﻿USE sofia;
DROP TABLE IF EXISTS sofia.sanguj_vpl;
CREATE TABLE sanguj_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sanguj_vpl WRITE;
INSERT INTO sanguj_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ઇબ્રાહીમઃ સન્તાનો દાયૂદ્ તસ્ય સન્તાનો યીશુખ્રીષ્ટસ્તસ્ય પૂર્વ્વપુરુષવંશશ્રેણી| ");
INSERT INTO sanguj_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","ઇબ્રાહીમઃ પુત્ર ઇસ્હાક્ તસ્ય પુત્રો યાકૂબ્ તસ્ય પુત્રો યિહૂદાસ્તસ્ય ભ્રાતરશ્ચ| ");
INSERT INTO sanguj_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","તસ્માદ્ યિહૂદાતસ્તામરો ગર્ભે પેરસ્સેરહૌ જજ્ઞાતે, તસ્ય પેરસઃ પુત્રો હિષ્રોણ્ તસ્ય પુત્રો ઽરામ્| ");
INSERT INTO sanguj_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","તસ્ય પુત્રો ઽમ્મીનાદબ્ તસ્ય પુત્રો નહશોન્ તસ્ય પુત્રઃ સલ્મોન્| ");
INSERT INTO sanguj_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","તસ્માદ્ રાહબો ગર્ભે બોયમ્ જજ્ઞે, તસ્માદ્ રૂતો ગર્ભે ઓબેદ્ જજ્ઞે, તસ્ય પુત્રો યિશયઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","તસ્ય પુત્રો દાયૂદ્ રાજઃ તસ્માદ્ મૃતોરિયસ્ય જાયાયાં સુલેમાન્ જજ્ઞે| ");
INSERT INTO sanguj_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","તસ્ય પુત્રો રિહબિયામ્, તસ્ય પુત્રોઽબિયઃ, તસ્ય પુત્ર આસા:| ");
INSERT INTO sanguj_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","તસ્ય સુતો યિહોશાફટ્ તસ્ય સુતો યિહોરામ તસ્ય સુત ઉષિયઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","તસ્ય સુતો યોથમ્ તસ્ય સુત આહમ્ તસ્ય સુતો હિષ્કિયઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","તસ્ય સુતો મિનશિઃ, તસ્ય સુત આમોન્ તસ્ય સુતો યોશિયઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","બાબિલ્નગરે પ્રવસનાત્ પૂર્વ્વં સ યોશિયો યિખનિયં તસ્ય ભ્રાતૃંશ્ચ જનયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","તતો બાબિલિ પ્રવસનકાલે યિખનિયઃ શલ્તીયેલં જનયામાસ, તસ્ય સુતઃ સિરુબ્બાવિલ્| ");
INSERT INTO sanguj_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","તસ્ય સુતો ઽબોહુદ્ તસ્ય સુત ઇલીયાકીમ્ તસ્ય સુતોઽસોર્| ");
INSERT INTO sanguj_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","અસોરઃ સુતઃ સાદોક્ તસ્ય સુત આખીમ્ તસ્ય સુત ઇલીહૂદ્| ");
INSERT INTO sanguj_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","તસ્ય સુત ઇલિયાસર્ તસ્ય સુતો મત્તન્| ");
INSERT INTO sanguj_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","તસ્ય સુતો યાકૂબ્ તસ્ય સુતો યૂષફ્ તસ્ય જાયા મરિયમ્; તસ્ય ગર્ભે યીશુરજનિ, તમેવ ખ્રીષ્ટમ્ (અર્થાદ્ અભિષિક્તં) વદન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ઇત્થમ્ ઇબ્રાહીમો દાયૂદં યાવત્ સાકલ્યેન ચતુર્દશપુરુષાઃ; આ દાયૂદઃ કાલાદ્ બાબિલિ પ્રવસનકાલં યાવત્ ચતુર્દશપુરુષા ભવન્તિ| બાબિલિ પ્રવાસનકાલાત્ ખ્રીષ્ટસ્ય કાલં યાવત્ ચતુર્દશપુરુષા ભવન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","યીશુખ્રીષ્ટસ્ય જન્મ કથ્થતે| મરિયમ્ નામિકા કન્યા યૂષફે વાગ્દત્તાસીત્, તદા તયોઃ સઙ્ગમાત્ પ્રાક્ સા કન્યા  પવિત્રેણાત્મના ગર્ભવતી બભૂવ| ");
INSERT INTO sanguj_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","તત્ર તસ્યાઃ પતિ ર્યૂષફ્ સૌજન્યાત્ તસ્યાઃ કલઙ્ગં પ્રકાશયિતુમ્ અનિચ્છન્ ગોપનેને તાં પારિત્યક્તું મનશ્ચક્રે| ");
INSERT INTO sanguj_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","સ તથૈવ ભાવયતિ, તદાનીં પરમેશ્વરસ્ય દૂતઃ સ્વપ્ને તં દર્શનં દત્ત્વા વ્યાજહાર, હે દાયૂદઃ સન્તાન યૂષફ્ ત્વં નિજાં જાયાં મરિયમમ્ આદાતું મા ભૈષીઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","યતસ્તસ્યા ગર્ભઃ પવિત્રાદાત્મનોઽભવત્, સા ચ પુત્રં પ્રસવિષ્યતે, તદા ત્વં તસ્ય નામ યીશુમ્ (અર્થાત્ ત્રાતારં) કરીષ્યસે, યસ્માત્ સ નિજમનુજાન્ તેષાં કલુષેભ્ય ઉદ્ધરિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ઇત્થં સતિ, પશ્ય ગર્ભવતી કન્યા તનયં પ્રસવિષ્યતે| ઇમ્માનૂયેલ્ તદીયઞ્ચ નામધેયં ભવિષ્યતિ|| ઇમ્માનૂયેલ્ અસ્માકં સઙ્ગીશ્વરઇત્યર્થઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","ઇતિ યદ્ વચનં પુર્વ્વં ભવિષ્યદ્વક્ત્રા ઈશ્વરઃ કથાયામાસ, તત્ તદાનીં સિદ્ધમભવત્| ");
INSERT INTO sanguj_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","અનન્તરં યૂષફ્ નિદ્રાતો જાગરિત ઉત્થાય પરમેશ્વરીયદૂતસ્ય નિદેશાનુસારેણ નિજાં જાયાં જગ્રાહ, ");
INSERT INTO sanguj_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","કિન્તુ યાવત્ સા નિજં પ્રથમસુતં અ સુષુવે, તાવત્ તાં નોપાગચ્છત્, તતઃ સુતસ્ય નામ યીશું ચક્રે| ");
INSERT INTO sanguj_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","અનન્તરં હેરોદ્ સંજ્ઞકે રાજ્ઞિ રાજ્યં શાસતિ યિહૂદીયદેશસ્ય બૈત્લેહમિ નગરે યીશૌ જાતવતિ ચ, કતિપયા જ્યોતિર્વ્વુદઃ પૂર્વ્વસ્યા દિશો યિરૂશાલમ્નગરં સમેત્ય કથયમાસુઃ, ");
INSERT INTO sanguj_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","યો યિહૂદીયાનાં રાજા જાતવાન્, સ કુત્રાસ્તે? વયં પૂર્વ્વસ્યાં દિશિ તિષ્ઠન્તસ્તદીયાં તારકામ્ અપશ્યામ તસ્માત્ તં પ્રણન્તુમ્ અाગમામ| ");
INSERT INTO sanguj_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","તદા હેરોદ્ રાજા કથામેતાં નિશમ્ય યિરૂશાલમ્નગરસ્થિતૈઃ સર્વ્વમાનવૈઃ સાર્દ્ધમ્ ઉદ્વિજ્ય ");
INSERT INTO sanguj_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","સર્વ્વાન્ પ્રધાનયાજકાન્ અધ્યાપકાંશ્ચ સમાહૂયાનીય પપ્રચ્છ, ખ્રીષ્ટઃ કુત્ર જનિષ્યતે? ");
INSERT INTO sanguj_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","તદા તે કથયામાસુઃ, યિહૂદીયદેશસ્ય બૈત્લેહમિ નગરે, યતો ભવિષ્યદ્વાદિના ઇત્થં લિખિતમાસ્તે, ");
INSERT INTO sanguj_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","સર્વ્વાભ્યો રાજધાનીભ્યો યિહૂદીયસ્ય નીવૃતઃ| હે યીહૂદીયદેશસ્યે બૈત્લેહમ્ ત્વં ન ચાવરા| ઇસ્રાયેલીયલોકાન્ મે યતો યઃ પાલયિષ્યતિ| તાદૃગેકો મહારાજસ્ત્વન્મધ્ય ઉદ્ભવિષ્યતી|| ");
INSERT INTO sanguj_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","તદાનીં હેરોદ્ રાજા તાન્ જ્યોતિર્વ્વિદો ગોપનમ્ આહૂય સા તારકા કદા દૃષ્ટાભવત્ , તદ્ વિનિશ્ચયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","અપરં તાન્ બૈત્લેહમં પ્રહીત્ય ગદિતવાન્, યૂયં યાત, યત્નાત્ તં શિશુમ્ અન્વિષ્ય તદુદ્દેશે પ્રાપ્તે મહ્યં વાર્ત્તાં દાસ્યથ, તતો મયાપિ ગત્વા સ પ્રણંસ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","તદાનીં રાજ્ઞ એતાદૃશીમ્ આજ્ઞાં પ્રાપ્ય તે પ્રતસ્થિરે, તતઃ પૂર્વ્વર્સ્યાં દિશિ સ્થિતૈસ્તૈ ર્યા તારકા દૃષ્ટા સા તારકા તેષામગ્રે ગત્વા યત્ર સ્થાને શિશૂરાસ્તે, તસ્ય સ્થાનસ્યોપરિ સ્થગિતા તસ્યૌ| ");
INSERT INTO sanguj_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","તદ્ દૃષ્ટ્વા તે મહાનન્દિતા બભૂવુઃ, ");
INSERT INTO sanguj_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","તતો ગેહમધ્ય પ્રવિશ્ય તસ્ય માત્રા મરિયમા સાદ્ધં તં શિશું નિરીક્ષય દણ્ડવદ્ ભૂત્વા પ્રણેમુઃ, અપરં સ્વેષાં ઘનસમ્પત્તિં મોચયિત્વા સુવર્ણં કુન્દુરું ગન્ધરમઞ્ચ તસ્મૈ દર્શનીયં દત્તવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","પશ્ચાદ્ હેરોદ્ રાજસ્ય સમીપં પુનરપિ ગન્તું સ્વપ્ન ઈશ્વરેણ નિષિદ્ધાઃ સન્તો ઽન્યેન પથા તે નિજદેશં પ્રતિ પ્રતસ્થિરે| ");
INSERT INTO sanguj_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","અનન્તરં તેષુ ગતવત્મુ પરમેશ્વરસ્ય દૂતો યૂષફે સ્વપ્ને દર્શનં દત્વા જગાદ, ત્વમ્ ઉત્થાય શિશું તન્માતરઞ્ચ ગૃહીત્વા મિસર્દેશં પલાયસ્વ, અપરં યાવદહં તુભ્યં વાર્ત્તાં ન કથયિષ્યામિ, તાવત્ તત્રૈવ નિવસ, યતો રાજા હેરોદ્ શિશું નાશયિતું મૃગયિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","તદાનીં યૂષફ્ ઉત્થાય રજન્યાં શિશું તન્માતરઞ્ચ ગૃહીત્વા મિસર્દેશં પ્રતિ પ્રતસ્થે, ");
INSERT INTO sanguj_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ગત્વા ચ હેરોદો નૃપતે ર્મરણપર્ય્યન્તં તત્ર દેશે ન્યુવાસ, તેન મિસર્દેશાદહં પુત્રં સ્વકીયં સમુપાહૂયમ્| યદેતદ્વચનમ્ ઈશ્વરેણ ભવિષ્યદ્વાદિના કથિતં તત્ સફલમભૂત્| ");
INSERT INTO sanguj_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","અનન્તરં હેરોદ્ જ્યોતિર્વિદ્ભિરાત્માનં પ્રવઞ્ચિતં વિજ્ઞાય ભૃશં ચુકોપ; અપરં જ્યોતિર્વ્વિદ્ભ્યસ્તેન વિનિશ્ચિતં યદ્ દિનં તદ્દિનાદ્ ગણયિત્વા દ્વિતીયવત્સરં પ્રવિષ્ટા યાવન્તો બાલકા અસ્મિન્ બૈત્લેહમ્નગરે તત્સીમમધ્યે ચાસન્, લોકાન્ પ્રહિત્ય તાન્ સર્વ્વાન્ ઘાતયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","અતઃ અનેકસ્ય વિલાપસ્ય નિનાદ: ક્રન્દનસ્ય ચ| શોકેન કૃતશબ્દશ્ચ રામાયાં સંનિશમ્યતે| સ્વબાલગણહેતોર્વૈ રાહેલ્ નારી તુ રોદિની| ન મન્યતે પ્રબોધન્તુ યતસ્તે નૈવ મન્તિ હિ|| ");
INSERT INTO sanguj_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","યદેતદ્ વચનં યિરીમિયનામકભવિષ્યદ્વાદિના કથિતં તત્ તદાનીં સફલમ્ અભૂત્| ");
INSERT INTO sanguj_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","તદનન્તરં હેરેદિ રાજનિ મૃતે પરમેશ્વરસ્ય દૂતો મિસર્દેશે સ્વપ્ને દર્શનં દત્ત્વા યૂષફે કથિતવાન્ ");
INSERT INTO sanguj_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ત્વમ્ ઉત્થાય શિશું તન્માતરઞ્ચ ગૃહીત્વા પુનરપીસ્રાયેલો દેશં યાહી, યે જનાઃ શિશું નાશયિતુમ્ અમૃગયન્ત, તે મૃતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","તદાનીં સ ઉત્થાય શિશું તન્માતરઞ્ચ ગૃહ્લન્ ઇસ્રાયેલ્દેશમ્ આજગામ| ");
INSERT INTO sanguj_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","કિન્તુ યિહૂદીયદેશે અર્ખિલાયનામ રાજકુમારો નિજપિતુ ર્હેરોદઃ પદં પ્રાપ્ય રાજત્વં કરોતીતિ નિશમ્ય તત્ સ્થાનં યાતું શઙ્કિતવાન્, પશ્ચાત્ સ્વપ્ન ઈશ્વરાત્ પ્રબોધં પ્રાપ્ય ગાલીલ્દેશસ્ય પ્રદેશૈકં પ્રસ્થાય નાસરન્નામ નગરં ગત્વા તત્ર ન્યુષિતવાન્, ");
INSERT INTO sanguj_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","તેન તં નાસરતીયં કથયિષ્યન્તિ, યદેતદ્વાક્યં ભવિષ્યદ્વાદિભિરુક્ત્તં તત્ સફલમભવત્| ");
INSERT INTO sanguj_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","તદાનોં યોહ્ન્નામા મજ્જયિતા યિહૂદીયદેશસ્ય પ્રાન્તરમ્ ઉપસ્થાય પ્રચારયન્ કથયામાસ, ");
INSERT INTO sanguj_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","મનાંસિ પરાવર્ત્તયત, સ્વર્ગીયરાજત્વં સમીપમાગતમ્| ");
INSERT INTO sanguj_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","પરમેશસ્ય પન્થાનં પરિષ્કુરુત સર્વ્વતઃ| તસ્ય રાજપથાંશ્ચૈવ સમીકુરુત સર્વ્વથા| ઇત્યેતત્ પ્રાન્તરે વાક્યં વદતઃ કસ્યચિદ્ રવઃ|| ");
INSERT INTO sanguj_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","એતદ્વચનં યિશયિયભવિષ્યદ્વાદિના યોહનમુદ્દિશ્ય ભાષિતમ્| યોહનો વસનં મહાઙ્ગરોમજં તસ્ય કટૌ ચર્મ્મકટિબન્ધનં; સ ચ શૂકકીટાન્ મધુ ચ ભુક્તવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","તદાનીં યિરૂશાલમ્નગરનિવાસિનઃ સર્વ્વે યિહૂદિદેશીયા યર્દ્દન્તટિન્યા ઉભયતટસ્થાશ્ચ માનવા બહિરાગત્ય તસ્ય સમીપે ");
INSERT INTO sanguj_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","સ્વીયં સ્વીયં દુરિતમ્ અઙ્ગીકૃત્ય તસ્યાં યર્દ્દનિ તેન મજ્જિતા બભૂવુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","અપરં બહૂન્ ફિરૂશિનઃ સિદૂકિનશ્ચ મનુજાન્ મંક્તું સ્વસમીપમ્ આગચ્છ્તો વિલોક્ય સ તાન્ અભિદધૌ, રે રે ભુજગવંશા આગામીનઃ કોપાત્ પલાયિતું યુષ્માન્ કશ્ચેતિતવાન્? ");
INSERT INTO sanguj_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","મનઃપરાવર્ત્તનસ્ય સમુચિતં ફલં ફલત| ");
INSERT INTO sanguj_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","કિન્ત્વસ્માકં તાત ઇબ્રાહીમ્ અસ્તીતિ સ્વેષુ મનઃસુ ચીન્તયન્તો મા વ્યાહરત| યતો યુષ્માન્ અહં વદામિ, ઈશ્વર એતેભ્યઃ પાષાણેભ્ય ઇબ્રાહીમઃ સન્તાનાન્ ઉત્પાદયિતું શક્નોતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","અપરં પાદપાનાં મૂલે કુઠાર ઇદાનીમપિ લગન્ આસ્તે, તસ્માદ્ યસ્મિન્ પાદપે ઉત્તમં ફલં ન ભવતિ, સ કૃત્તો મધ્યેઽગ્નિં નિક્ષેપ્સ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","અપરમ્ અહં મનઃપરાવર્ત્તનસૂચકેન મજ્જનેન યુષ્માન્ મજ્જયામીતિ સત્યં, કિન્તુ મમ પશ્ચાદ્ ય આગચ્છતિ, સ મત્તોપિ મહાન્, અહં તદીયોપાનહૌ વોઢુમપિ નહિ યોગ્યોસ્મિ, સ યુષ્માન્ વહ્નિરૂપે પવિત્ર આત્મનિ સંમજ્જયિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","તસ્ય કારે સૂર્પ આસ્તે, સ સ્વીયશસ્યાનિ સમ્યક્ પ્રસ્ફોટ્ય નિજાન્ સકલગોધૂમાન્ સંગૃહ્ય ભાણ્ડાગારે સ્થાપયિષ્યતિ, કિંન્તુ સર્વ્વાણિ વુષાણ્યનિર્વ્વાણવહ્નિના દાહયિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","અનન્તરં યીશુ ર્યોહના મજ્જિતો ભવિતું ગાલીલ્પ્રદેશાદ્ યર્દ્દનિ તસ્ય સમીપમ્ આજગામ| ");
INSERT INTO sanguj_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","કિન્તુ યોહન્ તં નિષિધ્ય બભાષે, ત્વં કિં મમ સમીપમ્ આગચ્છસિ? વરં ત્વયા મજ્જનં મમ પ્રયોજનમ્ આસ્તે| ");
INSERT INTO sanguj_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","તદાનીં યીશુઃ પ્રત્યવોચત્; ઈદાનીમ્ અનુમન્યસ્વ, યત ઇત્થં સર્વ્વધર્મ્મસાધનમ્ અસ્માકં કર્ત્તવ્યં, તતઃ સોઽન્વમન્યત| ");
INSERT INTO sanguj_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","અનન્તરં યીશુરમ્મસિ મજ્જિતુઃ સન્ તત્ક્ષણાત્ તોયમધ્યાદ્ ઉત્થાય જગામ, તદા જીમૂતદ્વારે મુક્તે જાતે, સ ઈશ્વરસ્યાત્માનં કપોતવદ્ અવરુહ્ય સ્વોપર્ય્યાગચ્છન્તં વીક્ષાઞ્ચક્રે| ");
INSERT INTO sanguj_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","અપરમ્ એષ મમ પ્રિયઃ પુત્ર એતસ્મિન્નેવ મમ મહાસન્તોષ એતાદૃશી વ્યોમજા વાગ્ બભૂવ| ");
INSERT INTO sanguj_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","તતઃ પરં યીશુઃ પ્રતારકેણ પરીક્ષિતો ભવિતુમ્ આત્મના પ્રાન્તરમ્ આકૃષ્ટઃ ");
INSERT INTO sanguj_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","સન્ ચત્વારિંશદહોરાત્રાન્ અનાહારસ્તિષ્ઠન્ ક્ષુધિતો બભૂવ| ");
INSERT INTO sanguj_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","તદાનીં પરીક્ષિતા તત્સમીપમ્ આગત્ય વ્યાહૃતવાન્, યદિ ત્વમીશ્વરાત્મજો ભવેસ્તર્હ્યાજ્ઞયા પાષાણાનેતાન્ પૂપાન્ વિધેહિ| ");
INSERT INTO sanguj_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","તતઃ સ પ્રત્યબ્રવીત્, ઇત્થં લિખિતમાસ્તે, \"મનુજઃ કેવલપૂપેન ન જીવિષ્યતિ, કિન્ત્વીશ્વરસ્ય વદનાદ્ યાનિ યાનિ વચાંસિ નિઃસરન્તિ તૈરેવ જીવિષ્યતિ| \" ");
INSERT INTO sanguj_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","તદા પ્રતારકસ્તં પુણ્યનગરં નીત્વા મન્દિરસ્ય ચૂડોપરિ નિધાય ગદિતવાન્, ");
INSERT INTO sanguj_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ત્વં યદિશ્વરસ્ય તનયો ભવેસ્તર્હીતોઽધઃ પત, યત ઇત્થં લિખિતમાસ્તે, આદેક્ષ્યતિ નિજાન્ દૂતાન્ રક્ષિતું ત્વાં પરમેશ્વરઃ| યથા સર્વ્વેષુ માર્ગેષુ ત્વદીયચરણદ્વયે| ન લગેત્ પ્રસ્તરાઘાતસ્ત્વાં ઘરિષ્યન્તિ તે કરૈઃ|| ");
INSERT INTO sanguj_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","તદાનીં યીશુસ્તસ્મૈ કથિતવાન્ એતદપિ લિખિતમાસ્તે, \"ત્વં નિજપ્રભું પરમેશ્વરં મા પરીક્ષસ્વ| \" ");
INSERT INTO sanguj_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","અનન્તરં પ્રતારકઃ પુનરપિ તમ્ અત્યુઞ્ચધરાધરોપરિ નીત્વા જગતઃ સકલરાજ્યાનિ તદૈશ્વર્ય્યાણિ ચ દર્શયાશ્ચકાર કથયાઞ્ચકાર ચ, ");
INSERT INTO sanguj_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","યદિ ત્વં દણ્ડવદ્ ભવન્ માં પ્રણમેસ્તર્હ્યહમ્ એતાનિ તુભ્યં પ્રદાસ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","તદાનીં યીશુસ્તમવોચત્, દૂરીભવ પ્રતારક, લિખિતમિદમ્ આસ્તે, \"ત્વયા નિજઃ પ્રભુઃ પરમેશ્વરઃ પ્રણમ્યઃ કેવલઃ સ સેવ્યશ્ચ| \" ");
INSERT INTO sanguj_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","તતઃ પ્રતારકેણ સ પર્ય્યત્યાજિ, તદા સ્વર્ગીયદૂતૈરાગત્ય સ સિષેવે| ");
INSERT INTO sanguj_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","તદનન્તરં યોહન્ કારાયાં બબન્ધે, તદ્વાર્ત્તાં નિશમ્ય યીશુના ગાલીલ્ પ્રાસ્થીયત| ");
INSERT INTO sanguj_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","તતઃ પરં સ નાસરન્નગરં વિહાય જલઘેસ્તટે સિબૂલૂન્નપ્તાલી એતયોરુવભયોઃ પ્રદેશયોઃ સીમ્નોર્મધ્યવર્ત્તી ય: કફર્નાહૂમ્ તન્નગરમ્ ઇત્વા ન્યવસત્| ");
INSERT INTO sanguj_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","તસ્માત્, અન્યાદેશીયગાલીલિ યર્દ્દન્પારેઽબ્ધિરોધસિ| નપ્તાલિસિબૂલૂન્દેશૌ યત્ર સ્થાને સ્થિતૌ પુરા| ");
INSERT INTO sanguj_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","તત્રત્યા મનુજા યે યે પર્ય્યભ્રામ્યન્ તમિસ્રકે| તૈર્જનૈર્બૃહદાલોકઃ પરિદર્શિષ્યતે તદા| અવસન્ યે જના દેશે મૃત્યુચ્છાયાસ્વરૂપકે| તેષામુપરિ લોકાનામાલોકઃ સંપ્રકાશિતઃ|| ");
INSERT INTO sanguj_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","યદેતદ્વચનં યિશયિયભવિષ્યદ્વાદિના પ્રોક્તં, તત્ તદા સફલમ્ અભૂત્| ");
INSERT INTO sanguj_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","અનન્તરં યીશુઃ સુસંવાદં પ્રચારયન્ એતાં કથાં કથયિતુમ્ આરેભે, મનાંસિ પરાવર્ત્તયત, સ્વર્ગીયરાજત્વં સવિધમભવત્| ");
INSERT INTO sanguj_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","તતઃ પરં યીશુ ર્ગાલીલો જલધેસ્તટેન ગચ્છન્ ગચ્છન્ આન્દ્રિયસ્તસ્ય ભ્રાતા શિમોન્ અર્થતો યં પિતરં વદન્તિ એતાવુભૌ જલઘૌ જાલં ક્ષિપન્તૌ દદર્શ, યતસ્તૌ મીનધારિણાવાસ્તામ્| ");
INSERT INTO sanguj_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","તદા સ તાવાહૂય વ્યાજહાર, યુવાં મમ પશ્ચાદ્ આગચ્છતં, યુવામહં મનુજધારિણૌ કરિષ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","તેનૈવ તૌ જાલં વિહાય તસ્ય પશ્ચાત્ આગચ્છતામ્| ");
INSERT INTO sanguj_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","અનન્તરં તસ્માત્ સ્થાનાત્ વ્રજન્ વ્રજન્ સિવદિયસ્ય સુતૌ યાકૂબ્ યોહન્નામાનૌ દ્વૌ સહજૌ તાતેન સાર્દ્ધં નૌકોપરિ જાલસ્ય જીર્ણોદ્ધારં કુર્વ્વન્તૌ વીક્ષ્ય તાવાહૂતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","તત્ક્ષણાત્ તૌ નાવં સ્વતાતઞ્ચ વિહાય તસ્ય પશ્ચાદ્ગામિનૌ બભૂવતુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","અનન્તરં ભજનભવને સમુપદિશન્ રાજ્યસ્ય સુસંવાદં પ્રચારયન્ મનુજાનાં સર્વ્વપ્રકારાન્ રોગાન્ સર્વ્વપ્રકારપીડાશ્ચ શમયન્ યીશુઃ કૃત્સ્નં ગાલીલ્દેશં ભ્રમિતુમ્ આરભત| ");
INSERT INTO sanguj_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","તેન કૃત્સ્નસુરિયાદેશસ્ય મધ્યં તસ્ય યશો વ્યાપ્નોત્, અપરં ભૂતગ્રસ્તા અપસ્મારર્ગીણઃ પક્ષાધાતિપ્રભૃતયશ્ચ યાવન્તો મનુજા નાનાવિધવ્યાધિભિઃ ક્લિષ્ટા આસન્, તેષુ સર્વ્વેષુ તસ્ય સમીપમ્ આનીતેષુ સ તાન્ સ્વસ્થાન્ ચકાર| ");
INSERT INTO sanguj_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","એતેન ગાલીલ્-દિકાપનિ-યિરૂશાલમ્-યિહૂદીયદેશેભ્યો યર્દ્દનઃ પારાઞ્ચ બહવો મનુજાસ્તસ્ય પશ્ચાદ્ આગચ્છન્| ");
INSERT INTO sanguj_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","અનન્તરં સ જનનિવહં નિરીક્ષ્ય ભૂધરોપરિ વ્રજિત્વા સમુપવિવેશ| ");
INSERT INTO sanguj_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","તદાનીં શિષ્યેષુ તસ્ય સમીપમાગતેષુ તેન તેભ્ય એષા કથા કથ્યાઞ્ચક્રે| ");
INSERT INTO sanguj_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","અભિમાનહીના જના ધન્યાઃ, યતસ્તે સ્વર્ગીયરાજ્યમ્ અધિકરિષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ખિદ્યમાના મનુજા ધન્યાઃ, યસ્માત્ તે સાન્ત્વનાં પ્રાપ્સન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","નમ્રા માનવાશ્ચ ધન્યાઃ, યસ્માત્ તે મેદિનીમ્ અધિકરિષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ધર્મ્માય બુભુક્ષિતાઃ તૃષાર્ત્તાશ્ચ મનુજા ધન્યાઃ, યસ્માત્ તે પરિતર્પ્સ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","કૃપાલવો માનવા ધન્યાઃ, યસ્માત્ તે કૃપાં પ્રાપ્સ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","નિર્મ્મલહૃદયા મનુજાશ્ચ ધન્યાઃ, યસ્માત્ ત ઈશ્ચરં દ્રક્ષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","મેલયિતારો માનવા ધન્યાઃ, યસ્માત્ ત ઈશ્ચરસ્ય સન્તાનત્વેન વિખ્યાસ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ધર્મ્મકારણાત્ તાડિતા મનુજા ધન્યા, યસ્માત્ સ્વર્ગીયરાજ્યે તેષામધિકરો વિદ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","યદા મનુજા મમ નામકૃતે યુષ્માન્ નિન્દન્તિ તાડયન્તિ મૃષા નાનાદુર્વ્વાક્યાનિ વદન્તિ ચ, તદા યુયં ધન્યાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","તદા આનન્દત, તથા ભૃશં હ્લાદધ્વઞ્ચ, યતઃ સ્વર્ગે ભૂયાંસિ ફલાનિ લપ્સ્યધ્વે; તે યુષ્માકં પુરાતનાન્ ભવિષ્યદ્વાદિનોઽપિ તાદૃગ્ અતાડયન્| ");
INSERT INTO sanguj_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","યુયં મેદિન્યાં લવણરૂપાઃ, કિન્તુ યદિ લવણસ્ય લવણત્વમ્ અપયાતિ, તર્હિ તત્ કેન પ્રકારેણ સ્વાદુયુક્તં ભવિષ્યતિ? તત્ કસ્યાપિ કાર્ય્યસ્યાયોગ્યત્વાત્ કેવલં બહિઃ પ્રક્ષેપ્તું નરાણાં પદતલેન દલયિતુઞ્ચ યોગ્યં ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","યૂયં જગતિ દીપ્તિરૂપાઃ, ભૂધરોપરિ સ્થિતં નગરં ગુપ્તં ભવિતું નહિ શક્ષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","અપરં મનુજાઃ પ્રદીપાન્ પ્રજ્વાલ્ય દ્રોણાધો ન સ્થાપયન્તિ, કિન્તુ દીપાધારોપર્ય્યેવ સ્થાપયન્તિ, તેન તે દીપા ગેહસ્થિતાન્ સકલાન્ પ્રકાશયન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","યેન માનવા યુષ્માકં સત્કર્મ્માણિ વિલોક્ય યુષ્માકં સ્વર્ગસ્થં પિતરં ધન્યં વદન્તિ, તેષાં સમક્ષં યુષ્માકં દીપ્તિસ્તાદૃક્ પ્રકાશતામ્| ");
INSERT INTO sanguj_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","અહં વ્યવસ્થાં ભવિષ્યદ્વાક્યઞ્ચ લોપ્તુમ્ આગતવાન્, ઇત્થં માનુભવત, તે દ્વે લોપ્તું નાગતવાન્, કિન્તુ સફલે કર્ત્તુમ્ આગતોસ્મિ| ");
INSERT INTO sanguj_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","અપરં યુષ્માન્ અહં તથ્યં વદામિ યાવત્ વ્યોમમેદિન્યો ર્ધ્વંસો ન ભવિષ્યતિ, તાવત્ સર્વ્વસ્મિન્ સફલે ન જાતે વ્યવસ્થાયા એકા માત્રા બિન્દુરેકોપિ વા ન લોપ્સ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","તસ્માત્ યો જન એતાસામ્ આજ્ઞાનામ્ અતિક્ષુદ્રામ્ એકાજ્ઞામપી લંઘતે મનુજાંઞ્ચ તથૈવ શિક્ષયતિ, સ સ્વર્ગીયરાજ્યે સર્વ્વેભ્યઃ ક્ષુદ્રત્વેન વિખ્યાસ્યતે, કિન્તુ યો જનસ્તાં પાલયતિ, તથૈવ શિક્ષયતિ ચ, સ સ્વર્ગીયરાજ્યે પ્રધાનત્વેન વિખ્યાસ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","અપરં યુષ્માન્ અહં વદામિ, અધ્યાપકફિરૂશિમાનવાનાં ધર્મ્માનુષ્ઠાનાત્ યુષ્માકં ધર્મ્માનુષ્ઠાને નોત્તમે જાતે યૂયમ્ ઈશ્વરીયરાજ્યં પ્રવેષ્ટું ન શક્ષ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","અપરઞ્ચ ત્વં નરં મા વધીઃ, યસ્માત્ યો નરં હન્તિ, સ વિચારસભાયાં દણ્ડાર્હો ભવિષ્યતિ, પૂર્વ્વકાલીનજનેભ્ય ઇતિ કથિતમાસીત્, યુષ્માભિરશ્રાવિ| ");
INSERT INTO sanguj_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","કિન્ત્વહં યુષ્માન્ વદામિ, યઃ કશ્ચિત્ કારણં વિના નિજભ્રાત્રે કુપ્યતિ, સ વિચારસભાયાં દણ્ડાર્હો ભવિષ્યતિ; યઃ કશ્ચિચ્ચ સ્વીયસહજં નિર્બ્બોધં વદતિ, સ મહાસભાયાં દણ્ડાર્હો ભવિષ્યતિ; પુનશ્ચ ત્વં મૂઢ ઇતિ વાક્યં યદિ કશ્ચિત્ સ્વીયભ્રાતરં વક્તિ, તર્હિ નરકાગ્નૌ સ દણ્ડાર્હો ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","અતો વેદ્યાઃ સમીપં નિજનૈવેદ્યે સમાનીતેઽપિ નિજભ્રાતરં પ્રતિ કસ્માચ્ચિત્ કારણાત્ ત્વં યદિ દોષી વિદ્યસે, તદાનીં તવ તસ્ય સ્મૃતિ ર્જાયતે ચ, ");
INSERT INTO sanguj_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","તર્હિ તસ્યા વેદ્યાઃ સમીપે નિજનૈવૈદ્યં નિધાય તદૈવ ગત્વા પૂર્વ્વં તેન સાર્દ્ધં મિલ, પશ્ચાત્ આગત્ય નિજનૈવેદ્યં નિવેદય| ");
INSERT INTO sanguj_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","અન્યઞ્ચ યાવત્ વિવાદિના સાર્દ્ધં વર્ત્મનિ તિષ્ઠસિ, તાવત્ તેન સાર્દ્ધં મેલનં કુરુ; નો ચેત્ વિવાદી વિચારયિતુઃ સમીપે ત્વાં સમર્પયતિ વિચારયિતા ચ રક્ષિણઃ સન્નિધૌ સમર્પયતિ તદા ત્વં કારાયાં બધ્યેથાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","તર્હિ ત્વામહં તથ્થં બ્રવીમિ, શેષકપર્દકેઽપિ ન પરિશોધિતે તસ્માત્ સ્થાનાત્ કદાપિ બહિરાગન્તું ન શક્ષ્યસિ| ");
INSERT INTO sanguj_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","અપરં ત્વં મા વ્યભિચર, યદેતદ્ વચનં પૂર્વ્વકાલીનલોકેભ્યઃ કથિતમાસીત્, તદ્ યૂયં શ્રુતવન્તઃ; ");
INSERT INTO sanguj_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","કિન્ત્વહં યુષ્માન્ વદામિ, યદિ કશ્ચિત્ કામતઃ કાઞ્ચન યોષિતં પશ્યતિ, તર્હિ સ મનસા તદૈવ વ્યભિચરિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","તસ્માત્ તવ દક્ષિણં નેત્રં યદિ ત્વાં બાધતે, તર્હિ તન્નેત્રમ્ ઉત્પાટ્ય દૂરે નિક્ષિપ, યસ્માત્ તવ સર્વ્વવપુષો નરકે નિક્ષેપાત્ તવૈકાઙ્ગસ્ય નાશો વરં| ");
INSERT INTO sanguj_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","યદ્વા તવ દક્ષિણઃ કરો યદિ ત્વાં બાધતે, તર્હિ તં કરં છિત્ત્વા દૂરે નિક્ષિપ, યતઃ સર્વ્વવપુષો નરકે નિક્ષેપાત્ એકાઙ્ગસ્ય નાશો વરં| ");
INSERT INTO sanguj_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","ઉક્તમાસ્તે, યદિ કશ્ચિન્ નિજજાયાં પરિત્યક્ત્તુમ્ ઇચ્છતિ, તર્હિ સ તસ્યૈ ત્યાગપત્રં દદાતુ| ");
INSERT INTO sanguj_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","કિન્ત્વહં યુષ્માન્ વ્યાહરામિ, વ્યભિચારદોષે ન જાતે યદિ કશ્ચિન્ નિજજાયાં પરિત્યજતિ, તર્હિ સ તાં વ્યભિચારયતિ; યશ્ચ તાં ત્યક્તાં સ્ત્રિયં વિવહતિ, સોપિ વ્યભિચરતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","પુનશ્ચ ત્વં મૃષા શપથમ્ ન કુર્વ્વન્ ઈશ્ચરાય નિજશપથં પાલય, પૂર્વ્વકાલીનલોકેભ્યો યૈષા કથા કથિતા, તામપિ યૂયં શ્રુતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","કિન્ત્વહં યુષ્માન્ વદામિ, કમપિ શપથં મા કાર્ષ્ટ, અર્થતઃ સ્વર્ગનામ્ના ન, યતઃ સ ઈશ્વરસ્ય સિંહાસનં; ");
INSERT INTO sanguj_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","પૃથિવ્યા નામ્નાપિ ન, યતઃ સા તસ્ય પાદપીઠં; યિરૂશાલમો નામ્નાપિ ન, યતઃ સા મહારાજસ્ય પુરી; ");
INSERT INTO sanguj_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","નિજશિરોનામ્નાપિ ન, યસ્માત્ તસ્યૈકં કચમપિ સિતમ્ અસિતં વા કર્ત્તું ત્વયા ન શક્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","અપરં યૂયં સંલાપસમયે કેવલં ભવતીતિ ન ભવતીતિ ચ વદત યત ઇતોઽધિકં યત્ તત્ પાપાત્મનો જાયતે| ");
INSERT INTO sanguj_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","અપરં લોચનસ્ય વિનિમયેન લોચનં દન્તસ્ય વિનિમયેન દન્તઃ પૂર્વ્વક્તમિદં વચનઞ્ચ યુષ્માભિરશ્રૂયત| ");
INSERT INTO sanguj_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","કિન્ત્વહં યુષ્માન્ વદામિ યૂયં હિંસકં નરં મા વ્યાઘાતયત| કિન્તુ કેનચિત્ તવ દક્ષિણકપોલે ચપેટાઘાતે કૃતે તં પ્રતિ વામં કપોલઞ્ચ વ્યાઘોટય| ");
INSERT INTO sanguj_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","અપરં કેનચિત્ ત્વયા સાર્ધ્દં વિવાદં કૃત્વા તવ પરિધેયવસને જિઘૃતિતે તસ્માયુત્તરીયવસનમપિ દેહિ| ");
INSERT INTO sanguj_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","યદિ કશ્ચિત્ ત્વાં ક્રોશમેકં નયનાર્થં અન્યાયતો ધરતિ, તદા તેન સાર્ધ્દં ક્રોશદ્વયં યાહિ| ");
INSERT INTO sanguj_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","યશ્ચ માનવસ્ત્વાં યાચતે, તસ્મૈ દેહિ, યદિ કશ્ચિત્ તુભ્યં ધારયિતુમ્ ઇચ્છતિ, તર્હિ તં પ્રતિ પરાંમુખો મા ભૂઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","નિજસમીપવસિનિ પ્રેમ કુરુ, કિન્તુ શત્રું પ્રતિ દ્વેષં કુરુ, યદેતત્ પુરોક્તં વચનં એતદપિ યૂયં શ્રુતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","કિન્ત્વહં યુષ્માન્ વદામિ, યૂયં રિપુવ્વપિ પ્રેમ કુરુત, યે ચ યુષ્માન્ શપન્તે, તાન, આશિષં વદત, યે ચ યુષ્માન્ ઋृતીયન્તે, તેષાં મઙ્ગલં કુરુત, યે ચ યુષ્માન્ નિન્દન્તિ, તાડયન્તિ ચ, તેષાં કૃતે પ્રાર્થયધ્વં| ");
INSERT INTO sanguj_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","તત્ર યઃ સતામસતાઞ્ચોપરિ પ્રભાકરમ્ ઉદાયયતિ, તથા ધાર્મ્મિકાનામધાર્મ્મિકાનાઞ્ચોપરિ નીરં વર્ષયતિ તાદૃશો યો યુષ્માકં સ્વર્ગસ્થઃ પિતા, યૂયં તસ્યૈવ સન્તાના ભવિષ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","યે યુષ્માસુ પ્રેમ કુર્વ્વન્તિ, યૂયં યદિ કેવલં તેવ્વેવ પ્રેમ કુરુથ, તર્હિ યુષ્માકં કિં ફલં ભવિષ્યતિ? ચણ્ડાલા અપિ તાદૃશં કિં ન કુર્વ્વન્તિ? ");
INSERT INTO sanguj_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","અપરં યૂયં યદિ કેવલં સ્વીયભ્રાતૃત્વેન નમત, તર્હિ કિં મહત્ કર્મ્મ કુરુથ? ચણ્ડાલા અપિ તાદૃશં કિં ન કુર્વ્વન્તિ? ");
INSERT INTO sanguj_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","તસ્માત્ યુષ્માકં સ્વર્ગસ્થઃ પિતા યથા પૂર્ણો ભવતિ, યૂયમપિ તાદૃશા ભવત| ");
INSERT INTO sanguj_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","સાવધાના ભવત, મનુજાન્ દર્શયિતું તેષાં ગોચરે ધર્મ્મકર્મ્મ મા કુરુત, તથા કૃતે યુષ્માકં સ્વર્ગસ્થપિતુઃ સકાશાત્ કિઞ્ચન ફલં ન પ્રાપ્સ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","ત્વં યદા દદાસિ તદા કપટિનો જના યથા મનુજેભ્યઃ પ્રશંસાં પ્રાપ્તું ભજનભવને રાજમાર્ગે ચ તૂરીં વાદયન્તિ, તથા મા કુરિु, અહં તુભ્યં યથાર્થં કથયામિ, તે સ્વકાયં ફલમ્ અલભન્ત| ");
INSERT INTO sanguj_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","કિન્તુ ત્વં યદા દદાસિ, તદા નિજદક્ષિણકરો યત્ કરોતિ, તદ્ વામકરં મા જ્ઞાપય| ");
INSERT INTO sanguj_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","તેન તવ દાનં ગુપ્તં ભવિષ્યતિ યસ્તુ તવ પિતા ગુપ્તદર્શી, સ પ્રકાશ્ય તુભ્યં ફલં દાસ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","અપરં યદા પ્રાર્થયસે, તદા કપટિનઇવ મા કુરુ, યસ્માત્ તે ભજનભવને રાજમાર્ગસ્ય કોણે તિષ્ઠન્તો લોકાન્ દર્શયન્તઃ પ્રાર્થયિતું પ્રીયન્તે; અહં યુષ્માન્ તથ્યં વદામિ, તે સ્વકીયફલં પ્રાપ્નુવન્| ");
INSERT INTO sanguj_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","તસ્માત્ પ્રાર્થનાકાલે અન્તરાગારં પ્રવિશ્ય દ્વારં રુદ્વ્વા ગુપ્તં પશ્યતસ્તવ પિતુઃ સમીપે પ્રાર્થયસ્વ; તેન તવ યઃ પિતા ગુપ્તદર્શી, સ પ્રકાશ્ય તુભ્યં ફલં દાસ્યતિl ");
INSERT INTO sanguj_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","અપરં પ્રાર્થનાકાલે દેવપૂજકાઇવ મુધા પુનરુક્તિં મા કુરુ, યસ્માત્ તે બોધન્તે, બહુવારં કથાયાં કથિતાયાં તેષાં પ્રાર્થના ગ્રાહિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","યૂયં તેષામિવ મા કુરુત, યસ્માત્ યુષ્માકં યદ્ યત્ પ્રયોજનં યાચનાતઃ પ્રાગેવ યુષ્માકં પિતા તત્ જાનાતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","અતએવ યૂયમ ઈદૃક્ પ્રાર્થયધ્વં, હે અસ્માકં સ્વર્ગસ્થપિતઃ, તવ નામ પૂજ્યં ભવતુ| ");
INSERT INTO sanguj_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","તવ રાજત્વં ભવતુ; તવેચ્છા સ્વર્ગે યથા તથૈવ મેદિન્યામપિ સફલા ભવતુ| ");
INSERT INTO sanguj_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","અસ્માકં પ્રયોજનીયમ્ આહારમ્ અદ્ય દેહિ| ");
INSERT INTO sanguj_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","વયં યથા નિજાપરાધિનઃ ક્ષમામહે, તથૈવાસ્માકમ્ અપરાધાન્ ક્ષમસ્વ| ");
INSERT INTO sanguj_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","અસ્માન્ પરીક્ષાં માનય, કિન્તુ પાપાત્મનો રક્ષ; રાજત્વં ગૌરવં પરાક્રમઃ એતે સર્વ્વે સર્વ્વદા તવ; તથાસ્તુ| ");
INSERT INTO sanguj_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","યદિ યૂયમ્ અન્યેષામ્ અપરાધાન્ ક્ષમધ્વે તર્હિ યુષ્માકં સ્વર્ગસ્થપિતાપિ યુષ્માન્ ક્ષમિષ્યતે; ");
INSERT INTO sanguj_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","કિન્તુ યદિ યૂયમ્ અન્યેષામ્ અપરાધાન્ ન ક્ષમધ્વે, તર્હિ યુષ્માકં જનકોપિ યુષ્માકમ્ અપરાધાન્ ન ક્ષમિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","અપરમ્ ઉપવાસકાલે કપટિનો જના માનુષાન્ ઉપવાસં જ્ઞાપયિતું સ્વેષાં વદનાનિ મ્લાનાનિ કુર્વ્વન્તિ, યૂયં તઇવ વિષણવદના મા ભવત; અહં યુષ્માન્ તથ્યં વદામિ તે સ્વકીયફલમ્ અલભન્ત| ");
INSERT INTO sanguj_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","યદા ત્વમ્ ઉપવસસિ, તદા યથા લોકૈસ્ત્વં ઉપવાસીવ ન દૃશ્યસે, કિન્તુ તવ યોઽગોચરઃ પિતા તેનૈવ દૃશ્યસે, તત્કૃતે નિજશિરસિ તૈલં મર્દ્દય વદનઞ્ચ પ્રક્ષાલય; ");
INSERT INTO sanguj_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","તેન તવ યઃ પિતા ગુપ્તદર્શી સ પ્રકાશ્ય તુભ્યં ફલં દાસ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","અપરં યત્ર સ્થાને કીટાઃ કલઙ્કાશ્ચ ક્ષયં નયન્તિ, ચૌરાશ્ચ સન્ધિં કર્ત્તયિત્વા ચોરયિતું શક્નુવન્તિ, તાદૃશ્યાં મેદિન્યાં સ્વાર્થં ધનં મા સંચિનુત| ");
INSERT INTO sanguj_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","કિન્તુ યત્ર સ્થાને કીટાઃ કલઙ્કાશ્ચ ક્ષયં ન નયન્તિ, ચૌરાશ્ચ સન્ધિં કર્ત્તયિત્વા ચોરયિતું ન શક્નુવન્તિ, તાદૃશે સ્વર્ગે ધનં સઞ્ચિનુત| ");
INSERT INTO sanguj_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","યસ્માત્ યત્ર સ્થાને યુષ્માંક ધનં તત્રૈવ ખાને યુષ્માકં મનાંસિ| ");
INSERT INTO sanguj_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","લોચનં દેહસ્ય પ્રદીપકં, તસ્માત્ યદિ તવ લોચનં પ્રસન્નં ભવતિ, તર્હિ તવ કૃત્સ્નં વપુ ર્દીપ્તિયુક્તં ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","કિન્તુ લોચનેઽપ્રસન્ને તવ કૃત્સ્નં વપુઃ તમિસ્રયુક્તં ભવિષ્યતિ| અતએવ યા દીપ્તિસ્ત્વયિ વિદ્યતે, સા યદિ તમિસ્રયુક્તા ભવતિ, તર્હિ તત્ તમિસ્રં કિયન્ મહત્| ");
INSERT INTO sanguj_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","કોપિ મનુજો દ્વૌ પ્રભૂ સેવિતું ન શક્નોતિ, યસ્માદ્ એકં સંમન્ય તદન્યં ન સમ્મન્યતે, યદ્વા એકત્ર મનો નિધાય તદન્યમ્ અવમન્યતે; તથા યૂયમપીશ્વરં લક્ષ્મીઞ્ચેત્યુભે સેવિતું ન શક્નુથ| ");
INSERT INTO sanguj_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","અપરમ્ અહં યુષ્મભ્યં તથ્યં કથયામિ, કિં ભક્ષિષ્યામઃ? કિં પાસ્યામઃ? ઇતિ પ્રાણધારણાય મા ચિન્તયત; કિં પરિધાસ્યામઃ? ઇતિ કાયરક્ષણાય ન ચિન્તયત; ભક્ષ્યાત્ પ્રાણા વસનાઞ્ચ વપૂંષિ કિં શ્રેષ્ઠાણિ ન હિ? ");
INSERT INTO sanguj_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","વિહાયસો વિહઙ્ગમાન્ વિલોકયત; તૈ ર્નોપ્યતે ન કૃત્યતે ભાણ્ડાગારે ન સઞ્ચીયતેઽપિ; તથાપિ યુષ્માકં સ્વર્ગસ્થઃ પિતા તેભ્ય આહારં વિતરતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","યૂયં તેભ્યઃ કિં શ્રેષ્ઠા ન ભવથ? યુષ્માકં કશ્ચિત્ મનુજઃ ચિન્તયન્ નિજાયુષઃ ક્ષણમપિ વર્દ્ધયિતું શક્નોતિ? ");
INSERT INTO sanguj_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","અપરં વસનાય કુતશ્ચિન્તયત? ક્ષેત્રોત્પન્નાનિ પુષ્પાણિ કથં વર્દ્ધન્તે તદાલોચયત| તાનિ તન્તૂન્ નોત્પાદયન્તિ કિમપિ કાર્ય્યં ન કુર્વ્વન્તિ; ");
INSERT INTO sanguj_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","તથાપ્યહં યુષ્માન્ વદામિ, સુલેમાન્ તાદૃગ્ ઐશ્વર્ય્યવાનપિ તત્પુષ્પમિવ વિભૂષિતો નાસીત્| ");
INSERT INTO sanguj_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","તસ્માત્ ક્ષદ્ય વિદ્યમાનં શ્ચઃ ચુલ્લ્યાં નિક્ષેપ્સ્યતે તાદૃશં યત્ ક્ષેત્રસ્થિતં કુસુમં તત્ યદીશ્ચર ઇત્થં બિભૂષયતિ, તર્હિ હે સ્તોકપ્રત્યયિનો યુષ્માન્ કિં ન પરિધાપયિષ્યતિ? ");
INSERT INTO sanguj_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","તસ્માત્ અસ્માભિઃ કિમત્સ્યતે? કિઞ્ચ પાયિષ્યતે? કિં વા પરિધાયિષ્યતે, ઇતિ ન ચિન્તયત| ");
INSERT INTO sanguj_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","યસ્માત્ દેવાર્ચ્ચકા અપીતિ ચેષ્ટન્તે; એતેષુ દ્રવ્યેષુ પ્રયોજનમસ્તીતિ યુષ્માકં સ્વર્ગસ્થઃ પિતા જાનાતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","અતએવ પ્રથમત ઈશ્વરીયરાજ્યં ધર્મ્મઞ્ચ ચેષ્ટધ્વં, તત એતાનિ વસ્તૂનિ યુષ્મભ્યં પ્રદાયિષ્યન્તે| ");
INSERT INTO sanguj_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","શ્વઃ કૃતે મા ચિન્તયત, શ્વએવ સ્વયં સ્વમુદ્દિશ્ય ચિન્તયિષ્યતિ; અદ્યતની યા ચિન્તા સાદ્યકૃતે પ્રચુરતરા| ");
INSERT INTO sanguj_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","યથા યૂયં દોષીકૃતા ન ભવથ, તત્કૃતેઽન્યં દોષિણં મા કુરુત| ");
INSERT INTO sanguj_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","યતો યાદૃશેન દોષેણ યૂયં પરાન્ દોષિણઃ કુરુથ, તાદૃશેન દોષેણ યૂયમપિ દોષીકૃતા ભવિષ્યથ, અન્યઞ્ચ યેન પરિમાણેન યુષ્માભિઃ પરિમીયતે, તેનૈવ પરિમાણેન યુષ્મત્કૃતે પરિમાયિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","અપરઞ્ચ નિજનયને યા નાસા વિદ્યતે, તામ્ અનાલોચ્ય તવ સહજસ્ય લોચને યત્ તૃણમ્ આસ્તે, તદેવ કુતો વીક્ષસે? ");
INSERT INTO sanguj_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","તવ નિજલોચને નાસાયાં વિદ્યમાનાયાં, હે ભ્રાતઃ, તવ નયનાત્ તૃણં બહિષ્યર્તું અનુજાનીહિ, કથામેતાં નિજસહજાય કથં કથયિતું શક્નોષિ? ");
INSERT INTO sanguj_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","હે કપટિન્, આદૌ નિજનયનાત્ નાસાં બહિષ્કુરુ તતો નિજદૃષ્ટૌ સુપ્રસન્નાયાં તવ ભ્રાતૃ ર્લોચનાત્ તૃણં બહિષ્કર્તું શક્ષ્યસિ| ");
INSERT INTO sanguj_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","અન્યઞ્ચ સારમેયેભ્યઃ પવિત્રવસ્તૂનિ મા વિતરત, વરાહાણાં સમક્ષઞ્ચ મુક્તા મા નિક્ષિપત; નિક્ષેપણાત્ તે તાઃ સર્વ્વાઃ પદૈ ર્દલયિષ્યન્તિ, પરાવૃત્ય યુષ્માનપિ વિદારયિષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","યાચધ્વં તતો યુષ્મભ્યં દાયિષ્યતે; મૃગયધ્વં તત ઉદ્દેશં લપ્સ્યધ્વે; દ્વારમ્ આહત, તતો યુષ્મત્કૃતે મુક્તં ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","યસ્માદ્ યેન યાચ્યતે, તેન લભ્યતે; યેન મૃગ્યતે તેનોદ્દેશઃ પ્રાપ્યતે; યેન ચ દ્વારમ્ આહન્યતે, તત્કૃતે દ્વારં મોચ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","આત્મજેન પૂપે પ્રાર્થિતે તસ્મૈ પાષાણં વિશ્રાણયતિ, ");
INSERT INTO sanguj_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","મીને યાચિતે ચ તસ્મૈ ભુજગં વિતરતિ, એતાદૃશઃ પિતા યુષ્માકં મધ્યે ક આસ્તે? ");
INSERT INTO sanguj_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","તસ્માદ્ યૂયમ્ અભદ્રાઃ સન્તોઽપિ યદિ નિજબાલકેભ્ય ઉત્તમં દ્રવ્યં દાતું જાનીથ, તર્હિ યુષ્માકં સ્વર્ગસ્થઃ પિતા સ્વીયયાચકેભ્યઃ કિમુત્તમાનિ વસ્તૂનિ ન દાસ્યતિ? ");
INSERT INTO sanguj_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","યૂષ્માન્ પ્રતીતરેષાં યાદૃશો વ્યવહારો યુષ્માકં પ્રિયઃ, યૂયં તાન્ પ્રતિ તાદૃશાનેવ વ્યવહારાન્ વિધત્ત; યસ્માદ્ વ્યવસ્થાભવિષ્યદ્વાદિનાં વચનાનામ્ ઇતિ સારમ્| ");
INSERT INTO sanguj_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","સઙ્કીર્ણદ્વારેણ પ્રવિશત; યતો નરકગમનાય યદ્ દ્વારં તદ્ વિસ્તીર્ણં યચ્ચ વર્ત્મ તદ્ બૃહત્ તેન બહવઃ પ્રવિશન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","અપરં સ્વર્ગગમનાય યદ્ દ્વારં તત્ કીદૃક્ સંકીર્ણં| યચ્ચ વર્ત્મ તત્ કીદૃગ્ દુર્ગમમ્| તદુદ્દેષ્ટારઃ કિયન્તોઽલ્પાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","અપરઞ્ચ યે જના મેષવેશેન યુષ્માકં સમીપમ્ આગચ્છન્તિ, કિન્ત્વન્તર્દુરન્તા વૃકા એતાદૃશેભ્યો ભવિષ્યદ્વાદિભ્યઃ સાવધાના ભવત, યૂયં ફલેન તાન્ પરિચેતું શક્નુથ| ");
INSERT INTO sanguj_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","મનુજાઃ કિં કણ્ટકિનો વૃક્ષાદ્ દ્રાક્ષાફલાનિ શૃગાલકોલિતશ્ચ ઉડુમ્બરફલાનિ શાતયન્તિ? ");
INSERT INTO sanguj_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","તદ્વદ્ ઉત્તમ એવ પાદપ ઉત્તમફલાનિ જનયતિ, અધમપાદપએવાધમફલાનિ જનયતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","કિન્તૂત્તમપાદપઃ કદાપ્યધમફલાનિ જનયિતું ન શક્નોતિ, તથાધમોપિ પાદપ ઉત્તમફલાનિ જનયિતું ન શક્નોતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","અપરં યે યે પાદપા અધમફલાનિ જનયન્તિ, તે કૃત્તા વહ્નૌ ક્ષિપ્યન્તે| ");
INSERT INTO sanguj_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","અતએવ યૂયં ફલેન તાન્ પરિચેષ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","યે જના માં પ્રભું વદન્તિ, તે સર્વ્વે સ્વર્ગરાજ્યં પ્રવેક્ષ્યન્તિ તન્ન, કિન્તુ યો માનવો મમ સ્વર્ગસ્થસ્ય પિતુરિષ્ટં કર્મ્મ કરોતિ સ એવ પ્રવેક્ષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","તદ્ દિને બહવો માં વદિષ્યન્તિ, હે પ્રભો હે પ્રભો, તવ નામ્ના કિમસ્મામિ ર્ભવિષ્યદ્વાક્યં ન વ્યાહૃતં? તવ નામ્ના ભૂતાઃ કિં ન ત્યાજિતાઃ? તવ નામ્ના કિં નાનાદ્ભુતાનિ કર્મ્માણિ ન કૃતાનિ? ");
INSERT INTO sanguj_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","તદાહં વદિષ્યામિ, હે કુકર્મ્મકારિણો યુષ્માન્ અહં ન વેદ્મિ, યૂયં મત્સમીપાદ્ દૂરીભવત| ");
INSERT INTO sanguj_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","યઃ કશ્ચિત્ મમૈતાઃ કથાઃ શ્રુત્વા પાલયતિ, સ પાષાણોપરિ ગૃહનિર્મ્માત્રા જ્ઞાનિના સહ મયોપમીયતે| ");
INSERT INTO sanguj_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","યતો વૃષ્ટૌ સત્યામ્ આપ્લાવ આગતે વાયૌ વાતે ચ તેષુ તદ્ગેહં લગ્નેષુ પાષાણોપરિ તસ્ય ભિત્તેસ્તન્ન પતતિl ");
INSERT INTO sanguj_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","કિન્તુ યઃ કશ્ચિત્ મમૈતાઃ કથાઃ શ્રુત્વા ન પાલયતિ સ સૈકતે ગેહનિર્મ્માત્રા ઽજ્ઞાનિના ઉપમીયતે| ");
INSERT INTO sanguj_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","યતો જલવૃષ્ટૌ સત્યામ્ આપ્લાવ આગતે પવને વાતે ચ તૈ ર્ગૃહે સમાઘાતે તત્ પતતિ તત્પતનં મહદ્ ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","યીશુનૈતેષુ વાક્યેષુ સમાપિતેષુ માનવાસ્તદીયોપદેશમ્ આશ્ચર્ય્યં મેનિરે| ");
INSERT INTO sanguj_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","યસ્માત્ સ ઉપાધ્યાયા ઇવ તાન્ નોપદિદેશ કિન્તુ સમર્થપુરુષઇવ સમુપદિદેશ| ");
INSERT INTO sanguj_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","યદા સ પર્વ્વતાદ્ અવારોહત્ તદા બહવો માનવાસ્તત્પશ્ચાદ્ વવ્રજુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","એકઃ કુષ્ઠવાન્ આગત્ય તં પ્રણમ્ય બભાષે, હે પ્રભો, યદિ ભવાન્ સંમન્યતે, તર્હિ માં નિરામયં કર્ત્તું શક્નોતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","તતો યીશુઃ કરં પ્રસાર્ય્ય તસ્યાઙ્ગં સ્પૃશન્ વ્યાજહાર, સમ્મન્યેઽહં ત્વં નિરામયો ભવ; તેન સ તત્ક્ષણાત્ કુષ્ઠેનામોચિ| ");
INSERT INTO sanguj_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","તતો યીશુસ્તં જગાદ, અવધેહિ કથામેતાં કશ્ચિદપિ મા બ્રૂહિ, કિન્તુ યાજકસ્ય સન્નિધિં ગત્વા સ્વાત્માનં દર્શય મનુજેભ્યો નિજનિરામયત્વં પ્રમાણયિતું મૂસાનિરૂપિતં દ્રવ્યમ્ ઉત્સૃજ ચ| ");
INSERT INTO sanguj_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","તદનન્તરં યીશુના કફર્નાહૂમ્નામનિ નગરે પ્રવિષ્ટે કશ્ચિત્ શતસેનાપતિસ્તત્સમીપમ્ આગત્ય વિનીય બભાષે, ");
INSERT INTO sanguj_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","હે પ્રભો, મદીય એકો દાસઃ પક્ષાઘાતવ્યાધિના ભૃશં વ્યથિતઃ, સતુ શયનીય આસ્તે| ");
INSERT INTO sanguj_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","તદાનીં યીશુસ્તસ્મૈ કથિતવાન્, અહં ગત્વા તં નિરામયં કરિષ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","તતઃ સ શતસેનાપતિઃ પ્રત્યવદત્, હે પ્રભો, ભવાન્ યત્ મમ ગેહમધ્યં યાતિ તદ્યોગ્યભાજનં નાહમસ્મિ; વાઙ્માત્રમ્ આદિશતુ, તેનૈવ મમ દાસો નિરામયો ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","યતો મયિ પરનિધ્નેઽપિ મમ નિદેશવશ્યાઃ કતિ કતિ સેનાઃ સન્તિ, તત એકસ્મિન્ યાહીત્યુક્તે સ યાતિ, તદન્યસ્મિન્ એહીત્યુક્તે સ આયાતિ, તથા મમ નિજદાસે કર્મ્મૈતત્ કુર્વ્વિત્યુક્તે સ તત્ કરોતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","તદાનીં યીશુસ્તસ્યૈતત્ વચો નિશમ્ય વિસ્મયાપન્નોઽભૂત્; નિજપશ્ચાદ્ગામિનો માનવાન્ અવોચ્ચ, યુષ્માન્ તથ્યં વચ્મિ, ઇસ્રાયેલીયલોકાનાં મધ્યેઽપિ નૈતાદૃશો વિશ્વાસો મયા પ્રાપ્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","અન્યચ્ચાહં યુષ્માન્ વદામિ, બહવઃ પૂર્વ્વસ્યાઃ પશ્ચિમાયાશ્ચ દિશ આગત્ય ઇબ્રાહીમા ઇસ્હાકા યાકૂબા ચ સાકમ્ મિલિત્વા સમુપવેક્ષ્યન્તિ; ");
INSERT INTO sanguj_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","કિન્તુ યત્ર સ્થાને રોદનદન્તઘર્ષણે ભવતસ્તસ્મિન્ બહિર્ભૂતતમિસ્રે રાજ્યસ્ય સન્તાના નિક્ષેસ્યન્તે| ");
INSERT INTO sanguj_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","તતઃ પરં યીશુસ્તં શતસેનાપતિં જગાદ, યાહિ, તવ પ્રતીત્યનુસારતો મઙ્ગલં ભૂયાત્; તદા તસ્મિન્નેવ દણ્ડે તદીયદાસો નિરામયો બભૂવ| ");
INSERT INTO sanguj_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","અનન્તરં યીશુઃ પિતરસ્ય ગેહમુપસ્થાય જ્વરેણ પીડિતાં શયનીયસ્થિતાં તસ્ય શ્વશ્રૂં વીક્ષાઞ્ચક્રે| ");
INSERT INTO sanguj_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","તતસ્તેન તસ્યાઃ કરસ્ય સ્પૃષ્ટતવાત્ જ્વરસ્તાં તત્યાજ, તદા સા સમુત્થાય તાન્ સિષેવે| ");
INSERT INTO sanguj_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","અનન્તરં સન્ધ્યાયાં સત્યાં બહુશો ભૂતગ્રસ્તમનુજાન્ તસ્ય સમીપમ્ આનિન્યુઃ સ ચ વાક્યેન ભૂતાન્ ત્યાજયામાસ, સર્વ્વપ્રકારપીડિતજનાંશ્ચ નિરામયાન્ ચકાર; ");
INSERT INTO sanguj_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","તસ્માત્, સર્વ્વા દુર્બ્બલતાસ્માકં તેનૈવ પરિધારિતા| અસ્માકં સકલં વ્યાધિં સએવ સંગૃહીતવાન્| યદેતદ્વચનં યિશયિયભવિષ્યદ્વાદિનોક્તમાસીત્, તત્તદા સફલમભવત્| ");
INSERT INTO sanguj_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","અનન્તરં યીશુશ્ચતુર્દિક્ષુ જનનિવહં વિલોક્ય તટિન્યાઃ પારં યાતું શિષ્યાન્ આદિદેશ| ");
INSERT INTO sanguj_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","તદાનીમ્ એક ઉપાધ્યાય આગત્ય કથિતવાન્, હે ગુરો, ભવાન્ યત્ર યાસ્યતિ તત્રાહમપિ ભવતઃ પશ્ચાદ્ યાસ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","તતો યીશુ ર્જગાદ, ક્રોષ્ટુઃ સ્થાતું સ્થાનં વિદ્યતે, વિહાયસો વિહઙ્ગમાનાં નીડાનિ ચ સન્તિ; કિન્તુ મનુષ્યપુત્રસ્ય શિરઃ સ્થાપયિતું સ્થાનં ન વિદ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","અનન્તરમ્ અપર એકઃ શિષ્યસ્તં બભાષે, હે પ્રભો, પ્રથમતો મમ પિતરં શ્મશાને નિધાતું ગમનાર્થં મામ્ અનુમન્યસ્વ| ");
INSERT INTO sanguj_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","તતો યીશુરુક્તવાન્ મૃતા મૃતાન્ શ્મશાને નિદધતુ, ત્વં મમ પશ્ચાદ્ આગચ્છ| ");
INSERT INTO sanguj_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","અનન્તરં તસ્મિન્ નાવમારૂઢે તસ્ય શિષ્યાસ્તત્પશ્ચાત્ જગ્મુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","પશ્ચાત્ સાગરસ્ય મધ્યં તેષુ ગતેષુ તાદૃશઃ પ્રબલો ઝઞ્ભ્શનિલ ઉદતિષ્ઠત્, યેન મહાતરઙ્ગ ઉત્થાય તરણિં છાદિતવાન્, કિન્તુ સ નિદ્રિત આસીત્| ");
INSERT INTO sanguj_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","તદા શિષ્યા આગત્ય તસ્ય નિદ્રાભઙ્ગં કૃત્વા કથયામાસુઃ, હે પ્રભો, વયં મ્રિયામહે, ભવાન્ અસ્માકં પ્રાણાન્ રક્ષતુ| ");
INSERT INTO sanguj_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","તદા સ તાન્ ઉક્તવાન્, હે અલ્પવિશ્વાસિનો યૂયં કુતો વિભીથ? તતઃ સ ઉત્થાય વાતં સાગરઞ્ચ તર્જયામાસ, તતો નિર્વ્વાતમભવત્| ");
INSERT INTO sanguj_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","અપરં મનુજા વિસ્મયં વિલોક્ય કથયામાસુઃ, અહો વાતસરિત્પતી અસ્ય કિમાજ્ઞાગ્રાહિણૌ? કીદૃશોઽયં માનવઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","અનન્તરં સ પારં ગત્વા ગિદેરીયદેશમ્ ઉપસ્થિતવાન્; તદા દ્વૌ ભૂતગ્રસ્તમનુજૌ શ્મશાનસ્થાનાદ્ બહિ ર્ભૂત્વા તં સાક્ષાત્ કૃતવન્તૌ, તાવેતાદૃશૌ પ્રચણ્ડાવાસ્તાં યત્ તેન સ્થાનેન કોપિ યાતું નાશક્નોત્| ");
INSERT INTO sanguj_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","તાવુચૈઃ કથયામાસતુઃ, હે ઈશ્વરસ્ય સૂનો યીશો, ત્વયા સાકમ્ આવયોઃ કઃ સમ્બન્ધઃ? નિરૂપિતકાલાત્ પ્રાગેવ કિમાવાભ્યાં યાતનાં દાતુમ્ અત્રાગતોસિ? ");
INSERT INTO sanguj_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","તદાનીં તાભ્યાં કિઞ્ચિદ્ દૂરે વરાહાણામ્ એકો મહાવ્રજોઽચરત્| ");
INSERT INTO sanguj_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","તતો ભૂતૌ તૌ તસ્યાન્તિકે વિનીય કથયામાસતુઃ, યદ્યાવાં ત્યાજયસિ, તર્હિ વરાહાણાં મધ્યેવ્રજમ્ આવાં પ્રેરય| ");
INSERT INTO sanguj_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","તદા યીશુરવદત્ યાતં, અનન્તરં તૌ યદા મનુજૌ વિહાય વરાહાન્ આશ્રિતવન્તૌ, તદા તે સર્વ્વે વરાહા ઉચ્ચસ્થાનાત્ મહાજવેન ધાવન્તઃ સાગરીયતોયે મજ્જન્તો મમ્રુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","તતો વરાહરક્ષકાઃ પલાયમાના મધ્યેનગરં તૌ ભૂતગ્રસ્તૌ પ્રતિ યદ્યદ્ અઘટત, તાઃ સર્વ્વવાર્ત્તા અવદન્| ");
INSERT INTO sanguj_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","તતો નાગરિકાઃ સર્વ્વે મનુજા યીશું સાક્ષાત્ કર્ત્તું બહિરાયાતાઃ તઞ્ચ વિલોક્ય પ્રાર્થયાઞ્ચક્રિરે ભવાન્ અસ્માકં સીમાતો યાતુ| ");
INSERT INTO sanguj_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","અનન્તરં યીશુ ર્નૌકામારુહ્ય પુનઃ પારમાગત્ય નિજગ્રામમ્ આયયૌ| ");
INSERT INTO sanguj_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","તતઃ કતિપયા જના એકં પક્ષાઘાતિનં સ્વટ્ટોપરિ શાયયિત્વા તત્સમીપમ્ આનયન્; તતો યીશુસ્તેષાં પ્રતીતિં વિજ્ઞાય તં પક્ષાઘાતિનં જગાદ, હે પુત્ર, સુસ્થિરો ભવ, તવ કલુષસ્ય મર્ષણં જાતમ્| ");
INSERT INTO sanguj_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","તાં કથાં નિશમ્ય કિયન્ત ઉપાધ્યાયા મનઃસુ ચિન્તિતવન્ત એષ મનુજ ઈશ્વરં નિન્દતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","તતઃ સ તેષામ્ એતાદૃશીં ચિન્તાં વિજ્ઞાય કથિતવાન્, યૂયં મનઃસુ કૃત એતાદૃશીં કુચિન્તાં કુરુથ? ");
INSERT INTO sanguj_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","તવ પાપમર્ષણં જાતં, યદ્વા ત્વમુત્થાય ગચ્છ, દ્વયોરનયો ર્વાક્યયોઃ કિં વાક્યં વક્તું સુગમં? ");
INSERT INTO sanguj_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","કિન્તુ મેદિન્યાં કલુષં ક્ષમિતું મનુજસુતસ્ય સામર્થ્યમસ્તીતિ યૂયં યથા જાનીથ, તદર્થં સ તં પક્ષાઘાતિનં ગદિતવાન્, ઉત્તિષ્ઠ, નિજશયનીયં આદાય ગેહં ગચ્છ| ");
INSERT INTO sanguj_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","તતઃ સ તત્ક્ષણાદ્ ઉત્થાય નિજગેહં પ્રસ્થિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","માનવા ઇત્થં વિલોક્ય વિસ્મયં મેનિરે, ઈશ્વરેણ માનવાય સામર્થ્યમ્ ઈદૃશં દત્તં ઇતિ કારણાત્ તં ધન્યં બભાષિરે ચ| ");
INSERT INTO sanguj_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","અનન્તરં યીશુસ્તત્સ્થાનાદ્ ગચ્છન્ ગચ્છન્ કરસંગ્રહસ્થાને સમુપવિષ્ટં મથિનામાનમ્ એકં મનુજં વિલોક્ય તં બભાષે, મમ પશ્ચાદ્ આગચ્છ, તતઃ સ ઉત્થાય તસ્ય પશ્ચાદ્ વવ્રાજ| ");
INSERT INTO sanguj_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","તતઃ પરં યીશૌ ગૃહે ભોક્તુમ્ ઉપવિષ્ટે બહવઃ કરસંગ્રાહિણઃ કલુષિણશ્ચ માનવા આગત્ય તેન સાકં તસ્ય શિષ્યૈશ્ચ સાકમ્ ઉપવિવિશુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ફિરૂશિનસ્તદ્ દૃષ્ટ્વા તસ્ય શિષ્યાન્ બભાષિરે, યુષ્માકં ગુરુઃ કિં નિમિત્તં કરસંગ્રાહિભિઃ કલુષિભિશ્ચ સાકં ભુંક્તે? ");
INSERT INTO sanguj_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","યીશુસ્તત્ શ્રુત્વા તાન્ પ્રત્યવદત્, નિરામયલોકાનાં ચિકિત્સકેન પ્રયોજનં નાસ્તિ, કિન્તુ સામયલોકાનાં પ્રયોજનમાસ્તે| ");
INSERT INTO sanguj_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","અતો યૂયં યાત્વા વચનસ્યાસ્યાર્થં શિક્ષધ્વમ્, દયાયાં મે યથા પ્રીતિ ર્ન તથા યજ્ઞકર્મ્મણિ| યતોઽહં ધાર્મ્મિકાન્ આહ્વાતું નાગતોઽસ્મિ કિન્તુ મનઃ પરિવર્ત્તયિતું પાપિન આહ્વાતુમ્ આગતોઽસ્મિ| ");
INSERT INTO sanguj_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","અનન્તરં યોહનઃ શિષ્યાસ્તસ્ય સમીપમ્ આગત્ય કથયામાસુઃ, ફિરૂશિનો વયઞ્ચ પુનઃ પુનરુપવસામઃ, કિન્તુ તવ શિષ્યા નોપવસન્તિ, કુતઃ? ");
INSERT INTO sanguj_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","તદા યીશુસ્તાન્ અવોચત્ યાવત્ સખીનાં સંઙ્ગે કન્યાયા વરસ્તિષ્ઠતિ, તાવત્ કિં તે વિલાપં કર્ત્તું શક્લુવન્તિ? કિન્તુ યદા તેષાં સંઙ્ગાદ્ વરં નયન્તિ, તાદૃશઃ સમય આગમિષ્યતિ, તદા તે ઉપવત્સ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","પુરાતનવસને કોપિ નવીનવસ્ત્રં ન યોજયતિ, યસ્માત્ તેન યોજિતેન પુરાતનવસનં છિનત્તિ તચ્છિદ્રઞ્ચ બહુકુત્સિતં દૃશ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","અન્યઞ્ચ પુરાતનકુત્વાં કોપિ નવાનગોસ્તનીરસં ન નિદધાતિ, યસ્માત્ તથા કૃતે કુતૂ ર્વિદીર્ય્યતે તેન ગોસ્તનીરસઃ પતતિ કુતૂશ્ચ નશ્યતિ; તસ્માત્ નવીનાયાં કુત્વાં નવીનો ગોસ્તનીરસઃ સ્થાપ્યતે, તેન દ્વયોરવનં ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","અપરં તેનૈતત્કથાકથનકાલે એકોઽધિપતિસ્તં પ્રણમ્ય બભાષે, મમ દુહિતા પ્રાયેણૈતાવત્કાલે મૃતા, તસ્માદ્ ભવાનાગત્ય તસ્યા ગાત્રે હસ્તમર્પયતુ, તેન સા જીવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","તદાનીં યીશુઃ શિષ્યૈઃ સાકમ્ ઉત્થાય તસ્ય પશ્ચાદ્ વવ્રાજ| ");
INSERT INTO sanguj_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ઇત્યનન્તરે દ્વાદશવત્સરાન્ યાવત્ પ્રદરામયેન શીર્ણૈકા નારી તસ્ય પશ્ચાદ્ આગત્ય તસ્ય વસનસ્ય ગ્રન્થિં પસ્પર્શ; ");
INSERT INTO sanguj_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","યસ્માત્ મયા કેવલં તસ્ય વસનં સ્પૃષ્ટ્વા સ્વાસ્થ્યં પ્રાપ્સ્યતે, સા નારીતિ મનસિ નિશ્ચિતવતી| ");
INSERT INTO sanguj_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","તતો યીશુર્વદનં પરાવર્ત્ત્ય તાં જગાદ, હે કન્યે, ત્વં સુસ્થિરા ભવ, તવ વિશ્વાસસ્ત્વાં સ્વસ્થામકાર્ષીત્| એતદ્વાક્યે ગદિતએવ સા યોષિત્ સ્વસ્થાભૂત્| ");
INSERT INTO sanguj_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","અપરં યીશુસ્તસ્યાધ્યક્ષસ્ય ગેહં ગત્વા વાદકપ્રભૃતીન્ બહૂન્ લોકાન્ શબ્દાયમાનાન્ વિલોક્ય તાન્ અવદત્, ");
INSERT INTO sanguj_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","પન્થાનં ત્યજ, કન્યેયં નામ્રિયત નિદ્રિતાસ્તે; કથામેતાં શ્રુત્વા તે તમુપજહસુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","કિન્તુ સર્વ્વેષુ બહિષ્કૃતેષુ સોઽભ્યન્તરં ગત્વા કન્યાયાઃ કરં ધૃતવાન્, તેન સોદતિષ્ઠત્; ");
INSERT INTO sanguj_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","તતસ્તત્કર્મ્મણો યશઃ કૃત્સ્નં તં દેશં વ્યાપ્તવત્| ");
INSERT INTO sanguj_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","તતઃ પરં યીશુસ્તસ્માત્ સ્થાનાદ્ યાત્રાં ચકાર; તદા હે દાયૂદઃ સન્તાન, અસ્માન્ દયસ્વ, ઇતિ વદન્તૌ દ્વૌ જનાવન્ધૌ પ્રોચૈરાહૂયન્તૌ તત્પશ્ચાદ્ વવ્રજતુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","તતો યીશૌ ગેહમધ્યં પ્રવિષ્ટં તાવપિ તસ્ય સમીપમ્ ઉપસ્થિતવન્તૌ, તદાનીં સ તૌ પૃષ્ટવાન્ કર્મ્મૈતત્ કર્ત્તું મમ સામર્થ્યમ્ આસ્તે, યુવાં કિમિતિ પ્રતીથઃ? તદા તૌ પ્રત્યૂચતુઃ, સત્યં પ્રભો| ");
INSERT INTO sanguj_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","તદાનીં સ તયો ર્લોચનાનિ સ્પૃશન્ બભાષે, યુવયોઃ પ્રતીત્યનુસારાદ્ યુવયો ર્મઙ્ગલં ભૂયાત્| તેન તત્ક્ષણાત્ તયો ર્નેત્રાણિ પ્રસન્નાન્યભવન્, ");
INSERT INTO sanguj_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","પશ્ચાદ્ યીશુસ્તૌ દૃઢમાજ્ઞાપ્ય જગાદ, અવધત્તમ્ એતાં કથાં કોપિ મનુજો મ જાનીયાત્| ");
INSERT INTO sanguj_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","કિન્તુ તૌ પ્રસ્થાય તસ્મિન્ કૃત્સ્ને દેશે તસ્ય કીર્ત્તિં પ્રકાશયામાસતુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","અપરં તૌ બહિર્યાત એતસ્મિન્નન્તરે મનુજા એકં ભૂતગ્રસ્તમૂકં તસ્ય સમીપમ્ આનીતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","તેન ભૂતે ત્યાજિતે સ મૂકઃ કથાં કથયિતું પ્રારભત, તેન જના વિસ્મયં વિજ્ઞાય કથયામાસુઃ, ઇસ્રાયેલો વંશે કદાપિ નેદૃગદૃશ્યત; ");
INSERT INTO sanguj_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","કિન્તુ ફિરૂશિનઃ કથયાઞ્ચક્રુઃ ભૂતાધિપતિના સ ભૂતાન્ ત્યાજયતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","તતઃ પરં યીશુસ્તેષાં ભજનભવન ઉપદિશન્ રાજ્યસ્ય સુસંવાદં પ્રચારયન્ લોકાનાં યસ્ય ય આમયો યા ચ પીડાસીત્, તાન્ શમયન્ શમયંશ્ચ સર્વ્વાણિ નગરાણિ ગ્રામાંશ્ચ બભ્રામ| ");
INSERT INTO sanguj_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","અન્યઞ્ચ મનુજાન્ વ્યાકુલાન્ અરક્ષકમેષાનિવ ચ ત્યક્તાન્ નિરીક્ષ્ય તેષુ કારુણિકઃ સન્ શિષ્યાન્ અવદત્, ");
INSERT INTO sanguj_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","શસ્યાનિ પ્રચુરાણિ સન્તિ, કિન્તુ છેત્તારઃ સ્તોકાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ક્ષેત્રં પ્રત્યપરાન્ છેદકાન્ પ્રહેતું શસ્યસ્વામિનં પ્રાર્થયધ્વમ્| ");
INSERT INTO sanguj_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","અનન્તરં યીશુ ર્દ્વાદશશિષ્યાન્ આહૂયામેધ્યભૂતાન્ ત્યાજયિતું સર્વ્વપ્રકારરોગાન્ પીડાશ્ચ શમયિતું તેભ્યઃ સામર્થ્યમદાત્| ");
INSERT INTO sanguj_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","તેષાં દ્વાદશપ્રેષ્યાણાં નામાન્યેતાનિ| પ્રથમં શિમોન્ યં પિતરં વદન્તિ, તતઃ પરં તસ્ય સહજ આન્દ્રિયઃ, સિવદિયસ્ય પુત્રો યાકૂબ્ ");
INSERT INTO sanguj_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","તસ્ય સહજો યોહન્; ફિલિપ્ બર્થલમય્ થોમાઃ કરસંગ્રાહી મથિઃ, આલ્ફેયપુત્રો યાકૂબ્, ");
INSERT INTO sanguj_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","કિનાનીયઃ શિમોન્, ય ઈષ્કરિયોતીયયિહૂદાઃ ખ્રીષ્ટં પરકરેઽર્પયત્| ");
INSERT INTO sanguj_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","એતાન્ દ્વાદશશિષ્યાન્ યીશુઃ પ્રેષયન્ ઇત્યાજ્ઞાપયત્, યૂયમ્ અન્યદેશીયાનાં પદવીં શેમિરોણીયાનાં કિમપિ નગરઞ્ચ ન પ્રવિશ્યે ");
INSERT INTO sanguj_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ઇસ્રાયેલ્ગોત્રસ્ય હારિતા યે યે મેષાસ્તેષામેવ સમીપં યાત| ");
INSERT INTO sanguj_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","ગત્વા ગત્વા સ્વર્ગસ્ય રાજત્વં સવિધમભવત્, એતાં કથાં પ્રચારયત| ");
INSERT INTO sanguj_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","આમયગ્રસ્તાન્ સ્વસ્થાન્ કુરુત, કુષ્ઠિનઃ પરિષ્કુરુત, મૃતલોકાન્ જીવયત, ભૂતાન્ ત્યાજયત, વિના મૂલ્યં યૂયમ્ અલભધ્વં વિનૈવ મૂલ્યં વિશ્રાણયત| ");
INSERT INTO sanguj_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","કિન્તુ સ્વેષાં કટિબન્ધેષુ સ્વર્ણરૂપ્યતામ્રાણાં કિમપિ ન ગૃહ્લીત| ");
INSERT INTO sanguj_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","અન્યચ્ચ યાત્રાયૈ ચેલસમ્પુટં વા દ્વિતીયવસનં વા પાદુકે વા યષ્ટિઃ, એતાન્ મા ગૃહ્લીત, યતઃ કાર્ય્યકૃત્ ભર્ત્તું યોગ્યો ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","અપરં યૂયં યત્ પુરં યઞ્ચ ગ્રામં પ્રવિશથ, તત્ર યો જનો યોગ્યપાત્રં તમવગત્ય યાનકાલં યાવત્ તત્ર તિષ્ઠત| ");
INSERT INTO sanguj_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","યદા યૂયં તદ્ગેહં પ્રવિશથ, તદા તમાશિષં વદત| ");
INSERT INTO sanguj_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","યદિ સ યોગ્યપાત્રં ભવતિ, તર્હિ તત્કલ્યાણં તસ્મૈ ભવિષ્યતિ, નોચેત્ સાશીર્યુષ્મભ્યમેવ ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","કિન્તુ યે જના યુષ્માકમાતિથ્યં ન વિદધતિ યુષ્માકં કથાઞ્ચ ન શૃણ્વન્તિ તેષાં ગેહાત્ પુરાદ્વા પ્રસ્થાનકાલે સ્વપદૂલીઃ પાતયત| ");
INSERT INTO sanguj_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","યુષ્માનહં તથ્યં વચ્મિ વિચારદિને તત્પુરસ્ય દશાતઃ સિદોમમોરાપુરયોર્દશા સહ્યતરા ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","પશ્યત, વૃકયૂથમધ્યે મેષઃ યથાવિસ્તથા યુષ્માન પ્રહિણોમિ, તસ્માદ્ યૂયમ્ અહિરિવ સતર્કાઃ કપોતાઇવાહિંસકા ભવત| ");
INSERT INTO sanguj_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","નૃભ્યઃ સાવધાના ભવત; યતસ્તૈ ર્યૂયં રાજસંસદિ સમર્પિષ્યધ્વે તેષાં ભજનગેહે પ્રહારિષ્યધ્વે| ");
INSERT INTO sanguj_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","યૂયં મન્નામહેતોઃ શાસ્તૃણાં રાજ્ઞાઞ્ચ સમક્ષં તાનન્યદેશિનશ્ચાધિ સાક્ષિત્વાર્થમાનેષ્યધ્વે| ");
INSERT INTO sanguj_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","કિન્ત્વિત્થં સમર્પિતા યૂયં કથં કિમુત્તરં વક્ષ્યથ તત્ર મા ચિન્તયત, યતસ્તદા યુષ્માભિ ર્યદ્ વક્તવ્યં તત્ તદ્દણ્ડે યુષ્મન્મનઃ સુ સમુપસ્થાસ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","યસ્માત્ તદા યો વક્ષ્યતિ સ ન યૂયં કિન્તુ યુષ્માકમન્તરસ્થઃ પિત્રાત્મા| ");
INSERT INTO sanguj_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","સહજઃ સહજં તાતઃ સુતઞ્ચ મૃતૌ સમર્પયિષ્યતિ, અપત્યાગિ સ્વસ્વપિત્રોे ર્વિપક્ષીભૂય તૌ ઘાતયિષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","મન્નમહેતોઃ સર્વ્વે જના યુષ્માન્ ઋृતીયિષ્યન્તે, કિન્તુ યઃ શેષં યાવદ્ ધૈર્ય્યં ઘૃત્વા સ્થાસ્યતિ, સ ત્રાયિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","તૈ ર્યદા યૂયમેકપુરે તાડિષ્યધ્વે, તદા યૂયમન્યપુરં પલાયધ્વં યુષ્માનહં તથ્યં વચ્મિ યાવન્મનુજસુતો નૈતિ તાવદ્ ઇસ્રાયેલ્દેશીયસર્વ્વનગરભ્રમણં સમાપયિતું ન શક્ષ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","ગુરોઃ શિષ્યો ન મહાન્, પ્રભોર્દાસો ન મહાન્| ");
INSERT INTO sanguj_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","યદિ શિષ્યો નિજગુરો ર્દાસશ્ચ સ્વપ્રભોઃ સમાનો ભવતિ તર્હિ તદ્ યથેષ્ટં| ચેત્તૈર્ગૃહપતિર્ભૂતરાજ ઉચ્યતે, તર્હિ પરિવારાઃ કિં તથા ન વક્ષ્યન્તે? ");
INSERT INTO sanguj_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","કિન્તુ તેભ્યો યૂયં મા બિભીત, યતો યન્ન પ્રકાશિષ્યતે, તાદૃક્ છાદિતં કિમપિ નાસ્તિ, યચ્ચ ન વ્યઞ્ચિષ્યતે, તાદૃગ્ ગુપ્તં કિમપિ નાસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","યદહં યુષ્માન્ તમસિ વચ્મિ તદ્ યુષ્માભિર્દીપ્તૌ કથ્યતાં; કર્ણાભ્યાં યત્ શ્રૂયતે તદ્ ગેહોપરિ પ્રચાર્ય્યતાં| ");
INSERT INTO sanguj_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","યે કાયં હન્તું શક્નુવન્તિ નાત્માનં, તેભ્યો મા ભૈષ્ટ; યઃ કાયાત્માનૌ નિરયે નાશયિતું, શક્નોતિ, તતો બિભીત| ");
INSERT INTO sanguj_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","દ્વૌ ચટકૌ કિમેકતામ્રમુદ્રયા ન વિક્રીયેતે? તથાપિ યુષ્મત્તાતાનુમતિં વિના તેષામેકોપિ ભુવિ ન પતતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","યુષ્મચ્છિરસાં સર્વ્વકચા ગણિતાંઃ સન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","અતો મા બિભીત, યૂયં બહુચટકેભ્યો બહુમૂલ્યાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","યો મનુજસાક્ષાન્મામઙ્ગીકુરુતે તમહં સ્વર્ગસ્થતાતસાક્ષાદઙ્ગીકરિષ્યે| ");
INSERT INTO sanguj_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","પૃથ્વ્યામહં શાન્તિં દાતુમાગતઇતિ માનુભવત, શાન્તિં દાતું ન કિન્ત્વસિં| ");
INSERT INTO sanguj_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","પિતૃમાતૃશ્ચશ્રૂભિઃ સાકં સુતસુતાબધૂ ર્વિરોધયિતુઞ્ચાગતેाસ્મિ| ");
INSERT INTO sanguj_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","તતઃ સ્વસ્વપરિવારએવ નૃશત્રુ ર્ભવિતા| ");
INSERT INTO sanguj_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","યઃ પિતરિ માતરિ વા મત્તોધિકં પ્રીયતે, સ ન મદર્હઃ; ");
INSERT INTO sanguj_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","યશ્ચ સુતે સુતાયાં વા મત્તોધિકં પ્રીયતે, સેाપિ ન મદર્હઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","યઃ સ્વક્રુશં ગૃહ્લન્ મત્પશ્ચાન્નૈતિ, સેाપિ ન મદર્હઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","યઃ સ્વપ્રાણાનવતિ, સ તાન્ હારયિષ્યતે, યસ્તુ મત્કૃતે સ્વપ્રાણાન્ હારયતિ, સ તાનવતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","યો યુષ્માકમાતિથ્યં વિદધાતિ, સ મમાતિથ્યં વિદધાતિ, યશ્ચ મમાતિથ્યં વિદધાતિ, સ મત્પ્રેરકસ્યાતિથ્યં વિદધાતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","યો ભવિષ્યદ્વાદીતિ જ્ઞાત્વા તસ્યાતિથ્યં વિધત્તે, સ ભવિષ્યદ્વાદિનઃ ફલં લપ્સ્યતે, યશ્ચ ધાર્મ્મિક ઇતિ વિદિત્વા તસ્યાતિથ્યં વિધત્તે સ ધાર્મ્મિકમાનવસ્ય ફલં પ્રાપ્સ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","યશ્ચ કશ્ચિત્ એતેષાં ક્ષુદ્રનરાણામ્ યં કઞ્ચનૈકં શિષ્ય ઇતિ વિદિત્વા કંસૈકં શીતલસલિલં તસ્મૈ દત્તે, યુષ્માનહં તથ્યં વદામિ, સ કેનાપિ પ્રકારેણ ફલેન ન વઞ્ચિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ઇત્થં યીશુઃ સ્વદ્વાદશશિષ્યાણામાજ્ઞાપનં સમાપ્ય પુરે પુર ઉપદેષ્ટું સુસંવાદં પ્રચારયિતું તત્સ્થાનાત્ પ્રતસ્થે| ");
INSERT INTO sanguj_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","અનન્તરં યોહન્ કારાયાં તિષ્ઠન્ ખ્રિષ્ટસ્ય કર્મ્મણાં વાર્ત્તં પ્રાપ્ય યસ્યાગમનવાર્ત્તાસીત્ સએવ કિં ત્વં? વા વયમન્યમ્ અપેક્ષિષ્યામહે? ");
INSERT INTO sanguj_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","એતત્ પ્રષ્ટું નિજૌ દ્વૌ શિષ્યૌ પ્રાહિણોત્| ");
INSERT INTO sanguj_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","યીશુઃ પ્રત્યવોચત્, અન્ધા નેત્રાણિ લભન્તે, ખઞ્ચા ગચ્છન્તિ, કુષ્ઠિનઃ સ્વસ્થા ભવન્તિ, બધિરાઃ શૃણ્વન્તિ, મૃતા જીવન્ત ઉત્તિષ્ઠન્તિ, દરિદ્રાણાં સમીપે સુસંવાદઃ પ્રચાર્ય્યત, ");
INSERT INTO sanguj_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","એતાનિ યદ્યદ્ યુવાં શૃણુથઃ પશ્યથશ્ચ ગત્વા તદ્વાર્ત્તાં યોહનં ગદતં| ");
INSERT INTO sanguj_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","યસ્યાહં ન વિઘ્નીભવામિ, સએવ ધન્યઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","અનન્તરં તયોઃ પ્રસ્થિતયો ર્યીશુ ર્યોહનમ્ ઉદ્દિશ્ય જનાન્ જગાદ, યૂયં કિં દ્રષ્ટું વહિર્મધ્યેપ્રાન્તરમ્ અગચ્છત? કિં વાતેન કમ્પિતં નલં? ");
INSERT INTO sanguj_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","વા કિં વીક્ષિતું વહિર્ગતવન્તઃ? કિં પરિહિતસૂક્ષ્મવસનં મનુજમેકં? પશ્યત, યે સૂક્ષ્મવસનાનિ પરિદધતિ, તે રાજધાન્યાં તિષ્ઠન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","તર્હિ યૂયં કિં દ્રષ્ટું બહિરગમત, કિમેકં ભવિષ્યદ્વાદિનં? તદેવ સત્યં| યુષ્માનહં વદામિ, સ ભવિષ્યદ્વાદિનોપિ મહાન્; ");
INSERT INTO sanguj_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","યતઃ, પશ્ય સ્વકીયદૂતોયં ત્વદગ્રે પ્રેષ્યતે મયા| સ ગત્વા તવ પન્થાનં સ્મયક્ પરિષ્કરિષ્યતિ|| એતદ્વચનં યમધિ લિખિતમાસ્તે સોઽયં યોહન્| ");
INSERT INTO sanguj_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","અપરં યુષ્માનહં તથ્યં બ્રવીમિ, મજ્જયિતુ ર્યોહનઃ શ્રેષ્ઠઃ કોપિ નારીતો નાજાયત; તથાપિ સ્વર્ગરાજ્યમધ્યે સર્વ્વેભ્યો યઃ ક્ષુદ્રઃ સ યોહનઃ શ્રેષ્ઠઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","અપરઞ્ચ આ યોહનોઽદ્ય યાવત્ સ્વર્ગરાજ્યં બલાદાક્રાન્તં ભવતિ આક્રમિનશ્ચ જના બલેન તદધિકુર્વ્વન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","યતો યોહનં યાવત્ સર્વ્વભવિષ્યદ્વાદિભિ ર્વ્યવસ્થયા ચ ઉપદેશઃ પ્રાકાશ્યત| ");
INSERT INTO sanguj_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","યદિ યૂયમિદં વાક્યં ગ્રહીતું શક્નુથ, તર્હિ શ્રેયઃ, યસ્યાગમનસ્ય વચનમાસ્તે સોઽયમ્ એલિયઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","યસ્ય શ્રોતું કર્ણૌ સ્તઃ સ શૃણોતુ| ");
INSERT INTO sanguj_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","એતે વિદ્યમાનજનાઃ કૈ ર્મયોપમીયન્તે? યે બાલકા હટ્ટ ઉપવિશ્ય સ્વં સ્વં બન્ધુમાહૂય વદન્તિ, ");
INSERT INTO sanguj_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","વયં યુષ્માકં સમીપે વંશીરવાદયામ, કિન્તુ યૂયં નાનૃત્યત; યુષ્માકં સમીપે ચ વયમરોદિમ, કિન્તુ યૂયં ન વ્યલપત, તાદૃશૈ ર્બાલકૈસ્ત ઉપમાયિષ્યન્તે| ");
INSERT INTO sanguj_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","યતો યોહન્ આગત્ય ન ભુક્તવાન્ ન પીતવાંશ્ચ, તેન લોકા વદન્તિ, સ ભૂતગ્રસ્ત ઇતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","મનુજસુત આગત્ય ભુક્તવાન્ પીતવાંશ્ચ, તેન લોકા વદન્તિ, પશ્યત એષ ભોક્તા મદ્યપાતા ચણ્ડાલપાપિનાં બન્ધશ્ચ, કિન્તુ જ્ઞાનિનો જ્ઞાનવ્યવહારં નિર્દોષં જાનન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","સ યત્ર યત્ર પુરે બહ્વાશ્ચર્ય્યં કર્મ્મ કૃતવાન્, તન્નિવાસિનાં મનઃપરાવૃત્ત્યભાવાત્ તાનિ નગરાણિ પ્રતિ હન્તેત્યુક્તા કથિતવાન્, ");
INSERT INTO sanguj_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","હા કોરાસીન્, હા બૈત્સૈદે, યુષ્મન્મધ્યે યદ્યદાશ્ચર્ય્યં કર્મ્મ કૃતં યદિ તત્ સોરસીદોન્નગર અકારિષ્યત, તર્હિ પૂર્વ્વમેવ તન્નિવાસિનઃ શાણવસને ભસ્મનિ ચોપવિશન્તો મનાંસિ પરાવર્ત્તિષ્યન્ત| ");
INSERT INTO sanguj_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","તસ્માદહં યુષ્માન્ વદામિ, વિચારદિને યુષ્માકં દશાતઃ સોરસીદોનો ર્દશા સહ્યતરા ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","અપરઞ્ચ બત કફર્નાહૂમ્, ત્વં સ્વર્ગં યાવદુન્નતોસિ, કિન્તુ નરકે નિક્ષેપ્સ્યસે, યસ્માત્ ત્વયિ યાન્યાશ્ચર્ય્યાણિ કર્મ્મણ્યકારિષત, યદિ તાનિ સિદોમ્નગર અકારિષ્યન્ત, તર્હિ તદદ્ય યાવદસ્થાસ્યત્| ");
INSERT INTO sanguj_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","કિન્ત્વહં યુષ્માન્ વદામિ, વિચારદિને તવ દણ્ડતઃ સિદોમો દણ્ડો સહ્યતરો ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","એતસ્મિન્નેવ સમયે યીશુઃ પુનરુવાચ, હે સ્વર્ગપૃથિવ્યોરેકાધિપતે પિતસ્ત્વં જ્ઞાનવતો વિદુષશ્ચ લોકાન્ પ્રત્યેતાનિ ન પ્રકાશ્ય બાલકાન્ પ્રતિ પ્રકાશિતવાન્, ઇતિ હેતોસ્ત્વાં ધન્યં વદામિ| ");
INSERT INTO sanguj_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","હે પિતઃ, ઇત્થં ભવેત્ યત ઇદં ત્વદૃષ્ટાવુત્તમં| ");
INSERT INTO sanguj_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","પિત્રા મયિ સર્વ્વાણિ સમર્પિતાનિ, પિતરં વિના કોપિ પુત્રં ન જાનાતિ, યાન્ પ્રતિ પુત્રેણ પિતા પ્રકાશ્યતે તાન્ વિના પુત્રાદ્ અન્યઃ કોપિ પિતરં ન જાનાતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","હે પરિશ્રાન્તા ભારાક્રાન્તાશ્ચ લોકા યૂયં મત્સન્નિધિમ્ આગચ્છત, અહં યુષ્માન્ વિશ્રમયિષ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","અહં ક્ષમણશીલો નમ્રમનાશ્ચ, તસ્માત્ મમ યુગં સ્વેષામુપરિ ધારયત મત્તઃ શિક્ષધ્વઞ્ચ, તેન યૂયં સ્વે સ્વે મનસિ વિશ્રામં લપ્સ્યધ્બે| ");
INSERT INTO sanguj_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","યતો મમ યુગમ્ અનાયાસં મમ ભારશ્ચ લઘુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","અનન્તરં યીશુ ર્વિશ્રામવારે શ્સ્યમધ્યેન ગચ્છતિ, તદા તચ્છિષ્યા બુભુક્ષિતાઃ સન્તઃ શ્સ્યમઞ્જરીશ્છત્વા છિત્વા ખાદિતુમારભન્ત| ");
INSERT INTO sanguj_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","તદ્ વિલોક્ય ફિરૂશિનો યીશું જગદુઃ, પશ્ય વિશ્રામવારે યત્ કર્મ્માકર્ત્તવ્યં તદેવ તવ શિષ્યાઃ કુર્વ્વન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","સ તાન્ પ્રત્યાવદત, દાયૂદ્ તત્સઙ્ગિનશ્ચ બુભુક્ષિતાઃ સન્તો યત્ કર્મ્માકુર્વ્વન્ તત્ કિં યુષ્માભિ ર્નાપાઠિ? ");
INSERT INTO sanguj_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","યે દર્શનીયાઃ પૂપાઃ યાજકાન્ વિના તસ્ય તત્સઙ્ગિમનુજાનાઞ્ચાભોજનીયાસ્ત ઈશ્વરાવાસં પ્રવિષ્ટેન તેન ભુક્તાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","અન્યચ્ચ વિશ્રામવારે મધ્યેમન્દિરં વિશ્રામવારીયં નિયમં લઙ્વન્તોપિ યાજકા નિર્દોષા ભવન્તિ, શાસ્ત્રમધ્યે કિમિદમપિ યુષ્માભિ ર્ન પઠિતં? ");
INSERT INTO sanguj_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","યુષ્માનહં વદામિ, અત્ર સ્થાને મન્દિરાદપિ ગરીયાન્ એક આસ્તે| ");
INSERT INTO sanguj_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","કિન્તુ દયાયાં મે યથા પ્રીતિ ર્ન તથા યજ્ઞકર્મ્મણિ| એતદ્વચનસ્યાર્થં યદિ યુયમ્ અજ્ઞાસિષ્ટ તર્હિ નિર્દોષાન્ દોષિણો નાકાર્ષ્ટ| ");
INSERT INTO sanguj_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","અન્યચ્ચ મનુજસુતો વિશ્રામવારસ્યાપિ પતિરાસ્તે| ");
INSERT INTO sanguj_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","અનન્તરં સ તત્સ્થાનાત્ પ્રસ્થાય તેષાં ભજનભવનં પ્રવિષ્ટવાન્, તદાનીમ્ એકઃ શુષ્કકરામયવાન્ ઉપસ્થિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","તતો યીશુમ્ અપવદિતું માનુષાઃ પપ્રચ્છુઃ, વિશ્રામવારે નિરામયત્વં કરણીયં ન વા? ");
INSERT INTO sanguj_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","તેન સ પ્રત્યુવાચ, વિશ્રામવારે યદિ કસ્યચિદ્ અવિ ર્ગર્ત્તે પતતિ, તર્હિ યસ્તં ઘૃત્વા ન તોલયતિ, એતાદૃશો મનુજો યુષ્માકં મધ્યે ક આસ્તે? ");
INSERT INTO sanguj_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","અવે ર્માનવઃ કિં નહિ શ્રેયાન્? અતો વિશ્રામવારે હિતકર્મ્મ કર્ત્તવ્યં| ");
INSERT INTO sanguj_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","અનન્તરં સ તં માનવં ગદિતવાન્, કરં પ્રસારય; તેન કરે પ્રસારિતે સોન્યકરવત્ સ્વસ્થોઽભવત્| ");
INSERT INTO sanguj_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","તદા ફિરૂશિનો બહિર્ભૂય કથં તં હનિષ્યામ ઇતિ કુમન્ત્રણાં તત્પ્રાતિકૂલ્યેન ચક્રુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","તતો યીશુસ્તદ્ વિદિત્વા સ્થનાન્તરં ગતવાન્; અન્યેષુ બહુનરેષુ તત્પશ્ચાદ્ ગતેષુ તાન્ સ નિરામયાન્ કૃત્વા ઇત્યાજ્ઞાપયત્, ");
INSERT INTO sanguj_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","યૂયં માં ન પરિચાયયત| ");
INSERT INTO sanguj_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","તસ્માત્ મમ પ્રીયો મનોનીતો મનસસ્તુષ્ટિકારકઃ| મદીયઃ સેવકો યસ્તુ વિદ્યતે તં સમીક્ષતાં| તસ્યોપરિ સ્વકીયાત્મા મયા સંસ્થાપયિષ્યતે| તેનાન્યદેશજાતેષુ વ્યવસ્થા સંપ્રકાશ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","કેનાપિ ન વિરોધં સ વિવાદઞ્ચ કરિષ્યતિ| ન ચ રાજપથે તેન વચનં શ્રાવયિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","વ્યવસ્થા ચલિતા યાવત્ નહિ તેન કરિષ્યતે| તાવત્ નલો વિદીર્ણોઽપિ ભંક્ષ્યતે નહિ તેન ચ| તથા સધૂમવર્ત્તિઞ્ચ ન સ નિર્વ્વાપયિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","પ્રત્યાશાઞ્ચ કરિષ્યન્તિ તન્નામ્નિ ભિન્નદેશજાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","યાન્યેતાનિ વચનાનિ યિશયિયભવિષ્યદ્વાદિના પ્રોક્તાન્યાસન્, તાનિ સફલાન્યભવન્| ");
INSERT INTO sanguj_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","અનન્તરં લોકૈ સ્તત્સમીપમ્ આનીતો ભૂતગ્રસ્તાન્ધમૂકૈકમનુજસ્તેન સ્વસ્થીકૃતઃ, તતઃ સોઽન્ધો મૂકો દ્રષ્ટું વક્તુઞ્ચારબ્ધવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","અનેન સર્વ્વે વિસ્મિતાઃ કથયાઞ્ચક્રુઃ, એષઃ કિં દાયૂદઃ સન્તાનો નહિ? ");
INSERT INTO sanguj_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","કિન્તુ ફિરૂશિનસ્તત્ શ્રુત્વા ગદિતવન્તઃ, બાલ્સિબૂબ્નામ્નો ભૂતરાજસ્ય સાહાય્યં વિના નાયં ભૂતાન્ ત્યાજયતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","તદાનીં યીશુસ્તેષામ્ ઇતિ માનસં વિજ્ઞાય તાન્ અવદત્ કિઞ્ચન રાજ્યં યદિ સ્વવિપક્ષાદ્ ભિદ્યતે, તર્હિ તત્ ઉચ્છિદ્યતે; યચ્ચ કિઞ્ચન નગરં વા ગૃહં સ્વવિપક્ષાદ્ વિભિદ્યતે, તત્ સ્થાતું ન શક્નોતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","તદ્વત્ શયતાનો યદિ શયતાનં બહિઃ કૃત્વા સ્વવિપક્ષાત્ પૃથક્ પૃથક્ ભવતિ, તર્હિ તસ્ય રાજ્યં કેન પ્રકારેણ સ્થાસ્યતિ? ");
INSERT INTO sanguj_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","અહઞ્ચ યદિ બાલ્સિબૂબા ભૂતાન્ ત્યાજયામિ, તર્હિ યુષ્માકં સન્તાનાઃ કેન ભૂતાન્ ત્યાજયન્તિ? તસ્માદ્ યુષ્માકમ્ એતદ્વિચારયિતારસ્ત એવ ભવિષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","કિન્તવહં યદીશ્વરાત્મના ભૂતાન્ ત્યાજયામિ, તર્હીશ્વરસ્ય રાજ્યં યુષ્માકં સન્નિધિમાગતવત્| ");
INSERT INTO sanguj_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","અન્યઞ્ચ કોપિ બલવન્ત જનં પ્રથમતો ન બદ્વ્વા કેન પ્રકારેણ તસ્ય ગૃહં પ્રવિશ્ય તદ્દ્રવ્યાદિ લોઠયિતું શક્નોતિ? કિન્તુ તત્ કૃત્વા તદીયગૃસ્ય દ્રવ્યાદિ લોઠયિતું શક્નોતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","યઃ કશ્ચિત્ મમ સ્વપક્ષીયો નહિ સ વિપક્ષીય આસ્તે, યશ્ચ મયા સાકં ન સંગૃહ્લાતિ, સ વિકિરતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","અતએવ યુષ્માનહં વદામિ, મનુજાનાં સર્વ્વપ્રકારપાપાનાં નિન્દાયાશ્ચ મર્ષણં ભવિતું શક્નોતિ, કિન્તુ પવિત્રસ્યાત્મનો વિરુદ્ધનિન્દાયા મર્ષણં ભવિતું ન શક્નોતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","યો મનુજસુતસ્ય વિરુદ્ધાં કથાં કથયતિ, તસ્યાપરાધસ્ય ક્ષમા ભવિતું શક્નોતિ, કિન્તુ યઃ કશ્ચિત્ પવિત્રસ્યાત્મનો વિરુદ્ધાં કથાં કથયતિ નેહલોકે ન પ્રેત્ય તસ્યાપરાધસ્ય ક્ષમા ભવિતું શક્નોતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","પાદપં યદિ ભદ્રં વદથ, તર્હિ તસ્ય ફલમપિ સાધુ વક્તવ્યં, યદિ ચ પાદપં અસાધું વદથ, તર્હિ તસ્ય ફલમપ્યસાધુ વક્તવ્યં; યતઃ સ્વીયસ્વીયફલેન પાદપઃ પરિચીયતે| ");
INSERT INTO sanguj_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","રે ભુજગવંશા યૂયમસાધવઃ સન્તઃ કથં સાધુ વાક્યં વક્તું શક્ષ્યથ? યસ્માદ્ અન્તઃકરણસ્ય પૂર્ણભાવાનુસારાદ્ વદનાદ્ વચો નિર્ગચ્છતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","તેન સાધુર્માનવોઽન્તઃકરણરૂપાત્ સાધુભાણ્ડાગારાત્ સાધુ દ્રવ્યં નિર્ગમયતિ, અસાધુર્માનુષસ્ત્વસાધુભાણ્ડાગારાદ્ અસાધુવસ્તૂનિ નિર્ગમયતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","કિન્ત્વહં યુષ્માન્ વદામિ, મનુજા યાવન્ત્યાલસ્યવચાંસિ વદન્તિ, વિચારદિને તદુત્તરમવશ્યં દાતવ્યં, ");
INSERT INTO sanguj_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","યતસ્ત્વં સ્વીયવચોભિ ર્નિરપરાધઃ સ્વીયવચોભિશ્ચ સાપરાધો ગણિષ્યસે| ");
INSERT INTO sanguj_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","તદાનીં કતિપયા ઉપાધ્યાયાઃ ફિરૂશિનશ્ચ જગદુઃ, હે ગુરો વયં ભવત્તઃ કિઞ્ચન લક્ષ્મ દિદૃક્ષામઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","તદા સ પ્રત્યુક્તવાન્, દુષ્ટો વ્યભિચારી ચ વંશો લક્ષ્મ મૃગયતે, કિન્તુ ભવિષ્યદ્વાદિનો યૂનસો લક્ષ્મ વિહાયાન્યત્ કિમપિ લક્ષ્મ તે ન પ્રદર્શયિષ્યન્તે| ");
INSERT INTO sanguj_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","યતો યૂનમ્ યથા ત્ર્યહોરાત્રં બૃહન્મીનસ્ય કુક્ષાવાસીત્, તથા મનુજપુત્રોપિ ત્ર્યહોરાત્રં મેદિન્યા મધ્યે સ્થાસ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","અપરં નીનિવીયા માનવા વિચારદિન એતદ્વંશીયાનાં પ્રતિકૂલમ્ ઉત્થાય તાન્ દોષિણઃ કરિષ્યન્તિ, યસ્માત્તે યૂનસ ઉપદેશાત્ મનાંસિ પરાવર્ત્તયાઞ્ચક્રિરે, કિન્ત્વત્ર યૂનસોપિ ગુરુતર એક આસ્તે| ");
INSERT INTO sanguj_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","પુનશ્ચ દક્ષિણદેશીયા રાજ્ઞી વિચારદિન એતદ્વંશીયાનાં પ્રતિકૂલમુત્થાય તાન્ દોષિણઃ કરિષ્યતિ યતઃ સા રાજ્ઞી સુલેમનો વિદ્યાયાઃ કથાં શ્રોતું મેદિન્યાઃ સીમ્ન આગચ્છત્, કિન્તુ સુલેમનોપિ ગુરુતર એકો જનોઽત્ર આસ્તે| ");
INSERT INTO sanguj_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","અપરં મનુજાદ્ બહિર્ગતો ઽપવિત્રભૂતઃ શુષ્કસ્થાનેન ગત્વા વિશ્રામં ગવેષયતિ, કિન્તુ તદલભમાનઃ સ વક્તિ, યસ્મા; નિકેતનાદ્ આગમં, તદેવ વેશ્મ પકાવૃત્ય યામિ| ");
INSERT INTO sanguj_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","પશ્ચાત્ સ તત્ સ્થાનમ્ ઉપસ્થાય તત્ શૂન્યં માર્જ્જિતં શોભિતઞ્ચ વિલોક્ય વ્રજન્ સ્વતોપિ દુષ્ટતરાન્ અન્યસપ્તભૂતાન્ સઙ્ગિનઃ કરોતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","તતસ્તે તત્ સ્થાનં પ્રવિશ્ય નિવસન્તિ, તેન તસ્ય મનુજસ્ય શેષદશા પૂર્વ્વદશાતોતીવાશુભા ભવતિ, એતેષાં દુષ્ટવંશ્યાનામપિ તથૈવ ઘટિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","માનવેભ્ય એતાસાં કથનાં કથનકાલે તસ્ય માતા સહજાશ્ચ તેન સાકં કાઞ્ચિત્ કથાં કથયિતું વાઞ્છન્તો બહિરેવ સ્થિતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","તતઃ કશ્ચિત્ તસ્મૈ કથિતવાન્, પશ્ય તવ જનની સહજાશ્ચ ત્વયા સાકં કાઞ્ચન કથાં કથયિતું કામયમાના બહિસ્તિષ્ઠન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","કિન્તુ સ તં પ્રત્યવદત્, મમ કા જનની? કે વા મમ સહજાઃ? ");
INSERT INTO sanguj_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","પશ્ચાત્ શિષ્યાન્ પ્રતિ કરં પ્રસાર્ય્ય કથિતવાન્, પશ્ય મમ જનની મમ સહજાશ્ચૈતે; ");
INSERT INTO sanguj_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","યઃ કશ્ચિત્ મમ સ્વર્ગસ્થસ્ય પિતુરિષ્ટં કર્મ્મ કુરુતે, સએવ મમ ભ્રાતા ભગિની જનની ચ| ");
INSERT INTO sanguj_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","અપરઞ્ચ તસ્મિન્ દિને યીશુઃ સદ્મનો ગત્વા સરિત્પતે રોધસિ સમુપવિવેશ| ");
INSERT INTO sanguj_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","તત્ર તત્સન્નિધૌ બહુજનાનાં નિવહોપસ્થિતેઃ સ તરણિમારુહ્ય સમુપાવિશત્, તેન માનવા રોધસિ સ્થિતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","તદાનીં સ દૃષ્ટાન્તૈસ્તાન્ ઇત્થં બહુશ ઉપદિષ્ટવાન્| પશ્યત, કશ્ચિત્ કૃષીવલો બીજાનિ વપ્તું બહિર્જગામ, ");
INSERT INTO sanguj_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","તસ્ય વપનકાલે કતિપયબીજેષુ માર્ગપાર્શ્વે પતિતેષુ વિહગાસ્તાનિ ભક્ષિતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","અપરં કતિપયબીજેષુ સ્તોકમૃદ્યુક્તપાષાણે પતિતેષુ મૃદલ્પત્વાત્ તત્ક્ષણાત્ તાન્યઙ્કુરિતાનિ, ");
INSERT INTO sanguj_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","કિન્તુ રવાવુદિતે દગ્ધાનિ તેષાં મૂલાપ્રવિષ્ટત્વાત્ શુષ્કતાં ગતાનિ ચ| ");
INSERT INTO sanguj_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","અપરં કતિપયબીજેષુ કણ્ટકાનાં મધ્યે પતિતેષુ કણ્ટકાન્યેધિત્વા તાનિ જગ્રસુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","અપરઞ્ચ કતિપયબીજાનિ ઉર્વ્વરાયાં પતિતાનિ; તેષાં મધ્યે કાનિચિત્ શતગુણાનિ કાનિચિત્ ષષ્ટિગુણાનિ કાનિચિત્ ત્રિંશગુંણાનિ ફલાનિ ફલિતવન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","શ્રોતું યસ્ય શ્રુતી આસાતે સ શૃણુયાત્| ");
INSERT INTO sanguj_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","અનન્તરં શિષ્યૈરાગત્ય સોઽપૃચ્છ્યત, ભવતા તેભ્યઃ કુતો દૃષ્ટાન્તકથા કથ્યતે? ");
INSERT INTO sanguj_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","તતઃ સ પ્રત્યવદત્, સ્વર્ગરાજ્યસ્ય નિગૂઢાં કથાં વેદિતું યુષ્મભ્યં સામર્થ્યમદાયિ, કિન્તુ તેભ્યો નાદાયિ| ");
INSERT INTO sanguj_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","યસ્માદ્ યસ્યાન્તિકે વર્દ્ધતે, તસ્માયેવ દાયિષ્યતે, તસ્માત્ તસ્ય બાહુલ્યં ભવિષ્યતિ, કિન્તુ યસ્યાન્તિકે ન વર્દ્ધતે, તસ્ય યત્ કિઞ્ચનાસ્તે, તદપિ તસ્માદ્ આદાયિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","તે પશ્યન્તોપિ ન પશ્યન્તિ, શૃણ્વન્તોપિ ન શૃણ્વન્તિ, બુધ્યમાના અપિ ન બુધ્યન્તે ચ, તસ્માત્ તેભ્યો દૃષ્ટાન્તકથા કથ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","યથા કર્ણૈઃ શ્રોષ્યથ યૂયં વૈ કિન્તુ યૂયં ન ભોત્સ્યથ| નેત્રૈર્દ્રક્ષ્યથ યૂયઞ્ચ પરિજ્ઞાતું ન શક્ષ્યથ| તે માનુષા યથા નૈવ પરિપશ્યન્તિ લોચનૈઃ| કર્ણૈ ર્યથા ન શૃણ્વન્તિ ન બુધ્યન્તે ચ માનસૈઃ| વ્યાવર્ત્તિતેષુ ચિત્તેષુ કાલે કુત્રાપિ તૈર્જનૈઃ| મત્તસ્તે મનુજાઃ સ્વસ્થા યથા નૈવ ભવન્તિ ચ| તથા તેષાં મનુષ્યાણાં ક્રિયન્તે સ્થૂલબુદ્ધયઃ| બધિરીભૂતકર્ણાશ્ચ જાતાશ્ચ મુદ્રિતા દૃશઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","યદેતાનિ વચનાનિ યિશયિયભવિષ્યદ્વાદિના પ્રોક્તાનિ તેષુ તાનિ ફલન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","કિન્તુ યુષ્માકં નયનાનિ ધન્યાનિ, યસ્માત્ તાનિ વીક્ષન્તે; ધન્યાશ્ચ યુષ્માકં શબ્દગ્રહાઃ, યસ્માત્ તૈરાકર્ણ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","મયા યૂયં તથ્યં વચામિ યુષ્માભિ ર્યદ્યદ્ વીક્ષ્યતે, તદ્ બહવો ભવિષ્યદ્વાદિનો ધાર્મ્મિકાશ્ચ માનવા દિદૃક્ષન્તોપિ દ્રષ્ટું નાલભન્ત, પુનશ્ચ યૂયં યદ્યત્ શૃણુથ, તત્ તે શુશ્રૂષમાણા અપિ શ્રોતું નાલભન્ત| ");
INSERT INTO sanguj_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","કૃષીવલીયદૃષ્ટાન્તસ્યાર્થં શૃણુત| ");
INSERT INTO sanguj_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","માર્ગપાર્શ્વે બીજાન્યુપ્તાનિ તસ્યાર્થ એષઃ, યદા કશ્ચિત્ રાજ્યસ્ય કથાં નિશમ્ય ન બુધ્યતે, તદા પાપાત્માગત્ય તદીયમનસ ઉપ્તાં કથાં હરન્ નયતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","અપરં પાષાણસ્થલે બીજાન્યુપ્તાનિ તસ્યાર્થ એષઃ; કશ્ચિત્ કથાં શ્રુત્વૈવ હર્ષચિત્તેન ગૃહ્લાતિ, ");
INSERT INTO sanguj_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","કિન્તુ તસ્ય મનસિ મૂલાપ્રવિષ્ટત્વાત્ સ કિઞ્ચિત્કાલમાત્રં સ્થિરસ્તિષ્ઠતિ; પશ્ચાત તત્કથાકારણાત્ કોપિ ક્લેસ્તાડના વા ચેત્ જાયતે, તર્હિ સ તત્ક્ષણાદ્ વિઘ્નમેતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","અપરં કણ્ટકાનાં મધ્યે બીજાન્યુપ્તાનિ તદર્થ એષઃ; કેનચિત્ કથાયાં શ્રુતાયાં સાંસારિકચિન્તાભિ ર્ભ્રાન્તિભિશ્ચ સા ગ્રસ્યતે, તેન સા મા વિફલા ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","અપરમ્ ઉર્વ્વરાયાં બીજાન્યુપ્તાનિ તદર્થ એષઃ; યે તાં કથાં શ્રુત્વા વુધ્યન્તે, તે ફલિતાઃ સન્તઃ કેચિત્ શતગુણાનિ કેચિત ષષ્ટિગુણાનિ કેચિચ્ચ ત્રિંશદ્ગુણાનિ ફલાનિ જનયન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","અનન્તરં સોપરામેકાં દૃષ્ટાન્તકથામુપસ્થાપ્ય તેભ્યઃ કથયામાસ; સ્વર્ગીયરાજ્યં તાદૃશેન કેનચિદ્ ગૃહસ્થેનોપમીયતે, યેન સ્વીયક્ષેત્રે પ્રશસ્તબીજાન્યૌપ્યન્ત| ");
INSERT INTO sanguj_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","કિન્તુ ક્ષણદાયાં સકલલોકેષુ સુપ્તેષુ તસ્ય રિપુરાગત્ય તેષાં ગોધૂમબીજાનાં મધ્યે વન્યયવમબીજાન્યુપ્ત્વા વવ્રાજ| ");
INSERT INTO sanguj_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","તતો યદા બીજેભ્યોઽઙ્કરા જાયમાનાઃ કણિશાનિ ઘૃતવન્તઃ; તદા વન્યયવસાન્યપિ દૃશ્યમાનાન્યભવન્| ");
INSERT INTO sanguj_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","તતો ગૃહસ્થસ્ય દાસેયા આગમ્ય તસ્મૈ કથયાઞ્ચક્રુઃ, હે મહેચ્છ, ભવતા કિં ક્ષેત્રે ભદ્રબીજાનિ નૌપ્યન્ત? તથાત્વે વન્યયવસાનિ કૃત આયન્? ");
INSERT INTO sanguj_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","તદાનીં તેન તે પ્રતિગદિતાઃ, કેનચિત્ રિપુણા કર્મ્મદમકારિ| દાસેયાઃ કથયામાસુઃ, વયં ગત્વા તાન્યુત્પાય્ય ક્ષિપામો ભવતઃ કીદૃશીચ્છા જાયતે? ");
INSERT INTO sanguj_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","તેનાવાદિ, નહિ, શઙ્કેઽહં વન્યયવસોત્પાટનકાલે યુષ્માભિસ્તૈઃ સાકં ગોધૂમા અપ્યુત્પાટિષ્યન્તે| ");
INSERT INTO sanguj_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","અતઃ શ્સ્યકર્ત્તનકાલં યાવદ્ ઉભયાન્યપિ સહ વર્દ્ધન્તાં, પશ્ચાત્ કર્ત્તનકાલે કર્ત્તકાન્ વક્ષ્યામિ, યૂયમાદૌ વન્યયવસાનિ સંગૃહ્ય દાહયિતું વીટિકા બદ્વ્વા સ્થાપયત; કિન્તુ સર્વ્વે ગોધૂમા યુષ્માભિ ર્ભાણ્ડાગારં નીત્વા સ્થાપ્યન્તામ્| ");
INSERT INTO sanguj_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","અનન્તરં સોપરામેકાં દૃષ્ટાન્તકથામુત્થાપ્ય તેભ્યઃ કથિતવાન્ કશ્ચિન્મનુજઃ સર્ષપબીજમેકં નીત્વા સ્વક્ષેત્ર ઉવાપ| ");
INSERT INTO sanguj_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","સર્ષપબીજં સર્વ્વસ્માદ્ બીજાત્ ક્ષુદ્રમપિ સદઙ્કુરિતં સર્વ્વસ્માત્ શાકાત્ બૃહદ્ ભવતિ; સ તાદૃશસ્તરુ ર્ભવતિ, યસ્ય શાખાસુ નભસઃ ખગા આગત્ય નિવસન્તિ; સ્વર્ગીયરાજ્યં તાદૃશસ્ય સર્ષપૈકસ્ય સમમ્| ");
INSERT INTO sanguj_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","પુનરપિ સ ઉપમાકથામેકાં તેભ્યઃ કથયાઞ્ચકાર; કાચન યોષિત્ યત્ કિણ્વમાદાય દ્રોણત્રયમિતગોધૂમચૂર્ણાનાં મધ્યે સર્વ્વેષાં મિશ્રીભવનપર્ય્યન્તં સમાચ્છાદ્ય નિધત્તવતી, તત્કિણ્વમિવ સ્વર્ગરાજ્યં| ");
INSERT INTO sanguj_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ઇત્થં યીશુ ર્મનુજનિવહાનાં સન્નિધાવુપમાકથાભિરેતાન્યાખ્યાનાનિ કથિતવાન્ ઉપમાં વિના તેભ્યઃ કિમપિ કથાં નાકથયત્| ");
INSERT INTO sanguj_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","એતેન દૃષ્ટાન્તીયેન વાક્યેન વ્યાદાય વદનં નિજં| અહં પ્રકાશયિષ્યામિ ગુપ્તવાક્યં પુરાભવં| યદેતદ્વચનં ભવિષ્યદ્વાદિના પ્રોક્તમાસીત્, તત્ સિદ્ધમભવત્| ");
INSERT INTO sanguj_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","સર્વ્વાન્ મનુજાન્ વિસૃજ્ય યીશૌ ગૃહં પ્રવિષ્ટે તચ્છિષ્યા આગત્ય યીશવે કથિતવન્તઃ, ક્ષેત્રસ્ય વન્યયવસીયદૃષ્ટાન્તકથામ્ ભવાન અસ્માન્ સ્પષ્ટીકૃત્ય વદતુ| ");
INSERT INTO sanguj_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","તતઃ સ પ્રત્યુવાચ, યેન ભદ્રબીજાન્યુપ્યન્તે સ મનુજપુત્રઃ, ");
INSERT INTO sanguj_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ક્ષેત્રં જગત્, ભદ્રબીજાની રાજ્યસ્ય સન્તાનાઃ, ");
INSERT INTO sanguj_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","વન્યયવસાનિ પાપાત્મનઃ સન્તાનાઃ| યેન રિપુણા તાન્યુપ્તાનિ સ શયતાનઃ, કર્ત્તનસમયશ્ચ જગતઃ શેષઃ, કર્ત્તકાઃ સ્વર્ગીયદૂતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","યથા વન્યયવસાનિ સંગૃહ્ય દાહ્યન્તે, તથા જગતઃ શેષે ભવિષ્યતિ; ");
INSERT INTO sanguj_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","અર્થાત્ મનુજસુતઃ સ્વાંયદૂતાન્ પ્રેષયિષ્યતિ, તેન તે ચ તસ્ય રાજ્યાત્ સર્વ્વાન્ વિઘ્નકારિણોઽધાર્મ્મિકલોકાંશ્ચ સંગૃહ્ય ");
INSERT INTO sanguj_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","યત્ર રોદનં દન્તઘર્ષણઞ્ચ ભવતિ, તત્રાગ્નિકુણ્ડે નિક્ષેપ્સ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","તદાનીં ધાર્મ્મિકલોકાઃ સ્વેષાં પિતૂ રાજ્યે ભાસ્કરઇવ તેજસ્વિનો ભવિષ્યન્તિ| શ્રોતું યસ્ય શ્રુતી આસાતે, મ શૃણુયાત્| ");
INSERT INTO sanguj_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","અપરઞ્ચ ક્ષેત્રમધ્યે નિધિં પશ્યન્ યો ગોપયતિ, તતઃ પરં સાનન્દો ગત્વા સ્વીયસર્વ્વસ્વં વિક્રીય ત્તક્ષેત્રં ક્રીણાતિ, સ ઇવ સ્વર્ગરાજ્યં| ");
INSERT INTO sanguj_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","અન્યઞ્ચ યો વણિક્ ઉત્તમાં મુક્તાં ગવેષયન્ ");
INSERT INTO sanguj_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","મહાર્ઘાં મુક્તાં વિલોક્ય નિજસર્વ્વસ્વં વિક્રીય તાં ક્રીણાતિ, સ ઇવ સ્વર્ગરાજ્યં| ");
INSERT INTO sanguj_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","પુનશ્ચ સમુદ્રો નિક્ષિપ્તઃ સર્વ્વપ્રકારમીનસંગ્રાહ્યાનાયઇવ સ્વર્ગરાજ્યં| ");
INSERT INTO sanguj_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","તસ્મિન્ આનાયે પૂર્ણે જના યથા રોધસ્યુત્તોલ્ય સમુપવિશ્ય પ્રશસ્તમીનાન્ સંગ્રહ્ય ભાજનેષુ નિદધતે, કુત્સિતાન્ નિક્ષિપન્તિ; ");
INSERT INTO sanguj_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","તથૈવ જગતઃ શેષે ભવિષ્યતિ, ફલતઃ સ્વર્ગીયદૂતા આગત્ય પુણ્યવજ્જનાનાં મધ્યાત્ પાપિનઃ પૃથક્ કૃત્વા વહ્નિકુણ્ડે નિક્ષેપ્સ્યન્તિ, ");
INSERT INTO sanguj_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","તત્ર રોદનં દન્તૈ ર્દન્તઘર્ષણઞ્ચ ભવિષ્યતઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","યીશુના તે પૃષ્ટા યુષ્માભિઃ કિમેતાન્યાખ્યાનાન્યબુધ્યન્ત? તદા તે પ્રત્યવદન્, સત્યં પ્રભો| ");
INSERT INTO sanguj_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","તદાનીં સ કથિતવાન્, નિજભાણ્ડાગારાત્ નવીનપુરાતનાનિ વસ્તૂનિ નિર્ગમયતિ યો ગૃહસ્થઃ સ ઇવ સ્વર્ગરાજ્યમધિ શિક્ષિતાઃ સ્વર્વ ઉપદેષ્ટારઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","અનન્તરં યીશુરેતાઃ સર્વ્વા દૃષ્ટાન્તકથાઃ સમાપ્ય તસ્માત્ સ્થાનાત્ પ્રતસ્થે| અપરં સ્વદેશમાગત્ય જનાન્ ભજનભવન ઉપદિષ્ટવાન્; ");
INSERT INTO sanguj_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","તે વિસ્મયં ગત્વા કથિતવન્ત એતસ્યૈતાદૃશં જ્ઞાનમ્ આશ્ચર્ય્યં કર્મ્મ ચ કસ્માદ્ અજાયત? ");
INSERT INTO sanguj_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","કિમયં સૂત્રધારસ્ય પુત્રો નહિ? એતસ્ય માતુ ર્નામ ચ કિં મરિયમ્ નહિ? યાકુબ્-યૂષફ્-શિમોન્-યિહૂદાશ્ચ કિમેતસ્ય ભ્રાતરો નહિ? ");
INSERT INTO sanguj_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","એતસ્ય ભગિન્યશ્ચ કિમસ્માકં મધ્યે ન સન્તિ? તર્હિ કસ્માદયમેતાનિ લબ્ધવાન્? ઇત્થં સ તેષાં વિઘ્નરૂપો બભૂવ; ");
INSERT INTO sanguj_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","તતો યીશુના નિગદિતં સ્વદેશીયજનાનાં મધ્યં વિના ભવિષ્યદ્વાદી કુત્રાપ્યન્યત્ર નાસમ્માન્યો ભવતી| ");
INSERT INTO sanguj_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","તેષામવિશ્વાસહેતોઃ સ તત્ર સ્થાને બહ્વાશ્ચર્ય્યકર્મ્માણિ ન કૃતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","તદાનીં રાજા હેરોદ્ યીશો ર્યશઃ શ્રુત્વા નિજદાસેયાન્ જગાદ્, ");
INSERT INTO sanguj_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","એષ મજ્જયિતા યોહન્, પ્રમિતેભયસ્તસ્યોત્થાનાત્ તેનેત્થમદ્ભુતં કર્મ્મ પ્રકાશ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","પુરા હેરોદ્ નિજભ્રાતુ: ફિલિપો જાયાયા હેરોદીયાયા અનુરોધાદ્ યોહનં ધારયિત્વા બદ્ધા કારાયાં સ્થાપિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","યતો યોહન્ ઉક્તવાન્, એત્સયાઃ સંગ્રહો ભવતો નોચિતઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","તસ્માત્ નૃપતિસ્તં હન્તુમિચ્છન્નપિ લોકેભ્યો વિભયાઞ્ચકાર; યતઃ સર્વ્વે યોહનં ભવિષ્યદ્વાદિનં મેનિરે| ");
INSERT INTO sanguj_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","કિન્તુ હેરોદો જન્માહીયમહ ઉપસ્થિતે હેરોદીયાયા દુહિતા તેષાં સમક્ષં નૃતિત્વા હેરોદમપ્રીણ્યત્| ");
INSERT INTO sanguj_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","તસ્માત્ ભૂપતિઃ શપથં કુર્વ્વન્ ઇતિ પ્રત્યજ્ઞાસીત્, ત્વયા યદ્ યાચ્યતે, તદેવાહં દાસ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","સા કુમારી સ્વીયમાતુઃ શિક્ષાં લબ્ધા બભાષે, મજ્જયિતુર્યોહન ઉત્તમાઙ્ગં ભાજને સમાનીય મહ્યં વિશ્રાણય| ");
INSERT INTO sanguj_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","તતો રાજા શુશોચ, કિન્તુ ભોજનાયોપવિશતાં સઙ્ગિનાં સ્વકૃતશપથસ્ય ચાનુરોધાત્ તત્ પ્રદાતુમ આદિદેશ| ");
INSERT INTO sanguj_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","પશ્ચાત્ કારાં પ્રતિ નરં પ્રહિત્ય યોહન ઉત્તમાઙ્ગં છિત્ત્વા ");
INSERT INTO sanguj_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","તત્ ભાજન આનાય્ય તસ્યૈ કુમાર્ય્યૈ વ્યશ્રાણયત્, તતઃ સા સ્વજનન્યાઃ સમીપં તન્નિનાય| ");
INSERT INTO sanguj_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","પશ્ચાત્ યોહનઃ શિષ્યા આગત્ય કાયં નીત્વા શ્મશાને સ્થાપયામાસુસ્તતો યીશોઃ સન્નિધિં વ્રજિત્વા તદ્વાર્ત્તાં બભાષિરે| ");
INSERT INTO sanguj_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","અનન્તરં યીશુરિતિ નિશભ્ય નાવા નિર્જનસ્થાનમ્ એકાકી ગતવાન્, પશ્ચાત્ માનવાસ્તત્ શ્રુત્વા નાનાનગરેભ્ય આગત્ય પદૈસ્તત્પશ્ચાદ્ ઈયુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","તદાનીં યીશુ ર્બહિરાગત્ય મહાન્તં જનનિવહં નિરીક્ષ્ય તેષુ કારુણિકઃ મન્ તેષાં પીડિતજનાન્ નિરામયાન્ ચકાર| ");
INSERT INTO sanguj_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","તતઃ પરં સન્ધ્યાયાં શિષ્યાસ્તદન્તિકમાગત્ય કથયાઞ્ચક્રુઃ, ઇદં નિર્જનસ્થાનં વેલાપ્યવસન્ના; તસ્માત્ મનુજાન્ સ્વસ્વગ્રામં ગન્તું સ્વાર્થં ભક્ષ્યાણિ ક્રેતુઞ્ચ ભવાન્ તાન્ વિસૃજતુ| ");
INSERT INTO sanguj_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","કિન્તુ યીશુસ્તાનવાદીત્, તેષાં ગમને પ્રયોજનં નાસ્તિ, યૂયમેવ તાન્ ભોજયત| ");
INSERT INTO sanguj_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","તદા તે પ્રત્યવદન્, અસ્માકમત્ર પૂપપઞ્ચકં મીનદ્વયઞ્ચાસ્તે| ");
INSERT INTO sanguj_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","તદાનીં તેનોક્તં તાનિ મદન્તિકમાનયત| ");
INSERT INTO sanguj_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","અનન્તરં સ મનુજાન્ યવસોપર્ય્યુપવેષ્ટુમ્ આજ્ઞાપયામાસ; અપર તત્ પૂપપઞ્ચકં મીનદ્વયઞ્ચ ગૃહ્લન્ સ્વર્ગં પ્રતિ નિરીક્ષ્યેશ્વરીયગુણાન્ અનૂદ્ય ભંક્ત્વા શિષ્યેભ્યો દત્તવાન્, શિષ્યાશ્ચ લોકેભ્યો દદુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","તતઃ સર્વ્વે ભુક્ત્વા પરિતૃપ્તવન્તઃ, તતસ્તદવશિષ્ટભક્ષ્યૈઃ પૂર્ણાન્ દ્વાદશડલકાન્ ગૃહીતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","તે ભોક્તારઃ સ્ત્રીર્બાલકાંશ્ચ વિહાય પ્રાયેણ પઞ્ચ સહસ્રાણિ પુમાંસ આસન્| ");
INSERT INTO sanguj_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","તદનન્તરં યીશુ ર્લોકાનાં વિસર્જનકાલે શિષ્યાન્ તરણિમારોઢું સ્વાગ્રે પારં યાતુઞ્ચ ગાઢમાદિષ્ટવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","તતો લોકેષુ વિસૃષ્ટેષુ સ વિવિક્તે પ્રાર્થયિતું ગિરિમેકં ગત્વા સન્ધ્યાં યાવત્ તત્રૈકાકી સ્થિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","કિન્તુ તદાનીં સમ્મુખવાતત્વાત્ સરિત્પતે ર્મધ્યે તરઙ્ગૈસ્તરણિર્દોલાયમાનાભવત્| ");
INSERT INTO sanguj_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","તદા સ યામિન્યાશ્ચતુર્થપ્રહરે પદ્ભ્યાં વ્રજન્ તેષામન્તિકં ગતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","કિન્તુ શિષ્યાસ્તં સાગરોપરિ વ્રજન્તં વિલોક્ય સમુદ્વિગ્ના જગદુઃ, એષ ભૂત ઇતિ શઙ્કમાના ઉચ્ચૈઃ શબ્દાયાઞ્ચક્રિરે ચ| ");
INSERT INTO sanguj_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","તદૈવ યીશુસ્તાનવદત્, સુસ્થિરા ભવત, મા ભૈષ્ટ, એષોઽહમ્| ");
INSERT INTO sanguj_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","તતઃ પિતર ઇત્યુક્તવાન્, હે પ્રભો, યદિ ભવાનેવ, તર્હિ માં ભવત્સમીપં યાતુમાજ્ઞાપયતુ| ");
INSERT INTO sanguj_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","તતઃ તેનાદિષ્ટઃ પિતરસ્તરણિતોઽવરુહ્ય યીશેाરન્તિકં પ્રાપ્તું તોયોપરિ વવ્રાજ| ");
INSERT INTO sanguj_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","કિન્તુ પ્રચણ્ડં પવનં વિલોક્ય ભયાત્ તોયે મંક્તુમ્ આરેભે, તસ્માદ્ ઉચ્ચૈઃ શબ્દાયમાનઃ કથિતવાન્, હે પ્રભો, મામવતુ| ");
INSERT INTO sanguj_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","યીશુસ્તત્ક્ષણાત્ કરં પ્રસાર્ય્ય તં ધરન્ ઉક્તવાન્, હ સ્તોકપ્રત્યયિન્ ત્વં કુતઃ સમશેથાઃ? ");
INSERT INTO sanguj_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","અનન્તરં તયોસ્તરણિમારૂઢયોઃ પવનો નિવવૃતે| ");
INSERT INTO sanguj_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","તદાનીં યે તરણ્યામાસન્, ત આગત્ય તં પ્રણભ્ય કથિતવન્તઃ, યથાર્થસ્ત્વમેવેશ્વરસુતઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","અનન્તરં પારં પ્રાપ્ય તે ગિનેષરન્નામકં નગરમુપતસ્થુઃ, ");
INSERT INTO sanguj_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","તદા તત્રત્યા જના યીશું પરિચીય તદ્દેશ્સ્ય ચતુર્દિશો વાર્ત્તાં પ્રહિત્ય યત્ર યાવન્તઃ પીડિતા આસન્, તાવતએવ તદન્તિકમાનયામાસુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","અપરં તદીયવસનસ્ય ગ્રન્થિમાત્રં સ્પ્રષ્ટું વિનીય યાવન્તો જનાસ્તત્ સ્પર્શં ચક્રિરે, તે સર્વ્વએવ નિરામયા બભૂવુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","અપરં યિરૂશાલમ્નગરીયાઃ કતિપયા અધ્યાપકાઃ ફિરૂશિનશ્ચ યીશોઃ સમીપમાગત્ય કથયામાસુઃ, ");
INSERT INTO sanguj_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","તવ શિષ્યાઃ કિમર્થમ્ અપ્રક્ષાલિતકરૈ ર્ભક્ષિત્વા પરમ્પરાગતં પ્રાચીનાનાં વ્યવહારં લઙ્વન્તે? ");
INSERT INTO sanguj_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","તતો યીશુઃ પ્રત્યુવાચ, યૂયં પરમ્પરાગતાચારેણ કુત ઈશ્વરાજ્ઞાં લઙ્વધ્વે| ");
INSERT INTO sanguj_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ઈશ્વર ઇત્યાજ્ઞાપયત્, ત્વં નિજપિતરૌ સંમન્યેથાઃ, યેન ચ નિજપિતરૌ નિન્દ્યેતે, સ નિશ્ચિતં મ્રિયેત; ");
INSERT INTO sanguj_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","કિન્તુ યૂયં વદથ, યઃ સ્વજનકં સ્વજનનીં વા વાક્યમિદં વદતિ, યુવાં મત્તો યલ્લભેથે, તત્ ન્યવિદ્યત, ");
INSERT INTO sanguj_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","સ નિજપિતરૌ પુન ર્ન સંમંસ્યતે| ઇત્થં યૂયં પરમ્પરાગતેન સ્વેષામાચારેણેશ્વરીયાજ્ઞાં લુમ્પથ| ");
INSERT INTO sanguj_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","રે કપટિનઃ સર્વ્વે યિશયિયો યુષ્માનધિ ભવિષ્યદ્વચનાન્યેતાનિ સમ્યગ્ ઉક્તવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","વદનૈ ર્મનુજા એતે સમાયાન્તિ મદન્તિકં| તથાધરૈ ર્મદીયઞ્ચ માનં કુર્વ્વન્તિ તે નરાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","કિન્તુ તેષાં મનો મત્તો વિદૂરએવ તિષ્ઠતિ| શિક્ષયન્તો વિધીન્ ન્રાજ્ઞા ભજન્તે માં મુધૈવ તે| ");
INSERT INTO sanguj_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","તતો યીશુ ર્લોકાન્ આહૂય પ્રોક્તવાન્, યૂયં શ્રુત્વા બુધ્યધ્બં| ");
INSERT INTO sanguj_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","યન્મુખં પ્રવિશતિ, તત્ મનુજમ્ અમેધ્યં ન કરોતિ, કિન્તુ યદાસ્યાત્ નિર્ગચ્છતિ, તદેવ માનુષમમેધ્યી કરોતી| ");
INSERT INTO sanguj_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","તદાનીં શિષ્યા આગત્ય તસ્મૈ કથયાઞ્ચક્રુઃ, એતાં કથાં શ્રુત્વા ફિરૂશિનો વ્યરજ્યન્ત, તત્ કિં ભવતા જ્ઞાયતે? ");
INSERT INTO sanguj_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","સ પ્રત્યવદત્, મમ સ્વર્ગસ્થઃ પિતા યં કઞ્ચિદઙ્કુરં નારોપયત્, સ ઉત્પાવ્દ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","તે તિષ્ઠન્તુ, તે અન્ધમનુજાનામ્ અન્ધમાર્ગદર્શકા એવ; યદ્યન્ધોઽન્ધં પન્થાનં દર્શયતિ, તર્હ્યુભૌ ગર્ત્તે પતતઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","તદા પિતરસ્તં પ્રત્યવદત્, દૃષ્ટાન્તમિમમસ્માન્ બોધયતુ| ");
INSERT INTO sanguj_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","યીશુના પ્રોક્તં, યૂયમદ્ય યાવત્ કિમબોધાઃ સ્થ? ");
INSERT INTO sanguj_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","કથામિમાં કિં ન બુધ્યધ્બે ? યદાસ્યં પ્રેવિશતિ, તદ્ ઉદરે પતન્ બહિર્નિર્યાતિ, ");
INSERT INTO sanguj_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","કિન્ત્વાસ્યાદ્ યન્નિર્યાતિ, તદ્ અન્તઃકરણાત્ નિર્યાતત્વાત્ મનુજમમેધ્યં કરોતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","યતોઽન્તઃકરણાત્ કુચિન્તા બધઃ પારદારિકતા વેશ્યાગમનં ચૈર્ય્યં મિથ્યાસાક્ષ્યમ્ ઈશ્વરનિન્દા ચૈતાનિ સર્વ્વાણિ નિર્ય્યાન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","એતાનિ મનુષ્યમપવિત્રી કુર્વ્વન્તિ કિન્ત્વપ્રક્ષાલિતકરેણ ભોજનં મનુજમમેધ્યં ન કરોતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","અનન્તરં યીશુસ્તસ્માત્ સ્થાનાત્ પ્રસ્થાય સોરસીદોન્નગરયોઃ સીમામુપતસ્યૌ| ");
INSERT INTO sanguj_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","તદા તત્સીમાતઃ કાચિત્ કિનાનીયા યોષિદ્ આગત્ય તમુચ્ચૈરુવાચ, હે પ્રભો દાયૂદઃ સન્તાન, મમૈકા દુહિતાસ્તે સા ભૂતગ્રસ્તા સતી મહાક્લેશં પ્રાપ્નોતિ મમ દયસ્વ| ");
INSERT INTO sanguj_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","કિન્તુ યીશુસ્તાં કિમપિ નોક્તવાન્, તતઃ શિષ્યા આગત્ય તં નિવેદયામાસુઃ, એષા યોષિદ્ અસ્માકં પશ્ચાદ્ ઉચ્ચૈરાહૂયાગચ્છતિ, એનાં વિસૃજતુ| ");
INSERT INTO sanguj_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","તદા સ પ્રત્યવદત્, ઇસ્રાયેલ્ગોત્રસ્ય હારિતમેષાન્ વિના કસ્યાપ્યન્યસ્ય સમીપં નાહં પ્રેષિતોસ્મિ| ");
INSERT INTO sanguj_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","તતઃ સા નારીસમાગત્ય તં પ્રણમ્ય જગાદ, હે પ્રભો મામુપકુરુ| ");
INSERT INTO sanguj_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","સ ઉક્તવાન્, બાલકાનાં ભક્ષ્યમાદાય સારમેયેભ્યો દાનં નોચિતં| ");
INSERT INTO sanguj_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","તદા સા બભાષે, હે પ્રભો, તત્ સત્યં, તથાપિ પ્રભો ર્ભઞ્ચાદ્ યદુચ્છિષ્ટં પતતિ, તત્ સારમેયાઃ ખાદન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","તતો યીશુઃ પ્રત્યવદત્, હે યોષિત્, તવ વિશ્વાસો મહાન્ તસ્માત્ તવ મનોભિલષિતં સિદ્ય્યતુ, તેન તસ્યાઃ કન્યા તસ્મિન્નેવ દણ્ડે નિરામયાભવત્| ");
INSERT INTO sanguj_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","અનન્તરં યીશસ્તસ્માત્ સ્થાનાત્ પ્રસ્થાય ગાલીલ્સાગરસ્ય સન્નિધિમાગત્ય ધરાધરમારુહ્ય તત્રોપવિવેશ| ");
INSERT INTO sanguj_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","પશ્ચાત્ જનનિવહો બહૂન્ ખઞ્ચાન્ધમૂકશુષ્કકરમાનુષાન્ આદાય યીશોઃ સમીપમાગત્ય તચ્ચરણાન્તિકે સ્થાપયામાસુઃ, તતઃ સા તાન્ નિરામયાન્ અકરોત્| ");
INSERT INTO sanguj_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ઇત્થં મૂકા વાક્યં વદન્તિ, શુષ્કકરાઃ સ્વાસ્થ્યમાયાન્તિ, પઙ્ગવો ગચ્છન્તિ, અન્ધા વીક્ષન્તે, ઇતિ વિલોક્ય લોકા વિસ્મયં મન્યમાના ઇસ્રાયેલ ઈશ્વરં ધન્યં બભાષિરે| ");
INSERT INTO sanguj_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","તદાનીં યીશુઃ સ્વશિષ્યાન્ આહૂય ગદિતવાન્, એતજ્જનનિવહેષુ મમ દયા જાયતે, એતે દિનત્રયં મયા સાકં સન્તિ, એષાં ભક્ષ્યવસ્તુ ચ કઞ્ચિદપિ નાસ્તિ, તસ્માદહમેતાનકૃતાહારાન્ ન વિસ્રક્ષ્યામિ, તથાત્વે વર્ત્મમધ્યે ક્લામ્યેષુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","તદા શિષ્યા ઊચુઃ, એતસ્મિન્ પ્રાન્તરમધ્ય એતાવતો મર્ત્યાન્ તર્પયિતું વયં કુત્ર પૂપાન્ પ્રાપ્સ્યામઃ? ");
INSERT INTO sanguj_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","યીશુરપૃચ્છત્, યુષ્માકં નિકટે કતિ પૂપા આસતે? ત ઊચુઃ, સપ્તપૂપા અલ્પાઃ ક્ષુદ્રમીનાશ્ચ સન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","તદાનીં સ લોકનિવહં ભૂમાવુપવેષ્ટુમ્ આદિશ્ય ");
INSERT INTO sanguj_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","તાન્ સપ્તપૂપાન્ મીનાંશ્ચ ગૃહ્લન્ ઈશ્વરીયગુણાન્ અનૂદ્ય ભંક્ત્વા શિષ્યેભ્યો દદૌ, શિષ્યા લોકેભ્યો દદુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","તતઃ સર્વ્વે ભુક્ત્વા તૃપ્તવન્તઃ; તદવશિષ્ટભક્ષ્યેણ સપ્તડલકાન્ પરિપૂર્ય્ય સંજગૃહુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","તે ભોક્તારો યોષિતો બાલકાંશ્ચ વિહાય પ્રાયેણ ચતુઃસહસ્રાણિ પુરુષા આસન્| ");
INSERT INTO sanguj_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","તતઃ પરં સ જનનિવહં વિસૃજ્ય તરિમારુહ્ય મગ્દલાપ્રદેશં ગતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","તદાનીં ફિરૂશિનઃ સિદૂકિનશ્ચાગત્ય તં પરીક્ષિતું નભમીયં કિઞ્ચન લક્ષ્મ દર્શયિતું તસ્મૈ નિવેદયામાસુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","તતઃ સ ઉક્તવાન્, સન્ધ્યાયાં નભસો રક્તત્વાદ્ યૂયં વદથ, શ્વો નિર્મ્મલં દિનં ભવિષ્યતિ; ");
INSERT INTO sanguj_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","પ્રાતઃકાલે ચ નભસો રક્તત્વાત્ મલિનત્વાઞ્ચ વદથ, ઝઞ્ભ્શદ્ય ભવિષ્યતિ| હે કપટિનો યદિ યૂયમ્ અન્તરીક્ષસ્ય લક્ષ્મ બોદ્ધું શક્નુથ, તર્હિ કાલસ્યૈતસ્ય લક્ષ્મ કથં બોદ્ધું ન શક્નુથ? ");
INSERT INTO sanguj_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","એતત્કાલસ્ય દુષ્ટો વ્યભિચારી ચ વંશો લક્ષ્મ ગવેષયતિ, કિન્તુ યૂનસો ભવિષ્યદ્વાદિનો લક્ષ્મ વિનાન્યત્ કિમપિ લક્ષ્મ તાન્ ન દર્શયિય્યતે| તદાનીં સ તાન્ વિહાય પ્રતસ્થે| ");
INSERT INTO sanguj_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","અનન્તરમન્યપારગમનકાલે તસ્ય શિષ્યાઃ પૂપમાનેતું વિસ્મૃતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","યીશુસ્તાનવાદીત્, યૂયં ફિરૂશિનાં સિદૂકિનાઞ્ચ કિણ્વં પ્રતિ સાવધાનાઃ સતર્કાશ્ચ ભવત| ");
INSERT INTO sanguj_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","તેન તે પરસ્પરં વિવિચ્ય કથયિતુમારેભિરે, વયં પૂપાનાનેતું વિસ્મૃતવન્ત એતત્કારણાદ્ ઇતિ કથયતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","કિન્તુ યીશુસ્તદ્વિજ્ઞાય તાનવોચત્, હે સ્તોકવિશ્વાસિનો યૂયં પૂપાનાનયનમધિ કુતઃ પરસ્પરમેતદ્ વિવિંક્ય? ");
INSERT INTO sanguj_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","યુષ્માભિઃ કિમદ્યાપિ ન જ્ઞાયતે? પઞ્ચભિઃ પૂપૈઃ પઞ્ચસહસ્રપુરુષેષુ ભોજિતેષુ ભક્ષ્યોચ્છિષ્ટપૂર્ણાન્ કતિ ડલકાન્ સમગૃહ્લીતં; ");
INSERT INTO sanguj_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","તથા સપ્તભિઃ પૂપૈશ્ચતુઃસહસ્રપુરુષેષુ ભેજિતેષુ કતિ ડલકાન્ સમગૃહ્લીત, તત્ કિં યુષ્માભિર્ન સ્મર્ય્યતે? ");
INSERT INTO sanguj_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","તસ્માત્ ફિરૂશિનાં સિદૂકિનાઞ્ચ કિણ્વં પ્રતિ સાવધાનાસ્તિષ્ઠત, કથામિમામ્ અહં પૂપાનધિ નાકથયં, એતદ્ યૂયં કુતો ન બુધ્યધ્વે? ");
INSERT INTO sanguj_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","તદાનીં પૂપકિણ્વં પ્રતિ સાવધાનાસ્તિષ્ઠતેતિ નોક્ત્વા ફિરૂશિનાં સિદૂકિનાઞ્ચ ઉપદેશં પ્રતિ સાવધાનાસ્તિષ્ઠતેતિ કથિતવાન્, ઇતિ તૈરબોધિ| ");
INSERT INTO sanguj_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","અપરઞ્ચ યીશુઃ કૈસરિયા-ફિલિપિપ્રદેશમાગત્ય શિષ્યાન્ અપૃચ્છત્, યોઽહં મનુજસુતઃ સોઽહં કઃ? લોકૈરહં કિમુચ્યે? ");
INSERT INTO sanguj_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","તદાનીં તે કથિતવન્તઃ, કેચિદ્ વદન્તિ ત્વં મજ્જયિતા યોહન્, કેચિદ્વદન્તિ, ત્વમ્ એલિયઃ, કેચિચ્ચ વદન્તિ, ત્વં યિરિમિયો વા કશ્ચિદ્ ભવિષ્યદ્વાદીતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","પશ્ચાત્ સ તાન્ પપ્રચ્છ, યૂયં માં કં વદથ? તતઃ શિમોન્ પિતર ઉવાચ, ");
INSERT INTO sanguj_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ત્વમમરેશ્વરસ્યાભિષિક્તપુત્રઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","તતો યીશુઃ કથિતવાન્, હે યૂનસઃ પુત્ર શિમોન્ ત્વં ધન્યઃ; યતઃ કોપિ અનુજસ્ત્વય્યેતજ્જ્ઞાનં નોદપાદયત્, કિન્તુ મમ સ્વર્ગસ્યઃ પિતોદપાદયત્| ");
INSERT INTO sanguj_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","અતોઽહં ત્વાં વદામિ, ત્વં પિતરઃ (પ્રસ્તરઃ) અહઞ્ચ તસ્ય પ્રસ્તરસ્યોપરિ સ્વમણ્ડલીં નિર્મ્માસ્યામિ, તેન નિરયો બલાત્ તાં પરાજેતું ન શક્ષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","અહં તુભ્યં સ્વર્ગીયરાજ્યસ્ય કુઞ્જિકાં દાસ્યામિ, તેન યત્ કિઞ્ચન ત્વં પૃથિવ્યાં ભંત્સ્યસિ તત્સ્વર્ગે ભંત્સ્યતે, યચ્ચ કિઞ્ચન મહ્યાં મોક્ષ્યસિ તત્ સ્વર્ગે મોક્ષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","પશ્ચાત્ સ શિષ્યાનાદિશત્, અહમભિષિક્તો યીશુરિતિ કથાં કસ્મૈચિદપિ યૂયં મા કથયત| ");
INSERT INTO sanguj_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","અન્યઞ્ચ યિરૂશાલમ્નગરં ગત્વા પ્રાચીનલોકેભ્યઃ પ્રધાનયાજકેભ્ય ઉપાધ્યાયેભ્યશ્ચ બહુદુઃખભોગસ્તૈ ર્હતત્વં તૃતીયદિને પુનરુત્થાનઞ્ચ મમાવશ્યકમ્ એતાઃ કથા યીશુસ્તત્કાલમારભ્ય શિષ્યાન્ જ્ઞાપયિતુમ્ આરબ્ધવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","તદાનીં પિતરસ્તસ્ય કરં ઘૃત્વા તર્જયિત્વા કથયિતુમારબ્ધવાન્, હે પ્રભો, તત્ ત્વત્તો દૂરં યાતુ, ત્વાં પ્રતિ કદાપિ ન ઘટિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","કિન્તુ સ વદનં પરાવર્ત્ય પિતરં જગાદ, હે વિઘ્નકારિન્, મત્સમ્મુખાદ્ દૂરીભવ, ત્વં માં બાધસે, ઈશ્વરીયકાર્ય્યાત્ માનુષીયકાર્ય્યં તુભ્યં રોચતે| ");
INSERT INTO sanguj_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","અનન્તરં યીશુઃ સ્વીયશિષ્યાન્ ઉક્તવાન્ યઃ કશ્ચિત્ મમ પશ્ચાદ્ગામી ભવિતુમ્ ઇચ્છતિ, સ સ્વં દામ્યતુ, તથા સ્વક્રુશં ગૃહ્લન્ મત્પશ્ચાદાયાતુ| ");
INSERT INTO sanguj_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","યતો યઃ પ્રાણાન્ રક્ષિતુમિચ્છતિ, સ તાન્ હારયિષ્યતિ, કિન્તુ યો મદર્થં નિજપ્રાણાન્ હારયતિ, સ તાન્ પ્રાપ્સ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","માનુષો યદિ સર્વ્વં જગત્ લભતે નિજપ્રણાન્ હારયતિ, તર્હિ તસ્ય કો લાભઃ? મનુજો નિજપ્રાણાનાં વિનિમયેન વા કિં દાતું શક્નોતિ? ");
INSERT INTO sanguj_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","મનુજસુતઃ સ્વદૂતૈઃ સાકં પિતુઃ પ્રભાવેણાગમિષ્યતિ; તદા પ્રતિમનુજં સ્વસ્વકર્મ્માનુસારાત્ ફલં દાસ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","અહં યુષ્માન્ તથ્યં વચ્મિ, સરાજ્યં મનુજસુતમ્ આગતં ન પશ્યન્તો મૃત્યું ન સ્વાદિષ્યન્તિ, એતાદૃશાઃ કતિપયજના અત્રાપિ દણ્ડાયમાનાઃ સન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","અનન્તરં ષડ્દિનેભ્યઃ પરં યીશુઃ પિતરં યાકૂબં તત્સહજં યોહનઞ્ચ ગૃહ્લન્ ઉચ્ચાદ્રે ર્વિવિક્તસ્થાનમ્ આગત્ય તેષાં સમક્ષં રૂપમન્યત્ દધાર| ");
INSERT INTO sanguj_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","તેન તદાસ્યં તેજસ્વિ, તદાભરણમ્ આલોકવત્ પાણ્ડરમભવત્| ");
INSERT INTO sanguj_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","અન્યચ્ચ તેન સાકં સંલપન્તૌ મૂસા એલિયશ્ચ તેભ્યો દર્શનં દદતુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","તદાનીં પિતરો યીશું જગાદ, હે પ્રભો સ્થિતિરત્રાસ્માકં શુભા, યદિ ભવતાનુમન્યતે, તર્હિ ભવદર્થમેકં મૂસાર્થમેકમ્ એલિયાર્થઞ્ચૈકમ્ ઇતિ ત્રીણિ દૂષ્યાણિ નિર્મ્મમ| ");
INSERT INTO sanguj_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","એતત્કથનકાલ એક ઉજ્જવલઃ પયોદસ્તેષામુપરિ છાયાં કૃતવાન્, વારિદાદ્ એષા નભસીયા વાગ્ બભૂવ, મમાયં પ્રિયઃ પુત્રઃ, અસ્મિન્ મમ મહાસન્તોષ એતસ્ય વાક્યં યૂયં નિશામયત| ");
INSERT INTO sanguj_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","કિન્તુ વાચમેતાં શૃણ્વન્તએવ શિષ્યા મૃશં શઙ્કમાના ન્યુબ્જા ન્યપતન્| ");
INSERT INTO sanguj_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","તદા યીશુરાગત્ય તેષાં ગાત્રાણિ સ્પૃશન્ ઉવાચ, ઉત્તિષ્ઠત, મા ભૈષ્ટ| ");
INSERT INTO sanguj_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","તદાનીં નેત્રાણ્યુન્મીલ્ય યીશું વિના કમપિ ન દદૃશુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","તતઃ પરમ્ અદ્રેરવરોહણકાલે યીશુસ્તાન્ ઇત્યાદિદેશ, મનુજસુતસ્ય મૃતાનાં મધ્યાદુત્થાનં યાવન્ન જાયતે, તાવત્ યુષ્માભિરેતદ્દર્શનં કસ્મૈચિદપિ ન કથયિતવ્યં| ");
INSERT INTO sanguj_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","તદા શિષ્યાસ્તં પપ્રચ્છુઃ, પ્રથમમ્ એલિય આયાસ્યતીતિ કુત ઉપાધ્યાયૈરુચ્યતે? ");
INSERT INTO sanguj_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","તતો યીશુઃ પ્રત્યવાદીત્, એલિયઃ પ્રાગેત્ય સર્વ્વાણિ સાધયિષ્યતીતિ સત્યં, ");
INSERT INTO sanguj_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","કિન્ત્વહં યુષ્માન્ વચ્મિ, એલિય એત્ય ગતઃ, તે તમપરિચિત્ય તસ્મિન્ યથેચ્છં વ્યવજહુઃ; મનુજસુતેનાપિ તેષામન્તિકે તાદૃગ્ દુઃખં ભોક્તવ્યં| ");
INSERT INTO sanguj_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","તદાનીં સ મજ્જયિતારં યોહનમધિ કથામેતાં વ્યાહૃતવાન્, ઇત્થં તચ્છિષ્યા બુબુધિરે| ");
INSERT INTO sanguj_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","પશ્ચાત્ તેષુ જનનિવહસ્યાન્તિકમાગતેષુ કશ્ચિત્ મનુજસ્તદન્તિકમેત્ય જાનૂની પાતયિત્વા કથિતવાન્, ");
INSERT INTO sanguj_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","હે પ્રભો, મત્પુત્રં પ્રતિ કૃપાં વિદધાતુ, સોપસ્મારામયેન ભૃશં વ્યથિતઃ સન્ પુનઃ પુન ર્વહ્નૌ મુહુ ર્જલમધ્યે પતતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","તસ્માદ્ ભવતઃ શિષ્યાણાં સમીપે તમાનયં કિન્તુ તે તં સ્વાસ્થં કર્ત્તું ન શક્તાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","તદા યીશુઃ કથિતવાન્ રે અવિશ્વાસિનઃ, રે વિપથગામિનઃ, પુનઃ કતિકાલાન્ અહં યુષ્માકં સન્નિધૌ સ્થાસ્યામિ? કતિકાલાન્ વા યુષ્માન્ સહિષ્યે? તમત્ર મમાન્તિકમાનયત| ");
INSERT INTO sanguj_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","પશ્ચાદ્ યીશુના તર્જતએવ સ ભૂતસ્તં વિહાય ગતવાન્, તદ્દણ્ડએવ સ બાલકો નિરામયોઽભૂત્| ");
INSERT INTO sanguj_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","તતઃ શિષ્યા ગુપ્તં યીશુમુપાગત્ય બભાષિરે, કુતો વયં તં ભૂતં ત્યાજયિતું ન શક્તાઃ? ");
INSERT INTO sanguj_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","યીશુના તે પ્રોક્તાઃ, યુષ્માકમપ્રત્યયાત્; ");
INSERT INTO sanguj_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","યુષ્માનહં તથ્યં વચ્મિ યદિ યુષ્માકં સર્ષપૈકમાત્રોપિ વિશ્વાસો જાયતે, તર્હિ યુષ્માભિરસ્મિન્ શૈલે ત્વમિતઃ સ્થાનાત્ તત્ સ્થાનં યાહીતિ બ્રૂતે સ તદૈવ ચલિષ્યતિ, યુષ્માકં કિમપ્યસાધ્યઞ્ચ કર્મ્મ ન સ્થાસ્યાતિ| કિન્તુ પ્રાર્થનોપવાસૌ વિનૈતાદૃશો ભૂતો ન ત્યાજ્યેત| ");
INSERT INTO sanguj_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","અપરં તેષાં ગાલીલ્પ્રદેશે ભ્રમણકાલે યીશુના તે ગદિતાઃ, મનુજસુતો જનાનાં કરેષુ સમર્પયિષ્યતે તૈ ર્હનિષ્યતે ચ, ");
INSERT INTO sanguj_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","કિન્તુ તૃતીયેઽહિ्ન મ ઉત્થાપિષ્યતે, તેન તે ભૃશં દુઃખિતા બભૂવઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","તદનન્તરં તેષુ કફર્નાહૂમ્નગરમાગતેષુ કરસંગ્રાહિણઃ પિતરાન્તિકમાગત્ય પપ્રચ્છુઃ, યુષ્માકં ગુરુઃ કિં મન્દિરાર્થં કરં ન દદાતિ? તતઃ પિતરઃ કથિતવાન્ દદાતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","તતસ્તસ્મિન્ ગૃહમધ્યમાગતે તસ્ય કથાકથનાત્ પૂર્વ્વમેવ યીશુરુવાચ, હે શિમોન્, મેદિન્યા રાજાનઃ સ્વસ્વાપત્યેભ્યઃ કિં વિદેશિભ્યઃ કેભ્યઃ કરં ગૃહ્લન્તિ? અત્ર ત્વં કિં બુધ્યસે? તતઃ પિતર ઉક્તવાન્, વિદેશિભ્યઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","તદા યીશુરુક્તવાન્, તર્હિ સન્તાના મુક્તાઃ સન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","તથાપિ યથાસ્માભિસ્તેષામન્તરાયો ન જન્યતે, તત્કૃતે જલધેસ્તીરં ગત્વા વડિશં ક્ષિપ, તેનાદૌ યો મીન ઉત્થાસ્યતિ, તં ઘૃત્વા તન્મુખે મોચિતે તોલકૈકં રૂપ્યં પ્રાપ્સ્યસિ, તદ્ ગૃહીત્વા તવ મમ ચ કૃતે તેભ્યો દેહિ| ");
INSERT INTO sanguj_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","તદાનીં શિષ્યા યીશોઃ સમીપમાગત્ય પૃષ્ટવન્તઃ સ્વર્ગરાજ્યે કઃ શ્રેષ્ઠઃ? ");
INSERT INTO sanguj_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","તતો યીશુઃ ક્ષુદ્રમેકં બાલકં સ્વસમીપમાનીય તેષાં મધ્યે નિધાય જગાદ, ");
INSERT INTO sanguj_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","યુષ્માનહં સત્યં બ્રવીમિ, યૂયં મનોવિનિમયેન ક્ષુદ્રબાલવત્ ન સન્તઃ સ્વર્ગરાજ્યં પ્રવેષ્ટું ન શક્નુથ| ");
INSERT INTO sanguj_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","યઃ કશ્ચિદ્ એતસ્ય ક્ષુદ્રબાલકસ્ય સમમાત્માનં નમ્રીકરોતિ, સએવ સ્વર્ગરાજયે શ્રેષ્ઠઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","યઃ કશ્ચિદ્ એતાદૃશં ક્ષુદ્રબાલકમેકં મમ નામ્નિ ગૃહ્લાતિ, સ મામેવ ગૃહ્લાતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","કિન્તુ યો જનો મયિ કૃતવિશ્વાસાનામેતેષાં ક્ષુદ્રપ્રાણિનામ્ એકસ્યાપિ વિધ્નિં જનયતિ, કણ્ઠબદ્ધપેષણીકસ્ય તસ્ય સાગરાગાધજલે મજ્જનં શ્રેયઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","વિઘ્નાત્ જગતઃ સન્તાપો ભવિષ્યતિ, વિઘ્નોઽવશ્યં જનયિષ્યતે, કિન્તુ યેન મનુજેન વિઘ્નો જનિષ્યતે તસ્યૈવ સન્તાપો ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","તસ્માત્ તવ કરશ્ચરણો વા યદિ ત્વાં બાધતે, તર્હિ તં છિત્ત્વા નિક્ષિપ, દ્વિકરસ્ય દ્વિપદસ્ય વા તવાનપ્તવહ્નૌ નિક્ષેપાત્, ખઞ્જસ્ય વા છિન્નહસ્તસ્ય તવ જીવને પ્રવેશો વરં| ");
INSERT INTO sanguj_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","અપરં તવ નેત્રં યદિ ત્વાં બાધતે, તર્હિ તદપ્યુત્પાવ્ય નિક્ષિપ, દ્વિનેત્રસ્ય નરકાગ્નૌ નિક્ષેપાત્ કાણસ્ય તવ જીવને પ્રવેશો વરં| ");
INSERT INTO sanguj_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","તસ્માદવધદ્ધં, એતેષાં ક્ષુદ્રપ્રાણિનામ્ એકમપિ મા તુચ્છીકુરુત, ");
INSERT INTO sanguj_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","યતો યુષ્માનહં તથ્યં બ્રવીમિ, સ્વર્ગે તેષાં દૂતા મમ સ્વર્ગસ્થસ્ય પિતુરાસ્યં નિત્યં પશ્યન્તિ| એવં યે યે હારિતાસ્તાન્ રક્ષિતું મનુજપુત્ર આગચ્છત્| ");
INSERT INTO sanguj_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","યૂયમત્ર કિં વિવિંગ્ઘ્વે? કસ્યચિદ્ યદિ શતં મેષાઃ સન્તિ, તેષામેકો હાર્ય્યતે ચ, તર્હિ સ એકોનશતં મેષાન્ વિહાય પર્વ્વતં ગત્વા તં હારિતમેકં કિં ન મૃગયતે? ");
INSERT INTO sanguj_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","યદિ ચ કદાચિત્ તન્મેષોદ્દેશં લમતે, તર્હિ યુષ્માનહં સત્યં કથયામિ, સોઽવિપથગામિભ્ય એકોનશતમેષેભ્યોપિ તદેકહેતોરધિકમ્ આહ્લાદતે| ");
INSERT INTO sanguj_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","તદ્વદ્ એતેષાં ક્ષુદ્રપ્રાએिનામ્ એકોપિ નશ્યતીતિ યુષ્માકં સ્વર્ગસ્થપિતુ ર્નાભિમતમ્| ");
INSERT INTO sanguj_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","યદ્યપિ તવ ભ્રાતા ત્વયિ કિમપ્યપરાધ્યતિ, તર્હિ ગત્વા યુવયોર્દ્વયોઃ સ્થિતયોસ્તસ્યાપરાધં તં જ્ઞાપય| તત્ર સ યદિ તવ વાક્યં શૃણોતિ, તર્હિ ત્વં સ્વભ્રાતરં પ્રાપ્તવાન્, ");
INSERT INTO sanguj_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","કિન્તુ યદિ ન શૃણોતિ, તર્હિ દ્વાભ્યાં ત્રિભિ ર્વા સાક્ષીભિઃ સર્વ્વં વાક્યં યથા નિશ્ચિતં જાયતે, તદર્થમ્ એકં દ્વૌ વા સાક્ષિણૌ ગૃહીત્વા યાહિ| ");
INSERT INTO sanguj_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","તેન સ યદિ તયો ર્વાક્યં ન માન્યતે, તર્હિ સમાજં તજ્જ્ઞાપય, કિન્તુ યદિ સમાજસ્યાપિ વાક્યં ન માન્યતે,તર્હિ સ તવ સમીપે દેવપૂજકઇવ ચણ્ડાલઇવ ચ ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","અહં યુષ્માન્ સત્યં વદામિ, યુષ્માભિઃ પૃથિવ્યાં યદ્ બધ્યતે તત્ સ્વર્ગે ભંત્સ્યતે; મેદિન્યાં યત્ ભોચ્યતે, સ્વર્ગેઽપિ તત્ મોક્ષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","પુનરહં યુષ્માન્ વદામિ, મેદિન્યાં યુષ્માકં યદિ દ્વાવેકવાક્યીભૂય કિઞ્ચિત્ પ્રાર્થયેતે, તર્હિ મમ સ્વર્ગસ્થપિત્રા તત્ તયોઃ કૃતે સમ્પન્નં ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","યતો યત્ર દ્વૌ ત્રયો વા મમ નાન્નિ મિલન્તિ, તત્રૈવાહં તેષાં મધ્યેઽસ્મિ| ");
INSERT INTO sanguj_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","તદાનીં પિતરસ્તત્સમીપમાગત્ય કથિતવાન્ હે પ્રભો, મમ ભ્રાતા મમ યદ્યપરાધ્યતિ, તર્હિ તં કતિકૃત્વઃ ક્ષમિષ્યે? ");
INSERT INTO sanguj_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","કિં સપ્તકૃત્વઃ? યીશુસ્તં જગાદ, ત્વાં કેવલં સપ્તકૃત્વો યાવત્ ન વદામિ, કિન્તુ સપ્તત્યા ગુણિતં સપ્તકૃત્વો યાવત્| ");
INSERT INTO sanguj_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","અપરં નિજદાસૈઃ સહ જિગણયિષુઃ કશ્ચિદ્ રાજેવ સ્વર્ગરાજયં| ");
INSERT INTO sanguj_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","આરબ્ધે તસ્મિન્ ગણને સાર્દ્ધસહસ્રમુદ્રાપૂરિતાનાં દશસહસ્રપુટકાનામ્ એકોઽઘમર્ણસ્તત્સમક્ષમાનાયિ| ");
INSERT INTO sanguj_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","તસ્ય પરિશોધનાય દ્રવ્યાભાવાત્ પરિશોધનાર્થં સ તદીયભાર્ય્યાપુત્રાદિસર્વ્વસ્વઞ્ચ વિક્રીયતામિતિ તત્પ્રભુરાદિદેશ| ");
INSERT INTO sanguj_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","તેન સ દાસસ્તસ્ય પાદયોઃ પતન્ પ્રણમ્ય કથિતવાન્ , હે પ્રભો ભવતા ઘૈર્ય્યે કૃતે મયા સર્વ્વં પરિશોધિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","તદાનીં દાસસ્ય પ્રભુઃ સકરુણઃ સન્ સકલર્ણં ક્ષમિત્વા તં તત્યાજ| ");
INSERT INTO sanguj_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","કિન્તુ તસ્મિન્ દાસે બહિ ર્યાતે, તસ્ય શતં મુદ્રાચતુર્થાંશાન્ યો ધારયતિ, તં સહદાસં દૃષ્દ્વા તસ્ય કણ્ઠં નિષ્પીડ્ય ગદિતવાન્, મમ યત્ પ્રાપ્યં તત્ પરિશોધય| ");
INSERT INTO sanguj_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","તદા તસ્ય સહદાસસ્તત્પાદયોઃ પતિત્વા વિનીય બભાષે, ત્વયા ધૈર્ય્યે કૃતે મયા સર્વ્વં પરિશોધિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","તથાપિ સ તત્ નાઙગીકૃત્ય યાવત્ સર્વ્વમૃણં ન પરિશોધિતવાન્ તાવત્ તં કારાયાં સ્થાપયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","તદા તસ્ય સહદાસાસ્તસ્યૈતાદૃગ્ આચરણં વિલોક્ય પ્રભોઃ સમીપં ગત્વા સર્વ્વં વૃત્તાન્તં નિવેદયામાસુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","તદા તસ્ય પ્રભુસ્તમાહૂય જગાદ, રે દુષ્ટ દાસ, ત્વયા મત્સન્નિધૌ પ્રાર્થિતે મયા તવ સર્વ્વમૃણં ત્યક્તં; ");
INSERT INTO sanguj_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","યથા ચાહં ત્વયિ કરુણાં કૃતવાન્, તથૈવ ત્વત્સહદાસે કરુણાકરણં કિં તવ નોચિતં? ");
INSERT INTO sanguj_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ઇતિ કથયિત્વા તસ્ય પ્રભુઃ ક્રુદ્ધ્યન્ નિજપ્રાપ્યં યાવત્ સ ન પરિશોધિતવાન્, તાવત્ પ્રહારકાનાં કરેષુ તં સમર્પિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","યદિ યૂયં સ્વાન્તઃકરણૈઃ સ્વસ્વસહજાનામ્ અપરાધાન્ ન ક્ષમધ્વે, તર્હિ મમ સ્વર્ગસ્યઃ પિતાપિ યુષ્માન્ પ્રતીત્થં કરિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","અનન્તરમ્ એતાસુ કથાસુ સમાપ્તાસુ યીશુ ર્ગાલીલપ્રદેશાત્ પ્રસ્થાય યર્દન્તીરસ્થં યિહૂદાપ્રદેશં પ્રાપ્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","તદા તત્પશ્ચાત્ જનનિવહે ગતે સ તત્ર તાન્ નિરામયાન્ અકરોત્| ");
INSERT INTO sanguj_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","તદનન્તરં ફિરૂશિનસ્તત્સમીપમાગત્ય પારીક્ષિતું તં પપ્રચ્છુઃ, કસ્માદપિ કારણાત્ નરેણ સ્વજાયા પરિત્યાજ્યા ન વા? ");
INSERT INTO sanguj_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","સ પ્રત્યુવાચ, પ્રથમમ્ ઈશ્વરો નરત્વેન નારીત્વેન ચ મનુજાન્ સસર્જ, તસ્માત્ કથિતવાન્, ");
INSERT INTO sanguj_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","માનુષઃ સ્વપિતરૌ પરિત્યજ્ય સ્વપત્ન્યામ્ આસક્ષ્યતે, તૌ દ્વૌ જનાવેકાઙ્ગૌ ભવિષ્યતઃ, કિમેતદ્ યુષ્માભિ ર્ન પઠિતમ્? ");
INSERT INTO sanguj_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","અતસ્તૌ પુન ર્ન દ્વૌ તયોરેકાઙ્ગત્વં જાતં, ઈશ્વરેણ યચ્ચ સમયુજ્યત, મનુજો ન તદ્ ભિન્દ્યાત્| ");
INSERT INTO sanguj_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","તદાનીં તે તં પ્રત્યવદન્, તથાત્વે ત્યાજ્યપત્રં દત્ત્વા સ્વાં સ્વાં જાયાં ત્યક્તું વ્યવસ્થાં મૂસાઃ કથં લિલેખ? ");
INSERT INTO sanguj_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","તતઃ સ કથિતવાન્, યુષ્માકં મનસાં કાઠિન્યાદ્ યુષ્માન્ સ્વાં સ્વાં જાયાં ત્યક્તુમ્ અન્વમન્યત કિન્તુ પ્રથમાદ્ એષો વિધિર્નાસીત્| ");
INSERT INTO sanguj_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","અતો યુષ્માનહં વદામિ, વ્યભિચારં વિના યો નિજજાયાં ત્યજેત્ અન્યાઞ્ચ વિવહેત્, સ પરદારાન્ ગચ્છતિ; યશ્ચ ત્યક્તાં નારીં વિવહતિ સોપિ પરદારેષુ રમતે| ");
INSERT INTO sanguj_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","તદા તસ્ય શિષ્યાસ્તં બભાષિરે, યદિ સ્વજાયયા સાકં પુંસ એતાદૃક્ સમ્બન્ધો જાયતે, તર્હિ વિવહનમેવ ન ભદ્રં| ");
INSERT INTO sanguj_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","તતઃ સ ઉક્તવાન્, યેભ્યસ્તત્સામર્થ્યં આદાયિ, તાન્ વિનાન્યઃ કોપિ મનુજ એતન્મતં ગ્રહીતું ન શક્નોતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","કતિપયા જનનક્લીબઃ કતિપયા નરકૃતક્લીબઃ સ્વર્ગરાજ્યાય કતિપયાઃ સ્વકૃતક્લીબાશ્ચ સન્તિ, યે ગ્રહીતું શક્નુવન્તિ તે ગૃહ્લન્તુ| ");
INSERT INTO sanguj_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","અપરમ્ યથા સ શિશૂનાં ગાત્રેષુ હસ્તં દત્વા પ્રાર્થયતે, તદર્થં તત્સમીંપં શિશવ આનીયન્ત, તત આનયિતૃન્ શિષ્યાસ્તિરસ્કૃતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","કિન્તુ યીશુરુવાચ, શિશવો મદન્તિકમ્ આગચ્છન્તુ, તાન્ મા વારયત, એતાદૃશાં શિશૂનામેવ સ્વર્ગરાજ્યં| ");
INSERT INTO sanguj_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","તતઃ સ તેષાં ગાત્રેષુ હસ્તં દત્વા તસ્માત્ સ્થાનાત્ પ્રતસ્થે| ");
INSERT INTO sanguj_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","અપરમ્ એક આગત્ય તં પપ્રચ્છ, હે પરમગુરો, અનન્તાયુઃ પ્રાપ્તું મયા કિં કિં સત્કર્મ્મ કર્ત્તવ્યં? ");
INSERT INTO sanguj_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","તતઃ સ ઉવાચ, માં પરમં કુતો વદસિ? વિનેશ્ચરં ન કોપિ પરમઃ, કિન્તુ યદ્યનન્તાયુઃ પ્રાપ્તું વાઞ્છસિ, તર્હ્યાજ્ઞાઃ પાલય| ");
INSERT INTO sanguj_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","તદા સ પૃષ્ટવાન્, કાઃ કા આજ્ઞાઃ? તતો યીશુઃ કથિતવાન્, નરં મા હન્યાઃ, પરદારાન્ મા ગચ્છેઃ, મા ચોરયેઃ, મૃષાસાક્ષ્યં મા દદ્યાઃ, ");
INSERT INTO sanguj_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","નિજપિતરૌ સંમન્યસ્વ, સ્વસમીપવાસિનિ સ્વવત્ પ્રેમ કુરુ| ");
INSERT INTO sanguj_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","સ યુવા કથિતવાન્, આ બાલ્યાદ્ એતાઃ પાલયામિ, ઇદાનીં કિં ન્યૂનમાસ્તે? ");
INSERT INTO sanguj_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","તતો યીશુરવદત્, યદિ સિદ્ધો ભવિતું વાઞ્છસિ, તર્હિ ગત્વા નિજસર્વ્વસ્વં વિક્રીય દરિદ્રેભ્યો વિતર, તતઃ સ્વર્ગે વિત્તં લપ્સ્યસે; આગચ્છ, મત્પશ્ચાદ્વર્ત્તી ચ ભવ| ");
INSERT INTO sanguj_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","એતાં વાચં શ્રુત્વા સ યુવા સ્વીયબહુસમ્પત્તે ર્વિષણઃ સન્ ચલિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","તદા યીશુઃ સ્વશિષ્યાન્ અવદત્, ધનિનાં સ્વર્ગરાજ્યપ્રવેશો મહાદુષ્કર ઇતિ યુષ્માનહં તથ્યં વદામિ| ");
INSERT INTO sanguj_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","પુનરપિ યુષ્માનહં વદામિ, ધનિનાં સ્વર્ગરાજ્યપ્રવેશાત્ સૂચીછિદ્રેણ મહાઙ્ગગમનં સુકરં| ");
INSERT INTO sanguj_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ઇતિ વાક્યં નિશમ્ય શિષ્યા અતિચમત્કૃત્ય કથયામાસુઃ; તર્હિ કસ્ય પરિત્રાણં ભવિતું શક્નોતિ? ");
INSERT INTO sanguj_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","તદા સ તાન્ દૃષ્દ્વા કથયામાસ, તત્ માનુષાણામશક્યં ભવતિ, કિન્ત્વીશ્વરસ્ય સર્વ્વં શક્યમ્| ");
INSERT INTO sanguj_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","તદા પિતરસ્તં ગદિતવાન્, પશ્ય, વયં સર્વ્વં પરિત્યજ્ય ભવતઃ પશ્ચાદ્વર્ત્તિનો ઽભવામ; વયં કિં પ્રાપ્સ્યામઃ? ");
INSERT INTO sanguj_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","તતો યીશુઃ કથિતવાન્, યુષ્માનહં તથ્યં વદામિ, યૂયં મમ પશ્ચાદ્વર્ત્તિનો જાતા ઇતિ કારણાત્ નવીનસૃષ્ટિકાલે યદા મનુજસુતઃ સ્વીયૈશ્ચર્ય્યસિંહાસન ઉપવેક્ષ્યતિ, તદા યૂયમપિ દ્વાદશસિંહાસનેષૂપવિશ્ય ઇસ્રાયેલીયદ્વાદશવંશાનાં વિચારં કરિષ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","અન્યચ્ચ યઃ કશ્ચિત્ મમ નામકારણાત્ ગૃહં વા ભ્રાતરં વા ભગિનીં વા પિતરં વા માતરં વા જાયાં વા બાલકં વા ભૂમિં પરિત્યજતિ, સ તેષાં શતગુણં લપ્સ્યતે, અનન્તાયુમોઽધિકારિત્વઞ્ચ પ્રાપ્સ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","કિન્તુ અગ્રીયા અનેકે જનાઃ પશ્ચાત્, પશ્ચાતીયાશ્ચાનેકે લોકા અગ્રે ભવિષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","સ્વર્ગરાજ્યમ્ એતાદૃશા કેનચિદ્ ગૃહસ્યેન સમં, યોઽતિપ્રભાતે નિજદ્રાક્ષાક્ષેત્રે કૃષકાન્ નિયોક્તું ગતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","પશ્ચાત્ તૈઃ સાકં દિનૈકભૃતિં મુદ્રાચતુર્થાંશં નિરૂપ્ય તાન્ દ્રાક્ષાક્ષેત્રં પ્રેરયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","અનન્તરં પ્રહરૈકવેલાયાં ગત્વા હટ્ટે કતિપયાન્ નિષ્કર્મ્મકાન્ વિલોક્ય તાનવદત્, ");
INSERT INTO sanguj_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","યૂયમપિ મમ દ્રાક્ષાક્ષેત્રં યાત, યુષ્મભ્યમહં યોગ્યભૃતિં દાસ્યામિ, તતસ્તે વવ્રજુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","પુનશ્ચ સ દ્વિતીયતૃતીયયોઃ પ્રહરયો ર્બહિ ર્ગત્વા તથૈવ કૃતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","તતો દણ્ડદ્વયાવશિષ્ટાયાં વેલાયાં બહિ ર્ગત્વાપરાન્ કતિપયજનાન્ નિષ્કર્મ્મકાન્ વિલોક્ય પૃષ્ટવાન્, યૂયં કિમર્થમ્ અત્ર સર્વ્વં દિનં નિષ્કર્મ્માણસ્તિષ્ઠથ? ");
INSERT INTO sanguj_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","તે પ્રત્યવદન્, અસ્માન્ ન કોપિ કર્મમણિ નિયુંક્તે| તદાનીં સ કથિતવાન્, યૂયમપિ મમ દ્રાક્ષાક્ષેત્રં યાત, તેન યોગ્યાં ભૃતિં લપ્સ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","તદનન્તરં સન્ધ્યાયાં સત્યાં સએવ દ્રાક્ષાક્ષેત્રપતિરધ્યક્ષં ગદિવાન્, કૃષકાન્ આહૂય શેષજનમારભ્ય પ્રથમં યાવત્ તેભ્યો ભૃતિં દેહિ| ");
INSERT INTO sanguj_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","તેન યે દણ્ડદ્વયાવસ્થિતે સમાયાતાસ્તેષામ્ એકૈકો જનો મુદ્રાચતુર્થાંશં પ્રાપ્નોત્| ");
INSERT INTO sanguj_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","તદાનીં પ્રથમનિયુક્તા જના આગત્યાનુમિતવન્તો વયમધિકં પ્રપ્સ્યામઃ, કિન્તુ તૈરપિ મુદ્રાચતુર્થાંશોઽલાભિ| ");
INSERT INTO sanguj_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","તતસ્તે તં ગૃહીત્વા તેન ક્ષેત્રપતિના સાકં વાગ્યુદ્ધં કુર્વ્વન્તઃ કથયામાસુઃ, ");
INSERT INTO sanguj_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","વયં કૃત્સ્નં દિનં તાપક્લેશૌ સોઢવન્તઃ, કિન્તુ પશ્ચાતાયા સે જના દણ્ડદ્વયમાત્રં પરિશ્રાન્તવન્તસ્તેઽસ્માભિઃ સમાનાંશાઃ કૃતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","તતઃ સ તેષામેકં પ્રત્યુવાચ, હે વત્સ, મયા ત્વાં પ્રતિ કોપ્યન્યાયો ન કૃતઃ કિં ત્વયા મત્સમક્ષં મુદ્રાચતુર્થાંશો નાઙ્ગીકૃતઃ? ");
INSERT INTO sanguj_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","તસ્માત્ તવ યત્ પ્રાપ્યં તદાદાય યાહિ, તુભ્યં યતિ, પશ્ચાતીયનિયુક્તલોકાયાપિ તતિ દાતુમિચ્છામિ| ");
INSERT INTO sanguj_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","સ્વેચ્છયા નિજદ્રવ્યવ્યવહરણં કિં મયા ન કર્ત્તવ્યં? મમ દાતૃત્વાત્ ત્વયા કિમ્ ઈર્ષ્યાદૃષ્ટિઃ ક્રિયતે? ");
INSERT INTO sanguj_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","ઇત્થમ્ અગ્રીયલોકાઃ પશ્ચતીયા ભવિષ્યન્તિ, પશ્ચાતીયજનાશ્ચગ્રીયા ભવિષ્યન્તિ, અહૂતા બહવઃ કિન્ત્વલ્પે મનોભિલષિતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","તદનન્તરં યીશુ ર્યિરૂશાલમ્નગરં ગચ્છન્ માર્ગમધ્યે શિષ્યાન્ એકાન્તે વભાષે, ");
INSERT INTO sanguj_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","પશ્ય વયં યિરૂશાલમ્નગરં યામઃ, તત્ર પ્રધાનયાજકાધ્યાપકાનાં કરેષુ મનુષ્યપુત્રઃ સમર્પિષ્યતે; ");
INSERT INTO sanguj_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","તે ચ તં હન્તુમાજ્ઞાપ્ય તિરસ્કૃત્ય વેત્રેણ પ્રહર્ત્તું ક્રુશે ધાતયિતુઞ્ચાન્યદેશીયાનાં કરેષુ સમર્પયિષ્યન્તિ, કિન્તુ સ તૃતીયદિવસે શ્મશાનાદ્ ઉત્થાપિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","તદાનીં સિવદીયસ્ય નારી સ્વપુત્રાવાદાય યીશોઃ સમીપમ્ એત્ય પ્રણમ્ય કઞ્ચનાનુગ્રહં તં યયાચે| ");
INSERT INTO sanguj_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","તદા યીશુસ્તાં પ્રોક્તવાન્, ત્વં કિં યાચસે? તતઃ સા બભાષે, ભવતો રાજત્વે મમાનયોઃ સુતયોરેકં ભવદ્દક્ષિણપાર્શ્વે દ્વિતીયં વામપાર્શ્વ ઉપવેષ્ટુમ્ આજ્ઞાપયતુ| ");
INSERT INTO sanguj_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","યીશુઃ પ્રત્યુવાચ, યુવાભ્યાં યદ્ યાચ્યતે, તન્ન બુધ્યતે, અહં યેન કંસેન પાસ્યામિ યુવાભ્યાં કિં તેન પાતું શક્યતે? અહઞ્ચ યેન મજ્જેનેન મજ્જિષ્યે, યુવાભ્યાં કિં તેન મજ્જયિતું શક્યતે? તે જગદુઃ શક્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","તદા સ ઉક્તવાન્, યુવાં મમ કંસેનાવશ્યં પાસ્યથઃ, મમ મજ્જનેન ચ યુવામપિ મજ્જિષ્યેથે, કિન્તુ યેષાં કૃતે મત્તાતેન નિરૂપિતમ્ ઇદં તાન્ વિહાયાન્યં કમપિ મદ્દક્ષિણપાર્શ્વે વામપાર્શ્વે ચ સમુપવેશયિતું મમાધિકારો નાસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","એતાં કથાં શ્રુત્વાન્યે દશશિષ્યાસ્તૌ ભ્રાતરૌ પ્રતિ ચુકુપુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","કિન્તુ યીશુઃ સ્વસમીપં તાનાહૂય જગાદ, અન્યદેશીયલોકાનાં નરપતયસ્તાન્ અધિકુર્વ્વન્તિ, યે તુ મહાન્તસ્તે તાન્ શાસતિ, ઇતિ યૂયં જાનીથ| ");
INSERT INTO sanguj_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","કિન્તુ યુષ્માકં મધ્યે ન તથા ભવેત્, યુષ્માકં યઃ કશ્ચિત્ મહાન્ બુભૂષતિ, સ યુષ્માન્ સેવેત; ");
INSERT INTO sanguj_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","યશ્ચ યુષ્માકં મધ્યે મુખ્યો બુભૂષતિ, સ યુષ્માકં દાસો ભવેત્| ");
INSERT INTO sanguj_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ઇત્થં મનુજપુત્રઃ સેવ્યો ભવિતું નહિ, કિન્તુ સેવિતું બહૂનાં પરિત્રાણમૂલ્યાર્થં સ્વપ્રાણાન્ દાતુઞ્ચાગતઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","અનન્તરં યિરીહોનગરાત્ તેષાં બહિર્ગમનસમયે તસ્ય પશ્ચાદ્ બહવો લોકા વવ્રજુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","અપરં વર્ત્મપાર્શ્વ ઉપવિશન્તૌ દ્વાવન્ધૌ તેન માર્ગેણ યીશો ર્ગમનં નિશમ્ય પ્રોચ્ચૈઃ કથયામાસતુઃ, હે પ્રભો દાયૂદઃ સન્તાન, આવયો ર્દયાં વિધેહિ| ");
INSERT INTO sanguj_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","તતો લોકાઃ સર્વ્વે તુષ્ણીમ્ભવતમિત્યુક્ત્વા તૌ તર્જયામાસુઃ; તથાપિ તૌ પુનરુચ્ચૈઃ કથયામાસતુઃ હે પ્રભો દાયૂદઃ સન્તાન, આવાં દયસ્વ| ");
INSERT INTO sanguj_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","તદાનીં યીશુઃ સ્થગિતઃ સન્ તાવાહૂય ભાષિતવાન્, યુવયોઃ કૃતે મયા કિં કર્ત્તર્વ્યં? યુવાં કિં કામયેથે? ");
INSERT INTO sanguj_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","તદા તાવુક્તવન્તૌ, પ્રભો નેત્રાણિ નૌ પ્રસન્નાનિ ભવેયુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","તદાનીં યીશુસ્તૌ પ્રતિ પ્રમન્નઃ સન્ તયો ર્નેત્રાણિ પસ્પર્શ, તેનૈવ તૌ સુવીક્ષાઞ્ચક્રાતે તત્પશ્ચાત્ જગ્મુતુશ્ચ| ");
INSERT INTO sanguj_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","અનન્તરં તેષુ યિરૂશાલમ્નગરસ્ય સમીપવેર્ત્તિનો જૈતુનનામકધરાધરસ્ય સમીપસ્થ્તિં બૈત્ફગિગ્રામમ્ આગતેષુ, યીશુઃ શિષ્યદ્વયં પ્રેષયન્ જગાદ, ");
INSERT INTO sanguj_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","યુવાં સમ્મુખસ્થગ્રામં ગત્વા બદ્ધાં યાં સવત્સાં ગર્દ્દભીં હઠાત્ પ્રાપ્સ્યથઃ, તાં મોચયિત્વા મદન્તિકમ્ આનયતં| ");
INSERT INTO sanguj_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","તત્ર યદિ કશ્ચિત્ કિઞ્ચિદ્ વક્ષ્યતિ, તર્હિ વદિષ્યથઃ, એતસ્યાં પ્રભોઃ પ્રયોજનમાસ્તે, તેન સ તત્ક્ષણાત્ પ્રહેષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","સીયોનઃ કન્યકાં યૂયં ભાષધ્વમિતિ ભારતીં| પશ્ય તે નમ્રશીલઃ સન્ નૃપ આરુહ્ય ગર્દભીં| અર્થાદારુહ્ય તદ્વત્સમાયાસ્યતિ ત્વદન્તિકં| ");
INSERT INTO sanguj_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","ભવિષ્યદ્વાદિનોક્તં વચનમિદં તદા સફલમભૂત્| ");
INSERT INTO sanguj_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","અનન્તરં તૌ શ્ષ્યિौ યીશો ર્યથાનિદેશં તં ગ્રામં ગત્વા ");
INSERT INTO sanguj_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ગર્દભીં તદ્વત્સઞ્ચ સમાનીતવન્તૌ, પશ્ચાત્ તદુપરિ સ્વીયવસનાની પાતયિત્વા તમારોહયામાસતુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","તતો બહવો લોકા નિજવસનાનિ પથિ પ્રસારયિતુમારેભિરે, કતિપયા જનાશ્ચ પાદપપર્ણાદિકં છિત્વા પથિ વિસ્તારયામાસુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","અગ્રગામિનઃ પશ્ચાદ્ગામિનશ્ચ મનુજા ઉચ્ચૈર્જય જય દાયૂદઃ સન્તાનેતિ જગદુઃ પરમેશ્વરસ્ય નામ્ના ય આયાતિ સ ધન્યઃ, સર્વ્વોપરિસ્થસ્વર્ગેપિ જયતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ઇત્થં તસ્મિન્ યિરૂશાલમં પ્રવિષ્ટે કોઽયમિતિ કથનાત્ કૃત્સ્નં નગરં ચઞ્ચલમભવત્| ");
INSERT INTO sanguj_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","તત્ર લોકોઃ કથયામાસુઃ, એષ ગાલીલ્પ્રદેશીય-નાસરતીય-ભવિષ્યદ્વાદી યીશુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","અનન્તરં યીશુરીશ્વરસ્ય મન્દિરં પ્રવિશ્ય તન્મધ્યાત્ ક્રયવિક્રયિણો વહિશ્ચકાર; વણિજાં મુદ્રાસનાની કપોતવિક્રયિણાઞ્ચસનાની ચ ન્યુવ્જયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","અપરં તાનુવાચ, એષા લિપિરાસ્તે, \"મમ ગૃહં પ્રાર્થનાગૃહમિતિ વિખ્યાસ્યતિ\", કિન્તુ યૂયં તદ્ દસ્યૂનાં ગહ્વરં કૃતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","તદનન્તરમ્ અન્ધખઞ્ચલોકાસ્તસ્ય સમીપમાગતાઃ, સ તાન્ નિરામયાન્ કૃતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","યદા પ્રધાનયાજકા અધ્યાપકાશ્ચ તેન કૃતાન્યેતાનિ ચિત્રકર્મ્માણિ દદૃશુઃ, જય જય દાયૂદઃ સન્તાન, મન્દિરે બાલકાનામ્ એતાદૃશમ્ ઉચ્ચધ્વનિં શુશ્રુવુશ્ચ, તદા મહાક્રુદ્ધા બભૂવઃ, ");
INSERT INTO sanguj_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","તં પપ્રચ્છુશ્ચ, ઇમે યદ્ વદન્તિ, તત્ કિં ત્વં શૃણોષિ? તતો યીશુસ્તાન્ અવોચત્, સત્યમ્; સ્તન્યપાયિશિશૂનાઞ્ચ બાલકાનાઞ્ચ વક્ત્રતઃ| સ્વકીયં મહિમાનં ત્વં સંપ્રકાશયસિ સ્વયં| એતદ્વાક્યં યૂયં કિં નાપઠત? ");
INSERT INTO sanguj_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","તતસ્તાન્ વિહાય સ નગરાદ્ બૈથનિયાગ્રામં ગત્વા તત્ર રજનીં યાપયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","અનન્તરં પ્રભાતે સતિ યીશુઃ પુનરપિ નગરમાગચ્છન્ ક્ષુધાર્ત્તો બભૂવ| ");
INSERT INTO sanguj_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","તતો માર્ગપાર્શ્વ ઉડુમ્બરવૃક્ષમેકં વિલોક્ય તત્સમીપં ગત્વા પત્રાણિ વિના કિમપિ ન પ્રાપ્ય તં પાદપં પ્રોવાચ, અદ્યારભ્ય કદાપિ ત્વયિ ફલં ન ભવતુ; તેન તત્ક્ષણાત્ સ ઉડુમ્બરમાહીરુહઃ શુષ્કતાં ગતઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","તદ્ દૃષ્ટ્વા શિષ્યા આશ્ચર્ય્યં વિજ્ઞાય કથયામાસુઃ, આઃ, ઉડુમ્વરપાદપોઽતિતૂર્ણં શુષ્કોઽભવત્| ");
INSERT INTO sanguj_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","તતો યીશુસ્તાનુવાચ, યુષ્માનહં સત્યં વદામિ, યદિ યૂયમસન્દિગ્ધાઃ પ્રતીથ, તર્હિ યૂયમપિ કેવલોડુમ્વરપાદપં પ્રતીત્થં કર્ત્તું શક્ષ્યથ, તન્ન, ત્વં ચલિત્વા સાગરે પતેતિ વાક્યં યુષ્માભિરસ્મિન શૈલે પ્રોક્તેપિ તદૈવ તદ્ ઘટિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","તથા વિશ્વસ્ય પ્રાર્થ્ય યુષ્માભિ ર્યદ્ યાચિષ્યતે, તદેવ પ્રાપ્સ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","અનન્તરં મન્દિરં પ્રવિશ્યોપદેશનસમયે તત્સમીપં પ્રધાનયાજકાઃ પ્રાચીનલોકાશ્ચાગત્ય પપ્રચ્છુઃ, ત્વયા કેન સામર્થ્યનૈતાનિ કર્મ્માણિ ક્રિયન્તે? કેન વા તુભ્યમેતાનિ સામર્થ્યાનિ દત્તાનિ? ");
INSERT INTO sanguj_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","તતો યીશુઃ પ્રત્યવદત્, અહમપિ યુષ્માન્ વાચમેકાં પૃચ્છામિ, યદિ યૂયં તદુત્તરં દાતું શક્ષ્યથ, તદા કેન સામર્થ્યેન કર્મ્માણ્યેતાનિ કરોમિ, તદહં યુષ્માન્ વક્ષ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","યોહનો મજ્જનં કસ્યાજ્ઞયાભવત્? કિમીશ્વરસ્ય મનુષ્યસ્ય વા? તતસ્તે પરસ્પરં વિવિચ્ય કથયામાસુઃ, યદીશ્વરસ્યેતિ વદામસ્તર્હિ યૂયં તં કુતો ન પ્રત્યૈત? વાચમેતાં વક્ષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","મનુષ્યસ્યેતિ વક્તુમપિ લોકેભ્યો બિભીમઃ, યતઃ સર્વ્વૈરપિ યોહન્ ભવિષ્યદ્વાદીતિ જ્ઞાયતે| ");
INSERT INTO sanguj_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","તસ્માત્ તે યીશું પ્રત્યવદન્, તદ્ વયં ન વિદ્મઃ| તદા સ તાનુક્તવાન્, તર્હિ કેન સામરથ્યેન કર્મ્માણ્યેતાન્યહં કરોમિ, તદપ્યહં યુષ્માન્ ન વક્ષ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","કસ્યચિજ્જનસ્ય દ્વૌ સુતાવાસ્તાં સ એકસ્ય સુતસ્ય સમીપં ગત્વા જગાદ, હે સુત, ત્વમદ્ય મમ દ્રાક્ષાક્ષેત્રે કર્મ્મ કર્તું વ્રજ| ");
INSERT INTO sanguj_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","તતઃ સ ઉક્તવાન્, ન યાસ્યામિ, કિન્તુ શેષેઽનુતપ્ય જગામ| ");
INSERT INTO sanguj_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","અનન્તરં સોન્યસુતસ્ય સમીપં ગત્વા તથૈવ કથ્તિવાન્; તતઃ સ પ્રત્યુવાચ, મહેચ્છ યામિ, કિન્તુ ન ગતઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","એતયોઃ પુત્રયો ર્મધ્યે પિતુરભિમતં કેન પાલિતં? યુષ્માભિઃ કિં બુધ્યતે? તતસ્તે પ્રત્યૂચુઃ, પ્રથમેન પુुત્રેણ| તદાનીં યીશુસ્તાનુવાચ, અહં યુષ્માન્ તથ્યં વદામિ, ચણ્ડાલા ગણિકાશ્ચ યુષ્માકમગ્રત ઈશ્વરસ્ય રાજ્યં પ્રવિશન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","યતો યુષ્માકં સમીપં યોહનિ ધર્મ્મપથેનાગતે યૂયં તં ન પ્રતીથ, કિન્તુ ચણ્ડાલા ગણિકાશ્ચ તં પ્રત્યાયન્, તદ્ વિલોક્યાપિ યૂયં પ્રત્યેતું નાખિદ્યધ્વં| ");
INSERT INTO sanguj_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","અપરમેકં દૃષ્ટાન્તં શૃણુત, કશ્ચિદ્ ગૃહસ્થઃ ક્ષેત્રે દ્રાક્ષાલતા રોપયિત્વા તચ્ચતુર્દિક્ષુ વારણીં વિધાય તન્મધ્યે દ્રાક્ષાયન્ત્રં સ્થાપિતવાન્, માઞ્ચઞ્ચ નિર્મ્મિતવાન્, તતઃ કૃષકેષુ તત્ ક્ષેત્રં સમર્પ્ય સ્વયં દૂરદેશં જગામ| ");
INSERT INTO sanguj_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","તદનન્તરં ફલસમય ઉપસ્થિતે સ ફલાનિ પ્રાપ્તું કૃષીવલાનાં સમીપં નિજદાસાન્ પ્રેષયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","કિન્તુ કૃષીવલાસ્તસ્ય તાન્ દાસેયાન્ ધૃત્વા કઞ્ચન પ્રહૃતવન્તઃ, કઞ્ચન પાષાણૈરાહતવન્તઃ, કઞ્ચન ચ હતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","પુનરપિ સ પ્રભુઃ પ્રથમતોઽધિકદાસેયાન્ પ્રેષયામાસ, કિન્તુ તે તાન્ પ્રત્યપિ તથૈવ ચક્રુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","અનન્તરં મમ સુતે ગતે તં સમાદરિષ્યન્તે, ઇત્યુક્ત્વા શેષે સ નિજસુતં તેષાં સન્નિધિં પ્રેષયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","કિન્તુ તે કૃષીવલાઃ સુતં વીક્ષ્ય પરસ્પરમ્ ઇતિ મન્ત્રયિતુમ્ આરેભિરે, અયમુત્તરાધિકારી વયમેનં નિહત્યાસ્યાધિકારં સ્વવશીકરિષ્યામઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","પશ્ચાત્ તે તં ધૃત્વા દ્રાક્ષાક્ષેત્રાદ્ બહિઃ પાતયિત્વાબધિષુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","યદા સ દ્રાક્ષાક્ષેત્રપતિરાગમિષ્યતિ, તદા તાન્ કૃષીવલાન્ કિં કરિષ્યતિ? ");
INSERT INTO sanguj_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","તતસ્તે પ્રત્યવદન્, તાન્ કલુષિણો દારુણયાતનાભિરાહનિષ્યતિ, યે ચ સમયાનુક્રમાત્ ફલાનિ દાસ્યન્તિ, તાદૃશેષુ કૃષીવલેષુ ક્ષેત્રં સમર્પયિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","તદા યીશુના તે ગદિતાઃ, ગ્રહણં ન કૃતં યસ્ય પાષાણસ્ય નિચાયકૈઃ| પ્રધાનપ્રસ્તરઃ કોણે સએવ સંભવિષ્યતિ| એતત્ પરેશિતુઃ કર્મ્માસ્મદૃષ્ટાવદ્ભુતં ભવેત્| ધર્મ્મગ્રન્થે લિખિતમેતદ્વચનં યુષ્માભિઃ કિં નાપાઠિ? ");
INSERT INTO sanguj_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","તસ્માદહં યુષ્માન્ વદામિ, યુષ્મત્ત ઈશ્વરીયરાજ્યમપનીય ફલોત્પાદયિત્રન્યજાતયે દાયિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","યો જન એતત્પાષાણોપરિ પતિષ્યતિ, તં સ ભંક્ષ્યતે, કિન્ત્વયં પાષાણો યસ્યોપરિ પતિષ્યતિ, તં સ ધૂલિવત્ ચૂર્ણીકરિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","તદાનીં પ્રાધનયાજકાઃ ફિરૂશિનશ્ચ તસ્યેમાં દૃષ્ટાન્તકથાં શ્રુત્વા સોઽસ્માનુદ્દિશ્ય કથિતવાન્, ઇતિ વિજ્ઞાય તં ધર્ત્તું ચેષ્ટિતવન્તઃ; ");
INSERT INTO sanguj_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","કિન્તુ લોકેભ્યો બિભ્યુઃ, યતો લોકૈઃ સ ભવિષ્યદ્વાદીત્યજ્ઞાયિ| ");
INSERT INTO sanguj_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","અનન્તરં યીશુઃ પુનરપિ દૃષ્ટાન્તેન તાન્ અવાદીત્, ");
INSERT INTO sanguj_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","સ્વર્ગીયરાજ્યમ્ એતાદૃશસ્ય નૃપતેઃ સમં, યો નિજ પુત્રં વિવાહયન્ સર્વ્વાન્ નિમન્ત્રિતાન્ આનેતું દાસેયાન્ પ્રહિતવાન્, ");
INSERT INTO sanguj_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","કિન્તુ તે સમાગન્તું નેષ્ટવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","તતો રાજા પુનરપિ દાસાનન્યાન્ ઇત્યુક્ત્વા પ્રેષયામાસ, નિમન્ત્રિતાન્ વદત, પશ્યત, મમ ભેજ્યમાસાદિતમાસ્તે, નિજવ્ટષાદિપુષ્ટજન્તૂન્ મારયિત્વા સર્વ્વં ખાદ્યદ્રવ્યમાસાદિતવાન્, યૂયં વિવાહમાગચ્છત| ");
INSERT INTO sanguj_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","તથપિ તે તુચ્છીકૃત્ય કેચિત્ નિજક્ષેત્રં કેચિદ્ વાણિજ્યં પ્રતિ સ્વસ્વમાર્ગેણ ચલિતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","અન્યે લોકાસ્તસ્ય દાસેયાન્ ધૃત્વા દૌરાત્મ્યં વ્યવહૃત્ય તાનવધિષુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","અનન્તરં સ નૃપતિસ્તાં વાર્ત્તાં શ્રુત્વા ક્રુધ્યન્ સૈન્યાનિ પ્રહિત્ય તાન્ ઘાતકાન્ હત્વા તેષાં નગરં દાહયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","તતઃ સ નિજદાસેયાન્ બભાષે, વિવાહીયં ભોજ્યમાસાદિતમાસ્તે, કિન્તુ નિમન્ત્રિતા જના અયોગ્યાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","તસ્માદ્ યૂયં રાજમાર્ગં ગત્વા યાવતો મનુજાન્ પશ્યત, તાવતએવ વિવાહીયભોજ્યાય નિમન્ત્રયત| ");
INSERT INTO sanguj_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","તદા તે દાસેયા રાજમાર્ગં ગત્વા ભદ્રાન્ અભદ્રાન્ વા યાવતો જનાન્ દદૃશુઃ, તાવતએવ સંગૃહ્યાનયન્; તતોઽભ્યાગતમનુજૈ ર્વિવાહગૃહમ્ અપૂર્ય્યત| ");
INSERT INTO sanguj_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","તદાનીં સ રાજા સર્વ્વાનભ્યાગતાન્ દ્રષ્ટુમ્ અભ્યન્તરમાગતવાન્; તદા તત્ર વિવાહીયવસનહીનમેકં જનં વીક્ષ્ય તં જગાદ્, ");
INSERT INTO sanguj_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","હે મિત્ર,ત્વં વિવાહીયવસનં વિના કથમત્ર પ્રવિષ્ટવાન્? તેન સ નિરુત્તરો બભૂવ| ");
INSERT INTO sanguj_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","તદા રાજા નિજાનુચરાન્ અવદત્, એતસ્ય કરચરણાન્ બદ્ધા યત્ર રોદનં દન્તૈર્દન્તઘર્ષણઞ્ચ ભવતિ, તત્ર વહિર્ભૂતતમિસ્રે તં નિક્ષિપત| ");
INSERT INTO sanguj_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","ઇત્થં બહવ આહૂતા અલ્પે મનોભિમતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","અનન્તરં ફિરૂશિનઃ પ્રગત્ય યથા સંલાપેન તમ્ ઉન્માથે પાતયેયુસ્તથા મન્ત્રયિત્વા ");
INSERT INTO sanguj_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","હેરોદીયમનુજૈઃ સાકં નિજશિષ્યગણેન તં પ્રતિ કથયામાસુઃ, હે ગુરો, ભવાન્ સત્યઃ સત્યમીશ્વરીયમાર્ગમુપદિશતિ, કમપિ માનુષં નાનુરુધ્યતે, કમપિ નાપેક્ષતે ચ, તદ્ વયં જાનીમઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","અતઃ કૈસરભૂપાય કરોઽસ્માકં દાતવ્યો ન વા? અત્ર ભવતા કિં બુધ્યતે? તદ્ અસ્માન્ વદતુ| ");
INSERT INTO sanguj_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","તતો યીશુસ્તેષાં ખલતાં વિજ્ઞાય કથિતવાન્, રે કપટિનઃ યુયં કુતો માં પરિક્ષધ્વે? ");
INSERT INTO sanguj_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","તત્કરદાનસ્ય મુદ્રાં માં દર્શયત| તદાનીં તૈસ્તસ્ય સમીપં મુદ્રાચતુર્થભાગ આનીતે ");
INSERT INTO sanguj_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","સ તાન્ પપ્રચ્છ, અત્ર કસ્યેયં મૂર્ત્તિ ર્નામ ચાસ્તે? તે જગદુઃ, કૈસરભૂપસ્ય| ");
INSERT INTO sanguj_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","તતઃ સ ઉક્તવાન, કૈસરસ્ય યત્ તત્ કૈસરાય દત્ત, ઈશ્વરસ્ય યત્ તદ્ ઈશ્વરાય દત્ત| ");
INSERT INTO sanguj_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ઇતિ વાક્યં નિશમ્ય તે વિસ્મયં વિજ્ઞાય તં વિહાય ચલિતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","તસ્મિન્નહનિ સિદૂકિનોઽર્થાત્ શ્મશાનાત્ નોત્થાસ્યન્તીતિ વાક્યં યે વદન્તિ, તે યીશેाરન્તિકમ્ આગત્ય પપ્રચ્છુઃ, ");
INSERT INTO sanguj_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","હે ગુરો, કશ્ચિન્મનુજશ્ચેત્ નિઃસન્તાનઃ સન્ પ્રાણાન્ ત્યજતિ, તર્હિ તસ્ય ભ્રાતા તસ્ય જાયાં વ્યુહ્ય ભ્રાતુઃ સન્તાનમ્ ઉત્પાદયિષ્યતીતિ મૂસા આદિષ્ટવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","કિન્ત્વસ્માકમત્ર કેઽપિ જનાઃ સપ્તસહોદરા આસન્, તેષાં જ્યેષ્ઠ એકાં કન્યાં વ્યવહાત્, અપરં પ્રાણત્યાગકાલે સ્વયં નિઃસન્તાનઃ સન્ તાં સ્ત્રિયં સ્વભ્રાતરિ સમર્પિતવાન્, ");
INSERT INTO sanguj_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","તતો દ્વિતીયાદિસપ્તમાન્તાશ્ચ તથૈવ ચક્રુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","શેષે સાપી નારી મમાર| ");
INSERT INTO sanguj_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","મૃતાનામ્ ઉત્થાનસમયે તેષાં સપ્તાનાં મધ્યે સા નારી કસ્ય ભાર્ય્યા ભવિષ્યતિ? યસ્માત્ સર્વ્વએવ તાં વ્યવહન્| ");
INSERT INTO sanguj_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","તતો યીશુઃ પ્રત્યવાદીત્, યૂયં ધર્મ્મપુસ્તકમ્ ઈશ્વરીયાં શક્તિઞ્ચ ન વિજ્ઞાય ભ્રાન્તિમન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","ઉત્થાનપ્રાપ્તા લોકા ન વિવહન્તિ, ન ચ વાચા દીયન્તે, કિન્ત્વીશ્વરસ્ય સ્વર્ગસ્થદૂતાનાં સદૃશા ભવન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","અપરં મૃતાનામુત્થાનમધિ યુષ્માન્ પ્રતીયમીશ્વરોક્તિઃ, ");
INSERT INTO sanguj_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","\"અહમિબ્રાહીમ ઈશ્વર ઇસ્હાક ઈશ્વરો યાકૂબ ઈશ્વર\" ઇતિ કિં યુષ્માભિ ર્નાપાઠિ? કિન્ત્વીશ્વરો જીવતામ્ ઈશ્વર:, સ મૃતાનામીશ્વરો નહિ| ");
INSERT INTO sanguj_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ઇતિ શ્રુત્વા સર્વ્વે લોકાસ્તસ્યોપદેશાદ્ વિસ્મયં ગતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","અનન્તરં સિદૂકિનામ્ નિરુત્તરત્વવાર્તાં નિશમ્ય ફિરૂશિન એકત્ર મિલિતવન્તઃ, ");
INSERT INTO sanguj_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","તેષામેકો વ્યવસ્થાપકો યીશું પરીક્ષિતું પપચ્છ, ");
INSERT INTO sanguj_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","હે ગુરો વ્યવસ્થાશાસ્ત્રમધ્યે કાજ્ઞા શ્રેષ્ઠા? ");
INSERT INTO sanguj_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","તતો યીશુરુવાચ, ત્વં સર્વ્વાન્તઃકરણૈઃ સર્વ્વપ્રાણૈઃ સર્વ્વચિત્તૈશ્ચ સાકં પ્રભૌ પરમેશ્વરે પ્રીયસ્વ, ");
INSERT INTO sanguj_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","એષા પ્રથમમહાજ્ઞા| તસ્યાઃ સદૃશી દ્વિતીયાજ્ઞૈષા, ");
INSERT INTO sanguj_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","તવ સમીપવાસિનિ સ્વાત્મનીવ પ્રેમ કુરુ| ");
INSERT INTO sanguj_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","અનયો ર્દ્વયોરાજ્ઞયોઃ કૃત્સ્નવ્યવસ્થાયા ભવિષ્યદ્વક્તૃગ્રન્થસ્ય ચ ભારસ્તિષ્ઠતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","અનન્તરં ફિરૂશિનામ્ એકત્ર સ્થિતિકાલે યીશુસ્તાન્ પપ્રચ્છ, ");
INSERT INTO sanguj_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","ખ્રીષ્ટમધિ યુષ્માકં કીદૃગ્બોધો જાયતે? સ કસ્ય સન્તાનઃ? તતસ્તે પ્રત્યવદન્, દાયૂદઃ સન્તાનઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","તદા સ ઉક્તવાન્, તર્હિ દાયૂદ્ કથમ્ આત્માધિષ્ઠાનેન તં પ્રભું વદતિ ? ");
INSERT INTO sanguj_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","યથા મમ પ્રભુમિદં વાક્યમવદત્ પરમેશ્વરઃ| તવારીન્ પાદપીઠં તે યાવન્નહિ કરોમ્યહં| તાવત્ કાલં મદીયે ત્વં દક્ષપાર્શ્વ ઉપાવિશ| અતો યદિ દાયૂદ્ તં પ્રભું વદતિ, ર્તિહ સ કથં તસ્ય સન્તાનો ભવતિ? ");
INSERT INTO sanguj_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","તદાનીં તેષાં કોપિ તદ્વાક્યસ્ય કિમપ્યુત્તરં દાતું નાશક્નોત્; ");
INSERT INTO sanguj_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","તદ્દિનમારભ્ય તં કિમપિ વાક્યં પ્રષ્ટું કસ્યાપિ સાહસો નાભવત્| ");
INSERT INTO sanguj_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","અનન્તરં યીશુ ર્જનનિવહં શિષ્યાંશ્ચાવદત્, ");
INSERT INTO sanguj_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","અધ્યાપકાઃ ફિરૂશિનશ્ચ મૂસાસને ઉપવિશન્તિ, ");
INSERT INTO sanguj_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","અતસ્તે યુષ્માન્ યદ્યત્ મન્તુમ્ આજ્ઞાપયન્તિ, તત્ મન્યધ્વં પાલયધ્વઞ્ચ, કિન્તુ તેષાં કર્મ્માનુરૂપં કર્મ્મ ન કુરુધ્વં; યતસ્તેષાં વાક્યમાત્રં સારં કાર્ય્યે કિમપિ નાસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","તે દુર્વ્વહાન્ ગુરુતરાન્ ભારાન્ બદ્વ્વા મનુષ્યાણાં સ્કન્ધેપરિ સમર્પયન્તિ, કિન્તુ સ્વયમઙ્ગુલ્યૈકયાપિ ન ચાલયન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","કેવલં લોકદર્શનાય સર્વ્વકર્મ્માણિ કુર્વ્વન્તિ; ફલતઃ પટ્ટબન્ધાન્ પ્રસાર્ય્ય ધારયન્તિ, સ્વવસ્ત્રેષુ ચ દીર્ઘગ્રન્થીન્ ધારયન્તિ; ");
INSERT INTO sanguj_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ભોજનભવન ઉચ્ચસ્થાનં, ભજનભવને પ્રધાનમાસનં, ");
INSERT INTO sanguj_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","હટ્ઠે નમસ્કારં ગુરુરિતિ સમ્બોધનઞ્ચૈતાનિ સર્વ્વાણિ વાઞ્છન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","કિન્તુ યૂયં ગુરવ ઇતિ સમ્બોધનીયા મા ભવત, યતો યુષ્માકમ્ એકઃ ખ્રીષ્ટએવ ગુરુ ");
INSERT INTO sanguj_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ર્યૂયં સર્વ્વે મિથો ભ્રાતરશ્ચ| પુનઃ પૃથિવ્યાં કમપિ પિતેતિ મા સમ્બુધ્યધ્વં, યતો યુષ્માકમેકઃ સ્વર્ગસ્થએવ પિતા| ");
INSERT INTO sanguj_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","યૂયં નાયકેતિ સમ્ભાષિતા મા ભવત, યતો યુષ્માકમેકઃ ખ્રીષ્ટએવ નાયકઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","અપરં યુષ્માકં મધ્યે યઃ પુમાન્ શ્રેષ્ઠઃ સ યુષ્માન્ સેવિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","યતો યઃ સ્વમુન્નમતિ, સ નતઃ કરિષ્યતે; કિન્તુ યઃ કશ્ચિત્ સ્વમવનતં કરોતિ, સ ઉન્નતઃ કરિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","હન્ત કપટિન ઉપાધ્યાયાઃ ફિરૂશિનશ્ચ, યૂયં મનુજાનાં સમક્ષં સ્વર્ગદ્વારં રુન્ધ, યૂયં સ્વયં તેન ન પ્રવિશથ, પ્રવિવિક્ષૂનપિ વારયથ| વત કપટિન ઉપાધ્યાયાઃ ફિરૂશિનશ્ચ યૂયં છલાદ્ દીર્ઘં પ્રાર્થ્ય વિધવાનાં સર્વ્વસ્વં ગ્રસથ, યુષ્માકં ઘોરતરદણ્ડો ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","હન્ત કપટિન ઉપાધ્યાયાઃ ફિરૂશિનશ્ચ, યૂયમેકં સ્વધર્મ્માવલમ્બિનં કર્ત્તું સાગરં ભૂમણ્ડલઞ્ચ પ્રદક્ષિણીકુરુથ, ");
INSERT INTO sanguj_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","કઞ્ચન પ્રાપ્ય સ્વતો દ્વિગુણનરકભાજનં તં કુરુથ| ");
INSERT INTO sanguj_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","વત અન્ધપથદર્શકાઃ સર્વ્વે, યૂયં વદથ, મન્દિરસ્ય શપથકરણાત્ કિમપિ ન દેયં; કિન્તુ મન્દિરસ્થસુવર્ણસ્ય શપથકરણાદ્ દેયં| ");
INSERT INTO sanguj_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","હે મૂઢા હે અન્ધાઃ સુવર્ણં તત્સુવર્ણપાવકમન્દિરમ્ એતયોરુભયો ર્મધ્યે કિં શ્રેયઃ? ");
INSERT INTO sanguj_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","અન્યચ્ચ વદથ, યજ્ઞવેદ્યાઃ શપથકરણાત્ કિમપિ ન દેયં, કિન્તુ તદુપરિસ્થિતસ્ય નૈવેદ્યસ્ય શપથકરણાદ્ દેયં| ");
INSERT INTO sanguj_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","હે મૂઢા હે અન્ધાઃ, નૈવેદ્યં તન્નૈવેદ્યપાવકવેદિરેતયોરુભયો ર્મધ્યે કિં શ્રેયઃ? ");
INSERT INTO sanguj_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","અતઃ કેનચિદ્ યજ્ઞવેદ્યાઃ શપથે કૃતે તદુપરિસ્થસ્ય સર્વ્વસ્ય શપથઃ ક્રિયતે| ");
INSERT INTO sanguj_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","કેનચિત્ મન્દિરસ્ય શપથે કૃતે મન્દિરતન્નિવાસિનોઃ શપથઃ ક્રિયતે| ");
INSERT INTO sanguj_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","કેનચિત્ સ્વર્ગસ્ય શપથે કૃતે ઈશ્વરીયસિંહાસનતદુપર્ય્યુપવિષ્ટયોઃ શપથઃ ક્રિયતે| ");
INSERT INTO sanguj_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","હન્ત કપટિન ઉપાધ્યાયાઃ ફિરૂશિનશ્ચ, યૂયં પોદિનાયાઃ સિતચ્છત્રાયા જીરકસ્ય ચ દશમાંશાન્ દત્થ, કિન્તુ વ્યવસ્થાયા ગુરુતરાન્ ન્યાયદયાવિશ્વાસાન્ પરિત્યજથ; ઇમે યુષ્માભિરાચરણીયા અમી ચ ન લંઘનીયાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","હે અન્ધપથદર્શકા યૂયં મશકાન્ અપસારયથ, કિન્તુ મહાઙ્ગાન્ ગ્રસથ| ");
INSERT INTO sanguj_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","હન્ત કપટિન ઉપાધ્યાયાઃ ફિરૂશિનશ્ચ, યૂયં પાનપાત્રાણાં ભોજનપાત્રાણાઞ્ચ બહિઃ પરિષ્કુરુથ; કિન્તુ તદભ્યન્તરં દુરાત્મતયા કલુષેણ ચ પરિપૂર્ણમાસ્તે| ");
INSERT INTO sanguj_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","હે અન્ધાઃ ફિરૂશિલોકા આદૌ પાનપાત્રાણાં ભોજનપાત્રાણાઞ્ચાભ્યન્તરં પરિષ્કુરુત, તેન તેષાં બહિરપિ પરિષ્કારિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","હન્ત કપટિન ઉપાધ્યાયાઃ ફિરૂશિનશ્ચ, યૂયં શુક્લીકૃતશ્મશાનસ્વરૂપા ભવથ, યથા શ્મશાનભવનસ્ય બહિશ્ચારુ, કિન્ત્વભ્યન્તરં મૃતલોકાનાં કીકશૈઃ સર્વ્વપ્રકારમલેન ચ પરિપૂર્ણમ્; ");
INSERT INTO sanguj_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","તથૈવ યૂયમપિ લોકાનાં સમક્ષં બહિર્ધાર્મ્મિકાઃ કિન્ત્વન્તઃકરણેષુ કેવલકાપટ્યાધર્મ્માભ્યાં પરિપૂર્ણાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","હા હા કપટિન ઉપાધ્યાયાઃ ફિરૂશિનશ્ચ, યૂયં ભવિષ્યદ્વાદિનાં શ્મશાનગેહં નિર્મ્માથ, સાધૂનાં શ્મશાનનિકેતનં શોભયથ ");
INSERT INTO sanguj_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","વદથ ચ યદિ વયં સ્વેષાં પૂર્વ્વપુરુષાણાં કાલ અસ્થાસ્યામ, તર્હિ ભવિષ્યદ્વાદિનાં શોણિતપાતને તેષાં સહભાગિનો નાભવિષ્યામ| ");
INSERT INTO sanguj_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","અતો યૂયં ભવિષ્યદ્વાદિઘાતકાનાં સન્તાના ઇતિ સ્વયમેવ સ્વેષાં સાક્ષ્યં દત્થ| ");
INSERT INTO sanguj_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","અતો યૂયં નિજપૂર્વ્વપુરુષાણાં પરિમાણપાત્રં પરિપૂરયત| ");
INSERT INTO sanguj_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","રે ભુજગાઃ કૃષ્ણભુજગવંશાઃ, યૂયં કથં નરકદણ્ડાદ્ રક્ષિષ્યધ્વે| ");
INSERT INTO sanguj_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","પશ્યત, યુષ્માકમન્તિકમ્ અહં ભવિષ્યદ્વાદિનો બુદ્ધિમત ઉપાધ્યાયાંશ્ચ પ્રેષયિષ્યામિ, કિન્તુ તેષાં કતિપયા યુષ્માભિ ર્ઘાનિષ્યન્તે, ક્રુશે ચ ઘાનિષ્યન્તે, કેચિદ્ ભજનભવને કષાભિરાઘાનિષ્યન્તે, નગરે નગરે તાડિષ્યન્તે ચ; ");
INSERT INTO sanguj_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","તેન સત્પુરુષસ્ય હાબિલો રક્તપાતમારભ્ય બેરિખિયઃ પુત્રં યં સિખરિયં યૂયં મન્દિરયજ્ઞવેદ્યો ર્મધ્યે હતવન્તઃ, તદીયશોણિતપાતં યાવદ્ અસ્મિન્ દેશે યાવતાં સાધુપુરુષાણાં શોણિતપાતો ઽભવત્ તત્ સર્વ્વેષામાગસાં દણ્ડા યુષ્માસુ વર્ત્તિષ્યન્તે| ");
INSERT INTO sanguj_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","અહં યુષ્માન્ત તથ્યં વદામિ, વિદ્યમાનેઽસ્મિન્ પુરુષે સર્વ્વે વર્ત્તિષ્યન્તે| ");
INSERT INTO sanguj_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","હે યિરૂશાલમ્ હે યિરૂશાલમ્ નગરિ ત્વં ભવિષ્યદ્વાદિનો હતવતી, તવ સમીપં પ્રેરિતાંશ્ચ પાષાણૈરાહતવતી, યથા કુક્કુટી શાવકાન્ પક્ષાધઃ સંગૃહ્લાતિ, તથા તવ સન્તાનાન્ સંગ્રહીતું અહં બહુવારમ્ ઐચ્છં; કિન્તુ ત્વં ન સમમન્યથાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","પશ્યત યષ્માકં વાસસ્થાનમ્ ઉચ્છિન્નં ત્યક્ષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","અહં યુષ્માન્ તથ્યં વદામિ, યઃ પરમેશ્વરસ્ય નામ્નાગચ્છતિ, સ ધન્ય ઇતિ વાણીં યાવન્ન વદિષ્યથ, તાવત્ માં પુન ર્ન દ્રક્ષ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","અનન્તરં યીશુ ર્યદા મન્દિરાદ્ બહિ ર્ગચ્છતિ, તદાનીં શિષ્યાસ્તં મન્દિરનિર્મ્માણં દર્શયિતુમાગતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","તતો યીશુસ્તાનુવાચ, યૂયં કિમેતાનિ ન પશ્યથ? યુષ્માનહં સત્યં વદામિ, એતન્નિચયનસ્ય પાષાણૈકમપ્યન્યપાષાણેाપરિ ન સ્થાસ્યતિ સર્વ્વાણિ ભૂમિસાત્ કારિષ્યન્તે| ");
INSERT INTO sanguj_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","અનન્તરં તસ્મિન્ જૈતુનપર્વ્વતોપરિ સમુપવિષ્ટે શિષ્યાસ્તસ્ય સમીપમાગત્ય ગુપ્તં પપ્રચ્છુઃ, એતા ઘટનાઃ કદા ભવિષ્યન્તિ? ભવત આગમનસ્ય યુગાન્તસ્ય ચ કિં લક્ષ્મ? તદસ્માન્ વદતુ| ");
INSERT INTO sanguj_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","તદાનીં યીશુસ્તાનવોચત્, અવધદ્વ્વં, કોપિ યુષ્માન્ ન ભ્રમયેત્| ");
INSERT INTO sanguj_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","બહવો મમ નામ ગૃહ્લન્ત આગમિષ્યન્તિ, ખ્રીષ્ટોઽહમેવેતિ વાચં વદન્તો બહૂન્ ભ્રમયિષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","યૂયઞ્ચ સંગ્રામસ્ય રણસ્ય ચાડમ્બરં શ્રોષ્યથ, અવધદ્વ્વં તેન ચઞ્ચલા મા ભવત, એતાન્યવશ્યં ઘટિષ્યન્તે, કિન્તુ તદા યુગાન્તો નહિ| ");
INSERT INTO sanguj_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","અપરં દેશસ્ય વિપક્ષો દેશો રાજ્યસ્ય વિપક્ષો રાજ્યં ભવિષ્યતિ, સ્થાને સ્થાને ચ દુર્ભિક્ષં મહામારી ભૂકમ્પશ્ચ ભવિષ્યન્તિ, ");
INSERT INTO sanguj_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","એતાનિ દુઃખોપક્રમાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","તદાનીં લોકા દુઃખં ભોજયિતું યુષ્માન્ પરકરેષુ સમર્પયિષ્યન્તિ હનિષ્યન્તિ ચ, તથા મમ નામકારણાદ્ યૂયં સર્વ્વદેશીયમનુજાનાં સમીપે ઘૃણાર્હા ભવિષ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","બહુષુ વિઘ્નં પ્રાપ્તવત્સુ પરસ્પરમ્ ઋृતીયાં કૃતવત્સુ ચ એકોઽપરં પરકરેષુ સમર્પયિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","તથા બહવો મૃષાભવિષ્યદ્વાદિન ઉપસ્થાય બહૂન્ ભ્રમયિષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","દુષ્કર્મ્મણાં બાહુલ્યાઞ્ચ બહૂનાં પ્રેમ શીતલં ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","કિન્તુ યઃ કશ્ચિત્ શેષં યાવદ્ ધૈર્ય્યમાશ્રયતે, સએવ પરિત્રાયિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","અપરં સર્વ્વદેશીયલોકાન્ પ્રતિમાક્ષી ભવિતું રાજસ્ય શુભસમાચારઃ સર્વ્વજગતિ પ્રચારિષ્યતે, એતાદૃશિ સતિ યુગાન્ત ઉપસ્થાસ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","અતો યત્ સર્વ્વનાશકૃદ્ઘૃણાર્હં વસ્તુ દાનિયેલ્ભવિષ્યદ્વદિના પ્રોક્તં તદ્ યદા પુણ્યસ્થાને સ્થાપિતં દ્રક્ષ્યથ, (યઃ પઠતિ, સ બુધ્યતાં) ");
INSERT INTO sanguj_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","તદાનીં યે યિહૂદીયદેશે તિષ્ઠન્તિ, તે પર્વ્વતેષુ પલાયન્તાં| ");
INSERT INTO sanguj_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","યઃ કશ્ચિદ્ ગૃહપૃષ્ઠે તિષ્ઠતિ, સ ગૃહાત્ કિમપિ વસ્ત્વાનેતુમ્ અધેा નાવરોહેત્| ");
INSERT INTO sanguj_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","યશ્ચ ક્ષેત્રે તિષ્ઠતિ, સોપિ વસ્ત્રમાનેતું પરાવૃત્ય ન યાયાત્| ");
INSERT INTO sanguj_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","તદાનીં ગર્ભિણીસ્તન્યપાયયિત્રીણાં દુર્ગતિ ર્ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","અતો યષ્માકં પલાયનં શીતકાલે વિશ્રામવારે વા યન્ન ભવેત્, તદર્થં પ્રાર્થયધ્વમ્| ");
INSERT INTO sanguj_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","આ જગદારમ્ભાદ્ એતત્કાલપર્ય્યનન્તં યાદૃશઃ કદાપિ નાભવત્ ન ચ ભવિષ્યતિ તાદૃશો મહાક્લેશસ્તદાનીમ્ ઉપસ્થાસ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","તસ્ય ક્લેશસ્ય સમયો યદિ હ્સ્વો ન ક્રિયેત, તર્હિ કસ્યાપિ પ્રાણિનો રક્ષણં ભવિતું ન શક્નુયાત્, કિન્તુ મનોનીતમનુજાનાં કૃતે સ કાલો હ્સ્વીકરિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","અપરઞ્ચ પશ્યત, ખ્રીષ્ટોઽત્ર વિદ્યતે, વા તત્ર વિદ્યતે, તદાનીં યદી કશ્ચિદ્ યુષ્માન ઇતિ વાક્યં વદતિ, તથાપિ તત્ ન પ્રતીત્| ");
INSERT INTO sanguj_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","યતો ભાક્તખ્રીષ્ટા ભાક્તભવિષ્યદ્વાદિનશ્ચ ઉપસ્થાય યાનિ મહન્તિ લક્ષ્માણિ ચિત્રકર્મ્માણિ ચ પ્રકાશયિષ્યન્તિ, તૈ ર્યદિ સમ્ભવેત્ તર્હિ મનોનીતમાનવા અપિ ભ્રામિષ્યન્તે| ");
INSERT INTO sanguj_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","પશ્યત, ઘટનાતઃ પૂર્વ્વં યુષ્માન્ વાર્ત્તામ્ અવાદિષમ્| ");
INSERT INTO sanguj_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","અતઃ પશ્યત, સ પ્રાન્તરે વિદ્યત ઇતિ વાક્યે કેનચિત્ કથિતેપિ બહિ ર્મા ગચ્છત, વા પશ્યત, સોન્તઃપુરે વિદ્યતે, એતદ્વાક્ય ઉક્તેપિ મા પ્રતીત| ");
INSERT INTO sanguj_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","યતો યથા વિદ્યુત્ પૂર્વ્વદિશો નિર્ગત્ય પશ્ચિમદિશં યાવત્ પ્રકાશતે, તથા માનુષપુત્રસ્યાપ્યાગમનં ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","યત્ર શવસ્તિષ્ઠતિ, તત્રેવ ગૃધ્રા મિલન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","અપરં તસ્ય ક્લેશસમયસ્યાવ્યવહિતપરત્ર સૂર્ય્યસ્ય તેજો લોપ્સ્યતે, ચન્દ્રમા જ્યોસ્નાં ન કરિષ્યતિ, નભસો નક્ષત્રાણિ પતિષ્યન્તિ, ગગણીયા ગ્રહાશ્ચ વિચલિષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","તદાનીમ્ આકાશમધ્યે મનુજસુતસ્ય લક્ષ્મ દર્શિષ્યતે, તતો નિજપરાક્રમેણ મહાતેજસા ચ મેઘારૂઢં મનુજસુતં નભસાગચ્છન્તં વિલોક્ય પૃથિવ્યાઃ સર્વ્વવંશીયા વિલપિષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","તદાનીં સ મહાશબ્દાયમાનતૂર્ય્યા વાદકાન્ નિજદૂતાન્ પ્રહેષ્યતિ, તે વ્યોમ્ન એકસીમાતોઽપરસીમાં યાવત્ ચતુર્દિશસ્તસ્ય મનોનીતજનાન્ આનીય મેલયિષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","ઉડુમ્બરપાદપસ્ય દૃષ્ટાન્તં શિક્ષધ્વં; યદા તસ્ય નવીનાઃ શાખા જાયન્તે, પલ્લવાદિશ્ચ નિર્ગચ્છતિ, તદા નિદાઘકાલઃ સવિધો ભવતીતિ યૂયં જાનીથ; ");
INSERT INTO sanguj_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","તદ્વદ્ એતા ઘટના દૃષ્ટ્વા સ સમયો દ્વાર ઉપાસ્થાદ્ ઇતિ જાનીત| ");
INSERT INTO sanguj_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","યુષ્માનહં તથ્યં વદામિ, ઇદાનીન્તનજનાનાં ગમનાત્ પૂર્વ્વમેવ તાનિ સર્વ્વાણિ ઘટિષ્યન્તે| ");
INSERT INTO sanguj_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","નભોમેદિન્યો ર્લુપ્તયોરપિ મમ વાક્ કદાપિ ન લોપ્સ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","અપરં મમ તાતં વિના માનુષઃ સ્વર્ગસ્થો દૂતો વા કોપિ તદ્દિનં તદ્દણ્ડઞ્ચ ન જ્ઞાપયતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","અપરં નોહે વિદ્યમાને યાદૃશમભવત્ તાદૃશં મનુજસુતસ્યાગમનકાલેપિ ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","ફલતો જલાપ્લાવનાત્ પૂર્વ્વં યદ્દિનં યાવત્ નોહઃ પોતં નારોહત્, તાવત્કાલં યથા મનુષ્યા ભોજને પાને વિવહને વિવાહને ચ પ્રવૃત્તા આસન્; ");
INSERT INTO sanguj_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","અપરમ્ આપ્લાવિતોયમાગત્ય યાવત્ સકલમનુજાન્ પ્લાવયિત્વા નાનયત્, તાવત્ તે યથા ન વિદામાસુઃ, તથા મનુજસુતાગમનેપિ ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","તદા ક્ષેત્રસ્થિતયોર્દ્વયોરેકો ધારિષ્યતે, અપરસ્ત્યાજિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","તથા પેષણ્યા પિંષત્યોરુભયો ર્યોષિતોરેકા ધારિષ્યતેઽપરા ત્યાજિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","યુષ્માકં પ્રભુઃ કસ્મિન્ દણ્ડ આગમિષ્યતિ, તદ્ યુષ્માભિ ર્નાવગમ્યતે, તસ્માત્ જાગ્રતઃ સન્તસ્તિષ્ઠત| ");
INSERT INTO sanguj_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","કુત્ર યામે સ્તેન આગમિષ્યતીતિ ચેદ્ ગૃહસ્થો જ્ઞાતુમ્ અશક્ષ્યત્, તર્હિ જાગરિત્વા તં સન્ધિં કર્ત્તિતુમ્ અવારયિષ્યત્ તદ્ જાનીત| ");
INSERT INTO sanguj_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","યુષ્માભિરવધીયતાં, યતો યુષ્માભિ ર્યત્ર ન બુધ્યતે, તત્રૈવ દણ્ડે મનુજસુત આયાસ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","પ્રભુ ર્નિજપરિવારાન્ યથાકાલં ભોજયિતું યં દાસમ્ અધ્યક્ષીકૃત્ય સ્થાપયતિ, તાદૃશો વિશ્વાસ્યો ધીમાન્ દાસઃ કઃ? ");
INSERT INTO sanguj_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","પ્રભુરાગત્ય યં દાસં તથાચરન્તં વીક્ષતે, સએવ ધન્યઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","યુષ્માનહં સત્યં વદામિ, સ તં નિજસર્વ્વસ્વસ્યાધિપં કરિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","કિન્તુ પ્રભુરાગન્તું વિલમ્બત ઇતિ મનસિ ચિન્તયિત્વા યો દુષ્ટો દાસો ");
INSERT INTO sanguj_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ઽપરદાસાન્ પ્રહર્ત્તું મત્તાનાં સઙ્ગે ભોક્તું પાતુઞ્ચ પ્રવર્ત્તતે, ");
INSERT INTO sanguj_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","સ દાસો યદા નાપેક્ષતે, યઞ્ચ દણ્ડં ન જાનાતિ, તત્કાલએવ તત્પ્રભુરુપસ્થાસ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","તદા તં દણ્ડયિત્વા યત્ર સ્થાને રોદનં દન્તઘર્ષણઞ્ચાસાતે, તત્ર કપટિભિઃ સાકં તદ્દશાં નિરૂપયિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","યા દશ કન્યાઃ પ્રદીપાન્ ગૃહ્લત્યો વરં સાક્ષાત્ કર્ત્તું બહિરિતાઃ, તાભિસ્તદા સ્વર્ગીયરાજ્યસ્ય સાદૃશ્યં ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","તાસાં કન્યાનાં મધ્યે પઞ્ચ સુધિયઃ પઞ્ચ દુર્ધિય આસન્| ");
INSERT INTO sanguj_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","યા દુર્ધિયસ્તાઃ પ્રદીપાન્ સઙ્ગે ગૃહીત્વા તૈલં ન જગૃહુઃ, ");
INSERT INTO sanguj_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","કિન્તુ સુધિયઃ પ્રદીપાન્ પાત્રેણ તૈલઞ્ચ જગૃહુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","અનન્તરં વરે વિલમ્બિતે તાઃ સર્વ્વા નિદ્રાવિષ્ટા નિદ્રાં જગ્મુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","અનન્તરમ્ અર્દ્ધરાત્રે પશ્યત વર આગચ્છતિ, તં સાક્ષાત્ કર્ત્તું બહિર્યાતેતિ જનરવાત્ ");
INSERT INTO sanguj_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","તાઃ સર્વ્વાઃ કન્યા ઉત્થાય પ્રદીપાન્ આસાદયિતું આરભન્ત| ");
INSERT INTO sanguj_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","તતો દુર્ધિયઃ સુધિય ઊચુઃ, કિઞ્ચિત્ તૈલં દત્ત, પ્રદીપા અસ્માકં નિર્વ્વાણાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","કિન્તુ સુધિયઃ પ્રત્યવદન્, દત્તે યુષ્માનસ્માંશ્ચ પ્રતિ તૈલં ન્યૂનીભવેત્, તસ્માદ્ વિક્રેતૃણાં સમીપં ગત્વા સ્વાર્થં તૈલં ક્રીણીત| ");
INSERT INTO sanguj_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","તદા તાસુ ક્રેતું ગતાસુ વર આજગામ, તતો યાઃ સજ્જિતા આસન્, તાસ્તેન સાકં વિવાહીયં વેશ્મ પ્રવિવિશુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","અનન્તરં દ્વારે રુદ્ધે અપરાઃ કન્યા આગત્ય જગદુઃ, હે પ્રભો, હે પ્રભો, અસ્માન્ પ્રતિ દ્વારં મોચય| ");
INSERT INTO sanguj_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","કિન્તુ સ ઉક્તવાન્, તથ્યં વદામિ, યુષ્માનહં ન વેદ્મિ| ");
INSERT INTO sanguj_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","અતો જાગ્રતઃ સન્તસ્તિષ્ઠત, મનુજસુતઃ કસ્મિન્ દિને કસ્મિન્ દણ્ડે વાગમિષ્યતિ, તદ્ યુષ્માભિ ર્ન જ્ઞાયતે| ");
INSERT INTO sanguj_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","અપરં સ એતાદૃશઃ કસ્યચિત્ પુંસસ્તુલ્યઃ, યો દૂરદેશં પ્રતિ યાત્રાકાલે નિજદાસાન્ આહૂય તેષાં સ્વસ્વસામર્થ્યાનુરૂપમ્ ");
INSERT INTO sanguj_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","એકસ્મિન્ મુદ્રાણાં પઞ્ચ પોટલિકાઃ અન્યસ્મિંશ્ચ દ્વે પોટલિકે અપરસ્મિંશ્ચ પોટલિકૈકામ્ ઇત્થં પ્રતિજનં સમર્પ્ય સ્વયં પ્રવાસં ગતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","અનન્તરં યો દાસઃ પઞ્ચ પોટલિકાઃ લબ્ધવાન્, સ ગત્વા વાણિજ્યં વિધાય તા દ્વિગુણીચકાર| ");
INSERT INTO sanguj_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","યશ્ચ દાસો દ્વે પોટલિકે અલભત, સોપિ તા મુદ્રા દ્વિગુણીચકાર| ");
INSERT INTO sanguj_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","કિન્તુ યો દાસ એકાં પોટલિકાં લબ્ધવાન્, સ ગત્વા ભૂમિં ખનિત્વા તન્મધ્યે નિજપ્રભોસ્તા મુદ્રા ગોપયાઞ્ચકાર| ");
INSERT INTO sanguj_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","તદનન્તરં બહુતિથે કાલે ગતે તેષાં દાસાનાં પ્રભુરાગત્ય તૈર્દાસૈઃ સમં ગણયાઞ્ચકાર| ");
INSERT INTO sanguj_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","તદાનીં યઃ પઞ્ચ પોટલિકાઃ પ્રાપ્તવાન્ સ તા દ્વિગુણીકૃતમુદ્રા આનીય જગાદ; હે પ્રભો, ભવતા મયિ પઞ્ચ પોટલિકાઃ સમર્પિતાઃ, પશ્યતુ, તા મયા દ્વિગુણીકૃતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","તદાનીં તસ્ય પ્રભુસ્તમુવાચ, હે ઉત્તમ વિશ્વાસ્ય દાસ, ત્વં ધન્યોસિ, સ્તોકેન વિશ્વાસ્યો જાતઃ, તસ્માત્ ત્વાં બહુવિત્તાધિપં કરોમિ, ત્વં સ્વપ્રભોઃ સુખસ્ય ભાગી ભવ| ");
INSERT INTO sanguj_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","તતો યેન દ્વે પોટલિકે લબ્ધે સોપ્યાગત્ય જગાદ, હે પ્રભો, ભવતા મયિ દ્વે પોટલિકે સમર્પિતે, પશ્યતુ તે મયા દ્વિગુણીકૃતે| ");
INSERT INTO sanguj_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","તેન તસ્ય પ્રભુસ્તમવોચત્, હે ઉત્તમ વિશ્વાસ્ય દાસ, ત્વં ધન્યોસિ, સ્તોકેન વિશ્વાસ્યો જાતઃ, તસ્માત્ ત્વાં બહુદ્રવિણાધિપં કરોમિ, ત્વં નિજપ્રભોઃ સુખસ્ય ભાગી ભવ| ");
INSERT INTO sanguj_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","અનન્તરં ય એકાં પોટલિકાં લબ્ધવાન્, સ એત્ય કથિતવાન્, હે પ્રભો, ત્વાં કઠિનનરં જ્ઞાતવાન્, ત્વયા યત્ર નોપ્તં, તત્રૈવ કૃત્યતે, યત્ર ચ ન કીર્ણં, તત્રૈવ સંગૃહ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","અતોહં સશઙ્કઃ સન્ ગત્વા તવ મુદ્રા ભૂમધ્યે સંગોપ્ય સ્થાપિતવાન્, પશ્ય, તવ યત્ તદેવ ગૃહાણ| ");
INSERT INTO sanguj_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","તદા તસ્ય પ્રભુઃ પ્રત્યવદત્ રે દુષ્ટાલસ દાસ, યત્રાહં ન વપામિ, તત્ર છિનદ્મિ, યત્ર ચ ન કિરામિ, તત્રેવ સંગૃહ્લામીતિ ચેદજાનાસ્તર્હિ ");
INSERT INTO sanguj_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","વણિક્ષુ મમ વિત્તાર્પણં તવોચિતમાસીત્, યેનાહમાગત્ય વૃદ્વ્યા સાકં મૂલમુદ્રાઃ પ્રાપ્સ્યમ્| ");
INSERT INTO sanguj_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","અતોસ્માત્ તાં પોટલિકામ્ આદાય યસ્ય દશ પોટલિકાઃ સન્તિ તસ્મિન્નર્પયત| ");
INSERT INTO sanguj_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","યેન વર્દ્વ્યતે તસ્મિન્નૈવાર્પિષ્યતે, તસ્યૈવ ચ બાહુલ્યં ભવિષ્યતિ, કિન્તુ યેન ન વર્દ્વ્યતે, તસ્યાન્તિકે યત્ કિઞ્ચન તિષ્ઠતિ, તદપિ પુનર્નેષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","અપરં યૂયં તમકર્મ્મણ્યં દાસં નીત્વા યત્ર સ્થાને ક્રન્દનં દન્તઘર્ષણઞ્ચ વિદ્યેતે, તસ્મિન્ બહિર્ભૂતતમસિ નિક્ષિપત| ");
INSERT INTO sanguj_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","યદા મનુજસુતઃ પવિત્રદૂતાન્ સઙ્ગિનઃ કૃત્વા નિજપ્રભાવેનાગત્ય નિજતેજોમયે સિંહાસને નિવેક્ષ્યતિ, ");
INSERT INTO sanguj_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","તદા તત્સમ્મુખે સર્વ્વજાતીયા જના સંમેલિષ્યન્તિ| તતો મેષપાલકો યથા છાગેભ્યોઽવીન્ પૃથક્ કરોતિ તથા સોપ્યેકસ્માદન્યમ્ ઇત્થં તાન્ પૃથક કૃત્વાવીન્ ");
INSERT INTO sanguj_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","દક્ષિણે છાગાંશ્ચ વામે સ્થાપયિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","તતઃ પરં રાજા દક્ષિણસ્થિતાન્ માનવાન્ વદિષ્યતિ, આગચ્છત મત્તાતસ્યાનુગ્રહભાજનાનિ, યુષ્મત્કૃત આ જગદારમ્ભત્ યદ્ રાજ્યમ્ આસાદિતં તદધિકુરુત| ");
INSERT INTO sanguj_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","યતો બુભુક્ષિતાય મહ્યં ભોજ્યમ્ અદત્ત, પિપાસિતાય પેયમદત્ત, વિદેશિનં માં સ્વસ્થાનમનયત, ");
INSERT INTO sanguj_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","વસ્ત્રહીનં માં વસનં પર્ય્યધાપયત, પીડીતં માં દ્રષ્ટુમાગચ્છત, કારાસ્થઞ્ચ માં વીક્ષિતુમ આગચ્છત| ");
INSERT INTO sanguj_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","તદા ધાર્મ્મિકાઃ પ્રતિવદિષ્યન્તિ, હે પ્રભો, કદા ત્વાં ક્ષુધિતં વીક્ષ્ય વયમભોજયામ? વા પિપાસિતં વીક્ષ્ય અપાયયામ? ");
INSERT INTO sanguj_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","કદા વા ત્વાં વિદેશિનં વિલોક્ય સ્વસ્થાનમનયામ? કદા વા ત્વાં નગ્નં વીક્ષ્ય વસનં પર્ય્યધાપયામ? ");
INSERT INTO sanguj_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","કદા વા ત્વાં પીડિતં કારાસ્થઞ્ચ વીક્ષ્ય ત્વદન્તિકમગચ્છામ? ");
INSERT INTO sanguj_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","તદાનીં રાજા તાન્ પ્રતિવદિષ્યતિ, યુષ્માનહં સત્યં વદામિ, મમૈતેષાં ભ્રાતૃણાં મધ્યે કઞ્ચનૈકં ક્ષુદ્રતમં પ્રતિ યદ્ અકુરુત, તન્માં પ્રત્યકુરુત| ");
INSERT INTO sanguj_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","પશ્ચાત્ સ વામસ્થિતાન્ જનાન્ વદિષ્યતિ, રે શાપગ્રસ્તાઃ સર્વ્વે, શૈતાને તસ્ય દૂતેભ્યશ્ચ યોઽનન્તવહ્નિરાસાદિત આસ્તે, યૂયં મદન્તિકાત્ તમગ્નિં ગચ્છત| ");
INSERT INTO sanguj_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","યતો ક્ષુધિતાય મહ્યમાહારં નાદત્ત, પિપાસિતાય મહ્યં પેયં નાદત્ત, ");
INSERT INTO sanguj_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","વિદેશિનં માં સ્વસ્થાનં નાનયત, વસનહીનં માં વસનં ન પર્ય્યધાપયત, પીડિતં કારાસ્થઞ્ચ માં વીક્ષિતું નાગચ્છત| ");
INSERT INTO sanguj_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","તદા તે પ્રતિવદિષ્યન્તિ, હે પ્રભો, કદા ત્વાં ક્ષુધિતં વા પિપાસિતં વા વિદેશિનં વા નગ્નં વા પીડિતં વા કારાસ્થં વીક્ષ્ય ત્વાં નાસેવામહિ? ");
INSERT INTO sanguj_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","તદા સ તાન્ વદિષ્યતિ, તથ્યમહં યુષ્માન્ બ્રવીમિ, યુષ્માભિરેષાં કઞ્ચન ક્ષોદિષ્ઠં પ્રતિ યન્નાકારિ, તન્માં પ્રત્યેવ નાકારિ| ");
INSERT INTO sanguj_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","પશ્ચાદમ્યનન્તશાસ્તિં કિન્તુ ધાર્મ્મિકા અનન્તાયુષં ભોક્તું યાસ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","યીશુરેતાન્ પ્રસ્તાવાન્ સમાપ્ય શિષ્યાનૂચે, ");
INSERT INTO sanguj_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","યુષ્માભિ ર્જ્ઞાતં દિનદ્વયાત્ પરં નિસ્તારમહ ઉપસ્થાસ્યતિ, તત્ર મનુજસુતઃ ક્રુશેન હન્તું પરકરેષુ સમર્પિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","તતઃ પરં પ્રધાનયાજકાધ્યાપકપ્રાઞ્ચઃ કિયફાનામ્નો મહાયાજકસ્યાટ્ટાલિકાયાં મિલિત્વા ");
INSERT INTO sanguj_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","કેનોપાયેન યીશું ધૃત્વા હન્તું શક્નુયુરિતિ મન્ત્રયાઞ્ચક્રુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","કિન્તુ તૈરુક્તં મહકાલે ન ધર્ત્તવ્યઃ, ધૃતે પ્રજાનાં કલહેન ભવિતું શક્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","તતો બૈથનિયાપુરે શિમોનાખ્યસ્ય કુષ્ઠિનો વેશ્મનિ યીશૌ તિષ્ઠતિ ");
INSERT INTO sanguj_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","કાચન યોષા શ્વેતોપલભાજનેન મહાર્ઘ્યં સુગન્ધિ તૈલમાનીય ભોજનાયોપવિશતસ્તસ્ય શિરોભ્યષેચત્| ");
INSERT INTO sanguj_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","કિન્તુ તદાલોક્ય તચ્છિષ્યૈઃ કુપિતૈરુક્તં, કુત ઇત્થમપવ્યયતે? ");
INSERT INTO sanguj_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ચેદિદં વ્યક્રેષ્યત, તર્હિ ભૂરિમૂલ્યં પ્રાપ્ય દરિદ્રેભ્યો વ્યતારિષ્યત| ");
INSERT INTO sanguj_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","યીશુના તદવગત્ય તે સમુદિતાઃ, યોષામેનાં કુતો દુઃખિનીં કુરુથ, સા માં પ્રતિ સાધુ કર્મ્માકાર્ષીત્| ");
INSERT INTO sanguj_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","યુષ્માકમં સમીપે દરિદ્રાઃ સતતમેવાસતે, કિન્તુ યુષ્માકમન્તિકેહં નાસે સતતં| ");
INSERT INTO sanguj_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","સા મમ કાયોપરિ સુગન્ધિતૈલં સિક્ત્વા મમ શ્મશાનદાનકર્મ્માકાર્ષીત્| ");
INSERT INTO sanguj_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","અતોહં યુષ્માન્ તથ્યં વદામિ સર્વ્વસ્મિન્ જગતિ યત્ર યત્રૈષ સુસમાચારઃ પ્રચારિષ્યતે, તત્ર તત્રૈતસ્યા નાર્ય્યાઃ સ્મરણાર્થમ્ કર્મ્મેદં પ્રચારિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","તતો દ્વાદશશિષ્યાણામ્ ઈષ્કરિયોતીયયિહૂદાનામક એકઃ શિષ્યઃ પ્રધાનયાજકાનામન્તિકં ગત્વા કથિતવાન્, ");
INSERT INTO sanguj_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","યદિ યુષ્માકં કરેષુ યીશું સમર્પયામિ, તર્હિ કિં દાસ્યથ? તદાનીં તે તસ્મૈ ત્રિંશન્મુદ્રા દાતું સ્થિરીકૃતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","સ તદારભ્ય તં પરકરેષુ સમર્પયિતું સુયોગં ચેષ્ટિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","અનન્તરં કિણ્વશૂન્યપૂપપર્વ્વણઃ પ્રથમેહ્નિ શિષ્યા યીશુમ્ ઉપગત્ય પપ્રચ્છુઃ ભવત્કૃતે કુત્ર વયં નિસ્તારમહભોજ્યમ્ આયોજયિષ્યામઃ? ભવતઃ કેચ્છા? ");
INSERT INTO sanguj_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","તદા સ ગદિતવાન્, મધ્યેનગરમમુકપુંસઃ સમીપં વ્રજિત્વા વદત, ગુરુ ર્ગદિતવાન્, મત્કાલઃ સવિધઃ, સહ શિષ્યૈસ્ત્વદાલયે નિસ્તારમહભોજ્યં ભોક્ષ્યે| ");
INSERT INTO sanguj_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","તદા શિષ્યા યીશોસ્તાદૃશનિદેશાનુરૂપકર્મ્મ વિધાય તત્ર નિસ્તારમહભોજ્યમાસાદયામાસુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","તતઃ સન્ધ્યાયાં સત્યાં દ્વાદશભિઃ શિષ્યૈઃ સાકં સ ન્યવિશત્| ");
INSERT INTO sanguj_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","અપરં ભુઞ્જાન ઉક્તવાન્ યુષ્માન્ તથ્યં વદામિ, યુષ્માકમેકો માં પરકરેષુ સમર્પયિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","તદા તેઽતીવ દુઃખિતા એકૈકશો વક્તુમારેભિરે, હે પ્રભો, સ કિમહં? ");
INSERT INTO sanguj_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","તતઃ સ જગાદ, મયા સાકં યો જનો ભોજનપાત્રે કરં સંક્ષિપતિ, સ એવ માં પરકરેષુ સમર્પયિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","મનુજસુતમધિ યાદૃશં લિખિતમાસ્તે, તદનુરૂપા તદ્ગતિ ર્ભવિષ્યતિ; કિન્તુ યેન પુંસા સ પરકરેષુ સમર્પયિષ્યતે, હા હા ચેત્ સ નાજનિષ્યત, તદા તસ્ય ક્ષેમમભવિષ્યત્| ");
INSERT INTO sanguj_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","તદા યિહૂદાનામા યો જનસ્તં પરકરેષુ સમર્પયિષ્યતિ, સ ઉક્તવાન્, હે ગુરો, સ કિમહં? તતઃ સ પ્રત્યુક્તવાન્, ત્વયા સત્યં ગદિતમ્| ");
INSERT INTO sanguj_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","અનન્તરં તેષામશનકાલે યીશુઃ પૂપમાદાયેશ્વરીયગુણાનનૂદ્ય ભંક્ત્વા શિષ્યેભ્યઃ પ્રદાય જગાદ, મદ્વપુઃસ્વરૂપમિમં ગૃહીત્વા ખાદત| ");
INSERT INTO sanguj_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","પશ્ચાત્ સ કંસં ગૃહ્લન્ ઈશ્વરીયગુણાનનૂદ્ય તેભ્યઃ પ્રદાય કથિતવાન્, સર્વ્વૈ ર્યુષ્માભિરનેન પાતવ્યં, ");
INSERT INTO sanguj_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","યસ્માદનેકેષાં પાપમર્ષણાય પાતિતં યન્મન્નૂત્નનિયમરૂપશોણિતં તદેતત્| ");
INSERT INTO sanguj_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","અપરમહં નૂત્નગોસ્તનીરસં ન પાસ્યામિ, તાવત્ ગોસ્તનીફલરસં પુનઃ કદાપિ ન પાસ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","પશ્ચાત્ તે ગીતમેકં સંગીય જૈતુનાખ્યગિરિં ગતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","તદાનીં યીશુસ્તાનવોચત્, અસ્યાં રજન્યામહં યુષ્માકં સર્વ્વેષાં વિઘ્નરૂપો ભવિષ્યામિ, યતો લિખિતમાસ્તે, \"મેષાણાં રક્ષકો યસ્તં પ્રહરિષ્યામ્યહં તતઃ| મેષાણાં નિવહો નૂનં પ્રવિકીર્ણો ભવિષ્યતિ\"|| ");
INSERT INTO sanguj_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","કિન્તુ શ્મશાનાત્ સમુત્થાય યુષ્માકમગ્રેઽહં ગાલીલં ગમિષ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","પિતરસ્તં પ્રોવાચ, ભવાંશ્ચેત્ સર્વ્વેષાં વિઘ્નરૂપો ભવતિ, તથાપિ મમ ન ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","તતો યીશુના સ ઉક્તઃ, તુભ્યમહં તથ્યં કથયામિ, યામિન્યામસ્યાં ચરણાયુધસ્ય રવાત્ પૂર્વ્વં ત્વં માં ત્રિ ર્નાઙ્ગીકરિષ્યસિ| ");
INSERT INTO sanguj_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","તતઃ પિતર ઉદિતવાન્, યદ્યપિ ત્વયા સમં મર્ત્તવ્યં, તથાપિ કદાપિ ત્વાં ન નાઙ્ગીકરિષ્યામિ; તથૈવ સર્વ્વે શિષ્યાશ્ચોચુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","અનન્તરં યીશુઃ શિષ્યૈઃ સાકં ગેત્શિમાનીનામકં સ્થાનં પ્રસ્થાય તેભ્યઃ કથિતવાન્, અદઃ સ્થાનં ગત્વા યાવદહં પ્રાર્થયિષ્યે તાવદ્ યૂયમત્રોપવિશત| ");
INSERT INTO sanguj_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","પશ્ચાત્ સ પિતરં સિવદિયસુતૌ ચ સઙ્ગિનઃ કૃત્વા ગતવાન્, શોકાકુલોઽતીવ વ્યથિતશ્ચ બભૂવ| ");
INSERT INTO sanguj_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","તાનવાદીચ્ચ મૃતિયાતનેવ મત્પ્રાણાનાં યાતના જાયતે, યૂયમત્ર મયા સાર્દ્ધં જાગૃત| ");
INSERT INTO sanguj_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","તતઃ સ કિઞ્ચિદ્દૂરં ગત્વાધોમુખઃ પતન્ પ્રાર્થયાઞ્ચક્રે, હે મત્પિતર્યદિ ભવિતું શક્નોતિ, તર્હિ કંસોઽયં મત્તો દૂરં યાતુ; કિન્તુ મદિચ્છાવત્ ન ભવતુ, ત્વદિચ્છાવદ્ ભવતુ| ");
INSERT INTO sanguj_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","તતઃ સ શિષ્યાનુપેત્ય તાન્ નિદ્રતો નિરીક્ષ્ય પિતરાય કથયામાસ, યૂયં મયા સાકં દણ્ડમેકમપિ જાગરિતું નાશન્કુત? ");
INSERT INTO sanguj_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","પરીક્ષાયાં ન પતિતું જાગૃત પ્રાર્થયધ્વઞ્ચ; આત્મા સમુદ્યતોસ્તિ, કિન્તુ વપુ ર્દુર્બ્બલં| ");
INSERT INTO sanguj_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","સ દ્વિતીયવારં પ્રાર્થયાઞ્ચક્રે, હે મત્તાત, ન પીતે યદિ કંસમિદં મત્તો દૂરં યાતું ન શક્નોતિ, તર્હિ ત્વદિચ્છાવદ્ ભવતુ| ");
INSERT INTO sanguj_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","સ પુનરેત્ય તાન્ નિદ્રતો દદર્શ, યતસ્તેષાં નેત્રાણિ નિદ્રયા પૂર્ણાન્યાસન્| ");
INSERT INTO sanguj_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","પશ્ચાત્ સ તાન્ વિહાય વ્રજિત્વા તૃતીયવારં પૂર્વ્વવત્ કથયન્ પ્રાર્થિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","તતઃ શિષ્યાનુપાગત્ય ગદિતવાન્, સામ્પ્રતં શયાનાઃ કિં વિશ્રામ્યથ? પશ્યત, સમય ઉપાસ્થાત્, મનુજસુતઃ પાપિનાં કરેષુ સમર્પ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ઉત્તિષ્ઠત, વયં યામઃ, યો માં પરકરેષુ મસર્પયિષ્યતિ, પશ્યત, સ સમીપમાયાતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","એતત્કથાકથનકાલે દ્વાદશશિષ્યાણામેકો યિહૂદાનામકો મુખ્યયાજકલોકપ્રાચીનૈઃ પ્રહિતાન્ અસિધારિયષ્ટિધારિણો મનુજાન્ ગૃહીત્વા તત્સમીપમુપતસ્થૌ| ");
INSERT INTO sanguj_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","અસૌ પરકરેષ્વર્પયિતા પૂર્વ્વં તાન્ ઇત્થં સઙ્કેતયામાસ, યમહં ચુમ્બિષ્યે, સોઽસૌ મનુજઃ,સએવ યુષ્માભિ ર્ધાર્ય્યતાં| ");
INSERT INTO sanguj_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","તદા સ સપદિ યીશુમુપાગત્ય હે ગુરો, પ્રણમામીત્યુક્ત્વા તં ચુચુમ્બે| ");
INSERT INTO sanguj_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","તદા યીશુસ્તમુવાચ, હે મિત્રં કિમર્થમાગતોસિ? તદા તૈરાગત્ય યીશુરાક્રમ્ય દઘ્રે| ");
INSERT INTO sanguj_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","તતો યીશોઃ સઙ્ગિનામેકઃ કરં પ્રસાર્ય્ય કોષાદસિં બહિષ્કૃત્ય મહાયાજકસ્ય દાસમેકમાહત્ય તસ્ય કર્ણં ચિચ્છેદ| ");
INSERT INTO sanguj_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","તતો યીશુસ્તં જગાદ, ખડ્ગં સ્વસ્થાનેे નિધેહિ યતો યે યે જના અસિં ધારયન્તિ, તએવાસિના વિનશ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","અપરં પિતા યથા મદન્તિકં સ્વર્ગીયદૂતાનાં દ્વાદશવાહિનીતોઽધિકં પ્રહિણુયાત્ મયા તમુદ્દિશ્યેદાનીમેવ તથા પ્રાર્થયિતું ન શક્યતે, ત્વયા કિમિત્થં જ્ઞાયતે? ");
INSERT INTO sanguj_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","તથા સતીત્થં ઘટિષ્યતે ધર્મ્મપુસ્તકસ્ય યદિદં વાક્યં તત્ કથં સિધ્યેત્? ");
INSERT INTO sanguj_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","તદાનીં યીશુ ર્જનનિવહં જગાદ, યૂયં ખડ્ગયષ્ટીન્ આદાય માં કિં ચૌરં ધર્ત્તુમાયાતાઃ? અહં પ્રત્યહં યુષ્માભિઃ સાકમુપવિશ્ય સમુપાદિશં, તદા માં નાધરત; ");
INSERT INTO sanguj_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","કિન્તુ ભવિષ્યદ્વાદિનાં વાક્યાનાં સંસિદ્ધયે સર્વ્વમેતદભૂત્| તદા સર્વ્વે શિષ્યાસ્તં વિહાય પલાયન્ત| ");
INSERT INTO sanguj_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","અનન્તરં તે મનુજા યીશું ધૃત્વા યત્રાધ્યાપકપ્રાઞ્ચઃ પરિષદં કુર્વ્વન્ત ઉપાવિશન્ તત્ર કિયફાનાाમકમહાયાજકસ્યાન્તિકં નિન્યુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","કિન્તુ શેષે કિં ભવિષ્યતીતિ વેત્તું પિતરો દૂરે તત્પશ્ચાદ્ વ્રજિત્વા મહાયાજકસ્યાટ્ટાલિકાં પ્રવિશ્ય દાસૈઃ સહિત ઉપાવિશત્| ");
INSERT INTO sanguj_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","તદાનીં પ્રધાનયાજકપ્રાચીનમન્ત્રિણઃ સર્વ્વે યીશું હન્તું મૃષાસાક્ષ્યમ્ અલિપ્સન્ત, ");
INSERT INTO sanguj_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","કિન્તુ ન લેભિરે| અનેકેષુ મૃષાસાક્ષિષ્વાગતેષ્વપિ તન્ન પ્રાપુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","શેષે દ્વૌ મૃષાસાક્ષિણાવાગત્ય જગદતુઃ, પુમાનયમકથયત્, અહમીશ્વરમન્દિરં ભંક્ત્વા દિનત્રયમધ્યે તન્નિર્મ્માતું શક્નોમિ| ");
INSERT INTO sanguj_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","તદા મહાયાજક ઉત્થાય યીશુમ્ અવાદીત્| ત્વં કિમપિ ન પ્રતિવદસિ? ત્વામધિ કિમેતે સાક્ષ્યં વદન્તિ? ");
INSERT INTO sanguj_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","કિન્તુ યીશુ ર્મૌનીભૂય તસ્યૌ| તતો મહાયાજક ઉક્તવાન્, ત્વામ્ અમરેશ્વરનામ્ના શપયામિ, ત્વમીશ્વરસ્ય પુત્રોઽભિષિક્તો ભવસિ નવેતિ વદ| ");
INSERT INTO sanguj_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","યીશુઃ પ્રત્યવદત્, ત્વં સત્યમુક્તવાન્; અહં યુષ્માન્ તથ્યં વદામિ, ઇતઃપરં મનુજસુતં સર્વ્વશક્તિમતો દક્ષિણપાર્શ્વે સ્થાતું ગગણસ્થં જલધરાનારુહ્યાયાન્તં વીક્ષધ્વે| ");
INSERT INTO sanguj_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","તદા મહાયાજકો નિજવસનં છિત્ત્વા જગાદ, એષ ઈશ્વરં નિન્દિતવાન્, અસ્માકમપરસાક્ષ્યેણ કિં પ્રયોજનં? પશ્યત, યૂયમેવાસ્યાસ્યાદ્ ઈશ્વરનિન્દાં શ્રુતવન્તઃ, ");
INSERT INTO sanguj_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","યુષ્માભિઃ કિં વિવિચ્યતે? તે પ્રત્યૂચુઃ, વધાર્હોઽયં| ");
INSERT INTO sanguj_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","તતો લોકૈસ્તદાસ્યે નિષ્ઠીવિતં કેચિત્ પ્રતલમાહત્ય કેચિચ્ચ ચપેટમાહત્ય બભાષિરે, ");
INSERT INTO sanguj_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","હે ખ્રીષ્ટ ત્વાં કશ્ચપેટમાહતવાન્? ઇતિ ગણયિત્વા વદાસ્માન્| ");
INSERT INTO sanguj_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","પિતરો બહિરઙ્ગન ઉપવિશતિ, તદાનીમેકા દાસી તમુપાગત્ય બભાષે, ત્વં ગાલીલીયયીશોઃ સહચરએકઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","કિન્તુ સ સર્વ્વેષાં સમક્ષમ્ અનઙ્ગીકૃત્યાવાદીત્, ત્વયા યદુચ્યતે, તદર્થમહં ન વેદ્મિ| ");
INSERT INTO sanguj_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","તદા તસ્મિન્ બહિર્દ્વારં ગતે ઽન્યા દાસી તં નિરીક્ષ્ય તત્રત્યજનાનવદત્, અયમપિ નાસરતીયયીશુના સાર્દ્ધમ્ આસીત્| ");
INSERT INTO sanguj_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","તતઃ સ શપથેન પુનરનઙ્ગીકૃત્ય કથિતવાન્, તં નરં ન પરિચિનોમિ| ");
INSERT INTO sanguj_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ક્ષણાત્ પરં તિષ્ઠન્તો જના એત્ય પિતરમ્ અવદન્, ત્વમવશ્યં તેષામેક ઇતિ ત્વદુચ્ચારણમેવ દ્યોતયતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","કિન્તુ સોઽભિશપ્ય કથિતવાન્, તં જનં નાહં પરિચિનોમિ, તદા સપદિ કુક્કુટો રુરાવ| ");
INSERT INTO sanguj_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","કુક્કુટરવાત્ પ્રાક્ ત્વં માં ત્રિરપાહ્નોષ્યસે, યૈષા વાગ્ યીશુનાવાદિ તાં પિતરઃ સંસ્મૃત્ય બહિરિત્વા ખેદાદ્ ભૃશં ચક્રન્દ| ");
INSERT INTO sanguj_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","પ્રભાતે જાતે પ્રધાનયાજકલોકપ્રાચીના યીશું હન્તું તત્પ્રતિકૂલં મન્ત્રયિત્વા ");
INSERT INTO sanguj_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","તં બદ્વ્વા નીત્વા પન્તીયપીલાતાખ્યાધિપે સમર્પયામાસુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","તતો યીશોઃ પરકરેવ્વર્પયિતા યિહૂદાસ્તત્પ્રાણાદણ્ડાજ્ઞાં વિદિત્વા સન્તપ્તમનાઃ પ્રધાનયાજકલોકપ્રાચીનાનાં સમક્ષં તાસ્ત્રીંશન્મુદ્રાઃ પ્રતિદાયાવાદીત્, ");
INSERT INTO sanguj_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","એતન્નિરાગોનરપ્રાણપરકરાર્પણાત્ કલુષં કૃતવાનહં| તદા ત ઉદિતવન્તઃ, તેનાસ્માકં કિં? ત્વયા તદ્ બુધ્યતામ્| ");
INSERT INTO sanguj_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","તતો યિહૂદા મન્દિરમધ્યે તા મુદ્રા નિક્ષિપ્ય પ્રસ્થિતવાન્ ઇત્વા ચ સ્વયમાત્માનમુદ્બબન્ધ| ");
INSERT INTO sanguj_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","પશ્ચાત્ પ્રધાનયાજકાસ્તા મુદ્રા આદાય કથિતવન્તઃ, એતા મુદ્રાઃ શોણિતમૂલ્યં તસ્માદ્ ભાણ્ડાગારે ન નિધાતવ્યાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","અનન્તરં તે મન્ત્રયિત્વા વિદેશિનાં શ્મશાનસ્થાનાય તાભિઃ કુલાલસ્ય ક્ષેત્રમક્રીણન્| ");
INSERT INTO sanguj_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","અતોઽદ્યાપિ તત્સ્થાનં રક્તક્ષેત્રં વદન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ઇત્થં સતિ ઇસ્રાયેલીયસન્તાનૈ ર્યસ્ય મૂલ્યં નિરુપિતં, તસ્ય ત્રિંશન્મુદ્રામાનં મૂલ્યં ");
INSERT INTO sanguj_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","માં પ્રતિ પરમેશ્વરસ્યાદેશાત્ તેભ્ય આદીયત, તેન ચ કુલાલસ્ય ક્ષેત્રં ક્રીતમિતિ યદ્વચનં યિરિમિયભવિષ્યદ્વાદિના પ્રોક્તં તત્ તદાસિધ્યત્| ");
INSERT INTO sanguj_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","અનન્તરં યીશૌ તદધિપતેઃ સમ્મુખ ઉપતિષ્ઠતિ સ તં પપ્રચ્છ, ત્વં કિં યિહૂદીયાનાં રાજા? તદા યીશુસ્તમવદત્, ત્વં સત્યમુક્તવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","કિન્તુ પ્રધાનયાજકપ્રાચીનૈરભિયુક્તેન તેન કિમપિ ન પ્રત્યવાદિ| ");
INSERT INTO sanguj_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","તતઃ પીલાતેન સ ઉદિતઃ, ઇમે ત્વત્પ્રતિકૂલતઃ કતિ કતિ સાક્ષ્યં દદતિ, તત્ ત્વં ન શૃણોષિ? ");
INSERT INTO sanguj_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","તથાપિ સ તેષામેકસ્યાપિ વચસ ઉત્તરં નોદિતવાન્; તેન સોઽધિપતિ ર્મહાચિત્રં વિદામાસ| ");
INSERT INTO sanguj_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","અન્યચ્ચ તન્મહકાલેઽધિપતેરેતાદૃશી રાતિરાસીત્, પ્રજા યં કઞ્ચન બન્ધિનં યાચન્તે, તમેવ સ મોચયતીતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","તદાનીં બરબ્બાનામા કશ્ચિત્ ખ્યાતબન્ધ્યાસીત્| ");
INSERT INTO sanguj_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","તતઃ પીલાતસ્તત્ર મિલિતાન્ લોકાન્ અપૃચ્છત્, એષ બરબ્બા બન્ધી ખ્રીષ્ટવિખ્યાતો યીશુશ્ચૈતયોઃ કં મોચયિષ્યામિ? યુષ્માકં કિમીપ્સિતં? ");
INSERT INTO sanguj_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","તૈરીર્ષ્યયા સ સમર્પિત ઇતિ સ જ્ઞાતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","અપરં વિચારાસનોપવેશનકાલે પીલાતસ્ય પત્ની ભૃત્યં પ્રહિત્ય તસ્મૈ કથયામાસ, તં ધાર્મ્મિકમનુજં પ્રતિ ત્વયા કિમપિ ન કર્ત્તવ્યં; યસ્માત્ તત્કૃતેઽદ્યાહં સ્વપ્ને પ્રભૂતકષ્ટમલભે| ");
INSERT INTO sanguj_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","અનન્તરં પ્રધાનયાજકપ્રાચીના બરબ્બાં યાચિત્વાદાતું યીશુઞ્ચ હન્તું સકલલોકાન્ પ્રાવર્ત્તયન્| ");
INSERT INTO sanguj_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","તતોઽધિપતિસ્તાન્ પૃષ્ટવાન્, એતયોઃ કમહં મોચયિષ્યામિ? યુષ્માકં કેચ્છા? તે પ્રોચુ ર્બરબ્બાં| ");
INSERT INTO sanguj_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","તદા પીલાતઃ પપ્રચ્છ, તર્હિ યં ખ્રીષ્ટં વદન્તિ, તં યીશું કિં કરિષ્યામિ? સર્વ્વે કથયામાસુઃ, સ ક્રુશેન વિધ્યતાં| ");
INSERT INTO sanguj_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","તતોઽધિપતિરવાદીત્, કુતઃ? કિં તેનાપરાદ્ધં? કિન્તુ તે પુનરુચૈ ર્જગદુઃ, સ ક્રુશેન વિધ્યતાં| ");
INSERT INTO sanguj_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","તદા નિજવાક્યમગ્રાહ્યમભૂત્, કલહશ્ચાપ્યભૂત્, પીલાત ઇતિ વિલોક્ય લોકાનાં સમક્ષં તોયમાદાય કરૌ પ્રક્ષાલ્યાવોચત્, એતસ્ય ધાર્મ્મિકમનુષ્યસ્ય શોણિતપાતે નિર્દોષોઽહં, યુષ્માભિરેવ તદ્ બુધ્યતાં| ");
INSERT INTO sanguj_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","તદા સર્વ્વાઃ પ્રજાઃ પ્રત્યવોચન્, તસ્ય શોણિતપાતાપરાધોઽસ્માકમ્ અસ્મત્સન્તાનાનાઞ્ચોપરિ ભવતુ| ");
INSERT INTO sanguj_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","તતઃ સ તેષાં સમીપે બરબ્બાં મોચયામાસ યીશુન્તુ કષાભિરાહત્ય ક્રુશેન વેધિતું સમર્પયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","અનન્તરમ્ અધિપતેઃ સેના અધિપતે ર્ગૃહં યીશુમાનીય તસ્ય સમીપે સેનાસમૂહં સંજગૃહુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","તતસ્તે તસ્ય વસનં મોચયિત્વા કૃષ્ણલોહિતવર્ણવસનં પરિધાપયામાસુઃ ");
INSERT INTO sanguj_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","કણ્ટકાનાં મુકુટં નિર્મ્માય તચ્છિરસિ દદુઃ, તસ્ય દક્ષિણકરે વેત્રમેકં દત્ત્વા તસ્ય સમ્મુખે જાનૂનિ પાતયિત્વા, હે યિહૂદીયાનાં રાજન્, તુભ્યં નમ ઇત્યુક્ત્વા તં તિરશ્ચક્રુઃ, ");
INSERT INTO sanguj_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","તતસ્તસ્ય ગાત્રે નિષ્ઠીવં દત્વા તેન વેત્રેણ શિર આજઘ્નુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ઇત્થં તં તિરસ્કૃત્ય તદ્ વસનં મોચયિત્વા પુનર્નિજવસનં પરિધાપયાઞ્ચક્રુઃ, તં ક્રુશેન વેધિતું નીતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","પશ્ચાત્તે બહિર્ભૂય કુરીણીયં શિમોન્નામકમેકં વિલોક્ય ક્રુશં વોઢું તમાદદિરે| ");
INSERT INTO sanguj_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","અનન્તરં ગુલ્ગલ્તામ્ અર્થાત્ શિરસ્કપાલનામકસ્થાનમુ પસ્થાય તે યીશવે પિત્તમિશ્રિતામ્લરસં પાતું દદુઃ, ");
INSERT INTO sanguj_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","કિન્તુ સ તમાસ્વાદ્ય ન પપૌ| ");
INSERT INTO sanguj_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","તદાનીં તે તં ક્રુશેન સંવિધ્ય તસ્ય વસનાનિ ગુટિકાપાતેન વિભજ્ય જગૃહુઃ, તસ્માત્, વિભજન્તેઽધરીયં મે તે મનુષ્યાઃ પરસ્પરં| મદુત્તરીયવસ્ત્રાર્થં ગુટિકાં પાતયન્તિ ચ|| યદેતદ્વચનં ભવિષ્યદ્વાદિભિરુક્તમાસીત્, તદા તદ્ અસિધ્યત્, ");
INSERT INTO sanguj_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","પશ્ચાત્ તે તત્રોપવિશ્ય તદ્રક્ષણકર્વ્વણિ નિયુક્તાસ્તસ્થુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","અપરમ્ એષ યિહૂદીયાનાં રાજા યીશુરિત્યપવાદલિપિપત્રં તચ્છિરસ ઊર્દ્વ્વે યોજયામાસુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","તતસ્તસ્ય વામે દક્ષિણે ચ દ્વૌ ચૈરૌ તેન સાકં ક્રુશેન વિવિધુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","તદા પાન્થા નિજશિરો લાડયિત્વા તં નિન્દન્તો જગદુઃ, ");
INSERT INTO sanguj_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","હે ઈશ્વરમન્દિરભઞ્જક દિનત્રયે તન્નિર્મ્માતઃ સ્વં રક્ષ, ચેત્ત્વમીશ્વરસુતસ્તર્હિ ક્રુશાદવરોહ| ");
INSERT INTO sanguj_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","પ્રધાનયાજકાધ્યાપકપ્રાચીનાશ્ચ તથા તિરસ્કૃત્ય જગદુઃ, ");
INSERT INTO sanguj_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","સોઽન્યજનાનાવત્, કિન્તુ સ્વમવિતું ન શક્નોતિ| યદીસ્રાયેલો રાજા ભવેત્, તર્હીદાનીમેવ ક્રુશાદવરોહતુ, તેન તં વયં પ્રત્યેષ્યામઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","સ ઈશ્વરે પ્રત્યાશામકરોત્, યદીશ્વરસ્તસ્મિન્ સન્તુષ્ટસ્તર્હીદાનીમેવ તમવેત્, યતઃ સ ઉક્તવાન્ અહમીશ્વરસુતઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","યૌ સ્તેનૌ સાકં તેન ક્રુશેન વિદ્ધૌ તૌ તદ્વદેવ તં નિનિન્દતુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","તદા દ્વિતીયયામાત્ તૃતીયયામં યાવત્ સર્વ્વદેશે તમિરં બભૂવ, ");
INSERT INTO sanguj_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","તૃતીયયામે \"એલી એલી લામા શિવક્તની\", અર્થાત્ મદીશ્વર મદીશ્વર કુતો મામત્યાક્ષીઃ? યીશુરુચ્ચૈરિતિ જગાદ| ");
INSERT INTO sanguj_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","તદા તત્ર સ્થિતાઃ કેચિત્ તત્ શ્રુત્વા બભાષિરે, અયમ્ એલિયમાહૂયતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","તેષાં મધ્યાદ્ એકઃ શીઘ્રં ગત્વા સ્પઞ્જં ગૃહીત્વા તત્રામ્લરસં દત્ત્વા નલેન પાતું તસ્મૈ દદૌ| ");
INSERT INTO sanguj_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ઇતરેઽકથયન્ તિષ્ઠત, તં રક્ષિતુમ્ એલિય આયાતિ નવેતિ પશ્યામઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","યીશુઃ પુનરુચૈરાહૂય પ્રાણાન્ જહૌ| ");
INSERT INTO sanguj_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","તતો મન્દિરસ્ય વિચ્છેદવસનમ્ ઊર્દ્વ્વાદધો યાવત્ છિદ્યમાનં દ્વિધાભવત્, ");
INSERT INTO sanguj_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ભૂમિશ્ચકમ્પે ભૂધરોવ્યદીર્ય્યત ચ| શ્મશાને મુક્તે ભૂરિપુણ્યવતાં સુપ્તદેહા ઉદતિષ્ઠન્, ");
INSERT INTO sanguj_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","શ્મશાનાદ્ વહિર્ભૂય તદુત્થાનાત્ પરં પુણ્યપુરં ગત્વા બહુજનાન્ દર્શયામાસુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","યીશુરક્ષણાય નિયુક્તઃ શતસેનાપતિસ્તત્સઙ્ગિનશ્ચ તાદૃશીં ભૂકમ્પાદિઘટનાં દૃષ્ટ્વા ભીતા અવદન્, એષ ઈશ્વરપુત્રો ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","યા બહુયોષિતો યીશું સેવમાના ગાલીલસ્તત્પશ્ચાદાગતાસ્તાસાં મધ્યે ");
INSERT INTO sanguj_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","મગ્દલીની મરિયમ્ યાકૂબ્યોશ્યો ર્માતા યા મરિયમ્ સિબદિયપુત્રયો ર્માતા ચ યોષિત એતા દૂરે તિષ્ઠન્ત્યો દદૃશુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","સન્ધ્યાયાં સત્યમ્ અરિમથિયાનગરસ્ય યૂષફ્નામા ધની મનુજો યીશોઃ શિષ્યત્વાત્ ");
INSERT INTO sanguj_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","પીલાતસ્ય સમીપં ગત્વા યીશોઃ કાયં યયાચે, તેન પીલાતઃ કાયં દાતુમ્ આદિદેશ| ");
INSERT INTO sanguj_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","યૂષફ્ તત્કાયં નીત્વા શુચિવસ્ત્રેણાચ્છાદ્ય ");
INSERT INTO sanguj_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","સ્વાર્થં શૈલે યત્ શ્મશાનં ચખાન, તન્મધ્યે તત્કાયં નિધાય તસ્ય દ્વારિ વૃહત્પાષાણં દદૌ| ");
INSERT INTO sanguj_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","કિન્તુ મગ્દલીની મરિયમ્ અન્યમરિયમ્ એતે સ્ત્રિયૌ તત્ર શ્મશાનસમ્મુખ ઉપવિવિશતુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","તદનન્તરં નિસ્તારોત્સવસ્યાયોજનદિનાત્ પરેઽહનિ પ્રધાનયાજકાઃ ફિરૂશિનશ્ચ મિલિત્વા પીલાતમુપાગત્યાકથયન્, ");
INSERT INTO sanguj_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","હે મહેચ્છ સ પ્રતારકો જીવન અકથયત્, દિનત્રયાત્ પરં શ્મશાનાદુત્થાસ્યામિ તદ્વાક્યં સ્મરામો વયં; ");
INSERT INTO sanguj_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","તસ્માત્ તૃતીયદિનં યાવત્ તત્ શ્મશાનં રક્ષિતુમાદિશતુ, નોચેત્ તચ્છિષ્યા યામિન્યામાગત્ય તં હૃત્વા લોકાન્ વદિષ્યન્તિ, સ શ્મશાનાદુદતિષ્ઠત્, તથા સતિ પ્રથમભ્રાન્તેઃ શેષીયભ્રાન્તિ ર્મહતી ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","તદા પીલાત અવાદીત્, યુષ્માકં સમીપે રક્ષિગણ આસ્તે, યૂયં ગત્વા યથા સાધ્યં રક્ષયત| ");
INSERT INTO sanguj_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","તતસ્તે ગત્વા તદ્દૂाરપાષાણં મુદ્રાઙ્કિતં કૃત્વા રક્ષિગણં નિયોજ્ય શ્મશાનં રક્ષયામાસુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","તતઃ પરં વિશ્રામવારસ્ય શેષે સપ્તાહપ્રથમદિનસ્ય પ્રભોતે જાતે મગ્દલીની મરિયમ્ અન્યમરિયમ્ ચ શ્મશાનં દ્રષ્ટુમાગતા| ");
INSERT INTO sanguj_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","તદા મહાન્ ભૂકમ્પોઽભવત્; પરમેશ્વરીયદૂતઃ સ્વર્ગાદવરુહ્ય શ્મશાનદ્વારાત્ પાષાણમપસાર્ય્ય તદુપર્ય્યુપવિવેશ| ");
INSERT INTO sanguj_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","તદ્વદનં વિદ્યુદ્વત્ તેજોમયં વસનં હિમશુભ્રઞ્ચ| ");
INSERT INTO sanguj_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","તદાનીં રક્ષિણસ્તદ્ભયાત્ કમ્પિતા મૃતવદ્ બભૂવઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","સ દૂતો યોષિતો જગાદ, યૂયં મા ભૈષ્ટ, ક્રુશહતયીશું મૃગયધ્વે તદહં વેદ્મિ| ");
INSERT INTO sanguj_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","સોઽત્ર નાસ્તિ, યથાવદત્ તથોત્થિતવાન્; એતત્ પ્રભોઃ શયનસ્થાનં પશ્યત| ");
INSERT INTO sanguj_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","તૂર્ણં ગત્વા તચ્છિષ્યાન્ ઇતિ વદત, સ શ્મશાનાદ્ ઉદતિષ્ઠત્, યુષ્માકમગ્રે ગાલીલં યાસ્યતિ યૂયં તત્ર તં વીક્ષિષ્યધ્વે, પશ્યતાહં વાર્ત્તામિમાં યુષ્માનવાદિષં| ");
INSERT INTO sanguj_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","તતસ્તા ભયાત્ મહાનન્દાઞ્ચ શ્મશાનાત્ તૂર્ણં બહિર્ભૂય તચ્છિષ્યાન્ વાર્ત્તાં વક્તું ધાવિતવત્યઃ| કિન્તુ શિષ્યાન્ વાર્ત્તાં વક્તું યાન્તિ, તદા યીશુ ર્દર્શનં દત્ત્વા તા જગાદ, ");
INSERT INTO sanguj_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","યુષ્માકં કલ્યાણં ભૂયાત્, તતસ્તા આગત્ય તત્પાદયોઃ પતિત્વા પ્રણેમુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","યીશુસ્તા અવાદીત્, મા બિભીત, યૂયં ગત્વા મમ ભ્રાતૃન્ ગાલીલં યાતું વદત, તત્ર તે માં દ્રક્ષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","સ્ત્રિયો ગચ્છન્તિ, તદા રક્ષિણાં કેચિત્ પુરં ગત્વા યદ્યદ્ ઘટિતં તત્સર્વ્વં પ્રધાનયાજકાન્ જ્ઞાપિતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","તે પ્રાચીનૈઃ સમં સંસદં કૃત્વા મન્ત્રયન્તો બહુમુદ્રાઃ સેનાભ્યો દત્ત્વાવદન્, ");
INSERT INTO sanguj_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","અસ્માસુ નિદ્રિતેષુ તચ્છિષ્યા યામિન્યામાગત્ય તં હૃત્વાનયન્, ઇતિ યૂયં પ્રચારયત| ");
INSERT INTO sanguj_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","યદ્યેતદધિપતેઃ શ્રોત્રગોચરીભવેત્, તર્હિ તં બોધયિત્વા યુષ્માનવિષ્યામઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","તતસ્તે મુદ્રા ગૃહીત્વા શિક્ષાનુરૂપં કર્મ્મ ચક્રુઃ, યિહૂદીયાનાં મધ્યે તસ્યાદ્યાપિ કિંવદન્તી વિદ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","એકાદશ શિષ્યા યીશુનિરૂપિતાગાલીલસ્યાદ્રિં ગત્વા ");
INSERT INTO sanguj_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","તત્ર તં સંવીક્ષ્ય પ્રણેમુઃ, કિન્તુ કેચિત્ સન્દિગ્ધવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","યીશુસ્તેષાં સમીપમાગત્ય વ્યાહૃતવાન્, સ્વર્ગમેદિન્યોઃ સર્વ્વાધિપતિત્વભારો મય્યર્પિત આસ્તે| ");
INSERT INTO sanguj_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","અતો યૂયં પ્રયાય સર્વ્વદેશીયાન્ શિષ્યાન્ કૃત્વા પિતુઃ પુત્રસ્ય પવિત્રસ્યાત્મનશ્ચ નામ્ના તાનવગાહયત; અહં યુષ્માન્ યદ્યદાદિશં તદપિ પાલયિતું તાનુપાદિશત| ");
INSERT INTO sanguj_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","પશ્યત, જગદન્તં યાવત્ સદાહં યુષ્માભિઃ સાકં તિષ્ઠામિ| ઇતિ|");
INSERT INTO sanguj_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ઈશ્વરપુત્રસ્ય યીશુખ્રીષ્ટસ્ય સુસંવાદારમ્ભઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ભવિષ્યદ્વાદિનાં ગ્રન્થેષુ લિપિરિત્થમાસ્તે, પશ્ય સ્વકીયદૂતન્તુ તવાગ્રે પ્રેષયામ્યહમ્| ગત્વા ત્વદીયપન્થાનં સ હિ પરિષ્કરિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","\"પરમેશસ્ય પન્થાનં પરિષ્કુરુત સર્વ્વતઃ| તસ્ય રાજપથઞ્ચૈવ સમાનં કુરુતાધુના| \" ઇત્યેતત્ પ્રાન્તરે વાક્યં વદતઃ કસ્યચિદ્રવઃ|| ");
INSERT INTO sanguj_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","સએવ યોહન્ પ્રાન્તરે મજ્જિતવાન્ તથા પાપમાર્જનનિમિત્તં મનોવ્યાવર્ત્તકમજ્જનસ્ય કથાઞ્ચ પ્રચારિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","તતો યિહૂદાદેશયિરૂશાલમ્નગરનિવાસિનઃ સર્વ્વે લોકા બહિ ર્ભૂત્વા તસ્ય સમીપમાગત્ય સ્વાનિ સ્વાનિ પાપાન્યઙ્ગીકૃત્ય યર્દ્દનનદ્યાં તેન મજ્જિતા બભૂવુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","અસ્ય યોહનઃ પરિધેયાનિ ક્રમેલકલોમજાનિ, તસ્ય કટિબન્ધનં ચર્મ્મજાતમ્, તસ્ય ભક્ષ્યાણિ ચ શૂકકીટા વન્યમધૂનિ ચાસન્| ");
INSERT INTO sanguj_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","સ પ્રચારયન્ કથયાઞ્ચક્રે, અહં નમ્રીભૂય યસ્ય પાદુકાબન્ધનં મોચયિતુમપિ ન યોગ્યોસ્મિ, તાદૃશો મત્તો ગુરુતર એકઃ પુરુષો મત્પશ્ચાદાગચ્છતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","અહં યુષ્માન્ જલે મજ્જિતવાન્ કિન્તુ સ પવિત્ર આત્માનિ સંમજ્જયિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","અપરઞ્ચ તસ્મિન્નેવ કાલે ગાલીલ્પ્રદેશસ્ય નાસરદ્ગ્રામાદ્ યીશુરાગત્ય યોહના યર્દ્દનનદ્યાં મજ્જિતોઽભૂત્| ");
INSERT INTO sanguj_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","સ જલાદુત્થિતમાત્રો મેઘદ્વારં મુક્તં કપોતવત્ સ્વસ્યોપરિ અવરોહન્તમાત્માનઞ્ચ દૃષ્ટવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ત્વં મમ પ્રિયઃ પુત્રસ્ત્વય્યેવ મમમહાસન્તોષ ઇયમાકાશીયા વાણી બભૂવ| ");
INSERT INTO sanguj_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","તસ્મિન્ કાલે આત્મા તં પ્રાન્તરમધ્યં નિનાય| ");
INSERT INTO sanguj_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","અથ સ ચત્વારિંશદ્દિનાનિ તસ્મિન્ સ્થાને વન્યપશુભિઃ સહ તિષ્ઠન્ શૈતાના પરીક્ષિતઃ; પશ્ચાત્ સ્વર્ગીયદૂતાસ્તં સિષેવિરે| ");
INSERT INTO sanguj_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","અનન્તરં યોહનિ બન્ધનાલયે બદ્ધે સતિ યીશુ ર્ગાલીલ્પ્રદેશમાગત્ય ઈશ્વરરાજ્યસ્ય સુસંવાદં પ્રચારયન્ કથયામાસ, ");
INSERT INTO sanguj_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","કાલઃ સમ્પૂર્ણ ઈશ્વરરાજ્યઞ્ચ સમીપમાગતં; અતોહેતો ર્યૂયં મનાંસિ વ્યાવર્ત્તયધ્વં સુસંવાદે ચ વિશ્વાસિત| ");
INSERT INTO sanguj_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","તદનન્તરં સ ગાલીલીયસમુદ્રસ્ય તીરે ગચ્છન્ શિમોન્ તસ્ય ભ્રાતા અન્દ્રિયનામા ચ ઇમૌ દ્વૌ જનૌ મત્સ્યધારિણૌ સાગરમધ્યે જાલં પ્રક્ષિપન્તૌ દૃષ્ટ્વા તાવવદત્, ");
INSERT INTO sanguj_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","યુવાં મમ પશ્ચાદાગચ્છતં, યુવામહં મનુષ્યધારિણૌ કરિષ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","તતસ્તૌ તત્ક્ષણમેવ જાલાનિ પરિત્યજ્ય તસ્ય પશ્ચાત્ જગ્મતુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","તતઃ પરં તત્સ્થાનાત્ કિઞ્ચિદ્ દૂરં ગત્વા સ સિવદીપુત્રયાકૂબ્ તદ્ભ્રાતૃયોહન્ ચ ઇમૌ નૌકાયાં જાલાનાં જીર્ણમુદ્ધારયન્તૌ દૃષ્ટ્વા તાવાહૂયત્| ");
INSERT INTO sanguj_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","તતસ્તૌ નૌકાયાં વેતનભુગ્ભિઃ સહિતં સ્વપિતરં વિહાય તત્પશ્ચાદીયતુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","તતઃ પરં કફર્નાહૂમ્નામકં નગરમુપસ્થાય સ વિશ્રામદિવસે ભજનગ્રહં પ્રવિશ્ય સમુપદિદેશ| ");
INSERT INTO sanguj_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","તસ્યોપદેશાલ્લોકા આશ્ચર્ય્યં મેનિરે યતઃ સોધ્યાપકાઇવ નોપદિશન્ પ્રભાવવાનિવ પ્રોપદિદેશ| ");
INSERT INTO sanguj_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","અપરઞ્ચ તસ્મિન્ ભજનગૃહે અપવિત્રભૂતેન ગ્રસ્ત એકો માનુષ આસીત્| સ ચીત્શબ્દં કૃત્વા કથયાઞ્ચકે ");
INSERT INTO sanguj_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ભો નાસરતીય યીશો ત્વમસ્માન્ ત્યજ, ત્વયા સહાસ્માકં કઃ સમ્બન્ધઃ? ત્વં કિમસ્માન્ નાશયિતું સમાગતઃ? ત્વમીશ્વરસ્ય પવિત્રલોક ઇત્યહં જાનામિ| ");
INSERT INTO sanguj_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","તદા યીશુસ્તં તર્જયિત્વા જગાદ તૂષ્ણીં ભવ ઇતો બહિર્ભવ ચ| ");
INSERT INTO sanguj_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","તતઃ સોઽપવિત્રભૂતસ્તં સમ્પીડ્ય અત્યુચૈશ્ચીત્કૃત્ય નિર્જગામ| ");
INSERT INTO sanguj_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","તેનૈવ સર્વ્વે ચમત્કૃત્ય પરસ્પરં કથયાઞ્ચક્રિરે, અહો કિમિદં? કીદૃશોઽયં નવ્ય ઉપદેશઃ? અનેન પ્રભાવેનાપવિત્રભૂતેષ્વાજ્ઞાપિતેષુ તે તદાજ્ઞાનુવર્ત્તિનો ભવન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","તદા તસ્ય યશો ગાલીલશ્ચતુર્દિક્સ્થસર્વ્વદેશાન્ વ્યાપ્નોત્| ");
INSERT INTO sanguj_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","અપરઞ્ચ તે ભજનગૃહાદ્ બહિ ર્ભૂત્વા યાકૂબ્યોહન્ભ્યાં સહ શિમોન આન્દ્રિયસ્ય ચ નિવેશનં પ્રવિવિશુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","તદા પિતરસ્ય શ્વશ્રૂર્જ્વરપીડિતા શય્યાયામાસ્ત ઇતિ તે તં ઝટિતિ વિજ્ઞાપયાઞ્ચક્રુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","તતઃ સ આગત્ય તસ્યા હસ્તં ધૃત્વા તામુદસ્થાપયત્; તદૈવ તાં જ્વરોઽત્યાક્ષીત્ તતઃ પરં સા તાન્ સિષેવે| ");
INSERT INTO sanguj_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","અથાસ્તં ગતે રવૌ સન્ધ્યાકાલે સતિ લોકાસ્તત્સમીપં સર્વ્વાન્ રોગિણો ભૂતધૃતાંશ્ચ સમાનિન્યુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","સર્વ્વે નાગરિકા લોકા દ્વારિ સંમિલિતાશ્ચ| ");
INSERT INTO sanguj_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","તતઃ સ નાનાવિધરોગિણો બહૂન્ મનુજાનરોગિણશ્ચકાર તથા બહૂન્ ભૂતાન્ ત્યાજયાઞ્ચકાર તાન્ ભૂતાન્ કિમપિ વાક્યં વક્તું નિષિષેધ ચ યતોહેતોસ્તે તમજાનન્| ");
INSERT INTO sanguj_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","અપરઞ્ચ સોઽતિપ્રત્યૂષે વસ્તુતસ્તુ રાત્રિશેષે સમુત્થાય બહિર્ભૂય નિર્જનં સ્થાનં ગત્વા તત્ર પ્રાર્થયાઞ્ચક્રે| ");
INSERT INTO sanguj_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","અનન્તરં શિમોન્ તત્સઙ્ગિનશ્ચ તસ્ય પશ્ચાદ્ ગતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","તદુદ્દેશં પ્રાપ્ય તમવદન્ સર્વ્વે લોકાસ્ત્વાં મૃગયન્તે| ");
INSERT INTO sanguj_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","તદા સોઽકથયત્ આગચ્છત વયં સમીપસ્થાનિ નગરાણિ યામઃ, યતોઽહં તત્ર કથાં પ્રચારયિતું બહિરાગમમ્| ");
INSERT INTO sanguj_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","અથ સ તેષાં ગાલીલ્પ્રદેશસ્ય સર્વ્વેષુ ભજનગૃહેષુ કથાઃ પ્રચારયાઞ્ચક્રે ભૂતાનત્યાજયઞ્ચ| ");
INSERT INTO sanguj_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","અનન્તરમેકઃ કુષ્ઠી સમાગત્ય તત્સમ્મુખે જાનુપાતં વિનયઞ્ચ કૃત્વા કથિતવાન્ યદિ ભવાન્ ઇચ્છતિ તર્હિ માં પરિષ્કર્ત્તું શક્નોતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","તતઃ કૃપાલુ ર્યીશુઃ કરૌ પ્રસાર્ય્ય તં સ્પષ્ટ્વા કથયામાસ ");
INSERT INTO sanguj_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","મમેચ્છા વિદ્યતે ત્વં પરિષ્કૃતો ભવ| એતત્કથાયાઃ કથનમાત્રાત્ સ કુષ્ઠી રોગાન્મુક્તઃ પરિષ્કૃતોઽભવત્| ");
INSERT INTO sanguj_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","તદા સ તં વિસૃજન્ ગાઢમાદિશ્ય જગાદ ");
INSERT INTO sanguj_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","સાવધાનો ભવ કથામિમાં કમપિ મા વદ; સ્વાત્માનં યાજકં દર્શય, લોકેભ્યઃ સ્વપરિષ્કૃતેઃ પ્રમાણદાનાય મૂસાનિર્ણીતં યદ્દાનં તદુત્સૃજસ્વ ચ| ");
INSERT INTO sanguj_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","કિન્તુ સ ગત્વા તત્ કર્મ્મ ઇત્થં વિસ્તાર્ય્ય પ્રચારયિતું પ્રારેભે તેનૈવ યીશુઃ પુનઃ સપ્રકાશં નગરં પ્રવેષ્ટું નાશક્નોત્ તતોહેતોર્બહિઃ કાનનસ્થાને તસ્યૌ; તથાપિ ચતુર્દ્દિગ્ભ્યો લોકાસ્તસ્ય સમીપમાયયુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","તદનન્તરં યીશૈ કતિપયદિનાનિ વિલમ્બ્ય પુનઃ કફર્નાહૂમ્નગરં પ્રવિષ્ટે સ ગૃહ આસ્ત ઇતિ કિંવદન્ત્યા તત્ક્ષણં તત્સમીપં બહવો લોકા આગત્ય સમુપતસ્થુઃ, ");
INSERT INTO sanguj_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","તસ્માદ્ ગૃહમધ્યે સર્વ્વેષાં કૃતે સ્થાનં નાભવદ્ દ્વારસ્ય ચતુર્દિક્ષ્વપિ નાભવત્, તત્કાલે સ તાન્ પ્રતિ કથાં પ્રચારયાઞ્ચક્રે| ");
INSERT INTO sanguj_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","તતઃ પરં લોકાશ્ચતુર્ભિ ર્માનવૈરેકં પક્ષાઘાતિનં વાહયિત્વા તત્સમીપમ્ આનિન્યુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","કિન્તુ જનાનાં બહુત્વાત્ તં યીશોઃ સમ્મુખમાનેતું ન શક્નુવન્તો યસ્મિન્ સ્થાને સ આસ્તે તદુપરિગૃહપૃષ્ઠં ખનિત્વા છિદ્રં કૃત્વા તેન માર્ગેણ સશય્યં પક્ષાઘાતિનમ્ અવરોહયામાસુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","તતો યીશુસ્તેષાં વિશ્વાસં દૃષ્ટ્વા તં પક્ષાઘાતિનં બભાષે હે વત્સ તવ પાપાનાં માર્જનં ભવતુ| ");
INSERT INTO sanguj_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","તદા કિયન્તોઽધ્યાપકાસ્તત્રોપવિશન્તો મનોભિ ર્વિતર્કયાઞ્ચક્રુઃ, એષ મનુષ્ય એતાદૃશીમીશ્વરનિન્દાં કથાં કુતઃ કથયતિ? ");
INSERT INTO sanguj_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","ઈશ્વરં વિના પાપાનિ માર્ષ્ટું કસ્ય સામર્થ્યમ્ આસ્તે? ");
INSERT INTO sanguj_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ઇત્થં તે વિતર્કયન્તિ યીશુસ્તત્ક્ષણં મનસા તદ્ બુદ્વ્વા તાનવદદ્ યૂયમન્તઃકરણૈઃ કુત એતાનિ વિતર્કયથ? ");
INSERT INTO sanguj_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","તદનન્તરં યીશુસ્તત્સ્થાનાત્ પુનઃ સમુદ્રતટં યયૌ; લોકનિવહે તત્સમીપમાગતે સ તાન્ સમુપદિદેશ| ");
INSERT INTO sanguj_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","કિન્તુ પૃથિવ્યાં પાપાનિ માર્ષ્ટું મનુષ્યપુત્રસ્ય સામર્થ્યમસ્તિ, એતદ્ યુષ્માન્ જ્ઞાપયિતું (સ તસ્મૈ પક્ષાઘાતિને કથયામાસ) ");
INSERT INTO sanguj_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","ઉત્તિષ્ઠ તવ શય્યાં ગૃહીત્વા સ્વગૃહં યાહિ, અહં ત્વામિદમ્ આજ્ઞાપયામિ| ");
INSERT INTO sanguj_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","તતઃ સ તત્ક્ષણમ્ ઉત્થાય શય્યાં ગૃહીત્વા સર્વ્વેષાં સાક્ષાત્ જગામ; સર્વ્વે વિસ્મિતા એતાદૃશં કર્મ્મ વયમ્ કદાપિ નાપશ્યામ, ઇમાં કથાં કથયિત્વેશ્વરં ધન્યમબ્રુવન્| ");
INSERT INTO sanguj_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","તદનન્તરં યીશુસ્તત્સ્થાનાત્ પુનઃ સમુદ્રતટં યયૌ; લોકનિવહે તત્સમીપમાગતે સ તાન્ સમુપદિદેશ| ");
INSERT INTO sanguj_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","અથ ગચ્છન્ કરસઞ્ચયગૃહ ઉપવિષ્ટમ્ આલ્ફીયપુત્રં લેવિં દૃષ્ટ્વા તમાહૂય કથિતવાન્ મત્પશ્ચાત્ ત્વામામચ્છ તતઃ સ ઉત્થાય તત્પશ્ચાદ્ યયૌ| ");
INSERT INTO sanguj_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","અનન્તરં યીશૌ તસ્ય ગૃહે ભોક્તુમ્ ઉપવિષ્ટે બહવઃ કરમઞ્ચાયિનઃ પાપિનશ્ચ તેન તચ્છિષ્યૈશ્ચ સહોપવિવિશુઃ, યતો બહવસ્તત્પશ્ચાદાજગ્મુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","તદા સ કરમઞ્ચાયિભિઃ પાપિભિશ્ચ સહ ખાદતિ, તદ્ દૃષ્ટ્વાધ્યાપકાઃ ફિરૂશિનશ્ચ તસ્ય શિષ્યાનૂચુઃ કરમઞ્ચાયિભિઃ પાપિભિશ્ચ સહાયં કુતો ભુંક્તે પિવતિ ચ? ");
INSERT INTO sanguj_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","તદ્વાક્યં શ્રુત્વા યીશુઃ પ્રત્યુવાચ,અરોગિલોકાનાં ચિકિત્સકેન પ્રયોજનં નાસ્તિ, કિન્તુ રોગિણામેવ; અહં ધાર્મ્મિકાનાહ્વાતું નાગતઃ કિન્તુ મનો વ્યાવર્ત્તયિતું પાપિન એવ| ");
INSERT INTO sanguj_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","તતઃ પરં યોહનઃ ફિરૂશિનાઞ્ચોપવાસાચારિશિષ્યા યીશોઃ સમીપમ્ આગત્ય કથયામાસુઃ, યોહનઃ ફિરૂશિનાઞ્ચ શિષ્યા ઉપવસન્તિ કિન્તુ ભવતઃ શિષ્યા નોપવસન્તિ કિં કારણમસ્ય? ");
INSERT INTO sanguj_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","તદા યીશુસ્તાન્ બભાષે યાવત્ કાલં સખિભિઃ સહ કન્યાયા વરસ્તિષ્ઠતિ તાવત્કાલં તે કિમુપવસ્તું શક્નુવન્તિ? યાવત્કાલં વરસ્તૈઃ સહ તિષ્ઠતિ તાવત્કાલં ત ઉપવસ્તું ન શક્નુવન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","યસ્મિન્ કાલે તેભ્યઃ સકાશાદ્ વરો નેષ્યતે સ કાલ આગચ્છતિ, તસ્મિન્ કાલે તે જના ઉપવત્સ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","કોપિ જનઃ પુરાતનવસ્ત્રે નૂતનવસ્ત્રં ન સીવ્યતિ, યતો નૂતનવસ્ત્રેણ સહ સેવને કૃતે જીર્ણં વસ્ત્રં છિદ્યતે તસ્માત્ પુન ર્મહત્ છિદ્રં જાયતે| ");
INSERT INTO sanguj_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","કોપિ જનઃ પુરાતનકુતૂષુ નૂતનં દ્રાક્ષારસં ન સ્થાપયતિ, યતો નૂતનદ્રાક્ષારસસ્ય તેજસા તાઃ કુત્વો વિદીર્ય્યન્તે તતો દ્રાક્ષારસશ્ચ પતતિ કુત્વશ્ચ નશ્યન્તિ, અતએવ નૂતનદ્રાક્ષારસો નૂતનકુતૂષુ સ્થાપનીયઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","તદનન્તરં યીશુ ર્યદા વિશ્રામવારે શસ્યક્ષેત્રેણ ગચ્છતિ તદા તસ્ય શિષ્યા ગચ્છન્તઃ શસ્યમઞ્જરીશ્છેત્તું પ્રવૃત્તાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","અતઃ ફિરૂશિનો યીશવે કથયામાસુઃ પશ્યતુ વિશ્રામવાસરે યત્ કર્મ્મ ન કર્ત્તવ્યં તદ્ ઇમે કુતઃ કુર્વ્વન્તિ? ");
INSERT INTO sanguj_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","તદા સ તેભ્યોઽકથયત્ દાયૂદ્ તત્સંઙ્ગિનશ્ચ ભક્ષ્યાભાવાત્ ક્ષુધિતાઃ સન્તો યત્ કર્મ્મ કૃતવન્તસ્તત્ કિં યુષ્માભિ ર્ન પઠિતમ્? ");
INSERT INTO sanguj_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","અબિયાથર્નામકે મહાયાજકતાં કુર્વ્વતિ સ કથમીશ્વરસ્યાવાસં પ્રવિશ્ય યે દર્શનીયપૂપા યાજકાન્ વિનાન્યસ્ય કસ્યાપિ ન ભક્ષ્યાસ્તાનેવ બુભુજે સઙ્ગિલોકેભ્યોઽપિ દદૌ| ");
INSERT INTO sanguj_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","સોઽપરમપિ જગાદ, વિશ્રામવારો મનુષ્યાર્થમેવ નિરૂપિતોઽસ્તિ કિન્તુ મનુષ્યો વિશ્રામવારાર્થં નૈવ| ");
INSERT INTO sanguj_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","મનુષ્યપુત્રો વિશ્રામવારસ્યાપિ પ્રભુરાસ્તે| ");
INSERT INTO sanguj_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","અનન્તરં યીશુઃ પુન ર્ભજનગૃહં પ્રવિષ્ટસ્તસ્મિન્ સ્થાને શુષ્કહસ્ત એકો માનવ આસીત્| ");
INSERT INTO sanguj_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","સ વિશ્રામવારે તમરોગિણં કરિષ્યતિ નવેત્યત્ર બહવસ્તમ્ અપવદિતું છિદ્રમપેક્ષિતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","તદા સ તં શુષ્કહસ્તં મનુષ્યં જગાદ મધ્યસ્થાને ત્વમુત્તિષ્ઠ| ");
INSERT INTO sanguj_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","તતઃ પરં સ તાન્ પપ્રચ્છ વિશ્રામવારે હિતમહિતં તથા હિ પ્રાણરક્ષા વા પ્રાણનાશ એષાં મધ્યે કિં કરણીયં ? કિન્તુ તે નિઃશબ્દાસ્તસ્થુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","તદા સ તેષામન્તઃકરણાનાં કાઠિન્યાદ્ધેતો ર્દુઃખિતઃ ક્રોધાત્ ચર્તુिદશો દૃષ્ટવાન્ તં માનુષં ગદિતવાન્ તં હસ્તં વિસ્તારય, તતસ્તેન હસ્તે વિસ્તૃતે તદ્ધસ્તોઽન્યહસ્તવદ્ અરોગો જાતઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","અથ ફિરૂશિનઃ પ્રસ્થાય તં નાશયિતું હેરોદીયૈઃ સહ મન્ત્રયિતુમારેભિરે| ");
INSERT INTO sanguj_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","અતએવ યીશુસ્તત્સ્થાનં પરિત્યજ્ય શિષ્યૈઃ સહ પુનઃ સાગરસમીપં ગતઃ; ");
INSERT INTO sanguj_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","તતો ગાલીલ્યિહૂદા-યિરૂશાલમ્-ઇદોમ્-યર્દન્નદીપારસ્થાનેભ્યો લોકસમૂહસ્તસ્ય પશ્ચાદ્ ગતઃ; તદન્યઃ સોરસીદનોઃ સમીપવાસિલોકસમૂહશ્ચ તસ્ય મહાકર્મ્મણાં વાર્ત્તં શ્રુત્વા તસ્ય સન્નિધિમાગતઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","તદા લોકસમૂહશ્ચેત્ તસ્યોપરિ પતતિ ઇત્યાશઙ્ક્ય સ નાવમેકાં નિકટે સ્થાપયિતું શિષ્યાનાદિષ્ટવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","યતોઽનેકમનુષ્યાણામારોગ્યકરણાદ્ વ્યાધિગ્રસ્તાઃ સર્વ્વે તં સ્પ્રષ્ટું પરસ્પરં બલેન યત્નવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","અપરઞ્ચ અપવિત્રભૂતાસ્તં દૃષ્ટ્વા તચ્ચરણયોઃ પતિત્વા પ્રોચૈઃ પ્રોચુઃ, ત્વમીશ્વરસ્ય પુત્રઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","કિન્તુ સ તાન્ દૃઢમ્ આજ્ઞાપ્ય સ્વં પરિચાયિતું નિષિદ્ધવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","અનન્તરં સ પર્વ્વતમારુહ્ય યં યં પ્રતિચ્છા તં તમાહૂતવાન્ તતસ્તે તત્સમીપમાગતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","તદા સ દ્વાદશજનાન્ સ્વેન સહ સ્થાતું સુસંવાદપ્રચારાય પ્રેરિતા ભવિતું ");
INSERT INTO sanguj_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","સર્વ્વપ્રકારવ્યાધીનાં શમનકરણાય પ્રભાવં પ્રાપ્તું ભૂતાન્ ત્યાજયિતુઞ્ચ નિયુક્તવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","તેષાં નામાનીમાનિ, શિમોન્ સિવદિપુત્રો ");
INSERT INTO sanguj_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","યાકૂબ્ તસ્ય ભ્રાતા યોહન્ ચ આન્દ્રિયઃ ફિલિપો બર્થલમયઃ, ");
INSERT INTO sanguj_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","મથી થોમા ચ આલ્ફીયપુત્રો યાકૂબ્ થદ્દીયઃ કિનાનીયઃ શિમોન્ યસ્તં પરહસ્તેષ્વર્પયિષ્યતિ સ ઈષ્કરિયોતીયયિહૂદાશ્ચ| ");
INSERT INTO sanguj_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","સ શિમોને પિતર ઇત્યુપનામ દદૌ યાકૂબ્યોહન્ભ્યાં ચ બિનેરિગિશ્ અર્થતો મેઘનાદપુત્રાવિત્યુપનામ દદૌ| ");
INSERT INTO sanguj_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","અનન્તરં તે નિવેશનં ગતાઃ, કિન્તુ તત્રાપિ પુનર્મહાન્ જનસમાગમો ઽભવત્ તસ્માત્તે ભોક્તુમપ્યવકાશં ન પ્રાપ્તાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","તતસ્તસ્ય સુહૃલ્લોકા ઇમાં વાર્ત્તાં પ્રાપ્ય સ હતજ્ઞાનોભૂદ્ ઇતિ કથાં કથયિત્વા તં ધૃત્વાનેતું ગતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","અપરઞ્ચ યિરૂશાલમ આગતા યે યેઽધ્યાપકાસ્તે જગદુરયં પુરુષો ભૂતપત્યાબિષ્ટસ્તેન ભૂતપતિના ભૂતાન્ ત્યાજયતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","તતસ્તાનાહૂય યીશુ ર્દૃષ્ટાન્તૈઃ કથાં કથિતવાન્ શૈતાન્ કથં શૈતાનં ત્યાજયિતું શક્નોતિ? ");
INSERT INTO sanguj_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","કિઞ્ચન રાજ્યં યદિ સ્વવિરોધેન પૃથગ્ ભવતિ તર્હિ તદ્ રાજ્યં સ્થિરં સ્થાતું ન શક્નોતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","તથા કસ્યાપિ પરિવારો યદિ પરસ્પરં વિરોધી ભવતિ તર્હિ સોપિ પરિવારઃ સ્થિરં સ્થાતું ન શક્નોતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","તદ્વત્ શૈતાન્ યદિ સ્વવિપક્ષતયા ઉત્તિષ્ઠન્ ભિન્નો ભવતિ તર્હિ સોપિ સ્થિરં સ્થાતું ન શક્નોતિ કિન્તૂચ્છિન્નો ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","અપરઞ્ચ પ્રબલં જનં પ્રથમં ન બદ્ધા કોપિ તસ્ય ગૃહં પ્રવિશ્ય દ્રવ્યાણિ લુણ્ઠયિતું ન શક્નોતિ, તં બદ્વ્વૈવ તસ્ય ગૃહસ્ય દ્રવ્યાણિ લુણ્ઠયિતું શક્નોતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","અતોહેતો ર્યુષ્મભ્યમહં સત્યં કથયામિ મનુષ્યાણાં સન્તાના યાનિ યાનિ પાપાનીશ્વરનિન્દાઞ્ચ કુર્વ્વન્તિ તેષાં તત્સર્વ્વેષામપરાધાનાં ક્ષમા ભવિતું શક્નોતિ, ");
INSERT INTO sanguj_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","કિન્તુ યઃ કશ્ચિત્ પવિત્રમાત્માનં નિન્દતિ તસ્યાપરાધસ્ય ક્ષમા કદાપિ ન ભવિષ્યતિ સોનન્તદણ્ડસ્યાર્હો ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","તસ્યાપવિત્રભૂતોઽસ્તિ તેષામેતત્કથાહેતોઃ સ ઇત્થં કથિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","અથ તસ્ય માતા ભ્રાતૃગણશ્ચાગત્ય બહિસ્તિષ્ઠનતો લોકાન્ પ્રેષ્ય તમાહૂતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","તતસ્તત્સન્નિધૌ સમુપવિષ્ટા લોકાસ્તં બભાષિરે પશ્ય બહિસ્તવ માતા ભ્રાતરશ્ચ ત્વામ્ અન્વિચ્છન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","તદા સ તાન્ પ્રત્યુવાચ મમ માતા કા ભ્રાતરો વા કે? તતઃ પરં સ સ્વમીપોપવિષ્ટાન્ શિષ્યાન્ પ્રતિ અવલોકનં કૃત્વા કથયામાસ ");
INSERT INTO sanguj_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","પશ્યતૈતે મમ માતા ભ્રાતરશ્ચ| ");
INSERT INTO sanguj_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","યઃ કશ્ચિદ્ ઈશ્વરસ્યેષ્ટાં ક્રિયાં કરોતિ સ એવ મમ ભ્રાતા ભગિની માતા ચ| ");
INSERT INTO sanguj_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","અનન્તરં સ સમુદ્રતટે પુનરુપદેષ્ટું પ્રારેભે, તતસ્તત્ર બહુજનાનાં સમાગમાત્ સ સાગરોપરિ નૌકામારુહ્ય સમુપવિષ્ટઃ; સર્વ્વે લોકાઃ સમુદ્રકૂલે તસ્થુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","તદા સ દૃષ્ટાન્તકથાભિ ર્બહૂપદિષ્ટવાન્ ઉપદિશંશ્ચ કથિતવાન્, ");
INSERT INTO sanguj_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","અવધાનં કુરુત, એકો બીજવપ્તા બીજાનિ વપ્તું ગતઃ; ");
INSERT INTO sanguj_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","વપનકાલે કિયન્તિ બીજાનિ માર્ગપાશ્વે પતિતાનિ, તત આકાશીયપક્ષિણ એત્ય તાનિ ચખાદુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","કિયન્તિ બીજાનિ સ્વલ્પમૃત્તિકાવત્પાષાણભૂમૌ પતિતાનિ તાનિ મૃદોલ્પત્વાત્ શીઘ્રમઙ્કુરિતાનિ; ");
INSERT INTO sanguj_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","કિન્તૂદિતે સૂર્ય્યે દગ્ધાનિ તથા મૂલાનો નાધોગતત્વાત્ શુષ્કાણિ ચ| ");
INSERT INTO sanguj_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","કિયન્તિ બીજાનિ કણ્ટકિવનમધ્યે પતિતાનિ તતઃ કણ્ટકાનિ સંવૃદ્વ્ય તાનિ જગ્રસુસ્તાનિ ન ચ ફલિતાનિ| ");
INSERT INTO sanguj_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","તથા કિયન્તિ બીજાન્યુત્તમભૂમૌ પતિતાનિ તાનિ સંવૃદ્વ્ય ફલાન્યુત્પાદિતાનિ કિયન્તિ બીજાનિ ત્રિંશદ્ગુણાનિ કિયન્તિ ષષ્ટિગુણાનિ કિયન્તિ શતગુણાનિ ફલાનિ ફલિતવન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","અથ સ તાનવદત્ યસ્ય શ્રોતું કર્ણૌ સ્તઃ સ શૃણોતુ| ");
INSERT INTO sanguj_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","તદનન્તરં નિર્જનસમયે તત્સઙ્ગિનો દ્વાદશશિષ્યાશ્ચ તં તદ્દૃષ્ટાન્તવાક્યસ્યાર્થં પપ્રચ્છુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","તદા સ તાનુદિતવાન્ ઈશ્વરરાજ્યસ્ય નિગૂઢવાક્યં બોદ્ધું યુષ્માકમધિકારોઽસ્તિ; ");
INSERT INTO sanguj_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","કિન્તુ યે વહિર્ભૂતાઃ \"તે પશ્યન્તઃ પશ્યન્તિ કિન્તુ ન જાનન્તિ, શૃણ્વન્તઃ શૃણ્વન્તિ કિન્તુ ન બુધ્યન્તે, ચેત્તૈ ર્મનઃસુ કદાપિ પરિવર્ત્તિતેષુ તેષાં પાપાન્યમોચયિષ્યન્ત,\" અતોહેતોસ્તાન્ પ્રતિ દૃષ્ટાન્તૈરેવ તાનિ મયા કથિતાનિ| ");
INSERT INTO sanguj_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","અથ સ કથિતવાન્ યૂયં કિમેતદ્ દૃષ્ટાન્તવાક્યં ન બુધ્યધ્વે? તર્હિ કથં સર્વ્વાન્ દૃષ્ટાન્તાન ભોત્સ્યધ્વે? ");
INSERT INTO sanguj_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","બીજવપ્તા વાક્યરૂપાણિ બીજાનિ વપતિ; ");
INSERT INTO sanguj_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","તત્ર યે યે લોકા વાક્યં શૃણ્વન્તિ, કિન્તુ શ્રુતમાત્રાત્ શૈતાન્ શીઘ્રમાગત્ય તેષાં મનઃસૂપ્તાનિ તાનિ વાક્યરૂપાણિ બીજાન્યપનયતિ તએવ ઉપ્તબીજમાર્ગપાર્શ્વેસ્વરૂપાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","યે જના વાક્યં શ્રુત્વા સહસા પરમાનન્દેન ગૃહ્લન્તિ, કિન્તુ હૃદિ સ્થૈર્ય્યાભાવાત્ કિઞ્ચિત્ કાલમાત્રં તિષ્ઠન્તિ તત્પશ્ચાત્ તદ્વાક્યહેતોઃ ");
INSERT INTO sanguj_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","કુત્રચિત્ ક્લેશે ઉપદ્રવે વા સમુપસ્થિતે તદૈવ વિઘ્નં પ્રાપ્નુવન્તિ તએવ ઉપ્તબીજપાષાણભૂમિસ્વરૂપાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","યે જનાઃ કથાં શૃણ્વન્તિ કિન્તુ સાંસારિકી ચિન્તા ધનભ્રાન્તિ ર્વિષયલોભશ્ચ એતે સર્વ્વે ઉપસ્થાય તાં કથાં ગ્રસન્તિ તતઃ મા વિફલા ભવતિ ");
INSERT INTO sanguj_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","તએવ ઉપ્તબીજસકણ્ટકભૂમિસ્વરૂપાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","યે જના વાક્યં શ્રુત્વા ગૃહ્લન્તિ તેષાં કસ્ય વા ત્રિંશદ્ગુણાનિ કસ્ય વા ષષ્ટિગુણાનિ કસ્ય વા શતગુણાનિ ફલાનિ ભવન્તિ તએવ ઉપ્તબીજોર્વ્વરભૂમિસ્વરૂપાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","તદા સોઽપરમપિ કથિતવાન્ કોપિ જનો દીપાધારં પરિત્યજ્ય દ્રોણસ્યાધઃ ખટ્વાયા અધે વા સ્થાપયિતું દીપમાનયતિ કિં? ");
INSERT INTO sanguj_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","અતોહેતો ર્યન્ન પ્રકાશયિષ્યતે તાદૃગ્ લુક્કાયિતં કિમપિ વસ્તુ નાસ્તિ; યદ્ વ્યક્તં ન ભવિષ્યતિ તાદૃશં ગુપ્તં કિમપિ વસ્તુ નાસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","યસ્ય શ્રોતું કર્ણૌ સ્તઃ સ શૃણોતુ| ");
INSERT INTO sanguj_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","અપરમપિ કથિતવાન્ યૂયં યદ્ યદ્ વાક્યં શૃણુથ તત્ર સાવધાના ભવત, યતો યૂયં યેન પરિમાણેન પરિમાથ તેનૈવ પરિમાણેન યુષ્મદર્થમપિ પરિમાસ્યતે; શ્રોતારો યૂયં યુષ્મભ્યમધિકં દાસ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","યસ્યાશ્રયે વર્દ્ધતે તસ્મૈ અપરમપિ દાસ્યતે, કિન્તુ યસ્યાશ્રયે ન વર્દ્ધતે તસ્ય યત્ કિઞ્ચિદસ્તિ તદપિ તસ્માન્ નેષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","અનન્તરં સ કથિતવાન્ એકો લોકઃ ક્ષેત્રે બીજાન્યુપ્ત્વા ");
INSERT INTO sanguj_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","જાગરણનિદ્રાભ્યાં દિવાનિશં ગમયતિ, પરન્તુ તદ્વીજં તસ્યાજ્ઞાતરૂપેણાઙ્કુરયતિ વર્દ્ધતે ચ; ");
INSERT INTO sanguj_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","યતોહેતોઃ પ્રથમતઃ પત્રાણિ તતઃ પરં કણિશાનિ તત્પશ્ચાત્ કણિશપૂર્ણાનિ શસ્યાનિ ભૂમિઃ સ્વયમુત્પાદયતિ; ");
INSERT INTO sanguj_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","કિન્તુ ફલેષુ પક્કેષુ શસ્યચ્છેદનકાલં જ્ઞાત્વા સ તત્ક્ષણં શસ્યાનિ છિનત્તિ, અનેન તુલ્યમીશ્વરરાજ્યં| ");
INSERT INTO sanguj_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","પુનઃ સોઽકથયદ્ ઈશ્વરરાજ્યં કેન સમં? કેન વસ્તુના સહ વા તદુપમાસ્યામિ? ");
INSERT INTO sanguj_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","તત્ સર્ષપૈકેન તુલ્યં યતો મૃદિ વપનકાલે સર્ષપબીજં સર્વ્વપૃથિવીસ્થબીજાત્ ક્ષુદ્રં ");
INSERT INTO sanguj_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","કિન્તુ વપનાત્ પરમ્ અઙ્કુરયિત્વા સર્વ્વશાકાદ્ બૃહદ્ ભવતિ, તસ્ય બૃહત્યઃ શાખાશ્ચ જાયન્તે તતસ્તચ્છાયાં પક્ષિણ આશ્રયન્તે| ");
INSERT INTO sanguj_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ઇત્થં તેષાં બોધાનુરૂપં સોઽનેકદૃષ્ટાન્તૈસ્તાનુપદિષ્ટવાન્, ");
INSERT INTO sanguj_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","દૃષ્ટાન્તં વિના કામપિ કથાં તેભ્યો ન કથિતવાન્ પશ્ચાન્ નિર્જને સ શિષ્યાન્ સર્વ્વદૃષ્ટાન્તાર્થં બોધિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","તદ્દિનસ્ય સન્ધ્યાયાં સ તેભ્યોઽકથયદ્ આગચ્છત વયં પારં યામ| ");
INSERT INTO sanguj_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","તદા તે લોકાન્ વિસૃજ્ય તમવિલમ્બં ગૃહીત્વા નૌકયા પ્રતસ્થિરે; અપરા અપિ નાવસ્તયા સહ સ્થિતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","તતઃ પરં મહાઝઞ્ભ્શગમાત્ નૌ ર્દોલાયમાના તરઙ્ગેણ જલૈઃ પૂર્ણાભવચ્ચ| ");
INSERT INTO sanguj_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","તદા સ નૌકાચશ્ચાદ્ભાગે ઉપધાને શિરો નિધાય નિદ્રિત આસીત્ તતસ્તે તં જાગરયિત્વા જગદુઃ, હે પ્રભો, અસ્માકં પ્રાણા યાન્તિ કિમત્ર ભવતશ્ચિન્તા નાસ્તિ? ");
INSERT INTO sanguj_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","તદા સ ઉત્થાય વાયું તર્જિતવાન્ સમુદ્રઞ્ચોક્તવાન્ શાન્તઃ સુસ્થિરશ્ચ ભવ; તતો વાયૌ નિવૃત્તેઽબ્ધિર્નિસ્તરઙ્ગોભૂત્| ");
INSERT INTO sanguj_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","તદા સ તાનુવાચ યૂયં કુત એતાદૃક્શઙ્કાકુલા ભવત? કિં વો વિશ્વાસો નાસ્તિ? ");
INSERT INTO sanguj_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","તસ્માત્તેઽતીવભીતાઃ પરસ્પરં વક્તુમારેભિરે, અહો વાયુઃ સિન્ધુશ્ચાસ્ય નિદેશગ્રાહિણૌ કીદૃગયં મનુજઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","અથ તૂ સિન્ધુપારં ગત્વા ગિદેરીયપ્રદેશ ઉપતસ્થુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","નૌકાતો નિર્ગતમાત્રાદ્ અપવિત્રભૂતગ્રસ્ત એકઃ શ્મશાનાદેત્ય તં સાક્ષાચ્ ચકાર| ");
INSERT INTO sanguj_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","સ શ્મશાનેઽવાત્સીત્ કોપિ તં શૃઙ્ખલેન બદ્વ્વા સ્થાપયિતું નાશક્નોત્| ");
INSERT INTO sanguj_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","જનૈર્વારં નિગડૈઃ શૃઙ્ખલૈશ્ચ સ બદ્ધોપિ શૃઙ્ખલાન્યાકૃષ્ય મોચિતવાન્ નિગડાનિ ચ ભંક્ત્વા ખણ્ડં ખણ્ડં કૃતવાન્ કોપિ તં વશીકર્ત્તું ન શશક| ");
INSERT INTO sanguj_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","દિવાનિશં સદા પર્વ્વતં શ્મશાનઞ્ચ ભ્રમિત્વા ચીત્શબ્દં કૃતવાન્ ગ્રાવભિશ્ચ સ્વયં સ્વં કૃતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","સ યીશું દૂરાત્ પશ્યન્નેવ ધાવન્ તં પ્રણનામ ઉચૈરુવંશ્ચોવાચ, ");
INSERT INTO sanguj_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","હે સર્વ્વોપરિસ્થેશ્વરપુત્ર યીશો ભવતા સહ મે કઃ સમ્બન્ધઃ? અહં ત્વામીશ્વરેણ શાપયે માં મા યાતય| ");
INSERT INTO sanguj_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","યતો યીશુસ્તં કથિતવાન્ રે અપવિત્રભૂત, અસ્માન્નરાદ્ બહિર્નિર્ગચ્છ| ");
INSERT INTO sanguj_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","અથ સ તં પૃષ્ટવાન્ કિન્તે નામ? તેન પ્રત્યુક્તં વયમનેકે ઽસ્મસ્તતોઽસ્મન્નામ બાહિની| ");
INSERT INTO sanguj_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","તતોસ્માન્ દેશાન્ન પ્રેષયેતિ તે તં પ્રાર્થયન્ત| ");
INSERT INTO sanguj_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","તદાનીં પર્વ્વતં નિકષા બૃહન્ વરાહવ્રજશ્ચરન્નાસીત્| ");
INSERT INTO sanguj_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","તસ્માદ્ ભૂતા વિનયેન જગદુઃ, અમું વરાહવ્રજમ્ આશ્રયિતુમ્ અસ્માન્ પ્રહિણુ| ");
INSERT INTO sanguj_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","યીશુનાનુજ્ઞાતાસ્તેઽપવિત્રભૂતા બહિર્નિર્યાય વરાહવ્રજં પ્રાવિશન્ તતઃ સર્વ્વે વરાહા વસ્તુતસ્તુ પ્રાયોદ્વિસહસ્રસંઙ્ખ્યકાઃ કટકેન મહાજવાદ્ ધાવન્તઃ સિન્ધૌ પ્રાણાન્ જહુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","તસ્માદ્ વરાહપાલકાઃ પલાયમાનાઃ પુરે ગ્રામે ચ તદ્વાર્ત્તં કથયાઞ્ચક્રુઃ| તદા લોકા ઘટિતં તત્કાર્ય્યં દ્રષ્ટું બહિર્જગ્મુઃ ");
INSERT INTO sanguj_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","યીશોઃ સન્નિધિં ગત્વા તં ભૂતગ્રસ્તમ્ અર્થાદ્ બાહિનીભૂતગ્રસ્તં નરં સવસ્ત્રં સચેતનં સમુપવિષ્ટઞ્ચ દૃृષ્ટ્વા બિભ્યુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","તતો દૃષ્ટતત્કાર્ય્યલોકાસ્તસ્ય ભૂતગ્રસ્તનરસ્ય વરાહવ્રજસ્યાપિ તાં ધટનાં વર્ણયામાસુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","તતસ્તે સ્વસીમાતો બહિર્ગન્તું યીશું વિનેતુમારેભિરે| ");
INSERT INTO sanguj_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","અથ તસ્ય નૌકારોહણકાલે સ ભૂતમુક્તો ના યીશુના સહ સ્થાતું પ્રાર્થયતે; ");
INSERT INTO sanguj_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","કિન્તુ સ તમનનુમત્ય કથિતવાન્ ત્વં નિજાત્મીયાનાં સમીપં ગૃહઞ્ચ ગચ્છ પ્રભુસ્ત્વયિ કૃપાં કૃત્વા યાનિ કર્મ્માણિ કૃતવાન્ તાનિ તાન્ જ્ઞાપય| ");
INSERT INTO sanguj_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","અતઃ સ પ્રસ્થાય યીશુના કૃતં તત્સર્વ્વાશ્ચર્ય્યં કર્મ્મ દિકાપલિદેશે પ્રચારયિતું પ્રારબ્ધવાન્ તતઃ સર્વ્વે લોકા આશ્ચર્ય્યં મેનિરે| ");
INSERT INTO sanguj_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","અનન્તરં યીશૌ નાવા પુનરન્યપાર ઉત્તીર્ણે સિન્ધુતટે ચ તિષ્ઠતિ સતિ તત્સમીપે બહુલોકાનાં સમાગમોઽભૂત્| ");
INSERT INTO sanguj_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","અપરં યાયીર્ નામ્ના કશ્ચિદ્ ભજનગૃહસ્યાધિપ આગત્ય તં દૃષ્ટ્વૈવ ચરણયોઃ પતિત્વા બહુ નિવેદ્ય કથિતવાન્; ");
INSERT INTO sanguj_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","મમ કન્યા મૃતપ્રાયાભૂદ્ અતો ભવાનેત્ય તદારોગ્યાય તસ્યા ગાત્રે હસ્તમ્ અર્પયતુ તેનૈવ સા જીવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","તદા યીશુસ્તેન સહ ચલિતઃ કિન્તુ તત્પશ્ચાદ્ બહુલોકાશ્ચલિત્વા તાદ્ગાત્રે પતિતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","અથ દ્વાદશવર્ષાણિ પ્રદરરોગેણ ");
INSERT INTO sanguj_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","શીર્ણા ચિકિત્સકાનાં નાનાચિકિત્સાભિશ્ચ દુઃખં ભુક્તવતી ચ સર્વ્વસ્વં વ્યયિત્વાપિ નારોગ્યં પ્રાપ્તા ચ પુનરપિ પીડિતાસીચ્ચ ");
INSERT INTO sanguj_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","યા સ્ત્રી સા યીશો ર્વાર્ત્તાં પ્રાપ્ય મનસાકથયત્ યદ્યહં તસ્ય વસ્ત્રમાત્ર સ્પ્રષ્ટું લભેયં તદા રોગહીના ભવિષ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","અતોહેતોઃ સા લોકારણ્યમધ્યે તત્પશ્ચાદાગત્ય તસ્ય વસ્ત્રં પસ્પર્શ| ");
INSERT INTO sanguj_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","તેનૈવ તત્ક્ષણં તસ્યા રક્તસ્રોતઃ શુષ્કં સ્વયં તસ્માદ્ રોગાન્મુક્તા ઇત્યપિ દેહેઽનુભૂતા| ");
INSERT INTO sanguj_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","અથ સ્વસ્માત્ શક્તિ ર્નિર્ગતા યીશુરેતન્મનસા જ્ઞાત્વા લોકનિવહં પ્રતિ મુખં વ્યાવૃત્ય પૃષ્ટવાન્ કેન મદ્વસ્ત્રં સ્પૃષ્ટં? ");
INSERT INTO sanguj_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","તતસ્તસ્ય શિષ્યા ઊચુઃ ભવતો વપુષિ લોકાઃ સંઘર્ષન્તિ તદ્ દૃષ્ટ્વા કેન મદ્વસ્ત્રં સ્પૃષ્ટમિતિ કુતઃ કથયતિ? ");
INSERT INTO sanguj_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","કિન્તુ કેન તત્ કર્મ્મ કૃતં તદ્ દ્રષ્ટું યીશુશ્ચતુર્દિશો દૃષ્ટવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","તતઃ સા સ્ત્રી ભીતા કમ્પિતા ચ સતી સ્વસ્યા રુક્પ્રતિક્રિયા જાતેતિ જ્ઞાત્વાગત્ય તત્સમ્મુખે પતિત્વા સર્વ્વવૃત્તાન્તં સત્યં તસ્મૈ કથયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","તદાનીં યીશુસ્તાં ગદિતવાન્, હે કન્યે તવ પ્રતીતિસ્ત્વામ્ અરોગામકરોત્ ત્વં ક્ષેમેણ વ્રજ સ્વરોગાન્મુક્તા ચ તિષ્ઠ| ");
INSERT INTO sanguj_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ઇતિવાક્યવદનકાલે ભજનગૃહાધિપસ્ય નિવેશનાલ્ લોકા એત્યાધિપં બભાષિરે તવ કન્યા મૃતા તસ્માદ્ ગુરું પુનઃ કુતઃ ક્લિશ્નાસિ? ");
INSERT INTO sanguj_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","કિન્તુ યીશુસ્તદ્ વાક્યં શ્રુત્વૈવ ભજનગૃહાધિપં ગદિતવાન્ મા ભૈષીઃ કેવલં વિશ્વાસિહિ| ");
INSERT INTO sanguj_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","અથ પિતરો યાકૂબ્ તદ્ભ્રાતા યોહન્ ચ એતાન્ વિના કમપિ સ્વપશ્ચાદ્ યાતું નાન્વમન્યત| ");
INSERT INTO sanguj_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","તસ્ય ભજનગૃહાધિપસ્ય નિવેશનસમીપમ્ આગત્ય કલહં બહુરોદનં વિલાપઞ્ચ કુર્વ્વતો લોકાન્ દદર્શ| ");
INSERT INTO sanguj_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","તસ્માન્ નિવેશનં પ્રવિશ્ય પ્રોક્તવાન્ યૂયં કુત ઇત્થં કલહં રોદનઞ્ચ કુરુથ? કન્યા ન મૃતા નિદ્રાતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","તસ્માત્તે તમુપજહસુઃ કિન્તુ યીશુઃ સર્વ્વાન બહિષ્કૃત્ય કન્યાયાઃ પિતરૌ સ્વસઙ્ગિનશ્ચ ગૃહીત્વા યત્ર કન્યાસીત્ તત્ સ્થાનં પ્રવિષ્ટવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","અથ સ તસ્યાઃ કન્યાયા હસ્તૌ ધૃત્વા તાં બભાષે ટાલીથા કૂમી, અર્થતો હે કન્યે ત્વમુત્તિષ્ઠ ઇત્યાજ્ઞાપયામિ| ");
INSERT INTO sanguj_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","તુનૈવ તત્ક્ષણં સા દ્વાદશવર્ષવયસ્કા કન્યા પોત્થાય ચલિતુમારેભે, ઇતઃ સર્વ્વે મહાવિસ્મયં ગતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","તત એતસ્યૈ કિઞ્ચિત્ ખાદ્યં દત્તેતિ કથયિત્વા એતત્કર્મ્મ કમપિ ન જ્ઞાપયતેતિ દૃઢમાદિષ્ટવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","અનન્તરં સ તત્સ્થાનાત્ પ્રસ્થાય સ્વપ્રદેશમાગતઃ શિષ્યાશ્ચ તત્પશ્ચાદ્ ગતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","અથ વિશ્રામવારે સતિ સ ભજનગૃહે ઉપદેષ્ટુમારબ્ધવાન્ તતોઽનેકે લોકાસ્તત્કથાં શ્રુત્વા વિસ્મિત્ય જગદુઃ, અસ્ય મનુજસ્ય ઈદૃશી આશ્ચર્ય્યક્રિયા કસ્માજ્ જાતા? તથા સ્વકરાભ્યામ્ ઇત્થમદ્ભુતં કર્મ્મ કર્ત્તાुમ્ એતસ્મૈ કથં જ્ઞાનં દત્તમ્? ");
INSERT INTO sanguj_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","કિમયં મરિયમઃ પુત્રસ્તજ્ઞા નો? કિમયં યાકૂબ્-યોસિ-યિહુદા-શિમોનાં ભ્રાતા નો? અસ્ય ભગિન્યઃ કિમિહાસ્માભિઃ સહ નો? ઇત્થં તે તદર્થે પ્રત્યૂહં ગતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","તદા યીશુસ્તેભ્યોઽકથયત્ સ્વદેશં સ્વકુટુમ્બાન્ સ્વપરિજનાંશ્ચ વિના કુત્રાપિ ભવિષ્યદ્વાદી અસત્કૃતો ન ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","અપરઞ્ચ તેષામપ્રત્યયાત્ સ વિસ્મિતઃ કિયતાં રોગિણાં વપુઃષુ હસ્તમ્ અર્પયિત્વા કેવલં તેષામારોગ્યકરણાદ્ અન્યત્ કિમપિ ચિત્રકાર્ય્યં કર્ત્તાં ન શક્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","અથ સ ચતુર્દિક્સ્થ ગ્રામાન્ ભ્રમિત્વા ઉપદિષ્ટવાન્ ");
INSERT INTO sanguj_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","દ્વાદશશિષ્યાન્ આહૂય અમેધ્યભૂતાન્ વશીકર્ત્તાં શક્તિં દત્ત્વા તેષાં દ્વૌ દ્વૌ જનો પ્રેષિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","પુનરિત્યાદિશદ્ યૂયમ્ એકૈકાં યષ્ટિં વિના વસ્ત્રસંપુટઃ પૂપઃ કટિબન્ધે તામ્રખણ્ડઞ્ચ એષાં કિમપિ મા ગ્રહ્લીત, ");
INSERT INTO sanguj_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","માર્ગયાત્રાયૈ પાદેષૂપાનહૌ દત્ત્વા દ્વે ઉત્તરીયે મા પરિધદ્વ્વં| ");
INSERT INTO sanguj_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","અપરમપ્યુક્તં તેન યૂયં યસ્યાં પુર્ય્યાં યસ્ય નિવેશનં પ્રવેક્ષ્યથ તાં પુરીં યાવન્ન ત્યક્ષ્યથ તાવત્ તન્નિવેશને સ્થાસ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","તત્ર યદિ કેપિ યુષ્માકમાતિથ્યં ન વિદધતિ યુષ્માકં કથાશ્ચ ન શૃણ્વન્તિ તર્હિ તત્સ્થાનાત્ પ્રસ્થાનસમયે તેષાં વિરુદ્ધં સાક્ષ્યં દાતું સ્વપાદાનાસ્ફાલ્ય રજઃ સમ્પાતયત; અહં યુષ્માન્ યથાર્થં વચ્મિ વિચારદિને તન્નગરસ્યાવસ્થાતઃ સિદોમામોરયો ર્નગરયોરવસ્થા સહ્યતરા ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","અથ તે ગત્વા લોકાનાં મનઃપરાવર્ત્તનીઃ કથા પ્રચારિતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","એવમનેકાન્ ભૂતાંશ્ચ ત્યાજિતવન્તસ્તથા તૈલેન મર્દ્દયિત્વા બહૂન્ જનાનરોગાનકાર્ષુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ઇત્થં તસ્ય સુખ્યાતિશ્ચતુર્દિશો વ્યાપ્તા તદા હેરોદ્ રાજા તન્નિશમ્ય કથિતવાન્, યોહન્ મજ્જકઃ શ્મશાનાદ્ ઉત્થિત અતોહેતોસ્તેન સર્વ્વા એતા અદ્ભુતક્રિયાઃ પ્રકાશન્તે| ");
INSERT INTO sanguj_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","અન્યેઽકથયન્ અયમ્ એલિયઃ, કેપિ કથિતવન્ત એષ ભવિષ્યદ્વાદી યદ્વા ભવિષ્યદ્વાદિનાં સદૃશ એકોયમ્| ");
INSERT INTO sanguj_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","કિન્તુ હેરોદ્ ઇત્યાકર્ણ્ય ભાષિતવાન્ યસ્યાહં શિરશ્છિન્નવાન્ સ એવ યોહનયં સ શ્મશાનાદુદતિષ્ઠત્| ");
INSERT INTO sanguj_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","પૂર્વ્વં સ્વભ્રાતુઃ ફિલિપસ્ય પત્ન્યા ઉદ્વાહં કૃતવન્તં હેરોદં યોહનવાદીત્ સ્વભાતૃવધૂ ર્ન વિવાહ્યા| ");
INSERT INTO sanguj_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","અતઃ કારણાત્ હેરોદ્ લોકં પ્રહિત્ય યોહનં ધૃત્વા બન્ધનાલયે બદ્ધવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","હેરોદિયા તસ્મૈ યોહને પ્રકુપ્ય તં હન્તુમ્ ઐચ્છત્ કિન્તુ ન શક્તા, ");
INSERT INTO sanguj_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","યસ્માદ્ હેરોદ્ તં ધાર્મ્મિકં સત્પુરુષઞ્ચ જ્ઞાત્વા સમ્મન્ય રક્ષિતવાન્; તત્કથાં શ્રુત્વા તદનુસારેણ બહૂનિ કર્મ્માણિ કૃતવાન્ હૃષ્ટમનાસ્તદુપદેશં શ્રુતવાંશ્ચ| ");
INSERT INTO sanguj_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","કિન્તુ હેરોદ્ યદા સ્વજન્મદિને પ્રધાનલોકેભ્યઃ સેનાનીભ્યશ્ચ ગાલીલ્પ્રદેશીયશ્રેષ્ઠલોકેભ્યશ્ચ રાત્રૌ ભોજ્યમેકં કૃતવાન્ ");
INSERT INTO sanguj_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","તસ્મિન્ શુભદિને હેરોદિયાયાઃ કન્યા સમેત્ય તેષાં સમક્ષં સંનૃત્ય હેરોદસ્તેન સહોપવિષ્ટાનાઞ્ચ તોષમજીજનત્ તતા નૃપઃ કન્યામાહ સ્મ મત્તો યદ્ યાચસે તદેવ તુભ્યં દાસ્યે| ");
INSERT INTO sanguj_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","શપથં કૃત્વાકથયત્ ચેદ્ રાજ્યાર્દ્ધમપિ યાચસે તદપિ તુભ્યં દાસ્યે| ");
INSERT INTO sanguj_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","તતઃ સા બહિ ર્ગત્વા સ્વમાતરં પપ્રચ્છ કિમહં યાચિષ્યે? તદા સાકથયત્ યોહનો મજ્જકસ્ય શિરઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","અથ તૂર્ણં ભૂપસમીપમ્ એત્ય યાચમાનાવદત્ ક્ષણેસ્મિન્ યોહનો મજ્જકસ્ય શિરઃ પાત્રે નિધાય દેહિ, એતદ્ યાચેઽહં| ");
INSERT INTO sanguj_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","તસ્માત્ ભૂપોઽતિદુઃખિતઃ, તથાપિ સ્વશપથસ્ય સહભોજિનાઞ્ચાનુરોધાત્ તદનઙ્ગીકર્ત્તું ન શક્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","તત્ક્ષણં રાજા ઘાતકં પ્રેષ્ય તસ્ય શિર આનેતુમાદિષ્ટવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","તતઃ સ કારાગારં ગત્વા તચ્છિરશ્છિત્વા પાત્રે નિધાયાનીય તસ્યૈ કન્યાયૈ દત્તવાન્ કન્યા ચ સ્વમાત્રે દદૌ| ");
INSERT INTO sanguj_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","અનનતરં યોહનઃ શિષ્યાસ્તદ્વાર્ત્તાં પ્રાપ્યાગત્ય તસ્ય કુણપં શ્મશાનેઽસ્થાપયન્| ");
INSERT INTO sanguj_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","અથ પ્રેષિતા યીશોઃ સન્નિધૌ મિલિતા યદ્ યચ્ ચક્રુઃ શિક્ષયામાસુશ્ચ તત્સર્વ્વવાર્ત્તાસ્તસ્મૈ કથિતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","સ તાનુવાચ યૂયં વિજનસ્થાનં ગત્વા વિશ્રામ્યત યતસ્તત્સન્નિધૌ બહુલોકાનાં સમાગમાત્ તે ભોક્તું નાવકાશં પ્રાપ્તાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","તતસ્તે નાવા વિજનસ્થાનં ગુપ્તં ગગ્મુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","તતો લોકનિવહસ્તેષાં સ્થાનાન્તરયાનં દદર્શ, અનેકે તં પરિચિત્ય નાનાપુરેભ્યઃ પદૈર્વ્રજિત્વા જવેન તૈષામગ્રે યીશોઃ સમીપ ઉપતસ્થુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","તદા યીશુ ર્નાવો બહિર્ગત્ય લોકારણ્યાનીં દૃષ્ટ્વા તેષુ કરુણાં કૃતવાન્ યતસ્તેઽરક્ષકમેષા ઇવાસન્ તદા સ તાન નાનાપ્રસઙ્ગાન્ ઉપદિષ્ટવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","અથ દિવાન્તે સતિ શિષ્યા એત્ય યીશુમૂચિરે, ઇદં વિજનસ્થાનં દિનઞ્ચાવસન્નં| ");
INSERT INTO sanguj_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","લોકાનાં કિમપિ ખાદ્યં નાસ્તિ, અતશ્ચતુર્દિક્ષુ ગ્રામાન્ ગન્તું ભોજ્યદ્રવ્યાણિ ક્રેતુઞ્ચ ભવાન્ તાન્ વિસૃજતુ| ");
INSERT INTO sanguj_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","તદા સ તાનુવાચ યૂયમેવ તાન્ ભોજયત; તતસ્તે જગદુ ર્વયં ગત્વા દ્વિશતસંખ્યકૈ ર્મુદ્રાપાદૈઃ પૂપાન્ ક્રીત્વા કિં તાન્ ભોજયિષ્યામઃ? ");
INSERT INTO sanguj_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","તદા સ તાન્ પૃષ્ઠવાન્ યુષ્માકં સન્નિધૌ કતિ પૂપા આસતે? ગત્વા પશ્યત; તતસ્તે દૃષ્ટ્વા તમવદન્ પઞ્ચ પૂપા દ્વૌ મત્સ્યૌ ચ સન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","તદા સ લોકાન્ શસ્પોપરિ પંક્તિભિરુપવેશયિતુમ્ આદિષ્ટવાન્, ");
INSERT INTO sanguj_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","તતસ્તે શતં શતં જનાઃ પઞ્ચાશત્ પઞ્ચાશજ્જનાશ્ચ પંક્તિભિ ર્ભુવિ સમુપવિવિશુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","અથ સ તાન્ પઞ્ચપૂપાન્ મત્સ્યદ્વયઞ્ચ ધૃત્વા સ્વર્ગં પશ્યન્ ઈશ્વરગુણાન્ અન્વકીર્ત્તયત્ તાન્ પૂપાન્ ભંક્ત્વા લોકેભ્યઃ પરિવેષયિતું શિષ્યેભ્યો દત્તવાન્ દ્વા મત્સ્યૌ ચ વિભજ્ય સર્વ્વેભ્યો દત્તવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","તતઃ સર્વ્વે ભુક્ત્વાતૃપ્યન્| ");
INSERT INTO sanguj_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","અનન્તરં શિષ્યા અવશિષ્ટૈઃ પૂપૈ ર્મત્સ્યૈશ્ચ પૂર્ણાન્ દ્વદશ ડલ્લકાન્ જગૃહુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","તે ભોક્તારઃ પ્રાયઃ પઞ્ચ સહસ્રાણિ પુરુષા આસન્| ");
INSERT INTO sanguj_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","અથ સ લોકાન્ વિસૃજન્નેવ નાવમારોઢું સ્વસ્માદગ્રે પારે બૈત્સૈદાપુરં યાતુઞ્ચ શ્ષ્યિाન્ વાઢમાદિષ્ટવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","તદા સ સર્વ્વાન્ વિસૃજ્ય પ્રાર્થયિતું પર્વ્વતં ગતઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","તતઃ સન્ધ્યાયાં સત્યાં નૌઃ સિન્ધુમધ્ય ઉપસ્થિતા કિન્તુ સ એકાકી સ્થલે સ્થિતઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","અથ સમ્મુખવાતવહનાત્ શિષ્યા નાવં વાહયિત્વા પરિશ્રાન્તા ઇતિ જ્ઞાત્વા સ નિશાચતુર્થયામે સિન્ધૂપરિ પદ્ભ્યાં વ્રજન્ તેષાં સમીપમેત્ય તેષામગ્રે યાતુમ્ ઉદ્યતઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","કિન્તુ શિષ્યાઃ સિન્ધૂપરિ તં વ્રજન્તં દૃષ્ટ્વા ભૂતમનુમાય રુરુવુઃ, ");
INSERT INTO sanguj_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","યતઃ સર્વ્વે તં દૃષ્ટ્વા વ્યાકુલિતાઃ| અતએવ યીશુસ્તત્ક્ષણં તૈઃ સહાલપ્ય કથિતવાન્, સુસ્થિરા ભૂત, અયમહં મા ભૈષ્ટ| ");
INSERT INTO sanguj_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","અથ નૌકામારુહ્ય તસ્મિન્ તેષાં સન્નિધિં ગતે વાતો નિવૃત્તઃ; તસ્માત્તે મનઃસુ વિસ્મિતા આશ્ચર્ય્યં મેનિરે| ");
INSERT INTO sanguj_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","યતસ્તે મનસાં કાઠિન્યાત્ તત્ પૂપીયમ્ આશ્ચર્ય્યં કર્મ્મ ન વિવિક્તવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","અથ તે પારં ગત્વા ગિનેષરત્પ્રદેશમેત્ય તટ ઉપસ્થિતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","તેષુ નૌકાતો બહિર્ગતેષુ તત્પ્રદેશીયા લોકાસ્તં પરિચિત્ય ");
INSERT INTO sanguj_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ચતુર્દિક્ષુ ધાવન્તો યત્ર યત્ર રોગિણો નરા આસન્ તાન્ સર્વ્વાન ખટ્વોપરિ નિધાય યત્ર કુત્રચિત્ તદ્વાર્ત્તાં પ્રાપુઃ તત્ સ્થાનમ્ આનેતુમ્ આરેભિરે| ");
INSERT INTO sanguj_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","તથા યત્ર યત્ર ગ્રામે યત્ર યત્ર પુરે યત્ર યત્ર પલ્લ્યાઞ્ચ તેન પ્રવેશઃ કૃતસ્તદ્વર્ત્મમધ્યે લોકાઃ પીડિતાન્ સ્થાપયિત્વા તસ્ય ચેલગ્રન્થિમાત્રં સ્પ્રષ્ટુમ્ તેષામર્થે તદનુજ્ઞાં પ્રાર્થયન્તઃ યાવન્તો લોકાઃ પસ્પૃશુસ્તાવન્ત એવ ગદાન્મુક્તાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","અનન્તરં યિરૂશાલમ આગતાઃ ફિરૂશિનોઽધ્યાપકાશ્ચ યીશોઃ સમીપમ્ આગતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","તે તસ્ય કિયતઃ શિષ્યાન્ અશુચિકરૈરર્થાદ અપ્રક્ષાલિતહસ્તૈ ર્ભુઞ્જતો દૃષ્ટ્વા તાનદૂષયન્| ");
INSERT INTO sanguj_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","યતઃ ફિરૂશિનઃ સર્વ્વયિહૂદીયાશ્ચ પ્રાચાં પરમ્પરાગતવાક્યં સમ્મન્ય પ્રતલેન હસ્તાન્ અપ્રક્ષાલ્ય ન ભુઞ્જતે| ");
INSERT INTO sanguj_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","આપનાદાગત્ય મજ્જનં વિના ન ખાદન્તિ; તથા પાનપાત્રાણાં જલપાત્રાણાં પિત્તલપાત્રાણામ્ આસનાનાઞ્ચ જલે મજ્જનમ્ ઇત્યાદયોન્યેપિ બહવસ્તેષામાચારાઃ સન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","તે ફિરૂશિનોઽધ્યાપકાશ્ચ યીશું પપ્રચ્છુઃ, તવ શિષ્યાઃ પ્રાચાં પરમ્પરાગતવાક્યાનુસારેણ નાચરન્તોઽપ્રક્ષાલિતકરૈઃ કુતો ભુજંતે? ");
INSERT INTO sanguj_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","તતઃ સ પ્રત્યુવાચ કપટિનો યુષ્માન્ ઉદ્દિશ્ય યિશયિયભવિષ્યદ્વાદી યુક્તમવાદીત્| યથા સ્વકીયૈરધરૈરેતે સમ્મન્યનતે સદૈવ માં| કિન્તુ મત્તો વિપ્રકર્ષે સન્તિ તેષાં મનાંસિ ચ| ");
INSERT INTO sanguj_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","શિક્ષયન્તો બિધીન્ ન્નાજ્ઞા ભજન્તે માં મુધૈવ તે| ");
INSERT INTO sanguj_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","યૂયં જલપાત્રપાનપાત્રાદીનિ મજ્જયન્તો મનુજપરમ્પરાગતવાક્યં રક્ષથ કિન્તુ ઈશ્વરાજ્ઞાં લંઘધ્વે; અપરા ઈદૃશ્યોનેકાઃ ક્રિયા અપિ કુરુધ્વે| ");
INSERT INTO sanguj_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","અન્યઞ્ચાકથયત્ યૂયં સ્વપરમ્પરાગતવાક્યસ્ય રક્ષાર્થં સ્પષ્ટરૂપેણ ઈશ્વરાજ્ઞાં લોપયથ| ");
INSERT INTO sanguj_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","યતો મૂસાદ્વારા પ્રોક્તમસ્તિ સ્વપિતરૌ સમ્મન્યધ્વં યસ્તુ માતરં પિતરં વા દુર્વ્વાક્યં વક્તિ સ નિતાન્તં હન્યતાં| ");
INSERT INTO sanguj_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","કિન્તુ મદીયેન યેન દ્રવ્યેણ તવોપકારોભવત્ તત્ કર્બ્બાણમર્થાદ્ ઈશ્વરાય નિવેદિતમ્ ઇદં વાક્યં યદિ કોપિ પિતરં માતરં વા વક્તિ ");
INSERT INTO sanguj_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","તર્હિ યૂયં માતુઃ પિતુ ર્વોપકારં કર્ત્તાં તં વારયથ| ");
INSERT INTO sanguj_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ઇત્થં સ્વપ્રચારિતપરમ્પરાગતવાક્યેન યૂયમ્ ઈશ્વરાજ્ઞાં મુધા વિધદ્વ્વે, ઈદૃશાન્યન્યાન્યનેકાનિ કર્મ્માણિ કુરુધ્વે| ");
INSERT INTO sanguj_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","અથ સ લોકાનાહૂય બભાષે યૂયં સર્વ્વે મદ્વાક્યં શૃણુત બુધ્યધ્વઞ્ચ| ");
INSERT INTO sanguj_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","બાહ્યાદન્તરં પ્રવિશ્ય નરમમેધ્યં કર્ત્તાં શક્નોતિ ઈદૃશં કિમપિ વસ્તુ નાસ્તિ, વરમ્ અન્તરાદ્ બહિર્ગતં યદ્વસ્તુ તન્મનુજમ્ અમેધ્યં કરોતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","યસ્ય શ્રોતું શ્રોત્રે સ્તઃ સ શૃણોતુ| ");
INSERT INTO sanguj_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","તતઃ સ લોકાન્ હિત્વા ગૃહમધ્યં પ્રવિષ્ટસ્તદા શિષ્યાસ્તદૃષ્ટાન્તવાક્યાર્થં પપ્રચ્છુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","તસ્માત્ સ તાન્ જગાદ યૂયમપિ કિમેતાદૃગબોધાઃ? કિમપિ દ્રવ્યં બાહ્યાદન્તરં પ્રવિશ્ય નરમમેધ્યં કર્ત્તાં ન શક્નોતિ કથામિમાં કિં ન બુધ્યધ્વે? ");
INSERT INTO sanguj_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","તત્ તદન્તર્ન પ્રવિશતિ કિન્તુ કુક્ષિમધ્યં પ્રવિશતિ શેષે સર્વ્વભુક્તવસ્તુગ્રાહિણિ બહિર્દેશે નિર્યાતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","અપરમપ્યવાદીદ્ યન્નરાન્નિરેતિ તદેવ નરમમેધ્યં કરોતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","યતોઽન્તરાદ્ અર્થાન્ માનવાનાં મનોભ્યઃ કુચિન્તા પરસ્ત્રીવેશ્યાગમનં ");
INSERT INTO sanguj_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","નરવધશ્ચૌર્ય્યં લોભો દુષ્ટતા પ્રવઞ્ચના કામુકતા કુદૃષ્ટિરીશ્વરનિન્દા ગર્વ્વસ્તમ ઇત્યાદીનિ નિર્ગચ્છન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","એતાનિ સર્વ્વાણિ દુરિતાન્યન્તરાદેત્ય નરમમેધ્યં કુર્વ્વન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","અથ સ ઉત્થાય તત્સ્થાનાત્ સોરસીદોન્પુરપ્રદેશં જગામ તત્ર કિમપિ નિવેશનં પ્રવિશ્ય સર્વ્વૈરજ્ઞાતઃ સ્થાતું મતિઞ્ચક્રે કિન્તુ ગુપ્તઃ સ્થાતું ન શશાક| ");
INSERT INTO sanguj_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","યતઃ સુરફૈનિકીદેશીયયૂનાનીવંશોદ્ભવસ્ત્રિયાઃ કન્યા ભૂતગ્રસ્તાસીત્| સા સ્ત્રી તદ્વાર્ત્તાં પ્રાપ્ય તત્સમીપમાગત્ય તચ્ચરણયોઃ પતિત્વા ");
INSERT INTO sanguj_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","સ્વકન્યાતો ભૂતં નિરાકર્ત્તાં તસ્મિન્ વિનયં કૃતવતી| ");
INSERT INTO sanguj_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","કિન્તુ યીશુસ્તામવદત્ પ્રથમં બાલકાસ્તૃપ્યન્તુ યતો બાલકાનાં ખાદ્યં ગૃહીત્વા કુક્કુરેભ્યો નિક્ષેપોઽનુચિતઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","તદા સા સ્ત્રી તમવાદીત્ ભોઃ પ્રભો તત્ સત્યં તથાપિ મઞ્ચાધઃસ્થાઃ કુક્કુરા બાલાનાં કરપતિતાનિ ખાદ્યખણ્ડાનિ ખાદન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","તતઃ સોઽકથયદ્ એતત્કથાહેતોઃ સકુશલા યાહિ તવ કન્યાં ત્યક્ત્વા ભૂતો ગતઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","અથ સા સ્ત્રી ગૃહં ગત્વા કન્યાં ભૂતત્યક્તાં શય્યાસ્થિતાં દદર્શ| ");
INSERT INTO sanguj_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","પુનશ્ચ સ સોરસીદોન્પુરપ્રદેશાત્ પ્રસ્થાય દિકાપલિદેશસ્ય પ્રાન્તરભાગેન ગાલીલ્જલધેઃ સમીપં ગતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","તદા લોકૈરેકં બધિરં કદ્વદઞ્ચ નરં તન્નિકટમાનીય તસ્ય ગાત્રે હસ્તમર્પયિતું વિનયઃ કૃતઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","તતો યીશુ ર્લોકારણ્યાત્ તં નિર્જનમાનીય તસ્ય કર્ણયોઙ્ગુલી ર્દદૌ નિષ્ઠીવં દત્ત્વા ચ તજ્જિહ્વાં પસ્પર્શ| ");
INSERT INTO sanguj_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","અનન્તરં સ્વર્ગં નિરીક્ષ્ય દીર્ઘં નિશ્વસ્ય તમવદત્ ઇતફતઃ અર્થાન્ મુક્તો ભૂયાત્| ");
INSERT INTO sanguj_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","તતસ્તત્ક્ષણં તસ્ય કર્ણૌ મુક્તૌ જિહ્વાયાશ્ચ જાડ્યાપગમાત્ સ સુસ્પષ્ટવાક્યમકથયત્| ");
INSERT INTO sanguj_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","અથ સ તાન્ વાઢમિત્યાદિદેશ યૂયમિમાં કથાં કસ્મૈચિદપિ મા કથયત, કિન્તુ સ યતિ ન્યષેધત્ તે તતિ બાહુલ્યેન પ્રાચારયન્; ");
INSERT INTO sanguj_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","તેઽતિચમત્કૃત્ય પરસ્પરં કથયામાસુઃ સ બધિરાય શ્રવણશક્તિં મૂકાય ચ કથનશક્તિં દત્ત્વા સર્વ્વં કર્મ્મોત્તમરૂપેણ ચકાર| ");
INSERT INTO sanguj_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","તદા તત્સમીપં બહવો લોકા આયાતા અતસ્તેષાં ભોજ્યદ્રવ્યાભાવાદ્ યીશુઃ શિષ્યાનાહૂય જગાદ,| ");
INSERT INTO sanguj_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","લોકનિવહે મમ કૃપા જાયતે તે દિનત્રયં મયા સાર્દ્ધં સન્તિ તેષાં ભોજ્યં કિમપિ નાસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","તેષાં મધ્યેઽનેકે દૂરાદ્ આગતાઃ, અભુક્તેષુ તેષુ મયા સ્વગૃહમભિપ્રહિતેષુ તે પથિ ક્લમિષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","શિષ્યા અવાદિષુઃ, એતાવતો લોકાન્ તર્પયિતુમ્ અત્ર પ્રન્તરે પૂપાન્ પ્રાપ્તું કેન શક્યતે? ");
INSERT INTO sanguj_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","તતઃ સ તાન્ પપ્રચ્છ યુષ્માકં કતિ પૂપાઃ સન્તિ? તેઽકથયન્ સપ્ત| ");
INSERT INTO sanguj_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","તતઃ સ તાલ્લોકાન્ ભુવિ સમુપવેષ્ટુમ્ આદિશ્ય તાન્ સપ્ત પૂપાન્ ધૃત્વા ઈશ્વરગુણાન્ અનુકીર્ત્તયામાસ, ભંક્ત્વા પરિવેષયિતું શિષ્યાન્ પ્રતિ દદૌ, તતસ્તે લોકેભ્યઃ પરિવેષયામાસુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","તથા તેષાં સમીપે યે ક્ષુદ્રમત્સ્યા આસન્ તાનપ્યાદાય ઈશ્વરગુણાન્ સંકીર્ત્ય પરિવેષયિતુમ્ આદિષ્ટવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","તતો લોકા ભુક્ત્વા તૃપ્તિં ગતા અવશિષ્ટખાદ્યૈઃ પૂર્ણાઃ સપ્તડલ્લકા ગૃહીતાશ્ચ| ");
INSERT INTO sanguj_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","એતે ભોક્તારઃ પ્રાયશ્ચતુઃ સહસ્રપુરુષા આસન્ તતઃ સ તાન્ વિસસર્જ| ");
INSERT INTO sanguj_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","અથ સ શિષ્યઃ સહ નાવમારુહ્ય દલ્માનૂથાસીમામાગતઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","તતઃ પરં ફિરૂશિન આગત્ય તેન સહ વિવદમાનાસ્તસ્ય પરીક્ષાર્થમ્ આકાશીયચિહ્નં દ્રષ્ટું યાચિતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","તદા સોઽન્તર્દીર્ઘં નિશ્વસ્યાકથયત્, એતે વિદ્યમાનનરાઃ કુતશ્ચિન્હં મૃગયન્તે? યુષ્માનહં યથાર્થં બ્રવીમિ લોકાનેતાન્ કિમપિ ચિહ્નં ન દર્શયિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","અથ તાન્ હિત્વા પુન ર્નાવમ્ આરુહ્ય પારમગાત્| ");
INSERT INTO sanguj_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","એતર્હિ શિષ્યૈઃ પૂપેષુ વિસ્મૃતેષુ નાવિ તેષાં સન્નિધૌ પૂપ એકએવ સ્થિતઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","તદાનીં યીશુસ્તાન્ આદિષ્ટવાન્ ફિરૂશિનાં હેરોદશ્ચ કિણ્વં પ્રતિ સતર્કાઃ સાવધાનાશ્ચ ભવત| ");
INSERT INTO sanguj_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","તતસ્તેઽન્યોન્યં વિવેચનં કર્તુમ્ આરેભિરે, અસ્માકં સન્નિધૌ પૂપો નાસ્તીતિ હેતોરિદં કથયતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","તદ્ બુદ્વ્વા યીશુસ્તેભ્યોઽકથયત્ યુષ્માકં સ્થાને પૂપાભાવાત્ કુત ઇત્થં વિતર્કયથ? યૂયં કિમદ્યાપિ કિમપિ ન જાનીથ? બોદ્ધુઞ્ચ ન શક્નુથ? યાવદદ્ય કિં યુષ્માકં મનાંસિ કઠિનાનિ સન્તિ? ");
INSERT INTO sanguj_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","સત્સુ નેત્રેષુ કિં ન પશ્યથ? સત્સુ કર્ણેષુ કિં ન શૃણુથ? ન સ્મરથ ચ? ");
INSERT INTO sanguj_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","યદાહં પઞ્ચપૂપાન્ પઞ્ચસહસ્રાણાં પુરુષાણાં મધ્યે ભંક્ત્વા દત્તવાન્ તદાનીં યૂયમ્ અવશિષ્ટપૂપૈઃ પૂર્ણાન્ કતિ ડલ્લકાન્ ગૃહીતવન્તઃ? તેઽકથયન્ દ્વાદશડલ્લકાન્| ");
INSERT INTO sanguj_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","અપરઞ્ચ યદા ચતુઃસહસ્રાણાં પુરુષાણાં મધ્યે પૂપાન્ ભંક્ત્વાદદાં તદા યૂયમ્ અતિરિક્તપૂપાનાં કતિ ડલ્લકાન્ ગૃહીતવન્તઃ? તે કથયામાસુઃ સપ્તડલ્લકાન્| ");
INSERT INTO sanguj_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","તદા સ કથિતવાન્ તર્હિ યૂયમ્ અધુનાપિ કુતો બોદ્વ્વું ન શક્નુથ? ");
INSERT INTO sanguj_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","અનન્તરં તસ્મિન્ બૈત્સૈદાનગરે પ્રાપ્તે લોકા અન્ધમેકં નરં તત્સમીપમાનીય તં સ્પ્રષ્ટું તં પ્રાર્થયાઞ્ચક્રિરે| ");
INSERT INTO sanguj_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","તદા તસ્યાન્ધસ્ય કરૌ ગૃહીત્વા નગરાદ્ બહિર્દેશં તં નીતવાન્; તન્નેત્રે નિષ્ઠીવં દત્ત્વા તદ્ગાત્રે હસ્તાવર્પયિત્વા તં પપ્રચ્છ, કિમપિ પશ્યસિ? ");
INSERT INTO sanguj_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","સ નેત્રે ઉન્મીલ્ય જગાદ, વૃક્ષવત્ મનુજાન્ ગચ્છતો નિરીક્ષે| ");
INSERT INTO sanguj_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","તતો યીશુઃ પુનસ્તસ્ય નયનયો ર્હસ્તાવર્પયિત્વા તસ્ય નેત્રે ઉન્મીલયામાસ; તસ્માત્ સ સ્વસ્થો ભૂત્વા સ્પષ્ટરૂપં સર્વ્વલોકાન્ દદર્શ| ");
INSERT INTO sanguj_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","તતઃ પરં ત્વં ગ્રામં મા ગચ્છ ગ્રામસ્થં કમપિ ચ કિમપ્યનુક્ત્વા નિજગૃહં યાહીત્યાદિશ્ય યીશુસ્તં નિજગૃહં પ્રહિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","અનન્તરં શિષ્યૈઃ સહિતો યીશુઃ કૈસરીયાફિલિપિપુરં જગામ, પથિ ગચ્છન્ તાનપૃચ્છત્ કોઽહમ્ અત્ર લોકાઃ કિં વદન્તિ? ");
INSERT INTO sanguj_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","તે પ્રત્યૂચુઃ ત્વાં યોહનં મજ્જકં વદન્તિ કિન્તુ કેપિ કેપિ એલિયં વદન્તિ; અપરે કેપિ કેપિ ભવિષ્યદ્વાદિનામ્ એકો જન ઇતિ વદન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","અથ સ તાનપૃચ્છત્ કિન્તુ કોહમ્? ઇત્યત્ર યૂયં કિં વદથ? તદા પિતરઃ પ્રત્યવદત્ ભવાન્ અભિષિક્તસ્ત્રાતા| ");
INSERT INTO sanguj_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","તતઃ સ તાન્ ગાઢમાદિશદ્ યૂયં મમ કથા કસ્મૈચિદપિ મા કથયત| ");
INSERT INTO sanguj_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","મનુષ્યપુત્રેણાવશ્યં બહવો યાતના ભોક્તવ્યાઃ પ્રાચીનલોકૈઃ પ્રધાનયાજકૈરધ્યાપકૈશ્ચ સ નિન્દિતઃ સન્ ઘાતયિષ્યતે તૃતીયદિને ઉત્થાસ્યતિ ચ, યીશુઃ શિષ્યાનુપદેષ્ટુમારભ્ય કથામિમાં સ્પષ્ટમાચષ્ટ| ");
INSERT INTO sanguj_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","તસ્માત્ પિતરસ્તસ્ય હસ્તૌ ધૃત્વા તં તર્જ્જિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","કિન્તુ સ મુખં પરાવર્ત્ય શિષ્યગણં નિરીક્ષ્ય પિતરં તર્જયિત્વાવાદીદ્ દૂરીભવ વિઘ્નકારિન્ ઈશ્વરીયકાર્ય્યાદપિ મનુષ્યકાર્ય્યં તુભ્યં રોચતતરાં| ");
INSERT INTO sanguj_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","અથ સ લોકાન્ શિષ્યાંશ્ચાહૂય જગાદ યઃ કશ્ચિન્ મામનુગન્તુમ્ ઇચ્છતિ સ આત્માનં દામ્યતુ, સ્વક્રુશં ગૃહીત્વા મત્પશ્ચાદ્ આયાતુ| ");
INSERT INTO sanguj_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","યતો યઃ કશ્ચિત્ સ્વપ્રાણં રક્ષિતુમિચ્છતિ સ તં હારયિષ્યતિ, કિન્તુ યઃ કશ્ચિન્ મદર્થં સુસંવાદાર્થઞ્ચ પ્રાણં હારયતિ સ તં રક્ષિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","અપરઞ્ચ મનુજઃ સર્વ્વં જગત્ પ્રાપ્ય યદિ સ્વપ્રાણં હારયતિ તર્હિ તસ્ય કો લાભઃ? ");
INSERT INTO sanguj_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","નરઃ સ્વપ્રાણવિનિમયેન કિં દાતું શક્નોતિ? ");
INSERT INTO sanguj_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","એતેષાં વ્યભિચારિણાં પાપિનાઞ્ચ લોકાનાં સાક્ષાદ્ યદિ કોપિ માં મત્કથાઞ્ચ લજ્જાસ્પદં જાનાતિ તર્હિ મનુજપુત્રો યદા ધર્મ્મદૂતૈઃ સહ પિતુઃ પ્રભાવેણાગમિષ્યતિ તદા સોપિ તં લજ્જાસ્પદં જ્ઞાસ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","અથ સ તાનવાદીત્ યુષ્મભ્યમહં યથાર્થં કથયામિ, ઈશ્વરરાજ્યં પરાક્રમેણોપસ્થિતં ન દૃષ્ટ્વા મૃત્યું નાસ્વાદિષ્યન્તે, અત્ર દણ્ડાયમાનાનાં મધ્યેપિ તાદૃશા લોકાઃ સન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","અથ ષડ્દિનેભ્યઃ પરં યીશુઃ પિતરં યાકૂબં યોહનઞ્ચ ગૃહીત્વા ગિરેરુચ્ચસ્ય નિર્જનસ્થાનં ગત્વા તેષાં પ્રત્યક્ષે મૂર્ત્યન્તરં દધાર| ");
INSERT INTO sanguj_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","તતસ્તસ્ય પરિધેયમ્ ઈદૃશમ્ ઉજ્જ્વલહિમપાણડરં જાતં યદ્ જગતિ કોપિ રજકો ન તાદૃક્ પાણડરં કર્ત્તાં શક્નોતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","અપરઞ્ચ એલિયો મૂસાશ્ચ તેભ્યો દર્શનં દત્ત્વા યીશુના સહ કથનં કર્ત્તુમારેભાતે| ");
INSERT INTO sanguj_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","તદા પિતરો યીશુમવાદીત્ હે ગુરોઽસ્માકમત્ર સ્થિતિરુત્તમા, તતએવ વયં ત્વત્કૃતે એકાં મૂસાકૃતે એકામ્ એલિયકૃતે ચૈકાં, એતાસ્તિસ્રઃ કુટી ર્નિર્મ્મામ| ");
INSERT INTO sanguj_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","કિન્તુ સ યદુક્તવાન્ તત્ સ્વયં ન બુબુધે તતઃ સર્વ્વે બિભયાઞ્ચક્રુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","એતર્હિ પયોદસ્તાન્ છાદયામાસ, મમયાં પ્રિયઃ પુત્રઃ કથાસુ તસ્ય મનાંસિ નિવેશયતેતિ નભોવાણી તન્મેદ્યાન્નિર્યયૌ| ");
INSERT INTO sanguj_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","અથ હઠાત્તે ચતુર્દિશો દૃષ્ટ્વા યીશું વિના સ્વૈઃ સહિતં કમપિ ન દદૃશુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","તતઃ પરં ગિરેરવરોહણકાલે સ તાન્ ગાઢમ્ દૂત્યાદિદેશ યાવન્નરસૂનોઃ શ્મશાનાદુત્થાનં ન ભવતિ, તાવત્ દર્શનસ્યાસ્ય વાર્ત્તા યુષ્માભિઃ કસ્મૈચિદપિ ન વક્તવ્યા| ");
INSERT INTO sanguj_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","તદા શ્મશાનાદુત્થાનસ્ય કોભિપ્રાય ઇતિ વિચાર્ય્ય તે તદ્વાક્યં સ્વેષુ ગોપાયાઞ્ચક્રિરે| ");
INSERT INTO sanguj_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","અથ તે યીશું પપ્રચ્છુઃ પ્રથમત એલિયેનાગન્તવ્યમ્ ઇતિ વાક્યં કુત ઉપાધ્યાયા આહુઃ? ");
INSERT INTO sanguj_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","તદા સ પ્રત્યુવાચ , એલિયઃ પ્રથમમેત્ય સર્વ્વકાર્ય્યાણિ સાધયિષ્યતિ; નરપુત્રે ચ લિપિ ર્યથાસ્તે તથૈવ સોપિ બહુદુઃખં પ્રાપ્યાવજ્ઞાસ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","કિન્ત્વહં યુષ્માન્ વદામિ , એલિયાર્થે લિપિ ર્યથાસ્તે તથૈવ સ એત્ય યયૌ, લોકા: સ્વેચ્છાનુરૂપં તમભિવ્યવહરન્તિ સ્મ| ");
INSERT INTO sanguj_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","અનન્તરં સ શિષ્યસમીપમેત્ય તેષાં ચતુઃપાર્શ્વે તૈઃ સહ બહુજનાન્ વિવદમાનાન્ અધ્યાપકાંશ્ચ દૃષ્ટવાન્; ");
INSERT INTO sanguj_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","કિન્તુ સર્વ્વલોકાસ્તં દૃષ્ટ્વૈવ ચમત્કૃત્ય તદાસન્નં ધાવન્તસ્તં પ્રણેમુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","તદા યીશુરધ્યાપકાનપ્રાક્ષીદ્ એતૈઃ સહ યૂયં કિં વિવદધ્વે? ");
INSERT INTO sanguj_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","તતો લોકાનાં કશ્ચિદેકઃ પ્રત્યવાદીત્ હે ગુરો મમ સૂનું મૂકં ભૂતધૃતઞ્ચ ભવદાસન્નમ્ આનયં| ");
INSERT INTO sanguj_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","યદાસૌ ભૂતસ્તમાક્રમતે તદૈવ પાતસતિ તથા સ ફેણાયતે, દન્તૈર્દન્તાન્ ઘર્ષતિ ક્ષીણો ભવતિ ચ; તતો હેતોસ્તં ભૂતં ત્યાજયિતું ભવચ્છિષ્યાન્ નિવેદિતવાન્ કિન્તુ તે ન શેકુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","તદા સ તમવાદીત્, રે અવિશ્વાસિનઃ સન્તાના યુષ્માભિઃ સહ કતિ કાલાનહં સ્થાસ્યામિ? અપરાન્ કતિ કાલાન્ વા વ આચારાન્ સહિષ્યે? તં મદાસન્નમાનયત| ");
INSERT INTO sanguj_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","તતસ્તત્સન્નિધિં સ આનીયત કિન્તુ તં દૃષ્ટ્વૈવ ભૂતો બાલકં ધૃતવાન્; સ ચ ભૂમૌ પતિત્વા ફેણાયમાનો લુલોઠ| ");
INSERT INTO sanguj_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","તદા સ તત્પિતરં પપ્રચ્છ, અસ્યેદૃશી દશા કતિ દિનાનિ ભૂતા? તતઃ સોવાદીત્ બાલ્યકાલાત્| ");
INSERT INTO sanguj_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","ભૂતોયં તં નાશયિતું બહુવારાન્ વહ્નૌ જલે ચ ન્યક્ષિપત્ કિન્તુ યદિ ભવાન કિમપિ કર્ત્તાં શક્નોતિ તર્હિ દયાં કૃત્વાસ્માન્ ઉપકરોતુ| ");
INSERT INTO sanguj_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","તદા યીશુસ્તમવદત્ યદિ પ્રત્યેતું શક્નોષિ તર્હિ પ્રત્યયિને જનાય સર્વ્વં સાધ્યમ્| ");
INSERT INTO sanguj_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","તતસ્તત્ક્ષણં તદ્બાલકસ્ય પિતા પ્રોચ્ચૈ રૂવન્ સાશ્રુનેત્રઃ પ્રોવાચ, પ્રભો પ્રત્યેમિ મમાપ્રત્યયં પ્રતિકુરુ| ");
INSERT INTO sanguj_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","અથ યીશુ ર્લોકસઙ્ઘં ધાવિત્વાયાન્તં દૃષ્ટ્વા તમપૂતભૂતં તર્જયિત્વા જગાદ, રે બધિર મૂક ભૂત ત્વમેતસ્માદ્ બહિર્ભવ પુનઃ કદાપિ માશ્રયૈનં ત્વામહમ્ ઇત્યાદિશામિ| ");
INSERT INTO sanguj_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","તદા સ ભૂતશ્ચીત્શબ્દં કૃત્વા તમાપીડ્ય બહિર્જજામ, તતો બાલકો મૃતકલ્પો બભૂવ તસ્માદયં મૃતઇત્યનેકે કથયામાસુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","કિન્તુ કરં ધૃત્વા યીશુનોત્થાપિતઃ સ ઉત્તસ્થૌ| ");
INSERT INTO sanguj_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","અથ યીશૌ ગૃહં પ્રવિષ્ટે શિષ્યા ગુપ્તં તં પપ્રચ્છુઃ, વયમેનં ભૂતં ત્યાજયિતું કુતો ન શક્તાઃ? ");
INSERT INTO sanguj_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","સ ઉવાચ, પ્રાર્થનોપવાસૌ વિના કેનાપ્યન્યેન કર્મ્મણા ભૂતમીદૃશં ત્યાજયિતું ન શક્યં| ");
INSERT INTO sanguj_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","અનન્તરં સ તત્સ્થાનાદિત્વા ગાલીલ્મધ્યેન યયૌ, કિન્તુ તત્ કોપિ જાનીયાદિતિ સ નૈચ્છત્| ");
INSERT INTO sanguj_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","અપરઞ્ચ સ શિષ્યાનુપદિશન્ બભાષે, નરપુત્રો નરહસ્તેષુ સમર્પયિષ્યતે તે ચ તં હનિષ્યન્તિ તૈસ્તસ્મિન્ હતે તૃતીયદિને સ ઉત્થાસ્યતીતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","કિન્તુ તત્કથાં તે નાબુધ્યન્ત પ્રષ્ટુઞ્ચ બિભ્યઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","અથ યીશુઃ કફર્નાહૂમ્પુરમાગત્ય મધ્યેગૃહઞ્ચેત્ય તાનપૃચ્છદ્ વર્ત્મમધ્યે યૂયમન્યોન્યં કિં વિવદધ્વે સ્મ? ");
INSERT INTO sanguj_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","કિન્તુ તે નિરુત્તરાસ્તસ્થુ ર્યસ્માત્તેષાં કો મુખ્ય ઇતિ વર્ત્માનિ તેઽન્યોન્યં વ્યવદન્ત| ");
INSERT INTO sanguj_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","તતઃ સ ઉપવિશ્ય દ્વાદશશિષ્યાન્ આહૂય બભાષે યઃ કશ્ચિત્ મુખ્યો ભવિતુમિચ્છતિ સ સર્વ્વેભ્યો ગૌણઃ સર્વ્વેષાં સેવકશ્ચ ભવતુ| ");
INSERT INTO sanguj_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","તદા સ બાલકમેકં ગૃહીત્વા મધ્યે સમુપાવેશયત્ તતસ્તં ક્રોડે કૃત્વા તાનવાદાત્ ");
INSERT INTO sanguj_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","યઃ કશ્ચિદીદૃશસ્ય કસ્યાપિ બાલસ્યાતિથ્યં કરોતિ સ મમાતિથ્યં કરોતિ; યઃ કશ્ચિન્મમાતિથ્યં કરોતિ સ કેવલમ્ મમાતિથ્યં કરોતિ તન્ન મત્પ્રેરકસ્યાપ્યાતિથ્યં કરોતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","અથ યોહન્ તમબ્રવીત્ હે ગુરો, અસ્માકમનનુગામિનમ્ એકં ત્વાન્નામ્ના ભૂતાન્ ત્યાજયન્તં વયં દૃષ્ટવન્તઃ, અસ્માકમપશ્ચાદ્ગામિત્વાચ્ચ તં ન્યષેધામ| ");
INSERT INTO sanguj_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","કિન્તુ યીશુરવદત્ તં મા નિષેધત્, યતો યઃ કશ્ચિન્ મન્નામ્ના ચિત્રં કર્મ્મ કરોતિ સ સહસા માં નિન્દિતું ન શક્નોતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","તથા યઃ કશ્ચિદ્ યુષ્માકં વિપક્ષતાં ન કરોતિ સ યુષ્માકમેવ સપક્ષઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","યઃ કશ્ચિદ્ યુષ્માન્ ખ્રીષ્ટશિષ્યાન્ જ્ઞાત્વા મન્નામ્ના કંસૈકેન પાનીયં પાતું દદાતિ, યુષ્માનહં યથાર્થં વચ્મિ, સ ફલેન વઞ્ચિતો ન ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","કિન્તુ યદિ કશ્ચિન્ મયિ વિશ્વાસિનામેષાં ક્ષુદ્રપ્રાણિનામ્ એકસ્યાપિ વિઘ્નં જનયતિ, તર્હિ તસ્યૈતત્કર્મ્મ કરણાત્ કણ્ઠબદ્ધપેષણીકસ્ય તસ્ય સાગરાગાધજલ મજ્જનં ભદ્રં| ");
INSERT INTO sanguj_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","અતઃ સ્વકરો યદિ ત્વાં બાધતે તર્હિ તં છિન્ધિ; ");
INSERT INTO sanguj_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","યસ્માત્ યત્ર કીટા ન મ્રિયન્તે વહ્નિશ્ચ ન નિર્વ્વાતિ, તસ્મિન્ અનિર્વ્વાણાનલનરકે કરદ્વયવસ્તવ ગમનાત્ કરહીનસ્ય સ્વર્ગપ્રવેશસ્તવ ક્ષેમં| ");
INSERT INTO sanguj_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","યદિ તવ પાદો વિઘ્નં જનયતિ તર્હિ તં છિન્ધિ, ");
INSERT INTO sanguj_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","યતો યત્ર કીટા ન મ્રિયન્તે વહ્નિશ્ચ ન નિર્વ્વાતિ, તસ્મિન્ ઽનિર્વ્વાણવહ્નૌ નરકે દ્વિપાદવતસ્તવ નિક્ષેપાત્ પાદહીનસ્ય સ્વર્ગપ્રવેશસ્તવ ક્ષેમં| ");
INSERT INTO sanguj_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","સ્વનેત્રં યદિ ત્વાં બાધતે તર્હિ તદપ્યુત્પાટય, યતો યત્ર કીટા ન મ્રિયન્તે વહ્નિશ્ચ ન નિર્વ્વાતિ, ");
INSERT INTO sanguj_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","તસ્મિન ઽનિર્વ્વાણવહ્નૌ નરકે દ્વિનેત્રસ્ય તવ નિક્ષેપાદ્ એકનેત્રવત ઈશ્વરરાજ્યે પ્રવેશસ્તવ ક્ષેમં| ");
INSERT INTO sanguj_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","યથા સર્વ્વો બલિ ર્લવણાક્તઃ ક્રિયતે તથા સર્વ્વો જનો વહ્નિરૂપેણ લવણાક્તઃ કારિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","લવણં ભદ્રં કિન્તુ યદિ લવણે સ્વાદુતા ન તિષ્ઠતિ, તર્હિ કથમ્ આસ્વાદ્યુક્તં કરિષ્યથ? યૂયં લવણયુક્તા ભવત પરસ્પરં પ્રેમ કુરુત| ");
INSERT INTO sanguj_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","અનન્તરં સ તત્સ્થાનાત્ પ્રસ્થાય યર્દ્દનનદ્યાઃ પારે યિહૂદાપ્રદેશ ઉપસ્થિતવાન્, તત્ર તદન્તિકે લોકાનાં સમાગમે જાતે સ નિજરીત્યનુસારેણ પુનસ્તાન્ ઉપદિદેશ| ");
INSERT INTO sanguj_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","તદા ફિરૂશિનસ્તત્સમીપમ્ એત્ય તં પરીક્ષિતું પપ્રચ્છઃ સ્વજાયા મનુજાનાં ત્યજ્યા ન વેતિ? ");
INSERT INTO sanguj_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","તતઃ સ પ્રત્યવાદીત્, અત્ર કાર્ય્યે મૂસા યુષ્માન્ પ્રતિ કિમાજ્ઞાપયત્? ");
INSERT INTO sanguj_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ત ઊચુઃ ત્યાગપત્રં લેખિતું સ્વપત્નીં ત્યક્તુઞ્ચ મૂસાઽનુમન્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","તદા યીશુઃ પ્રત્યુવાચ, યુષ્માકં મનસાં કાઠિન્યાદ્ધેતો ર્મૂસા નિદેશમિમમ્ અલિખત્| ");
INSERT INTO sanguj_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","કિન્તુ સૃષ્ટેરાદૌ ઈશ્વરો નરાન્ પુંરૂપેણ સ્ત્રીરૂપેણ ચ સસર્જ| ");
INSERT INTO sanguj_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","\"તતઃ કારણાત્ પુમાન્ પિતરં માતરઞ્ચ ત્યક્ત્વા સ્વજાયાયામ્ આસક્તો ભવિષ્યતિ, ");
INSERT INTO sanguj_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","તૌ દ્વાવ્ એકાઙ્ગૌ ભવિષ્યતઃ| \" તસ્માત્ તત્કાલમારભ્ય તૌ ન દ્વાવ્ એકાઙ્ગૌ| ");
INSERT INTO sanguj_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","અતઃ કારણાદ્ ઈશ્વરો યદયોજયત્ કોપિ નરસ્તન્ન વિયેજયેત્| ");
INSERT INTO sanguj_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","અથ યીશુ ર્ગૃહં પ્રવિષ્ટસ્તદા શિષ્યાઃ પુનસ્તત્કથાં તં પપ્રચ્છુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","તતઃ સોવદત્ કશ્ચિદ્ યદિ સ્વભાર્ય્યાં ત્યક્તવાન્યામ્ ઉદ્વહતિ તર્હિ સ સ્વભાર્ય્યાયાઃ પ્રાતિકૂલ્યેન વ્યભિચારી ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","કાચિન્નારી યદિ સ્વપતિં હિત્વાન્યપુંસા વિવાહિતા ભવતિ તર્હિ સાપિ વ્યભિચારિણી ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","અથ સ યથા શિશૂન્ સ્પૃશેત્, તદર્થં લોકૈસ્તદન્તિકં શિશવ આનીયન્ત, કિન્તુ શિષ્યાસ્તાનાનીતવતસ્તર્જયામાસુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","યીશુસ્તદ્ દૃષ્ટ્વા ક્રુધ્યન્ જગાદ, મન્નિકટમ્ આગન્તું શિશૂન્ મા વારયત, યત એતાદૃશા ઈશ્વરરાજ્યાધિકારિણઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","યુષ્માનહં યથાર્થં વચ્મિ, યઃ કશ્ચિત્ શિશુવદ્ ભૂત્વા રાજ્યમીશ્વરસ્ય ન ગૃહ્લીયાત્ સ કદાપિ તદ્રાજ્યં પ્રવેષ્ટું ન શક્નોતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","અનનતરં સ શિશૂનઙ્કે નિધાય તેષાં ગાત્રેષુ હસ્તૌ દત્ત્વાશિષં બભાષે| ");
INSERT INTO sanguj_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","અથ સ વર્ત્મના યાતિ, એતર્હિ જન એકો ધાવન્ આગત્ય તત્સમ્મુખે જાનુની પાતયિત્વા પૃષ્ટવાન્, ભોઃ પરમગુરો, અનન્તાયુઃ પ્રાપ્તયે મયા કિં કર્ત્તવ્યં? ");
INSERT INTO sanguj_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","તદા યીશુરુવાચ, માં પરમં કુતો વદસિ? વિનેશ્વરં કોપિ પરમો ન ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","પરસ્ત્રીં નાભિગચ્છ; નરં મા ઘાતય; સ્તેયં મા કુરુ; મૃષાસાક્ષ્યં મા દેહિ; હિંસાઞ્ચ મા કુરુ; પિતરૌ સમ્મન્યસ્વ; નિદેશા એતે ત્વયા જ્ઞાતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","તતસ્તન પ્રત્યુક્તં, હે ગુરો બાલ્યકાલાદહં સર્વ્વાનેતાન્ આચરામિ| ");
INSERT INTO sanguj_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","તદા યીશુસ્તં વિલોક્ય સ્નેહેન બભાષે, તવૈકસ્યાભાવ આસ્તે; ત્વં ગત્વા સર્વ્વસ્વં વિક્રીય દરિદ્રેભ્યો વિશ્રાણય, તતઃ સ્વર્ગે ધનં પ્રાપ્સ્યસિ; તતઃ પરમ્ એત્ય ક્રુશં વહન્ મદનુવર્ત્તી ભવ| ");
INSERT INTO sanguj_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","કિન્તુ તસ્ય બહુસમ્પદ્વિદ્યમાનત્વાત્ સ ઇમાં કથામાકર્ણ્ય વિષણો દુઃખિતશ્ચ સન્ જગામ| ");
INSERT INTO sanguj_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","અથ યીશુશ્ચતુર્દિશો નિરીક્ષ્ય શિષ્યાન્ અવાદીત્, ધનિલોકાનામ્ ઈશ્વરરાજ્યપ્રવેશઃ કીદૃગ્ દુષ્કરઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","તસ્ય કથાતઃ શિષ્યાશ્ચમચ્ચક્રુઃ, કિન્તુ સ પુનરવદત્, હે બાલકા યે ધને વિશ્વસન્તિ તેષામ્ ઈશ્વરરાજ્યપ્રવેશઃ કીદૃગ્ દુષ્કરઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ઈશ્વરરાજ્યે ધનિનાં પ્રવેશાત્ સૂચિરન્ધ્રેણ મહાઙ્ગસ્ય ગમનાગમનં સુકરં| ");
INSERT INTO sanguj_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","તદા શિષ્યા અતીવ વિસ્મિતાઃ પરસ્પરં પ્રોચુઃ, તર્હિ કઃ પરિત્રાણં પ્રાપ્તું શક્નોતિ? ");
INSERT INTO sanguj_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","તતો યીશુસ્તાન્ વિલોક્ય બભાષે, તન્ નરસ્યાસાધ્યં કિન્તુ નેશ્વરસ્ય, યતો હેતોરીશ્વરસ્ય સર્વ્વં સાધ્યમ્| ");
INSERT INTO sanguj_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","તદા પિતર ઉવાચ, પશ્ય વયં સર્વ્વં પરિત્યજ્ય ભવતોનુગામિનો જાતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","તતો યીશુઃ પ્રત્યવદત્, યુષ્માનહં યથાર્થં વદામિ, મદર્થં સુસંવાદાર્થં વા યો જનઃ સદનં ભ્રાતરં ભગિનીં પિતરં માતરં જાયાં સન્તાનાન્ ભૂમિ વા ત્યક્ત્વા ");
INSERT INTO sanguj_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ગૃહભ્રાતૃભગિનીપિતૃમાતૃપત્નીસન્તાનભૂમીનામિહ શતગુણાન્ પ્રેત્યાનન્તાયુશ્ચ ન પ્રાપ્નોતિ તાદૃશઃ કોપિ નાસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","કિન્ત્વગ્રીયા અનેકે લોકાઃ શેષાઃ, શેષીયા અનેકે લોકાશ્ચાગ્રા ભવિષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","અથ યિરૂશાલમ્યાનકાલે યીશુસ્તેષામ્ અગ્રગામી બભૂવ, તસ્માત્તે ચિત્રં જ્ઞાત્વા પશ્ચાદ્ગામિનો ભૂત્વા બિભ્યુઃ| તદા સ પુન ર્દ્વાદશશિષ્યાન્ ગૃહીત્વા સ્વીયં યદ્યદ્ ઘટિષ્યતે તત્તત્ તેભ્યઃ કથયિતું પ્રારેભે; ");
INSERT INTO sanguj_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","પશ્યત વયં યિરૂશાલમ્પુરં યામઃ, તત્ર મનુષ્યપુત્રઃ પ્રધાનયાજકાનામ્ ઉપાધ્યાયાનાઞ્ચ કરેષુ સમર્પયિષ્યતે; તે ચ વધદણ્ડાજ્ઞાં દાપયિત્વા પરદેશીયાનાં કરેષુ તં સમર્પયિષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","તે તમુપહસ્ય કશયા પ્રહૃત્ય તદ્વપુષિ નિષ્ઠીવં નિક્ષિપ્ય તં હનિષ્યન્તિ, તતઃ સ તૃતીયદિને પ્રોત્થાસ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","તતઃ સિવદેઃ પુત્રૌ યાકૂબ્યોહનૌ તદન્તિકમ્ એત્ય પ્રોચતુઃ, હે ગુરો યદ્ આવાભ્યાં યાચિષ્યતે તદસ્મદર્થં ભવાન્ કરોતુ નિવેદનમિદમાવયોઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","તતઃ સ કથિતવાન્, યુવાં કિમિચ્છથઃ? કિં મયા યુષ્મદર્થં કરણીયં? ");
INSERT INTO sanguj_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","તદા તૌ પ્રોચતુઃ, આવયોરેકં દક્ષિણપાર્શ્વે વામપાર્શ્વે ચૈકં તવૈશ્વર્ય્યપદે સમુપવેષ્ટુમ્ આજ્ઞાપય| ");
INSERT INTO sanguj_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","કિન્તુ યીશુઃ પ્રત્યુવાચ યુવામજ્ઞાત્વેદં પ્રાર્થયેથે, યેન કંસેનાહં પાસ્યામિ તેન યુવાભ્યાં કિં પાતું શક્ષ્યતે? યસ્મિન્ મજ્જનેનાહં મજ્જિષ્યે તન્મજ્જને મજ્જયિતું કિં યુવાભ્યાં શક્ષ્યતે? તૌ પ્રત્યૂચતુઃ શક્ષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","તદા યીશુરવદત્ યેન કંસેનાહં પાસ્યામિ તેનાવશ્યં યુવામપિ પાસ્યથઃ, યેન મજ્જનેન ચાહં મજ્જિય્યે તત્ર યુવામપિ મજ્જિષ્યેથે| ");
INSERT INTO sanguj_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","કિન્તુ યેષામર્થમ્ ઇદં નિરૂપિતં, તાન્ વિહાયાન્યં કમપિ મમ દક્ષિણપાર્શ્વે વામપાર્શ્વે વા સમુપવેશયિતું મમાધિકારો નાસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","અથાન્યદશશિષ્યા ઇમાં કથાં શ્રુત્વા યાકૂબ્યોહન્ભ્યાં ચુકુપુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","કિન્તુ યીશુસ્તાન્ સમાહૂય બભાષે, અન્યદેશીયાનાં રાજત્વં યે કુર્વ્વન્તિ તે તેષામેવ પ્રભુત્વં કુર્વ્વન્તિ, તથા યે મહાલોકાસ્તે તેષામ્ અધિપતિત્વં કુર્વ્વન્તીતિ યૂયં જાનીથ| ");
INSERT INTO sanguj_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","કિન્તુ યુષ્માકં મધ્યે ન તથા ભવિષ્યતિ, યુષ્માકં મધ્યે યઃ પ્રાધાન્યં વાઞ્છતિ સ યુષ્માકં સેવકો ભવિષ્યતિ, ");
INSERT INTO sanguj_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","યુષ્માકં યો મહાન્ ભવિતુમિચ્છતિ સ સર્વ્વેષાં કિઙ્કરો ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","યતો મનુષ્યપુત્રઃ સેવ્યો ભવિતું નાગતઃ સેવાં કર્ત્તાં તથાનેકેષાં પરિત્રાણસ્ય મૂલ્યરૂપસ્વપ્રાણં દાતુઞ્ચાગતઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","અથ તે યિરીહોનગરં પ્રાપ્તાસ્તસ્માત્ શિષ્યૈ ર્લોકૈશ્ચ સહ યીશો ર્ગમનકાલે ટીમયસ્ય પુત્રો બર્ટીમયનામા અન્ધસ્તન્માર્ગપાર્શ્વે ભિક્ષાર્થમ્ ઉપવિષ્ટઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","સ નાસરતીયસ્ય યીશોરાગમનવાર્ત્તાં પ્રાપ્ય પ્રોચૈ ર્વક્તુમારેભે, હે યીશો દાયૂદઃ સન્તાન માં દયસ્વ| ");
INSERT INTO sanguj_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","તતોનેકે લોકા મૌનીભવેતિ તં તર્જયામાસુઃ, કિન્તુ સ પુનરધિકમુચ્ચૈ ર્જગાદ, હે યીશો દાયૂદઃ સન્તાન માં દયસ્વ| ");
INSERT INTO sanguj_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","તદા યીશુઃ સ્થિત્વા તમાહ્વાતું સમાદિદેશ, તતો લોકાસ્તમન્ધમાહૂય બભાષિરે, હે નર, સ્થિરો ભવ, ઉત્તિષ્ઠ, સ ત્વામાહ્વયતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","તદા સ ઉત્તરીયવસ્ત્રં નિક્ષિપ્ય પ્રોત્થાય યીશોઃ સમીપં ગતઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","તતો યીશુસ્તમવદત્ ત્વયા કિં પ્રાર્થ્યતે? તુભ્યમહં કિં કરિષ્યામી? તદા સોન્ધસ્તમુવાચ, હે ગુરો મદીયા દૃષ્ટિર્ભવેત્| ");
INSERT INTO sanguj_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","તતો યીશુસ્તમુવાચ યાહિ તવ વિશ્વાસસ્ત્વાં સ્વસ્થમકાર્ષીત્, તસ્માત્ તત્ક્ષણં સ દૃષ્ટિં પ્રાપ્ય પથા યીશોઃ પશ્ચાદ્ યયૌ| ");
INSERT INTO sanguj_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","અનન્તરં તેષુ યિરૂશાલમઃ સમીપસ્થયો ર્બૈત્ફગીબૈથનીયપુરયોરન્તિકસ્થં જૈતુનનામાદ્રિમાગતેષુ યીશુઃ પ્રેષણકાલે દ્વૌ શિષ્યાવિદં વાક્યં જગાદ, ");
INSERT INTO sanguj_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","યુવામમું સમ્મુખસ્થં ગ્રામં યાતં, તત્ર પ્રવિશ્ય યો નરં નાવહત્ તં ગર્દ્દભશાવકં દ્રક્ષ્યથસ્તં મોચયિત્વાનયતં| ");
INSERT INTO sanguj_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","કિન્તુ યુવાં કર્મ્મેદં કુતઃ કુરુથઃ? કથામિમાં યદિ કોપિ પૃચ્છતિ તર્હિ પ્રભોરત્ર પ્રયોજનમસ્તીતિ કથિતે સ શીઘ્રં તમત્ર પ્રેષયિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","તતસ્તૌ ગત્વા દ્વિમાર્ગમેલને કસ્યચિદ્ દ્વારસ્ય પાર્શ્વે તં ગર્દ્દભશાવકં પ્રાપ્ય મોચયતઃ, ");
INSERT INTO sanguj_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","એતર્હિ તત્રોપસ્થિતલોકાનાં કશ્ચિદ્ અપૃચ્છત્, ગર્દ્દભશિશું કુતો મોચયથઃ? ");
INSERT INTO sanguj_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","તદા યીશોરાજ્ઞાનુસારેણ તેભ્યઃ પ્રત્યુદિતે તત્ક્ષણં તમાદાતું તેઽનુજજ્ઞુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","અથ તૌ યીશોઃ સન્નિધિં ગર્દ્દભશિશુમ્ આનીય તદુપરિ સ્વવસ્ત્રાણિ પાતયામાસતુઃ; તતઃ સ તદુપરિ સમુપવિષ્ટઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","તદાનેકે પથિ સ્વવાસાંસિ પાતયામાસુઃ, પરૈશ્ચ તરુશાખાશ્છિતવા માર્ગે વિકીર્ણાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","અપરઞ્ચ પશ્ચાદ્ગામિનોઽગ્રગામિનશ્ચ સર્વ્વે જના ઉચૈઃસ્વરેણ વક્તુમારેભિરે, જય જય યઃ પરમેશ્વરસ્ય નામ્નાગચ્છતિ સ ધન્ય ઇતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","તથાસ્માકમં પૂર્વ્વપુરુષસ્ય દાયૂદો યદ્રાજ્યં પરમેશ્વરનામ્નાયાતિ તદપિ ધન્યં, સર્વ્વસ્માદુચ્છ્રાયે સ્વર્ગે ઈશ્વરસ્ય જયો ભવેત્| ");
INSERT INTO sanguj_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ઇત્થં યીશુ ર્યિરૂશાલમિ મન્દિરં પ્રવિશ્ય ચતુર્દિક્સ્થાનિ સર્વ્વાણિ વસ્તૂનિ દૃષ્ટવાન્; અથ સાયંકાલ ઉપસ્થિતે દ્વાદશશિષ્યસહિતો બૈથનિયં જગામ| ");
INSERT INTO sanguj_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","અપરેહનિ બૈથનિયાદ્ આગમનસમયે ક્ષુધાર્ત્તો બભૂવ| ");
INSERT INTO sanguj_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","તતો દૂરે સપત્રમુડુમ્બરપાદપં વિલોક્ય તત્ર કિઞ્ચિત્ ફલં પ્રાપ્તું તસ્ય સન્નિકૃષ્ટં યયૌ, તદાનીં ફલપાતનસ્ય સમયો નાગચ્છતિ| તતસ્તત્રોપસ્થિતઃ પત્રાણિ વિના કિમપ્યપરં ન પ્રાપ્ય સ કથિતવાન્, ");
INSERT INTO sanguj_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","અદ્યારભ્ય કોપિ માનવસ્ત્વત્તઃ ફલં ન ભુઞ્જીત; ઇમાં કથાં તસ્ય શિષ્યાઃ શુશ્રુવુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","તદનન્તરં તેષુ યિરૂશાલમમાયાતેષુ યીશુ ર્મન્દિરં ગત્વા તત્રસ્થાનાં બણિજાં મુદ્રાસનાનિ પારાવતવિક્રેતૃણામ્ આસનાનિ ચ ન્યુબ્જયાઞ્ચકાર સર્વ્વાન્ ક્રેતૃન્ વિક્રેતૃંશ્ચ બહિશ્ચકાર| ");
INSERT INTO sanguj_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","અપરં મન્દિરમધ્યેન કિમપિ પાત્રં વોઢું સર્વ્વજનં નિવારયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","લોકાનુપદિશન્ જગાદ, મમ ગૃહં સર્વ્વજાતીયાનાં પ્રાર્થનાગૃહમ્ ઇતિ નામ્ના પ્રથિતં ભવિષ્યતિ એતત્ કિં શાસ્ત્રે લિખિતં નાસ્તિ? કિન્તુ યૂયં તદેવ ચોરાણાં ગહ્વરં કુરુથ| ");
INSERT INTO sanguj_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ઇમાં વાણીં શ્રુત્વાધ્યાપકાઃ પ્રધાનયાજકાશ્ચ તં યથા નાશયિતું શક્નુવન્તિ તથોेપાયં મૃગયામાસુઃ, કિન્તુ તસ્યોપદેશાત્ સર્વ્વે લોકા વિસ્મયં ગતા અતસ્તે તસ્માદ્ બિભ્યુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","અથ સાયંસમય ઉપસ્થિતે યીશુર્નગરાદ્ બહિર્વવ્રાજ| ");
INSERT INTO sanguj_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","અનન્તરં પ્રાતઃકાલે તે તેન માર્ગેણ ગચ્છન્તસ્તમુડુમ્બરમહીરુહં સમૂલં શુષ્કં દદૃશુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","તતઃ પિતરઃ પૂર્વ્વવાક્યં સ્મરન્ યીશું બભાષં, હે ગુરો પશ્યતુ ય ઉડુમ્બરવિટપી ભવતા શપ્તઃ સ શુષ્કો બભૂવ| ");
INSERT INTO sanguj_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","તતો યીશુઃ પ્રત્યવાદીત્, યૂયમીશ્વરે વિશ્વસિત| ");
INSERT INTO sanguj_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","યુષ્માનહં યથાર્થં વદામિ કોપિ યદ્યેતદ્ગિરિં વદતિ, ત્વમુત્થાય ગત્વા જલધૌ પત, પ્રોક્તમિદં વાક્યમવશ્યં ઘટિષ્યતે, મનસા કિમપિ ન સન્દિહ્ય ચેદિદં વિશ્વસેત્ તર્હિ તસ્ય વાક્યાનુસારેણ તદ્ ઘટિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","અતો હેતોરહં યુષ્માન્ વચ્મિ, પ્રાર્થનાકાલે યદ્યદાકાંક્ષિષ્યધ્વે તત્તદવશ્યં પ્રાપ્સ્યથ, ઇત્થં વિશ્વસિત, તતઃ પ્રાપ્સ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","અપરઞ્ચ યુષ્માસુ પ્રાર્થયિતું સમુત્થિતેષુ યદિ કોપિ યુષ્માકમ્ અપરાધી તિષ્ઠતિ, તર્હિ તં ક્ષમધ્વં, તથા કૃતે યુષ્માકં સ્વર્ગસ્થઃ પિતાપિ યુષ્માકમાગાંમિ ક્ષમિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","કિન્તુ યદિ ન ક્ષમધ્વે તર્હિ વઃ સ્વર્ગસ્થઃ પિતાપિ યુષ્માકમાગાંસિ ન ક્ષમિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","અનન્તરં તે પુન ર્યિરૂશાલમં પ્રવિવિશુઃ, યીશુ ર્યદા મધ્યેમન્દિરમ્ ઇતસ્તતો ગચ્છતિ, તદાનીં પ્રધાનયાજકા ઉપાધ્યાયાઃ પ્રાઞ્ચશ્ચ તદન્તિકમેત્ય કથામિમાં પપ્રચ્છુઃ, ");
INSERT INTO sanguj_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ત્વં કેનાદેશેન કર્મ્માણ્યેતાનિ કરોષિ? તથૈતાનિ કર્મ્માણિ કર્ત્તાં કેનાદિષ્ટોસિ? ");
INSERT INTO sanguj_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","તતો યીશુઃ પ્રતિગદિતવાન્ અહમપિ યુષ્માન્ એકકથાં પૃચ્છામિ, યદિ યૂયં તસ્યા ઉત્તરં કુરુથ, તર્હિ કયાજ્ઞયાહં કર્મ્માણ્યેતાનિ કરોમિ તદ્ યુષ્મભ્યં કથયિષ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","યોહનો મજ્જનમ્ ઈશ્વરાત્ જાતં કિં માનવાત્? તન્મહ્યં કથયત| ");
INSERT INTO sanguj_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","તે પરસ્પરં વિવેક્તું પ્રારેભિરે, તદ્ ઈશ્વરાદ્ બભૂવેતિ ચેદ્ વદામસ્તર્હિ કુતસ્તં ન પ્રત્યૈત? કથમેતાં કથયિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","માનવાદ્ અભવદિતિ ચેદ્ વદામસ્તર્હિ લોકેભ્યો ભયમસ્તિ યતો હેતોઃ સર્વ્વે યોહનં સત્યં ભવિષ્યદ્વાદિનં મન્યન્તે| ");
INSERT INTO sanguj_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","અતએવ તે યીશું પ્રત્યવાદિષુ ર્વયં તદ્ વક્તું ન શક્નુમઃ| યીશુરુવાચ, તર્હિ યેનાદેશેન કર્મ્માણ્યેતાનિ કરોમિ, અહમપિ યુષ્મભ્યં તન્ન કથયિષ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","અનન્તરં યીશુ ર્દૃષ્ટાન્તેન તેભ્યઃ કથયિતુમારેભે, કશ્ચિદેકો દ્રાક્ષાક્ષેત્રં વિધાય તચ્ચતુર્દિક્ષુ વારણીં કૃત્વા તન્મધ્યે દ્રાક્ષાપેષણકુણ્ડમ્ અખનત્, તથા તસ્ય ગડમપિ નિર્મ્મિતવાન્ તતસ્તત્ક્ષેત્રં કૃષીવલેષુ સમર્પ્ય દૂરદેશં જગામ| ");
INSERT INTO sanguj_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","તદનન્તરં ફલકાલે કૃષીવલેભ્યો દ્રાક્ષાક્ષેત્રફલાનિ પ્રાપ્તું તેષાં સવિધે ભૃત્યમ્ એકં પ્રાહિણોત્| ");
INSERT INTO sanguj_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","કિન્તુ કૃષીવલાસ્તં ધૃત્વા પ્રહૃત્ય રિક્તહસ્તં વિસસૃજુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","તતઃ સ પુનરન્યમેકં ભૃત્યં પ્રષયામાસ, કિન્તુ તે કૃષીવલાઃ પાષાણાઘાતૈસ્તસ્ય શિરો ભઙ્ક્ત્વા સાપમાનં તં વ્યસર્જન્| ");
INSERT INTO sanguj_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","તતઃ પરં સોપરં દાસં પ્રાહિણોત્ તદા તે તં જઘ્નુઃ, એવમ્ અનેકેષાં કસ્યચિત્ પ્રહારઃ કસ્યચિદ્ વધશ્ચ તૈઃ કૃતઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","તતઃ પરં મયા સ્વપુત્રે પ્રહિતે તે તમવશ્યં સમ્મંસ્યન્તે, ઇત્યુક્ત્વાવશેષે તેષાં સન્નિધૌ નિજપ્રિયમ્ અદ્વિતીયં પુત્રં પ્રેષયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","કિન્તુ કૃષીવલાઃ પરસ્પરં જગદુઃ, એષ ઉત્તરાધિકારી, આગચ્છત વયમેનં હન્મસ્તથા કૃતે ઽધિકારોયમ્ અસ્માકં ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","તતસ્તં ધૃત્વા હત્વા દ્રાક્ષાક્ષેત્રાદ્ બહિઃ પ્રાક્ષિપન્| ");
INSERT INTO sanguj_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","અનેનાસૌ દ્રાક્ષાક્ષેત્રપતિઃ કિં કરિષ્યતિ? સ એત્ય તાન્ કૃષીવલાન્ સંહત્ય તત્ક્ષેત્રમ્ અન્યેષુ કૃષીવલેષુ સમર્પયિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","અપરઞ્ચ, \"સ્થપતયઃ કરિષ્યન્તિ ગ્રાવાણં યન્તુ તુચ્છકં| પ્રાધાનપ્રસ્તરઃ કોણે સ એવ સંભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","એતત્ કર્મ્મ પરેશસ્યાંદ્ભુતં નો દૃષ્ટિતો ભવેત્|| \" ઇમાં શાસ્ત્રીયાં લિપિં યૂયં કિં નાપાઠિષ્ટ? ");
INSERT INTO sanguj_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","તદાનીં સ તાનુદ્દિશ્ય તાં દૃષ્ટાન્તકથાં કથિતવાન્, ત ઇત્થં બુદ્વ્વા તં ધર્ત્તામુદ્યતાઃ, કિન્તુ લોકેભ્યો બિભ્યુઃ, તદનન્તરં તે તં વિહાય વવ્રજુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","અપરઞ્ચ તે તસ્ય વાક્યદોષં ધર્ત્તાં કતિપયાન્ ફિરૂશિનો હેરોદીયાંશ્ચ લોકાન્ તદન્તિકં પ્રેષયામાસુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ત આગત્ય તમવદન્, હે ગુરો ભવાન્ તથ્યભાષી કસ્યાપ્યનુરોધં ન મન્યતે, પક્ષપાતઞ્ચ ન કરોતિ, યથાર્થત ઈશ્વરીયં માર્ગં દર્શયતિ વયમેતત્ પ્રજાનીમઃ, કૈસરાય કરો દેયો ન વાં? વયં દાસ્યામો ન વા? ");
INSERT INTO sanguj_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","કિન્તુ સ તેષાં કપટં જ્ઞાત્વા જગાદ, કુતો માં પરીક્ષધ્વે? એકં મુદ્રાપાદં સમાનીય માં દર્શયત| ");
INSERT INTO sanguj_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","તદા તૈરેકસ્મિન્ મુદ્રાપાદે સમાનીતે સ તાન્ પપ્રચ્છ, અત્ર લિખિતં નામ મૂર્ત્તિ ર્વા કસ્ય? તે પ્રત્યૂચુઃ, કૈસરસ્ય| ");
INSERT INTO sanguj_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","તદા યીશુરવદત્ તર્હિ કૈસરસ્ય દ્રવ્યાણિ કૈસરાય દત્ત, ઈશ્વરસ્ય દ્રવ્યાણિ તુ ઈશ્વરાય દત્ત; તતસ્તે વિસ્મયં મેનિરે| ");
INSERT INTO sanguj_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","અથ મૃતાનામુત્થાનં યે ન મન્યન્તે તે સિદૂકિનો યીશોઃ સમીપમાગત્ય તં પપ્રચ્છુઃ; ");
INSERT INTO sanguj_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","હે ગુરો કશ્ચિજ્જનો યદિ નિઃસન્તતિઃ સન્ ભાર્ય્યાયાં સત્યાં મ્રિયતે તર્હિ તસ્ય ભ્રાતા તસ્ય ભાર્ય્યાં ગૃહીત્વા ભ્રાતુ ર્વંશોત્પત્તિં કરિષ્યતિ, વ્યવસ્થામિમાં મૂસા અસ્માન્ પ્રતિ વ્યલિખત્| ");
INSERT INTO sanguj_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","કિન્તુ કેચિત્ સપ્ત ભ્રાતર આસન્, તતસ્તેષાં જ્યેષ્ઠભ્રાતા વિવહ્ય નિઃસન્તતિઃ સન્ અમ્રિયત| ");
INSERT INTO sanguj_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","તતો દ્વિતીયો ભ્રાતા તાં સ્ત્રિયમગૃહણત્ કિન્તુ સોપિ નિઃસન્તતિઃ સન્ અમ્રિયત; અથ તૃતીયોપિ ભ્રાતા તાદૃશોભવત્| ");
INSERT INTO sanguj_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ઇત્થં સપ્તૈવ ભ્રાતરસ્તાં સ્ત્રિયં ગૃહીત્વા નિઃસન્તાનાઃ સન્તોઽમ્રિયન્ત, સર્વ્વશેષે સાપિ સ્ત્રી મ્રિયતે સ્મ| ");
INSERT INTO sanguj_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","અથ મૃતાનામુત્થાનકાલે યદા ત ઉત્થાસ્યન્તિ તદા તેષાં કસ્ય ભાર્ય્યા સા ભવિષ્યતિ? યતસ્તે સપ્તૈવ તાં વ્યવહન્| ");
INSERT INTO sanguj_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","તતો યીશુઃ પ્રત્યુવાચ શાસ્ત્રમ્ ઈશ્વરશક્તિઞ્ચ યૂયમજ્ઞાત્વા કિમભ્રામ્યત ન? ");
INSERT INTO sanguj_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","મૃતલોકાનામુત્થાનં સતિ તે ન વિવહન્તિ વાગ્દત્તા અપિ ન ભવન્તિ, કિન્તુ સ્વર્ગીયદૂતાનાં સદૃશા ભવન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","પુનશ્ચ \"અહમ્ ઇબ્રાહીમ ઈશ્વર ઇસ્હાક ઈશ્વરો યાકૂબશ્ચેશ્વરઃ\" યામિમાં કથાં સ્તમ્બમધ્યે તિષ્ઠન્ ઈશ્વરો મૂસામવાદીત્ મૃતાનામુત્થાનાર્થે સા કથા મૂસાલિખિતે પુસ્તકે કિં યુષ્માભિ ર્નાપાઠિ? ");
INSERT INTO sanguj_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ઈશ્વરો જીવતાં પ્રભુઃ કિન્તુ મૃતાનાં પ્રભુ ર્ન ભવતિ, તસ્માદ્ધેતો ર્યૂયં મહાભ્રમેણ તિષ્ઠથ| ");
INSERT INTO sanguj_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","એતર્હિ એકોધ્યાપક એત્ય તેષામિત્થં વિચારં શુશ્રાવ; યીશુસ્તેષાં વાક્યસ્ય સદુત્તરં દત્તવાન્ ઇતિ બુદ્વ્વા તં પૃષ્ટવાન્ સર્વ્વાસામ્ આજ્ઞાનાં કા શ્રેષ્ઠા? તતો યીશુઃ પ્રત્યુવાચ, ");
INSERT INTO sanguj_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","\"હે ઇસ્રાયેલ્લોકા અવધત્ત, અસ્માકં પ્રભુઃ પરમેશ્વર એક એવ, ");
INSERT INTO sanguj_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","યૂયં સર્વ્વન્તઃકરણૈઃ સર્વ્વપ્રાણૈઃ સર્વ્વચિત્તૈઃ સર્વ્વશક્તિભિશ્ચ તસ્મિન્ પ્રભૌ પરમેશ્વરે પ્રીયધ્વં,\" ઇત્યાજ્ઞા શ્રેષ્ઠા| ");
INSERT INTO sanguj_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","તથા \"સ્વપ્રતિવાસિનિ સ્વવત્ પ્રેમ કુરુધ્વં,\" એષા યા દ્વિતીયાજ્ઞા સા તાદૃશી; એતાભ્યાં દ્વાભ્યામ્ આજ્ઞાભ્યામ્ અન્યા કાપ્યાજ્ઞા શ્રેષ્ઠા નાસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","તદા સોધ્યાપકસ્તમવદત્, હે ગુરો સત્યં ભવાન્ યથાર્થં પ્રોક્તવાન્ યત એકસ્માદ્ ઈશ્વરાદ્ અન્યો દ્વિતીય ઈશ્વરો નાસ્તિ; ");
INSERT INTO sanguj_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","અપરં સર્વ્વાન્તઃકરણૈઃ સર્વ્વપ્રાણૈઃ સર્વ્વચિત્તૈઃ સર્વ્વશક્તિભિશ્ચ ઈશ્વરે પ્રેમકરણં તથા સ્વમીપવાસિનિ સ્વવત્ પ્રેમકરણઞ્ચ સર્વ્વેભ્યો હોમબલિદાનાદિભ્યઃ શ્રષ્ઠં ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","તતો યીશુઃ સુબુદ્ધેરિવ તસ્યેદમ્ ઉત્તરં શ્રુત્વા તં ભાષિતવાન્ ત્વમીશ્વરસ્ય રાજ્યાન્ન દૂરોસિ| ઇતઃ પરં તેન સહ કસ્યાપિ વાક્યસ્ય વિચારં કર્ત્તાં કસ્યાપિ પ્રગલ્ભતા ન જાતા| ");
INSERT INTO sanguj_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","અનન્તરં મધ્યેમન્દિરમ્ ઉપદિશન્ યીશુરિમં પ્રશ્નં ચકાર, અધ્યાપકા અભિષિક્તં (તારકં) કુતો દાયૂદઃ સન્તાનં વદન્તિ? ");
INSERT INTO sanguj_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","સ્વયં દાયૂદ્ પવિત્રસ્યાત્મન આવેશેનેદં કથયામાસ| યથા| \"મમ પ્રભુમિદં વાક્યવદત્ પરમેશ્વરઃ| તવ શત્રૂનહં યાવત્ પાદપીઠં કરોમિ ન| તાવત્ કાલં મદીયે ત્વં દક્ષપાર્શ્વ્ ઉપાવિશ| \" ");
INSERT INTO sanguj_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","યદિ દાયૂદ્ તં પ્રભૂં વદતિ તર્હિ કથં સ તસ્ય સન્તાનો ભવિતુમર્હતિ? ઇતરે લોકાસ્તત્કથાં શ્રુત્વાનનન્દુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","તદાનીં સ તાનુપદિશ્ય કથિતવાન્ યે નરા દીર્ઘપરિધેયાનિ હટ્ટે વિપનૌ ચ ");
INSERT INTO sanguj_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","લોકકૃતનમસ્કારાન્ ભજનગૃહે પ્રધાનાસનાનિ ભોજનકાલે પ્રધાનસ્થાનાનિ ચ કાઙ્ક્ષન્તે; ");
INSERT INTO sanguj_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","વિધવાનાં સર્વ્વસ્વં ગ્રસિત્વા છલાદ્ દીર્ઘકાલં પ્રાર્થયન્તે તેભ્ય ઉપાધ્યાયેભ્યઃ સાવધાના ભવત; તેઽધિકતરાન્ દણ્ડાન્ પ્રાપ્સ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","તદનન્તરં લોકા ભાણ્ડાગારે મુદ્રા યથા નિક્ષિપન્તિ ભાણ્ડાગારસ્ય સમ્મુખે સમુપવિશ્ય યીશુસ્તદવલુલોક; તદાનીં બહવો ધનિનસ્તસ્ય મધ્યે બહૂનિ ધનાનિ નિરક્ષિપન્| ");
INSERT INTO sanguj_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","પશ્ચાદ્ એકા દરિદ્રા વિધવા સમાગત્ય દ્વિપણમૂલ્યાં મુદ્રૈકાં તત્ર નિરક્ષિપત્| ");
INSERT INTO sanguj_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","તદા યીશુઃ શિષ્યાન્ આહૂય કથિતવાન્ યુષ્માનહં યથાર્થં વદામિ યે યે ભાણ્ડાગારેઽસ્મિન ધનાનિ નિઃક્ષિપન્તિ સ્મ તેભ્યઃ સર્વ્વેભ્ય ઇયં વિધવા દરિદ્રાધિકમ્ નિઃક્ષિપતિ સ્મ| ");
INSERT INTO sanguj_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","યતસ્તે પ્રભૂતધનસ્ય કિઞ્ચિત્ નિરક્ષિપન્ કિન્તુ દીનેયં સ્વદિનયાપનયોગ્યં કિઞ્ચિદપિ ન સ્થાપયિત્વા સર્વ્વસ્વં નિરક્ષિપત્| ");
INSERT INTO sanguj_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","અનન્તરં મન્દિરાદ્ બહિર્ગમનકાલે તસ્ય શિષ્યાણામેકસ્તં વ્યાહૃતવાન્ હે ગુરો પશ્યતુ કીદૃશાઃ પાષાણાઃ કીદૃક્ ચ નિચયનં| ");
INSERT INTO sanguj_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","તદા યીશુસ્તમ્ અવદત્ ત્વં કિમેતદ્ બૃહન્નિચયનં પશ્યસિ? અસ્યૈકપાષાણોપિ દ્વિતીયપાષાણોપરિ ન સ્થાસ્યતિ સર્વ્વે ઽધઃક્ષેપ્સ્યન્તે| ");
INSERT INTO sanguj_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","અથ યસ્મિન્ કાલે જૈતુન્ગિરૌ મન્દિરસ્ય સમ્મુખે સ સમુપવિષ્ટસ્તસ્મિન્ કાલે પિતરો યાકૂબ્ યોહન્ આન્દ્રિયશ્ચૈતે તં રહસિ પપ્રચ્છુઃ, ");
INSERT INTO sanguj_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","એતા ઘટનાઃ કદા ભવિષ્યન્તિ? તથૈતત્સર્વ્વાસાં સિદ્ધ્યુપક્રમસ્ય વા કિં ચિહ્નં? તદસ્મભ્યં કથયતુ ભવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","તતો યાશુસ્તાન્ વક્તુમારેભે, કોપિ યથા યુષ્માન્ ન ભ્રામયતિ તથાત્ર યૂયં સાવધાના ભવત| ");
INSERT INTO sanguj_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","યતઃ ખ્રીષ્ટોહમિતિ કથયિત્વા મમ નામ્નાનેકે સમાગત્ય લોકાનાં ભ્રમં જનયિષ્યન્તિ; ");
INSERT INTO sanguj_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","કિન્તુ યૂયં રણસ્ય વાર્ત્તાં રણાડમ્બરઞ્ચ શ્રુત્વા મા વ્યાકુલા ભવત, ઘટના એતા અવશ્યમ્માવિન્યઃ; કિન્ત્વાપાતતો ન યુગાન્તો ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","દેશસ્ય વિપક્ષતયા દેશો રાજ્યસ્ય વિપક્ષતયા ચ રાજ્યમુત્થાસ્યતિ, તથા સ્થાને સ્થાને ભૂમિકમ્પો દુર્ભિક્ષં મહાક્લેશાશ્ચ સમુપસ્થાસ્યન્તિ, સર્વ્વ એતે દુઃખસ્યારમ્ભાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","કિન્તુ યૂયમ્ આત્માર્થે સાવધાનાસ્તિષ્ઠત, યતો લોકા રાજસભાયાં યુષ્માન્ સમર્પયિષ્યન્તિ, તથા ભજનગૃહે પ્રહરિષ્યન્તિ; યૂયં મદર્થે દેશાધિપાન્ ભૂપાંશ્ચ પ્રતિ સાક્ષ્યદાનાય તેષાં સમ્મુખે ઉપસ્થાપયિષ્યધ્વે| ");
INSERT INTO sanguj_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","શેષીભવનાત્ પૂર્વ્વં સર્વ્વાન્ દેશીયાન્ પ્રતિ સુસંવાદઃ પ્રચારયિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","કિન્તુ યદા તે યુષ્માન્ ધૃત્વા સમર્પયિષ્યન્તિ તદા યૂયં યદ્યદ્ ઉત્તરં દાસ્યથ, તદગ્ર તસ્ય વિવેચનં મા કુરુત તદર્થં કિઞ્ચિદપિ મા ચિન્તયત ચ, તદાનીં યુષ્માકં મનઃસુ યદ્યદ્ વાક્યમ્ ઉપસ્થાપયિષ્યતે તદેવ વદિષ્યથ, યતો યૂયં ન તદ્વક્તારઃ કિન્તુ પવિત્ર આત્મા તસ્ય વક્તા| ");
INSERT INTO sanguj_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","તદા ભ્રાતા ભ્રાતરં પિતા પુત્રં ઘાતનાર્થં પરહસ્તેષુ સમર્પયિષ્યતે, તથા પત્યાનિ માતાપિત્રો ર્વિપક્ષતયા તૌ ઘાતયિષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","મમ નામહેતોઃ સર્વ્વેષાં સવિધે યૂયં જુગુપ્સિતા ભવિષ્યથ, કિન્તુ યઃ કશ્ચિત્ શેષપર્ય્યન્તં ધૈર્ય્યમ્ આલમ્બિષ્યતે સએવ પરિત્રાસ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","દાનિયેલ્ભવિષ્યદ્વાદિના પ્રોક્તં સર્વ્વનાશિ જુગુપ્સિતઞ્ચ વસ્તુ યદા ત્વયોગ્યસ્થાને વિદ્યમાનં દ્રક્ષથ (યો જનઃ પઠતિ સ બુધ્યતાં) તદા યે યિહૂદીયદેશે તિષ્ઠન્તિ તે મહીધ્રં પ્રતિ પલાયન્તાં; ");
INSERT INTO sanguj_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","તથા યો નરો ગૃહોપરિ તિષ્ઠતિ સ ગૃહમધ્યં નાવરોહતુ, તથા કિમપિ વસ્તુ ગ્રહીતું મધ્યેગૃહં ન પ્રવિશતુ; ");
INSERT INTO sanguj_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","તથા ચ યો નરઃ ક્ષેત્રે તિષ્ઠતિ સોપિ સ્વવસ્ત્રં ગ્રહીતું પરાવૃત્ય ન વ્રજતુ| ");
INSERT INTO sanguj_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","તદાનીં ગર્બ્ભવતીનાં સ્તન્યદાત્રીણાઞ્ચ યોષિતાં દુર્ગતિ ર્ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","યુષ્માકં પલાયનં શીતકાલે યથા ન ભવતિ તદર્થં પ્રાર્થયધ્વં| ");
INSERT INTO sanguj_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","યતસ્તદા યાદૃશી દુર્ઘટના ઘટિષ્યતે તાદૃશી દુર્ઘટના ઈશ્વરસૃષ્ટેઃ પ્રથમમારભ્યાદ્ય યાવત્ કદાપિ ન જાતા ન જનિષ્યતે ચ| ");
INSERT INTO sanguj_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","અપરઞ્ચ પરમેશ્વરો યદિ તસ્ય સમયસ્ય સંક્ષેપં ન કરોતિ તર્હિ કસ્યાપિ પ્રાણભૃતો રક્ષા ભવિતું ન શક્ષ્યતિ, કિન્તુ યાન્ જનાન્ મનોનીતાન્ અકરોત્ તેષાં સ્વમનોનીતાનાં હેતોઃ સ તદનેહસં સંક્ષેપ્સ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","અન્યચ્ચ પશ્યત ખ્રીષ્ટોત્ર સ્થાને વા તત્ર સ્થાને વિદ્યતે, તસ્મિન્કાલે યદિ કશ્ચિદ્ યુષ્માન્ એતાદૃશં વાક્યં વ્યાહરતિ, તર્હિ તસ્મિન્ વાક્યે ભૈવ વિશ્વસિત| ");
INSERT INTO sanguj_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","યતોનેકે મિથ્યાખ્રીષ્ટા મિથ્યાભવિષ્યદ્વાદિનશ્ચ સમુપસ્થાય બહૂનિ ચિહ્નાન્યદ્ભુતાનિ કર્મ્માણિ ચ દર્શયિષ્યન્તિ; તથા યદિ સમ્ભવતિ તર્હિ મનોનીતલોકાનામપિ મિથ્યામતિં જનયિષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","પશ્યત ઘટનાતઃ પૂર્વ્વં સર્વ્વકાર્ય્યસ્ય વાર્ત્તાં યુષ્મભ્યમદામ્, યૂયં સાવધાનાસ્તિષ્ઠત| ");
INSERT INTO sanguj_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","અપરઞ્ચ તસ્ય ક્લેશકાલસ્યાવ્યવહિતે પરકાલે ભાસ્કરઃ સાન્ધકારો ભવિષ્યતિ તથૈવ ચન્દ્રશ્ચન્દ્રિકાં ન દાસ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","નભઃસ્થાનિ નક્ષત્રાણિ પતિષ્યન્તિ, વ્યોમમણ્ડલસ્થા ગ્રહાશ્ચ વિચલિષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","તદાનીં મહાપરાક્રમેણ મહૈશ્વર્ય્યેણ ચ મેઘમારુહ્ય સમાયાન્તં માનવસુતં માનવાઃ સમીક્ષિષ્યન્તે| ");
INSERT INTO sanguj_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","અન્યચ્ચ સ નિજદૂતાન્ પ્રહિત્ય નભોભૂમ્યોઃ સીમાં યાવદ્ જગતશ્ચતુર્દિગ્ભ્યઃ સ્વમનોનીતલોકાન્ સંગ્રહીષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","ઉડુમ્બરતરો ર્દૃષ્ટાન્તં શિક્ષધ્વં યદોડુમ્બરસ્ય તરો ર્નવીનાઃ શાખા જાયન્તે પલ્લવાદીનિ ચ ર્નિગચ્છન્તિ, તદા નિદાઘકાલઃ સવિધો ભવતીતિ યૂયં જ્ઞાતું શક્નુથ| ");
INSERT INTO sanguj_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","તદ્વદ્ એતા ઘટના દૃષ્ટ્વા સ કાલો દ્વાર્ય્યુપસ્થિત ઇતિ જાનીત| ");
INSERT INTO sanguj_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","યુષ્માનહં યથાર્થં વદામિ, આધુનિકલોકાનાં ગમનાત્ પૂર્વ્વં તાનિ સર્વ્વાણિ ઘટિષ્યન્તે| ");
INSERT INTO sanguj_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","દ્યાવાપૃથિવ્યો ર્વિચલિતયોઃ સત્યો ર્મદીયા વાણી ન વિચલિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","અપરઞ્ચ સ્વર્ગસ્થદૂતગણો વા પુત્રો વા તાતાદન્યઃ કોપિ તં દિવસં તં દણ્ડં વા ન જ્ઞાપયતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","અતઃ સ સમયઃ કદા ભવિષ્યતિ, એતજ્જ્ઞાનાભાવાદ્ યૂયં સાવધાનાસ્તિષ્ઠત, સતર્કાશ્ચ ભૂત્વા પ્રાર્થયધ્વં; ");
INSERT INTO sanguj_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","યદ્વત્ કશ્ચિત્ પુમાન્ સ્વનિવેશનાદ્ દૂરદેશં પ્રતિ યાત્રાકરણકાલે દાસેષુ સ્વકાર્ય્યસ્ય ભારમર્પયિત્વા સર્વ્વાન્ સ્વે સ્વે કર્મ્મણિ નિયોજયતિ; અપરં દૌવારિકં જાગરિતું સમાદિશ્ય યાતિ, તદ્વન્ નરપુત્રઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","ગૃહપતિઃ સાયંકાલે નિશીથે વા તૃતીયયામે વા પ્રાતઃકાલે વા કદાગમિષ્યતિ તદ્ યૂયં ન જાનીથ; ");
INSERT INTO sanguj_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","સ હઠાદાગત્ય યથા યુષ્માન્ નિદ્રિતાન્ ન પશ્યતિ, તદર્થં જાગરિતાસ્તિષ્ઠત| ");
INSERT INTO sanguj_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","યુષ્માનહં યદ્ વદામિ તદેવ સર્વ્વાન્ વદામિ, જાગરિતાસ્તિષ્ઠતેતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","તદા નિસ્તારોત્સવકિણ્વહીનપૂપોત્સવયોરારમ્ભસ્ય દિનદ્વયે ઽવશિષ્ટે પ્રધાનયાજકા અધ્યાપકાશ્ચ કેનાપિ છલેન યીશું ધર્ત્તાં હન્તુઞ્ચ મૃગયાઞ્ચક્રિરે; ");
INSERT INTO sanguj_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","કિન્તુ લોકાનાં કલહભયાદૂચિરે, નચોત્સવકાલ ઉચિતમેતદિતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","અનન્તરં બૈથનિયાપુुરે શિમોનકુષ્ઠિનો ગૃહે યોશૌ ભોત્કુમુપવિષ્ટે સતિ કાચિદ્ યોષિત્ પાણ્ડરપાષાણસ્ય સમ્પુટકેન મહાર્ઘ્યોત્તમતૈલમ્ આનીય સમ્પુટકં ભંક્ત્વા તસ્યોત્તમાઙ્ગે તૈલધારાં પાતયાઞ્ચક્રે| ");
INSERT INTO sanguj_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","તસ્માત્ કેચિત્ સ્વાન્તે કુપ્યન્તઃ કથિતવંન્તઃ કુતોયં તૈલાપવ્યયઃ? ");
INSERT INTO sanguj_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","યદ્યેતત્ તૈલ વ્યક્રેષ્યત તર્હિ મુદ્રાપાદશતત્રયાદપ્યધિકં તસ્ય પ્રાપ્તમૂલ્યં દરિદ્રલોકેભ્યો દાતુમશક્ષ્યત, કથામેતાં કથયિત્વા તયા યોષિતા સાકં વાચાયુહ્યન્| ");
INSERT INTO sanguj_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","કિન્તુ યીશુરુવાચ, કુત એતસ્યૈ કૃચ્છ્રં દદાસિ? મહ્યમિયં કર્મ્મોત્તમં કૃતવતી| ");
INSERT INTO sanguj_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","દરિદ્રાઃ સર્વ્વદા યુષ્માભિઃ સહ તિષ્ઠન્તિ, તસ્માદ્ યૂયં યદેચ્છથ તદૈવ તાનુપકર્ત્તાં શક્નુથ, કિન્ત્વહં યુભાભિઃ સહ નિરન્તરં ન તિષ્ઠામિ| ");
INSERT INTO sanguj_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","અસ્યા યથાસાધ્યં તથૈવાકરોદિયં, શ્મશાનયાપનાત્ પૂર્વ્વં સમેત્ય મદ્વપુષિ તૈલમ્ અમર્દ્દયત્| ");
INSERT INTO sanguj_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","અહં યુષ્મભ્યં યથાર્થં કથયામિ, જગતાં મધ્યે યત્ર યત્ર સુસંવાદોયં પ્રચારયિષ્યતે તત્ર તત્ર યોષિત એતસ્યાઃ સ્મરણાર્થં તત્કૃતકર્મ્મૈતત્ પ્રચારયિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","તતઃ પરં દ્વાદશાનાં શિષ્યાણામેક ઈષ્કરિયોતીયયિહૂદાખ્યો યીશું પરકરેષુ સમર્પયિતું પ્રધાનયાજકાનાં સમીપમિયાય| ");
INSERT INTO sanguj_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","તે તસ્ય વાક્યં સમાકર્ણ્ય સન્તુષ્ટાઃ સન્તસ્તસ્મૈ મુદ્રા દાતું પ્રત્યજાનત; તસ્માત્ સ તં તેષાં કરેષુ સમર્પણાયોપાયં મૃગયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","અનન્તરં કિણ્વશૂન્યપૂપોત્સવસ્ય પ્રથમેઽહનિ નિસ્તારોત્મવાર્થં મેષમારણાસમયે શિષ્યાસ્તં પપ્રચ્છઃ કુત્ર ગત્વા વયં નિસ્તારોત્સવસ્ય ભોજ્યમાસાદયિષ્યામઃ? કિમિચ્છતિ ભવાન્? ");
INSERT INTO sanguj_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","તદાનીં સ તેષાં દ્વયં પ્રેરયન્ બભાષે યુવયોઃ પુરમધ્યં ગતયોઃ સતો ર્યો જનઃ સજલકુમ્ભં વહન્ યુવાં સાક્ષાત્ કરિષ્યતિ તસ્યૈવ પશ્ચાદ્ યાતં; ");
INSERT INTO sanguj_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","સ યત્ સદનં પ્રવેક્ષ્યતિ તદ્ભવનપતિં વદતં, ગુરુરાહ યત્ર સશિષ્યોહં નિસ્તારોત્સવીયં ભોજનં કરિષ્યામિ, સા ભોજનશાલા કુત્રાસ્તિ? ");
INSERT INTO sanguj_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","તતઃ સ પરિષ્કૃતાં સુસજ્જિતાં બૃહતીચઞ્ચ યાં શાલાં દર્શયિષ્યતિ તસ્યામસ્મદર્થં ભોજ્યદ્રવ્યાણ્યાસાદયતં| ");
INSERT INTO sanguj_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","તતઃ શિષ્યૌ પ્રસ્થાય પુરં પ્રવિશ્ય સ યથોક્તવાન્ તથૈવ પ્રાપ્ય નિસ્તારોત્સવસ્ય ભોજ્યદ્રવ્યાણિ સમાસાદયેતામ્| ");
INSERT INTO sanguj_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","અનન્તરં યીશુઃ સાયંકાલે દ્વાદશભિઃ શિષ્યૈઃ સાર્દ્ધં જગામ; ");
INSERT INTO sanguj_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","સર્વ્વેષુ ભોજનાય પ્રોપવિષ્ટેષુ સ તાનુદિતવાન્ યુષ્માનહં યથાર્થં વ્યાહરામિ, અત્ર યુષ્માકમેકો જનો યો મયા સહ ભુંક્તે માં પરકેરેષુ સમર્પયિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","તદાનીં તે દુઃખિતાઃ સન્ત એકૈકશસ્તં પ્રષ્ટુમારબ્ધવન્તઃ સ કિમહં? પશ્ચાદ્ અન્ય એકોભિદધે સ કિમહં? ");
INSERT INTO sanguj_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","તતઃ સ પ્રત્યવદદ્ એતેષાં દ્વાદશાનાં યો જનો મયા સમં ભોજનાપાત્રે પાણિં મજ્જયિષ્યતિ સ એવ| ");
INSERT INTO sanguj_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","મનુજતનયમધિ યાદૃશં લિખિતમાસ્તે તદનુરૂપા ગતિસ્તસ્ય ભવિષ્યતિ, કિન્તુ યો જનો માનવસુતં સમર્પયિષ્યતે હન્ત તસ્ય જન્માભાવે સતિ ભદ્રમભવિષ્યત્| ");
INSERT INTO sanguj_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","અપરઞ્ચ તેષાં ભોજનસમયે યીશુઃ પૂપં ગૃહીત્વેશ્વરગુણાન્ અનુકીર્ત્ય ભઙ્ક્ત્વા તેભ્યો દત્ત્વા બભાષે, એતદ્ ગૃહીત્વા ભુઞ્જીધ્વમ્ એતન્મમ વિગ્રહરૂપં| ");
INSERT INTO sanguj_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","અનન્તરં સ કંસં ગૃહીત્વેશ્વરસ્ય ગુણાન્ કીર્ત્તયિત્વા તેભ્યો દદૌ, તતસ્તે સર્વ્વે પપુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","અપરં સ તાનવાદીદ્ બહૂનાં નિમિત્તં પાતિતં મમ નવીનનિયમરૂપં શોણિતમેતત્| ");
INSERT INTO sanguj_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","યુષ્માનહં યથાર્થં વદામિ, ઈશ્વરસ્ય રાજ્યે યાવત્ સદ્યોજાતં દ્રાક્ષારસં ન પાસ્યામિ,તાવદહં દ્રાક્ષાફલરસં પુન ર્ન પાસ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","તદનન્તરં તે ગીતમેકં સંગીય બહિ ર્જૈતુનં શિખરિણં યયુઃ ");
INSERT INTO sanguj_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","અથ યીશુસ્તાનુવાચ નિશાયામસ્યાં મયિ યુષ્માકં સર્વ્વેષાં પ્રત્યૂહો ભવિષ્યતિ યતો લિખિતમાસ્તે યથા, મેષાણાં રક્ષકઞ્ચાહં પ્રહરિષ્યામિ વૈ તતઃ| મેષાણાં નિવહો નૂનં પ્રવિકીર્ણો ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","કન્તુ મદુત્થાને જાતે યુષ્માકમગ્રેઽહં ગાલીલં વ્રજિષ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","તદા પિતરઃ પ્રતિબભાષે, યદ્યપિ સર્વ્વેષાં પ્રત્યૂહો ભવતિ તથાપિ મમ નૈવ ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","તતો યીશુરુક્તાવાન્ અહં તુભ્યં તથ્યં કથયામિ, ક્ષણાદાયામદ્ય કુક્કુટસ્ય દ્વિતીયવારરવણાત્ પૂર્વ્વં ત્વં વારત્રયં મામપહ્નોષ્યસે| ");
INSERT INTO sanguj_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","કિન્તુ સ ગાઢં વ્યાહરદ્ યદ્યપિ ત્વયા સાર્દ્ધં મમ પ્રાણો યાતિ તથાપિ કથમપિ ત્વાં નાપહ્નોષ્યે; સર્વ્વેઽપીતરે તથૈવ બભાષિરે| ");
INSERT INTO sanguj_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","અપરઞ્ચ તેષુ ગેત્શિમાનીનામકં સ્થાન ગતેષુ સ શિષ્યાન્ જગાદ, યાવદહં પ્રાર્થયે તાવદત્ર સ્થાને યૂયં સમુપવિશત| ");
INSERT INTO sanguj_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","અથ સ પિતરં યાકૂબં યોહનઞ્ચ ગૃહીત્વા વવ્રાજ; અત્યન્તં ત્રાસિતો વ્યાકુલિતશ્ચ તેભ્યઃ કથયામાસ, ");
INSERT INTO sanguj_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","નિધનકાલવત્ પ્રાણો મેઽતીવ દઃખમેતિ, યૂયં જાગ્રતોત્ર સ્થાને તિષ્ઠત| ");
INSERT INTO sanguj_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","તતઃ સ કિઞ્ચિદ્દૂરં ગત્વા ભૂમાવધોમુખઃ પતિત્વા પ્રાર્થિતવાનેતત્, યદિ ભવિતું શક્યં તર્હિ દુઃખસમયોયં મત્તો દૂરીભવતુ| ");
INSERT INTO sanguj_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","અપરમુદિતવાન્ હે પિત ર્હે પિતઃ સર્વ્વેં ત્વયા સાધ્યં, તતો હેતોરિમં કંસં મત્તો દૂરીકુરુ, કિન્તુ તન્ મમેચ્છાતો ન તવેચ્છાતો ભવતુ| ");
INSERT INTO sanguj_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","તતઃ પરં સ એત્ય તાન્ નિદ્રિતાન્ નિરીક્ષ્ય પિતરં પ્રોવાચ, શિમોન્ ત્વં કિં નિદ્રાસિ? ઘટિકામેકામ્ અપિ જાગરિતું ન શક્નોષિ? ");
INSERT INTO sanguj_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","પરીક્ષાયાં યથા ન પતથ તદર્થં સચેતનાઃ સન્તઃ પ્રાર્થયધ્વં; મન ઉદ્યુક્તમિતિ સત્યં કિન્તુ વપુરશક્તિકં| ");
INSERT INTO sanguj_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","અથ સ પુનર્વ્રજિત્વા પૂર્વ્વવત્ પ્રાર્થયાઞ્ચક્રે| ");
INSERT INTO sanguj_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","પરાવૃત્યાગત્ય પુનરપિ તાન્ નિદ્રિતાન્ દદર્શ તદા તેષાં લોચનાનિ નિદ્રયા પૂર્ણાનિ, તસ્માત્તસ્મૈ કા કથા કથયિતવ્યા ત એતદ્ બોદ્ધું ન શેકુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","તતઃપરં તૃતીયવારં આગત્ય તેભ્યો ઽકથયદ્ ઇદાનીમપિ શયિત્વા વિશ્રામ્યથ? યથેષ્ટં જાતં, સમયશ્ચોપસ્થિતઃ પશ્યત માનવતનયઃ પાપિલોકાનાં પાણિષુ સમર્પ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ઉત્તિષ્ઠત, વયં વ્રજામો યો જનો માં પરપાણિષુ સમર્પયિષ્યતે પશ્યત સ સમીપમાયાતઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ઇમાં કથાં કથયતિ સ, એતર્હિદ્વાદશાનામેકો યિહૂદા નામા શિષ્યઃ પ્રધાનયાજકાનામ્ ઉપાધ્યાયાનાં પ્રાચીનલોકાનાઞ્ચ સન્નિધેઃ ખઙ્ગલગુડધારિણો બહુલોકાન્ ગૃહીત્વા તસ્ય સમીપ ઉપસ્થિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","અપરઞ્ચાસૌ પરપાણિષુ સમર્પયિતા પૂર્વ્વમિતિ સઙ્કેતં કૃતવાન્ યમહં ચુમ્બિષ્યામિ સ એવાસૌ તમેવ ધૃત્વા સાવધાનં નયત| ");
INSERT INTO sanguj_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","અતો હેતોઃ સ આગત્યૈવ યોશોઃ સવિધં ગત્વા હે ગુરો હે ગુરો, ઇત્યુક્ત્વા તં ચુચુમ્બ| ");
INSERT INTO sanguj_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","તદા તે તદુપરિ પાણીનર્પયિત્વા તં દધ્નુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","તતસ્તસ્ય પાર્શ્વસ્થાનાં લોકાનામેકઃ ખઙ્ગં નિષ્કોષયન્ મહાયાજકસ્ય દાસમેકં પ્રહૃત્ય તસ્ય કર્ણં ચિચ્છેદ| ");
INSERT INTO sanguj_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","પશ્ચાદ્ યીશુસ્તાન્ વ્યાજહાર ખઙ્ગાન્ લગુડાંશ્ચ ગૃહીત્વા માં કિં ચૌરં ધર્ત્તાં સમાયાતાઃ? ");
INSERT INTO sanguj_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","મધ્યેમન્દિરં સમુપદિશન્ પ્રત્યહં યુષ્માભિઃ સહ સ્થિતવાનતહં, તસ્મિન્ કાલે યૂયં માં નાદીધરત, કિન્ત્વનેન શાસ્ત્રીયં વચનં સેધનીયં| ");
INSERT INTO sanguj_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","તદા સર્વ્વે શિષ્યાસ્તં પરિત્યજ્ય પલાયાઞ્ચક્રિરે| ");
INSERT INTO sanguj_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","અથૈકો યુવા માનવો નગ્નકાયે વસ્ત્રમેકં નિધાય તસ્ય પશ્ચાદ્ વ્રજન્ યુવલોકૈ ર્ધૃતો ");
INSERT INTO sanguj_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","વસ્ત્રં વિહાય નગ્નઃ પલાયાઞ્ચક્રે| ");
INSERT INTO sanguj_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","અપરઞ્ચ યસ્મિન્ સ્થાને પ્રધાનયાજકા ઉપાધ્યાયાઃ પ્રાચીનલોકાશ્ચ મહાયાજકેન સહ સદસિ સ્થિતાસ્તસ્મિન્ સ્થાને મહાયાજકસ્ય સમીપં યીશું નિન્યુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","પિતરો દૂરે તત્પશ્ચાદ્ ઇત્વા મહાયાજકસ્યાટ્ટાલિકાં પ્રવિશ્ય કિઙ્કરૈઃ સહોપવિશ્ય વહ્નિતાપં જગ્રાહ| ");
INSERT INTO sanguj_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","તદાનીં પ્રધાનયાજકા મન્ત્રિણશ્ચ યીશું ઘાતયિતું તત્પ્રાતિકૂલ્યેન સાક્ષિણો મૃગયાઞ્ચક્રિરે, કિન્તુ ન પ્રાપ્તાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","અનેકૈસ્તદ્વિરુદ્ધં મૃષાસાક્ષ્યે દત્તેપિ તેષાં વાક્યાનિ ન સમગચ્છન્ત| ");
INSERT INTO sanguj_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","સર્વ્વશેષે કિયન્ત ઉત્થાય તસ્ય પ્રાતિકૂલ્યેન મૃષાસાક્ષ્યં દત્ત્વા કથયામાસુઃ, ");
INSERT INTO sanguj_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","ઇદં કરકૃતમન્દિરં વિનાશ્ય દિનત્રયમધ્યે પુનરપરમ્ અકરકૃતં મન્દિરં નિર્મ્માસ્યામિ, ઇતિ વાક્યમ્ અસ્ય મુખાત્ શ્રુતમસ્માભિરિતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","કિન્તુ તત્રાપિ તેષાં સાક્ષ્યકથા ન સઙ્ગાતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","અથ મહાયાજકો મધ્યેસભમ્ ઉત્થાય યીશું વ્યાજહાર, એતે જનાસ્ત્વયિ યત્ સાક્ષ્યમદુઃ ત્વમેતસ્ય કિમપ્યુત્તરં કિં ન દાસ્યસિ? ");
INSERT INTO sanguj_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","કિન્તુ સ કિમપ્યુત્તરં ન દત્વા મૌનીભૂય તસ્યૌ; તતો મહાયાજકઃ પુનરપિ તં પૃષ્ટાવાન્ ત્વં સચ્ચિદાનન્દસ્ય તનયો ઽભિષિક્તસ્ત્રતા? ");
INSERT INTO sanguj_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","તદા યીશુસ્તં પ્રોવાચ ભવામ્યહમ્ યૂયઞ્ચ સર્વ્વશક્તિમતો દક્ષીણપાર્શ્વે સમુપવિશન્તં મેઘ મારુહ્ય સમાયાન્તઞ્ચ મનુષ્યપુત્રં સન્દ્રક્ષ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","તદા મહાયાજકઃ સ્વં વમનં છિત્વા વ્યાવહરત્ ");
INSERT INTO sanguj_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","કિમસ્માકં સાક્ષિભિઃ પ્રયોજનમ્? ઈશ્વરનિન્દાવાક્યં યુષ્માભિરશ્રાવિ કિં વિચારયથ? તદાનીં સર્વ્વે જગદુરયં નિધનદણ્ડમર્હતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","તતઃ કશ્ચિત્ કશ્ચિત્ તદ્વપુષિ નિષ્ઠીવં નિચિક્ષેપ તથા તન્મુખમાચ્છાદ્ય ચપેટેન હત્વા ગદિતવાન્ ગણયિત્વા વદ, અનુચરાશ્ચ ચપેટૈસ્તમાજઘ્નુઃ ");
INSERT INTO sanguj_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","તતઃ પરં પિતરેઽટ્ટાલિકાધઃકોષ્ઠે તિષ્ઠતિ મહાયાજકસ્યૈકા દાસી સમેત્ય ");
INSERT INTO sanguj_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","તં વિહ્નિતાપં ગૃહ્લન્તં વિલોક્ય તં સુનિરીક્ષ્ય બભાષે ત્વમપિ નાસરતીયયીશોઃ સઙ્ગિનામ્ એકો જન આસીઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","કિન્તુ સોપહ્નુત્ય જગાદ તમહં ન વદ્મિ ત્વં યત્ કથયમિ તદપ્યહં ન બુદ્ધ્યે| તદાનીં પિતરે ચત્વરં ગતવતિ કુेક્કુટો રુરાવ| ");
INSERT INTO sanguj_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","અથાન્યા દાસી પિતરં દૃષ્ટ્વા સમીપસ્થાન્ જનાન્ જગાદ અયં તેષામેકો જનઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","તતઃ સ દ્વિતીયવારમ્ અપહ્નુતવાન્ પશ્ચાત્ તત્રસ્થા લોકાઃ પિતરં પ્રોચુસ્ત્વમવશ્યં તેષામેકો જનઃ યતસ્ત્વં ગાલીલીયો નર ઇતિ તવોચ્ચારણં પ્રકાશયતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","તદા સ શપથાભિશાપૌ કૃત્વા પ્રોવાચ યૂયં કથાં કથયથ તં નરં ન જાનેઽહં| ");
INSERT INTO sanguj_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","તદાનીં દ્વિતીયવારં કુક્કુટો ઽરાવીત્| કુક્કુટસ્ય દ્વિતીયરવાત્ પૂર્વ્વં ત્વં માં વારત્રયમ્ અપહ્નોષ્યસિ, ઇતિ યદ્વાક્યં યીશુના સમુદિતં તત્ તદા સંસ્મૃત્ય પિતરો રોદિતુમ્ આરભત| ");
INSERT INTO sanguj_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","અથ પ્રભાતે સતિ પ્રધાનયાજકાઃ પ્રાઞ્ચ ઉપાધ્યાયાઃ સર્વ્વે મન્ત્રિણશ્ચ સભાં કૃત્વા યીશુृં બન્ધયિત્વ પીલાતાખ્યસ્ય દેશાધિપતેઃ સવિધં નીત્વા સમર્પયામાસુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","તદા પીલાતસ્તં પૃષ્ટવાન્ ત્વં કિં યિહૂદીયલોકાનાં રાજા? તતઃ સ પ્રત્યુક્તવાન્ સત્યં વદસિ| ");
INSERT INTO sanguj_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","અપરં પ્રધાનયાજકાસ્તસ્ય બહુષુ વાક્યેષુ દોષમારોપયાઞ્ચક્રુઃ કિન્તુ સ કિમપિ ન પ્રત્યુવાચ| ");
INSERT INTO sanguj_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","તદાનીં પીલાતસ્તં પુનઃ પપ્રચ્છ ત્વં કિં નોત્તરયસિ? પશ્યૈતે ત્વદ્વિરુદ્ધં કતિષુ સાધ્યેષુ સાક્ષં દદતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","કન્તુ યીશુસ્તદાપિ નોત્તરં દદૌ તતઃ પીલાત આશ્ચર્ય્યં જગામ| ");
INSERT INTO sanguj_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","અપરઞ્ચ કારાબદ્ધે કસ્તિંશ્ચિત્ જને તન્મહોત્સવકાલે લોકૈ ર્યાચિતે દેશાધિપતિસ્તં મોચયતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","યે ચ પૂર્વ્વમુપપ્લવમકાર્ષુરુપપ્લવે વધમપિ કૃતવન્તસ્તેષાં મધ્યે તદાનોં બરબ્બાનામક એકો બદ્ધ આસીત્| ");
INSERT INTO sanguj_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","અતો હેતોઃ પૂર્વ્વાપરીયાં રીતિકથાં કથયિત્વા લોકા ઉચ્ચૈરુવન્તઃ પીલાતસ્ય સમક્ષં નિવેદયામાસુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","તદા પીલાતસ્તાનાચખ્યૌ તર્હિ કિં યિહૂદીયાનાં રાજાનં મોચયિષ્યામિ? યુષ્માભિઃ કિમિષ્યતે? ");
INSERT INTO sanguj_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","યતઃ પ્રધાનયાજકા ઈર્ષ્યાત એવ યીશું સમાર્પયન્નિતિ સ વિવેદ| ");
INSERT INTO sanguj_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","કિન્તુ યથા બરબ્બાં મોચયતિ તથા પ્રાર્થયિતું પ્રધાનયાજકા લોકાન્ પ્રવર્ત્તયામાસુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","અથ પીલાતઃ પુનઃ પૃષ્ટવાન્ તર્હિ યં યિહૂદીયાનાં રાજેતિ વદથ તસ્ય કિં કરિષ્યામિ યુષ્માભિઃ કિમિષ્યતે? ");
INSERT INTO sanguj_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","તદા તે પુનરપિ પ્રોચ્ચૈઃ પ્રોચુસ્તં ક્રુશે વેધય| ");
INSERT INTO sanguj_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","તસ્માત્ પીલાતઃ કથિતવાન્ કુતઃ? સ કિં કુકર્મ્મ કૃતવાન્? કિન્તુ તે પુનશ્ચ રુવન્તો વ્યાજહ્રુસ્તં ક્રુશે વેધય| ");
INSERT INTO sanguj_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","તદા પીલાતઃ સર્વ્વાલ્લોકાન્ તોષયિતુમિચ્છન્ બરબ્બાં મોચયિત્વા યીશું કશાભિઃ પ્રહૃત્ય ક્રુશે વેદ્ધું તં સમર્પયામ્બભૂવ| ");
INSERT INTO sanguj_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","અનન્તરં સૈન્યગણોઽટ્ટાલિકામ્ અર્થાદ્ અધિપતે ર્ગૃહં યીશું નીત્વા સેનાનિવહં સમાહુયત્| ");
INSERT INTO sanguj_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","પશ્ચાત્ તે તં ધૂમલવર્ણવસ્ત્રં પરિધાપ્ય કણ્ટકમુકુટં રચયિત્વા શિરસિ સમારોપ્ય ");
INSERT INTO sanguj_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","હે યિહૂદીયાનાં રાજન્ નમસ્કાર ઇત્યુક્ત્વા તં નમસ્કર્ત્તામારેભિરે| ");
INSERT INTO sanguj_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","તસ્યોત્તમાઙ્ગે વેત્રાઘાતં ચક્રુસ્તદ્ગાત્રે નિષ્ઠીવઞ્ચ નિચિક્ષિપુઃ, તથા તસ્ય સમ્મુખે જાનુપાતં પ્રણોમુઃ ");
INSERT INTO sanguj_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ઇત્થમુપહસ્ય ધૂમ્રવર્ણવસ્ત્રમ્ ઉત્તાર્ય્ય તસ્ય વસ્ત્રં તં પર્ય્યધાપયન્ ક્રુશે વેદ્ધું બહિર્નિન્યુશ્ચ| ");
INSERT INTO sanguj_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","તતઃ પરં સેકન્દરસ્ય રુફસ્ય ચ પિતા શિમોન્નામા કુરીણીયલોક એકઃ કુતશ્ચિદ્ ગ્રામાદેત્ય પથિ યાતિ તં તે યીશોઃ ક્રુશં વોઢું બલાદ્ દધ્નુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","અથ ગુલ્ગલ્તા અર્થાત્ શિરઃકપાલનામકં સ્થાનં યીશુમાનીય ");
INSERT INTO sanguj_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","તે ગન્ધરસમિશ્રિતં દ્રાક્ષારસં પાતું તસ્મૈ દદુઃ કિન્તુ સ ન જગ્રાહ| ");
INSERT INTO sanguj_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","તસ્મિન્ ક્રુશે વિદ્ધે સતિ તેષામેકૈકશઃ કિં પ્રાપ્સ્યતીતિ નિર્ણયાય ");
INSERT INTO sanguj_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","તસ્ય પરિધેયાનાં વિભાગાર્થં ગુટિકાપાતં ચક્રુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","અપરમ્ એષ યિહૂદીયાનાં રાજેતિ લિખિતં દોષપત્રં તસ્ય શિરઊર્દ્વ્વમ્ આરોપયાઞ્ચક્રુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","તસ્ય વામદક્ષિણયો ર્દ્વૌ ચૌરૌ ક્રુશયો ર્વિવિધાતે| ");
INSERT INTO sanguj_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","તેનૈવ \"અપરાધિજનૈઃ સાર્દ્ધં સ ગણિતો ભવિષ્યતિ,\" ઇતિ શાસ્ત્રોક્તં વચનં સિદ્ધમભૂત| ");
INSERT INTO sanguj_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","અનન્તરં માર્ગે યે યે લોકા ગમનાગમને ચક્રુસ્તે સર્વ્વ એવ શિરાંસ્યાન્દોલ્ય નિન્દન્તો જગદુઃ, રે મન્દિરનાશક રે દિનત્રયમધ્યે તન્નિર્મ્માયક, ");
INSERT INTO sanguj_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","અધુનાત્માનમ્ અવિત્વા ક્રુશાદવરોહ| ");
INSERT INTO sanguj_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","કિઞ્ચ પ્રધાનયાજકા અધ્યાપકાશ્ચ તદ્વત્ તિરસ્કૃત્ય પરસ્પરં ચચક્ષિરે એષ પરાનાવત્ કિન્તુ સ્વમવિતું ન શક્નોતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","યદીસ્રાયેલો રાજાભિષિક્તસ્ત્રાતા ભવતિ તર્હ્યધુનૈન ક્રુશાદવરોહતુ વયં તદ્ દૃષ્ટ્વા વિશ્વસિષ્યામઃ; કિઞ્ચ યૌ લોકૌ તેન સાર્દ્ધં ક્રુશે ઽવિધ્યેતાં તાવપિ તં નિર્ભર્ત્સયામાસતુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","અથ દ્વિતીયયામાત્ તૃતીયયામં યાવત્ સર્વ્વો દેશઃ સાન્ધકારોભૂત્| ");
INSERT INTO sanguj_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","તતસ્તૃતીયપ્રહરે યીશુરુચ્ચૈરવદત્ એલી એલી લામા શિવક્તની અર્થાદ્ \"હે મદીશ મદીશ ત્વં પર્ય્યત્યાક્ષીઃ કુતો હિ માં?\" ");
INSERT INTO sanguj_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","તદા સમીપસ્થલોકાનાં કેચિત્ તદ્વાક્યં નિશમ્યાચખ્યુઃ પશ્યૈષ એલિયમ્ આહૂયતિ| ");
INSERT INTO sanguj_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","તત એકો જનો ધાવિત્વાગત્ય સ્પઞ્જે ઽમ્લરસં પૂરયિત્વા તં નડાગ્રે નિધાય પાતું તસ્મૈ દત્ત્વાવદત્ તિષ્ઠ એલિય એનમવરોહયિતુમ્ એતિ ન વેતિ પશ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","અથ યીશુરુચ્ચૈઃ સમાહૂય પ્રાણાન્ જહૌ| ");
INSERT INTO sanguj_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","તદા મન્દિરસ્ય જવનિકોર્દ્વ્વાદધઃર્ય્યન્તા વિદીર્ણા દ્વિખણ્ડાભૂત્| ");
INSERT INTO sanguj_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","કિઞ્ચ ઇત્થમુચ્ચૈરાહૂય પ્રાણાન્ ત્યજન્તં તં દૃષ્દ્વા તદ્રક્ષણાય નિયુક્તો યઃ સેનાપતિરાસીત્ સોવદત્ નરોયમ્ ઈશ્વરપુત્ર ઇતિ સત્યમ્| ");
INSERT INTO sanguj_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","તદાનીં મગ્દલીની મરિસમ્ કનિષ્ઠયાકૂબો યોસેશ્ચ માતાન્યમરિયમ્ શાલોમી ચ યાઃ સ્ત્રિયો ");
INSERT INTO sanguj_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","ગાલીલ્પ્રદેશે યીશું સેવિત્વા તદનુગામિન્યો જાતા ઇમાસ્તદન્યાશ્ચ યા અનેકા નાર્યો યીશુના સાર્દ્ધં યિરૂશાલમમાયાતાસ્તાશ્ચ દૂરાત્ તાનિ દદૃશુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","અથાસાદનદિનસ્યાર્થાદ્ વિશ્રામવારાત્ પૂર્વ્વદિનસ્ય સાયંકાલ આગત ");
INSERT INTO sanguj_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ઈશ્વરરાજ્યાપેક્ષ્યરિમથીયયૂષફનામા માન્યમન્ત્રી સમેત્ય પીલાતસવિધં નિર્ભયો ગત્વા યીશોર્દેહં યયાચે| ");
INSERT INTO sanguj_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","કિન્તુ સ ઇદાનીં મૃતઃ પીલાત ઇત્યસમ્ભવં મત્વા શતસેનાપતિમાહૂય સ કદા મૃત ઇતિ પપ્રચ્છ| ");
INSERT INTO sanguj_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","શતસેમનાપતિમુખાત્ તજ્જ્ઞાત્વા યૂષફે યીશોર્દેહં દદૌ| ");
INSERT INTO sanguj_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","પશ્ચાત્ સ સૂક્ષ્મં વાસઃ ક્રીત્વા યીશોઃ કાયમવરોહ્ય તેન વાસસા વેષ્ટાયિત્વા ગિરૌ ખાતશ્મશાને સ્થાપિતવાન્ પાષાણં લોઠયિત્વા દ્વારિ નિદધે| ");
INSERT INTO sanguj_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","કિન્તુ યત્ર સોસ્થાપ્યત તત મગ્દલીની મરિયમ્ યોસિમાતૃમરિયમ્ ચ દદૃશતૃઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","અથ વિશ્રામવારે ગતે મગ્દલીની મરિયમ્ યાકૂબમાતા મરિયમ્ શાલોમી ચેમાસ્તં મર્દ્દયિતું સુગન્ધિદ્રવ્યાણિ ક્રીત્વા ");
INSERT INTO sanguj_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","સપ્તાહપ્રથમદિનેઽતિપ્રત્યૂષે સૂર્ય્યોદયકાલે શ્મશાનમુપગતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","કિન્તુ શ્મશાનદ્વારપાષાણોઽતિબૃહન્ તં કોઽપસારયિષ્યતીતિ તાઃ પરસ્પરં ગદન્તિ! ");
INSERT INTO sanguj_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","એતર્હિ નિરીક્ષ્ય પાષાણો દ્વારો ઽપસારિત ઇતિ દદૃશુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","પશ્ચાત્તાઃ શ્મશાનં પ્રવિશ્ય શુક્લવર્ણદીર્ઘપરિચ્છદાવૃતમેકં યુવાનં શ્મશાનદક્ષિણપાર્શ્વ ઉપવિષ્ટં દૃષ્ટ્વા ચમચ્ચક્રુઃ| ");
INSERT INTO sanguj_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","સોઽવદત્, માભૈષ્ટ યૂયં ક્રુશે હતં નાસરતીયયીશું ગવેષયથ સોત્ર નાસ્તિ શ્મશાનાદુદસ્થાત્; તૈ ર્યત્ર સ સ્થાપિતઃ સ્થાનં તદિદં પશ્યત| ");
INSERT INTO sanguj_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","કિન્તુ તેન યથોક્તં તથા યુષ્માકમગ્રે ગાલીલં યાસ્યતે તત્ર સ યુષ્માન્ સાક્ષાત્ કરિષ્યતે યૂયં ગત્વા તસ્ય શિષ્યેભ્યઃ પિતરાય ચ વાર્ત્તામિમાં કથયત| ");
INSERT INTO sanguj_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","તાઃ કમ્પિતા વિસ્તિતાશ્ચ તૂર્ણં શ્મશાનાદ્ બહિર્ગત્વા પલાયન્ત ભયાત્ કમપિ કિમપિ નાવદંશ્ચ| ");
INSERT INTO sanguj_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","અપરં યીશુઃ સપ્તાહપ્રથમદિને પ્રત્યૂષે શ્મશાનાદુત્થાય યસ્યાઃ સપ્તભૂતાસ્ત્યાજિતાસ્તસ્યૈ મગ્દલીનીમરિયમે પ્રથમં દર્શનં દદૌ| ");
INSERT INTO sanguj_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","તતઃ સા ગત્વા શોકરોદનકૃદ્ભ્યોઽનુગતલોકેભ્યસ્તાં વાર્ત્તાં કથયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","કિન્તુ યીશુઃ પુનર્જીવન્ તસ્યૈ દર્શનં દત્તવાનિતિ શ્રુત્વા તે ન પ્રત્યયન્| ");
INSERT INTO sanguj_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","પશ્ચાત્ તેષાં દ્વાયો ર્ગ્રામયાનકાલે યીશુરન્યવેશં ધૃત્વા તાભ્યાં દર્શન દદૌ! ");
INSERT INTO sanguj_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","તાવપિ ગત્વાન્યશિષ્યેભ્યસ્તાં કથાં કથયાઞ્ચક્રતુઃ કિન્તુ તયોઃ કથામપિ તે ન પ્રત્યયન્| ");
INSERT INTO sanguj_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","શેષત એકાદશશિષ્યેષુ ભોજનોપવિષ્ટેષુ યીશુસ્તેભ્યો દર્શનં દદૌ તથોત્થાનાત્ પરં તદ્દર્શનપ્રાપ્તલોકાનાં કથાયામવિશ્વાસકરણાત્ તેષામવિશ્વાસમનઃકાઠિન્યાભ્યાં હેતુભ્યાં સ તાંસ્તર્જિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","અથ તાનાચખ્યૌ યૂયં સર્વ્વજગદ્ ગત્વા સર્વ્વજનાન્ પ્રતિ સુસંવાદં પ્રચારયત| ");
INSERT INTO sanguj_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","તત્ર યઃ કશ્ચિદ્ વિશ્વસ્ય મજ્જિતો ભવેત્ સ પરિત્રાસ્યતે કિન્તુ યો ન વિશ્વસિષ્યતિ સ દણ્ડયિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","કિઞ્ચ યે પ્રત્યેષ્યન્તિ તૈરીદૃગ્ આશ્ચર્ય્યં કર્મ્મ પ્રકાશયિષ્યતે તે મન્નામ્ના ભૂતાન્ ત્યાજયિષ્યન્તિ ભાષા અન્યાશ્ચ વદિષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","અપરં તૈઃ સર્પેષુ ધૃતેષુ પ્રાણનાશકવસ્તુનિ પીતે ચ તેષાં કાપિ ક્ષતિ ર્ન ભવિષ્યતિ; રોગિણાં ગાત્રેષુ કરાર્પિતે તેઽરોગા ભવિષ્યન્તિ ચ| ");
INSERT INTO sanguj_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","અથ પ્રભુસ્તાનિત્યાદિશ્ય સ્વર્ગં નીતઃ સન્ પરમેશ્વરસ્ય દક્ષિણ ઉપવિવેશ| ");
INSERT INTO sanguj_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","તતસ્તે પ્રસ્થાય સર્વ્વત્ર સુસંવાદીયકથાં પ્રચારયિતુમારેભિરે પ્રભુસ્તુ તેષાં સહાયઃ સન્ પ્રકાશિતાશ્ચર્ય્યક્રિયાભિસ્તાં કથાં પ્રમાણવતીં ચકાર| ઇતિ|");
INSERT INTO sanguj_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","પ્રથમતો યે સાક્ષિણો વાક્યપ્રચારકાશ્ચાસન્ તેઽસ્માકં મધ્યે યદ્યત્ સપ્રમાણં વાક્યમર્પયન્તિ સ્મ ");
INSERT INTO sanguj_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","તદનુસારતોઽન્યેપિ બહવસ્તદ્વૃત્તાન્તં રચયિતું પ્રવૃત્તાઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","અતએવ હે મહામહિમથિયફિલ્ ત્વં યા યાઃ કથા અશિક્ષ્યથાસ્તાસાં દૃઢપ્રમાણાનિ યથા પ્રાપ્નોષિ ");
INSERT INTO sanguj_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","તદર્થં પ્રથમમારભ્ય તાનિ સર્વ્વાણિ જ્ઞાત્વાહમપિ અનુક્રમાત્ સર્વ્વવૃત્તાન્તાન્ તુભ્યં લેખિતું મતિમકાર્ષમ્| ");
INSERT INTO sanguj_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","યિહૂદાદેશીયહેરોદ્નામકે રાજત્વં કુર્વ્વતિ અબીયયાજકસ્ય પર્ય્યાયાધિકારી સિખરિયનામક એકો યાજકો હારોણવંશોદ્ભવા ઇલીશેવાખ્યા ");
INSERT INTO sanguj_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","તસ્ય જાયા દ્વાવિમૌ નિર્દોષૌ પ્રભોઃ સર્વ્વાજ્ઞા વ્યવસ્થાશ્ચ સંમન્ય ઈશ્વરદૃષ્ટૌ ધાર્મ્મિકાવાસ્તામ્| ");
INSERT INTO sanguj_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","તયોઃ સન્તાન એકોપિ નાસીત્, યત ઇલીશેવા બન્ધ્યા તૌ દ્વાવેવ વૃદ્ધાવભવતામ્| ");
INSERT INTO sanguj_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","યદા સ્વપર્ય્યાનુક્રમેણ સિખરિય ઈશ્વાસ્ય સમક્ષં યાજકીયં કર્મ્મ કરોતિ ");
INSERT INTO sanguj_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","તદા યજ્ઞસ્ય દિનપરિપાય્યા પરમેશ્વરસ્ય મન્દિરે પ્રવેશકાલે ધૂપજ્વાલનં કર્મ્મ તસ્ય કરણીયમાસીત્| ");
INSERT INTO sanguj_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","તદ્ધૂપજ્વાલનકાલે લોકનિવહે પ્રાર્થનાં કર્તું બહિસ્તિષ્ઠતિ ");
INSERT INTO sanguj_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","સતિ સિખરિયો યસ્યાં વેદ્યાં ધૂપં જ્વાલયતિ તદ્દક્ષિણપાર્શ્વે પરમેશ્વરસ્ય દૂત એક ઉપસ્થિતો દર્શનં દદૌ| ");
INSERT INTO sanguj_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","તં દૃષ્ટ્વા સિખરિય ઉદ્વિવિજે શશઙ્કે ચ| ");
INSERT INTO sanguj_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","તદા સ દૂતસ્તં બભાષે હે સિખરિય મા ભૈસ્તવ પ્રાર્થના ગ્રાહ્યા જાતા તવ ભાર્ય્યા ઇલીશેવા પુત્રં પ્રસોષ્યતે તસ્ય નામ યોेહન્ ઇતિ કરિષ્યસિ| ");
INSERT INTO sanguj_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","કિઞ્ચ ત્વં સાનન્દઃ સહર્ષશ્ચ ભવિષ્યસિ તસ્ય જન્મનિ બહવ આનન્દિષ્યન્તિ ચ| ");
INSERT INTO sanguj_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","યતો હેતોઃ સ પરમેશ્વરસ્ય ગોચરે મહાન્ ભવિષ્યતિ તથા દ્રાક્ષારસં સુરાં વા કિમપિ ન પાસ્યતિ, અપરં જન્મારભ્ય પવિત્રેણાત્મના પરિપૂર્ણઃ ");
INSERT INTO sanguj_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","સન્ ઇસ્રાયેલ્વંશીયાન્ અનેકાન્ પ્રભોઃ પરમેશ્વરસ્ય માર્ગમાનેષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","સન્તાનાન્ પ્રતિ પિતૃણાં મનાંસિ ધર્મ્મજ્ઞાનં પ્રત્યનાજ્ઞાગ્રાહિણશ્ચ પરાવર્ત્તયિતું, પ્રભોઃ પરમેશ્વરસ્ય સેવાર્થમ્ એકાં સજ્જિતજાતિં વિધાતુઞ્ચ સ એલિયરૂપાત્મશક્તિપ્રાપ્તસ્તસ્યાગ્રે ગમિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","તદા સિખરિયો દૂતમવાદીત્ કથમેતદ્ વેત્સ્યામિ? યતોહં વૃદ્ધો મમ ભાર્ય્યા ચ વૃદ્ધા| ");
INSERT INTO sanguj_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","તતો દૂતઃ પ્રત્યુવાચ પશ્યેશ્વરસ્ય સાક્ષાદ્વર્ત્તી જિબ્રાયેલ્નામા દૂતોહં ત્વયા સહ કથાં ગદિતું તુભ્યમિમાં શુભવાર્ત્તાં દાતુઞ્ચ પ્રેષિતઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","કિન્તુ મદીયં વાક્યં કાલે ફલિષ્યતિ તત્ ત્વયા ન પ્રતીતમ્ અતઃ કારણાદ્ યાવદેવ તાનિ ન સેત્સ્યન્તિ તાવત્ ત્વં વક્તુંમશક્તો મૂકો ભવ| ");
INSERT INTO sanguj_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","તદાનીં યે યે લોકાઃ સિખરિયમપૈક્ષન્ત તે મધ્યેમન્દિરં તસ્ય બહુવિલમ્બાદ્ આશ્ચર્ય્યં મેનિરે| ");
INSERT INTO sanguj_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","સ બહિરાગતો યદા કિમપિ વાક્યં વક્તુમશક્તઃ સઙ્કેતં કૃત્વા નિઃશબ્દસ્તસ્યૌ તદા મધ્યેમન્દિરં કસ્યચિદ્ દર્શનં તેન પ્રાપ્તમ્ ઇતિ સર્વ્વે બુબુધિરે| ");
INSERT INTO sanguj_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","અનન્તરં તસ્ય સેવનપર્ય્યાયે સમ્પૂર્ણે સતિ સ નિજગેહં જગામ| ");
INSERT INTO sanguj_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","કતિપયદિનેષુ ગતેષુ તસ્ય ભાર્ય્યા ઇલીશેવા ગર્બ્ભવતી બભૂવ ");
INSERT INTO sanguj_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","પશ્ચાત્ સા પઞ્ચમાસાન્ સંગોપ્યાકથયત્ લોકાનાં સમક્ષં મમાપમાનં ખણ્ડયિતું પરમેશ્વરો મયિ દૃષ્ટિં પાતયિત્વા કર્મ્મેદૃશં કૃતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","અપરઞ્ચ તસ્યા ગર્બ્ભસ્ય ષષ્ઠે માસે જાતે ગાલીલ્પ્રદેશીયનાસરત્પુરે ");
INSERT INTO sanguj_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","દાયૂદો વંશીયાય યૂષફ્નામ્ને પુરુષાય યા મરિયમ્નામકુમારી વાગ્દત્તાસીત્ તસ્યાઃ સમીપં જિબ્રાયેલ્ દૂત ઈશ્વરેણ પ્રહિતઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","સ ગત્વા જગાદ હે ઈશ્વરાનુગૃહીતકન્યે તવ શુભં ભૂયાત્ પ્રભુઃ પરમેશ્વરસ્તવ સહાયોસ્તિ નારીણાં મધ્યે ત્વમેવ ધન્યા| ");
INSERT INTO sanguj_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","તદાનીં સા તં દૃષ્ટ્વા તસ્ય વાક્યત ઉદ્વિજ્ય કીદૃશં ભાષણમિદમ્ ઇતિ મનસા ચિન્તયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","તતો દૂતોઽવદત્ હે મરિયમ્ ભયં માકાર્ષીઃ, ત્વયિ પરમેશ્વરસ્યાનુગ્રહોસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","પશ્ય ત્વં ગર્બ્ભં ધૃત્વા પુત્રં પ્રસોષ્યસે તસ્ય નામ યીશુરિતિ કરિષ્યસિ| ");
INSERT INTO sanguj_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","સ મહાન્ ભવિષ્યતિ તથા સર્વ્વેભ્યઃ શ્રેષ્ઠસ્ય પુત્ર ઇતિ ખ્યાસ્યતિ; અપરં પ્રભુઃ પરમેશ્વરસ્તસ્ય પિતુર્દાયૂદઃ સિંહાસનં તસ્મૈ દાસ્યતિ; ");
INSERT INTO sanguj_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","તથા સ યાકૂબો વંશોપરિ સર્વ્વદા રાજત્વં કરિષ્યતિ, તસ્ય રાજત્વસ્યાન્તો ન ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","તદા મરિયમ્ તં દૂતં બભાષે નાહં પુરુષસઙ્ગં કરોમિ તર્હિ કથમેતત્ સમ્ભવિષ્યતિ? ");
INSERT INTO sanguj_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","તતો દૂતોઽકથયત્ પવિત્ર આત્મા ત્વામાશ્રાયિષ્યતિ તથા સર્વ્વશ્રેષ્ઠસ્ય શક્તિસ્તવોપરિ છાયાં કરિષ્યતિ તતો હેતોસ્તવ ગર્બ્ભાદ્ યઃ પવિત્રબાલકો જનિષ્યતે સ ઈશ્વરપુત્ર ઇતિ ખ્યાતિં પ્રાપ્સ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","અપરઞ્ચ પશ્ય તવ જ્ઞાતિરિલીશેવા યાં સર્વ્વે બન્ધ્યામવદન્ ઇદાનીં સા વાર્દ્ધક્યે સન્તાનમેકં ગર્બ્ભેઽધારયત્ તસ્ય ષષ્ઠમાસોભૂત્| ");
INSERT INTO sanguj_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","કિમપિ કર્મ્મ નાસાધ્યમ્ ઈશ્વરસ્ય| ");
INSERT INTO sanguj_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","તદા મરિયમ્ જગાદ, પશ્ય પ્રભેરહં દાસી મહ્યં તવ વાક્યાનુસારેણ સર્વ્વમેતદ્ ઘટતામ્; અનનતરં દૂતસ્તસ્યાઃ સમીપાત્ પ્રતસ્થે| ");
INSERT INTO sanguj_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","અથ કતિપયદિનાત્ પરં મરિયમ્ તસ્માત્ પર્વ્વતમયપ્રદેશીયયિહૂદાયા નગરમેકં શીઘ્રં ગત્વા ");
INSERT INTO sanguj_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","સિખરિયયાજકસ્ય ગૃહં પ્રવિશ્ય તસ્ય જાયામ્ ઇલીશેવાં સમ્બોધ્યાવદત્| ");
INSERT INTO sanguj_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","તતો મરિયમઃ સમ્બોધનવાક્યે ઇલીશેવાયાઃ કર્ણયોઃ પ્રવિષ્ટમાત્રે સતિ તસ્યા ગર્બ્ભસ્થબાલકો નનર્ત્ત| તત ઇલીશેવા પવિત્રેણાત્મના પરિપૂર્ણા સતી ");
INSERT INTO sanguj_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","પ્રોચ્ચૈર્ગદિતુમારેભે, યોષિતાં મધ્યે ત્વમેવ ધન્યા, તવ ગર્બ્ભસ્થઃ શિશુશ્ચ ધન્યઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ત્વં પ્રભોર્માતા, મમ નિવેશને ત્વયા ચરણાવર્પિતૌ, મમાદ્ય સૌભાગ્યમેતત્| ");
INSERT INTO sanguj_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","પશ્ય તવ વાક્યે મમ કર્ણયોઃ પ્રવિષ્ટમાત્રે સતિ મમોદરસ્થઃ શિશુરાનન્દાન્ નનર્ત્ત| ");
INSERT INTO sanguj_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","યા સ્ત્રી વ્યશ્વસીત્ સા ધન્યા, યતો હેતોસ્તાં પ્રતિ પરમેશ્વરોક્તં વાક્યં સર્વ્વં સિદ્ધં ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","તદાનીં મરિયમ્ જગાદ| ધન્યવાદં પરેશસ્ય કરોતિ મામકં મનઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","મમાત્મા તારકેશે ચ સમુલ્લાસં પ્રગચ્છતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","અકરોત્ સ પ્રભુ ર્દુષ્ટિં સ્વદાસ્યા દુર્ગતિં પ્રતિ| પશ્યાદ્યારભ્ય માં ધન્યાં વક્ષ્યન્તિ પુરુષાઃ સદા| ");
INSERT INTO sanguj_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","યઃ સર્વ્વશક્તિમાન્ યસ્ય નામાપિ ચ પવિત્રકં| સ એવ સુમહત્કર્મ્મ કૃતવાન્ મન્નિમિત્તકં| ");
INSERT INTO sanguj_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","યે બિભ્યતિ જનાસ્તસ્માત્ તેષાં સન્તાનપંક્તિષુ| અનુકમ્પા તદીયા ચ સર્વ્વદૈવ સુતિષ્ઠતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","સ્વબાહુબલતસ્તેન પ્રાકાશ્યત પરાક્રમઃ| મનઃકુમન્ત્રણાસાર્દ્ધં વિકીર્ય્યન્તેઽભિમાનિનઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","સિંહાસનગતાલ્લોકાન્ બલિનશ્ચાવરોહ્ય સઃ| પદેષૂચ્ચેષુ લોકાંસ્તુ ક્ષુદ્રાન્ સંસ્થાપયત્યપિ| ");
INSERT INTO sanguj_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ક્ષુધિતાન્ માનવાન્ દ્રવ્યૈરુત્તમૈઃ પરિતર્પ્ય સઃ| સકલાન્ ધનિનો લોકાન્ વિસૃજેદ્ રિક્તહસ્તકાન્| ");
INSERT INTO sanguj_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ઇબ્રાહીમિ ચ તદ્વંશે યા દયાસ્તિ સદૈવ તાં| સ્મૃત્વા પુરા પિતૃણાં નો યથા સાક્ષાત્ પ્રતિશ્રુતં| ");
INSERT INTO sanguj_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ઇસ્રાયેલ્સેવકસ્તેન તથોપક્રિયતે સ્વયં|| ");
INSERT INTO sanguj_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","અનન્તરં મરિયમ્ પ્રાયેણ માસત્રયમ્ ઇલીશેવયા સહોષિત્વા વ્યાઘુય્ય નિજનિવેશનં યયૌ| ");
INSERT INTO sanguj_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","તદનન્તરમ્ ઇલીશેવાયાઃ પ્રસવકાલ ઉપસ્થિતે સતિ સા પુત્રં પ્રાસોષ્ટ| ");
INSERT INTO sanguj_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","તતઃ પરમેશ્વરસ્તસ્યાં મહાનુગ્રહં કૃતવાન્ એતત્ શ્રુત્વા સમીપવાસિનઃ કુટુમ્બાશ્ચાગત્ય તયા સહ મુમુદિરે| ");
INSERT INTO sanguj_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","તથાષ્ટમે દિને તે બાલકસ્ય ત્વચં છેત્તુમ્ એત્ય તસ્ય પિતૃનામાનુરૂપં તન્નામ સિખરિય ઇતિ કર્ત્તુમીષુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","કિન્તુ તસ્ય માતાકથયત્ તન્ન, નામાસ્ય યોહન્ ઇતિ કર્ત્તવ્યમ્| ");
INSERT INTO sanguj_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","તદા તે વ્યાહરન્ તવ વંશમધ્યે નામેદૃશં કસ્યાપિ નાસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","તતઃ પરં તસ્ય પિતરં સિખરિયં પ્રતિ સઙ્કેત્ય પપ્રચ્છુઃ શિશોઃ કિં નામ કારિષ્યતે? ");
INSERT INTO sanguj_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","તતઃ સ ફલકમેકં યાચિત્વા લિલેખ તસ્ય નામ યોહન્ ભવિષ્યતિ| તસ્માત્ સર્વ્વે આશ્ચર્ય્યં મેનિરે| ");
INSERT INTO sanguj_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","તત્ક્ષણં સિખરિયસ્ય જિહ્વાજાડ્યેઽપગતે સ મુખં વ્યાદાય સ્પષ્ટવર્ણમુચ્ચાર્ય્ય ઈશ્વરસ્ય ગુણાનુવાદં ચકાર| ");
INSERT INTO sanguj_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","તસ્માચ્ચતુર્દિક્સ્થાઃ સમીપવાસિલોકા ભીતા એવમેતાઃ સર્વ્વાઃ કથા યિહૂદાયાઃ પર્વ્વતમયપ્રદેશસ્ય સર્વ્વત્ર પ્રચારિતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","તસ્માત્ શ્રોતારો મનઃસુ સ્થાપયિત્વા કથયામ્બભૂવુઃ કીદૃશોયં બાલો ભવિષ્યતિ? અથ પરમેશ્વરસ્તસ્ય સહાયોભૂત્| ");
INSERT INTO sanguj_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","તદા યોહનઃ પિતા સિખરિયઃ પવિત્રેણાત્મના પરિપૂર્ણઃ સન્ એતાદૃશં ભવિષ્યદ્વાક્યં કથયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","ઇસ્રાયેલઃ પ્રભુ ર્યસ્તુ સ ધન્યઃ પરમેશ્વરઃ| અનુગૃહ્ય નિજાલ્લોકાન્ સ એવ પરિમોચયેત્| ");
INSERT INTO sanguj_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","વિપક્ષજનહસ્તેભ્યો યથા મોચ્યામહે વયં| યાવજ્જીવઞ્ચ ધર્મ્મેણ સારલ્યેન ચ નિર્ભયાઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","સેવામહૈ તમેવૈકમ્ એતત્કારણમેવ ચ| સ્વકીયં સુપવિત્રઞ્ચ સંસ્મૃત્ય નિયમં સદા| ");
INSERT INTO sanguj_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","કૃપયા પુરુષાન્ પૂર્વ્વાન્ નિકષાર્થાત્તુ નઃ પિતુઃ| ઇબ્રાહીમઃ સમીપે યં શપથં કૃતવાન્ પુરા| ");
INSERT INTO sanguj_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","તમેવ સફલં કર્ત્તં તથા શત્રુગણસ્ય ચ| ઋृતીયાકારિણશ્ચૈવ કરેભ્યો રક્ષણાય નઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","સૃષ્ટેઃ પ્રથમતઃ સ્વીયૈઃ પવિત્રૈ ર્ભાવિવાદિભિઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","યથોક્તવાન્ તથા સ્વસ્ય દાયૂદઃ સેવકસ્ય તુ| ");
INSERT INTO sanguj_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","વંશે ત્રાતારમેકં સ સમુત્પાદિતવાન્ સ્વયમ્| ");
INSERT INTO sanguj_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","અતો હે બાલક ત્વન્તુ સર્વ્વેભ્યઃ શ્રેષ્ઠ એવ યઃ| તસ્યૈવ ભાવિવાદીતિ પ્રવિખ્યાતો ભવિષ્યસિ| અસ્માકં ચરણાન્ ક્ષેમે માર્ગે ચાલયિતું સદા| એવં ધ્વાન્તેઽર્થતો મૃત્યોશ્છાયાયાં યે તુ માનવાઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ઉપવિષ્ટાસ્તુ તાનેવ પ્રકાશયિતુમેવ હિ| કૃત્વા મહાનુકમ્પાં હિ યામેવ પરમેશ્વરઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ઊર્દ્વ્વાત્ સૂર્ય્યમુદાય્યૈવાસ્મભ્યં પ્રાદાત્તુ દર્શનં| તયાનુકમ્પયા સ્વસ્ય લોકાનાં પાપમોચને| ");
INSERT INTO sanguj_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","પરિત્રાણસ્ય તેભ્યો હિ જ્ઞાનવિશ્રાણનાય ચ| પ્રભો ર્માર્ગં પરિષ્કર્ત્તું તસ્યાગ્રાયી ભવિષ્યસિ|| ");
INSERT INTO sanguj_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","અથ બાલકઃ શરીરેણ બુદ્ધ્યા ચ વર્દ્ધિતુમારેભે; અપરઞ્ચ સ ઇસ્રાયેલો વંશીયલોકાનાં સમીપે યાવન્ન પ્રકટીભૂતસ્તાસ્તાવત્ પ્રાન્તરે ન્યવસત્| ");
INSERT INTO sanguj_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","અપરઞ્ચ તસ્મિન્ કાલે રાજ્યસ્ય સર્વ્વેષાં લોકાનાં નામાનિ લેખયિતુમ્ અગસ્તકૈસર આજ્ઞાપયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","તદનુસારેણ કુરીણિયનામનિ સુરિયાદેશસ્ય શાસકે સતિ નામલેખનં પ્રારેભે| ");
INSERT INTO sanguj_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","અતો હેતો ર્નામ લેખિતું સર્વ્વે જનાઃ સ્વીયં સ્વીયં નગરં જગ્મુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","તદાનીં યૂષફ્ નામ લેખિતું વાગ્દત્તયા સ્વભાર્ય્યયા ગર્બ્ભવત્યા મરિયમા સહ સ્વયં દાયૂદઃ સજાતિવંશ ઇતિ કારણાદ્ ગાલીલ્પ્રદેશસ્ય નાસરત્નગરાદ્ ");
INSERT INTO sanguj_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","યિહૂદાપ્રદેશસ્ય બૈત્લેહમાખ્યં દાયૂદ્નગરં જગામ| ");
INSERT INTO sanguj_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","અન્યચ્ચ તત્ર સ્થાને તયોસ્તિષ્ઠતોઃ સતો ર્મરિયમઃ પ્રસૂતિકાલ ઉપસ્થિતે ");
INSERT INTO sanguj_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","સા તં પ્રથમસુતં પ્રાસોષ્ટ કિન્તુ તસ્મિન્ વાસગૃહે સ્થાનાભાવાદ્ બાલકં વસ્ત્રેણ વેષ્ટયિત્વા ગોશાલાયાં સ્થાપયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","અનન્તરં યે કિયન્તો મેષપાલકાઃ સ્વમેષવ્રજરક્ષાયૈ તત્પ્રદેશે સ્થિત્વા રજન્યાં પ્રાન્તરે પ્રહરિણઃ કર્મ્મ કુર્વ્વન્તિ, ");
INSERT INTO sanguj_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","તેષાં સમીપં પરમેશ્વરસ્ય દૂત આગત્યોપતસ્થૌ; તદા ચતુષ્પાર્શ્વે પરમેશ્વરસ્ય તેજસઃ પ્રકાશિતત્વાત્ તેઽતિશશઙ્કિરે| ");
INSERT INTO sanguj_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","તદા સ દૂત ઉવાચ મા ભૈષ્ટ પશ્યતાદ્ય દાયૂદઃ પુરે યુષ્મન્નિમિત્તં ત્રાતા પ્રભુઃ ખ્રીષ્ટોઽજનિષ્ટ, ");
INSERT INTO sanguj_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","સર્વ્વેષાં લોકાનાં મહાનન્દજનકમ્ ઇમં મઙ્ગલવૃત્તાન્તં યુષ્માન્ જ્ઞાપયામિ| ");
INSERT INTO sanguj_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","યૂયં (તત્સ્થાનં ગત્વા) વસ્ત્રવેષ્ટિતં તં બાલકં ગોશાલાયાં શયનં દ્રક્ષ્યથ યુષ્માન્ પ્રતીદં ચિહ્નં ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","દૂત ઇમાં કથાં કથિતવતિ તત્રાકસ્માત્ સ્વર્ગીયાઃ પૃતના આગત્ય કથામ્ ઇમાં કથયિત્વેશ્વરસ્ય ગુણાનન્વવાદિષુઃ, યથા, ");
INSERT INTO sanguj_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","સર્વ્વોર્દ્વ્વસ્થૈરીશ્વરસ્ય મહિમા સમ્પ્રકાશ્યતાં| શાન્તિર્ભૂયાત્ પૃથિવ્યાસ્તુ સન્તોષશ્ચ નરાન્ પ્રતિ|| ");
INSERT INTO sanguj_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","તતઃ પરં તેષાં સન્નિધે ર્દૂતગણે સ્વર્ગં ગતે મેષપાલકાઃ પરસ્પરમ્ અવેચન્ આગચ્છત પ્રભુઃ પરમેશ્વરો યાં ઘટનાં જ્ઞાપિતવાન્ તસ્યા યાથર્યં જ્ઞાતું વયમધુના બૈત્લેહમ્પુરં યામઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","પશ્ચાત્ તે તૂર્ણં વ્રજિત્વા મરિયમં યૂષફં ગોશાલાયાં શયનં બાલકઞ્ચ દદૃશુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ઇત્થં દૃષ્ટ્વા બાલકસ્યાર્થે પ્રોક્તાં સર્વ્વકથાં તે પ્રાચારયાઞ્ચક્રુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","તતો યે લોકા મેષરક્ષકાણાં વદનેભ્યસ્તાં વાર્ત્તાં શુશ્રુવુસ્તે મહાશ્ચર્ય્યં મેનિરે| ");
INSERT INTO sanguj_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","કિન્તુ મરિયમ્ એતત્સર્વ્વઘટનાનાં તાત્પર્ય્યં વિવિચ્ય મનસિ સ્થાપયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","તત્પશ્ચાદ્ દૂતવિજ્ઞપ્તાનુરૂપં શ્રુત્વા દૃષ્ટ્વા ચ મેષપાલકા ઈશ્વરસ્ય ગુણાનુવાદં ધન્યવાદઞ્ચ કુર્વ્વાણાઃ પરાવૃત્ય યયુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","અથ બાલકસ્ય ત્વક્છેદનકાલેઽષ્ટમદિવસે સમુપસ્થિતે તસ્ય ગર્બ્ભસ્થિતેઃ પુર્વ્વં સ્વર્ગીયદૂતો યથાજ્ઞાપયત્ તદનુરૂપં તે તન્નામધેયં યીશુરિતિ ચક્રિરે| ");
INSERT INTO sanguj_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","તતઃ પરં મૂસાલિખિતવ્યવસ્થાયા અનુસારેણ મરિયમઃ શુચિત્વકાલ ઉપસ્થિતે, ");
INSERT INTO sanguj_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","\"પ્રથમજઃ સર્વ્વઃ પુરુષસન્તાનઃ પરમેશ્વરે સમર્પ્યતાં,\" ઇતિ પરમેશ્વરસ્ય વ્યવસ્થયા ");
INSERT INTO sanguj_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","યીશું પરમેશ્વરે સમર્પયિતુમ્ શાસ્ત્રીયવિધ્યુક્તં કપોતદ્વયં પારાવતશાવકદ્વયં વા બલિં દાતું તે તં ગૃહીત્વા યિરૂશાલમમ્ આયયુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","યિરૂશાલમ્પુરનિવાસી શિમિયોન્નામા ધાર્મ્મિક એક આસીત્ સ ઇસ્રાયેલઃ સાન્ત્વનામપેક્ષ્ય તસ્થૌ કિઞ્ચ પવિત્ર આત્મા તસ્મિન્નાવિર્ભૂતઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","અપરં પ્રભુણા પરમેશ્વરેણાભિષિક્તે ત્રાતરિ ત્વયા ન દૃષ્ટે ત્વં ન મરિષ્યસીતિ વાક્યં પવિત્રેણ આત્મના તસ્મ પ્રાકથ્યત| ");
INSERT INTO sanguj_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","અપરઞ્ચ યદા યીશોઃ પિતા માતા ચ તદર્થં વ્યવસ્થાનુરૂપં કર્મ્મ કર્ત્તું તં મન્દિરમ્ આનિન્યતુસ્તદા ");
INSERT INTO sanguj_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","શિમિયોન્ આત્મન આકર્ષણેન મન્દિરમાગત્ય તં ક્રોડે નિધાય ઈશ્વરસ્ય ધન્યવાદં કૃત્વા કથયામાસ, યથા, ");
INSERT INTO sanguj_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","હે પ્રભો તવ દાસોયં નિજવાક્યાનુસારતઃ| ઇદાનીન્તુ સકલ્યાણો ભવતા સંવિસૃજ્યતામ્| ");
INSERT INTO sanguj_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","યતઃ સકલદેશસ્ય દીપ્તયે દીપ્તિરૂપકં| ");
INSERT INTO sanguj_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ઇસ્રાયેલીયલોકસ્ય મહાગૌરવરૂપકં| ");
INSERT INTO sanguj_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","યં ત્રાયકં જનાનાન્તુ સમ્મુખે ત્વમજીજનઃ| સએવ વિદ્યતેઽસ્માકં ધ્રવં નયનનગોચરે|| ");
INSERT INTO sanguj_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","તદાનીં તેનોક્તા એતાઃ સકલાઃ કથાઃ શ્રુત્વા તસ્ય માતા યૂષફ્ ચ વિસ્મયં મેનાતે| ");
INSERT INTO sanguj_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","તતઃ પરં શિમિયોન્ તેભ્ય આશિષં દત્ત્વા તન્માતરં મરિયમમ્ ઉવાચ, પશ્ય ઇસ્રાયેલો વંશમધ્યે બહૂનાં પાતનાયોત્થાપનાય ચ તથા વિરોધપાત્રં ભવિતું, બહૂનાં ગુપ્તમનોગતાનાં પ્રકટીકરણાય બાલકોયં નિયુક્તોસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","તસ્માત્ તવાપિ પ્રાણાઃ શૂલેન વ્યત્સ્યન્તે| ");
INSERT INTO sanguj_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","અપરઞ્ચ આશેરસ્ય વંશીયફિનૂયેલો દુહિતા હન્નાખ્યા અતિજરતી ભવિષ્યદ્વાદિન્યેકા યા વિવાહાત્ પરં સપ્ત વત્સરાન્ પત્યા સહ ન્યવસત્ તતો વિધવા ભૂત્વા ચતુરશીતિવર્ષવયઃપર્ય્યનતં ");
INSERT INTO sanguj_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","મન્દિરે સ્થિત્વા પ્રાર્થનોપવાસૈર્દિવાનિશમ્ ઈશ્વરમ્ અસેવત સાપિ સ્ત્રી તસ્મિન્ સમયે મન્દિરમાગત્ય ");
INSERT INTO sanguj_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","પરમેશ્વરસ્ય ધન્યવાદં ચકાર, યિરૂશાલમ્પુરવાસિનો યાવન્તો લોકા મુક્તિમપેક્ષ્ય સ્થિતાસ્તાન્ યીશોર્વૃત્તાન્તં જ્ઞાપયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ઇત્થં પરમેશ્વરસ્ય વ્યવસ્થાનુસારેણ સર્વ્વેષુ કર્મ્મસુ કૃતેષુ તૌ પુનશ્ચ ગાલીલો નાસરત્નામકં નિજનગરં પ્રતસ્થાતે| ");
INSERT INTO sanguj_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","તત્પશ્ચાદ્ બાલકઃ શરીરેણ વૃદ્ધિમેત્ય જ્ઞાનેન પરિપૂર્ણ આત્મના શક્તિમાંશ્ચ ભવિતુમારેભે તથા તસ્મિન્ ઈશ્વરાનુગ્રહો બભૂવ| ");
INSERT INTO sanguj_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","તસ્ય પિતા માતા ચ પ્રતિવર્ષં નિસ્તારોત્સવસમયે યિરૂશાલમમ્ અગચ્છતામ્| ");
INSERT INTO sanguj_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","અપરઞ્ચ યીશૌ દ્વાદશવર્ષવયસ્કે સતિ તૌ પર્વ્વસમયસ્ય રીત્યનુસારેણ યિરૂશાલમં ગત્વા ");
INSERT INTO sanguj_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","પાર્વ્વણં સમ્પાદ્ય પુનરપિ વ્યાઘુય્ય યાતઃ કિન્તુ યીશુર્બાલકો યિરૂશાલમિ તિષ્ઠતિ| યૂષફ્ તન્માતા ચ તદ્ અવિદિત્વા ");
INSERT INTO sanguj_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","સ સઙ્ગિભિઃ સહ વિદ્યત એતચ્ચ બુદ્વ્વા દિનૈકગમ્યમાર્ગં જગ્મતુઃ| કિન્તુ શેષે જ્ઞાતિબન્ધૂનાં સમીપે મૃગયિત્વા તદુદ્દેेશમપ્રાપ્ય ");
INSERT INTO sanguj_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","તૌ પુનરપિ યિરૂશાલમમ્ પરાવૃત્યાગત્ય તં મૃગયાઞ્ચક્રતુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","અથ દિનત્રયાત્ પરં પણ્ડિતાનાં મધ્યે તેષાં કથાઃ શૃણ્વન્ તત્ત્વં પૃચ્છંશ્ચ મન્દિરે સમુપવિષ્ટઃ સ તાભ્યાં દૃષ્ટઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","તદા તસ્ય બુદ્ધ્યા પ્રત્યુત્તરૈશ્ચ સર્વ્વે શ્રોતારો વિસ્મયમાપદ્યન્તે| ");
INSERT INTO sanguj_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","તાદૃશં દૃષ્ટ્વા તસ્ય જનકો જનની ચ ચમચ્ચક્રતુઃ કિઞ્ચ તસ્ય માતા તમવદત્, હે પુત્ર, કથમાવાં પ્રતીત્થં સમાચરસ્ત્વમ્? પશ્ય તવ પિતાહઞ્ચ શોકાકુલૌ સન્તૌ ત્વામન્વિચ્છાવઃ સ્મ| ");
INSERT INTO sanguj_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","તતઃ સોવદત્ કુતો મામ્ અન્વૈચ્છતં? પિતુર્ગૃહે મયા સ્થાતવ્યમ્ એતત્ કિં યુવાભ્યાં ન જ્ઞાયતે? ");
INSERT INTO sanguj_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","કિન્તુ તૌ તસ્યૈતદ્વાક્યસ્ય તાત્પર્ય્યં બોદ્ધું નાશક્નુતાં| ");
INSERT INTO sanguj_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","તતઃ પરં સ તાભ્યાં સહ નાસરતં ગત્વા તયોર્વશીભૂતસ્તસ્થૌ કિન્તુ સર્વ્વા એતાઃ કથાસ્તસ્ય માતા મનસિ સ્થાપયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","અથ યીશો ર્બુદ્ધિઃ શરીરઞ્ચ તથા તસ્મિન્ ઈશ્વરસ્ય માનવાનાઞ્ચાનુગ્રહો વર્દ્ધિતુમ્ આરેભે| ");
INSERT INTO sanguj_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","અનન્તરં તિબિરિયકૈસરસ્ય રાજત્વસ્ય પઞ્ચદશે વત્સરે સતિ યદા પન્તીયપીલાતો યિહૂદાદેશાધિપતિ ર્હેરોદ્ તુ ગાલીલ્પ્રદેશસ્ય રાજા ફિલિપનામા તસ્ય ભ્રાતા તુ યિતૂરિયાયાસ્ત્રાખોનીતિયાપ્રદેશસ્ય ચ રાજાસીત્ લુષાનીયનામા અવિલીનીદેશસ્ય રાજાસીત્ ");
INSERT INTO sanguj_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","હાનન્ કિયફાશ્ચેમૌ પ્રધાનયાજાકાવાસ્તાં તદાનીં સિખરિયસ્ય પુત્રાય યોહને મધ્યેપ્રાન્તરમ્ ઈશ્વરસ્ય વાક્યે પ્રકાશિતે સતિ ");
INSERT INTO sanguj_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","સ યર્દ્દન ઉભયતટપ્રદેશાન્ સમેત્ય પાપમોચનાર્થં મનઃપરાવર્ત્તનસ્ય ચિહ્નરૂપં યન્મજ્જનં તદીયાઃ કથાઃ સર્વ્વત્ર પ્રચારયિતુમારેભે| ");
INSERT INTO sanguj_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","યિશયિયભવિષ્યદ્વક્તૃગ્રન્થે યાદૃશી લિપિરાસ્તે યથા, પરમેશસ્ય પન્થાનં પરિષ્કુરુત સર્વ્વતઃ| તસ્ય રાજપથઞ્ચૈવ સમાનં કુરુતાધુના| ");
INSERT INTO sanguj_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","કારિષ્યન્તે સમુચ્છ્રાયાઃ સકલા નિમ્નભૂમયઃ| કારિષ્યન્તે નતાઃ સર્વ્વે પર્વ્વતાશ્ચોપપર્વ્વતાઃ| કારિષ્યન્તે ચ યા વક્રાસ્તાઃ સર્વ્વાઃ સરલા ભુવઃ| કારિષ્યન્તે સમાનાસ્તા યા ઉચ્ચનીચભૂમયઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ઈશ્વરેણ કૃતં ત્રાણં દ્રક્ષ્યન્તિ સર્વ્વમાનવાઃ| ઇત્યેતત્ પ્રાન્તરે વાક્યં વદતઃ કસ્યચિદ્ રવઃ|| ");
INSERT INTO sanguj_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","યે યે લોકા મજ્જનાર્થં બહિરાયયુસ્તાન્ સોવદત્ રે રે સર્પવંશા આગામિનઃ કોપાત્ પલાયિતું યુષ્માન્ કશ્ચેતયામાસ? ");
INSERT INTO sanguj_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","તસ્માદ્ ઇબ્રાહીમ્ અસ્માકં પિતા કથામીદૃશીં મનોભિ ર્ન કથયિત્વા યૂયં મનઃપરિવર્ત્તનયોગ્યં ફલં ફલત; યુષ્માનહં યથાર્થં વદામિ પાષાણેભ્ય એતેભ્ય ઈશ્વર ઇબ્રાહીમઃ સન્તાનોત્પાદને સમર્થઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","અપરઞ્ચ તરુમૂલેઽધુનાપિ પરશુઃ સંલગ્નોસ્તિ યસ્તરુરુત્તમં ફલં ન ફલતિ સ છિદ્યતેઽગ્નૌ નિક્ષિપ્યતે ચ| ");
INSERT INTO sanguj_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","તદાનીં લોકાસ્તં પપ્રચ્છુસ્તર્હિ કિં કર્ત્તવ્યમસ્માભિઃ? ");
INSERT INTO sanguj_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","તતઃ સોવાદીત્ યસ્ય દ્વે વસને વિદ્યેતે સ વસ્ત્રહીનાયૈકં વિતરતુ કિંઞ્ચ યસ્ય ખાદ્યદ્રવ્યં વિદ્યતે સોપિ તથૈવ કરોતુ| ");
INSERT INTO sanguj_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","તતઃ પરં કરસઞ્ચાયિનો મજ્જનાર્થમ્ આગત્ય પપ્રચ્છુઃ હે ગુરો કિં કર્ત્તવ્યમસ્માભિઃ? ");
INSERT INTO sanguj_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","તતઃ સોકથયત્ નિરૂપિતાદધિકં ન ગૃહ્લિત| ");
INSERT INTO sanguj_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","અનન્તરં સેનાગણ એત્ય પપ્રચ્છ કિમસ્માભિ ર્વા કર્ત્તવ્યમ્? તતઃ સોભિદધે કસ્ય કામપિ હાનિં મા કાર્ષ્ટ તથા મૃષાપવાદં મા કુરુત નિજવેતનેન ચ સન્તુષ્ય તિષ્ઠત| ");
INSERT INTO sanguj_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","અપરઞ્ચ લોકા અપેક્ષયા સ્થિત્વા સર્વ્વેપીતિ મનોભિ ર્વિતર્કયાઞ્ચક્રુઃ, યોહનયમ્ અભિષિક્તસ્ત્રાતા ન વેતિ? ");
INSERT INTO sanguj_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","તદા યોહન્ સર્વ્વાન્ વ્યાજહાર, જલેઽહં યુષ્માન્ મજ્જયામિ સત્યં કિન્તુ યસ્ય પાદુકાબન્ધનં મોચયિતુમપિ ન યોગ્યોસ્મિ તાદૃશ એકો મત્તો ગુરુતરઃ પુમાન્ એતિ, સ યુષ્માન્ વહ્નિરૂપે પવિત્ર આત્મનિ મજ્જયિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","અપરઞ્ચ તસ્ય હસ્તે શૂર્પ આસ્તે સ સ્વશસ્યાનિ શુદ્ધરૂપં પ્રસ્ફોટ્ય ગોધૂમાન્ સર્વ્વાન્ ભાણ્ડાગારે સંગ્રહીષ્યતિ કિન્તુ બૂષાણિ સર્વ્વાણ્યનિર્વ્વાણવહ્નિના દાહયિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","યોહન્ ઉપદેશેનેત્થં નાનાકથા લોકાનાં સમક્ષં પ્રચારયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","અપરઞ્ચ હેરોદ્ રાજા ફિલિપ્નામ્નઃ સહોદરસ્ય ભાર્ય્યાં હેરોદિયામધિ તથાન્યાનિ યાનિ યાનિ કુકર્મ્માણિ કૃતવાન્ તદધિ ચ ");
INSERT INTO sanguj_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","યોહના તિરસ્કૃતો ભૂત્વા કારાગારે તસ્ય બન્ધનાદ્ અપરમપિ કુકર્મ્મ ચકાર| ");
INSERT INTO sanguj_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ઇતઃ પૂર્વ્વં યસ્મિન્ સમયે સર્વ્વે યોહના મજ્જિતાસ્તદાનીં યીશુરપ્યાગત્ય મજ્જિતઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","તદનન્તરં તેન પ્રાર્થિતે મેઘદ્વારં મુક્તં તસ્માચ્ચ પવિત્ર આત્મા મૂર્ત્તિમાન્ ભૂત્વા કપોતવત્ તદુપર્ય્યવરુરોહ; તદા ત્વં મમ પ્રિયઃ પુત્રસ્ત્વયિ મમ પરમઃ સન્તોષ ઇત્યાકાશવાણી બભૂવ| ");
INSERT INTO sanguj_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","તદાનીં યીશુઃ પ્રાયેણ ત્રિંશદ્વર્ષવયસ્ક આસીત્| લૌકિકજ્ઞાને તુ સ યૂષફઃ પુત્રઃ, ");
INSERT INTO sanguj_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","યૂષફ્ એલેઃ પુત્રઃ, એલિર્મત્તતઃ પુત્રઃ, મત્તત્ લેવેઃ પુત્રઃ, લેવિ ર્મલ્કેઃ પુત્રઃ, મલ્કિર્યાન્નસ્ય પુત્રઃ; યાન્નો યૂષફઃ પુત્રઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","યૂષફ્ મત્તથિયસ્ય પુત્રઃ, મત્તથિય આમોસઃ પુત્રઃ, આમોસ્ નહૂમઃ પુત્રઃ, નહૂમ્ ઇષ્લેઃ પુત્રઃ ઇષ્લિર્નગેઃ પુત્રઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","નગિર્માટઃ પુત્રઃ, માટ્ મત્તથિયસ્ય પુત્રઃ, મત્તથિયઃ શિમિયેઃ પુત્રઃ, શિમિયિર્યૂષફઃ પુત્રઃ, યૂષફ્ યિહૂદાઃ પુત્રઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","યિહૂદા યોહાનાઃ પુત્રઃ, યોહાના રીષાઃ પુત્રઃ, રીષાઃ સિરુબ્બાબિલઃ પુત્રઃ, સિરુબ્બાબિલ્ શલ્તીયેલઃ પુત્રઃ, શલ્તીયેલ્ નેરેઃ પુત્રઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","નેરિર્મલ્કેઃ પુત્રઃ, મલ્કિઃ અદ્યઃ પુત્રઃ, અદ્દી કોષમઃ પુત્રઃ, કોષમ્ ઇલ્મોદદઃ પુત્રઃ, ઇલ્મોદદ્ એરઃ પુત્રઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","એર્ યોશેઃ પુત્રઃ, યોશિઃ ઇલીયેષરઃ પુત્રઃ, ઇલીયેષર્ યોરીમઃ પુત્રઃ, યોરીમ્ મત્તતઃ પુત્રઃ, મત્તત લેવેઃ પુત્રઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","લેવિઃ શિમિયોનઃ પુત્રઃ, શિમિયોન્ યિહૂદાઃ પુત્રઃ, યિહૂદા યૂષુફઃ પુત્રઃ, યૂષુફ્ યોનનઃ પુત્રઃ, યાનન્ ઇલીયાકીમઃ પુત્રઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ઇલિયાકીમ્ઃ મિલેયાઃ પુત્રઃ, મિલેયા મૈનનઃ પુત્રઃ, મૈનન્ મત્તત્તસ્ય પુત્રઃ, મત્તત્તો નાથનઃ પુત્રઃ, નાથન્ દાયૂદઃ પુત્રઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","દાયૂદ્ યિશયઃ પુત્રઃ, યિશય ઓબેદઃ પુત્ર, ઓબેદ્ બોયસઃ પુત્રઃ, બોયસ્ સલ્મોનઃ પુત્રઃ, સલ્મોન્ નહશોનઃ પુત્રઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","નહશોન્ અમ્મીનાદબઃ પુત્રઃ, અમ્મીનાદબ્ અરામઃ પુત્રઃ, અરામ્ હિષ્રોણઃ પુત્રઃ, હિષ્રોણ્ પેરસઃ પુત્રઃ, પેરસ્ યિહૂદાઃ પુત્રઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","યિહૂદા યાકૂબઃ પુત્રઃ, યાકૂબ્ ઇસ્હાકઃ પુત્રઃ, ઇસ્હાક્ ઇબ્રાહીમઃ પુત્રઃ, ઇબ્રાહીમ્ તેરહઃ પુત્રઃ, તેરહ્ નાહોરઃ પુત્રઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","નાહોર્ સિરુગઃ પુત્રઃ, સિરુગ્ રિય્વઃ પુત્રઃ, રિયૂઃ પેલગઃ પુત્રઃ, પેલગ્ એવરઃ પુત્રઃ, એવર્ શેલહઃ પુત્રઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","શેલહ્ કૈનનઃ પુત્રઃ, કૈનન્ અર્ફક્ષદઃ પુત્રઃ, અર્ફક્ષદ્ શામઃ પુત્રઃ, શામ્ નોહઃ પુત્રઃ, નોહો લેમકઃ પુત્રઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","લેમક્ મિથૂશેલહઃ પુત્રઃ, મિથૂશેલહ્ હનોકઃ પુત્રઃ, હનોક્ યેરદઃ પુત્રઃ, યેરદ્ મહલલેલઃ પુત્રઃ, મહલલેલ્ કૈનનઃ પુત્રઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","કૈનન્ ઇનોશઃ પુત્રઃ, ઇનોશ્ શેતઃ પુત્રઃ, શેત્ આદમઃ પુત્ર, આદમ્ ઈશ્વરસ્ય પુત્રઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","તતઃ પરં યીશુઃ પવિત્રેણાત્મના પૂર્ણઃ સન્ યર્દ્દનનદ્યાઃ પરાવૃત્યાત્મના પ્રાન્તરં નીતઃ સન્ ચત્વારિંશદ્દિનાનિ યાવત્ શૈતાના પરીક્ષિતોઽભૂત્, ");
INSERT INTO sanguj_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","કિઞ્ચ તાનિ સર્વ્વદિનાનિ ભોજનં વિના સ્થિતત્વાત્ કાલે પૂર્ણે સ ક્ષુધિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","તતઃ શૈતાનાગત્ય તમવદત્ ત્વં ચેદીશ્વરસ્ય પુત્રસ્તર્હિ પ્રસ્તરાનેતાન્ આજ્ઞયા પૂપાન્ કુરુ| ");
INSERT INTO sanguj_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","તદા યીશુરુવાચ, લિપિરીદૃશી વિદ્યતે મનુજઃ કેવલેન પૂપેન ન જીવતિ કિન્ત્વીશ્વરસ્ય સર્વ્વાભિરાજ્ઞાભિ ર્જીવતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","તદા શૈતાન્ તમુચ્ચં પર્વ્વતં નીત્વા નિમિષૈકમધ્યે જગતઃ સર્વ્વરાજ્યાનિ દર્શિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","પશ્ચાત્ તમવાદીત્ સર્વ્વમ્ એતદ્ વિભવં પ્રતાપઞ્ચ તુભ્યં દાસ્યામિ તન્ મયિ સમર્પિતમાસ્તે યં પ્રતિ મમેચ્છા જાયતે તસ્મૈ દાતું શક્નોમિ, ");
INSERT INTO sanguj_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ત્વં ચેન્માં ભજસે તર્હિ સર્વ્વમેતત્ તવૈવ ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","તદા યીશુસ્તં પ્રત્યુક્તવાન્ દૂરી ભવ શૈતાન્ લિપિરાસ્તે, નિજં પ્રભું પરમેશ્વરં ભજસ્વ કેવલં તમેવ સેવસ્વ ચ| ");
INSERT INTO sanguj_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","અથ શૈતાન્ તં યિરૂશાલમં નીત્વા મન્દિરસ્ય ચૂડાયા ઉપરિ સમુપવેશ્ય જગાદ ત્વં ચેદીશ્વરસ્ય પુત્રસ્તર્હિ સ્થાનાદિતો લમ્ફિત્વાધઃ ");
INSERT INTO sanguj_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","પત યતો લિપિરાસ્તે, આજ્ઞાપયિષ્યતિ સ્વીયાન્ દૂતાન્ સ પરમેશ્વરઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","રક્ષિતું સર્વ્વમાર્ગે ત્વાં તેન ત્વચ્ચરણે યથા| ન લગેત્ પ્રસ્તરાઘાતસ્ત્વાં ધરિષ્યન્તિ તે તથા| ");
INSERT INTO sanguj_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","તદા યીશુના પ્રત્યુક્તમ્ ઇદમપ્યુક્તમસ્તિ ત્વં સ્વપ્રભું પરેશં મા પરીક્ષસ્વ| ");
INSERT INTO sanguj_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","પશ્ચાત્ શૈતાન્ સર્વ્વપરીક્ષાં સમાપ્ય ક્ષણાત્તં ત્યક્ત્વા યયૌ| ");
INSERT INTO sanguj_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","તદા યીશુરાત્મપ્રભાવાત્ પુનર્ગાલીલ્પ્રદેશં ગતસ્તદા તત્સુખ્યાતિશ્ચતુર્દિશં વ્યાનશે| ");
INSERT INTO sanguj_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","સ તેષાં ભજનગૃહેષુ ઉપદિશ્ય સર્વ્વૈઃ પ્રશંસિતો બભૂવ| ");
INSERT INTO sanguj_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","અથ સ સ્વપાલનસ્થાનં નાસરત્પુરમેત્ય વિશ્રામવારે સ્વાચારાદ્ ભજનગેહં પ્રવિશ્ય પઠિતુમુત્તસ્થૌ| ");
INSERT INTO sanguj_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","તતો યિશયિયભવિષ્યદ્વાદિનઃ પુસ્તકે તસ્ય કરદત્તે સતિ સ તત્ પુસ્તકં વિસ્તાર્ય્ય યત્ર વક્ષ્યમાણાનિ વચનાનિ સન્તિ તત્ સ્થાનં પ્રાપ્ય પપાઠ| ");
INSERT INTO sanguj_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","આત્મા તુ પરમેશસ્ય મદીયોપરિ વિદ્યતે| દરિદ્રેષુ સુસંવાદં વક્તું માં સોભિષિક્તવાન્| ભગ્નાન્તઃ કરણાલ્લોકાન્ સુસ્વસ્થાન્ કર્ત્તુમેવ ચ| બન્દીકૃતેષુ લોકેષુ મુક્તે ર્ઘોષયિતું વચઃ| નેત્રાણિ દાતુમન્ધેભ્યસ્ત્રાતું બદ્ધજનાનપિ| ");
INSERT INTO sanguj_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","પરેશાનુગ્રહે કાલં પ્રચારયિતુમેવ ચ| સર્વ્વૈતત્કરણાર્થાય મામેવ પ્રહિણોતિ સઃ|| ");
INSERT INTO sanguj_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","તતઃ પુસ્તકં બદ્વ્વા પરિચારકસ્ય હસ્તે સમર્પ્ય ચાસને સમુપવિષ્ટઃ, તતો ભજનગૃહે યાવન્તો લોકા આસન્ તે સર્વ્વેઽનન્યદૃષ્ટ્યા તં વિલુલોકિરે| ");
INSERT INTO sanguj_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","અનન્તરમ્ અદ્યૈતાનિ સર્વ્વાણિ લિખિતવચનાનિ યુષ્માકં મધ્યે સિદ્ધાનિ સ ઇમાં કથાં તેભ્યઃ કથયિતુમારેભે| ");
INSERT INTO sanguj_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","તતઃ સર્વ્વે તસ્મિન્ અન્વરજ્યન્ત, કિઞ્ચ તસ્ય મુખાન્નિર્ગતાભિરનુગ્રહસ્ય કથાભિશ્ચમત્કૃત્ય કથયામાસુઃ કિમયં યૂષફઃ પુત્રો ન? ");
INSERT INTO sanguj_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","તદા સોઽવાદીદ્ હે ચિકિત્સક સ્વમેવ સ્વસ્થં કુરુ કફર્નાહૂમિ યદ્યત્ કૃતવાન્ તદશ્રૌષ્મ તાઃ સર્વાઃ ક્રિયા અત્ર સ્વદેશે કુરુ કથામેતાં યૂયમેવાવશ્યં માં વદિષ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","પુનઃ સોવાદીદ્ યુષ્માનહં યથાર્થં વદામિ, કોપિ ભવિષ્યદ્વાદી સ્વદેશે સત્કારં ન પ્રાપ્નોતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","અપરઞ્ચ યથાર્થં વચ્મિ, એલિયસ્ય જીવનકાલે યદા સાર્દ્ધત્રિતયવર્ષાણિ યાવત્ જલદપ્રતિબન્ધાત્ સર્વ્વસ્મિન્ દેશે મહાદુર્ભિક્ષમ્ અજનિષ્ટ તદાનીમ્ ઇસ્રાયેલો દેશસ્ય મધ્યે બહ્વ્યો વિધવા આસન્, ");
INSERT INTO sanguj_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","કિન્તુ સીદોન્પ્રદેશીયસારિફત્પુરનિવાસિનીમ્ એકાં વિધવાં વિના કસ્યાશ્ચિદપિ સમીપે એલિયઃ પ્રેરિતો નાભૂત્| ");
INSERT INTO sanguj_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","અપરઞ્ચ ઇલીશાયભવિષ્યદ્વાદિવિદ્યમાનતાકાલે ઇસ્રાયેલ્દેશે બહવઃ કુષ્ઠિન આસન્ કિન્તુ સુરીયદેશીયં નામાન્કુષ્ઠિનં વિના કોપ્યન્યઃ પરિષ્કૃતો નાભૂત્| ");
INSERT INTO sanguj_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ઇમાં કથાં શ્રુત્વા ભજનગેહસ્થિતા લોકાઃ સક્રોધમ્ ઉત્થાય ");
INSERT INTO sanguj_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","નગરાત્તં બહિષ્કૃત્ય યસ્ય શિખરિણ ઉપરિ તેષાં નગરં સ્થાપિતમાસ્તે તસ્માન્નિક્ષેપ્તું તસ્ય શિખરં તં નિન્યુઃ ");
INSERT INTO sanguj_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","કિન્તુ સ તેષાં મધ્યાદપસૃત્ય સ્થાનાન્તરં જગામ| ");
INSERT INTO sanguj_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","તતઃ પરં યીશુર્ગાલીલ્પ્રદેશીયકફર્નાહૂમ્નગર ઉપસ્થાય વિશ્રામવારે લોકાનુપદેષ્ટુમ્ આરબ્ધવાન્| ");
INSERT INTO sanguj_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","તદુપદેશાત્ સર્વ્વે ચમચ્ચક્રુ ર્યતસ્તસ્ય કથા ગુરુતરા આસન્| ");
INSERT INTO sanguj_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","તદાનીં તદ્ભજનગેહસ્થિતોઽમેધ્યભૂતગ્રસ્ત એકો જન ઉચ્ચૈઃ કથયામાસ, ");
INSERT INTO sanguj_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","હે નાસરતીયયીશોઽસ્માન્ ત્યજ, ત્વયા સહાસ્માકં કઃ સમ્બન્ધઃ? કિમસ્માન્ વિનાશયિતુમાયાસિ? ત્વમીશ્વરસ્ય પવિત્રો જન એતદહં જાનામિ| ");
INSERT INTO sanguj_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","તદા યીશુસ્તં તર્જયિત્વાવદત્ મૌની ભવ ઇતો બહિર્ભવ; તતઃ સોમેધ્યભૂતસ્તં મધ્યસ્થાને પાતયિત્વા કિઞ્ચિદપ્યહિંસિત્વા તસ્માદ્ બહિર્ગતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","તતઃ સર્વ્વે લોકાશ્ચમત્કૃત્ય પરસ્પરં વક્તુમારેભિરે કોયં ચમત્કારઃ| એષ પ્રભાવેણ પરાક્રમેણ ચામેધ્યભૂતાન્ આજ્ઞાપયતિ તેનૈવ તે બહિર્ગચ્છન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","અનન્તરં ચતુર્દિક્સ્થદેશાન્ તસ્ય સુખ્યાતિર્વ્યાપ્નોત્| ");
INSERT INTO sanguj_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","તદનન્તરં સ ભજનગેહાદ્ બહિરાગત્ય શિમોનો નિવેશનં પ્રવિવેશ તદા તસ્ય શ્વશ્રૂર્જ્વરેણાત્યન્તં પીડિતાસીત્ શિષ્યાસ્તદર્થં તસ્મિન્ વિનયં ચક્રુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","તતઃ સ તસ્યાઃ સમીપે સ્થિત્વા જ્વરં તર્જયામાસ તેનૈવ તાં જ્વરોઽત્યાક્ષીત્ તતઃ સા તત્ક્ષણમ્ ઉત્થાય તાન્ સિષેવે| ");
INSERT INTO sanguj_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","અથ સૂર્ય્યાસ્તકાલે સ્વેષાં યે યે જના નાનારોગૈઃ પીડિતા આસન્ લોકાસ્તાન્ યીશોઃ સમીપમ્ આનિન્યુઃ, તદા સ એકૈકસ્ય ગાત્રે કરમર્પયિત્વા તાનરોગાન્ ચકાર| ");
INSERT INTO sanguj_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","તતો ભૂતા બહુભ્યો નિર્ગત્ય ચીત્શબ્દં કૃત્વા ચ બભાષિરે ત્વમીશ્વરસ્ય પુત્રોઽભિષિક્તત્રાતા; કિન્તુ સોભિષિક્તત્રાતેતિ તે વિવિદુરેતસ્માત્ કારણાત્ તાન્ તર્જયિત્વા તદ્વક્તું નિષિષેધ| ");
INSERT INTO sanguj_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","અપરઞ્ચ પ્રભાતે સતિ સ વિજનસ્થાનં પ્રતસ્થે પશ્ચાત્ જનાસ્તમન્વિચ્છન્તસ્તન્નિકટં ગત્વા સ્થાનાન્તરગમનાર્થં તમન્વરુન્ધન્| ");
INSERT INTO sanguj_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","કિન્તુ સ તાન્ જગાદ, ઈશ્વરીયરાજ્યસ્ય સુસંવાદં પ્રચારયિતુમ્ અન્યાનિ પુરાણ્યપિ મયા યાતવ્યાનિ યતસ્તદર્થમેવ પ્રેરિતોહં| ");
INSERT INTO sanguj_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","અથ ગાલીલો ભજનગેહેષુ સ ઉપદિદેશ| ");
INSERT INTO sanguj_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","અનન્તરં યીશુરેકદા ગિનેષરથ્દસ્ય તીર ઉત્તિષ્ઠતિ, તદા લોકા ઈશ્વરીયકથાં શ્રોતું તદુપરિ પ્રપતિતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","તદાનીં સ હ્દસ્ય તીરસમીપે નૌદ્વયં દદર્શ કિઞ્ચ મત્સ્યોપજીવિનો નાવં વિહાય જાલં પ્રક્ષાલયન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","તતસ્તયોર્દ્વયો ર્મધ્યે શિમોનો નાવમારુહ્ય તીરાત્ કિઞ્ચિદ્દૂરં યાતું તસ્મિન્ વિનયં કૃત્વા નૌકાયામુપવિશ્ય લોકાન્ પ્રોપદિષ્ટવાન્| ");
INSERT INTO sanguj_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","પશ્ચાત્ તં પ્રસ્તાવં સમાપ્ય સ શિમોનં વ્યાજહાર, ગભીરં જલં ગત્વા મત્સ્યાન્ ધર્ત્તું જાલં નિક્ષિપ| ");
INSERT INTO sanguj_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","તતઃ શિમોન બભાષે, હે ગુરો યદ્યપિ વયં કૃત્સ્નાં યામિનીં પરિશ્રમ્ય મત્સ્યૈકમપિ ન પ્રાપ્તાસ્તથાપિ ભવતો નિદેશતો જાલં ક્ષિપામઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","અથ જાલે ક્ષિપ્તે બહુમત્સ્યપતનાદ્ આનાયઃ પ્રચ્છિન્નઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","તસ્માદ્ ઉપકર્ત્તુમ્ અન્યનૌસ્થાન્ સઙ્ગિન આયાતુમ્ ઇઙ્ગિતેન સમાહ્વયન્ તતસ્ત આગત્ય મત્સ્યૈ ર્નૌદ્વયં પ્રપૂરયામાસુ ર્યૈ ર્નૌદ્વયં પ્રમગ્નમ્| ");
INSERT INTO sanguj_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","તદા શિમોન્પિતરસ્તદ્ વિલોક્ય યીશોશ્ચરણયોઃ પતિત્વા, હે પ્રભોહં પાપી નરો મમ નિકટાદ્ ભવાન્ યાતુ, ઇતિ કથિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","યતો જાલે પતિતાનાં મત્સ્યાનાં યૂથાત્ શિમોન્ તત્સઙ્ગિનશ્ચ ચમત્કૃતવન્તઃ; શિમોનઃ સહકારિણૌ સિવદેઃ પુત્રૌ યાકૂબ્ યોહન્ ચેમૌ તાદૃશૌ બભૂવતુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","તદા યીશુઃ શિમોનં જગાદ મા ભૈષીરદ્યારભ્ય ત્વં મનુષ્યધરો ભવિષ્યસિ| ");
INSERT INTO sanguj_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","અનન્તરં સર્વ્વાસુ નૌસુ તીરમ્ આનીતાસુ તે સર્વ્વાન્ પરિત્યજ્ય તસ્ય પશ્ચાદ્ગામિનો બભૂવુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","તતઃ પરં યીશૌ કસ્મિંશ્ચિત્ પુરે તિષ્ઠતિ જન એકઃ સર્વ્વાઙ્ગકુષ્ઠસ્તં વિલોક્ય તસ્ય સમીપે ન્યુબ્જઃ પતિત્વા સવિનયં વક્તુમારેભે, હે પ્રભો યદિ ભવાનિચ્છતિ તર્હિ માં પરિષ્કર્ત્તું શક્નોતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","તદાનીં સ પાણિં પ્રસાર્ય્ય તદઙ્ગં સ્પૃશન્ બભાષે ત્વં પરિષ્ક્રિયસ્વેતિ મમેચ્છાસ્તિ તતસ્તત્ક્ષણં સ કુષ્ઠાત્ મુક્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","પશ્ચાત્ સ તમાજ્ઞાપયામાસ કથામિમાં કસ્મૈચિદ્ અકથયિત્વા યાજકસ્ય સમીપઞ્ચ ગત્વા સ્વં દર્શય, લોકેભ્યો નિજપરિષ્કૃતત્વસ્ય પ્રમાણદાનાય મૂસાજ્ઞાનુસારેણ દ્રવ્યમુત્મૃજસ્વ ચ| ");
INSERT INTO sanguj_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","તથાપિ યીશોઃ સુખ્યાતિ ર્બહુ વ્યાપ્તુમારેભે કિઞ્ચ તસ્ય કથાં શ્રોતું સ્વીયરોગેભ્યો મોક્તુઞ્ચ લોકા આજગ્મુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","અથ સ પ્રાન્તરં ગત્વા પ્રાર્થયાઞ્ચક્રે| ");
INSERT INTO sanguj_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","અપરઞ્ચ એકદા યીશુરુપદિશતિ, એતર્હિ ગાલીલ્યિહૂદાપ્રદેશયોઃ સર્વ્વનગરેભ્યો યિરૂશાલમશ્ચ કિયન્તઃ ફિરૂશિલોકા વ્યવસ્થાપકાશ્ચ સમાગત્ય તદન્તિકે સમુપવિવિશુઃ, તસ્મિન્ કાલે લોકાનામારોગ્યકારણાત્ પ્રભોઃ પ્રભાવઃ પ્રચકાશે| ");
INSERT INTO sanguj_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","પશ્ચાત્ કિયન્તો લોકા એકં પક્ષાઘાતિનં ખટ્વાયાં નિધાય યીશોઃ સમીપમાનેતું સમ્મુખે સ્થાપયિતુઞ્ચ વ્યાપ્રિયન્ત| ");
INSERT INTO sanguj_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","કિન્તુ બહુજનનિવહસમ્વાધાત્ ન શક્નુવન્તો ગૃહોપરિ ગત્વા ગૃહપૃષ્ઠં ખનિત્વા તં પક્ષાઘાતિનં સખટ્વં ગૃહમધ્યે યીશોઃ સમ્મુખે ઽવરોહયામાસુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","તદા યીશુસ્તેષામ્ ઈદૃશં વિશ્વાસં વિલોક્ય તં પક્ષાઘાતિનં વ્યાજહાર, હે માનવ તવ પાપમક્ષમ્યત| ");
INSERT INTO sanguj_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","તસ્માદ્ અધ્યાપકાઃ ફિરૂશિનશ્ચ ચિત્તૈરિત્થં પ્રચિન્તિતવન્તઃ, એષ જન ઈશ્વરં નિન્દતિ કોયં? કેવલમીશ્વરં વિના પાપં ક્ષન્તું કઃ શક્નોતિ? ");
INSERT INTO sanguj_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","તદા યીશુસ્તેષામ્ ઇત્થં ચિન્તનં વિદિત્વા તેભ્યોકથયદ્ યૂયં મનોભિઃ કુતો વિતર્કયથ? ");
INSERT INTO sanguj_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","તવ પાપક્ષમા જાતા યદ્વા ત્વમુત્થાય વ્રજ એતયો ર્મધ્યે કા કથા સુકથ્યા? ");
INSERT INTO sanguj_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","કિન્તુ પૃથિવ્યાં પાપં ક્ષન્તું માનવસુતસ્ય સામર્થ્યમસ્તીતિ યથા યૂયં જ્ઞાતું શક્નુથ તદર્થં (સ તં પક્ષાઘાતિનં જગાદ) ઉત્તિષ્ઠ સ્વશય્યાં ગૃહીત્વા ગૃહં યાહીતિ ત્વામાદિશામિ| ");
INSERT INTO sanguj_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","તસ્માત્ સ તત્ક્ષણમ્ ઉત્થાય સર્વ્વેષાં સાક્ષાત્ નિજશયનીયં ગૃહીત્વા ઈશ્વરં ધન્યં વદન્ નિજનિવેશનં યયૌ| ");
INSERT INTO sanguj_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","તસ્માત્ સર્વ્વે વિસ્મય પ્રાપ્તા મનઃસુ ભીતાશ્ચ વયમદ્યાસમ્ભવકાર્ય્યાણ્યદર્શામ ઇત્યુક્ત્વા પરમેશ્વરં ધન્યં પ્રોદિતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","તતઃ પરં બહિર્ગચ્છન્ કરસઞ્ચયસ્થાને લેવિનામાનં કરસઞ્ચાયકં દૃષ્ટ્વા યીશુસ્તમભિદધે મમ પશ્ચાદેહિ| ");
INSERT INTO sanguj_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","તસ્માત્ સ તત્ક્ષણાત્ સર્વ્વં પરિત્યજ્ય તસ્ય પશ્ચાદિયાય| ");
INSERT INTO sanguj_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","અનન્તરં લેવિ ર્નિજગૃહે તદર્થં મહાભોજ્યં ચકાર, તદા તૈઃ સહાનેકે કરસઞ્ચાયિનસ્તદન્યલોકાશ્ચ ભોક્તુમુપવિવિશુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","તસ્માત્ કારણાત્ ચણ્ડાલાનાં પાપિલોકાનાઞ્ચ સઙ્ગે યૂયં કુતો ભંગ્ધ્વે પિવથ ચેતિ કથાં કથયિત્વા ફિરૂશિનોઽધ્યાપકાશ્ચ તસ્ય શિષ્યૈઃ સહ વાગ્યુદ્ધં કર્ત્તુમારેભિરે| ");
INSERT INTO sanguj_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","તસ્માદ્ યીશુસ્તાન્ પ્રત્યવોચદ્ અરોગલોકાનાં ચિકિત્સકેન પ્રયોજનં નાસ્તિ કિન્તુ સરોગાણામેવ| ");
INSERT INTO sanguj_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","અહં ધાર્મ્મિકાન્ આહ્વાતું નાગતોસ્મિ કિન્તુ મનઃ પરાવર્ત્તયિતું પાપિન એવ| ");
INSERT INTO sanguj_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","તતસ્તે પ્રોચુઃ, યોહનઃ ફિરૂશિનાઞ્ચ શિષ્યા વારંવારમ્ ઉપવસન્તિ પ્રાર્થયન્તે ચ કિન્તુ તવ શિષ્યાઃ કુતો ભુઞ્જતે પિવન્તિ ચ? ");
INSERT INTO sanguj_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","તદા સ તાનાચખ્યૌ વરે સઙ્ગે તિષ્ઠતિ વરસ્ય સખિગણં કિમુપવાસયિતું શક્નુથ? ");
INSERT INTO sanguj_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","કિન્તુ યદા તેષાં નિકટાદ્ વરો નેષ્યતે તદા તે સમુપવત્સ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","સોપરમપિ દૃષ્ટાન્તં કથયામ્બભૂવ પુરાતનવસ્ત્રે કોપિ નુતનવસ્ત્રં ન સીવ્યતિ યતસ્તેન સેવનેન જીર્ણવસ્ત્રં છિદ્યતે, નૂતનપુરાતનવસ્ત્રયો ર્મેલઞ્ચ ન ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","પુરાતન્યાં કુત્વાં કોપિ નુતનં દ્રાક્ષારસં ન નિદધાતિ, યતો નવીનદ્રાક્ષારસસ્ય તેજસા પુરાતની કુતૂ ર્વિદીર્ય્યતે તતો દ્રાક્ષારસઃ પતતિ કુતૂશ્ચ નશ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","તતો હેતો ર્નૂતન્યાં કુત્વાં નવીનદ્રાક્ષારસઃ નિધાતવ્યસ્તેનોભયસ્ય રક્ષા ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","અપરઞ્ચ પુરાતનં દ્રાક્ષારસં પીત્વા કોપિ નૂતનં ન વાઞ્છતિ, યતઃ સ વક્તિ નૂતનાત્ પુરાતનમ્ પ્રશસ્તમ્| ");
INSERT INTO sanguj_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","અચરઞ્ચ પર્વ્વણો દ્વિતીયદિનાત્ પરં પ્રથમવિશ્રામવારે શસ્યક્ષેત્રેણ યીશોર્ગમનકાલે તસ્ય શિષ્યાઃ કણિશં છિત્ત્વા કરેષુ મર્દ્દયિત્વા ખાદિતુમારેભિરે| ");
INSERT INTO sanguj_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","તસ્માત્ કિયન્તઃ ફિરૂશિનસ્તાનવદન્ વિશ્રામવારે યત્ કર્મ્મ ન કર્ત્તવ્યં તત્ કુતઃ કુરુથ? ");
INSERT INTO sanguj_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","યીશુઃ પ્રત્યુવાચ દાયૂદ્ તસ્ય સઙ્ગિનશ્ચ ક્ષુધાર્ત્તાઃ કિં ચક્રુઃ સ કથમ્ ઈશ્વરસ્ય મન્દિરં પ્રવિશ્ય ");
INSERT INTO sanguj_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","યે દર્શનીયાઃ પૂપા યાજકાન્ વિનાન્યસ્ય કસ્યાપ્યભોજનીયાસ્તાનાનીય સ્વયં બુભજે સઙ્ગિભ્યોપિ દદૌ તત્ કિં યુષ્માભિઃ કદાપિ નાપાઠિ? ");
INSERT INTO sanguj_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","પશ્ચાત્ સ તાનવદત્ મનુજસુતો વિશ્રામવારસ્યાપિ પ્રભુ ર્ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","અનન્તરમ્ અન્યવિશ્રામવારે સ ભજનગેહં પ્રવિશ્ય સમુપદિશતિ| તદા તત્સ્થાને શુષ્કદક્ષિણકર એકઃ પુમાન્ ઉપતસ્થિવાન્| ");
INSERT INTO sanguj_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","તસ્માદ્ અધ્યાપકાઃ ફિરૂશિનશ્ચ તસ્મિન્ દોષમારોપયિતું સ વિશ્રામવારે તસ્ય સ્વાસ્થ્યં કરોતિ નવેતિ પ્રતીક્ષિતુમારેભિરે| ");
INSERT INTO sanguj_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","તદા યીશુસ્તેષાં ચિન્તાં વિદિત્વા તં શુષ્કકરં પુમાંસં પ્રોવાચ, ત્વમુત્થાય મધ્યસ્થાને તિષ્ઠ| ");
INSERT INTO sanguj_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","તસ્માત્ તસ્મિન્ ઉત્થિતવતિ યીશુસ્તાન્ વ્યાજહાર, યુષ્માન્ ઇમાં કથાં પૃચ્છામિ, વિશ્રામવારે હિતમ્ અહિતં વા, પ્રાણરક્ષણં પ્રાણનાશનં વા, એતેષાં કિં કર્મ્મકરણીયમ્? ");
INSERT INTO sanguj_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","પશ્ચાત્ ચતુર્દિક્ષુ સર્વ્વાન્ વિલોક્ય તં માનવં બભાષે, નિજકરં પ્રસારય; તતસ્તેન તથા કૃત ઇતરકરવત્ તસ્ય હસ્તઃ સ્વસ્થોભવત્| ");
INSERT INTO sanguj_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","તસ્માત્ તે પ્રચણ્ડકોપાન્વિતા યીશું કિં કરિષ્યન્તીતિ પરસ્પરં પ્રમન્ત્રિતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","તતઃ પરં સ પર્વ્વતમારુહ્યેશ્વરમુદ્દિશ્ય પ્રાર્થયમાનઃ કૃત્સ્નાં રાત્રિં યાપિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","અથ દિને સતિ સ સર્વ્વાન્ શિષ્યાન્ આહૂતવાન્ તેષાં મધ્યે ");
INSERT INTO sanguj_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","પિતરનામ્ના ખ્યાતઃ શિમોન્ તસ્ય ભ્રાતા આન્દ્રિયશ્ચ યાકૂબ્ યોહન્ ચ ફિલિપ્ બર્થલમયશ્ચ ");
INSERT INTO sanguj_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","મથિઃ થોમા આલ્ફીયસ્ય પુત્રો યાકૂબ્ જ્વલન્તનામ્ના ખ્યાતઃ શિમોન્ ");
INSERT INTO sanguj_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ચ યાકૂબો ભ્રાતા યિહૂદાશ્ચ તં યઃ પરકરેષુ સમર્પયિષ્યતિ સ ઈષ્કરીયોતીયયિહૂદાશ્ચૈતાન્ દ્વાદશ જનાન્ મનોનીતાન્ કૃત્વા સ જગ્રાહ તથા પ્રેરિત ઇતિ તેષાં નામ ચકાર| ");
INSERT INTO sanguj_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","તતઃ પરં સ તૈઃ સહ પર્વ્વતાદવરુહ્ય ઉપત્યકાયાં તસ્થૌ તતસ્તસ્ય શિષ્યસઙ્ઘો યિહૂદાદેશાદ્ યિરૂશાલમશ્ચ સોરઃ સીદોનશ્ચ જલધે રોધસો જનનિહાશ્ચ એત્ય તસ્ય કથાશ્રવણાર્થં રોગમુક્ત્યર્થઞ્ચ તસ્ય સમીપે તસ્થુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","અમેધ્યભૂતગ્રસ્તાશ્ચ તન્નિકટમાગત્ય સ્વાસ્થ્યં પ્રાપુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","સર્વ્વેષાં સ્વાસ્થ્યકરણપ્રભાવસ્ય પ્રકાશિતત્વાત્ સર્વ્વે લોકા એત્ય તં સ્પ્રષ્ટું યેતિરે| ");
INSERT INTO sanguj_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","પશ્ચાત્ સ શિષ્યાન્ પ્રતિ દૃષ્ટિં કુત્વા જગાદ, હે દરિદ્રા યૂયં ધન્યા યત ઈશ્વરીયે રાજ્યે વોઽધિકારોસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","હે અધુના ક્ષુધિતલોકા યૂયં ધન્યા યતો યૂયં તર્પ્સ્યથ; હે ઇહ રોદિનો જના યૂયં ધન્યા યતો યૂયં હસિષ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","યદા લોકા મનુષ્યસૂનો ર્નામહેતો ર્યુષ્માન્ ઋृતીયિષ્યન્તે પૃથક્ કૃત્વા નિન્દિષ્યન્તિ, અધમાનિવ યુષ્માન્ સ્વસમીપાદ્ દૂરીકરિષ્યન્તિ ચ તદા યૂયં ધન્યાઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","સ્વર્ગે યુષ્માકં યથેષ્ટં ફલં ભવિષ્યતિ, એતદર્થં તસ્મિન્ દિને પ્રોલ્લસત આનન્દેન નૃત્યત ચ, તેષાં પૂર્વ્વપુરુષાશ્ચ ભવિષ્યદ્વાદિનઃ પ્રતિ તથૈવ વ્યવાહરન્| ");
INSERT INTO sanguj_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","કિન્તુ હા હા ધનવન્તો યૂયં સુખં પ્રાપ્નુત| હન્ત પરિતૃપ્તા યૂયં ક્ષુધિતા ભવિષ્યથ; ");
INSERT INTO sanguj_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ઇહ હસન્તો યૂયં વત યુષ્માભિઃ શોચિતવ્યં રોદિતવ્યઞ્ચ| ");
INSERT INTO sanguj_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","સર્વ્વૈલાકૈ ર્યુષ્માકં સુખ્યાતૌ કૃતાયાં યુષ્માકં દુર્ગતિ ર્ભવિષ્યતિ યુષ્માકં પૂર્વ્વપુરુષા મૃષાભવિષ્યદ્વાદિનઃ પ્રતિ તદ્વત્ કૃતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","હે શ્રોતારો યુષ્મભ્યમહં કથયામિ, યૂયં શત્રુષુ પ્રીયધ્વં યે ચ યુષ્માન્ દ્વિષન્તિ તેષામપિ હિતં કુરુત| ");
INSERT INTO sanguj_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","યે ચ યુષ્માન્ શપન્તિ તેભ્ય આશિષં દત્ત યે ચ યુષ્માન્ અવમન્યન્તે તેષાં મઙ્ગલં પ્રાર્થયધ્વં| ");
INSERT INTO sanguj_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","યદિ કશ્ચિત્ તવ કપોલે ચપેટાઘાતં કરોતિ તર્હિ તં પ્રતિ કપોલમ્ અન્યં પરાવર્ત્ત્ય સમ્મુખીકુરુ પુનશ્ચ યદિ કશ્ચિત્ તવ ગાત્રીયવસ્ત્રં હરતિ તર્હિ તં પરિધેયવસ્ત્રમ્ અપિ ગ્રહીતું મા વારય| ");
INSERT INTO sanguj_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","યસ્ત્વાં યાચતે તસ્મૈ દેહિ, યશ્ચ તવ સમ્પત્તિં હરતિ તં મા યાચસ્વ| ");
INSERT INTO sanguj_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","પરેભ્યઃ સ્વાન્ પ્રતિ યથાચરણમ્ અપેક્ષધ્વે પરાન્ પ્રતિ યૂયમપિ તથાચરત| ");
INSERT INTO sanguj_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","યે જના યુષ્માસુ પ્રીયન્તે કેવલં તેષુ પ્રીયમાણેષુ યુષ્માકં કિં ફલં? પાપિલોકા અપિ સ્વેષુ પ્રીયમાણેષુ પ્રીયન્તે| ");
INSERT INTO sanguj_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","યદિ હિતકારિણ એવ હિતં કુરુથ તર્હિ યુષ્માકં કિં ફલં? પાપિલોકા અપિ તથા કુર્વ્વન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","યેભ્ય ઋણપરિશોધસ્ય પ્રાપ્તિપ્રત્યાશાસ્તે કેવલં તેષુ ઋણે સમર્પિતે યુષ્માકં કિં ફલં? પુનઃ પ્રાપ્ત્યાશયા પાપીલોકા અપિ પાપિજનેષુ ઋણમ્ અર્પયન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","અતો યૂયં રિપુષ્વપિ પ્રીયધ્વં, પરહિતં કુરુત ચ; પુનઃ પ્રાપ્ત્યાશાં ત્યક્ત્વા ઋણમર્પયત, તથા કૃતે યુષ્માકં મહાફલં ભવિષ્યતિ, યૂયઞ્ચ સર્વ્વપ્રધાનસ્ય સન્તાના ઇતિ ખ્યાતિં પ્રાપ્સ્યથ, યતો યુષ્માકં પિતા કૃતઘ્નાનાં દુર્વ્ટત્તાનાઞ્ચ હિતમાચરતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","અત એવ સ યથા દયાલુ ર્યૂયમપિ તાદૃશા દયાલવો ભવત| ");
INSERT INTO sanguj_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","અપરઞ્ચ પરાન્ દોષિણો મા કુરુત તસ્માદ્ યૂયં દોષીકૃતા ન ભવિષ્યથ; અદણ્ડ્યાન્ મા દણ્ડયત તસ્માદ્ યૂયમપિ દણ્ડં ન પ્રાપ્સ્યથ; પરેષાં દોષાન્ ક્ષમધ્વં તસ્માદ્ યુષ્માકમપિ દોષાઃ ક્ષમિષ્યન્તે| ");
INSERT INTO sanguj_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","દાનાનિદત્ત તસ્માદ્ યૂયં દાનાનિ પ્રાપ્સ્યથ, વરઞ્ચ લોકાઃ પરિમાણપાત્રં પ્રદલય્ય સઞ્ચાલ્ય પ્રોઞ્ચાલ્ય પરિપૂર્ય્ય યુષ્માકં ક્રોડેષુ સમર્પયિષ્યન્તિ; યૂયં યેન પરિમાણેન પરિમાથ તેનૈવ પરિમાણેન યુષ્મત્કૃતે પરિમાસ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","અથ સ તેભ્યો દૃષ્ટાન્તકથામકથયત્, અન્ધો જનઃ કિમન્ધં પન્થાનં દર્શયિતું શક્નોતિ? તસ્માદ્ ઉભાવપિ કિં ગર્ત્તે ન પતિષ્યતઃ? ");
INSERT INTO sanguj_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ગુરોઃ શિષ્યો ન શ્રેષ્ઠઃ કિન્તુ શિષ્યે સિદ્ધે સતિ સ ગુરુતુલ્યો ભવિતું શક્નોતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","અપરઞ્ચ ત્વં સ્વચક્ષુुષિ નાસામ્ અદૃષ્ટ્વા તવ ભ્રાતુશ્ચક્ષુષિ યત્તૃણમસ્તિ તદેવ કુતઃ પશ્યમિ? ");
INSERT INTO sanguj_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","સ્વચક્ષુષિ યા નાસા વિદ્યતે તામ્ અજ્ઞાત્વા, ભ્રાતસ્તવ નેત્રાત્ તૃણં બહિઃ કરોમીતિ વાક્યં ભ્રાતરં કથં વક્તું શક્નોષિ? હે કપટિન્ પૂર્વ્વં સ્વનયનાત્ નાસાં બહિઃ કુરુ તતો ભ્રાતુશ્ચક્ષુષસ્તૃણં બહિઃ કર્ત્તું સુદૃષ્ટિં પ્રાપ્સ્યસિ| ");
INSERT INTO sanguj_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","અન્યઞ્ચ ઉત્તમસ્તરુઃ કદાપિ ફલમનુત્તમં ન ફલતિ, અનુત્તમતરુશ્ચ ફલમુત્તમં ન ફલતિ કારણાદતઃ ફલૈસ્તરવો જ્ઞાયન્તે| ");
INSERT INTO sanguj_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","કણ્ટકિપાદપાત્ કોપિ ઉડુમ્બરફલાનિ ન પાતયતિ તથા શૃગાલકોલિવૃક્ષાદપિ કોપિ દ્રાક્ષાફલં ન પાતયતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","તદ્વત્ સાધુલોકોઽન્તઃકરણરૂપાત્ સુભાણ્ડાગારાદ્ ઉત્તમાનિ દ્રવ્યાણિ બહિઃ કરોતિ, દુષ્ટો લોકશ્ચાન્તઃકરણરૂપાત્ કુભાણ્ડાગારાત્ કુત્સિતાનિ દ્રવ્યાણિ નિર્ગમયતિ યતોઽન્તઃકરણાનાં પૂર્ણભાવાનુરૂપાણિ વચાંસિ મુખાન્નિર્ગચ્છન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","અપરઞ્ચ મમાજ્ઞાનુરૂપં નાચરિત્વા કુતો માં પ્રભો પ્રભો ઇતિ વદથ? ");
INSERT INTO sanguj_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","યઃ કશ્ચિન્ મમ નિકટમ્ આગત્ય મમ કથા નિશમ્ય તદનુરૂપં કર્મ્મ કરોતિ સ કસ્ય સદૃશો ભવતિ તદહં યુષ્માન્ જ્ઞાाપયામિ| ");
INSERT INTO sanguj_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","યો જનો ગભીરં ખનિત્વા પાષાણસ્થલે ભિત્તિં નિર્મ્માય સ્વગૃહં રચયતિ તેન સહ તસ્યોપમા ભવતિ; યત આપ્લાવિજલમેત્ય તસ્ય મૂલે વેગેન વહદપિ તદ્ગેહં લાડયિતું ન શક્નોતિ યતસ્તસ્ય ભિત્તિઃ પાષાણોપરિ તિષ્ઠતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","કિન્તુ યઃ કશ્ચિન્ મમ કથાઃ શ્રુત્વા તદનુરૂપં નાચરતિ સ ભિત્તિં વિના મૃृદુપરિ ગૃહનિર્મ્માત્રા સમાનો ભવતિ; યત આપ્લાવિજલમાગત્ય વેગેન યદા વહતિ તદા તદ્ગૃહં પતતિ તસ્ય મહત્ પતનં જાયતે| ");
INSERT INTO sanguj_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","તતઃ પરં સ લોકાનાં કર્ણગોચરે તાન્ સર્વ્વાન્ ઉપદેશાન્ સમાપ્ય યદા કફર્નાહૂમ્પુરં પ્રવિશતિ ");
INSERT INTO sanguj_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","તદા શતસેનાપતેઃ પ્રિયદાસ એકો મૃતકલ્પઃ પીડિત આસીત્| ");
INSERT INTO sanguj_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","અતઃ સેનાપતિ ર્યીશો ર્વાર્ત્તાં નિશમ્ય દાસસ્યારોગ્યકરણાય તસ્યાગમનાર્થં વિનયકરણાય યિહૂદીયાન્ કિયતઃ પ્રાચઃ પ્રેષયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","તે યીશોરન્તિકં ગત્વા વિનયાતિશયં વક્તુમારેભિરે, સ સેનાપતિ ર્ભવતોનુગ્રહં પ્રાપ્તુમ્ અર્હતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","યતઃ સોસ્મજ્જાતીયેષુ લોકેષુ પ્રીયતે તથાસ્મત્કૃતે ભજનગેહં નિર્મ્મિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","તસ્માદ્ યીશુસ્તૈઃ સહ ગત્વા નિવેશનસ્ય સમીપં પ્રાપ, તદા સ શતસેનાપતિ ર્વક્ષ્યમાણવાક્યં તં વક્તું બન્ધૂન્ પ્રાહિણોત્| હે પ્રભો સ્વયં શ્રમો ન કર્ત્તવ્યો યદ્ ભવતા મદ્ગેહમધ્યે પાદાર્પણં ક્રિયેત તદપ્યહં નાર્હામિ, ");
INSERT INTO sanguj_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","કિઞ્ચાહં ભવત્સમીપં યાતુમપિ નાત્માનં યોગ્યં બુદ્ધવાન્, તતો ભવાન્ વાક્યમાત્રં વદતુ તેનૈવ મમ દાસઃ સ્વસ્થો ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","યસ્માદ્ અહં પરાધીનોપિ મમાધીના યાઃ સેનાઃ સન્તિ તાસામ્ એકજનં પ્રતિ યાહીતિ મયા પ્રોક્તે સ યાતિ; તદન્યં પ્રતિ આયાહીતિ પ્રોક્તે સ આયાતિ; તથા નિજદાસં પ્રતિ એતત્ કુર્વ્વિતિ પ્રોક્તે સ તદેવ કરોતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","યીશુરિદં વાક્યં શ્રુત્વા વિસ્મયં યયૌ, મુખં પરાવર્ત્ય પશ્ચાદ્વર્ત્તિનો લોકાન્ બભાષે ચ, યુષ્માનહં વદામિ ઇસ્રાયેલો વંશમધ્યેપિ વિશ્વાસમીદૃશં ન પ્રાપ્નવં| ");
INSERT INTO sanguj_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","તતસ્તે પ્રેષિતા ગૃહં ગત્વા તં પીડિતં દાસં સ્વસ્થં દદૃશુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","પરેઽહનિ સ નાયીનાખ્યં નગરં જગામ તસ્યાનેકે શિષ્યા અન્યે ચ લોકાસ્તેન સાર્દ્ધં યયુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","તેષુ તન્નગરસ્ય દ્વારસન્નિધિં પ્રાપ્તેષુ કિયન્તો લોકા એકં મૃતમનુજં વહન્તો નગરસ્ય બહિર્યાન્તિ, સ તન્માતુરેકપુત્રસ્તન્માતા ચ વિધવા; તયા સાર્દ્ધં તન્નગરીયા બહવો લોકા આસન્| ");
INSERT INTO sanguj_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","પ્રભુસ્તાં વિલોક્ય સાનુકમ્પઃ કથયામાસ, મા રોદીઃ| સ સમીપમિત્વા ખટ્વાં પસ્પર્શ તસ્માદ્ વાહકાઃ સ્થગિતાસ્તમ્યુઃ; ");
INSERT INTO sanguj_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","તદા સ ઉવાચ હે યુવમનુષ્ય ત્વમુત્તિષ્ઠ, ત્વામહમ્ આજ્ઞાપયામિ| ");
INSERT INTO sanguj_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","તસ્માત્ સ મૃતો જનસ્તત્ક્ષણમુત્થાય કથાં પ્રકથિતઃ; તતો યીશુસ્તસ્ય માતરિ તં સમર્પયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","તસ્માત્ સર્વ્વે લોકાઃ શશઙ્કિરે; એકો મહાભવિષ્યદ્વાદી મધ્યેઽસ્માકમ્ સમુદૈત્, ઈશ્વરશ્ચ સ્વલોકાનન્વગૃહ્લાત્ કથામિમાં કથયિત્વા ઈશ્વરં ધન્યં જગદુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","તતઃ પરં સમસ્તં યિહૂદાદેશં તસ્ય ચતુર્દિક્સ્થદેશઞ્ચ તસ્યૈતત્કીર્ત્તિ ર્વ્યાનશે| ");
INSERT INTO sanguj_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","તતઃ પરં યોહનઃ શિષ્યેષુ તં તદ્વૃત્તાન્તં જ્ઞાપિતવત્સુ ");
INSERT INTO sanguj_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","સ સ્વશિષ્યાણાં દ્વૌ જનાવાહૂય યીશું પ્રતિ વક્ષ્યમાણં વાક્યં વક્તું પ્રેષયામાસ, યસ્યાગમનમ્ અપેક્ષ્ય તિષ્ઠામો વયં કિં સ એવ જનસ્ત્વં? કિં વયમન્યમપેક્ષ્ય સ્થાસ્યામઃ? ");
INSERT INTO sanguj_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","પશ્ચાત્તૌ માનવૌ ગત્વા કથયામાસતુઃ, યસ્યાગમનમ્ અપેક્ષ્ય તિષ્ઠામો વયં, કિં સએવ જનસ્ત્વં? કિં વયમન્યમપેક્ષ્ય સ્થાસ્યામઃ? કથામિમાં તુભ્યં કથયિતું યોહન્ મજ્જક આવાં પ્રેષિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","તસ્મિન્ દણ્ડે યીશૂરોગિણો મહાવ્યાધિમતો દુષ્ટભૂતગ્રસ્તાંશ્ચ બહૂન્ સ્વસ્થાન્ કૃત્વા, અનેકાન્ધેભ્યશ્ચક્ષુંષિ દત્ત્વા પ્રત્યુવાચ, ");
INSERT INTO sanguj_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","યુવાં વ્રજતમ્ અન્ધા નેત્રાણિ ખઞ્જાશ્ચરણાનિ ચ પ્રાપ્નુવન્તિ, કુષ્ઠિનઃ પરિષ્ક્રિયન્તે, બધિરાઃ શ્રવણાનિ મૃતાશ્ચ જીવનાનિ પ્રાપ્નુવન્તિ, દરિદ્રાણાં સમીપેષુ સુસંવાદઃ પ્રચાર્ય્યતે, યં પ્રતિ વિઘ્નસ્વરૂપોહં ન ભવામિ સ ધન્યઃ, ");
INSERT INTO sanguj_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","એતાનિ યાનિ પશ્યથઃ શૃણુથશ્ચ તાનિ યોહનં જ્ઞાપયતમ્| ");
INSERT INTO sanguj_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","તયો ર્દૂતયો ર્ગતયોઃ સતો ર્યોહનિ સ લોકાન્ વક્તુમુપચક્રમે, યૂયં મધ્યેપ્રાન્તરં કિં દ્રષ્ટું નિરગમત? કિં વાયુના કમ્પિતં નડં? ");
INSERT INTO sanguj_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","યૂયં કિં દ્રષ્ટું નિરગમત? કિં સૂક્ષ્મવસ્ત્રપરિધાયિનં કમપિ નરં? કિન્તુ યે સૂક્ષ્મમૃદુવસ્ત્રાણિ પરિદધતિ સૂત્તમાનિ દ્રવ્યાણિ ભુઞ્જતે ચ તે રાજધાનીષુ તિષ્ઠન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","તર્હિ યૂયં કિં દ્રષ્ટું નિરગમત? કિમેકં ભવિષ્યદ્વાદિનં? તદેવ સત્યં કિન્તુ સ પુમાન્ ભવિષ્યદ્વાદિનોપિ શ્રેષ્ઠ ઇત્યહં યુષ્માન્ વદામિ; ");
INSERT INTO sanguj_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","પશ્ય સ્વકીયદૂતન્તુ તવાગ્ર પ્રેષયામ્યહં| ગત્વા ત્વદીયમાર્ગન્તુ સ હિ પરિષ્કરિષ્યતિ| યદર્થે લિપિરિયમ્ આસ્તે સ એવ યોહન્| ");
INSERT INTO sanguj_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","અતો યુષ્માનહં વદામિ સ્ત્રિયા ગર્બ્ભજાતાનાં ભવિષ્યદ્વાદિનાં મધ્યે યોહનો મજ્જકાત્ શ્રેષ્ઠઃ કોપિ નાસ્તિ, તત્રાપિ ઈશ્વરસ્ય રાજ્યે યઃ સર્વ્વસ્માત્ ક્ષુદ્રઃ સ યોહનોપિ શ્રેષ્ઠઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","અપરઞ્ચ સર્વ્વે લોકાઃ કરમઞ્ચાયિનશ્ચ તસ્ય વાક્યાનિ શ્રુત્વા યોહના મજ્જનેન મજ્જિતાઃ પરમેશ્વરં નિર્દોષં મેનિરે| ");
INSERT INTO sanguj_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","કિન્તુ ફિરૂશિનો વ્યવસ્થાપકાશ્ચ તેન ન મજ્જિતાઃ સ્વાન્ પ્રતીશ્વરસ્યોપદેશં નિષ્ફલમ્ અકુર્વ્વન્| ");
INSERT INTO sanguj_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","અથ પ્રભુઃ કથયામાસ, ઇદાનીન્તનજનાન્ કેનોપમામિ? તે કસ્ય સદૃશાઃ? ");
INSERT INTO sanguj_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","યે બાલકા વિપણ્યામ્ ઉપવિશ્ય પરસ્પરમ્ આહૂય વાક્યમિદં વદન્તિ, વયં યુષ્માકં નિકટે વંશીરવાદિષ્મ, કિન્તુ યૂયં નાનર્ત્તિષ્ટ, વયં યુષ્માકં નિકટ અરોદિષ્મ, કિન્તુ યુયં ન વ્યલપિષ્ટ, બાલકૈરેતાદૃશૈસ્તેષામ્ ઉપમા ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","યતો યોહન્ મજ્જક આગત્ય પૂપં નાખાદત્ દ્રાક્ષારસઞ્ચ નાપિવત્ તસ્માદ્ યૂયં વદથ, ભૂતગ્રસ્તોયમ્| ");
INSERT INTO sanguj_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","તતઃ પરં માનવસુત આગત્યાખાદદપિવઞ્ચ તસ્માદ્ યૂયં વદથ, ખાદકઃ સુરાપશ્ચાણ્ડાલપાપિનાં બન્ધુરેકો જનો દૃશ્યતામ્| ");
INSERT INTO sanguj_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","કિન્તુ જ્ઞાનિનો જ્ઞાનં નિર્દોષં વિદુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","પશ્ચાદેકઃ ફિરૂશી યીશું ભોજનાય ન્યમન્ત્રયત્ તતઃ સ તસ્ય ગૃહં ગત્વા ભોક્તુમુપવિષ્ટઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","એતર્હિ તત્ફિરૂશિનો ગૃહે યીશુ ર્ભેક્તુમ્ ઉપાવેક્ષીત્ તચ્છ્રુત્વા તન્નગરવાસિની કાપિ દુષ્ટા નારી પાણ્ડરપ્રસ્તરસ્ય સમ્પુટકે સુગન્ધિતૈલમ્ આનીય ");
INSERT INTO sanguj_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","તસ્ય પશ્ચાત્ પાદયોઃ સન્નિધૌ તસ્યૌ રુદતી ચ નેત્રામ્બુભિસ્તસ્ય ચરણૌ પ્રક્ષાલ્ય નિજકચૈરમાર્ક્ષીત્, તતસ્તસ્ય ચરણૌ ચુમ્બિત્વા તેન સુગન્ધિતૈલેન મમર્દ| ");
INSERT INTO sanguj_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","તસ્માત્ સ નિમન્ત્રયિતા ફિરૂશી મનસા ચિન્તયામાસ, યદ્યયં ભવિષ્યદ્વાદી ભવેત્ તર્હિ એનં સ્પૃશતિ યા સ્ત્રી સા કા કીદૃશી ચેતિ જ્ઞાતું શક્નુયાત્ યતઃ સા દુષ્ટા| ");
INSERT INTO sanguj_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","તદા યાશુસ્તં જગાદ, હે શિમોન્ ત્વાં પ્રતિ મમ કિઞ્ચિદ્ વક્તવ્યમસ્તિ; તસ્માત્ સ બભાષે, હે ગુરો તદ્ વદતુ| ");
INSERT INTO sanguj_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","એકોત્તમર્ણસ્ય દ્વાવધમર્ણાવાસ્તાં, તયોરેકઃ પઞ્ચશતાનિ મુદ્રાપાદાન્ અપરશ્ચ પઞ્ચાશત્ મુદ્રાપાદાન્ ધારયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","તદનન્તરં તયોઃ શોધ્યાભાવાત્ સ ઉત્તમર્ણસ્તયો રૃણે ચક્ષમે; તસ્માત્ તયોર્દ્વયોઃ કસ્તસ્મિન્ પ્રેષ્યતે બહુ? તદ્ બ્રૂહિ| ");
INSERT INTO sanguj_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","શિમોન્ પ્રત્યુવાચ, મયા બુધ્યતે યસ્યાધિકમ્ ઋણં ચક્ષમે સ ઇતિ; તતો યીશુસ્તં વ્યાજહાર, ત્વં યથાર્થં વ્યચારયઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","અથ તાં નારીં પ્રતિ વ્યાઘુઠ્ય શિમોનમવોચત્, સ્ત્રીમિમાં પશ્યસિ? તવ ગૃહે મય્યાગતે ત્વં પાદપ્રક્ષાલનાર્થં જલં નાદાઃ કિન્તુ યોષિદેષા નયનજલૈ ર્મમ પાદૌ પ્રક્ષાલ્ય કેશૈરમાર્ક્ષીત્| ");
INSERT INTO sanguj_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ત્વં માં નાચુમ્બીઃ કિન્તુ યોષિદેષા સ્વીયાગમનાદારભ્ય મદીયપાદૌ ચુમ્બિતું ન વ્યરંસ્ત| ");
INSERT INTO sanguj_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ત્વઞ્ચ મદીયોત્તમાઙ્ગે કિઞ્ચિદપિ તૈલં નામર્દીઃ કિન્તુ યોષિદેષા મમ ચરણૌ સુગન્ધિતૈલેનામર્દ્દીત્| ");
INSERT INTO sanguj_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","અતસ્ત્વાં વ્યાહરામિ, એતસ્યા બહુ પાપમક્ષમ્યત તતો બહુ પ્રીયતે કિન્તુ યસ્યાલ્પપાપં ક્ષમ્યતે સોલ્પં પ્રીયતે| ");
INSERT INTO sanguj_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","તતઃ પરં સ તાં બભાષે, ત્વદીયં પાપમક્ષમ્યત| ");
INSERT INTO sanguj_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","તદા તેન સાર્દ્ધં યે ભોક્તુમ્ ઉપવિવિશુસ્તે પરસ્પરં વક્તુમારેભિરે, અયં પાપં ક્ષમતે ક એષઃ? ");
INSERT INTO sanguj_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","કિન્તુ સ તાં નારીં જગાદ, તવ વિશ્વાસસ્ત્વાં પર્ય્યત્રાસ્ત ત્વં ક્ષેમેણ વ્રજ| ");
INSERT INTO sanguj_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","અપરઞ્ચ યીશુ ર્દ્વાદશભિઃ શિષ્યૈઃ સાર્દ્ધં નાનાનગરેષુ નાનાગ્રામેષુ ચ ગચ્છન્ ઇશ્વરીયરાજત્વસ્ય સુસંવાદં પ્રચારયિતું પ્રારેભે| ");
INSERT INTO sanguj_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","તદા યસ્યાઃ સપ્ત ભૂતા નિરગચ્છન્ સા મગ્દલીનીતિ વિખ્યાતા મરિયમ્ હેરોદ્રાજસ્ય ગૃહાધિપતેઃ હોષે ર્ભાર્ય્યા યોહના શૂશાના ");
INSERT INTO sanguj_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","પ્રભૃતયો યા બહ્વ્યઃ સ્ત્રિયઃ દુષ્ટભૂતેભ્યો રોગેભ્યશ્ચ મુક્તાઃ સત્યો નિજવિભૂતી ર્વ્યયિત્વા તમસેવન્ત, તાઃ સર્વ્વાસ્તેન સાર્દ્ધમ્ આસન્| ");
INSERT INTO sanguj_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","અનન્તરં નાનાનગરેભ્યો બહવો લોકા આગત્ય તસ્ય સમીપેઽમિલન્, તદા સ તેભ્ય એકાં દૃષ્ટાન્તકથાં કથયામાસ| એકઃ કૃષીબલો બીજાનિ વપ્તું બહિર્જગામ, ");
INSERT INTO sanguj_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","તતો વપનકાલે કતિપયાનિ બીજાનિ માર્ગપાર્શ્વે પેતુઃ, તતસ્તાનિ પદતલૈ ર્દલિતાનિ પક્ષિભિ ર્ભક્ષિતાનિ ચ| ");
INSERT INTO sanguj_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","કતિપયાનિ બીજાનિ પાષાણસ્થલે પતિતાનિ યદ્યપિ તાન્યઙ્કુરિતાનિ તથાપિ રસાભાવાત્ શુશુષુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","કતિપયાનિ બીજાનિ કણ્ટકિવનમધ્યે પતિતાનિ તતઃ કણ્ટકિવનાનિ સંવૃદ્ધ્ય તાનિ જગ્રસુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","તદન્યાનિ કતિપયબીજાનિ ચ ભૂમ્યામુત્તમાયાં પેતુસ્તતસ્તાન્યઙ્કુરયિત્વા શતગુણાનિ ફલાનિ ફેલુઃ| સ ઇમા કથાં કથયિત્વા પ્રોચ્ચૈઃ પ્રોવાચ, યસ્ય શ્રોતું શ્રોત્રે સ્તઃ સ શૃણોતુ| ");
INSERT INTO sanguj_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","તતઃ પરં શિષ્યાસ્તં પપ્રચ્છુરસ્ય દૃષ્ટાન્તસ્ય કિં તાત્પર્ય્યં? ");
INSERT INTO sanguj_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","તતઃ સ વ્યાજહાર, ઈશ્વરીયરાજ્યસ્ય ગુહ્યાનિ જ્ઞાતું યુષ્મભ્યમધિકારો દીયતે કિન્ત્વન્યે યથા દૃષ્ટ્વાપિ ન પશ્યન્તિ શ્રુત્વાપિ મ બુધ્યન્તે ચ તદર્થં તેષાં પુરસ્તાત્ તાઃ સર્વ્વાઃ કથા દૃષ્ટાન્તેન કથ્યન્તે| ");
INSERT INTO sanguj_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","દૃષ્ટાન્તસ્યાસ્યાભિપ્રાયઃ, ઈશ્વરીયકથા બીજસ્વરૂપા| ");
INSERT INTO sanguj_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","યે કથામાત્રં શૃણ્વન્તિ કિન્તુ પશ્ચાદ્ વિશ્વસ્ય યથા પરિત્રાણં ન પ્રાપ્નુવન્તિ તદાશયેન શૈતાનેત્ય હૃદયાતૃ તાં કથામ્ અપહરતિ ત એવ માર્ગપાર્શ્વસ્થભૂમિસ્વરૂપાઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","યે કથં શ્રુત્વા સાનન્દં ગૃહ્લન્તિ કિન્ત્વબદ્ધમૂલત્વાત્ સ્વલ્પકાલમાત્રં પ્રતીત્ય પરીક્ષાકાલે ભ્રશ્યન્તિ તએવ પાષાણભૂમિસ્વરૂપાઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","યે કથાં શ્રુત્વા યાન્તિ વિષયચિન્તાયાં ધનલોભેન એेહિકસુખે ચ મજ્જન્ત ઉપયુક્તફલાનિ ન ફલન્તિ ત એવોપ્તબીજકણ્ટકિભૂસ્વરૂપાઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","કિન્તુ યે શ્રુત્વા સરલૈઃ શુદ્ધૈશ્ચાન્તઃકરણૈઃ કથાં ગૃહ્લન્તિ ધૈર્ય્યમ્ અવલમ્બ્ય ફલાન્યુત્પાદયન્તિ ચ ત એવોત્તમમૃત્સ્વરૂપાઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","અપરઞ્ચ પ્રદીપં પ્રજ્વાલ્ય કોપિ પાત્રેણ નાચ્છાદયતિ તથા ખટ્વાધોપિ ન સ્થાપયતિ, કિન્તુ દીપાધારોપર્ય્યેવ સ્થાપયતિ, તસ્માત્ પ્રવેશકા દીપ્તિં પશ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","યન્ન પ્રકાશયિષ્યતે તાદૃગ્ અપ્રકાશિતં વસ્તુ કિમપિ નાસ્તિ યચ્ચ ન સુવ્યક્તં પ્રચારયિષ્યતે તાદૃગ્ ગૃપ્તં વસ્તુ કિમપિ નાસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","અતો યૂયં કેન પ્રકારેણ શૃણુથ તત્ર સાવધાના ભવત, યસ્ય સમીપે બર્દ્ધતે તસ્મૈ પુનર્દાસ્યતે કિન્તુ યસ્યાશ્રયે ન બર્દ્ધતે તસ્ય યદ્યદસ્તિ તદપિ તસ્માત્ નેષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","અપરઞ્ચ યીશો ર્માતા ભ્રાતરશ્ચ તસ્ય સમીપં જિગમિષવઃ ");
INSERT INTO sanguj_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","કિન્તુ જનતાસમ્બાધાત્ તત્સન્નિધિં પ્રાપ્તું ન શેકુઃ| તત્પશ્ચાત્ તવ માતા ભ્રાતરશ્ચ ત્વાં સાક્ષાત્ ચિકીર્ષન્તો બહિસ્તિષ્ઠનતીતિ વાર્ત્તાયાં તસ્મૈ કથિતાયાં ");
INSERT INTO sanguj_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","સ પ્રત્યુવાચ; યે જના ઈશ્વરસ્ય કથાં શ્રુત્વા તદનુરૂપમાચરન્તિ તએવ મમ માતા ભ્રાતરશ્ચ| ");
INSERT INTO sanguj_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","અનન્તરં એકદા યીશુઃ શિષ્યૈઃ સાર્દ્ધં નાવમારુહ્ય જગાદ, આયાત વયં હ્રદસ્ય પારં યામઃ, તતસ્તે જગ્મુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","તેષુ નૌકાં વાહયત્સુ સ નિદદ્રૌ; ");
INSERT INTO sanguj_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","અથાકસ્માત્ પ્રબલઝઞ્ભ્શગમાદ્ હ્રદે નૌકાયાં તરઙ્ગૈરાચ્છન્નાયાં વિપત્ તાન્ જગ્રાસ| તસ્માદ્ યીશોરન્તિકં ગત્વા હે ગુરો હે ગુરો પ્રાણા નો યાન્તીતિ ગદિત્વા તં જાગરયામ્બભૂવુઃ| તદા સ ઉત્થાય વાયું તરઙ્ગાંશ્ચ તર્જયામાસ તસ્માદુભૌ નિવૃત્ય સ્થિરૌ બભૂવતુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","સ તાન્ બભાષે યુષ્માકં વિશ્વાસઃ ક? તસ્માત્તે ભીતા વિસ્મિતાશ્ચ પરસ્પરં જગદુઃ, અહો કીદૃગયં મનુજઃ પવનં પાનીયઞ્ચાદિશતિ તદુભયં તદાદેશં વહતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","તતઃ પરં ગાલીલ્પ્રદેશસ્ય સમ્મુખસ્થગિદેરીયપ્રદેશે નૌકાયાં લગન્ત્યાં તટેઽવરોહમાવાદ્ ");
INSERT INTO sanguj_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","બહુતિથકાલં ભૂતગ્રસ્ત એકો માનુષઃ પુરાદાગત્ય તં સાક્ષાચ્ચકાર| સ મનુષો વાસો ન પરિદધત્ ગૃહે ચ ન વસન્ કેવલં શ્મશાનમ્ અધ્યુવાસ| ");
INSERT INTO sanguj_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","સ યીશું દૃષ્ટ્વૈવ ચીચ્છબ્દં ચકાર તસ્ય સમ્મુખે પતિત્વા પ્રોચ્ચૈર્જગાદ ચ, હે સર્વ્વપ્રધાનેશ્વરસ્ય પુત્ર, મયા સહ તવ કઃ સમ્બન્ધઃ? ત્વયિ વિનયં કરોમિ માં મા યાતય| ");
INSERT INTO sanguj_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","યતઃ સ તં માનુષં ત્યક્ત્વા યાતુમ્ અમેધ્યભૂતમ્ આદિદેશ; સ ભૂતસ્તં માનુષમ્ અસકૃદ્ દધાર તસ્માલ્લોકાઃ શૃઙ્ખલેન નિગડેન ચ બબન્ધુઃ; સ તદ્ ભંક્ત્વા ભૂતવશત્વાત્ મધ્યેપ્રાન્તરં યયૌ| ");
INSERT INTO sanguj_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","અનન્તરં યીશુસ્તં પપ્રચ્છ તવ કિન્નામ? સ ઉવાચ, મમ નામ બાહિનો યતો બહવો ભૂતાસ્તમાશિશ્રિયુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","અથ ભૂતા વિનયેન જગદુઃ, ગભીરં ગર્ત્તં ગન્તું માજ્ઞાપયાસ્માન્| ");
INSERT INTO sanguj_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","તદા પર્વ્વતોપરિ વરાહવ્રજશ્ચરતિ તસ્માદ્ ભૂતા વિનયેન પ્રોચુઃ, અમું વરાહવ્રજમ્ આશ્રયિતુમ્ અસ્માન્ અનુજાનીહિ; તતઃ સોનુજજ્ઞૌ| ");
INSERT INTO sanguj_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","તતઃ પરં ભૂતાસ્તં માનુષં વિહાય વરાહવ્રજમ્ આશિશ્રિયુઃ વરાહવ્રજાશ્ચ તત્ક્ષણાત્ કટકેન ધાવન્તો હ્રદે પ્રાણાન્ વિજૃહુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","તદ્ દૃષ્ટ્વા શૂકરરક્ષકાઃ પલાયમાના નગરં ગ્રામઞ્ચ ગત્વા તત્સર્વ્વવૃત્તાન્તં કથયામાસુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","તતઃ કિં વૃત્તમ્ એતદ્દર્શનાર્થં લોકા નિર્ગત્ય યીશોઃ સમીપં યયુઃ, તં માનુષં ત્યક્તભૂતં પરિહિતવસ્ત્રં સ્વસ્થમાનુષવદ્ યીશોશ્ચરણસન્નિધૌ સૂપવિશન્તં વિલોક્ય બિભ્યુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","યે લોકાસ્તસ્ય ભૂતગ્રસ્તસ્ય સ્વાસ્થ્યકરણં દદૃશુસ્તે તેભ્યઃ સર્વ્વવૃત્તાન્તં કથયામાસુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","તદનન્તરં તસ્ય ગિદેરીયપ્રદેશસ્ય ચતુર્દિક્સ્થા બહવો જના અતિત્રસ્તા વિનયેન તં જગદુઃ, ભવાન્ અસ્માકં નિકટાદ્ વ્રજતુ તસ્માત્ સ નાવમારુહ્ય તતો વ્યાઘુટ્ય જગામ| ");
INSERT INTO sanguj_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","તદાનીં ત્યક્તભૂતમનુજસ્તેન સહ સ્થાતું પ્રાર્થયાઞ્ચક્રે ");
INSERT INTO sanguj_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","કિન્તુ તદર્થમ્ ઈશ્વરઃ કીદૃઙ્મહાકર્મ્મ કૃતવાન્ ઇતિ નિવેશનં ગત્વા વિજ્ઞાપય, યીશુઃ કથામેતાં કથયિત્વા તં વિસસર્જ| તતઃ સ વ્રજિત્વા યીશુસ્તદર્થં યન્મહાકર્મ્મ ચકાર તત્ પુરસ્ય સર્વ્વત્ર પ્રકાશયિતું પ્રારેભે| ");
INSERT INTO sanguj_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","અથ યીશૌ પરાવૃત્યાગતે લોકાસ્તં આદરેણ જગૃહુ ર્યસ્માત્તે સર્વ્વે તમપેક્ષાઞ્ચક્રિરે| ");
INSERT INTO sanguj_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","તદનન્તરં યાયીર્નામ્નો ભજનગેહસ્યૈકોધિપ આગત્ય યીશોશ્ચરણયોઃ પતિત્વા સ્વનિવેશનાગમનાર્થં તસ્મિન્ વિનયં ચકાર, ");
INSERT INTO sanguj_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","યતસ્તસ્ય દ્વાદશવર્ષવયસ્કા કન્યૈકાસીત્ સા મૃતકલ્પાભવત્| તતસ્તસ્ય ગમનકાલે માર્ગે લોકાનાં મહાન્ સમાગમો બભૂવ| ");
INSERT INTO sanguj_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","દ્વાદશવર્ષાણિ પ્રદરરોગગ્રસ્તા નાના વૈદ્યૈશ્ચિકિત્સિતા સર્વ્વસ્વં વ્યયિત્વાપિ સ્વાસ્થ્યં ન પ્રાપ્તા યા યોષિત્ સા યીશોઃ પશ્ચાદાગત્ય તસ્ય વસ્ત્રગ્રન્થિં પસ્પર્શ| ");
INSERT INTO sanguj_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","તસ્માત્ તત્ક્ષણાત્ તસ્યા રક્તસ્રાવો રુદ્ધઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","તદાનીં યીશુરવદત્ કેનાહં સ્પૃષ્ટઃ? તતોઽનેકૈરનઙ્ગીકૃતે પિતરસ્તસ્ય સઙ્ગિનશ્ચાવદન્, હે ગુરો લોકા નિકટસ્થાઃ સન્તસ્તવ દેહે ઘર્ષયન્તિ, તથાપિ કેનાહં સ્પૃષ્ટઇતિ ભવાન્ કુતઃ પૃચ્છતિ? ");
INSERT INTO sanguj_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","યીશુઃ કથયામાસ, કેનાપ્યહં સ્પૃષ્ટો, યતો મત્તઃ શક્તિ ર્નિર્ગતેતિ મયા નિશ્ચિતમજ્ઞાયિ| ");
INSERT INTO sanguj_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","તદા સા નારી સ્વયં ન ગુપ્તેતિ વિદિત્વા કમ્પમાના સતી તસ્ય સમ્મુખે પપાત; યેન નિમિત્તેન તં પસ્પર્શ સ્પર્શમાત્રાચ્ચ યેન પ્રકારેણ સ્વસ્થાભવત્ તત્ સર્વ્વં તસ્ય સાક્ષાદાચખ્યૌ| ");
INSERT INTO sanguj_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","તતઃ સ તાં જગાદ હે કન્યે સુસ્થિરા ભવ, તવ વિશ્વાસસ્ત્વાં સ્વસ્થામ્ અકાર્ષીત્ ત્વં ક્ષેમેણ યાહિ| ");
INSERT INTO sanguj_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","યીશોરેતદ્વાક્યવદનકાલે તસ્યાધિપતે ર્નિવેશનાત્ કશ્ચિલ્લોક આગત્ય તં બભાષે, તવ કન્યા મૃતા ગુરું મા ક્લિશાન| ");
INSERT INTO sanguj_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","કિન્તુ યીશુસ્તદાકર્ણ્યાધિપતિં વ્યાજહાર, મા ભૈષીઃ કેવલં વિશ્વસિહિ તસ્માત્ સા જીવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","અથ તસ્ય નિવેશને પ્રાપ્તે સ પિતરં યોહનં યાકૂબઞ્ચ કન્યાયા માતરં પિતરઞ્ચ વિના, અન્યં કઞ્ચન પ્રવેષ્ટું વારયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","અપરઞ્ચ યે રુદન્તિ વિલપન્તિ ચ તાન્ સર્વ્વાન્ જનાન્ ઉવાચ, યૂયં મા રોદિષ્ટ કન્યા ન મૃતા નિદ્રાતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","કિન્તુ સા નિશ્ચિતં મૃતેતિ જ્ઞાત્વા તે તમુપજહસુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","પશ્ચાત્ સ સર્વ્વાન્ બહિઃ કૃત્વા કન્યાયાઃ કરૌ ધૃત્વાજુહુવે, હે કન્યે ત્વમુત્તિષ્ઠ, ");
INSERT INTO sanguj_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","તસ્માત્ તસ્યાઃ પ્રાણેષુ પુનરાગતેષુ સા તત્ક્ષણાદ્ ઉત્તસ્યૌ| તદાનીં તસ્યૈ કિઞ્ચિદ્ ભક્ષ્યં દાતુમ્ આદિદેશ| ");
INSERT INTO sanguj_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","તતસ્તસ્યાઃ પિતરૌ વિસ્મયં ગતૌ કિન્તુ સ તાવાદિદેશ ઘટનાયા એતસ્યાઃ કથાં કસ્મૈચિદપિ મા કથયતં| ");
INSERT INTO sanguj_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","તતઃ પરં સ દ્વાદશશિષ્યાનાહૂય ભૂતાન્ ત્યાજયિતું રોગાન્ પ્રતિકર્ત્તુઞ્ચ તેભ્યઃ શક્તિમાધિપત્યઞ્ચ દદૌ| ");
INSERT INTO sanguj_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","અપરઞ્ચ ઈશ્વરીયરાજ્યસ્ય સુસંવાદં પ્રકાશયિતુમ્ રોગિણામારોગ્યં કર્ત્તુઞ્ચ પ્રેરણકાલે તાન્ જગાદ| ");
INSERT INTO sanguj_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","યાત્રાર્થં યષ્ટિ ર્વસ્ત્રપુટકં ભક્ષ્યં મુદ્રા દ્વિતીયવસ્ત્રમ્, એષાં કિમપિ મા ગૃહ્લીત| ");
INSERT INTO sanguj_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","યૂયઞ્ચ યન્નિવેશનં પ્રવિશથ નગરત્યાગપર્ય્યનતં તન્નિવેશને તિષ્ઠત| ");
INSERT INTO sanguj_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","તત્ર યદિ કસ્યચિત્ પુરસ્ય લોકા યુષ્માકમાતિથ્યં ન કુર્વ્વન્તિ તર્હિ તસ્માન્નગરાદ્ ગમનકાલે તેષાં વિરુદ્ધં સાક્ષ્યાર્થં યુષ્માકં પદધૂલીઃ સમ્પાતયત| ");
INSERT INTO sanguj_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","અથ તે પ્રસ્થાય સર્વ્વત્ર સુસંવાદં પ્રચારયિતું પીડિતાન્ સ્વસ્થાન્ કર્ત્તુઞ્ચ ગ્રામેષુ ભ્રમિતું પ્રારેભિરે| ");
INSERT INTO sanguj_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","એતર્હિ હેરોદ્ રાજા યીશોઃ સર્વ્વકર્મ્મણાં વાર્ત્તાં શ્રુત્વા ભૃશમુદ્વિવિજે ");
INSERT INTO sanguj_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","યતઃ કેચિદૂચુર્યોહન્ શ્મશાનાદુદતિષ્ઠત્| કેચિદૂચુઃ, એલિયો દર્શનં દત્તવાન્; એવમન્યલોકા ઊચુઃ પૂર્વ્વીયઃ કશ્ચિદ્ ભવિષ્યદ્વાદી સમુત્થિતઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","કિન્તુ હેરોદુવાચ યોહનઃ શિરોઽહમછિનદમ્ ઇદાનીં યસ્યેદૃક્કર્મ્મણાં વાર્ત્તાં પ્રાપ્નોમિ સ કઃ? અથ સ તં દ્રષ્ટુમ્ ઐચ્છત્| ");
INSERT INTO sanguj_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","અનન્તરં પ્રેરિતાઃ પ્રત્યાગત્ય યાનિ યાનિ કર્મ્માણિ ચક્રુસ્તાનિ યીશવે કથયામાસુઃ તતઃ સ તાન્ બૈત્સૈદાનામકનગરસ્ય વિજનં સ્થાનં નીત્વા ગુપ્તં જગામ| ");
INSERT INTO sanguj_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","પશ્ચાલ્ લોકાસ્તદ્ વિદિત્વા તસ્ય પશ્ચાદ્ યયુઃ; તતઃ સ તાન્ નયન્ ઈશ્વરીયરાજ્યસ્ય પ્રસઙ્ગમુક્તવાન્, યેષાં ચિકિત્સયા પ્રયોજનમ્ આસીત્ તાન્ સ્વસ્થાન્ ચકાર ચ| ");
INSERT INTO sanguj_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","અપરઞ્ચ દિવાવસન્ને સતિ દ્વાદશશિષ્યા યીશોરન્તિકમ્ એત્ય કથયામાસુઃ, વયમત્ર પ્રાન્તરસ્થાને તિષ્ઠામઃ, તતો નગરાણિ ગ્રામાણિ ગત્વા વાસસ્થાનાનિ પ્રાપ્ય ભક્ષ્યદ્રવ્યાણિ ક્રેતું જનનિવહં ભવાન્ વિસૃજતુ| ");
INSERT INTO sanguj_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","તદા સ ઉવાચ, યૂયમેવ તાન્ ભેજયધ્વં; તતસ્તે પ્રોચુરસ્માકં નિકટે કેવલં પઞ્ચ પૂપા દ્વૌ મત્સ્યૌ ચ વિદ્યન્તે, અતએવ સ્થાનાન્તરમ્ ઇત્વા નિમિત્તમેતેષાં ભક્ષ્યદ્રવ્યેષુ ન ક્રીતેષુ ન ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","તત્ર પ્રાયેણ પઞ્ચસહસ્રાણિ પુરુષા આસન્| ");
INSERT INTO sanguj_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","તદા સ શિષ્યાન્ જગાદ પઞ્ચાશત્ પઞ્ચાશજ્જનૈઃ પંક્તીકૃત્ય તાનુપવેશયત, તસ્માત્ તે તદનુસારેણ સર્વ્વલોકાનુપવેશયાપાસુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","તતઃ સ તાન્ પઞ્ચ પૂપાન્ મીનદ્વયઞ્ચ ગૃહીત્વા સ્વર્ગં વિલોક્યેશ્વરગુણાન્ કીર્ત્તયાઞ્ચક્રે ભઙ્ક્તા ચ લોકેભ્યઃ પરિવેષણાર્થં શિષ્યેષુ સમર્પયામ્બભૂવ| ");
INSERT INTO sanguj_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","તતઃ સર્વ્વે ભુક્ત્વા તૃપ્તિં ગતા અવશિષ્ટાનાઞ્ચ દ્વાદશ ડલ્લકાન્ સંજગૃહુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","અથૈકદા નિર્જને શિષ્યૈઃ સહ પ્રાર્થનાકાલે તાન્ પપ્રચ્છ, લોકા માં કં વદન્તિ? ");
INSERT INTO sanguj_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","તતસ્તે પ્રાચુઃ, ત્વાં યોહન્મજ્જકં વદન્તિ; કેચિત્ ત્વામ્ એલિયં વદન્તિ, પૂર્વ્વકાલિકઃ કશ્ચિદ્ ભવિષ્યદ્વાદી શ્મશાનાદ્ ઉદતિષ્ઠદ્ ઇત્યપિ કેચિદ્ વદન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","તદા સ ઉવાચ, યૂયં માં કં વદથ? તતઃ પિતર ઉક્તવાન્ ત્વમ્ ઈશ્વરાભિષિક્તઃ પુરુષઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","તદા સ તાન્ દૃઢમાદિદેશ, કથામેતાં કસ્મૈચિદપિ મા કથયત| ");
INSERT INTO sanguj_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","સ પુનરુવાચ, મનુષ્યપુત્રેણ વહુયાતના ભોક્તવ્યાઃ પ્રાચીનલોકૈઃ પ્રધાનયાજકૈરધ્યાપકૈશ્ચ સોવજ્ઞાય હન્તવ્યઃ કિન્તુ તૃતીયદિવસે શ્મશાનાત્ તેનોત્થાતવ્યમ્| ");
INSERT INTO sanguj_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","અપરં સ સર્વ્વાનુવાચ, કશ્ચિદ્ યદિ મમ પશ્ચાદ્ ગન્તું વાઞ્છતિ તર્હિ સ સ્વં દામ્યતુ, દિને દિને ક્રુશં ગૃહીત્વા ચ મમ પશ્ચાદાગચ્છતુ| ");
INSERT INTO sanguj_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","યતો યઃ કશ્ચિત્ સ્વપ્રાણાન્ રિરક્ષિષતિ સ તાન્ હારયિષ્યતિ, યઃ કશ્ચિન્ મદર્થં પ્રાણાન્ હારયિષ્યતિ સ તાન્ રક્ષિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","કશ્ચિદ્ યદિ સર્વ્વં જગત્ પ્રાપ્નોતિ કિન્તુ સ્વપ્રાણાન્ હારયતિ સ્વયં વિનશ્યતિ ચ તર્હિ તસ્ય કો લાભઃ? ");
INSERT INTO sanguj_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","પુન ર્યઃ કશ્ચિન્ માં મમ વાક્યં વા લજ્જાસ્પદં જાનાતિ મનુષ્યપુત્રો યદા સ્વસ્ય પિતુશ્ચ પવિત્રાણાં દૂતાનાઞ્ચ તેજોભિઃ પરિવેષ્ટિત આગમિષ્યતિ તદા સોપિ તં લજ્જાસ્પદં જ્ઞાસ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","કિન્તુ યુષ્માનહં યથાર્થં વદામિ, ઈશ્વરીયરાજત્વં ન દૃષ્ટવા મૃત્યું નાસ્વાદિષ્યન્તે, એતાદૃશાઃ કિયન્તો લોકા અત્ર સ્થનેઽપિ દણ્ડાયમાનાઃ સન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","એતદાખ્યાનકથનાત્ પરં પ્રાયેણાષ્ટસુ દિનેષુ ગતેષુ સ પિતરં યોહનં યાકૂબઞ્ચ ગૃહીત્વા પ્રાર્થયિતું પર્વ્વતમેકં સમારુરોહ| ");
INSERT INTO sanguj_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","અથ તસ્ય પ્રાર્થનકાલે તસ્ય મુખાકૃતિરન્યરૂપા જાતા, તદીયં વસ્ત્રમુજ્જ્વલશુક્લં જાતં| ");
INSERT INTO sanguj_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","અપરઞ્ચ મૂસા એલિયશ્ચોભૌ તેજસ્વિનૌ દૃષ્ટૌ ");
INSERT INTO sanguj_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","તૌ તેન યિરૂશાલમ્પુરે યો મૃત્યુઃ સાધિષ્યતે તદીયાં કથાં તેન સાર્દ્ધં કથયિતુમ્ આરેભાતે| ");
INSERT INTO sanguj_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","તદા પિતરાદયઃ સ્વસ્ય સઙ્ગિનો નિદ્રયાકૃષ્ટા આસન્ કિન્તુ જાગરિત્વા તસ્ય તેજસ્તેન સાર્દ્ધમ્ ઉત્તિષ્ઠન્તૌ જનૌ ચ દદૃશુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","અથ તયોરુભયો ર્ગમનકાલે પિતરો યીશું બભાષે, હે ગુરોઽસ્માકં સ્થાનેઽસ્મિન્ સ્થિતિઃ શુભા, તત એકા ત્વદર્થા, એકા મૂસાર્થા, એકા એલિયાર્થા, ઇતિ તિસ્રઃ કુટ્યોસ્માભિ ર્નિર્મ્મીયન્તાં, ઇમાં કથાં સ ન વિવિચ્ય કથયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","અપરઞ્ચ તદ્વાક્યવદનકાલે પયોદ એક આગત્ય તેષામુપરિ છાયાં ચકાર, તતસ્તન્મધ્યે તયોઃ પ્રવેશાત્ તે શશઙ્કિરે| ");
INSERT INTO sanguj_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","તદા તસ્માત્ પયોદાદ્ ઇયમાકાશીયા વાણી નિર્જગામ, મમાયં પ્રિયઃ પુત્ર એતસ્ય કથાયાં મનો નિધત્ત| ");
INSERT INTO sanguj_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ઇતિ શબ્દે જાતે તે યીશુમેકાકિનં દદૃશુઃ કિન્તુ તે તદાનીં તસ્ય દર્શનસ્ય વાચમેકામપિ નોક્ત્વા મનઃસુ સ્થાપયામાસુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","પરેઽહનિ તેષુ તસ્માચ્છૈલાદ્ અવરૂઢેષુ તં સાક્ષાત્ કર્ત્તું બહવો લોકા આજગ્મુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","તેષાં મધ્યાદ્ એકો જન ઉચ્ચૈરુવાચ, હે ગુરો અહં વિનયં કરોમિ મમ પુત્રં પ્રતિ કૃપાદૃષ્ટિં કરોતુ, મમ સ એવૈકઃ પુત્રઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ભૂતેન ધૃતઃ સન્ સં પ્રસભં ચીચ્છબ્દં કરોતિ તન્મુખાત્ ફેણા નિર્ગચ્છન્તિ ચ, ભૂત ઇત્થં વિદાર્ય્ય ક્લિષ્ટ્વા પ્રાયશસ્તં ન ત્યજતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","તસ્માત્ તં ભૂતં ત્યાજયિતું તવ શિષ્યસમીપે ન્યવેદયં કિન્તુ તે ન શેકુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","તદા યીશુરવાદીત્, રે આવિશ્વાસિન્ વિપથગામિન્ વંશ કતિકાલાન્ યુષ્માભિઃ સહ સ્થાસ્યામ્યહં યુષ્માકમ્ આચરણાનિ ચ સહિષ્યે? તવ પુત્રમિહાનય| ");
INSERT INTO sanguj_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","તતસ્તસ્મિન્નાગતમાત્રે ભૂતસ્તં ભૂમૌ પાતયિત્વા વિદદાર; તદા યીશુસ્તમમેધ્યં ભૂતં તર્જયિત્વા બાલકં સ્વસ્થં કૃત્વા તસ્ય પિતરિ સમર્પયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ઈશ્વરસ્ય મહાશક્તિમ્ ઇમાં વિલોક્ય સર્વ્વે ચમચ્ચક્રુઃ; ઇત્થં યીશોઃ સર્વ્વાભિઃ ક્રિયાભિઃ સર્વ્વૈર્લોકૈરાશ્ચર્ય્યે મન્યમાને સતિ સ શિષ્યાન્ બભાષે, ");
INSERT INTO sanguj_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","કથેયં યુષ્માકં કર્ણેષુ પ્રવિશતુ, મનુષ્યપુત્રો મનુષ્યાણાં કરેષુ સમર્પયિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","કિન્તુ તે તાં કથાં ન બુબુધિરે, સ્પષ્ટત્વાભાવાત્ તસ્યા અભિપ્રાયસ્તેષાં બોધગમ્યો ન બભૂવ; તસ્યા આશયઃ ક ઇત્યપિ તે ભયાત્ પ્રષ્ટું ન શેકુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","તદનન્તરં તેષાં મધ્યે કઃ શ્રેષ્ઠઃ કથામેતાં ગૃહીત્વા તે મિથો વિવાદં ચક્રુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","તતો યીશુસ્તેષાં મનોભિપ્રાયં વિદિત્વા બાલકમેકં ગૃહીત્વા સ્વસ્ય નિકટે સ્થાપયિત્વા તાન્ જગાદ, ");
INSERT INTO sanguj_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","યો જનો મમ નામ્નાસ્ય બાલાસ્યાતિથ્યં વિદધાતિ સ મમાતિથ્યં વિદધાતિ, યશ્ચ મમાતિથ્યં વિદધાતિ સ મમ પ્રેરકસ્યાતિથ્યં વિદધાતિ, યુષ્માકં મધ્યેયઃ સ્વં સર્વ્વસ્માત્ ક્ષુદ્રં જાનીતે સ એવ શ્રેષ્ઠો ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","અપરઞ્ચ યોહન્ વ્યાજહાર હે પ્રભેा તવ નામ્ના ભૂતાન્ ત્યાજયન્તં માનુષમ્ એકં દૃષ્ટવન્તો વયં, કિન્ત્વસ્માકમ્ અપશ્ચાદ્ ગામિત્વાત્ તં ન્યષેધામ્| તદાનીં યીશુરુવાચ, ");
INSERT INTO sanguj_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","તં મા નિષેધત, યતો યો જનોસ્માકં ન વિપક્ષઃ સ એવાસ્માકં સપક્ષો ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","અનન્તરં તસ્યારોહણસમય ઉપસ્થિતે સ સ્થિરચેતા યિરૂશાલમં પ્રતિ યાત્રાં કર્ત્તું નિશ્ચિત્યાગ્રે દૂતાન્ પ્રેષયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","તસ્માત્ તે ગત્વા તસ્ય પ્રયોજનીયદ્રવ્યાણિ સંગ્રહીતું શોમિરોણીયાનાં ગ્રામં પ્રવિવિશુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","કિન્તુ સ યિરૂશાલમં નગરં યાતિ તતો હેતો ર્લોકાસ્તસ્યાતિથ્યં ન ચક્રુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","અતએવ યાકૂબ્યોહનૌ તસ્ય શિષ્યૌ તદ્ દૃષ્ટ્વા જગદતુઃ, હે પ્રભો એલિયો યથા ચકાર તથા વયમપિ કિં ગગણાદ્ આગન્તુમ્ એતાન્ ભસ્મીકર્ત્તુઞ્ચ વહ્નિમાજ્ઞાપયામઃ? ભવાન્ કિમિચ્છતિ? ");
INSERT INTO sanguj_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","કિન્તુ સ મુખં પરાવર્ત્ય તાન્ તર્જયિત્વા ગદિતવાન્ યુષ્માકં મનોભાવઃ કઃ, ઇતિ યૂયં ન જાનીથ| ");
INSERT INTO sanguj_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","મનુજસુતો મનુજાનાં પ્રાણાન્ નાશયિતું નાગચ્છત્, કિન્તુ રક્ષિતુમ્ આગચ્છત્| પશ્ચાદ્ ઇતરગ્રામં તે યયુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","તદનન્તરં પથિ ગમનકાલે જન એકસ્તં બભાષે, હે પ્રભો ભવાન્ યત્ર યાતિ ભવતા સહાહમપિ તત્ર યાસ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","તદાનીં યીશુસ્તમુવાચ, ગોમાયૂનાં ગર્ત્તા આસતે, વિહાયસીયવિહગાाનાં નીડાનિ ચ સન્તિ, કિન્તુ માનવતનયસ્ય શિરઃ સ્થાપયિતું સ્થાનં નાસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","તતઃ પરં સ ઇતરજનં જગાદ, ત્વં મમ પશ્ચાદ્ એહિ; તતઃ સ ઉવાચ, હે પ્રભો પૂર્વ્વં પિતરં શ્મશાને સ્થાપયિતું મામાદિશતુ| ");
INSERT INTO sanguj_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","તદા યીશુરુવાચ, મૃતા મૃતાન્ શ્મશાને સ્થાપયન્તુ કિન્તુ ત્વં ગત્વેશ્વરીયરાજ્યસ્ય કથાં પ્રચારય| ");
INSERT INTO sanguj_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","તતોન્યઃ કથયામાસ, હે પ્રભો મયાપિ ભવતઃ પશ્ચાદ્ ગંસ્યતે, કિન્તુ પૂર્વ્વં મમ નિવેશનસ્ય પરિજનાનામ્ અનુમતિં ગ્રહીતુમ્ અહમાદિશ્યૈ ભવતા| ");
INSERT INTO sanguj_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","તદાનીં યીશુસ્તં પ્રોક્તવાન્, યો જનો લાઙ્ગલે કરમર્પયિત્વા પશ્ચાત્ પશ્યતિ સ ઈશ્વરીયરાજ્યં નાર્હતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","તતઃ પરં પ્રભુરપરાન્ સપ્તતિશિષ્યાન્ નિયુજ્ય સ્વયં યાનિ નગરાણિ યાનિ સ્થાનાનિ ચ ગમિષ્યતિ તાનિ નગરાણિ તાનિ સ્થાનાનિ ચ પ્રતિ દ્વૌ દ્વૌ જનૌ પ્રહિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","તેભ્યઃ કથયામાસ ચ શસ્યાનિ બહૂનીતિ સત્યં કિન્તુ છેદકા અલ્પે; તસ્માદ્ધેતોઃ શસ્યક્ષેત્રે છેદકાન્ અપરાનપિ પ્રેષયિતું ક્ષેત્રસ્વામિનં પ્રાર્થયધ્વં| ");
INSERT INTO sanguj_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","યૂયં યાત, પશ્યત, વૃકાણાં મધ્યે મેષશાવકાનિવ યુષ્માન્ પ્રહિણોમિ| ");
INSERT INTO sanguj_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","યૂયં ક્ષુદ્રં મહદ્ વા વસનસમ્પુટકં પાદુકાશ્ચ મા ગૃહ્લીત, માર્ગમધ્યે કમપિ મા નમત ચ| ");
INSERT INTO sanguj_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","અપરઞ્ચ યૂયં યદ્ યત્ નિવેશનં પ્રવિશથ તત્ર નિવેશનસ્યાસ્ય મઙ્ગલં ભૂયાદિતિ વાક્યં પ્રથમં વદત| ");
INSERT INTO sanguj_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","તસ્માત્ તસ્મિન્ નિવેશને યદિ મઙ્ગલપાત્રં સ્થાસ્યતિ તર્હિ તન્મઙ્ગલં તસ્ય ભવિષ્યતિ, નોચેત્ યુષ્માન્ પ્રતિ પરાવર્ત્તિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","અપરઞ્ચ તે યત્કિઞ્ચિદ્ દાસ્યન્તિ તદેવ ભુક્ત્વા પીત્વા તસ્મિન્નિવેશને સ્થાસ્યથ; યતઃ કર્મ્મકારી જનો ભૃતિમ્ અર્હતિ; ગૃહાદ્ ગૃહં મા યાસ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","અન્યચ્ચ યુષ્માસુ કિમપિ નગરં પ્રવિષ્ટેષુ લોકા યદિ યુષ્માકમ્ આતિથ્યં કરિષ્યન્તિ, તર્હિ યત્ ખાદ્યમ્ ઉપસ્થાસ્યન્તિ તદેવ ખાદિષ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","તન્નગરસ્થાન્ રોગિણઃ સ્વસ્થાન્ કરિષ્યથ, ઈશ્વરીયં રાજ્યં યુષ્માકમ્ અન્તિકમ્ આગમત્ કથામેતાઞ્ચ પ્રચારયિષ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","કિન્તુ કિમપિ પુરં યુષ્માસુ પ્રવિષ્ટેષુ લોકા યદિ યુષ્માકમ્ આતિથ્યં ન કરિષ્યન્તિ, તર્હિ તસ્ય નગરસ્ય પન્થાનં ગત્વા કથામેતાં વદિષ્યથ, ");
INSERT INTO sanguj_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","યુષ્માકં નગરીયા યા ધૂલ્યોઽસ્માસુ સમલગન્ તા અપિ યુષ્માકં પ્રાતિકૂલ્યેન સાક્ષ્યાર્થં સમ્પાતયામઃ; તથાપીશ્વરરાજ્યં યુષ્માકં સમીપમ્ આગતમ્ ઇતિ નિશ્ચિતં જાનીત| ");
INSERT INTO sanguj_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","અહં યુષ્મભ્યં યથાર્થં કથયામિ, વિચારદિને તસ્ય નગરસ્ય દશાતઃ સિદોમો દશા સહ્યા ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","હા હા કોરાસીન્ નગર, હા હા બૈત્સૈદાનગર યુવયોર્મધ્યે યાદૃશાનિ આશ્ચર્ય્યાણિ કર્મ્માણ્યક્રિયન્ત, તાનિ કર્મ્માણિ યદિ સોરસીદોનો ર્નગરયોરકારિષ્યન્ત, તદા ઇતો બહુદિનપૂર્વ્વં તન્નિવાસિનઃ શણવસ્ત્રાણિ પરિધાય ગાત્રેષુ ભસ્મ વિલિપ્ય સમુપવિશ્ય સમખેત્સ્યન્ત| ");
INSERT INTO sanguj_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","અતો વિચારદિવસે યુષ્માકં દશાતઃ સોરસીદોન્નિવાસિનાં દશા સહ્યા ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","હે કફર્નાહૂમ્, ત્વં સ્વર્ગં યાવદ્ ઉન્નતા કિન્તુ નરકં યાવત્ ન્યગ્ભવિષ્યસિ| ");
INSERT INTO sanguj_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","યો જનો યુષ્માકં વાક્યં ગૃહ્લાતિ સ મમૈવ વાક્યં ગૃહ્લાતિ; કિઞ્ચ યો જનો યુષ્માકમ્ અવજ્ઞાં કરોતિ સ મમૈવાવજ્ઞાં કરોતિ; યો જનો મમાવજ્ઞાં કરોતિ ચ સ મત્પ્રેરકસ્યૈવાવજ્ઞાં કરોતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","અથ તે સપ્તતિશિષ્યા આનન્દેન પ્રત્યાગત્ય કથયામાસુઃ, હે પ્રભો ભવતો નામ્ના ભૂતા અપ્યસ્માકં વશીભવન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","તદાનીં સ તાન્ જગાદ, વિદ્યુતમિવ સ્વર્ગાત્ પતન્તં શૈતાનમ્ અદર્શમ્| ");
INSERT INTO sanguj_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","પશ્યત સર્પાન્ વૃશ્ચિકાન્ રિપોઃ સર્વ્વપરાક્રમાંશ્ચ પદતલૈ ર્દલયિતું યુષ્મભ્યં શક્તિં દદામિ તસ્માદ્ યુષ્માકં કાપિ હાનિ ર્ન ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","ભૂતા યુષ્માકં વશીભવન્તિ, એતન્નિમિત્તત્ મા સમુલ્લસત, સ્વર્ગે યુષ્માકં નામાનિ લિખિતાનિ સન્તીતિ નિમિત્તં સમુલ્લસત| ");
INSERT INTO sanguj_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","તદ્ઘટિકાયાં યીશુ ર્મનસિ જાતાહ્લાદઃ કથયામાસ હે સ્વર્ગપૃથિવ્યોરેકાધિપતે પિતસ્ત્વં જ્ઞાનવતાં વિદુષાઞ્ચ લોકાનાં પુરસ્તાત્ સર્વ્વમેતદ્ અપ્રકાશ્ય બાલકાનાં પુરસ્તાત્ પ્રાકાશય એતસ્માદ્ધેતોસ્ત્વાં ધન્યં વદામિ, હે પિતરિત્થં ભવતુ યદ્ એતદેવ તવ ગોચર ઉત્તમમ્| ");
INSERT INTO sanguj_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","પિત્રા સર્વ્વાણિ મયિ સમર્પિતાનિ પિતરં વિના કોપિ પુત્રં ન જાનાતિ કિઞ્ચ પુત્રં વિના યસ્મૈ જનાય પુત્રસ્તં પ્રકાશિતવાન્ તઞ્ચ વિના કોપિ પિતરં ન જાનાતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","તપઃ પરં સ શિષ્યાન્ પ્રતિ પરાવૃત્ય ગુપ્તં જગાદ, યૂયમેતાનિ સર્વ્વાણિ પશ્યથ તતો યુષ્માકં ચક્ષૂંષિ ધન્યાનિ| ");
INSERT INTO sanguj_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","યુષ્માનહં વદામિ, યૂયં યાનિ સર્વ્વાણિ પશ્યથ તાનિ બહવો ભવિષ્યદ્વાદિનો ભૂપતયશ્ચ દ્રષ્ટુમિચ્છન્તોપિ દ્રષ્ટું ન પ્રાપ્નુવન્, યુષ્માભિ ર્યા યાઃ કથાશ્ચ શ્રૂયન્તે તાઃ શ્રોતુમિચ્છન્તોપિ શ્રોતું નાલભન્ત| ");
INSERT INTO sanguj_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","અનન્તરમ્ એકો વ્યવસ્થાપક ઉત્થાય તં પરીક્ષિતું પપ્રચ્છ, હે ઉપદેશક અનન્તાયુષઃ પ્રાપ્તયે મયા કિં કરણીયં? ");
INSERT INTO sanguj_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","યીશુઃ પ્રત્યુવાચ, અત્રાર્થે વ્યવસ્થાયાં કિં લિખિતમસ્તિ? ત્વં કીદૃક્ પઠસિ? ");
INSERT INTO sanguj_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","તતઃ સોવદત્, ત્વં સર્વ્વાન્તઃકરણૈઃ સર્વ્વપ્રાણૈઃ સર્વ્વશક્તિભિઃ સર્વ્વચિત્તૈશ્ચ પ્રભૌ પરમેશ્વરે પ્રેમ કુરુ, સમીપવાસિનિ સ્વવત્ પ્રેમ કુરુ ચ| ");
INSERT INTO sanguj_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","તદા સ કથયામાસ, ત્વં યથાર્થં પ્રત્યવોચઃ, ઇત્થમ્ આચર તેનૈવ જીવિષ્યસિ| ");
INSERT INTO sanguj_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","કિન્તુ સ જનઃ સ્વં નિર્દ્દોષં જ્ઞાપયિતું યીશું પપ્રચ્છ, મમ સમીપવાસી કઃ? તતો યીશુઃ પ્રત્યુવાચ, ");
INSERT INTO sanguj_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","એકો જનો યિરૂશાલમ્પુરાદ્ યિરીહોપુરં યાતિ, એતર્હિ દસ્યૂનાં કરેષુ પતિતે તે તસ્ય વસ્ત્રાદિકં હૃતવન્તઃ તમાહત્ય મૃતપ્રાયં કૃત્વા ત્યક્ત્વા યયુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","અકસ્માદ્ એકો યાજકસ્તેન માર્ગેણ ગચ્છન્ તં દૃષ્ટ્વા માર્ગાન્યપાર્શ્વેન જગામ| ");
INSERT INTO sanguj_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ઇત્થમ્ એકો લેવીયસ્તત્સ્થાનં પ્રાપ્ય તસ્યાન્તિકં ગત્વા તં વિલોક્યાન્યેન પાર્શ્વેન જગામ| ");
INSERT INTO sanguj_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","કિન્ત્વેકઃ શોમિરોણીયો ગચ્છન્ તત્સ્થાનં પ્રાપ્ય તં દૃષ્ટ્વાદયત| ");
INSERT INTO sanguj_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","તસ્યાન્તિકં ગત્વા તસ્ય ક્ષતેષુ તૈલં દ્રાક્ષારસઞ્ચ પ્રક્ષિપ્ય ક્ષતાનિ બદ્ધ્વા નિજવાહનોપરિ તમુપવેશ્ય પ્રવાસીયગૃહમ્ આનીય તં સિષેવે| ");
INSERT INTO sanguj_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","પરસ્મિન્ દિવસે નિજગમનકાલે દ્વૌ મુદ્રાપાદૌ તદ્ગૃહસ્વામિને દત્ત્વાવદત્ જનમેનં સેવસ્વ તત્ર યોઽધિકો વ્યયો ભવિષ્યતિ તમહં પુનરાગમનકાલે પરિશોત્સ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","એષાં ત્રયાણાં મધ્યે તસ્ય દસ્યુહસ્તપતિતસ્ય જનસ્ય સમીપવાસી કઃ? ત્વયા કિં બુધ્યતે? ");
INSERT INTO sanguj_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","તતઃ સ વ્યવસ્થાપકઃ કથયામાસ યસ્તસ્મિન્ દયાં ચકાર| તદા યીશુઃ કથયામાસ ત્વમપિ ગત્વા તથાચર| ");
INSERT INTO sanguj_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","તતઃ પરં તે ગચ્છન્ત એકં ગ્રામં પ્રવિવિશુઃ; તદા મર્થાનામા સ્ત્રી સ્વગૃહે તસ્યાતિથ્યં ચકાર| ");
INSERT INTO sanguj_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","તસ્માત્ મરિયમ્ નામધેયા તસ્યા ભગિની યીશોઃ પદસમીપ ઉવવિશ્ય તસ્યોપદેશકથાં શ્રોતુમારેભે| ");
INSERT INTO sanguj_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","કિન્તુ મર્થા નાનાપરિચર્ય્યાયાં વ્યગ્રા બભૂવ તસ્માદ્ધેતોસ્તસ્ય સમીપમાગત્ય બભાષે; હે પ્રભો મમ ભગિની કેવલં મમોપરિ સર્વ્વકર્મ્મણાં ભારમ્ અર્પિતવતી તત્ર ભવતા કિઞ્ચિદપિ ન મનો નિધીયતે કિમ્? મમ સાહાય્યં કર્ત્તું ભવાન્ તામાદિશતુ| ");
INSERT INTO sanguj_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","તતો યીશુઃ પ્રત્યુવાચ હે મર્થે હે મર્થે, ત્વં નાનાકાર્ય્યેષુ ચિન્તિતવતી વ્યગ્રા ચાસિ, ");
INSERT INTO sanguj_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","કિન્તુ પ્રયોજનીયમ્ એકમાત્રમ્ આસ્તે| અપરઞ્ચ યમુત્તમં ભાગં કોપિ હર્ત્તું ન શક્નોતિ સએવ મરિયમા વૃતઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","અનન્તરં સ કસ્મિંશ્ચિત્ સ્થાને પ્રાર્થયત તત્સમાપ્તૌ સત્યાં તસ્યૈકઃ શિષ્યસ્તં જગાદ હે પ્રભો યોહન્ યથા સ્વશિષ્યાન્ પ્રાર્થયિતુમ્ ઉપદિષ્ટવાન્ તથા ભવાનપ્યસ્માન્ ઉપદિશતુ| ");
INSERT INTO sanguj_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","તસ્માત્ સ કથયામાસ, પ્રાર્થનકાલે યૂયમ્ ઇત્થં કથયધ્વં, હે અસ્માકં સ્વર્ગસ્થપિતસ્તવ નામ પૂજ્યં ભવતુ; તવ રાજત્વં ભવતુ; સ્વર્ગે યથા તથા પૃથિવ્યામપિ તવેચ્છયા સર્વ્વં ભવતુ| ");
INSERT INTO sanguj_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","પ્રત્યહમ્ અસ્માકં પ્રયોજનીયં ભોજ્યં દેહિ| ");
INSERT INTO sanguj_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","યથા વયં સર્વ્વાન્ અપરાધિનઃ ક્ષમામહે તથા ત્વમપિ પાપાન્યસ્માકં ક્ષમસ્વ| અસ્માન્ પરીક્ષાં માનય કિન્તુ પાપાત્મનો રક્ષ| ");
INSERT INTO sanguj_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","પશ્ચાત્ સોપરમપિ કથિતવાન્ યદિ યુષ્માકં કસ્યચિદ્ બન્ધુસ્તિષ્ઠતિ નિશીથે ચ તસ્ય સમીપં સ ગત્વા વદતિ, ");
INSERT INTO sanguj_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","હે બન્ધો પથિક એકો બન્ધુ ર્મમ નિવેશનમ્ આયાતઃ કિન્તુ તસ્યાતિથ્યં કર્ત્તું મમાન્તિકે કિમપિ નાસ્તિ, અતએવ પૂપત્રયં મહ્યમ્ ઋણં દેહિ; ");
INSERT INTO sanguj_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","તદા સ યદિ ગૃહમધ્યાત્ પ્રતિવદતિ માં મા ક્લિશાન, ઇદાનીં દ્વારં રુદ્ધં શયને મયા સહ બાલકાશ્ચ તિષ્ઠન્તિ તુભ્યં દાતુમ્ ઉત્થાતું ન શક્નોમિ, ");
INSERT INTO sanguj_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","તર્હિ યુષ્માનહં વદામિ, સ યદિ મિત્રતયા તસ્મૈ કિમપિ દાતું નોત્તિષ્ઠતિ તથાપિ વારં વારં પ્રાર્થનાત ઉત્થાપિતઃ સન્ યસ્મિન્ તસ્ય પ્રયોજનં તદેવ દાસ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","અતઃ કારણાત્ કથયામિ, યાચધ્વં તતો યુષ્મભ્યં દાસ્યતે, મૃગયધ્વં તત ઉદ્દેશં પ્રાપ્સ્યથ, દ્વારમ્ આહત તતો યુષ્મભ્યં દ્વારં મોક્ષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","યો યાચતે સ પ્રાપ્નોતિ, યો મૃગયતે સ એવોદ્દેશં પ્રાપ્નોતિ, યો દ્વારમ્ આહન્તિ તદર્થં દ્વારં મોચ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","પુત્રેણ પૂપે યાચિતે તસ્મૈ પાષાણં દદાતિ વા મત્સ્યે યાચિતે તસ્મૈ સર્પં દદાતિ ");
INSERT INTO sanguj_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","વા અણ્ડે યાચિતે તસ્મૈ વૃશ્ચિકં દદાતિ યુષ્માકં મધ્યે ક એતાદૃશઃ પિતાસ્તે? ");
INSERT INTO sanguj_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","તસ્માદેવ યૂયમભદ્રા અપિ યદિ સ્વસ્વબાલકેભ્ય ઉત્તમાનિ દ્રવ્યાણિ દાતું જાનીથ તર્હ્યસ્માકં સ્વર્ગસ્થઃ પિતા નિજયાચકેભ્યઃ કિં પવિત્રમ્ આત્માનં ન દાસ્યતિ? ");
INSERT INTO sanguj_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","અનન્તરં યીશુના કસ્માચ્ચિદ્ એકસ્મિન્ મૂકભૂતે ત્યાજિતે સતિ સ ભૂતત્યક્તો માનુષો વાક્યં વક્તુમ્ આરેભે; તતો લોકાઃ સકલા આશ્ચર્ય્યં મેનિરે| ");
INSERT INTO sanguj_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","કિન્તુ તેષાં કેચિદૂચુ ર્જનોયં બાલસિબૂબા અર્થાદ્ ભૂતરાજેન ભૂતાન્ ત્યાજયતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","તં પરીક્ષિતું કેચિદ્ આકાશીયમ્ એકં ચિહ્નં દર્શયિતું તં પ્રાર્થયાઞ્ચક્રિરે| ");
INSERT INTO sanguj_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","તદા સ તેષાં મનઃકલ્પનાં જ્ઞાત્વા કથયામાસ, કસ્યચિદ્ રાજ્યસ્ય લોકા યદિ પરસ્પરં વિરુન્ધન્તિ તર્હિ તદ્ રાજ્યમ્ નશ્યતિ; કેચિદ્ ગૃહસ્થા યદિ પરસ્પરં વિરુન્ધન્તિ તર્હિ તેપિ નશ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","તથૈવ શૈતાનપિ સ્વલોકાન્ યદિ વિરુણદ્ધિ તદા તસ્ય રાજ્યં કથં સ્થાસ્યતિ? બાલસિબૂબાહં ભૂતાન્ ત્યાજયામિ યૂયમિતિ વદથ| ");
INSERT INTO sanguj_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","યદ્યહં બાલસિબૂબા ભૂતાન્ ત્યાજયામિ તર્હિ યુષ્માકં સન્તાનાઃ કેન ત્યાજયન્તિ? તસ્માત્ તએવ કથાયા એતસ્યા વિચારયિતારો ભવિષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","કિન્તુ યદ્યહમ્ ઈશ્વરસ્ય પરાક્રમેણ ભૂતાન્ ત્યાજયામિ તર્હિ યુષ્માકં નિકટમ્ ઈશ્વરસ્ય રાજ્યમવશ્યમ્ ઉપતિષ્ઠતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","બલવાન્ પુમાન્ સુસજ્જમાનો યતિકાલં નિજાટ્ટાલિકાં રક્ષતિ તતિકાલં તસ્ય દ્રવ્યં નિરુપદ્રવં તિષ્ઠતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","કિન્તુ તસ્માદ્ અધિકબલઃ કશ્ચિદાગત્ય યદિ તં જયતિ તર્હિ યેષુ શસ્ત્રાસ્ત્રેષુ તસ્ય વિશ્વાસ આસીત્ તાનિ સર્વ્વાણિ હૃત્વા તસ્ય દ્રવ્યાણિ ગૃહ્લાતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","અતઃ કારણાદ્ યો મમ સપક્ષો ન સ વિપક્ષઃ, યો મયા સહ ન સંગૃહ્લાતિ સ વિકિરતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","અપરઞ્ચ અમેધ્યભૂતો માનુષસ્યાન્તર્નિર્ગત્ય શુષ્કસ્થાને ભ્રાન્ત્વા વિશ્રામં મૃગયતે કિન્તુ ન પ્રાપ્ય વદતિ મમ યસ્માદ્ ગૃહાદ્ આગતોહં પુનસ્તદ્ ગૃહં પરાવૃત્ય યામિ| ");
INSERT INTO sanguj_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","તતો ગત્વા તદ્ ગૃહં માર્જિતં શોભિતઞ્ચ દૃષ્ટ્વા ");
INSERT INTO sanguj_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","તત્ક્ષણમ્ અપગત્ય સ્વસ્માદપિ દુર્મ્મતીન્ અપરાન્ સપ્તભૂતાન્ સહાનયતિ તે ચ તદ્ગૃહં પવિશ્ય નિવસન્તિ| તસ્માત્ તસ્ય મનુષ્યસ્ય પ્રથમદશાતઃ શેષદશા દુઃખતરા ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","અસ્યાઃ કથાયાઃ કથનકાલે જનતામધ્યસ્થા કાચિન્નારી તમુચ્ચૈઃસ્વરં પ્રોવાચ, યા યોષિત્ ત્વાં ગર્બ્ભેઽધારયત્ સ્તન્યમપાયયચ્ચ સૈવ ધન્યા| ");
INSERT INTO sanguj_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","કિન્તુ સોકથયત્ યે પરમેશ્વરસ્ય કથાં શ્રુત્વા તદનુરૂપમ્ આચરન્તિ તએવ ધન્યાઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","તતઃ પરં તસ્યાન્તિકે બહુલોકાનાં સમાગમે જાતે સ વક્તુમારેભે, આધુનિકા દુષ્ટલોકાશ્ચિહ્નં દ્રષ્ટુમિચ્છન્તિ કિન્તુ યૂનસ્ભવિષ્યદ્વાદિનશ્ચિહ્નં વિનાન્યત્ કિઞ્ચિચ્ચિહ્નં તાન્ ન દર્શયિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","યૂનસ્ તુ યથા નીનિવીયલોકાનાં સમીપે ચિહ્નરૂપોભવત્ તથા વિદ્યમાનલોકાનામ્ એષાં સમીપે મનુષ્યપુત્રોપિ ચિહ્નરૂપો ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","વિચારસમયે ઇદાનીન્તનલોકાનાં પ્રાતિકૂલ્યેન દક્ષિણદેશીયા રાજ્ઞી પ્રોત્થાય તાન્ દોષિણઃ કરિષ્યતિ, યતઃ સા રાજ્ઞી સુલેમાન ઉપદેશકથાં શ્રોતું પૃથિવ્યાઃ સીમાત આગચ્છત્ કિન્તુ પશ્યત સુલેમાનોપિ ગુરુતર એકો જનોઽસ્મિન્ સ્થાને વિદ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","અપરઞ્ચ વિચારસમયે નીનિવીયલોકા અપિ વર્ત્તમાનકાલિકાનાં લોકાનાં વૈપરીત્યેન પ્રોત્થાય તાન્ દોષિણઃ કરિષ્યન્તિ, યતો હેતોસ્તે યૂનસો વાક્યાત્ ચિત્તાનિ પરિવર્ત્તયામાસુઃ કિન્તુ પશ્યત યૂનસોતિગુરુતર એકો જનોઽસ્મિન્ સ્થાને વિદ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","પ્રદીપં પ્રજ્વાલ્ય દ્રોણસ્યાધઃ કુત્રાપિ ગુપ્તસ્થાને વા કોપિ ન સ્થાપયતિ કિન્તુ ગૃહપ્રવેશિભ્યો દીપ્તિં દાતં દીપાધારોપર્ય્યેવ સ્થાપયતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","દેહસ્ય પ્રદીપશ્ચક્ષુસ્તસ્માદેવ ચક્ષુ ર્યદિ પ્રસન્નં ભવતિ તર્હિ તવ સર્વ્વશરીરં દીપ્તિમદ્ ભવિષ્યતિ કિન્તુ ચક્ષુ ર્યદિ મલીમસં તિષ્ઠતિ તર્હિ સર્વ્વશરીરં સાન્ધકારં સ્થાસ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","અસ્માત્ કારણાત્ તવાન્તઃસ્થં જ્યોતિ ર્યથાન્ધકારમયં ન ભવતિ તદર્થે સાવધાનો ભવ| ");
INSERT INTO sanguj_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","યતઃ શરીરસ્ય કુત્રાપ્યંશે સાન્ધકારે ન જાતે સર્વ્વં યદિ દીપ્તિમત્ તિષ્ઠતિ તર્હિ તુભ્યં દીપ્તિદાયિપ્રોજ્જ્વલન્ પ્રદીપ ઇવ તવ સવર્વશરીરં દીપ્તિમદ્ ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","એતત્કથાયાઃ કથનકાલે ફિરુશ્યેકો ભેજનાય તં નિમન્ત્રયામાસ, તતઃ સ ગત્વા ભોક્તુમ્ ઉપવિવેશ| ");
INSERT INTO sanguj_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","કિન્તુ ભોજનાત્ પૂર્વ્વં નામાઙ્ક્ષીત્ એતદ્ દૃષ્ટ્વા સ ફિરુશ્યાશ્ચર્ય્યં મેને| ");
INSERT INTO sanguj_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","તદા પ્રભુસ્તં પ્રોવાચ યૂયં ફિરૂશિલોકાઃ પાનપાત્રાણાં ભોજનપાત્રાણાઞ્ચ બહિઃ પરિષ્કુરુથ કિન્તુ યુષ્માકમન્ત ર્દૌરાત્મ્યૈ ર્દુષ્ક્રિયાભિશ્ચ પરિપૂર્ણં તિષ્ઠતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","હે સર્વ્વે નિર્બોધા યો બહિઃ સસર્જ સ એવ કિમન્ત ર્ન સસર્જ? ");
INSERT INTO sanguj_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","તત એવ યુષ્માભિરન્તઃકરણં (ઈશ્વરાય) નિવેદ્યતાં તસ્મિન્ કૃતે યુષ્માકં સર્વ્વાણિ શુચિતાં યાસ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","કિન્તુ હન્ત ફિરૂશિગણા યૂયં ન્યાયમ્ ઈશ્વરે પ્રેમ ચ પરિત્યજ્ય પોદિનાયા અરુદાદીનાં સર્વ્વેષાં શાકાનાઞ્ચ દશમાંશાન્ દત્થ કિન્તુ પ્રથમં પાલયિત્વા શેષસ્યાલઙ્ઘનં યુષ્માકમ્ ઉચિતમાસીત્| ");
INSERT INTO sanguj_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","હા હા ફિરૂશિનો યૂયં ભજનગેહે પ્રોચ્ચાસને આપણેષુ ચ નમસ્કારેષુ પ્રીયધ્વે| ");
INSERT INTO sanguj_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","વત કપટિનોઽધ્યાપકાઃ ફિરૂશિનશ્ચ લોકાયત્ શ્મશાનમ્ અનુપલભ્ય તદુપરિ ગચ્છન્તિ યૂયમ્ તાદૃગપ્રકાશિતશ્મશાનવાદ્ ભવથ| ");
INSERT INTO sanguj_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","તદાનીં વ્યવસ્થાપકાનામ્ એકા યીશુમવદત્, હે ઉપદેશક વાક્યેનેદૃશેનાસ્માસ્વપિ દોષમ્ આરોપયસિ| ");
INSERT INTO sanguj_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","તતઃ સ ઉવાચ, હા હા વ્યવસ્થાપકા યૂયમ્ માનુષાણામ્ ઉપરિ દુઃસહ્યાન્ ભારાન્ ન્યસ્યથ કિન્તુ સ્વયમ્ એકાઙ્ગુुલ્યાપિ તાન્ ભારાન્ ન સ્પૃશથ| ");
INSERT INTO sanguj_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","હન્ત યુષ્માકં પૂર્વ્વપુરુષા યાન્ ભવિષ્યદ્વાદિનોઽવધિષુસ્તેષાં શ્મશાનાનિ યૂયં નિર્મ્માથ| ");
INSERT INTO sanguj_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","તેનૈવ યૂયં સ્વપૂર્વ્વપુરુષાણાં કર્મ્માણિ સંમન્યધ્વે તદેવ સપ્રમાણં કુરુથ ચ, યતસ્તે તાનવધિષુઃ યૂયં તેષાં શ્મશાનાનિ નિર્મ્માથ| ");
INSERT INTO sanguj_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","અતએવ ઈશ્વરસ્ય શાસ્ત્રે પ્રોક્તમસ્તિ તેષામન્તિકે ભવિષ્યદ્વાદિનઃ પ્રેરિતાંશ્ચ પ્રેષયિષ્યામિ તતસ્તે તેષાં કાંશ્ચન હનિષ્યન્તિ કાંશ્ચન તાડશ્ષ્યિન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","એતસ્માત્ કારણાત્ હાબિલઃ શોણિતપાતમારભ્ય મન્દિરયજ્ઞવેદ્યો ર્મધ્યે હતસ્ય સિખરિયસ્ય રક્તપાતપર્ય્યન્તં ");
INSERT INTO sanguj_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","જગતઃ સૃષ્ટિમારભ્ય પૃથિવ્યાં ભવિષ્યદ્વાદિનાં યતિરક્તપાતા જાતાસ્તતીનામ્ અપરાધદણ્ડા એષાં વર્ત્તમાનલોકાનાં ભવિષ્યન્તિ, યુષ્માનહં નિશ્ચિતં વદામિ સર્વ્વે દણ્ડા વંશસ્યાસ્ય ભવિષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","હા હા વ્યવસ્થપકા યૂયં જ્ઞાનસ્ય કુઞ્ચિકાં હૃત્વા સ્વયં ન પ્રવિષ્ટા યે પ્રવેષ્ટુઞ્ચ પ્રયાસિનસ્તાનપિ પ્રવેષ્ટું વારિતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","ઇત્થં કથાકથનાદ્ અધ્યાપકાઃ ફિરૂશિનશ્ચ સતર્કાઃ ");
INSERT INTO sanguj_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","સન્તસ્તમપવદિતું તસ્ય કથાયા દોષં ધર્ત્તમિચ્છન્તો નાનાખ્યાનકથનાય તં પ્રવર્ત્તયિતું કોપયિતુઞ્ચ પ્રારેભિરે| ");
INSERT INTO sanguj_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","તદાનીં લોકાઃ સહસ્રં સહસ્રમ્ આગત્ય સમુપસ્થિતાસ્તત એકૈકો ઽન્યેષામુપરિ પતિતુમ્ ઉપચક્રમે; તદા યીશુઃ શિષ્યાન્ બભાષે, યૂયં ફિરૂશિનાં કિણ્વરૂપકાપટ્યે વિશેષેણ સાવધાનાસ્તિષ્ઠત| ");
INSERT INTO sanguj_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","યતો યન્ન પ્રકાશયિષ્યતે તદાચ્છન્નં વસ્તુ કિમપિ નાસ્તિ; તથા યન્ન જ્ઞાસ્યતે તદ્ ગુપ્તં વસ્તુ કિમપિ નાસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","અન્ધકારે તિષ્ઠનતો યાઃ કથા અકથયત તાઃ સર્વ્વાઃ કથા દીપ્તૌ શ્રોષ્યન્તે નિર્જને કર્ણે ચ યદકથયત ગૃહપૃષ્ઠાત્ તત્ પ્રચારયિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","હે બન્ધવો યુષ્માનહં વદામિ, યે શરીરસ્ય નાશં વિના કિમપ્યપરં કર્ત્તું ન શક્રુવન્તિ તેભ્યો મા ભૈષ્ટ| ");
INSERT INTO sanguj_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","તર્હિ કસ્માદ્ ભેતવ્યમ્ ઇત્યહં વદામિ, યઃ શરીરં નાશયિત્વા નરકં નિક્ષેપ્તું શક્નોતિ તસ્માદેવ ભયં કુરુત, પુનરપિ વદામિ તસ્માદેવ ભયં કુરુત| ");
INSERT INTO sanguj_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","પઞ્ચ ચટકપક્ષિણઃ કિં દ્વાભ્યાં તામ્રખણ્ડાભ્યાં ન વિક્રીયન્તે? તથાપીશ્વરસ્તેષામ્ એકમપિ ન વિસ્મરતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","યુષ્માકં શિરઃકેશા અપિ ગણિતાઃ સન્તિ તસ્માત્ મા વિભીત બહુચટકપક્ષિભ્યોપિ યૂયં બહુમૂલ્યાઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","અપરં યુષ્મભ્યં કથયામિ યઃ કશ્ચિન્ માનુષાણાં સાક્ષાન્ માં સ્વીકરોતિ મનુષ્યપુત્ર ઈશ્વરદૂતાનાં સાક્ષાત્ તં સ્વીકરિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","કિન્તુ યઃ કશ્ચિન્માનુષાણાં સાક્ષાન્મામ્ અસ્વીકરોતિ તમ્ ઈશ્વરસ્ય દૂતાનાં સાક્ષાદ્ અહમ્ અસ્વીકરિષ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","અન્યચ્ચ યઃ કશ્ચિન્ મનુજસુતસ્ય નિન્દાભાવેન કાઞ્ચિત્ કથાં કથયતિ તસ્ય તત્પાપસ્ય મોચનં ભવિષ્યતિ કિન્તુ યદિ કશ્ચિત્ પવિત્રમ્ આત્માનં નિન્દતિ તર્હિ તસ્ય તત્પાપસ્ય મોચનં ન ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","યદા લોકા યુષ્માન્ ભજનગેહં વિચારકર્તૃરાજ્યકર્તૃણાં સમ્મુખઞ્ચ નેષ્યન્તિ તદા કેન પ્રકારેણ કિમુત્તરં વદિષ્યથ કિં કથયિષ્યથ ચેત્યત્ર મા ચિન્તયત; ");
INSERT INTO sanguj_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","યતો યુષ્માભિર્યદ્ યદ્ વક્તવ્યં તત્ તસ્મિન્ સમયએવ પવિત્ર આત્મા યુષ્માન્ શિક્ષયિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","તતઃ પરં જનતામધ્યસ્થઃ કશ્ચિજ્જનસ્તં જગાદ હે ગુરો મયા સહ પૈતૃકં ધનં વિભક્તું મમ ભ્રાતરમાજ્ઞાપયતુ ભવાન્| ");
INSERT INTO sanguj_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","કિન્તુ સ તમવદત્ હે મનુષ્ય યુવયો ર્વિચારં વિભાગઞ્ચ કર્ત્તું માં કો નિયુક્તવાન્? ");
INSERT INTO sanguj_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","અનન્તરં સ લોકાનવદત્ લોભે સાવધાનાઃ સતર્કાશ્ચ તિષ્ઠત, યતો બહુસમ્પત્તિપ્રાપ્ત્યા મનુષ્યસ્યાયુ ર્ન ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","પશ્ચાદ્ દૃષ્ટાન્તકથામુત્થાપ્ય કથયામાસ, એકસ્ય ધનિનો ભૂમૌ બહૂનિ શસ્યાનિ જાતાનિ| ");
INSERT INTO sanguj_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","તતઃ સ મનસા ચિન્તયિત્વા કથયામ્બભૂવ મમૈતાનિ સમુત્પન્નાનિ દ્રવ્યાણિ સ્થાપયિતું સ્થાનં નાસ્તિ કિં કરિષ્યામિ? ");
INSERT INTO sanguj_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","તતોવદદ્ ઇત્થં કરિષ્યામિ, મમ સર્વ્વભાણ્ડાગારાણિ ભઙ્ક્ત્વા બૃહદ્ભાણ્ડાગારાણિ નિર્મ્માય તન્મધ્યે સર્વ્વફલાનિ દ્રવ્યાણિ ચ સ્થાપયિષ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","અપરં નિજમનો વદિષ્યામિ, હે મનો બહુવત્સરાર્થં નાનાદ્રવ્યાણિ સઞ્ચિતાનિ સન્તિ વિશ્રામં કુરુ ભુક્ત્વા પીત્વા કૌતુકઞ્ચ કુરુ| કિન્ત્વીશ્વરસ્તમ્ અવદત્, ");
INSERT INTO sanguj_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","રે નિર્બોધ અદ્ય રાત્રૌ તવ પ્રાણાસ્ત્વત્તો નેષ્યન્તે તત એતાનિ યાનિ દ્રવ્યાણિ ત્વયાસાદિતાનિ તાનિ કસ્ય ભવિષ્યન્તિ? ");
INSERT INTO sanguj_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","અતએવ યઃ કશ્ચિદ્ ઈશ્વરસ્ય સમીપે ધનસઞ્ચયમકૃત્વા કેવલં સ્વનિકટે સઞ્ચયં કરોતિ સોપિ તાદૃશઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","અથ સ શિષ્યેભ્યઃ કથયામાસ, યુષ્માનહં વદામિ, કિં ખાદિષ્યામઃ? કિં પરિધાસ્યામઃ? ઇત્યુક્ત્વા જીવનસ્ય શરીરસ્ય ચાર્થં ચિન્તાં મા કાર્ષ્ટ| ");
INSERT INTO sanguj_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ભક્ષ્યાજ્જીવનં ભૂષણાચ્છરીરઞ્ચ શ્રેષ્ઠં ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","કાકપક્ષિણાં કાર્ય્યં વિચારયત, તે ન વપન્તિ શસ્યાનિ ચ ન છિન્દન્તિ, તેષાં ભાણ્ડાગારાણિ ન સન્તિ કોષાશ્ચ ન સન્તિ, તથાપીશ્વરસ્તેભ્યો ભક્ષ્યાણિ દદાતિ, યૂયં પક્ષિભ્યઃ શ્રેષ્ઠતરા ન કિં? ");
INSERT INTO sanguj_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","અપરઞ્ચ ભાવયિત્વા નિજાયુષઃ ક્ષણમાત્રં વર્દ્ધયિતું શક્નોતિ, એતાદૃશો લાકો યુષ્માકં મધ્યે કોસ્તિ? ");
INSERT INTO sanguj_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","અતએવ ક્ષુદ્રં કાર્ય્યં સાધયિતુમ્ અસમર્થા યૂયમ્ અન્યસ્મિન્ કાર્ય્યે કુતો ભાવયથ? ");
INSERT INTO sanguj_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","અન્યચ્ચ કામ્પિલપુષ્પં કથં વર્દ્ધતે તદાપિ વિચારયત, તત્ કઞ્ચન શ્રમં ન કરોતિ તન્તૂંશ્ચ ન જનયતિ કિન્તુ યુષ્મભ્યં યથાર્થં કથયામિ સુલેમાન્ બહ્વૈશ્વર્ય્યાન્વિતોપિ પુષ્પસ્યાસ્ય સદૃશો વિભૂષિતો નાસીત્| ");
INSERT INTO sanguj_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","અદ્ય ક્ષેત્રે વર્ત્તમાનં શ્વશ્ચૂલ્લ્યાં ક્ષેપ્સ્યમાનં યત્ તૃણં, તસ્મૈ યદીશ્વર ઇત્થં ભૂષયતિ તર્હિ હે અલ્પપ્રત્યયિનો યુષ્માન કિં ન પરિધાપયિષ્યતિ? ");
INSERT INTO sanguj_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","અતએવ કિં ખાદિષ્યામઃ? કિં પરિધાસ્યામઃ? એતદર્થં મા ચેષ્ટધ્વં મા સંદિગ્ધ્વઞ્ચ| ");
INSERT INTO sanguj_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","જગતો દેવાર્ચ્ચકા એતાનિ સર્વ્વાણિ ચેષ્ટનતે; એષુ વસ્તુષુ યુષ્માકં પ્રયોજનમાસ્તે ઇતિ યુષ્માકં પિતા જાનાતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","અતએવેશ્વરસ્ય રાજ્યાર્થં સચેષ્ટા ભવત તથા કૃતે સર્વ્વાણ્યેતાનિ દ્રવ્યાણિ યુષ્મભ્યં પ્રદાયિષ્યન્તે| ");
INSERT INTO sanguj_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","હે ક્ષુદ્રમેષવ્રજ યૂયં મા ભૈષ્ટ યુષ્મભ્યં રાજ્યં દાતું યુષ્માકં પિતુઃ સમ્મતિરસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","અતએવ યુષ્માકં યા યા સમ્પત્તિરસ્તિ તાં તાં વિક્રીય વિતરત, યત્ સ્થાનં ચૌરા નાગચ્છન્તિ, કીટાશ્ચ ન ક્ષાયયન્તિ તાદૃશે સ્વર્ગે નિજાર્થમ્ અજરે સમ્પુટકે ઽક્ષયં ધનં સઞ્ચિનુત ચ; ");
INSERT INTO sanguj_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","યતો યત્ર યુષ્માકં ધનં વર્ત્તતે તત્રેવ યુષ્માકં મનઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","અપરઞ્ચ યૂયં પ્રદીપં જ્વાલયિત્વા બદ્ધકટયસ્તિષ્ઠત; ");
INSERT INTO sanguj_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","પ્રભુ ર્વિવાહાદાગત્ય યદૈવ દ્વારમાહન્તિ તદૈવ દ્વારં મોચયિતું યથા ભૃત્યા અપેક્ષ્ય તિષ્ઠન્તિ તથા યૂયમપિ તિષ્ઠત| ");
INSERT INTO sanguj_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","યતઃ પ્રભુરાગત્ય યાન્ દાસાન્ સચેતનાન્ તિષ્ઠતો દ્રક્ષ્યતિ તએવ ધન્યાઃ; અહં યુષ્માન્ યથાર્થં વદામિ પ્રભુસ્તાન્ ભોજનાર્થમ્ ઉપવેશ્ય સ્વયં બદ્ધકટિઃ સમીપમેત્ય પરિવેષયિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","યદિ દ્વિતીયે તૃતીયે વા પ્રહરે સમાગત્ય તથૈવ પશ્યતિ, તર્હિ તએવ દાસા ધન્યાઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","અપરઞ્ચ કસ્મિન્ ક્ષણે ચૌરા આગમિષ્યન્તિ ઇતિ યદિ ગૃહપતિ ર્જ્ઞાતું શક્નોતિ તદાવશ્યં જાગ્રન્ નિજગૃહે સન્ધિં કર્ત્તયિતું વારયતિ યૂયમેતદ્ વિત્ત| ");
INSERT INTO sanguj_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","અતએવ યૂયમપિ સજ્જમાનાસ્તિષ્ઠત યતો યસ્મિન્ ક્ષણે તં નાપ્રેક્ષધ્વે તસ્મિન્નેવ ક્ષણે મનુષ્યપુત્ર આગમિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","તદા પિતરઃ પપ્રચ્છ, હે પ્રભો ભવાન્ કિમસ્માન્ ઉદ્દિશ્ય કિં સર્વ્વાન્ ઉદ્દિશ્ય દૃષ્ટાન્તકથામિમાં વદતિ? ");
INSERT INTO sanguj_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","તતઃ પ્રભુઃ પ્રોવાચ, પ્રભુઃ સમુચિતકાલે નિજપરિવારાર્થં ભોજ્યપરિવેષણાય યં તત્પદે નિયોક્ષ્યતિ તાદૃશો વિશ્વાસ્યો બોદ્ધા કર્મ્માધીશઃ કોસ્તિ? ");
INSERT INTO sanguj_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","પ્રભુરાગત્ય યમ્ એતાદૃશે કર્મ્મણિ પ્રવૃત્તં દ્રક્ષ્યતિ સએવ દાસો ધન્યઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","અહં યુષ્માન્ યથાર્થં વદામિ સ તં નિજસર્વ્વસ્વસ્યાધિપતિં કરિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","કિન્તુ પ્રભુર્વિલમ્બેનાગમિષ્યતિ, ઇતિ વિચિન્ત્ય સ દાસો યદિ તદન્યદાસીદાસાન્ પ્રહર્ત્તુમ્ ભોક્તું પાતું મદિતુઞ્ચ પ્રારભતે, ");
INSERT INTO sanguj_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","તર્હિ યદા પ્રભું નાપેક્ષિષ્યતે યસ્મિન્ ક્ષણે સોઽચેતનશ્ચ સ્થાસ્યતિ તસ્મિન્નેવ ક્ષણે તસ્ય પ્રભુરાગત્ય તં પદભ્રષ્ટં કૃત્વા વિશ્વાસહીનૈઃ સહ તસ્ય અંશં નિરૂપયિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","યો દાસઃ પ્રભેाરાજ્ઞાં જ્ઞાત્વાપિ સજ્જિતો ન તિષ્ઠતિ તદાજ્ઞાનુસારેણ ચ કાર્ય્યં ન કરોતિ સોનેકાન્ પ્રહારાન્ પ્રાપ્સ્યતિ; ");
INSERT INTO sanguj_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","કિન્તુ યો જનોઽજ્ઞાત્વા પ્રહારાર્હં કર્મ્મ કરોતિ સોલ્પપ્રહારાન્ પ્રાપ્સ્યતિ| યતો યસ્મૈ બાહુલ્યેન દત્તં તસ્માદેવ બાહુલ્યેન ગ્રહીષ્યતે, માનુષા યસ્ય નિકટે બહુ સમર્પયન્તિ તસ્માદ્ બહુ યાચન્તે| ");
INSERT INTO sanguj_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","અહં પૃથિવ્યામ્ અનૈક્યરૂપં વહ્નિ નિક્ષેપ્તુમ્ આગતોસ્મિ, સ ચેદ્ ઇદાનીમેવ પ્રજ્વલતિ તત્ર મમ કા ચિન્તા? ");
INSERT INTO sanguj_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","કિન્તુ યેન મજ્જનેનાહં મગ્નો ભવિષ્યામિ યાવત્કાલં તસ્ય સિદ્ધિ ર્ન ભવિષ્યતિ તાવદહં કતિકષ્ટં પ્રાપ્સ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","મેલનં કર્ત્તું જગદ્ આગતોસ્મિ યૂયં કિમિત્થં બોધધ્વે? યુષ્માન્ વદામિ ન તથા, કિન્ત્વહં મેલનાભાવં કર્ત્તુંમ્ આગતોસ્મિ| ");
INSERT INTO sanguj_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","યસ્માદેતત્કાલમારભ્ય એકત્રસ્થપરિજનાનાં મધ્યે પઞ્ચજનાઃ પૃથગ્ ભૂત્વા ત્રયો જના દ્વયોર્જનયોઃ પ્રતિકૂલા દ્વૌ જનૌ ચ ત્રયાણાં જનાનાં પ્રતિકૂલૌ ભવિષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","પિતા પુત્રસ્ય વિપક્ષઃ પુત્રશ્ચ પિતુ ર્વિપક્ષો ભવિષ્યતિ માતા કન્યાયા વિપક્ષા કન્યા ચ માતુ ર્વિપક્ષા ભવિષ્યતિ, તથા શ્વશ્રૂર્બધ્વા વિપક્ષા બધૂશ્ચ શ્વશ્ર્વા વિપક્ષા ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","સ લોકેભ્યોપરમપિ કથયામાસ, પશ્ચિમદિશિ મેઘોદ્ગમં દૃષ્ટ્વા યૂયં હઠાદ્ વદથ વૃષ્ટિ ર્ભવિષ્યતિ તતસ્તથૈવ જાયતે| ");
INSERT INTO sanguj_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","અપરં દક્ષિણતો વાયૌ વાતિ સતિ વદથ નિદાઘો ભવિષ્યતિ તતઃ સોપિ જાયતે| ");
INSERT INTO sanguj_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","રે રે કપટિન આકાશસ્ય ભૂમ્યાશ્ચ લક્ષણં બોદ્ધું શક્નુથ, ");
INSERT INTO sanguj_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","કિન્તુ કાલસ્યાસ્ય લક્ષણં કુતો બોદ્ધું ન શક્નુથ? યૂયઞ્ચ સ્વયં કુતો ન ન્યાષ્યં વિચારયથ? ");
INSERT INTO sanguj_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","અપરઞ્ચ વિવાદિના સાર્દ્ધં વિચારયિતુઃ સમીપં ગચ્છન્ પથિ તસ્માદુદ્ધારં પ્રાપ્તું યતસ્વ નોચેત્ સ ત્વાં ધૃત્વા વિચારયિતુઃ સમીપં નયતિ| વિચારયિતા યદિ ત્વાં પ્રહર્ત્તુઃ સમીપં સમર્પયતિ પ્રહર્ત્તા ત્વાં કારાયાં બધ્નાતિ ");
INSERT INTO sanguj_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","તર્હિ ત્વામહં વદામિ ત્વયા નિઃશેષં કપર્દકેષુ ન પરિશોધિતેષુ ત્વં તતો મુક્તિં પ્રાપ્તું ન શક્ષ્યસિ| ");
INSERT INTO sanguj_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","અપરઞ્ચ પીલાતો યેષાં ગાલીલીયાનાં રક્તાનિ બલીનાં રક્તૈઃ સહામિશ્રયત્ તેષાં ગાલીલીયાનાં વૃત્તાન્તં કતિપયજના ઉપસ્થાપ્ય યીશવે કથયામાસુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","તતઃ સ પ્રત્યુવાચ તેષાં લોકાનામ્ એતાદૃશી દુર્ગતિ ર્ઘટિતા તત્કારણાદ્ યૂયં કિમન્યેભ્યો ગાલીલીયેભ્યોપ્યધિકપાપિનસ્તાન્ બોધધ્વે? ");
INSERT INTO sanguj_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","યુષ્માનહં વદામિ તથા ન કિન્તુ મનઃસુ ન પરાવર્ત્તિતેષુ યૂયમપિ તથા નંક્ષ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","અપરઞ્ચ શીલોહનામ્ન ઉચ્ચગૃહસ્ય પતનાદ્ યેઽષ્ટાદશજના મૃતાસ્તે યિરૂશાલમિ નિવાસિસર્વ્વલોકેભ્યોઽધિકાપરાધિનઃ કિં યૂયમિત્યં બોધધ્વે? ");
INSERT INTO sanguj_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","યુષ્માનહં વદામિ તથા ન કિન્તુ મનઃસુ ન પરિવર્ત્તિતેષુ યૂયમપિ તથા નંક્ષ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","અનન્તરં સ ઇમાં દૃષ્ટાન્તકથામકથયદ્ એકો જનો દ્રાક્ષાક્ષેત્રમધ્ય એકમુડુમ્બરવૃક્ષં રોપિતવાન્| પશ્ચાત્ સ આગત્ય તસ્મિન્ ફલાનિ ગવેષયામાસ, ");
INSERT INTO sanguj_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","કિન્તુ ફલાપ્રાપ્તેઃ કારણાદ્ ઉદ્યાનકારં ભૃત્યં જગાદ, પશ્ય વત્સરત્રયં યાવદાગત્ય એતસ્મિન્નુડુમ્બરતરૌ ક્ષલાન્યન્વિચ્છામિ, કિન્તુ નૈકમપિ પ્રપ્નોમિ તરુરયં કુતો વૃથા સ્થાનં વ્યાપ્ય તિષ્ઠતિ? એનં છિન્ધિ| ");
INSERT INTO sanguj_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","તતો ભૃત્યઃ પ્રત્યુવાચ, હે પ્રભો પુનર્વર્ષમેકં સ્થાતુમ્ આદિશ; એતસ્ય મૂલસ્ય ચતુર્દિક્ષુ ખનિત્વાહમ્ આલવાલં સ્થાપયામિ| ");
INSERT INTO sanguj_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","તતઃ ફલિતું શક્નોતિ યદિ ન ફલતિ તર્હિ પશ્ચાત્ છેત્સ્યસિ| ");
INSERT INTO sanguj_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","અથ વિશ્રામવારે ભજનગેહે યીશુરુપદિશતિ ");
INSERT INTO sanguj_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","તસ્મિત્ સમયે ભૂતગ્રસ્તત્વાત્ કુબ્જીભૂયાષ્ટાદશવર્ષાણિ યાવત્ કેનાપ્યુપાયેન ઋજુ ર્ભવિતું ન શક્નોતિ યા દુર્બ્બલા સ્ત્રી, ");
INSERT INTO sanguj_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","તાં તત્રોપસ્થિતાં વિલોક્ય યીશુસ્તામાહૂય કથિતવાન્ હે નારિ તવ દૌર્બ્બલ્યાત્ ત્વં મુક્તા ભવ| ");
INSERT INTO sanguj_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","તતઃ પરં તસ્યા ગાત્રે હસ્તાર્પણમાત્રાત્ સા ઋજુર્ભૂત્વેશ્વરસ્ય ધન્યવાદં કર્ત્તુમારેભે| ");
INSERT INTO sanguj_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","કિન્તુ વિશ્રામવારે યીશુના તસ્યાઃ સ્વાસ્થ્યકરણાદ્ ભજનગેહસ્યાધિપતિઃ પ્રકુપ્ય લોકાન્ ઉવાચ, ષટ્સુ દિનેષુ લોકૈઃ કર્મ્મ કર્ત્તવ્યં તસ્માદ્ધેતોઃ સ્વાસ્થ્યાર્થં તેષુ દિનેષુ આગચ્છત, વિશ્રામવારે માગચ્છત| ");
INSERT INTO sanguj_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","તદા પભુઃ પ્રત્યુવાચ રે કપટિનો યુષ્માકમ્ એકૈકો જનો વિશ્રામવારે સ્વીયં સ્વીયં વૃષભં ગર્દભં વા બન્ધનાન્મોચયિત્વા જલં પાયયિતું કિં ન નયતિ? ");
INSERT INTO sanguj_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","તર્હ્યાષ્ટાદશવત્સરાન્ યાવત્ શૈતાના બદ્ધા ઇબ્રાહીમઃ સન્તતિરિયં નારી કિં વિશ્રામવારે ન મોચયિતવ્યા? ");
INSERT INTO sanguj_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","એષુ વાક્યેષુ કથિતેષુ તસ્ય વિપક્ષાઃ સલજ્જા જાતાઃ કિન્તુ તેન કૃતસર્વ્વમહાકર્મ્મકારણાત્ લોકનિવહઃ સાનન્દોઽભવત્| ");
INSERT INTO sanguj_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","અનન્તરં સોવદદ્ ઈશ્વરસ્ય રાજ્યં કસ્ય સદૃશં? કેન તદુપમાસ્યામિ? ");
INSERT INTO sanguj_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","યત્ સર્ષપબીજં ગૃહીત્વા કશ્ચિજ્જન ઉદ્યાન ઉપ્તવાન્ તદ્ બીજમઙ્કુરિતં સત્ મહાવૃક્ષોઽજાયત, તતસ્તસ્ય શાખાસુ વિહાયસીયવિહગા આગત્ય ન્યૂષુઃ, તદ્રાજ્યં તાદૃશેન સર્ષપબીજેન તુલ્યં| ");
INSERT INTO sanguj_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","પુનઃ કથયામાસ, ઈશ્વરસ્ય રાજ્યં કસ્ય સદૃશં વદિષ્યામિ? યત્ કિણ્વં કાચિત્ સ્ત્રી ગૃહીત્વા દ્રોણત્રયપરિમિતગોધૂમચૂર્ણેષુ સ્થાપયામાસ, ");
INSERT INTO sanguj_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","તતઃ ક્રમેણ તત્ સર્વ્વગોધૂમચૂર્ણં વ્યાપ્નોતિ, તસ્ય કિણ્વસ્ય તુલ્યમ્ ઈશ્વરસ્ય રાજ્યં| ");
INSERT INTO sanguj_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","તતઃ સ યિરૂશાલમ્નગરં પ્રતિ યાત્રાં કૃત્વા નગરે નગરે ગ્રામે ગ્રામે સમુપદિશન્ જગામ| ");
INSERT INTO sanguj_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","તદા કશ્ચિજ્જનસ્તં પપ્રચ્છ, હે પ્રભો કિં કેવલમ્ અલ્પે લોકાઃ પરિત્રાસ્યન્તે? ");
INSERT INTO sanguj_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","તતઃ સ લોકાન્ ઉવાચ, સંકીર્ણદ્વારેણ પ્રવેષ્ટું યતઘ્વં, યતોહં યુષ્માન્ વદામિ, બહવઃ પ્રવેષ્ટું ચેષ્ટિષ્યન્તે કિન્તુ ન શક્ષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ગૃહપતિનોત્થાય દ્વારે રુદ્ધે સતિ યદિ યૂયં બહિઃ સ્થિત્વા દ્વારમાહત્ય વદથ, હે પ્રભો હે પ્રભો અસ્મત્કારણાદ્ દ્વારં મોચયતુ, તતઃ સ ઇતિ પ્રતિવક્ષ્યતિ, યૂયં કુત્રત્યા લોકા ઇત્યહં ન જાનામિ| ");
INSERT INTO sanguj_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","તદા યૂયં વદિષ્યથ, તવ સાક્ષાદ્ વયં ભેाજનં પાનઞ્ચ કૃતવન્તઃ, ત્વઞ્ચાસ્માકં નગરસ્ય પથિ સમુપદિષ્ટવાન્| ");
INSERT INTO sanguj_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","કિન્તુ સ વક્ષ્યતિ, યુષ્માનહં વદામિ, યૂયં કુત્રત્યા લોકા ઇત્યહં ન જાનામિ; હે દુરાચારિણો યૂયં મત્તો દૂરીભવત| ");
INSERT INTO sanguj_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","તદા ઇબ્રાહીમં ઇસ્હાકં યાકૂબઞ્ચ સર્વ્વભવિષ્યદ્વાદિનશ્ચ ઈશ્વરસ્ય રાજ્યં પ્રાપ્તાન્ સ્વાંશ્ચ બહિષ્કૃતાન્ દૃષ્ટ્વા યૂયં રોદનં દન્તૈર્દન્તઘર્ષણઞ્ચ કરિષ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","અપરઞ્ચ પૂર્વ્વપશ્ચિમદક્ષિણોત્તરદિગ્ભ્યો લોકા આગત્ય ઈશ્વરસ્ય રાજ્યે નિવત્સ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","પશ્યતેત્થં શેષીયા લોકા અગ્રા ભવિષ્યન્તિ, અગ્રીયા લોકાશ્ચ શેષા ભવિષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","અપરઞ્ચ તસ્મિન્ દિને કિયન્તઃ ફિરૂશિન આગત્ય યીશું પ્રોચુઃ, બહિર્ગચ્છ, સ્થાનાદસ્માત્ પ્રસ્થાનં કુરુ, હેરોદ્ ત્વાં જિઘાંસતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","તતઃ સ પ્રત્યવોચત્ પશ્યતાદ્ય શ્વશ્ચ ભૂતાન્ વિહાપ્ય રોગિણોઽરોગિણઃ કૃત્વા તૃતીયેહ્નિ સેત્સ્યામિ, કથામેતાં યૂયમિત્વા તં ભૂરિમાયં વદત| ");
INSERT INTO sanguj_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","તત્રાપ્યદ્ય શ્વઃ પરશ્વશ્ચ મયા ગમનાગમને કર્ત્તવ્યે, યતો હેતો ર્યિરૂશાલમો બહિઃ કુત્રાપિ કોપિ ભવિષ્યદ્વાદી ન ઘાનિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","હે યિરૂશાલમ્ હે યિરૂશાલમ્ ત્વં ભવિષ્યદ્વાદિનો હંસિ તવાન્તિકે પ્રેરિતાન્ પ્રસ્તરૈર્મારયસિ ચ, યથા કુક્કુટી નિજપક્ષાધઃ સ્વશાવકાન્ સંગૃહ્લાતિ, તથાહમપિ તવ શિશૂન્ સંગ્રહીતું કતિવારાન્ ઐચ્છં કિન્તુ ત્વં નૈચ્છઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","પશ્યત યુષ્માકં વાસસ્થાનાનિ પ્રોચ્છિદ્યમાનાનિ પરિત્યક્તાનિ ચ ભવિષ્યન્તિ; યુષ્માનહં યથાર્થં વદામિ, યઃ પ્રભો ર્નામ્નાગચ્છતિ સ ધન્ય ઇતિ વાચં યાવત્કાલં ન વદિષ્યથ, તાવત્કાલં યૂયં માં ન દ્રક્ષ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","અનન્તરં વિશ્રામવારે યીશૌ પ્રધાનસ્ય ફિરૂશિનો ગૃહે ભોક્તું ગતવતિ તે તં વીક્ષિતુમ્ આરેભિરે| ");
INSERT INTO sanguj_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","તદા જલોદરી તસ્ય સમ્મુખે સ્થિતઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","તતઃ સ વ્યવસ્થાપકાન્ ફિરૂશિનશ્ચ પપ્રચ્છ, વિશ્રામવારે સ્વાસ્થ્યં કર્ત્તવ્યં ન વા? તતસ્તે કિમપિ ન પ્રત્યૂચુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","તદા સ તં રોગિણં સ્વસ્થં કૃત્વા વિસસર્જ; ");
INSERT INTO sanguj_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","તાનુવાચ ચ યુષ્માકં કસ્યચિદ્ ગર્દ્દભો વૃષભો વા ચેદ્ ગર્ત્તે પતતિ તર્હિ વિશ્રામવારે તત્ક્ષણં સ કિં તં નોત્થાપયિષ્યતિ? ");
INSERT INTO sanguj_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","તતસ્તે કથાયા એતસ્યાઃ કિમપિ પ્રતિવક્તું ન શેકુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","અપરઞ્ચ પ્રધાનસ્થાનમનોનીતત્વકરણં વિલોક્ય સ નિમન્ત્રિતાન્ એતદુપદેશકથાં જગાદ, ");
INSERT INTO sanguj_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","ત્વં વિવાહાદિભોજ્યેષુ નિમન્ત્રિતઃ સન્ પ્રધાનસ્થાને મોપાવેક્ષીઃ| ત્વત્તો ગૌરવાન્વિતનિમન્ત્રિતજન આયાતે ");
INSERT INTO sanguj_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","નિમન્ત્રયિતાગત્ય મનુષ્યાયૈતસ્મૈ સ્થાનં દેહીતિ વાક્યં ચેદ્ વક્ષ્યતિ તર્હિ ત્વં સઙ્કુચિતો ભૂત્વા સ્થાન ઇતરસ્મિન્ ઉપવેષ્ટુમ્ ઉદ્યંસ્યસિ| ");
INSERT INTO sanguj_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","અસ્માત્ કારણાદેવ ત્વં નિમન્ત્રિતો ગત્વાઽપ્રધાનસ્થાન ઉપવિશ, તતો નિમન્ત્રયિતાગત્ય વદિષ્યતિ, હે બન્ધો પ્રોચ્ચસ્થાનં ગત્વોપવિશ, તથા સતિ ભોજનોપવિષ્ટાનાં સકલાનાં સાક્ષાત્ ત્વં માન્યો ભવિષ્યસિ| ");
INSERT INTO sanguj_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","યઃ કશ્ચિત્ સ્વમુન્નમયતિ સ નમયિષ્યતે, કિન્તુ યઃ કશ્ચિત્ સ્વં નમયતિ સ ઉન્નમયિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","તદા સ નિમન્ત્રયિતારં જનમપિ જગાદ, મધ્યાહ્ને રાત્રૌ વા ભોજ્યે કૃતે નિજબન્ધુગણો વા ભ્રાતૃृગણો વા જ્ઞાતિગણો વા ધનિગણો વા સમીપવાસિગણો વા એતાન્ ન નિમન્ત્રય, તથા કૃતે ચેત્ તે ત્વાં નિમન્ત્રયિષ્યન્તિ, તર્હિ પરિશોધો ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","કિન્તુ યદા ભેજ્યં કરોષિ તદા દરિદ્રશુષ્કકરખઞ્જાન્ધાન્ નિમન્ત્રય, ");
INSERT INTO sanguj_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","તત આશિષં લપ્સ્યસે, તેષુ પરિશોધં કર્ત્તુમશક્નુવત્સુ શ્મશાનાદ્ધાર્મ્મિકાનામુત્થાનકાલે ત્વં ફલાં લપ્સ્યસે| ");
INSERT INTO sanguj_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","અનન્તરં તાં કથાં નિશમ્ય ભોજનોપવિષ્ટઃ કશ્ચિત્ કથયામાસ, યો જન ઈશ્વરસ્ય રાજ્યે ભોક્તું લપ્સ્યતે સએવ ધન્યઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","તતઃ સ ઉવાચ, કશ્ચિત્ જનો રાત્રૌ ભેाજ્યં કૃત્વા બહૂન્ નિમન્ત્રયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","તતો ભોજનસમયે નિમન્ત્રિતલોકાન્ આહ્વાતું દાસદ્વારા કથયામાસ, ખદ્યદ્રવ્યાણિ સર્વ્વાણિ સમાસાદિતાનિ સન્તિ, યૂયમાગચ્છત| ");
INSERT INTO sanguj_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","કિન્તુ તે સર્વ્વ એકૈકં છલં કૃત્વા ક્ષમાં પ્રાર્થયાઞ્ચક્રિરે| પ્રથમો જનઃ કથયામાસ, ક્ષેત્રમેકં ક્રીતવાનહં તદેવ દ્રષ્ટું મયા ગન્તવ્યમ્, અતએવ માં ક્ષન્તું તં નિવેદય| ");
INSERT INTO sanguj_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","અન્યો જનઃ કથયામાસ, દશવૃષાનહં ક્રીતવાન્ તાન્ પરીક્ષિતું યામિ તસ્માદેવ માં ક્ષન્તું તં નિવેદય| ");
INSERT INTO sanguj_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","અપરઃ કથયામાસ, વ્યૂઢવાનહં તસ્માત્ કારણાદ્ યાતું ન શક્નોમિ| ");
INSERT INTO sanguj_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","પશ્ચાત્ સ દાસો ગત્વા નિજપ્રભોઃ સાક્ષાત્ સર્વ્વવૃત્તાન્તં નિવેદયામાસ, તતોસૌ ગૃહપતિઃ કુપિત્વા સ્વદાસં વ્યાજહાર, ત્વં સત્વરં નગરસ્ય સન્નિવેશાન્ માર્ગાંશ્ચ ગત્વા દરિદ્રશુષ્કકરખઞ્જાન્ધાન્ અત્રાનય| ");
INSERT INTO sanguj_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","તતો દાસોઽવદત્, હે પ્રભો ભવત આજ્ઞાનુસારેણાક્રિયત તથાપિ સ્થાનમસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","તદા પ્રભુઃ પુન ર્દાસાયાકથયત્, રાજપથાન્ વૃક્ષમૂલાનિ ચ યાત્વા મદીયગૃહપૂરણાર્થં લોકાનાગન્તું પ્રવર્ત્તય| ");
INSERT INTO sanguj_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","અહં યુષ્મભ્યં કથયામિ, પૂર્વ્વનિમન્ત્રિતાનમેકોપિ મમાસ્ય રાત્રિભોજ્યસ્યાસ્વાદં ન પ્રાપ્સ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","અનન્તરં બહુષુ લોકેષુ યીશોઃ પશ્ચાદ્ વ્રજિતેષુ સત્સુ સ વ્યાઘુટ્ય તેભ્યઃ કથયામાસ, ");
INSERT INTO sanguj_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","યઃ કશ્ચિન્ મમ સમીપમ્ આગત્ય સ્વસ્ય માતા પિતા પત્ની સન્તાના ભ્રાતરો ભગિમ્યો નિજપ્રાણાશ્ચ, એતેભ્યઃ સર્વ્વેભ્યો મય્યધિકં પ્રેમ ન કરોતિ, સ મમ શિષ્યો ભવિતું ન શક્ષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","યઃ કશ્ચિત્ સ્વીયં ક્રુશં વહન્ મમ પશ્ચાન્ન ગચ્છતિ, સોપિ મમ શિષ્યો ભવિતું ન શક્ષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","દુર્ગનિર્મ્માણે કતિવ્યયો ભવિષ્યતિ, તથા તસ્ય સમાપ્તિકરણાર્થં સમ્પત્તિરસ્તિ ન વા, પ્રથમમુપવિશ્ય એતન્ન ગણયતિ, યુષ્માકં મધ્ય એતાદૃશઃ કોસ્તિ? ");
INSERT INTO sanguj_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","નોચેદ્ ભિત્તિં કૃત્વા શેષે યદિ સમાપયિતું ન શક્ષ્યતિ, ");
INSERT INTO sanguj_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","તર્હિ માનુષોયં નિચેતુમ્ આરભત સમાપયિતું નાશક્નોત્, ઇતિ વ્યાહૃત્ય સર્વ્વે તમુપહસિષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","અપરઞ્ચ ભિન્નભૂપતિના સહ યુદ્ધં કર્ત્તુમ્ ઉદ્યમ્ય દશસહસ્રાણિ સૈન્યાનિ ગૃહીત્વા વિંશતિસહસ્રેઃ સૈન્યૈઃ સહિતસ્ય સમીપવાસિનઃ સમ્મુખં યાતું શક્ષ્યામિ ન વેતિ પ્રથમં ઉપવિશ્ય ન વિચારયતિ એતાદૃશો ભૂમિપતિઃ કઃ? ");
INSERT INTO sanguj_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","યદિ ન શક્નોતિ તર્હિ રિપાવતિદૂરે તિષ્ઠતિ સતિ નિજદૂતં પ્રેષ્ય સન્ધિં કર્ત્તું પ્રાર્થયેત| ");
INSERT INTO sanguj_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","તદ્વદ્ યુષ્માકં મધ્યે યઃ કશ્ચિન્ મદર્થં સર્વ્વસ્વં હાતું ન શક્નોતિ સ મમ શિષ્યો ભવિતું ન શક્ષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","લવણમ્ ઉત્તમમ્ ઇતિ સત્યં, કિન્તુ યદિ લવણસ્ય લવણત્વમ્ અપગચ્છતિ તર્હિ તત્ કથં સ્વાદુયુક્તં ભવિષ્યતિ? ");
INSERT INTO sanguj_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","તદ ભૂમ્યર્થમ્ આલવાલરાશ્યર્થમપિ ભદ્રં ન ભવતિ; લોકાસ્તદ્ બહિઃ ક્ષિપન્તિ| યસ્ય શ્રોતું શ્રોત્રે સ્તઃ સ શૃણોતુ| ");
INSERT INTO sanguj_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","તદા કરસઞ્ચાયિનઃ પાપિનશ્ચ લોકા ઉપદેશ્કથાં શ્રોતું યીશોઃ સમીપમ્ આગચ્છન્| ");
INSERT INTO sanguj_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","તતઃ ફિરૂશિન ઉપાધ્યાયાશ્ચ વિવદમાનાઃ કથયામાસુઃ એષ માનુષઃ પાપિભિઃ સહ પ્રણયં કૃત્વા તૈઃ સાર્દ્ધં ભુંક્તે| ");
INSERT INTO sanguj_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","તદા સ તેભ્ય ઇમાં દૃષ્ટાન્તકથાં કથિતવાન્, ");
INSERT INTO sanguj_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","કસ્યચિત્ શતમેષેષુ તિષ્ઠત્મુ તેષામેકં સ યદિ હારયતિ તર્હિ મધ્યેપ્રાન્તરમ્ એકોનશતમેષાન્ વિહાય હારિતમેષસ્ય ઉદ્દેશપ્રાપ્તિપર્ય્યનતં ન ગવેષયતિ, એતાદૃશો લોકો યુષ્માકં મધ્યે ક આસ્તે? ");
INSERT INTO sanguj_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","તસ્યોદ્દેશં પ્રાપ્ય હૃષ્ટમનાસ્તં સ્કન્ધે નિધાય સ્વસ્થાનમ્ આનીય બન્ધુબાન્ધવસમીપવાસિન આહૂય વક્તિ, ");
INSERT INTO sanguj_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","હારિતં મેષં પ્રાપ્તોહમ્ અતો હેતો ર્મયા સાર્દ્ધમ્ આનન્દત| ");
INSERT INTO sanguj_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","તદ્વદહં યુષ્માન્ વદામિ, યેષાં મનઃપરાવર્ત્તનસ્ય પ્રયોજનં નાસ્તિ, તાદૃશૈકોનશતધાર્મ્મિકકારણાદ્ ય આનન્દસ્તસ્માદ્ એકસ્ય મનઃપરિવર્ત્તિનઃ પાપિનઃ કારણાત્ સ્વર્ગે ઽધિકાનન્દો જાયતે| ");
INSERT INTO sanguj_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","અપરઞ્ચ દશાનાં રૂપ્યખણ્ડાનામ્ એકખણ્ડે હારિતે પ્રદીપં પ્રજ્વાલ્ય ગૃહં સમ્માર્જ્ય તસ્ય પ્રાપ્તિં યાવદ્ યત્નેન ન ગવેષયતિ, એતાદૃશી યોષિત્ કાસ્તે? ");
INSERT INTO sanguj_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","પ્રાપ્તે સતિ બન્ધુબાન્ધવસમીપવાસિનીરાહૂય કથયતિ, હારિતં રૂપ્યખણ્ડં પ્રાપ્તાહં તસ્માદેવ મયા સાર્દ્ધમ્ આનન્દત| ");
INSERT INTO sanguj_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","તદ્વદહં યુષ્માન્ વ્યાહરામિ, એકેન પાપિના મનસિ પરિવર્ત્તિતે, ઈશ્વરસ્ય દૂતાનાં મધ્યેપ્યાનન્દો જાયતે| ");
INSERT INTO sanguj_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","અપરઞ્ચ સ કથયામાસ, કસ્યચિદ્ દ્વૌ પુત્રાવાસ્તાં, ");
INSERT INTO sanguj_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","તયોઃ કનિષ્ઠઃ પુત્રઃ પિત્રે કથયામાસ, હે પિતસ્તવ સમ્પત્ત્યા યમંશં પ્રાપ્સ્યામ્યહં વિભજ્ય તં દેહિ, તતઃ પિતા નિજાં સમ્પત્તિં વિભજ્ય તાભ્યાં દદૌ| ");
INSERT INTO sanguj_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","કતિપયાત્ કાલાત્ પરં સ કનિષ્ઠપુત્રઃ સમસ્તં ધનં સંગૃહ્ય દૂરદેશં ગત્વા દુષ્ટાચરણેન સર્વ્વાં સમ્પત્તિં નાશયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","તસ્ય સર્વ્વધને વ્યયં ગતે તદ્દેશે મહાદુર્ભિક્ષં બભૂવ, તતસ્તસ્ય દૈન્યદશા ભવિતુમ્ આરેભે| ");
INSERT INTO sanguj_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","તતઃ પરં સ ગત્વા તદ્દેશીયં ગૃહસ્થમેકમ્ આશ્રયત; તતઃ સતં શૂકરવ્રજં ચારયિતું પ્રાન્તરં પ્રેષયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","કેનાપિ તસ્મૈ ભક્ષ્યાદાનાત્ સ શૂકરફલવલ્કલેન પિચિણ્ડપૂરણાં વવાઞ્છ| ");
INSERT INTO sanguj_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","શેષે સ મનસિ ચેતનાં પ્રાપ્ય કથયામાસ, હા મમ પિતુઃ સમીપે કતિ કતિ વેતનભુજો દાસા યથેષ્ટં તતોધિકઞ્ચ ભક્ષ્યં પ્રાપ્નુવન્તિ કિન્ત્વહં ક્ષુધા મુમૂર્ષુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","અહમુત્થાય પિતુઃ સમીપં ગત્વા કથામેતાં વદિષ્યામિ, હે પિતર્ ઈશ્વરસ્ય તવ ચ વિરુદ્ધં પાપમકરવમ્ ");
INSERT INTO sanguj_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","તવ પુત્રઇતિ વિખ્યાતો ભવિતું ન યોગ્યોસ્મિ ચ, માં તવ વૈતનિકં દાસં કૃત્વા સ્થાપય| ");
INSERT INTO sanguj_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","પશ્ચાત્ સ ઉત્થાય પિતુઃ સમીપં જગામ; તતસ્તસ્ય પિતાતિદૂરે તં નિરીક્ષ્ય દયાઞ્ચક્રે, ધાવિત્વા તસ્ય કણ્ઠં ગૃહીત્વા તં ચુચુમ્બ ચ| ");
INSERT INTO sanguj_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","તદા પુત્ર ઉવાચ, હે પિતર્ ઈશ્વરસ્ય તવ ચ વિરુદ્ધં પાપમકરવં, તવ પુત્રઇતિ વિખ્યાતો ભવિતું ન યોગ્યોસ્મિ ચ| ");
INSERT INTO sanguj_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","કિન્તુ તસ્ય પિતા નિજદાસાન્ આદિદેશ, સર્વ્વોત્તમવસ્ત્રાણ્યાનીય પરિધાપયતૈનં હસ્તે ચાઙ્ગુરીયકમ્ અર્પયત પાદયોશ્ચોપાનહૌ સમર્પયત; ");
INSERT INTO sanguj_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","પુષ્ટં ગોવત્સમ્ આનીય મારયત ચ તં ભુક્ત્વા વયમ્ આનન્દામ| ");
INSERT INTO sanguj_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","યતો મમ પુત્રોયમ્ અમ્રિયત પુનરજીવીદ્ હારિતશ્ચ લબ્ધોભૂત્ તતસ્ત આનન્દિતુમ્ આરેભિરે| ");
INSERT INTO sanguj_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","તત્કાલે તસ્ય જ્યેષ્ઠઃ પુત્રઃ ક્ષેત્ર આસીત્| અથ સ નિવેશનસ્ય નિકટં આગચ્છન્ નૃત્યાનાં વાદ્યાનાઞ્ચ શબ્દં શ્રુત્વા ");
INSERT INTO sanguj_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","દાસાનામ્ એકમ્ આહૂય પપ્રચ્છ, કિં કારણમસ્ય? ");
INSERT INTO sanguj_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","તતઃ સોવાદીત્, તવ ભ્રાતાગમત્, તવ તાતશ્ચ તં સુશરીરં પ્રાપ્ય પુષ્ટં ગોવત્સં મારિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","તતઃ સ પ્રકુપ્ય નિવેશનાન્તઃ પ્રવેષ્ટું ન સમ્મેને; તતસ્તસ્ય પિતા બહિરાગત્ય તં સાધયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","તતઃ સ પિતરં પ્રત્યુવાચ, પશ્ય તવ કાઞ્ચિદપ્યાજ્ઞાં ન વિલંઘ્ય બહૂન્ વત્સરાન્ અહં ત્વાં સેવે તથાપિ મિત્રૈઃ સાર્દ્ધમ્ ઉત્સવં કર્ત્તું કદાપિ છાગમેકમપિ મહ્યં નાદદાઃ; ");
INSERT INTO sanguj_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","કિન્તુ તવ યઃ પુત્રો વેશ્યાગમનાદિભિસ્તવ સમ્પત્તિમ્ અપવ્યયિતવાન્ તસ્મિન્નાગતમાત્રે તસ્યૈવ નિમિત્તં પુષ્ટં ગોવત્સં મારિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","તદા તસ્ય પિતાવોચત્, હે પુત્ર ત્વં સર્વ્વદા મયા સહાસિ તસ્માન્ મમ યદ્યદાસ્તે તત્સર્વ્વં તવ| ");
INSERT INTO sanguj_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","કિન્તુ તવાયં ભ્રાતા મૃતઃ પુનરજીવીદ્ હારિતશ્ચ ભૂત્વા પ્રાપ્તોભૂત્, એતસ્માત્ કારણાદ્ ઉત્સવાનન્દૌ કર્ત્તુમ્ ઉચિતમસ્માકમ્| ");
INSERT INTO sanguj_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","અપરઞ્ચ યીશુઃ શિષ્યેભ્યોન્યામેકાં કથાં કથયામાસ કસ્યચિદ્ ધનવતો મનુષ્યસ્ય ગૃહકાર્ય્યાધીશે સમ્પત્તેરપવ્યયેઽપવાદિતે સતિ ");
INSERT INTO sanguj_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","તસ્ય પ્રભુસ્તમ્ આહૂય જગાદ, ત્વયિ યામિમાં કથાં શૃણોમિ સા કીદૃશી? ત્વં ગૃહકાર્ય્યાધીશકર્મ્મણો ગણનાં દર્શય ગૃહકાર્ય્યાધીશપદે ત્વં ન સ્થાસ્યસિ| ");
INSERT INTO sanguj_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","તદા સ ગૃહકાર્ય્યાધીશો મનસા ચિન્તયામાસ, પ્રભુ ર્યદિ માં ગૃહકાર્ય્યાધીશપદાદ્ ભ્રંશયતિ તર્હિ કિં કરિષ્યેઽહં? મૃદં ખનિતું મમ શક્તિ ર્નાસ્તિ ભિક્ષિતુઞ્ચ લજ્જિષ્યેઽહં| ");
INSERT INTO sanguj_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","અતએવ મયિ ગૃહકાર્ય્યાધીશપદાત્ ચ્યુતે સતિ યથા લોકા મહ્યમ્ આશ્રયં દાસ્યન્તિ તદર્થં યત્કર્મ્મ મયા કરણીયં તન્ નિર્ણીયતે| ");
INSERT INTO sanguj_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","પશ્ચાત્ સ સ્વપ્રભોરેકૈકમ્ અધમર્ણમ્ આહૂય પ્રથમં પપ્રચ્છ, ત્વત્તો મે પ્રભુણા કતિ પ્રાપ્યમ્? ");
INSERT INTO sanguj_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","તતઃ સ ઉવાચ, એકશતાઢકતૈલાનિ; તદા ગૃહકાર્ય્યાધીશઃ પ્રોવાચ, તવ પત્રમાનીય શીઘ્રમુપવિશ્ય તત્ર પઞ્ચાશતં લિખ| ");
INSERT INTO sanguj_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","પશ્ચાદન્યમેકં પપ્રચ્છ, ત્વત્તો મે પ્રભુણા કતિ પ્રાપ્યમ્? તતઃ સોવાદીદ્ એકશતાઢકગોધૂમાઃ; તદા સ કથયામાસ, તવ પત્રમાનીય અશીતિં લિખ| ");
INSERT INTO sanguj_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","તેનૈવ પ્રભુસ્તમયથાર્થકૃતમ્ અધીશં તદ્બુદ્ધિનૈપુણ્યાત્ પ્રશશંસ; ઇત્થં દીપ્તિરૂપસન્તાનેભ્ય એતત્સંસારસ્ય સન્તાના વર્ત્તમાનકાલેઽધિકબુદ્ધિમન્તો ભવન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","અતો વદામિ યૂયમપ્યયથાર્થેન ધનેન મિત્રાણિ લભધ્વં તતો યુષ્માસુ પદભ્રષ્ટેષ્વપિ તાનિ ચિરકાલમ્ આશ્રયં દાસ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","યઃ કશ્ચિત્ ક્ષુદ્રે કાર્ય્યે વિશ્વાસ્યો ભવતિ સ મહતિ કાર્ય્યેપિ વિશ્વાસ્યો ભવતિ, કિન્તુ યઃ કશ્ચિત્ ક્ષુદ્રે કાર્ય્યેઽવિશ્વાસ્યો ભવતિ સ મહતિ કાર્ય્યેપ્યવિશ્વાસ્યો ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","અતએવ અયથાર્થેન ધનેન યદિ યૂયમવિશ્વાસ્યા જાતાસ્તર્હિ સત્યં ધનં યુષ્માકં કરેષુ કઃ સમર્પયિષ્યતિ? ");
INSERT INTO sanguj_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","યદિ ચ પરધનેન યૂયમ્ અવિશ્વાસ્યા ભવથ તર્હિ યુષ્માકં સ્વકીયધનં યુષ્મભ્યં કો દાસ્યતિ? ");
INSERT INTO sanguj_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","કોપિ દાસ ઉભૌ પ્રભૂ સેવિતું ન શક્નોતિ, યત એકસ્મિન્ પ્રીયમાણોઽન્યસ્મિન્નપ્રીયતે યદ્વા એકં જનં સમાદૃત્ય તદન્યં તુચ્છીકરોતિ તદ્વદ્ યૂયમપિ ધનેશ્વરૌ સેવિતું ન શક્નુથ| ");
INSERT INTO sanguj_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","તદૈતાઃ સર્વ્વાઃ કથાઃ શ્રુત્વા લોભિફિરૂશિનસ્તમુપજહસુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","તતઃ સ ઉવાચ, યૂયં મનુષ્યાણાં નિકટે સ્વાન્ નિર્દોષાન્ દર્શયથ કિન્તુ યુષ્માકમ્ અન્તઃકરણાનીશ્વરો જાનાતિ, યત્ મનુષ્યાણામ્ અતિ પ્રશંસ્યં તદ્ ઈશ્વરસ્ય ઘૃણ્યં| ");
INSERT INTO sanguj_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","યોહન આગમનપર્ય્યનતં યુષ્માકં સમીપે વ્યવસ્થાભવિષ્યદ્વાદિનાં લેખનાનિ ચાસન્ તતઃ પ્રભૃતિ ઈશ્વરરાજ્યસ્ય સુસંવાદઃ પ્રચરતિ, એકૈકો લોકસ્તન્મધ્યં યત્નેન પ્રવિશતિ ચ| ");
INSERT INTO sanguj_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","વરં નભસઃ પૃથિવ્યાશ્ચ લોપો ભવિષ્યતિ તથાપિ વ્યવસ્થાયા એકબિન્દોરપિ લોપો ન ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","યઃ કશ્ચિત્ સ્વીયાં ભાર્ય્યાં વિહાય સ્ત્રિયમન્યાં વિવહતિ સ પરદારાન્ ગચ્છતિ, યશ્ચ તા ત્યક્તાં નારીં વિવહતિ સોપિ પરદારાન ગચ્છતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","એકો ધની મનુષ્યઃ શુક્લાનિ સૂક્ષ્માણિ વસ્ત્રાણિ પર્ય્યદધાત્ પ્રતિદિનં પરિતોષરૂપેણાભુંક્તાપિવચ્ચ| ");
INSERT INTO sanguj_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","સર્વ્વાઙ્ગે ક્ષતયુક્ત ઇલિયાસરનામા કશ્ચિદ્ દરિદ્રસ્તસ્ય ધનવતો ભોજનપાત્રાત્ પતિતમ્ ઉચ્છિષ્ટં ભોક્તું વાઞ્છન્ તસ્ય દ્વારે પતિત્વાતિષ્ઠત્; ");
INSERT INTO sanguj_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","અથ શ્વાન આગત્ય તસ્ય ક્ષતાન્યલિહન્| ");
INSERT INTO sanguj_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","કિયત્કાલાત્પરં સ દરિદ્રઃ પ્રાણાન્ જહૌ; તતઃ સ્વર્ગીયદૂતાસ્તં નીત્વા ઇબ્રાહીમઃ ક્રોડ ઉપવેશયામાસુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","પશ્ચાત્ સ ધનવાનપિ મમાર, તં શ્મશાને સ્થાપયામાસુશ્ચ; કિન્તુ પરલોકે સ વેદનાકુલઃ સન્ ઊર્દ્ધ્વાં નિરીક્ષ્ય બહુદૂરાદ્ ઇબ્રાહીમં તત્ક્રોડ ઇલિયાસરઞ્ચ વિલોક્ય રુવન્નુવાચ; ");
INSERT INTO sanguj_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","હે પિતર્ ઇબ્રાહીમ્ અનુગૃહ્ય અઙ્ગુલ્યગ્રભાગં જલે મજ્જયિત્વા મમ જિહ્વાં શીતલાં કર્ત્તુમ્ ઇલિયાસરં પ્રેરય, યતો વહ્નિશિખાતોહં વ્યથિતોસ્મિ| ");
INSERT INTO sanguj_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","તદા ઇબ્રાહીમ્ બભાષે, હે પુત્ર ત્વં જીવન્ સમ્પદં પ્રાપ્તવાન્ ઇલિયાસરસ્તુ વિપદં પ્રાપ્તવાન્ એતત્ સ્મર, કિન્તુ સમ્પ્રતિ તસ્ય સુખં તવ ચ દુઃખં ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","અપરમપિ યુષ્માકમ્ અસ્માકઞ્ચ સ્થાનયો ર્મધ્યે મહદ્વિચ્છેદોઽસ્તિ તત એતત્સ્થાનસ્ય લોકાસ્તત્ સ્થાનં યાતું યદ્વા તત્સ્થાનસ્ય લોકા એતત્ સ્થાનમાયાતું ન શક્નુવન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","તદા સ ઉક્તવાન્, હે પિતસ્તર્હિ ત્વાં નિવેદયામિ મમ પિતુ ર્ગેહે યે મમ પઞ્ચ ભ્રાતરઃ સન્તિ ");
INSERT INTO sanguj_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","તે યથૈતદ્ યાતનાસ્થાનં નાયાસ્યન્તિ તથા મન્ત્રણાં દાતું તેષાં સમીપમ્ ઇલિયાસરં પ્રેરય| ");
INSERT INTO sanguj_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","તત ઇબ્રાહીમ્ ઉવાચ, મૂસાભવિષ્યદ્વાદિનાઞ્ચ પુસ્તકાનિ તેષાં નિકટે સન્તિ તે તદ્વચનાનિ મન્યન્તાં| ");
INSERT INTO sanguj_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","તદા સ નિવેદયામાસ, હે પિતર્ ઇબ્રાહીમ્ ન તથા, કિન્તુ યદિ મૃતલોકાનાં કશ્ચિત્ તેષાં સમીપં યાતિ તર્હિ તે મનાંસિ વ્યાઘોટયિષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","તત ઇબ્રાહીમ્ જગાદ, તે યદિ મૂસાભવિષ્યદ્વાદિનાઞ્ચ વચનાનિ ન મન્યન્તે તર્હિ મૃતલોકાનાં કસ્મિંશ્ચિદ્ ઉત્થિતેપિ તે તસ્ય મન્ત્રણાં ન મંસ્યન્તે| ");
INSERT INTO sanguj_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ઇતઃ પરં યીશુઃ શિષ્યાન્ ઉવાચ, વિઘ્નૈરવશ્યમ્ આગન્તવ્યં કિન્તુ વિઘ્ના યેન ઘટિષ્યન્તે તસ્ય દુર્ગતિ ર્ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","એતેષાં ક્ષુદ્રપ્રાણિનામ્ એકસ્યાપિ વિઘ્નજનનાત્ કણ્ઠબદ્ધપેષણીકસ્ય તસ્ય સાગરાગાધજલે મજ્જનં ભદ્રં| ");
INSERT INTO sanguj_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","યૂયં સ્વેષુ સાવધાનાસ્તિષ્ઠત; તવ ભ્રાતા યદિ તવ કિઞ્ચિદ્ અપરાધ્યતિ તર્હિ તં તર્જય, તેન યદિ મનઃ પરિવર્ત્તયતિ તર્હિ તં ક્ષમસ્વ| ");
INSERT INTO sanguj_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","પુનરેકદિનમધ્યે યદિ સ તવ સપ્તકૃત્વોઽપરાધ્યતિ કિન્તુ સપ્તકૃત્વ આગત્ય મનઃ પરિવર્ત્ય મયાપરાદ્ધમ્ ઇતિ વદતિ તર્હિ તં ક્ષમસ્વ| ");
INSERT INTO sanguj_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","તદા પ્રેરિતાઃ પ્રભુમ્ અવદન્ અસ્માકં વિશ્વાસં વર્દ્ધય| ");
INSERT INTO sanguj_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","પ્રભુરુવાચ, યદિ યુષ્માકં સર્ષપૈકપ્રમાણો વિશ્વાસોસ્તિ તર્હિ ત્વં સમૂલમુત્પાટિતો ભૂત્વા સમુદ્રે રોપિતો ભવ કથાયામ્ એતસ્યામ્ એતદુડુમ્બરાય કથિતાયાં સ યુષ્માકમાજ્ઞાવહો ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","અપરં સ્વદાસે હલં વાહયિત્વા વા પશૂન્ ચારયિત્વા ક્ષેત્રાદ્ આગતે સતિ તં વદતિ, એહિ ભોક્તુમુપવિશ, યુષ્માકમ્ એતાદૃશઃ કોસ્તિ? ");
INSERT INTO sanguj_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","વરઞ્ચ પૂર્વ્વં મમ ખાદ્યમાસાદ્ય યાવદ્ ભુઞ્જે પિવામિ ચ તાવદ્ બદ્ધકટિઃ પરિચર પશ્ચાત્ ત્વમપિ ભોક્ષ્યસે પાસ્યસિ ચ કથામીદૃશીં કિં ન વક્ષ્યતિ? ");
INSERT INTO sanguj_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","તેન દાસેન પ્રભોરાજ્ઞાનુરૂપે કર્મ્મણિ કૃતે પ્રભુઃ કિં તસ્મિન્ બાધિતો જાતઃ? નેત્થં બુધ્યતે મયા| ");
INSERT INTO sanguj_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ઇત્થં નિરૂપિતેષુ સર્વ્વકર્મ્મસુ કૃતેષુ સત્મુ યૂયમપીદં વાક્યં વદથ, વયમ્ અનુપકારિણો દાસા અસ્માભિર્યદ્યત્કર્ત્તવ્યં તન્માત્રમેવ કૃતં| ");
INSERT INTO sanguj_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","સ યિરૂશાલમિ યાત્રાં કુર્વ્વન્ શોમિરોણ્ગાલીલ્પ્રદેશમધ્યેન ગચ્છતિ, ");
INSERT INTO sanguj_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","એતર્હિ કુત્રચિદ્ ગ્રામે પ્રવેશમાત્રે દશકુષ્ઠિનસ્તં સાક્ષાત્ કૃત્વા ");
INSERT INTO sanguj_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","દૂરે તિષ્ઠનત ઉચ્ચૈ ર્વક્તુમારેભિરે, હે પ્રભો યીશો દયસ્વાસ્માન્| ");
INSERT INTO sanguj_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","તતઃ સ તાન્ દૃષ્ટ્વા જગાદ, યૂયં યાજકાનાં સમીપે સ્વાન્ દર્શયત, તતસ્તે ગચ્છન્તો રોગાત્ પરિષ્કૃતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","તદા તેષામેકઃ સ્વં સ્વસ્થં દૃષ્ટ્વા પ્રોચ્ચૈરીશ્વરં ધન્યં વદન્ વ્યાઘુટ્યાયાતો યીશો ર્ગુણાનનુવદન્ તચ્ચરણાધોભૂમૌ પપાત; ");
INSERT INTO sanguj_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","સ ચાસીત્ શોમિરોણી| ");
INSERT INTO sanguj_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","તદા યીશુરવદત્, દશજનાઃ કિં ન પરિષ્કૃતાઃ? તહ્યન્યે નવજનાઃ કુત્ર? ");
INSERT INTO sanguj_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ઈશ્વરં ધન્યં વદન્તમ્ એનં વિદેશિનં વિના કોપ્યન્યો ન પ્રાપ્યત| ");
INSERT INTO sanguj_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","તદા સ તમુવાચ, ત્વમુત્થાય યાહિ વિશ્વાસસ્તે ત્વાં સ્વસ્થં કૃતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","અથ કદેશ્વરસ્ય રાજત્વં ભવિષ્યતીતિ ફિરૂશિભિઃ પૃષ્ટે સ પ્રત્યુવાચ, ઈશ્વરસ્ય રાજત્વમ્ ઐશ્વર્ય્યદર્શનેન ન ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","અત એતસ્મિન્ પશ્ય તસ્મિન્ વા પશ્ય, ઇતિ વાક્યં લોકા વક્તું ન શક્ષ્યન્તિ, ઈશ્વરસ્ય રાજત્વં યુષ્માકમ્ અન્તરેવાસ્તે| ");
INSERT INTO sanguj_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","તતઃ સ શિષ્યાન્ જગાદ, યદા યુષ્માભિ ર્મનુજસુતસ્ય દિનમેકં દ્રષ્ટુમ્ વાઞ્છિષ્યતે કિન્તુ ન દર્શિષ્યતે, ઈદૃક્કાલ આયાતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","તદાત્ર પશ્ય વા તત્ર પશ્યેતિ વાક્યં લોકા વક્ષ્યન્તિ, કિન્તુ તેષાં પશ્ચાત્ મા યાત, માનુગચ્છત ચ| ");
INSERT INTO sanguj_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","યતસ્તડિદ્ યથાકાશૈકદિશ્યુદિય તદન્યામપિ દિશં વ્યાપ્ય પ્રકાશતે તદ્વત્ નિજદિને મનુજસૂનુઃ પ્રકાશિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","કિન્તુ તત્પૂર્વ્વં તેનાનેકાનિ દુઃખાનિ ભોક્તવ્યાન્યેતદ્વર્ત્તમાનલોકૈશ્ચ સોઽવજ્ઞાતવ્યઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","નોહસ્ય વિદ્યમાનકાલે યથાભવત્ મનુષ્યસૂનોઃ કાલેપિ તથા ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","યાવત્કાલં નોહો મહાપોતં નારોહદ્ આપ્લાવિવાર્ય્યેત્ય સર્વ્વં નાનાશયચ્ચ તાવત્કાલં યથા લોકા અભુઞ્જતાપિવન્ વ્યવહન્ વ્યવાહયંશ્ચ; ");
INSERT INTO sanguj_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ઇત્થં લોટો વર્ત્તમાનકાલેપિ યથા લોકા ભોજનપાનક્રયવિક્રયરોપણગૃહનિર્મ્માણકર્મ્મસુ પ્રાવર્ત્તન્ત, ");
INSERT INTO sanguj_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","કિન્તુ યદા લોટ્ સિદોમો નિર્જગામ તદા નભસઃ સગન્ધકાગ્નિવૃષ્ટિ ર્ભૂત્વા સર્વ્વં વ્યનાશયત્ ");
INSERT INTO sanguj_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","તદ્વન્ માનવપુત્રપ્રકાશદિનેપિ ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","તદા યદિ કશ્ચિદ્ ગૃહોપરિ તિષ્ઠતિ તર્હિ સ ગૃહમધ્યાત્ કિમપિ દ્રવ્યમાનેતુમ્ અવરુહ્ય નૈતુ; યશ્ચ ક્ષેત્રે તિષ્ઠતિ સોપિ વ્યાઘુટ્ય નાયાતુ| ");
INSERT INTO sanguj_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","લોટઃ પત્નીં સ્મરત| ");
INSERT INTO sanguj_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","યઃ પ્રાણાન્ રક્ષિતું ચેષ્ટિષ્યતે સ પ્રાણાન્ હારયિષ્યતિ યસ્તુ પ્રાણાન્ હારયિષ્યતિ સએવ પ્રાણાન્ રક્ષિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","યુષ્માનહં વચ્મિ તસ્યાં રાત્રૌ શય્યૈકગતયો ર્લોકયોરેકો ધારિષ્યતે પરસ્ત્યક્ષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","સ્ત્રિયૌ યુગપત્ પેષણીં વ્યાવર્ત્તયિષ્યતસ્તયોરેકા ધારિષ્યતે પરાત્યક્ષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","પુરુષૌ ક્ષેત્રે સ્થાસ્યતસ્તયોરેકો ધારિષ્યતે પરસ્ત્યક્ષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","તદા તે પપ્રચ્છુઃ, હે પ્રભો કુત્રેત્થં ભવિષ્યતિ? તતઃ સ ઉવાચ, યત્ર શવસ્તિષ્ઠતિ તત્ર ગૃધ્રા મિલન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","અપરઞ્ચ લોકૈરક્લાન્તૈ ર્નિરન્તરં પ્રાર્થયિતવ્યમ્ ઇત્યાશયેન યીશુના દૃષ્ટાન્ત એકઃ કથિતઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","કુત્રચિન્નગરે કશ્ચિત્ પ્રાડ્વિવાક આસીત્ સ ઈશ્વરાન્નાબિભેત્ માનુષાંશ્ચ નામન્યત| ");
INSERT INTO sanguj_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","અથ તત્પુરવાસિની કાચિદ્વિધવા તત્સમીપમેત્ય વિવાદિના સહ મમ વિવાદં પરિષ્કુર્વ્વિતિ નિવેદયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","તતઃ સ પ્રાડ્વિવાકઃ કિયદ્દિનાનિ ન તદઙ્ગીકૃતવાન્ પશ્ચાચ્ચિત્તે ચિન્તયામાસ, યદ્યપીશ્વરાન્ન બિભેમિ મનુષ્યાનપિ ન મન્યે ");
INSERT INTO sanguj_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","તથાપ્યેષા વિધવા માં ક્લિશ્નાતિ તસ્માદસ્યા વિવાદં પરિષ્કરિષ્યામિ નોચેત્ સા સદાગત્ય માં વ્યગ્રં કરિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","પશ્ચાત્ પ્રભુરવદદ્ અસાવન્યાયપ્રાડ્વિવાકો યદાહ તત્ર મનો નિધધ્વં| ");
INSERT INTO sanguj_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ઈશ્વરસ્ય યે ઽભિરુચિતલોકા દિવાનિશં પ્રાર્થયન્તે સ બહુદિનાનિ વિલમ્બ્યાપિ તેષાં વિવાદાન્ કિં ન પરિષ્કરિષ્યતિ? ");
INSERT INTO sanguj_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","યુષ્માનહં વદામિ ત્વરયા પરિષ્કરિષ્યતિ, કિન્તુ યદા મનુષ્યપુત્ર આગમિષ્યતિ તદા પૃથિવ્યાં કિમીદૃશં વિશ્વાસં પ્રાપ્સ્યતિ? ");
INSERT INTO sanguj_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","યે સ્વાન્ ધાર્મ્મિકાન્ જ્ઞાત્વા પરાન્ તુચ્છીકુર્વ્વન્તિ એતાદૃગ્ભ્યઃ, કિયદ્ભ્ય ઇમં દૃષ્ટાન્તં કથયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","એકઃ ફિરૂશ્યપરઃ કરસઞ્ચાયી દ્વાવિમૌ પ્રાર્થયિતું મન્દિરં ગતૌ| ");
INSERT INTO sanguj_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","તતોઽસૌ ફિરૂશ્યેકપાર્શ્વે તિષ્ઠન્ હે ઈશ્વર અહમન્યલોકવત્ લોઠયિતાન્યાયી પારદારિકશ્ચ ન ભવામિ અસ્ય કરસઞ્ચાયિનસ્તુલ્યશ્ચ ન, તસ્માત્ત્વાં ધન્યં વદામિ| ");
INSERT INTO sanguj_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","સપ્તસુ દિનેષુ દિનદ્વયમુપવસામિ સર્વ્વસમ્પત્તે ર્દશમાંશં દદામિ ચ, એતત્કથાં કથયન્ પ્રાર્થયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","કિન્તુ સ કરસઞ્ચાયિ દૂરે તિષ્ઠન્ સ્વર્ગં દ્રષ્ટું નેચ્છન્ વક્ષસિ કરાઘાતં કુર્વ્વન્ હે ઈશ્વર પાપિષ્ઠં માં દયસ્વ, ઇત્થં પ્રાર્થયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","યુષ્માનહં વદામિ, તયોર્દ્વયો ર્મધ્યે કેવલઃ કરસઞ્ચાયી પુણ્યવત્ત્વેન ગણિતો નિજગૃહં જગામ, યતો યઃ કશ્ચિત્ સ્વમુન્નમયતિ સ નામયિષ્યતે કિન્તુ યઃ કશ્ચિત્ સ્વં નમયતિ સ ઉન્નમયિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","અથ શિશૂનાં ગાત્રસ્પર્શાર્થં લોકાસ્તાન્ તસ્ય સમીપમાનિન્યુઃ શિષ્યાસ્તદ્ દૃષ્ટ્વાનેતૃન્ તર્જયામાસુઃ, ");
INSERT INTO sanguj_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","કિન્તુ યીશુસ્તાનાહૂય જગાદ, મન્નિકટમ્ આગન્તું શિશૂન્ અનુજાનીધ્વં તાંશ્ચ મા વારયત; યત ઈશ્વરરાજ્યાધિકારિણ એષાં સદૃશાઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","અહં યુષ્માન્ યથાર્થં વદામિ, યો જનઃ શિશોઃ સદૃશો ભૂત્વા ઈશ્વરરાજ્યં ન ગૃહ્લાતિ સ કેનાપિ પ્રકારેણ તત્ પ્રવેષ્ટું ન શક્નોતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","અપરમ્ એકોધિપતિસ્તં પપ્રચ્છ, હે પરમગુરો, અનન્તાયુષઃ પ્રાપ્તયે મયા કિં કર્ત્તવ્યં? ");
INSERT INTO sanguj_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","યીશુરુવાચ, માં કુતઃ પરમં વદસિ? ઈશ્વરં વિના કોપિ પરમો ન ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","પરદારાન્ મા ગચ્છ, નરં મા જહિ, મા ચોરય, મિથ્યાસાક્ષ્યં મા દેહિ, માતરં પિતરઞ્ચ સંમન્યસ્વ, એતા યા આજ્ઞાઃ સન્તિ તાસ્ત્વં જાનાસિ| ");
INSERT INTO sanguj_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","તદા સ ઉવાચ, બાલ્યકાલાત્ સર્વ્વા એતા આચરામિ| ");
INSERT INTO sanguj_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ઇતિ કથાં શ્રુત્વા યીશુસ્તમવદત્, તથાપિ તવૈકં કર્મ્મ ન્યૂનમાસ્તે, નિજં સર્વ્વસ્વં વિક્રીય દરિદ્રેભ્યો વિતર, તસ્માત્ સ્વર્ગે ધનં પ્રાપ્સ્યસિ; તત આગત્ય મમાનુગામી ભવ| ");
INSERT INTO sanguj_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","કિન્ત્વેતાં કથાં શ્રુત્વા સોધિપતિઃ શુશોચ, યતસ્તસ્ય બહુધનમાસીત્| ");
INSERT INTO sanguj_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","તદા યીશુસ્તમતિશોકાન્વિતં દૃષ્ટ્વા જગાદ, ધનવતામ્ ઈશ્વરરાજ્યપ્રવેશઃ કીદૃગ્ દુષ્કરઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ઈશ્વરરાજ્યે ધનિનઃ પ્રવેશાત્ સૂચેશ્છિદ્રેણ મહાઙ્ગસ્ય ગમનાગમને સુકરે| ");
INSERT INTO sanguj_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","શ્રોતારઃ પપ્રચ્છુસ્તર્હિ કેન પરિત્રાણં પ્રાપ્સ્યતે? ");
INSERT INTO sanguj_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","સ ઉક્તવાન્, યન્ માનુષેણાશક્યં તદ્ ઈશ્વરેણ શક્યં| ");
INSERT INTO sanguj_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","તદા પિતર ઉવાચ, પશ્ય વયં સર્વ્વસ્વં પરિત્યજ્ય તવ પશ્ચાદ્ગામિનોઽભવામ| ");
INSERT INTO sanguj_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","તતઃ સ ઉવાચ, યુષ્માનહં યથાર્થં વદામિ, ઈશ્વરરાજ્યાર્થં ગૃહં પિતરૌ ભ્રાતૃગણં જાયાં સન્તાનાંશ્ચ ત્યક્તવા ");
INSERT INTO sanguj_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ઇહ કાલે તતોઽધિકં પરકાલે ઽનન્તાયુશ્ચ ન પ્રાપ્સ્યતિ લોક ઈદૃશઃ કોપિ નાસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","અનન્તરં સ દ્વાદશશિષ્યાનાહૂય બભાષે, પશ્યત વયં યિરૂશાલમ્નગરં યામઃ, તસ્માત્ મનુષ્યપુત્રે ભવિષ્યદ્વાદિભિરુક્તં યદસ્તિ તદનુરૂપં તં પ્રતિ ઘટિષ્યતે; ");
INSERT INTO sanguj_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","વસ્તુતસ્તુ સોઽન્યદેશીયાનાં હસ્તેષુ સમર્પયિષ્યતે, તે તમુપહસિષ્યન્તિ, અન્યાયમાચરિષ્યન્તિ તદ્વપુષિ નિષ્ઠીવં નિક્ષેપ્સ્યન્તિ, કશાભિઃ પ્રહૃત્ય તં હનિષ્યન્તિ ચ, ");
INSERT INTO sanguj_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","કિન્તુ તૃતીયદિને સ શ્મશાનાદ્ ઉત્થાસ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","એતસ્યાઃ કથાયા અભિપ્રાયં કિઞ્ચિદપિ તે બોદ્ધું ન શેકુઃ તેષાં નિકટેઽસ્પષ્ટતવાત્ તસ્યૈતાસાં કથાનામ્ આશયં તે જ્ઞાતું ન શેકુશ્ચ| ");
INSERT INTO sanguj_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","અથ તસ્મિન્ યિરીહોઃ પુરસ્યાન્તિકં પ્રાપ્તે કશ્ચિદન્ધઃ પથઃ પાર્શ્વ ઉપવિશ્ય ભિક્ષામ્ અકરોત્ ");
INSERT INTO sanguj_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","સ લોકસમૂહસ્ય ગમનશબ્દં શ્રુત્વા તત્કારણં પૃષ્ટવાન્| ");
INSERT INTO sanguj_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","નાસરતીયયીશુર્યાતીતિ લોકૈરુક્તે સ ઉચ્ચૈર્વક્તુમારેભે, ");
INSERT INTO sanguj_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","હે દાયૂદઃ સન્તાન યીશો માં દયસ્વ| ");
INSERT INTO sanguj_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","તતોગ્રગામિનસ્તં મૌની તિષ્ઠેતિ તર્જયામાસુઃ કિન્તુ સ પુનારુવન્ ઉવાચ, હે દાયૂદઃ સન્તાન માં દયસ્વ| ");
INSERT INTO sanguj_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","તદા યીશુઃ સ્થગિતો ભૂત્વા સ્વાન્તિકે તમાનેતુમ્ આદિદેશ| ");
INSERT INTO sanguj_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","તતઃ સ તસ્યાન્તિકમ્ આગમત્, તદા સ તં પપ્રચ્છ, ત્વં કિમિચ્છસિ? ત્વદર્થમહં કિં કરિષ્યામિ? સ ઉક્તવાન્, હે પ્રભોઽહં દ્રષ્ટું લભૈ| ");
INSERT INTO sanguj_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","તદા યીશુરુવાચ, દૃષ્ટિશક્તિં ગૃહાણ તવ પ્રત્યયસ્ત્વાં સ્વસ્થં કૃતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","તતસ્તત્ક્ષણાત્ તસ્ય ચક્ષુષી પ્રસન્ને; તસ્માત્ સ ઈશ્વરં ધન્યં વદન્ તત્પશ્ચાદ્ યયૌ, તદાલોક્ય સર્વ્વે લોકા ઈશ્વરં પ્રશંસિતુમ્ આરેભિરે| ");
INSERT INTO sanguj_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","યદા યીશુ ર્યિરીહોપુરં પ્રવિશ્ય તન્મધ્યેન ગચ્છંસ્તદા ");
INSERT INTO sanguj_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","સક્કેયનામા કરસઞ્ચાયિનાં પ્રધાનો ધનવાનેકો ");
INSERT INTO sanguj_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","યીશુઃ કીદૃગિતિ દ્રષ્ટું ચેષ્ટિતવાન્ કિન્તુ ખર્વ્વત્વાલ્લોકસંઘમધ્યે તદ્દર્શનમપ્રાપ્ય ");
INSERT INTO sanguj_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","યેન પથા સ યાસ્યતિ તત્પથેઽગ્રે ધાવિત્વા તં દ્રષ્ટુમ્ ઉડુમ્બરતરુમારુરોહ| ");
INSERT INTO sanguj_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","પશ્ચાદ્ યીશુસ્તત્સ્થાનમ્ ઇત્વા ઊર્દ્ધ્વં વિલોક્ય તં દૃષ્ટ્વાવાદીત્, હે સક્કેય ત્વં શીઘ્રમવરોહ મયાદ્ય ત્વદ્ગેહે વસ્તવ્યં| ");
INSERT INTO sanguj_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","તતઃ સ શીઘ્રમવરુહ્ય સાહ્લાદં તં જગ્રાહ| ");
INSERT INTO sanguj_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","તદ્ દૃષ્ટ્વા સર્વ્વે વિવદમાના વક્તુમારેભિરે, સોતિથિત્વેન દુષ્ટલોકગૃહં ગચ્છતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","કિન્તુ સક્કેયો દણ્ડાયમાનો વક્તુમારેભે, હે પ્રભો પશ્ય મમ યા સમ્પત્તિરસ્તિ તદર્દ્ધં દરિદ્રેભ્યો દદે, અપરમ્ અન્યાયં કૃત્વા કસ્માદપિ યદિ કદાપિ કિઞ્ચિત્ મયા ગૃહીતં તર્હિ તચ્ચતુર્ગુણં દદામિ| ");
INSERT INTO sanguj_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","તદા યીશુસ્તમુક્તવાન્ અયમપિ ઇબ્રાહીમઃ સન્તાનોઽતઃ કારણાદ્ અદ્યાસ્ય ગૃહે ત્રાણમુપસ્થિતં| ");
INSERT INTO sanguj_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","યદ્ હારિતં તત્ મૃગયિતું રક્ષિતુઞ્ચ મનુષ્યપુત્ર આગતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","અથ સ યિરૂશાલમઃ સમીપ ઉપાતિષ્ઠદ્ ઈશ્વરરાજત્વસ્યાનુષ્ઠાનં તદૈવ ભવિષ્યતીતિ લોકૈરન્વભૂયત, તસ્માત્ સ શ્રોતૃભ્યઃ પુનર્દૃષ્ટાન્તકથામ્ ઉત્થાપ્ય કથયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","કોપિ મહાલ્લોકો નિજાર્થં રાજત્વપદં ગૃહીત્વા પુનરાગન્તું દૂરદેશં જગામ| ");
INSERT INTO sanguj_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","યાત્રાકાલે નિજાન્ દશદાસાન્ આહૂય દશસ્વર્ણમુદ્રા દત્ત્વા મમાગમનપર્ય્યન્તં વાણિજ્યં કુરુતેત્યાદિદેશ| ");
INSERT INTO sanguj_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","કિન્તુ તસ્ય પ્રજાસ્તમવજ્ઞાય મનુષ્યમેનમ્ અસ્માકમુપરિ રાજત્વં ન કારયિવ્યામ ઇમાં વાર્ત્તાં તન્નિકટે પ્રેરયામાસુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","અથ સ રાજત્વપદં પ્રાપ્યાગતવાન્ એકૈકો જનો બાણિજ્યેન કિં લબ્ધવાન્ ઇતિ જ્ઞાતું યેષુ દાસેષુ મુદ્રા અર્પયત્ તાન્ આહૂયાનેતુમ્ આદિદેશ| ");
INSERT INTO sanguj_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","તદા પ્રથમ આગત્ય કથિતવાન્, હે પ્રભો તવ તયૈકયા મુદ્રયા દશમુદ્રા લબ્ધાઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","તતઃ સ ઉવાચ ત્વમુત્તમો દાસઃ સ્વલ્પેન વિશ્વાસ્યો જાત ઇતઃ કારણાત્ ત્વં દશનગરાણામ્ અધિપો ભવ| ");
INSERT INTO sanguj_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","દ્વિતીય આગત્ય કથિતવાન્, હે પ્રભો તવૈકયા મુદ્રયા પઞ્ચમુદ્રા લબ્ધાઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","તતઃ સ ઉવાચ, ત્વં પઞ્ચાનાં નગરાણામધિપતિ ર્ભવ| ");
INSERT INTO sanguj_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","તતોન્ય આગત્ય કથયામાસ, હે પ્રભો પશ્ય તવ યા મુદ્રા અહં વસ્ત્રે બદ્ધ્વાસ્થાપયં સેયં| ");
INSERT INTO sanguj_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ત્વં કૃપણો યન્નાસ્થાપયસ્તદપિ ગૃહ્લાસિ, યન્નાવપસ્તદેવ ચ છિનત્સિ તતોહં ત્વત્તો ભીતઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","તદા સ જગાદ, રે દુષ્ટદાસ તવ વાક્યેન ત્વાં દોષિણં કરિષ્યામિ, યદહં નાસ્થાપયં તદેવ ગૃહ્લામિ, યદહં નાવપઞ્ચ તદેવ છિનદ્મિ, એતાદૃશઃ કૃપણોહમિતિ યદિ ત્વં જાનાસિ, ");
INSERT INTO sanguj_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","તર્હિ મમ મુદ્રા બણિજાં નિકટે કુતો નાસ્થાપયઃ? તયા કૃતેઽહમ્ આગત્ય કુસીદેન સાર્દ્ધં નિજમુદ્રા અપ્રાપ્સ્યમ્| ");
INSERT INTO sanguj_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","પશ્ચાત્ સ સમીપસ્થાન્ જનાન્ આજ્ઞાપયત્ અસ્માત્ મુદ્રા આનીય યસ્ય દશમુદ્રાઃ સન્તિ તસ્મૈ દત્ત| ");
INSERT INTO sanguj_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","તે પ્રોચુઃ પ્રભોઽસ્ય દશમુદ્રાઃ સન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","યુષ્માનહં વદામિ યસ્યાશ્રયે વદ્ધતે ઽધિકં તસ્મૈ દાયિષ્યતે, કિન્તુ યસ્યાશ્રયે ન વર્દ્ધતે તસ્ય યદ્યદસ્તિ તદપિ તસ્માન્ નાયિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","કિન્તુ મમાધિપતિત્વસ્ય વશત્વે સ્થાતુમ્ અસમ્મન્યમાના યે મમ રિપવસ્તાનાનીય મમ સમક્ષં સંહરત| ");
INSERT INTO sanguj_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ઇત્યુપદેશકથાં કથયિત્વા સોગ્રગઃ સન્ યિરૂશાલમપુરં યયૌ| ");
INSERT INTO sanguj_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","તતો બૈત્ફગીબૈથનીયાગ્રામયોઃ સમીપે જૈતુનાદ્રેરન્તિકમ્ ઇત્વા શિષ્યદ્વયમ્ ઇત્યુક્ત્વા પ્રેષયામાસ, ");
INSERT INTO sanguj_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","યુવામમું સમ્મુખસ્થગ્રામં પ્રવિશ્યૈવ યં કોપિ માનુષઃ કદાપિ નારોહત્ તં ગર્દ્દભશાવકં બદ્ધં દ્રક્ષ્યથસ્તં મોચયિત્વાનયતં| ");
INSERT INTO sanguj_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","તત્ર કુતો મોચયથઃ? ઇતિ ચેત્ કોપિ વક્ષ્યતિ તર્હિ વક્ષ્યથઃ પ્રભેाરત્ર પ્રયોજનમ્ આસ્તે| ");
INSERT INTO sanguj_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","તદા તૌ પ્રરિતૌ ગત્વા તત્કથાाનુસારેણ સર્વ્વં પ્રાપ્તૌ| ");
INSERT INTO sanguj_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ગર્દભશાવકમોચનકાલે તત્વામિન ઊચુઃ, ગર્દભશાવકં કુતો મોચયથઃ? ");
INSERT INTO sanguj_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","તાવૂચતુઃ પ્રભોરત્ર પ્રયોજનમ્ આસ્તે| ");
INSERT INTO sanguj_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","પશ્ચાત્ તૌ તં ગર્દભશાવકં યીશોરન્તિકમાનીય તત્પૃષ્ઠે નિજવસનાનિ પાતયિત્વા તદુપરિ યીશુમારોહયામાસતુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","અથ યાત્રાકાલે લોકાઃ પથિ સ્વવસ્ત્રાણિ પાતયિતુમ્ આરેભિરે| ");
INSERT INTO sanguj_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","અપરં જૈતુનાદ્રેરુપત્યકામ્ ઇત્વા શિષ્યસંઘઃ પૂર્વ્વદૃષ્ટાનિ મહાકર્મ્માણિ સ્મૃત્વા, ");
INSERT INTO sanguj_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","યો રાજા પ્રભો ર્નામ્નાયાતિ સ ધન્યઃ સ્વર્ગે કુશલં સર્વ્વોચ્ચે જયધ્વનિ ર્ભવતુ, કથામેતાં કથયિત્વા સાનન્દમ્ ઉચૈરીશ્વરં ધન્યં વક્તુમારેભે| ");
INSERT INTO sanguj_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","તદા લોકારણ્યમધ્યસ્થાઃ કિયન્તઃ ફિરૂશિનસ્તત્ શ્રુત્વા યીશું પ્રોચુઃ, હે ઉપદેશક સ્વશિષ્યાન્ તર્જય| ");
INSERT INTO sanguj_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","સ ઉવાચ, યુષ્માનહં વદામિ યદ્યમી નીરવાસ્તિષ્ઠન્તિ તર્હિ પાષાણા ઉચૈઃ કથાઃ કથયિષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","પશ્ચાત્ તત્પુરાન્તિકમેત્ય તદવલોક્ય સાશ્રુપાતં જગાદ, ");
INSERT INTO sanguj_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","હા હા ચેત્ ત્વમગ્રેઽજ્ઞાસ્યથાઃ, તવાસ્મિન્નેવ દિને વા યદિ સ્વમઙ્ગલમ્ ઉપાલપ્સ્યથાઃ, તર્હ્યુત્તમમ્ અભવિષ્યત્, કિન્તુ ક્ષણેસ્મિન્ તત્તવ દૃષ્ટેરગોચરમ્ ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ત્વં સ્વત્રાણકાલે ન મનો ન્યધત્થા ઇતિ હેતો ર્યત્કાલે તવ રિપવસ્ત્વાં ચતુર્દિક્ષુ પ્રાચીરેણ વેષ્ટયિત્વા રોત્સ્યન્તિ ");
INSERT INTO sanguj_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","બાલકૈઃ સાર્દ્ધં ભૂમિસાત્ કરિષ્યન્તિ ચ ત્વન્મધ્યે પાષાણૈકોપિ પાષાણોપરિ ન સ્થાસ્યતિ ચ, કાલ ઈદૃશ ઉપસ્થાસ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","અથ મધ્યેમન્દિરં પ્રવિશ્ય તત્રત્યાન્ ક્રયિવિક્રયિણો બહિષ્કુર્વ્વન્ ");
INSERT INTO sanguj_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","અવદત્ મદ્ગૃહં પ્રાર્થનાગૃહમિતિ લિપિરાસ્તે કિન્તુ યૂયં તદેવ ચૈરાણાં ગહ્વરં કુરુથ| ");
INSERT INTO sanguj_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","પશ્ચાત્ સ પ્રત્યહં મધ્યેમન્દિરમ્ ઉપદિદેશ; તતઃ પ્રધાનયાજકા અધ્યાપકાઃ પ્રાચીનાશ્ચ તં નાશયિતું ચિચેષ્ટિરે; ");
INSERT INTO sanguj_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","કિન્તુ તદુપદેશે સર્વ્વે લોકા નિવિષ્ટચિત્તાઃ સ્થિતાસ્તસ્માત્ તે તત્કર્ત્તું નાવકાશં પ્રાપુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","અથૈકદા યીશુ ર્મનિદરે સુસંવાદં પ્રચારયન્ લોકાનુપદિશતિ, એતર્હિ પ્રધાનયાજકા અધ્યાપકાઃ પ્રાઞ્ચશ્ચ તન્નિકટમાગત્ય પપ્રચ્છુઃ ");
INSERT INTO sanguj_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","કયાજ્ઞયા ત્વં કર્મ્માણ્યેતાનિ કરોષિ? કો વા ત્વામાજ્ઞાપયત્? તદસ્માન્ વદ| ");
INSERT INTO sanguj_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","સ પ્રત્યુવાચ, તર્હિ યુષ્માનપિ કથામેકાં પૃચ્છામિ તસ્યોત્તરં વદત| ");
INSERT INTO sanguj_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","યોહનો મજ્જનમ્ ઈશ્વરસ્ય માનુષાણાં વાજ્ઞાતો જાતં? ");
INSERT INTO sanguj_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","તતસ્તે મિથો વિવિચ્ય જગદુઃ, યદીશ્વરસ્ય વદામસ્તર્હિ તં કુતો ન પ્રત્યૈત સ ઇતિ વક્ષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","યદિ મનુષ્યસ્યેતિ વદામસ્તર્હિ સર્વ્વે લોકા અસ્માન્ પાષાણૈ ર્હનિષ્યન્તિ યતો યોહન્ ભવિષ્યદ્વાદીતિ સર્વ્વે દૃઢં જાનન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","અતએવ તે પ્રત્યૂચુઃ કસ્યાજ્ઞયા જાતમ્ ઇતિ વક્તું ન શક્નુમઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","તદા યીશુરવદત્ તર્હિ કયાજ્ઞયા કર્મ્માણ્યેતાતિ કરોમીતિ ચ યુષ્માન્ ન વક્ષ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","અથ લોકાનાં સાક્ષાત્ સ ઇમાં દૃષ્ટાન્તકથાં વક્તુમારેભે, કશ્ચિદ્ દ્રાક્ષાક્ષેત્રં કૃત્વા તત્ ક્ષેત્રં કૃષીવલાનાં હસ્તેષુ સમર્પ્ય બહુકાલાર્થં દૂરદેશં જગામ| ");
INSERT INTO sanguj_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","અથ ફલકાલે ફલાનિ ગ્રહીતુ કૃષીવલાનાં સમીપે દાસં પ્રાહિણોત્ કિન્તુ કૃષીવલાસ્તં પ્રહૃત્ય રિક્તહસ્તં વિસસર્જુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","તતઃ સોધિપતિઃ પુનરન્યં દાસં પ્રેષયામાસ, તે તમપિ પ્રહૃત્ય કુવ્યવહૃત્ય રિક્તહસ્તં વિસસૃજુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","તતઃ સ તૃતીયવારમ્ અન્યં પ્રાહિણોત્ તે તમપિ ક્ષતાઙ્ગં કૃત્વા બહિ ર્નિચિક્ષિપુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","તદા ક્ષેત્રપતિ ર્વિચારયામાસ, મમેદાનીં કિં કર્ત્તવ્યં? મમ પ્રિયે પુત્રે પ્રહિતે તે તમવશ્યં દૃષ્ટ્વા સમાદરિષ્યન્તે| ");
INSERT INTO sanguj_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","કિન્તુ કૃષીવલાસ્તં નિરીક્ષ્ય પરસ્પરં વિવિચ્ય પ્રોચુઃ, અયમુત્તરાધિકારી આગચ્છતૈનં હન્મસ્તતોધિકારોસ્માકં ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","તતસ્તે તં ક્ષેત્રાદ્ બહિ ર્નિપાત્ય જઘ્નુસ્તસ્માત્ સ ક્ષેત્રપતિસ્તાન્ પ્રતિ કિં કરિષ્યતિ? ");
INSERT INTO sanguj_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","સ આગત્ય તાન્ કૃષીવલાન્ હત્વા પરેષાં હસ્તેષુ તત્ક્ષેત્રં સમર્પયિષ્યતિ; ઇતિ કથાં શ્રુત્વા તે ઽવદન્ એતાદૃશી ઘટના ન ભવતુ| ");
INSERT INTO sanguj_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","કિન્તુ યીશુસ્તાનવલોક્ય જગાદ, તર્હિ, સ્થપતયઃ કરિષ્યન્તિ ગ્રાવાણં યન્તુ તુચ્છકં| પ્રધાનપ્રસ્તરઃ કોણે સ એવ હિ ભવિષ્યતિ| એતસ્ય શાસ્ત્રીયવચનસ્ય કિં તાત્પર્ય્યં? ");
INSERT INTO sanguj_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","અપરં તત્પાષાણોપરિ યઃ પતિષ્યતિ સ ભંક્ષ્યતે કિન્તુ યસ્યોપરિ સ પાષાણઃ પતિષ્યતિ સ તેન ધૂલિવચ્ ચૂર્ણીભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","સોસ્માકં વિરુદ્ધં દૃષ્ટાન્તમિમં કથિતવાન્ ઇતિ જ્ઞાત્વા પ્રધાનયાજકા અધ્યાપકાશ્ચ તદૈવ તં ધર્તું વવાઞ્છુઃ કિન્તુ લોકેભ્યો બિભ્યુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","અતએવ તં પ્રતિ સતર્કાઃ સન્તઃ કથં તદ્વાક્યદોષં ધૃત્વા તં દેશાધિપસ્ય સાધુવેશધારિણશ્ચરાન્ તસ્ય સમીપે પ્રેષયામાસુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","તદા તે તં પપ્રચ્છુઃ, હે ઉપદેશક ભવાન્ યથાર્થં કથયન્ ઉપદિશતિ, કમપ્યનપેક્ષ્ય સત્યત્વેનૈશ્વરં માર્ગમુપદિશતિ, વયમેતજ્જાનીમઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","કૈસરરાજાય કરોસ્માભિ ર્દેયો ન વા? ");
INSERT INTO sanguj_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","સ તેષાં વઞ્ચનં જ્ઞાત્વાવદત્ કુતો માં પરીક્ષધ્વે? માં મુદ્રામેકં દર્શયત| ");
INSERT INTO sanguj_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","ઇહ લિખિતા મૂર્તિરિયં નામ ચ કસ્ય? તેઽવદન્ કૈસરસ્ય| ");
INSERT INTO sanguj_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","તદા સ ઉવાચ, તર્હિ કૈસરસ્ય દ્રવ્યં કૈસરાય દત્ત; ઈશ્વરસ્ય તુ દ્રવ્યમીશ્વરાય દત્ત| ");
INSERT INTO sanguj_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","તસ્માલ્લોકાનાં સાક્ષાત્ તત્કથાયાઃ કમપિ દોષં ધર્તુમપ્રાપ્ય તે તસ્યોત્તરાદ્ આશ્ચર્ય્યં મન્યમાના મૌનિનસ્તસ્થુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","અપરઞ્ચ શ્મશાનાદુત્થાનાનઙ્ગીકારિણાં સિદૂકિનાં કિયન્તો જના આગત્ય તં પપ્રચ્છુઃ, ");
INSERT INTO sanguj_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","હે ઉપદેશક શાસ્ત્રે મૂસા અસ્માન્ પ્રતીતિ લિલેખ યસ્ય ભ્રાતા ભાર્ય્યાયાં સત્યાં નિઃસન્તાનો મ્રિયતે સ તજ્જાયાં વિવહ્ય તદ્વંશમ્ ઉત્પાદયિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","તથાચ કેચિત્ સપ્ત ભ્રાતર આસન્ તેષાં જ્યેષ્ઠો ભ્રાતા વિવહ્ય નિરપત્યઃ પ્રાણાન્ જહૌ| ");
INSERT INTO sanguj_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","અથ દ્વિતીયસ્તસ્ય જાયાં વિવહ્ય નિરપત્યઃ સન્ મમાર| તૃતીયશ્ચ તામેવ વ્યુવાહ; ");
INSERT INTO sanguj_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ઇત્થં સપ્ત ભ્રાતરસ્તામેવ વિવહ્ય નિરપત્યાઃ સન્તો મમ્રુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","શેષે સા સ્ત્રી ચ મમાર| ");
INSERT INTO sanguj_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","અતએવ શ્મશાનાદુત્થાનકાલે તેષાં સપ્તજનાનાં કસ્ય સા ભાર્ય્યા ભવિષ્યતિ? યતઃ સા તેષાં સપ્તાનામેવ ભાર્ય્યાસીત્| ");
INSERT INTO sanguj_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","તદા યીશુઃ પ્રત્યુવાચ, એતસ્ય જગતો લોકા વિવહન્તિ વાગ્દત્તાશ્ચ ભવન્તિ ");
INSERT INTO sanguj_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","કિન્તુ યે તજ્જગત્પ્રાપ્તિયોગ્યત્વેન ગણિતાં ભવિષ્યન્તિ શ્મશાનાચ્ચોત્થાસ્યન્તિ તે ન વિવહન્તિ વાગ્દત્તાશ્ચ ન ભવન્તિ, ");
INSERT INTO sanguj_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","તે પુન ર્ન મ્રિયન્તે કિન્તુ શ્મશાનાદુત્થાપિતાઃ સન્ત ઈશ્વરસ્ય સન્તાનાઃ સ્વર્ગીયદૂતાનાં સદૃશાશ્ચ ભવન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","અધિકન્તુ મૂસાઃ સ્તમ્બોપાખ્યાને પરમેશ્વર ઈબ્રાહીમ ઈશ્વર ઇસ્હાક ઈશ્વરો યાકૂબશ્ચેશ્વર ઇત્યુક્ત્વા મૃતાનાં શ્મશાનાદ્ ઉત્થાનસ્ય પ્રમાણં લિલેખ| ");
INSERT INTO sanguj_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","અતએવ ય ઈશ્વરઃ સ મૃતાનાં પ્રભુ ર્ન કિન્તુ જીવતામેવ પ્રભુઃ, તન્નિકટે સર્વ્વે જીવન્તઃ સન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ઇતિ શ્રુત્વા કિયન્તોધ્યાપકા ઊચુઃ, હે ઉપદેશક ભવાન્ ભદ્રં પ્રત્યુક્તવાન્| ");
INSERT INTO sanguj_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ઇતઃ પરં તં કિમપિ પ્રષ્ટં તેષાં પ્રગલ્ભતા નાભૂત્| ");
INSERT INTO sanguj_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","પશ્ચાત્ સ તાન્ ઉવાચ, યઃ ખ્રીષ્ટઃ સ દાયૂદઃ સન્તાન એતાં કથાં લોકાઃ કથં કથયન્તિ? ");
INSERT INTO sanguj_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","યતઃ મમ પ્રભુમિદં વાક્યમવદત્ પરમેશ્વરઃ| તવ શત્રૂનહં યાવત્ પાદપીઠં કરોમિ ન| તાવત્ કાલં મદીયે ત્વં દક્ષપાર્શ્વ ઉપાવિશ| ");
INSERT INTO sanguj_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ઇતિ કથાં દાયૂદ્ સ્વયં ગીતગ્રન્થેઽવદત્| ");
INSERT INTO sanguj_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","અતએવ યદિ દાયૂદ્ તં પ્રભું વદતિ, તર્હિ સ કથં તસ્ય સન્તાનો ભવતિ? ");
INSERT INTO sanguj_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","પશ્ચાદ્ યીશુઃ સર્વ્વજનાનાં કર્ણગોચરે શિષ્યાનુવાચ, ");
INSERT INTO sanguj_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","યેઽધ્યાપકા દીર્ઘપરિચ્છદં પરિધાય ભ્રમન્તિ, હટ્ટાપણયો ર્નમસ્કારે ભજનગેહસ્ય પ્રોચ્ચાસને ભોજનગૃહસ્ય પ્રધાનસ્થાને ચ પ્રીયન્તે ");
INSERT INTO sanguj_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","વિધવાનાં સર્વ્વસ્વં ગ્રસિત્વા છલેન દીર્ઘકાલં પ્રાર્થયન્તે ચ તેષુ સાવધાના ભવત, તેષામુગ્રદણ્ડો ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","અથ ધનિલોકા ભાણ્ડાગારે ધનં નિક્ષિપન્તિ સ તદેવ પશ્યતિ, ");
INSERT INTO sanguj_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","એતર્હિ કાચિદ્દીના વિધવા પણદ્વયં નિક્ષિપતિ તદ્ દદર્શ| ");
INSERT INTO sanguj_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","તતો યીશુરુવાચ યુષ્માનહં યથાર્થં વદામિ, દરિદ્રેયં વિધવા સર્વ્વેભ્યોધિકં ન્યક્ષેપ્સીત્, ");
INSERT INTO sanguj_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","યતોન્યે સ્વપ્રાજ્યધનેભ્ય ઈશ્વરાય કિઞ્ચિત્ ન્યક્ષેપ્સુઃ, કિન્તુ દરિદ્રેયં વિધવા દિનયાપનાર્થં સ્વસ્ય યત્ કિઞ્ચિત્ સ્થિતં તત્ સર્વ્વં ન્યક્ષેપ્સીત્| ");
INSERT INTO sanguj_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","અપરઞ્ચ ઉત્તમપ્રસ્તરૈરુત્સૃષ્ટવ્યૈશ્ચ મન્દિરં સુશોભતેતરાં કૈશ્ચિદિત્યુક્તે સ પ્રત્યુવાચ ");
INSERT INTO sanguj_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","યૂયં યદિદં નિચયનં પશ્યથ, અસ્ય પાષાણૈકોપ્યન્યપાષાણોપરિ ન સ્થાસ્યતિ, સર્વ્વે ભૂસાદ્ભવિષ્યન્તિ કાલોયમાયાતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","તદા તે પપ્રચ્છુઃ, હે ગુરો ઘટનેદૃશી કદા ભવિષ્યતિ? ઘટનાયા એતસ્યસશ્ચિહ્નં વા કિં ભવિષ્યતિ? ");
INSERT INTO sanguj_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","તદા સ જગાદ, સાવધાના ભવત યથા યુષ્માકં ભ્રમં કોપિ ન જનયતિ, ખીષ્ટોહમિત્યુક્ત્વા મમ નામ્રા બહવ ઉપસ્થાસ્યન્તિ સ કાલઃ પ્રાયેણોપસ્થિતઃ, તેષાં પશ્ચાન્મા ગચ્છત| ");
INSERT INTO sanguj_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","યુદ્ધસ્યોપપ્લવસ્ય ચ વાર્ત્તાં શ્રુત્વા મા શઙ્કધ્વં, યતઃ પ્રથમમ્ એતા ઘટના અવશ્યં ભવિષ્યન્તિ કિન્તુ નાપાતે યુગાન્તો ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","અપરઞ્ચ કથયામાસ, તદા દેશસ્ય વિપક્ષત્વેન દેશો રાજ્યસ્ય વિપક્ષત્વેન રાજ્યમ્ ઉત્થાસ્યતિ, ");
INSERT INTO sanguj_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","નાનાસ્થાનેષુ મહાભૂકમ્પો દુર્ભિક્ષં મારી ચ ભવિષ્યન્તિ, તથા વ્યોમમણ્ડલસ્ય ભયઙ્કરદર્શનાન્યશ્ચર્ય્યલક્ષણાનિ ચ પ્રકાશયિષ્યન્તે| ");
INSERT INTO sanguj_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","કિન્તુ સર્વ્વાસામેતાસાં ઘટનાનાં પૂર્વ્વં લોકા યુષ્માન્ ધૃત્વા તાડયિષ્યન્તિ, ભજનાલયે કારાયાઞ્ચ સમર્પયિષ્યન્તિ મમ નામકારણાદ્ યુષ્માન્ ભૂપાનાં શાસકાનાઞ્ચ સમ્મુખં નેષ્યન્તિ ચ| ");
INSERT INTO sanguj_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","સાક્ષ્યાર્થમ્ એતાનિ યુષ્માન્ પ્રતિ ઘટિષ્યન્તે| ");
INSERT INTO sanguj_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","તદા કિમુત્તરં વક્તવ્યમ્ એતત્ ન ચિન્તયિષ્યામ ઇતિ મનઃસુ નિશ્ચિતનુત| ");
INSERT INTO sanguj_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","વિપક્ષા યસ્માત્ કિમપ્યુત્તરમ્ આપત્તિઞ્ચ કર્ત્તું ન શક્ષ્યન્તિ તાદૃશં વાક્પટુત્વં જ્ઞાનઞ્ચ યુષ્મભ્યં દાસ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","કિઞ્ચ યૂયં પિત્રા માત્રા ભ્રાત્રા બન્ધુના જ્ઞાત્યા કુટુમ્બેન ચ પરકરેષુ સમર્પયિષ્યધ્વે; તતસ્તે યુષ્માકં કઞ્ચન કઞ્ચન ઘાતયિષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","મમ નામ્નઃ કારણાત્ સર્વ્વૈ ર્મનુષ્યૈ ર્યૂયમ્ ઋતીયિષ્યધ્વે| ");
INSERT INTO sanguj_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","કિન્તુ યુષ્માકં શિરઃકેશૈકોપિ ન વિનંક્ષ્યતિ, ");
INSERT INTO sanguj_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","તસ્માદેવ ધૈર્ય્યમવલમ્બ્ય સ્વસ્વપ્રાણાન્ રક્ષત| ");
INSERT INTO sanguj_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","અપરઞ્ચ યિરૂશાલમ્પુરં સૈન્યવેષ્ટિતં વિલોક્ય તસ્યોચ્છિન્નતાયાઃ સમયઃ સમીપ ઇત્યવગમિષ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","તદા યિહૂદાદેશસ્થા લોકાઃ પર્વ્વતં પલાયન્તાં, યે ચ નગરે તિષ્ઠન્તિ તે દેશાન્તરં પલાયન્તા, યે ચ ગ્રામે તિષ્ઠન્તિ તે નગરં ન પ્રવિશન્તુ, ");
INSERT INTO sanguj_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","યતસ્તદા સમુચિતદણ્ડનાય ધર્મ્મપુસ્તકે યાનિ સર્વ્વાણિ લિખિતાનિ તાનિ સફલાનિ ભવિષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","કિન્તુ યા યાસ્તદા ગર્ભવત્યઃ સ્તન્યદાવ્યશ્ચ તામાં દુર્ગતિ ર્ભવિષ્યતિ, યત એતાલ્લોકાન્ પ્રતિ કોપો દેશે ચ વિષમદુર્ગતિ ર્ઘટિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","વસ્તુતસ્તુ તે ખઙ્ગધારપરિવ્વઙ્ગં લપ્સ્યન્તે બદ્ધાઃ સન્તઃ સર્વ્વદેશેષુ નાયિષ્યન્તે ચ કિઞ્ચાન્યદેશીયાનાં સમયોપસ્થિતિપર્ય્યન્તં યિરૂશાલમ્પુરં તૈઃ પદતલૈ ર્દલયિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","સૂર્ય્યચન્દ્રનક્ષત્રેષુ લક્ષણાદિ ભવિષ્યન્તિ, ભુવિ સર્વ્વદેશીયાનાં દુઃખં ચિન્તા ચ સિન્ધૌ વીચીનાં તર્જનં ગર્જનઞ્ચ ભવિષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ભૂભૌ ભાવિઘટનાં ચિન્તયિત્વા મનુજા ભિયામૃતકલ્પા ભવિષ્યન્તિ, યતો વ્યોમમણ્ડલે તેજસ્વિનો દોલાયમાના ભવિષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","તદા પરાક્રમેણા મહાતેજસા ચ મેઘારૂઢં મનુષ્યપુત્રમ્ આયાન્તં દ્રક્ષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","કિન્ત્વેતાસાં ઘટનાનામારમ્ભે સતિ યૂયં મસ્તકાન્યુત્તોલ્ય ઊર્દધ્વં દ્રક્ષ્યથ, યતો યુષ્માકં મુક્તેઃ કાલઃ સવિધો ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","તતસ્તેનૈતદૃષ્ટાન્તકથા કથિતા, પશ્યત ઉડુમ્બરાદિવૃક્ષાણાં ");
INSERT INTO sanguj_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","નવીનપત્રાણિ જાતાનીતિ દૃષ્ટ્વા નિદાવકાલ ઉપસ્થિત ઇતિ યથા યૂયં જ્ઞાતું શક્નુથ, ");
INSERT INTO sanguj_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","તથા સર્વ્વાસામાસાં ઘટનાનામ્ આરમ્ભે દૃષ્ટે સતીશ્વરસ્ય રાજત્વં નિકટમ્ ઇત્યપિ જ્ઞાસ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","યુષ્માનહં યથાર્થં વદામિ, વિદ્યમાનલોકાનામેષાં ગમનાત્ પૂર્વ્વમ્ એતાનિ ઘટિષ્યન્તે| ");
INSERT INTO sanguj_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","નભોભુવોર્લોપો ભવિષ્યતિ મમ વાક્ તુ કદાપિ લુપ્તા ન ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","અતએવ વિષમાશનેન પાનેન ચ સાંમારિકચિન્તાભિશ્ચ યુષ્માકં ચિત્તેષુ મત્તેષુ તદ્દિનમ્ અકસ્માદ્ યુષ્માન્ પ્રતિ યથા નોપતિષ્ઠતિ તદર્થં સ્વેષુ સાવધાનાસ્તિષ્ઠત| ");
INSERT INTO sanguj_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","પૃથિવીસ્થસર્વ્વલોકાન્ પ્રતિ તદ્દિનમ્ ઉન્માથ ઇવ ઉપસ્થાસ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","યથા યૂયમ્ એતદ્ભાવિઘટના ઉત્તર્ત્તું મનુજસુતસ્ય સમ્મુખે સંસ્થાતુઞ્ચ યોગ્યા ભવથ કારણાદસ્માત્ સાવધાનાઃ સન્તો નિરન્તરં પ્રાર્થયધ્વં| ");
INSERT INTO sanguj_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","અપરઞ્ચ સ દિવા મન્દિર ઉપદિશ્ય રાચૈ જૈતુનાદ્રિં ગત્વાતિષ્ઠત્| ");
INSERT INTO sanguj_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","તતઃ પ્રત્યૂષે લાકાસ્તત્કથાં શ્રોતું મન્દિરે તદન્તિકમ્ આગચ્છન્| ");
INSERT INTO sanguj_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","અપરઞ્ચ કિણ્વશૂન્યપૂપોત્સવસ્ય કાલ ઉપસ્થિતે ");
INSERT INTO sanguj_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","પ્રધાનયાજકા અધ્યાયકાશ્ચ યથા તં હન્તું શક્નુવન્તિ તથોપાયામ્ અચેષ્ટન્ત કિન્તુ લોકેભ્યો બિભ્યુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","એતસ્તિન્ સમયે દ્વાદશશિષ્યેષુ ગણિત ઈષ્કરિયોતીયરૂઢિમાન્ યો યિહૂદાસ્તસ્યાન્તઃકરણં શૈતાનાશ્રિતત્વાત્ ");
INSERT INTO sanguj_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","સ ગત્વા યથા યીશું તેષાં કરેષુ સમર્પયિતું શક્નોતિ તથા મન્ત્રણાં પ્રધાનયાજકૈઃ સેનાપતિભિશ્ચ સહ ચકાર| ");
INSERT INTO sanguj_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","તેન તે તુષ્ટાસ્તસ્મૈ મુદ્રાં દાતું પણં ચક્રુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","તતઃ સોઙ્ગીકૃત્ય યથા લોકાનામગોચરે તં પરકરેષુ સમર્પયિતું શક્નોતિ તથાવકાશં ચેષ્ટિતુમારેભે| ");
INSERT INTO sanguj_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","અથ કિણ્વશૂન્યપૂપોત્મવદિને, અર્થાત્ યસ્મિન્ દિને નિસ્તારોત્સવસ્ય મેષો હન્તવ્યસ્તસ્મિન્ દિને ");
INSERT INTO sanguj_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","યીશુઃ પિતરં યોહનઞ્ચાહૂય જગાદ, યુવાં ગત્વાસ્માકં ભોજનાર્થં નિસ્તારોત્સવસ્ય દ્રવ્યાણ્યાસાદયતં| ");
INSERT INTO sanguj_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","તદા તૌ પપ્રચ્છતુઃ કુચાસાદયાવો ભવતઃ કેચ્છા? ");
INSERT INTO sanguj_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","તદા સોવાદીત્, નગરે પ્રવિષ્ટે કશ્ચિજ્જલકુમ્ભમાદાય યુવાં સાક્ષાત્ કરિષ્યતિ સ યન્નિવેશનં પ્રવિશતિ યુવામપિ તન્નિવેશનં તત્પશ્ચાદિત્વા નિવેશનપતિમ્ ઇતિ વાક્યં વદતં, ");
INSERT INTO sanguj_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","યત્રાહં નિસ્તારોત્સવસ્ય ભોજ્યં શિષ્યૈઃ સાર્દ્ધં ભોક્તું શક્નોમિ સાતિથિશાલાा કુત્ર? કથામિમાં પ્રભુસ્ત્વાં પૃચ્છતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","તતઃ સ જનો દ્વિતીયપ્રકોષ્ઠીયમ્ એકં શસ્તં કોષ્ઠં દર્શયિષ્યતિ તત્ર ભોજ્યમાસાદયતં| ");
INSERT INTO sanguj_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","તતસ્તૌ ગત્વા તદ્વાક્યાનુસારેણ સર્વ્વં દૃષ્દ્વા તત્ર નિસ્તારોત્સવીયં ભોજ્યમાસાદયામાસતુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","અથ કાલ ઉપસ્થિતે યીશુ ર્દ્વાદશભિઃ પ્રેરિતૈઃ સહ ભોક્તુમુપવિશ્ય કથિતવાન્ ");
INSERT INTO sanguj_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","મમ દુઃખભોગાત્ પૂર્વ્વં યુભાભિઃ સહ નિસ્તારોત્સવસ્યૈતસ્ય ભોજ્યં ભોક્તું મયાતિવાઞ્છા કૃતા| ");
INSERT INTO sanguj_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","યુષ્માન્ વદામિ, યાવત્કાલમ્ ઈશ્વરરાજ્યે ભોજનં ન કરિષ્યે તાવત્કાલમ્ ઇદં ન ભોક્ષ્યે| ");
INSERT INTO sanguj_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","તદા સ પાનપાત્રમાદાય ઈશ્વરસ્ય ગુણાન્ કીર્ત્તયિત્વા તેભ્યો દત્વાવદત્, ઇદં ગૃહ્લીત યૂયં વિભજ્ય પિવત| ");
INSERT INTO sanguj_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","યુષ્માન્ વદામિ યાવત્કાલમ્ ઈશ્વરરાજત્વસ્ય સંસ્થાપનં ન ભવતિ તાવદ્ દ્રાક્ષાફલરસં ન પાસ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","તતઃ પૂપં ગૃહીત્વા ઈશ્વરગુણાન્ કીર્ત્તયિત્વા ભઙ્ક્તા તેભ્યો દત્વાવદત્, યુષ્મદર્થં સમર્પિતં યન્મમ વપુસ્તદિદં, એતત્ કર્મ્મ મમ સ્મરણાર્થં કુરુધ્વં| ");
INSERT INTO sanguj_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","અથ ભોજનાન્તે તાદૃશં પાત્રં ગૃહીત્વાવદત્, યુષ્મત્કૃતે પાતિતં યન્મમ રક્તં તેન નિર્ણીતનવનિયમરૂપં પાનપાત્રમિદં| ");
INSERT INTO sanguj_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","પશ્યત યો માં પરકરેષુ સમર્પયિષ્યતિ સ મયા સહ ભોજનાસન ઉપવિશતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","યથા નિરૂપિતમાસ્તે તદનુસારેણા મનુષ્યપુुત્રસ્ય ગતિ ર્ભવિષ્યતિ કિન્તુ યસ્તં પરકરેષુ સમર્પયિષ્યતિ તસ્ય સન્તાપો ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","તદા તેષાં કો જન એતત્ કર્મ્મ કરિષ્યતિ તત્ તે પરસ્પરં પ્રષ્ટુમારેભિરે| ");
INSERT INTO sanguj_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","અપરં તેષાં કો જનઃ શ્રેષ્ઠત્વેન ગણયિષ્યતે, અત્રાર્થે તેષાં વિવાદોભવત્| ");
INSERT INTO sanguj_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","અસ્માત્ કારણાત્ સોવદત્, અન્યદેશીયાનાં રાજાનઃ પ્રજાનામુપરિ પ્રભુત્વં કુર્વ્વન્તિ દારુણશાસનં કૃત્વાપિ તે ભૂપતિત્વેન વિખ્યાતા ભવન્તિ ચ| ");
INSERT INTO sanguj_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","કિન્તુ યુષ્માકં તથા ન ભવિષ્યતિ, યો યુષ્માકં શ્રેષ્ઠો ભવિષ્યતિ સ કનિષ્ઠવદ્ ભવતુ, યશ્ચ મુખ્યો ભવિષ્યતિ સ સેવકવદ્ભવતુ| ");
INSERT INTO sanguj_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","ભોજનોપવિષ્ટપરિચારકયોઃ કઃ શ્રેષ્ઠઃ? યો ભોજનાયોપવિશતિ સ કિં શ્રેષ્ઠો ન ભવતિ? કિન્તુ યુષ્માકં મધ્યેઽહં પરિચારકઇવાસ્મિ| ");
INSERT INTO sanguj_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","અપરઞ્ચ યુયં મમ પરીક્ષાકાલે પ્રથમમારભ્ય મયા સહ સ્થિતા ");
INSERT INTO sanguj_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","એતત્કારણાત્ પિત્રા યથા મદર્થં રાજ્યમેકં નિરૂપિતં તથાહમપિ યુષ્મદર્થં રાજ્યં નિરૂપયામિ| ");
INSERT INTO sanguj_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","તસ્માન્ મમ રાજ્યે ભોજનાસને ચ ભોજનપાને કરિષ્યધ્વે સિંહાસનેષૂપવિશ્ય ચેસ્રાયેલીયાનાં દ્વાદશવંશાનાં વિચારં કરિષ્યધ્વે| ");
INSERT INTO sanguj_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","અપરં પ્રભુરુવાચ, હે શિમોન્ પશ્ય તિતઉના ધાન્યાનીવ યુષ્માન્ શૈતાન્ ચાલયિતુમ્ ઐચ્છત્, ");
INSERT INTO sanguj_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","કિન્તુ તવ વિશ્વાસસ્ય લોપો યથા ન ભવતિ એતત્ ત્વદર્થં પ્રાર્થિતં મયા, ત્વન્મનસિ પરિવર્ત્તિતે ચ ભ્રાતૃણાં મનાંસિ સ્થિરીકુરુ| ");
INSERT INTO sanguj_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","તદા સોવદત્, હે પ્રભોહં ત્વયા સાર્દ્ધં કારાં મૃતિઞ્ચ યાતું મજ્જિતોસ્મિ| ");
INSERT INTO sanguj_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","તતઃ સ ઉવાચ, હે પિતર ત્વાં વદામિ, અદ્ય કુક્કુટરવાત્ પૂર્વ્વં ત્વં મત્પરિચયં વારત્રયમ્ અપહ્વોષ્યસે| ");
INSERT INTO sanguj_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","અપરં સ પપ્રચ્છ, યદા મુદ્રાસમ્પુટં ખાદ્યપાત્રં પાદુકાઞ્ચ વિના યુષ્માન્ પ્રાહિણવં તદા યુષ્માકં કસ્યાપિ ન્યૂનતાસીત્? તે પ્રોચુઃ કસ્યાપિ ન| ");
INSERT INTO sanguj_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","તદા સોવદત્ કિન્ત્વિદાનીં મુદ્રાસમ્પુટં ખાદ્યપાત્રં વા યસ્યાસ્તિ તેન તદ્ગ્રહીતવ્યં, યસ્ય ચ કૃપાણોे નાસ્તિ તેન સ્વવસ્ત્રં વિક્રીય સ ક્રેતવ્યઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","યતો યુષ્માનહં વદામિ, અપરાધિજનૈઃ સાર્દ્ધં ગણિતઃ સ ભવિષ્યતિ| ઇદં યચ્છાસ્ત્રીયં વચનં લિખિતમસ્તિ તન્મયિ ફલિષ્યતિ યતો મમ સમ્બન્ધીયં સર્વ્વં સેત્સ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","તદા તે પ્રોચુઃ પ્રભો પશ્ય ઇમૌ કૃપાણૌ| તતઃ સોવદદ્ એતૌ યથેષ્ટૌ| ");
INSERT INTO sanguj_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","અથ સ તસ્માદ્વહિ ર્ગત્વા સ્વાચારાનુસારેણ જૈતુનનામાદ્રિં જગામ શિષ્યાશ્ચ તત્પશ્ચાદ્ યયુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","તત્રોપસ્થાય સ તાનુવાચ, યથા પરીક્ષાયાં ન પતથ તદર્થં પ્રાર્થયધ્વં| ");
INSERT INTO sanguj_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","પશ્ચાત્ સ તસ્માદ્ એકશરક્ષેપાદ્ બહિ ર્ગત્વા જાનુની પાતયિત્વા એતત્ પ્રાર્થયાઞ્ચક્રે, ");
INSERT INTO sanguj_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","હે પિત ર્યદિ ભવાન્ સમ્મન્યતે તર્હિ કંસમેનં મમાન્તિકાદ્ દૂરય કિન્તુ મદિચ્છાનુરૂપં ન ત્વદિચ્છાનુરૂપં ભવતુ| ");
INSERT INTO sanguj_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","તદા તસ્મૈ શક્તિં દાતું સ્વર્ગીયદૂતો દર્શનં દદૌ| ");
INSERT INTO sanguj_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","પશ્ચાત્ સોત્યન્તં યાતનયા વ્યાકુલો ભૂત્વા પુનર્દૃઢં પ્રાર્થયાઞ્ચક્રે, તસ્માદ્ બૃહચ્છોણિતબિન્દવ ઇવ તસ્ય સ્વેદબિન્દવઃ પૃથિવ્યાં પતિતુમારેભિરે| ");
INSERT INTO sanguj_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","અથ પ્રાર્થનાત ઉત્થાય શિષ્યાણાં સમીપમેત્ય તાન્ મનોદુઃખિનો નિદ્રિતાન્ દૃષ્ટ્વાવદત્ ");
INSERT INTO sanguj_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","કુતો નિદ્રાથ? પરીક્ષાયામ્ અપતનાર્થં પ્રર્થયધ્વં| ");
INSERT INTO sanguj_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","એતત્કથાયાઃ કથનકાલે દ્વાદશશિષ્યાણાં મધ્યે ગણિતો યિહૂદાનામા જનતાસહિતસ્તેષામ્ અગ્રે ચલિત્વા યીશોશ્ચુમ્બનાર્થં તદન્તિકમ્ આયયૌ| ");
INSERT INTO sanguj_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","તદા યીશુરુવાચ, હે યિહૂદા કિં ચુમ્બનેન મનુષ્યપુત્રં પરકરેષુ સમર્પયસિ? ");
INSERT INTO sanguj_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","તદા યદ્યદ્ ઘટિષ્યતે તદનુમાય સઙ્ગિભિરુક્તં, હે પ્રભો વયં કિ ખઙ્ગેન ઘાતયિષ્યામઃ? ");
INSERT INTO sanguj_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","તત એકઃ કરવાલેનાહત્ય પ્રધાનયાજકસ્ય દાસસ્ય દક્ષિણં કર્ણં ચિચ્છેદ| ");
INSERT INTO sanguj_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","અધૂના નિવર્ત્તસ્વ ઇત્યુક્ત્વા યીશુસ્તસ્ય શ્રુતિં સ્પૃષ્ટ્વા સ્વસ્યં ચકાર| ");
INSERT INTO sanguj_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","પશ્ચાદ્ યીશુઃ સમીપસ્થાન્ પ્રધાનયાજકાન્ મન્દિરસ્ય સેનાપતીન્ પ્રાચીનાંશ્ચ જગાદ, યૂયં કૃપાણાન્ યષ્ટીંશ્ચ ગૃહીત્વા માં કિં ચોરં ધર્ત્તુમાયાતાઃ? ");
INSERT INTO sanguj_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","યદાહં યુષ્માભિઃ સહ પ્રતિદિનં મન્દિરેઽતિષ્ઠં તદા માં ધર્ત્તં ન પ્રવૃત્તાઃ, કિન્ત્વિદાનીં યુષ્માકં સમયોન્ધકારસ્ય ચાધિપત્યમસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","અથ તે તં ધૃત્વા મહાયાજકસ્ય નિવેશનં નિન્યુઃ| તતઃ પિતરો દૂરે દૂરે પશ્ચાદિત્વા ");
INSERT INTO sanguj_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","બૃહત્કોષ્ઠસ્ય મધ્યે યત્રાગ્નિં જ્વાલયિત્વા લોકાઃ સમેત્યોપવિષ્ટાસ્તત્ર તૈઃ સાર્દ્ધમ્ ઉપવિવેશ| ");
INSERT INTO sanguj_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","અથ વહ્નિસન્નિધૌ સમુપવેશકાલે કાચિદ્દાસી મનો નિવિશ્ય તં નિરીક્ષ્યાવદત્ પુમાનયં તસ્ય સઙ્ગેઽસ્થાત્| ");
INSERT INTO sanguj_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","કિન્તુ સ તદ્ અપહ્નુત્યાવાદીત્ હે નારિ તમહં ન પરિચિનોમિ| ");
INSERT INTO sanguj_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","ક્ષણાન્તરેઽન્યજનસ્તં દૃષ્ટ્વાબ્રવીત્ ત્વમપિ તેષાં નિકરસ્યૈકજનોસિ| પિતરઃ પ્રત્યુવાચ હે નર નાહમસ્મિ| ");
INSERT INTO sanguj_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","તતઃ સાર્દ્ધદણ્ડદ્વયાત્ પરં પુનરન્યો જનો નિશ્ચિત્ય બભાષે, એષ તસ્ય સઙ્ગીતિ સત્યં યતોયં ગાલીલીયો લોકઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","તદા પિતર ઉવાચ હે નર ત્વં યદ્ વદમિ તદહં બોદ્ધું ન શક્નોમિ, ઇતિ વાક્યે કથિતમાત્રે કુક્કુટો રુરાવ| ");
INSERT INTO sanguj_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","તદા પ્રભુણા વ્યાધુટ્ય પિતરે નિરીક્ષિતે કૃકવાકુરવાત્ પૂર્વ્વં માં ત્રિરપહ્નોષ્યસે ઇતિ પૂર્વ્વોક્તં તસ્ય વાક્યં પિતરઃ સ્મૃત્વા ");
INSERT INTO sanguj_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","બહિર્ગત્વા મહાખેદેન ચક્રન્દ| ");
INSERT INTO sanguj_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","તદા યૈ ર્યીશુર્ધૃતસ્તે તમુપહસ્ય પ્રહર્ત્તુમારેભિરે| ");
INSERT INTO sanguj_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","વસ્ત્રેણ તસ્ય દૃશૌ બદ્ધ્વા કપોલે ચપેટાઘાતં કૃત્વા પપ્રચ્છુઃ, કસ્તે કપોલે ચપેટાઘાતં કૃતવાન? ગણયિત્વા તદ્ વદ| ");
INSERT INTO sanguj_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","તદન્યત્ તદ્વિરુદ્ધં બહુનિન્દાવાક્યં વક્તુમારેભિરે| ");
INSERT INTO sanguj_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","અથ પ્રભાતે સતિ લોકપ્રાઞ્ચઃ પ્રધાનયાજકા અધ્યાપકાશ્ચ સભાં કૃત્વા મધ્યેસભં યીશુમાનીય પપ્રચ્છુઃ, ત્વમ્ અભિષિકતોસિ ન વાસ્માન્ વદ| ");
INSERT INTO sanguj_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","સ પ્રત્યુવાચ, મયા તસ્મિન્નુક્તેઽપિ યૂયં ન વિશ્વસિષ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","કસ્મિંશ્ચિદ્વાક્યે યુષ્માન્ પૃષ્ટેઽપિ માં ન તદુત્તરં વક્ષ્યથ ન માં ત્યક્ષ્યથ ચ| ");
INSERT INTO sanguj_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","કિન્ત્વિતઃ પરં મનુજસુતઃ સર્વ્વશક્તિમત ઈશ્વરસ્ય દક્ષિણે પાર્શ્વે સમુપવેક્ષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","તતસ્તે પપ્રચ્છુઃ, ર્તિહ ત્વમીશ્વરસ્ય પુત્રઃ? સ કથયામાસ, યૂયં યથાર્થં વદથ સ એવાહં| ");
INSERT INTO sanguj_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","તદા તે સર્વ્વે કથયામાસુઃ, ર્તિહ સાક્ષ્યેઽન્સસ્મિન્ અસ્માકં કિં પ્રયોજનં? અસ્ય સ્વમુખાદેવ સાક્ષ્યં પ્રાપ્તમ્| ");
INSERT INTO sanguj_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","તતઃ સભાસ્થાઃ સર્વ્વલોકા ઉત્થાય તં પીલાતસમ્મુખં નીત્વાપ્રોદ્ય વક્તુમારેભિરે, ");
INSERT INTO sanguj_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","સ્વમભિષિક્તં રાજાનં વદન્તં કૈમરરાજાય કરદાનં નિષેધન્તં રાજ્યવિપર્ય્યયં કુર્ત્તું પ્રવર્ત્તમાનમ્ એન પ્રાપ્તા વયં| ");
INSERT INTO sanguj_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","તદા પીલાતસ્તં પૃષ્ટવાન્ ત્વં કિં યિહૂદીયાનાં રાજા? સ પ્રત્યુવાચ ત્વં સત્યમુક્તવાન્| ");
INSERT INTO sanguj_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","તદા પીલાતઃ પ્રધાનયાજકાદિલોકાન્ જગાદ્, અહમેતસ્ય કમપ્યપરાધં નાપ્તવાન્| ");
INSERT INTO sanguj_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","તતસ્તે પુનઃ સાહમિનો ભૂત્વાવદન્, એષ ગાલીલ એતત્સ્થાનપર્ય્યન્તે સર્વ્વસ્મિન્ યિહૂદાદેશે સર્વ્વાલ્લોકાનુપદિશ્ય કુપ્રવૃત્તિં ગ્રાહીતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","તદા પીલાતો ગાલીલપ્રદેશસ્ય નામ શ્રુત્વા પપ્રચ્છ, કિમયં ગાલીલીયો લોકઃ? ");
INSERT INTO sanguj_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","તતઃ સ ગાલીલ્પ્રદેશીયહેરોદ્રાજસ્ય તદા સ્થિતેસ્તસ્ય સમીપે યીશું પ્રેષયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","તદા હેરોદ્ યીશું વિલોક્ય સન્તુતોષ, યતઃ સ તસ્ય બહુવૃત્તાન્તશ્રવણાત્ તસ્ય કિઞિ्ચદાશ્ચર્ય્યકર્મ્મ પશ્યતિ ઇત્યાશાં કૃત્વા બહુકાલમારભ્ય તં દ્રષ્ટું પ્રયાસં કૃતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","તસ્માત્ તં બહુકથાઃ પપ્રચ્છ કિન્તુ સ તસ્ય કસ્યાપિ વાક્યસ્ય પ્રત્યુત્તરં નોવાચ| ");
INSERT INTO sanguj_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","અથ પ્રધાનયાજકા અધ્યાપકાશ્ચ પ્રોત્તિષ્ઠન્તઃ સાહસેન તમપવદિતું પ્રારેભિરે| ");
INSERT INTO sanguj_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","હેરોદ્ તસ્ય સેનાગણશ્ચ તમવજ્ઞાય ઉપહાસત્વેન રાજવસ્ત્રં પરિધાપ્ય પુનઃ પીલાતં પ્રતિ તં પ્રાહિણોત્| ");
INSERT INTO sanguj_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","પૂર્વ્વં હેરોદ્પીલાતયોઃ પરસ્પરં વૈરભાવ આસીત્ કિન્તુ તદ્દિને દ્વયો ર્મેલનં જાતમ્| ");
INSERT INTO sanguj_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","પશ્ચાત્ પીલાતઃ પ્રધાનયાજકાન્ શાસકાન્ લોકાંશ્ચ યુગપદાહૂય બભાષે, ");
INSERT INTO sanguj_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","રાજ્યવિપર્ય્યયકારકોયમ્ ઇત્યુક્ત્વા મનુષ્યમેનં મમ નિકટમાનૈષ્ટ કિન્તુ પશ્યત યુષ્માકં સમક્ષમ્ અસ્ય વિચારં કૃત્વાપિ પ્રોક્તાપવાદાનુરૂપેણાસ્ય કોપ્યપરાધઃ સપ્રમાણો ન જાતઃ, ");
INSERT INTO sanguj_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","યૂયઞ્ચ હેરોદઃ સન્નિધૌ પ્રેષિતા મયા તત્રાસ્ય કોપ્યપરાધસ્તેનાપિ ન પ્રાપ્તઃ| પશ્યતાનેન વધહેेતુકં કિમપિ નાપરાદ્ધં| ");
INSERT INTO sanguj_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","તસ્માદેનં તાડયિત્વા વિહાસ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","તત્રોત્સવે તેષામેકો મોચયિતવ્યઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ઇતિ હેતોસ્તે પ્રોચ્ચૈરેકદા પ્રોચુઃ, એનં દૂરીકૃત્ય બરબ્બાનામાનં મોચય| ");
INSERT INTO sanguj_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","સ બરબ્બા નગર ઉપપ્લવવધાપરાધાભ્યાં કારાયાં બદ્ધ આસીત્| ");
INSERT INTO sanguj_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","કિન્તુ પીલાતો યીશું મોચયિતું વાઞ્છન્ પુનસ્તાનુવાચ| ");
INSERT INTO sanguj_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","તથાપ્યેનં ક્રુશે વ્યધ ક્રુશે વ્યધેતિ વદન્તસ્તે રુરુવુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","તતઃ સ તૃતીયવારં જગાદ કુતઃ? સ કિં કર્મ્મ કૃતવાન્? નાહમસ્ય કમપિ વધાપરાધં પ્રાપ્તઃ કેવલં તાડયિત્વામું ત્યજામિ| ");
INSERT INTO sanguj_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","તથાપિ તે પુનરેનં ક્રુશે વ્યધ ઇત્યુક્ત્વા પ્રોચ્ચૈર્દૃઢં પ્રાર્થયાઞ્ચક્રિરે; ");
INSERT INTO sanguj_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","તતઃ પ્રધાનયાજકાદીનાં કલરવે પ્રબલે સતિ તેષાં પ્રાર્થનારૂપં કર્ત્તું પીલાત આદિદેશ| ");
INSERT INTO sanguj_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","રાજદ્રોહવધયોરપરાધેન કારાસ્થં યં જનં તે યયાચિરે તં મોચયિત્વા યીશું તેષામિચ્છાયાં સમાર્પયત્| ");
INSERT INTO sanguj_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","અથ તે યીશું ગૃહીત્વા યાન્તિ, એતર્હિ ગ્રામાદાગતં શિમોનનામાનં કુરીણીયં જનં ધૃત્વા યીશોઃ પશ્ચાન્નેતું તસ્ય સ્કન્ધે ક્રુશમર્પયામાસુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","તતો લોाકારણ્યમધ્યે બહુસ્ત્રિયો રુદત્યો વિલપન્ત્યશ્ચ યીશોઃ પશ્ચાદ્ યયુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","કિન્તુ સ વ્યાઘુટ્ય તા ઉવાચ, હે યિરૂશાલમો નાર્ય્યો યુયં મદર્થં ન રુદિત્વા સ્વાર્થં સ્વાપત્યાર્થઞ્ચ રુદિતિ; ");
INSERT INTO sanguj_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","પશ્યત યઃ કદાપિ ગર્ભવત્યો નાભવન્ સ્તન્યઞ્ચ નાપાયયન્ તાદૃશી ર્વન્ધ્યા યદા ધન્યા વક્ષ્યન્તિ સ કાલ આયાતિ| ");
INSERT INTO sanguj_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","તદા હે શૈલા અસ્માકમુપરિ પતત, હે ઉપશૈલા અસ્માનાચ્છાદયત કથામીદૃશીં લોકા વક્ષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","યતઃ સતેજસિ શાખિનિ ચેદેતદ્ ઘટતે તર્હિ શુષ્કશાખિનિ કિં ન ઘટિષ્યતે? ");
INSERT INTO sanguj_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","તદા તે હન્તું દ્વાવપરાધિનૌ તેન સાર્દ્ધં નિન્યુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","અપરં શિરઃકપાલનામકસ્થાનં પ્રાપ્ય તં ક્રુશે વિવિધુઃ; તદ્દ્વયોરપરાધિનોરેકં તસ્ય દક્ષિણો તદન્યં વામે ક્રુશે વિવિધુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","તદા યીશુરકથયત્, હે પિતરેતાન્ ક્ષમસ્વ યત એતે યત્ કર્મ્મ કુર્વ્વન્તિ તન્ ન વિદુઃ; પશ્ચાત્તે ગુટિકાપાતં કૃત્વા તસ્ય વસ્ત્રાણિ વિભજ્ય જગૃહુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","તત્ર લોકસંઘસ્તિષ્ઠન્ દદર્શ; તે તેષાં શાસકાશ્ચ તમુપહસ્ય જગદુઃ, એષ ઇતરાન્ રક્ષિતવાન્ યદીશ્વરેણાભિરુચિતો ઽભિષિક્તસ્ત્રાતા ભવતિ તર્હિ સ્વમધુના રક્ષતુ| ");
INSERT INTO sanguj_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","તદન્યઃ સેનાગણા એત્ય તસ્મૈ અમ્લરસં દત્વા પરિહસ્ય પ્રોવાચ, ");
INSERT INTO sanguj_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ચેત્ત્વં યિહૂદીયાનાં રાજાસિ તર્હિ સ્વં રક્ષ| ");
INSERT INTO sanguj_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","યિહૂદીયાનાં રાજેતિ વાક્યં યૂનાનીયરોમીયેબ્રીયાક્ષરૈ ર્લિખિતં તચ્છિરસ ઊર્દ્ધ્વેઽસ્થાપ્યત| ");
INSERT INTO sanguj_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","તદોભયપાર્શ્વયો ર્વિદ્ધૌ યાવપરાધિનૌ તયોરેકસ્તં વિનિન્દ્ય બભાષે, ચેત્ત્વમ્ અભિષિક્તોસિ તર્હિ સ્વમાવાઞ્ચ રક્ષ| ");
INSERT INTO sanguj_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","કિન્ત્વન્યસ્તં તર્જયિત્વાવદત્, ઈશ્વરાત્તવ કિઞ્ચિદપિ ભયં નાસ્તિ કિં? ત્વમપિ સમાનદણ્ડોસિ, ");
INSERT INTO sanguj_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","યોગ્યપાત્રે આવાં સ્વસ્વકર્મ્મણાં સમુચિતફલં પ્રાપ્નુવઃ કિન્ત્વનેન કિમપિ નાપરાદ્ધં| ");
INSERT INTO sanguj_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","અથ સ યીશું જગાદ હે પ્રભે ભવાન્ સ્વરાજ્યપ્રવેશકાલે માં સ્મરતુ| ");
INSERT INTO sanguj_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","તદા યીશુઃ કથિતવાન્ ત્વાં યથાર્થં વદામિ ત્વમદ્યૈવ મયા સાર્દ્ધં પરલોકસ્ય સુખસ્થાનં પ્રાપ્સ્યસિ| ");
INSERT INTO sanguj_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","અપરઞ્ચ દ્વિતીયયામાત્ તૃતીયયામપર્ય્યન્તં રવેસ્તેજસોન્તર્હિતત્વાત્ સર્વ્વદેશોઽન્ધકારેણાવૃતો ");
INSERT INTO sanguj_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","મન્દિરસ્ય યવનિકા ચ છિદ્યમાના દ્વિધા બભૂવ| ");
INSERT INTO sanguj_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","તતો યીશુરુચ્ચૈરુવાચ, હે પિત ર્મમાત્માનં તવ કરે સમર્પયે, ઇત્યુક્ત્વા સ પ્રાણાન્ જહૌ| ");
INSERT INTO sanguj_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","તદૈતા ઘટના દૃષ્ટ્વા શતસેનાપતિરીશ્વરં ધન્યમુક્ત્વા કથિતવાન્ અયં નિતાન્તં સાધુમનુષ્ય આસીત્| ");
INSERT INTO sanguj_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","અથ યાવન્તો લોકા દ્રષ્ટુમ્ આગતાસ્તે તા ઘટના દૃષ્ટ્વા વક્ષઃસુ કરાઘાતં કૃત્વા વ્યાચુટ્ય ગતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","યીશો ર્જ્ઞાતયો યા યા યોષિતશ્ચ ગાલીલસ્તેન સાર્દ્ધમાયાતાસ્તા અપિ દૂરે સ્થિત્વા તત્ સર્વ્વં દદૃશુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","તદા યિહૂદીયાનાં મન્ત્રણાં ક્રિયાઞ્ચાસમ્મન્યમાન ઈશ્વરસ્ય રાજત્વમ્ અપેક્ષમાણો ");
INSERT INTO sanguj_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","યિહૂદિદેશીયો ઽરિમથીયનગરીયો યૂષફ્નામા મન્ત્રી ભદ્રો ધાર્મ્મિકશ્ચ પુમાન્ ");
INSERT INTO sanguj_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","પીલાતાન્તિકં ગત્વા યીશો ર્દેહં યયાચે| ");
INSERT INTO sanguj_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","પશ્ચાદ્ વપુરવરોહ્ય વાસસા સંવેષ્ટ્ય યત્ર કોપિ માનુષો નાસ્થાપ્યત તસ્મિન્ શૈલે સ્વાતે શ્મશાને તદસ્થાપયત્| ");
INSERT INTO sanguj_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","તદ્દિનમાયોજનીયં દિનં વિશ્રામવારશ્ચ સમીપઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","અપરં યીશુના સાર્દ્ધં ગાલીલ આગતા યોષિતઃ પશ્ચાદિત્વા શ્મશાને તત્ર યથા વપુઃ સ્થાપિતં તચ્ચ દૃષ્ટ્વા ");
INSERT INTO sanguj_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","વ્યાઘુટ્ય સુગન્ધિદ્રવ્યતૈલાનિ કૃત્વા વિધિવદ્ વિશ્રામવારે વિશ્રામં ચક્રુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","અથ સપ્તાહપ્રથમદિનેઽતિપ્રત્યૂષે તા યોષિતઃ સમ્પાદિતં સુગન્ધિદ્રવ્યં ગૃહીત્વા તદન્યાભિઃ કિયતીભિઃ સ્ત્રીભિઃ સહ શ્મશાનં યયુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","કિન્તુ શ્મશાનદ્વારાત્ પાષાણમપસારિતં દૃષ્ટ્વા ");
INSERT INTO sanguj_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","તાઃ પ્રવિશ્ય પ્રભો ર્દેહમપ્રાપ્ય ");
INSERT INTO sanguj_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","વ્યાકુલા ભવન્તિ એતર્હિ તેજોમયવસ્ત્રાન્વિતૌ દ્વૌ પુરુષૌ તાસાં સમીપે સમુપસ્થિતૌ ");
INSERT INTO sanguj_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","તસ્માત્તાઃ શઙ્કાયુક્તા ભૂમાવધોમુખ્યસ્યસ્થુઃ| તદા તૌ તા ઊચતુ ર્મૃતાનાં મધ્યે જીવન્તં કુતો મૃગયથ? ");
INSERT INTO sanguj_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","સોત્ર નાસ્તિ સ ઉદસ્થાત્| ");
INSERT INTO sanguj_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","પાપિનાં કરેષુ સમર્પિતેન ક્રુશે હતેન ચ મનુષ્યપુત્રેણ તૃતીયદિવસે શ્મશાનાદુત્થાતવ્યમ્ ઇતિ કથાં સ ગલીલિ તિષ્ઠન્ યુષ્મભ્યં કથિતવાન્ તાં સ્મરત| ");
INSERT INTO sanguj_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","તદા તસ્ય સા કથા તાસાં મનઃસુ જાતા| ");
INSERT INTO sanguj_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","અનન્તરં શ્મશાનાદ્ ગત્વા તા એકાદશશિષ્યાદિભ્યઃ સર્વ્વેભ્યસ્તાં વાર્ત્તાં કથયામાસુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","મગ્દલીનીમરિયમ્, યોહના, યાકૂબો માતા મરિયમ્ તદન્યાઃ સઙ્ગિન્યો યોષિતશ્ચ પ્રેરિતેભ્ય એતાઃ સર્વ્વા વાર્ત્તાઃ કથયામાસુઃ ");
INSERT INTO sanguj_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","કિન્તુ તાસાં કથામ્ અનર્થકાખ્યાનમાત્રં બુદ્ધ્વા કોપિ ન પ્રત્યૈત્| ");
INSERT INTO sanguj_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","તદા પિતર ઉત્થાય શ્મશાનાન્તિકં દધાવ, તત્ર ચ પ્રહ્વો ભૂત્વા પાર્શ્વૈકસ્થાપિતં કેવલં વસ્ત્રં દદર્શ; તસ્માદાશ્ચર્ય્યં મન્યમાનો યદઘટત તન્મનસિ વિચારયન્ પ્રતસ્થે| ");
INSERT INTO sanguj_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","તસ્મિન્નેવ દિને દ્વૌ શિય્યૌ યિરૂશાલમશ્ચતુષ્ક્રોશાન્તરિતમ્ ઇમ્માયુગ્રામં ગચ્છન્તૌ ");
INSERT INTO sanguj_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","તાસાં ઘટનાનાં કથામકથયતાં ");
INSERT INTO sanguj_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","તયોરાલાપવિચારયોઃ કાલે યીશુરાગત્ય તાભ્યાં સહ જગામ ");
INSERT INTO sanguj_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","કિન્તુ યથા તૌ તં ન પરિચિનુતસ્તદર્થં તયો ર્દૃષ્ટિઃ સંરુદ્ધા| ");
INSERT INTO sanguj_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","સ તૌ પૃષ્ટવાન્ યુવાં વિષણ્ણૌ કિં વિચારયન્તૌ ગચ્છથઃ? ");
INSERT INTO sanguj_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","તતસ્તયોઃ ક્લિયપાનામા પ્રત્યુવાચ યિરૂશાલમપુરેઽધુના યાન્યઘટન્ત ત્વં કેવલવિદેશી કિં તદ્વૃત્તાન્તં ન જાનાસિ? ");
INSERT INTO sanguj_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","સ પપ્રચ્છ કા ઘટનાઃ? તદા તૌ વક્તુમારેભાતે યીશુનામા યો નાસરતીયો ભવિષ્યદ્વાદી ઈશ્વરસ્ય માનુષાણાઞ્ચ સાક્ષાત્ વાક્યે કર્મ્મણિ ચ શક્તિમાનાસીત્ ");
INSERT INTO sanguj_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","તમ્ અસ્માકં પ્રધાનયાજકા વિચારકાશ્ચ કેનાપિ પ્રકારેણ ક્રુશે વિદ્ધ્વા તસ્ય પ્રાણાનનાશયન્ તદીયા ઘટનાઃ; ");
INSERT INTO sanguj_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","કિન્તુ ય ઇસ્રાયેલીયલોકાન્ ઉદ્ધારયિષ્યતિ સ એવાયમ્ ઇત્યાશાસ્માભિઃ કૃતા| તદ્યથા તથાસ્તુ તસ્યા ઘટનાયા અદ્ય દિનત્રયં ગતં| ");
INSERT INTO sanguj_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","અધિકન્ત્વસ્માકં સઙ્ગિનીનાં કિયત્સ્ત્રીણાં મુખેભ્યોઽસમ્ભવવાક્યમિદં શ્રુતં; ");
INSERT INTO sanguj_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","તાઃ પ્રત્યૂષે શ્મશાનં ગત્વા તત્ર તસ્ય દેહમ્ અપ્રાપ્ય વ્યાઘુટ્યેત્વા પ્રોક્તવત્યઃ સ્વર્ગીસદૂતૌ દૃષ્ટાવસ્માભિસ્તૌ ચાવાદિષ્ટાં સ જીવિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","તતોસ્માકં કૈશ્ચિત્ શ્મશાનમગમ્યત તેઽપિ સ્ત્રીણાં વાક્યાનુરૂપં દૃષ્ટવન્તઃ કિન્તુ તં નાપશ્યન્| ");
INSERT INTO sanguj_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","તદા સ તાવુવાચ, હે અબોધૌ હે ભવિષ્યદ્વાદિભિરુક્તવાક્યં પ્રત્યેતું વિલમ્બમાનૌ; ");
INSERT INTO sanguj_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","એતત્સર્વ્વદુઃખં ભુક્ત્વા સ્વભૂતિપ્રાપ્તિઃ કિં ખ્રીષ્ટસ્ય ન ન્યાય્યા? ");
INSERT INTO sanguj_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","તતઃ સ મૂસાગ્રન્થમારભ્ય સર્વ્વભવિષ્યદ્વાદિનાં સર્વ્વશાસ્ત્રે સ્વસ્મિન્ લિખિતાખ્યાનાભિપ્રાયં બોધયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","અથ ગમ્યગ્રામાભ્યર્ણં પ્રાપ્ય તેનાગ્રે ગમનલક્ષણે દર્શિતે ");
INSERT INTO sanguj_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","તૌ સાધયિત્વાવદતાં સહાવાભ્યાં તિષ્ઠ દિને ગતે સતિ રાત્રિરભૂત્; તતઃ સ તાભ્યાં સાર્દ્ધં સ્થાતું ગૃહં યયૌ| ");
INSERT INTO sanguj_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","પશ્ચાદ્ભોજનોપવેશકાલે સ પૂપં ગૃહીત્વા ઈશ્વરગુણાન્ જગાદ તઞ્ચ ભંક્ત્વા તાભ્યાં દદૌ| ");
INSERT INTO sanguj_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","તદા તયો ર્દૃષ્ટૌ પ્રસન્નાયાં તં પ્રત્યભિજ્ઞતુઃ કિન્તુ સ તયોઃ સાક્ષાદન્તર્દધે| ");
INSERT INTO sanguj_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","તતસ્તૌ મિથોભિધાતુમ્ આરબ્ધવન્તૌ ગમનકાલે યદા કથામકથયત્ શાસ્ત્રાર્થઞ્ચબોધયત્ તદાવયો ર્બુદ્ધિઃ કિં ન પ્રાજ્વલત્? ");
INSERT INTO sanguj_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","તૌ તત્ક્ષણાદુત્થાય યિરૂશાલમપુરં પ્રત્યાયયતુઃ, તત્સ્થાને શિષ્યાણામ્ એકાદશાનાં સઙ્ગિનાઞ્ચ દર્શનં જાતં| ");
INSERT INTO sanguj_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","તે પ્રોચુઃ પ્રભુરુદતિષ્ઠદ્ ઇતિ સત્યં શિમોને દર્શનમદાચ્ચ| ");
INSERT INTO sanguj_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","તતઃ પથઃ સર્વ્વઘટનાયાઃ પૂપભઞ્જનેન તત્પરિચયસ્ય ચ સર્વ્વવૃત્તાન્તં તૌ વક્તુમારેભાતે| ");
INSERT INTO sanguj_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ઇત્થં તે પરસ્પરં વદન્તિ તત્કાલે યીશુઃ સ્વયં તેષાં મધ્ય પ્રોત્થય યુષ્માકં કલ્યાણં ભૂયાદ્ ઇત્યુવાચ, ");
INSERT INTO sanguj_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","કિન્તુ ભૂતં પશ્યામ ઇત્યનુમાય તે સમુદ્વિવિજિરે ત્રેષુશ્ચ| ");
INSERT INTO sanguj_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","સ ઉવાચ, કુતો દુઃખિતા ભવથ? યુષ્માકં મનઃસુ સન્દેહ ઉદેતિ ચ કુતઃ? ");
INSERT INTO sanguj_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","એષોહં, મમ કરૌ પશ્યત વરં સ્પૃષ્ટ્વા પશ્યત, મમ યાદૃશાનિ પશ્યથ તાદૃશાનિ ભૂતસ્ય માંસાસ્થીનિ ન સન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ઇત્યુક્ત્વા સ હસ્તપાદાન્ દર્શયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","તેઽસમ્ભવં જ્ઞાત્વા સાનન્દા ન પ્રત્યયન્| તતઃ સ તાન્ પપ્રચ્છ, અત્ર યુષ્માકં સમીપે ખાદ્યં કિઞ્ચિદસ્તિ? ");
INSERT INTO sanguj_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","તતસ્તે કિયદ્દગ્ધમત્સ્યં મધુ ચ દદુઃ ");
INSERT INTO sanguj_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","સ તદાદાય તેષાં સાક્ષાદ્ બુભુજે ");
INSERT INTO sanguj_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","કથયામાસ ચ મૂસાવ્યવસ્થાયાં ભવિષ્યદ્વાદિનાં ગ્રન્થેષુ ગીતપુસ્તકે ચ મયિ યાનિ સર્વ્વાણિ વચનાનિ લિખિતાનિ તદનુરૂપાણિ ઘટિષ્યન્તે યુષ્માભિઃ સાર્દ્ધં સ્થિત્વાહં યદેતદ્વાક્યમ્ અવદં તદિદાનીં પ્રત્યક્ષમભૂત્| ");
INSERT INTO sanguj_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","અથ તેભ્યઃ શાસ્ત્રબોધાધિકારં દત્વાવદત્, ");
INSERT INTO sanguj_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ખ્રીષ્ટેનેત્થં મૃતિયાતના ભોક્તવ્યા તૃતીયદિને ચ શ્મશાનાદુત્થાતવ્યઞ્ચેતિ લિપિરસ્તિ; ");
INSERT INTO sanguj_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","તન્નામ્ના યિરૂશાલમમારભ્ય સર્વ્વદેશે મનઃપરાવર્ત્તનસ્ય પાપમોચનસ્ય ચ સુસંવાદઃ પ્રચારયિતવ્યઃ, ");
INSERT INTO sanguj_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","એષુ સર્વ્વેષુ યૂયં સાક્ષિણઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","અપરઞ્ચ પશ્યત પિત્રા યત્ પ્રતિજ્ઞાતં તત્ પ્રેષયિષ્યામિ, અતએવ યાવત્કાલં યૂયં સ્વર્ગીયાં શક્તિં ન પ્રાપ્સ્યથ તાવત્કાલં યિરૂશાલમ્નગરે તિષ્ઠત| ");
INSERT INTO sanguj_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","અથ સ તાન્ બૈથનીયાપર્ય્યન્તં નીત્વા હસ્તાવુત્તોલ્ય આશિષ વક્તુમારેભે ");
INSERT INTO sanguj_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","આશિષં વદન્નેવ ચ તેભ્યઃ પૃથગ્ ભૂત્વા સ્વર્ગાય નીતોઽભવત્| ");
INSERT INTO sanguj_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","તદા તે તં ભજમાના મહાનન્દેન યિરૂશાલમં પ્રત્યાજગ્મુઃ| ");
INSERT INTO sanguj_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","તતો નિરન્તરં મન્દિરે તિષ્ઠન્ત ઈશ્વરસ્ય પ્રશંસાં ધન્યવાદઞ્ચ કર્ત્તમ્ આરેભિરે| ઇતિ||");
INSERT INTO sanguj_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","આદૌ વાદ આસીત્ સ ચ વાદ ઈશ્વરેણ સાર્ધમાસીત્ સ વાદઃ સ્વયમીશ્વર એવ| ");
INSERT INTO sanguj_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","સ આદાવીશ્વરેણ સહાસીત્| ");
INSERT INTO sanguj_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","તેન સર્વ્વં વસ્તુ સસૃજે સર્વ્વેષુ સૃષ્ટવસ્તુષુ કિમપિ વસ્તુ તેનાસૃષ્ટં નાસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","સ જીવનસ્યાકારઃ, તચ્ચ જીવનં મનુષ્યાણાં જ્યોતિઃ ");
INSERT INTO sanguj_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","તજ્જ્યોતિરન્ધકારે પ્રચકાશે કિન્ત્વન્ધકારસ્તન્ન જગ્રાહ| ");
INSERT INTO sanguj_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","યોહન્ નામક એકો મનુજ ઈશ્વરેણ પ્રેષયાઞ્ચક્રે| ");
INSERT INTO sanguj_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","તદ્વારા યથા સર્વ્વે વિશ્વસન્તિ તદર્થં સ તજ્જ્યોતિષિ પ્રમાણં દાતું સાક્ષિસ્વરૂપો ભૂત્વાગમત્, ");
INSERT INTO sanguj_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","સ સ્વયં તજ્જ્યોતિ ર્ન કિન્તુ તજ્જ્યોતિષિ પ્રમાણં દાતુમાગમત્| ");
INSERT INTO sanguj_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","જગત્યાગત્ય યઃ સર્વ્વમનુજેભ્યો દીપ્તિં દદાતિ તદેવ સત્યજ્યોતિઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","સ યજ્જગદસૃજત્ તન્મદ્ય એવ સ આસીત્ કિન્તુ જગતો લોકાસ્તં નાજાનન્| ");
INSERT INTO sanguj_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","નિજાધિકારં સ આગચ્છત્ કિન્તુ પ્રજાસ્તં નાગૃહ્લન્| ");
INSERT INTO sanguj_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","તથાપિ યે યે તમગૃહ્લન્ અર્થાત્ તસ્ય નામ્નિ વ્યશ્વસન્ તેભ્ય ઈશ્વરસ્ય પુત્રા ભવિતુમ્ અધિકારમ્ અદદાત્| ");
INSERT INTO sanguj_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","તેષાં જનિઃ શોણિતાન્ન શારીરિકાભિલાષાન્ન માનવાનામિચ્છાતો ન કિન્ત્વીશ્વરાદભવત્| ");
INSERT INTO sanguj_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","સ વાદો મનુષ્યરૂપેણાવતીર્ય્ય સત્યતાનુગ્રહાભ્યાં પરિપૂર્ણઃ સન્ સાર્ધમ્ અસ્માભિ ર્ન્યવસત્ તતઃ પિતુરદ્વિતીયપુત્રસ્ય યોગ્યો યો મહિમા તં મહિમાનં તસ્યાપશ્યામ| ");
INSERT INTO sanguj_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","તતો યોહનપિ પ્રચાર્ય્ય સાક્ષ્યમિદં દત્તવાન્ યો મમ પશ્ચાદ્ આગમિષ્યતિ સ મત્તો ગુરુતરઃ; યતો મત્પૂર્વ્વં સ વિદ્યમાન આસીત્; યદર્થમ્ અહં સાક્ષ્યમિદમ્ અદાં સ એષઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","અપરઞ્ચ તસ્ય પૂર્ણતાયા વયં સર્વ્વે ક્રમશઃ ક્રમશોનુગ્રહં પ્રાપ્તાઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","મૂસાદ્વારા વ્યવસ્થા દત્તા કિન્ત્વનુગ્રહઃ સત્યત્વઞ્ચ યીશુખ્રીષ્ટદ્વારા સમુપાતિષ્ઠતાં| ");
INSERT INTO sanguj_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","કોપિ મનુજ ઈશ્વરં કદાપિ નાપશ્યત્ કિન્તુ પિતુઃ ક્રોડસ્થોઽદ્વિતીયઃ પુત્રસ્તં પ્રકાશયત્| ");
INSERT INTO sanguj_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","ત્વં કઃ? ઇતિ વાક્યં પ્રેષ્ટું યદા યિહૂદીયલોકા યાજકાન્ લેવિલોકાંશ્ચ યિરૂશાલમો યોહનઃ સમીપે પ્રેષયામાસુઃ, ");
INSERT INTO sanguj_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","તદા સ સ્વીકૃતવાન્ નાપહ્નૂતવાન્ નાહમ્ અભિષિક્ત ઇત્યઙ્ગીકૃતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","તદા તેઽપૃચ્છન્ તર્હિ કો ભવાન્? કિં એલિયઃ? સોવદત્ ન; તતસ્તેઽપૃચ્છન્ તર્હિ ભવાન્ સ ભવિષ્યદ્વાદી? સોવદત્ નાહં સઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","તદા તેઽપૃચ્છન્ તર્હિ ભવાન્ કઃ? વયં ગત્વા પ્રેરકાન્ ત્વયિ કિં વક્ષ્યામઃ? સ્વસ્મિન્ કિં વદસિ? ");
INSERT INTO sanguj_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","તદા સોવદત્| પરમેશસ્ય પન્થાનં પરિષ્કુરુત સર્વ્વતઃ| ઇતીદં પ્રાન્તરે વાક્યં વદતઃ કસ્યચિદ્રવઃ| કથામિમાં યસ્મિન્ યિશયિયો ભવિષ્યદ્વાદી લિખિતવાન્ સોહમ્| ");
INSERT INTO sanguj_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","યે પ્રેષિતાસ્તે ફિરૂશિલોકાઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","તદા તેઽપૃચ્છન્ યદિ નાભિષિક્તોસિ એલિયોસિ ન સ ભવિષ્યદ્વાદ્યપિ નાસિ ચ, તર્હિ લોકાન્ મજ્જયસિ કુતઃ? ");
INSERT INTO sanguj_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","તતો યોહન્ પ્રત્યવોચત્, તોયેઽહં મજ્જયામીતિ સત્યં કિન્તુ યં યૂયં ન જાનીથ તાદૃશ એકો જનો યુષ્માકં મધ્ય ઉપતિષ્ઠતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","સ મત્પશ્ચાદ્ આગતોપિ મત્પૂર્વ્વં વર્ત્તમાન આસીત્ તસ્ય પાદુકાબન્ધનં મોચયિતુમપિ નાહં યોગ્યોસ્મિ| ");
INSERT INTO sanguj_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","યર્દ્દનનદ્યાઃ પારસ્થબૈથબારાયાં યસ્મિન્સ્થાને યોહનમજ્જયત્ તસ્મિન સ્થાને સર્વ્વમેતદ્ અઘટત| ");
INSERT INTO sanguj_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","પરેઽહનિ યોહન્ સ્વનિકટમાગચ્છન્તં યિશું વિલોક્ય પ્રાવોચત્ જગતઃ પાપમોચકમ્ ઈશ્વરસ્ય મેષશાવકં પશ્યત| ");
INSERT INTO sanguj_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","યો મમ પશ્ચાદાગમિષ્યતિ સ મત્તો ગુરુતરઃ, યતો હેતોર્મત્પૂર્વ્વં સોઽવર્ત્તત યસ્મિન્નહં કથામિમાં કથિતવાન્ સ એવાયં| ");
INSERT INTO sanguj_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","અપરં નાહમેનં પ્રત્યભિજ્ઞાતવાન્ કિન્તુ ઇસ્રાયેલ્લોકા એનં યથા પરિચિન્વન્તિ તદભિપ્રાયેણાહં જલે મજ્જયિતુમાગચ્છમ્| ");
INSERT INTO sanguj_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","પુનશ્ચ યોહનપરમેકં પ્રમાણં દત્વા કથિતવાન્ વિહાયસઃ કપોતવદ્ અવતરન્તમાત્માનમ્ અસ્યોપર્ય્યવતિષ્ઠન્તં ચ દૃષ્ટવાનહમ્| ");
INSERT INTO sanguj_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","નાહમેનં પ્રત્યભિજ્ઞાતવાન્ ઇતિ સત્યં કિન્તુ યો જલે મજ્જયિતું માં પ્રૈરયત્ સ એવેમાં કથામકથયત્ યસ્યોપર્ય્યાત્માનમ્ અવતરન્તમ્ અવતિષ્ઠન્તઞ્ચ દ્રક્ષયસિ સએવ પવિત્રે આત્મનિ મજ્જયિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","અવસ્તન્નિરીક્ષ્યાયમ્ ઈશ્વરસ્ય તનય ઇતિ પ્રમાણં દદામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","પરેઽહનિ યોહન્ દ્વાભ્યાં શિષ્યાભ્યાં સાર્દ્ધેં તિષ્ઠન્ ");
INSERT INTO sanguj_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","યિશું ગચ્છન્તં વિલોક્ય ગદિતવાન્, ઈશ્વરસ્ય મેષશાવકં પશ્યતં| ");
INSERT INTO sanguj_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ઇમાં કથાં શ્રુત્વા દ્વૌ શિષ્યૌ યીશોઃ પશ્ચાદ્ ઈયતુઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","તતો યીશુઃ પરાવૃત્ય તૌ પશ્ચાદ્ આગચ્છન્તૌ દૃષ્ટ્વા પૃષ્ટવાન્ યુવાં કિં ગવેશયથઃ? તાવપૃચ્છતાં હે રબ્બિ અર્થાત્ હે ગુરો ભવાન્ કુત્ર તિષ્ઠતિ? ");
INSERT INTO sanguj_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","તતઃ સોવાદિત્ એત્ય પશ્યતં| તતો દિવસસ્ય તૃતીયપ્રહરસ્ય ગતત્વાત્ તૌ તદ્દિનં તસ્ય સઙ્ગેઽસ્થાતાં| ");
INSERT INTO sanguj_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","યૌ દ્વૌ યોહનો વાક્યં શ્રુત્વા યિશોઃ પશ્ચાદ્ આગમતાં તયોઃ શિમોન્પિતરસ્ય ભ્રાતા આન્દ્રિયઃ ");
INSERT INTO sanguj_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","સ ઇત્વા પ્રથમં નિજસોદરં શિમોનં સાક્ષાત્પ્રાપ્ય કથિતવાન્ વયં ખ્રીષ્ટમ્ અર્થાત્ અભિષિક્તપુરુષં સાક્ષાત્કૃતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","પશ્ચાત્ સ તં યિશોઃ સમીપમ્ આનયત્| તદા યીશુસ્તં દૃષ્ટ્વાવદત્ ત્વં યૂનસઃ પુત્રઃ શિમોન્ કિન્તુ ત્વન્નામધેયં કૈફાઃ વા પિતરઃ અર્થાત્ પ્રસ્તરો ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","પરેઽહનિ યીશૌ ગાલીલં ગન્તું નિશ્ચિતચેતસિ સતિ ફિલિપનામાનં જનં સાક્ષાત્પ્રાપ્યાવોચત્ મમ પશ્ચાદ્ આગચ્છ| ");
INSERT INTO sanguj_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","બૈત્સૈદાનામ્નિ યસ્મિન્ ગ્રામે પિતરાન્દ્રિયયોર્વાસ આસીત્ તસ્મિન્ ગ્રામે તસ્ય ફિલિપસ્ય વસતિરાસીત્| ");
INSERT INTO sanguj_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","પશ્ચાત્ ફિલિપો નિથનેલં સાક્ષાત્પ્રાપ્યાવદત્ મૂસા વ્યવસ્થા ગ્રન્થે ભવિષ્યદ્વાદિનાં ગ્રન્થેષુ ચ યસ્યાખ્યાનં લિખિતમાસ્તે તં યૂષફઃ પુત્રં નાસરતીયં યીશું સાક્ષાદ્ અકાર્ષ્મ વયં| ");
INSERT INTO sanguj_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","તદા નિથનેલ્ કથિતવાન્ નાસરન્નગરાત કિં કશ્ચિદુત્તમ ઉત્પન્તું શક્નોતિ? તતઃ ફિલિપો ઽવોચત્ એત્ય પશ્ય| ");
INSERT INTO sanguj_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","અપરઞ્ચ યીશુઃ સ્વસ્ય સમીપં તમ્ આગચ્છન્તં દૃષ્ટ્વા વ્યાહૃતવાન્, પશ્યાયં નિષ્કપટઃ સત્ય ઇસ્રાયેલ્લોકઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","તતઃ સોવદદ્, ભવાન્ માં કથં પ્રત્યભિજાનાતિ? યીશુરવાદીત્ ફિલિપસ્ય આહ્વાનાત્ પૂર્વ્વં યદા ત્વમુડુમ્બરસ્ય તરોર્મૂલેઽસ્થાસ્તદા ત્વામદર્શમ્| ");
INSERT INTO sanguj_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","નિથનેલ્ અચકથત્, હે ગુરો ભવાન્ નિતાન્તમ્ ઈશ્વરસ્ય પુત્રોસિ, ભવાન્ ઇસ્રાયેલ્વંશસ્ય રાજા| ");
INSERT INTO sanguj_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","તતો યીશુ ર્વ્યાહરત્, ત્વામુડુમ્બરસ્ય પાદપસ્ય મૂલે દૃષ્ટવાનાહં મમૈતસ્માદ્વાક્યાત્ કિં ત્વં વ્યશ્વસીઃ? એતસ્માદપ્યાશ્ચર્ય્યાણિ કાર્ય્યાણિ દ્રક્ષ્યસિ| ");
INSERT INTO sanguj_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","અન્યચ્ચાવાદીદ્ યુષ્માનહં યથાર્થં વદામિ, ઇતઃ પરં મોચિતે મેઘદ્વારે તસ્માન્મનુજસૂનુના ઈશ્વરસ્ય દૂતગણમ્ અવરોહન્તમારોહન્તઞ્ચ દ્રક્ષ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","અનન્તરં ત્રુતીયદિવસે ગાલીલ્ પ્રદેશિયે કાન્નાનામ્નિ નગરે વિવાહ આસીત્ તત્ર ચ યીશોર્માતા તિષ્ઠત્| ");
INSERT INTO sanguj_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","તસ્મૈ વિવાહાય યીશુસ્તસ્ય શિષ્યાશ્ચ નિમન્ત્રિતા આસન્| ");
INSERT INTO sanguj_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","તદનન્તરં દ્રાક્ષારસસ્ય ન્યૂનત્વાદ્ યીશોર્માતા તમવદત્ એતેષાં દ્રાક્ષારસો નાસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","તદા સ તામવોચત્ હે નારિ મયા સહ તવ કિં કાર્ય્યં? મમ સમય ઇદાનીં નોપતિષ્ઠતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","તતસ્તસ્ય માતા દાસાનવોચદ્ અયં યદ્ વદતિ તદેવ કુરુત| ");
INSERT INTO sanguj_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","તસ્મિન્ સ્થાને યિહૂદીયાનાં શુચિત્વકરણવ્યવહારાનુસારેણાઢકૈકજલધરાણિ પાષાણમયાનિ ષડ્વૃહત્પાત્રાણિઆસન્| ");
INSERT INTO sanguj_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","તદા યીશુસ્તાન્ સર્વ્વકલશાન્ જલૈઃ પૂરયિતું તાનાજ્ઞાપયત્, તતસ્તે સર્વ્વાન્ કુમ્ભાનાકર્ણં જલૈઃ પર્ય્યપૂરયન્| ");
INSERT INTO sanguj_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","અથ તેભ્યઃ કિઞ્ચિદુત્તાર્ય્ય ભોજ્યાધિપાતેઃસમીપં નેતું સ તાનાદિશત્, તે તદનયન્| ");
INSERT INTO sanguj_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","અપરઞ્ચ તજ્જલં કથં દ્રાક્ષારસોઽભવત્ તજ્જલવાહકાદાસા જ્ઞાતું શક્તાઃ કિન્તુ તદ્ભોજ્યાધિપો જ્ઞાતું નાશક્નોત્ તદવલિહ્ય વરં સંમ્બોદ્યાવદત, ");
INSERT INTO sanguj_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","લોકાઃ પ્રથમં ઉત્તમદ્રાક્ષારસં દદતિ તષુ યથેષ્ટં પિતવત્સુ તસ્મા કિઞ્ચિદનુત્તમઞ્ચ દદતિ કિન્તુ ત્વમિદાનીં યાવત્ ઉત્તમદ્રાક્ષારસં સ્થાપયસિ| ");
INSERT INTO sanguj_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ઇત્થં યીશુર્ગાલીલપ્રદેશે આશ્ચર્ય્યકાર્મ્મ પ્રારમ્ભ નિજમહિમાનં પ્રાકાશયત્ તતઃ શિષ્યાસ્તસ્મિન્ વ્યશ્વસન્| ");
INSERT INTO sanguj_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","તતઃ પરમ્ સ નિજમાત્રુભ્રાત્રુસ્શિષ્યૈઃ સાર્દ્ધ્ં કફર્નાહૂમમ્ આગમત્ કિન્તુ તત્ર બહૂદિનાનિ આતિષ્ઠત્| ");
INSERT INTO sanguj_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","તદનન્તરં યિહૂદિયાનાં નિસ્તારોત્સવે નિકટમાગતે યીશુ ર્યિરૂશાલમ્ નગરમ્ આગચ્છત્| ");
INSERT INTO sanguj_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","તતો મન્દિરસ્ય મધ્યે ગોમેષપારાવતવિક્રયિણો વાણિજક્ષ્ચોપવિષ્ટાન્ વિલોક્ય ");
INSERT INTO sanguj_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","રજ્જુભિઃ કશાં નિર્મ્માય સર્વ્વગોમેષાદિભિઃ સાર્દ્ધં તાન્ મન્દિરાદ્ દૂરીકૃતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","વણિજાં મુદ્રાદિ વિકીર્ય્ય આસનાનિ ન્યૂબ્જીકૃત્ય પારાવતવિક્રયિભ્યોઽકથયદ્ અસ્માત્ સ્થાનાત્ સર્વાણ્યેતાનિ નયત, મમ પિતુગૃહં વાણિજ્યગૃહં મા કાર્ષ્ટ| ");
INSERT INTO sanguj_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","તસ્માત્ તન્મન્દિરાર્થ ઉદ્યોગો યસ્તુ સ ગ્રસતીવ મામ્| ઇમાં શાસ્ત્રીયલિપિં શિષ્યાઃસમસ્મરન્| ");
INSERT INTO sanguj_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","તતઃ પરમ્ યિહૂદીયલોકા યીષિમવદન્ તવમિદૃશકર્મ્મકરણાત્ કિં ચિહ્નમસ્માન્ દર્શયસિ? ");
INSERT INTO sanguj_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","તતો યીશુસ્તાનવોચદ્ યુષ્માભિરે તસ્મિન્ મન્દિરે નાશિતે દિનત્રયમધ્યેઽહં તદ્ ઉત્થાપયિષ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","તદા યિહૂદિયા વ્યાહાર્ષુઃ, એતસ્ય મન્દિરસ નિર્મ્માણેન ષટ્ચત્વારિંશદ્ વત્સરા ગતાઃ, ત્વં કિં દિનત્રયમધ્યે તદ્ ઉત્થાપયિષ્યસિ? ");
INSERT INTO sanguj_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","કિન્તુ સ નિજદેહરૂપમન્દિરે કથામિમાં કથિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","સ યદેતાદૃશં ગદિતવાન્ તચ્છિષ્યાઃ શ્મશાનાત્ તદીયોત્થાને સતિ સ્મૃત્વા ધર્મ્મગ્રન્થે યીશુનોક્તકથાયાં ચ વ્યશ્વસિષુઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","અનન્તરં નિસ્તારોત્સવસ્ય ભોજ્યસમયે યિરૂશાલમ્ નગરે તત્ક્રુતાશ્ચર્ય્યકર્મ્માણિ વિલોક્ય બહુભિસ્તસ્ય નામનિ વિશ્વસિતં| ");
INSERT INTO sanguj_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","કિન્તુ સ તેષાં કરેષુ સ્વં ન સમર્પયત્, યતઃ સ સર્વ્વાનવૈત્| ");
INSERT INTO sanguj_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","સ માનવેષુ કસ્યચિત્ પ્રમાણં નાપેક્ષત યતો મનુજાનાં મધ્યે યદ્યદસ્તિ તત્તત્ સોજાનાત્| ");
INSERT INTO sanguj_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","નિકદિમનામા યિહૂદીયાનામ્ અધિપતિઃ ફિરૂશી ક્ષણદાયાં ");
INSERT INTO sanguj_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","યીશૌરભ્યર્ણમ્ આવ્રજ્ય વ્યાહાર્ષીત્, હે ગુરો ભવાન્ ઈશ્વરાદ્ આગત્ એક ઉપદેષ્ટા, એતદ્ અસ્માભિર્જ્ઞાયતે; યતો ભવતા યાન્યાશ્ચર્ય્યકર્મ્માણિ ક્રિયન્તે પરમેશ્વરસ્ય સાહાય્યં વિના કેનાપિ તત્તત્કર્મ્માણિ કર્ત્તું ન શક્યન્તે| ");
INSERT INTO sanguj_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","તદા યીશુરુત્તરં દત્તવાન્ તવાહં યથાર્થતરં વ્યાહરામિ પુનર્જન્મનિ ન સતિ કોપિ માનવ ઈશ્વરસ્ય રાજ્યં દ્રષ્ટું ન શક્નોતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","તતો નિકદીમઃ પ્રત્યવોચત્ મનુજો વૃદ્ધો ભૂત્વા કથં જનિષ્યતે? સ કિં પુન ર્માતૃર્જઠરં પ્રવિશ્ય જનિતું શક્નોતિ? ");
INSERT INTO sanguj_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","યીશુરવાદીદ્ યથાર્થતરમ્ અહં કથયામિ મનુજે તોયાત્મભ્યાં પુન ર્ન જાતે સ ઈશ્વરસ્ય રાજ્યં પ્રવેષ્ટું ન શક્નોતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","માંસાદ્ યત્ જાયતે તન્ માંસમેવ તથાત્મનો યો જાયતે સ આત્મૈવ| ");
INSERT INTO sanguj_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","યુષ્માભિઃ પુન ર્જનિતવ્યં મમૈતસ્યાં કથાયામ્ આશ્ચર્યં મા મંસ્થાઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","સદાગતિર્યાં દિશમિચ્છતિ તસ્યામેવ દિશિ વાતિ, ત્વં તસ્ય સ્વનં શુણોષિ કિન્તુ સ કુત આયાતિ કુત્ર યાતિ વા કિમપિ ન જાનાસિ તદ્વાદ્ આત્મનઃ સકાશાત્ સર્વ્વેષાં મનુજાનાં જન્મ ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","તદા નિકદીમઃ પૃષ્ટવાન્ એતત્ કથં ભવિતું શક્નોતિ? ");
INSERT INTO sanguj_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","યીશુઃ પ્રત્યક્તવાન્ ત્વમિસ્રાયેલો ગુરુર્ભૂત્વાપિ કિમેતાં કથાં ન વેત્સિ? ");
INSERT INTO sanguj_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","તુભ્યં યથાર્થં કથયામિ, વયં યદ્ વિદ્મસ્તદ્ વચ્મઃ યંચ્ચ પશ્યામસ્તસ્યૈવ સાક્ષ્યં દદ્મઃ કિન્તુ યુષ્માભિરસ્માકં સાક્ષિત્વં ન ગૃહ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","એતસ્ય સંસારસ્ય કથાયાં કથિતાયાં યદિ યૂયં ન વિશ્વસિથ તર્હિ સ્વર્ગીયાયાં કથાયાં કથં વિશ્વસિષ્યથ? ");
INSERT INTO sanguj_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","યઃ સ્વર્ગેઽસ્તિ યં ચ સ્વર્ગાદ્ અવારોહત્ તં માનવતનયં વિના કોપિ સ્વર્ગં નારોહત્| ");
INSERT INTO sanguj_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","અપરઞ્ચ મૂસા યથા પ્રાન્તરે સર્પં પ્રોત્થાપિતવાન્ મનુષ્યપુત્રોઽપિ તથૈવોત્થાપિતવ્યઃ; ");
INSERT INTO sanguj_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","તસ્માદ્ યઃ કશ્ચિત્ તસ્મિન્ વિશ્વસિષ્યતિ સોઽવિનાશ્યઃ સન્ અનન્તાયુઃ પ્રાપ્સ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ઈશ્વર ઇત્થં જગદદયત યત્ સ્વમદ્વિતીયં તનયં પ્રાદદાત્ તતો યઃ કશ્ચિત્ તસ્મિન્ વિશ્વસિષ્યતિ સોઽવિનાશ્યઃ સન્ અનન્તાયુઃ પ્રાપ્સ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ઈશ્વરો જગતો લોકાન્ દણ્ડયિતું સ્વપુત્રં ન પ્રેષ્ય તાન્ પરિત્રાતું પ્રેષિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","અતએવ યઃ કશ્ચિત્ તસ્મિન્ વિશ્વસિતિ સ દણ્ડાર્હો ન ભવતિ કિન્તુ યઃ કશ્ચિત્ તસ્મિન્ ન વિશ્વસિતિ સ ઇદાનીમેવ દણ્ડાર્હો ભવતિ,યતઃ સ ઈશ્વરસ્યાદ્વિતીયપુત્રસ્ય નામનિ પ્રત્યયં ન કરોતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","જગતો મધ્યે જ્યોતિઃ પ્રાકાશત કિન્તુ મનુષ્યાણાં કર્મ્મણાં દૃષ્ટત્વાત્ તે જ્યોતિષોપિ તિમિરે પ્રીયન્તે એતદેવ દણ્ડસ્ય કારણાં ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","યઃ કુકર્મ્મ કરોતિ તસ્યાચારસ્ય દૃષ્ટત્વાત્ સ જ્યોતિરૄતીયિત્વા તન્નિકટં નાયાતિ; ");
INSERT INTO sanguj_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","કિન્તુ યઃ સત્કર્મ્મ કરોતિ તસ્ય સર્વ્વાણિ કર્મ્માણીશ્વરેણ કૃતાનીતિ સથા પ્રકાશતે તદભિપ્રાયેણ સ જ્યોતિષઃ સન્નિધિમ્ આયાતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","તતઃ પરમ્ યીશુઃ શિષ્યૈઃ સાર્દ્ધં યિહૂદીયદેશં ગત્વા તત્ર સ્થિત્વા મજ્જયિતુમ્ આરભત| ");
INSERT INTO sanguj_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","તદા શાલમ્ નગરસ્ય સમીપસ્થાયિનિ ઐનન્ ગ્રામે બહુતરતોયસ્થિતેસ્તત્ર યોહન્ અમજ્જયત્ તથા ચ લોકા આગત્ય તેન મજ્જિતા અભવન્| ");
INSERT INTO sanguj_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","તદા યોહન્ કારાયાં ન બદ્ધઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","અપરઞ્ચ શાચકર્મ્મણિ યોહાનઃ શિષ્યૈઃ સહ યિહૂદીયલોકાનાં વિવાદે જાતે, તે યોહનઃ સંન્નિધિં ગત્વાકથયન્, ");
INSERT INTO sanguj_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","હે ગુરો યર્દ્દનનદ્યાઃ પારે ભવતા સાર્દ્ધં ય આસીત્ યસ્મિંશ્ચ ભવાન્ સાક્ષ્યં પ્રદદાત્ પશ્યતુ સોપિ મજ્જયતિ સર્વ્વે તસ્ય સમીપં યાન્તિ ચ| ");
INSERT INTO sanguj_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","તદા યોહન્ પ્રત્યવોચદ્ ઈશ્વરેણ ન દત્તે કોપિ મનુજઃ કિમપિ પ્રાપ્તું ન શક્નોતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","અહં અભિષિક્તો ન ભવામિ કિન્તુ તદગ્રે પ્રેષિતોસ્મિ યામિમાં કથાં કથિતવાનાહં તત્ર યૂયં સર્વ્વે સાક્ષિણઃ સ્થ| ");
INSERT INTO sanguj_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","યો જનઃ કન્યાં લભતે સ એવ વરઃ કિન્તુ વરસ્ય સન્નિધૌ દણ્ડાયમાનં તસ્ય યન્મિત્રં તેન વરસ્ય શબ્દે શ્રુતેઽતીવાહ્લાદ્યતે મમાપિ તદ્વદ્ આનન્દસિદ્ધિર્જાતા| ");
INSERT INTO sanguj_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","તેન ક્રમશો વર્દ્ધિતવ્યં કિન્તુ મયા હ્સિતવ્યં| ");
INSERT INTO sanguj_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ય ઊર્ધ્વાદાગચ્છત્ સ સર્વ્વેષાં મુખ્યો યશ્ચ સંસારાદ્ ઉદપદ્યત સ સાંસારિકઃ સંસારીયાં કથાઞ્ચ કથયતિ યસ્તુ સ્વર્ગાદાગચ્છત્ સ સર્વ્વેષાં મુખ્યઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","સ યદપશ્યદશૃણોચ્ચ તસ્મિન્નેવ સાક્ષ્યં દદાતિ તથાપિ પ્રાયશઃ કશ્ચિત્ તસ્ય સાક્ષ્યં ન ગૃહ્લાતિ; ");
INSERT INTO sanguj_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","કિન્તુ યો ગૃહ્લાતિ સ ઈશ્વરસ્ય સત્યવાદિત્વં મુદ્રાઙ્ગિતં કરોતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ઈશ્વરેણ યઃ પ્રેરિતઃ સએવ ઈશ્વરીયકથાં કથયતિ યત ઈશ્વર આત્માનં તસ્મૈ અપરિમિતમ્ અદદાત્| ");
INSERT INTO sanguj_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","પિતા પુત્રે સ્નેહં કૃત્વા તસ્ય હસ્તે સર્વ્વાણિ સમર્પિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","યઃ કશ્ચિત્ પુત્રે વિશ્વસિતિ સ એવાનન્તમ્ પરમાયુઃ પ્રાપ્નોતિ કિન્તુ યઃ કશ્ચિત્ પુત્રે ન વિશ્વસિતિ સ પરમાયુષો દર્શનં ન પ્રાપ્નોતિ કિન્ત્વીશ્વરસ્ય કોપભાજનં ભૂત્વા તિષ્ઠતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","યીશુઃ સ્વયં નામજ્જયત્ કેવલં તસ્ય શિષ્યા અમજ્જયત્ કિન્તુ યોહનોઽધિકશિષ્યાન્ સ કરોતિ મજ્જયતિ ચ, ");
INSERT INTO sanguj_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ફિરૂશિન ઇમાં વાર્ત્તામશૃણ્વન્ ઇતિ પ્રભુરવગત્ય ");
INSERT INTO sanguj_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","યિહૂદીયદેશં વિહાય પુન ર્ગાલીલમ્ આગત્| ");
INSERT INTO sanguj_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","તતઃ શોમિરોણપ્રદેશસ્ય મદ્યેન તેન ગન્તવ્યે સતિ ");
INSERT INTO sanguj_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","યાકૂબ્ નિજપુત્રાય યૂષફે યાં ભૂમિમ્ અદદાત્ તત્સમીપસ્થાયિ શોમિરોણપ્રદેશસ્ય સુખાર્ નામ્ના વિખ્યાતસ્ય નગરસ્ય સન્નિધાવુપાસ્થાત્| ");
INSERT INTO sanguj_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","તત્ર યાકૂબઃ પ્રહિરાસીત્; તદા દ્વિતીયયામવેલાયાં જાતાયાં સ માર્ગે શ્રમાપન્નસ્તસ્ય પ્રહેઃ પાર્શ્વે ઉપાવિશત્| ");
INSERT INTO sanguj_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","એતર્હિ કાચિત્ શોમિરોણીયા યોષિત્ તોયોત્તોલનાર્થમ્ તત્રાગમત્ ");
INSERT INTO sanguj_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","તદા શિષ્યાઃ ખાદ્યદ્રવ્યાણિ ક્રેતું નગરમ્ અગચ્છન્| ");
INSERT INTO sanguj_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","યીશુઃ શોમિરોણીયાં તાં યોષિતમ્ વ્યાહાર્ષીત્ મહ્યં કિઞ્ચિત્ પાનીયં પાતું દેહિ| કિન્તુ શોમિરોણીયૈઃ સાકં યિહૂદીયલોકા ન વ્યવાહરન્ તસ્માદ્ધેતોઃ સાકથયત્ શોમિરોણીયા યોષિતદહં ત્વં યિહૂદીયોસિ કથં મત્તઃ પાનીયં પાતુમ્ ઇચ્છસિ? ");
INSERT INTO sanguj_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","તતો યીશુરવદદ્ ઈશ્વરસ્ય યદ્દાનં તત્કીદૃક્ પાનીયં પાતું મહ્યં દેહિ ય ઇત્થં ત્વાં યાચતે સ વા ક ઇતિ ચેદજ્ઞાસ્યથાસ્તર્હિ તમયાચિષ્યથાઃ સ ચ તુભ્યમમૃતં તોયમદાસ્યત્| ");
INSERT INTO sanguj_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","તદા સા સીમન્તિની ભાષિતવતિ, હે મહેચ્છ પ્રહિર્ગમ્ભીરો ભવતો નીરોત્તોલનપાત્રં નાસ્તી ચ તસ્માત્ તદમૃતં કીલાલં કુતઃ પ્રાપ્સ્યસિ? ");
INSERT INTO sanguj_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","યોસ્મભ્યમ્ ઇમમન્ધૂં દદૌ, યસ્ય ચ પરિજના ગોમેષાદયશ્ચ સર્વ્વેઽસ્ય પ્રહેઃ પાનીયં પપુરેતાદૃશો યોસ્માકં પૂર્વ્વપુરુષો યાકૂબ્ તસ્માદપિ ભવાન્ મહાન્ કિં? ");
INSERT INTO sanguj_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","તતો યીશુરકથયદ્ ઇદં પાનીયં સઃ પિવતિ સ પુનસ્તૃષાર્ત્તો ભવિષ્યતિ, ");
INSERT INTO sanguj_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","કિન્તુ મયા દત્તં પાનીયં યઃ પિવતિ સ પુનઃ કદાપિ તૃષાર્ત્તો ન ભવિષ્યતિ| મયા દત્તમ્ ઇદં તોયં તસ્યાન્તઃ પ્રસ્રવણરૂપં ભૂત્વા અનન્તાયુર્યાવત્ સ્રોષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","તદા સા વનિતાકથયત્ હે મહેચ્છ તર્હિ મમ પુનઃ પીપાસા યથા ન જાયતે તોયોત્તોલનાય યથાત્રાગમનં ન ભવતિ ચ તદર્થં મહ્યં તત્તોયં દેહી| ");
INSERT INTO sanguj_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","તતો યીશૂરવદદ્યાહિ તવ પતિમાહૂય સ્થાનેઽત્રાગચ્છ| ");
INSERT INTO sanguj_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","સા વામાવદત્ મમ પતિર્નાસ્તિ| યીશુરવદત્ મમ પતિર્નાસ્તીતિ વાક્યં ભદ્રમવોચઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","યતસ્તવ પઞ્ચ પતયોભવન્ અધુના તુ ત્વયા સાર્દ્ધં યસ્તિષ્ઠતિ સ તવ ભર્ત્તા ન વાક્યમિદં સત્યમવાદિઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","તદા સા મહિલા ગદિતવતિ હે મહેચ્છ ભવાન્ એકો ભવિષ્યદ્વાદીતિ બુદ્ધં મયા| ");
INSERT INTO sanguj_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","અસ્માકં પિતૃલોકા એતસ્મિન્ શિલોચ્ચયેઽભજન્ત, કિન્તુ ભવદ્ભિરુચ્યતે યિરૂશાલમ્ નગરે ભજનયોગ્યં સ્થાનમાસ્તે| ");
INSERT INTO sanguj_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","યીશુરવોચત્ હે યોષિત્ મમ વાક્યે વિશ્વસિહિ યદા યૂયં કેવલશૈલેઽસ્મિન્ વા યિરૂશાલમ્ નગરે પિતુર્ભજનં ન કરિષ્યધ્વે કાલ એતાદૃશ આયાતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","યૂયં યં ભજધ્વે તં ન જાનીથ, કિન્તુ વયં યં ભજામહે તં જાનીમહે, યતો યિહૂદીયલોકાનાં મધ્યાત્ પરિત્રાણં જાયતે| ");
INSERT INTO sanguj_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","કિન્તુ યદા સત્યભક્તા આત્મના સત્યરૂપેણ ચ પિતુર્ભજનં કરિષ્યન્તે સમય એતાદૃશ આયાતિ, વરમ્ ઇદાનીમપિ વિદ્યતે ; યત એતાદૃશો ભત્કાન્ પિતા ચેષ્ટતે| ");
INSERT INTO sanguj_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ઈશ્વર આત્મા; તતસ્તસ્ય યે ભક્તાસ્તૈઃ સ આત્મના સત્યરૂપેણ ચ ભજનીયઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","તદા સા મહિલાવાદીત્ ખ્રીષ્ટનામ્ના વિખ્યાતોઽભિષિક્તઃ પુરુષ આગમિષ્યતીતિ જાનામિ સ ચ સર્વ્વાઃ કથા અસ્માન્ જ્ઞાપયિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","તતો યીશુરવદત્ ત્વયા સાર્દ્ધં કથનં કરોમિ યોઽહમ્ અહમેવ સ પુરુષઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","એતસ્મિન્ સમયે શિષ્યા આગત્ય તથા સ્ત્રિયા સાર્દ્ધં તસ્ય કથોપકથને મહાશ્ચર્ય્યમ્ અમન્યન્ત તથાપિ ભવાન્ કિમિચ્છતિ? યદ્વા કિમર્થમ્ એતયા સાર્દ્ધં કથાં કથયતિ? ઇતિ કોપિ નાપૃચ્છત્| ");
INSERT INTO sanguj_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","તતઃ પરં સા નારી કલશં સ્થાપયિત્વા નગરમધ્યં ગત્વા લોકેભ્યોકથાયદ્ ");
INSERT INTO sanguj_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","અહં યદ્યત્ કર્મ્માકરવં તત્સર્વ્વં મહ્યમકથયદ્ એતાદૃશં માનવમેકમ્ આગત્ય પશ્યત રુ કિમ્ અભિષિક્તો ન ભવતિ ? ");
INSERT INTO sanguj_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","તતસ્તે નગરાદ્ બહિરાગત્ય તાતસ્ય સમીપમ્ આયન્| ");
INSERT INTO sanguj_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","એતર્હિ શિષ્યાઃ સાધયિત્વા તં વ્યાહાર્ષુઃ હે ગુરો ભવાન્ કિઞ્ચિદ્ ભૂક્તાં| ");
INSERT INTO sanguj_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","તતઃ સોવદદ્ યુષ્માભિર્યન્ન જ્ઞાયતે તાદૃશં ભક્ષ્યં મમાસ્તે| ");
INSERT INTO sanguj_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","તદા શિષ્યાઃ પરસ્પરં પ્રષ્ટુમ્ આરમ્ભન્ત, કિમસ્મૈ કોપિ કિમપિ ભક્ષ્યમાનીય દત્તવાન્? ");
INSERT INTO sanguj_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","યીશુરવોચત્ મત્પ્રેરકસ્યાભિમતાનુરૂપકરણં તસ્યૈવ કર્મ્મસિદ્ધિકારણઞ્ચ મમ ભક્ષ્યં| ");
INSERT INTO sanguj_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","માસચતુષ્ટયે જાતે શસ્યકર્ત્તનસમયો ભવિષ્યતીતિ વાક્યં યુષ્માભિઃ કિં નોદ્યતે? કિન્ત્વહં વદામિ, શિર ઉત્તોલ્ય ક્ષેત્રાણિ પ્રતિ નિરીક્ષ્ય પશ્યત, ઇદાનીં કર્ત્તનયોગ્યાનિ શુક્લવર્ણાન્યભવન્| ");
INSERT INTO sanguj_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","યશ્છિનત્તિ સ વેતનં લભતે અનન્તાયુઃસ્વરૂપં શસ્યં સ ગૃહ્લાતિ ચ, તેનૈવ વપ્તા છેત્તા ચ યુગપદ્ આનન્દતઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ઇત્થં સતિ વપત્યેકશ્છિનત્યન્ય ઇતિ વચનં સિદ્ધ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","યત્ર યૂયં ન પર્ય્યશ્રામ્યત તાદૃશં શસ્યં છેત્તું યુષ્માન્ પ્રૈરયમ્ અન્યે જનાઃપર્ય્યશ્રામ્યન્ યૂયં તેષાં શ્રગસ્ય ફલમ્ અલભધ્વમ્| ");
INSERT INTO sanguj_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","યસ્મિન્ કાલે યદ્યત્ કર્મ્માકાર્ષં તત્સર્વ્વં સ મહ્યમ્ અકથયત્ તસ્યા વનિતાયા ઇદં સાક્ષ્યવાક્યં શ્રુત્વા તન્નગરનિવાસિનો બહવઃ શોમિરોણીયલોકા વ્યશ્વસન્| ");
INSERT INTO sanguj_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","તથા ચ તસ્યાન્તિકે સમુપસ્થાય સ્વેષાં સન્નિધૌ કતિચિદ્ દિનાનિ સ્થાતું તસ્મિન્ વિનયમ્ અકુર્વ્વાન તસ્માત્ સ દિનદ્વયં તત્સ્થાને ન્યવષ્ટત્ ");
INSERT INTO sanguj_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","તતસ્તસ્યોપદેશેન બહવોઽપરે વિશ્વસ્ય ");
INSERT INTO sanguj_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","તાં યોષામવદન્ કેવલં તવ વાક્યેન પ્રતીમ ઇતિ ન, કિન્તુ સ જગતોઽભિષિક્તસ્ત્રાતેતિ તસ્ય કથાં શ્રુત્વા વયં સ્વયમેવાજ્ઞાસમહિ| ");
INSERT INTO sanguj_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","સ્વદેશે ભવિષ્યદ્વક્તુઃ સત્કારો નાસ્તીતિ યદ્યપિ યીશુઃ પ્રમાણં દત્વાકથયત્ ");
INSERT INTO sanguj_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","તથાપિ દિવસદ્વયાત્ પરં સ તસ્માત્ સ્થાનાદ્ ગાલીલં ગતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","અનન્તરં યે ગાલીલી લિયલોકા ઉત્સવે ગતા ઉત્સવસમયે યિરૂશલમ્ નગરે તસ્ય સર્વ્વાઃ ક્રિયા અપશ્યન્ તે ગાલીલમ્ આગતં તમ્ આગૃહ્લન્| ");
INSERT INTO sanguj_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","તતઃ પરમ્ યીશુ ર્યસ્મિન્ કાન્નાનગરે જલં દ્રાક્ષારસમ્ આકરોત્ તત્ સ્થાનં પુનરગાત્| તસ્મિન્નેવ સમયે કસ્યચિદ્ રાજસભાસ્તારસ્ય પુત્રઃ કફર્નાહૂમપુરી રોગગ્રસ્ત આસીત્| ");
INSERT INTO sanguj_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","સ યેહૂદીયદેશાદ્ યીશો ર્ગાલીલાગમનવાર્ત્તાં નિશમ્ય તસ્ય સમીપં ગત્વા પ્રાર્થ્ય વ્યાહૃતવાન્ મમ પુત્રસ્ય પ્રાયેણ કાલ આસન્નઃ ભવાન્ આગત્ય તં સ્વસ્થં કરોતુ| ");
INSERT INTO sanguj_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","તદા યીશુરકથયદ્ આશ્ચર્ય્યં કર્મ્મ ચિત્રં ચિહ્નં ચ ન દૃષ્ટા યૂયં ન પ્રત્યેષ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","તતઃ સ સભાસદવદત્ હે મહેચ્છ મમ પુત્રે ન મૃતે ભવાનાગચ્છતુ| ");
INSERT INTO sanguj_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","યીશુસ્તમવદદ્ ગચ્છ તવ પુત્રોઽજીવીત્ તદા યીશુનોક્તવાક્યે સ વિશ્વસ્ય ગતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ગમનકાલે માર્ગમધ્યે દાસાસ્તં સાક્ષાત્પ્રાપ્યાવદન્ ભવતઃ પુત્રોઽજીવીત્| ");
INSERT INTO sanguj_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","તતઃ કં કાલમારભ્ય રોગપ્રતીકારારમ્ભો જાતા ઇતિ પૃષ્ટે તૈરુક્તં હ્યઃ સાર્દ્ધદણ્ડદ્વયાધિકદ્વિતીયયામે તસ્ય જ્વરત્યાગોઽભવત્| ");
INSERT INTO sanguj_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","તદા યીશુસ્તસ્મિન્ ક્ષણે પ્રોક્તવાન્ તવ પુત્રોઽજીવીત્ પિતા તદ્બુદ્ધ્વા સપરિવારો વ્યશ્વસીત્| ");
INSERT INTO sanguj_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","યિહૂદીયદેશાદ્ આગત્ય ગાલીલિ યીશુરેતદ્ દ્વિતીયમ્ આશ્ચર્ય્યકર્મ્માકરોત્| ");
INSERT INTO sanguj_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","તતઃ પરં યિહૂદીયાનામ્ ઉત્સવ ઉપસ્થિતે યીશુ ર્યિરૂશાલમં ગતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","તસ્મિન્નગરે મેષનામ્નો દ્વારસ્ય સમીપે ઇબ્રીયભાષયા બૈથેસ્દા નામ્ના પિષ્કરિણી પઞ્ચઘટ્ટયુક્તાસીત્| ");
INSERT INTO sanguj_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","તસ્યાસ્તેષુ ઘટ્ટેષુ કિલાલકમ્પનમ્ અપેક્ષ્ય અન્ધખઞ્ચશુષ્કાઙ્ગાદયો બહવો રોગિણઃ પતન્તસ્તિષ્ઠન્તિ સ્મ| ");
INSERT INTO sanguj_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","યતો વિશેષકાલે તસ્ય સરસો વારિ સ્વર્ગીયદૂત એત્યાકમ્પયત્ તત્કીલાલકમ્પનાત્ પરં યઃ કશ્ચિદ્ રોગી પ્રથમં પાનીયમવારોહત્ સ એવ તત્ક્ષણાદ્ રોગમુક્તોઽભવત્| ");
INSERT INTO sanguj_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","તદાષ્ટાત્રિંશદ્વર્ષાણિ યાવદ્ રોગગ્રસ્ત એકજનસ્તસ્મિન્ સ્થાને સ્થિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","યીશુસ્તં શયિતં દૃષ્ટ્વા બહુકાલિકરોગીતિ જ્ઞાત્વા વ્યાહૃતવાન્ ત્વં કિં સ્વસ્થો બુભૂષસિ? ");
INSERT INTO sanguj_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","તતો રોગી કથિતવાન્ હે મહેચ્છ યદા કીલાલં કમ્પતે તદા માં પુષ્કરિણીમ્ અવરોહયિતું મમ કોપિ નાસ્તિ, તસ્માન્ મમ ગમનકાલે કશ્ચિદન્યોઽગ્રો ગત્વા અવરોહતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","તદા યીશુરકથયદ્ ઉત્તિષ્ઠ, તવ શય્યામુત્તોલ્ય ગૃહીત્વા યાહિ| ");
INSERT INTO sanguj_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","સ તત્ક્ષણાત્ સ્વસ્થો ભૂત્વા શય્યામુત્તોલ્યાદાય ગતવાન્ કિન્તુ તદ્દિનં વિશ્રામવારઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","તસ્માદ્ યિહૂદીયાઃ સ્વસ્થં નરં વ્યાહરન્ અદ્ય વિશ્રામવારે શયનીયમાદાય ન યાતવ્યમ્| ");
INSERT INTO sanguj_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","તતઃ સ પ્રત્યવોચદ્ યો માં સ્વસ્થમ્ અકાર્ષીત્ શયનીયમ્ ઉત્તોલ્યાદાય યાતું માં સ એવાદિશત્| ");
INSERT INTO sanguj_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","તદા તેઽપૃચ્છન્ શયનીયમ્ ઉત્તોલ્યાદાય યાતું ય આજ્ઞાપયત્ સ કઃ? ");
INSERT INTO sanguj_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","કિન્તુ સ ક ઇતિ સ્વસ્થીભૂતો નાજાનાદ્ યતસ્તસ્મિન્ સ્થાને જનતાસત્ત્વાદ્ યીશુઃ સ્થાનાન્તરમ્ આગમત્| ");
INSERT INTO sanguj_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","તતઃ પરં યેશુ ર્મન્દિરે તં નરં સાક્ષાત્પ્રાપ્યાકથયત્ પશ્યેદાનીમ્ અનામયો જાતોસિ યથાધિકા દુર્દશા ન ઘટતે તદ્ધેતોઃ પાપં કર્મ્મ પુનર્માકાર્ષીઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","તતઃ સ ગત્વા યિહૂદીયાન્ અવદદ્ યીશુ ર્મામ્ અરોગિણમ્ અકાર્ષીત્| ");
INSERT INTO sanguj_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","તતો યીશુ ર્વિશ્રામવારે કર્મ્મેદૃશં કૃતવાન્ ઇતિ હેતો ર્યિહૂદીયાસ્તં તાડયિત્વા હન્તુમ્ અચેષ્ટન્ત| ");
INSERT INTO sanguj_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","યીશુસ્તાનાખ્યત્ મમ પિતા યત્ કાર્ય્યં કરોતિ તદનુરૂપમ્ અહમપિ કરોતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","તતો યિહૂદીયાસ્તં હન્તું પુનરયતન્ત યતો વિશ્રામવારં નામન્યત તદેવ કેવલં ન અધિકન્તુ ઈશ્વરં સ્વપિતરં પ્રોચ્ય સ્વમપીશ્વરતુલ્યં કૃતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","પશ્ચાદ્ યીશુરવદદ્ યુષ્માનહં યથાર્થતરં વદામિ પુત્રઃ પિતરં યદ્યત્ કર્મ્મ કુર્વ્વન્તં પશ્યતિ તદતિરિક્તં સ્વેચ્છાતઃ કિમપિ કર્મ્મ કર્ત્તું ન શક્નોતિ| પિતા યત્ કરોતિ પુત્રોપિ તદેવ કરોતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","પિતા પુત્રે સ્નેહં કરોતિ તસ્માત્ સ્વયં યદ્યત્ કર્મ્મ કરોતિ તત્સર્વ્વં પુત્રં દર્શયતિ ; યથા ચ યુષ્માકં આશ્ચર્ય્યજ્ઞાનં જનિષ્યતે તદર્થમ્ ઇતોપિ મહાકર્મ્મ તં દર્શયિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","વસ્તુતસ્તુ પિતા યથા પ્રમિતાન્ ઉત્થાપ્ય સજિવાન્ કરોતિ તદ્વત્ પુત્રોપિ યં યં ઇચ્છતિ તં તં સજીવં કરોતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","સર્વ્વે પિતરં યથા સત્કુર્વ્વન્તિ તથા પુત્રમપિ સત્કારયિતું પિતા સ્વયં કસ્યાપિ વિચારમકૃત્વા સર્વ્વવિચારાણાં ભારં પુત્રે સમર્પિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","યઃ પુત્રં સત્ કરોતિ સ તસ્ય પ્રેરકમપિ સત્ કરોતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","યુષ્માનાહં યથાર્થતરં વદામિ યો જનો મમ વાક્યં શ્રુત્વા મત્પ્રેરકે વિશ્વસિતિ સોનન્તાયુઃ પ્રાપ્નોતિ કદાપિ દણ્ડબાજનં ન ભવતિ નિધનાદુત્થાય પરમાયુઃ પ્રાપ્નોતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","અહં યુષ્માનતિયથાર્થં વદામિ યદા મૃતા ઈશ્વરપુત્રસ્ય નિનાદં શ્રોષ્યન્તિ યે ચ શ્રોષ્યન્તિ તે સજીવા ભવિષ્યન્તિ સમય એતાદૃશ આયાતિ વરમ્ ઇદાનીમપ્યુપતિષ્ઠતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","પિતા યથા સ્વયઞ્જીવી તથા પુત્રાય સ્વયઞ્જીવિત્વાધિકારં દત્તવાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","સ મનુષ્યપુત્રઃ એતસ્માત્ કારણાત્ પિતા દણ્ડકરણાધિકારમપિ તસ્મિન્ સમર્પિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","એતદર્થે યૂયમ્ આશ્ચર્ય્યં ન મન્યધ્વં યતો યસ્મિન્ સમયે તસ્ય નિનાદં શ્રુત્વા શ્મશાનસ્થાઃ સર્વ્વે બહિરાગમિષ્યન્તિ સમય એતાદૃશ ઉપસ્થાસ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","તસ્માદ્ યે સત્કર્મ્માણિ કૃતવન્તસ્ત ઉત્થાય આયુઃ પ્રાપ્સ્યન્તિ યે ચ કુકર્માણિ કૃતવન્તસ્ત ઉત્થાય દણ્ડં પ્રાપ્સ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","અહં સ્વયં કિમપિ કર્ત્તું ન શક્નોમિ યથા શુણોમિ તથા વિચારયામિ મમ વિચારઞ્ચ ન્યાય્યઃ યતોહં સ્વીયાભીષ્ટં નેહિત્વા મત્પ્રેરયિતુઃ પિતુરિષ્ટમ્ ઈહે| ");
INSERT INTO sanguj_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","યદિ સ્વસ્મિન્ સ્વયં સાક્ષ્યં દદામિ તર્હિ તત્સાક્ષ્યમ્ આગ્રાહ્યં ભવતિ ; ");
INSERT INTO sanguj_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","કિન્તુ મદર્થેઽપરો જનઃ સાક્ષ્યં દદાતિ મદર્થે તસ્ય યત્ સાક્ષ્યં તત્ સત્યમ્ એતદપ્યહં જાનામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","યુષ્માભિ ર્યોહનં પ્રતિ લોકેષુ પ્રેરિતેષુ સ સત્યકથાયાં સાક્ષ્યમદદાત્| ");
INSERT INTO sanguj_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","માનુષાદહં સાક્ષ્યં નોપેક્ષે તથાપિ યૂયં યથા પરિત્રયધ્વે તદર્થમ્ ઇદં વાક્યં વદામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","યોહન્ દેદીપ્યમાનો દીપ ઇવ તેજસ્વી સ્થિતવાન્ યૂયમ્ અલ્પકાલં તસ્ય દીપ્ત્યાનન્દિતું સમમન્યધ્વં| ");
INSERT INTO sanguj_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","કિન્તુ તત્પ્રમાણાદપિ મમ ગુરુતરં પ્રમાણં વિદ્યતે પિતા માં પ્રેષ્ય યદ્યત્ કર્મ્મ સમાપયિતું શક્ત્તિમદદાત્ મયા કૃતં તત્તત્ કર્મ્મ મદર્થે પ્રમાણં દદાતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","યઃ પિતા માં પ્રેરિતવાન્ મોપિ મદર્થે પ્રમાણં દદાતિ| તસ્ય વાક્યં યુષ્માભિઃ કદાપિ ન શ્રુતં તસ્ય રૂપઞ્ચ ન દૃષ્ટં ");
INSERT INTO sanguj_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","તસ્ય વાક્યઞ્ચ યુષ્માકમ્ અન્તઃ કદાપિ સ્થાનં નાપ્નોતિ યતઃ સ યં પ્રેષિતવાન્ યૂયં તસ્મિન્ ન વિશ્વસિથ| ");
INSERT INTO sanguj_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","ધર્મ્મપુસ્તકાનિ યૂયમ્ આલોચયધ્વં તૈ ર્વાક્યૈરનન્તાયુઃ પ્રાપ્સ્યામ ઇતિ યૂયં બુધ્યધ્વે તદ્ધર્મ્મપુસ્તકાનિ મદર્થે પ્રમાણં દદતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","તથાપિ યૂયં પરમાયુઃપ્રાપ્તયે મમ સંનિધિમ્ ન જિગમિષથ| ");
INSERT INTO sanguj_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","અહં માનુષેભ્યઃ સત્કારં ન ગૃહ્લામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","અહં યુષ્માન્ જાનામિ; યુષ્માકમન્તર ઈશ્વરપ્રેમ નાસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","અહં નિજપિતુ ર્નામ્નાગતોસ્મિ તથાપિ માં ન ગૃહ્લીથ કિન્તુ કશ્ચિદ્ યદિ સ્વનામ્ના સમાગમિષ્યતિ તર્હિ તં ગ્રહીષ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","યૂયમ્ ઈશ્વરાત્ સત્કારં ન ચિષ્ટત્વા કેવલં પરસ્પરં સત્કારમ્ ચેદ્ આદધ્વ્વે તર્હિ કથં વિશ્વસિતું શક્નુથ? ");
INSERT INTO sanguj_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","પુતુઃ સમીપેઽહં યુષ્માન્ અપવદિષ્યામીતિ મા ચિન્તયત યસ્મિન્ , યસ્મિન્ યુષ્માકં વિશ્વસઃ સએવ મૂસા યુષ્માન્ અપવદતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","યદિ યૂયં તસ્મિન્ વ્યશ્વસિષ્યત તર્હિ મય્યપિ વ્યશ્વસિષ્યત, યત્ સ મયિ લિખિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","તતો યદિ તેન લિખિતવાનિ ન પ્રતિથ તર્હિ મમ વાક્યાનિ કથં પ્રત્યેષ્યથ? ");
INSERT INTO sanguj_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","તતઃ પરં યીશુ ર્ગાલીલ્ પ્રદેશીયસ્ય તિવિરિયાનામ્નઃ સિન્ધોઃ પારં ગતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","તતો વ્યાધિમલ્લોકસ્વાસ્થ્યકરણરૂપાણિ તસ્યાશ્ચર્ય્યાણિ કર્મ્માણિ દૃષ્ટ્વા બહવો જનાસ્તત્પશ્ચાદ્ અગચ્છન્| ");
INSERT INTO sanguj_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","તતો યીશુઃ પર્વ્વતમારુહ્ય તત્ર શિષ્યૈઃ સાકમ્| ");
INSERT INTO sanguj_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","તસ્મિન્ સમય નિસ્તારોત્સવનામ્નિ યિહૂદીયાનામ ઉત્સવ ઉપસ્થિતે ");
INSERT INTO sanguj_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","યીશુ ર્નેત્રે ઉત્તોલ્ય બહુલોકાન્ સ્વસમીપાગતાન્ વિલોક્ય ફિલિપં પૃષ્ટવાન્ એતેષાં ભોજનાય ભોજદ્રવ્યાણિ વયં કુત્ર ક્રેતું શક્રુમઃ? ");
INSERT INTO sanguj_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","વાક્યમિદં તસ્ય પરીક્ષાર્થમ્ અવાદીત્ કિન્તુ યત્ કરિષ્યતિ તત્ સ્વયમ્ અજાનાત્| ");
INSERT INTO sanguj_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ફિલિપઃ પ્રત્યવોચત્ એતેષામ્ એકૈકો યદ્યલ્પમ્ અલ્પં પ્રાપ્નોતિ તર્હિ મુદ્રાપાદદ્વિશતેન ક્રીતપૂપા અપિ ન્યૂના ભવિષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","શિમોન્ પિતરસ્ય ભ્રાતા આન્દ્રિયાખ્યઃ શિષ્યાણામેકો વ્યાહૃતવાન્ ");
INSERT INTO sanguj_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","અત્ર કસ્યચિદ્ બાલકસ્ય સમીપે પઞ્ચ યાવપૂપાઃ ક્ષુદ્રમત્સ્યદ્વયઞ્ચ સન્તિ કિન્તુ લોકાનાં એતાવાતાં મધ્યે તૈઃ કિં ભવિષ્યતિ? ");
INSERT INTO sanguj_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","પશ્ચાદ્ યીશુરવદત્ લોકાનુપવેશયત તત્ર બહુયવસસત્ત્વાત્ પઞ્ચસહસ્ત્રેભ્યો ન્યૂના અધિકા વા પુરુષા ભૂમ્યામ્ ઉપાવિશન્| ");
INSERT INTO sanguj_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","તતો યીશુસ્તાન્ પૂપાનાદાય ઈશ્વરસ્ય ગુણાન્ કીર્ત્તયિત્વા શિષ્યેષુ સમાર્પયત્ તતસ્તે તેભ્ય ઉપવિષ્ટલોકેભ્યઃ પૂપાન્ યથેષ્ટમત્સ્યઞ્ચ પ્રાદુઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","તેષુ તૃપ્તેષુ સ તાનવોચદ્ એતેષાં કિઞ્ચિદપિ યથા નાપચીયતે તથા સર્વ્વાણ્યવશિષ્ટાનિ સંગૃહ્લીત| ");
INSERT INTO sanguj_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","તતઃ સર્વ્વેષાં ભોજનાત્ પરં તે તેષાં પઞ્ચાનાં યાવપૂપાનાં અવશિષ્ટાન્યખિલાનિ સંગૃહ્ય દ્વાદશડલ્લકાન્ અપૂરયન્| ");
INSERT INTO sanguj_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","અપરં યીશોરેતાદૃશીમ્ આશ્ચર્ય્યક્રિયાં દૃષ્ટ્વા લોકા મિથો વક્તુમારેભિરે જગતિ યસ્યાગમનં ભવિષ્યતિ સ એવાયમ્ અવશ્યં ભવિષ્યદ્વક્ત્તા| ");
INSERT INTO sanguj_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","અતએવ લોકા આગત્ય તમાક્રમ્ય રાજાનં કરિષ્યન્તિ યીશુસ્તેષામ્ ઈદૃશં માનસં વિજ્ઞાય પુનશ્ચ પર્વ્વતમ્ એકાકી ગતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","સાયંકાલ ઉપસ્થિતે શિષ્યા જલધિતટં વ્રજિત્વા નાવમારુહ્ય નગરદિશિ સિન્ધૌ વાહયિત્વાગમન્| ");
INSERT INTO sanguj_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","તસ્મિન્ સમયે તિમિર ઉપાતિષ્ઠત્ કિન્તુ યીષુસ્તેષાં સમીપં નાગચ્છત્| ");
INSERT INTO sanguj_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","તદા પ્રબલપવનવહનાત્ સાગરે મહાતરઙ્ગો ભવિતુમ્ આરેભે| ");
INSERT INTO sanguj_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","તતસ્તે વાહયિત્વા દ્વિત્રાન્ ક્રોશાન્ ગતાઃ પશ્ચાદ્ યીશું જલધેરુપરિ પદ્ભ્યાં વ્રજન્તં નૌકાન્તિકમ્ આગચ્છન્તં વિલોક્ય ત્રાસયુક્તા અભવન્ ");
INSERT INTO sanguj_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","કિન્તુ સ તાનુક્ત્તવાન્ અયમહં મા ભૈષ્ટ| ");
INSERT INTO sanguj_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","તદા તે તં સ્વૈરં નાવિ ગૃહીતવન્તઃ તદા તત્ક્ષણાદ્ ઉદ્દિષ્ટસ્થાને નૌરુપાસ્થાત્| ");
INSERT INTO sanguj_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","યયા નાવા શિષ્યા અગચ્છન્ તદન્યા કાપિ નૌકા તસ્મિન્ સ્થાને નાસીત્ તતો યીશુઃ શિષ્યૈઃ સાકં નાગમત્ કેવલાઃ શિષ્યા અગમન્ એતત્ પારસ્થા લોકા જ્ઞાતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","કિન્તુ તતઃ પરં પ્રભુ ર્યત્ર ઈશ્વરસ્ય ગુણાન્ અનુકીર્ત્ત્ય લોકાન્ પૂપાન્ અભોજયત્ તત્સ્થાનસ્ય સમીપસ્થતિવિરિયાયા અપરાસ્તરણય આગમન્| ");
INSERT INTO sanguj_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","યીશુસ્તત્ર નાસ્તિ શિષ્યા અપિ તત્ર ના સન્તિ લોકા ઇતિ વિજ્ઞાય યીશું ગવેષયિતું તરણિભિઃ કફર્નાહૂમ્ પુરં ગતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","તતસ્તે સરિત્પતેઃ પારે તં સાક્ષાત્ પ્રાપ્ય પ્રાવોચન્ હે ગુરો ભવાન્ અત્ર સ્થાને કદાગમત્? ");
INSERT INTO sanguj_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","તદા યીશુસ્તાન્ પ્રત્યવાદીદ્ યુષ્માનહં યથાર્થતરં વદામિ આશ્ચર્ય્યકર્મ્મદર્શનાદ્ધેતો ર્ન કિન્તુ પૂપભોજનાત્ તેન તૃપ્તત્વાઞ્ચ માં ગવેષયથ| ");
INSERT INTO sanguj_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ક્ષયણીયભક્ષ્યાર્થં મા શ્રામિષ્ટ કિન્ત્વન્તાયુર્ભક્ષ્યાર્થં શ્રામ્યત, તસ્માત્ તાદૃશં ભક્ષ્યં મનુજપુત્રો યુષ્માભ્યં દાસ્યતિ; તસ્મિન્ તાત ઈશ્વરઃ પ્રમાણં પ્રાદાત્| ");
INSERT INTO sanguj_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","તદા તેઽપૃચ્છન્ ઈશ્વરાભિમતં કર્મ્મ કર્ત્તુમ્ અસ્માભિઃ કિં કર્ત્તવ્યં? ");
INSERT INTO sanguj_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","તતો યીશુરવદદ્ ઈશ્વરો યં પ્રૈરયત્ તસ્મિન્ વિશ્વસનમ્ ઈશ્વરાભિમતં કર્મ્મ| ");
INSERT INTO sanguj_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","તદા તે વ્યાહરન્ ભવતા કિં લક્ષણં દર્શિતં યદ્દૃષ્ટ્વા ભવતિ વિશ્વસિષ્યામઃ? ત્વયા કિં કર્મ્મ કૃતં? ");
INSERT INTO sanguj_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","અસ્માકં પૂર્વ્વપુરુષા મહાપ્રાન્તરે માન્નાં ભોક્ત્તું પ્રાપુઃ યથા લિપિરાસ્તે| સ્વર્ગીયાણિ તુ ભક્ષ્યાણિ પ્રદદૌ પરમેશ્વરઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","તદા યીશુરવદદ્ અહં યુષ્માનતિયથાર્થં વદામિ મૂસા યુષ્માભ્યં સ્વર્ગીયં ભક્ષ્યં નાદાત્ કિન્તુ મમ પિતા યુષ્માભ્યં સ્વર્ગીયં પરમં ભક્ષ્યં દદાતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","યઃ સ્વર્ગાદવરુહ્ય જગતે જીવનં દદાતિ સ ઈશ્વરદત્તભક્ષ્યરૂપઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","તદા તે પ્રાવોચન્ હે પ્રભો ભક્ષ્યમિદં નિત્યમસ્મભ્યં દદાતુ| ");
INSERT INTO sanguj_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","યીશુરવદદ્ અહમેવ જીવનરૂપં ભક્ષ્યં યો જનો મમ સન્નિધિમ્ આગચ્છતિ સ જાતુ ક્ષુધાર્ત્તો ન ભવિષ્યતિ, તથા યો જનો માં પ્રત્યેતિ સ જાતુ તૃષાર્ત્તો ન ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","માં દૃષ્ટ્વાપિ યૂયં ન વિશ્વસિથ યુષ્માનહમ્ ઇત્યવોચં| ");
INSERT INTO sanguj_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","પિતા મહ્યં યાવતો લોકાનદદાત્ તે સર્વ્વ એવ મમાન્તિકમ્ આગમિષ્યન્તિ યઃ કશ્ચિચ્ચ મમ સન્નિધિમ્ આયાસ્યતિ તં કેનાપિ પ્રકારેણ ન દૂરીકરિષ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","નિજાભિમતં સાધયિતું ન હિ કિન્તુ પ્રેરયિતુરભિમતં સાધયિતું સ્વર્ગાદ્ આગતોસ્મિ| ");
INSERT INTO sanguj_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","સ યાન્ યાન્ લોકાન્ મહ્યમદદાત્ તેષામેકમપિ ન હારયિત્વા શેષદિને સર્વ્વાનહમ્ ઉત્થાપયામિ ઇદં મત્પ્રેરયિતુઃ પિતુરભિમતં| ");
INSERT INTO sanguj_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","યઃ કશ્ચિન્ માનવસુતં વિલોક્ય વિશ્વસિતિ સ શેષદિને મયોત્થાપિતઃ સન્ અનન્તાયુઃ પ્રાપ્સ્યતિ ઇતિ મત્પ્રેરકસ્યાભિમતં| ");
INSERT INTO sanguj_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","તદા સ્વર્ગાદ્ યદ્ ભક્ષ્યમ્ અવારોહત્ તદ્ ભક્ષ્યમ્ અહમેવ યિહૂદીયલોકાસ્તસ્યૈતદ્ વાક્યે વિવદમાના વક્ત્તુમારેભિરે ");
INSERT INTO sanguj_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","યૂષફઃ પુત્રો યીશુ ર્યસ્ય માતાપિતરૌ વયં જાનીમ એષ કિં સએવ ન? તર્હિ સ્વર્ગાદ્ અવારોહમ્ ઇતિ વાક્યં કથં વક્ત્તિ? ");
INSERT INTO sanguj_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","તદા યીશુસ્તાન્ પ્રત્યવદત્ પરસ્પરં મા વિવદધ્વં ");
INSERT INTO sanguj_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","મત્પ્રેરકેણ પિત્રા નાકૃષ્ટઃ કોપિ જનો મમાન્તિકમ્ આયાતું ન શક્નોતિ કિન્ત્વાગતં જનં ચરમેઽહ્નિ પ્રોત્થાપયિષ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","તે સર્વ્વ ઈશ્વરેણ શિક્ષિતા ભવિષ્યન્તિ ભવિષ્યદ્વાદિનાં ગ્રન્થેષુ લિપિરિત્થમાસ્તે અતો યઃ કશ્ચિત્ પિતુઃ સકાશાત્ શ્રુત્વા શિક્ષતે સ એવ મમ સમીપમ્ આગમિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ય ઈશ્વરાદ્ અજાયત તં વિના કોપિ મનુષ્યો જનકં નાદર્શત્ કેવલઃ સએવ તાતમ્ અદ્રાક્ષીત્| ");
INSERT INTO sanguj_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","અહં યુષ્માન્ યથાર્થતરં વદામિ યો જનો મયિ વિશ્વાસં કરોતિ સોનન્તાયુઃ પ્રાપ્નોતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","અહમેવ તજ્જીવનભક્ષ્યં| ");
INSERT INTO sanguj_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","યુષ્માકં પૂર્વ્વપુરુષા મહાપ્રાન્તરે મન્નાભક્ષ્યં ભૂક્ત્તાપિ મૃતાઃ ");
INSERT INTO sanguj_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","કિન્તુ યદ્ભક્ષ્યં સ્વર્ગાદાગચ્છત્ તદ્ યદિ કશ્ચિદ્ ભુઙ્ક્ત્તે તર્હિ સ ન મ્રિયતે| ");
INSERT INTO sanguj_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","યજ્જીવનભક્ષ્યં સ્વર્ગાદાગચ્છત્ સોહમેવ ઇદં ભક્ષ્યં યો જનો ભુઙ્ક્ત્તે સ નિત્યજીવી ભવિષ્યતિ| પુનશ્ચ જગતો જીવનાર્થમહં યત્ સ્વકીયપિશિતં દાસ્યામિ તદેવ મયા વિતરિતં ભક્ષ્યમ્| ");
INSERT INTO sanguj_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","તસ્માદ્ યિહૂદીયાઃ પરસ્પરં વિવદમાના વક્ત્તુમારેભિરે એષ ભોજનાર્થં સ્વીયં પલલં કથમ્ અસ્મભ્યં દાસ્યતિ? ");
INSERT INTO sanguj_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","તદા યીશુસ્તાન્ આવોચદ્ યુષ્માનહં યથાર્થતરં વદામિ મનુષ્યપુત્રસ્યામિષે યુષ્માભિ ર્ન ભુક્ત્તે તસ્ય રુધિરે ચ ન પીતે જીવનેન સાર્દ્ધં યુષ્માકં સમ્બન્ધો નાસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","યો મમામિષં સ્વાદતિ મમ સુધિરઞ્ચ પિવતિ સોનન્તાયુઃ પ્રાપ્નોતિ તતઃ શેષેઽહ્નિ તમહમ્ ઉત્થાપયિષ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","યતો મદીયમામિષં પરમં ભક્ષ્યં તથા મદીયં શોણિતં પરમં પેયં| ");
INSERT INTO sanguj_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","યો જનો મદીયં પલલં સ્વાદતિ મદીયં રુધિરઞ્ચ પિવતિ સ મયિ વસતિ તસ્મિન્નહઞ્ચ વસામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","મત્પ્રેરયિત્રા જીવતા તાતેન યથાહં જીવામિ તદ્વદ્ યઃ કશ્ચિન્ મામત્તિ સોપિ મયા જીવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","યદ્ભક્ષ્યં સ્વર્ગાદાગચ્છત્ તદિદં યન્માન્નાં સ્વાદિત્વા યુષ્માકં પિતરોઽમ્રિયન્ત તાદૃશમ્ ઇદં ભક્ષ્યં ન ભવતિ ઇદં ભક્ષ્યં યો ભક્ષતિ સ નિત્યં જીવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","યદા કફર્નાહૂમ્ પુર્ય્યાં ભજનગેહે ઉપાદિશત્ તદા કથા એતા અકથયત્| ");
INSERT INTO sanguj_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","તદેત્થં શ્રુત્વા તસ્ય શિષ્યાણામ્ અનેકે પરસ્પરમ્ અકથયન્ ઇદં ગાઢં વાક્યં વાક્યમીદૃશં કઃ શ્રોતું શક્રુયાત્? ");
INSERT INTO sanguj_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","કિન્તુ યીશુઃ શિષ્યાણામ્ ઇત્થં વિવાદં સ્વચિત્તે વિજ્ઞાય કથિતવાન્ ઇદં વાક્યં કિં યુષ્માકં વિઘ્નં જનયતિ? ");
INSERT INTO sanguj_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","યદિ મનુજસુતં પૂર્વ્વવાસસ્થાનમ્ ઊર્દ્વ્વં ગચ્છન્તં પશ્યથ તર્હિ કિં ભવિષ્યતિ? ");
INSERT INTO sanguj_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","આત્મૈવ જીવનદાયકઃ વપુ ર્નિષ્ફલં યુષ્મભ્યમહં યાનિ વચાંસિ કથયામિ તાન્યાત્મા જીવનઞ્ચ| ");
INSERT INTO sanguj_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","કિન્તુ યુષ્માકં મધ્યે કેચન અવિશ્વાસિનઃ સન્તિ કે કે ન વિશ્વસન્તિ કો વા તં પરકરેષુ સમર્પયિષ્યતિ તાન્ યીશુરાપ્રથમાદ્ વેત્તિ| ");
INSERT INTO sanguj_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","અપરમપિ કથિતવાન્ અસ્માત્ કારણાદ્ અકથયં પિતુઃ સકાશાત્ શક્ત્તિમપ્રાપ્ય કોપિ મમાન્તિકમ્ આગન્તું ન શક્નોતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","તત્કાલેઽનેકે શિષ્યા વ્યાઘુટ્ય તેન સાર્દ્ધં પુન ર્નાગચ્છન્| ");
INSERT INTO sanguj_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","તદા યીશુ ર્દ્વાદશશિષ્યાન્ ઉક્ત્તવાન્ યૂયમપિ કિં યાસ્યથ? ");
INSERT INTO sanguj_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","તતઃ શિમોન્ પિતરઃ પ્રત્યવોચત્ હે પ્રભો કસ્યાભ્યર્ણં ગમિષ્યામઃ? ");
INSERT INTO sanguj_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","અનન્તજીવનદાયિન્યો યાઃ કથાસ્તાસ્તવૈવ| ભવાન્ અમરેશ્વરસ્યાભિષિક્ત્તપુત્ર ઇતિ વિશ્વસ્ય નિશ્ચિતં જાનીમઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","તદા યીશુરવદત્ કિમહં યુષ્માકં દ્વાદશજનાન્ મનોનીતાન્ ન કૃતવાન્? કિન્તુ યુષ્માકં મધ્યેપિ કશ્ચિદેકો વિઘ્નકારી વિદ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ઇમાં કથં સ શિમોનઃ પુત્રમ્ ઈષ્કરીયોતીયં યિહૂદામ્ ઉદ્દિશ્ય કથિતવાન્ યતો દ્વાદશાનાં મધ્યે ગણિતઃ સ તં પરકરેષુ સમર્પયિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","તતઃ પરં યિહૂદીયલોકાસ્તં હન્તું સમૈહન્ત તસ્માદ્ યીશુ ર્યિહૂદાપ્રદેશે પર્ય્યટિતું નેચ્છન્ ગાલીલ્ પ્રદેશે પર્ય્યટિતું પ્રારભત| ");
INSERT INTO sanguj_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","કિન્તુ તસ્મિન્ સમયે યિહૂદીયાનાં દૂષ્યવાસનામોત્સવ ઉપસ્થિતે ");
INSERT INTO sanguj_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","તસ્ય ભ્રાતરસ્તમ્ અવદન્ યાનિ કર્મ્માણિ ત્વયા ક્રિયન્તે તાનિ યથા તવ શિષ્યાઃ પશ્યન્તિ તદર્થં ત્વમિતઃ સ્થાનાદ્ યિહૂદીયદેશં વ્રજ| ");
INSERT INTO sanguj_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","યઃ કશ્ચિત્ સ્વયં પ્રચિકાશિષતિ સ કદાપિ ગુપ્તં કર્મ્મ ન કરોતિ યદીદૃશં કર્મ્મ કરોષિ તર્હિ જગતિ નિજં પરિચાયય| ");
INSERT INTO sanguj_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","યતસ્તસ્ય ભ્રાતરોપિ તં ન વિશ્વસન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","તદા યીશુસ્તાન્ અવોચત્ મમ સમય ઇદાનીં નોપતિષ્ઠતિ કિન્તુ યુષ્માકં સમયઃ સતતમ્ ઉપતિષ્ઠતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","જગતો લોકા યુષ્માન્ ઋતીયિતું ન શક્રુવન્તિ કિન્તુ મામેવ ઋતીયન્તે યતસ્તેષાં કર્માણિ દુષ્ટાનિ તત્ર સાક્ષ્યમિદમ્ અહં દદામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","અતએવ યૂયમ્ ઉત્સવેઽસ્મિન્ યાત નાહમ્ ઇદાનીમ્ અસ્મિન્નુત્સવે યામિ યતો મમ સમય ઇદાનીં ન સમ્પૂર્ણઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ઇતિ વાક્યમ્ ઉક્ત્ત્વા સ ગાલીલિ સ્થિતવાન્ ");
INSERT INTO sanguj_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","કિન્તુ તસ્ય ભ્રાતૃષુ તત્ર પ્રસ્થિતેષુ સત્સુ સોઽપ્રકટ ઉત્સવમ્ અગચ્છત્| ");
INSERT INTO sanguj_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","અનન્તરમ્ ઉત્સવમ્ ઉપસ્થિતા યિહૂદીયાસ્તં મૃગયિત્વાપૃચ્છન્ સ કુત્ર? ");
INSERT INTO sanguj_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","તતો લોકાનાં મધ્યે તસ્મિન્ નાનાવિધા વિવાદા ભવિતુમ્ આરબ્ધવન્તઃ| કેચિદ્ અવોચન્ સ ઉત્તમઃ પુરુષઃ કેચિદ્ અવોચન્ ન તથા વરં લોકાનાં ભ્રમં જનયતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","કિન્તુ યિહૂદીયાનાં ભયાત્ કોપિ તસ્ય પક્ષે સ્પષ્ટં નાકથયત્| ");
INSERT INTO sanguj_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","તતઃ પરમ્ ઉત્સવસ્ય મધ્યસમયે યીશુ ર્મન્દિરં ગત્વા સમુપદિશતિ સ્મ| ");
INSERT INTO sanguj_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","તતો યિહૂદીયા લોકા આશ્ચર્ય્યં જ્ઞાત્વાકથયન્ એષા માનુષો નાધીત્યા કથમ્ એતાદૃશો વિદ્વાનભૂત્? ");
INSERT INTO sanguj_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","તદા યીશુઃ પ્રત્યવોચદ્ ઉપદેશોયં ન મમ કિન્તુ યો માં પ્રેષિતવાન્ તસ્ય| ");
INSERT INTO sanguj_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","યો જનો નિદેશં તસ્ય ગ્રહીષ્યતિ મમોપદેશો મત્તો ભવતિ કિમ્ ઈશ્વરાદ્ ભવતિ સ ગનસ્તજ્જ્ઞાતું શક્ષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","યો જનઃ સ્વતઃ કથયતિ સ સ્વીયં ગૌરવમ્ ઈહતે કિન્તુ યઃ પ્રેરયિતુ ર્ગૌરવમ્ ઈહતે સ સત્યવાદી તસ્મિન્ કોપ્યધર્મ્મો નાસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","મૂસા યુષ્મભ્યં વ્યવસ્થાગ્રન્થં કિં નાદદાત્? કિન્તુ યુષ્માકં કોપિ તાં વ્યવસ્થાં ન સમાચરતિ| માં હન્તું કુતો યતધ્વે? ");
INSERT INTO sanguj_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","તદા લોકા અવદન્ ત્વં ભૂતગ્રસ્તસ્ત્વાં હન્તું કો યતતે? ");
INSERT INTO sanguj_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","તતો યીશુરવોચદ્ એકં કર્મ્મ મયાકારિ તસ્માદ્ યૂયં સર્વ્વ મહાશ્ચર્ય્યં મન્યધ્વે| ");
INSERT INTO sanguj_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","મૂસા યુષ્મભ્યં ત્વક્છેદવિધિં પ્રદદૌ સ મૂસાતો ન જાતઃ કિન્તુ પિતૃપુરુષેભ્યો જાતઃ તેન વિશ્રામવારેઽપિ માનુષાણાં ત્વક્છેદં કુરુથ| ");
INSERT INTO sanguj_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","અતએવ વિશ્રામવારે મનુષ્યાણાં ત્વક્છેદે કૃતે યદિ મૂસાવ્યવસ્થામઙ્ગનં ન ભવતિ તર્હિ મયા વિશ્રામવારે માનુષઃ સમ્પૂર્ણરૂપેણ સ્વસ્થોઽકારિ તત્કારણાદ્ યૂયં કિં મહ્યં કુપ્યથ? ");
INSERT INTO sanguj_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","સપક્ષપાતં વિચારમકૃત્વા ન્યાય્યં વિચારં કુરુત| ");
INSERT INTO sanguj_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","તદા યિરૂશાલમ્ નિવાસિનઃ કતિપયજના અકથયન્ ઇમે યં હન્તું ચેષ્ટન્તે સ એવાયં કિં ન? ");
INSERT INTO sanguj_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","કિન્તુ પશ્યત નિર્ભયઃ સન્ કથાં કથયતિ તથાપિ કિમપિ અ વદન્ત્યેતે અયમેવાભિષિક્ત્તો ભવતીતિ નિશ્ચિતં કિમધિપતયો જાનન્તિ? ");
INSERT INTO sanguj_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","મનુજોયં કસ્માદાગમદ્ ઇતિ વયં જાનોમઃ કિન્ત્વભિષિક્ત્ત આગતે સ કસ્માદાગતવાન્ ઇતિ કોપિ જ્ઞાતું ન શક્ષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","તદા યીશુ ર્મધ્યેમન્દિરમ્ ઉપદિશન્ ઉચ્ચૈઃકારમ્ ઉક્ત્તવાન્ યૂયં કિં માં જાનીથ? કસ્માચ્ચાગતોસ્મિ તદપિ કિં જાનીથ? નાહં સ્વત આગતોસ્મિ કિન્તુ યઃ સત્યવાદી સએવ માં પ્રેષિતવાન્ યૂયં તં ન જાનીથ| ");
INSERT INTO sanguj_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","તમહં જાને તેનાહં પ્રેરિત અગતોસ્મિ| ");
INSERT INTO sanguj_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","તસ્માદ્ યિહૂદીયાસ્તં ધર્ત્તુમ્ ઉદ્યતાસ્તથાપિ કોપિ તસ્ય ગાત્રે હસ્તં નાર્પયદ્ યતો હેતોસ્તદા તસ્ય સમયો નોપતિષ્ઠતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","કિન્તુ બહવો લોકાસ્તસ્મિન્ વિશ્વસ્ય કથિતવાન્તોઽભિષિક્ત્તપુરુષ આગત્ય માનુષસ્યાસ્ય ક્રિયાભ્યઃ કિમ્ અધિકા આશ્ચર્ય્યાઃ ક્રિયાઃ કરિષ્યતિ? ");
INSERT INTO sanguj_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","તતઃ પરં લોકાસ્તસ્મિન્ ઇત્થં વિવદન્તે ફિરૂશિનઃ પ્રધાનયાજકાઞ્ચેતિ શ્રુતવન્તસ્તં ધૃત્વા નેતું પદાતિગણં પ્રેષયામાસુઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","તતો યીશુરવદદ્ અહમ્ અલ્પદિનાનિ યુષ્માભિઃ સાર્દ્ધં સ્થિત્વા મત્પ્રેરયિતુઃ સમીપં યાસ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","માં મૃગયિષ્યધ્વે કિન્તૂદ્દેશં ન લપ્સ્યધ્વે રત્ર સ્થાસ્યામિ તત્ર યૂયં ગન્તું ન શક્ષ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","તદા યિહૂદીયાઃ પરસ્પરં વક્ત્તુમારેભિરે અસ્યોદ્દેશં ન પ્રાપ્સ્યામ એતાદૃશં કિં સ્થાનં યાસ્યતિ? ભિન્નદેશે વિકીર્ણાનાં યિહૂદીયાનાં સન્નિધિમ્ એષ ગત્વા તાન્ ઉપદેક્ષ્યતિ કિં? ");
INSERT INTO sanguj_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","નો ચેત્ માં ગવેષયિષ્યથ કિન્તૂદ્દેશં ન પ્રાપ્સ્યથ એષ કોદૃશં વાક્યમિદં વદતિ? ");
INSERT INTO sanguj_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","અનન્તરમ્ ઉત્સવસ્ય ચરમેઽહનિ અર્થાત્ પ્રધાનદિને યીશુરુત્તિષ્ઠન્ ઉચ્ચૈઃકારમ્ આહ્વયન્ ઉદિતવાન્ યદિ કશ્ચિત્ તૃષાર્ત્તો ભવતિ તર્હિ મમાન્તિકમ્ આગત્ય પિવતુ| ");
INSERT INTO sanguj_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","યઃ કશ્ચિન્મયિ વિશ્વસિતિ ધર્મ્મગ્રન્થસ્ય વચનાનુસારેણ તસ્યાભ્યન્તરતોઽમૃતતોયસ્ય સ્રોતાંસિ નિર્ગમિષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","યે તસ્મિન્ વિશ્વસન્તિ ત આત્માનં પ્રાપ્સ્યન્તીત્યર્થે સ ઇદં વાક્યં વ્યાહૃતવાન્ એતત્કાલં યાવદ્ યીશુ ર્વિભવં ન પ્રાપ્તસ્તસ્માત્ પવિત્ર આત્મા નાદીયત| ");
INSERT INTO sanguj_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","એતાં વાણીં શ્રુત્વા બહવો લોકા અવદન્ અયમેવ નિશ્ચિતં સ ભવિષ્યદ્વાદી| ");
INSERT INTO sanguj_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","કેચિદ્ અકથયન્ એષએવ સોભિષિક્ત્તઃ કિન્તુ કેચિદ્ અવદન્ સોભિષિક્ત્તઃ કિં ગાલીલ્ પ્રદેશે જનિષ્યતે? ");
INSERT INTO sanguj_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","સોભિષિક્ત્તો દાયૂદો વંશે દાયૂદો જન્મસ્થાને બૈત્લેહમિ પત્તને જનિષ્યતે ધર્મ્મગ્રન્થે કિમિત્થં લિખિતં નાસ્તિ? ");
INSERT INTO sanguj_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ઇત્થં તસ્મિન્ લોકાનાં ભિન્નવાક્યતા જાતા| ");
INSERT INTO sanguj_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","કતિપયલોકાસ્તં ધર્ત્તુમ્ ઐચ્છન્ તથાપિ તદ્વપુષિ કોપિ હસ્તં નાર્પયત્| ");
INSERT INTO sanguj_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","અનન્તરં પાદાતિગણે પ્રધાનયાજકાનાં ફિરૂશિનાઞ્ચ સમીપમાગતવતિ તે તાન્ અપૃચ્છન્ કુતો હેતોસ્તં નાનયત? ");
INSERT INTO sanguj_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","તદા પદાતયઃ પ્રત્યવદન્ સ માનવ ઇવ કોપિ કદાપિ નોપાદિશત્| ");
INSERT INTO sanguj_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","તતઃ ફિરૂશિનઃ પ્રાવોચન્ યૂયમપિ કિમભ્રામિષ્ટ? ");
INSERT INTO sanguj_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","અધિપતીનાં ફિરૂશિનાઞ્ચ કોપિ કિં તસ્મિન્ વ્યશ્વસીત્? ");
INSERT INTO sanguj_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","યે શાસ્ત્રં ન જાનન્તિ ત ઇમેઽધમલોકાએવ શાપગ્રસ્તાઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","તદા નિકદીમનામા તેષામેકો યઃ ક્ષણદાયાં યીશોઃ સન્નિધિમ્ અગાત્ સ ઉક્ત્તવાન્ ");
INSERT INTO sanguj_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","તસ્ય વાક્યે ન શ્રુતે કર્મ્મણિ ચ ન વિદિતે ઽસ્માકં વ્યવસ્થા કિં કઞ્ચન મનુજં દોષીકરોતિ? ");
INSERT INTO sanguj_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","તતસ્તે વ્યાહરન્ ત્વમપિ કિં ગાલીલીયલોકઃ? વિવિચ્ય પશ્ય ગલીલિ કોપિ ભવિષ્યદ્વાદી નોત્પદ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","તતઃ પરં સર્વ્વે સ્વં સ્વં ગૃહં ગતાઃ કિન્તુ યીશુ ર્જૈતુનનામાનં શિલોચ્ચયં ગતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","પ્રત્યૂષે યીશુઃ પનર્મન્દિરમ્ આગચ્છત્ ");
INSERT INTO sanguj_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","તતઃ સર્વ્વેષુ લોકેષુ તસ્ય સમીપ આગતેષુ સ ઉપવિશ્ય તાન્ ઉપદેષ્ટુમ્ આરભત| ");
INSERT INTO sanguj_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","તદા અધ્યાપકાઃ ફિરૂશિનઞ્ચ વ્યભિચારકર્મ્મણિ ધૃતં સ્ત્રિયમેકામ્ આનિય સર્વ્વેષાં મધ્યે સ્થાપયિત્વા વ્યાહરન્ ");
INSERT INTO sanguj_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","હે ગુરો યોષિતમ્ ઇમાં વ્યભિચારકર્મ્મ કુર્વ્વાણાં લોકા ધૃતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","એતાદૃશલોકાઃ પાષાણાઘાતેન હન્તવ્યા ઇતિ વિધિર્મૂસાવ્યવસ્થાગ્રન્થે લિખિતોસ્તિ કિન્તુ ભવાન્ કિમાદિશતિ? ");
INSERT INTO sanguj_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","તે તમપવદિતું પરીક્ષાભિપ્રાયેણ વાક્યમિદમ્ અપૃચ્છન્ કિન્તુ સ પ્રહ્વીભૂય ભૂમાવઙ્ગલ્યા લેખિતુમ્ આરભત| ");
INSERT INTO sanguj_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","તતસ્તૈઃ પુનઃ પુનઃ પૃષ્ટ ઉત્થાય કથિતવાન્ યુષ્માકં મધ્યે યો જનો નિરપરાધી સએવ પ્રથમમ્ એનાં પાષાણેનાહન્તુ| ");
INSERT INTO sanguj_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","પશ્ચાત્ સ પુનશ્ચ પ્રહ્વીભૂય ભૂમૌ લેખિતુમ્ આરભત| ");
INSERT INTO sanguj_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","તાં કથં શ્રુત્વા તે સ્વસ્વમનસિ પ્રબોધં પ્રાપ્ય જ્યેષ્ઠાનુક્રમં એકૈકશઃ સર્વ્વે બહિરગચ્છન્ તતો યીશુરેકાકી તયક્ત્તોભવત્ મધ્યસ્થાને દણ્ડાયમાના સા યોષા ચ સ્થિતા| ");
INSERT INTO sanguj_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","તત્પશ્ચાદ્ યીશુરુત્થાય તાં વનિતાં વિના કમપ્યપરં ન વિલોક્ય પૃષ્ટવાન્ હે વામે તવાપવાદકાઃ કુત્ર? કોપિ ત્વાં કિં ન દણ્ડયતિ? ");
INSERT INTO sanguj_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","સાવદત્ હે મહેચ્છ કોપિ ન તદા યીશુરવોચત્ નાહમપિ દણ્ડયામિ યાહિ પુનઃ પાપં માકાર્ષીઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","તતો યીશુઃ પુનરપિ લોકેભ્ય ઇત્થં કથયિતુમ્ આરભત જગતોહં જ્યોતિઃસ્વરૂપો યઃ કશ્ચિન્ મત્પશ્ચાદ ગચ્છતિ સ તિમિરે ન ભ્રમિત્વા જીવનરૂપાં દીપ્તિં પ્રાપ્સ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","તતઃ ફિરૂશિનોઽવાદિષુસ્ત્વં સ્વાર્થે સ્વયં સાક્ષ્યં દદાસિ તસ્માત્ તવ સાક્ષ્યં ગ્રાહ્યં ન ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","તદા યીશુઃ પ્રત્યુદિતવાન્ યદ્યપિ સ્વાર્થેઽહં સ્વયં સાક્ષ્યં દદામિ તથાપિ મત્ સાક્ષ્યં ગ્રાહ્યં યસ્માદ્ અહં કુત આગતોસ્મિ ક્વ યામિ ચ તદહં જાનામિ કિન્તુ કુત આગતોસ્મિ કુત્ર ગચ્છામિ ચ તદ્ યૂયં ન જાનીથ| ");
INSERT INTO sanguj_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","યૂયં લૌકિકં વિચારયથ નાહં કિમપિ વિચારયામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","કિન્તુ યદિ વિચારયામિ તર્હિ મમ વિચારો ગ્રહીતવ્યો યતોહમ્ એકાકી નાસ્મિ પ્રેરયિતા પિતા મયા સહ વિદ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","દ્વયો ર્જનયોઃ સાક્ષ્યં ગ્રહણીયં ભવતીતિ યુષ્માકં વ્યવસ્થાગ્રન્થે લિખિતમસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","અહં સ્વાર્થે સ્વયં સાક્ષિત્વં દદામિ યશ્ચ મમ તાતો માં પ્રેરિતવાન્ સોપિ મદર્થે સાક્ષ્યં દદાતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","તદા તેઽપૃચ્છન્ તવ તાતઃ કુત્ર? તતો યીશુઃ પ્રત્યવાદીદ્ યૂયં માં ન જાનીથ મત્પિતરઞ્ચ ન જાનીથ યદિ મામ્ અક્ષાસ્યત તર્હિ મમ તાતમપ્યક્ષાસ્યત| ");
INSERT INTO sanguj_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","યીશુ ર્મન્દિર ઉપદિશ્ય ભણ્ડાગારે કથા એતા અકથયત્ તથાપિ તં પ્રતિ કોપિ કરં નોદતોલયત્| ");
INSERT INTO sanguj_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","તતઃ પરં યીશુઃ પુનરુદિતવાન્ અધુનાહં ગચ્છામિ યૂયં માં ગવેષયિષ્યથ કિન્તુ નિજૈઃ પાપૈ ર્મરિષ્યથ યત્ સ્થાનમ્ અહં યાસ્યામિ તત્ સ્થાનમ્ યૂયં યાતું ન શક્ષ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","તદા યિહૂદીયાઃ પ્રાવોચન્ કિમયમ્ આત્મઘાતં કરિષ્યતિ? યતો યત્ સ્થાનમ્ અહં યાસ્યામિ તત્ સ્થાનમ્ યૂયં યાતું ન શક્ષ્યથ ઇતિ વાક્યં બ્રવીતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","તતો યીશુસ્તેભ્યઃ કથિતવાન્ યૂયમ્ અધઃસ્થાનીયા લોકા અહમ્ ઊર્દ્વ્વસ્થાનીયઃ યૂયમ્ એતજ્જગત્સમ્બન્ધીયા અહમ્ એતજ્જગત્સમ્બન્ધીયો ન| ");
INSERT INTO sanguj_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","તસ્માત્ કથિતવાન્ યૂયં નિજૈઃ પાપૈ ર્મરિષ્યથ યતોહં સ પુમાન્ ઇતિ યદિ ન વિશ્વસિથ તર્હિ નિજૈઃ પાપૈ ર્મરિષ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","તદા તે ઽપૃચ્છન્ કસ્ત્વં? તતો યીશુઃ કથિતવાન્ યુષ્માકં સન્નિધૌ યસ્ય પ્રસ્તાવમ્ આ પ્રથમાત્ કરોમિ સએવ પુરુષોહં| ");
INSERT INTO sanguj_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","યુષ્માસુ મયા બહુવાક્યં વક્ત્તવ્યં વિચારયિતવ્યઞ્ચ કિન્તુ મત્પ્રેરયિતા સત્યવાદી તસ્ય સમીપે યદહં શ્રુતવાન્ તદેવ જગતે કથયામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","કિન્તુ સ જનકે વાક્યમિદં પ્રોક્ત્તવાન્ ઇતિ તે નાબુધ્યન્ત| ");
INSERT INTO sanguj_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","તતો યીશુરકથયદ્ યદા મનુષ્યપુત્રમ્ ઊર્દ્વ્વ ઉત્થાપયિષ્યથ તદાહં સ પુમાન્ કેવલઃ સ્વયં કિમપિ કર્મ્મ ન કરોમિ કિન્તુ તાતો યથા શિક્ષયતિ તદનુસારેણ વાક્યમિદં વદામીતિ ચ યૂયં જ્ઞાતું શક્ષ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","મત્પ્રેરયિતા પિતા મામ્ એકાકિનં ન ત્યજતિ સ મયા સાર્દ્ધં તિષ્ઠતિ યતોહં તદભિમતં કર્મ્મ સદા કરોમિ| ");
INSERT INTO sanguj_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","તદા તસ્યૈતાનિ વાક્યાનિ શ્રુત્વા બહુવસ્તાસ્મિન્ વ્યશ્વસન્| ");
INSERT INTO sanguj_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","યે યિહૂદીયા વ્યશ્વસન્ યીશુસ્તેભ્યોઽકથયત્ ");
INSERT INTO sanguj_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","મમ વાક્યે યદિ યૂયમ્ આસ્થાં કુરુથ તર્હિ મમ શિષ્યા ભૂત્વા સત્યત્વં જ્ઞાસ્યથ તતઃ સત્યતયા યુષ્માકં મોક્ષો ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","તદા તે પ્રત્યવાદિષુઃ વયમ્ ઇબ્રાહીમો વંશઃ કદાપિ કસ્યાપિ દાસા ન જાતાસ્તર્હિ યુષ્માકં મુક્ત્તિ ર્ભવિષ્યતીતિ વાક્યં કથં બ્રવીષિ? ");
INSERT INTO sanguj_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","તદા યીશુઃ પ્રત્યવદદ્ યુષ્માનહં યથાર્થતરં વદામિ યઃ પાપં કરોતિ સ પાપસ્ય દાસઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","દાસશ્ચ નિરન્તરં નિવેશને ન તિષ્ઠતિ કિન્તુ પુત્રો નિરન્તરં તિષ્ઠતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","અતઃ પુત્રો યદિ યુષ્માન્ મોચયતિ તર્હિ નિતાન્તમેવ મુક્ત્તા ભવિષ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","યુયમ્ ઇબ્રાહીમો વંશ ઇત્યહં જાનામિ કિન્તુ મમ કથા યુષ્માકમ્ અન્તઃકરણેષુ સ્થાનં ન પ્રાપ્નુવન્તિ તસ્માદ્ધેતો ર્માં હન્તુમ્ ઈહધ્વે| ");
INSERT INTO sanguj_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","અહં સ્વપિતુઃ સમીપે યદપશ્યં તદેવ કથયામિ તથા યૂયમપિ સ્વપિતુઃ સમીપે યદપશ્યત તદેવ કુરુધ્વે| ");
INSERT INTO sanguj_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","તદા તે પ્રત્યવોચન્ ઇબ્રાહીમ્ અસ્માકં પિતા તતો યીશુરકથયદ્ યદિ યૂયમ્ ઇબ્રાહીમઃ સન્તાના અભવિષ્યત તર્હિ ઇબ્રાહીમ આચારણવદ્ આચરિષ્યત| ");
INSERT INTO sanguj_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ઈશ્વરસ્ય મુખાત્ સત્યં વાક્યં શ્રુત્વા યુષ્માન્ જ્ઞાપયામિ યોહં તં માં હન્તું ચેષ્ટધ્વે ઇબ્રાહીમ્ એતાદૃશં કર્મ્મ ન ચકાર| ");
INSERT INTO sanguj_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","યૂયં સ્વસ્વપિતુઃ કર્મ્માણિ કુરુથ તદા તૈરુક્ત્તં ન વયં જારજાતા અસ્માકમ્ એકએવ પિતાસ્તિ સ એવેશ્વરઃ ");
INSERT INTO sanguj_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","તતો યીશુના કથિતમ્ ઈશ્વરો યદિ યુષ્માકં તાતોભવિષ્યત્ તર્હિ યૂયં મયિ પ્રેમાકરિષ્યત યતોહમ્ ઈશ્વરાન્નિર્ગત્યાગતોસ્મિ સ્વતો નાગતોહં સ માં પ્રાહિણોત્| ");
INSERT INTO sanguj_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","યૂયં મમ વાક્યમિદં ન બુધ્યધ્વે કુતઃ? યતો યૂયં મમોપદેશં સોઢું ન શક્નુથ| ");
INSERT INTO sanguj_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","યૂયં શૈતાન્ પિતુઃ સન્તાના એતસ્માદ્ યુષ્માકં પિતુરભિલાષં પૂરયથ સ આ પ્રથમાત્ નરઘાતી તદન્તઃ સત્યત્વસ્ય લેશોપિ નાસ્તિ કારણાદતઃ સ સત્યતાયાં નાતિષ્ઠત્ સ યદા મૃષા કથયતિ તદા નિજસ્વભાવાનુસારેણૈવ કથયતિ યતો સ મૃષાભાષી મૃષોત્પાદકશ્ચ| ");
INSERT INTO sanguj_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","અહં તથ્યવાક્યં વદામિ કારણાદસ્માદ્ યૂયં માં ન પ્રતીથ| ");
INSERT INTO sanguj_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","મયિ પાપમસ્તીતિ પ્રમાણં યુષ્માકં કો દાતું શક્નોતિ? યદ્યહં તથ્યવાક્યં વદામિ તર્હિ કુતો માં ન પ્રતિથ? ");
INSERT INTO sanguj_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","યઃ કશ્ચન ઈશ્વરીયો લોકઃ સ ઈશ્વરીયકથાયાં મનો નિધત્તે યૂયમ્ ઈશ્વરીયલોકા ન ભવથ તન્નિદાનાત્ તત્ર ન મનાંસિ નિધદ્વે| ");
INSERT INTO sanguj_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","તદા યિહૂદીયાઃ પ્રત્યવાદિષુઃ ત્વમેકઃ શોમિરોણીયો ભૂતગ્રસ્તશ્ચ વયં કિમિદં ભદ્રં નાવાદિષ્મ? ");
INSERT INTO sanguj_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","તતો યીશુઃ પ્રત્યવાદીત્ નાહં ભૂતગ્રસ્તઃ કિન્તુ નિજતાતં સમ્મન્યે તસ્માદ્ યૂયં મામ્ અપમન્યધ્વે| ");
INSERT INTO sanguj_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","અહં સ્વસુખ્યાતિં ન ચેષ્ટે કિન્તુ ચેષ્ટિતા વિચારયિતા ચાપર એક આસ્તે| ");
INSERT INTO sanguj_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","અહં યુષ્મભ્યમ્ અતીવ યથાર્થં કથયામિ યો નરો મદીયં વાચં મન્યતે સ કદાચન નિધનં ન દ્રક્ષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","યિહૂદીયાસ્તમવદન્ ત્વં ભૂતગ્રસ્ત ઇતીદાનીમ્ અવૈષ્મ| ઇબ્રાહીમ્ ભવિષ્યદ્વાદિનઞ્ચ સર્વ્વે મૃતાઃ કિન્તુ ત્વં ભાષસે યો નરો મમ ભારતીં ગૃહ્લાતિ સ જાતુ નિધાનાસ્વાદં ન લપ્સ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","તર્હિ ત્વં કિમ્ અસ્માકં પૂર્વ્વપુરુષાદ્ ઇબ્રાહીમોપિ મહાન્? યસ્માત્ સોપિ મૃતઃ ભવિષ્યદ્વાદિનોપિ મૃતાઃ ત્વં સ્વં કં પુમાંસં મનુષે? ");
INSERT INTO sanguj_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","યીશુઃ પ્રત્યવોચદ્ યદ્યહં સ્વં સ્વયં સમ્મન્યે તર્હિ મમ તત્ સમ્મનનં કિમપિ ન કિન્તુ મમ તાતો યં યૂયં સ્વીયમ્ ઈશ્વરં ભાષધ્વે સએવ માં સમ્મનુતે| ");
INSERT INTO sanguj_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","યૂયં તં નાવગચ્છથ કિન્ત્વહં તમવગચ્છામિ તં નાવગચ્છામીતિ વાક્યં યદિ વદામિ તર્હિ યૂયમિવ મૃષાભાષી ભવામિ કિન્ત્વહં તમવગચ્છામિ તદાક્ષામપિ ગૃહ્લામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","યુષ્માકં પૂર્વ્વપુરુષ ઇબ્રાહીમ્ મમ સમયં દ્રષ્ટુમ્ અતીવાવાઞ્છત્ તન્નિરીક્ષ્યાનન્દચ્ચ| ");
INSERT INTO sanguj_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","તદા યિહૂદીયા અપૃચ્છન્ તવ વયઃ પઞ્ચાશદ્વત્સરા ન ત્વં કિમ્ ઇબ્રાહીમમ્ અદ્રાક્ષીઃ? ");
INSERT INTO sanguj_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","યીશુઃ પ્રત્યવાદીદ્ યુષ્માનહં યથાર્થતરં વદામિ ઇબ્રાહીમો જન્મનઃ પૂર્વ્વકાલમારભ્યાહં વિદ્યે| ");
INSERT INTO sanguj_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","તદા તે પાષાણાન્ ઉત્તોલ્ય તમાહન્તુમ્ ઉદયચ્છન્ કિન્તુ યીશુ ર્ગુપ્તો મન્તિરાદ્ બહિર્ગત્ય તેષાં મધ્યેન પ્રસ્થિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","તતઃ પરં યીશુર્ગચ્છન્ માર્ગમધ્યે જન્માન્ધં નરમ્ અપશ્યત્| ");
INSERT INTO sanguj_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","તતઃ શિષ્યાસ્તમ્ અપૃચ્છન્ હે ગુરો નરોયં સ્વપાપેન વા સ્વપિત્રાઃ પાપેનાન્ધોઽજાયત? ");
INSERT INTO sanguj_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","તતઃ સ પ્રત્યુદિતવાન્ એતસ્ય વાસ્ય પિત્રોઃ પાપાદ્ એતાદૃશોભૂદ ઇતિ નહિ કિન્ત્વનેન યથેશ્વરસ્ય કર્મ્મ પ્રકાશ્યતે તદ્ધેતોરેવ| ");
INSERT INTO sanguj_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","દિને તિષ્ઠતિ મત્પ્રેરયિતુઃ કર્મ્મ મયા કર્ત્તવ્યં યદા કિમપિ કર્મ્મ ન ક્રિયતે તાદૃશી નિશાગચ્છતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","અહં યાવત્કાલં જગતિ તિષ્ઠામિ તાવત્કાલં જગતો જ્યોતિઃસ્વરૂપોસ્મિ| ");
INSERT INTO sanguj_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ઇત્યુક્ત્તા ભૂમૌ નિષ્ઠીવં નિક્ષિપ્ય તેન પઙ્કં કૃતવાન્ ");
INSERT INTO sanguj_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","પશ્ચાત્ તત્પઙ્કેન તસ્યાન્ધસ્ય નેત્રે પ્રલિપ્ય તમિત્યાદિશત્ ગત્વા શિલોહે ઽર્થાત્ પ્રેરિતનામ્નિ સરસિ સ્નાહિ| તતોન્ધો ગત્વા તત્રાસ્નાત્ તતઃ પ્રન્નચક્ષુ ર્ભૂત્વા વ્યાઘુટ્યાગાત્| ");
INSERT INTO sanguj_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","અપરઞ્ચ સમીપવાસિનો લોકા યે ચ તં પૂર્વ્વમન્ધમ્ અપશ્યન્ તે બક્ત્તુમ્ આરભન્ત યોન્ધલોકો વર્ત્મન્યુપવિશ્યાભિક્ષત સ એવાયં જનઃ કિં ન ભવતિ? ");
INSERT INTO sanguj_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","કેચિદવદન્ સ એવ કેચિદવોચન્ તાદૃશો ભવતિ કિન્તુ સ સ્વયમબ્રવીત્ સ એવાહં ભવામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","અતએવ તે ઽપૃચ્છન્ ત્વં કથં દૃષ્ટિં પાપ્તવાન્? ");
INSERT INTO sanguj_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","તતઃ સોવદદ્ યીશનામક એકો જનો મમ નયને પઙ્કેન પ્રલિપ્ય ઇત્યાજ્ઞાપયત્ શિલોહકાસારં ગત્વા તત્ર સ્નાહિ| તતસ્તત્ર ગત્વા મયિ સ્નાતે દૃષ્ટિમહં લબ્ધવાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","તદા તે ઽવદન્ સ પુમાન્ કુત્ર? તેનોક્ત્તં નાહં જાનામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","અપરં તસ્મિન્ પૂર્વ્વાન્ધે જને ફિરૂશિનાં નિકટમ્ આનીતે સતિ ફિરૂશિનોપિ તમપૃચ્છન્ કથં દૃષ્ટિં પ્રાપ્તોસિ? ");
INSERT INTO sanguj_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","તતઃ સ કથિતવાન્ સ પઙ્કેન મમ નેત્રે ઽલિમ્પત્ પશ્ચાદ્ સ્નાત્વા દૃષ્ટિમલભે| ");
INSERT INTO sanguj_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","કિન્તુ યીશુ ર્વિશ્રામવારે કર્દ્દમં કૃત્વા તસ્ય નયને પ્રસન્નેઽકરોદ્ ઇતિકારણાત્ કતિપયફિરૂશિનોઽવદન્ ");
INSERT INTO sanguj_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","સ પુમાન્ ઈશ્વરાન્ન યતઃ સ વિશ્રામવારં ન મન્યતે| તતોન્યે કેચિત્ પ્રત્યવદન્ પાપી પુમાન્ કિમ્ એતાદૃશમ્ આશ્ચર્ય્યં કર્મ્મ કર્ત્તું શક્નોતિ? ");
INSERT INTO sanguj_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ઇત્થં તેષાં પરસ્પરં ભિન્નવાક્યત્વમ્ અભવત્| પશ્ચાત્ તે પુનરપિ તં પૂર્વ્વાન્ધં માનુષમ્ અપ્રાક્ષુઃ યો જનસ્તવ ચક્ષુષી પ્રસન્ને કૃતવાન્ તસ્મિન્ ત્વં કિં વદસિ? સ ઉક્ત્તવાન્ સ ભવિશદ્વાદી| ");
INSERT INTO sanguj_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","સ દૃષ્ટિમ્ આપ્તવાન્ ઇતિ યિહૂદીયાસ્તસ્ય દૃષ્ટિં પ્રાપ્તસ્ય જનસ્ય પિત્રો ર્મુખાદ્ અશ્રુત્વા ન પ્રત્યયન્| ");
INSERT INTO sanguj_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","અતએવ તે તાવપૃચ્છન્ યુવયો ર્યં પુત્રં જન્માન્ધં વદથઃ સ કિમયં? તર્હીદાનીં કથં દ્રષ્ટું શક્નોતિ? ");
INSERT INTO sanguj_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","તતસ્તસ્ય પિતરૌ પ્રત્યવોચતામ્ અયમ્ આવયોઃ પુત્ર આ જનેરન્ધશ્ચ તદપ્યાવાં જાનીવઃ ");
INSERT INTO sanguj_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","કિન્ત્વધુના કથં દૃષ્ટિં પ્રાપ્તવાન્ તદાવાં ન્ જાનીવઃ કોસ્ય ચક્ષુષી પ્રસન્ને કૃતવાન્ તદપિ ન જાનીવ એષ વયઃપ્રાપ્ત એનં પૃચ્છત સ્વકથાં સ્વયં વક્ષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","યિહૂદીયાનાં ભયાત્ તસ્ય પિતરૌ વાક્યમિદમ્ અવદતાં યતઃ કોપિ મનુષ્યો યદિ યીશુમ્ અભિષિક્તં વદતિ તર્હિ સ ભજનગૃહાદ્ દૂરીકારિષ્યતે યિહૂદીયા ઇતિ મન્ત્રણામ્ અકુર્વ્વન્ ");
INSERT INTO sanguj_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","અતસ્તસ્ય પિતરૌ વ્યાહરતામ્ એષ વયઃપ્રાપ્ત એનં પૃચ્છત| ");
INSERT INTO sanguj_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","તદા તે પુનશ્ચ તં પૂર્વ્વાન્ધમ્ આહૂય વ્યાહરન્ ઈશ્વરસ્ય ગુણાન્ વદ એષ મનુષ્યઃ પાપીતિ વયં જાનીમઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","તદા સ ઉક્ત્તવાન્ સ પાપી ન વેતિ નાહં જાને પૂર્વામન્ધ આસમહમ્ અધુના પશ્યામીતિ માત્રં જાનામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","તે પુનરપૃચ્છન્ સ ત્વાં પ્રતિ કિમકરોત્? કથં નેત્રે પ્રસન્ને ઽકરોત્? ");
INSERT INTO sanguj_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","તતઃ સોવાદીદ્ એકકૃત્વોકથયં યૂયં ન શૃણુથ તર્હિ કુતઃ પુનઃ શ્રોતુમ્ ઇચ્છથ? યૂયમપિ કિં તસ્ય શિષ્યા ભવિતુમ્ ઇચ્છથ? ");
INSERT INTO sanguj_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","તદા તે તં તિરસ્કૃત્ય વ્યાહરન્ ત્વં તસ્ય શિષ્યો વયં મૂસાઃ શિષ્યાઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","મૂસાવક્ત્રેણેશ્વરો જગાદ તજ્જાનીમઃ કિન્ત્વેષ કુત્રત્યલોક ઇતિ ન જાનીમઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","સોવદદ્ એષ મમ લોચને પ્રસન્ને ઽકરોત્ તથાપિ કુત્રત્યલોક ઇતિ યૂયં ન જાનીથ એતદ્ આશ્ચર્ય્યં ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ઈશ્વરઃ પાપિનાં કથાં ન શૃણોતિ કિન્તુ યો જનસ્તસ્મિન્ ભક્તિં કૃત્વા તદિષ્ટક્રિયાં કરોતિ તસ્યૈવ કથાં શૃણોતિ એતદ્ વયં જાનીમઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","કોપિ મનુષ્યો જન્માન્ધાય ચક્ષુષી અદદાત્ જગદારમ્ભાદ્ એતાદૃશીં કથાં કોપિ કદાપિ નાશૃણોત્| ");
INSERT INTO sanguj_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","અસ્માદ્ એષ મનુષ્યો યદીશ્વરાન્નાજાયત તર્હિ કિઞ્ચિદપીદૃશં કર્મ્મ કર્ત્તું નાશક્નોત્| ");
INSERT INTO sanguj_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","તે વ્યાહરન્ ત્વં પાપાદ્ અજાયથાઃ કિમસ્માન્ ત્વં શિક્ષયસિ? પશ્ચાત્તે તં બહિરકુર્વ્વન્| ");
INSERT INTO sanguj_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","તદનન્તરં યિહૂદીયૈઃ સ બહિરક્રિયત યીશુરિતિ વાર્ત્તાં શ્રુત્વા તં સાક્ષાત્ પ્રાપ્ય પૃષ્ટવાન્ ઈશ્વરસ્ય પુત્રે ત્વં વિશ્વસિષિ? ");
INSERT INTO sanguj_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","તદા સ પ્રત્યવોચત્ હે પ્રભો સ કો યત્ તસ્મિન્નહં વિશ્વસિમિ? ");
INSERT INTO sanguj_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","તતો યીશુઃ કથિતવાન્ ત્વં તં દૃષ્ટવાન્ ત્વયા સાકં યઃ કથં કથયતિ સએવ સઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","તદા હે પ્રભો વિશ્વસિમીત્યુક્ત્વા સ તં પ્રણામત્| ");
INSERT INTO sanguj_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","પશ્ચાદ્ યીશુઃ કથિતવાન્ નયનહીના નયનાનિ પ્રાપ્નુવન્તિ નયનવન્તશ્ચાન્ધા ભવન્તીત્યભિપ્રાયેણ જગદાહમ્ આગચ્છમ્| ");
INSERT INTO sanguj_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","એતત્ શ્રુત્વા નિકટસ્થાઃ કતિપયાઃ ફિરૂશિનો વ્યાહરન્ વયમપિ કિમન્ધાઃ? ");
INSERT INTO sanguj_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","તદા યીશુરવાદીદ્ યદ્યન્ધા અભવત તર્હિ પાપાનિ નાતિષ્ઠન્ કિન્તુ પશ્યામીતિ વાક્યવદનાદ્ યુષ્માકં પાપાનિ તિષ્ઠન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","અહં યુષ્માનતિયથાર્થં વદામિ, યો જનો દ્વારેણ ન પ્રવિશ્ય કેનાપ્યન્યેન મેષગૃહં પ્રવિશતિ સ એવ સ્તેનો દસ્યુશ્ચ| ");
INSERT INTO sanguj_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","યો દ્વારેણ પ્રવિશતિ સ એવ મેષપાલકઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","દૌવારિકસ્તસ્મૈ દ્વારં મોચયતિ મેષગણશ્ચ તસ્ય વાક્યં શૃણોતિ સ નિજાન્ મેષાન્ સ્વસ્વનામ્નાહૂય બહિઃ કૃત્વા નયતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","તથા નિજાન્ મેષાન્ બહિઃ કૃત્વા સ્વયં તેષામ્ અગ્રે ગચ્છતિ, તતો મેષાસ્તસ્ય શબ્દં બુધ્યન્તે, તસ્માત્ તસ્ય પશ્ચાદ્ વ્રજન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","કિન્તુ પરસ્ય શબ્દં ન બુધ્યન્તે તસ્માત્ તસ્ય પશ્ચાદ્ વ્રજિષ્યન્તિ વરં તસ્ય સમીપાત્ પલાયિષ્યન્તે| ");
INSERT INTO sanguj_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","યીશુસ્તેભ્ય ઇમાં દૃષ્ટાન્તકથામ્ અકથયત્ કિન્તુ તેન કથિતકથાયાસ્તાત્પર્ય્યં તે નાબુધ્યન્ત| ");
INSERT INTO sanguj_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","અતો યીશુઃ પુનરકથયત્, યુષ્માનાહં યથાર્થતરં વ્યાહરામિ, મેષગૃહસ્ય દ્વારમ્ અહમેવ| ");
INSERT INTO sanguj_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","મયા ન પ્રવિશ્ય ય આગચ્છન્ તે સ્તેના દસ્યવશ્ચ કિન્તુ મેષાસ્તેષાં કથા નાશૃણ્વન્| ");
INSERT INTO sanguj_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","અહમેવ દ્વારસ્વરૂપઃ, મયા યઃ કશ્ચિત પ્રવિશતિ સ રક્ષાં પ્રાપ્સ્યતિ તથા બહિરન્તશ્ચ ગમનાગમને કૃત્વા ચરણસ્થાનં પ્રાપ્સ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","યો જનસ્તેનઃ સ કેવલં સ્તૈન્યબધવિનાશાન્ કર્ત્તુમેવ સમાયાતિ કિન્ત્વહમ્ આયુ ર્દાતુમ્ અર્થાત્ બાહૂલ્યેન તદેવ દાતુમ્ આગચ્છમ્| ");
INSERT INTO sanguj_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","અહમેવ સત્યમેષપાલકો યસ્તુ સત્યો મેષપાલકઃ સ મેષાર્થં પ્રાણત્યાગં કરોતિ; ");
INSERT INTO sanguj_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","કિન્તુ યો જનો મેષપાલકો ન, અર્થાદ્ યસ્ય મેષા નિજા ન ભવન્તિ, ય એતાદૃશો વૈતનિકઃ સ વૃકમ્ આગચ્છન્તં દૃષ્ટ્વા મેજવ્રજં વિહાય પલાયતે, તસ્માદ્ વૃકસ્તં વ્રજં ધૃત્વા વિકિરતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","વૈતનિકઃ પલાયતે યતઃ સ વેતનાર્થી મેષાર્થં ન ચિન્તયતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","અહમેવ સત્યો મેષપાલકઃ, પિતા માં યથા જાનાતિ, અહઞ્ચ યથા પિતરં જાનામિ, ");
INSERT INTO sanguj_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","તથા નિજાન્ મેષાનપિ જાનામિ, મેષાશ્ચ માં જાનાન્તિ, અહઞ્ચ મેષાર્થં પ્રાણત્યાગં કરોમિ| ");
INSERT INTO sanguj_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","અપરઞ્ચ એતદ્ ગૃહીય મેષેભ્યો ભિન્ના અપિ મેષા મમ સન્તિ તે સકલા આનયિતવ્યાઃ; તે મમ શબ્દં શ્રોષ્યન્તિ તત એકો વ્રજ એકો રક્ષકો ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","પ્રાણાનહં ત્યક્ત્વા પુનઃ પ્રાણાન્ ગ્રહીષ્યામિ, તસ્માત્ પિતા મયિ સ્નેહં કરોતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","કશ્ચિજ્જનો મમ પ્રાણાન્ હન્તું ન શક્નોતિ કિન્તુ સ્વયં તાન્ સમર્પયામિ તાન્ સમર્પયિતું પુનર્ગ્રહીતુઞ્ચ મમ શક્તિરાસ્તે ભારમિમં સ્વપિતુઃ સકાશાત્ પ્રાપ્તોહમ્| ");
INSERT INTO sanguj_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","અસ્માદુપદેશાત્ પુનશ્ચ યિહૂદીયાનાં મધ્યે ભિન્નવાક્યતા જાતા| ");
INSERT INTO sanguj_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","તતો બહવો વ્યાહરન્ એષ ભૂતગ્રસ્ત ઉન્મત્તશ્ચ, કુત એતસ્ય કથાં શૃણુથ? ");
INSERT INTO sanguj_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","કેચિદ્ અવદન્ એતસ્ય કથા ભૂતગ્રસ્તસ્ય કથાવન્ન ભવન્તિ, ભૂતઃ કિમ્ અન્ધાય ચક્ષુષી દાતું શક્નોતિ? ");
INSERT INTO sanguj_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","શીતકાલે યિરૂશાલમિ મન્દિરોત્સર્ગપર્વ્વણ્યુપસ્થિતે ");
INSERT INTO sanguj_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","યીશુઃ સુલેમાનો નિઃસારેણ ગમનાગમને કરોતિ, ");
INSERT INTO sanguj_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","એતસ્મિન્ સમયે યિહૂદીયાસ્તં વેષ્ટયિત્વા વ્યાહરન્ કતિ કાલાન્ અસ્માકં વિચિકિત્સાં સ્થાપયિષ્યામિ? યદ્યભિષિક્તો ભવતિ તર્હિ તત્ સ્પષ્ટં વદ| ");
INSERT INTO sanguj_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","તદા યીશુઃ પ્રત્યવદદ્ અહમ્ અચકથં કિન્તુ યૂયં ન પ્રતીથ, નિજપિતુ ર્નામ્ના યાં યાં ક્રિયાં કરોમિ સા ક્રિયૈવ મમ સાક્ષિસ્વરૂપા| ");
INSERT INTO sanguj_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","કિન્ત્વહં પૂર્વ્વમકથયં યૂયં મમ મેષા ન ભવથ, કારણાદસ્માન્ ન વિશ્વસિથ| ");
INSERT INTO sanguj_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","મમ મેષા મમ શબ્દં શૃણ્વન્તિ તાનહં જાનામિ તે ચ મમ પશ્ચાદ્ ગચ્છન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","અહં તેભ્યોઽનન્તાયુ ર્દદામિ, તે કદાપિ ન નંક્ષ્યન્તિ કોપિ મમ કરાત્ તાન્ હર્ત્તું ન શક્ષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","યો મમ પિતા તાન્ મહ્યં દત્તવાન્ સ સર્વ્વસ્માત્ મહાન્, કોપિ મમ પિતુઃ કરાત્ તાન્ હર્ત્તું ન શક્ષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","અહં પિતા ચ દ્વયોરેકત્વમ્| ");
INSERT INTO sanguj_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","તતો યિહૂદીયાઃ પુનરપિ તં હન્તું પાષાણાન્ ઉદતોલયન્| ");
INSERT INTO sanguj_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","યીશુઃ કથિતવાન્ પિતુઃ સકાશાદ્ બહૂન્યુત્તમકર્મ્માણિ યુષ્માકં પ્રાકાશયં તેષાં કસ્ય કર્મ્મણઃ કારણાન્ માં પાષાણૈરાહન્તુમ્ ઉદ્યતાઃ સ્થ? ");
INSERT INTO sanguj_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","યિહૂદીયાઃ પ્રત્યવદન્ પ્રશસ્તકર્મ્મહેતો ર્ન કિન્તુ ત્વં માનુષઃ સ્વમીશ્વરમ્ ઉક્ત્વેશ્વરં નિન્દસિ કારણાદસ્માત્ ત્વાં પાષાણૈર્હન્મઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","તદા યીશુઃ પ્રત્યુક્તવાન્ મયા કથિતં યૂયમ્ ઈશ્વરા એતદ્વચનં યુષ્માકં શાસ્ત્રે લિખિતં નાસ્તિ કિં? ");
INSERT INTO sanguj_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","તસ્માદ્ યેષામ્ ઉદ્દેશે ઈશ્વરસ્ય કથા કથિતા તે યદીશ્વરગણા ઉચ્યન્તે ધર્મ્મગ્રન્થસ્યાપ્યન્યથા ભવિતું ન શક્યં, ");
INSERT INTO sanguj_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","તર્હ્યાહમ્ ઈશ્વરસ્ય પુત્ર ઇતિ વાક્યસ્ય કથનાત્ યૂયં પિત્રાભિષિક્તં જગતિ પ્રેરિતઞ્ચ પુમાંસં કથમ્ ઈશ્વરનિન્દકં વાદય? ");
INSERT INTO sanguj_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","યદ્યહં પિતુઃ કર્મ્મ ન કરોમિ તર્હિ માં ન પ્રતીત; ");
INSERT INTO sanguj_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","કિન્તુ યદિ કરોમિ તર્હિ મયિ યુષ્માભિઃ પ્રત્યયે ન કૃતેઽપિ કાર્ય્યે પ્રત્યયઃ ક્રિયતાં, તતો મયિ પિતાસ્તીતિ પિતર્ય્યહમ્ અસ્મીતિ ચ ક્ષાત્વા વિશ્વસિષ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","તદા તે પુનરપિ તં ધર્ત્તુમ્ અચેષ્ટન્ત કિન્તુ સ તેષાં કરેભ્યો નિસ્તીર્ય્ય ");
INSERT INTO sanguj_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","પુન ર્યર્દ્દન્ અદ્યાસ્તટે યત્ર પુર્વ્વં યોહન્ અમજ્જયત્ તત્રાગત્ય ન્યવસત્| ");
INSERT INTO sanguj_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","તતો બહવો લોકાસ્તત્સમીપમ્ આગત્ય વ્યાહરન્ યોહન્ કિમપ્યાશ્ચર્ય્યં કર્મ્મ નાકરોત્ કિન્ત્વસ્મિન્ મનુષ્યે યા યઃ કથા અકથયત્ તાઃ સર્વ્વાઃ સત્યાઃ; ");
INSERT INTO sanguj_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","તત્ર ચ બહવો લોકાસ્તસ્મિન્ વ્યશ્વસન્| ");
INSERT INTO sanguj_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","અનન્તરં મરિયમ્ તસ્યા ભગિની મર્થા ચ યસ્મિન્ વૈથનીયાગ્રામે વસતસ્તસ્મિન્ ગ્રામે ઇલિયાસર્ નામા પીડિત એક આસીત્| ");
INSERT INTO sanguj_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","યા મરિયમ્ પ્રભું સુગન્ધિતેલૈન મર્દ્દયિત્વા સ્વકેશૈસ્તસ્ય ચરણૌ સમમાર્જત્ તસ્યા ભ્રાતા સ ઇલિયાસર્ રોગી| ");
INSERT INTO sanguj_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","અપરઞ્ચ હે પ્રભો ભવાન્ યસ્મિન્ પ્રીયતે સ એવ પીડિતોસ્તીતિ કથાં કથયિત્વા તસ્ય ભગિન્યૌ પ્રેષિતવત્યૌ| ");
INSERT INTO sanguj_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","તદા યીશુરિમાં વાર્ત્તાં શ્રુત્વાકથયત પીડેયં મરણાર્થં ન કિન્ત્વીશ્વરસ્ય મહિમાર્થમ્ ઈશ્વરપુત્રસ્ય મહિમપ્રકાશાર્થઞ્ચ જાતા| ");
INSERT INTO sanguj_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","યીશુ ર્યદ્યપિમર્થાયાં તદ્ભગિન્યામ્ ઇલિયાસરિ ચાપ્રીયત, ");
INSERT INTO sanguj_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","તથાપિ ઇલિયાસરઃ પીડાયાઃ કથં શ્રુત્વા યત્ર આસીત્ તત્રૈવ દિનદ્વયમતિષ્ઠત્| ");
INSERT INTO sanguj_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","તતઃ પરમ્ સ શિષ્યાનકથયદ્ વયં પુન ર્યિહૂદીયપ્રદેશં યામઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","તતસ્તે પ્રત્યવદન્, હે ગુરો સ્વલ્પદિનાનિ ગતાનિ યિહૂદીયાસ્ત્વાં પાષાણૈ ર્હન્તુમ્ ઉદ્યતાસ્તથાપિ કિં પુનસ્તત્ર યાસ્યસિ? ");
INSERT INTO sanguj_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","યીશુઃ પ્રત્યવદત્, એકસ્મિન્ દિને કિં દ્વાદશઘટિકા ન ભવન્તિ? કોપિ દિવા ગચ્છન્ ન સ્ખલતિ યતઃ સ એતજ્જગતો દીપ્તિં પ્રાપ્નોતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","કિન્તુ રાત્રૌ ગચ્છન્ સ્ખલતિ યતો હેતોસ્તત્ર દીપ્તિ ર્નાસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ઇમાં કથાં કથયિત્વા સ તાનવદદ્, અસ્માકં બન્ધુઃ ઇલિયાસર્ નિદ્રિતોભૂદ્ ઇદાનીં તં નિદ્રાતો જાગરયિતું ગચ્છામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","યીશુ ર્મૃતૌ કથામિમાં કથિતવાન્ કિન્તુ વિશ્રામાર્થં નિદ્રાયાં કથિતવાન્ ઇતિ જ્ઞાત્વા શિષ્યા અકથયન્, ");
INSERT INTO sanguj_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","હે ગુરો સ યદિ નિદ્રાતિ તર્હિ ભદ્રમેવ| ");
INSERT INTO sanguj_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","તદા યીશુઃ સ્પષ્ટં તાન્ વ્યાહરત્, ઇલિયાસર્ અમ્રિયત; ");
INSERT INTO sanguj_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","કિન્તુ યૂયં યથા પ્રતીથ તદર્થમહં તત્ર ન સ્થિતવાન્ ઇત્યસ્માદ્ યુષ્મન્નિમિત્તમ્ આહ્લાદિતોહં, તથાપિ તસ્ય સમીપે યામ| ");
INSERT INTO sanguj_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","તદા થોમા યં દિદુમં વદન્તિ સ સઙ્ગિનઃ શિષ્યાન્ અવદદ્ વયમપિ ગત્વા તેન સાર્દ્ધં મ્રિયામહૈ| ");
INSERT INTO sanguj_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","યીશુસ્તત્રોપસ્થાય ઇલિયાસરઃ શ્મશાને સ્થાપનાત્ ચત્વારિ દિનાનિ ગતાનીતિ વાર્ત્તાં શ્રુતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","વૈથનીયા યિરૂશાલમઃ સમીપસ્થા ક્રોશૈકમાત્રાન્તરિતા; ");
INSERT INTO sanguj_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","તસ્માદ્ બહવો યિહૂદીયા મર્થાં મરિયમઞ્ચ ભ્યાતૃશોકાપન્નાં સાન્ત્વયિતું તયોઃ સમીપમ્ આગચ્છન્| ");
INSERT INTO sanguj_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","મર્થા યીશોરાગમનવાર્તાં શ્રુત્વૈવ તં સાક્ષાદ્ અકરોત્ કિન્તુ મરિયમ્ ગેહ ઉપવિશ્ય સ્થિતા| ");
INSERT INTO sanguj_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","તદા મર્થા યીશુમવાદત્, હે પ્રભો યદિ ભવાન્ અત્રાસ્થાસ્યત્ તર્હિ મમ ભ્રાતા નામરિષ્યત્| ");
INSERT INTO sanguj_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","કિન્ત્વિદાનીમપિ યદ્ ઈશ્વરે પ્રાર્થયિષ્યતે ઈશ્વરસ્તદ્ દાસ્યતીતિ જાનેઽહં| ");
INSERT INTO sanguj_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","યીશુરવાદીત્ તવ ભ્રાતા સમુત્થાસ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","મર્થા વ્યાહરત્ શેષદિવસે સ ઉત્થાનસમયે પ્રોત્થાસ્યતીતિ જાનેઽહં| ");
INSERT INTO sanguj_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","તદા યીશુઃ કથિતવાન્ અહમેવ ઉત્થાપયિતા જીવયિતા ચ યઃ કશ્ચન મયિ વિશ્વસિતિ સ મૃત્વાપિ જીવિષ્યતિ; ");
INSERT INTO sanguj_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","યઃ કશ્ચન ચ જીવન્ મયિ વિશ્વસિતિ સ કદાપિ ન મરિષ્યતિ, અસ્યાં કથાયાં કિં વિશ્વસિષિ? ");
INSERT INTO sanguj_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","સાવદત્ પ્રભો યસ્યાવતરણાપેક્ષાસ્તિ ભવાન્ સએવાભિષિક્ત્ત ઈશ્વરપુત્ર ઇતિ વિશ્વસિમિ| ");
INSERT INTO sanguj_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ઇતિ કથાં કથયિત્વા સા ગત્વા સ્વાં ભગિનીં મરિયમં ગુપ્તમાહૂય વ્યાહરત્ ગુરુરુપતિષ્ઠતિ ત્વામાહૂયતિ ચ| ");
INSERT INTO sanguj_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","કથામિમાં શ્રુત્વા સા તૂર્ણમ્ ઉત્થાય તસ્ય સમીપમ્ અગચ્છત્| ");
INSERT INTO sanguj_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","યીશુ ર્ગ્રામમધ્યં ન પ્રવિશ્ય યત્ર મર્થા તં સાક્ષાદ્ અકરોત્ તત્ર સ્થિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","યે યિહૂદીયા મરિયમા સાકં ગૃહે તિષ્ઠન્તસ્તામ્ અસાન્ત્વયન તે તાં ક્ષિપ્રમ્ ઉત્થાય ગચ્છન્તિં વિલોક્ય વ્યાહરન્, સ શ્મશાને રોદિતું યાતિ, ઇત્યુક્ત્વા તે તસ્યાઃ પશ્ચાદ્ અગચ્છન્| ");
INSERT INTO sanguj_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","યત્ર યીશુરતિષ્ઠત્ તત્ર મરિયમ્ ઉપસ્થાય તં દૃષ્ટ્વા તસ્ય ચરણયોઃ પતિત્વા વ્યાહરત્ હે પ્રભો યદિ ભવાન્ અત્રાસ્થાસ્યત્ તર્હિ મમ ભ્રાતા નામરિષ્યત્| ");
INSERT INTO sanguj_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","યીશુસ્તાં તસ્યાઃ સઙ્ગિનો યિહૂદીયાંશ્ચ રુદતો વિલોક્ય શોકાર્ત્તઃ સન્ દીર્ઘં નિશ્વસ્ય કથિતવાન્ તં કુત્રાસ્થાપયત? ");
INSERT INTO sanguj_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","તે વ્યાહરન્, હે પ્રભો ભવાન્ આગત્ય પશ્યતુ| ");
INSERT INTO sanguj_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","યીશુના ક્રન્દિતં| ");
INSERT INTO sanguj_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","અતએવ યિહૂદીયા અવદન્, પશ્યતાયં તસ્મિન્ કિદૃગ્ અપ્રિયત| ");
INSERT INTO sanguj_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","તેષાં કેચિદ્ અવદન્ યોન્ધાય ચક્ષુષી દત્તવાન્ સ કિમ્ અસ્ય મૃત્યું નિવારયિતું નાશક્નોત્? ");
INSERT INTO sanguj_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","તતો યીશુઃ પુનરન્તર્દીર્ઘં નિશ્વસ્ય શ્મશાનાન્તિકમ્ અગચ્છત્| તત્ શ્મશાનમ્ એકં ગહ્વરં તન્મુખે પાષાણ એક આસીત્| ");
INSERT INTO sanguj_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","તદા યીશુરવદદ્ એનં પાષાણમ્ અપસારયત, તતઃ પ્રમીતસ્ય ભગિની મર્થાવદત્ પ્રભો, અધુના તત્ર દુર્ગન્ધો જાતઃ, યતોદ્ય ચત્વારિ દિનાનિ શ્મશાને સ તિષ્ઠતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","તદા યીશુરવાદીત્, યદિ વિશ્વસિષિ તર્હીશ્વરસ્ય મહિમપ્રકાશં દ્રક્ષ્યસિ કથામિમાં કિં તુભ્યં નાકથયં? ");
INSERT INTO sanguj_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","તદા મૃતસ્ય શ્મશાનાત્ પાષાણોઽપસારિતે યીશુરૂર્દ્વ્વં પશ્યન્ અકથયત્, હે પિત ર્મમ નેવેસનમ્ અશૃણોઃ કારણાદસ્માત્ ત્વાં ધન્યં વદામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ત્વં સતતં શૃણોષિ તદપ્યહં જાનામિ, કિન્તુ ત્વં માં યત્ પ્રૈરયસ્તદ્ યથાસ્મિન્ સ્થાને સ્થિતા લોકા વિશ્વસન્તિ તદર્થમ્ ઇદં વાક્યં વદામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ઇમાં કથાં કથયિત્વા સ પ્રોચ્ચૈરાહ્વયત્, હે ઇલિયાસર્ બહિરાગચ્છ| ");
INSERT INTO sanguj_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","તતઃ સ પ્રમીતઃ શ્મશાનવસ્ત્રૈ ર્બદ્ધહસ્તપાદો ગાત્રમાર્જનવાસસા બદ્ધમુખશ્ચ બહિરાગચ્છત્| યીશુરુદિતવાન્ બન્ધનાનિ મોચયિત્વા ત્યજતૈનં| ");
INSERT INTO sanguj_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","મરિયમઃ સમીપમ્ આગતા યે યિહૂદીયલોકાસ્તદા યીશોરેતત્ કર્મ્માપશ્યન્ તેષાં બહવો વ્યશ્વસન્, ");
INSERT INTO sanguj_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","કિન્તુ કેચિદન્યે ફિરૂશિનાં સમીપં ગત્વા યીશોરેતસ્ય કર્મ્મણો વાર્ત્તામ્ અવદન્| ");
INSERT INTO sanguj_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","તતઃ પરં પ્રધાનયાજકાઃ ફિરૂશિનાશ્ચ સભાં કૃત્વા વ્યાહરન્ વયં કિં કુર્મ્મઃ? એષ માનવો બહૂન્યાશ્ચર્ય્યકર્મ્માણિ કરોતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","યદીદૃશં કર્મ્મ કર્ત્તું ન વારયામસ્તર્હિ સર્વ્વે લોકાસ્તસ્મિન્ વિશ્વસિષ્યન્તિ રોમિલોકાશ્ચાગત્યાસ્માકમ્ અનયા રાજધાન્યા સાર્દ્ધં રાજ્યમ્ આછેત્સ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","તદા તેષાં કિયફાનામા યસ્તસ્મિન્ વત્સરે મહાયાજકપદે ન્યયુજ્યત સ પ્રત્યવદદ્ યૂયં કિમપિ ન જાનીથ; ");
INSERT INTO sanguj_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","સમગ્રદેશસ્ય વિનાશતોપિ સર્વ્વલોકાર્થમ્ એકસ્ય જનસ્ય મરણમ્ અસ્માકં મઙ્ગલહેતુકમ્ એતસ્ય વિવેચનામપિ ન કુરુથ| ");
INSERT INTO sanguj_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","એતાં કથાં સ નિજબુદ્ધ્યા વ્યાહરદ્ ઇતિ ન, ");
INSERT INTO sanguj_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","કિન્તુ યીશૂસ્તદ્દેશીયાનાં કારણાત્ પ્રાણાન્ ત્યક્ષ્યતિ, દિશિ દિશિ વિકીર્ણાન્ ઈશ્વરસ્ય સન્તાનાન્ સંગૃહ્યૈકજાતિં કરિષ્યતિ ચ, તસ્મિન્ વત્સરે કિયફા મહાયાજકત્વપદે નિયુક્તઃ સન્ ઇદં ભવિષ્યદ્વાક્યં કથિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","તદ્દિનમારભ્ય તે કથં તં હન્તું શક્નુવન્તીતિ મન્ત્રણાં કર્ત્તું પ્રારેભિરે| ");
INSERT INTO sanguj_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","અતએવ યિહૂદીયાનાં મધ્યે યીશુઃ સપ્રકાશં ગમનાગમને અકૃત્વા તસ્માદ્ ગત્વા પ્રાન્તરસ્ય સમીપસ્થાયિપ્રદેશસ્યેફ્રાયિમ્ નામ્નિ નગરે શિષ્યૈઃ સાકં કાલં યાપયિતું પ્રારેભે| ");
INSERT INTO sanguj_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","અનન્તરં યિહૂદીયાનાં નિસ્તારોત્સવે નિકટવર્ત્તિનિ સતિ તદુત્સવાત્ પૂર્વ્વં સ્વાન્ શુચીન્ કર્ત્તું બહવો જના ગ્રામેભ્યો યિરૂશાલમ્ નગરમ્ આગચ્છન્, ");
INSERT INTO sanguj_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","યીશોરન્વેષણં કૃત્વા મન્દિરે દણ્ડાયમાનાઃ સન્તઃ પરસ્પરં વ્યાહરન્, યુષ્માકં કીદૃશો બોધો જાયતે? સ કિમ્ ઉત્સવેઽસ્મિન્ અત્રાગમિષ્યતિ? ");
INSERT INTO sanguj_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","સ ચ કુત્રાસ્તિ યદ્યેતત્ કશ્ચિદ્ વેત્તિ તર્હિ દર્શયતુ પ્રધાનયાજકાઃ ફિરૂશિનશ્ચ તં ધર્ત્તું પૂર્વ્વમ્ ઇમામ્ આજ્ઞાં પ્રાચારયન્| ");
INSERT INTO sanguj_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","નિસ્તારોત્સવાત્ પૂર્વ્વં દિનષટ્કે સ્થિતે યીશુ ર્યં પ્રમીતમ્ ઇલિયાસરં શ્મશાનાદ્ ઉદસ્થાપરત્ તસ્ય નિવાસસ્થાનં બૈથનિયાગ્રામમ્ આગચ્છત્| ");
INSERT INTO sanguj_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","તત્ર તદર્થં રજન્યાં ભોજ્યે કૃતે મર્થા પર્ય્યવેષયદ્ ઇલિયાસર્ ચ તસ્ય સઙ્ગિભિઃ સાર્દ્ધં ભોજનાસન ઉપાવિશત્| ");
INSERT INTO sanguj_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","તદા મરિયમ્ અર્દ્ધસેટકં બહુમૂલ્યં જટામાંસીયં તૈલમ્ આનીય યીશોશ્ચરણયો ર્મર્દ્દયિત્વા નિજકેશ ર્માર્ષ્ટુમ્ આરભત; તદા તૈલસ્ય પરિમલેન ગૃહમ્ આમોદિતમ્ અભવત્| ");
INSERT INTO sanguj_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","યઃ શિમોનઃ પુત્ર રિષ્કરિયોતીયો યિહૂદાનામા યીશું પરકરેષુ સમર્પયિષ્યતિ સ શિષ્યસ્તદા કથિતવાન્, ");
INSERT INTO sanguj_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","એતત્તૈલં ત્રિભિઃ શતૈ ર્મુદ્રાપદૈ ર્વિક્રીતં સદ્ દરિદ્રેભ્યઃ કુતો નાદીયત? ");
INSERT INTO sanguj_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","સ દરિદ્રલોકાર્થમ્ અચિન્તયદ્ ઇતિ ન, કિન્તુ સ ચૌર એવં તન્નિકટે મુદ્રાસમ્પુટકસ્થિત્યા તન્મધ્યે યદતિષ્ઠત્ તદપાહરત્ તસ્માત્ કારણાદ્ ઇમાં કથામકથયત્| ");
INSERT INTO sanguj_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","તદા યીશુરકથયદ્ એનાં મા વારય સા મમ શ્મશાનસ્થાપનદિનાર્થં તદરક્ષયત્| ");
INSERT INTO sanguj_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","દરિદ્રા યુષ્માકં સન્નિધૌ સર્વ્વદા તિષ્ઠન્તિ કિન્ત્વહં સર્વ્વદા યુષ્માકં સન્નિધૌ ન તિષ્ઠામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","તતઃ પરં યીશુસ્તત્રાસ્તીતિ વાર્ત્તાં શ્રુત્વા બહવો યિહૂદીયાસ્તં શ્મશાનાદુત્થાપિતમ્ ઇલિયાસરઞ્ચ દ્રષ્ટું તત્ સ્થાનમ્ આગચ્છન| ");
INSERT INTO sanguj_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","તદા પ્રધાનયાજકાસ્તમ્ ઇલિયાસરમપિ સંહર્ત્તુમ્ અમન્ત્રયન્ ; ");
INSERT INTO sanguj_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","યતસ્તેન બહવો યિહૂદીયા ગત્વા યીશૌ વ્યશ્વસન્| ");
INSERT INTO sanguj_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","અનન્તરં યીશુ ર્યિરૂશાલમ્ નગરમ્ આગચ્છતીતિ વાર્ત્તાં શ્રુત્વા પરેઽહનિ ઉત્સવાગતા બહવો લોકાઃ ");
INSERT INTO sanguj_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ખર્જ્જૂરપત્રાદ્યાનીય તં સાક્ષાત્ કર્ત્તું બહિરાગત્ય જય જયેતિ વાચં પ્રોચ્ચૈ ર્વક્તુમ્ આરભન્ત, ઇસ્રાયેલો યો રાજા પરમેશ્વરસ્ય નામ્નાગચ્છતિ સ ધન્યઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","તદા \"હે સિયોનઃ કન્યે મા ભૈષીઃ પશ્યાયં તવ રાજા ગર્દ્દભશાવકમ્ આરુહ્યાગચ્છતિ\" ");
INSERT INTO sanguj_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","ઇતિ શાસ્ત્રીયવચનાનુસારેણ યીશુરેકં યુવગર્દ્દભં પ્રાપ્ય તદુપર્ય્યારોહત્| ");
INSERT INTO sanguj_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","અસ્યાઃ ઘટનાયાસ્તાત્પર્ય્યં શિષ્યાઃ પ્રથમં નાબુધ્યન્ત, કિન્તુ યીશૌ મહિમાનં પ્રાપ્તે સતિ વાક્યમિદં તસ્મિન અકથ્યત લોકાશ્ચ તમ્પ્રતીત્થમ્ અકુર્વ્વન્ ઇતિ તે સ્મૃતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","સ ઇલિયાસરં શ્મશાનાદ્ આગન્તુમ્ આહ્વતવાન્ શ્મશાનાઞ્ચ ઉદસ્થાપયદ્ યે યે લોકાસ્તત્કર્મ્ય સાક્ષાદ્ અપશ્યન્ તે પ્રમાણં દાતુમ્ આરભન્ત| ");
INSERT INTO sanguj_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","સ એતાદૃશમ્ અદ્ભુતં કર્મ્મકરોત્ તસ્ય જનશ્રુતે ર્લોકાસ્તં સાક્ષાત્ કર્ત્તુમ્ આગચ્છન્| ");
INSERT INTO sanguj_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","તતઃ ફિરૂશિનઃ પરસ્પરં વક્તુમ્ આરભન્ત યુષ્માકં સર્વ્વાશ્ચેષ્ટા વૃથા જાતાઃ, ઇતિ કિં યૂયં ન બુધ્યધ્વે? પશ્યત સર્વ્વે લોકાસ્તસ્ય પશ્ચાદ્વર્ત્તિનોભવન્| ");
INSERT INTO sanguj_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ભજનં કર્ત્તુમ્ ઉત્સવાગતાનાં લોકાનાં કતિપયા જના અન્યદેશીયા આસન્ , ");
INSERT INTO sanguj_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","તે ગાલીલીયબૈત્સૈદાનિવાસિનઃ ફિલિપસ્ય સમીપમ્ આગત્ય વ્યાહરન્ હે મહેચ્છ વયં યીશું દ્રષ્ટુમ્ ઇચ્છામઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","તતઃ ફિલિપો ગત્વા આન્દ્રિયમ્ અવદત્ પશ્ચાદ્ આન્દ્રિયફિલિપૌ યીશવે વાર્ત્તામ્ અકથયતાં| ");
INSERT INTO sanguj_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","તદા યીશુઃ પ્રત્યુદિતવાન્ માનવસુતસ્ય મહિમપ્રાપ્તિસમય ઉપસ્થિતઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","અહં યુષ્માનતિયથાર્થં વદામિ, ધાન્યબીજં મૃત્તિકાયાં પતિત્વા યદિ ન મૃયતે તર્હ્યેકાકી તિષ્ઠતિ કિન્તુ યદિ મૃયતે તર્હિ બહુગુણં ફલં ફલતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","યો જનેा નિજપ્રાણાન્ પ્રિયાન્ જાનાતિ સ તાન્ હારયિષ્યતિ કિન્તુ યેा જન ઇહલોકે નિજપ્રાણાન્ અપ્રિયાન્ જાનાતિ સેाનન્તાયુઃ પ્રાપ્તું તાન્ રક્ષિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","કશ્ચિદ્ યદિ મમ સેવકો ભવિતું વાઞ્છતિ તર્હિ સ મમ પશ્ચાદ્ગામી ભવતુ, તસ્માદ્ અહં યત્ર તિષ્ઠામિ મમ સેવકેाપિ તત્ર સ્થાસ્યતિ; યો જનો માં સેવતે મમ પિતાપિ તં સમ્મંસ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","સામ્પ્રતં મમ પ્રાણા વ્યાકુલા ભવન્તિ, તસ્માદ્ હે પિતર એતસ્માત્ સમયાન્ માં રક્ષ, ઇત્યહં કિં પ્રાર્થયિષ્યે? કિન્ત્વહમ્ એતત્સમયાર્થમ્ અવતીર્ણવાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","હે પિત: સ્વનામ્નો મહિમાનં પ્રકાશય; તનૈવ સ્વનામ્નો મહિમાનમ્ અહં પ્રાકાશયં પુનરપિ પ્રકાશયિષ્યામિ, એષા ગગણીયા વાણી તસ્મિન્ સમયેઽજાયત| ");
INSERT INTO sanguj_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","તચ્શ્રુત્વા સમીપસ્થલોકાનાં કેચિદ્ અવદન્ મેઘોઽગર્જીત્, કેચિદ્ અવદન્ સ્વર્ગીયદૂતોઽનેન સહ કથામચકથત્| ");
INSERT INTO sanguj_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","તદા યીશુઃ પ્રત્યવાદીત્, મદર્થં શબ્દોયં નાભૂત્ યુષ્મદર્થમેવાભૂત્| ");
INSERT INTO sanguj_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","અધુના જગતોસ્ય વિચાર: સમ્પત્સ્યતે, અધુનાસ્ય જગત: પતી રાજ્યાત્ ચ્યોષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","યદ્યઈ પૃથિવ્યા ઊર્દ્વ્વે પ્રોત્થાપિતોસ્મિ તર્હિ સર્વ્વાન્ માનવાન્ સ્વસમીપમ્ આકર્ષિષ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","કથં તસ્ય મૃતિ ર્ભવિષ્યતિ, એતદ્ બોધયિતું સ ઇમાં કથામ્ અકથયત્| ");
INSERT INTO sanguj_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","તદા લોકા અકથયન્ સોભિષિક્તઃ સર્વ્વદા તિષ્ઠતીતિ વ્યવસ્થાગ્રન્થે શ્રુતમ્ અસ્માભિઃ, તર્હિ મનુષ્યપુત્રઃ પ્રોત્થાપિતો ભવિષ્યતીતિ વાક્યં કથં વદસિ? મનુષ્યપુત્રોયં કઃ? ");
INSERT INTO sanguj_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","તદા યીશુરકથાયદ્ યુષ્માભિઃ સાર્દ્ધમ્ અલ્પદિનાનિ જ્યોતિરાસ્તે, યથા યુષ્માન્ અન્ધકારો નાચ્છાદયતિ તદર્થં યાવત્કાલં યુષ્માભિઃ સાર્દ્ધં જ્યોતિસ્તિષ્ઠતિ તાવત્કાલં ગચ્છત; યો જનોઽન્ધકારે ગચ્છતિ સ કુત્ર યાતીતિ ન જાનાતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","અતએવ યાવત્કાલં યુષ્માકં નિકટે જ્યોતિરાસ્તે તાવત્કાલં જ્યોતીરૂપસન્તાના ભવિતું જ્યોતિષિ વિશ્વસિત; ઇમાં કથાં કથયિત્વા યીશુઃ પ્રસ્થાય તેભ્યઃ સ્વં ગુપ્તવાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","યદ્યપિ યીશુસ્તેષાં સમક્ષમ્ એતાવદાશ્ચર્ય્યકર્મ્માણિ કૃતવાન્ તથાપિ તે તસ્મિન્ ન વ્યશ્વસન્| ");
INSERT INTO sanguj_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","અતએવ કઃ પ્રત્યેતિ સુસંવાદં પરેશાસ્મત્ પ્રચારિતં? પ્રકાશતે પરેશસ્ય હસ્તઃ કસ્ય ચ સન્નિધૌ? યિશયિયભવિષ્યદ્વાદિના યદેતદ્ વાક્યમુક્તં તત્ સફલમ્ અભવત્| ");
INSERT INTO sanguj_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","તે પ્રત્યેતું નાશન્કુવન્ તસ્મિન્ યિશયિયભવિષ્યદ્વાદિ પુનરવાદીદ્, ");
INSERT INTO sanguj_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","યદા, \"તે નયનૈ ર્ન પશ્યન્તિ બુદ્ધિભિશ્ચ ન બુધ્યન્તે તૈ ર્મનઃસુ પરિવર્ત્તિતેષુ ચ તાનહં યથા સ્વસ્થાન્ ન કરોમિ તથા સ તેષાં લોચનાન્યન્ધાનિ કૃત્વા તેષામન્તઃકરણાનિ ગાઢાનિ કરિષ્યતિ| \" ");
INSERT INTO sanguj_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","યિશયિયો યદા યીશો ર્મહિમાનં વિલોક્ય તસ્મિન્ કથામકથયત્ તદા ભવિષ્યદ્વાક્યમ્ ઈદૃશં પ્રકાશયત્| ");
INSERT INTO sanguj_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","તથાપ્યધિપતિનાં બહવસ્તસ્મિન્ પ્રત્યાયન્| કિન્તુ ફિરૂશિનસ્તાન્ ભજનગૃહાદ્ દૂરીકુર્વ્વન્તીતિ ભયાત્ તે તં ન સ્વીકૃતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","યત ઈશ્વરસ્ય પ્રશંસાતો માનવાનાં પ્રશંસાયાં તેઽપ્રિયન્ત| ");
INSERT INTO sanguj_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","તદા યીશુરુચ્ચૈઃકારમ્ અકથયદ્ યો જનો મયિ વિશ્વસિતિ સ કેવલે મયિ વિશ્વસિતીતિ ન, સ મત્પ્રેરકેઽપિ વિશ્વસિતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","યો જનો માં પશ્યતિ સ મત્પ્રેરકમપિ પશ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","યો જનો માં પ્રત્યેતિ સ યથાન્ધકારે ન તિષ્ઠતિ તદર્થમ્ અહં જ્યોતિઃસ્વરૂપો ભૂત્વા જગત્યસ્મિન્ અવતીર્ણવાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","મમ કથાં શ્રુત્વા યદિ કશ્ચિન્ ન વિશ્વસિતિ તર્હિ તમહં દોષિણં ન કરોમિ, યતો હેતો ર્જગતો જનાનાં દોષાન્ નિશ્ચિતાન્ કર્ત્તું નાગત્ય તાન્ પરિચાતુમ્ આગતોસ્મિ| ");
INSERT INTO sanguj_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","યઃ કશ્ચિન્ માં ન શ્રદ્ધાય મમ કથં ન ગૃહ્લાતિ, અન્યસ્તં દોષિણં કરિષ્યતિ વસ્તુતસ્તુ યાં કથામહમ્ અચકથં સા કથા ચરમેઽન્હિ તં દોષિણં કરિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","યતો હેતોરહં સ્વતઃ કિમપિ ન કથયામિ, કિં કિં મયા કથયિતવ્યં કિં સમુપદેષ્ટવ્યઞ્ચ ઇતિ મત્પ્રેરયિતા પિતા મામાજ્ઞાપયત્| ");
INSERT INTO sanguj_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","તસ્ય સાજ્ઞા અનન્તાયુરિત્યહં જાનામિ, અતએવાહં યત્ કથયામિ તત્ પિતા યથાજ્ઞાપયત્ તથૈવ કથયામ્યહમ્| ");
INSERT INTO sanguj_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","નિસ્તારોત્સવસ્ય કિઞ્ચિત્કાલાત્ પૂર્વ્વં પૃથિવ્યાઃ પિતુઃ સમીપગમનસ્ય સમયઃ સન્નિકર્ષોભૂદ્ ઇતિ જ્ઞાત્વા યીશુરાપ્રથમાદ્ યેષુ જગત્પ્રવાસિષ્વાત્મીયલોકેષ પ્રેમ કરોતિ સ્મ તેષુ શેષં યાવત્ પ્રેમ કૃતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","પિતા તસ્ય હસ્તે સર્વ્વં સમર્પિતવાન્ સ્વયમ્ ઈશ્વરસ્ય સમીપાદ્ આગચ્છદ્ ઈશ્વરસ્ય સમીપં યાસ્યતિ ચ, સર્વ્વાણ્યેતાનિ જ્ઞાત્વા રજન્યાં ભોજને સમ્પૂર્ણે સતિ, ");
INSERT INTO sanguj_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","યદા શૈતાન્ તં પરહસ્તેષુ સમર્પયિતું શિમોનઃ પુત્રસ્ય ઈષ્કારિયોતિયસ્ય યિહૂદા અન્તઃકરણે કુપ્રવૃત્તિં સમાર્પયત્, ");
INSERT INTO sanguj_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","તદા યીશુ ર્ભોજનાસનાદ્ ઉત્થાય ગાત્રવસ્ત્રં મોચયિત્વા ગાત્રમાર્જનવસ્ત્રં ગૃહીત્વા તેન સ્વકટિમ્ અબધ્નાત્, ");
INSERT INTO sanguj_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","પશ્ચાદ્ એકપાત્રે જલમ્ અભિષિચ્ય શિષ્યાણાં પાદાન્ પ્રક્ષાલ્ય તેન કટિબદ્ધગાત્રમાર્જનવાસસા માર્ષ્ટું પ્રારભત| ");
INSERT INTO sanguj_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","તતઃ શિમોન્પિતરસ્ય સમીપમાગતે સ ઉક્તવાન્ હે પ્રભો ભવાન્ કિં મમ પાદૌ પ્રક્ષાલયિષ્યતિ? ");
INSERT INTO sanguj_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","યીશુરુદિતવાન્ અહં યત્ કરોમિ તત્ સમ્પ્રતિ ન જાનાસિ કિન્તુ પશ્ચાજ્ જ્ઞાસ્યસિ| ");
INSERT INTO sanguj_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","તતઃ પિતરઃ કથિતવાન્ ભવાન્ કદાપિ મમ પાદૌ ન પ્રક્ષાલયિષ્યતિ| યીશુરકથયદ્ યદિ ત્વાં ન પ્રક્ષાલયે તર્હિ મયિ તવ કોપ્યંશો નાસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","તદા શિમોન્પિતરઃ કથિતવાન્ હે પ્રભો તર્હિ કેવલપાદૌ ન, મમ હસ્તૌ શિરશ્ચ પ્રક્ષાલયતુ| ");
INSERT INTO sanguj_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","તતો યીશુરવદદ્ યો જનો ધૌતસ્તસ્ય સર્વ્વાઙ્ગપરિષ્કૃતત્વાત્ પાદૌ વિનાન્યાઙ્ગસ્ય પ્રક્ષાલનાપેક્ષા નાસ્તિ| યૂયં પરિષ્કૃતા ઇતિ સત્યં કિન્તુ ન સર્વ્વે, ");
INSERT INTO sanguj_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","યતો યો જનસ્તં પરકરેષુ સમર્પયિષ્યતિ તં સ જ્ઞાતવાન; અતએવ યૂયં સર્વ્વે ન પરિષ્કૃતા ઇમાં કથાં કથિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ઇત્થં યીશુસ્તેષાં પાદાન્ પ્રક્ષાલ્ય વસ્ત્રં પરિધાયાસને સમુપવિશ્ય કથિતવાન્ અહં યુષ્માન્ પ્રતિ કિં કર્મ્માકાર્ષં જાનીથ? ");
INSERT INTO sanguj_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","યૂયં માં ગુરું પ્રભુઞ્ચ વદથ તત્ સત્યમેવ વદથ યતોહં સએવ ભવામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","યદ્યહં પ્રભુ ર્ગુરુશ્ચ સન્ યુષ્માકં પાદાન્ પ્રક્ષાલિતવાન્ તર્હિ યુષ્માકમપિ પરસ્પરં પાદપ્રક્ષાલનમ્ ઉચિતમ્| ");
INSERT INTO sanguj_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","અહં યુષ્માન્ પ્રતિ યથા વ્યવાહરં યુષ્માન્ તથા વ્યવહર્ત્તુમ્ એકં પન્થાનં દર્શિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","અહં યુષ્માનતિયથાર્થં વદામિ, પ્રભો ર્દાસો ન મહાન્ પ્રેરકાચ્ચ પ્રેરિતો ન મહાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ઇમાં કથાં વિદિત્વા યદિ તદનુસારતઃ કર્મ્માણિ કુરુથ તર્હિ યૂયં ધન્યા ભવિષ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","સર્વ્વેષુ યુષ્માસુ કથામિમાં કથયામિ ઇતિ ન, યે મમ મનોનીતાસ્તાનહં જાનામિ, કિન્તુ મમ ભક્ષ્યાણિ યો ભુઙ્ક્તે મત્પ્રાણપ્રાતિકૂલ્યતઃ| ઉત્થાપયતિ પાદસ્ય મૂલં સ એષ માનવઃ| યદેતદ્ ધર્મ્મપુસ્તકસ્ય વચનં તદનુસારેણાવશ્યં ઘટિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","અહં સ જન ઇત્યત્ર યથા યુષ્માકં વિશ્વાસો જાયતે તદર્થં એતાદૃશઘટનાત્ પૂર્વ્વમ્ અહમિદાનીં યુષ્મભ્યમકથયમ્| ");
INSERT INTO sanguj_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","અહં યુષ્માનતીવ યથાર્થં વદામિ, મયા પ્રેરિતં જનં યો ગૃહ્લાતિ સ મામેવ ગૃહ્લાતિ યશ્ચ માં ગૃહ્લાતિ સ મત્પ્રેરકં ગૃહ્લાતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","એતાં કથાં કથયિત્વા યીશુ ર્દુઃખી સન્ પ્રમાણં દત્ત્વા કથિતવાન્ અહં યુષ્માનતિયથાર્થં વદામિ યુષ્માકમ્ એકો જનો માં પરકરેષુ સમર્પયિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","તતઃ સ કમુદ્દિશ્ય કથામેતાં કથિતવાન્ ઇત્યત્ર સન્દિગ્ધાઃ શિષ્યાઃ પરસ્પરં મુખમાલોકયિતું પ્રારભન્ત| ");
INSERT INTO sanguj_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","તસ્મિન્ સમયે યીશુ ર્યસ્મિન્ અપ્રીયત સ શિષ્યસ્તસ્ય વક્ષઃસ્થલમ્ અવાલમ્બત| ");
INSERT INTO sanguj_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","શિમોન્પિતરસ્તં સઙ્કેતેનાવદત્, અયં કમુદ્દિશ્ય કથામેતામ્ કથયતીતિ પૃચ્છ| ");
INSERT INTO sanguj_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","તદા સ યીશો ર્વક્ષઃસ્થલમ્ અવલમ્બ્ય પૃષ્ઠવાન્, હે પ્રભો સ જનઃ કઃ? ");
INSERT INTO sanguj_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","તતો યીશુઃ પ્રત્યવદદ્ એકખણ્ડં પૂપં મજ્જયિત્વા યસ્મૈ દાસ્યામિ સએવ સઃ; પશ્ચાત્ પૂપખણ્ડમેકં મજ્જયિત્વા શિમોનઃ પુત્રાય ઈષ્કરિયોતીયાય યિહૂદૈ દત્તવાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","તસ્મિન્ દત્તે સતિ શૈતાન્ તમાશ્રયત્; તદા યીશુસ્તમ્ અવદત્ ત્વં યત્ કરિષ્યસિ તત્ ક્ષિપ્રં કુરુ| ");
INSERT INTO sanguj_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","કિન્તુ સ યેનાશયેન તાં કથામકથાયત્ તમ્ ઉપવિષ્ટલોકાનાં કોપિ નાબુધ્યત; ");
INSERT INTO sanguj_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","કિન્તુ યિહૂદાઃ સમીપે મુદ્રાસમ્પુટકસ્થિતેઃ કેચિદ્ ઇત્થમ્ અબુધ્યન્ત પાર્વ્વણાસાદનાર્થં કિમપિ દ્રવ્યં ક્રેતું વા દરિદ્રેભ્યઃ કિઞ્ચિદ્ વિતરિતું કથિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","તદા પૂપખણ્ડગ્રહણાત્ પરં સ તૂર્ણં બહિરગચ્છત્; રાત્રિશ્ચ સમુપસ્યિતા| ");
INSERT INTO sanguj_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","યિહૂદે બહિર્ગતે યીશુરકથયદ્ ઇદાનીં માનવસુતસ્ય મહિમા પ્રકાશતે તેનેશ્વરસ્યાપિ મહિમા પ્રકાશતે| ");
INSERT INTO sanguj_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","યદિ તેનેશ્વરસ્ય મહિમા પ્રકાશતે તર્હીશ્વરોપિ સ્વેન તસ્ય મહિમાનં પ્રકાશયિષ્યતિ તૂર્ણમેવ પ્રકાશયિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","હે વત્સા અહં યુષ્માભિઃ સાર્દ્ધં કિઞ્ચિત્કાલમાત્રમ્ આસે, તતઃ પરં માં મૃગયિષ્યધ્વે કિન્ત્વહં યત્સ્થાનં યામિ તત્સ્થાનં યૂયં ગન્તું ન શક્ષ્યથ, યામિમાં કથાં યિહૂદીયેભ્યઃ કથિતવાન્ તથાધુના યુષ્મભ્યમપિ કથયામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","યૂયં પરસ્પરં પ્રીયધ્વમ્ અહં યુષ્માસુ યથા પ્રીયે યૂયમપિ પરસ્પરમ્ તથૈવ પ્રીયધ્વં, યુષ્માન્ ઇમાં નવીનામ્ આજ્ઞામ્ આદિશામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","તેનૈવ યદિ પરસ્પરં પ્રીયધ્વે તર્હિ લક્ષણેનાનેન યૂયં મમ શિષ્યા ઇતિ સર્વ્વે જ્ઞાતું શક્ષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","શિમોનપિતરઃ પૃષ્ઠવાન્ હે પ્રભો ભવાન્ કુત્ર યાસ્યતિ? તતો યીશુઃ પ્રત્યવદત્, અહં યત્સ્થાનં યામિ તત્સ્થાનં સામ્પ્રતં મમ પશ્ચાદ્ ગન્તું ન શક્નોષિ કિન્તુ પશ્ચાદ્ ગમિષ્યસિ| ");
INSERT INTO sanguj_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","તદા પિતરઃ પ્રત્યુદિતવાન્, હે પ્રભો સામ્પ્રતં કુતો હેતોસ્તવ પશ્ચાદ્ ગન્તું ન શક્નોમિ? ત્વદર્થં પ્રાણાન્ દાતું શક્નોમિ| ");
INSERT INTO sanguj_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","તતો યીશુઃ પ્રત્યુક્તવાન્ મન્નિમિત્તં કિં પ્રાણાન્ દાતું શક્નોષિ? ત્વામહં યથાર્થં વદામિ, કુક્કુટરવણાત્ પૂર્વ્વં ત્વં ત્રિ ર્મામ્ અપહ્નોષ્યસે| ");
INSERT INTO sanguj_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","મનોદુઃખિનો મા ભૂત; ઈશ્વરે વિશ્વસિત મયિ ચ વિશ્વસિત| ");
INSERT INTO sanguj_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","મમ પિતુ ગૃહે બહૂનિ વાસસ્થાનિ સન્તિ નો ચેત્ પૂર્વ્વં યુષ્માન્ અજ્ઞાપયિષ્યં યુષ્મદર્થં સ્થાનં સજ્જયિતું ગચ્છામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","યદિ ગત્વાહં યુષ્મન્નિમિત્તં સ્થાનં સજ્જયામિ તર્હિ પનરાગત્ય યુષ્માન્ સ્વસમીપં નેષ્યામિ, તતો યત્રાહં તિષ્ઠામિ તત્ર યૂયમપિ સ્થાસ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","અહં યત્સ્થાનં બ્રજામિ તત્સ્થાનં યૂયં જાનીથ તસ્ય પન્થાનમપિ જાનીથ| ");
INSERT INTO sanguj_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","તદા થોમા અવદત્, હે પ્રભો ભવાન્ કુત્ર યાતિ તદ્વયં ન જાનીમઃ, તર્હિ કથં પન્થાનં જ્ઞાતું શક્નુમઃ? ");
INSERT INTO sanguj_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","યીશુરકથયદ્ અહમેવ સત્યજીવનરૂપપથો મયા ન ગન્તા કોપિ પિતુઃ સમીપં ગન્તું ન શક્નોતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","યદિ મામ્ અજ્ઞાસ્યત તર્હિ મમ પિતરમપ્યજ્ઞાસ્યત કિન્ત્વધુનાતસ્તં જાનીથ પશ્યથ ચ| ");
INSERT INTO sanguj_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","તદા ફિલિપઃ કથિતવાન્, હે પ્રભો પિતરં દર્શય તસ્માદસ્માકં યથેષ્ટં ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","તતો યીશુઃ પ્રત્યાવાદીત્, હે ફિલિપ યુષ્માભિઃ સાર્દ્ધમ્ એતાવદ્દિનાનિ સ્થિતમપિ માં કિં ન પ્રત્યભિજાનાસિ? યો જનો મામ્ અપશ્યત્ સ પિતરમપ્યપશ્યત્ તર્હિ પિતરમ્ અસ્માન્ દર્શયેતિ કથાં કથં કથયસિ? ");
INSERT INTO sanguj_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","અહં પિતરિ તિષ્ઠામિ પિતા મયિ તિષ્ઠતીતિ કિં ત્વં ન પ્રત્યષિ? અહં યદ્વાક્યં વદામિ તત્ સ્વતો ન વદામિ કિન્તુ યઃ પિતા મયિ વિરાજતે સ એવ સર્વ્વકર્મ્માણિ કરાતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","અતએવ પિતર્ય્યહં તિષ્ઠામિ પિતા ચ મયિ તિષ્ઠતિ મમાસ્યાં કથાયાં પ્રત્યયં કુરુત, નો ચેત્ કર્મ્મહેતોઃ પ્રત્યયં કુરુત| ");
INSERT INTO sanguj_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","અહં યુષ્માનતિયથાર્થં વદામિ, યો જનો મયિ વિશ્વસિતિ સોહમિવ કર્મ્માણિ કરિષ્યતિ વરં તતોપિ મહાકર્મ્માણિ કરિષ્યતિ યતો હેતોરહં પિતુઃ સમીપં ગચ્છામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","યથા પુત્રેણ પિતુ ર્મહિમા પ્રકાશતે તદર્થં મમ નામ પ્રોચ્ય યત્ પ્રાર્થયિષ્યધ્વે તત્ સફલં કરિષ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","યદિ મમ નામ્ના યત્ કિઞ્ચિદ્ યાચધ્વે તર્હિ તદહં સાધયિષ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","યદિ મયિ પ્રીયધ્વે તર્હિ મમાજ્ઞાઃ સમાચરત| ");
INSERT INTO sanguj_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","તતો મયા પિતુઃ સમીપે પ્રાર્થિતે પિતા નિરન્તરં યુષ્માભિઃ સાર્દ્ધં સ્થાતુમ્ ઇતરમેકં સહાયમ્ અર્થાત્ સત્યમયમ્ આત્માનં યુષ્માકં નિકટં પ્રેષયિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","એતજ્જગતો લોકાસ્તં ગ્રહીતું ન શક્નુવન્તિ યતસ્તે તં નાપશ્યન્ નાજનંશ્ચ કિન્તુ યૂયં જાનીથ યતો હેતોઃ સ યુષ્માકમન્ત ર્નિવસતિ યુષ્માકં મધ્યે સ્થાસ્યતિ ચ| ");
INSERT INTO sanguj_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","અહં યુષ્માન્ અનાથાન્ કૃત્વા ન યાસ્યામિ પુનરપિ યુષ્માકં સમીપમ્ આગમિષ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","કિયત્કાલરત્ પરમ્ અસ્ય જગતો લોકા માં પુન ર્ન દ્રક્ષ્યન્તિ કિન્તુ યૂયં દ્રક્ષ્યથ;અહં જીવિષ્યામિ તસ્માત્ કારણાદ્ યૂયમપિ જીવિષ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","પિતર્ય્યહમસ્મિ મયિ ચ યૂયં સ્થ, તથાહં યુષ્માસ્વસ્મિ તદપિ તદા જ્ઞાસ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","યો જનો મમાજ્ઞા ગૃહીત્વા તા આચરતિ સએવ મયિ પ્રીયતે; યો જનશ્ચ મયિ પ્રીયતે સએવ મમ પિતુઃ પ્રિયપાત્રં ભવિષ્યતિ, તથાહમપિ તસ્મિન્ પ્રીત્વા તસ્મૈ સ્વં પ્રકાશયિષ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","તદા ઈષ્કરિયોતીયાદ્ અન્યો યિહૂદાસ્તમવદત્, હે પ્રભો ભવાન્ જગતો લોકાનાં સન્નિધૌ પ્રકાશિતો ન ભૂત્વાસ્માકં સન્નિધૌ કુતઃ પ્રકાશિતો ભવિષ્યતિ? ");
INSERT INTO sanguj_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","તતો યીશુઃ પ્રત્યુદિતવાન્, યો જનો મયિ પ્રીયતે સ મમાજ્ઞા અપિ ગૃહ્લાતિ, તેન મમ પિતાપિ તસ્મિન્ પ્રેષ્યતે, આવાઞ્ચ તન્નિકટમાગત્ય તેન સહ નિવત્સ્યાવઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","યો જનો મયિ ન પ્રીયતે સ મમ કથા અપિ ન ગૃહ્લાતિ પુનશ્ચ યામિમાં કથાં યૂયં શૃણુથ સા કથા કેવલસ્ય મમ ન કિન્તુ મમ પ્રેરકો યઃ પિતા તસ્યાપિ કથા| ");
INSERT INTO sanguj_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","ઇદાનીં યુષ્માકં નિકટે વિદ્યમાનોહમ્ એતાઃ સકલાઃ કથાઃ કથયામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","કિન્ત્વિતઃ પરં પિત્રા યઃ સહાયોઽર્થાત્ પવિત્ર આત્મા મમ નામ્નિ પ્રેરયિષ્યતિ સ સર્વ્વં શિક્ષયિત્વા મયોક્તાઃ સમસ્તાઃ કથા યુષ્માન્ સ્મારયિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","અહં યુષ્માકં નિકટે શાન્તિં સ્થાપયિત્વા યામિ, નિજાં શાન્તિં યુષ્મભ્યં દદામિ, જગતો લોકા યથા દદાતિ તથાહં ન દદામિ; યુષ્માકમ્ અન્તઃકરણાનિ દુઃખિતાનિ ભીતાનિ ચ ન ભવન્તુ| ");
INSERT INTO sanguj_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","અહં ગત્વા પુનરપિ યુષ્માકં સમીપમ્ આગમિષ્યામિ મયોક્તં વાક્યમિદં યૂયમ્ અશ્રૌષ્ટ; યદિ મય્યપ્રેષ્યધ્વં તર્હ્યહં પિતુઃ સમીપં ગચ્છામિ મમાસ્યાં કથાયાં યૂયમ્ અહ્લાદિષ્યધ્વં યતો મમ પિતા મત્તોપિ મહાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","તસ્યા ઘટનાયાઃ સમયે યથા યુષ્માકં શ્રદ્ધા જાયતે તદર્થમ્ અહં તસ્યા ઘટનાયાઃ પૂર્વ્વમ્ ઇદાનીં યુષ્માન્ એતાં વાર્ત્તાં વદામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ઇતઃ પરં યુષ્માભિઃ સહ મમ બહવ આલાપા ન ભવિષ્યન્તિ યતઃ કારણાદ્ એતસ્ય જગતઃ પતિરાગચ્છતિ કિન્તુ મયા સહ તસ્ય કોપિ સમ્બન્ધો નાસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","અહં પિતરિ પ્રેમ કરોમિ તથા પિતુ ર્વિધિવત્ કર્મ્માણિ કરોમીતિ યેન જગતો લોકા જાનન્તિ તદર્થમ્ ઉત્તિષ્ઠત વયં સ્થાનાદસ્માદ્ ગચ્છામ| ");
INSERT INTO sanguj_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","અહં સત્યદ્રાક્ષાલતાસ્વરૂપો મમ પિતા તૂદ્યાનપરિચારકસ્વરૂપઞ્ચ| ");
INSERT INTO sanguj_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","મમ યાસુ શાખાસુ ફલાનિ ન ભવન્તિ તાઃ સ છિનત્તિ તથા ફલવત્યઃ શાખા યથાધિકફલાનિ ફલન્તિ તદર્થં તાઃ પરિષ્કરોતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ઇદાનીં મયોક્તોપદેશેન યૂયં પરિષ્કૃતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","અતઃ કારણાત્ મયિ તિષ્ઠત તેનાહમપિ યુષ્માસુ તિષ્ઠામિ, યતો હેતો ર્દ્રાક્ષાલતાયામ્ અસંલગ્ના શાખા યથા ફલવતી ભવિતું ન શક્નોતિ તથા યૂયમપિ મય્યતિષ્ઠન્તઃ ફલવન્તો ભવિતું ન શક્નુથ| ");
INSERT INTO sanguj_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","અહં દ્રાક્ષાલતાસ્વરૂપો યૂયઞ્ચ શાખાસ્વરૂપોઃ; યો જનો મયિ તિષ્ઠતિ યત્ર ચાહં તિષ્ઠામિ, સ પ્રચૂરફલૈઃ ફલવાન્ ભવતિ, કિન્તુ માં વિના યૂયં કિમપિ કર્ત્તું ન શક્નુથ| ");
INSERT INTO sanguj_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","યઃ કશ્ચિન્ મયિ ન તિષ્ઠતિ સ શુષ્કશાખેવ બહિ ર્નિક્ષિપ્યતે લોકાશ્ચ તા આહૃત્ય વહ્નૌ નિક્ષિપ્ય દાહયન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","યદિ યૂયં મયિ તિષ્ઠથ મમ કથા ચ યુષ્માસુ તિષ્ઠતિ તર્હિ યદ્ વાઞ્છિત્વા યાચિષ્યધ્વે યુષ્માકં તદેવ સફલં ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","યદિ યૂયં પ્રચૂરફલવન્તો ભવથ તર્હિ તદ્વારા મમ પિતુ ર્મહિમા પ્રકાશિષ્યતે તથા યૂયં મમ શિષ્યા ઇતિ પરિક્ષાયિષ્યધ્વે| ");
INSERT INTO sanguj_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","પિતા યથા મયિ પ્રીતવાન્ અહમપિ યુષ્માસુ તથા પ્રીતવાન્ અતો હેતો ર્યૂયં નિરન્તરં મમ પ્રેમપાત્રાણિ ભૂત્વા તિષ્ઠત| ");
INSERT INTO sanguj_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","અહં યથા પિતુરાજ્ઞા ગૃહીત્વા તસ્ય પ્રેમભાજનં તિષ્ઠામિ તથૈવ યૂયમપિ યદિ મમાજ્ઞા ગુહ્લીથ તર્હિ મમ પ્રેમભાજનાનિ સ્થાસ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","યુષ્મન્નિમિત્તં મમ ય આહ્લાદઃ સ યથા ચિરં તિષ્ઠતિ યુષ્માકમ્ આનન્દશ્ચ યથા પૂર્ય્યતે તદર્થં યુષ્મભ્યમ્ એતાઃ કથા અત્રકથમ્| ");
INSERT INTO sanguj_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","અહં યુષ્માસુ યથા પ્રીયે યૂયમપિ પરસ્પરં તથા પ્રીયધ્વમ્ એષા મમાજ્ઞા| ");
INSERT INTO sanguj_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","મિત્રાણાં કારણાત્ સ્વપ્રાણદાનપર્ય્યન્તં યત્ પ્રેમ તસ્માન્ મહાપ્રેમ કસ્યાપિ નાસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","અહં યદ્યદ્ આદિશામિ તત્તદેવ યદિ યૂયમ્ આચરત તર્હિ યૂયમેવ મમ મિત્રાણિ| ");
INSERT INTO sanguj_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","અદ્યારભ્ય યુષ્માન્ દાસાન્ ન વદિષ્યામિ યત્ પ્રભુ ર્યત્ કરોતિ દાસસ્તદ્ ન જાનાતિ; કિન્તુ પિતુઃ સમીપે યદ્યદ્ અશૃણવં તત્ સર્વ્વં યૂષ્માન્ અજ્ઞાપયમ્ તત્કારણાદ્ યુષ્માન્ મિત્રાણિ પ્રોક્તવાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","યૂયં માં રોચિતવન્ત ઇતિ ન, કિન્ત્વહમેવ યુષ્માન્ રોચિતવાન્ યૂયં ગત્વા યથા ફલાન્યુત્પાદયથ તાનિ ફલાનિ ચાક્ષયાણિ ભવન્તિ, તદર્થં યુષ્માન્ ન્યજુનજં તસ્માન્ મમ નામ પ્રોચ્ય પિતરં યત્ કિઞ્ચિદ્ યાચિષ્યધ્વે તદેવ સ યુષ્મભ્યં દાસ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","યૂયં પરસ્પરં પ્રીયધ્વમ્ અહમ્ ઇત્યાજ્ઞાપયામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","જગતો લોકૈ ર્યુષ્માસુ ઋતીયિતેષુ તે પૂર્વ્વં મામેવાર્ત્તીયન્ત ઇતિ યૂયં જાનીથ| ");
INSERT INTO sanguj_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","યદિ યૂયં જગતો લોકા અભવિષ્યત તર્હિ જગતો લોકા યુષ્માન્ આત્મીયાન્ બુદ્ધ્વાપ્રેષ્યન્ત; કિન્તુ યૂયં જગતો લોકા ન ભવથ, અહં યુષ્માન્ અસ્માજ્જગતોઽરોચયમ્ એતસ્માત્ કારણાજ્જગતો લોકા યુષ્માન્ ઋતીયન્તે| ");
INSERT INTO sanguj_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","દાસઃ પ્રભો ર્મહાન્ ન ભવતિ મમૈતત્ પૂર્વ્વીયં વાક્યં સ્મરત; તે યદિ મામેવાતાડયન્ તર્હિ યુષ્માનપિ તાડયિષ્યન્તિ, યદિ મમ વાક્યં ગૃહ્લન્તિ તર્હિ યુષ્માકમપિ વાક્યં ગ્રહીષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","કિન્તુ તે મમ નામકારણાદ્ યુષ્માન્ પ્રતિ તાદૃશં વ્યવહરિષ્યન્તિ યતો યો માં પ્રેરિતવાન્ તં તે ન જાનન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","તેષાં સન્નિધિમ્ આગત્ય યદ્યહં નાકથયિષ્યં તર્હિ તેષાં પાપં નાભવિષ્યત્ કિન્ત્વધુના તેષાં પાપમાચ્છાદયિતુમ્ ઉપાયો નાસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","યો જનો મામ્ ઋતીયતે સ મમ પિતરમપિ ઋતીયતે| ");
INSERT INTO sanguj_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","યાદૃશાનિ કર્મ્માણિ કેનાપિ કદાપિ નાક્રિયન્ત તાદૃશાનિ કર્મ્માણિ યદિ તેષાં સાક્ષાદ્ અહં નાકરિષ્યં તર્હિ તેષાં પાપં નાભવિષ્યત્ કિન્ત્વધુના તે દૃષ્ટ્વાપિ માં મમ પિતરઞ્ચાર્ત્તીયન્ત| ");
INSERT INTO sanguj_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","તસ્માત્ તેઽકારણં મામ્ ઋતીયન્તે યદેતદ્ વચનં તેષાં શાસ્ત્રે લિખિતમાસ્તે તત્ સફલમ્ અભવત્| ");
INSERT INTO sanguj_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","કિન્તુ પિતુ ર્નિર્ગતં યં સહાયમર્થાત્ સત્યમયમ્ આત્માનં પિતુઃ સમીપાદ્ યુષ્માકં સમીપે પ્રેષયિષ્યામિ સ આગત્ય મયિ પ્રમાણં દાસ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","યૂયં પ્રથમમારભ્ય મયા સાર્દ્ધં તિષ્ઠથ તસ્માદ્ધેતો ર્યૂયમપિ પ્રમાણં દાસ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","યુષ્માકં યથા વાધા ન જાયતે તદર્થં યુષ્માન્ એતાનિ સર્વ્વવાક્યાનિ વ્યાહરં| ");
INSERT INTO sanguj_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","લોકા યુષ્માન્ ભજનગૃહેભ્યો દૂરીકરિષ્યન્તિ તથા યસ્મિન્ સમયે યુષ્માન્ હત્વા ઈશ્વરસ્ય તુષ્ટિ જનકં કર્મ્માકુર્મ્મ ઇતિ મંસ્યન્તે સ સમય આગચ્છન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","તે પિતરં માઞ્ચ ન જાનન્તિ, તસ્માદ્ યુષ્માન્ પ્રતીદૃશમ્ આચરિષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","અતો હેતાઃ સમયે સમુપસ્થિતે યથા મમ કથા યુષ્માકં મનઃસુઃ સમુપતિષ્ઠતિ તદર્થં યુષ્માભ્યમ્ એતાં કથાં કથયામિ યુષ્માભિઃ સાર્દ્ધમ્ અહં તિષ્ઠન્ પ્રથમં તાં યુષ્મભ્યં નાકથયં| ");
INSERT INTO sanguj_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","સામ્પ્રતં સ્વસ્ય પ્રેરયિતુઃ સમીપં ગચ્છામિ તથાપિ ત્વં ક્ક ગચ્છસિ કથામેતાં યુષ્માકં કોપિ માં ન પૃચ્છતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","કિન્તુ મયોક્તાભિરાભિઃ કથાભિ ર્યૂષ્માકમ્ અન્તઃકરણાનિ દુઃખેન પૂર્ણાન્યભવન્| ");
INSERT INTO sanguj_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","તથાપ્યહં યથાર્થં કથયામિ મમ ગમનં યુષ્માકં હિતાર્થમેવ, યતો હેતો ર્ગમને ન કૃતે સહાયો યુષ્માકં સમીપં નાગમિષ્યતિ કિન્તુ યદિ ગચ્છામિ તર્હિ યુષ્માકં સમીપે તં પ્રેષયિષ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","તતઃ સ આગત્ય પાપપુણ્યદણ્ડેષુ જગતો લોકાનાં પ્રબોધં જનયિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","તે મયિ ન વિશ્વસન્તિ તસ્માદ્ધેતોઃ પાપપ્રબોધં જનયિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","યુષ્માકમ્ અદૃશ્યઃ સન્નહં પિતુઃ સમીપં ગચ્છામિ તસ્માદ્ પુણ્યે પ્રબોધં જનયિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","એતજ્જગતોઽધિપતિ ર્દણ્ડાજ્ઞાં પ્રાપ્નોતિ તસ્માદ્ દણ્ડે પ્રબોધં જનયિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","યુષ્મભ્યં કથયિતું મમાનેકાઃ કથા આસતે, તાઃ કથા ઇદાનીં યૂયં સોઢું ન શક્નુથ; ");
INSERT INTO sanguj_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","કિન્તુ સત્યમય આત્મા યદા સમાગમિષ્યતિ તદા સર્વ્વં સત્યં યુષ્માન્ નેષ્યતિ, સ સ્વતઃ કિમપિ ન વદિષ્યતિ કિન્તુ યચ્છ્રોષ્યતિ તદેવ કથયિત્વા ભાવિકાર્ય્યં યુષ્માન્ જ્ઞાપયિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","મમ મહિમાનં પ્રકાશયિષ્યતિ યતો મદીયાં કથાં ગૃહીત્વા યુષ્માન્ બોધયિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","પિતુ ર્યદ્યદ્ આસ્તે તત્ સર્વ્વં મમ તસ્માદ્ કારણાદ્ અવાદિષં સ મદીયાં કથાં ગૃહીત્વા યુષ્માન્ બોધયિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","કિયત્કાલાત્ પરં યૂયં માં દ્રષ્ટું ન લપ્સ્યધ્વે કિન્તુ કિયત્કાલાત્ પરં પુન ર્દ્રષ્ટું લપ્સ્યધ્વે યતોહં પિતુઃ સમીપં ગચ્છામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","તતઃ શિષ્યાણાં કિયન્તો જનાઃ પરસ્પરં વદિતુમ્ આરભન્ત, કિયત્કાલાત્ પરં માં દ્રષ્ટું ન લપ્સ્યધ્વે કિન્તુ કિયત્કાલાત્ પરં પુન ર્દ્રષ્ટું લપ્સ્યધ્વે યતોહં પિતુઃ સમીપં ગચ્છામિ, ઇતિ યદ્ વાક્યમ્ અયં વદતિ તત્ કિં? ");
INSERT INTO sanguj_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","તતઃ કિયત્કાલાત્ પરમ્ ઇતિ તસ્ય વાક્યં કિં? તસ્ય વાક્યસ્યાભિપ્રાયં વયં બોદ્ધું ન શક્નુમસ્તૈરિતિ ");
INSERT INTO sanguj_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","નિગદિતે યીશુસ્તેષાં પ્રશ્નેચ્છાં જ્ઞાત્વા તેભ્યોઽકથયત્ કિયત્કાલાત્ પરં માં દ્રષ્ટું ન લપ્સ્યધ્વે, કિન્તુ કિયત્કાલાત્ પરં પૂન ર્દ્રષ્ટું લપ્સ્યધ્વે, યામિમાં કથામકથયં તસ્યા અભિપ્રાયં કિં યૂયં પરસ્પરં મૃગયધ્વે? ");
INSERT INTO sanguj_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","યુષ્માનહમ્ અતિયથાર્થં વદામિ યૂયં ક્રન્દિષ્યથ વિલપિષ્યથ ચ, કિન્તુ જગતો લોકા આનન્દિષ્યન્તિ; યૂયં શોકાકુલા ભવિષ્યથ કિન્તુ શોકાત્ પરં આનન્દયુક્તા ભવિષ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","પ્રસવકાલ ઉપસ્થિતે નારી યથા પ્રસવવેદનયા વ્યાકુલા ભવતિ કિન્તુ પુત્રે ભૂમિષ્ઠે સતિ મનુષ્યૈકો જન્મના નરલોકે પ્રવિષ્ટ ઇત્યાનન્દાત્ તસ્યાસ્તત્સર્વ્વં દુઃખં મનસિ ન તિષ્ઠતિ, ");
INSERT INTO sanguj_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","તથા યૂયમપિ સામ્પ્રતં શોકાકુલા ભવથ કિન્તુ પુનરપિ યુષ્મભ્યં દર્શનં દાસ્યામિ તેન યુષ્માકમ્ અન્તઃકરણાનિ સાનન્દાનિ ભવિષ્યન્તિ, યુષ્માકં તમ્ આનન્દઞ્ચ કોપિ હર્ત્તું ન શક્ષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","તસ્મિન્ દિવસે કામપિ કથાં માં ન પ્રક્ષ્યથ| યુષ્માનહમ્ અતિયથાર્થં વદામિ, મમ નામ્ના યત્ કિઞ્ચિદ્ પિતરં યાચિષ્યધ્વે તદેવ સ દાસ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","પૂર્વ્વે મમ નામ્ના કિમપિ નાયાચધ્વં, યાચધ્વં તતઃ પ્રાપ્સ્યથ તસ્માદ્ યુષ્માકં સમ્પૂર્ણાનન્દો જનિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","ઉપમાકથાભિઃ સર્વ્વાણ્યેતાનિ યુષ્માન્ જ્ઞાપિતવાન્ કિન્તુ યસ્મિન્ સમયે ઉપમયા નોક્ત્વા પિતુઃ કથાં સ્પષ્ટં જ્ઞાપયિષ્યામિ સમય એતાદૃશ આગચ્છતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","તદા મમ નામ્ના પ્રાર્થયિષ્યધ્વે ઽહં યુષ્મન્નિમિત્તં પિતરં વિનેષ્યે કથામિમાં ન વદામિ; ");
INSERT INTO sanguj_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","યતો યૂયં મયિ પ્રેમ કુરુથ, તથાહમ્ ઈશ્વરસ્ય સમીપાદ્ આગતવાન્ ઇત્યપિ પ્રતીથ, તસ્માદ્ કારણાત્ કારણાત્ પિતા સ્વયં યુષ્માસુ પ્રીયતે| ");
INSERT INTO sanguj_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","પિતુઃ સમીપાજ્જજદ્ આગતોસ્મિ જગત્ પરિત્યજ્ય ચ પુનરપિ પિતુઃ સમીપં ગચ્છામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","તદા શિષ્યા અવદન્, હે પ્રભો ભવાન્ ઉપમયા નોક્ત્વાધુના સ્પષ્ટં વદતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ભવાન્ સર્વ્વજ્ઞઃ કેનચિત્ પૃષ્ટો ભવિતુમપિ ભવતઃ પ્રયોજનં નાસ્તીત્યધુનાસ્માકં સ્થિરજ્ઞાનં જાતં તસ્માદ્ ભવાન્ ઈશ્વરસ્ય સમીપાદ્ આગતવાન્ ઇત્યત્ર વયં વિશ્વસિમઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","તતો યીશુઃ પ્રત્યવાદીદ્ ઇદાનીં કિં યૂયં વિશ્વસિથ? ");
INSERT INTO sanguj_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","પશ્યત સર્વ્વે યૂયં વિકીર્ણાઃ સન્તો મામ્ એકાકિનં પીરત્યજ્ય સ્વં સ્વં સ્થાનં ગમિષ્યથ, એતાદૃશઃ સમય આગચ્છતિ વરં પ્રાયેણોપસ્થિતવાન્; તથાપ્યહં નૈકાકી ભવામિ યતઃ પિતા મયા સાર્દ્ધમ્ આસ્તે| ");
INSERT INTO sanguj_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","યથા મયા યુષ્માકં શાન્તિ ર્જાયતે તદર્થમ્ એતાઃ કથા યુષ્મભ્યમ્ અચકથં; અસ્મિન્ જગતિ યુષ્માકં ક્લેશો ઘટિષ્યતે કિન્ત્વક્ષોભા ભવત યતો મયા જગજ્જિતં| ");
INSERT INTO sanguj_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","તતઃ પરં યીશુરેતાઃ કથાઃ કથયિત્વા સ્વર્ગં વિલોક્યૈતત્ પ્રાર્થયત્, હે પિતઃ સમય ઉપસ્થિતવાન્; યથા તવ પુત્રસ્તવ મહિમાનં પ્રકાશયતિ તદર્થં ત્વં નિજપુત્રસ્ય મહિમાનં પ્રકાશય| ");
INSERT INTO sanguj_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ત્વં યોલ્લોકાન્ તસ્ય હસ્તે સમર્પિતવાન્ સ યથા તેભ્યોઽનન્તાયુ ર્દદાતિ તદર્થં ત્વં પ્રાણિમાત્રાણામ્ અધિપતિત્વભારં તસ્મૈ દત્તવાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","યસ્ત્વમ્ અદ્વિતીયઃ સત્ય ઈશ્વરસ્ત્વયા પ્રેરિતશ્ચ યીશુઃ ખ્રીષ્ટ એતયોરુભયોઃ પરિચયે પ્રાપ્તેઽનન્તાયુ ર્ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ત્વં યસ્ય કર્મ્મણો ભારં મહ્યં દત્તવાન્, તત્ સમ્પન્નં કૃત્વા જગત્યસ્મિન્ તવ મહિમાનં પ્રાકાશયં| ");
INSERT INTO sanguj_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","અતએવ હે પિત ર્જગત્યવિદ્યમાને ત્વયા સહ તિષ્ઠતો મમ યો મહિમાસીત્ સમ્પ્રતિ તવ સમીપે માં તં મહિમાનં પ્રાપય| ");
INSERT INTO sanguj_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","અન્યચ્ચ ત્વમ્ એતજ્જગતો યાલ્લોકાન્ મહ્યમ્ અદદા અહં તેભ્યસ્તવ નામ્નસ્તત્ત્વજ્ઞાનમ્ અદદાં, તે તવૈવાસન્, ત્વં તાન્ મહ્યમદદાઃ, તસ્માત્તે તવોપદેશમ્ અગૃહ્લન્| ");
INSERT INTO sanguj_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ત્વં મહ્યં યત્ કિઞ્ચિદ્ અદદાસ્તત્સર્વ્વં ત્વત્તો જાયતે ઇત્યધુનાજાનન્| ");
INSERT INTO sanguj_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","મહ્યં યમુપદેશમ્ અદદા અહમપિ તેભ્યસ્તમુપદેશમ્ અદદાં તેપિ તમગૃહ્લન્ ત્વત્તોહં નિર્ગત્ય ત્વયા પ્રેરિતોભવમ્ અત્ર ચ વ્યશ્વસન્| ");
INSERT INTO sanguj_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","તેષામેવ નિમિત્તં પ્રાર્થયેઽહં જગતો લોકનિમિત્તં ન પ્રાર્થયે કિન્તુ યાલ્લોકાન્ મહ્યમ્ અદદાસ્તેષામેવ નિમિત્તં પ્રાર્થયેઽહં યતસ્તે તવૈવાસતે| ");
INSERT INTO sanguj_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","યે મમ તે તવ યે ચ તવ તે મમ તથા તૈ ર્મમ મહિમા પ્રકાશ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","સામ્પ્રતમ્ અસ્મિન્ જગતિ મમાવસ્થિતેઃ શેષમ્ અભવત્ અહં તવ સમીપં ગચ્છામિ કિન્તુ તે જગતિ સ્થાસ્યન્તિ; હે પવિત્ર પિતરાવયો ર્યથૈકત્વમાસ્તે તથા તેષામપ્યેકત્વં ભવતિ તદર્થં યાલ્લોકાન્ મહ્યમ્ અદદાસ્તાન્ સ્વનામ્ના રક્ષ| ");
INSERT INTO sanguj_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","યાવન્તિ દિનાનિ જગત્યસ્મિન્ તૈઃ સહાહમાસં તાવન્તિ દિનાનિ તાન્ તવ નામ્નાહં રક્ષિતવાન્; યાલ્લોકાન્ મહ્યમ્ અદદાસ્તાન્ સર્વ્વાન્ અહમરક્ષં, તેષાં મધ્યે કેવલં વિનાશપાત્રં હારિતં તેન ધર્મ્મપુસ્તકસ્ય વચનં પ્રત્યક્ષં ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","કિન્ત્વધુના તવ સન્નિધિં ગચ્છામિ મયા યથા તેષાં સમ્પૂર્ણાનન્દો ભવતિ તદર્થમહં જગતિ તિષ્ઠન્ એતાઃ કથા અકથયમ્| ");
INSERT INTO sanguj_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","તવોપદેશં તેભ્યોઽદદાં જગતા સહ યથા મમ સમ્બન્ધો નાસ્તિ તથા જજતા સહ તેષામપિ સમ્બન્ધાભાવાજ્ જગતો લોકાસ્તાન્ ઋતીયન્તે| ");
INSERT INTO sanguj_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","ત્વં જગતસ્તાન્ ગૃહાણેતિ ન પ્રાર્થયે કિન્ત્વશુભાદ્ રક્ષેતિ પ્રાર્થયેહમ્| ");
INSERT INTO sanguj_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","અહં યથા જગત્સમ્બન્ધીયો ન ભવામિ તથા તેપિ જગત્સમ્બન્ધીયા ન ભવન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","તવ સત્યકથયા તાન્ પવિત્રીકુરુ તવ વાક્યમેવ સત્યં| ");
INSERT INTO sanguj_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ત્વં યથા માં જગતિ પ્રૈરયસ્તથાહમપિ તાન્ જગતિ પ્રૈરયં| ");
INSERT INTO sanguj_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","તેષાં હિતાર્થં યથાહં સ્વં પવિત્રીકરોમિ તથા સત્યકથયા તેપિ પવિત્રીભવન્તુ| ");
INSERT INTO sanguj_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","કેવલં એતેષામર્થે પ્રાર્થયેઽહમ્ ઇતિ ન કિન્ત્વેતેષામુપદેશેન યે જના મયિ વિશ્વસિષ્યન્તિ તેષામપ્યર્થે પ્રાર્થેયેઽહમ્| ");
INSERT INTO sanguj_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","હે પિતસ્તેષાં સર્વ્વેષામ્ એકત્વં ભવતુ તવ યથા મયિ મમ ચ યથા ત્વય્યેકત્વં તથા તેષામપ્યાવયોરેકત્વં ભવતુ તેન ત્વં માં પ્રેરિતવાન્ ઇતિ જગતો લોકાઃ પ્રતિયન્તુ| ");
INSERT INTO sanguj_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","યથાવયોરેકત્વં તથા તેષામપ્યેકત્વં ભવતુ તેષ્વહં મયિ ચ ત્વમ્ ઇત્થં તેષાં સમ્પૂર્ણમેકત્વં ભવતુ, ત્વં પ્રેરિતવાન્ ત્વં મયિ યથા પ્રીયસે ચ તથા તેષ્વપિ પ્રીતવાન્ એતદ્યથા જગતો લોકા જાનન્તિ ");
INSERT INTO sanguj_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","તદર્થં ત્વં યં મહિમાનં મહ્યમ્ અદદાસ્તં મહિમાનમ્ અહમપિ તેભ્યો દત્તવાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","હે પિત ર્જગતો નિર્મ્માણાત્ પૂર્વ્વં મયિ સ્નેહં કૃત્વા યં મહિમાનં દત્તવાન્ મમ તં મહિમાનં યથા તે પશ્યન્તિ તદર્થં યાલ્લોકાન્ મહ્યં દત્તવાન્ અહં યત્ર તિષ્ઠામિ તેપિ યથા તત્ર તિષ્ઠન્તિ મમૈષા વાઞ્છા| ");
INSERT INTO sanguj_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","હે યથાર્થિક પિત ર્જગતો લોકૈસ્ત્વય્યજ્ઞાતેપિ ત્વામહં જાને ત્વં માં પ્રેરિતવાન્ ઇતીમે શિષ્યા જાનન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","યથાહં તેષુ તિષ્ઠામિ તથા મયિ યેન પ્રેમ્ના પ્રેમાકરોસ્તત્ તેષુ તિષ્ઠતિ તદર્થં તવ નામાહં તાન્ જ્ઞાપિતવાન્ પુનરપિ જ્ઞાપયિષ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","તાઃ કથાઃ કથયિત્વા યીશુઃ શિષ્યાનાદાય કિદ્રોન્નામકં સ્રોત ઉત્તીર્ય્ય શિષ્યૈઃ સહ તત્રત્યોદ્યાનં પ્રાવિશત્| ");
INSERT INTO sanguj_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","કિન્તુ વિશ્વાસઘાતિયિહૂદાસ્તત્ સ્થાનં પરિચીયતે યતો યીશુઃ શિષ્યૈઃ સાર્દ્ધં કદાચિત્ તત્ સ્થાનમ્ અગચ્છત્| ");
INSERT INTO sanguj_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","તદા સ યિહૂદાઃ સૈન્યગણં પ્રધાનયાજકાનાં ફિરૂશિનાઞ્ચ પદાતિગણઞ્ચ ગૃહીત્વા પ્રદીપાન્ ઉલ્કાન્ અસ્ત્રાણિ ચાદાય તસ્મિન્ સ્થાન ઉપસ્થિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","સ્વં પ્રતિ યદ્ ઘટિષ્યતે તજ્ જ્ઞાત્વા યીશુરગ્રેસરઃ સન્ તાનપૃચ્છત્ કં ગવેષયથ? ");
INSERT INTO sanguj_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","તે પ્રત્યવદન્, નાસરતીયં યીશું; તતો યીશુરવાદીદ્ અહમેવ સઃ; તૈઃ સહ વિશ્વાસઘાતી યિહૂદાશ્ચાતિષ્ઠત્| ");
INSERT INTO sanguj_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","તદાહમેવ સ તસ્યૈતાં કથાં શ્રુત્વૈવ તે પશ્ચાદેત્ય ભૂમૌ પતિતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","તતો યીશુઃ પુનરપિ પૃષ્ઠવાન્ કં ગવેષયથ? તતસ્તે પ્રત્યવદન્ નાસરતીયં યીશું| ");
INSERT INTO sanguj_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","તદા યીશુઃ પ્રત્યુદિતવાન્ અહમેવ સ ઇમાં કથામચકથમ્; યદિ મામન્વિચ્છથ તર્હીમાન્ ગન્તું મા વારયત| ");
INSERT INTO sanguj_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ઇત્થં ભૂતે મહ્યં યાલ્લોકાન્ અદદાસ્તેષામ્ એકમપિ નાહારયમ્ ઇમાં યાં કથાં સ સ્વયમકથયત્ સા કથા સફલા જાતા| ");
INSERT INTO sanguj_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","તદા શિમોન્પિતરસ્ય નિકટે ખઙ્ગલ્સ્થિતેઃ સ તં નિષ્કોષં કૃત્વા મહાયાજકસ્ય માલ્ખનામાનં દાસમ્ આહત્ય તસ્ય દક્ષિણકર્ણં છિન્નવાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","તતો યીશુઃ પિતરમ્ અવદત્, ખઙ્ગં કોષે સ્થાપય મમ પિતા મહ્યં પાતું યં કંસમ્ અદદાત્ તેનાહં કિં ન પાસ્યામિ? ");
INSERT INTO sanguj_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","તદા સૈન્યગણઃ સેનાપતિ ર્યિહૂદીયાનાં પદાતયશ્ચ યીશું ઘૃત્વા બદ્ધ્વા હાનન્નામ્નઃ કિયફાઃ શ્વશુરસ્ય સમીપં પ્રથમમ્ અનયન્| ");
INSERT INTO sanguj_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","સ કિયફાસ્તસ્મિન્ વત્સરે મહાયાજત્વપદે નિયુક્તઃ ");
INSERT INTO sanguj_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","સન્ સાધારણલોકાનાં મઙ્ગલાર્થમ્ એકજનસ્ય મરણમુચિતમ્ ઇતિ યિહૂદીયૈઃ સાર્દ્ધમ્ અમન્ત્રયત્| ");
INSERT INTO sanguj_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","તદા શિમોન્પિતરોઽન્યૈકશિષ્યશ્ચ યીશોઃ પશ્ચાદ્ અગચ્છતાં તસ્યાન્યશિષ્યસ્ય મહાયાજકેન પરિચિતત્વાત્ સ યીશુના સહ મહાયાજકસ્યાટ્ટાલિકાં પ્રાવિશત્| ");
INSERT INTO sanguj_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","કિન્તુ પિતરો બહિર્દ્વારસ્ય સમીપેઽતિષ્ઠદ્ અતએવ મહાયાજકેન પરિચિતઃ સ શિષ્યઃ પુનર્બહિર્ગત્વા દૌવાયિકાયૈ કથયિત્વા પિતરમ્ અભ્યન્તરમ્ આનયત્| ");
INSERT INTO sanguj_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","તદા સ દ્વારરક્ષિકા પિતરમ્ અવદત્ ત્વં કિં ન તસ્ય માનવસ્ય શિષ્યઃ? તતઃ સોવદદ્ અહં ન ભવામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","તતઃ પરં યત્સ્થાને દાસાઃ પદાતયશ્ચ શીતહેતોરઙ્ગારૈ ર્વહ્નિં પ્રજ્વાલ્ય તાપં સેવિતવન્તસ્તત્સ્થાને પિતરસ્તિષ્ઠન્ તૈઃ સહ વહ્નિતાપં સેવિતુમ્ આરભત| ");
INSERT INTO sanguj_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","તદા શિષ્યેષૂપદેશે ચ મહાયાજકેન યીશુઃ પૃષ્ટઃ ");
INSERT INTO sanguj_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","સન્ પ્રત્યુક્તવાન્ સર્વ્વલોકાનાં સમક્ષં કથામકથયં ગુપ્તં કામપિ કથાં ન કથયિત્વા યત્ સ્થાનં યિહૂદીયાઃ સતતં ગચ્છન્તિ તત્ર ભજનગેહે મન્દિરે ચાશિક્ષયં| ");
INSERT INTO sanguj_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","મત્તઃ કુતઃ પૃચ્છસિ? યે જના મદુપદેશમ્ અશૃણ્વન્ તાનેવ પૃચ્છ યદ્યદ્ અવદં તે તત્ જાનિન્ત| ");
INSERT INTO sanguj_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","તદેત્થં પ્રત્યુદિતત્વાત્ નિકટસ્થપદાતિ ર્યીશું ચપેટેનાહત્ય વ્યાહરત્ મહાયાજકમ્ એવં પ્રતિવદસિ? ");
INSERT INTO sanguj_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","તતો યીશુઃ પ્રતિગદિતવાન્ યદ્યયથાર્થમ્ અચકથં તર્હિ તસ્યાયથાર્થસ્ય પ્રમાણં દેહિ, કિન્તુ યદિ યથાર્થં તર્હિ કુતો હેતો ર્મામ્ અતાડયઃ? ");
INSERT INTO sanguj_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","પૂર્વ્વં હાનન્ સબન્ધનં તં કિયફામહાયાજકસ્ય સમીપં પ્રૈષયત્| ");
INSERT INTO sanguj_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","શિમોન્પિતરસ્તિષ્ઠન્ વહ્નિતાપં સેવતે, એતસ્મિન્ સમયે કિયન્તસ્તમ્ અપૃચ્છન્ ત્વં કિમ્ એતસ્ય જનસ્ય શિષ્યો ન? તતઃ સોપહ્નુત્યાબ્રવીદ્ અહં ન ભવામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","તદા મહાયાજકસ્ય યસ્ય દાસસ્ય પિતરઃ કર્ણમચ્છિનત્ તસ્ય કુટુમ્બઃ પ્રત્યુદિતવાન્ ઉદ્યાને તેન સહ તિષ્ઠન્તં ત્વાં કિં નાપશ્યં? ");
INSERT INTO sanguj_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","કિન્તુ પિતરઃ પુનરપહ્નુત્ય કથિતવાન્; તદાનીં કુક્કુટોઽરૌત્| ");
INSERT INTO sanguj_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","તદનન્તરં પ્રત્યૂષે તે કિયફાગૃહાદ્ અધિપતે ર્ગૃહં યીશુમ્ અનયન્ કિન્તુ યસ્મિન્ અશુચિત્વે જાતે તૈ ર્નિસ્તારોત્સવે ન ભોક્તવ્યં, તસ્ય ભયાદ્ યિહૂદીયાસ્તદ્ગૃહં નાવિશન્| ");
INSERT INTO sanguj_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","અપરં પીલાતો બહિરાગત્ય તાન્ પૃષ્ઠવાન્ એતસ્ય મનુષ્યસ્ય કં દોષં વદથ? ");
INSERT INTO sanguj_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","તદા તે પેત્યવદન્ દુષ્કર્મ્મકારિણિ ન સતિ ભવતઃ સમીપે નૈનં સમાર્પયિષ્યામઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","તતઃ પીલાતોઽવદદ્ યૂયમેનં ગૃહીત્વા સ્વેષાં વ્યવસ્થયા વિચારયત| તદા યિહૂદીયાઃ પ્રત્યવદન્ કસ્યાપિ મનુષ્યસ્ય પ્રાણદણ્ડં કર્ત્તું નાસ્માકમ્ અધિકારોઽસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","એવં સતિ યીશુઃ સ્વસ્ય મૃત્યૌ યાં કથાં કથિતવાન્ સા સફલાભવત્| ");
INSERT INTO sanguj_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","તદનન્તરં પીલાતઃ પુનરપિ તદ્ રાજગૃહં ગત્વા યીશુમાહૂય પૃષ્ટવાન્ ત્વં કિં યિહૂદીયાનાં રાજા? ");
INSERT INTO sanguj_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","યીશુઃ પ્રત્યવદત્ ત્વમ્ એતાં કથાં સ્વતઃ કથયસિ કિમન્યઃ કશ્ચિન્ મયિ કથિતવાન્? ");
INSERT INTO sanguj_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","પીલાતોઽવદદ્ અહં કિં યિહૂદીયઃ? તવ સ્વદેશીયા વિશેષતઃ પ્રધાનયાજકા મમ નિકટે ત્વાં સમાર્પયન, ત્વં કિં કૃતવાન્? ");
INSERT INTO sanguj_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","યીશુઃ પ્રત્યવદત્ મમ રાજ્યમ્ એતજ્જગત્સમ્બન્ધીયં ન ભવતિ યદિ મમ રાજ્યં જગત્સમ્બન્ધીયમ્ અભવિષ્યત્ તર્હિ યિહૂદીયાનાં હસ્તેષુ યથા સમર્પિતો નાભવં તદર્થં મમ સેવકા અયોત્સ્યન્ કિન્તુ મમ રાજ્યમ્ ઐહિકં ન| ");
INSERT INTO sanguj_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","તદા પીલાતઃ કથિતવાન્, તર્હિ ત્વં રાજા ભવસિ? યીશુઃ પ્રત્યુક્તવાન્ ત્વં સત્યં કથયસિ, રાજાહં ભવામિ; સત્યતાયાં સાક્ષ્યં દાતું જનિં ગૃહીત્વા જગત્યસ્મિન્ અવતીર્ણવાન્, તસ્માત્ સત્યધર્મ્મપક્ષપાતિનો મમ કથાં શૃણ્વન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","તદા સત્યં કિં? એતાં કથાં પષ્ટ્વા પીલાતઃ પુનરપિ બહિર્ગત્વા યિહૂદીયાન્ અભાષત, અહં તસ્ય કમપ્યપરાધં ન પ્રાપ્નોમિ| ");
INSERT INTO sanguj_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","નિસ્તારોત્સવસમયે યુષ્માભિરભિરુચિત એકો જનો મયા મોચયિતવ્ય એષા યુષ્માકં રીતિરસ્તિ, અતએવ યુષ્માકં નિકટે યિહૂદીયાનાં રાજાનં કિં મોચયામિ, યુષ્માકમ્ ઇચ્છા કા? ");
INSERT INTO sanguj_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","તદા તે સર્વ્વે રુવન્તો વ્યાહરન્ એનં માનુષં નહિ બરબ્બાં મોચય| કિન્તુ સ બરબ્બા દસ્યુરાસીત્| ");
INSERT INTO sanguj_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","પીલાતો યીશુમ્ આનીય કશયા પ્રાહારયત્| ");
INSERT INTO sanguj_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","પશ્ચાત્ સેનાગણઃ કણ્ટકનિર્મ્મિતં મુકુટં તસ્ય મસ્તકે સમર્પ્ય વાર્ત્તાકીવર્ણં રાજપરિચ્છદં પરિધાપ્ય, ");
INSERT INTO sanguj_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","હે યિહૂદીયાનાં રાજન્ નમસ્કાર ઇત્યુક્ત્વા તં ચપેટેનાહન્તુમ્ આરભત| ");
INSERT INTO sanguj_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","તદા પીલાતઃ પુનરપિ બહિર્ગત્વા લોકાન્ અવદત્, અસ્ય કમપ્યપરાધં ન લભેઽહં, પશ્યત તદ્ યુષ્માન્ જ્ઞાપયિતું યુષ્માકં સન્નિધૌ બહિરેનમ્ આનયામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","તતઃ પરં યીશુઃ કણ્ટકમુકુટવાન્ વાર્ત્તાકીવર્ણવસનવાંશ્ચ બહિરાગચ્છત્| તતઃ પીલાત ઉક્તવાન્ એનં મનુષ્યં પશ્યત| ");
INSERT INTO sanguj_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","તદા પ્રધાનયાજકાઃ પદાતયશ્ચ તં દૃષ્ટ્વા, એનં ક્રુશે વિધ, એનં ક્રુશે વિધ, ઇત્યુક્ત્વા રવિતું આરભન્ત| તતઃ પીલાતઃ કથિતવાન્ યૂયં સ્વયમ્ એનં નીત્વા ક્રુશે વિધત, અહમ્ એતસ્ય કમપ્યપરાધં ન પ્રાપ્તવાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","યિહૂદીયાઃ પ્રત્યવદન્ અસ્માકં યા વ્યવસ્થાસ્તે તદનુસારેણાસ્ય પ્રાણહનનમ્ ઉચિતં યતોયં સ્વમ્ ઈશ્વરસ્ય પુત્રમવદત્| ");
INSERT INTO sanguj_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","પીલાત ઇમાં કથાં શ્રુત્વા મહાત્રાસયુક્તઃ ");
INSERT INTO sanguj_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","સન્ પુનરપિ રાજગૃહ આગત્ય યીશું પૃષ્ટવાન્ ત્વં કુત્રત્યો લોકઃ? કિન્તુ યીશસ્તસ્ય કિમપિ પ્રત્યુત્તરં નાવદત્| ");
INSERT INTO sanguj_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","૧॰ તતઃ પીલાત્ કથિતવાન ત્વં કિં મયા સાર્દ્ધં ન સંલપિષ્યસિ ? ત્વાં ક્રુશે વેધિતું વા મોચયિતું શક્તિ ર્મમાસ્તે ઇતિ કિં ત્વં ન જાનાસિ ? તદા યીશુઃ પ્રત્યવદદ્ ઈશ્વરેણાદŸाં મમોપરિ તવ કિમપ્યધિપતિત્વં ન વિદ્યતે, તથાપિ યો જનો માં તવ હસ્તે સમાર્પયત્ તસ્ય મહાપાતકં જાતમ્| ");
INSERT INTO sanguj_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","તદા યીશુઃ પ્રત્યવદદ્ ઈશ્વરેણાદત્તં મમોપરિ તવ કિમપ્યધિપતિત્વં ન વિદ્યતે, તથાપિ યો જનો માં તવ હસ્તે સમાર્પયત્ તસ્ય મહાપાતકં જાતમ્| ");
INSERT INTO sanguj_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","તદારભ્ય પીલાતસ્તં મોચયિતું ચેષ્ટિતવાન્ કિન્તુ યિહૂદીયા રુવન્તો વ્યાહરન્ યદીમં માનવં ત્યજસિ તર્હિ ત્વં કૈસરસ્ય મિત્રં ન ભવસિ, યો જનઃ સ્વં રાજાનં વક્તિ સએવ કૈમરસ્ય વિરુદ્ધાં કથાં કથયતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","એતાં કથાં શ્રુત્વા પીલાતો યીશું બહિરાનીય નિસ્તારોત્સવસ્ય આસાદનદિનસ્ય દ્વિતીયપ્રહરાત્ પૂર્વ્વં પ્રસ્તરબન્ધનનામ્નિ સ્થાને ઽર્થાત્ ઇબ્રીયભાષયા યદ્ ગબ્બિથા કથ્યતે તસ્મિન્ સ્થાને વિચારાસન ઉપાવિશત્| ");
INSERT INTO sanguj_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","અનન્તરં પીલાતો યિહૂદીયાન્ અવદત્, યુષ્માકં રાજાનં પશ્યત| ");
INSERT INTO sanguj_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","કિન્તુ એનં દૂરીકુરુ, એનં દૂરીકુરુ, એનં ક્રુશે વિધ, ઇતિ કથાં કથયિત્વા તે રવિતુમ્ આરભન્ત; તદા પીલાતઃ કથિતવાન્ યુષ્માકં રાજાનં કિં ક્રુશે વેધિષ્યામિ? પ્રધાનયાજકા ઉત્તરમ્ અવદન્ કૈસરં વિના કોપિ રાજાસ્માકં નાસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","તતઃ પીલાતો યીશું ક્રુશે વેધિતું તેષાં હસ્તેષુ સમાર્પયત્, તતસ્તે તં ધૃત્વા નીતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","તતઃ પરં યીશુઃ ક્રુશં વહન્ શિરઃકપાલમ્ અર્થાદ્ યદ્ ઇબ્રીયભાષયા ગુલ્ગલ્તાં વદન્તિ તસ્મિન્ સ્થાન ઉપસ્થિતઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","તતસ્તે મધ્યસ્થાને તં તસ્યોભયપાર્શ્વે દ્વાવપરૌ ક્રુશેઽવિધન્| ");
INSERT INTO sanguj_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","અપરમ્ એષ યિહૂદીયાનાં રાજા નાસરતીયયીશુઃ, ઇતિ વિજ્ઞાપનં લિખિત્વા પીલાતસ્તસ્ય ક્રુશોપરિ સમયોજયત્| ");
INSERT INTO sanguj_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","સા લિપિઃ ઇબ્રીયયૂનાનીયરોમીયભાષાભિ ર્લિખિતા; યીશોઃ ક્રુશવેધનસ્થાનં નગરસ્ય સમીપં, તસ્માદ્ બહવો યિહૂદીયાસ્તાં પઠિતુમ્ આરભન્ત| ");
INSERT INTO sanguj_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","યિહૂદીયાનાં પ્રધાનયાજકાઃ પીલાતમિતિ ન્યવેદયન્ યિહૂદીયાનાં રાજેતિ વાક્યં ન કિન્તુ એષ સ્વં યિહૂદીયાનાં રાજાનમ્ અવદદ્ ઇત્થં લિખતુ| ");
INSERT INTO sanguj_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","તતઃ પીલાત ઉત્તરં દત્તવાન્ યલ્લેખનીયં તલ્લિખિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","ઇત્થં સેનાગણો યીશું ક્રુશે વિધિત્વા તસ્ય પરિધેયવસ્ત્રં ચતુરો ભાગાન્ કૃત્વા એકૈકસેના એકૈકભાગમ્ અગૃહ્લત્ તસ્યોત્તરીયવસ્ત્રઞ્ચાગૃહ્લત્| કિન્તૂત્તરીયવસ્ત્રં સૂચિસેવનં વિના સર્વ્વમ્ ઊતં| ");
INSERT INTO sanguj_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","તસ્માત્તે વ્યાહરન્ એતત્ કઃ પ્રાપ્સ્યતિ? તન્ન ખણ્ડયિત્વા તત્ર ગુટિકાપાતં કરવામ| વિભજન્તેઽધરીયં મે વસનં તે પરસ્પરં| મમોત્તરીયવસ્ત્રાર્થં ગુટિકાં પાતયન્તિ ચ| ઇતિ યદ્વાક્યં ધર્મ્મપુસ્તકે લિખિતમાસ્તે તત્ સેનાગણેનેત્થં વ્યવહરણાત્ સિદ્ધમભવત્| ");
INSERT INTO sanguj_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","તદાનીં યીશો ર્માતા માતુ ર્ભગિની ચ યા ક્લિયપા ભાર્ય્યા મરિયમ્ મગ્દલીની મરિયમ્ ચ એતાસ્તસ્ય ક્રુશસ્ય સન્નિધૌ સમતિષ્ઠન્| ");
INSERT INTO sanguj_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","તતો યીશુઃ સ્વમાતરં પ્રિયતમશિષ્યઞ્ચ સમીપે દણ્ડાયમાનૌ વિલોક્ય માતરમ્ અવદત્, હે યોષિદ્ એનં તવ પુત્રં પશ્ય, ");
INSERT INTO sanguj_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","શિષ્યન્ત્વવદત્, એનાં તવ માતરં પશ્ય| તતઃ સ શિષ્યસ્તદ્ઘટિકાયાં તાં નિજગૃહં નીતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","અનન્તરં સર્વ્વં કર્મ્માધુના સમ્પન્નમભૂત્ યીશુરિતિ જ્ઞાત્વા ધર્મ્મપુસ્તકસ્ય વચનં યથા સિદ્ધં ભવતિ તદર્થમ્ અકથયત્ મમ પિપાસા જાતા| ");
INSERT INTO sanguj_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","તતસ્તસ્મિન્ સ્થાને અમ્લરસેન પૂર્ણપાત્રસ્થિત્યા તે સ્પઞ્જમેકં તદમ્લરસેનાર્દ્રીકૃત્ય એસોબ્નલે તદ્ યોજયિત્વા તસ્ય મુખસ્ય સન્નિધાવસ્થાપયન્| ");
INSERT INTO sanguj_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","તદા યીશુરમ્લરસં ગૃહીત્વા સર્વ્વં સિદ્ધમ્ ઇતિ કથાં કથયિત્વા મસ્તકં નમયન્ પ્રાણાન્ પર્ય્યત્યજત્| ");
INSERT INTO sanguj_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","તદ્વિનમ્ આસાદનદિનં તસ્માત્ પરેઽહનિ વિશ્રામવારે દેહા યથા ક્રુશોપરિ ન તિષ્ઠન્તિ, યતઃ સ વિશ્રામવારો મહાદિનમાસીત્, તસ્માદ્ યિહૂદીયાઃ પીલાતનિકટં ગત્વા તેષાં પાદભઞ્જનસ્ય સ્થાનાન્તરનયનસ્ય ચાનુમતિં પ્રાર્થયન્ત| ");
INSERT INTO sanguj_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","અતઃ સેના આગત્ય યીશુના સહ ક્રુશે હતયોઃ પ્રથમદ્વિતીયચોરયોઃ પાદાન્ અભઞ્જન્; ");
INSERT INTO sanguj_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","કિન્તુ યીશોઃ સન્નિધિં ગત્વા સ મૃત ઇતિ દૃષ્ટ્વા તસ્ય પાદૌ નાભઞ્જન્| ");
INSERT INTO sanguj_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","પશ્ચાદ્ એકો યોદ્ધા શૂલાઘાતેન તસ્ય કુક્ષિમ્ અવિધત્ તત્ક્ષણાત્ તસ્માદ્ રક્તં જલઞ્ચ નિરગચ્છત્| ");
INSERT INTO sanguj_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","યો જનોઽસ્ય સાક્ષ્યં દદાતિ સ સ્વયં દૃષ્ટવાન્ તસ્યેદં સાક્ષ્યં સત્યં તસ્ય કથા યુષ્માકં વિશ્વાસં જનયિતું યોગ્યા તત્ સ જાનાતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","તસ્યૈકમ્ અસ્ધ્યપિ ન ભંક્ષ્યતે, ");
INSERT INTO sanguj_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","તદ્વદ્ અન્યશાસ્ત્રેપિ લિખ્યતે, યથા, \"દૃષ્ટિપાતં કરિષ્યન્તિ તેઽવિધન્ યન્તુ તમ્પ્રતિ| \" ");
INSERT INTO sanguj_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","અરિમથીયનગરસ્ય યૂષફ્નામા શિષ્ય એક આસીત્ કિન્તુ યિહૂદીયેભ્યો ભયાત્ પ્રકાશિતો ન ભવતિ; સ યીશો ર્દેહં નેતું પીલાતસ્યાનુમતિં પ્રાર્થયત, તતઃ પીલાતેનાનુમતે સતિ સ ગત્વા યીશો ર્દેહમ્ અનયત્| ");
INSERT INTO sanguj_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","અપરં યો નિકદીમો રાત્રૌ યીશોઃ સમીપમ્ અગચ્છત્ સોપિ ગન્ધરસેન મિશ્રિતં પ્રાયેણ પઞ્ચાશત્સેટકમગુરું ગૃહીત્વાગચ્છત્| ");
INSERT INTO sanguj_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","તતસ્તે યિહૂદીયાનાં શ્મશાને સ્થાપનરીત્યનુસારેણ તત્સુગન્ધિદ્રવ્યેણ સહિતં તસ્ય દેહં વસ્ત્રેણાવેષ્ટયન્| ");
INSERT INTO sanguj_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","અપરઞ્ચ યત્ર સ્થાને તં ક્રુશેઽવિધન્ તસ્ય નિકટસ્થોદ્યાને યત્ર કિમપિ મૃતદેહં કદાપિ નાસ્થાપ્યત તાદૃશમ્ એકં નૂતનં શ્મશાનમ્ આસીત્| ");
INSERT INTO sanguj_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","યિહૂદીયાનામ્ આસાદનદિનાગમનાત્ તે તસ્મિન્ સમીપસ્થશ્મશાને યીશુમ્ અશાયયન્| ");
INSERT INTO sanguj_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","અનન્તરં સપ્તાહસ્ય પ્રથમદિને ઽતિપ્રત્યૂષે ઽન્ધકારે તિષ્ઠતિ મગ્દલીની મરિયમ્ તસ્ય શ્મશાનસ્ય નિકટં ગત્વા શ્મશાનસ્ય મુખાત્ પ્રસ્તરમપસારિતમ્ અપશ્યત્| ");
INSERT INTO sanguj_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","પશ્ચાદ્ ધાવિત્વા શિમોન્પિતરાય યીશોઃ પ્રિયતમશિષ્યાય ચેદમ્ અકથયત્, લોકાઃ શ્મશાનાત્ પ્રભું નીત્વા કુત્રાસ્થાપયન્ તદ્ વક્તું ન શક્નોમિ| ");
INSERT INTO sanguj_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","અતઃ પિતરઃ સોન્યશિષ્યશ્ચ બર્હિ ર્ભુત્વા શ્મશાનસ્થાનં ગન્તુમ્ આરભેતાં| ");
INSERT INTO sanguj_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ઉભયોર્ધાવતોઃ સોન્યશિષ્યઃ પિતરં પશ્ચાત્ ત્યક્ત્વા પૂર્વ્વં શ્મશાનસ્થાન ઉપસ્થિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","તદા પ્રહ્વીભૂય સ્થાપિતવસ્ત્રાણિ દૃષ્ટવાન્ કિન્તુ ન પ્રાવિશત્| ");
INSERT INTO sanguj_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","અપરં શિમોન્પિતર આગત્ય શ્મશાનસ્થાનં પ્રવિશ્ય ");
INSERT INTO sanguj_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","સ્થાપિતવસ્ત્રાણિ મસ્તકસ્ય વસ્ત્રઞ્ચ પૃથક્ સ્થાનાન્તરે સ્થાપિતં દૃષ્ટવાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","તતઃ શ્મશાનસ્થાનં પૂર્વ્વમ્ આગતો યોન્યશિષ્યઃ સોપિ પ્રવિશ્ય તાદૃશં દૃષ્ટા વ્યશ્વસીત્| ");
INSERT INTO sanguj_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","યતઃ શ્મશાનાત્ સ ઉત્થાપયિતવ્ય એતસ્ય ધર્મ્મપુસ્તકવચનસ્ય ભાવં તે તદા વોદ્ધું નાશન્કુવન્| ");
INSERT INTO sanguj_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","અનન્તરં તૌ દ્વૌ શિષ્યૌ સ્વં સ્વં ગૃહં પરાવૃત્યાગચ્છતામ્| ");
INSERT INTO sanguj_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","તતઃ પરં મરિયમ્ શ્મશાનદ્વારસ્ય બહિઃ સ્થિત્વા રોદિતુમ્ આરભત તતો રુદતી પ્રહ્વીભૂય શ્મશાનં વિલોક્ય ");
INSERT INTO sanguj_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","યીશોઃ શયનસ્થાનસ્ય શિરઃસ્થાને પદતલે ચ દ્વયો ર્દિશો દ્વૌ સ્વર્ગીયદૂતાવુપવિષ્ટૌ સમપશ્યત્| ");
INSERT INTO sanguj_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","તૌ પૃષ્ટવન્તૌ હે નારિ કુતો રોદિષિ? સાવદત્ લોકા મમ પ્રભું નીત્વા કુત્રાસ્થાપયન્ ઇતિ ન જાનામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ઇત્યુક્ત્વા મુખં પરાવૃત્ય યીશું દણ્ડાયમાનમ્ અપશ્યત્ કિન્તુ સ યીશુરિતિ સા જ્ઞાતું નાશક્નોત્| ");
INSERT INTO sanguj_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","તદા યીશુસ્તામ્ અપૃચ્છત્ હે નારિ કુતો રોદિષિ? કં વા મૃગયસે? તતઃ સા તમ્ ઉદ્યાનસેવકં જ્ઞાત્વા વ્યાહરત્, હે મહેચ્છ ત્વં યદીતઃ સ્થાનાત્ તં નીતવાન્ તર્હિ કુત્રાસ્થાપયસ્તદ્ વદ તત્સ્થાનાત્ તમ્ આનયામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","તદા યીશુસ્તામ્ અવદત્ હે મરિયમ્| તતઃ સા પરાવૃત્ય પ્રત્યવદત્ હે રબ્બૂની અર્થાત્ હે ગુરો| ");
INSERT INTO sanguj_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","તદા યીશુરવદત્ માં મા ધર, ઇદાનીં પિતુઃ સમીપે ઊર્દ્ધ્વગમનં ન કરોમિ કિન્તુ યો મમ યુષ્માકઞ્ચ પિતા મમ યુષ્માકઞ્ચેશ્વરસ્તસ્ય નિકટ ઊર્દ્ધ્વગમનં કર્ત્તુમ્ ઉદ્યતોસ્મિ, ઇમાં કથાં ત્વં ગત્વા મમ ભ્રાતૃગણં જ્ઞાપય| ");
INSERT INTO sanguj_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","તતો મગ્દલીનીમરિયમ્ તત્ક્ષણાદ્ ગત્વા પ્રભુસ્તસ્યૈ દર્શનં દત્ત્વા કથા એતા અકથયદ્ ઇતિ વાર્ત્તાં શિષ્યેભ્યોઽકથયત્| ");
INSERT INTO sanguj_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","તતઃ પરં સપ્તાહસ્ય પ્રથમદિનસ્ય સન્ધ્યાસમયે શિષ્યા એકત્ર મિલિત્વા યિહૂદીયેભ્યો ભિયા દ્વારરુદ્ધમ્ અકુર્વ્વન્, એતસ્મિન્ કાલે યીશુસ્તેષાં મધ્યસ્થાને તિષ્ઠન્ અકથયદ્ યુષ્માકં કલ્યાણં ભૂયાત્| ");
INSERT INTO sanguj_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ઇત્યુક્ત્વા નિજહસ્તં કુક્ષિઞ્ચ દર્શિતવાન્, તતઃ શિષ્યાઃ પ્રભું દૃષ્ટ્વા હૃષ્ટા અભવન્| ");
INSERT INTO sanguj_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","યીશુઃ પુનરવદદ્ યુષ્માકં કલ્યાણં ભૂયાત્ પિતા યથા માં પ્રૈષયત્ તથાહમપિ યુષ્માન્ પ્રેષયામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ઇત્યુક્ત્વા સ તેષામુપરિ દીર્ઘપ્રશ્વાસં દત્ત્વા કથિતવાન્ પવિત્રમ્ આત્માનં ગૃહ્લીત| ");
INSERT INTO sanguj_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","યૂયં યેષાં પાપાનિ મોચયિષ્યથ તે મોચયિષ્યન્તે યેષાઞ્ચ પાપાતિ ન મોચયિષ્યથ તે ન મોચયિષ્યન્તે| ");
INSERT INTO sanguj_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","દ્વાદશમધ્યે ગણિતો યમજો થોમાનામા શિષ્યો યીશોરાગમનકાલૈ તૈઃ સાર્દ્ધં નાસીત્| ");
INSERT INTO sanguj_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","અતો વયં પ્રભૂમ્ અપશ્યામેતિ વાક્યેઽન્યશિષ્યૈરુક્તે સોવદત્, તસ્ય હસ્તયો ર્લૌહકીલકાનાં ચિહ્નં ન વિલોક્ય તચ્ચિહ્નમ્ અઙ્ગુલ્યા ન સ્પૃષ્ટ્વા તસ્ય કુક્ષૌ હસ્તં નારોપ્ય ચાહં ન વિશ્વસિષ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","અપરમ્ અષ્ટમેઽહ્નિ ગતે સતિ થોમાસહિતઃ શિષ્યગણ એકત્ર મિલિત્વા દ્વારં રુદ્ધ્વાભ્યન્તર આસીત્, એતર્હિ યીશુસ્તેષાં મધ્યસ્થાને તિષ્ઠન્ અકથયત્, યુષ્માકં કુશલં ભૂયાત્| ");
INSERT INTO sanguj_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","પશ્ચાત્ થામૈ કથિતવાન્ ત્વમ્ અઙ્ગુલીમ્ અત્રાર્પયિત્વા મમ કરૌ પશ્ય કરં પ્રસાર્ય્ય મમ કુક્ષાવર્પય નાવિશ્વસ્ય| ");
INSERT INTO sanguj_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","તદા થોમા અવદત્, હે મમ પ્રભો હે મદીશ્વર| ");
INSERT INTO sanguj_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","યીશુરકથયત્, હે થોમા માં નિરીક્ષ્ય વિશ્વસિષિ યે ન દૃષ્ટ્વા વિશ્વસન્તિ તએવ ધન્યાઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","એતદન્યાનિ પુસ્તકેઽસ્મિન્ અલિખિતાનિ બહૂન્યાશ્ચર્ય્યકર્મ્માણિ યીશુઃ શિષ્યાણાં પુરસ્તાદ્ અકરોત્| ");
INSERT INTO sanguj_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","કિન્તુ યીશુરીશ્વરસ્યાભિષિક્તઃ સુત એવેતિ યથા યૂયં વિશ્વસિથ વિશ્વસ્ય ચ તસ્ય નામ્ના પરમાયુઃ પ્રાપ્નુથ તદર્થમ્ એતાનિ સર્વ્વાણ્યલિખ્યન્ત| ");
INSERT INTO sanguj_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","તતઃ પરં તિબિરિયાજલધેસ્તટે યીશુઃ પુનરપિ શિષ્યેભ્યો દર્શનં દત્તવાન્ દર્શનસ્યાખ્યાનમિદમ્| ");
INSERT INTO sanguj_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","શિમોન્પિતરઃ યમજથોમા ગાલીલીયકાન્નાનગરનિવાસી નિથનેલ્ સિવદેઃ પુત્રાવન્યૌ દ્વૌ શિષ્યૌ ચૈતેષ્વેકત્ર મિલિતેષુ શિમોન્પિતરોઽકથયત્ મત્સ્યાન્ ધર્તું યામિ| ");
INSERT INTO sanguj_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","તતસ્તે વ્યાહરન્ તર્હિ વયમપિ ત્વયા સાર્દ્ધં યામઃ તદા તે બહિર્ગતાઃ સન્તઃ ક્ષિપ્રં નાવમ્ આરોહન્ કિન્તુ તસ્યાં રજન્યામ્ એકમપિ ન પ્રાપ્નુવન્| ");
INSERT INTO sanguj_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","પ્રભાતે સતિ યીશુસ્તટે સ્થિતવાન્ કિન્તુ સ યીશુરિતિ શિષ્યા જ્ઞાતું નાશક્નુવન્| ");
INSERT INTO sanguj_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","તદા યીશુરપૃચ્છત્, હે વત્સા સન્નિધૌ કિઞ્ચિત્ ખાદ્યદ્રવ્યમ્ આસ્તે? તેઽવદન્ કિમપિ નાસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","તદા સોઽવદત્ નૌકાયા દક્ષિણપાર્શ્વે જાલં નિક્ષિપત તતો લપ્સ્યધ્વે, તસ્માત્ તૈ ર્નિક્ષિપ્તે જાલે મત્સ્યા એતાવન્તોઽપતન્ યેન તે જાલમાકૃષ્ય નોત્તોલયિતું શક્તાઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","તસ્માદ્ યીશોઃ પ્રિયતમશિષ્યઃ પિતરાયાકથયત્ એષ પ્રભુ ર્ભવેત્, એષ પ્રભુરિતિ વાચં શ્રુત્વૈવ શિમોન્ નગ્નતાહેતો ર્મત્સ્યધારિણ ઉત્તરીયવસ્ત્રં પરિધાય હ્રદં પ્રત્યુદલમ્ફયત્| ");
INSERT INTO sanguj_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","અપરે શિષ્યા મત્સ્યૈઃ સાર્દ્ધં જાલમ્ આકર્ષન્તઃ ક્ષુદ્રનૌકાં વાહયિત્વા કૂલમાનયન્ તે કૂલાદ્ અતિદૂરે નાસન્ દ્વિશતહસ્તેભ્યો દૂર આસન્ ઇત્યનુમીયતે| ");
INSERT INTO sanguj_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","તીરં પ્રાપ્તૈસ્તૈસ્તત્ર પ્રજ્વલિતાગ્નિસ્તદુપરિ મત્સ્યાઃ પૂપાશ્ચ દૃષ્ટાઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","તતો યીશુરકથયદ્ યાન્ મત્સ્યાન્ અધરત તેષાં કતિપયાન્ આનયત| ");
INSERT INTO sanguj_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","અતઃ શિમોન્પિતરઃ પરાવૃત્ય ગત્વા બૃહદ્ભિસ્ત્રિપઞ્ચાશદધિકશતમત્સ્યૈઃ પરિપૂર્ણં તજ્જાલમ્ આકૃષ્યોદતોલયત્ કિન્ત્વેતાવદ્ભિ ર્મત્સ્યૈરપિ જાલં નાછિદ્યત| ");
INSERT INTO sanguj_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","અનન્તરં યીશુસ્તાન્ અવાદીત્ યૂયમાગત્ય ભુંગ્ધ્વં; તદા સએવ પ્રભુરિતિ જ્ઞાતત્વાત્ ત્વં કઃ? ઇતિ પ્રષ્ટું શિષ્યાણાં કસ્યાપિ પ્રગલ્ભતા નાભવત્| ");
INSERT INTO sanguj_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","તતો યીશુરાગત્ય પૂપાન્ મત્સ્યાંશ્ચ ગૃહીત્વા તેભ્યઃ પર્ય્યવેષયત્| ");
INSERT INTO sanguj_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ઇત્થં શ્મશાનાદુત્થાનાત્ પરં યીશુઃ શિષ્યેભ્યસ્તૃતીયવારં દર્શનં દત્તવાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ભોજને સમાપ્તે સતિ યીશુઃ શિમોન્પિતરં પૃષ્ટવાન્, હે યૂનસઃ પુત્ર શિમોન્ ત્વં કિમ્ એતેભ્યોધિકં મયિ પ્રીયસે? તતઃ સ ઉદિતવાન્ સત્યં પ્રભો ત્વયિ પ્રીયેઽહં તદ્ ભવાન્ જાનાતિ; તદા યીશુરકથયત્ તર્હિ મમ મેષશાવકગણં પાલય| ");
INSERT INTO sanguj_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","તતઃ સ દ્વિતીયવારં પૃષ્ટવાન્ હે યૂનસઃ પુત્ર શિમોન્ ત્વં કિં મયિ પ્રીયસે? તતઃ સ ઉક્તવાન્ સત્યં પ્રભો ત્વયિ પ્રીયેઽહં તદ્ ભવાન્ જાનાતિ; તદા યીશુરકથયત તર્હિ મમ મેષગણં પાલય| ");
INSERT INTO sanguj_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","પશ્ચાત્ સ તૃતીયવારં પૃષ્ટવાન્, હે યૂનસઃ પુત્ર શિમોન્ ત્વં કિં મયિ પ્રીયસે? એતદ્વાક્યં તૃતીયવારં પૃષ્ટવાન્ તસ્માત્ પિતરો દુઃખિતો ભૂત્વાઽકથયત્ હે પ્રભો ભવતઃ કિમપ્યગોચરં નાસ્તિ ત્વય્યહં પ્રીયે તદ્ ભવાન્ જાનાતિ; તતો યીશુરવદત્ તર્હિ મમ મેષગણં પાલય| ");
INSERT INTO sanguj_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","અહં તુભ્યં યથાર્થં કથયામિ યૌવનકાલે સ્વયં બદ્ધકટિ ર્યત્રેચ્છા તત્ર યાતવાન્ કિન્ત્વિતઃ પરં વૃદ્ધે વયસિ હસ્તં વિસ્તારયિષ્યસિ, અન્યજનસ્ત્વાં બદ્ધ્વા યત્ર ગન્તું તવેચ્છા ન ભવતિ ત્વાં ધૃત્વા તત્ર નેષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ફલતઃ કીદૃશેન મરણેન સ ઈશ્વરસ્ય મહિમાનં પ્રકાશયિષ્યતિ તદ્ બોધયિતું સ ઇતિ વાક્યં પ્રોક્તવાન્| ઇત્યુક્તે સતિ સ તમવોચત્ મમ પશ્ચાદ્ આગચ્છ| ");
INSERT INTO sanguj_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","યો જનો રાત્રિકાલે યીશો ર્વક્ષોઽવલમ્બ્ય, હે પ્રભો કો ભવન્તં પરકરેષુ સમર્પયિષ્યતીતિ વાક્યં પૃષ્ટવાન્, તં યીશોઃ પ્રિયતમશિષ્યં પશ્ચાદ્ આગચ્છન્તં ");
INSERT INTO sanguj_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","પિતરો મુખં પરાવર્ત્ત્ય વિલોક્ય યીશું પૃષ્ટવાન્, હે પ્રભો એતસ્ય માનવસ્ય કીદૃશી ગતિ ર્ભવિષ્યતિ? ");
INSERT INTO sanguj_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","સ પ્રત્યવદત્, મમ પુનરાગમનપર્ય્યન્તં યદિ તં સ્થાપયિતુમ્ ઇચ્છામિ તત્ર તવ કિં? ત્વં મમ પશ્ચાદ્ આગચ્છ| ");
INSERT INTO sanguj_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","તસ્માત્ સ શિષ્યો ન મરિષ્યતીતિ ભ્રાતૃગણમધ્યે કિંવદન્તી જાતા કિન્તુ સ ન મરિષ્યતીતિ વાક્યં યીશુ ર્નાવદત્ કેવલં મમ પુનરાગમનપર્ય્યન્તં યદિ તં સ્થાપયિતુમ્ ઇચ્છામિ તત્ર તવ કિં? ઇતિ વાક્યમ્ ઉક્તવાન્| ");
INSERT INTO sanguj_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","યો જન એતાનિ સર્વ્વાણિ લિખિતવાન્ અત્ર સાક્ષ્યઞ્ચ દત્તવાન્ સએવ સ શિષ્યઃ, તસ્ય સાક્ષ્યં પ્રમાણમિતિ વયં જાનીમઃ| ");
INSERT INTO sanguj_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","યીશુરેતેભ્યોઽપરાણ્યપિ બહૂનિ કર્મ્માણિ કૃતવાન્ તાનિ સર્વ્વાણિ યદ્યેકૈકં કૃત્વા લિખ્યન્તે તર્હિ ગ્રન્થા એતાવન્તો ભવન્તિ તેષાં ધારણે પૃથિવ્યાં સ્થાનં ન ભવતિ| ઇતિ||");
INSERT INTO sanguj_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","હે થિયફિલ, યીશુઃ સ્વમનોનીતાન્ પ્રેરિતાન્ પવિત્રેણાત્મના સમાદિશ્ય યસ્મિન્ દિને સ્વર્ગમારોહત્ યાં યાં ક્રિયામકરોત્ યદ્યદ્ ઉપાદિશચ્ચ તાનિ સર્વ્વાણિ પૂર્વ્વં મયા લિખિતાનિ| ");
INSERT INTO sanguj_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","સ સ્વનિધનદુઃખભોગાત્ પરમ્ અનેકપ્રત્યયક્ષપ્રમાણૌઃ સ્વં સજીવં દર્શયિત્વા ");
INSERT INTO sanguj_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ચત્વારિંશદ્દિનાનિ યાવત્ તેભ્યઃ પ્રેરિતેભ્યો દર્શનં દત્ત્વેશ્વરીયરાજ્યસ્ય વર્ણનમ અકરોત્| ");
INSERT INTO sanguj_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","અનન્તરં તેષાં સભાં કૃત્વા ઇત્યાજ્ઞાપયત્, યૂયં યિરૂશાલમોઽન્યત્ર ગમનમકૃત્વા યસ્તિન્ પિત્રાઙ્ગીકૃતે મમ વદનાત્ કથા અશૃણુત તત્પ્રાપ્તિમ્ અપેક્ષ્ય તિષ્ઠત| ");
INSERT INTO sanguj_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","યોહન્ જલે મજ્જિતાવાન્ કિન્ત્વલ્પદિનમધ્યે યૂયં પવિત્ર આત્મનિ મજ્જિતા ભવિષ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","પશ્ચાત્ તે સર્વ્વે મિલિત્વા તમ્ અપૃચ્છન્ હે પ્રભો ભવાન્ કિમિદાનીં પુનરપિ રાજ્યમ્ ઇસ્રાયેલીયલોકાનાં કરેષુ સમર્પયિષ્યતિ? ");
INSERT INTO sanguj_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","તતઃ સોવદત્ યાન્ સર્વ્વાન્ કાલાન્ સમયાંશ્ચ પિતા સ્વવશેઽસ્થાપયત્ તાન્ જ્ઞાતૃં યુષ્માકમ્ અધિકારો ન જાયતે| ");
INSERT INTO sanguj_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","કિન્તુ યુષ્માસુ પવિત્રસ્યાત્મન આવિર્ભાવે સતિ યૂયં શક્તિં પ્રાપ્ય યિરૂશાલમિ સમસ્તયિહૂદાશોમિરોણદેશયોઃ પૃથિવ્યાઃ સીમાં યાવદ્ યાવન્તો દેશાસ્તેષુ યર્વ્વેષુ ચ મયિ સાક્ષ્યં દાસ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ઇતિ વાક્યમુક્ત્વા સ તેષાં સમક્ષં સ્વર્ગં નીતોઽભવત્, તતો મેઘમારુહ્ય તેષાં દૃષ્ટેરગોચરોઽભવત્| ");
INSERT INTO sanguj_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","યસ્મિન્ સમયે તે વિહાયસં પ્રત્યનન્યદૃષ્ટ્યા તસ્ય તાદૃશમ્ ઊર્દ્વ્વગમનમ્ અપશ્યન્ તસ્મિન્નેવ સમયે શુક્લવસ્ત્રૌ દ્વૌ જનૌ તેષાં સન્નિધૌ દણ્ડાયમાનૌ કથિતવન્તૌ, ");
INSERT INTO sanguj_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","હે ગાલીલીયલોકા યૂયં કિમર્થં ગગણં પ્રતિ નિરીક્ષ્ય દણ્ડાયમાનાસ્તિષ્ઠથ? યુષ્માકં સમીપાત્ સ્વર્ગં નીતો યો યીશુસ્તં યૂયં યથા સ્વર્ગમ્ આરોહન્તમ્ અદર્શમ્ તથા સ પુનશ્ચાગમિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","તતઃ પરં તે જૈતુનનામ્નઃ પર્વ્વતાદ્ વિશ્રામવારસ્ય પથઃ પરિમાણમ્ અર્થાત્ પ્રાયેણાર્દ્ધક્રોશં દુરસ્થં યિરૂશાલમ્નગરં પરાવૃત્યાગચ્છન્| ");
INSERT INTO sanguj_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","નગરં પ્રવિશ્ય પિતરો યાકૂબ્ યોહન્ આન્દ્રિયઃ ફિલિપઃ થોમા બર્થજમયો મથિરાલ્ફીયપુત્રો યાકૂબ્ ઉદ્યોગાी શિમોન્ યાકૂબો ભ્રાતા યિહૂદા એતે સર્વ્વે યત્ર સ્થાને પ્રવસન્તિ તસ્મિન્ ઉપરિતનપ્રકોષ્ઠે પ્રાવિશન્| ");
INSERT INTO sanguj_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","પશ્ચાદ્ ઇમે કિયત્યઃ સ્ત્રિયશ્ચ યીશો ર્માતા મરિયમ્ તસ્ય ભ્રાતરશ્ચૈતે સર્વ્વ એકચિત્તીભૂત સતતં વિનયેન વિનયેન પ્રાર્થયન્ત| ");
INSERT INTO sanguj_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","તસ્મિન્ સમયે તત્ર સ્થાને સાકલ્યેન વિંશત્યધિકશતં શિષ્યા આસન્| તતઃ પિતરસ્તેષાં મધ્યે તિષ્ઠન્ ઉક્તવાન્ ");
INSERT INTO sanguj_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","હે ભ્રાતૃગણ યીશુધારિણાં લોકાનાં પથદર્શકો યો યિહૂદાસ્તસ્મિન્ દાયૂદા પવિત્ર આત્મા યાં કથાં કથયામાસ તસ્યાઃ પ્રત્યક્ષીભવનસ્યાવશ્યકત્વમ્ આસીત્| ");
INSERT INTO sanguj_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","સ જનોઽસ્માકં મધ્યવર્ત્તી સન્ અસ્યાઃ સેવાયા અંશમ્ અલભત| ");
INSERT INTO sanguj_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","તદનન્તરં કુકર્મ્મણા લબ્ધં યન્મૂલ્યં તેન ક્ષેત્રમેકં ક્રીતમ્ અપરં તસ્મિન્ અધોમુખે ભૃમૌ પતિતે સતિ તસ્યોદરસ્ય વિદીર્ણત્વાત્ સર્વ્વા નાડ્યો નિરગચ્છન્| ");
INSERT INTO sanguj_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","એતાં કથાં યિરૂશાલમ્નિવાસિનઃ સર્વ્વે લોકા વિદાન્તિ; તેષાં નિજભાષયા તત્ક્ષેત્રઞ્ચ હકલ્દામા, અર્થાત્ રક્તક્ષેત્રમિતિ વિખ્યાતમાસ્તે| ");
INSERT INTO sanguj_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","અન્યચ્ચ, નિકેતનં તદીયન્તુ શુન્યમેવ ભવિષ્યતિ| તસ્ય દૂષ્યે નિવાસાર્થં કોપિ સ્થાસ્યતિ નૈવ હિ| અન્ય એવ જનસ્તસ્ય પદં સંપ્રાપ્સ્યતિ ધ્રુવં| ઇત્થં ગીતપુસ્તકે લિખિતમાસ્તે| ");
INSERT INTO sanguj_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","અતો યોહનો મજ્જનમ્ આરભ્યાસ્માકં સમીપાત્ પ્રભો ર્યીશોઃ સ્વર્ગારોહણદિનં યાવત્ સોસ્માકં મધ્યે યાવન્તિ દિનાનિ યાપિતવાન્ ");
INSERT INTO sanguj_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","તાવન્તિ દિનાનિ યે માનવા અસ્માભિઃ સાર્દ્ધં તિષ્ઠન્તિ તેષામ્ એકેન જનેનાસ્માભિઃ સાર્દ્ધં યીશોરુત્થાને સાક્ષિણા ભવિતવ્યં| ");
INSERT INTO sanguj_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","અતો યસ્ય રૂઢિ ર્યુષ્ટો યં બર્શબ્બેત્યુક્ત્વાહૂયન્તિ સ યૂષફ્ મતથિશ્ચ દ્વાવેતૌ પૃથક્ કૃત્વા ત ઈશ્વરસ્ય સન્નિધૌ પ્રાર્ય્ય કથિતવન્તઃ, ");
INSERT INTO sanguj_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","હે સર્વ્વાન્તર્ય્યામિન્ પરમેશ્વર, યિહૂદાઃ સેવનપ્રેરિતત્વપદચ્યુતઃ ");
INSERT INTO sanguj_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","સન્ નિજસ્થાનમ્ અગચ્છત્, તત્પદં લબ્ધુમ્ એનયો ર્જનયો ર્મધ્યે ભવતા કોઽભિરુચિતસ્તદસ્માન્ દર્શ્યતાં| ");
INSERT INTO sanguj_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","તતો ગુટિકાપાટે કૃતે મતથિર્નિરચીયત તસ્માત્ સોન્યેષામ્ એકાદશાનાં પ્રરિતાનાં મધ્યે ગણિતોભવત્| ");
INSERT INTO sanguj_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","અપરઞ્ચ નિસ્તારોત્સવાત્ પરં પઞ્ચાશત્તમે દિને સમુપસ્થિતે સતિ તે સર્વ્વે એકાચિત્તીભૂય સ્થાન એકસ્મિન્ મિલિતા આસન્| ");
INSERT INTO sanguj_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","એતસ્મિન્નેવ સમયેઽકસ્માદ્ આકાશાત્ પ્રચણ્ડાત્યુગ્રવાયોઃ શબ્દવદ્ એકઃ શબ્દ આગત્ય યસ્મિન્ ગૃહે ત ઉપાવિશન્ તદ્ ગૃહં સમસ્તં વ્યાપ્નોત્| ");
INSERT INTO sanguj_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","તતઃ પરં વહ્નિશિખાસ્વરૂપા જિહ્વાઃ પ્રત્યક્ષીભૂય વિભક્તાઃ સત્યઃ પ્રતિજનોર્દ્ધ્વે સ્થગિતા અભૂવન્| ");
INSERT INTO sanguj_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","તસ્માત્ સર્વ્વે પવિત્રેણાત્મના પરિપૂર્ણાઃ સન્ત આત્મા યથા વાચિતવાન્ તદનુસારેણાન્યદેશીયાનાં ભાષા ઉક્તવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","તસ્મિન્ સમયે પૃથિવીસ્થસર્વ્વદેશેભ્યો યિહૂદીયમતાવલમ્બિનો ભક્તલોકા યિરૂશાલમિ પ્રાવસન્; ");
INSERT INTO sanguj_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","તસ્યાઃ કથાયાઃ કિંવદન્ત્યા જાતત્વાત્ સર્વ્વે લોકા મિલિત્વા નિજનિજભાષયા શિષ્યાણાં કથાકથનં શ્રુત્વા સમુદ્વિગ્ના અભવન્| ");
INSERT INTO sanguj_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","સર્વ્વએવ વિસ્મયાપન્ના આશ્ચર્ય્યાન્વિતાશ્ચ સન્તઃ પરસ્પરં ઉક્તવન્તઃ પશ્યત યે કથાં કથયન્તિ તે સર્વ્વે ગાલીલીયલોકાઃ કિં ન ભવન્તિ? ");
INSERT INTO sanguj_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","તર્હિ વયં પ્રત્યેકશઃ સ્વસ્વજન્મદેશીયભાષાભિઃ કથા એતેષાં શૃણુમઃ કિમિદં? ");
INSERT INTO sanguj_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","પાર્થી-માદી-અરામ્નહરયિમ્દેશનિવાસિમનો યિહૂદા-કપ્પદકિયા-પન્ત-આશિયા- ");
INSERT INTO sanguj_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ફ્રુગિયા-પમ્ફુલિયા-મિસરનિવાસિનઃ કુરીણીનિકટવર્ત્તિલૂબીયપ્રદેશનિવાસિનો રોમનગરાદ્ આગતા યિહૂદીયલોકા યિહૂદીયમતગ્રાહિણઃ ક્રીતીયા અરાબીયાદયો લોકાશ્ચ યે વયમ્ ");
INSERT INTO sanguj_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","અસ્માકં નિજનિજભાષાભિરેતેષામ્ ઈશ્વરીયમહાકર્મ્મવ્યાખ્યાનં શૃણુમઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ઇત્થં તે સર્વ્વએવ વિસ્મયાપન્નાઃ સન્દિગ્ધચિત્તાઃ સન્તઃ પરસ્પરમૂચુઃ, અસ્ય કો ભાવઃ? ");
INSERT INTO sanguj_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","અપરે કેચિત્ પરિહસ્ય કથિતવન્ત એતે નવીનદ્રાક્ષારસેન મત્તા અભવન્| ");
INSERT INTO sanguj_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","તદા પિતર એકાદશભિ ર્જનૈઃ સાકં તિષ્ઠન્ તાલ્લોકાન્ ઉચ્ચૈઃકારમ્ અવદત્, હે યિહૂદીયા હે યિરૂશાલમ્નિવાસિનઃ સર્વ્વે, અવધાનં કૃત્વા મદીયવાક્યં બુધ્યધ્વં| ");
INSERT INTO sanguj_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ઇદાનીમ્ એકયામાદ્ અધિકા વેલા નાસ્તિ તસ્માદ્ યૂયં યદ્ અનુમાથ માનવા ઇમે મદ્યપાનેન મત્તાસ્તન્ન| ");
INSERT INTO sanguj_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","કિન્તુ યોયેલ્ભવિષ્યદ્વક્ત્રૈતદ્વાક્યમુક્તં યથા, ");
INSERT INTO sanguj_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","ઈશ્વરઃ કથયામાસ યુગાન્તસમયે ત્વહમ્| વર્ષિષ્યામિ સ્વમાત્માનં સર્વ્વપ્રાણ્યુપરિ ધ્રુવમ્| ભાવિવાક્યં વદિષ્યન્તિ કન્યાઃ પુત્રાશ્ચ વસ્તુતઃ| પ્રત્યાદેશઞ્ચ પ્રાપ્સ્યન્તિ યુષ્માકં યુવમાનવાઃ| તથા પ્રાચીનલોકાસ્તુ સ્વપ્નાન્ દ્રક્ષ્યન્તિ નિશ્ચિતં| ");
INSERT INTO sanguj_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","વર્ષિષ્યામિ તદાત્માનં દાસદાસીજનોપિરિ| તેનૈવ ભાવિવાક્યં તે વદિષ્યન્તિ હિ સર્વ્વશઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ઊર્દ્ધ્વસ્થે ગગણે ચૈવ નીચસ્થે પૃથિવીતલે| શોણિતાનિ બૃહદ્ભાનૂન્ ઘનધૂમાદિકાનિ ચ| ચિહ્નાનિ દર્શયિષ્યામિ મહાશ્ચર્ય્યક્રિયાસ્તથા| ");
INSERT INTO sanguj_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","મહાભયાનકસ્યૈવ તદ્દિનસ્ય પરેશિતુઃ| પુરાગમાદ્ રવિઃ કૃષ્ણો રક્તશ્ચન્દ્રો ભવિષ્યતઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","કિન્તુ યઃ પરમેશસ્ય નામ્નિ સમ્પ્રાર્થયિષ્યતે| સએવ મનુજો નૂનં પરિત્રાતો ભવિષ્યતિ|| ");
INSERT INTO sanguj_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","અતો હે ઇસ્રાયેલ્વંશીયલોકાઃ સર્વ્વે કથાયામેતસ્યામ્ મનો નિધદ્ધ્વં નાસરતીયો યીશુરીશ્વરસ્ય મનોનીતઃ પુમાન્ એતદ્ ઈશ્વરસ્તત્કૃતૈરાશ્ચર્ય્યાદ્ભુતકર્મ્મભિ ર્લક્ષણૈશ્ચ યુષ્માકં સાક્ષાદેવ પ્રતિપાદિતવાન્ ઇતિ યૂયં જાનીથ| ");
INSERT INTO sanguj_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","તસ્મિન્ યીશૌ ઈશ્વરસ્ય પૂર્વ્વનિશ્ચિતમન્ત્રણાનિરૂપણાનુસારેણ મૃત્યૌ સમર્પિતે સતિ યૂયં તં ધૃત્વા દુષ્ટલોકાનાં હસ્તૈઃ ક્રુશે વિધિત્વાહત| ");
INSERT INTO sanguj_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","કિન્ત્વીશ્વરસ્તં નિધનસ્ય બન્ધનાન્મોચયિત્વા ઉદસ્થાપયત્ યતઃ સ મૃત્યુના બદ્ધસ્તિષ્ઠતીતિ ન સમ્ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","એતસ્તિન્ દાયૂદપિ કથિતવાન્ યથા, સર્વ્વદા મમ સાક્ષાત્તં સ્થાપય પરમેશ્વરં| સ્થિતે મદ્દક્ષિણે તસ્મિન્ સ્ખલિષ્યામિ ત્વહં નહિ| ");
INSERT INTO sanguj_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","આનન્દિષ્યતિ તદ્ધેતો ર્મામકીનં મનસ્તુ વૈ| આહ્લાદિષ્યતિ જિહ્વાપિ મદીયા તુ તથૈવ ચ| પ્રત્યાશયા શરીરન્તુ મદીયં વૈશયિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","પરલોકે યતો હેતોસ્ત્વં માં નૈવ હિ ત્યક્ષ્યસિ| સ્વકીયં પુણ્યવન્તં ત્વં ક્ષયિતું નૈવ દાસ્યસિ| એવં જીવનમાર્ગં ત્વં મામેવ દર્શયિષ્યસિ| ");
INSERT INTO sanguj_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","સ્વસમ્મુખે ય આનન્દો દક્ષિણે સ્વસ્ય યત્ સુખં| અનન્તં તેન માં પૂર્ણં કરિષ્યસિ ન સંશયઃ|| ");
INSERT INTO sanguj_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","હે ભ્રાતરોઽસ્માકં તસ્ય પૂર્વ્વપુરુષસ્ય દાયૂદઃ કથાં સ્પષ્ટં કથયિતું મામ્ અનુમન્યધ્વં, સ પ્રાણાન્ ત્યક્ત્વા શ્મશાને સ્થાપિતોભવદ્ અદ્યાપિ તત્ શ્મશાનમ્ અસ્માકં સન્નિધૌ વિદ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","ફલતો લૌકિકભાવેન દાયૂદો વંશે ખ્રીષ્ટં જન્મ ગ્રાહયિત્વા તસ્યૈવ સિંહાસને સમુવેષ્ટું તમુત્થાપયિષ્યતિ પરમેશ્વરઃ શપથં કુત્વા દાયૂદઃ સમીપ ઇમમ્ અઙ્ગીકારં કૃતવાન્, ");
INSERT INTO sanguj_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ઇતિ જ્ઞાત્વા દાયૂદ્ ભવિષ્યદ્વાદી સન્ ભવિષ્યત્કાલીયજ્ઞાનેન ખ્રીષ્ટોત્થાને કથામિમાં કથયામાસ યથા તસ્યાત્મા પરલોકે ન ત્યક્ષ્યતે તસ્ય શરીરઞ્ચ ન ક્ષેષ્યતિ; ");
INSERT INTO sanguj_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","અતઃ પરમેશ્વર એનં યીશું શ્મશાનાદ્ ઉદસ્થાપયત્ તત્ર વયં સર્વ્વે સાક્ષિણ આસ્મહે| ");
INSERT INTO sanguj_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","સ ઈશ્વરસ્ય દક્ષિણકરેણોન્નતિં પ્રાપ્ય પવિત્ર આત્મિન પિતા યમઙ્ગીકારં કૃતવાન્ તસ્ય ફલં પ્રાપ્ય યત્ પશ્યથ શૃણુથ ચ તદવર્ષત્| ");
INSERT INTO sanguj_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","યતો દાયૂદ્ સ્વર્ગં નારુરોહ કિન્તુ સ્વયમ્ ઇમાં કથામ્ અકથયદ્ યથા, મમ પ્રભુમિદં વાક્યમવદત્ પરમેશ્વરઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","તવ શત્રૂનહં યાવત્ પાદપીઠં કરોમિ ન| તાવત્ કાલં મદીયે ત્વં દક્ષવાર્શ્વ ઉપાવિશ| ");
INSERT INTO sanguj_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","અતો યં યીશું યૂયં ક્રુશેઽહત પરમેશ્વરસ્તં પ્રભુત્વાભિષિક્તત્વપદે ન્યયુંક્તેતિ ઇસ્રાયેલીયા લોકા નિશ્ચિતં જાનન્તુ| ");
INSERT INTO sanguj_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","એતાદૃશીં કથાં શ્રુત્વા તેષાં હૃદયાનાં વિદીર્ણત્વાત્ તે પિતરાય તદન્યપ્રેરિતેભ્યશ્ચ કથિતવન્તઃ, હે ભ્રાતૃગણ વયં કિં કરિષ્યામઃ? ");
INSERT INTO sanguj_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","તતઃ પિતરઃ પ્રત્યવદદ્ યૂયં સર્વ્વે સ્વં સ્વં મનઃ પરિવર્ત્તયધ્વં તથા પાપમોચનાર્થં યીશુખ્રીષ્ટસ્ય નામ્ના મજ્જિતાશ્ચ ભવત, તસ્માદ્ દાનરૂપં પરિત્રમ્ આત્માનં લપ્સ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","યતો યુષ્માકં યુષ્મત્સન્તાનાનાઞ્ચ દૂરસ્થસર્વ્વલોકાનાઞ્ચ નિમિત્તમ્ અર્થાદ્ અસ્માકં પ્રભુઃ પરમેશ્વરો યાવતો લાકાન્ આહ્વાસ્યતિ તેષાં સર્વ્વેષાં નિમિત્તમ્ અયમઙ્ગીકાર આસ્તે| ");
INSERT INTO sanguj_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","એતદન્યાભિ ર્બહુકથાભિઃ પ્રમાણં દત્વાકથયત્ એતેભ્યો વિપથગામિભ્યો વર્ત્તમાનલોકેભ્યઃ સ્વાન્ રક્ષત| ");
INSERT INTO sanguj_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","તતઃ પરં યે સાનન્દાસ્તાં કથામ્ અગૃહ્લન્ તે મજ્જિતા અભવન્| તસ્મિન્ દિવસે પ્રાયેણ ત્રીણિ સહસ્રાણિ લોકાસ્તેષાં સપક્ષાઃ સન્તઃ ");
INSERT INTO sanguj_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","પ્રેરિતાનામ્ ઉપદેશે સઙ્ગતૌ પૂપભઞ્જને પ્રાર્થનાસુ ચ મનઃસંયોગં કૃત્વાતિષ્ઠન્| ");
INSERT INTO sanguj_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","પ્રેરિતૈ ર્નાનાપ્રકારલક્ષણેષુ મહાશ્ચર્ય્યકર્મમસુ ચ દર્શિતેષુ સર્વ્વલોકાનાં ભયમુપસ્થિતં| ");
INSERT INTO sanguj_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","વિશ્વાસકારિણઃ સર્વ્વ ચ સહ તિષ્ઠનતઃ| સ્વેષાં સર્વ્વાઃ સમ્પત્તીઃ સાધારણ્યેન સ્થાપયિત્વાભુઞ્જત| ");
INSERT INTO sanguj_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ફલતો ગૃહાણિ દ્રવ્યાણિ ચ સર્વ્વાણિ વિક્રીય સર્વ્વેષાં સ્વસ્વપ્રયોજનાનુસારેણ વિભજ્ય સર્વ્વેભ્યોઽદદન્| ");
INSERT INTO sanguj_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","સર્વ્વ એકચિત્તીભૂય દિને દિને મન્દિરે સન્તિષ્ઠમાના ગૃહે ગૃહે ચ પૂપાનભઞ્જન્ત ઈશ્વરસ્ય ધન્યવાદં કુર્વ્વન્તો લોકૈઃ સમાદૃતાઃ પરમાનન્દેન સરલાન્તઃકરણેન ભોજનં પાનઞ્ચકુર્વ્વન્| ");
INSERT INTO sanguj_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","પરમેશ્વરો દિને દિને પરિત્રાણભાજનૈ ર્મણ્ડલીમ્ અવર્દ્ધયત્| ");
INSERT INTO sanguj_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","તૃતીયયામવેલાયાં સત્યાં પ્રાર્થનાયાઃ સમયે પિતરયોહનૌ સમ્ભૂય મન્દિરં ગચ્છતઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","તસ્મિન્નેવ સમયે મન્દિરપ્રવેશકાનાં સમીપે ભિક્ષારણાર્થં યં જન્મખઞ્જમાનુષં લોકા મન્દિરસ્ય સુન્દરનામ્નિ દ્વારે પ્રતિદિનમ્ અસ્થાપયન્ તં વહન્તસ્તદ્વારં આનયન્| ");
INSERT INTO sanguj_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","તદા પિતરયોહનૌ મન્તિરં પ્રવેષ્ટુમ્ ઉદ્યતૌ વિલોક્ય સ ખઞ્જસ્તૌ કિઞ્ચિદ્ ભિક્ષિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","તસ્માદ્ યોહના સહિતઃ પિતરસ્તમ્ અનન્યદૃષ્ટ્યા નિરીક્ષ્ય પ્રોક્તવાન્ આવાં પ્રતિ દૃષ્ટિં કુરુ| ");
INSERT INTO sanguj_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","તતઃ સ કિઞ્ચિત્ પ્રાપ્ત્યાશયા તૌ પ્રતિ દૃષ્ટિં કૃતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","તદા પિતરો ગદિતવાન્ મમ નિકટે સ્વર્ણરૂપ્યાદિ કિમપિ નાસ્તિ કિન્તુ યદાસ્તે તદ્ દદામિ નાસરતીયસ્ય યીશુખ્રીષ્ટસ્ય નામ્ના ત્વમુત્થાય ગમનાગમને કુરુ| ");
INSERT INTO sanguj_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","તતઃ પરં સ તસ્ય દક્ષિણકરં ધૃત્વા તમ્ ઉદતોલયત્; તેન તત્ક્ષણાત્ તસ્ય જનસ્ય પાદગુલ્ફયોઃ સબલત્વાત્ સ ઉલ્લમ્ફ્ય પ્રોત્થાય ગમનાગમને ઽકરોત્| ");
INSERT INTO sanguj_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","તતો ગમનાગમને કુર્વ્વન્ ઉલ્લમ્ફન્ ઈશ્વરં ધન્યં વદન્ તાભ્યાં સાર્દ્ધં મન્દિરં પ્રાવિશત્| ");
INSERT INTO sanguj_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","તતઃ સર્વ્વે લોકાસ્તં ગમનાગમને કુર્વ્વન્તમ્ ઈશ્વરં ધન્યં વદન્તઞ્ચ વિલોક્ય ");
INSERT INTO sanguj_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","મન્દિરસ્ય સુન્દરે દ્વારે ય ઉપવિશ્ય ભિક્ષિતવાન્ સએવાયમ્ ઇતિ જ્ઞાત્વા તં પ્રતિ તયા ઘટનયા ચમત્કૃતા વિસ્મયાપન્નાશ્ચાભવન્| ");
INSERT INTO sanguj_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","યઃ ખઞ્જઃ સ્વસ્થોભવત્ તેન પિતરયોહનોઃ કરયોર્ધ્ટતયોઃ સતોઃ સર્વ્વે લોકા સન્નિધિમ્ આગચ્છન્| ");
INSERT INTO sanguj_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","તદ્ દૃષ્ટ્વા પિતરસ્તેભ્યોઽકથયત્, હે ઇસ્રાયેલીયલોકા યૂયં કુતો ઽનેનાશ્ચર્ય્યં મન્યધ્વે? આવાં નિજશક્ત્યા યદ્વા નિજપુણ્યેન ખઞ્જમનુષ્યમેનં ગમિતવન્તાવિતિ ચિન્તયિત્વા આવાં પ્રતિ કુતોઽનન્યદૃષ્ટિં કુરુથ? ");
INSERT INTO sanguj_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","યં યીશું યૂયં પરકરેષુ સમાર્પયત તતો યં પીલાતો મોચયિતુમ્ એैચ્છત્ તથાપિ યૂયં તસ્ય સાક્ષાન્ નાઙ્ગીકૃતવન્ત ઇબ્રાહીમ ઇસ્હાકો યાકૂબશ્ચેશ્વરોઽર્થાદ્ અસ્માકં પૂર્વ્વપુરુષાણામ્ ઈશ્વરઃ સ્વપુત્રસ્ય તસ્ય યીશો ર્મહિમાનં પ્રાકાશયત્| ");
INSERT INTO sanguj_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","કિન્તુ યૂયં તં પવિત્રં ધાર્મ્મિકં પુમાંસં નાઙ્ગીકૃત્ય હત્યાકારિણમેકં સ્વેભ્યો દાતુમ્ અયાચધ્વં| ");
INSERT INTO sanguj_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","પશ્ચાત્ તં જીવનસ્યાધિપતિમ્ અહત કિન્ત્વીશ્વરઃ શ્મશાનાત્ તમ્ ઉદસ્થાપયત તત્ર વયં સાક્ષિણ આસ્મહે| ");
INSERT INTO sanguj_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ઇમં યં માનુષં યૂયં પશ્યથ પરિચિનુથ ચ સ તસ્ય નામ્નિ વિશ્વાસકરણાત્ ચલનશક્તિં લબ્ધવાન્ તસ્મિન્ તસ્ય યો વિશ્વાસઃ સ તં યુષ્માકં સર્વ્વેષાં સાક્ષાત્ સમ્પૂર્ણરૂપેણ સ્વસ્થમ્ અકાર્ષીત્| ");
INSERT INTO sanguj_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","હે ભ્રાતરો યૂયં યુષ્માકમ્ અધિપતયશ્ચ અજ્ઞાત્વા કર્મ્માણ્યેતાનિ કૃતવન્ત ઇદાનીં મમૈષ બોધો જાયતે| ");
INSERT INTO sanguj_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","કિન્ત્વીશ્વરઃ ખ્રીષ્ટસ્ય દુઃખભોગે ભવિષ્યદ્વાદિનાં મુખેભ્યો યાં યાં કથાં પૂર્વ્વમકથયત્ તાઃ કથા ઇત્થં સિદ્ધા અકરોત્| ");
INSERT INTO sanguj_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","અતઃ સ્વેષાં પાપમોચનાર્થં ખેદં કૃત્વા મનાંસિ પરિવર્ત્તયધ્વં, તસ્માદ્ ઈશ્વરાત્ સાન્ત્વનાપ્રાપ્તેઃ સમય ઉપસ્થાસ્યતિ; ");
INSERT INTO sanguj_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","પુનશ્ચ પૂર્વ્વકાલમ્ આરભ્ય પ્રચારિતો યો યીશુખ્રીષ્ટસ્તમ્ ઈશ્વરો યુષ્માન્ પ્રતિ પ્રેષયિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","કિન્તુ જગતઃ સૃષ્ટિમારભ્ય ઈશ્વરો નિજપવિત્રભવિષ્યદ્વાદિગણોન યથા કથિતવાન્ તદનુસારેણ સર્વ્વેષાં કાર્ય્યાણાં સિદ્ધિપર્ય્યન્તં તેન સ્વર્ગે વાસઃ કર્ત્તવ્યઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","યુષ્માકં પ્રભુઃ પરમેશ્વરો યુષ્માકં ભ્રાતૃગણમધ્યાત્ મત્સદૃશં ભવિષ્યદ્વક્તારમ્ ઉત્પાદયિષ્યતિ, તતઃ સ યત્ કિઞ્ચિત્ કથયિષ્યતિ તત્ર યૂયં મનાંસિ નિધદ્ધ્વં| ");
INSERT INTO sanguj_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","કિન્તુ યઃ કશ્ચિત્ પ્રાણી તસ્ય ભવિષ્યદ્વાદિનઃ કથાં ન ગ્રહીષ્યતિ સ નિજલોકાનાં મધ્યાદ્ ઉચ્છેત્સ્યતે,\" ઇમાં કથામ્ અસ્માકં પૂર્વ્વપુરુષેભ્યઃ કેવલો મૂસાઃ કથયામાસ ઇતિ નહિ, ");
INSERT INTO sanguj_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","શિમૂયેલ્ભવિષ્યદ્વાદિનમ્ આરભ્ય યાવન્તો ભવિષ્યદ્વાક્યમ્ અકથયન્ તે સર્વ્વએવ સમયસ્યૈતસ્ય કથામ્ અકથયન્| ");
INSERT INTO sanguj_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","યૂયમપિ તેષાં ભવિષ્યદ્વાદિનાં સન્તાનાઃ, \"તવ વંશોદ્ભવપુંસા સર્વ્વદેશીયા લોકા આશિષં પ્રાપ્તા ભવિષ્યન્તિ\", ઇબ્રાહીમે કથામેતાં કથયિત્વા ઈશ્વરોસ્માકં પૂર્વ્વપુરુષૈઃ સાર્દ્ધં યં નિયમં સ્થિરીકૃતવાન્ તસ્ય નિયમસ્યાધિકારિણોપિ યૂયં ભવથ| ");
INSERT INTO sanguj_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","અત ઈશ્વરો નિજપુત્રં યીશુમ્ ઉત્થાપ્ય યુષ્માકં સર્વ્વેષાં સ્વસ્વપાપાત્ પરાવર્ત્ત્ય યુષ્મભ્યમ્ આશિષં દાતું પ્રથમતસ્તં યુષ્માકં નિકટં પ્રેષિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","યસ્મિન્ સમયે પિતરયોહનૌ લોકાન્ ઉપદિશતસ્તસ્મિન્ સમયે યાજકા મન્દિરસ્ય સેનાપતયઃ સિદૂકીગણશ્ચ ");
INSERT INTO sanguj_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","તયોર્ ઉપદેશકરણે ખ્રીષ્ટસ્યોત્થાનમ્ ઉપલક્ષ્ય સર્વ્વેષાં મૃતાનામ્ ઉત્થાનપ્રસ્તાવે ચ વ્યગ્રાઃ સન્તસ્તાવુપાગમન્| ");
INSERT INTO sanguj_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","તૌ ધૃત્વા દિનાવસાનકારણાત્ પરદિનપર્ય્યનન્તં રુદ્ધ્વા સ્થાપિતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","તથાપિ યે લોકાસ્તયોરુપદેશમ્ અશૃણ્વન્ તેષાં પ્રાયેણ પઞ્ચસહસ્રાણિ જના વ્યશ્વસન્| ");
INSERT INTO sanguj_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","પરેઽહનિ અધિપતયઃ પ્રાચીના અધ્યાપકાશ્ચ હાનનનામા મહાયાજકઃ ");
INSERT INTO sanguj_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","કિયફા યોહન્ સિકન્દર ઇત્યાદયો મહાયાજકસ્ય જ્ઞાતયઃ સર્વ્વે યિરૂશાલમ્નગરે મિલિતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","અનન્તરં પ્રેરિતૌ મધ્યે સ્થાપયિત્વાપૃચ્છન્ યુવાં કયા શક્તયા વા કેન નામ્ના કર્મ્માણ્યેતાનિ કુરુથઃ? ");
INSERT INTO sanguj_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","તદા પિતરઃ પવિત્રેણાત્મના પરિપૂર્ણઃ સન્ પ્રત્યવાદીત્, હે લોકાનામ્ અધિપતિગણ હે ઇસ્રાયેલીયપ્રાચીનાઃ, ");
INSERT INTO sanguj_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","એતસ્ય દુર્બ્બલમાનુષસ્ય હિતં યત્ કર્મ્માક્રિયત, અર્થાત્, સ યેન પ્રકારેણ સ્વસ્થોભવત્ તચ્ચેદ્ અદ્યાવાં પૃચ્છથ, ");
INSERT INTO sanguj_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","તર્હિ સર્વ્વ ઇસ્રાયેेલીયલોકા યૂયં જાનીત નાસરતીયો યો યીશુખ્રીષ્ટઃ ક્રુશે યુષ્માભિરવિધ્યત યશ્ચેશ્વરેણ શ્મશાનાદ્ ઉત્થાપિતઃ, તસ્ય નામ્ના જનોયં સ્વસ્થઃ સન્ યુષ્માકં સમ્મુખે પ્રોત્તિષ્ઠતિ| ");
INSERT INTO sanguj_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","નિચેતૃભિ ર્યુષ્માભિરયં યઃ પ્રસ્તરોઽવજ્ઞાતોઽભવત્ સ પ્રધાનકોણસ્ય પ્રસ્તરોઽભવત્| ");
INSERT INTO sanguj_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","તદ્ભિન્નાદપરાત્ કસ્માદપિ પરિત્રાણં ભવિતું ન શક્નોતિ, યેન ત્રાણં પ્રાપ્યેત ભૂમણ્ડલસ્યલોકાનાં મધ્યે તાદૃશં કિમપિ નામ નાસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","તદા પિતરયોહનોરેતાદૃશીમ્ અક્ષેભતાં દૃષ્ટ્વા તાવવિદ્વાંસૌ નીચલોકાવિતિ બુદ્ધ્વા આશ્ચર્ય્યમ્ અમન્યન્ત તૌ ચ યીશોઃ સઙ્ગિનૌ જાતાવિતિ જ્ઞાતુમ્ અશક્નુવન્| ");
INSERT INTO sanguj_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","કિન્તુ તાભ્યાં સાર્દ્ધં તં સ્વસ્થમાનુષં તિષ્ઠન્તં દૃષ્ટ્વા તે કામપ્યપરામ્ આપત્તિં કર્ત્તં નાશક્નુન્| ");
INSERT INTO sanguj_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","તદા તે સભાતઃ સ્થાનાન્તરં ગન્તું તાન્ આજ્ઞાપ્ય સ્વયં પરસ્પરમ્ ઇતિ મન્ત્રણામકુર્વ્વન્ ");
INSERT INTO sanguj_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","તૌ માનવૌ પ્રતિ કિં કર્ત્તવ્યં? તાવેકં પ્રસિદ્ધમ્ આશ્ચર્ય્યં કર્મ્મ કૃતવન્તૌ તદ્ યિરૂશાલમ્નિવાસિનાં સર્વ્વેષાં લોકાનાં સમીપે પ્રાકાશત તચ્ચ વયમપહ્નોતું ન શક્નુમઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","કિન્તુ લોકાનાં મધ્યમ્ એતદ્ યથા ન વ્યાપ્નોતિ તદર્થં તૌ ભયં પ્રદર્શ્ય તેન નામ્ના કમપિ મનુષ્યં નોપદિશતમ્ ઇતિ દૃઢં નિષેધામઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","તતસ્તે પ્રેરિતાવાહૂય એતદાજ્ઞાપયન્ ઇતઃ પરં યીશો ર્નામ્ના કદાપિ કામપિ કથાં મા કથયતં કિમપિ નોપદિશઞ્ચ| ");
INSERT INTO sanguj_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","તતઃ પિતરયોહનૌ પ્રત્યવદતામ્ ઈશ્વરસ્યાજ્ઞાગ્રહણં વા યુષ્માકમ્ આજ્ઞાગ્રહણમ્ એતયો ર્મધ્યે ઈશ્વરસ્ય ગોચરે કિં વિહિતં? યૂયં તસ્ય વિવેચનાં કુરુત| ");
INSERT INTO sanguj_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","વયં યદ્ અપશ્યામ યદશૃણુમ ચ તન્ન પ્રચારયિષ્યામ એતત્ કદાપિ ભવિતું ન શક્નોતિ| ");
INSERT INTO sanguj_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","યદઘટત તદ્ દૃષ્ટા સર્વ્વે લોકા ઈશ્વરસ્ય ગુણાન્ અન્વવદન્ તસ્માત્ લોકભયાત્ તૌ દણ્ડયિતું કમપ્યુપાયં ન પ્રાપ્ય તે પુનરપિ તર્જયિત્વા તાવત્યજન્| ");
INSERT INTO sanguj_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","યસ્ય માનુષસ્યૈતત્ સ્વાસ્થ્યકરણમ્ આશ્ચર્ય્યં કર્મ્માક્રિયત તસ્ય વયશ્ચત્વારિંશદ્વત્સરા વ્યતીતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","તતઃ પરં તૌ વિસૃષ્ટૌ સન્તૌ સ્વસઙ્ગિનાં સન્નિધિં ગત્વા પ્રધાનયાજકૈઃ પ્રાચીનલોકૈશ્ચ પ્રોક્તાઃ સર્વ્વાઃ કથા જ્ઞાપિતવન્તૌ| ");
INSERT INTO sanguj_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","તચ્છ્રુત્વા સર્વ્વ એકચિત્તીભૂય ઈશ્વરમુદ્દિશ્ય પ્રોચ્ચૈરેતત્ પ્રાર્થયન્ત, હે પ્રભો ગગણપૃથિવીપયોધીનાં તેષુ ચ યદ્યદ્ આસ્તે તેષાં સ્રષ્ટેશ્વરસ્ત્વં| ");
INSERT INTO sanguj_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ત્વં નિજસેવકેન દાયૂદા વાક્યમિદમ્ ઉવચિથ, મનુષ્યા અન્યદેશીયાઃ કુર્વ્વન્તિ કલહં કુતઃ| લોકાઃ સર્વ્વે કિમર્થં વા ચિન્તાં કુર્વ્વન્તિ નિષ્ફલાં| ");
INSERT INTO sanguj_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","પરમેશસ્ય તેનૈવાભિષિક્તસ્ય જનસ્ય ચ| વિરુદ્ધમભિતિષ્ઠન્તિ પૃથિવ્યાઃ પતયઃ કુતઃ|| ");
INSERT INTO sanguj_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","ફલતસ્તવ હસ્તેન મન્ત્રણયા ચ પૂર્વ્વ યદ્યત્ સ્થિરીકૃતં તદ્ યથા સિદ્ધં ભવતિ તદર્થં ત્વં યમ્ અથિષિક્તવાન્ સ એવ પવિત્રો યીશુસ્તસ્ય પ્રાતિકૂલ્યેન હેરોદ્ પન્તીયપીલાતો ");
INSERT INTO sanguj_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ઽન્યદેશીયલોકા ઇસ્રાયેલ્લોકાશ્ચ સર્વ્વ એતે સભાયામ્ અતિષ્ઠન્| ");
INSERT INTO sanguj_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","હે પરમેશ્વર અધુના તેષાં તર્જનં ગર્જનઞ્ચ શૃણુ; ");
INSERT INTO sanguj_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","તથા સ્વાસ્થ્યકરણકર્મ્મણા તવ બાહુબલપ્રકાશપૂર્વ્વકં તવ સેવકાન્ નિર્ભયેન તવ વાક્યં પ્રચારયિતું તવ પવિત્રપુત્રસ્ય યીશો ર્નામ્ના આશ્ચર્ય્યાણ્યસમ્ભવાનિ ચ કર્મ્માણિ કર્ત્તુઞ્ચાજ્ઞાપય| ");
INSERT INTO sanguj_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ઇત્થં પ્રાર્થનયા યત્ર સ્થાને તે સભાયામ્ આસન્ તત્ સ્થાનં પ્રાકમ્પત; તતઃ સર્વ્વે પવિત્રેણાત્મના પરિપૂર્ણાઃ સન્ત ઈશ્વરસ્ય કથામ્ અક્ષોભેણ પ્રાચારયન્| ");
INSERT INTO sanguj_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","અપરઞ્ચ પ્રત્યયકારિલોકસમૂહા એકમનસ એકચિત્તીભૂય સ્થિતાઃ| તેષાં કેપિ નિજસમ્પત્તિં સ્વીયાં નાજાનન્ કિન્તુ તેષાં સર્વ્વાઃ સમ્પત્ત્યઃ સાધારણ્યેન સ્થિતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","અન્યચ્ચ પ્રેરિતા મહાશક્તિપ્રકાશપૂર્વ્વકં પ્રભો ર્યીશોરુત્થાને સાક્ષ્યમ્ અદદુઃ, તેષુ સર્વ્વેષુ મહાનુગ્રહોઽભવચ્ચ| ");
INSERT INTO sanguj_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","તેષાં મધ્યે કસ્યાપિ દ્રવ્યન્યૂનતા નાભવદ્ યતસ્તેષાં ગૃહભૂમ્યાદ્યા યાઃ સમ્પત્તય આસન્ તા વિક્રીય ");
INSERT INTO sanguj_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","તન્મૂલ્યમાનીય પ્રેરિતાનાં ચરણેષુ તૈઃ સ્થાપિતં; તતઃ પ્રત્યેકશઃ પ્રયોજનાનુસારેણ દત્તમભવત્| ");
INSERT INTO sanguj_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","વિશેષતઃ કુપ્રોપદ્વીપીયો યોસિનામકો લેવિવંશજાત એકો જનો ભૂમ્યધિકારી, યં પ્રેરિતા બર્ણબ્બા અર્થાત્ સાન્ત્વનાદાયક ઇત્યુક્ત્વા સમાહૂયન્, ");
INSERT INTO sanguj_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","સ જનો નિજભૂમિં વિક્રીય તન્મૂલ્યમાનીય પ્રેરિતાનાં ચરણેષુ સ્થાપિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","તદા અનાનિયનામક એકો જનો યસ્ય ભાર્ય્યાયા નામ સફીરા સ સ્વાધિકારં વિક્રીય ");
INSERT INTO sanguj_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","સ્વભાર્ય્યાં જ્ઞાપયિત્વા તન્મૂલ્યસ્યૈકાંશં સઙ્ગોપ્ય સ્થાપયિત્વા તદન્યાંશમાત્રમાનીય પ્રેરિતાનાં ચરણેષુ સમર્પિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","તસ્માત્ પિતરોકથયત્ હે અનાનિય ભૂમે ર્મૂલ્યં કિઞ્ચિત્ સઙ્ગોપ્ય સ્થાપયિતું પવિત્રસ્યાત્મનઃ સન્નિધૌ મૃષાવાક્યં કથયિતુઞ્ચ શૈતાન્ કુતસ્તવાન્તઃકરણે પ્રવૃત્તિમજનયત્? ");
INSERT INTO sanguj_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","સા ભૂમિ ર્યદા તવ હસ્તગતા તદા કિં તવ સ્વીયા નાસીત્? તર્હિ સ્વાન્તઃકરણે કુત એતાદૃશી કુકલ્પના ત્વયા કૃતા? ત્વં કેવલમનુષ્યસ્ય નિકટે મૃષાવાક્યં નાવાદીઃ કિન્ત્વીશ્વરસ્ય નિકટેઽપિ| ");
INSERT INTO sanguj_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","એતાં કથાં શ્રુત્વૈવ સોઽનાનિયો ભૂમૌ પતન્ પ્રાણાન્ અત્યજત્, તદ્વૃત્તાન્તં યાવન્તો લોકા અશૃણ્વન્ તેષાં સર્વ્વેષાં મહાભયમ્ અજાયત્| ");
INSERT INTO sanguj_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","તદા યુવલોકાસ્તં વસ્ત્રેણાચ્છાદ્ય બહિ ર્નીત્વા શ્મશાનેઽસ્થાપયન્| ");
INSERT INTO sanguj_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","તતઃ પ્રહરૈકાનન્તરં કિં વૃત્તં તન્નાવગત્ય તસ્ય ભાર્ય્યાપિ તત્ર સમુપસ્થિતા| ");
INSERT INTO sanguj_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","તતઃ પિતરસ્તામ્ અપૃચ્છત્, યુવાભ્યામ્ એતાવન્મુદ્રાભ્યો ભૂમિ ર્વિક્રીતા ન વા? એતત્વં વદ; તદા સા પ્રત્યવાદીત્ સત્યમ્ એતાવદ્ભ્યો મુદ્રાભ્ય એવ| ");
INSERT INTO sanguj_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","તતઃ પિતરોકથયત્ યુવાં કથં પરમેશ્વરસ્યાત્માનં પરીક્ષિતુમ્ એકમન્ત્રણાવભવતાં? પશ્ય યે તવ પતિં શ્મશાને સ્થાપિતવન્તસ્તે દ્વારસ્ય સમીપે સમુપતિષ્ઠન્તિ ત્વામપિ બહિર્નેષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","તતઃ સાપિ તસ્ય ચરણસન્નિધૌ પતિત્વા પ્રાણાન્ અત્યાક્ષીત્| પશ્ચાત્ તે યુવાનોઽભ્યન્તરમ્ આગત્ય તામપિ મૃતાં દૃષ્ટ્વા બહિ ર્નીત્વા તસ્યાઃ પત્યુઃ પાર્શ્વે શ્મશાને સ્થાપિતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","તસ્માત્ મણ્ડલ્યાઃ સર્વ્વે લોકા અન્યલોકાશ્ચ તાં વાર્ત્તાં શ્રુત્વા સાધ્વસં ગતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","તતઃ પરં પ્રેરિતાનાં હસ્તૈ ર્લોકાનાં મધ્યે બહ્વાશ્ચર્ય્યાણ્યદ્ભુતાનિ કર્મ્માણ્યક્રિયન્ત; તદા શિષ્યાઃ સર્વ્વ એકચિત્તીભૂય સુલેમાનો ઽલિન્દે સમ્ભૂયાસન્| ");
INSERT INTO sanguj_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","તેષાં સઙ્ઘાન્તર્ગો ભવિતું કોપિ પ્રગલ્ભતાં નાગમત્ કિન્તુ લોકાસ્તાન્ સમાદ્રિયન્ત| ");
INSERT INTO sanguj_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","સ્ત્રિયઃ પુરુષાશ્ચ બહવો લોકા વિશ્વાસ્ય પ્રભું શરણમાપન્નાઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","પિતરસ્ય ગમનાગમનાભ્યાં કેનાપિ પ્રકારેણ તસ્ય છાયા કસ્મિંશ્ચિજ્જને લગિષ્યતીત્યાશયા લોકા રોગિણઃ શિવિકયા ખટ્વયા ચાનીય પથિ પથિ સ્થાપિતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","ચતુર્દિક્સ્થનગરેભ્યો બહવો લોકાઃ સમ્ભૂય રોગિણોઽપવિત્રભુતગ્રસ્તાંશ્ચ યિરૂશાલમમ્ આનયન્ તતઃ સર્વ્વે સ્વસ્થા અક્રિયન્ત| ");
INSERT INTO sanguj_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","અનન્તરં મહાયાજકઃ સિદૂકિનાં મતગ્રાહિણસ્તેષાં સહચરાશ્ચ ");
INSERT INTO sanguj_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","મહાક્રોધાન્ત્વિતાઃ સન્તઃ પ્રેરિતાન્ ધૃત્વા નીચલોકાનાં કારાયાં બદ્ધ્વા સ્થાપિતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","કિન્તુ રાત્રૌ પરમેશ્વરસ્ય દૂતઃ કારાયા દ્વારં મોચયિત્વા તાન્ બહિરાનીયાકથયત્, ");
INSERT INTO sanguj_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","યૂયં ગત્વા મન્દિરે દણ્ડાયમાનાઃ સન્તો લોકાન્ પ્રતીમાં જીવનદાયિકાં સર્વ્વાં કથાં પ્રચારયત| ");
INSERT INTO sanguj_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ઇતિ શ્રુત્વા તે પ્રત્યૂષે મન્દિર ઉપસ્થાય ઉપદિષ્ટવન્તઃ| તદા સહચરગણેન સહિતો મહાયાજક આગત્ય મન્ત્રિગણમ્ ઇસ્રાયેલ્વંશસ્ય સર્વ્વાન્ રાજસભાસદઃ સભાસ્થાન્ કૃત્વા કારાયાસ્તાન્ આપયિતું પદાતિગણં પ્રેરિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","તતસ્તે ગત્વા કારાયાં તાન્ અપ્રાપ્ય પ્રત્યાગત્ય ઇતિ વાર્ત્તામ્ અવાદિષુઃ, ");
INSERT INTO sanguj_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","વયં તત્ર ગત્વા નિર્વ્વિઘ્નં કારાયા દ્વારં રુદ્ધં રક્ષકાંશ્ચ દ્વારસ્ય બહિર્દણ્ડાયમાનાન્ અદર્શામ એવ કિન્તુ દ્વારં મોચયિત્વા તન્મધ્યે કમપિ દ્રષ્ટું ન પ્રાપ્તાઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","એતાં કથાં શ્રુત્વા મહાયાજકો મન્દિરસ્ય સેનાપતિઃ પ્રધાનયાજકાશ્ચ, ઇત પરં કિમપરં ભવિષ્યતીતિ ચિન્તયિત્વા સન્દિગ્ધચિત્તા અભવન્| ");
INSERT INTO sanguj_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","એતસ્મિન્નેવ સમયે કશ્ચિત્ જન આગત્ય વાર્ત્તામેતામ્ અવદત્ પશ્યત યૂયં યાન્ માનવાન્ કારાયામ્ અસ્થાપયત તે મન્દિરે તિષ્ઠન્તો લોકાન્ ઉપદિશન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","તદા મન્દિરસ્ય સેનાપતિઃ પદાતયશ્ચ તત્ર ગત્વા ચેલ્લોકાઃ પાષાણાન્ નિક્ષિપ્યાસ્માન્ મારયન્તીતિ ભિયા વિનત્યાચારં તાન્ આનયન્| ");
INSERT INTO sanguj_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","તે મહાસભાયા મધ્યે તાન્ અસ્થાપયન્ તતઃ પરં મહાયાજકસ્તાન્ અપૃચ્છત્, ");
INSERT INTO sanguj_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","અનેન નામ્ના સમુપદેષ્ટું વયં કિં દૃઢં ન ન્યષેધામ? તથાપિ પશ્યત યૂયં સ્વેષાં તેનોપદેશેને યિરૂશાલમં પરિપૂર્ણં કૃત્વા તસ્ય જનસ્ય રક્તપાતજનિતાપરાધમ્ અસ્માન્ પ્રત્યાનેતું ચેષ્ટધ્વે| ");
INSERT INTO sanguj_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","તતઃ પિતરોન્યપ્રેરિતાશ્ચ પ્રત્યવદન્ માનુષસ્યાજ્ઞાગ્રહણાદ્ ઈશ્વરસ્યાજ્ઞાગ્રહણમ્ અસ્માકમુચિતમ્| ");
INSERT INTO sanguj_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","યં યીશું યૂયં ક્રુશે વેધિત્વાહત તમ્ અસ્માકં પૈતૃક ઈશ્વર ઉત્થાપ્ય ");
INSERT INTO sanguj_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ઇસ્રાયેલ્વંશાનાં મનઃપરિવર્ત્તનં પાપક્ષમાઞ્ચ કર્ત્તું રાજાનં પરિત્રાતારઞ્ચ કૃત્વા સ્વદક્ષિણપાર્શ્વે તસ્યાન્નતિમ્ અકરોત્| ");
INSERT INTO sanguj_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","એતસ્મિન્ વયમપિ સાક્ષિણ આસ્મહે, તત્ કેવલં નહિ, ઈશ્વર આજ્ઞાગ્રાહિભ્યો યં પવિત્રમ્ આત્મનં દત્તવાન્ સોપિ સાક્ષ્યસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","એતદ્વાક્યે શ્રુતે તેષાં હૃદયાનિ વિદ્ધાન્યભવન્ તતસ્તે તાન્ હન્તું મન્ત્રિતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","એતસ્મિન્નેવ સમયે તત્સભાસ્થાનાં સર્વ્વલોકાનાં મધ્યે સુખ્યાતો ગમિલીયેલ્નામક એકો જનો વ્યવસ્થાપકઃ ફિરૂશિલોક ઉત્થાય પ્રેરિતાન્ ક્ષણાર્થં સ્થાનાન્તરં ગન્તુમ્ આદિશ્ય કથિતવાન્, ");
INSERT INTO sanguj_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","હે ઇસ્રાયેલ્વંશીયાઃ સર્વ્વે યૂયમ્ એતાન્ માનુષાન્ પ્રતિ યત્ કર્ત્તુમ્ ઉદ્યતાસ્તસ્મિન્ સાવધાના ભવત| ");
INSERT INTO sanguj_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","ઇતઃ પૂર્વ્વં થૂદાનામૈકો જન ઉપસ્થાય સ્વં કમપિ મહાપુરુષમ્ અવદત્, તતઃ પ્રાયેણ ચતુઃશતલોકાસ્તસ્ય મતગ્રાહિણોભવન્ પશ્ચાત્ સ હતોભવત્ તસ્યાજ્ઞાગ્રાહિણો યાવન્તો લોકાસ્તે સર્વ્વે વિર્કીર્ણાઃ સન્તો ઽકૃતકાર્ય્યા અભવન્| ");
INSERT INTO sanguj_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","તસ્માજ્જનાત્ પરં નામલેખનસમયે ગાલીલીયયિહૂદાનામૈકો જન ઉપસ્થાય બહૂલ્લોકાન્ સ્વમતં ગ્રાહીતવાન્ તતઃ સોપિ વ્યનશ્યત્ તસ્યાજ્ઞાગ્રાહિણો યાવન્તો લોકા આસન્ તે સર્વ્વે વિકીર્ણા અભવન્| ");
INSERT INTO sanguj_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","અધુના વદામિ, યૂયમ્ એતાન્ મનુષ્યાન્ પ્રતિ કિમપિ ન કૃત્વા ક્ષાન્તા ભવત, યત એષ સઙ્કલ્પ એતત્ કર્મ્મ ચ યદિ મનુષ્યાદભવત્ તર્હિ વિફલં ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","યદીશ્વરાદભવત્ તર્હિ યૂયં તસ્યાન્યથા કર્ત્તું ન શક્ષ્યથ, વરમ્ ઈશ્વરરોધકા ભવિષ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","તદા તસ્ય મન્ત્રણાં સ્વીકૃત્ય તે પ્રેરિતાન્ આહૂય પ્રહૃત્ય યીશો ર્નામ્ના કામપિ કથાં કથયિતું નિષિધ્ય વ્યસર્જન્| ");
INSERT INTO sanguj_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","કિન્તુ તસ્ય નામાર્થં વયં લજ્જાભોગસ્ય યોગ્યત્વેન ગણિતા ઇત્યત્ર તે સાનન્દાઃ સન્તઃ સભાસ્થાનાં સાક્ષાદ્ અગચ્છન્| ");
INSERT INTO sanguj_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","તતઃ પરં પ્રતિદિનં મન્દિરે ગૃહે ગૃહે ચાવિશ્રામમ્ ઉપદિશ્ય યીશુખ્રીષ્ટસ્ય સુસંવાદં પ્રચારિતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","તસ્મિન્ સમયે શિષ્યાણાં બાહુલ્યાત્ પ્રાત્યહિકદાનસ્ય વિશ્રાણનૈ ર્ભિન્નદેશીયાનાં વિધવાસ્ત્રીગણ ઉપેક્ષિતે સતિ ઇબ્રીયલોકૈઃ સહાન્યદેશીયાનાં વિવાદ ઉપાતિષ્ઠત્| ");
INSERT INTO sanguj_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","તદા દ્વાદશપ્રેરિતાઃ સર્વ્વાન્ શિષ્યાન્ સંગૃહ્યાકથયન્ ઈશ્વરસ્ય કથાપ્રચારં પરિત્યજ્ય ભોજનગવેષણમ્ અસ્માકમ્ ઉચિતં નહિ| ");
INSERT INTO sanguj_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","અતો હે ભ્રાતૃગણ વયમ્ એતત્કર્મ્મણો ભારં યેભ્યો દાતું શક્નુમ એતાદૃશાન્ સુખ્યાત્યાપન્નાન્ પવિત્રેણાત્મના જ્ઞાનેન ચ પૂર્ણાન્ સપ્પ્રજનાન્ યૂયં સ્વેષાં મધ્યે મનોનીતાન્ કુરુત, ");
INSERT INTO sanguj_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","કિન્તુ વયં પ્રાર્થનાયાં કથાપ્રચારકર્મ્મણિ ચ નિત્યપ્રવૃત્તાઃ સ્થાસ્યામઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","એતસ્યાં કથાયાં સર્વ્વે લોકાઃ સન્તુષ્ટાઃ સન્તઃ સ્વેષાં મધ્યાત્ સ્તિફાનઃ ફિલિપઃ પ્રખરો નિકાનોર્ તીમન્ પર્મ્મિણા યિહૂદિમતગ્રાહી-આન્તિયખિયાનગરીયો નિકલા એતાન્ પરમભક્તાન્ પવિત્રેણાત્મના પરિપૂર્ણાન્ સપ્ત જનાન્ ");
INSERT INTO sanguj_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","પ્રેરિતાનાં સમક્ષમ્ આનયન્, તતસ્તે પ્રાર્થનાં કૃત્વા તેષાં શિરઃસુ હસ્તાન્ આર્પયન્| ");
INSERT INTO sanguj_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","અપરઞ્ચ ઈશ્વરસ્ય કથા દેશં વ્યાપ્નોત્ વિશેષતો યિરૂશાલમિ નગરે શિષ્યાણાં સંખ્યા પ્રભૂતરૂપેણાવર્દ્ધત યાજકાનાં મધ્યેપિ બહવઃ ખ્રીષ્ટમતગ્રાહિણોઽભવન્| ");
INSERT INTO sanguj_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","સ્તિફાનોे વિશ્વાસેન પરાક્રમેણ ચ પરિપૂર્ણઃ સન્ લોકાનાં મધ્યે બહુવિધમ્ અદ્ભુતમ્ આશ્ચર્ય્યં કર્મ્માકરોત્| ");
INSERT INTO sanguj_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","તેન લિબર્ત્તિનીયનામ્ના વિખ્યાતસઙ્ઘસ્ય કતિપયજનાઃ કુરીણીયસિકન્દરીય-કિલિકીયાશીયાદેશીયાઃ કિયન્તો જનાશ્ચોત્થાય સ્તિફાનેન સાર્દ્ધં વ્યવદન્ત| ");
INSERT INTO sanguj_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","કિન્તુ સ્તિફાનો જ્ઞાનેન પવિત્રેણાત્મના ચ ઈદૃશીં કથાં કથિતવાન્ યસ્યાસ્તે આપત્તિં કર્ત્તું નાશક્નુવન્| ");
INSERT INTO sanguj_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","પશ્ચાત્ તૈ ર્લોભિતાઃ કતિપયજનાઃ કથામેનામ્ અકથયન્, વયં તસ્ય મુખતો મૂસા ઈશ્વરસ્ય ચ નિન્દાવાક્યમ્ અશ્રૌષ્મ| ");
INSERT INTO sanguj_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","તે લોકાનાં લોકપ્રાચીનાનામ્ અધ્યાપકાનાઞ્ચ પ્રવૃત્તિં જનયિત્વા સ્તિફાનસ્ય સન્નિધિમ્ આગત્ય તં ધૃત્વા મહાસભામધ્યમ્ આનયન્| ");
INSERT INTO sanguj_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","તદનન્તરં કતિપયજનેષુ મિથ્યાસાક્ષિષુ સમાનીતેષુ તેઽકથયન્ એષ જન એતત્પુણ્યસ્થાનવ્યવસ્થયો ર્નિન્દાતઃ કદાપિ ન નિવર્ત્તતે| ");
INSERT INTO sanguj_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ફલતો નાસરતીયયીશુઃ સ્થાનમેતદ્ ઉચ્છિન્નં કરિષ્યતિ મૂસાસમર્પિતમ્ અસ્માકં વ્યવહરણમ્ અન્યરૂપં કરિષ્યતિ તસ્યૈતાદૃશીં કથાં વયમ્ અશૃણુમ| ");
INSERT INTO sanguj_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","તદા મહાસભાસ્થાઃ સર્વ્વે તં પ્રતિ સ્થિરાં દૃષ્ટિં કૃત્વા સ્વર્ગદૂતમુખસદૃશં તસ્ય મુખમ્ અપશ્યન્| ");
INSERT INTO sanguj_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","તતઃ પરં મહાયાજકઃ પૃષ્ટવાન્, એષા કથાં કિં સત્યા? ");
INSERT INTO sanguj_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","તતઃ સ પ્રત્યવદત્, હે પિતરો હે ભ્રાતરઃ સર્વ્વે લાકા મનાંસિ નિધદ્ધ્વં| અસ્માકં પૂર્વ્વપુરુષ ઇબ્રાહીમ્ હારણ્નગરે વાસકરણાત્ પૂર્વ્વં યદા અરામ્-નહરયિમદેશે આસીત્ તદા તેજોમય ઈશ્વરો દર્શનં દત્વા ");
INSERT INTO sanguj_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","તમવદત્ ત્વં સ્વદેશજ્ઞાતિમિત્રાણિ પરિત્યજ્ય યં દેશમહં દર્શયિષ્યામિ તં દેશં વ્રજ| ");
INSERT INTO sanguj_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","અતઃ સ કસ્દીયદેશં વિહાય હારણ્નગરે ન્યવસત્, તદનન્તરં તસ્ય પિતરિ મૃતે યત્ર દેશે યૂયં નિવસથ સ એનં દેશમાગચ્છત્| ");
INSERT INTO sanguj_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","કિન્ત્વીશ્વરસ્તસ્મૈ કમપ્યધિકારમ્ અર્થાદ્ એકપદપરિમિતાં ભૂમિમપિ નાદદાત્; તદા તસ્ય કોપિ સન્તાનો નાસીત્ તથાપિ સન્તાનૈઃ સાર્દ્ધમ્ એતસ્ય દેશસ્યાધિકારી ત્વં ભવિષ્યસીતિ તમ્પ્રત્યઙ્ગીકૃતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ઈશ્વર ઇત્થમ્ અપરમપિ કથિતવાન્ તવ સન્તાનાઃ પરદેશે નિવત્સ્યન્તિ તતસ્તદ્દેશીયલોકાશ્ચતુઃશતવત્સરાન્ યાવત્ તાન્ દાસત્વે સ્થાપયિત્વા તાન્ પ્રતિ કુવ્યવહારં કરિષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","અપરમ્ ઈશ્વર એનાં કથામપિ કથિતવાન્, યે લોકાસ્તાન્ દાસત્વે સ્થાપયિષ્યન્તિ તાલ્લોકાન્ અહં દણ્ડયિષ્યામિ, તતઃ પરં તે બહિર્ગતાઃ સન્તો મામ્ અત્ર સ્થાને સેવિષ્યન્તે| ");
INSERT INTO sanguj_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","પશ્ચાત્ સ તસ્મૈ ત્વક્છેદસ્ય નિયમં દત્તવાન્, અત ઇસ્હાકનામ્નિ ઇબ્રાહીમ એકપુત્રે જાતે, અષ્ટમદિને તસ્ય ત્વક્છેદમ્ અકરોત્| તસ્ય ઇસ્હાકઃ પુત્રો યાકૂબ્, તતસ્તસ્ય યાકૂબોઽસ્માકં દ્વાદશ પૂર્વ્વપુરુષા અજાયન્ત| ");
INSERT INTO sanguj_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","તે પૂર્વ્વપુરુષા ઈર્ષ્યયા પરિપૂર્ણા મિસરદેશં પ્રેષયિતું યૂષફં વ્યક્રીણન્| ");
INSERT INTO sanguj_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","કિન્ત્વીશ્વરસ્તસ્ય સહાયો ભૂત્વા સર્વ્વસ્યા દુર્ગતે રક્ષિત્વા તસ્મૈ બુદ્ધિં દત્ત્વા મિસરદેશસ્ય રાજ્ઞઃ ફિરૌણઃ પ્રિયપાત્રં કૃતવાન્ તતો રાજા મિસરદેશસ્ય સ્વીયસર્વ્વપરિવારસ્ય ચ શાસનપદં તસ્મૈ દત્તવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","તસ્મિન્ સમયે મિસર-કિનાનદેશયો ર્દુર્ભિક્ષહેતોરતિક્લિષ્ટત્વાત્ નઃ પૂર્વ્વપુરુષા ભક્ષ્યદ્રવ્યં નાલભન્ત| ");
INSERT INTO sanguj_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","કિન્તુ મિસરદેશે શસ્યાનિ સન્તિ, યાકૂબ્ ઇમાં વાર્ત્તાં શ્રુત્વા પ્રથમમ્ અસ્માકં પૂર્વ્વપુરુષાન્ મિસરં પ્રેષિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","તતો દ્વિતીયવારગમને યૂષફ્ સ્વભ્રાતૃભિઃ પરિચિતોઽભવત્; યૂષફો ભ્રાતરઃ ફિરૌણ્ રાજેન પરિચિતા અભવન્| ");
INSERT INTO sanguj_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","અનન્તરં યૂષફ્ ભ્રાતૃગણં પ્રેષ્ય નિજપિતરં યાકૂબં નિજાન્ પઞ્ચાધિકસપ્તતિસંખ્યકાન્ જ્ઞાતિજનાંશ્ચ સમાહૂતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","તસ્માદ્ યાકૂબ્ મિસરદેશં ગત્વા સ્વયમ્ અસ્માકં પૂર્વ્વપુરુષાશ્ચ તસ્મિન્ સ્થાનેઽમ્રિયન્ત| ");
INSERT INTO sanguj_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","તતસ્તે શિખિમં નીતા યત્ શ્મશાનમ્ ઇબ્રાહીમ્ મુદ્રાદત્વા શિખિમઃ પિતુ ર્હમોરઃ પુત્રેભ્યઃ ક્રીતવાન્ તત્શ્મશાને સ્થાપયાઞ્ચક્રિરે| ");
INSERT INTO sanguj_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","તતઃ પરમ્ ઈશ્વર ઇબ્રાહીમઃ સન્નિધૌ શપથં કૃત્વા યાં પ્રતિજ્ઞાં કૃતવાન્ તસ્યાઃ પ્રતિજ્ઞાયાઃ ફલનસમયે નિકટે સતિ ઇસ્રાયેલ્લોકા સિમરદેશે વર્દ્ધમાના બહુસંખ્યા અભવન્| ");
INSERT INTO sanguj_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","શેષે યૂષફં યો ન પરિચિનોતિ તાદૃશ એકો નરપતિરુપસ્થાય ");
INSERT INTO sanguj_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","અસ્માકં જ્ઞાતિભિઃ સાર્દ્ધં ધૂર્ત્તતાં વિધાય પૂર્વ્વપુરુષાન્ પ્રતિ કુવ્યવહરણપૂર્વ્વકં તેષાં વંશનાશનાય તેષાં નવજાતાન્ શિશૂન્ બહિ ર્નિરક્ષેપયત્| ");
INSERT INTO sanguj_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","એતસ્મિન્ સમયે મૂસા જજ્ઞે, સ તુ પરમસુન્દરોઽભવત્ તથા પિતૃગૃહે માસત્રયપર્ય્યન્તં પાલિતોઽભવત્| ");
INSERT INTO sanguj_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","કિન્તુ તસ્મિન્ બહિર્નિક્ષિપ્તે સતિ ફિરૌણરાજસ્ય કન્યા તમ્ ઉત્તોલ્ય નીત્વા દત્તકપુત્રં કૃત્વા પાલિતવતી| ");
INSERT INTO sanguj_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","તસ્માત્ સ મૂસા મિસરદેશીયાયાઃ સર્વ્વવિદ્યાયાઃ પારદૃષ્વા સન્ વાક્યે ક્રિયાયાઞ્ચ શક્તિમાન્ અભવત્| ");
INSERT INTO sanguj_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","સ સમ્પૂર્ણચત્વારિંશદ્વત્સરવયસ્કો ભૂત્વા ઇસ્રાયેલીયવંશનિજભ્રાતૃન્ સાક્ષાત્ કર્તું મતિં ચક્રે| ");
INSERT INTO sanguj_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","તેષાં જનમેકં હિંસિતં દૃષ્ટ્વા તસ્ય સપક્ષઃ સન્ હિંસિતજનમ્ ઉપકૃત્ય મિસરીયજનં જઘાન| ");
INSERT INTO sanguj_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","તસ્ય હસ્તેનેશ્વરસ્તાન્ ઉદ્ધરિષ્યતિ તસ્ય ભ્રાતૃગણ ઇતિ જ્ઞાસ્યતિ સ ઇત્યનુમાનં ચકાર, કિન્તુ તે ન બુબુધિરે| ");
INSERT INTO sanguj_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","તત્પરે ઽહનિ તેષામ્ ઉભયો ર્જનયો ર્વાક્કલહ ઉપસ્થિતે સતિ મૂસાઃ સમીપં ગત્વા તયો ર્મેલનં કર્ત્તું મતિં કૃત્વા કથયામાસ, હે મહાશયૌ યુવાં ભ્રાતરૌ પરસ્પરમ્ અન્યાયં કુતઃ કુરુથઃ? ");
INSERT INTO sanguj_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","તતઃ સમીપવાસિનં પ્રતિ યો જનોઽન્યાયં ચકાર સ તં દૂરીકૃત્ય કથયામાસ, અસ્માકમુપરિ શાસ્તૃત્વવિચારયિતૃત્વપદયોઃ કસ્ત્વાં નિયુક્તવાન્? ");
INSERT INTO sanguj_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","હ્યો યથા મિસરીયં હતવાન્ તથા કિં મામપિ હનિષ્યસિ? ");
INSERT INTO sanguj_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","તદા મૂસા એતાદૃશીં કથાં શ્રુત્વા પલાયનં ચક્રે, તતો મિદિયનદેશં ગત્વા પ્રવાસી સન્ તસ્થૌ, તતસ્તત્ર દ્વૌ પુત્રૌ જજ્ઞાતે| ");
INSERT INTO sanguj_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","અનન્તરં ચત્વારિંશદ્વત્સરેષુ ગતેષુ સીનયપર્વ્વતસ્ય પ્રાન્તરે પ્રજ્વલિતસ્તમ્બસ્ય વહ્નિશિખાયાં પરમેશ્વરદૂતસ્તસ્મૈ દર્શનં દદૌ| ");
INSERT INTO sanguj_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","મૂસાસ્તસ્મિન્ દર્શને વિસ્મયં મત્વા વિશેષં જ્ઞાતું નિકટં ગચ્છતિ, ");
INSERT INTO sanguj_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","એતસ્મિન્ સમયે, અહં તવ પૂર્વ્વપુરુષાણામ્ ઈશ્વરોઽર્થાદ્ ઇબ્રાહીમ ઈશ્વર ઇસ્હાક ઈશ્વરો યાકૂબ ઈશ્વરશ્ચ, મૂસામુદ્દિશ્ય પરમેશ્વરસ્યૈતાદૃશી વિહાયસીયા વાણી બભૂવ, તતઃ સ કમ્પાન્વિતઃ સન્ પુન ર્નિરીક્ષિતું પ્રગલ્ભો ન બભૂવ| ");
INSERT INTO sanguj_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","પરમેશ્વરસ્તં જગાદ, તવ પાદયોઃ પાદુકે મોચય યત્ર તિષ્ઠસિ સા પવિત્રભૂમિઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","અહં મિસરદેશસ્થાનાં નિજલોકાનાં દુર્દ્દશાં નિતાન્તમ્ અપશ્યં, તેષાં કાતર્ય્યોક્તિઞ્ચ શ્રુતવાન્ તસ્માત્ તાન્ ઉદ્ધર્ત્તુમ્ અવરુહ્યાગમમ્; ઇદાનીમ્ આગચ્છ મિસરદેશં ત્વાં પ્રેષયામિ| ");
INSERT INTO sanguj_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","કસ્ત્વાં શાસ્તૃત્વવિચારયિતૃત્વપદયો ર્નિયુક્તવાન્, ઇતિ વાક્યમુક્ત્વા તૈ ર્યો મૂસા અવજ્ઞાતસ્તમેવ ઈશ્વરઃ સ્તમ્બમધ્યે દર્શનદાત્રા તેન દૂતેન શાસ્તારં મુક્તિદાતારઞ્ચ કૃત્વા પ્રેષયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","સ ચ મિસરદેશે સૂફ્નામ્નિ સમુદ્રે ચ પશ્ચાત્ ચત્વારિંશદ્વત્સરાન્ યાવત્ મહાપ્રાન્તરે નાનાપ્રકારાણ્યદ્ભુતાનિ કર્મ્માણિ લક્ષણાનિ ચ દર્શયિત્વા તાન્ બહિઃ કૃત્વા સમાનિનાય| ");
INSERT INTO sanguj_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","પ્રભુઃ પરમેશ્વરો યુષ્માકં ભ્રાતૃગણસ્ય મધ્યે માદૃશમ્ એકં ભવિષ્યદ્વક્તારમ્ ઉત્પાદયિષ્યતિ તસ્ય કથાયાં યૂયં મનો નિધાસ્યથ, યો જન ઇસ્રાયેલઃ સન્તાનેભ્ય એનાં કથાં કથયામાસ સ એષ મૂસાઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","મહાપ્રાન્તરસ્થમણ્ડલીમધ્યેઽપિ સ એવ સીનયપર્વ્વતોપરિ તેન સાર્દ્ધં સંલાપિનો દૂતસ્ય ચાસ્મત્પિતૃગણસ્ય મધ્યસ્થઃ સન્ અસ્મભ્યં દાતવ્યનિ જીવનદાયકાનિ વાક્યાનિ લેભે| ");
INSERT INTO sanguj_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","અસ્માકં પૂર્વ્વપુરુષાસ્તમ્ અમાન્યં કત્વા સ્વેભ્યો દૂરીકૃત્ય મિસરદેશં પરાવૃત્ય ગન્તું મનોભિરભિલષ્ય હારોણં જગદુઃ, ");
INSERT INTO sanguj_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","અસ્માકમ્ અગ્રેઽગ્રે ગન્તુुમ્ અસ્મદર્થં દેવગણં નિર્મ્માહિ યતો યો મૂસા અસ્માન્ મિસરદેશાદ્ બહિઃ કૃત્વાનીતવાન્ તસ્ય કિં જાતં તદસ્માભિ ર્ન જ્ઞાયતે| ");
INSERT INTO sanguj_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","તસ્મિન્ સમયે તે ગોવત્સાકૃતિં પ્રતિમાં નિર્મ્માય તામુદ્દિશ્ય નૈવેદ્યમુત્મૃજ્ય સ્વહસ્તકૃતવસ્તુના આનન્દિતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","તસ્માદ્ ઈશ્વરસ્તેષાં પ્રતિ વિમુખઃ સન્ આકાશસ્થં જ્યોતિર્ગણં પૂજયિતું તેભ્યોઽનુમતિં દદૌ, યાદૃશં ભવિષ્યદ્વાદિનાં ગ્રન્થેષુ લિખિતમાસ્તે, યથા, ઇસ્રાયેલીયવંશા રે ચત્વારિંશત્સમાન્ પુરા| મહતિ પ્રાન્તરે સંસ્થા યૂયન્તુ યાનિ ચ| બલિહોમાદિકર્મ્માણિ કૃતવન્તસ્તુ તાનિ કિં| માં સમુદ્દિશ્ય યુષ્માભિઃ પ્રકૃતાનીતિ નૈવ ચ| ");
INSERT INTO sanguj_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","કિન્તુ વો મોલકાખ્યસ્ય દેવસ્ય દૂષ્યમેવ ચ| યુષ્માકં રિમ્ફનાખ્યાયા દેવતાયાશ્ચ તારકા| એતયોરુભયો ર્મૂર્તી યુષ્માભિઃ પરિપૂજિતે| અતો યુષ્માંસ્તુ બાબેલઃ પારં નેષ્યામિ નિશ્ચિતં| ");
INSERT INTO sanguj_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","અપરઞ્ચ યન્નિદર્શનમ્ અપશ્યસ્તદનુસારેણ દૂષ્યં નિર્મ્માહિ યસ્મિન્ ઈશ્વરો મૂસામ્ એતદ્વાક્યં બભાષે તત્ તસ્ય નિરૂપિતં સાક્ષ્યસ્વરૂપં દૂષ્યમ્ અસ્માકં પૂર્વ્વપુરુષૈઃ સહ પ્રાન્તરે તસ્થૌ| ");
INSERT INTO sanguj_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","પશ્ચાત્ યિહોશૂયેન સહિતૈસ્તેષાં વંશજાતૈરસ્મત્પૂર્વ્વપુરુષૈઃ સ્વેષાં સમ્મુખાદ્ ઈશ્વરેણ દૂરીકૃતાનામ્ અન્યદેશીયાનાં દેશાધિકૃતિકાલે સમાનીતં તદ્ દૂષ્યં દાયૂદોધિકારં યાવત્ તત્ર સ્થાન આસીત્| ");
INSERT INTO sanguj_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","સ દાયૂદ્ પરમેશ્વરસ્યાનુગ્રહં પ્રાપ્ય યાકૂબ્ ઈશ્વરાર્થમ્ એકં દૂષ્યં નિર્મ્માતું વવાઞ્છ; ");
INSERT INTO sanguj_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","કિન્તુ સુલેમાન્ તદર્થં મન્દિરમ્ એકં નિર્મ્મિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","તથાપિ યઃ સર્વ્વોપરિસ્થઃ સ કસ્મિંશ્ચિદ્ હસ્તકૃતે મન્દિરે નિવસતીતિ નહિ, ભવિષ્યદ્વાદી કથામેતાં કથયતિ, યથા, ");
INSERT INTO sanguj_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","પરેશો વદતિ સ્વર્ગો રાજસિંહાસનં મમ| મદીયં પાદપીઠઞ્ચ પૃથિવી ભવતિ ધ્રુવં| તર્હિ યૂયં કૃતે મે કિં પ્રનિર્મ્માસ્યથ મન્દિરં| વિશ્રામાય મદીયં વા સ્થાનં કિં વિદ્યતે ત્વિહ| ");
INSERT INTO sanguj_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","સર્વ્વાણ્યેતાનિ વસ્તૂનિ કિં મે હસ્તકૃતાનિ ન|| ");
INSERT INTO sanguj_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","હે અનાજ્ઞાગ્રાહકા અન્તઃકરણે શ્રવણે ચાપવિત્રલોકાઃ યૂયમ્ અનવરતં પવિત્રસ્યાત્મનઃ પ્રાતિકૂલ્યમ્ આચરથ, યુષ્માકં પૂર્વ્વપુરુષા યાદૃશા યૂયમપિ તાદૃશાઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","યુષ્માકં પૂર્વ્વપુરુષાઃ કં ભવિષ્યદ્વાદિનં નાતાડયન્? યે તસ્ય ધાર્મ્મિકસ્ય જનસ્યાગમનકથાં કથિતવન્તસ્તાન્ અઘ્નન્ યૂયમ્ અધૂના વિશ્વાસઘાતિનો ભૂત્વા તં ધાર્મ્મિકં જનમ્ અહત| ");
INSERT INTO sanguj_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","યૂયં સ્વર્ગીયદૂતગણેન વ્યવસ્થાં પ્રાપ્યાપિ તાં નાચરથ| ");
INSERT INTO sanguj_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ઇમાં કથાં શ્રુત્વા તે મનઃસુ બિદ્ધાઃ સન્તસ્તં પ્રતિ દન્તઘર્ષણમ્ અકુર્વ્વન્| ");
INSERT INTO sanguj_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","કિન્તુ સ્તિફાનઃ પવિત્રેણાત્મના પૂર્ણો ભૂત્વા ગગણં પ્રતિ સ્થિરદૃષ્ટિં કૃત્વા ઈશ્વરસ્ય દક્ષિણે દણ્ડાયમાનં યીશુઞ્ચ વિલોક્ય કથિતવાન્; ");
INSERT INTO sanguj_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","પશ્ય,મેઘદ્વારં મુક્તમ્ ઈશ્વરસ્ય દક્ષિણે સ્થિતં માનવસુતઞ્ચ પશ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","તદા તે પ્રોચ્ચૈઃ શબ્દં કૃત્વા કર્ણેષ્વઙ્ગુલી ર્નિધાય એકચિત્તીભૂય તમ્ આક્રમન્| ");
INSERT INTO sanguj_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","પશ્ચાત્ તં નગરાદ્ બહિઃ કૃત્વા પ્રસ્તરૈરાઘ્નન્ સાક્ષિણો લાકાઃ શૌલનામ્નો યૂનશ્ચરણસન્નિધૌ નિજવસ્ત્રાણિ સ્થાપિતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","અનન્તરં હે પ્રભો યીશે મદીયમાત્માનં ગૃહાણ સ્તિફાનસ્યેતિ પ્રાર્થનવાક્યવદનસમયે તે તં પ્રસ્તરૈરાઘ્નન્| ");
INSERT INTO sanguj_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","તસ્માત્ સ જાનુની પાતયિત્વા પ્રોચ્ચૈઃ શબ્દં કૃત્વા, હે પ્રભે પાપમેતદ્ એતેષુ મા સ્થાપય, ઇત્યુક્ત્વા મહાનિદ્રાં પ્રાપ્નોત્| ");
INSERT INTO sanguj_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","તસ્ય હત્યાકરણં શૌલોપિ સમમન્યત| તસ્મિન્ સમયે યિરૂશાલમ્નગરસ્થાં મણ્ડલીં પ્રતિ મહાતાડનાયાં જાતાયાં પ્રેરિતલોકાન્ હિત્વા સર્વ્વેઽપરે યિહૂદાશોમિરોણદેશયો ર્નાનાસ્થાને વિકીર્ણાઃ સન્તો ગતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","અન્યચ્ચ ભક્તલોકાસ્તં સ્તિફાનં શ્મશાને સ્થાપયિત્વા બહુ વ્યલપન્| ");
INSERT INTO sanguj_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","કિન્તુ શૌલો ગૃહે ગૃહે ભ્રમિત્વા સ્ત્રિયઃ પુરુષાંશ્ચ ધૃત્વા કારાયાં બદ્ધ્વા મણ્ડલ્યા મહોત્પાતં કૃતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","અન્યચ્ચ યે વિકીર્ણા અભવન્ તે સર્વ્વત્ર ભ્રમિત્વા સુસંવાદં પ્રાચારયન્| ");
INSERT INTO sanguj_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","તદા ફિલિપઃ શોમિરોણ્નગરં ગત્વા ખ્રીષ્ટાખ્યાનં પ્રાચારયત્; ");
INSERT INTO sanguj_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","તતોઽશુચિ-ભૃતગ્રસ્તલોકેભ્યો ભૂતાશ્ચીત્કૃત્યાગચ્છન્ તથા બહવઃ પક્ષાઘાતિનઃ ખઞ્જા લોકાશ્ચ સ્વસ્થા અભવન્| ");
INSERT INTO sanguj_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","તસ્માત્ લાકા ઈદૃશં તસ્યાશ્ચર્ય્યં કર્મ્મ વિલોક્ય નિશમ્ય ચ સર્વ્વ એકચિત્તીભૂય તેનોક્તાખ્યાને મનાંસિ ન્યદધુઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","તસ્મિન્નગરે મહાનન્દશ્ચાભવત્| ");
INSERT INTO sanguj_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","તતઃ પૂર્વ્વં તસ્મિન્નગરે શિમોન્નામા કશ્ચિજ્જનો બહ્વી ર્માયાક્રિયાઃ કૃત્વા સ્વં કઞ્ચન મહાપુરુષં પ્રોચ્ય શોમિરોણીયાનાં મોહં જનયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","તસ્માત્ સ માનુષ ઈશ્વરસ્ય મહાશક્તિસ્વરૂપ ઇત્યુક્ત્વા બાલવૃદ્ધવનિતાઃ સર્વ્વે લાકાસ્તસ્મિન્ મનાંસિ ન્યદધુઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","સ બહુકાલાન્ માયાવિક્રિયયા સર્વ્વાન્ અતીવ મોહયાઞ્ચકાર, તસ્માત્ તે તં મેનિરે| ");
INSERT INTO sanguj_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","કિન્ત્વીશ્વરસ્ય રાજ્યસ્ય યીશુખ્રીષ્ટસ્ય નામ્નશ્ચાખ્યાનપ્રચારિણઃ ફિલિપસ્ય કથાયાં વિશ્વસ્ય તેષાં સ્ત્રીપુરુષોભયલોકા મજ્જિતા અભવન્| ");
INSERT INTO sanguj_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","શેષે સ શિમોનપિ સ્વયં પ્રત્યૈત્ તતો મજ્જિતઃ સન્ ફિલિપેન કૃતામ્ આશ્ચર્ય્યક્રિયાં લક્ષણઞ્ચ વિલોક્યાસમ્ભવં મન્યમાનસ્તેન સહ સ્થિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","ઇત્થં શોમિરોણ્દેશીયલોકા ઈશ્વરસ્ય કથામ્ અગૃહ્લન્ ઇતિ વાર્ત્તાં યિરૂશાલમ્નગરસ્થપ્રેરિતાઃ પ્રાપ્ય પિતરં યોહનઞ્ચ તેષાં નિકટે પ્રેષિતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","તતસ્તૌ તત્ સ્થાનમ્ ઉપસ્થાય લોકા યથા પવિત્રમ્ આત્માનં પ્રાપ્નુવન્તિ તદર્થં પ્રાર્થયેતાં| ");
INSERT INTO sanguj_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","યતસ્તે પુરા કેવલપ્રભુયીશો ર્નામ્ના મજ્જિતમાત્રા અભવન્, ન તુ તેષાં મધ્યે કમપિ પ્રતિ પવિત્રસ્યાત્મન આવિર્ભાવો જાતઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","કિન્તુ પ્રેરિતાભ્યાં તેષાં ગાત્રેષુ કરેષ્વર્પિતેષુ સત્સુ તે પવિત્રમ્ આત્માનમ્ પ્રાપ્નુવન્| ");
INSERT INTO sanguj_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","ઇત્થં લોકાનાં ગાત્રેષુ પ્રેરિતયોઃ કરાર્પણેન તાન્ પવિત્રમ્ આત્માનં પ્રાપ્તાન્ દૃષ્ટ્વા સ શિમોન્ તયોઃ સમીપે મુદ્રા આનીય કથિતવાન્; ");
INSERT INTO sanguj_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","અહં યસ્ય ગાત્રે હસ્તમ્ અર્પયિષ્યામિ તસ્યાપિ યથેત્થં પવિત્રાત્મપ્રાપ્તિ ર્ભવતિ તાદૃશીં શક્તિં મહ્યં દત્તં| ");
INSERT INTO sanguj_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","કિન્તુ પિતરસ્તં પ્રત્યવદત્ તવ મુદ્રાસ્ત્વયા વિનશ્યન્તુ યત ઈશ્વરસ્ય દાનં મુદ્રાભિઃ ક્રીયતે ત્વમિત્થં બુદ્ધવાન્; ");
INSERT INTO sanguj_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ઈશ્વરાય તાવન્તઃકરણં સરલં નહિ, તસ્માદ્ અત્ર તવાંશોઽધિકારશ્ચ કોપિ નાસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","અત એતત્પાપહેતોઃ ખેદાન્વિતઃ સન્ કેનાપિ પ્રકારેણ તવ મનસ એતસ્યાઃ કુકલ્પનાયાઃ ક્ષમા ભવતિ, એતદર્થમ્ ઈશ્વરે પ્રાર્થનાં કુરુ; ");
INSERT INTO sanguj_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","યતસ્ત્વં તિક્તપિત્તે પાપસ્ય બન્ધને ચ યદસિ તન્મયા બુદ્ધમ્| ");
INSERT INTO sanguj_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","તદા શિમોન્ અકથયત્ તર્હિ યુવાભ્યામુદિતા કથા મયિ યથા ન ફલતિ તદર્થં યુવાં મન્નિમિત્તં પ્રભૌ પ્રાર્થનાં કુરુતં| ");
INSERT INTO sanguj_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","અનેન પ્રકારેણ તૌ સાક્ષ્યં દત્ત્વા પ્રભોઃ કથાં પ્રચારયન્તૌ શોમિરોણીયાનામ્ અનેકગ્રામેષુ સુસંવાદઞ્ચ પ્રચારયન્તૌ યિરૂશાલમ્નગરં પરાવૃત્ય ગતૌ| ");
INSERT INTO sanguj_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","તતઃ પરમ્ ઈશ્વરસ્ય દૂતઃ ફિલિપમ્ ઇત્યાદિશત્, ત્વમુત્થાય દક્ષિણસ્યાં દિશિ યો માર્ગો પ્રાન્તરસ્ય મધ્યેન યિરૂશાલમો ઽસાનગરં યાતિ તં માર્ગં ગચ્છ| ");
INSERT INTO sanguj_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","તતઃ સ ઉત્થાય ગતવાન્; તદા કન્દાકીનામ્નઃ કૂશ્લોકાનાં રાજ્ઞ્યાઃ સર્વ્વસમ્પત્તેરધીશઃ કૂશદેશીય એકઃ ષણ્ડો ભજનાર્થં યિરૂશાલમ્નગરમ્ આગત્ય ");
INSERT INTO sanguj_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","પુનરપિ રથમારુહ્ય યિશયિયનામ્નો ભવિષ્યદ્વાદિનો ગ્રન્થં પઠન્ પ્રત્યાગચ્છતિ| ");
INSERT INTO sanguj_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","એતસ્મિન્ સમયે આત્મા ફિલિપમ્ અવદત્, ત્વમ્ રથસ્ય સમીપં ગત્વા તેન સાર્દ્ધં મિલ| ");
INSERT INTO sanguj_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","તસ્માત્ સ ધાવન્ તસ્ય સન્નિધાવુપસ્થાય તેન પઠ્યમાનં યિશયિયથવિષ્યદ્વાદિનો વાક્યં શ્રુત્વા પૃષ્ટવાન્ યત્ પઠસિ તત્ કિં બુધ્યસે? ");
INSERT INTO sanguj_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","તતઃ સ કથિતવાન્ કેનચિન્ન બોધિતોહં કથં બુધ્યેય? તતઃ સ ફિલિપં રથમારોઢું સ્વેન સાર્દ્ધમ્ ઉપવેષ્ટુઞ્ચ ન્યવેદયત્| ");
INSERT INTO sanguj_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","સ શાસ્ત્રસ્યેતદ્વાક્યં પઠિતવાન્ યથા, સમાનીયત ઘાતાય સ યથા મેષશાવકઃ| લોમચ્છેદકસાક્ષાચ્ચ મેષશ્ચ નીરવો યથા| આબધ્ય વદનં સ્વીયં તથા સ સમતિષ્ઠત| ");
INSERT INTO sanguj_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","અન્યાયેન વિચારેણ સ ઉચ્છિન્નો ઽભવત્ તદા| તત્કાલીનમનુષ્યાન્ કો જનો વર્ણયિતું ક્ષમઃ| યતો જીવન્નૃણાં દેશાત્ સ ઉચ્છિન્નો ઽભવત્ ધ્રુવં| ");
INSERT INTO sanguj_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","અનન્તરં સ ફિલિપમ્ અવદત્ નિવેદયામિ, ભવિષ્યદ્વાદી યામિમાં કથાં કથયામાસ સ કિં સ્વસ્મિન્ વા કસ્મિંશ્ચિદ્ અન્યસ્મિન્? ");
INSERT INTO sanguj_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","તતઃ ફિલિપસ્તત્પ્રકરણમ્ આરભ્ય યીશોરુપાખ્યાનં તસ્યાગ્રે પ્રાસ્તૌત્| ");
INSERT INTO sanguj_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ઇત્થં માર્ગેણ ગચ્છન્તૌ જલાશયસ્ય સમીપ ઉપસ્થિતૌ; તદા ક્લીબોઽવાદીત્ પશ્યાત્ર સ્થાને જલમાસ્તે મમ મજ્જને કા બાધા? ");
INSERT INTO sanguj_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","તતઃ ફિલિપ ઉત્તરં વ્યાહરત્ સ્વાન્તઃકરણેન સાકં યદિ પ્રત્યેષિ તર્હિ બાધા નાસ્તિ| તતઃ સ કથિતવાન્ યીશુખ્રીષ્ટ ઈશ્વરસ્ય પુત્ર ઇત્યહં પ્રત્યેમિ| ");
INSERT INTO sanguj_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","તદા રથં સ્થગિતં કર્ત્તુમ્ આદિષ્ટે ફિલિપક્લીબૌ દ્વૌ જલમ્ અવારુહતાં; તદા ફિલિપસ્તમ્ મજ્જયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","તત્પશ્ચાત્ જલમધ્યાદ્ ઉત્થિતયોઃ સતોઃ પરમેશ્વરસ્યાત્મા ફિલિપં હૃત્વા નીતવાન્, તસ્માત્ ક્લીબઃ પુનસ્તં ન દૃષ્ટવાન્ તથાપિ હૃષ્ટચિત્તઃ સન્ સ્વમાર્ગેણ ગતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ફિલિપશ્ચાસ્દોદ્નગરમ્ ઉપસ્થાય તસ્માત્ કૈસરિયાનગર ઉપસ્થિતિકાલપર્ય્યનતં સર્વ્વસ્મિન્નગરે સુસંવાદં પ્રચારયન્ ગતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","તત્કાલપર્ય્યનતં શૌલઃ પ્રભોઃ શિષ્યાણાં પ્રાતિકૂલ્યેન તાડનાબધયોઃ કથાં નિઃસારયન્ મહાયાજકસ્ય સન્નિધિં ગત્વા ");
INSERT INTO sanguj_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","સ્ત્રિયં પુરુષઞ્ચ તન્મતગ્રાહિણં યં કઞ્ચિત્ પશ્યતિ તાન્ ધૃત્વા બદ્ધ્વા યિરૂશાલમમ્ આનયતીત્યાશયેન દમ્મેષક્નગરીયં ધર્મ્મસમાજાન્ પ્રતિ પત્રં યાચિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","ગચ્છન્ તુ દમ્મેષક્નગરનિકટ ઉપસ્થિતવાન્; તતોઽકસ્માદ્ આકાશાત્ તસ્ય ચતુર્દિક્ષુ તેજસઃ પ્રકાશનાત્ સ ભૂમાવપતત્| ");
INSERT INTO sanguj_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","પશ્ચાત્ હે શૌલ હે શૌલ કુતો માં તાડયસિ? સ્વં પ્રતિ પ્રોક્તમ્ એતં શબ્દં શ્રુત્વા ");
INSERT INTO sanguj_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","સ પૃષ્ટવાન્, હે પ્રભો ભવાન્ કઃ? તદા પ્રભુરકથયત્ યં યીશું ત્વં તાડયસિ સ એવાહં; કણ્ટકસ્ય મુખે પદાઘાતકરણં તવ કષ્ટમ્| ");
INSERT INTO sanguj_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","તદા કમ્પમાનો વિસ્મયાપન્નશ્ચ સોવદત્ હે પ્રભો મયા કિં કર્ત્તવ્યં? ભવત ઇચ્છા કા? તતઃ પ્રભુરાજ્ઞાપયદ્ ઉત્થાય નગરં ગચ્છ તત્ર ત્વયા યત્ કર્ત્તવ્યં તદ્ વદિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","તસ્ય સઙ્ગિનો લોકા અપિ તં શબ્દં શ્રુતવન્તઃ કિન્તુ કમપિ ન દૃષ્ટ્વા સ્તબ્ધાઃ સન્તઃ સ્થિતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","અનન્તરં શૌલો ભૂમિત ઉત્થાય ચક્ષુષી ઉન્મીલ્ય કમપિ ન દૃષ્ટવાન્| તદા લોકાસ્તસ્ય હસ્તૌ ધૃત્વા દમ્મેષક્નગરમ્ આનયન્| ");
INSERT INTO sanguj_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","તતઃ સ દિનત્રયં યાવદ્ અન્ધો ભૂત્વા ન ભુક્તવાન્ પીતવાંશ્ચ| ");
INSERT INTO sanguj_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","તદનન્તરં પ્રભુસ્તદ્દમ્મેષક્નગરવાસિન એકસ્મૈ શિષ્યાય દર્શનં દત્વા આહૂતવાન્ હે અનનિય| તતઃ સ પ્રત્યવાદીત્, હે પ્રભો પશ્ય શૃણોમિ| ");
INSERT INTO sanguj_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","તદા પ્રભુસ્તમાજ્ઞાપયત્ ત્વમુત્થાય સરલનામાનં માર્ગં ગત્વા યિહૂદાનિવેશને તાર્ષનગરીયં શૌલનામાનં જનં ગવેષયન્ પૃચ્છ; ");
INSERT INTO sanguj_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","પશ્ય સ પ્રાર્થયતે, તથા અનનિયનામક એકો જનસ્તસ્ય સમીપમ્ આગત્ય તસ્ય ગાત્રે હસ્તાર્પણં કૃત્વા દૃષ્ટિં દદાતીત્થં સ્વપ્ને દૃષ્ટવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","તસ્માદ્ અનનિયઃ પ્રત્યવદત્ હે પ્રભો યિરૂશાલમિ પવિત્રલોકાન્ પ્રતિ સોઽનેકહિંસાં કૃતવાન્; ");
INSERT INTO sanguj_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","અત્ર સ્થાને ચ યે લોકાસ્તવ નામ્નિ પ્રાર્થયન્તિ તાનપિ બદ્ધું સ પ્રધાનયાજકેભ્યઃ શક્તિં પ્રાપ્તવાન્, ઇમાં કથામ્ અહમ્ અનેકેષાં મુખેભ્યઃ શ્રુતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","કિન્તુ પ્રભુરકથયત્, યાહિ ભિન્નદેશીયલોકાનાં ભૂપતીનામ્ ઇસ્રાયેલ્લોકાનાઞ્ચ નિકટે મમ નામ પ્રચારયિતું સ જનો મમ મનોનીતપાત્રમાસ્તે| ");
INSERT INTO sanguj_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","મમ નામનિમિત્તઞ્ચ તેન કિયાન્ મહાન્ ક્લેશો ભોક્તવ્ય એતત્ તં દર્શયિષ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","તતો ઽનનિયો ગત્વા ગૃહં પ્રવિશ્ય તસ્ય ગાત્રે હસ્તાર્પ્રણં કૃત્વા કથિતવાન્, હે ભ્રાતઃ શૌલ ત્વં યથા દૃષ્ટિં પ્રાપ્નોષિ પવિત્રેણાત્મના પરિપૂર્ણો ભવસિ ચ, તદર્થં તવાગમનકાલે યઃ પ્રભુયીશુસ્તુભ્યં દર્શનમ્ અદદાત્ સ માં પ્રેષિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ઇત્યુક્તમાત્રે તસ્ય ચક્ષુર્ભ્યામ્ મીનશલ્કવદ્ વસ્તુનિ નિર્ગતે તત્ક્ષણાત્ સ પ્રસન્નચક્ષુ ર્ભૂત્વા પ્રોત્થાય મજ્જિતોઽભવત્ ભુક્ત્વા પીત્વા સબલોભવચ્ચ| ");
INSERT INTO sanguj_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","તતઃ પરં શૌલઃ શિષ્યૈઃ સહ કતિપયદિવસાન્ તસ્મિન્ દમ્મેષકનગરે સ્થિત્વાઽવિલમ્બં ");
INSERT INTO sanguj_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","સર્વ્વભજનભવનાનિ ગત્વા યીશુરીશ્વરસ્ય પુત્ર ઇમાં કથાં પ્રાચારયત્| ");
INSERT INTO sanguj_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","તસ્માત્ સર્વ્વે શ્રોતારશ્ચમત્કૃત્ય કથિતવન્તો યો યિરૂશાલમ્નગર એતન્નામ્ના પ્રાર્થયિતૃલોકાન્ વિનાશિતવાન્ એવમ્ એતાદૃશલોકાન્ બદ્ધ્વા પ્રધાનયાજકનિકટં નયતીત્યાશયા એતત્સ્થાનમપ્યાગચ્છત્ સએવ કિમયં ન ભવતિ? ");
INSERT INTO sanguj_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","કિન્તુ શૌલઃ ક્રમશ ઉત્સાહવાન્ ભૂત્વા યીશુરીશ્વરેણાભિષિક્તો જન એતસ્મિન્ પ્રમાણં દત્વા દમ્મેષક્-નિવાસિયિહૂદીયલોકાન્ નિરુત્તરાન્ અકરોત્| ");
INSERT INTO sanguj_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ઇત્થં બહુતિથે કાલે ગતે યિહૂદીયલોકાસ્તં હન્તું મન્ત્રયામાસુઃ ");
INSERT INTO sanguj_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","કિન્તુ શૌલસ્તેષામેતસ્યા મન્ત્રણાયા વાર્ત્તાં પ્રાપ્તવાન્| તે તં હન્તું તુ દિવાનિશં ગુપ્તાઃ સન્તો નગરસ્ય દ્વારેઽતિષ્ઠન્; ");
INSERT INTO sanguj_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","તસ્માત્ શિષ્યાસ્તં નીત્વા રાત્રૌ પિટકે નિધાય પ્રાચીરેણાવારોહયન્| ");
INSERT INTO sanguj_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","તતઃ પરં શૌલો યિરૂશાલમં ગત્વા શિષ્યગણેન સાર્દ્ધં સ્થાતુમ્ ઐહત્, કિન્તુ સર્વ્વે તસ્માદબિભયુઃ સ શિષ્ય ઇતિ ચ ન પ્રત્યયન્| ");
INSERT INTO sanguj_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","એતસ્માદ્ બર્ણબ્બાસ્તં ગૃહીત્વા પ્રેરિતાનાં સમીપમાનીય માર્ગમધ્યે પ્રભુઃ કથં તસ્મૈ દર્શનં દત્તવાન્ યાઃ કથાશ્ચ કથિતવાન્ સ ચ યથાક્ષોભઃ સન્ દમ્મેષક્નગરે યીશો ર્નામ પ્રાચારયત્ એતાન્ સર્વ્વવૃત્તાન્તાન્ તાન્ જ્ઞાપિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","તતઃ શૌલસ્તૈઃ સહ યિરૂશાલમિ કાલં યાપયન્ નિર્ભયં પ્રભો ર્યીશો ર્નામ પ્રાચારયત્| ");
INSERT INTO sanguj_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","તસ્માદ્ અન્યદેશીયલોકૈઃ સાર્દ્ધં વિવાદસ્યોપસ્થિતત્વાત્ તે તં હન્તુમ્ અચેષ્ટન્ત| ");
INSERT INTO sanguj_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","કિન્તુ ભ્રાતૃગણસ્તજ્જ્ઞાત્વા તં કૈસરિયાનગરં નીત્વા તાર્ષનગરં પ્રેષિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ઇત્થં સતિ યિહૂદિયાગાલીલ્શોમિરોણદેશીયાઃ સર્વ્વા મણ્ડલ્યો વિશ્રામં પ્રાપ્તાસ્તતસ્તાસાં નિષ્ઠાભવત્ પ્રભો ર્ભિયા પવિત્રસ્યાત્મનઃ સાન્ત્વનયા ચ કાલં ક્ષેપયિત્વા બહુસંખ્યા અભવન્| ");
INSERT INTO sanguj_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","તતઃ પરં પિતરઃ સ્થાને સ્થાને ભ્રમિત્વા શેષે લોદ્નગરનિવાસિપવિત્રલોકાનાં સમીપે સ્થિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","તદા તત્ર પક્ષાઘાતવ્યાધિનાષ્ટૌ વત્સરાન્ શય્યાગતમ્ ઐનેયનામાનં મનુષ્યં સાક્ષત્ પ્રાપ્ય તમવદત્, ");
INSERT INTO sanguj_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","હે ઐનેય યીશુખ્રીષ્ટસ્ત્વાં સ્વસ્થમ્ અકાર્ષીત્, ત્વમુત્થાય સ્વશય્યાં નિક્ષિપ, ઇત્યુક્તમાત્રે સ ઉદતિષ્ઠત્| ");
INSERT INTO sanguj_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","એતાદૃશં દૃષ્ટ્વા લોદ્શારોણનિવાસિનો લોકાઃ પ્રભું પ્રતિ પરાવર્ત્તન્ત| ");
INSERT INTO sanguj_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","અપરઞ્ચ ભિક્ષાદાનાદિષુ નાનક્રિયાસુ નિત્યં પ્રવૃત્તા યા યાફોનગરનિવાસિની ટાબિથાનામા શિષ્યા યાં દર્ક્કાં અર્થાદ્ હરિણીમયુક્ત્વા આહ્વયન્ સા નારી ");
INSERT INTO sanguj_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","તસ્મિન્ સમયે રુગ્ના સતી પ્રાણાન્ અત્યજત્, તતો લોકાસ્તાં પ્રક્ષાલ્યોપરિસ્થપ્રકોષ્ઠે શાયયિત્વાસ્થાપયન્| ");
INSERT INTO sanguj_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","લોદ્નગરં યાફોનગરસ્ય સમીપસ્થં તસ્માત્તત્ર પિતર આસ્તે, ઇતિ વાર્ત્તાં શ્રુત્વા તૂર્ણં તસ્યાગમનાર્થં તસ્મિન્ વિનયમુક્ત્વા શિષ્યગણો દ્વૌ મનુજૌ પ્રેષિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","તસ્માત્ પિતર ઉત્થાય તાભ્યાં સાર્દ્ધમ્ આગચ્છત્, તત્ર તસ્મિન્ ઉપસ્થિત ઉપરિસ્થપ્રકોષ્ઠં સમાનીતે ચ વિધવાઃ સ્વાભિઃ સહ સ્થિતિકાલે દર્ક્કયા કૃતાનિ યાન્યુત્તરીયાણિ પરિધેયાનિ ચ તાનિ સર્વ્વાણિ તં દર્શયિત્વા રુદત્યશ્ચતસૃષુ દિક્ષ્વતિષ્ઠન્| ");
INSERT INTO sanguj_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","કિન્તુ પિતરસ્તાઃ સર્વ્વા બહિઃ કૃત્વા જાનુની પાતયિત્વા પ્રાર્થિતવાન્; પશ્ચાત્ શવં પ્રતિ દૃષ્ટિં કૃત્વા કથિતવાન્, હે ટાબીથે ત્વમુત્તિષ્ઠ, ઇતિ વાક્ય ઉક્તે સા સ્ત્રી ચક્ષુષી પ્રોન્મીલ્ય પિતરમ્ અવલોક્યોત્થાયોપાવિશત્| ");
INSERT INTO sanguj_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","તતઃ પિતરસ્તસ્યાઃ કરૌ ધૃત્વા ઉત્તોલ્ય પવિત્રલોકાન્ વિધવાશ્ચાહૂય તેષાં નિકટે સજીવાં તાં સમાર્પયત્| ");
INSERT INTO sanguj_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","એષા કથા સમસ્તયાફોનગરં વ્યાપ્તા તસ્માદ્ અનેકે લોકાઃ પ્રભૌ વ્યશ્વસન્| ");
INSERT INTO sanguj_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","અપરઞ્ચ પિતરસ્તદ્યાફોનગરીયસ્ય કસ્યચિત્ શિમોન્નામ્નશ્ચર્મ્મકારસ્ય ગૃહે બહુદિનાનિ ન્યવસત્| ");
INSERT INTO sanguj_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","કૈસરિયાનગર ઇતાલિયાખ્યસૈન્યાન્તર્ગતઃ કર્ણીલિયનામા સેનાપતિરાસીત્ ");
INSERT INTO sanguj_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","સ સપરિવારો ભક્ત ઈશ્વરપરાયણશ્ચાસીત્; લોકેભ્યો બહૂનિ દાનાદીનિ દત્વા નિરન્તરમ્ ઈશ્વરે પ્રાર્થયાઞ્ચક્રે| ");
INSERT INTO sanguj_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","એકદા તૃતીયપ્રહરવેલાયાં સ દૃષ્ટવાન્ ઈશ્વરસ્યૈકો દૂતઃ સપ્રકાશં તત્સમીપમ્ આગત્ય કથિતવાન્, હે કર્ણીલિય| ");
INSERT INTO sanguj_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","કિન્તુ સ તં દૃષ્ટ્વા ભીતોઽકથયત્, હે પ્રભો કિં? તદા તમવદત્ તવ પ્રાર્થના દાનાદિ ચ સાક્ષિસ્વરૂપં ભૂત્વેશ્વરસ્ય ગોચરમભવત્| ");
INSERT INTO sanguj_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ઇદાનીં યાફોનગરં પ્રતિ લોકાન્ પ્રેષ્ય સમુદ્રતીરે શિમોન્નામ્નશ્ચર્મ્મકારસ્ય ગૃહે પ્રવાસકારી પિતરનામ્ના વિખ્યાતો યઃ શિમોન્ તમ્ આહ્વાયય; ");
INSERT INTO sanguj_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","તસ્માત્ ત્વયા યદ્યત્ કર્ત્તવ્યં તત્તત્ સ વદિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ઇત્યુપદિશ્ય દૂતે પ્રસ્થિતે સતિ કર્ણીલિયઃ સ્વગૃહસ્થાનાં દાસાનાં દ્વૌ જનૌ નિત્યં સ્વસઙ્ગિનાં સૈન્યાનામ્ એકાં ભક્તસેનાઞ્ચાહૂય ");
INSERT INTO sanguj_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","સકલમેતં વૃત્તાન્તં વિજ્ઞાપ્ય યાફોનગરં તાન્ પ્રાહિણોત્| ");
INSERT INTO sanguj_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","પરસ્મિન્ દિને તે યાત્રાં કૃત્વા યદા નગરસ્ય સમીપ ઉપાતિષ્ઠન્, તદા પિતરો દ્વિતીયપ્રહરવેલાયાં પ્રાર્થયિતું ગૃહપૃષ્ઠમ્ આરોહત્| ");
INSERT INTO sanguj_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","એતસ્મિન્ સમયે ક્ષુધાર્ત્તઃ સન્ કિઞ્ચિદ્ ભોક્તુમ્ ઐચ્છત્ કિન્તુ તેષામ્ અન્નાસાદનસમયે સ મૂર્ચ્છિતઃ સન્નપતત્| ");
INSERT INTO sanguj_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","તતો મેઘદ્વારં મુક્તં ચતુર્ભિઃ કોણૈ ર્લમ્બિતં બૃહદ્વસ્ત્રમિવ કિઞ્ચન ભાજનમ્ આકાશાત્ પૃથિવીમ્ અવારોહતીતિ દૃષ્ટવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","તન્મધ્યે નાનપ્રકારા ગ્રામ્યવન્યપશવઃ ખેચરોરોગામિપ્રભૃતયો જન્તવશ્ચાસન્| ");
INSERT INTO sanguj_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","અનન્તરં હે પિતર ઉત્થાય હત્વા ભુંક્ષ્વ તમ્પ્રતીયં ગગણીયા વાણી જાતા| ");
INSERT INTO sanguj_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","તદા પિતરઃ પ્રત્યવદત્, હે પ્રભો ઈદૃશં મા ભવતુ, અહમ્ એતત્ કાલં યાવત્ નિષિદ્ધમ્ અશુચિ વા દ્રવ્યં કિઞ્ચિદપિ ન ભુક્તવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","તતઃ પુનરપિ તાદૃશી વિહયસીયા વાણી જાતા યદ્ ઈશ્વરઃ શુચિ કૃતવાન્ તત્ ત્વં નિષિદ્ધં ન જાનીહિ| ");
INSERT INTO sanguj_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ઇત્થં ત્રિઃ સતિ તત્ પાત્રં પુનરાકૃષ્ટં આકાશમ્ અગચ્છત્| ");
INSERT INTO sanguj_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","તતઃ પરં યદ્ દર્શનં પ્રાપ્તવાન્ તસ્ય કો ભાવ ઇત્યત્ર પિતરો મનસા સન્દેગ્ધિ, એતસ્મિન્ સમયે કર્ણીલિયસ્ય તે પ્રેષિતા મનુષ્યા દ્વારસ્ય સન્નિધાવુપસ્થાય, ");
INSERT INTO sanguj_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","શિમોનો ગૃહમન્વિચ્છન્તઃ સમ્પૃછ્યાહૂય કથિતવન્તઃ પિતરનામ્ના વિખ્યાતો યઃ શિમોન્ સ કિમત્ર પ્રવસતિ? ");
INSERT INTO sanguj_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","યદા પિતરસ્તદ્દર્શનસ્ય ભાવં મનસાન્દોલયતિ તદાત્મા તમવદત્, પશ્ય ત્રયો જનાસ્ત્વાં મૃગયન્તે| ");
INSERT INTO sanguj_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ત્વમ્ ઉત્થાયાવરુહ્ય નિઃસન્દેહં તૈઃ સહ ગચ્છ મયૈવ તે પ્રેષિતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","તસ્માત્ પિતરોઽવરુહ્ય કર્ણીલિયપ્રેરિતલોકાનાં નિકટમાગત્ય કથિતવાન્ પશ્યત યૂયં યં મૃગયધ્વે સ જનોહં, યૂયં કિન્નિમિત્તમ્ આગતાઃ? ");
INSERT INTO sanguj_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","તતસ્તે પ્રત્યવદન્ કર્ણીલિયનામા શુદ્ધસત્ત્વ ઈશ્વરપરાયણો યિહૂદીયદેશસ્થાનાં સર્વ્વેષાં સન્નિધૌ સુખ્યાત્યાપન્ન એકઃ સેનાપતિ ર્નિજગૃહં ત્વામાહૂય નેતું ત્વત્તઃ કથા શ્રોતુઞ્ચ પવિત્રદૂતેન સમાદિષ્ટઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","તદા પિતરસ્તાનભ્યન્તરં નીત્વા તેષામાતિથ્યં કૃતવાન્, પરેઽહનિ તૈઃ સાર્દ્ધં યાત્રામકરોત્, યાફોનિવાસિનાં ભ્રાતૃણાં કિયન્તો જનાશ્ચ તેન સહ ગતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","પરસ્મિન્ દિવસે કૈસરિયાનગરમધ્યપ્રવેશસમયે કર્ણીલિયો જ્ઞાતિબન્ધૂન્ આહૂયાનીય તાન્ અપેક્ષ્ય સ્થિતઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","પિતરે ગૃહ ઉપસ્થિતે કર્ણીલિયસ્તં સાક્ષાત્કૃત્ય ચરણયોઃ પતિત્વા પ્રાણમત્| ");
INSERT INTO sanguj_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","પિતરસ્તમુત્થાપ્ય કથિતવાન્, ઉત્તિષ્ઠાહમપિ માનુષઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","તદા કર્ણીલિયેન સાકમ્ આલપન્ ગૃહં પ્રાવિશત્ તન્મધ્યે ચ બહુલોકાનાં સમાગમં દૃષ્ટ્વા તાન્ અવદત્, ");
INSERT INTO sanguj_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","અન્યજાતીયલોકૈઃ મહાલપનં વા તેષાં ગૃહમધ્યે પ્રવેશનં યિહૂદીયાનાં નિષિદ્ધમ્ અસ્તીતિ યૂયમ્ અવગચ્છથ; કિન્તુ કમપિ માનુષમ્ અવ્યવહાર્ય્યમ્ અશુચિં વા જ્ઞાતું મમ નોચિતમ્ ઇતિ પરમેશ્વરો માં જ્ઞાપિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ઇતિ હેતોરાહ્વાનશ્રવણમાત્રાત્ કાઞ્ચનાપત્તિમ્ અકૃત્વા યુષ્માકં સમીપમ્ આગતોસ્મિ; પૃચ્છામિ યૂયં કિન્નિમિત્તં મામ્ આહૂયત? ");
INSERT INTO sanguj_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","તદા કર્ણીલિયઃ કથિતવાન્, અદ્ય ચત્વારિ દિનાનિ જાતાનિ એતાવદ્વેલાં યાવદ્ અહમ્ અનાહાર આસન્ તતસ્તૃતીયપ્રહરે સતિ ગૃહે પ્રાર્થનસમયે તેજોમયવસ્ત્રભૃદ્ એકો જનો મમ સમક્ષં તિષ્ઠન્ એતાં કથામ્ અકથયત્, ");
INSERT INTO sanguj_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","હે કર્ણીલિય ત્વદીયા પ્રાર્થના ઈશ્વરસ્ય કર્ણગોચરીભૂતા તવ દાનાદિ ચ સાક્ષિસ્વરૂપં ભૂત્વા તસ્ય દૃષ્ટિગોચરમભવત્| ");
INSERT INTO sanguj_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","અતો યાફોનગરં પ્રતિ લોકાન્ પ્રહિત્ય તત્ર સમુદ્રતીરે શિમોન્નામ્નઃ કસ્યચિચ્ચર્મ્મકારસ્ય ગૃહે પ્રવાસકારી પિતરનામ્ના વિખ્યાતો યઃ શિમોન્ તમાહૂाયય; તતઃ સ આગત્ય ત્વામ્ ઉપદેક્ષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ઇતિ કારણાત્ તત્ક્ષણાત્ તવ નિકટે લોકાન્ પ્રેષિતવાન્, ત્વમાગતવાન્ ઇતિ ભદ્રં કૃતવાન્| ઈશ્વરો યાન્યાખ્યાનાનિ કથયિતુમ્ આદિશત્ તાનિ શ્રોતું વયં સર્વ્વે સામ્પ્રતમ્ ઈશ્વરસ્ય સાક્ષાદ્ ઉપસ્થિતાઃ સ્મઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","તદા પિતર ઇમાં કથાં કથયિતુમ્ આરબ્ધવાન્, ઈશ્વરો મનુષ્યાણામ્ અપક્ષપાતી સન્ ");
INSERT INTO sanguj_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","યસ્ય કસ્યચિદ્ દેશસ્ય યો લોકાસ્તસ્માદ્ભીત્વા સત્કર્મ્મ કરોતિ સ તસ્ય ગ્રાહ્યો ભવતિ, એતસ્ય નિશ્ચયમ્ ઉપલબ્ધવાનહમ્| ");
INSERT INTO sanguj_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","સર્વ્વેષાં પ્રભુ ર્યો યીશુખ્રીષ્ટસ્તેન ઈશ્વર ઇસ્રાયેલ્વંશાનાં નિકટે સુસંવાદં પ્રેષ્ય સમ્મેલનસ્ય યં સંવાદં પ્રાચારયત્ તં સંવાદં યૂયં શ્રુતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","યતો યોહના મજ્જને પ્રચારિતે સતિ સ ગાલીલદેશમારભ્ય સમસ્તયિહૂદીયદેશં વ્યાપ્નોત્; ");
INSERT INTO sanguj_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ફલત ઈશ્વરેણ પવિત્રેણાત્મના શક્ત્યા ચાભિષિક્તો નાસરતીયયીશુઃ સ્થાને સ્થાને ભ્રમન્ સુક્રિયાં કુર્વ્વન્ શૈતાના ક્લિષ્ટાન્ સર્વ્વલોકાન્ સ્વસ્થાન્ અકરોત્, યત ઈશ્વરસ્તસ્ય સહાય આસીત્; ");
INSERT INTO sanguj_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","વયઞ્ચ યિહૂદીયદેશે યિરૂશાલમ્નગરે ચ તેન કૃતાનાં સર્વ્વેષાં કર્મ્મણાં સાક્ષિણો ભવામઃ| લોકાસ્તં ક્રુશે વિદ્ધ્વા હતવન્તઃ, ");
INSERT INTO sanguj_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","કિન્તુ તૃતીયદિવસે ઈશ્વરસ્તમુત્થાપ્ય સપ્રકાશમ્ અદર્શયત્| ");
INSERT INTO sanguj_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","સર્વ્વલોકાનાં નિકટ ઇતિ ન હિ, કિન્તુ તસ્મિન્ શ્મશાનાદુત્થિતે સતિ તેન સાર્દ્ધં ભોજનં પાનઞ્ચ કૃતવન્ત એતાદૃશા ઈશ્વરસ્ય મનોનીતાઃ સાક્ષિણો યે વયમ્ અસ્માકં નિકટે તમદર્શયત્| ");
INSERT INTO sanguj_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","જીવિતમૃતોભયલોકાનાં વિચારં કર્ત્તુમ્ ઈશ્વરો યં નિયુક્તવાન્ સ એવ સ જનઃ, ઇમાં કથાં પ્રચારયિતું તસ્મિન્ પ્રમાણં દાતુઞ્ચ સોઽસ્માન્ આજ્ઞાપયત્| ");
INSERT INTO sanguj_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","યસ્તસ્મિન્ વિશ્વસિતિ સ તસ્ય નામ્ના પાપાન્મુક્તો ભવિષ્યતિ તસ્મિન્ સર્વ્વે ભવિષ્યદ્વાદિનોપિ એતાદૃશં સાક્ષ્યં દદતિ| ");
INSERT INTO sanguj_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","પિતરસ્યૈતત્કથાકથનકાલે સર્વ્વેષાં શ્રોતૃણામુપરિ પવિત્ર આત્માવારોહત્| ");
INSERT INTO sanguj_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","તતઃ પિતરેણ સાર્દ્ધમ્ આગતાસ્ત્વક્છેદિનો વિશ્વાસિનો લોકા અન્યદેશીયેભ્યઃ પવિત્ર આત્મનિ દત્તે સતિ ");
INSERT INTO sanguj_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","તે નાનાજાતીયભાષાભિઃ કથાં કથયન્ત ઈશ્વરં પ્રશંસન્તિ, ઇતિ દૃષ્ટ્વા શ્રુત્વા ચ વિસ્મયમ્ આપદ્યન્ત| ");
INSERT INTO sanguj_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","તદા પિતરઃ કથિતવાન્, વયમિવ યે પવિત્રમ્ આત્માનં પ્રાપ્તાસ્તેષાં જલમજ્જનં કિં કોપિ નિષેદ્ધું શક્નોતિ? ");
INSERT INTO sanguj_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","તતઃ પ્રભો ર્નામ્ના મજ્જિતા ભવતેતિ તાનાજ્ઞાપયત્| અનન્તરં તે સ્વૈઃ સાર્દ્ધં કતિપયદિનાનિ સ્થાતું પ્રાર્થયન્ત| ");
INSERT INTO sanguj_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","ઇત્થં ભિન્નદેશીયલોકા અપીશ્વરસ્ય વાક્યમ્ અગૃહ્લન્ ઇમાં વાર્ત્તાં યિહૂદીયદેશસ્થપ્રેરિતા ભ્રાતૃગણશ્ચ શ્રુતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","તતઃ પિતરે યિરૂશાલમ્નગરં ગતવતિ ત્વક્છેદિનો લોકાસ્તેન સહ વિવદમાના અવદન્, ");
INSERT INTO sanguj_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ત્વમ્ અત્વક્છેદિલોકાનાં ગૃહં ગત્વા તૈઃ સાર્દ્ધં ભુક્તવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","તતઃ પિતર આદિતઃ ક્રમશસ્તત્કાર્ય્યસ્ય સર્વ્વવૃત્તાન્તમાખ્યાતુમ્ આરબ્ધવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","યાફોનગર એકદાહં પ્રાર્થયમાનો મૂર્ચ્છિતઃ સન્ દર્શનેન ચતુર્ષુ કોણેષુ લમ્બનમાનં વૃહદ્વસ્ત્રમિવ પાત્રમેકમ્ આકાશદવરુહ્ય મન્નિકટમ્ આગચ્છદ્ અપશ્યમ્| ");
INSERT INTO sanguj_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","પશ્ચાત્ તદ્ અનન્યદૃષ્ટ્યા દૃષ્ટ્વા વિવિચ્ય તસ્ય મધ્યે નાનાપ્રકારાન્ ગ્રામ્યવન્યપશૂન્ ઉરોગામિખેચરાંશ્ચ દૃષ્ટવાન્; ");
INSERT INTO sanguj_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","હે પિતર ત્વમુત્થાય ગત્વા ભુંક્ષ્વ માં સમ્બોધ્ય કથયન્તં શબ્દમેકં શ્રુતવાંશ્ચ| ");
INSERT INTO sanguj_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","તતોહં પ્રત્યવદં, હે પ્રભો નેત્થં ભવતુ, યતઃ કિઞ્ચન નિષિદ્ધમ્ અશુચિ દ્રવ્યં વા મમ મુખમધ્યં કદાપિ ન પ્રાવિશત્| ");
INSERT INTO sanguj_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","અપરમ્ ઈશ્વરો યત્ શુચિ કૃતવાન્ તન્નિષિદ્ધં ન જાનીહિ દ્વિ ર્મામ્પ્રતીદૃશી વિહાયસીયા વાણી જાતા| ");
INSERT INTO sanguj_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","ત્રિરિત્થં સતિ તત્ સર્વ્વં પુનરાકાશમ્ આકૃષ્ટં| ");
INSERT INTO sanguj_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","પશ્ચાત્ કૈસરિયાનગરાત્ ત્રયો જના મન્નિકટં પ્રેષિતા યત્ર નિવેશને સ્થિતોહં તસ્મિન્ સમયે તત્રોપાતિષ્ઠન્| ");
INSERT INTO sanguj_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","તદા નિઃસન્દેહં તૈઃ સાર્દ્ધં યાતુમ્ આત્મા મામાદિષ્ટવાન્; તતઃ પરં મયા સહૈતેષુ ષડ્ભ્રાતૃષુ ગતેષુ વયં તસ્ય મનુજસ્ય ગૃહં પ્રાવિશામ| ");
INSERT INTO sanguj_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","સોસ્માકં નિકટે કથામેતામ્ અકથયત્ એકદા દૂત એકઃ પ્રત્યક્ષીભૂય મમ ગૃહમધ્યે તિષ્ટન્ મામિત્યાજ્ઞાપિતવાન્, યાફોનગરં પ્રતિ લોકાન્ પ્રહિત્ય પિતરનામ્ના વિખ્યાતં શિમોનમ્ આહૂયય; ");
INSERT INTO sanguj_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","તતસ્તવ ત્વદીયપરિવારાણાઞ્ચ યેન પરિત્રાણં ભવિષ્યતિ તત્ સ ઉપદેક્ષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","અહં તાં કથામુત્થાપ્ય કથિતવાન્ તેન પ્રથમમ્ અસ્માકમ્ ઉપરિ યથા પવિત્ર આત્માવરૂઢવાન્ તથા તેષામપ્યુપરિ સમવરૂઢવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","તેન યોહન્ જલે મજ્જિતવાન્ ઇતિ સત્યં કિન્તુ યૂયં પવિત્ર આત્મનિ મજ્જિતા ભવિષ્યથ, ઇતિ યદ્વાક્યં પ્રભુરુદિતવાન્ તત્ તદા મયા સ્મૃતમ્| ");
INSERT INTO sanguj_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","અતઃ પ્રભા યીશુખ્રીષ્ટે પ્રત્યયકારિણો યે વયમ્ અસ્મભ્યમ્ ઈશ્વરો યદ્ દત્તવાન્ તત્ તેભ્યો લોકેભ્યોપિ દત્તવાન્ તતઃ કોહં? કિમહમ્ ઈશ્વરં વારયિતું શક્નોમિ? ");
INSERT INTO sanguj_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","કથામેતાં શ્રુવા તે ક્ષાન્તા ઈશ્વરસ્ય ગુણાન્ અનુકીર્ત્ત્ય કથિતવન્તઃ, તર્હિ પરમાયુઃપ્રાપ્તિનિમિત્તમ્ ઈશ્વરોન્યદેશીયલોકેભ્યોપિ મનઃપરિવર્ત્તનરૂપં દાનમ્ અદાત્| ");
INSERT INTO sanguj_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","સ્તિફાનં પ્રતિ ઉપદ્રવે ઘટિતે યે વિકીર્ણા અભવન્ તૈ ફૈનીકીકુપ્રાન્તિયખિયાસુ ભ્રમિત્વા કેવલયિહૂદીયલોકાન્ વિના કસ્યાપ્યન્યસ્ય સમીપ ઈશ્વરસ્ય કથાં ન પ્રાચારયન્| ");
INSERT INTO sanguj_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","અપરં તેષાં કુપ્રીયાઃ કુરીનીયાશ્ચ કિયન્તો જના આન્તિયખિયાનગરં ગત્વા યૂનાનીયલોકાનાં સમીપેપિ પ્રભોર્યીશોઃ કથાં પ્રાચારયન્| ");
INSERT INTO sanguj_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","પ્રભોઃ કરસ્તેષાં સહાય આસીત્ તસ્માદ્ અનેકે લોકા વિશ્વસ્ય પ્રભું પ્રતિ પરાવર્ત્તન્ત| ");
INSERT INTO sanguj_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ઇતિ વાર્ત્તાયાં યિરૂશાલમસ્થમણ્ડલીયલોકાનાં કર્ણગોચરીભૂતાયામ્ આન્તિયખિયાનગરં ગન્તુ તે બર્ણબ્બાં પ્રૈરયન્| ");
INSERT INTO sanguj_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","તતો બર્ણબ્બાસ્તત્ર ઉપસ્થિતઃ સન્ ઈશ્વરસ્યાનુગ્રહસ્ય ફલં દૃષ્ટ્વા સાનન્દો જાતઃ, ");
INSERT INTO sanguj_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","સ સ્વયં સાધુ ર્વિશ્વાસેન પવિત્રેણાત્મના ચ પરિપૂર્ણઃ સન્ ગનોનિષ્ટયા પ્રભાવાસ્થાં કર્ત્તું સર્વ્વાન્ ઉપદિષ્ટવાન્ તેન પ્રભોઃ શિષ્યા અનેકે બભૂવુઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","શેષે શૌલં મૃગયિતું બર્ણબ્બાસ્તાર્ષનગરં પ્રસ્થિતવાન્| તત્ર તસ્યોદ્દેશં પ્રાપ્ય તમ્ આન્તિયખિયાનગરમ્ આનયત્; ");
INSERT INTO sanguj_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","તતસ્તૌ મણ્ડલીસ્થલોકૈઃ સભાં કૃત્વા સંવત્સરમેકં યાવદ્ બહુલોકાન્ ઉપાદિશતાં; તસ્મિન્ આન્તિયખિયાનગરે શિષ્યાઃ પ્રથમં ખ્રીષ્ટીયનામ્ના વિખ્યાતા અભવન્| ");
INSERT INTO sanguj_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","તતઃ પરં ભવિષ્યદ્વાદિગણે યિરૂશાલમ આન્તિયખિયાનગરમ્ આગતે સતિ ");
INSERT INTO sanguj_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","આગાબનામા તેષામેક ઉત્થાય આત્મનઃ શિક્ષયા સર્વ્વદેશે દુર્ભિક્ષં ભવિષ્યતીતિ જ્ઞાપિતવાન્; તતઃ ક્લૌદિયકૈસરસ્યાધિકારે સતિ તત્ પ્રત્યક્ષમ્ અભવત્| ");
INSERT INTO sanguj_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","તસ્માત્ શિષ્યા એકૈકશઃ સ્વસ્વશક્ત્યનુસારતો યિહૂદીયદેશનિવાસિનાં ભ્રતૃણાં દિનયાપનાર્થં ધનં પ્રેષયિતું નિશ્ચિત્ય ");
INSERT INTO sanguj_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","બર્ણબ્બાશૌલયો ર્દ્વારા પ્રાચીનલોકાનાં સમીપં તત્ પ્રેષિતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","તસ્મિન્ સમયે હેરોદ્‌રાજો મણ્ડલ્યાઃ કિયજ્જનેભ્યો દુઃખં દાતું પ્રારભત્| ");
INSERT INTO sanguj_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","વિશેષતો યોહનઃ સોદરં યાકૂબં કરવાલાઘાતેન્ હતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","તસ્માદ્ યિહૂદીયાઃ સન્તુષ્ટા અભવન્ ઇતિ વિજ્ઞાય સ પિતરમપિ ધર્ત્તું ગતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","તદા કિણ્વશૂન્યપૂપોત્સવસમય ઉપાતિષ્ટત્; અત ઉત્સવે ગતે સતિ લોકાનાં સમક્ષં તં બહિરાનેય્યામીતિ મનસિ સ્થિરીકૃત્ય સ તં ધારયિત્વા રક્ષ્ણાર્થમ્ યેષામ્ એકૈકસંઘે ચત્વારો જનાઃ સન્તિ તેષાં ચતુર્ણાં રક્ષકસંઘાનાં સમીપે તં સમર્પ્ય કારાયાં સ્થાપિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","કિન્તું પિતરસ્ય કારાસ્થિતિકારણાત્ મણ્ડલ્યા લોકા અવિશ્રામમ્ ઈશ્વરસ્ય સમીપે પ્રાર્થયન્ત| ");
INSERT INTO sanguj_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","અનન્તરં હેરોદિ તં બહિરાનાયિતું ઉદ્યતે સતિ તસ્યાં રાત્રૌ પિતરો રક્ષકદ્વયમધ્યસ્થાને શૃઙ્ખલદ્વયેન બદ્ધ્વઃ સન્ નિદ્રિત આસીત્, દૌવારિકાશ્ચ કારાયાઃ સમ્મુખે તિષ્ઠનતો દ્વારમ્ અરક્ષિષુઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","એતસ્મિન્ સમયે પરમેશ્વરસ્ય દૂતે સમુપસ્થિતે કારા દીપ્તિમતી જાતા; તતઃ સ દૂતઃ પિતરસ્ય કુક્ષાવાવાતં કૃત્વા તં જાગરયિત્વા ભાષિતવાન્ તૂર્ણમુત્તિષ્ઠ; તતસ્તસ્ય હસ્તસ્થશૃઙ્ખલદ્વયં ગલત્ પતિતં| ");
INSERT INTO sanguj_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","સ દૂતસ્તમવદત્, બદ્ધકટિઃ સન્ પાદયોઃ પાદુકે અર્પય; તેન તથા કૃતે સતિ દૂતસ્તમ્ ઉક્તવાન્ ગાત્રીયવસ્ત્રં ગાત્રે નિધાય મમ પશ્ચાદ્ એહિ| ");
INSERT INTO sanguj_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","તતઃ પિતરસ્તસ્ય પશ્ચાદ્ વ્રજન બહિરગચ્છત્, કિન્તુ દૂતેન કર્મ્મૈતત્ કૃતમિતિ સત્યમજ્ઞાત્વા સ્વપ્નદર્શનં જ્ઞાતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ઇત્થં તૌ પ્રથમાં દ્વિતીયાઞ્ચ કારાં લઙ્ઘિત્વા યેન લૌહનિર્મ્મિતદ્વારેણ નગરં ગમ્યતે તત્સમીપં પ્રાપ્નુતાં; તતસ્તસ્ય કવાટં સ્વયં મુક્તમભવત્ તતસ્તૌ તત્સ્થાનાદ્ બહિ ર્ભૂત્વા માર્ગૈકસ્ય સીમાં યાવદ્ ગતૌ; તતોઽકસ્માત્ સ દૂતઃ પિતરં ત્યક્તવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","તદા સ ચેતનાં પ્રાપ્ય કથિતવાન્ નિજદૂતં પ્રહિત્ય પરમેશ્વરો હેરોદો હસ્તાદ્ યિહૂદીયલોકાનાં સર્વ્વાશાયાશ્ચ માં સમુદ્ધૃતવાન્ ઇત્યહં નિશ્ચયં જ્ઞાતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","સ વિવિચ્ય માર્કનામ્રા વિખ્યાતસ્ય યોહનો માતુ ર્મરિયમો યસ્મિન્ ગૃહે બહવઃ સમ્ભૂય પ્રાર્થયન્ત તન્નિવેશનં ગતઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","પિતરેણ બહિર્દ્વાર આહતે સતિ રોદાનામા બાલિકા દ્રષ્ટું ગતા| ");
INSERT INTO sanguj_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","તતઃ પિતરસ્ય સ્વરં શ્રુવા સા હર્ષયુક્તા સતી દ્વારં ન મોચયિત્વા પિતરો દ્વારે તિષ્ઠતીતિ વાર્ત્તાં વક્તુમ્ અભ્યન્તરં ધાવિત્વા ગતવતી| ");
INSERT INTO sanguj_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","તે પ્રાવોચન્ ત્વમુન્મત્તા જાતાસિ કિન્તુ સા મુહુર્મુહુરુક્તવતી સત્યમેવૈતત્| ");
INSERT INTO sanguj_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","તદા તે કથિતવન્તસ્તર્હિ તસ્ય દૂતો ભવેત્| ");
INSERT INTO sanguj_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","પિતરો દ્વારમાહતવાન્ એતસ્મિન્નન્તરે દ્વારં મોચયિત્વા પિતરં દૃષ્ટ્વા વિસ્મયં પ્રાપ્તાઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","તતઃ પિતરો નિઃશબ્દં સ્થાતું તાન્ પ્રતિ હસ્તેન સઙ્કેતં કૃત્વા પરમેશ્વરો યેન પ્રકારેણ તં કારાયા ઉદ્ધૃત્યાનીતવાન્ તસ્ય વૃત્તાન્તં તાનજ્ઞાપયત્, યૂયં ગત્વા યાકુબં ભ્રાતૃગણઞ્ચ વાર્ત્તામેતાં વદતેત્યુક્તા સ્થાનાન્તરં પ્રસ્થિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","પ્રભાતે સતિ પિતરઃ ક્વ ગત ઇત્યત્ર રક્ષકાણાં મધ્યે મહાન્ કલહો જાતઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","હેરોદ્ બહુ મૃગયિત્વા તસ્યોદ્દેશે ન પ્રાપ્તે સતિ રક્ષકાન્ સંપૃચ્છ્ય તેષાં પ્રાણાન્ હન્તુમ્ આદિષ્ટવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","પશ્ચાત્ સ યિહૂદીયપ્રદેશાત્ કૈસરિયાનગરં ગત્વા તત્રાવાતિષ્ઠત્| ");
INSERT INTO sanguj_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","સોરસીદોનદેશયો ર્લોકેભ્યો હેરોદિ યુયુત્સૌ સતિ તે સર્વ્વ એકમન્ત્રણાઃ સન્તસ્તસ્ય સમીપ ઉપસ્થાય લ્વાસ્તનામાનં તસ્ય વસ્ત્રગૃહાધીશં સહાયં કૃત્વા હેરોદા સાર્દ્ધં સન્ધિં પ્રાર્થયન્ત યતસ્તસ્ય રાજ્ઞો દેશેન તેષાં દેશીયાનાં ભરણમ્ અભવત્ં ");
INSERT INTO sanguj_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","અતઃ કુત્રચિન્ નિરુપિતદિને હેરોદ્ રાજકીયં પરિચ્છદં પરિધાય સિંહાસને સમુપવિશ્ય તાન્ પ્રતિ કથામ્ ઉક્તવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","તતો લોકા ઉચ્ચૈઃકારં પ્રત્યવદન્, એષ મનુજરવો ન હિ, ઈશ્વરીયરવઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","તદા હેરોદ્ ઈશ્વરસ્ય સમ્માનં નાકરોત્; તસ્માદ્ધેતોઃ પરમેશ્વરસ્ય દૂતો હઠાત્ તં પ્રાહરત્ તેનૈવ સ કીટૈઃ ક્ષીણઃ સન્ પ્રાણાન્ અજહાત્| કિન્ત્વીશ્વરસ્ય કથા દેશં વ્યાપ્ય પ્રબલાભવત્| તતઃ પરં બર્ણબ્બાશૌલૌ યસ્ય કર્મ્મણો ભારં પ્રાપ્નુતાં તાભ્યાં તસ્મિન્ સમ્પાદિતે સતિ માર્કનામ્ના વિખ્યાતો યો યોહન્ તં સઙ્ગિનં કૃત્વા યિરૂશાલમ્નગરાત્ પ્રત્યાગતૌ| ");
INSERT INTO sanguj_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","અપરઞ્ચ બર્ણબ્બાઃ, શિમોન્ યં નિગ્રં વદન્તિ, કુરીનીયલૂકિયો હેરોદા રાજ્ઞા સહ કૃતવિદ્યાाભ્યાસો મિનહેમ્, શૌલશ્ચૈતે યે કિયન્તો જના ભવિષ્યદ્વાદિન ઉપદેષ્ટારશ્ચાન્તિયખિયાનગરસ્થમણ્ડલ્યામ્ આસન્, ");
INSERT INTO sanguj_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","તે યદોપવાસં કૃત્વેશ્વરમ્ અસેવન્ત તસ્મિન્ સમયે પવિત્ર આત્મા કથિતવાન્ અહં યસ્મિન્ કર્મ્મણિ બર્ણબ્બાશૈલૌ નિયુક્તવાન્ તત્કર્મ્મ કર્ત્તું તૌ પૃથક્ કુરુત| ");
INSERT INTO sanguj_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","તતસ્તૈરુપવાસપ્રાર્થનયોઃ કૃતયોઃ સતોસ્તે તયો ર્ગાત્રયો ર્હસ્તાર્પણં કૃત્વા તૌ વ્યસૃજન્| ");
INSERT INTO sanguj_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","તતઃ પરં તૌ પવિત્રેણાત્મના પ્રેરિતૌ સન્તૌ સિલૂકિયાનગરમ્ ઉપસ્થાય સમુદ્રપથેન કુપ્રોપદ્વીપમ્ અગચ્છતાં| ");
INSERT INTO sanguj_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","તતઃ સાલામીનગરમ્ ઉપસ્થાય તત્ર યિહૂદીયાનાં ભજનભવનાનિ ગત્વેશ્વરસ્ય કથાં પ્રાચારયતાં; યોહનપિ તત્સહચરોઽભવત્| ");
INSERT INTO sanguj_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ઇત્થં તે તસ્યોપદ્વીપસ્ય સર્વ્વત્ર ભ્રમન્તઃ પાફનગરમ્ ઉપસ્થિતાઃ; તત્ર સુવિવેચકેન સર્જિયપૌલનામ્ના તદ્દેશાધિપતિના સહ ભવિષ્યદ્વાદિનો વેશધારી બર્યીશુનામા યો માયાવી યિહૂદી આસીત્ તં સાક્ષાત્ પ્રાપ્તવતઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","તદ્દેશાધિપ ઈશ્વરસ્ય કથાં શ્રોતું વાઞ્છન્ પૌલબર્ણબ્બૌ ન્યમન્ત્રયત્| ");
INSERT INTO sanguj_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","કિન્ત્વિલુમા યં માયાવિનં વદન્તિ સ દેશાધિપતિં ધર્મ્મમાર્ગાદ્ બહિર્ભૂતં કર્ત્તુમ્ અયતત| ");
INSERT INTO sanguj_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","તસ્માત્ શોલોઽર્થાત્ પૌલઃ પવિત્રેણાત્મના પરિપૂર્ણઃ સન્ તં માયાવિનં પ્રત્યનન્યદૃષ્ટિં કૃત્વાકથયત્, ");
INSERT INTO sanguj_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","હે નરકિન્ ધર્મ્મદ્વેષિન્ કૌટિલ્યદુષ્કર્મ્મપરિપૂર્ણ, ત્વં કિં પ્રભોઃ સત્યપથસ્ય વિપર્ય્યયકરણાત્ કદાપિ ન નિવર્ત્તિષ્યસે? ");
INSERT INTO sanguj_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","અધુના પરમેશ્વરસ્તવ સમુચિતં કરિષ્યતિ તેન કતિપયદિનાનિ ત્વમ્ અન્ધઃ સન્ સૂર્ય્યમપિ ન દ્રક્ષ્યસિ| તત્ક્ષણાદ્ રાત્રિવદ્ અન્ધકારસ્તસ્ય દૃષ્ટિમ્ આચ્છાદિતવાન્; તસ્માત્ તસ્ય હસ્તં ધર્ત્તું સ લોકમન્વિચ્છન્ ઇતસ્તતો ભ્રમણં કૃતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","એનાં ઘટનાં દૃષ્ટ્વા સ દેશાધિપતિઃ પ્રભૂપદેશાદ્ વિસ્મિત્ય વિશ્વાસં કૃતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","તદનન્તરં પૌલસ્તત્સઙ્ગિનૌ ચ પાફનગરાત્ પ્રોતં ચાલયિત્વા પમ્ફુલિયાદેશસ્ય પર્ગીનગરમ્ અગચ્છન્ કિન્તુ યોહન્ તયોઃ સમીપાદ્ એત્ય યિરૂશાલમં પ્રત્યાગચ્છત્| ");
INSERT INTO sanguj_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","પશ્ચાત્ તૌ પર્ગીતો યાત્રાં કૃત્વા પિસિદિયાદેશસ્ય આન્તિયખિયાનગરમ્ ઉપસ્થાય વિશ્રામવારે ભજનભવનં પ્રવિશ્ય સમુપાવિશતાં| ");
INSERT INTO sanguj_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","વ્યવસ્થાભવિષ્યદ્વાક્યયોઃ પઠિતયોઃ સતો ર્હે ભ્રાતરૌ લોકાન્ પ્રતિ યુવયોઃ કાચિદ્ ઉપદેશકથા યદ્યસ્તિ તર્હિ તાં વદતં તૌ પ્રતિ તસ્ય ભજનભવનસ્યાધિપતયઃ કથામ્ એતાં કથયિત્વા પ્રૈષયન્| ");
INSERT INTO sanguj_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","અતઃ પૌલ ઉત્તિષ્ઠન્ હસ્તેન સઙ્કેતં કુર્વ્વન્ કથિતવાન્ હે ઇસ્રાયેલીયમનુષ્યા ઈશ્વરપરાયણાઃ સર્વ્વે લોકા યૂયમ્ અવધદ્ધં| ");
INSERT INTO sanguj_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","એતેષામિસ્રાયેલ્લોકાનામ્ ઈશ્વરોઽસ્માકં પૂર્વ્વપરુષાન્ મનોનીતાન્ કત્વા ગૃહીતવાન્ તતો મિસરિ દેશે પ્રવસનકાલે તેષામુન્નતિં કૃત્વા તસ્માત્ સ્વીયબાહુબલેન તાન્ બહિઃ કૃત્વા સમાનયત્| ");
INSERT INTO sanguj_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ચત્વારિંશદ્વત્સરાન્ યાવચ્ચ મહાપ્રાન્તરે તેષાં ભરણં કૃત્વા ");
INSERT INTO sanguj_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","કિનાન્દેશાન્તર્વ્વર્ત્તીણિ સપ્તરાજ્યાનિ નાશયિત્વા ગુટિકાપાતેન તેષુ સર્વ્વદેશેષુ તેભ્યોઽધિકારં દત્તવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","પઞ્ચાશદધિકચતુઃશતેષુ વત્સરેષુ ગતેષુ ચ શિમૂયેલ્ભવિષ્યદ્વાદિપર્ય્યન્તં તેષામુપરિ વિચારયિતૃન્ નિયુક્તવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","તૈશ્ચ રાજ્ઞિ પ્રાર્થિતે, ઈશ્વરો બિન્યામીનો વંશજાતસ્ય કીશઃ પુત્રં શૌલં ચત્વારિંશદ્વર્ષપર્ય્યન્તં તેષામુપરિ રાજાનં કૃતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","પશ્ચાત્ તં પદચ્યુતં કૃત્વા યો મદિષ્ટક્રિયાઃ સર્વ્વાઃ કરિષ્યતિ તાદૃશં મમ મનોભિમતમ્ એકં જનં યિશયઃ પુત્રં દાયૂદં પ્રાપ્તવાન્ ઇદં પ્રમાણં યસ્મિન્ દાયૂદિ સ દત્તવાન્ તં દાયૂદં તેષામુપરિ રાજત્વં કર્ત્તુમ્ ઉત્પાદિતવાન| ");
INSERT INTO sanguj_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","તસ્ય સ્વપ્રતિશ્રુતસ્ય વાક્યસ્યાનુસારેણ ઇસ્રાયેલ્લોકાનાં નિમિત્તં તેષાં મનુષ્યાણાં વંશાદ્ ઈશ્વર એકં યીશું (ત્રાતારમ્) ઉદપાદયત્| ");
INSERT INTO sanguj_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","તસ્ય પ્રકાશનાત્ પૂર્વ્વં યોહન્ ઇસ્રાયેલ્લોકાનાં સન્નિધૌ મનઃપરાવર્ત્તનરૂપં મજ્જનં પ્રાચારયત્| ");
INSERT INTO sanguj_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","યસ્ય ચ કર્મ્મણોे ભારં પ્રપ્તવાન્ યોહન્ તન્ નિષ્પાદયન્ એતાં કથાં કથિતવાન્, યૂયં માં કં જનં જાનીથ? અહમ્ અભિષિક્તત્રાતા નહિ, કિન્તુ પશ્યત યસ્ય પાદયોઃ પાદુકયો ર્બન્ધને મોચયિતુમપિ યોગ્યો ન ભવામિ તાદૃશ એકો જનો મમ પશ્ચાદ્ ઉપતિષ્ઠતિ| ");
INSERT INTO sanguj_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","હે ઇબ્રાહીમો વંશજાતા ભ્રાતરો હે ઈશ્વરભીતાઃ સર્વ્વલોકા યુષ્માન્ પ્રતિ પરિત્રાણસ્ય કથૈષા પ્રેરિતા| ");
INSERT INTO sanguj_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","યિરૂશાલમ્નિવાસિનસ્તેષામ્ અધિપતયશ્ચ તસ્ય યીશોઃ પરિચયં ન પ્રાપ્ય પ્રતિવિશ્રામવારં પઠ્યમાનાનાં ભવિષ્યદ્વાદિકથાનામ્ અભિપ્રાયમ્ અબુદ્ધ્વા ચ તસ્ય વધેન તાઃ કથાઃ સફલા અકુર્વ્વન્| ");
INSERT INTO sanguj_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","પ્રાણહનનસ્ય કમપિ હેતુમ્ અપ્રાપ્યાપિ પીલાતસ્ય નિકટે તસ્ય વધં પ્રાર્થયન્ત| ");
INSERT INTO sanguj_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","તસ્મિન્ યાઃ કથા લિખિતાઃ સન્તિ તદનુસારેણ કર્મ્મ સમ્પાદ્ય તં ક્રુશાદ્ અવતાર્ય્ય શ્મશાને શાયિતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","કિન્ત્વીશ્વરઃ શ્મશાનાત્ તમુદસ્થાપયત્, ");
INSERT INTO sanguj_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","પુનશ્ચ ગાલીલપ્રદેશાદ્ યિરૂશાલમનગરં તેન સાર્દ્ધં યે લોકા આગચ્છન્ સ બહુદિનાનિ તેભ્યો દર્શનં દત્તવાન્, અતસ્ત ઇદાનીં લોકાન્ પ્રતિ તસ્ય સાક્ષિણઃ સન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","અસ્માકં પૂર્વ્વપુરુષાણાં સમક્ષમ્ ઈશ્વરો યસ્મિન્ પ્રતિજ્ઞાતવાન્ યથા, ત્વં મે પુત્રોસિ ચાદ્ય ત્વાં સમુત્થાપિતવાનહમ્| ");
INSERT INTO sanguj_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ઇદં યદ્વચનં દ્વિતીયગીતે લિખિતમાસ્તે તદ્ યીશોરુત્થાનેન તેષાં સન્તાના યે વયમ્ અસ્માકં સન્નિધૌ તેન પ્રત્યક્ષી કૃતં, યુષ્માન્ ઇમં સુસંવાદં જ્ઞાપયામિ| ");
INSERT INTO sanguj_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","પરમેશ્વરેણ શ્મશાનાદ્ ઉત્થાપિતં તદીયં શરીરં કદાપિ ન ક્ષેષ્યતે, એતસ્મિન્ સ સ્વયં કથિતવાન્ યથા દાયૂદં પ્રતિ પ્રતિજ્ઞાતો યો વરસ્તમહં તુભ્યં દાસ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","એતદન્યસ્મિન્ ગીતેઽપિ કથિતવાન્| સ્વકીયં પુણ્યવન્તં ત્વં ક્ષયિતું ન ચ દાસ્યસિ| ");
INSERT INTO sanguj_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","દાયૂદા ઈશ્વરાભિમતસેવાયૈ નિજાયુષિ વ્યયિતે સતિ સ મહાનિદ્રાં પ્રાપ્ય નિજૈઃ પૂર્વ્વપુરુષૈઃ સહ મિલિતઃ સન્ અક્ષીયત; ");
INSERT INTO sanguj_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","કિન્તુ યમીશ્વરઃ શ્મશાનાદ્ ઉદસ્થાપયત્ સ નાક્ષીયત| ");
INSERT INTO sanguj_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","અતો હે ભ્રાતરઃ, અનેન જનેન પાપમોચનં ભવતીતિ યુષ્માન્ પ્રતિ પ્રચારિતમ્ આસ્તે| ");
INSERT INTO sanguj_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ફલતો મૂસાવ્યવસ્થયા યૂયં યેભ્યો દોષેભ્યો મુક્તા ભવિતું ન શક્ષ્યથ તેભ્યઃ સર્વ્વદોષેભ્ય એતસ્મિન્ જને વિશ્વાસિનઃ સર્વ્વે મુક્તા ભવિષ્યન્તીતિ યુષ્માભિ ર્જ્ઞાયતાં| ");
INSERT INTO sanguj_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","અપરઞ્ચ| અવજ્ઞાકારિણો લોકાશ્ચક્ષુરુન્મીલ્ય પશ્યત| તથૈવાસમ્ભવં જ્ઞાત્વા સ્યાત યૂયં વિલજ્જિતાઃ| યતો યુષ્માસુ તિષ્ઠત્સુ કરિષ્યે કર્મ્મ તાદૃશં| યેનૈવ તસ્ય વૃત્તાન્તે યુષ્મભ્યં કથિતેઽપિ હિ| યૂયં ન તન્તુ વૃત્તાન્તં પ્રત્યેષ્યથ કદાચન|| ");
INSERT INTO sanguj_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","યેયં કથા ભવિષ્યદ્વાદિનાં ગ્રન્થેષુ લિખિતાસ્તે સાવધાના ભવત સ કથા યથા યુષ્માન્ પ્રતિ ન ઘટતે| ");
INSERT INTO sanguj_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","યિહૂદીયભજનભવનાન્ નિર્ગતયોસ્તયો ર્ભિન્નદેશીયૈ ર્વક્ષ્યમાણા પ્રાર્થના કૃતા, આગામિનિ વિશ્રામવારેઽપિ કથેયમ્ અસ્માન્ પ્રતિ પ્રચારિતા ભવત્વિતિ| ");
INSERT INTO sanguj_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","સભાયા ભઙ્ગે સતિ બહવો યિહૂદીયલોકા યિહૂદીયમતગ્રાહિણો ભક્તલોકાશ્ચ બર્ણબ્બાપૌલયોઃ પશ્ચાદ્ આગચ્છન્, તેન તૌ તૈઃ સહ નાનાકથાઃ કથયિત્વેશ્વરાનુગ્રહાશ્રયે સ્થાતું તાન્ પ્રાવર્ત્તયતાં| ");
INSERT INTO sanguj_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","પરવિશ્રામવારે નગરસ્ય પ્રાયેણ સર્વ્વે લાકા ઈશ્વરીયાં કથાં શ્રોતું મિલિતાઃ, ");
INSERT INTO sanguj_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","કિન્તુ યિહૂદીયલોકા જનનિવહં વિલોક્ય ઈર્ષ્યયા પરિપૂર્ણાઃ સન્તો વિપરીતકથાકથનેનેશ્વરનિન્દયા ચ પૌલેનોક્તાં કથાં ખણ્ડયિતું ચેષ્ટિતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","તતઃ પૌैલબર્ણબ્બાવક્ષોભૌ કથિતવન્તૌ પ્રથમં યુષ્માકં સન્નિધાવીશ્વરીયકથાયાઃ પ્રચારણમ્ ઉચિતમાસીત્ કિન્તું તદગ્રાહ્યત્વકરણેન યૂયં સ્વાન્ અનન્તાયુષોઽયોગ્યાન્ દર્શયથ, એતત્કારણાદ્ વયમ્ અન્યદેશીયલોકાનાં સમીપં ગચ્છામઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","પ્રભુરસ્માન્ ઇત્થમ્ આદિષ્ટવાન્ યથા, યાવચ્ચ જગતઃ સીમાં લોકાનાં ત્રાણકારણાત્| મયાન્યદેશમધ્યે ત્વં સ્થાપિતો ભૂઃ પ્રદીપવત્|| ");
INSERT INTO sanguj_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","તદા કથામીદૃશીં શ્રુત્વા ભિન્નદેશીયા આહ્લાદિતાઃ સન્તઃ પ્રભોઃ કથાં ધન્યાં ધન્યામ્ અવદન્, યાવન્તો લોકાશ્ચ પરમાયુઃ પ્રાપ્તિનિમિત્તં નિરૂપિતા આસન્ તેे વ્યશ્વસન્| ");
INSERT INTO sanguj_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ઇત્થં પ્રભોઃ કથા સર્વ્વેદેશં વ્યાપ્નોત્| ");
INSERT INTO sanguj_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","કિન્તુ યિહૂદીયા નગરસ્ય પ્રધાનપુરુષાન્ સમ્માન્યાઃ કથિપયા ભક્તા યોષિતશ્ચ કુપ્રવૃત્તિં ગ્રાહયિત્વા પૌલબર્ણબ્બૌ તાડયિત્વા તસ્માત્ પ્રદેશાદ્ દૂરીકૃતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","અતઃ કારણાત્ તૌ નિજપદધૂલીસ્તેષાં પ્રાતિકૂલ્યેન પાતયિત્વેेકનિયં નગરં ગતૌ| ");
INSERT INTO sanguj_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","તતઃ શિષ્યગણ આનન્દેન પવિત્રેણાત્મના ચ પરિપૂર્ણોભવત્| ");
INSERT INTO sanguj_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","તૌ દ્વૌ જનૌ યુગપદ્ ઇકનિયનગરસ્થયિહૂદીયાનાં ભજનભવનં ગત્વા યથા બહવો યિહૂદીયા અન્યદેेશીયલોકાશ્ચ વ્યશ્વસન્ તાદૃશીં કથાં કથિતવન્તૌ| ");
INSERT INTO sanguj_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","કિન્તુ વિશ્વાસહીના યિહૂદીયા અન્યદેશીયલોકાન્ કુપ્રવૃત્તિં ગ્રાહયિત્વા ભ્રાતૃગણં પ્રતિ તેષાં વૈરં જનિતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","અતઃ સ્વાનુગ્રહકથાયાઃ પ્રમાણં દત્વા તયો ર્હસ્તૈ ર્બહુલક્ષણમ્ અદ્ભુતકર્મ્મ ચ પ્રાકાશયદ્ યઃ પ્રભુસ્તસ્ય કથા અક્ષોભેન પ્રચાર્ય્ય તૌ તત્ર બહુદિનાનિ સમવાતિષ્ઠેતાં| ");
INSERT INTO sanguj_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","કિન્તુ કિયન્તો લોકા યિહૂદીયાનાં સપક્ષાઃ કિયન્તો લોકાઃ પ્રેરિતાનાં સપક્ષા જાતાઃ, અતો નાગરિકજનનિવહમધ્યે ભિન્નવાક્યત્વમ્ અભવત્| ");
INSERT INTO sanguj_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","અન્યદેશીયા યિહૂદીયાસ્તેષામ્ અધિપતયશ્ચ દૌરાત્મ્યં કુત્વા તૌ પ્રસ્તરૈરાહન્તુમ્ ઉદ્યતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","તૌ તદ્વાર્ત્તાં પ્રાપ્ય પલાયિત્વા લુકાયનિયાદેશસ્યાન્તર્વ્વર્ત્તિલુસ્ત્રાદર્બ્બો ");
INSERT INTO sanguj_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","તત્સમીપસ્થદેશઞ્ચ ગત્વા તત્ર સુસંવાદં પ્રચારયતાં| ");
INSERT INTO sanguj_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","તત્રોભયપાદયોશ્ચલનશક્તિહીનો જન્મારભ્ય ખઞ્જઃ કદાપિ ગમનં નાકરોત્ એતાદૃશ એકો માનુષો લુસ્ત્રાનગર ઉપવિશ્ય પૌલસ્ય કથાં શ્રુતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","એતસ્મિન્ સમયે પૌલસ્તમ્પ્રતિ દૃષ્ટિં કૃત્વા તસ્ય સ્વાસ્થ્યે વિશ્વાસં વિદિત્વા પ્રોચ્ચૈઃ કથિતવાન્ ");
INSERT INTO sanguj_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","પદ્ભ્યામુત્તિષ્ઠન્ ઋજુ ર્ભવ| તતઃ સ ઉલ્લમ્ફં કૃત્વા ગમનાગમને કુતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","તદા લોકાઃ પૌલસ્ય તત્ કાર્ય્યં વિલોક્ય લુકાયનીયભાષયા પ્રોચ્ચૈઃ કથામેતાં કથિતવન્તઃ, દેવા મનુષ્યરૂપં ધૃત્વાસ્માકં સમીપમ્ અવારોહન્| ");
INSERT INTO sanguj_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","તે બર્ણબ્બાં યૂપિતરમ્ અવદન્ પૌલશ્ચ મુખ્યો વક્તા તસ્માત્ તં મર્કુરિયમ્ અવદન્| ");
INSERT INTO sanguj_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","તસ્ય નગરસ્ય સમ્મુખે સ્થાપિતસ્ય યૂપિતરવિગ્રહસ્ય યાજકો વૃષાન્ પુષ્પમાલાશ્ચ દ્વારસમીપમ્ આનીય લોકૈઃ સર્દ્ધં તાવુદ્દિશ્ય સમુત્સૃજ્ય દાતુમ્ ઉદ્યતઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","તદ્વાર્ત્તાં શ્રુત્વા બર્ણબ્બાપૌલૌ સ્વીયવસ્ત્રાણિ છિત્વા લોકાનાં મધ્યં વેગેન પ્રવિશ્ય પ્રોચ્ચૈઃ કથિતવન્તૌ, ");
INSERT INTO sanguj_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","હે મહેચ્છાઃ કુત એતાદૃશં કર્મ્મ કુરુથ? આવામપિ યુષ્માદૃશૌ સુખદુઃખભોગિનૌ મનુષ્યૌ, યુયમ્ એતાઃ સર્વ્વા વૃથાકલ્પનાઃ પરિત્યજ્ય યથા ગગણવસુન્ધરાજલનિધીનાં તન્મધ્યસ્થાનાં સર્વ્વેષાઞ્ચ સ્રષ્ટારમમરમ્ ઈશ્વરં પ્રતિ પરાવર્ત્તધ્વે તદર્થમ્ આવાં યુષ્માકં સન્નિધૌ સુસંવાદં પ્રચારયાવઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","સ ઈશ્વરઃ પૂર્વ્વકાલે સર્વ્વદેશીયલોકાન્ સ્વસ્વમાર્ગે ચલિતુમનુમતિં દત્તવાન્, ");
INSERT INTO sanguj_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","તથાપિ આકાશાત્ તોયવર્ષણેન નાનાપ્રકારશસ્યોત્પત્યા ચ યુષ્માકં હિતૈષી સન્ ભક્ષ્યૈરાનનદેન ચ યુષ્માકમ્ અન્તઃકરણાનિ તર્પયન્ તાનિ દાનાનિ નિજસાક્ષિસ્વરૂપાણિ સ્થપિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","કિન્તુ તાદૃશાયાં કથાયાં કથિતાયામપિ તયોઃ સમીપ ઉત્સર્જનાત્ લોકનિવહં પ્રાયેણ નિવર્ત્તયિતું નાશક્નુતામ્| ");
INSERT INTO sanguj_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","આન્તિયખિયા-ઇકનિયનગરાભ્યાં કતિપયયિહૂદીયલોકા આગત્ય લોકાન્ પ્રાવર્ત્તયન્ત તસ્માત્ તૈ પૌલં પ્રસ્તરૈરાઘ્નન્ તેન સ મૃત ઇતિ વિજ્ઞાય નગરસ્ય બહિસ્તમ્ આકૃષ્ય નીતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","કિન્તુ શિષ્યગણે તસ્ય ચતુર્દિશિ તિષ્ઠતિ સતિ સ સ્વયમ્ ઉત્થાય પુનરપિ નગરમધ્યં પ્રાવિશત્ તત્પરેઽહનિ બર્ણબ્બાસહિતો દર્બ્બીનગરં ગતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","તત્ર સુસંવાદં પ્રચાર્ય્ય બહુલોકાન્ શિષ્યાન્ કૃત્વા તૌ લુસ્ત્રામ્ ઇકનિયમ્ આન્તિયખિયાઞ્ચ પરાવૃત્ય ગતૌ| ");
INSERT INTO sanguj_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","બહુદુઃખાનિ ભુક્ત્વાપીશ્વરરાજ્યં પ્રવેષ્ટવ્યમ્ ઇતિ કારણાદ્ ધર્મ્મમાર્ગે સ્થાતું વિનયં કૃત્વા શિષ્યગણસ્ય મનઃસ્થૈર્ય્યમ્ અકુરુતાં| ");
INSERT INTO sanguj_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","મણ્ડલીનાં પ્રાચીનવર્ગાન્ નિયુજ્ય પ્રાર્થનોપવાસૌ કૃત્વા યત્પ્રભૌ તે વ્યશ્વસન્ તસ્ય હસ્તે તાન્ સમર્પ્ય ");
INSERT INTO sanguj_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","પિસિદિયામધ્યેન પામ્ફુલિયાદેશં ગતવન્તૌ| ");
INSERT INTO sanguj_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","પશ્ચાત્ પર્ગાનગરં ગત્વા સુસંવાદં પ્રચાર્ય્ય અત્તાલિયાનગરં પ્રસ્થિતવન્તૌ| ");
INSERT INTO sanguj_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","તસ્માત્ સમુદ્રપથેન ગત્વા તાભ્યાં યત્ કર્મ્મ સમ્પન્નં તત્કર્મ્મ સાધયિતું યન્નગરે દયાલોરીશ્વરસ્ય હસ્તે સમર્પિતૌ જાતૌ તદ્ આન્તિયખિયાનગરં ગતવન્તા| ");
INSERT INTO sanguj_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","તત્રોપસ્થાય તન્નગરસ્થમણ્ડલીં સંગૃહ્ય સ્વાભ્યામ ઈશ્વરો યદ્યત્ કર્મ્મકરોત્ તથા યેન પ્રકારેણ ભિન્નદેશીયલોકાન્ પ્રતિ વિશ્વાસરૂપદ્વારમ્ અમોચયદ્ એતાન્ સર્વ્વવૃત્તાન્તાન્ તાન્ જ્ઞાપિતવન્તૌ| ");
INSERT INTO sanguj_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","તતસ્તૌ શિર્ય્યૈઃ સાર્દ્ધં તત્ર બહુદિનાનિ ન્યવસતામ્| ");
INSERT INTO sanguj_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","યિહૂદાદેશાત્ કિયન્તો જના આગત્ય ભ્રાતૃગણમિત્થં શિક્ષિતવન્તો મૂસાવ્યવસ્થયા યદિ યુષ્માકં ત્વક્છેદો ન ભવતિ તર્હિ યૂયં પરિત્રાણં પ્રાપ્તું ન શક્ષ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","પૌલબર્ણબ્બૌ તૈઃ સહ બહૂન્ વિચારાન્ વિવાદાંશ્ચ કૃતવન્તૌ, તતો મણ્ડલીયનોકા એતસ્યાઃ કથાયાસ્તત્ત્વં જ્ઞાતું યિરૂશાલમ્નગરસ્થાન્ પ્રેરિતાન્ પ્રાચીનાંશ્ચ પ્રતિ પૌલબર્ણબ્બાપ્રભૃતીન્ કતિપયજનાન્ પ્રેષયિતું નિશ્ચયં કૃતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","તે મણ્ડલ્યા પ્રેરિતાઃ સન્તઃ ફૈણીકીશોમિરોન્દેશાભ્યાં ગત્વા ભિન્નદેશીયાનાં મનઃપરિવર્ત્તનસ્ય વાર્ત્તયા ભ્રાતૃણાં પરમાહ્લાદમ્ અજનયન્| ");
INSERT INTO sanguj_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","યિરૂશાલમ્યુપસ્થાય પ્રેરિતગણેન લોકપ્રાચીનગણેન સમાજેન ચ સમુપગૃહીતાઃ સન્તઃ સ્વૈરીશ્વરો યાનિ કર્મ્માણિ કૃતવાન્ તેષાં સર્વ્વવૃત્તાન્તાન્ તેષાં સમક્ષમ્ અકથયન્| ");
INSERT INTO sanguj_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","કિન્તુ વિશ્વાસિનઃ કિયન્તઃ ફિરૂશિમતગ્રાહિણો લોકા ઉત્થાય કથામેતાં કથિતવન્તો ભિન્નદેશીયાનાં ત્વક્છેદં કર્ત્તું મૂસાવ્યવસ્થાં પાલયિતુઞ્ચ સમાદેષ્ટવ્યમ્| ");
INSERT INTO sanguj_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","તતઃ પ્રેરિતા લોકપ્રાચીનાશ્ચ તસ્ય વિવેચનાં કર્ત્તું સભાયાં સ્થિતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","બહુવિચારેષુ જાતષુ પિતર ઉત્થાય કથિતવાન્, હે ભ્રાતરો યથા ભિન્નદેશીયલોકા મમ મુખાત્ સુસંવાદં શ્રુત્વા વિશ્વસન્તિ તદર્થં બહુદિનાત્ પૂર્વ્વમ્ ઈશ્વરોસ્માકં મધ્યે માં વૃત્વા નિયુક્તવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","અન્તર્ય્યામીશ્વરો યથાસ્મભ્યં તથા ભિન્નદેશીયેભ્યઃ પવિત્રમાત્માનં પ્રદાય વિશ્વાસેન તેષામ્ અન્તઃકરણાનિ પવિત્રાણિ કૃત્વા ");
INSERT INTO sanguj_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","તેષામ્ અસ્માકઞ્ચ મધ્યે કિમપિ વિશેષં ન સ્થાપયિત્વા તાનધિ સ્વયં પ્રમાણં દત્તવાન્ ઇતિ યૂયં જાનીથ| ");
INSERT INTO sanguj_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","અતએવાસ્માકં પૂર્વ્વપુરુષા વયઞ્ચ સ્વયં યદ્યુગસ્ય ભારં સોઢું ન શક્તાઃ સમ્પ્રતિ તં શિષ્યગણસ્ય સ્કન્ધેષુ ન્યસિતું કુત ઈશ્વરસ્ય પરીક્ષાં કરિષ્યથ? ");
INSERT INTO sanguj_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","પ્રભો ર્યીશુખ્રીષ્ટસ્યાનુગ્રહેણ તે યથા વયમપિ તથા પરિત્રાણં પ્રાપ્તુમ્ આશાં કુર્મ્મઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","અનન્તરં બર્ણબ્બાપૌલાભ્યામ્ ઈશ્વરો ભિન્નદેશીયાનાં મધ્યે યદ્યદ્ આશ્ચર્ય્યમ્ અદ્ભુતઞ્ચ કર્મ્મ કૃતવાન્ તદ્વૃત્તાન્તં તૌ સ્વમુખાભ્યામ્ અવર્ણયતાં સભાસ્થાઃ સર્વ્વે નીરવાઃ સન્તઃ શ્રુતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","તયોઃ કથાયાં સમાપ્તાયાં સત્યાં યાકૂબ્ કથયિતુમ્ આરબ્ધવાન્ ");
INSERT INTO sanguj_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","હે ભ્રાતરો મમ કથાયામ્ મનો નિધત્ત| ઈશ્વરઃ સ્વનામાર્થં ભિન્નદેશીયલોકાનામ્ મધ્યાદ્ એકં લોકસંઘં ગ્રહીતું મતિં કૃત્વા યેન પ્રકારેણ પ્રથમં તાન્ પ્રતિ કૃપાવલેકનં કૃતવાન્ તં શિમોન્ વર્ણિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ભવિષ્યદ્વાદિભિરુક્તાનિ યાનિ વાક્યાનિ તૈઃ સાર્દ્ધમ્ એતસ્યૈક્યં ભવતિ યથા લિખિતમાસ્તે| ");
INSERT INTO sanguj_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","સર્વ્વેષાં કર્મ્મણાં યસ્તુ સાધકઃ પરમેશ્વરઃ| સ એવેદં વદેદ્વાક્યં શેષાઃ સકલમાનવાઃ| ભિન્નદેશીયલોકાશ્ચ યાવન્તો મમ નામતઃ| ભવન્તિ હિ સુવિખ્યાતાસ્તે યથા પરમેશિતુઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","તત્વં સમ્યક્ સમીહન્તે તન્નિમિત્તમહં કિલ| પરાવૃત્ય સમાગત્ય દાયૂદઃ પતિતં પુનઃ| દૂષ્યમુત્થાપયિષ્યામિ તદીયં સર્વ્વવસ્તુ ચ| પતિતં પુનરુથાપ્ય સજ્જયિષ્યામિ સર્વ્વથા|| ");
INSERT INTO sanguj_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","આ પ્રથમાદ્ ઈશ્વરઃ સ્વીયાનિ સર્વ્વકર્મ્માણિ જાનાતિ| ");
INSERT INTO sanguj_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","અતએવ મમ નિવેદનમિદં ભિન્નદેશીયલોકાનાં મધ્યે યે જના ઈશ્વરં પ્રતિ પરાવર્ત્તન્ત તેષામુપરિ અન્યં કમપિ ભારં ન ન્યસ્ય ");
INSERT INTO sanguj_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","દેવતાપ્રસાદાશુચિભક્ષ્યં વ્યભિચારકર્મ્મ કણ્ઠસમ્પીડનમારિતપ્રાણિભક્ષ્યં રક્તભક્ષ્યઞ્ચ એતાનિ પરિત્યક્તું લિખામઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","યતઃ પૂર્વ્વકાલતો મૂસાવ્યવસ્થાપ્રચારિણો લોકા નગરે નગરે સન્તિ પ્રતિવિશ્રામવારઞ્ચ ભજનભવને તસ્યાઃ પાઠો ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","તતઃ પરં પ્રેરિતગણો લોકપ્રાચીનગણઃ સર્વ્વા મણ્ડલી ચ સ્વેષાં મધ્યે બર્શબ્બા નામ્ના વિખ્યાતો મનોનીતૌ કૃત્વા પૌલબર્ણબ્બાભ્યાં સાર્દ્ધમ્ આન્તિયખિયાનગરં પ્રતિ પ્રેષણમ્ ઉચિતં બુદ્ધ્વા તાભ્યાં પત્રં પ્રૈષયન્| ");
INSERT INTO sanguj_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","તસ્મિન્ પત્રે લિખિતમિંદ, આન્તિયખિયા-સુરિયા-કિલિકિયાદેશસ્થભિન્નદેશીયભ્રાતૃગણાય પ્રેરિતગણસ્ય લોકપ્રાચીનગણસ્ય ભ્રાતૃગણસ્ય ચ નમસ્કારઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","વિશેષતોઽસ્માકમ્ આજ્ઞામ્ અપ્રાપ્યાપિ કિયન્તો જના અસ્માકં મધ્યાદ્ ગત્વા ત્વક્છેદો મૂસાવ્યવસ્થા ચ પાલયિતવ્યાવિતિ યુષ્માન્ શિક્ષયિત્વા યુષ્માકં મનસામસ્થૈર્ય્યં કૃત્વા યુષ્માન્ સસન્દેહાન્ અકુર્વ્વન્ એતાં કથાં વયમ્ અશૃન્મ| ");
INSERT INTO sanguj_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","તત્કારણાદ્ વયમ્ એકમન્ત્રણાઃ સન્તઃ સભાયાં સ્થિત્વા પ્રભો ર્યીશુખ્રીષ્ટસ્ય નામનિમિત્તં મૃત્યુમુખગતાભ્યામસ્માકં ");
INSERT INTO sanguj_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","પ્રિયબર્ણબ્બાપૌલાભ્યાં સાર્દ્ધં મનોનીતલોકાનાં કેષાઞ્ચિદ્ યુષ્માકં સન્નિધૌ પ્રેષણમ્ ઉચિતં બુદ્ધવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","અતો યિહૂદાસીલૌ યુષ્માન્ પ્રતિ પ્રેષિતવન્તઃ, એતયો ર્મુખાભ્યાં સર્વ્વાં કથાં જ્ઞાસ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","દેવતાપ્રસાદભક્ષ્યં રક્તભક્ષ્યં ગલપીડનમારિતપ્રાણિભક્ષ્યં વ્યભિચારકર્મ્મ ચેમાનિ સર્વ્વાણિ યુષ્માભિસ્ત્યાજ્યાનિ; એતત્પ્રયોજનીયાજ્ઞાવ્યતિરેકેન યુષ્માકમ્ ઉપરિ ભારમન્યં ન ન્યસિતું પવિત્રસ્યાત્મનોઽસ્માકઞ્ચ ઉચિતજ્ઞાનમ્ અભવત્| ");
INSERT INTO sanguj_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","અતએવ તેભ્યઃ સર્વ્વેભ્યઃ સ્વેષુ રક્ષિતેષુ યૂયં ભદ્રં કર્મ્મ કરિષ્યથ| યુષ્માકં મઙ્ગલં ભૂયાત્| ");
INSERT INTO sanguj_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","તેे વિસૃષ્ટાઃ સન્ત આન્તિયખિયાનગર ઉપસ્થાય લોકનિવહં સંગૃહ્ય પત્રમ્ અદદન્| ");
INSERT INTO sanguj_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","તતસ્તે તત્પત્રં પઠિત્વા સાન્ત્વનાં પ્રાપ્ય સાનન્દા અભવન્| ");
INSERT INTO sanguj_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","યિહૂદાસીલૌ ચ સ્વયં પ્રચારકૌ ભૂત્વા ભ્રાતૃગણં નાનોપદિશ્ય તાન્ સુસ્થિરાન્ અકુરુતામ્| ");
INSERT INTO sanguj_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ઇત્થં તૌ તત્ર તૈઃ સાકં કતિપયદિનાનિ યાપયિત્વા પશ્ચાત્ પ્રેરિતાનાં સમીપે પ્રત્યાગમનાર્થં તેષાં સન્નિધેઃ કલ્યાણેન વિસૃષ્ટાવભવતાં| ");
INSERT INTO sanguj_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","કિન્તુ સીલસ્તત્ર સ્થાતું વાઞ્છિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","અપરં પૌલબર્ણબ્બૌ બહવઃ શિષ્યાશ્ચ લોકાન્ ઉપદિશ્ય પ્રભોઃ સુસંવાદં પ્રચારયન્ત આન્તિયખિયાયાં કાલં યાપિતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","કતિપયદિનેષુ ગતેષુ પૌલો બર્ણબ્બામ્ અવદત્ આગચ્છાવાં યેષુ નગરેષ્વીશ્વરસ્ય સુસંવાદં પ્રચારિતવન્તૌ તાનિ સર્વ્વનગરાણિ પુનર્ગત્વા ભ્રાતરઃ કીદૃશાઃ સન્તીતિ દ્રષ્ટું તાન્ સાક્ષાત્ કુર્વ્વઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","તેન માર્કનામ્ના વિખ્યાતં યોહનં સઙ્ગિનં કર્ત્તું બર્ણબ્બા મતિમકરોત્, ");
INSERT INTO sanguj_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","કિન્તુ સ પૂર્વ્વં તાભ્યાં સહ કાર્ય્યાર્થં ન ગત્વા પામ્ફૂલિયાદેશે તૌ ત્યક્તવાન્ તત્કારણાત્ પૌલસ્તં સઙ્ગિનં કર્ત્તુમ્ અનુચિતં જ્ઞાતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ઇત્થં તયોરતિશયવિરોધસ્યોપસ્થિતત્વાત્ તૌ પરસ્પરં પૃથગભવતાં તતો બર્ણબ્બા માર્કં ગૃહીત્વા પોતેન કુપ્રોપદ્વીપં ગતવાન્; ");
INSERT INTO sanguj_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","કિન્તુ પૌલઃ સીલં મનોનીતં કૃત્વા ભ્રાતૃભિરીશ્વરાનુગ્રહે સમર્પિતઃ સન્ પ્રસ્થાય ");
INSERT INTO sanguj_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","સુરિયાકિલિકિયાદેશાભ્યાં મણ્ડલીઃ સ્થિરીકુર્વ્વન્ અગચ્છત્| ");
INSERT INTO sanguj_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","પૌલો દર્બ્બીલુસ્ત્રાનગરયોરુપસ્થિતોભવત્ તત્ર તીમથિયનામા શિષ્ય એક આસીત્; સ વિશ્વાસિન્યા યિહૂદીયાયા યોષિતો ગર્બ્ભજાતઃ કિન્તુ તસ્ય પિતાન્યદેશીયલોકઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","સ જનો લુસ્ત્રા-ઇકનિયનગરસ્થાનાં ભ્રાતૃણાં સમીપેપિ સુખ્યાતિમાન્ આસીત્| ");
INSERT INTO sanguj_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","પૌલસ્તં સ્વસઙ્ગિનં કર્ત્તું મતિં કૃત્વા તં ગૃહીત્વા તદ્દેશનિવાસિનાં યિહૂદીયાનામ્ અનુરોધાત્ તસ્ય ત્વક્છેદં કૃતવાન્ યતસ્તસ્ય પિતા ભિન્નદેશીયલોક ઇતિ સર્વ્વૈરજ્ઞાયત| ");
INSERT INTO sanguj_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","તતઃ પરં તે નગરે નગરે ભ્રમિત્વા યિરૂશાલમસ્થૈઃ પ્રેરિતૈ ર્લોકપ્રાચીનૈશ્ચ નિરૂપિતં યદ્ વ્યવસ્થાપત્રં તદનુસારેણાચરિતું લોકેભ્યસ્તદ્ દત્તવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","તેનૈવ સર્વ્વે ધર્મ્મસમાજાઃ ખ્રીષ્ટધર્મ્મે સુસ્થિરાઃ સન્તઃ પ્રતિદિનં વર્દ્ધિતા અભવન્| ");
INSERT INTO sanguj_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","તેષુ ફ્રુગિયાગાલાતિયાદેશમધ્યેન ગતેષુ સત્સુ પવિત્ર આત્મા તાન્ આશિયાદેશે કથાં પ્રકાશયિતું પ્રતિષિદ્ધવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","તથા મુસિયાદેશ ઉપસ્થાય બિથુનિયાં ગન્તું તૈરુદ્યોગે કૃતે આત્મા તાન્ નાન્વમન્યત| ");
INSERT INTO sanguj_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","તસ્માત્ તે મુસિયાદેશં પરિત્યજ્ય ત્રોયાનગરં ગત્વા સમુપસ્થિતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","રાત્રૌ પૌલઃ સ્વપ્ને દૃષ્ટવાન્ એકો માકિદનિયલોકસ્તિષ્ઠન્ વિનયં કૃત્વા તસ્મૈ કથયતિ, માકિદનિયાદેશમ્ આગત્યાસ્માન્ ઉપકુર્વ્વિતિ| ");
INSERT INTO sanguj_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","તસ્યેત્થં સ્વપ્નદર્શનાત્ પ્રભુસ્તદ્દેશીયલોકાન્ પ્રતિ સુસંવાદં પ્રચારયિતુમ્ અસ્માન્ આહૂયતીતિ નિશ્ચિતં બુદ્ધ્વા વયં તૂર્ણં માકિદનિયાદેશં ગન્તુમ્ ઉદ્યોગમ્ અકુર્મ્મ| ");
INSERT INTO sanguj_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","તતઃ પરં વયં ત્રોયાનગરાદ્ પ્રસ્થાય ઋજુમાર્ગેણ સામથ્રાકિયોપદ્વીપેન ગત્વા પરેઽહનિ નિયાપલિનગર ઉપસ્થિતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","તસ્માદ્ ગત્વા માકિદનિયાન્તર્વ્વર્ત્તિ રોમીયવસતિસ્થાનં યત્ ફિલિપીનામપ્રધાનનગરં તત્રોપસ્થાય કતિપયદિનાનિ તત્ર સ્થિતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","વિશ્રામવારે નગરાદ્ બહિ ર્ગત્વા નદીતટે યત્ર પ્રાર્થનાચાર આસીત્ તત્રોપવિશ્ય સમાગતા નારીઃ પ્રતિ કથાં પ્રાચારયામ| ");
INSERT INTO sanguj_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","તતઃ થુયાતીરાનગરીયા ધૂષરામ્બરવિક્રાયિણી લુદિયાનામિકા યા ઈશ્વરસેવિકા યોષિત્ શ્રોત્રીણાં મધ્ય આસીત્ તયા પૌલોક્તવાક્યાનિ યદ્ ગૃહ્યન્તે તદર્થં પ્રભુસ્તસ્યા મનોદ્વારં મુક્તવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","અતઃ સા યોષિત્ સપરિવારા મજ્જિતા સતી વિનયં કૃત્વા કથિતવતી, યુષ્માકં વિચારાદ્ યદિ પ્રભૌ વિશ્વાસિની જાતાહં તર્હિ મમ ગૃહમ્ આગત્ય તિષ્ઠત| ઇત્થં સા યત્નેનાસ્માન્ અસ્થાપયત્| ");
INSERT INTO sanguj_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","યસ્યા ગણનયા તદધિપતીનાં બહુધનોપાર્જનં જાતં તાદૃશી ગણકભૂતગ્રસ્તા કાચન દાસી પ્રાર્થનાસ્થાનગમનકાલ આગત્યાસ્માન્ સાક્ષાત્ કૃતવતી| ");
INSERT INTO sanguj_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","સાસ્માકં પૌલસ્ય ચ પશ્ચાદ્ એત્ય પ્રોચ્ચૈઃ કથામિમાં કથિતવતી, મનુષ્યા એતે સર્વ્વોપરિસ્થસ્યેશ્વરસ્ય સેવકાઃ સન્તોઽસ્માન્ પ્રતિ પરિત્રાણસ્ય માર્ગં પ્રકાશયન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","સા કન્યા બહુદિનાનિ તાદૃશમ્ અકરોત્ તસ્માત્ પૌલો દુઃખિતઃ સન્ મુખં પરાવર્ત્ય તં ભૂતમવદદ્, અહં યીશુખ્રીષ્ટસ્ય નામ્ના ત્વામાજ્ઞાપયામિ ત્વમસ્યા બહિર્ગચ્છ; તેનૈવ તત્ક્ષણાત્ સ ભૂતસ્તસ્યા બહિર્ગતઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","તતઃ સ્વેષાં લાભસ્ય પ્રત્યાશા વિફલા જાતેતિ વિલોક્ય તસ્યાઃ પ્રભવઃ પૌલં સીલઞ્ચ ધૃત્વાકૃષ્ય વિચારસ્થાનેઽધિપતીનાં સમીપમ્ આનયન્| ");
INSERT INTO sanguj_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","તતઃ શાસકાનાં નિકટં નીત્વા રોમિલોકા વયમ્ અસ્માકં યદ્ વ્યવહરણં ગ્રહીતુમ્ આચરિતુઞ્ચ નિષિદ્ધં, ");
INSERT INTO sanguj_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ઇમે યિહૂદીયલોકાઃ સન્તોપિ તદેવ શિક્ષયિત્વા નગરેઽસ્માકમ્ અતીવ કલહં કુર્વ્વન્તિ, ");
INSERT INTO sanguj_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","ઇતિ કથિતે સતિ લોકનિવહસ્તયોઃ પ્રાતિકૂલ્યેનોદતિષ્ઠત્ તથા શાસકાસ્તયો ર્વસ્ત્રાણિ છિત્વા વેત્રાઘાતં કર્ત્તુમ્ આજ્ઞાપયન્| ");
INSERT INTO sanguj_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","અપરં તે તૌ બહુ પ્રહાર્ય્ય ત્વમેતૌ કારાં નીત્વા સાવધાનં રક્ષયેતિ કારારક્ષકમ્ આદિશન્| ");
INSERT INTO sanguj_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ઇત્થમ્ આજ્ઞાં પ્રાપ્ય સ તાવભ્યન્તરસ્થકારાં નીત્વા પાદેષુ પાદપાશીભિ ર્બદ્ધ્વા સ્થાપિતાવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","અથ નિશીથસમયે પૌલસીલાવીશ્વરમુદ્દિશ્ય પ્રાથનાં ગાનઞ્ચ કૃતવન્તૌ, કારાસ્થિતા લોકાશ્ચ તદશૃણ્વન્ ");
INSERT INTO sanguj_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","તદાકસ્માત્ મહાન્ ભૂમિકમ્પોઽભવત્ તેન ભિત્તિમૂલેન સહ કારા કમ્પિતાભૂત્ તત્ક્ષણાત્ સર્વ્વાણિ દ્વારાણિ મુક્તાનિ જાતાનિ સર્વ્વેષાં બન્ધનાનિ ચ મુક્તાનિ| ");
INSERT INTO sanguj_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","અતએવ કારારક્ષકો નિદ્રાતો જાગરિત્વા કારાયા દ્વારાણિ મુક્તાનિ દૃષ્ટ્વા બન્દિલોકાઃ પલાયિતા ઇત્યનુમાય કોષાત્ ખઙ્ગં બહિઃ કૃત્વાત્મઘાતં કર્ત્તુમ્ ઉદ્યતઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","કિન્તુ પૌલઃ પ્રોચ્ચૈસ્તમાહૂય કથિતવાન્ પશ્ય વયં સર્વ્વેઽત્રાસ્મહે, ત્વં નિજપ્રાણહિંસાં માકાર્ષીઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","તદા પ્રદીપમ્ આનેતુમ્ ઉક્ત્વા સ કમ્પમાનઃ સન્ ઉલ્લમ્પ્યાભ્યન્તરમ્ આગત્ય પૌલસીલયોઃ પાદેષુ પતિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","પશ્ચાત્ સ તૌ બહિરાનીય પૃષ્ટવાન્ હે મહેચ્છૌ પરિત્રાણં પ્રાપ્તું મયા કિં કર્ત્તવ્યં? ");
INSERT INTO sanguj_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","પશ્ચાત્ તૌ સ્વગૃહમાનીય તયોઃ સમ્મુખે ખાદ્યદ્રવ્યાણિ સ્થાપિતવાન્ તથા સ સ્વયં તદીયાઃ સર્વ્વે પરિવારાશ્ચેશ્વરે વિશ્વસન્તઃ સાનન્દિતા અભવન્| ");
INSERT INTO sanguj_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","તસ્મૈ તસ્ય ગૃહસ્થિતસર્વ્વલોકેભ્યશ્ચ પ્રભોઃ કથાં કથિતવન્તૌ| ");
INSERT INTO sanguj_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","તથા રાત્રેસ્તસ્મિન્નેવ દણ્ડે સ તૌ ગૃહીત્વા તયોઃ પ્રહારાણાં ક્ષતાનિ પ્રક્ષાલિતવાન્ તતઃ સ સ્વયં તસ્ય સર્વ્વે પરિજનાશ્ચ મજ્જિતા અભવન્| ");
INSERT INTO sanguj_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","પશ્ચાત્ તૌ સ્વગૃહમાનીય તયોઃ સમ્મુખે ખાદ્યદ્રવ્યાણિ સ્થાપિતવાન્ તથા સ સ્વયં તદીયાઃ સર્વ્વે પરિવારાશ્ચેશ્વરે વિશ્વસન્તઃ સાનન્દિતા અભવન્| ");
INSERT INTO sanguj_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","દિન ઉપસ્થિતે તૌ લોકૌ મોચયેતિ કથાં કથયિતું શાસકાઃ પદાતિગણં પ્રેષિતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","તતઃ કારારક્ષકઃ પૌલાય તાં વાર્ત્તાં કથિતવાન્ યુવાં ત્યાજયિતું શાસકા લોકાન પ્રેષિતવન્ત ઇદાનીં યુવાં બહિ ર્ભૂત્વા કુશલેન પ્રતિષ્ઠેતાં| ");
INSERT INTO sanguj_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","કિન્તુ પૌલસ્તાન્ અવદત્ રોમિલોકયોરાવયોઃ કમપિ દોષમ્ ન નિશ્ચિત્ય સર્વ્વેષાં સમક્ષમ્ આવાં કશયા તાડયિત્વા કારાયાં બદ્ધવન્ત ઇદાનીં કિમાવાં ગુપ્તં વિસ્ત્રક્ષ્યન્તિ? તન્ન ભવિષ્યતિ, સ્વયમાગત્યાવાં બહિઃ કૃત્વા નયન્તુ| ");
INSERT INTO sanguj_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","તદા પદાતિભિઃ શાસકેભ્ય એતદ્વાર્ત્તાયાં કથિતાયાં તૌ રોમિલોકાવિતિ કથાં શ્રુત્વા તે ભીતાઃ ");
INSERT INTO sanguj_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","સન્તસ્તયોઃ સન્નિધિમાગત્ય વિનયમ્ અકુર્વ્વન્ અપરં બહિઃ કૃત્વા નગરાત્ પ્રસ્થાતું પ્રાર્થિતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","તતસ્તૌ કારાયા નિર્ગત્ય લુદિયાયા ગૃહં ગતવન્તૌ તત્ર ભ્રાતૃગણં સાક્ષાત્કૃત્ય તાન્ સાન્ત્વયિત્વા તસ્માત્ સ્થાનાત્ પ્રસ્થિતૌ| ");
INSERT INTO sanguj_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","પૌલસીલૌ આમ્ફિપલ્યાપલ્લોનિયાનગરાભ્યાં ગત્વા યત્ર યિહૂદીયાનાં ભજનભવનમેકમ્ આસ્તે તત્ર થિષલનીકીનગર ઉપસ્થિતૌ| ");
INSERT INTO sanguj_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","તદા પૌલઃ સ્વાચારાનુસારેણ તેષાં સમીપં ગત્વા વિશ્રામવારત્રયે તૈઃ સાર્દ્ધં ધર્મ્મપુસ્તકીયકથાયા વિચારં કૃતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ફલતઃ ખ્રીષ્ટેન દુઃખભોગઃ કર્ત્તવ્યઃ શ્મશાનદુત્થાનઞ્ચ કર્ત્તવ્યં યુષ્માકં સન્નિધૌ યસ્ય યીશોઃ પ્રસ્તાવં કરોમિ સ ઈશ્વરેણાભિષિક્તઃ સ એતાઃ કથાઃ પ્રકાશ્ય પ્રમાણં દત્વા સ્થિરીકૃતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","તસ્માત્ તેષાં કતિપયજના અન્યદેશીયા બહવો ભક્તલોકા બહ્યઃ પ્રધાનનાર્ય્યશ્ચ વિશ્વસ્ય પૌલસીલયોઃ પશ્ચાદ્ગામિનો જાતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","કિન્તુ વિશ્વાસહીના યિહૂદીયલોકા ઈર્ષ્યયા પરિપૂર્ણાઃ સન્તો હટટ્સ્ય કતિનયલમ્પટલોકાન્ સઙ્ગિનઃ કૃત્વા જનતયા નગરમધ્યે મહાકલહં કૃત્વા યાસોનો ગૃહમ્ આક્રમ્ય પ્રેરિતાન્ ધૃત્વા લોકનિવહસ્ય સમીપમ્ આનેતું ચેષ્ટિતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","તેષામુદ્દેશમ્ અપ્રાપ્ય ચ યાસોનં કતિપયાન્ ભ્રાતૃંશ્ચ ધૃત્વા નગરાધિપતીનાં નિકટમાનીય પ્રોચ્ચૈઃ કથિતવન્તો યે મનુષ્યા જગદુદ્વાટિતવન્તસ્તે ઽત્રાપ્યુપસ્થિતાઃ સન્તિ, ");
INSERT INTO sanguj_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","એષ યાસોન્ આતિથ્યં કૃત્વા તાન્ ગૃહીતવાન્| યીશુનામક એકો રાજસ્તીતિ કથયન્તસ્તે કૈસરસ્યાજ્ઞાવિરુદ્ધં કર્મ્મ કુર્વ્વતિ| ");
INSERT INTO sanguj_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","તેષાં કથામિમાં શ્રુત્વા લોકનિવહો નગરાધિપતયશ્ચ સમુદ્વિગ્ના અભવન્| ");
INSERT INTO sanguj_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","તદા યાસોનસ્તદન્યેષાઞ્ચ ધનદણ્ડં ગૃહીત્વા તાન્ પરિત્યક્તવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","તતઃ પરં ભ્રાતૃગણો રજન્યાં પૌલસીલૌ શીઘ્રં બિરયાનગરં પ્રેષિતવાન્ તૌ તત્રોપસ્થાય યિહૂદીયાનાં ભજનભવનં ગતવન્તૌ| ");
INSERT INTO sanguj_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","તત્રસ્થા લોકાઃ થિષલનીકીસ્થલોકેભ્યો મહાત્માન આસન્ યત ઇત્થં ભવતિ ન વેતિ જ્ઞાતું દિને દિને ધર્મ્મગ્રન્થસ્યાલોચનાં કૃત્વા સ્વૈરં કથામ્ અગૃહ્લન્| ");
INSERT INTO sanguj_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","તસ્માદ્ અનેકે યિહૂદીયા અન્યદેશીયાનાં માન્યા સ્ત્રિયઃ પુરુષાશ્ચાનેકે વ્યશ્વસન્| ");
INSERT INTO sanguj_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","કિન્તુ બિરયાનગરે પૌલેનેશ્વરીયા કથા પ્રચાર્ય્યત ઇતિ થિષલનીકીસ્થા યિહૂદીયા જ્ઞાત્વા તત્સ્થાનમપ્યાગત્ય લોકાનાં કુપ્રવૃત્તિમ્ અજનયન્| ");
INSERT INTO sanguj_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","અતએવ તસ્માત્ સ્થાનાત્ સમુદ્રેણ યાન્તીતિ દર્શયિત્વા ભ્રાતરઃ ક્ષિપ્રં પૌલં પ્રાહિણ્વન્ કિન્તુ સીલતીમથિયૌ તત્ર સ્થિતવન્તૌ| ");
INSERT INTO sanguj_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","તતઃ પરં પૌલસ્ય માર્ગદર્શકાસ્તમ્ આથીનીનગર ઉપસ્થાપયન્ પશ્ચાદ્ યુવાં તૂર્ણમ્ એતત્ સ્થાનં આગમિષ્યથઃ સીલતીમથિયૌ પ્રતીમામ્ આજ્ઞાં પ્રાપ્ય તે પ્રત્યાગતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","પૌલ આથીનીનગરે તાવપેક્ષ્ય તિષ્ઠન્ તન્નગરં પ્રતિમાભિઃ પરિપૂર્ણં દૃષ્ટ્વા સન્તપ્તહૃદયો ઽભવત્| ");
INSERT INTO sanguj_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","તતઃ સ ભજનભવને યાન્ યિહૂદીયાન્ ભક્તલોકાંશ્ચ હટ્ટે ચ યાન્ અપશ્યત્ તૈઃ સહ પ્રતિદિનં વિચારિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","કિન્ત્વિપિકૂરીયમતગ્રહિણઃ સ્તોયિકીયમતગ્રાહિણશ્ચ કિયન્તો જનાસ્તેન સાર્દ્ધં વ્યવદન્ત| તત્ર કેચિદ્ અકથયન્ એષ વાચાલઃ કિં વક્તુમ્ ઇચ્છતિ? અપરે કેચિદ્ એષ જનઃ કેષાઞ્ચિદ્ વિદેશીયદેવાનાં પ્રચારક ઇત્યનુમીયતે યતઃ સ યીશુમ્ ઉત્થિતિઞ્ચ પ્રચારયત્| ");
INSERT INTO sanguj_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","તે તમ્ અરેયપાગનામ વિચારસ્થાનમ્ આનીય પ્રાવોચન્ ઇદં યન્નવીનં મતં ત્વં પ્રાચીકશ ઇદં કીદૃશં એતદ્ અસ્માન્ શ્રાવય; ");
INSERT INTO sanguj_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","યામિમામ્ અસમ્ભવકથામ્ અસ્માકં કર્ણગોચરીકૃતવાન્ અસ્યા ભાવાર્થઃ ક ઇતિ વયં જ્ઞાતુમ્ ઇચ્છામઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","તદાથીનીનિવાસિનસ્તન્નગરપ્રવાસિનશ્ચ કેવલં કસ્યાશ્ચન નવીનકથાયાઃ શ્રવણેન પ્રચારણેન ચ કાલમ્ અયાપયન્| ");
INSERT INTO sanguj_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","પૌલોઽરેયપાગસ્ય મધ્યે તિષ્ઠન્ એતાં કથાં પ્રચારિતવાન્, હે આથીનીયલોકા યૂયં સર્વ્વથા દેવપૂજાયામ્ આસક્તા ઇત્યહ પ્રત્યક્ષં પશ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","યતઃ પર્ય્યટનકાલે યુષ્માકં પૂજનીયાનિ પશ્યન્ ‘અવિજ્ઞાતેશ્વરાય’ એતલ્લિપિયુક્તાં યજ્ઞવેદીમેકાં દૃષ્ટવાન્; અતો ન વિદિત્વા યં પૂજયધ્વે તસ્યૈવ તત્વં યુષ્માન્ પ્રતિ પ્રચારયામિ| ");
INSERT INTO sanguj_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","જગતો જગત્સ્થાનાં સર્વ્વવસ્તૂનાઞ્ચ સ્રષ્ટા ય ઈશ્વરઃ સ સ્વર્ગપૃથિવ્યોરેકાધિપતિઃ સન્ કરનિર્મ્મિતમન્દિરેષુ ન નિવસતિ; ");
INSERT INTO sanguj_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","સ એવ સર્વ્વેભ્યો જીવનં પ્રાણાન્ સર્વ્વસામગ્રીશ્ચ પ્રદદાતિ; અતએવ સ કસ્યાશ્ચિત્ સામગ્ય્રા અભાવહેતો ર્મનુષ્યાણાં હસ્તૈઃ સેવિતો ભવતીતિ ન| ");
INSERT INTO sanguj_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","સ ભૂમણ્ડલે નિવાસાર્થમ્ એકસ્માત્ શોણિતાત્ સર્વ્વાન્ મનુષ્યાન્ સૃષ્ટ્વા તેષાં પૂર્વ્વનિરૂપિતસમયં વસતિસીમાઞ્ચ નિરચિનોત્; ");
INSERT INTO sanguj_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","તસ્માત્ લોકૈઃ કેનાપિ પ્રકારેણ મૃગયિત્વા પરમેશ્વરસ્ય તત્વં પ્રાપ્તું તસ્ય ગવેષણં કરણીયમ્| ");
INSERT INTO sanguj_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","કિન્તુ સોઽસ્માકં કસ્માચ્ચિદપિ દૂરે તિષ્ઠતીતિ નહિ, વયં તેન નિશ્વસનપ્રશ્વસનગમનાગમનપ્રાણધારણાનિ કુર્મ્મઃ, પુुનશ્ચ યુષ્માકમેવ કતિપયાઃ કવયઃ કથયન્તિ ‘તસ્ય વંશા વયં સ્મો હિ’ ઇતિ| ");
INSERT INTO sanguj_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","અતએવ યદિ વયમ્ ઈશ્વરસ્ય વંશા ભવામસ્તર્હિ મનુષ્યૈ ર્વિદ્યયા કૌશલેન ચ તક્ષિતં સ્વર્ણં રૂપ્યં દૃષદ્ વૈતેષામીશ્વરત્વમ્ અસ્માભિ ર્ન જ્ઞાતવ્યં| ");
INSERT INTO sanguj_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","તેષાં પૂર્વ્વીયલોકાનામ્ અજ્ઞાનતાં પ્રતીશ્વરો યદ્યપિ નાવાધત્ત તથાપીદાનીં સર્વ્વત્ર સર્વ્વાન્ મનઃ પરિવર્ત્તયિતુમ્ આજ્ઞાપયતિ, ");
INSERT INTO sanguj_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","યતઃ સ્વનિયુક્તેન પુરુષેણ યદા સ પૃથિવીસ્થાનાં સર્વ્વલોકાનાં વિચારં કરિષ્યતિ તદ્દિનં ન્યરૂપયત્; તસ્ય શ્મશાનોત્થાપનેન તસ્મિન્ સર્વ્વેભ્યઃ પ્રમાણં પ્રાદાત્| ");
INSERT INTO sanguj_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","તદા શ્મશાનાદ્ ઉત્થાનસ્ય કથાં શ્રુત્વા કેચિદ્ ઉપાહમન્, કેચિદવદન્ એનાં કથાં પુનરપિ ત્વત્તઃ શ્રોષ્યામઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","તતઃ પૌલસ્તેષાં સમીપાત્ પ્રસ્થિाતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","તથાપિ કેચિલ્લોકાસ્તેન સાર્દ્ધં મિલિત્વા વ્યશ્વસન્ તેષાં મધ્યે ઽરેયપાગીયદિયનુસિયો દામારીનામા કાચિન્નારી કિયન્તો નરાશ્ચાસન્| ");
INSERT INTO sanguj_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","તદ્ઘટનાતઃ પરં પૌલ આથીનીનગરાદ્ યાત્રાં કૃત્વા કરિન્થનગરમ્ આગચ્છત્| ");
INSERT INTO sanguj_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","તસ્મિન્ સમયે ક્લૌદિયઃ સર્વ્વાન્ યિહૂદીયાન્ રોમાનગરં વિહાય ગન્તુમ્ આજ્ઞાપયત્, તસ્માત્ પ્રિસ્કિલ્લાનામ્ના જાયયા સાર્દ્ધમ્ ઇતાલિયાદેશાત્ કિઞ્ચિત્પૂર્વ્વમ્ આગમત્ યઃ પન્તદેશે જાત આક્કિલનામા યિહૂદીયલોકઃ પૌલસ્તં સાક્ષાત્ પ્રાપ્ય તયોઃ સમીપમિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","તૌ દૂષ્યનિર્મ્માણજીવિનૌ, તસ્માત્ પરસ્પરમ્ એકવૃત્તિકત્વાત્ સ તાભ્યાં સહ ઉષિત્વા તત્ કર્મ્માકરોત્| ");
INSERT INTO sanguj_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","પૌલઃ પ્રતિવિશ્રામવારં ભજનભવનં ગત્વા વિચારં કૃત્વા યિહૂદીયાન્ અન્યદેશીયાંશ્ચ પ્રવૃત્તિં ગ્રાહિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","સીલતીમથિયયો ર્માકિદનિયાદેશાત્ સમેતયોઃ સતોઃ પૌલ ઉત્તપ્તમના ભૂત્વા યીશુરીશ્વરેણાભિષિક્તો ભવતીતિ પ્રમાણં યિહૂદીયાનાં સમીપે પ્રાદાત્| ");
INSERT INTO sanguj_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","કિન્તુ તે ઽતીવ વિરોધં વિધાય પાષણ્ડીયકથાં કથિતવન્તસ્તતઃ પૌલો વસ્ત્રં ધુન્વન્ એતાં કથાં કથિતવાન્, યુષ્માકં શોણિતપાતાપરાધો યુષ્માન્ પ્રત્યેવ ભવતુ, તેનાહં નિરપરાધો ઽદ્યારભ્ય ભિન્નદેશીયાનાં સમીપં યામિ| ");
INSERT INTO sanguj_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","સ તસ્માત્ પ્રસ્થાય ભજનભવનસમીપસ્થસ્ય યુસ્તનામ્ન ઈશ્વરભક્તસ્ય ભિન્નદેશીયસ્ય નિવેશનં પ્રાવિશત્| ");
INSERT INTO sanguj_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","તતઃ ક્રીષ્પનામા ભજનભવનાધિપતિઃ સપરિવારઃ પ્રભૌ વ્યશ્વસીત્, કરિન્થનગરીયા બહવો લોકાશ્ચ સમાકર્ણ્ય વિશ્વસ્ય મજ્જિતા અભવન્| ");
INSERT INTO sanguj_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","ક્ષણદાયાં પ્રભુઃ પૌલં દર્શનં દત્વા ભાષિતવાન્, મા ભૈષીઃ, મા નિરસીઃ કથાં પ્રચારય| ");
INSERT INTO sanguj_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","અહં ત્વયા સાર્દ્ધમ્ આસ હિંસાર્થં કોપિ ત્વાં સ્પ્રષ્ટું ન શક્ષ્યતિ નગરેઽસ્મિન્ મદીયા લોકા બહવ આસતે| ");
INSERT INTO sanguj_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","તસ્માત્ પૌલસ્તન્નગરે પ્રાયેણ સાર્દ્ધવત્સરપર્ય્યન્તં સંસ્થાયેશ્વરસ્ય કથામ્ ઉપાદિશત્| ");
INSERT INTO sanguj_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","ગાલ્લિયનામા કશ્ચિદ્ આખાયાદેશસ્ય પ્રાડ્વિવાકઃ સમભવત્, તતો યિહૂદીયા એકવાક્યાઃ સન્તઃ પૌલમ્ આક્રમ્ય વિચારસ્થાનં નીત્વા ");
INSERT INTO sanguj_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","માનુષ એષ વ્યવસ્થાય વિરુદ્ધમ્ ઈશ્વરભજનં કર્ત્તું લોકાન્ કુપ્રવૃત્તિં ગ્રાહયતીતિ નિવેદિતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","તતઃ પૌલે પ્રત્યુત્તરં દાતુમ્ ઉદ્યતે સતિ ગાલ્લિયા યિહૂદીયાન્ વ્યાહરત્, યદિ કસ્યચિદ્ અન્યાયસ્ય વાતિશયદુષ્ટતાચરણસ્ય વિચારોઽભવિષ્યત્ તર્હિ યુષ્માકં કથા મયા સહનીયાભવિષ્યત્| ");
INSERT INTO sanguj_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","કિન્તુ યદિ કેવલં કથાયા વા નામ્નો વા યુષ્માકં વ્યવસ્થાયા વિવાદો ભવતિ તર્હિ તસ્ય વિચારમહં ન કરિષ્યામિ, યૂયં તસ્ય મીમાંસાં કુરુત| ");
INSERT INTO sanguj_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","તતઃ સ તાન્ વિચારસ્થાનાદ્ દૂરીકૃતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","તદા ભિન્નદેશીયાઃ સોસ્થિનિનામાનં ભજનભવનસ્ય પ્રધાનાધિપતિં ધૃત્વા વિચારસ્થાનસ્ય સમ્મુખે પ્રાહરન્ તથાપિ ગાલ્લિયા તેષુ સર્વ્વકર્મ્મસુ ન મનો ન્યદધાત્| ");
INSERT INTO sanguj_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","પૌલસ્તત્ર પુનર્બહુદિનાનિ ન્યવસત્, તતો ભ્રાતૃગણાદ્ વિસર્જનં પ્રાપ્ય કિઞ્ચનવ્રતનિમિત્તં કિંક્રિયાનગરે શિરો મુણ્ડયિત્વા પ્રિસ્કિલ્લાક્કિલાભ્યાં સહિતો જલપથેન સુરિયાદેશં ગતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","તત ઇફિષનગર ઉપસ્થાય તત્ર તૌ વિસૃજ્ય સ્વયં ભજનભ્વનં પ્રવિશ્ય યિહૂદીયૈઃ સહ વિચારિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","તે સ્વૈઃ સાર્દ્ધં પુનઃ કતિપયદિનાનિ સ્થાતું તં વ્યનયન્, સ તદનુરરીકૃત્ય કથામેતાં કથિતવાન્, ");
INSERT INTO sanguj_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","યિરૂશાલમિ આગામ્યુત્સવપાલનાર્થં મયા ગમનીયં; પશ્ચાદ્ ઈશ્વરેચ્છાયાં જાતાયાં યુષ્માકં સમીપં પ્રત્યાગમિષ્યામિ| તતઃ પરં સ તૈ ર્વિસૃષ્ટઃ સન્ જલપથેન ઇફિષનગરાત્ પ્રસ્થિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","તતઃ કૈસરિયામ્ ઉપસ્થિતઃ સન્ નગરં ગત્વા સમાજં નમસ્કૃત્ય તસ્માદ્ આન્તિયખિયાનગરં પ્રસ્થિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","તત્ર કિયત્કાલં યાપયિત્વા તસ્માત્ પ્રસ્થાય સર્વ્વેષાં શિષ્યાણાં મનાંસિ સુસ્થિરાણિ કૃત્વા ક્રમશો ગલાતિયાફ્રુગિયાદેશયો ર્ભ્રમિત્વા ગતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","તસ્મિન્નેવ સમયે સિકન્દરિયાનગરે જાત આપલ્લોનામા શાસ્ત્રવિત્ સુવક્તા યિહૂદીય એકો જન ઇફિષનગરમ્ આગતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","સ શિક્ષિતપ્રભુમાર્ગો મનસોદ્યોગી ચ સન્ યોહનો મજ્જનમાત્રં જ્ઞાત્વા યથાર્થતયા પ્રભોઃ કથાં કથયન્ સમુપાદિશત્| ");
INSERT INTO sanguj_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","એષ જનો નિર્ભયત્વેન ભજનભવને કથયિતુમ્ આરબ્ધવાન્, તતઃ પ્રિસ્કિલ્લાક્કિલૌ તસ્યોપદેશકથાં નિશમ્ય તં સ્વયોઃ સમીપમ્ આનીય શુદ્ધરૂપેણેશ્વરસ્ય કથામ્ અબોધયતામ્| ");
INSERT INTO sanguj_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","પશ્ચાત્ સ આખાયાદેશં ગન્તું મતિં કૃતવાન્, તદા તત્રત્યઃ શિષ્યગણો યથા તં ગૃહ્લાતિ તદર્થં ભ્રાતૃગણેન સમાશ્વસ્ય પત્રે લિખિતે સતિ, આપલ્લાસ્તત્રોપસ્થિતઃ સન્ અનુગ્રહેણ પ્રત્યયિનાં બહૂપકારાન્ અકરોત્, ");
INSERT INTO sanguj_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ફલતો યીશુરભિષિક્તસ્ત્રાતેતિ શાસ્ત્રપ્રમાણં દત્વા પ્રકાશરૂપેણ પ્રતિપન્નં કૃત્વા યિહૂદીયાન્ નિરુત્તરાન્ કૃતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","કરિન્થનગર આપલ્લસઃ સ્થિતિકાલે પૌલ ઉત્તરપ્રદેશૈરાગચ્છન્ ઇફિષનગરમ્ ઉપસ્થિતવાન્| તત્ર કતિપયશિષ્યાન્ સાક્ષત્ પ્રાપ્ય તાન્ અપૃચ્છત્, ");
INSERT INTO sanguj_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","યૂયં વિશ્વસ્ય પવિત્રમાત્માનં પ્રાપ્તા ન વા? તતસ્તે પ્રત્યવદન્ પવિત્ર આત્મા દીયતે ઇત્યસ્માભિઃ શ્રુતમપિ નહિ| ");
INSERT INTO sanguj_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","તદા સાઽવદત્ તર્હિ યૂયં કેન મજ્જિતા અભવત? તેઽકથયન્ યોહનો મજ્જનેન| ");
INSERT INTO sanguj_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","તદા પૌલ ઉક્તવાન્ ઇતઃ પરં ય ઉપસ્થાસ્યતિ તસ્મિન્ અર્થત યીશુખ્રીષ્ટે વિશ્વસિતવ્યમિત્યુક્ત્વા યોહન્ મનઃપરિવર્ત્તનસૂચકેન મજ્જનેન જલે લોકાન્ અમજ્જયત્| ");
INSERT INTO sanguj_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","તાદૃશીં કથાં શ્રુત્વા તે પ્રભો ર્યીશુખ્રીષ્ટસ્ય નામ્ના મજ્જિતા અભવન્| ");
INSERT INTO sanguj_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","તતઃ પૌલેન તેષાં ગાત્રેષુ કરેઽર્પિતે તેષામુપરિ પવિત્ર આત્માવરૂઢવાન્, તસ્માત્ તે નાનાદેશીયા ભાષા ભવિષ્યત્કથાશ્ચ કથિતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","તે પ્રાયેણ દ્વાદશજના આસન્| ");
INSERT INTO sanguj_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","પૌલો ભજનભવનં ગત્વા પ્રાયેણ માસત્રયમ્ ઈશ્વરસ્ય રાજ્યસ્ય વિચારં કૃત્વા લોકાન્ પ્રવર્ત્ય સાહસેન કથામકથયત્| ");
INSERT INTO sanguj_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","કિન્તુ કઠિનાન્તઃકરણત્વાત્ કિયન્તો જના ન વિશ્વસ્ય સર્વ્વેષાં સમક્ષમ્ એતત્પથસ્ય નિન્દાં કર્ત્તું પ્રવૃત્તાઃ, અતઃ પૌલસ્તેષાં સમીપાત્ પ્રસ્થાય શિષ્યગણં પૃથક્કૃત્વા પ્રત્યહં તુરાન્નનામ્નઃ કસ્યચિત્ જનસ્ય પાઠશાલાયાં વિચારં કૃતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ઇત્થં વત્સરદ્વયં ગતં તસ્માદ્ આશિયાદેશનિવાસિનઃ સર્વ્વે યિહૂદીયા અન્યદેશીયલોકાશ્ચ પ્રભો ર્યીશોઃ કથામ્ અશ્રૌષન્| ");
INSERT INTO sanguj_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","પૌલેન ચ ઈશ્વર એતાદૃશાન્યદ્ભુતાનિ કર્મ્માણિ કૃતવાન્ ");
INSERT INTO sanguj_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","યત્ પરિધેયે ગાત્રમાર્જનવસ્ત્રે વા તસ્ય દેહાત્ પીડિતલોકાનામ્ સમીપમ્ આનીતે તે નિરામયા જાતા અપવિત્રા ભૂતાશ્ચ તેભ્યો બહિર્ગતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","તદા દેશાટનકારિણઃ કિયન્તો યિહૂદીયા ભૂતાપસારિણો ભૂતગ્રસ્તનોકાનાં સન્નિધૌ પ્રભે ર્યીશો ર્નામ જપ્ત્વા વાક્યમિદમ્ અવદન્, યસ્ય કથાં પૌલઃ પ્રચારયતિ તસ્ય યીશો ર્નામ્ના યુષ્માન્ આજ્ઞાપયામઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","સ્કિવનામ્નો યિહૂદીયાનાં પ્રધાનયાજકસ્ય સપ્તભિઃ પુત્તૈસ્તથા કૃતે સતિ ");
INSERT INTO sanguj_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","કશ્ચિદ્ અપવિત્રો ભૂતઃ પ્રત્યુદિતવાન્, યીશું જાનામિ પૌલઞ્ચ પરિચિનોમિ કિન્તુ કે યૂયં? ");
INSERT INTO sanguj_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ઇત્યુક્ત્વા સોપવિત્રભૂતગ્રસ્તો મનુષ્યો લમ્ફં કૃત્વા તેષામુપરિ પતિત્વા બલેન તાન્ જિતવાન્, તસ્માત્તે નગ્નાઃ ક્ષતાઙ્ગાશ્ચ સન્તસ્તસ્માદ્ ગેહાત્ પલાયન્ત| ");
INSERT INTO sanguj_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","સા વાગ્ ઇફિષનગરનિવાસિનસં સર્વ્વેષાં યિહૂદીયાનાં ભિન્નદેશીયાનાં લોકાનાઞ્ચ શ્રવોગોચરીભૂતા; તતઃ સર્વ્વે ભયં ગતાઃ પ્રભો ર્યીશો ર્નામ્નો યશો ઽવર્દ્ધત| ");
INSERT INTO sanguj_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","યેષામનેકેષાં લોકાનાં પ્રતીતિરજાયત ત આગત્ય સ્વૈઃ કૃતાઃ ક્રિયાઃ પ્રકાશરૂપેણાઙ્ગીકૃતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","બહવો માયાકર્મ્મકારિણઃ સ્વસ્વગ્રન્થાન્ આનીય રાશીકૃત્ય સર્વ્વેષાં સમક્ષમ્ અદાહયન્, તતો ગણનાં કૃત્વાબુધ્યન્ત પઞ્ચાયુતરૂપ્યમુદ્રામૂલ્યપુસ્તકાનિ દગ્ધાનિ| ");
INSERT INTO sanguj_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ઇત્થં પ્રભોઃ કથા સર્વ્વદેશં વ્યાપ્ય પ્રબલા જાતા| ");
INSERT INTO sanguj_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","સર્વ્વેષ્વેતેષુ કર્મ્મસુ સમ્પન્નેષુ સત્સુ પૌલો માકિદનિયાખાયાદેશાભ્યાં યિરૂશાલમં ગન્તું મતિં કૃત્વા કથિતવાન્ તત્સ્થાનં યાત્રાયાં કૃતાયાં સત્યાં મયા રોમાનગરં દ્રષ્ટવ્યં| ");
INSERT INTO sanguj_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","સ્વાનુગતલોકાનાં તીમથિયેરાસ્તૌ દ્વૌ જનૌ માકિદનિયાદેશં પ્રતિ પ્રહિત્ય સ્વયમ્ આશિયાદેશે કતિપયદિનાનિ સ્થિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","કિન્તુ તસ્મિન્ સમયે મતેઽસ્મિન્ કલહો જાતઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","તત્કારણમિદં, અર્ત્તિમીદેવ્યા રૂપ્યમન્દિરનિર્મ્માણેન સર્વ્વેષાં શિલ્પિનાં યથેષ્ટલાભમ્ અજનયત્ યો દીમીત્રિયનામા નાડીન્ધમઃ ");
INSERT INTO sanguj_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","સ તાન્ તત્કર્મ્મજીવિનઃ સર્વ્વલોકાંશ્ચ સમાહૂય ભાષિતવાન્ હે મહેચ્છા એતેન મન્દિરનિર્મ્માણેનાસ્માકં જીવિકા ભવતિ, એતદ્ યૂયં વિત્થ; ");
INSERT INTO sanguj_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","કિન્તુ હસ્તનિર્મ્મિતેશ્વરા ઈશ્વરા નહિ પૌલનામ્ના કેનચિજ્જનેન કથામિમાં વ્યાહૃત્ય કેવલેફિષનગરે નહિ પ્રાયેણ સર્વ્વસ્મિન્ આશિયાદેશે પ્રવૃત્તિં ગ્રાહયિત્વા બહુલોકાનાં શેમુષી પરાવર્ત્તિતા, એતદ્ યુષ્માભિ ર્દૃશ્યતે શ્રૂયતે ચ| ");
INSERT INTO sanguj_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","તેનાસ્માકં વાણિજ્યસ્ય સર્વ્વથા હાનેઃ સમ્ભવનં કેવલમિતિ નહિ, આશિયાદેશસ્થૈ ર્વા સર્વ્વજગત્સ્થૈ ર્લોકૈઃ પૂજ્યા યાર્તિમી મહાદેવી તસ્યા મન્દિરસ્યાવજ્ઞાનસ્ય તસ્યા ઐશ્વર્ય્યસ્ય નાશસ્ય ચ સમ્ભાવના વિદ્યતેे| ");
INSERT INTO sanguj_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","એતાદૃશીં કથાં શ્રુત્વા તે મહાક્રોધાન્વિતાઃ સન્ત ઉચ્ચૈઃકારં કથિતવન્ત ઇફિષીયાનામ્ અર્ત્તિમી દેવી મહતી ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","તતઃ સર્વ્વનગરં કલહેન પરિપૂર્ણમભવત્, તતઃ પરં તે માકિદનીયગાયારિસ્તાર્ખનામાનૌ પૌલસ્ય દ્વૌ સહચરૌ ધૃત્વૈકચિત્તા રઙ્ગભૂમિં જવેન ધાવિતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","તતઃ પૌલો લોકાનાં સન્નિધિં યાતુમ્ ઉદ્યતવાન્ કિન્તુ શિષ્યગણસ્તં વારિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","પૌલસ્યત્મીયા આશિયાદેશસ્થાઃ કતિપયાઃ પ્રધાનલોકાસ્તસ્ય સમીપં નરમેકં પ્રેષ્ય ત્વં રઙ્ગભૂમિં માગા ઇતિ ન્યવેદયન્| ");
INSERT INTO sanguj_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","તતો નાનાલોકાનાં નાનાકથાકથનાત્ સભા વ્યાકુલા જાતા કિં કારણાદ્ એતાવતી જનતાભવત્ એતદ્ અધિકૈ ર્લોકૈ ર્નાજ્ઞાયિ| ");
INSERT INTO sanguj_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","તતઃ પરં જનતામધ્યાદ્ યિહૂદીયૈર્બહિષ્કૃતઃ સિકન્દરો હસ્તેન સઙ્કેતં કૃત્વા લોકેભ્ય ઉત્તરં દાતુમુદ્યતવાન્, ");
INSERT INTO sanguj_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","કિન્તુ સ યિહૂદીયલોક ઇતિ નિશ્ચિતે સતિ ઇફિષીયાનામ્ અર્ત્તિમી દેવી મહતીતિ વાક્યં પ્રાયેણ પઞ્ચ દણ્ડાન્ યાવદ્ એકસ્વરેણ લોકનિવહૈઃ પ્રોક્તં| ");
INSERT INTO sanguj_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","તતો નગરાધિપતિસ્તાન્ સ્થિરાન્ કૃત્વા કથિતવાન્ હે ઇફિષાયાઃ સર્વ્વે લોકા આકર્ણયત, અર્તિમીમહાદેવ્યા મહાદેવાત્ પતિતાયાસ્તત્પ્રતિમાયાશ્ચ પૂજનમ ઇફિષનગરસ્થાઃ સર્વ્વે લોકાઃ કુર્વ્વન્તિ, એતત્ કે ન જાનન્તિ? ");
INSERT INTO sanguj_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","તસ્માદ્ એતત્પ્રતિકૂલં કેપિ કથયિતું ન શક્નુવન્તિ, ઇતિ જ્ઞાત્વા યુષ્માભિઃ સુસ્થિરત્વેન સ્થાતવ્યમ્ અવિવિચ્ય કિમપિ કર્મ્મ ન કર્ત્તવ્યઞ્ચ| ");
INSERT INTO sanguj_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","યાન્ એતાન્ મનુષ્યાન્ યૂયમત્ર સમાનયત તે મન્દિરદ્રવ્યાપહારકા યુષ્માકં દેવ્યા નિન્દકાશ્ચ ન ભવન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","યદિ કઞ્ચન પ્રતિ દીમીત્રિયસ્ય તસ્ય સહાયાનાઞ્ચ કાચિદ્ આપત્તિ ર્વિદ્યતે તર્હિ પ્રતિનિધિલોકા વિચારસ્થાનઞ્ચ સન્તિ, તે તત્ સ્થાનં ગત્વા ઉત્તરપ્રત્યુત્તરે કુર્વ્વન્તુ| ");
INSERT INTO sanguj_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","કિન્તુ યુષ્માકં કાચિદપરા કથા યદિ તિષ્ઠતિ તર્હિ નિયમિતાયાં સભાયાં તસ્યા નિષ્પત્તિ ર્ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","કિન્ત્વેતસ્ય વિરોધસ્યોત્તરં યેન દાતું શક્નુમ્ એતાદૃશસ્ય કસ્યચિત્ કારણસ્યાભાવાદ્ અદ્યતનઘટનાહેતો રાજદ્રોહિણામિવાસ્માકમ્ અભિયોગો ભવિષ્યતીતિ શઙ્કા વિદ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","ઇતિ કથયિત્વા સ સભાસ્થલોકાન્ વિસૃષ્ટવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ઇત્થં કલહે નિવૃત્તે સતિ પૌલઃ શિષ્યગણમ્ આહૂય વિસર્જનં પ્રાપ્ય માકિદનિયાદેશં પ્રસ્થિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","તેન સ્થાનેન ગચ્છન્ તદ્દેશીયાન્ શિષ્યાન્ બહૂપદિશ્ય યૂનાનીયદેશમ્ ઉપસ્થિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","તત્ર માસત્રયં સ્થિત્વા તસ્માત્ સુરિયાદેશં યાતુમ્ ઉદ્યતઃ, કિન્તુ યિહૂદીયાસ્તં હન્તું ગુપ્તા અતિષ્ઠન્ તસ્માત્ સ પુનરપિ માકિદનિયામાર્ગેણ પ્રત્યાગન્તું મતિં કૃતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","બિરયાનગરીયસોપાત્રઃ થિષલનીકીયારિસ્તાર્ખસિકુન્દૌ દર્બ્બોનગરીયગાયતીમથિયૌ આશિયાદેશીયતુખિકત્રફિમૌ ચ તેન સાર્દ્ધં આશિયાદેશં યાવદ્ ગતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","એતે સર્વ્વે ઽગ્રસરાઃ સન્તો ઽસ્માન્ અપેક્ષ્ય ત્રોયાનગરે સ્થિતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","કિણ્વશૂન્યપૂપોત્સવદિને ચ ગતે સતિ વયં ફિલિપીનગરાત્ તોયપથેન ગત્વા પઞ્ચભિ ર્દિનૈસ્ત્રોયાનગરમ્ ઉપસ્થાય તત્ર સપ્તદિનાન્યવાતિષ્ઠામ| ");
INSERT INTO sanguj_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","સપ્તાહસ્ય પ્રથમદિને પૂપાન્ ભંક્તુ શિષ્યેષુ મિલિતેષુ પૌલઃ પરદિને તસ્માત્ પ્રસ્થાતુમ્ ઉદ્યતઃ સન્ તદહ્નિ પ્રાયેણ ક્ષપાયા યામદ્વયં યાવત્ શિષ્યેભ્યો ધર્મ્મકથામ્ અકથયત્| ");
INSERT INTO sanguj_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ઉપરિસ્થે યસ્મિન્ પ્રકોષ્ઠે સભાં કૃત્વાસન્ તત્ર બહવઃ પ્રદીપાઃ પ્રાજ્વલન્| ");
INSERT INTO sanguj_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ઉતુખનામા કશ્ચન યુવા ચ વાતાયન ઉપવિશન્ ઘોરતરનિદ્રાગ્રસ્તો ઽભૂત્ તદા પૌલેન બહુક્ષણં કથાયાં પ્રચારિતાયાં નિદ્રામગ્નઃ સ તસ્માદ્ ઉપરિસ્થતૃતીયપ્રકોષ્ઠાદ્ અપતત્, તતો લોકાસ્તં મૃતકલ્પં ધૃત્વોદતોલયન્| ");
INSERT INTO sanguj_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","તતઃ પૌલોઽવરુહ્ય તસ્ય ગાત્રે પતિત્વા તં ક્રોડે નિધાય કથિતવાન્, યૂયં વ્યાકુલા મા ભૂત નાયં પ્રાણૈ ર્વિયુક્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","પશ્ચાત્ સ પુનશ્ચોપરિ ગત્વા પૂપાન્ ભંક્ત્વા પ્રભાતં યાવત્ કથોપકથને કૃત્વા પ્રસ્થિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","તે ચ તં જીવન્તં યુવાનં ગૃહીત્વા ગત્વા પરમાપ્યાયિતા જાતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","અનન્તરં વયં પોતેનાગ્રસરા ભૂત્વાસ્મનગરમ્ ઉત્તીર્ય્ય પૌલં ગ્રહીતું મતિમ્ અકુર્મ્મ યતઃ સ તત્ર પદ્ભ્યાં વ્રજિતું મતિં કૃત્વેતિ નિરૂપિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","તસ્માત્ તત્રાસ્માભિઃ સાર્દ્ધં તસ્મિન્ મિલિતે સતિ વયં તં નીત્વા મિતુલીન્યુપદ્વીપં પ્રાપ્તવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","તસ્માત્ પોતં મોચયિત્વા પરેઽહનિ ખીયોપદ્વીપસ્ય સમ્મુખં લબ્ધવન્તસ્તસ્માદ્ એકેનાહ્ના સામોપદ્વીપં ગત્વા પોતં લાગયિત્વા ત્રોગુલ્લિયે સ્થિત્વા પરસ્મિન્ દિવસેे મિલીતનગરમ્ ઉપાતિષ્ઠામ| ");
INSERT INTO sanguj_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","યતઃ પૌલ આશિયાદેશે કાલં યાપયિતુમ્ નાભિલષન્ ઇફિષનગરં ત્યક્ત્વા યાતું મન્ત્રણાં સ્થિરીકૃતવાન્; યસ્માદ્ યદિ સાધ્યં ભવતિ તર્હિ નિસ્તારોત્સવસ્ય પઞ્ચાશત્તમદિને સ યિરૂશાલમ્યુપસ્થાતું મતિં કૃતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","પૌલો મિલીતાદ્ ઇફિષં પ્રતિ લોકં પ્રહિત્ય સમાજસ્ય પ્રાચીનાન્ આહૂયાનીતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","તેષુ તસ્ય સમીપમ્ ઉપસ્થિતેષુ સ તેભ્ય ઇમાં કથાં કથિતવાન્, અહમ્ આશિયાદેશે પ્રથમાગમનમ્ આરભ્યાદ્ય યાવદ્ યુષ્માકં સન્નિધૌ સ્થિત્વા સર્વ્વસમયે યથાચરિતવાન્ તદ્ યૂયં જાનીથ; ");
INSERT INTO sanguj_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ફલતઃ સર્વ્વથા નમ્રમનાઃ સન્ બહુશ્રુપાતેન યિહુદીયાનામ્ કુમન્ત્રણાજાતનાનાપરીક્ષાભિઃ પ્રભોઃ સેવામકરવં| ");
INSERT INTO sanguj_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","કામપિ હિતકથાाં ન ગોપાયિતવાન્ તાં પ્રચાર્ય્ય સપ્રકાશં ગૃહે ગૃહે સમુપદિશ્યેશ્વરં પ્રતિ મનઃ પરાવર્ત્તનીયં પ્રભૌ યીશુખ્રીષ્ટે વિશ્વસનીયં ");
INSERT INTO sanguj_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","યિહૂદીયાનામ્ અન્યદેશીયલોકાનાઞ્ચ સમીપ એતાદૃશં સાક્ષ્યં દદામિ| ");
INSERT INTO sanguj_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","પશ્યત સામ્પ્રતમ્ આત્મનાકૃષ્ટઃ સન્ યિરૂશાલમ્નગરે યાત્રાં કરોમિ, તત્ર મામ્પ્રતિ યદ્યદ્ ઘટિષ્યતે તાન્યહં ન જાનામિ; ");
INSERT INTO sanguj_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","કિન્તુ મયા બન્ધનં ક્લેશશ્ચ ભોક્તવ્ય ઇતિ પવિત્ર આત્મા નગરે નગરે પ્રમાણં દદાતિ| ");
INSERT INTO sanguj_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","તથાપિ તં ક્લેશમહં તૃણાય ન મન્યે; ઈશ્વરસ્યાનુગ્રહવિષયકસ્ય સુસંવાદસ્ય પ્રમાણં દાતું, પ્રભો ર્યીશોઃ સકાશાદ યસ્યાઃ સેવાયાઃ ભારં પ્રાપ્નવં તાં સેવાં સાધયિતું સાનન્દં સ્વમાર્ગં સમાપયિતુुઞ્ચ નિજપ્રાણાનપિ પ્રિયાન્ ન મન્યે| ");
INSERT INTO sanguj_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","અધુના પશ્યત યેષાં સમીપેઽહમ્ ઈશ્વરીયરાજ્યસ્ય સુસંવાદં પ્રચાર્ય્ય ભ્રમણં કૃતવાન્ એતાદૃશા યૂયં મમ વદનં પુન ર્દ્રષ્ટું ન પ્રાપ્સ્યથ એતદપ્યહં જાનામિ| ");
INSERT INTO sanguj_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","યુષ્મભ્યમ્ અહમ્ ઈશ્વરસ્ય સર્વ્વાન્ આદેશાન્ પ્રકાશયિતું ન ન્યવર્ત્તે| ");
INSERT INTO sanguj_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","અહં સર્વ્વેષાં લોકાનાં રક્તપાતદોષાદ્ યન્નિર્દોષ આસે તસ્યાદ્ય યુષ્માન્ સાક્ષિણઃ કરોમિ| ");
INSERT INTO sanguj_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","યૂયં સ્વેષુ તથા યસ્ય વ્રજસ્યાધ્યક્ષન્ આત્મા યુષ્માન્ વિધાય ન્યયુઙ્ક્ત તત્સર્વ્વસ્મિન્ સાવધાના ભવત, ય સમાજઞ્ચ પ્રભુ ર્નિજરક્તમૂલ્યેન ક્રીતવાન તમ્ અવત, ");
INSERT INTO sanguj_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","યતો મયા ગમને કૃતએવ દુર્જયા વૃકા યુષ્માકં મધ્યં પ્રવિશ્ય વ્રજં પ્રતિ નિર્દયતામ્ આચરિષ્યન્તિ, ");
INSERT INTO sanguj_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","યુષ્માકમેવ મધ્યાદપિ લોકા ઉત્થાય શિષ્યગણમ્ અપહન્તું વિપરીતમ્ ઉપદેક્ષ્યન્તીત્યહં જાનામિ| ");
INSERT INTO sanguj_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","ઇતિ હેતો ર્યૂયં સચૈતન્યાઃ સન્તસ્તિષ્ટત, અહઞ્ચ સાશ્રુપાતઃ સન્ વત્સરત્રયં યાવદ્ દિવાનિશં પ્રતિજનં બોધયિતું ન ન્યવર્ત્તે તદપિ સ્મરત| ");
INSERT INTO sanguj_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","ઇદાનીં હે ભ્રાતરો યુષ્માકં નિષ્ઠાં જનયિતું પવિત્રીકૃતલોકાનાં મધ્યેઽધિકારઞ્ચ દાતું સમર્થો ય ઈશ્વરસ્તસ્યાનુગ્રહસ્ય યો વાદશ્ચ તયોરુભયો ર્યુષ્માન્ સમાર્પયમ્| ");
INSERT INTO sanguj_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","કસ્યાપિ સ્વર્ણં રૂપ્યં વસ્ત્રં વા પ્રતિ મયા લોભો ન કૃતઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","કિન્તુ મમ મત્સહચરલોકાનાઞ્ચાવશ્યકવ્યયાય મદીયમિદં કરદ્વયમ્ અશ્રામ્યદ્ એતદ્ યૂયં જાનીથ| ");
INSERT INTO sanguj_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","અનેન પ્રકારેણ ગ્રહણદ્ દાનં ભદ્રમિતિ યદ્વાક્યં પ્રભુ ર્યીશુઃ કથિતવાન્ તત્ સ્મર્ત્તું દરિદ્રલોકાનામુપકારાર્થં શ્રમં કર્ત્તુઞ્ચ યુષ્માકમ્ ઉચિતમ્ એતત્સર્વ્વં યુષ્માનહમ્ ઉપદિષ્ટવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","એતાં કથાં કથયિત્વા સ જાનુની પાતયિત્વા સર્વૈઃ સહ પ્રાર્થયત| ");
INSERT INTO sanguj_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","તેન તે ક્રન્દ્રન્તઃ ");
INSERT INTO sanguj_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","પુન ર્મમ મુખં ન દ્રક્ષ્યથ વિશેષત એષા યા કથા તેનાકથિ તત્કારણાત્ શોકં વિલાપઞ્ચ કૃત્વા કણ્ઠં ધૃત્વા ચુમ્બિતવન્તઃ| પશ્ચાત્ તે તં પોતં નીતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","તૈ ર્વિસૃષ્ટાઃ સન્તો વયં પોતં બાહયિત્વા ઋજુમાર્ગેણ કોષમ્ ઉપદ્વીપમ્ આગત્ય પરેઽહનિ રોદિયોપદ્વીપમ્ આગચ્છામ તતસ્તસ્માત્ પાતારાયામ્ ઉપાતિષ્ઠામ| ");
INSERT INTO sanguj_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","તત્ર ફૈનીકિયાદેશગામિનમ્ પોતમેકં પ્રાપ્ય તમારુહ્ય ગતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","કુપ્રોપદ્વીપં દૃષ્ટ્વા તં સવ્યદિશિ સ્થાપયિત્વા સુરિયાદેશં ગત્વા પોતસ્થદ્રવ્યાણ્યવરોહયિતું સોરનગરે લાગિતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","તત્ર શિષ્યગણસ્ય સાક્ષાત્કરણાય વયં તત્ર સપ્તદિનાનિ સ્થિતવન્તઃ પશ્ચાત્તે પવિત્રેણાત્મના પૌલં વ્યાહરન્ ત્વં યિરૂશાલમ્નગરં મા ગમઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","તતસ્તેષુ સપ્તસુ દિનેષુ યાપિતેષુ સત્સુ વયં તસ્માત્ સ્થાનાત્ નિજવર્ત્મના ગતવન્તઃ, તસ્માત્ તે સબાલવૃદ્ધવનિતા અસ્માભિઃ સહ નગરસ્ય પરિસરપર્ય્યન્તમ્ આગતાઃ પશ્ચાદ્વયં જલધિતટે જાનુપાતં પ્રાર્થયામહિ| ");
INSERT INTO sanguj_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","તતઃ પરસ્પરં વિસૃષ્ટાઃ સન્તો વયં પોતં ગતાસ્તે તુ સ્વસ્વગૃહં પ્રત્યાગતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","વયં સોરનગરાત્ નાવા પ્રસ્થાય તલિમાયિનગરમ્ ઉપાતિષ્ઠામ તત્રાસ્માકં સમુદ્રીયમાર્ગસ્યાન્તોઽભવત્ તત્ર ભ્રાતૃગણં નમસ્કૃત્ય દિનમેકં તૈઃ સાર્દ્ધમ્ ઉષતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","પરે ઽહનિ પૌલસ્તસ્ય સઙ્ગિનો વયઞ્ચ પ્રતિષ્ઠમાનાઃ કૈસરિયાનગરમ્ આગત્ય સુસંવાદપ્રચારકાનાં સપ્તજનાનાં ફિલિપનામ્ન એકસ્ય ગૃહં પ્રવિશ્યાવતિષ્ઠામ| ");
INSERT INTO sanguj_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","તસ્ય ચતસ્રો દુહિતરોઽનૂઢા ભવિષ્યદ્વાદિન્ય આસન્| ");
INSERT INTO sanguj_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","તત્રાસ્માસુ બહુદિનાનિ પ્રોષિતેષુ યિહૂદીયદેશાદ્ આગત્યાગાબનામા ભવિષ્યદ્વાદી સમુપસ્થિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","સોસ્માકં સમીપમેત્ય પૌલસ્ય કટિબન્ધનં ગૃહીત્વા નિજહસ્તાપાદાન્ બદ્ધ્વા ભાષિતવાન્ યસ્યેદં કટિબન્ધનં તં યિહૂદીયલોકા યિરૂશાલમનગર ઇત્થં બદ્ધ્વા ભિન્નદેશીયાનાં કરેષુ સમર્પયિષ્યન્તીતિ વાક્યં પવિત્ર આત્મા કથયતિ| ");
INSERT INTO sanguj_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","એતાદૃશીં કથાં શ્રુત્વા વયં તન્નગરવાસિનો ભ્રાતરશ્ચ યિરૂશાલમં ન યાતું પૌલં વ્યનયામહિ; ");
INSERT INTO sanguj_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","કિન્તુ સ પ્રત્યાવાદીત્, યૂયં કિં કુરુથ? કિં ક્રન્દનેન મમાન્તઃકરણં વિદીર્ણં કરિષ્યથ? પ્રભો ર્યીશો ર્નામ્નો નિમિત્તં યિરૂશાલમિ બદ્ધો ભવિતું કેવલ તન્ન પ્રાણાન્ દાતુમપિ સસજ્જોસ્મિ| ");
INSERT INTO sanguj_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","તેનાસ્માકં કથાયામ્ અગૃહીતાયામ્ ઈશ્વરસ્ય યથેચ્છા તથૈવ ભવત્વિત્યુક્ત્વા વયં નિરસ્યામ| ");
INSERT INTO sanguj_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","પરેઽહનિ પાથેયદ્રવ્યાણિ ગૃહીત્વા યિરૂશાલમં પ્રતિ યાત્રામ્ અકુર્મ્મ| ");
INSERT INTO sanguj_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","તતઃ કૈસરિયાનગરનિવાસિનઃ કતિપયાઃ શિષ્યા અસ્માભિઃ સાર્દ્ધમ્ ઇત્વા કૃપ્રીયેન મ્નાસન્નામ્ના યેન પ્રાચીનશિષ્યેન સાર્દ્ધમ્ અસ્માભિ ર્વસ્તવ્યં તસ્ય સમીપમ્ અસ્માન્ નીતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","અસ્માસુ યિરૂશાલમ્યુપસ્થિતેષુ તત્રસ્થભ્રાતૃગણોઽસ્માન્ આહ્લાદેન ગૃહીતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","પરસ્મિન્ દિવસે પૌલેઽસ્માભિઃ સહ યાકૂબો ગૃહં પ્રવિષ્ટે લોકપ્રાચીનાઃ સર્વ્વે તત્ર પરિષદિ સંસ્થિતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","અનન્તરં સ તાન્ નત્વા સ્વીયપ્રચારણેન ભિન્નદેશીયાન્ પ્રતીશ્વરો યાનિ કર્મ્માણિ સાધિતવાન્ તદીયાં કથામ્ અનુક્રમાત્ કથિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ઇતિ શ્રુત્વા તે પ્રભું ધન્યં પ્રોચ્ય વાક્યમિદમ્ અભાષન્ત, હે ભ્રાત ર્યિહૂદીયાનાં મધ્યે બહુસહસ્રાણિ લોકા વિશ્વાસિન આસતે કિન્તુ તે સર્વ્વે વ્યવસ્થામતાચારિણ એતત્ પ્રત્યક્ષં પશ્યસિ| ");
INSERT INTO sanguj_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","શિશૂનાં ત્વક્છેદનાદ્યાચરણં પ્રતિષિધ્ય ત્વં ભિન્નદેશનિવાસિનો યિહૂદીયલોકાન્ મૂસાવાક્યમ્ અશ્રદ્ધાતુમ્ ઉપદિશસીતિ તૈઃ શ્રુતમસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","ત્વમત્રાગતોસીતિ વાર્ત્તાં સમાકર્ણ્ય જનનિવહો મિલિત્વાવશ્યમેવાગમિષ્યતિ; અતએવ કિં કરણીયમ્? અત્ર વયં મન્ત્રયિત્વા સમુપાયં ત્વાં વદામસ્તં ત્વમાચર| ");
INSERT INTO sanguj_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","વ્રતં કર્ત્તું કૃતસઙ્કલ્પા યેઽસ્માંક ચત્વારો માનવાઃ સન્તિ ");
INSERT INTO sanguj_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","તાન્ ગૃહીત્વા તૈઃ સહિતઃ સ્વં શુચિં કુરુ તથા તેષાં શિરોમુણ્ડને યો વ્યયો ભવતિ તં ત્વં દેહિ| તથા કૃતે ત્વદીયાચારે યા જનશ્રુતિ ર્જાયતે સાલીકા કિન્તુ ત્વં વિધિં પાલયન્ વ્યવસ્થાનુસારેણેવાચરસીતિ તે ભોત્સન્તે| ");
INSERT INTO sanguj_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","ભિન્નદેશીયાનાં વિશ્વાસિલોકાનાં નિકટે વયં પત્રં લિખિત્વેત્થં સ્થિરીકૃતવન્તઃ, દેવપ્રસાદભોજનં રક્તં ગલપીડનમારિતપ્રાણિભોજનં વ્યભિચારશ્ચૈતેભ્યઃ સ્વરક્ષણવ્યતિરેકેણ તેષામન્યવિધિપાલનં કરણીયં ન| ");
INSERT INTO sanguj_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","તતઃ પૌલસ્તાન્ માનુષાનાદાય પરસ્મિન્ દિવસે તૈઃ સહ શુચિ ર્ભૂત્વા મન્દિરં ગત્વા શૌચકર્મ્મણો દિનેષુ સમ્પૂર્ણેષુ તેષામ્ એકૈકાર્થં નૈવેદ્યાદ્યુત્સર્ગો ભવિષ્યતીતિ જ્ઞાપિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","તેષુ સપ્તસુ દિનેષુ સમાપ્તકલ્પેષુ આશિયાદેશનિવાસિનો યિહૂદીયાસ્તં મધ્યેમન્દિરં વિલોક્ય જનનિવહસ્ય મનઃસુ કુપ્રવૃત્તિં જનયિત્વા તં ધૃત્વા ");
INSERT INTO sanguj_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","પ્રોચ્ચૈઃ પ્રાવોચન્, હે ઇસ્રાયેલ્લોકાઃ સર્વ્વે સાહાય્યં કુરુત| યો મનુજ એતેષાં લોકાનાં મૂસાવ્યવસ્થાયા એતસ્ય સ્થાનસ્યાપિ વિપરીતં સર્વ્વત્ર સર્વ્વાન્ શિક્ષયતિ સ એષઃ; વિશેષતઃ સ ભિન્નદેશીયલોકાન્ મન્દિરમ્ આનીય પવિત્રસ્થાનમેતદ્ અપવિત્રમકરોત્| ");
INSERT INTO sanguj_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","પૂર્વ્વં તે મધ્યેનગરમ્ ઇફિષનગરીયં ત્રફિમં પૌલેન સહિતં દૃષ્ટવન્ત એતસ્માત્ પૌલસ્તં મન્દિરમધ્યમ્ આનયદ્ ઇત્યન્વમિમત| ");
INSERT INTO sanguj_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","અતએવ સર્વ્વસ્મિન્ નગરે કલહોત્પન્નત્વાત્ ધાવન્તો લોકા આગત્ય પૌલં ધૃત્વા મન્દિરસ્ય બહિરાકૃષ્યાનયન્ તત્ક્ષણાદ્ દ્વારાણિ સર્વ્વાણિ ચ રુદ્ધાનિ| ");
INSERT INTO sanguj_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","તેષુ તં હન્તુમુદ્યતેेષુ યિરૂશાલમ્નગરે મહાનુપદ્રવો જાત ઇતિ વાર્ત્તાયાં સહસ્રસેનાપતેઃ કર્ણગોચરીભૂતાયાં સત્યાં સ તત્ક્ષણાત્ સૈન્યાનિ સેનાપતિગણઞ્ચ ગૃહીત્વા જવેનાગતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","તતો લોકાઃ સેનાગણેન સહ સહસ્રસેનાપતિમ્ આગચ્છન્તં દૃષ્ટ્વા પૌલતાડનાતો ન્યવર્ત્તન્ત| ");
INSERT INTO sanguj_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","સ સહસ્રસેનાપતિઃ સન્નિધાવાગમ્ય પૌલં ધૃત્વા શૃઙ્ખલદ્વયેન બદ્ધમ્ આદિશ્ય તાન્ પૃષ્ટવાન્ એષ કઃ? કિં કર્મ્મ ચાયં કૃતવાન્? ");
INSERT INTO sanguj_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","તતો જનસમૂહસ્ય કશ્ચિદ્ એકપ્રકારં કશ્ચિદ્ અન્યપ્રકારં વાક્યમ્ અરૌત્ સ તત્ર સત્યં જ્ઞાતુમ્ કલહકારણાદ્ અશક્તઃ સન્ તં દુર્ગં નેતુમ્ આજ્ઞાપયત્| ");
INSERT INTO sanguj_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","તેષુ સોપાનસ્યોપરિ પ્રાપ્તેષુ લોકાનાં સાહસકારણાત્ સેનાગણઃ પૌલમુત્તોલ્ય નીતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","તતઃ સર્વ્વે લોકાઃ પશ્ચાદ્ગામિનઃ સન્ત એનં દુરીકુરુતેતિ વાક્યમ્ ઉચ્ચૈરવદન્| ");
INSERT INTO sanguj_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","પૌલસ્ય દુર્ગાનયનસમયે સ તસ્મૈ સહસ્રસેનાપતયે કથિતવાન્, ભવતઃ પુરસ્તાત્ કથાં કથયિતું કિમ્ અનુમન્યતે? સ તમપૃચ્છત્ ત્વં કિં યૂનાનીયાં ભાષાં જાનાસિ? ");
INSERT INTO sanguj_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","યો મિસરીયો જનઃ પૂર્વ્વં વિરોધં કૃત્વા ચત્વારિ સહસ્રાણિ ઘાતકાન્ સઙ્ગિનઃ કૃત્વા વિપિનં ગતવાન્ ત્વં કિં સએવ ન ભવસિ? ");
INSERT INTO sanguj_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","તદા પૌલોઽકથયત્ અહં કિલિકિયાદેશસ્ય તાર્ષનગરીયો યિહૂદીયો, નાહં સામાન્યનગરીયો માનવઃ; અતએવ વિનયેઽહં લાકાનાં સમક્ષં કથાં કથયિતું મામનુજાનીષ્વ| ");
INSERT INTO sanguj_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","તેનાનુજ્ઞાતઃ પૌલઃ સોપાનોપરિ તિષ્ઠન્ હસ્તેનેઙ્ગિતં કૃતવાન્, તસ્માત્ સર્વ્વે સુસ્થિરા અભવન્| તદા પૌલ ઇબ્રીયભાષયા કથયિતુમ્ આરભત, ");
INSERT INTO sanguj_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","હે પિતૃગણા હે ભ્રાતૃગણાઃ, ઇદાનીં મમ નિવેદને સમવધત્ત| ");
INSERT INTO sanguj_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","તદા સ ઇબ્રીયભાષયા કથાં કથયતીતિ શ્રુત્વા સર્વ્વે લોકા અતીવ નિઃશબ્દા સન્તોઽતિષ્ઠન્| ");
INSERT INTO sanguj_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","પશ્ચાત્ સોઽકથયદ્ અહં યિહૂદીય ઇતિ નિશ્ચયઃ કિલિકિયાદેશસ્ય તાર્ષનગરં મમ જન્મભૂમિઃ,એતન્નગરીયસ્ય ગમિલીયેલનામ્નોઽધ્યાપકસ્ય શિષ્યો ભૂત્વા પૂર્વ્વપુરુષાણાં વિધિવ્યવસ્થાનુસારેણ સમ્પૂર્ણરૂપેણ શિક્ષિતોઽભવમ્ ઇદાનીન્તના યૂયં યાદૃશા ભવથ તાદૃશોઽહમપીશ્વરસેવાયામ્ ઉદ્યોગી જાતઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","મતમેતદ્ દ્વિષ્ટ્વા તદ્ગ્રાહિનારીપુરુષાન્ કારાયાં બદ્ધ્વા તેષાં પ્રાણનાશપર્ય્યન્તાં વિપક્ષતામ્ અકરવમ્| ");
INSERT INTO sanguj_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","મહાયાજકઃ સભાસદઃ પ્રાચીનલોકાશ્ચ મમૈતસ્યાઃ કથાયાઃ પ્રમાણં દાતું શક્નુવન્તિ, યસ્માત્ તેષાં સમીપાદ્ દમ્મેષકનગરનિવાસિભ્રાતૃગણાર્થમ્ આજ્ઞાપત્રાણિ ગૃહીત્વા યે તત્ર સ્થિતાસ્તાન્ દણ્ડયિતું યિરૂશાલમમ્ આનયનાર્થં દમ્મેષકનગરં ગતોસ્મિ| ");
INSERT INTO sanguj_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","કિન્તુ ગચ્છન્ તન્નગરસ્ય સમીપં પ્રાપ્તવાન્ તદા દ્વિતીયપ્રહરવેલાયાં સત્યામ્ અકસ્માદ્ ગગણાન્નિર્ગત્ય મહતી દીપ્તિ ર્મમ ચતુર્દિશિ પ્રકાશિતવતી| ");
INSERT INTO sanguj_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","તતો મયિ ભૂમૌै પતિતે સતિ, હે શૌલ હે શૌલ કુતો માં તાડયસિ? મામ્પ્રતિ ભાષિત એતાદૃશ એકો રવોપિ મયા શ્રુતઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","તદાહં પ્રત્યવદં, હે પ્રભે કો ભવાન્? તતઃ સોઽવાદીત્ યં ત્વં તાડયસિ સ નાસરતીયો યીશુરહં| ");
INSERT INTO sanguj_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","મમ સઙ્ગિનો લોકાસ્તાં દીપ્તિં દૃષ્ટ્વા ભિયં પ્રાપ્તાઃ, કિન્તુ મામ્પ્રત્યુદિતં તદ્વાક્યં તેे નાબુધ્યન્ત| ");
INSERT INTO sanguj_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","તતઃ પરં પૃષ્ટવાનહં, હે પ્રભો મયા કિં કર્ત્તવ્યં? તતઃ પ્રભુરકથયત્, ઉત્થાય દમ્મેષકનગરં યાહિ ત્વયા યદ્યત્ કર્ત્તવ્યં નિરૂપિતમાસ્તે તત્ તત્ર ત્વં જ્ઞાપયિષ્યસે| ");
INSERT INTO sanguj_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","અનન્તરં તસ્યાઃ ખરતરદીપ્તેઃ કારણાત્ કિમપિ ન દૃષ્ટ્વા સઙ્ગિગણેન ધૃતહસ્તઃ સન્ દમ્મેષકનગરં વ્રજિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","તન્નગરનિવાસિનાં સર્વ્વેષાં યિહૂદીયાનાં માન્યો વ્યવસ્થાનુસારેણ ભક્તશ્ચ હનાનીયનામા માનવ એકો ");
INSERT INTO sanguj_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","મમ સન્નિધિમ્ એત્ય તિષ્ઠન્ અકથયત્, હે ભ્રાતઃ શૌલ સુદૃષ્ટિ ર્ભવ તસ્મિન્ દણ્ડેઽહં સમ્યક્ તં દૃષ્ટવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","તતઃ સ મહ્યં કથિતવાન્ યથા ત્વમ્ ઈશ્વરસ્યાભિપ્રાયં વેત્સિ તસ્ય શુદ્ધસત્ત્વજનસ્ય દર્શનં પ્રાપ્ય તસ્ય શ્રીમુખસ્ય વાક્યં શૃણોષિ તન્નિમિત્તમ્ અસ્માકં પૂર્વ્વપુરુષાણામ્ ઈશ્વરસ્ત્વાં મનોનીતં કૃતવાનં| ");
INSERT INTO sanguj_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","યતો યદ્યદ્ અદ્રાક્ષીરશ્રૌષીશ્ચ સર્વ્વેષાં માનવાનાં સમીપે ત્વં તેષાં સાક્ષી ભવિષ્યસિ| ");
INSERT INTO sanguj_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","અતએવ કુતો વિલમ્બસે? પ્રભો ર્નામ્ના પ્રાર્થ્ય નિજપાપપ્રક્ષાલનાર્થં મજ્જનાય સમુત્તિષ્ઠ| ");
INSERT INTO sanguj_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","તતઃ પરં યિરૂશાલમ્નગરં પ્રત્યાગત્ય મન્દિરેઽહમ્ એકદા પ્રાર્થયે, તસ્મિન્ સમયેઽહમ્ અભિભૂતઃ સન્ પ્રભૂં સાક્ષાત્ પશ્યન્, ");
INSERT INTO sanguj_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ત્વં ત્વરયા યિરૂશાલમઃ પ્રતિષ્ઠસ્વ યતો લોકામયિ તવ સાક્ષ્યં ન ગ્રહીષ્યન્તિ, મામ્પ્રત્યુદિતં તસ્યેદં વાક્યમ્ અશ્રૌષમ્| ");
INSERT INTO sanguj_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","તતોહં પ્રત્યવાદિષમ્ હે પ્રભો પ્રતિભજનભવનં ત્વયિ વિશ્વાસિનો લોકાન્ બદ્ધ્વા પ્રહૃતવાન્, ");
INSERT INTO sanguj_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","તથા તવ સાક્ષિણઃ સ્તિફાનસ્ય રક્તપાતનસમયે તસ્ય વિનાશં સમ્મન્ય સન્નિધૌ તિષ્ઠન્ હન્તૃલોકાનાં વાસાંસિ રક્ષિતવાન્, એતત્ તે વિદુઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","તતઃ સોઽકથયત્ પ્રતિષ્ઠસ્વ ત્વાં દૂરસ્થભિન્નદેશીયાનાં સમીપં પ્રેષયિષ્યે| ");
INSERT INTO sanguj_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","તદા લોકા એતાવત્પર્ય્યન્તાં તદીયાં કથાં શ્રુત્વા પ્રોચ્ચૈરકથયન્, એનં ભૂમણ્ડલાદ્ દૂરીકુરુત, એતાદૃશજનસ્ય જીવનં નોચિતમ્| ");
INSERT INTO sanguj_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ઇત્યુચ્ચૈઃ કથયિત્વા વસનાનિ પરિત્યજ્ય ગગણં પ્રતિ ધૂલીરક્ષિપન્ ");
INSERT INTO sanguj_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","તતઃ સહસ્રસેનાપતિઃ પૌલં દુર્ગાભ્યન્તર નેતું સમાદિશત્| એતસ્ય પ્રતિકૂલાઃ સન્તો લોકાઃ કિન્નિમિત્તમ્ એતાવદુચ્ચૈઃસ્વરમ્ અકુર્વ્વન્, એતદ્ વેત્તું તં કશયા પ્રહૃત્ય તસ્ય પરીક્ષાં કર્ત્તુમાદિશત્| ");
INSERT INTO sanguj_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","પદાતયશ્ચર્મ્મનિર્મ્મિતરજ્જુભિસ્તસ્ય બન્ધનં કર્ત્તુમુદ્યતાસ્તાસ્તદાનીં પૌલઃ સમ્મુખસ્થિતં શતસેનાપતિમ્ ઉક્તવાન્ દણ્ડાજ્ઞાયામ્ અપ્રાપ્તાયાં કિં રોમિલોકં પ્રહર્ત્તું યુષ્માકમ્ અધિકારોસ્તિ? ");
INSERT INTO sanguj_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","એનાં કથાં શ્રુત્વા સ સહસ્રસેનાપતેઃ સન્નિધિં ગત્વા તાં વાર્ત્તામવદત્ સ રોમિલોક એતસ્માત્ સાવધાનઃ સન્ કર્મ્મ કુરુ| ");
INSERT INTO sanguj_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","તસ્માત્ સહસ્રસેનાપતિ ર્ગત્વા તમપ્રાક્ષીત્ ત્વં કિં રોમિલોકઃ? ઇતિ માં બ્રૂહિ| સોઽકથયત્ સત્યમ્| ");
INSERT INTO sanguj_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","તતઃ સહસ્રસેનાપતિઃ કથિતવાન્ બહુદ્રવિણં દત્ત્વાહં તત્ પૌરસખ્યં પ્રાપ્તવાન્; કિન્તુ પૌલઃ કથિતવાન્ અહં જનુના તત્ પ્રાપ્તોઽસ્મિ| ");
INSERT INTO sanguj_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","ઇત્થં સતિ યે પ્રહારેણ તં પરીક્ષિતું સમુદ્યતા આસન્ તે તસ્ય સમીપાત્ પ્રાતિષ્ઠન્ત; સહસ્રસેનાપતિસ્તં રોમિલોકં વિજ્ઞાય સ્વયં યત્ તસ્ય બન્ધનમ્ અકાર્ષીત્ તત્કારણાદ્ અબિભેત્| ");
INSERT INTO sanguj_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","યિહૂદીયલોકાઃ પૌલં કુતોઽપવદન્તે તસ્ય વૃત્તાન્તં જ્ઞાતું વાઞ્છન્ સહસ્રસેનાપતિઃ પરેઽહનિ પૌલં બન્ધનાત્ મોચયિત્વા પ્રધાનયાજકાન્ મહાસભાયાઃ સર્વ્વલોકાશ્ચ સમુપસ્થાતુમ્ આદિશ્ય તેષાં સન્નિધૌ પૌલમ્ અવરોહ્ય સ્થાપિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","સભાસદ્લોકાન્ પ્રતિ પૌલોઽનન્યદૃષ્ટ્યા પશ્યન્ અકથયત્, હે ભ્રાતૃગણા અદ્ય યાવત્ સરલેન સર્વ્વાન્તઃકરણેનેશ્વરસ્ય સાક્ષાદ્ આચરામિ| ");
INSERT INTO sanguj_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","અનેન હનાનીયનામા મહાયાજકસ્તં કપોલે ચપેટેનાહન્તું સમીપસ્થલોકાન્ આદિષ્ટવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","તદા પૌલસ્તમવદત્, હે બહિષ્પરિષ્કૃત, ઈશ્વરસ્ત્વાં પ્રહર્ત્તુમ્ ઉદ્યતોસ્તિ, યતો વ્યવસ્થાનુસારેણ વિચારયિતુમ્ ઉપવિશ્ય વ્યવસ્થાં લઙ્ઘિત્વા માં પ્રહર્ત્તુમ્ આજ્ઞાપયસિ| ");
INSERT INTO sanguj_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","તતો નિકટસ્થા લોકા અકથયન્, ત્વં કિમ્ ઈશ્વરસ્ય મહાયાજકં નિન્દસિ? ");
INSERT INTO sanguj_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","તતઃ પૌલઃ પ્રતિભાષિતવાન્ હે ભ્રાતૃગણ મહાયાજક એષ ઇતિ ન બુદ્ધં મયા તદન્યચ્ચ સ્વલોકાનામ્ અધિપતિં પ્રતિ દુર્વ્વાક્યં મા કથય, એતાદૃશી લિપિરસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","અનન્તરં પૌલસ્તેષામ્ અર્દ્ધં સિદૂકિલોકા અર્દ્ધં ફિરૂશિલોકા ઇતિ દૃષ્ટ્વા પ્રોચ્ચૈઃ સભાસ્થલોકાન્ અવદત્ હે ભ્રાતૃગણ અહં ફિરૂશિમતાવલમ્બી ફિરૂશિનઃ સત્નાનશ્ચ, મૃતલોકાનામ્ ઉત્થાને પ્રત્યાશાકરણાદ્ અહમપવાદિતોસ્મિ| ");
INSERT INTO sanguj_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","ઇતિ કથાયાં કથિતાયાં ફિરૂશિસિદૂકિનોઃ પરસ્પરં ભિન્નવાક્યત્વાત્ સભાયા મધ્યે દ્વૌ સંઘૌ જાતૌ| ");
INSERT INTO sanguj_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","યતઃ સિદૂકિલોકા ઉત્થાનં સ્વર્ગીયદૂતા આત્માનશ્ચ સર્વ્વેષામ્ એતેષાં કમપિ ન મન્યન્તે, કિન્તુ ફિરૂશિનઃ સર્વ્વમ્ અઙ્ગીકુર્વ્વન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","તતઃ પરસ્પરમ્ અતિશયકોલાહલે સમુપસ્થિતે ફિરૂશિનાં પક્ષીયાઃ સભાસ્થા અધ્યાપકાઃ પ્રતિપક્ષા ઉત્તિષ્ઠન્તો ઽકથયન્, એતસ્ય માનવસ્ય કમપિ દોષં ન પશ્યામઃ; યદિ કશ્ચિદ્ આત્મા વા કશ્ચિદ્ દૂત એનં પ્રત્યાદિશત્ તર્હિ વયમ્ ઈશ્વરસ્ય પ્રાતિકૂલ્યેન ન યોત્સ્યામઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","તસ્માદ્ અતીવ ભિન્નવાક્યત્વે સતિ તે પૌલં ખણ્ડં ખણ્ડં કરિષ્યન્તીત્યાશઙ્કયા સહસ્રસેનાપતિઃ સેનાગણં તત્સ્થાનં યાતું સભાતો બલાત્ પૌલં ધૃત્વા દુર્ગં નેતઞ્ચાજ્ઞાપયત્| ");
INSERT INTO sanguj_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","રાત્રો પ્રભુસ્તસ્ય સમીપે તિષ્ઠન્ કથિતવાન્ હે પૌલ નિર્ભયો ભવ યથા યિરૂશાલમ્નગરે મયિ સાક્ષ્યં દત્તવાન્ તથા રોમાનગરેપિ ત્વયા દાતવ્યમ્| ");
INSERT INTO sanguj_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","દિને સમુપસ્થિતે સતિ કિયન્તો યિહૂદીયલોકા એકમન્ત્રણાઃ સન્તઃ પૌલં ન હત્વા ભોજનપાને કરિષ્યામ ઇતિ શપથેન સ્વાન્ અબધ્નન્| ");
INSERT INTO sanguj_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","ચત્વારિંશજ્જનેભ્યોઽધિકા લોકા ઇતિ પણમ્ અકુર્વ્વન્| ");
INSERT INTO sanguj_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","તે મહાયાજકાનાં પ્રાચીનલોકાનાઞ્ચ સમીપં ગત્વા કથયન્, વયં પૌલં ન હત્વા કિમપિ ન ભોક્ષ્યામહે દૃઢેનાનેન શપથેન બદ્ધ્વા અભવામ| ");
INSERT INTO sanguj_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","અતએવ સામ્પ્રતં સભાસદ્લોકૈઃ સહ વયં તસ્મિન્ કઞ્ચિદ્ વિશેષવિચારં કરિષ્યામસ્તદર્થં ભવાન્ શ્વો ઽસ્માકં સમીપં તમ્ આનયત્વિતિ સહસ્રસેનાપતયે નિવેદનં કુરુત તેન યુષ્માકં સમીપં ઉપસ્થિતેઃ પૂર્વ્વં વયં તં હન્તુ સજ્જિષ્યામ| ");
INSERT INTO sanguj_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","તદા પૌલસ્ય ભાગિનેયસ્તેષામિતિ મન્ત્રણાં વિજ્ઞાય દુર્ગં ગત્વા તાં વાર્ત્તાં પૌલમ્ ઉક્તવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","તસ્માત્ પૌલ એકં શતસેનાપતિમ્ આહૂય વાક્યમિદમ્ ભાષિતવાન્ સહસ્રસેનાપતેઃ સમીપેઽસ્ય યુવમનુષ્યસ્ય કિઞ્ચિન્નિવેદનમ્ આસ્તે, તસ્માત્ તત્સવિધમ્ એનં નય| ");
INSERT INTO sanguj_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","તતઃ સ તમાદાય સહસ્રસેનાપતેઃ સમીપમ્ ઉપસ્થાય કથિતવાન્, ભવતઃ સમીપેઽસ્ય કિમપિ નિવેદનમાસ્તે તસ્માત્ બન્દિઃ પૌલો મામાહૂય ભવતઃ સમીપમ્ એનમ્ આનેતું પ્રાર્થિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","તદા સહસ્રસેનાપતિસ્તસ્ય હસ્તં ધૃત્વા નિર્જનસ્થાનં નીત્વા પૃષ્ઠવાન્ તવ કિં નિવેદનં? તત્ કથય| ");
INSERT INTO sanguj_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","તતઃ સોકથયત્, યિહૂદીયલાકાઃ પૌલે કમપિ વિશેષવિચારં છલં કૃત્વા તં સભાં નેતું ભવતઃ સમીપે નિવેદયિતું અમન્ત્રયન્| ");
INSERT INTO sanguj_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","કિન્તુ મવતા તન્ન સ્વીકર્ત્તવ્યં યતસ્તેષાં મધ્યેવર્ત્તિનશ્ચત્વારિંશજ્જનેભ્યો ઽધિકલોકા એકમન્ત્રણા ભૂત્વા પૌલં ન હત્વા ભોજનં પાનઞ્ચ ન કરિષ્યામ ઇતિ શપથેન બદ્ધાઃ સન્તો ઘાતકા ઇવ સજ્જિતા ઇદાનીં કેવલં ભવતો ઽનુમતિમ્ અપેક્ષન્તે| ");
INSERT INTO sanguj_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","યામિમાં કથાં ત્વં નિવેદિતવાન્ તાં કસ્મૈચિદપિ મા કથયેત્યુક્ત્વા સહસ્રસેનાપતિસ્તં યુવાનં વિસૃષ્ટવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","અનન્તરં સહસ્રસેનાપતિ ર્દ્વૌ શતસેનાપતી આહૂયેદમ્ આદિશત્, યુવાં રાત્રૌ પ્રહરૈકાવશિષ્ટાયાં સત્યાં કૈસરિયાનગરં યાતું પદાતિસૈન્યાનાં દ્વે શતે ઘોટકારોહિસૈન્યાનાં સપ્તતિં શક્તિધારિસૈન્યાનાં દ્વે શતે ચ જનાન્ સજ્જિતાન્ કુરુતં| ");
INSERT INTO sanguj_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","પૌલમ્ આરોહયિતું ફીલિક્ષાધિપતેઃ સમીપં નિર્વ્વિઘ્નં નેતુઞ્ચ વાહનાનિ સમુપસ્થાપયતં| ");
INSERT INTO sanguj_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","અપરં સ પત્રં લિખિત્વા દત્તવાન્ તલ્લિખિતમેતત્, ");
INSERT INTO sanguj_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","મહામહિમશ્રીયુક્તફીલિક્ષાધિપતયે ક્લૌદિયલુષિયસ્ય નમસ્કારઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","યિહૂદીયલોકાઃ પૂર્વ્વમ્ એનં માનવં ધૃત્વા સ્વહસ્તૈ ર્હન્તુમ્ ઉદ્યતા એતસ્મિન્નન્તરે સસૈન્યોહં તત્રોપસ્થાય એષ જનો રોમીય ઇતિ વિજ્ઞાય તં રક્ષિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","કિન્નિમિત્તં તે તમપવદન્તે તજ્જ્ઞાતું તેષા સભાં તમાનાયિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","તતસ્તેષાં વ્યવસ્થાયા વિરુદ્ધયા કયાચન કથયા સોઽપવાદિતોઽભવત્, કિન્તુ સ શૃઙ્ખલબન્ધનાર્હો વા પ્રાણનાશાર્હો ભવતીદૃશઃ કોપ્યપરાધો મયાસ્ય ન દૃષ્ટઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","તથાપિ મનુષ્યસ્યાસ્ય વધાર્થં યિહૂદીયા ઘાતકાઇવ સજ્જિતા એતાં વાર્ત્તાં શ્રુત્વા તત્ક્ષણાત્ તવ સમીપમેનં પ્રેષિતવાન્ અસ્યાપવાદકાંશ્ચ તવ સમીપં ગત્વાપવદિતુમ્ આજ્ઞાપયમ્| ભવતઃ કુશલં ભૂયાત્| ");
INSERT INTO sanguj_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","સૈન્યગણ આજ્ઞાનુસારેણ પૌલં ગૃહીત્વા તસ્યાં રજન્યામ્ આન્તિપાત્રિનગરમ્ આનયત્| ");
INSERT INTO sanguj_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","પરેઽહનિ તેન સહ યાતું ઘોટકારૂઢસૈન્યગણં સ્થાપયિત્વા પરાવૃત્ય દુર્ગં ગતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","તતઃ પરે ઘોટકારોહિસૈન્યગણઃ કૈસરિયાનગરમ્ ઉપસ્થાય તત્પત્રમ્ અધિપતેઃ કરે સમર્પ્ય તસ્ય સમીપે પૌલમ્ ઉપસ્થાપિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","તદાધિપતિસ્તત્પત્રં પઠિત્વા પૃષ્ઠવાન્ એષ કિમ્પ્રદેશીયો જનઃ? સ કિલિકિયાપ્રદેશીય એકો જન ઇતિ જ્ઞાત્વા કથિતવાન્, ");
INSERT INTO sanguj_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","તવાપવાદકગણ આગતે તવ કથાં શ્રોષ્યામિ| હેરોદ્રાજગૃહે તં સ્થાપયિતુમ્ આદિષ્ટવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","પઞ્ચભ્યો દિનેભ્યઃ પરં હનાનીયનામા મહાયાજકોઽધિપતેઃ સમક્ષં પૌલસ્ય પ્રાતિકૂલ્યેન નિવેદયિતું તર્તુલ્લનામાનં કઞ્ચન વક્તારં પ્રાચીનજનાંશ્ચ સઙ્ગિનઃ કૃત્વા કૈસરિયાનગરમ્ આગચ્છત્| ");
INSERT INTO sanguj_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","તતઃ પૌલે સમાનીતે સતિ તર્તુલ્લસ્તસ્યાપવાદકથાં કથયિતુમ્ આરભત હે મહામહિમફીલિક્ષ ભવતો વયમ્ અતિનિર્વ્વિઘ્નં કાલં યાપયામો ભવતઃ પરિણામદર્શિતયા એતદ્દેશીયાનાં બહૂનિ મઙ્ગલાનિ ઘટિતાનિ, ");
INSERT INTO sanguj_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","ઇતિ હેતો ર્વયમતિકૃતજ્ઞાઃ સન્તઃ સર્વ્વત્ર સર્વ્વદા ભવતો ગુણાન્ ગાયમઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","કિન્તુ બહુભિઃ કથાભિ ર્ભવન્તં યેન ન વિરઞ્જયામિ તસ્માદ્ વિનયે ભવાન્ બનુકમ્પ્ય મદલ્પકથાં શૃણોતુ| ");
INSERT INTO sanguj_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","એષ મહામારીસ્વરૂપો નાસરતીયમતગ્રાહિસંઘાતસ્ય મુખ્યો ભૂત્વા સર્વ્વદેશેષુ સર્વ્વેષાં યિહૂદીયાનાં રાજદ્રોહાચરણપ્રવૃત્તિં જનયતીત્યસ્માભિ ર્નિશ્ચિતં| ");
INSERT INTO sanguj_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","સ મન્દિરમપિ અશુચિ કર્ત્તું ચેષ્ટિતવાન્; ઇતિ કારણાદ્ વયમ્ એનં ધૃત્વા સ્વવ્યવસ્થાનુસારેણ વિચારયિતું પ્રાવર્ત્તામહિ; ");
INSERT INTO sanguj_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","કિન્તુ લુષિયઃ સહસ્રસેનાપતિરાગત્ય બલાદ્ અસ્માકં કરેભ્ય એનં ગૃહીત્વા ");
INSERT INTO sanguj_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","એતસ્યાપવાદકાન્ ભવતઃ સમીપમ્ આગન્તુમ્ આજ્ઞાપયત્| વયં યસ્મિન્ તમપવાદામો ભવતા પદપવાદકથાયાં વિચારિતાયાં સત્યાં સર્વ્વં વૃત્તાન્તં વેદિતું શક્ષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","તતો યિહૂદીયા અપિ સ્વીકૃત્ય કથિતવન્ત એષા કથા પ્રમાણમ્| ");
INSERT INTO sanguj_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","અધિપતૌ કથાં કથયિતું પૌલં પ્રતીઙ્ગિતં કૃતવતિ સ કથિતવાન્ ભવાન્ બહૂન્ વત્સરાન્ યાવદ્ એતદ્દેશસ્ય શાસનં કરોતીતિ વિજ્ઞાય પ્રત્યુત્તરં દાતુમ્ અક્ષોભોઽભવમ્| ");
INSERT INTO sanguj_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","અદ્ય કેવલં દ્વાદશ દિનાનિ યાતાનિ, અહમ્ આરાધનાં કર્ત્તું યિરૂશાલમનગરં ગતવાન્ એષા કથા ભવતા જ્ઞાતું શક્યતે; ");
INSERT INTO sanguj_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","કિન્ત્વિભે માં મધ્યેમન્દિરં કેનાપિ સહ વિતણ્ડાં કુર્વ્વન્તં કુત્રાપિ ભજનભવને નગરે વા લોકાન્ કુપ્રવૃત્તિં જનયન્તું ન દૃષ્ટવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","ઇદાનીં યસ્મિન્ યસ્મિન્ મામ્ અપવદન્તે તસ્ય કિમપિ પ્રમાણં દાતું ન શક્નુવન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","કિન્તુ ભવિષ્યદ્વાક્યગ્રન્થે વ્યવસ્થાગ્રન્થે ચ યા યા કથા લિખિતાસ્તે તાસુ સર્વ્વાસુ વિશ્વસ્ય યન્મતમ્ ઇમે વિધર્મ્મં જાનન્તિ તન્મતાનુસારેણાહં નિજપિતૃપુરુષાણામ્ ઈશ્વરમ્ આરાધયામીત્યહં ભવતઃ સમક્ષમ્ અઙ્ગીકરોમિ| ");
INSERT INTO sanguj_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","ધાર્મ્મિકાણામ્ અધાર્મ્મિકાણાઞ્ચ પ્રમીતલોકાનામેવોત્થાનં ભવિષ્યતીતિ કથામિમે સ્વીકુર્વ્વન્તિ તથાહમપિ તસ્મિન્ ઈશ્વરે પ્રત્યાશાં કરોમિ; ");
INSERT INTO sanguj_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","ઈશ્વરસ્ય માનવાનાઞ્ચ સમીપે યથા નિર્દોષો ભવામિ તદર્થં સતતં યત્નવાન્ અસ્મિ| ");
INSERT INTO sanguj_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","બહુષુ વત્સરેષુ ગતેષુ સ્વદેશીયલોકાનાં નિમિત્તં દાનીયદ્રવ્યાણિ નૈવેદ્યાનિ ચ સમાદાય પુનરાગમનં કૃતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","તતોહં શુચિ ર્ભૂત્વા લોકાનાં સમાગમં કલહં વા ન કારિતવાન્ તથાપ્યાશિયાદેશીયાઃ કિયન્તો યિહુદીયલોકા મધ્યેમન્દિરં માં ધૃતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","મમોપરિ યદિ કાચિદપવાદકથાસ્તિ તર્હિ ભવતઃ સમીપમ્ ઉપસ્થાય તેષામેવ સાક્ષ્યદાનમ્ ઉચિતમ્| ");
INSERT INTO sanguj_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","નોચેત્ પૂર્વ્વે મહાસભાસ્થાનાં લોકાનાં સન્નિધૌ મમ દણ્ડાયમાનત્વસમયે, અહમદ્ય મૃતાનામુત્થાને યુષ્માભિ ર્વિચારિતોસ્મિ, ");
INSERT INTO sanguj_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","તેષાં મધ્યે તિષ્ઠન્નહં યામિમાં કથામુચ્ચૈઃ સ્વરેણ કથિતવાન્ તદન્યો મમ કોપિ દોષોઽલભ્યત ન વેતિ વરમ્ એતે સમુપસ્થિતલોકા વદન્તુ| ");
INSERT INTO sanguj_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","તદા ફીલિક્ષ એતાં કથાં શ્રુત્વા તન્મતસ્ય વિશેષવૃત્તાન્તં વિજ્ઞાતું વિચારં સ્થગિતં કૃત્વા કથિતવાન્ લુષિયે સહસ્રસેનાપતૌ સમાયાતે સતિ યુષ્માકં વિચારમ્ અહં નિષ્પાદયિષ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","અનન્તરં બન્ધનં વિના પૌલં રક્ષિતું તસ્ય સેવનાય સાક્ષાત્કરણાય વા તદીયાત્મીયબન્ધુજનાન્ ન વારયિતુઞ્ચ શમસેનાપતિમ્ આદિષ્ટવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","અલ્પદિનાત્ પરં ફીલિક્ષોઽધિપતિ ર્દ્રુષિલ્લાનામ્ના યિહૂદીયયા સ્વભાર્ય્યયા સહાગત્ય પૌલમાહૂય તસ્ય મુખાત્ ખ્રીષ્ટધર્મ્મસ્ય વૃત્તાન્તમ્ અશ્રૌષીત્| ");
INSERT INTO sanguj_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","પૌલેન ન્યાયસ્ય પરિમિતભોગસ્ય ચરમવિચારસ્ય ચ કથાયાં કથિતાયાં સત્યાં ફીલિક્ષઃ કમ્પમાનઃ સન્ વ્યાહરદ્ ઇદાનીં યાહિ, અહમ્ અવકાશં પ્રાપ્ય ત્વામ્ આહૂસ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","મુક્તિપ્રપ્ત્યર્થં પૌલેન મહ્યં મુદ્રાદાસ્યન્તે ઇતિ પત્યાશાં કૃત્વા સ પુનઃ પુનસ્તમાહૂય તેન સાકં કથોપકથનં કૃતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","કિન્તુ વત્સરદ્વયાત્ પરં પર્કિયફીષ્ટ ફાલિક્ષસ્ય પદં પ્રાપ્તે સતિ ફીલિક્ષો યિહૂદીયાન્ સન્તુષ્ટાન્ ચિકીર્ષન્ પૌલં બદ્ધં સંસ્થાપ્ય ગતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","અનન્તરં ફીષ્ટો નિજરાજ્યમ્ આગત્ય દિનત્રયાત્ પરં કૈસરિયાતો યિરૂશાલમ્નગરમ્ આગમત્| ");
INSERT INTO sanguj_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","તદા મહાયાજકો યિહૂદીયાનાં પ્રધાનલોકાશ્ચ તસ્ય સમક્ષં પૌલમ્ અપાવદન્ત| ");
INSERT INTO sanguj_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ભવાન્ તં યિરૂશાલમમ્ આનેતુમ્ આજ્ઞાપયત્વિતિ વિનીય તે તસ્માદ્ અનુગ્રહં વાઞ્છિતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","યતઃ પથિમધ્યે ગોપનેન પૌલં હન્તું તૈ ર્ઘાતકા નિયુક્તાઃ| ફીષ્ટ ઉત્તરં દત્તવાન્ પૌલઃ કૈસરિયાયાં સ્થાસ્યતિ પુનરલ્પદિનાત્ પરમ્ અહં તત્ર યાસ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","તતસ્તસ્ય માનુષસ્ય યદિ કશ્ચિદ્ અપરાધસ્તિષ્ઠતિ તર્હિ યુષ્માકં યે શક્નુવન્તિ તે મયા સહ તત્ર ગત્વા તમપવદન્તુ સ એતાં કથાં કથિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","દશદિવસેભ્યોઽધિકં વિલમ્બ્ય ફીષ્ટસ્તસ્માત્ કૈસરિયાનગરં ગત્વા પરસ્મિન્ દિવસે વિચારાસન ઉપદિશ્ય પૌલમ્ આનેતુમ્ આજ્ઞાપયત્| ");
INSERT INTO sanguj_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","પૌલે સમુપસ્થિતે સતિ યિરૂશાલમ્નગરાદ્ આગતા યિહૂદીયલોકાસ્તં ચતુર્દિશિ સંવેષ્ટ્ય તસ્ય વિરુદ્ધં બહૂન્ મહાદોષાન્ ઉત્થાપિતવન્તઃ કિન્તુ તેષાં કિમપિ પ્રમાણં દાતું ન શક્નુવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","તતઃ પૌલઃ સ્વસ્મિન્ ઉત્તરમિદમ્ ઉદિતવાન્, યિહૂદીયાનાં વ્યવસ્થાયા મન્દિરસ્ય કૈસરસ્ય વા પ્રતિકૂલં કિમપિ કર્મ્મ નાહં કૃતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","કિન્તુ ફીષ્ટો યિહૂદીયાન્ સન્તુષ્ટાન્ કર્ત્તુમ્ અભિલષન્ પૌલમ્ અભાષત ત્વં કિં યિરૂશાલમં ગત્વાસ્મિન્ અભિયોગે મમ સાક્ષાદ્ વિચારિતો ભવિષ્યસિ? ");
INSERT INTO sanguj_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","તતઃ પૌલ ઉત્તરં પ્રોક્તવાન્, યત્ર મમ વિચારો ભવિતું યોગ્યઃ કૈસરસ્ય તત્ર વિચારાસન એવ સમુપસ્થિતોસ્મિ; અહં યિહૂદીયાનાં કામપિ હાનિં નાકાર્ષમ્ ઇતિ ભવાન્ યથાર્થતો વિજાનાતિ| ");
INSERT INTO sanguj_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","કઞ્ચિદપરાધં કિઞ્ચન વધાર્હં કર્મ્મ વા યદ્યહમ્ અકરિષ્યં તર્હિ પ્રાણહનનદણ્ડમપિ ભોક્તુમ્ ઉદ્યતોઽભવિષ્યં, કિન્તુ તે મમ સમપવાદં કુર્વ્વન્તિ સ યદિ કલ્પિતમાત્રો ભવતિ તર્હિ તેષાં કરેષુ માં સમર્પયિતું કસ્યાપ્યધિકારો નાસ્તિ, કૈસરસ્ય નિકટે મમ વિચારો ભવતુ| ");
INSERT INTO sanguj_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","તદા ફીષ્ટો મન્ત્રિભિઃ સાર્દ્ધં સંમન્ત્ર્ય પૌલાય કથિતવાન્, કૈસરસ્ય નિકટે કિં તવ વિચારો ભવિષ્યતિ? કૈસરસ્ય સમીપં ગમિષ્યસિ| ");
INSERT INTO sanguj_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","કિયદ્દિનેભ્યઃ પરમ્ આગ્રિપ્પરાજા બર્ણીકી ચ ફીષ્ટં સાક્ષાત્ કર્ત્તું કૈસરિયાનગરમ્ આગતવન્તૌ| ");
INSERT INTO sanguj_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","તદા તૌ બહુદિનાનિ તત્ર સ્થિતૌ તતઃ ફીષ્ટસ્તં રાજાનં પૌલસ્ય કથાં વિજ્ઞાપ્ય કથયિતુમ્ આરભત પૌલનામાનમ્ એકં બન્દિ ફીલિક્ષો બદ્ધં સંસ્થાપ્ય ગતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","યિરૂશાલમિ મમ સ્થિતિકાલે મહાયાજકો યિહૂદીયાનાં પ્રાચીનલોકાશ્ચ તમ્ અપોદ્ય તમ્પ્રતિ દણ્ડાજ્ઞાં પ્રાર્થયન્ત| ");
INSERT INTO sanguj_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","તતોહમ્ ઇત્યુત્તરમ્ અવદં યાવદ્ અપોદિતો જનઃ સ્વાપવાદકાન્ સાક્ષાત્ કૃત્વા સ્વસ્મિન્ યોઽપરાધ આરોપિતસ્તસ્ય પ્રત્યુત્તરં દાતું સુયોગં ન પ્રાપ્નોતિ, તાવત્કાલં કસ્યાપિ માનુષસ્ય પ્રાણનાશાજ્ઞાપનં રોમિલોકાનાં રીતિ ર્નહિ| ");
INSERT INTO sanguj_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","તતસ્તેષ્વત્રાગતેષુ પરસ્મિન્ દિવસેઽહમ્ અવિલમ્બં વિચારાસન ઉપવિશ્ય તં માનુષમ્ આનેતુમ્ આજ્ઞાપયમ્| ");
INSERT INTO sanguj_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","તદનન્તરં તસ્યાપવાદકા ઉપસ્થાય યાદૃશમ્ અહં ચિન્તિતવાન્ તાદૃશં કઞ્ચન મહાપવાદં નોત્થાપ્ય ");
INSERT INTO sanguj_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","સ્વેષાં મતે તથા પૌલો યં સજીવં વદતિ તસ્મિન્ યીશુનામનિ મૃતજને ચ તસ્ય વિરુદ્ધં કથિતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","તતોહં તાદૃગ્વિચારે સંશયાનઃ સન્ કથિતવાન્ ત્વં યિરૂશાલમં ગત્વા કિં તત્ર વિચારિતો ભવિતુમ્ ઇચ્છસિ? ");
INSERT INTO sanguj_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","તદા પૌલો મહારાજસ્ય નિકટે વિચારિતો ભવિતું પ્રાર્થયત, તસ્માદ્ યાવત્કાલં તં કૈસરસ્ય સમીપં પ્રેષયિતું ન શક્નોમિ તાવત્કાલં તમત્ર સ્થાપયિતુમ્ આદિષ્ટવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","તત આગ્રિપ્પઃ ફીષ્ટમ્ ઉક્તવાન્, અહમપિ તસ્ય માનુષસ્ય કથાં શ્રોતુમ્ અભિલષામિ| તદા ફીષ્ટો વ્યાહરત્ શ્વસ્તદીયાં કથાં ત્વં શ્રોષ્યસિ| ");
INSERT INTO sanguj_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","પરસ્મિન્ દિવસે આગ્રિપ્પો બર્ણીકી ચ મહાસમાગમં કૃત્વા પ્રધાનવાહિનીપતિભિ ર્નગરસ્થપ્રધાનલોકૈશ્ચ સહ મિલિત્વા રાજગૃહમાગત્ય સમુપસ્થિતૌ તદા ફીષ્ટસ્યાજ્ઞયા પૌલ આનીતોઽભવત્| ");
INSERT INTO sanguj_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","તદા ફીષ્ટઃ કથિતવાન્ હે રાજન્ આગ્રિપ્પ હે ઉપસ્થિતાઃ સર્વ્વે લોકા યિરૂશાલમ્નગરે યિહૂદીયલોકસમૂહો યસ્મિન્ માનુષે મમ સમીપે નિવેદનં કૃત્વા પ્રોચ્ચૈઃ કથામિમાં કથિતવાન્ પુનરલ્પકાલમપિ તસ્ય જીવનં નોચિતં તમેતં માનુષં પશ્યત| ");
INSERT INTO sanguj_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","કિન્ત્વેષ જનઃ પ્રાણનાશર્હં કિમપિ કર્મ્મ ન કૃતવાન્ ઇત્યજાનાં તથાપિ સ મહારાજસ્ય સન્નિધૌ વિચારિતો ભવિતું પ્રાર્થયત તસ્માત્ તસ્ય સમીપં તં પ્રેષયિતું મતિમકરવમ્| ");
INSERT INTO sanguj_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","કિન્તુ શ્રીયુક્તસ્ય સમીપમ્ એતસ્મિન્ કિં લેખનીયમ્ ઇત્યસ્ય કસ્યચિન્ નિર્ણયસ્ય ન જાતત્વાદ્ એતસ્ય વિચારે સતિ યથાહં લેખિતું કિઞ્ચન નિશ્ચિતં પ્રાપ્નોમિ તદર્થં યુષ્માકં સમક્ષં વિશેષતો હે આગ્રિપ્પરાજ ભવતઃ સમક્ષમ્ એતમ્ આનયે| ");
INSERT INTO sanguj_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","યતો બન્દિપ્રેષણસમયે તસ્યાભિયોગસ્ય કિઞ્ચિદલેખનમ્ અહમ્ અયુક્તં જાનામિ| ");
INSERT INTO sanguj_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","તત આગ્રિપ્પઃ પૌલમ્ અવાદીત્, નિજાં કથાં કથયિતું તુભ્યમ્ અનુમતિ ર્દીયતે| તસ્માત્ પૌલઃ કરં પ્રસાર્ય્ય સ્વસ્મિન્ ઉત્તરમ્ અવાદીત્| ");
INSERT INTO sanguj_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","હે આગ્રિપ્પરાજ યત્કારણાદહં યિહૂદીયૈરપવાદિતો ઽભવં તસ્ય વૃત્તાન્તમ્ અદ્ય ભવતઃ સાક્ષાન્ નિવેદયિતુમનુમતોહમ્ ઇદં સ્વીયં પરમં ભાગ્યં મન્યે; ");
INSERT INTO sanguj_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","યતો યિહૂદીયલોકાનાં મધ્યે યા યા રીતિઃ સૂક્ષ્મવિચારાશ્ચ સન્તિ તેષુ ભવાન્ વિજ્ઞતમઃ; અતએવ પ્રાર્થયે ધૈર્ય્યમવલમ્બ્ય મમ નિવેદનં શૃણોતુ| ");
INSERT INTO sanguj_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","અહં યિરૂશાલમ્નગરે સ્વદેશીયલોકાનાં મધ્યે તિષ્ઠન્ આ યૌવનકાલાદ્ યદ્રૂપમ્ આચરિતવાન્ તદ્ યિહૂદીયલોકાઃ સર્વ્વે વિદન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","અસ્માકં સર્વ્વેભ્યઃ શુદ્ધતમં યત્ ફિરૂશીયમતં તદવલમ્બી ભૂત્વાહં કાલં યાપિતવાન્ યે જના આ બાલ્યકાલાન્ માં જાનાન્તિ તે એતાદૃશં સાક્ષ્યં યદિ દદાતિ તર્હિ દાતું શક્નુવન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","કિન્તુ હે આગ્રિપ્પરાજ ઈશ્વરોઽસ્માકં પૂર્વ્વપુરુષાણાં નિકટે યદ્ અઙ્ગીકૃતવાન્ તસ્ય પ્રત્યાશાહેતોરહમ્ ઇદાનીં વિચારસ્થાને દણ્ડાયમાનોસ્મિ| ");
INSERT INTO sanguj_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","તસ્યાઙ્ગીકારસ્ય ફલં પ્રાપ્તુમ્ અસ્માકં દ્વાદશવંશા દિવાનિશં મહાયત્નાદ્ ઈશ્વરસેવનં કૃત્વા યાં પ્રત્યાશાં કુર્વ્વન્તિ તસ્યાઃ પ્રત્યાશાયા હેતોરહં યિહૂદીયૈરપવાદિતોઽભવમ્| ");
INSERT INTO sanguj_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","ઈશ્વરો મૃતાન્ ઉત્થાપયિષ્યતીતિ વાક્યં યુષ્માકં નિકટેઽસમ્ભવં કુતો ભવેત્? ");
INSERT INTO sanguj_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","નાસરતીયયીશો ર્નામ્નો વિરુદ્ધં નાનાપ્રકારપ્રતિકૂલાચરણમ્ ઉચિતમ્ ઇત્યહં મનસિ યથાર્થં વિજ્ઞાય ");
INSERT INTO sanguj_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","યિરૂશાલમનગરે તદકરવં ફલતઃ પ્રધાનયાજકસ્ય નિકટાત્ ક્ષમતાં પ્રાપ્ય બહૂન્ પવિત્રલોકાન્ કારાયાં બદ્ધવાન્ વિશેષતસ્તેષાં હનનસમયે તેષાં વિરુદ્ધાં નિજાં સમ્મતિં પ્રકાશિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","વારં વારં ભજનભવનેષુ તેભ્યો દણ્ડં પ્રદત્તવાન્ બલાત્ તં ધર્મ્મં નિન્દયિતવાંશ્ચ પુનશ્ચ તાન્ પ્રતિ મહાક્રોધાદ્ ઉન્મત્તઃ સન્ વિદેશીયનગરાણિ યાવત્ તાન્ તાડિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","ઇત્થં પ્રધાનયાજકસ્ય સમીપાત્ શક્તિમ્ આજ્ઞાપત્રઞ્ચ લબ્ધ્વા દમ્મેષક્નગરં ગતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","તદાહં હે રાજન્ માર્ગમધ્યે મધ્યાહ્નકાલે મમ મદીયસઙ્ગિનાં લોકાનાઞ્ચ ચતસૃષુ દિક્ષુ ગગણાત્ પ્રકાશમાનાં ભાસ્કરતોપિ તેજસ્વતીં દીપ્તિં દૃષ્ટવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","તસ્માદ્ અસ્માસુ સર્વ્વેષુ ભૂમૌ પતિતેષુ સત્સુ હે શૌલ હૈ શૌલ કુતો માં તાડયસિ? કણ્ટકાનાં મુખે પાદાહનનં તવ દુઃસાધ્યમ્ ઇબ્રીયભાષયા ગદિત એતાદૃશ એકઃ શબ્દો મયા શ્રુતઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","તદાહં પૃષ્ટવાન્ હે પ્રભો કો ભવાન્? તતઃ સ કથિતવાન્ યં યીશું ત્વં તાડયસિ સોહં, ");
INSERT INTO sanguj_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","કિન્તુ સમુત્તિષ્ઠ ત્વં યદ્ દૃષ્ટવાન્ ઇતઃ પુનઞ્ચ યદ્યત્ ત્વાં દર્શયિષ્યામિ તેષાં સર્વ્વેષાં કાર્ય્યાણાં ત્વાં સાક્ષિણં મમ સેવકઞ્ચ કર્ત્તુમ્ દર્શનમ્ અદામ્| ");
INSERT INTO sanguj_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","વિશેષતો યિહૂદીયલોકેભ્યો ભિન્નજાતીયેભ્યશ્ચ ત્વાં મનોનીતં કૃત્વા તેષાં યથા પાપમોચનં ભવતિ ");
INSERT INTO sanguj_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","યથા તે મયિ વિશ્વસ્ય પવિત્રીકૃતાનાં મધ્યે ભાગં પ્રાપ્નુવન્તિ તદભિપ્રાયેણ તેષાં જ્ઞાનચક્ષૂંષિ પ્રસન્નાનિ કર્ત્તું તથાન્ધકારાદ્ દીપ્તિં પ્રતિ શૈતાનાધિકારાચ્ચ ઈશ્વરં પ્રતિ મતીઃ પરાવર્ત્તયિતું તેષાં સમીપં ત્વાં પ્રેષ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","હે આગ્રિપ્પરાજ એતાદૃશં સ્વર્ગીયપ્રત્યાદેશં અગ્રાહ્યમ્ અકૃત્વાહં ");
INSERT INTO sanguj_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","પ્રથમતો દમ્મેષક્નગરે તતો યિરૂશાલમિ સર્વ્વસ્મિન્ યિહૂદીયદેશે અન્યેષુ દેશેષુ ચ યેेન લોકા મતિં પરાવર્ત્ત્ય ઈશ્વરં પ્રતિ પરાવર્ત્તયન્તે, મનઃપરાવર્ત્તનયોગ્યાનિ કર્મ્માણિ ચ કુર્વ્વન્તિ તાદૃશમ્ ઉપદેશં પ્રચારિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","એતત્કારણાદ્ યિહૂદીયા મધ્યેમન્દિરં માં ધૃત્વા હન્તુમ્ ઉદ્યતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","તથાપિ ખ્રીષ્ટો દુઃખં ભુક્ત્વા સર્વ્વેષાં પૂર્વ્વં શ્મશાનાદ્ ઉત્થાય નિજદેશીયાનાં ભિન્નદેશીયાનાઞ્ચ સમીપે દીપ્તિં પ્રકાશયિષ્યતિ ");
INSERT INTO sanguj_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","ભવિષ્યદ્વાદિગણો મૂસાશ્ચ ભાવિકાર્ય્યસ્ય યદિદં પ્રમાણમ્ અદદુરેતદ્ વિનાન્યાં કથાં ન કથયિત્વા ઈશ્વરાદ્ અનુગ્રહં લબ્ધ્વા મહતાં ક્ષુદ્રાણાઞ્ચ સર્વ્વેષાં સમીપે પ્રમાણં દત્ત્વાદ્ય યાવત્ તિષ્ઠામિ| ");
INSERT INTO sanguj_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","તસ્યમાં કથાં નિશમ્ય ફીષ્ટ ઉચ્ચૈઃ સ્વરેણ કથિતવાન્ હે પૌલ ત્વમ્ ઉન્મત્તોસિ બહુવિદ્યાભ્યાસેન ત્વં હતજ્ઞાનો જાતઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","સ ઉક્તવાન્ હે મહામહિમ ફીષ્ટ નાહમ્ ઉન્મત્તઃ કિન્તુ સત્યં વિવેચનીયઞ્ચ વાક્યં પ્રસ્તૌમિ| ");
INSERT INTO sanguj_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","યસ્ય સાક્ષાદ્ અક્ષોભઃ સન્ કથાં કથયામિ સ રાજા તદ્વૃત્તાન્તં જાનાતિ તસ્ય સમીપે કિમપિ ગુપ્તં નેતિ મયા નિશ્ચિતં બુધ્યતે યતસ્તદ્ વિજને ન કૃતં| ");
INSERT INTO sanguj_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","હે આગ્રિપ્પરાજ ભવાન્ કિં ભવિષ્યદ્વાદિગણોક્તાનિ વાક્યાનિ પ્રત્યેતિ? ભવાન્ પ્રત્યેતિ તદહં જાનામિ| ");
INSERT INTO sanguj_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","તત આગ્રિપ્પઃ પૌલમ્ અભિહિતવાન્ ત્વં પ્રવૃત્તિં જનયિત્વા પ્રાયેણ મામપિ ખ્રીષ્ટીયં કરોષિ| ");
INSERT INTO sanguj_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","તતઃ સોઽવાદીત્ ભવાન્ યે યે લોકાશ્ચ મમ કથામ્ અદ્ય શૃણ્વન્તિ પ્રાયેણ ઇતિ નહિ કિન્ત્વેતત્ શૃઙ્ખલબન્ધનં વિના સર્વ્વથા તે સર્વ્વે માદૃશા ભવન્ત્વિતીશ્વસ્ય સમીપે પ્રાર્થયેઽહમ્| ");
INSERT INTO sanguj_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","એતસ્યાં કથાયાં કથિતાયાં સ રાજા સોઽધિપતિ ર્બર્ણીકી સભાસ્થા લોકાશ્ચ તસ્માદ્ ઉત્થાય ");
INSERT INTO sanguj_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ગોપને પરસ્પરં વિવિચ્ય કથિતવન્ત એષ જનો બન્ધનાર્હં પ્રાણહનનાર્હં વા કિમપિ કર્મ્મ નાકરોત્| ");
INSERT INTO sanguj_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","તત આગ્રિપ્પઃ ફીષ્ટમ્ અવદત્, યદ્યેષ માનુષઃ કૈસરસ્ય નિકટે વિચારિતો ભવિતું ન પ્રાર્થયિષ્યત્ તર્હિ મુક્તો ભવિતુમ્ અશક્ષ્યત્| ");
INSERT INTO sanguj_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","જલપથેનાસ્માકમ્ ઇતોલિયાદેશં પ્રતિ યાત્રાયાં નિશ્ચિતાયાં સત્યાં તે યૂલિયનામ્નો મહારાજસ્ય સંઘાતાન્તર્ગતસ્ય સેનાપતેઃ સમીપે પૌલં તદન્યાન્ કતિનયજનાંશ્ચ સમાર્પયન્| ");
INSERT INTO sanguj_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","વયમ્ આદ્રામુત્તીયં પોતમેકમ્ આરુહ્ય આશિયાદેશસ્ય તટસમીપેન યાતું મતિં કૃત્વા લઙ્ગરમ્ ઉત્થાપ્ય પોતમ્ અમોચયામ; માકિદનિયાદેશસ્થથિષલનીકીનિવાસ્યારિસ્તાર્ખનામા કશ્ચિદ્ જનોઽસ્માભિઃ સાર્દ્ધમ્ આસીત્| ");
INSERT INTO sanguj_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","પરસ્મિન્ દિવસે ઽસ્માભિઃ સીદોન્નગરે પોતે લાગિતે તત્ર યૂલિયઃ સેનાપતિઃ પૌલં પ્રતિ સૌજન્યં પ્રદર્થ્ય સાન્ત્વનાર્થં બન્ધુબાન્ધવાન્ ઉપયાતુમ્ અનુજજ્ઞૌ| ");
INSERT INTO sanguj_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","તસ્માત્ પોતે મોચિતે સતિ સમ્મુખવાયોઃ સમ્ભવાદ્ વયં કુપ્રોપદ્વીપસ્ય તીરસમીપેન ગતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","કિલિકિયાયાઃ પામ્ફૂલિયાયાશ્ચ સમુદ્રસ્ય પારં ગત્વા લૂકિયાદેશાન્તર્ગતં મુરાનગરમ્ ઉપાતિષ્ઠામ| ");
INSERT INTO sanguj_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","તત્સ્થાનાદ્ ઇતાલિયાદેશં ગચ્છતિ યઃ સિકન્દરિયાનગરસ્ય પોતસ્તં તત્ર પ્રાપ્ય શતસેનાપતિસ્તં પોતમ્ અસ્માન્ આરોહયત્| ");
INSERT INTO sanguj_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","તતઃ પરં બહૂનિ દિનાનિ શનૈઃ શનૈઃ ર્ગત્વા ક્નીદપાર્શ્વોપસ્થ્તિेઃ પૂર્વ્વં પ્રતિકૂલેન પવનેન વયં સલ્મોન્યાઃ સમ્મુખમ્ ઉપસ્થાય ક્રીત્યુપદ્વીપસ્ય તીરસમીપેન ગતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","કષ્ટેન તમુત્તીર્ય્ય લાસેયાનગરસ્યાધઃ સુન્દરનામકં ખાતમ્ ઉપાતિષ્ઠામ| ");
INSERT INTO sanguj_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","ઇત્થં બહુતિથઃ કાલો યાપિત ઉપવાસદિનઞ્ચાતીતં, તત્કારણાત્ નૌવર્ત્મનિ ભયઙ્કરે સતિ પૌલો વિનયેન કથિતવાન્, ");
INSERT INTO sanguj_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","હે મહેચ્છા અહં નિશ્ચયં જાનામિ યાત્રાયામસ્યામ્ અસ્માકં ક્લેશા બહૂનામપચયાશ્ચ ભવિષ્યન્તિ, તે કેવલં પોતસામગ્ર્યોરિતિ નહિ, કિન્ત્વસ્માકં પ્રાણાનામપિ| ");
INSERT INTO sanguj_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","તદા શતસેનાપતિઃ પૌैेલોક્તવાક્યતોપિ કર્ણધારસ્ય પોતવણિજશ્ચ વાક્યં બહુમંસ્ત| ");
INSERT INTO sanguj_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","તત્ ખાતં શીતકાલે વાસાર્હસ્થાનં ન તસ્માદ્ અવાચીપ્રતીચોર્દિશોઃ ક્રીત્યાઃ ફૈનીકિયખાતં યાતું યદિ શક્નુવન્તસ્તર્હિ તત્ર શીતકાલં યાપયિતું પ્રાયેણ સર્વ્વે મન્ત્રયામાસુઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","તતઃ પરં દક્ષિણવાયુ ર્મન્દં વહતીતિ વિલોક્ય નિજાભિપ્રાયસ્ય સિદ્ધેઃ સુયોગો ભવતીતિ બુદ્ધ્વા પોતં મોચયિત્વા ક્રીત્યુપદ્વીપસ્ય તીરસમીપેન ચલિતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","કિન્ત્વલ્પક્ષણાત્ પરમેવ ઉરક્લુદોન્નામા પ્રતિકૂલઃ પ્રચણ્ડો વાયુ ર્વહન્ પોતેઽલગીત્ ");
INSERT INTO sanguj_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","તસ્યાભિમુખં ગન્તુમ્ પોતસ્યાશક્તત્વાદ્ વયં વાયુના સ્વયં નીતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","અનન્તરં ક્લૌદીનામ્ન ઉપદ્વીપસ્ય કૂલસમીપેન પોતં ગમયિત્વા બહુના કષ્ટેન ક્ષુદ્રનાવમ્ અરક્ષામ| ");
INSERT INTO sanguj_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","તે તામારુહ્ય રજ્જ્ચા પોતસ્યાધોભાગમ્ અબધ્નન્ તદનન્તરં ચેત્ પોતો સૈકતે લગતીતિ ભયાદ્ વાતવસનાન્યમોચયન્ તતઃ પોતો વાયુના ચાલિતઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","કિન્તુ ક્રમશો વાયોઃ પ્રબલત્વાત્ પોતો દોલાયમાનોઽભવત્ પરસ્મિન્ દિવસે પોતસ્થાનિ કતિપયાનિ દ્રવ્યાણિ તોયે નિક્ષિપ્તાનિ| ");
INSERT INTO sanguj_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","તૃતીયદિવસે વયં સ્વહસ્તૈઃ પોતસજ્જનદ્રવ્યાણિ નિક્ષિપ્તવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","તતો બહુદિનાનિ યાવત્ સૂર્ય્યનક્ષત્રાદીનિ સમાચ્છન્નાનિ તતો ઽતીવ વાત્યાગમાદ્ અસ્માકં પ્રાણરક્ષાયાઃ કાપિ પ્રત્યાશા નાતિષ્ઠત્| ");
INSERT INTO sanguj_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","બહુદિનેષુ લોકૈરનાહારેણ યાપિતેષુ સર્વ્વેષાં સાક્ષત્ પૌલસ્તિષ્ઠન્ અકથયત્, હે મહેચ્છાઃ ક્રીત્યુપદ્વીપાત્ પોતં ન મોચયિતુમ્ અહં પૂર્વ્વં યદ્ અવદં તદ્ગ્રહણં યુષ્માકમ્ ઉચિતમ્ આસીત્ તથા કૃતે યુષ્માકમ્ એષા વિપદ્ એષોઽપચયશ્ચ નાઘટિષ્યેતામ્| ");
INSERT INTO sanguj_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","કિન્તુ સામ્પ્રતં યુષ્માન્ વિનીય બ્રવીમ્યહં, યૂયં ન ક્ષુભ્યત યુષ્માકમ્ એકસ્યાપિ પ્રાણિનો હાનિ ર્ન ભવિષ્યતિ, કેવલસ્ય પોતસ્ય હાનિ ર્ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","યતો યસ્યેશ્વરસ્ય લોકોઽહં યઞ્ચાહં પરિચરામિ તદીય એકો દૂતો હ્યો રાત્રૌ મમાન્તિકે તિષ્ઠન્ કથિતવાન્, ");
INSERT INTO sanguj_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","હે પૌલ મા ભૈષીઃ કૈસરસ્ય સમ્મુખે ત્વયોપસ્થાતવ્યં; તવૈતાન્ સઙ્ગિનો લોકાન્ ઈશ્વરસ્તુભ્યં દત્તવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","અતએવ હે મહેચ્છા યૂયં સ્થિરમનસો ભવત મહ્યં યા કથાકથિ સાવશ્યં ઘટિષ્યતે મમૈતાદૃશી વિશ્વાસ ઈશ્વરે વિદ્યતે, ");
INSERT INTO sanguj_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","કિન્તુ કસ્યચિદ્ ઉપદ્વીપસ્યોપરિ પતિતવ્યમ્ અસ્માભિઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","તતઃ પરમ્ આદ્રિયાસમુદ્રે પોતસ્તથૈવ દોલાયમાનઃ સન્ ઇતસ્તતો ગચ્છન્ ચતુર્દશદિવસસ્ય રાત્રે ર્દ્વિતીયપ્રહરસમયે કસ્યચિત્ સ્થલસ્ય સમીપમુપતિષ્ઠતીતિ પોતીયલોકા અન્વમન્યન્ત| ");
INSERT INTO sanguj_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","તતસ્તે જલં પરિમાય તત્ર વિંશતિ ર્વ્યામા જલાનીતિ જ્ઞાતવન્તઃ| કિઞ્ચિદ્દૂરં ગત્વા પુનરપિ જલં પરિમિતવન્તઃ| તત્ર પઞ્ચદશ વ્યામા જલાનિ દૃષ્ટ્વા ");
INSERT INTO sanguj_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","ચેત્ પાષાણે લગતીતિ ભયાત્ પોતસ્ય પશ્ચાદ્ભાગતશ્ચતુરો લઙ્ગરાન્ નિક્ષિપ્ય દિવાકરમ્ અપેક્ષ્ય સર્વ્વે સ્થિતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","કિન્તુ પોતીયલોકાઃ પોતાગ્રભાગે લઙ્ગરનિક્ષેપં છલં કૃત્વા જલધૌ ક્ષુદ્રનાવમ્ અવરોહ્ય પલાયિતુમ્ અચેષ્ટન્ત| ");
INSERT INTO sanguj_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","તતઃ પૌલઃ સેનાપતયે સૈન્યગણાય ચ કથિતવાન્, એતે યદિ પોતમધ્યે ન તિષ્ઠન્તિ તર્હિ યુષ્માકં રક્ષણં ન શક્યં| ");
INSERT INTO sanguj_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","તદા સેનાગણો રજ્જૂન્ છિત્વા નાવં જલે પતિતુમ્ અદદાત્| ");
INSERT INTO sanguj_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","પ્રભાતસમયે પૌલઃ સર્વ્વાન્ જનાન્ ભોજનાર્થં પ્રાર્થ્ય વ્યાહરત્, અદ્ય ચતુર્દશદિનાનિ યાવદ્ યૂયમ્ અપેક્ષમાના અનાહારાઃ કાલમ્ અયાપયત કિમપિ નાભુંગ્ધં| ");
INSERT INTO sanguj_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","અતો વિનયેेઽહં ભક્ષ્યં ભુજ્યતાં તતો યુષ્માકં મઙ્ગલં ભવિષ્યતિ, યુષ્માકં કસ્યચિજ્જનસ્ય શિરસઃ કેશૈકોપિ ન નંક્ષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","ઇતિ વ્યાહૃત્ય પૌલં પૂપં ગૃહીત્વેશ્વરં ધન્યં ભાષમાણસ્તં ભંક્ત્વા ભોક્તુમ્ આરબ્ધવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","અનન્તરં સર્વ્વે ચ સુસ્થિરાઃ સન્તઃ ખાદ્યાનિ પર્પ્યગૃહ્લન્| ");
INSERT INTO sanguj_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","અસ્માકં પોતે ષટ્સપ્તત્યધિકશતદ્વયલોકા આસન્| ");
INSERT INTO sanguj_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","સર્વ્વેષુ લોકેષુ યથેષ્ટં ભુક્તવત્સુ પોતસ્થન્ ગોધૂમાન્ જલધૌ નિક્ષિપ્ય તૈઃ પોતસ્ય ભારો લઘૂકૃતઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","દિને જાતેઽપિ સ કો દેશ ઇતિ તદા ન પર્ય્યચીયત; કિન્તુ તત્ર સમતટમ્ એકં ખાતં દૃષ્ટ્વા યદિ શક્નુમસ્તર્હિ વયં તસ્યાભ્યન્તરં પોતં ગમયામ ઇતિ મતિં કૃત્વા તે લઙ્ગરાન્ છિત્ત્વા જલધૌ ત્યક્તવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","તથા કર્ણબન્ધનં મોચયિત્વા પ્રધાનં વાતવસનમ્ ઉત્તોલ્ય તીરસમીપં ગતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","કિન્તુ દ્વયોઃ સમુદ્રયોઃ સઙ્ગમસ્થાને સૈકતોપરિ પોતે નિક્ષિપ્તે ઽગ્રભાગે બાધિતે પશ્ચાદ્ભાગે પ્રબલતરઙ્ગોઽલગત્ તેન પોતો ભગ્નઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","તસ્માદ્ બન્દયશ્ચેદ્ બાહુભિસ્તરન્તઃ પલાયન્તે ઇત્યાશઙ્કયા સેનાગણસ્તાન્ હન્તુમ્ અમન્ત્રયત્; ");
INSERT INTO sanguj_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","કિન્તુ શતસેનાપતિઃ પૌલં રક્ષિતું પ્રયત્નં કૃત્વા તાન્ તચ્ચેષ્ટાયા નિવર્ત્ય ઇત્યાદિષ્ટવાન્, યે બાહુતરણં જાનન્તિ તેઽગ્રે પ્રોલ્લમ્પ્ય સમુદ્રે પતિત્વા બાહુભિસ્તીર્ત્ત્વા કૂલં યાન્તુ| ");
INSERT INTO sanguj_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","અપરમ્ અવશિષ્ટા જનાઃ કાષ્ઠં પોતીયં દ્રવ્યં વા યેન યત્ પ્રાપ્યતે તદવલમ્બ્ય યાન્તુ; ઇત્થં સર્વ્વે ભૂમિં પ્રાપ્ય પ્રાણૈ ર્જીવિતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","ઇત્થં સર્વ્વેષુ રક્ષાં પ્રાપ્તેષુ તત્રત્યોપદ્વીપસ્ય નામ મિલીતેતિ તે જ્ઞાતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","અસભ્યલોકા યથેષ્ટમ્ અનુકમ્પાં કૃત્વા વર્ત્તમાનવૃષ્ટેઃ શીતાચ્ચ વહ્નિં પ્રજ્જ્વાલ્યાસ્માકમ્ આતિથ્યમ્ અકુર્વ્વન્| ");
INSERT INTO sanguj_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","કિન્તુ પૌલ ઇન્ધનાનિ સંગૃહ્ય યદા તસ્મિન્ અગ્રૌ નિરક્ષિપત્, તદા વહ્નેઃ પ્રતાપાત્ એકઃ કૃષ્ણસર્પો નિર્ગત્ય તસ્ય હસ્તે દ્રષ્ટવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","તેઽસભ્યલોકાસ્તસ્ય હસ્તે સર્પમ્ અવલમ્બમાનં દૃષ્ટ્વા પરસ્પરમ્ ઉક્તવન્ત એષ જનોઽવશ્યં નરહા ભવિષ્યતિ, યતો યદ્યપિ જલધે રક્ષાં પ્રાપ્તવાન્ તથાપિ પ્રતિફલદાયક એનં જીવિતું ન દદાતિ| ");
INSERT INTO sanguj_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","કિન્તુ સ હસ્તં વિધુન્વન્ તં સર્પમ્ અગ્નિમધ્યે નિક્ષિપ્ય કામપિ પીડાં નાપ્તવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","તતો વિષજ્વાલયા એતસ્ય શરીરં સ્ફીતં ભવિષ્યતિ યદ્વા હઠાદયં પ્રાણાન્ ત્યક્ષ્યતીતિ નિશ્ચિત્ય લોકા બહુક્ષણાનિ યાવત્ તદ્ દ્રષ્ટું સ્થિતવન્તઃ કિન્તુ તસ્ય કસ્યાશ્ચિદ્ વિપદોઽઘટનાત્ તે તદ્વિપરીતં વિજ્ઞાય ભાષિતવન્ત એષ કશ્ચિદ્ દેવો ભવેત્| ");
INSERT INTO sanguj_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","પુબ્લિયનામા જન એકસ્તસ્યોપદ્વીપસ્યાધિપતિરાસીત્ તત્ર તસ્ય ભૂમ્યાદિ ચ સ્થિતં| સ જનોઽસ્માન્ નિજગૃહં નીત્વા સૌજન્યં પ્રકાશ્ય દિનત્રયં યાવદ્ અસ્માકં આતિથ્યમ્ અકરોત્| ");
INSERT INTO sanguj_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","તદા તસ્ય પુબ્લિયસ્ય પિતા જ્વરાતિસારેણ પીડ્યમાનઃ સન્ શય્યાયામ્ આસીત્; તતઃ પૌલસ્તસ્ય સમીપં ગત્વા પ્રાર્થનાં કૃત્વા તસ્ય ગાત્રે હસ્તં સમર્પ્ય તં સ્વસ્થં કૃતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","ઇત્થં ભૂતે તદ્વીપનિવાસિન ઇતરેપિ રોગિલોકા આગત્ય નિરામયા અભવન્| ");
INSERT INTO sanguj_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","તસ્માત્તેઽસ્માકમ્ અતીવ સત્કારં કૃતવન્તઃ, વિશેષતઃ પ્રસ્થાનસમયે પ્રયોજનીયાનિ નાનદ્રવ્યાણિ દત્તવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","ઇત્થં તત્ર ત્રિષુ માસેષુ ગતેષુ યસ્ય ચિહ્નં દિયસ્કૂરી તાદૃશ એકઃ સિકન્દરીયનગરસ્ય પોતઃ શીતકાલં યાપયન્ તસ્મિન્ ઉપદ્વીપે ઽતિષ્ઠત્ તમેવ પોતં વયમ્ આરુહ્ય યાત્રામ્ અકુર્મ્મ| ");
INSERT INTO sanguj_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","તતઃ પ્રથમતઃ સુરાકૂસનગરમ્ ઉપસ્થાય તત્ર ત્રીણિ દિનાનિ સ્થિતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","તસ્માદ્ આવૃત્ય રીગિયનગરમ્ ઉપસ્થિતાઃ દિનૈકસ્માત્ પરં દક્ષિણવયૌ સાનુકૂલ્યે સતિ પરસ્મિન્ દિવસે પતિયલીનગરમ્ ઉપાતિષ્ઠામ| ");
INSERT INTO sanguj_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","તતોઽસ્માસુ તત્રત્યં ભ્રાતૃગણં પ્રાપ્તેષુ તે સ્વૈઃ સાર્દ્ધમ્ અસ્માન્ સપ્ત દિનાનિ સ્થાપયિતુમ્ અયતન્ત, ઇત્થં વયં રોમાનગરમ્ પ્રત્યગચ્છામ| ");
INSERT INTO sanguj_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","તસ્માત્ તત્રત્યાઃ ભ્રાતરોઽસ્માકમ્ આગમનવાર્ત્તાં શ્રુત્વા આપ્પિયફરં ત્રિષ્ટાવર્ણીઞ્ચ યાવદ્ અગ્રેસરાઃ સન્તોસ્માન્ સાક્ષાત્ કર્ત્તુમ્ આગમન્; તેષાં દર્શનાત્ પૌલ ઈશ્વરં ધન્યં વદન્ આશ્વાસમ્ આપ્તવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","અસ્માસુ રોમાનગરં ગતેષુ શતસેનાપતિઃ સર્વ્વાન્ બન્દીન્ પ્રધાનસેનાપતેઃ સમીપે સમાર્પયત્ કિન્તુ પૌલાય સ્વરક્ષકપદાતિના સહ પૃથગ્ વસ્તુમ્ અનુમતિં દત્તવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","દિનત્રયાત્ પરં પૌલસ્તદ્દેશસ્થાન્ પ્રધાનયિહૂદિન આહૂતવાન્ તતસ્તેષુ સમુપસ્થિતેષુ સ કથિતવાન્, હે ભ્રાતૃગણ નિજલોકાનાં પૂર્વ્વપુરુષાણાં વા રીતે ર્વિપરીતં કિઞ્ચન કર્મ્માહં નાકરવં તથાપિ યિરૂશાલમનિવાસિનો લોકા માં બન્દિં કૃત્વા રોમિલોકાનાં હસ્તેષુ સમર્પિતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","રોમિલોકા વિચાર્ય્ય મમ પ્રાણહનનાર્હં કિમપિ કારણં ન પ્રાપ્ય માં મોચયિતુમ્ ઐચ્છન્; ");
INSERT INTO sanguj_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","કિન્તુ યિહૂદિલોકાનામ્ આપત્ત્યા મયા કૈસરરાજસ્ય સમીપે વિચારસ્ય પ્રાર્થના કર્ત્તવ્યા જાતા નોચેત્ નિજદેશીયલોકાન્ પ્રતિ મમ કોપ્યભિયોગો નાસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","એતત્કારણાદ્ અહં યુષ્માન્ દ્રષ્ટું સંલપિતુઞ્ચાહૂયમ્ ઇસ્રાયેલ્વશીયાનાં પ્રત્યાશાહેતોહમ્ એતેન શુઙ્ખલેન બદ્ધોઽભવમ્| ");
INSERT INTO sanguj_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","તદા તે તમ્ અવાદિષુઃ, યિહૂદીયદેશાદ્ વયં ત્વામધિ કિમપિ પત્રં ન પ્રાપ્તા યે ભ્રાતરઃ સમાયાતાસ્તેષાં કોપિ તવ કામપિ વાર્ત્તાં નાવદત્ અભદ્રમપિ નાકથયચ્ચ| ");
INSERT INTO sanguj_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","તવ મતં કિમિતિ વયં ત્વત્તઃ શ્રોતુમિચ્છામઃ| યદ્ ઇદં નવીનં મતમુત્થિતં તત્ સર્વ્વત્ર સર્વ્વેષાં નિકટે નિન્દિતં જાતમ ઇતિ વયં જાનીમઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","તૈસ્તદર્થમ્ એકસ્મિન્ દિને નિરૂપિતે તસ્મિન્ દિને બહવ એકત્ર મિલિત્વા પૌલસ્ય વાસગૃહમ્ આગચ્છન્ તસ્માત્ પૌલ આ પ્રાતઃકાલાત્ સન્ધ્યાકાલં યાવન્ મૂસાવ્યવસ્થાગ્રન્થાદ્ ભવિષ્યદ્વાદિનાં ગ્રન્થેભ્યશ્ચ યીશોઃ કથામ્ ઉત્થાપ્ય ઈશ્વરસ્ય રાજ્યે પ્રમાણં દત્વા તેષાં પ્રવૃત્તિં જનયિતું ચેષ્ટિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","કેચિત્તુ તસ્ય કથાં પ્રત્યાયન્ કેચિત્તુ ન પ્રત્યાયન્; ");
INSERT INTO sanguj_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","એતત્કારણાત્ તેષાં પરસ્પરમ્ અનૈક્યાત્ સર્વ્વે ચલિતવન્તઃ; તથાપિ પૌલ એતાં કથામેકાં કથિતવાન્ પવિત્ર આત્મા યિશયિયસ્ય ભવિષ્યદ્વક્તુ ર્વદનાદ્ અસ્માકં પિતૃપુરુષેભ્ય એતાં કથાં ભદ્રં કથયામાસ, યથા, ");
INSERT INTO sanguj_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","\"ઉપગત્ય જનાનેતાન્ ત્વં ભાષસ્વ વચસ્ત્વિદં| કર્ણૈઃ શ્રોષ્યથ યૂયં હિ કિન્તુ યૂયં ન ભોત્સ્યથ| નેત્રૈ ર્દ્રક્ષ્યથ યૂયઞ્ચ જ્ઞાતું યૂયં ન શક્ષ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","તે માનુષા યથા નેત્રૈઃ પરિપશ્યન્તિ નૈવ હિ| કર્ણૈઃ ર્યથા ન શૃણ્વન્તિ બુધ્યન્તે ન ચ માનસૈઃ| વ્યાવર્ત્તયત્સુ ચિત્તાનિ કાલે કુત્રાપિ તેષુ વૈ| મત્તસ્તે મનુજાઃ સ્વસ્થા યથા નૈવ ભવન્તિ ચ| તથા તેષાં મનુષ્યાણાં સન્તિ સ્થૂલા હિ બુદ્ધયઃ| બધિરીભૂતકર્ણાશ્ચ જાતાશ્ચ મુદ્રિતા દૃશઃ|| ");
INSERT INTO sanguj_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","અત ઈશ્વરાદ્ યત્ પરિત્રાણં તસ્ય વાર્ત્તા ભિન્નદેશીયાનાં સમીપં પ્રેષિતા તએવ તાં ગ્રહીષ્યન્તીતિ યૂયં જાનીત| ");
INSERT INTO sanguj_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","એતાદૃશ્યાં કથાયાં કથિતાયાં સત્યાં યિહૂદિનઃ પરસ્પરં બહુવિચારં કુર્વ્વન્તો ગતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","ઇત્થં પૌલઃ સમ્પૂર્ણં વત્સરદ્વયં યાવદ્ ભાટકીયે વાસગૃહે વસન્ યે લોકાસ્તસ્ય સન્નિધિમ્ આગચ્છન્તિ તાન્ સર્વ્વાનેવ પરિગૃહ્લન્, ");
INSERT INTO sanguj_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","નિર્વિઘ્નમ્ અતિશયનિઃક્ષોભમ્ ઈશ્વરીયરાજત્વસ્ય કથાં પ્રચારયન્ પ્રભૌ યીશૌ ખ્રીષ્ટે કથાઃ સમુપાદિશત્| ઇતિ||");
INSERT INTO sanguj_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","ઈશ્વરો નિજપુત્રમધિ યં સુસંવાદં ભવિષ્યદ્વાદિભિ ર્ધર્મ્મગ્રન્થે પ્રતિશ્રુતવાન્ તં સુસંવાદં પ્રચારયિતું પૃથક્કૃત આહૂતઃ પ્રેરિતશ્ચ પ્રભો ર્યીશુખ્રીષ્ટસ્ય સેવકો યઃ પૌલઃ ");
INSERT INTO sanguj_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","સ રોમાનગરસ્થાન્ ઈશ્વરપ્રિયાન્ આહૂતાંશ્ચ પવિત્રલોકાન્ પ્રતિ પત્રં લિખતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","અસ્માકં સ પ્રભુ ર્યીશુઃ ખ્રીષ્ટઃ શારીરિકસમ્બન્ધેન દાયૂદો વંશોદ્ભવઃ ");
INSERT INTO sanguj_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","પવિત્રસ્યાત્મનઃ સમ્બન્ધેન ચેશ્વરસ્ય પ્રભાવવાન્ પુત્ર ઇતિ શ્મશાનાત્ તસ્યોત્થાનેન પ્રતિપન્નં| ");
INSERT INTO sanguj_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","અપરં યેષાં મધ્યે યીશુના ખ્રીષ્ટેન યૂયમપ્યાહૂતાસ્તે ઽન્યદેશીયલોકાસ્તસ્ય નામ્નિ વિશ્વસ્ય નિદેશગ્રાહિણો યથા ભવન્તિ ");
INSERT INTO sanguj_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","તદભિપ્રાયેણ વયં તસ્માદ્ અનુગ્રહં પ્રેરિતત્વપદઞ્ચ પ્રાપ્તાઃ| ");
INSERT INTO sanguj_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","તાતેનાસ્માકમ્ ઈશ્વરેણ પ્રભુણા યીશુખ્રીષ્ટેન ચ યુષ્મભ્યમ્ અનુગ્રહઃ શાન્તિશ્ચ પ્રદીયેતાં| ");
INSERT INTO sanguj_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","પ્રથમતઃ સર્વ્વસ્મિન્ જગતિ યુષ્માકં વિશ્વાસસ્ય પ્રકાશિતત્વાદ્ અહં યુષ્માકં સર્વ્વેષાં નિમિત્તં યીશુખ્રીષ્ટસ્ય નામ ગૃહ્લન્ ઈશ્વરસ્ય ધન્યવાદં કરોમિ| ");
INSERT INTO sanguj_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","અપરમ્ ઈશ્વરસ્ય પ્રસાદાદ્ બહુકાલાત્ પરં સામ્પ્રતં યુષ્માકં સમીપં યાતું કથમપિ યત્ સુયોગં પ્રાપ્નોમિ, એતદર્થં નિરન્તરં નામાન્યુચ્ચારયન્ નિજાસુ સર્વ્વપ્રાર્થનાસુ સર્વ્વદા નિવેદયામિ, ");
INSERT INTO sanguj_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","એતસ્મિન્ યમહં તત્પુત્રીયસુસંવાદપ્રચારણેન મનસા પરિચરામિ સ ઈશ્વરો મમ સાક્ષી વિદ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","યતો યુષ્માકં મમ ચ વિશ્વાસેન વયમ્ ઉભયે યથા શાન્તિયુક્તા ભવામ ઇતિ કારણાદ્ ");
INSERT INTO sanguj_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","યુષ્માકં સ્થૈર્ય્યકરણાર્થં યુષ્મભ્યં કિઞ્ચિત્પરમાર્થદાનદાનાય યુષ્માન્ સાક્ષાત્ કર્ત્તું મદીયા વાઞ્છા| ");
INSERT INTO sanguj_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","હે ભ્રાતૃગણ ભિન્નદેશીયલોકાનાં મધ્યે યદ્વત્ તદ્વદ્ યુષ્માકં મધ્યેપિ યથા ફલં ભુઞ્જે તદભિપ્રાયેણ મુહુર્મુહુ ર્યુષ્માકં સમીપં ગન્તુમ્ ઉદ્યતોઽહં કિન્તુ યાવદ્ અદ્ય તસ્મિન્ ગમને મમ વિઘ્નો જાત ઇતિ યૂયં યદ્ અજ્ઞાતાસ્તિષ્ઠથ તદહમ્ ઉચિતં ન બુધ્યે| ");
INSERT INTO sanguj_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","અહં સભ્યાસભ્યાનાં વિદ્વદવિદ્વતાઞ્ચ સર્વ્વેષામ્ ઋણી વિદ્યે| ");
INSERT INTO sanguj_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","અતએવ રોમાનિવાસિનાં યુષ્માકં સમીપેઽપિ યથાશક્તિ સુસંવાદં પ્રચારયિતુમ્ અહમ્ ઉદ્યતોસ્મિ| ");
INSERT INTO sanguj_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","યતઃ ખ્રીષ્ટસ્ય સુસંવાદો મમ લજ્જાસ્પદં નહિ સ ઈશ્વરસ્ય શક્તિસ્વરૂપઃ સન્ આ યિહૂદીયેભ્યો ઽન્યજાતીયાન્ યાવત્ સર્વ્વજાતીયાનાં મધ્યે યઃ કશ્ચિદ્ તત્ર વિશ્વસિતિ તસ્યૈવ ત્રાણં જનયતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","યતઃ પ્રત્યયસ્ય સમપરિમાણમ્ ઈશ્વરદત્તં પુણ્યં તત્સુસંવાદે પ્રકાશતે| તદધિ ધર્મ્મપુસ્તકેપિ લિખિતમિદં \"પુણ્યવાન્ જનો વિશ્વાસેન જીવિષ્યતિ\"| ");
INSERT INTO sanguj_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","અતએવ યે માનવાઃ પાપકર્મ્મણા સત્યતાં રુન્ધન્તિ તેષાં સર્વ્વસ્ય દુરાચરણસ્યાધર્મ્મસ્ય ચ વિરુદ્ધં સ્વર્ગાદ્ ઈશ્વરસ્ય કોપઃ પ્રકાશતે| ");
INSERT INTO sanguj_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","યત ઈશ્વરમધિ યદ્યદ્ જ્ઞેયં તદ્ ઈશ્વરઃ સ્વયં તાન્ પ્રતિ પ્રકાશિતવાન્ તસ્માત્ તેષામ્ અગોચરં નહિ| ");
INSERT INTO sanguj_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","ફલતસ્તસ્યાનન્તશક્તીશ્વરત્વાદીન્યદૃશ્યાન્યપિ સૃષ્ટિકાલમ્ આરભ્ય કર્મ્મસુ પ્રકાશમાનાનિ દૃશ્યન્તે તસ્માત્ તેષાં દોષપ્રક્ષાલનસ્ય પન્થા નાસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","અપરમ્ ઈશ્વરં જ્ઞાત્વાપિ તે તમ્ ઈશ્વરજ્ઞાનેન નાદ્રિયન્ત કૃતજ્ઞા વા ન જાતાઃ; તસ્માત્ તેષાં સર્વ્વે તર્કા વિફલીભૂતાઃ, અપરઞ્ચ તેષાં વિવેકશૂન્યાનિ મનાંસિ તિમિરે મગ્નાનિ| ");
INSERT INTO sanguj_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","તે સ્વાન્ જ્ઞાનિનો જ્ઞાત્વા જ્ઞાનહીના અભવન્ ");
INSERT INTO sanguj_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","અનશ્વરસ્યેશ્વરસ્ય ગૌરવં વિહાય નશ્વરમનુષ્યપશુપક્ષ્યુરોગામિપ્રભૃતેરાકૃતિવિશિષ્ટપ્રતિમાસ્તૈરાશ્રિતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","ઇત્થં ત ઈશ્વરસ્ય સત્યતાં વિહાય મૃષામતમ્ આશ્રિતવન્તઃ સચ્ચિદાનન્દં સૃષ્ટિકર્ત્તારં ત્યક્ત્વા સૃષ્ટવસ્તુનઃ પૂજાં સેવાઞ્ચ કૃતવન્તઃ; ");
INSERT INTO sanguj_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","ઇતિ હેતોરીશ્વરસ્તાન્ કુક્રિયાયાં સમર્પ્ય નિજનિજકુચિન્તાભિલાષાભ્યાં સ્વં સ્વં શરીરં પરસ્પરમ્ અપમાનિતં કર્ત્તુમ્ અદદાત્| ");
INSERT INTO sanguj_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","ઈશ્વરેણ તેષુ ક્વભિલાષે સમર્પિતેષુ તેષાં યોષિતઃ સ્વાભાવિકાચરણમ્ અપહાય વિપરીતકૃત્યે પ્રાવર્ત્તન્ત; ");
INSERT INTO sanguj_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","તથા પુરુષા અપિ સ્વાભાવિકયોષિત્સઙ્ગમં વિહાય પરસ્પરં કામકૃશાનુના દગ્ધાઃ સન્તઃ પુમાંસઃ પુંભિઃ સાકં કુકૃત્યે સમાસજ્ય નિજનિજભ્રાન્તેઃ સમુચિતં ફલમ્ અલભન્ત| ");
INSERT INTO sanguj_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","તે સ્વેષાં મનઃસ્વીશ્વરાય સ્થાનં દાતુમ્ અનિચ્છુકાસ્તતો હેતોરીશ્વરસ્તાન્ પ્રતિ દુષ્ટમનસ્કત્વમ્ અવિહિતક્રિયત્વઞ્ચ દત્તવાન્| ");
INSERT INTO sanguj_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","અતએવ તે સર્વ્વે ઽન્યાયો વ્યભિચારો દુષ્ટત્વં લોભો જિઘાંસા ઈર્ષ્યા વધો વિવાદશ્ચાતુરી કુમતિરિત્યાદિભિ ર્દુષ્કર્મ્મભિઃ પરિપૂર્ણાઃ સન્તઃ ");
INSERT INTO sanguj_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","કર્ણેજપા અપવાદિન ઈશ્વરદ્વેષકા હિંસકા અહઙ્કારિણ આત્મશ્લાઘિનઃ કુકર્મ્મોત્પાદકાઃ પિત્રોરાજ્ઞાલઙ્ઘકા ");
INSERT INTO sanguj_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","અવિચારકા નિયમલઙ્ઘિનઃ સ્નેહરહિતા અતિદ્વેષિણો નિર્દયાશ્ચ જાતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","યે જના એતાદૃશં કર્મ્મ કુર્વ્વન્તિ તએવ મૃતિયોગ્યા ઈશ્વરસ્ય વિચારમીદૃશં જ્ઞાત્વાપિ ત એતાદૃશં કર્મ્મ સ્વયં કુર્વ્વન્તિ કેવલમિતિ નહિ કિન્તુ તાદૃશકર્મ્મકારિષુ લોકેષ્વપિ પ્રીયન્તે| ");
INSERT INTO sanguj_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","હે પરદૂષક મનુષ્ય યઃ કશ્ચન ત્વં ભવસિ તવોત્તરદાનાય પન્થા નાસ્તિ યતો યસ્માત્ કર્મ્મણઃ પરસ્ત્વયા દૂષ્યતે તસ્માત્ ત્વમપિ દૂષ્યસે, યતસ્તં દૂષયન્નપિ ત્વં તદ્વદ્ આચરસિ| ");
INSERT INTO sanguj_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","કિન્ત્વેતાદૃગાચારિભ્યો યં દણ્ડમ્ ઈશ્વરો નિશ્ચિનોતિ સ યથાર્થ ઇતિ વયં જાનીમઃ| ");
INSERT INTO sanguj_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","અતએવ હે માનુષ ત્વં યાદૃગાચારિણો દૂષયસિ સ્વયં યદિ તાદૃગાચરસિ તર્હિ ત્વમ્ ઈશ્વરદણ્ડાત્ પલાયિતું શક્ષ્યસીતિ કિં બુધ્યસે? ");
INSERT INTO sanguj_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","અપરં તવ મનસઃ પરિવર્ત્તનં કર્ત્તુમ્ ઇશ્વરસ્યાનુગ્રહો ભવતિ તન્ન બુદ્ધ્વા ત્વં કિં તદીયાનુગ્રહક્ષમાચિરસહિષ્ણુત્વનિધિં તુચ્છીકરોષિ? ");
INSERT INTO sanguj_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","તથા સ્વાન્તઃકરણસ્ય કઠોરત્વાત્ ખેદરાહિત્યાચ્ચેશ્વરસ્ય ન્યાય્યવિચારપ્રકાશનસ્ય ક્રોધસ્ય ચ દિનં યાવત્ કિં સ્વાર્થં કોપં સઞ્ચિનોષિ? ");
INSERT INTO sanguj_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","કિન્તુ સ એકૈકમનુજાય તત્કર્મ્માનુસારેણ પ્રતિફલં દાસ્યતિ; ");
INSERT INTO sanguj_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","વસ્તુતસ્તુ યે જના ધૈર્ય્યં ધૃત્વા સત્કર્મ્મ કુર્વ્વન્તો મહિમા સત્કારોઽમરત્વઞ્ચૈતાનિ મૃગયન્તે તેભ્યોઽનન્તાયુ ર્દાસ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","અપરં યે જનાઃ સત્યધર્મ્મમ્ અગૃહીત્વા વિપરીતધર્મ્મમ્ ગૃહ્લન્તિ તાદૃશા વિરોધિજનાઃ કોપં ક્રોધઞ્ચ ભોક્ષ્યન્તે| ");
INSERT INTO sanguj_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","આ યિહૂદિનોઽન્યદેશિનઃ પર્ય્યન્તં યાવન્તઃ કુકર્મ્મકારિણઃ પ્રાણિનઃ સન્તિ તે સર્વ્વે દુઃખં યાતનાઞ્ચ ગમિષ્યન્તિ; ");
INSERT INTO sanguj_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","કિન્તુ આ યિહૂદિનો ભિન્નદેશિપર્ય્યન્તા યાવન્તઃ સત્કર્મ્મકારિણો લોકાઃ સન્તિ તાન્ પ્રતિ મહિમા સત્કારઃ શાન્તિશ્ચ ભવિષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","ઈશ્વરસ્ય વિચારે પક્ષપાતો નાસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","અલબ્ધવ્યવસ્થાશાસ્ત્રૈ ર્યૈઃ પાપાનિ કૃતાનિ વ્યવસ્થાશાસ્ત્રાલબ્ધત્વાનુરૂપસ્તેષાં વિનાશો ભવિષ્યતિ; કિન્તુ લબ્ધવ્યવસ્થાશાસ્ત્રા યે પાપાન્યકુર્વ્વન્ વ્યવસ્થાનુસારાદેવ તેષાં વિચારો ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","વ્યવસ્થાશ્રોતાર ઈશ્વરસ્ય સમીપે નિષ્પાપા ભવિષ્યન્તીતિ નહિ કિન્તુ વ્યવસ્થાચારિણ એવ સપુણ્યા ભવિષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","યતો ઽલબ્ધવ્યવસ્થાશાસ્ત્રા ભિન્નદેશીયલોકા યદિ સ્વભાવતો વ્યવસ્થાનુરૂપાન્ આચારાન્ કુર્વ્વન્તિ તર્હ્યલબ્ધશાસ્ત્રાઃ સન્તોઽપિ તે સ્વેષાં વ્યવસ્થાશાસ્ત્રમિવ સ્વયમેવ ભવન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","તેષાં મનસિ સાક્ષિસ્વરૂપે સતિ તેષાં વિતર્કેષુ ચ કદા તાન્ દોષિણઃ કદા વા નિર્દોષાન્ કૃતવત્સુ તે સ્વાન્તર્લિખિતસ્ય વ્યવસ્થાશાસ્ત્રસ્ય પ્રમાણં સ્વયમેવ દદતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","યસ્મિન્ દિને મયા પ્રકાશિતસ્ય સુસંવાદસ્યાનુસારાદ્ ઈશ્વરો યીશુખ્રીષ્ટેન માનુષાણામ્ અન્તઃકરણાનાં ગૂઢાભિપ્રાયાન્ ધૃત્વા વિચારયિષ્યતિ તસ્મિન્ વિચારદિને તત્ પ્રકાશિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","પશ્ય ત્વં સ્વયં યિહૂદીતિ વિખ્યાતો વ્યવસ્થોપરિ વિશ્વાસં કરોષિ, ");
INSERT INTO sanguj_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ઈશ્વરમુદ્દિશ્ય સ્વં શ્લાઘસે, તથા વ્યવસ્થયા શિક્ષિતો ભૂત્વા તસ્યાભિમતં જાનાસિ, સર્વ્વાસાં કથાનાં સારં વિવિંક્ષે, ");
INSERT INTO sanguj_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","અપરં જ્ઞાનસ્ય સત્યતાયાશ્ચાકરસ્વરૂપં શાસ્ત્રં મમ સમીપે વિદ્યત અતો ઽન્ધલોકાનાં માર્ગદર્શયિતા ");
INSERT INTO sanguj_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","તિમિરસ્થિતલોકાનાં મધ્યે દીપ્તિસ્વરૂપોઽજ્ઞાનલોકેભ્યો જ્ઞાનદાતા શિશૂનાં શિક્ષયિતાહમેવેતિ મન્યસે| ");
INSERT INTO sanguj_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","પરાન્ શિક્ષયન્ સ્વયં સ્વં કિં ન શિક્ષયસિ? વસ્તુતશ્ચૌર્ય્યનિષેધવ્યવસ્થાં પ્રચારયન્ ત્વં કિં સ્વયમેવ ચોરયસિ? ");
INSERT INTO sanguj_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","તથા પરદારગમનં પ્રતિષેધન્ સ્વયં કિં પરદારાન્ ગચ્છસિ? તથા ત્વં સ્વયં પ્રતિમાદ્વેષી સન્ કિં મન્દિરસ્ય દ્રવ્યાણિ હરસિ? ");
INSERT INTO sanguj_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","યસ્ત્વં વ્યવસ્થાં શ્લાઘસે સ ત્વં કિં વ્યવસ્થામ્ અવમત્ય નેશ્વરં સમ્મન્યસે? ");
INSERT INTO sanguj_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","શાસ્ત્રે યથા લિખતિ \"ભિન્નદેશિનાં સમીપે યુષ્માકં દોષાદ્ ઈશ્વરસ્ય નામ્નો નિન્દા ભવતિ| \" ");
INSERT INTO sanguj_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","યદિ વ્યવસ્થાં પાલયસિ તર્હિ તવ ત્વક્છેદક્રિયા સફલા ભવતિ; યતિ વ્યવસ્થાં લઙ્ઘસે તર્હિ તવ ત્વક્છેદોઽત્વક્છેદો ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","યતો વ્યવસ્થાશાસ્ત્રાદિષ્ટધર્મ્મકર્મ્માચારી પુમાન્ અત્વક્છેદી સન્નપિ કિં ત્વક્છેદિનાં મધ્યે ન ગણયિષ્યતે? ");
INSERT INTO sanguj_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","કિન્તુ લબ્ધશાસ્ત્રશ્છિન્નત્વક્ ચ ત્વં યદિ વ્યવસ્થાલઙ્ઘનં કરોષિ તર્હિ વ્યવસ્થાપાલકાઃ સ્વાભાવિકાચ્છિન્નત્વચો લોકાસ્ત્વાં કિં ન દૂષયિષ્યન્તિ? ");
INSERT INTO sanguj_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","તસ્માદ્ યો બાહ્યે યિહૂદી સ યિહૂદી નહિ તથાઙ્ગસ્ય યસ્ત્વક્છેદઃ સ ત્વક્છેદો નહિ; ");
INSERT INTO sanguj_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","કિન્તુ યો જન આન્તરિકો યિહૂદી સ એવ યિહૂદી અપરઞ્ચ કેવલલિખિતયા વ્યવસ્થયા ન કિન્તુ માનસિકો યસ્ત્વક્છેદો યસ્ય ચ પ્રશંસા મનુષ્યેભ્યો ન ભૂત્વા ઈશ્વરાદ્ ભવતિ સ એવ ત્વક્છેદઃ| ");
INSERT INTO sanguj_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","અપરઞ્ચ યિહૂદિનઃ કિં શ્રેષ્ઠત્વં? તથા ત્વક્છેદસ્ય વા કિં ફલં? ");
INSERT INTO sanguj_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","સર્વ્વથા બહૂનિ ફલાનિ સન્તિ, વિશેષત ઈશ્વરસ્ય શાસ્ત્રં તેભ્યોઽદીયત| ");
INSERT INTO sanguj_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","કૈશ્ચિદ્ અવિશ્વસને કૃતે તેષામ્ અવિશ્વસનાત્ કિમ્ ઈશ્વરસ્ય વિશ્વાસ્યતાયા હાનિરુત્પત્સ્યતે? ");
INSERT INTO sanguj_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","કેનાપિ પ્રકારેણ નહિ| યદ્યપિ સર્વ્વે મનુષ્યા મિથ્યાવાદિનસ્તથાપીશ્વરઃ સત્યવાદી| શાસ્ત્રે યથા લિખિતમાસ્તે, અતસ્ત્વન્તુ સ્વવાક્યેન નિર્દ્દોષો હિ ભવિષ્યસિ| વિચારે ચૈવ નિષ્પાપો ભવિષ્યસિ ન સંશયઃ| ");
INSERT INTO sanguj_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","અસ્માકમ્ અન્યાયેન યદીશ્વરસ્ય ન્યાયઃ પ્રકાશતે તર્હિ કિં વદિષ્યામઃ? અહં માનુષાણાં કથામિવ કથાં કથયામિ, ઈશ્વરઃ સમુચિતં દણ્ડં દત્ત્વા કિમ્ અન્યાયી ભવિષ્યતિ? ");
INSERT INTO sanguj_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","ઇત્થં ન ભવતુ, તથા સતીશ્વરઃ કથં જગતો વિચારયિતા ભવિષ્યતિ? ");
INSERT INTO sanguj_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","મમ મિથ્યાવાક્યવદનાદ્ યદીશ્વરસ્ય સત્યત્વેન તસ્ય મહિમા વર્દ્ધતે તર્હિ કસ્માદહં વિચારેઽપરાધિત્વેન ગણ્યો ભવામિ? ");
INSERT INTO sanguj_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","મઙ્ગલાર્થં પાપમપિ કરણીયમિતિ વાક્યં ત્વયા કુતો નોચ્યતે? કિન્તુ યૈરુચ્યતે તે નિતાન્તં દણ્ડસ્ય પાત્રાણિ ભવન્તિ; તથાપિ તદ્વાક્યમ્ અસ્માભિરપ્યુચ્યત ઇત્યસ્માકં ગ્લાનિં કુર્વ્વન્તઃ કિયન્તો લોકા વદન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","અન્યલોકેભ્યો વયં કિં શ્રેષ્ઠાઃ? કદાચન નહિ યતો યિહૂદિનો ઽન્યદેશિનશ્ચ સર્વ્વએવ પાપસ્યાયત્તા ઇત્યસ્ય પ્રમાણં વયં પૂર્વ્વમ્ અદદામ| ");
INSERT INTO sanguj_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","લિપિ ર્યથાસ્તે, નૈકોપિ ધાર્મ્મિકો જનઃ| ");
INSERT INTO sanguj_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","તથા જ્ઞાનીશ્વરજ્ઞાની માનવઃ કોપિ નાસ્તિ હિ| ");
INSERT INTO sanguj_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","વિમાર્ગગામિનઃ સર્વ્વે સર્વ્વે દુષ્કર્મ્મકારિણઃ| એકો જનોપિ નો તેષાં સાધુકર્મ્મ કરોતિ ચ| ");
INSERT INTO sanguj_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","તથા તેષાન્તુ વૈ કણ્ઠા અનાવૃતશ્મશાનવત્| સ્તુતિવાદં પ્રકુર્વ્વન્તિ જિહ્વાભિસ્તે તુ કેવલં| તેષામોષ્ઠસ્ય નિમ્ને તુ વિષં તિષ્ઠતિ સર્પ્પવત્| ");
INSERT INTO sanguj_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","મુખં તેષાં હિ શાપેન કપટેન ચ પૂર્ય્યતે| ");
INSERT INTO sanguj_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","રક્તપાતાય તેષાં તુ પદાનિ ક્ષિપ્રગાનિ ચ| ");
INSERT INTO sanguj_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","પથિ તેષાં મનુષ્યાણાં નાશઃ ક્લેશશ્ચ કેવલઃ| ");
INSERT INTO sanguj_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","તે જના નહિ જાનન્તિ પન્થાનં સુખદાયિનં| ");
INSERT INTO sanguj_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","પરમેશાદ્ ભયં યત્તત્ તચ્ચક્ષુષોરગોચરં| ");
INSERT INTO sanguj_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","વ્યવસ્થાયાં યદ્યલ્લિખતિ તદ્ વ્યવસ્થાધીનાન્ લોકાન્ ઉદ્દિશ્ય લિખતીતિ વયં જાનીમઃ| તતો મનુષ્યમાત્રો નિરુત્તરઃ સન્ ઈશ્વરસ્ય સાક્ષાદ્ અપરાધી ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","અતએવ વ્યવસ્થાનુરૂપૈઃ કર્મ્મભિઃ કશ્ચિદપિ પ્રાણીશ્વરસ્ય સાક્ષાત્ સપુણ્યીકૃતો ભવિતું ન શક્ષ્યતિ યતો વ્યવસ્થયા પાપજ્ઞાનમાત્રં જાયતે| ");
INSERT INTO sanguj_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","કિન્તુ વ્યવસ્થાયાઃ પૃથગ્ ઈશ્વરેણ દેયં યત્ પુણ્યં તદ્ વ્યવસ્થાયા ભવિષ્યદ્વાદિગણસ્ય ચ વચનૈઃ પ્રમાણીકૃતં સદ્ ઇદાનીં પ્રકાશતે| ");
INSERT INTO sanguj_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","યીશુખ્રીષ્ટે વિશ્વાસકરણાદ્ ઈશ્વરેણ દત્તં તત્ પુણ્યં સકલેષુ પ્રકાશિતં સત્ સર્વ્વાન્ વિશ્વાસિનઃ પ્રતિ વર્ત્તતે| ");
INSERT INTO sanguj_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","તેષાં કોપિ પ્રભેદો નાસ્તિ, યતઃ સર્વ્વએવ પાપિન ઈશ્વરીયતેજોહીનાશ્ચ જાતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","ત ઈશ્વરસ્યાનુગ્રહાદ્ મૂલ્યં વિના ખ્રીષ્ટકૃતેન પરિત્રાણેન સપુણ્યીકૃતા ભવન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","યસ્માત્ સ્વશોણિતેન વિશ્વાસાત્ પાપનાશકો બલી ભવિતું સ એવ પૂર્વ્વમ્ ઈશ્વરેણ નિશ્ચિતઃ, ઇત્થમ્ ઈશ્વરીયસહિષ્ણુત્વાત્ પુરાકૃતપાપાનાં માર્જ્જનકરણે સ્વીયયાથાર્થ્યં તેન પ્રકાશ્યતે, ");
INSERT INTO sanguj_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","વર્ત્તમાનકાલીયમપિ સ્વયાથાર્થ્યં તેન પ્રકાશ્યતે, અપરં યીશૌ વિશ્વાસિનં સપુણ્યીકુર્વ્વન્નપિ સ યાથાર્થિકસ્તિષ્ઠતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","તર્હિ કુત્રાત્મશ્લાઘા? સા દૂરીકૃતા; કયા વ્યવસ્થયા? કિં ક્રિયારૂપવ્યવસ્થયા? ઇત્થં નહિ કિન્તુ તત્ કેવલવિશ્વાસરૂપયા વ્યવસ્થયૈવ ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","અતએવ વ્યવસ્થાનુરૂપાઃ ક્રિયા વિના કેવલેન વિશ્વાસેન માનવઃ સપુણ્યીકૃતો ભવિતું શક્નોતીત્યસ્ય રાદ્ધાન્તં દર્શયામઃ| ");
INSERT INTO sanguj_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","સ કિં કેવલયિહૂદિનામ્ ઈશ્વરો ભવતિ? ભિન્નદેશિનામ્ ઈશ્વરો ન ભવતિ? ભિન્નદેશિનામપિ ભવતિ; ");
INSERT INTO sanguj_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","યસ્માદ્ એક ઈશ્વરો વિશ્વાસાત્ ત્વક્છેદિનો વિશ્વાસેનાત્વક્છેદિનશ્ચ સપુણ્યીકરિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","તર્હિ વિશ્વાસેન વયં કિં વ્યવસ્થાં લુમ્પામ? ઇત્થં ન ભવતુ વયં વ્યવસ્થાં સંસ્થાપયામ એવ| ");
INSERT INTO sanguj_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","અસ્માકં પૂર્વ્વપુરુષ ઇબ્રાહીમ્ કાયિકક્રિયયા કિં લબ્ધવાન્ એતદધિ કિં વદિષ્યામઃ? ");
INSERT INTO sanguj_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","સ યદિ નિજક્રિયાભ્યઃ સપુણ્યો ભવેત્ તર્હિ તસ્યાત્મશ્લાઘાં કર્ત્તું પન્થા ભવેદિતિ સત્યં, કિન્ત્વીશ્વરસ્ય સમીપે નહિ| ");
INSERT INTO sanguj_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","શાસ્ત્રે કિં લિખતિ? ઇબ્રાહીમ્ ઈશ્વરે વિશ્વસનાત્ સ વિશ્વાસસ્તસ્મૈ પુણ્યાર્થં ગણિતો બભૂવ| ");
INSERT INTO sanguj_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","કર્મ્મકારિણો યદ્ વેતનં તદ્ અનુગ્રહસ્ય ફલં નહિ કિન્તુ તેનોપાર્જિતં મન્તવ્યમ્| ");
INSERT INTO sanguj_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","કિન્તુ યઃ પાપિનં સપુણ્યીકરોતિ તસ્મિન્ વિશ્વાસિનઃ કર્મ્મહીનસ્ય જનસ્ય યો વિશ્વાસઃ સ પુણ્યાર્થં ગણ્યો ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","અપરં યં ક્રિયાહીનમ્ ઈશ્વરઃ સપુણ્યીકરોતિ તસ્ય ધન્યવાદં દાયૂદ્ વર્ણયામાસ, યથા, ");
INSERT INTO sanguj_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","સ ધન્યોઽઘાનિ મૃષ્ટાનિ યસ્યાગાંસ્યાવૃતાનિ ચ| ");
INSERT INTO sanguj_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","સ ચ ધન્યઃ પરેશેન પાપં યસ્ય ન ગણ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","એષ ધન્યવાદસ્ત્વક્છેદિનમ્ અત્વક્છેદિનં વા કં પ્રતિ ભવતિ? ઇબ્રાહીમો વિશ્વાસઃ પુણ્યાર્થં ગણિત ઇતિ વયં વદામઃ| ");
INSERT INTO sanguj_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","સ વિશ્વાસસ્તસ્ય ત્વક્છેદિત્વાવસ્થાયાં કિમ્ અત્વક્છેદિત્વાવસ્થાયાં કસ્મિન્ સમયે પુણ્યમિવ ગણિતઃ? ત્વક્છેદિત્વાવસ્થાયાં નહિ કિન્ત્વત્વક્છેદિત્વાવસ્થાયાં| ");
INSERT INTO sanguj_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","અપરઞ્ચ સ યત્ સર્વ્વેષામ્ અત્વક્છેદિનાં વિશ્વાસિનામ્ આદિપુરુષો ભવેત્, તે ચ પુણ્યવત્ત્વેન ગણ્યેરન્; ");
INSERT INTO sanguj_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","યે ચ લોકાઃ કેવલં છિન્નત્વચો ન સન્તો ઽસ્મત્પૂર્વ્વપુરુષ ઇબ્રાહીમ્ અછિન્નત્વક્ સન્ યેન વિશ્વાસમાર્ગેણ ગતવાન્ તેનૈવ તસ્ય પાદચિહ્નેન ગચ્છન્તિ તેષાં ત્વક્છેદિનામપ્યાદિપુરુષો ભવેત્ તદર્થમ્ અત્વક્છેદિનો માનવસ્ય વિશ્વાસાત્ પુણ્યમ્ ઉત્પદ્યત ઇતિ પ્રમાણસ્વરૂપં ત્વક્છેદચિહ્નં સ પ્રાપ્નોત્| ");
INSERT INTO sanguj_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","ઇબ્રાહીમ્ જગતોઽધિકારી ભવિષ્યતિ યૈષા પ્રતિજ્ઞા તં તસ્ય વંશઞ્ચ પ્રતિ પૂર્વ્વમ્ અક્રિયત સા વ્યવસ્થામૂલિકા નહિ કિન્તુ વિશ્વાસજન્યપુણ્યમૂલિકા| ");
INSERT INTO sanguj_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","યતો વ્યવસ્થાવલમ્બિનો યદ્યધિકારિણો ભવન્તિ તર્હિ વિશ્વાસો વિફલો જાયતે સા પ્રતિજ્ઞાપિ લુપ્તૈવ| ");
INSERT INTO sanguj_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","અધિકન્તુ વ્યવસ્થા કોપં જનયતિ યતો ઽવિદ્યમાનાયાં વ્યવસ્થાયામ્ આજ્ઞાલઙ્ઘનં ન સમ્ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","અતએવ સા પ્રતિજ્ઞા યદ્ અનુગ્રહસ્ય ફલં ભવેત્ તદર્થં વિશ્વાસમૂલિકા યતસ્તથાત્વે તદ્વંશસમુદાયં પ્રતિ અર્થતો યે વ્યવસ્થયા તદ્વંશસમ્ભવાઃ કેવલં તાન્ પ્રતિ નહિ કિન્તુ ય ઇબ્રાહીમીયવિશ્વાસેન તત્સમ્ભવાસ્તાનપિ પ્રતિ સા પ્રતિજ્ઞા સ્થાસ્નુર્ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","યો નિર્જીવાન્ સજીવાન્ અવિદ્યમાનાનિ વસ્તૂનિ ચ વિદ્યમાનાનિ કરોતિ ઇબ્રાહીમો વિશ્વાસભૂમેસ્તસ્યેશ્વરસ્ય સાક્ષાત્ સોઽસ્માકં સર્વ્વેષામ્ આદિપુરુષ આસ્તે, યથા લિખિતં વિદ્યતે, અહં ત્વાં બહુજાતીનામ્ આદિપુરુષં કૃત્વા નિયુક્તવાન્| ");
INSERT INTO sanguj_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","ત્વદીયસ્તાદૃશો વંશો જનિષ્યતે યદિદં વાક્યં પ્રતિશ્રુતં તદનુસારાદ્ ઇબ્રાહીમ્ બહુદેશીયલોકાનામ્ આદિપુરુષો યદ્ ભવતિ તદર્થં સોઽનપેક્ષિતવ્યમપ્યપેક્ષમાણો વિશ્વાસં કૃતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","અપરઞ્ચ ક્ષીણવિશ્વાસો ન ભૂત્વા શતવત્સરવયસ્કત્વાત્ સ્વશરીરસ્ય જરાં સારાનામ્નઃ સ્વભાર્ય્યાયા રજોનિવૃત્તિઞ્ચ તૃણાય ન મેને| ");
INSERT INTO sanguj_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","અપરમ્ અવિશ્વાસાદ્ ઈશ્વરસ્ય પ્રતિજ્ઞાવચને કમપિ સંશયં ન ચકાર; ");
INSERT INTO sanguj_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","કિન્ત્વીશ્વરેણ યત્ પ્રતિશ્રુતં તત્ સાધયિતું શક્યત ઇતિ નિશ્ચિતં વિજ્ઞાય દૃઢવિશ્વાસઃ સન્ ઈશ્વરસ્ય મહિમાનં પ્રકાશયાઞ્ચકાર| ");
INSERT INTO sanguj_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","ઇતિ હેતોસ્તસ્ય સ વિશ્વાસસ્તદીયપુણ્યમિવ ગણયાઞ્ચક્રે| ");
INSERT INTO sanguj_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","પુણ્યમિવાગણ્યત તત્ કેવલસ્ય તસ્ય નિમિત્તં લિખિતં નહિ, અસ્માકં નિમિત્તમપિ, ");
INSERT INTO sanguj_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","યતોઽસ્માકં પાપનાશાર્થં સમર્પિતોઽસ્માકં પુણ્યપ્રાપ્ત્યર્થઞ્ચોત્થાપિતોઽભવત્ યોઽસ્માકં પ્રભુ ર્યીશુસ્તસ્યોત્થાપયિતરીશ્વરે ");
INSERT INTO sanguj_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","યદિ વયં વિશ્વસામસ્તર્હ્યસ્માકમપિ સએવ વિશ્વાસઃ પુણ્યમિવ ગણયિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","વિશ્વાસેન સપુણ્યીકૃતા વયમ્ ઈશ્વરેણ સાર્દ્ધં પ્રભુણાસ્માકં યીશુખ્રીષ્ટેન મેલનં પ્રાપ્તાઃ| ");
INSERT INTO sanguj_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","અપરં વયં યસ્મિન્ અનુગ્રહાશ્રયે તિષ્ઠામસ્તન્મધ્યં વિશ્વાસમાર્ગેણ તેનૈવાનીતા વયમ્ ઈશ્વરીયવિભવપ્રાપ્તિપ્રત્યાશયા સમાનન્દામઃ| ");
INSERT INTO sanguj_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","તત્ કેવલં નહિ કિન્તુ ક્લેશભોગેઽપ્યાનન્દામો યતઃ ક્લેશાाદ્ ધૈર્ય્યં જાયત ઇતિ વયં જાનીમઃ, ");
INSERT INTO sanguj_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ધૈર્ય્યાચ્ચ પરીક્ષિતત્વં જાયતે, પરીક્ષિતત્વાત્ પ્રત્યાશા જાયતે, ");
INSERT INTO sanguj_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","પ્રત્યાશાતો વ્રીડિતત્વં ન જાયતે, યસ્માદ્ અસ્મભ્યં દત્તેન પવિત્રેણાત્મનાસ્માકમ્ અન્તઃકરણાનીશ્વરસ્ય પ્રેમવારિણા સિક્તાનિ| ");
INSERT INTO sanguj_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","અસ્માસુ નિરુપાયેષુ સત્સુ ખ્રીષ્ટ ઉપયુક્તે સમયે પાપિનાં નિમિત્તં સ્વીયાન્ પ્રણાન્ અત્યજત્| ");
INSERT INTO sanguj_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","હિતકારિણો જનસ્ય કૃતે કોપિ પ્રણાન્ ત્યક્તું સાહસં કર્ત્તું શક્નોતિ, કિન્તુ ધાર્મ્મિકસ્ય કૃતે પ્રાયેણ કોપિ પ્રાણાન્ ન ત્યજતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","કિન્ત્વસ્માસુ પાપિષુ સત્સ્વપિ નિમિત્તમસ્માકં ખ્રીષ્ટઃ સ્વપ્રાણાન્ ત્યક્તવાન્, તત ઈશ્વરોસ્માન્ પ્રતિ નિજં પરમપ્રેમાણં દર્શિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","અતએવ તસ્ય રક્તપાતેન સપુણ્યીકૃતા વયં નિતાન્તં તેન કોપાદ્ ઉદ્ધારિષ્યામહે| ");
INSERT INTO sanguj_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","ફલતો વયં યદા રિપવ આસ્મ તદેશ્વરસ્ય પુત્રસ્ય મરણેન તેન સાર્દ્ધં યદ્યસ્માકં મેલનં જાતં તર્હિ મેલનપ્રાપ્તાઃ સન્તોઽવશ્યં તસ્ય જીવનેન રક્ષાં લપ્સ્યામહે| ");
INSERT INTO sanguj_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","તત્ કેવલં નહિ કિન્તુ યેન મેલનમ્ અલભામહિ તેનાસ્માકં પ્રભુણા યીશુખ્રીષ્ટેન સામ્પ્રતમ્ ઈશ્વરે સમાનન્દામશ્ચ| ");
INSERT INTO sanguj_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","તથા સતિ, એકેન માનુષેણ પાપં પાપેન ચ મરણં જગતીં પ્રાવિશત્ અપરં સર્વ્વેષાં પાપિત્વાત્ સર્વ્વે માનુષા મૃતે ર્નિઘ્ના અભવત્| ");
INSERT INTO sanguj_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","યતો વ્યવસ્થાદાનસમયં યાવત્ જગતિ પાપમ્ આસીત્ કિન્તુ યત્ર વ્યવસ્થા ન વિદ્યતે તત્ર પાપસ્યાપિ ગણના ન વિદ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","તથાપ્યાદમા યાદૃશં પાપં કૃતં તાદૃશં પાપં યૈ ર્નાકારિ આદમમ્ આરભ્ય મૂસાં યાવત્ તેષામપ્યુપરિ મૃત્યૂ રાજત્વમ્ અકરોત્ સ આદમ્ ભાવ્યાદમો નિદર્શનમેવાસ્તે| ");
INSERT INTO sanguj_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","કિન્તુ પાપકર્મ્મણો યાદૃશો ભાવસ્તાદૃગ્ દાનકર્મ્મણો ભાવો ન ભવતિ યત એકસ્ય જનસ્યાપરાધેન યદિ બહૂનાં મરણમ્ અઘટત તથાપીશ્વરાનુગ્રહસ્તદનુગ્રહમૂલકં દાનઞ્ચૈકેન જનેનાર્થાદ્ યીશુના ખ્રીષ્ટેન બહુષુ બાહુલ્યાતિબાહુલ્યેન ફલતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","અપરમ્ એકસ્ય જનસ્ય પાપકર્મ્મ યાદૃક્ ફલયુક્તં દાનકર્મ્મ તાદૃક્ ન ભવતિ યતો વિચારકર્મ્મૈકં પાપમ્ આરભ્ય દણ્ડજનકં બભૂવ, કિન્તુ દાનકર્મ્મ બહુપાપાન્યારભ્ય પુણ્યજનકં બભૂવ| ");
INSERT INTO sanguj_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","યત એકસ્ય જનસ્ય પાપકર્મ્મતસ્તેનૈકેન યદિ મરણસ્ય રાજત્વં જાતં તર્હિ યે જના અનુગ્રહસ્ય બાહુલ્યં પુણ્યદાનઞ્ચ પ્રાપ્નુવન્તિ ત એકેન જનેન, અર્થાત્ યીશુખ્રીષ્ટેન, જીવને રાજત્વમ્ અવશ્યં કરિષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","એકોઽપરાધો યદ્વત્ સર્વ્વમાનવાનાં દણ્ડગામી માર્ગો ઽભવત્ તદ્વદ્ એકં પુણ્યદાનં સર્વ્વમાનવાનાં જીવનયુક્તપુણ્યગામી માર્ગ એવ| ");
INSERT INTO sanguj_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","અપરમ્ એકસ્ય જનસ્યાજ્ઞાલઙ્ઘનાદ્ યથા બહવો ઽપરાધિનો જાતાસ્તદ્વદ્ એકસ્યાજ્ઞાચરણાદ્ બહવઃ સપુણ્યીકૃતા ભવન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","અધિકન્તુ વ્યવસ્થાગમનાદ્ અપરાધસ્ય બાહુલ્યં જાતં કિન્તુ યત્ર પાપસ્ય બાહુલ્યં તત્રૈવ તસ્માદ્ અનુગ્રહસ્ય બાહુલ્યમ્ અભવત્| ");
INSERT INTO sanguj_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","તેન મૃત્યુના યદ્વત્ પાપસ્ય રાજત્વમ્ અભવત્ તદ્વદ્ અસ્માકં પ્રભુયીશુખ્રીષ્ટદ્વારાનન્તજીવનદાયિપુણ્યેનાનુગ્રહસ્ય રાજત્વં ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","પ્રભૂતરૂપેણ યદ્ અનુગ્રહઃ પ્રકાશતે તદર્થં પાપે તિષ્ઠામ ઇતિ વાક્યં કિં વયં વદિષ્યામઃ? તન્ન ભવતુ| ");
INSERT INTO sanguj_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","પાપં પ્રતિ મૃતા વયં પુનસ્તસ્મિન્ કથમ્ જીવિષ્યામઃ? ");
INSERT INTO sanguj_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","વયં યાવન્તો લોકા યીશુખ્રીષ્ટે મજ્જિતા અભવામ તાવન્ત એવ તસ્ય મરણે મજ્જિતા ઇતિ કિં યૂયં ન જાનીથ? ");
INSERT INTO sanguj_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","તતો યથા પિતુઃ પરાક્રમેણ શ્મશાનાત્ ખ્રીષ્ટ ઉત્થાપિતસ્તથા વયમપિ યત્ નૂતનજીવિન ઇવાચરામસ્તદર્થં મજ્જનેન તેન સાર્દ્ધં મૃત્યુરૂપે શ્મશાને સંસ્થાપિતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","અપરં વયં યદિ તેન સંયુક્તાઃ સન્તઃ સ ઇવ મરણભાગિનો જાતાસ્તર્હિ સ ઇવોત્થાનભાગિનોઽપિ ભવિષ્યામઃ| ");
INSERT INTO sanguj_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","વયં યત્ પાપસ્ય દાસાઃ પુન ર્ન ભવામસ્તદર્થમ્ અસ્માકં પાપરૂપશરીરસ્ય વિનાશાર્થમ્ અસ્માકં પુરાતનપુરુષસ્તેન સાકં ક્રુશેઽહન્યતેતિ વયં જાનીમઃ| ");
INSERT INTO sanguj_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","યો હતઃ સ પાપાત્ મુક્ત એવ| ");
INSERT INTO sanguj_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","અતએવ યદિ વયં ખ્રીષ્ટેન સાર્દ્ધમ્ અહન્યામહિ તર્હિ પુનરપિ તેન સહિતા જીવિષ્યામ ઇત્યત્રાસ્માકં વિશ્વાસો વિદ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","યતઃ શ્મશાનાદ્ ઉત્થાપિતઃ ખ્રીષ્ટો પુન ર્ન મ્રિયત ઇતિ વયં જાનીમઃ| તસ્મિન્ કોપ્યધિકારો મૃત્યો ર્નાસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","અપરઞ્ચ સ યદ્ અમ્રિયત તેનૈકદા પાપમ્ ઉદ્દિશ્યામ્રિયત, યચ્ચ જીવતિ તેનેશ્વરમ્ ઉદ્દિશ્ય જીવતિ; ");
INSERT INTO sanguj_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","તદ્વદ્ યૂયમપિ સ્વાન્ પાપમ્ ઉદ્દિશ્ય મૃતાન્ અસ્માકં પ્રભુણા યીશુખ્રીષ્ટેનેશ્વરમ્ ઉદ્દિશ્ય જીવન્તો જાનીત| ");
INSERT INTO sanguj_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","અપરઞ્ચ કુત્સિતાભિલાષાाન્ પૂરયિતું યુષ્માકં મર્ત્યદેહેષુ પાપમ્ આધિપત્યં ન કરોતુ| ");
INSERT INTO sanguj_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","અપરં સ્વં સ્વમ્ અઙ્ગમ્ અધર્મ્મસ્યાસ્ત્રં કૃત્વા પાપસેવાયાં ન સમર્પયત, કિન્તુ શ્મશાનાદ્ ઉત્થિતાનિવ સ્વાન્ ઈશ્વરે સમર્પયત સ્વાન્યઙ્ગાનિ ચ ધર્મ્માસ્ત્રસ્વરૂપાણીશ્વરમ્ ઉદ્દિશ્ય સમર્પયત| ");
INSERT INTO sanguj_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","યુષ્માકમ્ ઉપરિ પાપસ્યાધિપત્યં પુન ર્ન ભવિષ્યતિ, યસ્માદ્ યૂયં વ્યવસ્થાયા અનાયત્તા અનુગ્રહસ્ય ચાયત્તા અભવત| ");
INSERT INTO sanguj_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","કિન્તુ વયં વ્યવસ્થાયા અનાયત્તા અનુગ્રહસ્ય ચાયત્તા અભવામ, ઇતિ કારણાત્ કિં પાપં કરિષ્યામઃ? તન્ન ભવતુ| ");
INSERT INTO sanguj_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","યતો મૃતિજનકં પાપં પુણ્યજનકં નિદેશાચરણઞ્ચૈતયોર્દ્વયો ર્યસ્મિન્ આજ્ઞાપાલનાર્થં ભૃત્યાનિવ સ્વાન્ સમર્પયથ, તસ્યૈવ ભૃત્યા ભવથ, એતત્ કિં યૂયં ન જાનીથ? ");
INSERT INTO sanguj_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","અપરઞ્ચ પૂર્વ્વં યૂયં પાપસ્ય ભૃત્યા આસ્તેતિ સત્યં કિન્તુ યસ્યાં શિક્ષારૂપાયાં મૂષાયાં નિક્ષિપ્તા અભવત તસ્યા આકૃતિં મનોભિ ર્લબ્ધવન્ત ઇતિ કારણાદ્ ઈશ્વરસ્ય ધન્યવાદો ભવતુ| ");
INSERT INTO sanguj_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","ઇત્થં યૂયં પાપસેવાતો મુક્તાઃ સન્તો ધર્મ્મસ્ય ભૃત્યા જાતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","યુષ્માકં શારીરિક્યા દુર્બ્બલતાયા હેતો ર્માનવવદ્ અહમ્ એતદ્ બ્રવીમિ; પુનઃ પુનરધર્મ્મકરણાર્થં યદ્વત્ પૂર્વ્વં પાપામેધ્યયો ર્ભૃત્યત્વે નિજાઙ્ગાનિ સમાર્પયત તદ્વદ્ ઇદાનીં સાધુકર્મ્મકરણાર્થં ધર્મ્મસ્ય ભૃત્યત્વે નિજાઙ્ગાનિ સમર્પયત| ");
INSERT INTO sanguj_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","યદા યૂયં પાપસ્ય ભૃત્યા આસ્ત તદા ધર્મ્મસ્ય નાયત્તા આસ્ત| ");
INSERT INTO sanguj_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","તર્હિ યાનિ કર્મ્માણિ યૂયમ્ ઇદાનીં લજ્જાજનકાનિ બુધ્યધ્વે પૂર્વ્વં તૈ ર્યુષ્માકં કો લાભ આસીત્? તેષાં કર્મ્મણાં ફલં મરણમેવ| ");
INSERT INTO sanguj_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","કિન્તુ સામ્પ્રતં યૂયં પાપસેવાતો મુક્તાઃ સન્ત ઈશ્વરસ્ય ભૃત્યાઽભવત તસ્માદ્ યુષ્માકં પવિત્રત્વરૂપં લભ્યમ્ અનન્તજીવનરૂપઞ્ચ ફલમ્ આસ્તે| ");
INSERT INTO sanguj_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","યતઃ પાપસ્ય વેતનં મરણં કિન્ત્વસ્માકં પ્રભુણા યીશુખ્રીષ્ટેનાનન્તજીવનમ્ ઈશ્વરદત્તં પારિતોષિકમ્ આસ્તે| ");
INSERT INTO sanguj_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","હે ભ્રાતૃગણ વ્યવસ્થાવિદઃ પ્રતિ મમેદં નિવેદનં| વિધિઃ કેવલં યાવજ્જીવં માનવોપર્ય્યધિપતિત્વં કરોતીતિ યૂયં કિં ન જાનીથ? ");
INSERT INTO sanguj_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","યાવત્કાલં પતિ ર્જીવતિ તાવત્કાલમ્ ઊઢા ભાર્ય્યા વ્યવસ્થયા તસ્મિન્ બદ્ધા તિષ્ઠતિ કિન્તુ યદિ પતિ ર્મ્રિયતે તર્હિ સા નારી પત્યુ ર્વ્યવસ્થાતો મુચ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","એતત્કારણાત્ પત્યુર્જીવનકાલે નારી યદ્યન્યં પુરુષં વિવહતિ તર્હિ સા વ્યભિચારિણી ભવતિ કિન્તુ યદિ સ પતિ ર્મ્રિયતે તર્હિ સા તસ્યા વ્યવસ્થાયા મુક્તા સતી પુરુષાન્તરેણ વ્યૂઢાપિ વ્યભિચારિણી ન ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","હે મમ ભ્રાતૃગણ, ઈશ્વરનિમિત્તં યદસ્માકં ફલં જાયતે તદર્થં શ્મશાનાદ્ ઉત્થાપિતેન પુરુષેણ સહ યુષ્માકં વિવાહો યદ્ ભવેત્ તદર્થં ખ્રીષ્ટસ્ય શરીરેણ યૂયં વ્યવસ્થાં પ્રતિ મૃતવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","યતોઽસ્માકં શારીરિકાચરણસમયે મરણનિમિત્તં ફલમ્ ઉત્પાદયિતું વ્યવસ્થયા દૂષિતઃ પાપાભિલાષોઽસ્માકમ્ અઙ્ગેષુ જીવન્ આસીત્| ");
INSERT INTO sanguj_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","કિન્તુ તદા યસ્યા વ્યવસ્થાયા વશે આસ્મહિ સામ્પ્રતં તાં પ્રતિ મૃતત્વાદ્ વયં તસ્યા અધીનત્વાત્ મુક્તા ઇતિ હેતોરીશ્વરોઽસ્માભિઃ પુરાતનલિખિતાનુસારાત્ ન સેવિતવ્યઃ કિન્તુ નવીનસ્વભાવેનૈવ સેવિતવ્યઃ ");
INSERT INTO sanguj_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","તર્હિ વયં કિં બ્રૂમઃ? વ્યવસ્થા કિં પાપજનિકા ભવતિ? નેત્થં ભવતુ| વ્યવસ્થામ્ અવિદ્યમાનાયાં પાપં કિમ્ ઇત્યહં નાવેદં; કિઞ્ચ લોભં મા કાર્ષીરિતિ ચેદ્ વ્યવસ્થાગ્રન્થે લિખિતં નાભવિષ્યત્ તર્હિ લોભઃ કિમ્ભૂતસ્તદહં નાજ્ઞાસ્યં| ");
INSERT INTO sanguj_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","કિન્તુ વ્યવસ્થયા પાપં છિદ્રં પ્રાપ્યાસ્માકમ્ અન્તઃ સર્વ્વવિધં કુત્સિતાભિલાષમ્ અજનયત્; યતો વ્યવસ્થાયામ્ અવિદ્યમાનાયાં પાપં મૃતં| ");
INSERT INTO sanguj_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","અપરં પૂર્વ્વં વ્યવસ્થાયામ્ અવિદ્યમાનાયામ્ અહમ્ અજીવં તતઃ પરમ્ આજ્ઞાયામ્ ઉપસ્થિતાયામ્ પાપમ્ અજીવત્ તદાહમ્ અમ્રિયે| ");
INSERT INTO sanguj_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","ઇત્થં સતિ જીવનનિમિત્તા યાજ્ઞા સા મમ મૃત્યુજનિકાભવત્| ");
INSERT INTO sanguj_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","યતઃ પાપં છિદ્રં પ્રાપ્ય વ્યવસ્થિતાદેશેન માં વઞ્ચયિત્વા તેન મામ્ અહન્| ");
INSERT INTO sanguj_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","અતએવ વ્યવસ્થા પવિત્રા, આદેશશ્ચ પવિત્રો ન્યાય્યો હિતકારી ચ ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","તર્હિ યત્ સ્વયં હિતકૃત્ તત્ કિં મમ મૃત્યુજનકમ્ અભવત્? નેત્થં ભવતુ; કિન્તુ પાપં યત્ પાતકમિવ પ્રકાશતે તથા નિદેશેન પાપં યદતીવ પાતકમિવ પ્રકાશતે તદર્થં હિતોપાયેન મમ મરણમ્ અજનયત્| ");
INSERT INTO sanguj_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","વ્યવસ્થાત્મબોધિકેતિ વયં જાનીમઃ કિન્ત્વહં શારીરતાચારી પાપસ્ય ક્રીતકિઙ્કરો વિદ્યે| ");
INSERT INTO sanguj_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","યતો યત્ કર્મ્મ કરોમિ તત્ મમ મનોઽભિમતં નહિ; અપરં યન્ મમ મનોઽભિમતં તન્ન કરોમિ કિન્તુ યદ્ ઋતીયે તત્ કરોમિ| ");
INSERT INTO sanguj_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","તથાત્વે યન્ મમાનભિમતં તદ્ યદિ કરોમિ તર્હિ વ્યવસ્થા સૂત્તમેતિ સ્વીકરોમિ| ");
INSERT INTO sanguj_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","અતએવ સમ્પ્રતિ તત્ કર્મ્મ મયા ક્રિયત ઇતિ નહિ કિન્તુ મમ શરીરસ્થેન પાપેનૈવ ક્રિયતે| ");
INSERT INTO sanguj_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","યતો મયિ, અર્થતો મમ શરીરે, કિમપ્યુત્તમં ન વસતિ, એતદ્ અહં જાનામિ; મમેચ્છુકતાયાં તિષ્ઠન્ત્યામપ્યહમ્ ઉત્તમકર્મ્મસાધને સમર્થો ન ભવામિ| ");
INSERT INTO sanguj_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","યતો યામુત્તમાં ક્રિયાં કર્ત્તુમહં વાઞ્છામિ તાં ન કરોમિ કિન્તુ યત્ કુત્સિતં કર્મ્મ કર્ત્તુમ્ અનિચ્છુકોઽસ્મિ તદેવ કરોમિ| ");
INSERT INTO sanguj_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","અતએવ યદ્યત્ કર્મ્મ કર્ત્તું મમેચ્છા ન ભવતિ તદ્ યદિ કરોમિ તર્હિ તત્ મયા ન ક્રિયતે, મમાન્તર્વર્ત્તિના પાપેનૈવ ક્રિયતે| ");
INSERT INTO sanguj_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","ભદ્રં કર્ત્તુમ્ ઇચ્છુકં માં યો ઽભદ્રં કર્ત્તું પ્રવર્ત્તયતિ તાદૃશં સ્વભાવમેકં મયિ પશ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","અહમ્ આન્તરિકપુરુષેણેશ્વરવ્યવસ્થાયાં સન્તુષ્ટ આસે; ");
INSERT INTO sanguj_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","કિન્તુ તદ્વિપરીતં યુધ્યન્તં તદન્યમેકં સ્વભાવં મદીયાઙ્ગસ્થિતં પ્રપશ્યામિ, સ મદીયાઙ્ગસ્થિતપાપસ્વભાવસ્યાયત્તં માં કર્ત્તું ચેષ્ટતે| ");
INSERT INTO sanguj_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","હા હા યોઽહં દુર્ભાગ્યો મનુજસ્તં મામ્ એતસ્માન્ મૃતાચ્છરીરાત્ કો નિસ્તારયિષ્યતિ? ");
INSERT INTO sanguj_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","અસ્માકં પ્રભુણા યીશુખ્રીષ્ટેન નિસ્તારયિતારમ્ ઈશ્વરં ધન્યં વદામિ| અતએવ શરીરેણ પાપવ્યવસ્થાયા મનસા તુ ઈશ્વરવ્યવસ્થાયાઃ સેવનં કરોમિ| ");
INSERT INTO sanguj_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","યે જનાઃ ખ્રીષ્ટં યીશુમ્ આશ્રિત્ય શારીરિકં નાચરન્ત આત્મિકમાચરન્તિ તેઽધુના દણ્ડાર્હા ન ભવન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","જીવનદાયકસ્યાત્મનો વ્યવસ્થા ખ્રીષ્ટયીશુના પાપમરણયો ર્વ્યવસ્થાતો મામમોચયત્| ");
INSERT INTO sanguj_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","યસ્માચ્છારીરસ્ય દુર્બ્બલત્વાદ્ વ્યવસ્થયા યત્ કર્મ્માસાધ્યમ્ ઈશ્વરો નિજપુત્રં પાપિશરીરરૂપં પાપનાશકબલિરૂપઞ્ચ પ્રેષ્ય તસ્ય શરીરે પાપસ્ય દણ્ડં કુર્વ્વન્ તત્કર્મ્મ સાધિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","તતઃ શારીરિકં નાચરિત્વાસ્માભિરાત્મિકમ્ આચરદ્ભિર્વ્યવસ્થાગ્રન્થે નિર્દ્દિષ્ટાનિ પુણ્યકર્મ્માણિ સર્વ્વાણિ સાધ્યન્તે| ");
INSERT INTO sanguj_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","યે શારીરિકાચારિણસ્તે શારીરિકાન્ વિષયાન્ ભાવયન્તિ યે ચાત્મિકાચારિણસ્તે આત્મનો વિષયાન્ ભાવયન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","શારીરિકભાવસ્ય ફલં મૃત્યુઃ કિઞ્ચાત્મિકભાવસ્ય ફલે જીવનં શાન્તિશ્ચ| ");
INSERT INTO sanguj_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","યતઃ શારીરિકભાવ ઈશ્વરસ્ય વિરુદ્ધઃ શત્રુતાભાવ એવ સ ઈશ્વરસ્ય વ્યવસ્થાયા અધીનો ન ભવતિ ભવિતુઞ્ચ ન શક્નોતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","એતસ્માત્ શારીરિકાચારિષુ તોષ્ટુમ્ ઈશ્વરેણ ન શક્યં| ");
INSERT INTO sanguj_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","કિન્ત્વીશ્વરસ્યાત્મા યદિ યુષ્માકં મધ્યે વસતિ તર્હિ યૂયં શારીરિકાચારિણો ન સન્ત આત્મિકાચારિણો ભવથઃ| યસ્મિન્ તુ ખ્રીષ્ટસ્યાત્મા ન વિદ્યતે સ તત્સમ્ભવો નહિ| ");
INSERT INTO sanguj_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","યદિ ખ્રીષ્ટો યુષ્માન્ અધિતિષ્ઠતિ તર્હિ પાપમ્ ઉદ્દિશ્ય શરીરં મૃતં કિન્તુ પુણ્યમુદ્દિશ્યાત્મા જીવતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","મૃતગણાદ્ યીશુ ર્યેનોત્થાપિતસ્તસ્યાત્મા યદિ યુષ્મન્મધ્યે વસતિ તર્હિ મૃતગણાત્ ખ્રીષ્ટસ્ય સ ઉત્થાપયિતા યુષ્મન્મધ્યવાસિના સ્વકીયાત્મના યુષ્માકં મૃતદેહાનપિ પુન ર્જીવયિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","હે ભ્રાતૃગણ શરીરસ્ય વયમધમર્ણા ન ભવામોઽતઃ શારીરિકાચારોઽસ્માભિ ર્ન કર્ત્તવ્યઃ| ");
INSERT INTO sanguj_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","યદિ યૂયં શરીરિકાચારિણો ભવેત તર્હિ યુષ્માભિ ર્મર્ત્તવ્યમેવ કિન્ત્વાત્મના યદિ શરીરકર્મ્માણિ ઘાતયેત તર્હિ જીવિષ્યથ| ");
INSERT INTO sanguj_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","યતો યાવન્તો લોકા ઈશ્વરસ્યાત્મનાકૃષ્યન્તે તે સર્વ્વ ઈશ્વરસ્ય સન્તાના ભવન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","યૂયં પુનરપિ ભયજનકં દાસ્યભાવં ન પ્રાપ્તાઃ કિન્તુ યેન ભાવેનેશ્વરં પિતઃ પિતરિતિ પ્રોચ્ય સમ્બોધયથ તાદૃશં દત્તકપુત્રત્વભાવમ્ પ્રાપ્નુત| ");
INSERT INTO sanguj_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","અપરઞ્ચ વયમ્ ઈશ્વરસ્ય સન્તાના એતસ્મિન્ પવિત્ર આત્મા સ્વયમ્ અસ્માકમ્ આત્માભિઃ સાર્દ્ધં પ્રમાણં દદાતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","અતએવ વયં યદિ સન્તાનાસ્તર્હ્યધિકારિણઃ, અર્થાદ્ ઈશ્વરસ્ય સ્વત્ત્વાધિકારિણઃ ખ્રીષ્ટેન સહાધિકારિણશ્ચ ભવામઃ; અપરં તેન સાર્દ્ધં યદિ દુઃખભાગિનો ભવામસ્તર્હિ તસ્ય વિભવસ્યાપિ ભાગિનો ભવિષ્યામઃ| ");
INSERT INTO sanguj_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","કિન્ત્વસ્માસુ યો ભાવીવિભવઃ પ્રકાશિષ્યતે તસ્ય સમીપે વર્ત્તમાનકાલીનં દુઃખમહં તૃણાય મન્યે| ");
INSERT INTO sanguj_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","યતઃ પ્રાણિગણ ઈશ્વરસ્ય સન્તાનાનાં વિભવપ્રાપ્તિમ્ આકાઙ્ક્ષન્ નિતાન્તમ્ અપેક્ષતે| ");
INSERT INTO sanguj_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","અપરઞ્ચ પ્રાણિગણઃ સ્વૈરમ્ અલીકતાયા વશીકૃતો નાભવત્ ");
INSERT INTO sanguj_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","કિન્તુ પ્રાણિગણોઽપિ નશ્વરતાધીનત્વાત્ મુક્તઃ સન્ ઈશ્વરસ્ય સન્તાનાનાં પરમમુક્તિં પ્રાપ્સ્યતીત્યભિપ્રાયેણ વશીકર્ત્રા વશીચક્રે| ");
INSERT INTO sanguj_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","અપરઞ્ચ પ્રસૂયમાનાવદ્ વ્યથિતઃ સન્ ઇદાનીં યાવત્ કૃત્સ્નઃ પ્રાણિગણ આર્ત્તસ્વરં કરોતીતિ વયં જાનીમઃ| ");
INSERT INTO sanguj_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","કેવલઃ સ ઇતિ નહિ કિન્તુ પ્રથમજાતફલસ્વરૂપમ્ આત્માનં પ્રાપ્તા વયમપિ દત્તકપુત્રત્વપદપ્રાપ્તિમ્ અર્થાત્ શરીરસ્ય મુક્તિં પ્રતીક્ષમાણાસ્તદ્વદ્ અન્તરાર્ત્તરાવં કુર્મ્મઃ| ");
INSERT INTO sanguj_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","વયં પ્રત્યાશયા ત્રાણમ્ અલભામહિ કિન્તુ પ્રત્યક્ષવસ્તુનો યા પ્રત્યાશા સા પ્રત્યાશા નહિ, યતો મનુષ્યો યત્ સમીક્ષતે તસ્ય પ્રત્યાશાં કુતઃ કરિષ્યતિ? ");
INSERT INTO sanguj_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","યદ્ અપ્રત્યક્ષં તસ્ય પ્રત્યાશાં યદિ વયં કુર્વ્વીમહિ તર્હિ ધૈર્ય્યમ્ અવલમ્બ્ય પ્રતીક્ષામહે| ");
INSERT INTO sanguj_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","તત આત્માપિ સ્વયમ્ અસ્માકં દુર્બ્બલતાયાઃ સહાયત્વં કરોતિ; યતઃ કિં પ્રાર્થિતવ્યં તદ્ બોદ્ધું વયં ન શક્નુમઃ, કિન્ત્વસ્પષ્ટૈરાર્ત્તરાવૈરાત્મા સ્વયમ્ અસ્મન્નિમિત્તં નિવેદયતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","અપરમ્ ઈશ્વરાભિમતરૂપેણ પવિત્રલોકાનાં કૃતે નિવેદયતિ ય આત્મા તસ્યાભિપ્રાયોઽન્તર્ય્યામિના જ્ઞાયતે| ");
INSERT INTO sanguj_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","અપરમ્ ઈશ્વરીયનિરૂપણાનુસારેણાહૂતાઃ સન્તો યે તસ્મિન્ પ્રીયન્તે સર્વ્વાણિ મિલિત્વા તેષાં મઙ્ગલં સાધયન્તિ, એતદ્ વયં જાનીમઃ| ");
INSERT INTO sanguj_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","યત ઈશ્વરો બહુભ્રાતૃણાં મધ્યે સ્વપુત્રં જ્યેષ્ઠં કર્ત્તુમ્ ઇચ્છન્ યાન્ પૂર્વ્વં લક્ષ્યીકૃતવાન્ તાન્ તસ્ય પ્રતિમૂર્ત્યાઃ સાદૃશ્યપ્રાપ્ત્યર્થં ન્યયુંક્ત| ");
INSERT INTO sanguj_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","અપરઞ્ચ તેન યે નિયુક્તાસ્ત આહૂતા અપિ યે ચ તેનાહૂતાસ્તે સપુણ્યીકૃતાઃ, યે ચ તેન સપુણ્યીકૃતાસ્તે વિભવયુક્તાઃ| ");
INSERT INTO sanguj_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","ઇત્યત્ર વયં કિં બ્રૂમઃ? ઈશ્વરો યદ્યસ્માકં સપક્ષો ભવતિ તર્હિ કો વિપક્ષોઽસ્માકં? ");
INSERT INTO sanguj_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","આત્મપુત્રં ન રક્ષિત્વા યોઽસ્માકં સર્વ્વેષાં કૃતે તં પ્રદત્તવાન્ સ કિં તેન સહાસ્મભ્યમ્ અન્યાનિ સર્વ્વાણિ ન દાસ્યતિ? ");
INSERT INTO sanguj_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","ઈશ્વરસ્યાભિરુચિતેષુ કેન દોષ આરોપયિષ્યતે? ય ઈશ્વરસ્તાન્ પુણ્યવત ઇવ ગણયતિ કિં તેન? ");
INSERT INTO sanguj_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","અપરં તેભ્યો દણ્ડદાનાજ્ઞા વા કેન કરિષ્યતે? યોઽસ્મન્નિમિત્તં પ્રાણાન્ ત્યક્તવાન્ કેવલં તન્ન કિન્તુ મૃતગણમધ્યાદ્ ઉત્થિતવાન્, અપિ ચેશ્વરસ્ય દક્ષિણે પાર્શ્વે તિષ્ઠન્ અદ્યાપ્યસ્માકં નિમિત્તં પ્રાર્થત એવમ્ભૂતો યઃ ખ્રીષ્ટઃ કિં તેન? ");
INSERT INTO sanguj_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","અસ્માભિઃ સહ ખ્રીષ્ટસ્ય પ્રેમવિચ્છેદં જનયિતું કઃ શક્નોતિ? ક્લેશો વ્યસનં વા તાડના વા દુર્ભિક્ષં વા વસ્ત્રહીનત્વં વા પ્રાણસંશયો વા ખઙ્ગો વા કિમેતાનિ શક્નુવન્તિ? ");
INSERT INTO sanguj_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","કિન્તુ લિખિતમ્ આસ્તે, યથા, વયં તવ નિમિત્તં સ્મો મૃત્યુવક્ત્રેઽખિલં દિનં| બલિર્દેયો યથા મેષો વયં ગણ્યામહે તથા| ");
INSERT INTO sanguj_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","અપરં યોઽસ્માસુ પ્રીયતે તેનૈતાસુ વિપત્સુ વયં સમ્યગ્ વિજયામહે| ");
INSERT INTO sanguj_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","યતોઽસ્માકં પ્રભુના યીશુખ્રીષ્ટેનેશ્વરસ્ય યત્ પ્રેમ તસ્માદ્ અસ્માકં વિચ્છેદં જનયિતું મૃત્યુ ર્જીવનં વા દિવ્યદૂતા વા બલવન્તો મુખ્યદૂતા વા વર્ત્તમાનો વા ભવિષ્યન્ કાલો વા ઉચ્ચપદં વા નીચપદં વાપરં કિમપિ સૃષ્ટવસ્તુ ");
INSERT INTO sanguj_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","વૈતેષાં કેનાપિ ન શક્યમિત્યસ્મિન્ દૃઢવિશ્વાસો મમાસ્તે| ");
INSERT INTO sanguj_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","અહં કાઞ્ચિદ્ કલ્પિતાં કથાં ન કથયામિ, ખ્રીષ્ટસ્ય સાક્ષાત્ સત્યમેવ બ્રવીમિ પવિત્રસ્યાત્મનઃ સાક્ષાન્ મદીયં મન એતત્ સાક્ષ્યં દદાતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","મમાન્તરતિશયદુઃખં નિરન્તરં ખેદશ્ચ ");
INSERT INTO sanguj_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","તસ્માદ્ અહં સ્વજાતીયભ્રાતૃણાં નિમિત્તાત્ સ્વયં ખ્રીષ્ટાચ્છાપાક્રાન્તો ભવિતુમ્ ઐચ્છમ્| ");
INSERT INTO sanguj_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","યતસ્ત ઇસ્રાયેલસ્ય વંશા અપિ ચ દત્તકપુત્રત્વં તેજો નિયમો વ્યવસ્થાદાનં મન્દિરે ભજનં પ્રતિજ્ઞાઃ પિતૃપુરુષગણશ્ચૈતેષુ સર્વ્વેષુ તેષામ્ અધિકારોઽસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","તત્ કેવલં નહિ કિન્તુ સર્વ્વાધ્યક્ષઃ સર્વ્વદા સચ્ચિદાનન્દ ઈશ્વરો યઃ ખ્રીષ્ટઃ સોઽપિ શારીરિકસમ્બન્ધેન તેષાં વંશસમ્ભવઃ| ");
INSERT INTO sanguj_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","ઈશ્વરસ્ય વાક્યં વિફલં જાતમ્ ઇતિ નહિ યત્કારણાદ્ ઇસ્રાયેલો વંશે યે જાતાસ્તે સર્વ્વે વસ્તુત ઇસ્રાયેલીયા ન ભવન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","અપરમ્ ઇબ્રાહીમો વંશે જાતા અપિ સર્વ્વે તસ્યૈવ સન્તાના ન ભવન્તિ કિન્તુ ઇસ્હાકો નામ્ના તવ વંશો વિખ્યાતો ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","અર્થાત્ શારીરિકસંસર્ગાત્ જાતાઃ સન્તાના યાવન્તસ્તાવન્ત એવેશ્વરસ્ય સન્તાના ન ભવન્તિ કિન્તુ પ્રતિશ્રવણાદ્ યે જાયન્તે તએવેશ્વરવંશો ગણ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","યતસ્તત્પ્રતિશ્રુતે ર્વાક્યમેતત્, એતાદૃશે સમયે ઽહં પુનરાગમિષ્યામિ તત્પૂર્વ્વં સારાયાઃ પુત્ર એકો જનિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","અપરમપિ વદામિ સ્વમનોઽભિલાષત ઈશ્વરેણ યન્નિરૂપિતં તત્ કર્મ્મતો નહિ કિન્ત્વાહ્વયિતુ ર્જાતમેતદ્ યથા સિદ્ધ્યતિ ");
INSERT INTO sanguj_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","તદર્થં રિબ્કાનામિકયા યોષિતા જનૈકસ્માદ્ અર્થાદ્ અસ્માકમ્ ઇસ્હાકઃ પૂર્વ્વપુરુષાદ્ ગર્ભે ધૃતે તસ્યાઃ સન્તાનયોઃ પ્રસવાત્ પૂર્વ્વં કિઞ્ચ તયોઃ શુભાશુભકર્મ્મણઃ કરણાત્ પૂર્વ્વં ");
INSERT INTO sanguj_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","તાં પ્રતીદં વાક્યમ્ ઉક્તં, જ્યેષ્ઠઃ કનિષ્ઠં સેવિષ્યતે, ");
INSERT INTO sanguj_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","યથા લિખિતમ્ આસ્તે, તથાપ્યેષાવિ ન પ્રીત્વા યાકૂબિ પ્રીતવાન્ અહં| ");
INSERT INTO sanguj_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","તર્હિ વયં કિં બ્રૂમઃ? ઈશ્વરઃ કિમ્ અન્યાયકારી? તથા ન ભવતુ| ");
INSERT INTO sanguj_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","યતઃ સ સ્વયં મૂસામ્ અવદત્; અહં યસ્મિન્ અનુગ્રહં ચિકીર્ષામિ તમેવાનુગૃહ્લામિ, યઞ્ચ દયિતુમ્ ઇચ્છામિ તમેવ દયે| ");
INSERT INTO sanguj_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","અતએવેચ્છતા યતમાનેન વા માનવેન તન્ન સાધ્યતે દયાકારિણેશ્વરેણૈવ સાધ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","ફિરૌણિ શાસ્ત્રે લિખતિ, અહં ત્વદ્દ્વારા મત્પરાક્રમં દર્શયિતું સર્વ્વપૃથિવ્યાં નિજનામ પ્રકાશયિતુઞ્ચ ત્વાં સ્થાપિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","અતઃ સ યમ્ અનુગ્રહીતુમ્ ઇચ્છતિ તમેવાનુગૃહ્લાતિ, યઞ્ચ નિગ્રહીતુમ્ ઇચ્છતિ તં નિગૃહ્લાતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","યદિ વદસિ તર્હિ સ દોષં કુતો ગૃહ્લાતિ? તદીયેચ્છાયાઃ પ્રતિબન્ધકત્વં કર્ત્તં કસ્ય સામર્થ્યં વિદ્યતે? ");
INSERT INTO sanguj_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","હે ઈશ્વરસ્ય પ્રતિપક્ષ મર્ત્ય ત્વં કઃ? એતાદૃશં માં કુતઃ સૃષ્ટવાન્? ઇતિ કથાં સૃષ્ટવસ્તુ સ્રષ્ટ્રે કિં કથયિષ્યતિ? ");
INSERT INTO sanguj_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","એકસ્માન્ મૃત્પિણ્ડાદ્ ઉત્કૃષ્ટાપકૃષ્ટૌ દ્વિવિધૌ કલશૌ કર્ત્તું કિં કુલાલસ્ય સામર્થ્યં નાસ્તિ? ");
INSERT INTO sanguj_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","ઈશ્વરઃ કોપં પ્રકાશયિતું નિજશક્તિં જ્ઞાપયિતુઞ્ચેચ્છન્ યદિ વિનાશસ્ય યોગ્યાનિ ક્રોધભાજનાનિ પ્રતિ બહુકાલં દીર્ઘસહિષ્ણુતામ્ આશ્રયતિ; ");
INSERT INTO sanguj_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","અપરઞ્ચ વિભવપ્રાપ્ત્યર્થં પૂર્વ્વં નિયુક્તાન્યનુગ્રહપાત્રાણિ પ્રતિ નિજવિભવસ્ય બાહુલ્યં પ્રકાશયિતું કેવલયિહૂદિનાં નહિ ભિન્નદેશિનામપિ મધ્યાદ્ ");
INSERT INTO sanguj_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","અસ્માનિવ તાન્યાહ્વયતિ તત્ર તવ કિં? ");
INSERT INTO sanguj_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","હોશેયગ્રન્થે યથા લિખિતમ્ આસ્તે, યો લોકો મમ નાસીત્ તં વદિષ્યામિ મદીયકં| યા જાતિ ર્મેઽપ્રિયા ચાસીત્ તાં વદિષ્યામ્યહં પ્રિયાં| ");
INSERT INTO sanguj_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","યૂયં મદીયલોકા ન યત્રેતિ વાક્યમૌચ્યત| અમરેશસ્ય સન્તાના ઇતિ ખ્યાસ્યન્તિ તત્ર તે| ");
INSERT INTO sanguj_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","ઇસ્રાયેલીયલોકેષુ યિશાયિયોઽપિ વાચમેતાં પ્રાચારયત્, ઇસ્રાયેલીયવંશાનાં યા સંખ્યા સા તુ નિશ્ચિતં| સમુદ્રસિકતાસંખ્યાસમાના યદિ જાયતે| તથાપિ કેવલં લોકૈરલ્પૈસ્ત્રાણં વ્રજિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","યતો ન્યાયેન સ્વં કર્મ્મ પરેશઃ સાધયિષ્યતિ| દેશે સએવ સંક્ષેપાન્નિજં કર્મ્મ કરિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","યિશાયિયોઽપરમપિ કથયામાસ, સૈન્યાધ્યક્ષપરેશેન ચેત્ કિઞ્ચિન્નોદશિષ્યત| તદા વયં સિદોમેવાભવિષ્યામ વિનિશ્ચિતં| યદ્વા વયમ્ અમોરાયા અગમિષ્યામ તુલ્યતાં| ");
INSERT INTO sanguj_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","તર્હિ વયં કિં વક્ષ્યામઃ? ઇતરદેશીયા લોકા અપિ પુણ્યાર્થમ્ અયતમાના વિશ્વાસેન પુણ્યમ્ અલભન્ત; ");
INSERT INTO sanguj_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","કિન્ત્વિસ્રાયેલ્લોકા વ્યવસ્થાપાલનેન પુણ્યાર્થં યતમાનાસ્તન્ નાલભન્ત| ");
INSERT INTO sanguj_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","તસ્ય કિં કારણં? તે વિશ્વાસેન નહિ કિન્તુ વ્યવસ્થાયાઃ ક્રિયયા ચેષ્ટિત્વા તસ્મિન્ સ્ખલનજનકે પાષાણે પાદસ્ખલનં પ્રાપ્તાઃ| ");
INSERT INTO sanguj_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","લિખિતં યાદૃશમ્ આસ્તે, પશ્ય પાદસ્ખલાર્થં હિ સીયોનિ પ્રસ્તરન્તથા| બાધાકારઞ્ચ પાષાણં પરિસ્થાપિતવાનહમ્| વિશ્વસિષ્યતિ યસ્તત્ર સ જનો ન ત્રપિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","હે ભ્રાતર ઇસ્રાયેલીયલોકા યત્ પરિત્રાણં પ્રાપ્નુવન્તિ તદહં મનસાભિલષન્ ઈશ્વરસ્ય સમીપે પ્રાર્થયે| ");
INSERT INTO sanguj_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","યત ઈશ્વરે તેષાં ચેષ્ટા વિદ્યત ઇત્યત્રાહં સાક્ષ્યસ્મિ; કિન્તુ તેષાં સા ચેષ્ટા સજ્ઞાના નહિ, ");
INSERT INTO sanguj_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","યતસ્ત ઈશ્વરદત્તં પુણ્યમ્ અવિજ્ઞાય સ્વકૃતપુણ્યં સ્થાપયિતુમ્ ચેષ્ટમાના ઈશ્વરદત્તસ્ય પુણ્યસ્ય નિઘ્નત્વં ન સ્વીકુર્વ્વન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","ખ્રીષ્ટ એકૈકવિશ્વાસિજનાય પુણ્યં દાતું વ્યવસ્થાયાઃ ફલસ્વરૂપો ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","વ્યવસ્થાપાલનેન યત્ પુણ્યં તત્ મૂસા વર્ણયામાસ, યથા, યો જનસ્તાં પાલયિષ્યતિ સ તદ્દ્વારા જીવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","કિન્તુ પ્રત્યયેન યત્ પુણ્યં તદ્ એતાદૃશં વાક્યં વદતિ, કઃ સ્વર્ગમ્ આરુહ્ય ખ્રીષ્ટમ્ અવરોહયિષ્યતિ? ");
INSERT INTO sanguj_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","કો વા પ્રેતલોકમ્ અવરુહ્ય ખ્રીષ્ટં મૃતગણમધ્યાદ્ આનેષ્યતીતિ વાક્ મનસિ ત્વયા ન ગદિતવ્યા| ");
INSERT INTO sanguj_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","તર્હિ કિં બ્રવીતિ? તદ્ વાક્યં તવ સમીપસ્થમ્ અર્થાત્ તવ વદને મનસિ ચાસ્તે, તચ્ચ વાક્યમ્ અસ્માભિઃ પ્રચાર્ય્યમાણં વિશ્વાસસ્ય વાક્યમેવ| ");
INSERT INTO sanguj_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","વસ્તુતઃ પ્રભું યીશું યદિ વદનેન સ્વીકરોષિ, તથેશ્વરસ્તં શ્મશાનાદ્ ઉદસ્થાપયદ્ ઇતિ યદ્યન્તઃકરણેન વિશ્વસિષિ તર્હિ પરિત્રાણં લપ્સ્યસે| ");
INSERT INTO sanguj_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","યસ્માત્ પુણ્યપ્રાપ્ત્યર્થમ્ અન્તઃકરણેન વિશ્વસિતવ્યં પરિત્રાણાર્થઞ્ચ વદનેન સ્વીકર્ત્તવ્યં| ");
INSERT INTO sanguj_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","શાસ્ત્રે યાદૃશં લિખતિ વિશ્વસિષ્યતિ યસ્તત્ર સ જનો ન ત્રપિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","ઇત્યત્ર યિહૂદિનિ તદન્યલોકે ચ કોપિ વિશેષો નાસ્તિ યસ્માદ્ યઃ સર્વ્વેષામ્ અદ્વિતીયઃ પ્રભુઃ સ નિજયાચકાન સર્વ્વાન્ પ્રતિ વદાન્યો ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","યતઃ, યઃ કશ્ચિત્ પરમેશસ્ય નામ્ના હિ પ્રાર્થયિષ્યતે| સ એવ મનુજો નૂનં પરિત્રાતો ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","યં યે જના ન પ્રત્યાયન્ તે તમુદ્દિશ્ય કથં પ્રાર્થયિષ્યન્તે? યે વા યસ્યાખ્યાનં કદાપિ ન શ્રુતવન્તસ્તે તં કથં પ્રત્યેષ્યન્તિ? અપરં યદિ પ્રચારયિતારો ન તિષ્ઠન્તિ તદા કથં તે શ્રોષ્યન્તિ? ");
INSERT INTO sanguj_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","યદિ વા પ્રેરિતા ન ભવન્તિ તદા કથં પ્રચારયિષ્યન્તિ? યાદૃશં લિખિતમ્ આસ્તે, યથા, માઙ્ગલિકં સુસંવાદં દદત્યાનીય યે નરાઃ| પ્રચારયન્તિ શાન્તેશ્ચ સુસંવાદં જનાસ્તુ યે| તેષાં ચરણપદ્માનિ કીદૃક્ શોભાન્વિતાનિ હિ| ");
INSERT INTO sanguj_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","કિન્તુ તે સર્વ્વે તં સુસંવાદં ન ગૃહીતવન્તઃ| યિશાયિયો યથા લિખિતવાન્| અસ્મત્પ્રચારિતે વાક્યે વિશ્વાસમકરોદ્ધિ કઃ| ");
INSERT INTO sanguj_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","અતએવ શ્રવણાદ્ વિશ્વાસ ઐશ્વરવાક્યપ્રચારાત્ શ્રવણઞ્ચ ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","તર્હ્યહં બ્રવીમિ તૈઃ કિં નાશ્રાવિ? અવશ્યમ્ અશ્રાવિ, યસ્માત્ તેષાં શબ્દો મહીં વ્યાપ્નોદ્ વાક્યઞ્ચ નિખિલં જગત્| ");
INSERT INTO sanguj_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","અપરમપિ વદામિ, ઇસ્રાયેલીયલોકાઃ કિમ્ એતાં કથાં ન બુધ્યન્તે? પ્રથમતો મૂસા ઇદં વાક્યં પ્રોવાચ, અહમુત્તાપયિષ્યે તાન્ અગણ્યમાનવૈરપિ| ક્લેક્ષ્યામિ જાતિમ્ એતાઞ્ચ પ્રોન્મત્તભિન્નજાતિભિઃ| ");
INSERT INTO sanguj_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","અપરઞ્ચ યિશાયિયોઽતિશયાક્ષોભેણ કથયામાસ, યથા, અધિ માં યૈસ્તુ નાચેષ્ટિ સમ્પ્રાપ્તસ્તૈ ર્જનૈરહં| અધિ માં યૈ ર્ન સમ્પૃષ્ટં વિજ્ઞાતસ્તૈ ર્જનૈરહં|| ");
INSERT INTO sanguj_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","કિન્ત્વિસ્રાયેલીયલોકાન્ અધિ કથયાઞ્ચકાર, યૈરાજ્ઞાલઙ્ઘિભિ ર્લોકૈ ર્વિરુદ્ધં વાક્યમુચ્યતે| તાન્ પ્રત્યેવ દિનં કૃત્સ્નં હસ્તૌ વિસ્તારયામ્યહં|| ");
INSERT INTO sanguj_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","ઈશ્વરેણ સ્વીકીયલોકા અપસારિતા અહં કિમ્ ઈદૃશં વાક્યં બ્રવીમિ? તન્ન ભવતુ યતોઽહમપિ બિન્યામીનગોત્રીય ઇબ્રાહીમવંશીય ઇસ્રાયેલીયલોકોઽસ્મિ| ");
INSERT INTO sanguj_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","ઈશ્વરેણ પૂર્વ્વં યે પ્રદૃષ્ટાસ્તે સ્વકીયલોકા અપસારિતા ઇતિ નહિ| અપરમ્ એલિયોપાખ્યાને શાસ્ત્રે યલ્લિખિતમ્ આસ્તે તદ્ યૂયં કિં ન જાનીથ? ");
INSERT INTO sanguj_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","હે પરમેશ્વર લોકાસ્ત્વદીયાઃ સર્વ્વા યજ્ઞવેદીરભઞ્જન્ તથા તવ ભવિષ્યદ્વાદિનઃ સર્વ્વાન્ અઘ્નન્ કેવલ એકોઽહમ્ અવશિષ્ટ આસે તે મમાપિ પ્રાણાન્ નાશયિતું ચેષ્ટનતે, એતાં કથામ્ ઇસ્રાયેલીયલોકાનાં વિરુદ્ધમ્ એલિય ઈશ્વરાય નિવેદયામાસ| ");
INSERT INTO sanguj_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","તતસ્તં પ્રતીશ્વરસ્યોત્તરં કિં જાતં? બાલ્નામ્નો દેવસ્ય સાક્ષાત્ યૈ ર્જાનૂનિ ન પાતિતાનિ તાદૃશાઃ સપ્ત સહસ્રાણિ લોકા અવશેષિતા મયા| ");
INSERT INTO sanguj_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","તદ્વદ્ એતસ્મિન્ વર્ત્તમાનકાલેઽપિ અનુગ્રહેણાભિરુચિતાસ્તેષામ્ અવશિષ્ટાઃ કતિપયા લોકાઃ સન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","અતએવ તદ્ યદ્યનુગ્રહેણ ભવતિ તર્હિ ક્રિયયા ન ભવતિ નો ચેદ્ અનુગ્રહોઽનનુગ્રહ એવ, યદિ વા ક્રિયયા ભવતિ તર્હ્યનુગ્રહેણ ન ભવતિ નો ચેત્ ક્રિયા ક્રિયૈવ ન ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","તર્હિ કિં? ઇસ્રાયેલીયલોકા યદ્ અમૃગયન્ત તન્ન પ્રાપુઃ| કિન્ત્વભિરુચિતલોકાસ્તત્ પ્રાપુસ્તદન્યે સર્વ્વ અન્ધીભૂતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","યથા લિખિતમ્ આસ્તે, ઘોરનિદ્રાલુતાભાવં દૃષ્ટિહીને ચ લોચને| કર્ણૌ શ્રુતિવિહીનૌ ચ પ્રદદૌ તેભ્ય ઈશ્વરઃ|| ");
INSERT INTO sanguj_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","એતેસ્મિન્ દાયૂદપિ લિખિતવાન્ યથા, અતો ભુક્ત્યાસનં તેષામ્ ઉન્માથવદ્ ભવિષ્યતિ| વા વંશયન્ત્રવદ્ બાધા દણ્ડવદ્ વા ભવિષ્યતિ|| ");
INSERT INTO sanguj_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","ભવિષ્યન્તિ તથાન્ધાસ્તે નેત્રૈઃ પશ્યન્તિ નો યથા| વેપથુઃ કટિદેશસ્ય તેષાં નિત્યં ભવિષ્યતિ|| ");
INSERT INTO sanguj_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","પતનાર્થં તે સ્ખલિતવન્ત ઇતિ વાચં કિમહં વદામિ? તન્ન ભવતુ કિન્તુ તાન્ ઉદ્યોગિનઃ કર્ત્તું તેષાં પતનાદ્ ઇતરદેશીયલોકૈઃ પરિત્રાણં પ્રાપ્તં| ");
INSERT INTO sanguj_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","તેષાં પતનં યદિ જગતો લોકાનાં લાભજનકમ્ અભવત્ તેષાં હ્રાસોઽપિ યદિ ભિન્નદેશિનાં લાભજનકોઽભવત્ તર્હિ તેષાં વૃદ્ધિઃ કતિ લાભજનિકા ભવિષ્યતિ? ");
INSERT INTO sanguj_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","અતો હે અન્યદેશિનો યુષ્માન્ સમ્બોધ્ય કથયામિ નિજાનાં જ્ઞાતિબન્ધૂનાં મનઃસૂદ્યોગં જનયન્ તેષાં મધ્યે કિયતાં લોકાનાં યથા પરિત્રાણં સાધયામિ ");
INSERT INTO sanguj_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","તન્નિમિત્તમ્ અન્યદેશિનાં નિકટે પ્રેરિતઃ સન્ અહં સ્વપદસ્ય મહિમાનં પ્રકાશયામિ| ");
INSERT INTO sanguj_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","તેષાં નિગ્રહેણ યદીશ્વરેણ સહ જગતો જનાનાં મેલનં જાતં તર્હિ તેષામ્ અનુગૃહીતત્વં મૃતદેહે યથા જીવનલાભસ્તદ્વત્ કિં ન ભવિષ્યતિ? ");
INSERT INTO sanguj_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","અપરં પ્રથમજાતં ફલં યદિ પવિત્રં ભવતિ તર્હિ સર્વ્વમેવ ફલં પવિત્રં ભવિષ્યતિ; તથા મૂલં યદિ પવિત્રં ભવતિ તર્હિ શાખા અપિ તથૈવ ભવિષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","કિયતીનાં શાખાનાં છેદને કૃતે ત્વં વન્યજિતવૃક્ષસ્ય શાખા ભૂત્વા યદિ તચ્છાખાનાં સ્થાને રોપિતા સતિ જિતવૃક્ષીયમૂલસ્ય રસં ભુંક્ષે, ");
INSERT INTO sanguj_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","તર્હિ તાસાં ભિન્નશાખાનાં વિરુદ્ધં માં ગર્વ્વીઃ; યદિ ગર્વ્વસિ તર્હિ ત્વં મૂલં યન્ન ધારયસિ કિન્તુ મૂલં ત્વાં ધારયતીતિ સંસ્મર| ");
INSERT INTO sanguj_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","અપરઞ્ચ યદિ વદસિ માં રોપયિતું તાઃ શાખા વિભન્ના અભવન્; ");
INSERT INTO sanguj_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","ભદ્રમ્, અપ્રત્યયકારણાત્ તે વિભિન્ના જાતાસ્તથા વિશ્વાસકારણાત્ ત્વં રોપિતો જાતસ્તસ્માદ્ અહઙ્કારમ્ અકૃત્વા સસાધ્વસો ભવ| ");
INSERT INTO sanguj_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","યત ઈશ્વરો યદિ સ્વાભાવિકીઃ શાખા ન રક્ષતિ તર્હિ સાવધાનો ભવ ચેત્ ત્વામપિ ન સ્થાપયતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","ઇત્યત્રેશ્વરસ્ય યાદૃશી કૃપા તાદૃશં ભયાનકત્વમપિ ત્વયા દૃશ્યતાં; યે પતિતાસ્તાન્ પ્રતિ તસ્ય ભયાનકત્વં દૃશ્યતાં, ત્વઞ્ચ યદિ તત્કૃપાશ્રિતસ્તિષ્ઠસિ તર્હિ ત્વાં પ્રતિ કૃપા દ્રક્ષ્યતે; નો ચેત્ ત્વમપિ તદ્વત્ છિન્નો ભવિષ્યસિ| ");
INSERT INTO sanguj_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","અપરઞ્ચ તે યદ્યપ્રત્યયે ન તિષ્ઠન્તિ તર્હિ પુનરપિ રોપયિષ્યન્તે યસ્માત્ તાન્ પુનરપિ રોપયિતુમ્ ઇશ્વરસ્ય શક્તિરાસ્તે| ");
INSERT INTO sanguj_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","વન્યજિતવૃક્ષસ્ય શાખા સન્ ત્વં યદિ તતશ્છિન્નો રીતિવ્યત્યયેનોત્તમજિતવૃક્ષે રોेेપિતોઽભવસ્તર્હિ તસ્ય વૃક્ષસ્ય સ્વીયા યાઃ શાખાસ્તાઃ કિં પુનઃ સ્વવૃક્ષે સંલગિતું ન શક્નુવન્તિ? ");
INSERT INTO sanguj_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","હે ભ્રાતરો યુષ્માકમ્ આત્માભિમાનો યન્ન જાયતે તદર્થં મમેદૃશી વાઞ્છા ભવતિ યૂયં એતન્નિગૂઢતત્ત્વમ્ અજાનન્તો યન્ન તિષ્ઠથ; વસ્તુતો યાવત્કાલં સમ્પૂર્ણરૂપેણ ભિન્નદેશિનાં સંગ્રહો ન ભવિષ્યતિ તાવત્કાલમ્ અંશત્વેન ઇસ્રાયેલીયલોકાનામ્ અન્ધતા સ્થાસ્યતિ; ");
INSERT INTO sanguj_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","પશ્ચાત્ તે સર્વ્વે પરિત્રાસ્યન્તે; એતાદૃશં લિખિતમપ્યાસ્તે, આગમિષ્યતિ સીયોનાદ્ એકો યસ્ત્રાણદાયકઃ| અધર્મ્મં યાકુબો વંશાત્ સ તુ દૂરીકરિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","તથા દૂરીકરિષ્યામિ તેષાં પાપાન્યહં યદા| તદા તૈરેવ સાર્દ્ધં મે નિયમોઽયં ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","સુસંવાદાત્ તે યુષ્માકં વિપક્ષા અભવન્ કિન્ત્વભિરુચિતત્વાત્ તે પિતૃલોકાનાં કૃતે પ્રિયપાત્રાણિ ભવન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","યત ઈશ્વરસ્ય દાનાદ્ આહ્વાનાઞ્ચ પશ્ચાત્તાપો ન ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","અતએવ પૂર્વ્વમ્ ઈશ્વરેઽવિશ્વાસિનઃ સન્તોઽપિ યૂયં યદ્વત્ સમ્પ્રતિ તેષામ્ અવિશ્વાસકારણાદ્ ઈશ્વરસ્ય કૃપાપાત્રાણિ જાતાસ્તદ્વદ્ ");
INSERT INTO sanguj_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","ઇદાનીં તેઽવિશ્વાસિનઃ સન્તિ કિન્તુ યુષ્માભિ ર્લબ્ધકૃપાકારણાત્ તૈરપિ કૃપા લપ્સ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","ઈશ્વરઃ સર્વ્વાન્ પ્રતિ કૃપાં પ્રકાશયિતું સર્વ્વાન્ અવિશ્વાસિત્વેન ગણયતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","અહો ઈશ્વરસ્ય જ્ઞાનબુદ્ધિરૂપયો ર્ધનયોઃ કીદૃક્ પ્રાચુર્ય્યં| તસ્ય રાજશાસનસ્ય તત્ત્વં કીદૃગ્ અપ્રાપ્યં| તસ્ય માર્ગાશ્ચ કીદૃગ્ અનુપલક્ષ્યાઃ| ");
INSERT INTO sanguj_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","પરમેશ્વરસ્ય સઙ્કલ્પં કો જ્ઞાતવાન્? તસ્ય મન્ત્રી વા કોઽભવત્? ");
INSERT INTO sanguj_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","કો વા તસ્યોપકારી ભૃત્વા તત્કૃતે તેન પ્રત્યુપકર્ત્તવ્યઃ? ");
INSERT INTO sanguj_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","યતો વસ્તુમાત્રમેવ તસ્માત્ તેન તસ્મૈ ચાભવત્ તદીયો મહિમા સર્વ્વદા પ્રકાશિતો ભવતુ| ઇતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","હે ભ્રાતર ઈશ્વરસ્ય કૃપયાહં યુષ્માન્ વિનયે યૂયં સ્વં સ્વં શરીરં સજીવં પવિત્રં ગ્રાહ્યં બલિમ્ ઈશ્વરમુદ્દિશ્ય સમુત્સૃજત, એષા સેવા યુષ્માકં યોગ્યા| ");
INSERT INTO sanguj_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","અપરં યૂયં સાંસારિકા ઇવ માચરત, કિન્તુ સ્વં સ્વં સ્વભાવં પરાવર્ત્ય નૂતનાચારિણો ભવત, તત ઈશ્વરસ્ય નિદેશઃ કીદૃગ્ ઉત્તમો ગ્રહણીયઃ સમ્પૂર્ણશ્ચેતિ યુષ્માભિરનુભાવિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","કશ્ચિદપિ જનો યોગ્યત્વાદધિકં સ્વં ન મન્યતાં કિન્તુ ઈશ્વરો યસ્મૈ પ્રત્યયસ્ય યત્પરિમાણમ્ અદદાત્ સ તદનુસારતો યોગ્યરૂપં સ્વં મનુતામ્, ઈશ્વરાદ્ અનુગ્રહં પ્રાપ્તઃ સન્ યુષ્માકમ્ એકૈકં જનમ્ ઇત્યાજ્ઞાપયામિ| ");
INSERT INTO sanguj_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","યતો યદ્વદસ્માકમ્ એકસ્મિન્ શરીરે બહૂન્યઙ્ગાનિ સન્તિ કિન્તુ સર્વ્વેષામઙ્ગાનાં કાર્ય્યં સમાનં નહિ; ");
INSERT INTO sanguj_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","તદ્વદસ્માકં બહુત્વેઽપિ સર્વ્વે વયં ખ્રીષ્ટે એકશરીરાઃ પરસ્પરમ્ અઙ્ગપ્રત્યઙ્ગત્વેન ભવામઃ| ");
INSERT INTO sanguj_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","અસ્માદ્ ઈશ્વરાનુગ્રહેણ વિશેષં વિશેષં દાનમ્ અસ્માસુ પ્રાપ્તેષુ સત્સુ કોપિ યદિ ભવિષ્યદ્વાક્યં વદતિ તર્હિ પ્રત્યયસ્ય પરિમાણાનુસારતઃ સ તદ્ વદતુ; ");
INSERT INTO sanguj_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","યદ્વા યદિ કશ્ચિત્ સેવનકારી ભવતિ તર્હિ સ તત્સેવનં કરોતુ; અથવા યદિ કશ્ચિદ્ અધ્યાપયિતા ભવતિ તર્હિ સોઽધ્યાપયતુ; ");
INSERT INTO sanguj_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","તથા ય ઉપદેષ્ટા ભવતિ સ ઉપદિશતુ યશ્ચ દાતા સ સરલતયા દદાતુ યસ્ત્વધિપતિઃ સ યત્નેનાધિપતિત્વં કરોતુ યશ્ચ દયાલુઃ સ હૃષ્ટમનસા દયતામ્| ");
INSERT INTO sanguj_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","અપરઞ્ચ યુષ્માકં પ્રેમ કાપટ્યવર્જિતં ભવતુ યદ્ અભદ્રં તદ્ ઋતીયધ્વં યચ્ચ ભદ્રં તસ્મિન્ અનુરજ્યધ્વમ્| ");
INSERT INTO sanguj_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","અપરં ભ્રાતૃત્વપ્રેમ્ના પરસ્પરં પ્રીયધ્વં સમાદરાદ્ એકોઽપરજનં શ્રેષ્ઠં જાનીધ્વમ્| ");
INSERT INTO sanguj_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","તથા કાર્ય્યે નિરાલસ્યા મનસિ ચ સોદ્યોગાઃ સન્તઃ પ્રભું સેવધ્વમ્| ");
INSERT INTO sanguj_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","અપરં પ્રત્યાશાયામ્ આનન્દિતા દુઃખસમયે ચ ધૈર્ય્યયુક્તા ભવત; પ્રાર્થનાયાં સતતં પ્રવર્ત્તધ્વં| ");
INSERT INTO sanguj_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","પવિત્રાણાં દીનતાં દૂરીકુરુધ્વમ્ અતિથિસેવાયામ્ અનુરજ્યધ્વમ્| ");
INSERT INTO sanguj_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","યે જના યુષ્માન્ તાડયન્તિ તાન્ આશિષં વદત શાપમ્ અદત્ત્વા દદ્ધ્વમાશિષમ્| ");
INSERT INTO sanguj_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","યે જના આનન્દન્તિ તૈઃ સાર્દ્ધમ્ આનન્દત યે ચ રુદન્તિ તૈઃ સહ રુદિત| ");
INSERT INTO sanguj_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","અપરઞ્ચ યુષ્માકં મનસાં પરસ્પરમ્ એકોભાવો ભવતુ; અપરમ્ ઉચ્ચપદમ્ અનાકાઙ્ક્ષ્ય નીચલોકૈઃ સહાપિ માર્દવમ્ આચરત; સ્વાન્ જ્ઞાનિનો ન મન્યધ્વં| ");
INSERT INTO sanguj_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","પરસ્માદ્ અપકારં પ્રાપ્યાપિ પરં નાપકુરુત| સર્વ્વેષાં દૃષ્ટિતો યત્ કર્મ્મોત્તમં તદેવ કુરુત| ");
INSERT INTO sanguj_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","યદિ ભવિતું શક્યતે તર્હિ યથાશક્તિ સર્વ્વલોકૈઃ સહ નિર્વ્વિરોધેન કાલં યાપયત| ");
INSERT INTO sanguj_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","હે પ્રિયબન્ધવઃ, કસ્મૈચિદ્ અપકારસ્ય સમુચિતં દણ્ડં સ્વયં ન દદ્ધ્વં, કિન્ત્વીશ્વરીયક્રોધાય સ્થાનં દત્ત યતો લિખિતમાસ્તે પરમેશ્વરઃ કથયતિ, દાનં ફલસ્ય મત્કર્મ્મ સૂચિતં પ્રદદામ્યહં| ");
INSERT INTO sanguj_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","ઇતિકારણાદ્ રિપુ ર્યદિ ક્ષુધાર્ત્તસ્તે તર્હિ તં ત્વં પ્રભોજય| તથા યદિ તૃષાર્ત્તઃ સ્યાત્ તર્હિ તં પરિપાયય| તેન ત્વં મસ્તકે તસ્ય જ્વલદગ્નિં નિધાસ્યસિ| ");
INSERT INTO sanguj_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","કુક્રિયયા પરાજિતા ન સન્ત ઉત્તમક્રિયયા કુક્રિયાં પરાજયત| ");
INSERT INTO sanguj_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","યુષ્માકમ્ એકૈકજનઃ શાસનપદસ્ય નિઘ્નો ભવતુ યતો યાનિ શાસનપદાનિ સન્તિ તાનિ સર્વ્વાણીશ્વરેણ સ્થાપિતાનિ; ઈશ્વરં વિના પદસ્થાપનં ન ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","ઇતિ હેતોઃ શાસનપદસ્ય યત્ પ્રાતિકૂલ્યં તદ્ ઈશ્વરીયનિરૂપણસ્ય પ્રાતિકૂલ્યમેવ; અપરં યે પ્રાતિકૂલ્યમ્ આચરન્તિ તે સ્વેષાં સમુચિતં દણ્ડં સ્વયમેવ ઘટયન્તે| ");
INSERT INTO sanguj_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","શાસ્તા સદાચારિણાં ભયપ્રદો નહિ દુરાચારિણામેવ ભયપ્રદો ભવતિ; ત્વં કિં તસ્માન્ નિર્ભયો ભવિતુમ્ ઇચ્છસિ? તર્હિ સત્કર્મ્માચર, તસ્માદ્ યશો લપ્સ્યસે, ");
INSERT INTO sanguj_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","યતસ્તવ સદાચરણાય સ ઈશ્વરસ્ય ભૃત્યોઽસ્તિ| કિન્તુ યદિ કુકર્મ્માચરસિ તર્હિ ત્વં શઙ્કસ્વ યતઃ સ નિરર્થકં ખઙ્ગં ન ધારયતિ; કુકર્મ્માચારિણં સમુચિતં દણ્ડયિતુમ્ સ ઈશ્વરસ્ય દણ્ડદભૃત્ય એવ| ");
INSERT INTO sanguj_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","અતએવ કેવલદણ્ડભયાન્નહિ કિન્તુ સદસદ્બોધાદપિ તસ્ય વશ્યેન ભવિતવ્યં| ");
INSERT INTO sanguj_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","એતસ્માદ્ યુષ્માકં રાજકરદાનમપ્યુચિતં યસ્માદ્ યે કરં ગૃહ્લન્તિ ત ઈશ્વરસ્ય કિઙ્કરા ભૂત્વા સતતમ્ એતસ્મિન્ કર્મ્મણિ નિવિષ્ટાસ્તિષ્ઠન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","અસ્માત્ કરગ્રાહિણે કરં દત્ત, તથા શુલ્કગ્રાહિણે શુલ્કં દત્ત, અપરં યસ્માદ્ ભેતવ્યં તસ્માદ્ બિભીત, યશ્ચ સમાદરણીયસ્તં સમાદ્રિયધ્વમ્; ઇત્થં યસ્ય યત્ પ્રાપ્યં તત્ તસ્મૈ દત્ત| ");
INSERT INTO sanguj_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","યુષ્માકં પરસ્પરં પ્રેમ વિના ઽન્યત્ કિમપિ દેયમ્ ઋણં ન ભવતુ, યતો યઃ પરસ્મિન્ પ્રેમ કરોતિ તેન વ્યવસ્થા સિધ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","વસ્તુતઃ પરદારાન્ મા ગચ્છ, નરહત્યાં મા કાર્ષીઃ, ચૈર્ય્યં મા કાર્ષીઃ, મિથ્યાસાક્ષ્યં મા દેહિ, લોભં મા કાર્ષીઃ, એતાઃ સર્વ્વા આજ્ઞા એતાભ્યો ભિન્ના યા કાચિદ્ આજ્ઞાસ્તિ સાપિ સ્વસમીપવાસિનિ સ્વવત્ પ્રેમ કુર્વ્વિત્યનેન વચનેન વેદિતા| ");
INSERT INTO sanguj_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","યતઃ પ્રેમ સમીપવાસિનોઽશુભં ન જનયતિ તસ્માત્ પ્રેમ્ના સર્વ્વા વ્યવસ્થા પાલ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","પ્રત્યયીભવનકાલેઽસ્માકં પરિત્રાણસ્ય સામીપ્યાદ્ ઇદાનીં તસ્ય સામીપ્યમ્ અવ્યવહિતં; અતઃ સમયં વિવિચ્યાસ્માભિઃ સામ્પ્રતમ્ અવશ્યમેવ નિદ્રાતો જાગર્ત્તવ્યં| ");
INSERT INTO sanguj_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","બહુતરા યામિની ગતા પ્રભાતં સન્નિધિં પ્રાપ્તં તસ્માત્ તામસીયાઃ ક્રિયાઃ પરિત્યજ્યાસ્માભિ ર્વાસરીયા સજ્જા પરિધાતવ્યા| ");
INSERT INTO sanguj_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","અતો હેતો ર્વયં દિવા વિહિતં સદાચરણમ્ આચરિષ્યામઃ| રઙ્ગરસો મત્તત્વં લમ્પટત્વં કામુકત્વં વિવાદ ઈર્ષ્યા ચૈતાનિ પરિત્યક્ષ્યામઃ| ");
INSERT INTO sanguj_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","યૂયં પ્રભુયીશુખ્રીષ્ટરૂપં પરિચ્છદં પરિધદ્ધ્વં સુખાભિલાષપૂરણાય શારીરિકાચરણં માચરત| ");
INSERT INTO sanguj_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","યો જનોઽદૃઢવિશ્વાસસ્તં યુષ્માકં સઙ્ગિનં કુરુત કિન્તુ સન્દેહવિચારાર્થં નહિ| ");
INSERT INTO sanguj_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","યતો નિષિદ્ધં કિમપિ ખાદ્યદ્રવ્યં નાસ્તિ, કસ્યચિજ્જનસ્ય પ્રત્યય એતાદૃશો વિદ્યતે કિન્ત્વદૃઢવિશ્વાસઃ કશ્ચિદપરો જનઃ કેવલં શાકં ભુઙ્ક્તં| ");
INSERT INTO sanguj_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","તર્હિ યો જનઃ સાધારણં દ્રવ્યં ભુઙ્ક્તે સ વિશેષદ્રવ્યભોક્તારં નાવજાનીયાત્ તથા વિશેષદ્રવ્યભોક્તાપિ સાધારણદ્રવ્યભોક્તારં દોષિણં ન કુર્ય્યાત્, યસ્માદ્ ઈશ્વરસ્તમ્ અગૃહ્લાત્| ");
INSERT INTO sanguj_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","હે પરદાસસ્ય દૂષયિતસ્ત્વં કઃ? નિજપ્રભોઃ સમીપે તેન પદસ્થેન પદચ્યુતેન વા ભવિતવ્યં સ ચ પદસ્થ એવ ભવિષ્યતિ યત ઈશ્વરસ્તં પદસ્થં કર્ત્તું શક્નોતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","અપરઞ્ચ કશ્ચિજ્જનો દિનાદ્ દિનં વિશેષં મન્યતે કશ્ચિત્તુु સર્વ્વાણિ દિનાનિ સમાનાનિ મન્યતે, એકૈકો જનઃ સ્વીયમનસિ વિવિચ્ય નિશ્ચિનોતુ| ");
INSERT INTO sanguj_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","યો જનઃ કિઞ્ચન દિનં વિશેષં મન્યતે સ પ્રભુભક્ત્યા તન્ મન્યતે, યશ્ચ જનઃ કિમપિ દિનં વિશેષં ન મન્યતે સોઽપિ પ્રભુભક્ત્યા તન્ન મન્યતે; અપરઞ્ચ યઃ સર્વ્વાણિ ભક્ષ્યદ્રવ્યાણિ ભુઙ્ક્તે સ પ્રભુભક્તયા તાનિ ભુઙ્ક્તે યતઃ સ ઈશ્વરં ધન્યં વક્તિ, યશ્ચ ન ભુઙ્ક્તે સોઽપિ પ્રભુભક્ત્યૈવ ન ભુઞ્જાન ઈશ્વરં ધન્યં બ્રૂતે| ");
INSERT INTO sanguj_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","અપરમ્ અસ્માકં કશ્ચિત્ નિજનિમિત્તં પ્રાણાન્ ધારયતિ નિજનિમિત્તં મ્રિયતે વા તન્ન; ");
INSERT INTO sanguj_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","કિન્તુ યદિ વયં પ્રાણાન્ ધારયામસ્તર્હિ પ્રભુનિમિત્તં ધારયામઃ, યદિ ચ પ્રાણાન્ ત્યજામસ્તર્હ્યપિ પ્રભુનિમિત્તં ત્યજામઃ, અતએવ જીવને મરણે વા વયં પ્રભોરેવાસ્મહે| ");
INSERT INTO sanguj_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","યતો જીવન્તો મૃતાશ્ચેત્યુભયેષાં લોકાનાં પ્રભુત્વપ્રાપ્ત્યર્થં ખ્રીષ્ટો મૃત ઉત્થિતઃ પુનર્જીવિતશ્ચ| ");
INSERT INTO sanguj_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","કિન્તુ ત્વં નિજં ભ્રાતરં કુતો દૂષયસિ? તથા ત્વં નિજં ભ્રાતરં કુતસ્તુચ્છં જાનાસિ? ખ્રીષ્ટસ્ય વિચારસિંહાસનસ્ય સમ્મુખે સર્વ્વૈરસ્માભિરુપસ્થાતવ્યં; ");
INSERT INTO sanguj_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","યાદૃશં લિખિતમ્ આસ્તે, પરેશઃ શપથં કુર્વ્વન્ વાક્યમેતત્ પુરાવદત્| સર્વ્વો જનઃ સમીપે મે જાનુપાતં કરિષ્યતિ| જિહ્વૈકૈકા તથેશસ્ય નિઘ્નત્વં સ્વીકરિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","અતએવ ઈશ્વરસમીપેઽસ્માકમ્ એકૈકજનેન નિજા કથા કથયિતવ્યા| ");
INSERT INTO sanguj_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","ઇત્થં સતિ વયમ્ અદ્યારભ્ય પરસ્પરં ન દૂષયન્તઃ સ્વભ્રાતુ ર્વિઘ્નો વ્યાઘાતો વા યન્ન જાયેત તાદૃશીમીહાં કુર્મ્મહે| ");
INSERT INTO sanguj_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","કિમપિ વસ્તુ સ્વભાવતો નાશુચિ ભવતીત્યહં જાને તથા પ્રભુના યીશુખ્રીષ્ટેનાપિ નિશ્ચિતં જાને, કિન્તુ યો જનો યદ્ દ્રવ્યમ્ અપવિત્રં જાનીતે તસ્ય કૃતે તદ્ અપવિત્રમ્ આસ્તે| ");
INSERT INTO sanguj_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","અતએવ તવ ભક્ષ્યદ્રવ્યેણ તવ ભ્રાતા શોકાન્વિતો ભવતિ તર્હિ ત્વં ભ્રાતરં પ્રતિ પ્રેમ્ના નાચરસિ| ખ્રીષ્ટો યસ્ય કૃતે સ્વપ્રાણાન્ વ્યયિતવાન્ ત્વં નિજેન ભક્ષ્યદ્રવ્યેણ તં ન નાશય| ");
INSERT INTO sanguj_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","અપરં યુષ્માકમ્ ઉત્તમં કર્મ્મ નિન્દિતં ન ભવતુ| ");
INSERT INTO sanguj_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","ભક્ષ્યં પેયઞ્ચેશ્વરરાજ્યસ્ય સારો નહિ, કિન્તુ પુણ્યં શાન્તિશ્ચ પવિત્રેણાત્મના જાત આનન્દશ્ચ| ");
INSERT INTO sanguj_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","એતૈ ર્યો જનઃ ખ્રીષ્ટં સેવતે, સ એવેશ્વરસ્ય તુષ્ટિકરો મનુષ્યૈશ્ચ સુખ્યાતઃ| ");
INSERT INTO sanguj_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","અતએવ યેનાસ્માકં સર્વ્વેષાં પરસ્પરમ્ ઐક્યં નિષ્ઠા ચ જાયતે તદેવાસ્માભિ ર્યતિતવ્યં| ");
INSERT INTO sanguj_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","ભક્ષ્યાર્થમ્ ઈશ્વરસ્ય કર્મ્મણો હાનિં મા જનયત; સર્વ્વં વસ્તુ પવિત્રમિતિ સત્યં તથાપિ યો જનો યદ્ ભુક્ત્વા વિઘ્નં લભતે તદર્થં તદ્ ભદ્રં નહિ| ");
INSERT INTO sanguj_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","તવ માંસભક્ષણસુરાપાનાદિભિઃ ક્રિયાભિ ર્યદિ તવ ભ્રાતુઃ પાદસ્ખલનં વિઘ્નો વા ચાઞ્ચલ્યં વા જાયતે તર્હિ તદ્ભોજનપાનયોસ્ત્યાગો ભદ્રઃ| ");
INSERT INTO sanguj_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","યદિ તવ પ્રત્યયસ્તિષ્ઠતિ તર્હીશ્વરસ્ય ગોચરે સ્વાન્તરે તં ગોપય; યો જનઃ સ્વમતેન સ્વં દોષિણં ન કરોતિ સ એવ ધન્યઃ| ");
INSERT INTO sanguj_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","કિન્તુ યઃ કશ્ચિત્ સંશય્ય ભુઙ્ક્તેઽર્થાત્ ન પ્રતીત્ય ભુઙ્ક્તે, સ એવાવશ્યં દણ્ડાર્હો ભવિષ્યતિ, યતો યત્ પ્રત્યયજં નહિ તદેવ પાપમયં ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","બલવદ્ભિરસ્માભિ ર્દુર્બ્બલાનાં દૌર્બ્બલ્યં સોઢવ્યં ન ચ સ્વેષામ્ ઇષ્ટાચાર આચરિતવ્યઃ| ");
INSERT INTO sanguj_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","અસ્માકમ્ એકૈકો જનઃ સ્વસમીપવાસિનો હિતાર્થં નિષ્ઠાર્થઞ્ચ તસ્યૈવેષ્ટાચારમ્ આચરતુ| ");
INSERT INTO sanguj_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","યતઃ ખ્રીષ્ટોઽપિ નિજેષ્ટાચારં નાચરિતવાન્, યથા લિખિતમ્ આસ્તે, ત્વન્નિન્દકગણસ્યૈવ નિન્દાભિ ર્નિન્દિતોઽસ્મ્યહં| ");
INSERT INTO sanguj_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","અપરઞ્ચ વયં યત્ સહિષ્ણુતાસાન્ત્વનયો ર્જનકેન શાસ્ત્રેણ પ્રત્યાશાં લભેમહિ તન્નિમિત્તં પૂર્વ્વકાલે લિખિતાનિ સર્વ્વવચનાન્યસ્માકમ્ ઉપદેશાર્થમેવ લિલિખિરે| ");
INSERT INTO sanguj_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","સહિષ્ણુતાસાન્ત્વનયોરાકરો ય ઈશ્વરઃ સ એવં કરોતુ યત્ પ્રભુ ર્યીશુખ્રીષ્ટ ઇવ યુષ્માકમ્ એકજનોઽન્યજનેન સાર્દ્ધં મનસ ઐક્યમ્ આચરેત્; ");
INSERT INTO sanguj_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","યૂયઞ્ચ સર્વ્વ એકચિત્તા ભૂત્વા મુખૈકેનેવાસ્મત્પ્રભુયીશુખ્રીષ્ટસ્ય પિતુરીશ્વરસ્ય ગુણાન્ કીર્ત્તયેત| ");
INSERT INTO sanguj_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","અપરમ્ ઈશ્વરસ્ય મહિમ્નઃ પ્રકાશાર્થં ખ્રીષ્ટો યથા યુષ્માન્ પ્રત્યગૃહ્લાત્ તથા યુષ્માકમપ્યેકો જનોઽન્યજનં પ્રતિગૃહ્લાતુ| ");
INSERT INTO sanguj_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","યથા લિખિતમ્ આસ્તે, અતોઽહં સમ્મુખે તિષ્ઠન્ ભિન્નદેશનિવાસિનાં| સ્તુવંસ્ત્વાં પરિગાસ્યામિ તવ નામ્નિ પરેશ્વર|| ");
INSERT INTO sanguj_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","તસ્ય દયાલુત્વાચ્ચ ભિન્નજાતીયા યદ્ ઈશ્વરસ્ય ગુણાન્ કીર્ત્તયેયુસ્તદર્થં યીશુઃ ખ્રીષ્ટસ્ત્વક્છેદનિયમસ્ય નિઘ્નોઽભવદ્ ઇત્યહં વદામિ| યથા લિખિતમ્ આસ્તે, અતોઽહં સમ્મુખે તિષ્ઠન્ ભિન્નદેશનિવાસિનાં| સ્તુવંસ્ત્વાં પરિગાસ્યામિ તવ નામ્નિ પરેશ્વર|| ");
INSERT INTO sanguj_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","અપરમપિ લિખિતમ્ આસ્તે, હે અન્યજાતયો યૂયં સમં નન્દત તજ્જનૈઃ| ");
INSERT INTO sanguj_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","પુનશ્ચ લિખિતમ્ આસ્તે, હે સર્વ્વદેશિનો યૂયં ધન્યં બ્રૂત પરેશ્વરં| હે તદીયનરા યૂયં કુરુધ્વં તત્પ્રશંસનં|| ");
INSERT INTO sanguj_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","અપર યીશાયિયોઽપિ લિલેખ, યીશયસ્ય તુ યત્ મૂલં તત્ પ્રકાશિષ્યતે તદા| સર્વ્વજાતીયનૃણાઞ્ચ શાસકઃ સમુદેષ્યતિ| તત્રાન્યદેશિલોકૈશ્ચ પ્રત્યાશા પ્રકરિષ્યતે|| ");
INSERT INTO sanguj_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","અતએવ યૂયં પવિત્રસ્યાત્મનઃ પ્રભાવાદ્ યત્ સમ્પૂર્ણાં પ્રત્યાશાં લપ્સ્યધ્વે તદર્થં તત્પ્રત્યાશાજનક ઈશ્વરઃ પ્રત્યયેન યુષ્માન્ શાન્ત્યાનન્દાભ્યાં સમ્પૂર્ણાન્ કરોતુ| ");
INSERT INTO sanguj_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","હે ભ્રાતરો યૂયં સદ્ભાવયુક્તાઃ સર્વ્વપ્રકારેણ જ્ઞાનેન ચ સમ્પૂર્ણાઃ પરસ્પરોપદેશે ચ તત્પરા ઇત્યહં નિશ્ચિતં જાનામિ, ");
INSERT INTO sanguj_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","તથાપ્યહં યત્ પ્રગલ્ભતરો ભવન્ યુષ્માન્ પ્રબોધયામિ તસ્યૈકં કારણમિદં| ");
INSERT INTO sanguj_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","ભિન્નજાતીયાઃ પવિત્રેણાત્મના પાવિતનૈવેદ્યરૂપા ભૂત્વા યદ્ ગ્રાહ્યા ભવેયુસ્તન્નિમિત્તમહમ્ ઈશ્વરસ્ય સુસંવાદં પ્રચારયિતું ભિન્નજાતીયાનાં મધ્યે યીશુખ્રીષ્ટસ્ય સેવકત્વં દાનં ઈશ્વરાત્ લબ્ધવાનસ્મિ| ");
INSERT INTO sanguj_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","ઈશ્વરં પ્રતિ યીશુખ્રીષ્ટેન મમ શ્લાઘાકરણસ્ય કારણમ્ આસ્તે| ");
INSERT INTO sanguj_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","ભિન્નદેશિન આજ્ઞાગ્રાહિણઃ કર્ત્તું ખ્રીષ્ટો વાક્યેન ક્રિયયા ચ, આશ્ચર્ય્યલક્ષણૈશ્ચિત્રક્રિયાભિઃ પવિત્રસ્યાત્મનઃ પ્રભાવેન ચ યાનિ કર્મ્માણિ મયા સાધિતવાન્, ");
INSERT INTO sanguj_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","કેવલં તાન્યેવ વિનાન્યસ્ય કસ્યચિત્ કર્મ્મણો વર્ણનાં કર્ત્તું પ્રગલ્ભો ન ભવામિ| તસ્માત્ આ યિરૂશાલમ ઇલ્લૂરિકં યાવત્ સર્વ્વત્ર ખ્રીષ્ટસ્ય સુસંવાદં પ્રાચારયં| ");
INSERT INTO sanguj_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","અન્યેન નિચિતાયાં ભિત્તાવહં યન્ન નિચિનોમિ તન્નિમિત્તં યત્ર યત્ર સ્થાને ખ્રીષ્ટસ્ય નામ કદાપિ કેનાપિ ન જ્ઞાપિતં તત્ર તત્ર સુસંવાદં પ્રચારયિતુમ્ અહં યતે| ");
INSERT INTO sanguj_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","યાદૃશં લિખિતમ્ આસ્તે, યૈ ર્વાર્ત્તા તસ્ય ન પ્રાપ્તા દર્શનં તૈસ્તુ લપ્સ્યતે| યૈશ્ચ નૈવ શ્રુતં કિઞ્ચિત્ બોદ્ધું શક્ષ્યન્તિ તે જનાઃ|| ");
INSERT INTO sanguj_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","તસ્માદ્ યુષ્મત્સમીપગમનાદ્ અહં મુહુર્મુહુ ર્નિવારિતોઽભવં| ");
INSERT INTO sanguj_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","કિન્ત્વિદાનીમ્ અત્ર પ્રદેશેષુ મયા ન ગતં સ્થાનં કિમપિ નાવશિષ્યતે યુષ્મત્સમીપં ગન્તું બહુવત્સરાનારભ્ય મામકીનાકાઙ્ક્ષા ચ વિદ્યત ઇતિ હેતોઃ ");
INSERT INTO sanguj_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","સ્પાનિયાદેશગમનકાલેઽહં યુષ્મન્મધ્યેન ગચ્છન્ યુષ્માન્ આલોકિષ્યે, તતઃ પરં યુષ્મત્સમ્ભાષણેન તૃપ્તિં પરિલભ્ય તદ્દેશગમનાર્થં યુષ્માભિ ર્વિસર્જયિષ્યે, ઈદૃશી મદીયા પ્રત્યાશા વિદ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","કિન્તુ સામ્પ્રતં પવિત્રલોકાનાં સેવનાય યિરૂશાલમ્નગરં વ્રજામિ| ");
INSERT INTO sanguj_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","યતો યિરૂશાલમસ્થપવિત્રલોકાનાં મધ્યે યે દરિદ્રા અર્થવિશ્રાણનેન તાનુપકર્ત્તું માકિદનિયાદેશીયા આખાયાદેશીયાશ્ચ લોકા ઐચ્છન્| ");
INSERT INTO sanguj_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","એષા તેષાં સદિચ્છા યતસ્તે તેષામ્ ઋણિનઃ સન્તિ યતો હેતો ર્ભિન્નજાતીયા યેષાં પરમાર્થસ્યાંશિનો જાતા ઐહિકવિષયે તેષામુપકારસ્તૈઃ કર્ત્તવ્યઃ| ");
INSERT INTO sanguj_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","અતો મયા તત્ કર્મ્મ સાધયિત્વા તસ્મિન્ ફલે તેભ્યઃ સમર્પિતે યુષ્મન્મધ્યેન સ્પાનિયાદેશો ગમિષ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","યુષ્મત્સમીપે મમાગમનસમયે ખ્રીષ્ટસ્ય સુસંવાદસ્ય પૂર્ણવરેણ સમ્બલિતઃ સન્ અહમ્ આગમિષ્યામિ ઇતિ મયા જ્ઞાયતે| ");
INSERT INTO sanguj_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","હે ભ્રાતૃગણ પ્રભો ર્યીશુખ્રીષ્ટસ્ય નામ્ના પવિત્રસ્યાત્માનઃ પ્રેમ્ના ચ વિનયેઽહં ");
INSERT INTO sanguj_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","યિહૂદાદેશસ્થાનામ્ અવિશ્વાસિલોકાનાં કરેભ્યો યદહં રક્ષાં લભેય મદીયૈતેન સેવનકર્મ્મણા ચ યદ્ યિરૂશાલમસ્થાઃ પવિત્રલોકાસ્તુષ્યેયુઃ, ");
INSERT INTO sanguj_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","તદર્થં યૂયં મત્કૃત ઈશ્વરાય પ્રાર્થયમાણા યતધ્વં તેનાહમ્ ઈશ્વરેચ્છયા સાનન્દં યુષ્મત્સમીપં ગત્વા યુષ્માભિઃ સહિતઃ પ્રાણાન્ આપ્યાયિતું પારયિષ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","શાન્તિદાયક ઈશ્વરો યુષ્માકં સર્વ્વેષાં સઙ્ગી ભૂયાત્| ઇતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","કિંક્રીયાનગરીયધર્મ્મસમાજસ્ય પરિચારિકા યા ફૈબીનામિકાસ્માકં ધર્મ્મભગિની તસ્યાઃ કૃતેઽહં યુષ્માન્ નિવેદયામિ, ");
INSERT INTO sanguj_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","યૂયં તાં પ્રભુમાશ્રિતાં વિજ્ઞાય તસ્યા આતિથ્યં પવિત્રલોકાર્હં કુરુધ્વં, યુષ્મત્તસ્તસ્યા ય ઉપકારો ભવિતું શક્નોતિ તં કુરુધ્વં, યસ્માત્ તયા બહૂનાં મમ ચોપકારઃ કૃતઃ| ");
INSERT INTO sanguj_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","અપરઞ્ચ ખ્રીષ્ટસ્ય યીશોઃ કર્મ્મણિ મમ સહકારિણૌ મમ પ્રાણરક્ષાર્થઞ્ચ સ્વપ્રાણાન્ પણીકૃતવન્તૌ યૌ પ્રિષ્કિલ્લાક્કિલૌ તૌ મમ નમસ્કારં જ્ઞાપયધ્વં| ");
INSERT INTO sanguj_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","તાભ્યામ્ ઉપકારાપ્તિઃ કેવલં મયા સ્વીકર્ત્તવ્યેતિ નહિ ભિન્નદેશીયૈઃ સર્વ્વધર્મ્મસમાજૈરપિ| ");
INSERT INTO sanguj_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","અપરઞ્ચ તયો ર્ગૃહે સ્થિતાન્ ધર્મ્મસમાજલોકાન્ મમ નમસ્કારં જ્ઞાપયધ્વં| તદ્વત્ આશિયાદેશે ખ્રીષ્ટસ્ય પક્ષે પ્રથમજાતફલસ્વરૂપો ય ઇપેનિતનામા મમ પ્રિયબન્ધુસ્તમપિ મમ નમસ્કારં જ્ઞાપયધ્વં| ");
INSERT INTO sanguj_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","અપરં બહુશ્રમેણાસ્માન્ અસેવત યા મરિયમ્ તામપિ નમસ્કારં જ્ઞાપયધ્વં| ");
INSERT INTO sanguj_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","અપરઞ્ચ પ્રેરિતેષુ ખ્યાતકીર્ત્તી મદગ્રે ખ્રીષ્ટાશ્રિતૌ મમ સ્વજાતીયૌ સહબન્દિનૌ ચ યાવાન્દ્રનીકયૂનિયૌ તૌ મમ નમસ્કારં જ્ઞાપયધ્વં| ");
INSERT INTO sanguj_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","તથા પ્રભૌ મત્પ્રિયતમમ્ આમ્પ્લિયમપિ મમ નમસ્કારં જ્ઞાપયધ્વં| ");
INSERT INTO sanguj_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","અપરં ખ્રીષ્ટસેવાયાં મમ સહકારિણમ્ ઊર્બ્બાણં મમ પ્રિયતમં સ્તાખુઞ્ચ મમ નમસ્કારં જ્ઞાપયધ્વં| ");
INSERT INTO sanguj_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","અપરં ખ્રીષ્ટેન પરીક્ષિતમ્ આપિલ્લિં મમ નમસ્કારં વદત, આરિષ્ટબૂલસ્ય પરિજનાંશ્ચ મમ નમસ્કારં જ્ઞાપયધ્વં| ");
INSERT INTO sanguj_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","અપરં મમ જ્ઞાતિં હેરોદિયોનં મમ નમસ્કારં વદત, તથા નાર્કિસસ્ય પરિવારાણાં મધ્યે યે પ્રભુમાશ્રિતાસ્તાન્ મમ નમસ્કારં વદત| ");
INSERT INTO sanguj_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","અપરં પ્રભોઃ સેવાયાં પરિશ્રમકારિણ્યૌ ત્રુફેનાત્રુફોષે મમ નમસ્કારં વદત, તથા પ્રભોઃ સેવાયામ્ અત્યન્તં પરિશ્રમકારિણી યા પ્રિયા પર્ષિસ્તાં નમસ્કારં જ્ઞાપયધ્વં| ");
INSERT INTO sanguj_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","અપરં પ્રભોરભિરુચિતં રૂફં મમ ધર્મ્મમાતા યા તસ્ય માતા તામપિ નમસ્કારં વદત| ");
INSERT INTO sanguj_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","અપરમ્ અસુંકૃતં ફ્લિગોનં હર્મ્મં પાત્રબં હર્મ્મિમ્ એતેષાં સઙ્ગિભ્રાતૃગણઞ્ચ નમસ્કારં જ્ઞાપયધ્વં| ");
INSERT INTO sanguj_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","અપરં ફિલલગો યૂલિયા નીરિયસ્તસ્ય ભગિન્યલુમ્પા ચૈતાન્ એતૈઃ સાર્દ્ધં યાવન્તઃ પવિત્રલોકા આસતે તાનપિ નમસ્કારં જ્ઞાપયધ્વં| ");
INSERT INTO sanguj_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","યૂયં પરસ્પરં પવિત્રચુમ્બનેન નમસ્કુરુધ્વં| ખ્રીષ્ટસ્ય ધર્મ્મસમાજગણો યુષ્માન્ નમસ્કુરુતે| ");
INSERT INTO sanguj_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","હે ભ્રાતરો યુષ્માન્ વિનયેઽહં યુષ્માભિ ર્યા શિક્ષા લબ્ધા તામ્ અતિક્રમ્ય યે વિચ્છેદાન્ વિઘ્નાંશ્ચ કુર્વ્વન્તિ તાન્ નિશ્ચિનુત તેષાં સઙ્ગં વર્જયત ચ| ");
INSERT INTO sanguj_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","યતસ્તાદૃશા લોકા અસ્માકં પ્રભો ર્યીશુખ્રીષ્ટસ્ય દાસા ઇતિ નહિ કિન્તુ સ્વોદરસ્યૈવ દાસાઃ; અપરં પ્રણયવચનૈ ર્મધુરવાક્યૈશ્ચ સરલલોકાનાં મનાંસિ મોહયન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","યુષ્માકમ્ આજ્ઞાગ્રાહિત્વં સર્વ્વત્ર સર્વ્વૈ ર્જ્ઞાતં તતોઽહં યુષ્માસુ સાનન્દોઽભવં તથાપિ યૂયં યત્ સત્જ્ઞાનેન જ્ઞાનિનઃ કુજ્ઞાનેे ચાતત્પરા ભવેતેતિ મમાભિલાષઃ| ");
INSERT INTO sanguj_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","અધિકન્તુ શાન્તિદાયક ઈશ્વરઃ શૈતાનમ્ અવિલમ્બં યુષ્માકં પદાનામ્ અધો મર્દ્દિષ્યતિ| અસ્માકં પ્રભુ ર્યીશુખ્રીષ્ટો યુષ્માસુ પ્રસાદં ક્રિયાત્| ઇતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","મમ સહકારી તીમથિયો મમ જ્ઞાતયો લૂકિયો યાસોન્ સોસિપાત્રશ્ચેમે યુષ્માન્ નમસ્કુર્વ્વન્તે| ");
INSERT INTO sanguj_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","અપરમ્ એતત્પત્રલેખકસ્તર્ત્તિયનામાહમપિ પ્રભો ર્નામ્ના યુષ્માન્ નમસ્કરોમિ| ");
INSERT INTO sanguj_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","તથા કૃત્સ્નધર્મ્મસમાજસ્ય મમ ચાતિથ્યકારી ગાયો યુષ્માન્ નમસ્કરોતિ| અપરમ્ એતન્નગરસ્ય ધનરક્ષક ઇરાસ્તઃ ક્કાર્ત્તનામકશ્ચૈકો ભ્રાતા તાવપિ યુષ્માન્ નમસ્કુરુતઃ| ");
INSERT INTO sanguj_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","અસ્માકં પ્રભુ ર્યીશુખ્રીષ્ટા યુષ્માસુ સર્વ્વેષુ પ્રસાદં ક્રિયાત્| ઇતિ| ");
INSERT INTO sanguj_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","પૂર્વ્વકાલિકયુગેષુ પ્રચ્છન્ના યા મન્ત્રણાધુના પ્રકાશિતા ભૂત્વા ભવિષ્યદ્વાદિલિખિતગ્રન્થગણસ્ય પ્રમાણાદ્ વિશ્વાસેન ગ્રહણાર્થં સદાતનસ્યેશ્વરસ્યાજ્ઞયા સર્વ્વદેશીયલોકાન્ જ્ઞાપ્યતે, ");
INSERT INTO sanguj_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","તસ્યા મન્ત્રણાયા જ્ઞાનં લબ્ધ્વા મયા યઃ સુસંવાદો યીશુખ્રીષ્ટમધિ પ્રચાર્ય્યતે, તદનુસારાદ્ યુષ્માન્ ધર્મ્મે સુસ્થિરાન્ કર્ત્તું સમર્થો યોઽદ્વિતીયઃ ");
INSERT INTO sanguj_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","સર્વ્વજ્ઞ ઈશ્વરસ્તસ્ય ધન્યવાદો યીશુખ્રીષ્ટેન સન્તતં ભૂયાત્| ઇતિ|");
INSERT INTO sanguj_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","યાવન્તઃ પવિત્રા લોકાઃ સ્વેષામ્ અસ્માકઞ્ચ વસતિસ્થાનેષ્વસ્માકં પ્રભો ર્યીશોઃ ખ્રીષ્ટસ્ય નામ્ના પ્રાર્થયન્તે તૈઃ સહાહૂતાનાં ખ્રીષ્ટેન યીશુના પવિત્રીકૃતાનાં લોકાનાં ય ઈશ્વરીયધર્મ્મસમાજઃ કરિન્થનગરે વિદ્યતે ");
INSERT INTO sanguj_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","તં પ્રતીશ્વરસ્યેચ્છયાહૂતો યીશુખ્રીષ્ટસ્ય પ્રેરિતઃ પૌલઃ સોસ્થિનિનામા ભ્રાતા ચ પત્રં લિખતિ| ");
INSERT INTO sanguj_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","અસ્માકં પિત્રેશ્વરેણ પ્રભુના યીશુખ્રીષ્ટેન ચ પ્રસાદઃ શાન્તિશ્ચ યુષ્મભ્યં દીયતાં| ");
INSERT INTO sanguj_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","ઈશ્વરો યીશુખ્રીષ્ટેન યુષ્માન્ પ્રતિ પ્રસાદં પ્રકાશિતવાન્, તસ્માદહં યુષ્મન્નિમિત્તં સર્વ્વદા મદીયેશ્વરં ધન્યં વદામિ| ");
INSERT INTO sanguj_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","ખ્રીષ્ટસમ્બન્ધીયં સાક્ષ્યં યુષ્માકં મધ્યે યેન પ્રકારેણ સપ્રમાણમ્ અભવત્ ");
INSERT INTO sanguj_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","તેન યૂયં ખ્રીષ્ટાત્ સર્વ્વવિધવક્તૃતાજ્ઞાનાદીનિ સર્વ્વધનાનિ લબ્ધવન્તઃ| ");
INSERT INTO sanguj_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","તતોઽસ્મત્પ્રભો ર્યીશુખ્રીષ્ટસ્ય પુનરાગમનં પ્રતીક્ષમાણાનાં યુષ્માકં કસ્યાપિ વરસ્યાભાવો ન ભવતિ| ");
INSERT INTO sanguj_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","અપરમ્ અસ્માકં પ્રભો ર્યીશુખ્રીષ્ટસ્ય દિવસે યૂયં યન્નિર્દ્દોષા ભવેત તદર્થં સએવ યાવદન્તં યુષ્માન્ સુસ્થિરાન્ કરિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","ય ઈશ્વરઃ સ્વપુત્રસ્યાસ્મત્પ્રભો ર્યીશુખ્રીષ્ટસ્યાંશિનઃ કર્ત્તું યુષ્માન્ આહૂતવાન્ સ વિશ્વસનીયઃ| ");
INSERT INTO sanguj_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","હે ભ્રાતરઃ, અસ્માકં પ્રભુયીશુખ્રીષ્ટસ્ય નામ્ના યુષ્માન્ વિનયેઽહં સર્વ્વૈ ર્યુષ્માભિરેકરૂપાણિ વાક્યાનિ કથ્યન્તાં યુષ્મન્મધ્યે ભિન્નસઙ્ઘાતા ન ભવન્તુ મનોવિચારયોરૈક્યેન યુષ્માકં સિદ્ધત્વં ભવતુ| ");
INSERT INTO sanguj_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","હે મમ ભ્રાતરો યુષ્મન્મધ્યે વિવાદા જાતા ઇતિ વાર્ત્તામહં ક્લોય્યાઃ પરિજનૈ ર્જ્ઞાપિતઃ| ");
INSERT INTO sanguj_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","મમાભિપ્રેતમિદં યુષ્માકં કશ્ચિત્ કશ્ચિદ્ વદતિ પૌલસ્ય શિષ્યોઽહમ્ આપલ્લોઃ શિષ્યોઽહં કૈફાઃ શિષ્યોઽહં ખ્રીષ્ટસ્ય શિષ્યોઽહમિતિ ચ| ");
INSERT INTO sanguj_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","ખ્રીષ્ટસ્ય કિં વિભેદઃ કૃતઃ? પૌલઃ કિં યુષ્મત્કૃતે ક્રુશે હતઃ? પૌલસ્ય નામ્ના વા યૂયં કિં મજ્જિતાઃ? ");
INSERT INTO sanguj_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","ક્રિષ્પગાયૌ વિના યુષ્માકં મધ્યેઽન્યઃ કોઽપિ મયા ન મજ્જિત ઇતિ હેતોરહમ્ ઈશ્વરં ધન્યં વદામિ| ");
INSERT INTO sanguj_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","એતેન મમ નામ્ના માનવા મયા મજ્જિતા ઇતિ વક્તું કેનાપિ ન શક્યતે| ");
INSERT INTO sanguj_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","અપરં સ્તિફાનસ્ય પરિજના મયા મજ્જિતાસ્તદન્યઃ કશ્ચિદ્ યન્મયા મજ્જિતસ્તદહં ન વેદ્મિ| ");
INSERT INTO sanguj_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","ખ્રીષ્ટેનાહં મજ્જનાર્થં ન પ્રેરિતઃ કિન્તુ સુસંવાદસ્ય પ્રચારાર્થમેવ; સોઽપિ વાક્પટુતયા મયા ન પ્રચારિતવ્યઃ, યતસ્તથા પ્રચારિતે ખ્રીષ્ટસ્ય ક્રુશે મૃત્યુઃ ફલહીનો ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","યતો હેતો ર્યે વિનશ્યન્તિ તે તાં ક્રુશસ્ય વાર્ત્તાં પ્રલાપમિવ મન્યન્તે કિઞ્ચ પરિત્રાણં લભમાનેષ્વસ્માસુ સા ઈશ્વરીયશક્તિસ્વરૂપા| ");
INSERT INTO sanguj_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","તસ્માદિત્થં લિખિતમાસ્તે, જ્ઞાનવતાન્તુ યત્ જ્ઞાનં તન્મયા નાશયિષ્યતે| વિલોપયિષ્યતે તદ્વદ્ બુદ્ધિ ર્બદ્ધિમતાં મયા|| ");
INSERT INTO sanguj_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","જ્ઞાની કુત્ર? શાસ્ત્રી વા કુત્ર? ઇહલોકસ્ય વિચારતત્પરો વા કુત્ર? ઇહલોકસ્ય જ્ઞાનં કિમીશ્વરેણ મોહીકૃતં નહિ? ");
INSERT INTO sanguj_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","ઈશ્વરસ્ય જ્ઞાનાદ્ ઇહલોકસ્ય માનવાઃ સ્વજ્ઞાનેનેશ્વરસ્ય તત્ત્વબોધં ન પ્રાપ્તવન્તસ્તસ્માદ્ ઈશ્વરઃ પ્રચારરૂપિણા પ્રલાપેન વિશ્વાસિનઃ પરિત્રાતું રોચિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","યિહૂદીયલોકા લક્ષણાનિ દિદૃક્ષન્તિ ભિન્નદેશીયલોકાસ્તુ વિદ્યાં મૃગયન્તે, ");
INSERT INTO sanguj_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","વયઞ્ચ ક્રુશે હતં ખ્રીષ્ટં પ્રચારયામઃ| તસ્ય પ્રચારો યિહૂદીયૈ ર્વિઘ્ન ઇવ ભિન્નદેશીયૈશ્ચ પ્રલાપ ઇવ મન્યતે, ");
INSERT INTO sanguj_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","કિન્તુ યિહૂદીયાનાં ભિન્નદેશીયાનાઞ્ચ મધ્યે યે આહૂતાસ્તેષુ સ ખ્રીષ્ટ ઈશ્વરીયશક્તિરિવેશ્વરીયજ્ઞાનમિવ ચ પ્રકાશતે| ");
INSERT INTO sanguj_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","યત ઈશ્વરે યઃ પ્રલાપ આરોપ્યતે સ માનવાતિરિક્તં જ્ઞાનમેવ યચ્ચ દૌર્બ્બલ્યમ્ ઈશ્વર આરોપ્યતે તત્ માનવાતિરિક્તં બલમેવ| ");
INSERT INTO sanguj_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","હે ભ્રાતરઃ, આહૂતયુષ્મદ્ગણો યષ્માભિરાલોક્યતાં તન્મધ્યે સાંસારિકજ્ઞાનેન જ્ઞાનવન્તઃ પરાક્રમિણો વા કુલીના વા બહવો ન વિદ્યન્તે| ");
INSERT INTO sanguj_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","યત ઈશ્વરો જ્ઞાનવતસ્ત્રપયિતું મૂર્ખલોકાન્ રોચિતવાન્ બલાનિ ચ ત્રપયિતુમ્ ઈશ્વરો દુર્બ્બલાન્ રોચિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","તથા વર્ત્તમાનલોકાન્ સંસ્થિતિભ્રષ્ટાન્ કર્ત્તુમ્ ઈશ્વરો જગતોઽપકૃષ્ટાન્ હેયાન્ અવર્ત્તમાનાંશ્ચાભિરોચિતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","તત ઈશ્વરસ્ય સાક્ષાત્ કેનાપ્યાત્મશ્લાઘા ન કર્ત્તવ્યા| ");
INSERT INTO sanguj_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","યૂયઞ્ચ તસ્માત્ ખ્રીષ્ટે યીશૌ સંસ્થિતિં પ્રાપ્તવન્તઃ સ ઈશ્વરાદ્ યુષ્માકં જ્ઞાનં પુણ્યં પવિત્રત્વં મુક્તિશ્ચ જાતા| ");
INSERT INTO sanguj_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","અતએવ યદ્વદ્ લિખિતમાસ્તે તદ્વત્, યઃ કશ્ચિત્ શ્લાઘમાનઃ સ્યાત્ શ્લાઘતાં પ્રભુના સ હિ| ");
INSERT INTO sanguj_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","હે ભ્રાતરો યુષ્મત્સમીપે મમાગમનકાલેઽહં વક્તૃતાયા વિદ્યાયા વા નૈપુણ્યેનેશ્વરસ્ય સાક્ષ્યં પ્રચારિતવાન્ તન્નહિ; ");
INSERT INTO sanguj_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","યતો યીશુખ્રીષ્ટં તસ્ય ક્રુશે હતત્વઞ્ચ વિના નાન્યત્ કિમપિ યુષ્મન્મધ્યે જ્ઞાપયિતું વિહિતં બુદ્ધવાન્| ");
INSERT INTO sanguj_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","અપરઞ્ચાતીવ દૌર્બ્બલ્યભીતિકમ્પયુક્તો યુષ્માભિઃ સાર્દ્ધમાસં| ");
INSERT INTO sanguj_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","અપરં યુષ્માકં વિશ્વાસો યત્ માનુષિકજ્ઞાનસ્ય ફલં ન ભવેત્ કિન્ત્વીશ્વરીયશક્તેઃ ફલં ભવેત્, ");
INSERT INTO sanguj_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","તદર્થં મમ વક્તૃતા મદીયપ્રચારશ્ચ માનુષિકજ્ઞાનસ્ય મધુરવાક્યસમ્બલિતૌ નાસ્તાં કિન્ત્વાત્મનઃ શક્તેશ્ચ પ્રમાણયુક્તાવાસ્તાં| ");
INSERT INTO sanguj_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","વયં જ્ઞાનં ભાષામહે તચ્ચ સિદ્ધલોકૈ ર્જ્ઞાનમિવ મન્યતે, તદિહલોકસ્ય જ્ઞાનં નહિ, ઇહલોકસ્ય નશ્વરાણામ્ અધિપતીનાં વા જ્ઞાનં નહિ; ");
INSERT INTO sanguj_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","કિન્તુ કાલાવસ્થાયાઃ પૂર્વ્વસ્માદ્ યત્ જ્ઞાનમ્ અસ્માકં વિભવાર્થમ્ ઈશ્વરેણ નિશ્ચિત્ય પ્રચ્છન્નં તન્નિગૂઢમ્ ઈશ્વરીયજ્ઞાનં પ્રભાષામહે| ");
INSERT INTO sanguj_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","ઇહલોકસ્યાધિપતીનાં કેનાપિ તત્ જ્ઞાનં ન લબ્ધં, લબ્ધે સતિ તે પ્રભાવવિશિષ્ટં પ્રભું ક્રુશે નાહનિષ્યન્| ");
INSERT INTO sanguj_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","તદ્વલ્લિખિતમાસ્તે, નેત્રેણ ક્કાપિ નો દૃષ્ટં કર્ણેનાપિ ચ ન શ્રુતં| મનોમધ્યે તુ કસ્યાપિ ન પ્રવિષ્ટં કદાપિ યત્| ઈશ્વરે પ્રીયમાણાનાં કૃતે તત્ તેન સઞ્ચિતં| ");
INSERT INTO sanguj_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","અપરમીશ્વરઃ સ્વાત્મના તદસ્માકં સાક્ષાત્ પ્રાકાશયત્; યત આત્મા સર્વ્વમેવાનુસન્ધત્તે તેન ચેશ્વરસ્ય મર્મ્મતત્ત્વમપિ બુધ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","મનુજસ્યાન્તઃસ્થમાત્માનં વિના કેન મનુજેન તસ્ય મનુજસ્ય તત્ત્વં બુધ્યતે? તદ્વદીશ્વરસ્યાત્માનં વિના કેનાપીશ્વરસ્ય તત્ત્વં ન બુધ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","વયઞ્ચેહલોકસ્યાત્માનં લબ્ધવન્તસ્તન્નહિ કિન્ત્વીશ્વરસ્યૈવાત્માનં લબ્ધવન્તઃ, તતો હેતોરીશ્વરેણ સ્વપ્રસાદાદ્ અસ્મભ્યં યદ્ યદ્ દત્તં તત્સર્વ્વમ્ અસ્માભિ ર્જ્ઞાતું શક્યતે| ");
INSERT INTO sanguj_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","તચ્ચાસ્માભિ ર્માનુષિકજ્ઞાનસ્ય વાક્યાનિ શિક્ષિત્વા કથ્યત ઇતિ નહિ કિન્ત્વાત્મતો વાક્યાનિ શિક્ષિત્વાત્મિકૈ ર્વાક્યૈરાત્મિકં ભાવં પ્રકાશયદ્ભિઃ કથ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","પ્રાણી મનુષ્ય ઈશ્વરીયાત્મનઃ શિક્ષાં ન ગૃહ્લાતિ યત આત્મિકવિચારેણ સા વિચાર્ય્યેતિ હેતોઃ સ તાં પ્રલાપમિવ મન્યતે બોદ્ધુઞ્ચ ન શક્નોતિ| ");
INSERT INTO sanguj_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","આત્મિકો માનવઃ સર્વ્વાણિ વિચારયતિ કિન્તુ સ્વયં કેનાપિ ન વિચાર્ય્યતે| ");
INSERT INTO sanguj_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","યત ઈશ્વરસ્ય મનો જ્ઞાત્વા તમુપદેષ્ટું કઃ શક્નોતિ? કિન્તુ ખ્રીષ્ટસ્ય મનોઽસ્માભિ ર્લબ્ધં| ");
INSERT INTO sanguj_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","હે ભ્રાતરઃ, અહમાત્મિકૈરિવ યુષ્માભિઃ સમં સમ્ભાષિતું નાશક્નવં કિન્તુ શારીરિકાચારિભિઃ ખ્રીષ્ટધર્મ્મે શિશુતુલ્યૈશ્ચ જનૈરિવ યુષ્માભિઃ સહ સમભાષે| ");
INSERT INTO sanguj_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","યુષ્માન્ કઠિનભક્ષ્યં ન ભોજયન્ દુગ્ધમ્ અપાયયં યતો યૂયં ભક્ષ્યં ગ્રહીતું તદા નાશક્નુત ઇદાનીમપિ ન શક્નુથ, યતો હેતોરધુનાપિ શારીરિકાચારિણ આધ્વે| ");
INSERT INTO sanguj_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","યુષ્મન્મધ્યે માત્સર્ય્યવિવાદભેદા ભવન્તિ તતઃ કિં શારીરિકાચારિણો નાધ્વે માનુષિકમાર્ગેણ ચ ન ચરથ? ");
INSERT INTO sanguj_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","પૌલસ્યાહમિત્યાપલ્લોરહમિતિ વા યદ્વાક્યં યુષ્માકં કૈશ્ચિત્ કૈશ્ચિત્ કથ્યતે તસ્માદ્ યૂયં શારીરિકાચારિણ ન ભવથ? ");
INSERT INTO sanguj_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","પૌલઃ કઃ? આપલ્લો ર્વા કઃ? તૌ પરિચારકમાત્રૌ તયોરેકૈકસ્મૈ ચ પ્રભુ ર્યાદૃક્ ફલમદદાત્ તદ્વત્ તયોર્દ્વારા યૂયં વિશ્વાસિનો જાતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","અહં રોપિતવાન્ આપલ્લોશ્ચ નિષિક્તવાન્ ઈશ્વરશ્ચાવર્દ્ધયત્| ");
INSERT INTO sanguj_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","અતો રોપયિતૃસેક્તારાવસારૌ વર્દ્ધયિતેશ્વર એવ સારઃ| ");
INSERT INTO sanguj_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","રોપયિતૃસેક્તારૌ ચ સમૌ તયોરેકૈકશ્ચ સ્વશ્રમયોગ્યં સ્વવેતનં લપ્સ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","આવામીશ્વરેણ સહ કર્મ્મકારિણૌ, ઈશ્વરસ્ય યત્ ક્ષેત્રમ્ ઈશ્વરસ્ય યા નિર્મ્મિતિઃ સા યૂયમેવ| ");
INSERT INTO sanguj_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","ઈશ્વરસ્ય પ્રસાદાત્ મયા યત્ પદં લબ્ધં તસ્માત્ જ્ઞાનિના ગૃહકારિણેવ મયા ભિત્તિમૂલં સ્થાપિતં તદુપરિ ચાન્યેન નિચીયતે| કિન્તુ યેન યન્નિચીયતે તત્ તેન વિવિચ્યતાં| ");
INSERT INTO sanguj_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","યતો યીશુખ્રીષ્ટરૂપં યદ્ ભિત્તિમૂલં સ્થાપિતં તદન્યત્ કિમપિ ભિત્તિમૂલં સ્થાપયિતું કેનાપિ ન શક્યતે| ");
INSERT INTO sanguj_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","એતદ્ભિત્તિમૂલસ્યોપરિ યદિ કેચિત્ સ્વર્ણરૂપ્યમણિકાષ્ઠતૃણનલાન્ નિચિન્વન્તિ, ");
INSERT INTO sanguj_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","તર્હ્યેકૈકસ્ય કર્મ્મ પ્રકાશિષ્યતે યતઃ સ દિવસસ્તત્ પ્રકાશયિષ્યતિ| યતો હતોસ્તન દિવસેન વહ્નિમયેનોદેતવ્યં તત એકૈકસ્ય કર્મ્મ કીદૃશમેતસ્ય પરીક્ષા બહ્નિના ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","યસ્ય નિચયનરૂપં કર્મ્મ સ્થાસ્નુ ભવિષ્યતિ સ વેતનં લપ્સ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","યસ્ય ચ કર્મ્મ ધક્ષ્યતે તસ્ય ક્ષતિ ર્ભવિષ્યતિ કિન્તુ વહ્ને ર્નિર્ગતજન ઇવ સ સ્વયં પરિત્રાણં પ્રાપ્સ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","યૂયમ્ ઈશ્વરસ્ય મન્દિરં યુષ્મન્મધ્યે ચેશ્વરસ્યાત્મા નિવસતીતિ કિં ન જાનીથ? ");
INSERT INTO sanguj_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","ઈશ્વરસ્ય મન્દિરં યેન વિનાશ્યતે સોઽપીશ્વરેણ વિનાશયિષ્યતે યત ઈશ્વરસ્ય મન્દિરં પવિત્રમેવ યૂયં તુ તન્મન્દિરમ્ આધ્વે| ");
INSERT INTO sanguj_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","કોપિ સ્વં ન વઞ્ચયતાં| યુષ્માકં કશ્ચન ચેદિહલોકસ્ય જ્ઞાનેન જ્ઞાનવાનહમિતિ બુધ્યતે તર્હિ સ યત્ જ્ઞાની ભવેત્ તદર્થં મૂઢો ભવતુ| ");
INSERT INTO sanguj_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","યસ્માદિહલોકસ્ય જ્ઞાનમ્ ઈશ્વરસ્ય સાક્ષાત્ મૂઢત્વમેવ| એતસ્મિન્ લિખિતમપ્યાસ્તે, તીક્ષ્ણા યા જ્ઞાનિનાં બુદ્ધિસ્તયા તાન્ ધરતીશ્વરઃ| ");
INSERT INTO sanguj_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","પુનશ્ચ| જ્ઞાનિનાં કલ્પના વેત્તિ પરમેશો નિરર્થકાઃ| ");
INSERT INTO sanguj_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","અતએવ કોઽપિ મનુજૈરાત્માનં ન શ્લાઘતાં યતઃ સર્વ્વાણિ યુષ્માકમેવ, ");
INSERT INTO sanguj_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","પૌલ વા આપલ્લો ર્વા કૈફા વા જગદ્ વા જીવનં વા મરણં વા વર્ત્તમાનં વા ભવિષ્યદ્વા સર્વ્વાણ્યેવ યુષ્માકં, ");
INSERT INTO sanguj_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","યૂયઞ્ચ ખ્રીષ્ટસ્ય, ખ્રીષ્ટશ્ચેશ્વરસ્ય| ");
INSERT INTO sanguj_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","લોકા અસ્માન્ ખ્રીષ્ટસ્ય પરિચારકાન્ ઈશ્વરસ્ય નિગૂઠવાક્યધનસ્યાધ્યક્ષાંશ્ચ મન્યન્તાં| ");
INSERT INTO sanguj_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","કિઞ્ચ ધનાધ્યક્ષેણ વિશ્વસનીયેન ભવિતવ્યમેતદેવ લોકૈ ર્યાચ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","અતો વિચારયદ્ભિ ર્યુષ્માભિરન્યૈઃ કૈશ્ચિન્ મનુજૈ ર્વા મમ પરીક્ષણં મયાતીવ લઘુ મન્યતે ઽહમપ્યાત્માનં ન વિચારયામિ| ");
INSERT INTO sanguj_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","મયા કિમપ્યપરાદ્ધમિત્યહં ન વેદ્મિ કિન્ત્વેતેન મમ નિરપરાધત્વં ન નિશ્ચીયતે પ્રભુરેવ મમ વિચારયિતાસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","અત ઉપયુક્તસમયાત્ પૂર્વ્વમ્ અર્થતઃ પ્રભોરાગમનાત્ પૂર્વ્વં યુષ્માભિ ર્વિચારો ન ક્રિયતાં| પ્રભુરાગત્ય તિમિરેણ પ્રચ્છન્નાનિ સર્વ્વાણિ દીપયિષ્યતિ મનસાં મન્ત્રણાશ્ચ પ્રકાશયિષ્યતિ તસ્મિન્ સમય ઈશ્વરાદ્ એકૈકસ્ય પ્રશંસા ભવિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","હે ભ્રાતરઃ સર્વ્વાણ્યેતાનિ મયાત્માનમ્ આપલ્લવઞ્ચોદ્દિશ્ય કથિતાનિ તસ્યૈતત્ કારણં યુયં યથા શાસ્ત્રીયવિધિમતિક્રમ્ય માનવમ્ અતીવ નાદરિષ્યધ્બ ઈત્થઞ્ચૈકેન વૈપરીત્યાદ્ અપરેણ ન શ્લાઘિષ્યધ્બ એતાદૃશીં શિક્ષામાવયોર્દૃષ્ટાન્તાત્ લપ્સ્યધ્વે| ");
INSERT INTO sanguj_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","અપરાત્ કસ્ત્વાં વિશેષયતિ? તુભ્યં યન્ન દત્ત તાદૃશં કિં ધારયસિ? અદત્તેનેવ દત્તેન વસ્તુના કુતઃ શ્લાઘસે? ");
INSERT INTO sanguj_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","ઇદાનીમેવ યૂયં કિં તૃપ્તા લબ્ધધના વા? અસ્માસ્વવિદ્યમાનેષુ યૂયં કિં રાજત્વપદં પ્રાપ્તાઃ? યુષ્માકં રાજત્વં મયાભિલષિતં યતસ્તેન યુષ્માભિઃ સહ વયમપિ રાજ્યાંશિનો ભવિષ્યામઃ| ");
INSERT INTO sanguj_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","પ્રેરિતા વયં શેષા હન્તવ્યાશ્ચેવેશ્વરેણ નિદર્શિતાઃ| યતો વયં સર્વ્વલોકાનામ્ અર્થતઃ સ્વર્ગીયદૂતાનાં માનવાનાઞ્ચ કૌતુકાસ્પદાનિ જાતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","ખ્રીષ્ટસ્ય કૃતે વયં મૂઢાઃ કિન્તુ યૂયં ખ્રીષ્ટેન જ્ઞાનિનઃ, વયં દુર્બ્બલા યૂયઞ્ચ સબલાઃ, યૂયં સમ્માનિતા વયઞ્ચાપમાનિતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","વયમદ્યાપિ ક્ષુધાર્ત્તાસ્તૃષ્ણાર્ત્તા વસ્ત્રહીનાસ્તાડિતા આશ્રમરહિતાશ્ચ સન્તઃ ");
INSERT INTO sanguj_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","કર્મ્મણિ સ્વકરાન્ વ્યાપારયન્તશ્ચ દુઃખૈઃ કાલં યાપયામઃ| ગર્હિતૈરસ્માભિરાશીઃ કથ્યતે દૂરીકૃતૈઃ સહ્યતે નિન્દિતૈઃ પ્રસાદ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","વયમદ્યાપિ જગતઃ સમ્માર્જનીયોગ્યા અવકરા ઇવ સર્વ્વૈ ર્મન્યામહે| ");
INSERT INTO sanguj_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","યુષ્માન્ ત્રપયિતુમહમેતાનિ લિખામીતિ નહિ કિન્તુ પ્રિયાત્મજાનિવ યુષ્માન્ પ્રબોધયામિ| ");
INSERT INTO sanguj_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","યતઃ ખ્રીષ્ટધર્મ્મે યદ્યપિ યુષ્માકં દશસહસ્રાણિ વિનેતારો ભવન્તિ તથાપિ બહવો જનકા ન ભવન્તિ યતોઽહમેવ સુસંવાદેન યીશુખ્રીષ્ટે યુષ્માન્ અજનયં| ");
INSERT INTO sanguj_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","અતો યુષ્માન્ વિનયેઽહં યૂયં મદનુગામિનો ભવત| ");
INSERT INTO sanguj_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","ઇત્યર્થં સર્વ્વેષુ ધર્મ્મસમાજેષુ સર્વ્વત્ર ખ્રીષ્ટધર્મ્મયોગ્યા યે વિધયો મયોપદિશ્યન્તે તાન્ યો યુષ્માન્ સ્મારયિષ્યત્યેવમ્ભૂતં પ્રભોઃ કૃતે પ્રિયં વિશ્વાસિનઞ્ચ મદીયતનયં તીમથિયં યુષ્માકં સમીપં પ્રેષિતવાનહં| ");
INSERT INTO sanguj_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","અપરમહં યુષ્માકં સમીપં ન ગમિષ્યામીતિ બુદ્ધ્વા યુષ્માકં કિયન્તો લોકા ગર્વ્વન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","કિન્તુ યદિ પ્રભેરિચ્છા ભવતિ તર્હ્યહમવિલમ્બં યુષ્મત્સમીપમુપસ્થાય તેષાં દર્પધ્માતાનાં લોકાનાં વાચં જ્ઞાસ્યામીતિ નહિ સામર્થ્યમેવ જ્ઞાસ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","યસ્માદીશ્વરસ્ય રાજત્વં વાગ્યુક્તં નહિ કિન્તુ સામર્થ્યયુક્તં| ");
INSERT INTO sanguj_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","યુષ્માકં કા વાઞ્છા? યુષ્મત્સમીપે મયા કિં દણ્ડપાણિના ગન્તવ્યમુત પ્રેમનમ્રતાત્મયુક્તેન વા? ");
INSERT INTO sanguj_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","અપરં યુષ્માકં મધ્યે વ્યભિચારો વિદ્યતે સ ચ વ્યભિચારસ્તાદૃશો યદ્ દેવપૂજકાનાં મધ્યેઽપિ તત્તુલ્યો ન વિદ્યતે ફલતો યુષ્માકમેકો જનો વિમાતૃગમનં કૃરુત ઇતિ વાર્ત્તા સર્વ્વત્ર વ્યાપ્તા| ");
INSERT INTO sanguj_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","તથાચ યૂયં દર્પધ્માતા આધ્બે, તત્ કર્મ્મ યેન કૃતં સ યથા યુષ્મન્મધ્યાદ્ દૂરીક્રિયતે તથા શોકો યુષ્માભિ ર્ન ક્રિયતે કિમ્ એતત્? ");
INSERT INTO sanguj_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","અવિદ્યમાને મદીયશરીરે મમાત્મા યુષ્મન્મધ્યે વિદ્યતે અતોઽહં વિદ્યમાન ઇવ તત્કર્મ્મકારિણો વિચારં નિશ્ચિતવાન્, ");
INSERT INTO sanguj_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","અસ્મત્પ્રભો ર્યીશુખ્રીષ્ટસ્ય નામ્ના યુષ્માકં મદીયાત્મનશ્ચ મિલને જાતે ઽસ્મત્પ્રભો ર્યીશુખ્રીષ્ટસ્ય શક્તેઃ સાહાય્યેન ");
INSERT INTO sanguj_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","સ નરઃ શરીરનાશાર્થમસ્માભિઃ શયતાનો હસ્તે સમર્પયિતવ્યસ્તતોઽસ્માકં પ્રભો ર્યીશો ર્દિવસે તસ્યાત્મા રક્ષાં ગન્તું શક્ષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","યુષ્માકં દર્પો ન ભદ્રાય યૂયં કિમેતન્ન જાનીથ, યથા, વિકારઃ કૃત્સ્નશક્તૂનાં સ્વલ્પકિણ્વેન જાયતે| ");
INSERT INTO sanguj_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","યૂયં યત્ નવીનશક્તુસ્વરૂપા ભવેત તદર્થં પુરાતનં કિણ્વમ્ અવમાર્જ્જત યતો યુષ્માભિઃ કિણ્વશૂન્યૈ ર્ભવિતવ્યં| અપરમ્ અસ્માકં નિસ્તારોત્સવીયમેષશાવકો યઃ ખ્રીષ્ટઃ સોઽસ્મદર્થં બલીકૃતો ઽભવત્| ");
INSERT INTO sanguj_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","અતઃ પુરાતનકિણ્વેનાર્થતો દુષ્ટતાજિઘાંસારૂપેણ કિણ્વેન તન્નહિ કિન્તુ સારલ્યસત્યત્વરૂપયા કિણ્વશૂન્યતયાસ્માભિરુત્સવઃ કર્ત્તવ્યઃ| ");
INSERT INTO sanguj_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","વ્યાભિચારિણાં સંસર્ગો યુષ્માભિ ર્વિહાતવ્ય ઇતિ મયા પત્રે લિખિતં| ");
INSERT INTO sanguj_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","કિન્ત્વૈહિકલોકાનાં મધ્યે યે વ્યભિચારિણો લોભિન ઉપદ્રાવિણો દેવપૂજકા વા તેષાં સંસર્ગઃ સર્વ્વથા વિહાતવ્ય ઇતિ નહિ, વિહાતવ્યે સતિ યુષ્માભિ ર્જગતો નિર્ગન્તવ્યમેવ| ");
INSERT INTO sanguj_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","કિન્તુ ભ્રાતૃત્વેન વિખ્યાતઃ કશ્ચિજ્જનો યદિ વ્યભિચારી લોભી દેવપૂજકો નિન્દકો મદ્યપ ઉપદ્રાવી વા ભવેત્ તર્હિ તાદૃશેન માનવેન સહ ભોજનપાનેઽપિ યુષ્માભિ ર્ન કર્ત્તવ્યે ઇત્યધુના મયા લિખિતં| ");
INSERT INTO sanguj_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","સમાજબહિઃસ્થિતાનાં લોકાનાં વિચારકરણે મમ કોઽધિકારઃ? કિન્તુ તદન્તર્ગતાનાં વિચારણં યુષ્માભિઃ કિં ન કર્ત્તવ્યં ભવેત્? ");
INSERT INTO sanguj_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","બહિઃસ્થાનાં તુ વિચાર ઈશ્વરેણ કારિષ્યતે| અતો યુષ્માભિઃ સ પાતકી સ્વમધ્યાદ્ બહિષ્ક્રિયતાં| ");
INSERT INTO sanguj_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","યુષ્માકમેકસ્ય જનસ્યાપરેણ સહ વિવાદે જાતે સ પવિત્રલોકૈ ર્વિચારમકારયન્ કિમ્ અધાર્મ્મિકલોકૈ ર્વિચારયિતું પ્રોત્સહતે? ");
INSERT INTO sanguj_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","જગતોઽપિ વિચારણં પવિત્રલોકૈઃ કારિષ્યત એતદ્ યૂયં કિં ન જાનીથ? અતો જગદ્ યદિ યુષ્માભિ ર્વિચારયિતવ્યં તર્હિ ક્ષુદ્રતમવિચારેષુ યૂયં કિમસમર્થાઃ? ");
INSERT INTO sanguj_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","દૂતા અપ્યસ્માભિ ર્વિચારયિષ્યન્ત ઇતિ કિં ન જાનીથ? અત ઐહિકવિષયાઃ કિમ્ અસ્માભિ ર્ન વિચારયિતવ્યા ભવેયુઃ? ");
INSERT INTO sanguj_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","ઐહિકવિષયસ્ય વિચારે યુષ્માભિઃ કર્ત્તવ્યે યે લોકાઃ સમિતૌ ક્ષુદ્રતમાસ્ત એવ નિયુજ્યન્તાં| ");
INSERT INTO sanguj_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","અહં યુષ્માન્ ત્રપયિતુમિચ્છન્ વદામિ યૃષ્મન્મધ્યે કિમેકોઽપિ મનુષ્યસ્તાદૃગ્ બુદ્ધિમાન્નહિ યો ભ્રાતૃવિવાદવિચારણે સમર્થઃ સ્યાત્? ");
INSERT INTO sanguj_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","કિઞ્ચૈકો ભ્રાતા ભ્રાત્રાન્યેન કિમવિશ્વાસિનાં વિચારકાણાં સાક્ષાદ્ વિવદતે? યષ્મન્મધ્યે વિવાદા વિદ્યન્ત એતદપિ યુષ્માકં દોષઃ| ");
INSERT INTO sanguj_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","યૂયં કુતોઽન્યાયસહનં ક્ષતિસહનં વા શ્રેયો ન મન્યધ્વે? ");
INSERT INTO sanguj_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","કિન્તુ યૂયમપિ ભ્રાતૃનેવ પ્રત્યન્યાયં ક્ષતિઞ્ચ કુરુથ કિમેતત્? ");
INSERT INTO sanguj_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","ઈશ્વરસ્ય રાજ્યેઽન્યાયકારિણાં લોકાનામધિકારો નાસ્ત્યેતદ્ યૂયં કિં ન જાનીથ? મા વઞ્ચ્યધ્વં, યે વ્યભિચારિણો દેવાર્ચ્ચિનઃ પારદારિકાઃ સ્ત્રીવદાચારિણઃ પુંમૈથુનકારિણસ્તસ્કરા ");
INSERT INTO sanguj_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","લોભિનો મદ્યપા નિન્દકા ઉપદ્રાવિણો વા ત ઈશ્વરસ્ય રાજ્યભાગિનો ન ભવિષ્યન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","યૂયઞ્ચૈવંવિધા લોકા આસ્ત કિન્તુ પ્રભો ર્યીશો ર્નામ્નાસ્મદીશ્વરસ્યાત્મના ચ યૂયં પ્રક્ષાલિતાઃ પાવિતાઃ સપુણ્યીકૃતાશ્ચ| ");
INSERT INTO sanguj_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","મદર્થં સર્વ્વં દ્રવ્યમ્ અપ્રતિષિદ્ધં કિન્તુ ન સર્વ્વં હિતજનકં| મદર્થં સર્વ્વમપ્રતિષિદ્ધં તથાપ્યહં કસ્યાપિ દ્રવ્યસ્ય વશીકૃતો ન ભવિષ્યામિ| ");
INSERT INTO sanguj_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","ઉદરાય ભક્ષ્યાણિ ભક્ષ્યેભ્યશ્ચોદરં, કિન્તુ ભક્ષ્યોદરે ઈશ્વરેણ નાશયિષ્યેતે; અપરં દેહો ન વ્યભિચારાય કિન્તુ પ્રભવે પ્રભુશ્ચ દેહાય| ");
INSERT INTO sanguj_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","યશ્ચેશ્વરઃ પ્રભુમુત્થાપિતવાન્ સ સ્વશક્ત્યાસ્માનપ્યુત્થાપયિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","યુષ્માકં યાનિ શરીરાણિ તાનિ ખ્રીષ્ટસ્યાઙ્ગાનીતિ કિં યૂયં ન જાનીથ? અતઃ ખ્રીષ્ટસ્ય યાન્યઙ્ગાનિ તાનિ મયાપહૃત્ય વેશ્યાયા અઙ્ગાનિ કિં કારિષ્યન્તે? તન્ન ભવતુ| ");
INSERT INTO sanguj_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","યઃ કશ્ચિદ્ વેશ્યાયામ્ આસજ્યતે સ તયા સહૈકદેહો ભવતિ કિં યૂયમેતન્ન જાનીથ? યતો લિખિતમાસ્તે, યથા, તૌ દ્વૌ જનાવેકાઙ્ગૌ ભવિષ્યતઃ| ");
INSERT INTO sanguj_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","માનવા યાન્યન્યાનિ કલુષાણિ કુર્વ્વતે તાનિ વપુ ર્ન સમાવિશન્તિ કિન્તુ વ્યભિચારિણા સ્વવિગ્રહસ્ય વિરુદ્ધં કલ્મષં ક્રિયતે| ");
INSERT INTO sanguj_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","માનવા યાન્યન્યાનિ કલુષાણિ કુર્વ્વતે તાનિ વપુ ર્ન સમાવિશન્તિ કિન્તુ વ્યભિચારિણા સ્વવિગ્રહસ્ય વિરુદ્ધં કલ્મષં ક્રિયતે| ");
INSERT INTO sanguj_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","યુષ્માકં યાનિ વપૂંસિ તાનિ યુષ્મદન્તઃસ્થિતસ્યેશ્વરાલ્લબ્ધસ્ય પવિત્રસ્યાત્મનો મન્દિરાણિ યૂયઞ્ચ સ્વેષાં સ્વામિનો નાધ્વે કિમેતદ્ યુષ્માભિ ર્ન જ્ઞાયતે? ");
INSERT INTO sanguj_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","યૂયં મૂલ્યેન ક્રીતા અતો વપુર્મનોભ્યામ્ ઈશ્વરો યુષ્માભિઃ પૂજ્યતાં યત ઈશ્વર એવ તયોઃ સ્વામી| ");
INSERT INTO sanguj_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","અપરઞ્ચ યુષ્માભિ ર્માં પ્રતિ યત્ પત્રમલેખિ તસ્યોત્તરમેતત્, યોષિતોઽસ્પર્શનં મનુજસ્ય વરં; ");
INSERT INTO sanguj_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","કિન્તુ વ્યભિચારભયાદ્ એકૈકસ્ય પુંસઃ સ્વકીયભાર્ય્યા ભવતુ તદ્વદ્ એકૈકસ્યા યોષિતો ઽપિ સ્વકીયભર્ત્તા ભવતુ| ");
INSERT INTO sanguj_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","ભાર્ય્યાયૈ ભર્ત્રા યદ્યદ્ વિતરણીયં તદ્ વિતીર્ય્યતાં તદ્વદ્ ભર્ત્રેઽપિ ભાર્ય્યયા વિતરણીયં વિતીર્ય્યતાં| ");
INSERT INTO sanguj_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","ભાર્ય્યાયાઃ સ્વદેહે સ્વત્વં નાસ્તિ ભર્ત્તુરેવ, તદ્વદ્ ભર્ત્તુરપિ સ્વદેહે સ્વત્વં નાસ્તિ ભાર્ય્યાયા એવ| ");
INSERT INTO sanguj_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","ઉપોષણપ્રાર્થનયોઃ સેવનાર્થમ્ એકમન્ત્રણાનાં યુષ્માકં કિયત્કાલં યાવદ્ યા પૃથક્સ્થિતિ ર્ભવતિ તદન્યો વિચ્છેદો યુષ્મન્મધ્યે ન ભવતુ, તતઃ પરમ્ ઇન્દ્રિયાણામ્ અધૈર્ય્યાત્ શયતાન્ યદ્ યુષ્માન્ પરીક્ષાં ન નયેત્ તદર્થં પુનરેકત્ર મિલત| ");
INSERT INTO sanguj_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","એતદ્ આદેશતો નહિ કિન્ત્વનુજ્ઞાત એવ મયા કથ્યતે, ");
INSERT INTO sanguj_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","યતો મમાવસ્થેવ સર્વ્વમાનવાનામવસ્થા ભવત્વિતિ મમ વાઞ્છા કિન્ત્વીશ્વરાદ્ એકેનૈકો વરોઽન્યેન ચાન્યો વર ઇત્થમેકૈકેન સ્વકીયવરો લબ્ધઃ| ");
INSERT INTO sanguj_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","અપરમ્ અકૃતવિવાહાન્ વિધવાશ્ચ પ્રતિ મમૈતન્નિવેદનં મમેવ તેષામવસ્થિતિ ર્ભદ્રા; ");
INSERT INTO sanguj_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","કિઞ્ચ યદિ તૈરિન્દ્રિયાણિ નિયન્તું ન શક્યન્તે તર્હિ વિવાહઃ ક્રિયતાં યતઃ કામદહનાદ્ વ્યૂઢત્વં ભદ્રં| ");
INSERT INTO sanguj_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","યે ચ કૃતવિવાહાસ્તે મયા નહિ પ્રભુનૈવૈતદ્ આજ્ઞાપ્યન્તે| ");
INSERT INTO sanguj_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","ભાર્ય્યા ભર્ત્તૃતઃ પૃથક્ ન ભવતુ| યદિ વા પૃથગ્ભૂતા સ્યાત્ તર્હિ નિર્વિવાહા તિષ્ઠતુ સ્વીયપતિના વા સન્દધાતુ ભર્ત્તાપિ ભાર્ય્યાં ન ત્યજતુ| ");
INSERT INTO sanguj_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","ઇતરાન્ જનાન્ પ્રતિ પ્રભુ ર્ન બ્રવીતિ કિન્ત્વહં બ્રવીમિ; કસ્યચિદ્ ભ્રાતુર્યોષિદ્ અવિશ્વાસિની સત્યપિ યદિ તેન સહવાસે તુષ્યતિ તર્હિ સા તેન ન ત્યજ્યતાં| ");
INSERT INTO sanguj_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","તદ્વત્ કસ્યાશ્ચિદ્ યોષિતઃ પતિરવિશ્વાસી સન્નપિ યદિ તયા સહવાસે તુષ્યતિ તર્હિ સ તયા ન ત્યજ્યતાં| ");
INSERT INTO sanguj_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","યતોઽવિશ્વાસી ભર્ત્તા ભાર્ય્યયા પવિત્રીભૂતઃ, તદ્વદવિશ્વાસિની ભાર્ય્યા ભર્ત્રા પવિત્રીભૂતા; નોચેદ્ યુષ્માકમપત્યાન્યશુચીન્યભવિષ્યન્ કિન્ત્વધુના તાનિ પવિત્રાણિ સન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","અવિશ્વાસી જનો યદિ વા પૃથગ્ ભવતિ તર્હિ પૃથગ્ ભવતુ; એતેન ભ્રાતા ભગિની વા ન નિબધ્યતે તથાપિ વયમીશ્વરેણ શાન્તયે સમાહૂતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","હે નારિ તવ ભર્ત્તુઃ પરિત્રાણં ત્વત્તો ભવિષ્યતિ ન વેતિ ત્વયા કિં જ્ઞાયતે? હે નર તવ જાયાયાઃ પરિત્રાણં ત્વત્તેा ભવિષ્યતિ ન વેતિ ત્વયા કિં જ્ઞાયતે? ");
INSERT INTO sanguj_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","એકૈકો જનઃ પરમેશ્વરાલ્લબ્ધં યદ્ ભજતે યસ્યાઞ્ચાવસ્થાયામ્ ઈશ્વરેણાહ્વાયિ તદનુસારેણૈવાચરતુ તદહં સર્વ્વસમાજસ્થાન્ આદિશામિ| ");
INSERT INTO sanguj_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","છિન્નત્વગ્ ભૃત્વા ય આહૂતઃ સ પ્રકૃષ્ટત્વક્ ન ભવતુ, તદ્વદ્ અછિન્નત્વગ્ ભૂત્વા ય આહૂતઃ સ છિન્નત્વક્ ન ભવતુ| ");
INSERT INTO sanguj_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","ત્વક્છેદઃ સારો નહિ તદ્વદત્વક્છેદોઽપિ સારો નહિ કિન્ત્વીશ્વરસ્યાજ્ઞાનાં પાલનમેવ| ");
INSERT INTO sanguj_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","યો જનો યસ્યામવસ્થાયામાહ્વાયિ સ તસ્યામેવાવતિષ્ઠતાં| ");
INSERT INTO sanguj_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","દાસઃ સન્ ત્વં કિમાહૂતોઽસિ? તન્મા ચિન્તય, તથાચ યદિ સ્વતન્ત્રો ભવિતું શક્નુયાસ્તર્હિ તદેવ વૃણુ| ");
INSERT INTO sanguj_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","યતઃ પ્રભુનાહૂતો યો દાસઃ સ પ્રભો ર્મોચિતજનઃ| તદ્વદ્ તેનાહૂતઃ સ્વતન્ત્રો જનોઽપિ ખ્રીષ્ટસ્ય દાસ એવ| ");
INSERT INTO sanguj_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","યૂયં મૂલ્યેન ક્રીતા અતો હેતો ર્માનવાનાં દાસા મા ભવત| ");
INSERT INTO sanguj_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","હે ભ્રાતરો યસ્યામવસ્થાયાં યસ્યાહ્વાનમભવત્ તયા સ ઈશ્વરસ્ય સાક્ષાત્ તિષ્ઠતુ| ");
INSERT INTO sanguj_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","અપરમ્ અકૃતવિવાહાન્ જનાન્ પ્રતિ પ્રભોઃ કોઽપ્યાદેશો મયા ન લબ્ધઃ કિન્તુ પ્રભોરનુકમ્પયા વિશ્વાસ્યો ભૂતોઽહં યદ્ ભદ્રં મન્યે તદ્ વદામિ| ");
INSERT INTO sanguj_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","વર્ત્તમાનાત્ ક્લેશસમયાત્ મનુષ્યસ્યાનૂઢત્વં ભદ્રમિતિ મયા બુધ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","ત્વં કિં યોષિતિ નિબદ્ધોઽસિ તર્હિ મોચનં પ્રાપ્તું મા યતસ્વ| કિં વા યોષિતો મુક્તોઽસિ? તર્હિ જાયાં મા ગવેષય| ");
INSERT INTO sanguj_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","વિવાહં કુર્વ્વતા ત્વયા કિમપિ નાપારાધ્યતે તદ્વદ્ વ્યૂહ્યમાનયા યુવત્યાપિ કિમપિ નાપરાધ્યતે તથાચ તાદૃશૌ દ્વૌ જનૌ શારીરિકં ક્લેશં લપ્સ્યેતે કિન્તુ યુષ્માન્ પ્રતિ મમ કરુણા વિદ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","હે ભ્રાતરોઽહમિદં બ્રવીમિ, ઇતઃ પરં સમયોઽતીવ સંક્ષિપ્તઃ, ");
INSERT INTO sanguj_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","અતઃ કૃતદારૈરકૃતદારૈરિવ રુદદ્ભિશ્ચારુદદ્ભિરિવ સાનન્દૈશ્ચ નિરાનન્દૈરિવ ક્રેતૃભિશ્ચાભાગિભિરિવાચરિતવ્યં ");
INSERT INTO sanguj_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","યે ચ સંસારે ચરન્તિ તૈ ર્નાતિચરિતવ્યં યત ઇહલેाકસ્ય કૌતુકો વિચલતિ| ");
INSERT INTO sanguj_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","કિન્તુ યૂયં યન્નિશ્ચિન્તા ભવેતેતિ મમ વાઞ્છા| અકૃતવિવાહો જનો યથા પ્રભું પરિતોષયેત્ તથા પ્રભું ચિન્તયતિ, ");
INSERT INTO sanguj_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","કિન્તુ કૃતવિવાહો જનો યથા ભાર્ય્યાં પરિતોષયેત્ તથા સંસારં ચિન્તયતિ| ");
INSERT INTO sanguj_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","તદ્વદ્ ઊઢયોષિતો ઽનૂઢા વિશિષ્યતે| યાનૂઢા સા યથા કાયમનસોઃ પવિત્રા ભવેત્ તથા પ્રભું ચિન્તયતિ યા ચોઢા સા યથા ભર્ત્તારં પરિતોષયેત્ તથા સંસારં ચિન્તયતિ| ");
INSERT INTO sanguj_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","અહં યદ્ યુષ્માન્ મૃગબન્ધિન્યા પરિક્ષિપેયં તદર્થં નહિ કિન્તુ યૂયં યદનિન્દિતા ભૂત્વા પ્રભોઃ સેવનેઽબાધમ્ આસક્તા ભવેત તદર્થમેતાનિ સર્વ્વાણિ યુષ્માકં હિતાય મયા કથ્યન્તે| ");
INSERT INTO sanguj_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","કસ્યચિત્ કન્યાયાં યૌવનપ્રાપ્તાયાં યદિ સ તસ્યા અનૂઢત્વં નિન્દનીયં વિવાહશ્ચ સાધયિતવ્ય ઇતિ મન્યતે તર્હિ યથાભિલાષં કરોતુ, એતેન કિમપિ નાપરાત્સ્યતિ વિવાહઃ ક્રિયતાં| ");
INSERT INTO sanguj_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","કિન્તુ દુઃખેનાક્લિષ્ટઃ કશ્ચિત્ પિતા યદિ સ્થિરમનોગતઃ સ્વમનોઽભિલાષસાધને સમર્થશ્ચ સ્યાત્ મમ કન્યા મયા રક્ષિતવ્યેતિ મનસિ નિશ્ચિનોતિ ચ તર્હિ સ ભદ્રં કર્મ્મ કરોતિ| ");
INSERT INTO sanguj_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","અતો યો વિવાહં કરોતિ સ ભદ્રં કર્મ્મ કરોતિ યશ્ચ વિવાહં ન કરોતિ સ ભદ્રતરં કર્મ્મ કરોતિ| ");
INSERT INTO sanguj_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","યાવત્કાલં પતિ ર્જીવતિ તાવદ્ ભાર્ય્યા વ્યવસ્થયા નિબદ્ધા તિષ્ઠતિ કિન્તુ પત્યૌ મહાનિદ્રાં ગતે સા મુક્તીભૂય યમભિલષતિ તેન સહ તસ્યા વિવાહો ભવિતું શક્નોતિ, કિન્ત્વેતત્ કેવલં પ્રભુભક્તાનાં મધ્યે| ");
INSERT INTO sanguj_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","તથાચ સા યદિ નિષ્પતિકા તિષ્ઠતિ તર્હિ તસ્યાઃ ક્ષેમં ભવિષ્યતીતિ મમ ભાવઃ| અપરમ્ ઈશ્વરસ્યાત્મા મમાપ્યન્ત ર્વિદ્યત ઇતિ મયા બુધ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","દેવપ્રસાદે સર્વ્વેષામ્ અસ્માકં જ્ઞાનમાસ્તે તદ્વયં વિદ્મઃ| તથાપિ જ્ઞાનં ગર્વ્વં જનયતિ કિન્તુ પ્રેમતો નિષ્ઠા જાયતે| ");
INSERT INTO sanguj_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","અતઃ કશ્ચન યદિ મન્યતે મમ જ્ઞાનમાસ્ત ઇતિ તર્હિ તેન યાદૃશં જ્ઞાનં ચેષ્ટિતવ્યં તાદૃશં કિમપિ જ્ઞાનમદ્યાપિ ન લબ્ધં| ");
INSERT INTO sanguj_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","કિન્તુ ય ઈશ્વરે પ્રીયતે સ ઈશ્વરેણાપિ જ્ઞાયતે| ");
INSERT INTO sanguj_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","દેવતાબલિપ્રસાદભક્ષણે વયમિદં વિદ્મો યત્ જગન્મધ્યે કોઽપિ દેવો ન વિદ્યતે, એકશ્ચેશ્વરો દ્વિતીયો નાસ્તીતિ| ");
INSERT INTO sanguj_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","સ્વર્ગે પૃથિવ્યાં વા યદ્યપિ કેષુચિદ્ ઈશ્વર ઇતિ નામારોપ્યતે તાદૃશાશ્ચ બહવ ઈશ્વરા બહવશ્ચ પ્રભવો વિદ્યન્તે ");
INSERT INTO sanguj_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","તથાપ્યસ્માકમદ્વિતીય ઈશ્વરઃ સ પિતા યસ્માત્ સર્વ્વેષાં યદર્થઞ્ચાસ્માકં સૃષ્ટિ ર્જાતા, અસ્માકઞ્ચાદ્વિતીયઃ પ્રભુઃ સ યીશુઃ ખ્રીષ્ટો યેન સર્વ્વવસ્તૂનાં યેનાસ્માકમપિ સૃષ્ટિઃ કૃતા| ");
INSERT INTO sanguj_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","અધિકન્તુ જ્ઞાનં સર્વ્વેષાં નાસ્તિ યતઃ કેચિદદ્યાપિ દેવતાં સમ્મન્ય દેવપ્રસાદમિવ તદ્ ભક્ષ્યં ભુઞ્જતે તેન દુર્બ્બલતયા તેષાં સ્વાન્તાનિ મલીમસાનિ ભવન્તિ| ");
INSERT INTO sanguj_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","કિન્તુ ભક્ષ્યદ્રવ્યાદ્ વયમ્ ઈશ્વરેણ ગ્રાહ્યા ભવામસ્તન્નહિ યતો ભુઙ્ક્ત્વા વયમુત્કૃષ્ટા ન ભવામસ્તદ્વદભુઙ્ક્ત્વાપ્યપકૃષ્ટા ન ભવામઃ| ");
INSERT INTO sanguj_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","અતો યુષ્માકં યા ક્ષમતા સા દુર્બ્બલાનામ્ ઉન્માથસ્વરૂપા યન્ન ભવેત્ તદર્થં સાવધાના ભવત| ");
INSERT INTO sanguj_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","યતો જ્ઞાનવિશિષ્ટસ્ત્વં યદિ દેવાલયે ઉપવિષ્ટઃ કેનાપિ દૃશ્યસે તર્હિ તસ્ય દુર્બ્બલસ્ય મનસિ કિં પ્રસાદભક્ષણ ઉત્સાહો ન જનિષ્યતે? ");
INSERT INTO sanguj_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","તથા સતિ યસ્ય કૃતે ખ્રીષ્ટો મમાર તવ સ દુર્બ્બલો ભ્રાતા તવ જ્ઞાનાત્ કિં ન વિનંક્ષ્યતિ? ");
INSERT INTO sanguj_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","ઇત્યનેન પ્રકારેણ ભ્રાતૃણાં વિરુદ્ધમ્ અપરાધ્યદ્ભિસ્તેષાં દુર્બ્બલાનિ મનાંસિ વ્યાઘાતયદ્ભિશ્ચ યુષ્માભિઃ ખ્રીષ્ટસ્ય વૈપરીત્યેનાપરાધ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","અતો હેતોઃ પિશિતાશનં યદિ મમ ભ્રાતુ ર્વિઘ્નસ્વરૂપં ભવેત્ તર્હ્યહં યત્ સ્વભ્રાતુ ર્વિઘ્નજનકો ન ભવેયં તદર્થં યાવજ્જીવનં પિશિતં ન ભોક્ષ્યે| ");
INSERT INTO sanguj_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","અહં કિમ્ એકઃ પ્રેરિતો નાસ્મિ? કિમહં સ્વતન્ત્રો નાસ્મિ? અસ્માકં પ્રભુ ર્યીશુઃ ખ્રીષ્ટઃ કિં મયા નાદર્શિ? યૂયમપિ કિં પ્રભુના મદીયશ્રમફલસ્વરૂપા ન ભવથ? ");
INSERT INTO sanguj_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","અન્યલોકાનાં કૃતે યદ્યપ્યહં પ્રેરિતો ન ભવેયં તથાચ યુષ્મત્કૃતે પ્રેરિતોઽસ્મિ યતઃ પ્રભુના મમ પ્રેરિતત્વપદસ્ય મુદ્રાસ્વરૂપા યૂયમેવાધ્વે| ");
INSERT INTO sanguj_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","યે લોકા મયિ દોષમારોપયન્તિ તાન્ પ્રતિ મમ પ્રત્યુત્તરમેતત્| ");
INSERT INTO sanguj_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","ભોજનપાનયોઃ કિમસ્માકં ક્ષમતા નાસ્તિ? ");
INSERT INTO sanguj_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","અન્યે પ્રેરિતાઃ પ્રભો ર્ભ્રાતરૌ કૈફાશ્ચ યત્ કુર્વ્વન્તિ તદ્વત્ કાઞ્ચિત્ ધર્મ્મભગિનીં વ્યૂહ્ય તયા સાર્દ્ધં પર્ય્યટિતું વયં કિં ન શક્નુમઃ? ");
INSERT INTO sanguj_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","સાંસારિકશ્રમસ્ય પરિત્યાગાત્ કિં કેવલમહં બર્ણબ્બાશ્ચ નિવારિતૌ? ");
INSERT INTO sanguj_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","નિજધનવ્યયેન કઃ સંગ્રામં કરોતિ? કો વા દ્રાક્ષાક્ષેત્રં કૃત્વા તત્ફલાનિ ન ભુઙ્ક્તે? કો વા પશુવ્રજં પાલયન્ તત્પયો ન પિવતિ? ");
INSERT INTO sanguj_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","કિમહં કેવલાં માનુષિકાં વાચં વદામિ? વ્યવસ્થાયાં કિમેતાદૃશં વચનં ન વિદ્યતે? ");
INSERT INTO sanguj_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","મૂસાવ્યવસ્થાગ્રન્થે લિખિતમાસ્તે, ત્વં શસ્યમર્દ્દકવૃષસ્યાસ્યં ન ભંત્સ્યસીતિ| ઈશ્વરેણ બલીવર્દ્દાનામેવ ચિન્તા કિં ક્રિયતે? ");
INSERT INTO sanguj_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","કિં વા સર્વ્વથાસ્માકં કૃતે તદ્વચનં તેનોક્તં? અસ્માકમેવ કૃતે તલ્લિખિતં| યઃ ક્ષેત્રં કર્ષતિ તેન પ્રત્યાશાયુક્તેન કર્ષ્ટવ્યં, યશ્ચ શસ્યાનિ મર્દ્દયતિ તેન લાભપ્રત્યાશાયુક્તેન મર્દ્દિતવ્યં| ");
INSERT INTO sanguj_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","યુષ્મત્કૃતેઽસ્માભિઃ પારત્રિકાણિ બીજાનિ રોપિતાનિ, અતો યુષ્માકમૈહિકફલાનાં વયમ્ અંશિનો ભવિષ્યામઃ કિમેતત્ મહત્ કર્મ્મ? ");
INSERT INTO sanguj_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","યુષ્માસુ યોઽધિકારસ્તસ્ય ભાગિનો યદ્યન્યે ભવેયુસ્તર્હ્યસ્માભિસ્તતોઽધિકં કિં તસ્ય ભાગિભિ ર્ન ભવિતવ્યં? અધિકન્તુ વયં તેનાધિકારેણ ન વ્યવહૃતવન્તઃ કિન્તુ ખ્રીષ્ટીયસુસંવાદસ્ય કોઽપિ વ્યાઘાતોઽસ્માભિર્યન્ન જાયેત તદર્થં સર્વ્વં સહામહે| ");
INSERT INTO sanguj_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","અપરં યે પવિત્રવસ્તૂનાં પરિચર્ય્યાં કુર્વ્વન્તિ તે પવિત્રવસ્તુતો ભક્ષ્યાણિ લભન્તે, યે ચ વેદ્યાઃ પરિચર્ય્યાં કુર્વ્વન્તિ તે વેદિસ્થવસ્તૂનામ્ અંશિનો ભવન્ત્યેતદ્ યૂયં કિં ન વિદ? ");
INSERT INTO sanguj_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","તદ્વદ્ યે સુસંવાદં ઘોષયન્તિ તૈઃ સુસંવાદેન જીવિતવ્યમિતિ પ્રભુનાદિષ્ટં| ");
INSERT INTO sanguj_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","અહમેતેષાં સર્વ્વેષાં કિમપિ નાશ્રિતવાન્ માં પ્રતિ તદનુસારાત્ આચરિતવ્યમિત્યાશયેનાપિ પત્રમિદં મયા ન લિખ્યતે યતઃ કેનાપિ જનેન મમ યશસો મુધાકરણાત્ મમ મરણં વરં| ");
INSERT INTO sanguj_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","સુસંવાદઘેષણાત્ મમ યશો ન જાયતે યતસ્તદ્ઘોષણં મમાવશ્યકં યદ્યહં સુસંવાદં ન ઘોષયેયં તર્હિ માં ધિક્| ");
INSERT INTO sanguj_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","ઇચ્છુકેન તત્ કુર્વ્વતા મયા ફલં લપ્સ્યતે કિન્ત્વનિચ્છુકેઽપિ મયિ તત્કર્મ્મણો ભારોઽર્પિતોઽસ્તિ| ");
INSERT INTO sanguj_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","એતેન મયા લભ્યં ફલં કિં? સુસંવાદેન મમ યોઽધિકાર આસ્તે તં યદભદ્રભાવેન નાચરેયં તદર્થં સુસંવાદઘોષણસમયે તસ્ય ખ્રીષ્ટીયસુસંવાદસ્ય નિર્વ્યયીકરણમેવ મમ ફલં| ");
INSERT INTO sanguj_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","સર્વ્વેષામ્ અનાયત્તોઽહં યદ્ ભૂરિશો લોકાન્ પ્રતિપદ્યે તદર્થં સર્વ્વેષાં દાસત્વમઙ્ગીકૃતવાન્| ");
INSERT INTO sanguj_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","યિહૂદીયાન્ યત્ પ્રતિપદ્યે તદર્થં યિહૂદીયાનાં કૃતે યિહૂદીયઇવાભવં| યે ચ વ્યવસ્થાયત્તાસ્તાન્ યત્ પ્રતિપદ્યે તદર્થં વ્યવસ્થાનાયત્તો યોઽહં સોઽહં વ્યવસ્થાયત્તાનાં કૃતે વ્યવસ્થાયત્તઇવાભવં| ");
INSERT INTO sanguj_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","યે ચાલબ્ધવ્યવસ્થાસ્તાન્ યત્ પ્રતિપદ્યે તદર્થમ્ ઈશ્વરસ્ય સાક્ષાદ્ અલબ્ધવ્યવસ્થો ન ભૂત્વા ખ્રીષ્ટેન લબ્ધવ્યવસ્થો યોઽહં સોઽહમ્ અલબ્ધવ્યવસ્થાનાં કૃતેઽલબ્ધવ્યવસ્થ ઇવાભવં| ");
INSERT INTO sanguj_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","દુર્બ્બલાન્ યત્ પ્રતિપદ્યે તદર્થમહં દુર્બ્બલાનાં કૃતે દુર્બ્બલઇવાભવં| ઇત્થં કેનાપિ પ્રકારેણ કતિપયા લોકા યન્મયા પરિત્રાણં પ્રાપ્નુયુસ્તદર્થં યો યાદૃશ આસીત્ તસ્ય કૃતે ઽહં તાદૃશઇવાભવં| ");
INSERT INTO sanguj_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","ઇદૃશ આચારઃ સુસંવાદાર્થં મયા ક્રિયતે યતોઽહં તસ્ય ફલાનાં સહભાગી ભવિતુમિચ્છામિ| ");
INSERT INTO sanguj_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","પણ્યલાભાર્થં યે ધાવન્તિ ધાવતાં તેષાં સર્વ્વેષાં કેવલ એકઃ પણ્યં લભતે યુષ્માભિઃ કિમેતન્ન જ્ઞાયતે? અતો યૂયં યથા પણ્યં લપ્સ્યધ્વે તથૈવ ધાવત| ");
INSERT INTO sanguj_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","મલ્લા અપિ સર્વ્વભોગે પરિમિતભોગિનો ભવન્તિ તે તુ મ્લાનાં સ્રજં લિપ્સન્તે કિન્તુ વયમ્ અમ્લાનાં લિપ્સામહે| ");
INSERT INTO sanguj_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","તસ્માદ્ અહમપિ ધાવામિ કિન્તુ લક્ષ્યમનુદ્દિશ્ય ધાવામિ તન્નહિ| અહં મલ્લઇવ યુધ્યામિ ચ કિન્તુ છાયામાઘાતયન્નિવ યુધ્યામિ તન્નહિ| ");
INSERT INTO sanguj_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","ઇતરાન્ પ્રતિ સુસંવાદં ઘોષયિત્વાહં યત્ સ્વયમગ્રાહ્યો ન ભવામિ તદર્થં દેહમ્ આહન્મિ વશીકુર્વ્વે ચ| ");
INSERT INTO sanguj_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","હે ભ્રાતરઃ, અસ્મત્પિતૃપુરુષાનધિ યૂયં યદજ્ઞાતા ન તિષ્ઠતેતિ મમ વાઞ્છા, તે સર્વ્વે મેઘાધઃસ્થિતા બભૂવુઃ સર્વ્વે સમુદ્રમધ્યેન વવ્રજુઃ, ");
INSERT INTO sanguj_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","સર્વ્વે મૂસામુદ્દિશ્ય મેઘસમુદ્રયો ર્મજ્જિતા બભૂવુઃ ");
INSERT INTO sanguj_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","સર્વ્વ એકમ્ આત્મિકં ભક્ષ્યં બુભુજિર એકમ્ આત્મિકં પેયં પપુશ્ચ ");
INSERT INTO sanguj_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","યતસ્તેઽનુચરત આત્મિકાદ્ અચલાત્ લબ્ધં તોયં પપુઃ સોઽચલઃ ખ્રીષ્ટએવ| ");
INSERT INTO sanguj_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","તથા સત્યપિ તેષાં મધ્યેઽધિકેષુ લોકેષ્વીશ્વરો ન સન્તુતોષેતિ હેતોસ્તે પ્રન્તરે નિપાતિતાઃ| ");
INSERT INTO sanguj_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","એતસ્મિન્ તે ઽસ્માકં નિદર્શનસ્વરૂપા બભૂવુઃ; અતસ્તે યથા કુત્સિતાભિલાષિણો બભૂવુરસ્માભિસ્તથા કુત્સિતાભિલાષિભિ ર્ન ભવિતવ્યં| ");
INSERT INTO sanguj_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","લિખિતમાસ્તે, લોકા ભોક્તું પાતુઞ્ચોપવિવિશુસ્તતઃ ક્રીડિતુમુત્થિતા ઇતયનેન પ્રકારેણ તેષાં કૈશ્ચિદ્ યદ્વદ્ દેવપૂજા કૃતા યુષ્માભિસ્તદ્વત્ ન ક્રિયતાં| ");
INSERT INTO sanguj_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","અપરં તેષાં કૈશ્ચિદ્ યદ્વદ્ વ્યભિચારઃ કૃતસ્તેન ચૈકસ્મિન્ દિને ત્રયોવિંશતિસહસ્રાણિ લોકા નિપાતિતાસ્તદ્વદ્ અસ્માભિ ર્વ્યભિચારો ન કર્ત્તવ્યઃ| ");
INSERT INTO sanguj_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","તેષાં કેચિદ્ યદ્વત્ ખ્રીષ્ટં પરીક્ષિતવન્તસ્તસ્માદ્ ભુજઙ્ગૈ ર્નષ્ટાશ્ચ તદ્વદ્ અસ્માભિઃ ખ્રીષ્ટો ન પરીક્ષિતવ્યઃ| ");
INSERT INTO sanguj_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","તેષાં કેચિદ્ યથા વાક્કલહં કૃતવન્તસ્તત્કારણાત્ હન્ત્રા વિનાશિતાશ્ચ યુષ્માભિસ્તદ્વદ્ વાક્કલહો ન ક્રિયતાં| ");
INSERT INTO sanguj_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","તાન્ પ્રતિ યાન્યેતાનિ જઘટિરે તાન્યસ્માકં નિદર્શનાનિ જગતઃ શેષયુગે વર્ત્તમાનાનામ્ અસ્માકં શિક્ષાર્થં લિખિતાનિ ચ બભૂવુઃ| ");
INSERT INTO sanguj_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","અતએવ યઃ કશ્ચિદ્ સુસ્થિરંમન્યઃ સ યન્ન પતેત્ તત્ર સાવધાનો ભવતુ| ");
INSERT INTO sanguj_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","માનુષિકપરીક્ષાતિરિક્તા કાપિ પરીક્ષા યુષ્માન્ નાક્રામત્, ઈશ્વરશ્ચ વિશ્વાસ્યઃ સોઽતિશક્ત્યાં પરીક્ષાયાં પતનાત્ યુષ્માન્ રક્ષિષ્યતિ, પરીક્ષા ચ યદ્ યુષ્માભિઃ સોઢું શક્યતે તદર્થં તયા સહ નિસ્તારસ્ય પન્થાનં નિરૂપયિષ્યતિ| ");
INSERT INTO sanguj_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","હે પ્રિયભ્રાતરઃ, દેવપૂજાતો દૂરમ્ અપસરત| ");
INSERT INTO sanguj_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","અહં યુષ્માન્ વિજ્ઞાન્ મત્વા પ્રભાષે મયા યત્ કથ્યતે તદ્ યુષ્માભિ ર્વિવિચ્યતાં| ");
INSERT INTO sanguj_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","યદ્ ધન્યવાદપાત્રમ્ અસ્માભિ ર્ધન્યં ગદ્યતે તત્ કિં ખ્રીષ્ટસ્ય શોણિતસ્ય સહભાગિત્વં નહિ? યશ્ચ પૂપોઽસ્માભિ ર્ભજ્યતે સ કિં ખ્રીષ્ટસ્ય વપુષઃ સહભાગિત્વં નહિ? ");
INSERT INTO sanguj_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","વયં બહવઃ સન્તોઽપ્યેકપૂપસ્વરૂપા એકવપુઃસ્વરૂપાશ્ચ ભવામઃ, યતો વયં સર્વ્વ એકપૂપસ્ય સહભાગિનઃ| ");
INSERT INTO sanguj_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","યૂયં શારીરિકમ્ ઇસ્રાયેલીયવંશં નિરીક્ષધ્વં| યે બલીનાં માંસાનિ ભુઞ્જતે તે કિં યજ્ઞવેદ્યાઃ સહભાગિનો ન ભવન્તિ? ");
INSERT INTO sanguj_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","ઇત્યનેન મયા કિં કથ્યતે? દેવતા વાસ્તવિકી દેવતાયૈ બલિદાનં વા વાસ્તવિકં કિં ભવેત્? ");
INSERT INTO sanguj_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","તન્નહિ કિન્તુ ભિન્નજાતિભિ ર્યે બલયો દીયન્તે ત ઈશ્વરાય તન્નહિ ભૂતેભ્યએવ દીયન્તે તસ્માદ્ યૂયં યદ્ ભૂતાનાં સહભાગિનો ભવથેત્યહં નાભિલષામિ| ");
INSERT INTO sanguj_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","પ્રભોઃ કંસેન ભૂતાનામપિ કંસેન પાનં યુષ્માભિરસાધ્યં; યૂયં પ્રભો ર્ભોજ્યસ્ય ભૂતાનામપિ ભોજ્યસ્ય સહભાગિનો ભવિતું ન શક્નુથ| ");
INSERT INTO sanguj_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","વયં કિં પ્રભું સ્પર્દ્ધિષ્યામહે? વયં કિં તસ્માદ્ બલવન્તઃ? ");
INSERT INTO sanguj_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","માં પ્રતિ સર્વ્વં કર્મ્માપ્રતિષિદ્ધં કિન્તુ ન સર્વ્વં હિતજનકં સર્વ્વમ્ અપ્રતિષિદ્ધં કિન્તુ ન સર્વ્વં નિષ્ઠાજનકં| ");
INSERT INTO sanguj_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","આત્મહિતઃ કેનાપિ ન ચેષ્ટિતવ્યઃ કિન્તુ સર્વ્વૈઃ પરહિતશ્ચેષ્ટિતવ્યઃ| ");
INSERT INTO sanguj_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","આપણે યત્ ક્રય્યં તદ્ યુષ્માભિઃ સંવેદસ્યાર્થં કિમપિ ન પૃષ્ટ્વા ભુજ્યતાં ");
INSERT INTO sanguj_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","યતઃ પૃથિવી તન્મધ્યસ્થઞ્ચ સર્વ્વં પરમેશ્વરસ્ય| ");
INSERT INTO sanguj_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","અપરમ્ અવિશ્વાસિલોકાનાં કેનચિત્ નિમન્ત્રિતા યૂયં યદિ તત્ર જિગમિષથ તર્હિ તેન યદ્ યદ્ ઉપસ્થાપ્યતે તદ્ યુષ્માભિઃ સંવેદસ્યાર્થં કિમપિ ન પૃષ્ટ્વા ભુજ્યતાં| ");
INSERT INTO sanguj_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","કિન્તુ તત્ર યદિ કશ્ચિદ્ યુષ્માન્ વદેત્ ભક્ષ્યમેતદ્ દેવતાયાઃ પ્રસાદ ઇતિ તર્હિ તસ્ય જ્ઞાપયિતુરનુરોધાત્ સંવેદસ્યાર્થઞ્ચ તદ્ યુષ્માભિ ર્ન ભોક્તવ્યં| પૃથિવી તન્મધ્યસ્થઞ્ચ સર્વ્વં પરમેશ્વરસ્ય, ");
INSERT INTO sanguj_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","સત્યમેતત્, કિન્તુ મયા યઃ સંવેદો નિર્દ્દિશ્યતે સ તવ નહિ પરસ્યૈવ| ");
INSERT INTO sanguj_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","અનુગ્રહપાત્રેણ મયા ધન્યવાદં કૃત્વા યદ્ ભુજ્યતે તત્કારણાદ્ અહં કુતો નિન્દિષ્યે? ");
INSERT INTO sanguj_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","તસ્માદ્ ભોજનં પાનમ્ અન્યદ્વા કર્મ્મ કુર્વ્વદ્ભિ ર્યુષ્માભિઃ સર્વ્વમેવેશ્વરસ્ય મહિમ્નઃ પ્રકાશાર્થં ક્રિયતાં| ");
INSERT INTO sanguj_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","યિહૂદીયાનાં ભિન્નજાતીયાનામ્ ઈશ્વરસ્ય સમાજસ્ય વા વિઘ્નજનકૈ ર્યુષ્માભિ ર્ન ભવિતવ્યં| ");
INSERT INTO sanguj_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","અહમપ્યાત્મહિતમ્ અચેષ્ટમાનો બહૂનાં પરિત્રાણાર્થં તેષાં હિતં ચેષ્ટમાનઃ સર્વ્વવિષયે સર્વ્વેષાં તુષ્ટિકરો ભવામીત્યનેનાહં યદ્વત્ ખ્રીષ્ટસ્યાનુગામી તદ્વદ્ યૂયં મમાનુગામિનો ભવત| ");
INSERT INTO sanguj_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","હે ભ્રાતરઃ, યૂયં સર્વ્વસ્મિન્ કાર્ય્યે માં સ્મરથ મયા ચ યાદૃગુપદિષ્ટાસ્તાદૃગાચરથૈતત્કારણાત્ મયા પ્રશંસનીયા આધ્બે| ");
INSERT INTO sanguj_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","તથાપિ મમૈષા વાઞ્છા યદ્ યૂયમિદમ્ અવગતા ભવથ, ");
INSERT INTO sanguj_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","એકૈકસ્ય પુરુષસ્યોત્તમાઙ્ગસ્વરૂપઃ ખ્રીષ્ટઃ, યોષિતશ્ચોત્તમાઙ્ગસ્વરૂપઃ પુમાન્, ખ્રીષ્ટસ્ય ચોત્તમાઙ્ગસ્વરૂપ ઈશ્વરઃ| ");
INSERT INTO sanguj_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","અપરમ્ આચ્છાદિતોત્તમાઙ્ગેન યેન પુંસા પ્રાર્થના ક્રિયત ઈશ્વરીયવાણી કથ્યતે વા તેન સ્વીયોત્તમાઙ્ગમ્ અવજ્ઞાયતે| ");
INSERT INTO sanguj_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","અનાચ્છાદિતોત્તમાઙ્ગયા યયા યોષિતા ચ પ્રાર્થના ક્રિયત ઈશ્વરીયવાણી કથ્યતે વા તયાપિ સ્વીયોત્તમાઙ્ગમ્ અવજ્ઞાયતે યતઃ સા મુણ્ડિતશિરઃસદૃશા| ");
INSERT INTO sanguj_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","અનાચ્છાદિતમસ્તકા યા યોષિત્ તસ્યાઃ શિરઃ મુણ્ડનીયમેવ કિન્તુ યોષિતઃ કેશચ્છેદનં શિરોમુણ્ડનં વા યદિ લજ્જાજનકં ભવેત્ તર્હિ તયા સ્વશિર આચ્છાદ્યતાં| ");
INSERT INTO sanguj_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","પુમાન્ ઈશ્વરસ્ય પ્રતિમૂર્ત્તિઃ પ્રતિતેજઃસ્વરૂપશ્ચ તસ્માત્ તેન શિરો નાચ્છાદનીયં કિન્તુ સીમન્તિની પુંસઃ પ્રતિબિમ્બસ્વરૂપા| ");
INSERT INTO sanguj_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","યતો યોષાતઃ પુમાન્ નોદપાદિ કિન્તુ પુંસો યોષિદ્ ઉદપાદિ| ");
INSERT INTO sanguj_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","અધિકન્તુ યોષિતઃ કૃતે પુંસઃ સૃષ્ટિ ર્ન બભૂવ કિન્તુ પુંસઃ કૃતે યોષિતઃ સૃષ્ટિ ર્બભૂવ| ");
INSERT INTO sanguj_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","ઇતિ હેતો ર્દૂતાનામ્ આદરાદ્ યોષિતા શિરસ્યધીનતાસૂચકમ્ આવરણં ધર્ત્તવ્યં| ");
INSERT INTO sanguj_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","તથાપિ પ્રભો ર્વિધિના પુમાંસં વિના યોષિન્ન જાયતે યોષિતઞ્ચ વિના પુમાન્ ન જાયતે| ");
INSERT INTO sanguj_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","યતો યથા પુંસો યોષિદ્ ઉદપાદિ તથા યોષિતઃ પુમાન્ જાયતે, સર્વ્વવસ્તૂનિ ચેશ્વરાદ્ ઉત્પદ્યન્તે| ");
INSERT INTO sanguj_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","યુષ્માભિરેવૈતદ્ વિવિચ્યતાં, અનાવૃતયા યોષિતા પ્રાર્થનં કિં સુદૃશ્યં ભવેત્? ");
INSERT INTO sanguj_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","પુરુષસ્ય દીર્ઘકેશત્વં તસ્ય લજ્જાજનકં, કિન્તુ યોષિતો દીર્ઘકેશત્વં તસ્યા ગૌરવજનકં ");
INSERT INTO sanguj_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","યત આચ્છાદનાય તસ્યૈ કેશા દત્તા ઇતિ કિં યુષ્માભિઃ સ્વભાવતો ન શિક્ષ્યતે? ");
INSERT INTO sanguj_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","અત્ર યદિ કશ્ચિદ્ વિવદિતુમ્ ઇચ્છેત્ તર્હ્યસ્માકમ્ ઈશ્વરીયસમિતીનાઞ્ચ તાદૃશી રીતિ ર્ન વિદ્યતે| ");
INSERT INTO sanguj_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","યુષ્માભિ ર્ન ભદ્રાય કિન્તુ કુત્સિતાય સમાગમ્યતે તસ્માદ્ એતાનિ ભાષમાણેન મયા યૂયં ન પ્રશંસનીયાઃ| ");
INSERT INTO sanguj_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","પ્રથમતઃ સમિતૌ સમાગતાનાં યુષ્માકં મધ્યે ભેદાઃ સન્તીતિ વાર્ત્તા મયા શ્રૂયતે તન્મધ્યે કિઞ્ચિત્ સત્યં મન્યતે ચ| ");
INSERT INTO sanguj_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","યતો હેતો ર્યુષ્મન્મધ્યે યે પરીક્ષિતાસ્તે યત્ પ્રકાશ્યન્તે તદર્થં ભેદૈ ર્ભવિતવ્યમેવ| ");
INSERT INTO sanguj_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","એકત્ર સમાગતૈ ર્યુષ્માભિઃ પ્રભાવં ભેाજ્યં ભુજ્યત ઇતિ નહિ; ");
INSERT INTO sanguj_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","યતો ભોજનકાલે યુષ્માકમેકૈકેન સ્વકીયં ભક્ષ્યં તૂર્ણં ગ્રસ્યતે તસ્માદ્ એકો જનો બુભુક્ષિતસ્તિષ્ઠતિ, અન્યશ્ચ પરિતૃપ્તો ભવતિ| ");
INSERT INTO sangu