﻿USE sofia;
DROP TABLE IF EXISTS sofia.sandev_vpl;
CREATE TABLE sandev_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sandev_vpl WRITE;
INSERT INTO sandev_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","इब्राहीमः सन्तानो दायूद् तस्य सन्तानो यीशुख्रीष्टस्तस्य पूर्व्वपुरुषवंशश्रेणी। ");
INSERT INTO sandev_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","इब्राहीमः पुत्र इस्हाक् तस्य पुत्रो याकूब् तस्य पुत्रो यिहूदास्तस्य भ्रातरश्च। ");
INSERT INTO sandev_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","तस्माद् यिहूदातस्तामरो गर्भे पेरस्सेरहौ जज्ञाते, तस्य पेरसः पुत्रो हिष्रोण् तस्य पुत्रो ऽराम्। ");
INSERT INTO sandev_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","तस्य पुत्रो ऽम्मीनादब् तस्य पुत्रो नहशोन् तस्य पुत्रः सल्मोन्। ");
INSERT INTO sandev_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","तस्माद् राहबो गर्भे बोयम् जज्ञे, तस्माद् रूतो गर्भे ओबेद् जज्ञे, तस्य पुत्रो यिशयः। ");
INSERT INTO sandev_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","तस्य पुत्रो दायूद् राजः तस्माद् मृतोरियस्य जायायां सुलेमान् जज्ञे। ");
INSERT INTO sandev_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","तस्य पुत्रो रिहबियाम्, तस्य पुत्रोऽबियः, तस्य पुत्र आसा:। ");
INSERT INTO sandev_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","तस्य सुतो यिहोशाफट् तस्य सुतो यिहोराम तस्य सुत उषियः। ");
INSERT INTO sandev_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","तस्य सुतो योथम् तस्य सुत आहम् तस्य सुतो हिष्कियः। ");
INSERT INTO sandev_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","तस्य सुतो मिनशिः, तस्य सुत आमोन् तस्य सुतो योशियः। ");
INSERT INTO sandev_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","बाबिल्नगरे प्रवसनात् पूर्व्वं स योशियो यिखनियं तस्य भ्रातृंश्च जनयामास। ");
INSERT INTO sandev_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ततो बाबिलि प्रवसनकाले यिखनियः शल्तीयेलं जनयामास, तस्य सुतः सिरुब्बाविल्। ");
INSERT INTO sandev_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","तस्य सुतो ऽबोहुद् तस्य सुत इलीयाकीम् तस्य सुतोऽसोर्। ");
INSERT INTO sandev_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","असोरः सुतः सादोक् तस्य सुत आखीम् तस्य सुत इलीहूद्। ");
INSERT INTO sandev_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","तस्य सुत इलियासर् तस्य सुतो मत्तन्। ");
INSERT INTO sandev_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","तस्य सुतो याकूब् तस्य सुतो यूषफ् तस्य जाया मरियम्; तस्य गर्भे यीशुरजनि, तमेव ख्रीष्टम् (अर्थाद् अभिषिक्तं) वदन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","इत्थम् इब्राहीमो दायूदं यावत् साकल्येन चतुर्दशपुरुषाः; आ दायूदः कालाद् बाबिलि प्रवसनकालं यावत् चतुर्दशपुरुषा भवन्ति। बाबिलि प्रवासनकालात् ख्रीष्टस्य कालं यावत् चतुर्दशपुरुषा भवन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","यीशुख्रीष्टस्य जन्म कथ्थते। मरियम् नामिका कन्या यूषफे वाग्दत्तासीत्, तदा तयोः सङ्गमात् प्राक् सा कन्या  पवित्रेणात्मना गर्भवती बभूव। ");
INSERT INTO sandev_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","तत्र तस्याः पति र्यूषफ् सौजन्यात् तस्याः कलङ्गं प्रकाशयितुम् अनिच्छन् गोपनेने तां पारित्यक्तुं मनश्चक्रे। ");
INSERT INTO sandev_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","स तथैव भावयति, तदानीं परमेश्वरस्य दूतः स्वप्ने तं दर्शनं दत्त्वा व्याजहार, हे दायूदः सन्तान यूषफ् त्वं निजां जायां मरियमम् आदातुं मा भैषीः। ");
INSERT INTO sandev_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","यतस्तस्या गर्भः पवित्रादात्मनोऽभवत्, सा च पुत्रं प्रसविष्यते, तदा त्वं तस्य नाम यीशुम् (अर्थात् त्रातारं) करीष्यसे, यस्मात् स निजमनुजान् तेषां कलुषेभ्य उद्धरिष्यति। ");
INSERT INTO sandev_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","इत्थं सति, पश्य गर्भवती कन्या तनयं प्रसविष्यते। इम्मानूयेल् तदीयञ्च नामधेयं भविष्यति॥ इम्मानूयेल् अस्माकं सङ्गीश्वरइत्यर्थः। ");
INSERT INTO sandev_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","इति यद् वचनं पुर्व्वं भविष्यद्वक्त्रा ईश्वरः कथायामास, तत् तदानीं सिद्धमभवत्। ");
INSERT INTO sandev_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","अनन्तरं यूषफ् निद्रातो जागरित उत्थाय परमेश्वरीयदूतस्य निदेशानुसारेण निजां जायां जग्राह, ");
INSERT INTO sandev_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","किन्तु यावत् सा निजं प्रथमसुतं अ सुषुवे, तावत् तां नोपागच्छत्, ततः सुतस्य नाम यीशुं चक्रे। ");
INSERT INTO sandev_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","अनन्तरं हेरोद् संज्ञके राज्ञि राज्यं शासति यिहूदीयदेशस्य बैत्लेहमि नगरे यीशौ जातवति च, कतिपया ज्योतिर्व्वुदः पूर्व्वस्या दिशो यिरूशालम्नगरं समेत्य कथयमासुः, ");
INSERT INTO sandev_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","यो यिहूदीयानां राजा जातवान्, स कुत्रास्ते? वयं पूर्व्वस्यां दिशि तिष्ठन्तस्तदीयां तारकाम् अपश्याम तस्मात् तं प्रणन्तुम् अागमाम। ");
INSERT INTO sandev_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","तदा हेरोद् राजा कथामेतां निशम्य यिरूशालम्नगरस्थितैः सर्व्वमानवैः सार्द्धम् उद्विज्य ");
INSERT INTO sandev_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","सर्व्वान् प्रधानयाजकान् अध्यापकांश्च समाहूयानीय पप्रच्छ, ख्रीष्टः कुत्र जनिष्यते? ");
INSERT INTO sandev_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","तदा ते कथयामासुः, यिहूदीयदेशस्य बैत्लेहमि नगरे, यतो भविष्यद्वादिना इत्थं लिखितमास्ते, ");
INSERT INTO sandev_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","सर्व्वाभ्यो राजधानीभ्यो यिहूदीयस्य नीवृतः। हे यीहूदीयदेशस्ये बैत्लेहम् त्वं न चावरा। इस्रायेलीयलोकान् मे यतो यः पालयिष्यति। तादृगेको महाराजस्त्वन्मध्य उद्भविष्यती॥ ");
INSERT INTO sandev_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","तदानीं हेरोद् राजा तान् ज्योतिर्व्विदो गोपनम् आहूय सा तारका कदा दृष्टाभवत् , तद् विनिश्चयामास। ");
INSERT INTO sandev_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","अपरं तान् बैत्लेहमं प्रहीत्य गदितवान्, यूयं यात, यत्नात् तं शिशुम् अन्विष्य तदुद्देशे प्राप्ते मह्यं वार्त्तां दास्यथ, ततो मयापि गत्वा स प्रणंस्यते। ");
INSERT INTO sandev_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","तदानीं राज्ञ एतादृशीम् आज्ञां प्राप्य ते प्रतस्थिरे, ततः पूर्व्वर्स्यां दिशि स्थितैस्तै र्या तारका दृष्टा सा तारका तेषामग्रे गत्वा यत्र स्थाने शिशूरास्ते, तस्य स्थानस्योपरि स्थगिता तस्यौ। ");
INSERT INTO sandev_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","तद् दृष्ट्वा ते महानन्दिता बभूवुः, ");
INSERT INTO sandev_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ततो गेहमध्य प्रविश्य तस्य मात्रा मरियमा साद्धं तं शिशुं निरीक्षय दण्डवद् भूत्वा प्रणेमुः, अपरं स्वेषां घनसम्पत्तिं मोचयित्वा सुवर्णं कुन्दुरुं गन्धरमञ्च तस्मै दर्शनीयं दत्तवन्तः। ");
INSERT INTO sandev_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","पश्चाद् हेरोद् राजस्य समीपं पुनरपि गन्तुं स्वप्न ईश्वरेण निषिद्धाः सन्तो ऽन्येन पथा ते निजदेशं प्रति प्रतस्थिरे। ");
INSERT INTO sandev_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","अनन्तरं तेषु गतवत्मु परमेश्वरस्य दूतो यूषफे स्वप्ने दर्शनं दत्वा जगाद, त्वम् उत्थाय शिशुं तन्मातरञ्च गृहीत्वा मिसर्देशं पलायस्व, अपरं यावदहं तुभ्यं वार्त्तां न कथयिष्यामि, तावत् तत्रैव निवस, यतो राजा हेरोद् शिशुं नाशयितुं मृगयिष्यते। ");
INSERT INTO sandev_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","तदानीं यूषफ् उत्थाय रजन्यां शिशुं तन्मातरञ्च गृहीत्वा मिसर्देशं प्रति प्रतस्थे, ");
INSERT INTO sandev_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","गत्वा च हेरोदो नृपते र्मरणपर्य्यन्तं तत्र देशे न्युवास, तेन मिसर्देशादहं पुत्रं स्वकीयं समुपाहूयम्। यदेतद्वचनम् ईश्वरेण भविष्यद्वादिना कथितं तत् सफलमभूत्। ");
INSERT INTO sandev_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","अनन्तरं हेरोद् ज्योतिर्विद्भिरात्मानं प्रवञ्चितं विज्ञाय भृशं चुकोप; अपरं ज्योतिर्व्विद्भ्यस्तेन विनिश्चितं यद् दिनं तद्दिनाद् गणयित्वा द्वितीयवत्सरं प्रविष्टा यावन्तो बालका अस्मिन् बैत्लेहम्नगरे तत्सीममध्ये चासन्, लोकान् प्रहित्य तान् सर्व्वान् घातयामास। ");
INSERT INTO sandev_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","अतः अनेकस्य विलापस्य निनाद: क्रन्दनस्य च। शोकेन कृतशब्दश्च रामायां संनिशम्यते। स्वबालगणहेतोर्वै राहेल् नारी तु रोदिनी। न मन्यते प्रबोधन्तु यतस्ते नैव मन्ति हि॥ ");
INSERT INTO sandev_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","यदेतद् वचनं यिरीमियनामकभविष्यद्वादिना कथितं तत् तदानीं सफलम् अभूत्। ");
INSERT INTO sandev_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","तदनन्तरं हेरेदि राजनि मृते परमेश्वरस्य दूतो मिसर्देशे स्वप्ने दर्शनं दत्त्वा यूषफे कथितवान् ");
INSERT INTO sandev_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","त्वम् उत्थाय शिशुं तन्मातरञ्च गृहीत्वा पुनरपीस्रायेलो देशं याही, ये जनाः शिशुं नाशयितुम् अमृगयन्त, ते मृतवन्तः। ");
INSERT INTO sandev_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","तदानीं स उत्थाय शिशुं तन्मातरञ्च गृह्लन् इस्रायेल्देशम् आजगाम। ");
INSERT INTO sandev_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","किन्तु यिहूदीयदेशे अर्खिलायनाम राजकुमारो निजपितु र्हेरोदः पदं प्राप्य राजत्वं करोतीति निशम्य तत् स्थानं यातुं शङ्कितवान्, पश्चात् स्वप्न ईश्वरात् प्रबोधं प्राप्य गालील्देशस्य प्रदेशैकं प्रस्थाय नासरन्नाम नगरं गत्वा तत्र न्युषितवान्, ");
INSERT INTO sandev_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","तेन तं नासरतीयं कथयिष्यन्ति, यदेतद्वाक्यं भविष्यद्वादिभिरुक्त्तं तत् सफलमभवत्। ");
INSERT INTO sandev_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","तदानों योह्न्नामा मज्जयिता यिहूदीयदेशस्य प्रान्तरम् उपस्थाय प्रचारयन् कथयामास, ");
INSERT INTO sandev_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","मनांसि परावर्त्तयत, स्वर्गीयराजत्वं समीपमागतम्। ");
INSERT INTO sandev_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","परमेशस्य पन्थानं परिष्कुरुत सर्व्वतः। तस्य राजपथांश्चैव समीकुरुत सर्व्वथा। इत्येतत् प्रान्तरे वाक्यं वदतः कस्यचिद् रवः॥ ");
INSERT INTO sandev_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","एतद्वचनं यिशयियभविष्यद्वादिना योहनमुद्दिश्य भाषितम्। योहनो वसनं महाङ्गरोमजं तस्य कटौ चर्म्मकटिबन्धनं; स च शूककीटान् मधु च भुक्तवान्। ");
INSERT INTO sandev_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","तदानीं यिरूशालम्नगरनिवासिनः सर्व्वे यिहूदिदेशीया यर्द्दन्तटिन्या उभयतटस्थाश्च मानवा बहिरागत्य तस्य समीपे ");
INSERT INTO sandev_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","स्वीयं स्वीयं दुरितम् अङ्गीकृत्य तस्यां यर्द्दनि तेन मज्जिता बभूवुः। ");
INSERT INTO sandev_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","अपरं बहून् फिरूशिनः सिदूकिनश्च मनुजान् मंक्तुं स्वसमीपम् आगच्छ्तो विलोक्य स तान् अभिदधौ, रे रे भुजगवंशा आगामीनः कोपात् पलायितुं युष्मान् कश्चेतितवान्? ");
INSERT INTO sandev_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","मनःपरावर्त्तनस्य समुचितं फलं फलत। ");
INSERT INTO sandev_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","किन्त्वस्माकं तात इब्राहीम् अस्तीति स्वेषु मनःसु चीन्तयन्तो मा व्याहरत। यतो युष्मान् अहं वदामि, ईश्वर एतेभ्यः पाषाणेभ्य इब्राहीमः सन्तानान् उत्पादयितुं शक्नोति। ");
INSERT INTO sandev_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","अपरं पादपानां मूले कुठार इदानीमपि लगन् आस्ते, तस्माद् यस्मिन् पादपे उत्तमं फलं न भवति, स कृत्तो मध्येऽग्निं निक्षेप्स्यते। ");
INSERT INTO sandev_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","अपरम् अहं मनःपरावर्त्तनसूचकेन मज्जनेन युष्मान् मज्जयामीति सत्यं, किन्तु मम पश्चाद् य आगच्छति, स मत्तोपि महान्, अहं तदीयोपानहौ वोढुमपि नहि योग्योस्मि, स युष्मान् वह्निरूपे पवित्र आत्मनि संमज्जयिष्यति। ");
INSERT INTO sandev_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","तस्य कारे सूर्प आस्ते, स स्वीयशस्यानि सम्यक् प्रस्फोट्य निजान् सकलगोधूमान् संगृह्य भाण्डागारे स्थापयिष्यति, किंन्तु सर्व्वाणि वुषाण्यनिर्व्वाणवह्निना दाहयिष्यति। ");
INSERT INTO sandev_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","अनन्तरं यीशु र्योहना मज्जितो भवितुं गालील्प्रदेशाद् यर्द्दनि तस्य समीपम् आजगाम। ");
INSERT INTO sandev_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","किन्तु योहन् तं निषिध्य बभाषे, त्वं किं मम समीपम् आगच्छसि? वरं त्वया मज्जनं मम प्रयोजनम् आस्ते। ");
INSERT INTO sandev_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","तदानीं यीशुः प्रत्यवोचत्; ईदानीम् अनुमन्यस्व, यत इत्थं सर्व्वधर्म्मसाधनम् अस्माकं कर्त्तव्यं, ततः सोऽन्वमन्यत। ");
INSERT INTO sandev_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","अनन्तरं यीशुरम्मसि मज्जितुः सन् तत्क्षणात् तोयमध्याद् उत्थाय जगाम, तदा जीमूतद्वारे मुक्ते जाते, स ईश्वरस्यात्मानं कपोतवद् अवरुह्य स्वोपर्य्यागच्छन्तं वीक्षाञ्चक्रे। ");
INSERT INTO sandev_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","अपरम् एष मम प्रियः पुत्र एतस्मिन्नेव मम महासन्तोष एतादृशी व्योमजा वाग् बभूव। ");
INSERT INTO sandev_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","ततः परं यीशुः प्रतारकेण परीक्षितो भवितुम् आत्मना प्रान्तरम् आकृष्टः ");
INSERT INTO sandev_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","सन् चत्वारिंशदहोरात्रान् अनाहारस्तिष्ठन् क्षुधितो बभूव। ");
INSERT INTO sandev_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","तदानीं परीक्षिता तत्समीपम् आगत्य व्याहृतवान्, यदि त्वमीश्वरात्मजो भवेस्तर्ह्याज्ञया पाषाणानेतान् पूपान् विधेहि। ");
INSERT INTO sandev_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","ततः स प्रत्यब्रवीत्, इत्थं लिखितमास्ते, \"मनुजः केवलपूपेन न जीविष्यति, किन्त्वीश्वरस्य वदनाद् यानि यानि वचांसि निःसरन्ति तैरेव जीविष्यति।\" ");
INSERT INTO sandev_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","तदा प्रतारकस्तं पुण्यनगरं नीत्वा मन्दिरस्य चूडोपरि निधाय गदितवान्, ");
INSERT INTO sandev_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","त्वं यदिश्वरस्य तनयो भवेस्तर्हीतोऽधः पत, यत इत्थं लिखितमास्ते, आदेक्ष्यति निजान् दूतान् रक्षितुं त्वां परमेश्वरः। यथा सर्व्वेषु मार्गेषु त्वदीयचरणद्वये। न लगेत् प्रस्तराघातस्त्वां घरिष्यन्ति ते करैः॥ ");
INSERT INTO sandev_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","तदानीं यीशुस्तस्मै कथितवान् एतदपि लिखितमास्ते, \"त्वं निजप्रभुं परमेश्वरं मा परीक्षस्व।\" ");
INSERT INTO sandev_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","अनन्तरं प्रतारकः पुनरपि तम् अत्युञ्चधराधरोपरि नीत्वा जगतः सकलराज्यानि तदैश्वर्य्याणि च दर्शयाश्चकार कथयाञ्चकार च, ");
INSERT INTO sandev_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","यदि त्वं दण्डवद् भवन् मां प्रणमेस्तर्ह्यहम् एतानि तुभ्यं प्रदास्यामि। ");
INSERT INTO sandev_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","तदानीं यीशुस्तमवोचत्, दूरीभव प्रतारक, लिखितमिदम् आस्ते, \"त्वया निजः प्रभुः परमेश्वरः प्रणम्यः केवलः स सेव्यश्च।\" ");
INSERT INTO sandev_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","ततः प्रतारकेण स पर्य्यत्याजि, तदा स्वर्गीयदूतैरागत्य स सिषेवे। ");
INSERT INTO sandev_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","तदनन्तरं योहन् कारायां बबन्धे, तद्वार्त्तां निशम्य यीशुना गालील् प्रास्थीयत। ");
INSERT INTO sandev_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ततः परं स नासरन्नगरं विहाय जलघेस्तटे सिबूलून्नप्ताली एतयोरुवभयोः प्रदेशयोः सीम्नोर्मध्यवर्त्ती य: कफर्नाहूम् तन्नगरम् इत्वा न्यवसत्। ");
INSERT INTO sandev_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","तस्मात्, अन्यादेशीयगालीलि यर्द्दन्पारेऽब्धिरोधसि। नप्तालिसिबूलून्देशौ यत्र स्थाने स्थितौ पुरा। ");
INSERT INTO sandev_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","तत्रत्या मनुजा ये ये पर्य्यभ्राम्यन् तमिस्रके। तैर्जनैर्बृहदालोकः परिदर्शिष्यते तदा। अवसन् ये जना देशे मृत्युच्छायास्वरूपके। तेषामुपरि लोकानामालोकः संप्रकाशितः॥ ");
INSERT INTO sandev_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","यदेतद्वचनं यिशयियभविष्यद्वादिना प्रोक्तं, तत् तदा सफलम् अभूत्। ");
INSERT INTO sandev_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","अनन्तरं यीशुः सुसंवादं प्रचारयन् एतां कथां कथयितुम् आरेभे, मनांसि परावर्त्तयत, स्वर्गीयराजत्वं सविधमभवत्। ");
INSERT INTO sandev_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ततः परं यीशु र्गालीलो जलधेस्तटेन गच्छन् गच्छन् आन्द्रियस्तस्य भ्राता शिमोन् अर्थतो यं पितरं वदन्ति एतावुभौ जलघौ जालं क्षिपन्तौ ददर्श, यतस्तौ मीनधारिणावास्ताम्। ");
INSERT INTO sandev_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","तदा स तावाहूय व्याजहार, युवां मम पश्चाद् आगच्छतं, युवामहं मनुजधारिणौ करिष्यामि। ");
INSERT INTO sandev_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","तेनैव तौ जालं विहाय तस्य पश्चात् आगच्छताम्। ");
INSERT INTO sandev_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","अनन्तरं तस्मात् स्थानात् व्रजन् व्रजन् सिवदियस्य सुतौ याकूब् योहन्नामानौ द्वौ सहजौ तातेन सार्द्धं नौकोपरि जालस्य जीर्णोद्धारं कुर्व्वन्तौ वीक्ष्य तावाहूतवान्। ");
INSERT INTO sandev_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","तत्क्षणात् तौ नावं स्वतातञ्च विहाय तस्य पश्चाद्गामिनौ बभूवतुः। ");
INSERT INTO sandev_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","अनन्तरं भजनभवने समुपदिशन् राज्यस्य सुसंवादं प्रचारयन् मनुजानां सर्व्वप्रकारान् रोगान् सर्व्वप्रकारपीडाश्च शमयन् यीशुः कृत्स्नं गालील्देशं भ्रमितुम् आरभत। ");
INSERT INTO sandev_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","तेन कृत्स्नसुरियादेशस्य मध्यं तस्य यशो व्याप्नोत्, अपरं भूतग्रस्ता अपस्मारर्गीणः पक्षाधातिप्रभृतयश्च यावन्तो मनुजा नानाविधव्याधिभिः क्लिष्टा आसन्, तेषु सर्व्वेषु तस्य समीपम् आनीतेषु स तान् स्वस्थान् चकार। ");
INSERT INTO sandev_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","एतेन गालील्-दिकापनि-यिरूशालम्-यिहूदीयदेशेभ्यो यर्द्दनः पाराञ्च बहवो मनुजास्तस्य पश्चाद् आगच्छन्। ");
INSERT INTO sandev_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","अनन्तरं स जननिवहं निरीक्ष्य भूधरोपरि व्रजित्वा समुपविवेश। ");
INSERT INTO sandev_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","तदानीं शिष्येषु तस्य समीपमागतेषु तेन तेभ्य एषा कथा कथ्याञ्चक्रे। ");
INSERT INTO sandev_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","अभिमानहीना जना धन्याः, यतस्ते स्वर्गीयराज्यम् अधिकरिष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","खिद्यमाना मनुजा धन्याः, यस्मात् ते सान्त्वनां प्राप्सन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","नम्रा मानवाश्च धन्याः, यस्मात् ते मेदिनीम् अधिकरिष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","धर्म्माय बुभुक्षिताः तृषार्त्ताश्च मनुजा धन्याः, यस्मात् ते परितर्प्स्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","कृपालवो मानवा धन्याः, यस्मात् ते कृपां प्राप्स्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","निर्म्मलहृदया मनुजाश्च धन्याः, यस्मात् त ईश्चरं द्रक्ष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","मेलयितारो मानवा धन्याः, यस्मात् त ईश्चरस्य सन्तानत्वेन विख्यास्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","धर्म्मकारणात् ताडिता मनुजा धन्या, यस्मात् स्वर्गीयराज्ये तेषामधिकरो विद्यते। ");
INSERT INTO sandev_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","यदा मनुजा मम नामकृते युष्मान् निन्दन्ति ताडयन्ति मृषा नानादुर्व्वाक्यानि वदन्ति च, तदा युयं धन्याः। ");
INSERT INTO sandev_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","तदा आनन्दत, तथा भृशं ह्लादध्वञ्च, यतः स्वर्गे भूयांसि फलानि लप्स्यध्वे; ते युष्माकं पुरातनान् भविष्यद्वादिनोऽपि तादृग् अताडयन्। ");
INSERT INTO sandev_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","युयं मेदिन्यां लवणरूपाः, किन्तु यदि लवणस्य लवणत्वम् अपयाति, तर्हि तत् केन प्रकारेण स्वादुयुक्तं भविष्यति? तत् कस्यापि कार्य्यस्यायोग्यत्वात् केवलं बहिः प्रक्षेप्तुं नराणां पदतलेन दलयितुञ्च योग्यं भवति। ");
INSERT INTO sandev_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","यूयं जगति दीप्तिरूपाः, भूधरोपरि स्थितं नगरं गुप्तं भवितुं नहि शक्ष्यति। ");
INSERT INTO sandev_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","अपरं मनुजाः प्रदीपान् प्रज्वाल्य द्रोणाधो न स्थापयन्ति, किन्तु दीपाधारोपर्य्येव स्थापयन्ति, तेन ते दीपा गेहस्थितान् सकलान् प्रकाशयन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","येन मानवा युष्माकं सत्कर्म्माणि विलोक्य युष्माकं स्वर्गस्थं पितरं धन्यं वदन्ति, तेषां समक्षं युष्माकं दीप्तिस्तादृक् प्रकाशताम्। ");
INSERT INTO sandev_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","अहं व्यवस्थां भविष्यद्वाक्यञ्च लोप्तुम् आगतवान्, इत्थं मानुभवत, ते द्वे लोप्तुं नागतवान्, किन्तु सफले कर्त्तुम् आगतोस्मि। ");
INSERT INTO sandev_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","अपरं युष्मान् अहं तथ्यं वदामि यावत् व्योममेदिन्यो र्ध्वंसो न भविष्यति, तावत् सर्व्वस्मिन् सफले न जाते व्यवस्थाया एका मात्रा बिन्दुरेकोपि वा न लोप्स्यते। ");
INSERT INTO sandev_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","तस्मात् यो जन एतासाम् आज्ञानाम् अतिक्षुद्राम् एकाज्ञामपी लंघते मनुजांञ्च तथैव शिक्षयति, स स्वर्गीयराज्ये सर्व्वेभ्यः क्षुद्रत्वेन विख्यास्यते, किन्तु यो जनस्तां पालयति, तथैव शिक्षयति च, स स्वर्गीयराज्ये प्रधानत्वेन विख्यास्यते। ");
INSERT INTO sandev_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","अपरं युष्मान् अहं वदामि, अध्यापकफिरूशिमानवानां धर्म्मानुष्ठानात् युष्माकं धर्म्मानुष्ठाने नोत्तमे जाते यूयम् ईश्वरीयराज्यं प्रवेष्टुं न शक्ष्यथ। ");
INSERT INTO sandev_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","अपरञ्च त्वं नरं मा वधीः, यस्मात् यो नरं हन्ति, स विचारसभायां दण्डार्हो भविष्यति, पूर्व्वकालीनजनेभ्य इति कथितमासीत्, युष्माभिरश्रावि। ");
INSERT INTO sandev_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","किन्त्वहं युष्मान् वदामि, यः कश्चित् कारणं विना निजभ्रात्रे कुप्यति, स विचारसभायां दण्डार्हो भविष्यति; यः कश्चिच्च स्वीयसहजं निर्ब्बोधं वदति, स महासभायां दण्डार्हो भविष्यति; पुनश्च त्वं मूढ इति वाक्यं यदि कश्चित् स्वीयभ्रातरं वक्ति, तर्हि नरकाग्नौ स दण्डार्हो भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","अतो वेद्याः समीपं निजनैवेद्ये समानीतेऽपि निजभ्रातरं प्रति कस्माच्चित् कारणात् त्वं यदि दोषी विद्यसे, तदानीं तव तस्य स्मृति र्जायते च, ");
INSERT INTO sandev_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","तर्हि तस्या वेद्याः समीपे निजनैवैद्यं निधाय तदैव गत्वा पूर्व्वं तेन सार्द्धं मिल, पश्चात् आगत्य निजनैवेद्यं निवेदय। ");
INSERT INTO sandev_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","अन्यञ्च यावत् विवादिना सार्द्धं वर्त्मनि तिष्ठसि, तावत् तेन सार्द्धं मेलनं कुरु; नो चेत् विवादी विचारयितुः समीपे त्वां समर्पयति विचारयिता च रक्षिणः सन्निधौ समर्पयति तदा त्वं कारायां बध्येथाः। ");
INSERT INTO sandev_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","तर्हि त्वामहं तथ्थं ब्रवीमि, शेषकपर्दकेऽपि न परिशोधिते तस्मात् स्थानात् कदापि बहिरागन्तुं न शक्ष्यसि। ");
INSERT INTO sandev_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","अपरं त्वं मा व्यभिचर, यदेतद् वचनं पूर्व्वकालीनलोकेभ्यः कथितमासीत्, तद् यूयं श्रुतवन्तः; ");
INSERT INTO sandev_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","किन्त्वहं युष्मान् वदामि, यदि कश्चित् कामतः काञ्चन योषितं पश्यति, तर्हि स मनसा तदैव व्यभिचरितवान्। ");
INSERT INTO sandev_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","तस्मात् तव दक्षिणं नेत्रं यदि त्वां बाधते, तर्हि तन्नेत्रम् उत्पाट्य दूरे निक्षिप, यस्मात् तव सर्व्ववपुषो नरके निक्षेपात् तवैकाङ्गस्य नाशो वरं। ");
INSERT INTO sandev_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","यद्वा तव दक्षिणः करो यदि त्वां बाधते, तर्हि तं करं छित्त्वा दूरे निक्षिप, यतः सर्व्ववपुषो नरके निक्षेपात् एकाङ्गस्य नाशो वरं। ");
INSERT INTO sandev_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","उक्तमास्ते, यदि कश्चिन् निजजायां परित्यक्त्तुम् इच्छति, तर्हि स तस्यै त्यागपत्रं ददातु। ");
INSERT INTO sandev_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","किन्त्वहं युष्मान् व्याहरामि, व्यभिचारदोषे न जाते यदि कश्चिन् निजजायां परित्यजति, तर्हि स तां व्यभिचारयति; यश्च तां त्यक्तां स्त्रियं विवहति, सोपि व्यभिचरति। ");
INSERT INTO sandev_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","पुनश्च त्वं मृषा शपथम् न कुर्व्वन् ईश्चराय निजशपथं पालय, पूर्व्वकालीनलोकेभ्यो यैषा कथा कथिता, तामपि यूयं श्रुतवन्तः। ");
INSERT INTO sandev_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","किन्त्वहं युष्मान् वदामि, कमपि शपथं मा कार्ष्ट, अर्थतः स्वर्गनाम्ना न, यतः स ईश्वरस्य सिंहासनं; ");
INSERT INTO sandev_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","पृथिव्या नाम्नापि न, यतः सा तस्य पादपीठं; यिरूशालमो नाम्नापि न, यतः सा महाराजस्य पुरी; ");
INSERT INTO sandev_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","निजशिरोनाम्नापि न, यस्मात् तस्यैकं कचमपि सितम् असितं वा कर्त्तुं त्वया न शक्यते। ");
INSERT INTO sandev_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","अपरं यूयं संलापसमये केवलं भवतीति न भवतीति च वदत यत इतोऽधिकं यत् तत् पापात्मनो जायते। ");
INSERT INTO sandev_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","अपरं लोचनस्य विनिमयेन लोचनं दन्तस्य विनिमयेन दन्तः पूर्व्वक्तमिदं वचनञ्च युष्माभिरश्रूयत। ");
INSERT INTO sandev_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","किन्त्वहं युष्मान् वदामि यूयं हिंसकं नरं मा व्याघातयत। किन्तु केनचित् तव दक्षिणकपोले चपेटाघाते कृते तं प्रति वामं कपोलञ्च व्याघोटय। ");
INSERT INTO sandev_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","अपरं केनचित् त्वया सार्ध्दं विवादं कृत्वा तव परिधेयवसने जिघृतिते तस्मायुत्तरीयवसनमपि देहि। ");
INSERT INTO sandev_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","यदि कश्चित् त्वां क्रोशमेकं नयनार्थं अन्यायतो धरति, तदा तेन सार्ध्दं क्रोशद्वयं याहि। ");
INSERT INTO sandev_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","यश्च मानवस्त्वां याचते, तस्मै देहि, यदि कश्चित् तुभ्यं धारयितुम् इच्छति, तर्हि तं प्रति परांमुखो मा भूः। ");
INSERT INTO sandev_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","निजसमीपवसिनि प्रेम कुरु, किन्तु शत्रुं प्रति द्वेषं कुरु, यदेतत् पुरोक्तं वचनं एतदपि यूयं श्रुतवन्तः। ");
INSERT INTO sandev_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","किन्त्वहं युष्मान् वदामि, यूयं रिपुव्वपि प्रेम कुरुत, ये च युष्मान् शपन्ते, तान, आशिषं वदत, ये च युष्मान् ऋृतीयन्ते, तेषां मङ्गलं कुरुत, ये च युष्मान् निन्दन्ति, ताडयन्ति च, तेषां कृते प्रार्थयध्वं। ");
INSERT INTO sandev_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","तत्र यः सतामसताञ्चोपरि प्रभाकरम् उदाययति, तथा धार्म्मिकानामधार्म्मिकानाञ्चोपरि नीरं वर्षयति तादृशो यो युष्माकं स्वर्गस्थः पिता, यूयं तस्यैव सन्ताना भविष्यथ। ");
INSERT INTO sandev_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ये युष्मासु प्रेम कुर्व्वन्ति, यूयं यदि केवलं तेव्वेव प्रेम कुरुथ, तर्हि युष्माकं किं फलं भविष्यति? चण्डाला अपि तादृशं किं न कुर्व्वन्ति? ");
INSERT INTO sandev_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","अपरं यूयं यदि केवलं स्वीयभ्रातृत्वेन नमत, तर्हि किं महत् कर्म्म कुरुथ? चण्डाला अपि तादृशं किं न कुर्व्वन्ति? ");
INSERT INTO sandev_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","तस्मात् युष्माकं स्वर्गस्थः पिता यथा पूर्णो भवति, यूयमपि तादृशा भवत। ");
INSERT INTO sandev_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","सावधाना भवत, मनुजान् दर्शयितुं तेषां गोचरे धर्म्मकर्म्म मा कुरुत, तथा कृते युष्माकं स्वर्गस्थपितुः सकाशात् किञ्चन फलं न प्राप्स्यथ। ");
INSERT INTO sandev_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","त्वं यदा ददासि तदा कपटिनो जना यथा मनुजेभ्यः प्रशंसां प्राप्तुं भजनभवने राजमार्गे च तूरीं वादयन्ति, तथा मा कुरिु, अहं तुभ्यं यथार्थं कथयामि, ते स्वकायं फलम् अलभन्त। ");
INSERT INTO sandev_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","किन्तु त्वं यदा ददासि, तदा निजदक्षिणकरो यत् करोति, तद् वामकरं मा ज्ञापय। ");
INSERT INTO sandev_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","तेन तव दानं गुप्तं भविष्यति यस्तु तव पिता गुप्तदर्शी, स प्रकाश्य तुभ्यं फलं दास्यति। ");
INSERT INTO sandev_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","अपरं यदा प्रार्थयसे, तदा कपटिनइव मा कुरु, यस्मात् ते भजनभवने राजमार्गस्य कोणे तिष्ठन्तो लोकान् दर्शयन्तः प्रार्थयितुं प्रीयन्ते; अहं युष्मान् तथ्यं वदामि, ते स्वकीयफलं प्राप्नुवन्। ");
INSERT INTO sandev_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","तस्मात् प्रार्थनाकाले अन्तरागारं प्रविश्य द्वारं रुद्व्वा गुप्तं पश्यतस्तव पितुः समीपे प्रार्थयस्व; तेन तव यः पिता गुप्तदर्शी, स प्रकाश्य तुभ्यं फलं दास्यतिl ");
INSERT INTO sandev_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","अपरं प्रार्थनाकाले देवपूजकाइव मुधा पुनरुक्तिं मा कुरु, यस्मात् ते बोधन्ते, बहुवारं कथायां कथितायां तेषां प्रार्थना ग्राहिष्यते। ");
INSERT INTO sandev_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","यूयं तेषामिव मा कुरुत, यस्मात् युष्माकं यद् यत् प्रयोजनं याचनातः प्रागेव युष्माकं पिता तत् जानाति। ");
INSERT INTO sandev_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","अतएव यूयम ईदृक् प्रार्थयध्वं, हे अस्माकं स्वर्गस्थपितः, तव नाम पूज्यं भवतु। ");
INSERT INTO sandev_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","तव राजत्वं भवतु; तवेच्छा स्वर्गे यथा तथैव मेदिन्यामपि सफला भवतु। ");
INSERT INTO sandev_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","अस्माकं प्रयोजनीयम् आहारम् अद्य देहि। ");
INSERT INTO sandev_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","वयं यथा निजापराधिनः क्षमामहे, तथैवास्माकम् अपराधान् क्षमस्व। ");
INSERT INTO sandev_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","अस्मान् परीक्षां मानय, किन्तु पापात्मनो रक्ष; राजत्वं गौरवं पराक्रमः एते सर्व्वे सर्व्वदा तव; तथास्तु। ");
INSERT INTO sandev_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","यदि यूयम् अन्येषाम् अपराधान् क्षमध्वे तर्हि युष्माकं स्वर्गस्थपितापि युष्मान् क्षमिष्यते; ");
INSERT INTO sandev_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","किन्तु यदि यूयम् अन्येषाम् अपराधान् न क्षमध्वे, तर्हि युष्माकं जनकोपि युष्माकम् अपराधान् न क्षमिष्यते। ");
INSERT INTO sandev_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","अपरम् उपवासकाले कपटिनो जना मानुषान् उपवासं ज्ञापयितुं स्वेषां वदनानि म्लानानि कुर्व्वन्ति, यूयं तइव विषणवदना मा भवत; अहं युष्मान् तथ्यं वदामि ते स्वकीयफलम् अलभन्त। ");
INSERT INTO sandev_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","यदा त्वम् उपवससि, तदा यथा लोकैस्त्वं उपवासीव न दृश्यसे, किन्तु तव योऽगोचरः पिता तेनैव दृश्यसे, तत्कृते निजशिरसि तैलं मर्द्दय वदनञ्च प्रक्षालय; ");
INSERT INTO sandev_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","तेन तव यः पिता गुप्तदर्शी स प्रकाश्य तुभ्यं फलं दास्यति। ");
INSERT INTO sandev_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","अपरं यत्र स्थाने कीटाः कलङ्काश्च क्षयं नयन्ति, चौराश्च सन्धिं कर्त्तयित्वा चोरयितुं शक्नुवन्ति, तादृश्यां मेदिन्यां स्वार्थं धनं मा संचिनुत। ");
INSERT INTO sandev_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","किन्तु यत्र स्थाने कीटाः कलङ्काश्च क्षयं न नयन्ति, चौराश्च सन्धिं कर्त्तयित्वा चोरयितुं न शक्नुवन्ति, तादृशे स्वर्गे धनं सञ्चिनुत। ");
INSERT INTO sandev_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","यस्मात् यत्र स्थाने युष्मांक धनं तत्रैव खाने युष्माकं मनांसि। ");
INSERT INTO sandev_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","लोचनं देहस्य प्रदीपकं, तस्मात् यदि तव लोचनं प्रसन्नं भवति, तर्हि तव कृत्स्नं वपु र्दीप्तियुक्तं भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","किन्तु लोचनेऽप्रसन्ने तव कृत्स्नं वपुः तमिस्रयुक्तं भविष्यति। अतएव या दीप्तिस्त्वयि विद्यते, सा यदि तमिस्रयुक्ता भवति, तर्हि तत् तमिस्रं कियन् महत्। ");
INSERT INTO sandev_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","कोपि मनुजो द्वौ प्रभू सेवितुं न शक्नोति, यस्माद् एकं संमन्य तदन्यं न सम्मन्यते, यद्वा एकत्र मनो निधाय तदन्यम् अवमन्यते; तथा यूयमपीश्वरं लक्ष्मीञ्चेत्युभे सेवितुं न शक्नुथ। ");
INSERT INTO sandev_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","अपरम् अहं युष्मभ्यं तथ्यं कथयामि, किं भक्षिष्यामः? किं पास्यामः? इति प्राणधारणाय मा चिन्तयत; किं परिधास्यामः? इति कायरक्षणाय न चिन्तयत; भक्ष्यात् प्राणा वसनाञ्च वपूंषि किं श्रेष्ठाणि न हि? ");
INSERT INTO sandev_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","विहायसो विहङ्गमान् विलोकयत; तै र्नोप्यते न कृत्यते भाण्डागारे न सञ्चीयतेऽपि; तथापि युष्माकं स्वर्गस्थः पिता तेभ्य आहारं वितरति। ");
INSERT INTO sandev_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","यूयं तेभ्यः किं श्रेष्ठा न भवथ? युष्माकं कश्चित् मनुजः चिन्तयन् निजायुषः क्षणमपि वर्द्धयितुं शक्नोति? ");
INSERT INTO sandev_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","अपरं वसनाय कुतश्चिन्तयत? क्षेत्रोत्पन्नानि पुष्पाणि कथं वर्द्धन्ते तदालोचयत। तानि तन्तून् नोत्पादयन्ति किमपि कार्य्यं न कुर्व्वन्ति; ");
INSERT INTO sandev_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","तथाप्यहं युष्मान् वदामि, सुलेमान् तादृग् ऐश्वर्य्यवानपि तत्पुष्पमिव विभूषितो नासीत्। ");
INSERT INTO sandev_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","तस्मात् क्षद्य विद्यमानं श्चः चुल्ल्यां निक्षेप्स्यते तादृशं यत् क्षेत्रस्थितं कुसुमं तत् यदीश्चर इत्थं बिभूषयति, तर्हि हे स्तोकप्रत्ययिनो युष्मान् किं न परिधापयिष्यति? ");
INSERT INTO sandev_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","तस्मात् अस्माभिः किमत्स्यते? किञ्च पायिष्यते? किं वा परिधायिष्यते, इति न चिन्तयत। ");
INSERT INTO sandev_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","यस्मात् देवार्च्चका अपीति चेष्टन्ते; एतेषु द्रव्येषु प्रयोजनमस्तीति युष्माकं स्वर्गस्थः पिता जानाति। ");
INSERT INTO sandev_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","अतएव प्रथमत ईश्वरीयराज्यं धर्म्मञ्च चेष्टध्वं, तत एतानि वस्तूनि युष्मभ्यं प्रदायिष्यन्ते। ");
INSERT INTO sandev_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","श्वः कृते मा चिन्तयत, श्वएव स्वयं स्वमुद्दिश्य चिन्तयिष्यति; अद्यतनी या चिन्ता साद्यकृते प्रचुरतरा। ");
INSERT INTO sandev_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","यथा यूयं दोषीकृता न भवथ, तत्कृतेऽन्यं दोषिणं मा कुरुत। ");
INSERT INTO sandev_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","यतो यादृशेन दोषेण यूयं परान् दोषिणः कुरुथ, तादृशेन दोषेण यूयमपि दोषीकृता भविष्यथ, अन्यञ्च येन परिमाणेन युष्माभिः परिमीयते, तेनैव परिमाणेन युष्मत्कृते परिमायिष्यते। ");
INSERT INTO sandev_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","अपरञ्च निजनयने या नासा विद्यते, ताम् अनालोच्य तव सहजस्य लोचने यत् तृणम् आस्ते, तदेव कुतो वीक्षसे? ");
INSERT INTO sandev_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","तव निजलोचने नासायां विद्यमानायां, हे भ्रातः, तव नयनात् तृणं बहिष्यर्तुं अनुजानीहि, कथामेतां निजसहजाय कथं कथयितुं शक्नोषि? ");
INSERT INTO sandev_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","हे कपटिन्, आदौ निजनयनात् नासां बहिष्कुरु ततो निजदृष्टौ सुप्रसन्नायां तव भ्रातृ र्लोचनात् तृणं बहिष्कर्तुं शक्ष्यसि। ");
INSERT INTO sandev_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","अन्यञ्च सारमेयेभ्यः पवित्रवस्तूनि मा वितरत, वराहाणां समक्षञ्च मुक्ता मा निक्षिपत; निक्षेपणात् ते ताः सर्व्वाः पदै र्दलयिष्यन्ति, परावृत्य युष्मानपि विदारयिष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","याचध्वं ततो युष्मभ्यं दायिष्यते; मृगयध्वं तत उद्देशं लप्स्यध्वे; द्वारम् आहत, ततो युष्मत्कृते मुक्तं भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","यस्माद् येन याच्यते, तेन लभ्यते; येन मृग्यते तेनोद्देशः प्राप्यते; येन च द्वारम् आहन्यते, तत्कृते द्वारं मोच्यते। ");
INSERT INTO sandev_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","आत्मजेन पूपे प्रार्थिते तस्मै पाषाणं विश्राणयति, ");
INSERT INTO sandev_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","मीने याचिते च तस्मै भुजगं वितरति, एतादृशः पिता युष्माकं मध्ये क आस्ते? ");
INSERT INTO sandev_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","तस्माद् यूयम् अभद्राः सन्तोऽपि यदि निजबालकेभ्य उत्तमं द्रव्यं दातुं जानीथ, तर्हि युष्माकं स्वर्गस्थः पिता स्वीययाचकेभ्यः किमुत्तमानि वस्तूनि न दास्यति? ");
INSERT INTO sandev_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","यूष्मान् प्रतीतरेषां यादृशो व्यवहारो युष्माकं प्रियः, यूयं तान् प्रति तादृशानेव व्यवहारान् विधत्त; यस्माद् व्यवस्थाभविष्यद्वादिनां वचनानाम् इति सारम्। ");
INSERT INTO sandev_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","सङ्कीर्णद्वारेण प्रविशत; यतो नरकगमनाय यद् द्वारं तद् विस्तीर्णं यच्च वर्त्म तद् बृहत् तेन बहवः प्रविशन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","अपरं स्वर्गगमनाय यद् द्वारं तत् कीदृक् संकीर्णं। यच्च वर्त्म तत् कीदृग् दुर्गमम्। तदुद्देष्टारः कियन्तोऽल्पाः। ");
INSERT INTO sandev_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","अपरञ्च ये जना मेषवेशेन युष्माकं समीपम् आगच्छन्ति, किन्त्वन्तर्दुरन्ता वृका एतादृशेभ्यो भविष्यद्वादिभ्यः सावधाना भवत, यूयं फलेन तान् परिचेतुं शक्नुथ। ");
INSERT INTO sandev_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","मनुजाः किं कण्टकिनो वृक्षाद् द्राक्षाफलानि शृगालकोलितश्च उडुम्बरफलानि शातयन्ति? ");
INSERT INTO sandev_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","तद्वद् उत्तम एव पादप उत्तमफलानि जनयति, अधमपादपएवाधमफलानि जनयति। ");
INSERT INTO sandev_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","किन्तूत्तमपादपः कदाप्यधमफलानि जनयितुं न शक्नोति, तथाधमोपि पादप उत्तमफलानि जनयितुं न शक्नोति। ");
INSERT INTO sandev_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","अपरं ये ये पादपा अधमफलानि जनयन्ति, ते कृत्ता वह्नौ क्षिप्यन्ते। ");
INSERT INTO sandev_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","अतएव यूयं फलेन तान् परिचेष्यथ। ");
INSERT INTO sandev_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","ये जना मां प्रभुं वदन्ति, ते सर्व्वे स्वर्गराज्यं प्रवेक्ष्यन्ति तन्न, किन्तु यो मानवो मम स्वर्गस्थस्य पितुरिष्टं कर्म्म करोति स एव प्रवेक्ष्यति। ");
INSERT INTO sandev_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","तद् दिने बहवो मां वदिष्यन्ति, हे प्रभो हे प्रभो, तव नाम्ना किमस्मामि र्भविष्यद्वाक्यं न व्याहृतं? तव नाम्ना भूताः किं न त्याजिताः? तव नाम्ना किं नानाद्भुतानि कर्म्माणि न कृतानि? ");
INSERT INTO sandev_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","तदाहं वदिष्यामि, हे कुकर्म्मकारिणो युष्मान् अहं न वेद्मि, यूयं मत्समीपाद् दूरीभवत। ");
INSERT INTO sandev_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","यः कश्चित् ममैताः कथाः श्रुत्वा पालयति, स पाषाणोपरि गृहनिर्म्मात्रा ज्ञानिना सह मयोपमीयते। ");
INSERT INTO sandev_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","यतो वृष्टौ सत्याम् आप्लाव आगते वायौ वाते च तेषु तद्गेहं लग्नेषु पाषाणोपरि तस्य भित्तेस्तन्न पततिl ");
INSERT INTO sandev_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","किन्तु यः कश्चित् ममैताः कथाः श्रुत्वा न पालयति स सैकते गेहनिर्म्मात्रा ऽज्ञानिना उपमीयते। ");
INSERT INTO sandev_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","यतो जलवृष्टौ सत्याम् आप्लाव आगते पवने वाते च तै र्गृहे समाघाते तत् पतति तत्पतनं महद् भवति। ");
INSERT INTO sandev_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","यीशुनैतेषु वाक्येषु समापितेषु मानवास्तदीयोपदेशम् आश्चर्य्यं मेनिरे। ");
INSERT INTO sandev_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","यस्मात् स उपाध्याया इव तान् नोपदिदेश किन्तु समर्थपुरुषइव समुपदिदेश। ");
INSERT INTO sandev_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","यदा स पर्व्वताद् अवारोहत् तदा बहवो मानवास्तत्पश्चाद् वव्रजुः। ");
INSERT INTO sandev_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","एकः कुष्ठवान् आगत्य तं प्रणम्य बभाषे, हे प्रभो, यदि भवान् संमन्यते, तर्हि मां निरामयं कर्त्तुं शक्नोति। ");
INSERT INTO sandev_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ततो यीशुः करं प्रसार्य्य तस्याङ्गं स्पृशन् व्याजहार, सम्मन्येऽहं त्वं निरामयो भव; तेन स तत्क्षणात् कुष्ठेनामोचि। ");
INSERT INTO sandev_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ततो यीशुस्तं जगाद, अवधेहि कथामेतां कश्चिदपि मा ब्रूहि, किन्तु याजकस्य सन्निधिं गत्वा स्वात्मानं दर्शय मनुजेभ्यो निजनिरामयत्वं प्रमाणयितुं मूसानिरूपितं द्रव्यम् उत्सृज च। ");
INSERT INTO sandev_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","तदनन्तरं यीशुना कफर्नाहूम्नामनि नगरे प्रविष्टे कश्चित् शतसेनापतिस्तत्समीपम् आगत्य विनीय बभाषे, ");
INSERT INTO sandev_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","हे प्रभो, मदीय एको दासः पक्षाघातव्याधिना भृशं व्यथितः, सतु शयनीय आस्ते। ");
INSERT INTO sandev_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","तदानीं यीशुस्तस्मै कथितवान्, अहं गत्वा तं निरामयं करिष्यामि। ");
INSERT INTO sandev_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ततः स शतसेनापतिः प्रत्यवदत्, हे प्रभो, भवान् यत् मम गेहमध्यं याति तद्योग्यभाजनं नाहमस्मि; वाङ्मात्रम् आदिशतु, तेनैव मम दासो निरामयो भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","यतो मयि परनिध्नेऽपि मम निदेशवश्याः कति कति सेनाः सन्ति, तत एकस्मिन् याहीत्युक्ते स याति, तदन्यस्मिन् एहीत्युक्ते स आयाति, तथा मम निजदासे कर्म्मैतत् कुर्व्वित्युक्ते स तत् करोति। ");
INSERT INTO sandev_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","तदानीं यीशुस्तस्यैतत् वचो निशम्य विस्मयापन्नोऽभूत्; निजपश्चाद्गामिनो मानवान् अवोच्च, युष्मान् तथ्यं वच्मि, इस्रायेलीयलोकानां मध्येऽपि नैतादृशो विश्वासो मया प्राप्तः। ");
INSERT INTO sandev_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","अन्यच्चाहं युष्मान् वदामि, बहवः पूर्व्वस्याः पश्चिमायाश्च दिश आगत्य इब्राहीमा इस्हाका याकूबा च साकम् मिलित्वा समुपवेक्ष्यन्ति; ");
INSERT INTO sandev_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","किन्तु यत्र स्थाने रोदनदन्तघर्षणे भवतस्तस्मिन् बहिर्भूततमिस्रे राज्यस्य सन्ताना निक्षेस्यन्ते। ");
INSERT INTO sandev_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","ततः परं यीशुस्तं शतसेनापतिं जगाद, याहि, तव प्रतीत्यनुसारतो मङ्गलं भूयात्; तदा तस्मिन्नेव दण्डे तदीयदासो निरामयो बभूव। ");
INSERT INTO sandev_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","अनन्तरं यीशुः पितरस्य गेहमुपस्थाय ज्वरेण पीडितां शयनीयस्थितां तस्य श्वश्रूं वीक्षाञ्चक्रे। ");
INSERT INTO sandev_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ततस्तेन तस्याः करस्य स्पृष्टतवात् ज्वरस्तां तत्याज, तदा सा समुत्थाय तान् सिषेवे। ");
INSERT INTO sandev_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","अनन्तरं सन्ध्यायां सत्यां बहुशो भूतग्रस्तमनुजान् तस्य समीपम् आनिन्युः स च वाक्येन भूतान् त्याजयामास, सर्व्वप्रकारपीडितजनांश्च निरामयान् चकार; ");
INSERT INTO sandev_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","तस्मात्, सर्व्वा दुर्ब्बलतास्माकं तेनैव परिधारिता। अस्माकं सकलं व्याधिं सएव संगृहीतवान्। यदेतद्वचनं यिशयियभविष्यद्वादिनोक्तमासीत्, तत्तदा सफलमभवत्। ");
INSERT INTO sandev_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","अनन्तरं यीशुश्चतुर्दिक्षु जननिवहं विलोक्य तटिन्याः पारं यातुं शिष्यान् आदिदेश। ");
INSERT INTO sandev_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","तदानीम् एक उपाध्याय आगत्य कथितवान्, हे गुरो, भवान् यत्र यास्यति तत्राहमपि भवतः पश्चाद् यास्यामि। ");
INSERT INTO sandev_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ततो यीशु र्जगाद, क्रोष्टुः स्थातुं स्थानं विद्यते, विहायसो विहङ्गमानां नीडानि च सन्ति; किन्तु मनुष्यपुत्रस्य शिरः स्थापयितुं स्थानं न विद्यते। ");
INSERT INTO sandev_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","अनन्तरम् अपर एकः शिष्यस्तं बभाषे, हे प्रभो, प्रथमतो मम पितरं श्मशाने निधातुं गमनार्थं माम् अनुमन्यस्व। ");
INSERT INTO sandev_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ततो यीशुरुक्तवान् मृता मृतान् श्मशाने निदधतु, त्वं मम पश्चाद् आगच्छ। ");
INSERT INTO sandev_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","अनन्तरं तस्मिन् नावमारूढे तस्य शिष्यास्तत्पश्चात् जग्मुः। ");
INSERT INTO sandev_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","पश्चात् सागरस्य मध्यं तेषु गतेषु तादृशः प्रबलो झञ्भ्शनिल उदतिष्ठत्, येन महातरङ्ग उत्थाय तरणिं छादितवान्, किन्तु स निद्रित आसीत्। ");
INSERT INTO sandev_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","तदा शिष्या आगत्य तस्य निद्राभङ्गं कृत्वा कथयामासुः, हे प्रभो, वयं म्रियामहे, भवान् अस्माकं प्राणान् रक्षतु। ");
INSERT INTO sandev_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","तदा स तान् उक्तवान्, हे अल्पविश्वासिनो यूयं कुतो विभीथ? ततः स उत्थाय वातं सागरञ्च तर्जयामास, ततो निर्व्वातमभवत्। ");
INSERT INTO sandev_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","अपरं मनुजा विस्मयं विलोक्य कथयामासुः, अहो वातसरित्पती अस्य किमाज्ञाग्राहिणौ? कीदृशोऽयं मानवः। ");
INSERT INTO sandev_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","अनन्तरं स पारं गत्वा गिदेरीयदेशम् उपस्थितवान्; तदा द्वौ भूतग्रस्तमनुजौ श्मशानस्थानाद् बहि र्भूत्वा तं साक्षात् कृतवन्तौ, तावेतादृशौ प्रचण्डावास्तां यत् तेन स्थानेन कोपि यातुं नाशक्नोत्। ");
INSERT INTO sandev_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","तावुचैः कथयामासतुः, हे ईश्वरस्य सूनो यीशो, त्वया साकम् आवयोः कः सम्बन्धः? निरूपितकालात् प्रागेव किमावाभ्यां यातनां दातुम् अत्रागतोसि? ");
INSERT INTO sandev_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","तदानीं ताभ्यां किञ्चिद् दूरे वराहाणाम् एको महाव्रजोऽचरत्। ");
INSERT INTO sandev_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ततो भूतौ तौ तस्यान्तिके विनीय कथयामासतुः, यद्यावां त्याजयसि, तर्हि वराहाणां मध्येव्रजम् आवां प्रेरय। ");
INSERT INTO sandev_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","तदा यीशुरवदत् यातं, अनन्तरं तौ यदा मनुजौ विहाय वराहान् आश्रितवन्तौ, तदा ते सर्व्वे वराहा उच्चस्थानात् महाजवेन धावन्तः सागरीयतोये मज्जन्तो मम्रुः। ");
INSERT INTO sandev_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ततो वराहरक्षकाः पलायमाना मध्येनगरं तौ भूतग्रस्तौ प्रति यद्यद् अघटत, ताः सर्व्ववार्त्ता अवदन्। ");
INSERT INTO sandev_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ततो नागरिकाः सर्व्वे मनुजा यीशुं साक्षात् कर्त्तुं बहिरायाताः तञ्च विलोक्य प्रार्थयाञ्चक्रिरे भवान् अस्माकं सीमातो यातु। ");
INSERT INTO sandev_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","अनन्तरं यीशु र्नौकामारुह्य पुनः पारमागत्य निजग्रामम् आययौ। ");
INSERT INTO sandev_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ततः कतिपया जना एकं पक्षाघातिनं स्वट्टोपरि शाययित्वा तत्समीपम् आनयन्; ततो यीशुस्तेषां प्रतीतिं विज्ञाय तं पक्षाघातिनं जगाद, हे पुत्र, सुस्थिरो भव, तव कलुषस्य मर्षणं जातम्। ");
INSERT INTO sandev_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","तां कथां निशम्य कियन्त उपाध्याया मनःसु चिन्तितवन्त एष मनुज ईश्वरं निन्दति। ");
INSERT INTO sandev_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ततः स तेषाम् एतादृशीं चिन्तां विज्ञाय कथितवान्, यूयं मनःसु कृत एतादृशीं कुचिन्तां कुरुथ? ");
INSERT INTO sandev_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","तव पापमर्षणं जातं, यद्वा त्वमुत्थाय गच्छ, द्वयोरनयो र्वाक्ययोः किं वाक्यं वक्तुं सुगमं? ");
INSERT INTO sandev_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","किन्तु मेदिन्यां कलुषं क्षमितुं मनुजसुतस्य सामर्थ्यमस्तीति यूयं यथा जानीथ, तदर्थं स तं पक्षाघातिनं गदितवान्, उत्तिष्ठ, निजशयनीयं आदाय गेहं गच्छ। ");
INSERT INTO sandev_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ततः स तत्क्षणाद् उत्थाय निजगेहं प्रस्थितवान्। ");
INSERT INTO sandev_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","मानवा इत्थं विलोक्य विस्मयं मेनिरे, ईश्वरेण मानवाय सामर्थ्यम् ईदृशं दत्तं इति कारणात् तं धन्यं बभाषिरे च। ");
INSERT INTO sandev_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","अनन्तरं यीशुस्तत्स्थानाद् गच्छन् गच्छन् करसंग्रहस्थाने समुपविष्टं मथिनामानम् एकं मनुजं विलोक्य तं बभाषे, मम पश्चाद् आगच्छ, ततः स उत्थाय तस्य पश्चाद् वव्राज। ");
INSERT INTO sandev_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ततः परं यीशौ गृहे भोक्तुम् उपविष्टे बहवः करसंग्राहिणः कलुषिणश्च मानवा आगत्य तेन साकं तस्य शिष्यैश्च साकम् उपविविशुः। ");
INSERT INTO sandev_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","फिरूशिनस्तद् दृष्ट्वा तस्य शिष्यान् बभाषिरे, युष्माकं गुरुः किं निमित्तं करसंग्राहिभिः कलुषिभिश्च साकं भुंक्ते? ");
INSERT INTO sandev_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","यीशुस्तत् श्रुत्वा तान् प्रत्यवदत्, निरामयलोकानां चिकित्सकेन प्रयोजनं नास्ति, किन्तु सामयलोकानां प्रयोजनमास्ते। ");
INSERT INTO sandev_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","अतो यूयं यात्वा वचनस्यास्यार्थं शिक्षध्वम्, दयायां मे यथा प्रीति र्न तथा यज्ञकर्म्मणि।यतोऽहं धार्म्मिकान् आह्वातुं नागतोऽस्मि किन्तु मनः परिवर्त्तयितुं पापिन आह्वातुम् आगतोऽस्मि। ");
INSERT INTO sandev_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","अनन्तरं योहनः शिष्यास्तस्य समीपम् आगत्य कथयामासुः, फिरूशिनो वयञ्च पुनः पुनरुपवसामः, किन्तु तव शिष्या नोपवसन्ति, कुतः? ");
INSERT INTO sandev_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","तदा यीशुस्तान् अवोचत् यावत् सखीनां संङ्गे कन्याया वरस्तिष्ठति, तावत् किं ते विलापं कर्त्तुं शक्लुवन्ति? किन्तु यदा तेषां संङ्गाद् वरं नयन्ति, तादृशः समय आगमिष्यति, तदा ते उपवत्स्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","पुरातनवसने कोपि नवीनवस्त्रं न योजयति, यस्मात् तेन योजितेन पुरातनवसनं छिनत्ति तच्छिद्रञ्च बहुकुत्सितं दृश्यते। ");
INSERT INTO sandev_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","अन्यञ्च पुरातनकुत्वां कोपि नवानगोस्तनीरसं न निदधाति, यस्मात् तथा कृते कुतू र्विदीर्य्यते तेन गोस्तनीरसः पतति कुतूश्च नश्यति; तस्मात् नवीनायां कुत्वां नवीनो गोस्तनीरसः स्थाप्यते, तेन द्वयोरवनं भवति। ");
INSERT INTO sandev_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","अपरं तेनैतत्कथाकथनकाले एकोऽधिपतिस्तं प्रणम्य बभाषे, मम दुहिता प्रायेणैतावत्काले मृता, तस्माद् भवानागत्य तस्या गात्रे हस्तमर्पयतु, तेन सा जीविष्यति। ");
INSERT INTO sandev_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","तदानीं यीशुः शिष्यैः साकम् उत्थाय तस्य पश्चाद् वव्राज। ");
INSERT INTO sandev_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","इत्यनन्तरे द्वादशवत्सरान् यावत् प्रदरामयेन शीर्णैका नारी तस्य पश्चाद् आगत्य तस्य वसनस्य ग्रन्थिं पस्पर्श; ");
INSERT INTO sandev_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","यस्मात् मया केवलं तस्य वसनं स्पृष्ट्वा स्वास्थ्यं प्राप्स्यते, सा नारीति मनसि निश्चितवती। ");
INSERT INTO sandev_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ततो यीशुर्वदनं परावर्त्त्य तां जगाद, हे कन्ये, त्वं सुस्थिरा भव, तव विश्वासस्त्वां स्वस्थामकार्षीत्। एतद्वाक्ये गदितएव सा योषित् स्वस्थाभूत्। ");
INSERT INTO sandev_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","अपरं यीशुस्तस्याध्यक्षस्य गेहं गत्वा वादकप्रभृतीन् बहून् लोकान् शब्दायमानान् विलोक्य तान् अवदत्, ");
INSERT INTO sandev_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","पन्थानं त्यज, कन्येयं नाम्रियत निद्रितास्ते; कथामेतां श्रुत्वा ते तमुपजहसुः। ");
INSERT INTO sandev_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","किन्तु सर्व्वेषु बहिष्कृतेषु सोऽभ्यन्तरं गत्वा कन्यायाः करं धृतवान्, तेन सोदतिष्ठत्; ");
INSERT INTO sandev_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ततस्तत्कर्म्मणो यशः कृत्स्नं तं देशं व्याप्तवत्। ");
INSERT INTO sandev_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","ततः परं यीशुस्तस्मात् स्थानाद् यात्रां चकार; तदा हे दायूदः सन्तान, अस्मान् दयस्व, इति वदन्तौ द्वौ जनावन्धौ प्रोचैराहूयन्तौ तत्पश्चाद् वव्रजतुः। ");
INSERT INTO sandev_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ततो यीशौ गेहमध्यं प्रविष्टं तावपि तस्य समीपम् उपस्थितवन्तौ, तदानीं स तौ पृष्टवान् कर्म्मैतत् कर्त्तुं मम सामर्थ्यम् आस्ते, युवां किमिति प्रतीथः? तदा तौ प्रत्यूचतुः, सत्यं प्रभो। ");
INSERT INTO sandev_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","तदानीं स तयो र्लोचनानि स्पृशन् बभाषे, युवयोः प्रतीत्यनुसाराद् युवयो र्मङ्गलं भूयात्। तेन तत्क्षणात् तयो र्नेत्राणि प्रसन्नान्यभवन्, ");
INSERT INTO sandev_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","पश्चाद् यीशुस्तौ दृढमाज्ञाप्य जगाद, अवधत्तम् एतां कथां कोपि मनुजो म जानीयात्। ");
INSERT INTO sandev_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","किन्तु तौ प्रस्थाय तस्मिन् कृत्स्ने देशे तस्य कीर्त्तिं प्रकाशयामासतुः। ");
INSERT INTO sandev_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","अपरं तौ बहिर्यात एतस्मिन्नन्तरे मनुजा एकं भूतग्रस्तमूकं तस्य समीपम् आनीतवन्तः। ");
INSERT INTO sandev_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","तेन भूते त्याजिते स मूकः कथां कथयितुं प्रारभत, तेन जना विस्मयं विज्ञाय कथयामासुः, इस्रायेलो वंशे कदापि नेदृगदृश्यत; ");
INSERT INTO sandev_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","किन्तु फिरूशिनः कथयाञ्चक्रुः भूताधिपतिना स भूतान् त्याजयति। ");
INSERT INTO sandev_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ततः परं यीशुस्तेषां भजनभवन उपदिशन् राज्यस्य सुसंवादं प्रचारयन् लोकानां यस्य य आमयो या च पीडासीत्, तान् शमयन् शमयंश्च सर्व्वाणि नगराणि ग्रामांश्च बभ्राम। ");
INSERT INTO sandev_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","अन्यञ्च मनुजान् व्याकुलान् अरक्षकमेषानिव च त्यक्तान् निरीक्ष्य तेषु कारुणिकः सन् शिष्यान् अवदत्, ");
INSERT INTO sandev_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","शस्यानि प्रचुराणि सन्ति, किन्तु छेत्तारः स्तोकाः। ");
INSERT INTO sandev_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","क्षेत्रं प्रत्यपरान् छेदकान् प्रहेतुं शस्यस्वामिनं प्रार्थयध्वम्। ");
INSERT INTO sandev_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","अनन्तरं यीशु र्द्वादशशिष्यान् आहूयामेध्यभूतान् त्याजयितुं सर्व्वप्रकाररोगान् पीडाश्च शमयितुं तेभ्यः सामर्थ्यमदात्। ");
INSERT INTO sandev_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","तेषां द्वादशप्रेष्याणां नामान्येतानि। प्रथमं शिमोन् यं पितरं वदन्ति, ततः परं तस्य सहज आन्द्रियः, सिवदियस्य पुत्रो याकूब् ");
INSERT INTO sandev_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","तस्य सहजो योहन्; फिलिप् बर्थलमय् थोमाः करसंग्राही मथिः, आल्फेयपुत्रो याकूब्, ");
INSERT INTO sandev_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","किनानीयः शिमोन्, य ईष्करियोतीययिहूदाः ख्रीष्टं परकरेऽर्पयत्। ");
INSERT INTO sandev_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","एतान् द्वादशशिष्यान् यीशुः प्रेषयन् इत्याज्ञापयत्, यूयम् अन्यदेशीयानां पदवीं शेमिरोणीयानां किमपि नगरञ्च न प्रविश्ये ");
INSERT INTO sandev_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","इस्रायेल्गोत्रस्य हारिता ये ये मेषास्तेषामेव समीपं यात। ");
INSERT INTO sandev_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","गत्वा गत्वा स्वर्गस्य राजत्वं सविधमभवत्, एतां कथां प्रचारयत। ");
INSERT INTO sandev_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","आमयग्रस्तान् स्वस्थान् कुरुत, कुष्ठिनः परिष्कुरुत, मृतलोकान् जीवयत, भूतान् त्याजयत, विना मूल्यं यूयम् अलभध्वं विनैव मूल्यं विश्राणयत। ");
INSERT INTO sandev_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","किन्तु स्वेषां कटिबन्धेषु स्वर्णरूप्यताम्राणां किमपि न गृह्लीत। ");
INSERT INTO sandev_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","अन्यच्च यात्रायै चेलसम्पुटं वा द्वितीयवसनं वा पादुके वा यष्टिः, एतान् मा गृह्लीत, यतः कार्य्यकृत् भर्त्तुं योग्यो भवति। ");
INSERT INTO sandev_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","अपरं यूयं यत् पुरं यञ्च ग्रामं प्रविशथ, तत्र यो जनो योग्यपात्रं तमवगत्य यानकालं यावत् तत्र तिष्ठत। ");
INSERT INTO sandev_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","यदा यूयं तद्गेहं प्रविशथ, तदा तमाशिषं वदत। ");
INSERT INTO sandev_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","यदि स योग्यपात्रं भवति, तर्हि तत्कल्याणं तस्मै भविष्यति, नोचेत् साशीर्युष्मभ्यमेव भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","किन्तु ये जना युष्माकमातिथ्यं न विदधति युष्माकं कथाञ्च न शृण्वन्ति तेषां गेहात् पुराद्वा प्रस्थानकाले स्वपदूलीः पातयत। ");
INSERT INTO sandev_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","युष्मानहं तथ्यं वच्मि विचारदिने तत्पुरस्य दशातः सिदोममोरापुरयोर्दशा सह्यतरा भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","पश्यत, वृकयूथमध्ये मेषः यथाविस्तथा युष्मान प्रहिणोमि, तस्माद् यूयम् अहिरिव सतर्काः कपोताइवाहिंसका भवत। ");
INSERT INTO sandev_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","नृभ्यः सावधाना भवत; यतस्तै र्यूयं राजसंसदि समर्पिष्यध्वे तेषां भजनगेहे प्रहारिष्यध्वे। ");
INSERT INTO sandev_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","यूयं मन्नामहेतोः शास्तृणां राज्ञाञ्च समक्षं तानन्यदेशिनश्चाधि साक्षित्वार्थमानेष्यध्वे। ");
INSERT INTO sandev_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","किन्त्वित्थं समर्पिता यूयं कथं किमुत्तरं वक्ष्यथ तत्र मा चिन्तयत, यतस्तदा युष्माभि र्यद् वक्तव्यं तत् तद्दण्डे युष्मन्मनः सु समुपस्थास्यति। ");
INSERT INTO sandev_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","यस्मात् तदा यो वक्ष्यति स न यूयं किन्तु युष्माकमन्तरस्थः पित्रात्मा। ");
INSERT INTO sandev_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","सहजः सहजं तातः सुतञ्च मृतौ समर्पयिष्यति, अपत्यागि स्वस्वपित्रोे र्विपक्षीभूय तौ घातयिष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","मन्नमहेतोः सर्व्वे जना युष्मान् ऋृतीयिष्यन्ते, किन्तु यः शेषं यावद् धैर्य्यं घृत्वा स्थास्यति, स त्रायिष्यते। ");
INSERT INTO sandev_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","तै र्यदा यूयमेकपुरे ताडिष्यध्वे, तदा यूयमन्यपुरं पलायध्वं युष्मानहं तथ्यं वच्मि यावन्मनुजसुतो नैति तावद् इस्रायेल्देशीयसर्व्वनगरभ्रमणं समापयितुं न शक्ष्यथ। ");
INSERT INTO sandev_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","गुरोः शिष्यो न महान्, प्रभोर्दासो न महान्। ");
INSERT INTO sandev_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","यदि शिष्यो निजगुरो र्दासश्च स्वप्रभोः समानो भवति तर्हि तद् यथेष्टं। चेत्तैर्गृहपतिर्भूतराज उच्यते, तर्हि परिवाराः किं तथा न वक्ष्यन्ते? ");
INSERT INTO sandev_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","किन्तु तेभ्यो यूयं मा बिभीत, यतो यन्न प्रकाशिष्यते, तादृक् छादितं किमपि नास्ति, यच्च न व्यञ्चिष्यते, तादृग् गुप्तं किमपि नास्ति। ");
INSERT INTO sandev_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","यदहं युष्मान् तमसि वच्मि तद् युष्माभिर्दीप्तौ कथ्यतां; कर्णाभ्यां यत् श्रूयते तद् गेहोपरि प्रचार्य्यतां। ");
INSERT INTO sandev_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ये कायं हन्तुं शक्नुवन्ति नात्मानं, तेभ्यो मा भैष्ट; यः कायात्मानौ निरये नाशयितुं, शक्नोति, ततो बिभीत। ");
INSERT INTO sandev_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","द्वौ चटकौ किमेकताम्रमुद्रया न विक्रीयेते? तथापि युष्मत्तातानुमतिं विना तेषामेकोपि भुवि न पतति। ");
INSERT INTO sandev_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","युष्मच्छिरसां सर्व्वकचा गणितांः सन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","अतो मा बिभीत, यूयं बहुचटकेभ्यो बहुमूल्याः। ");
INSERT INTO sandev_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","यो मनुजसाक्षान्मामङ्गीकुरुते तमहं स्वर्गस्थतातसाक्षादङ्गीकरिष्ये। ");
INSERT INTO sandev_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","पृथ्व्यामहं शान्तिं दातुमागतइति मानुभवत, शान्तिं दातुं न किन्त्वसिं। ");
INSERT INTO sandev_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","पितृमातृश्चश्रूभिः साकं सुतसुताबधू र्विरोधयितुञ्चागतेास्मि। ");
INSERT INTO sandev_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","ततः स्वस्वपरिवारएव नृशत्रु र्भविता। ");
INSERT INTO sandev_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","यः पितरि मातरि वा मत्तोधिकं प्रीयते, स न मदर्हः; ");
INSERT INTO sandev_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","यश्च सुते सुतायां वा मत्तोधिकं प्रीयते, सेापि न मदर्हः। ");
INSERT INTO sandev_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","यः स्वक्रुशं गृह्लन् मत्पश्चान्नैति, सेापि न मदर्हः। ");
INSERT INTO sandev_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","यः स्वप्राणानवति, स तान् हारयिष्यते, यस्तु मत्कृते स्वप्राणान् हारयति, स तानवति। ");
INSERT INTO sandev_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","यो युष्माकमातिथ्यं विदधाति, स ममातिथ्यं विदधाति, यश्च ममातिथ्यं विदधाति, स मत्प्रेरकस्यातिथ्यं विदधाति। ");
INSERT INTO sandev_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","यो भविष्यद्वादीति ज्ञात्वा तस्यातिथ्यं विधत्ते, स भविष्यद्वादिनः फलं लप्स्यते, यश्च धार्म्मिक इति विदित्वा तस्यातिथ्यं विधत्ते स धार्म्मिकमानवस्य फलं प्राप्स्यति। ");
INSERT INTO sandev_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","यश्च कश्चित् एतेषां क्षुद्रनराणाम् यं कञ्चनैकं शिष्य इति विदित्वा कंसैकं शीतलसलिलं तस्मै दत्ते, युष्मानहं तथ्यं वदामि, स केनापि प्रकारेण फलेन न वञ्चिष्यते। ");
INSERT INTO sandev_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","इत्थं यीशुः स्वद्वादशशिष्याणामाज्ञापनं समाप्य पुरे पुर उपदेष्टुं सुसंवादं प्रचारयितुं तत्स्थानात् प्रतस्थे। ");
INSERT INTO sandev_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","अनन्तरं योहन् कारायां तिष्ठन् ख्रिष्टस्य कर्म्मणां वार्त्तं प्राप्य यस्यागमनवार्त्तासीत् सएव किं त्वं? वा वयमन्यम् अपेक्षिष्यामहे? ");
INSERT INTO sandev_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","एतत् प्रष्टुं निजौ द्वौ शिष्यौ प्राहिणोत्। ");
INSERT INTO sandev_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","यीशुः प्रत्यवोचत्, अन्धा नेत्राणि लभन्ते, खञ्चा गच्छन्ति, कुष्ठिनः स्वस्था भवन्ति, बधिराः शृण्वन्ति, मृता जीवन्त उत्तिष्ठन्ति, दरिद्राणां समीपे सुसंवादः प्रचार्य्यत, ");
INSERT INTO sandev_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","एतानि यद्यद् युवां शृणुथः पश्यथश्च गत्वा तद्वार्त्तां योहनं गदतं। ");
INSERT INTO sandev_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","यस्याहं न विघ्नीभवामि, सएव धन्यः। ");
INSERT INTO sandev_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","अनन्तरं तयोः प्रस्थितयो र्यीशु र्योहनम् उद्दिश्य जनान् जगाद, यूयं किं द्रष्टुं वहिर्मध्येप्रान्तरम् अगच्छत? किं वातेन कम्पितं नलं? ");
INSERT INTO sandev_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","वा किं वीक्षितुं वहिर्गतवन्तः? किं परिहितसूक्ष्मवसनं मनुजमेकं? पश्यत, ये सूक्ष्मवसनानि परिदधति, ते राजधान्यां तिष्ठन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","तर्हि यूयं किं द्रष्टुं बहिरगमत, किमेकं भविष्यद्वादिनं? तदेव सत्यं। युष्मानहं वदामि, स भविष्यद्वादिनोपि महान्; ");
INSERT INTO sandev_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","यतः, पश्य स्वकीयदूतोयं त्वदग्रे प्रेष्यते मया। स गत्वा तव पन्थानं स्मयक् परिष्करिष्यति॥ एतद्वचनं यमधि लिखितमास्ते सोऽयं योहन्। ");
INSERT INTO sandev_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","अपरं युष्मानहं तथ्यं ब्रवीमि, मज्जयितु र्योहनः श्रेष्ठः कोपि नारीतो नाजायत; तथापि स्वर्गराज्यमध्ये सर्व्वेभ्यो यः क्षुद्रः स योहनः श्रेष्ठः। ");
INSERT INTO sandev_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","अपरञ्च आ योहनोऽद्य यावत् स्वर्गराज्यं बलादाक्रान्तं भवति आक्रमिनश्च जना बलेन तदधिकुर्व्वन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","यतो योहनं यावत् सर्व्वभविष्यद्वादिभि र्व्यवस्थया च उपदेशः प्राकाश्यत। ");
INSERT INTO sandev_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","यदि यूयमिदं वाक्यं ग्रहीतुं शक्नुथ, तर्हि श्रेयः, यस्यागमनस्य वचनमास्ते सोऽयम् एलियः। ");
INSERT INTO sandev_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","यस्य श्रोतुं कर्णौ स्तः स शृणोतु। ");
INSERT INTO sandev_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","एते विद्यमानजनाः कै र्मयोपमीयन्ते? ये बालका हट्ट उपविश्य स्वं स्वं बन्धुमाहूय वदन्ति, ");
INSERT INTO sandev_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","वयं युष्माकं समीपे वंशीरवादयाम, किन्तु यूयं नानृत्यत; युष्माकं समीपे च वयमरोदिम, किन्तु यूयं न व्यलपत, तादृशै र्बालकैस्त उपमायिष्यन्ते। ");
INSERT INTO sandev_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","यतो योहन् आगत्य न भुक्तवान् न पीतवांश्च, तेन लोका वदन्ति, स भूतग्रस्त इति। ");
INSERT INTO sandev_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","मनुजसुत आगत्य भुक्तवान् पीतवांश्च, तेन लोका वदन्ति, पश्यत एष भोक्ता मद्यपाता चण्डालपापिनां बन्धश्च, किन्तु ज्ञानिनो ज्ञानव्यवहारं निर्दोषं जानन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","स यत्र यत्र पुरे बह्वाश्चर्य्यं कर्म्म कृतवान्, तन्निवासिनां मनःपरावृत्त्यभावात् तानि नगराणि प्रति हन्तेत्युक्ता कथितवान्, ");
INSERT INTO sandev_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","हा कोरासीन्, हा बैत्सैदे, युष्मन्मध्ये यद्यदाश्चर्य्यं कर्म्म कृतं यदि तत् सोरसीदोन्नगर अकारिष्यत, तर्हि पूर्व्वमेव तन्निवासिनः शाणवसने भस्मनि चोपविशन्तो मनांसि परावर्त्तिष्यन्त। ");
INSERT INTO sandev_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","तस्मादहं युष्मान् वदामि, विचारदिने युष्माकं दशातः सोरसीदोनो र्दशा सह्यतरा भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","अपरञ्च बत कफर्नाहूम्, त्वं स्वर्गं यावदुन्नतोसि, किन्तु नरके निक्षेप्स्यसे, यस्मात् त्वयि यान्याश्चर्य्याणि कर्म्मण्यकारिषत, यदि तानि सिदोम्नगर अकारिष्यन्त, तर्हि तदद्य यावदस्थास्यत्। ");
INSERT INTO sandev_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","किन्त्वहं युष्मान् वदामि, विचारदिने तव दण्डतः सिदोमो दण्डो सह्यतरो भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","एतस्मिन्नेव समये यीशुः पुनरुवाच, हे स्वर्गपृथिव्योरेकाधिपते पितस्त्वं ज्ञानवतो विदुषश्च लोकान् प्रत्येतानि न प्रकाश्य बालकान् प्रति प्रकाशितवान्, इति हेतोस्त्वां धन्यं वदामि। ");
INSERT INTO sandev_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","हे पितः, इत्थं भवेत् यत इदं त्वदृष्टावुत्तमं। ");
INSERT INTO sandev_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","पित्रा मयि सर्व्वाणि समर्पितानि, पितरं विना कोपि पुत्रं न जानाति, यान् प्रति पुत्रेण पिता प्रकाश्यते तान् विना पुत्राद् अन्यः कोपि पितरं न जानाति। ");
INSERT INTO sandev_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","हे परिश्रान्ता भाराक्रान्ताश्च लोका यूयं मत्सन्निधिम् आगच्छत, अहं युष्मान् विश्रमयिष्यामि। ");
INSERT INTO sandev_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","अहं क्षमणशीलो नम्रमनाश्च, तस्मात् मम युगं स्वेषामुपरि धारयत मत्तः शिक्षध्वञ्च, तेन यूयं स्वे स्वे मनसि विश्रामं लप्स्यध्बे। ");
INSERT INTO sandev_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","यतो मम युगम् अनायासं मम भारश्च लघुः। ");
INSERT INTO sandev_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","अनन्तरं यीशु र्विश्रामवारे श्स्यमध्येन गच्छति, तदा तच्छिष्या बुभुक्षिताः सन्तः श्स्यमञ्जरीश्छत्वा छित्वा खादितुमारभन्त। ");
INSERT INTO sandev_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","तद् विलोक्य फिरूशिनो यीशुं जगदुः, पश्य विश्रामवारे यत् कर्म्माकर्त्तव्यं तदेव तव शिष्याः कुर्व्वन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","स तान् प्रत्यावदत, दायूद् तत्सङ्गिनश्च बुभुक्षिताः सन्तो यत् कर्म्माकुर्व्वन् तत् किं युष्माभि र्नापाठि? ");
INSERT INTO sandev_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ये दर्शनीयाः पूपाः याजकान् विना तस्य तत्सङ्गिमनुजानाञ्चाभोजनीयास्त ईश्वरावासं प्रविष्टेन तेन भुक्ताः। ");
INSERT INTO sandev_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","अन्यच्च विश्रामवारे मध्येमन्दिरं विश्रामवारीयं नियमं लङ्वन्तोपि याजका निर्दोषा भवन्ति, शास्त्रमध्ये किमिदमपि युष्माभि र्न पठितं? ");
INSERT INTO sandev_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","युष्मानहं वदामि, अत्र स्थाने मन्दिरादपि गरीयान् एक आस्ते। ");
INSERT INTO sandev_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","किन्तु दयायां मे यथा प्रीति र्न तथा यज्ञकर्म्मणि। एतद्वचनस्यार्थं यदि युयम् अज्ञासिष्ट तर्हि निर्दोषान् दोषिणो नाकार्ष्ट। ");
INSERT INTO sandev_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","अन्यच्च मनुजसुतो विश्रामवारस्यापि पतिरास्ते। ");
INSERT INTO sandev_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","अनन्तरं स तत्स्थानात् प्रस्थाय तेषां भजनभवनं प्रविष्टवान्, तदानीम् एकः शुष्ककरामयवान् उपस्थितवान्। ");
INSERT INTO sandev_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ततो यीशुम् अपवदितुं मानुषाः पप्रच्छुः, विश्रामवारे निरामयत्वं करणीयं न वा? ");
INSERT INTO sandev_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","तेन स प्रत्युवाच, विश्रामवारे यदि कस्यचिद् अवि र्गर्त्ते पतति, तर्हि यस्तं घृत्वा न तोलयति, एतादृशो मनुजो युष्माकं मध्ये क आस्ते? ");
INSERT INTO sandev_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","अवे र्मानवः किं नहि श्रेयान्? अतो विश्रामवारे हितकर्म्म कर्त्तव्यं। ");
INSERT INTO sandev_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","अनन्तरं स तं मानवं गदितवान्, करं प्रसारय; तेन करे प्रसारिते सोन्यकरवत् स्वस्थोऽभवत्। ");
INSERT INTO sandev_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","तदा फिरूशिनो बहिर्भूय कथं तं हनिष्याम इति कुमन्त्रणां तत्प्रातिकूल्येन चक्रुः। ");
INSERT INTO sandev_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ततो यीशुस्तद् विदित्वा स्थनान्तरं गतवान्; अन्येषु बहुनरेषु तत्पश्चाद् गतेषु तान् स निरामयान् कृत्वा इत्याज्ञापयत्, ");
INSERT INTO sandev_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","यूयं मां न परिचाययत। ");
INSERT INTO sandev_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","तस्मात् मम प्रीयो मनोनीतो मनसस्तुष्टिकारकः। मदीयः सेवको यस्तु विद्यते तं समीक्षतां। तस्योपरि स्वकीयात्मा मया संस्थापयिष्यते। तेनान्यदेशजातेषु व्यवस्था संप्रकाश्यते। ");
INSERT INTO sandev_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","केनापि न विरोधं स विवादञ्च करिष्यति। न च राजपथे तेन वचनं श्रावयिष्यते। ");
INSERT INTO sandev_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","व्यवस्था चलिता यावत् नहि तेन करिष्यते। तावत् नलो विदीर्णोऽपि भंक्ष्यते नहि तेन च। तथा सधूमवर्त्तिञ्च न स निर्व्वापयिष्यते। ");
INSERT INTO sandev_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","प्रत्याशाञ्च करिष्यन्ति तन्नाम्नि भिन्नदेशजाः। ");
INSERT INTO sandev_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","यान्येतानि वचनानि यिशयियभविष्यद्वादिना प्रोक्तान्यासन्, तानि सफलान्यभवन्। ");
INSERT INTO sandev_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","अनन्तरं लोकै स्तत्समीपम् आनीतो भूतग्रस्तान्धमूकैकमनुजस्तेन स्वस्थीकृतः, ततः सोऽन्धो मूको द्रष्टुं वक्तुञ्चारब्धवान्। ");
INSERT INTO sandev_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","अनेन सर्व्वे विस्मिताः कथयाञ्चक्रुः, एषः किं दायूदः सन्तानो नहि? ");
INSERT INTO sandev_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","किन्तु फिरूशिनस्तत् श्रुत्वा गदितवन्तः, बाल्सिबूब्नाम्नो भूतराजस्य साहाय्यं विना नायं भूतान् त्याजयति। ");
INSERT INTO sandev_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","तदानीं यीशुस्तेषाम् इति मानसं विज्ञाय तान् अवदत् किञ्चन राज्यं यदि स्वविपक्षाद् भिद्यते, तर्हि तत् उच्छिद्यते; यच्च किञ्चन नगरं वा गृहं स्वविपक्षाद् विभिद्यते, तत् स्थातुं न शक्नोति। ");
INSERT INTO sandev_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","तद्वत् शयतानो यदि शयतानं बहिः कृत्वा स्वविपक्षात् पृथक् पृथक् भवति, तर्हि तस्य राज्यं केन प्रकारेण स्थास्यति? ");
INSERT INTO sandev_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","अहञ्च यदि बाल्सिबूबा भूतान् त्याजयामि, तर्हि युष्माकं सन्तानाः केन भूतान् त्याजयन्ति? तस्माद् युष्माकम् एतद्विचारयितारस्त एव भविष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","किन्तवहं यदीश्वरात्मना भूतान् त्याजयामि, तर्हीश्वरस्य राज्यं युष्माकं सन्निधिमागतवत्। ");
INSERT INTO sandev_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","अन्यञ्च कोपि बलवन्त जनं प्रथमतो न बद्व्वा केन प्रकारेण तस्य गृहं प्रविश्य तद्द्रव्यादि लोठयितुं शक्नोति? किन्तु तत् कृत्वा तदीयगृस्य द्रव्यादि लोठयितुं शक्नोति। ");
INSERT INTO sandev_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","यः कश्चित् मम स्वपक्षीयो नहि स विपक्षीय आस्ते, यश्च मया साकं न संगृह्लाति, स विकिरति। ");
INSERT INTO sandev_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","अतएव युष्मानहं वदामि, मनुजानां सर्व्वप्रकारपापानां निन्दायाश्च मर्षणं भवितुं शक्नोति, किन्तु पवित्रस्यात्मनो विरुद्धनिन्दाया मर्षणं भवितुं न शक्नोति। ");
INSERT INTO sandev_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","यो मनुजसुतस्य विरुद्धां कथां कथयति, तस्यापराधस्य क्षमा भवितुं शक्नोति, किन्तु यः कश्चित् पवित्रस्यात्मनो विरुद्धां कथां कथयति नेहलोके न प्रेत्य तस्यापराधस्य क्षमा भवितुं शक्नोति। ");
INSERT INTO sandev_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","पादपं यदि भद्रं वदथ, तर्हि तस्य फलमपि साधु वक्तव्यं, यदि च पादपं असाधुं वदथ, तर्हि तस्य फलमप्यसाधु वक्तव्यं; यतः स्वीयस्वीयफलेन पादपः परिचीयते। ");
INSERT INTO sandev_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","रे भुजगवंशा यूयमसाधवः सन्तः कथं साधु वाक्यं वक्तुं शक्ष्यथ? यस्माद् अन्तःकरणस्य पूर्णभावानुसाराद् वदनाद् वचो निर्गच्छति। ");
INSERT INTO sandev_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","तेन साधुर्मानवोऽन्तःकरणरूपात् साधुभाण्डागारात् साधु द्रव्यं निर्गमयति, असाधुर्मानुषस्त्वसाधुभाण्डागाराद् असाधुवस्तूनि निर्गमयति। ");
INSERT INTO sandev_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","किन्त्वहं युष्मान् वदामि, मनुजा यावन्त्यालस्यवचांसि वदन्ति, विचारदिने तदुत्तरमवश्यं दातव्यं, ");
INSERT INTO sandev_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","यतस्त्वं स्वीयवचोभि र्निरपराधः स्वीयवचोभिश्च सापराधो गणिष्यसे। ");
INSERT INTO sandev_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","तदानीं कतिपया उपाध्यायाः फिरूशिनश्च जगदुः, हे गुरो वयं भवत्तः किञ्चन लक्ष्म दिदृक्षामः। ");
INSERT INTO sandev_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","तदा स प्रत्युक्तवान्, दुष्टो व्यभिचारी च वंशो लक्ष्म मृगयते, किन्तु भविष्यद्वादिनो यूनसो लक्ष्म विहायान्यत् किमपि लक्ष्म ते न प्रदर्शयिष्यन्ते। ");
INSERT INTO sandev_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","यतो यूनम् यथा त्र्यहोरात्रं बृहन्मीनस्य कुक्षावासीत्, तथा मनुजपुत्रोपि त्र्यहोरात्रं मेदिन्या मध्ये स्थास्यति। ");
INSERT INTO sandev_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","अपरं नीनिवीया मानवा विचारदिन एतद्वंशीयानां प्रतिकूलम् उत्थाय तान् दोषिणः करिष्यन्ति, यस्मात्ते यूनस उपदेशात् मनांसि परावर्त्तयाञ्चक्रिरे, किन्त्वत्र यूनसोपि गुरुतर एक आस्ते। ");
INSERT INTO sandev_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","पुनश्च दक्षिणदेशीया राज्ञी विचारदिन एतद्वंशीयानां प्रतिकूलमुत्थाय तान् दोषिणः करिष्यति यतः सा राज्ञी सुलेमनो विद्यायाः कथां श्रोतुं मेदिन्याः सीम्न आगच्छत्, किन्तु सुलेमनोपि गुरुतर एको जनोऽत्र आस्ते। ");
INSERT INTO sandev_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","अपरं मनुजाद् बहिर्गतो ऽपवित्रभूतः शुष्कस्थानेन गत्वा विश्रामं गवेषयति, किन्तु तदलभमानः स वक्ति, यस्मा; निकेतनाद् आगमं, तदेव वेश्म पकावृत्य यामि। ");
INSERT INTO sandev_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","पश्चात् स तत् स्थानम् उपस्थाय तत् शून्यं मार्ज्जितं शोभितञ्च विलोक्य व्रजन् स्वतोपि दुष्टतरान् अन्यसप्तभूतान् सङ्गिनः करोति। ");
INSERT INTO sandev_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ततस्ते तत् स्थानं प्रविश्य निवसन्ति, तेन तस्य मनुजस्य शेषदशा पूर्व्वदशातोतीवाशुभा भवति, एतेषां दुष्टवंश्यानामपि तथैव घटिष्यते। ");
INSERT INTO sandev_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","मानवेभ्य एतासां कथनां कथनकाले तस्य माता सहजाश्च तेन साकं काञ्चित् कथां कथयितुं वाञ्छन्तो बहिरेव स्थितवन्तः। ");
INSERT INTO sandev_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ततः कश्चित् तस्मै कथितवान्, पश्य तव जननी सहजाश्च त्वया साकं काञ्चन कथां कथयितुं कामयमाना बहिस्तिष्ठन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","किन्तु स तं प्रत्यवदत्, मम का जननी? के वा मम सहजाः? ");
INSERT INTO sandev_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","पश्चात् शिष्यान् प्रति करं प्रसार्य्य कथितवान्, पश्य मम जननी मम सहजाश्चैते; ");
INSERT INTO sandev_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","यः कश्चित् मम स्वर्गस्थस्य पितुरिष्टं कर्म्म कुरुते, सएव मम भ्राता भगिनी जननी च। ");
INSERT INTO sandev_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","अपरञ्च तस्मिन् दिने यीशुः सद्मनो गत्वा सरित्पते रोधसि समुपविवेश। ");
INSERT INTO sandev_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","तत्र तत्सन्निधौ बहुजनानां निवहोपस्थितेः स तरणिमारुह्य समुपाविशत्, तेन मानवा रोधसि स्थितवन्तः। ");
INSERT INTO sandev_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","तदानीं स दृष्टान्तैस्तान् इत्थं बहुश उपदिष्टवान्। पश्यत, कश्चित् कृषीवलो बीजानि वप्तुं बहिर्जगाम, ");
INSERT INTO sandev_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","तस्य वपनकाले कतिपयबीजेषु मार्गपार्श्वे पतितेषु विहगास्तानि भक्षितवन्तः। ");
INSERT INTO sandev_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","अपरं कतिपयबीजेषु स्तोकमृद्युक्तपाषाणे पतितेषु मृदल्पत्वात् तत्क्षणात् तान्यङ्कुरितानि, ");
INSERT INTO sandev_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","किन्तु रवावुदिते दग्धानि तेषां मूलाप्रविष्टत्वात् शुष्कतां गतानि च। ");
INSERT INTO sandev_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","अपरं कतिपयबीजेषु कण्टकानां मध्ये पतितेषु कण्टकान्येधित्वा तानि जग्रसुः। ");
INSERT INTO sandev_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","अपरञ्च कतिपयबीजानि उर्व्वरायां पतितानि; तेषां मध्ये कानिचित् शतगुणानि कानिचित् षष्टिगुणानि कानिचित् त्रिंशगुंणानि फलानि फलितवन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","श्रोतुं यस्य श्रुती आसाते स शृणुयात्। ");
INSERT INTO sandev_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","अनन्तरं शिष्यैरागत्य सोऽपृच्छ्यत, भवता तेभ्यः कुतो दृष्टान्तकथा कथ्यते? ");
INSERT INTO sandev_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ततः स प्रत्यवदत्, स्वर्गराज्यस्य निगूढां कथां वेदितुं युष्मभ्यं सामर्थ्यमदायि, किन्तु तेभ्यो नादायि। ");
INSERT INTO sandev_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","यस्माद् यस्यान्तिके वर्द्धते, तस्मायेव दायिष्यते, तस्मात् तस्य बाहुल्यं भविष्यति, किन्तु यस्यान्तिके न वर्द्धते, तस्य यत् किञ्चनास्ते, तदपि तस्माद् आदायिष्यते। ");
INSERT INTO sandev_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","ते पश्यन्तोपि न पश्यन्ति, शृण्वन्तोपि न शृण्वन्ति, बुध्यमाना अपि न बुध्यन्ते च, तस्मात् तेभ्यो दृष्टान्तकथा कथ्यते। ");
INSERT INTO sandev_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","यथा कर्णैः श्रोष्यथ यूयं वै किन्तु यूयं न भोत्स्यथ। नेत्रैर्द्रक्ष्यथ यूयञ्च परिज्ञातुं न शक्ष्यथ। ते मानुषा यथा नैव परिपश्यन्ति लोचनैः। कर्णै र्यथा न शृण्वन्ति न बुध्यन्ते च मानसैः। व्यावर्त्तितेषु चित्तेषु काले कुत्रापि तैर्जनैः। मत्तस्ते मनुजाः स्वस्था यथा नैव भवन्ति च। तथा तेषां मनुष्याणां क्रियन्ते स्थूलबुद्धयः। बधिरीभूतकर्णाश्च जाताश्च मुद्रिता दृशः। ");
INSERT INTO sandev_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","यदेतानि वचनानि यिशयियभविष्यद्वादिना प्रोक्तानि तेषु तानि फलन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","किन्तु युष्माकं नयनानि धन्यानि, यस्मात् तानि वीक्षन्ते; धन्याश्च युष्माकं शब्दग्रहाः, यस्मात् तैराकर्ण्यते। ");
INSERT INTO sandev_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","मया यूयं तथ्यं वचामि युष्माभि र्यद्यद् वीक्ष्यते, तद् बहवो भविष्यद्वादिनो धार्म्मिकाश्च मानवा दिदृक्षन्तोपि द्रष्टुं नालभन्त, पुनश्च यूयं यद्यत् शृणुथ, तत् ते शुश्रूषमाणा अपि श्रोतुं नालभन्त। ");
INSERT INTO sandev_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","कृषीवलीयदृष्टान्तस्यार्थं शृणुत। ");
INSERT INTO sandev_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","मार्गपार्श्वे बीजान्युप्तानि तस्यार्थ एषः, यदा कश्चित् राज्यस्य कथां निशम्य न बुध्यते, तदा पापात्मागत्य तदीयमनस उप्तां कथां हरन् नयति। ");
INSERT INTO sandev_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","अपरं पाषाणस्थले बीजान्युप्तानि तस्यार्थ एषः; कश्चित् कथां श्रुत्वैव हर्षचित्तेन गृह्लाति, ");
INSERT INTO sandev_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","किन्तु तस्य मनसि मूलाप्रविष्टत्वात् स किञ्चित्कालमात्रं स्थिरस्तिष्ठति; पश्चात तत्कथाकारणात् कोपि क्लेस्ताडना वा चेत् जायते, तर्हि स तत्क्षणाद् विघ्नमेति। ");
INSERT INTO sandev_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","अपरं कण्टकानां मध्ये बीजान्युप्तानि तदर्थ एषः; केनचित् कथायां श्रुतायां सांसारिकचिन्ताभि र्भ्रान्तिभिश्च सा ग्रस्यते, तेन सा मा विफला भवति। ");
INSERT INTO sandev_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","अपरम् उर्व्वरायां बीजान्युप्तानि तदर्थ एषः; ये तां कथां श्रुत्वा वुध्यन्ते, ते फलिताः सन्तः केचित् शतगुणानि केचित षष्टिगुणानि केचिच्च त्रिंशद्गुणानि फलानि जनयन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","अनन्तरं सोपरामेकां दृष्टान्तकथामुपस्थाप्य तेभ्यः कथयामास; स्वर्गीयराज्यं तादृशेन केनचिद् गृहस्थेनोपमीयते, येन स्वीयक्षेत्रे प्रशस्तबीजान्यौप्यन्त। ");
INSERT INTO sandev_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","किन्तु क्षणदायां सकललोकेषु सुप्तेषु तस्य रिपुरागत्य तेषां गोधूमबीजानां मध्ये वन्ययवमबीजान्युप्त्वा वव्राज। ");
INSERT INTO sandev_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ततो यदा बीजेभ्योऽङ्करा जायमानाः कणिशानि घृतवन्तः; तदा वन्ययवसान्यपि दृश्यमानान्यभवन्। ");
INSERT INTO sandev_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ततो गृहस्थस्य दासेया आगम्य तस्मै कथयाञ्चक्रुः, हे महेच्छ, भवता किं क्षेत्रे भद्रबीजानि नौप्यन्त? तथात्वे वन्ययवसानि कृत आयन्? ");
INSERT INTO sandev_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","तदानीं तेन ते प्रतिगदिताः, केनचित् रिपुणा कर्म्मदमकारि। दासेयाः कथयामासुः, वयं गत्वा तान्युत्पाय्य क्षिपामो भवतः कीदृशीच्छा जायते? ");
INSERT INTO sandev_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","तेनावादि, नहि, शङ्केऽहं वन्ययवसोत्पाटनकाले युष्माभिस्तैः साकं गोधूमा अप्युत्पाटिष्यन्ते। ");
INSERT INTO sandev_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","अतः श्स्यकर्त्तनकालं यावद् उभयान्यपि सह वर्द्धन्तां, पश्चात् कर्त्तनकाले कर्त्तकान् वक्ष्यामि, यूयमादौ वन्ययवसानि संगृह्य दाहयितुं वीटिका बद्व्वा स्थापयत; किन्तु सर्व्वे गोधूमा युष्माभि र्भाण्डागारं नीत्वा स्थाप्यन्ताम्। ");
INSERT INTO sandev_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","अनन्तरं सोपरामेकां दृष्टान्तकथामुत्थाप्य तेभ्यः कथितवान् कश्चिन्मनुजः सर्षपबीजमेकं नीत्वा स्वक्षेत्र उवाप। ");
INSERT INTO sandev_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","सर्षपबीजं सर्व्वस्माद् बीजात् क्षुद्रमपि सदङ्कुरितं सर्व्वस्मात् शाकात् बृहद् भवति; स तादृशस्तरु र्भवति, यस्य शाखासु नभसः खगा आगत्य निवसन्ति; स्वर्गीयराज्यं तादृशस्य सर्षपैकस्य समम्। ");
INSERT INTO sandev_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","पुनरपि स उपमाकथामेकां तेभ्यः कथयाञ्चकार; काचन योषित् यत् किण्वमादाय द्रोणत्रयमितगोधूमचूर्णानां मध्ये सर्व्वेषां मिश्रीभवनपर्य्यन्तं समाच्छाद्य निधत्तवती, तत्किण्वमिव स्वर्गराज्यं। ");
INSERT INTO sandev_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","इत्थं यीशु र्मनुजनिवहानां सन्निधावुपमाकथाभिरेतान्याख्यानानि कथितवान् उपमां विना तेभ्यः किमपि कथां नाकथयत्। ");
INSERT INTO sandev_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","एतेन दृष्टान्तीयेन वाक्येन व्यादाय वदनं निजं। अहं प्रकाशयिष्यामि गुप्तवाक्यं पुराभवं। यदेतद्वचनं भविष्यद्वादिना प्रोक्तमासीत्, तत् सिद्धमभवत्। ");
INSERT INTO sandev_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","सर्व्वान् मनुजान् विसृज्य यीशौ गृहं प्रविष्टे तच्छिष्या आगत्य यीशवे कथितवन्तः, क्षेत्रस्य वन्ययवसीयदृष्टान्तकथाम् भवान अस्मान् स्पष्टीकृत्य वदतु। ");
INSERT INTO sandev_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ततः स प्रत्युवाच, येन भद्रबीजान्युप्यन्ते स मनुजपुत्रः, ");
INSERT INTO sandev_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","क्षेत्रं जगत्, भद्रबीजानी राज्यस्य सन्तानाः, ");
INSERT INTO sandev_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","वन्ययवसानि पापात्मनः सन्तानाः। येन रिपुणा तान्युप्तानि स शयतानः, कर्त्तनसमयश्च जगतः शेषः, कर्त्तकाः स्वर्गीयदूताः। ");
INSERT INTO sandev_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","यथा वन्ययवसानि संगृह्य दाह्यन्ते, तथा जगतः शेषे भविष्यति; ");
INSERT INTO sandev_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","अर्थात् मनुजसुतः स्वांयदूतान् प्रेषयिष्यति, तेन ते च तस्य राज्यात् सर्व्वान् विघ्नकारिणोऽधार्म्मिकलोकांश्च संगृह्य ");
INSERT INTO sandev_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","यत्र रोदनं दन्तघर्षणञ्च भवति, तत्राग्निकुण्डे निक्षेप्स्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","तदानीं धार्म्मिकलोकाः स्वेषां पितू राज्ये भास्करइव तेजस्विनो भविष्यन्ति। श्रोतुं यस्य श्रुती आसाते, म शृणुयात्। ");
INSERT INTO sandev_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","अपरञ्च क्षेत्रमध्ये निधिं पश्यन् यो गोपयति, ततः परं सानन्दो गत्वा स्वीयसर्व्वस्वं विक्रीय त्तक्षेत्रं क्रीणाति, स इव स्वर्गराज्यं। ");
INSERT INTO sandev_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","अन्यञ्च यो वणिक् उत्तमां मुक्तां गवेषयन् ");
INSERT INTO sandev_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","महार्घां मुक्तां विलोक्य निजसर्व्वस्वं विक्रीय तां क्रीणाति, स इव स्वर्गराज्यं। ");
INSERT INTO sandev_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","पुनश्च समुद्रो निक्षिप्तः सर्व्वप्रकारमीनसंग्राह्यानायइव स्वर्गराज्यं। ");
INSERT INTO sandev_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","तस्मिन् आनाये पूर्णे जना यथा रोधस्युत्तोल्य समुपविश्य प्रशस्तमीनान् संग्रह्य भाजनेषु निदधते, कुत्सितान् निक्षिपन्ति; ");
INSERT INTO sandev_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","तथैव जगतः शेषे भविष्यति, फलतः स्वर्गीयदूता आगत्य पुण्यवज्जनानां मध्यात् पापिनः पृथक् कृत्वा वह्निकुण्डे निक्षेप्स्यन्ति, ");
INSERT INTO sandev_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","तत्र रोदनं दन्तै र्दन्तघर्षणञ्च भविष्यतः। ");
INSERT INTO sandev_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","यीशुना ते पृष्टा युष्माभिः किमेतान्याख्यानान्यबुध्यन्त? तदा ते प्रत्यवदन्, सत्यं प्रभो। ");
INSERT INTO sandev_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","तदानीं स कथितवान्, निजभाण्डागारात् नवीनपुरातनानि वस्तूनि निर्गमयति यो गृहस्थः स इव स्वर्गराज्यमधि शिक्षिताः स्वर्व उपदेष्टारः। ");
INSERT INTO sandev_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","अनन्तरं यीशुरेताः सर्व्वा दृष्टान्तकथाः समाप्य तस्मात् स्थानात् प्रतस्थे। अपरं स्वदेशमागत्य जनान् भजनभवन उपदिष्टवान्; ");
INSERT INTO sandev_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ते विस्मयं गत्वा कथितवन्त एतस्यैतादृशं ज्ञानम् आश्चर्य्यं कर्म्म च कस्माद् अजायत? ");
INSERT INTO sandev_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","किमयं सूत्रधारस्य पुत्रो नहि? एतस्य मातु र्नाम च किं मरियम् नहि? याकुब्-यूषफ्-शिमोन्-यिहूदाश्च किमेतस्य भ्रातरो नहि? ");
INSERT INTO sandev_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","एतस्य भगिन्यश्च किमस्माकं मध्ये न सन्ति? तर्हि कस्मादयमेतानि लब्धवान्? इत्थं स तेषां विघ्नरूपो बभूव; ");
INSERT INTO sandev_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ततो यीशुना निगदितं स्वदेशीयजनानां मध्यं विना भविष्यद्वादी कुत्राप्यन्यत्र नासम्मान्यो भवती। ");
INSERT INTO sandev_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","तेषामविश्वासहेतोः स तत्र स्थाने बह्वाश्चर्य्यकर्म्माणि न कृतवान्। ");
INSERT INTO sandev_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","तदानीं राजा हेरोद् यीशो र्यशः श्रुत्वा निजदासेयान् जगाद्, ");
INSERT INTO sandev_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","एष मज्जयिता योहन्, प्रमितेभयस्तस्योत्थानात् तेनेत्थमद्भुतं कर्म्म प्रकाश्यते। ");
INSERT INTO sandev_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","पुरा हेरोद् निजभ्रातु: फिलिपो जायाया हेरोदीयाया अनुरोधाद् योहनं धारयित्वा बद्धा कारायां स्थापितवान्। ");
INSERT INTO sandev_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","यतो योहन् उक्तवान्, एत्सयाः संग्रहो भवतो नोचितः। ");
INSERT INTO sandev_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","तस्मात् नृपतिस्तं हन्तुमिच्छन्नपि लोकेभ्यो विभयाञ्चकार; यतः सर्व्वे योहनं भविष्यद्वादिनं मेनिरे। ");
INSERT INTO sandev_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","किन्तु हेरोदो जन्माहीयमह उपस्थिते हेरोदीयाया दुहिता तेषां समक्षं नृतित्वा हेरोदमप्रीण्यत्। ");
INSERT INTO sandev_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","तस्मात् भूपतिः शपथं कुर्व्वन् इति प्रत्यज्ञासीत्, त्वया यद् याच्यते, तदेवाहं दास्यामि। ");
INSERT INTO sandev_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","सा कुमारी स्वीयमातुः शिक्षां लब्धा बभाषे, मज्जयितुर्योहन उत्तमाङ्गं भाजने समानीय मह्यं विश्राणय। ");
INSERT INTO sandev_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ततो राजा शुशोच, किन्तु भोजनायोपविशतां सङ्गिनां स्वकृतशपथस्य चानुरोधात् तत् प्रदातुम आदिदेश। ");
INSERT INTO sandev_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","पश्चात् कारां प्रति नरं प्रहित्य योहन उत्तमाङ्गं छित्त्वा ");
INSERT INTO sandev_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","तत् भाजन आनाय्य तस्यै कुमार्य्यै व्यश्राणयत्, ततः सा स्वजनन्याः समीपं तन्निनाय। ");
INSERT INTO sandev_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","पश्चात् योहनः शिष्या आगत्य कायं नीत्वा श्मशाने स्थापयामासुस्ततो यीशोः सन्निधिं व्रजित्वा तद्वार्त्तां बभाषिरे। ");
INSERT INTO sandev_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","अनन्तरं यीशुरिति निशभ्य नावा निर्जनस्थानम् एकाकी गतवान्, पश्चात् मानवास्तत् श्रुत्वा नानानगरेभ्य आगत्य पदैस्तत्पश्चाद् ईयुः। ");
INSERT INTO sandev_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","तदानीं यीशु र्बहिरागत्य महान्तं जननिवहं निरीक्ष्य तेषु कारुणिकः मन् तेषां पीडितजनान् निरामयान् चकार। ");
INSERT INTO sandev_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ततः परं सन्ध्यायां शिष्यास्तदन्तिकमागत्य कथयाञ्चक्रुः, इदं निर्जनस्थानं वेलाप्यवसन्ना; तस्मात् मनुजान् स्वस्वग्रामं गन्तुं स्वार्थं भक्ष्याणि क्रेतुञ्च भवान् तान् विसृजतु। ");
INSERT INTO sandev_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","किन्तु यीशुस्तानवादीत्, तेषां गमने प्रयोजनं नास्ति, यूयमेव तान् भोजयत। ");
INSERT INTO sandev_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","तदा ते प्रत्यवदन्, अस्माकमत्र पूपपञ्चकं मीनद्वयञ्चास्ते। ");
INSERT INTO sandev_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","तदानीं तेनोक्तं तानि मदन्तिकमानयत। ");
INSERT INTO sandev_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","अनन्तरं स मनुजान् यवसोपर्य्युपवेष्टुम् आज्ञापयामास; अपर तत् पूपपञ्चकं मीनद्वयञ्च गृह्लन् स्वर्गं प्रति निरीक्ष्येश्वरीयगुणान् अनूद्य भंक्त्वा शिष्येभ्यो दत्तवान्, शिष्याश्च लोकेभ्यो ददुः। ");
INSERT INTO sandev_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ततः सर्व्वे भुक्त्वा परितृप्तवन्तः, ततस्तदवशिष्टभक्ष्यैः पूर्णान् द्वादशडलकान् गृहीतवन्तः। ");
INSERT INTO sandev_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","ते भोक्तारः स्त्रीर्बालकांश्च विहाय प्रायेण पञ्च सहस्राणि पुमांस आसन्। ");
INSERT INTO sandev_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","तदनन्तरं यीशु र्लोकानां विसर्जनकाले शिष्यान् तरणिमारोढुं स्वाग्रे पारं यातुञ्च गाढमादिष्टवान्। ");
INSERT INTO sandev_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ततो लोकेषु विसृष्टेषु स विविक्ते प्रार्थयितुं गिरिमेकं गत्वा सन्ध्यां यावत् तत्रैकाकी स्थितवान्। ");
INSERT INTO sandev_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","किन्तु तदानीं सम्मुखवातत्वात् सरित्पते र्मध्ये तरङ्गैस्तरणिर्दोलायमानाभवत्। ");
INSERT INTO sandev_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","तदा स यामिन्याश्चतुर्थप्रहरे पद्भ्यां व्रजन् तेषामन्तिकं गतवान्। ");
INSERT INTO sandev_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","किन्तु शिष्यास्तं सागरोपरि व्रजन्तं विलोक्य समुद्विग्ना जगदुः, एष भूत इति शङ्कमाना उच्चैः शब्दायाञ्चक्रिरे च। ");
INSERT INTO sandev_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","तदैव यीशुस्तानवदत्, सुस्थिरा भवत, मा भैष्ट, एषोऽहम्। ");
INSERT INTO sandev_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","ततः पितर इत्युक्तवान्, हे प्रभो, यदि भवानेव, तर्हि मां भवत्समीपं यातुमाज्ञापयतु। ");
INSERT INTO sandev_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ततः तेनादिष्टः पितरस्तरणितोऽवरुह्य यीशेारन्तिकं प्राप्तुं तोयोपरि वव्राज। ");
INSERT INTO sandev_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","किन्तु प्रचण्डं पवनं विलोक्य भयात् तोये मंक्तुम् आरेभे, तस्माद् उच्चैः शब्दायमानः कथितवान्, हे प्रभो, मामवतु। ");
INSERT INTO sandev_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","यीशुस्तत्क्षणात् करं प्रसार्य्य तं धरन् उक्तवान्, ह स्तोकप्रत्ययिन् त्वं कुतः समशेथाः? ");
INSERT INTO sandev_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","अनन्तरं तयोस्तरणिमारूढयोः पवनो निववृते। ");
INSERT INTO sandev_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","तदानीं ये तरण्यामासन्, त आगत्य तं प्रणभ्य कथितवन्तः, यथार्थस्त्वमेवेश्वरसुतः। ");
INSERT INTO sandev_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","अनन्तरं पारं प्राप्य ते गिनेषरन्नामकं नगरमुपतस्थुः, ");
INSERT INTO sandev_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","तदा तत्रत्या जना यीशुं परिचीय तद्देश्स्य चतुर्दिशो वार्त्तां प्रहित्य यत्र यावन्तः पीडिता आसन्, तावतएव तदन्तिकमानयामासुः। ");
INSERT INTO sandev_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","अपरं तदीयवसनस्य ग्रन्थिमात्रं स्प्रष्टुं विनीय यावन्तो जनास्तत् स्पर्शं चक्रिरे, ते सर्व्वएव निरामया बभूवुः। ");
INSERT INTO sandev_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","अपरं यिरूशालम्नगरीयाः कतिपया अध्यापकाः फिरूशिनश्च यीशोः समीपमागत्य कथयामासुः, ");
INSERT INTO sandev_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","तव शिष्याः किमर्थम् अप्रक्षालितकरै र्भक्षित्वा परम्परागतं प्राचीनानां व्यवहारं लङ्वन्ते? ");
INSERT INTO sandev_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ततो यीशुः प्रत्युवाच, यूयं परम्परागताचारेण कुत ईश्वराज्ञां लङ्वध्वे। ");
INSERT INTO sandev_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ईश्वर इत्याज्ञापयत्, त्वं निजपितरौ संमन्येथाः, येन च निजपितरौ निन्द्येते, स निश्चितं म्रियेत; ");
INSERT INTO sandev_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","किन्तु यूयं वदथ, यः स्वजनकं स्वजननीं वा वाक्यमिदं वदति, युवां मत्तो यल्लभेथे, तत् न्यविद्यत, ");
INSERT INTO sandev_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","स निजपितरौ पुन र्न संमंस्यते। इत्थं यूयं परम्परागतेन स्वेषामाचारेणेश्वरीयाज्ञां लुम्पथ। ");
INSERT INTO sandev_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","रे कपटिनः सर्व्वे यिशयियो युष्मानधि भविष्यद्वचनान्येतानि सम्यग् उक्तवान्। ");
INSERT INTO sandev_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","वदनै र्मनुजा एते समायान्ति मदन्तिकं। तथाधरै र्मदीयञ्च मानं कुर्व्वन्ति ते नराः। ");
INSERT INTO sandev_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","किन्तु तेषां मनो मत्तो विदूरएव तिष्ठति। शिक्षयन्तो विधीन् न्राज्ञा भजन्ते मां मुधैव ते। ");
INSERT INTO sandev_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ततो यीशु र्लोकान् आहूय प्रोक्तवान्, यूयं श्रुत्वा बुध्यध्बं। ");
INSERT INTO sandev_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","यन्मुखं प्रविशति, तत् मनुजम् अमेध्यं न करोति, किन्तु यदास्यात् निर्गच्छति, तदेव मानुषममेध्यी करोती। ");
INSERT INTO sandev_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","तदानीं शिष्या आगत्य तस्मै कथयाञ्चक्रुः, एतां कथां श्रुत्वा फिरूशिनो व्यरज्यन्त, तत् किं भवता ज्ञायते? ");
INSERT INTO sandev_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","स प्रत्यवदत्, मम स्वर्गस्थः पिता यं कञ्चिदङ्कुरं नारोपयत्, स उत्पाव्द्यते। ");
INSERT INTO sandev_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","ते तिष्ठन्तु, ते अन्धमनुजानाम् अन्धमार्गदर्शका एव; यद्यन्धोऽन्धं पन्थानं दर्शयति, तर्ह्युभौ गर्त्ते पततः। ");
INSERT INTO sandev_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","तदा पितरस्तं प्रत्यवदत्, दृष्टान्तमिममस्मान् बोधयतु। ");
INSERT INTO sandev_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","यीशुना प्रोक्तं, यूयमद्य यावत् किमबोधाः स्थ? ");
INSERT INTO sandev_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","कथामिमां किं न बुध्यध्बे ? यदास्यं प्रेविशति, तद् उदरे पतन् बहिर्निर्याति, ");
INSERT INTO sandev_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","किन्त्वास्याद् यन्निर्याति, तद् अन्तःकरणात् निर्यातत्वात् मनुजममेध्यं करोति। ");
INSERT INTO sandev_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","यतोऽन्तःकरणात् कुचिन्ता बधः पारदारिकता वेश्यागमनं चैर्य्यं मिथ्यासाक्ष्यम् ईश्वरनिन्दा चैतानि सर्व्वाणि निर्य्यान्ति। ");
INSERT INTO sandev_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","एतानि मनुष्यमपवित्री कुर्व्वन्ति किन्त्वप्रक्षालितकरेण भोजनं मनुजममेध्यं न करोति। ");
INSERT INTO sandev_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","अनन्तरं यीशुस्तस्मात् स्थानात् प्रस्थाय सोरसीदोन्नगरयोः सीमामुपतस्यौ। ");
INSERT INTO sandev_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","तदा तत्सीमातः काचित् किनानीया योषिद् आगत्य तमुच्चैरुवाच, हे प्रभो दायूदः सन्तान, ममैका दुहितास्ते सा भूतग्रस्ता सती महाक्लेशं प्राप्नोति मम दयस्व। ");
INSERT INTO sandev_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","किन्तु यीशुस्तां किमपि नोक्तवान्, ततः शिष्या आगत्य तं निवेदयामासुः, एषा योषिद् अस्माकं पश्चाद् उच्चैराहूयागच्छति, एनां विसृजतु। ");
INSERT INTO sandev_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","तदा स प्रत्यवदत्, इस्रायेल्गोत्रस्य हारितमेषान् विना कस्याप्यन्यस्य समीपं नाहं प्रेषितोस्मि। ");
INSERT INTO sandev_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","ततः सा नारीसमागत्य तं प्रणम्य जगाद, हे प्रभो मामुपकुरु। ");
INSERT INTO sandev_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","स उक्तवान्, बालकानां भक्ष्यमादाय सारमेयेभ्यो दानं नोचितं। ");
INSERT INTO sandev_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","तदा सा बभाषे, हे प्रभो, तत् सत्यं, तथापि प्रभो र्भञ्चाद् यदुच्छिष्टं पतति, तत् सारमेयाः खादन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ततो यीशुः प्रत्यवदत्, हे योषित्, तव विश्वासो महान् तस्मात् तव मनोभिलषितं सिद्य्यतु, तेन तस्याः कन्या तस्मिन्नेव दण्डे निरामयाभवत्। ");
INSERT INTO sandev_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","अनन्तरं यीशस्तस्मात् स्थानात् प्रस्थाय गालील्सागरस्य सन्निधिमागत्य धराधरमारुह्य तत्रोपविवेश। ");
INSERT INTO sandev_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","पश्चात् जननिवहो बहून् खञ्चान्धमूकशुष्ककरमानुषान् आदाय यीशोः समीपमागत्य तच्चरणान्तिके स्थापयामासुः, ततः सा तान् निरामयान् अकरोत्। ");
INSERT INTO sandev_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","इत्थं मूका वाक्यं वदन्ति, शुष्ककराः स्वास्थ्यमायान्ति, पङ्गवो गच्छन्ति, अन्धा वीक्षन्ते, इति विलोक्य लोका विस्मयं मन्यमाना इस्रायेल ईश्वरं धन्यं बभाषिरे। ");
INSERT INTO sandev_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","तदानीं यीशुः स्वशिष्यान् आहूय गदितवान्, एतज्जननिवहेषु मम दया जायते, एते दिनत्रयं मया साकं सन्ति, एषां भक्ष्यवस्तु च कञ्चिदपि नास्ति, तस्मादहमेतानकृताहारान् न विस्रक्ष्यामि, तथात्वे वर्त्ममध्ये क्लाम्येषुः। ");
INSERT INTO sandev_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","तदा शिष्या ऊचुः, एतस्मिन् प्रान्तरमध्य एतावतो मर्त्यान् तर्पयितुं वयं कुत्र पूपान् प्राप्स्यामः? ");
INSERT INTO sandev_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","यीशुरपृच्छत्, युष्माकं निकटे कति पूपा आसते? त ऊचुः, सप्तपूपा अल्पाः क्षुद्रमीनाश्च सन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","तदानीं स लोकनिवहं भूमावुपवेष्टुम् आदिश्य ");
INSERT INTO sandev_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","तान् सप्तपूपान् मीनांश्च गृह्लन् ईश्वरीयगुणान् अनूद्य भंक्त्वा शिष्येभ्यो ददौ, शिष्या लोकेभ्यो ददुः। ");
INSERT INTO sandev_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ततः सर्व्वे भुक्त्वा तृप्तवन्तः; तदवशिष्टभक्ष्येण सप्तडलकान् परिपूर्य्य संजगृहुः। ");
INSERT INTO sandev_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","ते भोक्तारो योषितो बालकांश्च विहाय प्रायेण चतुःसहस्राणि पुरुषा आसन्। ");
INSERT INTO sandev_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","ततः परं स जननिवहं विसृज्य तरिमारुह्य मग्दलाप्रदेशं गतवान्। ");
INSERT INTO sandev_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","तदानीं फिरूशिनः सिदूकिनश्चागत्य तं परीक्षितुं नभमीयं किञ्चन लक्ष्म दर्शयितुं तस्मै निवेदयामासुः। ");
INSERT INTO sandev_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ततः स उक्तवान्, सन्ध्यायां नभसो रक्तत्वाद् यूयं वदथ, श्वो निर्म्मलं दिनं भविष्यति; ");
INSERT INTO sandev_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","प्रातःकाले च नभसो रक्तत्वात् मलिनत्वाञ्च वदथ, झञ्भ्शद्य भविष्यति। हे कपटिनो यदि यूयम् अन्तरीक्षस्य लक्ष्म बोद्धुं शक्नुथ, तर्हि कालस्यैतस्य लक्ष्म कथं बोद्धुं न शक्नुथ? ");
INSERT INTO sandev_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","एतत्कालस्य दुष्टो व्यभिचारी च वंशो लक्ष्म गवेषयति, किन्तु यूनसो भविष्यद्वादिनो लक्ष्म विनान्यत् किमपि लक्ष्म तान् न दर्शयिय्यते। तदानीं स तान् विहाय प्रतस्थे। ");
INSERT INTO sandev_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","अनन्तरमन्यपारगमनकाले तस्य शिष्याः पूपमानेतुं विस्मृतवन्तः। ");
INSERT INTO sandev_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","यीशुस्तानवादीत्, यूयं फिरूशिनां सिदूकिनाञ्च किण्वं प्रति सावधानाः सतर्काश्च भवत। ");
INSERT INTO sandev_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","तेन ते परस्परं विविच्य कथयितुमारेभिरे, वयं पूपानानेतुं विस्मृतवन्त एतत्कारणाद् इति कथयति। ");
INSERT INTO sandev_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","किन्तु यीशुस्तद्विज्ञाय तानवोचत्, हे स्तोकविश्वासिनो यूयं पूपानानयनमधि कुतः परस्परमेतद् विविंक्य? ");
INSERT INTO sandev_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","युष्माभिः किमद्यापि न ज्ञायते? पञ्चभिः पूपैः पञ्चसहस्रपुरुषेषु भोजितेषु भक्ष्योच्छिष्टपूर्णान् कति डलकान् समगृह्लीतं; ");
INSERT INTO sandev_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","तथा सप्तभिः पूपैश्चतुःसहस्रपुरुषेषु भेजितेषु कति डलकान् समगृह्लीत, तत् किं युष्माभिर्न स्मर्य्यते? ");
INSERT INTO sandev_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","तस्मात् फिरूशिनां सिदूकिनाञ्च किण्वं प्रति सावधानास्तिष्ठत, कथामिमाम् अहं पूपानधि नाकथयं, एतद् यूयं कुतो न बुध्यध्वे? ");
INSERT INTO sandev_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","तदानीं पूपकिण्वं प्रति सावधानास्तिष्ठतेति नोक्त्वा फिरूशिनां सिदूकिनाञ्च उपदेशं प्रति सावधानास्तिष्ठतेति कथितवान्, इति तैरबोधि। ");
INSERT INTO sandev_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","अपरञ्च यीशुः कैसरिया-फिलिपिप्रदेशमागत्य शिष्यान् अपृच्छत्, योऽहं मनुजसुतः सोऽहं कः? लोकैरहं किमुच्ये? ");
INSERT INTO sandev_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","तदानीं ते कथितवन्तः, केचिद् वदन्ति त्वं मज्जयिता योहन्, केचिद्वदन्ति, त्वम् एलियः, केचिच्च वदन्ति, त्वं यिरिमियो वा कश्चिद् भविष्यद्वादीति। ");
INSERT INTO sandev_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","पश्चात् स तान् पप्रच्छ, यूयं मां कं वदथ? ततः शिमोन् पितर उवाच, ");
INSERT INTO sandev_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","त्वममरेश्वरस्याभिषिक्तपुत्रः। ");
INSERT INTO sandev_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ततो यीशुः कथितवान्, हे यूनसः पुत्र शिमोन् त्वं धन्यः; यतः कोपि अनुजस्त्वय्येतज्ज्ञानं नोदपादयत्, किन्तु मम स्वर्गस्यः पितोदपादयत्। ");
INSERT INTO sandev_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","अतोऽहं त्वां वदामि, त्वं पितरः (प्रस्तरः) अहञ्च तस्य प्रस्तरस्योपरि स्वमण्डलीं निर्म्मास्यामि, तेन निरयो बलात् तां पराजेतुं न शक्ष्यति। ");
INSERT INTO sandev_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","अहं तुभ्यं स्वर्गीयराज्यस्य कुञ्जिकां दास्यामि, तेन यत् किञ्चन त्वं पृथिव्यां भंत्स्यसि तत्स्वर्गे भंत्स्यते, यच्च किञ्चन मह्यां मोक्ष्यसि तत् स्वर्गे मोक्ष्यते। ");
INSERT INTO sandev_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","पश्चात् स शिष्यानादिशत्, अहमभिषिक्तो यीशुरिति कथां कस्मैचिदपि यूयं मा कथयत। ");
INSERT INTO sandev_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","अन्यञ्च यिरूशालम्नगरं गत्वा प्राचीनलोकेभ्यः प्रधानयाजकेभ्य उपाध्यायेभ्यश्च बहुदुःखभोगस्तै र्हतत्वं तृतीयदिने पुनरुत्थानञ्च ममावश्यकम् एताः कथा यीशुस्तत्कालमारभ्य शिष्यान् ज्ञापयितुम् आरब्धवान्। ");
INSERT INTO sandev_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","तदानीं पितरस्तस्य करं घृत्वा तर्जयित्वा कथयितुमारब्धवान्, हे प्रभो, तत् त्वत्तो दूरं यातु, त्वां प्रति कदापि न घटिष्यते। ");
INSERT INTO sandev_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","किन्तु स वदनं परावर्त्य पितरं जगाद, हे विघ्नकारिन्, मत्सम्मुखाद् दूरीभव, त्वं मां बाधसे, ईश्वरीयकार्य्यात् मानुषीयकार्य्यं तुभ्यं रोचते। ");
INSERT INTO sandev_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","अनन्तरं यीशुः स्वीयशिष्यान् उक्तवान् यः कश्चित् मम पश्चाद्गामी भवितुम् इच्छति, स स्वं दाम्यतु, तथा स्वक्रुशं गृह्लन् मत्पश्चादायातु। ");
INSERT INTO sandev_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","यतो यः प्राणान् रक्षितुमिच्छति, स तान् हारयिष्यति, किन्तु यो मदर्थं निजप्राणान् हारयति, स तान् प्राप्स्यति। ");
INSERT INTO sandev_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","मानुषो यदि सर्व्वं जगत् लभते निजप्रणान् हारयति, तर्हि तस्य को लाभः? मनुजो निजप्राणानां विनिमयेन वा किं दातुं शक्नोति? ");
INSERT INTO sandev_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","मनुजसुतः स्वदूतैः साकं पितुः प्रभावेणागमिष्यति; तदा प्रतिमनुजं स्वस्वकर्म्मानुसारात् फलं दास्यति। ");
INSERT INTO sandev_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","अहं युष्मान् तथ्यं वच्मि, सराज्यं मनुजसुतम् आगतं न पश्यन्तो मृत्युं न स्वादिष्यन्ति, एतादृशाः कतिपयजना अत्रापि दण्डायमानाः सन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","अनन्तरं षड्दिनेभ्यः परं यीशुः पितरं याकूबं तत्सहजं योहनञ्च गृह्लन् उच्चाद्रे र्विविक्तस्थानम् आगत्य तेषां समक्षं रूपमन्यत् दधार। ");
INSERT INTO sandev_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","तेन तदास्यं तेजस्वि, तदाभरणम् आलोकवत् पाण्डरमभवत्। ");
INSERT INTO sandev_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","अन्यच्च तेन साकं संलपन्तौ मूसा एलियश्च तेभ्यो दर्शनं ददतुः। ");
INSERT INTO sandev_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","तदानीं पितरो यीशुं जगाद, हे प्रभो स्थितिरत्रास्माकं शुभा, यदि भवतानुमन्यते, तर्हि भवदर्थमेकं मूसार्थमेकम् एलियार्थञ्चैकम् इति त्रीणि दूष्याणि निर्म्मम। ");
INSERT INTO sandev_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","एतत्कथनकाल एक उज्जवलः पयोदस्तेषामुपरि छायां कृतवान्, वारिदाद् एषा नभसीया वाग् बभूव, ममायं प्रियः पुत्रः, अस्मिन् मम महासन्तोष एतस्य वाक्यं यूयं निशामयत। ");
INSERT INTO sandev_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","किन्तु वाचमेतां शृण्वन्तएव शिष्या मृशं शङ्कमाना न्युब्जा न्यपतन्। ");
INSERT INTO sandev_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","तदा यीशुरागत्य तेषां गात्राणि स्पृशन् उवाच, उत्तिष्ठत, मा भैष्ट। ");
INSERT INTO sandev_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","तदानीं नेत्राण्युन्मील्य यीशुं विना कमपि न ददृशुः। ");
INSERT INTO sandev_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ततः परम् अद्रेरवरोहणकाले यीशुस्तान् इत्यादिदेश, मनुजसुतस्य मृतानां मध्यादुत्थानं यावन्न जायते, तावत् युष्माभिरेतद्दर्शनं कस्मैचिदपि न कथयितव्यं। ");
INSERT INTO sandev_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","तदा शिष्यास्तं पप्रच्छुः, प्रथमम् एलिय आयास्यतीति कुत उपाध्यायैरुच्यते? ");
INSERT INTO sandev_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ततो यीशुः प्रत्यवादीत्, एलियः प्रागेत्य सर्व्वाणि साधयिष्यतीति सत्यं, ");
INSERT INTO sandev_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","किन्त्वहं युष्मान् वच्मि, एलिय एत्य गतः, ते तमपरिचित्य तस्मिन् यथेच्छं व्यवजहुः; मनुजसुतेनापि तेषामन्तिके तादृग् दुःखं भोक्तव्यं। ");
INSERT INTO sandev_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","तदानीं स मज्जयितारं योहनमधि कथामेतां व्याहृतवान्, इत्थं तच्छिष्या बुबुधिरे। ");
INSERT INTO sandev_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","पश्चात् तेषु जननिवहस्यान्तिकमागतेषु कश्चित् मनुजस्तदन्तिकमेत्य जानूनी पातयित्वा कथितवान्, ");
INSERT INTO sandev_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","हे प्रभो, मत्पुत्रं प्रति कृपां विदधातु, सोपस्मारामयेन भृशं व्यथितः सन् पुनः पुन र्वह्नौ मुहु र्जलमध्ये पतति। ");
INSERT INTO sandev_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","तस्माद् भवतः शिष्याणां समीपे तमानयं किन्तु ते तं स्वास्थं कर्त्तुं न शक्ताः। ");
INSERT INTO sandev_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","तदा यीशुः कथितवान् रे अविश्वासिनः, रे विपथगामिनः, पुनः कतिकालान् अहं युष्माकं सन्निधौ स्थास्यामि? कतिकालान् वा युष्मान् सहिष्ये? तमत्र ममान्तिकमानयत। ");
INSERT INTO sandev_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","पश्चाद् यीशुना तर्जतएव स भूतस्तं विहाय गतवान्, तद्दण्डएव स बालको निरामयोऽभूत्। ");
INSERT INTO sandev_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ततः शिष्या गुप्तं यीशुमुपागत्य बभाषिरे, कुतो वयं तं भूतं त्याजयितुं न शक्ताः? ");
INSERT INTO sandev_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","यीशुना ते प्रोक्ताः, युष्माकमप्रत्ययात्; ");
INSERT INTO sandev_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","युष्मानहं तथ्यं वच्मि यदि युष्माकं सर्षपैकमात्रोपि विश्वासो जायते, तर्हि युष्माभिरस्मिन् शैले त्वमितः स्थानात् तत् स्थानं याहीति ब्रूते स तदैव चलिष्यति, युष्माकं किमप्यसाध्यञ्च कर्म्म न स्थास्याति। किन्तु प्रार्थनोपवासौ विनैतादृशो भूतो न त्याज्येत। ");
INSERT INTO sandev_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","अपरं तेषां गालील्प्रदेशे भ्रमणकाले यीशुना ते गदिताः, मनुजसुतो जनानां करेषु समर्पयिष्यते तै र्हनिष्यते च, ");
INSERT INTO sandev_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","किन्तु तृतीयेऽहि्न म उत्थापिष्यते, तेन ते भृशं दुःखिता बभूवः। ");
INSERT INTO sandev_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","तदनन्तरं तेषु कफर्नाहूम्नगरमागतेषु करसंग्राहिणः पितरान्तिकमागत्य पप्रच्छुः, युष्माकं गुरुः किं मन्दिरार्थं करं न ददाति? ततः पितरः कथितवान् ददाति। ");
INSERT INTO sandev_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ततस्तस्मिन् गृहमध्यमागते तस्य कथाकथनात् पूर्व्वमेव यीशुरुवाच, हे शिमोन्, मेदिन्या राजानः स्वस्वापत्येभ्यः किं विदेशिभ्यः केभ्यः करं गृह्लन्ति? अत्र त्वं किं बुध्यसे? ततः पितर उक्तवान्, विदेशिभ्यः। ");
INSERT INTO sandev_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","तदा यीशुरुक्तवान्, तर्हि सन्ताना मुक्ताः सन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","तथापि यथास्माभिस्तेषामन्तरायो न जन्यते, तत्कृते जलधेस्तीरं गत्वा वडिशं क्षिप, तेनादौ यो मीन उत्थास्यति, तं घृत्वा तन्मुखे मोचिते तोलकैकं रूप्यं प्राप्स्यसि, तद् गृहीत्वा तव मम च कृते तेभ्यो देहि। ");
INSERT INTO sandev_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","तदानीं शिष्या यीशोः समीपमागत्य पृष्टवन्तः स्वर्गराज्ये कः श्रेष्ठः? ");
INSERT INTO sandev_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","ततो यीशुः क्षुद्रमेकं बालकं स्वसमीपमानीय तेषां मध्ये निधाय जगाद, ");
INSERT INTO sandev_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","युष्मानहं सत्यं ब्रवीमि, यूयं मनोविनिमयेन क्षुद्रबालवत् न सन्तः स्वर्गराज्यं प्रवेष्टुं न शक्नुथ। ");
INSERT INTO sandev_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","यः कश्चिद् एतस्य क्षुद्रबालकस्य सममात्मानं नम्रीकरोति, सएव स्वर्गराजये श्रेष्ठः। ");
INSERT INTO sandev_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","यः कश्चिद् एतादृशं क्षुद्रबालकमेकं मम नाम्नि गृह्लाति, स मामेव गृह्लाति। ");
INSERT INTO sandev_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","किन्तु यो जनो मयि कृतविश्वासानामेतेषां क्षुद्रप्राणिनाम् एकस्यापि विध्निं जनयति, कण्ठबद्धपेषणीकस्य तस्य सागरागाधजले मज्जनं श्रेयः। ");
INSERT INTO sandev_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","विघ्नात् जगतः सन्तापो भविष्यति, विघ्नोऽवश्यं जनयिष्यते, किन्तु येन मनुजेन विघ्नो जनिष्यते तस्यैव सन्तापो भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","तस्मात् तव करश्चरणो वा यदि त्वां बाधते, तर्हि तं छित्त्वा निक्षिप, द्विकरस्य द्विपदस्य वा तवानप्तवह्नौ निक्षेपात्, खञ्जस्य वा छिन्नहस्तस्य तव जीवने प्रवेशो वरं। ");
INSERT INTO sandev_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","अपरं तव नेत्रं यदि त्वां बाधते, तर्हि तदप्युत्पाव्य निक्षिप, द्विनेत्रस्य नरकाग्नौ निक्षेपात् काणस्य तव जीवने प्रवेशो वरं। ");
INSERT INTO sandev_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","तस्मादवधद्धं, एतेषां क्षुद्रप्राणिनाम् एकमपि मा तुच्छीकुरुत, ");
INSERT INTO sandev_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","यतो युष्मानहं तथ्यं ब्रवीमि, स्वर्गे तेषां दूता मम स्वर्गस्थस्य पितुरास्यं नित्यं पश्यन्ति। एवं ये ये हारितास्तान् रक्षितुं मनुजपुत्र आगच्छत्। ");
INSERT INTO sandev_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","यूयमत्र किं विविंग्घ्वे? कस्यचिद् यदि शतं मेषाः सन्ति, तेषामेको हार्य्यते च, तर्हि स एकोनशतं मेषान् विहाय पर्व्वतं गत्वा तं हारितमेकं किं न मृगयते? ");
INSERT INTO sandev_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","यदि च कदाचित् तन्मेषोद्देशं लमते, तर्हि युष्मानहं सत्यं कथयामि, सोऽविपथगामिभ्य एकोनशतमेषेभ्योपि तदेकहेतोरधिकम् आह्लादते। ");
INSERT INTO sandev_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","तद्वद् एतेषां क्षुद्रप्राएिनाम् एकोपि नश्यतीति युष्माकं स्वर्गस्थपितु र्नाभिमतम्। ");
INSERT INTO sandev_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","यद्यपि तव भ्राता त्वयि किमप्यपराध्यति, तर्हि गत्वा युवयोर्द्वयोः स्थितयोस्तस्यापराधं तं ज्ञापय। तत्र स यदि तव वाक्यं शृणोति, तर्हि त्वं स्वभ्रातरं प्राप्तवान्, ");
INSERT INTO sandev_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","किन्तु यदि न शृणोति, तर्हि द्वाभ्यां त्रिभि र्वा साक्षीभिः सर्व्वं वाक्यं यथा निश्चितं जायते, तदर्थम् एकं द्वौ वा साक्षिणौ गृहीत्वा याहि। ");
INSERT INTO sandev_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","तेन स यदि तयो र्वाक्यं न मान्यते, तर्हि समाजं तज्ज्ञापय, किन्तु यदि समाजस्यापि वाक्यं न मान्यते,तर्हि स तव समीपे देवपूजकइव चण्डालइव च भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","अहं युष्मान् सत्यं वदामि, युष्माभिः पृथिव्यां यद् बध्यते तत् स्वर्गे भंत्स्यते; मेदिन्यां यत् भोच्यते, स्वर्गेऽपि तत् मोक्ष्यते। ");
INSERT INTO sandev_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","पुनरहं युष्मान् वदामि, मेदिन्यां युष्माकं यदि द्वावेकवाक्यीभूय किञ्चित् प्रार्थयेते, तर्हि मम स्वर्गस्थपित्रा तत् तयोः कृते सम्पन्नं भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","यतो यत्र द्वौ त्रयो वा मम नान्नि मिलन्ति, तत्रैवाहं तेषां मध्येऽस्मि। ");
INSERT INTO sandev_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","तदानीं पितरस्तत्समीपमागत्य कथितवान् हे प्रभो, मम भ्राता मम यद्यपराध्यति, तर्हि तं कतिकृत्वः क्षमिष्ये? ");
INSERT INTO sandev_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","किं सप्तकृत्वः? यीशुस्तं जगाद, त्वां केवलं सप्तकृत्वो यावत् न वदामि, किन्तु सप्तत्या गुणितं सप्तकृत्वो यावत्। ");
INSERT INTO sandev_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","अपरं निजदासैः सह जिगणयिषुः कश्चिद् राजेव स्वर्गराजयं। ");
INSERT INTO sandev_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","आरब्धे तस्मिन् गणने सार्द्धसहस्रमुद्रापूरितानां दशसहस्रपुटकानाम् एकोऽघमर्णस्तत्समक्षमानायि। ");
INSERT INTO sandev_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","तस्य परिशोधनाय द्रव्याभावात् परिशोधनार्थं स तदीयभार्य्यापुत्रादिसर्व्वस्वञ्च विक्रीयतामिति तत्प्रभुरादिदेश। ");
INSERT INTO sandev_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","तेन स दासस्तस्य पादयोः पतन् प्रणम्य कथितवान् , हे प्रभो भवता घैर्य्ये कृते मया सर्व्वं परिशोधिष्यते। ");
INSERT INTO sandev_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","तदानीं दासस्य प्रभुः सकरुणः सन् सकलर्णं क्षमित्वा तं तत्याज। ");
INSERT INTO sandev_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","किन्तु तस्मिन् दासे बहि र्याते, तस्य शतं मुद्राचतुर्थांशान् यो धारयति, तं सहदासं दृष्द्वा तस्य कण्ठं निष्पीड्य गदितवान्, मम यत् प्राप्यं तत् परिशोधय। ");
INSERT INTO sandev_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","तदा तस्य सहदासस्तत्पादयोः पतित्वा विनीय बभाषे, त्वया धैर्य्ये कृते मया सर्व्वं परिशोधिष्यते। ");
INSERT INTO sandev_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","तथापि स तत् नाङगीकृत्य यावत् सर्व्वमृणं न परिशोधितवान् तावत् तं कारायां स्थापयामास। ");
INSERT INTO sandev_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","तदा तस्य सहदासास्तस्यैतादृग् आचरणं विलोक्य प्रभोः समीपं गत्वा सर्व्वं वृत्तान्तं निवेदयामासुः। ");
INSERT INTO sandev_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","तदा तस्य प्रभुस्तमाहूय जगाद, रे दुष्ट दास, त्वया मत्सन्निधौ प्रार्थिते मया तव सर्व्वमृणं त्यक्तं; ");
INSERT INTO sandev_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","यथा चाहं त्वयि करुणां कृतवान्, तथैव त्वत्सहदासे करुणाकरणं किं तव नोचितं? ");
INSERT INTO sandev_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","इति कथयित्वा तस्य प्रभुः क्रुद्ध्यन् निजप्राप्यं यावत् स न परिशोधितवान्, तावत् प्रहारकानां करेषु तं समर्पितवान्। ");
INSERT INTO sandev_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","यदि यूयं स्वान्तःकरणैः स्वस्वसहजानाम् अपराधान् न क्षमध्वे, तर्हि मम स्वर्गस्यः पितापि युष्मान् प्रतीत्थं करिष्यति। ");
INSERT INTO sandev_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","अनन्तरम् एतासु कथासु समाप्तासु यीशु र्गालीलप्रदेशात् प्रस्थाय यर्दन्तीरस्थं यिहूदाप्रदेशं प्राप्तः। ");
INSERT INTO sandev_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","तदा तत्पश्चात् जननिवहे गते स तत्र तान् निरामयान् अकरोत्। ");
INSERT INTO sandev_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","तदनन्तरं फिरूशिनस्तत्समीपमागत्य पारीक्षितुं तं पप्रच्छुः, कस्मादपि कारणात् नरेण स्वजाया परित्याज्या न वा? ");
INSERT INTO sandev_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","स प्रत्युवाच, प्रथमम् ईश्वरो नरत्वेन नारीत्वेन च मनुजान् ससर्ज, तस्मात् कथितवान्, ");
INSERT INTO sandev_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","मानुषः स्वपितरौ परित्यज्य स्वपत्न्याम् आसक्ष्यते, तौ द्वौ जनावेकाङ्गौ भविष्यतः, किमेतद् युष्माभि र्न पठितम्? ");
INSERT INTO sandev_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","अतस्तौ पुन र्न द्वौ तयोरेकाङ्गत्वं जातं, ईश्वरेण यच्च समयुज्यत, मनुजो न तद् भिन्द्यात्। ");
INSERT INTO sandev_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","तदानीं ते तं प्रत्यवदन्, तथात्वे त्याज्यपत्रं दत्त्वा स्वां स्वां जायां त्यक्तुं व्यवस्थां मूसाः कथं लिलेख? ");
INSERT INTO sandev_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ततः स कथितवान्, युष्माकं मनसां काठिन्याद् युष्मान् स्वां स्वां जायां त्यक्तुम् अन्वमन्यत किन्तु प्रथमाद् एषो विधिर्नासीत्। ");
INSERT INTO sandev_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","अतो युष्मानहं वदामि, व्यभिचारं विना यो निजजायां त्यजेत् अन्याञ्च विवहेत्, स परदारान् गच्छति; यश्च त्यक्तां नारीं विवहति सोपि परदारेषु रमते। ");
INSERT INTO sandev_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","तदा तस्य शिष्यास्तं बभाषिरे, यदि स्वजायया साकं पुंस एतादृक् सम्बन्धो जायते, तर्हि विवहनमेव न भद्रं। ");
INSERT INTO sandev_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ततः स उक्तवान्, येभ्यस्तत्सामर्थ्यं आदायि, तान् विनान्यः कोपि मनुज एतन्मतं ग्रहीतुं न शक्नोति। ");
INSERT INTO sandev_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","कतिपया जननक्लीबः कतिपया नरकृतक्लीबः स्वर्गराज्याय कतिपयाः स्वकृतक्लीबाश्च सन्ति, ये ग्रहीतुं शक्नुवन्ति ते गृह्लन्तु। ");
INSERT INTO sandev_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","अपरम् यथा स शिशूनां गात्रेषु हस्तं दत्वा प्रार्थयते, तदर्थं तत्समींपं शिशव आनीयन्त, तत आनयितृन् शिष्यास्तिरस्कृतवन्तः। ");
INSERT INTO sandev_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","किन्तु यीशुरुवाच, शिशवो मदन्तिकम् आगच्छन्तु, तान् मा वारयत, एतादृशां शिशूनामेव स्वर्गराज्यं। ");
INSERT INTO sandev_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ततः स तेषां गात्रेषु हस्तं दत्वा तस्मात् स्थानात् प्रतस्थे। ");
INSERT INTO sandev_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","अपरम् एक आगत्य तं पप्रच्छ, हे परमगुरो, अनन्तायुः प्राप्तुं मया किं किं सत्कर्म्म कर्त्तव्यं? ");
INSERT INTO sandev_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ततः स उवाच, मां परमं कुतो वदसि? विनेश्चरं न कोपि परमः, किन्तु यद्यनन्तायुः प्राप्तुं वाञ्छसि, तर्ह्याज्ञाः पालय। ");
INSERT INTO sandev_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","तदा स पृष्टवान्, काः का आज्ञाः? ततो यीशुः कथितवान्, नरं मा हन्याः, परदारान् मा गच्छेः, मा चोरयेः, मृषासाक्ष्यं मा दद्याः, ");
INSERT INTO sandev_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","निजपितरौ संमन्यस्व, स्वसमीपवासिनि स्ववत् प्रेम कुरु। ");
INSERT INTO sandev_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","स युवा कथितवान्, आ बाल्याद् एताः पालयामि, इदानीं किं न्यूनमास्ते? ");
INSERT INTO sandev_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ततो यीशुरवदत्, यदि सिद्धो भवितुं वाञ्छसि, तर्हि गत्वा निजसर्व्वस्वं विक्रीय दरिद्रेभ्यो वितर, ततः स्वर्गे वित्तं लप्स्यसे; आगच्छ, मत्पश्चाद्वर्त्ती च भव। ");
INSERT INTO sandev_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","एतां वाचं श्रुत्वा स युवा स्वीयबहुसम्पत्ते र्विषणः सन् चलितवान्। ");
INSERT INTO sandev_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","तदा यीशुः स्वशिष्यान् अवदत्, धनिनां स्वर्गराज्यप्रवेशो महादुष्कर इति युष्मानहं तथ्यं वदामि। ");
INSERT INTO sandev_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","पुनरपि युष्मानहं वदामि, धनिनां स्वर्गराज्यप्रवेशात् सूचीछिद्रेण महाङ्गगमनं सुकरं। ");
INSERT INTO sandev_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","इति वाक्यं निशम्य शिष्या अतिचमत्कृत्य कथयामासुः; तर्हि कस्य परित्राणं भवितुं शक्नोति? ");
INSERT INTO sandev_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","तदा स तान् दृष्द्वा कथयामास, तत् मानुषाणामशक्यं भवति, किन्त्वीश्वरस्य सर्व्वं शक्यम्। ");
INSERT INTO sandev_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","तदा पितरस्तं गदितवान्, पश्य, वयं सर्व्वं परित्यज्य भवतः पश्चाद्वर्त्तिनो ऽभवाम; वयं किं प्राप्स्यामः? ");
INSERT INTO sandev_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ततो यीशुः कथितवान्, युष्मानहं तथ्यं वदामि, यूयं मम पश्चाद्वर्त्तिनो जाता इति कारणात् नवीनसृष्टिकाले यदा मनुजसुतः स्वीयैश्चर्य्यसिंहासन उपवेक्ष्यति, तदा यूयमपि द्वादशसिंहासनेषूपविश्य इस्रायेलीयद्वादशवंशानां विचारं करिष्यथ। ");
INSERT INTO sandev_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","अन्यच्च यः कश्चित् मम नामकारणात् गृहं वा भ्रातरं वा भगिनीं वा पितरं वा मातरं वा जायां वा बालकं वा भूमिं परित्यजति, स तेषां शतगुणं लप्स्यते, अनन्तायुमोऽधिकारित्वञ्च प्राप्स्यति। ");
INSERT INTO sandev_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","किन्तु अग्रीया अनेके जनाः पश्चात्, पश्चातीयाश्चानेके लोका अग्रे भविष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","स्वर्गराज्यम् एतादृशा केनचिद् गृहस्येन समं, योऽतिप्रभाते निजद्राक्षाक्षेत्रे कृषकान् नियोक्तुं गतवान्। ");
INSERT INTO sandev_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","पश्चात् तैः साकं दिनैकभृतिं मुद्राचतुर्थांशं निरूप्य तान् द्राक्षाक्षेत्रं प्रेरयामास। ");
INSERT INTO sandev_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","अनन्तरं प्रहरैकवेलायां गत्वा हट्टे कतिपयान् निष्कर्म्मकान् विलोक्य तानवदत्, ");
INSERT INTO sandev_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","यूयमपि मम द्राक्षाक्षेत्रं यात, युष्मभ्यमहं योग्यभृतिं दास्यामि, ततस्ते वव्रजुः। ");
INSERT INTO sandev_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","पुनश्च स द्वितीयतृतीययोः प्रहरयो र्बहि र्गत्वा तथैव कृतवान्। ");
INSERT INTO sandev_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","ततो दण्डद्वयावशिष्टायां वेलायां बहि र्गत्वापरान् कतिपयजनान् निष्कर्म्मकान् विलोक्य पृष्टवान्, यूयं किमर्थम् अत्र सर्व्वं दिनं निष्कर्म्माणस्तिष्ठथ? ");
INSERT INTO sandev_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","ते प्रत्यवदन्, अस्मान् न कोपि कर्ममणि नियुंक्ते। तदानीं स कथितवान्, यूयमपि मम द्राक्षाक्षेत्रं यात, तेन योग्यां भृतिं लप्स्यथ। ");
INSERT INTO sandev_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","तदनन्तरं सन्ध्यायां सत्यां सएव द्राक्षाक्षेत्रपतिरध्यक्षं गदिवान्, कृषकान् आहूय शेषजनमारभ्य प्रथमं यावत् तेभ्यो भृतिं देहि। ");
INSERT INTO sandev_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","तेन ये दण्डद्वयावस्थिते समायातास्तेषाम् एकैको जनो मुद्राचतुर्थांशं प्राप्नोत्। ");
INSERT INTO sandev_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","तदानीं प्रथमनियुक्ता जना आगत्यानुमितवन्तो वयमधिकं प्रप्स्यामः, किन्तु तैरपि मुद्राचतुर्थांशोऽलाभि। ");
INSERT INTO sandev_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ततस्ते तं गृहीत्वा तेन क्षेत्रपतिना साकं वाग्युद्धं कुर्व्वन्तः कथयामासुः, ");
INSERT INTO sandev_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","वयं कृत्स्नं दिनं तापक्लेशौ सोढवन्तः, किन्तु पश्चाताया से जना दण्डद्वयमात्रं परिश्रान्तवन्तस्तेऽस्माभिः समानांशाः कृताः। ");
INSERT INTO sandev_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","ततः स तेषामेकं प्रत्युवाच, हे वत्स, मया त्वां प्रति कोप्यन्यायो न कृतः किं त्वया मत्समक्षं मुद्राचतुर्थांशो नाङ्गीकृतः? ");
INSERT INTO sandev_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","तस्मात् तव यत् प्राप्यं तदादाय याहि, तुभ्यं यति, पश्चातीयनियुक्तलोकायापि तति दातुमिच्छामि। ");
INSERT INTO sandev_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","स्वेच्छया निजद्रव्यव्यवहरणं किं मया न कर्त्तव्यं? मम दातृत्वात् त्वया किम् ईर्ष्यादृष्टिः क्रियते? ");
INSERT INTO sandev_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","इत्थम् अग्रीयलोकाः पश्चतीया भविष्यन्ति, पश्चातीयजनाश्चग्रीया भविष्यन्ति, अहूता बहवः किन्त्वल्पे मनोभिलषिताः। ");
INSERT INTO sandev_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","तदनन्तरं यीशु र्यिरूशालम्नगरं गच्छन् मार्गमध्ये शिष्यान् एकान्ते वभाषे, ");
INSERT INTO sandev_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","पश्य वयं यिरूशालम्नगरं यामः, तत्र प्रधानयाजकाध्यापकानां करेषु मनुष्यपुत्रः समर्पिष्यते; ");
INSERT INTO sandev_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ते च तं हन्तुमाज्ञाप्य तिरस्कृत्य वेत्रेण प्रहर्त्तुं क्रुशे धातयितुञ्चान्यदेशीयानां करेषु समर्पयिष्यन्ति, किन्तु स तृतीयदिवसे श्मशानाद् उत्थापिष्यते। ");
INSERT INTO sandev_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","तदानीं सिवदीयस्य नारी स्वपुत्रावादाय यीशोः समीपम् एत्य प्रणम्य कञ्चनानुग्रहं तं ययाचे। ");
INSERT INTO sandev_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","तदा यीशुस्तां प्रोक्तवान्, त्वं किं याचसे? ततः सा बभाषे, भवतो राजत्वे ममानयोः सुतयोरेकं भवद्दक्षिणपार्श्वे द्वितीयं वामपार्श्व उपवेष्टुम् आज्ञापयतु। ");
INSERT INTO sandev_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","यीशुः प्रत्युवाच, युवाभ्यां यद् याच्यते, तन्न बुध्यते, अहं येन कंसेन पास्यामि युवाभ्यां किं तेन पातुं शक्यते? अहञ्च येन मज्जेनेन मज्जिष्ये, युवाभ्यां किं तेन मज्जयितुं शक्यते? ते जगदुः शक्यते। ");
INSERT INTO sandev_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","तदा स उक्तवान्, युवां मम कंसेनावश्यं पास्यथः, मम मज्जनेन च युवामपि मज्जिष्येथे, किन्तु येषां कृते मत्तातेन निरूपितम् इदं तान् विहायान्यं कमपि मद्दक्षिणपार्श्वे वामपार्श्वे च समुपवेशयितुं ममाधिकारो नास्ति। ");
INSERT INTO sandev_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","एतां कथां श्रुत्वान्ये दशशिष्यास्तौ भ्रातरौ प्रति चुकुपुः। ");
INSERT INTO sandev_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","किन्तु यीशुः स्वसमीपं तानाहूय जगाद, अन्यदेशीयलोकानां नरपतयस्तान् अधिकुर्व्वन्ति, ये तु महान्तस्ते तान् शासति, इति यूयं जानीथ। ");
INSERT INTO sandev_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","किन्तु युष्माकं मध्ये न तथा भवेत्, युष्माकं यः कश्चित् महान् बुभूषति, स युष्मान् सेवेत; ");
INSERT INTO sandev_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","यश्च युष्माकं मध्ये मुख्यो बुभूषति, स युष्माकं दासो भवेत्। ");
INSERT INTO sandev_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","इत्थं मनुजपुत्रः सेव्यो भवितुं नहि, किन्तु सेवितुं बहूनां परित्राणमूल्यार्थं स्वप्राणान् दातुञ्चागतः। ");
INSERT INTO sandev_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","अनन्तरं यिरीहोनगरात् तेषां बहिर्गमनसमये तस्य पश्चाद् बहवो लोका वव्रजुः। ");
INSERT INTO sandev_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","अपरं वर्त्मपार्श्व उपविशन्तौ द्वावन्धौ तेन मार्गेण यीशो र्गमनं निशम्य प्रोच्चैः कथयामासतुः, हे प्रभो दायूदः सन्तान, आवयो र्दयां विधेहि। ");
INSERT INTO sandev_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ततो लोकाः सर्व्वे तुष्णीम्भवतमित्युक्त्वा तौ तर्जयामासुः; तथापि तौ पुनरुच्चैः कथयामासतुः हे प्रभो दायूदः सन्तान, आवां दयस्व। ");
INSERT INTO sandev_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","तदानीं यीशुः स्थगितः सन् तावाहूय भाषितवान्, युवयोः कृते मया किं कर्त्तर्व्यं? युवां किं कामयेथे? ");
INSERT INTO sandev_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","तदा तावुक्तवन्तौ, प्रभो नेत्राणि नौ प्रसन्नानि भवेयुः। ");
INSERT INTO sandev_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","तदानीं यीशुस्तौ प्रति प्रमन्नः सन् तयो र्नेत्राणि पस्पर्श, तेनैव तौ सुवीक्षाञ्चक्राते तत्पश्चात् जग्मुतुश्च। ");
INSERT INTO sandev_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","अनन्तरं तेषु यिरूशालम्नगरस्य समीपवेर्त्तिनो जैतुननामकधराधरस्य समीपस्थ्तिं बैत्फगिग्रामम् आगतेषु, यीशुः शिष्यद्वयं प्रेषयन् जगाद, ");
INSERT INTO sandev_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","युवां सम्मुखस्थग्रामं गत्वा बद्धां यां सवत्सां गर्द्दभीं हठात् प्राप्स्यथः, तां मोचयित्वा मदन्तिकम् आनयतं। ");
INSERT INTO sandev_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","तत्र यदि कश्चित् किञ्चिद् वक्ष्यति, तर्हि वदिष्यथः, एतस्यां प्रभोः प्रयोजनमास्ते, तेन स तत्क्षणात् प्रहेष्यति। ");
INSERT INTO sandev_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","सीयोनः कन्यकां यूयं भाषध्वमिति भारतीं। पश्य ते नम्रशीलः सन् नृप आरुह्य गर्दभीं। अर्थादारुह्य तद्वत्समायास्यति त्वदन्तिकं। ");
INSERT INTO sandev_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","भविष्यद्वादिनोक्तं वचनमिदं तदा सफलमभूत्। ");
INSERT INTO sandev_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","अनन्तरं तौ श्ष्यिौ यीशो र्यथानिदेशं तं ग्रामं गत्वा ");
INSERT INTO sandev_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","गर्दभीं तद्वत्सञ्च समानीतवन्तौ, पश्चात् तदुपरि स्वीयवसनानी पातयित्वा तमारोहयामासतुः। ");
INSERT INTO sandev_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ततो बहवो लोका निजवसनानि पथि प्रसारयितुमारेभिरे, कतिपया जनाश्च पादपपर्णादिकं छित्वा पथि विस्तारयामासुः। ");
INSERT INTO sandev_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","अग्रगामिनः पश्चाद्गामिनश्च मनुजा उच्चैर्जय जय दायूदः सन्तानेति जगदुः परमेश्वरस्य नाम्ना य आयाति स धन्यः, सर्व्वोपरिस्थस्वर्गेपि जयति। ");
INSERT INTO sandev_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","इत्थं तस्मिन् यिरूशालमं प्रविष्टे कोऽयमिति कथनात् कृत्स्नं नगरं चञ्चलमभवत्। ");
INSERT INTO sandev_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","तत्र लोकोः कथयामासुः, एष गालील्प्रदेशीय-नासरतीय-भविष्यद्वादी यीशुः। ");
INSERT INTO sandev_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","अनन्तरं यीशुरीश्वरस्य मन्दिरं प्रविश्य तन्मध्यात् क्रयविक्रयिणो वहिश्चकार; वणिजां मुद्रासनानी कपोतविक्रयिणाञ्चसनानी च न्युव्जयामास। ");
INSERT INTO sandev_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","अपरं तानुवाच, एषा लिपिरास्ते, \"मम गृहं प्रार्थनागृहमिति विख्यास्यति\", किन्तु यूयं तद् दस्यूनां गह्वरं कृतवन्तः। ");
INSERT INTO sandev_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","तदनन्तरम् अन्धखञ्चलोकास्तस्य समीपमागताः, स तान् निरामयान् कृतवान्। ");
INSERT INTO sandev_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","यदा प्रधानयाजका अध्यापकाश्च तेन कृतान्येतानि चित्रकर्म्माणि ददृशुः, जय जय दायूदः सन्तान, मन्दिरे बालकानाम् एतादृशम् उच्चध्वनिं शुश्रुवुश्च, तदा महाक्रुद्धा बभूवः, ");
INSERT INTO sandev_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","तं पप्रच्छुश्च, इमे यद् वदन्ति, तत् किं त्वं शृणोषि? ततो यीशुस्तान् अवोचत्, सत्यम्; स्तन्यपायिशिशूनाञ्च बालकानाञ्च वक्त्रतः। स्वकीयं महिमानं त्वं संप्रकाशयसि स्वयं। एतद्वाक्यं यूयं किं नापठत? ");
INSERT INTO sandev_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ततस्तान् विहाय स नगराद् बैथनियाग्रामं गत्वा तत्र रजनीं यापयामास। ");
INSERT INTO sandev_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","अनन्तरं प्रभाते सति यीशुः पुनरपि नगरमागच्छन् क्षुधार्त्तो बभूव। ");
INSERT INTO sandev_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ततो मार्गपार्श्व उडुम्बरवृक्षमेकं विलोक्य तत्समीपं गत्वा पत्राणि विना किमपि न प्राप्य तं पादपं प्रोवाच, अद्यारभ्य कदापि त्वयि फलं न भवतु; तेन तत्क्षणात् स उडुम्बरमाहीरुहः शुष्कतां गतः। ");
INSERT INTO sandev_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","तद् दृष्ट्वा शिष्या आश्चर्य्यं विज्ञाय कथयामासुः, आः, उडुम्वरपादपोऽतितूर्णं शुष्कोऽभवत्। ");
INSERT INTO sandev_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ततो यीशुस्तानुवाच, युष्मानहं सत्यं वदामि, यदि यूयमसन्दिग्धाः प्रतीथ, तर्हि यूयमपि केवलोडुम्वरपादपं प्रतीत्थं कर्त्तुं शक्ष्यथ, तन्न, त्वं चलित्वा सागरे पतेति वाक्यं युष्माभिरस्मिन शैले प्रोक्तेपि तदैव तद् घटिष्यते। ");
INSERT INTO sandev_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","तथा विश्वस्य प्रार्थ्य युष्माभि र्यद् याचिष्यते, तदेव प्राप्स्यते। ");
INSERT INTO sandev_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","अनन्तरं मन्दिरं प्रविश्योपदेशनसमये तत्समीपं प्रधानयाजकाः प्राचीनलोकाश्चागत्य पप्रच्छुः, त्वया केन सामर्थ्यनैतानि कर्म्माणि क्रियन्ते? केन वा तुभ्यमेतानि सामर्थ्यानि दत्तानि? ");
INSERT INTO sandev_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ततो यीशुः प्रत्यवदत्, अहमपि युष्मान् वाचमेकां पृच्छामि, यदि यूयं तदुत्तरं दातुं शक्ष्यथ, तदा केन सामर्थ्येन कर्म्माण्येतानि करोमि, तदहं युष्मान् वक्ष्यामि। ");
INSERT INTO sandev_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","योहनो मज्जनं कस्याज्ञयाभवत्? किमीश्वरस्य मनुष्यस्य वा? ततस्ते परस्परं विविच्य कथयामासुः, यदीश्वरस्येति वदामस्तर्हि यूयं तं कुतो न प्रत्यैत? वाचमेतां वक्ष्यति। ");
INSERT INTO sandev_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","मनुष्यस्येति वक्तुमपि लोकेभ्यो बिभीमः, यतः सर्व्वैरपि योहन् भविष्यद्वादीति ज्ञायते। ");
INSERT INTO sandev_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","तस्मात् ते यीशुं प्रत्यवदन्, तद् वयं न विद्मः। तदा स तानुक्तवान्, तर्हि केन सामरथ्येन कर्म्माण्येतान्यहं करोमि, तदप्यहं युष्मान् न वक्ष्यामि। ");
INSERT INTO sandev_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","कस्यचिज्जनस्य द्वौ सुतावास्तां स एकस्य सुतस्य समीपं गत्वा जगाद, हे सुत, त्वमद्य मम द्राक्षाक्षेत्रे कर्म्म कर्तुं व्रज। ");
INSERT INTO sandev_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ततः स उक्तवान्, न यास्यामि, किन्तु शेषेऽनुतप्य जगाम। ");
INSERT INTO sandev_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","अनन्तरं सोन्यसुतस्य समीपं गत्वा तथैव कथ्तिवान्; ततः स प्रत्युवाच, महेच्छ यामि, किन्तु न गतः। ");
INSERT INTO sandev_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","एतयोः पुत्रयो र्मध्ये पितुरभिमतं केन पालितं? युष्माभिः किं बुध्यते? ततस्ते प्रत्यूचुः, प्रथमेन पुुत्रेण। तदानीं यीशुस्तानुवाच, अहं युष्मान् तथ्यं वदामि, चण्डाला गणिकाश्च युष्माकमग्रत ईश्वरस्य राज्यं प्रविशन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","यतो युष्माकं समीपं योहनि धर्म्मपथेनागते यूयं तं न प्रतीथ, किन्तु चण्डाला गणिकाश्च तं प्रत्यायन्, तद् विलोक्यापि यूयं प्रत्येतुं नाखिद्यध्वं। ");
INSERT INTO sandev_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","अपरमेकं दृष्टान्तं शृणुत, कश्चिद् गृहस्थः क्षेत्रे द्राक्षालता रोपयित्वा तच्चतुर्दिक्षु वारणीं विधाय तन्मध्ये द्राक्षायन्त्रं स्थापितवान्, माञ्चञ्च निर्म्मितवान्, ततः कृषकेषु तत् क्षेत्रं समर्प्य स्वयं दूरदेशं जगाम। ");
INSERT INTO sandev_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","तदनन्तरं फलसमय उपस्थिते स फलानि प्राप्तुं कृषीवलानां समीपं निजदासान् प्रेषयामास। ");
INSERT INTO sandev_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","किन्तु कृषीवलास्तस्य तान् दासेयान् धृत्वा कञ्चन प्रहृतवन्तः, कञ्चन पाषाणैराहतवन्तः, कञ्चन च हतवन्तः। ");
INSERT INTO sandev_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","पुनरपि स प्रभुः प्रथमतोऽधिकदासेयान् प्रेषयामास, किन्तु ते तान् प्रत्यपि तथैव चक्रुः। ");
INSERT INTO sandev_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","अनन्तरं मम सुते गते तं समादरिष्यन्ते, इत्युक्त्वा शेषे स निजसुतं तेषां सन्निधिं प्रेषयामास। ");
INSERT INTO sandev_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","किन्तु ते कृषीवलाः सुतं वीक्ष्य परस्परम् इति मन्त्रयितुम् आरेभिरे, अयमुत्तराधिकारी वयमेनं निहत्यास्याधिकारं स्ववशीकरिष्यामः। ");
INSERT INTO sandev_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","पश्चात् ते तं धृत्वा द्राक्षाक्षेत्राद् बहिः पातयित्वाबधिषुः। ");
INSERT INTO sandev_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","यदा स द्राक्षाक्षेत्रपतिरागमिष्यति, तदा तान् कृषीवलान् किं करिष्यति? ");
INSERT INTO sandev_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ततस्ते प्रत्यवदन्, तान् कलुषिणो दारुणयातनाभिराहनिष्यति, ये च समयानुक्रमात् फलानि दास्यन्ति, तादृशेषु कृषीवलेषु क्षेत्रं समर्पयिष्यति। ");
INSERT INTO sandev_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","तदा यीशुना ते गदिताः, ग्रहणं न कृतं यस्य पाषाणस्य निचायकैः। प्रधानप्रस्तरः कोणे सएव संभविष्यति। एतत् परेशितुः कर्म्मास्मदृष्टावद्भुतं भवेत्। धर्म्मग्रन्थे लिखितमेतद्वचनं युष्माभिः किं नापाठि? ");
INSERT INTO sandev_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","तस्मादहं युष्मान् वदामि, युष्मत्त ईश्वरीयराज्यमपनीय फलोत्पादयित्रन्यजातये दायिष्यते। ");
INSERT INTO sandev_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","यो जन एतत्पाषाणोपरि पतिष्यति, तं स भंक्ष्यते, किन्त्वयं पाषाणो यस्योपरि पतिष्यति, तं स धूलिवत् चूर्णीकरिष्यति। ");
INSERT INTO sandev_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","तदानीं प्राधनयाजकाः फिरूशिनश्च तस्येमां दृष्टान्तकथां श्रुत्वा सोऽस्मानुद्दिश्य कथितवान्, इति विज्ञाय तं धर्त्तुं चेष्टितवन्तः; ");
INSERT INTO sandev_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","किन्तु लोकेभ्यो बिभ्युः, यतो लोकैः स भविष्यद्वादीत्यज्ञायि। ");
INSERT INTO sandev_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","अनन्तरं यीशुः पुनरपि दृष्टान्तेन तान् अवादीत्, ");
INSERT INTO sandev_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","स्वर्गीयराज्यम् एतादृशस्य नृपतेः समं, यो निज पुत्रं विवाहयन् सर्व्वान् निमन्त्रितान् आनेतुं दासेयान् प्रहितवान्, ");
INSERT INTO sandev_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","किन्तु ते समागन्तुं नेष्टवन्तः। ");
INSERT INTO sandev_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","ततो राजा पुनरपि दासानन्यान् इत्युक्त्वा प्रेषयामास, निमन्त्रितान् वदत, पश्यत, मम भेज्यमासादितमास्ते, निजव्टषादिपुष्टजन्तून् मारयित्वा सर्व्वं खाद्यद्रव्यमासादितवान्, यूयं विवाहमागच्छत। ");
INSERT INTO sandev_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","तथपि ते तुच्छीकृत्य केचित् निजक्षेत्रं केचिद् वाणिज्यं प्रति स्वस्वमार्गेण चलितवन्तः। ");
INSERT INTO sandev_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","अन्ये लोकास्तस्य दासेयान् धृत्वा दौरात्म्यं व्यवहृत्य तानवधिषुः। ");
INSERT INTO sandev_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","अनन्तरं स नृपतिस्तां वार्त्तां श्रुत्वा क्रुध्यन् सैन्यानि प्रहित्य तान् घातकान् हत्वा तेषां नगरं दाहयामास। ");
INSERT INTO sandev_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","ततः स निजदासेयान् बभाषे, विवाहीयं भोज्यमासादितमास्ते, किन्तु निमन्त्रिता जना अयोग्याः। ");
INSERT INTO sandev_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","तस्माद् यूयं राजमार्गं गत्वा यावतो मनुजान् पश्यत, तावतएव विवाहीयभोज्याय निमन्त्रयत। ");
INSERT INTO sandev_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","तदा ते दासेया राजमार्गं गत्वा भद्रान् अभद्रान् वा यावतो जनान् ददृशुः, तावतएव संगृह्यानयन्; ततोऽभ्यागतमनुजै र्विवाहगृहम् अपूर्य्यत। ");
INSERT INTO sandev_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","तदानीं स राजा सर्व्वानभ्यागतान् द्रष्टुम् अभ्यन्तरमागतवान्; तदा तत्र विवाहीयवसनहीनमेकं जनं वीक्ष्य तं जगाद्, ");
INSERT INTO sandev_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","हे मित्र,त्वं विवाहीयवसनं विना कथमत्र प्रविष्टवान्? तेन स निरुत्तरो बभूव। ");
INSERT INTO sandev_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","तदा राजा निजानुचरान् अवदत्, एतस्य करचरणान् बद्धा यत्र रोदनं दन्तैर्दन्तघर्षणञ्च भवति, तत्र वहिर्भूततमिस्रे तं निक्षिपत। ");
INSERT INTO sandev_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","इत्थं बहव आहूता अल्पे मनोभिमताः। ");
INSERT INTO sandev_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","अनन्तरं फिरूशिनः प्रगत्य यथा संलापेन तम् उन्माथे पातयेयुस्तथा मन्त्रयित्वा ");
INSERT INTO sandev_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","हेरोदीयमनुजैः साकं निजशिष्यगणेन तं प्रति कथयामासुः, हे गुरो, भवान् सत्यः सत्यमीश्वरीयमार्गमुपदिशति, कमपि मानुषं नानुरुध्यते, कमपि नापेक्षते च, तद् वयं जानीमः। ");
INSERT INTO sandev_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","अतः कैसरभूपाय करोऽस्माकं दातव्यो न वा? अत्र भवता किं बुध्यते? तद् अस्मान् वदतु। ");
INSERT INTO sandev_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","ततो यीशुस्तेषां खलतां विज्ञाय कथितवान्, रे कपटिनः युयं कुतो मां परिक्षध्वे? ");
INSERT INTO sandev_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","तत्करदानस्य मुद्रां मां दर्शयत। तदानीं तैस्तस्य समीपं मुद्राचतुर्थभाग आनीते ");
INSERT INTO sandev_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","स तान् पप्रच्छ, अत्र कस्येयं मूर्त्ति र्नाम चास्ते? ते जगदुः, कैसरभूपस्य। ");
INSERT INTO sandev_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ततः स उक्तवान, कैसरस्य यत् तत् कैसराय दत्त, ईश्वरस्य यत् तद् ईश्वराय दत्त। ");
INSERT INTO sandev_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","इति वाक्यं निशम्य ते विस्मयं विज्ञाय तं विहाय चलितवन्तः। ");
INSERT INTO sandev_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","तस्मिन्नहनि सिदूकिनोऽर्थात् श्मशानात् नोत्थास्यन्तीति वाक्यं ये वदन्ति, ते यीशेारन्तिकम् आगत्य पप्रच्छुः, ");
INSERT INTO sandev_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","हे गुरो, कश्चिन्मनुजश्चेत् निःसन्तानः सन् प्राणान् त्यजति, तर्हि तस्य भ्राता तस्य जायां व्युह्य भ्रातुः सन्तानम् उत्पादयिष्यतीति मूसा आदिष्टवान्। ");
INSERT INTO sandev_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","किन्त्वस्माकमत्र केऽपि जनाः सप्तसहोदरा आसन्, तेषां ज्येष्ठ एकां कन्यां व्यवहात्, अपरं प्राणत्यागकाले स्वयं निःसन्तानः सन् तां स्त्रियं स्वभ्रातरि समर्पितवान्, ");
INSERT INTO sandev_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ततो द्वितीयादिसप्तमान्ताश्च तथैव चक्रुः। ");
INSERT INTO sandev_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","शेषे सापी नारी ममार। ");
INSERT INTO sandev_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","मृतानाम् उत्थानसमये तेषां सप्तानां मध्ये सा नारी कस्य भार्य्या भविष्यति? यस्मात् सर्व्वएव तां व्यवहन्। ");
INSERT INTO sandev_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ततो यीशुः प्रत्यवादीत्, यूयं धर्म्मपुस्तकम् ईश्वरीयां शक्तिञ्च न विज्ञाय भ्रान्तिमन्तः। ");
INSERT INTO sandev_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","उत्थानप्राप्ता लोका न विवहन्ति, न च वाचा दीयन्ते, किन्त्वीश्वरस्य स्वर्गस्थदूतानां सदृशा भवन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","अपरं मृतानामुत्थानमधि युष्मान् प्रतीयमीश्वरोक्तिः, ");
INSERT INTO sandev_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","\"अहमिब्राहीम ईश्वर इस्हाक ईश्वरो याकूब ईश्वर\" इति किं युष्माभि र्नापाठि? किन्त्वीश्वरो जीवताम् ईश्वर:, स मृतानामीश्वरो नहि। ");
INSERT INTO sandev_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","इति श्रुत्वा सर्व्वे लोकास्तस्योपदेशाद् विस्मयं गताः। ");
INSERT INTO sandev_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","अनन्तरं सिदूकिनाम् निरुत्तरत्ववार्तां निशम्य फिरूशिन एकत्र मिलितवन्तः, ");
INSERT INTO sandev_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","तेषामेको व्यवस्थापको यीशुं परीक्षितुं पपच्छ, ");
INSERT INTO sandev_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","हे गुरो व्यवस्थाशास्त्रमध्ये काज्ञा श्रेष्ठा? ");
INSERT INTO sandev_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ततो यीशुरुवाच, त्वं सर्व्वान्तःकरणैः सर्व्वप्राणैः सर्व्वचित्तैश्च साकं प्रभौ परमेश्वरे प्रीयस्व, ");
INSERT INTO sandev_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","एषा प्रथममहाज्ञा। तस्याः सदृशी द्वितीयाज्ञैषा, ");
INSERT INTO sandev_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","तव समीपवासिनि स्वात्मनीव प्रेम कुरु। ");
INSERT INTO sandev_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","अनयो र्द्वयोराज्ञयोः कृत्स्नव्यवस्थाया भविष्यद्वक्तृग्रन्थस्य च भारस्तिष्ठति। ");
INSERT INTO sandev_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","अनन्तरं फिरूशिनाम् एकत्र स्थितिकाले यीशुस्तान् पप्रच्छ, ");
INSERT INTO sandev_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","ख्रीष्टमधि युष्माकं कीदृग्बोधो जायते? स कस्य सन्तानः? ततस्ते प्रत्यवदन्, दायूदः सन्तानः। ");
INSERT INTO sandev_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","तदा स उक्तवान्, तर्हि दायूद् कथम् आत्माधिष्ठानेन तं प्रभुं वदति ? ");
INSERT INTO sandev_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","यथा मम प्रभुमिदं वाक्यमवदत् परमेश्वरः। तवारीन् पादपीठं ते यावन्नहि करोम्यहं। तावत् कालं मदीये त्वं दक्षपार्श्व उपाविश। अतो यदि दायूद् तं प्रभुं वदति, र्तिह स कथं तस्य सन्तानो भवति? ");
INSERT INTO sandev_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","तदानीं तेषां कोपि तद्वाक्यस्य किमप्युत्तरं दातुं नाशक्नोत्; ");
INSERT INTO sandev_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","तद्दिनमारभ्य तं किमपि वाक्यं प्रष्टुं कस्यापि साहसो नाभवत्। ");
INSERT INTO sandev_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","अनन्तरं यीशु र्जननिवहं शिष्यांश्चावदत्, ");
INSERT INTO sandev_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","अध्यापकाः फिरूशिनश्च मूसासने उपविशन्ति, ");
INSERT INTO sandev_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","अतस्ते युष्मान् यद्यत् मन्तुम् आज्ञापयन्ति, तत् मन्यध्वं पालयध्वञ्च, किन्तु तेषां कर्म्मानुरूपं कर्म्म न कुरुध्वं; यतस्तेषां वाक्यमात्रं सारं कार्य्ये किमपि नास्ति। ");
INSERT INTO sandev_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","ते दुर्व्वहान् गुरुतरान् भारान् बद्व्वा मनुष्याणां स्कन्धेपरि समर्पयन्ति, किन्तु स्वयमङ्गुल्यैकयापि न चालयन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","केवलं लोकदर्शनाय सर्व्वकर्म्माणि कुर्व्वन्ति; फलतः पट्टबन्धान् प्रसार्य्य धारयन्ति, स्ववस्त्रेषु च दीर्घग्रन्थीन् धारयन्ति; ");
INSERT INTO sandev_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","भोजनभवन उच्चस्थानं, भजनभवने प्रधानमासनं, ");
INSERT INTO sandev_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","हट्ठे नमस्कारं गुरुरिति सम्बोधनञ्चैतानि सर्व्वाणि वाञ्छन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","किन्तु यूयं गुरव इति सम्बोधनीया मा भवत, यतो युष्माकम् एकः ख्रीष्टएव गुरु ");
INSERT INTO sandev_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","र्यूयं सर्व्वे मिथो भ्रातरश्च। पुनः पृथिव्यां कमपि पितेति मा सम्बुध्यध्वं, यतो युष्माकमेकः स्वर्गस्थएव पिता। ");
INSERT INTO sandev_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","यूयं नायकेति सम्भाषिता मा भवत, यतो युष्माकमेकः ख्रीष्टएव नायकः। ");
INSERT INTO sandev_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","अपरं युष्माकं मध्ये यः पुमान् श्रेष्ठः स युष्मान् सेविष्यते। ");
INSERT INTO sandev_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","यतो यः स्वमुन्नमति, स नतः करिष्यते; किन्तु यः कश्चित् स्वमवनतं करोति, स उन्नतः करिष्यते। ");
INSERT INTO sandev_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","हन्त कपटिन उपाध्यायाः फिरूशिनश्च, यूयं मनुजानां समक्षं स्वर्गद्वारं रुन्ध, यूयं स्वयं तेन न प्रविशथ, प्रविविक्षूनपि वारयथ। वत कपटिन उपाध्यायाः फिरूशिनश्च यूयं छलाद् दीर्घं प्रार्थ्य विधवानां सर्व्वस्वं ग्रसथ, युष्माकं घोरतरदण्डो भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","हन्त कपटिन उपाध्यायाः फिरूशिनश्च, यूयमेकं स्वधर्म्मावलम्बिनं कर्त्तुं सागरं भूमण्डलञ्च प्रदक्षिणीकुरुथ, ");
INSERT INTO sandev_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","कञ्चन प्राप्य स्वतो द्विगुणनरकभाजनं तं कुरुथ। ");
INSERT INTO sandev_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","वत अन्धपथदर्शकाः सर्व्वे, यूयं वदथ, मन्दिरस्य शपथकरणात् किमपि न देयं; किन्तु मन्दिरस्थसुवर्णस्य शपथकरणाद् देयं। ");
INSERT INTO sandev_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","हे मूढा हे अन्धाः सुवर्णं तत्सुवर्णपावकमन्दिरम् एतयोरुभयो र्मध्ये किं श्रेयः? ");
INSERT INTO sandev_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","अन्यच्च वदथ, यज्ञवेद्याः शपथकरणात् किमपि न देयं, किन्तु तदुपरिस्थितस्य नैवेद्यस्य शपथकरणाद् देयं। ");
INSERT INTO sandev_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","हे मूढा हे अन्धाः, नैवेद्यं तन्नैवेद्यपावकवेदिरेतयोरुभयो र्मध्ये किं श्रेयः? ");
INSERT INTO sandev_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","अतः केनचिद् यज्ञवेद्याः शपथे कृते तदुपरिस्थस्य सर्व्वस्य शपथः क्रियते। ");
INSERT INTO sandev_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","केनचित् मन्दिरस्य शपथे कृते मन्दिरतन्निवासिनोः शपथः क्रियते। ");
INSERT INTO sandev_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","केनचित् स्वर्गस्य शपथे कृते ईश्वरीयसिंहासनतदुपर्य्युपविष्टयोः शपथः क्रियते। ");
INSERT INTO sandev_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","हन्त कपटिन उपाध्यायाः फिरूशिनश्च, यूयं पोदिनायाः सितच्छत्राया जीरकस्य च दशमांशान् दत्थ, किन्तु व्यवस्थाया गुरुतरान् न्यायदयाविश्वासान् परित्यजथ; इमे युष्माभिराचरणीया अमी च न लंघनीयाः। ");
INSERT INTO sandev_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","हे अन्धपथदर्शका यूयं मशकान् अपसारयथ, किन्तु महाङ्गान् ग्रसथ। ");
INSERT INTO sandev_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","हन्त कपटिन उपाध्यायाः फिरूशिनश्च, यूयं पानपात्राणां भोजनपात्राणाञ्च बहिः परिष्कुरुथ; किन्तु तदभ्यन्तरं दुरात्मतया कलुषेण च परिपूर्णमास्ते। ");
INSERT INTO sandev_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","हे अन्धाः फिरूशिलोका आदौ पानपात्राणां भोजनपात्राणाञ्चाभ्यन्तरं परिष्कुरुत, तेन तेषां बहिरपि परिष्कारिष्यते। ");
INSERT INTO sandev_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","हन्त कपटिन उपाध्यायाः फिरूशिनश्च, यूयं शुक्लीकृतश्मशानस्वरूपा भवथ, यथा श्मशानभवनस्य बहिश्चारु, किन्त्वभ्यन्तरं मृतलोकानां कीकशैः सर्व्वप्रकारमलेन च परिपूर्णम्; ");
INSERT INTO sandev_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","तथैव यूयमपि लोकानां समक्षं बहिर्धार्म्मिकाः किन्त्वन्तःकरणेषु केवलकापट्याधर्म्माभ्यां परिपूर्णाः। ");
INSERT INTO sandev_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","हा हा कपटिन उपाध्यायाः फिरूशिनश्च, यूयं भविष्यद्वादिनां श्मशानगेहं निर्म्माथ, साधूनां श्मशाननिकेतनं शोभयथ ");
INSERT INTO sandev_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","वदथ च यदि वयं स्वेषां पूर्व्वपुरुषाणां काल अस्थास्याम, तर्हि भविष्यद्वादिनां शोणितपातने तेषां सहभागिनो नाभविष्याम। ");
INSERT INTO sandev_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","अतो यूयं भविष्यद्वादिघातकानां सन्ताना इति स्वयमेव स्वेषां साक्ष्यं दत्थ। ");
INSERT INTO sandev_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","अतो यूयं निजपूर्व्वपुरुषाणां परिमाणपात्रं परिपूरयत। ");
INSERT INTO sandev_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","रे भुजगाः कृष्णभुजगवंशाः, यूयं कथं नरकदण्डाद् रक्षिष्यध्वे। ");
INSERT INTO sandev_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","पश्यत, युष्माकमन्तिकम् अहं भविष्यद्वादिनो बुद्धिमत उपाध्यायांश्च प्रेषयिष्यामि, किन्तु तेषां कतिपया युष्माभि र्घानिष्यन्ते, क्रुशे च घानिष्यन्ते, केचिद् भजनभवने कषाभिराघानिष्यन्ते, नगरे नगरे ताडिष्यन्ते च; ");
INSERT INTO sandev_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","तेन सत्पुरुषस्य हाबिलो रक्तपातमारभ्य बेरिखियः पुत्रं यं सिखरियं यूयं मन्दिरयज्ञवेद्यो र्मध्ये हतवन्तः, तदीयशोणितपातं यावद् अस्मिन् देशे यावतां साधुपुरुषाणां शोणितपातो ऽभवत् तत् सर्व्वेषामागसां दण्डा युष्मासु वर्त्तिष्यन्ते। ");
INSERT INTO sandev_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","अहं युष्मान्त तथ्यं वदामि, विद्यमानेऽस्मिन् पुरुषे सर्व्वे वर्त्तिष्यन्ते। ");
INSERT INTO sandev_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","हे यिरूशालम् हे यिरूशालम् नगरि त्वं भविष्यद्वादिनो हतवती, तव समीपं प्रेरितांश्च पाषाणैराहतवती, यथा कुक्कुटी शावकान् पक्षाधः संगृह्लाति, तथा तव सन्तानान् संग्रहीतुं अहं बहुवारम् ऐच्छं; किन्तु त्वं न सममन्यथाः। ");
INSERT INTO sandev_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","पश्यत यष्माकं वासस्थानम् उच्छिन्नं त्यक्ष्यते। ");
INSERT INTO sandev_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","अहं युष्मान् तथ्यं वदामि, यः परमेश्वरस्य नाम्नागच्छति, स धन्य इति वाणीं यावन्न वदिष्यथ, तावत् मां पुन र्न द्रक्ष्यथ। ");
INSERT INTO sandev_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","अनन्तरं यीशु र्यदा मन्दिराद् बहि र्गच्छति, तदानीं शिष्यास्तं मन्दिरनिर्म्माणं दर्शयितुमागताः। ");
INSERT INTO sandev_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ततो यीशुस्तानुवाच, यूयं किमेतानि न पश्यथ? युष्मानहं सत्यं वदामि, एतन्निचयनस्य पाषाणैकमप्यन्यपाषाणेापरि न स्थास्यति सर्व्वाणि भूमिसात् कारिष्यन्ते। ");
INSERT INTO sandev_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","अनन्तरं तस्मिन् जैतुनपर्व्वतोपरि समुपविष्टे शिष्यास्तस्य समीपमागत्य गुप्तं पप्रच्छुः, एता घटनाः कदा भविष्यन्ति? भवत आगमनस्य युगान्तस्य च किं लक्ष्म? तदस्मान् वदतु। ");
INSERT INTO sandev_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","तदानीं यीशुस्तानवोचत्, अवधद्व्वं, कोपि युष्मान् न भ्रमयेत्। ");
INSERT INTO sandev_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","बहवो मम नाम गृह्लन्त आगमिष्यन्ति, ख्रीष्टोऽहमेवेति वाचं वदन्तो बहून् भ्रमयिष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","यूयञ्च संग्रामस्य रणस्य चाडम्बरं श्रोष्यथ, अवधद्व्वं तेन चञ्चला मा भवत, एतान्यवश्यं घटिष्यन्ते, किन्तु तदा युगान्तो नहि। ");
INSERT INTO sandev_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","अपरं देशस्य विपक्षो देशो राज्यस्य विपक्षो राज्यं भविष्यति, स्थाने स्थाने च दुर्भिक्षं महामारी भूकम्पश्च भविष्यन्ति, ");
INSERT INTO sandev_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","एतानि दुःखोपक्रमाः। ");
INSERT INTO sandev_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","तदानीं लोका दुःखं भोजयितुं युष्मान् परकरेषु समर्पयिष्यन्ति हनिष्यन्ति च, तथा मम नामकारणाद् यूयं सर्व्वदेशीयमनुजानां समीपे घृणार्हा भविष्यथ। ");
INSERT INTO sandev_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","बहुषु विघ्नं प्राप्तवत्सु परस्परम् ऋृतीयां कृतवत्सु च एकोऽपरं परकरेषु समर्पयिष्यति। ");
INSERT INTO sandev_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","तथा बहवो मृषाभविष्यद्वादिन उपस्थाय बहून् भ्रमयिष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","दुष्कर्म्मणां बाहुल्याञ्च बहूनां प्रेम शीतलं भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","किन्तु यः कश्चित् शेषं यावद् धैर्य्यमाश्रयते, सएव परित्रायिष्यते। ");
INSERT INTO sandev_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","अपरं सर्व्वदेशीयलोकान् प्रतिमाक्षी भवितुं राजस्य शुभसमाचारः सर्व्वजगति प्रचारिष्यते, एतादृशि सति युगान्त उपस्थास्यति। ");
INSERT INTO sandev_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","अतो यत् सर्व्वनाशकृद्घृणार्हं वस्तु दानियेल्भविष्यद्वदिना प्रोक्तं तद् यदा पुण्यस्थाने स्थापितं द्रक्ष्यथ, (यः पठति, स बुध्यतां) ");
INSERT INTO sandev_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","तदानीं ये यिहूदीयदेशे तिष्ठन्ति, ते पर्व्वतेषु पलायन्तां। ");
INSERT INTO sandev_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","यः कश्चिद् गृहपृष्ठे तिष्ठति, स गृहात् किमपि वस्त्वानेतुम् अधेा नावरोहेत्। ");
INSERT INTO sandev_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","यश्च क्षेत्रे तिष्ठति, सोपि वस्त्रमानेतुं परावृत्य न यायात्। ");
INSERT INTO sandev_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","तदानीं गर्भिणीस्तन्यपाययित्रीणां दुर्गति र्भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","अतो यष्माकं पलायनं शीतकाले विश्रामवारे वा यन्न भवेत्, तदर्थं प्रार्थयध्वम्। ");
INSERT INTO sandev_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","आ जगदारम्भाद् एतत्कालपर्य्यनन्तं यादृशः कदापि नाभवत् न च भविष्यति तादृशो महाक्लेशस्तदानीम् उपस्थास्यति। ");
INSERT INTO sandev_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","तस्य क्लेशस्य समयो यदि ह्स्वो न क्रियेत, तर्हि कस्यापि प्राणिनो रक्षणं भवितुं न शक्नुयात्, किन्तु मनोनीतमनुजानां कृते स कालो ह्स्वीकरिष्यते। ");
INSERT INTO sandev_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","अपरञ्च पश्यत, ख्रीष्टोऽत्र विद्यते, वा तत्र विद्यते, तदानीं यदी कश्चिद् युष्मान इति वाक्यं वदति, तथापि तत् न प्रतीत्। ");
INSERT INTO sandev_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","यतो भाक्तख्रीष्टा भाक्तभविष्यद्वादिनश्च उपस्थाय यानि महन्ति लक्ष्माणि चित्रकर्म्माणि च प्रकाशयिष्यन्ति, तै र्यदि सम्भवेत् तर्हि मनोनीतमानवा अपि भ्रामिष्यन्ते। ");
INSERT INTO sandev_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","पश्यत, घटनातः पूर्व्वं युष्मान् वार्त्ताम् अवादिषम्। ");
INSERT INTO sandev_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","अतः पश्यत, स प्रान्तरे विद्यत इति वाक्ये केनचित् कथितेपि बहि र्मा गच्छत, वा पश्यत, सोन्तःपुरे विद्यते, एतद्वाक्य उक्तेपि मा प्रतीत। ");
INSERT INTO sandev_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","यतो यथा विद्युत् पूर्व्वदिशो निर्गत्य पश्चिमदिशं यावत् प्रकाशते, तथा मानुषपुत्रस्याप्यागमनं भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","यत्र शवस्तिष्ठति, तत्रेव गृध्रा मिलन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","अपरं तस्य क्लेशसमयस्याव्यवहितपरत्र सूर्य्यस्य तेजो लोप्स्यते, चन्द्रमा ज्योस्नां न करिष्यति, नभसो नक्षत्राणि पतिष्यन्ति, गगणीया ग्रहाश्च विचलिष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","तदानीम् आकाशमध्ये मनुजसुतस्य लक्ष्म दर्शिष्यते, ततो निजपराक्रमेण महातेजसा च मेघारूढं मनुजसुतं नभसागच्छन्तं विलोक्य पृथिव्याः सर्व्ववंशीया विलपिष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","तदानीं स महाशब्दायमानतूर्य्या वादकान् निजदूतान् प्रहेष्यति, ते व्योम्न एकसीमातोऽपरसीमां यावत् चतुर्दिशस्तस्य मनोनीतजनान् आनीय मेलयिष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","उडुम्बरपादपस्य दृष्टान्तं शिक्षध्वं; यदा तस्य नवीनाः शाखा जायन्ते, पल्लवादिश्च निर्गच्छति, तदा निदाघकालः सविधो भवतीति यूयं जानीथ; ");
INSERT INTO sandev_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","तद्वद् एता घटना दृष्ट्वा स समयो द्वार उपास्थाद् इति जानीत। ");
INSERT INTO sandev_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","युष्मानहं तथ्यं वदामि, इदानीन्तनजनानां गमनात् पूर्व्वमेव तानि सर्व्वाणि घटिष्यन्ते। ");
INSERT INTO sandev_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","नभोमेदिन्यो र्लुप्तयोरपि मम वाक् कदापि न लोप्स्यते। ");
INSERT INTO sandev_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","अपरं मम तातं विना मानुषः स्वर्गस्थो दूतो वा कोपि तद्दिनं तद्दण्डञ्च न ज्ञापयति। ");
INSERT INTO sandev_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","अपरं नोहे विद्यमाने यादृशमभवत् तादृशं मनुजसुतस्यागमनकालेपि भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","फलतो जलाप्लावनात् पूर्व्वं यद्दिनं यावत् नोहः पोतं नारोहत्, तावत्कालं यथा मनुष्या भोजने पाने विवहने विवाहने च प्रवृत्ता आसन्; ");
INSERT INTO sandev_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","अपरम् आप्लावितोयमागत्य यावत् सकलमनुजान् प्लावयित्वा नानयत्, तावत् ते यथा न विदामासुः, तथा मनुजसुतागमनेपि भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","तदा क्षेत्रस्थितयोर्द्वयोरेको धारिष्यते, अपरस्त्याजिष्यते। ");
INSERT INTO sandev_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","तथा पेषण्या पिंषत्योरुभयो र्योषितोरेका धारिष्यतेऽपरा त्याजिष्यते। ");
INSERT INTO sandev_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","युष्माकं प्रभुः कस्मिन् दण्ड आगमिष्यति, तद् युष्माभि र्नावगम्यते, तस्मात् जाग्रतः सन्तस्तिष्ठत। ");
INSERT INTO sandev_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","कुत्र यामे स्तेन आगमिष्यतीति चेद् गृहस्थो ज्ञातुम् अशक्ष्यत्, तर्हि जागरित्वा तं सन्धिं कर्त्तितुम् अवारयिष्यत् तद् जानीत। ");
INSERT INTO sandev_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","युष्माभिरवधीयतां, यतो युष्माभि र्यत्र न बुध्यते, तत्रैव दण्डे मनुजसुत आयास्यति। ");
INSERT INTO sandev_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","प्रभु र्निजपरिवारान् यथाकालं भोजयितुं यं दासम् अध्यक्षीकृत्य स्थापयति, तादृशो विश्वास्यो धीमान् दासः कः? ");
INSERT INTO sandev_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","प्रभुरागत्य यं दासं तथाचरन्तं वीक्षते, सएव धन्यः। ");
INSERT INTO sandev_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","युष्मानहं सत्यं वदामि, स तं निजसर्व्वस्वस्याधिपं करिष्यति। ");
INSERT INTO sandev_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","किन्तु प्रभुरागन्तुं विलम्बत इति मनसि चिन्तयित्वा यो दुष्टो दासो ");
INSERT INTO sandev_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ऽपरदासान् प्रहर्त्तुं मत्तानां सङ्गे भोक्तुं पातुञ्च प्रवर्त्तते, ");
INSERT INTO sandev_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","स दासो यदा नापेक्षते, यञ्च दण्डं न जानाति, तत्कालएव तत्प्रभुरुपस्थास्यति। ");
INSERT INTO sandev_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","तदा तं दण्डयित्वा यत्र स्थाने रोदनं दन्तघर्षणञ्चासाते, तत्र कपटिभिः साकं तद्दशां निरूपयिष्यति। ");
INSERT INTO sandev_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","या दश कन्याः प्रदीपान् गृह्लत्यो वरं साक्षात् कर्त्तुं बहिरिताः, ताभिस्तदा स्वर्गीयराज्यस्य सादृश्यं भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","तासां कन्यानां मध्ये पञ्च सुधियः पञ्च दुर्धिय आसन्। ");
INSERT INTO sandev_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","या दुर्धियस्ताः प्रदीपान् सङ्गे गृहीत्वा तैलं न जगृहुः, ");
INSERT INTO sandev_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","किन्तु सुधियः प्रदीपान् पात्रेण तैलञ्च जगृहुः। ");
INSERT INTO sandev_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","अनन्तरं वरे विलम्बिते ताः सर्व्वा निद्राविष्टा निद्रां जग्मुः। ");
INSERT INTO sandev_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","अनन्तरम् अर्द्धरात्रे पश्यत वर आगच्छति, तं साक्षात् कर्त्तुं बहिर्यातेति जनरवात् ");
INSERT INTO sandev_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","ताः सर्व्वाः कन्या उत्थाय प्रदीपान् आसादयितुं आरभन्त। ");
INSERT INTO sandev_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ततो दुर्धियः सुधिय ऊचुः, किञ्चित् तैलं दत्त, प्रदीपा अस्माकं निर्व्वाणाः। ");
INSERT INTO sandev_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","किन्तु सुधियः प्रत्यवदन्, दत्ते युष्मानस्मांश्च प्रति तैलं न्यूनीभवेत्, तस्माद् विक्रेतृणां समीपं गत्वा स्वार्थं तैलं क्रीणीत। ");
INSERT INTO sandev_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","तदा तासु क्रेतुं गतासु वर आजगाम, ततो याः सज्जिता आसन्, तास्तेन साकं विवाहीयं वेश्म प्रविविशुः। ");
INSERT INTO sandev_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","अनन्तरं द्वारे रुद्धे अपराः कन्या आगत्य जगदुः, हे प्रभो, हे प्रभो, अस्मान् प्रति द्वारं मोचय। ");
INSERT INTO sandev_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","किन्तु स उक्तवान्, तथ्यं वदामि, युष्मानहं न वेद्मि। ");
INSERT INTO sandev_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","अतो जाग्रतः सन्तस्तिष्ठत, मनुजसुतः कस्मिन् दिने कस्मिन् दण्डे वागमिष्यति, तद् युष्माभि र्न ज्ञायते। ");
INSERT INTO sandev_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","अपरं स एतादृशः कस्यचित् पुंसस्तुल्यः, यो दूरदेशं प्रति यात्राकाले निजदासान् आहूय तेषां स्वस्वसामर्थ्यानुरूपम् ");
INSERT INTO sandev_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","एकस्मिन् मुद्राणां पञ्च पोटलिकाः अन्यस्मिंश्च द्वे पोटलिके अपरस्मिंश्च पोटलिकैकाम् इत्थं प्रतिजनं समर्प्य स्वयं प्रवासं गतवान्। ");
INSERT INTO sandev_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","अनन्तरं यो दासः पञ्च पोटलिकाः लब्धवान्, स गत्वा वाणिज्यं विधाय ता द्विगुणीचकार। ");
INSERT INTO sandev_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","यश्च दासो द्वे पोटलिके अलभत, सोपि ता मुद्रा द्विगुणीचकार। ");
INSERT INTO sandev_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","किन्तु यो दास एकां पोटलिकां लब्धवान्, स गत्वा भूमिं खनित्वा तन्मध्ये निजप्रभोस्ता मुद्रा गोपयाञ्चकार। ");
INSERT INTO sandev_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","तदनन्तरं बहुतिथे काले गते तेषां दासानां प्रभुरागत्य तैर्दासैः समं गणयाञ्चकार। ");
INSERT INTO sandev_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","तदानीं यः पञ्च पोटलिकाः प्राप्तवान् स ता द्विगुणीकृतमुद्रा आनीय जगाद; हे प्रभो, भवता मयि पञ्च पोटलिकाः समर्पिताः, पश्यतु, ता मया द्विगुणीकृताः। ");
INSERT INTO sandev_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","तदानीं तस्य प्रभुस्तमुवाच, हे उत्तम विश्वास्य दास, त्वं धन्योसि, स्तोकेन विश्वास्यो जातः, तस्मात् त्वां बहुवित्ताधिपं करोमि, त्वं स्वप्रभोः सुखस्य भागी भव। ");
INSERT INTO sandev_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","ततो येन द्वे पोटलिके लब्धे सोप्यागत्य जगाद, हे प्रभो, भवता मयि द्वे पोटलिके समर्पिते, पश्यतु ते मया द्विगुणीकृते। ");
INSERT INTO sandev_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","तेन तस्य प्रभुस्तमवोचत्, हे उत्तम विश्वास्य दास, त्वं धन्योसि, स्तोकेन विश्वास्यो जातः, तस्मात् त्वां बहुद्रविणाधिपं करोमि, त्वं निजप्रभोः सुखस्य भागी भव। ");
INSERT INTO sandev_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","अनन्तरं य एकां पोटलिकां लब्धवान्, स एत्य कथितवान्, हे प्रभो, त्वां कठिननरं ज्ञातवान्, त्वया यत्र नोप्तं, तत्रैव कृत्यते, यत्र च न कीर्णं, तत्रैव संगृह्यते। ");
INSERT INTO sandev_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","अतोहं सशङ्कः सन् गत्वा तव मुद्रा भूमध्ये संगोप्य स्थापितवान्, पश्य, तव यत् तदेव गृहाण। ");
INSERT INTO sandev_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","तदा तस्य प्रभुः प्रत्यवदत् रे दुष्टालस दास, यत्राहं न वपामि, तत्र छिनद्मि, यत्र च न किरामि, तत्रेव संगृह्लामीति चेदजानास्तर्हि ");
INSERT INTO sandev_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","वणिक्षु मम वित्तार्पणं तवोचितमासीत्, येनाहमागत्य वृद्व्या साकं मूलमुद्राः प्राप्स्यम्। ");
INSERT INTO sandev_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","अतोस्मात् तां पोटलिकाम् आदाय यस्य दश पोटलिकाः सन्ति तस्मिन्नर्पयत। ");
INSERT INTO sandev_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","येन वर्द्व्यते तस्मिन्नैवार्पिष्यते, तस्यैव च बाहुल्यं भविष्यति, किन्तु येन न वर्द्व्यते, तस्यान्तिके यत् किञ्चन तिष्ठति, तदपि पुनर्नेष्यते। ");
INSERT INTO sandev_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","अपरं यूयं तमकर्म्मण्यं दासं नीत्वा यत्र स्थाने क्रन्दनं दन्तघर्षणञ्च विद्येते, तस्मिन् बहिर्भूततमसि निक्षिपत। ");
INSERT INTO sandev_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","यदा मनुजसुतः पवित्रदूतान् सङ्गिनः कृत्वा निजप्रभावेनागत्य निजतेजोमये सिंहासने निवेक्ष्यति, ");
INSERT INTO sandev_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","तदा तत्सम्मुखे सर्व्वजातीया जना संमेलिष्यन्ति। ततो मेषपालको यथा छागेभ्योऽवीन् पृथक् करोति तथा सोप्येकस्मादन्यम् इत्थं तान् पृथक कृत्वावीन् ");
INSERT INTO sandev_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","दक्षिणे छागांश्च वामे स्थापयिष्यति। ");
INSERT INTO sandev_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","ततः परं राजा दक्षिणस्थितान् मानवान् वदिष्यति, आगच्छत मत्तातस्यानुग्रहभाजनानि, युष्मत्कृत आ जगदारम्भत् यद् राज्यम् आसादितं तदधिकुरुत। ");
INSERT INTO sandev_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","यतो बुभुक्षिताय मह्यं भोज्यम् अदत्त, पिपासिताय पेयमदत्त, विदेशिनं मां स्वस्थानमनयत, ");
INSERT INTO sandev_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","वस्त्रहीनं मां वसनं पर्य्यधापयत, पीडीतं मां द्रष्टुमागच्छत, कारास्थञ्च मां वीक्षितुम आगच्छत। ");
INSERT INTO sandev_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","तदा धार्म्मिकाः प्रतिवदिष्यन्ति, हे प्रभो, कदा त्वां क्षुधितं वीक्ष्य वयमभोजयाम? वा पिपासितं वीक्ष्य अपाययाम? ");
INSERT INTO sandev_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","कदा वा त्वां विदेशिनं विलोक्य स्वस्थानमनयाम? कदा वा त्वां नग्नं वीक्ष्य वसनं पर्य्यधापयाम? ");
INSERT INTO sandev_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","कदा वा त्वां पीडितं कारास्थञ्च वीक्ष्य त्वदन्तिकमगच्छाम? ");
INSERT INTO sandev_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","तदानीं राजा तान् प्रतिवदिष्यति, युष्मानहं सत्यं वदामि, ममैतेषां भ्रातृणां मध्ये कञ्चनैकं क्षुद्रतमं प्रति यद् अकुरुत, तन्मां प्रत्यकुरुत। ");
INSERT INTO sandev_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","पश्चात् स वामस्थितान् जनान् वदिष्यति, रे शापग्रस्ताः सर्व्वे, शैताने तस्य दूतेभ्यश्च योऽनन्तवह्निरासादित आस्ते, यूयं मदन्तिकात् तमग्निं गच्छत। ");
INSERT INTO sandev_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","यतो क्षुधिताय मह्यमाहारं नादत्त, पिपासिताय मह्यं पेयं नादत्त, ");
INSERT INTO sandev_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","विदेशिनं मां स्वस्थानं नानयत, वसनहीनं मां वसनं न पर्य्यधापयत, पीडितं कारास्थञ्च मां वीक्षितुं नागच्छत। ");
INSERT INTO sandev_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","तदा ते प्रतिवदिष्यन्ति, हे प्रभो, कदा त्वां क्षुधितं वा पिपासितं वा विदेशिनं वा नग्नं वा पीडितं वा कारास्थं वीक्ष्य त्वां नासेवामहि? ");
INSERT INTO sandev_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","तदा स तान् वदिष्यति, तथ्यमहं युष्मान् ब्रवीमि, युष्माभिरेषां कञ्चन क्षोदिष्ठं प्रति यन्नाकारि, तन्मां प्रत्येव नाकारि। ");
INSERT INTO sandev_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","पश्चादम्यनन्तशास्तिं किन्तु धार्म्मिका अनन्तायुषं भोक्तुं यास्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","यीशुरेतान् प्रस्तावान् समाप्य शिष्यानूचे, ");
INSERT INTO sandev_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","युष्माभि र्ज्ञातं दिनद्वयात् परं निस्तारमह उपस्थास्यति, तत्र मनुजसुतः क्रुशेन हन्तुं परकरेषु समर्पिष्यते। ");
INSERT INTO sandev_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","ततः परं प्रधानयाजकाध्यापकप्राञ्चः कियफानाम्नो महायाजकस्याट्टालिकायां मिलित्वा ");
INSERT INTO sandev_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","केनोपायेन यीशुं धृत्वा हन्तुं शक्नुयुरिति मन्त्रयाञ्चक्रुः। ");
INSERT INTO sandev_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","किन्तु तैरुक्तं महकाले न धर्त्तव्यः, धृते प्रजानां कलहेन भवितुं शक्यते। ");
INSERT INTO sandev_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","ततो बैथनियापुरे शिमोनाख्यस्य कुष्ठिनो वेश्मनि यीशौ तिष्ठति ");
INSERT INTO sandev_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","काचन योषा श्वेतोपलभाजनेन महार्घ्यं सुगन्धि तैलमानीय भोजनायोपविशतस्तस्य शिरोभ्यषेचत्। ");
INSERT INTO sandev_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","किन्तु तदालोक्य तच्छिष्यैः कुपितैरुक्तं, कुत इत्थमपव्ययते? ");
INSERT INTO sandev_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","चेदिदं व्यक्रेष्यत, तर्हि भूरिमूल्यं प्राप्य दरिद्रेभ्यो व्यतारिष्यत। ");
INSERT INTO sandev_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","यीशुना तदवगत्य ते समुदिताः, योषामेनां कुतो दुःखिनीं कुरुथ, सा मां प्रति साधु कर्म्माकार्षीत्। ");
INSERT INTO sandev_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","युष्माकमं समीपे दरिद्राः सततमेवासते, किन्तु युष्माकमन्तिकेहं नासे सततं। ");
INSERT INTO sandev_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","सा मम कायोपरि सुगन्धितैलं सिक्त्वा मम श्मशानदानकर्म्माकार्षीत्। ");
INSERT INTO sandev_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","अतोहं युष्मान् तथ्यं वदामि सर्व्वस्मिन् जगति यत्र यत्रैष सुसमाचारः प्रचारिष्यते, तत्र तत्रैतस्या नार्य्याः स्मरणार्थम् कर्म्मेदं प्रचारिष्यते। ");
INSERT INTO sandev_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","ततो द्वादशशिष्याणाम् ईष्करियोतीययिहूदानामक एकः शिष्यः प्रधानयाजकानामन्तिकं गत्वा कथितवान्, ");
INSERT INTO sandev_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","यदि युष्माकं करेषु यीशुं समर्पयामि, तर्हि किं दास्यथ? तदानीं ते तस्मै त्रिंशन्मुद्रा दातुं स्थिरीकृतवन्तः। ");
INSERT INTO sandev_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","स तदारभ्य तं परकरेषु समर्पयितुं सुयोगं चेष्टितवान्। ");
INSERT INTO sandev_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","अनन्तरं किण्वशून्यपूपपर्व्वणः प्रथमेह्नि शिष्या यीशुम् उपगत्य पप्रच्छुः भवत्कृते कुत्र वयं निस्तारमहभोज्यम् आयोजयिष्यामः? भवतः केच्छा? ");
INSERT INTO sandev_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","तदा स गदितवान्, मध्येनगरममुकपुंसः समीपं व्रजित्वा वदत, गुरु र्गदितवान्, मत्कालः सविधः, सह शिष्यैस्त्वदालये निस्तारमहभोज्यं भोक्ष्ये। ");
INSERT INTO sandev_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","तदा शिष्या यीशोस्तादृशनिदेशानुरूपकर्म्म विधाय तत्र निस्तारमहभोज्यमासादयामासुः। ");
INSERT INTO sandev_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ततः सन्ध्यायां सत्यां द्वादशभिः शिष्यैः साकं स न्यविशत्। ");
INSERT INTO sandev_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","अपरं भुञ्जान उक्तवान् युष्मान् तथ्यं वदामि, युष्माकमेको मां परकरेषु समर्पयिष्यति। ");
INSERT INTO sandev_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","तदा तेऽतीव दुःखिता एकैकशो वक्तुमारेभिरे, हे प्रभो, स किमहं? ");
INSERT INTO sandev_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ततः स जगाद, मया साकं यो जनो भोजनपात्रे करं संक्षिपति, स एव मां परकरेषु समर्पयिष्यति। ");
INSERT INTO sandev_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","मनुजसुतमधि यादृशं लिखितमास्ते, तदनुरूपा तद्गति र्भविष्यति; किन्तु येन पुंसा स परकरेषु समर्पयिष्यते, हा हा चेत् स नाजनिष्यत, तदा तस्य क्षेममभविष्यत्। ");
INSERT INTO sandev_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","तदा यिहूदानामा यो जनस्तं परकरेषु समर्पयिष्यति, स उक्तवान्, हे गुरो, स किमहं? ततः स प्रत्युक्तवान्, त्वया सत्यं गदितम्। ");
INSERT INTO sandev_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","अनन्तरं तेषामशनकाले यीशुः पूपमादायेश्वरीयगुणाननूद्य भंक्त्वा शिष्येभ्यः प्रदाय जगाद, मद्वपुःस्वरूपमिमं गृहीत्वा खादत। ");
INSERT INTO sandev_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","पश्चात् स कंसं गृह्लन् ईश्वरीयगुणाननूद्य तेभ्यः प्रदाय कथितवान्, सर्व्वै र्युष्माभिरनेन पातव्यं, ");
INSERT INTO sandev_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","यस्मादनेकेषां पापमर्षणाय पातितं यन्मन्नूत्ननियमरूपशोणितं तदेतत्। ");
INSERT INTO sandev_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","अपरमहं नूत्नगोस्तनीरसं न पास्यामि, तावत् गोस्तनीफलरसं पुनः कदापि न पास्यामि। ");
INSERT INTO sandev_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","पश्चात् ते गीतमेकं संगीय जैतुनाख्यगिरिं गतवन्तः। ");
INSERT INTO sandev_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","तदानीं यीशुस्तानवोचत्, अस्यां रजन्यामहं युष्माकं सर्व्वेषां विघ्नरूपो भविष्यामि, यतो लिखितमास्ते, \"मेषाणां रक्षको यस्तं प्रहरिष्याम्यहं ततः। मेषाणां निवहो नूनं प्रविकीर्णो भविष्यति\"॥ ");
INSERT INTO sandev_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","किन्तु श्मशानात् समुत्थाय युष्माकमग्रेऽहं गालीलं गमिष्यामि। ");
INSERT INTO sandev_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","पितरस्तं प्रोवाच, भवांश्चेत् सर्व्वेषां विघ्नरूपो भवति, तथापि मम न भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ततो यीशुना स उक्तः, तुभ्यमहं तथ्यं कथयामि, यामिन्यामस्यां चरणायुधस्य रवात् पूर्व्वं त्वं मां त्रि र्नाङ्गीकरिष्यसि। ");
INSERT INTO sandev_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ततः पितर उदितवान्, यद्यपि त्वया समं मर्त्तव्यं, तथापि कदापि त्वां न नाङ्गीकरिष्यामि; तथैव सर्व्वे शिष्याश्चोचुः। ");
INSERT INTO sandev_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","अनन्तरं यीशुः शिष्यैः साकं गेत्शिमानीनामकं स्थानं प्रस्थाय तेभ्यः कथितवान्, अदः स्थानं गत्वा यावदहं प्रार्थयिष्ये तावद् यूयमत्रोपविशत। ");
INSERT INTO sandev_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","पश्चात् स पितरं सिवदियसुतौ च सङ्गिनः कृत्वा गतवान्, शोकाकुलोऽतीव व्यथितश्च बभूव। ");
INSERT INTO sandev_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","तानवादीच्च मृतियातनेव मत्प्राणानां यातना जायते, यूयमत्र मया सार्द्धं जागृत। ");
INSERT INTO sandev_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ततः स किञ्चिद्दूरं गत्वाधोमुखः पतन् प्रार्थयाञ्चक्रे, हे मत्पितर्यदि भवितुं शक्नोति, तर्हि कंसोऽयं मत्तो दूरं यातु; किन्तु मदिच्छावत् न भवतु, त्वदिच्छावद् भवतु। ");
INSERT INTO sandev_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ततः स शिष्यानुपेत्य तान् निद्रतो निरीक्ष्य पितराय कथयामास, यूयं मया साकं दण्डमेकमपि जागरितुं नाशन्कुत? ");
INSERT INTO sandev_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","परीक्षायां न पतितुं जागृत प्रार्थयध्वञ्च; आत्मा समुद्यतोस्ति, किन्तु वपु र्दुर्ब्बलं। ");
INSERT INTO sandev_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","स द्वितीयवारं प्रार्थयाञ्चक्रे, हे मत्तात, न पीते यदि कंसमिदं मत्तो दूरं यातुं न शक्नोति, तर्हि त्वदिच्छावद् भवतु। ");
INSERT INTO sandev_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","स पुनरेत्य तान् निद्रतो ददर्श, यतस्तेषां नेत्राणि निद्रया पूर्णान्यासन्। ");
INSERT INTO sandev_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","पश्चात् स तान् विहाय व्रजित्वा तृतीयवारं पूर्व्ववत् कथयन् प्रार्थितवान्। ");
INSERT INTO sandev_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ततः शिष्यानुपागत्य गदितवान्, साम्प्रतं शयानाः किं विश्राम्यथ? पश्यत, समय उपास्थात्, मनुजसुतः पापिनां करेषु समर्प्यते। ");
INSERT INTO sandev_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","उत्तिष्ठत, वयं यामः, यो मां परकरेषु मसर्पयिष्यति, पश्यत, स समीपमायाति। ");
INSERT INTO sandev_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","एतत्कथाकथनकाले द्वादशशिष्याणामेको यिहूदानामको मुख्ययाजकलोकप्राचीनैः प्रहितान् असिधारियष्टिधारिणो मनुजान् गृहीत्वा तत्समीपमुपतस्थौ। ");
INSERT INTO sandev_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","असौ परकरेष्वर्पयिता पूर्व्वं तान् इत्थं सङ्केतयामास, यमहं चुम्बिष्ये, सोऽसौ मनुजः,सएव युष्माभि र्धार्य्यतां। ");
INSERT INTO sandev_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","तदा स सपदि यीशुमुपागत्य हे गुरो, प्रणमामीत्युक्त्वा तं चुचुम्बे। ");
INSERT INTO sandev_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","तदा यीशुस्तमुवाच, हे मित्रं किमर्थमागतोसि? तदा तैरागत्य यीशुराक्रम्य दघ्रे। ");
INSERT INTO sandev_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ततो यीशोः सङ्गिनामेकः करं प्रसार्य्य कोषादसिं बहिष्कृत्य महायाजकस्य दासमेकमाहत्य तस्य कर्णं चिच्छेद। ");
INSERT INTO sandev_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","ततो यीशुस्तं जगाद, खड्गं स्वस्थानेे निधेहि यतो ये ये जना असिं धारयन्ति, तएवासिना विनश्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","अपरं पिता यथा मदन्तिकं स्वर्गीयदूतानां द्वादशवाहिनीतोऽधिकं प्रहिणुयात् मया तमुद्दिश्येदानीमेव तथा प्रार्थयितुं न शक्यते, त्वया किमित्थं ज्ञायते? ");
INSERT INTO sandev_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","तथा सतीत्थं घटिष्यते धर्म्मपुस्तकस्य यदिदं वाक्यं तत् कथं सिध्येत्? ");
INSERT INTO sandev_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","तदानीं यीशु र्जननिवहं जगाद, यूयं खड्गयष्टीन् आदाय मां किं चौरं धर्त्तुमायाताः? अहं प्रत्यहं युष्माभिः साकमुपविश्य समुपादिशं, तदा मां नाधरत; ");
INSERT INTO sandev_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","किन्तु भविष्यद्वादिनां वाक्यानां संसिद्धये सर्व्वमेतदभूत्।तदा सर्व्वे शिष्यास्तं विहाय पलायन्त। ");
INSERT INTO sandev_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","अनन्तरं ते मनुजा यीशुं धृत्वा यत्राध्यापकप्राञ्चः परिषदं कुर्व्वन्त उपाविशन् तत्र कियफानाामकमहायाजकस्यान्तिकं निन्युः। ");
INSERT INTO sandev_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","किन्तु शेषे किं भविष्यतीति वेत्तुं पितरो दूरे तत्पश्चाद् व्रजित्वा महायाजकस्याट्टालिकां प्रविश्य दासैः सहित उपाविशत्। ");
INSERT INTO sandev_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","तदानीं प्रधानयाजकप्राचीनमन्त्रिणः सर्व्वे यीशुं हन्तुं मृषासाक्ष्यम् अलिप्सन्त, ");
INSERT INTO sandev_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","किन्तु न लेभिरे। अनेकेषु मृषासाक्षिष्वागतेष्वपि तन्न प्रापुः। ");
INSERT INTO sandev_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","शेषे द्वौ मृषासाक्षिणावागत्य जगदतुः, पुमानयमकथयत्, अहमीश्वरमन्दिरं भंक्त्वा दिनत्रयमध्ये तन्निर्म्मातुं शक्नोमि। ");
INSERT INTO sandev_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","तदा महायाजक उत्थाय यीशुम् अवादीत्। त्वं किमपि न प्रतिवदसि? त्वामधि किमेते साक्ष्यं वदन्ति? ");
INSERT INTO sandev_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","किन्तु यीशु र्मौनीभूय तस्यौ। ततो महायाजक उक्तवान्, त्वाम् अमरेश्वरनाम्ना शपयामि, त्वमीश्वरस्य पुत्रोऽभिषिक्तो भवसि नवेति वद। ");
INSERT INTO sandev_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","यीशुः प्रत्यवदत्, त्वं सत्यमुक्तवान्; अहं युष्मान् तथ्यं वदामि, इतःपरं मनुजसुतं सर्व्वशक्तिमतो दक्षिणपार्श्वे स्थातुं गगणस्थं जलधरानारुह्यायान्तं वीक्षध्वे। ");
INSERT INTO sandev_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","तदा महायाजको निजवसनं छित्त्वा जगाद, एष ईश्वरं निन्दितवान्, अस्माकमपरसाक्ष्येण किं प्रयोजनं? पश्यत, यूयमेवास्यास्याद् ईश्वरनिन्दां श्रुतवन्तः, ");
INSERT INTO sandev_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","युष्माभिः किं विविच्यते? ते प्रत्यूचुः, वधार्होऽयं। ");
INSERT INTO sandev_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ततो लोकैस्तदास्ये निष्ठीवितं केचित् प्रतलमाहत्य केचिच्च चपेटमाहत्य बभाषिरे, ");
INSERT INTO sandev_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","हे ख्रीष्ट त्वां कश्चपेटमाहतवान्? इति गणयित्वा वदास्मान्। ");
INSERT INTO sandev_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","पितरो बहिरङ्गन उपविशति, तदानीमेका दासी तमुपागत्य बभाषे, त्वं गालीलीययीशोः सहचरएकः। ");
INSERT INTO sandev_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","किन्तु स सर्व्वेषां समक्षम् अनङ्गीकृत्यावादीत्, त्वया यदुच्यते, तदर्थमहं न वेद्मि। ");
INSERT INTO sandev_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","तदा तस्मिन् बहिर्द्वारं गते ऽन्या दासी तं निरीक्ष्य तत्रत्यजनानवदत्, अयमपि नासरतीययीशुना सार्द्धम् आसीत्। ");
INSERT INTO sandev_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","ततः स शपथेन पुनरनङ्गीकृत्य कथितवान्, तं नरं न परिचिनोमि। ");
INSERT INTO sandev_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","क्षणात् परं तिष्ठन्तो जना एत्य पितरम् अवदन्, त्वमवश्यं तेषामेक इति त्वदुच्चारणमेव द्योतयति। ");
INSERT INTO sandev_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","किन्तु सोऽभिशप्य कथितवान्, तं जनं नाहं परिचिनोमि, तदा सपदि कुक्कुटो रुराव। ");
INSERT INTO sandev_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","कुक्कुटरवात् प्राक् त्वं मां त्रिरपाह्नोष्यसे, यैषा वाग् यीशुनावादि तां पितरः संस्मृत्य बहिरित्वा खेदाद् भृशं चक्रन्द। ");
INSERT INTO sandev_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","प्रभाते जाते प्रधानयाजकलोकप्राचीना यीशुं हन्तुं तत्प्रतिकूलं मन्त्रयित्वा ");
INSERT INTO sandev_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","तं बद्व्वा नीत्वा पन्तीयपीलाताख्याधिपे समर्पयामासुः। ");
INSERT INTO sandev_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","ततो यीशोः परकरेव्वर्पयिता यिहूदास्तत्प्राणादण्डाज्ञां विदित्वा सन्तप्तमनाः प्रधानयाजकलोकप्राचीनानां समक्षं तास्त्रींशन्मुद्राः प्रतिदायावादीत्, ");
INSERT INTO sandev_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","एतन्निरागोनरप्राणपरकरार्पणात् कलुषं कृतवानहं। तदा त उदितवन्तः, तेनास्माकं किं? त्वया तद् बुध्यताम्। ");
INSERT INTO sandev_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ततो यिहूदा मन्दिरमध्ये ता मुद्रा निक्षिप्य प्रस्थितवान् इत्वा च स्वयमात्मानमुद्बबन्ध। ");
INSERT INTO sandev_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","पश्चात् प्रधानयाजकास्ता मुद्रा आदाय कथितवन्तः, एता मुद्राः शोणितमूल्यं तस्माद् भाण्डागारे न निधातव्याः। ");
INSERT INTO sandev_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","अनन्तरं ते मन्त्रयित्वा विदेशिनां श्मशानस्थानाय ताभिः कुलालस्य क्षेत्रमक्रीणन्। ");
INSERT INTO sandev_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","अतोऽद्यापि तत्स्थानं रक्तक्षेत्रं वदन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","इत्थं सति इस्रायेलीयसन्तानै र्यस्य मूल्यं निरुपितं, तस्य त्रिंशन्मुद्रामानं मूल्यं ");
INSERT INTO sandev_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","मां प्रति परमेश्वरस्यादेशात् तेभ्य आदीयत, तेन च कुलालस्य क्षेत्रं क्रीतमिति यद्वचनं यिरिमियभविष्यद्वादिना प्रोक्तं तत् तदासिध्यत्। ");
INSERT INTO sandev_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","अनन्तरं यीशौ तदधिपतेः सम्मुख उपतिष्ठति स तं पप्रच्छ, त्वं किं यिहूदीयानां राजा? तदा यीशुस्तमवदत्, त्वं सत्यमुक्तवान्। ");
INSERT INTO sandev_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","किन्तु प्रधानयाजकप्राचीनैरभियुक्तेन तेन किमपि न प्रत्यवादि। ");
INSERT INTO sandev_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","ततः पीलातेन स उदितः, इमे त्वत्प्रतिकूलतः कति कति साक्ष्यं ददति, तत् त्वं न शृणोषि? ");
INSERT INTO sandev_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","तथापि स तेषामेकस्यापि वचस उत्तरं नोदितवान्; तेन सोऽधिपति र्महाचित्रं विदामास। ");
INSERT INTO sandev_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","अन्यच्च तन्महकालेऽधिपतेरेतादृशी रातिरासीत्, प्रजा यं कञ्चन बन्धिनं याचन्ते, तमेव स मोचयतीति। ");
INSERT INTO sandev_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","तदानीं बरब्बानामा कश्चित् ख्यातबन्ध्यासीत्। ");
INSERT INTO sandev_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ततः पीलातस्तत्र मिलितान् लोकान् अपृच्छत्, एष बरब्बा बन्धी ख्रीष्टविख्यातो यीशुश्चैतयोः कं मोचयिष्यामि? युष्माकं किमीप्सितं? ");
INSERT INTO sandev_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","तैरीर्ष्यया स समर्पित इति स ज्ञातवान्। ");
INSERT INTO sandev_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","अपरं विचारासनोपवेशनकाले पीलातस्य पत्नी भृत्यं प्रहित्य तस्मै कथयामास, तं धार्म्मिकमनुजं प्रति त्वया किमपि न कर्त्तव्यं; यस्मात् तत्कृतेऽद्याहं स्वप्ने प्रभूतकष्टमलभे। ");
INSERT INTO sandev_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","अनन्तरं प्रधानयाजकप्राचीना बरब्बां याचित्वादातुं यीशुञ्च हन्तुं सकललोकान् प्रावर्त्तयन्। ");
INSERT INTO sandev_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ततोऽधिपतिस्तान् पृष्टवान्, एतयोः कमहं मोचयिष्यामि? युष्माकं केच्छा? ते प्रोचु र्बरब्बां। ");
INSERT INTO sandev_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","तदा पीलातः पप्रच्छ, तर्हि यं ख्रीष्टं वदन्ति, तं यीशुं किं करिष्यामि? सर्व्वे कथयामासुः, स क्रुशेन विध्यतां। ");
INSERT INTO sandev_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ततोऽधिपतिरवादीत्, कुतः? किं तेनापराद्धं? किन्तु ते पुनरुचै र्जगदुः, स क्रुशेन विध्यतां। ");
INSERT INTO sandev_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","तदा निजवाक्यमग्राह्यमभूत्, कलहश्चाप्यभूत्, पीलात इति विलोक्य लोकानां समक्षं तोयमादाय करौ प्रक्षाल्यावोचत्, एतस्य धार्म्मिकमनुष्यस्य शोणितपाते निर्दोषोऽहं, युष्माभिरेव तद् बुध्यतां। ");
INSERT INTO sandev_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","तदा सर्व्वाः प्रजाः प्रत्यवोचन्, तस्य शोणितपातापराधोऽस्माकम् अस्मत्सन्तानानाञ्चोपरि भवतु। ");
INSERT INTO sandev_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","ततः स तेषां समीपे बरब्बां मोचयामास यीशुन्तु कषाभिराहत्य क्रुशेन वेधितुं समर्पयामास। ");
INSERT INTO sandev_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","अनन्तरम् अधिपतेः सेना अधिपते र्गृहं यीशुमानीय तस्य समीपे सेनासमूहं संजगृहुः। ");
INSERT INTO sandev_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ततस्ते तस्य वसनं मोचयित्वा कृष्णलोहितवर्णवसनं परिधापयामासुः ");
INSERT INTO sandev_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","कण्टकानां मुकुटं निर्म्माय तच्छिरसि ददुः, तस्य दक्षिणकरे वेत्रमेकं दत्त्वा तस्य सम्मुखे जानूनि पातयित्वा, हे यिहूदीयानां राजन्, तुभ्यं नम इत्युक्त्वा तं तिरश्चक्रुः, ");
INSERT INTO sandev_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ततस्तस्य गात्रे निष्ठीवं दत्वा तेन वेत्रेण शिर आजघ्नुः। ");
INSERT INTO sandev_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","इत्थं तं तिरस्कृत्य तद् वसनं मोचयित्वा पुनर्निजवसनं परिधापयाञ्चक्रुः, तं क्रुशेन वेधितुं नीतवन्तः। ");
INSERT INTO sandev_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","पश्चात्ते बहिर्भूय कुरीणीयं शिमोन्नामकमेकं विलोक्य क्रुशं वोढुं तमाददिरे। ");
INSERT INTO sandev_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","अनन्तरं गुल्गल्ताम् अर्थात् शिरस्कपालनामकस्थानमु पस्थाय ते यीशवे पित्तमिश्रिताम्लरसं पातुं ददुः, ");
INSERT INTO sandev_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","किन्तु स तमास्वाद्य न पपौ। ");
INSERT INTO sandev_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","तदानीं ते तं क्रुशेन संविध्य तस्य वसनानि गुटिकापातेन विभज्य जगृहुः, तस्मात्, विभजन्तेऽधरीयं मे ते मनुष्याः परस्परं। मदुत्तरीयवस्त्रार्थं गुटिकां पातयन्ति च॥यदेतद्वचनं भविष्यद्वादिभिरुक्तमासीत्, तदा तद् असिध्यत्, ");
INSERT INTO sandev_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","पश्चात् ते तत्रोपविश्य तद्रक्षणकर्व्वणि नियुक्तास्तस्थुः। ");
INSERT INTO sandev_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","अपरम् एष यिहूदीयानां राजा यीशुरित्यपवादलिपिपत्रं तच्छिरस ऊर्द्व्वे योजयामासुः। ");
INSERT INTO sandev_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ततस्तस्य वामे दक्षिणे च द्वौ चैरौ तेन साकं क्रुशेन विविधुः। ");
INSERT INTO sandev_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","तदा पान्था निजशिरो लाडयित्वा तं निन्दन्तो जगदुः, ");
INSERT INTO sandev_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","हे ईश्वरमन्दिरभञ्जक दिनत्रये तन्निर्म्मातः स्वं रक्ष, चेत्त्वमीश्वरसुतस्तर्हि क्रुशादवरोह। ");
INSERT INTO sandev_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","प्रधानयाजकाध्यापकप्राचीनाश्च तथा तिरस्कृत्य जगदुः, ");
INSERT INTO sandev_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","सोऽन्यजनानावत्, किन्तु स्वमवितुं न शक्नोति। यदीस्रायेलो राजा भवेत्, तर्हीदानीमेव क्रुशादवरोहतु, तेन तं वयं प्रत्येष्यामः। ");
INSERT INTO sandev_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","स ईश्वरे प्रत्याशामकरोत्, यदीश्वरस्तस्मिन् सन्तुष्टस्तर्हीदानीमेव तमवेत्, यतः स उक्तवान् अहमीश्वरसुतः। ");
INSERT INTO sandev_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","यौ स्तेनौ साकं तेन क्रुशेन विद्धौ तौ तद्वदेव तं निनिन्दतुः। ");
INSERT INTO sandev_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","तदा द्वितीययामात् तृतीययामं यावत् सर्व्वदेशे तमिरं बभूव, ");
INSERT INTO sandev_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","तृतीययामे \"एली एली लामा शिवक्तनी\", अर्थात् मदीश्वर मदीश्वर कुतो मामत्याक्षीः? यीशुरुच्चैरिति जगाद। ");
INSERT INTO sandev_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","तदा तत्र स्थिताः केचित् तत् श्रुत्वा बभाषिरे, अयम् एलियमाहूयति। ");
INSERT INTO sandev_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","तेषां मध्याद् एकः शीघ्रं गत्वा स्पञ्जं गृहीत्वा तत्राम्लरसं दत्त्वा नलेन पातुं तस्मै ददौ। ");
INSERT INTO sandev_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","इतरेऽकथयन् तिष्ठत, तं रक्षितुम् एलिय आयाति नवेति पश्यामः। ");
INSERT INTO sandev_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","यीशुः पुनरुचैराहूय प्राणान् जहौ। ");
INSERT INTO sandev_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","ततो मन्दिरस्य विच्छेदवसनम् ऊर्द्व्वादधो यावत् छिद्यमानं द्विधाभवत्, ");
INSERT INTO sandev_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","भूमिश्चकम्पे भूधरोव्यदीर्य्यत च। श्मशाने मुक्ते भूरिपुण्यवतां सुप्तदेहा उदतिष्ठन्, ");
INSERT INTO sandev_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","श्मशानाद् वहिर्भूय तदुत्थानात् परं पुण्यपुरं गत्वा बहुजनान् दर्शयामासुः। ");
INSERT INTO sandev_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","यीशुरक्षणाय नियुक्तः शतसेनापतिस्तत्सङ्गिनश्च तादृशीं भूकम्पादिघटनां दृष्ट्वा भीता अवदन्, एष ईश्वरपुत्रो भवति। ");
INSERT INTO sandev_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","या बहुयोषितो यीशुं सेवमाना गालीलस्तत्पश्चादागतास्तासां मध्ये ");
INSERT INTO sandev_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","मग्दलीनी मरियम् याकूब्योश्यो र्माता या मरियम् सिबदियपुत्रयो र्माता च योषित एता दूरे तिष्ठन्त्यो ददृशुः। ");
INSERT INTO sandev_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","सन्ध्यायां सत्यम् अरिमथियानगरस्य यूषफ्नामा धनी मनुजो यीशोः शिष्यत्वात् ");
INSERT INTO sandev_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","पीलातस्य समीपं गत्वा यीशोः कायं ययाचे, तेन पीलातः कायं दातुम् आदिदेश। ");
INSERT INTO sandev_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","यूषफ् तत्कायं नीत्वा शुचिवस्त्रेणाच्छाद्य ");
INSERT INTO sandev_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","स्वार्थं शैले यत् श्मशानं चखान, तन्मध्ये तत्कायं निधाय तस्य द्वारि वृहत्पाषाणं ददौ। ");
INSERT INTO sandev_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","किन्तु मग्दलीनी मरियम् अन्यमरियम् एते स्त्रियौ तत्र श्मशानसम्मुख उपविविशतुः। ");
INSERT INTO sandev_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","तदनन्तरं निस्तारोत्सवस्यायोजनदिनात् परेऽहनि प्रधानयाजकाः फिरूशिनश्च मिलित्वा पीलातमुपागत्याकथयन्, ");
INSERT INTO sandev_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","हे महेच्छ स प्रतारको जीवन अकथयत्, दिनत्रयात् परं श्मशानादुत्थास्यामि तद्वाक्यं स्मरामो वयं; ");
INSERT INTO sandev_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","तस्मात् तृतीयदिनं यावत् तत् श्मशानं रक्षितुमादिशतु, नोचेत् तच्छिष्या यामिन्यामागत्य तं हृत्वा लोकान् वदिष्यन्ति, स श्मशानादुदतिष्ठत्, तथा सति प्रथमभ्रान्तेः शेषीयभ्रान्ति र्महती भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","तदा पीलात अवादीत्, युष्माकं समीपे रक्षिगण आस्ते, यूयं गत्वा यथा साध्यं रक्षयत। ");
INSERT INTO sandev_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ततस्ते गत्वा तद्दूारपाषाणं मुद्राङ्कितं कृत्वा रक्षिगणं नियोज्य श्मशानं रक्षयामासुः। ");
INSERT INTO sandev_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ततः परं विश्रामवारस्य शेषे सप्ताहप्रथमदिनस्य प्रभोते जाते मग्दलीनी मरियम् अन्यमरियम् च श्मशानं द्रष्टुमागता। ");
INSERT INTO sandev_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","तदा महान् भूकम्पोऽभवत्; परमेश्वरीयदूतः स्वर्गादवरुह्य श्मशानद्वारात् पाषाणमपसार्य्य तदुपर्य्युपविवेश। ");
INSERT INTO sandev_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","तद्वदनं विद्युद्वत् तेजोमयं वसनं हिमशुभ्रञ्च। ");
INSERT INTO sandev_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","तदानीं रक्षिणस्तद्भयात् कम्पिता मृतवद् बभूवः। ");
INSERT INTO sandev_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","स दूतो योषितो जगाद, यूयं मा भैष्ट, क्रुशहतयीशुं मृगयध्वे तदहं वेद्मि। ");
INSERT INTO sandev_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","सोऽत्र नास्ति, यथावदत् तथोत्थितवान्; एतत् प्रभोः शयनस्थानं पश्यत। ");
INSERT INTO sandev_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","तूर्णं गत्वा तच्छिष्यान् इति वदत, स श्मशानाद् उदतिष्ठत्, युष्माकमग्रे गालीलं यास्यति यूयं तत्र तं वीक्षिष्यध्वे, पश्यताहं वार्त्तामिमां युष्मानवादिषं। ");
INSERT INTO sandev_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ततस्ता भयात् महानन्दाञ्च श्मशानात् तूर्णं बहिर्भूय तच्छिष्यान् वार्त्तां वक्तुं धावितवत्यः। किन्तु शिष्यान् वार्त्तां वक्तुं यान्ति, तदा यीशु र्दर्शनं दत्त्वा ता जगाद, ");
INSERT INTO sandev_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","युष्माकं कल्याणं भूयात्, ततस्ता आगत्य तत्पादयोः पतित्वा प्रणेमुः। ");
INSERT INTO sandev_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","यीशुस्ता अवादीत्, मा बिभीत, यूयं गत्वा मम भ्रातृन् गालीलं यातुं वदत, तत्र ते मां द्रक्ष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","स्त्रियो गच्छन्ति, तदा रक्षिणां केचित् पुरं गत्वा यद्यद् घटितं तत्सर्व्वं प्रधानयाजकान् ज्ञापितवन्तः। ");
INSERT INTO sandev_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","ते प्राचीनैः समं संसदं कृत्वा मन्त्रयन्तो बहुमुद्राः सेनाभ्यो दत्त्वावदन्, ");
INSERT INTO sandev_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","अस्मासु निद्रितेषु तच्छिष्या यामिन्यामागत्य तं हृत्वानयन्, इति यूयं प्रचारयत। ");
INSERT INTO sandev_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","यद्येतदधिपतेः श्रोत्रगोचरीभवेत्, तर्हि तं बोधयित्वा युष्मानविष्यामः। ");
INSERT INTO sandev_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","ततस्ते मुद्रा गृहीत्वा शिक्षानुरूपं कर्म्म चक्रुः, यिहूदीयानां मध्ये तस्याद्यापि किंवदन्ती विद्यते। ");
INSERT INTO sandev_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","एकादश शिष्या यीशुनिरूपितागालीलस्याद्रिं गत्वा ");
INSERT INTO sandev_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","तत्र तं संवीक्ष्य प्रणेमुः, किन्तु केचित् सन्दिग्धवन्तः। ");
INSERT INTO sandev_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","यीशुस्तेषां समीपमागत्य व्याहृतवान्, स्वर्गमेदिन्योः सर्व्वाधिपतित्वभारो मय्यर्पित आस्ते। ");
INSERT INTO sandev_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","अतो यूयं प्रयाय सर्व्वदेशीयान् शिष्यान् कृत्वा पितुः पुत्रस्य पवित्रस्यात्मनश्च नाम्ना तानवगाहयत; अहं युष्मान् यद्यदादिशं तदपि पालयितुं तानुपादिशत। ");
INSERT INTO sandev_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","पश्यत, जगदन्तं यावत् सदाहं युष्माभिः साकं तिष्ठामि। इति।");
INSERT INTO sandev_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ईश्वरपुत्रस्य यीशुख्रीष्टस्य सुसंवादारम्भः। ");
INSERT INTO sandev_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","भविष्यद्वादिनां ग्रन्थेषु लिपिरित्थमास्ते, पश्य स्वकीयदूतन्तु तवाग्रे प्रेषयाम्यहम्। गत्वा त्वदीयपन्थानं स हि परिष्करिष्यति। ");
INSERT INTO sandev_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","\"परमेशस्य पन्थानं परिष्कुरुत सर्व्वतः। तस्य राजपथञ्चैव समानं कुरुताधुना।\" इत्येतत् प्रान्तरे वाक्यं वदतः कस्यचिद्रवः॥ ");
INSERT INTO sandev_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","सएव योहन् प्रान्तरे मज्जितवान् तथा पापमार्जननिमित्तं मनोव्यावर्त्तकमज्जनस्य कथाञ्च प्रचारितवान्। ");
INSERT INTO sandev_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ततो यिहूदादेशयिरूशालम्नगरनिवासिनः सर्व्वे लोका बहि र्भूत्वा तस्य समीपमागत्य स्वानि स्वानि पापान्यङ्गीकृत्य यर्द्दननद्यां तेन मज्जिता बभूवुः। ");
INSERT INTO sandev_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","अस्य योहनः परिधेयानि क्रमेलकलोमजानि, तस्य कटिबन्धनं चर्म्मजातम्, तस्य भक्ष्याणि च शूककीटा वन्यमधूनि चासन्। ");
INSERT INTO sandev_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","स प्रचारयन् कथयाञ्चक्रे, अहं नम्रीभूय यस्य पादुकाबन्धनं मोचयितुमपि न योग्योस्मि, तादृशो मत्तो गुरुतर एकः पुरुषो मत्पश्चादागच्छति। ");
INSERT INTO sandev_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","अहं युष्मान् जले मज्जितवान् किन्तु स पवित्र आत्मानि संमज्जयिष्यति। ");
INSERT INTO sandev_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","अपरञ्च तस्मिन्नेव काले गालील्प्रदेशस्य नासरद्ग्रामाद् यीशुरागत्य योहना यर्द्दननद्यां मज्जितोऽभूत्। ");
INSERT INTO sandev_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","स जलादुत्थितमात्रो मेघद्वारं मुक्तं कपोतवत् स्वस्योपरि अवरोहन्तमात्मानञ्च दृष्टवान्। ");
INSERT INTO sandev_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","त्वं मम प्रियः पुत्रस्त्वय्येव मममहासन्तोष इयमाकाशीया वाणी बभूव। ");
INSERT INTO sandev_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","तस्मिन् काले आत्मा तं प्रान्तरमध्यं निनाय। ");
INSERT INTO sandev_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","अथ स चत्वारिंशद्दिनानि तस्मिन् स्थाने वन्यपशुभिः सह तिष्ठन् शैताना परीक्षितः; पश्चात् स्वर्गीयदूतास्तं सिषेविरे। ");
INSERT INTO sandev_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","अनन्तरं योहनि बन्धनालये बद्धे सति यीशु र्गालील्प्रदेशमागत्य ईश्वरराज्यस्य सुसंवादं प्रचारयन् कथयामास, ");
INSERT INTO sandev_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","कालः सम्पूर्ण ईश्वरराज्यञ्च समीपमागतं; अतोहेतो र्यूयं मनांसि व्यावर्त्तयध्वं सुसंवादे च विश्वासित। ");
INSERT INTO sandev_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","तदनन्तरं स गालीलीयसमुद्रस्य तीरे गच्छन् शिमोन् तस्य भ्राता अन्द्रियनामा च इमौ द्वौ जनौ मत्स्यधारिणौ सागरमध्ये जालं प्रक्षिपन्तौ दृष्ट्वा ताववदत्, ");
INSERT INTO sandev_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","युवां मम पश्चादागच्छतं, युवामहं मनुष्यधारिणौ करिष्यामि। ");
INSERT INTO sandev_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ततस्तौ तत्क्षणमेव जालानि परित्यज्य तस्य पश्चात् जग्मतुः। ");
INSERT INTO sandev_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ततः परं तत्स्थानात् किञ्चिद् दूरं गत्वा स सिवदीपुत्रयाकूब् तद्भ्रातृयोहन् च इमौ नौकायां जालानां जीर्णमुद्धारयन्तौ दृष्ट्वा तावाहूयत्। ");
INSERT INTO sandev_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ततस्तौ नौकायां वेतनभुग्भिः सहितं स्वपितरं विहाय तत्पश्चादीयतुः। ");
INSERT INTO sandev_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ततः परं कफर्नाहूम्नामकं नगरमुपस्थाय स विश्रामदिवसे भजनग्रहं प्रविश्य समुपदिदेश। ");
INSERT INTO sandev_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","तस्योपदेशाल्लोका आश्चर्य्यं मेनिरे यतः सोध्यापकाइव नोपदिशन् प्रभाववानिव प्रोपदिदेश। ");
INSERT INTO sandev_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","अपरञ्च तस्मिन् भजनगृहे अपवित्रभूतेन ग्रस्त एको मानुष आसीत्। स चीत्शब्दं कृत्वा कथयाञ्चके ");
INSERT INTO sandev_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","भो नासरतीय यीशो त्वमस्मान् त्यज, त्वया सहास्माकं कः सम्बन्धः? त्वं किमस्मान् नाशयितुं समागतः? त्वमीश्वरस्य पवित्रलोक इत्यहं जानामि। ");
INSERT INTO sandev_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","तदा यीशुस्तं तर्जयित्वा जगाद तूष्णीं भव इतो बहिर्भव च। ");
INSERT INTO sandev_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ततः सोऽपवित्रभूतस्तं सम्पीड्य अत्युचैश्चीत्कृत्य निर्जगाम। ");
INSERT INTO sandev_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","तेनैव सर्व्वे चमत्कृत्य परस्परं कथयाञ्चक्रिरे, अहो किमिदं? कीदृशोऽयं नव्य उपदेशः? अनेन प्रभावेनापवित्रभूतेष्वाज्ञापितेषु ते तदाज्ञानुवर्त्तिनो भवन्ति। ");
INSERT INTO sandev_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","तदा तस्य यशो गालीलश्चतुर्दिक्स्थसर्व्वदेशान् व्याप्नोत्। ");
INSERT INTO sandev_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","अपरञ्च ते भजनगृहाद् बहि र्भूत्वा याकूब्योहन्भ्यां सह शिमोन आन्द्रियस्य च निवेशनं प्रविविशुः। ");
INSERT INTO sandev_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","तदा पितरस्य श्वश्रूर्ज्वरपीडिता शय्यायामास्त इति ते तं झटिति विज्ञापयाञ्चक्रुः। ");
INSERT INTO sandev_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ततः स आगत्य तस्या हस्तं धृत्वा तामुदस्थापयत्; तदैव तां ज्वरोऽत्याक्षीत् ततः परं सा तान् सिषेवे। ");
INSERT INTO sandev_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","अथास्तं गते रवौ सन्ध्याकाले सति लोकास्तत्समीपं सर्व्वान् रोगिणो भूतधृतांश्च समानिन्युः। ");
INSERT INTO sandev_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","सर्व्वे नागरिका लोका द्वारि संमिलिताश्च। ");
INSERT INTO sandev_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ततः स नानाविधरोगिणो बहून् मनुजानरोगिणश्चकार तथा बहून् भूतान् त्याजयाञ्चकार तान् भूतान् किमपि वाक्यं वक्तुं निषिषेध च यतोहेतोस्ते तमजानन्। ");
INSERT INTO sandev_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","अपरञ्च सोऽतिप्रत्यूषे वस्तुतस्तु रात्रिशेषे समुत्थाय बहिर्भूय निर्जनं स्थानं गत्वा तत्र प्रार्थयाञ्चक्रे। ");
INSERT INTO sandev_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","अनन्तरं शिमोन् तत्सङ्गिनश्च तस्य पश्चाद् गतवन्तः। ");
INSERT INTO sandev_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","तदुद्देशं प्राप्य तमवदन् सर्व्वे लोकास्त्वां मृगयन्ते। ");
INSERT INTO sandev_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","तदा सोऽकथयत् आगच्छत वयं समीपस्थानि नगराणि यामः, यतोऽहं तत्र कथां प्रचारयितुं बहिरागमम्। ");
INSERT INTO sandev_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","अथ स तेषां गालील्प्रदेशस्य सर्व्वेषु भजनगृहेषु कथाः प्रचारयाञ्चक्रे भूतानत्याजयञ्च। ");
INSERT INTO sandev_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","अनन्तरमेकः कुष्ठी समागत्य तत्सम्मुखे जानुपातं विनयञ्च कृत्वा कथितवान् यदि भवान् इच्छति तर्हि मां परिष्कर्त्तुं शक्नोति। ");
INSERT INTO sandev_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ततः कृपालु र्यीशुः करौ प्रसार्य्य तं स्पष्ट्वा कथयामास ");
INSERT INTO sandev_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ममेच्छा विद्यते त्वं परिष्कृतो भव। एतत्कथायाः कथनमात्रात् स कुष्ठी रोगान्मुक्तः परिष्कृतोऽभवत्। ");
INSERT INTO sandev_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","तदा स तं विसृजन् गाढमादिश्य जगाद ");
INSERT INTO sandev_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","सावधानो भव कथामिमां कमपि मा वद; स्वात्मानं याजकं दर्शय, लोकेभ्यः स्वपरिष्कृतेः प्रमाणदानाय मूसानिर्णीतं यद्दानं तदुत्सृजस्व च। ");
INSERT INTO sandev_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","किन्तु स गत्वा तत् कर्म्म इत्थं विस्तार्य्य प्रचारयितुं प्रारेभे तेनैव यीशुः पुनः सप्रकाशं नगरं प्रवेष्टुं नाशक्नोत् ततोहेतोर्बहिः काननस्थाने तस्यौ; तथापि चतुर्द्दिग्भ्यो लोकास्तस्य समीपमाययुः। ");
INSERT INTO sandev_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","तदनन्तरं यीशै कतिपयदिनानि विलम्ब्य पुनः कफर्नाहूम्नगरं प्रविष्टे स गृह आस्त इति किंवदन्त्या तत्क्षणं तत्समीपं बहवो लोका आगत्य समुपतस्थुः, ");
INSERT INTO sandev_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","तस्माद् गृहमध्ये सर्व्वेषां कृते स्थानं नाभवद् द्वारस्य चतुर्दिक्ष्वपि नाभवत्, तत्काले स तान् प्रति कथां प्रचारयाञ्चक्रे। ");
INSERT INTO sandev_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ततः परं लोकाश्चतुर्भि र्मानवैरेकं पक्षाघातिनं वाहयित्वा तत्समीपम् आनिन्युः। ");
INSERT INTO sandev_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","किन्तु जनानां बहुत्वात् तं यीशोः सम्मुखमानेतुं न शक्नुवन्तो यस्मिन् स्थाने स आस्ते तदुपरिगृहपृष्ठं खनित्वा छिद्रं कृत्वा तेन मार्गेण सशय्यं पक्षाघातिनम् अवरोहयामासुः। ");
INSERT INTO sandev_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ततो यीशुस्तेषां विश्वासं दृष्ट्वा तं पक्षाघातिनं बभाषे हे वत्स तव पापानां मार्जनं भवतु। ");
INSERT INTO sandev_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","तदा कियन्तोऽध्यापकास्तत्रोपविशन्तो मनोभि र्वितर्कयाञ्चक्रुः, एष मनुष्य एतादृशीमीश्वरनिन्दां कथां कुतः कथयति? ");
INSERT INTO sandev_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","ईश्वरं विना पापानि मार्ष्टुं कस्य सामर्थ्यम् आस्ते? ");
INSERT INTO sandev_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","इत्थं ते वितर्कयन्ति यीशुस्तत्क्षणं मनसा तद् बुद्व्वा तानवदद् यूयमन्तःकरणैः कुत एतानि वितर्कयथ? ");
INSERT INTO sandev_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","तदनन्तरं यीशुस्तत्स्थानात् पुनः समुद्रतटं ययौ; लोकनिवहे तत्समीपमागते स तान् समुपदिदेश। ");
INSERT INTO sandev_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","किन्तु पृथिव्यां पापानि मार्ष्टुं मनुष्यपुत्रस्य सामर्थ्यमस्ति, एतद् युष्मान् ज्ञापयितुं (स तस्मै पक्षाघातिने कथयामास) ");
INSERT INTO sandev_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","उत्तिष्ठ तव शय्यां गृहीत्वा स्वगृहं याहि, अहं त्वामिदम् आज्ञापयामि। ");
INSERT INTO sandev_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ततः स तत्क्षणम् उत्थाय शय्यां गृहीत्वा सर्व्वेषां साक्षात् जगाम; सर्व्वे विस्मिता एतादृशं कर्म्म वयम् कदापि नापश्याम, इमां कथां कथयित्वेश्वरं धन्यमब्रुवन्। ");
INSERT INTO sandev_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","तदनन्तरं यीशुस्तत्स्थानात् पुनः समुद्रतटं ययौ; लोकनिवहे तत्समीपमागते स तान् समुपदिदेश। ");
INSERT INTO sandev_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","अथ गच्छन् करसञ्चयगृह उपविष्टम् आल्फीयपुत्रं लेविं दृष्ट्वा तमाहूय कथितवान् मत्पश्चात् त्वामामच्छ ततः स उत्थाय तत्पश्चाद् ययौ। ");
INSERT INTO sandev_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","अनन्तरं यीशौ तस्य गृहे भोक्तुम् उपविष्टे बहवः करमञ्चायिनः पापिनश्च तेन तच्छिष्यैश्च सहोपविविशुः, यतो बहवस्तत्पश्चादाजग्मुः। ");
INSERT INTO sandev_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","तदा स करमञ्चायिभिः पापिभिश्च सह खादति, तद् दृष्ट्वाध्यापकाः फिरूशिनश्च तस्य शिष्यानूचुः करमञ्चायिभिः पापिभिश्च सहायं कुतो भुंक्ते पिवति च? ");
INSERT INTO sandev_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","तद्वाक्यं श्रुत्वा यीशुः प्रत्युवाच,अरोगिलोकानां चिकित्सकेन प्रयोजनं नास्ति, किन्तु रोगिणामेव; अहं धार्म्मिकानाह्वातुं नागतः किन्तु मनो व्यावर्त्तयितुं पापिन एव। ");
INSERT INTO sandev_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ततः परं योहनः फिरूशिनाञ्चोपवासाचारिशिष्या यीशोः समीपम् आगत्य कथयामासुः, योहनः फिरूशिनाञ्च शिष्या उपवसन्ति किन्तु भवतः शिष्या नोपवसन्ति किं कारणमस्य? ");
INSERT INTO sandev_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","तदा यीशुस्तान् बभाषे यावत् कालं सखिभिः सह कन्याया वरस्तिष्ठति तावत्कालं ते किमुपवस्तुं शक्नुवन्ति? यावत्कालं वरस्तैः सह तिष्ठति तावत्कालं त उपवस्तुं न शक्नुवन्ति। ");
INSERT INTO sandev_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","यस्मिन् काले तेभ्यः सकाशाद् वरो नेष्यते स काल आगच्छति, तस्मिन् काले ते जना उपवत्स्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","कोपि जनः पुरातनवस्त्रे नूतनवस्त्रं न सीव्यति, यतो नूतनवस्त्रेण सह सेवने कृते जीर्णं वस्त्रं छिद्यते तस्मात् पुन र्महत् छिद्रं जायते। ");
INSERT INTO sandev_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","कोपि जनः पुरातनकुतूषु नूतनं द्राक्षारसं न स्थापयति, यतो नूतनद्राक्षारसस्य तेजसा ताः कुत्वो विदीर्य्यन्ते ततो द्राक्षारसश्च पतति कुत्वश्च नश्यन्ति, अतएव नूतनद्राक्षारसो नूतनकुतूषु स्थापनीयः। ");
INSERT INTO sandev_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","तदनन्तरं यीशु र्यदा विश्रामवारे शस्यक्षेत्रेण गच्छति तदा तस्य शिष्या गच्छन्तः शस्यमञ्जरीश्छेत्तुं प्रवृत्ताः। ");
INSERT INTO sandev_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","अतः फिरूशिनो यीशवे कथयामासुः पश्यतु विश्रामवासरे यत् कर्म्म न कर्त्तव्यं तद् इमे कुतः कुर्व्वन्ति? ");
INSERT INTO sandev_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","तदा स तेभ्योऽकथयत् दायूद् तत्संङ्गिनश्च भक्ष्याभावात् क्षुधिताः सन्तो यत् कर्म्म कृतवन्तस्तत् किं युष्माभि र्न पठितम्? ");
INSERT INTO sandev_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","अबियाथर्नामके महायाजकतां कुर्व्वति स कथमीश्वरस्यावासं प्रविश्य ये दर्शनीयपूपा याजकान् विनान्यस्य कस्यापि न भक्ष्यास्तानेव बुभुजे सङ्गिलोकेभ्योऽपि ददौ। ");
INSERT INTO sandev_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","सोऽपरमपि जगाद, विश्रामवारो मनुष्यार्थमेव निरूपितोऽस्ति किन्तु मनुष्यो विश्रामवारार्थं नैव। ");
INSERT INTO sandev_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","मनुष्यपुत्रो विश्रामवारस्यापि प्रभुरास्ते। ");
INSERT INTO sandev_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","अनन्तरं यीशुः पुन र्भजनगृहं प्रविष्टस्तस्मिन् स्थाने शुष्कहस्त एको मानव आसीत्। ");
INSERT INTO sandev_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","स विश्रामवारे तमरोगिणं करिष्यति नवेत्यत्र बहवस्तम् अपवदितुं छिद्रमपेक्षितवन्तः। ");
INSERT INTO sandev_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","तदा स तं शुष्कहस्तं मनुष्यं जगाद मध्यस्थाने त्वमुत्तिष्ठ। ");
INSERT INTO sandev_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ततः परं स तान् पप्रच्छ विश्रामवारे हितमहितं तथा हि प्राणरक्षा वा प्राणनाश एषां मध्ये किं करणीयं ? किन्तु ते निःशब्दास्तस्थुः। ");
INSERT INTO sandev_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","तदा स तेषामन्तःकरणानां काठिन्याद्धेतो र्दुःखितः क्रोधात् चर्तुिदशो दृष्टवान् तं मानुषं गदितवान् तं हस्तं विस्तारय, ततस्तेन हस्ते विस्तृते तद्धस्तोऽन्यहस्तवद् अरोगो जातः। ");
INSERT INTO sandev_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","अथ फिरूशिनः प्रस्थाय तं नाशयितुं हेरोदीयैः सह मन्त्रयितुमारेभिरे। ");
INSERT INTO sandev_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","अतएव यीशुस्तत्स्थानं परित्यज्य शिष्यैः सह पुनः सागरसमीपं गतः; ");
INSERT INTO sandev_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ततो गालील्यिहूदा-यिरूशालम्-इदोम्-यर्दन्नदीपारस्थानेभ्यो लोकसमूहस्तस्य पश्चाद् गतः; तदन्यः सोरसीदनोः समीपवासिलोकसमूहश्च तस्य महाकर्म्मणां वार्त्तं श्रुत्वा तस्य सन्निधिमागतः। ");
INSERT INTO sandev_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","तदा लोकसमूहश्चेत् तस्योपरि पतति इत्याशङ्क्य स नावमेकां निकटे स्थापयितुं शिष्यानादिष्टवान्। ");
INSERT INTO sandev_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","यतोऽनेकमनुष्याणामारोग्यकरणाद् व्याधिग्रस्ताः सर्व्वे तं स्प्रष्टुं परस्परं बलेन यत्नवन्तः। ");
INSERT INTO sandev_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","अपरञ्च अपवित्रभूतास्तं दृष्ट्वा तच्चरणयोः पतित्वा प्रोचैः प्रोचुः, त्वमीश्वरस्य पुत्रः। ");
INSERT INTO sandev_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","किन्तु स तान् दृढम् आज्ञाप्य स्वं परिचायितुं निषिद्धवान्। ");
INSERT INTO sandev_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","अनन्तरं स पर्व्वतमारुह्य यं यं प्रतिच्छा तं तमाहूतवान् ततस्ते तत्समीपमागताः। ");
INSERT INTO sandev_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","तदा स द्वादशजनान् स्वेन सह स्थातुं सुसंवादप्रचाराय प्रेरिता भवितुं ");
INSERT INTO sandev_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","सर्व्वप्रकारव्याधीनां शमनकरणाय प्रभावं प्राप्तुं भूतान् त्याजयितुञ्च नियुक्तवान्। ");
INSERT INTO sandev_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","तेषां नामानीमानि, शिमोन् सिवदिपुत्रो ");
INSERT INTO sandev_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","याकूब् तस्य भ्राता योहन् च आन्द्रियः फिलिपो बर्थलमयः, ");
INSERT INTO sandev_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","मथी थोमा च आल्फीयपुत्रो याकूब् थद्दीयः किनानीयः शिमोन् यस्तं परहस्तेष्वर्पयिष्यति स ईष्करियोतीययिहूदाश्च। ");
INSERT INTO sandev_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","स शिमोने पितर इत्युपनाम ददौ याकूब्योहन्भ्यां च बिनेरिगिश् अर्थतो मेघनादपुत्रावित्युपनाम ददौ। ");
INSERT INTO sandev_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","अनन्तरं ते निवेशनं गताः, किन्तु तत्रापि पुनर्महान् जनसमागमो ऽभवत् तस्मात्ते भोक्तुमप्यवकाशं न प्राप्ताः। ");
INSERT INTO sandev_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ततस्तस्य सुहृल्लोका इमां वार्त्तां प्राप्य स हतज्ञानोभूद् इति कथां कथयित्वा तं धृत्वानेतुं गताः। ");
INSERT INTO sandev_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","अपरञ्च यिरूशालम आगता ये येऽध्यापकास्ते जगदुरयं पुरुषो भूतपत्याबिष्टस्तेन भूतपतिना भूतान् त्याजयति। ");
INSERT INTO sandev_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","ततस्तानाहूय यीशु र्दृष्टान्तैः कथां कथितवान् शैतान् कथं शैतानं त्याजयितुं शक्नोति? ");
INSERT INTO sandev_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","किञ्चन राज्यं यदि स्वविरोधेन पृथग् भवति तर्हि तद् राज्यं स्थिरं स्थातुं न शक्नोति। ");
INSERT INTO sandev_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","तथा कस्यापि परिवारो यदि परस्परं विरोधी भवति तर्हि सोपि परिवारः स्थिरं स्थातुं न शक्नोति। ");
INSERT INTO sandev_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","तद्वत् शैतान् यदि स्वविपक्षतया उत्तिष्ठन् भिन्नो भवति तर्हि सोपि स्थिरं स्थातुं न शक्नोति किन्तूच्छिन्नो भवति। ");
INSERT INTO sandev_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","अपरञ्च प्रबलं जनं प्रथमं न बद्धा कोपि तस्य गृहं प्रविश्य द्रव्याणि लुण्ठयितुं न शक्नोति, तं बद्व्वैव तस्य गृहस्य द्रव्याणि लुण्ठयितुं शक्नोति। ");
INSERT INTO sandev_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","अतोहेतो र्युष्मभ्यमहं सत्यं कथयामि मनुष्याणां सन्ताना यानि यानि पापानीश्वरनिन्दाञ्च कुर्व्वन्ति तेषां तत्सर्व्वेषामपराधानां क्षमा भवितुं शक्नोति, ");
INSERT INTO sandev_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","किन्तु यः कश्चित् पवित्रमात्मानं निन्दति तस्यापराधस्य क्षमा कदापि न भविष्यति सोनन्तदण्डस्यार्हो भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","तस्यापवित्रभूतोऽस्ति तेषामेतत्कथाहेतोः स इत्थं कथितवान्। ");
INSERT INTO sandev_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","अथ तस्य माता भ्रातृगणश्चागत्य बहिस्तिष्ठनतो लोकान् प्रेष्य तमाहूतवन्तः। ");
INSERT INTO sandev_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ततस्तत्सन्निधौ समुपविष्टा लोकास्तं बभाषिरे पश्य बहिस्तव माता भ्रातरश्च त्वाम् अन्विच्छन्ति। ");
INSERT INTO sandev_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","तदा स तान् प्रत्युवाच मम माता का भ्रातरो वा के? ततः परं स स्वमीपोपविष्टान् शिष्यान् प्रति अवलोकनं कृत्वा कथयामास ");
INSERT INTO sandev_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","पश्यतैते मम माता भ्रातरश्च। ");
INSERT INTO sandev_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","यः कश्चिद् ईश्वरस्येष्टां क्रियां करोति स एव मम भ्राता भगिनी माता च। ");
INSERT INTO sandev_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","अनन्तरं स समुद्रतटे पुनरुपदेष्टुं प्रारेभे, ततस्तत्र बहुजनानां समागमात् स सागरोपरि नौकामारुह्य समुपविष्टः; सर्व्वे लोकाः समुद्रकूले तस्थुः। ");
INSERT INTO sandev_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","तदा स दृष्टान्तकथाभि र्बहूपदिष्टवान् उपदिशंश्च कथितवान्, ");
INSERT INTO sandev_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","अवधानं कुरुत, एको बीजवप्ता बीजानि वप्तुं गतः; ");
INSERT INTO sandev_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","वपनकाले कियन्ति बीजानि मार्गपाश्वे पतितानि, तत आकाशीयपक्षिण एत्य तानि चखादुः। ");
INSERT INTO sandev_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","कियन्ति बीजानि स्वल्पमृत्तिकावत्पाषाणभूमौ पतितानि तानि मृदोल्पत्वात् शीघ्रमङ्कुरितानि; ");
INSERT INTO sandev_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","किन्तूदिते सूर्य्ये दग्धानि तथा मूलानो नाधोगतत्वात् शुष्काणि च। ");
INSERT INTO sandev_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","कियन्ति बीजानि कण्टकिवनमध्ये पतितानि ततः कण्टकानि संवृद्व्य तानि जग्रसुस्तानि न च फलितानि। ");
INSERT INTO sandev_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","तथा कियन्ति बीजान्युत्तमभूमौ पतितानि तानि संवृद्व्य फलान्युत्पादितानि कियन्ति बीजानि त्रिंशद्गुणानि कियन्ति षष्टिगुणानि कियन्ति शतगुणानि फलानि फलितवन्ति। ");
INSERT INTO sandev_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","अथ स तानवदत् यस्य श्रोतुं कर्णौ स्तः स शृणोतु। ");
INSERT INTO sandev_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","तदनन्तरं निर्जनसमये तत्सङ्गिनो द्वादशशिष्याश्च तं तद्दृष्टान्तवाक्यस्यार्थं पप्रच्छुः। ");
INSERT INTO sandev_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","तदा स तानुदितवान् ईश्वरराज्यस्य निगूढवाक्यं बोद्धुं युष्माकमधिकारोऽस्ति; ");
INSERT INTO sandev_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","किन्तु ये वहिर्भूताः \"ते पश्यन्तः पश्यन्ति किन्तु न जानन्ति, शृण्वन्तः शृण्वन्ति किन्तु न बुध्यन्ते, चेत्तै र्मनःसु कदापि परिवर्त्तितेषु तेषां पापान्यमोचयिष्यन्त,\" अतोहेतोस्तान् प्रति दृष्टान्तैरेव तानि मया कथितानि। ");
INSERT INTO sandev_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","अथ स कथितवान् यूयं किमेतद् दृष्टान्तवाक्यं न बुध्यध्वे? तर्हि कथं सर्व्वान् दृष्टान्तान भोत्स्यध्वे? ");
INSERT INTO sandev_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","बीजवप्ता वाक्यरूपाणि बीजानि वपति; ");
INSERT INTO sandev_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","तत्र ये ये लोका वाक्यं शृण्वन्ति, किन्तु श्रुतमात्रात् शैतान् शीघ्रमागत्य तेषां मनःसूप्तानि तानि वाक्यरूपाणि बीजान्यपनयति तएव उप्तबीजमार्गपार्श्वेस्वरूपाः। ");
INSERT INTO sandev_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ये जना वाक्यं श्रुत्वा सहसा परमानन्देन गृह्लन्ति, किन्तु हृदि स्थैर्य्याभावात् किञ्चित् कालमात्रं तिष्ठन्ति तत्पश्चात् तद्वाक्यहेतोः ");
INSERT INTO sandev_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","कुत्रचित् क्लेशे उपद्रवे वा समुपस्थिते तदैव विघ्नं प्राप्नुवन्ति तएव उप्तबीजपाषाणभूमिस्वरूपाः। ");
INSERT INTO sandev_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","ये जनाः कथां शृण्वन्ति किन्तु सांसारिकी चिन्ता धनभ्रान्ति र्विषयलोभश्च एते सर्व्वे उपस्थाय तां कथां ग्रसन्ति ततः मा विफला भवति ");
INSERT INTO sandev_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","तएव उप्तबीजसकण्टकभूमिस्वरूपाः। ");
INSERT INTO sandev_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ये जना वाक्यं श्रुत्वा गृह्लन्ति तेषां कस्य वा त्रिंशद्गुणानि कस्य वा षष्टिगुणानि कस्य वा शतगुणानि फलानि भवन्ति तएव उप्तबीजोर्व्वरभूमिस्वरूपाः। ");
INSERT INTO sandev_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","तदा सोऽपरमपि कथितवान् कोपि जनो दीपाधारं परित्यज्य द्रोणस्याधः खट्वाया अधे वा स्थापयितुं दीपमानयति किं? ");
INSERT INTO sandev_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","अतोहेतो र्यन्न प्रकाशयिष्यते तादृग् लुक्कायितं किमपि वस्तु नास्ति; यद् व्यक्तं न भविष्यति तादृशं गुप्तं किमपि वस्तु नास्ति। ");
INSERT INTO sandev_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","यस्य श्रोतुं कर्णौ स्तः स शृणोतु। ");
INSERT INTO sandev_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","अपरमपि कथितवान् यूयं यद् यद् वाक्यं शृणुथ तत्र सावधाना भवत, यतो यूयं येन परिमाणेन परिमाथ तेनैव परिमाणेन युष्मदर्थमपि परिमास्यते; श्रोतारो यूयं युष्मभ्यमधिकं दास्यते। ");
INSERT INTO sandev_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","यस्याश्रये वर्द्धते तस्मै अपरमपि दास्यते, किन्तु यस्याश्रये न वर्द्धते तस्य यत् किञ्चिदस्ति तदपि तस्मान् नेष्यते। ");
INSERT INTO sandev_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","अनन्तरं स कथितवान् एको लोकः क्षेत्रे बीजान्युप्त्वा ");
INSERT INTO sandev_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","जागरणनिद्राभ्यां दिवानिशं गमयति, परन्तु तद्वीजं तस्याज्ञातरूपेणाङ्कुरयति वर्द्धते च; ");
INSERT INTO sandev_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","यतोहेतोः प्रथमतः पत्राणि ततः परं कणिशानि तत्पश्चात् कणिशपूर्णानि शस्यानि भूमिः स्वयमुत्पादयति; ");
INSERT INTO sandev_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","किन्तु फलेषु पक्केषु शस्यच्छेदनकालं ज्ञात्वा स तत्क्षणं शस्यानि छिनत्ति, अनेन तुल्यमीश्वरराज्यं। ");
INSERT INTO sandev_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","पुनः सोऽकथयद् ईश्वरराज्यं केन समं? केन वस्तुना सह वा तदुपमास्यामि? ");
INSERT INTO sandev_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","तत् सर्षपैकेन तुल्यं यतो मृदि वपनकाले सर्षपबीजं सर्व्वपृथिवीस्थबीजात् क्षुद्रं ");
INSERT INTO sandev_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","किन्तु वपनात् परम् अङ्कुरयित्वा सर्व्वशाकाद् बृहद् भवति, तस्य बृहत्यः शाखाश्च जायन्ते ततस्तच्छायां पक्षिण आश्रयन्ते। ");
INSERT INTO sandev_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","इत्थं तेषां बोधानुरूपं सोऽनेकदृष्टान्तैस्तानुपदिष्टवान्, ");
INSERT INTO sandev_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","दृष्टान्तं विना कामपि कथां तेभ्यो न कथितवान् पश्चान् निर्जने स शिष्यान् सर्व्वदृष्टान्तार्थं बोधितवान्। ");
INSERT INTO sandev_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","तद्दिनस्य सन्ध्यायां स तेभ्योऽकथयद् आगच्छत वयं पारं याम। ");
INSERT INTO sandev_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","तदा ते लोकान् विसृज्य तमविलम्बं गृहीत्वा नौकया प्रतस्थिरे; अपरा अपि नावस्तया सह स्थिताः। ");
INSERT INTO sandev_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ततः परं महाझञ्भ्शगमात् नौ र्दोलायमाना तरङ्गेण जलैः पूर्णाभवच्च। ");
INSERT INTO sandev_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","तदा स नौकाचश्चाद्भागे उपधाने शिरो निधाय निद्रित आसीत् ततस्ते तं जागरयित्वा जगदुः, हे प्रभो, अस्माकं प्राणा यान्ति किमत्र भवतश्चिन्ता नास्ति? ");
INSERT INTO sandev_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","तदा स उत्थाय वायुं तर्जितवान् समुद्रञ्चोक्तवान् शान्तः सुस्थिरश्च भव; ततो वायौ निवृत्तेऽब्धिर्निस्तरङ्गोभूत्। ");
INSERT INTO sandev_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","तदा स तानुवाच यूयं कुत एतादृक्शङ्काकुला भवत? किं वो विश्वासो नास्ति? ");
INSERT INTO sandev_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","तस्मात्तेऽतीवभीताः परस्परं वक्तुमारेभिरे, अहो वायुः सिन्धुश्चास्य निदेशग्राहिणौ कीदृगयं मनुजः। ");
INSERT INTO sandev_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","अथ तू सिन्धुपारं गत्वा गिदेरीयप्रदेश उपतस्थुः। ");
INSERT INTO sandev_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","नौकातो निर्गतमात्राद् अपवित्रभूतग्रस्त एकः श्मशानादेत्य तं साक्षाच् चकार। ");
INSERT INTO sandev_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","स श्मशानेऽवात्सीत् कोपि तं शृङ्खलेन बद्व्वा स्थापयितुं नाशक्नोत्। ");
INSERT INTO sandev_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","जनैर्वारं निगडैः शृङ्खलैश्च स बद्धोपि शृङ्खलान्याकृष्य मोचितवान् निगडानि च भंक्त्वा खण्डं खण्डं कृतवान् कोपि तं वशीकर्त्तुं न शशक। ");
INSERT INTO sandev_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","दिवानिशं सदा पर्व्वतं श्मशानञ्च भ्रमित्वा चीत्शब्दं कृतवान् ग्रावभिश्च स्वयं स्वं कृतवान्। ");
INSERT INTO sandev_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","स यीशुं दूरात् पश्यन्नेव धावन् तं प्रणनाम उचैरुवंश्चोवाच, ");
INSERT INTO sandev_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","हे सर्व्वोपरिस्थेश्वरपुत्र यीशो भवता सह मे कः सम्बन्धः? अहं त्वामीश्वरेण शापये मां मा यातय। ");
INSERT INTO sandev_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","यतो यीशुस्तं कथितवान् रे अपवित्रभूत, अस्मान्नराद् बहिर्निर्गच्छ। ");
INSERT INTO sandev_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","अथ स तं पृष्टवान् किन्ते नाम? तेन प्रत्युक्तं वयमनेके ऽस्मस्ततोऽस्मन्नाम बाहिनी। ");
INSERT INTO sandev_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ततोस्मान् देशान्न प्रेषयेति ते तं प्रार्थयन्त। ");
INSERT INTO sandev_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","तदानीं पर्व्वतं निकषा बृहन् वराहव्रजश्चरन्नासीत्। ");
INSERT INTO sandev_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","तस्माद् भूता विनयेन जगदुः, अमुं वराहव्रजम् आश्रयितुम् अस्मान् प्रहिणु। ");
INSERT INTO sandev_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","यीशुनानुज्ञातास्तेऽपवित्रभूता बहिर्निर्याय वराहव्रजं प्राविशन् ततः सर्व्वे वराहा वस्तुतस्तु प्रायोद्विसहस्रसंङ्ख्यकाः कटकेन महाजवाद् धावन्तः सिन्धौ प्राणान् जहुः। ");
INSERT INTO sandev_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","तस्माद् वराहपालकाः पलायमानाः पुरे ग्रामे च तद्वार्त्तं कथयाञ्चक्रुः। तदा लोका घटितं तत्कार्य्यं द्रष्टुं बहिर्जग्मुः ");
INSERT INTO sandev_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","यीशोः सन्निधिं गत्वा तं भूतग्रस्तम् अर्थाद् बाहिनीभूतग्रस्तं नरं सवस्त्रं सचेतनं समुपविष्टञ्च दृृष्ट्वा बिभ्युः। ");
INSERT INTO sandev_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ततो दृष्टतत्कार्य्यलोकास्तस्य भूतग्रस्तनरस्य वराहव्रजस्यापि तां धटनां वर्णयामासुः। ");
INSERT INTO sandev_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ततस्ते स्वसीमातो बहिर्गन्तुं यीशुं विनेतुमारेभिरे। ");
INSERT INTO sandev_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","अथ तस्य नौकारोहणकाले स भूतमुक्तो ना यीशुना सह स्थातुं प्रार्थयते; ");
INSERT INTO sandev_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","किन्तु स तमननुमत्य कथितवान् त्वं निजात्मीयानां समीपं गृहञ्च गच्छ प्रभुस्त्वयि कृपां कृत्वा यानि कर्म्माणि कृतवान् तानि तान् ज्ञापय। ");
INSERT INTO sandev_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","अतः स प्रस्थाय यीशुना कृतं तत्सर्व्वाश्चर्य्यं कर्म्म दिकापलिदेशे प्रचारयितुं प्रारब्धवान् ततः सर्व्वे लोका आश्चर्य्यं मेनिरे। ");
INSERT INTO sandev_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","अनन्तरं यीशौ नावा पुनरन्यपार उत्तीर्णे सिन्धुतटे च तिष्ठति सति तत्समीपे बहुलोकानां समागमोऽभूत्। ");
INSERT INTO sandev_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","अपरं यायीर् नाम्ना कश्चिद् भजनगृहस्याधिप आगत्य तं दृष्ट्वैव चरणयोः पतित्वा बहु निवेद्य कथितवान्; ");
INSERT INTO sandev_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","मम कन्या मृतप्रायाभूद् अतो भवानेत्य तदारोग्याय तस्या गात्रे हस्तम् अर्पयतु तेनैव सा जीविष्यति। ");
INSERT INTO sandev_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","तदा यीशुस्तेन सह चलितः किन्तु तत्पश्चाद् बहुलोकाश्चलित्वा ताद्गात्रे पतिताः। ");
INSERT INTO sandev_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","अथ द्वादशवर्षाणि प्रदररोगेण ");
INSERT INTO sandev_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","शीर्णा चिकित्सकानां नानाचिकित्साभिश्च दुःखं भुक्तवती च सर्व्वस्वं व्ययित्वापि नारोग्यं प्राप्ता च पुनरपि पीडितासीच्च ");
INSERT INTO sandev_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","या स्त्री सा यीशो र्वार्त्तां प्राप्य मनसाकथयत् यद्यहं तस्य वस्त्रमात्र स्प्रष्टुं लभेयं तदा रोगहीना भविष्यामि। ");
INSERT INTO sandev_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","अतोहेतोः सा लोकारण्यमध्ये तत्पश्चादागत्य तस्य वस्त्रं पस्पर्श। ");
INSERT INTO sandev_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","तेनैव तत्क्षणं तस्या रक्तस्रोतः शुष्कं स्वयं तस्माद् रोगान्मुक्ता इत्यपि देहेऽनुभूता। ");
INSERT INTO sandev_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","अथ स्वस्मात् शक्ति र्निर्गता यीशुरेतन्मनसा ज्ञात्वा लोकनिवहं प्रति मुखं व्यावृत्य पृष्टवान् केन मद्वस्त्रं स्पृष्टं? ");
INSERT INTO sandev_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ततस्तस्य शिष्या ऊचुः भवतो वपुषि लोकाः संघर्षन्ति तद् दृष्ट्वा केन मद्वस्त्रं स्पृष्टमिति कुतः कथयति? ");
INSERT INTO sandev_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","किन्तु केन तत् कर्म्म कृतं तद् द्रष्टुं यीशुश्चतुर्दिशो दृष्टवान्। ");
INSERT INTO sandev_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ततः सा स्त्री भीता कम्पिता च सती स्वस्या रुक्प्रतिक्रिया जातेति ज्ञात्वागत्य तत्सम्मुखे पतित्वा सर्व्ववृत्तान्तं सत्यं तस्मै कथयामास। ");
INSERT INTO sandev_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","तदानीं यीशुस्तां गदितवान्, हे कन्ये तव प्रतीतिस्त्वाम् अरोगामकरोत् त्वं क्षेमेण व्रज स्वरोगान्मुक्ता च तिष्ठ। ");
INSERT INTO sandev_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","इतिवाक्यवदनकाले भजनगृहाधिपस्य निवेशनाल् लोका एत्याधिपं बभाषिरे तव कन्या मृता तस्माद् गुरुं पुनः कुतः क्लिश्नासि? ");
INSERT INTO sandev_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","किन्तु यीशुस्तद् वाक्यं श्रुत्वैव भजनगृहाधिपं गदितवान् मा भैषीः केवलं विश्वासिहि। ");
INSERT INTO sandev_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","अथ पितरो याकूब् तद्भ्राता योहन् च एतान् विना कमपि स्वपश्चाद् यातुं नान्वमन्यत। ");
INSERT INTO sandev_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","तस्य भजनगृहाधिपस्य निवेशनसमीपम् आगत्य कलहं बहुरोदनं विलापञ्च कुर्व्वतो लोकान् ददर्श। ");
INSERT INTO sandev_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","तस्मान् निवेशनं प्रविश्य प्रोक्तवान् यूयं कुत इत्थं कलहं रोदनञ्च कुरुथ? कन्या न मृता निद्राति। ");
INSERT INTO sandev_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","तस्मात्ते तमुपजहसुः किन्तु यीशुः सर्व्वान बहिष्कृत्य कन्यायाः पितरौ स्वसङ्गिनश्च गृहीत्वा यत्र कन्यासीत् तत् स्थानं प्रविष्टवान्। ");
INSERT INTO sandev_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","अथ स तस्याः कन्याया हस्तौ धृत्वा तां बभाषे टालीथा कूमी, अर्थतो हे कन्ये त्वमुत्तिष्ठ इत्याज्ञापयामि। ");
INSERT INTO sandev_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","तुनैव तत्क्षणं सा द्वादशवर्षवयस्का कन्या पोत्थाय चलितुमारेभे, इतः सर्व्वे महाविस्मयं गताः। ");
INSERT INTO sandev_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","तत एतस्यै किञ्चित् खाद्यं दत्तेति कथयित्वा एतत्कर्म्म कमपि न ज्ञापयतेति दृढमादिष्टवान्। ");
INSERT INTO sandev_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","अनन्तरं स तत्स्थानात् प्रस्थाय स्वप्रदेशमागतः शिष्याश्च तत्पश्चाद् गताः। ");
INSERT INTO sandev_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","अथ विश्रामवारे सति स भजनगृहे उपदेष्टुमारब्धवान् ततोऽनेके लोकास्तत्कथां श्रुत्वा विस्मित्य जगदुः, अस्य मनुजस्य ईदृशी आश्चर्य्यक्रिया कस्माज् जाता? तथा स्वकराभ्याम् इत्थमद्भुतं कर्म्म कर्त्ताुम् एतस्मै कथं ज्ञानं दत्तम्? ");
INSERT INTO sandev_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","किमयं मरियमः पुत्रस्तज्ञा नो? किमयं याकूब्-योसि-यिहुदा-शिमोनां भ्राता नो? अस्य भगिन्यः किमिहास्माभिः सह नो? इत्थं ते तदर्थे प्रत्यूहं गताः। ");
INSERT INTO sandev_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","तदा यीशुस्तेभ्योऽकथयत् स्वदेशं स्वकुटुम्बान् स्वपरिजनांश्च विना कुत्रापि भविष्यद्वादी असत्कृतो न भवति। ");
INSERT INTO sandev_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","अपरञ्च तेषामप्रत्ययात् स विस्मितः कियतां रोगिणां वपुःषु हस्तम् अर्पयित्वा केवलं तेषामारोग्यकरणाद् अन्यत् किमपि चित्रकार्य्यं कर्त्तां न शक्तः। ");
INSERT INTO sandev_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","अथ स चतुर्दिक्स्थ ग्रामान् भ्रमित्वा उपदिष्टवान् ");
INSERT INTO sandev_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","द्वादशशिष्यान् आहूय अमेध्यभूतान् वशीकर्त्तां शक्तिं दत्त्वा तेषां द्वौ द्वौ जनो प्रेषितवान्। ");
INSERT INTO sandev_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","पुनरित्यादिशद् यूयम् एकैकां यष्टिं विना वस्त्रसंपुटः पूपः कटिबन्धे ताम्रखण्डञ्च एषां किमपि मा ग्रह्लीत, ");
INSERT INTO sandev_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","मार्गयात्रायै पादेषूपानहौ दत्त्वा द्वे उत्तरीये मा परिधद्व्वं। ");
INSERT INTO sandev_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","अपरमप्युक्तं तेन यूयं यस्यां पुर्य्यां यस्य निवेशनं प्रवेक्ष्यथ तां पुरीं यावन्न त्यक्ष्यथ तावत् तन्निवेशने स्थास्यथ। ");
INSERT INTO sandev_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","तत्र यदि केपि युष्माकमातिथ्यं न विदधति युष्माकं कथाश्च न शृण्वन्ति तर्हि तत्स्थानात् प्रस्थानसमये तेषां विरुद्धं साक्ष्यं दातुं स्वपादानास्फाल्य रजः सम्पातयत; अहं युष्मान् यथार्थं वच्मि विचारदिने तन्नगरस्यावस्थातः सिदोमामोरयो र्नगरयोरवस्था सह्यतरा भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","अथ ते गत्वा लोकानां मनःपरावर्त्तनीः कथा प्रचारितवन्तः। ");
INSERT INTO sandev_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","एवमनेकान् भूतांश्च त्याजितवन्तस्तथा तैलेन मर्द्दयित्वा बहून् जनानरोगानकार्षुः। ");
INSERT INTO sandev_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","इत्थं तस्य सुख्यातिश्चतुर्दिशो व्याप्ता तदा हेरोद् राजा तन्निशम्य कथितवान्, योहन् मज्जकः श्मशानाद् उत्थित अतोहेतोस्तेन सर्व्वा एता अद्भुतक्रियाः प्रकाशन्ते। ");
INSERT INTO sandev_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","अन्येऽकथयन् अयम् एलियः, केपि कथितवन्त एष भविष्यद्वादी यद्वा भविष्यद्वादिनां सदृश एकोयम्। ");
INSERT INTO sandev_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","किन्तु हेरोद् इत्याकर्ण्य भाषितवान् यस्याहं शिरश्छिन्नवान् स एव योहनयं स श्मशानादुदतिष्ठत्। ");
INSERT INTO sandev_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","पूर्व्वं स्वभ्रातुः फिलिपस्य पत्न्या उद्वाहं कृतवन्तं हेरोदं योहनवादीत् स्वभातृवधू र्न विवाह्या। ");
INSERT INTO sandev_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","अतः कारणात् हेरोद् लोकं प्रहित्य योहनं धृत्वा बन्धनालये बद्धवान्। ");
INSERT INTO sandev_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","हेरोदिया तस्मै योहने प्रकुप्य तं हन्तुम् ऐच्छत् किन्तु न शक्ता, ");
INSERT INTO sandev_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","यस्माद् हेरोद् तं धार्म्मिकं सत्पुरुषञ्च ज्ञात्वा सम्मन्य रक्षितवान्; तत्कथां श्रुत्वा तदनुसारेण बहूनि कर्म्माणि कृतवान् हृष्टमनास्तदुपदेशं श्रुतवांश्च। ");
INSERT INTO sandev_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","किन्तु हेरोद् यदा स्वजन्मदिने प्रधानलोकेभ्यः सेनानीभ्यश्च गालील्प्रदेशीयश्रेष्ठलोकेभ्यश्च रात्रौ भोज्यमेकं कृतवान् ");
INSERT INTO sandev_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","तस्मिन् शुभदिने हेरोदियायाः कन्या समेत्य तेषां समक्षं संनृत्य हेरोदस्तेन सहोपविष्टानाञ्च तोषमजीजनत् तता नृपः कन्यामाह स्म मत्तो यद् याचसे तदेव तुभ्यं दास्ये। ");
INSERT INTO sandev_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","शपथं कृत्वाकथयत् चेद् राज्यार्द्धमपि याचसे तदपि तुभ्यं दास्ये। ");
INSERT INTO sandev_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ततः सा बहि र्गत्वा स्वमातरं पप्रच्छ किमहं याचिष्ये? तदा साकथयत् योहनो मज्जकस्य शिरः। ");
INSERT INTO sandev_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","अथ तूर्णं भूपसमीपम् एत्य याचमानावदत् क्षणेस्मिन् योहनो मज्जकस्य शिरः पात्रे निधाय देहि, एतद् याचेऽहं। ");
INSERT INTO sandev_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","तस्मात् भूपोऽतिदुःखितः, तथापि स्वशपथस्य सहभोजिनाञ्चानुरोधात् तदनङ्गीकर्त्तुं न शक्तः। ");
INSERT INTO sandev_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","तत्क्षणं राजा घातकं प्रेष्य तस्य शिर आनेतुमादिष्टवान्। ");
INSERT INTO sandev_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ततः स कारागारं गत्वा तच्छिरश्छित्वा पात्रे निधायानीय तस्यै कन्यायै दत्तवान् कन्या च स्वमात्रे ददौ। ");
INSERT INTO sandev_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","अननतरं योहनः शिष्यास्तद्वार्त्तां प्राप्यागत्य तस्य कुणपं श्मशानेऽस्थापयन्। ");
INSERT INTO sandev_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","अथ प्रेषिता यीशोः सन्निधौ मिलिता यद् यच् चक्रुः शिक्षयामासुश्च तत्सर्व्ववार्त्तास्तस्मै कथितवन्तः। ");
INSERT INTO sandev_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","स तानुवाच यूयं विजनस्थानं गत्वा विश्राम्यत यतस्तत्सन्निधौ बहुलोकानां समागमात् ते भोक्तुं नावकाशं प्राप्ताः। ");
INSERT INTO sandev_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ततस्ते नावा विजनस्थानं गुप्तं गग्मुः। ");
INSERT INTO sandev_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ततो लोकनिवहस्तेषां स्थानान्तरयानं ददर्श, अनेके तं परिचित्य नानापुरेभ्यः पदैर्व्रजित्वा जवेन तैषामग्रे यीशोः समीप उपतस्थुः। ");
INSERT INTO sandev_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","तदा यीशु र्नावो बहिर्गत्य लोकारण्यानीं दृष्ट्वा तेषु करुणां कृतवान् यतस्तेऽरक्षकमेषा इवासन् तदा स तान नानाप्रसङ्गान् उपदिष्टवान्। ");
INSERT INTO sandev_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","अथ दिवान्ते सति शिष्या एत्य यीशुमूचिरे, इदं विजनस्थानं दिनञ्चावसन्नं। ");
INSERT INTO sandev_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","लोकानां किमपि खाद्यं नास्ति, अतश्चतुर्दिक्षु ग्रामान् गन्तुं भोज्यद्रव्याणि क्रेतुञ्च भवान् तान् विसृजतु। ");
INSERT INTO sandev_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","तदा स तानुवाच यूयमेव तान् भोजयत; ततस्ते जगदु र्वयं गत्वा द्विशतसंख्यकै र्मुद्रापादैः पूपान् क्रीत्वा किं तान् भोजयिष्यामः? ");
INSERT INTO sandev_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","तदा स तान् पृष्ठवान् युष्माकं सन्निधौ कति पूपा आसते? गत्वा पश्यत; ततस्ते दृष्ट्वा तमवदन् पञ्च पूपा द्वौ मत्स्यौ च सन्ति। ");
INSERT INTO sandev_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","तदा स लोकान् शस्पोपरि पंक्तिभिरुपवेशयितुम् आदिष्टवान्, ");
INSERT INTO sandev_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ततस्ते शतं शतं जनाः पञ्चाशत् पञ्चाशज्जनाश्च पंक्तिभि र्भुवि समुपविविशुः। ");
INSERT INTO sandev_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","अथ स तान् पञ्चपूपान् मत्स्यद्वयञ्च धृत्वा स्वर्गं पश्यन् ईश्वरगुणान् अन्वकीर्त्तयत् तान् पूपान् भंक्त्वा लोकेभ्यः परिवेषयितुं शिष्येभ्यो दत्तवान् द्वा मत्स्यौ च विभज्य सर्व्वेभ्यो दत्तवान्। ");
INSERT INTO sandev_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ततः सर्व्वे भुक्त्वातृप्यन्। ");
INSERT INTO sandev_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","अनन्तरं शिष्या अवशिष्टैः पूपै र्मत्स्यैश्च पूर्णान् द्वदश डल्लकान् जगृहुः। ");
INSERT INTO sandev_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","ते भोक्तारः प्रायः पञ्च सहस्राणि पुरुषा आसन्। ");
INSERT INTO sandev_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","अथ स लोकान् विसृजन्नेव नावमारोढुं स्वस्मादग्रे पारे बैत्सैदापुरं यातुञ्च श्ष्यिान् वाढमादिष्टवान्। ");
INSERT INTO sandev_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","तदा स सर्व्वान् विसृज्य प्रार्थयितुं पर्व्वतं गतः। ");
INSERT INTO sandev_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ततः सन्ध्यायां सत्यां नौः सिन्धुमध्य उपस्थिता किन्तु स एकाकी स्थले स्थितः। ");
INSERT INTO sandev_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","अथ सम्मुखवातवहनात् शिष्या नावं वाहयित्वा परिश्रान्ता इति ज्ञात्वा स निशाचतुर्थयामे सिन्धूपरि पद्भ्यां व्रजन् तेषां समीपमेत्य तेषामग्रे यातुम् उद्यतः। ");
INSERT INTO sandev_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","किन्तु शिष्याः सिन्धूपरि तं व्रजन्तं दृष्ट्वा भूतमनुमाय रुरुवुः, ");
INSERT INTO sandev_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","यतः सर्व्वे तं दृष्ट्वा व्याकुलिताः। अतएव यीशुस्तत्क्षणं तैः सहालप्य कथितवान्, सुस्थिरा भूत, अयमहं मा भैष्ट। ");
INSERT INTO sandev_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","अथ नौकामारुह्य तस्मिन् तेषां सन्निधिं गते वातो निवृत्तः; तस्मात्ते मनःसु विस्मिता आश्चर्य्यं मेनिरे। ");
INSERT INTO sandev_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","यतस्ते मनसां काठिन्यात् तत् पूपीयम् आश्चर्य्यं कर्म्म न विविक्तवन्तः। ");
INSERT INTO sandev_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","अथ ते पारं गत्वा गिनेषरत्प्रदेशमेत्य तट उपस्थिताः। ");
INSERT INTO sandev_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","तेषु नौकातो बहिर्गतेषु तत्प्रदेशीया लोकास्तं परिचित्य ");
INSERT INTO sandev_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","चतुर्दिक्षु धावन्तो यत्र यत्र रोगिणो नरा आसन् तान् सर्व्वान खट्वोपरि निधाय यत्र कुत्रचित् तद्वार्त्तां प्रापुः तत् स्थानम् आनेतुम् आरेभिरे। ");
INSERT INTO sandev_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","तथा यत्र यत्र ग्रामे यत्र यत्र पुरे यत्र यत्र पल्ल्याञ्च तेन प्रवेशः कृतस्तद्वर्त्ममध्ये लोकाः पीडितान् स्थापयित्वा तस्य चेलग्रन्थिमात्रं स्प्रष्टुम् तेषामर्थे तदनुज्ञां प्रार्थयन्तः यावन्तो लोकाः पस्पृशुस्तावन्त एव गदान्मुक्ताः। ");
INSERT INTO sandev_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","अनन्तरं यिरूशालम आगताः फिरूशिनोऽध्यापकाश्च यीशोः समीपम् आगताः। ");
INSERT INTO sandev_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ते तस्य कियतः शिष्यान् अशुचिकरैरर्थाद अप्रक्षालितहस्तै र्भुञ्जतो दृष्ट्वा तानदूषयन्। ");
INSERT INTO sandev_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","यतः फिरूशिनः सर्व्वयिहूदीयाश्च प्राचां परम्परागतवाक्यं सम्मन्य प्रतलेन हस्तान् अप्रक्षाल्य न भुञ्जते। ");
INSERT INTO sandev_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","आपनादागत्य मज्जनं विना न खादन्ति; तथा पानपात्राणां जलपात्राणां पित्तलपात्राणाम् आसनानाञ्च जले मज्जनम् इत्यादयोन्येपि बहवस्तेषामाचाराः सन्ति। ");
INSERT INTO sandev_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ते फिरूशिनोऽध्यापकाश्च यीशुं पप्रच्छुः, तव शिष्याः प्राचां परम्परागतवाक्यानुसारेण नाचरन्तोऽप्रक्षालितकरैः कुतो भुजंते? ");
INSERT INTO sandev_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ततः स प्रत्युवाच कपटिनो युष्मान् उद्दिश्य यिशयियभविष्यद्वादी युक्तमवादीत्। यथा स्वकीयैरधरैरेते सम्मन्यनते सदैव मां। किन्तु मत्तो विप्रकर्षे सन्ति तेषां मनांसि च। ");
INSERT INTO sandev_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","शिक्षयन्तो बिधीन् न्नाज्ञा भजन्ते मां मुधैव ते। ");
INSERT INTO sandev_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","यूयं जलपात्रपानपात्रादीनि मज्जयन्तो मनुजपरम्परागतवाक्यं रक्षथ किन्तु ईश्वराज्ञां लंघध्वे; अपरा ईदृश्योनेकाः क्रिया अपि कुरुध्वे। ");
INSERT INTO sandev_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","अन्यञ्चाकथयत् यूयं स्वपरम्परागतवाक्यस्य रक्षार्थं स्पष्टरूपेण ईश्वराज्ञां लोपयथ। ");
INSERT INTO sandev_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","यतो मूसाद्वारा प्रोक्तमस्ति स्वपितरौ सम्मन्यध्वं यस्तु मातरं पितरं वा दुर्व्वाक्यं वक्ति स नितान्तं हन्यतां। ");
INSERT INTO sandev_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","किन्तु मदीयेन येन द्रव्येण तवोपकारोभवत् तत् कर्ब्बाणमर्थाद् ईश्वराय निवेदितम् इदं वाक्यं यदि कोपि पितरं मातरं वा वक्ति ");
INSERT INTO sandev_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","तर्हि यूयं मातुः पितु र्वोपकारं कर्त्तां तं वारयथ। ");
INSERT INTO sandev_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","इत्थं स्वप्रचारितपरम्परागतवाक्येन यूयम् ईश्वराज्ञां मुधा विधद्व्वे, ईदृशान्यन्यान्यनेकानि कर्म्माणि कुरुध्वे। ");
INSERT INTO sandev_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","अथ स लोकानाहूय बभाषे यूयं सर्व्वे मद्वाक्यं शृणुत बुध्यध्वञ्च। ");
INSERT INTO sandev_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","बाह्यादन्तरं प्रविश्य नरममेध्यं कर्त्तां शक्नोति ईदृशं किमपि वस्तु नास्ति, वरम् अन्तराद् बहिर्गतं यद्वस्तु तन्मनुजम् अमेध्यं करोति। ");
INSERT INTO sandev_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","यस्य श्रोतुं श्रोत्रे स्तः स शृणोतु। ");
INSERT INTO sandev_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","ततः स लोकान् हित्वा गृहमध्यं प्रविष्टस्तदा शिष्यास्तदृष्टान्तवाक्यार्थं पप्रच्छुः। ");
INSERT INTO sandev_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","तस्मात् स तान् जगाद यूयमपि किमेतादृगबोधाः? किमपि द्रव्यं बाह्यादन्तरं प्रविश्य नरममेध्यं कर्त्तां न शक्नोति कथामिमां किं न बुध्यध्वे? ");
INSERT INTO sandev_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","तत् तदन्तर्न प्रविशति किन्तु कुक्षिमध्यं प्रविशति शेषे सर्व्वभुक्तवस्तुग्राहिणि बहिर्देशे निर्याति। ");
INSERT INTO sandev_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","अपरमप्यवादीद् यन्नरान्निरेति तदेव नरममेध्यं करोति। ");
INSERT INTO sandev_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","यतोऽन्तराद् अर्थान् मानवानां मनोभ्यः कुचिन्ता परस्त्रीवेश्यागमनं ");
INSERT INTO sandev_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","नरवधश्चौर्य्यं लोभो दुष्टता प्रवञ्चना कामुकता कुदृष्टिरीश्वरनिन्दा गर्व्वस्तम इत्यादीनि निर्गच्छन्ति। ");
INSERT INTO sandev_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","एतानि सर्व्वाणि दुरितान्यन्तरादेत्य नरममेध्यं कुर्व्वन्ति। ");
INSERT INTO sandev_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","अथ स उत्थाय तत्स्थानात् सोरसीदोन्पुरप्रदेशं जगाम तत्र किमपि निवेशनं प्रविश्य सर्व्वैरज्ञातः स्थातुं मतिञ्चक्रे किन्तु गुप्तः स्थातुं न शशाक। ");
INSERT INTO sandev_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","यतः सुरफैनिकीदेशीययूनानीवंशोद्भवस्त्रियाः कन्या भूतग्रस्तासीत्। सा स्त्री तद्वार्त्तां प्राप्य तत्समीपमागत्य तच्चरणयोः पतित्वा ");
INSERT INTO sandev_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","स्वकन्यातो भूतं निराकर्त्तां तस्मिन् विनयं कृतवती। ");
INSERT INTO sandev_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","किन्तु यीशुस्तामवदत् प्रथमं बालकास्तृप्यन्तु यतो बालकानां खाद्यं गृहीत्वा कुक्कुरेभ्यो निक्षेपोऽनुचितः। ");
INSERT INTO sandev_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","तदा सा स्त्री तमवादीत् भोः प्रभो तत् सत्यं तथापि मञ्चाधःस्थाः कुक्कुरा बालानां करपतितानि खाद्यखण्डानि खादन्ति। ");
INSERT INTO sandev_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ततः सोऽकथयद् एतत्कथाहेतोः सकुशला याहि तव कन्यां त्यक्त्वा भूतो गतः। ");
INSERT INTO sandev_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","अथ सा स्त्री गृहं गत्वा कन्यां भूतत्यक्तां शय्यास्थितां ददर्श। ");
INSERT INTO sandev_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","पुनश्च स सोरसीदोन्पुरप्रदेशात् प्रस्थाय दिकापलिदेशस्य प्रान्तरभागेन गालील्जलधेः समीपं गतवान्। ");
INSERT INTO sandev_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","तदा लोकैरेकं बधिरं कद्वदञ्च नरं तन्निकटमानीय तस्य गात्रे हस्तमर्पयितुं विनयः कृतः। ");
INSERT INTO sandev_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ततो यीशु र्लोकारण्यात् तं निर्जनमानीय तस्य कर्णयोङ्गुली र्ददौ निष्ठीवं दत्त्वा च तज्जिह्वां पस्पर्श। ");
INSERT INTO sandev_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","अनन्तरं स्वर्गं निरीक्ष्य दीर्घं निश्वस्य तमवदत् इतफतः अर्थान् मुक्तो भूयात्। ");
INSERT INTO sandev_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ततस्तत्क्षणं तस्य कर्णौ मुक्तौ जिह्वायाश्च जाड्यापगमात् स सुस्पष्टवाक्यमकथयत्। ");
INSERT INTO sandev_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","अथ स तान् वाढमित्यादिदेश यूयमिमां कथां कस्मैचिदपि मा कथयत, किन्तु स यति न्यषेधत् ते तति बाहुल्येन प्राचारयन्; ");
INSERT INTO sandev_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","तेऽतिचमत्कृत्य परस्परं कथयामासुः स बधिराय श्रवणशक्तिं मूकाय च कथनशक्तिं दत्त्वा सर्व्वं कर्म्मोत्तमरूपेण चकार। ");
INSERT INTO sandev_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","तदा तत्समीपं बहवो लोका आयाता अतस्तेषां भोज्यद्रव्याभावाद् यीशुः शिष्यानाहूय जगाद,। ");
INSERT INTO sandev_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","लोकनिवहे मम कृपा जायते ते दिनत्रयं मया सार्द्धं सन्ति तेषां भोज्यं किमपि नास्ति। ");
INSERT INTO sandev_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","तेषां मध्येऽनेके दूराद् आगताः, अभुक्तेषु तेषु मया स्वगृहमभिप्रहितेषु ते पथि क्लमिष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","शिष्या अवादिषुः, एतावतो लोकान् तर्पयितुम् अत्र प्रन्तरे पूपान् प्राप्तुं केन शक्यते? ");
INSERT INTO sandev_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ततः स तान् पप्रच्छ युष्माकं कति पूपाः सन्ति? तेऽकथयन् सप्त। ");
INSERT INTO sandev_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","ततः स ताल्लोकान् भुवि समुपवेष्टुम् आदिश्य तान् सप्त पूपान् धृत्वा ईश्वरगुणान् अनुकीर्त्तयामास, भंक्त्वा परिवेषयितुं शिष्यान् प्रति ददौ, ततस्ते लोकेभ्यः परिवेषयामासुः। ");
INSERT INTO sandev_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","तथा तेषां समीपे ये क्षुद्रमत्स्या आसन् तानप्यादाय ईश्वरगुणान् संकीर्त्य परिवेषयितुम् आदिष्टवान्। ");
INSERT INTO sandev_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ततो लोका भुक्त्वा तृप्तिं गता अवशिष्टखाद्यैः पूर्णाः सप्तडल्लका गृहीताश्च। ");
INSERT INTO sandev_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","एते भोक्तारः प्रायश्चतुः सहस्रपुरुषा आसन् ततः स तान् विससर्ज। ");
INSERT INTO sandev_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","अथ स शिष्यः सह नावमारुह्य दल्मानूथासीमामागतः। ");
INSERT INTO sandev_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ततः परं फिरूशिन आगत्य तेन सह विवदमानास्तस्य परीक्षार्थम् आकाशीयचिह्नं द्रष्टुं याचितवन्तः। ");
INSERT INTO sandev_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","तदा सोऽन्तर्दीर्घं निश्वस्याकथयत्, एते विद्यमाननराः कुतश्चिन्हं मृगयन्ते? युष्मानहं यथार्थं ब्रवीमि लोकानेतान् किमपि चिह्नं न दर्शयिष्यते। ");
INSERT INTO sandev_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","अथ तान् हित्वा पुन र्नावम् आरुह्य पारमगात्। ");
INSERT INTO sandev_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","एतर्हि शिष्यैः पूपेषु विस्मृतेषु नावि तेषां सन्निधौ पूप एकएव स्थितः। ");
INSERT INTO sandev_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","तदानीं यीशुस्तान् आदिष्टवान् फिरूशिनां हेरोदश्च किण्वं प्रति सतर्काः सावधानाश्च भवत। ");
INSERT INTO sandev_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ततस्तेऽन्योन्यं विवेचनं कर्तुम् आरेभिरे, अस्माकं सन्निधौ पूपो नास्तीति हेतोरिदं कथयति। ");
INSERT INTO sandev_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","तद् बुद्व्वा यीशुस्तेभ्योऽकथयत् युष्माकं स्थाने पूपाभावात् कुत इत्थं वितर्कयथ? यूयं किमद्यापि किमपि न जानीथ? बोद्धुञ्च न शक्नुथ? यावदद्य किं युष्माकं मनांसि कठिनानि सन्ति? ");
INSERT INTO sandev_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","सत्सु नेत्रेषु किं न पश्यथ? सत्सु कर्णेषु किं न शृणुथ? न स्मरथ च? ");
INSERT INTO sandev_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","यदाहं पञ्चपूपान् पञ्चसहस्राणां पुरुषाणां मध्ये भंक्त्वा दत्तवान् तदानीं यूयम् अवशिष्टपूपैः पूर्णान् कति डल्लकान् गृहीतवन्तः? तेऽकथयन् द्वादशडल्लकान्। ");
INSERT INTO sandev_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","अपरञ्च यदा चतुःसहस्राणां पुरुषाणां मध्ये पूपान् भंक्त्वाददां तदा यूयम् अतिरिक्तपूपानां कति डल्लकान् गृहीतवन्तः? ते कथयामासुः सप्तडल्लकान्। ");
INSERT INTO sandev_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","तदा स कथितवान् तर्हि यूयम् अधुनापि कुतो बोद्व्वुं न शक्नुथ? ");
INSERT INTO sandev_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","अनन्तरं तस्मिन् बैत्सैदानगरे प्राप्ते लोका अन्धमेकं नरं तत्समीपमानीय तं स्प्रष्टुं तं प्रार्थयाञ्चक्रिरे। ");
INSERT INTO sandev_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","तदा तस्यान्धस्य करौ गृहीत्वा नगराद् बहिर्देशं तं नीतवान्; तन्नेत्रे निष्ठीवं दत्त्वा तद्गात्रे हस्तावर्पयित्वा तं पप्रच्छ, किमपि पश्यसि? ");
INSERT INTO sandev_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","स नेत्रे उन्मील्य जगाद, वृक्षवत् मनुजान् गच्छतो निरीक्षे। ");
INSERT INTO sandev_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ततो यीशुः पुनस्तस्य नयनयो र्हस्तावर्पयित्वा तस्य नेत्रे उन्मीलयामास; तस्मात् स स्वस्थो भूत्वा स्पष्टरूपं सर्व्वलोकान् ददर्श। ");
INSERT INTO sandev_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ततः परं त्वं ग्रामं मा गच्छ ग्रामस्थं कमपि च किमप्यनुक्त्वा निजगृहं याहीत्यादिश्य यीशुस्तं निजगृहं प्रहितवान्। ");
INSERT INTO sandev_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","अनन्तरं शिष्यैः सहितो यीशुः कैसरीयाफिलिपिपुरं जगाम, पथि गच्छन् तानपृच्छत् कोऽहम् अत्र लोकाः किं वदन्ति? ");
INSERT INTO sandev_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","ते प्रत्यूचुः त्वां योहनं मज्जकं वदन्ति किन्तु केपि केपि एलियं वदन्ति; अपरे केपि केपि भविष्यद्वादिनाम् एको जन इति वदन्ति। ");
INSERT INTO sandev_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","अथ स तानपृच्छत् किन्तु कोहम्? इत्यत्र यूयं किं वदथ? तदा पितरः प्रत्यवदत् भवान् अभिषिक्तस्त्राता। ");
INSERT INTO sandev_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","ततः स तान् गाढमादिशद् यूयं मम कथा कस्मैचिदपि मा कथयत। ");
INSERT INTO sandev_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","मनुष्यपुत्रेणावश्यं बहवो यातना भोक्तव्याः प्राचीनलोकैः प्रधानयाजकैरध्यापकैश्च स निन्दितः सन् घातयिष्यते तृतीयदिने उत्थास्यति च, यीशुः शिष्यानुपदेष्टुमारभ्य कथामिमां स्पष्टमाचष्ट। ");
INSERT INTO sandev_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","तस्मात् पितरस्तस्य हस्तौ धृत्वा तं तर्ज्जितवान्। ");
INSERT INTO sandev_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","किन्तु स मुखं परावर्त्य शिष्यगणं निरीक्ष्य पितरं तर्जयित्वावादीद् दूरीभव विघ्नकारिन् ईश्वरीयकार्य्यादपि मनुष्यकार्य्यं तुभ्यं रोचततरां। ");
INSERT INTO sandev_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","अथ स लोकान् शिष्यांश्चाहूय जगाद यः कश्चिन् मामनुगन्तुम् इच्छति स आत्मानं दाम्यतु, स्वक्रुशं गृहीत्वा मत्पश्चाद् आयातु। ");
INSERT INTO sandev_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","यतो यः कश्चित् स्वप्राणं रक्षितुमिच्छति स तं हारयिष्यति, किन्तु यः कश्चिन् मदर्थं सुसंवादार्थञ्च प्राणं हारयति स तं रक्षिष्यति। ");
INSERT INTO sandev_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","अपरञ्च मनुजः सर्व्वं जगत् प्राप्य यदि स्वप्राणं हारयति तर्हि तस्य को लाभः? ");
INSERT INTO sandev_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","नरः स्वप्राणविनिमयेन किं दातुं शक्नोति? ");
INSERT INTO sandev_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","एतेषां व्यभिचारिणां पापिनाञ्च लोकानां साक्षाद् यदि कोपि मां मत्कथाञ्च लज्जास्पदं जानाति तर्हि मनुजपुत्रो यदा धर्म्मदूतैः सह पितुः प्रभावेणागमिष्यति तदा सोपि तं लज्जास्पदं ज्ञास्यति। ");
INSERT INTO sandev_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","अथ स तानवादीत् युष्मभ्यमहं यथार्थं कथयामि, ईश्वरराज्यं पराक्रमेणोपस्थितं न दृष्ट्वा मृत्युं नास्वादिष्यन्ते, अत्र दण्डायमानानां मध्येपि तादृशा लोकाः सन्ति। ");
INSERT INTO sandev_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","अथ षड्दिनेभ्यः परं यीशुः पितरं याकूबं योहनञ्च गृहीत्वा गिरेरुच्चस्य निर्जनस्थानं गत्वा तेषां प्रत्यक्षे मूर्त्यन्तरं दधार। ");
INSERT INTO sandev_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ततस्तस्य परिधेयम् ईदृशम् उज्ज्वलहिमपाणडरं जातं यद् जगति कोपि रजको न तादृक् पाणडरं कर्त्तां शक्नोति। ");
INSERT INTO sandev_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","अपरञ्च एलियो मूसाश्च तेभ्यो दर्शनं दत्त्वा यीशुना सह कथनं कर्त्तुमारेभाते। ");
INSERT INTO sandev_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","तदा पितरो यीशुमवादीत् हे गुरोऽस्माकमत्र स्थितिरुत्तमा, ततएव वयं त्वत्कृते एकां मूसाकृते एकाम् एलियकृते चैकां, एतास्तिस्रः कुटी र्निर्म्माम। ");
INSERT INTO sandev_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","किन्तु स यदुक्तवान् तत् स्वयं न बुबुधे ततः सर्व्वे बिभयाञ्चक्रुः। ");
INSERT INTO sandev_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","एतर्हि पयोदस्तान् छादयामास, ममयां प्रियः पुत्रः कथासु तस्य मनांसि निवेशयतेति नभोवाणी तन्मेद्यान्निर्ययौ। ");
INSERT INTO sandev_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","अथ हठात्ते चतुर्दिशो दृष्ट्वा यीशुं विना स्वैः सहितं कमपि न ददृशुः। ");
INSERT INTO sandev_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ततः परं गिरेरवरोहणकाले स तान् गाढम् दूत्यादिदेश यावन्नरसूनोः श्मशानादुत्थानं न भवति, तावत् दर्शनस्यास्य वार्त्ता युष्माभिः कस्मैचिदपि न वक्तव्या। ");
INSERT INTO sandev_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","तदा श्मशानादुत्थानस्य कोभिप्राय इति विचार्य्य ते तद्वाक्यं स्वेषु गोपायाञ्चक्रिरे। ");
INSERT INTO sandev_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","अथ ते यीशुं पप्रच्छुः प्रथमत एलियेनागन्तव्यम् इति वाक्यं कुत उपाध्याया आहुः? ");
INSERT INTO sandev_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","तदा स प्रत्युवाच , एलियः प्रथममेत्य सर्व्वकार्य्याणि साधयिष्यति; नरपुत्रे च लिपि र्यथास्ते तथैव सोपि बहुदुःखं प्राप्यावज्ञास्यते। ");
INSERT INTO sandev_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","किन्त्वहं युष्मान् वदामि , एलियार्थे लिपि र्यथास्ते तथैव स एत्य ययौ, लोका: स्वेच्छानुरूपं तमभिव्यवहरन्ति स्म। ");
INSERT INTO sandev_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","अनन्तरं स शिष्यसमीपमेत्य तेषां चतुःपार्श्वे तैः सह बहुजनान् विवदमानान् अध्यापकांश्च दृष्टवान्; ");
INSERT INTO sandev_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","किन्तु सर्व्वलोकास्तं दृष्ट्वैव चमत्कृत्य तदासन्नं धावन्तस्तं प्रणेमुः। ");
INSERT INTO sandev_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","तदा यीशुरध्यापकानप्राक्षीद् एतैः सह यूयं किं विवदध्वे? ");
INSERT INTO sandev_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ततो लोकानां कश्चिदेकः प्रत्यवादीत् हे गुरो मम सूनुं मूकं भूतधृतञ्च भवदासन्नम् आनयं। ");
INSERT INTO sandev_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","यदासौ भूतस्तमाक्रमते तदैव पातसति तथा स फेणायते, दन्तैर्दन्तान् घर्षति क्षीणो भवति च; ततो हेतोस्तं भूतं त्याजयितुं भवच्छिष्यान् निवेदितवान् किन्तु ते न शेकुः। ");
INSERT INTO sandev_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","तदा स तमवादीत्, रे अविश्वासिनः सन्ताना युष्माभिः सह कति कालानहं स्थास्यामि? अपरान् कति कालान् वा व आचारान् सहिष्ये? तं मदासन्नमानयत। ");
INSERT INTO sandev_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ततस्तत्सन्निधिं स आनीयत किन्तु तं दृष्ट्वैव भूतो बालकं धृतवान्; स च भूमौ पतित्वा फेणायमानो लुलोठ। ");
INSERT INTO sandev_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","तदा स तत्पितरं पप्रच्छ, अस्येदृशी दशा कति दिनानि भूता? ततः सोवादीत् बाल्यकालात्। ");
INSERT INTO sandev_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","भूतोयं तं नाशयितुं बहुवारान् वह्नौ जले च न्यक्षिपत् किन्तु यदि भवान किमपि कर्त्तां शक्नोति तर्हि दयां कृत्वास्मान् उपकरोतु। ");
INSERT INTO sandev_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","तदा यीशुस्तमवदत् यदि प्रत्येतुं शक्नोषि तर्हि प्रत्ययिने जनाय सर्व्वं साध्यम्। ");
INSERT INTO sandev_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ततस्तत्क्षणं तद्बालकस्य पिता प्रोच्चै रूवन् साश्रुनेत्रः प्रोवाच, प्रभो प्रत्येमि ममाप्रत्ययं प्रतिकुरु। ");
INSERT INTO sandev_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","अथ यीशु र्लोकसङ्घं धावित्वायान्तं दृष्ट्वा तमपूतभूतं तर्जयित्वा जगाद, रे बधिर मूक भूत त्वमेतस्माद् बहिर्भव पुनः कदापि माश्रयैनं त्वामहम् इत्यादिशामि। ");
INSERT INTO sandev_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","तदा स भूतश्चीत्शब्दं कृत्वा तमापीड्य बहिर्जजाम, ततो बालको मृतकल्पो बभूव तस्मादयं मृतइत्यनेके कथयामासुः। ");
INSERT INTO sandev_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","किन्तु करं धृत्वा यीशुनोत्थापितः स उत्तस्थौ। ");
INSERT INTO sandev_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","अथ यीशौ गृहं प्रविष्टे शिष्या गुप्तं तं पप्रच्छुः, वयमेनं भूतं त्याजयितुं कुतो न शक्ताः? ");
INSERT INTO sandev_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","स उवाच, प्रार्थनोपवासौ विना केनाप्यन्येन कर्म्मणा भूतमीदृशं त्याजयितुं न शक्यं। ");
INSERT INTO sandev_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","अनन्तरं स तत्स्थानादित्वा गालील्मध्येन ययौ, किन्तु तत् कोपि जानीयादिति स नैच्छत्। ");
INSERT INTO sandev_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","अपरञ्च स शिष्यानुपदिशन् बभाषे, नरपुत्रो नरहस्तेषु समर्पयिष्यते ते च तं हनिष्यन्ति तैस्तस्मिन् हते तृतीयदिने स उत्थास्यतीति। ");
INSERT INTO sandev_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","किन्तु तत्कथां ते नाबुध्यन्त प्रष्टुञ्च बिभ्यः। ");
INSERT INTO sandev_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","अथ यीशुः कफर्नाहूम्पुरमागत्य मध्येगृहञ्चेत्य तानपृच्छद् वर्त्ममध्ये यूयमन्योन्यं किं विवदध्वे स्म? ");
INSERT INTO sandev_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","किन्तु ते निरुत्तरास्तस्थु र्यस्मात्तेषां को मुख्य इति वर्त्मानि तेऽन्योन्यं व्यवदन्त। ");
INSERT INTO sandev_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ततः स उपविश्य द्वादशशिष्यान् आहूय बभाषे यः कश्चित् मुख्यो भवितुमिच्छति स सर्व्वेभ्यो गौणः सर्व्वेषां सेवकश्च भवतु। ");
INSERT INTO sandev_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","तदा स बालकमेकं गृहीत्वा मध्ये समुपावेशयत् ततस्तं क्रोडे कृत्वा तानवादात् ");
INSERT INTO sandev_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","यः कश्चिदीदृशस्य कस्यापि बालस्यातिथ्यं करोति स ममातिथ्यं करोति; यः कश्चिन्ममातिथ्यं करोति स केवलम् ममातिथ्यं करोति तन्न मत्प्रेरकस्याप्यातिथ्यं करोति। ");
INSERT INTO sandev_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","अथ योहन् तमब्रवीत् हे गुरो, अस्माकमननुगामिनम् एकं त्वान्नाम्ना भूतान् त्याजयन्तं वयं दृष्टवन्तः, अस्माकमपश्चाद्गामित्वाच्च तं न्यषेधाम। ");
INSERT INTO sandev_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","किन्तु यीशुरवदत् तं मा निषेधत्, यतो यः कश्चिन् मन्नाम्ना चित्रं कर्म्म करोति स सहसा मां निन्दितुं न शक्नोति। ");
INSERT INTO sandev_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","तथा यः कश्चिद् युष्माकं विपक्षतां न करोति स युष्माकमेव सपक्षः। ");
INSERT INTO sandev_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","यः कश्चिद् युष्मान् ख्रीष्टशिष्यान् ज्ञात्वा मन्नाम्ना कंसैकेन पानीयं पातुं ददाति, युष्मानहं यथार्थं वच्मि, स फलेन वञ्चितो न भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","किन्तु यदि कश्चिन् मयि विश्वासिनामेषां क्षुद्रप्राणिनाम् एकस्यापि विघ्नं जनयति, तर्हि तस्यैतत्कर्म्म करणात् कण्ठबद्धपेषणीकस्य तस्य सागरागाधजल मज्जनं भद्रं। ");
INSERT INTO sandev_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","अतः स्वकरो यदि त्वां बाधते तर्हि तं छिन्धि; ");
INSERT INTO sandev_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","यस्मात् यत्र कीटा न म्रियन्ते वह्निश्च न निर्व्वाति, तस्मिन् अनिर्व्वाणानलनरके करद्वयवस्तव गमनात् करहीनस्य स्वर्गप्रवेशस्तव क्षेमं। ");
INSERT INTO sandev_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","यदि तव पादो विघ्नं जनयति तर्हि तं छिन्धि, ");
INSERT INTO sandev_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","यतो यत्र कीटा न म्रियन्ते वह्निश्च न निर्व्वाति, तस्मिन् ऽनिर्व्वाणवह्नौ नरके द्विपादवतस्तव निक्षेपात् पादहीनस्य स्वर्गप्रवेशस्तव क्षेमं। ");
INSERT INTO sandev_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","स्वनेत्रं यदि त्वां बाधते तर्हि तदप्युत्पाटय, यतो यत्र कीटा न म्रियन्ते वह्निश्च न निर्व्वाति, ");
INSERT INTO sandev_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","तस्मिन ऽनिर्व्वाणवह्नौ नरके द्विनेत्रस्य तव निक्षेपाद् एकनेत्रवत ईश्वरराज्ये प्रवेशस्तव क्षेमं। ");
INSERT INTO sandev_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","यथा सर्व्वो बलि र्लवणाक्तः क्रियते तथा सर्व्वो जनो वह्निरूपेण लवणाक्तः कारिष्यते। ");
INSERT INTO sandev_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","लवणं भद्रं किन्तु यदि लवणे स्वादुता न तिष्ठति, तर्हि कथम् आस्वाद्युक्तं करिष्यथ? यूयं लवणयुक्ता भवत परस्परं प्रेम कुरुत। ");
INSERT INTO sandev_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","अनन्तरं स तत्स्थानात् प्रस्थाय यर्द्दननद्याः पारे यिहूदाप्रदेश उपस्थितवान्, तत्र तदन्तिके लोकानां समागमे जाते स निजरीत्यनुसारेण पुनस्तान् उपदिदेश। ");
INSERT INTO sandev_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","तदा फिरूशिनस्तत्समीपम् एत्य तं परीक्षितुं पप्रच्छः स्वजाया मनुजानां त्यज्या न वेति? ");
INSERT INTO sandev_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ततः स प्रत्यवादीत्, अत्र कार्य्ये मूसा युष्मान् प्रति किमाज्ञापयत्? ");
INSERT INTO sandev_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","त ऊचुः त्यागपत्रं लेखितुं स्वपत्नीं त्यक्तुञ्च मूसाऽनुमन्यते। ");
INSERT INTO sandev_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","तदा यीशुः प्रत्युवाच, युष्माकं मनसां काठिन्याद्धेतो र्मूसा निदेशमिमम् अलिखत्। ");
INSERT INTO sandev_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","किन्तु सृष्टेरादौ ईश्वरो नरान् पुंरूपेण स्त्रीरूपेण च ससर्ज। ");
INSERT INTO sandev_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","\"ततः कारणात् पुमान् पितरं मातरञ्च त्यक्त्वा स्वजायायाम् आसक्तो भविष्यति, ");
INSERT INTO sandev_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","तौ द्वाव् एकाङ्गौ भविष्यतः।\" तस्मात् तत्कालमारभ्य तौ न द्वाव् एकाङ्गौ। ");
INSERT INTO sandev_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","अतः कारणाद् ईश्वरो यदयोजयत् कोपि नरस्तन्न वियेजयेत्। ");
INSERT INTO sandev_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","अथ यीशु र्गृहं प्रविष्टस्तदा शिष्याः पुनस्तत्कथां तं पप्रच्छुः। ");
INSERT INTO sandev_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ततः सोवदत् कश्चिद् यदि स्वभार्य्यां त्यक्तवान्याम् उद्वहति तर्हि स स्वभार्य्यायाः प्रातिकूल्येन व्यभिचारी भवति। ");
INSERT INTO sandev_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","काचिन्नारी यदि स्वपतिं हित्वान्यपुंसा विवाहिता भवति तर्हि सापि व्यभिचारिणी भवति। ");
INSERT INTO sandev_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","अथ स यथा शिशून् स्पृशेत्, तदर्थं लोकैस्तदन्तिकं शिशव आनीयन्त, किन्तु शिष्यास्तानानीतवतस्तर्जयामासुः। ");
INSERT INTO sandev_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","यीशुस्तद् दृष्ट्वा क्रुध्यन् जगाद, मन्निकटम् आगन्तुं शिशून् मा वारयत, यत एतादृशा ईश्वरराज्याधिकारिणः। ");
INSERT INTO sandev_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","युष्मानहं यथार्थं वच्मि, यः कश्चित् शिशुवद् भूत्वा राज्यमीश्वरस्य न गृह्लीयात् स कदापि तद्राज्यं प्रवेष्टुं न शक्नोति। ");
INSERT INTO sandev_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","अननतरं स शिशूनङ्के निधाय तेषां गात्रेषु हस्तौ दत्त्वाशिषं बभाषे। ");
INSERT INTO sandev_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","अथ स वर्त्मना याति, एतर्हि जन एको धावन् आगत्य तत्सम्मुखे जानुनी पातयित्वा पृष्टवान्, भोः परमगुरो, अनन्तायुः प्राप्तये मया किं कर्त्तव्यं? ");
INSERT INTO sandev_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","तदा यीशुरुवाच, मां परमं कुतो वदसि? विनेश्वरं कोपि परमो न भवति। ");
INSERT INTO sandev_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","परस्त्रीं नाभिगच्छ; नरं मा घातय; स्तेयं मा कुरु; मृषासाक्ष्यं मा देहि; हिंसाञ्च मा कुरु; पितरौ सम्मन्यस्व; निदेशा एते त्वया ज्ञाताः। ");
INSERT INTO sandev_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ततस्तन प्रत्युक्तं, हे गुरो बाल्यकालादहं सर्व्वानेतान् आचरामि। ");
INSERT INTO sandev_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","तदा यीशुस्तं विलोक्य स्नेहेन बभाषे, तवैकस्याभाव आस्ते; त्वं गत्वा सर्व्वस्वं विक्रीय दरिद्रेभ्यो विश्राणय, ततः स्वर्गे धनं प्राप्स्यसि; ततः परम् एत्य क्रुशं वहन् मदनुवर्त्ती भव। ");
INSERT INTO sandev_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","किन्तु तस्य बहुसम्पद्विद्यमानत्वात् स इमां कथामाकर्ण्य विषणो दुःखितश्च सन् जगाम। ");
INSERT INTO sandev_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","अथ यीशुश्चतुर्दिशो निरीक्ष्य शिष्यान् अवादीत्, धनिलोकानाम् ईश्वरराज्यप्रवेशः कीदृग् दुष्करः। ");
INSERT INTO sandev_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","तस्य कथातः शिष्याश्चमच्चक्रुः, किन्तु स पुनरवदत्, हे बालका ये धने विश्वसन्ति तेषाम् ईश्वरराज्यप्रवेशः कीदृग् दुष्करः। ");
INSERT INTO sandev_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ईश्वरराज्ये धनिनां प्रवेशात् सूचिरन्ध्रेण महाङ्गस्य गमनागमनं सुकरं। ");
INSERT INTO sandev_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","तदा शिष्या अतीव विस्मिताः परस्परं प्रोचुः, तर्हि कः परित्राणं प्राप्तुं शक्नोति? ");
INSERT INTO sandev_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ततो यीशुस्तान् विलोक्य बभाषे, तन् नरस्यासाध्यं किन्तु नेश्वरस्य, यतो हेतोरीश्वरस्य सर्व्वं साध्यम्। ");
INSERT INTO sandev_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","तदा पितर उवाच, पश्य वयं सर्व्वं परित्यज्य भवतोनुगामिनो जाताः। ");
INSERT INTO sandev_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","ततो यीशुः प्रत्यवदत्, युष्मानहं यथार्थं वदामि, मदर्थं सुसंवादार्थं वा यो जनः सदनं भ्रातरं भगिनीं पितरं मातरं जायां सन्तानान् भूमि वा त्यक्त्वा ");
INSERT INTO sandev_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","गृहभ्रातृभगिनीपितृमातृपत्नीसन्तानभूमीनामिह शतगुणान् प्रेत्यानन्तायुश्च न प्राप्नोति तादृशः कोपि नास्ति। ");
INSERT INTO sandev_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","किन्त्वग्रीया अनेके लोकाः शेषाः, शेषीया अनेके लोकाश्चाग्रा भविष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","अथ यिरूशालम्यानकाले यीशुस्तेषाम् अग्रगामी बभूव, तस्मात्ते चित्रं ज्ञात्वा पश्चाद्गामिनो भूत्वा बिभ्युः। तदा स पुन र्द्वादशशिष्यान् गृहीत्वा स्वीयं यद्यद् घटिष्यते तत्तत् तेभ्यः कथयितुं प्रारेभे; ");
INSERT INTO sandev_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","पश्यत वयं यिरूशालम्पुरं यामः, तत्र मनुष्यपुत्रः प्रधानयाजकानाम् उपाध्यायानाञ्च करेषु समर्पयिष्यते; ते च वधदण्डाज्ञां दापयित्वा परदेशीयानां करेषु तं समर्पयिष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ते तमुपहस्य कशया प्रहृत्य तद्वपुषि निष्ठीवं निक्षिप्य तं हनिष्यन्ति, ततः स तृतीयदिने प्रोत्थास्यति। ");
INSERT INTO sandev_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ततः सिवदेः पुत्रौ याकूब्योहनौ तदन्तिकम् एत्य प्रोचतुः, हे गुरो यद् आवाभ्यां याचिष्यते तदस्मदर्थं भवान् करोतु निवेदनमिदमावयोः। ");
INSERT INTO sandev_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ततः स कथितवान्, युवां किमिच्छथः? किं मया युष्मदर्थं करणीयं? ");
INSERT INTO sandev_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","तदा तौ प्रोचतुः, आवयोरेकं दक्षिणपार्श्वे वामपार्श्वे चैकं तवैश्वर्य्यपदे समुपवेष्टुम् आज्ञापय। ");
INSERT INTO sandev_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","किन्तु यीशुः प्रत्युवाच युवामज्ञात्वेदं प्रार्थयेथे, येन कंसेनाहं पास्यामि तेन युवाभ्यां किं पातुं शक्ष्यते? यस्मिन् मज्जनेनाहं मज्जिष्ये तन्मज्जने मज्जयितुं किं युवाभ्यां शक्ष्यते? तौ प्रत्यूचतुः शक्ष्यते। ");
INSERT INTO sandev_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","तदा यीशुरवदत् येन कंसेनाहं पास्यामि तेनावश्यं युवामपि पास्यथः, येन मज्जनेन चाहं मज्जिय्ये तत्र युवामपि मज्जिष्येथे। ");
INSERT INTO sandev_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","किन्तु येषामर्थम् इदं निरूपितं, तान् विहायान्यं कमपि मम दक्षिणपार्श्वे वामपार्श्वे वा समुपवेशयितुं ममाधिकारो नास्ति। ");
INSERT INTO sandev_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","अथान्यदशशिष्या इमां कथां श्रुत्वा याकूब्योहन्भ्यां चुकुपुः। ");
INSERT INTO sandev_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","किन्तु यीशुस्तान् समाहूय बभाषे, अन्यदेशीयानां राजत्वं ये कुर्व्वन्ति ते तेषामेव प्रभुत्वं कुर्व्वन्ति, तथा ये महालोकास्ते तेषाम् अधिपतित्वं कुर्व्वन्तीति यूयं जानीथ। ");
INSERT INTO sandev_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","किन्तु युष्माकं मध्ये न तथा भविष्यति, युष्माकं मध्ये यः प्राधान्यं वाञ्छति स युष्माकं सेवको भविष्यति, ");
INSERT INTO sandev_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","युष्माकं यो महान् भवितुमिच्छति स सर्व्वेषां किङ्करो भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","यतो मनुष्यपुत्रः सेव्यो भवितुं नागतः सेवां कर्त्तां तथानेकेषां परित्राणस्य मूल्यरूपस्वप्राणं दातुञ्चागतः। ");
INSERT INTO sandev_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","अथ ते यिरीहोनगरं प्राप्तास्तस्मात् शिष्यै र्लोकैश्च सह यीशो र्गमनकाले टीमयस्य पुत्रो बर्टीमयनामा अन्धस्तन्मार्गपार्श्वे भिक्षार्थम् उपविष्टः। ");
INSERT INTO sandev_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","स नासरतीयस्य यीशोरागमनवार्त्तां प्राप्य प्रोचै र्वक्तुमारेभे, हे यीशो दायूदः सन्तान मां दयस्व। ");
INSERT INTO sandev_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ततोनेके लोका मौनीभवेति तं तर्जयामासुः, किन्तु स पुनरधिकमुच्चै र्जगाद, हे यीशो दायूदः सन्तान मां दयस्व। ");
INSERT INTO sandev_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","तदा यीशुः स्थित्वा तमाह्वातुं समादिदेश, ततो लोकास्तमन्धमाहूय बभाषिरे, हे नर, स्थिरो भव, उत्तिष्ठ, स त्वामाह्वयति। ");
INSERT INTO sandev_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","तदा स उत्तरीयवस्त्रं निक्षिप्य प्रोत्थाय यीशोः समीपं गतः। ");
INSERT INTO sandev_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ततो यीशुस्तमवदत् त्वया किं प्रार्थ्यते? तुभ्यमहं किं करिष्यामी? तदा सोन्धस्तमुवाच, हे गुरो मदीया दृष्टिर्भवेत्। ");
INSERT INTO sandev_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ततो यीशुस्तमुवाच याहि तव विश्वासस्त्वां स्वस्थमकार्षीत्, तस्मात् तत्क्षणं स दृष्टिं प्राप्य पथा यीशोः पश्चाद् ययौ। ");
INSERT INTO sandev_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","अनन्तरं तेषु यिरूशालमः समीपस्थयो र्बैत्फगीबैथनीयपुरयोरन्तिकस्थं जैतुननामाद्रिमागतेषु यीशुः प्रेषणकाले द्वौ शिष्याविदं वाक्यं जगाद, ");
INSERT INTO sandev_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","युवाममुं सम्मुखस्थं ग्रामं यातं, तत्र प्रविश्य यो नरं नावहत् तं गर्द्दभशावकं द्रक्ष्यथस्तं मोचयित्वानयतं। ");
INSERT INTO sandev_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","किन्तु युवां कर्म्मेदं कुतः कुरुथः? कथामिमां यदि कोपि पृच्छति तर्हि प्रभोरत्र प्रयोजनमस्तीति कथिते स शीघ्रं तमत्र प्रेषयिष्यति। ");
INSERT INTO sandev_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ततस्तौ गत्वा द्विमार्गमेलने कस्यचिद् द्वारस्य पार्श्वे तं गर्द्दभशावकं प्राप्य मोचयतः, ");
INSERT INTO sandev_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","एतर्हि तत्रोपस्थितलोकानां कश्चिद् अपृच्छत्, गर्द्दभशिशुं कुतो मोचयथः? ");
INSERT INTO sandev_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","तदा यीशोराज्ञानुसारेण तेभ्यः प्रत्युदिते तत्क्षणं तमादातुं तेऽनुजज्ञुः। ");
INSERT INTO sandev_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","अथ तौ यीशोः सन्निधिं गर्द्दभशिशुम् आनीय तदुपरि स्ववस्त्राणि पातयामासतुः; ततः स तदुपरि समुपविष्टः। ");
INSERT INTO sandev_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","तदानेके पथि स्ववासांसि पातयामासुः, परैश्च तरुशाखाश्छितवा मार्गे विकीर्णाः। ");
INSERT INTO sandev_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","अपरञ्च पश्चाद्गामिनोऽग्रगामिनश्च सर्व्वे जना उचैःस्वरेण वक्तुमारेभिरे, जय जय यः परमेश्वरस्य नाम्नागच्छति स धन्य इति। ");
INSERT INTO sandev_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","तथास्माकमं पूर्व्वपुरुषस्य दायूदो यद्राज्यं परमेश्वरनाम्नायाति तदपि धन्यं, सर्व्वस्मादुच्छ्राये स्वर्गे ईश्वरस्य जयो भवेत्। ");
INSERT INTO sandev_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","इत्थं यीशु र्यिरूशालमि मन्दिरं प्रविश्य चतुर्दिक्स्थानि सर्व्वाणि वस्तूनि दृष्टवान्; अथ सायंकाल उपस्थिते द्वादशशिष्यसहितो बैथनियं जगाम। ");
INSERT INTO sandev_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","अपरेहनि बैथनियाद् आगमनसमये क्षुधार्त्तो बभूव। ");
INSERT INTO sandev_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ततो दूरे सपत्रमुडुम्बरपादपं विलोक्य तत्र किञ्चित् फलं प्राप्तुं तस्य सन्निकृष्टं ययौ, तदानीं फलपातनस्य समयो नागच्छति। ततस्तत्रोपस्थितः पत्राणि विना किमप्यपरं न प्राप्य स कथितवान्, ");
INSERT INTO sandev_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","अद्यारभ्य कोपि मानवस्त्वत्तः फलं न भुञ्जीत; इमां कथां तस्य शिष्याः शुश्रुवुः। ");
INSERT INTO sandev_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","तदनन्तरं तेषु यिरूशालममायातेषु यीशु र्मन्दिरं गत्वा तत्रस्थानां बणिजां मुद्रासनानि पारावतविक्रेतृणाम् आसनानि च न्युब्जयाञ्चकार सर्व्वान् क्रेतृन् विक्रेतृंश्च बहिश्चकार। ");
INSERT INTO sandev_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","अपरं मन्दिरमध्येन किमपि पात्रं वोढुं सर्व्वजनं निवारयामास। ");
INSERT INTO sandev_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","लोकानुपदिशन् जगाद, मम गृहं सर्व्वजातीयानां प्रार्थनागृहम् इति नाम्ना प्रथितं भविष्यति एतत् किं शास्त्रे लिखितं नास्ति? किन्तु यूयं तदेव चोराणां गह्वरं कुरुथ। ");
INSERT INTO sandev_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","इमां वाणीं श्रुत्वाध्यापकाः प्रधानयाजकाश्च तं यथा नाशयितुं शक्नुवन्ति तथोेपायं मृगयामासुः, किन्तु तस्योपदेशात् सर्व्वे लोका विस्मयं गता अतस्ते तस्माद् बिभ्युः। ");
INSERT INTO sandev_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","अथ सायंसमय उपस्थिते यीशुर्नगराद् बहिर्वव्राज। ");
INSERT INTO sandev_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","अनन्तरं प्रातःकाले ते तेन मार्गेण गच्छन्तस्तमुडुम्बरमहीरुहं समूलं शुष्कं ददृशुः। ");
INSERT INTO sandev_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ततः पितरः पूर्व्ववाक्यं स्मरन् यीशुं बभाषं, हे गुरो पश्यतु य उडुम्बरविटपी भवता शप्तः स शुष्को बभूव। ");
INSERT INTO sandev_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ततो यीशुः प्रत्यवादीत्, यूयमीश्वरे विश्वसित। ");
INSERT INTO sandev_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","युष्मानहं यथार्थं वदामि कोपि यद्येतद्गिरिं वदति, त्वमुत्थाय गत्वा जलधौ पत, प्रोक्तमिदं वाक्यमवश्यं घटिष्यते, मनसा किमपि न सन्दिह्य चेदिदं विश्वसेत् तर्हि तस्य वाक्यानुसारेण तद् घटिष्यते। ");
INSERT INTO sandev_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","अतो हेतोरहं युष्मान् वच्मि, प्रार्थनाकाले यद्यदाकांक्षिष्यध्वे तत्तदवश्यं प्राप्स्यथ, इत्थं विश्वसित, ततः प्राप्स्यथ। ");
INSERT INTO sandev_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","अपरञ्च युष्मासु प्रार्थयितुं समुत्थितेषु यदि कोपि युष्माकम् अपराधी तिष्ठति, तर्हि तं क्षमध्वं, तथा कृते युष्माकं स्वर्गस्थः पितापि युष्माकमागांमि क्षमिष्यते। ");
INSERT INTO sandev_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","किन्तु यदि न क्षमध्वे तर्हि वः स्वर्गस्थः पितापि युष्माकमागांसि न क्षमिष्यते। ");
INSERT INTO sandev_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","अनन्तरं ते पुन र्यिरूशालमं प्रविविशुः, यीशु र्यदा मध्येमन्दिरम् इतस्ततो गच्छति, तदानीं प्रधानयाजका उपाध्यायाः प्राञ्चश्च तदन्तिकमेत्य कथामिमां पप्रच्छुः, ");
INSERT INTO sandev_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","त्वं केनादेशेन कर्म्माण्येतानि करोषि? तथैतानि कर्म्माणि कर्त्तां केनादिष्टोसि? ");
INSERT INTO sandev_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ततो यीशुः प्रतिगदितवान् अहमपि युष्मान् एककथां पृच्छामि, यदि यूयं तस्या उत्तरं कुरुथ, तर्हि कयाज्ञयाहं कर्म्माण्येतानि करोमि तद् युष्मभ्यं कथयिष्यामि। ");
INSERT INTO sandev_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","योहनो मज्जनम् ईश्वरात् जातं किं मानवात्? तन्मह्यं कथयत। ");
INSERT INTO sandev_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","ते परस्परं विवेक्तुं प्रारेभिरे, तद् ईश्वराद् बभूवेति चेद् वदामस्तर्हि कुतस्तं न प्रत्यैत? कथमेतां कथयिष्यति। ");
INSERT INTO sandev_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","मानवाद् अभवदिति चेद् वदामस्तर्हि लोकेभ्यो भयमस्ति यतो हेतोः सर्व्वे योहनं सत्यं भविष्यद्वादिनं मन्यन्ते। ");
INSERT INTO sandev_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","अतएव ते यीशुं प्रत्यवादिषु र्वयं तद् वक्तुं न शक्नुमः। यीशुरुवाच, तर्हि येनादेशेन कर्म्माण्येतानि करोमि, अहमपि युष्मभ्यं तन्न कथयिष्यामि। ");
INSERT INTO sandev_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","अनन्तरं यीशु र्दृष्टान्तेन तेभ्यः कथयितुमारेभे, कश्चिदेको द्राक्षाक्षेत्रं विधाय तच्चतुर्दिक्षु वारणीं कृत्वा तन्मध्ये द्राक्षापेषणकुण्डम् अखनत्, तथा तस्य गडमपि निर्म्मितवान् ततस्तत्क्षेत्रं कृषीवलेषु समर्प्य दूरदेशं जगाम। ");
INSERT INTO sandev_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","तदनन्तरं फलकाले कृषीवलेभ्यो द्राक्षाक्षेत्रफलानि प्राप्तुं तेषां सविधे भृत्यम् एकं प्राहिणोत्। ");
INSERT INTO sandev_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","किन्तु कृषीवलास्तं धृत्वा प्रहृत्य रिक्तहस्तं विससृजुः। ");
INSERT INTO sandev_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ततः स पुनरन्यमेकं भृत्यं प्रषयामास, किन्तु ते कृषीवलाः पाषाणाघातैस्तस्य शिरो भङ्क्त्वा सापमानं तं व्यसर्जन्। ");
INSERT INTO sandev_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ततः परं सोपरं दासं प्राहिणोत् तदा ते तं जघ्नुः, एवम् अनेकेषां कस्यचित् प्रहारः कस्यचिद् वधश्च तैः कृतः। ");
INSERT INTO sandev_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ततः परं मया स्वपुत्रे प्रहिते ते तमवश्यं सम्मंस्यन्ते, इत्युक्त्वावशेषे तेषां सन्निधौ निजप्रियम् अद्वितीयं पुत्रं प्रेषयामास। ");
INSERT INTO sandev_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","किन्तु कृषीवलाः परस्परं जगदुः, एष उत्तराधिकारी, आगच्छत वयमेनं हन्मस्तथा कृते ऽधिकारोयम् अस्माकं भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ततस्तं धृत्वा हत्वा द्राक्षाक्षेत्राद् बहिः प्राक्षिपन्। ");
INSERT INTO sandev_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","अनेनासौ द्राक्षाक्षेत्रपतिः किं करिष्यति? स एत्य तान् कृषीवलान् संहत्य तत्क्षेत्रम् अन्येषु कृषीवलेषु समर्पयिष्यति। ");
INSERT INTO sandev_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","अपरञ्च, \"स्थपतयः करिष्यन्ति ग्रावाणं यन्तु तुच्छकं। प्राधानप्रस्तरः कोणे स एव संभविष्यति। ");
INSERT INTO sandev_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","एतत् कर्म्म परेशस्यांद्भुतं नो दृष्टितो भवेत्॥\" इमां शास्त्रीयां लिपिं यूयं किं नापाठिष्ट? ");
INSERT INTO sandev_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","तदानीं स तानुद्दिश्य तां दृष्टान्तकथां कथितवान्, त इत्थं बुद्व्वा तं धर्त्तामुद्यताः, किन्तु लोकेभ्यो बिभ्युः, तदनन्तरं ते तं विहाय वव्रजुः। ");
INSERT INTO sandev_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","अपरञ्च ते तस्य वाक्यदोषं धर्त्तां कतिपयान् फिरूशिनो हेरोदीयांश्च लोकान् तदन्तिकं प्रेषयामासुः। ");
INSERT INTO sandev_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","त आगत्य तमवदन्, हे गुरो भवान् तथ्यभाषी कस्याप्यनुरोधं न मन्यते, पक्षपातञ्च न करोति, यथार्थत ईश्वरीयं मार्गं दर्शयति वयमेतत् प्रजानीमः, कैसराय करो देयो न वां? वयं दास्यामो न वा? ");
INSERT INTO sandev_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","किन्तु स तेषां कपटं ज्ञात्वा जगाद, कुतो मां परीक्षध्वे? एकं मुद्रापादं समानीय मां दर्शयत। ");
INSERT INTO sandev_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","तदा तैरेकस्मिन् मुद्रापादे समानीते स तान् पप्रच्छ, अत्र लिखितं नाम मूर्त्ति र्वा कस्य? ते प्रत्यूचुः, कैसरस्य। ");
INSERT INTO sandev_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","तदा यीशुरवदत् तर्हि कैसरस्य द्रव्याणि कैसराय दत्त, ईश्वरस्य द्रव्याणि तु ईश्वराय दत्त; ततस्ते विस्मयं मेनिरे। ");
INSERT INTO sandev_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","अथ मृतानामुत्थानं ये न मन्यन्ते ते सिदूकिनो यीशोः समीपमागत्य तं पप्रच्छुः; ");
INSERT INTO sandev_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","हे गुरो कश्चिज्जनो यदि निःसन्ततिः सन् भार्य्यायां सत्यां म्रियते तर्हि तस्य भ्राता तस्य भार्य्यां गृहीत्वा भ्रातु र्वंशोत्पत्तिं करिष्यति, व्यवस्थामिमां मूसा अस्मान् प्रति व्यलिखत्। ");
INSERT INTO sandev_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","किन्तु केचित् सप्त भ्रातर आसन्, ततस्तेषां ज्येष्ठभ्राता विवह्य निःसन्ततिः सन् अम्रियत। ");
INSERT INTO sandev_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ततो द्वितीयो भ्राता तां स्त्रियमगृहणत् किन्तु सोपि निःसन्ततिः सन् अम्रियत; अथ तृतीयोपि भ्राता तादृशोभवत्। ");
INSERT INTO sandev_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","इत्थं सप्तैव भ्रातरस्तां स्त्रियं गृहीत्वा निःसन्तानाः सन्तोऽम्रियन्त, सर्व्वशेषे सापि स्त्री म्रियते स्म। ");
INSERT INTO sandev_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","अथ मृतानामुत्थानकाले यदा त उत्थास्यन्ति तदा तेषां कस्य भार्य्या सा भविष्यति? यतस्ते सप्तैव तां व्यवहन्। ");
INSERT INTO sandev_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ततो यीशुः प्रत्युवाच शास्त्रम् ईश्वरशक्तिञ्च यूयमज्ञात्वा किमभ्राम्यत न? ");
INSERT INTO sandev_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","मृतलोकानामुत्थानं सति ते न विवहन्ति वाग्दत्ता अपि न भवन्ति, किन्तु स्वर्गीयदूतानां सदृशा भवन्ति। ");
INSERT INTO sandev_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","पुनश्च \"अहम् इब्राहीम ईश्वर इस्हाक ईश्वरो याकूबश्चेश्वरः\" यामिमां कथां स्तम्बमध्ये तिष्ठन् ईश्वरो मूसामवादीत् मृतानामुत्थानार्थे सा कथा मूसालिखिते पुस्तके किं युष्माभि र्नापाठि? ");
INSERT INTO sandev_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ईश्वरो जीवतां प्रभुः किन्तु मृतानां प्रभु र्न भवति, तस्माद्धेतो र्यूयं महाभ्रमेण तिष्ठथ। ");
INSERT INTO sandev_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","एतर्हि एकोध्यापक एत्य तेषामित्थं विचारं शुश्राव; यीशुस्तेषां वाक्यस्य सदुत्तरं दत्तवान् इति बुद्व्वा तं पृष्टवान् सर्व्वासाम् आज्ञानां का श्रेष्ठा? ततो यीशुः प्रत्युवाच, ");
INSERT INTO sandev_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","\"हे इस्रायेल्लोका अवधत्त, अस्माकं प्रभुः परमेश्वर एक एव, ");
INSERT INTO sandev_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","यूयं सर्व्वन्तःकरणैः सर्व्वप्राणैः सर्व्वचित्तैः सर्व्वशक्तिभिश्च तस्मिन् प्रभौ परमेश्वरे प्रीयध्वं,\" इत्याज्ञा श्रेष्ठा। ");
INSERT INTO sandev_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","तथा \"स्वप्रतिवासिनि स्ववत् प्रेम कुरुध्वं,\" एषा या द्वितीयाज्ञा सा तादृशी; एताभ्यां द्वाभ्याम् आज्ञाभ्याम् अन्या काप्याज्ञा श्रेष्ठा नास्ति। ");
INSERT INTO sandev_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","तदा सोध्यापकस्तमवदत्, हे गुरो सत्यं भवान् यथार्थं प्रोक्तवान् यत एकस्माद् ईश्वराद् अन्यो द्वितीय ईश्वरो नास्ति; ");
INSERT INTO sandev_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","अपरं सर्व्वान्तःकरणैः सर्व्वप्राणैः सर्व्वचित्तैः सर्व्वशक्तिभिश्च ईश्वरे प्रेमकरणं तथा स्वमीपवासिनि स्ववत् प्रेमकरणञ्च सर्व्वेभ्यो होमबलिदानादिभ्यः श्रष्ठं भवति। ");
INSERT INTO sandev_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","ततो यीशुः सुबुद्धेरिव तस्येदम् उत्तरं श्रुत्वा तं भाषितवान् त्वमीश्वरस्य राज्यान्न दूरोसि।इतः परं तेन सह कस्यापि वाक्यस्य विचारं कर्त्तां कस्यापि प्रगल्भता न जाता। ");
INSERT INTO sandev_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","अनन्तरं मध्येमन्दिरम् उपदिशन् यीशुरिमं प्रश्नं चकार, अध्यापका अभिषिक्तं (तारकं) कुतो दायूदः सन्तानं वदन्ति? ");
INSERT INTO sandev_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","स्वयं दायूद् पवित्रस्यात्मन आवेशेनेदं कथयामास। यथा। \"मम प्रभुमिदं वाक्यवदत् परमेश्वरः। तव शत्रूनहं यावत् पादपीठं करोमि न। तावत् कालं मदीये त्वं दक्षपार्श्व् उपाविश।\" ");
INSERT INTO sandev_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","यदि दायूद् तं प्रभूं वदति तर्हि कथं स तस्य सन्तानो भवितुमर्हति? इतरे लोकास्तत्कथां श्रुत्वाननन्दुः। ");
INSERT INTO sandev_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","तदानीं स तानुपदिश्य कथितवान् ये नरा दीर्घपरिधेयानि हट्टे विपनौ च ");
INSERT INTO sandev_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","लोककृतनमस्कारान् भजनगृहे प्रधानासनानि भोजनकाले प्रधानस्थानानि च काङ्क्षन्ते; ");
INSERT INTO sandev_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","विधवानां सर्व्वस्वं ग्रसित्वा छलाद् दीर्घकालं प्रार्थयन्ते तेभ्य उपाध्यायेभ्यः सावधाना भवत; तेऽधिकतरान् दण्डान् प्राप्स्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","तदनन्तरं लोका भाण्डागारे मुद्रा यथा निक्षिपन्ति भाण्डागारस्य सम्मुखे समुपविश्य यीशुस्तदवलुलोक; तदानीं बहवो धनिनस्तस्य मध्ये बहूनि धनानि निरक्षिपन्। ");
INSERT INTO sandev_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","पश्चाद् एका दरिद्रा विधवा समागत्य द्विपणमूल्यां मुद्रैकां तत्र निरक्षिपत्। ");
INSERT INTO sandev_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","तदा यीशुः शिष्यान् आहूय कथितवान् युष्मानहं यथार्थं वदामि ये ये भाण्डागारेऽस्मिन धनानि निःक्षिपन्ति स्म तेभ्यः सर्व्वेभ्य इयं विधवा दरिद्राधिकम् निःक्षिपति स्म। ");
INSERT INTO sandev_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","यतस्ते प्रभूतधनस्य किञ्चित् निरक्षिपन् किन्तु दीनेयं स्वदिनयापनयोग्यं किञ्चिदपि न स्थापयित्वा सर्व्वस्वं निरक्षिपत्। ");
INSERT INTO sandev_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","अनन्तरं मन्दिराद् बहिर्गमनकाले तस्य शिष्याणामेकस्तं व्याहृतवान् हे गुरो पश्यतु कीदृशाः पाषाणाः कीदृक् च निचयनं। ");
INSERT INTO sandev_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","तदा यीशुस्तम् अवदत् त्वं किमेतद् बृहन्निचयनं पश्यसि? अस्यैकपाषाणोपि द्वितीयपाषाणोपरि न स्थास्यति सर्व्वे ऽधःक्षेप्स्यन्ते। ");
INSERT INTO sandev_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","अथ यस्मिन् काले जैतुन्गिरौ मन्दिरस्य सम्मुखे स समुपविष्टस्तस्मिन् काले पितरो याकूब् योहन् आन्द्रियश्चैते तं रहसि पप्रच्छुः, ");
INSERT INTO sandev_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","एता घटनाः कदा भविष्यन्ति? तथैतत्सर्व्वासां सिद्ध्युपक्रमस्य वा किं चिह्नं? तदस्मभ्यं कथयतु भवान्। ");
INSERT INTO sandev_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ततो याशुस्तान् वक्तुमारेभे, कोपि यथा युष्मान् न भ्रामयति तथात्र यूयं सावधाना भवत। ");
INSERT INTO sandev_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","यतः ख्रीष्टोहमिति कथयित्वा मम नाम्नानेके समागत्य लोकानां भ्रमं जनयिष्यन्ति; ");
INSERT INTO sandev_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","किन्तु यूयं रणस्य वार्त्तां रणाडम्बरञ्च श्रुत्वा मा व्याकुला भवत, घटना एता अवश्यम्माविन्यः; किन्त्वापाततो न युगान्तो भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","देशस्य विपक्षतया देशो राज्यस्य विपक्षतया च राज्यमुत्थास्यति, तथा स्थाने स्थाने भूमिकम्पो दुर्भिक्षं महाक्लेशाश्च समुपस्थास्यन्ति, सर्व्व एते दुःखस्यारम्भाः। ");
INSERT INTO sandev_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","किन्तु यूयम् आत्मार्थे सावधानास्तिष्ठत, यतो लोका राजसभायां युष्मान् समर्पयिष्यन्ति, तथा भजनगृहे प्रहरिष्यन्ति; यूयं मदर्थे देशाधिपान् भूपांश्च प्रति साक्ष्यदानाय तेषां सम्मुखे उपस्थापयिष्यध्वे। ");
INSERT INTO sandev_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","शेषीभवनात् पूर्व्वं सर्व्वान् देशीयान् प्रति सुसंवादः प्रचारयिष्यते। ");
INSERT INTO sandev_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","किन्तु यदा ते युष्मान् धृत्वा समर्पयिष्यन्ति तदा यूयं यद्यद् उत्तरं दास्यथ, तदग्र तस्य विवेचनं मा कुरुत तदर्थं किञ्चिदपि मा चिन्तयत च, तदानीं युष्माकं मनःसु यद्यद् वाक्यम् उपस्थापयिष्यते तदेव वदिष्यथ, यतो यूयं न तद्वक्तारः किन्तु पवित्र आत्मा तस्य वक्ता। ");
INSERT INTO sandev_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","तदा भ्राता भ्रातरं पिता पुत्रं घातनार्थं परहस्तेषु समर्पयिष्यते, तथा पत्यानि मातापित्रो र्विपक्षतया तौ घातयिष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","मम नामहेतोः सर्व्वेषां सविधे यूयं जुगुप्सिता भविष्यथ, किन्तु यः कश्चित् शेषपर्य्यन्तं धैर्य्यम् आलम्बिष्यते सएव परित्रास्यते। ");
INSERT INTO sandev_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","दानियेल्भविष्यद्वादिना प्रोक्तं सर्व्वनाशि जुगुप्सितञ्च वस्तु यदा त्वयोग्यस्थाने विद्यमानं द्रक्षथ (यो जनः पठति स बुध्यतां) तदा ये यिहूदीयदेशे तिष्ठन्ति ते महीध्रं प्रति पलायन्तां; ");
INSERT INTO sandev_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","तथा यो नरो गृहोपरि तिष्ठति स गृहमध्यं नावरोहतु, तथा किमपि वस्तु ग्रहीतुं मध्येगृहं न प्रविशतु; ");
INSERT INTO sandev_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","तथा च यो नरः क्षेत्रे तिष्ठति सोपि स्ववस्त्रं ग्रहीतुं परावृत्य न व्रजतु। ");
INSERT INTO sandev_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","तदानीं गर्ब्भवतीनां स्तन्यदात्रीणाञ्च योषितां दुर्गति र्भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","युष्माकं पलायनं शीतकाले यथा न भवति तदर्थं प्रार्थयध्वं। ");
INSERT INTO sandev_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","यतस्तदा यादृशी दुर्घटना घटिष्यते तादृशी दुर्घटना ईश्वरसृष्टेः प्रथममारभ्याद्य यावत् कदापि न जाता न जनिष्यते च। ");
INSERT INTO sandev_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","अपरञ्च परमेश्वरो यदि तस्य समयस्य संक्षेपं न करोति तर्हि कस्यापि प्राणभृतो रक्षा भवितुं न शक्ष्यति, किन्तु यान् जनान् मनोनीतान् अकरोत् तेषां स्वमनोनीतानां हेतोः स तदनेहसं संक्षेप्स्यति। ");
INSERT INTO sandev_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","अन्यच्च पश्यत ख्रीष्टोत्र स्थाने वा तत्र स्थाने विद्यते, तस्मिन्काले यदि कश्चिद् युष्मान् एतादृशं वाक्यं व्याहरति, तर्हि तस्मिन् वाक्ये भैव विश्वसित। ");
INSERT INTO sandev_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","यतोनेके मिथ्याख्रीष्टा मिथ्याभविष्यद्वादिनश्च समुपस्थाय बहूनि चिह्नान्यद्भुतानि कर्म्माणि च दर्शयिष्यन्ति; तथा यदि सम्भवति तर्हि मनोनीतलोकानामपि मिथ्यामतिं जनयिष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","पश्यत घटनातः पूर्व्वं सर्व्वकार्य्यस्य वार्त्तां युष्मभ्यमदाम्, यूयं सावधानास्तिष्ठत। ");
INSERT INTO sandev_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","अपरञ्च तस्य क्लेशकालस्याव्यवहिते परकाले भास्करः सान्धकारो भविष्यति तथैव चन्द्रश्चन्द्रिकां न दास्यति। ");
INSERT INTO sandev_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","नभःस्थानि नक्षत्राणि पतिष्यन्ति, व्योममण्डलस्था ग्रहाश्च विचलिष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","तदानीं महापराक्रमेण महैश्वर्य्येण च मेघमारुह्य समायान्तं मानवसुतं मानवाः समीक्षिष्यन्ते। ");
INSERT INTO sandev_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","अन्यच्च स निजदूतान् प्रहित्य नभोभूम्योः सीमां यावद् जगतश्चतुर्दिग्भ्यः स्वमनोनीतलोकान् संग्रहीष्यति। ");
INSERT INTO sandev_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","उडुम्बरतरो र्दृष्टान्तं शिक्षध्वं यदोडुम्बरस्य तरो र्नवीनाः शाखा जायन्ते पल्लवादीनि च र्निगच्छन्ति, तदा निदाघकालः सविधो भवतीति यूयं ज्ञातुं शक्नुथ। ");
INSERT INTO sandev_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","तद्वद् एता घटना दृष्ट्वा स कालो द्वार्य्युपस्थित इति जानीत। ");
INSERT INTO sandev_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","युष्मानहं यथार्थं वदामि, आधुनिकलोकानां गमनात् पूर्व्वं तानि सर्व्वाणि घटिष्यन्ते। ");
INSERT INTO sandev_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","द्यावापृथिव्यो र्विचलितयोः सत्यो र्मदीया वाणी न विचलिष्यति। ");
INSERT INTO sandev_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","अपरञ्च स्वर्गस्थदूतगणो वा पुत्रो वा तातादन्यः कोपि तं दिवसं तं दण्डं वा न ज्ञापयति। ");
INSERT INTO sandev_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","अतः स समयः कदा भविष्यति, एतज्ज्ञानाभावाद् यूयं सावधानास्तिष्ठत, सतर्काश्च भूत्वा प्रार्थयध्वं; ");
INSERT INTO sandev_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","यद्वत् कश्चित् पुमान् स्वनिवेशनाद् दूरदेशं प्रति यात्राकरणकाले दासेषु स्वकार्य्यस्य भारमर्पयित्वा सर्व्वान् स्वे स्वे कर्म्मणि नियोजयति; अपरं दौवारिकं जागरितुं समादिश्य याति, तद्वन् नरपुत्रः। ");
INSERT INTO sandev_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","गृहपतिः सायंकाले निशीथे वा तृतीययामे वा प्रातःकाले वा कदागमिष्यति तद् यूयं न जानीथ; ");
INSERT INTO sandev_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","स हठादागत्य यथा युष्मान् निद्रितान् न पश्यति, तदर्थं जागरितास्तिष्ठत। ");
INSERT INTO sandev_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","युष्मानहं यद् वदामि तदेव सर्व्वान् वदामि, जागरितास्तिष्ठतेति। ");
INSERT INTO sandev_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","तदा निस्तारोत्सवकिण्वहीनपूपोत्सवयोरारम्भस्य दिनद्वये ऽवशिष्टे प्रधानयाजका अध्यापकाश्च केनापि छलेन यीशुं धर्त्तां हन्तुञ्च मृगयाञ्चक्रिरे; ");
INSERT INTO sandev_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","किन्तु लोकानां कलहभयादूचिरे, नचोत्सवकाल उचितमेतदिति। ");
INSERT INTO sandev_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","अनन्तरं बैथनियापुुरे शिमोनकुष्ठिनो गृहे योशौ भोत्कुमुपविष्टे सति काचिद् योषित् पाण्डरपाषाणस्य सम्पुटकेन महार्घ्योत्तमतैलम् आनीय सम्पुटकं भंक्त्वा तस्योत्तमाङ्गे तैलधारां पातयाञ्चक्रे। ");
INSERT INTO sandev_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","तस्मात् केचित् स्वान्ते कुप्यन्तः कथितवंन्तः कुतोयं तैलापव्ययः? ");
INSERT INTO sandev_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","यद्येतत् तैल व्यक्रेष्यत तर्हि मुद्रापादशतत्रयादप्यधिकं तस्य प्राप्तमूल्यं दरिद्रलोकेभ्यो दातुमशक्ष्यत, कथामेतां कथयित्वा तया योषिता साकं वाचायुह्यन्। ");
INSERT INTO sandev_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","किन्तु यीशुरुवाच, कुत एतस्यै कृच्छ्रं ददासि? मह्यमियं कर्म्मोत्तमं कृतवती। ");
INSERT INTO sandev_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","दरिद्राः सर्व्वदा युष्माभिः सह तिष्ठन्ति, तस्माद् यूयं यदेच्छथ तदैव तानुपकर्त्तां शक्नुथ, किन्त्वहं युभाभिः सह निरन्तरं न तिष्ठामि। ");
INSERT INTO sandev_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","अस्या यथासाध्यं तथैवाकरोदियं, श्मशानयापनात् पूर्व्वं समेत्य मद्वपुषि तैलम् अमर्द्दयत्। ");
INSERT INTO sandev_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","अहं युष्मभ्यं यथार्थं कथयामि, जगतां मध्ये यत्र यत्र सुसंवादोयं प्रचारयिष्यते तत्र तत्र योषित एतस्याः स्मरणार्थं तत्कृतकर्म्मैतत् प्रचारयिष्यते। ");
INSERT INTO sandev_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ततः परं द्वादशानां शिष्याणामेक ईष्करियोतीययिहूदाख्यो यीशुं परकरेषु समर्पयितुं प्रधानयाजकानां समीपमियाय। ");
INSERT INTO sandev_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ते तस्य वाक्यं समाकर्ण्य सन्तुष्टाः सन्तस्तस्मै मुद्रा दातुं प्रत्यजानत; तस्मात् स तं तेषां करेषु समर्पणायोपायं मृगयामास। ");
INSERT INTO sandev_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","अनन्तरं किण्वशून्यपूपोत्सवस्य प्रथमेऽहनि निस्तारोत्मवार्थं मेषमारणासमये शिष्यास्तं पप्रच्छः कुत्र गत्वा वयं निस्तारोत्सवस्य भोज्यमासादयिष्यामः? किमिच्छति भवान्? ");
INSERT INTO sandev_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","तदानीं स तेषां द्वयं प्रेरयन् बभाषे युवयोः पुरमध्यं गतयोः सतो र्यो जनः सजलकुम्भं वहन् युवां साक्षात् करिष्यति तस्यैव पश्चाद् यातं; ");
INSERT INTO sandev_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","स यत् सदनं प्रवेक्ष्यति तद्भवनपतिं वदतं, गुरुराह यत्र सशिष्योहं निस्तारोत्सवीयं भोजनं करिष्यामि, सा भोजनशाला कुत्रास्ति? ");
INSERT INTO sandev_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ततः स परिष्कृतां सुसज्जितां बृहतीचञ्च यां शालां दर्शयिष्यति तस्यामस्मदर्थं भोज्यद्रव्याण्यासादयतं। ");
INSERT INTO sandev_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ततः शिष्यौ प्रस्थाय पुरं प्रविश्य स यथोक्तवान् तथैव प्राप्य निस्तारोत्सवस्य भोज्यद्रव्याणि समासादयेताम्। ");
INSERT INTO sandev_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","अनन्तरं यीशुः सायंकाले द्वादशभिः शिष्यैः सार्द्धं जगाम; ");
INSERT INTO sandev_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","सर्व्वेषु भोजनाय प्रोपविष्टेषु स तानुदितवान् युष्मानहं यथार्थं व्याहरामि, अत्र युष्माकमेको जनो यो मया सह भुंक्ते मां परकेरेषु समर्पयिष्यते। ");
INSERT INTO sandev_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","तदानीं ते दुःखिताः सन्त एकैकशस्तं प्रष्टुमारब्धवन्तः स किमहं? पश्चाद् अन्य एकोभिदधे स किमहं? ");
INSERT INTO sandev_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ततः स प्रत्यवदद् एतेषां द्वादशानां यो जनो मया समं भोजनापात्रे पाणिं मज्जयिष्यति स एव। ");
INSERT INTO sandev_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","मनुजतनयमधि यादृशं लिखितमास्ते तदनुरूपा गतिस्तस्य भविष्यति, किन्तु यो जनो मानवसुतं समर्पयिष्यते हन्त तस्य जन्माभावे सति भद्रमभविष्यत्। ");
INSERT INTO sandev_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","अपरञ्च तेषां भोजनसमये यीशुः पूपं गृहीत्वेश्वरगुणान् अनुकीर्त्य भङ्क्त्वा तेभ्यो दत्त्वा बभाषे, एतद् गृहीत्वा भुञ्जीध्वम् एतन्मम विग्रहरूपं। ");
INSERT INTO sandev_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","अनन्तरं स कंसं गृहीत्वेश्वरस्य गुणान् कीर्त्तयित्वा तेभ्यो ददौ, ततस्ते सर्व्वे पपुः। ");
INSERT INTO sandev_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","अपरं स तानवादीद् बहूनां निमित्तं पातितं मम नवीननियमरूपं शोणितमेतत्। ");
INSERT INTO sandev_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","युष्मानहं यथार्थं वदामि, ईश्वरस्य राज्ये यावत् सद्योजातं द्राक्षारसं न पास्यामि,तावदहं द्राक्षाफलरसं पुन र्न पास्यामि। ");
INSERT INTO sandev_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","तदनन्तरं ते गीतमेकं संगीय बहि र्जैतुनं शिखरिणं ययुः ");
INSERT INTO sandev_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","अथ यीशुस्तानुवाच निशायामस्यां मयि युष्माकं सर्व्वेषां प्रत्यूहो भविष्यति यतो लिखितमास्ते यथा, मेषाणां रक्षकञ्चाहं प्रहरिष्यामि वै ततः। मेषाणां निवहो नूनं प्रविकीर्णो भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","कन्तु मदुत्थाने जाते युष्माकमग्रेऽहं गालीलं व्रजिष्यामि। ");
INSERT INTO sandev_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","तदा पितरः प्रतिबभाषे, यद्यपि सर्व्वेषां प्रत्यूहो भवति तथापि मम नैव भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ततो यीशुरुक्तावान् अहं तुभ्यं तथ्यं कथयामि, क्षणादायामद्य कुक्कुटस्य द्वितीयवाररवणात् पूर्व्वं त्वं वारत्रयं मामपह्नोष्यसे। ");
INSERT INTO sandev_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","किन्तु स गाढं व्याहरद् यद्यपि त्वया सार्द्धं मम प्राणो याति तथापि कथमपि त्वां नापह्नोष्ये; सर्व्वेऽपीतरे तथैव बभाषिरे। ");
INSERT INTO sandev_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","अपरञ्च तेषु गेत्शिमानीनामकं स्थान गतेषु स शिष्यान् जगाद, यावदहं प्रार्थये तावदत्र स्थाने यूयं समुपविशत। ");
INSERT INTO sandev_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","अथ स पितरं याकूबं योहनञ्च गृहीत्वा वव्राज; अत्यन्तं त्रासितो व्याकुलितश्च तेभ्यः कथयामास, ");
INSERT INTO sandev_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","निधनकालवत् प्राणो मेऽतीव दःखमेति, यूयं जाग्रतोत्र स्थाने तिष्ठत। ");
INSERT INTO sandev_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ततः स किञ्चिद्दूरं गत्वा भूमावधोमुखः पतित्वा प्रार्थितवानेतत्, यदि भवितुं शक्यं तर्हि दुःखसमयोयं मत्तो दूरीभवतु। ");
INSERT INTO sandev_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","अपरमुदितवान् हे पित र्हे पितः सर्व्वें त्वया साध्यं, ततो हेतोरिमं कंसं मत्तो दूरीकुरु, किन्तु तन् ममेच्छातो न तवेच्छातो भवतु। ");
INSERT INTO sandev_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","ततः परं स एत्य तान् निद्रितान् निरीक्ष्य पितरं प्रोवाच, शिमोन् त्वं किं निद्रासि? घटिकामेकाम् अपि जागरितुं न शक्नोषि? ");
INSERT INTO sandev_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","परीक्षायां यथा न पतथ तदर्थं सचेतनाः सन्तः प्रार्थयध्वं; मन उद्युक्तमिति सत्यं किन्तु वपुरशक्तिकं। ");
INSERT INTO sandev_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","अथ स पुनर्व्रजित्वा पूर्व्ववत् प्रार्थयाञ्चक्रे। ");
INSERT INTO sandev_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","परावृत्यागत्य पुनरपि तान् निद्रितान् ददर्श तदा तेषां लोचनानि निद्रया पूर्णानि, तस्मात्तस्मै का कथा कथयितव्या त एतद् बोद्धुं न शेकुः। ");
INSERT INTO sandev_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ततःपरं तृतीयवारं आगत्य तेभ्यो ऽकथयद् इदानीमपि शयित्वा विश्राम्यथ? यथेष्टं जातं, समयश्चोपस्थितः पश्यत मानवतनयः पापिलोकानां पाणिषु समर्प्यते। ");
INSERT INTO sandev_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","उत्तिष्ठत, वयं व्रजामो यो जनो मां परपाणिषु समर्पयिष्यते पश्यत स समीपमायातः। ");
INSERT INTO sandev_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","इमां कथां कथयति स, एतर्हिद्वादशानामेको यिहूदा नामा शिष्यः प्रधानयाजकानाम् उपाध्यायानां प्राचीनलोकानाञ्च सन्निधेः खङ्गलगुडधारिणो बहुलोकान् गृहीत्वा तस्य समीप उपस्थितवान्। ");
INSERT INTO sandev_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","अपरञ्चासौ परपाणिषु समर्पयिता पूर्व्वमिति सङ्केतं कृतवान् यमहं चुम्बिष्यामि स एवासौ तमेव धृत्वा सावधानं नयत। ");
INSERT INTO sandev_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","अतो हेतोः स आगत्यैव योशोः सविधं गत्वा हे गुरो हे गुरो, इत्युक्त्वा तं चुचुम्ब। ");
INSERT INTO sandev_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","तदा ते तदुपरि पाणीनर्पयित्वा तं दध्नुः। ");
INSERT INTO sandev_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ततस्तस्य पार्श्वस्थानां लोकानामेकः खङ्गं निष्कोषयन् महायाजकस्य दासमेकं प्रहृत्य तस्य कर्णं चिच्छेद। ");
INSERT INTO sandev_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","पश्चाद् यीशुस्तान् व्याजहार खङ्गान् लगुडांश्च गृहीत्वा मां किं चौरं धर्त्तां समायाताः? ");
INSERT INTO sandev_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","मध्येमन्दिरं समुपदिशन् प्रत्यहं युष्माभिः सह स्थितवानतहं, तस्मिन् काले यूयं मां नादीधरत, किन्त्वनेन शास्त्रीयं वचनं सेधनीयं। ");
INSERT INTO sandev_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","तदा सर्व्वे शिष्यास्तं परित्यज्य पलायाञ्चक्रिरे। ");
INSERT INTO sandev_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","अथैको युवा मानवो नग्नकाये वस्त्रमेकं निधाय तस्य पश्चाद् व्रजन् युवलोकै र्धृतो ");
INSERT INTO sandev_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","वस्त्रं विहाय नग्नः पलायाञ्चक्रे। ");
INSERT INTO sandev_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","अपरञ्च यस्मिन् स्थाने प्रधानयाजका उपाध्यायाः प्राचीनलोकाश्च महायाजकेन सह सदसि स्थितास्तस्मिन् स्थाने महायाजकस्य समीपं यीशुं निन्युः। ");
INSERT INTO sandev_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","पितरो दूरे तत्पश्चाद् इत्वा महायाजकस्याट्टालिकां प्रविश्य किङ्करैः सहोपविश्य वह्नितापं जग्राह। ");
INSERT INTO sandev_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","तदानीं प्रधानयाजका मन्त्रिणश्च यीशुं घातयितुं तत्प्रातिकूल्येन साक्षिणो मृगयाञ्चक्रिरे, किन्तु न प्राप्ताः। ");
INSERT INTO sandev_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","अनेकैस्तद्विरुद्धं मृषासाक्ष्ये दत्तेपि तेषां वाक्यानि न समगच्छन्त। ");
INSERT INTO sandev_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","सर्व्वशेषे कियन्त उत्थाय तस्य प्रातिकूल्येन मृषासाक्ष्यं दत्त्वा कथयामासुः, ");
INSERT INTO sandev_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","इदं करकृतमन्दिरं विनाश्य दिनत्रयमध्ये पुनरपरम् अकरकृतं मन्दिरं निर्म्मास्यामि, इति वाक्यम् अस्य मुखात् श्रुतमस्माभिरिति। ");
INSERT INTO sandev_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","किन्तु तत्रापि तेषां साक्ष्यकथा न सङ्गाताः। ");
INSERT INTO sandev_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","अथ महायाजको मध्येसभम् उत्थाय यीशुं व्याजहार, एते जनास्त्वयि यत् साक्ष्यमदुः त्वमेतस्य किमप्युत्तरं किं न दास्यसि? ");
INSERT INTO sandev_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","किन्तु स किमप्युत्तरं न दत्वा मौनीभूय तस्यौ; ततो महायाजकः पुनरपि तं पृष्टावान् त्वं सच्चिदानन्दस्य तनयो ऽभिषिक्तस्त्रता? ");
INSERT INTO sandev_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","तदा यीशुस्तं प्रोवाच भवाम्यहम् यूयञ्च सर्व्वशक्तिमतो दक्षीणपार्श्वे समुपविशन्तं मेघ मारुह्य समायान्तञ्च मनुष्यपुत्रं सन्द्रक्ष्यथ। ");
INSERT INTO sandev_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","तदा महायाजकः स्वं वमनं छित्वा व्यावहरत् ");
INSERT INTO sandev_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","किमस्माकं साक्षिभिः प्रयोजनम्? ईश्वरनिन्दावाक्यं युष्माभिरश्रावि किं विचारयथ? तदानीं सर्व्वे जगदुरयं निधनदण्डमर्हति। ");
INSERT INTO sandev_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","ततः कश्चित् कश्चित् तद्वपुषि निष्ठीवं निचिक्षेप तथा तन्मुखमाच्छाद्य चपेटेन हत्वा गदितवान् गणयित्वा वद, अनुचराश्च चपेटैस्तमाजघ्नुः ");
INSERT INTO sandev_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ततः परं पितरेऽट्टालिकाधःकोष्ठे तिष्ठति महायाजकस्यैका दासी समेत्य ");
INSERT INTO sandev_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","तं विह्नितापं गृह्लन्तं विलोक्य तं सुनिरीक्ष्य बभाषे त्वमपि नासरतीययीशोः सङ्गिनाम् एको जन आसीः। ");
INSERT INTO sandev_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","किन्तु सोपह्नुत्य जगाद तमहं न वद्मि त्वं यत् कथयमि तदप्यहं न बुद्ध्ये। तदानीं पितरे चत्वरं गतवति कुेक्कुटो रुराव। ");
INSERT INTO sandev_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","अथान्या दासी पितरं दृष्ट्वा समीपस्थान् जनान् जगाद अयं तेषामेको जनः। ");
INSERT INTO sandev_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","ततः स द्वितीयवारम् अपह्नुतवान् पश्चात् तत्रस्था लोकाः पितरं प्रोचुस्त्वमवश्यं तेषामेको जनः यतस्त्वं गालीलीयो नर इति तवोच्चारणं प्रकाशयति। ");
INSERT INTO sandev_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","तदा स शपथाभिशापौ कृत्वा प्रोवाच यूयं कथां कथयथ तं नरं न जानेऽहं। ");
INSERT INTO sandev_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","तदानीं द्वितीयवारं कुक्कुटो ऽरावीत्। कुक्कुटस्य द्वितीयरवात् पूर्व्वं त्वं मां वारत्रयम् अपह्नोष्यसि, इति यद्वाक्यं यीशुना समुदितं तत् तदा संस्मृत्य पितरो रोदितुम् आरभत। ");
INSERT INTO sandev_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","अथ प्रभाते सति प्रधानयाजकाः प्राञ्च उपाध्यायाः सर्व्वे मन्त्रिणश्च सभां कृत्वा यीशुृं बन्धयित्व पीलाताख्यस्य देशाधिपतेः सविधं नीत्वा समर्पयामासुः। ");
INSERT INTO sandev_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","तदा पीलातस्तं पृष्टवान् त्वं किं यिहूदीयलोकानां राजा? ततः स प्रत्युक्तवान् सत्यं वदसि। ");
INSERT INTO sandev_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","अपरं प्रधानयाजकास्तस्य बहुषु वाक्येषु दोषमारोपयाञ्चक्रुः किन्तु स किमपि न प्रत्युवाच। ");
INSERT INTO sandev_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","तदानीं पीलातस्तं पुनः पप्रच्छ त्वं किं नोत्तरयसि? पश्यैते त्वद्विरुद्धं कतिषु साध्येषु साक्षं ददति। ");
INSERT INTO sandev_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","कन्तु यीशुस्तदापि नोत्तरं ददौ ततः पीलात आश्चर्य्यं जगाम। ");
INSERT INTO sandev_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","अपरञ्च काराबद्धे कस्तिंश्चित् जने तन्महोत्सवकाले लोकै र्याचिते देशाधिपतिस्तं मोचयति। ");
INSERT INTO sandev_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ये च पूर्व्वमुपप्लवमकार्षुरुपप्लवे वधमपि कृतवन्तस्तेषां मध्ये तदानों बरब्बानामक एको बद्ध आसीत्। ");
INSERT INTO sandev_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","अतो हेतोः पूर्व्वापरीयां रीतिकथां कथयित्वा लोका उच्चैरुवन्तः पीलातस्य समक्षं निवेदयामासुः। ");
INSERT INTO sandev_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","तदा पीलातस्तानाचख्यौ तर्हि किं यिहूदीयानां राजानं मोचयिष्यामि? युष्माभिः किमिष्यते? ");
INSERT INTO sandev_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","यतः प्रधानयाजका ईर्ष्यात एव यीशुं समार्पयन्निति स विवेद। ");
INSERT INTO sandev_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","किन्तु यथा बरब्बां मोचयति तथा प्रार्थयितुं प्रधानयाजका लोकान् प्रवर्त्तयामासुः। ");
INSERT INTO sandev_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","अथ पीलातः पुनः पृष्टवान् तर्हि यं यिहूदीयानां राजेति वदथ तस्य किं करिष्यामि युष्माभिः किमिष्यते? ");
INSERT INTO sandev_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","तदा ते पुनरपि प्रोच्चैः प्रोचुस्तं क्रुशे वेधय। ");
INSERT INTO sandev_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","तस्मात् पीलातः कथितवान् कुतः? स किं कुकर्म्म कृतवान्? किन्तु ते पुनश्च रुवन्तो व्याजह्रुस्तं क्रुशे वेधय। ");
INSERT INTO sandev_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","तदा पीलातः सर्व्वाल्लोकान् तोषयितुमिच्छन् बरब्बां मोचयित्वा यीशुं कशाभिः प्रहृत्य क्रुशे वेद्धुं तं समर्पयाम्बभूव। ");
INSERT INTO sandev_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","अनन्तरं सैन्यगणोऽट्टालिकाम् अर्थाद् अधिपते र्गृहं यीशुं नीत्वा सेनानिवहं समाहुयत्। ");
INSERT INTO sandev_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","पश्चात् ते तं धूमलवर्णवस्त्रं परिधाप्य कण्टकमुकुटं रचयित्वा शिरसि समारोप्य ");
INSERT INTO sandev_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","हे यिहूदीयानां राजन् नमस्कार इत्युक्त्वा तं नमस्कर्त्तामारेभिरे। ");
INSERT INTO sandev_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","तस्योत्तमाङ्गे वेत्राघातं चक्रुस्तद्गात्रे निष्ठीवञ्च निचिक्षिपुः, तथा तस्य सम्मुखे जानुपातं प्रणोमुः ");
INSERT INTO sandev_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","इत्थमुपहस्य धूम्रवर्णवस्त्रम् उत्तार्य्य तस्य वस्त्रं तं पर्य्यधापयन् क्रुशे वेद्धुं बहिर्निन्युश्च। ");
INSERT INTO sandev_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","ततः परं सेकन्दरस्य रुफस्य च पिता शिमोन्नामा कुरीणीयलोक एकः कुतश्चिद् ग्रामादेत्य पथि याति तं ते यीशोः क्रुशं वोढुं बलाद् दध्नुः। ");
INSERT INTO sandev_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","अथ गुल्गल्ता अर्थात् शिरःकपालनामकं स्थानं यीशुमानीय ");
INSERT INTO sandev_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ते गन्धरसमिश्रितं द्राक्षारसं पातुं तस्मै ददुः किन्तु स न जग्राह। ");
INSERT INTO sandev_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","तस्मिन् क्रुशे विद्धे सति तेषामेकैकशः किं प्राप्स्यतीति निर्णयाय ");
INSERT INTO sandev_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","तस्य परिधेयानां विभागार्थं गुटिकापातं चक्रुः। ");
INSERT INTO sandev_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","अपरम् एष यिहूदीयानां राजेति लिखितं दोषपत्रं तस्य शिरऊर्द्व्वम् आरोपयाञ्चक्रुः। ");
INSERT INTO sandev_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","तस्य वामदक्षिणयो र्द्वौ चौरौ क्रुशयो र्विविधाते। ");
INSERT INTO sandev_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","तेनैव \"अपराधिजनैः सार्द्धं स गणितो भविष्यति,\" इति शास्त्रोक्तं वचनं सिद्धमभूत। ");
INSERT INTO sandev_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","अनन्तरं मार्गे ये ये लोका गमनागमने चक्रुस्ते सर्व्व एव शिरांस्यान्दोल्य निन्दन्तो जगदुः, रे मन्दिरनाशक रे दिनत्रयमध्ये तन्निर्म्मायक, ");
INSERT INTO sandev_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","अधुनात्मानम् अवित्वा क्रुशादवरोह। ");
INSERT INTO sandev_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","किञ्च प्रधानयाजका अध्यापकाश्च तद्वत् तिरस्कृत्य परस्परं चचक्षिरे एष परानावत् किन्तु स्वमवितुं न शक्नोति। ");
INSERT INTO sandev_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","यदीस्रायेलो राजाभिषिक्तस्त्राता भवति तर्ह्यधुनैन क्रुशादवरोहतु वयं तद् दृष्ट्वा विश्वसिष्यामः; किञ्च यौ लोकौ तेन सार्द्धं क्रुशे ऽविध्येतां तावपि तं निर्भर्त्सयामासतुः। ");
INSERT INTO sandev_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","अथ द्वितीययामात् तृतीययामं यावत् सर्व्वो देशः सान्धकारोभूत्। ");
INSERT INTO sandev_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ततस्तृतीयप्रहरे यीशुरुच्चैरवदत् एली एली लामा शिवक्तनी अर्थाद् \"हे मदीश मदीश त्वं पर्य्यत्याक्षीः कुतो हि मां?\" ");
INSERT INTO sandev_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","तदा समीपस्थलोकानां केचित् तद्वाक्यं निशम्याचख्युः पश्यैष एलियम् आहूयति। ");
INSERT INTO sandev_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","तत एको जनो धावित्वागत्य स्पञ्जे ऽम्लरसं पूरयित्वा तं नडाग्रे निधाय पातुं तस्मै दत्त्वावदत् तिष्ठ एलिय एनमवरोहयितुम् एति न वेति पश्यामि। ");
INSERT INTO sandev_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","अथ यीशुरुच्चैः समाहूय प्राणान् जहौ। ");
INSERT INTO sandev_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","तदा मन्दिरस्य जवनिकोर्द्व्वादधःर्य्यन्ता विदीर्णा द्विखण्डाभूत्। ");
INSERT INTO sandev_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","किञ्च इत्थमुच्चैराहूय प्राणान् त्यजन्तं तं दृष्द्वा तद्रक्षणाय नियुक्तो यः सेनापतिरासीत् सोवदत् नरोयम् ईश्वरपुत्र इति सत्यम्। ");
INSERT INTO sandev_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","तदानीं मग्दलीनी मरिसम् कनिष्ठयाकूबो योसेश्च मातान्यमरियम् शालोमी च याः स्त्रियो ");
INSERT INTO sandev_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","गालील्प्रदेशे यीशुं सेवित्वा तदनुगामिन्यो जाता इमास्तदन्याश्च या अनेका नार्यो यीशुना सार्द्धं यिरूशालममायातास्ताश्च दूरात् तानि ददृशुः। ");
INSERT INTO sandev_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","अथासादनदिनस्यार्थाद् विश्रामवारात् पूर्व्वदिनस्य सायंकाल आगत ");
INSERT INTO sandev_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ईश्वरराज्यापेक्ष्यरिमथीययूषफनामा मान्यमन्त्री समेत्य पीलातसविधं निर्भयो गत्वा यीशोर्देहं ययाचे। ");
INSERT INTO sandev_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","किन्तु स इदानीं मृतः पीलात इत्यसम्भवं मत्वा शतसेनापतिमाहूय स कदा मृत इति पप्रच्छ। ");
INSERT INTO sandev_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","शतसेमनापतिमुखात् तज्ज्ञात्वा यूषफे यीशोर्देहं ददौ। ");
INSERT INTO sandev_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","पश्चात् स सूक्ष्मं वासः क्रीत्वा यीशोः कायमवरोह्य तेन वाससा वेष्टायित्वा गिरौ खातश्मशाने स्थापितवान् पाषाणं लोठयित्वा द्वारि निदधे। ");
INSERT INTO sandev_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","किन्तु यत्र सोस्थाप्यत तत मग्दलीनी मरियम् योसिमातृमरियम् च ददृशतृः। ");
INSERT INTO sandev_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","अथ विश्रामवारे गते मग्दलीनी मरियम् याकूबमाता मरियम् शालोमी चेमास्तं मर्द्दयितुं सुगन्धिद्रव्याणि क्रीत्वा ");
INSERT INTO sandev_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","सप्ताहप्रथमदिनेऽतिप्रत्यूषे सूर्य्योदयकाले श्मशानमुपगताः। ");
INSERT INTO sandev_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","किन्तु श्मशानद्वारपाषाणोऽतिबृहन् तं कोऽपसारयिष्यतीति ताः परस्परं गदन्ति! ");
INSERT INTO sandev_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","एतर्हि निरीक्ष्य पाषाणो द्वारो ऽपसारित इति ददृशुः। ");
INSERT INTO sandev_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","पश्चात्ताः श्मशानं प्रविश्य शुक्लवर्णदीर्घपरिच्छदावृतमेकं युवानं श्मशानदक्षिणपार्श्व उपविष्टं दृष्ट्वा चमच्चक्रुः। ");
INSERT INTO sandev_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","सोऽवदत्, माभैष्ट यूयं क्रुशे हतं नासरतीययीशुं गवेषयथ सोत्र नास्ति श्मशानादुदस्थात्; तै र्यत्र स स्थापितः स्थानं तदिदं पश्यत। ");
INSERT INTO sandev_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","किन्तु तेन यथोक्तं तथा युष्माकमग्रे गालीलं यास्यते तत्र स युष्मान् साक्षात् करिष्यते यूयं गत्वा तस्य शिष्येभ्यः पितराय च वार्त्तामिमां कथयत। ");
INSERT INTO sandev_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ताः कम्पिता विस्तिताश्च तूर्णं श्मशानाद् बहिर्गत्वा पलायन्त भयात् कमपि किमपि नावदंश्च। ");
INSERT INTO sandev_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","अपरं यीशुः सप्ताहप्रथमदिने प्रत्यूषे श्मशानादुत्थाय यस्याः सप्तभूतास्त्याजितास्तस्यै मग्दलीनीमरियमे प्रथमं दर्शनं ददौ। ");
INSERT INTO sandev_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ततः सा गत्वा शोकरोदनकृद्भ्योऽनुगतलोकेभ्यस्तां वार्त्तां कथयामास। ");
INSERT INTO sandev_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","किन्तु यीशुः पुनर्जीवन् तस्यै दर्शनं दत्तवानिति श्रुत्वा ते न प्रत्ययन्। ");
INSERT INTO sandev_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","पश्चात् तेषां द्वायो र्ग्रामयानकाले यीशुरन्यवेशं धृत्वा ताभ्यां दर्शन ददौ! ");
INSERT INTO sandev_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","तावपि गत्वान्यशिष्येभ्यस्तां कथां कथयाञ्चक्रतुः किन्तु तयोः कथामपि ते न प्रत्ययन्। ");
INSERT INTO sandev_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","शेषत एकादशशिष्येषु भोजनोपविष्टेषु यीशुस्तेभ्यो दर्शनं ददौ तथोत्थानात् परं तद्दर्शनप्राप्तलोकानां कथायामविश्वासकरणात् तेषामविश्वासमनःकाठिन्याभ्यां हेतुभ्यां स तांस्तर्जितवान्। ");
INSERT INTO sandev_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","अथ तानाचख्यौ यूयं सर्व्वजगद् गत्वा सर्व्वजनान् प्रति सुसंवादं प्रचारयत। ");
INSERT INTO sandev_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","तत्र यः कश्चिद् विश्वस्य मज्जितो भवेत् स परित्रास्यते किन्तु यो न विश्वसिष्यति स दण्डयिष्यते। ");
INSERT INTO sandev_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","किञ्च ये प्रत्येष्यन्ति तैरीदृग् आश्चर्य्यं कर्म्म प्रकाशयिष्यते ते मन्नाम्ना भूतान् त्याजयिष्यन्ति भाषा अन्याश्च वदिष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","अपरं तैः सर्पेषु धृतेषु प्राणनाशकवस्तुनि पीते च तेषां कापि क्षति र्न भविष्यति; रोगिणां गात्रेषु करार्पिते तेऽरोगा भविष्यन्ति च। ");
INSERT INTO sandev_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","अथ प्रभुस्तानित्यादिश्य स्वर्गं नीतः सन् परमेश्वरस्य दक्षिण उपविवेश। ");
INSERT INTO sandev_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ततस्ते प्रस्थाय सर्व्वत्र सुसंवादीयकथां प्रचारयितुमारेभिरे प्रभुस्तु तेषां सहायः सन् प्रकाशिताश्चर्य्यक्रियाभिस्तां कथां प्रमाणवतीं चकार। इति।");
INSERT INTO sandev_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","प्रथमतो ये साक्षिणो वाक्यप्रचारकाश्चासन् तेऽस्माकं मध्ये यद्यत् सप्रमाणं वाक्यमर्पयन्ति स्म ");
INSERT INTO sandev_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","तदनुसारतोऽन्येपि बहवस्तद्वृत्तान्तं रचयितुं प्रवृत्ताः। ");
INSERT INTO sandev_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","अतएव हे महामहिमथियफिल् त्वं या याः कथा अशिक्ष्यथास्तासां दृढप्रमाणानि यथा प्राप्नोषि ");
INSERT INTO sandev_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","तदर्थं प्रथममारभ्य तानि सर्व्वाणि ज्ञात्वाहमपि अनुक्रमात् सर्व्ववृत्तान्तान् तुभ्यं लेखितुं मतिमकार्षम्। ");
INSERT INTO sandev_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","यिहूदादेशीयहेरोद्नामके राजत्वं कुर्व्वति अबीययाजकस्य पर्य्यायाधिकारी सिखरियनामक एको याजको हारोणवंशोद्भवा इलीशेवाख्या ");
INSERT INTO sandev_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","तस्य जाया द्वाविमौ निर्दोषौ प्रभोः सर्व्वाज्ञा व्यवस्थाश्च संमन्य ईश्वरदृष्टौ धार्म्मिकावास्ताम्। ");
INSERT INTO sandev_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","तयोः सन्तान एकोपि नासीत्, यत इलीशेवा बन्ध्या तौ द्वावेव वृद्धावभवताम्। ");
INSERT INTO sandev_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","यदा स्वपर्य्यानुक्रमेण सिखरिय ईश्वास्य समक्षं याजकीयं कर्म्म करोति ");
INSERT INTO sandev_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","तदा यज्ञस्य दिनपरिपाय्या परमेश्वरस्य मन्दिरे प्रवेशकाले धूपज्वालनं कर्म्म तस्य करणीयमासीत्। ");
INSERT INTO sandev_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","तद्धूपज्वालनकाले लोकनिवहे प्रार्थनां कर्तुं बहिस्तिष्ठति ");
INSERT INTO sandev_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","सति सिखरियो यस्यां वेद्यां धूपं ज्वालयति तद्दक्षिणपार्श्वे परमेश्वरस्य दूत एक उपस्थितो दर्शनं ददौ। ");
INSERT INTO sandev_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","तं दृष्ट्वा सिखरिय उद्विविजे शशङ्के च। ");
INSERT INTO sandev_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","तदा स दूतस्तं बभाषे हे सिखरिय मा भैस्तव प्रार्थना ग्राह्या जाता तव भार्य्या इलीशेवा पुत्रं प्रसोष्यते तस्य नाम योेहन् इति करिष्यसि। ");
INSERT INTO sandev_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","किञ्च त्वं सानन्दः सहर्षश्च भविष्यसि तस्य जन्मनि बहव आनन्दिष्यन्ति च। ");
INSERT INTO sandev_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","यतो हेतोः स परमेश्वरस्य गोचरे महान् भविष्यति तथा द्राक्षारसं सुरां वा किमपि न पास्यति, अपरं जन्मारभ्य पवित्रेणात्मना परिपूर्णः ");
INSERT INTO sandev_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","सन् इस्रायेल्वंशीयान् अनेकान् प्रभोः परमेश्वरस्य मार्गमानेष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","सन्तानान् प्रति पितृणां मनांसि धर्म्मज्ञानं प्रत्यनाज्ञाग्राहिणश्च परावर्त्तयितुं, प्रभोः परमेश्वरस्य सेवार्थम् एकां सज्जितजातिं विधातुञ्च स एलियरूपात्मशक्तिप्राप्तस्तस्याग्रे गमिष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","तदा सिखरियो दूतमवादीत् कथमेतद् वेत्स्यामि? यतोहं वृद्धो मम भार्य्या च वृद्धा। ");
INSERT INTO sandev_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ततो दूतः प्रत्युवाच पश्येश्वरस्य साक्षाद्वर्त्ती जिब्रायेल्नामा दूतोहं त्वया सह कथां गदितुं तुभ्यमिमां शुभवार्त्तां दातुञ्च प्रेषितः। ");
INSERT INTO sandev_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","किन्तु मदीयं वाक्यं काले फलिष्यति तत् त्वया न प्रतीतम् अतः कारणाद् यावदेव तानि न सेत्स्यन्ति तावत् त्वं वक्तुंमशक्तो मूको भव। ");
INSERT INTO sandev_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","तदानीं ये ये लोकाः सिखरियमपैक्षन्त ते मध्येमन्दिरं तस्य बहुविलम्बाद् आश्चर्य्यं मेनिरे। ");
INSERT INTO sandev_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","स बहिरागतो यदा किमपि वाक्यं वक्तुमशक्तः सङ्केतं कृत्वा निःशब्दस्तस्यौ तदा मध्येमन्दिरं कस्यचिद् दर्शनं तेन प्राप्तम् इति सर्व्वे बुबुधिरे। ");
INSERT INTO sandev_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","अनन्तरं तस्य सेवनपर्य्याये सम्पूर्णे सति स निजगेहं जगाम। ");
INSERT INTO sandev_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","कतिपयदिनेषु गतेषु तस्य भार्य्या इलीशेवा गर्ब्भवती बभूव ");
INSERT INTO sandev_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","पश्चात् सा पञ्चमासान् संगोप्याकथयत् लोकानां समक्षं ममापमानं खण्डयितुं परमेश्वरो मयि दृष्टिं पातयित्वा कर्म्मेदृशं कृतवान्। ");
INSERT INTO sandev_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","अपरञ्च तस्या गर्ब्भस्य षष्ठे मासे जाते गालील्प्रदेशीयनासरत्पुरे ");
INSERT INTO sandev_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","दायूदो वंशीयाय यूषफ्नाम्ने पुरुषाय या मरियम्नामकुमारी वाग्दत्तासीत् तस्याः समीपं जिब्रायेल् दूत ईश्वरेण प्रहितः। ");
INSERT INTO sandev_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","स गत्वा जगाद हे ईश्वरानुगृहीतकन्ये तव शुभं भूयात् प्रभुः परमेश्वरस्तव सहायोस्ति नारीणां मध्ये त्वमेव धन्या। ");
INSERT INTO sandev_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","तदानीं सा तं दृष्ट्वा तस्य वाक्यत उद्विज्य कीदृशं भाषणमिदम् इति मनसा चिन्तयामास। ");
INSERT INTO sandev_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ततो दूतोऽवदत् हे मरियम् भयं माकार्षीः, त्वयि परमेश्वरस्यानुग्रहोस्ति। ");
INSERT INTO sandev_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","पश्य त्वं गर्ब्भं धृत्वा पुत्रं प्रसोष्यसे तस्य नाम यीशुरिति करिष्यसि। ");
INSERT INTO sandev_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","स महान् भविष्यति तथा सर्व्वेभ्यः श्रेष्ठस्य पुत्र इति ख्यास्यति; अपरं प्रभुः परमेश्वरस्तस्य पितुर्दायूदः सिंहासनं तस्मै दास्यति; ");
INSERT INTO sandev_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","तथा स याकूबो वंशोपरि सर्व्वदा राजत्वं करिष्यति, तस्य राजत्वस्यान्तो न भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","तदा मरियम् तं दूतं बभाषे नाहं पुरुषसङ्गं करोमि तर्हि कथमेतत् सम्भविष्यति? ");
INSERT INTO sandev_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ततो दूतोऽकथयत् पवित्र आत्मा त्वामाश्रायिष्यति तथा सर्व्वश्रेष्ठस्य शक्तिस्तवोपरि छायां करिष्यति ततो हेतोस्तव गर्ब्भाद् यः पवित्रबालको जनिष्यते स ईश्वरपुत्र इति ख्यातिं प्राप्स्यति। ");
INSERT INTO sandev_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","अपरञ्च पश्य तव ज्ञातिरिलीशेवा यां सर्व्वे बन्ध्यामवदन् इदानीं सा वार्द्धक्ये सन्तानमेकं गर्ब्भेऽधारयत् तस्य षष्ठमासोभूत्। ");
INSERT INTO sandev_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","किमपि कर्म्म नासाध्यम् ईश्वरस्य। ");
INSERT INTO sandev_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","तदा मरियम् जगाद, पश्य प्रभेरहं दासी मह्यं तव वाक्यानुसारेण सर्व्वमेतद् घटताम्; अननतरं दूतस्तस्याः समीपात् प्रतस्थे। ");
INSERT INTO sandev_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","अथ कतिपयदिनात् परं मरियम् तस्मात् पर्व्वतमयप्रदेशीययिहूदाया नगरमेकं शीघ्रं गत्वा ");
INSERT INTO sandev_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","सिखरिययाजकस्य गृहं प्रविश्य तस्य जायाम् इलीशेवां सम्बोध्यावदत्। ");
INSERT INTO sandev_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ततो मरियमः सम्बोधनवाक्ये इलीशेवायाः कर्णयोः प्रविष्टमात्रे सति तस्या गर्ब्भस्थबालको ननर्त्त। तत इलीशेवा पवित्रेणात्मना परिपूर्णा सती ");
INSERT INTO sandev_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","प्रोच्चैर्गदितुमारेभे, योषितां मध्ये त्वमेव धन्या, तव गर्ब्भस्थः शिशुश्च धन्यः। ");
INSERT INTO sandev_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","त्वं प्रभोर्माता, मम निवेशने त्वया चरणावर्पितौ, ममाद्य सौभाग्यमेतत्। ");
INSERT INTO sandev_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","पश्य तव वाक्ये मम कर्णयोः प्रविष्टमात्रे सति ममोदरस्थः शिशुरानन्दान् ननर्त्त। ");
INSERT INTO sandev_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","या स्त्री व्यश्वसीत् सा धन्या, यतो हेतोस्तां प्रति परमेश्वरोक्तं वाक्यं सर्व्वं सिद्धं भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","तदानीं मरियम् जगाद। धन्यवादं परेशस्य करोति मामकं मनः। ");
INSERT INTO sandev_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ममात्मा तारकेशे च समुल्लासं प्रगच्छति। ");
INSERT INTO sandev_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","अकरोत् स प्रभु र्दुष्टिं स्वदास्या दुर्गतिं प्रति। पश्याद्यारभ्य मां धन्यां वक्ष्यन्ति पुरुषाः सदा। ");
INSERT INTO sandev_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","यः सर्व्वशक्तिमान् यस्य नामापि च पवित्रकं। स एव सुमहत्कर्म्म कृतवान् मन्निमित्तकं। ");
INSERT INTO sandev_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ये बिभ्यति जनास्तस्मात् तेषां सन्तानपंक्तिषु। अनुकम्पा तदीया च सर्व्वदैव सुतिष्ठति। ");
INSERT INTO sandev_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","स्वबाहुबलतस्तेन प्राकाश्यत पराक्रमः। मनःकुमन्त्रणासार्द्धं विकीर्य्यन्तेऽभिमानिनः। ");
INSERT INTO sandev_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","सिंहासनगताल्लोकान् बलिनश्चावरोह्य सः। पदेषूच्चेषु लोकांस्तु क्षुद्रान् संस्थापयत्यपि। ");
INSERT INTO sandev_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","क्षुधितान् मानवान् द्रव्यैरुत्तमैः परितर्प्य सः। सकलान् धनिनो लोकान् विसृजेद् रिक्तहस्तकान्। ");
INSERT INTO sandev_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","इब्राहीमि च तद्वंशे या दयास्ति सदैव तां। स्मृत्वा पुरा पितृणां नो यथा साक्षात् प्रतिश्रुतं। ");
INSERT INTO sandev_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","इस्रायेल्सेवकस्तेन तथोपक्रियते स्वयं॥ ");
INSERT INTO sandev_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","अनन्तरं मरियम् प्रायेण मासत्रयम् इलीशेवया सहोषित्वा व्याघुय्य निजनिवेशनं ययौ। ");
INSERT INTO sandev_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","तदनन्तरम् इलीशेवायाः प्रसवकाल उपस्थिते सति सा पुत्रं प्रासोष्ट। ");
INSERT INTO sandev_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ततः परमेश्वरस्तस्यां महानुग्रहं कृतवान् एतत् श्रुत्वा समीपवासिनः कुटुम्बाश्चागत्य तया सह मुमुदिरे। ");
INSERT INTO sandev_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","तथाष्टमे दिने ते बालकस्य त्वचं छेत्तुम् एत्य तस्य पितृनामानुरूपं तन्नाम सिखरिय इति कर्त्तुमीषुः। ");
INSERT INTO sandev_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","किन्तु तस्य माताकथयत् तन्न, नामास्य योहन् इति कर्त्तव्यम्। ");
INSERT INTO sandev_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","तदा ते व्याहरन् तव वंशमध्ये नामेदृशं कस्यापि नास्ति। ");
INSERT INTO sandev_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ततः परं तस्य पितरं सिखरियं प्रति सङ्केत्य पप्रच्छुः शिशोः किं नाम कारिष्यते? ");
INSERT INTO sandev_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ततः स फलकमेकं याचित्वा लिलेख तस्य नाम योहन् भविष्यति। तस्मात् सर्व्वे आश्चर्य्यं मेनिरे। ");
INSERT INTO sandev_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","तत्क्षणं सिखरियस्य जिह्वाजाड्येऽपगते स मुखं व्यादाय स्पष्टवर्णमुच्चार्य्य ईश्वरस्य गुणानुवादं चकार। ");
INSERT INTO sandev_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","तस्माच्चतुर्दिक्स्थाः समीपवासिलोका भीता एवमेताः सर्व्वाः कथा यिहूदायाः पर्व्वतमयप्रदेशस्य सर्व्वत्र प्रचारिताः। ");
INSERT INTO sandev_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","तस्मात् श्रोतारो मनःसु स्थापयित्वा कथयाम्बभूवुः कीदृशोयं बालो भविष्यति? अथ परमेश्वरस्तस्य सहायोभूत्। ");
INSERT INTO sandev_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","तदा योहनः पिता सिखरियः पवित्रेणात्मना परिपूर्णः सन् एतादृशं भविष्यद्वाक्यं कथयामास। ");
INSERT INTO sandev_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","इस्रायेलः प्रभु र्यस्तु स धन्यः परमेश्वरः। अनुगृह्य निजाल्लोकान् स एव परिमोचयेत्। ");
INSERT INTO sandev_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","विपक्षजनहस्तेभ्यो यथा मोच्यामहे वयं। यावज्जीवञ्च धर्म्मेण सारल्येन च निर्भयाः। ");
INSERT INTO sandev_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","सेवामहै तमेवैकम् एतत्कारणमेव च। स्वकीयं सुपवित्रञ्च संस्मृत्य नियमं सदा। ");
INSERT INTO sandev_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","कृपया पुरुषान् पूर्व्वान् निकषार्थात्तु नः पितुः। इब्राहीमः समीपे यं शपथं कृतवान् पुरा। ");
INSERT INTO sandev_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","तमेव सफलं कर्त्तं तथा शत्रुगणस्य च। ऋृतीयाकारिणश्चैव करेभ्यो रक्षणाय नः। ");
INSERT INTO sandev_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","सृष्टेः प्रथमतः स्वीयैः पवित्रै र्भाविवादिभिः। ");
INSERT INTO sandev_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","यथोक्तवान् तथा स्वस्य दायूदः सेवकस्य तु। ");
INSERT INTO sandev_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","वंशे त्रातारमेकं स समुत्पादितवान् स्वयम्। ");
INSERT INTO sandev_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","अतो हे बालक त्वन्तु सर्व्वेभ्यः श्रेष्ठ एव यः। तस्यैव भाविवादीति प्रविख्यातो भविष्यसि। अस्माकं चरणान् क्षेमे मार्गे चालयितुं सदा। एवं ध्वान्तेऽर्थतो मृत्योश्छायायां ये तु मानवाः। ");
INSERT INTO sandev_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","उपविष्टास्तु तानेव प्रकाशयितुमेव हि। कृत्वा महानुकम्पां हि यामेव परमेश्वरः। ");
INSERT INTO sandev_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ऊर्द्व्वात् सूर्य्यमुदाय्यैवास्मभ्यं प्रादात्तु दर्शनं। तयानुकम्पया स्वस्य लोकानां पापमोचने। ");
INSERT INTO sandev_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","परित्राणस्य तेभ्यो हि ज्ञानविश्राणनाय च। प्रभो र्मार्गं परिष्कर्त्तुं तस्याग्रायी भविष्यसि॥ ");
INSERT INTO sandev_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","अथ बालकः शरीरेण बुद्ध्या च वर्द्धितुमारेभे; अपरञ्च स इस्रायेलो वंशीयलोकानां समीपे यावन्न प्रकटीभूतस्तास्तावत् प्रान्तरे न्यवसत्। ");
INSERT INTO sandev_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","अपरञ्च तस्मिन् काले राज्यस्य सर्व्वेषां लोकानां नामानि लेखयितुम् अगस्तकैसर आज्ञापयामास। ");
INSERT INTO sandev_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","तदनुसारेण कुरीणियनामनि सुरियादेशस्य शासके सति नामलेखनं प्रारेभे। ");
INSERT INTO sandev_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","अतो हेतो र्नाम लेखितुं सर्व्वे जनाः स्वीयं स्वीयं नगरं जग्मुः। ");
INSERT INTO sandev_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","तदानीं यूषफ् नाम लेखितुं वाग्दत्तया स्वभार्य्यया गर्ब्भवत्या मरियमा सह स्वयं दायूदः सजातिवंश इति कारणाद् गालील्प्रदेशस्य नासरत्नगराद् ");
INSERT INTO sandev_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","यिहूदाप्रदेशस्य बैत्लेहमाख्यं दायूद्नगरं जगाम। ");
INSERT INTO sandev_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","अन्यच्च तत्र स्थाने तयोस्तिष्ठतोः सतो र्मरियमः प्रसूतिकाल उपस्थिते ");
INSERT INTO sandev_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","सा तं प्रथमसुतं प्रासोष्ट किन्तु तस्मिन् वासगृहे स्थानाभावाद् बालकं वस्त्रेण वेष्टयित्वा गोशालायां स्थापयामास। ");
INSERT INTO sandev_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","अनन्तरं ये कियन्तो मेषपालकाः स्वमेषव्रजरक्षायै तत्प्रदेशे स्थित्वा रजन्यां प्रान्तरे प्रहरिणः कर्म्म कुर्व्वन्ति, ");
INSERT INTO sandev_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","तेषां समीपं परमेश्वरस्य दूत आगत्योपतस्थौ; तदा चतुष्पार्श्वे परमेश्वरस्य तेजसः प्रकाशितत्वात् तेऽतिशशङ्किरे। ");
INSERT INTO sandev_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","तदा स दूत उवाच मा भैष्ट पश्यताद्य दायूदः पुरे युष्मन्निमित्तं त्राता प्रभुः ख्रीष्टोऽजनिष्ट, ");
INSERT INTO sandev_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","सर्व्वेषां लोकानां महानन्दजनकम् इमं मङ्गलवृत्तान्तं युष्मान् ज्ञापयामि। ");
INSERT INTO sandev_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","यूयं (तत्स्थानं गत्वा) वस्त्रवेष्टितं तं बालकं गोशालायां शयनं द्रक्ष्यथ युष्मान् प्रतीदं चिह्नं भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","दूत इमां कथां कथितवति तत्राकस्मात् स्वर्गीयाः पृतना आगत्य कथाम् इमां कथयित्वेश्वरस्य गुणानन्ववादिषुः, यथा, ");
INSERT INTO sandev_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","सर्व्वोर्द्व्वस्थैरीश्वरस्य महिमा सम्प्रकाश्यतां। शान्तिर्भूयात् पृथिव्यास्तु सन्तोषश्च नरान् प्रति॥ ");
INSERT INTO sandev_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ततः परं तेषां सन्निधे र्दूतगणे स्वर्गं गते मेषपालकाः परस्परम् अवेचन् आगच्छत प्रभुः परमेश्वरो यां घटनां ज्ञापितवान् तस्या याथर्यं ज्ञातुं वयमधुना बैत्लेहम्पुरं यामः। ");
INSERT INTO sandev_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","पश्चात् ते तूर्णं व्रजित्वा मरियमं यूषफं गोशालायां शयनं बालकञ्च ददृशुः। ");
INSERT INTO sandev_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","इत्थं दृष्ट्वा बालकस्यार्थे प्रोक्तां सर्व्वकथां ते प्राचारयाञ्चक्रुः। ");
INSERT INTO sandev_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ततो ये लोका मेषरक्षकाणां वदनेभ्यस्तां वार्त्तां शुश्रुवुस्ते महाश्चर्य्यं मेनिरे। ");
INSERT INTO sandev_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","किन्तु मरियम् एतत्सर्व्वघटनानां तात्पर्य्यं विविच्य मनसि स्थापयामास। ");
INSERT INTO sandev_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","तत्पश्चाद् दूतविज्ञप्तानुरूपं श्रुत्वा दृष्ट्वा च मेषपालका ईश्वरस्य गुणानुवादं धन्यवादञ्च कुर्व्वाणाः परावृत्य ययुः। ");
INSERT INTO sandev_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","अथ बालकस्य त्वक्छेदनकालेऽष्टमदिवसे समुपस्थिते तस्य गर्ब्भस्थितेः पुर्व्वं स्वर्गीयदूतो यथाज्ञापयत् तदनुरूपं ते तन्नामधेयं यीशुरिति चक्रिरे। ");
INSERT INTO sandev_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","ततः परं मूसालिखितव्यवस्थाया अनुसारेण मरियमः शुचित्वकाल उपस्थिते, ");
INSERT INTO sandev_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","\"प्रथमजः सर्व्वः पुरुषसन्तानः परमेश्वरे समर्प्यतां,\" इति परमेश्वरस्य व्यवस्थया ");
INSERT INTO sandev_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","यीशुं परमेश्वरे समर्पयितुम् शास्त्रीयविध्युक्तं कपोतद्वयं पारावतशावकद्वयं वा बलिं दातुं ते तं गृहीत्वा यिरूशालमम् आययुः। ");
INSERT INTO sandev_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","यिरूशालम्पुरनिवासी शिमियोन्नामा धार्म्मिक एक आसीत् स इस्रायेलः सान्त्वनामपेक्ष्य तस्थौ किञ्च पवित्र आत्मा तस्मिन्नाविर्भूतः। ");
INSERT INTO sandev_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","अपरं प्रभुणा परमेश्वरेणाभिषिक्ते त्रातरि त्वया न दृष्टे त्वं न मरिष्यसीति वाक्यं पवित्रेण आत्मना तस्म प्राकथ्यत। ");
INSERT INTO sandev_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","अपरञ्च यदा यीशोः पिता माता च तदर्थं व्यवस्थानुरूपं कर्म्म कर्त्तुं तं मन्दिरम् आनिन्यतुस्तदा ");
INSERT INTO sandev_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","शिमियोन् आत्मन आकर्षणेन मन्दिरमागत्य तं क्रोडे निधाय ईश्वरस्य धन्यवादं कृत्वा कथयामास, यथा, ");
INSERT INTO sandev_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","हे प्रभो तव दासोयं निजवाक्यानुसारतः। इदानीन्तु सकल्याणो भवता संविसृज्यताम्। ");
INSERT INTO sandev_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","यतः सकलदेशस्य दीप्तये दीप्तिरूपकं। ");
INSERT INTO sandev_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","इस्रायेलीयलोकस्य महागौरवरूपकं। ");
INSERT INTO sandev_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","यं त्रायकं जनानान्तु सम्मुखे त्वमजीजनः। सएव विद्यतेऽस्माकं ध्रवं नयननगोचरे॥ ");
INSERT INTO sandev_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","तदानीं तेनोक्ता एताः सकलाः कथाः श्रुत्वा तस्य माता यूषफ् च विस्मयं मेनाते। ");
INSERT INTO sandev_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ततः परं शिमियोन् तेभ्य आशिषं दत्त्वा तन्मातरं मरियमम् उवाच, पश्य इस्रायेलो वंशमध्ये बहूनां पातनायोत्थापनाय च तथा विरोधपात्रं भवितुं, बहूनां गुप्तमनोगतानां प्रकटीकरणाय बालकोयं नियुक्तोस्ति। ");
INSERT INTO sandev_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","तस्मात् तवापि प्राणाः शूलेन व्यत्स्यन्ते। ");
INSERT INTO sandev_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","अपरञ्च आशेरस्य वंशीयफिनूयेलो दुहिता हन्नाख्या अतिजरती भविष्यद्वादिन्येका या विवाहात् परं सप्त वत्सरान् पत्या सह न्यवसत् ततो विधवा भूत्वा चतुरशीतिवर्षवयःपर्य्यनतं ");
INSERT INTO sandev_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","मन्दिरे स्थित्वा प्रार्थनोपवासैर्दिवानिशम् ईश्वरम् असेवत सापि स्त्री तस्मिन् समये मन्दिरमागत्य ");
INSERT INTO sandev_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","परमेश्वरस्य धन्यवादं चकार, यिरूशालम्पुरवासिनो यावन्तो लोका मुक्तिमपेक्ष्य स्थितास्तान् यीशोर्वृत्तान्तं ज्ञापयामास। ");
INSERT INTO sandev_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","इत्थं परमेश्वरस्य व्यवस्थानुसारेण सर्व्वेषु कर्म्मसु कृतेषु तौ पुनश्च गालीलो नासरत्नामकं निजनगरं प्रतस्थाते। ");
INSERT INTO sandev_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","तत्पश्चाद् बालकः शरीरेण वृद्धिमेत्य ज्ञानेन परिपूर्ण आत्मना शक्तिमांश्च भवितुमारेभे तथा तस्मिन् ईश्वरानुग्रहो बभूव। ");
INSERT INTO sandev_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","तस्य पिता माता च प्रतिवर्षं निस्तारोत्सवसमये यिरूशालमम् अगच्छताम्। ");
INSERT INTO sandev_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","अपरञ्च यीशौ द्वादशवर्षवयस्के सति तौ पर्व्वसमयस्य रीत्यनुसारेण यिरूशालमं गत्वा ");
INSERT INTO sandev_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","पार्व्वणं सम्पाद्य पुनरपि व्याघुय्य यातः किन्तु यीशुर्बालको यिरूशालमि तिष्ठति। यूषफ् तन्माता च तद् अविदित्वा ");
INSERT INTO sandev_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","स सङ्गिभिः सह विद्यत एतच्च बुद्व्वा दिनैकगम्यमार्गं जग्मतुः। किन्तु शेषे ज्ञातिबन्धूनां समीपे मृगयित्वा तदुद्देेशमप्राप्य ");
INSERT INTO sandev_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","तौ पुनरपि यिरूशालमम् परावृत्यागत्य तं मृगयाञ्चक्रतुः। ");
INSERT INTO sandev_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","अथ दिनत्रयात् परं पण्डितानां मध्ये तेषां कथाः शृण्वन् तत्त्वं पृच्छंश्च मन्दिरे समुपविष्टः स ताभ्यां दृष्टः। ");
INSERT INTO sandev_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","तदा तस्य बुद्ध्या प्रत्युत्तरैश्च सर्व्वे श्रोतारो विस्मयमापद्यन्ते। ");
INSERT INTO sandev_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","तादृशं दृष्ट्वा तस्य जनको जननी च चमच्चक्रतुः किञ्च तस्य माता तमवदत्, हे पुत्र, कथमावां प्रतीत्थं समाचरस्त्वम्? पश्य तव पिताहञ्च शोकाकुलौ सन्तौ त्वामन्विच्छावः स्म। ");
INSERT INTO sandev_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","ततः सोवदत् कुतो माम् अन्वैच्छतं? पितुर्गृहे मया स्थातव्यम् एतत् किं युवाभ्यां न ज्ञायते? ");
INSERT INTO sandev_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","किन्तु तौ तस्यैतद्वाक्यस्य तात्पर्य्यं बोद्धुं नाशक्नुतां। ");
INSERT INTO sandev_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ततः परं स ताभ्यां सह नासरतं गत्वा तयोर्वशीभूतस्तस्थौ किन्तु सर्व्वा एताः कथास्तस्य माता मनसि स्थापयामास। ");
INSERT INTO sandev_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","अथ यीशो र्बुद्धिः शरीरञ्च तथा तस्मिन् ईश्वरस्य मानवानाञ्चानुग्रहो वर्द्धितुम् आरेभे। ");
INSERT INTO sandev_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","अनन्तरं तिबिरियकैसरस्य राजत्वस्य पञ्चदशे वत्सरे सति यदा पन्तीयपीलातो यिहूदादेशाधिपति र्हेरोद् तु गालील्प्रदेशस्य राजा फिलिपनामा तस्य भ्राता तु यितूरियायास्त्राखोनीतियाप्रदेशस्य च राजासीत् लुषानीयनामा अविलीनीदेशस्य राजासीत् ");
INSERT INTO sandev_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","हानन् कियफाश्चेमौ प्रधानयाजाकावास्तां तदानीं सिखरियस्य पुत्राय योहने मध्येप्रान्तरम् ईश्वरस्य वाक्ये प्रकाशिते सति ");
INSERT INTO sandev_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","स यर्द्दन उभयतटप्रदेशान् समेत्य पापमोचनार्थं मनःपरावर्त्तनस्य चिह्नरूपं यन्मज्जनं तदीयाः कथाः सर्व्वत्र प्रचारयितुमारेभे। ");
INSERT INTO sandev_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","यिशयियभविष्यद्वक्तृग्रन्थे यादृशी लिपिरास्ते यथा, परमेशस्य पन्थानं परिष्कुरुत सर्व्वतः। तस्य राजपथञ्चैव समानं कुरुताधुना। ");
INSERT INTO sandev_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","कारिष्यन्ते समुच्छ्रायाः सकला निम्नभूमयः। कारिष्यन्ते नताः सर्व्वे पर्व्वताश्चोपपर्व्वताः। कारिष्यन्ते च या वक्रास्ताः सर्व्वाः सरला भुवः। कारिष्यन्ते समानास्ता या उच्चनीचभूमयः। ");
INSERT INTO sandev_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ईश्वरेण कृतं त्राणं द्रक्ष्यन्ति सर्व्वमानवाः। इत्येतत् प्रान्तरे वाक्यं वदतः कस्यचिद् रवः॥ ");
INSERT INTO sandev_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ये ये लोका मज्जनार्थं बहिराययुस्तान् सोवदत् रे रे सर्पवंशा आगामिनः कोपात् पलायितुं युष्मान् कश्चेतयामास? ");
INSERT INTO sandev_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","तस्माद् इब्राहीम् अस्माकं पिता कथामीदृशीं मनोभि र्न कथयित्वा यूयं मनःपरिवर्त्तनयोग्यं फलं फलत; युष्मानहं यथार्थं वदामि पाषाणेभ्य एतेभ्य ईश्वर इब्राहीमः सन्तानोत्पादने समर्थः। ");
INSERT INTO sandev_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","अपरञ्च तरुमूलेऽधुनापि परशुः संलग्नोस्ति यस्तरुरुत्तमं फलं न फलति स छिद्यतेऽग्नौ निक्षिप्यते च। ");
INSERT INTO sandev_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","तदानीं लोकास्तं पप्रच्छुस्तर्हि किं कर्त्तव्यमस्माभिः? ");
INSERT INTO sandev_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ततः सोवादीत् यस्य द्वे वसने विद्येते स वस्त्रहीनायैकं वितरतु किंञ्च यस्य खाद्यद्रव्यं विद्यते सोपि तथैव करोतु। ");
INSERT INTO sandev_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ततः परं करसञ्चायिनो मज्जनार्थम् आगत्य पप्रच्छुः हे गुरो किं कर्त्तव्यमस्माभिः? ");
INSERT INTO sandev_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ततः सोकथयत् निरूपितादधिकं न गृह्लित। ");
INSERT INTO sandev_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","अनन्तरं सेनागण एत्य पप्रच्छ किमस्माभि र्वा कर्त्तव्यम्? ततः सोभिदधे कस्य कामपि हानिं मा कार्ष्ट तथा मृषापवादं मा कुरुत निजवेतनेन च सन्तुष्य तिष्ठत। ");
INSERT INTO sandev_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","अपरञ्च लोका अपेक्षया स्थित्वा सर्व्वेपीति मनोभि र्वितर्कयाञ्चक्रुः, योहनयम् अभिषिक्तस्त्राता न वेति? ");
INSERT INTO sandev_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","तदा योहन् सर्व्वान् व्याजहार, जलेऽहं युष्मान् मज्जयामि सत्यं किन्तु यस्य पादुकाबन्धनं मोचयितुमपि न योग्योस्मि तादृश एको मत्तो गुरुतरः पुमान् एति, स युष्मान् वह्निरूपे पवित्र आत्मनि मज्जयिष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","अपरञ्च तस्य हस्ते शूर्प आस्ते स स्वशस्यानि शुद्धरूपं प्रस्फोट्य गोधूमान् सर्व्वान् भाण्डागारे संग्रहीष्यति किन्तु बूषाणि सर्व्वाण्यनिर्व्वाणवह्निना दाहयिष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","योहन् उपदेशेनेत्थं नानाकथा लोकानां समक्षं प्रचारयामास। ");
INSERT INTO sandev_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","अपरञ्च हेरोद् राजा फिलिप्नाम्नः सहोदरस्य भार्य्यां हेरोदियामधि तथान्यानि यानि यानि कुकर्म्माणि कृतवान् तदधि च ");
INSERT INTO sandev_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","योहना तिरस्कृतो भूत्वा कारागारे तस्य बन्धनाद् अपरमपि कुकर्म्म चकार। ");
INSERT INTO sandev_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","इतः पूर्व्वं यस्मिन् समये सर्व्वे योहना मज्जितास्तदानीं यीशुरप्यागत्य मज्जितः। ");
INSERT INTO sandev_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","तदनन्तरं तेन प्रार्थिते मेघद्वारं मुक्तं तस्माच्च पवित्र आत्मा मूर्त्तिमान् भूत्वा कपोतवत् तदुपर्य्यवरुरोह; तदा त्वं मम प्रियः पुत्रस्त्वयि मम परमः सन्तोष इत्याकाशवाणी बभूव। ");
INSERT INTO sandev_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","तदानीं यीशुः प्रायेण त्रिंशद्वर्षवयस्क आसीत्। लौकिकज्ञाने तु स यूषफः पुत्रः, ");
INSERT INTO sandev_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","यूषफ् एलेः पुत्रः, एलिर्मत्ततः पुत्रः, मत्तत् लेवेः पुत्रः, लेवि र्मल्केः पुत्रः, मल्किर्यान्नस्य पुत्रः; यान्नो यूषफः पुत्रः। ");
INSERT INTO sandev_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","यूषफ् मत्तथियस्य पुत्रः, मत्तथिय आमोसः पुत्रः, आमोस् नहूमः पुत्रः, नहूम् इष्लेः पुत्रः इष्लिर्नगेः पुत्रः। ");
INSERT INTO sandev_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","नगिर्माटः पुत्रः, माट् मत्तथियस्य पुत्रः, मत्तथियः शिमियेः पुत्रः, शिमियिर्यूषफः पुत्रः, यूषफ् यिहूदाः पुत्रः। ");
INSERT INTO sandev_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","यिहूदा योहानाः पुत्रः, योहाना रीषाः पुत्रः, रीषाः सिरुब्बाबिलः पुत्रः, सिरुब्बाबिल् शल्तीयेलः पुत्रः, शल्तीयेल् नेरेः पुत्रः। ");
INSERT INTO sandev_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","नेरिर्मल्केः पुत्रः, मल्किः अद्यः पुत्रः, अद्दी कोषमः पुत्रः, कोषम् इल्मोददः पुत्रः, इल्मोदद् एरः पुत्रः। ");
INSERT INTO sandev_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","एर् योशेः पुत्रः, योशिः इलीयेषरः पुत्रः, इलीयेषर् योरीमः पुत्रः, योरीम् मत्ततः पुत्रः, मत्तत लेवेः पुत्रः। ");
INSERT INTO sandev_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","लेविः शिमियोनः पुत्रः, शिमियोन् यिहूदाः पुत्रः, यिहूदा यूषुफः पुत्रः, यूषुफ् योननः पुत्रः, यानन् इलीयाकीमः पुत्रः। ");
INSERT INTO sandev_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","इलियाकीम्ः मिलेयाः पुत्रः, मिलेया मैननः पुत्रः, मैनन् मत्तत्तस्य पुत्रः, मत्तत्तो नाथनः पुत्रः, नाथन् दायूदः पुत्रः। ");
INSERT INTO sandev_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","दायूद् यिशयः पुत्रः, यिशय ओबेदः पुत्र, ओबेद् बोयसः पुत्रः, बोयस् सल्मोनः पुत्रः, सल्मोन् नहशोनः पुत्रः। ");
INSERT INTO sandev_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","नहशोन् अम्मीनादबः पुत्रः, अम्मीनादब् अरामः पुत्रः, अराम् हिष्रोणः पुत्रः, हिष्रोण् पेरसः पुत्रः, पेरस् यिहूदाः पुत्रः। ");
INSERT INTO sandev_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","यिहूदा याकूबः पुत्रः, याकूब् इस्हाकः पुत्रः, इस्हाक् इब्राहीमः पुत्रः, इब्राहीम् तेरहः पुत्रः, तेरह् नाहोरः पुत्रः। ");
INSERT INTO sandev_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","नाहोर् सिरुगः पुत्रः, सिरुग् रिय्वः पुत्रः, रियूः पेलगः पुत्रः, पेलग् एवरः पुत्रः, एवर् शेलहः पुत्रः। ");
INSERT INTO sandev_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","शेलह् कैननः पुत्रः, कैनन् अर्फक्षदः पुत्रः, अर्फक्षद् शामः पुत्रः, शाम् नोहः पुत्रः, नोहो लेमकः पुत्रः। ");
INSERT INTO sandev_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","लेमक् मिथूशेलहः पुत्रः, मिथूशेलह् हनोकः पुत्रः, हनोक् येरदः पुत्रः, येरद् महललेलः पुत्रः, महललेल् कैननः पुत्रः। ");
INSERT INTO sandev_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","कैनन् इनोशः पुत्रः, इनोश् शेतः पुत्रः, शेत् आदमः पुत्र, आदम् ईश्वरस्य पुत्रः। ");
INSERT INTO sandev_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ततः परं यीशुः पवित्रेणात्मना पूर्णः सन् यर्द्दननद्याः परावृत्यात्मना प्रान्तरं नीतः सन् चत्वारिंशद्दिनानि यावत् शैताना परीक्षितोऽभूत्, ");
INSERT INTO sandev_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","किञ्च तानि सर्व्वदिनानि भोजनं विना स्थितत्वात् काले पूर्णे स क्षुधितवान्। ");
INSERT INTO sandev_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ततः शैतानागत्य तमवदत् त्वं चेदीश्वरस्य पुत्रस्तर्हि प्रस्तरानेतान् आज्ञया पूपान् कुरु। ");
INSERT INTO sandev_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","तदा यीशुरुवाच, लिपिरीदृशी विद्यते मनुजः केवलेन पूपेन न जीवति किन्त्वीश्वरस्य सर्व्वाभिराज्ञाभि र्जीवति। ");
INSERT INTO sandev_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","तदा शैतान् तमुच्चं पर्व्वतं नीत्वा निमिषैकमध्ये जगतः सर्व्वराज्यानि दर्शितवान्। ");
INSERT INTO sandev_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","पश्चात् तमवादीत् सर्व्वम् एतद् विभवं प्रतापञ्च तुभ्यं दास्यामि तन् मयि समर्पितमास्ते यं प्रति ममेच्छा जायते तस्मै दातुं शक्नोमि, ");
INSERT INTO sandev_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","त्वं चेन्मां भजसे तर्हि सर्व्वमेतत् तवैव भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","तदा यीशुस्तं प्रत्युक्तवान् दूरी भव शैतान् लिपिरास्ते, निजं प्रभुं परमेश्वरं भजस्व केवलं तमेव सेवस्व च। ");
INSERT INTO sandev_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","अथ शैतान् तं यिरूशालमं नीत्वा मन्दिरस्य चूडाया उपरि समुपवेश्य जगाद त्वं चेदीश्वरस्य पुत्रस्तर्हि स्थानादितो लम्फित्वाधः ");
INSERT INTO sandev_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","पत यतो लिपिरास्ते, आज्ञापयिष्यति स्वीयान् दूतान् स परमेश्वरः। ");
INSERT INTO sandev_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","रक्षितुं सर्व्वमार्गे त्वां तेन त्वच्चरणे यथा। न लगेत् प्रस्तराघातस्त्वां धरिष्यन्ति ते तथा। ");
INSERT INTO sandev_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","तदा यीशुना प्रत्युक्तम् इदमप्युक्तमस्ति त्वं स्वप्रभुं परेशं मा परीक्षस्व। ");
INSERT INTO sandev_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","पश्चात् शैतान् सर्व्वपरीक्षां समाप्य क्षणात्तं त्यक्त्वा ययौ। ");
INSERT INTO sandev_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","तदा यीशुरात्मप्रभावात् पुनर्गालील्प्रदेशं गतस्तदा तत्सुख्यातिश्चतुर्दिशं व्यानशे। ");
INSERT INTO sandev_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","स तेषां भजनगृहेषु उपदिश्य सर्व्वैः प्रशंसितो बभूव। ");
INSERT INTO sandev_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","अथ स स्वपालनस्थानं नासरत्पुरमेत्य विश्रामवारे स्वाचाराद् भजनगेहं प्रविश्य पठितुमुत्तस्थौ। ");
INSERT INTO sandev_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ततो यिशयियभविष्यद्वादिनः पुस्तके तस्य करदत्ते सति स तत् पुस्तकं विस्तार्य्य यत्र वक्ष्यमाणानि वचनानि सन्ति तत् स्थानं प्राप्य पपाठ। ");
INSERT INTO sandev_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","आत्मा तु परमेशस्य मदीयोपरि विद्यते। दरिद्रेषु सुसंवादं वक्तुं मां सोभिषिक्तवान्। भग्नान्तः करणाल्लोकान् सुस्वस्थान् कर्त्तुमेव च। बन्दीकृतेषु लोकेषु मुक्ते र्घोषयितुं वचः। नेत्राणि दातुमन्धेभ्यस्त्रातुं बद्धजनानपि। ");
INSERT INTO sandev_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","परेशानुग्रहे कालं प्रचारयितुमेव च। सर्व्वैतत्करणार्थाय मामेव प्रहिणोति सः॥ ");
INSERT INTO sandev_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ततः पुस्तकं बद्व्वा परिचारकस्य हस्ते समर्प्य चासने समुपविष्टः, ततो भजनगृहे यावन्तो लोका आसन् ते सर्व्वेऽनन्यदृष्ट्या तं विलुलोकिरे। ");
INSERT INTO sandev_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","अनन्तरम् अद्यैतानि सर्व्वाणि लिखितवचनानि युष्माकं मध्ये सिद्धानि स इमां कथां तेभ्यः कथयितुमारेभे। ");
INSERT INTO sandev_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","ततः सर्व्वे तस्मिन् अन्वरज्यन्त, किञ्च तस्य मुखान्निर्गताभिरनुग्रहस्य कथाभिश्चमत्कृत्य कथयामासुः किमयं यूषफः पुत्रो न? ");
INSERT INTO sandev_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","तदा सोऽवादीद् हे चिकित्सक स्वमेव स्वस्थं कुरु कफर्नाहूमि यद्यत् कृतवान् तदश्रौष्म ताः सर्वाः क्रिया अत्र स्वदेशे कुरु कथामेतां यूयमेवावश्यं मां वदिष्यथ। ");
INSERT INTO sandev_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","पुनः सोवादीद् युष्मानहं यथार्थं वदामि, कोपि भविष्यद्वादी स्वदेशे सत्कारं न प्राप्नोति। ");
INSERT INTO sandev_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","अपरञ्च यथार्थं वच्मि, एलियस्य जीवनकाले यदा सार्द्धत्रितयवर्षाणि यावत् जलदप्रतिबन्धात् सर्व्वस्मिन् देशे महादुर्भिक्षम् अजनिष्ट तदानीम् इस्रायेलो देशस्य मध्ये बह्व्यो विधवा आसन्, ");
INSERT INTO sandev_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","किन्तु सीदोन्प्रदेशीयसारिफत्पुरनिवासिनीम् एकां विधवां विना कस्याश्चिदपि समीपे एलियः प्रेरितो नाभूत्। ");
INSERT INTO sandev_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","अपरञ्च इलीशायभविष्यद्वादिविद्यमानताकाले इस्रायेल्देशे बहवः कुष्ठिन आसन् किन्तु सुरीयदेशीयं नामान्कुष्ठिनं विना कोप्यन्यः परिष्कृतो नाभूत्। ");
INSERT INTO sandev_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","इमां कथां श्रुत्वा भजनगेहस्थिता लोकाः सक्रोधम् उत्थाय ");
INSERT INTO sandev_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","नगरात्तं बहिष्कृत्य यस्य शिखरिण उपरि तेषां नगरं स्थापितमास्ते तस्मान्निक्षेप्तुं तस्य शिखरं तं निन्युः ");
INSERT INTO sandev_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","किन्तु स तेषां मध्यादपसृत्य स्थानान्तरं जगाम। ");
INSERT INTO sandev_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ततः परं यीशुर्गालील्प्रदेशीयकफर्नाहूम्नगर उपस्थाय विश्रामवारे लोकानुपदेष्टुम् आरब्धवान्। ");
INSERT INTO sandev_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","तदुपदेशात् सर्व्वे चमच्चक्रु र्यतस्तस्य कथा गुरुतरा आसन्। ");
INSERT INTO sandev_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","तदानीं तद्भजनगेहस्थितोऽमेध्यभूतग्रस्त एको जन उच्चैः कथयामास, ");
INSERT INTO sandev_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","हे नासरतीययीशोऽस्मान् त्यज, त्वया सहास्माकं कः सम्बन्धः? किमस्मान् विनाशयितुमायासि? त्वमीश्वरस्य पवित्रो जन एतदहं जानामि। ");
INSERT INTO sandev_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","तदा यीशुस्तं तर्जयित्वावदत् मौनी भव इतो बहिर्भव; ततः सोमेध्यभूतस्तं मध्यस्थाने पातयित्वा किञ्चिदप्यहिंसित्वा तस्माद् बहिर्गतवान्। ");
INSERT INTO sandev_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","ततः सर्व्वे लोकाश्चमत्कृत्य परस्परं वक्तुमारेभिरे कोयं चमत्कारः। एष प्रभावेण पराक्रमेण चामेध्यभूतान् आज्ञापयति तेनैव ते बहिर्गच्छन्ति। ");
INSERT INTO sandev_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","अनन्तरं चतुर्दिक्स्थदेशान् तस्य सुख्यातिर्व्याप्नोत्। ");
INSERT INTO sandev_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","तदनन्तरं स भजनगेहाद् बहिरागत्य शिमोनो निवेशनं प्रविवेश तदा तस्य श्वश्रूर्ज्वरेणात्यन्तं पीडितासीत् शिष्यास्तदर्थं तस्मिन् विनयं चक्रुः। ");
INSERT INTO sandev_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ततः स तस्याः समीपे स्थित्वा ज्वरं तर्जयामास तेनैव तां ज्वरोऽत्याक्षीत् ततः सा तत्क्षणम् उत्थाय तान् सिषेवे। ");
INSERT INTO sandev_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","अथ सूर्य्यास्तकाले स्वेषां ये ये जना नानारोगैः पीडिता आसन् लोकास्तान् यीशोः समीपम् आनिन्युः, तदा स एकैकस्य गात्रे करमर्पयित्वा तानरोगान् चकार। ");
INSERT INTO sandev_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ततो भूता बहुभ्यो निर्गत्य चीत्शब्दं कृत्वा च बभाषिरे त्वमीश्वरस्य पुत्रोऽभिषिक्तत्राता; किन्तु सोभिषिक्तत्रातेति ते विविदुरेतस्मात् कारणात् तान् तर्जयित्वा तद्वक्तुं निषिषेध। ");
INSERT INTO sandev_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","अपरञ्च प्रभाते सति स विजनस्थानं प्रतस्थे पश्चात् जनास्तमन्विच्छन्तस्तन्निकटं गत्वा स्थानान्तरगमनार्थं तमन्वरुन्धन्। ");
INSERT INTO sandev_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","किन्तु स तान् जगाद, ईश्वरीयराज्यस्य सुसंवादं प्रचारयितुम् अन्यानि पुराण्यपि मया यातव्यानि यतस्तदर्थमेव प्रेरितोहं। ");
INSERT INTO sandev_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","अथ गालीलो भजनगेहेषु स उपदिदेश। ");
INSERT INTO sandev_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","अनन्तरं यीशुरेकदा गिनेषरत्ह्दस्य तीर उत्तिष्ठति, तदा लोका ईश्वरीयकथां श्रोतुं तदुपरि प्रपतिताः। ");
INSERT INTO sandev_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","तदानीं स ह्दस्य तीरसमीपे नौद्वयं ददर्श किञ्च मत्स्योपजीविनो नावं विहाय जालं प्रक्षालयन्ति। ");
INSERT INTO sandev_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ततस्तयोर्द्वयो र्मध्ये शिमोनो नावमारुह्य तीरात् किञ्चिद्दूरं यातुं तस्मिन् विनयं कृत्वा नौकायामुपविश्य लोकान् प्रोपदिष्टवान्। ");
INSERT INTO sandev_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","पश्चात् तं प्रस्तावं समाप्य स शिमोनं व्याजहार, गभीरं जलं गत्वा मत्स्यान् धर्त्तुं जालं निक्षिप। ");
INSERT INTO sandev_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ततः शिमोन बभाषे, हे गुरो यद्यपि वयं कृत्स्नां यामिनीं परिश्रम्य मत्स्यैकमपि न प्राप्तास्तथापि भवतो निदेशतो जालं क्षिपामः। ");
INSERT INTO sandev_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","अथ जाले क्षिप्ते बहुमत्स्यपतनाद् आनायः प्रच्छिन्नः। ");
INSERT INTO sandev_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","तस्माद् उपकर्त्तुम् अन्यनौस्थान् सङ्गिन आयातुम् इङ्गितेन समाह्वयन् ततस्त आगत्य मत्स्यै र्नौद्वयं प्रपूरयामासु र्यै र्नौद्वयं प्रमग्नम्। ");
INSERT INTO sandev_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","तदा शिमोन्पितरस्तद् विलोक्य यीशोश्चरणयोः पतित्वा, हे प्रभोहं पापी नरो मम निकटाद् भवान् यातु, इति कथितवान्। ");
INSERT INTO sandev_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","यतो जाले पतितानां मत्स्यानां यूथात् शिमोन् तत्सङ्गिनश्च चमत्कृतवन्तः; शिमोनः सहकारिणौ सिवदेः पुत्रौ याकूब् योहन् चेमौ तादृशौ बभूवतुः। ");
INSERT INTO sandev_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","तदा यीशुः शिमोनं जगाद मा भैषीरद्यारभ्य त्वं मनुष्यधरो भविष्यसि। ");
INSERT INTO sandev_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","अनन्तरं सर्व्वासु नौसु तीरम् आनीतासु ते सर्व्वान् परित्यज्य तस्य पश्चाद्गामिनो बभूवुः। ");
INSERT INTO sandev_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","ततः परं यीशौ कस्मिंश्चित् पुरे तिष्ठति जन एकः सर्व्वाङ्गकुष्ठस्तं विलोक्य तस्य समीपे न्युब्जः पतित्वा सविनयं वक्तुमारेभे, हे प्रभो यदि भवानिच्छति तर्हि मां परिष्कर्त्तुं शक्नोति। ");
INSERT INTO sandev_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","तदानीं स पाणिं प्रसार्य्य तदङ्गं स्पृशन् बभाषे त्वं परिष्क्रियस्वेति ममेच्छास्ति ततस्तत्क्षणं स कुष्ठात् मुक्तः। ");
INSERT INTO sandev_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","पश्चात् स तमाज्ञापयामास कथामिमां कस्मैचिद् अकथयित्वा याजकस्य समीपञ्च गत्वा स्वं दर्शय, लोकेभ्यो निजपरिष्कृतत्वस्य प्रमाणदानाय मूसाज्ञानुसारेण द्रव्यमुत्मृजस्व च। ");
INSERT INTO sandev_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","तथापि यीशोः सुख्याति र्बहु व्याप्तुमारेभे किञ्च तस्य कथां श्रोतुं स्वीयरोगेभ्यो मोक्तुञ्च लोका आजग्मुः। ");
INSERT INTO sandev_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","अथ स प्रान्तरं गत्वा प्रार्थयाञ्चक्रे। ");
INSERT INTO sandev_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","अपरञ्च एकदा यीशुरुपदिशति, एतर्हि गालील्यिहूदाप्रदेशयोः सर्व्वनगरेभ्यो यिरूशालमश्च कियन्तः फिरूशिलोका व्यवस्थापकाश्च समागत्य तदन्तिके समुपविविशुः, तस्मिन् काले लोकानामारोग्यकारणात् प्रभोः प्रभावः प्रचकाशे। ");
INSERT INTO sandev_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","पश्चात् कियन्तो लोका एकं पक्षाघातिनं खट्वायां निधाय यीशोः समीपमानेतुं सम्मुखे स्थापयितुञ्च व्याप्रियन्त। ");
INSERT INTO sandev_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","किन्तु बहुजननिवहसम्वाधात् न शक्नुवन्तो गृहोपरि गत्वा गृहपृष्ठं खनित्वा तं पक्षाघातिनं सखट्वं गृहमध्ये यीशोः सम्मुखे ऽवरोहयामासुः। ");
INSERT INTO sandev_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","तदा यीशुस्तेषाम् ईदृशं विश्वासं विलोक्य तं पक्षाघातिनं व्याजहार, हे मानव तव पापमक्षम्यत। ");
INSERT INTO sandev_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","तस्माद् अध्यापकाः फिरूशिनश्च चित्तैरित्थं प्रचिन्तितवन्तः, एष जन ईश्वरं निन्दति कोयं? केवलमीश्वरं विना पापं क्षन्तुं कः शक्नोति? ");
INSERT INTO sandev_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","तदा यीशुस्तेषाम् इत्थं चिन्तनं विदित्वा तेभ्योकथयद् यूयं मनोभिः कुतो वितर्कयथ? ");
INSERT INTO sandev_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","तव पापक्षमा जाता यद्वा त्वमुत्थाय व्रज एतयो र्मध्ये का कथा सुकथ्या? ");
INSERT INTO sandev_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","किन्तु पृथिव्यां पापं क्षन्तुं मानवसुतस्य सामर्थ्यमस्तीति यथा यूयं ज्ञातुं शक्नुथ तदर्थं (स तं पक्षाघातिनं जगाद) उत्तिष्ठ स्वशय्यां गृहीत्वा गृहं याहीति त्वामादिशामि। ");
INSERT INTO sandev_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","तस्मात् स तत्क्षणम् उत्थाय सर्व्वेषां साक्षात् निजशयनीयं गृहीत्वा ईश्वरं धन्यं वदन् निजनिवेशनं ययौ। ");
INSERT INTO sandev_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","तस्मात् सर्व्वे विस्मय प्राप्ता मनःसु भीताश्च वयमद्यासम्भवकार्य्याण्यदर्शाम इत्युक्त्वा परमेश्वरं धन्यं प्रोदिताः। ");
INSERT INTO sandev_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","ततः परं बहिर्गच्छन् करसञ्चयस्थाने लेविनामानं करसञ्चायकं दृष्ट्वा यीशुस्तमभिदधे मम पश्चादेहि। ");
INSERT INTO sandev_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","तस्मात् स तत्क्षणात् सर्व्वं परित्यज्य तस्य पश्चादियाय। ");
INSERT INTO sandev_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","अनन्तरं लेवि र्निजगृहे तदर्थं महाभोज्यं चकार, तदा तैः सहानेके करसञ्चायिनस्तदन्यलोकाश्च भोक्तुमुपविविशुः। ");
INSERT INTO sandev_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","तस्मात् कारणात् चण्डालानां पापिलोकानाञ्च सङ्गे यूयं कुतो भंग्ध्वे पिवथ चेति कथां कथयित्वा फिरूशिनोऽध्यापकाश्च तस्य शिष्यैः सह वाग्युद्धं कर्त्तुमारेभिरे। ");
INSERT INTO sandev_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","तस्माद् यीशुस्तान् प्रत्यवोचद् अरोगलोकानां चिकित्सकेन प्रयोजनं नास्ति किन्तु सरोगाणामेव। ");
INSERT INTO sandev_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","अहं धार्म्मिकान् आह्वातुं नागतोस्मि किन्तु मनः परावर्त्तयितुं पापिन एव। ");
INSERT INTO sandev_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","ततस्ते प्रोचुः, योहनः फिरूशिनाञ्च शिष्या वारंवारम् उपवसन्ति प्रार्थयन्ते च किन्तु तव शिष्याः कुतो भुञ्जते पिवन्ति च? ");
INSERT INTO sandev_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","तदा स तानाचख्यौ वरे सङ्गे तिष्ठति वरस्य सखिगणं किमुपवासयितुं शक्नुथ? ");
INSERT INTO sandev_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","किन्तु यदा तेषां निकटाद् वरो नेष्यते तदा ते समुपवत्स्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","सोपरमपि दृष्टान्तं कथयाम्बभूव पुरातनवस्त्रे कोपि नुतनवस्त्रं न सीव्यति यतस्तेन सेवनेन जीर्णवस्त्रं छिद्यते, नूतनपुरातनवस्त्रयो र्मेलञ्च न भवति। ");
INSERT INTO sandev_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","पुरातन्यां कुत्वां कोपि नुतनं द्राक्षारसं न निदधाति, यतो नवीनद्राक्षारसस्य तेजसा पुरातनी कुतू र्विदीर्य्यते ततो द्राक्षारसः पतति कुतूश्च नश्यति। ");
INSERT INTO sandev_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","ततो हेतो र्नूतन्यां कुत्वां नवीनद्राक्षारसः निधातव्यस्तेनोभयस्य रक्षा भवति। ");
INSERT INTO sandev_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","अपरञ्च पुरातनं द्राक्षारसं पीत्वा कोपि नूतनं न वाञ्छति, यतः स वक्ति नूतनात् पुरातनम् प्रशस्तम्। ");
INSERT INTO sandev_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","अचरञ्च पर्व्वणो द्वितीयदिनात् परं प्रथमविश्रामवारे शस्यक्षेत्रेण यीशोर्गमनकाले तस्य शिष्याः कणिशं छित्त्वा करेषु मर्द्दयित्वा खादितुमारेभिरे। ");
INSERT INTO sandev_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","तस्मात् कियन्तः फिरूशिनस्तानवदन् विश्रामवारे यत् कर्म्म न कर्त्तव्यं तत् कुतः कुरुथ? ");
INSERT INTO sandev_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","यीशुः प्रत्युवाच दायूद् तस्य सङ्गिनश्च क्षुधार्त्ताः किं चक्रुः स कथम् ईश्वरस्य मन्दिरं प्रविश्य ");
INSERT INTO sandev_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ये दर्शनीयाः पूपा याजकान् विनान्यस्य कस्याप्यभोजनीयास्तानानीय स्वयं बुभजे सङ्गिभ्योपि ददौ तत् किं युष्माभिः कदापि नापाठि? ");
INSERT INTO sandev_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","पश्चात् स तानवदत् मनुजसुतो विश्रामवारस्यापि प्रभु र्भवति। ");
INSERT INTO sandev_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","अनन्तरम् अन्यविश्रामवारे स भजनगेहं प्रविश्य समुपदिशति। तदा तत्स्थाने शुष्कदक्षिणकर एकः पुमान् उपतस्थिवान्। ");
INSERT INTO sandev_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","तस्माद् अध्यापकाः फिरूशिनश्च तस्मिन् दोषमारोपयितुं स विश्रामवारे तस्य स्वास्थ्यं करोति नवेति प्रतीक्षितुमारेभिरे। ");
INSERT INTO sandev_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","तदा यीशुस्तेषां चिन्तां विदित्वा तं शुष्ककरं पुमांसं प्रोवाच, त्वमुत्थाय मध्यस्थाने तिष्ठ। ");
INSERT INTO sandev_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","तस्मात् तस्मिन् उत्थितवति यीशुस्तान् व्याजहार, युष्मान् इमां कथां पृच्छामि, विश्रामवारे हितम् अहितं वा, प्राणरक्षणं प्राणनाशनं वा, एतेषां किं कर्म्मकरणीयम्? ");
INSERT INTO sandev_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","पश्चात् चतुर्दिक्षु सर्व्वान् विलोक्य तं मानवं बभाषे, निजकरं प्रसारय; ततस्तेन तथा कृत इतरकरवत् तस्य हस्तः स्वस्थोभवत्। ");
INSERT INTO sandev_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","तस्मात् ते प्रचण्डकोपान्विता यीशुं किं करिष्यन्तीति परस्परं प्रमन्त्रिताः। ");
INSERT INTO sandev_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ततः परं स पर्व्वतमारुह्येश्वरमुद्दिश्य प्रार्थयमानः कृत्स्नां रात्रिं यापितवान्। ");
INSERT INTO sandev_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","अथ दिने सति स सर्व्वान् शिष्यान् आहूतवान् तेषां मध्ये ");
INSERT INTO sandev_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","पितरनाम्ना ख्यातः शिमोन् तस्य भ्राता आन्द्रियश्च याकूब् योहन् च फिलिप् बर्थलमयश्च ");
INSERT INTO sandev_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","मथिः थोमा आल्फीयस्य पुत्रो याकूब् ज्वलन्तनाम्ना ख्यातः शिमोन् ");
INSERT INTO sandev_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","च याकूबो भ्राता यिहूदाश्च तं यः परकरेषु समर्पयिष्यति स ईष्करीयोतीययिहूदाश्चैतान् द्वादश जनान् मनोनीतान् कृत्वा स जग्राह तथा प्रेरित इति तेषां नाम चकार। ");
INSERT INTO sandev_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","ततः परं स तैः सह पर्व्वतादवरुह्य उपत्यकायां तस्थौ ततस्तस्य शिष्यसङ्घो यिहूदादेशाद् यिरूशालमश्च सोरः सीदोनश्च जलधे रोधसो जननिहाश्च एत्य तस्य कथाश्रवणार्थं रोगमुक्त्यर्थञ्च तस्य समीपे तस्थुः। ");
INSERT INTO sandev_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","अमेध्यभूतग्रस्ताश्च तन्निकटमागत्य स्वास्थ्यं प्रापुः। ");
INSERT INTO sandev_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","सर्व्वेषां स्वास्थ्यकरणप्रभावस्य प्रकाशितत्वात् सर्व्वे लोका एत्य तं स्प्रष्टुं येतिरे। ");
INSERT INTO sandev_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","पश्चात् स शिष्यान् प्रति दृष्टिं कुत्वा जगाद, हे दरिद्रा यूयं धन्या यत ईश्वरीये राज्ये वोऽधिकारोस्ति। ");
INSERT INTO sandev_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","हे अधुना क्षुधितलोका यूयं धन्या यतो यूयं तर्प्स्यथ; हे इह रोदिनो जना यूयं धन्या यतो यूयं हसिष्यथ। ");
INSERT INTO sandev_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","यदा लोका मनुष्यसूनो र्नामहेतो र्युष्मान् ऋृतीयिष्यन्ते पृथक् कृत्वा निन्दिष्यन्ति, अधमानिव युष्मान् स्वसमीपाद् दूरीकरिष्यन्ति च तदा यूयं धन्याः। ");
INSERT INTO sandev_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","स्वर्गे युष्माकं यथेष्टं फलं भविष्यति, एतदर्थं तस्मिन् दिने प्रोल्लसत आनन्देन नृत्यत च, तेषां पूर्व्वपुरुषाश्च भविष्यद्वादिनः प्रति तथैव व्यवाहरन्। ");
INSERT INTO sandev_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","किन्तु हा हा धनवन्तो यूयं सुखं प्राप्नुत। हन्त परितृप्ता यूयं क्षुधिता भविष्यथ; ");
INSERT INTO sandev_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","इह हसन्तो यूयं वत युष्माभिः शोचितव्यं रोदितव्यञ्च। ");
INSERT INTO sandev_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","सर्व्वैलाकै र्युष्माकं सुख्यातौ कृतायां युष्माकं दुर्गति र्भविष्यति युष्माकं पूर्व्वपुरुषा मृषाभविष्यद्वादिनः प्रति तद्वत् कृतवन्तः। ");
INSERT INTO sandev_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","हे श्रोतारो युष्मभ्यमहं कथयामि, यूयं शत्रुषु प्रीयध्वं ये च युष्मान् द्विषन्ति तेषामपि हितं कुरुत। ");
INSERT INTO sandev_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ये च युष्मान् शपन्ति तेभ्य आशिषं दत्त ये च युष्मान् अवमन्यन्ते तेषां मङ्गलं प्रार्थयध्वं। ");
INSERT INTO sandev_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","यदि कश्चित् तव कपोले चपेटाघातं करोति तर्हि तं प्रति कपोलम् अन्यं परावर्त्त्य सम्मुखीकुरु पुनश्च यदि कश्चित् तव गात्रीयवस्त्रं हरति तर्हि तं परिधेयवस्त्रम् अपि ग्रहीतुं मा वारय। ");
INSERT INTO sandev_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","यस्त्वां याचते तस्मै देहि, यश्च तव सम्पत्तिं हरति तं मा याचस्व। ");
INSERT INTO sandev_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","परेभ्यः स्वान् प्रति यथाचरणम् अपेक्षध्वे परान् प्रति यूयमपि तथाचरत। ");
INSERT INTO sandev_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","ये जना युष्मासु प्रीयन्ते केवलं तेषु प्रीयमाणेषु युष्माकं किं फलं? पापिलोका अपि स्वेषु प्रीयमाणेषु प्रीयन्ते। ");
INSERT INTO sandev_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","यदि हितकारिण एव हितं कुरुथ तर्हि युष्माकं किं फलं? पापिलोका अपि तथा कुर्व्वन्ति। ");
INSERT INTO sandev_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","येभ्य ऋणपरिशोधस्य प्राप्तिप्रत्याशास्ते केवलं तेषु ऋणे समर्पिते युष्माकं किं फलं? पुनः प्राप्त्याशया पापीलोका अपि पापिजनेषु ऋणम् अर्पयन्ति। ");
INSERT INTO sandev_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","अतो यूयं रिपुष्वपि प्रीयध्वं, परहितं कुरुत च; पुनः प्राप्त्याशां त्यक्त्वा ऋणमर्पयत, तथा कृते युष्माकं महाफलं भविष्यति, यूयञ्च सर्व्वप्रधानस्य सन्ताना इति ख्यातिं प्राप्स्यथ, यतो युष्माकं पिता कृतघ्नानां दुर्व्टत्तानाञ्च हितमाचरति। ");
INSERT INTO sandev_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","अत एव स यथा दयालु र्यूयमपि तादृशा दयालवो भवत। ");
INSERT INTO sandev_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","अपरञ्च परान् दोषिणो मा कुरुत तस्माद् यूयं दोषीकृता न भविष्यथ; अदण्ड्यान् मा दण्डयत तस्माद् यूयमपि दण्डं न प्राप्स्यथ; परेषां दोषान् क्षमध्वं तस्माद् युष्माकमपि दोषाः क्षमिष्यन्ते। ");
INSERT INTO sandev_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","दानानिदत्त तस्माद् यूयं दानानि प्राप्स्यथ, वरञ्च लोकाः परिमाणपात्रं प्रदलय्य सञ्चाल्य प्रोञ्चाल्य परिपूर्य्य युष्माकं क्रोडेषु समर्पयिष्यन्ति; यूयं येन परिमाणेन परिमाथ तेनैव परिमाणेन युष्मत्कृते परिमास्यते। ");
INSERT INTO sandev_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","अथ स तेभ्यो दृष्टान्तकथामकथयत्, अन्धो जनः किमन्धं पन्थानं दर्शयितुं शक्नोति? तस्माद् उभावपि किं गर्त्ते न पतिष्यतः? ");
INSERT INTO sandev_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","गुरोः शिष्यो न श्रेष्ठः किन्तु शिष्ये सिद्धे सति स गुरुतुल्यो भवितुं शक्नोति। ");
INSERT INTO sandev_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","अपरञ्च त्वं स्वचक्षुुषि नासाम् अदृष्ट्वा तव भ्रातुश्चक्षुषि यत्तृणमस्ति तदेव कुतः पश्यमि? ");
INSERT INTO sandev_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","स्वचक्षुषि या नासा विद्यते ताम् अज्ञात्वा, भ्रातस्तव नेत्रात् तृणं बहिः करोमीति वाक्यं भ्रातरं कथं वक्तुं शक्नोषि? हे कपटिन् पूर्व्वं स्वनयनात् नासां बहिः कुरु ततो भ्रातुश्चक्षुषस्तृणं बहिः कर्त्तुं सुदृष्टिं प्राप्स्यसि। ");
INSERT INTO sandev_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","अन्यञ्च उत्तमस्तरुः कदापि फलमनुत्तमं न फलति, अनुत्तमतरुश्च फलमुत्तमं न फलति कारणादतः फलैस्तरवो ज्ञायन्ते। ");
INSERT INTO sandev_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","कण्टकिपादपात् कोपि उडुम्बरफलानि न पातयति तथा शृगालकोलिवृक्षादपि कोपि द्राक्षाफलं न पातयति। ");
INSERT INTO sandev_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","तद्वत् साधुलोकोऽन्तःकरणरूपात् सुभाण्डागाराद् उत्तमानि द्रव्याणि बहिः करोति, दुष्टो लोकश्चान्तःकरणरूपात् कुभाण्डागारात् कुत्सितानि द्रव्याणि निर्गमयति यतोऽन्तःकरणानां पूर्णभावानुरूपाणि वचांसि मुखान्निर्गच्छन्ति। ");
INSERT INTO sandev_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","अपरञ्च ममाज्ञानुरूपं नाचरित्वा कुतो मां प्रभो प्रभो इति वदथ? ");
INSERT INTO sandev_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","यः कश्चिन् मम निकटम् आगत्य मम कथा निशम्य तदनुरूपं कर्म्म करोति स कस्य सदृशो भवति तदहं युष्मान् ज्ञाापयामि। ");
INSERT INTO sandev_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","यो जनो गभीरं खनित्वा पाषाणस्थले भित्तिं निर्म्माय स्वगृहं रचयति तेन सह तस्योपमा भवति; यत आप्लाविजलमेत्य तस्य मूले वेगेन वहदपि तद्गेहं लाडयितुं न शक्नोति यतस्तस्य भित्तिः पाषाणोपरि तिष्ठति। ");
INSERT INTO sandev_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","किन्तु यः कश्चिन् मम कथाः श्रुत्वा तदनुरूपं नाचरति स भित्तिं विना मृृदुपरि गृहनिर्म्मात्रा समानो भवति; यत आप्लाविजलमागत्य वेगेन यदा वहति तदा तद्गृहं पतति तस्य महत् पतनं जायते। ");
INSERT INTO sandev_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","ततः परं स लोकानां कर्णगोचरे तान् सर्व्वान् उपदेशान् समाप्य यदा कफर्नाहूम्पुरं प्रविशति ");
INSERT INTO sandev_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","तदा शतसेनापतेः प्रियदास एको मृतकल्पः पीडित आसीत्। ");
INSERT INTO sandev_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","अतः सेनापति र्यीशो र्वार्त्तां निशम्य दासस्यारोग्यकरणाय तस्यागमनार्थं विनयकरणाय यिहूदीयान् कियतः प्राचः प्रेषयामास। ");
INSERT INTO sandev_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","ते यीशोरन्तिकं गत्वा विनयातिशयं वक्तुमारेभिरे, स सेनापति र्भवतोनुग्रहं प्राप्तुम् अर्हति। ");
INSERT INTO sandev_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","यतः सोस्मज्जातीयेषु लोकेषु प्रीयते तथास्मत्कृते भजनगेहं निर्म्मितवान्। ");
INSERT INTO sandev_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","तस्माद् यीशुस्तैः सह गत्वा निवेशनस्य समीपं प्राप, तदा स शतसेनापति र्वक्ष्यमाणवाक्यं तं वक्तुं बन्धून् प्राहिणोत्। हे प्रभो स्वयं श्रमो न कर्त्तव्यो यद् भवता मद्गेहमध्ये पादार्पणं क्रियेत तदप्यहं नार्हामि, ");
INSERT INTO sandev_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","किञ्चाहं भवत्समीपं यातुमपि नात्मानं योग्यं बुद्धवान्, ततो भवान् वाक्यमात्रं वदतु तेनैव मम दासः स्वस्थो भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","यस्माद् अहं पराधीनोपि ममाधीना याः सेनाः सन्ति तासाम् एकजनं प्रति याहीति मया प्रोक्ते स याति; तदन्यं प्रति आयाहीति प्रोक्ते स आयाति; तथा निजदासं प्रति एतत् कुर्व्विति प्रोक्ते स तदेव करोति। ");
INSERT INTO sandev_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","यीशुरिदं वाक्यं श्रुत्वा विस्मयं ययौ, मुखं परावर्त्य पश्चाद्वर्त्तिनो लोकान् बभाषे च, युष्मानहं वदामि इस्रायेलो वंशमध्येपि विश्वासमीदृशं न प्राप्नवं। ");
INSERT INTO sandev_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ततस्ते प्रेषिता गृहं गत्वा तं पीडितं दासं स्वस्थं ददृशुः। ");
INSERT INTO sandev_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","परेऽहनि स नायीनाख्यं नगरं जगाम तस्यानेके शिष्या अन्ये च लोकास्तेन सार्द्धं ययुः। ");
INSERT INTO sandev_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","तेषु तन्नगरस्य द्वारसन्निधिं प्राप्तेषु कियन्तो लोका एकं मृतमनुजं वहन्तो नगरस्य बहिर्यान्ति, स तन्मातुरेकपुत्रस्तन्माता च विधवा; तया सार्द्धं तन्नगरीया बहवो लोका आसन्। ");
INSERT INTO sandev_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","प्रभुस्तां विलोक्य सानुकम्पः कथयामास, मा रोदीः। स समीपमित्वा खट्वां पस्पर्श तस्माद् वाहकाः स्थगितास्तम्युः; ");
INSERT INTO sandev_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","तदा स उवाच हे युवमनुष्य त्वमुत्तिष्ठ, त्वामहम् आज्ञापयामि। ");
INSERT INTO sandev_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","तस्मात् स मृतो जनस्तत्क्षणमुत्थाय कथां प्रकथितः; ततो यीशुस्तस्य मातरि तं समर्पयामास। ");
INSERT INTO sandev_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","तस्मात् सर्व्वे लोकाः शशङ्किरे; एको महाभविष्यद्वादी मध्येऽस्माकम् समुदैत्, ईश्वरश्च स्वलोकानन्वगृह्लात् कथामिमां कथयित्वा ईश्वरं धन्यं जगदुः। ");
INSERT INTO sandev_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ततः परं समस्तं यिहूदादेशं तस्य चतुर्दिक्स्थदेशञ्च तस्यैतत्कीर्त्ति र्व्यानशे। ");
INSERT INTO sandev_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ततः परं योहनः शिष्येषु तं तद्वृत्तान्तं ज्ञापितवत्सु ");
INSERT INTO sandev_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","स स्वशिष्याणां द्वौ जनावाहूय यीशुं प्रति वक्ष्यमाणं वाक्यं वक्तुं प्रेषयामास, यस्यागमनम् अपेक्ष्य तिष्ठामो वयं किं स एव जनस्त्वं? किं वयमन्यमपेक्ष्य स्थास्यामः? ");
INSERT INTO sandev_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","पश्चात्तौ मानवौ गत्वा कथयामासतुः, यस्यागमनम् अपेक्ष्य तिष्ठामो वयं, किं सएव जनस्त्वं? किं वयमन्यमपेक्ष्य स्थास्यामः? कथामिमां तुभ्यं कथयितुं योहन् मज्जक आवां प्रेषितवान्। ");
INSERT INTO sandev_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","तस्मिन् दण्डे यीशूरोगिणो महाव्याधिमतो दुष्टभूतग्रस्तांश्च बहून् स्वस्थान् कृत्वा, अनेकान्धेभ्यश्चक्षुंषि दत्त्वा प्रत्युवाच, ");
INSERT INTO sandev_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","युवां व्रजतम् अन्धा नेत्राणि खञ्जाश्चरणानि च प्राप्नुवन्ति, कुष्ठिनः परिष्क्रियन्ते, बधिराः श्रवणानि मृताश्च जीवनानि प्राप्नुवन्ति, दरिद्राणां समीपेषु सुसंवादः प्रचार्य्यते, यं प्रति विघ्नस्वरूपोहं न भवामि स धन्यः, ");
INSERT INTO sandev_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","एतानि यानि पश्यथः शृणुथश्च तानि योहनं ज्ञापयतम्। ");
INSERT INTO sandev_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","तयो र्दूतयो र्गतयोः सतो र्योहनि स लोकान् वक्तुमुपचक्रमे, यूयं मध्येप्रान्तरं किं द्रष्टुं निरगमत? किं वायुना कम्पितं नडं? ");
INSERT INTO sandev_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","यूयं किं द्रष्टुं निरगमत? किं सूक्ष्मवस्त्रपरिधायिनं कमपि नरं? किन्तु ये सूक्ष्ममृदुवस्त्राणि परिदधति सूत्तमानि द्रव्याणि भुञ्जते च ते राजधानीषु तिष्ठन्ति। ");
INSERT INTO sandev_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","तर्हि यूयं किं द्रष्टुं निरगमत? किमेकं भविष्यद्वादिनं? तदेव सत्यं किन्तु स पुमान् भविष्यद्वादिनोपि श्रेष्ठ इत्यहं युष्मान् वदामि; ");
INSERT INTO sandev_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","पश्य स्वकीयदूतन्तु तवाग्र प्रेषयाम्यहं। गत्वा त्वदीयमार्गन्तु स हि परिष्करिष्यति। यदर्थे लिपिरियम् आस्ते स एव योहन्। ");
INSERT INTO sandev_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","अतो युष्मानहं वदामि स्त्रिया गर्ब्भजातानां भविष्यद्वादिनां मध्ये योहनो मज्जकात् श्रेष्ठः कोपि नास्ति, तत्रापि ईश्वरस्य राज्ये यः सर्व्वस्मात् क्षुद्रः स योहनोपि श्रेष्ठः। ");
INSERT INTO sandev_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","अपरञ्च सर्व्वे लोकाः करमञ्चायिनश्च तस्य वाक्यानि श्रुत्वा योहना मज्जनेन मज्जिताः परमेश्वरं निर्दोषं मेनिरे। ");
INSERT INTO sandev_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","किन्तु फिरूशिनो व्यवस्थापकाश्च तेन न मज्जिताः स्वान् प्रतीश्वरस्योपदेशं निष्फलम् अकुर्व्वन्। ");
INSERT INTO sandev_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","अथ प्रभुः कथयामास, इदानीन्तनजनान् केनोपमामि? ते कस्य सदृशाः? ");
INSERT INTO sandev_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ये बालका विपण्याम् उपविश्य परस्परम् आहूय वाक्यमिदं वदन्ति, वयं युष्माकं निकटे वंशीरवादिष्म, किन्तु यूयं नानर्त्तिष्ट, वयं युष्माकं निकट अरोदिष्म, किन्तु युयं न व्यलपिष्ट, बालकैरेतादृशैस्तेषाम् उपमा भवति। ");
INSERT INTO sandev_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","यतो योहन् मज्जक आगत्य पूपं नाखादत् द्राक्षारसञ्च नापिवत् तस्माद् यूयं वदथ, भूतग्रस्तोयम्। ");
INSERT INTO sandev_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","ततः परं मानवसुत आगत्याखाददपिवञ्च तस्माद् यूयं वदथ, खादकः सुरापश्चाण्डालपापिनां बन्धुरेको जनो दृश्यताम्। ");
INSERT INTO sandev_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","किन्तु ज्ञानिनो ज्ञानं निर्दोषं विदुः। ");
INSERT INTO sandev_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","पश्चादेकः फिरूशी यीशुं भोजनाय न्यमन्त्रयत् ततः स तस्य गृहं गत्वा भोक्तुमुपविष्टः। ");
INSERT INTO sandev_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","एतर्हि तत्फिरूशिनो गृहे यीशु र्भेक्तुम् उपावेक्षीत् तच्छ्रुत्वा तन्नगरवासिनी कापि दुष्टा नारी पाण्डरप्रस्तरस्य सम्पुटके सुगन्धितैलम् आनीय ");
INSERT INTO sandev_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","तस्य पश्चात् पादयोः सन्निधौ तस्यौ रुदती च नेत्राम्बुभिस्तस्य चरणौ प्रक्षाल्य निजकचैरमार्क्षीत्, ततस्तस्य चरणौ चुम्बित्वा तेन सुगन्धितैलेन ममर्द। ");
INSERT INTO sandev_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","तस्मात् स निमन्त्रयिता फिरूशी मनसा चिन्तयामास, यद्ययं भविष्यद्वादी भवेत् तर्हि एनं स्पृशति या स्त्री सा का कीदृशी चेति ज्ञातुं शक्नुयात् यतः सा दुष्टा। ");
INSERT INTO sandev_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","तदा याशुस्तं जगाद, हे शिमोन् त्वां प्रति मम किञ्चिद् वक्तव्यमस्ति; तस्मात् स बभाषे, हे गुरो तद् वदतु। ");
INSERT INTO sandev_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","एकोत्तमर्णस्य द्वावधमर्णावास्तां, तयोरेकः पञ्चशतानि मुद्रापादान् अपरश्च पञ्चाशत् मुद्रापादान् धारयामास। ");
INSERT INTO sandev_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","तदनन्तरं तयोः शोध्याभावात् स उत्तमर्णस्तयो र्ऋणे चक्षमे; तस्मात् तयोर्द्वयोः कस्तस्मिन् प्रेष्यते बहु? तद् ब्रूहि। ");
INSERT INTO sandev_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","शिमोन् प्रत्युवाच, मया बुध्यते यस्याधिकम् ऋणं चक्षमे स इति; ततो यीशुस्तं व्याजहार, त्वं यथार्थं व्यचारयः। ");
INSERT INTO sandev_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","अथ तां नारीं प्रति व्याघुठ्य शिमोनमवोचत्, स्त्रीमिमां पश्यसि? तव गृहे मय्यागते त्वं पादप्रक्षालनार्थं जलं नादाः किन्तु योषिदेषा नयनजलै र्मम पादौ प्रक्षाल्य केशैरमार्क्षीत्। ");
INSERT INTO sandev_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","त्वं मां नाचुम्बीः किन्तु योषिदेषा स्वीयागमनादारभ्य मदीयपादौ चुम्बितुं न व्यरंस्त। ");
INSERT INTO sandev_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","त्वञ्च मदीयोत्तमाङ्गे किञ्चिदपि तैलं नामर्दीः किन्तु योषिदेषा मम चरणौ सुगन्धितैलेनामर्द्दीत्। ");
INSERT INTO sandev_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","अतस्त्वां व्याहरामि, एतस्या बहु पापमक्षम्यत ततो बहु प्रीयते किन्तु यस्याल्पपापं क्षम्यते सोल्पं प्रीयते। ");
INSERT INTO sandev_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ततः परं स तां बभाषे, त्वदीयं पापमक्षम्यत। ");
INSERT INTO sandev_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","तदा तेन सार्द्धं ये भोक्तुम् उपविविशुस्ते परस्परं वक्तुमारेभिरे, अयं पापं क्षमते क एषः? ");
INSERT INTO sandev_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","किन्तु स तां नारीं जगाद, तव विश्वासस्त्वां पर्य्यत्रास्त त्वं क्षेमेण व्रज। ");
INSERT INTO sandev_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","अपरञ्च यीशु र्द्वादशभिः शिष्यैः सार्द्धं नानानगरेषु नानाग्रामेषु च गच्छन् इश्वरीयराजत्वस्य सुसंवादं प्रचारयितुं प्रारेभे। ");
INSERT INTO sandev_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","तदा यस्याः सप्त भूता निरगच्छन् सा मग्दलीनीति विख्याता मरियम् हेरोद्राजस्य गृहाधिपतेः होषे र्भार्य्या योहना शूशाना ");
INSERT INTO sandev_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","प्रभृतयो या बह्व्यः स्त्रियः दुष्टभूतेभ्यो रोगेभ्यश्च मुक्ताः सत्यो निजविभूती र्व्ययित्वा तमसेवन्त, ताः सर्व्वास्तेन सार्द्धम् आसन्। ");
INSERT INTO sandev_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","अनन्तरं नानानगरेभ्यो बहवो लोका आगत्य तस्य समीपेऽमिलन्, तदा स तेभ्य एकां दृष्टान्तकथां कथयामास। एकः कृषीबलो बीजानि वप्तुं बहिर्जगाम, ");
INSERT INTO sandev_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","ततो वपनकाले कतिपयानि बीजानि मार्गपार्श्वे पेतुः, ततस्तानि पदतलै र्दलितानि पक्षिभि र्भक्षितानि च। ");
INSERT INTO sandev_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","कतिपयानि बीजानि पाषाणस्थले पतितानि यद्यपि तान्यङ्कुरितानि तथापि रसाभावात् शुशुषुः। ");
INSERT INTO sandev_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","कतिपयानि बीजानि कण्टकिवनमध्ये पतितानि ततः कण्टकिवनानि संवृद्ध्य तानि जग्रसुः। ");
INSERT INTO sandev_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","तदन्यानि कतिपयबीजानि च भूम्यामुत्तमायां पेतुस्ततस्तान्यङ्कुरयित्वा शतगुणानि फलानि फेलुः। स इमा कथां कथयित्वा प्रोच्चैः प्रोवाच, यस्य श्रोतुं श्रोत्रे स्तः स शृणोतु। ");
INSERT INTO sandev_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ततः परं शिष्यास्तं पप्रच्छुरस्य दृष्टान्तस्य किं तात्पर्य्यं? ");
INSERT INTO sandev_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ततः स व्याजहार, ईश्वरीयराज्यस्य गुह्यानि ज्ञातुं युष्मभ्यमधिकारो दीयते किन्त्वन्ये यथा दृष्ट्वापि न पश्यन्ति श्रुत्वापि म बुध्यन्ते च तदर्थं तेषां पुरस्तात् ताः सर्व्वाः कथा दृष्टान्तेन कथ्यन्ते। ");
INSERT INTO sandev_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","दृष्टान्तस्यास्याभिप्रायः, ईश्वरीयकथा बीजस्वरूपा। ");
INSERT INTO sandev_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ये कथामात्रं शृण्वन्ति किन्तु पश्चाद् विश्वस्य यथा परित्राणं न प्राप्नुवन्ति तदाशयेन शैतानेत्य हृदयातृ तां कथाम् अपहरति त एव मार्गपार्श्वस्थभूमिस्वरूपाः। ");
INSERT INTO sandev_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ये कथं श्रुत्वा सानन्दं गृह्लन्ति किन्त्वबद्धमूलत्वात् स्वल्पकालमात्रं प्रतीत्य परीक्षाकाले भ्रश्यन्ति तएव पाषाणभूमिस्वरूपाः। ");
INSERT INTO sandev_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ये कथां श्रुत्वा यान्ति विषयचिन्तायां धनलोभेन एेहिकसुखे च मज्जन्त उपयुक्तफलानि न फलन्ति त एवोप्तबीजकण्टकिभूस्वरूपाः। ");
INSERT INTO sandev_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","किन्तु ये श्रुत्वा सरलैः शुद्धैश्चान्तःकरणैः कथां गृह्लन्ति धैर्य्यम् अवलम्ब्य फलान्युत्पादयन्ति च त एवोत्तममृत्स्वरूपाः। ");
INSERT INTO sandev_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","अपरञ्च प्रदीपं प्रज्वाल्य कोपि पात्रेण नाच्छादयति तथा खट्वाधोपि न स्थापयति, किन्तु दीपाधारोपर्य्येव स्थापयति, तस्मात् प्रवेशका दीप्तिं पश्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","यन्न प्रकाशयिष्यते तादृग् अप्रकाशितं वस्तु किमपि नास्ति यच्च न सुव्यक्तं प्रचारयिष्यते तादृग् गृप्तं वस्तु किमपि नास्ति। ");
INSERT INTO sandev_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","अतो यूयं केन प्रकारेण शृणुथ तत्र सावधाना भवत, यस्य समीपे बर्द्धते तस्मै पुनर्दास्यते किन्तु यस्याश्रये न बर्द्धते तस्य यद्यदस्ति तदपि तस्मात् नेष्यते। ");
INSERT INTO sandev_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","अपरञ्च यीशो र्माता भ्रातरश्च तस्य समीपं जिगमिषवः ");
INSERT INTO sandev_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","किन्तु जनतासम्बाधात् तत्सन्निधिं प्राप्तुं न शेकुः। तत्पश्चात् तव माता भ्रातरश्च त्वां साक्षात् चिकीर्षन्तो बहिस्तिष्ठनतीति वार्त्तायां तस्मै कथितायां ");
INSERT INTO sandev_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","स प्रत्युवाच; ये जना ईश्वरस्य कथां श्रुत्वा तदनुरूपमाचरन्ति तएव मम माता भ्रातरश्च। ");
INSERT INTO sandev_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","अनन्तरं एकदा यीशुः शिष्यैः सार्द्धं नावमारुह्य जगाद, आयात वयं ह्रदस्य पारं यामः, ततस्ते जग्मुः। ");
INSERT INTO sandev_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","तेषु नौकां वाहयत्सु स निदद्रौ; ");
INSERT INTO sandev_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","अथाकस्मात् प्रबलझञ्भ्शगमाद् ह्रदे नौकायां तरङ्गैराच्छन्नायां विपत् तान् जग्रास।तस्माद् यीशोरन्तिकं गत्वा हे गुरो हे गुरो प्राणा नो यान्तीति गदित्वा तं जागरयाम्बभूवुः।तदा स उत्थाय वायुं तरङ्गांश्च तर्जयामास तस्मादुभौ निवृत्य स्थिरौ बभूवतुः। ");
INSERT INTO sandev_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","स तान् बभाषे युष्माकं विश्वासः क? तस्मात्ते भीता विस्मिताश्च परस्परं जगदुः, अहो कीदृगयं मनुजः पवनं पानीयञ्चादिशति तदुभयं तदादेशं वहति। ");
INSERT INTO sandev_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ततः परं गालील्प्रदेशस्य सम्मुखस्थगिदेरीयप्रदेशे नौकायां लगन्त्यां तटेऽवरोहमावाद् ");
INSERT INTO sandev_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","बहुतिथकालं भूतग्रस्त एको मानुषः पुरादागत्य तं साक्षाच्चकार। स मनुषो वासो न परिदधत् गृहे च न वसन् केवलं श्मशानम् अध्युवास। ");
INSERT INTO sandev_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","स यीशुं दृष्ट्वैव चीच्छब्दं चकार तस्य सम्मुखे पतित्वा प्रोच्चैर्जगाद च, हे सर्व्वप्रधानेश्वरस्य पुत्र, मया सह तव कः सम्बन्धः? त्वयि विनयं करोमि मां मा यातय। ");
INSERT INTO sandev_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","यतः स तं मानुषं त्यक्त्वा यातुम् अमेध्यभूतम् आदिदेश; स भूतस्तं मानुषम् असकृद् दधार तस्माल्लोकाः शृङ्खलेन निगडेन च बबन्धुः; स तद् भंक्त्वा भूतवशत्वात् मध्येप्रान्तरं ययौ। ");
INSERT INTO sandev_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","अनन्तरं यीशुस्तं पप्रच्छ तव किन्नाम? स उवाच, मम नाम बाहिनो यतो बहवो भूतास्तमाशिश्रियुः। ");
INSERT INTO sandev_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","अथ भूता विनयेन जगदुः, गभीरं गर्त्तं गन्तुं माज्ञापयास्मान्। ");
INSERT INTO sandev_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","तदा पर्व्वतोपरि वराहव्रजश्चरति तस्माद् भूता विनयेन प्रोचुः, अमुं वराहव्रजम् आश्रयितुम् अस्मान् अनुजानीहि; ततः सोनुजज्ञौ। ");
INSERT INTO sandev_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ततः परं भूतास्तं मानुषं विहाय वराहव्रजम् आशिश्रियुः वराहव्रजाश्च तत्क्षणात् कटकेन धावन्तो ह्रदे प्राणान् विजृहुः। ");
INSERT INTO sandev_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","तद् दृष्ट्वा शूकररक्षकाः पलायमाना नगरं ग्रामञ्च गत्वा तत्सर्व्ववृत्तान्तं कथयामासुः। ");
INSERT INTO sandev_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","ततः किं वृत्तम् एतद्दर्शनार्थं लोका निर्गत्य यीशोः समीपं ययुः, तं मानुषं त्यक्तभूतं परिहितवस्त्रं स्वस्थमानुषवद् यीशोश्चरणसन्निधौ सूपविशन्तं विलोक्य बिभ्युः। ");
INSERT INTO sandev_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ये लोकास्तस्य भूतग्रस्तस्य स्वास्थ्यकरणं ददृशुस्ते तेभ्यः सर्व्ववृत्तान्तं कथयामासुः। ");
INSERT INTO sandev_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","तदनन्तरं तस्य गिदेरीयप्रदेशस्य चतुर्दिक्स्था बहवो जना अतित्रस्ता विनयेन तं जगदुः, भवान् अस्माकं निकटाद् व्रजतु तस्मात् स नावमारुह्य ततो व्याघुट्य जगाम। ");
INSERT INTO sandev_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","तदानीं त्यक्तभूतमनुजस्तेन सह स्थातुं प्रार्थयाञ्चक्रे ");
INSERT INTO sandev_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","किन्तु तदर्थम् ईश्वरः कीदृङ्महाकर्म्म कृतवान् इति निवेशनं गत्वा विज्ञापय, यीशुः कथामेतां कथयित्वा तं विससर्ज। ततः स व्रजित्वा यीशुस्तदर्थं यन्महाकर्म्म चकार तत् पुरस्य सर्व्वत्र प्रकाशयितुं प्रारेभे। ");
INSERT INTO sandev_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","अथ यीशौ परावृत्यागते लोकास्तं आदरेण जगृहु र्यस्मात्ते सर्व्वे तमपेक्षाञ्चक्रिरे। ");
INSERT INTO sandev_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","तदनन्तरं यायीर्नाम्नो भजनगेहस्यैकोधिप आगत्य यीशोश्चरणयोः पतित्वा स्वनिवेशनागमनार्थं तस्मिन् विनयं चकार, ");
INSERT INTO sandev_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","यतस्तस्य द्वादशवर्षवयस्का कन्यैकासीत् सा मृतकल्पाभवत्। ततस्तस्य गमनकाले मार्गे लोकानां महान् समागमो बभूव। ");
INSERT INTO sandev_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","द्वादशवर्षाणि प्रदररोगग्रस्ता नाना वैद्यैश्चिकित्सिता सर्व्वस्वं व्ययित्वापि स्वास्थ्यं न प्राप्ता या योषित् सा यीशोः पश्चादागत्य तस्य वस्त्रग्रन्थिं पस्पर्श। ");
INSERT INTO sandev_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","तस्मात् तत्क्षणात् तस्या रक्तस्रावो रुद्धः। ");
INSERT INTO sandev_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","तदानीं यीशुरवदत् केनाहं स्पृष्टः? ततोऽनेकैरनङ्गीकृते पितरस्तस्य सङ्गिनश्चावदन्, हे गुरो लोका निकटस्थाः सन्तस्तव देहे घर्षयन्ति, तथापि केनाहं स्पृष्टइति भवान् कुतः पृच्छति? ");
INSERT INTO sandev_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","यीशुः कथयामास, केनाप्यहं स्पृष्टो, यतो मत्तः शक्ति र्निर्गतेति मया निश्चितमज्ञायि। ");
INSERT INTO sandev_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","तदा सा नारी स्वयं न गुप्तेति विदित्वा कम्पमाना सती तस्य सम्मुखे पपात; येन निमित्तेन तं पस्पर्श स्पर्शमात्राच्च येन प्रकारेण स्वस्थाभवत् तत् सर्व्वं तस्य साक्षादाचख्यौ। ");
INSERT INTO sandev_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ततः स तां जगाद हे कन्ये सुस्थिरा भव, तव विश्वासस्त्वां स्वस्थाम् अकार्षीत् त्वं क्षेमेण याहि। ");
INSERT INTO sandev_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","यीशोरेतद्वाक्यवदनकाले तस्याधिपते र्निवेशनात् कश्चिल्लोक आगत्य तं बभाषे, तव कन्या मृता गुरुं मा क्लिशान। ");
INSERT INTO sandev_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","किन्तु यीशुस्तदाकर्ण्याधिपतिं व्याजहार, मा भैषीः केवलं विश्वसिहि तस्मात् सा जीविष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","अथ तस्य निवेशने प्राप्ते स पितरं योहनं याकूबञ्च कन्याया मातरं पितरञ्च विना, अन्यं कञ्चन प्रवेष्टुं वारयामास। ");
INSERT INTO sandev_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","अपरञ्च ये रुदन्ति विलपन्ति च तान् सर्व्वान् जनान् उवाच, यूयं मा रोदिष्ट कन्या न मृता निद्राति। ");
INSERT INTO sandev_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","किन्तु सा निश्चितं मृतेति ज्ञात्वा ते तमुपजहसुः। ");
INSERT INTO sandev_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","पश्चात् स सर्व्वान् बहिः कृत्वा कन्यायाः करौ धृत्वाजुहुवे, हे कन्ये त्वमुत्तिष्ठ, ");
INSERT INTO sandev_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","तस्मात् तस्याः प्राणेषु पुनरागतेषु सा तत्क्षणाद् उत्तस्यौ। तदानीं तस्यै किञ्चिद् भक्ष्यं दातुम् आदिदेश। ");
INSERT INTO sandev_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ततस्तस्याः पितरौ विस्मयं गतौ किन्तु स तावादिदेश घटनाया एतस्याः कथां कस्मैचिदपि मा कथयतं। ");
INSERT INTO sandev_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","ततः परं स द्वादशशिष्यानाहूय भूतान् त्याजयितुं रोगान् प्रतिकर्त्तुञ्च तेभ्यः शक्तिमाधिपत्यञ्च ददौ। ");
INSERT INTO sandev_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","अपरञ्च ईश्वरीयराज्यस्य सुसंवादं प्रकाशयितुम् रोगिणामारोग्यं कर्त्तुञ्च प्रेरणकाले तान् जगाद। ");
INSERT INTO sandev_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","यात्रार्थं यष्टि र्वस्त्रपुटकं भक्ष्यं मुद्रा द्वितीयवस्त्रम्, एषां किमपि मा गृह्लीत। ");
INSERT INTO sandev_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","यूयञ्च यन्निवेशनं प्रविशथ नगरत्यागपर्य्यनतं तन्निवेशने तिष्ठत। ");
INSERT INTO sandev_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","तत्र यदि कस्यचित् पुरस्य लोका युष्माकमातिथ्यं न कुर्व्वन्ति तर्हि तस्मान्नगराद् गमनकाले तेषां विरुद्धं साक्ष्यार्थं युष्माकं पदधूलीः सम्पातयत। ");
INSERT INTO sandev_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","अथ ते प्रस्थाय सर्व्वत्र सुसंवादं प्रचारयितुं पीडितान् स्वस्थान् कर्त्तुञ्च ग्रामेषु भ्रमितुं प्रारेभिरे। ");
INSERT INTO sandev_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","एतर्हि हेरोद् राजा यीशोः सर्व्वकर्म्मणां वार्त्तां श्रुत्वा भृशमुद्विविजे ");
INSERT INTO sandev_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","यतः केचिदूचुर्योहन् श्मशानादुदतिष्ठत्। केचिदूचुः, एलियो दर्शनं दत्तवान्; एवमन्यलोका ऊचुः पूर्व्वीयः कश्चिद् भविष्यद्वादी समुत्थितः। ");
INSERT INTO sandev_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","किन्तु हेरोदुवाच योहनः शिरोऽहमछिनदम् इदानीं यस्येदृक्कर्म्मणां वार्त्तां प्राप्नोमि स कः? अथ स तं द्रष्टुम् ऐच्छत्। ");
INSERT INTO sandev_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","अनन्तरं प्रेरिताः प्रत्यागत्य यानि यानि कर्म्माणि चक्रुस्तानि यीशवे कथयामासुः ततः स तान् बैत्सैदानामकनगरस्य विजनं स्थानं नीत्वा गुप्तं जगाम। ");
INSERT INTO sandev_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","पश्चाल् लोकास्तद् विदित्वा तस्य पश्चाद् ययुः; ततः स तान् नयन् ईश्वरीयराज्यस्य प्रसङ्गमुक्तवान्, येषां चिकित्सया प्रयोजनम् आसीत् तान् स्वस्थान् चकार च। ");
INSERT INTO sandev_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","अपरञ्च दिवावसन्ने सति द्वादशशिष्या यीशोरन्तिकम् एत्य कथयामासुः, वयमत्र प्रान्तरस्थाने तिष्ठामः, ततो नगराणि ग्रामाणि गत्वा वासस्थानानि प्राप्य भक्ष्यद्रव्याणि क्रेतुं जननिवहं भवान् विसृजतु। ");
INSERT INTO sandev_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","तदा स उवाच, यूयमेव तान् भेजयध्वं; ततस्ते प्रोचुरस्माकं निकटे केवलं पञ्च पूपा द्वौ मत्स्यौ च विद्यन्ते, अतएव स्थानान्तरम् इत्वा निमित्तमेतेषां भक्ष्यद्रव्येषु न क्रीतेषु न भवति। ");
INSERT INTO sandev_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","तत्र प्रायेण पञ्चसहस्राणि पुरुषा आसन्। ");
INSERT INTO sandev_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","तदा स शिष्यान् जगाद पञ्चाशत् पञ्चाशज्जनैः पंक्तीकृत्य तानुपवेशयत, तस्मात् ते तदनुसारेण सर्व्वलोकानुपवेशयापासुः। ");
INSERT INTO sandev_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ततः स तान् पञ्च पूपान् मीनद्वयञ्च गृहीत्वा स्वर्गं विलोक्येश्वरगुणान् कीर्त्तयाञ्चक्रे भङ्क्ता च लोकेभ्यः परिवेषणार्थं शिष्येषु समर्पयाम्बभूव। ");
INSERT INTO sandev_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ततः सर्व्वे भुक्त्वा तृप्तिं गता अवशिष्टानाञ्च द्वादश डल्लकान् संजगृहुः। ");
INSERT INTO sandev_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","अथैकदा निर्जने शिष्यैः सह प्रार्थनाकाले तान् पप्रच्छ, लोका मां कं वदन्ति? ");
INSERT INTO sandev_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","ततस्ते प्राचुः, त्वां योहन्मज्जकं वदन्ति; केचित् त्वाम् एलियं वदन्ति, पूर्व्वकालिकः कश्चिद् भविष्यद्वादी श्मशानाद् उदतिष्ठद् इत्यपि केचिद् वदन्ति। ");
INSERT INTO sandev_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","तदा स उवाच, यूयं मां कं वदथ? ततः पितर उक्तवान् त्वम् ईश्वराभिषिक्तः पुरुषः। ");
INSERT INTO sandev_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","तदा स तान् दृढमादिदेश, कथामेतां कस्मैचिदपि मा कथयत। ");
INSERT INTO sandev_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","स पुनरुवाच, मनुष्यपुत्रेण वहुयातना भोक्तव्याः प्राचीनलोकैः प्रधानयाजकैरध्यापकैश्च सोवज्ञाय हन्तव्यः किन्तु तृतीयदिवसे श्मशानात् तेनोत्थातव्यम्। ");
INSERT INTO sandev_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","अपरं स सर्व्वानुवाच, कश्चिद् यदि मम पश्चाद् गन्तुं वाञ्छति तर्हि स स्वं दाम्यतु, दिने दिने क्रुशं गृहीत्वा च मम पश्चादागच्छतु। ");
INSERT INTO sandev_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","यतो यः कश्चित् स्वप्राणान् रिरक्षिषति स तान् हारयिष्यति, यः कश्चिन् मदर्थं प्राणान् हारयिष्यति स तान् रक्षिष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","कश्चिद् यदि सर्व्वं जगत् प्राप्नोति किन्तु स्वप्राणान् हारयति स्वयं विनश्यति च तर्हि तस्य को लाभः? ");
INSERT INTO sandev_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","पुन र्यः कश्चिन् मां मम वाक्यं वा लज्जास्पदं जानाति मनुष्यपुत्रो यदा स्वस्य पितुश्च पवित्राणां दूतानाञ्च तेजोभिः परिवेष्टित आगमिष्यति तदा सोपि तं लज्जास्पदं ज्ञास्यति। ");
INSERT INTO sandev_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","किन्तु युष्मानहं यथार्थं वदामि, ईश्वरीयराजत्वं न दृष्टवा मृत्युं नास्वादिष्यन्ते, एतादृशाः कियन्तो लोका अत्र स्थनेऽपि दण्डायमानाः सन्ति। ");
INSERT INTO sandev_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","एतदाख्यानकथनात् परं प्रायेणाष्टसु दिनेषु गतेषु स पितरं योहनं याकूबञ्च गृहीत्वा प्रार्थयितुं पर्व्वतमेकं समारुरोह। ");
INSERT INTO sandev_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","अथ तस्य प्रार्थनकाले तस्य मुखाकृतिरन्यरूपा जाता, तदीयं वस्त्रमुज्ज्वलशुक्लं जातं। ");
INSERT INTO sandev_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","अपरञ्च मूसा एलियश्चोभौ तेजस्विनौ दृष्टौ ");
INSERT INTO sandev_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","तौ तेन यिरूशालम्पुरे यो मृत्युः साधिष्यते तदीयां कथां तेन सार्द्धं कथयितुम् आरेभाते। ");
INSERT INTO sandev_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","तदा पितरादयः स्वस्य सङ्गिनो निद्रयाकृष्टा आसन् किन्तु जागरित्वा तस्य तेजस्तेन सार्द्धम् उत्तिष्ठन्तौ जनौ च ददृशुः। ");
INSERT INTO sandev_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","अथ तयोरुभयो र्गमनकाले पितरो यीशुं बभाषे, हे गुरोऽस्माकं स्थानेऽस्मिन् स्थितिः शुभा, तत एका त्वदर्था, एका मूसार्था, एका एलियार्था, इति तिस्रः कुट्योस्माभि र्निर्म्मीयन्तां, इमां कथां स न विविच्य कथयामास। ");
INSERT INTO sandev_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","अपरञ्च तद्वाक्यवदनकाले पयोद एक आगत्य तेषामुपरि छायां चकार, ततस्तन्मध्ये तयोः प्रवेशात् ते शशङ्किरे। ");
INSERT INTO sandev_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","तदा तस्मात् पयोदाद् इयमाकाशीया वाणी निर्जगाम, ममायं प्रियः पुत्र एतस्य कथायां मनो निधत्त। ");
INSERT INTO sandev_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","इति शब्दे जाते ते यीशुमेकाकिनं ददृशुः किन्तु ते तदानीं तस्य दर्शनस्य वाचमेकामपि नोक्त्वा मनःसु स्थापयामासुः। ");
INSERT INTO sandev_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","परेऽहनि तेषु तस्माच्छैलाद् अवरूढेषु तं साक्षात् कर्त्तुं बहवो लोका आजग्मुः। ");
INSERT INTO sandev_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","तेषां मध्याद् एको जन उच्चैरुवाच, हे गुरो अहं विनयं करोमि मम पुत्रं प्रति कृपादृष्टिं करोतु, मम स एवैकः पुत्रः। ");
INSERT INTO sandev_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","भूतेन धृतः सन् सं प्रसभं चीच्छब्दं करोति तन्मुखात् फेणा निर्गच्छन्ति च, भूत इत्थं विदार्य्य क्लिष्ट्वा प्रायशस्तं न त्यजति। ");
INSERT INTO sandev_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","तस्मात् तं भूतं त्याजयितुं तव शिष्यसमीपे न्यवेदयं किन्तु ते न शेकुः। ");
INSERT INTO sandev_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","तदा यीशुरवादीत्, रे आविश्वासिन् विपथगामिन् वंश कतिकालान् युष्माभिः सह स्थास्याम्यहं युष्माकम् आचरणानि च सहिष्ये? तव पुत्रमिहानय। ");
INSERT INTO sandev_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ततस्तस्मिन्नागतमात्रे भूतस्तं भूमौ पातयित्वा विददार; तदा यीशुस्तममेध्यं भूतं तर्जयित्वा बालकं स्वस्थं कृत्वा तस्य पितरि समर्पयामास। ");
INSERT INTO sandev_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ईश्वरस्य महाशक्तिम् इमां विलोक्य सर्व्वे चमच्चक्रुः; इत्थं यीशोः सर्व्वाभिः क्रियाभिः सर्व्वैर्लोकैराश्चर्य्ये मन्यमाने सति स शिष्यान् बभाषे, ");
INSERT INTO sandev_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","कथेयं युष्माकं कर्णेषु प्रविशतु, मनुष्यपुत्रो मनुष्याणां करेषु समर्पयिष्यते। ");
INSERT INTO sandev_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","किन्तु ते तां कथां न बुबुधिरे, स्पष्टत्वाभावात् तस्या अभिप्रायस्तेषां बोधगम्यो न बभूव; तस्या आशयः क इत्यपि ते भयात् प्रष्टुं न शेकुः। ");
INSERT INTO sandev_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","तदनन्तरं तेषां मध्ये कः श्रेष्ठः कथामेतां गृहीत्वा ते मिथो विवादं चक्रुः। ");
INSERT INTO sandev_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ततो यीशुस्तेषां मनोभिप्रायं विदित्वा बालकमेकं गृहीत्वा स्वस्य निकटे स्थापयित्वा तान् जगाद, ");
INSERT INTO sandev_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","यो जनो मम नाम्नास्य बालास्यातिथ्यं विदधाति स ममातिथ्यं विदधाति, यश्च ममातिथ्यं विदधाति स मम प्रेरकस्यातिथ्यं विदधाति, युष्माकं मध्येयः स्वं सर्व्वस्मात् क्षुद्रं जानीते स एव श्रेष्ठो भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","अपरञ्च योहन् व्याजहार हे प्रभेा तव नाम्ना भूतान् त्याजयन्तं मानुषम् एकं दृष्टवन्तो वयं, किन्त्वस्माकम् अपश्चाद् गामित्वात् तं न्यषेधाम्। तदानीं यीशुरुवाच, ");
INSERT INTO sandev_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","तं मा निषेधत, यतो यो जनोस्माकं न विपक्षः स एवास्माकं सपक्षो भवति। ");
INSERT INTO sandev_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","अनन्तरं तस्यारोहणसमय उपस्थिते स स्थिरचेता यिरूशालमं प्रति यात्रां कर्त्तुं निश्चित्याग्रे दूतान् प्रेषयामास। ");
INSERT INTO sandev_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","तस्मात् ते गत्वा तस्य प्रयोजनीयद्रव्याणि संग्रहीतुं शोमिरोणीयानां ग्रामं प्रविविशुः। ");
INSERT INTO sandev_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","किन्तु स यिरूशालमं नगरं याति ततो हेतो र्लोकास्तस्यातिथ्यं न चक्रुः। ");
INSERT INTO sandev_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","अतएव याकूब्योहनौ तस्य शिष्यौ तद् दृष्ट्वा जगदतुः, हे प्रभो एलियो यथा चकार तथा वयमपि किं गगणाद् आगन्तुम् एतान् भस्मीकर्त्तुञ्च वह्निमाज्ञापयामः? भवान् किमिच्छति? ");
INSERT INTO sandev_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","किन्तु स मुखं परावर्त्य तान् तर्जयित्वा गदितवान् युष्माकं मनोभावः कः, इति यूयं न जानीथ। ");
INSERT INTO sandev_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","मनुजसुतो मनुजानां प्राणान् नाशयितुं नागच्छत्, किन्तु रक्षितुम् आगच्छत्। पश्चाद् इतरग्रामं ते ययुः। ");
INSERT INTO sandev_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","तदनन्तरं पथि गमनकाले जन एकस्तं बभाषे, हे प्रभो भवान् यत्र याति भवता सहाहमपि तत्र यास्यामि। ");
INSERT INTO sandev_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","तदानीं यीशुस्तमुवाच, गोमायूनां गर्त्ता आसते, विहायसीयविहगाानां नीडानि च सन्ति, किन्तु मानवतनयस्य शिरः स्थापयितुं स्थानं नास्ति। ");
INSERT INTO sandev_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ततः परं स इतरजनं जगाद, त्वं मम पश्चाद् एहि; ततः स उवाच, हे प्रभो पूर्व्वं पितरं श्मशाने स्थापयितुं मामादिशतु। ");
INSERT INTO sandev_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","तदा यीशुरुवाच, मृता मृतान् श्मशाने स्थापयन्तु किन्तु त्वं गत्वेश्वरीयराज्यस्य कथां प्रचारय। ");
INSERT INTO sandev_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ततोन्यः कथयामास, हे प्रभो मयापि भवतः पश्चाद् गंस्यते, किन्तु पूर्व्वं मम निवेशनस्य परिजनानाम् अनुमतिं ग्रहीतुम् अहमादिश्यै भवता। ");
INSERT INTO sandev_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","तदानीं यीशुस्तं प्रोक्तवान्, यो जनो लाङ्गले करमर्पयित्वा पश्चात् पश्यति स ईश्वरीयराज्यं नार्हति। ");
INSERT INTO sandev_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ततः परं प्रभुरपरान् सप्ततिशिष्यान् नियुज्य स्वयं यानि नगराणि यानि स्थानानि च गमिष्यति तानि नगराणि तानि स्थानानि च प्रति द्वौ द्वौ जनौ प्रहितवान्। ");
INSERT INTO sandev_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","तेभ्यः कथयामास च शस्यानि बहूनीति सत्यं किन्तु छेदका अल्पे; तस्माद्धेतोः शस्यक्षेत्रे छेदकान् अपरानपि प्रेषयितुं क्षेत्रस्वामिनं प्रार्थयध्वं। ");
INSERT INTO sandev_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","यूयं यात, पश्यत, वृकाणां मध्ये मेषशावकानिव युष्मान् प्रहिणोमि। ");
INSERT INTO sandev_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","यूयं क्षुद्रं महद् वा वसनसम्पुटकं पादुकाश्च मा गृह्लीत, मार्गमध्ये कमपि मा नमत च। ");
INSERT INTO sandev_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","अपरञ्च यूयं यद् यत् निवेशनं प्रविशथ तत्र निवेशनस्यास्य मङ्गलं भूयादिति वाक्यं प्रथमं वदत। ");
INSERT INTO sandev_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","तस्मात् तस्मिन् निवेशने यदि मङ्गलपात्रं स्थास्यति तर्हि तन्मङ्गलं तस्य भविष्यति, नोचेत् युष्मान् प्रति परावर्त्तिष्यते। ");
INSERT INTO sandev_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","अपरञ्च ते यत्किञ्चिद् दास्यन्ति तदेव भुक्त्वा पीत्वा तस्मिन्निवेशने स्थास्यथ; यतः कर्म्मकारी जनो भृतिम् अर्हति; गृहाद् गृहं मा यास्यथ। ");
INSERT INTO sandev_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","अन्यच्च युष्मासु किमपि नगरं प्रविष्टेषु लोका यदि युष्माकम् आतिथ्यं करिष्यन्ति, तर्हि यत् खाद्यम् उपस्थास्यन्ति तदेव खादिष्यथ। ");
INSERT INTO sandev_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","तन्नगरस्थान् रोगिणः स्वस्थान् करिष्यथ, ईश्वरीयं राज्यं युष्माकम् अन्तिकम् आगमत् कथामेताञ्च प्रचारयिष्यथ। ");
INSERT INTO sandev_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","किन्तु किमपि पुरं युष्मासु प्रविष्टेषु लोका यदि युष्माकम् आतिथ्यं न करिष्यन्ति, तर्हि तस्य नगरस्य पन्थानं गत्वा कथामेतां वदिष्यथ, ");
INSERT INTO sandev_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","युष्माकं नगरीया या धूल्योऽस्मासु समलगन् ता अपि युष्माकं प्रातिकूल्येन साक्ष्यार्थं सम्पातयामः; तथापीश्वरराज्यं युष्माकं समीपम् आगतम् इति निश्चितं जानीत। ");
INSERT INTO sandev_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","अहं युष्मभ्यं यथार्थं कथयामि, विचारदिने तस्य नगरस्य दशातः सिदोमो दशा सह्या भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","हा हा कोरासीन् नगर, हा हा बैत्सैदानगर युवयोर्मध्ये यादृशानि आश्चर्य्याणि कर्म्माण्यक्रियन्त, तानि कर्म्माणि यदि सोरसीदोनो र्नगरयोरकारिष्यन्त, तदा इतो बहुदिनपूर्व्वं तन्निवासिनः शणवस्त्राणि परिधाय गात्रेषु भस्म विलिप्य समुपविश्य समखेत्स्यन्त। ");
INSERT INTO sandev_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","अतो विचारदिवसे युष्माकं दशातः सोरसीदोन्निवासिनां दशा सह्या भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","हे कफर्नाहूम्, त्वं स्वर्गं यावद् उन्नता किन्तु नरकं यावत् न्यग्भविष्यसि। ");
INSERT INTO sandev_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","यो जनो युष्माकं वाक्यं गृह्लाति स ममैव वाक्यं गृह्लाति; किञ्च यो जनो युष्माकम् अवज्ञां करोति स ममैवावज्ञां करोति; यो जनो ममावज्ञां करोति च स मत्प्रेरकस्यैवावज्ञां करोति। ");
INSERT INTO sandev_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","अथ ते सप्ततिशिष्या आनन्देन प्रत्यागत्य कथयामासुः, हे प्रभो भवतो नाम्ना भूता अप्यस्माकं वशीभवन्ति। ");
INSERT INTO sandev_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","तदानीं स तान् जगाद, विद्युतमिव स्वर्गात् पतन्तं शैतानम् अदर्शम्। ");
INSERT INTO sandev_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","पश्यत सर्पान् वृश्चिकान् रिपोः सर्व्वपराक्रमांश्च पदतलै र्दलयितुं युष्मभ्यं शक्तिं ददामि तस्माद् युष्माकं कापि हानि र्न भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","भूता युष्माकं वशीभवन्ति, एतन्निमित्तत् मा समुल्लसत, स्वर्गे युष्माकं नामानि लिखितानि सन्तीति निमित्तं समुल्लसत। ");
INSERT INTO sandev_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","तद्घटिकायां यीशु र्मनसि जाताह्लादः कथयामास हे स्वर्गपृथिव्योरेकाधिपते पितस्त्वं ज्ञानवतां विदुषाञ्च लोकानां पुरस्तात् सर्व्वमेतद् अप्रकाश्य बालकानां पुरस्तात् प्राकाशय एतस्माद्धेतोस्त्वां धन्यं वदामि, हे पितरित्थं भवतु यद् एतदेव तव गोचर उत्तमम्। ");
INSERT INTO sandev_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","पित्रा सर्व्वाणि मयि समर्पितानि पितरं विना कोपि पुत्रं न जानाति किञ्च पुत्रं विना यस्मै जनाय पुत्रस्तं प्रकाशितवान् तञ्च विना कोपि पितरं न जानाति। ");
INSERT INTO sandev_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","तपः परं स शिष्यान् प्रति परावृत्य गुप्तं जगाद, यूयमेतानि सर्व्वाणि पश्यथ ततो युष्माकं चक्षूंषि धन्यानि। ");
INSERT INTO sandev_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","युष्मानहं वदामि, यूयं यानि सर्व्वाणि पश्यथ तानि बहवो भविष्यद्वादिनो भूपतयश्च द्रष्टुमिच्छन्तोपि द्रष्टुं न प्राप्नुवन्, युष्माभि र्या याः कथाश्च श्रूयन्ते ताः श्रोतुमिच्छन्तोपि श्रोतुं नालभन्त। ");
INSERT INTO sandev_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","अनन्तरम् एको व्यवस्थापक उत्थाय तं परीक्षितुं पप्रच्छ, हे उपदेशक अनन्तायुषः प्राप्तये मया किं करणीयं? ");
INSERT INTO sandev_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","यीशुः प्रत्युवाच, अत्रार्थे व्यवस्थायां किं लिखितमस्ति? त्वं कीदृक् पठसि? ");
INSERT INTO sandev_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ततः सोवदत्, त्वं सर्व्वान्तःकरणैः सर्व्वप्राणैः सर्व्वशक्तिभिः सर्व्वचित्तैश्च प्रभौ परमेश्वरे प्रेम कुरु, समीपवासिनि स्ववत् प्रेम कुरु च। ");
INSERT INTO sandev_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","तदा स कथयामास, त्वं यथार्थं प्रत्यवोचः, इत्थम् आचर तेनैव जीविष्यसि। ");
INSERT INTO sandev_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","किन्तु स जनः स्वं निर्द्दोषं ज्ञापयितुं यीशुं पप्रच्छ, मम समीपवासी कः? ततो यीशुः प्रत्युवाच, ");
INSERT INTO sandev_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","एको जनो यिरूशालम्पुराद् यिरीहोपुरं याति, एतर्हि दस्यूनां करेषु पतिते ते तस्य वस्त्रादिकं हृतवन्तः तमाहत्य मृतप्रायं कृत्वा त्यक्त्वा ययुः। ");
INSERT INTO sandev_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","अकस्माद् एको याजकस्तेन मार्गेण गच्छन् तं दृष्ट्वा मार्गान्यपार्श्वेन जगाम। ");
INSERT INTO sandev_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","इत्थम् एको लेवीयस्तत्स्थानं प्राप्य तस्यान्तिकं गत्वा तं विलोक्यान्येन पार्श्वेन जगाम। ");
INSERT INTO sandev_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","किन्त्वेकः शोमिरोणीयो गच्छन् तत्स्थानं प्राप्य तं दृष्ट्वादयत। ");
INSERT INTO sandev_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","तस्यान्तिकं गत्वा तस्य क्षतेषु तैलं द्राक्षारसञ्च प्रक्षिप्य क्षतानि बद्ध्वा निजवाहनोपरि तमुपवेश्य प्रवासीयगृहम् आनीय तं सिषेवे। ");
INSERT INTO sandev_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","परस्मिन् दिवसे निजगमनकाले द्वौ मुद्रापादौ तद्गृहस्वामिने दत्त्वावदत् जनमेनं सेवस्व तत्र योऽधिको व्ययो भविष्यति तमहं पुनरागमनकाले परिशोत्स्यामि। ");
INSERT INTO sandev_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","एषां त्रयाणां मध्ये तस्य दस्युहस्तपतितस्य जनस्य समीपवासी कः? त्वया किं बुध्यते? ");
INSERT INTO sandev_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ततः स व्यवस्थापकः कथयामास यस्तस्मिन् दयां चकार। तदा यीशुः कथयामास त्वमपि गत्वा तथाचर। ");
INSERT INTO sandev_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","ततः परं ते गच्छन्त एकं ग्रामं प्रविविशुः; तदा मर्थानामा स्त्री स्वगृहे तस्यातिथ्यं चकार। ");
INSERT INTO sandev_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","तस्मात् मरियम् नामधेया तस्या भगिनी यीशोः पदसमीप उवविश्य तस्योपदेशकथां श्रोतुमारेभे। ");
INSERT INTO sandev_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","किन्तु मर्था नानापरिचर्य्यायां व्यग्रा बभूव तस्माद्धेतोस्तस्य समीपमागत्य बभाषे; हे प्रभो मम भगिनी केवलं ममोपरि सर्व्वकर्म्मणां भारम् अर्पितवती तत्र भवता किञ्चिदपि न मनो निधीयते किम्? मम साहाय्यं कर्त्तुं भवान् तामादिशतु। ");
INSERT INTO sandev_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ततो यीशुः प्रत्युवाच हे मर्थे हे मर्थे, त्वं नानाकार्य्येषु चिन्तितवती व्यग्रा चासि, ");
INSERT INTO sandev_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","किन्तु प्रयोजनीयम् एकमात्रम् आस्ते। अपरञ्च यमुत्तमं भागं कोपि हर्त्तुं न शक्नोति सएव मरियमा वृतः। ");
INSERT INTO sandev_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","अनन्तरं स कस्मिंश्चित् स्थाने प्रार्थयत तत्समाप्तौ सत्यां तस्यैकः शिष्यस्तं जगाद हे प्रभो योहन् यथा स्वशिष्यान् प्रार्थयितुम् उपदिष्टवान् तथा भवानप्यस्मान् उपदिशतु। ");
INSERT INTO sandev_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","तस्मात् स कथयामास, प्रार्थनकाले यूयम् इत्थं कथयध्वं, हे अस्माकं स्वर्गस्थपितस्तव नाम पूज्यं भवतु; तव राजत्वं भवतु; स्वर्गे यथा तथा पृथिव्यामपि तवेच्छया सर्व्वं भवतु। ");
INSERT INTO sandev_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","प्रत्यहम् अस्माकं प्रयोजनीयं भोज्यं देहि। ");
INSERT INTO sandev_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","यथा वयं सर्व्वान् अपराधिनः क्षमामहे तथा त्वमपि पापान्यस्माकं क्षमस्व। अस्मान् परीक्षां मानय किन्तु पापात्मनो रक्ष। ");
INSERT INTO sandev_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","पश्चात् सोपरमपि कथितवान् यदि युष्माकं कस्यचिद् बन्धुस्तिष्ठति निशीथे च तस्य समीपं स गत्वा वदति, ");
INSERT INTO sandev_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","हे बन्धो पथिक एको बन्धु र्मम निवेशनम् आयातः किन्तु तस्यातिथ्यं कर्त्तुं ममान्तिके किमपि नास्ति, अतएव पूपत्रयं मह्यम् ऋणं देहि; ");
INSERT INTO sandev_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","तदा स यदि गृहमध्यात् प्रतिवदति मां मा क्लिशान, इदानीं द्वारं रुद्धं शयने मया सह बालकाश्च तिष्ठन्ति तुभ्यं दातुम् उत्थातुं न शक्नोमि, ");
INSERT INTO sandev_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","तर्हि युष्मानहं वदामि, स यदि मित्रतया तस्मै किमपि दातुं नोत्तिष्ठति तथापि वारं वारं प्रार्थनात उत्थापितः सन् यस्मिन् तस्य प्रयोजनं तदेव दास्यति। ");
INSERT INTO sandev_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","अतः कारणात् कथयामि, याचध्वं ततो युष्मभ्यं दास्यते, मृगयध्वं तत उद्देशं प्राप्स्यथ, द्वारम् आहत ततो युष्मभ्यं द्वारं मोक्ष्यते। ");
INSERT INTO sandev_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","यो याचते स प्राप्नोति, यो मृगयते स एवोद्देशं प्राप्नोति, यो द्वारम् आहन्ति तदर्थं द्वारं मोच्यते। ");
INSERT INTO sandev_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","पुत्रेण पूपे याचिते तस्मै पाषाणं ददाति वा मत्स्ये याचिते तस्मै सर्पं ददाति ");
INSERT INTO sandev_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","वा अण्डे याचिते तस्मै वृश्चिकं ददाति युष्माकं मध्ये क एतादृशः पितास्ते? ");
INSERT INTO sandev_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","तस्मादेव यूयमभद्रा अपि यदि स्वस्वबालकेभ्य उत्तमानि द्रव्याणि दातुं जानीथ तर्ह्यस्माकं स्वर्गस्थः पिता निजयाचकेभ्यः किं पवित्रम् आत्मानं न दास्यति? ");
INSERT INTO sandev_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","अनन्तरं यीशुना कस्माच्चिद् एकस्मिन् मूकभूते त्याजिते सति स भूतत्यक्तो मानुषो वाक्यं वक्तुम् आरेभे; ततो लोकाः सकला आश्चर्य्यं मेनिरे। ");
INSERT INTO sandev_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","किन्तु तेषां केचिदूचु र्जनोयं बालसिबूबा अर्थाद् भूतराजेन भूतान् त्याजयति। ");
INSERT INTO sandev_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","तं परीक्षितुं केचिद् आकाशीयम् एकं चिह्नं दर्शयितुं तं प्रार्थयाञ्चक्रिरे। ");
INSERT INTO sandev_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","तदा स तेषां मनःकल्पनां ज्ञात्वा कथयामास, कस्यचिद् राज्यस्य लोका यदि परस्परं विरुन्धन्ति तर्हि तद् राज्यम् नश्यति; केचिद् गृहस्था यदि परस्परं विरुन्धन्ति तर्हि तेपि नश्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","तथैव शैतानपि स्वलोकान् यदि विरुणद्धि तदा तस्य राज्यं कथं स्थास्यति? बालसिबूबाहं भूतान् त्याजयामि यूयमिति वदथ। ");
INSERT INTO sandev_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","यद्यहं बालसिबूबा भूतान् त्याजयामि तर्हि युष्माकं सन्तानाः केन त्याजयन्ति? तस्मात् तएव कथाया एतस्या विचारयितारो भविष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","किन्तु यद्यहम् ईश्वरस्य पराक्रमेण भूतान् त्याजयामि तर्हि युष्माकं निकटम् ईश्वरस्य राज्यमवश्यम् उपतिष्ठति। ");
INSERT INTO sandev_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","बलवान् पुमान् सुसज्जमानो यतिकालं निजाट्टालिकां रक्षति ततिकालं तस्य द्रव्यं निरुपद्रवं तिष्ठति। ");
INSERT INTO sandev_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","किन्तु तस्माद् अधिकबलः कश्चिदागत्य यदि तं जयति तर्हि येषु शस्त्रास्त्रेषु तस्य विश्वास आसीत् तानि सर्व्वाणि हृत्वा तस्य द्रव्याणि गृह्लाति। ");
INSERT INTO sandev_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","अतः कारणाद् यो मम सपक्षो न स विपक्षः, यो मया सह न संगृह्लाति स विकिरति। ");
INSERT INTO sandev_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","अपरञ्च अमेध्यभूतो मानुषस्यान्तर्निर्गत्य शुष्कस्थाने भ्रान्त्वा विश्रामं मृगयते किन्तु न प्राप्य वदति मम यस्माद् गृहाद् आगतोहं पुनस्तद् गृहं परावृत्य यामि। ");
INSERT INTO sandev_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ततो गत्वा तद् गृहं मार्जितं शोभितञ्च दृष्ट्वा ");
INSERT INTO sandev_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","तत्क्षणम् अपगत्य स्वस्मादपि दुर्म्मतीन् अपरान् सप्तभूतान् सहानयति ते च तद्गृहं पविश्य निवसन्ति। तस्मात् तस्य मनुष्यस्य प्रथमदशातः शेषदशा दुःखतरा भवति। ");
INSERT INTO sandev_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","अस्याः कथायाः कथनकाले जनतामध्यस्था काचिन्नारी तमुच्चैःस्वरं प्रोवाच, या योषित् त्वां गर्ब्भेऽधारयत् स्तन्यमपाययच्च सैव धन्या। ");
INSERT INTO sandev_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","किन्तु सोकथयत् ये परमेश्वरस्य कथां श्रुत्वा तदनुरूपम् आचरन्ति तएव धन्याः। ");
INSERT INTO sandev_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","ततः परं तस्यान्तिके बहुलोकानां समागमे जाते स वक्तुमारेभे, आधुनिका दुष्टलोकाश्चिह्नं द्रष्टुमिच्छन्ति किन्तु यूनस्भविष्यद्वादिनश्चिह्नं विनान्यत् किञ्चिच्चिह्नं तान् न दर्शयिष्यते। ");
INSERT INTO sandev_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","यूनस् तु यथा नीनिवीयलोकानां समीपे चिह्नरूपोभवत् तथा विद्यमानलोकानाम् एषां समीपे मनुष्यपुत्रोपि चिह्नरूपो भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","विचारसमये इदानीन्तनलोकानां प्रातिकूल्येन दक्षिणदेशीया राज्ञी प्रोत्थाय तान् दोषिणः करिष्यति, यतः सा राज्ञी सुलेमान उपदेशकथां श्रोतुं पृथिव्याः सीमात आगच्छत् किन्तु पश्यत सुलेमानोपि गुरुतर एको जनोऽस्मिन् स्थाने विद्यते। ");
INSERT INTO sandev_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","अपरञ्च विचारसमये नीनिवीयलोका अपि वर्त्तमानकालिकानां लोकानां वैपरीत्येन प्रोत्थाय तान् दोषिणः करिष्यन्ति, यतो हेतोस्ते यूनसो वाक्यात् चित्तानि परिवर्त्तयामासुः किन्तु पश्यत यूनसोतिगुरुतर एको जनोऽस्मिन् स्थाने विद्यते। ");
INSERT INTO sandev_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","प्रदीपं प्रज्वाल्य द्रोणस्याधः कुत्रापि गुप्तस्थाने वा कोपि न स्थापयति किन्तु गृहप्रवेशिभ्यो दीप्तिं दातं दीपाधारोपर्य्येव स्थापयति। ");
INSERT INTO sandev_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","देहस्य प्रदीपश्चक्षुस्तस्मादेव चक्षु र्यदि प्रसन्नं भवति तर्हि तव सर्व्वशरीरं दीप्तिमद् भविष्यति किन्तु चक्षु र्यदि मलीमसं तिष्ठति तर्हि सर्व्वशरीरं सान्धकारं स्थास्यति। ");
INSERT INTO sandev_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","अस्मात् कारणात् तवान्तःस्थं ज्योति र्यथान्धकारमयं न भवति तदर्थे सावधानो भव। ");
INSERT INTO sandev_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","यतः शरीरस्य कुत्राप्यंशे सान्धकारे न जाते सर्व्वं यदि दीप्तिमत् तिष्ठति तर्हि तुभ्यं दीप्तिदायिप्रोज्ज्वलन् प्रदीप इव तव सवर्वशरीरं दीप्तिमद् भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","एतत्कथायाः कथनकाले फिरुश्येको भेजनाय तं निमन्त्रयामास, ततः स गत्वा भोक्तुम् उपविवेश। ");
INSERT INTO sandev_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","किन्तु भोजनात् पूर्व्वं नामाङ्क्षीत् एतद् दृष्ट्वा स फिरुश्याश्चर्य्यं मेने। ");
INSERT INTO sandev_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","तदा प्रभुस्तं प्रोवाच यूयं फिरूशिलोकाः पानपात्राणां भोजनपात्राणाञ्च बहिः परिष्कुरुथ किन्तु युष्माकमन्त र्दौरात्म्यै र्दुष्क्रियाभिश्च परिपूर्णं तिष्ठति। ");
INSERT INTO sandev_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","हे सर्व्वे निर्बोधा यो बहिः ससर्ज स एव किमन्त र्न ससर्ज? ");
INSERT INTO sandev_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","तत एव युष्माभिरन्तःकरणं (ईश्वराय) निवेद्यतां तस्मिन् कृते युष्माकं सर्व्वाणि शुचितां यास्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","किन्तु हन्त फिरूशिगणा यूयं न्यायम् ईश्वरे प्रेम च परित्यज्य पोदिनाया अरुदादीनां सर्व्वेषां शाकानाञ्च दशमांशान् दत्थ किन्तु प्रथमं पालयित्वा शेषस्यालङ्घनं युष्माकम् उचितमासीत्। ");
INSERT INTO sandev_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","हा हा फिरूशिनो यूयं भजनगेहे प्रोच्चासने आपणेषु च नमस्कारेषु प्रीयध्वे। ");
INSERT INTO sandev_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","वत कपटिनोऽध्यापकाः फिरूशिनश्च लोकायत् श्मशानम् अनुपलभ्य तदुपरि गच्छन्ति यूयम् तादृगप्रकाशितश्मशानवाद् भवथ। ");
INSERT INTO sandev_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","तदानीं व्यवस्थापकानाम् एका यीशुमवदत्, हे उपदेशक वाक्येनेदृशेनास्मास्वपि दोषम् आरोपयसि। ");
INSERT INTO sandev_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ततः स उवाच, हा हा व्यवस्थापका यूयम् मानुषाणाम् उपरि दुःसह्यान् भारान् न्यस्यथ किन्तु स्वयम् एकाङ्गुुल्यापि तान् भारान् न स्पृशथ। ");
INSERT INTO sandev_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","हन्त युष्माकं पूर्व्वपुरुषा यान् भविष्यद्वादिनोऽवधिषुस्तेषां श्मशानानि यूयं निर्म्माथ। ");
INSERT INTO sandev_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","तेनैव यूयं स्वपूर्व्वपुरुषाणां कर्म्माणि संमन्यध्वे तदेव सप्रमाणं कुरुथ च, यतस्ते तानवधिषुः यूयं तेषां श्मशानानि निर्म्माथ। ");
INSERT INTO sandev_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","अतएव ईश्वरस्य शास्त्रे प्रोक्तमस्ति तेषामन्तिके भविष्यद्वादिनः प्रेरितांश्च प्रेषयिष्यामि ततस्ते तेषां कांश्चन हनिष्यन्ति कांश्चन ताडश्ष्यिन्ति। ");
INSERT INTO sandev_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","एतस्मात् कारणात् हाबिलः शोणितपातमारभ्य मन्दिरयज्ञवेद्यो र्मध्ये हतस्य सिखरियस्य रक्तपातपर्य्यन्तं ");
INSERT INTO sandev_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","जगतः सृष्टिमारभ्य पृथिव्यां भविष्यद्वादिनां यतिरक्तपाता जातास्ततीनाम् अपराधदण्डा एषां वर्त्तमानलोकानां भविष्यन्ति, युष्मानहं निश्चितं वदामि सर्व्वे दण्डा वंशस्यास्य भविष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","हा हा व्यवस्थपका यूयं ज्ञानस्य कुञ्चिकां हृत्वा स्वयं न प्रविष्टा ये प्रवेष्टुञ्च प्रयासिनस्तानपि प्रवेष्टुं वारितवन्तः। ");
INSERT INTO sandev_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","इत्थं कथाकथनाद् अध्यापकाः फिरूशिनश्च सतर्काः ");
INSERT INTO sandev_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","सन्तस्तमपवदितुं तस्य कथाया दोषं धर्त्तमिच्छन्तो नानाख्यानकथनाय तं प्रवर्त्तयितुं कोपयितुञ्च प्रारेभिरे। ");
INSERT INTO sandev_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","तदानीं लोकाः सहस्रं सहस्रम् आगत्य समुपस्थितास्तत एकैको ऽन्येषामुपरि पतितुम् उपचक्रमे; तदा यीशुः शिष्यान् बभाषे, यूयं फिरूशिनां किण्वरूपकापट्ये विशेषेण सावधानास्तिष्ठत। ");
INSERT INTO sandev_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","यतो यन्न प्रकाशयिष्यते तदाच्छन्नं वस्तु किमपि नास्ति; तथा यन्न ज्ञास्यते तद् गुप्तं वस्तु किमपि नास्ति। ");
INSERT INTO sandev_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","अन्धकारे तिष्ठनतो याः कथा अकथयत ताः सर्व्वाः कथा दीप्तौ श्रोष्यन्ते निर्जने कर्णे च यदकथयत गृहपृष्ठात् तत् प्रचारयिष्यते। ");
INSERT INTO sandev_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","हे बन्धवो युष्मानहं वदामि, ये शरीरस्य नाशं विना किमप्यपरं कर्त्तुं न शक्रुवन्ति तेभ्यो मा भैष्ट। ");
INSERT INTO sandev_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","तर्हि कस्माद् भेतव्यम् इत्यहं वदामि, यः शरीरं नाशयित्वा नरकं निक्षेप्तुं शक्नोति तस्मादेव भयं कुरुत, पुनरपि वदामि तस्मादेव भयं कुरुत। ");
INSERT INTO sandev_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","पञ्च चटकपक्षिणः किं द्वाभ्यां ताम्रखण्डाभ्यां न विक्रीयन्ते? तथापीश्वरस्तेषाम् एकमपि न विस्मरति। ");
INSERT INTO sandev_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","युष्माकं शिरःकेशा अपि गणिताः सन्ति तस्मात् मा विभीत बहुचटकपक्षिभ्योपि यूयं बहुमूल्याः। ");
INSERT INTO sandev_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","अपरं युष्मभ्यं कथयामि यः कश्चिन् मानुषाणां साक्षान् मां स्वीकरोति मनुष्यपुत्र ईश्वरदूतानां साक्षात् तं स्वीकरिष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","किन्तु यः कश्चिन्मानुषाणां साक्षान्माम् अस्वीकरोति तम् ईश्वरस्य दूतानां साक्षाद् अहम् अस्वीकरिष्यामि। ");
INSERT INTO sandev_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","अन्यच्च यः कश्चिन् मनुजसुतस्य निन्दाभावेन काञ्चित् कथां कथयति तस्य तत्पापस्य मोचनं भविष्यति किन्तु यदि कश्चित् पवित्रम् आत्मानं निन्दति तर्हि तस्य तत्पापस्य मोचनं न भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","यदा लोका युष्मान् भजनगेहं विचारकर्तृराज्यकर्तृणां सम्मुखञ्च नेष्यन्ति तदा केन प्रकारेण किमुत्तरं वदिष्यथ किं कथयिष्यथ चेत्यत्र मा चिन्तयत; ");
INSERT INTO sandev_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","यतो युष्माभिर्यद् यद् वक्तव्यं तत् तस्मिन् समयएव पवित्र आत्मा युष्मान् शिक्षयिष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ततः परं जनतामध्यस्थः कश्चिज्जनस्तं जगाद हे गुरो मया सह पैतृकं धनं विभक्तुं मम भ्रातरमाज्ञापयतु भवान्। ");
INSERT INTO sandev_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","किन्तु स तमवदत् हे मनुष्य युवयो र्विचारं विभागञ्च कर्त्तुं मां को नियुक्तवान्? ");
INSERT INTO sandev_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","अनन्तरं स लोकानवदत् लोभे सावधानाः सतर्काश्च तिष्ठत, यतो बहुसम्पत्तिप्राप्त्या मनुष्यस्यायु र्न भवति। ");
INSERT INTO sandev_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","पश्चाद् दृष्टान्तकथामुत्थाप्य कथयामास, एकस्य धनिनो भूमौ बहूनि शस्यानि जातानि। ");
INSERT INTO sandev_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ततः स मनसा चिन्तयित्वा कथयाम्बभूव ममैतानि समुत्पन्नानि द्रव्याणि स्थापयितुं स्थानं नास्ति किं करिष्यामि? ");
INSERT INTO sandev_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ततोवदद् इत्थं करिष्यामि, मम सर्व्वभाण्डागाराणि भङ्क्त्वा बृहद्भाण्डागाराणि निर्म्माय तन्मध्ये सर्व्वफलानि द्रव्याणि च स्थापयिष्यामि। ");
INSERT INTO sandev_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","अपरं निजमनो वदिष्यामि, हे मनो बहुवत्सरार्थं नानाद्रव्याणि सञ्चितानि सन्ति विश्रामं कुरु भुक्त्वा पीत्वा कौतुकञ्च कुरु। किन्त्वीश्वरस्तम् अवदत्, ");
INSERT INTO sandev_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","रे निर्बोध अद्य रात्रौ तव प्राणास्त्वत्तो नेष्यन्ते तत एतानि यानि द्रव्याणि त्वयासादितानि तानि कस्य भविष्यन्ति? ");
INSERT INTO sandev_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","अतएव यः कश्चिद् ईश्वरस्य समीपे धनसञ्चयमकृत्वा केवलं स्वनिकटे सञ्चयं करोति सोपि तादृशः। ");
INSERT INTO sandev_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","अथ स शिष्येभ्यः कथयामास, युष्मानहं वदामि, किं खादिष्यामः? किं परिधास्यामः? इत्युक्त्वा जीवनस्य शरीरस्य चार्थं चिन्तां मा कार्ष्ट। ");
INSERT INTO sandev_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","भक्ष्याज्जीवनं भूषणाच्छरीरञ्च श्रेष्ठं भवति। ");
INSERT INTO sandev_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","काकपक्षिणां कार्य्यं विचारयत, ते न वपन्ति शस्यानि च न छिन्दन्ति, तेषां भाण्डागाराणि न सन्ति कोषाश्च न सन्ति, तथापीश्वरस्तेभ्यो भक्ष्याणि ददाति, यूयं पक्षिभ्यः श्रेष्ठतरा न किं? ");
INSERT INTO sandev_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","अपरञ्च भावयित्वा निजायुषः क्षणमात्रं वर्द्धयितुं शक्नोति, एतादृशो लाको युष्माकं मध्ये कोस्ति? ");
INSERT INTO sandev_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","अतएव क्षुद्रं कार्य्यं साधयितुम् असमर्था यूयम् अन्यस्मिन् कार्य्ये कुतो भावयथ? ");
INSERT INTO sandev_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","अन्यच्च काम्पिलपुष्पं कथं वर्द्धते तदापि विचारयत, तत् कञ्चन श्रमं न करोति तन्तूंश्च न जनयति किन्तु युष्मभ्यं यथार्थं कथयामि सुलेमान् बह्वैश्वर्य्यान्वितोपि पुष्पस्यास्य सदृशो विभूषितो नासीत्। ");
INSERT INTO sandev_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","अद्य क्षेत्रे वर्त्तमानं श्वश्चूल्ल्यां क्षेप्स्यमानं यत् तृणं, तस्मै यदीश्वर इत्थं भूषयति तर्हि हे अल्पप्रत्ययिनो युष्मान किं न परिधापयिष्यति? ");
INSERT INTO sandev_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","अतएव किं खादिष्यामः? किं परिधास्यामः? एतदर्थं मा चेष्टध्वं मा संदिग्ध्वञ्च। ");
INSERT INTO sandev_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","जगतो देवार्च्चका एतानि सर्व्वाणि चेष्टनते; एषु वस्तुषु युष्माकं प्रयोजनमास्ते इति युष्माकं पिता जानाति। ");
INSERT INTO sandev_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","अतएवेश्वरस्य राज्यार्थं सचेष्टा भवत तथा कृते सर्व्वाण्येतानि द्रव्याणि युष्मभ्यं प्रदायिष्यन्ते। ");
INSERT INTO sandev_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","हे क्षुद्रमेषव्रज यूयं मा भैष्ट युष्मभ्यं राज्यं दातुं युष्माकं पितुः सम्मतिरस्ति। ");
INSERT INTO sandev_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","अतएव युष्माकं या या सम्पत्तिरस्ति तां तां विक्रीय वितरत, यत् स्थानं चौरा नागच्छन्ति, कीटाश्च न क्षाययन्ति तादृशे स्वर्गे निजार्थम् अजरे सम्पुटके ऽक्षयं धनं सञ्चिनुत च; ");
INSERT INTO sandev_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","यतो यत्र युष्माकं धनं वर्त्तते तत्रेव युष्माकं मनः। ");
INSERT INTO sandev_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","अपरञ्च यूयं प्रदीपं ज्वालयित्वा बद्धकटयस्तिष्ठत; ");
INSERT INTO sandev_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","प्रभु र्विवाहादागत्य यदैव द्वारमाहन्ति तदैव द्वारं मोचयितुं यथा भृत्या अपेक्ष्य तिष्ठन्ति तथा यूयमपि तिष्ठत। ");
INSERT INTO sandev_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","यतः प्रभुरागत्य यान् दासान् सचेतनान् तिष्ठतो द्रक्ष्यति तएव धन्याः; अहं युष्मान् यथार्थं वदामि प्रभुस्तान् भोजनार्थम् उपवेश्य स्वयं बद्धकटिः समीपमेत्य परिवेषयिष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","यदि द्वितीये तृतीये वा प्रहरे समागत्य तथैव पश्यति, तर्हि तएव दासा धन्याः। ");
INSERT INTO sandev_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","अपरञ्च कस्मिन् क्षणे चौरा आगमिष्यन्ति इति यदि गृहपति र्ज्ञातुं शक्नोति तदावश्यं जाग्रन् निजगृहे सन्धिं कर्त्तयितुं वारयति यूयमेतद् वित्त। ");
INSERT INTO sandev_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","अतएव यूयमपि सज्जमानास्तिष्ठत यतो यस्मिन् क्षणे तं नाप्रेक्षध्वे तस्मिन्नेव क्षणे मनुष्यपुत्र आगमिष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","तदा पितरः पप्रच्छ, हे प्रभो भवान् किमस्मान् उद्दिश्य किं सर्व्वान् उद्दिश्य दृष्टान्तकथामिमां वदति? ");
INSERT INTO sandev_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ततः प्रभुः प्रोवाच, प्रभुः समुचितकाले निजपरिवारार्थं भोज्यपरिवेषणाय यं तत्पदे नियोक्ष्यति तादृशो विश्वास्यो बोद्धा कर्म्माधीशः कोस्ति? ");
INSERT INTO sandev_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","प्रभुरागत्य यम् एतादृशे कर्म्मणि प्रवृत्तं द्रक्ष्यति सएव दासो धन्यः। ");
INSERT INTO sandev_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","अहं युष्मान् यथार्थं वदामि स तं निजसर्व्वस्वस्याधिपतिं करिष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","किन्तु प्रभुर्विलम्बेनागमिष्यति, इति विचिन्त्य स दासो यदि तदन्यदासीदासान् प्रहर्त्तुम् भोक्तुं पातुं मदितुञ्च प्रारभते, ");
INSERT INTO sandev_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","तर्हि यदा प्रभुं नापेक्षिष्यते यस्मिन् क्षणे सोऽचेतनश्च स्थास्यति तस्मिन्नेव क्षणे तस्य प्रभुरागत्य तं पदभ्रष्टं कृत्वा विश्वासहीनैः सह तस्य अंशं निरूपयिष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","यो दासः प्रभेाराज्ञां ज्ञात्वापि सज्जितो न तिष्ठति तदाज्ञानुसारेण च कार्य्यं न करोति सोनेकान् प्रहारान् प्राप्स्यति; ");
INSERT INTO sandev_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","किन्तु यो जनोऽज्ञात्वा प्रहारार्हं कर्म्म करोति सोल्पप्रहारान् प्राप्स्यति। यतो यस्मै बाहुल्येन दत्तं तस्मादेव बाहुल्येन ग्रहीष्यते, मानुषा यस्य निकटे बहु समर्पयन्ति तस्माद् बहु याचन्ते। ");
INSERT INTO sandev_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","अहं पृथिव्याम् अनैक्यरूपं वह्नि निक्षेप्तुम् आगतोस्मि, स चेद् इदानीमेव प्रज्वलति तत्र मम का चिन्ता? ");
INSERT INTO sandev_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","किन्तु येन मज्जनेनाहं मग्नो भविष्यामि यावत्कालं तस्य सिद्धि र्न भविष्यति तावदहं कतिकष्टं प्राप्स्यामि। ");
INSERT INTO sandev_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","मेलनं कर्त्तुं जगद् आगतोस्मि यूयं किमित्थं बोधध्वे? युष्मान् वदामि न तथा, किन्त्वहं मेलनाभावं कर्त्तुंम् आगतोस्मि। ");
INSERT INTO sandev_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","यस्मादेतत्कालमारभ्य एकत्रस्थपरिजनानां मध्ये पञ्चजनाः पृथग् भूत्वा त्रयो जना द्वयोर्जनयोः प्रतिकूला द्वौ जनौ च त्रयाणां जनानां प्रतिकूलौ भविष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","पिता पुत्रस्य विपक्षः पुत्रश्च पितु र्विपक्षो भविष्यति माता कन्याया विपक्षा कन्या च मातु र्विपक्षा भविष्यति, तथा श्वश्रूर्बध्वा विपक्षा बधूश्च श्वश्र्वा विपक्षा भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","स लोकेभ्योपरमपि कथयामास, पश्चिमदिशि मेघोद्गमं दृष्ट्वा यूयं हठाद् वदथ वृष्टि र्भविष्यति ततस्तथैव जायते। ");
INSERT INTO sandev_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","अपरं दक्षिणतो वायौ वाति सति वदथ निदाघो भविष्यति ततः सोपि जायते। ");
INSERT INTO sandev_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","रे रे कपटिन आकाशस्य भूम्याश्च लक्षणं बोद्धुं शक्नुथ, ");
INSERT INTO sandev_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","किन्तु कालस्यास्य लक्षणं कुतो बोद्धुं न शक्नुथ? यूयञ्च स्वयं कुतो न न्याष्यं विचारयथ? ");
INSERT INTO sandev_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","अपरञ्च विवादिना सार्द्धं विचारयितुः समीपं गच्छन् पथि तस्मादुद्धारं प्राप्तुं यतस्व नोचेत् स त्वां धृत्वा विचारयितुः समीपं नयति। विचारयिता यदि त्वां प्रहर्त्तुः समीपं समर्पयति प्रहर्त्ता त्वां कारायां बध्नाति ");
INSERT INTO sandev_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","तर्हि त्वामहं वदामि त्वया निःशेषं कपर्दकेषु न परिशोधितेषु त्वं ततो मुक्तिं प्राप्तुं न शक्ष्यसि। ");
INSERT INTO sandev_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","अपरञ्च पीलातो येषां गालीलीयानां रक्तानि बलीनां रक्तैः सहामिश्रयत् तेषां गालीलीयानां वृत्तान्तं कतिपयजना उपस्थाप्य यीशवे कथयामासुः। ");
INSERT INTO sandev_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ततः स प्रत्युवाच तेषां लोकानाम् एतादृशी दुर्गति र्घटिता तत्कारणाद् यूयं किमन्येभ्यो गालीलीयेभ्योप्यधिकपापिनस्तान् बोधध्वे? ");
INSERT INTO sandev_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","युष्मानहं वदामि तथा न किन्तु मनःसु न परावर्त्तितेषु यूयमपि तथा नंक्ष्यथ। ");
INSERT INTO sandev_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","अपरञ्च शीलोहनाम्न उच्चगृहस्य पतनाद् येऽष्टादशजना मृतास्ते यिरूशालमि निवासिसर्व्वलोकेभ्योऽधिकापराधिनः किं यूयमित्यं बोधध्वे? ");
INSERT INTO sandev_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","युष्मानहं वदामि तथा न किन्तु मनःसु न परिवर्त्तितेषु यूयमपि तथा नंक्ष्यथ। ");
INSERT INTO sandev_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","अनन्तरं स इमां दृष्टान्तकथामकथयद् एको जनो द्राक्षाक्षेत्रमध्य एकमुडुम्बरवृक्षं रोपितवान्। पश्चात् स आगत्य तस्मिन् फलानि गवेषयामास, ");
INSERT INTO sandev_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","किन्तु फलाप्राप्तेः कारणाद् उद्यानकारं भृत्यं जगाद, पश्य वत्सरत्रयं यावदागत्य एतस्मिन्नुडुम्बरतरौ क्षलान्यन्विच्छामि, किन्तु नैकमपि प्रप्नोमि तरुरयं कुतो वृथा स्थानं व्याप्य तिष्ठति? एनं छिन्धि। ");
INSERT INTO sandev_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ततो भृत्यः प्रत्युवाच, हे प्रभो पुनर्वर्षमेकं स्थातुम् आदिश; एतस्य मूलस्य चतुर्दिक्षु खनित्वाहम् आलवालं स्थापयामि। ");
INSERT INTO sandev_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ततः फलितुं शक्नोति यदि न फलति तर्हि पश्चात् छेत्स्यसि। ");
INSERT INTO sandev_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","अथ विश्रामवारे भजनगेहे यीशुरुपदिशति ");
INSERT INTO sandev_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","तस्मित् समये भूतग्रस्तत्वात् कुब्जीभूयाष्टादशवर्षाणि यावत् केनाप्युपायेन ऋजु र्भवितुं न शक्नोति या दुर्ब्बला स्त्री, ");
INSERT INTO sandev_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","तां तत्रोपस्थितां विलोक्य यीशुस्तामाहूय कथितवान् हे नारि तव दौर्ब्बल्यात् त्वं मुक्ता भव। ");
INSERT INTO sandev_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ततः परं तस्या गात्रे हस्तार्पणमात्रात् सा ऋजुर्भूत्वेश्वरस्य धन्यवादं कर्त्तुमारेभे। ");
INSERT INTO sandev_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","किन्तु विश्रामवारे यीशुना तस्याः स्वास्थ्यकरणाद् भजनगेहस्याधिपतिः प्रकुप्य लोकान् उवाच, षट्सु दिनेषु लोकैः कर्म्म कर्त्तव्यं तस्माद्धेतोः स्वास्थ्यार्थं तेषु दिनेषु आगच्छत, विश्रामवारे मागच्छत। ");
INSERT INTO sandev_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","तदा पभुः प्रत्युवाच रे कपटिनो युष्माकम् एकैको जनो विश्रामवारे स्वीयं स्वीयं वृषभं गर्दभं वा बन्धनान्मोचयित्वा जलं पाययितुं किं न नयति? ");
INSERT INTO sandev_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","तर्ह्याष्टादशवत्सरान् यावत् शैताना बद्धा इब्राहीमः सन्ततिरियं नारी किं विश्रामवारे न मोचयितव्या? ");
INSERT INTO sandev_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","एषु वाक्येषु कथितेषु तस्य विपक्षाः सलज्जा जाताः किन्तु तेन कृतसर्व्वमहाकर्म्मकारणात् लोकनिवहः सानन्दोऽभवत्। ");
INSERT INTO sandev_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","अनन्तरं सोवदद् ईश्वरस्य राज्यं कस्य सदृशं? केन तदुपमास्यामि? ");
INSERT INTO sandev_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","यत् सर्षपबीजं गृहीत्वा कश्चिज्जन उद्यान उप्तवान् तद् बीजमङ्कुरितं सत् महावृक्षोऽजायत, ततस्तस्य शाखासु विहायसीयविहगा आगत्य न्यूषुः, तद्राज्यं तादृशेन सर्षपबीजेन तुल्यं। ");
INSERT INTO sandev_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","पुनः कथयामास, ईश्वरस्य राज्यं कस्य सदृशं वदिष्यामि? यत् किण्वं काचित् स्त्री गृहीत्वा द्रोणत्रयपरिमितगोधूमचूर्णेषु स्थापयामास, ");
INSERT INTO sandev_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ततः क्रमेण तत् सर्व्वगोधूमचूर्णं व्याप्नोति, तस्य किण्वस्य तुल्यम् ईश्वरस्य राज्यं। ");
INSERT INTO sandev_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ततः स यिरूशालम्नगरं प्रति यात्रां कृत्वा नगरे नगरे ग्रामे ग्रामे समुपदिशन् जगाम। ");
INSERT INTO sandev_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","तदा कश्चिज्जनस्तं पप्रच्छ, हे प्रभो किं केवलम् अल्पे लोकाः परित्रास्यन्ते? ");
INSERT INTO sandev_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","ततः स लोकान् उवाच, संकीर्णद्वारेण प्रवेष्टुं यतघ्वं, यतोहं युष्मान् वदामि, बहवः प्रवेष्टुं चेष्टिष्यन्ते किन्तु न शक्ष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","गृहपतिनोत्थाय द्वारे रुद्धे सति यदि यूयं बहिः स्थित्वा द्वारमाहत्य वदथ, हे प्रभो हे प्रभो अस्मत्कारणाद् द्वारं मोचयतु, ततः स इति प्रतिवक्ष्यति, यूयं कुत्रत्या लोका इत्यहं न जानामि। ");
INSERT INTO sandev_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","तदा यूयं वदिष्यथ, तव साक्षाद् वयं भेाजनं पानञ्च कृतवन्तः, त्वञ्चास्माकं नगरस्य पथि समुपदिष्टवान्। ");
INSERT INTO sandev_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","किन्तु स वक्ष्यति, युष्मानहं वदामि, यूयं कुत्रत्या लोका इत्यहं न जानामि; हे दुराचारिणो यूयं मत्तो दूरीभवत। ");
INSERT INTO sandev_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","तदा इब्राहीमं इस्हाकं याकूबञ्च सर्व्वभविष्यद्वादिनश्च ईश्वरस्य राज्यं प्राप्तान् स्वांश्च बहिष्कृतान् दृष्ट्वा यूयं रोदनं दन्तैर्दन्तघर्षणञ्च करिष्यथ। ");
INSERT INTO sandev_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","अपरञ्च पूर्व्वपश्चिमदक्षिणोत्तरदिग्भ्यो लोका आगत्य ईश्वरस्य राज्ये निवत्स्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","पश्यतेत्थं शेषीया लोका अग्रा भविष्यन्ति, अग्रीया लोकाश्च शेषा भविष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","अपरञ्च तस्मिन् दिने कियन्तः फिरूशिन आगत्य यीशुं प्रोचुः, बहिर्गच्छ, स्थानादस्मात् प्रस्थानं कुरु, हेरोद् त्वां जिघांसति। ");
INSERT INTO sandev_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ततः स प्रत्यवोचत् पश्यताद्य श्वश्च भूतान् विहाप्य रोगिणोऽरोगिणः कृत्वा तृतीयेह्नि सेत्स्यामि, कथामेतां यूयमित्वा तं भूरिमायं वदत। ");
INSERT INTO sandev_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","तत्राप्यद्य श्वः परश्वश्च मया गमनागमने कर्त्तव्ये, यतो हेतो र्यिरूशालमो बहिः कुत्रापि कोपि भविष्यद्वादी न घानिष्यते। ");
INSERT INTO sandev_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","हे यिरूशालम् हे यिरूशालम् त्वं भविष्यद्वादिनो हंसि तवान्तिके प्रेरितान् प्रस्तरैर्मारयसि च, यथा कुक्कुटी निजपक्षाधः स्वशावकान् संगृह्लाति, तथाहमपि तव शिशून् संग्रहीतुं कतिवारान् ऐच्छं किन्तु त्वं नैच्छः। ");
INSERT INTO sandev_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","पश्यत युष्माकं वासस्थानानि प्रोच्छिद्यमानानि परित्यक्तानि च भविष्यन्ति; युष्मानहं यथार्थं वदामि, यः प्रभो र्नाम्नागच्छति स धन्य इति वाचं यावत्कालं न वदिष्यथ, तावत्कालं यूयं मां न द्रक्ष्यथ। ");
INSERT INTO sandev_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","अनन्तरं विश्रामवारे यीशौ प्रधानस्य फिरूशिनो गृहे भोक्तुं गतवति ते तं वीक्षितुम् आरेभिरे। ");
INSERT INTO sandev_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","तदा जलोदरी तस्य सम्मुखे स्थितः। ");
INSERT INTO sandev_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ततः स व्यवस्थापकान् फिरूशिनश्च पप्रच्छ, विश्रामवारे स्वास्थ्यं कर्त्तव्यं न वा? ततस्ते किमपि न प्रत्यूचुः। ");
INSERT INTO sandev_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","तदा स तं रोगिणं स्वस्थं कृत्वा विससर्ज; ");
INSERT INTO sandev_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","तानुवाच च युष्माकं कस्यचिद् गर्द्दभो वृषभो वा चेद् गर्त्ते पतति तर्हि विश्रामवारे तत्क्षणं स किं तं नोत्थापयिष्यति? ");
INSERT INTO sandev_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ततस्ते कथाया एतस्याः किमपि प्रतिवक्तुं न शेकुः। ");
INSERT INTO sandev_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","अपरञ्च प्रधानस्थानमनोनीतत्वकरणं विलोक्य स निमन्त्रितान् एतदुपदेशकथां जगाद, ");
INSERT INTO sandev_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","त्वं विवाहादिभोज्येषु निमन्त्रितः सन् प्रधानस्थाने मोपावेक्षीः। त्वत्तो गौरवान्वितनिमन्त्रितजन आयाते ");
INSERT INTO sandev_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","निमन्त्रयितागत्य मनुष्यायैतस्मै स्थानं देहीति वाक्यं चेद् वक्ष्यति तर्हि त्वं सङ्कुचितो भूत्वा स्थान इतरस्मिन् उपवेष्टुम् उद्यंस्यसि। ");
INSERT INTO sandev_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","अस्मात् कारणादेव त्वं निमन्त्रितो गत्वाऽप्रधानस्थान उपविश, ततो निमन्त्रयितागत्य वदिष्यति, हे बन्धो प्रोच्चस्थानं गत्वोपविश, तथा सति भोजनोपविष्टानां सकलानां साक्षात् त्वं मान्यो भविष्यसि। ");
INSERT INTO sandev_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","यः कश्चित् स्वमुन्नमयति स नमयिष्यते, किन्तु यः कश्चित् स्वं नमयति स उन्नमयिष्यते। ");
INSERT INTO sandev_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","तदा स निमन्त्रयितारं जनमपि जगाद, मध्याह्ने रात्रौ वा भोज्ये कृते निजबन्धुगणो वा भ्रातृृगणो वा ज्ञातिगणो वा धनिगणो वा समीपवासिगणो वा एतान् न निमन्त्रय, तथा कृते चेत् ते त्वां निमन्त्रयिष्यन्ति, तर्हि परिशोधो भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","किन्तु यदा भेज्यं करोषि तदा दरिद्रशुष्ककरखञ्जान्धान् निमन्त्रय, ");
INSERT INTO sandev_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","तत आशिषं लप्स्यसे, तेषु परिशोधं कर्त्तुमशक्नुवत्सु श्मशानाद्धार्म्मिकानामुत्थानकाले त्वं फलां लप्स्यसे। ");
INSERT INTO sandev_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","अनन्तरं तां कथां निशम्य भोजनोपविष्टः कश्चित् कथयामास, यो जन ईश्वरस्य राज्ये भोक्तुं लप्स्यते सएव धन्यः। ");
INSERT INTO sandev_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ततः स उवाच, कश्चित् जनो रात्रौ भेाज्यं कृत्वा बहून् निमन्त्रयामास। ");
INSERT INTO sandev_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ततो भोजनसमये निमन्त्रितलोकान् आह्वातुं दासद्वारा कथयामास, खद्यद्रव्याणि सर्व्वाणि समासादितानि सन्ति, यूयमागच्छत। ");
INSERT INTO sandev_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","किन्तु ते सर्व्व एकैकं छलं कृत्वा क्षमां प्रार्थयाञ्चक्रिरे। प्रथमो जनः कथयामास, क्षेत्रमेकं क्रीतवानहं तदेव द्रष्टुं मया गन्तव्यम्, अतएव मां क्षन्तुं तं निवेदय। ");
INSERT INTO sandev_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","अन्यो जनः कथयामास, दशवृषानहं क्रीतवान् तान् परीक्षितुं यामि तस्मादेव मां क्षन्तुं तं निवेदय। ");
INSERT INTO sandev_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","अपरः कथयामास, व्यूढवानहं तस्मात् कारणाद् यातुं न शक्नोमि। ");
INSERT INTO sandev_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","पश्चात् स दासो गत्वा निजप्रभोः साक्षात् सर्व्ववृत्तान्तं निवेदयामास, ततोसौ गृहपतिः कुपित्वा स्वदासं व्याजहार, त्वं सत्वरं नगरस्य सन्निवेशान् मार्गांश्च गत्वा दरिद्रशुष्ककरखञ्जान्धान् अत्रानय। ");
INSERT INTO sandev_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","ततो दासोऽवदत्, हे प्रभो भवत आज्ञानुसारेणाक्रियत तथापि स्थानमस्ति। ");
INSERT INTO sandev_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","तदा प्रभुः पुन र्दासायाकथयत्, राजपथान् वृक्षमूलानि च यात्वा मदीयगृहपूरणार्थं लोकानागन्तुं प्रवर्त्तय। ");
INSERT INTO sandev_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","अहं युष्मभ्यं कथयामि, पूर्व्वनिमन्त्रितानमेकोपि ममास्य रात्रिभोज्यस्यास्वादं न प्राप्स्यति। ");
INSERT INTO sandev_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","अनन्तरं बहुषु लोकेषु यीशोः पश्चाद् व्रजितेषु सत्सु स व्याघुट्य तेभ्यः कथयामास, ");
INSERT INTO sandev_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","यः कश्चिन् मम समीपम् आगत्य स्वस्य माता पिता पत्नी सन्ताना भ्रातरो भगिम्यो निजप्राणाश्च, एतेभ्यः सर्व्वेभ्यो मय्यधिकं प्रेम न करोति, स मम शिष्यो भवितुं न शक्ष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","यः कश्चित् स्वीयं क्रुशं वहन् मम पश्चान्न गच्छति, सोपि मम शिष्यो भवितुं न शक्ष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","दुर्गनिर्म्माणे कतिव्ययो भविष्यति, तथा तस्य समाप्तिकरणार्थं सम्पत्तिरस्ति न वा, प्रथममुपविश्य एतन्न गणयति, युष्माकं मध्य एतादृशः कोस्ति? ");
INSERT INTO sandev_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","नोचेद् भित्तिं कृत्वा शेषे यदि समापयितुं न शक्ष्यति, ");
INSERT INTO sandev_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","तर्हि मानुषोयं निचेतुम् आरभत समापयितुं नाशक्नोत्, इति व्याहृत्य सर्व्वे तमुपहसिष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","अपरञ्च भिन्नभूपतिना सह युद्धं कर्त्तुम् उद्यम्य दशसहस्राणि सैन्यानि गृहीत्वा विंशतिसहस्रेः सैन्यैः सहितस्य समीपवासिनः सम्मुखं यातुं शक्ष्यामि न वेति प्रथमं उपविश्य न विचारयति एतादृशो भूमिपतिः कः? ");
INSERT INTO sandev_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","यदि न शक्नोति तर्हि रिपावतिदूरे तिष्ठति सति निजदूतं प्रेष्य सन्धिं कर्त्तुं प्रार्थयेत। ");
INSERT INTO sandev_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","तद्वद् युष्माकं मध्ये यः कश्चिन् मदर्थं सर्व्वस्वं हातुं न शक्नोति स मम शिष्यो भवितुं न शक्ष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","लवणम् उत्तमम् इति सत्यं, किन्तु यदि लवणस्य लवणत्वम् अपगच्छति तर्हि तत् कथं स्वादुयुक्तं भविष्यति? ");
INSERT INTO sandev_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","तद भूम्यर्थम् आलवालराश्यर्थमपि भद्रं न भवति; लोकास्तद् बहिः क्षिपन्ति।यस्य श्रोतुं श्रोत्रे स्तः स शृणोतु। ");
INSERT INTO sandev_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","तदा करसञ्चायिनः पापिनश्च लोका उपदेश्कथां श्रोतुं यीशोः समीपम् आगच्छन्। ");
INSERT INTO sandev_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ततः फिरूशिन उपाध्यायाश्च विवदमानाः कथयामासुः एष मानुषः पापिभिः सह प्रणयं कृत्वा तैः सार्द्धं भुंक्ते। ");
INSERT INTO sandev_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","तदा स तेभ्य इमां दृष्टान्तकथां कथितवान्, ");
INSERT INTO sandev_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","कस्यचित् शतमेषेषु तिष्ठत्मु तेषामेकं स यदि हारयति तर्हि मध्येप्रान्तरम् एकोनशतमेषान् विहाय हारितमेषस्य उद्देशप्राप्तिपर्य्यनतं न गवेषयति, एतादृशो लोको युष्माकं मध्ये क आस्ते? ");
INSERT INTO sandev_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","तस्योद्देशं प्राप्य हृष्टमनास्तं स्कन्धे निधाय स्वस्थानम् आनीय बन्धुबान्धवसमीपवासिन आहूय वक्ति, ");
INSERT INTO sandev_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","हारितं मेषं प्राप्तोहम् अतो हेतो र्मया सार्द्धम् आनन्दत। ");
INSERT INTO sandev_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","तद्वदहं युष्मान् वदामि, येषां मनःपरावर्त्तनस्य प्रयोजनं नास्ति, तादृशैकोनशतधार्म्मिककारणाद् य आनन्दस्तस्माद् एकस्य मनःपरिवर्त्तिनः पापिनः कारणात् स्वर्गे ऽधिकानन्दो जायते। ");
INSERT INTO sandev_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","अपरञ्च दशानां रूप्यखण्डानाम् एकखण्डे हारिते प्रदीपं प्रज्वाल्य गृहं सम्मार्ज्य तस्य प्राप्तिं यावद् यत्नेन न गवेषयति, एतादृशी योषित् कास्ते? ");
INSERT INTO sandev_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","प्राप्ते सति बन्धुबान्धवसमीपवासिनीराहूय कथयति, हारितं रूप्यखण्डं प्राप्ताहं तस्मादेव मया सार्द्धम् आनन्दत। ");
INSERT INTO sandev_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","तद्वदहं युष्मान् व्याहरामि, एकेन पापिना मनसि परिवर्त्तिते, ईश्वरस्य दूतानां मध्येप्यानन्दो जायते। ");
INSERT INTO sandev_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","अपरञ्च स कथयामास, कस्यचिद् द्वौ पुत्रावास्तां, ");
INSERT INTO sandev_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","तयोः कनिष्ठः पुत्रः पित्रे कथयामास, हे पितस्तव सम्पत्त्या यमंशं प्राप्स्याम्यहं विभज्य तं देहि, ततः पिता निजां सम्पत्तिं विभज्य ताभ्यां ददौ। ");
INSERT INTO sandev_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","कतिपयात् कालात् परं स कनिष्ठपुत्रः समस्तं धनं संगृह्य दूरदेशं गत्वा दुष्टाचरणेन सर्व्वां सम्पत्तिं नाशयामास। ");
INSERT INTO sandev_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","तस्य सर्व्वधने व्ययं गते तद्देशे महादुर्भिक्षं बभूव, ततस्तस्य दैन्यदशा भवितुम् आरेभे। ");
INSERT INTO sandev_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ततः परं स गत्वा तद्देशीयं गृहस्थमेकम् आश्रयत; ततः सतं शूकरव्रजं चारयितुं प्रान्तरं प्रेषयामास। ");
INSERT INTO sandev_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","केनापि तस्मै भक्ष्यादानात् स शूकरफलवल्कलेन पिचिण्डपूरणां ववाञ्छ। ");
INSERT INTO sandev_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","शेषे स मनसि चेतनां प्राप्य कथयामास, हा मम पितुः समीपे कति कति वेतनभुजो दासा यथेष्टं ततोधिकञ्च भक्ष्यं प्राप्नुवन्ति किन्त्वहं क्षुधा मुमूर्षुः। ");
INSERT INTO sandev_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","अहमुत्थाय पितुः समीपं गत्वा कथामेतां वदिष्यामि, हे पितर् ईश्वरस्य तव च विरुद्धं पापमकरवम् ");
INSERT INTO sandev_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","तव पुत्रइति विख्यातो भवितुं न योग्योस्मि च, मां तव वैतनिकं दासं कृत्वा स्थापय। ");
INSERT INTO sandev_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","पश्चात् स उत्थाय पितुः समीपं जगाम; ततस्तस्य पितातिदूरे तं निरीक्ष्य दयाञ्चक्रे, धावित्वा तस्य कण्ठं गृहीत्वा तं चुचुम्ब च। ");
INSERT INTO sandev_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","तदा पुत्र उवाच, हे पितर् ईश्वरस्य तव च विरुद्धं पापमकरवं, तव पुत्रइति विख्यातो भवितुं न योग्योस्मि च। ");
INSERT INTO sandev_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","किन्तु तस्य पिता निजदासान् आदिदेश, सर्व्वोत्तमवस्त्राण्यानीय परिधापयतैनं हस्ते चाङ्गुरीयकम् अर्पयत पादयोश्चोपानहौ समर्पयत; ");
INSERT INTO sandev_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","पुष्टं गोवत्सम् आनीय मारयत च तं भुक्त्वा वयम् आनन्दाम। ");
INSERT INTO sandev_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","यतो मम पुत्रोयम् अम्रियत पुनरजीवीद् हारितश्च लब्धोभूत् ततस्त आनन्दितुम् आरेभिरे। ");
INSERT INTO sandev_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","तत्काले तस्य ज्येष्ठः पुत्रः क्षेत्र आसीत्। अथ स निवेशनस्य निकटं आगच्छन् नृत्यानां वाद्यानाञ्च शब्दं श्रुत्वा ");
INSERT INTO sandev_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","दासानाम् एकम् आहूय पप्रच्छ, किं कारणमस्य? ");
INSERT INTO sandev_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","ततः सोवादीत्, तव भ्रातागमत्, तव तातश्च तं सुशरीरं प्राप्य पुष्टं गोवत्सं मारितवान्। ");
INSERT INTO sandev_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","ततः स प्रकुप्य निवेशनान्तः प्रवेष्टुं न सम्मेने; ततस्तस्य पिता बहिरागत्य तं साधयामास। ");
INSERT INTO sandev_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ततः स पितरं प्रत्युवाच, पश्य तव काञ्चिदप्याज्ञां न विलंघ्य बहून् वत्सरान् अहं त्वां सेवे तथापि मित्रैः सार्द्धम् उत्सवं कर्त्तुं कदापि छागमेकमपि मह्यं नाददाः; ");
INSERT INTO sandev_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","किन्तु तव यः पुत्रो वेश्यागमनादिभिस्तव सम्पत्तिम् अपव्ययितवान् तस्मिन्नागतमात्रे तस्यैव निमित्तं पुष्टं गोवत्सं मारितवान्। ");
INSERT INTO sandev_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","तदा तस्य पितावोचत्, हे पुत्र त्वं सर्व्वदा मया सहासि तस्मान् मम यद्यदास्ते तत्सर्व्वं तव। ");
INSERT INTO sandev_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","किन्तु तवायं भ्राता मृतः पुनरजीवीद् हारितश्च भूत्वा प्राप्तोभूत्, एतस्मात् कारणाद् उत्सवानन्दौ कर्त्तुम् उचितमस्माकम्। ");
INSERT INTO sandev_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","अपरञ्च यीशुः शिष्येभ्योन्यामेकां कथां कथयामास कस्यचिद् धनवतो मनुष्यस्य गृहकार्य्याधीशे सम्पत्तेरपव्ययेऽपवादिते सति ");
INSERT INTO sandev_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","तस्य प्रभुस्तम् आहूय जगाद, त्वयि यामिमां कथां शृणोमि सा कीदृशी? त्वं गृहकार्य्याधीशकर्म्मणो गणनां दर्शय गृहकार्य्याधीशपदे त्वं न स्थास्यसि। ");
INSERT INTO sandev_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","तदा स गृहकार्य्याधीशो मनसा चिन्तयामास, प्रभु र्यदि मां गृहकार्य्याधीशपदाद् भ्रंशयति तर्हि किं करिष्येऽहं? मृदं खनितुं मम शक्ति र्नास्ति भिक्षितुञ्च लज्जिष्येऽहं। ");
INSERT INTO sandev_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","अतएव मयि गृहकार्य्याधीशपदात् च्युते सति यथा लोका मह्यम् आश्रयं दास्यन्ति तदर्थं यत्कर्म्म मया करणीयं तन् निर्णीयते। ");
INSERT INTO sandev_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","पश्चात् स स्वप्रभोरेकैकम् अधमर्णम् आहूय प्रथमं पप्रच्छ, त्वत्तो मे प्रभुणा कति प्राप्यम्? ");
INSERT INTO sandev_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ततः स उवाच, एकशताढकतैलानि; तदा गृहकार्य्याधीशः प्रोवाच, तव पत्रमानीय शीघ्रमुपविश्य तत्र पञ्चाशतं लिख। ");
INSERT INTO sandev_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","पश्चादन्यमेकं पप्रच्छ, त्वत्तो मे प्रभुणा कति प्राप्यम्? ततः सोवादीद् एकशताढकगोधूमाः; तदा स कथयामास, तव पत्रमानीय अशीतिं लिख। ");
INSERT INTO sandev_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","तेनैव प्रभुस्तमयथार्थकृतम् अधीशं तद्बुद्धिनैपुण्यात् प्रशशंस; इत्थं दीप्तिरूपसन्तानेभ्य एतत्संसारस्य सन्ताना वर्त्तमानकालेऽधिकबुद्धिमन्तो भवन्ति। ");
INSERT INTO sandev_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","अतो वदामि यूयमप्ययथार्थेन धनेन मित्राणि लभध्वं ततो युष्मासु पदभ्रष्टेष्वपि तानि चिरकालम् आश्रयं दास्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","यः कश्चित् क्षुद्रे कार्य्ये विश्वास्यो भवति स महति कार्य्येपि विश्वास्यो भवति, किन्तु यः कश्चित् क्षुद्रे कार्य्येऽविश्वास्यो भवति स महति कार्य्येप्यविश्वास्यो भवति। ");
INSERT INTO sandev_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","अतएव अयथार्थेन धनेन यदि यूयमविश्वास्या जातास्तर्हि सत्यं धनं युष्माकं करेषु कः समर्पयिष्यति? ");
INSERT INTO sandev_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","यदि च परधनेन यूयम् अविश्वास्या भवथ तर्हि युष्माकं स्वकीयधनं युष्मभ्यं को दास्यति? ");
INSERT INTO sandev_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","कोपि दास उभौ प्रभू सेवितुं न शक्नोति, यत एकस्मिन् प्रीयमाणोऽन्यस्मिन्नप्रीयते यद्वा एकं जनं समादृत्य तदन्यं तुच्छीकरोति तद्वद् यूयमपि धनेश्वरौ सेवितुं न शक्नुथ। ");
INSERT INTO sandev_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","तदैताः सर्व्वाः कथाः श्रुत्वा लोभिफिरूशिनस्तमुपजहसुः। ");
INSERT INTO sandev_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ततः स उवाच, यूयं मनुष्याणां निकटे स्वान् निर्दोषान् दर्शयथ किन्तु युष्माकम् अन्तःकरणानीश्वरो जानाति, यत् मनुष्याणाम् अति प्रशंस्यं तद् ईश्वरस्य घृण्यं। ");
INSERT INTO sandev_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","योहन आगमनपर्य्यनतं युष्माकं समीपे व्यवस्थाभविष्यद्वादिनां लेखनानि चासन् ततः प्रभृति ईश्वरराज्यस्य सुसंवादः प्रचरति, एकैको लोकस्तन्मध्यं यत्नेन प्रविशति च। ");
INSERT INTO sandev_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","वरं नभसः पृथिव्याश्च लोपो भविष्यति तथापि व्यवस्थाया एकबिन्दोरपि लोपो न भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","यः कश्चित् स्वीयां भार्य्यां विहाय स्त्रियमन्यां विवहति स परदारान् गच्छति, यश्च ता त्यक्तां नारीं विवहति सोपि परदारान गच्छति। ");
INSERT INTO sandev_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","एको धनी मनुष्यः शुक्लानि सूक्ष्माणि वस्त्राणि पर्य्यदधात् प्रतिदिनं परितोषरूपेणाभुंक्तापिवच्च। ");
INSERT INTO sandev_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","सर्व्वाङ्गे क्षतयुक्त इलियासरनामा कश्चिद् दरिद्रस्तस्य धनवतो भोजनपात्रात् पतितम् उच्छिष्टं भोक्तुं वाञ्छन् तस्य द्वारे पतित्वातिष्ठत्; ");
INSERT INTO sandev_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","अथ श्वान आगत्य तस्य क्षतान्यलिहन्। ");
INSERT INTO sandev_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","कियत्कालात्परं स दरिद्रः प्राणान् जहौ; ततः स्वर्गीयदूतास्तं नीत्वा इब्राहीमः क्रोड उपवेशयामासुः। ");
INSERT INTO sandev_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","पश्चात् स धनवानपि ममार, तं श्मशाने स्थापयामासुश्च; किन्तु परलोके स वेदनाकुलः सन् ऊर्द्ध्वां निरीक्ष्य बहुदूराद् इब्राहीमं तत्क्रोड इलियासरञ्च विलोक्य रुवन्नुवाच; ");
INSERT INTO sandev_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","हे पितर् इब्राहीम् अनुगृह्य अङ्गुल्यग्रभागं जले मज्जयित्वा मम जिह्वां शीतलां कर्त्तुम् इलियासरं प्रेरय, यतो वह्निशिखातोहं व्यथितोस्मि। ");
INSERT INTO sandev_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","तदा इब्राहीम् बभाषे, हे पुत्र त्वं जीवन् सम्पदं प्राप्तवान् इलियासरस्तु विपदं प्राप्तवान् एतत् स्मर, किन्तु सम्प्रति तस्य सुखं तव च दुःखं भवति। ");
INSERT INTO sandev_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","अपरमपि युष्माकम् अस्माकञ्च स्थानयो र्मध्ये महद्विच्छेदोऽस्ति तत एतत्स्थानस्य लोकास्तत् स्थानं यातुं यद्वा तत्स्थानस्य लोका एतत् स्थानमायातुं न शक्नुवन्ति। ");
INSERT INTO sandev_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","तदा स उक्तवान्, हे पितस्तर्हि त्वां निवेदयामि मम पितु र्गेहे ये मम पञ्च भ्रातरः सन्ति ");
INSERT INTO sandev_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ते यथैतद् यातनास्थानं नायास्यन्ति तथा मन्त्रणां दातुं तेषां समीपम् इलियासरं प्रेरय। ");
INSERT INTO sandev_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","तत इब्राहीम् उवाच, मूसाभविष्यद्वादिनाञ्च पुस्तकानि तेषां निकटे सन्ति ते तद्वचनानि मन्यन्तां। ");
INSERT INTO sandev_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","तदा स निवेदयामास, हे पितर् इब्राहीम् न तथा, किन्तु यदि मृतलोकानां कश्चित् तेषां समीपं याति तर्हि ते मनांसि व्याघोटयिष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","तत इब्राहीम् जगाद, ते यदि मूसाभविष्यद्वादिनाञ्च वचनानि न मन्यन्ते तर्हि मृतलोकानां कस्मिंश्चिद् उत्थितेपि ते तस्य मन्त्रणां न मंस्यन्ते। ");
INSERT INTO sandev_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","इतः परं यीशुः शिष्यान् उवाच, विघ्नैरवश्यम् आगन्तव्यं किन्तु विघ्ना येन घटिष्यन्ते तस्य दुर्गति र्भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","एतेषां क्षुद्रप्राणिनाम् एकस्यापि विघ्नजननात् कण्ठबद्धपेषणीकस्य तस्य सागरागाधजले मज्जनं भद्रं। ");
INSERT INTO sandev_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","यूयं स्वेषु सावधानास्तिष्ठत; तव भ्राता यदि तव किञ्चिद् अपराध्यति तर्हि तं तर्जय, तेन यदि मनः परिवर्त्तयति तर्हि तं क्षमस्व। ");
INSERT INTO sandev_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","पुनरेकदिनमध्ये यदि स तव सप्तकृत्वोऽपराध्यति किन्तु सप्तकृत्व आगत्य मनः परिवर्त्य मयापराद्धम् इति वदति तर्हि तं क्षमस्व। ");
INSERT INTO sandev_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","तदा प्रेरिताः प्रभुम् अवदन् अस्माकं विश्वासं वर्द्धय। ");
INSERT INTO sandev_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","प्रभुरुवाच, यदि युष्माकं सर्षपैकप्रमाणो विश्वासोस्ति तर्हि त्वं समूलमुत्पाटितो भूत्वा समुद्रे रोपितो भव कथायाम् एतस्याम् एतदुडुम्बराय कथितायां स युष्माकमाज्ञावहो भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","अपरं स्वदासे हलं वाहयित्वा वा पशून् चारयित्वा क्षेत्राद् आगते सति तं वदति, एहि भोक्तुमुपविश, युष्माकम् एतादृशः कोस्ति? ");
INSERT INTO sandev_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","वरञ्च पूर्व्वं मम खाद्यमासाद्य यावद् भुञ्जे पिवामि च तावद् बद्धकटिः परिचर पश्चात् त्वमपि भोक्ष्यसे पास्यसि च कथामीदृशीं किं न वक्ष्यति? ");
INSERT INTO sandev_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","तेन दासेन प्रभोराज्ञानुरूपे कर्म्मणि कृते प्रभुः किं तस्मिन् बाधितो जातः? नेत्थं बुध्यते मया। ");
INSERT INTO sandev_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","इत्थं निरूपितेषु सर्व्वकर्म्मसु कृतेषु सत्मु यूयमपीदं वाक्यं वदथ, वयम् अनुपकारिणो दासा अस्माभिर्यद्यत्कर्त्तव्यं तन्मात्रमेव कृतं। ");
INSERT INTO sandev_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","स यिरूशालमि यात्रां कुर्व्वन् शोमिरोण्गालील्प्रदेशमध्येन गच्छति, ");
INSERT INTO sandev_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","एतर्हि कुत्रचिद् ग्रामे प्रवेशमात्रे दशकुष्ठिनस्तं साक्षात् कृत्वा ");
INSERT INTO sandev_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","दूरे तिष्ठनत उच्चै र्वक्तुमारेभिरे, हे प्रभो यीशो दयस्वास्मान्। ");
INSERT INTO sandev_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ततः स तान् दृष्ट्वा जगाद, यूयं याजकानां समीपे स्वान् दर्शयत, ततस्ते गच्छन्तो रोगात् परिष्कृताः। ");
INSERT INTO sandev_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","तदा तेषामेकः स्वं स्वस्थं दृष्ट्वा प्रोच्चैरीश्वरं धन्यं वदन् व्याघुट्यायातो यीशो र्गुणाननुवदन् तच्चरणाधोभूमौ पपात; ");
INSERT INTO sandev_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","स चासीत् शोमिरोणी। ");
INSERT INTO sandev_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","तदा यीशुरवदत्, दशजनाः किं न परिष्कृताः? तह्यन्ये नवजनाः कुत्र? ");
INSERT INTO sandev_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ईश्वरं धन्यं वदन्तम् एनं विदेशिनं विना कोप्यन्यो न प्राप्यत। ");
INSERT INTO sandev_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","तदा स तमुवाच, त्वमुत्थाय याहि विश्वासस्ते त्वां स्वस्थं कृतवान्। ");
INSERT INTO sandev_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","अथ कदेश्वरस्य राजत्वं भविष्यतीति फिरूशिभिः पृष्टे स प्रत्युवाच, ईश्वरस्य राजत्वम् ऐश्वर्य्यदर्शनेन न भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","अत एतस्मिन् पश्य तस्मिन् वा पश्य, इति वाक्यं लोका वक्तुं न शक्ष्यन्ति, ईश्वरस्य राजत्वं युष्माकम् अन्तरेवास्ते। ");
INSERT INTO sandev_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ततः स शिष्यान् जगाद, यदा युष्माभि र्मनुजसुतस्य दिनमेकं द्रष्टुम् वाञ्छिष्यते किन्तु न दर्शिष्यते, ईदृक्काल आयाति। ");
INSERT INTO sandev_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","तदात्र पश्य वा तत्र पश्येति वाक्यं लोका वक्ष्यन्ति, किन्तु तेषां पश्चात् मा यात, मानुगच्छत च। ");
INSERT INTO sandev_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","यतस्तडिद् यथाकाशैकदिश्युदिय तदन्यामपि दिशं व्याप्य प्रकाशते तद्वत् निजदिने मनुजसूनुः प्रकाशिष्यते। ");
INSERT INTO sandev_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","किन्तु तत्पूर्व्वं तेनानेकानि दुःखानि भोक्तव्यान्येतद्वर्त्तमानलोकैश्च सोऽवज्ञातव्यः। ");
INSERT INTO sandev_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","नोहस्य विद्यमानकाले यथाभवत् मनुष्यसूनोः कालेपि तथा भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","यावत्कालं नोहो महापोतं नारोहद् आप्लाविवार्य्येत्य सर्व्वं नानाशयच्च तावत्कालं यथा लोका अभुञ्जतापिवन् व्यवहन् व्यवाहयंश्च; ");
INSERT INTO sandev_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","इत्थं लोटो वर्त्तमानकालेपि यथा लोका भोजनपानक्रयविक्रयरोपणगृहनिर्म्माणकर्म्मसु प्रावर्त्तन्त, ");
INSERT INTO sandev_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","किन्तु यदा लोट् सिदोमो निर्जगाम तदा नभसः सगन्धकाग्निवृष्टि र्भूत्वा सर्व्वं व्यनाशयत् ");
INSERT INTO sandev_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","तद्वन् मानवपुत्रप्रकाशदिनेपि भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","तदा यदि कश्चिद् गृहोपरि तिष्ठति तर्हि स गृहमध्यात् किमपि द्रव्यमानेतुम् अवरुह्य नैतु; यश्च क्षेत्रे तिष्ठति सोपि व्याघुट्य नायातु। ");
INSERT INTO sandev_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","लोटः पत्नीं स्मरत। ");
INSERT INTO sandev_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","यः प्राणान् रक्षितुं चेष्टिष्यते स प्राणान् हारयिष्यति यस्तु प्राणान् हारयिष्यति सएव प्राणान् रक्षिष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","युष्मानहं वच्मि तस्यां रात्रौ शय्यैकगतयो र्लोकयोरेको धारिष्यते परस्त्यक्ष्यते। ");
INSERT INTO sandev_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","स्त्रियौ युगपत् पेषणीं व्यावर्त्तयिष्यतस्तयोरेका धारिष्यते परात्यक्ष्यते। ");
INSERT INTO sandev_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","पुरुषौ क्षेत्रे स्थास्यतस्तयोरेको धारिष्यते परस्त्यक्ष्यते। ");
INSERT INTO sandev_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","तदा ते पप्रच्छुः, हे प्रभो कुत्रेत्थं भविष्यति? ततः स उवाच, यत्र शवस्तिष्ठति तत्र गृध्रा मिलन्ति। ");
INSERT INTO sandev_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","अपरञ्च लोकैरक्लान्तै र्निरन्तरं प्रार्थयितव्यम् इत्याशयेन यीशुना दृष्टान्त एकः कथितः। ");
INSERT INTO sandev_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","कुत्रचिन्नगरे कश्चित् प्राड्विवाक आसीत् स ईश्वरान्नाबिभेत् मानुषांश्च नामन्यत। ");
INSERT INTO sandev_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","अथ तत्पुरवासिनी काचिद्विधवा तत्समीपमेत्य विवादिना सह मम विवादं परिष्कुर्व्विति निवेदयामास। ");
INSERT INTO sandev_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ततः स प्राड्विवाकः कियद्दिनानि न तदङ्गीकृतवान् पश्चाच्चित्ते चिन्तयामास, यद्यपीश्वरान्न बिभेमि मनुष्यानपि न मन्ये ");
INSERT INTO sandev_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","तथाप्येषा विधवा मां क्लिश्नाति तस्मादस्या विवादं परिष्करिष्यामि नोचेत् सा सदागत्य मां व्यग्रं करिष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","पश्चात् प्रभुरवदद् असावन्यायप्राड्विवाको यदाह तत्र मनो निधध्वं। ");
INSERT INTO sandev_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ईश्वरस्य ये ऽभिरुचितलोका दिवानिशं प्रार्थयन्ते स बहुदिनानि विलम्ब्यापि तेषां विवादान् किं न परिष्करिष्यति? ");
INSERT INTO sandev_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","युष्मानहं वदामि त्वरया परिष्करिष्यति, किन्तु यदा मनुष्यपुत्र आगमिष्यति तदा पृथिव्यां किमीदृशं विश्वासं प्राप्स्यति? ");
INSERT INTO sandev_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ये स्वान् धार्म्मिकान् ज्ञात्वा परान् तुच्छीकुर्व्वन्ति एतादृग्भ्यः, कियद्भ्य इमं दृष्टान्तं कथयामास। ");
INSERT INTO sandev_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","एकः फिरूश्यपरः करसञ्चायी द्वाविमौ प्रार्थयितुं मन्दिरं गतौ। ");
INSERT INTO sandev_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ततोऽसौ फिरूश्येकपार्श्वे तिष्ठन् हे ईश्वर अहमन्यलोकवत् लोठयितान्यायी पारदारिकश्च न भवामि अस्य करसञ्चायिनस्तुल्यश्च न, तस्मात्त्वां धन्यं वदामि। ");
INSERT INTO sandev_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","सप्तसु दिनेषु दिनद्वयमुपवसामि सर्व्वसम्पत्ते र्दशमांशं ददामि च, एतत्कथां कथयन् प्रार्थयामास। ");
INSERT INTO sandev_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","किन्तु स करसञ्चायि दूरे तिष्ठन् स्वर्गं द्रष्टुं नेच्छन् वक्षसि कराघातं कुर्व्वन् हे ईश्वर पापिष्ठं मां दयस्व, इत्थं प्रार्थयामास। ");
INSERT INTO sandev_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","युष्मानहं वदामि, तयोर्द्वयो र्मध्ये केवलः करसञ्चायी पुण्यवत्त्वेन गणितो निजगृहं जगाम, यतो यः कश्चित् स्वमुन्नमयति स नामयिष्यते किन्तु यः कश्चित् स्वं नमयति स उन्नमयिष्यते। ");
INSERT INTO sandev_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","अथ शिशूनां गात्रस्पर्शार्थं लोकास्तान् तस्य समीपमानिन्युः शिष्यास्तद् दृष्ट्वानेतृन् तर्जयामासुः, ");
INSERT INTO sandev_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","किन्तु यीशुस्तानाहूय जगाद, मन्निकटम् आगन्तुं शिशून् अनुजानीध्वं तांश्च मा वारयत; यत ईश्वरराज्याधिकारिण एषां सदृशाः। ");
INSERT INTO sandev_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","अहं युष्मान् यथार्थं वदामि, यो जनः शिशोः सदृशो भूत्वा ईश्वरराज्यं न गृह्लाति स केनापि प्रकारेण तत् प्रवेष्टुं न शक्नोति। ");
INSERT INTO sandev_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","अपरम् एकोधिपतिस्तं पप्रच्छ, हे परमगुरो, अनन्तायुषः प्राप्तये मया किं कर्त्तव्यं? ");
INSERT INTO sandev_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","यीशुरुवाच, मां कुतः परमं वदसि? ईश्वरं विना कोपि परमो न भवति। ");
INSERT INTO sandev_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","परदारान् मा गच्छ, नरं मा जहि, मा चोरय, मिथ्यासाक्ष्यं मा देहि, मातरं पितरञ्च संमन्यस्व, एता या आज्ञाः सन्ति तास्त्वं जानासि। ");
INSERT INTO sandev_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","तदा स उवाच, बाल्यकालात् सर्व्वा एता आचरामि। ");
INSERT INTO sandev_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","इति कथां श्रुत्वा यीशुस्तमवदत्, तथापि तवैकं कर्म्म न्यूनमास्ते, निजं सर्व्वस्वं विक्रीय दरिद्रेभ्यो वितर, तस्मात् स्वर्गे धनं प्राप्स्यसि; तत आगत्य ममानुगामी भव। ");
INSERT INTO sandev_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","किन्त्वेतां कथां श्रुत्वा सोधिपतिः शुशोच, यतस्तस्य बहुधनमासीत्। ");
INSERT INTO sandev_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","तदा यीशुस्तमतिशोकान्वितं दृष्ट्वा जगाद, धनवताम् ईश्वरराज्यप्रवेशः कीदृग् दुष्करः। ");
INSERT INTO sandev_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ईश्वरराज्ये धनिनः प्रवेशात् सूचेश्छिद्रेण महाङ्गस्य गमनागमने सुकरे। ");
INSERT INTO sandev_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","श्रोतारः पप्रच्छुस्तर्हि केन परित्राणं प्राप्स्यते? ");
INSERT INTO sandev_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","स उक्तवान्, यन् मानुषेणाशक्यं तद् ईश्वरेण शक्यं। ");
INSERT INTO sandev_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","तदा पितर उवाच, पश्य वयं सर्व्वस्वं परित्यज्य तव पश्चाद्गामिनोऽभवाम। ");
INSERT INTO sandev_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ततः स उवाच, युष्मानहं यथार्थं वदामि, ईश्वरराज्यार्थं गृहं पितरौ भ्रातृगणं जायां सन्तानांश्च त्यक्तवा ");
INSERT INTO sandev_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","इह काले ततोऽधिकं परकाले ऽनन्तायुश्च न प्राप्स्यति लोक ईदृशः कोपि नास्ति। ");
INSERT INTO sandev_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","अनन्तरं स द्वादशशिष्यानाहूय बभाषे, पश्यत वयं यिरूशालम्नगरं यामः, तस्मात् मनुष्यपुत्रे भविष्यद्वादिभिरुक्तं यदस्ति तदनुरूपं तं प्रति घटिष्यते; ");
INSERT INTO sandev_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","वस्तुतस्तु सोऽन्यदेशीयानां हस्तेषु समर्पयिष्यते, ते तमुपहसिष्यन्ति, अन्यायमाचरिष्यन्ति तद्वपुषि निष्ठीवं निक्षेप्स्यन्ति, कशाभिः प्रहृत्य तं हनिष्यन्ति च, ");
INSERT INTO sandev_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","किन्तु तृतीयदिने स श्मशानाद् उत्थास्यति। ");
INSERT INTO sandev_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","एतस्याः कथाया अभिप्रायं किञ्चिदपि ते बोद्धुं न शेकुः तेषां निकटेऽस्पष्टतवात् तस्यैतासां कथानाम् आशयं ते ज्ञातुं न शेकुश्च। ");
INSERT INTO sandev_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","अथ तस्मिन् यिरीहोः पुरस्यान्तिकं प्राप्ते कश्चिदन्धः पथः पार्श्व उपविश्य भिक्षाम् अकरोत् ");
INSERT INTO sandev_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","स लोकसमूहस्य गमनशब्दं श्रुत्वा तत्कारणं पृष्टवान्। ");
INSERT INTO sandev_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","नासरतीययीशुर्यातीति लोकैरुक्ते स उच्चैर्वक्तुमारेभे, ");
INSERT INTO sandev_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","हे दायूदः सन्तान यीशो मां दयस्व। ");
INSERT INTO sandev_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ततोग्रगामिनस्तं मौनी तिष्ठेति तर्जयामासुः किन्तु स पुनारुवन् उवाच, हे दायूदः सन्तान मां दयस्व। ");
INSERT INTO sandev_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","तदा यीशुः स्थगितो भूत्वा स्वान्तिके तमानेतुम् आदिदेश। ");
INSERT INTO sandev_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","ततः स तस्यान्तिकम् आगमत्, तदा स तं पप्रच्छ, त्वं किमिच्छसि? त्वदर्थमहं किं करिष्यामि? स उक्तवान्, हे प्रभोऽहं द्रष्टुं लभै। ");
INSERT INTO sandev_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","तदा यीशुरुवाच, दृष्टिशक्तिं गृहाण तव प्रत्ययस्त्वां स्वस्थं कृतवान्। ");
INSERT INTO sandev_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ततस्तत्क्षणात् तस्य चक्षुषी प्रसन्ने; तस्मात् स ईश्वरं धन्यं वदन् तत्पश्चाद् ययौ, तदालोक्य सर्व्वे लोका ईश्वरं प्रशंसितुम् आरेभिरे। ");
INSERT INTO sandev_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","यदा यीशु र्यिरीहोपुरं प्रविश्य तन्मध्येन गच्छंस्तदा ");
INSERT INTO sandev_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","सक्केयनामा करसञ्चायिनां प्रधानो धनवानेको ");
INSERT INTO sandev_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","यीशुः कीदृगिति द्रष्टुं चेष्टितवान् किन्तु खर्व्वत्वाल्लोकसंघमध्ये तद्दर्शनमप्राप्य ");
INSERT INTO sandev_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","येन पथा स यास्यति तत्पथेऽग्रे धावित्वा तं द्रष्टुम् उडुम्बरतरुमारुरोह। ");
INSERT INTO sandev_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","पश्चाद् यीशुस्तत्स्थानम् इत्वा ऊर्द्ध्वं विलोक्य तं दृष्ट्वावादीत्, हे सक्केय त्वं शीघ्रमवरोह मयाद्य त्वद्गेहे वस्तव्यं। ");
INSERT INTO sandev_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ततः स शीघ्रमवरुह्य साह्लादं तं जग्राह। ");
INSERT INTO sandev_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","तद् दृष्ट्वा सर्व्वे विवदमाना वक्तुमारेभिरे, सोतिथित्वेन दुष्टलोकगृहं गच्छति। ");
INSERT INTO sandev_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","किन्तु सक्केयो दण्डायमानो वक्तुमारेभे, हे प्रभो पश्य मम या सम्पत्तिरस्ति तदर्द्धं दरिद्रेभ्यो ददे, अपरम् अन्यायं कृत्वा कस्मादपि यदि कदापि किञ्चित् मया गृहीतं तर्हि तच्चतुर्गुणं ददामि। ");
INSERT INTO sandev_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","तदा यीशुस्तमुक्तवान् अयमपि इब्राहीमः सन्तानोऽतः कारणाद् अद्यास्य गृहे त्राणमुपस्थितं। ");
INSERT INTO sandev_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","यद् हारितं तत् मृगयितुं रक्षितुञ्च मनुष्यपुत्र आगतवान्। ");
INSERT INTO sandev_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","अथ स यिरूशालमः समीप उपातिष्ठद् ईश्वरराजत्वस्यानुष्ठानं तदैव भविष्यतीति लोकैरन्वभूयत, तस्मात् स श्रोतृभ्यः पुनर्दृष्टान्तकथाम् उत्थाप्य कथयामास। ");
INSERT INTO sandev_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","कोपि महाल्लोको निजार्थं राजत्वपदं गृहीत्वा पुनरागन्तुं दूरदेशं जगाम। ");
INSERT INTO sandev_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","यात्राकाले निजान् दशदासान् आहूय दशस्वर्णमुद्रा दत्त्वा ममागमनपर्य्यन्तं वाणिज्यं कुरुतेत्यादिदेश। ");
INSERT INTO sandev_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","किन्तु तस्य प्रजास्तमवज्ञाय मनुष्यमेनम् अस्माकमुपरि राजत्वं न कारयिव्याम इमां वार्त्तां तन्निकटे प्रेरयामासुः। ");
INSERT INTO sandev_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","अथ स राजत्वपदं प्राप्यागतवान् एकैको जनो बाणिज्येन किं लब्धवान् इति ज्ञातुं येषु दासेषु मुद्रा अर्पयत् तान् आहूयानेतुम् आदिदेश। ");
INSERT INTO sandev_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","तदा प्रथम आगत्य कथितवान्, हे प्रभो तव तयैकया मुद्रया दशमुद्रा लब्धाः। ");
INSERT INTO sandev_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","ततः स उवाच त्वमुत्तमो दासः स्वल्पेन विश्वास्यो जात इतः कारणात् त्वं दशनगराणाम् अधिपो भव। ");
INSERT INTO sandev_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","द्वितीय आगत्य कथितवान्, हे प्रभो तवैकया मुद्रया पञ्चमुद्रा लब्धाः। ");
INSERT INTO sandev_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ततः स उवाच, त्वं पञ्चानां नगराणामधिपति र्भव। ");
INSERT INTO sandev_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","ततोन्य आगत्य कथयामास, हे प्रभो पश्य तव या मुद्रा अहं वस्त्रे बद्ध्वास्थापयं सेयं। ");
INSERT INTO sandev_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","त्वं कृपणो यन्नास्थापयस्तदपि गृह्लासि, यन्नावपस्तदेव च छिनत्सि ततोहं त्वत्तो भीतः। ");
INSERT INTO sandev_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","तदा स जगाद, रे दुष्टदास तव वाक्येन त्वां दोषिणं करिष्यामि, यदहं नास्थापयं तदेव गृह्लामि, यदहं नावपञ्च तदेव छिनद्मि, एतादृशः कृपणोहमिति यदि त्वं जानासि, ");
INSERT INTO sandev_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","तर्हि मम मुद्रा बणिजां निकटे कुतो नास्थापयः? तया कृतेऽहम् आगत्य कुसीदेन सार्द्धं निजमुद्रा अप्राप्स्यम्। ");
INSERT INTO sandev_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","पश्चात् स समीपस्थान् जनान् आज्ञापयत् अस्मात् मुद्रा आनीय यस्य दशमुद्राः सन्ति तस्मै दत्त। ");
INSERT INTO sandev_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","ते प्रोचुः प्रभोऽस्य दशमुद्राः सन्ति। ");
INSERT INTO sandev_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","युष्मानहं वदामि यस्याश्रये वद्धते ऽधिकं तस्मै दायिष्यते, किन्तु यस्याश्रये न वर्द्धते तस्य यद्यदस्ति तदपि तस्मान् नायिष्यते। ");
INSERT INTO sandev_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","किन्तु ममाधिपतित्वस्य वशत्वे स्थातुम् असम्मन्यमाना ये मम रिपवस्तानानीय मम समक्षं संहरत। ");
INSERT INTO sandev_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","इत्युपदेशकथां कथयित्वा सोग्रगः सन् यिरूशालमपुरं ययौ। ");
INSERT INTO sandev_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ततो बैत्फगीबैथनीयाग्रामयोः समीपे जैतुनाद्रेरन्तिकम् इत्वा शिष्यद्वयम् इत्युक्त्वा प्रेषयामास, ");
INSERT INTO sandev_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","युवाममुं सम्मुखस्थग्रामं प्रविश्यैव यं कोपि मानुषः कदापि नारोहत् तं गर्द्दभशावकं बद्धं द्रक्ष्यथस्तं मोचयित्वानयतं। ");
INSERT INTO sandev_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","तत्र कुतो मोचयथः? इति चेत् कोपि वक्ष्यति तर्हि वक्ष्यथः प्रभेारत्र प्रयोजनम् आस्ते। ");
INSERT INTO sandev_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","तदा तौ प्ररितौ गत्वा तत्कथाानुसारेण सर्व्वं प्राप्तौ। ");
INSERT INTO sandev_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","गर्दभशावकमोचनकाले तत्वामिन ऊचुः, गर्दभशावकं कुतो मोचयथः? ");
INSERT INTO sandev_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","तावूचतुः प्रभोरत्र प्रयोजनम् आस्ते। ");
INSERT INTO sandev_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","पश्चात् तौ तं गर्दभशावकं यीशोरन्तिकमानीय तत्पृष्ठे निजवसनानि पातयित्वा तदुपरि यीशुमारोहयामासतुः। ");
INSERT INTO sandev_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","अथ यात्राकाले लोकाः पथि स्ववस्त्राणि पातयितुम् आरेभिरे। ");
INSERT INTO sandev_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","अपरं जैतुनाद्रेरुपत्यकाम् इत्वा शिष्यसंघः पूर्व्वदृष्टानि महाकर्म्माणि स्मृत्वा, ");
INSERT INTO sandev_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","यो राजा प्रभो र्नाम्नायाति स धन्यः स्वर्गे कुशलं सर्व्वोच्चे जयध्वनि र्भवतु, कथामेतां कथयित्वा सानन्दम् उचैरीश्वरं धन्यं वक्तुमारेभे। ");
INSERT INTO sandev_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","तदा लोकारण्यमध्यस्थाः कियन्तः फिरूशिनस्तत् श्रुत्वा यीशुं प्रोचुः, हे उपदेशक स्वशिष्यान् तर्जय। ");
INSERT INTO sandev_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","स उवाच, युष्मानहं वदामि यद्यमी नीरवास्तिष्ठन्ति तर्हि पाषाणा उचैः कथाः कथयिष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","पश्चात् तत्पुरान्तिकमेत्य तदवलोक्य साश्रुपातं जगाद, ");
INSERT INTO sandev_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","हा हा चेत् त्वमग्रेऽज्ञास्यथाः, तवास्मिन्नेव दिने वा यदि स्वमङ्गलम् उपालप्स्यथाः, तर्ह्युत्तमम् अभविष्यत्, किन्तु क्षणेस्मिन् तत्तव दृष्टेरगोचरम् भवति। ");
INSERT INTO sandev_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","त्वं स्वत्राणकाले न मनो न्यधत्था इति हेतो र्यत्काले तव रिपवस्त्वां चतुर्दिक्षु प्राचीरेण वेष्टयित्वा रोत्स्यन्ति ");
INSERT INTO sandev_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","बालकैः सार्द्धं भूमिसात् करिष्यन्ति च त्वन्मध्ये पाषाणैकोपि पाषाणोपरि न स्थास्यति च, काल ईदृश उपस्थास्यति। ");
INSERT INTO sandev_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","अथ मध्येमन्दिरं प्रविश्य तत्रत्यान् क्रयिविक्रयिणो बहिष्कुर्व्वन् ");
INSERT INTO sandev_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","अवदत् मद्गृहं प्रार्थनागृहमिति लिपिरास्ते किन्तु यूयं तदेव चैराणां गह्वरं कुरुथ। ");
INSERT INTO sandev_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","पश्चात् स प्रत्यहं मध्येमन्दिरम् उपदिदेश; ततः प्रधानयाजका अध्यापकाः प्राचीनाश्च तं नाशयितुं चिचेष्टिरे; ");
INSERT INTO sandev_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","किन्तु तदुपदेशे सर्व्वे लोका निविष्टचित्ताः स्थितास्तस्मात् ते तत्कर्त्तुं नावकाशं प्रापुः। ");
INSERT INTO sandev_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","अथैकदा यीशु र्मनिदरे सुसंवादं प्रचारयन् लोकानुपदिशति, एतर्हि प्रधानयाजका अध्यापकाः प्राञ्चश्च तन्निकटमागत्य पप्रच्छुः ");
INSERT INTO sandev_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","कयाज्ञया त्वं कर्म्माण्येतानि करोषि? को वा त्वामाज्ञापयत्? तदस्मान् वद। ");
INSERT INTO sandev_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","स प्रत्युवाच, तर्हि युष्मानपि कथामेकां पृच्छामि तस्योत्तरं वदत। ");
INSERT INTO sandev_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","योहनो मज्जनम् ईश्वरस्य मानुषाणां वाज्ञातो जातं? ");
INSERT INTO sandev_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ततस्ते मिथो विविच्य जगदुः, यदीश्वरस्य वदामस्तर्हि तं कुतो न प्रत्यैत स इति वक्ष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","यदि मनुष्यस्येति वदामस्तर्हि सर्व्वे लोका अस्मान् पाषाणै र्हनिष्यन्ति यतो योहन् भविष्यद्वादीति सर्व्वे दृढं जानन्ति। ");
INSERT INTO sandev_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","अतएव ते प्रत्यूचुः कस्याज्ञया जातम् इति वक्तुं न शक्नुमः। ");
INSERT INTO sandev_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","तदा यीशुरवदत् तर्हि कयाज्ञया कर्म्माण्येताति करोमीति च युष्मान् न वक्ष्यामि। ");
INSERT INTO sandev_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","अथ लोकानां साक्षात् स इमां दृष्टान्तकथां वक्तुमारेभे, कश्चिद् द्राक्षाक्षेत्रं कृत्वा तत् क्षेत्रं कृषीवलानां हस्तेषु समर्प्य बहुकालार्थं दूरदेशं जगाम। ");
INSERT INTO sandev_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","अथ फलकाले फलानि ग्रहीतु कृषीवलानां समीपे दासं प्राहिणोत् किन्तु कृषीवलास्तं प्रहृत्य रिक्तहस्तं विससर्जुः। ");
INSERT INTO sandev_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","ततः सोधिपतिः पुनरन्यं दासं प्रेषयामास, ते तमपि प्रहृत्य कुव्यवहृत्य रिक्तहस्तं विससृजुः। ");
INSERT INTO sandev_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ततः स तृतीयवारम् अन्यं प्राहिणोत् ते तमपि क्षताङ्गं कृत्वा बहि र्निचिक्षिपुः। ");
INSERT INTO sandev_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","तदा क्षेत्रपति र्विचारयामास, ममेदानीं किं कर्त्तव्यं? मम प्रिये पुत्रे प्रहिते ते तमवश्यं दृष्ट्वा समादरिष्यन्ते। ");
INSERT INTO sandev_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","किन्तु कृषीवलास्तं निरीक्ष्य परस्परं विविच्य प्रोचुः, अयमुत्तराधिकारी आगच्छतैनं हन्मस्ततोधिकारोस्माकं भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ततस्ते तं क्षेत्राद् बहि र्निपात्य जघ्नुस्तस्मात् स क्षेत्रपतिस्तान् प्रति किं करिष्यति? ");
INSERT INTO sandev_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","स आगत्य तान् कृषीवलान् हत्वा परेषां हस्तेषु तत्क्षेत्रं समर्पयिष्यति; इति कथां श्रुत्वा ते ऽवदन् एतादृशी घटना न भवतु। ");
INSERT INTO sandev_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","किन्तु यीशुस्तानवलोक्य जगाद, तर्हि, स्थपतयः करिष्यन्ति ग्रावाणं यन्तु तुच्छकं। प्रधानप्रस्तरः कोणे स एव हि भविष्यति। एतस्य शास्त्रीयवचनस्य किं तात्पर्य्यं? ");
INSERT INTO sandev_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","अपरं तत्पाषाणोपरि यः पतिष्यति स भंक्ष्यते किन्तु यस्योपरि स पाषाणः पतिष्यति स तेन धूलिवच् चूर्णीभविष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","सोस्माकं विरुद्धं दृष्टान्तमिमं कथितवान् इति ज्ञात्वा प्रधानयाजका अध्यापकाश्च तदैव तं धर्तुं ववाञ्छुः किन्तु लोकेभ्यो बिभ्युः। ");
INSERT INTO sandev_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","अतएव तं प्रति सतर्काः सन्तः कथं तद्वाक्यदोषं धृत्वा तं देशाधिपस्य साधुवेशधारिणश्चरान् तस्य समीपे प्रेषयामासुः। ");
INSERT INTO sandev_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","तदा ते तं पप्रच्छुः, हे उपदेशक भवान् यथार्थं कथयन् उपदिशति, कमप्यनपेक्ष्य सत्यत्वेनैश्वरं मार्गमुपदिशति, वयमेतज्जानीमः। ");
INSERT INTO sandev_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","कैसरराजाय करोस्माभि र्देयो न वा? ");
INSERT INTO sandev_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","स तेषां वञ्चनं ज्ञात्वावदत् कुतो मां परीक्षध्वे? मां मुद्रामेकं दर्शयत। ");
INSERT INTO sandev_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","इह लिखिता मूर्तिरियं नाम च कस्य? तेऽवदन् कैसरस्य। ");
INSERT INTO sandev_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","तदा स उवाच, तर्हि कैसरस्य द्रव्यं कैसराय दत्त; ईश्वरस्य तु द्रव्यमीश्वराय दत्त। ");
INSERT INTO sandev_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","तस्माल्लोकानां साक्षात् तत्कथायाः कमपि दोषं धर्तुमप्राप्य ते तस्योत्तराद् आश्चर्य्यं मन्यमाना मौनिनस्तस्थुः। ");
INSERT INTO sandev_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","अपरञ्च श्मशानादुत्थानानङ्गीकारिणां सिदूकिनां कियन्तो जना आगत्य तं पप्रच्छुः, ");
INSERT INTO sandev_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","हे उपदेशक शास्त्रे मूसा अस्मान् प्रतीति लिलेख यस्य भ्राता भार्य्यायां सत्यां निःसन्तानो म्रियते स तज्जायां विवह्य तद्वंशम् उत्पादयिष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","तथाच केचित् सप्त भ्रातर आसन् तेषां ज्येष्ठो भ्राता विवह्य निरपत्यः प्राणान् जहौ। ");
INSERT INTO sandev_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","अथ द्वितीयस्तस्य जायां विवह्य निरपत्यः सन् ममार। तृतीयश्च तामेव व्युवाह; ");
INSERT INTO sandev_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","इत्थं सप्त भ्रातरस्तामेव विवह्य निरपत्याः सन्तो मम्रुः। ");
INSERT INTO sandev_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","शेषे सा स्त्री च ममार। ");
INSERT INTO sandev_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","अतएव श्मशानादुत्थानकाले तेषां सप्तजनानां कस्य सा भार्य्या भविष्यति? यतः सा तेषां सप्तानामेव भार्य्यासीत्। ");
INSERT INTO sandev_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","तदा यीशुः प्रत्युवाच, एतस्य जगतो लोका विवहन्ति वाग्दत्ताश्च भवन्ति ");
INSERT INTO sandev_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","किन्तु ये तज्जगत्प्राप्तियोग्यत्वेन गणितां भविष्यन्ति श्मशानाच्चोत्थास्यन्ति ते न विवहन्ति वाग्दत्ताश्च न भवन्ति, ");
INSERT INTO sandev_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ते पुन र्न म्रियन्ते किन्तु श्मशानादुत्थापिताः सन्त ईश्वरस्य सन्तानाः स्वर्गीयदूतानां सदृशाश्च भवन्ति। ");
INSERT INTO sandev_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","अधिकन्तु मूसाः स्तम्बोपाख्याने परमेश्वर ईब्राहीम ईश्वर इस्हाक ईश्वरो याकूबश्चेश्वर इत्युक्त्वा मृतानां श्मशानाद् उत्थानस्य प्रमाणं लिलेख। ");
INSERT INTO sandev_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","अतएव य ईश्वरः स मृतानां प्रभु र्न किन्तु जीवतामेव प्रभुः, तन्निकटे सर्व्वे जीवन्तः सन्ति। ");
INSERT INTO sandev_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","इति श्रुत्वा कियन्तोध्यापका ऊचुः, हे उपदेशक भवान् भद्रं प्रत्युक्तवान्। ");
INSERT INTO sandev_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","इतः परं तं किमपि प्रष्टं तेषां प्रगल्भता नाभूत्। ");
INSERT INTO sandev_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","पश्चात् स तान् उवाच, यः ख्रीष्टः स दायूदः सन्तान एतां कथां लोकाः कथं कथयन्ति? ");
INSERT INTO sandev_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","यतः मम प्रभुमिदं वाक्यमवदत् परमेश्वरः। तव शत्रूनहं यावत् पादपीठं करोमि न। तावत् कालं मदीये त्वं दक्षपार्श्व उपाविश। ");
INSERT INTO sandev_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","इति कथां दायूद् स्वयं गीतग्रन्थेऽवदत्। ");
INSERT INTO sandev_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","अतएव यदि दायूद् तं प्रभुं वदति, तर्हि स कथं तस्य सन्तानो भवति? ");
INSERT INTO sandev_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","पश्चाद् यीशुः सर्व्वजनानां कर्णगोचरे शिष्यानुवाच, ");
INSERT INTO sandev_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","येऽध्यापका दीर्घपरिच्छदं परिधाय भ्रमन्ति, हट्टापणयो र्नमस्कारे भजनगेहस्य प्रोच्चासने भोजनगृहस्य प्रधानस्थाने च प्रीयन्ते ");
INSERT INTO sandev_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","विधवानां सर्व्वस्वं ग्रसित्वा छलेन दीर्घकालं प्रार्थयन्ते च तेषु सावधाना भवत, तेषामुग्रदण्डो भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","अथ धनिलोका भाण्डागारे धनं निक्षिपन्ति स तदेव पश्यति, ");
INSERT INTO sandev_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","एतर्हि काचिद्दीना विधवा पणद्वयं निक्षिपति तद् ददर्श। ");
INSERT INTO sandev_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ततो यीशुरुवाच युष्मानहं यथार्थं वदामि, दरिद्रेयं विधवा सर्व्वेभ्योधिकं न्यक्षेप्सीत्, ");
INSERT INTO sandev_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","यतोन्ये स्वप्राज्यधनेभ्य ईश्वराय किञ्चित् न्यक्षेप्सुः, किन्तु दरिद्रेयं विधवा दिनयापनार्थं स्वस्य यत् किञ्चित् स्थितं तत् सर्व्वं न्यक्षेप्सीत्। ");
INSERT INTO sandev_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","अपरञ्च उत्तमप्रस्तरैरुत्सृष्टव्यैश्च मन्दिरं सुशोभतेतरां कैश्चिदित्युक्ते स प्रत्युवाच ");
INSERT INTO sandev_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","यूयं यदिदं निचयनं पश्यथ, अस्य पाषाणैकोप्यन्यपाषाणोपरि न स्थास्यति, सर्व्वे भूसाद्भविष्यन्ति कालोयमायाति। ");
INSERT INTO sandev_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","तदा ते पप्रच्छुः, हे गुरो घटनेदृशी कदा भविष्यति? घटनाया एतस्यसश्चिह्नं वा किं भविष्यति? ");
INSERT INTO sandev_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","तदा स जगाद, सावधाना भवत यथा युष्माकं भ्रमं कोपि न जनयति, खीष्टोहमित्युक्त्वा मम नाम्रा बहव उपस्थास्यन्ति स कालः प्रायेणोपस्थितः, तेषां पश्चान्मा गच्छत। ");
INSERT INTO sandev_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","युद्धस्योपप्लवस्य च वार्त्तां श्रुत्वा मा शङ्कध्वं, यतः प्रथमम् एता घटना अवश्यं भविष्यन्ति किन्तु नापाते युगान्तो भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","अपरञ्च कथयामास, तदा देशस्य विपक्षत्वेन देशो राज्यस्य विपक्षत्वेन राज्यम् उत्थास्यति, ");
INSERT INTO sandev_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","नानास्थानेषु महाभूकम्पो दुर्भिक्षं मारी च भविष्यन्ति, तथा व्योममण्डलस्य भयङ्करदर्शनान्यश्चर्य्यलक्षणानि च प्रकाशयिष्यन्ते। ");
INSERT INTO sandev_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","किन्तु सर्व्वासामेतासां घटनानां पूर्व्वं लोका युष्मान् धृत्वा ताडयिष्यन्ति, भजनालये कारायाञ्च समर्पयिष्यन्ति मम नामकारणाद् युष्मान् भूपानां शासकानाञ्च सम्मुखं नेष्यन्ति च। ");
INSERT INTO sandev_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","साक्ष्यार्थम् एतानि युष्मान् प्रति घटिष्यन्ते। ");
INSERT INTO sandev_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","तदा किमुत्तरं वक्तव्यम् एतत् न चिन्तयिष्याम इति मनःसु निश्चितनुत। ");
INSERT INTO sandev_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","विपक्षा यस्मात् किमप्युत्तरम् आपत्तिञ्च कर्त्तुं न शक्ष्यन्ति तादृशं वाक्पटुत्वं ज्ञानञ्च युष्मभ्यं दास्यामि। ");
INSERT INTO sandev_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","किञ्च यूयं पित्रा मात्रा भ्रात्रा बन्धुना ज्ञात्या कुटुम्बेन च परकरेषु समर्पयिष्यध्वे; ततस्ते युष्माकं कञ्चन कञ्चन घातयिष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","मम नाम्नः कारणात् सर्व्वै र्मनुष्यै र्यूयम् ऋतीयिष्यध्वे। ");
INSERT INTO sandev_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","किन्तु युष्माकं शिरःकेशैकोपि न विनंक्ष्यति, ");
INSERT INTO sandev_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","तस्मादेव धैर्य्यमवलम्ब्य स्वस्वप्राणान् रक्षत। ");
INSERT INTO sandev_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","अपरञ्च यिरूशालम्पुरं सैन्यवेष्टितं विलोक्य तस्योच्छिन्नतायाः समयः समीप इत्यवगमिष्यथ। ");
INSERT INTO sandev_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","तदा यिहूदादेशस्था लोकाः पर्व्वतं पलायन्तां, ये च नगरे तिष्ठन्ति ते देशान्तरं पलायन्ता, ये च ग्रामे तिष्ठन्ति ते नगरं न प्रविशन्तु, ");
INSERT INTO sandev_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","यतस्तदा समुचितदण्डनाय धर्म्मपुस्तके यानि सर्व्वाणि लिखितानि तानि सफलानि भविष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","किन्तु या यास्तदा गर्भवत्यः स्तन्यदाव्यश्च तामां दुर्गति र्भविष्यति, यत एताल्लोकान् प्रति कोपो देशे च विषमदुर्गति र्घटिष्यते। ");
INSERT INTO sandev_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","वस्तुतस्तु ते खङ्गधारपरिव्वङ्गं लप्स्यन्ते बद्धाः सन्तः सर्व्वदेशेषु नायिष्यन्ते च किञ्चान्यदेशीयानां समयोपस्थितिपर्य्यन्तं यिरूशालम्पुरं तैः पदतलै र्दलयिष्यते। ");
INSERT INTO sandev_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","सूर्य्यचन्द्रनक्षत्रेषु लक्षणादि भविष्यन्ति, भुवि सर्व्वदेशीयानां दुःखं चिन्ता च सिन्धौ वीचीनां तर्जनं गर्जनञ्च भविष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","भूभौ भाविघटनां चिन्तयित्वा मनुजा भियामृतकल्पा भविष्यन्ति, यतो व्योममण्डले तेजस्विनो दोलायमाना भविष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","तदा पराक्रमेणा महातेजसा च मेघारूढं मनुष्यपुत्रम् आयान्तं द्रक्ष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","किन्त्वेतासां घटनानामारम्भे सति यूयं मस्तकान्युत्तोल्य ऊर्दध्वं द्रक्ष्यथ, यतो युष्माकं मुक्तेः कालः सविधो भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ततस्तेनैतदृष्टान्तकथा कथिता, पश्यत उडुम्बरादिवृक्षाणां ");
INSERT INTO sandev_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","नवीनपत्राणि जातानीति दृष्ट्वा निदावकाल उपस्थित इति यथा यूयं ज्ञातुं शक्नुथ, ");
INSERT INTO sandev_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","तथा सर्व्वासामासां घटनानाम् आरम्भे दृष्टे सतीश्वरस्य राजत्वं निकटम् इत्यपि ज्ञास्यथ। ");
INSERT INTO sandev_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","युष्मानहं यथार्थं वदामि, विद्यमानलोकानामेषां गमनात् पूर्व्वम् एतानि घटिष्यन्ते। ");
INSERT INTO sandev_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","नभोभुवोर्लोपो भविष्यति मम वाक् तु कदापि लुप्ता न भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","अतएव विषमाशनेन पानेन च सांमारिकचिन्ताभिश्च युष्माकं चित्तेषु मत्तेषु तद्दिनम् अकस्माद् युष्मान् प्रति यथा नोपतिष्ठति तदर्थं स्वेषु सावधानास्तिष्ठत। ");
INSERT INTO sandev_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","पृथिवीस्थसर्व्वलोकान् प्रति तद्दिनम् उन्माथ इव उपस्थास्यति। ");
INSERT INTO sandev_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","यथा यूयम् एतद्भाविघटना उत्तर्त्तुं मनुजसुतस्य सम्मुखे संस्थातुञ्च योग्या भवथ कारणादस्मात् सावधानाः सन्तो निरन्तरं प्रार्थयध्वं। ");
INSERT INTO sandev_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","अपरञ्च स दिवा मन्दिर उपदिश्य राचै जैतुनाद्रिं गत्वातिष्ठत्। ");
INSERT INTO sandev_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ततः प्रत्यूषे लाकास्तत्कथां श्रोतुं मन्दिरे तदन्तिकम् आगच्छन्। ");
INSERT INTO sandev_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","अपरञ्च किण्वशून्यपूपोत्सवस्य काल उपस्थिते ");
INSERT INTO sandev_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","प्रधानयाजका अध्यायकाश्च यथा तं हन्तुं शक्नुवन्ति तथोपायाम् अचेष्टन्त किन्तु लोकेभ्यो बिभ्युः। ");
INSERT INTO sandev_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","एतस्तिन् समये द्वादशशिष्येषु गणित ईष्करियोतीयरूढिमान् यो यिहूदास्तस्यान्तःकरणं शैतानाश्रितत्वात् ");
INSERT INTO sandev_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","स गत्वा यथा यीशुं तेषां करेषु समर्पयितुं शक्नोति तथा मन्त्रणां प्रधानयाजकैः सेनापतिभिश्च सह चकार। ");
INSERT INTO sandev_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","तेन ते तुष्टास्तस्मै मुद्रां दातुं पणं चक्रुः। ");
INSERT INTO sandev_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ततः सोङ्गीकृत्य यथा लोकानामगोचरे तं परकरेषु समर्पयितुं शक्नोति तथावकाशं चेष्टितुमारेभे। ");
INSERT INTO sandev_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","अथ किण्वशून्यपूपोत्मवदिने, अर्थात् यस्मिन् दिने निस्तारोत्सवस्य मेषो हन्तव्यस्तस्मिन् दिने ");
INSERT INTO sandev_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","यीशुः पितरं योहनञ्चाहूय जगाद, युवां गत्वास्माकं भोजनार्थं निस्तारोत्सवस्य द्रव्याण्यासादयतं। ");
INSERT INTO sandev_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","तदा तौ पप्रच्छतुः कुचासादयावो भवतः केच्छा? ");
INSERT INTO sandev_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","तदा सोवादीत्, नगरे प्रविष्टे कश्चिज्जलकुम्भमादाय युवां साक्षात् करिष्यति स यन्निवेशनं प्रविशति युवामपि तन्निवेशनं तत्पश्चादित्वा निवेशनपतिम् इति वाक्यं वदतं, ");
INSERT INTO sandev_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","यत्राहं निस्तारोत्सवस्य भोज्यं शिष्यैः सार्द्धं भोक्तुं शक्नोमि सातिथिशालाा कुत्र? कथामिमां प्रभुस्त्वां पृच्छति। ");
INSERT INTO sandev_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ततः स जनो द्वितीयप्रकोष्ठीयम् एकं शस्तं कोष्ठं दर्शयिष्यति तत्र भोज्यमासादयतं। ");
INSERT INTO sandev_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ततस्तौ गत्वा तद्वाक्यानुसारेण सर्व्वं दृष्द्वा तत्र निस्तारोत्सवीयं भोज्यमासादयामासतुः। ");
INSERT INTO sandev_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","अथ काल उपस्थिते यीशु र्द्वादशभिः प्रेरितैः सह भोक्तुमुपविश्य कथितवान् ");
INSERT INTO sandev_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","मम दुःखभोगात् पूर्व्वं युभाभिः सह निस्तारोत्सवस्यैतस्य भोज्यं भोक्तुं मयातिवाञ्छा कृता। ");
INSERT INTO sandev_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","युष्मान् वदामि, यावत्कालम् ईश्वरराज्ये भोजनं न करिष्ये तावत्कालम् इदं न भोक्ष्ये। ");
INSERT INTO sandev_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","तदा स पानपात्रमादाय ईश्वरस्य गुणान् कीर्त्तयित्वा तेभ्यो दत्वावदत्, इदं गृह्लीत यूयं विभज्य पिवत। ");
INSERT INTO sandev_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","युष्मान् वदामि यावत्कालम् ईश्वरराजत्वस्य संस्थापनं न भवति तावद् द्राक्षाफलरसं न पास्यामि। ");
INSERT INTO sandev_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ततः पूपं गृहीत्वा ईश्वरगुणान् कीर्त्तयित्वा भङ्क्ता तेभ्यो दत्वावदत्, युष्मदर्थं समर्पितं यन्मम वपुस्तदिदं, एतत् कर्म्म मम स्मरणार्थं कुरुध्वं। ");
INSERT INTO sandev_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","अथ भोजनान्ते तादृशं पात्रं गृहीत्वावदत्, युष्मत्कृते पातितं यन्मम रक्तं तेन निर्णीतनवनियमरूपं पानपात्रमिदं। ");
INSERT INTO sandev_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","पश्यत यो मां परकरेषु समर्पयिष्यति स मया सह भोजनासन उपविशति। ");
INSERT INTO sandev_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","यथा निरूपितमास्ते तदनुसारेणा मनुष्यपुुत्रस्य गति र्भविष्यति किन्तु यस्तं परकरेषु समर्पयिष्यति तस्य सन्तापो भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","तदा तेषां को जन एतत् कर्म्म करिष्यति तत् ते परस्परं प्रष्टुमारेभिरे। ");
INSERT INTO sandev_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","अपरं तेषां को जनः श्रेष्ठत्वेन गणयिष्यते, अत्रार्थे तेषां विवादोभवत्। ");
INSERT INTO sandev_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","अस्मात् कारणात् सोवदत्, अन्यदेशीयानां राजानः प्रजानामुपरि प्रभुत्वं कुर्व्वन्ति दारुणशासनं कृत्वापि ते भूपतित्वेन विख्याता भवन्ति च। ");
INSERT INTO sandev_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","किन्तु युष्माकं तथा न भविष्यति, यो युष्माकं श्रेष्ठो भविष्यति स कनिष्ठवद् भवतु, यश्च मुख्यो भविष्यति स सेवकवद्भवतु। ");
INSERT INTO sandev_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","भोजनोपविष्टपरिचारकयोः कः श्रेष्ठः? यो भोजनायोपविशति स किं श्रेष्ठो न भवति? किन्तु युष्माकं मध्येऽहं परिचारकइवास्मि। ");
INSERT INTO sandev_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","अपरञ्च युयं मम परीक्षाकाले प्रथममारभ्य मया सह स्थिता ");
INSERT INTO sandev_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","एतत्कारणात् पित्रा यथा मदर्थं राज्यमेकं निरूपितं तथाहमपि युष्मदर्थं राज्यं निरूपयामि। ");
INSERT INTO sandev_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","तस्मान् मम राज्ये भोजनासने च भोजनपाने करिष्यध्वे सिंहासनेषूपविश्य चेस्रायेलीयानां द्वादशवंशानां विचारं करिष्यध्वे। ");
INSERT INTO sandev_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","अपरं प्रभुरुवाच, हे शिमोन् पश्य तितउना धान्यानीव युष्मान् शैतान् चालयितुम् ऐच्छत्, ");
INSERT INTO sandev_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","किन्तु तव विश्वासस्य लोपो यथा न भवति एतत् त्वदर्थं प्रार्थितं मया, त्वन्मनसि परिवर्त्तिते च भ्रातृणां मनांसि स्थिरीकुरु। ");
INSERT INTO sandev_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","तदा सोवदत्, हे प्रभोहं त्वया सार्द्धं कारां मृतिञ्च यातुं मज्जितोस्मि। ");
INSERT INTO sandev_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ततः स उवाच, हे पितर त्वां वदामि, अद्य कुक्कुटरवात् पूर्व्वं त्वं मत्परिचयं वारत्रयम् अपह्वोष्यसे। ");
INSERT INTO sandev_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","अपरं स पप्रच्छ, यदा मुद्रासम्पुटं खाद्यपात्रं पादुकाञ्च विना युष्मान् प्राहिणवं तदा युष्माकं कस्यापि न्यूनतासीत्? ते प्रोचुः कस्यापि न। ");
INSERT INTO sandev_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","तदा सोवदत् किन्त्विदानीं मुद्रासम्पुटं खाद्यपात्रं वा यस्यास्ति तेन तद्ग्रहीतव्यं, यस्य च कृपाणोे नास्ति तेन स्ववस्त्रं विक्रीय स क्रेतव्यः। ");
INSERT INTO sandev_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","यतो युष्मानहं वदामि, अपराधिजनैः सार्द्धं गणितः स भविष्यति। इदं यच्छास्त्रीयं वचनं लिखितमस्ति तन्मयि फलिष्यति यतो मम सम्बन्धीयं सर्व्वं सेत्स्यति। ");
INSERT INTO sandev_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","तदा ते प्रोचुः प्रभो पश्य इमौ कृपाणौ। ततः सोवदद् एतौ यथेष्टौ। ");
INSERT INTO sandev_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","अथ स तस्माद्वहि र्गत्वा स्वाचारानुसारेण जैतुननामाद्रिं जगाम शिष्याश्च तत्पश्चाद् ययुः। ");
INSERT INTO sandev_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","तत्रोपस्थाय स तानुवाच, यथा परीक्षायां न पतथ तदर्थं प्रार्थयध्वं। ");
INSERT INTO sandev_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","पश्चात् स तस्माद् एकशरक्षेपाद् बहि र्गत्वा जानुनी पातयित्वा एतत् प्रार्थयाञ्चक्रे, ");
INSERT INTO sandev_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","हे पित र्यदि भवान् सम्मन्यते तर्हि कंसमेनं ममान्तिकाद् दूरय किन्तु मदिच्छानुरूपं न त्वदिच्छानुरूपं भवतु। ");
INSERT INTO sandev_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","तदा तस्मै शक्तिं दातुं स्वर्गीयदूतो दर्शनं ददौ। ");
INSERT INTO sandev_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","पश्चात् सोत्यन्तं यातनया व्याकुलो भूत्वा पुनर्दृढं प्रार्थयाञ्चक्रे, तस्माद् बृहच्छोणितबिन्दव इव तस्य स्वेदबिन्दवः पृथिव्यां पतितुमारेभिरे। ");
INSERT INTO sandev_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","अथ प्रार्थनात उत्थाय शिष्याणां समीपमेत्य तान् मनोदुःखिनो निद्रितान् दृष्ट्वावदत् ");
INSERT INTO sandev_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","कुतो निद्राथ? परीक्षायाम् अपतनार्थं प्रर्थयध्वं। ");
INSERT INTO sandev_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","एतत्कथायाः कथनकाले द्वादशशिष्याणां मध्ये गणितो यिहूदानामा जनतासहितस्तेषाम् अग्रे चलित्वा यीशोश्चुम्बनार्थं तदन्तिकम् आययौ। ");
INSERT INTO sandev_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","तदा यीशुरुवाच, हे यिहूदा किं चुम्बनेन मनुष्यपुत्रं परकरेषु समर्पयसि? ");
INSERT INTO sandev_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","तदा यद्यद् घटिष्यते तदनुमाय सङ्गिभिरुक्तं, हे प्रभो वयं कि खङ्गेन घातयिष्यामः? ");
INSERT INTO sandev_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","तत एकः करवालेनाहत्य प्रधानयाजकस्य दासस्य दक्षिणं कर्णं चिच्छेद। ");
INSERT INTO sandev_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","अधूना निवर्त्तस्व इत्युक्त्वा यीशुस्तस्य श्रुतिं स्पृष्ट्वा स्वस्यं चकार। ");
INSERT INTO sandev_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","पश्चाद् यीशुः समीपस्थान् प्रधानयाजकान् मन्दिरस्य सेनापतीन् प्राचीनांश्च जगाद, यूयं कृपाणान् यष्टींश्च गृहीत्वा मां किं चोरं धर्त्तुमायाताः? ");
INSERT INTO sandev_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","यदाहं युष्माभिः सह प्रतिदिनं मन्दिरेऽतिष्ठं तदा मां धर्त्तं न प्रवृत्ताः, किन्त्विदानीं युष्माकं समयोन्धकारस्य चाधिपत्यमस्ति। ");
INSERT INTO sandev_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","अथ ते तं धृत्वा महायाजकस्य निवेशनं निन्युः। ततः पितरो दूरे दूरे पश्चादित्वा ");
INSERT INTO sandev_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","बृहत्कोष्ठस्य मध्ये यत्राग्निं ज्वालयित्वा लोकाः समेत्योपविष्टास्तत्र तैः सार्द्धम् उपविवेश। ");
INSERT INTO sandev_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","अथ वह्निसन्निधौ समुपवेशकाले काचिद्दासी मनो निविश्य तं निरीक्ष्यावदत् पुमानयं तस्य सङ्गेऽस्थात्। ");
INSERT INTO sandev_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","किन्तु स तद् अपह्नुत्यावादीत् हे नारि तमहं न परिचिनोमि। ");
INSERT INTO sandev_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","क्षणान्तरेऽन्यजनस्तं दृष्ट्वाब्रवीत् त्वमपि तेषां निकरस्यैकजनोसि। पितरः प्रत्युवाच हे नर नाहमस्मि। ");
INSERT INTO sandev_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ततः सार्द्धदण्डद्वयात् परं पुनरन्यो जनो निश्चित्य बभाषे, एष तस्य सङ्गीति सत्यं यतोयं गालीलीयो लोकः। ");
INSERT INTO sandev_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","तदा पितर उवाच हे नर त्वं यद् वदमि तदहं बोद्धुं न शक्नोमि, इति वाक्ये कथितमात्रे कुक्कुटो रुराव। ");
INSERT INTO sandev_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","तदा प्रभुणा व्याधुट्य पितरे निरीक्षिते कृकवाकुरवात् पूर्व्वं मां त्रिरपह्नोष्यसे इति पूर्व्वोक्तं तस्य वाक्यं पितरः स्मृत्वा ");
INSERT INTO sandev_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","बहिर्गत्वा महाखेदेन चक्रन्द। ");
INSERT INTO sandev_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","तदा यै र्यीशुर्धृतस्ते तमुपहस्य प्रहर्त्तुमारेभिरे। ");
INSERT INTO sandev_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","वस्त्रेण तस्य दृशौ बद्ध्वा कपोले चपेटाघातं कृत्वा पप्रच्छुः, कस्ते कपोले चपेटाघातं कृतवान? गणयित्वा तद् वद। ");
INSERT INTO sandev_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","तदन्यत् तद्विरुद्धं बहुनिन्दावाक्यं वक्तुमारेभिरे। ");
INSERT INTO sandev_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","अथ प्रभाते सति लोकप्राञ्चः प्रधानयाजका अध्यापकाश्च सभां कृत्वा मध्येसभं यीशुमानीय पप्रच्छुः, त्वम् अभिषिकतोसि न वास्मान् वद। ");
INSERT INTO sandev_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","स प्रत्युवाच, मया तस्मिन्नुक्तेऽपि यूयं न विश्वसिष्यथ। ");
INSERT INTO sandev_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","कस्मिंश्चिद्वाक्ये युष्मान् पृष्टेऽपि मां न तदुत्तरं वक्ष्यथ न मां त्यक्ष्यथ च। ");
INSERT INTO sandev_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","किन्त्वितः परं मनुजसुतः सर्व्वशक्तिमत ईश्वरस्य दक्षिणे पार्श्वे समुपवेक्ष्यति। ");
INSERT INTO sandev_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ततस्ते पप्रच्छुः, र्तिह त्वमीश्वरस्य पुत्रः? स कथयामास, यूयं यथार्थं वदथ स एवाहं। ");
INSERT INTO sandev_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","तदा ते सर्व्वे कथयामासुः, र्तिह साक्ष्येऽन्सस्मिन् अस्माकं किं प्रयोजनं? अस्य स्वमुखादेव साक्ष्यं प्राप्तम्। ");
INSERT INTO sandev_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ततः सभास्थाः सर्व्वलोका उत्थाय तं पीलातसम्मुखं नीत्वाप्रोद्य वक्तुमारेभिरे, ");
INSERT INTO sandev_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","स्वमभिषिक्तं राजानं वदन्तं कैमरराजाय करदानं निषेधन्तं राज्यविपर्य्ययं कुर्त्तुं प्रवर्त्तमानम् एन प्राप्ता वयं। ");
INSERT INTO sandev_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","तदा पीलातस्तं पृष्टवान् त्वं किं यिहूदीयानां राजा? स प्रत्युवाच त्वं सत्यमुक्तवान्। ");
INSERT INTO sandev_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","तदा पीलातः प्रधानयाजकादिलोकान् जगाद्, अहमेतस्य कमप्यपराधं नाप्तवान्। ");
INSERT INTO sandev_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","ततस्ते पुनः साहमिनो भूत्वावदन्, एष गालील एतत्स्थानपर्य्यन्ते सर्व्वस्मिन् यिहूदादेशे सर्व्वाल्लोकानुपदिश्य कुप्रवृत्तिं ग्राहीतवान्। ");
INSERT INTO sandev_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","तदा पीलातो गालीलप्रदेशस्य नाम श्रुत्वा पप्रच्छ, किमयं गालीलीयो लोकः? ");
INSERT INTO sandev_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ततः स गालील्प्रदेशीयहेरोद्राजस्य तदा स्थितेस्तस्य समीपे यीशुं प्रेषयामास। ");
INSERT INTO sandev_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","तदा हेरोद् यीशुं विलोक्य सन्तुतोष, यतः स तस्य बहुवृत्तान्तश्रवणात् तस्य किञि्चदाश्चर्य्यकर्म्म पश्यति इत्याशां कृत्वा बहुकालमारभ्य तं द्रष्टुं प्रयासं कृतवान्। ");
INSERT INTO sandev_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","तस्मात् तं बहुकथाः पप्रच्छ किन्तु स तस्य कस्यापि वाक्यस्य प्रत्युत्तरं नोवाच। ");
INSERT INTO sandev_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","अथ प्रधानयाजका अध्यापकाश्च प्रोत्तिष्ठन्तः साहसेन तमपवदितुं प्रारेभिरे। ");
INSERT INTO sandev_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","हेरोद् तस्य सेनागणश्च तमवज्ञाय उपहासत्वेन राजवस्त्रं परिधाप्य पुनः पीलातं प्रति तं प्राहिणोत्। ");
INSERT INTO sandev_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","पूर्व्वं हेरोद्पीलातयोः परस्परं वैरभाव आसीत् किन्तु तद्दिने द्वयो र्मेलनं जातम्। ");
INSERT INTO sandev_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","पश्चात् पीलातः प्रधानयाजकान् शासकान् लोकांश्च युगपदाहूय बभाषे, ");
INSERT INTO sandev_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","राज्यविपर्य्ययकारकोयम् इत्युक्त्वा मनुष्यमेनं मम निकटमानैष्ट किन्तु पश्यत युष्माकं समक्षम् अस्य विचारं कृत्वापि प्रोक्तापवादानुरूपेणास्य कोप्यपराधः सप्रमाणो न जातः, ");
INSERT INTO sandev_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","यूयञ्च हेरोदः सन्निधौ प्रेषिता मया तत्रास्य कोप्यपराधस्तेनापि न प्राप्तः।पश्यतानेन वधहेेतुकं किमपि नापराद्धं। ");
INSERT INTO sandev_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","तस्मादेनं ताडयित्वा विहास्यामि। ");
INSERT INTO sandev_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","तत्रोत्सवे तेषामेको मोचयितव्यः। ");
INSERT INTO sandev_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","इति हेतोस्ते प्रोच्चैरेकदा प्रोचुः, एनं दूरीकृत्य बरब्बानामानं मोचय। ");
INSERT INTO sandev_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","स बरब्बा नगर उपप्लववधापराधाभ्यां कारायां बद्ध आसीत्। ");
INSERT INTO sandev_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","किन्तु पीलातो यीशुं मोचयितुं वाञ्छन् पुनस्तानुवाच। ");
INSERT INTO sandev_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","तथाप्येनं क्रुशे व्यध क्रुशे व्यधेति वदन्तस्ते रुरुवुः। ");
INSERT INTO sandev_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ततः स तृतीयवारं जगाद कुतः? स किं कर्म्म कृतवान्? नाहमस्य कमपि वधापराधं प्राप्तः केवलं ताडयित्वामुं त्यजामि। ");
INSERT INTO sandev_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","तथापि ते पुनरेनं क्रुशे व्यध इत्युक्त्वा प्रोच्चैर्दृढं प्रार्थयाञ्चक्रिरे; ");
INSERT INTO sandev_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ततः प्रधानयाजकादीनां कलरवे प्रबले सति तेषां प्रार्थनारूपं कर्त्तुं पीलात आदिदेश। ");
INSERT INTO sandev_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","राजद्रोहवधयोरपराधेन कारास्थं यं जनं ते ययाचिरे तं मोचयित्वा यीशुं तेषामिच्छायां समार्पयत्। ");
INSERT INTO sandev_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","अथ ते यीशुं गृहीत्वा यान्ति, एतर्हि ग्रामादागतं शिमोननामानं कुरीणीयं जनं धृत्वा यीशोः पश्चान्नेतुं तस्य स्कन्धे क्रुशमर्पयामासुः। ");
INSERT INTO sandev_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ततो लोाकारण्यमध्ये बहुस्त्रियो रुदत्यो विलपन्त्यश्च यीशोः पश्चाद् ययुः। ");
INSERT INTO sandev_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","किन्तु स व्याघुट्य ता उवाच, हे यिरूशालमो नार्य्यो युयं मदर्थं न रुदित्वा स्वार्थं स्वापत्यार्थञ्च रुदिति; ");
INSERT INTO sandev_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","पश्यत यः कदापि गर्भवत्यो नाभवन् स्तन्यञ्च नापाययन् तादृशी र्वन्ध्या यदा धन्या वक्ष्यन्ति स काल आयाति। ");
INSERT INTO sandev_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","तदा हे शैला अस्माकमुपरि पतत, हे उपशैला अस्मानाच्छादयत कथामीदृशीं लोका वक्ष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","यतः सतेजसि शाखिनि चेदेतद् घटते तर्हि शुष्कशाखिनि किं न घटिष्यते? ");
INSERT INTO sandev_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","तदा ते हन्तुं द्वावपराधिनौ तेन सार्द्धं निन्युः। ");
INSERT INTO sandev_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","अपरं शिरःकपालनामकस्थानं प्राप्य तं क्रुशे विविधुः; तद्द्वयोरपराधिनोरेकं तस्य दक्षिणो तदन्यं वामे क्रुशे विविधुः। ");
INSERT INTO sandev_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","तदा यीशुरकथयत्, हे पितरेतान् क्षमस्व यत एते यत् कर्म्म कुर्व्वन्ति तन् न विदुः; पश्चात्ते गुटिकापातं कृत्वा तस्य वस्त्राणि विभज्य जगृहुः। ");
INSERT INTO sandev_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","तत्र लोकसंघस्तिष्ठन् ददर्श; ते तेषां शासकाश्च तमुपहस्य जगदुः, एष इतरान् रक्षितवान् यदीश्वरेणाभिरुचितो ऽभिषिक्तस्त्राता भवति तर्हि स्वमधुना रक्षतु। ");
INSERT INTO sandev_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","तदन्यः सेनागणा एत्य तस्मै अम्लरसं दत्वा परिहस्य प्रोवाच, ");
INSERT INTO sandev_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","चेत्त्वं यिहूदीयानां राजासि तर्हि स्वं रक्ष। ");
INSERT INTO sandev_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","यिहूदीयानां राजेति वाक्यं यूनानीयरोमीयेब्रीयाक्षरै र्लिखितं तच्छिरस ऊर्द्ध्वेऽस्थाप्यत। ");
INSERT INTO sandev_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","तदोभयपार्श्वयो र्विद्धौ यावपराधिनौ तयोरेकस्तं विनिन्द्य बभाषे, चेत्त्वम् अभिषिक्तोसि तर्हि स्वमावाञ्च रक्ष। ");
INSERT INTO sandev_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","किन्त्वन्यस्तं तर्जयित्वावदत्, ईश्वरात्तव किञ्चिदपि भयं नास्ति किं? त्वमपि समानदण्डोसि, ");
INSERT INTO sandev_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","योग्यपात्रे आवां स्वस्वकर्म्मणां समुचितफलं प्राप्नुवः किन्त्वनेन किमपि नापराद्धं। ");
INSERT INTO sandev_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","अथ स यीशुं जगाद हे प्रभे भवान् स्वराज्यप्रवेशकाले मां स्मरतु। ");
INSERT INTO sandev_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","तदा यीशुः कथितवान् त्वां यथार्थं वदामि त्वमद्यैव मया सार्द्धं परलोकस्य सुखस्थानं प्राप्स्यसि। ");
INSERT INTO sandev_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","अपरञ्च द्वितीययामात् तृतीययामपर्य्यन्तं रवेस्तेजसोन्तर्हितत्वात् सर्व्वदेशोऽन्धकारेणावृतो ");
INSERT INTO sandev_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","मन्दिरस्य यवनिका च छिद्यमाना द्विधा बभूव। ");
INSERT INTO sandev_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ततो यीशुरुच्चैरुवाच, हे पित र्ममात्मानं तव करे समर्पये, इत्युक्त्वा स प्राणान् जहौ। ");
INSERT INTO sandev_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","तदैता घटना दृष्ट्वा शतसेनापतिरीश्वरं धन्यमुक्त्वा कथितवान् अयं नितान्तं साधुमनुष्य आसीत्। ");
INSERT INTO sandev_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","अथ यावन्तो लोका द्रष्टुम् आगतास्ते ता घटना दृष्ट्वा वक्षःसु कराघातं कृत्वा व्याचुट्य गताः। ");
INSERT INTO sandev_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","यीशो र्ज्ञातयो या या योषितश्च गालीलस्तेन सार्द्धमायातास्ता अपि दूरे स्थित्वा तत् सर्व्वं ददृशुः। ");
INSERT INTO sandev_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","तदा यिहूदीयानां मन्त्रणां क्रियाञ्चासम्मन्यमान ईश्वरस्य राजत्वम् अपेक्षमाणो ");
INSERT INTO sandev_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","यिहूदिदेशीयो ऽरिमथीयनगरीयो यूषफ्नामा मन्त्री भद्रो धार्म्मिकश्च पुमान् ");
INSERT INTO sandev_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","पीलातान्तिकं गत्वा यीशो र्देहं ययाचे। ");
INSERT INTO sandev_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","पश्चाद् वपुरवरोह्य वाससा संवेष्ट्य यत्र कोपि मानुषो नास्थाप्यत तस्मिन् शैले स्वाते श्मशाने तदस्थापयत्। ");
INSERT INTO sandev_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","तद्दिनमायोजनीयं दिनं विश्रामवारश्च समीपः। ");
INSERT INTO sandev_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","अपरं यीशुना सार्द्धं गालील आगता योषितः पश्चादित्वा श्मशाने तत्र यथा वपुः स्थापितं तच्च दृष्ट्वा ");
INSERT INTO sandev_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","व्याघुट्य सुगन्धिद्रव्यतैलानि कृत्वा विधिवद् विश्रामवारे विश्रामं चक्रुः। ");
INSERT INTO sandev_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","अथ सप्ताहप्रथमदिनेऽतिप्रत्यूषे ता योषितः सम्पादितं सुगन्धिद्रव्यं गृहीत्वा तदन्याभिः कियतीभिः स्त्रीभिः सह श्मशानं ययुः। ");
INSERT INTO sandev_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","किन्तु श्मशानद्वारात् पाषाणमपसारितं दृष्ट्वा ");
INSERT INTO sandev_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ताः प्रविश्य प्रभो र्देहमप्राप्य ");
INSERT INTO sandev_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","व्याकुला भवन्ति एतर्हि तेजोमयवस्त्रान्वितौ द्वौ पुरुषौ तासां समीपे समुपस्थितौ ");
INSERT INTO sandev_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","तस्मात्ताः शङ्कायुक्ता भूमावधोमुख्यस्यस्थुः। तदा तौ ता ऊचतु र्मृतानां मध्ये जीवन्तं कुतो मृगयथ? ");
INSERT INTO sandev_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","सोत्र नास्ति स उदस्थात्। ");
INSERT INTO sandev_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","पापिनां करेषु समर्पितेन क्रुशे हतेन च मनुष्यपुत्रेण तृतीयदिवसे श्मशानादुत्थातव्यम् इति कथां स गलीलि तिष्ठन् युष्मभ्यं कथितवान् तां स्मरत। ");
INSERT INTO sandev_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","तदा तस्य सा कथा तासां मनःसु जाता। ");
INSERT INTO sandev_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","अनन्तरं श्मशानाद् गत्वा ता एकादशशिष्यादिभ्यः सर्व्वेभ्यस्तां वार्त्तां कथयामासुः। ");
INSERT INTO sandev_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","मग्दलीनीमरियम्, योहना, याकूबो माता मरियम् तदन्याः सङ्गिन्यो योषितश्च प्रेरितेभ्य एताः सर्व्वा वार्त्ताः कथयामासुः ");
INSERT INTO sandev_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","किन्तु तासां कथाम् अनर्थकाख्यानमात्रं बुद्ध्वा कोपि न प्रत्यैत्। ");
INSERT INTO sandev_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","तदा पितर उत्थाय श्मशानान्तिकं दधाव, तत्र च प्रह्वो भूत्वा पार्श्वैकस्थापितं केवलं वस्त्रं ददर्श; तस्मादाश्चर्य्यं मन्यमानो यदघटत तन्मनसि विचारयन् प्रतस्थे। ");
INSERT INTO sandev_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","तस्मिन्नेव दिने द्वौ शिय्यौ यिरूशालमश्चतुष्क्रोशान्तरितम् इम्मायुग्रामं गच्छन्तौ ");
INSERT INTO sandev_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","तासां घटनानां कथामकथयतां ");
INSERT INTO sandev_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","तयोरालापविचारयोः काले यीशुरागत्य ताभ्यां सह जगाम ");
INSERT INTO sandev_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","किन्तु यथा तौ तं न परिचिनुतस्तदर्थं तयो र्दृष्टिः संरुद्धा। ");
INSERT INTO sandev_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","स तौ पृष्टवान् युवां विषण्णौ किं विचारयन्तौ गच्छथः? ");
INSERT INTO sandev_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ततस्तयोः क्लियपानामा प्रत्युवाच यिरूशालमपुरेऽधुना यान्यघटन्त त्वं केवलविदेशी किं तद्वृत्तान्तं न जानासि? ");
INSERT INTO sandev_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","स पप्रच्छ का घटनाः? तदा तौ वक्तुमारेभाते यीशुनामा यो नासरतीयो भविष्यद्वादी ईश्वरस्य मानुषाणाञ्च साक्षात् वाक्ये कर्म्मणि च शक्तिमानासीत् ");
INSERT INTO sandev_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","तम् अस्माकं प्रधानयाजका विचारकाश्च केनापि प्रकारेण क्रुशे विद्ध्वा तस्य प्राणाननाशयन् तदीया घटनाः; ");
INSERT INTO sandev_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","किन्तु य इस्रायेलीयलोकान् उद्धारयिष्यति स एवायम् इत्याशास्माभिः कृता।तद्यथा तथास्तु तस्या घटनाया अद्य दिनत्रयं गतं। ");
INSERT INTO sandev_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","अधिकन्त्वस्माकं सङ्गिनीनां कियत्स्त्रीणां मुखेभ्योऽसम्भववाक्यमिदं श्रुतं; ");
INSERT INTO sandev_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ताः प्रत्यूषे श्मशानं गत्वा तत्र तस्य देहम् अप्राप्य व्याघुट्येत्वा प्रोक्तवत्यः स्वर्गीसदूतौ दृष्टावस्माभिस्तौ चावादिष्टां स जीवितवान्। ");
INSERT INTO sandev_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ततोस्माकं कैश्चित् श्मशानमगम्यत तेऽपि स्त्रीणां वाक्यानुरूपं दृष्टवन्तः किन्तु तं नापश्यन्। ");
INSERT INTO sandev_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","तदा स तावुवाच, हे अबोधौ हे भविष्यद्वादिभिरुक्तवाक्यं प्रत्येतुं विलम्बमानौ; ");
INSERT INTO sandev_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","एतत्सर्व्वदुःखं भुक्त्वा स्वभूतिप्राप्तिः किं ख्रीष्टस्य न न्याय्या? ");
INSERT INTO sandev_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ततः स मूसाग्रन्थमारभ्य सर्व्वभविष्यद्वादिनां सर्व्वशास्त्रे स्वस्मिन् लिखिताख्यानाभिप्रायं बोधयामास। ");
INSERT INTO sandev_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","अथ गम्यग्रामाभ्यर्णं प्राप्य तेनाग्रे गमनलक्षणे दर्शिते ");
INSERT INTO sandev_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","तौ साधयित्वावदतां सहावाभ्यां तिष्ठ दिने गते सति रात्रिरभूत्; ततः स ताभ्यां सार्द्धं स्थातुं गृहं ययौ। ");
INSERT INTO sandev_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","पश्चाद्भोजनोपवेशकाले स पूपं गृहीत्वा ईश्वरगुणान् जगाद तञ्च भंक्त्वा ताभ्यां ददौ। ");
INSERT INTO sandev_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","तदा तयो र्दृष्टौ प्रसन्नायां तं प्रत्यभिज्ञतुः किन्तु स तयोः साक्षादन्तर्दधे। ");
INSERT INTO sandev_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ततस्तौ मिथोभिधातुम् आरब्धवन्तौ गमनकाले यदा कथामकथयत् शास्त्रार्थञ्चबोधयत् तदावयो र्बुद्धिः किं न प्राज्वलत्? ");
INSERT INTO sandev_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","तौ तत्क्षणादुत्थाय यिरूशालमपुरं प्रत्याययतुः, तत्स्थाने शिष्याणाम् एकादशानां सङ्गिनाञ्च दर्शनं जातं। ");
INSERT INTO sandev_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ते प्रोचुः प्रभुरुदतिष्ठद् इति सत्यं शिमोने दर्शनमदाच्च। ");
INSERT INTO sandev_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","ततः पथः सर्व्वघटनायाः पूपभञ्जनेन तत्परिचयस्य च सर्व्ववृत्तान्तं तौ वक्तुमारेभाते। ");
INSERT INTO sandev_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","इत्थं ते परस्परं वदन्ति तत्काले यीशुः स्वयं तेषां मध्य प्रोत्थय युष्माकं कल्याणं भूयाद् इत्युवाच, ");
INSERT INTO sandev_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","किन्तु भूतं पश्याम इत्यनुमाय ते समुद्विविजिरे त्रेषुश्च। ");
INSERT INTO sandev_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","स उवाच, कुतो दुःखिता भवथ? युष्माकं मनःसु सन्देह उदेति च कुतः? ");
INSERT INTO sandev_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","एषोहं, मम करौ पश्यत वरं स्पृष्ट्वा पश्यत, मम यादृशानि पश्यथ तादृशानि भूतस्य मांसास्थीनि न सन्ति। ");
INSERT INTO sandev_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","इत्युक्त्वा स हस्तपादान् दर्शयामास। ");
INSERT INTO sandev_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","तेऽसम्भवं ज्ञात्वा सानन्दा न प्रत्ययन्। ततः स तान् पप्रच्छ, अत्र युष्माकं समीपे खाद्यं किञ्चिदस्ति? ");
INSERT INTO sandev_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ततस्ते कियद्दग्धमत्स्यं मधु च ददुः ");
INSERT INTO sandev_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","स तदादाय तेषां साक्षाद् बुभुजे ");
INSERT INTO sandev_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","कथयामास च मूसाव्यवस्थायां भविष्यद्वादिनां ग्रन्थेषु गीतपुस्तके च मयि यानि सर्व्वाणि वचनानि लिखितानि तदनुरूपाणि घटिष्यन्ते युष्माभिः सार्द्धं स्थित्वाहं यदेतद्वाक्यम् अवदं तदिदानीं प्रत्यक्षमभूत्। ");
INSERT INTO sandev_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","अथ तेभ्यः शास्त्रबोधाधिकारं दत्वावदत्, ");
INSERT INTO sandev_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ख्रीष्टेनेत्थं मृतियातना भोक्तव्या तृतीयदिने च श्मशानादुत्थातव्यञ्चेति लिपिरस्ति; ");
INSERT INTO sandev_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","तन्नाम्ना यिरूशालममारभ्य सर्व्वदेशे मनःपरावर्त्तनस्य पापमोचनस्य च सुसंवादः प्रचारयितव्यः, ");
INSERT INTO sandev_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","एषु सर्व्वेषु यूयं साक्षिणः। ");
INSERT INTO sandev_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","अपरञ्च पश्यत पित्रा यत् प्रतिज्ञातं तत् प्रेषयिष्यामि, अतएव यावत्कालं यूयं स्वर्गीयां शक्तिं न प्राप्स्यथ तावत्कालं यिरूशालम्नगरे तिष्ठत। ");
INSERT INTO sandev_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","अथ स तान् बैथनीयापर्य्यन्तं नीत्वा हस्तावुत्तोल्य आशिष वक्तुमारेभे ");
INSERT INTO sandev_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","आशिषं वदन्नेव च तेभ्यः पृथग् भूत्वा स्वर्गाय नीतोऽभवत्। ");
INSERT INTO sandev_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","तदा ते तं भजमाना महानन्देन यिरूशालमं प्रत्याजग्मुः। ");
INSERT INTO sandev_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ततो निरन्तरं मन्दिरे तिष्ठन्त ईश्वरस्य प्रशंसां धन्यवादञ्च कर्त्तम् आरेभिरे। इति॥");
INSERT INTO sandev_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","आदौ वाद आसीत् स च वाद ईश्वरेण सार्धमासीत् स वादः स्वयमीश्वर एव। ");
INSERT INTO sandev_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","स आदावीश्वरेण सहासीत्। ");
INSERT INTO sandev_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","तेन सर्व्वं वस्तु ससृजे सर्व्वेषु सृष्टवस्तुषु किमपि वस्तु तेनासृष्टं नास्ति। ");
INSERT INTO sandev_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","स जीवनस्याकारः, तच्च जीवनं मनुष्याणां ज्योतिः ");
INSERT INTO sandev_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","तज्ज्योतिरन्धकारे प्रचकाशे किन्त्वन्धकारस्तन्न जग्राह। ");
INSERT INTO sandev_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","योहन् नामक एको मनुज ईश्वरेण प्रेषयाञ्चक्रे। ");
INSERT INTO sandev_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","तद्वारा यथा सर्व्वे विश्वसन्ति तदर्थं स तज्ज्योतिषि प्रमाणं दातुं साक्षिस्वरूपो भूत्वागमत्, ");
INSERT INTO sandev_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","स स्वयं तज्ज्योति र्न किन्तु तज्ज्योतिषि प्रमाणं दातुमागमत्। ");
INSERT INTO sandev_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","जगत्यागत्य यः सर्व्वमनुजेभ्यो दीप्तिं ददाति तदेव सत्यज्योतिः। ");
INSERT INTO sandev_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","स यज्जगदसृजत् तन्मद्य एव स आसीत् किन्तु जगतो लोकास्तं नाजानन्। ");
INSERT INTO sandev_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","निजाधिकारं स आगच्छत् किन्तु प्रजास्तं नागृह्लन्। ");
INSERT INTO sandev_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","तथापि ये ये तमगृह्लन् अर्थात् तस्य नाम्नि व्यश्वसन् तेभ्य ईश्वरस्य पुत्रा भवितुम् अधिकारम् अददात्। ");
INSERT INTO sandev_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","तेषां जनिः शोणितान्न शारीरिकाभिलाषान्न मानवानामिच्छातो न किन्त्वीश्वरादभवत्। ");
INSERT INTO sandev_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","स वादो मनुष्यरूपेणावतीर्य्य सत्यतानुग्रहाभ्यां परिपूर्णः सन् सार्धम् अस्माभि र्न्यवसत् ततः पितुरद्वितीयपुत्रस्य योग्यो यो महिमा तं महिमानं तस्यापश्याम। ");
INSERT INTO sandev_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ततो योहनपि प्रचार्य्य साक्ष्यमिदं दत्तवान् यो मम पश्चाद् आगमिष्यति स मत्तो गुरुतरः; यतो मत्पूर्व्वं स विद्यमान आसीत्; यदर्थम् अहं साक्ष्यमिदम् अदां स एषः। ");
INSERT INTO sandev_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","अपरञ्च तस्य पूर्णताया वयं सर्व्वे क्रमशः क्रमशोनुग्रहं प्राप्ताः। ");
INSERT INTO sandev_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","मूसाद्वारा व्यवस्था दत्ता किन्त्वनुग्रहः सत्यत्वञ्च यीशुख्रीष्टद्वारा समुपातिष्ठतां। ");
INSERT INTO sandev_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","कोपि मनुज ईश्वरं कदापि नापश्यत् किन्तु पितुः क्रोडस्थोऽद्वितीयः पुत्रस्तं प्रकाशयत्। ");
INSERT INTO sandev_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","त्वं कः? इति वाक्यं प्रेष्टुं यदा यिहूदीयलोका याजकान् लेविलोकांश्च यिरूशालमो योहनः समीपे प्रेषयामासुः, ");
INSERT INTO sandev_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","तदा स स्वीकृतवान् नापह्नूतवान् नाहम् अभिषिक्त इत्यङ्गीकृतवान्। ");
INSERT INTO sandev_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","तदा तेऽपृच्छन् तर्हि को भवान्? किं एलियः? सोवदत् न; ततस्तेऽपृच्छन् तर्हि भवान् स भविष्यद्वादी? सोवदत् नाहं सः। ");
INSERT INTO sandev_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","तदा तेऽपृच्छन् तर्हि भवान् कः? वयं गत्वा प्रेरकान् त्वयि किं वक्ष्यामः? स्वस्मिन् किं वदसि? ");
INSERT INTO sandev_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","तदा सोवदत्। परमेशस्य पन्थानं परिष्कुरुत सर्व्वतः। इतीदं प्रान्तरे वाक्यं वदतः कस्यचिद्रवः। कथामिमां यस्मिन् यिशयियो भविष्यद्वादी लिखितवान् सोहम्। ");
INSERT INTO sandev_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ये प्रेषितास्ते फिरूशिलोकाः। ");
INSERT INTO sandev_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","तदा तेऽपृच्छन् यदि नाभिषिक्तोसि एलियोसि न स भविष्यद्वाद्यपि नासि च, तर्हि लोकान् मज्जयसि कुतः? ");
INSERT INTO sandev_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ततो योहन् प्रत्यवोचत्, तोयेऽहं मज्जयामीति सत्यं किन्तु यं यूयं न जानीथ तादृश एको जनो युष्माकं मध्य उपतिष्ठति। ");
INSERT INTO sandev_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","स मत्पश्चाद् आगतोपि मत्पूर्व्वं वर्त्तमान आसीत् तस्य पादुकाबन्धनं मोचयितुमपि नाहं योग्योस्मि। ");
INSERT INTO sandev_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","यर्द्दननद्याः पारस्थबैथबारायां यस्मिन्स्थाने योहनमज्जयत् तस्मिन स्थाने सर्व्वमेतद् अघटत। ");
INSERT INTO sandev_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","परेऽहनि योहन् स्वनिकटमागच्छन्तं यिशुं विलोक्य प्रावोचत् जगतः पापमोचकम् ईश्वरस्य मेषशावकं पश्यत। ");
INSERT INTO sandev_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","यो मम पश्चादागमिष्यति स मत्तो गुरुतरः, यतो हेतोर्मत्पूर्व्वं सोऽवर्त्तत यस्मिन्नहं कथामिमां कथितवान् स एवायं। ");
INSERT INTO sandev_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","अपरं नाहमेनं प्रत्यभिज्ञातवान् किन्तु इस्रायेल्लोका एनं यथा परिचिन्वन्ति तदभिप्रायेणाहं जले मज्जयितुमागच्छम्। ");
INSERT INTO sandev_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","पुनश्च योहनपरमेकं प्रमाणं दत्वा कथितवान् विहायसः कपोतवद् अवतरन्तमात्मानम् अस्योपर्य्यवतिष्ठन्तं च दृष्टवानहम्। ");
INSERT INTO sandev_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","नाहमेनं प्रत्यभिज्ञातवान् इति सत्यं किन्तु यो जले मज्जयितुं मां प्रैरयत् स एवेमां कथामकथयत् यस्योपर्य्यात्मानम् अवतरन्तम् अवतिष्ठन्तञ्च द्रक्षयसि सएव पवित्रे आत्मनि मज्जयिष्यति। ");
INSERT INTO sandev_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","अवस्तन्निरीक्ष्यायम् ईश्वरस्य तनय इति प्रमाणं ददामि। ");
INSERT INTO sandev_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","परेऽहनि योहन् द्वाभ्यां शिष्याभ्यां सार्द्धें तिष्ठन् ");
INSERT INTO sandev_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","यिशुं गच्छन्तं विलोक्य गदितवान्, ईश्वरस्य मेषशावकं पश्यतं। ");
INSERT INTO sandev_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","इमां कथां श्रुत्वा द्वौ शिष्यौ यीशोः पश्चाद् ईयतुः। ");
INSERT INTO sandev_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ततो यीशुः परावृत्य तौ पश्चाद् आगच्छन्तौ दृष्ट्वा पृष्टवान् युवां किं गवेशयथः? तावपृच्छतां हे रब्बि अर्थात् हे गुरो भवान् कुत्र तिष्ठति? ");
INSERT INTO sandev_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ततः सोवादित् एत्य पश्यतं। ततो दिवसस्य तृतीयप्रहरस्य गतत्वात् तौ तद्दिनं तस्य सङ्गेऽस्थातां। ");
INSERT INTO sandev_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","यौ द्वौ योहनो वाक्यं श्रुत्वा यिशोः पश्चाद् आगमतां तयोः शिमोन्पितरस्य भ्राता आन्द्रियः ");
INSERT INTO sandev_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","स इत्वा प्रथमं निजसोदरं शिमोनं साक्षात्प्राप्य कथितवान् वयं ख्रीष्टम् अर्थात् अभिषिक्तपुरुषं साक्षात्कृतवन्तः। ");
INSERT INTO sandev_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","पश्चात् स तं यिशोः समीपम् आनयत्। तदा यीशुस्तं दृष्ट्वावदत् त्वं यूनसः पुत्रः शिमोन् किन्तु त्वन्नामधेयं कैफाः वा पितरः अर्थात् प्रस्तरो भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","परेऽहनि यीशौ गालीलं गन्तुं निश्चितचेतसि सति फिलिपनामानं जनं साक्षात्प्राप्यावोचत् मम पश्चाद् आगच्छ। ");
INSERT INTO sandev_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","बैत्सैदानाम्नि यस्मिन् ग्रामे पितरान्द्रिययोर्वास आसीत् तस्मिन् ग्रामे तस्य फिलिपस्य वसतिरासीत्। ");
INSERT INTO sandev_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","पश्चात् फिलिपो निथनेलं साक्षात्प्राप्यावदत् मूसा व्यवस्था ग्रन्थे भविष्यद्वादिनां ग्रन्थेषु च यस्याख्यानं लिखितमास्ते तं यूषफः पुत्रं नासरतीयं यीशुं साक्षाद् अकार्ष्म वयं। ");
INSERT INTO sandev_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","तदा निथनेल् कथितवान् नासरन्नगरात किं कश्चिदुत्तम उत्पन्तुं शक्नोति? ततः फिलिपो ऽवोचत् एत्य पश्य। ");
INSERT INTO sandev_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","अपरञ्च यीशुः स्वस्य समीपं तम् आगच्छन्तं दृष्ट्वा व्याहृतवान्, पश्यायं निष्कपटः सत्य इस्रायेल्लोकः। ");
INSERT INTO sandev_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","ततः सोवदद्, भवान् मां कथं प्रत्यभिजानाति? यीशुरवादीत् फिलिपस्य आह्वानात् पूर्व्वं यदा त्वमुडुम्बरस्य तरोर्मूलेऽस्थास्तदा त्वामदर्शम्। ");
INSERT INTO sandev_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","निथनेल् अचकथत्, हे गुरो भवान् नितान्तम् ईश्वरस्य पुत्रोसि, भवान् इस्रायेल्वंशस्य राजा। ");
INSERT INTO sandev_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ततो यीशु र्व्याहरत्, त्वामुडुम्बरस्य पादपस्य मूले दृष्टवानाहं ममैतस्माद्वाक्यात् किं त्वं व्यश्वसीः? एतस्मादप्याश्चर्य्याणि कार्य्याणि द्रक्ष्यसि। ");
INSERT INTO sandev_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","अन्यच्चावादीद् युष्मानहं यथार्थं वदामि, इतः परं मोचिते मेघद्वारे तस्मान्मनुजसूनुना ईश्वरस्य दूतगणम् अवरोहन्तमारोहन्तञ्च द्रक्ष्यथ। ");
INSERT INTO sandev_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","अनन्तरं त्रुतीयदिवसे गालील् प्रदेशिये कान्नानाम्नि नगरे विवाह आसीत् तत्र च यीशोर्माता तिष्ठत्। ");
INSERT INTO sandev_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","तस्मै विवाहाय यीशुस्तस्य शिष्याश्च निमन्त्रिता आसन्। ");
INSERT INTO sandev_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","तदनन्तरं द्राक्षारसस्य न्यूनत्वाद् यीशोर्माता तमवदत् एतेषां द्राक्षारसो नास्ति। ");
INSERT INTO sandev_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","तदा स तामवोचत् हे नारि मया सह तव किं कार्य्यं? मम समय इदानीं नोपतिष्ठति। ");
INSERT INTO sandev_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","ततस्तस्य माता दासानवोचद् अयं यद् वदति तदेव कुरुत। ");
INSERT INTO sandev_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","तस्मिन् स्थाने यिहूदीयानां शुचित्वकरणव्यवहारानुसारेणाढकैकजलधराणि पाषाणमयानि षड्वृहत्पात्राणिआसन्। ");
INSERT INTO sandev_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","तदा यीशुस्तान् सर्व्वकलशान् जलैः पूरयितुं तानाज्ञापयत्, ततस्ते सर्व्वान् कुम्भानाकर्णं जलैः पर्य्यपूरयन्। ");
INSERT INTO sandev_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","अथ तेभ्यः किञ्चिदुत्तार्य्य भोज्याधिपातेःसमीपं नेतुं स तानादिशत्, ते तदनयन्। ");
INSERT INTO sandev_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","अपरञ्च तज्जलं कथं द्राक्षारसोऽभवत् तज्जलवाहकादासा ज्ञातुं शक्ताः किन्तु तद्भोज्याधिपो ज्ञातुं नाशक्नोत् तदवलिह्य वरं संम्बोद्यावदत, ");
INSERT INTO sandev_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","लोकाः प्रथमं उत्तमद्राक्षारसं ददति तषु यथेष्टं पितवत्सु तस्मा किञ्चिदनुत्तमञ्च ददति किन्तु त्वमिदानीं यावत् उत्तमद्राक्षारसं स्थापयसि। ");
INSERT INTO sandev_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","इत्थं यीशुर्गालीलप्रदेशे आश्चर्य्यकार्म्म प्रारम्भ निजमहिमानं प्राकाशयत् ततः शिष्यास्तस्मिन् व्यश्वसन्। ");
INSERT INTO sandev_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ततः परम् स निजमात्रुभ्रात्रुस्शिष्यैः सार्द्ध्ं कफर्नाहूमम् आगमत् किन्तु तत्र बहूदिनानि आतिष्ठत्। ");
INSERT INTO sandev_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","तदनन्तरं यिहूदियानां निस्तारोत्सवे निकटमागते यीशु र्यिरूशालम् नगरम् आगच्छत्। ");
INSERT INTO sandev_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ततो मन्दिरस्य मध्ये गोमेषपारावतविक्रयिणो वाणिजक्ष्चोपविष्टान् विलोक्य ");
INSERT INTO sandev_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","रज्जुभिः कशां निर्म्माय सर्व्वगोमेषादिभिः सार्द्धं तान् मन्दिराद् दूरीकृतवान्। ");
INSERT INTO sandev_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","वणिजां मुद्रादि विकीर्य्य आसनानि न्यूब्जीकृत्य पारावतविक्रयिभ्योऽकथयद् अस्मात् स्थानात् सर्वाण्येतानि नयत, मम पितुगृहं वाणिज्यगृहं मा कार्ष्ट। ");
INSERT INTO sandev_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","तस्मात् तन्मन्दिरार्थ उद्योगो यस्तु स ग्रसतीव माम्। इमां शास्त्रीयलिपिं शिष्याःसमस्मरन्। ");
INSERT INTO sandev_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ततः परम् यिहूदीयलोका यीषिमवदन् तवमिदृशकर्म्मकरणात् किं चिह्नमस्मान् दर्शयसि? ");
INSERT INTO sandev_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ततो यीशुस्तानवोचद् युष्माभिरे तस्मिन् मन्दिरे नाशिते दिनत्रयमध्येऽहं तद् उत्थापयिष्यामि। ");
INSERT INTO sandev_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","तदा यिहूदिया व्याहार्षुः, एतस्य मन्दिरस निर्म्माणेन षट्चत्वारिंशद् वत्सरा गताः, त्वं किं दिनत्रयमध्ये तद् उत्थापयिष्यसि? ");
INSERT INTO sandev_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","किन्तु स निजदेहरूपमन्दिरे कथामिमां कथितवान्। ");
INSERT INTO sandev_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","स यदेतादृशं गदितवान् तच्छिष्याः श्मशानात् तदीयोत्थाने सति स्मृत्वा धर्म्मग्रन्थे यीशुनोक्तकथायां च व्यश्वसिषुः। ");
INSERT INTO sandev_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","अनन्तरं निस्तारोत्सवस्य भोज्यसमये यिरूशालम् नगरे तत्क्रुताश्चर्य्यकर्म्माणि विलोक्य बहुभिस्तस्य नामनि विश्वसितं। ");
INSERT INTO sandev_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","किन्तु स तेषां करेषु स्वं न समर्पयत्, यतः स सर्व्वानवैत्। ");
INSERT INTO sandev_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","स मानवेषु कस्यचित् प्रमाणं नापेक्षत यतो मनुजानां मध्ये यद्यदस्ति तत्तत् सोजानात्। ");
INSERT INTO sandev_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","निकदिमनामा यिहूदीयानाम् अधिपतिः फिरूशी क्षणदायां ");
INSERT INTO sandev_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","यीशौरभ्यर्णम् आव्रज्य व्याहार्षीत्, हे गुरो भवान् ईश्वराद् आगत् एक उपदेष्टा, एतद् अस्माभिर्ज्ञायते; यतो भवता यान्याश्चर्य्यकर्म्माणि क्रियन्ते परमेश्वरस्य साहाय्यं विना केनापि तत्तत्कर्म्माणि कर्त्तुं न शक्यन्ते। ");
INSERT INTO sandev_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","तदा यीशुरुत्तरं दत्तवान् तवाहं यथार्थतरं व्याहरामि पुनर्जन्मनि न सति कोपि मानव ईश्वरस्य राज्यं द्रष्टुं न शक्नोति। ");
INSERT INTO sandev_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ततो निकदीमः प्रत्यवोचत् मनुजो वृद्धो भूत्वा कथं जनिष्यते? स किं पुन र्मातृर्जठरं प्रविश्य जनितुं शक्नोति? ");
INSERT INTO sandev_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","यीशुरवादीद् यथार्थतरम् अहं कथयामि मनुजे तोयात्मभ्यां पुन र्न जाते स ईश्वरस्य राज्यं प्रवेष्टुं न शक्नोति। ");
INSERT INTO sandev_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","मांसाद् यत् जायते तन् मांसमेव तथात्मनो यो जायते स आत्मैव। ");
INSERT INTO sandev_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","युष्माभिः पुन र्जनितव्यं ममैतस्यां कथायाम् आश्चर्यं मा मंस्थाः। ");
INSERT INTO sandev_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","सदागतिर्यां दिशमिच्छति तस्यामेव दिशि वाति, त्वं तस्य स्वनं शुणोषि किन्तु स कुत आयाति कुत्र याति वा किमपि न जानासि तद्वाद् आत्मनः सकाशात् सर्व्वेषां मनुजानां जन्म भवति। ");
INSERT INTO sandev_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","तदा निकदीमः पृष्टवान् एतत् कथं भवितुं शक्नोति? ");
INSERT INTO sandev_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","यीशुः प्रत्यक्तवान् त्वमिस्रायेलो गुरुर्भूत्वापि किमेतां कथां न वेत्सि? ");
INSERT INTO sandev_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","तुभ्यं यथार्थं कथयामि, वयं यद् विद्मस्तद् वच्मः यंच्च पश्यामस्तस्यैव साक्ष्यं दद्मः किन्तु युष्माभिरस्माकं साक्षित्वं न गृह्यते। ");
INSERT INTO sandev_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","एतस्य संसारस्य कथायां कथितायां यदि यूयं न विश्वसिथ तर्हि स्वर्गीयायां कथायां कथं विश्वसिष्यथ? ");
INSERT INTO sandev_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","यः स्वर्गेऽस्ति यं च स्वर्गाद् अवारोहत् तं मानवतनयं विना कोपि स्वर्गं नारोहत्। ");
INSERT INTO sandev_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","अपरञ्च मूसा यथा प्रान्तरे सर्पं प्रोत्थापितवान् मनुष्यपुत्रोऽपि तथैवोत्थापितव्यः; ");
INSERT INTO sandev_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","तस्माद् यः कश्चित् तस्मिन् विश्वसिष्यति सोऽविनाश्यः सन् अनन्तायुः प्राप्स्यति। ");
INSERT INTO sandev_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ईश्वर इत्थं जगददयत यत् स्वमद्वितीयं तनयं प्राददात् ततो यः कश्चित् तस्मिन् विश्वसिष्यति सोऽविनाश्यः सन् अनन्तायुः प्राप्स्यति। ");
INSERT INTO sandev_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ईश्वरो जगतो लोकान् दण्डयितुं स्वपुत्रं न प्रेष्य तान् परित्रातुं प्रेषितवान्। ");
INSERT INTO sandev_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","अतएव यः कश्चित् तस्मिन् विश्वसिति स दण्डार्हो न भवति किन्तु यः कश्चित् तस्मिन् न विश्वसिति स इदानीमेव दण्डार्हो भवति,यतः स ईश्वरस्याद्वितीयपुत्रस्य नामनि प्रत्ययं न करोति। ");
INSERT INTO sandev_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","जगतो मध्ये ज्योतिः प्राकाशत किन्तु मनुष्याणां कर्म्मणां दृष्टत्वात् ते ज्योतिषोपि तिमिरे प्रीयन्ते एतदेव दण्डस्य कारणां भवति। ");
INSERT INTO sandev_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","यः कुकर्म्म करोति तस्याचारस्य दृष्टत्वात् स ज्योतिर्ॠतीयित्वा तन्निकटं नायाति; ");
INSERT INTO sandev_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","किन्तु यः सत्कर्म्म करोति तस्य सर्व्वाणि कर्म्माणीश्वरेण कृतानीति सथा प्रकाशते तदभिप्रायेण स ज्योतिषः सन्निधिम् आयाति। ");
INSERT INTO sandev_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ततः परम् यीशुः शिष्यैः सार्द्धं यिहूदीयदेशं गत्वा तत्र स्थित्वा मज्जयितुम् आरभत। ");
INSERT INTO sandev_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","तदा शालम् नगरस्य समीपस्थायिनि ऐनन् ग्रामे बहुतरतोयस्थितेस्तत्र योहन् अमज्जयत् तथा च लोका आगत्य तेन मज्जिता अभवन्। ");
INSERT INTO sandev_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","तदा योहन् कारायां न बद्धः। ");
INSERT INTO sandev_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","अपरञ्च शाचकर्म्मणि योहानः शिष्यैः सह यिहूदीयलोकानां विवादे जाते, ते योहनः संन्निधिं गत्वाकथयन्, ");
INSERT INTO sandev_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","हे गुरो यर्द्दननद्याः पारे भवता सार्द्धं य आसीत् यस्मिंश्च भवान् साक्ष्यं प्रददात् पश्यतु सोपि मज्जयति सर्व्वे तस्य समीपं यान्ति च। ");
INSERT INTO sandev_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","तदा योहन् प्रत्यवोचद् ईश्वरेण न दत्ते कोपि मनुजः किमपि प्राप्तुं न शक्नोति। ");
INSERT INTO sandev_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","अहं अभिषिक्तो न भवामि किन्तु तदग्रे प्रेषितोस्मि यामिमां कथां कथितवानाहं तत्र यूयं सर्व्वे साक्षिणः स्थ। ");
INSERT INTO sandev_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","यो जनः कन्यां लभते स एव वरः किन्तु वरस्य सन्निधौ दण्डायमानं तस्य यन्मित्रं तेन वरस्य शब्दे श्रुतेऽतीवाह्लाद्यते ममापि तद्वद् आनन्दसिद्धिर्जाता। ");
INSERT INTO sandev_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","तेन क्रमशो वर्द्धितव्यं किन्तु मया ह्सितव्यं। ");
INSERT INTO sandev_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","य ऊर्ध्वादागच्छत् स सर्व्वेषां मुख्यो यश्च संसाराद् उदपद्यत स सांसारिकः संसारीयां कथाञ्च कथयति यस्तु स्वर्गादागच्छत् स सर्व्वेषां मुख्यः। ");
INSERT INTO sandev_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","स यदपश्यदशृणोच्च तस्मिन्नेव साक्ष्यं ददाति तथापि प्रायशः कश्चित् तस्य साक्ष्यं न गृह्लाति; ");
INSERT INTO sandev_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","किन्तु यो गृह्लाति स ईश्वरस्य सत्यवादित्वं मुद्राङ्गितं करोति। ");
INSERT INTO sandev_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ईश्वरेण यः प्रेरितः सएव ईश्वरीयकथां कथयति यत ईश्वर आत्मानं तस्मै अपरिमितम् अददात्। ");
INSERT INTO sandev_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","पिता पुत्रे स्नेहं कृत्वा तस्य हस्ते सर्व्वाणि समर्पितवान्। ");
INSERT INTO sandev_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","यः कश्चित् पुत्रे विश्वसिति स एवानन्तम् परमायुः प्राप्नोति किन्तु यः कश्चित् पुत्रे न विश्वसिति स परमायुषो दर्शनं न प्राप्नोति किन्त्वीश्वरस्य कोपभाजनं भूत्वा तिष्ठति। ");
INSERT INTO sandev_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","यीशुः स्वयं नामज्जयत् केवलं तस्य शिष्या अमज्जयत् किन्तु योहनोऽधिकशिष्यान् स करोति मज्जयति च, ");
INSERT INTO sandev_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","फिरूशिन इमां वार्त्तामशृण्वन् इति प्रभुरवगत्य ");
INSERT INTO sandev_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","यिहूदीयदेशं विहाय पुन र्गालीलम् आगत्। ");
INSERT INTO sandev_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ततः शोमिरोणप्रदेशस्य मद्येन तेन गन्तव्ये सति ");
INSERT INTO sandev_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","याकूब् निजपुत्राय यूषफे यां भूमिम् अददात् तत्समीपस्थायि शोमिरोणप्रदेशस्य सुखार् नाम्ना विख्यातस्य नगरस्य सन्निधावुपास्थात्। ");
INSERT INTO sandev_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","तत्र याकूबः प्रहिरासीत्; तदा द्वितीययामवेलायां जातायां स मार्गे श्रमापन्नस्तस्य प्रहेः पार्श्वे उपाविशत्। ");
INSERT INTO sandev_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","एतर्हि काचित् शोमिरोणीया योषित् तोयोत्तोलनार्थम् तत्रागमत् ");
INSERT INTO sandev_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","तदा शिष्याः खाद्यद्रव्याणि क्रेतुं नगरम् अगच्छन्। ");
INSERT INTO sandev_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","यीशुः शोमिरोणीयां तां योषितम् व्याहार्षीत् मह्यं किञ्चित् पानीयं पातुं देहि। किन्तु शोमिरोणीयैः साकं यिहूदीयलोका न व्यवाहरन् तस्माद्धेतोः साकथयत् शोमिरोणीया योषितदहं त्वं यिहूदीयोसि कथं मत्तः पानीयं पातुम् इच्छसि? ");
INSERT INTO sandev_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ततो यीशुरवदद् ईश्वरस्य यद्दानं तत्कीदृक् पानीयं पातुं मह्यं देहि य इत्थं त्वां याचते स वा क इति चेदज्ञास्यथास्तर्हि तमयाचिष्यथाः स च तुभ्यममृतं तोयमदास्यत्। ");
INSERT INTO sandev_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","तदा सा सीमन्तिनी भाषितवति, हे महेच्छ प्रहिर्गम्भीरो भवतो नीरोत्तोलनपात्रं नास्ती च तस्मात् तदमृतं कीलालं कुतः प्राप्स्यसि? ");
INSERT INTO sandev_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","योस्मभ्यम् इममन्धूं ददौ, यस्य च परिजना गोमेषादयश्च सर्व्वेऽस्य प्रहेः पानीयं पपुरेतादृशो योस्माकं पूर्व्वपुरुषो याकूब् तस्मादपि भवान् महान् किं? ");
INSERT INTO sandev_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ततो यीशुरकथयद् इदं पानीयं सः पिवति स पुनस्तृषार्त्तो भविष्यति, ");
INSERT INTO sandev_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","किन्तु मया दत्तं पानीयं यः पिवति स पुनः कदापि तृषार्त्तो न भविष्यति। मया दत्तम् इदं तोयं तस्यान्तः प्रस्रवणरूपं भूत्वा अनन्तायुर्यावत् स्रोष्यति। ");
INSERT INTO sandev_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","तदा सा वनिताकथयत् हे महेच्छ तर्हि मम पुनः पीपासा यथा न जायते तोयोत्तोलनाय यथात्रागमनं न भवति च तदर्थं मह्यं तत्तोयं देही। ");
INSERT INTO sandev_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","ततो यीशूरवदद्याहि तव पतिमाहूय स्थानेऽत्रागच्छ। ");
INSERT INTO sandev_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","सा वामावदत् मम पतिर्नास्ति। यीशुरवदत् मम पतिर्नास्तीति वाक्यं भद्रमवोचः। ");
INSERT INTO sandev_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","यतस्तव पञ्च पतयोभवन् अधुना तु त्वया सार्द्धं यस्तिष्ठति स तव भर्त्ता न वाक्यमिदं सत्यमवादिः। ");
INSERT INTO sandev_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","तदा सा महिला गदितवति हे महेच्छ भवान् एको भविष्यद्वादीति बुद्धं मया। ");
INSERT INTO sandev_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","अस्माकं पितृलोका एतस्मिन् शिलोच्चयेऽभजन्त, किन्तु भवद्भिरुच्यते यिरूशालम् नगरे भजनयोग्यं स्थानमास्ते। ");
INSERT INTO sandev_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","यीशुरवोचत् हे योषित् मम वाक्ये विश्वसिहि यदा यूयं केवलशैलेऽस्मिन् वा यिरूशालम् नगरे पितुर्भजनं न करिष्यध्वे काल एतादृश आयाति। ");
INSERT INTO sandev_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","यूयं यं भजध्वे तं न जानीथ, किन्तु वयं यं भजामहे तं जानीमहे, यतो यिहूदीयलोकानां मध्यात् परित्राणं जायते। ");
INSERT INTO sandev_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","किन्तु यदा सत्यभक्ता आत्मना सत्यरूपेण च पितुर्भजनं करिष्यन्ते समय एतादृश आयाति, वरम् इदानीमपि विद्यते ; यत एतादृशो भत्कान् पिता चेष्टते। ");
INSERT INTO sandev_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ईश्वर आत्मा; ततस्तस्य ये भक्तास्तैः स आत्मना सत्यरूपेण च भजनीयः। ");
INSERT INTO sandev_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","तदा सा महिलावादीत् ख्रीष्टनाम्ना विख्यातोऽभिषिक्तः पुरुष आगमिष्यतीति जानामि स च सर्व्वाः कथा अस्मान् ज्ञापयिष्यति। ");
INSERT INTO sandev_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","ततो यीशुरवदत् त्वया सार्द्धं कथनं करोमि योऽहम् अहमेव स पुरुषः। ");
INSERT INTO sandev_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","एतस्मिन् समये शिष्या आगत्य तथा स्त्रिया सार्द्धं तस्य कथोपकथने महाश्चर्य्यम् अमन्यन्त तथापि भवान् किमिच्छति? यद्वा किमर्थम् एतया सार्द्धं कथां कथयति? इति कोपि नापृच्छत्। ");
INSERT INTO sandev_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","ततः परं सा नारी कलशं स्थापयित्वा नगरमध्यं गत्वा लोकेभ्योकथायद् ");
INSERT INTO sandev_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","अहं यद्यत् कर्म्माकरवं तत्सर्व्वं मह्यमकथयद् एतादृशं मानवमेकम् आगत्य पश्यत रु किम् अभिषिक्तो न भवति ? ");
INSERT INTO sandev_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ततस्ते नगराद् बहिरागत्य तातस्य समीपम् आयन्। ");
INSERT INTO sandev_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","एतर्हि शिष्याः साधयित्वा तं व्याहार्षुः हे गुरो भवान् किञ्चिद् भूक्तां। ");
INSERT INTO sandev_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ततः सोवदद् युष्माभिर्यन्न ज्ञायते तादृशं भक्ष्यं ममास्ते। ");
INSERT INTO sandev_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","तदा शिष्याः परस्परं प्रष्टुम् आरम्भन्त, किमस्मै कोपि किमपि भक्ष्यमानीय दत्तवान्? ");
INSERT INTO sandev_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","यीशुरवोचत् मत्प्रेरकस्याभिमतानुरूपकरणं तस्यैव कर्म्मसिद्धिकारणञ्च मम भक्ष्यं। ");
INSERT INTO sandev_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","मासचतुष्टये जाते शस्यकर्त्तनसमयो भविष्यतीति वाक्यं युष्माभिः किं नोद्यते? किन्त्वहं वदामि, शिर उत्तोल्य क्षेत्राणि प्रति निरीक्ष्य पश्यत, इदानीं कर्त्तनयोग्यानि शुक्लवर्णान्यभवन्। ");
INSERT INTO sandev_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","यश्छिनत्ति स वेतनं लभते अनन्तायुःस्वरूपं शस्यं स गृह्लाति च, तेनैव वप्ता छेत्ता च युगपद् आनन्दतः। ");
INSERT INTO sandev_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","इत्थं सति वपत्येकश्छिनत्यन्य इति वचनं सिद्ध्यति। ");
INSERT INTO sandev_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","यत्र यूयं न पर्य्यश्राम्यत तादृशं शस्यं छेत्तुं युष्मान् प्रैरयम् अन्ये जनाःपर्य्यश्राम्यन् यूयं तेषां श्रगस्य फलम् अलभध्वम्। ");
INSERT INTO sandev_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","यस्मिन् काले यद्यत् कर्म्माकार्षं तत्सर्व्वं स मह्यम् अकथयत् तस्या वनिताया इदं साक्ष्यवाक्यं श्रुत्वा तन्नगरनिवासिनो बहवः शोमिरोणीयलोका व्यश्वसन्। ");
INSERT INTO sandev_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","तथा च तस्यान्तिके समुपस्थाय स्वेषां सन्निधौ कतिचिद् दिनानि स्थातुं तस्मिन् विनयम् अकुर्व्वान तस्मात् स दिनद्वयं तत्स्थाने न्यवष्टत् ");
INSERT INTO sandev_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ततस्तस्योपदेशेन बहवोऽपरे विश्वस्य ");
INSERT INTO sandev_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","तां योषामवदन् केवलं तव वाक्येन प्रतीम इति न, किन्तु स जगतोऽभिषिक्तस्त्रातेति तस्य कथां श्रुत्वा वयं स्वयमेवाज्ञासमहि। ");
INSERT INTO sandev_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","स्वदेशे भविष्यद्वक्तुः सत्कारो नास्तीति यद्यपि यीशुः प्रमाणं दत्वाकथयत् ");
INSERT INTO sandev_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","तथापि दिवसद्वयात् परं स तस्मात् स्थानाद् गालीलं गतवान्। ");
INSERT INTO sandev_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","अनन्तरं ये गालीली लियलोका उत्सवे गता उत्सवसमये यिरूशलम् नगरे तस्य सर्व्वाः क्रिया अपश्यन् ते गालीलम् आगतं तम् आगृह्लन्। ");
INSERT INTO sandev_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","ततः परम् यीशु र्यस्मिन् कान्नानगरे जलं द्राक्षारसम् आकरोत् तत् स्थानं पुनरगात्। तस्मिन्नेव समये कस्यचिद् राजसभास्तारस्य पुत्रः कफर्नाहूमपुरी रोगग्रस्त आसीत्। ");
INSERT INTO sandev_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","स येहूदीयदेशाद् यीशो र्गालीलागमनवार्त्तां निशम्य तस्य समीपं गत्वा प्रार्थ्य व्याहृतवान् मम पुत्रस्य प्रायेण काल आसन्नः भवान् आगत्य तं स्वस्थं करोतु। ");
INSERT INTO sandev_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","तदा यीशुरकथयद् आश्चर्य्यं कर्म्म चित्रं चिह्नं च न दृष्टा यूयं न प्रत्येष्यथ। ");
INSERT INTO sandev_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ततः स सभासदवदत् हे महेच्छ मम पुत्रे न मृते भवानागच्छतु। ");
INSERT INTO sandev_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","यीशुस्तमवदद् गच्छ तव पुत्रोऽजीवीत् तदा यीशुनोक्तवाक्ये स विश्वस्य गतवान्। ");
INSERT INTO sandev_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","गमनकाले मार्गमध्ये दासास्तं साक्षात्प्राप्यावदन् भवतः पुत्रोऽजीवीत्। ");
INSERT INTO sandev_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ततः कं कालमारभ्य रोगप्रतीकारारम्भो जाता इति पृष्टे तैरुक्तं ह्यः सार्द्धदण्डद्वयाधिकद्वितीययामे तस्य ज्वरत्यागोऽभवत्। ");
INSERT INTO sandev_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","तदा यीशुस्तस्मिन् क्षणे प्रोक्तवान् तव पुत्रोऽजीवीत् पिता तद्बुद्ध्वा सपरिवारो व्यश्वसीत्। ");
INSERT INTO sandev_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","यिहूदीयदेशाद् आगत्य गालीलि यीशुरेतद् द्वितीयम् आश्चर्य्यकर्म्माकरोत्। ");
INSERT INTO sandev_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","ततः परं यिहूदीयानाम् उत्सव उपस्थिते यीशु र्यिरूशालमं गतवान्। ");
INSERT INTO sandev_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","तस्मिन्नगरे मेषनाम्नो द्वारस्य समीपे इब्रीयभाषया बैथेस्दा नाम्ना पिष्करिणी पञ्चघट्टयुक्तासीत्। ");
INSERT INTO sandev_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","तस्यास्तेषु घट्टेषु किलालकम्पनम् अपेक्ष्य अन्धखञ्चशुष्काङ्गादयो बहवो रोगिणः पतन्तस्तिष्ठन्ति स्म। ");
INSERT INTO sandev_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","यतो विशेषकाले तस्य सरसो वारि स्वर्गीयदूत एत्याकम्पयत् तत्कीलालकम्पनात् परं यः कश्चिद् रोगी प्रथमं पानीयमवारोहत् स एव तत्क्षणाद् रोगमुक्तोऽभवत्। ");
INSERT INTO sandev_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","तदाष्टात्रिंशद्वर्षाणि यावद् रोगग्रस्त एकजनस्तस्मिन् स्थाने स्थितवान्। ");
INSERT INTO sandev_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","यीशुस्तं शयितं दृष्ट्वा बहुकालिकरोगीति ज्ञात्वा व्याहृतवान् त्वं किं स्वस्थो बुभूषसि? ");
INSERT INTO sandev_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ततो रोगी कथितवान् हे महेच्छ यदा कीलालं कम्पते तदा मां पुष्करिणीम् अवरोहयितुं मम कोपि नास्ति, तस्मान् मम गमनकाले कश्चिदन्योऽग्रो गत्वा अवरोहति। ");
INSERT INTO sandev_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","तदा यीशुरकथयद् उत्तिष्ठ, तव शय्यामुत्तोल्य गृहीत्वा याहि। ");
INSERT INTO sandev_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","स तत्क्षणात् स्वस्थो भूत्वा शय्यामुत्तोल्यादाय गतवान् किन्तु तद्दिनं विश्रामवारः। ");
INSERT INTO sandev_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","तस्माद् यिहूदीयाः स्वस्थं नरं व्याहरन् अद्य विश्रामवारे शयनीयमादाय न यातव्यम्। ");
INSERT INTO sandev_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","ततः स प्रत्यवोचद् यो मां स्वस्थम् अकार्षीत् शयनीयम् उत्तोल्यादाय यातुं मां स एवादिशत्। ");
INSERT INTO sandev_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","तदा तेऽपृच्छन् शयनीयम् उत्तोल्यादाय यातुं य आज्ञापयत् स कः? ");
INSERT INTO sandev_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","किन्तु स क इति स्वस्थीभूतो नाजानाद् यतस्तस्मिन् स्थाने जनतासत्त्वाद् यीशुः स्थानान्तरम् आगमत्। ");
INSERT INTO sandev_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","ततः परं येशु र्मन्दिरे तं नरं साक्षात्प्राप्याकथयत् पश्येदानीम् अनामयो जातोसि यथाधिका दुर्दशा न घटते तद्धेतोः पापं कर्म्म पुनर्माकार्षीः। ");
INSERT INTO sandev_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ततः स गत्वा यिहूदीयान् अवदद् यीशु र्माम् अरोगिणम् अकार्षीत्। ");
INSERT INTO sandev_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","ततो यीशु र्विश्रामवारे कर्म्मेदृशं कृतवान् इति हेतो र्यिहूदीयास्तं ताडयित्वा हन्तुम् अचेष्टन्त। ");
INSERT INTO sandev_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","यीशुस्तानाख्यत् मम पिता यत् कार्य्यं करोति तदनुरूपम् अहमपि करोति। ");
INSERT INTO sandev_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","ततो यिहूदीयास्तं हन्तुं पुनरयतन्त यतो विश्रामवारं नामन्यत तदेव केवलं न अधिकन्तु ईश्वरं स्वपितरं प्रोच्य स्वमपीश्वरतुल्यं कृतवान्। ");
INSERT INTO sandev_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","पश्चाद् यीशुरवदद् युष्मानहं यथार्थतरं वदामि पुत्रः पितरं यद्यत् कर्म्म कुर्व्वन्तं पश्यति तदतिरिक्तं स्वेच्छातः किमपि कर्म्म कर्त्तुं न शक्नोति। पिता यत् करोति पुत्रोपि तदेव करोति। ");
INSERT INTO sandev_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","पिता पुत्रे स्नेहं करोति तस्मात् स्वयं यद्यत् कर्म्म करोति तत्सर्व्वं पुत्रं दर्शयति ; यथा च युष्माकं आश्चर्य्यज्ञानं जनिष्यते तदर्थम् इतोपि महाकर्म्म तं दर्शयिष्यति। ");
INSERT INTO sandev_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","वस्तुतस्तु पिता यथा प्रमितान् उत्थाप्य सजिवान् करोति तद्वत् पुत्रोपि यं यं इच्छति तं तं सजीवं करोति। ");
INSERT INTO sandev_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","सर्व्वे पितरं यथा सत्कुर्व्वन्ति तथा पुत्रमपि सत्कारयितुं पिता स्वयं कस्यापि विचारमकृत्वा सर्व्वविचाराणां भारं पुत्रे समर्पितवान्। ");
INSERT INTO sandev_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","यः पुत्रं सत् करोति स तस्य प्रेरकमपि सत् करोति। ");
INSERT INTO sandev_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","युष्मानाहं यथार्थतरं वदामि यो जनो मम वाक्यं श्रुत्वा मत्प्रेरके विश्वसिति सोनन्तायुः प्राप्नोति कदापि दण्डबाजनं न भवति निधनादुत्थाय परमायुः प्राप्नोति। ");
INSERT INTO sandev_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","अहं युष्मानतियथार्थं वदामि यदा मृता ईश्वरपुत्रस्य निनादं श्रोष्यन्ति ये च श्रोष्यन्ति ते सजीवा भविष्यन्ति समय एतादृश आयाति वरम् इदानीमप्युपतिष्ठति। ");
INSERT INTO sandev_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","पिता यथा स्वयञ्जीवी तथा पुत्राय स्वयञ्जीवित्वाधिकारं दत्तवान्। ");
INSERT INTO sandev_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","स मनुष्यपुत्रः एतस्मात् कारणात् पिता दण्डकरणाधिकारमपि तस्मिन् समर्पितवान्। ");
INSERT INTO sandev_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","एतदर्थे यूयम् आश्चर्य्यं न मन्यध्वं यतो यस्मिन् समये तस्य निनादं श्रुत्वा श्मशानस्थाः सर्व्वे बहिरागमिष्यन्ति समय एतादृश उपस्थास्यति। ");
INSERT INTO sandev_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","तस्माद् ये सत्कर्म्माणि कृतवन्तस्त उत्थाय आयुः प्राप्स्यन्ति ये च कुकर्माणि कृतवन्तस्त उत्थाय दण्डं प्राप्स्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","अहं स्वयं किमपि कर्त्तुं न शक्नोमि यथा शुणोमि तथा विचारयामि मम विचारञ्च न्याय्यः यतोहं स्वीयाभीष्टं नेहित्वा मत्प्रेरयितुः पितुरिष्टम् ईहे। ");
INSERT INTO sandev_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","यदि स्वस्मिन् स्वयं साक्ष्यं ददामि तर्हि तत्साक्ष्यम् आग्राह्यं भवति ; ");
INSERT INTO sandev_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","किन्तु मदर्थेऽपरो जनः साक्ष्यं ददाति मदर्थे तस्य यत् साक्ष्यं तत् सत्यम् एतदप्यहं जानामि। ");
INSERT INTO sandev_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","युष्माभि र्योहनं प्रति लोकेषु प्रेरितेषु स सत्यकथायां साक्ष्यमददात्। ");
INSERT INTO sandev_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","मानुषादहं साक्ष्यं नोपेक्षे तथापि यूयं यथा परित्रयध्वे तदर्थम् इदं वाक्यं वदामि। ");
INSERT INTO sandev_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","योहन् देदीप्यमानो दीप इव तेजस्वी स्थितवान् यूयम् अल्पकालं तस्य दीप्त्यानन्दितुं सममन्यध्वं। ");
INSERT INTO sandev_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","किन्तु तत्प्रमाणादपि मम गुरुतरं प्रमाणं विद्यते पिता मां प्रेष्य यद्यत् कर्म्म समापयितुं शक्त्तिमददात् मया कृतं तत्तत् कर्म्म मदर्थे प्रमाणं ददाति। ");
INSERT INTO sandev_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","यः पिता मां प्रेरितवान् मोपि मदर्थे प्रमाणं ददाति। तस्य वाक्यं युष्माभिः कदापि न श्रुतं तस्य रूपञ्च न दृष्टं ");
INSERT INTO sandev_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","तस्य वाक्यञ्च युष्माकम् अन्तः कदापि स्थानं नाप्नोति यतः स यं प्रेषितवान् यूयं तस्मिन् न विश्वसिथ। ");
INSERT INTO sandev_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","धर्म्मपुस्तकानि यूयम् आलोचयध्वं तै र्वाक्यैरनन्तायुः प्राप्स्याम इति यूयं बुध्यध्वे तद्धर्म्मपुस्तकानि मदर्थे प्रमाणं ददति। ");
INSERT INTO sandev_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","तथापि यूयं परमायुःप्राप्तये मम संनिधिम् न जिगमिषथ। ");
INSERT INTO sandev_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","अहं मानुषेभ्यः सत्कारं न गृह्लामि। ");
INSERT INTO sandev_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","अहं युष्मान् जानामि; युष्माकमन्तर ईश्वरप्रेम नास्ति। ");
INSERT INTO sandev_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","अहं निजपितु र्नाम्नागतोस्मि तथापि मां न गृह्लीथ किन्तु कश्चिद् यदि स्वनाम्ना समागमिष्यति तर्हि तं ग्रहीष्यथ। ");
INSERT INTO sandev_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","यूयम् ईश्वरात् सत्कारं न चिष्टत्वा केवलं परस्परं सत्कारम् चेद् आदध्व्वे तर्हि कथं विश्वसितुं शक्नुथ? ");
INSERT INTO sandev_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","पुतुः समीपेऽहं युष्मान् अपवदिष्यामीति मा चिन्तयत यस्मिन् , यस्मिन् युष्माकं विश्वसः सएव मूसा युष्मान् अपवदति। ");
INSERT INTO sandev_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","यदि यूयं तस्मिन् व्यश्वसिष्यत तर्हि मय्यपि व्यश्वसिष्यत, यत् स मयि लिखितवान्। ");
INSERT INTO sandev_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","ततो यदि तेन लिखितवानि न प्रतिथ तर्हि मम वाक्यानि कथं प्रत्येष्यथ? ");
INSERT INTO sandev_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","ततः परं यीशु र्गालील् प्रदेशीयस्य तिविरियानाम्नः सिन्धोः पारं गतवान्। ");
INSERT INTO sandev_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ततो व्याधिमल्लोकस्वास्थ्यकरणरूपाणि तस्याश्चर्य्याणि कर्म्माणि दृष्ट्वा बहवो जनास्तत्पश्चाद् अगच्छन्। ");
INSERT INTO sandev_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ततो यीशुः पर्व्वतमारुह्य तत्र शिष्यैः साकम्। ");
INSERT INTO sandev_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","तस्मिन् समय निस्तारोत्सवनाम्नि यिहूदीयानाम उत्सव उपस्थिते ");
INSERT INTO sandev_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","यीशु र्नेत्रे उत्तोल्य बहुलोकान् स्वसमीपागतान् विलोक्य फिलिपं पृष्टवान् एतेषां भोजनाय भोजद्रव्याणि वयं कुत्र क्रेतुं शक्रुमः? ");
INSERT INTO sandev_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","वाक्यमिदं तस्य परीक्षार्थम् अवादीत् किन्तु यत् करिष्यति तत् स्वयम् अजानात्। ");
INSERT INTO sandev_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","फिलिपः प्रत्यवोचत् एतेषाम् एकैको यद्यल्पम् अल्पं प्राप्नोति तर्हि मुद्रापादद्विशतेन क्रीतपूपा अपि न्यूना भविष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","शिमोन् पितरस्य भ्राता आन्द्रियाख्यः शिष्याणामेको व्याहृतवान् ");
INSERT INTO sandev_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","अत्र कस्यचिद् बालकस्य समीपे पञ्च यावपूपाः क्षुद्रमत्स्यद्वयञ्च सन्ति किन्तु लोकानां एतावातां मध्ये तैः किं भविष्यति? ");
INSERT INTO sandev_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","पश्चाद् यीशुरवदत् लोकानुपवेशयत तत्र बहुयवससत्त्वात् पञ्चसहस्त्रेभ्यो न्यूना अधिका वा पुरुषा भूम्याम् उपाविशन्। ");
INSERT INTO sandev_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ततो यीशुस्तान् पूपानादाय ईश्वरस्य गुणान् कीर्त्तयित्वा शिष्येषु समार्पयत् ततस्ते तेभ्य उपविष्टलोकेभ्यः पूपान् यथेष्टमत्स्यञ्च प्रादुः। ");
INSERT INTO sandev_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","तेषु तृप्तेषु स तानवोचद् एतेषां किञ्चिदपि यथा नापचीयते तथा सर्व्वाण्यवशिष्टानि संगृह्लीत। ");
INSERT INTO sandev_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ततः सर्व्वेषां भोजनात् परं ते तेषां पञ्चानां यावपूपानां अवशिष्टान्यखिलानि संगृह्य द्वादशडल्लकान् अपूरयन्। ");
INSERT INTO sandev_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","अपरं यीशोरेतादृशीम् आश्चर्य्यक्रियां दृष्ट्वा लोका मिथो वक्तुमारेभिरे जगति यस्यागमनं भविष्यति स एवायम् अवश्यं भविष्यद्वक्त्ता। ");
INSERT INTO sandev_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","अतएव लोका आगत्य तमाक्रम्य राजानं करिष्यन्ति यीशुस्तेषाम् ईदृशं मानसं विज्ञाय पुनश्च पर्व्वतम् एकाकी गतवान्। ");
INSERT INTO sandev_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","सायंकाल उपस्थिते शिष्या जलधितटं व्रजित्वा नावमारुह्य नगरदिशि सिन्धौ वाहयित्वागमन्। ");
INSERT INTO sandev_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","तस्मिन् समये तिमिर उपातिष्ठत् किन्तु यीषुस्तेषां समीपं नागच्छत्। ");
INSERT INTO sandev_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","तदा प्रबलपवनवहनात् सागरे महातरङ्गो भवितुम् आरेभे। ");
INSERT INTO sandev_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ततस्ते वाहयित्वा द्वित्रान् क्रोशान् गताः पश्चाद् यीशुं जलधेरुपरि पद्भ्यां व्रजन्तं नौकान्तिकम् आगच्छन्तं विलोक्य त्रासयुक्ता अभवन् ");
INSERT INTO sandev_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","किन्तु स तानुक्त्तवान् अयमहं मा भैष्ट। ");
INSERT INTO sandev_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","तदा ते तं स्वैरं नावि गृहीतवन्तः तदा तत्क्षणाद् उद्दिष्टस्थाने नौरुपास्थात्। ");
INSERT INTO sandev_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","यया नावा शिष्या अगच्छन् तदन्या कापि नौका तस्मिन् स्थाने नासीत् ततो यीशुः शिष्यैः साकं नागमत् केवलाः शिष्या अगमन् एतत् पारस्था लोका ज्ञातवन्तः। ");
INSERT INTO sandev_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","किन्तु ततः परं प्रभु र्यत्र ईश्वरस्य गुणान् अनुकीर्त्त्य लोकान् पूपान् अभोजयत् तत्स्थानस्य समीपस्थतिविरियाया अपरास्तरणय आगमन्। ");
INSERT INTO sandev_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","यीशुस्तत्र नास्ति शिष्या अपि तत्र ना सन्ति लोका इति विज्ञाय यीशुं गवेषयितुं तरणिभिः कफर्नाहूम् पुरं गताः। ");
INSERT INTO sandev_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","ततस्ते सरित्पतेः पारे तं साक्षात् प्राप्य प्रावोचन् हे गुरो भवान् अत्र स्थाने कदागमत्? ");
INSERT INTO sandev_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","तदा यीशुस्तान् प्रत्यवादीद् युष्मानहं यथार्थतरं वदामि आश्चर्य्यकर्म्मदर्शनाद्धेतो र्न किन्तु पूपभोजनात् तेन तृप्तत्वाञ्च मां गवेषयथ। ");
INSERT INTO sandev_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","क्षयणीयभक्ष्यार्थं मा श्रामिष्ट किन्त्वन्तायुर्भक्ष्यार्थं श्राम्यत, तस्मात् तादृशं भक्ष्यं मनुजपुत्रो युष्माभ्यं दास्यति; तस्मिन् तात ईश्वरः प्रमाणं प्रादात्। ");
INSERT INTO sandev_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","तदा तेऽपृच्छन् ईश्वराभिमतं कर्म्म कर्त्तुम् अस्माभिः किं कर्त्तव्यं? ");
INSERT INTO sandev_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","ततो यीशुरवदद् ईश्वरो यं प्रैरयत् तस्मिन् विश्वसनम् ईश्वराभिमतं कर्म्म। ");
INSERT INTO sandev_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","तदा ते व्याहरन् भवता किं लक्षणं दर्शितं यद्दृष्ट्वा भवति विश्वसिष्यामः? त्वया किं कर्म्म कृतं? ");
INSERT INTO sandev_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","अस्माकं पूर्व्वपुरुषा महाप्रान्तरे मान्नां भोक्त्तुं प्रापुः यथा लिपिरास्ते। स्वर्गीयाणि तु भक्ष्याणि प्रददौ परमेश्वरः। ");
INSERT INTO sandev_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","तदा यीशुरवदद् अहं युष्मानतियथार्थं वदामि मूसा युष्माभ्यं स्वर्गीयं भक्ष्यं नादात् किन्तु मम पिता युष्माभ्यं स्वर्गीयं परमं भक्ष्यं ददाति। ");
INSERT INTO sandev_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","यः स्वर्गादवरुह्य जगते जीवनं ददाति स ईश्वरदत्तभक्ष्यरूपः। ");
INSERT INTO sandev_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","तदा ते प्रावोचन् हे प्रभो भक्ष्यमिदं नित्यमस्मभ्यं ददातु। ");
INSERT INTO sandev_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","यीशुरवदद् अहमेव जीवनरूपं भक्ष्यं यो जनो मम सन्निधिम् आगच्छति स जातु क्षुधार्त्तो न भविष्यति, तथा यो जनो मां प्रत्येति स जातु तृषार्त्तो न भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","मां दृष्ट्वापि यूयं न विश्वसिथ युष्मानहम् इत्यवोचं। ");
INSERT INTO sandev_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","पिता मह्यं यावतो लोकानददात् ते सर्व्व एव ममान्तिकम् आगमिष्यन्ति यः कश्चिच्च मम सन्निधिम् आयास्यति तं केनापि प्रकारेण न दूरीकरिष्यामि। ");
INSERT INTO sandev_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","निजाभिमतं साधयितुं न हि किन्तु प्रेरयितुरभिमतं साधयितुं स्वर्गाद् आगतोस्मि। ");
INSERT INTO sandev_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","स यान् यान् लोकान् मह्यमददात् तेषामेकमपि न हारयित्वा शेषदिने सर्व्वानहम् उत्थापयामि इदं मत्प्रेरयितुः पितुरभिमतं। ");
INSERT INTO sandev_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","यः कश्चिन् मानवसुतं विलोक्य विश्वसिति स शेषदिने मयोत्थापितः सन् अनन्तायुः प्राप्स्यति इति मत्प्रेरकस्याभिमतं। ");
INSERT INTO sandev_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","तदा स्वर्गाद् यद् भक्ष्यम् अवारोहत् तद् भक्ष्यम् अहमेव यिहूदीयलोकास्तस्यैतद् वाक्ये विवदमाना वक्त्तुमारेभिरे ");
INSERT INTO sandev_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","यूषफः पुत्रो यीशु र्यस्य मातापितरौ वयं जानीम एष किं सएव न? तर्हि स्वर्गाद् अवारोहम् इति वाक्यं कथं वक्त्ति? ");
INSERT INTO sandev_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","तदा यीशुस्तान् प्रत्यवदत् परस्परं मा विवदध्वं ");
INSERT INTO sandev_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","मत्प्रेरकेण पित्रा नाकृष्टः कोपि जनो ममान्तिकम् आयातुं न शक्नोति किन्त्वागतं जनं चरमेऽह्नि प्रोत्थापयिष्यामि। ");
INSERT INTO sandev_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","ते सर्व्व ईश्वरेण शिक्षिता भविष्यन्ति भविष्यद्वादिनां ग्रन्थेषु लिपिरित्थमास्ते अतो यः कश्चित् पितुः सकाशात् श्रुत्वा शिक्षते स एव मम समीपम् आगमिष्यति। ");
INSERT INTO sandev_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","य ईश्वराद् अजायत तं विना कोपि मनुष्यो जनकं नादर्शत् केवलः सएव तातम् अद्राक्षीत्। ");
INSERT INTO sandev_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","अहं युष्मान् यथार्थतरं वदामि यो जनो मयि विश्वासं करोति सोनन्तायुः प्राप्नोति। ");
INSERT INTO sandev_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","अहमेव तज्जीवनभक्ष्यं। ");
INSERT INTO sandev_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","युष्माकं पूर्व्वपुरुषा महाप्रान्तरे मन्नाभक्ष्यं भूक्त्तापि मृताः ");
INSERT INTO sandev_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","किन्तु यद्भक्ष्यं स्वर्गादागच्छत् तद् यदि कश्चिद् भुङ्क्त्ते तर्हि स न म्रियते। ");
INSERT INTO sandev_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","यज्जीवनभक्ष्यं स्वर्गादागच्छत् सोहमेव इदं भक्ष्यं यो जनो भुङ्क्त्ते स नित्यजीवी भविष्यति। पुनश्च जगतो जीवनार्थमहं यत् स्वकीयपिशितं दास्यामि तदेव मया वितरितं भक्ष्यम्। ");
INSERT INTO sandev_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","तस्माद् यिहूदीयाः परस्परं विवदमाना वक्त्तुमारेभिरे एष भोजनार्थं स्वीयं पललं कथम् अस्मभ्यं दास्यति? ");
INSERT INTO sandev_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","तदा यीशुस्तान् आवोचद् युष्मानहं यथार्थतरं वदामि मनुष्यपुत्रस्यामिषे युष्माभि र्न भुक्त्ते तस्य रुधिरे च न पीते जीवनेन सार्द्धं युष्माकं सम्बन्धो नास्ति। ");
INSERT INTO sandev_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","यो ममामिषं स्वादति मम सुधिरञ्च पिवति सोनन्तायुः प्राप्नोति ततः शेषेऽह्नि तमहम् उत्थापयिष्यामि। ");
INSERT INTO sandev_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","यतो मदीयमामिषं परमं भक्ष्यं तथा मदीयं शोणितं परमं पेयं। ");
INSERT INTO sandev_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","यो जनो मदीयं पललं स्वादति मदीयं रुधिरञ्च पिवति स मयि वसति तस्मिन्नहञ्च वसामि। ");
INSERT INTO sandev_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","मत्प्रेरयित्रा जीवता तातेन यथाहं जीवामि तद्वद् यः कश्चिन् मामत्ति सोपि मया जीविष्यति। ");
INSERT INTO sandev_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","यद्भक्ष्यं स्वर्गादागच्छत् तदिदं यन्मान्नां स्वादित्वा युष्माकं पितरोऽम्रियन्त तादृशम् इदं भक्ष्यं न भवति इदं भक्ष्यं यो भक्षति स नित्यं जीविष्यति। ");
INSERT INTO sandev_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","यदा कफर्नाहूम् पुर्य्यां भजनगेहे उपादिशत् तदा कथा एता अकथयत्। ");
INSERT INTO sandev_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","तदेत्थं श्रुत्वा तस्य शिष्याणाम् अनेके परस्परम् अकथयन् इदं गाढं वाक्यं वाक्यमीदृशं कः श्रोतुं शक्रुयात्? ");
INSERT INTO sandev_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","किन्तु यीशुः शिष्याणाम् इत्थं विवादं स्वचित्ते विज्ञाय कथितवान् इदं वाक्यं किं युष्माकं विघ्नं जनयति? ");
INSERT INTO sandev_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","यदि मनुजसुतं पूर्व्ववासस्थानम् ऊर्द्व्वं गच्छन्तं पश्यथ तर्हि किं भविष्यति? ");
INSERT INTO sandev_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","आत्मैव जीवनदायकः वपु र्निष्फलं युष्मभ्यमहं यानि वचांसि कथयामि तान्यात्मा जीवनञ्च। ");
INSERT INTO sandev_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","किन्तु युष्माकं मध्ये केचन अविश्वासिनः सन्ति के के न विश्वसन्ति को वा तं परकरेषु समर्पयिष्यति तान् यीशुराप्रथमाद् वेत्ति। ");
INSERT INTO sandev_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","अपरमपि कथितवान् अस्मात् कारणाद् अकथयं पितुः सकाशात् शक्त्तिमप्राप्य कोपि ममान्तिकम् आगन्तुं न शक्नोति। ");
INSERT INTO sandev_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","तत्कालेऽनेके शिष्या व्याघुट्य तेन सार्द्धं पुन र्नागच्छन्। ");
INSERT INTO sandev_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","तदा यीशु र्द्वादशशिष्यान् उक्त्तवान् यूयमपि किं यास्यथ? ");
INSERT INTO sandev_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ततः शिमोन् पितरः प्रत्यवोचत् हे प्रभो कस्याभ्यर्णं गमिष्यामः? ");
INSERT INTO sandev_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","अनन्तजीवनदायिन्यो याः कथास्तास्तवैव। भवान् अमरेश्वरस्याभिषिक्त्तपुत्र इति विश्वस्य निश्चितं जानीमः। ");
INSERT INTO sandev_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","तदा यीशुरवदत् किमहं युष्माकं द्वादशजनान् मनोनीतान् न कृतवान्? किन्तु युष्माकं मध्येपि कश्चिदेको विघ्नकारी विद्यते। ");
INSERT INTO sandev_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","इमां कथं स शिमोनः पुत्रम् ईष्करीयोतीयं यिहूदाम् उद्दिश्य कथितवान् यतो द्वादशानां मध्ये गणितः स तं परकरेषु समर्पयिष्यति। ");
INSERT INTO sandev_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","ततः परं यिहूदीयलोकास्तं हन्तुं समैहन्त तस्माद् यीशु र्यिहूदाप्रदेशे पर्य्यटितुं नेच्छन् गालील् प्रदेशे पर्य्यटितुं प्रारभत। ");
INSERT INTO sandev_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","किन्तु तस्मिन् समये यिहूदीयानां दूष्यवासनामोत्सव उपस्थिते ");
INSERT INTO sandev_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","तस्य भ्रातरस्तम् अवदन् यानि कर्म्माणि त्वया क्रियन्ते तानि यथा तव शिष्याः पश्यन्ति तदर्थं त्वमितः स्थानाद् यिहूदीयदेशं व्रज। ");
INSERT INTO sandev_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","यः कश्चित् स्वयं प्रचिकाशिषति स कदापि गुप्तं कर्म्म न करोति यदीदृशं कर्म्म करोषि तर्हि जगति निजं परिचायय। ");
INSERT INTO sandev_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","यतस्तस्य भ्रातरोपि तं न विश्वसन्ति। ");
INSERT INTO sandev_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","तदा यीशुस्तान् अवोचत् मम समय इदानीं नोपतिष्ठति किन्तु युष्माकं समयः सततम् उपतिष्ठति। ");
INSERT INTO sandev_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","जगतो लोका युष्मान् ऋतीयितुं न शक्रुवन्ति किन्तु मामेव ऋतीयन्ते यतस्तेषां कर्माणि दुष्टानि तत्र साक्ष्यमिदम् अहं ददामि। ");
INSERT INTO sandev_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","अतएव यूयम् उत्सवेऽस्मिन् यात नाहम् इदानीम् अस्मिन्नुत्सवे यामि यतो मम समय इदानीं न सम्पूर्णः। ");
INSERT INTO sandev_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","इति वाक्यम् उक्त्त्वा स गालीलि स्थितवान् ");
INSERT INTO sandev_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","किन्तु तस्य भ्रातृषु तत्र प्रस्थितेषु सत्सु सोऽप्रकट उत्सवम् अगच्छत्। ");
INSERT INTO sandev_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","अनन्तरम् उत्सवम् उपस्थिता यिहूदीयास्तं मृगयित्वापृच्छन् स कुत्र? ");
INSERT INTO sandev_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","ततो लोकानां मध्ये तस्मिन् नानाविधा विवादा भवितुम् आरब्धवन्तः। केचिद् अवोचन् स उत्तमः पुरुषः केचिद् अवोचन् न तथा वरं लोकानां भ्रमं जनयति। ");
INSERT INTO sandev_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","किन्तु यिहूदीयानां भयात् कोपि तस्य पक्षे स्पष्टं नाकथयत्। ");
INSERT INTO sandev_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ततः परम् उत्सवस्य मध्यसमये यीशु र्मन्दिरं गत्वा समुपदिशति स्म। ");
INSERT INTO sandev_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ततो यिहूदीया लोका आश्चर्य्यं ज्ञात्वाकथयन् एषा मानुषो नाधीत्या कथम् एतादृशो विद्वानभूत्? ");
INSERT INTO sandev_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","तदा यीशुः प्रत्यवोचद् उपदेशोयं न मम किन्तु यो मां प्रेषितवान् तस्य। ");
INSERT INTO sandev_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","यो जनो निदेशं तस्य ग्रहीष्यति ममोपदेशो मत्तो भवति किम् ईश्वराद् भवति स गनस्तज्ज्ञातुं शक्ष्यति। ");
INSERT INTO sandev_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","यो जनः स्वतः कथयति स स्वीयं गौरवम् ईहते किन्तु यः प्रेरयितु र्गौरवम् ईहते स सत्यवादी तस्मिन् कोप्यधर्म्मो नास्ति। ");
INSERT INTO sandev_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","मूसा युष्मभ्यं व्यवस्थाग्रन्थं किं नाददात्? किन्तु युष्माकं कोपि तां व्यवस्थां न समाचरति। मां हन्तुं कुतो यतध्वे? ");
INSERT INTO sandev_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","तदा लोका अवदन् त्वं भूतग्रस्तस्त्वां हन्तुं को यतते? ");
INSERT INTO sandev_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ततो यीशुरवोचद् एकं कर्म्म मयाकारि तस्माद् यूयं सर्व्व महाश्चर्य्यं मन्यध्वे। ");
INSERT INTO sandev_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","मूसा युष्मभ्यं त्वक्छेदविधिं प्रददौ स मूसातो न जातः किन्तु पितृपुरुषेभ्यो जातः तेन विश्रामवारेऽपि मानुषाणां त्वक्छेदं कुरुथ। ");
INSERT INTO sandev_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","अतएव विश्रामवारे मनुष्याणां त्वक्छेदे कृते यदि मूसाव्यवस्थामङ्गनं न भवति तर्हि मया विश्रामवारे मानुषः सम्पूर्णरूपेण स्वस्थोऽकारि तत्कारणाद् यूयं किं मह्यं कुप्यथ? ");
INSERT INTO sandev_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","सपक्षपातं विचारमकृत्वा न्याय्यं विचारं कुरुत। ");
INSERT INTO sandev_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","तदा यिरूशालम् निवासिनः कतिपयजना अकथयन् इमे यं हन्तुं चेष्टन्ते स एवायं किं न? ");
INSERT INTO sandev_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","किन्तु पश्यत निर्भयः सन् कथां कथयति तथापि किमपि अ वदन्त्येते अयमेवाभिषिक्त्तो भवतीति निश्चितं किमधिपतयो जानन्ति? ");
INSERT INTO sandev_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","मनुजोयं कस्मादागमद् इति वयं जानोमः किन्त्वभिषिक्त्त आगते स कस्मादागतवान् इति कोपि ज्ञातुं न शक्ष्यति। ");
INSERT INTO sandev_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","तदा यीशु र्मध्येमन्दिरम् उपदिशन् उच्चैःकारम् उक्त्तवान् यूयं किं मां जानीथ? कस्माच्चागतोस्मि तदपि किं जानीथ? नाहं स्वत आगतोस्मि किन्तु यः सत्यवादी सएव मां प्रेषितवान् यूयं तं न जानीथ। ");
INSERT INTO sandev_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","तमहं जाने तेनाहं प्रेरित अगतोस्मि। ");
INSERT INTO sandev_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","तस्माद् यिहूदीयास्तं धर्त्तुम् उद्यतास्तथापि कोपि तस्य गात्रे हस्तं नार्पयद् यतो हेतोस्तदा तस्य समयो नोपतिष्ठति। ");
INSERT INTO sandev_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","किन्तु बहवो लोकास्तस्मिन् विश्वस्य कथितवान्तोऽभिषिक्त्तपुरुष आगत्य मानुषस्यास्य क्रियाभ्यः किम् अधिका आश्चर्य्याः क्रियाः करिष्यति? ");
INSERT INTO sandev_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","ततः परं लोकास्तस्मिन् इत्थं विवदन्ते फिरूशिनः प्रधानयाजकाञ्चेति श्रुतवन्तस्तं धृत्वा नेतुं पदातिगणं प्रेषयामासुः। ");
INSERT INTO sandev_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ततो यीशुरवदद् अहम् अल्पदिनानि युष्माभिः सार्द्धं स्थित्वा मत्प्रेरयितुः समीपं यास्यामि। ");
INSERT INTO sandev_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","मां मृगयिष्यध्वे किन्तूद्देशं न लप्स्यध्वे रत्र स्थास्यामि तत्र यूयं गन्तुं न शक्ष्यथ। ");
INSERT INTO sandev_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","तदा यिहूदीयाः परस्परं वक्त्तुमारेभिरे अस्योद्देशं न प्राप्स्याम एतादृशं किं स्थानं यास्यति? भिन्नदेशे विकीर्णानां यिहूदीयानां सन्निधिम् एष गत्वा तान् उपदेक्ष्यति किं? ");
INSERT INTO sandev_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","नो चेत् मां गवेषयिष्यथ किन्तूद्देशं न प्राप्स्यथ एष कोदृशं वाक्यमिदं वदति? ");
INSERT INTO sandev_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","अनन्तरम् उत्सवस्य चरमेऽहनि अर्थात् प्रधानदिने यीशुरुत्तिष्ठन् उच्चैःकारम् आह्वयन् उदितवान् यदि कश्चित् तृषार्त्तो भवति तर्हि ममान्तिकम् आगत्य पिवतु। ");
INSERT INTO sandev_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","यः कश्चिन्मयि विश्वसिति धर्म्मग्रन्थस्य वचनानुसारेण तस्याभ्यन्तरतोऽमृततोयस्य स्रोतांसि निर्गमिष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ये तस्मिन् विश्वसन्ति त आत्मानं प्राप्स्यन्तीत्यर्थे स इदं वाक्यं व्याहृतवान् एतत्कालं यावद् यीशु र्विभवं न प्राप्तस्तस्मात् पवित्र आत्मा नादीयत। ");
INSERT INTO sandev_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","एतां वाणीं श्रुत्वा बहवो लोका अवदन् अयमेव निश्चितं स भविष्यद्वादी। ");
INSERT INTO sandev_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","केचिद् अकथयन् एषएव सोभिषिक्त्तः किन्तु केचिद् अवदन् सोभिषिक्त्तः किं गालील् प्रदेशे जनिष्यते? ");
INSERT INTO sandev_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","सोभिषिक्त्तो दायूदो वंशे दायूदो जन्मस्थाने बैत्लेहमि पत्तने जनिष्यते धर्म्मग्रन्थे किमित्थं लिखितं नास्ति? ");
INSERT INTO sandev_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","इत्थं तस्मिन् लोकानां भिन्नवाक्यता जाता। ");
INSERT INTO sandev_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","कतिपयलोकास्तं धर्त्तुम् ऐच्छन् तथापि तद्वपुषि कोपि हस्तं नार्पयत्। ");
INSERT INTO sandev_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","अनन्तरं पादातिगणे प्रधानयाजकानां फिरूशिनाञ्च समीपमागतवति ते तान् अपृच्छन् कुतो हेतोस्तं नानयत? ");
INSERT INTO sandev_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","तदा पदातयः प्रत्यवदन् स मानव इव कोपि कदापि नोपादिशत्। ");
INSERT INTO sandev_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ततः फिरूशिनः प्रावोचन् यूयमपि किमभ्रामिष्ट? ");
INSERT INTO sandev_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","अधिपतीनां फिरूशिनाञ्च कोपि किं तस्मिन् व्यश्वसीत्? ");
INSERT INTO sandev_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ये शास्त्रं न जानन्ति त इमेऽधमलोकाएव शापग्रस्ताः। ");
INSERT INTO sandev_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","तदा निकदीमनामा तेषामेको यः क्षणदायां यीशोः सन्निधिम् अगात् स उक्त्तवान् ");
INSERT INTO sandev_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","तस्य वाक्ये न श्रुते कर्म्मणि च न विदिते ऽस्माकं व्यवस्था किं कञ्चन मनुजं दोषीकरोति? ");
INSERT INTO sandev_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ततस्ते व्याहरन् त्वमपि किं गालीलीयलोकः? विविच्य पश्य गलीलि कोपि भविष्यद्वादी नोत्पद्यते। ");
INSERT INTO sandev_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","ततः परं सर्व्वे स्वं स्वं गृहं गताः किन्तु यीशु र्जैतुननामानं शिलोच्चयं गतवान्। ");
INSERT INTO sandev_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","प्रत्यूषे यीशुः पनर्मन्दिरम् आगच्छत् ");
INSERT INTO sandev_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ततः सर्व्वेषु लोकेषु तस्य समीप आगतेषु स उपविश्य तान् उपदेष्टुम् आरभत। ");
INSERT INTO sandev_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","तदा अध्यापकाः फिरूशिनञ्च व्यभिचारकर्म्मणि धृतं स्त्रियमेकाम् आनिय सर्व्वेषां मध्ये स्थापयित्वा व्याहरन् ");
INSERT INTO sandev_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","हे गुरो योषितम् इमां व्यभिचारकर्म्म कुर्व्वाणां लोका धृतवन्तः। ");
INSERT INTO sandev_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","एतादृशलोकाः पाषाणाघातेन हन्तव्या इति विधिर्मूसाव्यवस्थाग्रन्थे लिखितोस्ति किन्तु भवान् किमादिशति? ");
INSERT INTO sandev_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","ते तमपवदितुं परीक्षाभिप्रायेण वाक्यमिदम् अपृच्छन् किन्तु स प्रह्वीभूय भूमावङ्गल्या लेखितुम् आरभत। ");
INSERT INTO sandev_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ततस्तैः पुनः पुनः पृष्ट उत्थाय कथितवान् युष्माकं मध्ये यो जनो निरपराधी सएव प्रथमम् एनां पाषाणेनाहन्तु। ");
INSERT INTO sandev_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","पश्चात् स पुनश्च प्रह्वीभूय भूमौ लेखितुम् आरभत। ");
INSERT INTO sandev_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","तां कथं श्रुत्वा ते स्वस्वमनसि प्रबोधं प्राप्य ज्येष्ठानुक्रमं एकैकशः सर्व्वे बहिरगच्छन् ततो यीशुरेकाकी तयक्त्तोभवत् मध्यस्थाने दण्डायमाना सा योषा च स्थिता। ");
INSERT INTO sandev_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","तत्पश्चाद् यीशुरुत्थाय तां वनितां विना कमप्यपरं न विलोक्य पृष्टवान् हे वामे तवापवादकाः कुत्र? कोपि त्वां किं न दण्डयति? ");
INSERT INTO sandev_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","सावदत् हे महेच्छ कोपि न तदा यीशुरवोचत् नाहमपि दण्डयामि याहि पुनः पापं माकार्षीः। ");
INSERT INTO sandev_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","ततो यीशुः पुनरपि लोकेभ्य इत्थं कथयितुम् आरभत जगतोहं ज्योतिःस्वरूपो यः कश्चिन् मत्पश्चाद गच्छति स तिमिरे न भ्रमित्वा जीवनरूपां दीप्तिं प्राप्स्यति। ");
INSERT INTO sandev_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ततः फिरूशिनोऽवादिषुस्त्वं स्वार्थे स्वयं साक्ष्यं ददासि तस्मात् तव साक्ष्यं ग्राह्यं न भवति। ");
INSERT INTO sandev_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","तदा यीशुः प्रत्युदितवान् यद्यपि स्वार्थेऽहं स्वयं साक्ष्यं ददामि तथापि मत् साक्ष्यं ग्राह्यं यस्माद् अहं कुत आगतोस्मि क्व यामि च तदहं जानामि किन्तु कुत आगतोस्मि कुत्र गच्छामि च तद् यूयं न जानीथ। ");
INSERT INTO sandev_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","यूयं लौकिकं विचारयथ नाहं किमपि विचारयामि। ");
INSERT INTO sandev_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","किन्तु यदि विचारयामि तर्हि मम विचारो ग्रहीतव्यो यतोहम् एकाकी नास्मि प्रेरयिता पिता मया सह विद्यते। ");
INSERT INTO sandev_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","द्वयो र्जनयोः साक्ष्यं ग्रहणीयं भवतीति युष्माकं व्यवस्थाग्रन्थे लिखितमस्ति। ");
INSERT INTO sandev_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","अहं स्वार्थे स्वयं साक्षित्वं ददामि यश्च मम तातो मां प्रेरितवान् सोपि मदर्थे साक्ष्यं ददाति। ");
INSERT INTO sandev_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","तदा तेऽपृच्छन् तव तातः कुत्र? ततो यीशुः प्रत्यवादीद् यूयं मां न जानीथ मत्पितरञ्च न जानीथ यदि माम् अक्षास्यत तर्हि मम तातमप्यक्षास्यत। ");
INSERT INTO sandev_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","यीशु र्मन्दिर उपदिश्य भण्डागारे कथा एता अकथयत् तथापि तं प्रति कोपि करं नोदतोलयत्। ");
INSERT INTO sandev_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ततः परं यीशुः पुनरुदितवान् अधुनाहं गच्छामि यूयं मां गवेषयिष्यथ किन्तु निजैः पापै र्मरिष्यथ यत् स्थानम् अहं यास्यामि तत् स्थानम् यूयं यातुं न शक्ष्यथ। ");
INSERT INTO sandev_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","तदा यिहूदीयाः प्रावोचन् किमयम् आत्मघातं करिष्यति? यतो यत् स्थानम् अहं यास्यामि तत् स्थानम् यूयं यातुं न शक्ष्यथ इति वाक्यं ब्रवीति। ");
INSERT INTO sandev_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ततो यीशुस्तेभ्यः कथितवान् यूयम् अधःस्थानीया लोका अहम् ऊर्द्व्वस्थानीयः यूयम् एतज्जगत्सम्बन्धीया अहम् एतज्जगत्सम्बन्धीयो न। ");
INSERT INTO sandev_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","तस्मात् कथितवान् यूयं निजैः पापै र्मरिष्यथ यतोहं स पुमान् इति यदि न विश्वसिथ तर्हि निजैः पापै र्मरिष्यथ। ");
INSERT INTO sandev_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","तदा ते ऽपृच्छन् कस्त्वं? ततो यीशुः कथितवान् युष्माकं सन्निधौ यस्य प्रस्तावम् आ प्रथमात् करोमि सएव पुरुषोहं। ");
INSERT INTO sandev_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","युष्मासु मया बहुवाक्यं वक्त्तव्यं विचारयितव्यञ्च किन्तु मत्प्रेरयिता सत्यवादी तस्य समीपे यदहं श्रुतवान् तदेव जगते कथयामि। ");
INSERT INTO sandev_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","किन्तु स जनके वाक्यमिदं प्रोक्त्तवान् इति ते नाबुध्यन्त। ");
INSERT INTO sandev_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ततो यीशुरकथयद् यदा मनुष्यपुत्रम् ऊर्द्व्व उत्थापयिष्यथ तदाहं स पुमान् केवलः स्वयं किमपि कर्म्म न करोमि किन्तु तातो यथा शिक्षयति तदनुसारेण वाक्यमिदं वदामीति च यूयं ज्ञातुं शक्ष्यथ। ");
INSERT INTO sandev_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","मत्प्रेरयिता पिता माम् एकाकिनं न त्यजति स मया सार्द्धं तिष्ठति यतोहं तदभिमतं कर्म्म सदा करोमि। ");
INSERT INTO sandev_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","तदा तस्यैतानि वाक्यानि श्रुत्वा बहुवस्तास्मिन् व्यश्वसन्। ");
INSERT INTO sandev_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","ये यिहूदीया व्यश्वसन् यीशुस्तेभ्योऽकथयत् ");
INSERT INTO sandev_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","मम वाक्ये यदि यूयम् आस्थां कुरुथ तर्हि मम शिष्या भूत्वा सत्यत्वं ज्ञास्यथ ततः सत्यतया युष्माकं मोक्षो भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","तदा ते प्रत्यवादिषुः वयम् इब्राहीमो वंशः कदापि कस्यापि दासा न जातास्तर्हि युष्माकं मुक्त्ति र्भविष्यतीति वाक्यं कथं ब्रवीषि? ");
INSERT INTO sandev_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","तदा यीशुः प्रत्यवदद् युष्मानहं यथार्थतरं वदामि यः पापं करोति स पापस्य दासः। ");
INSERT INTO sandev_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","दासश्च निरन्तरं निवेशने न तिष्ठति किन्तु पुत्रो निरन्तरं तिष्ठति। ");
INSERT INTO sandev_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","अतः पुत्रो यदि युष्मान् मोचयति तर्हि नितान्तमेव मुक्त्ता भविष्यथ। ");
INSERT INTO sandev_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","युयम् इब्राहीमो वंश इत्यहं जानामि किन्तु मम कथा युष्माकम् अन्तःकरणेषु स्थानं न प्राप्नुवन्ति तस्माद्धेतो र्मां हन्तुम् ईहध्वे। ");
INSERT INTO sandev_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","अहं स्वपितुः समीपे यदपश्यं तदेव कथयामि तथा यूयमपि स्वपितुः समीपे यदपश्यत तदेव कुरुध्वे। ");
INSERT INTO sandev_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","तदा ते प्रत्यवोचन् इब्राहीम् अस्माकं पिता ततो यीशुरकथयद् यदि यूयम् इब्राहीमः सन्ताना अभविष्यत तर्हि इब्राहीम आचारणवद् आचरिष्यत। ");
INSERT INTO sandev_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ईश्वरस्य मुखात् सत्यं वाक्यं श्रुत्वा युष्मान् ज्ञापयामि योहं तं मां हन्तुं चेष्टध्वे इब्राहीम् एतादृशं कर्म्म न चकार। ");
INSERT INTO sandev_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","यूयं स्वस्वपितुः कर्म्माणि कुरुथ तदा तैरुक्त्तं न वयं जारजाता अस्माकम् एकएव पितास्ति स एवेश्वरः ");
INSERT INTO sandev_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ततो यीशुना कथितम् ईश्वरो यदि युष्माकं तातोभविष्यत् तर्हि यूयं मयि प्रेमाकरिष्यत यतोहम् ईश्वरान्निर्गत्यागतोस्मि स्वतो नागतोहं स मां प्राहिणोत्। ");
INSERT INTO sandev_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","यूयं मम वाक्यमिदं न बुध्यध्वे कुतः? यतो यूयं ममोपदेशं सोढुं न शक्नुथ। ");
INSERT INTO sandev_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","यूयं शैतान् पितुः सन्ताना एतस्माद् युष्माकं पितुरभिलाषं पूरयथ स आ प्रथमात् नरघाती तदन्तः सत्यत्वस्य लेशोपि नास्ति कारणादतः स सत्यतायां नातिष्ठत् स यदा मृषा कथयति तदा निजस्वभावानुसारेणैव कथयति यतो स मृषाभाषी मृषोत्पादकश्च। ");
INSERT INTO sandev_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","अहं तथ्यवाक्यं वदामि कारणादस्माद् यूयं मां न प्रतीथ। ");
INSERT INTO sandev_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","मयि पापमस्तीति प्रमाणं युष्माकं को दातुं शक्नोति? यद्यहं तथ्यवाक्यं वदामि तर्हि कुतो मां न प्रतिथ? ");
INSERT INTO sandev_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","यः कश्चन ईश्वरीयो लोकः स ईश्वरीयकथायां मनो निधत्ते यूयम् ईश्वरीयलोका न भवथ तन्निदानात् तत्र न मनांसि निधद्वे। ");
INSERT INTO sandev_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","तदा यिहूदीयाः प्रत्यवादिषुः त्वमेकः शोमिरोणीयो भूतग्रस्तश्च वयं किमिदं भद्रं नावादिष्म? ");
INSERT INTO sandev_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ततो यीशुः प्रत्यवादीत् नाहं भूतग्रस्तः किन्तु निजतातं सम्मन्ये तस्माद् यूयं माम् अपमन्यध्वे। ");
INSERT INTO sandev_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","अहं स्वसुख्यातिं न चेष्टे किन्तु चेष्टिता विचारयिता चापर एक आस्ते। ");
INSERT INTO sandev_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","अहं युष्मभ्यम् अतीव यथार्थं कथयामि यो नरो मदीयं वाचं मन्यते स कदाचन निधनं न द्रक्ष्यति। ");
INSERT INTO sandev_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","यिहूदीयास्तमवदन् त्वं भूतग्रस्त इतीदानीम् अवैष्म। इब्राहीम् भविष्यद्वादिनञ्च सर्व्वे मृताः किन्तु त्वं भाषसे यो नरो मम भारतीं गृह्लाति स जातु निधानास्वादं न लप्स्यते। ");
INSERT INTO sandev_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","तर्हि त्वं किम् अस्माकं पूर्व्वपुरुषाद् इब्राहीमोपि महान्? यस्मात् सोपि मृतः भविष्यद्वादिनोपि मृताः त्वं स्वं कं पुमांसं मनुषे? ");
INSERT INTO sandev_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","यीशुः प्रत्यवोचद् यद्यहं स्वं स्वयं सम्मन्ये तर्हि मम तत् सम्मननं किमपि न किन्तु मम तातो यं यूयं स्वीयम् ईश्वरं भाषध्वे सएव मां सम्मनुते। ");
INSERT INTO sandev_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","यूयं तं नावगच्छथ किन्त्वहं तमवगच्छामि तं नावगच्छामीति वाक्यं यदि वदामि तर्हि यूयमिव मृषाभाषी भवामि किन्त्वहं तमवगच्छामि तदाक्षामपि गृह्लामि। ");
INSERT INTO sandev_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","युष्माकं पूर्व्वपुरुष इब्राहीम् मम समयं द्रष्टुम् अतीवावाञ्छत् तन्निरीक्ष्यानन्दच्च। ");
INSERT INTO sandev_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","तदा यिहूदीया अपृच्छन् तव वयः पञ्चाशद्वत्सरा न त्वं किम् इब्राहीमम् अद्राक्षीः? ");
INSERT INTO sandev_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","यीशुः प्रत्यवादीद् युष्मानहं यथार्थतरं वदामि इब्राहीमो जन्मनः पूर्व्वकालमारभ्याहं विद्ये। ");
INSERT INTO sandev_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","तदा ते पाषाणान् उत्तोल्य तमाहन्तुम् उदयच्छन् किन्तु यीशु र्गुप्तो मन्तिराद् बहिर्गत्य तेषां मध्येन प्रस्थितवान्। ");
INSERT INTO sandev_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","ततः परं यीशुर्गच्छन् मार्गमध्ये जन्मान्धं नरम् अपश्यत्। ");
INSERT INTO sandev_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ततः शिष्यास्तम् अपृच्छन् हे गुरो नरोयं स्वपापेन वा स्वपित्राः पापेनान्धोऽजायत? ");
INSERT INTO sandev_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","ततः स प्रत्युदितवान् एतस्य वास्य पित्रोः पापाद् एतादृशोभूद इति नहि किन्त्वनेन यथेश्वरस्य कर्म्म प्रकाश्यते तद्धेतोरेव। ");
INSERT INTO sandev_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","दिने तिष्ठति मत्प्रेरयितुः कर्म्म मया कर्त्तव्यं यदा किमपि कर्म्म न क्रियते तादृशी निशागच्छति। ");
INSERT INTO sandev_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","अहं यावत्कालं जगति तिष्ठामि तावत्कालं जगतो ज्योतिःस्वरूपोस्मि। ");
INSERT INTO sandev_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","इत्युक्त्ता भूमौ निष्ठीवं निक्षिप्य तेन पङ्कं कृतवान् ");
INSERT INTO sandev_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","पश्चात् तत्पङ्केन तस्यान्धस्य नेत्रे प्रलिप्य तमित्यादिशत् गत्वा शिलोहे ऽर्थात् प्रेरितनाम्नि सरसि स्नाहि। ततोन्धो गत्वा तत्रास्नात् ततः प्रन्नचक्षु र्भूत्वा व्याघुट्यागात्। ");
INSERT INTO sandev_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","अपरञ्च समीपवासिनो लोका ये च तं पूर्व्वमन्धम् अपश्यन् ते बक्त्तुम् आरभन्त योन्धलोको वर्त्मन्युपविश्याभिक्षत स एवायं जनः किं न भवति? ");
INSERT INTO sandev_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","केचिदवदन् स एव केचिदवोचन् तादृशो भवति किन्तु स स्वयमब्रवीत् स एवाहं भवामि। ");
INSERT INTO sandev_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","अतएव ते ऽपृच्छन् त्वं कथं दृष्टिं पाप्तवान्? ");
INSERT INTO sandev_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ततः सोवदद् यीशनामक एको जनो मम नयने पङ्केन प्रलिप्य इत्याज्ञापयत् शिलोहकासारं गत्वा तत्र स्नाहि। ततस्तत्र गत्वा मयि स्नाते दृष्टिमहं लब्धवान्। ");
INSERT INTO sandev_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","तदा ते ऽवदन् स पुमान् कुत्र? तेनोक्त्तं नाहं जानामि। ");
INSERT INTO sandev_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","अपरं तस्मिन् पूर्व्वान्धे जने फिरूशिनां निकटम् आनीते सति फिरूशिनोपि तमपृच्छन् कथं दृष्टिं प्राप्तोसि? ");
INSERT INTO sandev_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ततः स कथितवान् स पङ्केन मम नेत्रे ऽलिम्पत् पश्चाद् स्नात्वा दृष्टिमलभे। ");
INSERT INTO sandev_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","किन्तु यीशु र्विश्रामवारे कर्द्दमं कृत्वा तस्य नयने प्रसन्नेऽकरोद् इतिकारणात् कतिपयफिरूशिनोऽवदन् ");
INSERT INTO sandev_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","स पुमान् ईश्वरान्न यतः स विश्रामवारं न मन्यते। ततोन्ये केचित् प्रत्यवदन् पापी पुमान् किम् एतादृशम् आश्चर्य्यं कर्म्म कर्त्तुं शक्नोति? ");
INSERT INTO sandev_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","इत्थं तेषां परस्परं भिन्नवाक्यत्वम् अभवत्। पश्चात् ते पुनरपि तं पूर्व्वान्धं मानुषम् अप्राक्षुः यो जनस्तव चक्षुषी प्रसन्ने कृतवान् तस्मिन् त्वं किं वदसि? स उक्त्तवान् स भविशद्वादी। ");
INSERT INTO sandev_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","स दृष्टिम् आप्तवान् इति यिहूदीयास्तस्य दृष्टिं प्राप्तस्य जनस्य पित्रो र्मुखाद् अश्रुत्वा न प्रत्ययन्। ");
INSERT INTO sandev_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","अतएव ते तावपृच्छन् युवयो र्यं पुत्रं जन्मान्धं वदथः स किमयं? तर्हीदानीं कथं द्रष्टुं शक्नोति? ");
INSERT INTO sandev_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ततस्तस्य पितरौ प्रत्यवोचताम् अयम् आवयोः पुत्र आ जनेरन्धश्च तदप्यावां जानीवः ");
INSERT INTO sandev_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","किन्त्वधुना कथं दृष्टिं प्राप्तवान् तदावां न् जानीवः कोस्य चक्षुषी प्रसन्ने कृतवान् तदपि न जानीव एष वयःप्राप्त एनं पृच्छत स्वकथां स्वयं वक्ष्यति। ");
INSERT INTO sandev_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","यिहूदीयानां भयात् तस्य पितरौ वाक्यमिदम् अवदतां यतः कोपि मनुष्यो यदि यीशुम् अभिषिक्तं वदति तर्हि स भजनगृहाद् दूरीकारिष्यते यिहूदीया इति मन्त्रणाम् अकुर्व्वन् ");
INSERT INTO sandev_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","अतस्तस्य पितरौ व्याहरताम् एष वयःप्राप्त एनं पृच्छत। ");
INSERT INTO sandev_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","तदा ते पुनश्च तं पूर्व्वान्धम् आहूय व्याहरन् ईश्वरस्य गुणान् वद एष मनुष्यः पापीति वयं जानीमः। ");
INSERT INTO sandev_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","तदा स उक्त्तवान् स पापी न वेति नाहं जाने पूर्वामन्ध आसमहम् अधुना पश्यामीति मात्रं जानामि। ");
INSERT INTO sandev_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ते पुनरपृच्छन् स त्वां प्रति किमकरोत्? कथं नेत्रे प्रसन्ने ऽकरोत्? ");
INSERT INTO sandev_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","ततः सोवादीद् एककृत्वोकथयं यूयं न शृणुथ तर्हि कुतः पुनः श्रोतुम् इच्छथ? यूयमपि किं तस्य शिष्या भवितुम् इच्छथ? ");
INSERT INTO sandev_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","तदा ते तं तिरस्कृत्य व्याहरन् त्वं तस्य शिष्यो वयं मूसाः शिष्याः। ");
INSERT INTO sandev_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","मूसावक्त्रेणेश्वरो जगाद तज्जानीमः किन्त्वेष कुत्रत्यलोक इति न जानीमः। ");
INSERT INTO sandev_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","सोवदद् एष मम लोचने प्रसन्ने ऽकरोत् तथापि कुत्रत्यलोक इति यूयं न जानीथ एतद् आश्चर्य्यं भवति। ");
INSERT INTO sandev_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ईश्वरः पापिनां कथां न शृणोति किन्तु यो जनस्तस्मिन् भक्तिं कृत्वा तदिष्टक्रियां करोति तस्यैव कथां शृणोति एतद् वयं जानीमः। ");
INSERT INTO sandev_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","कोपि मनुष्यो जन्मान्धाय चक्षुषी अददात् जगदारम्भाद् एतादृशीं कथां कोपि कदापि नाशृणोत्। ");
INSERT INTO sandev_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","अस्माद् एष मनुष्यो यदीश्वरान्नाजायत तर्हि किञ्चिदपीदृशं कर्म्म कर्त्तुं नाशक्नोत्। ");
INSERT INTO sandev_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","ते व्याहरन् त्वं पापाद् अजायथाः किमस्मान् त्वं शिक्षयसि? पश्चात्ते तं बहिरकुर्व्वन्। ");
INSERT INTO sandev_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","तदनन्तरं यिहूदीयैः स बहिरक्रियत यीशुरिति वार्त्तां श्रुत्वा तं साक्षात् प्राप्य पृष्टवान् ईश्वरस्य पुत्रे त्वं विश्वसिषि? ");
INSERT INTO sandev_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","तदा स प्रत्यवोचत् हे प्रभो स को यत् तस्मिन्नहं विश्वसिमि? ");
INSERT INTO sandev_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","ततो यीशुः कथितवान् त्वं तं दृष्टवान् त्वया साकं यः कथं कथयति सएव सः। ");
INSERT INTO sandev_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","तदा हे प्रभो विश्वसिमीत्युक्त्वा स तं प्रणामत्। ");
INSERT INTO sandev_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","पश्चाद् यीशुः कथितवान् नयनहीना नयनानि प्राप्नुवन्ति नयनवन्तश्चान्धा भवन्तीत्यभिप्रायेण जगदाहम् आगच्छम्। ");
INSERT INTO sandev_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","एतत् श्रुत्वा निकटस्थाः कतिपयाः फिरूशिनो व्याहरन् वयमपि किमन्धाः? ");
INSERT INTO sandev_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","तदा यीशुरवादीद् यद्यन्धा अभवत तर्हि पापानि नातिष्ठन् किन्तु पश्यामीति वाक्यवदनाद् युष्माकं पापानि तिष्ठन्ति। ");
INSERT INTO sandev_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","अहं युष्मानतियथार्थं वदामि, यो जनो द्वारेण न प्रविश्य केनाप्यन्येन मेषगृहं प्रविशति स एव स्तेनो दस्युश्च। ");
INSERT INTO sandev_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","यो द्वारेण प्रविशति स एव मेषपालकः। ");
INSERT INTO sandev_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","दौवारिकस्तस्मै द्वारं मोचयति मेषगणश्च तस्य वाक्यं शृणोति स निजान् मेषान् स्वस्वनाम्नाहूय बहिः कृत्वा नयति। ");
INSERT INTO sandev_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","तथा निजान् मेषान् बहिः कृत्वा स्वयं तेषाम् अग्रे गच्छति, ततो मेषास्तस्य शब्दं बुध्यन्ते, तस्मात् तस्य पश्चाद् व्रजन्ति। ");
INSERT INTO sandev_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","किन्तु परस्य शब्दं न बुध्यन्ते तस्मात् तस्य पश्चाद् व्रजिष्यन्ति वरं तस्य समीपात् पलायिष्यन्ते। ");
INSERT INTO sandev_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","यीशुस्तेभ्य इमां दृष्टान्तकथाम् अकथयत् किन्तु तेन कथितकथायास्तात्पर्य्यं ते नाबुध्यन्त। ");
INSERT INTO sandev_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","अतो यीशुः पुनरकथयत्, युष्मानाहं यथार्थतरं व्याहरामि, मेषगृहस्य द्वारम् अहमेव। ");
INSERT INTO sandev_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","मया न प्रविश्य य आगच्छन् ते स्तेना दस्यवश्च किन्तु मेषास्तेषां कथा नाशृण्वन्। ");
INSERT INTO sandev_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","अहमेव द्वारस्वरूपः, मया यः कश्चित प्रविशति स रक्षां प्राप्स्यति तथा बहिरन्तश्च गमनागमने कृत्वा चरणस्थानं प्राप्स्यति। ");
INSERT INTO sandev_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","यो जनस्तेनः स केवलं स्तैन्यबधविनाशान् कर्त्तुमेव समायाति किन्त्वहम् आयु र्दातुम् अर्थात् बाहूल्येन तदेव दातुम् आगच्छम्। ");
INSERT INTO sandev_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","अहमेव सत्यमेषपालको यस्तु सत्यो मेषपालकः स मेषार्थं प्राणत्यागं करोति; ");
INSERT INTO sandev_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","किन्तु यो जनो मेषपालको न, अर्थाद् यस्य मेषा निजा न भवन्ति, य एतादृशो वैतनिकः स वृकम् आगच्छन्तं दृष्ट्वा मेजव्रजं विहाय पलायते, तस्माद् वृकस्तं व्रजं धृत्वा विकिरति। ");
INSERT INTO sandev_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","वैतनिकः पलायते यतः स वेतनार्थी मेषार्थं न चिन्तयति। ");
INSERT INTO sandev_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","अहमेव सत्यो मेषपालकः, पिता मां यथा जानाति, अहञ्च यथा पितरं जानामि, ");
INSERT INTO sandev_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","तथा निजान् मेषानपि जानामि, मेषाश्च मां जानान्ति, अहञ्च मेषार्थं प्राणत्यागं करोमि। ");
INSERT INTO sandev_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","अपरञ्च एतद् गृहीय मेषेभ्यो भिन्ना अपि मेषा मम सन्ति ते सकला आनयितव्याः; ते मम शब्दं श्रोष्यन्ति तत एको व्रज एको रक्षको भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","प्राणानहं त्यक्त्वा पुनः प्राणान् ग्रहीष्यामि, तस्मात् पिता मयि स्नेहं करोति। ");
INSERT INTO sandev_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","कश्चिज्जनो मम प्राणान् हन्तुं न शक्नोति किन्तु स्वयं तान् समर्पयामि तान् समर्पयितुं पुनर्ग्रहीतुञ्च मम शक्तिरास्ते भारमिमं स्वपितुः सकाशात् प्राप्तोहम्। ");
INSERT INTO sandev_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","अस्मादुपदेशात् पुनश्च यिहूदीयानां मध्ये भिन्नवाक्यता जाता। ");
INSERT INTO sandev_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ततो बहवो व्याहरन् एष भूतग्रस्त उन्मत्तश्च, कुत एतस्य कथां शृणुथ? ");
INSERT INTO sandev_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","केचिद् अवदन् एतस्य कथा भूतग्रस्तस्य कथावन्न भवन्ति, भूतः किम् अन्धाय चक्षुषी दातुं शक्नोति? ");
INSERT INTO sandev_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","शीतकाले यिरूशालमि मन्दिरोत्सर्गपर्व्वण्युपस्थिते ");
INSERT INTO sandev_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","यीशुः सुलेमानो निःसारेण गमनागमने करोति, ");
INSERT INTO sandev_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","एतस्मिन् समये यिहूदीयास्तं वेष्टयित्वा व्याहरन् कति कालान् अस्माकं विचिकित्सां स्थापयिष्यामि? यद्यभिषिक्तो भवति तर्हि तत् स्पष्टं वद। ");
INSERT INTO sandev_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","तदा यीशुः प्रत्यवदद् अहम् अचकथं किन्तु यूयं न प्रतीथ, निजपितु र्नाम्ना यां यां क्रियां करोमि सा क्रियैव मम साक्षिस्वरूपा। ");
INSERT INTO sandev_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","किन्त्वहं पूर्व्वमकथयं यूयं मम मेषा न भवथ, कारणादस्मान् न विश्वसिथ। ");
INSERT INTO sandev_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","मम मेषा मम शब्दं शृण्वन्ति तानहं जानामि ते च मम पश्चाद् गच्छन्ति। ");
INSERT INTO sandev_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","अहं तेभ्योऽनन्तायु र्ददामि, ते कदापि न नंक्ष्यन्ति कोपि मम करात् तान् हर्त्तुं न शक्ष्यति। ");
INSERT INTO sandev_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","यो मम पिता तान् मह्यं दत्तवान् स सर्व्वस्मात् महान्, कोपि मम पितुः करात् तान् हर्त्तुं न शक्ष्यति। ");
INSERT INTO sandev_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","अहं पिता च द्वयोरेकत्वम्। ");
INSERT INTO sandev_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","ततो यिहूदीयाः पुनरपि तं हन्तुं पाषाणान् उदतोलयन्। ");
INSERT INTO sandev_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","यीशुः कथितवान् पितुः सकाशाद् बहून्युत्तमकर्म्माणि युष्माकं प्राकाशयं तेषां कस्य कर्म्मणः कारणान् मां पाषाणैराहन्तुम् उद्यताः स्थ? ");
INSERT INTO sandev_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","यिहूदीयाः प्रत्यवदन् प्रशस्तकर्म्महेतो र्न किन्तु त्वं मानुषः स्वमीश्वरम् उक्त्वेश्वरं निन्दसि कारणादस्मात् त्वां पाषाणैर्हन्मः। ");
INSERT INTO sandev_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","तदा यीशुः प्रत्युक्तवान् मया कथितं यूयम् ईश्वरा एतद्वचनं युष्माकं शास्त्रे लिखितं नास्ति किं? ");
INSERT INTO sandev_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","तस्माद् येषाम् उद्देशे ईश्वरस्य कथा कथिता ते यदीश्वरगणा उच्यन्ते धर्म्मग्रन्थस्याप्यन्यथा भवितुं न शक्यं, ");
INSERT INTO sandev_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","तर्ह्याहम् ईश्वरस्य पुत्र इति वाक्यस्य कथनात् यूयं पित्राभिषिक्तं जगति प्रेरितञ्च पुमांसं कथम् ईश्वरनिन्दकं वादय? ");
INSERT INTO sandev_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","यद्यहं पितुः कर्म्म न करोमि तर्हि मां न प्रतीत; ");
INSERT INTO sandev_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","किन्तु यदि करोमि तर्हि मयि युष्माभिः प्रत्यये न कृतेऽपि कार्य्ये प्रत्ययः क्रियतां, ततो मयि पितास्तीति पितर्य्यहम् अस्मीति च क्षात्वा विश्वसिष्यथ। ");
INSERT INTO sandev_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","तदा ते पुनरपि तं धर्त्तुम् अचेष्टन्त किन्तु स तेषां करेभ्यो निस्तीर्य्य ");
INSERT INTO sandev_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","पुन र्यर्द्दन् अद्यास्तटे यत्र पुर्व्वं योहन् अमज्जयत् तत्रागत्य न्यवसत्। ");
INSERT INTO sandev_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ततो बहवो लोकास्तत्समीपम् आगत्य व्याहरन् योहन् किमप्याश्चर्य्यं कर्म्म नाकरोत् किन्त्वस्मिन् मनुष्ये या यः कथा अकथयत् ताः सर्व्वाः सत्याः; ");
INSERT INTO sandev_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","तत्र च बहवो लोकास्तस्मिन् व्यश्वसन्। ");
INSERT INTO sandev_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","अनन्तरं मरियम् तस्या भगिनी मर्था च यस्मिन् वैथनीयाग्रामे वसतस्तस्मिन् ग्रामे इलियासर् नामा पीडित एक आसीत्। ");
INSERT INTO sandev_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","या मरियम् प्रभुं सुगन्धितेलैन मर्द्दयित्वा स्वकेशैस्तस्य चरणौ सममार्जत् तस्या भ्राता स इलियासर् रोगी। ");
INSERT INTO sandev_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","अपरञ्च हे प्रभो भवान् यस्मिन् प्रीयते स एव पीडितोस्तीति कथां कथयित्वा तस्य भगिन्यौ प्रेषितवत्यौ। ");
INSERT INTO sandev_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","तदा यीशुरिमां वार्त्तां श्रुत्वाकथयत पीडेयं मरणार्थं न किन्त्वीश्वरस्य महिमार्थम् ईश्वरपुत्रस्य महिमप्रकाशार्थञ्च जाता। ");
INSERT INTO sandev_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","यीशु र्यद्यपिमर्थायां तद्भगिन्याम् इलियासरि चाप्रीयत, ");
INSERT INTO sandev_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","तथापि इलियासरः पीडायाः कथं श्रुत्वा यत्र आसीत् तत्रैव दिनद्वयमतिष्ठत्। ");
INSERT INTO sandev_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ततः परम् स शिष्यानकथयद् वयं पुन र्यिहूदीयप्रदेशं यामः। ");
INSERT INTO sandev_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","ततस्ते प्रत्यवदन्, हे गुरो स्वल्पदिनानि गतानि यिहूदीयास्त्वां पाषाणै र्हन्तुम् उद्यतास्तथापि किं पुनस्तत्र यास्यसि? ");
INSERT INTO sandev_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","यीशुः प्रत्यवदत्, एकस्मिन् दिने किं द्वादशघटिका न भवन्ति? कोपि दिवा गच्छन् न स्खलति यतः स एतज्जगतो दीप्तिं प्राप्नोति। ");
INSERT INTO sandev_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","किन्तु रात्रौ गच्छन् स्खलति यतो हेतोस्तत्र दीप्ति र्नास्ति। ");
INSERT INTO sandev_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","इमां कथां कथयित्वा स तानवदद्, अस्माकं बन्धुः इलियासर् निद्रितोभूद् इदानीं तं निद्रातो जागरयितुं गच्छामि। ");
INSERT INTO sandev_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","यीशु र्मृतौ कथामिमां कथितवान् किन्तु विश्रामार्थं निद्रायां कथितवान् इति ज्ञात्वा शिष्या अकथयन्, ");
INSERT INTO sandev_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","हे गुरो स यदि निद्राति तर्हि भद्रमेव। ");
INSERT INTO sandev_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","तदा यीशुः स्पष्टं तान् व्याहरत्, इलियासर् अम्रियत; ");
INSERT INTO sandev_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","किन्तु यूयं यथा प्रतीथ तदर्थमहं तत्र न स्थितवान् इत्यस्माद् युष्मन्निमित्तम् आह्लादितोहं, तथापि तस्य समीपे याम। ");
INSERT INTO sandev_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","तदा थोमा यं दिदुमं वदन्ति स सङ्गिनः शिष्यान् अवदद् वयमपि गत्वा तेन सार्द्धं म्रियामहै। ");
INSERT INTO sandev_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","यीशुस्तत्रोपस्थाय इलियासरः श्मशाने स्थापनात् चत्वारि दिनानि गतानीति वार्त्तां श्रुतवान्। ");
INSERT INTO sandev_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","वैथनीया यिरूशालमः समीपस्था क्रोशैकमात्रान्तरिता; ");
INSERT INTO sandev_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","तस्माद् बहवो यिहूदीया मर्थां मरियमञ्च भ्यातृशोकापन्नां सान्त्वयितुं तयोः समीपम् आगच्छन्। ");
INSERT INTO sandev_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","मर्था यीशोरागमनवार्तां श्रुत्वैव तं साक्षाद् अकरोत् किन्तु मरियम् गेह उपविश्य स्थिता। ");
INSERT INTO sandev_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","तदा मर्था यीशुमवादत्, हे प्रभो यदि भवान् अत्रास्थास्यत् तर्हि मम भ्राता नामरिष्यत्। ");
INSERT INTO sandev_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","किन्त्विदानीमपि यद् ईश्वरे प्रार्थयिष्यते ईश्वरस्तद् दास्यतीति जानेऽहं। ");
INSERT INTO sandev_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","यीशुरवादीत् तव भ्राता समुत्थास्यति। ");
INSERT INTO sandev_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","मर्था व्याहरत् शेषदिवसे स उत्थानसमये प्रोत्थास्यतीति जानेऽहं। ");
INSERT INTO sandev_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","तदा यीशुः कथितवान् अहमेव उत्थापयिता जीवयिता च यः कश्चन मयि विश्वसिति स मृत्वापि जीविष्यति; ");
INSERT INTO sandev_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","यः कश्चन च जीवन् मयि विश्वसिति स कदापि न मरिष्यति, अस्यां कथायां किं विश्वसिषि? ");
INSERT INTO sandev_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","सावदत् प्रभो यस्यावतरणापेक्षास्ति भवान् सएवाभिषिक्त्त ईश्वरपुत्र इति विश्वसिमि। ");
INSERT INTO sandev_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","इति कथां कथयित्वा सा गत्वा स्वां भगिनीं मरियमं गुप्तमाहूय व्याहरत् गुरुरुपतिष्ठति त्वामाहूयति च। ");
INSERT INTO sandev_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","कथामिमां श्रुत्वा सा तूर्णम् उत्थाय तस्य समीपम् अगच्छत्। ");
INSERT INTO sandev_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","यीशु र्ग्राममध्यं न प्रविश्य यत्र मर्था तं साक्षाद् अकरोत् तत्र स्थितवान्। ");
INSERT INTO sandev_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","ये यिहूदीया मरियमा साकं गृहे तिष्ठन्तस्ताम् असान्त्वयन ते तां क्षिप्रम् उत्थाय गच्छन्तिं विलोक्य व्याहरन्, स श्मशाने रोदितुं याति, इत्युक्त्वा ते तस्याः पश्चाद् अगच्छन्। ");
INSERT INTO sandev_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","यत्र यीशुरतिष्ठत् तत्र मरियम् उपस्थाय तं दृष्ट्वा तस्य चरणयोः पतित्वा व्याहरत् हे प्रभो यदि भवान् अत्रास्थास्यत् तर्हि मम भ्राता नामरिष्यत्। ");
INSERT INTO sandev_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","यीशुस्तां तस्याः सङ्गिनो यिहूदीयांश्च रुदतो विलोक्य शोकार्त्तः सन् दीर्घं निश्वस्य कथितवान् तं कुत्रास्थापयत? ");
INSERT INTO sandev_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ते व्याहरन्, हे प्रभो भवान् आगत्य पश्यतु। ");
INSERT INTO sandev_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","यीशुना क्रन्दितं। ");
INSERT INTO sandev_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","अतएव यिहूदीया अवदन्, पश्यतायं तस्मिन् किदृग् अप्रियत। ");
INSERT INTO sandev_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","तेषां केचिद् अवदन् योन्धाय चक्षुषी दत्तवान् स किम् अस्य मृत्युं निवारयितुं नाशक्नोत्? ");
INSERT INTO sandev_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","ततो यीशुः पुनरन्तर्दीर्घं निश्वस्य श्मशानान्तिकम् अगच्छत्। तत् श्मशानम् एकं गह्वरं तन्मुखे पाषाण एक आसीत्। ");
INSERT INTO sandev_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","तदा यीशुरवदद् एनं पाषाणम् अपसारयत, ततः प्रमीतस्य भगिनी मर्थावदत् प्रभो, अधुना तत्र दुर्गन्धो जातः, यतोद्य चत्वारि दिनानि श्मशाने स तिष्ठति। ");
INSERT INTO sandev_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","तदा यीशुरवादीत्, यदि विश्वसिषि तर्हीश्वरस्य महिमप्रकाशं द्रक्ष्यसि कथामिमां किं तुभ्यं नाकथयं? ");
INSERT INTO sandev_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","तदा मृतस्य श्मशानात् पाषाणोऽपसारिते यीशुरूर्द्व्वं पश्यन् अकथयत्, हे पित र्मम नेवेसनम् अशृणोः कारणादस्मात् त्वां धन्यं वदामि। ");
INSERT INTO sandev_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","त्वं सततं शृणोषि तदप्यहं जानामि, किन्तु त्वं मां यत् प्रैरयस्तद् यथास्मिन् स्थाने स्थिता लोका विश्वसन्ति तदर्थम् इदं वाक्यं वदामि। ");
INSERT INTO sandev_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","इमां कथां कथयित्वा स प्रोच्चैराह्वयत्, हे इलियासर् बहिरागच्छ। ");
INSERT INTO sandev_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","ततः स प्रमीतः श्मशानवस्त्रै र्बद्धहस्तपादो गात्रमार्जनवाससा बद्धमुखश्च बहिरागच्छत्। यीशुरुदितवान् बन्धनानि मोचयित्वा त्यजतैनं। ");
INSERT INTO sandev_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","मरियमः समीपम् आगता ये यिहूदीयलोकास्तदा यीशोरेतत् कर्म्मापश्यन् तेषां बहवो व्यश्वसन्, ");
INSERT INTO sandev_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","किन्तु केचिदन्ये फिरूशिनां समीपं गत्वा यीशोरेतस्य कर्म्मणो वार्त्ताम् अवदन्। ");
INSERT INTO sandev_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","ततः परं प्रधानयाजकाः फिरूशिनाश्च सभां कृत्वा व्याहरन् वयं किं कुर्म्मः? एष मानवो बहून्याश्चर्य्यकर्म्माणि करोति। ");
INSERT INTO sandev_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","यदीदृशं कर्म्म कर्त्तुं न वारयामस्तर्हि सर्व्वे लोकास्तस्मिन् विश्वसिष्यन्ति रोमिलोकाश्चागत्यास्माकम् अनया राजधान्या सार्द्धं राज्यम् आछेत्स्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","तदा तेषां कियफानामा यस्तस्मिन् वत्सरे महायाजकपदे न्ययुज्यत स प्रत्यवदद् यूयं किमपि न जानीथ; ");
INSERT INTO sandev_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","समग्रदेशस्य विनाशतोपि सर्व्वलोकार्थम् एकस्य जनस्य मरणम् अस्माकं मङ्गलहेतुकम् एतस्य विवेचनामपि न कुरुथ। ");
INSERT INTO sandev_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","एतां कथां स निजबुद्ध्या व्याहरद् इति न, ");
INSERT INTO sandev_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","किन्तु यीशूस्तद्देशीयानां कारणात् प्राणान् त्यक्ष्यति, दिशि दिशि विकीर्णान् ईश्वरस्य सन्तानान् संगृह्यैकजातिं करिष्यति च, तस्मिन् वत्सरे कियफा महायाजकत्वपदे नियुक्तः सन् इदं भविष्यद्वाक्यं कथितवान्। ");
INSERT INTO sandev_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","तद्दिनमारभ्य ते कथं तं हन्तुं शक्नुवन्तीति मन्त्रणां कर्त्तुं प्रारेभिरे। ");
INSERT INTO sandev_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","अतएव यिहूदीयानां मध्ये यीशुः सप्रकाशं गमनागमने अकृत्वा तस्माद् गत्वा प्रान्तरस्य समीपस्थायिप्रदेशस्येफ्रायिम् नाम्नि नगरे शिष्यैः साकं कालं यापयितुं प्रारेभे। ");
INSERT INTO sandev_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","अनन्तरं यिहूदीयानां निस्तारोत्सवे निकटवर्त्तिनि सति तदुत्सवात् पूर्व्वं स्वान् शुचीन् कर्त्तुं बहवो जना ग्रामेभ्यो यिरूशालम् नगरम् आगच्छन्, ");
INSERT INTO sandev_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","यीशोरन्वेषणं कृत्वा मन्दिरे दण्डायमानाः सन्तः परस्परं व्याहरन्, युष्माकं कीदृशो बोधो जायते? स किम् उत्सवेऽस्मिन् अत्रागमिष्यति? ");
INSERT INTO sandev_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","स च कुत्रास्ति यद्येतत् कश्चिद् वेत्ति तर्हि दर्शयतु प्रधानयाजकाः फिरूशिनश्च तं धर्त्तुं पूर्व्वम् इमाम् आज्ञां प्राचारयन्। ");
INSERT INTO sandev_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","निस्तारोत्सवात् पूर्व्वं दिनषट्के स्थिते यीशु र्यं प्रमीतम् इलियासरं श्मशानाद् उदस्थापरत् तस्य निवासस्थानं बैथनियाग्रामम् आगच्छत्। ");
INSERT INTO sandev_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","तत्र तदर्थं रजन्यां भोज्ये कृते मर्था पर्य्यवेषयद् इलियासर् च तस्य सङ्गिभिः सार्द्धं भोजनासन उपाविशत्। ");
INSERT INTO sandev_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","तदा मरियम् अर्द्धसेटकं बहुमूल्यं जटामांसीयं तैलम् आनीय यीशोश्चरणयो र्मर्द्दयित्वा निजकेश र्मार्ष्टुम् आरभत; तदा तैलस्य परिमलेन गृहम् आमोदितम् अभवत्। ");
INSERT INTO sandev_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","यः शिमोनः पुत्र र्इष्करियोतीयो यिहूदानामा यीशुं परकरेषु समर्पयिष्यति स शिष्यस्तदा कथितवान्, ");
INSERT INTO sandev_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","एतत्तैलं त्रिभिः शतै र्मुद्रापदै र्विक्रीतं सद् दरिद्रेभ्यः कुतो नादीयत? ");
INSERT INTO sandev_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","स दरिद्रलोकार्थम् अचिन्तयद् इति न, किन्तु स चौर एवं तन्निकटे मुद्रासम्पुटकस्थित्या तन्मध्ये यदतिष्ठत् तदपाहरत् तस्मात् कारणाद् इमां कथामकथयत्। ");
INSERT INTO sandev_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","तदा यीशुरकथयद् एनां मा वारय सा मम श्मशानस्थापनदिनार्थं तदरक्षयत्। ");
INSERT INTO sandev_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","दरिद्रा युष्माकं सन्निधौ सर्व्वदा तिष्ठन्ति किन्त्वहं सर्व्वदा युष्माकं सन्निधौ न तिष्ठामि। ");
INSERT INTO sandev_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","ततः परं यीशुस्तत्रास्तीति वार्त्तां श्रुत्वा बहवो यिहूदीयास्तं श्मशानादुत्थापितम् इलियासरञ्च द्रष्टुं तत् स्थानम् आगच्छन। ");
INSERT INTO sandev_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","तदा प्रधानयाजकास्तम् इलियासरमपि संहर्त्तुम् अमन्त्रयन् ; ");
INSERT INTO sandev_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","यतस्तेन बहवो यिहूदीया गत्वा यीशौ व्यश्वसन्। ");
INSERT INTO sandev_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","अनन्तरं यीशु र्यिरूशालम् नगरम् आगच्छतीति वार्त्तां श्रुत्वा परेऽहनि उत्सवागता बहवो लोकाः ");
INSERT INTO sandev_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","खर्ज्जूरपत्राद्यानीय तं साक्षात् कर्त्तुं बहिरागत्य जय जयेति वाचं प्रोच्चै र्वक्तुम् आरभन्त, इस्रायेलो यो राजा परमेश्वरस्य नाम्नागच्छति स धन्यः। ");
INSERT INTO sandev_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","तदा \"हे सियोनः कन्ये मा भैषीः पश्यायं तव राजा गर्द्दभशावकम् आरुह्यागच्छति\" ");
INSERT INTO sandev_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","इति शास्त्रीयवचनानुसारेण यीशुरेकं युवगर्द्दभं प्राप्य तदुपर्य्यारोहत्। ");
INSERT INTO sandev_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","अस्याः घटनायास्तात्पर्य्यं शिष्याः प्रथमं नाबुध्यन्त, किन्तु यीशौ महिमानं प्राप्ते सति वाक्यमिदं तस्मिन अकथ्यत लोकाश्च तम्प्रतीत्थम् अकुर्व्वन् इति ते स्मृतवन्तः। ");
INSERT INTO sandev_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","स इलियासरं श्मशानाद् आगन्तुम् आह्वतवान् श्मशानाञ्च उदस्थापयद् ये ये लोकास्तत्कर्म्य साक्षाद् अपश्यन् ते प्रमाणं दातुम् आरभन्त। ");
INSERT INTO sandev_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","स एतादृशम् अद्भुतं कर्म्मकरोत् तस्य जनश्रुते र्लोकास्तं साक्षात् कर्त्तुम् आगच्छन्। ");
INSERT INTO sandev_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","ततः फिरूशिनः परस्परं वक्तुम् आरभन्त युष्माकं सर्व्वाश्चेष्टा वृथा जाताः, इति किं यूयं न बुध्यध्वे? पश्यत सर्व्वे लोकास्तस्य पश्चाद्वर्त्तिनोभवन्। ");
INSERT INTO sandev_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","भजनं कर्त्तुम् उत्सवागतानां लोकानां कतिपया जना अन्यदेशीया आसन् , ");
INSERT INTO sandev_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ते गालीलीयबैत्सैदानिवासिनः फिलिपस्य समीपम् आगत्य व्याहरन् हे महेच्छ वयं यीशुं द्रष्टुम् इच्छामः। ");
INSERT INTO sandev_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ततः फिलिपो गत्वा आन्द्रियम् अवदत् पश्चाद् आन्द्रियफिलिपौ यीशवे वार्त्ताम् अकथयतां। ");
INSERT INTO sandev_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","तदा यीशुः प्रत्युदितवान् मानवसुतस्य महिमप्राप्तिसमय उपस्थितः। ");
INSERT INTO sandev_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","अहं युष्मानतियथार्थं वदामि, धान्यबीजं मृत्तिकायां पतित्वा यदि न मृयते तर्ह्येकाकी तिष्ठति किन्तु यदि मृयते तर्हि बहुगुणं फलं फलति। ");
INSERT INTO sandev_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","यो जनेा निजप्राणान् प्रियान् जानाति स तान् हारयिष्यति किन्तु येा जन इहलोके निजप्राणान् अप्रियान् जानाति सेानन्तायुः प्राप्तुं तान् रक्षिष्यति। ");
INSERT INTO sandev_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","कश्चिद् यदि मम सेवको भवितुं वाञ्छति तर्हि स मम पश्चाद्गामी भवतु, तस्माद् अहं यत्र तिष्ठामि मम सेवकेापि तत्र स्थास्यति; यो जनो मां सेवते मम पितापि तं सम्मंस्यते। ");
INSERT INTO sandev_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","साम्प्रतं मम प्राणा व्याकुला भवन्ति, तस्माद् हे पितर एतस्मात् समयान् मां रक्ष, इत्यहं किं प्रार्थयिष्ये? किन्त्वहम् एतत्समयार्थम् अवतीर्णवान्। ");
INSERT INTO sandev_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","हे पित: स्वनाम्नो महिमानं प्रकाशय; तनैव स्वनाम्नो महिमानम् अहं प्राकाशयं पुनरपि प्रकाशयिष्यामि, एषा गगणीया वाणी तस्मिन् समयेऽजायत। ");
INSERT INTO sandev_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","तच्श्रुत्वा समीपस्थलोकानां केचिद् अवदन् मेघोऽगर्जीत्, केचिद् अवदन् स्वर्गीयदूतोऽनेन सह कथामचकथत्। ");
INSERT INTO sandev_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","तदा यीशुः प्रत्यवादीत्, मदर्थं शब्दोयं नाभूत् युष्मदर्थमेवाभूत्। ");
INSERT INTO sandev_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","अधुना जगतोस्य विचार: सम्पत्स्यते, अधुनास्य जगत: पती राज्यात् च्योष्यति। ");
INSERT INTO sandev_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","यद्यई पृथिव्या ऊर्द्व्वे प्रोत्थापितोस्मि तर्हि सर्व्वान् मानवान् स्वसमीपम् आकर्षिष्यामि। ");
INSERT INTO sandev_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","कथं तस्य मृति र्भविष्यति, एतद् बोधयितुं स इमां कथाम् अकथयत्। ");
INSERT INTO sandev_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","तदा लोका अकथयन् सोभिषिक्तः सर्व्वदा तिष्ठतीति व्यवस्थाग्रन्थे श्रुतम् अस्माभिः, तर्हि मनुष्यपुत्रः प्रोत्थापितो भविष्यतीति वाक्यं कथं वदसि? मनुष्यपुत्रोयं कः? ");
INSERT INTO sandev_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","तदा यीशुरकथायद् युष्माभिः सार्द्धम् अल्पदिनानि ज्योतिरास्ते, यथा युष्मान् अन्धकारो नाच्छादयति तदर्थं यावत्कालं युष्माभिः सार्द्धं ज्योतिस्तिष्ठति तावत्कालं गच्छत; यो जनोऽन्धकारे गच्छति स कुत्र यातीति न जानाति। ");
INSERT INTO sandev_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","अतएव यावत्कालं युष्माकं निकटे ज्योतिरास्ते तावत्कालं ज्योतीरूपसन्ताना भवितुं ज्योतिषि विश्वसित; इमां कथां कथयित्वा यीशुः प्रस्थाय तेभ्यः स्वं गुप्तवान्। ");
INSERT INTO sandev_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","यद्यपि यीशुस्तेषां समक्षम् एतावदाश्चर्य्यकर्म्माणि कृतवान् तथापि ते तस्मिन् न व्यश्वसन्। ");
INSERT INTO sandev_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","अतएव कः प्रत्येति सुसंवादं परेशास्मत् प्रचारितं? प्रकाशते परेशस्य हस्तः कस्य च सन्निधौ? यिशयियभविष्यद्वादिना यदेतद् वाक्यमुक्तं तत् सफलम् अभवत्। ");
INSERT INTO sandev_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","ते प्रत्येतुं नाशन्कुवन् तस्मिन् यिशयियभविष्यद्वादि पुनरवादीद्, ");
INSERT INTO sandev_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","यदा, \"ते नयनै र्न पश्यन्ति बुद्धिभिश्च न बुध्यन्ते तै र्मनःसु परिवर्त्तितेषु च तानहं यथा स्वस्थान् न करोमि तथा स तेषां लोचनान्यन्धानि कृत्वा तेषामन्तःकरणानि गाढानि करिष्यति।\" ");
INSERT INTO sandev_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","यिशयियो यदा यीशो र्महिमानं विलोक्य तस्मिन् कथामकथयत् तदा भविष्यद्वाक्यम् ईदृशं प्रकाशयत्। ");
INSERT INTO sandev_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","तथाप्यधिपतिनां बहवस्तस्मिन् प्रत्यायन्। किन्तु फिरूशिनस्तान् भजनगृहाद् दूरीकुर्व्वन्तीति भयात् ते तं न स्वीकृतवन्तः। ");
INSERT INTO sandev_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","यत ईश्वरस्य प्रशंसातो मानवानां प्रशंसायां तेऽप्रियन्त। ");
INSERT INTO sandev_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","तदा यीशुरुच्चैःकारम् अकथयद् यो जनो मयि विश्वसिति स केवले मयि विश्वसितीति न, स मत्प्रेरकेऽपि विश्वसिति। ");
INSERT INTO sandev_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","यो जनो मां पश्यति स मत्प्रेरकमपि पश्यति। ");
INSERT INTO sandev_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","यो जनो मां प्रत्येति स यथान्धकारे न तिष्ठति तदर्थम् अहं ज्योतिःस्वरूपो भूत्वा जगत्यस्मिन् अवतीर्णवान्। ");
INSERT INTO sandev_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","मम कथां श्रुत्वा यदि कश्चिन् न विश्वसिति तर्हि तमहं दोषिणं न करोमि, यतो हेतो र्जगतो जनानां दोषान् निश्चितान् कर्त्तुं नागत्य तान् परिचातुम् आगतोस्मि। ");
INSERT INTO sandev_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","यः कश्चिन् मां न श्रद्धाय मम कथं न गृह्लाति, अन्यस्तं दोषिणं करिष्यति वस्तुतस्तु यां कथामहम् अचकथं सा कथा चरमेऽन्हि तं दोषिणं करिष्यति। ");
INSERT INTO sandev_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","यतो हेतोरहं स्वतः किमपि न कथयामि, किं किं मया कथयितव्यं किं समुपदेष्टव्यञ्च इति मत्प्रेरयिता पिता मामाज्ञापयत्। ");
INSERT INTO sandev_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","तस्य साज्ञा अनन्तायुरित्यहं जानामि, अतएवाहं यत् कथयामि तत् पिता यथाज्ञापयत् तथैव कथयाम्यहम्। ");
INSERT INTO sandev_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","निस्तारोत्सवस्य किञ्चित्कालात् पूर्व्वं पृथिव्याः पितुः समीपगमनस्य समयः सन्निकर्षोभूद् इति ज्ञात्वा यीशुराप्रथमाद् येषु जगत्प्रवासिष्वात्मीयलोकेष प्रेम करोति स्म तेषु शेषं यावत् प्रेम कृतवान्। ");
INSERT INTO sandev_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","पिता तस्य हस्ते सर्व्वं समर्पितवान् स्वयम् ईश्वरस्य समीपाद् आगच्छद् ईश्वरस्य समीपं यास्यति च, सर्व्वाण्येतानि ज्ञात्वा रजन्यां भोजने सम्पूर्णे सति, ");
INSERT INTO sandev_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","यदा शैतान् तं परहस्तेषु समर्पयितुं शिमोनः पुत्रस्य ईष्कारियोतियस्य यिहूदा अन्तःकरणे कुप्रवृत्तिं समार्पयत्, ");
INSERT INTO sandev_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","तदा यीशु र्भोजनासनाद् उत्थाय गात्रवस्त्रं मोचयित्वा गात्रमार्जनवस्त्रं गृहीत्वा तेन स्वकटिम् अबध्नात्, ");
INSERT INTO sandev_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","पश्चाद् एकपात्रे जलम् अभिषिच्य शिष्याणां पादान् प्रक्षाल्य तेन कटिबद्धगात्रमार्जनवाससा मार्ष्टुं प्रारभत। ");
INSERT INTO sandev_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ततः शिमोन्पितरस्य समीपमागते स उक्तवान् हे प्रभो भवान् किं मम पादौ प्रक्षालयिष्यति? ");
INSERT INTO sandev_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","यीशुरुदितवान् अहं यत् करोमि तत् सम्प्रति न जानासि किन्तु पश्चाज् ज्ञास्यसि। ");
INSERT INTO sandev_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","ततः पितरः कथितवान् भवान् कदापि मम पादौ न प्रक्षालयिष्यति। यीशुरकथयद् यदि त्वां न प्रक्षालये तर्हि मयि तव कोप्यंशो नास्ति। ");
INSERT INTO sandev_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","तदा शिमोन्पितरः कथितवान् हे प्रभो तर्हि केवलपादौ न, मम हस्तौ शिरश्च प्रक्षालयतु। ");
INSERT INTO sandev_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","ततो यीशुरवदद् यो जनो धौतस्तस्य सर्व्वाङ्गपरिष्कृतत्वात् पादौ विनान्याङ्गस्य प्रक्षालनापेक्षा नास्ति। यूयं परिष्कृता इति सत्यं किन्तु न सर्व्वे, ");
INSERT INTO sandev_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","यतो यो जनस्तं परकरेषु समर्पयिष्यति तं स ज्ञातवान; अतएव यूयं सर्व्वे न परिष्कृता इमां कथां कथितवान्। ");
INSERT INTO sandev_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","इत्थं यीशुस्तेषां पादान् प्रक्षाल्य वस्त्रं परिधायासने समुपविश्य कथितवान् अहं युष्मान् प्रति किं कर्म्माकार्षं जानीथ? ");
INSERT INTO sandev_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","यूयं मां गुरुं प्रभुञ्च वदथ तत् सत्यमेव वदथ यतोहं सएव भवामि। ");
INSERT INTO sandev_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","यद्यहं प्रभु र्गुरुश्च सन् युष्माकं पादान् प्रक्षालितवान् तर्हि युष्माकमपि परस्परं पादप्रक्षालनम् उचितम्। ");
INSERT INTO sandev_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","अहं युष्मान् प्रति यथा व्यवाहरं युष्मान् तथा व्यवहर्त्तुम् एकं पन्थानं दर्शितवान्। ");
INSERT INTO sandev_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","अहं युष्मानतियथार्थं वदामि, प्रभो र्दासो न महान् प्रेरकाच्च प्रेरितो न महान्। ");
INSERT INTO sandev_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","इमां कथां विदित्वा यदि तदनुसारतः कर्म्माणि कुरुथ तर्हि यूयं धन्या भविष्यथ। ");
INSERT INTO sandev_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","सर्व्वेषु युष्मासु कथामिमां कथयामि इति न, ये मम मनोनीतास्तानहं जानामि, किन्तु मम भक्ष्याणि यो भुङ्क्ते मत्प्राणप्रातिकूल्यतः। उत्थापयति पादस्य मूलं स एष मानवः।यदेतद् धर्म्मपुस्तकस्य वचनं तदनुसारेणावश्यं घटिष्यते। ");
INSERT INTO sandev_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","अहं स जन इत्यत्र यथा युष्माकं विश्वासो जायते तदर्थं एतादृशघटनात् पूर्व्वम् अहमिदानीं युष्मभ्यमकथयम्। ");
INSERT INTO sandev_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","अहं युष्मानतीव यथार्थं वदामि, मया प्रेरितं जनं यो गृह्लाति स मामेव गृह्लाति यश्च मां गृह्लाति स मत्प्रेरकं गृह्लाति। ");
INSERT INTO sandev_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","एतां कथां कथयित्वा यीशु र्दुःखी सन् प्रमाणं दत्त्वा कथितवान् अहं युष्मानतियथार्थं वदामि युष्माकम् एको जनो मां परकरेषु समर्पयिष्यति। ");
INSERT INTO sandev_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","ततः स कमुद्दिश्य कथामेतां कथितवान् इत्यत्र सन्दिग्धाः शिष्याः परस्परं मुखमालोकयितुं प्रारभन्त। ");
INSERT INTO sandev_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","तस्मिन् समये यीशु र्यस्मिन् अप्रीयत स शिष्यस्तस्य वक्षःस्थलम् अवालम्बत। ");
INSERT INTO sandev_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","शिमोन्पितरस्तं सङ्केतेनावदत्, अयं कमुद्दिश्य कथामेताम् कथयतीति पृच्छ। ");
INSERT INTO sandev_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","तदा स यीशो र्वक्षःस्थलम् अवलम्ब्य पृष्ठवान्, हे प्रभो स जनः कः? ");
INSERT INTO sandev_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","ततो यीशुः प्रत्यवदद् एकखण्डं पूपं मज्जयित्वा यस्मै दास्यामि सएव सः; पश्चात् पूपखण्डमेकं मज्जयित्वा शिमोनः पुत्राय ईष्करियोतीयाय यिहूदै दत्तवान्। ");
INSERT INTO sandev_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","तस्मिन् दत्ते सति शैतान् तमाश्रयत्; तदा यीशुस्तम् अवदत् त्वं यत् करिष्यसि तत् क्षिप्रं कुरु। ");
INSERT INTO sandev_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","किन्तु स येनाशयेन तां कथामकथायत् तम् उपविष्टलोकानां कोपि नाबुध्यत; ");
INSERT INTO sandev_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","किन्तु यिहूदाः समीपे मुद्रासम्पुटकस्थितेः केचिद् इत्थम् अबुध्यन्त पार्व्वणासादनार्थं किमपि द्रव्यं क्रेतुं वा दरिद्रेभ्यः किञ्चिद् वितरितुं कथितवान्। ");
INSERT INTO sandev_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","तदा पूपखण्डग्रहणात् परं स तूर्णं बहिरगच्छत्; रात्रिश्च समुपस्यिता। ");
INSERT INTO sandev_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","यिहूदे बहिर्गते यीशुरकथयद् इदानीं मानवसुतस्य महिमा प्रकाशते तेनेश्वरस्यापि महिमा प्रकाशते। ");
INSERT INTO sandev_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","यदि तेनेश्वरस्य महिमा प्रकाशते तर्हीश्वरोपि स्वेन तस्य महिमानं प्रकाशयिष्यति तूर्णमेव प्रकाशयिष्यति। ");
INSERT INTO sandev_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","हे वत्सा अहं युष्माभिः सार्द्धं किञ्चित्कालमात्रम् आसे, ततः परं मां मृगयिष्यध्वे किन्त्वहं यत्स्थानं यामि तत्स्थानं यूयं गन्तुं न शक्ष्यथ, यामिमां कथां यिहूदीयेभ्यः कथितवान् तथाधुना युष्मभ्यमपि कथयामि। ");
INSERT INTO sandev_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","यूयं परस्परं प्रीयध्वम् अहं युष्मासु यथा प्रीये यूयमपि परस्परम् तथैव प्रीयध्वं, युष्मान् इमां नवीनाम् आज्ञाम् आदिशामि। ");
INSERT INTO sandev_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","तेनैव यदि परस्परं प्रीयध्वे तर्हि लक्षणेनानेन यूयं मम शिष्या इति सर्व्वे ज्ञातुं शक्ष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","शिमोनपितरः पृष्ठवान् हे प्रभो भवान् कुत्र यास्यति? ततो यीशुः प्रत्यवदत्, अहं यत्स्थानं यामि तत्स्थानं साम्प्रतं मम पश्चाद् गन्तुं न शक्नोषि किन्तु पश्चाद् गमिष्यसि। ");
INSERT INTO sandev_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","तदा पितरः प्रत्युदितवान्, हे प्रभो साम्प्रतं कुतो हेतोस्तव पश्चाद् गन्तुं न शक्नोमि? त्वदर्थं प्राणान् दातुं शक्नोमि। ");
INSERT INTO sandev_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ततो यीशुः प्रत्युक्तवान् मन्निमित्तं किं प्राणान् दातुं शक्नोषि? त्वामहं यथार्थं वदामि, कुक्कुटरवणात् पूर्व्वं त्वं त्रि र्माम् अपह्नोष्यसे। ");
INSERT INTO sandev_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","मनोदुःखिनो मा भूत; ईश्वरे विश्वसित मयि च विश्वसित। ");
INSERT INTO sandev_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","मम पितु गृहे बहूनि वासस्थानि सन्ति नो चेत् पूर्व्वं युष्मान् अज्ञापयिष्यं युष्मदर्थं स्थानं सज्जयितुं गच्छामि। ");
INSERT INTO sandev_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","यदि गत्वाहं युष्मन्निमित्तं स्थानं सज्जयामि तर्हि पनरागत्य युष्मान् स्वसमीपं नेष्यामि, ततो यत्राहं तिष्ठामि तत्र यूयमपि स्थास्यथ। ");
INSERT INTO sandev_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","अहं यत्स्थानं ब्रजामि तत्स्थानं यूयं जानीथ तस्य पन्थानमपि जानीथ। ");
INSERT INTO sandev_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","तदा थोमा अवदत्, हे प्रभो भवान् कुत्र याति तद्वयं न जानीमः, तर्हि कथं पन्थानं ज्ञातुं शक्नुमः? ");
INSERT INTO sandev_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","यीशुरकथयद् अहमेव सत्यजीवनरूपपथो मया न गन्ता कोपि पितुः समीपं गन्तुं न शक्नोति। ");
INSERT INTO sandev_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","यदि माम् अज्ञास्यत तर्हि मम पितरमप्यज्ञास्यत किन्त्वधुनातस्तं जानीथ पश्यथ च। ");
INSERT INTO sandev_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","तदा फिलिपः कथितवान्, हे प्रभो पितरं दर्शय तस्मादस्माकं यथेष्टं भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","ततो यीशुः प्रत्यावादीत्, हे फिलिप युष्माभिः सार्द्धम् एतावद्दिनानि स्थितमपि मां किं न प्रत्यभिजानासि? यो जनो माम् अपश्यत् स पितरमप्यपश्यत् तर्हि पितरम् अस्मान् दर्शयेति कथां कथं कथयसि? ");
INSERT INTO sandev_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","अहं पितरि तिष्ठामि पिता मयि तिष्ठतीति किं त्वं न प्रत्यषि? अहं यद्वाक्यं वदामि तत् स्वतो न वदामि किन्तु यः पिता मयि विराजते स एव सर्व्वकर्म्माणि कराति। ");
INSERT INTO sandev_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","अतएव पितर्य्यहं तिष्ठामि पिता च मयि तिष्ठति ममास्यां कथायां प्रत्ययं कुरुत, नो चेत् कर्म्महेतोः प्रत्ययं कुरुत। ");
INSERT INTO sandev_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","अहं युष्मानतियथार्थं वदामि, यो जनो मयि विश्वसिति सोहमिव कर्म्माणि करिष्यति वरं ततोपि महाकर्म्माणि करिष्यति यतो हेतोरहं पितुः समीपं गच्छामि। ");
INSERT INTO sandev_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","यथा पुत्रेण पितु र्महिमा प्रकाशते तदर्थं मम नाम प्रोच्य यत् प्रार्थयिष्यध्वे तत् सफलं करिष्यामि। ");
INSERT INTO sandev_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","यदि मम नाम्ना यत् किञ्चिद् याचध्वे तर्हि तदहं साधयिष्यामि। ");
INSERT INTO sandev_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","यदि मयि प्रीयध्वे तर्हि ममाज्ञाः समाचरत। ");
INSERT INTO sandev_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ततो मया पितुः समीपे प्रार्थिते पिता निरन्तरं युष्माभिः सार्द्धं स्थातुम् इतरमेकं सहायम् अर्थात् सत्यमयम् आत्मानं युष्माकं निकटं प्रेषयिष्यति। ");
INSERT INTO sandev_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","एतज्जगतो लोकास्तं ग्रहीतुं न शक्नुवन्ति यतस्ते तं नापश्यन् नाजनंश्च किन्तु यूयं जानीथ यतो हेतोः स युष्माकमन्त र्निवसति युष्माकं मध्ये स्थास्यति च। ");
INSERT INTO sandev_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","अहं युष्मान् अनाथान् कृत्वा न यास्यामि पुनरपि युष्माकं समीपम् आगमिष्यामि। ");
INSERT INTO sandev_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","कियत्कालरत् परम् अस्य जगतो लोका मां पुन र्न द्रक्ष्यन्ति किन्तु यूयं द्रक्ष्यथ;अहं जीविष्यामि तस्मात् कारणाद् यूयमपि जीविष्यथ। ");
INSERT INTO sandev_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","पितर्य्यहमस्मि मयि च यूयं स्थ, तथाहं युष्मास्वस्मि तदपि तदा ज्ञास्यथ। ");
INSERT INTO sandev_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","यो जनो ममाज्ञा गृहीत्वा ता आचरति सएव मयि प्रीयते; यो जनश्च मयि प्रीयते सएव मम पितुः प्रियपात्रं भविष्यति, तथाहमपि तस्मिन् प्रीत्वा तस्मै स्वं प्रकाशयिष्यामि। ");
INSERT INTO sandev_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","तदा ईष्करियोतीयाद् अन्यो यिहूदास्तमवदत्, हे प्रभो भवान् जगतो लोकानां सन्निधौ प्रकाशितो न भूत्वास्माकं सन्निधौ कुतः प्रकाशितो भविष्यति? ");
INSERT INTO sandev_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ततो यीशुः प्रत्युदितवान्, यो जनो मयि प्रीयते स ममाज्ञा अपि गृह्लाति, तेन मम पितापि तस्मिन् प्रेष्यते, आवाञ्च तन्निकटमागत्य तेन सह निवत्स्यावः। ");
INSERT INTO sandev_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","यो जनो मयि न प्रीयते स मम कथा अपि न गृह्लाति पुनश्च यामिमां कथां यूयं शृणुथ सा कथा केवलस्य मम न किन्तु मम प्रेरको यः पिता तस्यापि कथा। ");
INSERT INTO sandev_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","इदानीं युष्माकं निकटे विद्यमानोहम् एताः सकलाः कथाः कथयामि। ");
INSERT INTO sandev_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","किन्त्वितः परं पित्रा यः सहायोऽर्थात् पवित्र आत्मा मम नाम्नि प्रेरयिष्यति स सर्व्वं शिक्षयित्वा मयोक्ताः समस्ताः कथा युष्मान् स्मारयिष्यति। ");
INSERT INTO sandev_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","अहं युष्माकं निकटे शान्तिं स्थापयित्वा यामि, निजां शान्तिं युष्मभ्यं ददामि, जगतो लोका यथा ददाति तथाहं न ददामि; युष्माकम् अन्तःकरणानि दुःखितानि भीतानि च न भवन्तु। ");
INSERT INTO sandev_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","अहं गत्वा पुनरपि युष्माकं समीपम् आगमिष्यामि मयोक्तं वाक्यमिदं यूयम् अश्रौष्ट; यदि मय्यप्रेष्यध्वं तर्ह्यहं पितुः समीपं गच्छामि ममास्यां कथायां यूयम् अह्लादिष्यध्वं यतो मम पिता मत्तोपि महान्। ");
INSERT INTO sandev_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","तस्या घटनायाः समये यथा युष्माकं श्रद्धा जायते तदर्थम् अहं तस्या घटनायाः पूर्व्वम् इदानीं युष्मान् एतां वार्त्तां वदामि। ");
INSERT INTO sandev_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","इतः परं युष्माभिः सह मम बहव आलापा न भविष्यन्ति यतः कारणाद् एतस्य जगतः पतिरागच्छति किन्तु मया सह तस्य कोपि सम्बन्धो नास्ति। ");
INSERT INTO sandev_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","अहं पितरि प्रेम करोमि तथा पितु र्विधिवत् कर्म्माणि करोमीति येन जगतो लोका जानन्ति तदर्थम् उत्तिष्ठत वयं स्थानादस्माद् गच्छाम। ");
INSERT INTO sandev_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","अहं सत्यद्राक्षालतास्वरूपो मम पिता तूद्यानपरिचारकस्वरूपञ्च। ");
INSERT INTO sandev_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","मम यासु शाखासु फलानि न भवन्ति ताः स छिनत्ति तथा फलवत्यः शाखा यथाधिकफलानि फलन्ति तदर्थं ताः परिष्करोति। ");
INSERT INTO sandev_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","इदानीं मयोक्तोपदेशेन यूयं परिष्कृताः। ");
INSERT INTO sandev_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","अतः कारणात् मयि तिष्ठत तेनाहमपि युष्मासु तिष्ठामि, यतो हेतो र्द्राक्षालतायाम् असंलग्ना शाखा यथा फलवती भवितुं न शक्नोति तथा यूयमपि मय्यतिष्ठन्तः फलवन्तो भवितुं न शक्नुथ। ");
INSERT INTO sandev_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","अहं द्राक्षालतास्वरूपो यूयञ्च शाखास्वरूपोः; यो जनो मयि तिष्ठति यत्र चाहं तिष्ठामि, स प्रचूरफलैः फलवान् भवति, किन्तु मां विना यूयं किमपि कर्त्तुं न शक्नुथ। ");
INSERT INTO sandev_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","यः कश्चिन् मयि न तिष्ठति स शुष्कशाखेव बहि र्निक्षिप्यते लोकाश्च ता आहृत्य वह्नौ निक्षिप्य दाहयन्ति। ");
INSERT INTO sandev_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","यदि यूयं मयि तिष्ठथ मम कथा च युष्मासु तिष्ठति तर्हि यद् वाञ्छित्वा याचिष्यध्वे युष्माकं तदेव सफलं भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","यदि यूयं प्रचूरफलवन्तो भवथ तर्हि तद्वारा मम पितु र्महिमा प्रकाशिष्यते तथा यूयं मम शिष्या इति परिक्षायिष्यध्वे। ");
INSERT INTO sandev_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","पिता यथा मयि प्रीतवान् अहमपि युष्मासु तथा प्रीतवान् अतो हेतो र्यूयं निरन्तरं मम प्रेमपात्राणि भूत्वा तिष्ठत। ");
INSERT INTO sandev_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","अहं यथा पितुराज्ञा गृहीत्वा तस्य प्रेमभाजनं तिष्ठामि तथैव यूयमपि यदि ममाज्ञा गुह्लीथ तर्हि मम प्रेमभाजनानि स्थास्यथ। ");
INSERT INTO sandev_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","युष्मन्निमित्तं मम य आह्लादः स यथा चिरं तिष्ठति युष्माकम् आनन्दश्च यथा पूर्य्यते तदर्थं युष्मभ्यम् एताः कथा अत्रकथम्। ");
INSERT INTO sandev_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","अहं युष्मासु यथा प्रीये यूयमपि परस्परं तथा प्रीयध्वम् एषा ममाज्ञा। ");
INSERT INTO sandev_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","मित्राणां कारणात् स्वप्राणदानपर्य्यन्तं यत् प्रेम तस्मान् महाप्रेम कस्यापि नास्ति। ");
INSERT INTO sandev_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","अहं यद्यद् आदिशामि तत्तदेव यदि यूयम् आचरत तर्हि यूयमेव मम मित्राणि। ");
INSERT INTO sandev_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","अद्यारभ्य युष्मान् दासान् न वदिष्यामि यत् प्रभु र्यत् करोति दासस्तद् न जानाति; किन्तु पितुः समीपे यद्यद् अशृणवं तत् सर्व्वं यूष्मान् अज्ञापयम् तत्कारणाद् युष्मान् मित्राणि प्रोक्तवान्। ");
INSERT INTO sandev_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","यूयं मां रोचितवन्त इति न, किन्त्वहमेव युष्मान् रोचितवान् यूयं गत्वा यथा फलान्युत्पादयथ तानि फलानि चाक्षयाणि भवन्ति, तदर्थं युष्मान् न्यजुनजं तस्मान् मम नाम प्रोच्य पितरं यत् किञ्चिद् याचिष्यध्वे तदेव स युष्मभ्यं दास्यति। ");
INSERT INTO sandev_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","यूयं परस्परं प्रीयध्वम् अहम् इत्याज्ञापयामि। ");
INSERT INTO sandev_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","जगतो लोकै र्युष्मासु ऋतीयितेषु ते पूर्व्वं मामेवार्त्तीयन्त इति यूयं जानीथ। ");
INSERT INTO sandev_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","यदि यूयं जगतो लोका अभविष्यत तर्हि जगतो लोका युष्मान् आत्मीयान् बुद्ध्वाप्रेष्यन्त; किन्तु यूयं जगतो लोका न भवथ, अहं युष्मान् अस्माज्जगतोऽरोचयम् एतस्मात् कारणाज्जगतो लोका युष्मान् ऋतीयन्ते। ");
INSERT INTO sandev_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","दासः प्रभो र्महान् न भवति ममैतत् पूर्व्वीयं वाक्यं स्मरत; ते यदि मामेवाताडयन् तर्हि युष्मानपि ताडयिष्यन्ति, यदि मम वाक्यं गृह्लन्ति तर्हि युष्माकमपि वाक्यं ग्रहीष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","किन्तु ते मम नामकारणाद् युष्मान् प्रति तादृशं व्यवहरिष्यन्ति यतो यो मां प्रेरितवान् तं ते न जानन्ति। ");
INSERT INTO sandev_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","तेषां सन्निधिम् आगत्य यद्यहं नाकथयिष्यं तर्हि तेषां पापं नाभविष्यत् किन्त्वधुना तेषां पापमाच्छादयितुम् उपायो नास्ति। ");
INSERT INTO sandev_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","यो जनो माम् ऋतीयते स मम पितरमपि ऋतीयते। ");
INSERT INTO sandev_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","यादृशानि कर्म्माणि केनापि कदापि नाक्रियन्त तादृशानि कर्म्माणि यदि तेषां साक्षाद् अहं नाकरिष्यं तर्हि तेषां पापं नाभविष्यत् किन्त्वधुना ते दृष्ट्वापि मां मम पितरञ्चार्त्तीयन्त। ");
INSERT INTO sandev_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","तस्मात् तेऽकारणं माम् ऋतीयन्ते यदेतद् वचनं तेषां शास्त्रे लिखितमास्ते तत् सफलम् अभवत्। ");
INSERT INTO sandev_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","किन्तु पितु र्निर्गतं यं सहायमर्थात् सत्यमयम् आत्मानं पितुः समीपाद् युष्माकं समीपे प्रेषयिष्यामि स आगत्य मयि प्रमाणं दास्यति। ");
INSERT INTO sandev_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","यूयं प्रथममारभ्य मया सार्द्धं तिष्ठथ तस्माद्धेतो र्यूयमपि प्रमाणं दास्यथ। ");
INSERT INTO sandev_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","युष्माकं यथा वाधा न जायते तदर्थं युष्मान् एतानि सर्व्ववाक्यानि व्याहरं। ");
INSERT INTO sandev_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","लोका युष्मान् भजनगृहेभ्यो दूरीकरिष्यन्ति तथा यस्मिन् समये युष्मान् हत्वा ईश्वरस्य तुष्टि जनकं कर्म्माकुर्म्म इति मंस्यन्ते स समय आगच्छन्ति। ");
INSERT INTO sandev_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","ते पितरं माञ्च न जानन्ति, तस्माद् युष्मान् प्रतीदृशम् आचरिष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","अतो हेताः समये समुपस्थिते यथा मम कथा युष्माकं मनःसुः समुपतिष्ठति तदर्थं युष्माभ्यम् एतां कथां कथयामि युष्माभिः सार्द्धम् अहं तिष्ठन् प्रथमं तां युष्मभ्यं नाकथयं। ");
INSERT INTO sandev_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","साम्प्रतं स्वस्य प्रेरयितुः समीपं गच्छामि तथापि त्वं क्क गच्छसि कथामेतां युष्माकं कोपि मां न पृच्छति। ");
INSERT INTO sandev_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","किन्तु मयोक्ताभिराभिः कथाभि र्यूष्माकम् अन्तःकरणानि दुःखेन पूर्णान्यभवन्। ");
INSERT INTO sandev_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","तथाप्यहं यथार्थं कथयामि मम गमनं युष्माकं हितार्थमेव, यतो हेतो र्गमने न कृते सहायो युष्माकं समीपं नागमिष्यति किन्तु यदि गच्छामि तर्हि युष्माकं समीपे तं प्रेषयिष्यामि। ");
INSERT INTO sandev_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","ततः स आगत्य पापपुण्यदण्डेषु जगतो लोकानां प्रबोधं जनयिष्यति। ");
INSERT INTO sandev_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ते मयि न विश्वसन्ति तस्माद्धेतोः पापप्रबोधं जनयिष्यति। ");
INSERT INTO sandev_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","युष्माकम् अदृश्यः सन्नहं पितुः समीपं गच्छामि तस्माद् पुण्ये प्रबोधं जनयिष्यति। ");
INSERT INTO sandev_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","एतज्जगतोऽधिपति र्दण्डाज्ञां प्राप्नोति तस्माद् दण्डे प्रबोधं जनयिष्यति। ");
INSERT INTO sandev_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","युष्मभ्यं कथयितुं ममानेकाः कथा आसते, ताः कथा इदानीं यूयं सोढुं न शक्नुथ; ");
INSERT INTO sandev_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","किन्तु सत्यमय आत्मा यदा समागमिष्यति तदा सर्व्वं सत्यं युष्मान् नेष्यति, स स्वतः किमपि न वदिष्यति किन्तु यच्छ्रोष्यति तदेव कथयित्वा भाविकार्य्यं युष्मान् ज्ञापयिष्यति। ");
INSERT INTO sandev_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","मम महिमानं प्रकाशयिष्यति यतो मदीयां कथां गृहीत्वा युष्मान् बोधयिष्यति। ");
INSERT INTO sandev_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","पितु र्यद्यद् आस्ते तत् सर्व्वं मम तस्माद् कारणाद् अवादिषं स मदीयां कथां गृहीत्वा युष्मान् बोधयिष्यति। ");
INSERT INTO sandev_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","कियत्कालात् परं यूयं मां द्रष्टुं न लप्स्यध्वे किन्तु कियत्कालात् परं पुन र्द्रष्टुं लप्स्यध्वे यतोहं पितुः समीपं गच्छामि। ");
INSERT INTO sandev_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ततः शिष्याणां कियन्तो जनाः परस्परं वदितुम् आरभन्त, कियत्कालात् परं मां द्रष्टुं न लप्स्यध्वे किन्तु कियत्कालात् परं पुन र्द्रष्टुं लप्स्यध्वे यतोहं पितुः समीपं गच्छामि, इति यद् वाक्यम् अयं वदति तत् किं? ");
INSERT INTO sandev_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","ततः कियत्कालात् परम् इति तस्य वाक्यं किं? तस्य वाक्यस्याभिप्रायं वयं बोद्धुं न शक्नुमस्तैरिति ");
INSERT INTO sandev_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","निगदिते यीशुस्तेषां प्रश्नेच्छां ज्ञात्वा तेभ्योऽकथयत् कियत्कालात् परं मां द्रष्टुं न लप्स्यध्वे, किन्तु कियत्कालात् परं पून र्द्रष्टुं लप्स्यध्वे, यामिमां कथामकथयं तस्या अभिप्रायं किं यूयं परस्परं मृगयध्वे? ");
INSERT INTO sandev_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","युष्मानहम् अतियथार्थं वदामि यूयं क्रन्दिष्यथ विलपिष्यथ च, किन्तु जगतो लोका आनन्दिष्यन्ति; यूयं शोकाकुला भविष्यथ किन्तु शोकात् परं आनन्दयुक्ता भविष्यथ। ");
INSERT INTO sandev_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","प्रसवकाल उपस्थिते नारी यथा प्रसववेदनया व्याकुला भवति किन्तु पुत्रे भूमिष्ठे सति मनुष्यैको जन्मना नरलोके प्रविष्ट इत्यानन्दात् तस्यास्तत्सर्व्वं दुःखं मनसि न तिष्ठति, ");
INSERT INTO sandev_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","तथा यूयमपि साम्प्रतं शोकाकुला भवथ किन्तु पुनरपि युष्मभ्यं दर्शनं दास्यामि तेन युष्माकम् अन्तःकरणानि सानन्दानि भविष्यन्ति, युष्माकं तम् आनन्दञ्च कोपि हर्त्तुं न शक्ष्यति। ");
INSERT INTO sandev_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","तस्मिन् दिवसे कामपि कथां मां न प्रक्ष्यथ। युष्मानहम् अतियथार्थं वदामि, मम नाम्ना यत् किञ्चिद् पितरं याचिष्यध्वे तदेव स दास्यति। ");
INSERT INTO sandev_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","पूर्व्वे मम नाम्ना किमपि नायाचध्वं, याचध्वं ततः प्राप्स्यथ तस्माद् युष्माकं सम्पूर्णानन्दो जनिष्यते। ");
INSERT INTO sandev_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","उपमाकथाभिः सर्व्वाण्येतानि युष्मान् ज्ञापितवान् किन्तु यस्मिन् समये उपमया नोक्त्वा पितुः कथां स्पष्टं ज्ञापयिष्यामि समय एतादृश आगच्छति। ");
INSERT INTO sandev_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","तदा मम नाम्ना प्रार्थयिष्यध्वे ऽहं युष्मन्निमित्तं पितरं विनेष्ये कथामिमां न वदामि; ");
INSERT INTO sandev_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","यतो यूयं मयि प्रेम कुरुथ, तथाहम् ईश्वरस्य समीपाद् आगतवान् इत्यपि प्रतीथ, तस्माद् कारणात् कारणात् पिता स्वयं युष्मासु प्रीयते। ");
INSERT INTO sandev_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","पितुः समीपाज्जजद् आगतोस्मि जगत् परित्यज्य च पुनरपि पितुः समीपं गच्छामि। ");
INSERT INTO sandev_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","तदा शिष्या अवदन्, हे प्रभो भवान् उपमया नोक्त्वाधुना स्पष्टं वदति। ");
INSERT INTO sandev_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","भवान् सर्व्वज्ञः केनचित् पृष्टो भवितुमपि भवतः प्रयोजनं नास्तीत्यधुनास्माकं स्थिरज्ञानं जातं तस्माद् भवान् ईश्वरस्य समीपाद् आगतवान् इत्यत्र वयं विश्वसिमः। ");
INSERT INTO sandev_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ततो यीशुः प्रत्यवादीद् इदानीं किं यूयं विश्वसिथ? ");
INSERT INTO sandev_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","पश्यत सर्व्वे यूयं विकीर्णाः सन्तो माम् एकाकिनं पीरत्यज्य स्वं स्वं स्थानं गमिष्यथ, एतादृशः समय आगच्छति वरं प्रायेणोपस्थितवान्; तथाप्यहं नैकाकी भवामि यतः पिता मया सार्द्धम् आस्ते। ");
INSERT INTO sandev_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","यथा मया युष्माकं शान्ति र्जायते तदर्थम् एताः कथा युष्मभ्यम् अचकथं; अस्मिन् जगति युष्माकं क्लेशो घटिष्यते किन्त्वक्षोभा भवत यतो मया जगज्जितं। ");
INSERT INTO sandev_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","ततः परं यीशुरेताः कथाः कथयित्वा स्वर्गं विलोक्यैतत् प्रार्थयत्, हे पितः समय उपस्थितवान्; यथा तव पुत्रस्तव महिमानं प्रकाशयति तदर्थं त्वं निजपुत्रस्य महिमानं प्रकाशय। ");
INSERT INTO sandev_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","त्वं योल्लोकान् तस्य हस्ते समर्पितवान् स यथा तेभ्योऽनन्तायु र्ददाति तदर्थं त्वं प्राणिमात्राणाम् अधिपतित्वभारं तस्मै दत्तवान्। ");
INSERT INTO sandev_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","यस्त्वम् अद्वितीयः सत्य ईश्वरस्त्वया प्रेरितश्च यीशुः ख्रीष्ट एतयोरुभयोः परिचये प्राप्तेऽनन्तायु र्भवति। ");
INSERT INTO sandev_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","त्वं यस्य कर्म्मणो भारं मह्यं दत्तवान्, तत् सम्पन्नं कृत्वा जगत्यस्मिन् तव महिमानं प्राकाशयं। ");
INSERT INTO sandev_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","अतएव हे पित र्जगत्यविद्यमाने त्वया सह तिष्ठतो मम यो महिमासीत् सम्प्रति तव समीपे मां तं महिमानं प्रापय। ");
INSERT INTO sandev_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","अन्यच्च त्वम् एतज्जगतो याल्लोकान् मह्यम् अददा अहं तेभ्यस्तव नाम्नस्तत्त्वज्ञानम् अददां, ते तवैवासन्, त्वं तान् मह्यमददाः, तस्मात्ते तवोपदेशम् अगृह्लन्। ");
INSERT INTO sandev_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","त्वं मह्यं यत् किञ्चिद् अददास्तत्सर्व्वं त्वत्तो जायते इत्यधुनाजानन्। ");
INSERT INTO sandev_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","मह्यं यमुपदेशम् अददा अहमपि तेभ्यस्तमुपदेशम् अददां तेपि तमगृह्लन् त्वत्तोहं निर्गत्य त्वया प्रेरितोभवम् अत्र च व्यश्वसन्। ");
INSERT INTO sandev_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","तेषामेव निमित्तं प्रार्थयेऽहं जगतो लोकनिमित्तं न प्रार्थये किन्तु याल्लोकान् मह्यम् अददास्तेषामेव निमित्तं प्रार्थयेऽहं यतस्ते तवैवासते। ");
INSERT INTO sandev_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ये मम ते तव ये च तव ते मम तथा तै र्मम महिमा प्रकाश्यते। ");
INSERT INTO sandev_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","साम्प्रतम् अस्मिन् जगति ममावस्थितेः शेषम् अभवत् अहं तव समीपं गच्छामि किन्तु ते जगति स्थास्यन्ति; हे पवित्र पितरावयो र्यथैकत्वमास्ते तथा तेषामप्येकत्वं भवति तदर्थं याल्लोकान् मह्यम् अददास्तान् स्वनाम्ना रक्ष। ");
INSERT INTO sandev_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","यावन्ति दिनानि जगत्यस्मिन् तैः सहाहमासं तावन्ति दिनानि तान् तव नाम्नाहं रक्षितवान्; याल्लोकान् मह्यम् अददास्तान् सर्व्वान् अहमरक्षं, तेषां मध्ये केवलं विनाशपात्रं हारितं तेन धर्म्मपुस्तकस्य वचनं प्रत्यक्षं भवति। ");
INSERT INTO sandev_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","किन्त्वधुना तव सन्निधिं गच्छामि मया यथा तेषां सम्पूर्णानन्दो भवति तदर्थमहं जगति तिष्ठन् एताः कथा अकथयम्। ");
INSERT INTO sandev_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","तवोपदेशं तेभ्योऽददां जगता सह यथा मम सम्बन्धो नास्ति तथा जजता सह तेषामपि सम्बन्धाभावाज् जगतो लोकास्तान् ऋतीयन्ते। ");
INSERT INTO sandev_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","त्वं जगतस्तान् गृहाणेति न प्रार्थये किन्त्वशुभाद् रक्षेति प्रार्थयेहम्। ");
INSERT INTO sandev_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","अहं यथा जगत्सम्बन्धीयो न भवामि तथा तेपि जगत्सम्बन्धीया न भवन्ति। ");
INSERT INTO sandev_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","तव सत्यकथया तान् पवित्रीकुरु तव वाक्यमेव सत्यं। ");
INSERT INTO sandev_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","त्वं यथा मां जगति प्रैरयस्तथाहमपि तान् जगति प्रैरयं। ");
INSERT INTO sandev_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","तेषां हितार्थं यथाहं स्वं पवित्रीकरोमि तथा सत्यकथया तेपि पवित्रीभवन्तु। ");
INSERT INTO sandev_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","केवलं एतेषामर्थे प्रार्थयेऽहम् इति न किन्त्वेतेषामुपदेशेन ये जना मयि विश्वसिष्यन्ति तेषामप्यर्थे प्रार्थेयेऽहम्। ");
INSERT INTO sandev_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","हे पितस्तेषां सर्व्वेषाम् एकत्वं भवतु तव यथा मयि मम च यथा त्वय्येकत्वं तथा तेषामप्यावयोरेकत्वं भवतु तेन त्वं मां प्रेरितवान् इति जगतो लोकाः प्रतियन्तु। ");
INSERT INTO sandev_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","यथावयोरेकत्वं तथा तेषामप्येकत्वं भवतु तेष्वहं मयि च त्वम् इत्थं तेषां सम्पूर्णमेकत्वं भवतु, त्वं प्रेरितवान् त्वं मयि यथा प्रीयसे च तथा तेष्वपि प्रीतवान् एतद्यथा जगतो लोका जानन्ति ");
INSERT INTO sandev_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","तदर्थं त्वं यं महिमानं मह्यम् अददास्तं महिमानम् अहमपि तेभ्यो दत्तवान्। ");
INSERT INTO sandev_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","हे पित र्जगतो निर्म्माणात् पूर्व्वं मयि स्नेहं कृत्वा यं महिमानं दत्तवान् मम तं महिमानं यथा ते पश्यन्ति तदर्थं याल्लोकान् मह्यं दत्तवान् अहं यत्र तिष्ठामि तेपि यथा तत्र तिष्ठन्ति ममैषा वाञ्छा। ");
INSERT INTO sandev_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","हे यथार्थिक पित र्जगतो लोकैस्त्वय्यज्ञातेपि त्वामहं जाने त्वं मां प्रेरितवान् इतीमे शिष्या जानन्ति। ");
INSERT INTO sandev_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","यथाहं तेषु तिष्ठामि तथा मयि येन प्रेम्ना प्रेमाकरोस्तत् तेषु तिष्ठति तदर्थं तव नामाहं तान् ज्ञापितवान् पुनरपि ज्ञापयिष्यामि। ");
INSERT INTO sandev_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","ताः कथाः कथयित्वा यीशुः शिष्यानादाय किद्रोन्नामकं स्रोत उत्तीर्य्य शिष्यैः सह तत्रत्योद्यानं प्राविशत्। ");
INSERT INTO sandev_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","किन्तु विश्वासघातियिहूदास्तत् स्थानं परिचीयते यतो यीशुः शिष्यैः सार्द्धं कदाचित् तत् स्थानम् अगच्छत्। ");
INSERT INTO sandev_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","तदा स यिहूदाः सैन्यगणं प्रधानयाजकानां फिरूशिनाञ्च पदातिगणञ्च गृहीत्वा प्रदीपान् उल्कान् अस्त्राणि चादाय तस्मिन् स्थान उपस्थितवान्। ");
INSERT INTO sandev_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","स्वं प्रति यद् घटिष्यते तज् ज्ञात्वा यीशुरग्रेसरः सन् तानपृच्छत् कं गवेषयथ? ");
INSERT INTO sandev_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","ते प्रत्यवदन्, नासरतीयं यीशुं; ततो यीशुरवादीद् अहमेव सः; तैः सह विश्वासघाती यिहूदाश्चातिष्ठत्। ");
INSERT INTO sandev_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","तदाहमेव स तस्यैतां कथां श्रुत्वैव ते पश्चादेत्य भूमौ पतिताः। ");
INSERT INTO sandev_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","ततो यीशुः पुनरपि पृष्ठवान् कं गवेषयथ? ततस्ते प्रत्यवदन् नासरतीयं यीशुं। ");
INSERT INTO sandev_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","तदा यीशुः प्रत्युदितवान् अहमेव स इमां कथामचकथम्; यदि मामन्विच्छथ तर्हीमान् गन्तुं मा वारयत। ");
INSERT INTO sandev_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","इत्थं भूते मह्यं याल्लोकान् अददास्तेषाम् एकमपि नाहारयम् इमां यां कथां स स्वयमकथयत् सा कथा सफला जाता। ");
INSERT INTO sandev_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","तदा शिमोन्पितरस्य निकटे खङ्गल्स्थितेः स तं निष्कोषं कृत्वा महायाजकस्य माल्खनामानं दासम् आहत्य तस्य दक्षिणकर्णं छिन्नवान्। ");
INSERT INTO sandev_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ततो यीशुः पितरम् अवदत्, खङ्गं कोषे स्थापय मम पिता मह्यं पातुं यं कंसम् अददात् तेनाहं किं न पास्यामि? ");
INSERT INTO sandev_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","तदा सैन्यगणः सेनापति र्यिहूदीयानां पदातयश्च यीशुं घृत्वा बद्ध्वा हानन्नाम्नः कियफाः श्वशुरस्य समीपं प्रथमम् अनयन्। ");
INSERT INTO sandev_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","स कियफास्तस्मिन् वत्सरे महायाजत्वपदे नियुक्तः ");
INSERT INTO sandev_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","सन् साधारणलोकानां मङ्गलार्थम् एकजनस्य मरणमुचितम् इति यिहूदीयैः सार्द्धम् अमन्त्रयत्। ");
INSERT INTO sandev_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","तदा शिमोन्पितरोऽन्यैकशिष्यश्च यीशोः पश्चाद् अगच्छतां तस्यान्यशिष्यस्य महायाजकेन परिचितत्वात् स यीशुना सह महायाजकस्याट्टालिकां प्राविशत्। ");
INSERT INTO sandev_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","किन्तु पितरो बहिर्द्वारस्य समीपेऽतिष्ठद् अतएव महायाजकेन परिचितः स शिष्यः पुनर्बहिर्गत्वा दौवायिकायै कथयित्वा पितरम् अभ्यन्तरम् आनयत्। ");
INSERT INTO sandev_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","तदा स द्वाररक्षिका पितरम् अवदत् त्वं किं न तस्य मानवस्य शिष्यः? ततः सोवदद् अहं न भवामि। ");
INSERT INTO sandev_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ततः परं यत्स्थाने दासाः पदातयश्च शीतहेतोरङ्गारै र्वह्निं प्रज्वाल्य तापं सेवितवन्तस्तत्स्थाने पितरस्तिष्ठन् तैः सह वह्नितापं सेवितुम् आरभत। ");
INSERT INTO sandev_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","तदा शिष्येषूपदेशे च महायाजकेन यीशुः पृष्टः ");
INSERT INTO sandev_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","सन् प्रत्युक्तवान् सर्व्वलोकानां समक्षं कथामकथयं गुप्तं कामपि कथां न कथयित्वा यत् स्थानं यिहूदीयाः सततं गच्छन्ति तत्र भजनगेहे मन्दिरे चाशिक्षयं। ");
INSERT INTO sandev_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","मत्तः कुतः पृच्छसि? ये जना मदुपदेशम् अशृण्वन् तानेव पृच्छ यद्यद् अवदं ते तत् जानिन्त। ");
INSERT INTO sandev_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","तदेत्थं प्रत्युदितत्वात् निकटस्थपदाति र्यीशुं चपेटेनाहत्य व्याहरत् महायाजकम् एवं प्रतिवदसि? ");
INSERT INTO sandev_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ततो यीशुः प्रतिगदितवान् यद्ययथार्थम् अचकथं तर्हि तस्यायथार्थस्य प्रमाणं देहि, किन्तु यदि यथार्थं तर्हि कुतो हेतो र्माम् अताडयः? ");
INSERT INTO sandev_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","पूर्व्वं हानन् सबन्धनं तं कियफामहायाजकस्य समीपं प्रैषयत्। ");
INSERT INTO sandev_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","शिमोन्पितरस्तिष्ठन् वह्नितापं सेवते, एतस्मिन् समये कियन्तस्तम् अपृच्छन् त्वं किम् एतस्य जनस्य शिष्यो न? ततः सोपह्नुत्याब्रवीद् अहं न भवामि। ");
INSERT INTO sandev_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","तदा महायाजकस्य यस्य दासस्य पितरः कर्णमच्छिनत् तस्य कुटुम्बः प्रत्युदितवान् उद्याने तेन सह तिष्ठन्तं त्वां किं नापश्यं? ");
INSERT INTO sandev_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","किन्तु पितरः पुनरपह्नुत्य कथितवान्; तदानीं कुक्कुटोऽरौत्। ");
INSERT INTO sandev_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","तदनन्तरं प्रत्यूषे ते कियफागृहाद् अधिपते र्गृहं यीशुम् अनयन् किन्तु यस्मिन् अशुचित्वे जाते तै र्निस्तारोत्सवे न भोक्तव्यं, तस्य भयाद् यिहूदीयास्तद्गृहं नाविशन्। ");
INSERT INTO sandev_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","अपरं पीलातो बहिरागत्य तान् पृष्ठवान् एतस्य मनुष्यस्य कं दोषं वदथ? ");
INSERT INTO sandev_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","तदा ते पेत्यवदन् दुष्कर्म्मकारिणि न सति भवतः समीपे नैनं समार्पयिष्यामः। ");
INSERT INTO sandev_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ततः पीलातोऽवदद् यूयमेनं गृहीत्वा स्वेषां व्यवस्थया विचारयत। तदा यिहूदीयाः प्रत्यवदन् कस्यापि मनुष्यस्य प्राणदण्डं कर्त्तुं नास्माकम् अधिकारोऽस्ति। ");
INSERT INTO sandev_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","एवं सति यीशुः स्वस्य मृत्यौ यां कथां कथितवान् सा सफलाभवत्। ");
INSERT INTO sandev_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","तदनन्तरं पीलातः पुनरपि तद् राजगृहं गत्वा यीशुमाहूय पृष्टवान् त्वं किं यिहूदीयानां राजा? ");
INSERT INTO sandev_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","यीशुः प्रत्यवदत् त्वम् एतां कथां स्वतः कथयसि किमन्यः कश्चिन् मयि कथितवान्? ");
INSERT INTO sandev_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","पीलातोऽवदद् अहं किं यिहूदीयः? तव स्वदेशीया विशेषतः प्रधानयाजका मम निकटे त्वां समार्पयन, त्वं किं कृतवान्? ");
INSERT INTO sandev_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","यीशुः प्रत्यवदत् मम राज्यम् एतज्जगत्सम्बन्धीयं न भवति यदि मम राज्यं जगत्सम्बन्धीयम् अभविष्यत् तर्हि यिहूदीयानां हस्तेषु यथा समर्पितो नाभवं तदर्थं मम सेवका अयोत्स्यन् किन्तु मम राज्यम् ऐहिकं न। ");
INSERT INTO sandev_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","तदा पीलातः कथितवान्, तर्हि त्वं राजा भवसि? यीशुः प्रत्युक्तवान् त्वं सत्यं कथयसि, राजाहं भवामि; सत्यतायां साक्ष्यं दातुं जनिं गृहीत्वा जगत्यस्मिन् अवतीर्णवान्, तस्मात् सत्यधर्म्मपक्षपातिनो मम कथां शृण्वन्ति। ");
INSERT INTO sandev_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","तदा सत्यं किं? एतां कथां पष्ट्वा पीलातः पुनरपि बहिर्गत्वा यिहूदीयान् अभाषत, अहं तस्य कमप्यपराधं न प्राप्नोमि। ");
INSERT INTO sandev_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","निस्तारोत्सवसमये युष्माभिरभिरुचित एको जनो मया मोचयितव्य एषा युष्माकं रीतिरस्ति, अतएव युष्माकं निकटे यिहूदीयानां राजानं किं मोचयामि, युष्माकम् इच्छा का? ");
INSERT INTO sandev_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","तदा ते सर्व्वे रुवन्तो व्याहरन् एनं मानुषं नहि बरब्बां मोचय। किन्तु स बरब्बा दस्युरासीत्। ");
INSERT INTO sandev_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","पीलातो यीशुम् आनीय कशया प्राहारयत्। ");
INSERT INTO sandev_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","पश्चात् सेनागणः कण्टकनिर्म्मितं मुकुटं तस्य मस्तके समर्प्य वार्त्ताकीवर्णं राजपरिच्छदं परिधाप्य, ");
INSERT INTO sandev_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","हे यिहूदीयानां राजन् नमस्कार इत्युक्त्वा तं चपेटेनाहन्तुम् आरभत। ");
INSERT INTO sandev_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","तदा पीलातः पुनरपि बहिर्गत्वा लोकान् अवदत्, अस्य कमप्यपराधं न लभेऽहं, पश्यत तद् युष्मान् ज्ञापयितुं युष्माकं सन्निधौ बहिरेनम् आनयामि। ");
INSERT INTO sandev_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","ततः परं यीशुः कण्टकमुकुटवान् वार्त्ताकीवर्णवसनवांश्च बहिरागच्छत्। ततः पीलात उक्तवान् एनं मनुष्यं पश्यत। ");
INSERT INTO sandev_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","तदा प्रधानयाजकाः पदातयश्च तं दृष्ट्वा, एनं क्रुशे विध, एनं क्रुशे विध, इत्युक्त्वा रवितुं आरभन्त। ततः पीलातः कथितवान् यूयं स्वयम् एनं नीत्वा क्रुशे विधत, अहम् एतस्य कमप्यपराधं न प्राप्तवान्। ");
INSERT INTO sandev_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","यिहूदीयाः प्रत्यवदन् अस्माकं या व्यवस्थास्ते तदनुसारेणास्य प्राणहननम् उचितं यतोयं स्वम् ईश्वरस्य पुत्रमवदत्। ");
INSERT INTO sandev_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","पीलात इमां कथां श्रुत्वा महात्रासयुक्तः ");
INSERT INTO sandev_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","सन् पुनरपि राजगृह आगत्य यीशुं पृष्टवान् त्वं कुत्रत्यो लोकः? किन्तु यीशस्तस्य किमपि प्रत्युत्तरं नावदत्। ");
INSERT INTO sandev_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","१॰ ततः पीलात् कथितवान त्वं किं मया सार्द्धं न संलपिष्यसि ? त्वां क्रुशे वेधितुं वा मोचयितुं शक्ति र्ममास्ते इति किं त्वं न जानासि ? तदा यीशुः प्रत्यवदद् ईश्वरेणादŸां ममोपरि तव किमप्यधिपतित्वं न विद्यते, तथापि यो जनो मां तव हस्ते समार्पयत् तस्य महापातकं जातम्। ");
INSERT INTO sandev_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","तदा यीशुः प्रत्यवदद् ईश्वरेणादत्तं ममोपरि तव किमप्यधिपतित्वं न विद्यते, तथापि यो जनो मां तव हस्ते समार्पयत् तस्य महापातकं जातम्। ");
INSERT INTO sandev_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","तदारभ्य पीलातस्तं मोचयितुं चेष्टितवान् किन्तु यिहूदीया रुवन्तो व्याहरन् यदीमं मानवं त्यजसि तर्हि त्वं कैसरस्य मित्रं न भवसि, यो जनः स्वं राजानं वक्ति सएव कैमरस्य विरुद्धां कथां कथयति। ");
INSERT INTO sandev_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","एतां कथां श्रुत्वा पीलातो यीशुं बहिरानीय निस्तारोत्सवस्य आसादनदिनस्य द्वितीयप्रहरात् पूर्व्वं प्रस्तरबन्धननाम्नि स्थाने ऽर्थात् इब्रीयभाषया यद् गब्बिथा कथ्यते तस्मिन् स्थाने विचारासन उपाविशत्। ");
INSERT INTO sandev_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","अनन्तरं पीलातो यिहूदीयान् अवदत्, युष्माकं राजानं पश्यत। ");
INSERT INTO sandev_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","किन्तु एनं दूरीकुरु, एनं दूरीकुरु, एनं क्रुशे विध, इति कथां कथयित्वा ते रवितुम् आरभन्त; तदा पीलातः कथितवान् युष्माकं राजानं किं क्रुशे वेधिष्यामि? प्रधानयाजका उत्तरम् अवदन् कैसरं विना कोपि राजास्माकं नास्ति। ");
INSERT INTO sandev_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","ततः पीलातो यीशुं क्रुशे वेधितुं तेषां हस्तेषु समार्पयत्, ततस्ते तं धृत्वा नीतवन्तः। ");
INSERT INTO sandev_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ततः परं यीशुः क्रुशं वहन् शिरःकपालम् अर्थाद् यद् इब्रीयभाषया गुल्गल्तां वदन्ति तस्मिन् स्थान उपस्थितः। ");
INSERT INTO sandev_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ततस्ते मध्यस्थाने तं तस्योभयपार्श्वे द्वावपरौ क्रुशेऽविधन्। ");
INSERT INTO sandev_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","अपरम् एष यिहूदीयानां राजा नासरतीययीशुः, इति विज्ञापनं लिखित्वा पीलातस्तस्य क्रुशोपरि समयोजयत्। ");
INSERT INTO sandev_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","सा लिपिः इब्रीययूनानीयरोमीयभाषाभि र्लिखिता; यीशोः क्रुशवेधनस्थानं नगरस्य समीपं, तस्माद् बहवो यिहूदीयास्तां पठितुम् आरभन्त। ");
INSERT INTO sandev_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","यिहूदीयानां प्रधानयाजकाः पीलातमिति न्यवेदयन् यिहूदीयानां राजेति वाक्यं न किन्तु एष स्वं यिहूदीयानां राजानम् अवदद् इत्थं लिखतु। ");
INSERT INTO sandev_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","ततः पीलात उत्तरं दत्तवान् यल्लेखनीयं तल्लिखितवान्। ");
INSERT INTO sandev_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","इत्थं सेनागणो यीशुं क्रुशे विधित्वा तस्य परिधेयवस्त्रं चतुरो भागान् कृत्वा एकैकसेना एकैकभागम् अगृह्लत् तस्योत्तरीयवस्त्रञ्चागृह्लत्। किन्तूत्तरीयवस्त्रं सूचिसेवनं विना सर्व्वम् ऊतं। ");
INSERT INTO sandev_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","तस्मात्ते व्याहरन् एतत् कः प्राप्स्यति? तन्न खण्डयित्वा तत्र गुटिकापातं करवाम। विभजन्तेऽधरीयं मे वसनं ते परस्परं। ममोत्तरीयवस्त्रार्थं गुटिकां पातयन्ति च। इति यद्वाक्यं धर्म्मपुस्तके लिखितमास्ते तत् सेनागणेनेत्थं व्यवहरणात् सिद्धमभवत्। ");
INSERT INTO sandev_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","तदानीं यीशो र्माता मातु र्भगिनी च या क्लियपा भार्य्या मरियम् मग्दलीनी मरियम् च एतास्तस्य क्रुशस्य सन्निधौ समतिष्ठन्। ");
INSERT INTO sandev_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","ततो यीशुः स्वमातरं प्रियतमशिष्यञ्च समीपे दण्डायमानौ विलोक्य मातरम् अवदत्, हे योषिद् एनं तव पुत्रं पश्य, ");
INSERT INTO sandev_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","शिष्यन्त्ववदत्, एनां तव मातरं पश्य। ततः स शिष्यस्तद्घटिकायां तां निजगृहं नीतवान्। ");
INSERT INTO sandev_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","अनन्तरं सर्व्वं कर्म्माधुना सम्पन्नमभूत् यीशुरिति ज्ञात्वा धर्म्मपुस्तकस्य वचनं यथा सिद्धं भवति तदर्थम् अकथयत् मम पिपासा जाता। ");
INSERT INTO sandev_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ततस्तस्मिन् स्थाने अम्लरसेन पूर्णपात्रस्थित्या ते स्पञ्जमेकं तदम्लरसेनार्द्रीकृत्य एसोब्नले तद् योजयित्वा तस्य मुखस्य सन्निधावस्थापयन्। ");
INSERT INTO sandev_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","तदा यीशुरम्लरसं गृहीत्वा सर्व्वं सिद्धम् इति कथां कथयित्वा मस्तकं नमयन् प्राणान् पर्य्यत्यजत्। ");
INSERT INTO sandev_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","तद्विनम् आसादनदिनं तस्मात् परेऽहनि विश्रामवारे देहा यथा क्रुशोपरि न तिष्ठन्ति, यतः स विश्रामवारो महादिनमासीत्, तस्माद् यिहूदीयाः पीलातनिकटं गत्वा तेषां पादभञ्जनस्य स्थानान्तरनयनस्य चानुमतिं प्रार्थयन्त। ");
INSERT INTO sandev_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","अतः सेना आगत्य यीशुना सह क्रुशे हतयोः प्रथमद्वितीयचोरयोः पादान् अभञ्जन्; ");
INSERT INTO sandev_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","किन्तु यीशोः सन्निधिं गत्वा स मृत इति दृष्ट्वा तस्य पादौ नाभञ्जन्। ");
INSERT INTO sandev_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","पश्चाद् एको योद्धा शूलाघातेन तस्य कुक्षिम् अविधत् तत्क्षणात् तस्माद् रक्तं जलञ्च निरगच्छत्। ");
INSERT INTO sandev_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","यो जनोऽस्य साक्ष्यं ददाति स स्वयं दृष्टवान् तस्येदं साक्ष्यं सत्यं तस्य कथा युष्माकं विश्वासं जनयितुं योग्या तत् स जानाति। ");
INSERT INTO sandev_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","तस्यैकम् अस्ध्यपि न भंक्ष्यते, ");
INSERT INTO sandev_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","तद्वद् अन्यशास्त्रेपि लिख्यते, यथा, \"दृष्टिपातं करिष्यन्ति तेऽविधन् यन्तु तम्प्रति।\" ");
INSERT INTO sandev_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","अरिमथीयनगरस्य यूषफ्नामा शिष्य एक आसीत् किन्तु यिहूदीयेभ्यो भयात् प्रकाशितो न भवति; स यीशो र्देहं नेतुं पीलातस्यानुमतिं प्रार्थयत, ततः पीलातेनानुमते सति स गत्वा यीशो र्देहम् अनयत्। ");
INSERT INTO sandev_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","अपरं यो निकदीमो रात्रौ यीशोः समीपम् अगच्छत् सोपि गन्धरसेन मिश्रितं प्रायेण पञ्चाशत्सेटकमगुरुं गृहीत्वागच्छत्। ");
INSERT INTO sandev_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","ततस्ते यिहूदीयानां श्मशाने स्थापनरीत्यनुसारेण तत्सुगन्धिद्रव्येण सहितं तस्य देहं वस्त्रेणावेष्टयन्। ");
INSERT INTO sandev_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","अपरञ्च यत्र स्थाने तं क्रुशेऽविधन् तस्य निकटस्थोद्याने यत्र किमपि मृतदेहं कदापि नास्थाप्यत तादृशम् एकं नूतनं श्मशानम् आसीत्। ");
INSERT INTO sandev_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","यिहूदीयानाम् आसादनदिनागमनात् ते तस्मिन् समीपस्थश्मशाने यीशुम् अशाययन्। ");
INSERT INTO sandev_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","अनन्तरं सप्ताहस्य प्रथमदिने ऽतिप्रत्यूषे ऽन्धकारे तिष्ठति मग्दलीनी मरियम् तस्य श्मशानस्य निकटं गत्वा श्मशानस्य मुखात् प्रस्तरमपसारितम् अपश्यत्। ");
INSERT INTO sandev_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","पश्चाद् धावित्वा शिमोन्पितराय यीशोः प्रियतमशिष्याय चेदम् अकथयत्, लोकाः श्मशानात् प्रभुं नीत्वा कुत्रास्थापयन् तद् वक्तुं न शक्नोमि। ");
INSERT INTO sandev_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","अतः पितरः सोन्यशिष्यश्च बर्हि र्भुत्वा श्मशानस्थानं गन्तुम् आरभेतां। ");
INSERT INTO sandev_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","उभयोर्धावतोः सोन्यशिष्यः पितरं पश्चात् त्यक्त्वा पूर्व्वं श्मशानस्थान उपस्थितवान्। ");
INSERT INTO sandev_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","तदा प्रह्वीभूय स्थापितवस्त्राणि दृष्टवान् किन्तु न प्राविशत्। ");
INSERT INTO sandev_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","अपरं शिमोन्पितर आगत्य श्मशानस्थानं प्रविश्य ");
INSERT INTO sandev_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","स्थापितवस्त्राणि मस्तकस्य वस्त्रञ्च पृथक् स्थानान्तरे स्थापितं दृष्टवान्। ");
INSERT INTO sandev_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","ततः श्मशानस्थानं पूर्व्वम् आगतो योन्यशिष्यः सोपि प्रविश्य तादृशं दृष्टा व्यश्वसीत्। ");
INSERT INTO sandev_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","यतः श्मशानात् स उत्थापयितव्य एतस्य धर्म्मपुस्तकवचनस्य भावं ते तदा वोद्धुं नाशन्कुवन्। ");
INSERT INTO sandev_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","अनन्तरं तौ द्वौ शिष्यौ स्वं स्वं गृहं परावृत्यागच्छताम्। ");
INSERT INTO sandev_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","ततः परं मरियम् श्मशानद्वारस्य बहिः स्थित्वा रोदितुम् आरभत ततो रुदती प्रह्वीभूय श्मशानं विलोक्य ");
INSERT INTO sandev_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","यीशोः शयनस्थानस्य शिरःस्थाने पदतले च द्वयो र्दिशो द्वौ स्वर्गीयदूतावुपविष्टौ समपश्यत्। ");
INSERT INTO sandev_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","तौ पृष्टवन्तौ हे नारि कुतो रोदिषि? सावदत् लोका मम प्रभुं नीत्वा कुत्रास्थापयन् इति न जानामि। ");
INSERT INTO sandev_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","इत्युक्त्वा मुखं परावृत्य यीशुं दण्डायमानम् अपश्यत् किन्तु स यीशुरिति सा ज्ञातुं नाशक्नोत्। ");
INSERT INTO sandev_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","तदा यीशुस्ताम् अपृच्छत् हे नारि कुतो रोदिषि? कं वा मृगयसे? ततः सा तम् उद्यानसेवकं ज्ञात्वा व्याहरत्, हे महेच्छ त्वं यदीतः स्थानात् तं नीतवान् तर्हि कुत्रास्थापयस्तद् वद तत्स्थानात् तम् आनयामि। ");
INSERT INTO sandev_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","तदा यीशुस्ताम् अवदत् हे मरियम्। ततः सा परावृत्य प्रत्यवदत् हे रब्बूनी अर्थात् हे गुरो। ");
INSERT INTO sandev_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","तदा यीशुरवदत् मां मा धर, इदानीं पितुः समीपे ऊर्द्ध्वगमनं न करोमि किन्तु यो मम युष्माकञ्च पिता मम युष्माकञ्चेश्वरस्तस्य निकट ऊर्द्ध्वगमनं कर्त्तुम् उद्यतोस्मि, इमां कथां त्वं गत्वा मम भ्रातृगणं ज्ञापय। ");
INSERT INTO sandev_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","ततो मग्दलीनीमरियम् तत्क्षणाद् गत्वा प्रभुस्तस्यै दर्शनं दत्त्वा कथा एता अकथयद् इति वार्त्तां शिष्येभ्योऽकथयत्। ");
INSERT INTO sandev_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ततः परं सप्ताहस्य प्रथमदिनस्य सन्ध्यासमये शिष्या एकत्र मिलित्वा यिहूदीयेभ्यो भिया द्वाररुद्धम् अकुर्व्वन्, एतस्मिन् काले यीशुस्तेषां मध्यस्थाने तिष्ठन् अकथयद् युष्माकं कल्याणं भूयात्। ");
INSERT INTO sandev_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","इत्युक्त्वा निजहस्तं कुक्षिञ्च दर्शितवान्, ततः शिष्याः प्रभुं दृष्ट्वा हृष्टा अभवन्। ");
INSERT INTO sandev_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","यीशुः पुनरवदद् युष्माकं कल्याणं भूयात् पिता यथा मां प्रैषयत् तथाहमपि युष्मान् प्रेषयामि। ");
INSERT INTO sandev_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","इत्युक्त्वा स तेषामुपरि दीर्घप्रश्वासं दत्त्वा कथितवान् पवित्रम् आत्मानं गृह्लीत। ");
INSERT INTO sandev_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","यूयं येषां पापानि मोचयिष्यथ ते मोचयिष्यन्ते येषाञ्च पापाति न मोचयिष्यथ ते न मोचयिष्यन्ते। ");
INSERT INTO sandev_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","द्वादशमध्ये गणितो यमजो थोमानामा शिष्यो यीशोरागमनकालै तैः सार्द्धं नासीत्। ");
INSERT INTO sandev_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","अतो वयं प्रभूम् अपश्यामेति वाक्येऽन्यशिष्यैरुक्ते सोवदत्, तस्य हस्तयो र्लौहकीलकानां चिह्नं न विलोक्य तच्चिह्नम् अङ्गुल्या न स्पृष्ट्वा तस्य कुक्षौ हस्तं नारोप्य चाहं न विश्वसिष्यामि। ");
INSERT INTO sandev_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","अपरम् अष्टमेऽह्नि गते सति थोमासहितः शिष्यगण एकत्र मिलित्वा द्वारं रुद्ध्वाभ्यन्तर आसीत्, एतर्हि यीशुस्तेषां मध्यस्थाने तिष्ठन् अकथयत्, युष्माकं कुशलं भूयात्। ");
INSERT INTO sandev_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","पश्चात् थामै कथितवान् त्वम् अङ्गुलीम् अत्रार्पयित्वा मम करौ पश्य करं प्रसार्य्य मम कुक्षावर्पय नाविश्वस्य। ");
INSERT INTO sandev_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","तदा थोमा अवदत्, हे मम प्रभो हे मदीश्वर। ");
INSERT INTO sandev_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","यीशुरकथयत्, हे थोमा मां निरीक्ष्य विश्वसिषि ये न दृष्ट्वा विश्वसन्ति तएव धन्याः। ");
INSERT INTO sandev_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","एतदन्यानि पुस्तकेऽस्मिन् अलिखितानि बहून्याश्चर्य्यकर्म्माणि यीशुः शिष्याणां पुरस्ताद् अकरोत्। ");
INSERT INTO sandev_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","किन्तु यीशुरीश्वरस्याभिषिक्तः सुत एवेति यथा यूयं विश्वसिथ विश्वस्य च तस्य नाम्ना परमायुः प्राप्नुथ तदर्थम् एतानि सर्व्वाण्यलिख्यन्त। ");
INSERT INTO sandev_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","ततः परं तिबिरियाजलधेस्तटे यीशुः पुनरपि शिष्येभ्यो दर्शनं दत्तवान् दर्शनस्याख्यानमिदम्। ");
INSERT INTO sandev_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","शिमोन्पितरः यमजथोमा गालीलीयकान्नानगरनिवासी निथनेल् सिवदेः पुत्रावन्यौ द्वौ शिष्यौ चैतेष्वेकत्र मिलितेषु शिमोन्पितरोऽकथयत् मत्स्यान् धर्तुं यामि। ");
INSERT INTO sandev_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ततस्ते व्याहरन् तर्हि वयमपि त्वया सार्द्धं यामः तदा ते बहिर्गताः सन्तः क्षिप्रं नावम् आरोहन् किन्तु तस्यां रजन्याम् एकमपि न प्राप्नुवन्। ");
INSERT INTO sandev_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","प्रभाते सति यीशुस्तटे स्थितवान् किन्तु स यीशुरिति शिष्या ज्ञातुं नाशक्नुवन्। ");
INSERT INTO sandev_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","तदा यीशुरपृच्छत्, हे वत्सा सन्निधौ किञ्चित् खाद्यद्रव्यम् आस्ते? तेऽवदन् किमपि नास्ति। ");
INSERT INTO sandev_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","तदा सोऽवदत् नौकाया दक्षिणपार्श्वे जालं निक्षिपत ततो लप्स्यध्वे, तस्मात् तै र्निक्षिप्ते जाले मत्स्या एतावन्तोऽपतन् येन ते जालमाकृष्य नोत्तोलयितुं शक्ताः। ");
INSERT INTO sandev_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","तस्माद् यीशोः प्रियतमशिष्यः पितरायाकथयत् एष प्रभु र्भवेत्, एष प्रभुरिति वाचं श्रुत्वैव शिमोन् नग्नताहेतो र्मत्स्यधारिण उत्तरीयवस्त्रं परिधाय ह्रदं प्रत्युदलम्फयत्। ");
INSERT INTO sandev_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","अपरे शिष्या मत्स्यैः सार्द्धं जालम् आकर्षन्तः क्षुद्रनौकां वाहयित्वा कूलमानयन् ते कूलाद् अतिदूरे नासन् द्विशतहस्तेभ्यो दूर आसन् इत्यनुमीयते। ");
INSERT INTO sandev_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","तीरं प्राप्तैस्तैस्तत्र प्रज्वलिताग्निस्तदुपरि मत्स्याः पूपाश्च दृष्टाः। ");
INSERT INTO sandev_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","ततो यीशुरकथयद् यान् मत्स्यान् अधरत तेषां कतिपयान् आनयत। ");
INSERT INTO sandev_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","अतः शिमोन्पितरः परावृत्य गत्वा बृहद्भिस्त्रिपञ्चाशदधिकशतमत्स्यैः परिपूर्णं तज्जालम् आकृष्योदतोलयत् किन्त्वेतावद्भि र्मत्स्यैरपि जालं नाछिद्यत। ");
INSERT INTO sandev_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","अनन्तरं यीशुस्तान् अवादीत् यूयमागत्य भुंग्ध्वं; तदा सएव प्रभुरिति ज्ञातत्वात् त्वं कः? इति प्रष्टुं शिष्याणां कस्यापि प्रगल्भता नाभवत्। ");
INSERT INTO sandev_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ततो यीशुरागत्य पूपान् मत्स्यांश्च गृहीत्वा तेभ्यः पर्य्यवेषयत्। ");
INSERT INTO sandev_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","इत्थं श्मशानादुत्थानात् परं यीशुः शिष्येभ्यस्तृतीयवारं दर्शनं दत्तवान्। ");
INSERT INTO sandev_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","भोजने समाप्ते सति यीशुः शिमोन्पितरं पृष्टवान्, हे यूनसः पुत्र शिमोन् त्वं किम् एतेभ्योधिकं मयि प्रीयसे? ततः स उदितवान् सत्यं प्रभो त्वयि प्रीयेऽहं तद् भवान् जानाति; तदा यीशुरकथयत् तर्हि मम मेषशावकगणं पालय। ");
INSERT INTO sandev_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ततः स द्वितीयवारं पृष्टवान् हे यूनसः पुत्र शिमोन् त्वं किं मयि प्रीयसे? ततः स उक्तवान् सत्यं प्रभो त्वयि प्रीयेऽहं तद् भवान् जानाति; तदा यीशुरकथयत तर्हि मम मेषगणं पालय। ");
INSERT INTO sandev_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","पश्चात् स तृतीयवारं पृष्टवान्, हे यूनसः पुत्र शिमोन् त्वं किं मयि प्रीयसे? एतद्वाक्यं तृतीयवारं पृष्टवान् तस्मात् पितरो दुःखितो भूत्वाऽकथयत् हे प्रभो भवतः किमप्यगोचरं नास्ति त्वय्यहं प्रीये तद् भवान् जानाति; ततो यीशुरवदत् तर्हि मम मेषगणं पालय। ");
INSERT INTO sandev_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","अहं तुभ्यं यथार्थं कथयामि यौवनकाले स्वयं बद्धकटि र्यत्रेच्छा तत्र यातवान् किन्त्वितः परं वृद्धे वयसि हस्तं विस्तारयिष्यसि, अन्यजनस्त्वां बद्ध्वा यत्र गन्तुं तवेच्छा न भवति त्वां धृत्वा तत्र नेष्यति। ");
INSERT INTO sandev_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","फलतः कीदृशेन मरणेन स ईश्वरस्य महिमानं प्रकाशयिष्यति तद् बोधयितुं स इति वाक्यं प्रोक्तवान्। इत्युक्ते सति स तमवोचत् मम पश्चाद् आगच्छ। ");
INSERT INTO sandev_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","यो जनो रात्रिकाले यीशो र्वक्षोऽवलम्ब्य, हे प्रभो को भवन्तं परकरेषु समर्पयिष्यतीति वाक्यं पृष्टवान्, तं यीशोः प्रियतमशिष्यं पश्चाद् आगच्छन्तं ");
INSERT INTO sandev_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","पितरो मुखं परावर्त्त्य विलोक्य यीशुं पृष्टवान्, हे प्रभो एतस्य मानवस्य कीदृशी गति र्भविष्यति? ");
INSERT INTO sandev_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","स प्रत्यवदत्, मम पुनरागमनपर्य्यन्तं यदि तं स्थापयितुम् इच्छामि तत्र तव किं? त्वं मम पश्चाद् आगच्छ। ");
INSERT INTO sandev_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","तस्मात् स शिष्यो न मरिष्यतीति भ्रातृगणमध्ये किंवदन्ती जाता किन्तु स न मरिष्यतीति वाक्यं यीशु र्नावदत् केवलं मम पुनरागमनपर्य्यन्तं यदि तं स्थापयितुम् इच्छामि तत्र तव किं? इति वाक्यम् उक्तवान्। ");
INSERT INTO sandev_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","यो जन एतानि सर्व्वाणि लिखितवान् अत्र साक्ष्यञ्च दत्तवान् सएव स शिष्यः, तस्य साक्ष्यं प्रमाणमिति वयं जानीमः। ");
INSERT INTO sandev_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","यीशुरेतेभ्योऽपराण्यपि बहूनि कर्म्माणि कृतवान् तानि सर्व्वाणि यद्येकैकं कृत्वा लिख्यन्ते तर्हि ग्रन्था एतावन्तो भवन्ति तेषां धारणे पृथिव्यां स्थानं न भवति। इति॥");
INSERT INTO sandev_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","हे थियफिल, यीशुः स्वमनोनीतान् प्रेरितान् पवित्रेणात्मना समादिश्य यस्मिन् दिने स्वर्गमारोहत् यां यां क्रियामकरोत् यद्यद् उपादिशच्च तानि सर्व्वाणि पूर्व्वं मया लिखितानि। ");
INSERT INTO sandev_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","स स्वनिधनदुःखभोगात् परम् अनेकप्रत्ययक्षप्रमाणौः स्वं सजीवं दर्शयित्वा ");
INSERT INTO sandev_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","चत्वारिंशद्दिनानि यावत् तेभ्यः प्रेरितेभ्यो दर्शनं दत्त्वेश्वरीयराज्यस्य वर्णनम अकरोत्। ");
INSERT INTO sandev_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","अनन्तरं तेषां सभां कृत्वा इत्याज्ञापयत्, यूयं यिरूशालमोऽन्यत्र गमनमकृत्वा यस्तिन् पित्राङ्गीकृते मम वदनात् कथा अशृणुत तत्प्राप्तिम् अपेक्ष्य तिष्ठत। ");
INSERT INTO sandev_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","योहन् जले मज्जितावान् किन्त्वल्पदिनमध्ये यूयं पवित्र आत्मनि मज्जिता भविष्यथ। ");
INSERT INTO sandev_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","पश्चात् ते सर्व्वे मिलित्वा तम् अपृच्छन् हे प्रभो भवान् किमिदानीं पुनरपि राज्यम् इस्रायेलीयलोकानां करेषु समर्पयिष्यति? ");
INSERT INTO sandev_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ततः सोवदत् यान् सर्व्वान् कालान् समयांश्च पिता स्ववशेऽस्थापयत् तान् ज्ञातृं युष्माकम् अधिकारो न जायते। ");
INSERT INTO sandev_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","किन्तु युष्मासु पवित्रस्यात्मन आविर्भावे सति यूयं शक्तिं प्राप्य यिरूशालमि समस्तयिहूदाशोमिरोणदेशयोः पृथिव्याः सीमां यावद् यावन्तो देशास्तेषु यर्व्वेषु च मयि साक्ष्यं दास्यथ। ");
INSERT INTO sandev_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","इति वाक्यमुक्त्वा स तेषां समक्षं स्वर्गं नीतोऽभवत्, ततो मेघमारुह्य तेषां दृष्टेरगोचरोऽभवत्। ");
INSERT INTO sandev_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","यस्मिन् समये ते विहायसं प्रत्यनन्यदृष्ट्या तस्य तादृशम् ऊर्द्व्वगमनम् अपश्यन् तस्मिन्नेव समये शुक्लवस्त्रौ द्वौ जनौ तेषां सन्निधौ दण्डायमानौ कथितवन्तौ, ");
INSERT INTO sandev_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","हे गालीलीयलोका यूयं किमर्थं गगणं प्रति निरीक्ष्य दण्डायमानास्तिष्ठथ? युष्माकं समीपात् स्वर्गं नीतो यो यीशुस्तं यूयं यथा स्वर्गम् आरोहन्तम् अदर्शम् तथा स पुनश्चागमिष्यति। ");
INSERT INTO sandev_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","ततः परं ते जैतुननाम्नः पर्व्वताद् विश्रामवारस्य पथः परिमाणम् अर्थात् प्रायेणार्द्धक्रोशं दुरस्थं यिरूशालम्नगरं परावृत्यागच्छन्। ");
INSERT INTO sandev_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","नगरं प्रविश्य पितरो याकूब् योहन् आन्द्रियः फिलिपः थोमा बर्थजमयो मथिराल्फीयपुत्रो याकूब् उद्योगाी शिमोन् याकूबो भ्राता यिहूदा एते सर्व्वे यत्र स्थाने प्रवसन्ति तस्मिन् उपरितनप्रकोष्ठे प्राविशन्। ");
INSERT INTO sandev_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","पश्चाद् इमे कियत्यः स्त्रियश्च यीशो र्माता मरियम् तस्य भ्रातरश्चैते सर्व्व एकचित्तीभूत सततं विनयेन विनयेन प्रार्थयन्त। ");
INSERT INTO sandev_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","तस्मिन् समये तत्र स्थाने साकल्येन विंशत्यधिकशतं शिष्या आसन्। ततः पितरस्तेषां मध्ये तिष्ठन् उक्तवान् ");
INSERT INTO sandev_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","हे भ्रातृगण यीशुधारिणां लोकानां पथदर्शको यो यिहूदास्तस्मिन् दायूदा पवित्र आत्मा यां कथां कथयामास तस्याः प्रत्यक्षीभवनस्यावश्यकत्वम् आसीत्। ");
INSERT INTO sandev_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","स जनोऽस्माकं मध्यवर्त्ती सन् अस्याः सेवाया अंशम् अलभत। ");
INSERT INTO sandev_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","तदनन्तरं कुकर्म्मणा लब्धं यन्मूल्यं तेन क्षेत्रमेकं क्रीतम् अपरं तस्मिन् अधोमुखे भृमौ पतिते सति तस्योदरस्य विदीर्णत्वात् सर्व्वा नाड्यो निरगच्छन्। ");
INSERT INTO sandev_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","एतां कथां यिरूशालम्निवासिनः सर्व्वे लोका विदान्ति; तेषां निजभाषया तत्क्षेत्रञ्च हकल्दामा, अर्थात् रक्तक्षेत्रमिति विख्यातमास्ते। ");
INSERT INTO sandev_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","अन्यच्च, निकेतनं तदीयन्तु शुन्यमेव भविष्यति। तस्य दूष्ये निवासार्थं कोपि स्थास्यति नैव हि। अन्य एव जनस्तस्य पदं संप्राप्स्यति ध्रुवं। इत्थं गीतपुस्तके लिखितमास्ते। ");
INSERT INTO sandev_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","अतो योहनो मज्जनम् आरभ्यास्माकं समीपात् प्रभो र्यीशोः स्वर्गारोहणदिनं यावत् सोस्माकं मध्ये यावन्ति दिनानि यापितवान् ");
INSERT INTO sandev_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","तावन्ति दिनानि ये मानवा अस्माभिः सार्द्धं तिष्ठन्ति तेषाम् एकेन जनेनास्माभिः सार्द्धं यीशोरुत्थाने साक्षिणा भवितव्यं। ");
INSERT INTO sandev_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","अतो यस्य रूढि र्युष्टो यं बर्शब्बेत्युक्त्वाहूयन्ति स यूषफ् मतथिश्च द्वावेतौ पृथक् कृत्वा त ईश्वरस्य सन्निधौ प्रार्य्य कथितवन्तः, ");
INSERT INTO sandev_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","हे सर्व्वान्तर्य्यामिन् परमेश्वर, यिहूदाः सेवनप्रेरितत्वपदच्युतः ");
INSERT INTO sandev_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","सन् निजस्थानम् अगच्छत्, तत्पदं लब्धुम् एनयो र्जनयो र्मध्ये भवता कोऽभिरुचितस्तदस्मान् दर्श्यतां। ");
INSERT INTO sandev_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ततो गुटिकापाटे कृते मतथिर्निरचीयत तस्मात् सोन्येषाम् एकादशानां प्ररितानां मध्ये गणितोभवत्। ");
INSERT INTO sandev_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","अपरञ्च निस्तारोत्सवात् परं पञ्चाशत्तमे दिने समुपस्थिते सति ते सर्व्वे एकाचित्तीभूय स्थान एकस्मिन् मिलिता आसन्। ");
INSERT INTO sandev_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","एतस्मिन्नेव समयेऽकस्माद् आकाशात् प्रचण्डात्युग्रवायोः शब्दवद् एकः शब्द आगत्य यस्मिन् गृहे त उपाविशन् तद् गृहं समस्तं व्याप्नोत्। ");
INSERT INTO sandev_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ततः परं वह्निशिखास्वरूपा जिह्वाः प्रत्यक्षीभूय विभक्ताः सत्यः प्रतिजनोर्द्ध्वे स्थगिता अभूवन्। ");
INSERT INTO sandev_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","तस्मात् सर्व्वे पवित्रेणात्मना परिपूर्णाः सन्त आत्मा यथा वाचितवान् तदनुसारेणान्यदेशीयानां भाषा उक्तवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","तस्मिन् समये पृथिवीस्थसर्व्वदेशेभ्यो यिहूदीयमतावलम्बिनो भक्तलोका यिरूशालमि प्रावसन्; ");
INSERT INTO sandev_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","तस्याः कथायाः किंवदन्त्या जातत्वात् सर्व्वे लोका मिलित्वा निजनिजभाषया शिष्याणां कथाकथनं श्रुत्वा समुद्विग्ना अभवन्। ");
INSERT INTO sandev_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","सर्व्वएव विस्मयापन्ना आश्चर्य्यान्विताश्च सन्तः परस्परं उक्तवन्तः पश्यत ये कथां कथयन्ति ते सर्व्वे गालीलीयलोकाः किं न भवन्ति? ");
INSERT INTO sandev_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","तर्हि वयं प्रत्येकशः स्वस्वजन्मदेशीयभाषाभिः कथा एतेषां शृणुमः किमिदं? ");
INSERT INTO sandev_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","पार्थी-मादी-अराम्नहरयिम्देशनिवासिमनो यिहूदा-कप्पदकिया-पन्त-आशिया- ");
INSERT INTO sandev_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","फ्रुगिया-पम्फुलिया-मिसरनिवासिनः कुरीणीनिकटवर्त्तिलूबीयप्रदेशनिवासिनो रोमनगराद् आगता यिहूदीयलोका यिहूदीयमतग्राहिणः क्रीतीया अराबीयादयो लोकाश्च ये वयम् ");
INSERT INTO sandev_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","अस्माकं निजनिजभाषाभिरेतेषाम् ईश्वरीयमहाकर्म्मव्याख्यानं शृणुमः। ");
INSERT INTO sandev_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","इत्थं ते सर्व्वएव विस्मयापन्नाः सन्दिग्धचित्ताः सन्तः परस्परमूचुः, अस्य को भावः? ");
INSERT INTO sandev_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","अपरे केचित् परिहस्य कथितवन्त एते नवीनद्राक्षारसेन मत्ता अभवन्। ");
INSERT INTO sandev_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","तदा पितर एकादशभि र्जनैः साकं तिष्ठन् ताल्लोकान् उच्चैःकारम् अवदत्, हे यिहूदीया हे यिरूशालम्निवासिनः सर्व्वे, अवधानं कृत्वा मदीयवाक्यं बुध्यध्वं। ");
INSERT INTO sandev_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","इदानीम् एकयामाद् अधिका वेला नास्ति तस्माद् यूयं यद् अनुमाथ मानवा इमे मद्यपानेन मत्तास्तन्न। ");
INSERT INTO sandev_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","किन्तु योयेल्भविष्यद्वक्त्रैतद्वाक्यमुक्तं यथा, ");
INSERT INTO sandev_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","ईश्वरः कथयामास युगान्तसमये त्वहम्। वर्षिष्यामि स्वमात्मानं सर्व्वप्राण्युपरि ध्रुवम्। भाविवाक्यं वदिष्यन्ति कन्याः पुत्राश्च वस्तुतः। प्रत्यादेशञ्च प्राप्स्यन्ति युष्माकं युवमानवाः। तथा प्राचीनलोकास्तु स्वप्नान् द्रक्ष्यन्ति निश्चितं। ");
INSERT INTO sandev_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","वर्षिष्यामि तदात्मानं दासदासीजनोपिरि। तेनैव भाविवाक्यं ते वदिष्यन्ति हि सर्व्वशः। ");
INSERT INTO sandev_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ऊर्द्ध्वस्थे गगणे चैव नीचस्थे पृथिवीतले। शोणितानि बृहद्भानून् घनधूमादिकानि च। चिह्नानि दर्शयिष्यामि महाश्चर्य्यक्रियास्तथा। ");
INSERT INTO sandev_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","महाभयानकस्यैव तद्दिनस्य परेशितुः। पुरागमाद् रविः कृष्णो रक्तश्चन्द्रो भविष्यतः। ");
INSERT INTO sandev_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","किन्तु यः परमेशस्य नाम्नि सम्प्रार्थयिष्यते। सएव मनुजो नूनं परित्रातो भविष्यति॥ ");
INSERT INTO sandev_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","अतो हे इस्रायेल्वंशीयलोकाः सर्व्वे कथायामेतस्याम् मनो निधद्ध्वं नासरतीयो यीशुरीश्वरस्य मनोनीतः पुमान् एतद् ईश्वरस्तत्कृतैराश्चर्य्याद्भुतकर्म्मभि र्लक्षणैश्च युष्माकं साक्षादेव प्रतिपादितवान् इति यूयं जानीथ। ");
INSERT INTO sandev_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","तस्मिन् यीशौ ईश्वरस्य पूर्व्वनिश्चितमन्त्रणानिरूपणानुसारेण मृत्यौ समर्पिते सति यूयं तं धृत्वा दुष्टलोकानां हस्तैः क्रुशे विधित्वाहत। ");
INSERT INTO sandev_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","किन्त्वीश्वरस्तं निधनस्य बन्धनान्मोचयित्वा उदस्थापयत् यतः स मृत्युना बद्धस्तिष्ठतीति न सम्भवति। ");
INSERT INTO sandev_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","एतस्तिन् दायूदपि कथितवान् यथा, सर्व्वदा मम साक्षात्तं स्थापय परमेश्वरं। स्थिते मद्दक्षिणे तस्मिन् स्खलिष्यामि त्वहं नहि। ");
INSERT INTO sandev_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","आनन्दिष्यति तद्धेतो र्मामकीनं मनस्तु वै। आह्लादिष्यति जिह्वापि मदीया तु तथैव च। प्रत्याशया शरीरन्तु मदीयं वैशयिष्यते। ");
INSERT INTO sandev_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","परलोके यतो हेतोस्त्वं मां नैव हि त्यक्ष्यसि। स्वकीयं पुण्यवन्तं त्वं क्षयितुं नैव दास्यसि। एवं जीवनमार्गं त्वं मामेव दर्शयिष्यसि। ");
INSERT INTO sandev_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","स्वसम्मुखे य आनन्दो दक्षिणे स्वस्य यत् सुखं। अनन्तं तेन मां पूर्णं करिष्यसि न संशयः॥ ");
INSERT INTO sandev_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","हे भ्रातरोऽस्माकं तस्य पूर्व्वपुरुषस्य दायूदः कथां स्पष्टं कथयितुं माम् अनुमन्यध्वं, स प्राणान् त्यक्त्वा श्मशाने स्थापितोभवद् अद्यापि तत् श्मशानम् अस्माकं सन्निधौ विद्यते। ");
INSERT INTO sandev_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","फलतो लौकिकभावेन दायूदो वंशे ख्रीष्टं जन्म ग्राहयित्वा तस्यैव सिंहासने समुवेष्टुं तमुत्थापयिष्यति परमेश्वरः शपथं कुत्वा दायूदः समीप इमम् अङ्गीकारं कृतवान्, ");
INSERT INTO sandev_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","इति ज्ञात्वा दायूद् भविष्यद्वादी सन् भविष्यत्कालीयज्ञानेन ख्रीष्टोत्थाने कथामिमां कथयामास यथा तस्यात्मा परलोके न त्यक्ष्यते तस्य शरीरञ्च न क्षेष्यति; ");
INSERT INTO sandev_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","अतः परमेश्वर एनं यीशुं श्मशानाद् उदस्थापयत् तत्र वयं सर्व्वे साक्षिण आस्महे। ");
INSERT INTO sandev_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","स ईश्वरस्य दक्षिणकरेणोन्नतिं प्राप्य पवित्र आत्मिन पिता यमङ्गीकारं कृतवान् तस्य फलं प्राप्य यत् पश्यथ शृणुथ च तदवर्षत्। ");
INSERT INTO sandev_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","यतो दायूद् स्वर्गं नारुरोह किन्तु स्वयम् इमां कथाम् अकथयद् यथा, मम प्रभुमिदं वाक्यमवदत् परमेश्वरः। ");
INSERT INTO sandev_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","तव शत्रूनहं यावत् पादपीठं करोमि न। तावत् कालं मदीये त्वं दक्षवार्श्व उपाविश। ");
INSERT INTO sandev_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","अतो यं यीशुं यूयं क्रुशेऽहत परमेश्वरस्तं प्रभुत्वाभिषिक्तत्वपदे न्ययुंक्तेति इस्रायेलीया लोका निश्चितं जानन्तु। ");
INSERT INTO sandev_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","एतादृशीं कथां श्रुत्वा तेषां हृदयानां विदीर्णत्वात् ते पितराय तदन्यप्रेरितेभ्यश्च कथितवन्तः, हे भ्रातृगण वयं किं करिष्यामः? ");
INSERT INTO sandev_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","ततः पितरः प्रत्यवदद् यूयं सर्व्वे स्वं स्वं मनः परिवर्त्तयध्वं तथा पापमोचनार्थं यीशुख्रीष्टस्य नाम्ना मज्जिताश्च भवत, तस्माद् दानरूपं परित्रम् आत्मानं लप्स्यथ। ");
INSERT INTO sandev_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","यतो युष्माकं युष्मत्सन्तानानाञ्च दूरस्थसर्व्वलोकानाञ्च निमित्तम् अर्थाद् अस्माकं प्रभुः परमेश्वरो यावतो लाकान् आह्वास्यति तेषां सर्व्वेषां निमित्तम् अयमङ्गीकार आस्ते। ");
INSERT INTO sandev_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","एतदन्याभि र्बहुकथाभिः प्रमाणं दत्वाकथयत् एतेभ्यो विपथगामिभ्यो वर्त्तमानलोकेभ्यः स्वान् रक्षत। ");
INSERT INTO sandev_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","ततः परं ये सानन्दास्तां कथाम् अगृह्लन् ते मज्जिता अभवन्। तस्मिन् दिवसे प्रायेण त्रीणि सहस्राणि लोकास्तेषां सपक्षाः सन्तः ");
INSERT INTO sandev_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","प्रेरितानाम् उपदेशे सङ्गतौ पूपभञ्जने प्रार्थनासु च मनःसंयोगं कृत्वातिष्ठन्। ");
INSERT INTO sandev_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","प्रेरितै र्नानाप्रकारलक्षणेषु महाश्चर्य्यकर्ममसु च दर्शितेषु सर्व्वलोकानां भयमुपस्थितं। ");
INSERT INTO sandev_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","विश्वासकारिणः सर्व्व च सह तिष्ठनतः। स्वेषां सर्व्वाः सम्पत्तीः साधारण्येन स्थापयित्वाभुञ्जत। ");
INSERT INTO sandev_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","फलतो गृहाणि द्रव्याणि च सर्व्वाणि विक्रीय सर्व्वेषां स्वस्वप्रयोजनानुसारेण विभज्य सर्व्वेभ्योऽददन्। ");
INSERT INTO sandev_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","सर्व्व एकचित्तीभूय दिने दिने मन्दिरे सन्तिष्ठमाना गृहे गृहे च पूपानभञ्जन्त ईश्वरस्य धन्यवादं कुर्व्वन्तो लोकैः समादृताः परमानन्देन सरलान्तःकरणेन भोजनं पानञ्चकुर्व्वन्। ");
INSERT INTO sandev_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","परमेश्वरो दिने दिने परित्राणभाजनै र्मण्डलीम् अवर्द्धयत्। ");
INSERT INTO sandev_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","तृतीययामवेलायां सत्यां प्रार्थनायाः समये पितरयोहनौ सम्भूय मन्दिरं गच्छतः। ");
INSERT INTO sandev_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","तस्मिन्नेव समये मन्दिरप्रवेशकानां समीपे भिक्षारणार्थं यं जन्मखञ्जमानुषं लोका मन्दिरस्य सुन्दरनाम्नि द्वारे प्रतिदिनम् अस्थापयन् तं वहन्तस्तद्वारं आनयन्। ");
INSERT INTO sandev_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","तदा पितरयोहनौ मन्तिरं प्रवेष्टुम् उद्यतौ विलोक्य स खञ्जस्तौ किञ्चिद् भिक्षितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","तस्माद् योहना सहितः पितरस्तम् अनन्यदृष्ट्या निरीक्ष्य प्रोक्तवान् आवां प्रति दृष्टिं कुरु। ");
INSERT INTO sandev_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ततः स किञ्चित् प्राप्त्याशया तौ प्रति दृष्टिं कृतवान्। ");
INSERT INTO sandev_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","तदा पितरो गदितवान् मम निकटे स्वर्णरूप्यादि किमपि नास्ति किन्तु यदास्ते तद् ददामि नासरतीयस्य यीशुख्रीष्टस्य नाम्ना त्वमुत्थाय गमनागमने कुरु। ");
INSERT INTO sandev_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ततः परं स तस्य दक्षिणकरं धृत्वा तम् उदतोलयत्; तेन तत्क्षणात् तस्य जनस्य पादगुल्फयोः सबलत्वात् स उल्लम्फ्य प्रोत्थाय गमनागमने ऽकरोत्। ");
INSERT INTO sandev_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ततो गमनागमने कुर्व्वन् उल्लम्फन् ईश्वरं धन्यं वदन् ताभ्यां सार्द्धं मन्दिरं प्राविशत्। ");
INSERT INTO sandev_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ततः सर्व्वे लोकास्तं गमनागमने कुर्व्वन्तम् ईश्वरं धन्यं वदन्तञ्च विलोक्य ");
INSERT INTO sandev_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","मन्दिरस्य सुन्दरे द्वारे य उपविश्य भिक्षितवान् सएवायम् इति ज्ञात्वा तं प्रति तया घटनया चमत्कृता विस्मयापन्नाश्चाभवन्। ");
INSERT INTO sandev_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","यः खञ्जः स्वस्थोभवत् तेन पितरयोहनोः करयोर्ध्टतयोः सतोः सर्व्वे लोका सन्निधिम् आगच्छन्। ");
INSERT INTO sandev_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","तद् दृष्ट्वा पितरस्तेभ्योऽकथयत्, हे इस्रायेलीयलोका यूयं कुतो ऽनेनाश्चर्य्यं मन्यध्वे? आवां निजशक्त्या यद्वा निजपुण्येन खञ्जमनुष्यमेनं गमितवन्ताविति चिन्तयित्वा आवां प्रति कुतोऽनन्यदृष्टिं कुरुथ? ");
INSERT INTO sandev_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","यं यीशुं यूयं परकरेषु समार्पयत ततो यं पीलातो मोचयितुम् एैच्छत् तथापि यूयं तस्य साक्षान् नाङ्गीकृतवन्त इब्राहीम इस्हाको याकूबश्चेश्वरोऽर्थाद् अस्माकं पूर्व्वपुरुषाणाम् ईश्वरः स्वपुत्रस्य तस्य यीशो र्महिमानं प्राकाशयत्। ");
INSERT INTO sandev_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","किन्तु यूयं तं पवित्रं धार्म्मिकं पुमांसं नाङ्गीकृत्य हत्याकारिणमेकं स्वेभ्यो दातुम् अयाचध्वं। ");
INSERT INTO sandev_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","पश्चात् तं जीवनस्याधिपतिम् अहत किन्त्वीश्वरः श्मशानात् तम् उदस्थापयत तत्र वयं साक्षिण आस्महे। ");
INSERT INTO sandev_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","इमं यं मानुषं यूयं पश्यथ परिचिनुथ च स तस्य नाम्नि विश्वासकरणात् चलनशक्तिं लब्धवान् तस्मिन् तस्य यो विश्वासः स तं युष्माकं सर्व्वेषां साक्षात् सम्पूर्णरूपेण स्वस्थम् अकार्षीत्। ");
INSERT INTO sandev_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","हे भ्रातरो यूयं युष्माकम् अधिपतयश्च अज्ञात्वा कर्म्माण्येतानि कृतवन्त इदानीं ममैष बोधो जायते। ");
INSERT INTO sandev_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","किन्त्वीश्वरः ख्रीष्टस्य दुःखभोगे भविष्यद्वादिनां मुखेभ्यो यां यां कथां पूर्व्वमकथयत् ताः कथा इत्थं सिद्धा अकरोत्। ");
INSERT INTO sandev_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","अतः स्वेषां पापमोचनार्थं खेदं कृत्वा मनांसि परिवर्त्तयध्वं, तस्माद् ईश्वरात् सान्त्वनाप्राप्तेः समय उपस्थास्यति; ");
INSERT INTO sandev_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","पुनश्च पूर्व्वकालम् आरभ्य प्रचारितो यो यीशुख्रीष्टस्तम् ईश्वरो युष्मान् प्रति प्रेषयिष्यति। ");
INSERT INTO sandev_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","किन्तु जगतः सृष्टिमारभ्य ईश्वरो निजपवित्रभविष्यद्वादिगणोन यथा कथितवान् तदनुसारेण सर्व्वेषां कार्य्याणां सिद्धिपर्य्यन्तं तेन स्वर्गे वासः कर्त्तव्यः। ");
INSERT INTO sandev_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","युष्माकं प्रभुः परमेश्वरो युष्माकं भ्रातृगणमध्यात् मत्सदृशं भविष्यद्वक्तारम् उत्पादयिष्यति, ततः स यत् किञ्चित् कथयिष्यति तत्र यूयं मनांसि निधद्ध्वं। ");
INSERT INTO sandev_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","किन्तु यः कश्चित् प्राणी तस्य भविष्यद्वादिनः कथां न ग्रहीष्यति स निजलोकानां मध्याद् उच्छेत्स्यते,\" इमां कथाम् अस्माकं पूर्व्वपुरुषेभ्यः केवलो मूसाः कथयामास इति नहि, ");
INSERT INTO sandev_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","शिमूयेल्भविष्यद्वादिनम् आरभ्य यावन्तो भविष्यद्वाक्यम् अकथयन् ते सर्व्वएव समयस्यैतस्य कथाम् अकथयन्। ");
INSERT INTO sandev_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","यूयमपि तेषां भविष्यद्वादिनां सन्तानाः, \"तव वंशोद्भवपुंसा सर्व्वदेशीया लोका आशिषं प्राप्ता भविष्यन्ति\", इब्राहीमे कथामेतां कथयित्वा ईश्वरोस्माकं पूर्व्वपुरुषैः सार्द्धं यं नियमं स्थिरीकृतवान् तस्य नियमस्याधिकारिणोपि यूयं भवथ। ");
INSERT INTO sandev_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","अत ईश्वरो निजपुत्रं यीशुम् उत्थाप्य युष्माकं सर्व्वेषां स्वस्वपापात् परावर्त्त्य युष्मभ्यम् आशिषं दातुं प्रथमतस्तं युष्माकं निकटं प्रेषितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","यस्मिन् समये पितरयोहनौ लोकान् उपदिशतस्तस्मिन् समये याजका मन्दिरस्य सेनापतयः सिदूकीगणश्च ");
INSERT INTO sandev_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","तयोर् उपदेशकरणे ख्रीष्टस्योत्थानम् उपलक्ष्य सर्व्वेषां मृतानाम् उत्थानप्रस्तावे च व्यग्राः सन्तस्तावुपागमन्। ");
INSERT INTO sandev_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","तौ धृत्वा दिनावसानकारणात् परदिनपर्य्यनन्तं रुद्ध्वा स्थापितवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","तथापि ये लोकास्तयोरुपदेशम् अशृण्वन् तेषां प्रायेण पञ्चसहस्राणि जना व्यश्वसन्। ");
INSERT INTO sandev_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","परेऽहनि अधिपतयः प्राचीना अध्यापकाश्च हानननामा महायाजकः ");
INSERT INTO sandev_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","कियफा योहन् सिकन्दर इत्यादयो महायाजकस्य ज्ञातयः सर्व्वे यिरूशालम्नगरे मिलिताः। ");
INSERT INTO sandev_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","अनन्तरं प्रेरितौ मध्ये स्थापयित्वापृच्छन् युवां कया शक्तया वा केन नाम्ना कर्म्माण्येतानि कुरुथः? ");
INSERT INTO sandev_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","तदा पितरः पवित्रेणात्मना परिपूर्णः सन् प्रत्यवादीत्, हे लोकानाम् अधिपतिगण हे इस्रायेलीयप्राचीनाः, ");
INSERT INTO sandev_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","एतस्य दुर्ब्बलमानुषस्य हितं यत् कर्म्माक्रियत, अर्थात्, स येन प्रकारेण स्वस्थोभवत् तच्चेद् अद्यावां पृच्छथ, ");
INSERT INTO sandev_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","तर्हि सर्व्व इस्रायेेलीयलोका यूयं जानीत नासरतीयो यो यीशुख्रीष्टः क्रुशे युष्माभिरविध्यत यश्चेश्वरेण श्मशानाद् उत्थापितः, तस्य नाम्ना जनोयं स्वस्थः सन् युष्माकं सम्मुखे प्रोत्तिष्ठति। ");
INSERT INTO sandev_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","निचेतृभि र्युष्माभिरयं यः प्रस्तरोऽवज्ञातोऽभवत् स प्रधानकोणस्य प्रस्तरोऽभवत्। ");
INSERT INTO sandev_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","तद्भिन्नादपरात् कस्मादपि परित्राणं भवितुं न शक्नोति, येन त्राणं प्राप्येत भूमण्डलस्यलोकानां मध्ये तादृशं किमपि नाम नास्ति। ");
INSERT INTO sandev_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","तदा पितरयोहनोरेतादृशीम् अक्षेभतां दृष्ट्वा तावविद्वांसौ नीचलोकाविति बुद्ध्वा आश्चर्य्यम् अमन्यन्त तौ च यीशोः सङ्गिनौ जाताविति ज्ञातुम् अशक्नुवन्। ");
INSERT INTO sandev_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","किन्तु ताभ्यां सार्द्धं तं स्वस्थमानुषं तिष्ठन्तं दृष्ट्वा ते कामप्यपराम् आपत्तिं कर्त्तं नाशक्नुन्। ");
INSERT INTO sandev_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","तदा ते सभातः स्थानान्तरं गन्तुं तान् आज्ञाप्य स्वयं परस्परम् इति मन्त्रणामकुर्व्वन् ");
INSERT INTO sandev_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","तौ मानवौ प्रति किं कर्त्तव्यं? तावेकं प्रसिद्धम् आश्चर्य्यं कर्म्म कृतवन्तौ तद् यिरूशालम्निवासिनां सर्व्वेषां लोकानां समीपे प्राकाशत तच्च वयमपह्नोतुं न शक्नुमः। ");
INSERT INTO sandev_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","किन्तु लोकानां मध्यम् एतद् यथा न व्याप्नोति तदर्थं तौ भयं प्रदर्श्य तेन नाम्ना कमपि मनुष्यं नोपदिशतम् इति दृढं निषेधामः। ");
INSERT INTO sandev_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","ततस्ते प्रेरितावाहूय एतदाज्ञापयन् इतः परं यीशो र्नाम्ना कदापि कामपि कथां मा कथयतं किमपि नोपदिशञ्च। ");
INSERT INTO sandev_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","ततः पितरयोहनौ प्रत्यवदताम् ईश्वरस्याज्ञाग्रहणं वा युष्माकम् आज्ञाग्रहणम् एतयो र्मध्ये ईश्वरस्य गोचरे किं विहितं? यूयं तस्य विवेचनां कुरुत। ");
INSERT INTO sandev_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","वयं यद् अपश्याम यदशृणुम च तन्न प्रचारयिष्याम एतत् कदापि भवितुं न शक्नोति। ");
INSERT INTO sandev_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","यदघटत तद् दृष्टा सर्व्वे लोका ईश्वरस्य गुणान् अन्ववदन् तस्मात् लोकभयात् तौ दण्डयितुं कमप्युपायं न प्राप्य ते पुनरपि तर्जयित्वा तावत्यजन्। ");
INSERT INTO sandev_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","यस्य मानुषस्यैतत् स्वास्थ्यकरणम् आश्चर्य्यं कर्म्माक्रियत तस्य वयश्चत्वारिंशद्वत्सरा व्यतीताः। ");
INSERT INTO sandev_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","ततः परं तौ विसृष्टौ सन्तौ स्वसङ्गिनां सन्निधिं गत्वा प्रधानयाजकैः प्राचीनलोकैश्च प्रोक्ताः सर्व्वाः कथा ज्ञापितवन्तौ। ");
INSERT INTO sandev_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","तच्छ्रुत्वा सर्व्व एकचित्तीभूय ईश्वरमुद्दिश्य प्रोच्चैरेतत् प्रार्थयन्त, हे प्रभो गगणपृथिवीपयोधीनां तेषु च यद्यद् आस्ते तेषां स्रष्टेश्वरस्त्वं। ");
INSERT INTO sandev_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","त्वं निजसेवकेन दायूदा वाक्यमिदम् उवचिथ, मनुष्या अन्यदेशीयाः कुर्व्वन्ति कलहं कुतः। लोकाः सर्व्वे किमर्थं वा चिन्तां कुर्व्वन्ति निष्फलां। ");
INSERT INTO sandev_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","परमेशस्य तेनैवाभिषिक्तस्य जनस्य च। विरुद्धमभितिष्ठन्ति पृथिव्याः पतयः कुतः॥ ");
INSERT INTO sandev_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","फलतस्तव हस्तेन मन्त्रणया च पूर्व्व यद्यत् स्थिरीकृतं तद् यथा सिद्धं भवति तदर्थं त्वं यम् अथिषिक्तवान् स एव पवित्रो यीशुस्तस्य प्रातिकूल्येन हेरोद् पन्तीयपीलातो ");
INSERT INTO sandev_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ऽन्यदेशीयलोका इस्रायेल्लोकाश्च सर्व्व एते सभायाम् अतिष्ठन्। ");
INSERT INTO sandev_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","हे परमेश्वर अधुना तेषां तर्जनं गर्जनञ्च शृणु; ");
INSERT INTO sandev_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","तथा स्वास्थ्यकरणकर्म्मणा तव बाहुबलप्रकाशपूर्व्वकं तव सेवकान् निर्भयेन तव वाक्यं प्रचारयितुं तव पवित्रपुत्रस्य यीशो र्नाम्ना आश्चर्य्याण्यसम्भवानि च कर्म्माणि कर्त्तुञ्चाज्ञापय। ");
INSERT INTO sandev_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","इत्थं प्रार्थनया यत्र स्थाने ते सभायाम् आसन् तत् स्थानं प्राकम्पत; ततः सर्व्वे पवित्रेणात्मना परिपूर्णाः सन्त ईश्वरस्य कथाम् अक्षोभेण प्राचारयन्। ");
INSERT INTO sandev_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","अपरञ्च प्रत्ययकारिलोकसमूहा एकमनस एकचित्तीभूय स्थिताः। तेषां केपि निजसम्पत्तिं स्वीयां नाजानन् किन्तु तेषां सर्व्वाः सम्पत्त्यः साधारण्येन स्थिताः। ");
INSERT INTO sandev_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","अन्यच्च प्रेरिता महाशक्तिप्रकाशपूर्व्वकं प्रभो र्यीशोरुत्थाने साक्ष्यम् अददुः, तेषु सर्व्वेषु महानुग्रहोऽभवच्च। ");
INSERT INTO sandev_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","तेषां मध्ये कस्यापि द्रव्यन्यूनता नाभवद् यतस्तेषां गृहभूम्याद्या याः सम्पत्तय आसन् ता विक्रीय ");
INSERT INTO sandev_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","तन्मूल्यमानीय प्रेरितानां चरणेषु तैः स्थापितं; ततः प्रत्येकशः प्रयोजनानुसारेण दत्तमभवत्। ");
INSERT INTO sandev_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","विशेषतः कुप्रोपद्वीपीयो योसिनामको लेविवंशजात एको जनो भूम्यधिकारी, यं प्रेरिता बर्णब्बा अर्थात् सान्त्वनादायक इत्युक्त्वा समाहूयन्, ");
INSERT INTO sandev_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","स जनो निजभूमिं विक्रीय तन्मूल्यमानीय प्रेरितानां चरणेषु स्थापितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","तदा अनानियनामक एको जनो यस्य भार्य्याया नाम सफीरा स स्वाधिकारं विक्रीय ");
INSERT INTO sandev_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","स्वभार्य्यां ज्ञापयित्वा तन्मूल्यस्यैकांशं सङ्गोप्य स्थापयित्वा तदन्यांशमात्रमानीय प्रेरितानां चरणेषु समर्पितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","तस्मात् पितरोकथयत् हे अनानिय भूमे र्मूल्यं किञ्चित् सङ्गोप्य स्थापयितुं पवित्रस्यात्मनः सन्निधौ मृषावाक्यं कथयितुञ्च शैतान् कुतस्तवान्तःकरणे प्रवृत्तिमजनयत्? ");
INSERT INTO sandev_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","सा भूमि र्यदा तव हस्तगता तदा किं तव स्वीया नासीत्? तर्हि स्वान्तःकरणे कुत एतादृशी कुकल्पना त्वया कृता? त्वं केवलमनुष्यस्य निकटे मृषावाक्यं नावादीः किन्त्वीश्वरस्य निकटेऽपि। ");
INSERT INTO sandev_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","एतां कथां श्रुत्वैव सोऽनानियो भूमौ पतन् प्राणान् अत्यजत्, तद्वृत्तान्तं यावन्तो लोका अशृण्वन् तेषां सर्व्वेषां महाभयम् अजायत्। ");
INSERT INTO sandev_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","तदा युवलोकास्तं वस्त्रेणाच्छाद्य बहि र्नीत्वा श्मशानेऽस्थापयन्। ");
INSERT INTO sandev_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","ततः प्रहरैकानन्तरं किं वृत्तं तन्नावगत्य तस्य भार्य्यापि तत्र समुपस्थिता। ");
INSERT INTO sandev_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ततः पितरस्ताम् अपृच्छत्, युवाभ्याम् एतावन्मुद्राभ्यो भूमि र्विक्रीता न वा? एतत्वं वद; तदा सा प्रत्यवादीत् सत्यम् एतावद्भ्यो मुद्राभ्य एव। ");
INSERT INTO sandev_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ततः पितरोकथयत् युवां कथं परमेश्वरस्यात्मानं परीक्षितुम् एकमन्त्रणावभवतां? पश्य ये तव पतिं श्मशाने स्थापितवन्तस्ते द्वारस्य समीपे समुपतिष्ठन्ति त्वामपि बहिर्नेष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","ततः सापि तस्य चरणसन्निधौ पतित्वा प्राणान् अत्याक्षीत्। पश्चात् ते युवानोऽभ्यन्तरम् आगत्य तामपि मृतां दृष्ट्वा बहि र्नीत्वा तस्याः पत्युः पार्श्वे श्मशाने स्थापितवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","तस्मात् मण्डल्याः सर्व्वे लोका अन्यलोकाश्च तां वार्त्तां श्रुत्वा साध्वसं गताः। ");
INSERT INTO sandev_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","ततः परं प्रेरितानां हस्तै र्लोकानां मध्ये बह्वाश्चर्य्याण्यद्भुतानि कर्म्माण्यक्रियन्त; तदा शिष्याः सर्व्व एकचित्तीभूय सुलेमानो ऽलिन्दे सम्भूयासन्। ");
INSERT INTO sandev_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","तेषां सङ्घान्तर्गो भवितुं कोपि प्रगल्भतां नागमत् किन्तु लोकास्तान् समाद्रियन्त। ");
INSERT INTO sandev_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","स्त्रियः पुरुषाश्च बहवो लोका विश्वास्य प्रभुं शरणमापन्नाः। ");
INSERT INTO sandev_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","पितरस्य गमनागमनाभ्यां केनापि प्रकारेण तस्य छाया कस्मिंश्चिज्जने लगिष्यतीत्याशया लोका रोगिणः शिविकया खट्वया चानीय पथि पथि स्थापितवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","चतुर्दिक्स्थनगरेभ्यो बहवो लोकाः सम्भूय रोगिणोऽपवित्रभुतग्रस्तांश्च यिरूशालमम् आनयन् ततः सर्व्वे स्वस्था अक्रियन्त। ");
INSERT INTO sandev_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","अनन्तरं महायाजकः सिदूकिनां मतग्राहिणस्तेषां सहचराश्च ");
INSERT INTO sandev_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","महाक्रोधान्त्विताः सन्तः प्रेरितान् धृत्वा नीचलोकानां कारायां बद्ध्वा स्थापितवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","किन्तु रात्रौ परमेश्वरस्य दूतः काराया द्वारं मोचयित्वा तान् बहिरानीयाकथयत्, ");
INSERT INTO sandev_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","यूयं गत्वा मन्दिरे दण्डायमानाः सन्तो लोकान् प्रतीमां जीवनदायिकां सर्व्वां कथां प्रचारयत। ");
INSERT INTO sandev_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","इति श्रुत्वा ते प्रत्यूषे मन्दिर उपस्थाय उपदिष्टवन्तः। तदा सहचरगणेन सहितो महायाजक आगत्य मन्त्रिगणम् इस्रायेल्वंशस्य सर्व्वान् राजसभासदः सभास्थान् कृत्वा कारायास्तान् आपयितुं पदातिगणं प्रेरितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","ततस्ते गत्वा कारायां तान् अप्राप्य प्रत्यागत्य इति वार्त्ताम् अवादिषुः, ");
INSERT INTO sandev_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","वयं तत्र गत्वा निर्व्विघ्नं काराया द्वारं रुद्धं रक्षकांश्च द्वारस्य बहिर्दण्डायमानान् अदर्शाम एव किन्तु द्वारं मोचयित्वा तन्मध्ये कमपि द्रष्टुं न प्राप्ताः। ");
INSERT INTO sandev_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","एतां कथां श्रुत्वा महायाजको मन्दिरस्य सेनापतिः प्रधानयाजकाश्च, इत परं किमपरं भविष्यतीति चिन्तयित्वा सन्दिग्धचित्ता अभवन्। ");
INSERT INTO sandev_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","एतस्मिन्नेव समये कश्चित् जन आगत्य वार्त्तामेताम् अवदत् पश्यत यूयं यान् मानवान् कारायाम् अस्थापयत ते मन्दिरे तिष्ठन्तो लोकान् उपदिशन्ति। ");
INSERT INTO sandev_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","तदा मन्दिरस्य सेनापतिः पदातयश्च तत्र गत्वा चेल्लोकाः पाषाणान् निक्षिप्यास्मान् मारयन्तीति भिया विनत्याचारं तान् आनयन्। ");
INSERT INTO sandev_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","ते महासभाया मध्ये तान् अस्थापयन् ततः परं महायाजकस्तान् अपृच्छत्, ");
INSERT INTO sandev_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","अनेन नाम्ना समुपदेष्टुं वयं किं दृढं न न्यषेधाम? तथापि पश्यत यूयं स्वेषां तेनोपदेशेने यिरूशालमं परिपूर्णं कृत्वा तस्य जनस्य रक्तपातजनितापराधम् अस्मान् प्रत्यानेतुं चेष्टध्वे। ");
INSERT INTO sandev_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","ततः पितरोन्यप्रेरिताश्च प्रत्यवदन् मानुषस्याज्ञाग्रहणाद् ईश्वरस्याज्ञाग्रहणम् अस्माकमुचितम्। ");
INSERT INTO sandev_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","यं यीशुं यूयं क्रुशे वेधित्वाहत तम् अस्माकं पैतृक ईश्वर उत्थाप्य ");
INSERT INTO sandev_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","इस्रायेल्वंशानां मनःपरिवर्त्तनं पापक्षमाञ्च कर्त्तुं राजानं परित्रातारञ्च कृत्वा स्वदक्षिणपार्श्वे तस्यान्नतिम् अकरोत्। ");
INSERT INTO sandev_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","एतस्मिन् वयमपि साक्षिण आस्महे, तत् केवलं नहि, ईश्वर आज्ञाग्राहिभ्यो यं पवित्रम् आत्मनं दत्तवान् सोपि साक्ष्यस्ति। ");
INSERT INTO sandev_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","एतद्वाक्ये श्रुते तेषां हृदयानि विद्धान्यभवन् ततस्ते तान् हन्तुं मन्त्रितवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","एतस्मिन्नेव समये तत्सभास्थानां सर्व्वलोकानां मध्ये सुख्यातो गमिलीयेल्नामक एको जनो व्यवस्थापकः फिरूशिलोक उत्थाय प्रेरितान् क्षणार्थं स्थानान्तरं गन्तुम् आदिश्य कथितवान्, ");
INSERT INTO sandev_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","हे इस्रायेल्वंशीयाः सर्व्वे यूयम् एतान् मानुषान् प्रति यत् कर्त्तुम् उद्यतास्तस्मिन् सावधाना भवत। ");
INSERT INTO sandev_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","इतः पूर्व्वं थूदानामैको जन उपस्थाय स्वं कमपि महापुरुषम् अवदत्, ततः प्रायेण चतुःशतलोकास्तस्य मतग्राहिणोभवन् पश्चात् स हतोभवत् तस्याज्ञाग्राहिणो यावन्तो लोकास्ते सर्व्वे विर्कीर्णाः सन्तो ऽकृतकार्य्या अभवन्। ");
INSERT INTO sandev_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","तस्माज्जनात् परं नामलेखनसमये गालीलीययिहूदानामैको जन उपस्थाय बहूल्लोकान् स्वमतं ग्राहीतवान् ततः सोपि व्यनश्यत् तस्याज्ञाग्राहिणो यावन्तो लोका आसन् ते सर्व्वे विकीर्णा अभवन्। ");
INSERT INTO sandev_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","अधुना वदामि, यूयम् एतान् मनुष्यान् प्रति किमपि न कृत्वा क्षान्ता भवत, यत एष सङ्कल्प एतत् कर्म्म च यदि मनुष्यादभवत् तर्हि विफलं भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","यदीश्वरादभवत् तर्हि यूयं तस्यान्यथा कर्त्तुं न शक्ष्यथ, वरम् ईश्वररोधका भविष्यथ। ");
INSERT INTO sandev_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","तदा तस्य मन्त्रणां स्वीकृत्य ते प्रेरितान् आहूय प्रहृत्य यीशो र्नाम्ना कामपि कथां कथयितुं निषिध्य व्यसर्जन्। ");
INSERT INTO sandev_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","किन्तु तस्य नामार्थं वयं लज्जाभोगस्य योग्यत्वेन गणिता इत्यत्र ते सानन्दाः सन्तः सभास्थानां साक्षाद् अगच्छन्। ");
INSERT INTO sandev_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ततः परं प्रतिदिनं मन्दिरे गृहे गृहे चाविश्रामम् उपदिश्य यीशुख्रीष्टस्य सुसंवादं प्रचारितवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","तस्मिन् समये शिष्याणां बाहुल्यात् प्रात्यहिकदानस्य विश्राणनै र्भिन्नदेशीयानां विधवास्त्रीगण उपेक्षिते सति इब्रीयलोकैः सहान्यदेशीयानां विवाद उपातिष्ठत्। ");
INSERT INTO sandev_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","तदा द्वादशप्रेरिताः सर्व्वान् शिष्यान् संगृह्याकथयन् ईश्वरस्य कथाप्रचारं परित्यज्य भोजनगवेषणम् अस्माकम् उचितं नहि। ");
INSERT INTO sandev_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","अतो हे भ्रातृगण वयम् एतत्कर्म्मणो भारं येभ्यो दातुं शक्नुम एतादृशान् सुख्यात्यापन्नान् पवित्रेणात्मना ज्ञानेन च पूर्णान् सप्प्रजनान् यूयं स्वेषां मध्ये मनोनीतान् कुरुत, ");
INSERT INTO sandev_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","किन्तु वयं प्रार्थनायां कथाप्रचारकर्म्मणि च नित्यप्रवृत्ताः स्थास्यामः। ");
INSERT INTO sandev_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","एतस्यां कथायां सर्व्वे लोकाः सन्तुष्टाः सन्तः स्वेषां मध्यात् स्तिफानः फिलिपः प्रखरो निकानोर् तीमन् पर्म्मिणा यिहूदिमतग्राही-आन्तियखियानगरीयो निकला एतान् परमभक्तान् पवित्रेणात्मना परिपूर्णान् सप्त जनान् ");
INSERT INTO sandev_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","प्रेरितानां समक्षम् आनयन्, ततस्ते प्रार्थनां कृत्वा तेषां शिरःसु हस्तान् आर्पयन्। ");
INSERT INTO sandev_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","अपरञ्च ईश्वरस्य कथा देशं व्याप्नोत् विशेषतो यिरूशालमि नगरे शिष्याणां संख्या प्रभूतरूपेणावर्द्धत याजकानां मध्येपि बहवः ख्रीष्टमतग्राहिणोऽभवन्। ");
INSERT INTO sandev_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","स्तिफानोे विश्वासेन पराक्रमेण च परिपूर्णः सन् लोकानां मध्ये बहुविधम् अद्भुतम् आश्चर्य्यं कर्म्माकरोत्। ");
INSERT INTO sandev_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","तेन लिबर्त्तिनीयनाम्ना विख्यातसङ्घस्य कतिपयजनाः कुरीणीयसिकन्दरीय-किलिकीयाशीयादेशीयाः कियन्तो जनाश्चोत्थाय स्तिफानेन सार्द्धं व्यवदन्त। ");
INSERT INTO sandev_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","किन्तु स्तिफानो ज्ञानेन पवित्रेणात्मना च ईदृशीं कथां कथितवान् यस्यास्ते आपत्तिं कर्त्तुं नाशक्नुवन्। ");
INSERT INTO sandev_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","पश्चात् तै र्लोभिताः कतिपयजनाः कथामेनाम् अकथयन्, वयं तस्य मुखतो मूसा ईश्वरस्य च निन्दावाक्यम् अश्रौष्म। ");
INSERT INTO sandev_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","ते लोकानां लोकप्राचीनानाम् अध्यापकानाञ्च प्रवृत्तिं जनयित्वा स्तिफानस्य सन्निधिम् आगत्य तं धृत्वा महासभामध्यम् आनयन्। ");
INSERT INTO sandev_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","तदनन्तरं कतिपयजनेषु मिथ्यासाक्षिषु समानीतेषु तेऽकथयन् एष जन एतत्पुण्यस्थानव्यवस्थयो र्निन्दातः कदापि न निवर्त्तते। ");
INSERT INTO sandev_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","फलतो नासरतीययीशुः स्थानमेतद् उच्छिन्नं करिष्यति मूसासमर्पितम् अस्माकं व्यवहरणम् अन्यरूपं करिष्यति तस्यैतादृशीं कथां वयम् अशृणुम। ");
INSERT INTO sandev_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","तदा महासभास्थाः सर्व्वे तं प्रति स्थिरां दृष्टिं कृत्वा स्वर्गदूतमुखसदृशं तस्य मुखम् अपश्यन्। ");
INSERT INTO sandev_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ततः परं महायाजकः पृष्टवान्, एषा कथां किं सत्या? ");
INSERT INTO sandev_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","ततः स प्रत्यवदत्, हे पितरो हे भ्रातरः सर्व्वे लाका मनांसि निधद्ध्वं।अस्माकं पूर्व्वपुरुष इब्राहीम् हारण्नगरे वासकरणात् पूर्व्वं यदा अराम्-नहरयिमदेशे आसीत् तदा तेजोमय ईश्वरो दर्शनं दत्वा ");
INSERT INTO sandev_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","तमवदत् त्वं स्वदेशज्ञातिमित्राणि परित्यज्य यं देशमहं दर्शयिष्यामि तं देशं व्रज। ");
INSERT INTO sandev_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","अतः स कस्दीयदेशं विहाय हारण्नगरे न्यवसत्, तदनन्तरं तस्य पितरि मृते यत्र देशे यूयं निवसथ स एनं देशमागच्छत्। ");
INSERT INTO sandev_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","किन्त्वीश्वरस्तस्मै कमप्यधिकारम् अर्थाद् एकपदपरिमितां भूमिमपि नाददात्; तदा तस्य कोपि सन्तानो नासीत् तथापि सन्तानैः सार्द्धम् एतस्य देशस्याधिकारी त्वं भविष्यसीति तम्प्रत्यङ्गीकृतवान्। ");
INSERT INTO sandev_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ईश्वर इत्थम् अपरमपि कथितवान् तव सन्तानाः परदेशे निवत्स्यन्ति ततस्तद्देशीयलोकाश्चतुःशतवत्सरान् यावत् तान् दासत्वे स्थापयित्वा तान् प्रति कुव्यवहारं करिष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","अपरम् ईश्वर एनां कथामपि कथितवान्, ये लोकास्तान् दासत्वे स्थापयिष्यन्ति ताल्लोकान् अहं दण्डयिष्यामि, ततः परं ते बहिर्गताः सन्तो माम् अत्र स्थाने सेविष्यन्ते। ");
INSERT INTO sandev_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","पश्चात् स तस्मै त्वक्छेदस्य नियमं दत्तवान्, अत इस्हाकनाम्नि इब्राहीम एकपुत्रे जाते, अष्टमदिने तस्य त्वक्छेदम् अकरोत्। तस्य इस्हाकः पुत्रो याकूब्, ततस्तस्य याकूबोऽस्माकं द्वादश पूर्व्वपुरुषा अजायन्त। ");
INSERT INTO sandev_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","ते पूर्व्वपुरुषा ईर्ष्यया परिपूर्णा मिसरदेशं प्रेषयितुं यूषफं व्यक्रीणन्। ");
INSERT INTO sandev_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","किन्त्वीश्वरस्तस्य सहायो भूत्वा सर्व्वस्या दुर्गते रक्षित्वा तस्मै बुद्धिं दत्त्वा मिसरदेशस्य राज्ञः फिरौणः प्रियपात्रं कृतवान् ततो राजा मिसरदेशस्य स्वीयसर्व्वपरिवारस्य च शासनपदं तस्मै दत्तवान्। ");
INSERT INTO sandev_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","तस्मिन् समये मिसर-किनानदेशयो र्दुर्भिक्षहेतोरतिक्लिष्टत्वात् नः पूर्व्वपुरुषा भक्ष्यद्रव्यं नालभन्त। ");
INSERT INTO sandev_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","किन्तु मिसरदेशे शस्यानि सन्ति, याकूब् इमां वार्त्तां श्रुत्वा प्रथमम् अस्माकं पूर्व्वपुरुषान् मिसरं प्रेषितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ततो द्वितीयवारगमने यूषफ् स्वभ्रातृभिः परिचितोऽभवत्; यूषफो भ्रातरः फिरौण् राजेन परिचिता अभवन्। ");
INSERT INTO sandev_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","अनन्तरं यूषफ् भ्रातृगणं प्रेष्य निजपितरं याकूबं निजान् पञ्चाधिकसप्ततिसंख्यकान् ज्ञातिजनांश्च समाहूतवान्। ");
INSERT INTO sandev_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","तस्माद् याकूब् मिसरदेशं गत्वा स्वयम् अस्माकं पूर्व्वपुरुषाश्च तस्मिन् स्थानेऽम्रियन्त। ");
INSERT INTO sandev_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ततस्ते शिखिमं नीता यत् श्मशानम् इब्राहीम् मुद्रादत्वा शिखिमः पितु र्हमोरः पुत्रेभ्यः क्रीतवान् तत्श्मशाने स्थापयाञ्चक्रिरे। ");
INSERT INTO sandev_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","ततः परम् ईश्वर इब्राहीमः सन्निधौ शपथं कृत्वा यां प्रतिज्ञां कृतवान् तस्याः प्रतिज्ञायाः फलनसमये निकटे सति इस्रायेल्लोका सिमरदेशे वर्द्धमाना बहुसंख्या अभवन्। ");
INSERT INTO sandev_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","शेषे यूषफं यो न परिचिनोति तादृश एको नरपतिरुपस्थाय ");
INSERT INTO sandev_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","अस्माकं ज्ञातिभिः सार्द्धं धूर्त्ततां विधाय पूर्व्वपुरुषान् प्रति कुव्यवहरणपूर्व्वकं तेषां वंशनाशनाय तेषां नवजातान् शिशून् बहि र्निरक्षेपयत्। ");
INSERT INTO sandev_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","एतस्मिन् समये मूसा जज्ञे, स तु परमसुन्दरोऽभवत् तथा पितृगृहे मासत्रयपर्य्यन्तं पालितोऽभवत्। ");
INSERT INTO sandev_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","किन्तु तस्मिन् बहिर्निक्षिप्ते सति फिरौणराजस्य कन्या तम् उत्तोल्य नीत्वा दत्तकपुत्रं कृत्वा पालितवती। ");
INSERT INTO sandev_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","तस्मात् स मूसा मिसरदेशीयायाः सर्व्वविद्यायाः पारदृष्वा सन् वाक्ये क्रियायाञ्च शक्तिमान् अभवत्। ");
INSERT INTO sandev_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","स सम्पूर्णचत्वारिंशद्वत्सरवयस्को भूत्वा इस्रायेलीयवंशनिजभ्रातृन् साक्षात् कर्तुं मतिं चक्रे। ");
INSERT INTO sandev_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","तेषां जनमेकं हिंसितं दृष्ट्वा तस्य सपक्षः सन् हिंसितजनम् उपकृत्य मिसरीयजनं जघान। ");
INSERT INTO sandev_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","तस्य हस्तेनेश्वरस्तान् उद्धरिष्यति तस्य भ्रातृगण इति ज्ञास्यति स इत्यनुमानं चकार, किन्तु ते न बुबुधिरे। ");
INSERT INTO sandev_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","तत्परे ऽहनि तेषाम् उभयो र्जनयो र्वाक्कलह उपस्थिते सति मूसाः समीपं गत्वा तयो र्मेलनं कर्त्तुं मतिं कृत्वा कथयामास, हे महाशयौ युवां भ्रातरौ परस्परम् अन्यायं कुतः कुरुथः? ");
INSERT INTO sandev_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","ततः समीपवासिनं प्रति यो जनोऽन्यायं चकार स तं दूरीकृत्य कथयामास, अस्माकमुपरि शास्तृत्वविचारयितृत्वपदयोः कस्त्वां नियुक्तवान्? ");
INSERT INTO sandev_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","ह्यो यथा मिसरीयं हतवान् तथा किं मामपि हनिष्यसि? ");
INSERT INTO sandev_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","तदा मूसा एतादृशीं कथां श्रुत्वा पलायनं चक्रे, ततो मिदियनदेशं गत्वा प्रवासी सन् तस्थौ, ततस्तत्र द्वौ पुत्रौ जज्ञाते। ");
INSERT INTO sandev_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","अनन्तरं चत्वारिंशद्वत्सरेषु गतेषु सीनयपर्व्वतस्य प्रान्तरे प्रज्वलितस्तम्बस्य वह्निशिखायां परमेश्वरदूतस्तस्मै दर्शनं ददौ। ");
INSERT INTO sandev_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","मूसास्तस्मिन् दर्शने विस्मयं मत्वा विशेषं ज्ञातुं निकटं गच्छति, ");
INSERT INTO sandev_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","एतस्मिन् समये, अहं तव पूर्व्वपुरुषाणाम् ईश्वरोऽर्थाद् इब्राहीम ईश्वर इस्हाक ईश्वरो याकूब ईश्वरश्च, मूसामुद्दिश्य परमेश्वरस्यैतादृशी विहायसीया वाणी बभूव, ततः स कम्पान्वितः सन् पुन र्निरीक्षितुं प्रगल्भो न बभूव। ");
INSERT INTO sandev_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","परमेश्वरस्तं जगाद, तव पादयोः पादुके मोचय यत्र तिष्ठसि सा पवित्रभूमिः। ");
INSERT INTO sandev_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","अहं मिसरदेशस्थानां निजलोकानां दुर्द्दशां नितान्तम् अपश्यं, तेषां कातर्य्योक्तिञ्च श्रुतवान् तस्मात् तान् उद्धर्त्तुम् अवरुह्यागमम्; इदानीम् आगच्छ मिसरदेशं त्वां प्रेषयामि। ");
INSERT INTO sandev_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","कस्त्वां शास्तृत्वविचारयितृत्वपदयो र्नियुक्तवान्, इति वाक्यमुक्त्वा तै र्यो मूसा अवज्ञातस्तमेव ईश्वरः स्तम्बमध्ये दर्शनदात्रा तेन दूतेन शास्तारं मुक्तिदातारञ्च कृत्वा प्रेषयामास। ");
INSERT INTO sandev_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","स च मिसरदेशे सूफ्नाम्नि समुद्रे च पश्चात् चत्वारिंशद्वत्सरान् यावत् महाप्रान्तरे नानाप्रकाराण्यद्भुतानि कर्म्माणि लक्षणानि च दर्शयित्वा तान् बहिः कृत्वा समानिनाय। ");
INSERT INTO sandev_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","प्रभुः परमेश्वरो युष्माकं भ्रातृगणस्य मध्ये मादृशम् एकं भविष्यद्वक्तारम् उत्पादयिष्यति तस्य कथायां यूयं मनो निधास्यथ, यो जन इस्रायेलः सन्तानेभ्य एनां कथां कथयामास स एष मूसाः। ");
INSERT INTO sandev_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","महाप्रान्तरस्थमण्डलीमध्येऽपि स एव सीनयपर्व्वतोपरि तेन सार्द्धं संलापिनो दूतस्य चास्मत्पितृगणस्य मध्यस्थः सन् अस्मभ्यं दातव्यनि जीवनदायकानि वाक्यानि लेभे। ");
INSERT INTO sandev_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","अस्माकं पूर्व्वपुरुषास्तम् अमान्यं कत्वा स्वेभ्यो दूरीकृत्य मिसरदेशं परावृत्य गन्तुं मनोभिरभिलष्य हारोणं जगदुः, ");
INSERT INTO sandev_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","अस्माकम् अग्रेऽग्रे गन्तुुम् अस्मदर्थं देवगणं निर्म्माहि यतो यो मूसा अस्मान् मिसरदेशाद् बहिः कृत्वानीतवान् तस्य किं जातं तदस्माभि र्न ज्ञायते। ");
INSERT INTO sandev_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","तस्मिन् समये ते गोवत्साकृतिं प्रतिमां निर्म्माय तामुद्दिश्य नैवेद्यमुत्मृज्य स्वहस्तकृतवस्तुना आनन्दितवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","तस्माद् ईश्वरस्तेषां प्रति विमुखः सन् आकाशस्थं ज्योतिर्गणं पूजयितुं तेभ्योऽनुमतिं ददौ, यादृशं भविष्यद्वादिनां ग्रन्थेषु लिखितमास्ते, यथा, इस्रायेलीयवंशा रे चत्वारिंशत्समान् पुरा। महति प्रान्तरे संस्था यूयन्तु यानि च। बलिहोमादिकर्म्माणि कृतवन्तस्तु तानि किं। मां समुद्दिश्य युष्माभिः प्रकृतानीति नैव च। ");
INSERT INTO sandev_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","किन्तु वो मोलकाख्यस्य देवस्य दूष्यमेव च। युष्माकं रिम्फनाख्याया देवतायाश्च तारका। एतयोरुभयो र्मूर्ती युष्माभिः परिपूजिते। अतो युष्मांस्तु बाबेलः पारं नेष्यामि निश्चितं। ");
INSERT INTO sandev_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","अपरञ्च यन्निदर्शनम् अपश्यस्तदनुसारेण दूष्यं निर्म्माहि यस्मिन् ईश्वरो मूसाम् एतद्वाक्यं बभाषे तत् तस्य निरूपितं साक्ष्यस्वरूपं दूष्यम् अस्माकं पूर्व्वपुरुषैः सह प्रान्तरे तस्थौ। ");
INSERT INTO sandev_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","पश्चात् यिहोशूयेन सहितैस्तेषां वंशजातैरस्मत्पूर्व्वपुरुषैः स्वेषां सम्मुखाद् ईश्वरेण दूरीकृतानाम् अन्यदेशीयानां देशाधिकृतिकाले समानीतं तद् दूष्यं दायूदोधिकारं यावत् तत्र स्थान आसीत्। ");
INSERT INTO sandev_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","स दायूद् परमेश्वरस्यानुग्रहं प्राप्य याकूब् ईश्वरार्थम् एकं दूष्यं निर्म्मातुं ववाञ्छ; ");
INSERT INTO sandev_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","किन्तु सुलेमान् तदर्थं मन्दिरम् एकं निर्म्मितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","तथापि यः सर्व्वोपरिस्थः स कस्मिंश्चिद् हस्तकृते मन्दिरे निवसतीति नहि, भविष्यद्वादी कथामेतां कथयति, यथा, ");
INSERT INTO sandev_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","परेशो वदति स्वर्गो राजसिंहासनं मम। मदीयं पादपीठञ्च पृथिवी भवति ध्रुवं। तर्हि यूयं कृते मे किं प्रनिर्म्मास्यथ मन्दिरं। विश्रामाय मदीयं वा स्थानं किं विद्यते त्विह। ");
INSERT INTO sandev_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","सर्व्वाण्येतानि वस्तूनि किं मे हस्तकृतानि न॥ ");
INSERT INTO sandev_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","हे अनाज्ञाग्राहका अन्तःकरणे श्रवणे चापवित्रलोकाः यूयम् अनवरतं पवित्रस्यात्मनः प्रातिकूल्यम् आचरथ, युष्माकं पूर्व्वपुरुषा यादृशा यूयमपि तादृशाः। ");
INSERT INTO sandev_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","युष्माकं पूर्व्वपुरुषाः कं भविष्यद्वादिनं नाताडयन्? ये तस्य धार्म्मिकस्य जनस्यागमनकथां कथितवन्तस्तान् अघ्नन् यूयम् अधूना विश्वासघातिनो भूत्वा तं धार्म्मिकं जनम् अहत। ");
INSERT INTO sandev_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","यूयं स्वर्गीयदूतगणेन व्यवस्थां प्राप्यापि तां नाचरथ। ");
INSERT INTO sandev_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","इमां कथां श्रुत्वा ते मनःसु बिद्धाः सन्तस्तं प्रति दन्तघर्षणम् अकुर्व्वन्। ");
INSERT INTO sandev_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","किन्तु स्तिफानः पवित्रेणात्मना पूर्णो भूत्वा गगणं प्रति स्थिरदृष्टिं कृत्वा ईश्वरस्य दक्षिणे दण्डायमानं यीशुञ्च विलोक्य कथितवान्; ");
INSERT INTO sandev_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","पश्य,मेघद्वारं मुक्तम् ईश्वरस्य दक्षिणे स्थितं मानवसुतञ्च पश्यामि। ");
INSERT INTO sandev_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","तदा ते प्रोच्चैः शब्दं कृत्वा कर्णेष्वङ्गुली र्निधाय एकचित्तीभूय तम् आक्रमन्। ");
INSERT INTO sandev_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","पश्चात् तं नगराद् बहिः कृत्वा प्रस्तरैराघ्नन् साक्षिणो लाकाः शौलनाम्नो यूनश्चरणसन्निधौ निजवस्त्राणि स्थापितवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","अनन्तरं हे प्रभो यीशे मदीयमात्मानं गृहाण स्तिफानस्येति प्रार्थनवाक्यवदनसमये ते तं प्रस्तरैराघ्नन्। ");
INSERT INTO sandev_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","तस्मात् स जानुनी पातयित्वा प्रोच्चैः शब्दं कृत्वा, हे प्रभे पापमेतद् एतेषु मा स्थापय, इत्युक्त्वा महानिद्रां प्राप्नोत्। ");
INSERT INTO sandev_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","तस्य हत्याकरणं शौलोपि सममन्यत। तस्मिन् समये यिरूशालम्नगरस्थां मण्डलीं प्रति महाताडनायां जातायां प्रेरितलोकान् हित्वा सर्व्वेऽपरे यिहूदाशोमिरोणदेशयो र्नानास्थाने विकीर्णाः सन्तो गताः। ");
INSERT INTO sandev_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","अन्यच्च भक्तलोकास्तं स्तिफानं श्मशाने स्थापयित्वा बहु व्यलपन्। ");
INSERT INTO sandev_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","किन्तु शौलो गृहे गृहे भ्रमित्वा स्त्रियः पुरुषांश्च धृत्वा कारायां बद्ध्वा मण्डल्या महोत्पातं कृतवान्। ");
INSERT INTO sandev_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","अन्यच्च ये विकीर्णा अभवन् ते सर्व्वत्र भ्रमित्वा सुसंवादं प्राचारयन्। ");
INSERT INTO sandev_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","तदा फिलिपः शोमिरोण्नगरं गत्वा ख्रीष्टाख्यानं प्राचारयत्; ");
INSERT INTO sandev_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","ततोऽशुचि-भृतग्रस्तलोकेभ्यो भूताश्चीत्कृत्यागच्छन् तथा बहवः पक्षाघातिनः खञ्जा लोकाश्च स्वस्था अभवन्। ");
INSERT INTO sandev_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","तस्मात् लाका ईदृशं तस्याश्चर्य्यं कर्म्म विलोक्य निशम्य च सर्व्व एकचित्तीभूय तेनोक्ताख्याने मनांसि न्यदधुः। ");
INSERT INTO sandev_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","तस्मिन्नगरे महानन्दश्चाभवत्। ");
INSERT INTO sandev_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ततः पूर्व्वं तस्मिन्नगरे शिमोन्नामा कश्चिज्जनो बह्वी र्मायाक्रियाः कृत्वा स्वं कञ्चन महापुरुषं प्रोच्य शोमिरोणीयानां मोहं जनयामास। ");
INSERT INTO sandev_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","तस्मात् स मानुष ईश्वरस्य महाशक्तिस्वरूप इत्युक्त्वा बालवृद्धवनिताः सर्व्वे लाकास्तस्मिन् मनांसि न्यदधुः। ");
INSERT INTO sandev_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","स बहुकालान् मायाविक्रियया सर्व्वान् अतीव मोहयाञ्चकार, तस्मात् ते तं मेनिरे। ");
INSERT INTO sandev_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","किन्त्वीश्वरस्य राज्यस्य यीशुख्रीष्टस्य नाम्नश्चाख्यानप्रचारिणः फिलिपस्य कथायां विश्वस्य तेषां स्त्रीपुरुषोभयलोका मज्जिता अभवन्। ");
INSERT INTO sandev_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","शेषे स शिमोनपि स्वयं प्रत्यैत् ततो मज्जितः सन् फिलिपेन कृताम् आश्चर्य्यक्रियां लक्षणञ्च विलोक्यासम्भवं मन्यमानस्तेन सह स्थितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","इत्थं शोमिरोण्देशीयलोका ईश्वरस्य कथाम् अगृह्लन् इति वार्त्तां यिरूशालम्नगरस्थप्रेरिताः प्राप्य पितरं योहनञ्च तेषां निकटे प्रेषितवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ततस्तौ तत् स्थानम् उपस्थाय लोका यथा पवित्रम् आत्मानं प्राप्नुवन्ति तदर्थं प्रार्थयेतां। ");
INSERT INTO sandev_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","यतस्ते पुरा केवलप्रभुयीशो र्नाम्ना मज्जितमात्रा अभवन्, न तु तेषां मध्ये कमपि प्रति पवित्रस्यात्मन आविर्भावो जातः। ");
INSERT INTO sandev_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","किन्तु प्रेरिताभ्यां तेषां गात्रेषु करेष्वर्पितेषु सत्सु ते पवित्रम् आत्मानम् प्राप्नुवन्। ");
INSERT INTO sandev_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","इत्थं लोकानां गात्रेषु प्रेरितयोः करार्पणेन तान् पवित्रम् आत्मानं प्राप्तान् दृष्ट्वा स शिमोन् तयोः समीपे मुद्रा आनीय कथितवान्; ");
INSERT INTO sandev_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","अहं यस्य गात्रे हस्तम् अर्पयिष्यामि तस्यापि यथेत्थं पवित्रात्मप्राप्ति र्भवति तादृशीं शक्तिं मह्यं दत्तं। ");
INSERT INTO sandev_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","किन्तु पितरस्तं प्रत्यवदत् तव मुद्रास्त्वया विनश्यन्तु यत ईश्वरस्य दानं मुद्राभिः क्रीयते त्वमित्थं बुद्धवान्; ");
INSERT INTO sandev_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ईश्वराय तावन्तःकरणं सरलं नहि, तस्माद् अत्र तवांशोऽधिकारश्च कोपि नास्ति। ");
INSERT INTO sandev_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","अत एतत्पापहेतोः खेदान्वितः सन् केनापि प्रकारेण तव मनस एतस्याः कुकल्पनायाः क्षमा भवति, एतदर्थम् ईश्वरे प्रार्थनां कुरु; ");
INSERT INTO sandev_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","यतस्त्वं तिक्तपित्ते पापस्य बन्धने च यदसि तन्मया बुद्धम्। ");
INSERT INTO sandev_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","तदा शिमोन् अकथयत् तर्हि युवाभ्यामुदिता कथा मयि यथा न फलति तदर्थं युवां मन्निमित्तं प्रभौ प्रार्थनां कुरुतं। ");
INSERT INTO sandev_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","अनेन प्रकारेण तौ साक्ष्यं दत्त्वा प्रभोः कथां प्रचारयन्तौ शोमिरोणीयानाम् अनेकग्रामेषु सुसंवादञ्च प्रचारयन्तौ यिरूशालम्नगरं परावृत्य गतौ। ");
INSERT INTO sandev_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ततः परम् ईश्वरस्य दूतः फिलिपम् इत्यादिशत्, त्वमुत्थाय दक्षिणस्यां दिशि यो मार्गो प्रान्तरस्य मध्येन यिरूशालमो ऽसानगरं याति तं मार्गं गच्छ। ");
INSERT INTO sandev_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ततः स उत्थाय गतवान्; तदा कन्दाकीनाम्नः कूश्लोकानां राज्ञ्याः सर्व्वसम्पत्तेरधीशः कूशदेशीय एकः षण्डो भजनार्थं यिरूशालम्नगरम् आगत्य ");
INSERT INTO sandev_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","पुनरपि रथमारुह्य यिशयियनाम्नो भविष्यद्वादिनो ग्रन्थं पठन् प्रत्यागच्छति। ");
INSERT INTO sandev_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","एतस्मिन् समये आत्मा फिलिपम् अवदत्, त्वम् रथस्य समीपं गत्वा तेन सार्द्धं मिल। ");
INSERT INTO sandev_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","तस्मात् स धावन् तस्य सन्निधावुपस्थाय तेन पठ्यमानं यिशयियथविष्यद्वादिनो वाक्यं श्रुत्वा पृष्टवान् यत् पठसि तत् किं बुध्यसे? ");
INSERT INTO sandev_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","ततः स कथितवान् केनचिन्न बोधितोहं कथं बुध्येय? ततः स फिलिपं रथमारोढुं स्वेन सार्द्धम् उपवेष्टुञ्च न्यवेदयत्। ");
INSERT INTO sandev_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","स शास्त्रस्येतद्वाक्यं पठितवान् यथा, समानीयत घाताय स यथा मेषशावकः। लोमच्छेदकसाक्षाच्च मेषश्च नीरवो यथा। आबध्य वदनं स्वीयं तथा स समतिष्ठत। ");
INSERT INTO sandev_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","अन्यायेन विचारेण स उच्छिन्नो ऽभवत् तदा। तत्कालीनमनुष्यान् को जनो वर्णयितुं क्षमः। यतो जीवन्नृणां देशात् स उच्छिन्नो ऽभवत् ध्रुवं। ");
INSERT INTO sandev_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","अनन्तरं स फिलिपम् अवदत् निवेदयामि, भविष्यद्वादी यामिमां कथां कथयामास स किं स्वस्मिन् वा कस्मिंश्चिद् अन्यस्मिन्? ");
INSERT INTO sandev_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ततः फिलिपस्तत्प्रकरणम् आरभ्य यीशोरुपाख्यानं तस्याग्रे प्रास्तौत्। ");
INSERT INTO sandev_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","इत्थं मार्गेण गच्छन्तौ जलाशयस्य समीप उपस्थितौ; तदा क्लीबोऽवादीत् पश्यात्र स्थाने जलमास्ते मम मज्जने का बाधा? ");
INSERT INTO sandev_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","ततः फिलिप उत्तरं व्याहरत् स्वान्तःकरणेन साकं यदि प्रत्येषि तर्हि बाधा नास्ति। ततः स कथितवान् यीशुख्रीष्ट ईश्वरस्य पुत्र इत्यहं प्रत्येमि। ");
INSERT INTO sandev_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","तदा रथं स्थगितं कर्त्तुम् आदिष्टे फिलिपक्लीबौ द्वौ जलम् अवारुहतां; तदा फिलिपस्तम् मज्जयामास। ");
INSERT INTO sandev_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","तत्पश्चात् जलमध्याद् उत्थितयोः सतोः परमेश्वरस्यात्मा फिलिपं हृत्वा नीतवान्, तस्मात् क्लीबः पुनस्तं न दृष्टवान् तथापि हृष्टचित्तः सन् स्वमार्गेण गतवान्। ");
INSERT INTO sandev_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","फिलिपश्चास्दोद्नगरम् उपस्थाय तस्मात् कैसरियानगर उपस्थितिकालपर्य्यनतं सर्व्वस्मिन्नगरे सुसंवादं प्रचारयन् गतवान्। ");
INSERT INTO sandev_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","तत्कालपर्य्यनतं शौलः प्रभोः शिष्याणां प्रातिकूल्येन ताडनाबधयोः कथां निःसारयन् महायाजकस्य सन्निधिं गत्वा ");
INSERT INTO sandev_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","स्त्रियं पुरुषञ्च तन्मतग्राहिणं यं कञ्चित् पश्यति तान् धृत्वा बद्ध्वा यिरूशालमम् आनयतीत्याशयेन दम्मेषक्नगरीयं धर्म्मसमाजान् प्रति पत्रं याचितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","गच्छन् तु दम्मेषक्नगरनिकट उपस्थितवान्; ततोऽकस्माद् आकाशात् तस्य चतुर्दिक्षु तेजसः प्रकाशनात् स भूमावपतत्। ");
INSERT INTO sandev_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","पश्चात् हे शौल हे शौल कुतो मां ताडयसि? स्वं प्रति प्रोक्तम् एतं शब्दं श्रुत्वा ");
INSERT INTO sandev_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","स पृष्टवान्, हे प्रभो भवान् कः? तदा प्रभुरकथयत् यं यीशुं त्वं ताडयसि स एवाहं; कण्टकस्य मुखे पदाघातकरणं तव कष्टम्। ");
INSERT INTO sandev_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","तदा कम्पमानो विस्मयापन्नश्च सोवदत् हे प्रभो मया किं कर्त्तव्यं? भवत इच्छा का? ततः प्रभुराज्ञापयद् उत्थाय नगरं गच्छ तत्र त्वया यत् कर्त्तव्यं तद् वदिष्यते। ");
INSERT INTO sandev_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","तस्य सङ्गिनो लोका अपि तं शब्दं श्रुतवन्तः किन्तु कमपि न दृष्ट्वा स्तब्धाः सन्तः स्थितवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","अनन्तरं शौलो भूमित उत्थाय चक्षुषी उन्मील्य कमपि न दृष्टवान्। तदा लोकास्तस्य हस्तौ धृत्वा दम्मेषक्नगरम् आनयन्। ");
INSERT INTO sandev_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ततः स दिनत्रयं यावद् अन्धो भूत्वा न भुक्तवान् पीतवांश्च। ");
INSERT INTO sandev_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","तदनन्तरं प्रभुस्तद्दम्मेषक्नगरवासिन एकस्मै शिष्याय दर्शनं दत्वा आहूतवान् हे अननिय। ततः स प्रत्यवादीत्, हे प्रभो पश्य शृणोमि। ");
INSERT INTO sandev_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","तदा प्रभुस्तमाज्ञापयत् त्वमुत्थाय सरलनामानं मार्गं गत्वा यिहूदानिवेशने तार्षनगरीयं शौलनामानं जनं गवेषयन् पृच्छ; ");
INSERT INTO sandev_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","पश्य स प्रार्थयते, तथा अननियनामक एको जनस्तस्य समीपम् आगत्य तस्य गात्रे हस्तार्पणं कृत्वा दृष्टिं ददातीत्थं स्वप्ने दृष्टवान्। ");
INSERT INTO sandev_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","तस्माद् अननियः प्रत्यवदत् हे प्रभो यिरूशालमि पवित्रलोकान् प्रति सोऽनेकहिंसां कृतवान्; ");
INSERT INTO sandev_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","अत्र स्थाने च ये लोकास्तव नाम्नि प्रार्थयन्ति तानपि बद्धुं स प्रधानयाजकेभ्यः शक्तिं प्राप्तवान्, इमां कथाम् अहम् अनेकेषां मुखेभ्यः श्रुतवान्। ");
INSERT INTO sandev_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","किन्तु प्रभुरकथयत्, याहि भिन्नदेशीयलोकानां भूपतीनाम् इस्रायेल्लोकानाञ्च निकटे मम नाम प्रचारयितुं स जनो मम मनोनीतपात्रमास्ते। ");
INSERT INTO sandev_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","मम नामनिमित्तञ्च तेन कियान् महान् क्लेशो भोक्तव्य एतत् तं दर्शयिष्यामि। ");
INSERT INTO sandev_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ततो ऽननियो गत्वा गृहं प्रविश्य तस्य गात्रे हस्तार्प्रणं कृत्वा कथितवान्, हे भ्रातः शौल त्वं यथा दृष्टिं प्राप्नोषि पवित्रेणात्मना परिपूर्णो भवसि च, तदर्थं तवागमनकाले यः प्रभुयीशुस्तुभ्यं दर्शनम् अददात् स मां प्रेषितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","इत्युक्तमात्रे तस्य चक्षुर्भ्याम् मीनशल्कवद् वस्तुनि निर्गते तत्क्षणात् स प्रसन्नचक्षु र्भूत्वा प्रोत्थाय मज्जितोऽभवत् भुक्त्वा पीत्वा सबलोभवच्च। ");
INSERT INTO sandev_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ततः परं शौलः शिष्यैः सह कतिपयदिवसान् तस्मिन् दम्मेषकनगरे स्थित्वाऽविलम्बं ");
INSERT INTO sandev_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","सर्व्वभजनभवनानि गत्वा यीशुरीश्वरस्य पुत्र इमां कथां प्राचारयत्। ");
INSERT INTO sandev_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","तस्मात् सर्व्वे श्रोतारश्चमत्कृत्य कथितवन्तो यो यिरूशालम्नगर एतन्नाम्ना प्रार्थयितृलोकान् विनाशितवान् एवम् एतादृशलोकान् बद्ध्वा प्रधानयाजकनिकटं नयतीत्याशया एतत्स्थानमप्यागच्छत् सएव किमयं न भवति? ");
INSERT INTO sandev_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","किन्तु शौलः क्रमश उत्साहवान् भूत्वा यीशुरीश्वरेणाभिषिक्तो जन एतस्मिन् प्रमाणं दत्वा दम्मेषक्-निवासियिहूदीयलोकान् निरुत्तरान् अकरोत्। ");
INSERT INTO sandev_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","इत्थं बहुतिथे काले गते यिहूदीयलोकास्तं हन्तुं मन्त्रयामासुः ");
INSERT INTO sandev_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","किन्तु शौलस्तेषामेतस्या मन्त्रणाया वार्त्तां प्राप्तवान्। ते तं हन्तुं तु दिवानिशं गुप्ताः सन्तो नगरस्य द्वारेऽतिष्ठन्; ");
INSERT INTO sandev_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","तस्मात् शिष्यास्तं नीत्वा रात्रौ पिटके निधाय प्राचीरेणावारोहयन्। ");
INSERT INTO sandev_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","ततः परं शौलो यिरूशालमं गत्वा शिष्यगणेन सार्द्धं स्थातुम् ऐहत्, किन्तु सर्व्वे तस्मादबिभयुः स शिष्य इति च न प्रत्ययन्। ");
INSERT INTO sandev_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","एतस्माद् बर्णब्बास्तं गृहीत्वा प्रेरितानां समीपमानीय मार्गमध्ये प्रभुः कथं तस्मै दर्शनं दत्तवान् याः कथाश्च कथितवान् स च यथाक्षोभः सन् दम्मेषक्नगरे यीशो र्नाम प्राचारयत् एतान् सर्व्ववृत्तान्तान् तान् ज्ञापितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","ततः शौलस्तैः सह यिरूशालमि कालं यापयन् निर्भयं प्रभो र्यीशो र्नाम प्राचारयत्। ");
INSERT INTO sandev_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","तस्माद् अन्यदेशीयलोकैः सार्द्धं विवादस्योपस्थितत्वात् ते तं हन्तुम् अचेष्टन्त। ");
INSERT INTO sandev_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","किन्तु भ्रातृगणस्तज्ज्ञात्वा तं कैसरियानगरं नीत्वा तार्षनगरं प्रेषितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","इत्थं सति यिहूदियागालील्शोमिरोणदेशीयाः सर्व्वा मण्डल्यो विश्रामं प्राप्तास्ततस्तासां निष्ठाभवत् प्रभो र्भिया पवित्रस्यात्मनः सान्त्वनया च कालं क्षेपयित्वा बहुसंख्या अभवन्। ");
INSERT INTO sandev_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","ततः परं पितरः स्थाने स्थाने भ्रमित्वा शेषे लोद्नगरनिवासिपवित्रलोकानां समीपे स्थितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","तदा तत्र पक्षाघातव्याधिनाष्टौ वत्सरान् शय्यागतम् ऐनेयनामानं मनुष्यं साक्षत् प्राप्य तमवदत्, ");
INSERT INTO sandev_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","हे ऐनेय यीशुख्रीष्टस्त्वां स्वस्थम् अकार्षीत्, त्वमुत्थाय स्वशय्यां निक्षिप, इत्युक्तमात्रे स उदतिष्ठत्। ");
INSERT INTO sandev_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","एतादृशं दृष्ट्वा लोद्शारोणनिवासिनो लोकाः प्रभुं प्रति परावर्त्तन्त। ");
INSERT INTO sandev_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","अपरञ्च भिक्षादानादिषु नानक्रियासु नित्यं प्रवृत्ता या याफोनगरनिवासिनी टाबिथानामा शिष्या यां दर्क्कां अर्थाद् हरिणीमयुक्त्वा आह्वयन् सा नारी ");
INSERT INTO sandev_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","तस्मिन् समये रुग्ना सती प्राणान् अत्यजत्, ततो लोकास्तां प्रक्षाल्योपरिस्थप्रकोष्ठे शाययित्वास्थापयन्। ");
INSERT INTO sandev_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","लोद्नगरं याफोनगरस्य समीपस्थं तस्मात्तत्र पितर आस्ते, इति वार्त्तां श्रुत्वा तूर्णं तस्यागमनार्थं तस्मिन् विनयमुक्त्वा शिष्यगणो द्वौ मनुजौ प्रेषितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","तस्मात् पितर उत्थाय ताभ्यां सार्द्धम् आगच्छत्, तत्र तस्मिन् उपस्थित उपरिस्थप्रकोष्ठं समानीते च विधवाः स्वाभिः सह स्थितिकाले दर्क्कया कृतानि यान्युत्तरीयाणि परिधेयानि च तानि सर्व्वाणि तं दर्शयित्वा रुदत्यश्चतसृषु दिक्ष्वतिष्ठन्। ");
INSERT INTO sandev_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","किन्तु पितरस्ताः सर्व्वा बहिः कृत्वा जानुनी पातयित्वा प्रार्थितवान्; पश्चात् शवं प्रति दृष्टिं कृत्वा कथितवान्, हे टाबीथे त्वमुत्तिष्ठ, इति वाक्य उक्ते सा स्त्री चक्षुषी प्रोन्मील्य पितरम् अवलोक्योत्थायोपाविशत्। ");
INSERT INTO sandev_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","ततः पितरस्तस्याः करौ धृत्वा उत्तोल्य पवित्रलोकान् विधवाश्चाहूय तेषां निकटे सजीवां तां समार्पयत्। ");
INSERT INTO sandev_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","एषा कथा समस्तयाफोनगरं व्याप्ता तस्माद् अनेके लोकाः प्रभौ व्यश्वसन्। ");
INSERT INTO sandev_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","अपरञ्च पितरस्तद्याफोनगरीयस्य कस्यचित् शिमोन्नाम्नश्चर्म्मकारस्य गृहे बहुदिनानि न्यवसत्। ");
INSERT INTO sandev_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","कैसरियानगर इतालियाख्यसैन्यान्तर्गतः कर्णीलियनामा सेनापतिरासीत् ");
INSERT INTO sandev_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","स सपरिवारो भक्त ईश्वरपरायणश्चासीत्; लोकेभ्यो बहूनि दानादीनि दत्वा निरन्तरम् ईश्वरे प्रार्थयाञ्चक्रे। ");
INSERT INTO sandev_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","एकदा तृतीयप्रहरवेलायां स दृष्टवान् ईश्वरस्यैको दूतः सप्रकाशं तत्समीपम् आगत्य कथितवान्, हे कर्णीलिय। ");
INSERT INTO sandev_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","किन्तु स तं दृष्ट्वा भीतोऽकथयत्, हे प्रभो किं? तदा तमवदत् तव प्रार्थना दानादि च साक्षिस्वरूपं भूत्वेश्वरस्य गोचरमभवत्। ");
INSERT INTO sandev_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","इदानीं याफोनगरं प्रति लोकान् प्रेष्य समुद्रतीरे शिमोन्नाम्नश्चर्म्मकारस्य गृहे प्रवासकारी पितरनाम्ना विख्यातो यः शिमोन् तम् आह्वायय; ");
INSERT INTO sandev_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","तस्मात् त्वया यद्यत् कर्त्तव्यं तत्तत् स वदिष्यति। ");
INSERT INTO sandev_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","इत्युपदिश्य दूते प्रस्थिते सति कर्णीलियः स्वगृहस्थानां दासानां द्वौ जनौ नित्यं स्वसङ्गिनां सैन्यानाम् एकां भक्तसेनाञ्चाहूय ");
INSERT INTO sandev_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","सकलमेतं वृत्तान्तं विज्ञाप्य याफोनगरं तान् प्राहिणोत्। ");
INSERT INTO sandev_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","परस्मिन् दिने ते यात्रां कृत्वा यदा नगरस्य समीप उपातिष्ठन्, तदा पितरो द्वितीयप्रहरवेलायां प्रार्थयितुं गृहपृष्ठम् आरोहत्। ");
INSERT INTO sandev_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","एतस्मिन् समये क्षुधार्त्तः सन् किञ्चिद् भोक्तुम् ऐच्छत् किन्तु तेषाम् अन्नासादनसमये स मूर्च्छितः सन्नपतत्। ");
INSERT INTO sandev_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ततो मेघद्वारं मुक्तं चतुर्भिः कोणै र्लम्बितं बृहद्वस्त्रमिव किञ्चन भाजनम् आकाशात् पृथिवीम् अवारोहतीति दृष्टवान्। ");
INSERT INTO sandev_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","तन्मध्ये नानप्रकारा ग्राम्यवन्यपशवः खेचरोरोगामिप्रभृतयो जन्तवश्चासन्। ");
INSERT INTO sandev_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","अनन्तरं हे पितर उत्थाय हत्वा भुंक्ष्व तम्प्रतीयं गगणीया वाणी जाता। ");
INSERT INTO sandev_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","तदा पितरः प्रत्यवदत्, हे प्रभो ईदृशं मा भवतु, अहम् एतत् कालं यावत् निषिद्धम् अशुचि वा द्रव्यं किञ्चिदपि न भुक्तवान्। ");
INSERT INTO sandev_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ततः पुनरपि तादृशी विहयसीया वाणी जाता यद् ईश्वरः शुचि कृतवान् तत् त्वं निषिद्धं न जानीहि। ");
INSERT INTO sandev_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","इत्थं त्रिः सति तत् पात्रं पुनराकृष्टं आकाशम् अगच्छत्। ");
INSERT INTO sandev_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ततः परं यद् दर्शनं प्राप्तवान् तस्य को भाव इत्यत्र पितरो मनसा सन्देग्धि, एतस्मिन् समये कर्णीलियस्य ते प्रेषिता मनुष्या द्वारस्य सन्निधावुपस्थाय, ");
INSERT INTO sandev_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","शिमोनो गृहमन्विच्छन्तः सम्पृछ्याहूय कथितवन्तः पितरनाम्ना विख्यातो यः शिमोन् स किमत्र प्रवसति? ");
INSERT INTO sandev_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","यदा पितरस्तद्दर्शनस्य भावं मनसान्दोलयति तदात्मा तमवदत्, पश्य त्रयो जनास्त्वां मृगयन्ते। ");
INSERT INTO sandev_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","त्वम् उत्थायावरुह्य निःसन्देहं तैः सह गच्छ मयैव ते प्रेषिताः। ");
INSERT INTO sandev_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","तस्मात् पितरोऽवरुह्य कर्णीलियप्रेरितलोकानां निकटमागत्य कथितवान् पश्यत यूयं यं मृगयध्वे स जनोहं, यूयं किन्निमित्तम् आगताः? ");
INSERT INTO sandev_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ततस्ते प्रत्यवदन् कर्णीलियनामा शुद्धसत्त्व ईश्वरपरायणो यिहूदीयदेशस्थानां सर्व्वेषां सन्निधौ सुख्यात्यापन्न एकः सेनापति र्निजगृहं त्वामाहूय नेतुं त्वत्तः कथा श्रोतुञ्च पवित्रदूतेन समादिष्टः। ");
INSERT INTO sandev_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","तदा पितरस्तानभ्यन्तरं नीत्वा तेषामातिथ्यं कृतवान्, परेऽहनि तैः सार्द्धं यात्रामकरोत्, याफोनिवासिनां भ्रातृणां कियन्तो जनाश्च तेन सह गताः। ");
INSERT INTO sandev_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","परस्मिन् दिवसे कैसरियानगरमध्यप्रवेशसमये कर्णीलियो ज्ञातिबन्धून् आहूयानीय तान् अपेक्ष्य स्थितः। ");
INSERT INTO sandev_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","पितरे गृह उपस्थिते कर्णीलियस्तं साक्षात्कृत्य चरणयोः पतित्वा प्राणमत्। ");
INSERT INTO sandev_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","पितरस्तमुत्थाप्य कथितवान्, उत्तिष्ठाहमपि मानुषः। ");
INSERT INTO sandev_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","तदा कर्णीलियेन साकम् आलपन् गृहं प्राविशत् तन्मध्ये च बहुलोकानां समागमं दृष्ट्वा तान् अवदत्, ");
INSERT INTO sandev_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","अन्यजातीयलोकैः महालपनं वा तेषां गृहमध्ये प्रवेशनं यिहूदीयानां निषिद्धम् अस्तीति यूयम् अवगच्छथ; किन्तु कमपि मानुषम् अव्यवहार्य्यम् अशुचिं वा ज्ञातुं मम नोचितम् इति परमेश्वरो मां ज्ञापितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","इति हेतोराह्वानश्रवणमात्रात् काञ्चनापत्तिम् अकृत्वा युष्माकं समीपम् आगतोस्मि; पृच्छामि यूयं किन्निमित्तं माम् आहूयत? ");
INSERT INTO sandev_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","तदा कर्णीलियः कथितवान्, अद्य चत्वारि दिनानि जातानि एतावद्वेलां यावद् अहम् अनाहार आसन् ततस्तृतीयप्रहरे सति गृहे प्रार्थनसमये तेजोमयवस्त्रभृद् एको जनो मम समक्षं तिष्ठन् एतां कथाम् अकथयत्, ");
INSERT INTO sandev_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","हे कर्णीलिय त्वदीया प्रार्थना ईश्वरस्य कर्णगोचरीभूता तव दानादि च साक्षिस्वरूपं भूत्वा तस्य दृष्टिगोचरमभवत्। ");
INSERT INTO sandev_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","अतो याफोनगरं प्रति लोकान् प्रहित्य तत्र समुद्रतीरे शिमोन्नाम्नः कस्यचिच्चर्म्मकारस्य गृहे प्रवासकारी पितरनाम्ना विख्यातो यः शिमोन् तमाहूायय; ततः स आगत्य त्वाम् उपदेक्ष्यति। ");
INSERT INTO sandev_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","इति कारणात् तत्क्षणात् तव निकटे लोकान् प्रेषितवान्, त्वमागतवान् इति भद्रं कृतवान्। ईश्वरो यान्याख्यानानि कथयितुम् आदिशत् तानि श्रोतुं वयं सर्व्वे साम्प्रतम् ईश्वरस्य साक्षाद् उपस्थिताः स्मः। ");
INSERT INTO sandev_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","तदा पितर इमां कथां कथयितुम् आरब्धवान्, ईश्वरो मनुष्याणाम् अपक्षपाती सन् ");
INSERT INTO sandev_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","यस्य कस्यचिद् देशस्य यो लोकास्तस्माद्भीत्वा सत्कर्म्म करोति स तस्य ग्राह्यो भवति, एतस्य निश्चयम् उपलब्धवानहम्। ");
INSERT INTO sandev_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","सर्व्वेषां प्रभु र्यो यीशुख्रीष्टस्तेन ईश्वर इस्रायेल्वंशानां निकटे सुसंवादं प्रेष्य सम्मेलनस्य यं संवादं प्राचारयत् तं संवादं यूयं श्रुतवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","यतो योहना मज्जने प्रचारिते सति स गालीलदेशमारभ्य समस्तयिहूदीयदेशं व्याप्नोत्; ");
INSERT INTO sandev_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","फलत ईश्वरेण पवित्रेणात्मना शक्त्या चाभिषिक्तो नासरतीययीशुः स्थाने स्थाने भ्रमन् सुक्रियां कुर्व्वन् शैताना क्लिष्टान् सर्व्वलोकान् स्वस्थान् अकरोत्, यत ईश्वरस्तस्य सहाय आसीत्; ");
INSERT INTO sandev_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","वयञ्च यिहूदीयदेशे यिरूशालम्नगरे च तेन कृतानां सर्व्वेषां कर्म्मणां साक्षिणो भवामः। लोकास्तं क्रुशे विद्ध्वा हतवन्तः, ");
INSERT INTO sandev_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","किन्तु तृतीयदिवसे ईश्वरस्तमुत्थाप्य सप्रकाशम् अदर्शयत्। ");
INSERT INTO sandev_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","सर्व्वलोकानां निकट इति न हि, किन्तु तस्मिन् श्मशानादुत्थिते सति तेन सार्द्धं भोजनं पानञ्च कृतवन्त एतादृशा ईश्वरस्य मनोनीताः साक्षिणो ये वयम् अस्माकं निकटे तमदर्शयत्। ");
INSERT INTO sandev_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","जीवितमृतोभयलोकानां विचारं कर्त्तुम् ईश्वरो यं नियुक्तवान् स एव स जनः, इमां कथां प्रचारयितुं तस्मिन् प्रमाणं दातुञ्च सोऽस्मान् आज्ञापयत्। ");
INSERT INTO sandev_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","यस्तस्मिन् विश्वसिति स तस्य नाम्ना पापान्मुक्तो भविष्यति तस्मिन् सर्व्वे भविष्यद्वादिनोपि एतादृशं साक्ष्यं ददति। ");
INSERT INTO sandev_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","पितरस्यैतत्कथाकथनकाले सर्व्वेषां श्रोतृणामुपरि पवित्र आत्मावारोहत्। ");
INSERT INTO sandev_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ततः पितरेण सार्द्धम् आगतास्त्वक्छेदिनो विश्वासिनो लोका अन्यदेशीयेभ्यः पवित्र आत्मनि दत्ते सति ");
INSERT INTO sandev_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ते नानाजातीयभाषाभिः कथां कथयन्त ईश्वरं प्रशंसन्ति, इति दृष्ट्वा श्रुत्वा च विस्मयम् आपद्यन्त। ");
INSERT INTO sandev_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","तदा पितरः कथितवान्, वयमिव ये पवित्रम् आत्मानं प्राप्तास्तेषां जलमज्जनं किं कोपि निषेद्धुं शक्नोति? ");
INSERT INTO sandev_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","ततः प्रभो र्नाम्ना मज्जिता भवतेति तानाज्ञापयत्। अनन्तरं ते स्वैः सार्द्धं कतिपयदिनानि स्थातुं प्रार्थयन्त। ");
INSERT INTO sandev_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","इत्थं भिन्नदेशीयलोका अपीश्वरस्य वाक्यम् अगृह्लन् इमां वार्त्तां यिहूदीयदेशस्थप्रेरिता भ्रातृगणश्च श्रुतवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ततः पितरे यिरूशालम्नगरं गतवति त्वक्छेदिनो लोकास्तेन सह विवदमाना अवदन्, ");
INSERT INTO sandev_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","त्वम् अत्वक्छेदिलोकानां गृहं गत्वा तैः सार्द्धं भुक्तवान्। ");
INSERT INTO sandev_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","ततः पितर आदितः क्रमशस्तत्कार्य्यस्य सर्व्ववृत्तान्तमाख्यातुम् आरब्धवान्। ");
INSERT INTO sandev_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","याफोनगर एकदाहं प्रार्थयमानो मूर्च्छितः सन् दर्शनेन चतुर्षु कोणेषु लम्बनमानं वृहद्वस्त्रमिव पात्रमेकम् आकाशदवरुह्य मन्निकटम् आगच्छद् अपश्यम्। ");
INSERT INTO sandev_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","पश्चात् तद् अनन्यदृष्ट्या दृष्ट्वा विविच्य तस्य मध्ये नानाप्रकारान् ग्राम्यवन्यपशून् उरोगामिखेचरांश्च दृष्टवान्; ");
INSERT INTO sandev_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","हे पितर त्वमुत्थाय गत्वा भुंक्ष्व मां सम्बोध्य कथयन्तं शब्दमेकं श्रुतवांश्च। ");
INSERT INTO sandev_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","ततोहं प्रत्यवदं, हे प्रभो नेत्थं भवतु, यतः किञ्चन निषिद्धम् अशुचि द्रव्यं वा मम मुखमध्यं कदापि न प्राविशत्। ");
INSERT INTO sandev_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","अपरम् ईश्वरो यत् शुचि कृतवान् तन्निषिद्धं न जानीहि द्वि र्माम्प्रतीदृशी विहायसीया वाणी जाता। ");
INSERT INTO sandev_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","त्रिरित्थं सति तत् सर्व्वं पुनराकाशम् आकृष्टं। ");
INSERT INTO sandev_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","पश्चात् कैसरियानगरात् त्रयो जना मन्निकटं प्रेषिता यत्र निवेशने स्थितोहं तस्मिन् समये तत्रोपातिष्ठन्। ");
INSERT INTO sandev_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","तदा निःसन्देहं तैः सार्द्धं यातुम् आत्मा मामादिष्टवान्; ततः परं मया सहैतेषु षड्भ्रातृषु गतेषु वयं तस्य मनुजस्य गृहं प्राविशाम। ");
INSERT INTO sandev_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","सोस्माकं निकटे कथामेताम् अकथयत् एकदा दूत एकः प्रत्यक्षीभूय मम गृहमध्ये तिष्टन् मामित्याज्ञापितवान्, याफोनगरं प्रति लोकान् प्रहित्य पितरनाम्ना विख्यातं शिमोनम् आहूयय; ");
INSERT INTO sandev_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ततस्तव त्वदीयपरिवाराणाञ्च येन परित्राणं भविष्यति तत् स उपदेक्ष्यति। ");
INSERT INTO sandev_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","अहं तां कथामुत्थाप्य कथितवान् तेन प्रथमम् अस्माकम् उपरि यथा पवित्र आत्मावरूढवान् तथा तेषामप्युपरि समवरूढवान्। ");
INSERT INTO sandev_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","तेन योहन् जले मज्जितवान् इति सत्यं किन्तु यूयं पवित्र आत्मनि मज्जिता भविष्यथ, इति यद्वाक्यं प्रभुरुदितवान् तत् तदा मया स्मृतम्। ");
INSERT INTO sandev_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","अतः प्रभा यीशुख्रीष्टे प्रत्ययकारिणो ये वयम् अस्मभ्यम् ईश्वरो यद् दत्तवान् तत् तेभ्यो लोकेभ्योपि दत्तवान् ततः कोहं? किमहम् ईश्वरं वारयितुं शक्नोमि? ");
INSERT INTO sandev_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","कथामेतां श्रुवा ते क्षान्ता ईश्वरस्य गुणान् अनुकीर्त्त्य कथितवन्तः, तर्हि परमायुःप्राप्तिनिमित्तम् ईश्वरोन्यदेशीयलोकेभ्योपि मनःपरिवर्त्तनरूपं दानम् अदात्। ");
INSERT INTO sandev_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","स्तिफानं प्रति उपद्रवे घटिते ये विकीर्णा अभवन् तै फैनीकीकुप्रान्तियखियासु भ्रमित्वा केवलयिहूदीयलोकान् विना कस्याप्यन्यस्य समीप ईश्वरस्य कथां न प्राचारयन्। ");
INSERT INTO sandev_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","अपरं तेषां कुप्रीयाः कुरीनीयाश्च कियन्तो जना आन्तियखियानगरं गत्वा यूनानीयलोकानां समीपेपि प्रभोर्यीशोः कथां प्राचारयन्। ");
INSERT INTO sandev_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","प्रभोः करस्तेषां सहाय आसीत् तस्माद् अनेके लोका विश्वस्य प्रभुं प्रति परावर्त्तन्त। ");
INSERT INTO sandev_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","इति वार्त्तायां यिरूशालमस्थमण्डलीयलोकानां कर्णगोचरीभूतायाम् आन्तियखियानगरं गन्तु ते बर्णब्बां प्रैरयन्। ");
INSERT INTO sandev_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ततो बर्णब्बास्तत्र उपस्थितः सन् ईश्वरस्यानुग्रहस्य फलं दृष्ट्वा सानन्दो जातः, ");
INSERT INTO sandev_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","स स्वयं साधु र्विश्वासेन पवित्रेणात्मना च परिपूर्णः सन् गनोनिष्टया प्रभावास्थां कर्त्तुं सर्व्वान् उपदिष्टवान् तेन प्रभोः शिष्या अनेके बभूवुः। ");
INSERT INTO sandev_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","शेषे शौलं मृगयितुं बर्णब्बास्तार्षनगरं प्रस्थितवान्। तत्र तस्योद्देशं प्राप्य तम् आन्तियखियानगरम् आनयत्; ");
INSERT INTO sandev_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ततस्तौ मण्डलीस्थलोकैः सभां कृत्वा संवत्सरमेकं यावद् बहुलोकान् उपादिशतां; तस्मिन् आन्तियखियानगरे शिष्याः प्रथमं ख्रीष्टीयनाम्ना विख्याता अभवन्। ");
INSERT INTO sandev_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","ततः परं भविष्यद्वादिगणे यिरूशालम आन्तियखियानगरम् आगते सति ");
INSERT INTO sandev_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","आगाबनामा तेषामेक उत्थाय आत्मनः शिक्षया सर्व्वदेशे दुर्भिक्षं भविष्यतीति ज्ञापितवान्; ततः क्लौदियकैसरस्याधिकारे सति तत् प्रत्यक्षम् अभवत्। ");
INSERT INTO sandev_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","तस्मात् शिष्या एकैकशः स्वस्वशक्त्यनुसारतो यिहूदीयदेशनिवासिनां भ्रतृणां दिनयापनार्थं धनं प्रेषयितुं निश्चित्य ");
INSERT INTO sandev_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","बर्णब्बाशौलयो र्द्वारा प्राचीनलोकानां समीपं तत् प्रेषितवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","तस्मिन् समये हेरोद्‌राजो मण्डल्याः कियज्जनेभ्यो दुःखं दातुं प्रारभत्। ");
INSERT INTO sandev_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","विशेषतो योहनः सोदरं याकूबं करवालाघातेन् हतवान्। ");
INSERT INTO sandev_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","तस्माद् यिहूदीयाः सन्तुष्टा अभवन् इति विज्ञाय स पितरमपि धर्त्तुं गतवान्। ");
INSERT INTO sandev_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","तदा किण्वशून्यपूपोत्सवसमय उपातिष्टत्; अत उत्सवे गते सति लोकानां समक्षं तं बहिरानेय्यामीति मनसि स्थिरीकृत्य स तं धारयित्वा रक्ष्णार्थम् येषाम् एकैकसंघे चत्वारो जनाः सन्ति तेषां चतुर्णां रक्षकसंघानां समीपे तं समर्प्य कारायां स्थापितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","किन्तुं पितरस्य कारास्थितिकारणात् मण्डल्या लोका अविश्रामम् ईश्वरस्य समीपे प्रार्थयन्त। ");
INSERT INTO sandev_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","अनन्तरं हेरोदि तं बहिरानायितुं उद्यते सति तस्यां रात्रौ पितरो रक्षकद्वयमध्यस्थाने शृङ्खलद्वयेन बद्ध्वः सन् निद्रित आसीत्, दौवारिकाश्च कारायाः सम्मुखे तिष्ठनतो द्वारम् अरक्षिषुः। ");
INSERT INTO sandev_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","एतस्मिन् समये परमेश्वरस्य दूते समुपस्थिते कारा दीप्तिमती जाता; ततः स दूतः पितरस्य कुक्षावावातं कृत्वा तं जागरयित्वा भाषितवान् तूर्णमुत्तिष्ठ; ततस्तस्य हस्तस्थशृङ्खलद्वयं गलत् पतितं। ");
INSERT INTO sandev_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","स दूतस्तमवदत्, बद्धकटिः सन् पादयोः पादुके अर्पय; तेन तथा कृते सति दूतस्तम् उक्तवान् गात्रीयवस्त्रं गात्रे निधाय मम पश्चाद् एहि। ");
INSERT INTO sandev_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ततः पितरस्तस्य पश्चाद् व्रजन बहिरगच्छत्, किन्तु दूतेन कर्म्मैतत् कृतमिति सत्यमज्ञात्वा स्वप्नदर्शनं ज्ञातवान्। ");
INSERT INTO sandev_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","इत्थं तौ प्रथमां द्वितीयाञ्च कारां लङ्घित्वा येन लौहनिर्म्मितद्वारेण नगरं गम्यते तत्समीपं प्राप्नुतां; ततस्तस्य कवाटं स्वयं मुक्तमभवत् ततस्तौ तत्स्थानाद् बहि र्भूत्वा मार्गैकस्य सीमां यावद् गतौ; ततोऽकस्मात् स दूतः पितरं त्यक्तवान्। ");
INSERT INTO sandev_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","तदा स चेतनां प्राप्य कथितवान् निजदूतं प्रहित्य परमेश्वरो हेरोदो हस्ताद् यिहूदीयलोकानां सर्व्वाशायाश्च मां समुद्धृतवान् इत्यहं निश्चयं ज्ञातवान्। ");
INSERT INTO sandev_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","स विविच्य मार्कनाम्रा विख्यातस्य योहनो मातु र्मरियमो यस्मिन् गृहे बहवः सम्भूय प्रार्थयन्त तन्निवेशनं गतः। ");
INSERT INTO sandev_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","पितरेण बहिर्द्वार आहते सति रोदानामा बालिका द्रष्टुं गता। ");
INSERT INTO sandev_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","ततः पितरस्य स्वरं श्रुवा सा हर्षयुक्ता सती द्वारं न मोचयित्वा पितरो द्वारे तिष्ठतीति वार्त्तां वक्तुम् अभ्यन्तरं धावित्वा गतवती। ");
INSERT INTO sandev_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","ते प्रावोचन् त्वमुन्मत्ता जातासि किन्तु सा मुहुर्मुहुरुक्तवती सत्यमेवैतत्। ");
INSERT INTO sandev_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","तदा ते कथितवन्तस्तर्हि तस्य दूतो भवेत्। ");
INSERT INTO sandev_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","पितरो द्वारमाहतवान् एतस्मिन्नन्तरे द्वारं मोचयित्वा पितरं दृष्ट्वा विस्मयं प्राप्ताः। ");
INSERT INTO sandev_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","ततः पितरो निःशब्दं स्थातुं तान् प्रति हस्तेन सङ्केतं कृत्वा परमेश्वरो येन प्रकारेण तं काराया उद्धृत्यानीतवान् तस्य वृत्तान्तं तानज्ञापयत्, यूयं गत्वा याकुबं भ्रातृगणञ्च वार्त्तामेतां वदतेत्युक्ता स्थानान्तरं प्रस्थितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","प्रभाते सति पितरः क्व गत इत्यत्र रक्षकाणां मध्ये महान् कलहो जातः। ");
INSERT INTO sandev_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","हेरोद् बहु मृगयित्वा तस्योद्देशे न प्राप्ते सति रक्षकान् संपृच्छ्य तेषां प्राणान् हन्तुम् आदिष्टवान्। ");
INSERT INTO sandev_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","पश्चात् स यिहूदीयप्रदेशात् कैसरियानगरं गत्वा तत्रावातिष्ठत्। ");
INSERT INTO sandev_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","सोरसीदोनदेशयो र्लोकेभ्यो हेरोदि युयुत्सौ सति ते सर्व्व एकमन्त्रणाः सन्तस्तस्य समीप उपस्थाय ल्वास्तनामानं तस्य वस्त्रगृहाधीशं सहायं कृत्वा हेरोदा सार्द्धं सन्धिं प्रार्थयन्त यतस्तस्य राज्ञो देशेन तेषां देशीयानां भरणम् अभवत्ं ");
INSERT INTO sandev_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","अतः कुत्रचिन् निरुपितदिने हेरोद् राजकीयं परिच्छदं परिधाय सिंहासने समुपविश्य तान् प्रति कथाम् उक्तवान्। ");
INSERT INTO sandev_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","ततो लोका उच्चैःकारं प्रत्यवदन्, एष मनुजरवो न हि, ईश्वरीयरवः। ");
INSERT INTO sandev_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","तदा हेरोद् ईश्वरस्य सम्मानं नाकरोत्; तस्माद्धेतोः परमेश्वरस्य दूतो हठात् तं प्राहरत् तेनैव स कीटैः क्षीणः सन् प्राणान् अजहात्। किन्त्वीश्वरस्य कथा देशं व्याप्य प्रबलाभवत्। ततः परं बर्णब्बाशौलौ यस्य कर्म्मणो भारं प्राप्नुतां ताभ्यां तस्मिन् सम्पादिते सति मार्कनाम्ना विख्यातो यो योहन् तं सङ्गिनं कृत्वा यिरूशालम्नगरात् प्रत्यागतौ। ");
INSERT INTO sandev_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","अपरञ्च बर्णब्बाः, शिमोन् यं निग्रं वदन्ति, कुरीनीयलूकियो हेरोदा राज्ञा सह कृतविद्यााभ्यासो मिनहेम्, शौलश्चैते ये कियन्तो जना भविष्यद्वादिन उपदेष्टारश्चान्तियखियानगरस्थमण्डल्याम् आसन्, ");
INSERT INTO sandev_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","ते यदोपवासं कृत्वेश्वरम् असेवन्त तस्मिन् समये पवित्र आत्मा कथितवान् अहं यस्मिन् कर्म्मणि बर्णब्बाशैलौ नियुक्तवान् तत्कर्म्म कर्त्तुं तौ पृथक् कुरुत। ");
INSERT INTO sandev_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","ततस्तैरुपवासप्रार्थनयोः कृतयोः सतोस्ते तयो र्गात्रयो र्हस्तार्पणं कृत्वा तौ व्यसृजन्। ");
INSERT INTO sandev_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","ततः परं तौ पवित्रेणात्मना प्रेरितौ सन्तौ सिलूकियानगरम् उपस्थाय समुद्रपथेन कुप्रोपद्वीपम् अगच्छतां। ");
INSERT INTO sandev_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ततः सालामीनगरम् उपस्थाय तत्र यिहूदीयानां भजनभवनानि गत्वेश्वरस्य कथां प्राचारयतां; योहनपि तत्सहचरोऽभवत्। ");
INSERT INTO sandev_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","इत्थं ते तस्योपद्वीपस्य सर्व्वत्र भ्रमन्तः पाफनगरम् उपस्थिताः; तत्र सुविवेचकेन सर्जियपौलनाम्ना तद्देशाधिपतिना सह भविष्यद्वादिनो वेशधारी बर्यीशुनामा यो मायावी यिहूदी आसीत् तं साक्षात् प्राप्तवतः। ");
INSERT INTO sandev_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","तद्देशाधिप ईश्वरस्य कथां श्रोतुं वाञ्छन् पौलबर्णब्बौ न्यमन्त्रयत्। ");
INSERT INTO sandev_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","किन्त्विलुमा यं मायाविनं वदन्ति स देशाधिपतिं धर्म्ममार्गाद् बहिर्भूतं कर्त्तुम् अयतत। ");
INSERT INTO sandev_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","तस्मात् शोलोऽर्थात् पौलः पवित्रेणात्मना परिपूर्णः सन् तं मायाविनं प्रत्यनन्यदृष्टिं कृत्वाकथयत्, ");
INSERT INTO sandev_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","हे नरकिन् धर्म्मद्वेषिन् कौटिल्यदुष्कर्म्मपरिपूर्ण, त्वं किं प्रभोः सत्यपथस्य विपर्य्ययकरणात् कदापि न निवर्त्तिष्यसे? ");
INSERT INTO sandev_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","अधुना परमेश्वरस्तव समुचितं करिष्यति तेन कतिपयदिनानि त्वम् अन्धः सन् सूर्य्यमपि न द्रक्ष्यसि। तत्क्षणाद् रात्रिवद् अन्धकारस्तस्य दृष्टिम् आच्छादितवान्; तस्मात् तस्य हस्तं धर्त्तुं स लोकमन्विच्छन् इतस्ततो भ्रमणं कृतवान्। ");
INSERT INTO sandev_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","एनां घटनां दृष्ट्वा स देशाधिपतिः प्रभूपदेशाद् विस्मित्य विश्वासं कृतवान्। ");
INSERT INTO sandev_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","तदनन्तरं पौलस्तत्सङ्गिनौ च पाफनगरात् प्रोतं चालयित्वा पम्फुलियादेशस्य पर्गीनगरम् अगच्छन् किन्तु योहन् तयोः समीपाद् एत्य यिरूशालमं प्रत्यागच्छत्। ");
INSERT INTO sandev_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","पश्चात् तौ पर्गीतो यात्रां कृत्वा पिसिदियादेशस्य आन्तियखियानगरम् उपस्थाय विश्रामवारे भजनभवनं प्रविश्य समुपाविशतां। ");
INSERT INTO sandev_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","व्यवस्थाभविष्यद्वाक्ययोः पठितयोः सतो र्हे भ्रातरौ लोकान् प्रति युवयोः काचिद् उपदेशकथा यद्यस्ति तर्हि तां वदतं तौ प्रति तस्य भजनभवनस्याधिपतयः कथाम् एतां कथयित्वा प्रैषयन्। ");
INSERT INTO sandev_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","अतः पौल उत्तिष्ठन् हस्तेन सङ्केतं कुर्व्वन् कथितवान् हे इस्रायेलीयमनुष्या ईश्वरपरायणाः सर्व्वे लोका यूयम् अवधद्धं। ");
INSERT INTO sandev_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","एतेषामिस्रायेल्लोकानाम् ईश्वरोऽस्माकं पूर्व्वपरुषान् मनोनीतान् कत्वा गृहीतवान् ततो मिसरि देशे प्रवसनकाले तेषामुन्नतिं कृत्वा तस्मात् स्वीयबाहुबलेन तान् बहिः कृत्वा समानयत्। ");
INSERT INTO sandev_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","चत्वारिंशद्वत्सरान् यावच्च महाप्रान्तरे तेषां भरणं कृत्वा ");
INSERT INTO sandev_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","किनान्देशान्तर्व्वर्त्तीणि सप्तराज्यानि नाशयित्वा गुटिकापातेन तेषु सर्व्वदेशेषु तेभ्योऽधिकारं दत्तवान्। ");
INSERT INTO sandev_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","पञ्चाशदधिकचतुःशतेषु वत्सरेषु गतेषु च शिमूयेल्भविष्यद्वादिपर्य्यन्तं तेषामुपरि विचारयितृन् नियुक्तवान्। ");
INSERT INTO sandev_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","तैश्च राज्ञि प्रार्थिते, ईश्वरो बिन्यामीनो वंशजातस्य कीशः पुत्रं शौलं चत्वारिंशद्वर्षपर्य्यन्तं तेषामुपरि राजानं कृतवान्। ");
INSERT INTO sandev_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","पश्चात् तं पदच्युतं कृत्वा यो मदिष्टक्रियाः सर्व्वाः करिष्यति तादृशं मम मनोभिमतम् एकं जनं यिशयः पुत्रं दायूदं प्राप्तवान् इदं प्रमाणं यस्मिन् दायूदि स दत्तवान् तं दायूदं तेषामुपरि राजत्वं कर्त्तुम् उत्पादितवान। ");
INSERT INTO sandev_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","तस्य स्वप्रतिश्रुतस्य वाक्यस्यानुसारेण इस्रायेल्लोकानां निमित्तं तेषां मनुष्याणां वंशाद् ईश्वर एकं यीशुं (त्रातारम्) उदपादयत्। ");
INSERT INTO sandev_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","तस्य प्रकाशनात् पूर्व्वं योहन् इस्रायेल्लोकानां सन्निधौ मनःपरावर्त्तनरूपं मज्जनं प्राचारयत्। ");
INSERT INTO sandev_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","यस्य च कर्म्मणोे भारं प्रप्तवान् योहन् तन् निष्पादयन् एतां कथां कथितवान्, यूयं मां कं जनं जानीथ? अहम् अभिषिक्तत्राता नहि, किन्तु पश्यत यस्य पादयोः पादुकयो र्बन्धने मोचयितुमपि योग्यो न भवामि तादृश एको जनो मम पश्चाद् उपतिष्ठति। ");
INSERT INTO sandev_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","हे इब्राहीमो वंशजाता भ्रातरो हे ईश्वरभीताः सर्व्वलोका युष्मान् प्रति परित्राणस्य कथैषा प्रेरिता। ");
INSERT INTO sandev_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","यिरूशालम्निवासिनस्तेषाम् अधिपतयश्च तस्य यीशोः परिचयं न प्राप्य प्रतिविश्रामवारं पठ्यमानानां भविष्यद्वादिकथानाम् अभिप्रायम् अबुद्ध्वा च तस्य वधेन ताः कथाः सफला अकुर्व्वन्। ");
INSERT INTO sandev_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","प्राणहननस्य कमपि हेतुम् अप्राप्यापि पीलातस्य निकटे तस्य वधं प्रार्थयन्त। ");
INSERT INTO sandev_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","तस्मिन् याः कथा लिखिताः सन्ति तदनुसारेण कर्म्म सम्पाद्य तं क्रुशाद् अवतार्य्य श्मशाने शायितवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","किन्त्वीश्वरः श्मशानात् तमुदस्थापयत्, ");
INSERT INTO sandev_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","पुनश्च गालीलप्रदेशाद् यिरूशालमनगरं तेन सार्द्धं ये लोका आगच्छन् स बहुदिनानि तेभ्यो दर्शनं दत्तवान्, अतस्त इदानीं लोकान् प्रति तस्य साक्षिणः सन्ति। ");
INSERT INTO sandev_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","अस्माकं पूर्व्वपुरुषाणां समक्षम् ईश्वरो यस्मिन् प्रतिज्ञातवान् यथा, त्वं मे पुत्रोसि चाद्य त्वां समुत्थापितवानहम्। ");
INSERT INTO sandev_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","इदं यद्वचनं द्वितीयगीते लिखितमास्ते तद् यीशोरुत्थानेन तेषां सन्ताना ये वयम् अस्माकं सन्निधौ तेन प्रत्यक्षी कृतं, युष्मान् इमं सुसंवादं ज्ञापयामि। ");
INSERT INTO sandev_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","परमेश्वरेण श्मशानाद् उत्थापितं तदीयं शरीरं कदापि न क्षेष्यते, एतस्मिन् स स्वयं कथितवान् यथा दायूदं प्रति प्रतिज्ञातो यो वरस्तमहं तुभ्यं दास्यामि। ");
INSERT INTO sandev_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","एतदन्यस्मिन् गीतेऽपि कथितवान्। स्वकीयं पुण्यवन्तं त्वं क्षयितुं न च दास्यसि। ");
INSERT INTO sandev_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","दायूदा ईश्वराभिमतसेवायै निजायुषि व्ययिते सति स महानिद्रां प्राप्य निजैः पूर्व्वपुरुषैः सह मिलितः सन् अक्षीयत; ");
INSERT INTO sandev_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","किन्तु यमीश्वरः श्मशानाद् उदस्थापयत् स नाक्षीयत। ");
INSERT INTO sandev_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","अतो हे भ्रातरः, अनेन जनेन पापमोचनं भवतीति युष्मान् प्रति प्रचारितम् आस्ते। ");
INSERT INTO sandev_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","फलतो मूसाव्यवस्थया यूयं येभ्यो दोषेभ्यो मुक्ता भवितुं न शक्ष्यथ तेभ्यः सर्व्वदोषेभ्य एतस्मिन् जने विश्वासिनः सर्व्वे मुक्ता भविष्यन्तीति युष्माभि र्ज्ञायतां। ");
INSERT INTO sandev_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","अपरञ्च। अवज्ञाकारिणो लोकाश्चक्षुरुन्मील्य पश्यत। तथैवासम्भवं ज्ञात्वा स्यात यूयं विलज्जिताः। यतो युष्मासु तिष्ठत्सु करिष्ये कर्म्म तादृशं। येनैव तस्य वृत्तान्ते युष्मभ्यं कथितेऽपि हि। यूयं न तन्तु वृत्तान्तं प्रत्येष्यथ कदाचन॥ ");
INSERT INTO sandev_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","येयं कथा भविष्यद्वादिनां ग्रन्थेषु लिखितास्ते सावधाना भवत स कथा यथा युष्मान् प्रति न घटते। ");
INSERT INTO sandev_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","यिहूदीयभजनभवनान् निर्गतयोस्तयो र्भिन्नदेशीयै र्वक्ष्यमाणा प्रार्थना कृता, आगामिनि विश्रामवारेऽपि कथेयम् अस्मान् प्रति प्रचारिता भवत्विति। ");
INSERT INTO sandev_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","सभाया भङ्गे सति बहवो यिहूदीयलोका यिहूदीयमतग्राहिणो भक्तलोकाश्च बर्णब्बापौलयोः पश्चाद् आगच्छन्, तेन तौ तैः सह नानाकथाः कथयित्वेश्वरानुग्रहाश्रये स्थातुं तान् प्रावर्त्तयतां। ");
INSERT INTO sandev_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","परविश्रामवारे नगरस्य प्रायेण सर्व्वे लाका ईश्वरीयां कथां श्रोतुं मिलिताः, ");
INSERT INTO sandev_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","किन्तु यिहूदीयलोका जननिवहं विलोक्य ईर्ष्यया परिपूर्णाः सन्तो विपरीतकथाकथनेनेश्वरनिन्दया च पौलेनोक्तां कथां खण्डयितुं चेष्टितवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","ततः पौैलबर्णब्बावक्षोभौ कथितवन्तौ प्रथमं युष्माकं सन्निधावीश्वरीयकथायाः प्रचारणम् उचितमासीत् किन्तुं तदग्राह्यत्वकरणेन यूयं स्वान् अनन्तायुषोऽयोग्यान् दर्शयथ, एतत्कारणाद् वयम् अन्यदेशीयलोकानां समीपं गच्छामः। ");
INSERT INTO sandev_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","प्रभुरस्मान् इत्थम् आदिष्टवान् यथा, यावच्च जगतः सीमां लोकानां त्राणकारणात्। मयान्यदेशमध्ये त्वं स्थापितो भूः प्रदीपवत्॥ ");
INSERT INTO sandev_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","तदा कथामीदृशीं श्रुत्वा भिन्नदेशीया आह्लादिताः सन्तः प्रभोः कथां धन्यां धन्याम् अवदन्, यावन्तो लोकाश्च परमायुः प्राप्तिनिमित्तं निरूपिता आसन् तेे व्यश्वसन्। ");
INSERT INTO sandev_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","इत्थं प्रभोः कथा सर्व्वेदेशं व्याप्नोत्। ");
INSERT INTO sandev_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","किन्तु यिहूदीया नगरस्य प्रधानपुरुषान् सम्मान्याः कथिपया भक्ता योषितश्च कुप्रवृत्तिं ग्राहयित्वा पौलबर्णब्बौ ताडयित्वा तस्मात् प्रदेशाद् दूरीकृतवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","अतः कारणात् तौ निजपदधूलीस्तेषां प्रातिकूल्येन पातयित्वेेकनियं नगरं गतौ। ");
INSERT INTO sandev_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","ततः शिष्यगण आनन्देन पवित्रेणात्मना च परिपूर्णोभवत्। ");
INSERT INTO sandev_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","तौ द्वौ जनौ युगपद् इकनियनगरस्थयिहूदीयानां भजनभवनं गत्वा यथा बहवो यिहूदीया अन्यदेेशीयलोकाश्च व्यश्वसन् तादृशीं कथां कथितवन्तौ। ");
INSERT INTO sandev_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","किन्तु विश्वासहीना यिहूदीया अन्यदेशीयलोकान् कुप्रवृत्तिं ग्राहयित्वा भ्रातृगणं प्रति तेषां वैरं जनितवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","अतः स्वानुग्रहकथायाः प्रमाणं दत्वा तयो र्हस्तै र्बहुलक्षणम् अद्भुतकर्म्म च प्राकाशयद् यः प्रभुस्तस्य कथा अक्षोभेन प्रचार्य्य तौ तत्र बहुदिनानि समवातिष्ठेतां। ");
INSERT INTO sandev_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","किन्तु कियन्तो लोका यिहूदीयानां सपक्षाः कियन्तो लोकाः प्रेरितानां सपक्षा जाताः, अतो नागरिकजननिवहमध्ये भिन्नवाक्यत्वम् अभवत्। ");
INSERT INTO sandev_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","अन्यदेशीया यिहूदीयास्तेषाम् अधिपतयश्च दौरात्म्यं कुत्वा तौ प्रस्तरैराहन्तुम् उद्यताः। ");
INSERT INTO sandev_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","तौ तद्वार्त्तां प्राप्य पलायित्वा लुकायनियादेशस्यान्तर्व्वर्त्तिलुस्त्रादर्ब्बो ");
INSERT INTO sandev_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","तत्समीपस्थदेशञ्च गत्वा तत्र सुसंवादं प्रचारयतां। ");
INSERT INTO sandev_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","तत्रोभयपादयोश्चलनशक्तिहीनो जन्मारभ्य खञ्जः कदापि गमनं नाकरोत् एतादृश एको मानुषो लुस्त्रानगर उपविश्य पौलस्य कथां श्रुतवान्। ");
INSERT INTO sandev_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","एतस्मिन् समये पौलस्तम्प्रति दृष्टिं कृत्वा तस्य स्वास्थ्ये विश्वासं विदित्वा प्रोच्चैः कथितवान् ");
INSERT INTO sandev_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","पद्भ्यामुत्तिष्ठन् ऋजु र्भव।ततः स उल्लम्फं कृत्वा गमनागमने कुतवान्। ");
INSERT INTO sandev_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","तदा लोकाः पौलस्य तत् कार्य्यं विलोक्य लुकायनीयभाषया प्रोच्चैः कथामेतां कथितवन्तः, देवा मनुष्यरूपं धृत्वास्माकं समीपम् अवारोहन्। ");
INSERT INTO sandev_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","ते बर्णब्बां यूपितरम् अवदन् पौलश्च मुख्यो वक्ता तस्मात् तं मर्कुरियम् अवदन्। ");
INSERT INTO sandev_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","तस्य नगरस्य सम्मुखे स्थापितस्य यूपितरविग्रहस्य याजको वृषान् पुष्पमालाश्च द्वारसमीपम् आनीय लोकैः सर्द्धं तावुद्दिश्य समुत्सृज्य दातुम् उद्यतः। ");
INSERT INTO sandev_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","तद्वार्त्तां श्रुत्वा बर्णब्बापौलौ स्वीयवस्त्राणि छित्वा लोकानां मध्यं वेगेन प्रविश्य प्रोच्चैः कथितवन्तौ, ");
INSERT INTO sandev_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","हे महेच्छाः कुत एतादृशं कर्म्म कुरुथ? आवामपि युष्मादृशौ सुखदुःखभोगिनौ मनुष्यौ, युयम् एताः सर्व्वा वृथाकल्पनाः परित्यज्य यथा गगणवसुन्धराजलनिधीनां तन्मध्यस्थानां सर्व्वेषाञ्च स्रष्टारममरम् ईश्वरं प्रति परावर्त्तध्वे तदर्थम् आवां युष्माकं सन्निधौ सुसंवादं प्रचारयावः। ");
INSERT INTO sandev_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","स ईश्वरः पूर्व्वकाले सर्व्वदेशीयलोकान् स्वस्वमार्गे चलितुमनुमतिं दत्तवान्, ");
INSERT INTO sandev_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","तथापि आकाशात् तोयवर्षणेन नानाप्रकारशस्योत्पत्या च युष्माकं हितैषी सन् भक्ष्यैराननदेन च युष्माकम् अन्तःकरणानि तर्पयन् तानि दानानि निजसाक्षिस्वरूपाणि स्थपितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","किन्तु तादृशायां कथायां कथितायामपि तयोः समीप उत्सर्जनात् लोकनिवहं प्रायेण निवर्त्तयितुं नाशक्नुताम्। ");
INSERT INTO sandev_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","आन्तियखिया-इकनियनगराभ्यां कतिपययिहूदीयलोका आगत्य लोकान् प्रावर्त्तयन्त तस्मात् तै पौलं प्रस्तरैराघ्नन् तेन स मृत इति विज्ञाय नगरस्य बहिस्तम् आकृष्य नीतवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","किन्तु शिष्यगणे तस्य चतुर्दिशि तिष्ठति सति स स्वयम् उत्थाय पुनरपि नगरमध्यं प्राविशत् तत्परेऽहनि बर्णब्बासहितो दर्ब्बीनगरं गतवान्। ");
INSERT INTO sandev_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","तत्र सुसंवादं प्रचार्य्य बहुलोकान् शिष्यान् कृत्वा तौ लुस्त्राम् इकनियम् आन्तियखियाञ्च परावृत्य गतौ। ");
INSERT INTO sandev_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","बहुदुःखानि भुक्त्वापीश्वरराज्यं प्रवेष्टव्यम् इति कारणाद् धर्म्ममार्गे स्थातुं विनयं कृत्वा शिष्यगणस्य मनःस्थैर्य्यम् अकुरुतां। ");
INSERT INTO sandev_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","मण्डलीनां प्राचीनवर्गान् नियुज्य प्रार्थनोपवासौ कृत्वा यत्प्रभौ ते व्यश्वसन् तस्य हस्ते तान् समर्प्य ");
INSERT INTO sandev_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","पिसिदियामध्येन पाम्फुलियादेशं गतवन्तौ। ");
INSERT INTO sandev_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","पश्चात् पर्गानगरं गत्वा सुसंवादं प्रचार्य्य अत्तालियानगरं प्रस्थितवन्तौ। ");
INSERT INTO sandev_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","तस्मात् समुद्रपथेन गत्वा ताभ्यां यत् कर्म्म सम्पन्नं तत्कर्म्म साधयितुं यन्नगरे दयालोरीश्वरस्य हस्ते समर्पितौ जातौ तद् आन्तियखियानगरं गतवन्ता। ");
INSERT INTO sandev_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","तत्रोपस्थाय तन्नगरस्थमण्डलीं संगृह्य स्वाभ्याम ईश्वरो यद्यत् कर्म्मकरोत् तथा येन प्रकारेण भिन्नदेशीयलोकान् प्रति विश्वासरूपद्वारम् अमोचयद् एतान् सर्व्ववृत्तान्तान् तान् ज्ञापितवन्तौ। ");
INSERT INTO sandev_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ततस्तौ शिर्य्यैः सार्द्धं तत्र बहुदिनानि न्यवसताम्। ");
INSERT INTO sandev_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","यिहूदादेशात् कियन्तो जना आगत्य भ्रातृगणमित्थं शिक्षितवन्तो मूसाव्यवस्थया यदि युष्माकं त्वक्छेदो न भवति तर्हि यूयं परित्राणं प्राप्तुं न शक्ष्यथ। ");
INSERT INTO sandev_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","पौलबर्णब्बौ तैः सह बहून् विचारान् विवादांश्च कृतवन्तौ, ततो मण्डलीयनोका एतस्याः कथायास्तत्त्वं ज्ञातुं यिरूशालम्नगरस्थान् प्रेरितान् प्राचीनांश्च प्रति पौलबर्णब्बाप्रभृतीन् कतिपयजनान् प्रेषयितुं निश्चयं कृतवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","ते मण्डल्या प्रेरिताः सन्तः फैणीकीशोमिरोन्देशाभ्यां गत्वा भिन्नदेशीयानां मनःपरिवर्त्तनस्य वार्त्तया भ्रातृणां परमाह्लादम् अजनयन्। ");
INSERT INTO sandev_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","यिरूशालम्युपस्थाय प्रेरितगणेन लोकप्राचीनगणेन समाजेन च समुपगृहीताः सन्तः स्वैरीश्वरो यानि कर्म्माणि कृतवान् तेषां सर्व्ववृत्तान्तान् तेषां समक्षम् अकथयन्। ");
INSERT INTO sandev_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","किन्तु विश्वासिनः कियन्तः फिरूशिमतग्राहिणो लोका उत्थाय कथामेतां कथितवन्तो भिन्नदेशीयानां त्वक्छेदं कर्त्तुं मूसाव्यवस्थां पालयितुञ्च समादेष्टव्यम्। ");
INSERT INTO sandev_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","ततः प्रेरिता लोकप्राचीनाश्च तस्य विवेचनां कर्त्तुं सभायां स्थितवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","बहुविचारेषु जातषु पितर उत्थाय कथितवान्, हे भ्रातरो यथा भिन्नदेशीयलोका मम मुखात् सुसंवादं श्रुत्वा विश्वसन्ति तदर्थं बहुदिनात् पूर्व्वम् ईश्वरोस्माकं मध्ये मां वृत्वा नियुक्तवान्। ");
INSERT INTO sandev_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","अन्तर्य्यामीश्वरो यथास्मभ्यं तथा भिन्नदेशीयेभ्यः पवित्रमात्मानं प्रदाय विश्वासेन तेषाम् अन्तःकरणानि पवित्राणि कृत्वा ");
INSERT INTO sandev_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","तेषाम् अस्माकञ्च मध्ये किमपि विशेषं न स्थापयित्वा तानधि स्वयं प्रमाणं दत्तवान् इति यूयं जानीथ। ");
INSERT INTO sandev_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","अतएवास्माकं पूर्व्वपुरुषा वयञ्च स्वयं यद्युगस्य भारं सोढुं न शक्ताः सम्प्रति तं शिष्यगणस्य स्कन्धेषु न्यसितुं कुत ईश्वरस्य परीक्षां करिष्यथ? ");
INSERT INTO sandev_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","प्रभो र्यीशुख्रीष्टस्यानुग्रहेण ते यथा वयमपि तथा परित्राणं प्राप्तुम् आशां कुर्म्मः। ");
INSERT INTO sandev_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","अनन्तरं बर्णब्बापौलाभ्याम् ईश्वरो भिन्नदेशीयानां मध्ये यद्यद् आश्चर्य्यम् अद्भुतञ्च कर्म्म कृतवान् तद्वृत्तान्तं तौ स्वमुखाभ्याम् अवर्णयतां सभास्थाः सर्व्वे नीरवाः सन्तः श्रुतवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","तयोः कथायां समाप्तायां सत्यां याकूब् कथयितुम् आरब्धवान् ");
INSERT INTO sandev_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","हे भ्रातरो मम कथायाम् मनो निधत्त। ईश्वरः स्वनामार्थं भिन्नदेशीयलोकानाम् मध्याद् एकं लोकसंघं ग्रहीतुं मतिं कृत्वा येन प्रकारेण प्रथमं तान् प्रति कृपावलेकनं कृतवान् तं शिमोन् वर्णितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","भविष्यद्वादिभिरुक्तानि यानि वाक्यानि तैः सार्द्धम् एतस्यैक्यं भवति यथा लिखितमास्ते। ");
INSERT INTO sandev_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","सर्व्वेषां कर्म्मणां यस्तु साधकः परमेश्वरः। स एवेदं वदेद्वाक्यं शेषाः सकलमानवाः। भिन्नदेशीयलोकाश्च यावन्तो मम नामतः। भवन्ति हि सुविख्यातास्ते यथा परमेशितुः। ");
INSERT INTO sandev_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","तत्वं सम्यक् समीहन्ते तन्निमित्तमहं किल। परावृत्य समागत्य दायूदः पतितं पुनः। दूष्यमुत्थापयिष्यामि तदीयं सर्व्ववस्तु च। पतितं पुनरुथाप्य सज्जयिष्यामि सर्व्वथा॥ ");
INSERT INTO sandev_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","आ प्रथमाद् ईश्वरः स्वीयानि सर्व्वकर्म्माणि जानाति। ");
INSERT INTO sandev_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","अतएव मम निवेदनमिदं भिन्नदेशीयलोकानां मध्ये ये जना ईश्वरं प्रति परावर्त्तन्त तेषामुपरि अन्यं कमपि भारं न न्यस्य ");
INSERT INTO sandev_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","देवताप्रसादाशुचिभक्ष्यं व्यभिचारकर्म्म कण्ठसम्पीडनमारितप्राणिभक्ष्यं रक्तभक्ष्यञ्च एतानि परित्यक्तुं लिखामः। ");
INSERT INTO sandev_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","यतः पूर्व्वकालतो मूसाव्यवस्थाप्रचारिणो लोका नगरे नगरे सन्ति प्रतिविश्रामवारञ्च भजनभवने तस्याः पाठो भवति। ");
INSERT INTO sandev_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","ततः परं प्रेरितगणो लोकप्राचीनगणः सर्व्वा मण्डली च स्वेषां मध्ये बर्शब्बा नाम्ना विख्यातो मनोनीतौ कृत्वा पौलबर्णब्बाभ्यां सार्द्धम् आन्तियखियानगरं प्रति प्रेषणम् उचितं बुद्ध्वा ताभ्यां पत्रं प्रैषयन्। ");
INSERT INTO sandev_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","तस्मिन् पत्रे लिखितमिंद, आन्तियखिया-सुरिया-किलिकियादेशस्थभिन्नदेशीयभ्रातृगणाय प्रेरितगणस्य लोकप्राचीनगणस्य भ्रातृगणस्य च नमस्कारः। ");
INSERT INTO sandev_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","विशेषतोऽस्माकम् आज्ञाम् अप्राप्यापि कियन्तो जना अस्माकं मध्याद् गत्वा त्वक्छेदो मूसाव्यवस्था च पालयितव्याविति युष्मान् शिक्षयित्वा युष्माकं मनसामस्थैर्य्यं कृत्वा युष्मान् ससन्देहान् अकुर्व्वन् एतां कथां वयम् अशृन्म। ");
INSERT INTO sandev_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","तत्कारणाद् वयम् एकमन्त्रणाः सन्तः सभायां स्थित्वा प्रभो र्यीशुख्रीष्टस्य नामनिमित्तं मृत्युमुखगताभ्यामस्माकं ");
INSERT INTO sandev_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","प्रियबर्णब्बापौलाभ्यां सार्द्धं मनोनीतलोकानां केषाञ्चिद् युष्माकं सन्निधौ प्रेषणम् उचितं बुद्धवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","अतो यिहूदासीलौ युष्मान् प्रति प्रेषितवन्तः, एतयो र्मुखाभ्यां सर्व्वां कथां ज्ञास्यथ। ");
INSERT INTO sandev_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","देवताप्रसादभक्ष्यं रक्तभक्ष्यं गलपीडनमारितप्राणिभक्ष्यं व्यभिचारकर्म्म चेमानि सर्व्वाणि युष्माभिस्त्याज्यानि; एतत्प्रयोजनीयाज्ञाव्यतिरेकेन युष्माकम् उपरि भारमन्यं न न्यसितुं पवित्रस्यात्मनोऽस्माकञ्च उचितज्ञानम् अभवत्। ");
INSERT INTO sandev_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","अतएव तेभ्यः सर्व्वेभ्यः स्वेषु रक्षितेषु यूयं भद्रं कर्म्म करिष्यथ। युष्माकं मङ्गलं भूयात्। ");
INSERT INTO sandev_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","तेे विसृष्टाः सन्त आन्तियखियानगर उपस्थाय लोकनिवहं संगृह्य पत्रम् अददन्। ");
INSERT INTO sandev_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ततस्ते तत्पत्रं पठित्वा सान्त्वनां प्राप्य सानन्दा अभवन्। ");
INSERT INTO sandev_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","यिहूदासीलौ च स्वयं प्रचारकौ भूत्वा भ्रातृगणं नानोपदिश्य तान् सुस्थिरान् अकुरुताम्। ");
INSERT INTO sandev_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","इत्थं तौ तत्र तैः साकं कतिपयदिनानि यापयित्वा पश्चात् प्रेरितानां समीपे प्रत्यागमनार्थं तेषां सन्निधेः कल्याणेन विसृष्टावभवतां। ");
INSERT INTO sandev_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","किन्तु सीलस्तत्र स्थातुं वाञ्छितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","अपरं पौलबर्णब्बौ बहवः शिष्याश्च लोकान् उपदिश्य प्रभोः सुसंवादं प्रचारयन्त आन्तियखियायां कालं यापितवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","कतिपयदिनेषु गतेषु पौलो बर्णब्बाम् अवदत् आगच्छावां येषु नगरेष्वीश्वरस्य सुसंवादं प्रचारितवन्तौ तानि सर्व्वनगराणि पुनर्गत्वा भ्रातरः कीदृशाः सन्तीति द्रष्टुं तान् साक्षात् कुर्व्वः। ");
INSERT INTO sandev_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","तेन मार्कनाम्ना विख्यातं योहनं सङ्गिनं कर्त्तुं बर्णब्बा मतिमकरोत्, ");
INSERT INTO sandev_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","किन्तु स पूर्व्वं ताभ्यां सह कार्य्यार्थं न गत्वा पाम्फूलियादेशे तौ त्यक्तवान् तत्कारणात् पौलस्तं सङ्गिनं कर्त्तुम् अनुचितं ज्ञातवान्। ");
INSERT INTO sandev_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","इत्थं तयोरतिशयविरोधस्योपस्थितत्वात् तौ परस्परं पृथगभवतां ततो बर्णब्बा मार्कं गृहीत्वा पोतेन कुप्रोपद्वीपं गतवान्; ");
INSERT INTO sandev_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","किन्तु पौलः सीलं मनोनीतं कृत्वा भ्रातृभिरीश्वरानुग्रहे समर्पितः सन् प्रस्थाय ");
INSERT INTO sandev_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","सुरियाकिलिकियादेशाभ्यां मण्डलीः स्थिरीकुर्व्वन् अगच्छत्। ");
INSERT INTO sandev_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","पौलो दर्ब्बीलुस्त्रानगरयोरुपस्थितोभवत् तत्र तीमथियनामा शिष्य एक आसीत्; स विश्वासिन्या यिहूदीयाया योषितो गर्ब्भजातः किन्तु तस्य पितान्यदेशीयलोकः। ");
INSERT INTO sandev_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","स जनो लुस्त्रा-इकनियनगरस्थानां भ्रातृणां समीपेपि सुख्यातिमान् आसीत्। ");
INSERT INTO sandev_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","पौलस्तं स्वसङ्गिनं कर्त्तुं मतिं कृत्वा तं गृहीत्वा तद्देशनिवासिनां यिहूदीयानाम् अनुरोधात् तस्य त्वक्छेदं कृतवान् यतस्तस्य पिता भिन्नदेशीयलोक इति सर्व्वैरज्ञायत। ");
INSERT INTO sandev_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","ततः परं ते नगरे नगरे भ्रमित्वा यिरूशालमस्थैः प्रेरितै र्लोकप्राचीनैश्च निरूपितं यद् व्यवस्थापत्रं तदनुसारेणाचरितुं लोकेभ्यस्तद् दत्तवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","तेनैव सर्व्वे धर्म्मसमाजाः ख्रीष्टधर्म्मे सुस्थिराः सन्तः प्रतिदिनं वर्द्धिता अभवन्। ");
INSERT INTO sandev_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","तेषु फ्रुगियागालातियादेशमध्येन गतेषु सत्सु पवित्र आत्मा तान् आशियादेशे कथां प्रकाशयितुं प्रतिषिद्धवान्। ");
INSERT INTO sandev_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","तथा मुसियादेश उपस्थाय बिथुनियां गन्तुं तैरुद्योगे कृते आत्मा तान् नान्वमन्यत। ");
INSERT INTO sandev_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","तस्मात् ते मुसियादेशं परित्यज्य त्रोयानगरं गत्वा समुपस्थिताः। ");
INSERT INTO sandev_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","रात्रौ पौलः स्वप्ने दृष्टवान् एको माकिदनियलोकस्तिष्ठन् विनयं कृत्वा तस्मै कथयति, माकिदनियादेशम् आगत्यास्मान् उपकुर्व्विति। ");
INSERT INTO sandev_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","तस्येत्थं स्वप्नदर्शनात् प्रभुस्तद्देशीयलोकान् प्रति सुसंवादं प्रचारयितुम् अस्मान् आहूयतीति निश्चितं बुद्ध्वा वयं तूर्णं माकिदनियादेशं गन्तुम् उद्योगम् अकुर्म्म। ");
INSERT INTO sandev_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","ततः परं वयं त्रोयानगराद् प्रस्थाय ऋजुमार्गेण सामथ्राकियोपद्वीपेन गत्वा परेऽहनि नियापलिनगर उपस्थिताः। ");
INSERT INTO sandev_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","तस्माद् गत्वा माकिदनियान्तर्व्वर्त्ति रोमीयवसतिस्थानं यत् फिलिपीनामप्रधाननगरं तत्रोपस्थाय कतिपयदिनानि तत्र स्थितवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","विश्रामवारे नगराद् बहि र्गत्वा नदीतटे यत्र प्रार्थनाचार आसीत् तत्रोपविश्य समागता नारीः प्रति कथां प्राचारयाम। ");
INSERT INTO sandev_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","ततः थुयातीरानगरीया धूषराम्बरविक्रायिणी लुदियानामिका या ईश्वरसेविका योषित् श्रोत्रीणां मध्य आसीत् तया पौलोक्तवाक्यानि यद् गृह्यन्ते तदर्थं प्रभुस्तस्या मनोद्वारं मुक्तवान्। ");
INSERT INTO sandev_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","अतः सा योषित् सपरिवारा मज्जिता सती विनयं कृत्वा कथितवती, युष्माकं विचाराद् यदि प्रभौ विश्वासिनी जाताहं तर्हि मम गृहम् आगत्य तिष्ठत। इत्थं सा यत्नेनास्मान् अस्थापयत्। ");
INSERT INTO sandev_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","यस्या गणनया तदधिपतीनां बहुधनोपार्जनं जातं तादृशी गणकभूतग्रस्ता काचन दासी प्रार्थनास्थानगमनकाल आगत्यास्मान् साक्षात् कृतवती। ");
INSERT INTO sandev_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","सास्माकं पौलस्य च पश्चाद् एत्य प्रोच्चैः कथामिमां कथितवती, मनुष्या एते सर्व्वोपरिस्थस्येश्वरस्य सेवकाः सन्तोऽस्मान् प्रति परित्राणस्य मार्गं प्रकाशयन्ति। ");
INSERT INTO sandev_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","सा कन्या बहुदिनानि तादृशम् अकरोत् तस्मात् पौलो दुःखितः सन् मुखं परावर्त्य तं भूतमवदद्, अहं यीशुख्रीष्टस्य नाम्ना त्वामाज्ञापयामि त्वमस्या बहिर्गच्छ; तेनैव तत्क्षणात् स भूतस्तस्या बहिर्गतः। ");
INSERT INTO sandev_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","ततः स्वेषां लाभस्य प्रत्याशा विफला जातेति विलोक्य तस्याः प्रभवः पौलं सीलञ्च धृत्वाकृष्य विचारस्थानेऽधिपतीनां समीपम् आनयन्। ");
INSERT INTO sandev_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ततः शासकानां निकटं नीत्वा रोमिलोका वयम् अस्माकं यद् व्यवहरणं ग्रहीतुम् आचरितुञ्च निषिद्धं, ");
INSERT INTO sandev_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","इमे यिहूदीयलोकाः सन्तोपि तदेव शिक्षयित्वा नगरेऽस्माकम् अतीव कलहं कुर्व्वन्ति, ");
INSERT INTO sandev_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","इति कथिते सति लोकनिवहस्तयोः प्रातिकूल्येनोदतिष्ठत् तथा शासकास्तयो र्वस्त्राणि छित्वा वेत्राघातं कर्त्तुम् आज्ञापयन्। ");
INSERT INTO sandev_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","अपरं ते तौ बहु प्रहार्य्य त्वमेतौ कारां नीत्वा सावधानं रक्षयेति कारारक्षकम् आदिशन्। ");
INSERT INTO sandev_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","इत्थम् आज्ञां प्राप्य स तावभ्यन्तरस्थकारां नीत्वा पादेषु पादपाशीभि र्बद्ध्वा स्थापितावान्। ");
INSERT INTO sandev_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","अथ निशीथसमये पौलसीलावीश्वरमुद्दिश्य प्राथनां गानञ्च कृतवन्तौ, कारास्थिता लोकाश्च तदशृण्वन् ");
INSERT INTO sandev_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","तदाकस्मात् महान् भूमिकम्पोऽभवत् तेन भित्तिमूलेन सह कारा कम्पिताभूत् तत्क्षणात् सर्व्वाणि द्वाराणि मुक्तानि जातानि सर्व्वेषां बन्धनानि च मुक्तानि। ");
INSERT INTO sandev_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","अतएव कारारक्षको निद्रातो जागरित्वा काराया द्वाराणि मुक्तानि दृष्ट्वा बन्दिलोकाः पलायिता इत्यनुमाय कोषात् खङ्गं बहिः कृत्वात्मघातं कर्त्तुम् उद्यतः। ");
INSERT INTO sandev_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","किन्तु पौलः प्रोच्चैस्तमाहूय कथितवान् पश्य वयं सर्व्वेऽत्रास्महे, त्वं निजप्राणहिंसां माकार्षीः। ");
INSERT INTO sandev_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","तदा प्रदीपम् आनेतुम् उक्त्वा स कम्पमानः सन् उल्लम्प्याभ्यन्तरम् आगत्य पौलसीलयोः पादेषु पतितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","पश्चात् स तौ बहिरानीय पृष्टवान् हे महेच्छौ परित्राणं प्राप्तुं मया किं कर्त्तव्यं? ");
INSERT INTO sandev_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","पश्चात् तौ स्वगृहमानीय तयोः सम्मुखे खाद्यद्रव्याणि स्थापितवान् तथा स स्वयं तदीयाः सर्व्वे परिवाराश्चेश्वरे विश्वसन्तः सानन्दिता अभवन्। ");
INSERT INTO sandev_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","तस्मै तस्य गृहस्थितसर्व्वलोकेभ्यश्च प्रभोः कथां कथितवन्तौ। ");
INSERT INTO sandev_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","तथा रात्रेस्तस्मिन्नेव दण्डे स तौ गृहीत्वा तयोः प्रहाराणां क्षतानि प्रक्षालितवान् ततः स स्वयं तस्य सर्व्वे परिजनाश्च मज्जिता अभवन्। ");
INSERT INTO sandev_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","पश्चात् तौ स्वगृहमानीय तयोः सम्मुखे खाद्यद्रव्याणि स्थापितवान् तथा स स्वयं तदीयाः सर्व्वे परिवाराश्चेश्वरे विश्वसन्तः सानन्दिता अभवन्। ");
INSERT INTO sandev_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","दिन उपस्थिते तौ लोकौ मोचयेति कथां कथयितुं शासकाः पदातिगणं प्रेषितवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","ततः कारारक्षकः पौलाय तां वार्त्तां कथितवान् युवां त्याजयितुं शासका लोकान प्रेषितवन्त इदानीं युवां बहि र्भूत्वा कुशलेन प्रतिष्ठेतां। ");
INSERT INTO sandev_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","किन्तु पौलस्तान् अवदत् रोमिलोकयोरावयोः कमपि दोषम् न निश्चित्य सर्व्वेषां समक्षम् आवां कशया ताडयित्वा कारायां बद्धवन्त इदानीं किमावां गुप्तं विस्त्रक्ष्यन्ति? तन्न भविष्यति, स्वयमागत्यावां बहिः कृत्वा नयन्तु। ");
INSERT INTO sandev_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","तदा पदातिभिः शासकेभ्य एतद्वार्त्तायां कथितायां तौ रोमिलोकाविति कथां श्रुत्वा ते भीताः ");
INSERT INTO sandev_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","सन्तस्तयोः सन्निधिमागत्य विनयम् अकुर्व्वन् अपरं बहिः कृत्वा नगरात् प्रस्थातुं प्रार्थितवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ततस्तौ काराया निर्गत्य लुदियाया गृहं गतवन्तौ तत्र भ्रातृगणं साक्षात्कृत्य तान् सान्त्वयित्वा तस्मात् स्थानात् प्रस्थितौ। ");
INSERT INTO sandev_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","पौलसीलौ आम्फिपल्यापल्लोनियानगराभ्यां गत्वा यत्र यिहूदीयानां भजनभवनमेकम् आस्ते तत्र थिषलनीकीनगर उपस्थितौ। ");
INSERT INTO sandev_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","तदा पौलः स्वाचारानुसारेण तेषां समीपं गत्वा विश्रामवारत्रये तैः सार्द्धं धर्म्मपुस्तकीयकथाया विचारं कृतवान्। ");
INSERT INTO sandev_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","फलतः ख्रीष्टेन दुःखभोगः कर्त्तव्यः श्मशानदुत्थानञ्च कर्त्तव्यं युष्माकं सन्निधौ यस्य यीशोः प्रस्तावं करोमि स ईश्वरेणाभिषिक्तः स एताः कथाः प्रकाश्य प्रमाणं दत्वा स्थिरीकृतवान्। ");
INSERT INTO sandev_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","तस्मात् तेषां कतिपयजना अन्यदेशीया बहवो भक्तलोका बह्यः प्रधाननार्य्यश्च विश्वस्य पौलसीलयोः पश्चाद्गामिनो जाताः। ");
INSERT INTO sandev_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","किन्तु विश्वासहीना यिहूदीयलोका ईर्ष्यया परिपूर्णाः सन्तो हटट्स्य कतिनयलम्पटलोकान् सङ्गिनः कृत्वा जनतया नगरमध्ये महाकलहं कृत्वा यासोनो गृहम् आक्रम्य प्रेरितान् धृत्वा लोकनिवहस्य समीपम् आनेतुं चेष्टितवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","तेषामुद्देशम् अप्राप्य च यासोनं कतिपयान् भ्रातृंश्च धृत्वा नगराधिपतीनां निकटमानीय प्रोच्चैः कथितवन्तो ये मनुष्या जगदुद्वाटितवन्तस्ते ऽत्राप्युपस्थिताः सन्ति, ");
INSERT INTO sandev_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","एष यासोन् आतिथ्यं कृत्वा तान् गृहीतवान्। यीशुनामक एको राजस्तीति कथयन्तस्ते कैसरस्याज्ञाविरुद्धं कर्म्म कुर्व्वति। ");
INSERT INTO sandev_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","तेषां कथामिमां श्रुत्वा लोकनिवहो नगराधिपतयश्च समुद्विग्ना अभवन्। ");
INSERT INTO sandev_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","तदा यासोनस्तदन्येषाञ्च धनदण्डं गृहीत्वा तान् परित्यक्तवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","ततः परं भ्रातृगणो रजन्यां पौलसीलौ शीघ्रं बिरयानगरं प्रेषितवान् तौ तत्रोपस्थाय यिहूदीयानां भजनभवनं गतवन्तौ। ");
INSERT INTO sandev_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","तत्रस्था लोकाः थिषलनीकीस्थलोकेभ्यो महात्मान आसन् यत इत्थं भवति न वेति ज्ञातुं दिने दिने धर्म्मग्रन्थस्यालोचनां कृत्वा स्वैरं कथाम् अगृह्लन्। ");
INSERT INTO sandev_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","तस्माद् अनेके यिहूदीया अन्यदेशीयानां मान्या स्त्रियः पुरुषाश्चानेके व्यश्वसन्। ");
INSERT INTO sandev_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","किन्तु बिरयानगरे पौलेनेश्वरीया कथा प्रचार्य्यत इति थिषलनीकीस्था यिहूदीया ज्ञात्वा तत्स्थानमप्यागत्य लोकानां कुप्रवृत्तिम् अजनयन्। ");
INSERT INTO sandev_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","अतएव तस्मात् स्थानात् समुद्रेण यान्तीति दर्शयित्वा भ्रातरः क्षिप्रं पौलं प्राहिण्वन् किन्तु सीलतीमथियौ तत्र स्थितवन्तौ। ");
INSERT INTO sandev_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","ततः परं पौलस्य मार्गदर्शकास्तम् आथीनीनगर उपस्थापयन् पश्चाद् युवां तूर्णम् एतत् स्थानं आगमिष्यथः सीलतीमथियौ प्रतीमाम् आज्ञां प्राप्य ते प्रत्यागताः। ");
INSERT INTO sandev_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","पौल आथीनीनगरे तावपेक्ष्य तिष्ठन् तन्नगरं प्रतिमाभिः परिपूर्णं दृष्ट्वा सन्तप्तहृदयो ऽभवत्। ");
INSERT INTO sandev_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","ततः स भजनभवने यान् यिहूदीयान् भक्तलोकांश्च हट्टे च यान् अपश्यत् तैः सह प्रतिदिनं विचारितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","किन्त्विपिकूरीयमतग्रहिणः स्तोयिकीयमतग्राहिणश्च कियन्तो जनास्तेन सार्द्धं व्यवदन्त। तत्र केचिद् अकथयन् एष वाचालः किं वक्तुम् इच्छति? अपरे केचिद् एष जनः केषाञ्चिद् विदेशीयदेवानां प्रचारक इत्यनुमीयते यतः स यीशुम् उत्थितिञ्च प्रचारयत्। ");
INSERT INTO sandev_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","ते तम् अरेयपागनाम विचारस्थानम् आनीय प्रावोचन् इदं यन्नवीनं मतं त्वं प्राचीकश इदं कीदृशं एतद् अस्मान् श्रावय; ");
INSERT INTO sandev_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","यामिमाम् असम्भवकथाम् अस्माकं कर्णगोचरीकृतवान् अस्या भावार्थः क इति वयं ज्ञातुम् इच्छामः। ");
INSERT INTO sandev_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","तदाथीनीनिवासिनस्तन्नगरप्रवासिनश्च केवलं कस्याश्चन नवीनकथायाः श्रवणेन प्रचारणेन च कालम् अयापयन्। ");
INSERT INTO sandev_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","पौलोऽरेयपागस्य मध्ये तिष्ठन् एतां कथां प्रचारितवान्, हे आथीनीयलोका यूयं सर्व्वथा देवपूजायाम् आसक्ता इत्यह प्रत्यक्षं पश्यामि। ");
INSERT INTO sandev_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","यतः पर्य्यटनकाले युष्माकं पूजनीयानि पश्यन् ‘अविज्ञातेश्वराय’ एतल्लिपियुक्तां यज्ञवेदीमेकां दृष्टवान्; अतो न विदित्वा यं पूजयध्वे तस्यैव तत्वं युष्मान् प्रति प्रचारयामि। ");
INSERT INTO sandev_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","जगतो जगत्स्थानां सर्व्ववस्तूनाञ्च स्रष्टा य ईश्वरः स स्वर्गपृथिव्योरेकाधिपतिः सन् करनिर्म्मितमन्दिरेषु न निवसति; ");
INSERT INTO sandev_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","स एव सर्व्वेभ्यो जीवनं प्राणान् सर्व्वसामग्रीश्च प्रददाति; अतएव स कस्याश्चित् सामग्य्रा अभावहेतो र्मनुष्याणां हस्तैः सेवितो भवतीति न। ");
INSERT INTO sandev_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","स भूमण्डले निवासार्थम् एकस्मात् शोणितात् सर्व्वान् मनुष्यान् सृष्ट्वा तेषां पूर्व्वनिरूपितसमयं वसतिसीमाञ्च निरचिनोत्; ");
INSERT INTO sandev_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","तस्मात् लोकैः केनापि प्रकारेण मृगयित्वा परमेश्वरस्य तत्वं प्राप्तुं तस्य गवेषणं करणीयम्। ");
INSERT INTO sandev_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","किन्तु सोऽस्माकं कस्माच्चिदपि दूरे तिष्ठतीति नहि, वयं तेन निश्वसनप्रश्वसनगमनागमनप्राणधारणानि कुर्म्मः, पुुनश्च युष्माकमेव कतिपयाः कवयः कथयन्ति ‘तस्य वंशा वयं स्मो हि’ इति। ");
INSERT INTO sandev_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","अतएव यदि वयम् ईश्वरस्य वंशा भवामस्तर्हि मनुष्यै र्विद्यया कौशलेन च तक्षितं स्वर्णं रूप्यं दृषद् वैतेषामीश्वरत्वम् अस्माभि र्न ज्ञातव्यं। ");
INSERT INTO sandev_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","तेषां पूर्व्वीयलोकानाम् अज्ञानतां प्रतीश्वरो यद्यपि नावाधत्त तथापीदानीं सर्व्वत्र सर्व्वान् मनः परिवर्त्तयितुम् आज्ञापयति, ");
INSERT INTO sandev_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","यतः स्वनियुक्तेन पुरुषेण यदा स पृथिवीस्थानां सर्व्वलोकानां विचारं करिष्यति तद्दिनं न्यरूपयत्; तस्य श्मशानोत्थापनेन तस्मिन् सर्व्वेभ्यः प्रमाणं प्रादात्। ");
INSERT INTO sandev_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","तदा श्मशानाद् उत्थानस्य कथां श्रुत्वा केचिद् उपाहमन्, केचिदवदन् एनां कथां पुनरपि त्वत्तः श्रोष्यामः। ");
INSERT INTO sandev_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","ततः पौलस्तेषां समीपात् प्रस्थिातवान्। ");
INSERT INTO sandev_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","तथापि केचिल्लोकास्तेन सार्द्धं मिलित्वा व्यश्वसन् तेषां मध्ये ऽरेयपागीयदियनुसियो दामारीनामा काचिन्नारी कियन्तो नराश्चासन्। ");
INSERT INTO sandev_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","तद्घटनातः परं पौल आथीनीनगराद् यात्रां कृत्वा करिन्थनगरम् आगच्छत्। ");
INSERT INTO sandev_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","तस्मिन् समये क्लौदियः सर्व्वान् यिहूदीयान् रोमानगरं विहाय गन्तुम् आज्ञापयत्, तस्मात् प्रिस्किल्लानाम्ना जायया सार्द्धम् इतालियादेशात् किञ्चित्पूर्व्वम् आगमत् यः पन्तदेशे जात आक्किलनामा यिहूदीयलोकः पौलस्तं साक्षात् प्राप्य तयोः समीपमितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","तौ दूष्यनिर्म्माणजीविनौ, तस्मात् परस्परम् एकवृत्तिकत्वात् स ताभ्यां सह उषित्वा तत् कर्म्माकरोत्। ");
INSERT INTO sandev_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","पौलः प्रतिविश्रामवारं भजनभवनं गत्वा विचारं कृत्वा यिहूदीयान् अन्यदेशीयांश्च प्रवृत्तिं ग्राहितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","सीलतीमथिययो र्माकिदनियादेशात् समेतयोः सतोः पौल उत्तप्तमना भूत्वा यीशुरीश्वरेणाभिषिक्तो भवतीति प्रमाणं यिहूदीयानां समीपे प्रादात्। ");
INSERT INTO sandev_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","किन्तु ते ऽतीव विरोधं विधाय पाषण्डीयकथां कथितवन्तस्ततः पौलो वस्त्रं धुन्वन् एतां कथां कथितवान्, युष्माकं शोणितपातापराधो युष्मान् प्रत्येव भवतु, तेनाहं निरपराधो ऽद्यारभ्य भिन्नदेशीयानां समीपं यामि। ");
INSERT INTO sandev_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","स तस्मात् प्रस्थाय भजनभवनसमीपस्थस्य युस्तनाम्न ईश्वरभक्तस्य भिन्नदेशीयस्य निवेशनं प्राविशत्। ");
INSERT INTO sandev_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","ततः क्रीष्पनामा भजनभवनाधिपतिः सपरिवारः प्रभौ व्यश्वसीत्, करिन्थनगरीया बहवो लोकाश्च समाकर्ण्य विश्वस्य मज्जिता अभवन्। ");
INSERT INTO sandev_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","क्षणदायां प्रभुः पौलं दर्शनं दत्वा भाषितवान्, मा भैषीः, मा निरसीः कथां प्रचारय। ");
INSERT INTO sandev_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","अहं त्वया सार्द्धम् आस हिंसार्थं कोपि त्वां स्प्रष्टुं न शक्ष्यति नगरेऽस्मिन् मदीया लोका बहव आसते। ");
INSERT INTO sandev_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","तस्मात् पौलस्तन्नगरे प्रायेण सार्द्धवत्सरपर्य्यन्तं संस्थायेश्वरस्य कथाम् उपादिशत्। ");
INSERT INTO sandev_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","गाल्लियनामा कश्चिद् आखायादेशस्य प्राड्विवाकः समभवत्, ततो यिहूदीया एकवाक्याः सन्तः पौलम् आक्रम्य विचारस्थानं नीत्वा ");
INSERT INTO sandev_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","मानुष एष व्यवस्थाय विरुद्धम् ईश्वरभजनं कर्त्तुं लोकान् कुप्रवृत्तिं ग्राहयतीति निवेदितवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","ततः पौले प्रत्युत्तरं दातुम् उद्यते सति गाल्लिया यिहूदीयान् व्याहरत्, यदि कस्यचिद् अन्यायस्य वातिशयदुष्टताचरणस्य विचारोऽभविष्यत् तर्हि युष्माकं कथा मया सहनीयाभविष्यत्। ");
INSERT INTO sandev_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","किन्तु यदि केवलं कथाया वा नाम्नो वा युष्माकं व्यवस्थाया विवादो भवति तर्हि तस्य विचारमहं न करिष्यामि, यूयं तस्य मीमांसां कुरुत। ");
INSERT INTO sandev_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","ततः स तान् विचारस्थानाद् दूरीकृतवान्। ");
INSERT INTO sandev_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","तदा भिन्नदेशीयाः सोस्थिनिनामानं भजनभवनस्य प्रधानाधिपतिं धृत्वा विचारस्थानस्य सम्मुखे प्राहरन् तथापि गाल्लिया तेषु सर्व्वकर्म्मसु न मनो न्यदधात्। ");
INSERT INTO sandev_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","पौलस्तत्र पुनर्बहुदिनानि न्यवसत्, ततो भ्रातृगणाद् विसर्जनं प्राप्य किञ्चनव्रतनिमित्तं किंक्रियानगरे शिरो मुण्डयित्वा प्रिस्किल्लाक्किलाभ्यां सहितो जलपथेन सुरियादेशं गतवान्। ");
INSERT INTO sandev_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","तत इफिषनगर उपस्थाय तत्र तौ विसृज्य स्वयं भजनभ्वनं प्रविश्य यिहूदीयैः सह विचारितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","ते स्वैः सार्द्धं पुनः कतिपयदिनानि स्थातुं तं व्यनयन्, स तदनुररीकृत्य कथामेतां कथितवान्, ");
INSERT INTO sandev_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","यिरूशालमि आगाम्युत्सवपालनार्थं मया गमनीयं; पश्चाद् ईश्वरेच्छायां जातायां युष्माकं समीपं प्रत्यागमिष्यामि। ततः परं स तै र्विसृष्टः सन् जलपथेन इफिषनगरात् प्रस्थितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","ततः कैसरियाम् उपस्थितः सन् नगरं गत्वा समाजं नमस्कृत्य तस्माद् आन्तियखियानगरं प्रस्थितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","तत्र कियत्कालं यापयित्वा तस्मात् प्रस्थाय सर्व्वेषां शिष्याणां मनांसि सुस्थिराणि कृत्वा क्रमशो गलातियाफ्रुगियादेशयो र्भ्रमित्वा गतवान्। ");
INSERT INTO sandev_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","तस्मिन्नेव समये सिकन्दरियानगरे जात आपल्लोनामा शास्त्रवित् सुवक्ता यिहूदीय एको जन इफिषनगरम् आगतवान्। ");
INSERT INTO sandev_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","स शिक्षितप्रभुमार्गो मनसोद्योगी च सन् योहनो मज्जनमात्रं ज्ञात्वा यथार्थतया प्रभोः कथां कथयन् समुपादिशत्। ");
INSERT INTO sandev_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","एष जनो निर्भयत्वेन भजनभवने कथयितुम् आरब्धवान्, ततः प्रिस्किल्लाक्किलौ तस्योपदेशकथां निशम्य तं स्वयोः समीपम् आनीय शुद्धरूपेणेश्वरस्य कथाम् अबोधयताम्। ");
INSERT INTO sandev_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","पश्चात् स आखायादेशं गन्तुं मतिं कृतवान्, तदा तत्रत्यः शिष्यगणो यथा तं गृह्लाति तदर्थं भ्रातृगणेन समाश्वस्य पत्रे लिखिते सति, आपल्लास्तत्रोपस्थितः सन् अनुग्रहेण प्रत्ययिनां बहूपकारान् अकरोत्, ");
INSERT INTO sandev_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","फलतो यीशुरभिषिक्तस्त्रातेति शास्त्रप्रमाणं दत्वा प्रकाशरूपेण प्रतिपन्नं कृत्वा यिहूदीयान् निरुत्तरान् कृतवान्। ");
INSERT INTO sandev_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","करिन्थनगर आपल्लसः स्थितिकाले पौल उत्तरप्रदेशैरागच्छन् इफिषनगरम् उपस्थितवान्। तत्र कतिपयशिष्यान् साक्षत् प्राप्य तान् अपृच्छत्, ");
INSERT INTO sandev_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","यूयं विश्वस्य पवित्रमात्मानं प्राप्ता न वा? ततस्ते प्रत्यवदन् पवित्र आत्मा दीयते इत्यस्माभिः श्रुतमपि नहि। ");
INSERT INTO sandev_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","तदा साऽवदत् तर्हि यूयं केन मज्जिता अभवत? तेऽकथयन् योहनो मज्जनेन। ");
INSERT INTO sandev_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","तदा पौल उक्तवान् इतः परं य उपस्थास्यति तस्मिन् अर्थत यीशुख्रीष्टे विश्वसितव्यमित्युक्त्वा योहन् मनःपरिवर्त्तनसूचकेन मज्जनेन जले लोकान् अमज्जयत्। ");
INSERT INTO sandev_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","तादृशीं कथां श्रुत्वा ते प्रभो र्यीशुख्रीष्टस्य नाम्ना मज्जिता अभवन्। ");
INSERT INTO sandev_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ततः पौलेन तेषां गात्रेषु करेऽर्पिते तेषामुपरि पवित्र आत्मावरूढवान्, तस्मात् ते नानादेशीया भाषा भविष्यत्कथाश्च कथितवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","ते प्रायेण द्वादशजना आसन्। ");
INSERT INTO sandev_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","पौलो भजनभवनं गत्वा प्रायेण मासत्रयम् ईश्वरस्य राज्यस्य विचारं कृत्वा लोकान् प्रवर्त्य साहसेन कथामकथयत्। ");
INSERT INTO sandev_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","किन्तु कठिनान्तःकरणत्वात् कियन्तो जना न विश्वस्य सर्व्वेषां समक्षम् एतत्पथस्य निन्दां कर्त्तुं प्रवृत्ताः, अतः पौलस्तेषां समीपात् प्रस्थाय शिष्यगणं पृथक्कृत्वा प्रत्यहं तुरान्ननाम्नः कस्यचित् जनस्य पाठशालायां विचारं कृतवान्। ");
INSERT INTO sandev_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","इत्थं वत्सरद्वयं गतं तस्माद् आशियादेशनिवासिनः सर्व्वे यिहूदीया अन्यदेशीयलोकाश्च प्रभो र्यीशोः कथाम् अश्रौषन्। ");
INSERT INTO sandev_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","पौलेन च ईश्वर एतादृशान्यद्भुतानि कर्म्माणि कृतवान् ");
INSERT INTO sandev_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","यत् परिधेये गात्रमार्जनवस्त्रे वा तस्य देहात् पीडितलोकानाम् समीपम् आनीते ते निरामया जाता अपवित्रा भूताश्च तेभ्यो बहिर्गतवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","तदा देशाटनकारिणः कियन्तो यिहूदीया भूतापसारिणो भूतग्रस्तनोकानां सन्निधौ प्रभे र्यीशो र्नाम जप्त्वा वाक्यमिदम् अवदन्, यस्य कथां पौलः प्रचारयति तस्य यीशो र्नाम्ना युष्मान् आज्ञापयामः। ");
INSERT INTO sandev_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","स्किवनाम्नो यिहूदीयानां प्रधानयाजकस्य सप्तभिः पुत्तैस्तथा कृते सति ");
INSERT INTO sandev_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","कश्चिद् अपवित्रो भूतः प्रत्युदितवान्, यीशुं जानामि पौलञ्च परिचिनोमि किन्तु के यूयं? ");
INSERT INTO sandev_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","इत्युक्त्वा सोपवित्रभूतग्रस्तो मनुष्यो लम्फं कृत्वा तेषामुपरि पतित्वा बलेन तान् जितवान्, तस्मात्ते नग्नाः क्षताङ्गाश्च सन्तस्तस्माद् गेहात् पलायन्त। ");
INSERT INTO sandev_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","सा वाग् इफिषनगरनिवासिनसं सर्व्वेषां यिहूदीयानां भिन्नदेशीयानां लोकानाञ्च श्रवोगोचरीभूता; ततः सर्व्वे भयं गताः प्रभो र्यीशो र्नाम्नो यशो ऽवर्द्धत। ");
INSERT INTO sandev_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","येषामनेकेषां लोकानां प्रतीतिरजायत त आगत्य स्वैः कृताः क्रियाः प्रकाशरूपेणाङ्गीकृतवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","बहवो मायाकर्म्मकारिणः स्वस्वग्रन्थान् आनीय राशीकृत्य सर्व्वेषां समक्षम् अदाहयन्, ततो गणनां कृत्वाबुध्यन्त पञ्चायुतरूप्यमुद्रामूल्यपुस्तकानि दग्धानि। ");
INSERT INTO sandev_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","इत्थं प्रभोः कथा सर्व्वदेशं व्याप्य प्रबला जाता। ");
INSERT INTO sandev_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","सर्व्वेष्वेतेषु कर्म्मसु सम्पन्नेषु सत्सु पौलो माकिदनियाखायादेशाभ्यां यिरूशालमं गन्तुं मतिं कृत्वा कथितवान् तत्स्थानं यात्रायां कृतायां सत्यां मया रोमानगरं द्रष्टव्यं। ");
INSERT INTO sandev_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","स्वानुगतलोकानां तीमथियेरास्तौ द्वौ जनौ माकिदनियादेशं प्रति प्रहित्य स्वयम् आशियादेशे कतिपयदिनानि स्थितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","किन्तु तस्मिन् समये मतेऽस्मिन् कलहो जातः। ");
INSERT INTO sandev_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","तत्कारणमिदं, अर्त्तिमीदेव्या रूप्यमन्दिरनिर्म्माणेन सर्व्वेषां शिल्पिनां यथेष्टलाभम् अजनयत् यो दीमीत्रियनामा नाडीन्धमः ");
INSERT INTO sandev_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","स तान् तत्कर्म्मजीविनः सर्व्वलोकांश्च समाहूय भाषितवान् हे महेच्छा एतेन मन्दिरनिर्म्माणेनास्माकं जीविका भवति, एतद् यूयं वित्थ; ");
INSERT INTO sandev_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","किन्तु हस्तनिर्म्मितेश्वरा ईश्वरा नहि पौलनाम्ना केनचिज्जनेन कथामिमां व्याहृत्य केवलेफिषनगरे नहि प्रायेण सर्व्वस्मिन् आशियादेशे प्रवृत्तिं ग्राहयित्वा बहुलोकानां शेमुषी परावर्त्तिता, एतद् युष्माभि र्दृश्यते श्रूयते च। ");
INSERT INTO sandev_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","तेनास्माकं वाणिज्यस्य सर्व्वथा हानेः सम्भवनं केवलमिति नहि, आशियादेशस्थै र्वा सर्व्वजगत्स्थै र्लोकैः पूज्या यार्तिमी महादेवी तस्या मन्दिरस्यावज्ञानस्य तस्या ऐश्वर्य्यस्य नाशस्य च सम्भावना विद्यतेे। ");
INSERT INTO sandev_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","एतादृशीं कथां श्रुत्वा ते महाक्रोधान्विताः सन्त उच्चैःकारं कथितवन्त इफिषीयानाम् अर्त्तिमी देवी महती भवति। ");
INSERT INTO sandev_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","ततः सर्व्वनगरं कलहेन परिपूर्णमभवत्, ततः परं ते माकिदनीयगायारिस्तार्खनामानौ पौलस्य द्वौ सहचरौ धृत्वैकचित्ता रङ्गभूमिं जवेन धावितवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","ततः पौलो लोकानां सन्निधिं यातुम् उद्यतवान् किन्तु शिष्यगणस्तं वारितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","पौलस्यत्मीया आशियादेशस्थाः कतिपयाः प्रधानलोकास्तस्य समीपं नरमेकं प्रेष्य त्वं रङ्गभूमिं मागा इति न्यवेदयन्। ");
INSERT INTO sandev_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","ततो नानालोकानां नानाकथाकथनात् सभा व्याकुला जाता किं कारणाद् एतावती जनताभवत् एतद् अधिकै र्लोकै र्नाज्ञायि। ");
INSERT INTO sandev_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","ततः परं जनतामध्याद् यिहूदीयैर्बहिष्कृतः सिकन्दरो हस्तेन सङ्केतं कृत्वा लोकेभ्य उत्तरं दातुमुद्यतवान्, ");
INSERT INTO sandev_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","किन्तु स यिहूदीयलोक इति निश्चिते सति इफिषीयानाम् अर्त्तिमी देवी महतीति वाक्यं प्रायेण पञ्च दण्डान् यावद् एकस्वरेण लोकनिवहैः प्रोक्तं। ");
INSERT INTO sandev_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","ततो नगराधिपतिस्तान् स्थिरान् कृत्वा कथितवान् हे इफिषायाः सर्व्वे लोका आकर्णयत, अर्तिमीमहादेव्या महादेवात् पतितायास्तत्प्रतिमायाश्च पूजनम इफिषनगरस्थाः सर्व्वे लोकाः कुर्व्वन्ति, एतत् के न जानन्ति? ");
INSERT INTO sandev_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","तस्माद् एतत्प्रतिकूलं केपि कथयितुं न शक्नुवन्ति, इति ज्ञात्वा युष्माभिः सुस्थिरत्वेन स्थातव्यम् अविविच्य किमपि कर्म्म न कर्त्तव्यञ्च। ");
INSERT INTO sandev_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","यान् एतान् मनुष्यान् यूयमत्र समानयत ते मन्दिरद्रव्यापहारका युष्माकं देव्या निन्दकाश्च न भवन्ति। ");
INSERT INTO sandev_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","यदि कञ्चन प्रति दीमीत्रियस्य तस्य सहायानाञ्च काचिद् आपत्ति र्विद्यते तर्हि प्रतिनिधिलोका विचारस्थानञ्च सन्ति, ते तत् स्थानं गत्वा उत्तरप्रत्युत्तरे कुर्व्वन्तु। ");
INSERT INTO sandev_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","किन्तु युष्माकं काचिदपरा कथा यदि तिष्ठति तर्हि नियमितायां सभायां तस्या निष्पत्ति र्भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","किन्त्वेतस्य विरोधस्योत्तरं येन दातुं शक्नुम् एतादृशस्य कस्यचित् कारणस्याभावाद् अद्यतनघटनाहेतो राजद्रोहिणामिवास्माकम् अभियोगो भविष्यतीति शङ्का विद्यते। ");
INSERT INTO sandev_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","इति कथयित्वा स सभास्थलोकान् विसृष्टवान्। ");
INSERT INTO sandev_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","इत्थं कलहे निवृत्ते सति पौलः शिष्यगणम् आहूय विसर्जनं प्राप्य माकिदनियादेशं प्रस्थितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","तेन स्थानेन गच्छन् तद्देशीयान् शिष्यान् बहूपदिश्य यूनानीयदेशम् उपस्थितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","तत्र मासत्रयं स्थित्वा तस्मात् सुरियादेशं यातुम् उद्यतः, किन्तु यिहूदीयास्तं हन्तुं गुप्ता अतिष्ठन् तस्मात् स पुनरपि माकिदनियामार्गेण प्रत्यागन्तुं मतिं कृतवान्। ");
INSERT INTO sandev_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","बिरयानगरीयसोपात्रः थिषलनीकीयारिस्तार्खसिकुन्दौ दर्ब्बोनगरीयगायतीमथियौ आशियादेशीयतुखिकत्रफिमौ च तेन सार्द्धं आशियादेशं यावद् गतवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","एते सर्व्वे ऽग्रसराः सन्तो ऽस्मान् अपेक्ष्य त्रोयानगरे स्थितवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","किण्वशून्यपूपोत्सवदिने च गते सति वयं फिलिपीनगरात् तोयपथेन गत्वा पञ्चभि र्दिनैस्त्रोयानगरम् उपस्थाय तत्र सप्तदिनान्यवातिष्ठाम। ");
INSERT INTO sandev_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","सप्ताहस्य प्रथमदिने पूपान् भंक्तु शिष्येषु मिलितेषु पौलः परदिने तस्मात् प्रस्थातुम् उद्यतः सन् तदह्नि प्रायेण क्षपाया यामद्वयं यावत् शिष्येभ्यो धर्म्मकथाम् अकथयत्। ");
INSERT INTO sandev_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","उपरिस्थे यस्मिन् प्रकोष्ठे सभां कृत्वासन् तत्र बहवः प्रदीपाः प्राज्वलन्। ");
INSERT INTO sandev_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","उतुखनामा कश्चन युवा च वातायन उपविशन् घोरतरनिद्राग्रस्तो ऽभूत् तदा पौलेन बहुक्षणं कथायां प्रचारितायां निद्रामग्नः स तस्माद् उपरिस्थतृतीयप्रकोष्ठाद् अपतत्, ततो लोकास्तं मृतकल्पं धृत्वोदतोलयन्। ");
INSERT INTO sandev_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","ततः पौलोऽवरुह्य तस्य गात्रे पतित्वा तं क्रोडे निधाय कथितवान्, यूयं व्याकुला मा भूत नायं प्राणै र्वियुक्तः। ");
INSERT INTO sandev_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","पश्चात् स पुनश्चोपरि गत्वा पूपान् भंक्त्वा प्रभातं यावत् कथोपकथने कृत्वा प्रस्थितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","ते च तं जीवन्तं युवानं गृहीत्वा गत्वा परमाप्यायिता जाताः। ");
INSERT INTO sandev_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","अनन्तरं वयं पोतेनाग्रसरा भूत्वास्मनगरम् उत्तीर्य्य पौलं ग्रहीतुं मतिम् अकुर्म्म यतः स तत्र पद्भ्यां व्रजितुं मतिं कृत्वेति निरूपितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","तस्मात् तत्रास्माभिः सार्द्धं तस्मिन् मिलिते सति वयं तं नीत्वा मितुलीन्युपद्वीपं प्राप्तवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","तस्मात् पोतं मोचयित्वा परेऽहनि खीयोपद्वीपस्य सम्मुखं लब्धवन्तस्तस्माद् एकेनाह्ना सामोपद्वीपं गत्वा पोतं लागयित्वा त्रोगुल्लिये स्थित्वा परस्मिन् दिवसेे मिलीतनगरम् उपातिष्ठाम। ");
INSERT INTO sandev_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","यतः पौल आशियादेशे कालं यापयितुम् नाभिलषन् इफिषनगरं त्यक्त्वा यातुं मन्त्रणां स्थिरीकृतवान्; यस्माद् यदि साध्यं भवति तर्हि निस्तारोत्सवस्य पञ्चाशत्तमदिने स यिरूशालम्युपस्थातुं मतिं कृतवान्। ");
INSERT INTO sandev_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","पौलो मिलीताद् इफिषं प्रति लोकं प्रहित्य समाजस्य प्राचीनान् आहूयानीतवान्। ");
INSERT INTO sandev_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","तेषु तस्य समीपम् उपस्थितेषु स तेभ्य इमां कथां कथितवान्, अहम् आशियादेशे प्रथमागमनम् आरभ्याद्य यावद् युष्माकं सन्निधौ स्थित्वा सर्व्वसमये यथाचरितवान् तद् यूयं जानीथ; ");
INSERT INTO sandev_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","फलतः सर्व्वथा नम्रमनाः सन् बहुश्रुपातेन यिहुदीयानाम् कुमन्त्रणाजातनानापरीक्षाभिः प्रभोः सेवामकरवं। ");
INSERT INTO sandev_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","कामपि हितकथाां न गोपायितवान् तां प्रचार्य्य सप्रकाशं गृहे गृहे समुपदिश्येश्वरं प्रति मनः परावर्त्तनीयं प्रभौ यीशुख्रीष्टे विश्वसनीयं ");
INSERT INTO sandev_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","यिहूदीयानाम् अन्यदेशीयलोकानाञ्च समीप एतादृशं साक्ष्यं ददामि। ");
INSERT INTO sandev_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","पश्यत साम्प्रतम् आत्मनाकृष्टः सन् यिरूशालम्नगरे यात्रां करोमि, तत्र माम्प्रति यद्यद् घटिष्यते तान्यहं न जानामि; ");
INSERT INTO sandev_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","किन्तु मया बन्धनं क्लेशश्च भोक्तव्य इति पवित्र आत्मा नगरे नगरे प्रमाणं ददाति। ");
INSERT INTO sandev_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","तथापि तं क्लेशमहं तृणाय न मन्ये; ईश्वरस्यानुग्रहविषयकस्य सुसंवादस्य प्रमाणं दातुं, प्रभो र्यीशोः सकाशाद यस्याः सेवायाः भारं प्राप्नवं तां सेवां साधयितुं सानन्दं स्वमार्गं समापयितुुञ्च निजप्राणानपि प्रियान् न मन्ये। ");
INSERT INTO sandev_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","अधुना पश्यत येषां समीपेऽहम् ईश्वरीयराज्यस्य सुसंवादं प्रचार्य्य भ्रमणं कृतवान् एतादृशा यूयं मम वदनं पुन र्द्रष्टुं न प्राप्स्यथ एतदप्यहं जानामि। ");
INSERT INTO sandev_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","युष्मभ्यम् अहम् ईश्वरस्य सर्व्वान् आदेशान् प्रकाशयितुं न न्यवर्त्ते। ");
INSERT INTO sandev_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","अहं सर्व्वेषां लोकानां रक्तपातदोषाद् यन्निर्दोष आसे तस्याद्य युष्मान् साक्षिणः करोमि। ");
INSERT INTO sandev_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","यूयं स्वेषु तथा यस्य व्रजस्याध्यक्षन् आत्मा युष्मान् विधाय न्ययुङ्क्त तत्सर्व्वस्मिन् सावधाना भवत, य समाजञ्च प्रभु र्निजरक्तमूल्येन क्रीतवान तम् अवत, ");
INSERT INTO sandev_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","यतो मया गमने कृतएव दुर्जया वृका युष्माकं मध्यं प्रविश्य व्रजं प्रति निर्दयताम् आचरिष्यन्ति, ");
INSERT INTO sandev_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","युष्माकमेव मध्यादपि लोका उत्थाय शिष्यगणम् अपहन्तुं विपरीतम् उपदेक्ष्यन्तीत्यहं जानामि। ");
INSERT INTO sandev_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","इति हेतो र्यूयं सचैतन्याः सन्तस्तिष्टत, अहञ्च साश्रुपातः सन् वत्सरत्रयं यावद् दिवानिशं प्रतिजनं बोधयितुं न न्यवर्त्ते तदपि स्मरत। ");
INSERT INTO sandev_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","इदानीं हे भ्रातरो युष्माकं निष्ठां जनयितुं पवित्रीकृतलोकानां मध्येऽधिकारञ्च दातुं समर्थो य ईश्वरस्तस्यानुग्रहस्य यो वादश्च तयोरुभयो र्युष्मान् समार्पयम्। ");
INSERT INTO sandev_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","कस्यापि स्वर्णं रूप्यं वस्त्रं वा प्रति मया लोभो न कृतः। ");
INSERT INTO sandev_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","किन्तु मम मत्सहचरलोकानाञ्चावश्यकव्ययाय मदीयमिदं करद्वयम् अश्राम्यद् एतद् यूयं जानीथ। ");
INSERT INTO sandev_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","अनेन प्रकारेण ग्रहणद् दानं भद्रमिति यद्वाक्यं प्रभु र्यीशुः कथितवान् तत् स्मर्त्तुं दरिद्रलोकानामुपकारार्थं श्रमं कर्त्तुञ्च युष्माकम् उचितम् एतत्सर्व्वं युष्मानहम् उपदिष्टवान्। ");
INSERT INTO sandev_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","एतां कथां कथयित्वा स जानुनी पातयित्वा सर्वैः सह प्रार्थयत। ");
INSERT INTO sandev_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","तेन ते क्रन्द्रन्तः ");
INSERT INTO sandev_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","पुन र्मम मुखं न द्रक्ष्यथ विशेषत एषा या कथा तेनाकथि तत्कारणात् शोकं विलापञ्च कृत्वा कण्ठं धृत्वा चुम्बितवन्तः। पश्चात् ते तं पोतं नीतवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","तै र्विसृष्टाः सन्तो वयं पोतं बाहयित्वा ऋजुमार्गेण कोषम् उपद्वीपम् आगत्य परेऽहनि रोदियोपद्वीपम् आगच्छाम ततस्तस्मात् पातारायाम् उपातिष्ठाम। ");
INSERT INTO sandev_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","तत्र फैनीकियादेशगामिनम् पोतमेकं प्राप्य तमारुह्य गतवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","कुप्रोपद्वीपं दृष्ट्वा तं सव्यदिशि स्थापयित्वा सुरियादेशं गत्वा पोतस्थद्रव्याण्यवरोहयितुं सोरनगरे लागितवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","तत्र शिष्यगणस्य साक्षात्करणाय वयं तत्र सप्तदिनानि स्थितवन्तः पश्चात्ते पवित्रेणात्मना पौलं व्याहरन् त्वं यिरूशालम्नगरं मा गमः। ");
INSERT INTO sandev_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","ततस्तेषु सप्तसु दिनेषु यापितेषु सत्सु वयं तस्मात् स्थानात् निजवर्त्मना गतवन्तः, तस्मात् ते सबालवृद्धवनिता अस्माभिः सह नगरस्य परिसरपर्य्यन्तम् आगताः पश्चाद्वयं जलधितटे जानुपातं प्रार्थयामहि। ");
INSERT INTO sandev_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ततः परस्परं विसृष्टाः सन्तो वयं पोतं गतास्ते तु स्वस्वगृहं प्रत्यागतवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","वयं सोरनगरात् नावा प्रस्थाय तलिमायिनगरम् उपातिष्ठाम तत्रास्माकं समुद्रीयमार्गस्यान्तोऽभवत् तत्र भ्रातृगणं नमस्कृत्य दिनमेकं तैः सार्द्धम् उषतवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","परे ऽहनि पौलस्तस्य सङ्गिनो वयञ्च प्रतिष्ठमानाः कैसरियानगरम् आगत्य सुसंवादप्रचारकानां सप्तजनानां फिलिपनाम्न एकस्य गृहं प्रविश्यावतिष्ठाम। ");
INSERT INTO sandev_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","तस्य चतस्रो दुहितरोऽनूढा भविष्यद्वादिन्य आसन्। ");
INSERT INTO sandev_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","तत्रास्मासु बहुदिनानि प्रोषितेषु यिहूदीयदेशाद् आगत्यागाबनामा भविष्यद्वादी समुपस्थितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","सोस्माकं समीपमेत्य पौलस्य कटिबन्धनं गृहीत्वा निजहस्तापादान् बद्ध्वा भाषितवान् यस्येदं कटिबन्धनं तं यिहूदीयलोका यिरूशालमनगर इत्थं बद्ध्वा भिन्नदेशीयानां करेषु समर्पयिष्यन्तीति वाक्यं पवित्र आत्मा कथयति। ");
INSERT INTO sandev_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","एतादृशीं कथां श्रुत्वा वयं तन्नगरवासिनो भ्रातरश्च यिरूशालमं न यातुं पौलं व्यनयामहि; ");
INSERT INTO sandev_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","किन्तु स प्रत्यावादीत्, यूयं किं कुरुथ? किं क्रन्दनेन ममान्तःकरणं विदीर्णं करिष्यथ? प्रभो र्यीशो र्नाम्नो निमित्तं यिरूशालमि बद्धो भवितुं केवल तन्न प्राणान् दातुमपि ससज्जोस्मि। ");
INSERT INTO sandev_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","तेनास्माकं कथायाम् अगृहीतायाम् ईश्वरस्य यथेच्छा तथैव भवत्वित्युक्त्वा वयं निरस्याम। ");
INSERT INTO sandev_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","परेऽहनि पाथेयद्रव्याणि गृहीत्वा यिरूशालमं प्रति यात्राम् अकुर्म्म। ");
INSERT INTO sandev_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","ततः कैसरियानगरनिवासिनः कतिपयाः शिष्या अस्माभिः सार्द्धम् इत्वा कृप्रीयेन म्नासन्नाम्ना येन प्राचीनशिष्येन सार्द्धम् अस्माभि र्वस्तव्यं तस्य समीपम् अस्मान् नीतवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","अस्मासु यिरूशालम्युपस्थितेषु तत्रस्थभ्रातृगणोऽस्मान् आह्लादेन गृहीतवान्। ");
INSERT INTO sandev_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","परस्मिन् दिवसे पौलेऽस्माभिः सह याकूबो गृहं प्रविष्टे लोकप्राचीनाः सर्व्वे तत्र परिषदि संस्थिताः। ");
INSERT INTO sandev_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","अनन्तरं स तान् नत्वा स्वीयप्रचारणेन भिन्नदेशीयान् प्रतीश्वरो यानि कर्म्माणि साधितवान् तदीयां कथाम् अनुक्रमात् कथितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","इति श्रुत्वा ते प्रभुं धन्यं प्रोच्य वाक्यमिदम् अभाषन्त, हे भ्रात र्यिहूदीयानां मध्ये बहुसहस्राणि लोका विश्वासिन आसते किन्तु ते सर्व्वे व्यवस्थामताचारिण एतत् प्रत्यक्षं पश्यसि। ");
INSERT INTO sandev_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","शिशूनां त्वक्छेदनाद्याचरणं प्रतिषिध्य त्वं भिन्नदेशनिवासिनो यिहूदीयलोकान् मूसावाक्यम् अश्रद्धातुम् उपदिशसीति तैः श्रुतमस्ति। ");
INSERT INTO sandev_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","त्वमत्रागतोसीति वार्त्तां समाकर्ण्य जननिवहो मिलित्वावश्यमेवागमिष्यति; अतएव किं करणीयम्? अत्र वयं मन्त्रयित्वा समुपायं त्वां वदामस्तं त्वमाचर। ");
INSERT INTO sandev_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","व्रतं कर्त्तुं कृतसङ्कल्पा येऽस्मांक चत्वारो मानवाः सन्ति ");
INSERT INTO sandev_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","तान् गृहीत्वा तैः सहितः स्वं शुचिं कुरु तथा तेषां शिरोमुण्डने यो व्ययो भवति तं त्वं देहि। तथा कृते त्वदीयाचारे या जनश्रुति र्जायते सालीका किन्तु त्वं विधिं पालयन् व्यवस्थानुसारेणेवाचरसीति ते भोत्सन्ते। ");
INSERT INTO sandev_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","भिन्नदेशीयानां विश्वासिलोकानां निकटे वयं पत्रं लिखित्वेत्थं स्थिरीकृतवन्तः, देवप्रसादभोजनं रक्तं गलपीडनमारितप्राणिभोजनं व्यभिचारश्चैतेभ्यः स्वरक्षणव्यतिरेकेण तेषामन्यविधिपालनं करणीयं न। ");
INSERT INTO sandev_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","ततः पौलस्तान् मानुषानादाय परस्मिन् दिवसे तैः सह शुचि र्भूत्वा मन्दिरं गत्वा शौचकर्म्मणो दिनेषु सम्पूर्णेषु तेषाम् एकैकार्थं नैवेद्याद्युत्सर्गो भविष्यतीति ज्ञापितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","तेषु सप्तसु दिनेषु समाप्तकल्पेषु आशियादेशनिवासिनो यिहूदीयास्तं मध्येमन्दिरं विलोक्य जननिवहस्य मनःसु कुप्रवृत्तिं जनयित्वा तं धृत्वा ");
INSERT INTO sandev_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","प्रोच्चैः प्रावोचन्, हे इस्रायेल्लोकाः सर्व्वे साहाय्यं कुरुत। यो मनुज एतेषां लोकानां मूसाव्यवस्थाया एतस्य स्थानस्यापि विपरीतं सर्व्वत्र सर्व्वान् शिक्षयति स एषः; विशेषतः स भिन्नदेशीयलोकान् मन्दिरम् आनीय पवित्रस्थानमेतद् अपवित्रमकरोत्। ");
INSERT INTO sandev_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","पूर्व्वं ते मध्येनगरम् इफिषनगरीयं त्रफिमं पौलेन सहितं दृष्टवन्त एतस्मात् पौलस्तं मन्दिरमध्यम् आनयद् इत्यन्वमिमत। ");
INSERT INTO sandev_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","अतएव सर्व्वस्मिन् नगरे कलहोत्पन्नत्वात् धावन्तो लोका आगत्य पौलं धृत्वा मन्दिरस्य बहिराकृष्यानयन् तत्क्षणाद् द्वाराणि सर्व्वाणि च रुद्धानि। ");
INSERT INTO sandev_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","तेषु तं हन्तुमुद्यतेेषु यिरूशालम्नगरे महानुपद्रवो जात इति वार्त्तायां सहस्रसेनापतेः कर्णगोचरीभूतायां सत्यां स तत्क्षणात् सैन्यानि सेनापतिगणञ्च गृहीत्वा जवेनागतवान्। ");
INSERT INTO sandev_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","ततो लोकाः सेनागणेन सह सहस्रसेनापतिम् आगच्छन्तं दृष्ट्वा पौलताडनातो न्यवर्त्तन्त। ");
INSERT INTO sandev_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","स सहस्रसेनापतिः सन्निधावागम्य पौलं धृत्वा शृङ्खलद्वयेन बद्धम् आदिश्य तान् पृष्टवान् एष कः? किं कर्म्म चायं कृतवान्? ");
INSERT INTO sandev_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","ततो जनसमूहस्य कश्चिद् एकप्रकारं कश्चिद् अन्यप्रकारं वाक्यम् अरौत् स तत्र सत्यं ज्ञातुम् कलहकारणाद् अशक्तः सन् तं दुर्गं नेतुम् आज्ञापयत्। ");
INSERT INTO sandev_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","तेषु सोपानस्योपरि प्राप्तेषु लोकानां साहसकारणात् सेनागणः पौलमुत्तोल्य नीतवान्। ");
INSERT INTO sandev_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ततः सर्व्वे लोकाः पश्चाद्गामिनः सन्त एनं दुरीकुरुतेति वाक्यम् उच्चैरवदन्। ");
INSERT INTO sandev_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","पौलस्य दुर्गानयनसमये स तस्मै सहस्रसेनापतये कथितवान्, भवतः पुरस्तात् कथां कथयितुं किम् अनुमन्यते? स तमपृच्छत् त्वं किं यूनानीयां भाषां जानासि? ");
INSERT INTO sandev_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","यो मिसरीयो जनः पूर्व्वं विरोधं कृत्वा चत्वारि सहस्राणि घातकान् सङ्गिनः कृत्वा विपिनं गतवान् त्वं किं सएव न भवसि? ");
INSERT INTO sandev_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","तदा पौलोऽकथयत् अहं किलिकियादेशस्य तार्षनगरीयो यिहूदीयो, नाहं सामान्यनगरीयो मानवः; अतएव विनयेऽहं लाकानां समक्षं कथां कथयितुं मामनुजानीष्व। ");
INSERT INTO sandev_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","तेनानुज्ञातः पौलः सोपानोपरि तिष्ठन् हस्तेनेङ्गितं कृतवान्, तस्मात् सर्व्वे सुस्थिरा अभवन्। तदा पौल इब्रीयभाषया कथयितुम् आरभत, ");
INSERT INTO sandev_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","हे पितृगणा हे भ्रातृगणाः, इदानीं मम निवेदने समवधत्त। ");
INSERT INTO sandev_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","तदा स इब्रीयभाषया कथां कथयतीति श्रुत्वा सर्व्वे लोका अतीव निःशब्दा सन्तोऽतिष्ठन्। ");
INSERT INTO sandev_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","पश्चात् सोऽकथयद् अहं यिहूदीय इति निश्चयः किलिकियादेशस्य तार्षनगरं मम जन्मभूमिः,एतन्नगरीयस्य गमिलीयेलनाम्नोऽध्यापकस्य शिष्यो भूत्वा पूर्व्वपुरुषाणां विधिव्यवस्थानुसारेण सम्पूर्णरूपेण शिक्षितोऽभवम् इदानीन्तना यूयं यादृशा भवथ तादृशोऽहमपीश्वरसेवायाम् उद्योगी जातः। ");
INSERT INTO sandev_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","मतमेतद् द्विष्ट्वा तद्ग्राहिनारीपुरुषान् कारायां बद्ध्वा तेषां प्राणनाशपर्य्यन्तां विपक्षताम् अकरवम्। ");
INSERT INTO sandev_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","महायाजकः सभासदः प्राचीनलोकाश्च ममैतस्याः कथायाः प्रमाणं दातुं शक्नुवन्ति, यस्मात् तेषां समीपाद् दम्मेषकनगरनिवासिभ्रातृगणार्थम् आज्ञापत्राणि गृहीत्वा ये तत्र स्थितास्तान् दण्डयितुं यिरूशालमम् आनयनार्थं दम्मेषकनगरं गतोस्मि। ");
INSERT INTO sandev_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","किन्तु गच्छन् तन्नगरस्य समीपं प्राप्तवान् तदा द्वितीयप्रहरवेलायां सत्याम् अकस्माद् गगणान्निर्गत्य महती दीप्ति र्मम चतुर्दिशि प्रकाशितवती। ");
INSERT INTO sandev_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ततो मयि भूमौै पतिते सति, हे शौल हे शौल कुतो मां ताडयसि? माम्प्रति भाषित एतादृश एको रवोपि मया श्रुतः। ");
INSERT INTO sandev_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","तदाहं प्रत्यवदं, हे प्रभे को भवान्? ततः सोऽवादीत् यं त्वं ताडयसि स नासरतीयो यीशुरहं। ");
INSERT INTO sandev_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","मम सङ्गिनो लोकास्तां दीप्तिं दृष्ट्वा भियं प्राप्ताः, किन्तु माम्प्रत्युदितं तद्वाक्यं तेे नाबुध्यन्त। ");
INSERT INTO sandev_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","ततः परं पृष्टवानहं, हे प्रभो मया किं कर्त्तव्यं? ततः प्रभुरकथयत्, उत्थाय दम्मेषकनगरं याहि त्वया यद्यत् कर्त्तव्यं निरूपितमास्ते तत् तत्र त्वं ज्ञापयिष्यसे। ");
INSERT INTO sandev_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","अनन्तरं तस्याः खरतरदीप्तेः कारणात् किमपि न दृष्ट्वा सङ्गिगणेन धृतहस्तः सन् दम्मेषकनगरं व्रजितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","तन्नगरनिवासिनां सर्व्वेषां यिहूदीयानां मान्यो व्यवस्थानुसारेण भक्तश्च हनानीयनामा मानव एको ");
INSERT INTO sandev_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","मम सन्निधिम् एत्य तिष्ठन् अकथयत्, हे भ्रातः शौल सुदृष्टि र्भव तस्मिन् दण्डेऽहं सम्यक् तं दृष्टवान्। ");
INSERT INTO sandev_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","ततः स मह्यं कथितवान् यथा त्वम् ईश्वरस्याभिप्रायं वेत्सि तस्य शुद्धसत्त्वजनस्य दर्शनं प्राप्य तस्य श्रीमुखस्य वाक्यं शृणोषि तन्निमित्तम् अस्माकं पूर्व्वपुरुषाणाम् ईश्वरस्त्वां मनोनीतं कृतवानं। ");
INSERT INTO sandev_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","यतो यद्यद् अद्राक्षीरश्रौषीश्च सर्व्वेषां मानवानां समीपे त्वं तेषां साक्षी भविष्यसि। ");
INSERT INTO sandev_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","अतएव कुतो विलम्बसे? प्रभो र्नाम्ना प्रार्थ्य निजपापप्रक्षालनार्थं मज्जनाय समुत्तिष्ठ। ");
INSERT INTO sandev_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","ततः परं यिरूशालम्नगरं प्रत्यागत्य मन्दिरेऽहम् एकदा प्रार्थये, तस्मिन् समयेऽहम् अभिभूतः सन् प्रभूं साक्षात् पश्यन्, ");
INSERT INTO sandev_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","त्वं त्वरया यिरूशालमः प्रतिष्ठस्व यतो लोकामयि तव साक्ष्यं न ग्रहीष्यन्ति, माम्प्रत्युदितं तस्येदं वाक्यम् अश्रौषम्। ");
INSERT INTO sandev_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","ततोहं प्रत्यवादिषम् हे प्रभो प्रतिभजनभवनं त्वयि विश्वासिनो लोकान् बद्ध्वा प्रहृतवान्, ");
INSERT INTO sandev_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","तथा तव साक्षिणः स्तिफानस्य रक्तपातनसमये तस्य विनाशं सम्मन्य सन्निधौ तिष्ठन् हन्तृलोकानां वासांसि रक्षितवान्, एतत् ते विदुः। ");
INSERT INTO sandev_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","ततः सोऽकथयत् प्रतिष्ठस्व त्वां दूरस्थभिन्नदेशीयानां समीपं प्रेषयिष्ये। ");
INSERT INTO sandev_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","तदा लोका एतावत्पर्य्यन्तां तदीयां कथां श्रुत्वा प्रोच्चैरकथयन्, एनं भूमण्डलाद् दूरीकुरुत, एतादृशजनस्य जीवनं नोचितम्। ");
INSERT INTO sandev_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","इत्युच्चैः कथयित्वा वसनानि परित्यज्य गगणं प्रति धूलीरक्षिपन् ");
INSERT INTO sandev_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ततः सहस्रसेनापतिः पौलं दुर्गाभ्यन्तर नेतुं समादिशत्। एतस्य प्रतिकूलाः सन्तो लोकाः किन्निमित्तम् एतावदुच्चैःस्वरम् अकुर्व्वन्, एतद् वेत्तुं तं कशया प्रहृत्य तस्य परीक्षां कर्त्तुमादिशत्। ");
INSERT INTO sandev_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","पदातयश्चर्म्मनिर्म्मितरज्जुभिस्तस्य बन्धनं कर्त्तुमुद्यतास्तास्तदानीं पौलः सम्मुखस्थितं शतसेनापतिम् उक्तवान् दण्डाज्ञायाम् अप्राप्तायां किं रोमिलोकं प्रहर्त्तुं युष्माकम् अधिकारोस्ति? ");
INSERT INTO sandev_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","एनां कथां श्रुत्वा स सहस्रसेनापतेः सन्निधिं गत्वा तां वार्त्तामवदत् स रोमिलोक एतस्मात् सावधानः सन् कर्म्म कुरु। ");
INSERT INTO sandev_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","तस्मात् सहस्रसेनापति र्गत्वा तमप्राक्षीत् त्वं किं रोमिलोकः? इति मां ब्रूहि। सोऽकथयत् सत्यम्। ");
INSERT INTO sandev_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","ततः सहस्रसेनापतिः कथितवान् बहुद्रविणं दत्त्वाहं तत् पौरसख्यं प्राप्तवान्; किन्तु पौलः कथितवान् अहं जनुना तत् प्राप्तोऽस्मि। ");
INSERT INTO sandev_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","इत्थं सति ये प्रहारेण तं परीक्षितुं समुद्यता आसन् ते तस्य समीपात् प्रातिष्ठन्त; सहस्रसेनापतिस्तं रोमिलोकं विज्ञाय स्वयं यत् तस्य बन्धनम् अकार्षीत् तत्कारणाद् अबिभेत्। ");
INSERT INTO sandev_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","यिहूदीयलोकाः पौलं कुतोऽपवदन्ते तस्य वृत्तान्तं ज्ञातुं वाञ्छन् सहस्रसेनापतिः परेऽहनि पौलं बन्धनात् मोचयित्वा प्रधानयाजकान् महासभायाः सर्व्वलोकाश्च समुपस्थातुम् आदिश्य तेषां सन्निधौ पौलम् अवरोह्य स्थापितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","सभासद्लोकान् प्रति पौलोऽनन्यदृष्ट्या पश्यन् अकथयत्, हे भ्रातृगणा अद्य यावत् सरलेन सर्व्वान्तःकरणेनेश्वरस्य साक्षाद् आचरामि। ");
INSERT INTO sandev_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","अनेन हनानीयनामा महायाजकस्तं कपोले चपेटेनाहन्तुं समीपस्थलोकान् आदिष्टवान्। ");
INSERT INTO sandev_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","तदा पौलस्तमवदत्, हे बहिष्परिष्कृत, ईश्वरस्त्वां प्रहर्त्तुम् उद्यतोस्ति, यतो व्यवस्थानुसारेण विचारयितुम् उपविश्य व्यवस्थां लङ्घित्वा मां प्रहर्त्तुम् आज्ञापयसि। ");
INSERT INTO sandev_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","ततो निकटस्था लोका अकथयन्, त्वं किम् ईश्वरस्य महायाजकं निन्दसि? ");
INSERT INTO sandev_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","ततः पौलः प्रतिभाषितवान् हे भ्रातृगण महायाजक एष इति न बुद्धं मया तदन्यच्च स्वलोकानाम् अधिपतिं प्रति दुर्व्वाक्यं मा कथय, एतादृशी लिपिरस्ति। ");
INSERT INTO sandev_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","अनन्तरं पौलस्तेषाम् अर्द्धं सिदूकिलोका अर्द्धं फिरूशिलोका इति दृष्ट्वा प्रोच्चैः सभास्थलोकान् अवदत् हे भ्रातृगण अहं फिरूशिमतावलम्बी फिरूशिनः सत्नानश्च, मृतलोकानाम् उत्थाने प्रत्याशाकरणाद् अहमपवादितोस्मि। ");
INSERT INTO sandev_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","इति कथायां कथितायां फिरूशिसिदूकिनोः परस्परं भिन्नवाक्यत्वात् सभाया मध्ये द्वौ संघौ जातौ। ");
INSERT INTO sandev_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","यतः सिदूकिलोका उत्थानं स्वर्गीयदूता आत्मानश्च सर्व्वेषाम् एतेषां कमपि न मन्यन्ते, किन्तु फिरूशिनः सर्व्वम् अङ्गीकुर्व्वन्ति। ");
INSERT INTO sandev_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","ततः परस्परम् अतिशयकोलाहले समुपस्थिते फिरूशिनां पक्षीयाः सभास्था अध्यापकाः प्रतिपक्षा उत्तिष्ठन्तो ऽकथयन्, एतस्य मानवस्य कमपि दोषं न पश्यामः; यदि कश्चिद् आत्मा वा कश्चिद् दूत एनं प्रत्यादिशत् तर्हि वयम् ईश्वरस्य प्रातिकूल्येन न योत्स्यामः। ");
INSERT INTO sandev_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","तस्माद् अतीव भिन्नवाक्यत्वे सति ते पौलं खण्डं खण्डं करिष्यन्तीत्याशङ्कया सहस्रसेनापतिः सेनागणं तत्स्थानं यातुं सभातो बलात् पौलं धृत्वा दुर्गं नेतञ्चाज्ञापयत्। ");
INSERT INTO sandev_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","रात्रो प्रभुस्तस्य समीपे तिष्ठन् कथितवान् हे पौल निर्भयो भव यथा यिरूशालम्नगरे मयि साक्ष्यं दत्तवान् तथा रोमानगरेपि त्वया दातव्यम्। ");
INSERT INTO sandev_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","दिने समुपस्थिते सति कियन्तो यिहूदीयलोका एकमन्त्रणाः सन्तः पौलं न हत्वा भोजनपाने करिष्याम इति शपथेन स्वान् अबध्नन्। ");
INSERT INTO sandev_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","चत्वारिंशज्जनेभ्योऽधिका लोका इति पणम् अकुर्व्वन्। ");
INSERT INTO sandev_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","ते महायाजकानां प्राचीनलोकानाञ्च समीपं गत्वा कथयन्, वयं पौलं न हत्वा किमपि न भोक्ष्यामहे दृढेनानेन शपथेन बद्ध्वा अभवाम। ");
INSERT INTO sandev_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","अतएव साम्प्रतं सभासद्लोकैः सह वयं तस्मिन् कञ्चिद् विशेषविचारं करिष्यामस्तदर्थं भवान् श्वो ऽस्माकं समीपं तम् आनयत्विति सहस्रसेनापतये निवेदनं कुरुत तेन युष्माकं समीपं उपस्थितेः पूर्व्वं वयं तं हन्तु सज्जिष्याम। ");
INSERT INTO sandev_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","तदा पौलस्य भागिनेयस्तेषामिति मन्त्रणां विज्ञाय दुर्गं गत्वा तां वार्त्तां पौलम् उक्तवान्। ");
INSERT INTO sandev_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","तस्मात् पौल एकं शतसेनापतिम् आहूय वाक्यमिदम् भाषितवान् सहस्रसेनापतेः समीपेऽस्य युवमनुष्यस्य किञ्चिन्निवेदनम् आस्ते, तस्मात् तत्सविधम् एनं नय। ");
INSERT INTO sandev_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","ततः स तमादाय सहस्रसेनापतेः समीपम् उपस्थाय कथितवान्, भवतः समीपेऽस्य किमपि निवेदनमास्ते तस्मात् बन्दिः पौलो मामाहूय भवतः समीपम् एनम् आनेतुं प्रार्थितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","तदा सहस्रसेनापतिस्तस्य हस्तं धृत्वा निर्जनस्थानं नीत्वा पृष्ठवान् तव किं निवेदनं? तत् कथय। ");
INSERT INTO sandev_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","ततः सोकथयत्, यिहूदीयलाकाः पौले कमपि विशेषविचारं छलं कृत्वा तं सभां नेतुं भवतः समीपे निवेदयितुं अमन्त्रयन्। ");
INSERT INTO sandev_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","किन्तु मवता तन्न स्वीकर्त्तव्यं यतस्तेषां मध्येवर्त्तिनश्चत्वारिंशज्जनेभ्यो ऽधिकलोका एकमन्त्रणा भूत्वा पौलं न हत्वा भोजनं पानञ्च न करिष्याम इति शपथेन बद्धाः सन्तो घातका इव सज्जिता इदानीं केवलं भवतो ऽनुमतिम् अपेक्षन्ते। ");
INSERT INTO sandev_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","यामिमां कथां त्वं निवेदितवान् तां कस्मैचिदपि मा कथयेत्युक्त्वा सहस्रसेनापतिस्तं युवानं विसृष्टवान्। ");
INSERT INTO sandev_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","अनन्तरं सहस्रसेनापति र्द्वौ शतसेनापती आहूयेदम् आदिशत्, युवां रात्रौ प्रहरैकावशिष्टायां सत्यां कैसरियानगरं यातुं पदातिसैन्यानां द्वे शते घोटकारोहिसैन्यानां सप्ततिं शक्तिधारिसैन्यानां द्वे शते च जनान् सज्जितान् कुरुतं। ");
INSERT INTO sandev_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","पौलम् आरोहयितुं फीलिक्षाधिपतेः समीपं निर्व्विघ्नं नेतुञ्च वाहनानि समुपस्थापयतं। ");
INSERT INTO sandev_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","अपरं स पत्रं लिखित्वा दत्तवान् तल्लिखितमेतत्, ");
INSERT INTO sandev_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","महामहिमश्रीयुक्तफीलिक्षाधिपतये क्लौदियलुषियस्य नमस्कारः। ");
INSERT INTO sandev_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","यिहूदीयलोकाः पूर्व्वम् एनं मानवं धृत्वा स्वहस्तै र्हन्तुम् उद्यता एतस्मिन्नन्तरे ससैन्योहं तत्रोपस्थाय एष जनो रोमीय इति विज्ञाय तं रक्षितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","किन्निमित्तं ते तमपवदन्ते तज्ज्ञातुं तेषा सभां तमानायितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","ततस्तेषां व्यवस्थाया विरुद्धया कयाचन कथया सोऽपवादितोऽभवत्, किन्तु स शृङ्खलबन्धनार्हो वा प्राणनाशार्हो भवतीदृशः कोप्यपराधो मयास्य न दृष्टः। ");
INSERT INTO sandev_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","तथापि मनुष्यस्यास्य वधार्थं यिहूदीया घातकाइव सज्जिता एतां वार्त्तां श्रुत्वा तत्क्षणात् तव समीपमेनं प्रेषितवान् अस्यापवादकांश्च तव समीपं गत्वापवदितुम् आज्ञापयम्। भवतः कुशलं भूयात्। ");
INSERT INTO sandev_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","सैन्यगण आज्ञानुसारेण पौलं गृहीत्वा तस्यां रजन्याम् आन्तिपात्रिनगरम् आनयत्। ");
INSERT INTO sandev_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","परेऽहनि तेन सह यातुं घोटकारूढसैन्यगणं स्थापयित्वा परावृत्य दुर्गं गतवान्। ");
INSERT INTO sandev_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","ततः परे घोटकारोहिसैन्यगणः कैसरियानगरम् उपस्थाय तत्पत्रम् अधिपतेः करे समर्प्य तस्य समीपे पौलम् उपस्थापितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","तदाधिपतिस्तत्पत्रं पठित्वा पृष्ठवान् एष किम्प्रदेशीयो जनः? स किलिकियाप्रदेशीय एको जन इति ज्ञात्वा कथितवान्, ");
INSERT INTO sandev_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","तवापवादकगण आगते तव कथां श्रोष्यामि। हेरोद्राजगृहे तं स्थापयितुम् आदिष्टवान्। ");
INSERT INTO sandev_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","पञ्चभ्यो दिनेभ्यः परं हनानीयनामा महायाजकोऽधिपतेः समक्षं पौलस्य प्रातिकूल्येन निवेदयितुं तर्तुल्लनामानं कञ्चन वक्तारं प्राचीनजनांश्च सङ्गिनः कृत्वा कैसरियानगरम् आगच्छत्। ");
INSERT INTO sandev_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","ततः पौले समानीते सति तर्तुल्लस्तस्यापवादकथां कथयितुम् आरभत हे महामहिमफीलिक्ष भवतो वयम् अतिनिर्व्विघ्नं कालं यापयामो भवतः परिणामदर्शितया एतद्देशीयानां बहूनि मङ्गलानि घटितानि, ");
INSERT INTO sandev_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","इति हेतो र्वयमतिकृतज्ञाः सन्तः सर्व्वत्र सर्व्वदा भवतो गुणान् गायमः। ");
INSERT INTO sandev_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","किन्तु बहुभिः कथाभि र्भवन्तं येन न विरञ्जयामि तस्माद् विनये भवान् बनुकम्प्य मदल्पकथां शृणोतु। ");
INSERT INTO sandev_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","एष महामारीस्वरूपो नासरतीयमतग्राहिसंघातस्य मुख्यो भूत्वा सर्व्वदेशेषु सर्व्वेषां यिहूदीयानां राजद्रोहाचरणप्रवृत्तिं जनयतीत्यस्माभि र्निश्चितं। ");
INSERT INTO sandev_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","स मन्दिरमपि अशुचि कर्त्तुं चेष्टितवान्; इति कारणाद् वयम् एनं धृत्वा स्वव्यवस्थानुसारेण विचारयितुं प्रावर्त्तामहि; ");
INSERT INTO sandev_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","किन्तु लुषियः सहस्रसेनापतिरागत्य बलाद् अस्माकं करेभ्य एनं गृहीत्वा ");
INSERT INTO sandev_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","एतस्यापवादकान् भवतः समीपम् आगन्तुम् आज्ञापयत्। वयं यस्मिन् तमपवादामो भवता पदपवादकथायां विचारितायां सत्यां सर्व्वं वृत्तान्तं वेदितुं शक्ष्यते। ");
INSERT INTO sandev_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","ततो यिहूदीया अपि स्वीकृत्य कथितवन्त एषा कथा प्रमाणम्। ");
INSERT INTO sandev_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","अधिपतौ कथां कथयितुं पौलं प्रतीङ्गितं कृतवति स कथितवान् भवान् बहून् वत्सरान् यावद् एतद्देशस्य शासनं करोतीति विज्ञाय प्रत्युत्तरं दातुम् अक्षोभोऽभवम्। ");
INSERT INTO sandev_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","अद्य केवलं द्वादश दिनानि यातानि, अहम् आराधनां कर्त्तुं यिरूशालमनगरं गतवान् एषा कथा भवता ज्ञातुं शक्यते; ");
INSERT INTO sandev_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","किन्त्विभे मां मध्येमन्दिरं केनापि सह वितण्डां कुर्व्वन्तं कुत्रापि भजनभवने नगरे वा लोकान् कुप्रवृत्तिं जनयन्तुं न दृष्टवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","इदानीं यस्मिन् यस्मिन् माम् अपवदन्ते तस्य किमपि प्रमाणं दातुं न शक्नुवन्ति। ");
INSERT INTO sandev_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","किन्तु भविष्यद्वाक्यग्रन्थे व्यवस्थाग्रन्थे च या या कथा लिखितास्ते तासु सर्व्वासु विश्वस्य यन्मतम् इमे विधर्म्मं जानन्ति तन्मतानुसारेणाहं निजपितृपुरुषाणाम् ईश्वरम् आराधयामीत्यहं भवतः समक्षम् अङ्गीकरोमि। ");
INSERT INTO sandev_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","धार्म्मिकाणाम् अधार्म्मिकाणाञ्च प्रमीतलोकानामेवोत्थानं भविष्यतीति कथामिमे स्वीकुर्व्वन्ति तथाहमपि तस्मिन् ईश्वरे प्रत्याशां करोमि; ");
INSERT INTO sandev_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","ईश्वरस्य मानवानाञ्च समीपे यथा निर्दोषो भवामि तदर्थं सततं यत्नवान् अस्मि। ");
INSERT INTO sandev_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","बहुषु वत्सरेषु गतेषु स्वदेशीयलोकानां निमित्तं दानीयद्रव्याणि नैवेद्यानि च समादाय पुनरागमनं कृतवान्। ");
INSERT INTO sandev_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","ततोहं शुचि र्भूत्वा लोकानां समागमं कलहं वा न कारितवान् तथाप्याशियादेशीयाः कियन्तो यिहुदीयलोका मध्येमन्दिरं मां धृतवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","ममोपरि यदि काचिदपवादकथास्ति तर्हि भवतः समीपम् उपस्थाय तेषामेव साक्ष्यदानम् उचितम्। ");
INSERT INTO sandev_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","नोचेत् पूर्व्वे महासभास्थानां लोकानां सन्निधौ मम दण्डायमानत्वसमये, अहमद्य मृतानामुत्थाने युष्माभि र्विचारितोस्मि, ");
INSERT INTO sandev_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","तेषां मध्ये तिष्ठन्नहं यामिमां कथामुच्चैः स्वरेण कथितवान् तदन्यो मम कोपि दोषोऽलभ्यत न वेति वरम् एते समुपस्थितलोका वदन्तु। ");
INSERT INTO sandev_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","तदा फीलिक्ष एतां कथां श्रुत्वा तन्मतस्य विशेषवृत्तान्तं विज्ञातुं विचारं स्थगितं कृत्वा कथितवान् लुषिये सहस्रसेनापतौ समायाते सति युष्माकं विचारम् अहं निष्पादयिष्यामि। ");
INSERT INTO sandev_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","अनन्तरं बन्धनं विना पौलं रक्षितुं तस्य सेवनाय साक्षात्करणाय वा तदीयात्मीयबन्धुजनान् न वारयितुञ्च शमसेनापतिम् आदिष्टवान्। ");
INSERT INTO sandev_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","अल्पदिनात् परं फीलिक्षोऽधिपति र्द्रुषिल्लानाम्ना यिहूदीयया स्वभार्य्यया सहागत्य पौलमाहूय तस्य मुखात् ख्रीष्टधर्म्मस्य वृत्तान्तम् अश्रौषीत्। ");
INSERT INTO sandev_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","पौलेन न्यायस्य परिमितभोगस्य चरमविचारस्य च कथायां कथितायां सत्यां फीलिक्षः कम्पमानः सन् व्याहरद् इदानीं याहि, अहम् अवकाशं प्राप्य त्वाम् आहूस्यामि। ");
INSERT INTO sandev_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","मुक्तिप्रप्त्यर्थं पौलेन मह्यं मुद्रादास्यन्ते इति पत्याशां कृत्वा स पुनः पुनस्तमाहूय तेन साकं कथोपकथनं कृतवान्। ");
INSERT INTO sandev_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","किन्तु वत्सरद्वयात् परं पर्कियफीष्ट फालिक्षस्य पदं प्राप्ते सति फीलिक्षो यिहूदीयान् सन्तुष्टान् चिकीर्षन् पौलं बद्धं संस्थाप्य गतवान्। ");
INSERT INTO sandev_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","अनन्तरं फीष्टो निजराज्यम् आगत्य दिनत्रयात् परं कैसरियातो यिरूशालम्नगरम् आगमत्। ");
INSERT INTO sandev_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","तदा महायाजको यिहूदीयानां प्रधानलोकाश्च तस्य समक्षं पौलम् अपावदन्त। ");
INSERT INTO sandev_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","भवान् तं यिरूशालमम् आनेतुम् आज्ञापयत्विति विनीय ते तस्माद् अनुग्रहं वाञ्छितवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","यतः पथिमध्ये गोपनेन पौलं हन्तुं तै र्घातका नियुक्ताः। फीष्ट उत्तरं दत्तवान् पौलः कैसरियायां स्थास्यति पुनरल्पदिनात् परम् अहं तत्र यास्यामि। ");
INSERT INTO sandev_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","ततस्तस्य मानुषस्य यदि कश्चिद् अपराधस्तिष्ठति तर्हि युष्माकं ये शक्नुवन्ति ते मया सह तत्र गत्वा तमपवदन्तु स एतां कथां कथितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","दशदिवसेभ्योऽधिकं विलम्ब्य फीष्टस्तस्मात् कैसरियानगरं गत्वा परस्मिन् दिवसे विचारासन उपदिश्य पौलम् आनेतुम् आज्ञापयत्। ");
INSERT INTO sandev_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","पौले समुपस्थिते सति यिरूशालम्नगराद् आगता यिहूदीयलोकास्तं चतुर्दिशि संवेष्ट्य तस्य विरुद्धं बहून् महादोषान् उत्थापितवन्तः किन्तु तेषां किमपि प्रमाणं दातुं न शक्नुवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","ततः पौलः स्वस्मिन् उत्तरमिदम् उदितवान्, यिहूदीयानां व्यवस्थाया मन्दिरस्य कैसरस्य वा प्रतिकूलं किमपि कर्म्म नाहं कृतवान्। ");
INSERT INTO sandev_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","किन्तु फीष्टो यिहूदीयान् सन्तुष्टान् कर्त्तुम् अभिलषन् पौलम् अभाषत त्वं किं यिरूशालमं गत्वास्मिन् अभियोगे मम साक्षाद् विचारितो भविष्यसि? ");
INSERT INTO sandev_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","ततः पौल उत्तरं प्रोक्तवान्, यत्र मम विचारो भवितुं योग्यः कैसरस्य तत्र विचारासन एव समुपस्थितोस्मि; अहं यिहूदीयानां कामपि हानिं नाकार्षम् इति भवान् यथार्थतो विजानाति। ");
INSERT INTO sandev_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","कञ्चिदपराधं किञ्चन वधार्हं कर्म्म वा यद्यहम् अकरिष्यं तर्हि प्राणहननदण्डमपि भोक्तुम् उद्यतोऽभविष्यं, किन्तु ते मम समपवादं कुर्व्वन्ति स यदि कल्पितमात्रो भवति तर्हि तेषां करेषु मां समर्पयितुं कस्याप्यधिकारो नास्ति, कैसरस्य निकटे मम विचारो भवतु। ");
INSERT INTO sandev_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","तदा फीष्टो मन्त्रिभिः सार्द्धं संमन्त्र्य पौलाय कथितवान्, कैसरस्य निकटे किं तव विचारो भविष्यति? कैसरस्य समीपं गमिष्यसि। ");
INSERT INTO sandev_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","कियद्दिनेभ्यः परम् आग्रिप्पराजा बर्णीकी च फीष्टं साक्षात् कर्त्तुं कैसरियानगरम् आगतवन्तौ। ");
INSERT INTO sandev_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","तदा तौ बहुदिनानि तत्र स्थितौ ततः फीष्टस्तं राजानं पौलस्य कथां विज्ञाप्य कथयितुम् आरभत पौलनामानम् एकं बन्दि फीलिक्षो बद्धं संस्थाप्य गतवान्। ");
INSERT INTO sandev_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","यिरूशालमि मम स्थितिकाले महायाजको यिहूदीयानां प्राचीनलोकाश्च तम् अपोद्य तम्प्रति दण्डाज्ञां प्रार्थयन्त। ");
INSERT INTO sandev_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","ततोहम् इत्युत्तरम् अवदं यावद् अपोदितो जनः स्वापवादकान् साक्षात् कृत्वा स्वस्मिन् योऽपराध आरोपितस्तस्य प्रत्युत्तरं दातुं सुयोगं न प्राप्नोति, तावत्कालं कस्यापि मानुषस्य प्राणनाशाज्ञापनं रोमिलोकानां रीति र्नहि। ");
INSERT INTO sandev_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","ततस्तेष्वत्रागतेषु परस्मिन् दिवसेऽहम् अविलम्बं विचारासन उपविश्य तं मानुषम् आनेतुम् आज्ञापयम्। ");
INSERT INTO sandev_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","तदनन्तरं तस्यापवादका उपस्थाय यादृशम् अहं चिन्तितवान् तादृशं कञ्चन महापवादं नोत्थाप्य ");
INSERT INTO sandev_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","स्वेषां मते तथा पौलो यं सजीवं वदति तस्मिन् यीशुनामनि मृतजने च तस्य विरुद्धं कथितवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","ततोहं तादृग्विचारे संशयानः सन् कथितवान् त्वं यिरूशालमं गत्वा किं तत्र विचारितो भवितुम् इच्छसि? ");
INSERT INTO sandev_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","तदा पौलो महाराजस्य निकटे विचारितो भवितुं प्रार्थयत, तस्माद् यावत्कालं तं कैसरस्य समीपं प्रेषयितुं न शक्नोमि तावत्कालं तमत्र स्थापयितुम् आदिष्टवान्। ");
INSERT INTO sandev_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","तत आग्रिप्पः फीष्टम् उक्तवान्, अहमपि तस्य मानुषस्य कथां श्रोतुम् अभिलषामि। तदा फीष्टो व्याहरत् श्वस्तदीयां कथां त्वं श्रोष्यसि। ");
INSERT INTO sandev_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","परस्मिन् दिवसे आग्रिप्पो बर्णीकी च महासमागमं कृत्वा प्रधानवाहिनीपतिभि र्नगरस्थप्रधानलोकैश्च सह मिलित्वा राजगृहमागत्य समुपस्थितौ तदा फीष्टस्याज्ञया पौल आनीतोऽभवत्। ");
INSERT INTO sandev_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","तदा फीष्टः कथितवान् हे राजन् आग्रिप्प हे उपस्थिताः सर्व्वे लोका यिरूशालम्नगरे यिहूदीयलोकसमूहो यस्मिन् मानुषे मम समीपे निवेदनं कृत्वा प्रोच्चैः कथामिमां कथितवान् पुनरल्पकालमपि तस्य जीवनं नोचितं तमेतं मानुषं पश्यत। ");
INSERT INTO sandev_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","किन्त्वेष जनः प्राणनाशर्हं किमपि कर्म्म न कृतवान् इत्यजानां तथापि स महाराजस्य सन्निधौ विचारितो भवितुं प्रार्थयत तस्मात् तस्य समीपं तं प्रेषयितुं मतिमकरवम्। ");
INSERT INTO sandev_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","किन्तु श्रीयुक्तस्य समीपम् एतस्मिन् किं लेखनीयम् इत्यस्य कस्यचिन् निर्णयस्य न जातत्वाद् एतस्य विचारे सति यथाहं लेखितुं किञ्चन निश्चितं प्राप्नोमि तदर्थं युष्माकं समक्षं विशेषतो हे आग्रिप्पराज भवतः समक्षम् एतम् आनये। ");
INSERT INTO sandev_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","यतो बन्दिप्रेषणसमये तस्याभियोगस्य किञ्चिदलेखनम् अहम् अयुक्तं जानामि। ");
INSERT INTO sandev_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","तत आग्रिप्पः पौलम् अवादीत्, निजां कथां कथयितुं तुभ्यम् अनुमति र्दीयते। तस्मात् पौलः करं प्रसार्य्य स्वस्मिन् उत्तरम् अवादीत्। ");
INSERT INTO sandev_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","हे आग्रिप्पराज यत्कारणादहं यिहूदीयैरपवादितो ऽभवं तस्य वृत्तान्तम् अद्य भवतः साक्षान् निवेदयितुमनुमतोहम् इदं स्वीयं परमं भाग्यं मन्ये; ");
INSERT INTO sandev_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","यतो यिहूदीयलोकानां मध्ये या या रीतिः सूक्ष्मविचाराश्च सन्ति तेषु भवान् विज्ञतमः; अतएव प्रार्थये धैर्य्यमवलम्ब्य मम निवेदनं शृणोतु। ");
INSERT INTO sandev_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","अहं यिरूशालम्नगरे स्वदेशीयलोकानां मध्ये तिष्ठन् आ यौवनकालाद् यद्रूपम् आचरितवान् तद् यिहूदीयलोकाः सर्व्वे विदन्ति। ");
INSERT INTO sandev_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","अस्माकं सर्व्वेभ्यः शुद्धतमं यत् फिरूशीयमतं तदवलम्बी भूत्वाहं कालं यापितवान् ये जना आ बाल्यकालान् मां जानान्ति ते एतादृशं साक्ष्यं यदि ददाति तर्हि दातुं शक्नुवन्ति। ");
INSERT INTO sandev_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","किन्तु हे आग्रिप्पराज ईश्वरोऽस्माकं पूर्व्वपुरुषाणां निकटे यद् अङ्गीकृतवान् तस्य प्रत्याशाहेतोरहम् इदानीं विचारस्थाने दण्डायमानोस्मि। ");
INSERT INTO sandev_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","तस्याङ्गीकारस्य फलं प्राप्तुम् अस्माकं द्वादशवंशा दिवानिशं महायत्नाद् ईश्वरसेवनं कृत्वा यां प्रत्याशां कुर्व्वन्ति तस्याः प्रत्याशाया हेतोरहं यिहूदीयैरपवादितोऽभवम्। ");
INSERT INTO sandev_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","ईश्वरो मृतान् उत्थापयिष्यतीति वाक्यं युष्माकं निकटेऽसम्भवं कुतो भवेत्? ");
INSERT INTO sandev_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","नासरतीययीशो र्नाम्नो विरुद्धं नानाप्रकारप्रतिकूलाचरणम् उचितम् इत्यहं मनसि यथार्थं विज्ञाय ");
INSERT INTO sandev_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","यिरूशालमनगरे तदकरवं फलतः प्रधानयाजकस्य निकटात् क्षमतां प्राप्य बहून् पवित्रलोकान् कारायां बद्धवान् विशेषतस्तेषां हननसमये तेषां विरुद्धां निजां सम्मतिं प्रकाशितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","वारं वारं भजनभवनेषु तेभ्यो दण्डं प्रदत्तवान् बलात् तं धर्म्मं निन्दयितवांश्च पुनश्च तान् प्रति महाक्रोधाद् उन्मत्तः सन् विदेशीयनगराणि यावत् तान् ताडितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","इत्थं प्रधानयाजकस्य समीपात् शक्तिम् आज्ञापत्रञ्च लब्ध्वा दम्मेषक्नगरं गतवान्। ");
INSERT INTO sandev_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","तदाहं हे राजन् मार्गमध्ये मध्याह्नकाले मम मदीयसङ्गिनां लोकानाञ्च चतसृषु दिक्षु गगणात् प्रकाशमानां भास्करतोपि तेजस्वतीं दीप्तिं दृष्टवान्। ");
INSERT INTO sandev_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","तस्माद् अस्मासु सर्व्वेषु भूमौ पतितेषु सत्सु हे शौल है शौल कुतो मां ताडयसि? कण्टकानां मुखे पादाहननं तव दुःसाध्यम् इब्रीयभाषया गदित एतादृश एकः शब्दो मया श्रुतः। ");
INSERT INTO sandev_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","तदाहं पृष्टवान् हे प्रभो को भवान्? ततः स कथितवान् यं यीशुं त्वं ताडयसि सोहं, ");
INSERT INTO sandev_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","किन्तु समुत्तिष्ठ त्वं यद् दृष्टवान् इतः पुनञ्च यद्यत् त्वां दर्शयिष्यामि तेषां सर्व्वेषां कार्य्याणां त्वां साक्षिणं मम सेवकञ्च कर्त्तुम् दर्शनम् अदाम्। ");
INSERT INTO sandev_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","विशेषतो यिहूदीयलोकेभ्यो भिन्नजातीयेभ्यश्च त्वां मनोनीतं कृत्वा तेषां यथा पापमोचनं भवति ");
INSERT INTO sandev_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","यथा ते मयि विश्वस्य पवित्रीकृतानां मध्ये भागं प्राप्नुवन्ति तदभिप्रायेण तेषां ज्ञानचक्षूंषि प्रसन्नानि कर्त्तुं तथान्धकाराद् दीप्तिं प्रति शैतानाधिकाराच्च ईश्वरं प्रति मतीः परावर्त्तयितुं तेषां समीपं त्वां प्रेष्यामि। ");
INSERT INTO sandev_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","हे आग्रिप्पराज एतादृशं स्वर्गीयप्रत्यादेशं अग्राह्यम् अकृत्वाहं ");
INSERT INTO sandev_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","प्रथमतो दम्मेषक्नगरे ततो यिरूशालमि सर्व्वस्मिन् यिहूदीयदेशे अन्येषु देशेषु च येेन लोका मतिं परावर्त्त्य ईश्वरं प्रति परावर्त्तयन्ते, मनःपरावर्त्तनयोग्यानि कर्म्माणि च कुर्व्वन्ति तादृशम् उपदेशं प्रचारितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","एतत्कारणाद् यिहूदीया मध्येमन्दिरं मां धृत्वा हन्तुम् उद्यताः। ");
INSERT INTO sandev_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","तथापि ख्रीष्टो दुःखं भुक्त्वा सर्व्वेषां पूर्व्वं श्मशानाद् उत्थाय निजदेशीयानां भिन्नदेशीयानाञ्च समीपे दीप्तिं प्रकाशयिष्यति ");
INSERT INTO sandev_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","भविष्यद्वादिगणो मूसाश्च भाविकार्य्यस्य यदिदं प्रमाणम् अददुरेतद् विनान्यां कथां न कथयित्वा ईश्वराद् अनुग्रहं लब्ध्वा महतां क्षुद्राणाञ्च सर्व्वेषां समीपे प्रमाणं दत्त्वाद्य यावत् तिष्ठामि। ");
INSERT INTO sandev_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","तस्यमां कथां निशम्य फीष्ट उच्चैः स्वरेण कथितवान् हे पौल त्वम् उन्मत्तोसि बहुविद्याभ्यासेन त्वं हतज्ञानो जातः। ");
INSERT INTO sandev_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","स उक्तवान् हे महामहिम फीष्ट नाहम् उन्मत्तः किन्तु सत्यं विवेचनीयञ्च वाक्यं प्रस्तौमि। ");
INSERT INTO sandev_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","यस्य साक्षाद् अक्षोभः सन् कथां कथयामि स राजा तद्वृत्तान्तं जानाति तस्य समीपे किमपि गुप्तं नेति मया निश्चितं बुध्यते यतस्तद् विजने न कृतं। ");
INSERT INTO sandev_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","हे आग्रिप्पराज भवान् किं भविष्यद्वादिगणोक्तानि वाक्यानि प्रत्येति? भवान् प्रत्येति तदहं जानामि। ");
INSERT INTO sandev_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","तत आग्रिप्पः पौलम् अभिहितवान् त्वं प्रवृत्तिं जनयित्वा प्रायेण मामपि ख्रीष्टीयं करोषि। ");
INSERT INTO sandev_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","ततः सोऽवादीत् भवान् ये ये लोकाश्च मम कथाम् अद्य शृण्वन्ति प्रायेण इति नहि किन्त्वेतत् शृङ्खलबन्धनं विना सर्व्वथा ते सर्व्वे मादृशा भवन्त्वितीश्वस्य समीपे प्रार्थयेऽहम्। ");
INSERT INTO sandev_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","एतस्यां कथायां कथितायां स राजा सोऽधिपति र्बर्णीकी सभास्था लोकाश्च तस्माद् उत्थाय ");
INSERT INTO sandev_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","गोपने परस्परं विविच्य कथितवन्त एष जनो बन्धनार्हं प्राणहननार्हं वा किमपि कर्म्म नाकरोत्। ");
INSERT INTO sandev_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","तत आग्रिप्पः फीष्टम् अवदत्, यद्येष मानुषः कैसरस्य निकटे विचारितो भवितुं न प्रार्थयिष्यत् तर्हि मुक्तो भवितुम् अशक्ष्यत्। ");
INSERT INTO sandev_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","जलपथेनास्माकम् इतोलियादेशं प्रति यात्रायां निश्चितायां सत्यां ते यूलियनाम्नो महाराजस्य संघातान्तर्गतस्य सेनापतेः समीपे पौलं तदन्यान् कतिनयजनांश्च समार्पयन्। ");
INSERT INTO sandev_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","वयम् आद्रामुत्तीयं पोतमेकम् आरुह्य आशियादेशस्य तटसमीपेन यातुं मतिं कृत्वा लङ्गरम् उत्थाप्य पोतम् अमोचयाम; माकिदनियादेशस्थथिषलनीकीनिवास्यारिस्तार्खनामा कश्चिद् जनोऽस्माभिः सार्द्धम् आसीत्। ");
INSERT INTO sandev_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","परस्मिन् दिवसे ऽस्माभिः सीदोन्नगरे पोते लागिते तत्र यूलियः सेनापतिः पौलं प्रति सौजन्यं प्रदर्थ्य सान्त्वनार्थं बन्धुबान्धवान् उपयातुम् अनुजज्ञौ। ");
INSERT INTO sandev_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","तस्मात् पोते मोचिते सति सम्मुखवायोः सम्भवाद् वयं कुप्रोपद्वीपस्य तीरसमीपेन गतवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","किलिकियायाः पाम्फूलियायाश्च समुद्रस्य पारं गत्वा लूकियादेशान्तर्गतं मुरानगरम् उपातिष्ठाम। ");
INSERT INTO sandev_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","तत्स्थानाद् इतालियादेशं गच्छति यः सिकन्दरियानगरस्य पोतस्तं तत्र प्राप्य शतसेनापतिस्तं पोतम् अस्मान् आरोहयत्। ");
INSERT INTO sandev_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","ततः परं बहूनि दिनानि शनैः शनैः र्गत्वा क्नीदपार्श्वोपस्थ्तिेः पूर्व्वं प्रतिकूलेन पवनेन वयं सल्मोन्याः सम्मुखम् उपस्थाय क्रीत्युपद्वीपस्य तीरसमीपेन गतवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","कष्टेन तमुत्तीर्य्य लासेयानगरस्याधः सुन्दरनामकं खातम् उपातिष्ठाम। ");
INSERT INTO sandev_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","इत्थं बहुतिथः कालो यापित उपवासदिनञ्चातीतं, तत्कारणात् नौवर्त्मनि भयङ्करे सति पौलो विनयेन कथितवान्, ");
INSERT INTO sandev_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","हे महेच्छा अहं निश्चयं जानामि यात्रायामस्याम् अस्माकं क्लेशा बहूनामपचयाश्च भविष्यन्ति, ते केवलं पोतसामग्र्योरिति नहि, किन्त्वस्माकं प्राणानामपि। ");
INSERT INTO sandev_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","तदा शतसेनापतिः पौैेलोक्तवाक्यतोपि कर्णधारस्य पोतवणिजश्च वाक्यं बहुमंस्त। ");
INSERT INTO sandev_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","तत् खातं शीतकाले वासार्हस्थानं न तस्माद् अवाचीप्रतीचोर्दिशोः क्रीत्याः फैनीकियखातं यातुं यदि शक्नुवन्तस्तर्हि तत्र शीतकालं यापयितुं प्रायेण सर्व्वे मन्त्रयामासुः। ");
INSERT INTO sandev_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","ततः परं दक्षिणवायु र्मन्दं वहतीति विलोक्य निजाभिप्रायस्य सिद्धेः सुयोगो भवतीति बुद्ध्वा पोतं मोचयित्वा क्रीत्युपद्वीपस्य तीरसमीपेन चलितवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","किन्त्वल्पक्षणात् परमेव उरक्लुदोन्नामा प्रतिकूलः प्रचण्डो वायु र्वहन् पोतेऽलगीत् ");
INSERT INTO sandev_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","तस्याभिमुखं गन्तुम् पोतस्याशक्तत्वाद् वयं वायुना स्वयं नीताः। ");
INSERT INTO sandev_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","अनन्तरं क्लौदीनाम्न उपद्वीपस्य कूलसमीपेन पोतं गमयित्वा बहुना कष्टेन क्षुद्रनावम् अरक्षाम। ");
INSERT INTO sandev_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","ते तामारुह्य रज्ज्चा पोतस्याधोभागम् अबध्नन् तदनन्तरं चेत् पोतो सैकते लगतीति भयाद् वातवसनान्यमोचयन् ततः पोतो वायुना चालितः। ");
INSERT INTO sandev_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","किन्तु क्रमशो वायोः प्रबलत्वात् पोतो दोलायमानोऽभवत् परस्मिन् दिवसे पोतस्थानि कतिपयानि द्रव्याणि तोये निक्षिप्तानि। ");
INSERT INTO sandev_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","तृतीयदिवसे वयं स्वहस्तैः पोतसज्जनद्रव्याणि निक्षिप्तवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","ततो बहुदिनानि यावत् सूर्य्यनक्षत्रादीनि समाच्छन्नानि ततो ऽतीव वात्यागमाद् अस्माकं प्राणरक्षायाः कापि प्रत्याशा नातिष्ठत्। ");
INSERT INTO sandev_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","बहुदिनेषु लोकैरनाहारेण यापितेषु सर्व्वेषां साक्षत् पौलस्तिष्ठन् अकथयत्, हे महेच्छाः क्रीत्युपद्वीपात् पोतं न मोचयितुम् अहं पूर्व्वं यद् अवदं तद्ग्रहणं युष्माकम् उचितम् आसीत् तथा कृते युष्माकम् एषा विपद् एषोऽपचयश्च नाघटिष्येताम्। ");
INSERT INTO sandev_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","किन्तु साम्प्रतं युष्मान् विनीय ब्रवीम्यहं, यूयं न क्षुभ्यत युष्माकम् एकस्यापि प्राणिनो हानि र्न भविष्यति, केवलस्य पोतस्य हानि र्भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","यतो यस्येश्वरस्य लोकोऽहं यञ्चाहं परिचरामि तदीय एको दूतो ह्यो रात्रौ ममान्तिके तिष्ठन् कथितवान्, ");
INSERT INTO sandev_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","हे पौल मा भैषीः कैसरस्य सम्मुखे त्वयोपस्थातव्यं; तवैतान् सङ्गिनो लोकान् ईश्वरस्तुभ्यं दत्तवान्। ");
INSERT INTO sandev_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","अतएव हे महेच्छा यूयं स्थिरमनसो भवत मह्यं या कथाकथि सावश्यं घटिष्यते ममैतादृशी विश्वास ईश्वरे विद्यते, ");
INSERT INTO sandev_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","किन्तु कस्यचिद् उपद्वीपस्योपरि पतितव्यम् अस्माभिः। ");
INSERT INTO sandev_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","ततः परम् आद्रियासमुद्रे पोतस्तथैव दोलायमानः सन् इतस्ततो गच्छन् चतुर्दशदिवसस्य रात्रे र्द्वितीयप्रहरसमये कस्यचित् स्थलस्य समीपमुपतिष्ठतीति पोतीयलोका अन्वमन्यन्त। ");
INSERT INTO sandev_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","ततस्ते जलं परिमाय तत्र विंशति र्व्यामा जलानीति ज्ञातवन्तः। किञ्चिद्दूरं गत्वा पुनरपि जलं परिमितवन्तः। तत्र पञ्चदश व्यामा जलानि दृष्ट्वा ");
INSERT INTO sandev_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","चेत् पाषाणे लगतीति भयात् पोतस्य पश्चाद्भागतश्चतुरो लङ्गरान् निक्षिप्य दिवाकरम् अपेक्ष्य सर्व्वे स्थितवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","किन्तु पोतीयलोकाः पोताग्रभागे लङ्गरनिक्षेपं छलं कृत्वा जलधौ क्षुद्रनावम् अवरोह्य पलायितुम् अचेष्टन्त। ");
INSERT INTO sandev_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","ततः पौलः सेनापतये सैन्यगणाय च कथितवान्, एते यदि पोतमध्ये न तिष्ठन्ति तर्हि युष्माकं रक्षणं न शक्यं। ");
INSERT INTO sandev_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","तदा सेनागणो रज्जून् छित्वा नावं जले पतितुम् अददात्। ");
INSERT INTO sandev_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","प्रभातसमये पौलः सर्व्वान् जनान् भोजनार्थं प्रार्थ्य व्याहरत्, अद्य चतुर्दशदिनानि यावद् यूयम् अपेक्षमाना अनाहाराः कालम् अयापयत किमपि नाभुंग्धं। ");
INSERT INTO sandev_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","अतो विनयेेऽहं भक्ष्यं भुज्यतां ततो युष्माकं मङ्गलं भविष्यति, युष्माकं कस्यचिज्जनस्य शिरसः केशैकोपि न नंक्ष्यति। ");
INSERT INTO sandev_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","इति व्याहृत्य पौलं पूपं गृहीत्वेश्वरं धन्यं भाषमाणस्तं भंक्त्वा भोक्तुम् आरब्धवान्। ");
INSERT INTO sandev_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","अनन्तरं सर्व्वे च सुस्थिराः सन्तः खाद्यानि पर्प्यगृह्लन्। ");
INSERT INTO sandev_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","अस्माकं पोते षट्सप्तत्यधिकशतद्वयलोका आसन्। ");
INSERT INTO sandev_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","सर्व्वेषु लोकेषु यथेष्टं भुक्तवत्सु पोतस्थन् गोधूमान् जलधौ निक्षिप्य तैः पोतस्य भारो लघूकृतः। ");
INSERT INTO sandev_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","दिने जातेऽपि स को देश इति तदा न पर्य्यचीयत; किन्तु तत्र समतटम् एकं खातं दृष्ट्वा यदि शक्नुमस्तर्हि वयं तस्याभ्यन्तरं पोतं गमयाम इति मतिं कृत्वा ते लङ्गरान् छित्त्वा जलधौ त्यक्तवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","तथा कर्णबन्धनं मोचयित्वा प्रधानं वातवसनम् उत्तोल्य तीरसमीपं गतवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","किन्तु द्वयोः समुद्रयोः सङ्गमस्थाने सैकतोपरि पोते निक्षिप्ते ऽग्रभागे बाधिते पश्चाद्भागे प्रबलतरङ्गोऽलगत् तेन पोतो भग्नः। ");
INSERT INTO sandev_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","तस्माद् बन्दयश्चेद् बाहुभिस्तरन्तः पलायन्ते इत्याशङ्कया सेनागणस्तान् हन्तुम् अमन्त्रयत्; ");
INSERT INTO sandev_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","किन्तु शतसेनापतिः पौलं रक्षितुं प्रयत्नं कृत्वा तान् तच्चेष्टाया निवर्त्य इत्यादिष्टवान्, ये बाहुतरणं जानन्ति तेऽग्रे प्रोल्लम्प्य समुद्रे पतित्वा बाहुभिस्तीर्त्त्वा कूलं यान्तु। ");
INSERT INTO sandev_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","अपरम् अवशिष्टा जनाः काष्ठं पोतीयं द्रव्यं वा येन यत् प्राप्यते तदवलम्ब्य यान्तु; इत्थं सर्व्वे भूमिं प्राप्य प्राणै र्जीविताः। ");
INSERT INTO sandev_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","इत्थं सर्व्वेषु रक्षां प्राप्तेषु तत्रत्योपद्वीपस्य नाम मिलीतेति ते ज्ञातवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","असभ्यलोका यथेष्टम् अनुकम्पां कृत्वा वर्त्तमानवृष्टेः शीताच्च वह्निं प्रज्ज्वाल्यास्माकम् आतिथ्यम् अकुर्व्वन्। ");
INSERT INTO sandev_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","किन्तु पौल इन्धनानि संगृह्य यदा तस्मिन् अग्रौ निरक्षिपत्, तदा वह्नेः प्रतापात् एकः कृष्णसर्पो निर्गत्य तस्य हस्ते द्रष्टवान्। ");
INSERT INTO sandev_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","तेऽसभ्यलोकास्तस्य हस्ते सर्पम् अवलम्बमानं दृष्ट्वा परस्परम् उक्तवन्त एष जनोऽवश्यं नरहा भविष्यति, यतो यद्यपि जलधे रक्षां प्राप्तवान् तथापि प्रतिफलदायक एनं जीवितुं न ददाति। ");
INSERT INTO sandev_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","किन्तु स हस्तं विधुन्वन् तं सर्पम् अग्निमध्ये निक्षिप्य कामपि पीडां नाप्तवान्। ");
INSERT INTO sandev_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","ततो विषज्वालया एतस्य शरीरं स्फीतं भविष्यति यद्वा हठादयं प्राणान् त्यक्ष्यतीति निश्चित्य लोका बहुक्षणानि यावत् तद् द्रष्टुं स्थितवन्तः किन्तु तस्य कस्याश्चिद् विपदोऽघटनात् ते तद्विपरीतं विज्ञाय भाषितवन्त एष कश्चिद् देवो भवेत्। ");
INSERT INTO sandev_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","पुब्लियनामा जन एकस्तस्योपद्वीपस्याधिपतिरासीत् तत्र तस्य भूम्यादि च स्थितं। स जनोऽस्मान् निजगृहं नीत्वा सौजन्यं प्रकाश्य दिनत्रयं यावद् अस्माकं आतिथ्यम् अकरोत्। ");
INSERT INTO sandev_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","तदा तस्य पुब्लियस्य पिता ज्वरातिसारेण पीड्यमानः सन् शय्यायाम् आसीत्; ततः पौलस्तस्य समीपं गत्वा प्रार्थनां कृत्वा तस्य गात्रे हस्तं समर्प्य तं स्वस्थं कृतवान्। ");
INSERT INTO sandev_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","इत्थं भूते तद्वीपनिवासिन इतरेपि रोगिलोका आगत्य निरामया अभवन्। ");
INSERT INTO sandev_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","तस्मात्तेऽस्माकम् अतीव सत्कारं कृतवन्तः, विशेषतः प्रस्थानसमये प्रयोजनीयानि नानद्रव्याणि दत्तवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","इत्थं तत्र त्रिषु मासेषु गतेषु यस्य चिह्नं दियस्कूरी तादृश एकः सिकन्दरीयनगरस्य पोतः शीतकालं यापयन् तस्मिन् उपद्वीपे ऽतिष्ठत् तमेव पोतं वयम् आरुह्य यात्राम् अकुर्म्म। ");
INSERT INTO sandev_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","ततः प्रथमतः सुराकूसनगरम् उपस्थाय तत्र त्रीणि दिनानि स्थितवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","तस्माद् आवृत्य रीगियनगरम् उपस्थिताः दिनैकस्मात् परं दक्षिणवयौ सानुकूल्ये सति परस्मिन् दिवसे पतियलीनगरम् उपातिष्ठाम। ");
INSERT INTO sandev_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","ततोऽस्मासु तत्रत्यं भ्रातृगणं प्राप्तेषु ते स्वैः सार्द्धम् अस्मान् सप्त दिनानि स्थापयितुम् अयतन्त, इत्थं वयं रोमानगरम् प्रत्यगच्छाम। ");
INSERT INTO sandev_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","तस्मात् तत्रत्याः भ्रातरोऽस्माकम् आगमनवार्त्तां श्रुत्वा आप्पियफरं त्रिष्टावर्णीञ्च यावद् अग्रेसराः सन्तोस्मान् साक्षात् कर्त्तुम् आगमन्; तेषां दर्शनात् पौल ईश्वरं धन्यं वदन् आश्वासम् आप्तवान्। ");
INSERT INTO sandev_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","अस्मासु रोमानगरं गतेषु शतसेनापतिः सर्व्वान् बन्दीन् प्रधानसेनापतेः समीपे समार्पयत् किन्तु पौलाय स्वरक्षकपदातिना सह पृथग् वस्तुम् अनुमतिं दत्तवान्। ");
INSERT INTO sandev_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","दिनत्रयात् परं पौलस्तद्देशस्थान् प्रधानयिहूदिन आहूतवान् ततस्तेषु समुपस्थितेषु स कथितवान्, हे भ्रातृगण निजलोकानां पूर्व्वपुरुषाणां वा रीते र्विपरीतं किञ्चन कर्म्माहं नाकरवं तथापि यिरूशालमनिवासिनो लोका मां बन्दिं कृत्वा रोमिलोकानां हस्तेषु समर्पितवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","रोमिलोका विचार्य्य मम प्राणहननार्हं किमपि कारणं न प्राप्य मां मोचयितुम् ऐच्छन्; ");
INSERT INTO sandev_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","किन्तु यिहूदिलोकानाम् आपत्त्या मया कैसरराजस्य समीपे विचारस्य प्रार्थना कर्त्तव्या जाता नोचेत् निजदेशीयलोकान् प्रति मम कोप्यभियोगो नास्ति। ");
INSERT INTO sandev_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","एतत्कारणाद् अहं युष्मान् द्रष्टुं संलपितुञ्चाहूयम् इस्रायेल्वशीयानां प्रत्याशाहेतोहम् एतेन शुङ्खलेन बद्धोऽभवम्। ");
INSERT INTO sandev_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","तदा ते तम् अवादिषुः, यिहूदीयदेशाद् वयं त्वामधि किमपि पत्रं न प्राप्ता ये भ्रातरः समायातास्तेषां कोपि तव कामपि वार्त्तां नावदत् अभद्रमपि नाकथयच्च। ");
INSERT INTO sandev_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","तव मतं किमिति वयं त्वत्तः श्रोतुमिच्छामः। यद् इदं नवीनं मतमुत्थितं तत् सर्व्वत्र सर्व्वेषां निकटे निन्दितं जातम इति वयं जानीमः। ");
INSERT INTO sandev_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","तैस्तदर्थम् एकस्मिन् दिने निरूपिते तस्मिन् दिने बहव एकत्र मिलित्वा पौलस्य वासगृहम् आगच्छन् तस्मात् पौल आ प्रातःकालात् सन्ध्याकालं यावन् मूसाव्यवस्थाग्रन्थाद् भविष्यद्वादिनां ग्रन्थेभ्यश्च यीशोः कथाम् उत्थाप्य ईश्वरस्य राज्ये प्रमाणं दत्वा तेषां प्रवृत्तिं जनयितुं चेष्टितवान्। ");
INSERT INTO sandev_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","केचित्तु तस्य कथां प्रत्यायन् केचित्तु न प्रत्यायन्; ");
INSERT INTO sandev_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","एतत्कारणात् तेषां परस्परम् अनैक्यात् सर्व्वे चलितवन्तः; तथापि पौल एतां कथामेकां कथितवान् पवित्र आत्मा यिशयियस्य भविष्यद्वक्तु र्वदनाद् अस्माकं पितृपुरुषेभ्य एतां कथां भद्रं कथयामास, यथा, ");
INSERT INTO sandev_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","\"उपगत्य जनानेतान् त्वं भाषस्व वचस्त्विदं। कर्णैः श्रोष्यथ यूयं हि किन्तु यूयं न भोत्स्यथ। नेत्रै र्द्रक्ष्यथ यूयञ्च ज्ञातुं यूयं न शक्ष्यथ। ");
INSERT INTO sandev_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","ते मानुषा यथा नेत्रैः परिपश्यन्ति नैव हि। कर्णैः र्यथा न शृण्वन्ति बुध्यन्ते न च मानसैः। व्यावर्त्तयत्सु चित्तानि काले कुत्रापि तेषु वै। मत्तस्ते मनुजाः स्वस्था यथा नैव भवन्ति च। तथा तेषां मनुष्याणां सन्ति स्थूला हि बुद्धयः। बधिरीभूतकर्णाश्च जाताश्च मुद्रिता दृशः॥ ");
INSERT INTO sandev_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","अत ईश्वराद् यत् परित्राणं तस्य वार्त्ता भिन्नदेशीयानां समीपं प्रेषिता तएव तां ग्रहीष्यन्तीति यूयं जानीत। ");
INSERT INTO sandev_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","एतादृश्यां कथायां कथितायां सत्यां यिहूदिनः परस्परं बहुविचारं कुर्व्वन्तो गतवन्तः। ");
INSERT INTO sandev_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","इत्थं पौलः सम्पूर्णं वत्सरद्वयं यावद् भाटकीये वासगृहे वसन् ये लोकास्तस्य सन्निधिम् आगच्छन्ति तान् सर्व्वानेव परिगृह्लन्, ");
INSERT INTO sandev_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","निर्विघ्नम् अतिशयनिःक्षोभम् ईश्वरीयराजत्वस्य कथां प्रचारयन् प्रभौ यीशौ ख्रीष्टे कथाः समुपादिशत्। इति॥");
INSERT INTO sandev_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","ईश्वरो निजपुत्रमधि यं सुसंवादं भविष्यद्वादिभि र्धर्म्मग्रन्थे प्रतिश्रुतवान् तं सुसंवादं प्रचारयितुं पृथक्कृत आहूतः प्रेरितश्च प्रभो र्यीशुख्रीष्टस्य सेवको यः पौलः ");
INSERT INTO sandev_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","स रोमानगरस्थान् ईश्वरप्रियान् आहूतांश्च पवित्रलोकान् प्रति पत्रं लिखति। ");
INSERT INTO sandev_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","अस्माकं स प्रभु र्यीशुः ख्रीष्टः शारीरिकसम्बन्धेन दायूदो वंशोद्भवः ");
INSERT INTO sandev_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","पवित्रस्यात्मनः सम्बन्धेन चेश्वरस्य प्रभाववान् पुत्र इति श्मशानात् तस्योत्थानेन प्रतिपन्नं। ");
INSERT INTO sandev_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","अपरं येषां मध्ये यीशुना ख्रीष्टेन यूयमप्याहूतास्ते ऽन्यदेशीयलोकास्तस्य नाम्नि विश्वस्य निदेशग्राहिणो यथा भवन्ति ");
INSERT INTO sandev_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","तदभिप्रायेण वयं तस्माद् अनुग्रहं प्रेरितत्वपदञ्च प्राप्ताः। ");
INSERT INTO sandev_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","तातेनास्माकम् ईश्वरेण प्रभुणा यीशुख्रीष्टेन च युष्मभ्यम् अनुग्रहः शान्तिश्च प्रदीयेतां। ");
INSERT INTO sandev_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","प्रथमतः सर्व्वस्मिन् जगति युष्माकं विश्वासस्य प्रकाशितत्वाद् अहं युष्माकं सर्व्वेषां निमित्तं यीशुख्रीष्टस्य नाम गृह्लन् ईश्वरस्य धन्यवादं करोमि। ");
INSERT INTO sandev_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","अपरम् ईश्वरस्य प्रसादाद् बहुकालात् परं साम्प्रतं युष्माकं समीपं यातुं कथमपि यत् सुयोगं प्राप्नोमि, एतदर्थं निरन्तरं नामान्युच्चारयन् निजासु सर्व्वप्रार्थनासु सर्व्वदा निवेदयामि, ");
INSERT INTO sandev_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","एतस्मिन् यमहं तत्पुत्रीयसुसंवादप्रचारणेन मनसा परिचरामि स ईश्वरो मम साक्षी विद्यते। ");
INSERT INTO sandev_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","यतो युष्माकं मम च विश्वासेन वयम् उभये यथा शान्तियुक्ता भवाम इति कारणाद् ");
INSERT INTO sandev_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","युष्माकं स्थैर्य्यकरणार्थं युष्मभ्यं किञ्चित्परमार्थदानदानाय युष्मान् साक्षात् कर्त्तुं मदीया वाञ्छा। ");
INSERT INTO sandev_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","हे भ्रातृगण भिन्नदेशीयलोकानां मध्ये यद्वत् तद्वद् युष्माकं मध्येपि यथा फलं भुञ्जे तदभिप्रायेण मुहुर्मुहु र्युष्माकं समीपं गन्तुम् उद्यतोऽहं किन्तु यावद् अद्य तस्मिन् गमने मम विघ्नो जात इति यूयं यद् अज्ञातास्तिष्ठथ तदहम् उचितं न बुध्ये। ");
INSERT INTO sandev_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","अहं सभ्यासभ्यानां विद्वदविद्वताञ्च सर्व्वेषाम् ऋणी विद्ये। ");
INSERT INTO sandev_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","अतएव रोमानिवासिनां युष्माकं समीपेऽपि यथाशक्ति सुसंवादं प्रचारयितुम् अहम् उद्यतोस्मि। ");
INSERT INTO sandev_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","यतः ख्रीष्टस्य सुसंवादो मम लज्जास्पदं नहि स ईश्वरस्य शक्तिस्वरूपः सन् आ यिहूदीयेभ्यो ऽन्यजातीयान् यावत् सर्व्वजातीयानां मध्ये यः कश्चिद् तत्र विश्वसिति तस्यैव त्राणं जनयति। ");
INSERT INTO sandev_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","यतः प्रत्ययस्य समपरिमाणम् ईश्वरदत्तं पुण्यं तत्सुसंवादे प्रकाशते। तदधि धर्म्मपुस्तकेपि लिखितमिदं \"पुण्यवान् जनो विश्वासेन जीविष्यति\"। ");
INSERT INTO sandev_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","अतएव ये मानवाः पापकर्म्मणा सत्यतां रुन्धन्ति तेषां सर्व्वस्य दुराचरणस्याधर्म्मस्य च विरुद्धं स्वर्गाद् ईश्वरस्य कोपः प्रकाशते। ");
INSERT INTO sandev_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","यत ईश्वरमधि यद्यद् ज्ञेयं तद् ईश्वरः स्वयं तान् प्रति प्रकाशितवान् तस्मात् तेषाम् अगोचरं नहि। ");
INSERT INTO sandev_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","फलतस्तस्यानन्तशक्तीश्वरत्वादीन्यदृश्यान्यपि सृष्टिकालम् आरभ्य कर्म्मसु प्रकाशमानानि दृश्यन्ते तस्मात् तेषां दोषप्रक्षालनस्य पन्था नास्ति। ");
INSERT INTO sandev_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","अपरम् ईश्वरं ज्ञात्वापि ते तम् ईश्वरज्ञानेन नाद्रियन्त कृतज्ञा वा न जाताः; तस्मात् तेषां सर्व्वे तर्का विफलीभूताः, अपरञ्च तेषां विवेकशून्यानि मनांसि तिमिरे मग्नानि। ");
INSERT INTO sandev_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","ते स्वान् ज्ञानिनो ज्ञात्वा ज्ञानहीना अभवन् ");
INSERT INTO sandev_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","अनश्वरस्येश्वरस्य गौरवं विहाय नश्वरमनुष्यपशुपक्ष्युरोगामिप्रभृतेराकृतिविशिष्टप्रतिमास्तैराश्रिताः। ");
INSERT INTO sandev_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","इत्थं त ईश्वरस्य सत्यतां विहाय मृषामतम् आश्रितवन्तः सच्चिदानन्दं सृष्टिकर्त्तारं त्यक्त्वा सृष्टवस्तुनः पूजां सेवाञ्च कृतवन्तः; ");
INSERT INTO sandev_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","इति हेतोरीश्वरस्तान् कुक्रियायां समर्प्य निजनिजकुचिन्ताभिलाषाभ्यां स्वं स्वं शरीरं परस्परम् अपमानितं कर्त्तुम् अददात्। ");
INSERT INTO sandev_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","ईश्वरेण तेषु क्वभिलाषे समर्पितेषु तेषां योषितः स्वाभाविकाचरणम् अपहाय विपरीतकृत्ये प्रावर्त्तन्त; ");
INSERT INTO sandev_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","तथा पुरुषा अपि स्वाभाविकयोषित्सङ्गमं विहाय परस्परं कामकृशानुना दग्धाः सन्तः पुमांसः पुंभिः साकं कुकृत्ये समासज्य निजनिजभ्रान्तेः समुचितं फलम् अलभन्त। ");
INSERT INTO sandev_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","ते स्वेषां मनःस्वीश्वराय स्थानं दातुम् अनिच्छुकास्ततो हेतोरीश्वरस्तान् प्रति दुष्टमनस्कत्वम् अविहितक्रियत्वञ्च दत्तवान्। ");
INSERT INTO sandev_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","अतएव ते सर्व्वे ऽन्यायो व्यभिचारो दुष्टत्वं लोभो जिघांसा ईर्ष्या वधो विवादश्चातुरी कुमतिरित्यादिभि र्दुष्कर्म्मभिः परिपूर्णाः सन्तः ");
INSERT INTO sandev_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","कर्णेजपा अपवादिन ईश्वरद्वेषका हिंसका अहङ्कारिण आत्मश्लाघिनः कुकर्म्मोत्पादकाः पित्रोराज्ञालङ्घका ");
INSERT INTO sandev_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","अविचारका नियमलङ्घिनः स्नेहरहिता अतिद्वेषिणो निर्दयाश्च जाताः। ");
INSERT INTO sandev_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","ये जना एतादृशं कर्म्म कुर्व्वन्ति तएव मृतियोग्या ईश्वरस्य विचारमीदृशं ज्ञात्वापि त एतादृशं कर्म्म स्वयं कुर्व्वन्ति केवलमिति नहि किन्तु तादृशकर्म्मकारिषु लोकेष्वपि प्रीयन्ते। ");
INSERT INTO sandev_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","हे परदूषक मनुष्य यः कश्चन त्वं भवसि तवोत्तरदानाय पन्था नास्ति यतो यस्मात् कर्म्मणः परस्त्वया दूष्यते तस्मात् त्वमपि दूष्यसे, यतस्तं दूषयन्नपि त्वं तद्वद् आचरसि। ");
INSERT INTO sandev_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","किन्त्वेतादृगाचारिभ्यो यं दण्डम् ईश्वरो निश्चिनोति स यथार्थ इति वयं जानीमः। ");
INSERT INTO sandev_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","अतएव हे मानुष त्वं यादृगाचारिणो दूषयसि स्वयं यदि तादृगाचरसि तर्हि त्वम् ईश्वरदण्डात् पलायितुं शक्ष्यसीति किं बुध्यसे? ");
INSERT INTO sandev_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","अपरं तव मनसः परिवर्त्तनं कर्त्तुम् इश्वरस्यानुग्रहो भवति तन्न बुद्ध्वा त्वं किं तदीयानुग्रहक्षमाचिरसहिष्णुत्वनिधिं तुच्छीकरोषि? ");
INSERT INTO sandev_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","तथा स्वान्तःकरणस्य कठोरत्वात् खेदराहित्याच्चेश्वरस्य न्याय्यविचारप्रकाशनस्य क्रोधस्य च दिनं यावत् किं स्वार्थं कोपं सञ्चिनोषि? ");
INSERT INTO sandev_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","किन्तु स एकैकमनुजाय तत्कर्म्मानुसारेण प्रतिफलं दास्यति; ");
INSERT INTO sandev_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","वस्तुतस्तु ये जना धैर्य्यं धृत्वा सत्कर्म्म कुर्व्वन्तो महिमा सत्कारोऽमरत्वञ्चैतानि मृगयन्ते तेभ्योऽनन्तायु र्दास्यति। ");
INSERT INTO sandev_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","अपरं ये जनाः सत्यधर्म्मम् अगृहीत्वा विपरीतधर्म्मम् गृह्लन्ति तादृशा विरोधिजनाः कोपं क्रोधञ्च भोक्ष्यन्ते। ");
INSERT INTO sandev_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","आ यिहूदिनोऽन्यदेशिनः पर्य्यन्तं यावन्तः कुकर्म्मकारिणः प्राणिनः सन्ति ते सर्व्वे दुःखं यातनाञ्च गमिष्यन्ति; ");
INSERT INTO sandev_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","किन्तु आ यिहूदिनो भिन्नदेशिपर्य्यन्ता यावन्तः सत्कर्म्मकारिणो लोकाः सन्ति तान् प्रति महिमा सत्कारः शान्तिश्च भविष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","ईश्वरस्य विचारे पक्षपातो नास्ति। ");
INSERT INTO sandev_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","अलब्धव्यवस्थाशास्त्रै र्यैः पापानि कृतानि व्यवस्थाशास्त्रालब्धत्वानुरूपस्तेषां विनाशो भविष्यति; किन्तु लब्धव्यवस्थाशास्त्रा ये पापान्यकुर्व्वन् व्यवस्थानुसारादेव तेषां विचारो भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","व्यवस्थाश्रोतार ईश्वरस्य समीपे निष्पापा भविष्यन्तीति नहि किन्तु व्यवस्थाचारिण एव सपुण्या भविष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","यतो ऽलब्धव्यवस्थाशास्त्रा भिन्नदेशीयलोका यदि स्वभावतो व्यवस्थानुरूपान् आचारान् कुर्व्वन्ति तर्ह्यलब्धशास्त्राः सन्तोऽपि ते स्वेषां व्यवस्थाशास्त्रमिव स्वयमेव भवन्ति। ");
INSERT INTO sandev_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","तेषां मनसि साक्षिस्वरूपे सति तेषां वितर्केषु च कदा तान् दोषिणः कदा वा निर्दोषान् कृतवत्सु ते स्वान्तर्लिखितस्य व्यवस्थाशास्त्रस्य प्रमाणं स्वयमेव ददति। ");
INSERT INTO sandev_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","यस्मिन् दिने मया प्रकाशितस्य सुसंवादस्यानुसाराद् ईश्वरो यीशुख्रीष्टेन मानुषाणाम् अन्तःकरणानां गूढाभिप्रायान् धृत्वा विचारयिष्यति तस्मिन् विचारदिने तत् प्रकाशिष्यते। ");
INSERT INTO sandev_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","पश्य त्वं स्वयं यिहूदीति विख्यातो व्यवस्थोपरि विश्वासं करोषि, ");
INSERT INTO sandev_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ईश्वरमुद्दिश्य स्वं श्लाघसे, तथा व्यवस्थया शिक्षितो भूत्वा तस्याभिमतं जानासि, सर्व्वासां कथानां सारं विविंक्षे, ");
INSERT INTO sandev_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","अपरं ज्ञानस्य सत्यतायाश्चाकरस्वरूपं शास्त्रं मम समीपे विद्यत अतो ऽन्धलोकानां मार्गदर्शयिता ");
INSERT INTO sandev_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","तिमिरस्थितलोकानां मध्ये दीप्तिस्वरूपोऽज्ञानलोकेभ्यो ज्ञानदाता शिशूनां शिक्षयिताहमेवेति मन्यसे। ");
INSERT INTO sandev_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","परान् शिक्षयन् स्वयं स्वं किं न शिक्षयसि? वस्तुतश्चौर्य्यनिषेधव्यवस्थां प्रचारयन् त्वं किं स्वयमेव चोरयसि? ");
INSERT INTO sandev_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","तथा परदारगमनं प्रतिषेधन् स्वयं किं परदारान् गच्छसि? तथा त्वं स्वयं प्रतिमाद्वेषी सन् किं मन्दिरस्य द्रव्याणि हरसि? ");
INSERT INTO sandev_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","यस्त्वं व्यवस्थां श्लाघसे स त्वं किं व्यवस्थाम् अवमत्य नेश्वरं सम्मन्यसे? ");
INSERT INTO sandev_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","शास्त्रे यथा लिखति \"भिन्नदेशिनां समीपे युष्माकं दोषाद् ईश्वरस्य नाम्नो निन्दा भवति।\" ");
INSERT INTO sandev_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","यदि व्यवस्थां पालयसि तर्हि तव त्वक्छेदक्रिया सफला भवति; यति व्यवस्थां लङ्घसे तर्हि तव त्वक्छेदोऽत्वक्छेदो भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","यतो व्यवस्थाशास्त्रादिष्टधर्म्मकर्म्माचारी पुमान् अत्वक्छेदी सन्नपि किं त्वक्छेदिनां मध्ये न गणयिष्यते? ");
INSERT INTO sandev_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","किन्तु लब्धशास्त्रश्छिन्नत्वक् च त्वं यदि व्यवस्थालङ्घनं करोषि तर्हि व्यवस्थापालकाः स्वाभाविकाच्छिन्नत्वचो लोकास्त्वां किं न दूषयिष्यन्ति? ");
INSERT INTO sandev_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","तस्माद् यो बाह्ये यिहूदी स यिहूदी नहि तथाङ्गस्य यस्त्वक्छेदः स त्वक्छेदो नहि; ");
INSERT INTO sandev_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","किन्तु यो जन आन्तरिको यिहूदी स एव यिहूदी अपरञ्च केवललिखितया व्यवस्थया न किन्तु मानसिको यस्त्वक्छेदो यस्य च प्रशंसा मनुष्येभ्यो न भूत्वा ईश्वराद् भवति स एव त्वक्छेदः। ");
INSERT INTO sandev_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","अपरञ्च यिहूदिनः किं श्रेष्ठत्वं? तथा त्वक्छेदस्य वा किं फलं? ");
INSERT INTO sandev_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","सर्व्वथा बहूनि फलानि सन्ति, विशेषत ईश्वरस्य शास्त्रं तेभ्योऽदीयत। ");
INSERT INTO sandev_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","कैश्चिद् अविश्वसने कृते तेषाम् अविश्वसनात् किम् ईश्वरस्य विश्वास्यताया हानिरुत्पत्स्यते? ");
INSERT INTO sandev_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","केनापि प्रकारेण नहि। यद्यपि सर्व्वे मनुष्या मिथ्यावादिनस्तथापीश्वरः सत्यवादी। शास्त्रे यथा लिखितमास्ते, अतस्त्वन्तु स्ववाक्येन निर्द्दोषो हि भविष्यसि। विचारे चैव निष्पापो भविष्यसि न संशयः। ");
INSERT INTO sandev_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","अस्माकम् अन्यायेन यदीश्वरस्य न्यायः प्रकाशते तर्हि किं वदिष्यामः? अहं मानुषाणां कथामिव कथां कथयामि, ईश्वरः समुचितं दण्डं दत्त्वा किम् अन्यायी भविष्यति? ");
INSERT INTO sandev_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","इत्थं न भवतु, तथा सतीश्वरः कथं जगतो विचारयिता भविष्यति? ");
INSERT INTO sandev_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","मम मिथ्यावाक्यवदनाद् यदीश्वरस्य सत्यत्वेन तस्य महिमा वर्द्धते तर्हि कस्मादहं विचारेऽपराधित्वेन गण्यो भवामि? ");
INSERT INTO sandev_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","मङ्गलार्थं पापमपि करणीयमिति वाक्यं त्वया कुतो नोच्यते? किन्तु यैरुच्यते ते नितान्तं दण्डस्य पात्राणि भवन्ति; तथापि तद्वाक्यम् अस्माभिरप्युच्यत इत्यस्माकं ग्लानिं कुर्व्वन्तः कियन्तो लोका वदन्ति। ");
INSERT INTO sandev_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","अन्यलोकेभ्यो वयं किं श्रेष्ठाः? कदाचन नहि यतो यिहूदिनो ऽन्यदेशिनश्च सर्व्वएव पापस्यायत्ता इत्यस्य प्रमाणं वयं पूर्व्वम् अददाम। ");
INSERT INTO sandev_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","लिपि र्यथास्ते, नैकोपि धार्म्मिको जनः। ");
INSERT INTO sandev_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","तथा ज्ञानीश्वरज्ञानी मानवः कोपि नास्ति हि। ");
INSERT INTO sandev_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","विमार्गगामिनः सर्व्वे सर्व्वे दुष्कर्म्मकारिणः। एको जनोपि नो तेषां साधुकर्म्म करोति च। ");
INSERT INTO sandev_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","तथा तेषान्तु वै कण्ठा अनावृतश्मशानवत्। स्तुतिवादं प्रकुर्व्वन्ति जिह्वाभिस्ते तु केवलं। तेषामोष्ठस्य निम्ने तु विषं तिष्ठति सर्प्पवत्। ");
INSERT INTO sandev_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","मुखं तेषां हि शापेन कपटेन च पूर्य्यते। ");
INSERT INTO sandev_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","रक्तपाताय तेषां तु पदानि क्षिप्रगानि च। ");
INSERT INTO sandev_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","पथि तेषां मनुष्याणां नाशः क्लेशश्च केवलः। ");
INSERT INTO sandev_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","ते जना नहि जानन्ति पन्थानं सुखदायिनं। ");
INSERT INTO sandev_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","परमेशाद् भयं यत्तत् तच्चक्षुषोरगोचरं। ");
INSERT INTO sandev_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","व्यवस्थायां यद्यल्लिखति तद् व्यवस्थाधीनान् लोकान् उद्दिश्य लिखतीति वयं जानीमः। ततो मनुष्यमात्रो निरुत्तरः सन् ईश्वरस्य साक्षाद् अपराधी भवति। ");
INSERT INTO sandev_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","अतएव व्यवस्थानुरूपैः कर्म्मभिः कश्चिदपि प्राणीश्वरस्य साक्षात् सपुण्यीकृतो भवितुं न शक्ष्यति यतो व्यवस्थया पापज्ञानमात्रं जायते। ");
INSERT INTO sandev_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","किन्तु व्यवस्थायाः पृथग् ईश्वरेण देयं यत् पुण्यं तद् व्यवस्थाया भविष्यद्वादिगणस्य च वचनैः प्रमाणीकृतं सद् इदानीं प्रकाशते। ");
INSERT INTO sandev_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","यीशुख्रीष्टे विश्वासकरणाद् ईश्वरेण दत्तं तत् पुण्यं सकलेषु प्रकाशितं सत् सर्व्वान् विश्वासिनः प्रति वर्त्तते। ");
INSERT INTO sandev_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","तेषां कोपि प्रभेदो नास्ति, यतः सर्व्वएव पापिन ईश्वरीयतेजोहीनाश्च जाताः। ");
INSERT INTO sandev_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","त ईश्वरस्यानुग्रहाद् मूल्यं विना ख्रीष्टकृतेन परित्राणेन सपुण्यीकृता भवन्ति। ");
INSERT INTO sandev_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","यस्मात् स्वशोणितेन विश्वासात् पापनाशको बली भवितुं स एव पूर्व्वम् ईश्वरेण निश्चितः, इत्थम् ईश्वरीयसहिष्णुत्वात् पुराकृतपापानां मार्ज्जनकरणे स्वीययाथार्थ्यं तेन प्रकाश्यते, ");
INSERT INTO sandev_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","वर्त्तमानकालीयमपि स्वयाथार्थ्यं तेन प्रकाश्यते, अपरं यीशौ विश्वासिनं सपुण्यीकुर्व्वन्नपि स याथार्थिकस्तिष्ठति। ");
INSERT INTO sandev_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","तर्हि कुत्रात्मश्लाघा? सा दूरीकृता; कया व्यवस्थया? किं क्रियारूपव्यवस्थया? इत्थं नहि किन्तु तत् केवलविश्वासरूपया व्यवस्थयैव भवति। ");
INSERT INTO sandev_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","अतएव व्यवस्थानुरूपाः क्रिया विना केवलेन विश्वासेन मानवः सपुण्यीकृतो भवितुं शक्नोतीत्यस्य राद्धान्तं दर्शयामः। ");
INSERT INTO sandev_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","स किं केवलयिहूदिनाम् ईश्वरो भवति? भिन्नदेशिनाम् ईश्वरो न भवति? भिन्नदेशिनामपि भवति; ");
INSERT INTO sandev_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","यस्माद् एक ईश्वरो विश्वासात् त्वक्छेदिनो विश्वासेनात्वक्छेदिनश्च सपुण्यीकरिष्यति। ");
INSERT INTO sandev_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","तर्हि विश्वासेन वयं किं व्यवस्थां लुम्पाम? इत्थं न भवतु वयं व्यवस्थां संस्थापयाम एव। ");
INSERT INTO sandev_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","अस्माकं पूर्व्वपुरुष इब्राहीम् कायिकक्रियया किं लब्धवान् एतदधि किं वदिष्यामः? ");
INSERT INTO sandev_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","स यदि निजक्रियाभ्यः सपुण्यो भवेत् तर्हि तस्यात्मश्लाघां कर्त्तुं पन्था भवेदिति सत्यं, किन्त्वीश्वरस्य समीपे नहि। ");
INSERT INTO sandev_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","शास्त्रे किं लिखति? इब्राहीम् ईश्वरे विश्वसनात् स विश्वासस्तस्मै पुण्यार्थं गणितो बभूव। ");
INSERT INTO sandev_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","कर्म्मकारिणो यद् वेतनं तद् अनुग्रहस्य फलं नहि किन्तु तेनोपार्जितं मन्तव्यम्। ");
INSERT INTO sandev_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","किन्तु यः पापिनं सपुण्यीकरोति तस्मिन् विश्वासिनः कर्म्महीनस्य जनस्य यो विश्वासः स पुण्यार्थं गण्यो भवति। ");
INSERT INTO sandev_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","अपरं यं क्रियाहीनम् ईश्वरः सपुण्यीकरोति तस्य धन्यवादं दायूद् वर्णयामास, यथा, ");
INSERT INTO sandev_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","स धन्योऽघानि मृष्टानि यस्यागांस्यावृतानि च। ");
INSERT INTO sandev_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","स च धन्यः परेशेन पापं यस्य न गण्यते। ");
INSERT INTO sandev_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","एष धन्यवादस्त्वक्छेदिनम् अत्वक्छेदिनं वा कं प्रति भवति? इब्राहीमो विश्वासः पुण्यार्थं गणित इति वयं वदामः। ");
INSERT INTO sandev_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","स विश्वासस्तस्य त्वक्छेदित्वावस्थायां किम् अत्वक्छेदित्वावस्थायां कस्मिन् समये पुण्यमिव गणितः? त्वक्छेदित्वावस्थायां नहि किन्त्वत्वक्छेदित्वावस्थायां। ");
INSERT INTO sandev_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","अपरञ्च स यत् सर्व्वेषाम् अत्वक्छेदिनां विश्वासिनाम् आदिपुरुषो भवेत्, ते च पुण्यवत्त्वेन गण्येरन्; ");
INSERT INTO sandev_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","ये च लोकाः केवलं छिन्नत्वचो न सन्तो ऽस्मत्पूर्व्वपुरुष इब्राहीम् अछिन्नत्वक् सन् येन विश्वासमार्गेण गतवान् तेनैव तस्य पादचिह्नेन गच्छन्ति तेषां त्वक्छेदिनामप्यादिपुरुषो भवेत् तदर्थम् अत्वक्छेदिनो मानवस्य विश्वासात् पुण्यम् उत्पद्यत इति प्रमाणस्वरूपं त्वक्छेदचिह्नं स प्राप्नोत्। ");
INSERT INTO sandev_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","इब्राहीम् जगतोऽधिकारी भविष्यति यैषा प्रतिज्ञा तं तस्य वंशञ्च प्रति पूर्व्वम् अक्रियत सा व्यवस्थामूलिका नहि किन्तु विश्वासजन्यपुण्यमूलिका। ");
INSERT INTO sandev_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","यतो व्यवस्थावलम्बिनो यद्यधिकारिणो भवन्ति तर्हि विश्वासो विफलो जायते सा प्रतिज्ञापि लुप्तैव। ");
INSERT INTO sandev_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","अधिकन्तु व्यवस्था कोपं जनयति यतो ऽविद्यमानायां व्यवस्थायाम् आज्ञालङ्घनं न सम्भवति। ");
INSERT INTO sandev_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","अतएव सा प्रतिज्ञा यद् अनुग्रहस्य फलं भवेत् तदर्थं विश्वासमूलिका यतस्तथात्वे तद्वंशसमुदायं प्रति अर्थतो ये व्यवस्थया तद्वंशसम्भवाः केवलं तान् प्रति नहि किन्तु य इब्राहीमीयविश्वासेन तत्सम्भवास्तानपि प्रति सा प्रतिज्ञा स्थास्नुर्भवति। ");
INSERT INTO sandev_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","यो निर्जीवान् सजीवान् अविद्यमानानि वस्तूनि च विद्यमानानि करोति इब्राहीमो विश्वासभूमेस्तस्येश्वरस्य साक्षात् सोऽस्माकं सर्व्वेषाम् आदिपुरुष आस्ते, यथा लिखितं विद्यते, अहं त्वां बहुजातीनाम् आदिपुरुषं कृत्वा नियुक्तवान्। ");
INSERT INTO sandev_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","त्वदीयस्तादृशो वंशो जनिष्यते यदिदं वाक्यं प्रतिश्रुतं तदनुसाराद् इब्राहीम् बहुदेशीयलोकानाम् आदिपुरुषो यद् भवति तदर्थं सोऽनपेक्षितव्यमप्यपेक्षमाणो विश्वासं कृतवान्। ");
INSERT INTO sandev_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","अपरञ्च क्षीणविश्वासो न भूत्वा शतवत्सरवयस्कत्वात् स्वशरीरस्य जरां सारानाम्नः स्वभार्य्याया रजोनिवृत्तिञ्च तृणाय न मेने। ");
INSERT INTO sandev_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","अपरम् अविश्वासाद् ईश्वरस्य प्रतिज्ञावचने कमपि संशयं न चकार; ");
INSERT INTO sandev_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","किन्त्वीश्वरेण यत् प्रतिश्रुतं तत् साधयितुं शक्यत इति निश्चितं विज्ञाय दृढविश्वासः सन् ईश्वरस्य महिमानं प्रकाशयाञ्चकार। ");
INSERT INTO sandev_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","इति हेतोस्तस्य स विश्वासस्तदीयपुण्यमिव गणयाञ्चक्रे। ");
INSERT INTO sandev_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","पुण्यमिवागण्यत तत् केवलस्य तस्य निमित्तं लिखितं नहि, अस्माकं निमित्तमपि, ");
INSERT INTO sandev_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","यतोऽस्माकं पापनाशार्थं समर्पितोऽस्माकं पुण्यप्राप्त्यर्थञ्चोत्थापितोऽभवत् योऽस्माकं प्रभु र्यीशुस्तस्योत्थापयितरीश्वरे ");
INSERT INTO sandev_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","यदि वयं विश्वसामस्तर्ह्यस्माकमपि सएव विश्वासः पुण्यमिव गणयिष्यते। ");
INSERT INTO sandev_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","विश्वासेन सपुण्यीकृता वयम् ईश्वरेण सार्द्धं प्रभुणास्माकं यीशुख्रीष्टेन मेलनं प्राप्ताः। ");
INSERT INTO sandev_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","अपरं वयं यस्मिन् अनुग्रहाश्रये तिष्ठामस्तन्मध्यं विश्वासमार्गेण तेनैवानीता वयम् ईश्वरीयविभवप्राप्तिप्रत्याशया समानन्दामः। ");
INSERT INTO sandev_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","तत् केवलं नहि किन्तु क्लेशभोगेऽप्यानन्दामो यतः क्लेशााद् धैर्य्यं जायत इति वयं जानीमः, ");
INSERT INTO sandev_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","धैर्य्याच्च परीक्षितत्वं जायते, परीक्षितत्वात् प्रत्याशा जायते, ");
INSERT INTO sandev_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","प्रत्याशातो व्रीडितत्वं न जायते, यस्माद् अस्मभ्यं दत्तेन पवित्रेणात्मनास्माकम् अन्तःकरणानीश्वरस्य प्रेमवारिणा सिक्तानि। ");
INSERT INTO sandev_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","अस्मासु निरुपायेषु सत्सु ख्रीष्ट उपयुक्ते समये पापिनां निमित्तं स्वीयान् प्रणान् अत्यजत्। ");
INSERT INTO sandev_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","हितकारिणो जनस्य कृते कोपि प्रणान् त्यक्तुं साहसं कर्त्तुं शक्नोति, किन्तु धार्म्मिकस्य कृते प्रायेण कोपि प्राणान् न त्यजति। ");
INSERT INTO sandev_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","किन्त्वस्मासु पापिषु सत्स्वपि निमित्तमस्माकं ख्रीष्टः स्वप्राणान् त्यक्तवान्, तत ईश्वरोस्मान् प्रति निजं परमप्रेमाणं दर्शितवान्। ");
INSERT INTO sandev_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","अतएव तस्य रक्तपातेन सपुण्यीकृता वयं नितान्तं तेन कोपाद् उद्धारिष्यामहे। ");
INSERT INTO sandev_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","फलतो वयं यदा रिपव आस्म तदेश्वरस्य पुत्रस्य मरणेन तेन सार्द्धं यद्यस्माकं मेलनं जातं तर्हि मेलनप्राप्ताः सन्तोऽवश्यं तस्य जीवनेन रक्षां लप्स्यामहे। ");
INSERT INTO sandev_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","तत् केवलं नहि किन्तु येन मेलनम् अलभामहि तेनास्माकं प्रभुणा यीशुख्रीष्टेन साम्प्रतम् ईश्वरे समानन्दामश्च। ");
INSERT INTO sandev_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","तथा सति, एकेन मानुषेण पापं पापेन च मरणं जगतीं प्राविशत् अपरं सर्व्वेषां पापित्वात् सर्व्वे मानुषा मृते र्निघ्ना अभवत्। ");
INSERT INTO sandev_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","यतो व्यवस्थादानसमयं यावत् जगति पापम् आसीत् किन्तु यत्र व्यवस्था न विद्यते तत्र पापस्यापि गणना न विद्यते। ");
INSERT INTO sandev_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","तथाप्यादमा यादृशं पापं कृतं तादृशं पापं यै र्नाकारि आदमम् आरभ्य मूसां यावत् तेषामप्युपरि मृत्यू राजत्वम् अकरोत् स आदम् भाव्यादमो निदर्शनमेवास्ते। ");
INSERT INTO sandev_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","किन्तु पापकर्म्मणो यादृशो भावस्तादृग् दानकर्म्मणो भावो न भवति यत एकस्य जनस्यापराधेन यदि बहूनां मरणम् अघटत तथापीश्वरानुग्रहस्तदनुग्रहमूलकं दानञ्चैकेन जनेनार्थाद् यीशुना ख्रीष्टेन बहुषु बाहुल्यातिबाहुल्येन फलति। ");
INSERT INTO sandev_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","अपरम् एकस्य जनस्य पापकर्म्म यादृक् फलयुक्तं दानकर्म्म तादृक् न भवति यतो विचारकर्म्मैकं पापम् आरभ्य दण्डजनकं बभूव, किन्तु दानकर्म्म बहुपापान्यारभ्य पुण्यजनकं बभूव। ");
INSERT INTO sandev_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","यत एकस्य जनस्य पापकर्म्मतस्तेनैकेन यदि मरणस्य राजत्वं जातं तर्हि ये जना अनुग्रहस्य बाहुल्यं पुण्यदानञ्च प्राप्नुवन्ति त एकेन जनेन, अर्थात् यीशुख्रीष्टेन, जीवने राजत्वम् अवश्यं करिष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","एकोऽपराधो यद्वत् सर्व्वमानवानां दण्डगामी मार्गो ऽभवत् तद्वद् एकं पुण्यदानं सर्व्वमानवानां जीवनयुक्तपुण्यगामी मार्ग एव। ");
INSERT INTO sandev_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","अपरम् एकस्य जनस्याज्ञालङ्घनाद् यथा बहवो ऽपराधिनो जातास्तद्वद् एकस्याज्ञाचरणाद् बहवः सपुण्यीकृता भवन्ति। ");
INSERT INTO sandev_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","अधिकन्तु व्यवस्थागमनाद् अपराधस्य बाहुल्यं जातं किन्तु यत्र पापस्य बाहुल्यं तत्रैव तस्माद् अनुग्रहस्य बाहुल्यम् अभवत्। ");
INSERT INTO sandev_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","तेन मृत्युना यद्वत् पापस्य राजत्वम् अभवत् तद्वद् अस्माकं प्रभुयीशुख्रीष्टद्वारानन्तजीवनदायिपुण्येनानुग्रहस्य राजत्वं भवति। ");
INSERT INTO sandev_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","प्रभूतरूपेण यद् अनुग्रहः प्रकाशते तदर्थं पापे तिष्ठाम इति वाक्यं किं वयं वदिष्यामः? तन्न भवतु। ");
INSERT INTO sandev_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","पापं प्रति मृता वयं पुनस्तस्मिन् कथम् जीविष्यामः? ");
INSERT INTO sandev_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","वयं यावन्तो लोका यीशुख्रीष्टे मज्जिता अभवाम तावन्त एव तस्य मरणे मज्जिता इति किं यूयं न जानीथ? ");
INSERT INTO sandev_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","ततो यथा पितुः पराक्रमेण श्मशानात् ख्रीष्ट उत्थापितस्तथा वयमपि यत् नूतनजीविन इवाचरामस्तदर्थं मज्जनेन तेन सार्द्धं मृत्युरूपे श्मशाने संस्थापिताः। ");
INSERT INTO sandev_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","अपरं वयं यदि तेन संयुक्ताः सन्तः स इव मरणभागिनो जातास्तर्हि स इवोत्थानभागिनोऽपि भविष्यामः। ");
INSERT INTO sandev_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","वयं यत् पापस्य दासाः पुन र्न भवामस्तदर्थम् अस्माकं पापरूपशरीरस्य विनाशार्थम् अस्माकं पुरातनपुरुषस्तेन साकं क्रुशेऽहन्यतेति वयं जानीमः। ");
INSERT INTO sandev_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","यो हतः स पापात् मुक्त एव। ");
INSERT INTO sandev_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","अतएव यदि वयं ख्रीष्टेन सार्द्धम् अहन्यामहि तर्हि पुनरपि तेन सहिता जीविष्याम इत्यत्रास्माकं विश्वासो विद्यते। ");
INSERT INTO sandev_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","यतः श्मशानाद् उत्थापितः ख्रीष्टो पुन र्न म्रियत इति वयं जानीमः। तस्मिन् कोप्यधिकारो मृत्यो र्नास्ति। ");
INSERT INTO sandev_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","अपरञ्च स यद् अम्रियत तेनैकदा पापम् उद्दिश्याम्रियत, यच्च जीवति तेनेश्वरम् उद्दिश्य जीवति; ");
INSERT INTO sandev_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","तद्वद् यूयमपि स्वान् पापम् उद्दिश्य मृतान् अस्माकं प्रभुणा यीशुख्रीष्टेनेश्वरम् उद्दिश्य जीवन्तो जानीत। ");
INSERT INTO sandev_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","अपरञ्च कुत्सिताभिलाषाान् पूरयितुं युष्माकं मर्त्यदेहेषु पापम् आधिपत्यं न करोतु। ");
INSERT INTO sandev_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","अपरं स्वं स्वम् अङ्गम् अधर्म्मस्यास्त्रं कृत्वा पापसेवायां न समर्पयत, किन्तु श्मशानाद् उत्थितानिव स्वान् ईश्वरे समर्पयत स्वान्यङ्गानि च धर्म्मास्त्रस्वरूपाणीश्वरम् उद्दिश्य समर्पयत। ");
INSERT INTO sandev_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","युष्माकम् उपरि पापस्याधिपत्यं पुन र्न भविष्यति, यस्माद् यूयं व्यवस्थाया अनायत्ता अनुग्रहस्य चायत्ता अभवत। ");
INSERT INTO sandev_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","किन्तु वयं व्यवस्थाया अनायत्ता अनुग्रहस्य चायत्ता अभवाम, इति कारणात् किं पापं करिष्यामः? तन्न भवतु। ");
INSERT INTO sandev_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","यतो मृतिजनकं पापं पुण्यजनकं निदेशाचरणञ्चैतयोर्द्वयो र्यस्मिन् आज्ञापालनार्थं भृत्यानिव स्वान् समर्पयथ, तस्यैव भृत्या भवथ, एतत् किं यूयं न जानीथ? ");
INSERT INTO sandev_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","अपरञ्च पूर्व्वं यूयं पापस्य भृत्या आस्तेति सत्यं किन्तु यस्यां शिक्षारूपायां मूषायां निक्षिप्ता अभवत तस्या आकृतिं मनोभि र्लब्धवन्त इति कारणाद् ईश्वरस्य धन्यवादो भवतु। ");
INSERT INTO sandev_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","इत्थं यूयं पापसेवातो मुक्ताः सन्तो धर्म्मस्य भृत्या जाताः। ");
INSERT INTO sandev_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","युष्माकं शारीरिक्या दुर्ब्बलताया हेतो र्मानववद् अहम् एतद् ब्रवीमि; पुनः पुनरधर्म्मकरणार्थं यद्वत् पूर्व्वं पापामेध्ययो र्भृत्यत्वे निजाङ्गानि समार्पयत तद्वद् इदानीं साधुकर्म्मकरणार्थं धर्म्मस्य भृत्यत्वे निजाङ्गानि समर्पयत। ");
INSERT INTO sandev_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","यदा यूयं पापस्य भृत्या आस्त तदा धर्म्मस्य नायत्ता आस्त। ");
INSERT INTO sandev_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","तर्हि यानि कर्म्माणि यूयम् इदानीं लज्जाजनकानि बुध्यध्वे पूर्व्वं तै र्युष्माकं को लाभ आसीत्? तेषां कर्म्मणां फलं मरणमेव। ");
INSERT INTO sandev_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","किन्तु साम्प्रतं यूयं पापसेवातो मुक्ताः सन्त ईश्वरस्य भृत्याऽभवत तस्माद् युष्माकं पवित्रत्वरूपं लभ्यम् अनन्तजीवनरूपञ्च फलम् आस्ते। ");
INSERT INTO sandev_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","यतः पापस्य वेतनं मरणं किन्त्वस्माकं प्रभुणा यीशुख्रीष्टेनानन्तजीवनम् ईश्वरदत्तं पारितोषिकम् आस्ते। ");
INSERT INTO sandev_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","हे भ्रातृगण व्यवस्थाविदः प्रति ममेदं निवेदनं। विधिः केवलं यावज्जीवं मानवोपर्य्यधिपतित्वं करोतीति यूयं किं न जानीथ? ");
INSERT INTO sandev_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","यावत्कालं पति र्जीवति तावत्कालम् ऊढा भार्य्या व्यवस्थया तस्मिन् बद्धा तिष्ठति किन्तु यदि पति र्म्रियते तर्हि सा नारी पत्यु र्व्यवस्थातो मुच्यते। ");
INSERT INTO sandev_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","एतत्कारणात् पत्युर्जीवनकाले नारी यद्यन्यं पुरुषं विवहति तर्हि सा व्यभिचारिणी भवति किन्तु यदि स पति र्म्रियते तर्हि सा तस्या व्यवस्थाया मुक्ता सती पुरुषान्तरेण व्यूढापि व्यभिचारिणी न भवति। ");
INSERT INTO sandev_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","हे मम भ्रातृगण, ईश्वरनिमित्तं यदस्माकं फलं जायते तदर्थं श्मशानाद् उत्थापितेन पुरुषेण सह युष्माकं विवाहो यद् भवेत् तदर्थं ख्रीष्टस्य शरीरेण यूयं व्यवस्थां प्रति मृतवन्तः। ");
INSERT INTO sandev_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","यतोऽस्माकं शारीरिकाचरणसमये मरणनिमित्तं फलम् उत्पादयितुं व्यवस्थया दूषितः पापाभिलाषोऽस्माकम् अङ्गेषु जीवन् आसीत्। ");
INSERT INTO sandev_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","किन्तु तदा यस्या व्यवस्थाया वशे आस्महि साम्प्रतं तां प्रति मृतत्वाद् वयं तस्या अधीनत्वात् मुक्ता इति हेतोरीश्वरोऽस्माभिः पुरातनलिखितानुसारात् न सेवितव्यः किन्तु नवीनस्वभावेनैव सेवितव्यः ");
INSERT INTO sandev_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","तर्हि वयं किं ब्रूमः? व्यवस्था किं पापजनिका भवति? नेत्थं भवतु। व्यवस्थाम् अविद्यमानायां पापं किम् इत्यहं नावेदं; किञ्च लोभं मा कार्षीरिति चेद् व्यवस्थाग्रन्थे लिखितं नाभविष्यत् तर्हि लोभः किम्भूतस्तदहं नाज्ञास्यं। ");
INSERT INTO sandev_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","किन्तु व्यवस्थया पापं छिद्रं प्राप्यास्माकम् अन्तः सर्व्वविधं कुत्सिताभिलाषम् अजनयत्; यतो व्यवस्थायाम् अविद्यमानायां पापं मृतं। ");
INSERT INTO sandev_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","अपरं पूर्व्वं व्यवस्थायाम् अविद्यमानायाम् अहम् अजीवं ततः परम् आज्ञायाम् उपस्थितायाम् पापम् अजीवत् तदाहम् अम्रिये। ");
INSERT INTO sandev_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","इत्थं सति जीवननिमित्ता याज्ञा सा मम मृत्युजनिकाभवत्। ");
INSERT INTO sandev_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","यतः पापं छिद्रं प्राप्य व्यवस्थितादेशेन मां वञ्चयित्वा तेन माम् अहन्। ");
INSERT INTO sandev_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","अतएव व्यवस्था पवित्रा, आदेशश्च पवित्रो न्याय्यो हितकारी च भवति। ");
INSERT INTO sandev_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","तर्हि यत् स्वयं हितकृत् तत् किं मम मृत्युजनकम् अभवत्? नेत्थं भवतु; किन्तु पापं यत् पातकमिव प्रकाशते तथा निदेशेन पापं यदतीव पातकमिव प्रकाशते तदर्थं हितोपायेन मम मरणम् अजनयत्। ");
INSERT INTO sandev_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","व्यवस्थात्मबोधिकेति वयं जानीमः किन्त्वहं शारीरताचारी पापस्य क्रीतकिङ्करो विद्ये। ");
INSERT INTO sandev_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","यतो यत् कर्म्म करोमि तत् मम मनोऽभिमतं नहि; अपरं यन् मम मनोऽभिमतं तन्न करोमि किन्तु यद् ऋतीये तत् करोमि। ");
INSERT INTO sandev_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","तथात्वे यन् ममानभिमतं तद् यदि करोमि तर्हि व्यवस्था सूत्तमेति स्वीकरोमि। ");
INSERT INTO sandev_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","अतएव सम्प्रति तत् कर्म्म मया क्रियत इति नहि किन्तु मम शरीरस्थेन पापेनैव क्रियते। ");
INSERT INTO sandev_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","यतो मयि, अर्थतो मम शरीरे, किमप्युत्तमं न वसति, एतद् अहं जानामि; ममेच्छुकतायां तिष्ठन्त्यामप्यहम् उत्तमकर्म्मसाधने समर्थो न भवामि। ");
INSERT INTO sandev_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","यतो यामुत्तमां क्रियां कर्त्तुमहं वाञ्छामि तां न करोमि किन्तु यत् कुत्सितं कर्म्म कर्त्तुम् अनिच्छुकोऽस्मि तदेव करोमि। ");
INSERT INTO sandev_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","अतएव यद्यत् कर्म्म कर्त्तुं ममेच्छा न भवति तद् यदि करोमि तर्हि तत् मया न क्रियते, ममान्तर्वर्त्तिना पापेनैव क्रियते। ");
INSERT INTO sandev_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","भद्रं कर्त्तुम् इच्छुकं मां यो ऽभद्रं कर्त्तुं प्रवर्त्तयति तादृशं स्वभावमेकं मयि पश्यामि। ");
INSERT INTO sandev_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","अहम् आन्तरिकपुरुषेणेश्वरव्यवस्थायां सन्तुष्ट आसे; ");
INSERT INTO sandev_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","किन्तु तद्विपरीतं युध्यन्तं तदन्यमेकं स्वभावं मदीयाङ्गस्थितं प्रपश्यामि, स मदीयाङ्गस्थितपापस्वभावस्यायत्तं मां कर्त्तुं चेष्टते। ");
INSERT INTO sandev_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","हा हा योऽहं दुर्भाग्यो मनुजस्तं माम् एतस्मान् मृताच्छरीरात् को निस्तारयिष्यति? ");
INSERT INTO sandev_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","अस्माकं प्रभुणा यीशुख्रीष्टेन निस्तारयितारम् ईश्वरं धन्यं वदामि। अतएव शरीरेण पापव्यवस्थाया मनसा तु ईश्वरव्यवस्थायाः सेवनं करोमि। ");
INSERT INTO sandev_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","ये जनाः ख्रीष्टं यीशुम् आश्रित्य शारीरिकं नाचरन्त आत्मिकमाचरन्ति तेऽधुना दण्डार्हा न भवन्ति। ");
INSERT INTO sandev_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","जीवनदायकस्यात्मनो व्यवस्था ख्रीष्टयीशुना पापमरणयो र्व्यवस्थातो माममोचयत्। ");
INSERT INTO sandev_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","यस्माच्छारीरस्य दुर्ब्बलत्वाद् व्यवस्थया यत् कर्म्मासाध्यम् ईश्वरो निजपुत्रं पापिशरीररूपं पापनाशकबलिरूपञ्च प्रेष्य तस्य शरीरे पापस्य दण्डं कुर्व्वन् तत्कर्म्म साधितवान्। ");
INSERT INTO sandev_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","ततः शारीरिकं नाचरित्वास्माभिरात्मिकम् आचरद्भिर्व्यवस्थाग्रन्थे निर्द्दिष्टानि पुण्यकर्म्माणि सर्व्वाणि साध्यन्ते। ");
INSERT INTO sandev_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","ये शारीरिकाचारिणस्ते शारीरिकान् विषयान् भावयन्ति ये चात्मिकाचारिणस्ते आत्मनो विषयान् भावयन्ति। ");
INSERT INTO sandev_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","शारीरिकभावस्य फलं मृत्युः किञ्चात्मिकभावस्य फले जीवनं शान्तिश्च। ");
INSERT INTO sandev_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","यतः शारीरिकभाव ईश्वरस्य विरुद्धः शत्रुताभाव एव स ईश्वरस्य व्यवस्थाया अधीनो न भवति भवितुञ्च न शक्नोति। ");
INSERT INTO sandev_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","एतस्मात् शारीरिकाचारिषु तोष्टुम् ईश्वरेण न शक्यं। ");
INSERT INTO sandev_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","किन्त्वीश्वरस्यात्मा यदि युष्माकं मध्ये वसति तर्हि यूयं शारीरिकाचारिणो न सन्त आत्मिकाचारिणो भवथः। यस्मिन् तु ख्रीष्टस्यात्मा न विद्यते स तत्सम्भवो नहि। ");
INSERT INTO sandev_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","यदि ख्रीष्टो युष्मान् अधितिष्ठति तर्हि पापम् उद्दिश्य शरीरं मृतं किन्तु पुण्यमुद्दिश्यात्मा जीवति। ");
INSERT INTO sandev_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","मृतगणाद् यीशु र्येनोत्थापितस्तस्यात्मा यदि युष्मन्मध्ये वसति तर्हि मृतगणात् ख्रीष्टस्य स उत्थापयिता युष्मन्मध्यवासिना स्वकीयात्मना युष्माकं मृतदेहानपि पुन र्जीवयिष्यति। ");
INSERT INTO sandev_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","हे भ्रातृगण शरीरस्य वयमधमर्णा न भवामोऽतः शारीरिकाचारोऽस्माभि र्न कर्त्तव्यः। ");
INSERT INTO sandev_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","यदि यूयं शरीरिकाचारिणो भवेत तर्हि युष्माभि र्मर्त्तव्यमेव किन्त्वात्मना यदि शरीरकर्म्माणि घातयेत तर्हि जीविष्यथ। ");
INSERT INTO sandev_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","यतो यावन्तो लोका ईश्वरस्यात्मनाकृष्यन्ते ते सर्व्व ईश्वरस्य सन्ताना भवन्ति। ");
INSERT INTO sandev_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","यूयं पुनरपि भयजनकं दास्यभावं न प्राप्ताः किन्तु येन भावेनेश्वरं पितः पितरिति प्रोच्य सम्बोधयथ तादृशं दत्तकपुत्रत्वभावम् प्राप्नुत। ");
INSERT INTO sandev_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","अपरञ्च वयम् ईश्वरस्य सन्ताना एतस्मिन् पवित्र आत्मा स्वयम् अस्माकम् आत्माभिः सार्द्धं प्रमाणं ददाति। ");
INSERT INTO sandev_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","अतएव वयं यदि सन्तानास्तर्ह्यधिकारिणः, अर्थाद् ईश्वरस्य स्वत्त्वाधिकारिणः ख्रीष्टेन सहाधिकारिणश्च भवामः; अपरं तेन सार्द्धं यदि दुःखभागिनो भवामस्तर्हि तस्य विभवस्यापि भागिनो भविष्यामः। ");
INSERT INTO sandev_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","किन्त्वस्मासु यो भावीविभवः प्रकाशिष्यते तस्य समीपे वर्त्तमानकालीनं दुःखमहं तृणाय मन्ये। ");
INSERT INTO sandev_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","यतः प्राणिगण ईश्वरस्य सन्तानानां विभवप्राप्तिम् आकाङ्क्षन् नितान्तम् अपेक्षते। ");
INSERT INTO sandev_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","अपरञ्च प्राणिगणः स्वैरम् अलीकताया वशीकृतो नाभवत् ");
INSERT INTO sandev_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","किन्तु प्राणिगणोऽपि नश्वरताधीनत्वात् मुक्तः सन् ईश्वरस्य सन्तानानां परममुक्तिं प्राप्स्यतीत्यभिप्रायेण वशीकर्त्रा वशीचक्रे। ");
INSERT INTO sandev_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","अपरञ्च प्रसूयमानावद् व्यथितः सन् इदानीं यावत् कृत्स्नः प्राणिगण आर्त्तस्वरं करोतीति वयं जानीमः। ");
INSERT INTO sandev_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","केवलः स इति नहि किन्तु प्रथमजातफलस्वरूपम् आत्मानं प्राप्ता वयमपि दत्तकपुत्रत्वपदप्राप्तिम् अर्थात् शरीरस्य मुक्तिं प्रतीक्षमाणास्तद्वद् अन्तरार्त्तरावं कुर्म्मः। ");
INSERT INTO sandev_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","वयं प्रत्याशया त्राणम् अलभामहि किन्तु प्रत्यक्षवस्तुनो या प्रत्याशा सा प्रत्याशा नहि, यतो मनुष्यो यत् समीक्षते तस्य प्रत्याशां कुतः करिष्यति? ");
INSERT INTO sandev_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","यद् अप्रत्यक्षं तस्य प्रत्याशां यदि वयं कुर्व्वीमहि तर्हि धैर्य्यम् अवलम्ब्य प्रतीक्षामहे। ");
INSERT INTO sandev_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","तत आत्मापि स्वयम् अस्माकं दुर्ब्बलतायाः सहायत्वं करोति; यतः किं प्रार्थितव्यं तद् बोद्धुं वयं न शक्नुमः, किन्त्वस्पष्टैरार्त्तरावैरात्मा स्वयम् अस्मन्निमित्तं निवेदयति। ");
INSERT INTO sandev_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","अपरम् ईश्वराभिमतरूपेण पवित्रलोकानां कृते निवेदयति य आत्मा तस्याभिप्रायोऽन्तर्य्यामिना ज्ञायते। ");
INSERT INTO sandev_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","अपरम् ईश्वरीयनिरूपणानुसारेणाहूताः सन्तो ये तस्मिन् प्रीयन्ते सर्व्वाणि मिलित्वा तेषां मङ्गलं साधयन्ति, एतद् वयं जानीमः। ");
INSERT INTO sandev_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","यत ईश्वरो बहुभ्रातृणां मध्ये स्वपुत्रं ज्येष्ठं कर्त्तुम् इच्छन् यान् पूर्व्वं लक्ष्यीकृतवान् तान् तस्य प्रतिमूर्त्याः सादृश्यप्राप्त्यर्थं न्ययुंक्त। ");
INSERT INTO sandev_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","अपरञ्च तेन ये नियुक्तास्त आहूता अपि ये च तेनाहूतास्ते सपुण्यीकृताः, ये च तेन सपुण्यीकृतास्ते विभवयुक्ताः। ");
INSERT INTO sandev_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","इत्यत्र वयं किं ब्रूमः? ईश्वरो यद्यस्माकं सपक्षो भवति तर्हि को विपक्षोऽस्माकं? ");
INSERT INTO sandev_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","आत्मपुत्रं न रक्षित्वा योऽस्माकं सर्व्वेषां कृते तं प्रदत्तवान् स किं तेन सहास्मभ्यम् अन्यानि सर्व्वाणि न दास्यति? ");
INSERT INTO sandev_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","ईश्वरस्याभिरुचितेषु केन दोष आरोपयिष्यते? य ईश्वरस्तान् पुण्यवत इव गणयति किं तेन? ");
INSERT INTO sandev_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","अपरं तेभ्यो दण्डदानाज्ञा वा केन करिष्यते? योऽस्मन्निमित्तं प्राणान् त्यक्तवान् केवलं तन्न किन्तु मृतगणमध्याद् उत्थितवान्, अपि चेश्वरस्य दक्षिणे पार्श्वे तिष्ठन् अद्याप्यस्माकं निमित्तं प्रार्थत एवम्भूतो यः ख्रीष्टः किं तेन? ");
INSERT INTO sandev_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","अस्माभिः सह ख्रीष्टस्य प्रेमविच्छेदं जनयितुं कः शक्नोति? क्लेशो व्यसनं वा ताडना वा दुर्भिक्षं वा वस्त्रहीनत्वं वा प्राणसंशयो वा खङ्गो वा किमेतानि शक्नुवन्ति? ");
INSERT INTO sandev_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","किन्तु लिखितम् आस्ते, यथा, वयं तव निमित्तं स्मो मृत्युवक्त्रेऽखिलं दिनं। बलिर्देयो यथा मेषो वयं गण्यामहे तथा। ");
INSERT INTO sandev_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","अपरं योऽस्मासु प्रीयते तेनैतासु विपत्सु वयं सम्यग् विजयामहे। ");
INSERT INTO sandev_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","यतोऽस्माकं प्रभुना यीशुख्रीष्टेनेश्वरस्य यत् प्रेम तस्माद् अस्माकं विच्छेदं जनयितुं मृत्यु र्जीवनं वा दिव्यदूता वा बलवन्तो मुख्यदूता वा वर्त्तमानो वा भविष्यन् कालो वा उच्चपदं वा नीचपदं वापरं किमपि सृष्टवस्तु ");
INSERT INTO sandev_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","वैतेषां केनापि न शक्यमित्यस्मिन् दृढविश्वासो ममास्ते। ");
INSERT INTO sandev_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","अहं काञ्चिद् कल्पितां कथां न कथयामि, ख्रीष्टस्य साक्षात् सत्यमेव ब्रवीमि पवित्रस्यात्मनः साक्षान् मदीयं मन एतत् साक्ष्यं ददाति। ");
INSERT INTO sandev_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","ममान्तरतिशयदुःखं निरन्तरं खेदश्च ");
INSERT INTO sandev_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","तस्माद् अहं स्वजातीयभ्रातृणां निमित्तात् स्वयं ख्रीष्टाच्छापाक्रान्तो भवितुम् ऐच्छम्। ");
INSERT INTO sandev_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","यतस्त इस्रायेलस्य वंशा अपि च दत्तकपुत्रत्वं तेजो नियमो व्यवस्थादानं मन्दिरे भजनं प्रतिज्ञाः पितृपुरुषगणश्चैतेषु सर्व्वेषु तेषाम् अधिकारोऽस्ति। ");
INSERT INTO sandev_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","तत् केवलं नहि किन्तु सर्व्वाध्यक्षः सर्व्वदा सच्चिदानन्द ईश्वरो यः ख्रीष्टः सोऽपि शारीरिकसम्बन्धेन तेषां वंशसम्भवः। ");
INSERT INTO sandev_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","ईश्वरस्य वाक्यं विफलं जातम् इति नहि यत्कारणाद् इस्रायेलो वंशे ये जातास्ते सर्व्वे वस्तुत इस्रायेलीया न भवन्ति। ");
INSERT INTO sandev_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","अपरम् इब्राहीमो वंशे जाता अपि सर्व्वे तस्यैव सन्ताना न भवन्ति किन्तु इस्हाको नाम्ना तव वंशो विख्यातो भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","अर्थात् शारीरिकसंसर्गात् जाताः सन्ताना यावन्तस्तावन्त एवेश्वरस्य सन्ताना न भवन्ति किन्तु प्रतिश्रवणाद् ये जायन्ते तएवेश्वरवंशो गण्यते। ");
INSERT INTO sandev_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","यतस्तत्प्रतिश्रुते र्वाक्यमेतत्, एतादृशे समये ऽहं पुनरागमिष्यामि तत्पूर्व्वं सारायाः पुत्र एको जनिष्यते। ");
INSERT INTO sandev_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","अपरमपि वदामि स्वमनोऽभिलाषत ईश्वरेण यन्निरूपितं तत् कर्म्मतो नहि किन्त्वाह्वयितु र्जातमेतद् यथा सिद्ध्यति ");
INSERT INTO sandev_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","तदर्थं रिब्कानामिकया योषिता जनैकस्माद् अर्थाद् अस्माकम् इस्हाकः पूर्व्वपुरुषाद् गर्भे धृते तस्याः सन्तानयोः प्रसवात् पूर्व्वं किञ्च तयोः शुभाशुभकर्म्मणः करणात् पूर्व्वं ");
INSERT INTO sandev_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","तां प्रतीदं वाक्यम् उक्तं, ज्येष्ठः कनिष्ठं सेविष्यते, ");
INSERT INTO sandev_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","यथा लिखितम् आस्ते, तथाप्येषावि न प्रीत्वा याकूबि प्रीतवान् अहं। ");
INSERT INTO sandev_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","तर्हि वयं किं ब्रूमः? ईश्वरः किम् अन्यायकारी? तथा न भवतु। ");
INSERT INTO sandev_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","यतः स स्वयं मूसाम् अवदत्; अहं यस्मिन् अनुग्रहं चिकीर्षामि तमेवानुगृह्लामि, यञ्च दयितुम् इच्छामि तमेव दये। ");
INSERT INTO sandev_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","अतएवेच्छता यतमानेन वा मानवेन तन्न साध्यते दयाकारिणेश्वरेणैव साध्यते। ");
INSERT INTO sandev_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","फिरौणि शास्त्रे लिखति, अहं त्वद्द्वारा मत्पराक्रमं दर्शयितुं सर्व्वपृथिव्यां निजनाम प्रकाशयितुञ्च त्वां स्थापितवान्। ");
INSERT INTO sandev_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","अतः स यम् अनुग्रहीतुम् इच्छति तमेवानुगृह्लाति, यञ्च निग्रहीतुम् इच्छति तं निगृह्लाति। ");
INSERT INTO sandev_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","यदि वदसि तर्हि स दोषं कुतो गृह्लाति? तदीयेच्छायाः प्रतिबन्धकत्वं कर्त्तं कस्य सामर्थ्यं विद्यते? ");
INSERT INTO sandev_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","हे ईश्वरस्य प्रतिपक्ष मर्त्य त्वं कः? एतादृशं मां कुतः सृष्टवान्? इति कथां सृष्टवस्तु स्रष्ट्रे किं कथयिष्यति? ");
INSERT INTO sandev_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","एकस्मान् मृत्पिण्डाद् उत्कृष्टापकृष्टौ द्विविधौ कलशौ कर्त्तुं किं कुलालस्य सामर्थ्यं नास्ति? ");
INSERT INTO sandev_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","ईश्वरः कोपं प्रकाशयितुं निजशक्तिं ज्ञापयितुञ्चेच्छन् यदि विनाशस्य योग्यानि क्रोधभाजनानि प्रति बहुकालं दीर्घसहिष्णुताम् आश्रयति; ");
INSERT INTO sandev_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","अपरञ्च विभवप्राप्त्यर्थं पूर्व्वं नियुक्तान्यनुग्रहपात्राणि प्रति निजविभवस्य बाहुल्यं प्रकाशयितुं केवलयिहूदिनां नहि भिन्नदेशिनामपि मध्याद् ");
INSERT INTO sandev_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","अस्मानिव तान्याह्वयति तत्र तव किं? ");
INSERT INTO sandev_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","होशेयग्रन्थे यथा लिखितम् आस्ते, यो लोको मम नासीत् तं वदिष्यामि मदीयकं। या जाति र्मेऽप्रिया चासीत् तां वदिष्याम्यहं प्रियां। ");
INSERT INTO sandev_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","यूयं मदीयलोका न यत्रेति वाक्यमौच्यत। अमरेशस्य सन्ताना इति ख्यास्यन्ति तत्र ते। ");
INSERT INTO sandev_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","इस्रायेलीयलोकेषु यिशायियोऽपि वाचमेतां प्राचारयत्, इस्रायेलीयवंशानां या संख्या सा तु निश्चितं। समुद्रसिकतासंख्यासमाना यदि जायते। तथापि केवलं लोकैरल्पैस्त्राणं व्रजिष्यते। ");
INSERT INTO sandev_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","यतो न्यायेन स्वं कर्म्म परेशः साधयिष्यति। देशे सएव संक्षेपान्निजं कर्म्म करिष्यति। ");
INSERT INTO sandev_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","यिशायियोऽपरमपि कथयामास, सैन्याध्यक्षपरेशेन चेत् किञ्चिन्नोदशिष्यत। तदा वयं सिदोमेवाभविष्याम विनिश्चितं। यद्वा वयम् अमोराया अगमिष्याम तुल्यतां। ");
INSERT INTO sandev_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","तर्हि वयं किं वक्ष्यामः? इतरदेशीया लोका अपि पुण्यार्थम् अयतमाना विश्वासेन पुण्यम् अलभन्त; ");
INSERT INTO sandev_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","किन्त्विस्रायेल्लोका व्यवस्थापालनेन पुण्यार्थं यतमानास्तन् नालभन्त। ");
INSERT INTO sandev_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","तस्य किं कारणं? ते विश्वासेन नहि किन्तु व्यवस्थायाः क्रियया चेष्टित्वा तस्मिन् स्खलनजनके पाषाणे पादस्खलनं प्राप्ताः। ");
INSERT INTO sandev_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","लिखितं यादृशम् आस्ते, पश्य पादस्खलार्थं हि सीयोनि प्रस्तरन्तथा। बाधाकारञ्च पाषाणं परिस्थापितवानहम्। विश्वसिष्यति यस्तत्र स जनो न त्रपिष्यते। ");
INSERT INTO sandev_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","हे भ्रातर इस्रायेलीयलोका यत् परित्राणं प्राप्नुवन्ति तदहं मनसाभिलषन् ईश्वरस्य समीपे प्रार्थये। ");
INSERT INTO sandev_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","यत ईश्वरे तेषां चेष्टा विद्यत इत्यत्राहं साक्ष्यस्मि; किन्तु तेषां सा चेष्टा सज्ञाना नहि, ");
INSERT INTO sandev_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","यतस्त ईश्वरदत्तं पुण्यम् अविज्ञाय स्वकृतपुण्यं स्थापयितुम् चेष्टमाना ईश्वरदत्तस्य पुण्यस्य निघ्नत्वं न स्वीकुर्व्वन्ति। ");
INSERT INTO sandev_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","ख्रीष्ट एकैकविश्वासिजनाय पुण्यं दातुं व्यवस्थायाः फलस्वरूपो भवति। ");
INSERT INTO sandev_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","व्यवस्थापालनेन यत् पुण्यं तत् मूसा वर्णयामास, यथा, यो जनस्तां पालयिष्यति स तद्द्वारा जीविष्यति। ");
INSERT INTO sandev_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","किन्तु प्रत्ययेन यत् पुण्यं तद् एतादृशं वाक्यं वदति, कः स्वर्गम् आरुह्य ख्रीष्टम् अवरोहयिष्यति? ");
INSERT INTO sandev_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","को वा प्रेतलोकम् अवरुह्य ख्रीष्टं मृतगणमध्याद् आनेष्यतीति वाक् मनसि त्वया न गदितव्या। ");
INSERT INTO sandev_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","तर्हि किं ब्रवीति? तद् वाक्यं तव समीपस्थम् अर्थात् तव वदने मनसि चास्ते, तच्च वाक्यम् अस्माभिः प्रचार्य्यमाणं विश्वासस्य वाक्यमेव। ");
INSERT INTO sandev_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","वस्तुतः प्रभुं यीशुं यदि वदनेन स्वीकरोषि, तथेश्वरस्तं श्मशानाद् उदस्थापयद् इति यद्यन्तःकरणेन विश्वसिषि तर्हि परित्राणं लप्स्यसे। ");
INSERT INTO sandev_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","यस्मात् पुण्यप्राप्त्यर्थम् अन्तःकरणेन विश्वसितव्यं परित्राणार्थञ्च वदनेन स्वीकर्त्तव्यं। ");
INSERT INTO sandev_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","शास्त्रे यादृशं लिखति विश्वसिष्यति यस्तत्र स जनो न त्रपिष्यते। ");
INSERT INTO sandev_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","इत्यत्र यिहूदिनि तदन्यलोके च कोपि विशेषो नास्ति यस्माद् यः सर्व्वेषाम् अद्वितीयः प्रभुः स निजयाचकान सर्व्वान् प्रति वदान्यो भवति। ");
INSERT INTO sandev_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","यतः, यः कश्चित् परमेशस्य नाम्ना हि प्रार्थयिष्यते। स एव मनुजो नूनं परित्रातो भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","यं ये जना न प्रत्यायन् ते तमुद्दिश्य कथं प्रार्थयिष्यन्ते? ये वा यस्याख्यानं कदापि न श्रुतवन्तस्ते तं कथं प्रत्येष्यन्ति? अपरं यदि प्रचारयितारो न तिष्ठन्ति तदा कथं ते श्रोष्यन्ति? ");
INSERT INTO sandev_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","यदि वा प्रेरिता न भवन्ति तदा कथं प्रचारयिष्यन्ति? यादृशं लिखितम् आस्ते, यथा, माङ्गलिकं सुसंवादं ददत्यानीय ये नराः। प्रचारयन्ति शान्तेश्च सुसंवादं जनास्तु ये। तेषां चरणपद्मानि कीदृक् शोभान्वितानि हि। ");
INSERT INTO sandev_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","किन्तु ते सर्व्वे तं सुसंवादं न गृहीतवन्तः। यिशायियो यथा लिखितवान्। अस्मत्प्रचारिते वाक्ये विश्वासमकरोद्धि कः। ");
INSERT INTO sandev_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","अतएव श्रवणाद् विश्वास ऐश्वरवाक्यप्रचारात् श्रवणञ्च भवति। ");
INSERT INTO sandev_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","तर्ह्यहं ब्रवीमि तैः किं नाश्रावि? अवश्यम् अश्रावि, यस्मात् तेषां शब्दो महीं व्याप्नोद् वाक्यञ्च निखिलं जगत्। ");
INSERT INTO sandev_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","अपरमपि वदामि, इस्रायेलीयलोकाः किम् एतां कथां न बुध्यन्ते? प्रथमतो मूसा इदं वाक्यं प्रोवाच, अहमुत्तापयिष्ये तान् अगण्यमानवैरपि। क्लेक्ष्यामि जातिम् एताञ्च प्रोन्मत्तभिन्नजातिभिः। ");
INSERT INTO sandev_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","अपरञ्च यिशायियोऽतिशयाक्षोभेण कथयामास, यथा, अधि मां यैस्तु नाचेष्टि सम्प्राप्तस्तै र्जनैरहं। अधि मां यै र्न सम्पृष्टं विज्ञातस्तै र्जनैरहं॥ ");
INSERT INTO sandev_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","किन्त्विस्रायेलीयलोकान् अधि कथयाञ्चकार, यैराज्ञालङ्घिभि र्लोकै र्विरुद्धं वाक्यमुच्यते। तान् प्रत्येव दिनं कृत्स्नं हस्तौ विस्तारयाम्यहं॥ ");
INSERT INTO sandev_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","ईश्वरेण स्वीकीयलोका अपसारिता अहं किम् ईदृशं वाक्यं ब्रवीमि? तन्न भवतु यतोऽहमपि बिन्यामीनगोत्रीय इब्राहीमवंशीय इस्रायेलीयलोकोऽस्मि। ");
INSERT INTO sandev_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","ईश्वरेण पूर्व्वं ये प्रदृष्टास्ते स्वकीयलोका अपसारिता इति नहि। अपरम् एलियोपाख्याने शास्त्रे यल्लिखितम् आस्ते तद् यूयं किं न जानीथ? ");
INSERT INTO sandev_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","हे परमेश्वर लोकास्त्वदीयाः सर्व्वा यज्ञवेदीरभञ्जन् तथा तव भविष्यद्वादिनः सर्व्वान् अघ्नन् केवल एकोऽहम् अवशिष्ट आसे ते ममापि प्राणान् नाशयितुं चेष्टनते, एतां कथाम् इस्रायेलीयलोकानां विरुद्धम् एलिय ईश्वराय निवेदयामास। ");
INSERT INTO sandev_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","ततस्तं प्रतीश्वरस्योत्तरं किं जातं? बाल्नाम्नो देवस्य साक्षात् यै र्जानूनि न पातितानि तादृशाः सप्त सहस्राणि लोका अवशेषिता मया। ");
INSERT INTO sandev_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","तद्वद् एतस्मिन् वर्त्तमानकालेऽपि अनुग्रहेणाभिरुचितास्तेषाम् अवशिष्टाः कतिपया लोकाः सन्ति। ");
INSERT INTO sandev_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","अतएव तद् यद्यनुग्रहेण भवति तर्हि क्रियया न भवति नो चेद् अनुग्रहोऽननुग्रह एव, यदि वा क्रियया भवति तर्ह्यनुग्रहेण न भवति नो चेत् क्रिया क्रियैव न भवति। ");
INSERT INTO sandev_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","तर्हि किं? इस्रायेलीयलोका यद् अमृगयन्त तन्न प्रापुः। किन्त्वभिरुचितलोकास्तत् प्रापुस्तदन्ये सर्व्व अन्धीभूताः। ");
INSERT INTO sandev_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","यथा लिखितम् आस्ते, घोरनिद्रालुताभावं दृष्टिहीने च लोचने। कर्णौ श्रुतिविहीनौ च प्रददौ तेभ्य ईश्वरः॥ ");
INSERT INTO sandev_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","एतेस्मिन् दायूदपि लिखितवान् यथा, अतो भुक्त्यासनं तेषाम् उन्माथवद् भविष्यति। वा वंशयन्त्रवद् बाधा दण्डवद् वा भविष्यति॥ ");
INSERT INTO sandev_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","भविष्यन्ति तथान्धास्ते नेत्रैः पश्यन्ति नो यथा। वेपथुः कटिदेशस्य तेषां नित्यं भविष्यति॥ ");
INSERT INTO sandev_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","पतनार्थं ते स्खलितवन्त इति वाचं किमहं वदामि? तन्न भवतु किन्तु तान् उद्योगिनः कर्त्तुं तेषां पतनाद् इतरदेशीयलोकैः परित्राणं प्राप्तं। ");
INSERT INTO sandev_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","तेषां पतनं यदि जगतो लोकानां लाभजनकम् अभवत् तेषां ह्रासोऽपि यदि भिन्नदेशिनां लाभजनकोऽभवत् तर्हि तेषां वृद्धिः कति लाभजनिका भविष्यति? ");
INSERT INTO sandev_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","अतो हे अन्यदेशिनो युष्मान् सम्बोध्य कथयामि निजानां ज्ञातिबन्धूनां मनःसूद्योगं जनयन् तेषां मध्ये कियतां लोकानां यथा परित्राणं साधयामि ");
INSERT INTO sandev_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","तन्निमित्तम् अन्यदेशिनां निकटे प्रेरितः सन् अहं स्वपदस्य महिमानं प्रकाशयामि। ");
INSERT INTO sandev_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","तेषां निग्रहेण यदीश्वरेण सह जगतो जनानां मेलनं जातं तर्हि तेषाम् अनुगृहीतत्वं मृतदेहे यथा जीवनलाभस्तद्वत् किं न भविष्यति? ");
INSERT INTO sandev_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","अपरं प्रथमजातं फलं यदि पवित्रं भवति तर्हि सर्व्वमेव फलं पवित्रं भविष्यति; तथा मूलं यदि पवित्रं भवति तर्हि शाखा अपि तथैव भविष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","कियतीनां शाखानां छेदने कृते त्वं वन्यजितवृक्षस्य शाखा भूत्वा यदि तच्छाखानां स्थाने रोपिता सति जितवृक्षीयमूलस्य रसं भुंक्षे, ");
INSERT INTO sandev_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","तर्हि तासां भिन्नशाखानां विरुद्धं मां गर्व्वीः; यदि गर्व्वसि तर्हि त्वं मूलं यन्न धारयसि किन्तु मूलं त्वां धारयतीति संस्मर। ");
INSERT INTO sandev_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","अपरञ्च यदि वदसि मां रोपयितुं ताः शाखा विभन्ना अभवन्; ");
INSERT INTO sandev_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","भद्रम्, अप्रत्ययकारणात् ते विभिन्ना जातास्तथा विश्वासकारणात् त्वं रोपितो जातस्तस्माद् अहङ्कारम् अकृत्वा ससाध्वसो भव। ");
INSERT INTO sandev_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","यत ईश्वरो यदि स्वाभाविकीः शाखा न रक्षति तर्हि सावधानो भव चेत् त्वामपि न स्थापयति। ");
INSERT INTO sandev_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","इत्यत्रेश्वरस्य यादृशी कृपा तादृशं भयानकत्वमपि त्वया दृश्यतां; ये पतितास्तान् प्रति तस्य भयानकत्वं दृश्यतां, त्वञ्च यदि तत्कृपाश्रितस्तिष्ठसि तर्हि त्वां प्रति कृपा द्रक्ष्यते; नो चेत् त्वमपि तद्वत् छिन्नो भविष्यसि। ");
INSERT INTO sandev_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","अपरञ्च ते यद्यप्रत्यये न तिष्ठन्ति तर्हि पुनरपि रोपयिष्यन्ते यस्मात् तान् पुनरपि रोपयितुम् इश्वरस्य शक्तिरास्ते। ");
INSERT INTO sandev_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","वन्यजितवृक्षस्य शाखा सन् त्वं यदि ततश्छिन्नो रीतिव्यत्ययेनोत्तमजितवृक्षे रोेेपितोऽभवस्तर्हि तस्य वृक्षस्य स्वीया याः शाखास्ताः किं पुनः स्ववृक्षे संलगितुं न शक्नुवन्ति? ");
INSERT INTO sandev_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","हे भ्रातरो युष्माकम् आत्माभिमानो यन्न जायते तदर्थं ममेदृशी वाञ्छा भवति यूयं एतन्निगूढतत्त्वम् अजानन्तो यन्न तिष्ठथ; वस्तुतो यावत्कालं सम्पूर्णरूपेण भिन्नदेशिनां संग्रहो न भविष्यति तावत्कालम् अंशत्वेन इस्रायेलीयलोकानाम् अन्धता स्थास्यति; ");
INSERT INTO sandev_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","पश्चात् ते सर्व्वे परित्रास्यन्ते; एतादृशं लिखितमप्यास्ते, आगमिष्यति सीयोनाद् एको यस्त्राणदायकः। अधर्म्मं याकुबो वंशात् स तु दूरीकरिष्यति। ");
INSERT INTO sandev_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","तथा दूरीकरिष्यामि तेषां पापान्यहं यदा। तदा तैरेव सार्द्धं मे नियमोऽयं भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","सुसंवादात् ते युष्माकं विपक्षा अभवन् किन्त्वभिरुचितत्वात् ते पितृलोकानां कृते प्रियपात्राणि भवन्ति। ");
INSERT INTO sandev_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","यत ईश्वरस्य दानाद् आह्वानाञ्च पश्चात्तापो न भवति। ");
INSERT INTO sandev_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","अतएव पूर्व्वम् ईश्वरेऽविश्वासिनः सन्तोऽपि यूयं यद्वत् सम्प्रति तेषाम् अविश्वासकारणाद् ईश्वरस्य कृपापात्राणि जातास्तद्वद् ");
INSERT INTO sandev_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","इदानीं तेऽविश्वासिनः सन्ति किन्तु युष्माभि र्लब्धकृपाकारणात् तैरपि कृपा लप्स्यते। ");
INSERT INTO sandev_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","ईश्वरः सर्व्वान् प्रति कृपां प्रकाशयितुं सर्व्वान् अविश्वासित्वेन गणयति। ");
INSERT INTO sandev_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","अहो ईश्वरस्य ज्ञानबुद्धिरूपयो र्धनयोः कीदृक् प्राचुर्य्यं। तस्य राजशासनस्य तत्त्वं कीदृग् अप्राप्यं। तस्य मार्गाश्च कीदृग् अनुपलक्ष्याः। ");
INSERT INTO sandev_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","परमेश्वरस्य सङ्कल्पं को ज्ञातवान्? तस्य मन्त्री वा कोऽभवत्? ");
INSERT INTO sandev_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","को वा तस्योपकारी भृत्वा तत्कृते तेन प्रत्युपकर्त्तव्यः? ");
INSERT INTO sandev_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","यतो वस्तुमात्रमेव तस्मात् तेन तस्मै चाभवत् तदीयो महिमा सर्व्वदा प्रकाशितो भवतु। इति। ");
INSERT INTO sandev_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","हे भ्रातर ईश्वरस्य कृपयाहं युष्मान् विनये यूयं स्वं स्वं शरीरं सजीवं पवित्रं ग्राह्यं बलिम् ईश्वरमुद्दिश्य समुत्सृजत, एषा सेवा युष्माकं योग्या। ");
INSERT INTO sandev_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","अपरं यूयं सांसारिका इव माचरत, किन्तु स्वं स्वं स्वभावं परावर्त्य नूतनाचारिणो भवत, तत ईश्वरस्य निदेशः कीदृग् उत्तमो ग्रहणीयः सम्पूर्णश्चेति युष्माभिरनुभाविष्यते। ");
INSERT INTO sandev_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","कश्चिदपि जनो योग्यत्वादधिकं स्वं न मन्यतां किन्तु ईश्वरो यस्मै प्रत्ययस्य यत्परिमाणम् अददात् स तदनुसारतो योग्यरूपं स्वं मनुताम्, ईश्वराद् अनुग्रहं प्राप्तः सन् युष्माकम् एकैकं जनम् इत्याज्ञापयामि। ");
INSERT INTO sandev_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","यतो यद्वदस्माकम् एकस्मिन् शरीरे बहून्यङ्गानि सन्ति किन्तु सर्व्वेषामङ्गानां कार्य्यं समानं नहि; ");
INSERT INTO sandev_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","तद्वदस्माकं बहुत्वेऽपि सर्व्वे वयं ख्रीष्टे एकशरीराः परस्परम् अङ्गप्रत्यङ्गत्वेन भवामः। ");
INSERT INTO sandev_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","अस्माद् ईश्वरानुग्रहेण विशेषं विशेषं दानम् अस्मासु प्राप्तेषु सत्सु कोपि यदि भविष्यद्वाक्यं वदति तर्हि प्रत्ययस्य परिमाणानुसारतः स तद् वदतु; ");
INSERT INTO sandev_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","यद्वा यदि कश्चित् सेवनकारी भवति तर्हि स तत्सेवनं करोतु; अथवा यदि कश्चिद् अध्यापयिता भवति तर्हि सोऽध्यापयतु; ");
INSERT INTO sandev_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","तथा य उपदेष्टा भवति स उपदिशतु यश्च दाता स सरलतया ददातु यस्त्वधिपतिः स यत्नेनाधिपतित्वं करोतु यश्च दयालुः स हृष्टमनसा दयताम्। ");
INSERT INTO sandev_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","अपरञ्च युष्माकं प्रेम कापट्यवर्जितं भवतु यद् अभद्रं तद् ऋतीयध्वं यच्च भद्रं तस्मिन् अनुरज्यध्वम्। ");
INSERT INTO sandev_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","अपरं भ्रातृत्वप्रेम्ना परस्परं प्रीयध्वं समादराद् एकोऽपरजनं श्रेष्ठं जानीध्वम्। ");
INSERT INTO sandev_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","तथा कार्य्ये निरालस्या मनसि च सोद्योगाः सन्तः प्रभुं सेवध्वम्। ");
INSERT INTO sandev_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","अपरं प्रत्याशायाम् आनन्दिता दुःखसमये च धैर्य्ययुक्ता भवत; प्रार्थनायां सततं प्रवर्त्तध्वं। ");
INSERT INTO sandev_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","पवित्राणां दीनतां दूरीकुरुध्वम् अतिथिसेवायाम् अनुरज्यध्वम्। ");
INSERT INTO sandev_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","ये जना युष्मान् ताडयन्ति तान् आशिषं वदत शापम् अदत्त्वा दद्ध्वमाशिषम्। ");
INSERT INTO sandev_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","ये जना आनन्दन्ति तैः सार्द्धम् आनन्दत ये च रुदन्ति तैः सह रुदित। ");
INSERT INTO sandev_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","अपरञ्च युष्माकं मनसां परस्परम् एकोभावो भवतु; अपरम् उच्चपदम् अनाकाङ्क्ष्य नीचलोकैः सहापि मार्दवम् आचरत; स्वान् ज्ञानिनो न मन्यध्वं। ");
INSERT INTO sandev_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","परस्माद् अपकारं प्राप्यापि परं नापकुरुत। सर्व्वेषां दृष्टितो यत् कर्म्मोत्तमं तदेव कुरुत। ");
INSERT INTO sandev_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","यदि भवितुं शक्यते तर्हि यथाशक्ति सर्व्वलोकैः सह निर्व्विरोधेन कालं यापयत। ");
INSERT INTO sandev_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","हे प्रियबन्धवः, कस्मैचिद् अपकारस्य समुचितं दण्डं स्वयं न दद्ध्वं, किन्त्वीश्वरीयक्रोधाय स्थानं दत्त यतो लिखितमास्ते परमेश्वरः कथयति, दानं फलस्य मत्कर्म्म सूचितं प्रददाम्यहं। ");
INSERT INTO sandev_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","इतिकारणाद् रिपु र्यदि क्षुधार्त्तस्ते तर्हि तं त्वं प्रभोजय। तथा यदि तृषार्त्तः स्यात् तर्हि तं परिपायय। तेन त्वं मस्तके तस्य ज्वलदग्निं निधास्यसि। ");
INSERT INTO sandev_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","कुक्रियया पराजिता न सन्त उत्तमक्रियया कुक्रियां पराजयत। ");
INSERT INTO sandev_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","युष्माकम् एकैकजनः शासनपदस्य निघ्नो भवतु यतो यानि शासनपदानि सन्ति तानि सर्व्वाणीश्वरेण स्थापितानि; ईश्वरं विना पदस्थापनं न भवति। ");
INSERT INTO sandev_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","इति हेतोः शासनपदस्य यत् प्रातिकूल्यं तद् ईश्वरीयनिरूपणस्य प्रातिकूल्यमेव; अपरं ये प्रातिकूल्यम् आचरन्ति ते स्वेषां समुचितं दण्डं स्वयमेव घटयन्ते। ");
INSERT INTO sandev_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","शास्ता सदाचारिणां भयप्रदो नहि दुराचारिणामेव भयप्रदो भवति; त्वं किं तस्मान् निर्भयो भवितुम् इच्छसि? तर्हि सत्कर्म्माचर, तस्माद् यशो लप्स्यसे, ");
INSERT INTO sandev_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","यतस्तव सदाचरणाय स ईश्वरस्य भृत्योऽस्ति। किन्तु यदि कुकर्म्माचरसि तर्हि त्वं शङ्कस्व यतः स निरर्थकं खङ्गं न धारयति; कुकर्म्माचारिणं समुचितं दण्डयितुम् स ईश्वरस्य दण्डदभृत्य एव। ");
INSERT INTO sandev_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","अतएव केवलदण्डभयान्नहि किन्तु सदसद्बोधादपि तस्य वश्येन भवितव्यं। ");
INSERT INTO sandev_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","एतस्माद् युष्माकं राजकरदानमप्युचितं यस्माद् ये करं गृह्लन्ति त ईश्वरस्य किङ्करा भूत्वा सततम् एतस्मिन् कर्म्मणि निविष्टास्तिष्ठन्ति। ");
INSERT INTO sandev_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","अस्मात् करग्राहिणे करं दत्त, तथा शुल्कग्राहिणे शुल्कं दत्त, अपरं यस्माद् भेतव्यं तस्माद् बिभीत, यश्च समादरणीयस्तं समाद्रियध्वम्; इत्थं यस्य यत् प्राप्यं तत् तस्मै दत्त। ");
INSERT INTO sandev_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","युष्माकं परस्परं प्रेम विना ऽन्यत् किमपि देयम् ऋणं न भवतु, यतो यः परस्मिन् प्रेम करोति तेन व्यवस्था सिध्यति। ");
INSERT INTO sandev_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","वस्तुतः परदारान् मा गच्छ, नरहत्यां मा कार्षीः, चैर्य्यं मा कार्षीः, मिथ्यासाक्ष्यं मा देहि, लोभं मा कार्षीः, एताः सर्व्वा आज्ञा एताभ्यो भिन्ना या काचिद् आज्ञास्ति सापि स्वसमीपवासिनि स्ववत् प्रेम कुर्व्वित्यनेन वचनेन वेदिता। ");
INSERT INTO sandev_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","यतः प्रेम समीपवासिनोऽशुभं न जनयति तस्मात् प्रेम्ना सर्व्वा व्यवस्था पाल्यते। ");
INSERT INTO sandev_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","प्रत्ययीभवनकालेऽस्माकं परित्राणस्य सामीप्याद् इदानीं तस्य सामीप्यम् अव्यवहितं; अतः समयं विविच्यास्माभिः साम्प्रतम् अवश्यमेव निद्रातो जागर्त्तव्यं। ");
INSERT INTO sandev_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","बहुतरा यामिनी गता प्रभातं सन्निधिं प्राप्तं तस्मात् तामसीयाः क्रियाः परित्यज्यास्माभि र्वासरीया सज्जा परिधातव्या। ");
INSERT INTO sandev_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","अतो हेतो र्वयं दिवा विहितं सदाचरणम् आचरिष्यामः। रङ्गरसो मत्तत्वं लम्पटत्वं कामुकत्वं विवाद ईर्ष्या चैतानि परित्यक्ष्यामः। ");
INSERT INTO sandev_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","यूयं प्रभुयीशुख्रीष्टरूपं परिच्छदं परिधद्ध्वं सुखाभिलाषपूरणाय शारीरिकाचरणं माचरत। ");
INSERT INTO sandev_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","यो जनोऽदृढविश्वासस्तं युष्माकं सङ्गिनं कुरुत किन्तु सन्देहविचारार्थं नहि। ");
INSERT INTO sandev_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","यतो निषिद्धं किमपि खाद्यद्रव्यं नास्ति, कस्यचिज्जनस्य प्रत्यय एतादृशो विद्यते किन्त्वदृढविश्वासः कश्चिदपरो जनः केवलं शाकं भुङ्क्तं। ");
INSERT INTO sandev_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","तर्हि यो जनः साधारणं द्रव्यं भुङ्क्ते स विशेषद्रव्यभोक्तारं नावजानीयात् तथा विशेषद्रव्यभोक्तापि साधारणद्रव्यभोक्तारं दोषिणं न कुर्य्यात्, यस्माद् ईश्वरस्तम् अगृह्लात्। ");
INSERT INTO sandev_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","हे परदासस्य दूषयितस्त्वं कः? निजप्रभोः समीपे तेन पदस्थेन पदच्युतेन वा भवितव्यं स च पदस्थ एव भविष्यति यत ईश्वरस्तं पदस्थं कर्त्तुं शक्नोति। ");
INSERT INTO sandev_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","अपरञ्च कश्चिज्जनो दिनाद् दिनं विशेषं मन्यते कश्चित्तुु सर्व्वाणि दिनानि समानानि मन्यते, एकैको जनः स्वीयमनसि विविच्य निश्चिनोतु। ");
INSERT INTO sandev_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","यो जनः किञ्चन दिनं विशेषं मन्यते स प्रभुभक्त्या तन् मन्यते, यश्च जनः किमपि दिनं विशेषं न मन्यते सोऽपि प्रभुभक्त्या तन्न मन्यते; अपरञ्च यः सर्व्वाणि भक्ष्यद्रव्याणि भुङ्क्ते स प्रभुभक्तया तानि भुङ्क्ते यतः स ईश्वरं धन्यं वक्ति, यश्च न भुङ्क्ते सोऽपि प्रभुभक्त्यैव न भुञ्जान ईश्वरं धन्यं ब्रूते। ");
INSERT INTO sandev_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","अपरम् अस्माकं कश्चित् निजनिमित्तं प्राणान् धारयति निजनिमित्तं म्रियते वा तन्न; ");
INSERT INTO sandev_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","किन्तु यदि वयं प्राणान् धारयामस्तर्हि प्रभुनिमित्तं धारयामः, यदि च प्राणान् त्यजामस्तर्ह्यपि प्रभुनिमित्तं त्यजामः, अतएव जीवने मरणे वा वयं प्रभोरेवास्महे। ");
INSERT INTO sandev_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","यतो जीवन्तो मृताश्चेत्युभयेषां लोकानां प्रभुत्वप्राप्त्यर्थं ख्रीष्टो मृत उत्थितः पुनर्जीवितश्च। ");
INSERT INTO sandev_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","किन्तु त्वं निजं भ्रातरं कुतो दूषयसि? तथा त्वं निजं भ्रातरं कुतस्तुच्छं जानासि? ख्रीष्टस्य विचारसिंहासनस्य सम्मुखे सर्व्वैरस्माभिरुपस्थातव्यं; ");
INSERT INTO sandev_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","यादृशं लिखितम् आस्ते, परेशः शपथं कुर्व्वन् वाक्यमेतत् पुरावदत्। सर्व्वो जनः समीपे मे जानुपातं करिष्यति। जिह्वैकैका तथेशस्य निघ्नत्वं स्वीकरिष्यति। ");
INSERT INTO sandev_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","अतएव ईश्वरसमीपेऽस्माकम् एकैकजनेन निजा कथा कथयितव्या। ");
INSERT INTO sandev_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","इत्थं सति वयम् अद्यारभ्य परस्परं न दूषयन्तः स्वभ्रातु र्विघ्नो व्याघातो वा यन्न जायेत तादृशीमीहां कुर्म्महे। ");
INSERT INTO sandev_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","किमपि वस्तु स्वभावतो नाशुचि भवतीत्यहं जाने तथा प्रभुना यीशुख्रीष्टेनापि निश्चितं जाने, किन्तु यो जनो यद् द्रव्यम् अपवित्रं जानीते तस्य कृते तद् अपवित्रम् आस्ते। ");
INSERT INTO sandev_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","अतएव तव भक्ष्यद्रव्येण तव भ्राता शोकान्वितो भवति तर्हि त्वं भ्रातरं प्रति प्रेम्ना नाचरसि। ख्रीष्टो यस्य कृते स्वप्राणान् व्ययितवान् त्वं निजेन भक्ष्यद्रव्येण तं न नाशय। ");
INSERT INTO sandev_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","अपरं युष्माकम् उत्तमं कर्म्म निन्दितं न भवतु। ");
INSERT INTO sandev_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","भक्ष्यं पेयञ्चेश्वरराज्यस्य सारो नहि, किन्तु पुण्यं शान्तिश्च पवित्रेणात्मना जात आनन्दश्च। ");
INSERT INTO sandev_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","एतै र्यो जनः ख्रीष्टं सेवते, स एवेश्वरस्य तुष्टिकरो मनुष्यैश्च सुख्यातः। ");
INSERT INTO sandev_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","अतएव येनास्माकं सर्व्वेषां परस्परम् ऐक्यं निष्ठा च जायते तदेवास्माभि र्यतितव्यं। ");
INSERT INTO sandev_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","भक्ष्यार्थम् ईश्वरस्य कर्म्मणो हानिं मा जनयत; सर्व्वं वस्तु पवित्रमिति सत्यं तथापि यो जनो यद् भुक्त्वा विघ्नं लभते तदर्थं तद् भद्रं नहि। ");
INSERT INTO sandev_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","तव मांसभक्षणसुरापानादिभिः क्रियाभि र्यदि तव भ्रातुः पादस्खलनं विघ्नो वा चाञ्चल्यं वा जायते तर्हि तद्भोजनपानयोस्त्यागो भद्रः। ");
INSERT INTO sandev_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","यदि तव प्रत्ययस्तिष्ठति तर्हीश्वरस्य गोचरे स्वान्तरे तं गोपय; यो जनः स्वमतेन स्वं दोषिणं न करोति स एव धन्यः। ");
INSERT INTO sandev_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","किन्तु यः कश्चित् संशय्य भुङ्क्तेऽर्थात् न प्रतीत्य भुङ्क्ते, स एवावश्यं दण्डार्हो भविष्यति, यतो यत् प्रत्ययजं नहि तदेव पापमयं भवति। ");
INSERT INTO sandev_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","बलवद्भिरस्माभि र्दुर्ब्बलानां दौर्ब्बल्यं सोढव्यं न च स्वेषाम् इष्टाचार आचरितव्यः। ");
INSERT INTO sandev_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","अस्माकम् एकैको जनः स्वसमीपवासिनो हितार्थं निष्ठार्थञ्च तस्यैवेष्टाचारम् आचरतु। ");
INSERT INTO sandev_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","यतः ख्रीष्टोऽपि निजेष्टाचारं नाचरितवान्, यथा लिखितम् आस्ते, त्वन्निन्दकगणस्यैव निन्दाभि र्निन्दितोऽस्म्यहं। ");
INSERT INTO sandev_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","अपरञ्च वयं यत् सहिष्णुतासान्त्वनयो र्जनकेन शास्त्रेण प्रत्याशां लभेमहि तन्निमित्तं पूर्व्वकाले लिखितानि सर्व्ववचनान्यस्माकम् उपदेशार्थमेव लिलिखिरे। ");
INSERT INTO sandev_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","सहिष्णुतासान्त्वनयोराकरो य ईश्वरः स एवं करोतु यत् प्रभु र्यीशुख्रीष्ट इव युष्माकम् एकजनोऽन्यजनेन सार्द्धं मनस ऐक्यम् आचरेत्; ");
INSERT INTO sandev_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","यूयञ्च सर्व्व एकचित्ता भूत्वा मुखैकेनेवास्मत्प्रभुयीशुख्रीष्टस्य पितुरीश्वरस्य गुणान् कीर्त्तयेत। ");
INSERT INTO sandev_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","अपरम् ईश्वरस्य महिम्नः प्रकाशार्थं ख्रीष्टो यथा युष्मान् प्रत्यगृह्लात् तथा युष्माकमप्येको जनोऽन्यजनं प्रतिगृह्लातु। ");
INSERT INTO sandev_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","यथा लिखितम् आस्ते, अतोऽहं सम्मुखे तिष्ठन् भिन्नदेशनिवासिनां। स्तुवंस्त्वां परिगास्यामि तव नाम्नि परेश्वर।। ");
INSERT INTO sandev_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","तस्य दयालुत्वाच्च भिन्नजातीया यद् ईश्वरस्य गुणान् कीर्त्तयेयुस्तदर्थं यीशुः ख्रीष्टस्त्वक्छेदनियमस्य निघ्नोऽभवद् इत्यहं वदामि। यथा लिखितम् आस्ते, अतोऽहं सम्मुखे तिष्ठन् भिन्नदेशनिवासिनां। स्तुवंस्त्वां परिगास्यामि तव नाम्नि परेश्वर॥ ");
INSERT INTO sandev_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","अपरमपि लिखितम् आस्ते, हे अन्यजातयो यूयं समं नन्दत तज्जनैः। ");
INSERT INTO sandev_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","पुनश्च लिखितम् आस्ते, हे सर्व्वदेशिनो यूयं धन्यं ब्रूत परेश्वरं। हे तदीयनरा यूयं कुरुध्वं तत्प्रशंसनं॥ ");
INSERT INTO sandev_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","अपर यीशायियोऽपि लिलेख, यीशयस्य तु यत् मूलं तत् प्रकाशिष्यते तदा। सर्व्वजातीयनृणाञ्च शासकः समुदेष्यति। तत्रान्यदेशिलोकैश्च प्रत्याशा प्रकरिष्यते॥ ");
INSERT INTO sandev_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","अतएव यूयं पवित्रस्यात्मनः प्रभावाद् यत् सम्पूर्णां प्रत्याशां लप्स्यध्वे तदर्थं तत्प्रत्याशाजनक ईश्वरः प्रत्ययेन युष्मान् शान्त्यानन्दाभ्यां सम्पूर्णान् करोतु। ");
INSERT INTO sandev_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","हे भ्रातरो यूयं सद्भावयुक्ताः सर्व्वप्रकारेण ज्ञानेन च सम्पूर्णाः परस्परोपदेशे च तत्परा इत्यहं निश्चितं जानामि, ");
INSERT INTO sandev_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","तथाप्यहं यत् प्रगल्भतरो भवन् युष्मान् प्रबोधयामि तस्यैकं कारणमिदं। ");
INSERT INTO sandev_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","भिन्नजातीयाः पवित्रेणात्मना पावितनैवेद्यरूपा भूत्वा यद् ग्राह्या भवेयुस्तन्निमित्तमहम् ईश्वरस्य सुसंवादं प्रचारयितुं भिन्नजातीयानां मध्ये यीशुख्रीष्टस्य सेवकत्वं दानं ईश्वरात् लब्धवानस्मि। ");
INSERT INTO sandev_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","ईश्वरं प्रति यीशुख्रीष्टेन मम श्लाघाकरणस्य कारणम् आस्ते। ");
INSERT INTO sandev_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","भिन्नदेशिन आज्ञाग्राहिणः कर्त्तुं ख्रीष्टो वाक्येन क्रियया च, आश्चर्य्यलक्षणैश्चित्रक्रियाभिः पवित्रस्यात्मनः प्रभावेन च यानि कर्म्माणि मया साधितवान्, ");
INSERT INTO sandev_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","केवलं तान्येव विनान्यस्य कस्यचित् कर्म्मणो वर्णनां कर्त्तुं प्रगल्भो न भवामि। तस्मात् आ यिरूशालम इल्लूरिकं यावत् सर्व्वत्र ख्रीष्टस्य सुसंवादं प्राचारयं। ");
INSERT INTO sandev_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","अन्येन निचितायां भित्तावहं यन्न निचिनोमि तन्निमित्तं यत्र यत्र स्थाने ख्रीष्टस्य नाम कदापि केनापि न ज्ञापितं तत्र तत्र सुसंवादं प्रचारयितुम् अहं यते। ");
INSERT INTO sandev_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","यादृशं लिखितम् आस्ते, यै र्वार्त्ता तस्य न प्राप्ता दर्शनं तैस्तु लप्स्यते। यैश्च नैव श्रुतं किञ्चित् बोद्धुं शक्ष्यन्ति ते जनाः॥ ");
INSERT INTO sandev_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","तस्माद् युष्मत्समीपगमनाद् अहं मुहुर्मुहु र्निवारितोऽभवं। ");
INSERT INTO sandev_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","किन्त्विदानीम् अत्र प्रदेशेषु मया न गतं स्थानं किमपि नावशिष्यते युष्मत्समीपं गन्तुं बहुवत्सरानारभ्य मामकीनाकाङ्क्षा च विद्यत इति हेतोः ");
INSERT INTO sandev_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","स्पानियादेशगमनकालेऽहं युष्मन्मध्येन गच्छन् युष्मान् आलोकिष्ये, ततः परं युष्मत्सम्भाषणेन तृप्तिं परिलभ्य तद्देशगमनार्थं युष्माभि र्विसर्जयिष्ये, ईदृशी मदीया प्रत्याशा विद्यते। ");
INSERT INTO sandev_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","किन्तु साम्प्रतं पवित्रलोकानां सेवनाय यिरूशालम्नगरं व्रजामि। ");
INSERT INTO sandev_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","यतो यिरूशालमस्थपवित्रलोकानां मध्ये ये दरिद्रा अर्थविश्राणनेन तानुपकर्त्तुं माकिदनियादेशीया आखायादेशीयाश्च लोका ऐच्छन्। ");
INSERT INTO sandev_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","एषा तेषां सदिच्छा यतस्ते तेषाम् ऋणिनः सन्ति यतो हेतो र्भिन्नजातीया येषां परमार्थस्यांशिनो जाता ऐहिकविषये तेषामुपकारस्तैः कर्त्तव्यः। ");
INSERT INTO sandev_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","अतो मया तत् कर्म्म साधयित्वा तस्मिन् फले तेभ्यः समर्पिते युष्मन्मध्येन स्पानियादेशो गमिष्यते। ");
INSERT INTO sandev_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","युष्मत्समीपे ममागमनसमये ख्रीष्टस्य सुसंवादस्य पूर्णवरेण सम्बलितः सन् अहम् आगमिष्यामि इति मया ज्ञायते। ");
INSERT INTO sandev_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","हे भ्रातृगण प्रभो र्यीशुख्रीष्टस्य नाम्ना पवित्रस्यात्मानः प्रेम्ना च विनयेऽहं ");
INSERT INTO sandev_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","यिहूदादेशस्थानाम् अविश्वासिलोकानां करेभ्यो यदहं रक्षां लभेय मदीयैतेन सेवनकर्म्मणा च यद् यिरूशालमस्थाः पवित्रलोकास्तुष्येयुः, ");
INSERT INTO sandev_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","तदर्थं यूयं मत्कृत ईश्वराय प्रार्थयमाणा यतध्वं तेनाहम् ईश्वरेच्छया सानन्दं युष्मत्समीपं गत्वा युष्माभिः सहितः प्राणान् आप्यायितुं पारयिष्यामि। ");
INSERT INTO sandev_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","शान्तिदायक ईश्वरो युष्माकं सर्व्वेषां सङ्गी भूयात्। इति। ");
INSERT INTO sandev_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","किंक्रीयानगरीयधर्म्मसमाजस्य परिचारिका या फैबीनामिकास्माकं धर्म्मभगिनी तस्याः कृतेऽहं युष्मान् निवेदयामि, ");
INSERT INTO sandev_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","यूयं तां प्रभुमाश्रितां विज्ञाय तस्या आतिथ्यं पवित्रलोकार्हं कुरुध्वं, युष्मत्तस्तस्या य उपकारो भवितुं शक्नोति तं कुरुध्वं, यस्मात् तया बहूनां मम चोपकारः कृतः। ");
INSERT INTO sandev_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","अपरञ्च ख्रीष्टस्य यीशोः कर्म्मणि मम सहकारिणौ मम प्राणरक्षार्थञ्च स्वप्राणान् पणीकृतवन्तौ यौ प्रिष्किल्लाक्किलौ तौ मम नमस्कारं ज्ञापयध्वं। ");
INSERT INTO sandev_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","ताभ्याम् उपकाराप्तिः केवलं मया स्वीकर्त्तव्येति नहि भिन्नदेशीयैः सर्व्वधर्म्मसमाजैरपि। ");
INSERT INTO sandev_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","अपरञ्च तयो र्गृहे स्थितान् धर्म्मसमाजलोकान् मम नमस्कारं ज्ञापयध्वं। तद्वत् आशियादेशे ख्रीष्टस्य पक्षे प्रथमजातफलस्वरूपो य इपेनितनामा मम प्रियबन्धुस्तमपि मम नमस्कारं ज्ञापयध्वं। ");
INSERT INTO sandev_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","अपरं बहुश्रमेणास्मान् असेवत या मरियम् तामपि नमस्कारं ज्ञापयध्वं। ");
INSERT INTO sandev_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","अपरञ्च प्रेरितेषु ख्यातकीर्त्ती मदग्रे ख्रीष्टाश्रितौ मम स्वजातीयौ सहबन्दिनौ च यावान्द्रनीकयूनियौ तौ मम नमस्कारं ज्ञापयध्वं। ");
INSERT INTO sandev_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","तथा प्रभौ मत्प्रियतमम् आम्प्लियमपि मम नमस्कारं ज्ञापयध्वं। ");
INSERT INTO sandev_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","अपरं ख्रीष्टसेवायां मम सहकारिणम् ऊर्ब्बाणं मम प्रियतमं स्ताखुञ्च मम नमस्कारं ज्ञापयध्वं। ");
INSERT INTO sandev_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","अपरं ख्रीष्टेन परीक्षितम् आपिल्लिं मम नमस्कारं वदत, आरिष्टबूलस्य परिजनांश्च मम नमस्कारं ज्ञापयध्वं। ");
INSERT INTO sandev_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","अपरं मम ज्ञातिं हेरोदियोनं मम नमस्कारं वदत, तथा नार्किसस्य परिवाराणां मध्ये ये प्रभुमाश्रितास्तान् मम नमस्कारं वदत। ");
INSERT INTO sandev_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","अपरं प्रभोः सेवायां परिश्रमकारिण्यौ त्रुफेनात्रुफोषे मम नमस्कारं वदत, तथा प्रभोः सेवायाम् अत्यन्तं परिश्रमकारिणी या प्रिया पर्षिस्तां नमस्कारं ज्ञापयध्वं। ");
INSERT INTO sandev_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","अपरं प्रभोरभिरुचितं रूफं मम धर्म्ममाता या तस्य माता तामपि नमस्कारं वदत। ");
INSERT INTO sandev_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","अपरम् असुंकृतं फ्लिगोनं हर्म्मं पात्रबं हर्म्मिम् एतेषां सङ्गिभ्रातृगणञ्च नमस्कारं ज्ञापयध्वं। ");
INSERT INTO sandev_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","अपरं फिललगो यूलिया नीरियस्तस्य भगिन्यलुम्पा चैतान् एतैः सार्द्धं यावन्तः पवित्रलोका आसते तानपि नमस्कारं ज्ञापयध्वं। ");
INSERT INTO sandev_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","यूयं परस्परं पवित्रचुम्बनेन नमस्कुरुध्वं। ख्रीष्टस्य धर्म्मसमाजगणो युष्मान् नमस्कुरुते। ");
INSERT INTO sandev_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","हे भ्रातरो युष्मान् विनयेऽहं युष्माभि र्या शिक्षा लब्धा ताम् अतिक्रम्य ये विच्छेदान् विघ्नांश्च कुर्व्वन्ति तान् निश्चिनुत तेषां सङ्गं वर्जयत च। ");
INSERT INTO sandev_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","यतस्तादृशा लोका अस्माकं प्रभो र्यीशुख्रीष्टस्य दासा इति नहि किन्तु स्वोदरस्यैव दासाः; अपरं प्रणयवचनै र्मधुरवाक्यैश्च सरललोकानां मनांसि मोहयन्ति। ");
INSERT INTO sandev_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","युष्माकम् आज्ञाग्राहित्वं सर्व्वत्र सर्व्वै र्ज्ञातं ततोऽहं युष्मासु सानन्दोऽभवं तथापि यूयं यत् सत्ज्ञानेन ज्ञानिनः कुज्ञानेे चातत्परा भवेतेति ममाभिलाषः। ");
INSERT INTO sandev_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","अधिकन्तु शान्तिदायक ईश्वरः शैतानम् अविलम्बं युष्माकं पदानाम् अधो मर्द्दिष्यति। अस्माकं प्रभु र्यीशुख्रीष्टो युष्मासु प्रसादं क्रियात्। इति। ");
INSERT INTO sandev_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","मम सहकारी तीमथियो मम ज्ञातयो लूकियो यासोन् सोसिपात्रश्चेमे युष्मान् नमस्कुर्व्वन्ते। ");
INSERT INTO sandev_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","अपरम् एतत्पत्रलेखकस्तर्त्तियनामाहमपि प्रभो र्नाम्ना युष्मान् नमस्करोमि। ");
INSERT INTO sandev_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","तथा कृत्स्नधर्म्मसमाजस्य मम चातिथ्यकारी गायो युष्मान् नमस्करोति। अपरम् एतन्नगरस्य धनरक्षक इरास्तः क्कार्त्तनामकश्चैको भ्राता तावपि युष्मान् नमस्कुरुतः। ");
INSERT INTO sandev_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","अस्माकं प्रभु र्यीशुख्रीष्टा युष्मासु सर्व्वेषु प्रसादं क्रियात्। इति। ");
INSERT INTO sandev_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","पूर्व्वकालिकयुगेषु प्रच्छन्ना या मन्त्रणाधुना प्रकाशिता भूत्वा भविष्यद्वादिलिखितग्रन्थगणस्य प्रमाणाद् विश्वासेन ग्रहणार्थं सदातनस्येश्वरस्याज्ञया सर्व्वदेशीयलोकान् ज्ञाप्यते, ");
INSERT INTO sandev_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","तस्या मन्त्रणाया ज्ञानं लब्ध्वा मया यः सुसंवादो यीशुख्रीष्टमधि प्रचार्य्यते, तदनुसाराद् युष्मान् धर्म्मे सुस्थिरान् कर्त्तुं समर्थो योऽद्वितीयः ");
INSERT INTO sandev_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","सर्व्वज्ञ ईश्वरस्तस्य धन्यवादो यीशुख्रीष्टेन सन्ततं भूयात्। इति।");
INSERT INTO sandev_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","यावन्तः पवित्रा लोकाः स्वेषाम् अस्माकञ्च वसतिस्थानेष्वस्माकं प्रभो र्यीशोः ख्रीष्टस्य नाम्ना प्रार्थयन्ते तैः सहाहूतानां ख्रीष्टेन यीशुना पवित्रीकृतानां लोकानां य ईश्वरीयधर्म्मसमाजः करिन्थनगरे विद्यते ");
INSERT INTO sandev_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","तं प्रतीश्वरस्येच्छयाहूतो यीशुख्रीष्टस्य प्रेरितः पौलः सोस्थिनिनामा भ्राता च पत्रं लिखति। ");
INSERT INTO sandev_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","अस्माकं पित्रेश्वरेण प्रभुना यीशुख्रीष्टेन च प्रसादः शान्तिश्च युष्मभ्यं दीयतां। ");
INSERT INTO sandev_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","ईश्वरो यीशुख्रीष्टेन युष्मान् प्रति प्रसादं प्रकाशितवान्, तस्मादहं युष्मन्निमित्तं सर्व्वदा मदीयेश्वरं धन्यं वदामि। ");
INSERT INTO sandev_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","ख्रीष्टसम्बन्धीयं साक्ष्यं युष्माकं मध्ये येन प्रकारेण सप्रमाणम् अभवत् ");
INSERT INTO sandev_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","तेन यूयं ख्रीष्टात् सर्व्वविधवक्तृताज्ञानादीनि सर्व्वधनानि लब्धवन्तः। ");
INSERT INTO sandev_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","ततोऽस्मत्प्रभो र्यीशुख्रीष्टस्य पुनरागमनं प्रतीक्षमाणानां युष्माकं कस्यापि वरस्याभावो न भवति। ");
INSERT INTO sandev_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","अपरम् अस्माकं प्रभो र्यीशुख्रीष्टस्य दिवसे यूयं यन्निर्द्दोषा भवेत तदर्थं सएव यावदन्तं युष्मान् सुस्थिरान् करिष्यति। ");
INSERT INTO sandev_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","य ईश्वरः स्वपुत्रस्यास्मत्प्रभो र्यीशुख्रीष्टस्यांशिनः कर्त्तुं युष्मान् आहूतवान् स विश्वसनीयः। ");
INSERT INTO sandev_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","हे भ्रातरः, अस्माकं प्रभुयीशुख्रीष्टस्य नाम्ना युष्मान् विनयेऽहं सर्व्वै र्युष्माभिरेकरूपाणि वाक्यानि कथ्यन्तां युष्मन्मध्ये भिन्नसङ्घाता न भवन्तु मनोविचारयोरैक्येन युष्माकं सिद्धत्वं भवतु। ");
INSERT INTO sandev_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","हे मम भ्रातरो युष्मन्मध्ये विवादा जाता इति वार्त्तामहं क्लोय्याः परिजनै र्ज्ञापितः। ");
INSERT INTO sandev_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","ममाभिप्रेतमिदं युष्माकं कश्चित् कश्चिद् वदति पौलस्य शिष्योऽहम् आपल्लोः शिष्योऽहं कैफाः शिष्योऽहं ख्रीष्टस्य शिष्योऽहमिति च। ");
INSERT INTO sandev_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","ख्रीष्टस्य किं विभेदः कृतः? पौलः किं युष्मत्कृते क्रुशे हतः? पौलस्य नाम्ना वा यूयं किं मज्जिताः? ");
INSERT INTO sandev_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","क्रिष्पगायौ विना युष्माकं मध्येऽन्यः कोऽपि मया न मज्जित इति हेतोरहम् ईश्वरं धन्यं वदामि। ");
INSERT INTO sandev_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","एतेन मम नाम्ना मानवा मया मज्जिता इति वक्तुं केनापि न शक्यते। ");
INSERT INTO sandev_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","अपरं स्तिफानस्य परिजना मया मज्जितास्तदन्यः कश्चिद् यन्मया मज्जितस्तदहं न वेद्मि। ");
INSERT INTO sandev_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","ख्रीष्टेनाहं मज्जनार्थं न प्रेरितः किन्तु सुसंवादस्य प्रचारार्थमेव; सोऽपि वाक्पटुतया मया न प्रचारितव्यः, यतस्तथा प्रचारिते ख्रीष्टस्य क्रुशे मृत्युः फलहीनो भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","यतो हेतो र्ये विनश्यन्ति ते तां क्रुशस्य वार्त्तां प्रलापमिव मन्यन्ते किञ्च परित्राणं लभमानेष्वस्मासु सा ईश्वरीयशक्तिस्वरूपा। ");
INSERT INTO sandev_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","तस्मादित्थं लिखितमास्ते, ज्ञानवतान्तु यत् ज्ञानं तन्मया नाशयिष्यते। विलोपयिष्यते तद्वद् बुद्धि र्बद्धिमतां मया॥ ");
INSERT INTO sandev_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","ज्ञानी कुत्र? शास्त्री वा कुत्र? इहलोकस्य विचारतत्परो वा कुत्र? इहलोकस्य ज्ञानं किमीश्वरेण मोहीकृतं नहि? ");
INSERT INTO sandev_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","ईश्वरस्य ज्ञानाद् इहलोकस्य मानवाः स्वज्ञानेनेश्वरस्य तत्त्वबोधं न प्राप्तवन्तस्तस्माद् ईश्वरः प्रचाररूपिणा प्रलापेन विश्वासिनः परित्रातुं रोचितवान्। ");
INSERT INTO sandev_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","यिहूदीयलोका लक्षणानि दिदृक्षन्ति भिन्नदेशीयलोकास्तु विद्यां मृगयन्ते, ");
INSERT INTO sandev_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","वयञ्च क्रुशे हतं ख्रीष्टं प्रचारयामः। तस्य प्रचारो यिहूदीयै र्विघ्न इव भिन्नदेशीयैश्च प्रलाप इव मन्यते, ");
INSERT INTO sandev_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","किन्तु यिहूदीयानां भिन्नदेशीयानाञ्च मध्ये ये आहूतास्तेषु स ख्रीष्ट ईश्वरीयशक्तिरिवेश्वरीयज्ञानमिव च प्रकाशते। ");
INSERT INTO sandev_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","यत ईश्वरे यः प्रलाप आरोप्यते स मानवातिरिक्तं ज्ञानमेव यच्च दौर्ब्बल्यम् ईश्वर आरोप्यते तत् मानवातिरिक्तं बलमेव। ");
INSERT INTO sandev_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","हे भ्रातरः, आहूतयुष्मद्गणो यष्माभिरालोक्यतां तन्मध्ये सांसारिकज्ञानेन ज्ञानवन्तः पराक्रमिणो वा कुलीना वा बहवो न विद्यन्ते। ");
INSERT INTO sandev_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","यत ईश्वरो ज्ञानवतस्त्रपयितुं मूर्खलोकान् रोचितवान् बलानि च त्रपयितुम् ईश्वरो दुर्ब्बलान् रोचितवान्। ");
INSERT INTO sandev_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","तथा वर्त्तमानलोकान् संस्थितिभ्रष्टान् कर्त्तुम् ईश्वरो जगतोऽपकृष्टान् हेयान् अवर्त्तमानांश्चाभिरोचितवान्। ");
INSERT INTO sandev_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","तत ईश्वरस्य साक्षात् केनाप्यात्मश्लाघा न कर्त्तव्या। ");
INSERT INTO sandev_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","यूयञ्च तस्मात् ख्रीष्टे यीशौ संस्थितिं प्राप्तवन्तः स ईश्वराद् युष्माकं ज्ञानं पुण्यं पवित्रत्वं मुक्तिश्च जाता। ");
INSERT INTO sandev_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","अतएव यद्वद् लिखितमास्ते तद्वत्, यः कश्चित् श्लाघमानः स्यात् श्लाघतां प्रभुना स हि। ");
INSERT INTO sandev_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","हे भ्रातरो युष्मत्समीपे ममागमनकालेऽहं वक्तृताया विद्याया वा नैपुण्येनेश्वरस्य साक्ष्यं प्रचारितवान् तन्नहि; ");
INSERT INTO sandev_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","यतो यीशुख्रीष्टं तस्य क्रुशे हतत्वञ्च विना नान्यत् किमपि युष्मन्मध्ये ज्ञापयितुं विहितं बुद्धवान्। ");
INSERT INTO sandev_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","अपरञ्चातीव दौर्ब्बल्यभीतिकम्पयुक्तो युष्माभिः सार्द्धमासं। ");
INSERT INTO sandev_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","अपरं युष्माकं विश्वासो यत् मानुषिकज्ञानस्य फलं न भवेत् किन्त्वीश्वरीयशक्तेः फलं भवेत्, ");
INSERT INTO sandev_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","तदर्थं मम वक्तृता मदीयप्रचारश्च मानुषिकज्ञानस्य मधुरवाक्यसम्बलितौ नास्तां किन्त्वात्मनः शक्तेश्च प्रमाणयुक्तावास्तां। ");
INSERT INTO sandev_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","वयं ज्ञानं भाषामहे तच्च सिद्धलोकै र्ज्ञानमिव मन्यते, तदिहलोकस्य ज्ञानं नहि, इहलोकस्य नश्वराणाम् अधिपतीनां वा ज्ञानं नहि; ");
INSERT INTO sandev_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","किन्तु कालावस्थायाः पूर्व्वस्माद् यत् ज्ञानम् अस्माकं विभवार्थम् ईश्वरेण निश्चित्य प्रच्छन्नं तन्निगूढम् ईश्वरीयज्ञानं प्रभाषामहे। ");
INSERT INTO sandev_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","इहलोकस्याधिपतीनां केनापि तत् ज्ञानं न लब्धं, लब्धे सति ते प्रभावविशिष्टं प्रभुं क्रुशे नाहनिष्यन्। ");
INSERT INTO sandev_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","तद्वल्लिखितमास्ते, नेत्रेण क्कापि नो दृष्टं कर्णेनापि च न श्रुतं। मनोमध्ये तु कस्यापि न प्रविष्टं कदापि यत्। ईश्वरे प्रीयमाणानां कृते तत् तेन सञ्चितं। ");
INSERT INTO sandev_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","अपरमीश्वरः स्वात्मना तदस्माकं साक्षात् प्राकाशयत्; यत आत्मा सर्व्वमेवानुसन्धत्ते तेन चेश्वरस्य मर्म्मतत्त्वमपि बुध्यते। ");
INSERT INTO sandev_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","मनुजस्यान्तःस्थमात्मानं विना केन मनुजेन तस्य मनुजस्य तत्त्वं बुध्यते? तद्वदीश्वरस्यात्मानं विना केनापीश्वरस्य तत्त्वं न बुध्यते। ");
INSERT INTO sandev_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","वयञ्चेहलोकस्यात्मानं लब्धवन्तस्तन्नहि किन्त्वीश्वरस्यैवात्मानं लब्धवन्तः, ततो हेतोरीश्वरेण स्वप्रसादाद् अस्मभ्यं यद् यद् दत्तं तत्सर्व्वम् अस्माभि र्ज्ञातुं शक्यते। ");
INSERT INTO sandev_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","तच्चास्माभि र्मानुषिकज्ञानस्य वाक्यानि शिक्षित्वा कथ्यत इति नहि किन्त्वात्मतो वाक्यानि शिक्षित्वात्मिकै र्वाक्यैरात्मिकं भावं प्रकाशयद्भिः कथ्यते। ");
INSERT INTO sandev_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","प्राणी मनुष्य ईश्वरीयात्मनः शिक्षां न गृह्लाति यत आत्मिकविचारेण सा विचार्य्येति हेतोः स तां प्रलापमिव मन्यते बोद्धुञ्च न शक्नोति। ");
INSERT INTO sandev_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","आत्मिको मानवः सर्व्वाणि विचारयति किन्तु स्वयं केनापि न विचार्य्यते। ");
INSERT INTO sandev_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","यत ईश्वरस्य मनो ज्ञात्वा तमुपदेष्टुं कः शक्नोति? किन्तु ख्रीष्टस्य मनोऽस्माभि र्लब्धं। ");
INSERT INTO sandev_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","हे भ्रातरः, अहमात्मिकैरिव युष्माभिः समं सम्भाषितुं नाशक्नवं किन्तु शारीरिकाचारिभिः ख्रीष्टधर्म्मे शिशुतुल्यैश्च जनैरिव युष्माभिः सह समभाषे। ");
INSERT INTO sandev_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","युष्मान् कठिनभक्ष्यं न भोजयन् दुग्धम् अपाययं यतो यूयं भक्ष्यं ग्रहीतुं तदा नाशक्नुत इदानीमपि न शक्नुथ, यतो हेतोरधुनापि शारीरिकाचारिण आध्वे। ");
INSERT INTO sandev_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","युष्मन्मध्ये मात्सर्य्यविवादभेदा भवन्ति ततः किं शारीरिकाचारिणो नाध्वे मानुषिकमार्गेण च न चरथ? ");
INSERT INTO sandev_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","पौलस्याहमित्यापल्लोरहमिति वा यद्वाक्यं युष्माकं कैश्चित् कैश्चित् कथ्यते तस्माद् यूयं शारीरिकाचारिण न भवथ? ");
INSERT INTO sandev_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","पौलः कः? आपल्लो र्वा कः? तौ परिचारकमात्रौ तयोरेकैकस्मै च प्रभु र्यादृक् फलमददात् तद्वत् तयोर्द्वारा यूयं विश्वासिनो जाताः। ");
INSERT INTO sandev_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","अहं रोपितवान् आपल्लोश्च निषिक्तवान् ईश्वरश्चावर्द्धयत्। ");
INSERT INTO sandev_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","अतो रोपयितृसेक्तारावसारौ वर्द्धयितेश्वर एव सारः। ");
INSERT INTO sandev_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","रोपयितृसेक्तारौ च समौ तयोरेकैकश्च स्वश्रमयोग्यं स्ववेतनं लप्स्यते। ");
INSERT INTO sandev_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","आवामीश्वरेण सह कर्म्मकारिणौ, ईश्वरस्य यत् क्षेत्रम् ईश्वरस्य या निर्म्मितिः सा यूयमेव। ");
INSERT INTO sandev_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","ईश्वरस्य प्रसादात् मया यत् पदं लब्धं तस्मात् ज्ञानिना गृहकारिणेव मया भित्तिमूलं स्थापितं तदुपरि चान्येन निचीयते। किन्तु येन यन्निचीयते तत् तेन विविच्यतां। ");
INSERT INTO sandev_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","यतो यीशुख्रीष्टरूपं यद् भित्तिमूलं स्थापितं तदन्यत् किमपि भित्तिमूलं स्थापयितुं केनापि न शक्यते। ");
INSERT INTO sandev_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","एतद्भित्तिमूलस्योपरि यदि केचित् स्वर्णरूप्यमणिकाष्ठतृणनलान् निचिन्वन्ति, ");
INSERT INTO sandev_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","तर्ह्येकैकस्य कर्म्म प्रकाशिष्यते यतः स दिवसस्तत् प्रकाशयिष्यति। यतो हतोस्तन दिवसेन वह्निमयेनोदेतव्यं तत एकैकस्य कर्म्म कीदृशमेतस्य परीक्षा बह्निना भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","यस्य निचयनरूपं कर्म्म स्थास्नु भविष्यति स वेतनं लप्स्यते। ");
INSERT INTO sandev_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","यस्य च कर्म्म धक्ष्यते तस्य क्षति र्भविष्यति किन्तु वह्ने र्निर्गतजन इव स स्वयं परित्राणं प्राप्स्यति। ");
INSERT INTO sandev_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","यूयम् ईश्वरस्य मन्दिरं युष्मन्मध्ये चेश्वरस्यात्मा निवसतीति किं न जानीथ? ");
INSERT INTO sandev_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","ईश्वरस्य मन्दिरं येन विनाश्यते सोऽपीश्वरेण विनाशयिष्यते यत ईश्वरस्य मन्दिरं पवित्रमेव यूयं तु तन्मन्दिरम् आध्वे। ");
INSERT INTO sandev_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","कोपि स्वं न वञ्चयतां। युष्माकं कश्चन चेदिहलोकस्य ज्ञानेन ज्ञानवानहमिति बुध्यते तर्हि स यत् ज्ञानी भवेत् तदर्थं मूढो भवतु। ");
INSERT INTO sandev_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","यस्मादिहलोकस्य ज्ञानम् ईश्वरस्य साक्षात् मूढत्वमेव। एतस्मिन् लिखितमप्यास्ते, तीक्ष्णा या ज्ञानिनां बुद्धिस्तया तान् धरतीश्वरः। ");
INSERT INTO sandev_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","पुनश्च। ज्ञानिनां कल्पना वेत्ति परमेशो निरर्थकाः। ");
INSERT INTO sandev_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","अतएव कोऽपि मनुजैरात्मानं न श्लाघतां यतः सर्व्वाणि युष्माकमेव, ");
INSERT INTO sandev_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","पौल वा आपल्लो र्वा कैफा वा जगद् वा जीवनं वा मरणं वा वर्त्तमानं वा भविष्यद्वा सर्व्वाण्येव युष्माकं, ");
INSERT INTO sandev_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","यूयञ्च ख्रीष्टस्य, ख्रीष्टश्चेश्वरस्य। ");
INSERT INTO sandev_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","लोका अस्मान् ख्रीष्टस्य परिचारकान् ईश्वरस्य निगूठवाक्यधनस्याध्यक्षांश्च मन्यन्तां। ");
INSERT INTO sandev_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","किञ्च धनाध्यक्षेण विश्वसनीयेन भवितव्यमेतदेव लोकै र्याच्यते। ");
INSERT INTO sandev_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","अतो विचारयद्भि र्युष्माभिरन्यैः कैश्चिन् मनुजै र्वा मम परीक्षणं मयातीव लघु मन्यते ऽहमप्यात्मानं न विचारयामि। ");
INSERT INTO sandev_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","मया किमप्यपराद्धमित्यहं न वेद्मि किन्त्वेतेन मम निरपराधत्वं न निश्चीयते प्रभुरेव मम विचारयितास्ति। ");
INSERT INTO sandev_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","अत उपयुक्तसमयात् पूर्व्वम् अर्थतः प्रभोरागमनात् पूर्व्वं युष्माभि र्विचारो न क्रियतां। प्रभुरागत्य तिमिरेण प्रच्छन्नानि सर्व्वाणि दीपयिष्यति मनसां मन्त्रणाश्च प्रकाशयिष्यति तस्मिन् समय ईश्वराद् एकैकस्य प्रशंसा भविष्यति। ");
INSERT INTO sandev_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","हे भ्रातरः सर्व्वाण्येतानि मयात्मानम् आपल्लवञ्चोद्दिश्य कथितानि तस्यैतत् कारणं युयं यथा शास्त्रीयविधिमतिक्रम्य मानवम् अतीव नादरिष्यध्ब ईत्थञ्चैकेन वैपरीत्याद् अपरेण न श्लाघिष्यध्ब एतादृशीं शिक्षामावयोर्दृष्टान्तात् लप्स्यध्वे। ");
INSERT INTO sandev_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","अपरात् कस्त्वां विशेषयति? तुभ्यं यन्न दत्त तादृशं किं धारयसि? अदत्तेनेव दत्तेन वस्तुना कुतः श्लाघसे? ");
INSERT INTO sandev_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","इदानीमेव यूयं किं तृप्ता लब्धधना वा? अस्मास्वविद्यमानेषु यूयं किं राजत्वपदं प्राप्ताः? युष्माकं राजत्वं मयाभिलषितं यतस्तेन युष्माभिः सह वयमपि राज्यांशिनो भविष्यामः। ");
INSERT INTO sandev_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","प्रेरिता वयं शेषा हन्तव्याश्चेवेश्वरेण निदर्शिताः। यतो वयं सर्व्वलोकानाम् अर्थतः स्वर्गीयदूतानां मानवानाञ्च कौतुकास्पदानि जाताः। ");
INSERT INTO sandev_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","ख्रीष्टस्य कृते वयं मूढाः किन्तु यूयं ख्रीष्टेन ज्ञानिनः, वयं दुर्ब्बला यूयञ्च सबलाः, यूयं सम्मानिता वयञ्चापमानिताः। ");
INSERT INTO sandev_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","वयमद्यापि क्षुधार्त्तास्तृष्णार्त्ता वस्त्रहीनास्ताडिता आश्रमरहिताश्च सन्तः ");
INSERT INTO sandev_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","कर्म्मणि स्वकरान् व्यापारयन्तश्च दुःखैः कालं यापयामः। गर्हितैरस्माभिराशीः कथ्यते दूरीकृतैः सह्यते निन्दितैः प्रसाद्यते। ");
INSERT INTO sandev_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","वयमद्यापि जगतः सम्मार्जनीयोग्या अवकरा इव सर्व्वै र्मन्यामहे। ");
INSERT INTO sandev_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","युष्मान् त्रपयितुमहमेतानि लिखामीति नहि किन्तु प्रियात्मजानिव युष्मान् प्रबोधयामि। ");
INSERT INTO sandev_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","यतः ख्रीष्टधर्म्मे यद्यपि युष्माकं दशसहस्राणि विनेतारो भवन्ति तथापि बहवो जनका न भवन्ति यतोऽहमेव सुसंवादेन यीशुख्रीष्टे युष्मान् अजनयं। ");
INSERT INTO sandev_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","अतो युष्मान् विनयेऽहं यूयं मदनुगामिनो भवत। ");
INSERT INTO sandev_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","इत्यर्थं सर्व्वेषु धर्म्मसमाजेषु सर्व्वत्र ख्रीष्टधर्म्मयोग्या ये विधयो मयोपदिश्यन्ते तान् यो युष्मान् स्मारयिष्यत्येवम्भूतं प्रभोः कृते प्रियं विश्वासिनञ्च मदीयतनयं तीमथियं युष्माकं समीपं प्रेषितवानहं। ");
INSERT INTO sandev_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","अपरमहं युष्माकं समीपं न गमिष्यामीति बुद्ध्वा युष्माकं कियन्तो लोका गर्व्वन्ति। ");
INSERT INTO sandev_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","किन्तु यदि प्रभेरिच्छा भवति तर्ह्यहमविलम्बं युष्मत्समीपमुपस्थाय तेषां दर्पध्मातानां लोकानां वाचं ज्ञास्यामीति नहि सामर्थ्यमेव ज्ञास्यामि। ");
INSERT INTO sandev_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","यस्मादीश्वरस्य राजत्वं वाग्युक्तं नहि किन्तु सामर्थ्ययुक्तं। ");
INSERT INTO sandev_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","युष्माकं का वाञ्छा? युष्मत्समीपे मया किं दण्डपाणिना गन्तव्यमुत प्रेमनम्रतात्मयुक्तेन वा? ");
INSERT INTO sandev_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","अपरं युष्माकं मध्ये व्यभिचारो विद्यते स च व्यभिचारस्तादृशो यद् देवपूजकानां मध्येऽपि तत्तुल्यो न विद्यते फलतो युष्माकमेको जनो विमातृगमनं कृरुत इति वार्त्ता सर्व्वत्र व्याप्ता। ");
INSERT INTO sandev_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","तथाच यूयं दर्पध्माता आध्बे, तत् कर्म्म येन कृतं स यथा युष्मन्मध्याद् दूरीक्रियते तथा शोको युष्माभि र्न क्रियते किम् एतत्? ");
INSERT INTO sandev_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","अविद्यमाने मदीयशरीरे ममात्मा युष्मन्मध्ये विद्यते अतोऽहं विद्यमान इव तत्कर्म्मकारिणो विचारं निश्चितवान्, ");
INSERT INTO sandev_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","अस्मत्प्रभो र्यीशुख्रीष्टस्य नाम्ना युष्माकं मदीयात्मनश्च मिलने जाते ऽस्मत्प्रभो र्यीशुख्रीष्टस्य शक्तेः साहाय्येन ");
INSERT INTO sandev_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","स नरः शरीरनाशार्थमस्माभिः शयतानो हस्ते समर्पयितव्यस्ततोऽस्माकं प्रभो र्यीशो र्दिवसे तस्यात्मा रक्षां गन्तुं शक्ष्यति। ");
INSERT INTO sandev_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","युष्माकं दर्पो न भद्राय यूयं किमेतन्न जानीथ, यथा, विकारः कृत्स्नशक्तूनां स्वल्पकिण्वेन जायते। ");
INSERT INTO sandev_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","यूयं यत् नवीनशक्तुस्वरूपा भवेत तदर्थं पुरातनं किण्वम् अवमार्ज्जत यतो युष्माभिः किण्वशून्यै र्भवितव्यं। अपरम् अस्माकं निस्तारोत्सवीयमेषशावको यः ख्रीष्टः सोऽस्मदर्थं बलीकृतो ऽभवत्। ");
INSERT INTO sandev_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","अतः पुरातनकिण्वेनार्थतो दुष्टताजिघांसारूपेण किण्वेन तन्नहि किन्तु सारल्यसत्यत्वरूपया किण्वशून्यतयास्माभिरुत्सवः कर्त्तव्यः। ");
INSERT INTO sandev_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","व्याभिचारिणां संसर्गो युष्माभि र्विहातव्य इति मया पत्रे लिखितं। ");
INSERT INTO sandev_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","किन्त्वैहिकलोकानां मध्ये ये व्यभिचारिणो लोभिन उपद्राविणो देवपूजका वा तेषां संसर्गः सर्व्वथा विहातव्य इति नहि, विहातव्ये सति युष्माभि र्जगतो निर्गन्तव्यमेव। ");
INSERT INTO sandev_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","किन्तु भ्रातृत्वेन विख्यातः कश्चिज्जनो यदि व्यभिचारी लोभी देवपूजको निन्दको मद्यप उपद्रावी वा भवेत् तर्हि तादृशेन मानवेन सह भोजनपानेऽपि युष्माभि र्न कर्त्तव्ये इत्यधुना मया लिखितं। ");
INSERT INTO sandev_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","समाजबहिःस्थितानां लोकानां विचारकरणे मम कोऽधिकारः? किन्तु तदन्तर्गतानां विचारणं युष्माभिः किं न कर्त्तव्यं भवेत्? ");
INSERT INTO sandev_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","बहिःस्थानां तु विचार ईश्वरेण कारिष्यते। अतो युष्माभिः स पातकी स्वमध्याद् बहिष्क्रियतां। ");
INSERT INTO sandev_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","युष्माकमेकस्य जनस्यापरेण सह विवादे जाते स पवित्रलोकै र्विचारमकारयन् किम् अधार्म्मिकलोकै र्विचारयितुं प्रोत्सहते? ");
INSERT INTO sandev_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","जगतोऽपि विचारणं पवित्रलोकैः कारिष्यत एतद् यूयं किं न जानीथ? अतो जगद् यदि युष्माभि र्विचारयितव्यं तर्हि क्षुद्रतमविचारेषु यूयं किमसमर्थाः? ");
INSERT INTO sandev_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","दूता अप्यस्माभि र्विचारयिष्यन्त इति किं न जानीथ? अत ऐहिकविषयाः किम् अस्माभि र्न विचारयितव्या भवेयुः? ");
INSERT INTO sandev_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","ऐहिकविषयस्य विचारे युष्माभिः कर्त्तव्ये ये लोकाः समितौ क्षुद्रतमास्त एव नियुज्यन्तां। ");
INSERT INTO sandev_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","अहं युष्मान् त्रपयितुमिच्छन् वदामि यृष्मन्मध्ये किमेकोऽपि मनुष्यस्तादृग् बुद्धिमान्नहि यो भ्रातृविवादविचारणे समर्थः स्यात्? ");
INSERT INTO sandev_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","किञ्चैको भ्राता भ्रात्रान्येन किमविश्वासिनां विचारकाणां साक्षाद् विवदते? यष्मन्मध्ये विवादा विद्यन्त एतदपि युष्माकं दोषः। ");
INSERT INTO sandev_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","यूयं कुतोऽन्यायसहनं क्षतिसहनं वा श्रेयो न मन्यध्वे? ");
INSERT INTO sandev_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","किन्तु यूयमपि भ्रातृनेव प्रत्यन्यायं क्षतिञ्च कुरुथ किमेतत्? ");
INSERT INTO sandev_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","ईश्वरस्य राज्येऽन्यायकारिणां लोकानामधिकारो नास्त्येतद् यूयं किं न जानीथ? मा वञ्च्यध्वं, ये व्यभिचारिणो देवार्च्चिनः पारदारिकाः स्त्रीवदाचारिणः पुंमैथुनकारिणस्तस्करा ");
INSERT INTO sandev_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","लोभिनो मद्यपा निन्दका उपद्राविणो वा त ईश्वरस्य राज्यभागिनो न भविष्यन्ति। ");
INSERT INTO sandev_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","यूयञ्चैवंविधा लोका आस्त किन्तु प्रभो र्यीशो र्नाम्नास्मदीश्वरस्यात्मना च यूयं प्रक्षालिताः पाविताः सपुण्यीकृताश्च। ");
INSERT INTO sandev_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","मदर्थं सर्व्वं द्रव्यम् अप्रतिषिद्धं किन्तु न सर्व्वं हितजनकं।मदर्थं सर्व्वमप्रतिषिद्धं तथाप्यहं कस्यापि द्रव्यस्य वशीकृतो न भविष्यामि। ");
INSERT INTO sandev_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","उदराय भक्ष्याणि भक्ष्येभ्यश्चोदरं, किन्तु भक्ष्योदरे ईश्वरेण नाशयिष्येते; अपरं देहो न व्यभिचाराय किन्तु प्रभवे प्रभुश्च देहाय। ");
INSERT INTO sandev_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","यश्चेश्वरः प्रभुमुत्थापितवान् स स्वशक्त्यास्मानप्युत्थापयिष्यति। ");
INSERT INTO sandev_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","युष्माकं यानि शरीराणि तानि ख्रीष्टस्याङ्गानीति किं यूयं न जानीथ? अतः ख्रीष्टस्य यान्यङ्गानि तानि मयापहृत्य वेश्याया अङ्गानि किं कारिष्यन्ते? तन्न भवतु। ");
INSERT INTO sandev_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","यः कश्चिद् वेश्यायाम् आसज्यते स तया सहैकदेहो भवति किं यूयमेतन्न जानीथ? यतो लिखितमास्ते, यथा, तौ द्वौ जनावेकाङ्गौ भविष्यतः। ");
INSERT INTO sandev_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","मानवा यान्यन्यानि कलुषाणि कुर्व्वते तानि वपु र्न समाविशन्ति किन्तु व्यभिचारिणा स्वविग्रहस्य विरुद्धं कल्मषं क्रियते। ");
INSERT INTO sandev_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","मानवा यान्यन्यानि कलुषाणि कुर्व्वते तानि वपु र्न समाविशन्ति किन्तु व्यभिचारिणा स्वविग्रहस्य विरुद्धं कल्मषं क्रियते। ");
INSERT INTO sandev_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","युष्माकं यानि वपूंसि तानि युष्मदन्तःस्थितस्येश्वराल्लब्धस्य पवित्रस्यात्मनो मन्दिराणि यूयञ्च स्वेषां स्वामिनो नाध्वे किमेतद् युष्माभि र्न ज्ञायते? ");
INSERT INTO sandev_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","यूयं मूल्येन क्रीता अतो वपुर्मनोभ्याम् ईश्वरो युष्माभिः पूज्यतां यत ईश्वर एव तयोः स्वामी। ");
INSERT INTO sandev_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","अपरञ्च युष्माभि र्मां प्रति यत् पत्रमलेखि तस्योत्तरमेतत्, योषितोऽस्पर्शनं मनुजस्य वरं; ");
INSERT INTO sandev_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","किन्तु व्यभिचारभयाद् एकैकस्य पुंसः स्वकीयभार्य्या भवतु तद्वद् एकैकस्या योषितो ऽपि स्वकीयभर्त्ता भवतु। ");
INSERT INTO sandev_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","भार्य्यायै भर्त्रा यद्यद् वितरणीयं तद् वितीर्य्यतां तद्वद् भर्त्रेऽपि भार्य्यया वितरणीयं वितीर्य्यतां। ");
INSERT INTO sandev_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","भार्य्यायाः स्वदेहे स्वत्वं नास्ति भर्त्तुरेव, तद्वद् भर्त्तुरपि स्वदेहे स्वत्वं नास्ति भार्य्याया एव। ");
INSERT INTO sandev_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","उपोषणप्रार्थनयोः सेवनार्थम् एकमन्त्रणानां युष्माकं कियत्कालं यावद् या पृथक्स्थिति र्भवति तदन्यो विच्छेदो युष्मन्मध्ये न भवतु, ततः परम् इन्द्रियाणाम् अधैर्य्यात् शयतान् यद् युष्मान् परीक्षां न नयेत् तदर्थं पुनरेकत्र मिलत। ");
INSERT INTO sandev_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","एतद् आदेशतो नहि किन्त्वनुज्ञात एव मया कथ्यते, ");
INSERT INTO sandev_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","यतो ममावस्थेव सर्व्वमानवानामवस्था भवत्विति मम वाञ्छा किन्त्वीश्वराद् एकेनैको वरोऽन्येन चान्यो वर इत्थमेकैकेन स्वकीयवरो लब्धः। ");
INSERT INTO sandev_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","अपरम् अकृतविवाहान् विधवाश्च प्रति ममैतन्निवेदनं ममेव तेषामवस्थिति र्भद्रा; ");
INSERT INTO sandev_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","किञ्च यदि तैरिन्द्रियाणि नियन्तुं न शक्यन्ते तर्हि विवाहः क्रियतां यतः कामदहनाद् व्यूढत्वं भद्रं। ");
INSERT INTO sandev_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","ये च कृतविवाहास्ते मया नहि प्रभुनैवैतद् आज्ञाप्यन्ते। ");
INSERT INTO sandev_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","भार्य्या भर्त्तृतः पृथक् न भवतु। यदि वा पृथग्भूता स्यात् तर्हि निर्विवाहा तिष्ठतु स्वीयपतिना वा सन्दधातु भर्त्तापि भार्य्यां न त्यजतु। ");
INSERT INTO sandev_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","इतरान् जनान् प्रति प्रभु र्न ब्रवीति किन्त्वहं ब्रवीमि; कस्यचिद् भ्रातुर्योषिद् अविश्वासिनी सत्यपि यदि तेन सहवासे तुष्यति तर्हि सा तेन न त्यज्यतां। ");
INSERT INTO sandev_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","तद्वत् कस्याश्चिद् योषितः पतिरविश्वासी सन्नपि यदि तया सहवासे तुष्यति तर्हि स तया न त्यज्यतां। ");
INSERT INTO sandev_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","यतोऽविश्वासी भर्त्ता भार्य्यया पवित्रीभूतः, तद्वदविश्वासिनी भार्य्या भर्त्रा पवित्रीभूता; नोचेद् युष्माकमपत्यान्यशुचीन्यभविष्यन् किन्त्वधुना तानि पवित्राणि सन्ति। ");
INSERT INTO sandev_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","अविश्वासी जनो यदि वा पृथग् भवति तर्हि पृथग् भवतु; एतेन भ्राता भगिनी वा न निबध्यते तथापि वयमीश्वरेण शान्तये समाहूताः। ");
INSERT INTO sandev_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","हे नारि तव भर्त्तुः परित्राणं त्वत्तो भविष्यति न वेति त्वया किं ज्ञायते? हे नर तव जायायाः परित्राणं त्वत्तेा भविष्यति न वेति त्वया किं ज्ञायते? ");
INSERT INTO sandev_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","एकैको जनः परमेश्वराल्लब्धं यद् भजते यस्याञ्चावस्थायाम् ईश्वरेणाह्वायि तदनुसारेणैवाचरतु तदहं सर्व्वसमाजस्थान् आदिशामि। ");
INSERT INTO sandev_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","छिन्नत्वग् भृत्वा य आहूतः स प्रकृष्टत्वक् न भवतु, तद्वद् अछिन्नत्वग् भूत्वा य आहूतः स छिन्नत्वक् न भवतु। ");
INSERT INTO sandev_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","त्वक्छेदः सारो नहि तद्वदत्वक्छेदोऽपि सारो नहि किन्त्वीश्वरस्याज्ञानां पालनमेव। ");
INSERT INTO sandev_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","यो जनो यस्यामवस्थायामाह्वायि स तस्यामेवावतिष्ठतां। ");
INSERT INTO sandev_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","दासः सन् त्वं किमाहूतोऽसि? तन्मा चिन्तय, तथाच यदि स्वतन्त्रो भवितुं शक्नुयास्तर्हि तदेव वृणु। ");
INSERT INTO sandev_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","यतः प्रभुनाहूतो यो दासः स प्रभो र्मोचितजनः। तद्वद् तेनाहूतः स्वतन्त्रो जनोऽपि ख्रीष्टस्य दास एव। ");
INSERT INTO sandev_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","यूयं मूल्येन क्रीता अतो हेतो र्मानवानां दासा मा भवत। ");
INSERT INTO sandev_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","हे भ्रातरो यस्यामवस्थायां यस्याह्वानमभवत् तया स ईश्वरस्य साक्षात् तिष्ठतु। ");
INSERT INTO sandev_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","अपरम् अकृतविवाहान् जनान् प्रति प्रभोः कोऽप्यादेशो मया न लब्धः किन्तु प्रभोरनुकम्पया विश्वास्यो भूतोऽहं यद् भद्रं मन्ये तद् वदामि। ");
INSERT INTO sandev_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","वर्त्तमानात् क्लेशसमयात् मनुष्यस्यानूढत्वं भद्रमिति मया बुध्यते। ");
INSERT INTO sandev_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","त्वं किं योषिति निबद्धोऽसि तर्हि मोचनं प्राप्तुं मा यतस्व। किं वा योषितो मुक्तोऽसि? तर्हि जायां मा गवेषय। ");
INSERT INTO sandev_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","विवाहं कुर्व्वता त्वया किमपि नापाराध्यते तद्वद् व्यूह्यमानया युवत्यापि किमपि नापराध्यते तथाच तादृशौ द्वौ जनौ शारीरिकं क्लेशं लप्स्येते किन्तु युष्मान् प्रति मम करुणा विद्यते। ");
INSERT INTO sandev_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","हे भ्रातरोऽहमिदं ब्रवीमि, इतः परं समयोऽतीव संक्षिप्तः, ");
INSERT INTO sandev_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","अतः कृतदारैरकृतदारैरिव रुदद्भिश्चारुदद्भिरिव सानन्दैश्च निरानन्दैरिव क्रेतृभिश्चाभागिभिरिवाचरितव्यं ");
INSERT INTO sandev_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","ये च संसारे चरन्ति तै र्नातिचरितव्यं यत इहलेाकस्य कौतुको विचलति। ");
INSERT INTO sandev_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","किन्तु यूयं यन्निश्चिन्ता भवेतेति मम वाञ्छा। अकृतविवाहो जनो यथा प्रभुं परितोषयेत् तथा प्रभुं चिन्तयति, ");
INSERT INTO sandev_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","किन्तु कृतविवाहो जनो यथा भार्य्यां परितोषयेत् तथा संसारं चिन्तयति। ");
INSERT INTO sandev_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","तद्वद् ऊढयोषितो ऽनूढा विशिष्यते। यानूढा सा यथा कायमनसोः पवित्रा भवेत् तथा प्रभुं चिन्तयति या चोढा सा यथा भर्त्तारं परितोषयेत् तथा संसारं चिन्तयति। ");
INSERT INTO sandev_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","अहं यद् युष्मान् मृगबन्धिन्या परिक्षिपेयं तदर्थं नहि किन्तु यूयं यदनिन्दिता भूत्वा प्रभोः सेवनेऽबाधम् आसक्ता भवेत तदर्थमेतानि सर्व्वाणि युष्माकं हिताय मया कथ्यन्ते। ");
INSERT INTO sandev_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","कस्यचित् कन्यायां यौवनप्राप्तायां यदि स तस्या अनूढत्वं निन्दनीयं विवाहश्च साधयितव्य इति मन्यते तर्हि यथाभिलाषं करोतु, एतेन किमपि नापरात्स्यति विवाहः क्रियतां। ");
INSERT INTO sandev_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","किन्तु दुःखेनाक्लिष्टः कश्चित् पिता यदि स्थिरमनोगतः स्वमनोऽभिलाषसाधने समर्थश्च स्यात् मम कन्या मया रक्षितव्येति मनसि निश्चिनोति च तर्हि स भद्रं कर्म्म करोति। ");
INSERT INTO sandev_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","अतो यो विवाहं करोति स भद्रं कर्म्म करोति यश्च विवाहं न करोति स भद्रतरं कर्म्म करोति। ");
INSERT INTO sandev_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","यावत्कालं पति र्जीवति तावद् भार्य्या व्यवस्थया निबद्धा तिष्ठति किन्तु पत्यौ महानिद्रां गते सा मुक्तीभूय यमभिलषति तेन सह तस्या विवाहो भवितुं शक्नोति, किन्त्वेतत् केवलं प्रभुभक्तानां मध्ये। ");
INSERT INTO sandev_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","तथाच सा यदि निष्पतिका तिष्ठति तर्हि तस्याः क्षेमं भविष्यतीति मम भावः। अपरम् ईश्वरस्यात्मा ममाप्यन्त र्विद्यत इति मया बुध्यते। ");
INSERT INTO sandev_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","देवप्रसादे सर्व्वेषाम् अस्माकं ज्ञानमास्ते तद्वयं विद्मः। तथापि ज्ञानं गर्व्वं जनयति किन्तु प्रेमतो निष्ठा जायते। ");
INSERT INTO sandev_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","अतः कश्चन यदि मन्यते मम ज्ञानमास्त इति तर्हि तेन यादृशं ज्ञानं चेष्टितव्यं तादृशं किमपि ज्ञानमद्यापि न लब्धं। ");
INSERT INTO sandev_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","किन्तु य ईश्वरे प्रीयते स ईश्वरेणापि ज्ञायते। ");
INSERT INTO sandev_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","देवताबलिप्रसादभक्षणे वयमिदं विद्मो यत् जगन्मध्ये कोऽपि देवो न विद्यते, एकश्चेश्वरो द्वितीयो नास्तीति। ");
INSERT INTO sandev_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","स्वर्गे पृथिव्यां वा यद्यपि केषुचिद् ईश्वर इति नामारोप्यते तादृशाश्च बहव ईश्वरा बहवश्च प्रभवो विद्यन्ते ");
INSERT INTO sandev_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","तथाप्यस्माकमद्वितीय ईश्वरः स पिता यस्मात् सर्व्वेषां यदर्थञ्चास्माकं सृष्टि र्जाता, अस्माकञ्चाद्वितीयः प्रभुः स यीशुः ख्रीष्टो येन सर्व्ववस्तूनां येनास्माकमपि सृष्टिः कृता। ");
INSERT INTO sandev_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","अधिकन्तु ज्ञानं सर्व्वेषां नास्ति यतः केचिदद्यापि देवतां सम्मन्य देवप्रसादमिव तद् भक्ष्यं भुञ्जते तेन दुर्ब्बलतया तेषां स्वान्तानि मलीमसानि भवन्ति। ");
INSERT INTO sandev_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","किन्तु भक्ष्यद्रव्याद् वयम् ईश्वरेण ग्राह्या भवामस्तन्नहि यतो भुङ्क्त्वा वयमुत्कृष्टा न भवामस्तद्वदभुङ्क्त्वाप्यपकृष्टा न भवामः। ");
INSERT INTO sandev_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","अतो युष्माकं या क्षमता सा दुर्ब्बलानाम् उन्माथस्वरूपा यन्न भवेत् तदर्थं सावधाना भवत। ");
INSERT INTO sandev_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","यतो ज्ञानविशिष्टस्त्वं यदि देवालये उपविष्टः केनापि दृश्यसे तर्हि तस्य दुर्ब्बलस्य मनसि किं प्रसादभक्षण उत्साहो न जनिष्यते? ");
INSERT INTO sandev_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","तथा सति यस्य कृते ख्रीष्टो ममार तव स दुर्ब्बलो भ्राता तव ज्ञानात् किं न विनंक्ष्यति? ");
INSERT INTO sandev_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","इत्यनेन प्रकारेण भ्रातृणां विरुद्धम् अपराध्यद्भिस्तेषां दुर्ब्बलानि मनांसि व्याघातयद्भिश्च युष्माभिः ख्रीष्टस्य वैपरीत्येनापराध्यते। ");
INSERT INTO sandev_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","अतो हेतोः पिशिताशनं यदि मम भ्रातु र्विघ्नस्वरूपं भवेत् तर्ह्यहं यत् स्वभ्रातु र्विघ्नजनको न भवेयं तदर्थं यावज्जीवनं पिशितं न भोक्ष्ये। ");
INSERT INTO sandev_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","अहं किम् एकः प्रेरितो नास्मि? किमहं स्वतन्त्रो नास्मि? अस्माकं प्रभु र्यीशुः ख्रीष्टः किं मया नादर्शि? यूयमपि किं प्रभुना मदीयश्रमफलस्वरूपा न भवथ? ");
INSERT INTO sandev_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","अन्यलोकानां कृते यद्यप्यहं प्रेरितो न भवेयं तथाच युष्मत्कृते प्रेरितोऽस्मि यतः प्रभुना मम प्रेरितत्वपदस्य मुद्रास्वरूपा यूयमेवाध्वे। ");
INSERT INTO sandev_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","ये लोका मयि दोषमारोपयन्ति तान् प्रति मम प्रत्युत्तरमेतत्। ");
INSERT INTO sandev_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","भोजनपानयोः किमस्माकं क्षमता नास्ति? ");
INSERT INTO sandev_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","अन्ये प्रेरिताः प्रभो र्भ्रातरौ कैफाश्च यत् कुर्व्वन्ति तद्वत् काञ्चित् धर्म्मभगिनीं व्यूह्य तया सार्द्धं पर्य्यटितुं वयं किं न शक्नुमः? ");
INSERT INTO sandev_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","सांसारिकश्रमस्य परित्यागात् किं केवलमहं बर्णब्बाश्च निवारितौ? ");
INSERT INTO sandev_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","निजधनव्ययेन कः संग्रामं करोति? को वा द्राक्षाक्षेत्रं कृत्वा तत्फलानि न भुङ्क्ते? को वा पशुव्रजं पालयन् तत्पयो न पिवति? ");
INSERT INTO sandev_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","किमहं केवलां मानुषिकां वाचं वदामि? व्यवस्थायां किमेतादृशं वचनं न विद्यते? ");
INSERT INTO sandev_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","मूसाव्यवस्थाग्रन्थे लिखितमास्ते, त्वं शस्यमर्द्दकवृषस्यास्यं न भंत्स्यसीति। ईश्वरेण बलीवर्द्दानामेव चिन्ता किं क्रियते? ");
INSERT INTO sandev_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","किं वा सर्व्वथास्माकं कृते तद्वचनं तेनोक्तं? अस्माकमेव कृते तल्लिखितं। यः क्षेत्रं कर्षति तेन प्रत्याशायुक्तेन कर्ष्टव्यं, यश्च शस्यानि मर्द्दयति तेन लाभप्रत्याशायुक्तेन मर्द्दितव्यं। ");
INSERT INTO sandev_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","युष्मत्कृतेऽस्माभिः पारत्रिकाणि बीजानि रोपितानि, अतो युष्माकमैहिकफलानां वयम् अंशिनो भविष्यामः किमेतत् महत् कर्म्म? ");
INSERT INTO sandev_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","युष्मासु योऽधिकारस्तस्य भागिनो यद्यन्ये भवेयुस्तर्ह्यस्माभिस्ततोऽधिकं किं तस्य भागिभि र्न भवितव्यं? अधिकन्तु वयं तेनाधिकारेण न व्यवहृतवन्तः किन्तु ख्रीष्टीयसुसंवादस्य कोऽपि व्याघातोऽस्माभिर्यन्न जायेत तदर्थं सर्व्वं सहामहे। ");
INSERT INTO sandev_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","अपरं ये पवित्रवस्तूनां परिचर्य्यां कुर्व्वन्ति ते पवित्रवस्तुतो भक्ष्याणि लभन्ते, ये च वेद्याः परिचर्य्यां कुर्व्वन्ति ते वेदिस्थवस्तूनाम् अंशिनो भवन्त्येतद् यूयं किं न विद? ");
INSERT INTO sandev_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","तद्वद् ये सुसंवादं घोषयन्ति तैः सुसंवादेन जीवितव्यमिति प्रभुनादिष्टं। ");
INSERT INTO sandev_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","अहमेतेषां सर्व्वेषां किमपि नाश्रितवान् मां प्रति तदनुसारात् आचरितव्यमित्याशयेनापि पत्रमिदं मया न लिख्यते यतः केनापि जनेन मम यशसो मुधाकरणात् मम मरणं वरं। ");
INSERT INTO sandev_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","सुसंवादघेषणात् मम यशो न जायते यतस्तद्घोषणं ममावश्यकं यद्यहं सुसंवादं न घोषयेयं तर्हि मां धिक्। ");
INSERT INTO sandev_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","इच्छुकेन तत् कुर्व्वता मया फलं लप्स्यते किन्त्वनिच्छुकेऽपि मयि तत्कर्म्मणो भारोऽर्पितोऽस्ति। ");
INSERT INTO sandev_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","एतेन मया लभ्यं फलं किं? सुसंवादेन मम योऽधिकार आस्ते तं यदभद्रभावेन नाचरेयं तदर्थं सुसंवादघोषणसमये तस्य ख्रीष्टीयसुसंवादस्य निर्व्ययीकरणमेव मम फलं। ");
INSERT INTO sandev_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","सर्व्वेषाम् अनायत्तोऽहं यद् भूरिशो लोकान् प्रतिपद्ये तदर्थं सर्व्वेषां दासत्वमङ्गीकृतवान्। ");
INSERT INTO sandev_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","यिहूदीयान् यत् प्रतिपद्ये तदर्थं यिहूदीयानां कृते यिहूदीयइवाभवं। ये च व्यवस्थायत्तास्तान् यत् प्रतिपद्ये तदर्थं व्यवस्थानायत्तो योऽहं सोऽहं व्यवस्थायत्तानां कृते व्यवस्थायत्तइवाभवं। ");
INSERT INTO sandev_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","ये चालब्धव्यवस्थास्तान् यत् प्रतिपद्ये तदर्थम् ईश्वरस्य साक्षाद् अलब्धव्यवस्थो न भूत्वा ख्रीष्टेन लब्धव्यवस्थो योऽहं सोऽहम् अलब्धव्यवस्थानां कृतेऽलब्धव्यवस्थ इवाभवं। ");
INSERT INTO sandev_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","दुर्ब्बलान् यत् प्रतिपद्ये तदर्थमहं दुर्ब्बलानां कृते दुर्ब्बलइवाभवं। इत्थं केनापि प्रकारेण कतिपया लोका यन्मया परित्राणं प्राप्नुयुस्तदर्थं यो यादृश आसीत् तस्य कृते ऽहं तादृशइवाभवं। ");
INSERT INTO sandev_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","इदृश आचारः सुसंवादार्थं मया क्रियते यतोऽहं तस्य फलानां सहभागी भवितुमिच्छामि। ");
INSERT INTO sandev_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","पण्यलाभार्थं ये धावन्ति धावतां तेषां सर्व्वेषां केवल एकः पण्यं लभते युष्माभिः किमेतन्न ज्ञायते? अतो यूयं यथा पण्यं लप्स्यध्वे तथैव धावत। ");
INSERT INTO sandev_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","मल्ला अपि सर्व्वभोगे परिमितभोगिनो भवन्ति ते तु म्लानां स्रजं लिप्सन्ते किन्तु वयम् अम्लानां लिप्सामहे। ");
INSERT INTO sandev_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","तस्माद् अहमपि धावामि किन्तु लक्ष्यमनुद्दिश्य धावामि तन्नहि। अहं मल्लइव युध्यामि च किन्तु छायामाघातयन्निव युध्यामि तन्नहि। ");
INSERT INTO sandev_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","इतरान् प्रति सुसंवादं घोषयित्वाहं यत् स्वयमग्राह्यो न भवामि तदर्थं देहम् आहन्मि वशीकुर्व्वे च। ");
INSERT INTO sandev_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","हे भ्रातरः, अस्मत्पितृपुरुषानधि यूयं यदज्ञाता न तिष्ठतेति मम वाञ्छा, ते सर्व्वे मेघाधःस्थिता बभूवुः सर्व्वे समुद्रमध्येन वव्रजुः, ");
INSERT INTO sandev_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","सर्व्वे मूसामुद्दिश्य मेघसमुद्रयो र्मज्जिता बभूवुः ");
INSERT INTO sandev_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","सर्व्व एकम् आत्मिकं भक्ष्यं बुभुजिर एकम् आत्मिकं पेयं पपुश्च ");
INSERT INTO sandev_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","यतस्तेऽनुचरत आत्मिकाद् अचलात् लब्धं तोयं पपुः सोऽचलः ख्रीष्टएव। ");
INSERT INTO sandev_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","तथा सत्यपि तेषां मध्येऽधिकेषु लोकेष्वीश्वरो न सन्तुतोषेति हेतोस्ते प्रन्तरे निपातिताः। ");
INSERT INTO sandev_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","एतस्मिन् ते ऽस्माकं निदर्शनस्वरूपा बभूवुः; अतस्ते यथा कुत्सिताभिलाषिणो बभूवुरस्माभिस्तथा कुत्सिताभिलाषिभि र्न भवितव्यं। ");
INSERT INTO sandev_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","लिखितमास्ते, लोका भोक्तुं पातुञ्चोपविविशुस्ततः क्रीडितुमुत्थिता इतयनेन प्रकारेण तेषां कैश्चिद् यद्वद् देवपूजा कृता युष्माभिस्तद्वत् न क्रियतां। ");
INSERT INTO sandev_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","अपरं तेषां कैश्चिद् यद्वद् व्यभिचारः कृतस्तेन चैकस्मिन् दिने त्रयोविंशतिसहस्राणि लोका निपातितास्तद्वद् अस्माभि र्व्यभिचारो न कर्त्तव्यः। ");
INSERT INTO sandev_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","तेषां केचिद् यद्वत् ख्रीष्टं परीक्षितवन्तस्तस्माद् भुजङ्गै र्नष्टाश्च तद्वद् अस्माभिः ख्रीष्टो न परीक्षितव्यः। ");
INSERT INTO sandev_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","तेषां केचिद् यथा वाक्कलहं कृतवन्तस्तत्कारणात् हन्त्रा विनाशिताश्च युष्माभिस्तद्वद् वाक्कलहो न क्रियतां। ");
INSERT INTO sandev_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","तान् प्रति यान्येतानि जघटिरे तान्यस्माकं निदर्शनानि जगतः शेषयुगे वर्त्तमानानाम् अस्माकं शिक्षार्थं लिखितानि च बभूवुः। ");
INSERT INTO sandev_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","अतएव यः कश्चिद् सुस्थिरंमन्यः स यन्न पतेत् तत्र सावधानो भवतु। ");
INSERT INTO sandev_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","मानुषिकपरीक्षातिरिक्ता कापि परीक्षा युष्मान् नाक्रामत्, ईश्वरश्च विश्वास्यः सोऽतिशक्त्यां परीक्षायां पतनात् युष्मान् रक्षिष्यति, परीक्षा च यद् युष्माभिः सोढुं शक्यते तदर्थं तया सह निस्तारस्य पन्थानं निरूपयिष्यति। ");
INSERT INTO sandev_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","हे प्रियभ्रातरः, देवपूजातो दूरम् अपसरत। ");
INSERT INTO sandev_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","अहं युष्मान् विज्ञान् मत्वा प्रभाषे मया यत् कथ्यते तद् युष्माभि र्विविच्यतां। ");
INSERT INTO sandev_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","यद् धन्यवादपात्रम् अस्माभि र्धन्यं गद्यते तत् किं ख्रीष्टस्य शोणितस्य सहभागित्वं नहि? यश्च पूपोऽस्माभि र्भज्यते स किं ख्रीष्टस्य वपुषः सहभागित्वं नहि? ");
INSERT INTO sandev_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","वयं बहवः सन्तोऽप्येकपूपस्वरूपा एकवपुःस्वरूपाश्च भवामः, यतो वयं सर्व्व एकपूपस्य सहभागिनः। ");
INSERT INTO sandev_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","यूयं शारीरिकम् इस्रायेलीयवंशं निरीक्षध्वं। ये बलीनां मांसानि भुञ्जते ते किं यज्ञवेद्याः सहभागिनो न भवन्ति? ");
INSERT INTO sandev_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","इत्यनेन मया किं कथ्यते? देवता वास्तविकी देवतायै बलिदानं वा वास्तविकं किं भवेत्? ");
INSERT INTO sandev_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","तन्नहि किन्तु भिन्नजातिभि र्ये बलयो दीयन्ते त ईश्वराय तन्नहि भूतेभ्यएव दीयन्ते तस्माद् यूयं यद् भूतानां सहभागिनो भवथेत्यहं नाभिलषामि। ");
INSERT INTO sandev_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","प्रभोः कंसेन भूतानामपि कंसेन पानं युष्माभिरसाध्यं; यूयं प्रभो र्भोज्यस्य भूतानामपि भोज्यस्य सहभागिनो भवितुं न शक्नुथ। ");
INSERT INTO sandev_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","वयं किं प्रभुं स्पर्द्धिष्यामहे? वयं किं तस्माद् बलवन्तः? ");
INSERT INTO sandev_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","मां प्रति सर्व्वं कर्म्माप्रतिषिद्धं किन्तु न सर्व्वं हितजनकं सर्व्वम् अप्रतिषिद्धं किन्तु न सर्व्वं निष्ठाजनकं। ");
INSERT INTO sandev_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","आत्महितः केनापि न चेष्टितव्यः किन्तु सर्व्वैः परहितश्चेष्टितव्यः। ");
INSERT INTO sandev_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","आपणे यत् क्रय्यं तद् युष्माभिः संवेदस्यार्थं किमपि न पृष्ट्वा भुज्यतां ");
INSERT INTO sandev_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","यतः पृथिवी तन्मध्यस्थञ्च सर्व्वं परमेश्वरस्य। ");
INSERT INTO sandev_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","अपरम् अविश्वासिलोकानां केनचित् निमन्त्रिता यूयं यदि तत्र जिगमिषथ तर्हि तेन यद् यद् उपस्थाप्यते तद् युष्माभिः संवेदस्यार्थं किमपि न पृष्ट्वा भुज्यतां। ");
INSERT INTO sandev_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","किन्तु तत्र यदि कश्चिद् युष्मान् वदेत् भक्ष्यमेतद् देवतायाः प्रसाद इति तर्हि तस्य ज्ञापयितुरनुरोधात् संवेदस्यार्थञ्च तद् युष्माभि र्न भोक्तव्यं। पृथिवी तन्मध्यस्थञ्च सर्व्वं परमेश्वरस्य, ");
INSERT INTO sandev_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","सत्यमेतत्, किन्तु मया यः संवेदो निर्द्दिश्यते स तव नहि परस्यैव। ");
INSERT INTO sandev_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","अनुग्रहपात्रेण मया धन्यवादं कृत्वा यद् भुज्यते तत्कारणाद् अहं कुतो निन्दिष्ये? ");
INSERT INTO sandev_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","तस्माद् भोजनं पानम् अन्यद्वा कर्म्म कुर्व्वद्भि र्युष्माभिः सर्व्वमेवेश्वरस्य महिम्नः प्रकाशार्थं क्रियतां। ");
INSERT INTO sandev_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","यिहूदीयानां भिन्नजातीयानाम् ईश्वरस्य समाजस्य वा विघ्नजनकै र्युष्माभि र्न भवितव्यं। ");
INSERT INTO sandev_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","अहमप्यात्महितम् अचेष्टमानो बहूनां परित्राणार्थं तेषां हितं चेष्टमानः सर्व्वविषये सर्व्वेषां तुष्टिकरो भवामीत्यनेनाहं यद्वत् ख्रीष्टस्यानुगामी तद्वद् यूयं ममानुगामिनो भवत। ");
INSERT INTO sandev_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","हे भ्रातरः, यूयं सर्व्वस्मिन् कार्य्ये मां स्मरथ मया च यादृगुपदिष्टास्तादृगाचरथैतत्कारणात् मया प्रशंसनीया आध्बे। ");
INSERT INTO sandev_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","तथापि ममैषा वाञ्छा यद् यूयमिदम् अवगता भवथ, ");
INSERT INTO sandev_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","एकैकस्य पुरुषस्योत्तमाङ्गस्वरूपः ख्रीष्टः, योषितश्चोत्तमाङ्गस्वरूपः पुमान्, ख्रीष्टस्य चोत्तमाङ्गस्वरूप ईश्वरः। ");
INSERT INTO sandev_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","अपरम् आच्छादितोत्तमाङ्गेन येन पुंसा प्रार्थना क्रियत ईश्वरीयवाणी कथ्यते वा तेन स्वीयोत्तमाङ्गम् अवज्ञायते। ");
INSERT INTO sandev_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","अनाच्छादितोत्तमाङ्गया यया योषिता च प्रार्थना क्रियत ईश्वरीयवाणी कथ्यते वा तयापि स्वीयोत्तमाङ्गम् अवज्ञायते यतः सा मुण्डितशिरःसदृशा। ");
INSERT INTO sandev_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","अनाच्छादितमस्तका या योषित् तस्याः शिरः मुण्डनीयमेव किन्तु योषितः केशच्छेदनं शिरोमुण्डनं वा यदि लज्जाजनकं भवेत् तर्हि तया स्वशिर आच्छाद्यतां। ");
INSERT INTO sandev_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","पुमान् ईश्वरस्य प्रतिमूर्त्तिः प्रतितेजःस्वरूपश्च तस्मात् तेन शिरो नाच्छादनीयं किन्तु सीमन्तिनी पुंसः प्रतिबिम्बस्वरूपा। ");
INSERT INTO sandev_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","यतो योषातः पुमान् नोदपादि किन्तु पुंसो योषिद् उदपादि। ");
INSERT INTO sandev_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","अधिकन्तु योषितः कृते पुंसः सृष्टि र्न बभूव किन्तु पुंसः कृते योषितः सृष्टि र्बभूव। ");
INSERT INTO sandev_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","इति हेतो र्दूतानाम् आदराद् योषिता शिरस्यधीनतासूचकम् आवरणं धर्त्तव्यं। ");
INSERT INTO sandev_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","तथापि प्रभो र्विधिना पुमांसं विना योषिन्न जायते योषितञ्च विना पुमान् न जायते। ");
INSERT INTO sandev_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","यतो यथा पुंसो योषिद् उदपादि तथा योषितः पुमान् जायते, सर्व्ववस्तूनि चेश्वराद् उत्पद्यन्ते। ");
INSERT INTO sandev_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","युष्माभिरेवैतद् विविच्यतां, अनावृतया योषिता प्रार्थनं किं सुदृश्यं भवेत्? ");
INSERT INTO sandev_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","पुरुषस्य दीर्घकेशत्वं तस्य लज्जाजनकं, किन्तु योषितो दीर्घकेशत्वं तस्या गौरवजनकं ");
INSERT INTO sandev_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","यत आच्छादनाय तस्यै केशा दत्ता इति किं युष्माभिः स्वभावतो न शिक्ष्यते? ");
INSERT INTO sandev_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","अत्र यदि कश्चिद् विवदितुम् इच्छेत् तर्ह्यस्माकम् ईश्वरीयसमितीनाञ्च तादृशी रीति र्न विद्यते। ");
INSERT INTO sandev_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","युष्माभि र्न भद्राय किन्तु कुत्सिताय समागम्यते तस्माद् एतानि भाषमाणेन मया यूयं न प्रशंसनीयाः। ");
INSERT INTO sandev_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","प्रथमतः समितौ समागतानां युष्माकं मध्ये भेदाः सन्तीति वार्त्ता मया श्रूयते तन्मध्ये किञ्चित् सत्यं मन्यते च। ");
INSERT INTO sandev_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","यतो हेतो र्युष्मन्मध्ये ये परीक्षितास्ते यत् प्रकाश्यन्ते तदर्थं भेदै र्भवितव्यमेव। ");
INSERT INTO sandev_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","एकत्र समागतै र्युष्माभिः प्रभावं भेाज्यं भुज्यत इति नहि; ");
INSERT INTO sandev_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","यतो भोजनकाले युष्माकमेकैकेन स्वकीयं भक्ष्यं तूर्णं ग्रस्यते तस्माद् एको जनो बुभुक्षितस्तिष्ठति, अन्यश्च परितृप्तो भवति। ");
INSERT INTO sandev_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22"