﻿USE sofia;
DROP TABLE IF EXISTS sofia.sancol_vpl;
CREATE TABLE sancol_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sancol_vpl WRITE;
INSERT INTO sancol_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ibrAhImaH santAnO dAyUd tasya santAnO yIzukhrISTastasya pUrvvapuruSavaMzazrENI| ");
INSERT INTO sancol_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","ibrAhImaH putra ishAk tasya putrO yAkUb tasya putrO yihUdAstasya bhrAtarazca| ");
INSERT INTO sancol_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","tasmAd yihUdAtastAmarO garbhE pErassErahau jajnjAtE, tasya pErasaH putrO hiSrON tasya putrO 'rAm| ");
INSERT INTO sancol_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","tasya putrO 'mmInAdab tasya putrO nahazOn tasya putraH salmOn| ");
INSERT INTO sancol_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","tasmAd rAhabO garbhE bOyam jajnjE, tasmAd rUtO garbhE ObEd jajnjE, tasya putrO yizayaH| ");
INSERT INTO sancol_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","tasya putrO dAyUd rAjaH tasmAd mRtOriyasya jAyAyAM sulEmAn jajnjE| ");
INSERT INTO sancol_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","tasya putrO rihabiyAm, tasya putrO'biyaH, tasya putra AsA:| ");
INSERT INTO sancol_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","tasya sutO yihOzAphaT tasya sutO yihOrAma tasya suta uSiyaH| ");
INSERT INTO sancol_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","tasya sutO yOtham tasya suta Aham tasya sutO hiSkiyaH| ");
INSERT INTO sancol_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","tasya sutO minaziH, tasya suta AmOn tasya sutO yOziyaH| ");
INSERT INTO sancol_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","bAbilnagarE pravasanAt pUrvvaM sa yOziyO yikhaniyaM tasya bhrAtRMzca janayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","tatO bAbili pravasanakAlE yikhaniyaH zaltIyElaM janayAmAsa, tasya sutaH sirubbAvil| ");
INSERT INTO sancol_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","tasya sutO 'bOhud tasya suta ilIyAkIm tasya sutO'sOr| ");
INSERT INTO sancol_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","asOraH sutaH sAdOk tasya suta AkhIm tasya suta ilIhUd| ");
INSERT INTO sancol_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","tasya suta iliyAsar tasya sutO mattan| ");
INSERT INTO sancol_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","tasya sutO yAkUb tasya sutO yUSaph tasya jAyA mariyam; tasya garbhE yIzurajani, tamEva khrISTam (arthAd abhiSiktaM) vadanti| ");
INSERT INTO sancol_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ittham ibrAhImO dAyUdaM yAvat sAkalyEna caturdazapuruSAH; A dAyUdaH kAlAd bAbili pravasanakAlaM yAvat caturdazapuruSA bhavanti| bAbili pravAsanakAlAt khrISTasya kAlaM yAvat caturdazapuruSA bhavanti| ");
INSERT INTO sancol_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","yIzukhrISTasya janma kaththatE| mariyam nAmikA kanyA yUSaphE vAgdattAsIt, tadA tayOH saggamAt prAk sA kanyA  pavitrENAtmanA garbhavatI babhUva| ");
INSERT INTO sancol_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","tatra tasyAH pati ryUSaph saujanyAt tasyAH kalaggaM prakAzayitum anicchan gOpanEnE tAM pArityaktuM manazcakrE| ");
INSERT INTO sancol_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","sa tathaiva bhAvayati, tadAnIM paramEzvarasya dUtaH svapnE taM darzanaM dattvA vyAjahAra, hE dAyUdaH santAna yUSaph tvaM nijAM jAyAM mariyamam AdAtuM mA bhaiSIH| ");
INSERT INTO sancol_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","yatastasyA garbhaH pavitrAdAtmanO'bhavat, sA ca putraM prasaviSyatE, tadA tvaM tasya nAma yIzum (arthAt trAtAraM) karISyasE, yasmAt sa nijamanujAn tESAM kaluSEbhya uddhariSyati| ");
INSERT INTO sancol_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","itthaM sati, pazya garbhavatI kanyA tanayaM prasaviSyatE| immAnUyEl tadIyanjca nAmadhEyaM bhaviSyati|| immAnUyEl asmAkaM saggIzvara_ityarthaH| ");
INSERT INTO sancol_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","iti yad vacanaM purvvaM bhaviSyadvaktrA IzvaraH kathAyAmAsa, tat tadAnIM siddhamabhavat| ");
INSERT INTO sancol_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","anantaraM yUSaph nidrAtO jAgarita utthAya paramEzvarIyadUtasya nidEzAnusArENa nijAM jAyAM jagrAha, ");
INSERT INTO sancol_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","kintu yAvat sA nijaM prathamasutaM a suSuvE, tAvat tAM nOpAgacchat, tataH sutasya nAma yIzuM cakrE| ");
INSERT INTO sancol_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","anantaraM hErOd saMjnjakE rAjnji rAjyaM zAsati yihUdIyadEzasya baitlEhami nagarE yIzau jAtavati ca, katipayA jyOtirvvudaH pUrvvasyA dizO yirUzAlamnagaraM samEtya kathayamAsuH, ");
INSERT INTO sancol_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","yO yihUdIyAnAM rAjA jAtavAn, sa kutrAstE? vayaM pUrvvasyAM dizi tiSThantastadIyAM tArakAm apazyAma tasmAt taM praNantum aाgamAma| ");
INSERT INTO sancol_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","tadA hErOd rAjA kathAmEtAM nizamya yirUzAlamnagarasthitaiH sarvvamAnavaiH sArddham udvijya ");
INSERT INTO sancol_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","sarvvAn pradhAnayAjakAn adhyApakAMzca samAhUyAnIya papraccha, khrISTaH kutra janiSyatE? ");
INSERT INTO sancol_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","tadA tE kathayAmAsuH, yihUdIyadEzasya baitlEhami nagarE, yatO bhaviSyadvAdinA itthaM likhitamAstE, ");
INSERT INTO sancol_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","sarvvAbhyO rAjadhAnIbhyO yihUdIyasya nIvRtaH| hE yIhUdIyadEzasyE baitlEham tvaM na cAvarA|isrAyElIyalOkAn mE yatO yaH pAlayiSyati| tAdRgEkO mahArAjastvanmadhya udbhaviSyatI|| ");
INSERT INTO sancol_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","tadAnIM hErOd rAjA tAn jyOtirvvidO gOpanam AhUya sA tArakA kadA dRSTAbhavat , tad vinizcayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","aparaM tAn baitlEhamaM prahItya gaditavAn, yUyaM yAta, yatnAt taM zizum anviSya taduddEzE prAptE mahyaM vArttAM dAsyatha, tatO mayApi gatvA sa praNaMsyatE| ");
INSERT INTO sancol_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","tadAnIM rAjnja EtAdRzIm AjnjAM prApya tE pratasthirE, tataH pUrvvarsyAM dizi sthitaistai ryA tArakA dRSTA sA tArakA tESAmagrE gatvA yatra sthAnE zizUrAstE, tasya sthAnasyOpari sthagitA tasyau| ");
INSERT INTO sancol_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","tad dRSTvA tE mahAnanditA babhUvuH, ");
INSERT INTO sancol_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","tatO gEhamadhya pravizya tasya mAtrA mariyamA sAddhaM taM zizuM nirIkSaya daNPavad bhUtvA praNEmuH, aparaM svESAM ghanasampattiM mOcayitvA suvarNaM kunduruM gandharamanjca tasmai darzanIyaM dattavantaH| ");
INSERT INTO sancol_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","pazcAd hErOd rAjasya samIpaM punarapi gantuM svapna IzvarENa niSiddhAH santO 'nyEna pathA tE nijadEzaM prati pratasthirE| ");
INSERT INTO sancol_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","anantaraM tESu gatavatmu paramEzvarasya dUtO yUSaphE svapnE darzanaM datvA jagAda, tvam utthAya zizuM tanmAtaranjca gRhItvA misardEzaM palAyasva, aparaM yAvadahaM tubhyaM vArttAM na kathayiSyAmi, tAvat tatraiva nivasa, yatO rAjA hErOd zizuM nAzayituM mRgayiSyatE| ");
INSERT INTO sancol_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","tadAnIM yUSaph utthAya rajanyAM zizuM tanmAtaranjca gRhItvA misardEzaM prati pratasthE, ");
INSERT INTO sancol_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","gatvA ca hErOdO nRpatE rmaraNaparyyantaM tatra dEzE nyuvAsa, tEna misardEzAdahaM putraM svakIyaM samupAhUyam| yadEtadvacanam IzvarENa bhaviSyadvAdinA kathitaM tat saphalamabhUt| ");
INSERT INTO sancol_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","anantaraM hErOd jyOtirvidbhirAtmAnaM pravanjcitaM vijnjAya bhRzaM cukOpa; aparaM jyOtirvvidbhyastEna vinizcitaM yad dinaM taddinAd gaNayitvA dvitIyavatsaraM praviSTA yAvantO bAlakA asmin baitlEhamnagarE tatsImamadhyE cAsan, lOkAn prahitya tAn sarvvAn ghAtayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ataH anEkasya vilApasya ninAda: krandanasya ca| zOkEna kRtazabdazca rAmAyAM saMnizamyatE| svabAlagaNahEtOrvai rAhEl nArI tu rOdinI| na manyatE prabOdhantu yatastE naiva manti hi|| ");
INSERT INTO sancol_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","yadEtad vacanaM yirImiyanAmakabhaviSyadvAdinA kathitaM tat tadAnIM saphalam abhUt| ");
INSERT INTO sancol_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","tadanantaraM hErEdi rAjani mRtE paramEzvarasya dUtO misardEzE svapnE darzanaM dattvA yUSaphE kathitavAn ");
INSERT INTO sancol_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","tvam utthAya zizuM tanmAtaranjca gRhItvA punarapIsrAyElO dEzaM yAhI, yE janAH zizuM nAzayitum amRgayanta, tE mRtavantaH| ");
INSERT INTO sancol_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","tadAnIM sa utthAya zizuM tanmAtaranjca gRhlan isrAyEldEzam AjagAma| ");
INSERT INTO sancol_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","kintu yihUdIyadEzE arkhilAyanAma rAjakumArO nijapitu rhErOdaH padaM prApya rAjatvaM karOtIti nizamya tat sthAnaM yAtuM zagkitavAn, pazcAt svapna IzvarAt prabOdhaM prApya gAlIldEzasya pradEzaikaM prasthAya nAsarannAma nagaraM gatvA tatra nyuSitavAn, ");
INSERT INTO sancol_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","tEna taM nAsaratIyaM kathayiSyanti, yadEtadvAkyaM bhaviSyadvAdibhirukttaM tat saphalamabhavat| ");
INSERT INTO sancol_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","tadAnOM yOhnnAmA majjayitA yihUdIyadEzasya prAntaram upasthAya pracArayan kathayAmAsa, ");
INSERT INTO sancol_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","manAMsi parAvarttayata, svargIyarAjatvaM samIpamAgatam| ");
INSERT INTO sancol_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","paramEzasya panthAnaM pariSkuruta sarvvataH| tasya rAjapathAMzcaiva samIkuruta sarvvathA| ityEtat prAntarE vAkyaM vadataH kasyacid ravaH|| ");
INSERT INTO sancol_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","EtadvacanaM yizayiyabhaviSyadvAdinA yOhanamuddizya bhASitam| yOhanO vasanaM mahAggarOmajaM tasya kaTau carmmakaTibandhanaM; sa ca zUkakITAn madhu ca bhuktavAn| ");
INSERT INTO sancol_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","tadAnIM yirUzAlamnagaranivAsinaH sarvvE yihUdidEzIyA yarddantaTinyA ubhayataTasthAzca mAnavA bahirAgatya tasya samIpE ");
INSERT INTO sancol_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","svIyaM svIyaM duritam aggIkRtya tasyAM yarddani tEna majjitA babhUvuH| ");
INSERT INTO sancol_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","aparaM bahUn phirUzinaH sidUkinazca manujAn maMktuM svasamIpam AgacchtO vilOkya sa tAn abhidadhau, rE rE bhujagavaMzA AgAmInaH kOpAt palAyituM yuSmAn kazcEtitavAn? ");
INSERT INTO sancol_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","manaHparAvarttanasya samucitaM phalaM phalata| ");
INSERT INTO sancol_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","kintvasmAkaM tAta ibrAhIm astIti svESu manaHsu cIntayantO mA vyAharata| yatO yuSmAn ahaM vadAmi, Izvara EtEbhyaH pASANEbhya ibrAhImaH santAnAn utpAdayituM zaknOti| ");
INSERT INTO sancol_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","aparaM pAdapAnAM mUlE kuThAra idAnImapi lagan AstE, tasmAd yasmin pAdapE uttamaM phalaM na bhavati, sa kRttO madhyE'gniM nikSEpsyatE| ");
INSERT INTO sancol_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","aparam ahaM manaHparAvarttanasUcakEna majjanEna yuSmAn majjayAmIti satyaM, kintu mama pazcAd ya Agacchati, sa mattOpi mahAn, ahaM tadIyOpAnahau vOPhumapi nahi yOgyOsmi, sa yuSmAn vahnirUpE pavitra Atmani saMmajjayiSyati| ");
INSERT INTO sancol_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","tasya kArE sUrpa AstE, sa svIyazasyAni samyak prasphOTya nijAn sakalagOdhUmAn saMgRhya bhANPAgArE sthApayiSyati, kiMntu sarvvANi vuSANyanirvvANavahninA dAhayiSyati| ");
INSERT INTO sancol_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","anantaraM yIzu ryOhanA majjitO bhavituM gAlIlpradEzAd yarddani tasya samIpam AjagAma| ");
INSERT INTO sancol_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","kintu yOhan taM niSidhya babhASE, tvaM kiM mama samIpam Agacchasi? varaM tvayA majjanaM mama prayOjanam AstE| ");
INSERT INTO sancol_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","tadAnIM yIzuH pratyavOcat; IdAnIm anumanyasva, yata itthaM sarvvadharmmasAdhanam asmAkaM karttavyaM, tataH sO'nvamanyata| ");
INSERT INTO sancol_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","anantaraM yIzurammasi majjituH san tatkSaNAt tOyamadhyAd utthAya jagAma, tadA jImUtadvArE muktE jAtE, sa IzvarasyAtmAnaM kapOtavad avaruhya svOparyyAgacchantaM vIkSAnjcakrE| ");
INSERT INTO sancol_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","aparam ESa mama priyaH putra EtasminnEva mama mahAsantOSa EtAdRzI vyOmajA vAg babhUva| ");
INSERT INTO sancol_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","tataH paraM yIzuH pratArakENa parIkSitO bhavitum AtmanA prAntaram AkRSTaH ");
INSERT INTO sancol_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","san catvAriMzadahOrAtrAn anAhArastiSThan kSudhitO babhUva| ");
INSERT INTO sancol_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","tadAnIM parIkSitA tatsamIpam Agatya vyAhRtavAn, yadi tvamIzvarAtmajO bhavEstarhyAjnjayA pASANAnEtAn pUpAn vidhEhi| ");
INSERT INTO sancol_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","tataH sa pratyabravIt, itthaM likhitamAstE, \"manujaH kEvalapUpEna na jIviSyati, kintvIzvarasya vadanAd yAni yAni vacAMsi niHsaranti tairEva jIviSyati|\" ");
INSERT INTO sancol_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","tadA pratArakastaM puNyanagaraM nItvA mandirasya cUPOpari nidhAya gaditavAn, ");
INSERT INTO sancol_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","tvaM yadizvarasya tanayO bhavEstarhItO'dhaH pata, yata itthaM likhitamAstE, AdEkSyati nijAn dUtAn rakSituM tvAM paramEzvaraH| yathA sarvvESu mArgESu tvadIyacaraNadvayE| na lagEt prastarAghAtastvAM ghariSyanti tE karaiH|| ");
INSERT INTO sancol_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","tadAnIM yIzustasmai kathitavAn Etadapi likhitamAstE, \"tvaM nijaprabhuM paramEzvaraM mA parIkSasva|\" ");
INSERT INTO sancol_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","anantaraM pratArakaH punarapi tam atyunjcadharAdharOpari nItvA jagataH sakalarAjyAni tadaizvaryyANi ca darzayAzcakAra kathayAnjcakAra ca, ");
INSERT INTO sancol_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","yadi tvaM daNPavad bhavan mAM praNamEstarhyaham EtAni tubhyaM pradAsyAmi| ");
INSERT INTO sancol_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","tadAnIM yIzustamavOcat, dUrIbhava pratAraka, likhitamidam AstE, \"tvayA nijaH prabhuH paramEzvaraH praNamyaH kEvalaH sa sEvyazca|\" ");
INSERT INTO sancol_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","tataH pratArakENa sa paryyatyAji, tadA svargIyadUtairAgatya sa siSEvE| ");
INSERT INTO sancol_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","tadanantaraM yOhan kArAyAM babandhE, tadvArttAM nizamya yIzunA gAlIl prAsthIyata| ");
INSERT INTO sancol_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","tataH paraM sa nAsarannagaraM vihAya jalaghEstaTE sibUlUnnaptAlI EtayOruvabhayOH pradEzayOH sImnOrmadhyavarttI ya: kapharnAhUm tannagaram itvA nyavasat| ");
INSERT INTO sancol_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","tasmAt, anyAdEzIyagAlIli yarddanpArE'bdhirOdhasi| naptAlisibUlUndEzau yatra sthAnE sthitau purA| ");
INSERT INTO sancol_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","tatratyA manujA yE yE paryyabhrAmyan tamisrakE| tairjanairbRhadAlOkaH paridarziSyatE tadA| avasan yE janA dEzE mRtyucchAyAsvarUpakE| tESAmupari lOkAnAmAlOkaH saMprakAzitaH|| ");
INSERT INTO sancol_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","yadEtadvacanaM yizayiyabhaviSyadvAdinA prOktaM, tat tadA saphalam abhUt| ");
INSERT INTO sancol_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","anantaraM yIzuH susaMvAdaM pracArayan EtAM kathAM kathayitum ArEbhE, manAMsi parAvarttayata, svargIyarAjatvaM savidhamabhavat| ");
INSERT INTO sancol_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","tataH paraM yIzu rgAlIlO jaladhEstaTEna gacchan gacchan Andriyastasya bhrAtA zimOn arthatO yaM pitaraM vadanti EtAvubhau jalaghau jAlaM kSipantau dadarza, yatastau mInadhAriNAvAstAm| ");
INSERT INTO sancol_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","tadA sa tAvAhUya vyAjahAra, yuvAM mama pazcAd AgacchataM, yuvAmahaM manujadhAriNau kariSyAmi| ");
INSERT INTO sancol_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","tEnaiva tau jAlaM vihAya tasya pazcAt AgacchatAm| ");
INSERT INTO sancol_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","anantaraM tasmAt sthAnAt vrajan vrajan sivadiyasya sutau yAkUb yOhannAmAnau dvau sahajau tAtEna sArddhaM naukOpari jAlasya jIrNOddhAraM kurvvantau vIkSya tAvAhUtavAn| ");
INSERT INTO sancol_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","tatkSaNAt tau nAvaM svatAtanjca vihAya tasya pazcAdgAminau babhUvatuH| ");
INSERT INTO sancol_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","anantaraM bhajanabhavanE samupadizan rAjyasya susaMvAdaM pracArayan manujAnAM sarvvaprakArAn rOgAn sarvvaprakArapIPAzca zamayan yIzuH kRtsnaM gAlIldEzaM bhramitum Arabhata| ");
INSERT INTO sancol_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","tEna kRtsnasuriyAdEzasya madhyaM tasya yazO vyApnOt, aparaM bhUtagrastA apasmArargINaH pakSAdhAtiprabhRtayazca yAvantO manujA nAnAvidhavyAdhibhiH kliSTA Asan, tESu sarvvESu tasya samIpam AnItESu sa tAn svasthAn cakAra| ");
INSERT INTO sancol_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","EtEna gAlIl-dikApani-yirUzAlam-yihUdIyadEzEbhyO yarddanaH pArAnjca bahavO manujAstasya pazcAd Agacchan| ");
INSERT INTO sancol_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","anantaraM sa jananivahaM nirIkSya bhUdharOpari vrajitvA samupavivEza| ");
INSERT INTO sancol_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","tadAnIM ziSyESu tasya samIpamAgatESu tEna tEbhya ESA kathA kathyAnjcakrE| ");
INSERT INTO sancol_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","abhimAnahInA janA dhanyAH, yatastE svargIyarAjyam adhikariSyanti| ");
INSERT INTO sancol_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","khidyamAnA manujA dhanyAH, yasmAt tE sAntvanAM prApsanti| ");
INSERT INTO sancol_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","namrA mAnavAzca dhanyAH, yasmAt tE mEdinIm adhikariSyanti| ");
INSERT INTO sancol_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","dharmmAya bubhukSitAH tRSArttAzca manujA dhanyAH, yasmAt tE paritarpsyanti| ");
INSERT INTO sancol_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","kRpAlavO mAnavA dhanyAH, yasmAt tE kRpAM prApsyanti| ");
INSERT INTO sancol_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","nirmmalahRdayA manujAzca dhanyAH, yasmAt ta IzcaraM drakSyanti| ");
INSERT INTO sancol_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","mElayitArO mAnavA dhanyAH, yasmAt ta Izcarasya santAnatvEna vikhyAsyanti| ");
INSERT INTO sancol_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","dharmmakAraNAt tAPitA manujA dhanyA, yasmAt svargIyarAjyE tESAmadhikarO vidyatE| ");
INSERT INTO sancol_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","yadA manujA mama nAmakRtE yuSmAn nindanti tAPayanti mRSA nAnAdurvvAkyAni vadanti ca, tadA yuyaM dhanyAH| ");
INSERT INTO sancol_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","tadA Anandata, tathA bhRzaM hlAdadhvanjca, yataH svargE bhUyAMsi phalAni lapsyadhvE; tE yuSmAkaM purAtanAn bhaviSyadvAdinO'pi tAdRg atAPayan| ");
INSERT INTO sancol_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","yuyaM mEdinyAM lavaNarUpAH, kintu yadi lavaNasya lavaNatvam apayAti, tarhi tat kEna prakArENa svAduyuktaM bhaviSyati? tat kasyApi kAryyasyAyOgyatvAt kEvalaM bahiH prakSEptuM narANAM padatalEna dalayitunjca yOgyaM bhavati| ");
INSERT INTO sancol_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","yUyaM jagati dIptirUpAH, bhUdharOpari sthitaM nagaraM guptaM bhavituM nahi zakSyati| ");
INSERT INTO sancol_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","aparaM manujAH pradIpAn prajvAlya drONAdhO na sthApayanti, kintu dIpAdhArOparyyEva sthApayanti, tEna tE dIpA gEhasthitAn sakalAn prakAzayanti| ");
INSERT INTO sancol_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","yEna mAnavA yuSmAkaM satkarmmANi vilOkya yuSmAkaM svargasthaM pitaraM dhanyaM vadanti, tESAM samakSaM yuSmAkaM dIptistAdRk prakAzatAm| ");
INSERT INTO sancol_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","ahaM vyavasthAM bhaviSyadvAkyanjca lOptum AgatavAn, itthaM mAnubhavata, tE dvE lOptuM nAgatavAn, kintu saphalE karttum AgatOsmi| ");
INSERT INTO sancol_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","aparaM yuSmAn ahaM tathyaM vadAmi yAvat vyOmamEdinyO rdhvaMsO na bhaviSyati, tAvat sarvvasmin saphalE na jAtE vyavasthAyA EkA mAtrA bindurEkOpi vA na lOpsyatE| ");
INSERT INTO sancol_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","tasmAt yO jana EtAsAm AjnjAnAm atikSudrAm EkAjnjAmapI laMghatE manujAMnjca tathaiva zikSayati, sa svargIyarAjyE sarvvEbhyaH kSudratvEna vikhyAsyatE, kintu yO janastAM pAlayati, tathaiva zikSayati ca, sa svargIyarAjyE pradhAnatvEna vikhyAsyatE| ");
INSERT INTO sancol_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","aparaM yuSmAn ahaM vadAmi, adhyApakaphirUzimAnavAnAM dharmmAnuSThAnAt yuSmAkaM dharmmAnuSThAnE nOttamE jAtE yUyam IzvarIyarAjyaM pravESTuM na zakSyatha| ");
INSERT INTO sancol_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","aparanjca tvaM naraM mA vadhIH, yasmAt yO naraM hanti, sa vicArasabhAyAM daNPArhO bhaviSyati, pUrvvakAlInajanEbhya iti kathitamAsIt, yuSmAbhirazrAvi| ");
INSERT INTO sancol_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","kintvahaM yuSmAn vadAmi, yaH kazcit kAraNaM vinA nijabhrAtrE kupyati, sa vicArasabhAyAM daNPArhO bhaviSyati; yaH kazcicca svIyasahajaM nirbbOdhaM vadati, sa mahAsabhAyAM daNPArhO bhaviSyati; punazca tvaM mUPha iti vAkyaM yadi kazcit svIyabhrAtaraM vakti, tarhi narakAgnau sa daNPArhO bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","atO vEdyAH samIpaM nijanaivEdyE samAnItE'pi nijabhrAtaraM prati kasmAccit kAraNAt tvaM yadi dOSI vidyasE, tadAnIM tava tasya smRti rjAyatE ca, ");
INSERT INTO sancol_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","tarhi tasyA vEdyAH samIpE nijanaivaidyaM nidhAya tadaiva gatvA pUrvvaM tEna sArddhaM mila, pazcAt Agatya nijanaivEdyaM nivEdaya| ");
INSERT INTO sancol_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","anyanjca yAvat vivAdinA sArddhaM vartmani tiSThasi, tAvat tEna sArddhaM mElanaM kuru; nO cEt vivAdI vicArayituH samIpE tvAM samarpayati vicArayitA ca rakSiNaH sannidhau samarpayati tadA tvaM kArAyAM badhyEthAH| ");
INSERT INTO sancol_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","tarhi tvAmahaM taththaM bravImi, zESakapardakE'pi na parizOdhitE tasmAt sthAnAt kadApi bahirAgantuM na zakSyasi| ");
INSERT INTO sancol_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","aparaM tvaM mA vyabhicara, yadEtad vacanaM pUrvvakAlInalOkEbhyaH kathitamAsIt, tad yUyaM zrutavantaH; ");
INSERT INTO sancol_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","kintvahaM yuSmAn vadAmi, yadi kazcit kAmataH kAnjcana yOSitaM pazyati, tarhi sa manasA tadaiva vyabhicaritavAn| ");
INSERT INTO sancol_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","tasmAt tava dakSiNaM nEtraM yadi tvAM bAdhatE, tarhi tannEtram utpATya dUrE nikSipa, yasmAt tava sarvvavapuSO narakE nikSEpAt tavaikAggasya nAzO varaM| ");
INSERT INTO sancol_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","yadvA tava dakSiNaH karO yadi tvAM bAdhatE, tarhi taM karaM chittvA dUrE nikSipa, yataH sarvvavapuSO narakE nikSEpAt EkAggasya nAzO varaM| ");
INSERT INTO sancol_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","uktamAstE, yadi kazcin nijajAyAM parityakttum icchati, tarhi sa tasyai tyAgapatraM dadAtu| ");
INSERT INTO sancol_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","kintvahaM yuSmAn vyAharAmi, vyabhicAradOSE na jAtE yadi kazcin nijajAyAM parityajati, tarhi sa tAM vyabhicArayati; yazca tAM tyaktAM striyaM vivahati, sOpi vyabhicarati| ");
INSERT INTO sancol_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","punazca tvaM mRSA zapatham na kurvvan IzcarAya nijazapathaM pAlaya, pUrvvakAlInalOkEbhyO yaiSA kathA kathitA, tAmapi yUyaM zrutavantaH| ");
INSERT INTO sancol_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","kintvahaM yuSmAn vadAmi, kamapi zapathaM mA kArSTa, arthataH svarganAmnA na, yataH sa Izvarasya siMhAsanaM; ");
INSERT INTO sancol_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","pRthivyA nAmnApi na, yataH sA tasya pAdapIThaM; yirUzAlamO nAmnApi na, yataH sA mahArAjasya purI; ");
INSERT INTO sancol_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","nijazirOnAmnApi na, yasmAt tasyaikaM kacamapi sitam asitaM vA karttuM tvayA na zakyatE| ");
INSERT INTO sancol_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","aparaM yUyaM saMlApasamayE kEvalaM bhavatIti na bhavatIti ca vadata yata itO'dhikaM yat tat pApAtmanO jAyatE| ");
INSERT INTO sancol_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","aparaM lOcanasya vinimayEna lOcanaM dantasya vinimayEna dantaH pUrvvaktamidaM vacananjca yuSmAbhirazrUyata| ");
INSERT INTO sancol_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","kintvahaM yuSmAn vadAmi yUyaM hiMsakaM naraM mA vyAghAtayata| kintu kEnacit tava dakSiNakapOlE capETAghAtE kRtE taM prati vAmaM kapOlanjca vyAghOTaya| ");
INSERT INTO sancol_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","aparaM kEnacit tvayA sArdhdaM vivAdaM kRtvA tava paridhEyavasanE jighRtitE tasmAyuttarIyavasanamapi dEhi| ");
INSERT INTO sancol_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","yadi kazcit tvAM krOzamEkaM nayanArthaM anyAyatO dharati, tadA tEna sArdhdaM krOzadvayaM yAhi| ");
INSERT INTO sancol_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","yazca mAnavastvAM yAcatE, tasmai dEhi, yadi kazcit tubhyaM dhArayitum icchati, tarhi taM prati parAMmukhO mA bhUH| ");
INSERT INTO sancol_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","nijasamIpavasini prEma kuru, kintu zatruM prati dvESaM kuru, yadEtat purOktaM vacanaM Etadapi yUyaM zrutavantaH| ");
INSERT INTO sancol_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","kintvahaM yuSmAn vadAmi, yUyaM ripuvvapi prEma kuruta, yE ca yuSmAn zapantE, tAna, AziSaM vadata, yE ca yuSmAn RृtIyantE, tESAM maggalaM kuruta, yE ca yuSmAn nindanti, tAPayanti ca, tESAM kRtE prArthayadhvaM| ");
INSERT INTO sancol_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","tatra yaH satAmasatAnjcOpari prabhAkaram udAyayati, tathA dhArmmikAnAmadhArmmikAnAnjcOpari nIraM varSayati tAdRzO yO yuSmAkaM svargasthaH pitA, yUyaM tasyaiva santAnA bhaviSyatha| ");
INSERT INTO sancol_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","yE yuSmAsu prEma kurvvanti, yUyaM yadi kEvalaM tEvvEva prEma kurutha, tarhi yuSmAkaM kiM phalaM bhaviSyati? caNPAlA api tAdRzaM kiM na kurvvanti? ");
INSERT INTO sancol_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","aparaM yUyaM yadi kEvalaM svIyabhrAtRtvEna namata, tarhi kiM mahat karmma kurutha? caNPAlA api tAdRzaM kiM na kurvvanti? ");
INSERT INTO sancol_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","tasmAt yuSmAkaM svargasthaH pitA yathA pUrNO bhavati, yUyamapi tAdRzA bhavata| ");
INSERT INTO sancol_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","sAvadhAnA bhavata, manujAn darzayituM tESAM gOcarE dharmmakarmma mA kuruta, tathA kRtE yuSmAkaM svargasthapituH sakAzAt kinjcana phalaM na prApsyatha| ");
INSERT INTO sancol_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","tvaM yadA dadAsi tadA kapaTinO janA yathA manujEbhyaH prazaMsAM prAptuM bhajanabhavanE rAjamArgE ca tUrIM vAdayanti, tathA mA kuriु, ahaM tubhyaM yathArthaM kathayAmi, tE svakAyaM phalam alabhanta| ");
INSERT INTO sancol_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","kintu tvaM yadA dadAsi, tadA nijadakSiNakarO yat karOti, tad vAmakaraM mA jnjApaya| ");
INSERT INTO sancol_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","tEna tava dAnaM guptaM bhaviSyati yastu tava pitA guptadarzI, sa prakAzya tubhyaM phalaM dAsyati| ");
INSERT INTO sancol_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","aparaM yadA prArthayasE, tadA kapaTina_iva mA kuru, yasmAt tE bhajanabhavanE rAjamArgasya kONE tiSThantO lOkAn darzayantaH prArthayituM prIyantE; ahaM yuSmAn tathyaM vadAmi, tE svakIyaphalaM prApnuvan| ");
INSERT INTO sancol_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","tasmAt prArthanAkAlE antarAgAraM pravizya dvAraM rudvvA guptaM pazyatastava pituH samIpE prArthayasva; tEna tava yaH pitA guptadarzI, sa prakAzya tubhyaM phalaM dAsyatil ");
INSERT INTO sancol_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","aparaM prArthanAkAlE dEvapUjakAiva mudhA punaruktiM mA kuru, yasmAt tE bOdhantE, bahuvAraM kathAyAM kathitAyAM tESAM prArthanA grAhiSyatE| ");
INSERT INTO sancol_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","yUyaM tESAmiva mA kuruta, yasmAt yuSmAkaM yad yat prayOjanaM yAcanAtaH prAgEva yuSmAkaM pitA tat jAnAti| ");
INSERT INTO sancol_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","ataEva yUyama IdRk prArthayadhvaM, hE asmAkaM svargasthapitaH, tava nAma pUjyaM bhavatu| ");
INSERT INTO sancol_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","tava rAjatvaM bhavatu; tavEcchA svargE yathA tathaiva mEdinyAmapi saphalA bhavatu| ");
INSERT INTO sancol_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","asmAkaM prayOjanIyam AhAram adya dEhi| ");
INSERT INTO sancol_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","vayaM yathA nijAparAdhinaH kSamAmahE, tathaivAsmAkam aparAdhAn kSamasva| ");
INSERT INTO sancol_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","asmAn parIkSAM mAnaya, kintu pApAtmanO rakSa; rAjatvaM gauravaM parAkramaH EtE sarvvE sarvvadA tava; tathAstu| ");
INSERT INTO sancol_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","yadi yUyam anyESAm aparAdhAn kSamadhvE tarhi yuSmAkaM svargasthapitApi yuSmAn kSamiSyatE; ");
INSERT INTO sancol_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","kintu yadi yUyam anyESAm aparAdhAn na kSamadhvE, tarhi yuSmAkaM janakOpi yuSmAkam aparAdhAn na kSamiSyatE| ");
INSERT INTO sancol_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","aparam upavAsakAlE kapaTinO janA mAnuSAn upavAsaM jnjApayituM svESAM vadanAni mlAnAni kurvvanti, yUyaM ta_iva viSaNavadanA mA bhavata; ahaM yuSmAn tathyaM vadAmi tE svakIyaphalam alabhanta| ");
INSERT INTO sancol_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","yadA tvam upavasasi, tadA yathA lOkaistvaM upavAsIva na dRzyasE, kintu tava yO'gOcaraH pitA tEnaiva dRzyasE, tatkRtE nijazirasi tailaM marddaya vadananjca prakSAlaya; ");
INSERT INTO sancol_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","tEna tava yaH pitA guptadarzI sa prakAzya tubhyaM phalaM dAsyati| ");
INSERT INTO sancol_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","aparaM yatra sthAnE kITAH kalagkAzca kSayaM nayanti, caurAzca sandhiM karttayitvA cOrayituM zaknuvanti, tAdRzyAM mEdinyAM svArthaM dhanaM mA saMcinuta| ");
INSERT INTO sancol_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","kintu yatra sthAnE kITAH kalagkAzca kSayaM na nayanti, caurAzca sandhiM karttayitvA cOrayituM na zaknuvanti, tAdRzE svargE dhanaM sanjcinuta| ");
INSERT INTO sancol_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","yasmAt yatra sthAnE yuSmAMka dhanaM tatraiva khAnE yuSmAkaM manAMsi| ");
INSERT INTO sancol_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","lOcanaM dEhasya pradIpakaM, tasmAt yadi tava lOcanaM prasannaM bhavati, tarhi tava kRtsnaM vapu rdIptiyuktaM bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","kintu lOcanE'prasannE tava kRtsnaM vapuH tamisrayuktaM bhaviSyati| ataEva yA dIptistvayi vidyatE, sA yadi tamisrayuktA bhavati, tarhi tat tamisraM kiyan mahat| ");
INSERT INTO sancol_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","kOpi manujO dvau prabhU sEvituM na zaknOti, yasmAd EkaM saMmanya tadanyaM na sammanyatE, yadvA Ekatra manO nidhAya tadanyam avamanyatE; tathA yUyamapIzvaraM lakSmInjcEtyubhE sEvituM na zaknutha| ");
INSERT INTO sancol_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","aparam ahaM yuSmabhyaM tathyaM kathayAmi, kiM bhakSiSyAmaH? kiM pAsyAmaH? iti prANadhAraNAya mA cintayata; kiM paridhAsyAmaH? iti kAyarakSaNAya na cintayata; bhakSyAt prANA vasanAnjca vapUMSi kiM zrESThANi na hi? ");
INSERT INTO sancol_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","vihAyasO vihaggamAn vilOkayata; tai rnOpyatE na kRtyatE bhANPAgArE na sanjcIyatE'pi; tathApi yuSmAkaM svargasthaH pitA tEbhya AhAraM vitarati| ");
INSERT INTO sancol_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","yUyaM tEbhyaH kiM zrESThA na bhavatha? yuSmAkaM kazcit manujaH cintayan nijAyuSaH kSaNamapi varddhayituM zaknOti? ");
INSERT INTO sancol_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","aparaM vasanAya kutazcintayata? kSEtrOtpannAni puSpANi kathaM varddhantE tadAlOcayata| tAni tantUn nOtpAdayanti kimapi kAryyaM na kurvvanti; ");
INSERT INTO sancol_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","tathApyahaM yuSmAn vadAmi, sulEmAn tAdRg aizvaryyavAnapi tatpuSpamiva vibhUSitO nAsIt| ");
INSERT INTO sancol_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","tasmAt kSadya vidyamAnaM zcaH cullyAM nikSEpsyatE tAdRzaM yat kSEtrasthitaM kusumaM tat yadIzcara itthaM bibhUSayati, tarhi hE stOkapratyayinO yuSmAn kiM na paridhApayiSyati? ");
INSERT INTO sancol_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","tasmAt asmAbhiH kimatsyatE? kinjca pAyiSyatE? kiM vA paridhAyiSyatE, iti na cintayata| ");
INSERT INTO sancol_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","yasmAt dEvArccakA apIti cESTantE; EtESu dravyESu prayOjanamastIti yuSmAkaM svargasthaH pitA jAnAti| ");
INSERT INTO sancol_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ataEva prathamata IzvarIyarAjyaM dharmmanjca cESTadhvaM, tata EtAni vastUni yuSmabhyaM pradAyiSyantE| ");
INSERT INTO sancol_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","zvaH kRtE mA cintayata, zvaEva svayaM svamuddizya cintayiSyati; adyatanI yA cintA sAdyakRtE pracuratarA| ");
INSERT INTO sancol_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","yathA yUyaM dOSIkRtA na bhavatha, tatkRtE'nyaM dOSiNaM mA kuruta| ");
INSERT INTO sancol_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","yatO yAdRzEna dOSENa yUyaM parAn dOSiNaH kurutha, tAdRzEna dOSENa yUyamapi dOSIkRtA bhaviSyatha, anyanjca yEna parimANEna yuSmAbhiH parimIyatE, tEnaiva parimANEna yuSmatkRtE parimAyiSyatE| ");
INSERT INTO sancol_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","aparanjca nijanayanE yA nAsA vidyatE, tAm anAlOcya tava sahajasya lOcanE yat tRNam AstE, tadEva kutO vIkSasE? ");
INSERT INTO sancol_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","tava nijalOcanE nAsAyAM vidyamAnAyAM, hE bhrAtaH, tava nayanAt tRNaM bahiSyartuM anujAnIhi, kathAmEtAM nijasahajAya kathaM kathayituM zaknOSi? ");
INSERT INTO sancol_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","hE kapaTin, Adau nijanayanAt nAsAM bahiSkuru tatO nijadRSTau suprasannAyAM tava bhrAtR rlOcanAt tRNaM bahiSkartuM zakSyasi| ");
INSERT INTO sancol_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","anyanjca sAramEyEbhyaH pavitravastUni mA vitarata, varAhANAM samakSanjca muktA mA nikSipata; nikSEpaNAt tE tAH sarvvAH padai rdalayiSyanti, parAvRtya yuSmAnapi vidArayiSyanti| ");
INSERT INTO sancol_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","yAcadhvaM tatO yuSmabhyaM dAyiSyatE; mRgayadhvaM tata uddEzaM lapsyadhvE; dvAram Ahata, tatO yuSmatkRtE muktaM bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","yasmAd yEna yAcyatE, tEna labhyatE; yEna mRgyatE tEnOddEzaH prApyatE; yEna ca dvAram AhanyatE, tatkRtE dvAraM mOcyatE| ");
INSERT INTO sancol_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","AtmajEna pUpE prArthitE tasmai pASANaM vizrANayati, ");
INSERT INTO sancol_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","mInE yAcitE ca tasmai bhujagaM vitarati, EtAdRzaH pitA yuSmAkaM madhyE ka AstE? ");
INSERT INTO sancol_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","tasmAd yUyam abhadrAH santO'pi yadi nijabAlakEbhya uttamaM dravyaM dAtuM jAnItha, tarhi yuSmAkaM svargasthaH pitA svIyayAcakEbhyaH kimuttamAni vastUni na dAsyati? ");
INSERT INTO sancol_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","yUSmAn pratItarESAM yAdRzO vyavahArO yuSmAkaM priyaH, yUyaM tAn prati tAdRzAnEva vyavahArAn vidhatta; yasmAd vyavasthAbhaviSyadvAdinAM vacanAnAm iti sAram| ");
INSERT INTO sancol_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","sagkIrNadvArENa pravizata; yatO narakagamanAya yad dvAraM tad vistIrNaM yacca vartma tad bRhat tEna bahavaH pravizanti| ");
INSERT INTO sancol_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","aparaM svargagamanAya yad dvAraM tat kIdRk saMkIrNaM| yacca vartma tat kIdRg durgamam| taduddESTAraH kiyantO'lpAH| ");
INSERT INTO sancol_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","aparanjca yE janA mESavEzEna yuSmAkaM samIpam Agacchanti, kintvantardurantA vRkA EtAdRzEbhyO bhaviSyadvAdibhyaH sAvadhAnA bhavata, yUyaM phalEna tAn paricEtuM zaknutha| ");
INSERT INTO sancol_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","manujAH kiM kaNTakinO vRkSAd drAkSAphalAni zRgAlakOlitazca uPumbaraphalAni zAtayanti? ");
INSERT INTO sancol_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","tadvad uttama Eva pAdapa uttamaphalAni janayati, adhamapAdapaEvAdhamaphalAni janayati| ");
INSERT INTO sancol_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","kintUttamapAdapaH kadApyadhamaphalAni janayituM na zaknOti, tathAdhamOpi pAdapa uttamaphalAni janayituM na zaknOti| ");
INSERT INTO sancol_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","aparaM yE yE pAdapA adhamaphalAni janayanti, tE kRttA vahnau kSipyantE| ");
INSERT INTO sancol_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ataEva yUyaM phalEna tAn paricESyatha| ");
INSERT INTO sancol_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","yE janA mAM prabhuM vadanti, tE sarvvE svargarAjyaM pravEkSyanti tanna, kintu yO mAnavO mama svargasthasya pituriSTaM karmma karOti sa Eva pravEkSyati| ");
INSERT INTO sancol_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","tad dinE bahavO mAM vadiSyanti, hE prabhO hE prabhO, tava nAmnA kimasmAmi rbhaviSyadvAkyaM na vyAhRtaM? tava nAmnA bhUtAH kiM na tyAjitAH? tava nAmnA kiM nAnAdbhutAni karmmANi na kRtAni? ");
INSERT INTO sancol_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","tadAhaM vadiSyAmi, hE kukarmmakAriNO yuSmAn ahaM na vEdmi, yUyaM matsamIpAd dUrIbhavata| ");
INSERT INTO sancol_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","yaH kazcit mamaitAH kathAH zrutvA pAlayati, sa pASANOpari gRhanirmmAtrA jnjAninA saha mayOpamIyatE| ");
INSERT INTO sancol_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","yatO vRSTau satyAm AplAva AgatE vAyau vAtE ca tESu tadgEhaM lagnESu pASANOpari tasya bhittEstanna patatil ");
INSERT INTO sancol_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","kintu yaH kazcit mamaitAH kathAH zrutvA na pAlayati sa saikatE gEhanirmmAtrA 'jnjAninA upamIyatE| ");
INSERT INTO sancol_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","yatO jalavRSTau satyAm AplAva AgatE pavanE vAtE ca tai rgRhE samAghAtE tat patati tatpatanaM mahad bhavati| ");
INSERT INTO sancol_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","yIzunaitESu vAkyESu samApitESu mAnavAstadIyOpadEzam AzcaryyaM mEnirE| ");
INSERT INTO sancol_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","yasmAt sa upAdhyAyA iva tAn nOpadidEza kintu samarthapuruSa_iva samupadidEza| ");
INSERT INTO sancol_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","yadA sa parvvatAd avArOhat tadA bahavO mAnavAstatpazcAd vavrajuH| ");
INSERT INTO sancol_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","EkaH kuSThavAn Agatya taM praNamya babhASE, hE prabhO, yadi bhavAn saMmanyatE, tarhi mAM nirAmayaM karttuM zaknOti| ");
INSERT INTO sancol_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","tatO yIzuH karaM prasAryya tasyAggaM spRzan vyAjahAra, sammanyE'haM tvaM nirAmayO bhava; tEna sa tatkSaNAt kuSThEnAmOci| ");
INSERT INTO sancol_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","tatO yIzustaM jagAda, avadhEhi kathAmEtAM kazcidapi mA brUhi, kintu yAjakasya sannidhiM gatvA svAtmAnaM darzaya manujEbhyO nijanirAmayatvaM pramANayituM mUsAnirUpitaM dravyam utsRja ca| ");
INSERT INTO sancol_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","tadanantaraM yIzunA kapharnAhUmnAmani nagarE praviSTE kazcit zatasEnApatistatsamIpam Agatya vinIya babhASE, ");
INSERT INTO sancol_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","hE prabhO, madIya EkO dAsaH pakSAghAtavyAdhinA bhRzaM vyathitaH, satu zayanIya AstE| ");
INSERT INTO sancol_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","tadAnIM yIzustasmai kathitavAn, ahaM gatvA taM nirAmayaM kariSyAmi| ");
INSERT INTO sancol_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","tataH sa zatasEnApatiH pratyavadat, hE prabhO, bhavAn yat mama gEhamadhyaM yAti tadyOgyabhAjanaM nAhamasmi; vAgmAtram Adizatu, tEnaiva mama dAsO nirAmayO bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","yatO mayi paranidhnE'pi mama nidEzavazyAH kati kati sEnAH santi, tata Ekasmin yAhItyuktE sa yAti, tadanyasmin EhItyuktE sa AyAti, tathA mama nijadAsE karmmaitat kurvvityuktE sa tat karOti| ");
INSERT INTO sancol_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","tadAnIM yIzustasyaitat vacO nizamya vismayApannO'bhUt; nijapazcAdgAminO mAnavAn avOcca, yuSmAn tathyaM vacmi, isrAyElIyalOkAnAM madhyE'pi naitAdRzO vizvAsO mayA prAptaH| ");
INSERT INTO sancol_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","anyaccAhaM yuSmAn vadAmi, bahavaH pUrvvasyAH pazcimAyAzca diza Agatya ibrAhImA ishAkA yAkUbA ca sAkam militvA samupavEkSyanti; ");
INSERT INTO sancol_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","kintu yatra sthAnE rOdanadantagharSaNE bhavatastasmin bahirbhUtatamisrE rAjyasya santAnA nikSEsyantE| ");
INSERT INTO sancol_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","tataH paraM yIzustaM zatasEnApatiM jagAda, yAhi, tava pratItyanusAratO maggalaM bhUyAt; tadA tasminnEva daNPE tadIyadAsO nirAmayO babhUva| ");
INSERT INTO sancol_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","anantaraM yIzuH pitarasya gEhamupasthAya jvarENa pIPitAM zayanIyasthitAM tasya zvazrUM vIkSAnjcakrE| ");
INSERT INTO sancol_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","tatastEna tasyAH karasya spRSTatavAt jvarastAM tatyAja, tadA sA samutthAya tAn siSEvE| ");
INSERT INTO sancol_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","anantaraM sandhyAyAM satyAM bahuzO bhUtagrastamanujAn tasya samIpam AninyuH sa ca vAkyEna bhUtAn tyAjayAmAsa, sarvvaprakArapIPitajanAMzca nirAmayAn cakAra; ");
INSERT INTO sancol_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","tasmAt, sarvvA durbbalatAsmAkaM tEnaiva paridhAritA| asmAkaM sakalaM vyAdhiM saEva saMgRhItavAn| yadEtadvacanaM yizayiyabhaviSyadvAdinOktamAsIt, tattadA saphalamabhavat| ");
INSERT INTO sancol_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","anantaraM yIzuzcaturdikSu jananivahaM vilOkya taTinyAH pAraM yAtuM ziSyAn AdidEza| ");
INSERT INTO sancol_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","tadAnIm Eka upAdhyAya Agatya kathitavAn, hE gurO, bhavAn yatra yAsyati tatrAhamapi bhavataH pazcAd yAsyAmi| ");
INSERT INTO sancol_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","tatO yIzu rjagAda, krOSTuH sthAtuM sthAnaM vidyatE, vihAyasO vihaggamAnAM nIPAni ca santi; kintu manuSyaputrasya ziraH sthApayituM sthAnaM na vidyatE| ");
INSERT INTO sancol_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","anantaram apara EkaH ziSyastaM babhASE, hE prabhO, prathamatO mama pitaraM zmazAnE nidhAtuM gamanArthaM mAm anumanyasva| ");
INSERT INTO sancol_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","tatO yIzuruktavAn mRtA mRtAn zmazAnE nidadhatu, tvaM mama pazcAd Agaccha| ");
INSERT INTO sancol_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","anantaraM tasmin nAvamArUPhE tasya ziSyAstatpazcAt jagmuH| ");
INSERT INTO sancol_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","pazcAt sAgarasya madhyaM tESu gatESu tAdRzaH prabalO jhanjbhzanila udatiSThat, yEna mahAtaragga utthAya taraNiM chAditavAn, kintu sa nidrita AsIt| ");
INSERT INTO sancol_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","tadA ziSyA Agatya tasya nidrAbhaggaM kRtvA kathayAmAsuH, hE prabhO, vayaM mriyAmahE, bhavAn asmAkaM prANAn rakSatu| ");
INSERT INTO sancol_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","tadA sa tAn uktavAn, hE alpavizvAsinO yUyaM kutO vibhItha? tataH sa utthAya vAtaM sAgaranjca tarjayAmAsa, tatO nirvvAtamabhavat| ");
INSERT INTO sancol_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","aparaM manujA vismayaM vilOkya kathayAmAsuH, ahO vAtasaritpatI asya kimAjnjAgrAhiNau? kIdRzO'yaM mAnavaH| ");
INSERT INTO sancol_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","anantaraM sa pAraM gatvA gidErIyadEzam upasthitavAn; tadA dvau bhUtagrastamanujau zmazAnasthAnAd bahi rbhUtvA taM sAkSAt kRtavantau, tAvEtAdRzau pracaNPAvAstAM yat tEna sthAnEna kOpi yAtuM nAzaknOt| ");
INSERT INTO sancol_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","tAvucaiH kathayAmAsatuH, hE Izvarasya sUnO yIzO, tvayA sAkam AvayOH kaH sambandhaH? nirUpitakAlAt prAgEva kimAvAbhyAM yAtanAM dAtum atrAgatOsi? ");
INSERT INTO sancol_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","tadAnIM tAbhyAM kinjcid dUrE varAhANAm EkO mahAvrajO'carat| ");
INSERT INTO sancol_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","tatO bhUtau tau tasyAntikE vinIya kathayAmAsatuH, yadyAvAM tyAjayasi, tarhi varAhANAM madhyEvrajam AvAM prEraya| ");
INSERT INTO sancol_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","tadA yIzuravadat yAtaM, anantaraM tau yadA manujau vihAya varAhAn Azritavantau, tadA tE sarvvE varAhA uccasthAnAt mahAjavEna dhAvantaH sAgarIyatOyE majjantO mamruH| ");
INSERT INTO sancol_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","tatO varAharakSakAH palAyamAnA madhyEnagaraM tau bhUtagrastau prati yadyad aghaTata, tAH sarvvavArttA avadan| ");
INSERT INTO sancol_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","tatO nAgarikAH sarvvE manujA yIzuM sAkSAt karttuM bahirAyAtAH tanjca vilOkya prArthayAnjcakrirE bhavAn asmAkaM sImAtO yAtu| ");
INSERT INTO sancol_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","anantaraM yIzu rnaukAmAruhya punaH pAramAgatya nijagrAmam Ayayau| ");
INSERT INTO sancol_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","tataH katipayA janA EkaM pakSAghAtinaM svaTTOpari zAyayitvA tatsamIpam Anayan; tatO yIzustESAM pratItiM vijnjAya taM pakSAghAtinaM jagAda, hE putra, susthirO bhava, tava kaluSasya marSaNaM jAtam| ");
INSERT INTO sancol_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","tAM kathAM nizamya kiyanta upAdhyAyA manaHsu cintitavanta ESa manuja IzvaraM nindati| ");
INSERT INTO sancol_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","tataH sa tESAm EtAdRzIM cintAM vijnjAya kathitavAn, yUyaM manaHsu kRta EtAdRzIM kucintAM kurutha? ");
INSERT INTO sancol_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","tava pApamarSaNaM jAtaM, yadvA tvamutthAya gaccha, dvayOranayO rvAkyayOH kiM vAkyaM vaktuM sugamaM? ");
INSERT INTO sancol_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","kintu mEdinyAM kaluSaM kSamituM manujasutasya sAmarthyamastIti yUyaM yathA jAnItha, tadarthaM sa taM pakSAghAtinaM gaditavAn, uttiSTha, nijazayanIyaM AdAya gEhaM gaccha| ");
INSERT INTO sancol_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","tataH sa tatkSaNAd utthAya nijagEhaM prasthitavAn| ");
INSERT INTO sancol_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","mAnavA itthaM vilOkya vismayaM mEnirE, IzvarENa mAnavAya sAmarthyam IdRzaM dattaM iti kAraNAt taM dhanyaM babhASirE ca| ");
INSERT INTO sancol_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","anantaraM yIzustatsthAnAd gacchan gacchan karasaMgrahasthAnE samupaviSTaM mathinAmAnam EkaM manujaM vilOkya taM babhASE, mama pazcAd Agaccha, tataH sa utthAya tasya pazcAd vavrAja| ");
INSERT INTO sancol_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","tataH paraM yIzau gRhE bhOktum upaviSTE bahavaH karasaMgrAhiNaH kaluSiNazca mAnavA Agatya tEna sAkaM tasya ziSyaizca sAkam upavivizuH| ");
INSERT INTO sancol_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","phirUzinastad dRSTvA tasya ziSyAn babhASirE, yuSmAkaM guruH kiM nimittaM karasaMgrAhibhiH kaluSibhizca sAkaM bhuMktE? ");
INSERT INTO sancol_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","yIzustat zrutvA tAn pratyavadat, nirAmayalOkAnAM cikitsakEna prayOjanaM nAsti, kintu sAmayalOkAnAM prayOjanamAstE| ");
INSERT INTO sancol_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","atO yUyaM yAtvA vacanasyAsyArthaM zikSadhvam, dayAyAM mE yathA prIti rna tathA yajnjakarmmaNi|yatO'haM dhArmmikAn AhvAtuM nAgatO'smi kintu manaH parivarttayituM pApina AhvAtum AgatO'smi| ");
INSERT INTO sancol_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","anantaraM yOhanaH ziSyAstasya samIpam Agatya kathayAmAsuH, phirUzinO vayanjca punaH punarupavasAmaH, kintu tava ziSyA nOpavasanti, kutaH? ");
INSERT INTO sancol_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","tadA yIzustAn avOcat yAvat sakhInAM saMggE kanyAyA varastiSThati, tAvat kiM tE vilApaM karttuM zakluvanti? kintu yadA tESAM saMggAd varaM nayanti, tAdRzaH samaya AgamiSyati, tadA tE upavatsyanti| ");
INSERT INTO sancol_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","purAtanavasanE kOpi navInavastraM na yOjayati, yasmAt tEna yOjitEna purAtanavasanaM chinatti tacchidranjca bahukutsitaM dRzyatE| ");
INSERT INTO sancol_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","anyanjca purAtanakutvAM kOpi navAnagOstanIrasaM na nidadhAti, yasmAt tathA kRtE kutU rvidIryyatE tEna gOstanIrasaH patati kutUzca nazyati; tasmAt navInAyAM kutvAM navInO gOstanIrasaH sthApyatE, tEna dvayOravanaM bhavati| ");
INSERT INTO sancol_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","aparaM tEnaitatkathAkathanakAlE EkO'dhipatistaM praNamya babhASE, mama duhitA prAyENaitAvatkAlE mRtA, tasmAd bhavAnAgatya tasyA gAtrE hastamarpayatu, tEna sA jIviSyati| ");
INSERT INTO sancol_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","tadAnIM yIzuH ziSyaiH sAkam utthAya tasya pazcAd vavrAja| ");
INSERT INTO sancol_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ityanantarE dvAdazavatsarAn yAvat pradarAmayEna zIrNaikA nArI tasya pazcAd Agatya tasya vasanasya granthiM pasparza; ");
INSERT INTO sancol_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","yasmAt mayA kEvalaM tasya vasanaM spRSTvA svAsthyaM prApsyatE, sA nArIti manasi nizcitavatI| ");
INSERT INTO sancol_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","tatO yIzurvadanaM parAvarttya tAM jagAda, hE kanyE, tvaM susthirA bhava, tava vizvAsastvAM svasthAmakArSIt| EtadvAkyE gaditaEva sA yOSit svasthAbhUt| ");
INSERT INTO sancol_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","aparaM yIzustasyAdhyakSasya gEhaM gatvA vAdakaprabhRtIn bahUn lOkAn zabdAyamAnAn vilOkya tAn avadat, ");
INSERT INTO sancol_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","panthAnaM tyaja, kanyEyaM nAmriyata nidritAstE; kathAmEtAM zrutvA tE tamupajahasuH| ");
INSERT INTO sancol_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","kintu sarvvESu bahiSkRtESu sO'bhyantaraM gatvA kanyAyAH karaM dhRtavAn, tEna sOdatiSThat; ");
INSERT INTO sancol_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","tatastatkarmmaNO yazaH kRtsnaM taM dEzaM vyAptavat| ");
INSERT INTO sancol_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","tataH paraM yIzustasmAt sthAnAd yAtrAM cakAra; tadA hE dAyUdaH santAna, asmAn dayasva, iti vadantau dvau janAvandhau prOcairAhUyantau tatpazcAd vavrajatuH| ");
INSERT INTO sancol_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","tatO yIzau gEhamadhyaM praviSTaM tAvapi tasya samIpam upasthitavantau, tadAnIM sa tau pRSTavAn karmmaitat karttuM mama sAmarthyam AstE, yuvAM kimiti pratIthaH? tadA tau pratyUcatuH, satyaM prabhO| ");
INSERT INTO sancol_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","tadAnIM sa tayO rlOcanAni spRzan babhASE, yuvayOH pratItyanusArAd yuvayO rmaggalaM bhUyAt| tEna tatkSaNAt tayO rnEtrANi prasannAnyabhavan, ");
INSERT INTO sancol_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","pazcAd yIzustau dRPhamAjnjApya jagAda, avadhattam EtAM kathAM kOpi manujO ma jAnIyAt| ");
INSERT INTO sancol_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","kintu tau prasthAya tasmin kRtsnE dEzE tasya kIrttiM prakAzayAmAsatuH| ");
INSERT INTO sancol_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","aparaM tau bahiryAta EtasminnantarE manujA EkaM bhUtagrastamUkaM tasya samIpam AnItavantaH| ");
INSERT INTO sancol_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","tEna bhUtE tyAjitE sa mUkaH kathAM kathayituM prArabhata, tEna janA vismayaM vijnjAya kathayAmAsuH, isrAyElO vaMzE kadApi nEdRgadRzyata; ");
INSERT INTO sancol_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","kintu phirUzinaH kathayAnjcakruH bhUtAdhipatinA sa bhUtAn tyAjayati| ");
INSERT INTO sancol_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","tataH paraM yIzustESAM bhajanabhavana upadizan rAjyasya susaMvAdaM pracArayan lOkAnAM yasya ya AmayO yA ca pIPAsIt, tAn zamayan zamayaMzca sarvvANi nagarANi grAmAMzca babhrAma| ");
INSERT INTO sancol_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","anyanjca manujAn vyAkulAn arakSakamESAniva ca tyaktAn nirIkSya tESu kAruNikaH san ziSyAn avadat, ");
INSERT INTO sancol_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","zasyAni pracurANi santi, kintu chEttAraH stOkAH| ");
INSERT INTO sancol_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","kSEtraM pratyaparAn chEdakAn prahEtuM zasyasvAminaM prArthayadhvam| ");
INSERT INTO sancol_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","anantaraM yIzu rdvAdazaziSyAn AhUyAmEdhyabhUtAn tyAjayituM sarvvaprakArarOgAn pIPAzca zamayituM tEbhyaH sAmarthyamadAt| ");
INSERT INTO sancol_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","tESAM dvAdazaprESyANAM nAmAnyEtAni| prathamaM zimOn yaM pitaraM vadanti, tataH paraM tasya sahaja AndriyaH, sivadiyasya putrO yAkUb ");
INSERT INTO sancol_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","tasya sahajO yOhan; philip barthalamay thOmAH karasaMgrAhI mathiH, AlphEyaputrO yAkUb, ");
INSERT INTO sancol_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","kinAnIyaH zimOn, ya ISkariyOtIyayihUdAH khrISTaM parakarE'rpayat| ");
INSERT INTO sancol_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","EtAn dvAdazaziSyAn yIzuH prESayan ityAjnjApayat, yUyam anyadEzIyAnAM padavIM zEmirONIyAnAM kimapi nagaranjca na pravizyE ");
INSERT INTO sancol_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","isrAyElgOtrasya hAritA yE yE mESAstESAmEva samIpaM yAta| ");
INSERT INTO sancol_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","gatvA gatvA svargasya rAjatvaM savidhamabhavat, EtAM kathAM pracArayata| ");
INSERT INTO sancol_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","AmayagrastAn svasthAn kuruta, kuSThinaH pariSkuruta, mRtalOkAn jIvayata, bhUtAn tyAjayata, vinA mUlyaM yUyam alabhadhvaM vinaiva mUlyaM vizrANayata| ");
INSERT INTO sancol_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","kintu svESAM kaTibandhESu svarNarUpyatAmrANAM kimapi na gRhlIta| ");
INSERT INTO sancol_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","anyacca yAtrAyai cElasampuTaM vA dvitIyavasanaM vA pAdukE vA yaSTiH, EtAn mA gRhlIta, yataH kAryyakRt bharttuM yOgyO bhavati| ");
INSERT INTO sancol_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","aparaM yUyaM yat puraM yanjca grAmaM pravizatha, tatra yO janO yOgyapAtraM tamavagatya yAnakAlaM yAvat tatra tiSThata| ");
INSERT INTO sancol_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","yadA yUyaM tadgEhaM pravizatha, tadA tamAziSaM vadata| ");
INSERT INTO sancol_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","yadi sa yOgyapAtraM bhavati, tarhi tatkalyANaM tasmai bhaviSyati, nOcEt sAzIryuSmabhyamEva bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","kintu yE janA yuSmAkamAtithyaM na vidadhati yuSmAkaM kathAnjca na zRNvanti tESAM gEhAt purAdvA prasthAnakAlE svapadUlIH pAtayata| ");
INSERT INTO sancol_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","yuSmAnahaM tathyaM vacmi vicAradinE tatpurasya dazAtaH sidOmamOrApurayOrdazA sahyatarA bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","pazyata, vRkayUthamadhyE mESaH yathAvistathA yuSmAna prahiNOmi, tasmAd yUyam ahiriva satarkAH kapOtAivAhiMsakA bhavata| ");
INSERT INTO sancol_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","nRbhyaH sAvadhAnA bhavata; yatastai ryUyaM rAjasaMsadi samarpiSyadhvE tESAM bhajanagEhE prahAriSyadhvE| ");
INSERT INTO sancol_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","yUyaM mannAmahEtOH zAstRNAM rAjnjAnjca samakSaM tAnanyadEzinazcAdhi sAkSitvArthamAnESyadhvE| ");
INSERT INTO sancol_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","kintvitthaM samarpitA yUyaM kathaM kimuttaraM vakSyatha tatra mA cintayata, yatastadA yuSmAbhi ryad vaktavyaM tat taddaNPE yuSmanmanaH su samupasthAsyati| ");
INSERT INTO sancol_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","yasmAt tadA yO vakSyati sa na yUyaM kintu yuSmAkamantarasthaH pitrAtmA| ");
INSERT INTO sancol_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","sahajaH sahajaM tAtaH sutanjca mRtau samarpayiSyati, apatyAgi svasvapitrOे rvipakSIbhUya tau ghAtayiSyanti| ");
INSERT INTO sancol_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","mannamahEtOH sarvvE janA yuSmAn RृtIyiSyantE, kintu yaH zESaM yAvad dhairyyaM ghRtvA sthAsyati, sa trAyiSyatE| ");
INSERT INTO sancol_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","tai ryadA yUyamEkapurE tAPiSyadhvE, tadA yUyamanyapuraM palAyadhvaM yuSmAnahaM tathyaM vacmi yAvanmanujasutO naiti tAvad isrAyEldEzIyasarvvanagarabhramaNaM samApayituM na zakSyatha| ");
INSERT INTO sancol_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","gurOH ziSyO na mahAn, prabhOrdAsO na mahAn| ");
INSERT INTO sancol_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","yadi ziSyO nijagurO rdAsazca svaprabhOH samAnO bhavati tarhi tad yathESTaM| cEttairgRhapatirbhUtarAja ucyatE, tarhi parivArAH kiM tathA na vakSyantE? ");
INSERT INTO sancol_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","kintu tEbhyO yUyaM mA bibhIta, yatO yanna prakAziSyatE, tAdRk chAditaM kimapi nAsti, yacca na vyanjciSyatE, tAdRg guptaM kimapi nAsti| ");
INSERT INTO sancol_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","yadahaM yuSmAn tamasi vacmi tad yuSmAbhirdIptau kathyatAM; karNAbhyAM yat zrUyatE tad gEhOpari pracAryyatAM| ");
INSERT INTO sancol_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","yE kAyaM hantuM zaknuvanti nAtmAnaM, tEbhyO mA bhaiSTa; yaH kAyAtmAnau nirayE nAzayituM, zaknOti, tatO bibhIta| ");
INSERT INTO sancol_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","dvau caTakau kimEkatAmramudrayA na vikrIyEtE? tathApi yuSmattAtAnumatiM vinA tESAmEkOpi bhuvi na patati| ");
INSERT INTO sancol_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","yuSmacchirasAM sarvvakacA gaNitAMH santi| ");
INSERT INTO sancol_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","atO mA bibhIta, yUyaM bahucaTakEbhyO bahumUlyAH| ");
INSERT INTO sancol_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","yO manujasAkSAnmAmaggIkurutE tamahaM svargasthatAtasAkSAdaggIkariSyE| ");
INSERT INTO sancol_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","pRthvyAmahaM zAntiM dAtumAgata_iti mAnubhavata, zAntiM dAtuM na kintvasiM| ");
INSERT INTO sancol_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","pitRmAtRzcazrUbhiH sAkaM sutasutAbadhU rvirOdhayitunjcAgatEाsmi| ");
INSERT INTO sancol_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","tataH svasvaparivAraEva nRzatru rbhavitA| ");
INSERT INTO sancol_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","yaH pitari mAtari vA mattOdhikaM prIyatE, sa na madarhaH; ");
INSERT INTO sancol_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","yazca sutE sutAyAM vA mattOdhikaM prIyatE, sEाpi na madarhaH| ");
INSERT INTO sancol_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","yaH svakruzaM gRhlan matpazcAnnaiti, sEाpi na madarhaH| ");
INSERT INTO sancol_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","yaH svaprANAnavati, sa tAn hArayiSyatE, yastu matkRtE svaprANAn hArayati, sa tAnavati| ");
INSERT INTO sancol_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","yO yuSmAkamAtithyaM vidadhAti, sa mamAtithyaM vidadhAti, yazca mamAtithyaM vidadhAti, sa matprErakasyAtithyaM vidadhAti| ");
INSERT INTO sancol_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","yO bhaviSyadvAdIti jnjAtvA tasyAtithyaM vidhattE, sa bhaviSyadvAdinaH phalaM lapsyatE, yazca dhArmmika iti viditvA tasyAtithyaM vidhattE sa dhArmmikamAnavasya phalaM prApsyati| ");
INSERT INTO sancol_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","yazca kazcit EtESAM kSudranarANAm yaM kanjcanaikaM ziSya iti viditvA kaMsaikaM zItalasalilaM tasmai dattE, yuSmAnahaM tathyaM vadAmi, sa kEnApi prakArENa phalEna na vanjciSyatE| ");
INSERT INTO sancol_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","itthaM yIzuH svadvAdazaziSyANAmAjnjApanaM samApya purE pura upadESTuM susaMvAdaM pracArayituM tatsthAnAt pratasthE| ");
INSERT INTO sancol_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","anantaraM yOhan kArAyAM tiSThan khriSTasya karmmaNAM vArttaM prApya yasyAgamanavArttAsIt saEva kiM tvaM? vA vayamanyam apEkSiSyAmahE? ");
INSERT INTO sancol_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Etat praSTuM nijau dvau ziSyau prAhiNOt| ");
INSERT INTO sancol_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","yIzuH pratyavOcat, andhA nEtrANi labhantE, khanjcA gacchanti, kuSThinaH svasthA bhavanti, badhirAH zRNvanti, mRtA jIvanta uttiSThanti, daridrANAM samIpE susaMvAdaH pracAryyata, ");
INSERT INTO sancol_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","EtAni yadyad yuvAM zRNuthaH pazyathazca gatvA tadvArttAM yOhanaM gadataM| ");
INSERT INTO sancol_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","yasyAhaM na vighnIbhavAmi, saEva dhanyaH| ");
INSERT INTO sancol_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","anantaraM tayOH prasthitayO ryIzu ryOhanam uddizya janAn jagAda, yUyaM kiM draSTuM vahirmadhyEprAntaram agacchata? kiM vAtEna kampitaM nalaM? ");
INSERT INTO sancol_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","vA kiM vIkSituM vahirgatavantaH? kiM parihitasUkSmavasanaM manujamEkaM? pazyata, yE sUkSmavasanAni paridadhati, tE rAjadhAnyAM tiSThanti| ");
INSERT INTO sancol_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","tarhi yUyaM kiM draSTuM bahiragamata, kimEkaM bhaviSyadvAdinaM? tadEva satyaM| yuSmAnahaM vadAmi, sa bhaviSyadvAdinOpi mahAn; ");
INSERT INTO sancol_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","yataH, pazya svakIyadUtOyaM tvadagrE prESyatE mayA| sa gatvA tava panthAnaM smayak pariSkariSyati|| EtadvacanaM yamadhi likhitamAstE sO'yaM yOhan| ");
INSERT INTO sancol_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","aparaM yuSmAnahaM tathyaM bravImi, majjayitu ryOhanaH zrESThaH kOpi nArItO nAjAyata; tathApi svargarAjyamadhyE sarvvEbhyO yaH kSudraH sa yOhanaH zrESThaH| ");
INSERT INTO sancol_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","aparanjca A yOhanO'dya yAvat svargarAjyaM balAdAkrAntaM bhavati Akraminazca janA balEna tadadhikurvvanti| ");
INSERT INTO sancol_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","yatO yOhanaM yAvat sarvvabhaviSyadvAdibhi rvyavasthayA ca upadEzaH prAkAzyata| ");
INSERT INTO sancol_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","yadi yUyamidaM vAkyaM grahItuM zaknutha, tarhi zrEyaH, yasyAgamanasya vacanamAstE sO'yam EliyaH| ");
INSERT INTO sancol_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","yasya zrOtuM karNau staH sa zRNOtu| ");
INSERT INTO sancol_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","EtE vidyamAnajanAH kai rmayOpamIyantE? yE bAlakA haTTa upavizya svaM svaM bandhumAhUya vadanti, ");
INSERT INTO sancol_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","vayaM yuSmAkaM samIpE vaMzIravAdayAma, kintu yUyaM nAnRtyata; yuSmAkaM samIpE ca vayamarOdima, kintu yUyaM na vyalapata, tAdRzai rbAlakaista upamAyiSyantE| ");
INSERT INTO sancol_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","yatO yOhan Agatya na bhuktavAn na pItavAMzca, tEna lOkA vadanti, sa bhUtagrasta iti| ");
INSERT INTO sancol_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","manujasuta Agatya bhuktavAn pItavAMzca, tEna lOkA vadanti, pazyata ESa bhOktA madyapAtA caNPAlapApinAM bandhazca, kintu jnjAninO jnjAnavyavahAraM nirdOSaM jAnanti| ");
INSERT INTO sancol_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","sa yatra yatra purE bahvAzcaryyaM karmma kRtavAn, tannivAsinAM manaHparAvRttyabhAvAt tAni nagarANi prati hantEtyuktA kathitavAn, ");
INSERT INTO sancol_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","hA kOrAsIn, hA baitsaidE, yuSmanmadhyE yadyadAzcaryyaM karmma kRtaM yadi tat sOrasIdOnnagara akAriSyata, tarhi pUrvvamEva tannivAsinaH zANavasanE bhasmani cOpavizantO manAMsi parAvarttiSyanta| ");
INSERT INTO sancol_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","tasmAdahaM yuSmAn vadAmi, vicAradinE yuSmAkaM dazAtaH sOrasIdOnO rdazA sahyatarA bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","aparanjca bata kapharnAhUm, tvaM svargaM yAvadunnatOsi, kintu narakE nikSEpsyasE, yasmAt tvayi yAnyAzcaryyANi karmmaNyakAriSata, yadi tAni sidOmnagara akAriSyanta, tarhi tadadya yAvadasthAsyat| ");
INSERT INTO sancol_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","kintvahaM yuSmAn vadAmi, vicAradinE tava daNPataH sidOmO daNPO sahyatarO bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","EtasminnEva samayE yIzuH punaruvAca, hE svargapRthivyOrEkAdhipatE pitastvaM jnjAnavatO viduSazca lOkAn pratyEtAni na prakAzya bAlakAn prati prakAzitavAn, iti hEtOstvAM dhanyaM vadAmi| ");
INSERT INTO sancol_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","hE pitaH, itthaM bhavEt yata idaM tvadRSTAvuttamaM| ");
INSERT INTO sancol_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","pitrA mayi sarvvANi samarpitAni, pitaraM vinA kOpi putraM na jAnAti, yAn prati putrENa pitA prakAzyatE tAn vinA putrAd anyaH kOpi pitaraM na jAnAti| ");
INSERT INTO sancol_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","hE parizrAntA bhArAkrAntAzca lOkA yUyaM matsannidhim Agacchata, ahaM yuSmAn vizramayiSyAmi| ");
INSERT INTO sancol_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ahaM kSamaNazIlO namramanAzca, tasmAt mama yugaM svESAmupari dhArayata mattaH zikSadhvanjca, tEna yUyaM svE svE manasi vizrAmaM lapsyadhbE| ");
INSERT INTO sancol_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","yatO mama yugam anAyAsaM mama bhArazca laghuH| ");
INSERT INTO sancol_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","anantaraM yIzu rvizrAmavArE zsyamadhyEna gacchati, tadA tacchiSyA bubhukSitAH santaH zsyamanjjarIzchatvA chitvA khAditumArabhanta| ");
INSERT INTO sancol_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","tad vilOkya phirUzinO yIzuM jagaduH, pazya vizrAmavArE yat karmmAkarttavyaM tadEva tava ziSyAH kurvvanti| ");
INSERT INTO sancol_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","sa tAn pratyAvadata, dAyUd tatsagginazca bubhukSitAH santO yat karmmAkurvvan tat kiM yuSmAbhi rnApAThi? ");
INSERT INTO sancol_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","yE darzanIyAH pUpAH yAjakAn vinA tasya tatsaggimanujAnAnjcAbhOjanIyAsta IzvarAvAsaM praviSTEna tEna bhuktAH| ");
INSERT INTO sancol_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","anyacca vizrAmavArE madhyEmandiraM vizrAmavArIyaM niyamaM lagvantOpi yAjakA nirdOSA bhavanti, zAstramadhyE kimidamapi yuSmAbhi rna paThitaM? ");
INSERT INTO sancol_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","yuSmAnahaM vadAmi, atra sthAnE mandirAdapi garIyAn Eka AstE| ");
INSERT INTO sancol_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","kintu dayAyAM mE yathA prIti rna tathA yajnjakarmmaNi| EtadvacanasyArthaM yadi yuyam ajnjAsiSTa tarhi nirdOSAn dOSiNO nAkArSTa| ");
INSERT INTO sancol_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","anyacca manujasutO vizrAmavArasyApi patirAstE| ");
INSERT INTO sancol_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","anantaraM sa tatsthAnAt prasthAya tESAM bhajanabhavanaM praviSTavAn, tadAnIm EkaH zuSkakarAmayavAn upasthitavAn| ");
INSERT INTO sancol_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","tatO yIzum apavadituM mAnuSAH papracchuH, vizrAmavArE nirAmayatvaM karaNIyaM na vA? ");
INSERT INTO sancol_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","tEna sa pratyuvAca, vizrAmavArE yadi kasyacid avi rgarttE patati, tarhi yastaM ghRtvA na tOlayati, EtAdRzO manujO yuSmAkaM madhyE ka AstE? ");
INSERT INTO sancol_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","avE rmAnavaH kiM nahi zrEyAn? atO vizrAmavArE hitakarmma karttavyaM| ");
INSERT INTO sancol_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","anantaraM sa taM mAnavaM gaditavAn, karaM prasAraya; tEna karE prasAritE sOnyakaravat svasthO'bhavat| ");
INSERT INTO sancol_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","tadA phirUzinO bahirbhUya kathaM taM haniSyAma iti kumantraNAM tatprAtikUlyEna cakruH| ");
INSERT INTO sancol_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","tatO yIzustad viditvA sthanAntaraM gatavAn; anyESu bahunarESu tatpazcAd gatESu tAn sa nirAmayAn kRtvA ityAjnjApayat, ");
INSERT INTO sancol_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","yUyaM mAM na paricAyayata| ");
INSERT INTO sancol_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","tasmAt mama prIyO manOnItO manasastuSTikArakaH| madIyaH sEvakO yastu vidyatE taM samIkSatAM| tasyOpari svakIyAtmA mayA saMsthApayiSyatE| tEnAnyadEzajAtESu vyavasthA saMprakAzyatE| ");
INSERT INTO sancol_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","kEnApi na virOdhaM sa vivAdanjca kariSyati| na ca rAjapathE tEna vacanaM zrAvayiSyatE| ");
INSERT INTO sancol_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","vyavasthA calitA yAvat nahi tEna kariSyatE| tAvat nalO vidIrNO'pi bhaMkSyatE nahi tEna ca| tathA sadhUmavarttinjca na sa nirvvApayiSyatE| ");
INSERT INTO sancol_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","pratyAzAnjca kariSyanti tannAmni bhinnadEzajAH| ");
INSERT INTO sancol_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","yAnyEtAni vacanAni yizayiyabhaviSyadvAdinA prOktAnyAsan, tAni saphalAnyabhavan| ");
INSERT INTO sancol_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","anantaraM lOkai statsamIpam AnItO bhUtagrastAndhamUkaikamanujastEna svasthIkRtaH, tataH sO'ndhO mUkO draSTuM vaktunjcArabdhavAn| ");
INSERT INTO sancol_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","anEna sarvvE vismitAH kathayAnjcakruH, ESaH kiM dAyUdaH santAnO nahi? ");
INSERT INTO sancol_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","kintu phirUzinastat zrutvA gaditavantaH, bAlsibUbnAmnO bhUtarAjasya sAhAyyaM vinA nAyaM bhUtAn tyAjayati| ");
INSERT INTO sancol_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","tadAnIM yIzustESAm iti mAnasaM vijnjAya tAn avadat kinjcana rAjyaM yadi svavipakSAd bhidyatE, tarhi tat ucchidyatE; yacca kinjcana nagaraM vA gRhaM svavipakSAd vibhidyatE, tat sthAtuM na zaknOti| ");
INSERT INTO sancol_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","tadvat zayatAnO yadi zayatAnaM bahiH kRtvA svavipakSAt pRthak pRthak bhavati, tarhi tasya rAjyaM kEna prakArENa sthAsyati? ");
INSERT INTO sancol_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ahanjca yadi bAlsibUbA bhUtAn tyAjayAmi, tarhi yuSmAkaM santAnAH kEna bhUtAn tyAjayanti? tasmAd yuSmAkam EtadvicArayitArasta Eva bhaviSyanti| ");
INSERT INTO sancol_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","kintavahaM yadIzvarAtmanA bhUtAn tyAjayAmi, tarhIzvarasya rAjyaM yuSmAkaM sannidhimAgatavat| ");
INSERT INTO sancol_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","anyanjca kOpi balavanta janaM prathamatO na badvvA kEna prakArENa tasya gRhaM pravizya taddravyAdi lOThayituM zaknOti? kintu tat kRtvA tadIyagRsya dravyAdi lOThayituM zaknOti| ");
INSERT INTO sancol_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","yaH kazcit mama svapakSIyO nahi sa vipakSIya AstE, yazca mayA sAkaM na saMgRhlAti, sa vikirati| ");
INSERT INTO sancol_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ataEva yuSmAnahaM vadAmi, manujAnAM sarvvaprakArapApAnAM nindAyAzca marSaNaM bhavituM zaknOti, kintu pavitrasyAtmanO viruddhanindAyA marSaNaM bhavituM na zaknOti| ");
INSERT INTO sancol_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","yO manujasutasya viruddhAM kathAM kathayati, tasyAparAdhasya kSamA bhavituM zaknOti, kintu yaH kazcit pavitrasyAtmanO viruddhAM kathAM kathayati nEhalOkE na prEtya tasyAparAdhasya kSamA bhavituM zaknOti| ");
INSERT INTO sancol_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","pAdapaM yadi bhadraM vadatha, tarhi tasya phalamapi sAdhu vaktavyaM, yadi ca pAdapaM asAdhuM vadatha, tarhi tasya phalamapyasAdhu vaktavyaM; yataH svIyasvIyaphalEna pAdapaH paricIyatE| ");
INSERT INTO sancol_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","rE bhujagavaMzA yUyamasAdhavaH santaH kathaM sAdhu vAkyaM vaktuM zakSyatha? yasmAd antaHkaraNasya pUrNabhAvAnusArAd vadanAd vacO nirgacchati| ");
INSERT INTO sancol_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","tEna sAdhurmAnavO'ntaHkaraNarUpAt sAdhubhANPAgArAt sAdhu dravyaM nirgamayati, asAdhurmAnuSastvasAdhubhANPAgArAd asAdhuvastUni nirgamayati| ");
INSERT INTO sancol_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","kintvahaM yuSmAn vadAmi, manujA yAvantyAlasyavacAMsi vadanti, vicAradinE taduttaramavazyaM dAtavyaM, ");
INSERT INTO sancol_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","yatastvaM svIyavacObhi rniraparAdhaH svIyavacObhizca sAparAdhO gaNiSyasE| ");
INSERT INTO sancol_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","tadAnIM katipayA upAdhyAyAH phirUzinazca jagaduH, hE gurO vayaM bhavattaH kinjcana lakSma didRkSAmaH| ");
INSERT INTO sancol_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","tadA sa pratyuktavAn, duSTO vyabhicArI ca vaMzO lakSma mRgayatE, kintu bhaviSyadvAdinO yUnasO lakSma vihAyAnyat kimapi lakSma tE na pradarzayiSyantE| ");
INSERT INTO sancol_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","yatO yUnam yathA tryahOrAtraM bRhanmInasya kukSAvAsIt, tathA manujaputrOpi tryahOrAtraM mEdinyA madhyE sthAsyati| ");
INSERT INTO sancol_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","aparaM nInivIyA mAnavA vicAradina EtadvaMzIyAnAM pratikUlam utthAya tAn dOSiNaH kariSyanti, yasmAttE yUnasa upadEzAt manAMsi parAvarttayAnjcakrirE, kintvatra yUnasOpi gurutara Eka AstE| ");
INSERT INTO sancol_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","punazca dakSiNadEzIyA rAjnjI vicAradina EtadvaMzIyAnAM pratikUlamutthAya tAn dOSiNaH kariSyati yataH sA rAjnjI sulEmanO vidyAyAH kathAM zrOtuM mEdinyAH sImna Agacchat, kintu sulEmanOpi gurutara EkO janO'tra AstE| ");
INSERT INTO sancol_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","aparaM manujAd bahirgatO 'pavitrabhUtaH zuSkasthAnEna gatvA vizrAmaM gavESayati, kintu tadalabhamAnaH sa vakti, yasmA; nikEtanAd AgamaM, tadEva vEzma pakAvRtya yAmi| ");
INSERT INTO sancol_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","pazcAt sa tat sthAnam upasthAya tat zUnyaM mArjjitaM zObhitanjca vilOkya vrajan svatOpi duSTatarAn anyasaptabhUtAn sagginaH karOti| ");
INSERT INTO sancol_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","tatastE tat sthAnaM pravizya nivasanti, tEna tasya manujasya zESadazA pUrvvadazAtOtIvAzubhA bhavati, EtESAM duSTavaMzyAnAmapi tathaiva ghaTiSyatE| ");
INSERT INTO sancol_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","mAnavEbhya EtAsAM kathanAM kathanakAlE tasya mAtA sahajAzca tEna sAkaM kAnjcit kathAM kathayituM vAnjchantO bahirEva sthitavantaH| ");
INSERT INTO sancol_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","tataH kazcit tasmai kathitavAn, pazya tava jananI sahajAzca tvayA sAkaM kAnjcana kathAM kathayituM kAmayamAnA bahistiSThanti| ");
INSERT INTO sancol_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","kintu sa taM pratyavadat, mama kA jananI? kE vA mama sahajAH? ");
INSERT INTO sancol_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","pazcAt ziSyAn prati karaM prasAryya kathitavAn, pazya mama jananI mama sahajAzcaitE; ");
INSERT INTO sancol_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","yaH kazcit mama svargasthasya pituriSTaM karmma kurutE, saEva mama bhrAtA bhaginI jananI ca| ");
INSERT INTO sancol_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","aparanjca tasmin dinE yIzuH sadmanO gatvA saritpatE rOdhasi samupavivEza| ");
INSERT INTO sancol_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","tatra tatsannidhau bahujanAnAM nivahOpasthitEH sa taraNimAruhya samupAvizat, tEna mAnavA rOdhasi sthitavantaH| ");
INSERT INTO sancol_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","tadAnIM sa dRSTAntaistAn itthaM bahuza upadiSTavAn| pazyata, kazcit kRSIvalO bIjAni vaptuM bahirjagAma, ");
INSERT INTO sancol_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","tasya vapanakAlE katipayabIjESu mArgapArzvE patitESu vihagAstAni bhakSitavantaH| ");
INSERT INTO sancol_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","aparaM katipayabIjESu stOkamRdyuktapASANE patitESu mRdalpatvAt tatkSaNAt tAnyagkuritAni, ");
INSERT INTO sancol_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","kintu ravAvuditE dagdhAni tESAM mUlApraviSTatvAt zuSkatAM gatAni ca| ");
INSERT INTO sancol_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","aparaM katipayabIjESu kaNTakAnAM madhyE patitESu kaNTakAnyEdhitvA tAni jagrasuH| ");
INSERT INTO sancol_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","aparanjca katipayabIjAni urvvarAyAM patitAni; tESAM madhyE kAnicit zataguNAni kAnicit SaSTiguNAni kAnicit triMzaguMNAni phalAni phalitavanti| ");
INSERT INTO sancol_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","zrOtuM yasya zrutI AsAtE sa zRNuyAt| ");
INSERT INTO sancol_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","anantaraM ziSyairAgatya sO'pRcchyata, bhavatA tEbhyaH kutO dRSTAntakathA kathyatE? ");
INSERT INTO sancol_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","tataH sa pratyavadat, svargarAjyasya nigUPhAM kathAM vEdituM yuSmabhyaM sAmarthyamadAyi, kintu tEbhyO nAdAyi| ");
INSERT INTO sancol_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","yasmAd yasyAntikE varddhatE, tasmAyEva dAyiSyatE, tasmAt tasya bAhulyaM bhaviSyati, kintu yasyAntikE na varddhatE, tasya yat kinjcanAstE, tadapi tasmAd AdAyiSyatE| ");
INSERT INTO sancol_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","tE pazyantOpi na pazyanti, zRNvantOpi na zRNvanti, budhyamAnA api na budhyantE ca, tasmAt tEbhyO dRSTAntakathA kathyatE| ");
INSERT INTO sancol_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","yathA karNaiH zrOSyatha yUyaM vai kintu yUyaM na bhOtsyatha| nEtrairdrakSyatha yUyanjca parijnjAtuM na zakSyatha| tE mAnuSA yathA naiva paripazyanti lOcanaiH| karNai ryathA na zRNvanti na budhyantE ca mAnasaiH| vyAvarttitESu cittESu kAlE kutrApi tairjanaiH| mattastE manujAH svasthA yathA naiva bhavanti ca| tathA tESAM manuSyANAM kriyantE sthUlabuddhayaH| badhirIbhUtakarNAzca jAtAzca mudritA dRzaH| ");
INSERT INTO sancol_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","yadEtAni vacanAni yizayiyabhaviSyadvAdinA prOktAni tESu tAni phalanti| ");
INSERT INTO sancol_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","kintu yuSmAkaM nayanAni dhanyAni, yasmAt tAni vIkSantE; dhanyAzca yuSmAkaM zabdagrahAH, yasmAt tairAkarNyatE| ");
INSERT INTO sancol_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","mayA yUyaM tathyaM vacAmi yuSmAbhi ryadyad vIkSyatE, tad bahavO bhaviSyadvAdinO dhArmmikAzca mAnavA didRkSantOpi draSTuM nAlabhanta, punazca yUyaM yadyat zRNutha, tat tE zuzrUSamANA api zrOtuM nAlabhanta| ");
INSERT INTO sancol_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","kRSIvalIyadRSTAntasyArthaM zRNuta| ");
INSERT INTO sancol_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","mArgapArzvE bIjAnyuptAni tasyArtha ESaH, yadA kazcit rAjyasya kathAM nizamya na budhyatE, tadA pApAtmAgatya tadIyamanasa uptAM kathAM haran nayati| ");
INSERT INTO sancol_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","aparaM pASANasthalE bIjAnyuptAni tasyArtha ESaH; kazcit kathAM zrutvaiva harSacittEna gRhlAti, ");
INSERT INTO sancol_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","kintu tasya manasi mUlApraviSTatvAt sa kinjcitkAlamAtraM sthirastiSThati; pazcAta tatkathAkAraNAt kOpi klEstAPanA vA cEt jAyatE, tarhi sa tatkSaNAd vighnamEti| ");
INSERT INTO sancol_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","aparaM kaNTakAnAM madhyE bIjAnyuptAni tadartha ESaH; kEnacit kathAyAM zrutAyAM sAMsArikacintAbhi rbhrAntibhizca sA grasyatE, tEna sA mA viphalA bhavati| ");
INSERT INTO sancol_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","aparam urvvarAyAM bIjAnyuptAni tadartha ESaH; yE tAM kathAM zrutvA vudhyantE, tE phalitAH santaH kEcit zataguNAni kEcita SaSTiguNAni kEcicca triMzadguNAni phalAni janayanti| ");
INSERT INTO sancol_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","anantaraM sOparAmEkAM dRSTAntakathAmupasthApya tEbhyaH kathayAmAsa; svargIyarAjyaM tAdRzEna kEnacid gRhasthEnOpamIyatE, yEna svIyakSEtrE prazastabIjAnyaupyanta| ");
INSERT INTO sancol_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","kintu kSaNadAyAM sakalalOkESu suptESu tasya ripurAgatya tESAM gOdhUmabIjAnAM madhyE vanyayavamabIjAnyuptvA vavrAja| ");
INSERT INTO sancol_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","tatO yadA bIjEbhyO'gkarA jAyamAnAH kaNizAni ghRtavantaH; tadA vanyayavasAnyapi dRzyamAnAnyabhavan| ");
INSERT INTO sancol_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","tatO gRhasthasya dAsEyA Agamya tasmai kathayAnjcakruH, hE mahEccha, bhavatA kiM kSEtrE bhadrabIjAni naupyanta? tathAtvE vanyayavasAni kRta Ayan? ");
INSERT INTO sancol_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","tadAnIM tEna tE pratigaditAH, kEnacit ripuNA karmmadamakAri| dAsEyAH kathayAmAsuH, vayaM gatvA tAnyutpAyya kSipAmO bhavataH kIdRzIcchA jAyatE? ");
INSERT INTO sancol_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","tEnAvAdi, nahi, zagkE'haM vanyayavasOtpATanakAlE yuSmAbhistaiH sAkaM gOdhUmA apyutpATiSyantE| ");
INSERT INTO sancol_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ataH zsyakarttanakAlaM yAvad ubhayAnyapi saha varddhantAM, pazcAt karttanakAlE karttakAn vakSyAmi, yUyamAdau vanyayavasAni saMgRhya dAhayituM vITikA badvvA sthApayata; kintu sarvvE gOdhUmA yuSmAbhi rbhANPAgAraM nItvA sthApyantAm| ");
INSERT INTO sancol_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","anantaraM sOparAmEkAM dRSTAntakathAmutthApya tEbhyaH kathitavAn kazcinmanujaH sarSapabIjamEkaM nItvA svakSEtra uvApa| ");
INSERT INTO sancol_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","sarSapabIjaM sarvvasmAd bIjAt kSudramapi sadagkuritaM sarvvasmAt zAkAt bRhad bhavati; sa tAdRzastaru rbhavati, yasya zAkhAsu nabhasaH khagA Agatya nivasanti; svargIyarAjyaM tAdRzasya sarSapaikasya samam| ");
INSERT INTO sancol_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","punarapi sa upamAkathAmEkAM tEbhyaH kathayAnjcakAra; kAcana yOSit yat kiNvamAdAya drONatrayamitagOdhUmacUrNAnAM madhyE sarvvESAM mizrIbhavanaparyyantaM samAcchAdya nidhattavatI, tatkiNvamiva svargarAjyaM| ");
INSERT INTO sancol_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","itthaM yIzu rmanujanivahAnAM sannidhAvupamAkathAbhirEtAnyAkhyAnAni kathitavAn upamAM vinA tEbhyaH kimapi kathAM nAkathayat| ");
INSERT INTO sancol_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","EtEna dRSTAntIyEna vAkyEna vyAdAya vadanaM nijaM| ahaM prakAzayiSyAmi guptavAkyaM purAbhavaM| yadEtadvacanaM bhaviSyadvAdinA prOktamAsIt, tat siddhamabhavat| ");
INSERT INTO sancol_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","sarvvAn manujAn visRjya yIzau gRhaM praviSTE tacchiSyA Agatya yIzavE kathitavantaH, kSEtrasya vanyayavasIyadRSTAntakathAm bhavAna asmAn spaSTIkRtya vadatu| ");
INSERT INTO sancol_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","tataH sa pratyuvAca, yEna bhadrabIjAnyupyantE sa manujaputraH, ");
INSERT INTO sancol_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","kSEtraM jagat, bhadrabIjAnI rAjyasya santAnAH, ");
INSERT INTO sancol_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","vanyayavasAni pApAtmanaH santAnAH| yEna ripuNA tAnyuptAni sa zayatAnaH, karttanasamayazca jagataH zESaH, karttakAH svargIyadUtAH| ");
INSERT INTO sancol_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","yathA vanyayavasAni saMgRhya dAhyantE, tathA jagataH zESE bhaviSyati; ");
INSERT INTO sancol_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","arthAt manujasutaH svAMyadUtAn prESayiSyati, tEna tE ca tasya rAjyAt sarvvAn vighnakAriNO'dhArmmikalOkAMzca saMgRhya ");
INSERT INTO sancol_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","yatra rOdanaM dantagharSaNanjca bhavati, tatrAgnikuNPE nikSEpsyanti| ");
INSERT INTO sancol_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","tadAnIM dhArmmikalOkAH svESAM pitU rAjyE bhAskara_iva tEjasvinO bhaviSyanti| zrOtuM yasya zrutI AsAtE, ma zRNuyAt| ");
INSERT INTO sancol_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","aparanjca kSEtramadhyE nidhiM pazyan yO gOpayati, tataH paraM sAnandO gatvA svIyasarvvasvaM vikrIya ttakSEtraM krINAti, sa iva svargarAjyaM| ");
INSERT INTO sancol_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","anyanjca yO vaNik uttamAM muktAM gavESayan ");
INSERT INTO sancol_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","mahArghAM muktAM vilOkya nijasarvvasvaM vikrIya tAM krINAti, sa iva svargarAjyaM| ");
INSERT INTO sancol_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","punazca samudrO nikSiptaH sarvvaprakAramInasaMgrAhyAnAya_iva svargarAjyaM| ");
INSERT INTO sancol_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","tasmin AnAyE pUrNE janA yathA rOdhasyuttOlya samupavizya prazastamInAn saMgrahya bhAjanESu nidadhatE, kutsitAn nikSipanti; ");
INSERT INTO sancol_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","tathaiva jagataH zESE bhaviSyati, phalataH svargIyadUtA Agatya puNyavajjanAnAM madhyAt pApinaH pRthak kRtvA vahnikuNPE nikSEpsyanti, ");
INSERT INTO sancol_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","tatra rOdanaM dantai rdantagharSaNanjca bhaviSyataH| ");
INSERT INTO sancol_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","yIzunA tE pRSTA yuSmAbhiH kimEtAnyAkhyAnAnyabudhyanta? tadA tE pratyavadan, satyaM prabhO| ");
INSERT INTO sancol_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","tadAnIM sa kathitavAn, nijabhANPAgArAt navInapurAtanAni vastUni nirgamayati yO gRhasthaH sa iva svargarAjyamadhi zikSitAH svarva upadESTAraH| ");
INSERT INTO sancol_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","anantaraM yIzurEtAH sarvvA dRSTAntakathAH samApya tasmAt sthAnAt pratasthE| aparaM svadEzamAgatya janAn bhajanabhavana upadiSTavAn; ");
INSERT INTO sancol_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","tE vismayaM gatvA kathitavanta EtasyaitAdRzaM jnjAnam AzcaryyaM karmma ca kasmAd ajAyata? ");
INSERT INTO sancol_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","kimayaM sUtradhArasya putrO nahi? Etasya mAtu rnAma ca kiM mariyam nahi? yAkub-yUSaph-zimOn-yihUdAzca kimEtasya bhrAtarO nahi? ");
INSERT INTO sancol_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Etasya bhaginyazca kimasmAkaM madhyE na santi? tarhi kasmAdayamEtAni labdhavAn? itthaM sa tESAM vighnarUpO babhUva; ");
INSERT INTO sancol_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","tatO yIzunA nigaditaM svadEzIyajanAnAM madhyaM vinA bhaviSyadvAdI kutrApyanyatra nAsammAnyO bhavatI| ");
INSERT INTO sancol_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","tESAmavizvAsahEtOH sa tatra sthAnE bahvAzcaryyakarmmANi na kRtavAn| ");
INSERT INTO sancol_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","tadAnIM rAjA hErOd yIzO ryazaH zrutvA nijadAsEyAn jagAd, ");
INSERT INTO sancol_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ESa majjayitA yOhan, pramitEbhayastasyOtthAnAt tEnEtthamadbhutaM karmma prakAzyatE| ");
INSERT INTO sancol_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","purA hErOd nijabhrAtu: philipO jAyAyA hErOdIyAyA anurOdhAd yOhanaM dhArayitvA baddhA kArAyAM sthApitavAn| ");
INSERT INTO sancol_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","yatO yOhan uktavAn, EtsayAH saMgrahO bhavatO nOcitaH| ");
INSERT INTO sancol_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","tasmAt nRpatistaM hantumicchannapi lOkEbhyO vibhayAnjcakAra; yataH sarvvE yOhanaM bhaviSyadvAdinaM mEnirE| ");
INSERT INTO sancol_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","kintu hErOdO janmAhIyamaha upasthitE hErOdIyAyA duhitA tESAM samakSaM nRtitvA hErOdamaprINyat| ");
INSERT INTO sancol_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","tasmAt bhUpatiH zapathaM kurvvan iti pratyajnjAsIt, tvayA yad yAcyatE, tadEvAhaM dAsyAmi| ");
INSERT INTO sancol_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","sA kumArI svIyamAtuH zikSAM labdhA babhASE, majjayituryOhana uttamAggaM bhAjanE samAnIya mahyaM vizrANaya| ");
INSERT INTO sancol_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","tatO rAjA zuzOca, kintu bhOjanAyOpavizatAM sagginAM svakRtazapathasya cAnurOdhAt tat pradAtuma AdidEza| ");
INSERT INTO sancol_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","pazcAt kArAM prati naraM prahitya yOhana uttamAggaM chittvA ");
INSERT INTO sancol_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","tat bhAjana AnAyya tasyai kumAryyai vyazrANayat, tataH sA svajananyAH samIpaM tanninAya| ");
INSERT INTO sancol_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","pazcAt yOhanaH ziSyA Agatya kAyaM nItvA zmazAnE sthApayAmAsustatO yIzOH sannidhiM vrajitvA tadvArttAM babhASirE| ");
INSERT INTO sancol_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","anantaraM yIzuriti nizabhya nAvA nirjanasthAnam EkAkI gatavAn, pazcAt mAnavAstat zrutvA nAnAnagarEbhya Agatya padaistatpazcAd IyuH| ");
INSERT INTO sancol_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","tadAnIM yIzu rbahirAgatya mahAntaM jananivahaM nirIkSya tESu kAruNikaH man tESAM pIPitajanAn nirAmayAn cakAra| ");
INSERT INTO sancol_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","tataH paraM sandhyAyAM ziSyAstadantikamAgatya kathayAnjcakruH, idaM nirjanasthAnaM vElApyavasannA; tasmAt manujAn svasvagrAmaM gantuM svArthaM bhakSyANi krEtunjca bhavAn tAn visRjatu| ");
INSERT INTO sancol_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","kintu yIzustAnavAdIt, tESAM gamanE prayOjanaM nAsti, yUyamEva tAn bhOjayata| ");
INSERT INTO sancol_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","tadA tE pratyavadan, asmAkamatra pUpapanjcakaM mInadvayanjcAstE| ");
INSERT INTO sancol_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","tadAnIM tEnOktaM tAni madantikamAnayata| ");
INSERT INTO sancol_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","anantaraM sa manujAn yavasOparyyupavESTum AjnjApayAmAsa; apara tat pUpapanjcakaM mInadvayanjca gRhlan svargaM prati nirIkSyEzvarIyaguNAn anUdya bhaMktvA ziSyEbhyO dattavAn, ziSyAzca lOkEbhyO daduH| ");
INSERT INTO sancol_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","tataH sarvvE bhuktvA paritRptavantaH, tatastadavaziSTabhakSyaiH pUrNAn dvAdazaPalakAn gRhItavantaH| ");
INSERT INTO sancol_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","tE bhOktAraH strIrbAlakAMzca vihAya prAyENa panjca sahasrANi pumAMsa Asan| ");
INSERT INTO sancol_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","tadanantaraM yIzu rlOkAnAM visarjanakAlE ziSyAn taraNimArOPhuM svAgrE pAraM yAtunjca gAPhamAdiSTavAn| ");
INSERT INTO sancol_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","tatO lOkESu visRSTESu sa viviktE prArthayituM girimEkaM gatvA sandhyAM yAvat tatraikAkI sthitavAn| ");
INSERT INTO sancol_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","kintu tadAnIM sammukhavAtatvAt saritpatE rmadhyE taraggaistaraNirdOlAyamAnAbhavat| ");
INSERT INTO sancol_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","tadA sa yAminyAzcaturthapraharE padbhyAM vrajan tESAmantikaM gatavAn| ");
INSERT INTO sancol_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","kintu ziSyAstaM sAgarOpari vrajantaM vilOkya samudvignA jagaduH, ESa bhUta iti zagkamAnA uccaiH zabdAyAnjcakrirE ca| ");
INSERT INTO sancol_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","tadaiva yIzustAnavadat, susthirA bhavata, mA bhaiSTa, ESO'ham| ");
INSERT INTO sancol_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","tataH pitara ityuktavAn, hE prabhO, yadi bhavAnEva, tarhi mAM bhavatsamIpaM yAtumAjnjApayatu| ");
INSERT INTO sancol_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","tataH tEnAdiSTaH pitarastaraNitO'varuhya yIzEाrantikaM prAptuM tOyOpari vavrAja| ");
INSERT INTO sancol_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","kintu pracaNPaM pavanaM vilOkya bhayAt tOyE maMktum ArEbhE, tasmAd uccaiH zabdAyamAnaH kathitavAn, hE prabhO, mAmavatu| ");
INSERT INTO sancol_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","yIzustatkSaNAt karaM prasAryya taM dharan uktavAn, ha stOkapratyayin tvaM kutaH samazEthAH? ");
INSERT INTO sancol_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","anantaraM tayOstaraNimArUPhayOH pavanO nivavRtE| ");
INSERT INTO sancol_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","tadAnIM yE taraNyAmAsan, ta Agatya taM praNabhya kathitavantaH, yathArthastvamEvEzvarasutaH| ");
INSERT INTO sancol_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","anantaraM pAraM prApya tE ginESarannAmakaM nagaramupatasthuH, ");
INSERT INTO sancol_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","tadA tatratyA janA yIzuM paricIya taddEzsya caturdizO vArttAM prahitya yatra yAvantaH pIPitA Asan, tAvataEva tadantikamAnayAmAsuH| ");
INSERT INTO sancol_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","aparaM tadIyavasanasya granthimAtraM spraSTuM vinIya yAvantO janAstat sparzaM cakrirE, tE sarvvaEva nirAmayA babhUvuH| ");
INSERT INTO sancol_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","aparaM yirUzAlamnagarIyAH katipayA adhyApakAH phirUzinazca yIzOH samIpamAgatya kathayAmAsuH, ");
INSERT INTO sancol_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","tava ziSyAH kimartham aprakSAlitakarai rbhakSitvA paramparAgataM prAcInAnAM vyavahAraM lagvantE? ");
INSERT INTO sancol_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","tatO yIzuH pratyuvAca, yUyaM paramparAgatAcArENa kuta IzvarAjnjAM lagvadhvE| ");
INSERT INTO sancol_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Izvara ityAjnjApayat, tvaM nijapitarau saMmanyEthAH, yEna ca nijapitarau nindyEtE, sa nizcitaM mriyEta; ");
INSERT INTO sancol_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","kintu yUyaM vadatha, yaH svajanakaM svajananIM vA vAkyamidaM vadati, yuvAM mattO yallabhEthE, tat nyavidyata, ");
INSERT INTO sancol_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","sa nijapitarau puna rna saMmaMsyatE| itthaM yUyaM paramparAgatEna svESAmAcArENEzvarIyAjnjAM lumpatha| ");
INSERT INTO sancol_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","rE kapaTinaH sarvvE yizayiyO yuSmAnadhi bhaviSyadvacanAnyEtAni samyag uktavAn| ");
INSERT INTO sancol_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","vadanai rmanujA EtE samAyAnti madantikaM| tathAdharai rmadIyanjca mAnaM kurvvanti tE narAH| ");
INSERT INTO sancol_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","kintu tESAM manO mattO vidUraEva tiSThati| zikSayantO vidhIn nrAjnjA bhajantE mAM mudhaiva tE| ");
INSERT INTO sancol_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","tatO yIzu rlOkAn AhUya prOktavAn, yUyaM zrutvA budhyadhbaM| ");
INSERT INTO sancol_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","yanmukhaM pravizati, tat manujam amEdhyaM na karOti, kintu yadAsyAt nirgacchati, tadEva mAnuSamamEdhyI karOtI| ");
INSERT INTO sancol_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","tadAnIM ziSyA Agatya tasmai kathayAnjcakruH, EtAM kathAM zrutvA phirUzinO vyarajyanta, tat kiM bhavatA jnjAyatE? ");
INSERT INTO sancol_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","sa pratyavadat, mama svargasthaH pitA yaM kanjcidagkuraM nArOpayat, sa utpAvdyatE| ");
INSERT INTO sancol_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","tE tiSThantu, tE andhamanujAnAm andhamArgadarzakA Eva; yadyandhO'ndhaM panthAnaM darzayati, tarhyubhau garttE patataH| ");
INSERT INTO sancol_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","tadA pitarastaM pratyavadat, dRSTAntamimamasmAn bOdhayatu| ");
INSERT INTO sancol_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","yIzunA prOktaM, yUyamadya yAvat kimabOdhAH stha? ");
INSERT INTO sancol_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","kathAmimAM kiM na budhyadhbE ? yadAsyaM prEvizati, tad udarE patan bahirniryAti, ");
INSERT INTO sancol_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","kintvAsyAd yanniryAti, tad antaHkaraNAt niryAtatvAt manujamamEdhyaM karOti| ");
INSERT INTO sancol_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","yatO'ntaHkaraNAt kucintA badhaH pAradArikatA vEzyAgamanaM cairyyaM mithyAsAkSyam IzvaranindA caitAni sarvvANi niryyAnti| ");
INSERT INTO sancol_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","EtAni manuSyamapavitrI kurvvanti kintvaprakSAlitakarENa bhOjanaM manujamamEdhyaM na karOti| ");
INSERT INTO sancol_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","anantaraM yIzustasmAt sthAnAt prasthAya sOrasIdOnnagarayOH sImAmupatasyau| ");
INSERT INTO sancol_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","tadA tatsImAtaH kAcit kinAnIyA yOSid Agatya tamuccairuvAca, hE prabhO dAyUdaH santAna, mamaikA duhitAstE sA bhUtagrastA satI mahAklEzaM prApnOti mama dayasva| ");
INSERT INTO sancol_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","kintu yIzustAM kimapi nOktavAn, tataH ziSyA Agatya taM nivEdayAmAsuH, ESA yOSid asmAkaM pazcAd uccairAhUyAgacchati, EnAM visRjatu| ");
INSERT INTO sancol_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","tadA sa pratyavadat, isrAyElgOtrasya hAritamESAn vinA kasyApyanyasya samIpaM nAhaM prESitOsmi| ");
INSERT INTO sancol_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","tataH sA nArIsamAgatya taM praNamya jagAda, hE prabhO mAmupakuru| ");
INSERT INTO sancol_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","sa uktavAn, bAlakAnAM bhakSyamAdAya sAramEyEbhyO dAnaM nOcitaM| ");
INSERT INTO sancol_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","tadA sA babhASE, hE prabhO, tat satyaM, tathApi prabhO rbhanjcAd yaducchiSTaM patati, tat sAramEyAH khAdanti| ");
INSERT INTO sancol_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","tatO yIzuH pratyavadat, hE yOSit, tava vizvAsO mahAn tasmAt tava manObhilaSitaM sidyyatu, tEna tasyAH kanyA tasminnEva daNPE nirAmayAbhavat| ");
INSERT INTO sancol_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","anantaraM yIzastasmAt sthAnAt prasthAya gAlIlsAgarasya sannidhimAgatya dharAdharamAruhya tatrOpavivEza| ");
INSERT INTO sancol_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","pazcAt jananivahO bahUn khanjcAndhamUkazuSkakaramAnuSAn AdAya yIzOH samIpamAgatya taccaraNAntikE sthApayAmAsuH, tataH sA tAn nirAmayAn akarOt| ");
INSERT INTO sancol_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","itthaM mUkA vAkyaM vadanti, zuSkakarAH svAsthyamAyAnti, paggavO gacchanti, andhA vIkSantE, iti vilOkya lOkA vismayaM manyamAnA isrAyEla IzvaraM dhanyaM babhASirE| ");
INSERT INTO sancol_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","tadAnIM yIzuH svaziSyAn AhUya gaditavAn, EtajjananivahESu mama dayA jAyatE, EtE dinatrayaM mayA sAkaM santi, ESAM bhakSyavastu ca kanjcidapi nAsti, tasmAdahamEtAnakRtAhArAn na visrakSyAmi, tathAtvE vartmamadhyE klAmyESuH| ");
INSERT INTO sancol_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","tadA ziSyA UcuH, Etasmin prAntaramadhya EtAvatO martyAn tarpayituM vayaM kutra pUpAn prApsyAmaH? ");
INSERT INTO sancol_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","yIzurapRcchat, yuSmAkaM nikaTE kati pUpA AsatE? ta UcuH, saptapUpA alpAH kSudramInAzca santi| ");
INSERT INTO sancol_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","tadAnIM sa lOkanivahaM bhUmAvupavESTum Adizya ");
INSERT INTO sancol_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","tAn saptapUpAn mInAMzca gRhlan IzvarIyaguNAn anUdya bhaMktvA ziSyEbhyO dadau, ziSyA lOkEbhyO daduH| ");
INSERT INTO sancol_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","tataH sarvvE bhuktvA tRptavantaH; tadavaziSTabhakSyENa saptaPalakAn paripUryya saMjagRhuH| ");
INSERT INTO sancol_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","tE bhOktArO yOSitO bAlakAMzca vihAya prAyENa catuHsahasrANi puruSA Asan| ");
INSERT INTO sancol_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","tataH paraM sa jananivahaM visRjya tarimAruhya magdalApradEzaM gatavAn| ");
INSERT INTO sancol_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","tadAnIM phirUzinaH sidUkinazcAgatya taM parIkSituM nabhamIyaM kinjcana lakSma darzayituM tasmai nivEdayAmAsuH| ");
INSERT INTO sancol_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","tataH sa uktavAn, sandhyAyAM nabhasO raktatvAd yUyaM vadatha, zvO nirmmalaM dinaM bhaviSyati; ");
INSERT INTO sancol_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","prAtaHkAlE ca nabhasO raktatvAt malinatvAnjca vadatha, jhanjbhzadya bhaviSyati| hE kapaTinO yadi yUyam antarIkSasya lakSma bOddhuM zaknutha, tarhi kAlasyaitasya lakSma kathaM bOddhuM na zaknutha? ");
INSERT INTO sancol_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","EtatkAlasya duSTO vyabhicArI ca vaMzO lakSma gavESayati, kintu yUnasO bhaviSyadvAdinO lakSma vinAnyat kimapi lakSma tAn na darzayiyyatE| tadAnIM sa tAn vihAya pratasthE| ");
INSERT INTO sancol_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","anantaramanyapAragamanakAlE tasya ziSyAH pUpamAnEtuM vismRtavantaH| ");
INSERT INTO sancol_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","yIzustAnavAdIt, yUyaM phirUzinAM sidUkinAnjca kiNvaM prati sAvadhAnAH satarkAzca bhavata| ");
INSERT INTO sancol_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","tEna tE parasparaM vivicya kathayitumArEbhirE, vayaM pUpAnAnEtuM vismRtavanta EtatkAraNAd iti kathayati| ");
INSERT INTO sancol_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","kintu yIzustadvijnjAya tAnavOcat, hE stOkavizvAsinO yUyaM pUpAnAnayanamadhi kutaH parasparamEtad viviMkya? ");
INSERT INTO sancol_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","yuSmAbhiH kimadyApi na jnjAyatE? panjcabhiH pUpaiH panjcasahasrapuruSESu bhOjitESu bhakSyOcchiSTapUrNAn kati PalakAn samagRhlItaM; ");
INSERT INTO sancol_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","tathA saptabhiH pUpaizcatuHsahasrapuruSESu bhEjitESu kati PalakAn samagRhlIta, tat kiM yuSmAbhirna smaryyatE? ");
INSERT INTO sancol_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","tasmAt phirUzinAM sidUkinAnjca kiNvaM prati sAvadhAnAstiSThata, kathAmimAm ahaM pUpAnadhi nAkathayaM, Etad yUyaM kutO na budhyadhvE? ");
INSERT INTO sancol_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","tadAnIM pUpakiNvaM prati sAvadhAnAstiSThatEti nOktvA phirUzinAM sidUkinAnjca upadEzaM prati sAvadhAnAstiSThatEti kathitavAn, iti tairabOdhi| ");
INSERT INTO sancol_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","aparanjca yIzuH kaisariyA-philipipradEzamAgatya ziSyAn apRcchat, yO'haM manujasutaH sO'haM kaH? lOkairahaM kimucyE? ");
INSERT INTO sancol_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","tadAnIM tE kathitavantaH, kEcid vadanti tvaM majjayitA yOhan, kEcidvadanti, tvam EliyaH, kEcicca vadanti, tvaM yirimiyO vA kazcid bhaviSyadvAdIti| ");
INSERT INTO sancol_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","pazcAt sa tAn papraccha, yUyaM mAM kaM vadatha? tataH zimOn pitara uvAca, ");
INSERT INTO sancol_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","tvamamarEzvarasyAbhiSiktaputraH| ");
INSERT INTO sancol_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","tatO yIzuH kathitavAn, hE yUnasaH putra zimOn tvaM dhanyaH; yataH kOpi anujastvayyEtajjnjAnaM nOdapAdayat, kintu mama svargasyaH pitOdapAdayat| ");
INSERT INTO sancol_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","atO'haM tvAM vadAmi, tvaM pitaraH (prastaraH) ahanjca tasya prastarasyOpari svamaNPalIM nirmmAsyAmi, tEna nirayO balAt tAM parAjEtuM na zakSyati| ");
INSERT INTO sancol_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","ahaM tubhyaM svargIyarAjyasya kunjjikAM dAsyAmi, tEna yat kinjcana tvaM pRthivyAM bhaMtsyasi tatsvargE bhaMtsyatE, yacca kinjcana mahyAM mOkSyasi tat svargE mOkSyatE| ");
INSERT INTO sancol_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","pazcAt sa ziSyAnAdizat, ahamabhiSiktO yIzuriti kathAM kasmaicidapi yUyaM mA kathayata| ");
INSERT INTO sancol_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","anyanjca yirUzAlamnagaraM gatvA prAcInalOkEbhyaH pradhAnayAjakEbhya upAdhyAyEbhyazca bahuduHkhabhOgastai rhatatvaM tRtIyadinE punarutthAnanjca mamAvazyakam EtAH kathA yIzustatkAlamArabhya ziSyAn jnjApayitum ArabdhavAn| ");
INSERT INTO sancol_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","tadAnIM pitarastasya karaM ghRtvA tarjayitvA kathayitumArabdhavAn, hE prabhO, tat tvattO dUraM yAtu, tvAM prati kadApi na ghaTiSyatE| ");
INSERT INTO sancol_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","kintu sa vadanaM parAvartya pitaraM jagAda, hE vighnakArin, matsammukhAd dUrIbhava, tvaM mAM bAdhasE, IzvarIyakAryyAt mAnuSIyakAryyaM tubhyaM rOcatE| ");
INSERT INTO sancol_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","anantaraM yIzuH svIyaziSyAn uktavAn yaH kazcit mama pazcAdgAmI bhavitum icchati, sa svaM dAmyatu, tathA svakruzaM gRhlan matpazcAdAyAtu| ");
INSERT INTO sancol_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","yatO yaH prANAn rakSitumicchati, sa tAn hArayiSyati, kintu yO madarthaM nijaprANAn hArayati, sa tAn prApsyati| ");
INSERT INTO sancol_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","mAnuSO yadi sarvvaM jagat labhatE nijapraNAn hArayati, tarhi tasya kO lAbhaH? manujO nijaprANAnAM vinimayEna vA kiM dAtuM zaknOti? ");
INSERT INTO sancol_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","manujasutaH svadUtaiH sAkaM pituH prabhAvENAgamiSyati; tadA pratimanujaM svasvakarmmAnusArAt phalaM dAsyati| ");
INSERT INTO sancol_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","ahaM yuSmAn tathyaM vacmi, sarAjyaM manujasutam AgataM na pazyantO mRtyuM na svAdiSyanti, EtAdRzAH katipayajanA atrApi daNPAyamAnAH santi| ");
INSERT INTO sancol_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","anantaraM SaPdinEbhyaH paraM yIzuH pitaraM yAkUbaM tatsahajaM yOhananjca gRhlan uccAdrE rviviktasthAnam Agatya tESAM samakSaM rUpamanyat dadhAra| ");
INSERT INTO sancol_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","tEna tadAsyaM tEjasvi, tadAbharaNam AlOkavat pANParamabhavat| ");
INSERT INTO sancol_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","anyacca tEna sAkaM saMlapantau mUsA Eliyazca tEbhyO darzanaM dadatuH| ");
INSERT INTO sancol_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","tadAnIM pitarO yIzuM jagAda, hE prabhO sthitiratrAsmAkaM zubhA, yadi bhavatAnumanyatE, tarhi bhavadarthamEkaM mUsArthamEkam EliyArthanjcaikam iti trINi dUSyANi nirmmama| ");
INSERT INTO sancol_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","EtatkathanakAla Eka ujjavalaH payOdastESAmupari chAyAM kRtavAn, vAridAd ESA nabhasIyA vAg babhUva, mamAyaM priyaH putraH, asmin mama mahAsantOSa Etasya vAkyaM yUyaM nizAmayata| ");
INSERT INTO sancol_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","kintu vAcamEtAM zRNvantaEva ziSyA mRzaM zagkamAnA nyubjA nyapatan| ");
INSERT INTO sancol_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","tadA yIzurAgatya tESAM gAtrANi spRzan uvAca, uttiSThata, mA bhaiSTa| ");
INSERT INTO sancol_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","tadAnIM nEtrANyunmIlya yIzuM vinA kamapi na dadRzuH| ");
INSERT INTO sancol_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","tataH param adrEravarOhaNakAlE yIzustAn ityAdidEza, manujasutasya mRtAnAM madhyAdutthAnaM yAvanna jAyatE, tAvat yuSmAbhirEtaddarzanaM kasmaicidapi na kathayitavyaM| ");
INSERT INTO sancol_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","tadA ziSyAstaM papracchuH, prathamam Eliya AyAsyatIti kuta upAdhyAyairucyatE? ");
INSERT INTO sancol_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","tatO yIzuH pratyavAdIt, EliyaH prAgEtya sarvvANi sAdhayiSyatIti satyaM, ");
INSERT INTO sancol_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","kintvahaM yuSmAn vacmi, Eliya Etya gataH, tE tamaparicitya tasmin yathEcchaM vyavajahuH; manujasutEnApi tESAmantikE tAdRg duHkhaM bhOktavyaM| ");
INSERT INTO sancol_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","tadAnIM sa majjayitAraM yOhanamadhi kathAmEtAM vyAhRtavAn, itthaM tacchiSyA bubudhirE| ");
INSERT INTO sancol_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","pazcAt tESu jananivahasyAntikamAgatESu kazcit manujastadantikamEtya jAnUnI pAtayitvA kathitavAn, ");
INSERT INTO sancol_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","hE prabhO, matputraM prati kRpAM vidadhAtu, sOpasmArAmayEna bhRzaM vyathitaH san punaH puna rvahnau muhu rjalamadhyE patati| ");
INSERT INTO sancol_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","tasmAd bhavataH ziSyANAM samIpE tamAnayaM kintu tE taM svAsthaM karttuM na zaktAH| ");
INSERT INTO sancol_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","tadA yIzuH kathitavAn rE avizvAsinaH, rE vipathagAminaH, punaH katikAlAn ahaM yuSmAkaM sannidhau sthAsyAmi? katikAlAn vA yuSmAn sahiSyE? tamatra mamAntikamAnayata| ");
INSERT INTO sancol_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","pazcAd yIzunA tarjataEva sa bhUtastaM vihAya gatavAn, taddaNPaEva sa bAlakO nirAmayO'bhUt| ");
INSERT INTO sancol_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","tataH ziSyA guptaM yIzumupAgatya babhASirE, kutO vayaM taM bhUtaM tyAjayituM na zaktAH? ");
INSERT INTO sancol_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","yIzunA tE prOktAH, yuSmAkamapratyayAt; ");
INSERT INTO sancol_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","yuSmAnahaM tathyaM vacmi yadi yuSmAkaM sarSapaikamAtrOpi vizvAsO jAyatE, tarhi yuSmAbhirasmin zailE tvamitaH sthAnAt tat sthAnaM yAhIti brUtE sa tadaiva caliSyati, yuSmAkaM kimapyasAdhyanjca karmma na sthAsyAti| kintu prArthanOpavAsau vinaitAdRzO bhUtO na tyAjyEta| ");
INSERT INTO sancol_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","aparaM tESAM gAlIlpradEzE bhramaNakAlE yIzunA tE gaditAH, manujasutO janAnAM karESu samarpayiSyatE tai rhaniSyatE ca, ");
INSERT INTO sancol_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","kintu tRtIyE'hi्na ma utthApiSyatE, tEna tE bhRzaM duHkhitA babhUvaH| ");
INSERT INTO sancol_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","tadanantaraM tESu kapharnAhUmnagaramAgatESu karasaMgrAhiNaH pitarAntikamAgatya papracchuH, yuSmAkaM guruH kiM mandirArthaM karaM na dadAti? tataH pitaraH kathitavAn dadAti| ");
INSERT INTO sancol_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","tatastasmin gRhamadhyamAgatE tasya kathAkathanAt pUrvvamEva yIzuruvAca, hE zimOn, mEdinyA rAjAnaH svasvApatyEbhyaH kiM vidEzibhyaH kEbhyaH karaM gRhlanti? atra tvaM kiM budhyasE? tataH pitara uktavAn, vidEzibhyaH| ");
INSERT INTO sancol_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","tadA yIzuruktavAn, tarhi santAnA muktAH santi| ");
INSERT INTO sancol_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","tathApi yathAsmAbhistESAmantarAyO na janyatE, tatkRtE jaladhEstIraM gatvA vaPizaM kSipa, tEnAdau yO mIna utthAsyati, taM ghRtvA tanmukhE mOcitE tOlakaikaM rUpyaM prApsyasi, tad gRhItvA tava mama ca kRtE tEbhyO dEhi| ");
INSERT INTO sancol_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","tadAnIM ziSyA yIzOH samIpamAgatya pRSTavantaH svargarAjyE kaH zrESThaH? ");
INSERT INTO sancol_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","tatO yIzuH kSudramEkaM bAlakaM svasamIpamAnIya tESAM madhyE nidhAya jagAda, ");
INSERT INTO sancol_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","yuSmAnahaM satyaM bravImi, yUyaM manOvinimayEna kSudrabAlavat na santaH svargarAjyaM pravESTuM na zaknutha| ");
INSERT INTO sancol_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","yaH kazcid Etasya kSudrabAlakasya samamAtmAnaM namrIkarOti, saEva svargarAjayE zrESThaH| ");
INSERT INTO sancol_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","yaH kazcid EtAdRzaM kSudrabAlakamEkaM mama nAmni gRhlAti, sa mAmEva gRhlAti| ");
INSERT INTO sancol_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","kintu yO janO mayi kRtavizvAsAnAmEtESAM kSudraprANinAm EkasyApi vidhniM janayati, kaNThabaddhapESaNIkasya tasya sAgarAgAdhajalE majjanaM zrEyaH| ");
INSERT INTO sancol_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","vighnAt jagataH santApO bhaviSyati, vighnO'vazyaM janayiSyatE, kintu yEna manujEna vighnO janiSyatE tasyaiva santApO bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","tasmAt tava karazcaraNO vA yadi tvAM bAdhatE, tarhi taM chittvA nikSipa, dvikarasya dvipadasya vA tavAnaptavahnau nikSEpAt, khanjjasya vA chinnahastasya tava jIvanE pravEzO varaM| ");
INSERT INTO sancol_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","aparaM tava nEtraM yadi tvAM bAdhatE, tarhi tadapyutpAvya nikSipa, dvinEtrasya narakAgnau nikSEpAt kANasya tava jIvanE pravEzO varaM| ");
INSERT INTO sancol_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","tasmAdavadhaddhaM, EtESAM kSudraprANinAm Ekamapi mA tucchIkuruta, ");
INSERT INTO sancol_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","yatO yuSmAnahaM tathyaM bravImi, svargE tESAM dUtA mama svargasthasya piturAsyaM nityaM pazyanti| EvaM yE yE hAritAstAn rakSituM manujaputra Agacchat| ");
INSERT INTO sancol_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","yUyamatra kiM viviMgghvE? kasyacid yadi zataM mESAH santi, tESAmEkO hAryyatE ca, tarhi sa EkOnazataM mESAn vihAya parvvataM gatvA taM hAritamEkaM kiM na mRgayatE? ");
INSERT INTO sancol_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","yadi ca kadAcit tanmESOddEzaM lamatE, tarhi yuSmAnahaM satyaM kathayAmi, sO'vipathagAmibhya EkOnazatamESEbhyOpi tadEkahEtOradhikam AhlAdatE| ");
INSERT INTO sancol_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","tadvad EtESAM kSudraprAEिnAm EkOpi nazyatIti yuSmAkaM svargasthapitu rnAbhimatam| ");
INSERT INTO sancol_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","yadyapi tava bhrAtA tvayi kimapyaparAdhyati, tarhi gatvA yuvayOrdvayOH sthitayOstasyAparAdhaM taM jnjApaya| tatra sa yadi tava vAkyaM zRNOti, tarhi tvaM svabhrAtaraM prAptavAn, ");
INSERT INTO sancol_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","kintu yadi na zRNOti, tarhi dvAbhyAM tribhi rvA sAkSIbhiH sarvvaM vAkyaM yathA nizcitaM jAyatE, tadartham EkaM dvau vA sAkSiNau gRhItvA yAhi| ");
INSERT INTO sancol_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","tEna sa yadi tayO rvAkyaM na mAnyatE, tarhi samAjaM tajjnjApaya, kintu yadi samAjasyApi vAkyaM na mAnyatE,tarhi sa tava samIpE dEvapUjaka_iva caNPAla_iva ca bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","ahaM yuSmAn satyaM vadAmi, yuSmAbhiH pRthivyAM yad badhyatE tat svargE bhaMtsyatE; mEdinyAM yat bhOcyatE, svargE'pi tat mOkSyatE| ");
INSERT INTO sancol_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","punarahaM yuSmAn vadAmi, mEdinyAM yuSmAkaM yadi dvAvEkavAkyIbhUya kinjcit prArthayEtE, tarhi mama svargasthapitrA tat tayOH kRtE sampannaM bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","yatO yatra dvau trayO vA mama nAnni milanti, tatraivAhaM tESAM madhyE'smi| ");
INSERT INTO sancol_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","tadAnIM pitarastatsamIpamAgatya kathitavAn hE prabhO, mama bhrAtA mama yadyaparAdhyati, tarhi taM katikRtvaH kSamiSyE? ");
INSERT INTO sancol_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","kiM saptakRtvaH? yIzustaM jagAda, tvAM kEvalaM saptakRtvO yAvat na vadAmi, kintu saptatyA guNitaM saptakRtvO yAvat| ");
INSERT INTO sancol_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","aparaM nijadAsaiH saha jigaNayiSuH kazcid rAjEva svargarAjayaM| ");
INSERT INTO sancol_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ArabdhE tasmin gaNanE sArddhasahasramudrApUritAnAM dazasahasrapuTakAnAm EkO'ghamarNastatsamakSamAnAyi| ");
INSERT INTO sancol_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","tasya parizOdhanAya dravyAbhAvAt parizOdhanArthaM sa tadIyabhAryyAputrAdisarvvasvanjca vikrIyatAmiti tatprabhurAdidEza| ");
INSERT INTO sancol_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","tEna sa dAsastasya pAdayOH patan praNamya kathitavAn , hE prabhO bhavatA ghairyyE kRtE mayA sarvvaM parizOdhiSyatE| ");
INSERT INTO sancol_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","tadAnIM dAsasya prabhuH sakaruNaH san sakalarNaM kSamitvA taM tatyAja| ");
INSERT INTO sancol_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","kintu tasmin dAsE bahi ryAtE, tasya zataM mudrAcaturthAMzAn yO dhArayati, taM sahadAsaM dRSdvA tasya kaNThaM niSpIPya gaditavAn, mama yat prApyaM tat parizOdhaya| ");
INSERT INTO sancol_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","tadA tasya sahadAsastatpAdayOH patitvA vinIya babhASE, tvayA dhairyyE kRtE mayA sarvvaM parizOdhiSyatE| ");
INSERT INTO sancol_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","tathApi sa tat nAgagIkRtya yAvat sarvvamRNaM na parizOdhitavAn tAvat taM kArAyAM sthApayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","tadA tasya sahadAsAstasyaitAdRg AcaraNaM vilOkya prabhOH samIpaM gatvA sarvvaM vRttAntaM nivEdayAmAsuH| ");
INSERT INTO sancol_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","tadA tasya prabhustamAhUya jagAda, rE duSTa dAsa, tvayA matsannidhau prArthitE mayA tava sarvvamRNaM tyaktaM; ");
INSERT INTO sancol_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","yathA cAhaM tvayi karuNAM kRtavAn, tathaiva tvatsahadAsE karuNAkaraNaM kiM tava nOcitaM? ");
INSERT INTO sancol_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","iti kathayitvA tasya prabhuH kruddhyan nijaprApyaM yAvat sa na parizOdhitavAn, tAvat prahArakAnAM karESu taM samarpitavAn| ");
INSERT INTO sancol_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","yadi yUyaM svAntaHkaraNaiH svasvasahajAnAm aparAdhAn na kSamadhvE, tarhi mama svargasyaH pitApi yuSmAn pratItthaM kariSyati| ");
INSERT INTO sancol_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","anantaram EtAsu kathAsu samAptAsu yIzu rgAlIlapradEzAt prasthAya yardantIrasthaM yihUdApradEzaM prAptaH| ");
INSERT INTO sancol_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","tadA tatpazcAt jananivahE gatE sa tatra tAn nirAmayAn akarOt| ");
INSERT INTO sancol_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","tadanantaraM phirUzinastatsamIpamAgatya pArIkSituM taM papracchuH, kasmAdapi kAraNAt narENa svajAyA parityAjyA na vA? ");
INSERT INTO sancol_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","sa pratyuvAca, prathamam IzvarO naratvEna nArItvEna ca manujAn sasarja, tasmAt kathitavAn, ");
INSERT INTO sancol_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","mAnuSaH svapitarau parityajya svapatnyAm AsakSyatE, tau dvau janAvEkAggau bhaviSyataH, kimEtad yuSmAbhi rna paThitam? ");
INSERT INTO sancol_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","atastau puna rna dvau tayOrEkAggatvaM jAtaM, IzvarENa yacca samayujyata, manujO na tad bhindyAt| ");
INSERT INTO sancol_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","tadAnIM tE taM pratyavadan, tathAtvE tyAjyapatraM dattvA svAM svAM jAyAM tyaktuM vyavasthAM mUsAH kathaM lilEkha? ");
INSERT INTO sancol_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","tataH sa kathitavAn, yuSmAkaM manasAM kAThinyAd yuSmAn svAM svAM jAyAM tyaktum anvamanyata kintu prathamAd ESO vidhirnAsIt| ");
INSERT INTO sancol_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","atO yuSmAnahaM vadAmi, vyabhicAraM vinA yO nijajAyAM tyajEt anyAnjca vivahEt, sa paradArAn gacchati; yazca tyaktAM nArIM vivahati sOpi paradArESu ramatE| ");
INSERT INTO sancol_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","tadA tasya ziSyAstaM babhASirE, yadi svajAyayA sAkaM puMsa EtAdRk sambandhO jAyatE, tarhi vivahanamEva na bhadraM| ");
INSERT INTO sancol_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","tataH sa uktavAn, yEbhyastatsAmarthyaM AdAyi, tAn vinAnyaH kOpi manuja EtanmataM grahItuM na zaknOti| ");
INSERT INTO sancol_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","katipayA jananaklIbaH katipayA narakRtaklIbaH svargarAjyAya katipayAH svakRtaklIbAzca santi, yE grahItuM zaknuvanti tE gRhlantu| ");
INSERT INTO sancol_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","aparam yathA sa zizUnAM gAtrESu hastaM datvA prArthayatE, tadarthaM tatsamIMpaM zizava AnIyanta, tata AnayitRn ziSyAstiraskRtavantaH| ");
INSERT INTO sancol_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","kintu yIzuruvAca, zizavO madantikam Agacchantu, tAn mA vArayata, EtAdRzAM zizUnAmEva svargarAjyaM| ");
INSERT INTO sancol_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","tataH sa tESAM gAtrESu hastaM datvA tasmAt sthAnAt pratasthE| ");
INSERT INTO sancol_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","aparam Eka Agatya taM papraccha, hE paramagurO, anantAyuH prAptuM mayA kiM kiM satkarmma karttavyaM? ");
INSERT INTO sancol_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","tataH sa uvAca, mAM paramaM kutO vadasi? vinEzcaraM na kOpi paramaH, kintu yadyanantAyuH prAptuM vAnjchasi, tarhyAjnjAH pAlaya| ");
INSERT INTO sancol_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","tadA sa pRSTavAn, kAH kA AjnjAH? tatO yIzuH kathitavAn, naraM mA hanyAH, paradArAn mA gacchEH, mA cOrayEH, mRSAsAkSyaM mA dadyAH, ");
INSERT INTO sancol_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","nijapitarau saMmanyasva, svasamIpavAsini svavat prEma kuru| ");
INSERT INTO sancol_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","sa yuvA kathitavAn, A bAlyAd EtAH pAlayAmi, idAnIM kiM nyUnamAstE? ");
INSERT INTO sancol_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","tatO yIzuravadat, yadi siddhO bhavituM vAnjchasi, tarhi gatvA nijasarvvasvaM vikrIya daridrEbhyO vitara, tataH svargE vittaM lapsyasE; Agaccha, matpazcAdvarttI ca bhava| ");
INSERT INTO sancol_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","EtAM vAcaM zrutvA sa yuvA svIyabahusampattE rviSaNaH san calitavAn| ");
INSERT INTO sancol_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","tadA yIzuH svaziSyAn avadat, dhaninAM svargarAjyapravEzO mahAduSkara iti yuSmAnahaM tathyaM vadAmi| ");
INSERT INTO sancol_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","punarapi yuSmAnahaM vadAmi, dhaninAM svargarAjyapravEzAt sUcIchidrENa mahAggagamanaM sukaraM| ");
INSERT INTO sancol_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","iti vAkyaM nizamya ziSyA aticamatkRtya kathayAmAsuH; tarhi kasya paritrANaM bhavituM zaknOti? ");
INSERT INTO sancol_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","tadA sa tAn dRSdvA kathayAmAsa, tat mAnuSANAmazakyaM bhavati, kintvIzvarasya sarvvaM zakyam| ");
INSERT INTO sancol_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","tadA pitarastaM gaditavAn, pazya, vayaM sarvvaM parityajya bhavataH pazcAdvarttinO 'bhavAma; vayaM kiM prApsyAmaH? ");
INSERT INTO sancol_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","tatO yIzuH kathitavAn, yuSmAnahaM tathyaM vadAmi, yUyaM mama pazcAdvarttinO jAtA iti kAraNAt navInasRSTikAlE yadA manujasutaH svIyaizcaryyasiMhAsana upavEkSyati, tadA yUyamapi dvAdazasiMhAsanESUpavizya isrAyElIyadvAdazavaMzAnAM vicAraM kariSyatha| ");
INSERT INTO sancol_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","anyacca yaH kazcit mama nAmakAraNAt gRhaM vA bhrAtaraM vA bhaginIM vA pitaraM vA mAtaraM vA jAyAM vA bAlakaM vA bhUmiM parityajati, sa tESAM zataguNaM lapsyatE, anantAyumO'dhikAritvanjca prApsyati| ");
INSERT INTO sancol_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","kintu agrIyA anEkE janAH pazcAt, pazcAtIyAzcAnEkE lOkA agrE bhaviSyanti| ");
INSERT INTO sancol_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","svargarAjyam EtAdRzA kEnacid gRhasyEna samaM, yO'tiprabhAtE nijadrAkSAkSEtrE kRSakAn niyOktuM gatavAn| ");
INSERT INTO sancol_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","pazcAt taiH sAkaM dinaikabhRtiM mudrAcaturthAMzaM nirUpya tAn drAkSAkSEtraM prErayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","anantaraM praharaikavElAyAM gatvA haTTE katipayAn niSkarmmakAn vilOkya tAnavadat, ");
INSERT INTO sancol_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","yUyamapi mama drAkSAkSEtraM yAta, yuSmabhyamahaM yOgyabhRtiM dAsyAmi, tatastE vavrajuH| ");
INSERT INTO sancol_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","punazca sa dvitIyatRtIyayOH praharayO rbahi rgatvA tathaiva kRtavAn| ");
INSERT INTO sancol_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","tatO daNPadvayAvaziSTAyAM vElAyAM bahi rgatvAparAn katipayajanAn niSkarmmakAn vilOkya pRSTavAn, yUyaM kimartham atra sarvvaM dinaM niSkarmmANastiSThatha? ");
INSERT INTO sancol_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","tE pratyavadan, asmAn na kOpi karmamaNi niyuMktE| tadAnIM sa kathitavAn, yUyamapi mama drAkSAkSEtraM yAta, tEna yOgyAM bhRtiM lapsyatha| ");
INSERT INTO sancol_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","tadanantaraM sandhyAyAM satyAM saEva drAkSAkSEtrapatiradhyakSaM gadivAn, kRSakAn AhUya zESajanamArabhya prathamaM yAvat tEbhyO bhRtiM dEhi| ");
INSERT INTO sancol_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","tEna yE daNPadvayAvasthitE samAyAtAstESAm EkaikO janO mudrAcaturthAMzaM prApnOt| ");
INSERT INTO sancol_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","tadAnIM prathamaniyuktA janA AgatyAnumitavantO vayamadhikaM prapsyAmaH, kintu tairapi mudrAcaturthAMzO'lAbhi| ");
INSERT INTO sancol_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","tatastE taM gRhItvA tEna kSEtrapatinA sAkaM vAgyuddhaM kurvvantaH kathayAmAsuH, ");
INSERT INTO sancol_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","vayaM kRtsnaM dinaM tApaklEzau sOPhavantaH, kintu pazcAtAyA sE janA daNPadvayamAtraM parizrAntavantastE'smAbhiH samAnAMzAH kRtAH| ");
INSERT INTO sancol_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","tataH sa tESAmEkaM pratyuvAca, hE vatsa, mayA tvAM prati kOpyanyAyO na kRtaH kiM tvayA matsamakSaM mudrAcaturthAMzO nAggIkRtaH? ");
INSERT INTO sancol_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","tasmAt tava yat prApyaM tadAdAya yAhi, tubhyaM yati, pazcAtIyaniyuktalOkAyApi tati dAtumicchAmi| ");
INSERT INTO sancol_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","svEcchayA nijadravyavyavaharaNaM kiM mayA na karttavyaM? mama dAtRtvAt tvayA kim IrSyAdRSTiH kriyatE? ");
INSERT INTO sancol_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","ittham agrIyalOkAH pazcatIyA bhaviSyanti, pazcAtIyajanAzcagrIyA bhaviSyanti, ahUtA bahavaH kintvalpE manObhilaSitAH| ");
INSERT INTO sancol_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","tadanantaraM yIzu ryirUzAlamnagaraM gacchan mArgamadhyE ziSyAn EkAntE vabhASE, ");
INSERT INTO sancol_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","pazya vayaM yirUzAlamnagaraM yAmaH, tatra pradhAnayAjakAdhyApakAnAM karESu manuSyaputraH samarpiSyatE; ");
INSERT INTO sancol_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","tE ca taM hantumAjnjApya tiraskRtya vEtrENa praharttuM kruzE dhAtayitunjcAnyadEzIyAnAM karESu samarpayiSyanti, kintu sa tRtIyadivasE zmazAnAd utthApiSyatE| ");
INSERT INTO sancol_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","tadAnIM sivadIyasya nArI svaputrAvAdAya yIzOH samIpam Etya praNamya kanjcanAnugrahaM taM yayAcE| ");
INSERT INTO sancol_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","tadA yIzustAM prOktavAn, tvaM kiM yAcasE? tataH sA babhASE, bhavatO rAjatvE mamAnayOH sutayOrEkaM bhavaddakSiNapArzvE dvitIyaM vAmapArzva upavESTum AjnjApayatu| ");
INSERT INTO sancol_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","yIzuH pratyuvAca, yuvAbhyAM yad yAcyatE, tanna budhyatE, ahaM yEna kaMsEna pAsyAmi yuvAbhyAM kiM tEna pAtuM zakyatE? ahanjca yEna majjEnEna majjiSyE, yuvAbhyAM kiM tEna majjayituM zakyatE? tE jagaduH zakyatE| ");
INSERT INTO sancol_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","tadA sa uktavAn, yuvAM mama kaMsEnAvazyaM pAsyathaH, mama majjanEna ca yuvAmapi majjiSyEthE, kintu yESAM kRtE mattAtEna nirUpitam idaM tAn vihAyAnyaM kamapi maddakSiNapArzvE vAmapArzvE ca samupavEzayituM mamAdhikArO nAsti| ");
INSERT INTO sancol_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","EtAM kathAM zrutvAnyE dazaziSyAstau bhrAtarau prati cukupuH| ");
INSERT INTO sancol_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","kintu yIzuH svasamIpaM tAnAhUya jagAda, anyadEzIyalOkAnAM narapatayastAn adhikurvvanti, yE tu mahAntastE tAn zAsati, iti yUyaM jAnItha| ");
INSERT INTO sancol_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","kintu yuSmAkaM madhyE na tathA bhavEt, yuSmAkaM yaH kazcit mahAn bubhUSati, sa yuSmAn sEvEta; ");
INSERT INTO sancol_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","yazca yuSmAkaM madhyE mukhyO bubhUSati, sa yuSmAkaM dAsO bhavEt| ");
INSERT INTO sancol_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","itthaM manujaputraH sEvyO bhavituM nahi, kintu sEvituM bahUnAM paritrANamUlyArthaM svaprANAn dAtunjcAgataH| ");
INSERT INTO sancol_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","anantaraM yirIhOnagarAt tESAM bahirgamanasamayE tasya pazcAd bahavO lOkA vavrajuH| ");
INSERT INTO sancol_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","aparaM vartmapArzva upavizantau dvAvandhau tEna mArgENa yIzO rgamanaM nizamya prOccaiH kathayAmAsatuH, hE prabhO dAyUdaH santAna, AvayO rdayAM vidhEhi| ");
INSERT INTO sancol_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","tatO lOkAH sarvvE tuSNImbhavatamityuktvA tau tarjayAmAsuH; tathApi tau punaruccaiH kathayAmAsatuH hE prabhO dAyUdaH santAna, AvAM dayasva| ");
INSERT INTO sancol_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","tadAnIM yIzuH sthagitaH san tAvAhUya bhASitavAn, yuvayOH kRtE mayA kiM karttarvyaM? yuvAM kiM kAmayEthE? ");
INSERT INTO sancol_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","tadA tAvuktavantau, prabhO nEtrANi nau prasannAni bhavEyuH| ");
INSERT INTO sancol_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","tadAnIM yIzustau prati pramannaH san tayO rnEtrANi pasparza, tEnaiva tau suvIkSAnjcakrAtE tatpazcAt jagmutuzca| ");
INSERT INTO sancol_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","anantaraM tESu yirUzAlamnagarasya samIpavErttinO jaitunanAmakadharAdharasya samIpasthtiM baitphagigrAmam AgatESu, yIzuH ziSyadvayaM prESayan jagAda, ");
INSERT INTO sancol_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","yuvAM sammukhasthagrAmaM gatvA baddhAM yAM savatsAM garddabhIM haThAt prApsyathaH, tAM mOcayitvA madantikam AnayataM| ");
INSERT INTO sancol_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","tatra yadi kazcit kinjcid vakSyati, tarhi vadiSyathaH, EtasyAM prabhOH prayOjanamAstE, tEna sa tatkSaNAt prahESyati| ");
INSERT INTO sancol_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","sIyOnaH kanyakAM yUyaM bhASadhvamiti bhAratIM| pazya tE namrazIlaH san nRpa Aruhya gardabhIM| arthAdAruhya tadvatsamAyAsyati tvadantikaM| ");
INSERT INTO sancol_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","bhaviSyadvAdinOktaM vacanamidaM tadA saphalamabhUt| ");
INSERT INTO sancol_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","anantaraM tau zSyiौ yIzO ryathAnidEzaM taM grAmaM gatvA ");
INSERT INTO sancol_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","gardabhIM tadvatsanjca samAnItavantau, pazcAt tadupari svIyavasanAnI pAtayitvA tamArOhayAmAsatuH| ");
INSERT INTO sancol_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","tatO bahavO lOkA nijavasanAni pathi prasArayitumArEbhirE, katipayA janAzca pAdapaparNAdikaM chitvA pathi vistArayAmAsuH| ");
INSERT INTO sancol_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","agragAminaH pazcAdgAminazca manujA uccairjaya jaya dAyUdaH santAnEti jagaduH paramEzvarasya nAmnA ya AyAti sa dhanyaH, sarvvOparisthasvargEpi jayati| ");
INSERT INTO sancol_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","itthaM tasmin yirUzAlamaM praviSTE kO'yamiti kathanAt kRtsnaM nagaraM canjcalamabhavat| ");
INSERT INTO sancol_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","tatra lOkOH kathayAmAsuH, ESa gAlIlpradEzIya-nAsaratIya-bhaviSyadvAdI yIzuH| ");
INSERT INTO sancol_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","anantaraM yIzurIzvarasya mandiraM pravizya tanmadhyAt krayavikrayiNO vahizcakAra; vaNijAM mudrAsanAnI kapOtavikrayiNAnjcasanAnI ca nyuvjayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","aparaM tAnuvAca, ESA lipirAstE, \"mama gRhaM prArthanAgRhamiti vikhyAsyati\", kintu yUyaM tad dasyUnAM gahvaraM kRtavantaH| ");
INSERT INTO sancol_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","tadanantaram andhakhanjcalOkAstasya samIpamAgatAH, sa tAn nirAmayAn kRtavAn| ");
INSERT INTO sancol_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","yadA pradhAnayAjakA adhyApakAzca tEna kRtAnyEtAni citrakarmmANi dadRzuH, jaya jaya dAyUdaH santAna, mandirE bAlakAnAm EtAdRzam uccadhvaniM zuzruvuzca, tadA mahAkruddhA babhUvaH, ");
INSERT INTO sancol_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","taM papracchuzca, imE yad vadanti, tat kiM tvaM zRNOSi? tatO yIzustAn avOcat, satyam; stanyapAyizizUnAnjca bAlakAnAnjca vaktrataH| svakIyaM mahimAnaM tvaM saMprakAzayasi svayaM| EtadvAkyaM yUyaM kiM nApaThata? ");
INSERT INTO sancol_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","tatastAn vihAya sa nagarAd baithaniyAgrAmaM gatvA tatra rajanIM yApayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","anantaraM prabhAtE sati yIzuH punarapi nagaramAgacchan kSudhArttO babhUva| ");
INSERT INTO sancol_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","tatO mArgapArzva uPumbaravRkSamEkaM vilOkya tatsamIpaM gatvA patrANi vinA kimapi na prApya taM pAdapaM prOvAca, adyArabhya kadApi tvayi phalaM na bhavatu; tEna tatkSaNAt sa uPumbaramAhIruhaH zuSkatAM gataH| ");
INSERT INTO sancol_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","tad dRSTvA ziSyA AzcaryyaM vijnjAya kathayAmAsuH, AH, uPumvarapAdapO'titUrNaM zuSkO'bhavat| ");
INSERT INTO sancol_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","tatO yIzustAnuvAca, yuSmAnahaM satyaM vadAmi, yadi yUyamasandigdhAH pratItha, tarhi yUyamapi kEvalOPumvarapAdapaM pratItthaM karttuM zakSyatha, tanna, tvaM calitvA sAgarE patEti vAkyaM yuSmAbhirasmina zailE prOktEpi tadaiva tad ghaTiSyatE| ");
INSERT INTO sancol_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","tathA vizvasya prArthya yuSmAbhi ryad yAciSyatE, tadEva prApsyatE| ");
INSERT INTO sancol_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","anantaraM mandiraM pravizyOpadEzanasamayE tatsamIpaM pradhAnayAjakAH prAcInalOkAzcAgatya papracchuH, tvayA kEna sAmarthyanaitAni karmmANi kriyantE? kEna vA tubhyamEtAni sAmarthyAni dattAni? ");
INSERT INTO sancol_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","tatO yIzuH pratyavadat, ahamapi yuSmAn vAcamEkAM pRcchAmi, yadi yUyaM taduttaraM dAtuM zakSyatha, tadA kEna sAmarthyEna karmmANyEtAni karOmi, tadahaM yuSmAn vakSyAmi| ");
INSERT INTO sancol_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","yOhanO majjanaM kasyAjnjayAbhavat? kimIzvarasya manuSyasya vA? tatastE parasparaM vivicya kathayAmAsuH, yadIzvarasyEti vadAmastarhi yUyaM taM kutO na pratyaita? vAcamEtAM vakSyati| ");
INSERT INTO sancol_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","manuSyasyEti vaktumapi lOkEbhyO bibhImaH, yataH sarvvairapi yOhan bhaviSyadvAdIti jnjAyatE| ");
INSERT INTO sancol_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","tasmAt tE yIzuM pratyavadan, tad vayaM na vidmaH| tadA sa tAnuktavAn, tarhi kEna sAmarathyEna karmmANyEtAnyahaM karOmi, tadapyahaM yuSmAn na vakSyAmi| ");
INSERT INTO sancol_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","kasyacijjanasya dvau sutAvAstAM sa Ekasya sutasya samIpaM gatvA jagAda, hE suta, tvamadya mama drAkSAkSEtrE karmma kartuM vraja| ");
INSERT INTO sancol_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","tataH sa uktavAn, na yAsyAmi, kintu zESE'nutapya jagAma| ");
INSERT INTO sancol_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","anantaraM sOnyasutasya samIpaM gatvA tathaiva kathtivAn; tataH sa pratyuvAca, mahEccha yAmi, kintu na gataH| ");
INSERT INTO sancol_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","EtayOH putrayO rmadhyE piturabhimataM kEna pAlitaM? yuSmAbhiH kiM budhyatE? tatastE pratyUcuH, prathamEna puुtrENa| tadAnIM yIzustAnuvAca, ahaM yuSmAn tathyaM vadAmi, caNPAlA gaNikAzca yuSmAkamagrata Izvarasya rAjyaM pravizanti| ");
INSERT INTO sancol_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","yatO yuSmAkaM samIpaM yOhani dharmmapathEnAgatE yUyaM taM na pratItha, kintu caNPAlA gaNikAzca taM pratyAyan, tad vilOkyApi yUyaM pratyEtuM nAkhidyadhvaM| ");
INSERT INTO sancol_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","aparamEkaM dRSTAntaM zRNuta, kazcid gRhasthaH kSEtrE drAkSAlatA rOpayitvA taccaturdikSu vAraNIM vidhAya tanmadhyE drAkSAyantraM sthApitavAn, mAnjcanjca nirmmitavAn, tataH kRSakESu tat kSEtraM samarpya svayaM dUradEzaM jagAma| ");
INSERT INTO sancol_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","tadanantaraM phalasamaya upasthitE sa phalAni prAptuM kRSIvalAnAM samIpaM nijadAsAn prESayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","kintu kRSIvalAstasya tAn dAsEyAn dhRtvA kanjcana prahRtavantaH, kanjcana pASANairAhatavantaH, kanjcana ca hatavantaH| ");
INSERT INTO sancol_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","punarapi sa prabhuH prathamatO'dhikadAsEyAn prESayAmAsa, kintu tE tAn pratyapi tathaiva cakruH| ");
INSERT INTO sancol_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","anantaraM mama sutE gatE taM samAdariSyantE, ityuktvA zESE sa nijasutaM tESAM sannidhiM prESayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","kintu tE kRSIvalAH sutaM vIkSya parasparam iti mantrayitum ArEbhirE, ayamuttarAdhikArI vayamEnaM nihatyAsyAdhikAraM svavazIkariSyAmaH| ");
INSERT INTO sancol_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","pazcAt tE taM dhRtvA drAkSAkSEtrAd bahiH pAtayitvAbadhiSuH| ");
INSERT INTO sancol_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","yadA sa drAkSAkSEtrapatirAgamiSyati, tadA tAn kRSIvalAn kiM kariSyati? ");
INSERT INTO sancol_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","tatastE pratyavadan, tAn kaluSiNO dAruNayAtanAbhirAhaniSyati, yE ca samayAnukramAt phalAni dAsyanti, tAdRzESu kRSIvalESu kSEtraM samarpayiSyati| ");
INSERT INTO sancol_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","tadA yIzunA tE gaditAH, grahaNaM na kRtaM yasya pASANasya nicAyakaiH| pradhAnaprastaraH kONE saEva saMbhaviSyati| Etat parEzituH karmmAsmadRSTAvadbhutaM bhavEt| dharmmagranthE likhitamEtadvacanaM yuSmAbhiH kiM nApAThi? ");
INSERT INTO sancol_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","tasmAdahaM yuSmAn vadAmi, yuSmatta IzvarIyarAjyamapanIya phalOtpAdayitranyajAtayE dAyiSyatE| ");
INSERT INTO sancol_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","yO jana EtatpASANOpari patiSyati, taM sa bhaMkSyatE, kintvayaM pASANO yasyOpari patiSyati, taM sa dhUlivat cUrNIkariSyati| ");
INSERT INTO sancol_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","tadAnIM prAdhanayAjakAH phirUzinazca tasyEmAM dRSTAntakathAM zrutvA sO'smAnuddizya kathitavAn, iti vijnjAya taM dharttuM cESTitavantaH; ");
INSERT INTO sancol_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","kintu lOkEbhyO bibhyuH, yatO lOkaiH sa bhaviSyadvAdItyajnjAyi| ");
INSERT INTO sancol_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","anantaraM yIzuH punarapi dRSTAntEna tAn avAdIt, ");
INSERT INTO sancol_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","svargIyarAjyam EtAdRzasya nRpatEH samaM, yO nija putraM vivAhayan sarvvAn nimantritAn AnEtuM dAsEyAn prahitavAn, ");
INSERT INTO sancol_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","kintu tE samAgantuM nESTavantaH| ");
INSERT INTO sancol_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","tatO rAjA punarapi dAsAnanyAn ityuktvA prESayAmAsa, nimantritAn vadata, pazyata, mama bhEjyamAsAditamAstE, nijavTaSAdipuSTajantUn mArayitvA sarvvaM khAdyadravyamAsAditavAn, yUyaM vivAhamAgacchata| ");
INSERT INTO sancol_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","tathapi tE tucchIkRtya kEcit nijakSEtraM kEcid vANijyaM prati svasvamArgENa calitavantaH| ");
INSERT INTO sancol_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","anyE lOkAstasya dAsEyAn dhRtvA daurAtmyaM vyavahRtya tAnavadhiSuH| ");
INSERT INTO sancol_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","anantaraM sa nRpatistAM vArttAM zrutvA krudhyan sainyAni prahitya tAn ghAtakAn hatvA tESAM nagaraM dAhayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","tataH sa nijadAsEyAn babhASE, vivAhIyaM bhOjyamAsAditamAstE, kintu nimantritA janA ayOgyAH| ");
INSERT INTO sancol_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","tasmAd yUyaM rAjamArgaM gatvA yAvatO manujAn pazyata, tAvataEva vivAhIyabhOjyAya nimantrayata| ");
INSERT INTO sancol_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","tadA tE dAsEyA rAjamArgaM gatvA bhadrAn abhadrAn vA yAvatO janAn dadRzuH, tAvataEva saMgRhyAnayan; tatO'bhyAgatamanujai rvivAhagRham apUryyata| ");
INSERT INTO sancol_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","tadAnIM sa rAjA sarvvAnabhyAgatAn draSTum abhyantaramAgatavAn; tadA tatra vivAhIyavasanahInamEkaM janaM vIkSya taM jagAd, ");
INSERT INTO sancol_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","hE mitra,tvaM vivAhIyavasanaM vinA kathamatra praviSTavAn? tEna sa niruttarO babhUva| ");
INSERT INTO sancol_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","tadA rAjA nijAnucarAn avadat, Etasya karacaraNAn baddhA yatra rOdanaM dantairdantagharSaNanjca bhavati, tatra vahirbhUtatamisrE taM nikSipata| ");
INSERT INTO sancol_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","itthaM bahava AhUtA alpE manObhimatAH| ");
INSERT INTO sancol_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","anantaraM phirUzinaH pragatya yathA saMlApEna tam unmAthE pAtayEyustathA mantrayitvA ");
INSERT INTO sancol_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","hErOdIyamanujaiH sAkaM nijaziSyagaNEna taM prati kathayAmAsuH, hE gurO, bhavAn satyaH satyamIzvarIyamArgamupadizati, kamapi mAnuSaM nAnurudhyatE, kamapi nApEkSatE ca, tad vayaM jAnImaH| ");
INSERT INTO sancol_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","ataH kaisarabhUpAya karO'smAkaM dAtavyO na vA? atra bhavatA kiM budhyatE? tad asmAn vadatu| ");
INSERT INTO sancol_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","tatO yIzustESAM khalatAM vijnjAya kathitavAn, rE kapaTinaH yuyaM kutO mAM parikSadhvE? ");
INSERT INTO sancol_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","tatkaradAnasya mudrAM mAM darzayata| tadAnIM taistasya samIpaM mudrAcaturthabhAga AnItE ");
INSERT INTO sancol_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","sa tAn papraccha, atra kasyEyaM mUrtti rnAma cAstE? tE jagaduH, kaisarabhUpasya| ");
INSERT INTO sancol_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","tataH sa uktavAna, kaisarasya yat tat kaisarAya datta, Izvarasya yat tad IzvarAya datta| ");
INSERT INTO sancol_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","iti vAkyaM nizamya tE vismayaM vijnjAya taM vihAya calitavantaH| ");
INSERT INTO sancol_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","tasminnahani sidUkinO'rthAt zmazAnAt nOtthAsyantIti vAkyaM yE vadanti, tE yIzEाrantikam Agatya papracchuH, ");
INSERT INTO sancol_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","hE gurO, kazcinmanujazcEt niHsantAnaH san prANAn tyajati, tarhi tasya bhrAtA tasya jAyAM vyuhya bhrAtuH santAnam utpAdayiSyatIti mUsA AdiSTavAn| ");
INSERT INTO sancol_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","kintvasmAkamatra kE'pi janAH saptasahOdarA Asan, tESAM jyESTha EkAM kanyAM vyavahAt, aparaM prANatyAgakAlE svayaM niHsantAnaH san tAM striyaM svabhrAtari samarpitavAn, ");
INSERT INTO sancol_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","tatO dvitIyAdisaptamAntAzca tathaiva cakruH| ");
INSERT INTO sancol_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","zESE sApI nArI mamAra| ");
INSERT INTO sancol_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","mRtAnAm utthAnasamayE tESAM saptAnAM madhyE sA nArI kasya bhAryyA bhaviSyati? yasmAt sarvvaEva tAM vyavahan| ");
INSERT INTO sancol_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","tatO yIzuH pratyavAdIt, yUyaM dharmmapustakam IzvarIyAM zaktinjca na vijnjAya bhrAntimantaH| ");
INSERT INTO sancol_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","utthAnaprAptA lOkA na vivahanti, na ca vAcA dIyantE, kintvIzvarasya svargasthadUtAnAM sadRzA bhavanti| ");
INSERT INTO sancol_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","aparaM mRtAnAmutthAnamadhi yuSmAn pratIyamIzvarOktiH, ");
INSERT INTO sancol_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","\"ahamibrAhIma Izvara ishAka IzvarO yAkUba Izvara\" iti kiM yuSmAbhi rnApAThi? kintvIzvarO jIvatAm Izvara:, sa mRtAnAmIzvarO nahi| ");
INSERT INTO sancol_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","iti zrutvA sarvvE lOkAstasyOpadEzAd vismayaM gatAH| ");
INSERT INTO sancol_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","anantaraM sidUkinAm niruttaratvavArtAM nizamya phirUzina Ekatra militavantaH, ");
INSERT INTO sancol_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","tESAmEkO vyavasthApakO yIzuM parIkSituM papaccha, ");
INSERT INTO sancol_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","hE gurO vyavasthAzAstramadhyE kAjnjA zrESThA? ");
INSERT INTO sancol_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","tatO yIzuruvAca, tvaM sarvvAntaHkaraNaiH sarvvaprANaiH sarvvacittaizca sAkaM prabhau paramEzvarE prIyasva, ");
INSERT INTO sancol_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ESA prathamamahAjnjA| tasyAH sadRzI dvitIyAjnjaiSA, ");
INSERT INTO sancol_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","tava samIpavAsini svAtmanIva prEma kuru| ");
INSERT INTO sancol_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","anayO rdvayOrAjnjayOH kRtsnavyavasthAyA bhaviSyadvaktRgranthasya ca bhArastiSThati| ");
INSERT INTO sancol_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","anantaraM phirUzinAm Ekatra sthitikAlE yIzustAn papraccha, ");
INSERT INTO sancol_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","khrISTamadhi yuSmAkaM kIdRgbOdhO jAyatE? sa kasya santAnaH? tatastE pratyavadan, dAyUdaH santAnaH| ");
INSERT INTO sancol_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","tadA sa uktavAn, tarhi dAyUd katham AtmAdhiSThAnEna taM prabhuM vadati ? ");
INSERT INTO sancol_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","yathA mama prabhumidaM vAkyamavadat paramEzvaraH| tavArIn pAdapIThaM tE yAvannahi karOmyahaM| tAvat kAlaM madIyE tvaM dakSapArzva upAviza| atO yadi dAyUd taM prabhuM vadati, rtiha sa kathaM tasya santAnO bhavati? ");
INSERT INTO sancol_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","tadAnIM tESAM kOpi tadvAkyasya kimapyuttaraM dAtuM nAzaknOt; ");
INSERT INTO sancol_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","taddinamArabhya taM kimapi vAkyaM praSTuM kasyApi sAhasO nAbhavat| ");
INSERT INTO sancol_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","anantaraM yIzu rjananivahaM ziSyAMzcAvadat, ");
INSERT INTO sancol_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","adhyApakAH phirUzinazca mUsAsanE upavizanti, ");
INSERT INTO sancol_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","atastE yuSmAn yadyat mantum AjnjApayanti, tat manyadhvaM pAlayadhvanjca, kintu tESAM karmmAnurUpaM karmma na kurudhvaM; yatastESAM vAkyamAtraM sAraM kAryyE kimapi nAsti| ");
INSERT INTO sancol_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","tE durvvahAn gurutarAn bhArAn badvvA manuSyANAM skandhEpari samarpayanti, kintu svayamaggulyaikayApi na cAlayanti| ");
INSERT INTO sancol_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","kEvalaM lOkadarzanAya sarvvakarmmANi kurvvanti; phalataH paTTabandhAn prasAryya dhArayanti, svavastrESu ca dIrghagranthIn dhArayanti; ");
INSERT INTO sancol_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","bhOjanabhavana uccasthAnaM, bhajanabhavanE pradhAnamAsanaM, ");
INSERT INTO sancol_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","haTThE namaskAraM gururiti sambOdhananjcaitAni sarvvANi vAnjchanti| ");
INSERT INTO sancol_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","kintu yUyaM gurava iti sambOdhanIyA mA bhavata, yatO yuSmAkam EkaH khrISTaEva guru ");
INSERT INTO sancol_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ryUyaM sarvvE mithO bhrAtarazca| punaH pRthivyAM kamapi pitEti mA sambudhyadhvaM, yatO yuSmAkamEkaH svargasthaEva pitA| ");
INSERT INTO sancol_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","yUyaM nAyakEti sambhASitA mA bhavata, yatO yuSmAkamEkaH khrISTaEva nAyakaH| ");
INSERT INTO sancol_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","aparaM yuSmAkaM madhyE yaH pumAn zrESThaH sa yuSmAn sEviSyatE| ");
INSERT INTO sancol_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","yatO yaH svamunnamati, sa nataH kariSyatE; kintu yaH kazcit svamavanataM karOti, sa unnataH kariSyatE| ");
INSERT INTO sancol_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","hanta kapaTina upAdhyAyAH phirUzinazca, yUyaM manujAnAM samakSaM svargadvAraM rundha, yUyaM svayaM tEna na pravizatha, pravivikSUnapi vArayatha| vata kapaTina upAdhyAyAH phirUzinazca yUyaM chalAd dIrghaM prArthya vidhavAnAM sarvvasvaM grasatha, yuSmAkaM ghOrataradaNPO bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","hanta kapaTina upAdhyAyAH phirUzinazca, yUyamEkaM svadharmmAvalambinaM karttuM sAgaraM bhUmaNPalanjca pradakSiNIkurutha, ");
INSERT INTO sancol_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","kanjcana prApya svatO dviguNanarakabhAjanaM taM kurutha| ");
INSERT INTO sancol_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","vata andhapathadarzakAH sarvvE, yUyaM vadatha, mandirasya zapathakaraNAt kimapi na dEyaM; kintu mandirasthasuvarNasya zapathakaraNAd dEyaM| ");
INSERT INTO sancol_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","hE mUPhA hE andhAH suvarNaM tatsuvarNapAvakamandiram EtayOrubhayO rmadhyE kiM zrEyaH? ");
INSERT INTO sancol_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","anyacca vadatha, yajnjavEdyAH zapathakaraNAt kimapi na dEyaM, kintu taduparisthitasya naivEdyasya zapathakaraNAd dEyaM| ");
INSERT INTO sancol_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","hE mUPhA hE andhAH, naivEdyaM tannaivEdyapAvakavEdirEtayOrubhayO rmadhyE kiM zrEyaH? ");
INSERT INTO sancol_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ataH kEnacid yajnjavEdyAH zapathE kRtE taduparisthasya sarvvasya zapathaH kriyatE| ");
INSERT INTO sancol_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","kEnacit mandirasya zapathE kRtE mandiratannivAsinOH zapathaH kriyatE| ");
INSERT INTO sancol_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","kEnacit svargasya zapathE kRtE IzvarIyasiMhAsanataduparyyupaviSTayOH zapathaH kriyatE| ");
INSERT INTO sancol_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","hanta kapaTina upAdhyAyAH phirUzinazca, yUyaM pOdinAyAH sitacchatrAyA jIrakasya ca dazamAMzAn dattha, kintu vyavasthAyA gurutarAn nyAyadayAvizvAsAn parityajatha; imE yuSmAbhirAcaraNIyA amI ca na laMghanIyAH| ");
INSERT INTO sancol_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","hE andhapathadarzakA yUyaM mazakAn apasArayatha, kintu mahAggAn grasatha| ");
INSERT INTO sancol_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","hanta kapaTina upAdhyAyAH phirUzinazca, yUyaM pAnapAtrANAM bhOjanapAtrANAnjca bahiH pariSkurutha; kintu tadabhyantaraM durAtmatayA kaluSENa ca paripUrNamAstE| ");
INSERT INTO sancol_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","hE andhAH phirUzilOkA Adau pAnapAtrANAM bhOjanapAtrANAnjcAbhyantaraM pariSkuruta, tEna tESAM bahirapi pariSkAriSyatE| ");
INSERT INTO sancol_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","hanta kapaTina upAdhyAyAH phirUzinazca, yUyaM zuklIkRtazmazAnasvarUpA bhavatha, yathA zmazAnabhavanasya bahizcAru, kintvabhyantaraM mRtalOkAnAM kIkazaiH sarvvaprakAramalEna ca paripUrNam; ");
INSERT INTO sancol_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","tathaiva yUyamapi lOkAnAM samakSaM bahirdhArmmikAH kintvantaHkaraNESu kEvalakApaTyAdharmmAbhyAM paripUrNAH| ");
INSERT INTO sancol_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","hA hA kapaTina upAdhyAyAH phirUzinazca, yUyaM bhaviSyadvAdinAM zmazAnagEhaM nirmmAtha, sAdhUnAM zmazAnanikEtanaM zObhayatha ");
INSERT INTO sancol_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","vadatha ca yadi vayaM svESAM pUrvvapuruSANAM kAla asthAsyAma, tarhi bhaviSyadvAdinAM zONitapAtanE tESAM sahabhAginO nAbhaviSyAma| ");
INSERT INTO sancol_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","atO yUyaM bhaviSyadvAdighAtakAnAM santAnA iti svayamEva svESAM sAkSyaM dattha| ");
INSERT INTO sancol_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","atO yUyaM nijapUrvvapuruSANAM parimANapAtraM paripUrayata| ");
INSERT INTO sancol_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","rE bhujagAH kRSNabhujagavaMzAH, yUyaM kathaM narakadaNPAd rakSiSyadhvE| ");
INSERT INTO sancol_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","pazyata, yuSmAkamantikam ahaM bhaviSyadvAdinO buddhimata upAdhyAyAMzca prESayiSyAmi, kintu tESAM katipayA yuSmAbhi rghAniSyantE, kruzE ca ghAniSyantE, kEcid bhajanabhavanE kaSAbhirAghAniSyantE, nagarE nagarE tAPiSyantE ca; ");
INSERT INTO sancol_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","tEna satpuruSasya hAbilO raktapAtamArabhya bErikhiyaH putraM yaM sikhariyaM yUyaM mandirayajnjavEdyO rmadhyE hatavantaH, tadIyazONitapAtaM yAvad asmin dEzE yAvatAM sAdhupuruSANAM zONitapAtO 'bhavat tat sarvvESAmAgasAM daNPA yuSmAsu varttiSyantE| ");
INSERT INTO sancol_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ahaM yuSmAnta tathyaM vadAmi, vidyamAnE'smin puruSE sarvvE varttiSyantE| ");
INSERT INTO sancol_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","hE yirUzAlam hE yirUzAlam nagari tvaM bhaviSyadvAdinO hatavatI, tava samIpaM prEritAMzca pASANairAhatavatI, yathA kukkuTI zAvakAn pakSAdhaH saMgRhlAti, tathA tava santAnAn saMgrahItuM ahaM bahuvAram aicchaM; kintu tvaM na samamanyathAH| ");
INSERT INTO sancol_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","pazyata yaSmAkaM vAsasthAnam ucchinnaM tyakSyatE| ");
INSERT INTO sancol_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ahaM yuSmAn tathyaM vadAmi, yaH paramEzvarasya nAmnAgacchati, sa dhanya iti vANIM yAvanna vadiSyatha, tAvat mAM puna rna drakSyatha| ");
INSERT INTO sancol_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","anantaraM yIzu ryadA mandirAd bahi rgacchati, tadAnIM ziSyAstaM mandiranirmmANaM darzayitumAgatAH| ");
INSERT INTO sancol_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","tatO yIzustAnuvAca, yUyaM kimEtAni na pazyatha? yuSmAnahaM satyaM vadAmi, Etannicayanasya pASANaikamapyanyapASANEाpari na sthAsyati sarvvANi bhUmisAt kAriSyantE| ");
INSERT INTO sancol_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","anantaraM tasmin jaitunaparvvatOpari samupaviSTE ziSyAstasya samIpamAgatya guptaM papracchuH, EtA ghaTanAH kadA bhaviSyanti? bhavata Agamanasya yugAntasya ca kiM lakSma? tadasmAn vadatu| ");
INSERT INTO sancol_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","tadAnIM yIzustAnavOcat, avadhadvvaM, kOpi yuSmAn na bhramayEt| ");
INSERT INTO sancol_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","bahavO mama nAma gRhlanta AgamiSyanti, khrISTO'hamEvEti vAcaM vadantO bahUn bhramayiSyanti| ");
INSERT INTO sancol_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","yUyanjca saMgrAmasya raNasya cAPambaraM zrOSyatha, avadhadvvaM tEna canjcalA mA bhavata, EtAnyavazyaM ghaTiSyantE, kintu tadA yugAntO nahi| ");
INSERT INTO sancol_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","aparaM dEzasya vipakSO dEzO rAjyasya vipakSO rAjyaM bhaviSyati, sthAnE sthAnE ca durbhikSaM mahAmArI bhUkampazca bhaviSyanti, ");
INSERT INTO sancol_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","EtAni duHkhOpakramAH| ");
INSERT INTO sancol_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","tadAnIM lOkA duHkhaM bhOjayituM yuSmAn parakarESu samarpayiSyanti haniSyanti ca, tathA mama nAmakAraNAd yUyaM sarvvadEzIyamanujAnAM samIpE ghRNArhA bhaviSyatha| ");
INSERT INTO sancol_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","bahuSu vighnaM prAptavatsu parasparam RृtIyAM kRtavatsu ca EkO'paraM parakarESu samarpayiSyati| ");
INSERT INTO sancol_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","tathA bahavO mRSAbhaviSyadvAdina upasthAya bahUn bhramayiSyanti| ");
INSERT INTO sancol_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","duSkarmmaNAM bAhulyAnjca bahUnAM prEma zItalaM bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","kintu yaH kazcit zESaM yAvad dhairyyamAzrayatE, saEva paritrAyiSyatE| ");
INSERT INTO sancol_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","aparaM sarvvadEzIyalOkAn pratimAkSI bhavituM rAjasya zubhasamAcAraH sarvvajagati pracAriSyatE, EtAdRzi sati yugAnta upasthAsyati| ");
INSERT INTO sancol_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","atO yat sarvvanAzakRdghRNArhaM vastu dAniyElbhaviSyadvadinA prOktaM tad yadA puNyasthAnE sthApitaM drakSyatha, (yaH paThati, sa budhyatAM) ");
INSERT INTO sancol_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","tadAnIM yE yihUdIyadEzE tiSThanti, tE parvvatESu palAyantAM| ");
INSERT INTO sancol_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","yaH kazcid gRhapRSThE tiSThati, sa gRhAt kimapi vastvAnEtum adhEा nAvarOhEt| ");
INSERT INTO sancol_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","yazca kSEtrE tiSThati, sOpi vastramAnEtuM parAvRtya na yAyAt| ");
INSERT INTO sancol_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","tadAnIM garbhiNIstanyapAyayitrINAM durgati rbhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","atO yaSmAkaM palAyanaM zItakAlE vizrAmavArE vA yanna bhavEt, tadarthaM prArthayadhvam| ");
INSERT INTO sancol_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","A jagadArambhAd EtatkAlaparyyanantaM yAdRzaH kadApi nAbhavat na ca bhaviSyati tAdRzO mahAklEzastadAnIm upasthAsyati| ");
INSERT INTO sancol_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","tasya klEzasya samayO yadi hsvO na kriyEta, tarhi kasyApi prANinO rakSaNaM bhavituM na zaknuyAt, kintu manOnItamanujAnAM kRtE sa kAlO hsvIkariSyatE| ");
INSERT INTO sancol_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","aparanjca pazyata, khrISTO'tra vidyatE, vA tatra vidyatE, tadAnIM yadI kazcid yuSmAna iti vAkyaM vadati, tathApi tat na pratIt| ");
INSERT INTO sancol_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","yatO bhAktakhrISTA bhAktabhaviSyadvAdinazca upasthAya yAni mahanti lakSmANi citrakarmmANi ca prakAzayiSyanti, tai ryadi sambhavEt tarhi manOnItamAnavA api bhrAmiSyantE| ");
INSERT INTO sancol_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","pazyata, ghaTanAtaH pUrvvaM yuSmAn vArttAm avAdiSam| ");
INSERT INTO sancol_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","ataH pazyata, sa prAntarE vidyata iti vAkyE kEnacit kathitEpi bahi rmA gacchata, vA pazyata, sOntaHpurE vidyatE, EtadvAkya uktEpi mA pratIta| ");
INSERT INTO sancol_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","yatO yathA vidyut pUrvvadizO nirgatya pazcimadizaM yAvat prakAzatE, tathA mAnuSaputrasyApyAgamanaM bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","yatra zavastiSThati, tatrEva gRdhrA milanti| ");
INSERT INTO sancol_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","aparaM tasya klEzasamayasyAvyavahitaparatra sUryyasya tEjO lOpsyatE, candramA jyOsnAM na kariSyati, nabhasO nakSatrANi patiSyanti, gagaNIyA grahAzca vicaliSyanti| ");
INSERT INTO sancol_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","tadAnIm AkAzamadhyE manujasutasya lakSma darziSyatE, tatO nijaparAkramENa mahAtEjasA ca mEghArUPhaM manujasutaM nabhasAgacchantaM vilOkya pRthivyAH sarvvavaMzIyA vilapiSyanti| ");
INSERT INTO sancol_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","tadAnIM sa mahAzabdAyamAnatUryyA vAdakAn nijadUtAn prahESyati, tE vyOmna EkasImAtO'parasImAM yAvat caturdizastasya manOnItajanAn AnIya mElayiSyanti| ");
INSERT INTO sancol_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","uPumbarapAdapasya dRSTAntaM zikSadhvaM; yadA tasya navInAH zAkhA jAyantE, pallavAdizca nirgacchati, tadA nidAghakAlaH savidhO bhavatIti yUyaM jAnItha; ");
INSERT INTO sancol_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","tadvad EtA ghaTanA dRSTvA sa samayO dvAra upAsthAd iti jAnIta| ");
INSERT INTO sancol_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","yuSmAnahaM tathyaM vadAmi, idAnIntanajanAnAM gamanAt pUrvvamEva tAni sarvvANi ghaTiSyantE| ");
INSERT INTO sancol_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","nabhOmEdinyO rluptayOrapi mama vAk kadApi na lOpsyatE| ");
INSERT INTO sancol_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","aparaM mama tAtaM vinA mAnuSaH svargasthO dUtO vA kOpi taddinaM taddaNPanjca na jnjApayati| ");
INSERT INTO sancol_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","aparaM nOhE vidyamAnE yAdRzamabhavat tAdRzaM manujasutasyAgamanakAlEpi bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","phalatO jalAplAvanAt pUrvvaM yaddinaM yAvat nOhaH pOtaM nArOhat, tAvatkAlaM yathA manuSyA bhOjanE pAnE vivahanE vivAhanE ca pravRttA Asan; ");
INSERT INTO sancol_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","aparam AplAvitOyamAgatya yAvat sakalamanujAn plAvayitvA nAnayat, tAvat tE yathA na vidAmAsuH, tathA manujasutAgamanEpi bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","tadA kSEtrasthitayOrdvayOrEkO dhAriSyatE, aparastyAjiSyatE| ");
INSERT INTO sancol_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","tathA pESaNyA piMSatyOrubhayO ryOSitOrEkA dhAriSyatE'parA tyAjiSyatE| ");
INSERT INTO sancol_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","yuSmAkaM prabhuH kasmin daNPa AgamiSyati, tad yuSmAbhi rnAvagamyatE, tasmAt jAgrataH santastiSThata| ");
INSERT INTO sancol_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","kutra yAmE stEna AgamiSyatIti cEd gRhasthO jnjAtum azakSyat, tarhi jAgaritvA taM sandhiM karttitum avArayiSyat tad jAnIta| ");
INSERT INTO sancol_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","yuSmAbhiravadhIyatAM, yatO yuSmAbhi ryatra na budhyatE, tatraiva daNPE manujasuta AyAsyati| ");
INSERT INTO sancol_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","prabhu rnijaparivArAn yathAkAlaM bhOjayituM yaM dAsam adhyakSIkRtya sthApayati, tAdRzO vizvAsyO dhImAn dAsaH kaH? ");
INSERT INTO sancol_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","prabhurAgatya yaM dAsaM tathAcarantaM vIkSatE, saEva dhanyaH| ");
INSERT INTO sancol_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","yuSmAnahaM satyaM vadAmi, sa taM nijasarvvasvasyAdhipaM kariSyati| ");
INSERT INTO sancol_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","kintu prabhurAgantuM vilambata iti manasi cintayitvA yO duSTO dAsO ");
INSERT INTO sancol_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","'paradAsAn praharttuM mattAnAM saggE bhOktuM pAtunjca pravarttatE, ");
INSERT INTO sancol_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","sa dAsO yadA nApEkSatE, yanjca daNPaM na jAnAti, tatkAlaEva tatprabhurupasthAsyati| ");
INSERT INTO sancol_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","tadA taM daNPayitvA yatra sthAnE rOdanaM dantagharSaNanjcAsAtE, tatra kapaTibhiH sAkaM taddazAM nirUpayiSyati| ");
INSERT INTO sancol_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","yA daza kanyAH pradIpAn gRhlatyO varaM sAkSAt karttuM bahiritAH, tAbhistadA svargIyarAjyasya sAdRzyaM bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","tAsAM kanyAnAM madhyE panjca sudhiyaH panjca durdhiya Asan| ");
INSERT INTO sancol_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","yA durdhiyastAH pradIpAn saggE gRhItvA tailaM na jagRhuH, ");
INSERT INTO sancol_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","kintu sudhiyaH pradIpAn pAtrENa tailanjca jagRhuH| ");
INSERT INTO sancol_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","anantaraM varE vilambitE tAH sarvvA nidrAviSTA nidrAM jagmuH| ");
INSERT INTO sancol_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","anantaram arddharAtrE pazyata vara Agacchati, taM sAkSAt karttuM bahiryAtEti janaravAt ");
INSERT INTO sancol_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","tAH sarvvAH kanyA utthAya pradIpAn AsAdayituM Arabhanta| ");
INSERT INTO sancol_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","tatO durdhiyaH sudhiya UcuH, kinjcit tailaM datta, pradIpA asmAkaM nirvvANAH| ");
INSERT INTO sancol_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","kintu sudhiyaH pratyavadan, dattE yuSmAnasmAMzca prati tailaM nyUnIbhavEt, tasmAd vikrEtRNAM samIpaM gatvA svArthaM tailaM krINIta| ");
INSERT INTO sancol_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","tadA tAsu krEtuM gatAsu vara AjagAma, tatO yAH sajjitA Asan, tAstEna sAkaM vivAhIyaM vEzma pravivizuH| ");
INSERT INTO sancol_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","anantaraM dvArE ruddhE aparAH kanyA Agatya jagaduH, hE prabhO, hE prabhO, asmAn prati dvAraM mOcaya| ");
INSERT INTO sancol_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","kintu sa uktavAn, tathyaM vadAmi, yuSmAnahaM na vEdmi| ");
INSERT INTO sancol_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","atO jAgrataH santastiSThata, manujasutaH kasmin dinE kasmin daNPE vAgamiSyati, tad yuSmAbhi rna jnjAyatE| ");
INSERT INTO sancol_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","aparaM sa EtAdRzaH kasyacit puMsastulyaH, yO dUradEzaM prati yAtrAkAlE nijadAsAn AhUya tESAM svasvasAmarthyAnurUpam ");
INSERT INTO sancol_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ekasmin mudrANAM panjca pOTalikAH anyasmiMzca dvE pOTalikE aparasmiMzca pOTalikaikAm itthaM pratijanaM samarpya svayaM pravAsaM gatavAn| ");
INSERT INTO sancol_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","anantaraM yO dAsaH panjca pOTalikAH labdhavAn, sa gatvA vANijyaM vidhAya tA dviguNIcakAra| ");
INSERT INTO sancol_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","yazca dAsO dvE pOTalikE alabhata, sOpi tA mudrA dviguNIcakAra| ");
INSERT INTO sancol_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","kintu yO dAsa EkAM pOTalikAM labdhavAn, sa gatvA bhUmiM khanitvA tanmadhyE nijaprabhOstA mudrA gOpayAnjcakAra| ");
INSERT INTO sancol_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","tadanantaraM bahutithE kAlE gatE tESAM dAsAnAM prabhurAgatya tairdAsaiH samaM gaNayAnjcakAra| ");
INSERT INTO sancol_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","tadAnIM yaH panjca pOTalikAH prAptavAn sa tA dviguNIkRtamudrA AnIya jagAda; hE prabhO, bhavatA mayi panjca pOTalikAH samarpitAH, pazyatu, tA mayA dviguNIkRtAH| ");
INSERT INTO sancol_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","tadAnIM tasya prabhustamuvAca, hE uttama vizvAsya dAsa, tvaM dhanyOsi, stOkEna vizvAsyO jAtaH, tasmAt tvAM bahuvittAdhipaM karOmi, tvaM svaprabhOH sukhasya bhAgI bhava| ");
INSERT INTO sancol_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","tatO yEna dvE pOTalikE labdhE sOpyAgatya jagAda, hE prabhO, bhavatA mayi dvE pOTalikE samarpitE, pazyatu tE mayA dviguNIkRtE| ");
INSERT INTO sancol_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","tEna tasya prabhustamavOcat, hE uttama vizvAsya dAsa, tvaM dhanyOsi, stOkEna vizvAsyO jAtaH, tasmAt tvAM bahudraviNAdhipaM karOmi, tvaM nijaprabhOH sukhasya bhAgI bhava| ");
INSERT INTO sancol_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","anantaraM ya EkAM pOTalikAM labdhavAn, sa Etya kathitavAn, hE prabhO, tvAM kaThinanaraM jnjAtavAn, tvayA yatra nOptaM, tatraiva kRtyatE, yatra ca na kIrNaM, tatraiva saMgRhyatE| ");
INSERT INTO sancol_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","atOhaM sazagkaH san gatvA tava mudrA bhUmadhyE saMgOpya sthApitavAn, pazya, tava yat tadEva gRhANa| ");
INSERT INTO sancol_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","tadA tasya prabhuH pratyavadat rE duSTAlasa dAsa, yatrAhaM na vapAmi, tatra chinadmi, yatra ca na kirAmi, tatrEva saMgRhlAmIti cEdajAnAstarhi ");
INSERT INTO sancol_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","vaNikSu mama vittArpaNaM tavOcitamAsIt, yEnAhamAgatya vRdvyA sAkaM mUlamudrAH prApsyam| ");
INSERT INTO sancol_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","atOsmAt tAM pOTalikAm AdAya yasya daza pOTalikAH santi tasminnarpayata| ");
INSERT INTO sancol_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","yEna vardvyatE tasminnaivArpiSyatE, tasyaiva ca bAhulyaM bhaviSyati, kintu yEna na vardvyatE, tasyAntikE yat kinjcana tiSThati, tadapi punarnESyatE| ");
INSERT INTO sancol_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","aparaM yUyaM tamakarmmaNyaM dAsaM nItvA yatra sthAnE krandanaM dantagharSaNanjca vidyEtE, tasmin bahirbhUtatamasi nikSipata| ");
INSERT INTO sancol_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","yadA manujasutaH pavitradUtAn sagginaH kRtvA nijaprabhAvEnAgatya nijatEjOmayE siMhAsanE nivEkSyati, ");
INSERT INTO sancol_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","tadA tatsammukhE sarvvajAtIyA janA saMmEliSyanti| tatO mESapAlakO yathA chAgEbhyO'vIn pRthak karOti tathA sOpyEkasmAdanyam itthaM tAn pRthaka kRtvAvIn ");
INSERT INTO sancol_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","dakSiNE chAgAMzca vAmE sthApayiSyati| ");
INSERT INTO sancol_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","tataH paraM rAjA dakSiNasthitAn mAnavAn vadiSyati, Agacchata mattAtasyAnugrahabhAjanAni, yuSmatkRta A jagadArambhat yad rAjyam AsAditaM tadadhikuruta| ");
INSERT INTO sancol_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","yatO bubhukSitAya mahyaM bhOjyam adatta, pipAsitAya pEyamadatta, vidEzinaM mAM svasthAnamanayata, ");
INSERT INTO sancol_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","vastrahInaM mAM vasanaM paryyadhApayata, pIPItaM mAM draSTumAgacchata, kArAsthanjca mAM vIkSituma Agacchata| ");
INSERT INTO sancol_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","tadA dhArmmikAH prativadiSyanti, hE prabhO, kadA tvAM kSudhitaM vIkSya vayamabhOjayAma? vA pipAsitaM vIkSya apAyayAma? ");
INSERT INTO sancol_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","kadA vA tvAM vidEzinaM vilOkya svasthAnamanayAma? kadA vA tvAM nagnaM vIkSya vasanaM paryyadhApayAma? ");
INSERT INTO sancol_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","kadA vA tvAM pIPitaM kArAsthanjca vIkSya tvadantikamagacchAma? ");
INSERT INTO sancol_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","tadAnIM rAjA tAn prativadiSyati, yuSmAnahaM satyaM vadAmi, mamaitESAM bhrAtRNAM madhyE kanjcanaikaM kSudratamaM prati yad akuruta, tanmAM pratyakuruta| ");
INSERT INTO sancol_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","pazcAt sa vAmasthitAn janAn vadiSyati, rE zApagrastAH sarvvE, zaitAnE tasya dUtEbhyazca yO'nantavahnirAsAdita AstE, yUyaM madantikAt tamagniM gacchata| ");
INSERT INTO sancol_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","yatO kSudhitAya mahyamAhAraM nAdatta, pipAsitAya mahyaM pEyaM nAdatta, ");
INSERT INTO sancol_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","vidEzinaM mAM svasthAnaM nAnayata, vasanahInaM mAM vasanaM na paryyadhApayata, pIPitaM kArAsthanjca mAM vIkSituM nAgacchata| ");
INSERT INTO sancol_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","tadA tE prativadiSyanti, hE prabhO, kadA tvAM kSudhitaM vA pipAsitaM vA vidEzinaM vA nagnaM vA pIPitaM vA kArAsthaM vIkSya tvAM nAsEvAmahi? ");
INSERT INTO sancol_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","tadA sa tAn vadiSyati, tathyamahaM yuSmAn bravImi, yuSmAbhirESAM kanjcana kSOdiSThaM prati yannAkAri, tanmAM pratyEva nAkAri| ");
INSERT INTO sancol_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","pazcAdamyanantazAstiM kintu dhArmmikA anantAyuSaM bhOktuM yAsyanti| ");
INSERT INTO sancol_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","yIzurEtAn prastAvAn samApya ziSyAnUcE, ");
INSERT INTO sancol_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","yuSmAbhi rjnjAtaM dinadvayAt paraM nistAramaha upasthAsyati, tatra manujasutaH kruzEna hantuM parakarESu samarpiSyatE| ");
INSERT INTO sancol_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","tataH paraM pradhAnayAjakAdhyApakaprAnjcaH kiyaphAnAmnO mahAyAjakasyATTAlikAyAM militvA ");
INSERT INTO sancol_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","kEnOpAyEna yIzuM dhRtvA hantuM zaknuyuriti mantrayAnjcakruH| ");
INSERT INTO sancol_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","kintu tairuktaM mahakAlE na dharttavyaH, dhRtE prajAnAM kalahEna bhavituM zakyatE| ");
INSERT INTO sancol_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","tatO baithaniyApurE zimOnAkhyasya kuSThinO vEzmani yIzau tiSThati ");
INSERT INTO sancol_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","kAcana yOSA zvEtOpalabhAjanEna mahArghyaM sugandhi tailamAnIya bhOjanAyOpavizatastasya zirObhyaSEcat| ");
INSERT INTO sancol_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","kintu tadAlOkya tacchiSyaiH kupitairuktaM, kuta itthamapavyayatE? ");
INSERT INTO sancol_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","cEdidaM vyakrESyata, tarhi bhUrimUlyaM prApya daridrEbhyO vyatAriSyata| ");
INSERT INTO sancol_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","yIzunA tadavagatya tE samuditAH, yOSAmEnAM kutO duHkhinIM kurutha, sA mAM prati sAdhu karmmAkArSIt| ");
INSERT INTO sancol_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","yuSmAkamaM samIpE daridrAH satatamEvAsatE, kintu yuSmAkamantikEhaM nAsE satataM| ");
INSERT INTO sancol_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","sA mama kAyOpari sugandhitailaM siktvA mama zmazAnadAnakarmmAkArSIt| ");
INSERT INTO sancol_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","atOhaM yuSmAn tathyaM vadAmi sarvvasmin jagati yatra yatraiSa susamAcAraH pracAriSyatE, tatra tatraitasyA nAryyAH smaraNArtham karmmEdaM pracAriSyatE| ");
INSERT INTO sancol_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","tatO dvAdazaziSyANAm ISkariyOtIyayihUdAnAmaka EkaH ziSyaH pradhAnayAjakAnAmantikaM gatvA kathitavAn, ");
INSERT INTO sancol_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","yadi yuSmAkaM karESu yIzuM samarpayAmi, tarhi kiM dAsyatha? tadAnIM tE tasmai triMzanmudrA dAtuM sthirIkRtavantaH| ");
INSERT INTO sancol_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","sa tadArabhya taM parakarESu samarpayituM suyOgaM cESTitavAn| ");
INSERT INTO sancol_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","anantaraM kiNvazUnyapUpaparvvaNaH prathamEhni ziSyA yIzum upagatya papracchuH bhavatkRtE kutra vayaM nistAramahabhOjyam AyOjayiSyAmaH? bhavataH kEcchA? ");
INSERT INTO sancol_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","tadA sa gaditavAn, madhyEnagaramamukapuMsaH samIpaM vrajitvA vadata, guru rgaditavAn, matkAlaH savidhaH, saha ziSyaistvadAlayE nistAramahabhOjyaM bhOkSyE| ");
INSERT INTO sancol_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","tadA ziSyA yIzOstAdRzanidEzAnurUpakarmma vidhAya tatra nistAramahabhOjyamAsAdayAmAsuH| ");
INSERT INTO sancol_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","tataH sandhyAyAM satyAM dvAdazabhiH ziSyaiH sAkaM sa nyavizat| ");
INSERT INTO sancol_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","aparaM bhunjjAna uktavAn yuSmAn tathyaM vadAmi, yuSmAkamEkO mAM parakarESu samarpayiSyati| ");
INSERT INTO sancol_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","tadA tE'tIva duHkhitA EkaikazO vaktumArEbhirE, hE prabhO, sa kimahaM? ");
INSERT INTO sancol_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","tataH sa jagAda, mayA sAkaM yO janO bhOjanapAtrE karaM saMkSipati, sa Eva mAM parakarESu samarpayiSyati| ");
INSERT INTO sancol_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","manujasutamadhi yAdRzaM likhitamAstE, tadanurUpA tadgati rbhaviSyati; kintu yEna puMsA sa parakarESu samarpayiSyatE, hA hA cEt sa nAjaniSyata, tadA tasya kSEmamabhaviSyat| ");
INSERT INTO sancol_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","tadA yihUdAnAmA yO janastaM parakarESu samarpayiSyati, sa uktavAn, hE gurO, sa kimahaM? tataH sa pratyuktavAn, tvayA satyaM gaditam| ");
INSERT INTO sancol_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","anantaraM tESAmazanakAlE yIzuH pUpamAdAyEzvarIyaguNAnanUdya bhaMktvA ziSyEbhyaH pradAya jagAda, madvapuHsvarUpamimaM gRhItvA khAdata| ");
INSERT INTO sancol_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","pazcAt sa kaMsaM gRhlan IzvarIyaguNAnanUdya tEbhyaH pradAya kathitavAn, sarvvai ryuSmAbhiranEna pAtavyaM, ");
INSERT INTO sancol_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","yasmAdanEkESAM pApamarSaNAya pAtitaM yanmannUtnaniyamarUpazONitaM tadEtat| ");
INSERT INTO sancol_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","aparamahaM nUtnagOstanIrasaM na pAsyAmi, tAvat gOstanIphalarasaM punaH kadApi na pAsyAmi| ");
INSERT INTO sancol_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","pazcAt tE gItamEkaM saMgIya jaitunAkhyagiriM gatavantaH| ");
INSERT INTO sancol_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","tadAnIM yIzustAnavOcat, asyAM rajanyAmahaM yuSmAkaM sarvvESAM vighnarUpO bhaviSyAmi, yatO likhitamAstE, \"mESANAM rakSakO yastaM prahariSyAmyahaM tataH| mESANAM nivahO nUnaM pravikIrNO bhaviSyati\"|| ");
INSERT INTO sancol_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","kintu zmazAnAt samutthAya yuSmAkamagrE'haM gAlIlaM gamiSyAmi| ");
INSERT INTO sancol_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","pitarastaM prOvAca, bhavAMzcEt sarvvESAM vighnarUpO bhavati, tathApi mama na bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","tatO yIzunA sa uktaH, tubhyamahaM tathyaM kathayAmi, yAminyAmasyAM caraNAyudhasya ravAt pUrvvaM tvaM mAM tri rnAggIkariSyasi| ");
INSERT INTO sancol_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","tataH pitara uditavAn, yadyapi tvayA samaM marttavyaM, tathApi kadApi tvAM na nAggIkariSyAmi; tathaiva sarvvE ziSyAzcOcuH| ");
INSERT INTO sancol_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","anantaraM yIzuH ziSyaiH sAkaM gEtzimAnInAmakaM sthAnaM prasthAya tEbhyaH kathitavAn, adaH sthAnaM gatvA yAvadahaM prArthayiSyE tAvad yUyamatrOpavizata| ");
INSERT INTO sancol_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","pazcAt sa pitaraM sivadiyasutau ca sagginaH kRtvA gatavAn, zOkAkulO'tIva vyathitazca babhUva| ");
INSERT INTO sancol_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","tAnavAdIcca mRtiyAtanEva matprANAnAM yAtanA jAyatE, yUyamatra mayA sArddhaM jAgRta| ");
INSERT INTO sancol_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","tataH sa kinjciddUraM gatvAdhOmukhaH patan prArthayAnjcakrE, hE matpitaryadi bhavituM zaknOti, tarhi kaMsO'yaM mattO dUraM yAtu; kintu madicchAvat na bhavatu, tvadicchAvad bhavatu| ");
INSERT INTO sancol_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","tataH sa ziSyAnupEtya tAn nidratO nirIkSya pitarAya kathayAmAsa, yUyaM mayA sAkaM daNPamEkamapi jAgarituM nAzankuta? ");
INSERT INTO sancol_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","parIkSAyAM na patituM jAgRta prArthayadhvanjca; AtmA samudyatOsti, kintu vapu rdurbbalaM| ");
INSERT INTO sancol_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","sa dvitIyavAraM prArthayAnjcakrE, hE mattAta, na pItE yadi kaMsamidaM mattO dUraM yAtuM na zaknOti, tarhi tvadicchAvad bhavatu| ");
INSERT INTO sancol_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","sa punarEtya tAn nidratO dadarza, yatastESAM nEtrANi nidrayA pUrNAnyAsan| ");
INSERT INTO sancol_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","pazcAt sa tAn vihAya vrajitvA tRtIyavAraM pUrvvavat kathayan prArthitavAn| ");
INSERT INTO sancol_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","tataH ziSyAnupAgatya gaditavAn, sAmprataM zayAnAH kiM vizrAmyatha? pazyata, samaya upAsthAt, manujasutaH pApinAM karESu samarpyatE| ");
INSERT INTO sancol_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","uttiSThata, vayaM yAmaH, yO mAM parakarESu masarpayiSyati, pazyata, sa samIpamAyAti| ");
INSERT INTO sancol_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","EtatkathAkathanakAlE dvAdazaziSyANAmEkO yihUdAnAmakO mukhyayAjakalOkaprAcInaiH prahitAn asidhAriyaSTidhAriNO manujAn gRhItvA tatsamIpamupatasthau| ");
INSERT INTO sancol_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","asau parakarESvarpayitA pUrvvaM tAn itthaM sagkEtayAmAsa, yamahaM cumbiSyE, sO'sau manujaH,saEva yuSmAbhi rdhAryyatAM| ");
INSERT INTO sancol_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","tadA sa sapadi yIzumupAgatya hE gurO, praNamAmItyuktvA taM cucumbE| ");
INSERT INTO sancol_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","tadA yIzustamuvAca, hE mitraM kimarthamAgatOsi? tadA tairAgatya yIzurAkramya daghrE| ");
INSERT INTO sancol_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","tatO yIzOH sagginAmEkaH karaM prasAryya kOSAdasiM bahiSkRtya mahAyAjakasya dAsamEkamAhatya tasya karNaM cicchEda| ");
INSERT INTO sancol_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","tatO yIzustaM jagAda, khaPgaM svasthAnEे nidhEhi yatO yE yE janA asiM dhArayanti, taEvAsinA vinazyanti| ");
INSERT INTO sancol_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","aparaM pitA yathA madantikaM svargIyadUtAnAM dvAdazavAhinItO'dhikaM prahiNuyAt mayA tamuddizyEdAnImEva tathA prArthayituM na zakyatE, tvayA kimitthaM jnjAyatE? ");
INSERT INTO sancol_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","tathA satItthaM ghaTiSyatE dharmmapustakasya yadidaM vAkyaM tat kathaM sidhyEt? ");
INSERT INTO sancol_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","tadAnIM yIzu rjananivahaM jagAda, yUyaM khaPgayaSTIn AdAya mAM kiM cauraM dharttumAyAtAH? ahaM pratyahaM yuSmAbhiH sAkamupavizya samupAdizaM, tadA mAM nAdharata; ");
INSERT INTO sancol_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","kintu bhaviSyadvAdinAM vAkyAnAM saMsiddhayE sarvvamEtadabhUt|tadA sarvvE ziSyAstaM vihAya palAyanta| ");
INSERT INTO sancol_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","anantaraM tE manujA yIzuM dhRtvA yatrAdhyApakaprAnjcaH pariSadaM kurvvanta upAvizan tatra kiyaphAnAाmakamahAyAjakasyAntikaM ninyuH| ");
INSERT INTO sancol_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","kintu zESE kiM bhaviSyatIti vEttuM pitarO dUrE tatpazcAd vrajitvA mahAyAjakasyATTAlikAM pravizya dAsaiH sahita upAvizat| ");
INSERT INTO sancol_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","tadAnIM pradhAnayAjakaprAcInamantriNaH sarvvE yIzuM hantuM mRSAsAkSyam alipsanta, ");
INSERT INTO sancol_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","kintu na lEbhirE| anEkESu mRSAsAkSiSvAgatESvapi tanna prApuH| ");
INSERT INTO sancol_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","zESE dvau mRSAsAkSiNAvAgatya jagadatuH, pumAnayamakathayat, ahamIzvaramandiraM bhaMktvA dinatrayamadhyE tannirmmAtuM zaknOmi| ");
INSERT INTO sancol_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","tadA mahAyAjaka utthAya yIzum avAdIt| tvaM kimapi na prativadasi? tvAmadhi kimEtE sAkSyaM vadanti? ");
INSERT INTO sancol_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","kintu yIzu rmaunIbhUya tasyau| tatO mahAyAjaka uktavAn, tvAm amarEzvaranAmnA zapayAmi, tvamIzvarasya putrO'bhiSiktO bhavasi navEti vada| ");
INSERT INTO sancol_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","yIzuH pratyavadat, tvaM satyamuktavAn; ahaM yuSmAn tathyaM vadAmi, itaHparaM manujasutaM sarvvazaktimatO dakSiNapArzvE sthAtuM gagaNasthaM jaladharAnAruhyAyAntaM vIkSadhvE| ");
INSERT INTO sancol_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","tadA mahAyAjakO nijavasanaM chittvA jagAda, ESa IzvaraM ninditavAn, asmAkamaparasAkSyENa kiM prayOjanaM? pazyata, yUyamEvAsyAsyAd IzvaranindAM zrutavantaH, ");
INSERT INTO sancol_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","yuSmAbhiH kiM vivicyatE? tE pratyUcuH, vadhArhO'yaM| ");
INSERT INTO sancol_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","tatO lOkaistadAsyE niSThIvitaM kEcit pratalamAhatya kEcicca capETamAhatya babhASirE, ");
INSERT INTO sancol_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","hE khrISTa tvAM kazcapETamAhatavAn? iti gaNayitvA vadAsmAn| ");
INSERT INTO sancol_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","pitarO bahiraggana upavizati, tadAnImEkA dAsI tamupAgatya babhASE, tvaM gAlIlIyayIzOH sahacaraEkaH| ");
INSERT INTO sancol_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","kintu sa sarvvESAM samakSam anaggIkRtyAvAdIt, tvayA yaducyatE, tadarthamahaM na vEdmi| ");
INSERT INTO sancol_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","tadA tasmin bahirdvAraM gatE 'nyA dAsI taM nirIkSya tatratyajanAnavadat, ayamapi nAsaratIyayIzunA sArddham AsIt| ");
INSERT INTO sancol_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","tataH sa zapathEna punaranaggIkRtya kathitavAn, taM naraM na paricinOmi| ");
INSERT INTO sancol_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","kSaNAt paraM tiSThantO janA Etya pitaram avadan, tvamavazyaM tESAmEka iti tvaduccAraNamEva dyOtayati| ");
INSERT INTO sancol_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","kintu sO'bhizapya kathitavAn, taM janaM nAhaM paricinOmi, tadA sapadi kukkuTO rurAva| ");
INSERT INTO sancol_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","kukkuTaravAt prAk tvaM mAM trirapAhnOSyasE, yaiSA vAg yIzunAvAdi tAM pitaraH saMsmRtya bahiritvA khEdAd bhRzaM cakranda| ");
INSERT INTO sancol_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","prabhAtE jAtE pradhAnayAjakalOkaprAcInA yIzuM hantuM tatpratikUlaM mantrayitvA ");
INSERT INTO sancol_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","taM badvvA nItvA pantIyapIlAtAkhyAdhipE samarpayAmAsuH| ");
INSERT INTO sancol_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","tatO yIzOH parakarEvvarpayitA yihUdAstatprANAdaNPAjnjAM viditvA santaptamanAH pradhAnayAjakalOkaprAcInAnAM samakSaM tAstrIMzanmudrAH pratidAyAvAdIt, ");
INSERT INTO sancol_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","EtannirAgOnaraprANaparakarArpaNAt kaluSaM kRtavAnahaM| tadA ta uditavantaH, tEnAsmAkaM kiM? tvayA tad budhyatAm| ");
INSERT INTO sancol_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","tatO yihUdA mandiramadhyE tA mudrA nikSipya prasthitavAn itvA ca svayamAtmAnamudbabandha| ");
INSERT INTO sancol_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","pazcAt pradhAnayAjakAstA mudrA AdAya kathitavantaH, EtA mudrAH zONitamUlyaM tasmAd bhANPAgArE na nidhAtavyAH| ");
INSERT INTO sancol_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","anantaraM tE mantrayitvA vidEzinAM zmazAnasthAnAya tAbhiH kulAlasya kSEtramakrINan| ");
INSERT INTO sancol_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","atO'dyApi tatsthAnaM raktakSEtraM vadanti| ");
INSERT INTO sancol_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","itthaM sati isrAyElIyasantAnai ryasya mUlyaM nirupitaM, tasya triMzanmudrAmAnaM mUlyaM ");
INSERT INTO sancol_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","mAM prati paramEzvarasyAdEzAt tEbhya AdIyata, tEna ca kulAlasya kSEtraM krItamiti yadvacanaM yirimiyabhaviSyadvAdinA prOktaM tat tadAsidhyat| ");
INSERT INTO sancol_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","anantaraM yIzau tadadhipatEH sammukha upatiSThati sa taM papraccha, tvaM kiM yihUdIyAnAM rAjA? tadA yIzustamavadat, tvaM satyamuktavAn| ");
INSERT INTO sancol_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","kintu pradhAnayAjakaprAcInairabhiyuktEna tEna kimapi na pratyavAdi| ");
INSERT INTO sancol_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","tataH pIlAtEna sa uditaH, imE tvatpratikUlataH kati kati sAkSyaM dadati, tat tvaM na zRNOSi? ");
INSERT INTO sancol_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","tathApi sa tESAmEkasyApi vacasa uttaraM nOditavAn; tEna sO'dhipati rmahAcitraM vidAmAsa| ");
INSERT INTO sancol_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","anyacca tanmahakAlE'dhipatErEtAdRzI rAtirAsIt, prajA yaM kanjcana bandhinaM yAcantE, tamEva sa mOcayatIti| ");
INSERT INTO sancol_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","tadAnIM barabbAnAmA kazcit khyAtabandhyAsIt| ");
INSERT INTO sancol_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","tataH pIlAtastatra militAn lOkAn apRcchat, ESa barabbA bandhI khrISTavikhyAtO yIzuzcaitayOH kaM mOcayiSyAmi? yuSmAkaM kimIpsitaM? ");
INSERT INTO sancol_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","tairIrSyayA sa samarpita iti sa jnjAtavAn| ");
INSERT INTO sancol_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","aparaM vicArAsanOpavEzanakAlE pIlAtasya patnI bhRtyaM prahitya tasmai kathayAmAsa, taM dhArmmikamanujaM prati tvayA kimapi na karttavyaM; yasmAt tatkRtE'dyAhaM svapnE prabhUtakaSTamalabhE| ");
INSERT INTO sancol_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","anantaraM pradhAnayAjakaprAcInA barabbAM yAcitvAdAtuM yIzunjca hantuM sakalalOkAn prAvarttayan| ");
INSERT INTO sancol_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","tatO'dhipatistAn pRSTavAn, EtayOH kamahaM mOcayiSyAmi? yuSmAkaM kEcchA? tE prOcu rbarabbAM| ");
INSERT INTO sancol_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","tadA pIlAtaH papraccha, tarhi yaM khrISTaM vadanti, taM yIzuM kiM kariSyAmi? sarvvE kathayAmAsuH, sa kruzEna vidhyatAM| ");
INSERT INTO sancol_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","tatO'dhipatiravAdIt, kutaH? kiM tEnAparAddhaM? kintu tE punarucai rjagaduH, sa kruzEna vidhyatAM| ");
INSERT INTO sancol_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","tadA nijavAkyamagrAhyamabhUt, kalahazcApyabhUt, pIlAta iti vilOkya lOkAnAM samakSaM tOyamAdAya karau prakSAlyAvOcat, Etasya dhArmmikamanuSyasya zONitapAtE nirdOSO'haM, yuSmAbhirEva tad budhyatAM| ");
INSERT INTO sancol_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","tadA sarvvAH prajAH pratyavOcan, tasya zONitapAtAparAdhO'smAkam asmatsantAnAnAnjcOpari bhavatu| ");
INSERT INTO sancol_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","tataH sa tESAM samIpE barabbAM mOcayAmAsa yIzuntu kaSAbhirAhatya kruzEna vEdhituM samarpayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","anantaram adhipatEH sEnA adhipatE rgRhaM yIzumAnIya tasya samIpE sEnAsamUhaM saMjagRhuH| ");
INSERT INTO sancol_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","tatastE tasya vasanaM mOcayitvA kRSNalOhitavarNavasanaM paridhApayAmAsuH ");
INSERT INTO sancol_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","kaNTakAnAM mukuTaM nirmmAya tacchirasi daduH, tasya dakSiNakarE vEtramEkaM dattvA tasya sammukhE jAnUni pAtayitvA, hE yihUdIyAnAM rAjan, tubhyaM nama ityuktvA taM tirazcakruH, ");
INSERT INTO sancol_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","tatastasya gAtrE niSThIvaM datvA tEna vEtrENa zira AjaghnuH| ");
INSERT INTO sancol_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","itthaM taM tiraskRtya tad vasanaM mOcayitvA punarnijavasanaM paridhApayAnjcakruH, taM kruzEna vEdhituM nItavantaH| ");
INSERT INTO sancol_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","pazcAttE bahirbhUya kurINIyaM zimOnnAmakamEkaM vilOkya kruzaM vOPhuM tamAdadirE| ");
INSERT INTO sancol_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","anantaraM gulgaltAm arthAt ziraskapAlanAmakasthAnamu pasthAya tE yIzavE pittamizritAmlarasaM pAtuM daduH, ");
INSERT INTO sancol_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","kintu sa tamAsvAdya na papau| ");
INSERT INTO sancol_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","tadAnIM tE taM kruzEna saMvidhya tasya vasanAni guTikApAtEna vibhajya jagRhuH, tasmAt, vibhajantE'dharIyaM mE tE manuSyAH parasparaM| maduttarIyavastrArthaM guTikAM pAtayanti ca||yadEtadvacanaM bhaviSyadvAdibhiruktamAsIt, tadA tad asidhyat, ");
INSERT INTO sancol_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","pazcAt tE tatrOpavizya tadrakSaNakarvvaNi niyuktAstasthuH| ");
INSERT INTO sancol_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","aparam ESa yihUdIyAnAM rAjA yIzurityapavAdalipipatraM tacchirasa UrdvvE yOjayAmAsuH| ");
INSERT INTO sancol_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","tatastasya vAmE dakSiNE ca dvau cairau tEna sAkaM kruzEna vividhuH| ");
INSERT INTO sancol_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","tadA pAnthA nijazirO lAPayitvA taM nindantO jagaduH, ");
INSERT INTO sancol_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","hE Izvaramandirabhanjjaka dinatrayE tannirmmAtaH svaM rakSa, cEttvamIzvarasutastarhi kruzAdavarOha| ");
INSERT INTO sancol_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","pradhAnayAjakAdhyApakaprAcInAzca tathA tiraskRtya jagaduH, ");
INSERT INTO sancol_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","sO'nyajanAnAvat, kintu svamavituM na zaknOti| yadIsrAyElO rAjA bhavEt, tarhIdAnImEva kruzAdavarOhatu, tEna taM vayaM pratyESyAmaH| ");
INSERT INTO sancol_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","sa IzvarE pratyAzAmakarOt, yadIzvarastasmin santuSTastarhIdAnImEva tamavEt, yataH sa uktavAn ahamIzvarasutaH| ");
INSERT INTO sancol_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","yau stEnau sAkaM tEna kruzEna viddhau tau tadvadEva taM ninindatuH| ");
INSERT INTO sancol_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","tadA dvitIyayAmAt tRtIyayAmaM yAvat sarvvadEzE tamiraM babhUva, ");
INSERT INTO sancol_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","tRtIyayAmE \"ElI ElI lAmA zivaktanI\", arthAt madIzvara madIzvara kutO mAmatyAkSIH? yIzuruccairiti jagAda| ");
INSERT INTO sancol_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","tadA tatra sthitAH kEcit tat zrutvA babhASirE, ayam EliyamAhUyati| ");
INSERT INTO sancol_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","tESAM madhyAd EkaH zIghraM gatvA spanjjaM gRhItvA tatrAmlarasaM dattvA nalEna pAtuM tasmai dadau| ");
INSERT INTO sancol_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","itarE'kathayan tiSThata, taM rakSitum Eliya AyAti navEti pazyAmaH| ");
INSERT INTO sancol_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","yIzuH punarucairAhUya prANAn jahau| ");
INSERT INTO sancol_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","tatO mandirasya vicchEdavasanam UrdvvAdadhO yAvat chidyamAnaM dvidhAbhavat, ");
INSERT INTO sancol_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","bhUmizcakampE bhUdharOvyadIryyata ca| zmazAnE muktE bhUripuNyavatAM suptadEhA udatiSThan, ");
INSERT INTO sancol_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","zmazAnAd vahirbhUya tadutthAnAt paraM puNyapuraM gatvA bahujanAn darzayAmAsuH| ");
INSERT INTO sancol_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","yIzurakSaNAya niyuktaH zatasEnApatistatsagginazca tAdRzIM bhUkampAdighaTanAM dRSTvA bhItA avadan, ESa IzvaraputrO bhavati| ");
INSERT INTO sancol_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","yA bahuyOSitO yIzuM sEvamAnA gAlIlastatpazcAdAgatAstAsAM madhyE ");
INSERT INTO sancol_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","magdalInI mariyam yAkUbyOzyO rmAtA yA mariyam sibadiyaputrayO rmAtA ca yOSita EtA dUrE tiSThantyO dadRzuH| ");
INSERT INTO sancol_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","sandhyAyAM satyam arimathiyAnagarasya yUSaphnAmA dhanI manujO yIzOH ziSyatvAt ");
INSERT INTO sancol_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","pIlAtasya samIpaM gatvA yIzOH kAyaM yayAcE, tEna pIlAtaH kAyaM dAtum AdidEza| ");
INSERT INTO sancol_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","yUSaph tatkAyaM nItvA zucivastrENAcchAdya ");
INSERT INTO sancol_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","svArthaM zailE yat zmazAnaM cakhAna, tanmadhyE tatkAyaM nidhAya tasya dvAri vRhatpASANaM dadau| ");
INSERT INTO sancol_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","kintu magdalInI mariyam anyamariyam EtE striyau tatra zmazAnasammukha upavivizatuH| ");
INSERT INTO sancol_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","tadanantaraM nistArOtsavasyAyOjanadinAt parE'hani pradhAnayAjakAH phirUzinazca militvA pIlAtamupAgatyAkathayan, ");
INSERT INTO sancol_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","hE mahEccha sa pratArakO jIvana akathayat, dinatrayAt paraM zmazAnAdutthAsyAmi tadvAkyaM smarAmO vayaM; ");
INSERT INTO sancol_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","tasmAt tRtIyadinaM yAvat tat zmazAnaM rakSitumAdizatu, nOcEt tacchiSyA yAminyAmAgatya taM hRtvA lOkAn vadiSyanti, sa zmazAnAdudatiSThat, tathA sati prathamabhrAntEH zESIyabhrAnti rmahatI bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","tadA pIlAta avAdIt, yuSmAkaM samIpE rakSigaNa AstE, yUyaM gatvA yathA sAdhyaM rakSayata| ");
INSERT INTO sancol_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","tatastE gatvA taddUाrapASANaM mudrAgkitaM kRtvA rakSigaNaM niyOjya zmazAnaM rakSayAmAsuH| ");
INSERT INTO sancol_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","tataH paraM vizrAmavArasya zESE saptAhaprathamadinasya prabhOtE jAtE magdalInI mariyam anyamariyam ca zmazAnaM draSTumAgatA| ");
INSERT INTO sancol_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","tadA mahAn bhUkampO'bhavat; paramEzvarIyadUtaH svargAdavaruhya zmazAnadvArAt pASANamapasAryya taduparyyupavivEza| ");
INSERT INTO sancol_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","tadvadanaM vidyudvat tEjOmayaM vasanaM himazubhranjca| ");
INSERT INTO sancol_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","tadAnIM rakSiNastadbhayAt kampitA mRtavad babhUvaH| ");
INSERT INTO sancol_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","sa dUtO yOSitO jagAda, yUyaM mA bhaiSTa, kruzahatayIzuM mRgayadhvE tadahaM vEdmi| ");
INSERT INTO sancol_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","sO'tra nAsti, yathAvadat tathOtthitavAn; Etat prabhOH zayanasthAnaM pazyata| ");
INSERT INTO sancol_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","tUrNaM gatvA tacchiSyAn iti vadata, sa zmazAnAd udatiSThat, yuSmAkamagrE gAlIlaM yAsyati yUyaM tatra taM vIkSiSyadhvE, pazyatAhaM vArttAmimAM yuSmAnavAdiSaM| ");
INSERT INTO sancol_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","tatastA bhayAt mahAnandAnjca zmazAnAt tUrNaM bahirbhUya tacchiSyAn vArttAM vaktuM dhAvitavatyaH| kintu ziSyAn vArttAM vaktuM yAnti, tadA yIzu rdarzanaM dattvA tA jagAda, ");
INSERT INTO sancol_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","yuSmAkaM kalyANaM bhUyAt, tatastA Agatya tatpAdayOH patitvA praNEmuH| ");
INSERT INTO sancol_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","yIzustA avAdIt, mA bibhIta, yUyaM gatvA mama bhrAtRn gAlIlaM yAtuM vadata, tatra tE mAM drakSyanti| ");
INSERT INTO sancol_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","striyO gacchanti, tadA rakSiNAM kEcit puraM gatvA yadyad ghaTitaM tatsarvvaM pradhAnayAjakAn jnjApitavantaH| ");
INSERT INTO sancol_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","tE prAcInaiH samaM saMsadaM kRtvA mantrayantO bahumudrAH sEnAbhyO dattvAvadan, ");
INSERT INTO sancol_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","asmAsu nidritESu tacchiSyA yAminyAmAgatya taM hRtvAnayan, iti yUyaM pracArayata| ");
INSERT INTO sancol_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","yadyEtadadhipatEH zrOtragOcarIbhavEt, tarhi taM bOdhayitvA yuSmAnaviSyAmaH| ");
INSERT INTO sancol_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","tatastE mudrA gRhItvA zikSAnurUpaM karmma cakruH, yihUdIyAnAM madhyE tasyAdyApi kiMvadantI vidyatE| ");
INSERT INTO sancol_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","EkAdaza ziSyA yIzunirUpitAgAlIlasyAdriM gatvA ");
INSERT INTO sancol_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","tatra taM saMvIkSya praNEmuH, kintu kEcit sandigdhavantaH| ");
INSERT INTO sancol_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","yIzustESAM samIpamAgatya vyAhRtavAn, svargamEdinyOH sarvvAdhipatitvabhArO mayyarpita AstE| ");
INSERT INTO sancol_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","atO yUyaM prayAya sarvvadEzIyAn ziSyAn kRtvA pituH putrasya pavitrasyAtmanazca nAmnA tAnavagAhayata; ahaM yuSmAn yadyadAdizaM tadapi pAlayituM tAnupAdizata| ");
INSERT INTO sancol_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","pazyata, jagadantaM yAvat sadAhaM yuSmAbhiH sAkaM tiSThAmi| iti|");
INSERT INTO sancol_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Izvaraputrasya yIzukhrISTasya susaMvAdArambhaH| ");
INSERT INTO sancol_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","bhaviSyadvAdinAM granthESu lipiritthamAstE, pazya svakIyadUtantu tavAgrE prESayAmyaham| gatvA tvadIyapanthAnaM sa hi pariSkariSyati| ");
INSERT INTO sancol_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","\"paramEzasya panthAnaM pariSkuruta sarvvataH| tasya rAjapathanjcaiva samAnaM kurutAdhunA|\" ityEtat prAntarE vAkyaM vadataH kasyacidravaH|| ");
INSERT INTO sancol_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","saEva yOhan prAntarE majjitavAn tathA pApamArjananimittaM manOvyAvarttakamajjanasya kathAnjca pracAritavAn| ");
INSERT INTO sancol_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","tatO yihUdAdEzayirUzAlamnagaranivAsinaH sarvvE lOkA bahi rbhUtvA tasya samIpamAgatya svAni svAni pApAnyaggIkRtya yarddananadyAM tEna majjitA babhUvuH| ");
INSERT INTO sancol_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","asya yOhanaH paridhEyAni kramElakalOmajAni, tasya kaTibandhanaM carmmajAtam, tasya bhakSyANi ca zUkakITA vanyamadhUni cAsan| ");
INSERT INTO sancol_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","sa pracArayan kathayAnjcakrE, ahaM namrIbhUya yasya pAdukAbandhanaM mOcayitumapi na yOgyOsmi, tAdRzO mattO gurutara EkaH puruSO matpazcAdAgacchati| ");
INSERT INTO sancol_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ahaM yuSmAn jalE majjitavAn kintu sa pavitra AtmAni saMmajjayiSyati| ");
INSERT INTO sancol_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","aparanjca tasminnEva kAlE gAlIlpradEzasya nAsaradgrAmAd yIzurAgatya yOhanA yarddananadyAM majjitO'bhUt| ");
INSERT INTO sancol_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","sa jalAdutthitamAtrO mEghadvAraM muktaM kapOtavat svasyOpari avarOhantamAtmAnanjca dRSTavAn| ");
INSERT INTO sancol_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","tvaM mama priyaH putrastvayyEva mamamahAsantOSa iyamAkAzIyA vANI babhUva| ");
INSERT INTO sancol_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","tasmin kAlE AtmA taM prAntaramadhyaM ninAya| ");
INSERT INTO sancol_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","atha sa catvAriMzaddinAni tasmin sthAnE vanyapazubhiH saha tiSThan zaitAnA parIkSitaH; pazcAt svargIyadUtAstaM siSEvirE| ");
INSERT INTO sancol_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","anantaraM yOhani bandhanAlayE baddhE sati yIzu rgAlIlpradEzamAgatya IzvararAjyasya susaMvAdaM pracArayan kathayAmAsa, ");
INSERT INTO sancol_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","kAlaH sampUrNa IzvararAjyanjca samIpamAgataM; atOhEtO ryUyaM manAMsi vyAvarttayadhvaM susaMvAdE ca vizvAsita| ");
INSERT INTO sancol_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","tadanantaraM sa gAlIlIyasamudrasya tIrE gacchan zimOn tasya bhrAtA andriyanAmA ca imau dvau janau matsyadhAriNau sAgaramadhyE jAlaM prakSipantau dRSTvA tAvavadat, ");
INSERT INTO sancol_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","yuvAM mama pazcAdAgacchataM, yuvAmahaM manuSyadhAriNau kariSyAmi| ");
INSERT INTO sancol_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","tatastau tatkSaNamEva jAlAni parityajya tasya pazcAt jagmatuH| ");
INSERT INTO sancol_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","tataH paraM tatsthAnAt kinjcid dUraM gatvA sa sivadIputrayAkUb tadbhrAtRyOhan ca imau naukAyAM jAlAnAM jIrNamuddhArayantau dRSTvA tAvAhUyat| ");
INSERT INTO sancol_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","tatastau naukAyAM vEtanabhugbhiH sahitaM svapitaraM vihAya tatpazcAdIyatuH| ");
INSERT INTO sancol_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","tataH paraM kapharnAhUmnAmakaM nagaramupasthAya sa vizrAmadivasE bhajanagrahaM pravizya samupadidEza| ");
INSERT INTO sancol_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","tasyOpadEzAllOkA AzcaryyaM mEnirE yataH sOdhyApakAiva nOpadizan prabhAvavAniva prOpadidEza| ");
INSERT INTO sancol_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","aparanjca tasmin bhajanagRhE apavitrabhUtEna grasta EkO mAnuSa AsIt| sa cItzabdaM kRtvA kathayAnjcakE ");
INSERT INTO sancol_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","bhO nAsaratIya yIzO tvamasmAn tyaja, tvayA sahAsmAkaM kaH sambandhaH? tvaM kimasmAn nAzayituM samAgataH? tvamIzvarasya pavitralOka ityahaM jAnAmi| ");
INSERT INTO sancol_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","tadA yIzustaM tarjayitvA jagAda tUSNIM bhava itO bahirbhava ca| ");
INSERT INTO sancol_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","tataH sO'pavitrabhUtastaM sampIPya atyucaizcItkRtya nirjagAma| ");
INSERT INTO sancol_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","tEnaiva sarvvE camatkRtya parasparaM kathayAnjcakrirE, ahO kimidaM? kIdRzO'yaM navya upadEzaH? anEna prabhAvEnApavitrabhUtESvAjnjApitESu tE tadAjnjAnuvarttinO bhavanti| ");
INSERT INTO sancol_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","tadA tasya yazO gAlIlazcaturdiksthasarvvadEzAn vyApnOt| ");
INSERT INTO sancol_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","aparanjca tE bhajanagRhAd bahi rbhUtvA yAkUbyOhanbhyAM saha zimOna Andriyasya ca nivEzanaM pravivizuH| ");
INSERT INTO sancol_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","tadA pitarasya zvazrUrjvarapIPitA zayyAyAmAsta iti tE taM jhaTiti vijnjApayAnjcakruH| ");
INSERT INTO sancol_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","tataH sa Agatya tasyA hastaM dhRtvA tAmudasthApayat; tadaiva tAM jvarO'tyAkSIt tataH paraM sA tAn siSEvE| ");
INSERT INTO sancol_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","athAstaM gatE ravau sandhyAkAlE sati lOkAstatsamIpaM sarvvAn rOgiNO bhUtadhRtAMzca samAninyuH| ");
INSERT INTO sancol_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","sarvvE nAgarikA lOkA dvAri saMmilitAzca| ");
INSERT INTO sancol_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","tataH sa nAnAvidharOgiNO bahUn manujAnarOgiNazcakAra tathA bahUn bhUtAn tyAjayAnjcakAra tAn bhUtAn kimapi vAkyaM vaktuM niSiSEdha ca yatOhEtOstE tamajAnan| ");
INSERT INTO sancol_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","aparanjca sO'tipratyUSE vastutastu rAtrizESE samutthAya bahirbhUya nirjanaM sthAnaM gatvA tatra prArthayAnjcakrE| ");
INSERT INTO sancol_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","anantaraM zimOn tatsagginazca tasya pazcAd gatavantaH| ");
INSERT INTO sancol_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","taduddEzaM prApya tamavadan sarvvE lOkAstvAM mRgayantE| ");
INSERT INTO sancol_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","tadA sO'kathayat Agacchata vayaM samIpasthAni nagarANi yAmaH, yatO'haM tatra kathAM pracArayituM bahirAgamam| ");
INSERT INTO sancol_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","atha sa tESAM gAlIlpradEzasya sarvvESu bhajanagRhESu kathAH pracArayAnjcakrE bhUtAnatyAjayanjca| ");
INSERT INTO sancol_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","anantaramEkaH kuSThI samAgatya tatsammukhE jAnupAtaM vinayanjca kRtvA kathitavAn yadi bhavAn icchati tarhi mAM pariSkarttuM zaknOti| ");
INSERT INTO sancol_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","tataH kRpAlu ryIzuH karau prasAryya taM spaSTvA kathayAmAsa ");
INSERT INTO sancol_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","mamEcchA vidyatE tvaM pariSkRtO bhava| EtatkathAyAH kathanamAtrAt sa kuSThI rOgAnmuktaH pariSkRtO'bhavat| ");
INSERT INTO sancol_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","tadA sa taM visRjan gAPhamAdizya jagAda ");
INSERT INTO sancol_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","sAvadhAnO bhava kathAmimAM kamapi mA vada; svAtmAnaM yAjakaM darzaya, lOkEbhyaH svapariSkRtEH pramANadAnAya mUsAnirNItaM yaddAnaM tadutsRjasva ca| ");
INSERT INTO sancol_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","kintu sa gatvA tat karmma itthaM vistAryya pracArayituM prArEbhE tEnaiva yIzuH punaH saprakAzaM nagaraM pravESTuM nAzaknOt tatOhEtOrbahiH kAnanasthAnE tasyau; tathApi caturddigbhyO lOkAstasya samIpamAyayuH| ");
INSERT INTO sancol_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","tadanantaraM yIzai katipayadinAni vilambya punaH kapharnAhUmnagaraM praviSTE sa gRha Asta iti kiMvadantyA tatkSaNaM tatsamIpaM bahavO lOkA Agatya samupatasthuH, ");
INSERT INTO sancol_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","tasmAd gRhamadhyE sarvvESAM kRtE sthAnaM nAbhavad dvArasya caturdikSvapi nAbhavat, tatkAlE sa tAn prati kathAM pracArayAnjcakrE| ");
INSERT INTO sancol_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","tataH paraM lOkAzcaturbhi rmAnavairEkaM pakSAghAtinaM vAhayitvA tatsamIpam AninyuH| ");
INSERT INTO sancol_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","kintu janAnAM bahutvAt taM yIzOH sammukhamAnEtuM na zaknuvantO yasmin sthAnE sa AstE taduparigRhapRSThaM khanitvA chidraM kRtvA tEna mArgENa sazayyaM pakSAghAtinam avarOhayAmAsuH| ");
INSERT INTO sancol_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","tatO yIzustESAM vizvAsaM dRSTvA taM pakSAghAtinaM babhASE hE vatsa tava pApAnAM mArjanaM bhavatu| ");
INSERT INTO sancol_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","tadA kiyantO'dhyApakAstatrOpavizantO manObhi rvitarkayAnjcakruH, ESa manuSya EtAdRzImIzvaranindAM kathAM kutaH kathayati? ");
INSERT INTO sancol_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","IzvaraM vinA pApAni mArSTuM kasya sAmarthyam AstE? ");
INSERT INTO sancol_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","itthaM tE vitarkayanti yIzustatkSaNaM manasA tad budvvA tAnavadad yUyamantaHkaraNaiH kuta EtAni vitarkayatha? ");
INSERT INTO sancol_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","tadanantaraM yIzustatsthAnAt punaH samudrataTaM yayau; lOkanivahE tatsamIpamAgatE sa tAn samupadidEza| ");
INSERT INTO sancol_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","kintu pRthivyAM pApAni mArSTuM manuSyaputrasya sAmarthyamasti, Etad yuSmAn jnjApayituM (sa tasmai pakSAghAtinE kathayAmAsa) ");
INSERT INTO sancol_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","uttiSTha tava zayyAM gRhItvA svagRhaM yAhi, ahaM tvAmidam AjnjApayAmi| ");
INSERT INTO sancol_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","tataH sa tatkSaNam utthAya zayyAM gRhItvA sarvvESAM sAkSAt jagAma; sarvvE vismitA EtAdRzaM karmma vayam kadApi nApazyAma, imAM kathAM kathayitvEzvaraM dhanyamabruvan| ");
INSERT INTO sancol_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","tadanantaraM yIzustatsthAnAt punaH samudrataTaM yayau; lOkanivahE tatsamIpamAgatE sa tAn samupadidEza| ");
INSERT INTO sancol_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","atha gacchan karasanjcayagRha upaviSTam AlphIyaputraM lEviM dRSTvA tamAhUya kathitavAn matpazcAt tvAmAmaccha tataH sa utthAya tatpazcAd yayau| ");
INSERT INTO sancol_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","anantaraM yIzau tasya gRhE bhOktum upaviSTE bahavaH karamanjcAyinaH pApinazca tEna tacchiSyaizca sahOpavivizuH, yatO bahavastatpazcAdAjagmuH| ");
INSERT INTO sancol_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","tadA sa karamanjcAyibhiH pApibhizca saha khAdati, tad dRSTvAdhyApakAH phirUzinazca tasya ziSyAnUcuH karamanjcAyibhiH pApibhizca sahAyaM kutO bhuMktE pivati ca? ");
INSERT INTO sancol_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","tadvAkyaM zrutvA yIzuH pratyuvAca,arOgilOkAnAM cikitsakEna prayOjanaM nAsti, kintu rOgiNAmEva; ahaM dhArmmikAnAhvAtuM nAgataH kintu manO vyAvarttayituM pApina Eva| ");
INSERT INTO sancol_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","tataH paraM yOhanaH phirUzinAnjcOpavAsAcAriziSyA yIzOH samIpam Agatya kathayAmAsuH, yOhanaH phirUzinAnjca ziSyA upavasanti kintu bhavataH ziSyA nOpavasanti kiM kAraNamasya? ");
INSERT INTO sancol_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","tadA yIzustAn babhASE yAvat kAlaM sakhibhiH saha kanyAyA varastiSThati tAvatkAlaM tE kimupavastuM zaknuvanti? yAvatkAlaM varastaiH saha tiSThati tAvatkAlaM ta upavastuM na zaknuvanti| ");
INSERT INTO sancol_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","yasmin kAlE tEbhyaH sakAzAd varO nESyatE sa kAla Agacchati, tasmin kAlE tE janA upavatsyanti| ");
INSERT INTO sancol_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","kOpi janaH purAtanavastrE nUtanavastraM na sIvyati, yatO nUtanavastrENa saha sEvanE kRtE jIrNaM vastraM chidyatE tasmAt puna rmahat chidraM jAyatE| ");
INSERT INTO sancol_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","kOpi janaH purAtanakutUSu nUtanaM drAkSArasaM na sthApayati, yatO nUtanadrAkSArasasya tEjasA tAH kutvO vidIryyantE tatO drAkSArasazca patati kutvazca nazyanti, ataEva nUtanadrAkSArasO nUtanakutUSu sthApanIyaH| ");
INSERT INTO sancol_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","tadanantaraM yIzu ryadA vizrAmavArE zasyakSEtrENa gacchati tadA tasya ziSyA gacchantaH zasyamanjjarIzchEttuM pravRttAH| ");
INSERT INTO sancol_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ataH phirUzinO yIzavE kathayAmAsuH pazyatu vizrAmavAsarE yat karmma na karttavyaM tad imE kutaH kurvvanti? ");
INSERT INTO sancol_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","tadA sa tEbhyO'kathayat dAyUd tatsaMgginazca bhakSyAbhAvAt kSudhitAH santO yat karmma kRtavantastat kiM yuSmAbhi rna paThitam? ");
INSERT INTO sancol_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","abiyAtharnAmakE mahAyAjakatAM kurvvati sa kathamIzvarasyAvAsaM pravizya yE darzanIyapUpA yAjakAn vinAnyasya kasyApi na bhakSyAstAnEva bubhujE saggilOkEbhyO'pi dadau| ");
INSERT INTO sancol_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","sO'paramapi jagAda, vizrAmavArO manuSyArthamEva nirUpitO'sti kintu manuSyO vizrAmavArArthaM naiva| ");
INSERT INTO sancol_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","manuSyaputrO vizrAmavArasyApi prabhurAstE| ");
INSERT INTO sancol_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","anantaraM yIzuH puna rbhajanagRhaM praviSTastasmin sthAnE zuSkahasta EkO mAnava AsIt| ");
INSERT INTO sancol_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","sa vizrAmavArE tamarOgiNaM kariSyati navEtyatra bahavastam apavadituM chidramapEkSitavantaH| ");
INSERT INTO sancol_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","tadA sa taM zuSkahastaM manuSyaM jagAda madhyasthAnE tvamuttiSTha| ");
INSERT INTO sancol_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","tataH paraM sa tAn papraccha vizrAmavArE hitamahitaM tathA hi prANarakSA vA prANanAza ESAM madhyE kiM karaNIyaM ? kintu tE niHzabdAstasthuH| ");
INSERT INTO sancol_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","tadA sa tESAmantaHkaraNAnAM kAThinyAddhEtO rduHkhitaH krOdhAt cartuिdazO dRSTavAn taM mAnuSaM gaditavAn taM hastaM vistAraya, tatastEna hastE vistRtE taddhastO'nyahastavad arOgO jAtaH| ");
INSERT INTO sancol_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","atha phirUzinaH prasthAya taM nAzayituM hErOdIyaiH saha mantrayitumArEbhirE| ");
INSERT INTO sancol_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ataEva yIzustatsthAnaM parityajya ziSyaiH saha punaH sAgarasamIpaM gataH; ");
INSERT INTO sancol_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","tatO gAlIlyihUdA-yirUzAlam-idOm-yardannadIpArasthAnEbhyO lOkasamUhastasya pazcAd gataH; tadanyaH sOrasIdanOH samIpavAsilOkasamUhazca tasya mahAkarmmaNAM vArttaM zrutvA tasya sannidhimAgataH| ");
INSERT INTO sancol_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","tadA lOkasamUhazcEt tasyOpari patati ityAzagkya sa nAvamEkAM nikaTE sthApayituM ziSyAnAdiSTavAn| ");
INSERT INTO sancol_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","yatO'nEkamanuSyANAmArOgyakaraNAd vyAdhigrastAH sarvvE taM spraSTuM parasparaM balEna yatnavantaH| ");
INSERT INTO sancol_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","aparanjca apavitrabhUtAstaM dRSTvA taccaraNayOH patitvA prOcaiH prOcuH, tvamIzvarasya putraH| ");
INSERT INTO sancol_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","kintu sa tAn dRPham AjnjApya svaM paricAyituM niSiddhavAn| ");
INSERT INTO sancol_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","anantaraM sa parvvatamAruhya yaM yaM praticchA taM tamAhUtavAn tatastE tatsamIpamAgatAH| ");
INSERT INTO sancol_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","tadA sa dvAdazajanAn svEna saha sthAtuM susaMvAdapracArAya prEritA bhavituM ");
INSERT INTO sancol_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","sarvvaprakAravyAdhInAM zamanakaraNAya prabhAvaM prAptuM bhUtAn tyAjayitunjca niyuktavAn| ");
INSERT INTO sancol_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","tESAM nAmAnImAni, zimOn sivadiputrO ");
INSERT INTO sancol_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","yAkUb tasya bhrAtA yOhan ca AndriyaH philipO barthalamayaH, ");
INSERT INTO sancol_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","mathI thOmA ca AlphIyaputrO yAkUb thaddIyaH kinAnIyaH zimOn yastaM parahastESvarpayiSyati sa ISkariyOtIyayihUdAzca| ");
INSERT INTO sancol_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","sa zimOnE pitara ityupanAma dadau yAkUbyOhanbhyAM ca binErigiz arthatO mEghanAdaputrAvityupanAma dadau| ");
INSERT INTO sancol_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","anantaraM tE nivEzanaM gatAH, kintu tatrApi punarmahAn janasamAgamO 'bhavat tasmAttE bhOktumapyavakAzaM na prAptAH| ");
INSERT INTO sancol_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","tatastasya suhRllOkA imAM vArttAM prApya sa hatajnjAnObhUd iti kathAM kathayitvA taM dhRtvAnEtuM gatAH| ");
INSERT INTO sancol_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","aparanjca yirUzAlama AgatA yE yE'dhyApakAstE jagadurayaM puruSO bhUtapatyAbiSTastEna bhUtapatinA bhUtAn tyAjayati| ");
INSERT INTO sancol_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","tatastAnAhUya yIzu rdRSTAntaiH kathAM kathitavAn zaitAn kathaM zaitAnaM tyAjayituM zaknOti? ");
INSERT INTO sancol_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","kinjcana rAjyaM yadi svavirOdhEna pRthag bhavati tarhi tad rAjyaM sthiraM sthAtuM na zaknOti| ");
INSERT INTO sancol_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","tathA kasyApi parivArO yadi parasparaM virOdhI bhavati tarhi sOpi parivAraH sthiraM sthAtuM na zaknOti| ");
INSERT INTO sancol_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","tadvat zaitAn yadi svavipakSatayA uttiSThan bhinnO bhavati tarhi sOpi sthiraM sthAtuM na zaknOti kintUcchinnO bhavati| ");
INSERT INTO sancol_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","aparanjca prabalaM janaM prathamaM na baddhA kOpi tasya gRhaM pravizya dravyANi luNThayituM na zaknOti, taM badvvaiva tasya gRhasya dravyANi luNThayituM zaknOti| ");
INSERT INTO sancol_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","atOhEtO ryuSmabhyamahaM satyaM kathayAmi manuSyANAM santAnA yAni yAni pApAnIzvaranindAnjca kurvvanti tESAM tatsarvvESAmaparAdhAnAM kSamA bhavituM zaknOti, ");
INSERT INTO sancol_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","kintu yaH kazcit pavitramAtmAnaM nindati tasyAparAdhasya kSamA kadApi na bhaviSyati sOnantadaNPasyArhO bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","tasyApavitrabhUtO'sti tESAmEtatkathAhEtOH sa itthaM kathitavAn| ");
INSERT INTO sancol_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","atha tasya mAtA bhrAtRgaNazcAgatya bahistiSThanatO lOkAn prESya tamAhUtavantaH| ");
INSERT INTO sancol_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","tatastatsannidhau samupaviSTA lOkAstaM babhASirE pazya bahistava mAtA bhrAtarazca tvAm anvicchanti| ");
INSERT INTO sancol_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","tadA sa tAn pratyuvAca mama mAtA kA bhrAtarO vA kE? tataH paraM sa svamIpOpaviSTAn ziSyAn prati avalOkanaM kRtvA kathayAmAsa ");
INSERT INTO sancol_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","pazyataitE mama mAtA bhrAtarazca| ");
INSERT INTO sancol_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","yaH kazcid IzvarasyESTAM kriyAM karOti sa Eva mama bhrAtA bhaginI mAtA ca| ");
INSERT INTO sancol_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","anantaraM sa samudrataTE punarupadESTuM prArEbhE, tatastatra bahujanAnAM samAgamAt sa sAgarOpari naukAmAruhya samupaviSTaH; sarvvE lOkAH samudrakUlE tasthuH| ");
INSERT INTO sancol_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","tadA sa dRSTAntakathAbhi rbahUpadiSTavAn upadizaMzca kathitavAn, ");
INSERT INTO sancol_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","avadhAnaM kuruta, EkO bIjavaptA bIjAni vaptuM gataH; ");
INSERT INTO sancol_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","vapanakAlE kiyanti bIjAni mArgapAzvE patitAni, tata AkAzIyapakSiNa Etya tAni cakhAduH| ");
INSERT INTO sancol_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","kiyanti bIjAni svalpamRttikAvatpASANabhUmau patitAni tAni mRdOlpatvAt zIghramagkuritAni; ");
INSERT INTO sancol_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","kintUditE sUryyE dagdhAni tathA mUlAnO nAdhOgatatvAt zuSkANi ca| ");
INSERT INTO sancol_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","kiyanti bIjAni kaNTakivanamadhyE patitAni tataH kaNTakAni saMvRdvya tAni jagrasustAni na ca phalitAni| ");
INSERT INTO sancol_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","tathA kiyanti bIjAnyuttamabhUmau patitAni tAni saMvRdvya phalAnyutpAditAni kiyanti bIjAni triMzadguNAni kiyanti SaSTiguNAni kiyanti zataguNAni phalAni phalitavanti| ");
INSERT INTO sancol_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","atha sa tAnavadat yasya zrOtuM karNau staH sa zRNOtu| ");
INSERT INTO sancol_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","tadanantaraM nirjanasamayE tatsagginO dvAdazaziSyAzca taM taddRSTAntavAkyasyArthaM papracchuH| ");
INSERT INTO sancol_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","tadA sa tAnuditavAn IzvararAjyasya nigUPhavAkyaM bOddhuM yuSmAkamadhikArO'sti; ");
INSERT INTO sancol_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","kintu yE vahirbhUtAH \"tE pazyantaH pazyanti kintu na jAnanti, zRNvantaH zRNvanti kintu na budhyantE, cEttai rmanaHsu kadApi parivarttitESu tESAM pApAnyamOcayiSyanta,\" atOhEtOstAn prati dRSTAntairEva tAni mayA kathitAni| ");
INSERT INTO sancol_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","atha sa kathitavAn yUyaM kimEtad dRSTAntavAkyaM na budhyadhvE? tarhi kathaM sarvvAn dRSTAntAna bhOtsyadhvE? ");
INSERT INTO sancol_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","bIjavaptA vAkyarUpANi bIjAni vapati; ");
INSERT INTO sancol_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","tatra yE yE lOkA vAkyaM zRNvanti, kintu zrutamAtrAt zaitAn zIghramAgatya tESAM manaHsUptAni tAni vAkyarUpANi bIjAnyapanayati taEva uptabIjamArgapArzvEsvarUpAH| ");
INSERT INTO sancol_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","yE janA vAkyaM zrutvA sahasA paramAnandEna gRhlanti, kintu hRdi sthairyyAbhAvAt kinjcit kAlamAtraM tiSThanti tatpazcAt tadvAkyahEtOH ");
INSERT INTO sancol_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","kutracit klEzE upadravE vA samupasthitE tadaiva vighnaM prApnuvanti taEva uptabIjapASANabhUmisvarUpAH| ");
INSERT INTO sancol_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","yE janAH kathAM zRNvanti kintu sAMsArikI cintA dhanabhrAnti rviSayalObhazca EtE sarvvE upasthAya tAM kathAM grasanti tataH mA viphalA bhavati ");
INSERT INTO sancol_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","taEva uptabIjasakaNTakabhUmisvarUpAH| ");
INSERT INTO sancol_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","yE janA vAkyaM zrutvA gRhlanti tESAM kasya vA triMzadguNAni kasya vA SaSTiguNAni kasya vA zataguNAni phalAni bhavanti taEva uptabIjOrvvarabhUmisvarUpAH| ");
INSERT INTO sancol_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","tadA sO'paramapi kathitavAn kOpi janO dIpAdhAraM parityajya drONasyAdhaH khaTvAyA adhE vA sthApayituM dIpamAnayati kiM? ");
INSERT INTO sancol_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","atOhEtO ryanna prakAzayiSyatE tAdRg lukkAyitaM kimapi vastu nAsti; yad vyaktaM na bhaviSyati tAdRzaM guptaM kimapi vastu nAsti| ");
INSERT INTO sancol_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","yasya zrOtuM karNau staH sa zRNOtu| ");
INSERT INTO sancol_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","aparamapi kathitavAn yUyaM yad yad vAkyaM zRNutha tatra sAvadhAnA bhavata, yatO yUyaM yEna parimANEna parimAtha tEnaiva parimANEna yuSmadarthamapi parimAsyatE; zrOtArO yUyaM yuSmabhyamadhikaM dAsyatE| ");
INSERT INTO sancol_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","yasyAzrayE varddhatE tasmai aparamapi dAsyatE, kintu yasyAzrayE na varddhatE tasya yat kinjcidasti tadapi tasmAn nESyatE| ");
INSERT INTO sancol_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","anantaraM sa kathitavAn EkO lOkaH kSEtrE bIjAnyuptvA ");
INSERT INTO sancol_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","jAgaraNanidrAbhyAM divAnizaM gamayati, parantu tadvIjaM tasyAjnjAtarUpENAgkurayati varddhatE ca; ");
INSERT INTO sancol_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","yatOhEtOH prathamataH patrANi tataH paraM kaNizAni tatpazcAt kaNizapUrNAni zasyAni bhUmiH svayamutpAdayati; ");
INSERT INTO sancol_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","kintu phalESu pakkESu zasyacchEdanakAlaM jnjAtvA sa tatkSaNaM zasyAni chinatti, anEna tulyamIzvararAjyaM| ");
INSERT INTO sancol_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","punaH sO'kathayad IzvararAjyaM kEna samaM? kEna vastunA saha vA tadupamAsyAmi? ");
INSERT INTO sancol_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","tat sarSapaikEna tulyaM yatO mRdi vapanakAlE sarSapabIjaM sarvvapRthivIsthabIjAt kSudraM ");
INSERT INTO sancol_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","kintu vapanAt param agkurayitvA sarvvazAkAd bRhad bhavati, tasya bRhatyaH zAkhAzca jAyantE tatastacchAyAM pakSiNa AzrayantE| ");
INSERT INTO sancol_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","itthaM tESAM bOdhAnurUpaM sO'nEkadRSTAntaistAnupadiSTavAn, ");
INSERT INTO sancol_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","dRSTAntaM vinA kAmapi kathAM tEbhyO na kathitavAn pazcAn nirjanE sa ziSyAn sarvvadRSTAntArthaM bOdhitavAn| ");
INSERT INTO sancol_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","taddinasya sandhyAyAM sa tEbhyO'kathayad Agacchata vayaM pAraM yAma| ");
INSERT INTO sancol_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","tadA tE lOkAn visRjya tamavilambaM gRhItvA naukayA pratasthirE; aparA api nAvastayA saha sthitAH| ");
INSERT INTO sancol_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","tataH paraM mahAjhanjbhzagamAt nau rdOlAyamAnA taraggENa jalaiH pUrNAbhavacca| ");
INSERT INTO sancol_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","tadA sa naukAcazcAdbhAgE upadhAnE zirO nidhAya nidrita AsIt tatastE taM jAgarayitvA jagaduH, hE prabhO, asmAkaM prANA yAnti kimatra bhavatazcintA nAsti? ");
INSERT INTO sancol_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","tadA sa utthAya vAyuM tarjitavAn samudranjcOktavAn zAntaH susthirazca bhava; tatO vAyau nivRttE'bdhirnistaraggObhUt| ");
INSERT INTO sancol_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","tadA sa tAnuvAca yUyaM kuta EtAdRkzagkAkulA bhavata? kiM vO vizvAsO nAsti? ");
INSERT INTO sancol_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","tasmAttE'tIvabhItAH parasparaM vaktumArEbhirE, ahO vAyuH sindhuzcAsya nidEzagrAhiNau kIdRgayaM manujaH| ");
INSERT INTO sancol_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","atha tU sindhupAraM gatvA gidErIyapradEza upatasthuH| ");
INSERT INTO sancol_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","naukAtO nirgatamAtrAd apavitrabhUtagrasta EkaH zmazAnAdEtya taM sAkSAc cakAra| ");
INSERT INTO sancol_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","sa zmazAnE'vAtsIt kOpi taM zRgkhalEna badvvA sthApayituM nAzaknOt| ");
INSERT INTO sancol_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","janairvAraM nigaPaiH zRgkhalaizca sa baddhOpi zRgkhalAnyAkRSya mOcitavAn nigaPAni ca bhaMktvA khaNPaM khaNPaM kRtavAn kOpi taM vazIkarttuM na zazaka| ");
INSERT INTO sancol_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","divAnizaM sadA parvvataM zmazAnanjca bhramitvA cItzabdaM kRtavAn grAvabhizca svayaM svaM kRtavAn| ");
INSERT INTO sancol_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","sa yIzuM dUrAt pazyannEva dhAvan taM praNanAma ucairuvaMzcOvAca, ");
INSERT INTO sancol_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","hE sarvvOparisthEzvaraputra yIzO bhavatA saha mE kaH sambandhaH? ahaM tvAmIzvarENa zApayE mAM mA yAtaya| ");
INSERT INTO sancol_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","yatO yIzustaM kathitavAn rE apavitrabhUta, asmAnnarAd bahirnirgaccha| ");
INSERT INTO sancol_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","atha sa taM pRSTavAn kintE nAma? tEna pratyuktaM vayamanEkE 'smastatO'smannAma bAhinI| ");
INSERT INTO sancol_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","tatOsmAn dEzAnna prESayEti tE taM prArthayanta| ");
INSERT INTO sancol_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","tadAnIM parvvataM nikaSA bRhan varAhavrajazcarannAsIt| ");
INSERT INTO sancol_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","tasmAd bhUtA vinayEna jagaduH, amuM varAhavrajam Azrayitum asmAn prahiNu| ");
INSERT INTO sancol_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","yIzunAnujnjAtAstE'pavitrabhUtA bahirniryAya varAhavrajaM prAvizan tataH sarvvE varAhA vastutastu prAyOdvisahasrasaMgkhyakAH kaTakEna mahAjavAd dhAvantaH sindhau prANAn jahuH| ");
INSERT INTO sancol_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","tasmAd varAhapAlakAH palAyamAnAH purE grAmE ca tadvArttaM kathayAnjcakruH| tadA lOkA ghaTitaM tatkAryyaM draSTuM bahirjagmuH ");
INSERT INTO sancol_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","yIzOH sannidhiM gatvA taM bhUtagrastam arthAd bAhinIbhUtagrastaM naraM savastraM sacEtanaM samupaviSTanjca dRृSTvA bibhyuH| ");
INSERT INTO sancol_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","tatO dRSTatatkAryyalOkAstasya bhUtagrastanarasya varAhavrajasyApi tAM dhaTanAM varNayAmAsuH| ");
INSERT INTO sancol_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","tatastE svasImAtO bahirgantuM yIzuM vinEtumArEbhirE| ");
INSERT INTO sancol_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","atha tasya naukArOhaNakAlE sa bhUtamuktO nA yIzunA saha sthAtuM prArthayatE; ");
INSERT INTO sancol_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","kintu sa tamananumatya kathitavAn tvaM nijAtmIyAnAM samIpaM gRhanjca gaccha prabhustvayi kRpAM kRtvA yAni karmmANi kRtavAn tAni tAn jnjApaya| ");
INSERT INTO sancol_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ataH sa prasthAya yIzunA kRtaM tatsarvvAzcaryyaM karmma dikApalidEzE pracArayituM prArabdhavAn tataH sarvvE lOkA AzcaryyaM mEnirE| ");
INSERT INTO sancol_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","anantaraM yIzau nAvA punaranyapAra uttIrNE sindhutaTE ca tiSThati sati tatsamIpE bahulOkAnAM samAgamO'bhUt| ");
INSERT INTO sancol_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","aparaM yAyIr nAmnA kazcid bhajanagRhasyAdhipa Agatya taM dRSTvaiva caraNayOH patitvA bahu nivEdya kathitavAn; ");
INSERT INTO sancol_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","mama kanyA mRtaprAyAbhUd atO bhavAnEtya tadArOgyAya tasyA gAtrE hastam arpayatu tEnaiva sA jIviSyati| ");
INSERT INTO sancol_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","tadA yIzustEna saha calitaH kintu tatpazcAd bahulOkAzcalitvA tAdgAtrE patitAH| ");
INSERT INTO sancol_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","atha dvAdazavarSANi pradararOgENa ");
INSERT INTO sancol_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","zIrNA cikitsakAnAM nAnAcikitsAbhizca duHkhaM bhuktavatI ca sarvvasvaM vyayitvApi nArOgyaM prAptA ca punarapi pIPitAsIcca ");
INSERT INTO sancol_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","yA strI sA yIzO rvArttAM prApya manasAkathayat yadyahaM tasya vastramAtra spraSTuM labhEyaM tadA rOgahInA bhaviSyAmi| ");
INSERT INTO sancol_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","atOhEtOH sA lOkAraNyamadhyE tatpazcAdAgatya tasya vastraM pasparza| ");
INSERT INTO sancol_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","tEnaiva tatkSaNaM tasyA raktasrOtaH zuSkaM svayaM tasmAd rOgAnmuktA ityapi dEhE'nubhUtA| ");
INSERT INTO sancol_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","atha svasmAt zakti rnirgatA yIzurEtanmanasA jnjAtvA lOkanivahaM prati mukhaM vyAvRtya pRSTavAn kEna madvastraM spRSTaM? ");
INSERT INTO sancol_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","tatastasya ziSyA UcuH bhavatO vapuSi lOkAH saMgharSanti tad dRSTvA kEna madvastraM spRSTamiti kutaH kathayati? ");
INSERT INTO sancol_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","kintu kEna tat karmma kRtaM tad draSTuM yIzuzcaturdizO dRSTavAn| ");
INSERT INTO sancol_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","tataH sA strI bhItA kampitA ca satI svasyA rukpratikriyA jAtEti jnjAtvAgatya tatsammukhE patitvA sarvvavRttAntaM satyaM tasmai kathayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","tadAnIM yIzustAM gaditavAn, hE kanyE tava pratItistvAm arOgAmakarOt tvaM kSEmENa vraja svarOgAnmuktA ca tiSTha| ");
INSERT INTO sancol_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","itivAkyavadanakAlE bhajanagRhAdhipasya nivEzanAl lOkA EtyAdhipaM babhASirE tava kanyA mRtA tasmAd guruM punaH kutaH kliznAsi? ");
INSERT INTO sancol_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","kintu yIzustad vAkyaM zrutvaiva bhajanagRhAdhipaM gaditavAn mA bhaiSIH kEvalaM vizvAsihi| ");
INSERT INTO sancol_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","atha pitarO yAkUb tadbhrAtA yOhan ca EtAn vinA kamapi svapazcAd yAtuM nAnvamanyata| ");
INSERT INTO sancol_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","tasya bhajanagRhAdhipasya nivEzanasamIpam Agatya kalahaM bahurOdanaM vilApanjca kurvvatO lOkAn dadarza| ");
INSERT INTO sancol_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","tasmAn nivEzanaM pravizya prOktavAn yUyaM kuta itthaM kalahaM rOdananjca kurutha? kanyA na mRtA nidrAti| ");
INSERT INTO sancol_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","tasmAttE tamupajahasuH kintu yIzuH sarvvAna bahiSkRtya kanyAyAH pitarau svasagginazca gRhItvA yatra kanyAsIt tat sthAnaM praviSTavAn| ");
INSERT INTO sancol_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","atha sa tasyAH kanyAyA hastau dhRtvA tAM babhASE TAlIthA kUmI, arthatO hE kanyE tvamuttiSTha ityAjnjApayAmi| ");
INSERT INTO sancol_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","tunaiva tatkSaNaM sA dvAdazavarSavayaskA kanyA pOtthAya calitumArEbhE, itaH sarvvE mahAvismayaM gatAH| ");
INSERT INTO sancol_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","tata Etasyai kinjcit khAdyaM dattEti kathayitvA Etatkarmma kamapi na jnjApayatEti dRPhamAdiSTavAn| ");
INSERT INTO sancol_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","anantaraM sa tatsthAnAt prasthAya svapradEzamAgataH ziSyAzca tatpazcAd gatAH| ");
INSERT INTO sancol_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","atha vizrAmavArE sati sa bhajanagRhE upadESTumArabdhavAn tatO'nEkE lOkAstatkathAM zrutvA vismitya jagaduH, asya manujasya IdRzI AzcaryyakriyA kasmAj jAtA? tathA svakarAbhyAm itthamadbhutaM karmma karttAुm Etasmai kathaM jnjAnaM dattam? ");
INSERT INTO sancol_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","kimayaM mariyamaH putrastajnjA nO? kimayaM yAkUb-yOsi-yihudA-zimOnAM bhrAtA nO? asya bhaginyaH kimihAsmAbhiH saha nO? itthaM tE tadarthE pratyUhaM gatAH| ");
INSERT INTO sancol_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","tadA yIzustEbhyO'kathayat svadEzaM svakuTumbAn svaparijanAMzca vinA kutrApi bhaviSyadvAdI asatkRtO na bhavati| ");
INSERT INTO sancol_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","aparanjca tESAmapratyayAt sa vismitaH kiyatAM rOgiNAM vapuHSu hastam arpayitvA kEvalaM tESAmArOgyakaraNAd anyat kimapi citrakAryyaM karttAM na zaktaH| ");
INSERT INTO sancol_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","atha sa caturdikstha grAmAn bhramitvA upadiSTavAn ");
INSERT INTO sancol_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","dvAdazaziSyAn AhUya amEdhyabhUtAn vazIkarttAM zaktiM dattvA tESAM dvau dvau janO prESitavAn| ");
INSERT INTO sancol_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","punarityAdizad yUyam EkaikAM yaSTiM vinA vastrasaMpuTaH pUpaH kaTibandhE tAmrakhaNPanjca ESAM kimapi mA grahlIta, ");
INSERT INTO sancol_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","mArgayAtrAyai pAdESUpAnahau dattvA dvE uttarIyE mA paridhadvvaM| ");
INSERT INTO sancol_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","aparamapyuktaM tEna yUyaM yasyAM puryyAM yasya nivEzanaM pravEkSyatha tAM purIM yAvanna tyakSyatha tAvat tannivEzanE sthAsyatha| ");
INSERT INTO sancol_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","tatra yadi kEpi yuSmAkamAtithyaM na vidadhati yuSmAkaM kathAzca na zRNvanti tarhi tatsthAnAt prasthAnasamayE tESAM viruddhaM sAkSyaM dAtuM svapAdAnAsphAlya rajaH sampAtayata; ahaM yuSmAn yathArthaM vacmi vicAradinE tannagarasyAvasthAtaH sidOmAmOrayO rnagarayOravasthA sahyatarA bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","atha tE gatvA lOkAnAM manaHparAvarttanIH kathA pracAritavantaH| ");
INSERT INTO sancol_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","EvamanEkAn bhUtAMzca tyAjitavantastathA tailEna marddayitvA bahUn janAnarOgAnakArSuH| ");
INSERT INTO sancol_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","itthaM tasya sukhyAtizcaturdizO vyAptA tadA hErOd rAjA tannizamya kathitavAn, yOhan majjakaH zmazAnAd utthita atOhEtOstEna sarvvA EtA adbhutakriyAH prakAzantE| ");
INSERT INTO sancol_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","anyE'kathayan ayam EliyaH, kEpi kathitavanta ESa bhaviSyadvAdI yadvA bhaviSyadvAdinAM sadRza EkOyam| ");
INSERT INTO sancol_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","kintu hErOd ityAkarNya bhASitavAn yasyAhaM zirazchinnavAn sa Eva yOhanayaM sa zmazAnAdudatiSThat| ");
INSERT INTO sancol_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","pUrvvaM svabhrAtuH philipasya patnyA udvAhaM kRtavantaM hErOdaM yOhanavAdIt svabhAtRvadhU rna vivAhyA| ");
INSERT INTO sancol_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ataH kAraNAt hErOd lOkaM prahitya yOhanaM dhRtvA bandhanAlayE baddhavAn| ");
INSERT INTO sancol_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","hErOdiyA tasmai yOhanE prakupya taM hantum aicchat kintu na zaktA, ");
INSERT INTO sancol_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","yasmAd hErOd taM dhArmmikaM satpuruSanjca jnjAtvA sammanya rakSitavAn; tatkathAM zrutvA tadanusArENa bahUni karmmANi kRtavAn hRSTamanAstadupadEzaM zrutavAMzca| ");
INSERT INTO sancol_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","kintu hErOd yadA svajanmadinE pradhAnalOkEbhyaH sEnAnIbhyazca gAlIlpradEzIyazrESThalOkEbhyazca rAtrau bhOjyamEkaM kRtavAn ");
INSERT INTO sancol_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","tasmin zubhadinE hErOdiyAyAH kanyA samEtya tESAM samakSaM saMnRtya hErOdastEna sahOpaviSTAnAnjca tOSamajIjanat tatA nRpaH kanyAmAha sma mattO yad yAcasE tadEva tubhyaM dAsyE| ");
INSERT INTO sancol_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","zapathaM kRtvAkathayat cEd rAjyArddhamapi yAcasE tadapi tubhyaM dAsyE| ");
INSERT INTO sancol_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","tataH sA bahi rgatvA svamAtaraM papraccha kimahaM yAciSyE? tadA sAkathayat yOhanO majjakasya ziraH| ");
INSERT INTO sancol_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","atha tUrNaM bhUpasamIpam Etya yAcamAnAvadat kSaNEsmin yOhanO majjakasya ziraH pAtrE nidhAya dEhi, Etad yAcE'haM| ");
INSERT INTO sancol_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","tasmAt bhUpO'tiduHkhitaH, tathApi svazapathasya sahabhOjinAnjcAnurOdhAt tadanaggIkarttuM na zaktaH| ");
INSERT INTO sancol_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","tatkSaNaM rAjA ghAtakaM prESya tasya zira AnEtumAdiSTavAn| ");
INSERT INTO sancol_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","tataH sa kArAgAraM gatvA tacchirazchitvA pAtrE nidhAyAnIya tasyai kanyAyai dattavAn kanyA ca svamAtrE dadau| ");
INSERT INTO sancol_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ananataraM yOhanaH ziSyAstadvArttAM prApyAgatya tasya kuNapaM zmazAnE'sthApayan| ");
INSERT INTO sancol_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","atha prESitA yIzOH sannidhau militA yad yac cakruH zikSayAmAsuzca tatsarvvavArttAstasmai kathitavantaH| ");
INSERT INTO sancol_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","sa tAnuvAca yUyaM vijanasthAnaM gatvA vizrAmyata yatastatsannidhau bahulOkAnAM samAgamAt tE bhOktuM nAvakAzaM prAptAH| ");
INSERT INTO sancol_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","tatastE nAvA vijanasthAnaM guptaM gagmuH| ");
INSERT INTO sancol_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","tatO lOkanivahastESAM sthAnAntarayAnaM dadarza, anEkE taM paricitya nAnApurEbhyaH padairvrajitvA javEna taiSAmagrE yIzOH samIpa upatasthuH| ");
INSERT INTO sancol_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","tadA yIzu rnAvO bahirgatya lOkAraNyAnIM dRSTvA tESu karuNAM kRtavAn yatastE'rakSakamESA ivAsan tadA sa tAna nAnAprasaggAn upadiSTavAn| ");
INSERT INTO sancol_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","atha divAntE sati ziSyA Etya yIzumUcirE, idaM vijanasthAnaM dinanjcAvasannaM| ");
INSERT INTO sancol_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","lOkAnAM kimapi khAdyaM nAsti, atazcaturdikSu grAmAn gantuM bhOjyadravyANi krEtunjca bhavAn tAn visRjatu| ");
INSERT INTO sancol_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","tadA sa tAnuvAca yUyamEva tAn bhOjayata; tatastE jagadu rvayaM gatvA dvizatasaMkhyakai rmudrApAdaiH pUpAn krItvA kiM tAn bhOjayiSyAmaH? ");
INSERT INTO sancol_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","tadA sa tAn pRSThavAn yuSmAkaM sannidhau kati pUpA AsatE? gatvA pazyata; tatastE dRSTvA tamavadan panjca pUpA dvau matsyau ca santi| ");
INSERT INTO sancol_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","tadA sa lOkAn zaspOpari paMktibhirupavEzayitum AdiSTavAn, ");
INSERT INTO sancol_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","tatastE zataM zataM janAH panjcAzat panjcAzajjanAzca paMktibhi rbhuvi samupavivizuH| ");
INSERT INTO sancol_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","atha sa tAn panjcapUpAn matsyadvayanjca dhRtvA svargaM pazyan IzvaraguNAn anvakIrttayat tAn pUpAn bhaMktvA lOkEbhyaH parivESayituM ziSyEbhyO dattavAn dvA matsyau ca vibhajya sarvvEbhyO dattavAn| ");
INSERT INTO sancol_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","tataH sarvvE bhuktvAtRpyan| ");
INSERT INTO sancol_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","anantaraM ziSyA avaziSTaiH pUpai rmatsyaizca pUrNAn dvadaza PallakAn jagRhuH| ");
INSERT INTO sancol_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","tE bhOktAraH prAyaH panjca sahasrANi puruSA Asan| ");
INSERT INTO sancol_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","atha sa lOkAn visRjannEva nAvamArOPhuM svasmAdagrE pArE baitsaidApuraM yAtunjca zSyiाn vAPhamAdiSTavAn| ");
INSERT INTO sancol_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","tadA sa sarvvAn visRjya prArthayituM parvvataM gataH| ");
INSERT INTO sancol_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","tataH sandhyAyAM satyAM nauH sindhumadhya upasthitA kintu sa EkAkI sthalE sthitaH| ");
INSERT INTO sancol_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","atha sammukhavAtavahanAt ziSyA nAvaM vAhayitvA parizrAntA iti jnjAtvA sa nizAcaturthayAmE sindhUpari padbhyAM vrajan tESAM samIpamEtya tESAmagrE yAtum udyataH| ");
INSERT INTO sancol_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","kintu ziSyAH sindhUpari taM vrajantaM dRSTvA bhUtamanumAya ruruvuH, ");
INSERT INTO sancol_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","yataH sarvvE taM dRSTvA vyAkulitAH| ataEva yIzustatkSaNaM taiH sahAlapya kathitavAn, susthirA bhUta, ayamahaM mA bhaiSTa| ");
INSERT INTO sancol_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","atha naukAmAruhya tasmin tESAM sannidhiM gatE vAtO nivRttaH; tasmAttE manaHsu vismitA AzcaryyaM mEnirE| ");
INSERT INTO sancol_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","yatastE manasAM kAThinyAt tat pUpIyam AzcaryyaM karmma na viviktavantaH| ");
INSERT INTO sancol_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","atha tE pAraM gatvA ginESaratpradEzamEtya taTa upasthitAH| ");
INSERT INTO sancol_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","tESu naukAtO bahirgatESu tatpradEzIyA lOkAstaM paricitya ");
INSERT INTO sancol_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","caturdikSu dhAvantO yatra yatra rOgiNO narA Asan tAn sarvvAna khaTvOpari nidhAya yatra kutracit tadvArttAM prApuH tat sthAnam AnEtum ArEbhirE| ");
INSERT INTO sancol_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","tathA yatra yatra grAmE yatra yatra purE yatra yatra pallyAnjca tEna pravEzaH kRtastadvartmamadhyE lOkAH pIPitAn sthApayitvA tasya cElagranthimAtraM spraSTum tESAmarthE tadanujnjAM prArthayantaH yAvantO lOkAH paspRzustAvanta Eva gadAnmuktAH| ");
INSERT INTO sancol_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","anantaraM yirUzAlama AgatAH phirUzinO'dhyApakAzca yIzOH samIpam AgatAH| ");
INSERT INTO sancol_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","tE tasya kiyataH ziSyAn azucikarairarthAda aprakSAlitahastai rbhunjjatO dRSTvA tAnadUSayan| ");
INSERT INTO sancol_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","yataH phirUzinaH sarvvayihUdIyAzca prAcAM paramparAgatavAkyaM sammanya pratalEna hastAn aprakSAlya na bhunjjatE| ");
INSERT INTO sancol_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ApanAdAgatya majjanaM vinA na khAdanti; tathA pAnapAtrANAM jalapAtrANAM pittalapAtrANAm AsanAnAnjca jalE majjanam ityAdayOnyEpi bahavastESAmAcArAH santi| ");
INSERT INTO sancol_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","tE phirUzinO'dhyApakAzca yIzuM papracchuH, tava ziSyAH prAcAM paramparAgatavAkyAnusArENa nAcarantO'prakSAlitakaraiH kutO bhujaMtE? ");
INSERT INTO sancol_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","tataH sa pratyuvAca kapaTinO yuSmAn uddizya yizayiyabhaviSyadvAdI yuktamavAdIt| yathA svakIyairadharairEtE sammanyanatE sadaiva mAM| kintu mattO viprakarSE santi tESAM manAMsi ca| ");
INSERT INTO sancol_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","zikSayantO bidhIn nnAjnjA bhajantE mAM mudhaiva tE| ");
INSERT INTO sancol_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","yUyaM jalapAtrapAnapAtrAdIni majjayantO manujaparamparAgatavAkyaM rakSatha kintu IzvarAjnjAM laMghadhvE; aparA IdRzyOnEkAH kriyA api kurudhvE| ");
INSERT INTO sancol_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","anyanjcAkathayat yUyaM svaparamparAgatavAkyasya rakSArthaM spaSTarUpENa IzvarAjnjAM lOpayatha| ");
INSERT INTO sancol_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","yatO mUsAdvArA prOktamasti svapitarau sammanyadhvaM yastu mAtaraM pitaraM vA durvvAkyaM vakti sa nitAntaM hanyatAM| ");
INSERT INTO sancol_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","kintu madIyEna yEna dravyENa tavOpakArObhavat tat karbbANamarthAd IzvarAya nivEditam idaM vAkyaM yadi kOpi pitaraM mAtaraM vA vakti ");
INSERT INTO sancol_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","tarhi yUyaM mAtuH pitu rvOpakAraM karttAM taM vArayatha| ");
INSERT INTO sancol_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","itthaM svapracAritaparamparAgatavAkyEna yUyam IzvarAjnjAM mudhA vidhadvvE, IdRzAnyanyAnyanEkAni karmmANi kurudhvE| ");
INSERT INTO sancol_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","atha sa lOkAnAhUya babhASE yUyaM sarvvE madvAkyaM zRNuta budhyadhvanjca| ");
INSERT INTO sancol_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","bAhyAdantaraM pravizya naramamEdhyaM karttAM zaknOti IdRzaM kimapi vastu nAsti, varam antarAd bahirgataM yadvastu tanmanujam amEdhyaM karOti| ");
INSERT INTO sancol_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","yasya zrOtuM zrOtrE staH sa zRNOtu| ");
INSERT INTO sancol_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","tataH sa lOkAn hitvA gRhamadhyaM praviSTastadA ziSyAstadRSTAntavAkyArthaM papracchuH| ");
INSERT INTO sancol_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","tasmAt sa tAn jagAda yUyamapi kimEtAdRgabOdhAH? kimapi dravyaM bAhyAdantaraM pravizya naramamEdhyaM karttAM na zaknOti kathAmimAM kiM na budhyadhvE? ");
INSERT INTO sancol_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","tat tadantarna pravizati kintu kukSimadhyaM pravizati zESE sarvvabhuktavastugrAhiNi bahirdEzE niryAti| ");
INSERT INTO sancol_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","aparamapyavAdId yannarAnnirEti tadEva naramamEdhyaM karOti| ");
INSERT INTO sancol_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","yatO'ntarAd arthAn mAnavAnAM manObhyaH kucintA parastrIvEzyAgamanaM ");
INSERT INTO sancol_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","naravadhazcauryyaM lObhO duSTatA pravanjcanA kAmukatA kudRSTirIzvaranindA garvvastama ityAdIni nirgacchanti| ");
INSERT INTO sancol_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","EtAni sarvvANi duritAnyantarAdEtya naramamEdhyaM kurvvanti| ");
INSERT INTO sancol_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","atha sa utthAya tatsthAnAt sOrasIdOnpurapradEzaM jagAma tatra kimapi nivEzanaM pravizya sarvvairajnjAtaH sthAtuM matinjcakrE kintu guptaH sthAtuM na zazAka| ");
INSERT INTO sancol_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","yataH suraphainikIdEzIyayUnAnIvaMzOdbhavastriyAH kanyA bhUtagrastAsIt| sA strI tadvArttAM prApya tatsamIpamAgatya taccaraNayOH patitvA ");
INSERT INTO sancol_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","svakanyAtO bhUtaM nirAkarttAM tasmin vinayaM kRtavatI| ");
INSERT INTO sancol_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","kintu yIzustAmavadat prathamaM bAlakAstRpyantu yatO bAlakAnAM khAdyaM gRhItvA kukkurEbhyO nikSEpO'nucitaH| ");
INSERT INTO sancol_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","tadA sA strI tamavAdIt bhOH prabhO tat satyaM tathApi manjcAdhaHsthAH kukkurA bAlAnAM karapatitAni khAdyakhaNPAni khAdanti| ");
INSERT INTO sancol_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","tataH sO'kathayad EtatkathAhEtOH sakuzalA yAhi tava kanyAM tyaktvA bhUtO gataH| ");
INSERT INTO sancol_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","atha sA strI gRhaM gatvA kanyAM bhUtatyaktAM zayyAsthitAM dadarza| ");
INSERT INTO sancol_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","punazca sa sOrasIdOnpurapradEzAt prasthAya dikApalidEzasya prAntarabhAgEna gAlIljaladhEH samIpaM gatavAn| ");
INSERT INTO sancol_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","tadA lOkairEkaM badhiraM kadvadanjca naraM tannikaTamAnIya tasya gAtrE hastamarpayituM vinayaH kRtaH| ");
INSERT INTO sancol_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","tatO yIzu rlOkAraNyAt taM nirjanamAnIya tasya karNayOggulI rdadau niSThIvaM dattvA ca tajjihvAM pasparza| ");
INSERT INTO sancol_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","anantaraM svargaM nirIkSya dIrghaM nizvasya tamavadat itaphataH arthAn muktO bhUyAt| ");
INSERT INTO sancol_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","tatastatkSaNaM tasya karNau muktau jihvAyAzca jAPyApagamAt sa suspaSTavAkyamakathayat| ");
INSERT INTO sancol_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","atha sa tAn vAPhamityAdidEza yUyamimAM kathAM kasmaicidapi mA kathayata, kintu sa yati nyaSEdhat tE tati bAhulyEna prAcArayan; ");
INSERT INTO sancol_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","tE'ticamatkRtya parasparaM kathayAmAsuH sa badhirAya zravaNazaktiM mUkAya ca kathanazaktiM dattvA sarvvaM karmmOttamarUpENa cakAra| ");
INSERT INTO sancol_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","tadA tatsamIpaM bahavO lOkA AyAtA atastESAM bhOjyadravyAbhAvAd yIzuH ziSyAnAhUya jagAda,| ");
INSERT INTO sancol_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","lOkanivahE mama kRpA jAyatE tE dinatrayaM mayA sArddhaM santi tESAM bhOjyaM kimapi nAsti| ");
INSERT INTO sancol_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","tESAM madhyE'nEkE dUrAd AgatAH, abhuktESu tESu mayA svagRhamabhiprahitESu tE pathi klamiSyanti| ");
INSERT INTO sancol_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ziSyA avAdiSuH, EtAvatO lOkAn tarpayitum atra prantarE pUpAn prAptuM kEna zakyatE? ");
INSERT INTO sancol_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","tataH sa tAn papraccha yuSmAkaM kati pUpAH santi? tE'kathayan sapta| ");
INSERT INTO sancol_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","tataH sa tAllOkAn bhuvi samupavESTum Adizya tAn sapta pUpAn dhRtvA IzvaraguNAn anukIrttayAmAsa, bhaMktvA parivESayituM ziSyAn prati dadau, tatastE lOkEbhyaH parivESayAmAsuH| ");
INSERT INTO sancol_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","tathA tESAM samIpE yE kSudramatsyA Asan tAnapyAdAya IzvaraguNAn saMkIrtya parivESayitum AdiSTavAn| ");
INSERT INTO sancol_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","tatO lOkA bhuktvA tRptiM gatA avaziSTakhAdyaiH pUrNAH saptaPallakA gRhItAzca| ");
INSERT INTO sancol_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","EtE bhOktAraH prAyazcatuH sahasrapuruSA Asan tataH sa tAn visasarja| ");
INSERT INTO sancol_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","atha sa ziSyaH saha nAvamAruhya dalmAnUthAsImAmAgataH| ");
INSERT INTO sancol_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","tataH paraM phirUzina Agatya tEna saha vivadamAnAstasya parIkSArtham AkAzIyacihnaM draSTuM yAcitavantaH| ");
INSERT INTO sancol_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","tadA sO'ntardIrghaM nizvasyAkathayat, EtE vidyamAnanarAH kutazcinhaM mRgayantE? yuSmAnahaM yathArthaM bravImi lOkAnEtAn kimapi cihnaM na darzayiSyatE| ");
INSERT INTO sancol_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","atha tAn hitvA puna rnAvam Aruhya pAramagAt| ");
INSERT INTO sancol_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Etarhi ziSyaiH pUpESu vismRtESu nAvi tESAM sannidhau pUpa EkaEva sthitaH| ");
INSERT INTO sancol_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","tadAnIM yIzustAn AdiSTavAn phirUzinAM hErOdazca kiNvaM prati satarkAH sAvadhAnAzca bhavata| ");
INSERT INTO sancol_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","tatastE'nyOnyaM vivEcanaM kartum ArEbhirE, asmAkaM sannidhau pUpO nAstIti hEtOridaM kathayati| ");
INSERT INTO sancol_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","tad budvvA yIzustEbhyO'kathayat yuSmAkaM sthAnE pUpAbhAvAt kuta itthaM vitarkayatha? yUyaM kimadyApi kimapi na jAnItha? bOddhunjca na zaknutha? yAvadadya kiM yuSmAkaM manAMsi kaThinAni santi? ");
INSERT INTO sancol_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","satsu nEtrESu kiM na pazyatha? satsu karNESu kiM na zRNutha? na smaratha ca? ");
INSERT INTO sancol_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","yadAhaM panjcapUpAn panjcasahasrANAM puruSANAM madhyE bhaMktvA dattavAn tadAnIM yUyam avaziSTapUpaiH pUrNAn kati PallakAn gRhItavantaH? tE'kathayan dvAdazaPallakAn| ");
INSERT INTO sancol_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","aparanjca yadA catuHsahasrANAM puruSANAM madhyE pUpAn bhaMktvAdadAM tadA yUyam atiriktapUpAnAM kati PallakAn gRhItavantaH? tE kathayAmAsuH saptaPallakAn| ");
INSERT INTO sancol_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","tadA sa kathitavAn tarhi yUyam adhunApi kutO bOdvvuM na zaknutha? ");
INSERT INTO sancol_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","anantaraM tasmin baitsaidAnagarE prAptE lOkA andhamEkaM naraM tatsamIpamAnIya taM spraSTuM taM prArthayAnjcakrirE| ");
INSERT INTO sancol_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","tadA tasyAndhasya karau gRhItvA nagarAd bahirdEzaM taM nItavAn; tannEtrE niSThIvaM dattvA tadgAtrE hastAvarpayitvA taM papraccha, kimapi pazyasi? ");
INSERT INTO sancol_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","sa nEtrE unmIlya jagAda, vRkSavat manujAn gacchatO nirIkSE| ");
INSERT INTO sancol_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","tatO yIzuH punastasya nayanayO rhastAvarpayitvA tasya nEtrE unmIlayAmAsa; tasmAt sa svasthO bhUtvA spaSTarUpaM sarvvalOkAn dadarza| ");
INSERT INTO sancol_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","tataH paraM tvaM grAmaM mA gaccha grAmasthaM kamapi ca kimapyanuktvA nijagRhaM yAhItyAdizya yIzustaM nijagRhaM prahitavAn| ");
INSERT INTO sancol_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","anantaraM ziSyaiH sahitO yIzuH kaisarIyAphilipipuraM jagAma, pathi gacchan tAnapRcchat kO'ham atra lOkAH kiM vadanti? ");
INSERT INTO sancol_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","tE pratyUcuH tvAM yOhanaM majjakaM vadanti kintu kEpi kEpi EliyaM vadanti; aparE kEpi kEpi bhaviSyadvAdinAm EkO jana iti vadanti| ");
INSERT INTO sancol_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","atha sa tAnapRcchat kintu kOham? ityatra yUyaM kiM vadatha? tadA pitaraH pratyavadat bhavAn abhiSiktastrAtA| ");
INSERT INTO sancol_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","tataH sa tAn gAPhamAdizad yUyaM mama kathA kasmaicidapi mA kathayata| ");
INSERT INTO sancol_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","manuSyaputrENAvazyaM bahavO yAtanA bhOktavyAH prAcInalOkaiH pradhAnayAjakairadhyApakaizca sa ninditaH san ghAtayiSyatE tRtIyadinE utthAsyati ca, yIzuH ziSyAnupadESTumArabhya kathAmimAM spaSTamAcaSTa| ");
INSERT INTO sancol_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","tasmAt pitarastasya hastau dhRtvA taM tarjjitavAn| ");
INSERT INTO sancol_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","kintu sa mukhaM parAvartya ziSyagaNaM nirIkSya pitaraM tarjayitvAvAdId dUrIbhava vighnakArin IzvarIyakAryyAdapi manuSyakAryyaM tubhyaM rOcatatarAM| ");
INSERT INTO sancol_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","atha sa lOkAn ziSyAMzcAhUya jagAda yaH kazcin mAmanugantum icchati sa AtmAnaM dAmyatu, svakruzaM gRhItvA matpazcAd AyAtu| ");
INSERT INTO sancol_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","yatO yaH kazcit svaprANaM rakSitumicchati sa taM hArayiSyati, kintu yaH kazcin madarthaM susaMvAdArthanjca prANaM hArayati sa taM rakSiSyati| ");
INSERT INTO sancol_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","aparanjca manujaH sarvvaM jagat prApya yadi svaprANaM hArayati tarhi tasya kO lAbhaH? ");
INSERT INTO sancol_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","naraH svaprANavinimayEna kiM dAtuM zaknOti? ");
INSERT INTO sancol_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","EtESAM vyabhicAriNAM pApinAnjca lOkAnAM sAkSAd yadi kOpi mAM matkathAnjca lajjAspadaM jAnAti tarhi manujaputrO yadA dharmmadUtaiH saha pituH prabhAvENAgamiSyati tadA sOpi taM lajjAspadaM jnjAsyati| ");
INSERT INTO sancol_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","atha sa tAnavAdIt yuSmabhyamahaM yathArthaM kathayAmi, IzvararAjyaM parAkramENOpasthitaM na dRSTvA mRtyuM nAsvAdiSyantE, atra daNPAyamAnAnAM madhyEpi tAdRzA lOkAH santi| ");
INSERT INTO sancol_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","atha SaPdinEbhyaH paraM yIzuH pitaraM yAkUbaM yOhananjca gRhItvA girEruccasya nirjanasthAnaM gatvA tESAM pratyakSE mUrtyantaraM dadhAra| ");
INSERT INTO sancol_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","tatastasya paridhEyam IdRzam ujjvalahimapANaParaM jAtaM yad jagati kOpi rajakO na tAdRk pANaParaM karttAM zaknOti| ");
INSERT INTO sancol_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","aparanjca EliyO mUsAzca tEbhyO darzanaM dattvA yIzunA saha kathanaM karttumArEbhAtE| ");
INSERT INTO sancol_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","tadA pitarO yIzumavAdIt hE gurO'smAkamatra sthitiruttamA, tataEva vayaM tvatkRtE EkAM mUsAkRtE EkAm EliyakRtE caikAM, EtAstisraH kuTI rnirmmAma| ");
INSERT INTO sancol_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","kintu sa yaduktavAn tat svayaM na bubudhE tataH sarvvE bibhayAnjcakruH| ");
INSERT INTO sancol_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Etarhi payOdastAn chAdayAmAsa, mamayAM priyaH putraH kathAsu tasya manAMsi nivEzayatEti nabhOvANI tanmEdyAnniryayau| ");
INSERT INTO sancol_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","atha haThAttE caturdizO dRSTvA yIzuM vinA svaiH sahitaM kamapi na dadRzuH| ");
INSERT INTO sancol_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","tataH paraM girEravarOhaNakAlE sa tAn gAPham dUtyAdidEza yAvannarasUnOH zmazAnAdutthAnaM na bhavati, tAvat darzanasyAsya vArttA yuSmAbhiH kasmaicidapi na vaktavyA| ");
INSERT INTO sancol_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","tadA zmazAnAdutthAnasya kObhiprAya iti vicAryya tE tadvAkyaM svESu gOpAyAnjcakrirE| ");
INSERT INTO sancol_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","atha tE yIzuM papracchuH prathamata EliyEnAgantavyam iti vAkyaM kuta upAdhyAyA AhuH? ");
INSERT INTO sancol_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","tadA sa pratyuvAca , EliyaH prathamamEtya sarvvakAryyANi sAdhayiSyati; naraputrE ca lipi ryathAstE tathaiva sOpi bahuduHkhaM prApyAvajnjAsyatE| ");
INSERT INTO sancol_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","kintvahaM yuSmAn vadAmi , EliyArthE lipi ryathAstE tathaiva sa Etya yayau, lOkA: svEcchAnurUpaM tamabhivyavaharanti sma| ");
INSERT INTO sancol_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","anantaraM sa ziSyasamIpamEtya tESAM catuHpArzvE taiH saha bahujanAn vivadamAnAn adhyApakAMzca dRSTavAn; ");
INSERT INTO sancol_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","kintu sarvvalOkAstaM dRSTvaiva camatkRtya tadAsannaM dhAvantastaM praNEmuH| ");
INSERT INTO sancol_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","tadA yIzuradhyApakAnaprAkSId EtaiH saha yUyaM kiM vivadadhvE? ");
INSERT INTO sancol_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","tatO lOkAnAM kazcidEkaH pratyavAdIt hE gurO mama sUnuM mUkaM bhUtadhRtanjca bhavadAsannam AnayaM| ");
INSERT INTO sancol_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","yadAsau bhUtastamAkramatE tadaiva pAtasati tathA sa phENAyatE, dantairdantAn gharSati kSINO bhavati ca; tatO hEtOstaM bhUtaM tyAjayituM bhavacchiSyAn nivEditavAn kintu tE na zEkuH| ");
INSERT INTO sancol_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","tadA sa tamavAdIt, rE avizvAsinaH santAnA yuSmAbhiH saha kati kAlAnahaM sthAsyAmi? aparAn kati kAlAn vA va AcArAn sahiSyE? taM madAsannamAnayata| ");
INSERT INTO sancol_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","tatastatsannidhiM sa AnIyata kintu taM dRSTvaiva bhUtO bAlakaM dhRtavAn; sa ca bhUmau patitvA phENAyamAnO lulOTha| ");
INSERT INTO sancol_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","tadA sa tatpitaraM papraccha, asyEdRzI dazA kati dinAni bhUtA? tataH sOvAdIt bAlyakAlAt| ");
INSERT INTO sancol_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","bhUtOyaM taM nAzayituM bahuvArAn vahnau jalE ca nyakSipat kintu yadi bhavAna kimapi karttAM zaknOti tarhi dayAM kRtvAsmAn upakarOtu| ");
INSERT INTO sancol_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","tadA yIzustamavadat yadi pratyEtuM zaknOSi tarhi pratyayinE janAya sarvvaM sAdhyam| ");
INSERT INTO sancol_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","tatastatkSaNaM tadbAlakasya pitA prOccai rUvan sAzrunEtraH prOvAca, prabhO pratyEmi mamApratyayaM pratikuru| ");
INSERT INTO sancol_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","atha yIzu rlOkasagghaM dhAvitvAyAntaM dRSTvA tamapUtabhUtaM tarjayitvA jagAda, rE badhira mUka bhUta tvamEtasmAd bahirbhava punaH kadApi mAzrayainaM tvAmaham ityAdizAmi| ");
INSERT INTO sancol_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","tadA sa bhUtazcItzabdaM kRtvA tamApIPya bahirjajAma, tatO bAlakO mRtakalpO babhUva tasmAdayaM mRta_ityanEkE kathayAmAsuH| ");
INSERT INTO sancol_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","kintu karaM dhRtvA yIzunOtthApitaH sa uttasthau| ");
INSERT INTO sancol_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","atha yIzau gRhaM praviSTE ziSyA guptaM taM papracchuH, vayamEnaM bhUtaM tyAjayituM kutO na zaktAH? ");
INSERT INTO sancol_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","sa uvAca, prArthanOpavAsau vinA kEnApyanyEna karmmaNA bhUtamIdRzaM tyAjayituM na zakyaM| ");
INSERT INTO sancol_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","anantaraM sa tatsthAnAditvA gAlIlmadhyEna yayau, kintu tat kOpi jAnIyAditi sa naicchat| ");
INSERT INTO sancol_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","aparanjca sa ziSyAnupadizan babhASE, naraputrO narahastESu samarpayiSyatE tE ca taM haniSyanti taistasmin hatE tRtIyadinE sa utthAsyatIti| ");
INSERT INTO sancol_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","kintu tatkathAM tE nAbudhyanta praSTunjca bibhyaH| ");
INSERT INTO sancol_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","atha yIzuH kapharnAhUmpuramAgatya madhyEgRhanjcEtya tAnapRcchad vartmamadhyE yUyamanyOnyaM kiM vivadadhvE sma? ");
INSERT INTO sancol_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","kintu tE niruttarAstasthu ryasmAttESAM kO mukhya iti vartmAni tE'nyOnyaM vyavadanta| ");
INSERT INTO sancol_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","tataH sa upavizya dvAdazaziSyAn AhUya babhASE yaH kazcit mukhyO bhavitumicchati sa sarvvEbhyO gauNaH sarvvESAM sEvakazca bhavatu| ");
INSERT INTO sancol_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","tadA sa bAlakamEkaM gRhItvA madhyE samupAvEzayat tatastaM krOPE kRtvA tAnavAdAt ");
INSERT INTO sancol_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","yaH kazcidIdRzasya kasyApi bAlasyAtithyaM karOti sa mamAtithyaM karOti; yaH kazcinmamAtithyaM karOti sa kEvalam mamAtithyaM karOti tanna matprErakasyApyAtithyaM karOti| ");
INSERT INTO sancol_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","atha yOhan tamabravIt hE gurO, asmAkamananugAminam EkaM tvAnnAmnA bhUtAn tyAjayantaM vayaM dRSTavantaH, asmAkamapazcAdgAmitvAcca taM nyaSEdhAma| ");
INSERT INTO sancol_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","kintu yIzuravadat taM mA niSEdhat, yatO yaH kazcin mannAmnA citraM karmma karOti sa sahasA mAM nindituM na zaknOti| ");
INSERT INTO sancol_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","tathA yaH kazcid yuSmAkaM vipakSatAM na karOti sa yuSmAkamEva sapakSaH| ");
INSERT INTO sancol_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","yaH kazcid yuSmAn khrISTaziSyAn jnjAtvA mannAmnA kaMsaikEna pAnIyaM pAtuM dadAti, yuSmAnahaM yathArthaM vacmi, sa phalEna vanjcitO na bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","kintu yadi kazcin mayi vizvAsinAmESAM kSudraprANinAm EkasyApi vighnaM janayati, tarhi tasyaitatkarmma karaNAt kaNThabaddhapESaNIkasya tasya sAgarAgAdhajala majjanaM bhadraM| ");
INSERT INTO sancol_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","ataH svakarO yadi tvAM bAdhatE tarhi taM chindhi; ");
INSERT INTO sancol_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","yasmAt yatra kITA na mriyantE vahnizca na nirvvAti, tasmin anirvvANAnalanarakE karadvayavastava gamanAt karahInasya svargapravEzastava kSEmaM| ");
INSERT INTO sancol_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","yadi tava pAdO vighnaM janayati tarhi taM chindhi, ");
INSERT INTO sancol_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","yatO yatra kITA na mriyantE vahnizca na nirvvAti, tasmin 'nirvvANavahnau narakE dvipAdavatastava nikSEpAt pAdahInasya svargapravEzastava kSEmaM| ");
INSERT INTO sancol_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","svanEtraM yadi tvAM bAdhatE tarhi tadapyutpATaya, yatO yatra kITA na mriyantE vahnizca na nirvvAti, ");
INSERT INTO sancol_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","tasmina 'nirvvANavahnau narakE dvinEtrasya tava nikSEpAd EkanEtravata IzvararAjyE pravEzastava kSEmaM| ");
INSERT INTO sancol_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","yathA sarvvO bali rlavaNAktaH kriyatE tathA sarvvO janO vahnirUpENa lavaNAktaH kAriSyatE| ");
INSERT INTO sancol_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","lavaNaM bhadraM kintu yadi lavaNE svAdutA na tiSThati, tarhi katham AsvAdyuktaM kariSyatha? yUyaM lavaNayuktA bhavata parasparaM prEma kuruta| ");
INSERT INTO sancol_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","anantaraM sa tatsthAnAt prasthAya yarddananadyAH pArE yihUdApradEza upasthitavAn, tatra tadantikE lOkAnAM samAgamE jAtE sa nijarItyanusArENa punastAn upadidEza| ");
INSERT INTO sancol_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","tadA phirUzinastatsamIpam Etya taM parIkSituM papracchaH svajAyA manujAnAM tyajyA na vEti? ");
INSERT INTO sancol_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","tataH sa pratyavAdIt, atra kAryyE mUsA yuSmAn prati kimAjnjApayat? ");
INSERT INTO sancol_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ta UcuH tyAgapatraM lEkhituM svapatnIM tyaktunjca mUsA'numanyatE| ");
INSERT INTO sancol_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","tadA yIzuH pratyuvAca, yuSmAkaM manasAM kAThinyAddhEtO rmUsA nidEzamimam alikhat| ");
INSERT INTO sancol_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","kintu sRSTErAdau IzvarO narAn puMrUpENa strIrUpENa ca sasarja| ");
INSERT INTO sancol_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","\"tataH kAraNAt pumAn pitaraM mAtaranjca tyaktvA svajAyAyAm AsaktO bhaviSyati, ");
INSERT INTO sancol_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","tau dvAv EkAggau bhaviSyataH|\" tasmAt tatkAlamArabhya tau na dvAv EkAggau| ");
INSERT INTO sancol_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ataH kAraNAd IzvarO yadayOjayat kOpi narastanna viyEjayEt| ");
INSERT INTO sancol_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","atha yIzu rgRhaM praviSTastadA ziSyAH punastatkathAM taM papracchuH| ");
INSERT INTO sancol_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","tataH sOvadat kazcid yadi svabhAryyAM tyaktavAnyAm udvahati tarhi sa svabhAryyAyAH prAtikUlyEna vyabhicArI bhavati| ");
INSERT INTO sancol_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","kAcinnArI yadi svapatiM hitvAnyapuMsA vivAhitA bhavati tarhi sApi vyabhicAriNI bhavati| ");
INSERT INTO sancol_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","atha sa yathA zizUn spRzEt, tadarthaM lOkaistadantikaM zizava AnIyanta, kintu ziSyAstAnAnItavatastarjayAmAsuH| ");
INSERT INTO sancol_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","yIzustad dRSTvA krudhyan jagAda, mannikaTam AgantuM zizUn mA vArayata, yata EtAdRzA IzvararAjyAdhikAriNaH| ");
INSERT INTO sancol_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","yuSmAnahaM yathArthaM vacmi, yaH kazcit zizuvad bhUtvA rAjyamIzvarasya na gRhlIyAt sa kadApi tadrAjyaM pravESTuM na zaknOti| ");
INSERT INTO sancol_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ananataraM sa zizUnagkE nidhAya tESAM gAtrESu hastau dattvAziSaM babhASE| ");
INSERT INTO sancol_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","atha sa vartmanA yAti, Etarhi jana EkO dhAvan Agatya tatsammukhE jAnunI pAtayitvA pRSTavAn, bhOH paramagurO, anantAyuH prAptayE mayA kiM karttavyaM? ");
INSERT INTO sancol_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","tadA yIzuruvAca, mAM paramaM kutO vadasi? vinEzvaraM kOpi paramO na bhavati| ");
INSERT INTO sancol_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","parastrIM nAbhigaccha; naraM mA ghAtaya; stEyaM mA kuru; mRSAsAkSyaM mA dEhi; hiMsAnjca mA kuru; pitarau sammanyasva; nidEzA EtE tvayA jnjAtAH| ");
INSERT INTO sancol_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","tatastana pratyuktaM, hE gurO bAlyakAlAdahaM sarvvAnEtAn AcarAmi| ");
INSERT INTO sancol_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","tadA yIzustaM vilOkya snEhEna babhASE, tavaikasyAbhAva AstE; tvaM gatvA sarvvasvaM vikrIya daridrEbhyO vizrANaya, tataH svargE dhanaM prApsyasi; tataH param Etya kruzaM vahan madanuvarttI bhava| ");
INSERT INTO sancol_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","kintu tasya bahusampadvidyamAnatvAt sa imAM kathAmAkarNya viSaNO duHkhitazca san jagAma| ");
INSERT INTO sancol_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","atha yIzuzcaturdizO nirIkSya ziSyAn avAdIt, dhanilOkAnAm IzvararAjyapravEzaH kIdRg duSkaraH| ");
INSERT INTO sancol_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","tasya kathAtaH ziSyAzcamaccakruH, kintu sa punaravadat, hE bAlakA yE dhanE vizvasanti tESAm IzvararAjyapravEzaH kIdRg duSkaraH| ");
INSERT INTO sancol_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","IzvararAjyE dhaninAM pravEzAt sUcirandhrENa mahAggasya gamanAgamanaM sukaraM| ");
INSERT INTO sancol_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","tadA ziSyA atIva vismitAH parasparaM prOcuH, tarhi kaH paritrANaM prAptuM zaknOti? ");
INSERT INTO sancol_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","tatO yIzustAn vilOkya babhASE, tan narasyAsAdhyaM kintu nEzvarasya, yatO hEtOrIzvarasya sarvvaM sAdhyam| ");
INSERT INTO sancol_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","tadA pitara uvAca, pazya vayaM sarvvaM parityajya bhavatOnugAminO jAtAH| ");
INSERT INTO sancol_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","tatO yIzuH pratyavadat, yuSmAnahaM yathArthaM vadAmi, madarthaM susaMvAdArthaM vA yO janaH sadanaM bhrAtaraM bhaginIM pitaraM mAtaraM jAyAM santAnAn bhUmi vA tyaktvA ");
INSERT INTO sancol_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","gRhabhrAtRbhaginIpitRmAtRpatnIsantAnabhUmInAmiha zataguNAn prEtyAnantAyuzca na prApnOti tAdRzaH kOpi nAsti| ");
INSERT INTO sancol_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","kintvagrIyA anEkE lOkAH zESAH, zESIyA anEkE lOkAzcAgrA bhaviSyanti| ");
INSERT INTO sancol_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","atha yirUzAlamyAnakAlE yIzustESAm agragAmI babhUva, tasmAttE citraM jnjAtvA pazcAdgAminO bhUtvA bibhyuH| tadA sa puna rdvAdazaziSyAn gRhItvA svIyaM yadyad ghaTiSyatE tattat tEbhyaH kathayituM prArEbhE; ");
INSERT INTO sancol_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","pazyata vayaM yirUzAlampuraM yAmaH, tatra manuSyaputraH pradhAnayAjakAnAm upAdhyAyAnAnjca karESu samarpayiSyatE; tE ca vadhadaNPAjnjAM dApayitvA paradEzIyAnAM karESu taM samarpayiSyanti| ");
INSERT INTO sancol_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","tE tamupahasya kazayA prahRtya tadvapuSi niSThIvaM nikSipya taM haniSyanti, tataH sa tRtIyadinE prOtthAsyati| ");
INSERT INTO sancol_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","tataH sivadEH putrau yAkUbyOhanau tadantikam Etya prOcatuH, hE gurO yad AvAbhyAM yAciSyatE tadasmadarthaM bhavAn karOtu nivEdanamidamAvayOH| ");
INSERT INTO sancol_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","tataH sa kathitavAn, yuvAM kimicchathaH? kiM mayA yuSmadarthaM karaNIyaM? ");
INSERT INTO sancol_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","tadA tau prOcatuH, AvayOrEkaM dakSiNapArzvE vAmapArzvE caikaM tavaizvaryyapadE samupavESTum AjnjApaya| ");
INSERT INTO sancol_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","kintu yIzuH pratyuvAca yuvAmajnjAtvEdaM prArthayEthE, yEna kaMsEnAhaM pAsyAmi tEna yuvAbhyAM kiM pAtuM zakSyatE? yasmin majjanEnAhaM majjiSyE tanmajjanE majjayituM kiM yuvAbhyAM zakSyatE? tau pratyUcatuH zakSyatE| ");
INSERT INTO sancol_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","tadA yIzuravadat yEna kaMsEnAhaM pAsyAmi tEnAvazyaM yuvAmapi pAsyathaH, yEna majjanEna cAhaM majjiyyE tatra yuvAmapi majjiSyEthE| ");
INSERT INTO sancol_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","kintu yESAmartham idaM nirUpitaM, tAn vihAyAnyaM kamapi mama dakSiNapArzvE vAmapArzvE vA samupavEzayituM mamAdhikArO nAsti| ");
INSERT INTO sancol_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","athAnyadazaziSyA imAM kathAM zrutvA yAkUbyOhanbhyAM cukupuH| ");
INSERT INTO sancol_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","kintu yIzustAn samAhUya babhASE, anyadEzIyAnAM rAjatvaM yE kurvvanti tE tESAmEva prabhutvaM kurvvanti, tathA yE mahAlOkAstE tESAm adhipatitvaM kurvvantIti yUyaM jAnItha| ");
INSERT INTO sancol_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","kintu yuSmAkaM madhyE na tathA bhaviSyati, yuSmAkaM madhyE yaH prAdhAnyaM vAnjchati sa yuSmAkaM sEvakO bhaviSyati, ");
INSERT INTO sancol_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","yuSmAkaM yO mahAn bhavitumicchati sa sarvvESAM kigkarO bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","yatO manuSyaputraH sEvyO bhavituM nAgataH sEvAM karttAM tathAnEkESAM paritrANasya mUlyarUpasvaprANaM dAtunjcAgataH| ");
INSERT INTO sancol_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","atha tE yirIhOnagaraM prAptAstasmAt ziSyai rlOkaizca saha yIzO rgamanakAlE TImayasya putrO barTImayanAmA andhastanmArgapArzvE bhikSArtham upaviSTaH| ");
INSERT INTO sancol_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","sa nAsaratIyasya yIzOrAgamanavArttAM prApya prOcai rvaktumArEbhE, hE yIzO dAyUdaH santAna mAM dayasva| ");
INSERT INTO sancol_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","tatOnEkE lOkA maunIbhavEti taM tarjayAmAsuH, kintu sa punaradhikamuccai rjagAda, hE yIzO dAyUdaH santAna mAM dayasva| ");
INSERT INTO sancol_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","tadA yIzuH sthitvA tamAhvAtuM samAdidEza, tatO lOkAstamandhamAhUya babhASirE, hE nara, sthirO bhava, uttiSTha, sa tvAmAhvayati| ");
INSERT INTO sancol_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","tadA sa uttarIyavastraM nikSipya prOtthAya yIzOH samIpaM gataH| ");
INSERT INTO sancol_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","tatO yIzustamavadat tvayA kiM prArthyatE? tubhyamahaM kiM kariSyAmI? tadA sOndhastamuvAca, hE gurO madIyA dRSTirbhavEt| ");
INSERT INTO sancol_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","tatO yIzustamuvAca yAhi tava vizvAsastvAM svasthamakArSIt, tasmAt tatkSaNaM sa dRSTiM prApya pathA yIzOH pazcAd yayau| ");
INSERT INTO sancol_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","anantaraM tESu yirUzAlamaH samIpasthayO rbaitphagIbaithanIyapurayOrantikasthaM jaitunanAmAdrimAgatESu yIzuH prESaNakAlE dvau ziSyAvidaM vAkyaM jagAda, ");
INSERT INTO sancol_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","yuvAmamuM sammukhasthaM grAmaM yAtaM, tatra pravizya yO naraM nAvahat taM garddabhazAvakaM drakSyathastaM mOcayitvAnayataM| ");
INSERT INTO sancol_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","kintu yuvAM karmmEdaM kutaH kuruthaH? kathAmimAM yadi kOpi pRcchati tarhi prabhOratra prayOjanamastIti kathitE sa zIghraM tamatra prESayiSyati| ");
INSERT INTO sancol_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","tatastau gatvA dvimArgamElanE kasyacid dvArasya pArzvE taM garddabhazAvakaM prApya mOcayataH, ");
INSERT INTO sancol_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Etarhi tatrOpasthitalOkAnAM kazcid apRcchat, garddabhazizuM kutO mOcayathaH? ");
INSERT INTO sancol_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","tadA yIzOrAjnjAnusArENa tEbhyaH pratyuditE tatkSaNaM tamAdAtuM tE'nujajnjuH| ");
INSERT INTO sancol_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","atha tau yIzOH sannidhiM garddabhazizum AnIya tadupari svavastrANi pAtayAmAsatuH; tataH sa tadupari samupaviSTaH| ");
INSERT INTO sancol_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","tadAnEkE pathi svavAsAMsi pAtayAmAsuH, paraizca taruzAkhAzchitavA mArgE vikIrNAH| ");
INSERT INTO sancol_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","aparanjca pazcAdgAminO'gragAminazca sarvvE janA ucaiHsvarENa vaktumArEbhirE, jaya jaya yaH paramEzvarasya nAmnAgacchati sa dhanya iti| ");
INSERT INTO sancol_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","tathAsmAkamaM pUrvvapuruSasya dAyUdO yadrAjyaM paramEzvaranAmnAyAti tadapi dhanyaM, sarvvasmAducchrAyE svargE Izvarasya jayO bhavEt| ");
INSERT INTO sancol_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","itthaM yIzu ryirUzAlami mandiraM pravizya caturdiksthAni sarvvANi vastUni dRSTavAn; atha sAyaMkAla upasthitE dvAdazaziSyasahitO baithaniyaM jagAma| ");
INSERT INTO sancol_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","aparEhani baithaniyAd AgamanasamayE kSudhArttO babhUva| ");
INSERT INTO sancol_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","tatO dUrE sapatramuPumbarapAdapaM vilOkya tatra kinjcit phalaM prAptuM tasya sannikRSTaM yayau, tadAnIM phalapAtanasya samayO nAgacchati| tatastatrOpasthitaH patrANi vinA kimapyaparaM na prApya sa kathitavAn, ");
INSERT INTO sancol_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","adyArabhya kOpi mAnavastvattaH phalaM na bhunjjIta; imAM kathAM tasya ziSyAH zuzruvuH| ");
INSERT INTO sancol_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","tadanantaraM tESu yirUzAlamamAyAtESu yIzu rmandiraM gatvA tatrasthAnAM baNijAM mudrAsanAni pArAvatavikrEtRNAm AsanAni ca nyubjayAnjcakAra sarvvAn krEtRn vikrEtRMzca bahizcakAra| ");
INSERT INTO sancol_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","aparaM mandiramadhyEna kimapi pAtraM vOPhuM sarvvajanaM nivArayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","lOkAnupadizan jagAda, mama gRhaM sarvvajAtIyAnAM prArthanAgRham iti nAmnA prathitaM bhaviSyati Etat kiM zAstrE likhitaM nAsti? kintu yUyaM tadEva cOrANAM gahvaraM kurutha| ");
INSERT INTO sancol_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","imAM vANIM zrutvAdhyApakAH pradhAnayAjakAzca taM yathA nAzayituM zaknuvanti tathOेpAyaM mRgayAmAsuH, kintu tasyOpadEzAt sarvvE lOkA vismayaM gatA atastE tasmAd bibhyuH| ");
INSERT INTO sancol_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","atha sAyaMsamaya upasthitE yIzurnagarAd bahirvavrAja| ");
INSERT INTO sancol_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","anantaraM prAtaHkAlE tE tEna mArgENa gacchantastamuPumbaramahIruhaM samUlaM zuSkaM dadRzuH| ");
INSERT INTO sancol_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","tataH pitaraH pUrvvavAkyaM smaran yIzuM babhASaM, hE gurO pazyatu ya uPumbaraviTapI bhavatA zaptaH sa zuSkO babhUva| ");
INSERT INTO sancol_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","tatO yIzuH pratyavAdIt, yUyamIzvarE vizvasita| ");
INSERT INTO sancol_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","yuSmAnahaM yathArthaM vadAmi kOpi yadyEtadgiriM vadati, tvamutthAya gatvA jaladhau pata, prOktamidaM vAkyamavazyaM ghaTiSyatE, manasA kimapi na sandihya cEdidaM vizvasEt tarhi tasya vAkyAnusArENa tad ghaTiSyatE| ");
INSERT INTO sancol_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","atO hEtOrahaM yuSmAn vacmi, prArthanAkAlE yadyadAkAMkSiSyadhvE tattadavazyaM prApsyatha, itthaM vizvasita, tataH prApsyatha| ");
INSERT INTO sancol_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","aparanjca yuSmAsu prArthayituM samutthitESu yadi kOpi yuSmAkam aparAdhI tiSThati, tarhi taM kSamadhvaM, tathA kRtE yuSmAkaM svargasthaH pitApi yuSmAkamAgAMmi kSamiSyatE| ");
INSERT INTO sancol_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","kintu yadi na kSamadhvE tarhi vaH svargasthaH pitApi yuSmAkamAgAMsi na kSamiSyatE| ");
INSERT INTO sancol_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","anantaraM tE puna ryirUzAlamaM pravivizuH, yIzu ryadA madhyEmandiram itastatO gacchati, tadAnIM pradhAnayAjakA upAdhyAyAH prAnjcazca tadantikamEtya kathAmimAM papracchuH, ");
INSERT INTO sancol_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","tvaM kEnAdEzEna karmmANyEtAni karOSi? tathaitAni karmmANi karttAM kEnAdiSTOsi? ");
INSERT INTO sancol_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","tatO yIzuH pratigaditavAn ahamapi yuSmAn EkakathAM pRcchAmi, yadi yUyaM tasyA uttaraM kurutha, tarhi kayAjnjayAhaM karmmANyEtAni karOmi tad yuSmabhyaM kathayiSyAmi| ");
INSERT INTO sancol_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","yOhanO majjanam IzvarAt jAtaM kiM mAnavAt? tanmahyaM kathayata| ");
INSERT INTO sancol_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","tE parasparaM vivEktuM prArEbhirE, tad IzvarAd babhUvEti cEd vadAmastarhi kutastaM na pratyaita? kathamEtAM kathayiSyati| ");
INSERT INTO sancol_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","mAnavAd abhavaditi cEd vadAmastarhi lOkEbhyO bhayamasti yatO hEtOH sarvvE yOhanaM satyaM bhaviSyadvAdinaM manyantE| ");
INSERT INTO sancol_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ataEva tE yIzuM pratyavAdiSu rvayaM tad vaktuM na zaknumaH| yIzuruvAca, tarhi yEnAdEzEna karmmANyEtAni karOmi, ahamapi yuSmabhyaM tanna kathayiSyAmi| ");
INSERT INTO sancol_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","anantaraM yIzu rdRSTAntEna tEbhyaH kathayitumArEbhE, kazcidEkO drAkSAkSEtraM vidhAya taccaturdikSu vAraNIM kRtvA tanmadhyE drAkSApESaNakuNPam akhanat, tathA tasya gaPamapi nirmmitavAn tatastatkSEtraM kRSIvalESu samarpya dUradEzaM jagAma| ");
INSERT INTO sancol_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","tadanantaraM phalakAlE kRSIvalEbhyO drAkSAkSEtraphalAni prAptuM tESAM savidhE bhRtyam EkaM prAhiNOt| ");
INSERT INTO sancol_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","kintu kRSIvalAstaM dhRtvA prahRtya riktahastaM visasRjuH| ");
INSERT INTO sancol_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","tataH sa punaranyamEkaM bhRtyaM praSayAmAsa, kintu tE kRSIvalAH pASANAghAtaistasya zirO bhagktvA sApamAnaM taM vyasarjan| ");
INSERT INTO sancol_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","tataH paraM sOparaM dAsaM prAhiNOt tadA tE taM jaghnuH, Evam anEkESAM kasyacit prahAraH kasyacid vadhazca taiH kRtaH| ");
INSERT INTO sancol_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","tataH paraM mayA svaputrE prahitE tE tamavazyaM sammaMsyantE, ityuktvAvazESE tESAM sannidhau nijapriyam advitIyaM putraM prESayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","kintu kRSIvalAH parasparaM jagaduH, ESa uttarAdhikArI, Agacchata vayamEnaM hanmastathA kRtE 'dhikArOyam asmAkaM bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","tatastaM dhRtvA hatvA drAkSAkSEtrAd bahiH prAkSipan| ");
INSERT INTO sancol_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","anEnAsau drAkSAkSEtrapatiH kiM kariSyati? sa Etya tAn kRSIvalAn saMhatya tatkSEtram anyESu kRSIvalESu samarpayiSyati| ");
INSERT INTO sancol_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","aparanjca, \"sthapatayaH kariSyanti grAvANaM yantu tucchakaM| prAdhAnaprastaraH kONE sa Eva saMbhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Etat karmma parEzasyAMdbhutaM nO dRSTitO bhavEt||\" imAM zAstrIyAM lipiM yUyaM kiM nApAThiSTa? ");
INSERT INTO sancol_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","tadAnIM sa tAnuddizya tAM dRSTAntakathAM kathitavAn, ta itthaM budvvA taM dharttAmudyatAH, kintu lOkEbhyO bibhyuH, tadanantaraM tE taM vihAya vavrajuH| ");
INSERT INTO sancol_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","aparanjca tE tasya vAkyadOSaM dharttAM katipayAn phirUzinO hErOdIyAMzca lOkAn tadantikaM prESayAmAsuH| ");
INSERT INTO sancol_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ta Agatya tamavadan, hE gurO bhavAn tathyabhASI kasyApyanurOdhaM na manyatE, pakSapAtanjca na karOti, yathArthata IzvarIyaM mArgaM darzayati vayamEtat prajAnImaH, kaisarAya karO dEyO na vAM? vayaM dAsyAmO na vA? ");
INSERT INTO sancol_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","kintu sa tESAM kapaTaM jnjAtvA jagAda, kutO mAM parIkSadhvE? EkaM mudrApAdaM samAnIya mAM darzayata| ");
INSERT INTO sancol_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","tadA tairEkasmin mudrApAdE samAnItE sa tAn papraccha, atra likhitaM nAma mUrtti rvA kasya? tE pratyUcuH, kaisarasya| ");
INSERT INTO sancol_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","tadA yIzuravadat tarhi kaisarasya dravyANi kaisarAya datta, Izvarasya dravyANi tu IzvarAya datta; tatastE vismayaM mEnirE| ");
INSERT INTO sancol_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","atha mRtAnAmutthAnaM yE na manyantE tE sidUkinO yIzOH samIpamAgatya taM papracchuH; ");
INSERT INTO sancol_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","hE gurO kazcijjanO yadi niHsantatiH san bhAryyAyAM satyAM mriyatE tarhi tasya bhrAtA tasya bhAryyAM gRhItvA bhrAtu rvaMzOtpattiM kariSyati, vyavasthAmimAM mUsA asmAn prati vyalikhat| ");
INSERT INTO sancol_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","kintu kEcit sapta bhrAtara Asan, tatastESAM jyESThabhrAtA vivahya niHsantatiH san amriyata| ");
INSERT INTO sancol_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","tatO dvitIyO bhrAtA tAM striyamagRhaNat kintu sOpi niHsantatiH san amriyata; atha tRtIyOpi bhrAtA tAdRzObhavat| ");
INSERT INTO sancol_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","itthaM saptaiva bhrAtarastAM striyaM gRhItvA niHsantAnAH santO'mriyanta, sarvvazESE sApi strI mriyatE sma| ");
INSERT INTO sancol_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","atha mRtAnAmutthAnakAlE yadA ta utthAsyanti tadA tESAM kasya bhAryyA sA bhaviSyati? yatastE saptaiva tAM vyavahan| ");
INSERT INTO sancol_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","tatO yIzuH pratyuvAca zAstram Izvarazaktinjca yUyamajnjAtvA kimabhrAmyata na? ");
INSERT INTO sancol_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","mRtalOkAnAmutthAnaM sati tE na vivahanti vAgdattA api na bhavanti, kintu svargIyadUtAnAM sadRzA bhavanti| ");
INSERT INTO sancol_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","punazca \"aham ibrAhIma Izvara ishAka IzvarO yAkUbazcEzvaraH\" yAmimAM kathAM stambamadhyE tiSThan IzvarO mUsAmavAdIt mRtAnAmutthAnArthE sA kathA mUsAlikhitE pustakE kiM yuSmAbhi rnApAThi? ");
INSERT INTO sancol_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","IzvarO jIvatAM prabhuH kintu mRtAnAM prabhu rna bhavati, tasmAddhEtO ryUyaM mahAbhramENa tiSThatha| ");
INSERT INTO sancol_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Etarhi EkOdhyApaka Etya tESAmitthaM vicAraM zuzrAva; yIzustESAM vAkyasya saduttaraM dattavAn iti budvvA taM pRSTavAn sarvvAsAm AjnjAnAM kA zrESThA? tatO yIzuH pratyuvAca, ");
INSERT INTO sancol_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","\"hE isrAyEllOkA avadhatta, asmAkaM prabhuH paramEzvara Eka Eva, ");
INSERT INTO sancol_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","yUyaM sarvvantaHkaraNaiH sarvvaprANaiH sarvvacittaiH sarvvazaktibhizca tasmin prabhau paramEzvarE prIyadhvaM,\" ityAjnjA zrESThA| ");
INSERT INTO sancol_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","tathA \"svaprativAsini svavat prEma kurudhvaM,\" ESA yA dvitIyAjnjA sA tAdRzI; EtAbhyAM dvAbhyAm AjnjAbhyAm anyA kApyAjnjA zrESThA nAsti| ");
INSERT INTO sancol_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","tadA sOdhyApakastamavadat, hE gurO satyaM bhavAn yathArthaM prOktavAn yata EkasmAd IzvarAd anyO dvitIya IzvarO nAsti; ");
INSERT INTO sancol_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","aparaM sarvvAntaHkaraNaiH sarvvaprANaiH sarvvacittaiH sarvvazaktibhizca IzvarE prEmakaraNaM tathA svamIpavAsini svavat prEmakaraNanjca sarvvEbhyO hOmabalidAnAdibhyaH zraSThaM bhavati| ");
INSERT INTO sancol_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","tatO yIzuH subuddhEriva tasyEdam uttaraM zrutvA taM bhASitavAn tvamIzvarasya rAjyAnna dUrOsi|itaH paraM tEna saha kasyApi vAkyasya vicAraM karttAM kasyApi pragalbhatA na jAtA| ");
INSERT INTO sancol_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","anantaraM madhyEmandiram upadizan yIzurimaM praznaM cakAra, adhyApakA abhiSiktaM (tArakaM) kutO dAyUdaH santAnaM vadanti? ");
INSERT INTO sancol_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","svayaM dAyUd pavitrasyAtmana AvEzEnEdaM kathayAmAsa| yathA| \"mama prabhumidaM vAkyavadat paramEzvaraH| tava zatrUnahaM yAvat pAdapIThaM karOmi na| tAvat kAlaM madIyE tvaM dakSapArzv upAviza|\" ");
INSERT INTO sancol_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","yadi dAyUd taM prabhUM vadati tarhi kathaM sa tasya santAnO bhavitumarhati? itarE lOkAstatkathAM zrutvAnananduH| ");
INSERT INTO sancol_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","tadAnIM sa tAnupadizya kathitavAn yE narA dIrghaparidhEyAni haTTE vipanau ca ");
INSERT INTO sancol_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","lOkakRtanamaskArAn bhajanagRhE pradhAnAsanAni bhOjanakAlE pradhAnasthAnAni ca kAgkSantE; ");
INSERT INTO sancol_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","vidhavAnAM sarvvasvaM grasitvA chalAd dIrghakAlaM prArthayantE tEbhya upAdhyAyEbhyaH sAvadhAnA bhavata; tE'dhikatarAn daNPAn prApsyanti| ");
INSERT INTO sancol_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","tadanantaraM lOkA bhANPAgArE mudrA yathA nikSipanti bhANPAgArasya sammukhE samupavizya yIzustadavalulOka; tadAnIM bahavO dhaninastasya madhyE bahUni dhanAni nirakSipan| ");
INSERT INTO sancol_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","pazcAd EkA daridrA vidhavA samAgatya dvipaNamUlyAM mudraikAM tatra nirakSipat| ");
INSERT INTO sancol_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","tadA yIzuH ziSyAn AhUya kathitavAn yuSmAnahaM yathArthaM vadAmi yE yE bhANPAgArE'smina dhanAni niHkSipanti sma tEbhyaH sarvvEbhya iyaM vidhavA daridrAdhikam niHkSipati sma| ");
INSERT INTO sancol_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","yatastE prabhUtadhanasya kinjcit nirakSipan kintu dInEyaM svadinayApanayOgyaM kinjcidapi na sthApayitvA sarvvasvaM nirakSipat| ");
INSERT INTO sancol_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","anantaraM mandirAd bahirgamanakAlE tasya ziSyANAmEkastaM vyAhRtavAn hE gurO pazyatu kIdRzAH pASANAH kIdRk ca nicayanaM| ");
INSERT INTO sancol_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","tadA yIzustam avadat tvaM kimEtad bRhannicayanaM pazyasi? asyaikapASANOpi dvitIyapASANOpari na sthAsyati sarvvE 'dhaHkSEpsyantE| ");
INSERT INTO sancol_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","atha yasmin kAlE jaitungirau mandirasya sammukhE sa samupaviSTastasmin kAlE pitarO yAkUb yOhan AndriyazcaitE taM rahasi papracchuH, ");
INSERT INTO sancol_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","EtA ghaTanAH kadA bhaviSyanti? tathaitatsarvvAsAM siddhyupakramasya vA kiM cihnaM? tadasmabhyaM kathayatu bhavAn| ");
INSERT INTO sancol_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","tatO yAzustAn vaktumArEbhE, kOpi yathA yuSmAn na bhrAmayati tathAtra yUyaM sAvadhAnA bhavata| ");
INSERT INTO sancol_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","yataH khrISTOhamiti kathayitvA mama nAmnAnEkE samAgatya lOkAnAM bhramaM janayiSyanti; ");
INSERT INTO sancol_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","kintu yUyaM raNasya vArttAM raNAPambaranjca zrutvA mA vyAkulA bhavata, ghaTanA EtA avazyammAvinyaH; kintvApAtatO na yugAntO bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","dEzasya vipakSatayA dEzO rAjyasya vipakSatayA ca rAjyamutthAsyati, tathA sthAnE sthAnE bhUmikampO durbhikSaM mahAklEzAzca samupasthAsyanti, sarvva EtE duHkhasyArambhAH| ");
INSERT INTO sancol_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","kintu yUyam AtmArthE sAvadhAnAstiSThata, yatO lOkA rAjasabhAyAM yuSmAn samarpayiSyanti, tathA bhajanagRhE prahariSyanti; yUyaM madarthE dEzAdhipAn bhUpAMzca prati sAkSyadAnAya tESAM sammukhE upasthApayiSyadhvE| ");
INSERT INTO sancol_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","zESIbhavanAt pUrvvaM sarvvAn dEzIyAn prati susaMvAdaH pracArayiSyatE| ");
INSERT INTO sancol_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","kintu yadA tE yuSmAn dhRtvA samarpayiSyanti tadA yUyaM yadyad uttaraM dAsyatha, tadagra tasya vivEcanaM mA kuruta tadarthaM kinjcidapi mA cintayata ca, tadAnIM yuSmAkaM manaHsu yadyad vAkyam upasthApayiSyatE tadEva vadiSyatha, yatO yUyaM na tadvaktAraH kintu pavitra AtmA tasya vaktA| ");
INSERT INTO sancol_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","tadA bhrAtA bhrAtaraM pitA putraM ghAtanArthaM parahastESu samarpayiSyatE, tathA patyAni mAtApitrO rvipakSatayA tau ghAtayiSyanti| ");
INSERT INTO sancol_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","mama nAmahEtOH sarvvESAM savidhE yUyaM jugupsitA bhaviSyatha, kintu yaH kazcit zESaparyyantaM dhairyyam AlambiSyatE saEva paritrAsyatE| ");
INSERT INTO sancol_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","dAniyElbhaviSyadvAdinA prOktaM sarvvanAzi jugupsitanjca vastu yadA tvayOgyasthAnE vidyamAnaM drakSatha (yO janaH paThati sa budhyatAM) tadA yE yihUdIyadEzE tiSThanti tE mahIdhraM prati palAyantAM; ");
INSERT INTO sancol_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","tathA yO narO gRhOpari tiSThati sa gRhamadhyaM nAvarOhatu, tathA kimapi vastu grahItuM madhyEgRhaM na pravizatu; ");
INSERT INTO sancol_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","tathA ca yO naraH kSEtrE tiSThati sOpi svavastraM grahItuM parAvRtya na vrajatu| ");
INSERT INTO sancol_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","tadAnIM garbbhavatInAM stanyadAtrINAnjca yOSitAM durgati rbhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","yuSmAkaM palAyanaM zItakAlE yathA na bhavati tadarthaM prArthayadhvaM| ");
INSERT INTO sancol_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","yatastadA yAdRzI durghaTanA ghaTiSyatE tAdRzI durghaTanA IzvarasRSTEH prathamamArabhyAdya yAvat kadApi na jAtA na janiSyatE ca| ");
INSERT INTO sancol_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","aparanjca paramEzvarO yadi tasya samayasya saMkSEpaM na karOti tarhi kasyApi prANabhRtO rakSA bhavituM na zakSyati, kintu yAn janAn manOnItAn akarOt tESAM svamanOnItAnAM hEtOH sa tadanEhasaM saMkSEpsyati| ");
INSERT INTO sancol_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","anyacca pazyata khrISTOtra sthAnE vA tatra sthAnE vidyatE, tasminkAlE yadi kazcid yuSmAn EtAdRzaM vAkyaM vyAharati, tarhi tasmin vAkyE bhaiva vizvasita| ");
INSERT INTO sancol_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","yatOnEkE mithyAkhrISTA mithyAbhaviSyadvAdinazca samupasthAya bahUni cihnAnyadbhutAni karmmANi ca darzayiSyanti; tathA yadi sambhavati tarhi manOnItalOkAnAmapi mithyAmatiM janayiSyanti| ");
INSERT INTO sancol_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","pazyata ghaTanAtaH pUrvvaM sarvvakAryyasya vArttAM yuSmabhyamadAm, yUyaM sAvadhAnAstiSThata| ");
INSERT INTO sancol_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","aparanjca tasya klEzakAlasyAvyavahitE parakAlE bhAskaraH sAndhakArO bhaviSyati tathaiva candrazcandrikAM na dAsyati| ");
INSERT INTO sancol_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","nabhaHsthAni nakSatrANi patiSyanti, vyOmamaNPalasthA grahAzca vicaliSyanti| ");
INSERT INTO sancol_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","tadAnIM mahAparAkramENa mahaizvaryyENa ca mEghamAruhya samAyAntaM mAnavasutaM mAnavAH samIkSiSyantE| ");
INSERT INTO sancol_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","anyacca sa nijadUtAn prahitya nabhObhUmyOH sImAM yAvad jagatazcaturdigbhyaH svamanOnItalOkAn saMgrahISyati| ");
INSERT INTO sancol_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","uPumbaratarO rdRSTAntaM zikSadhvaM yadOPumbarasya tarO rnavInAH zAkhA jAyantE pallavAdIni ca rnigacchanti, tadA nidAghakAlaH savidhO bhavatIti yUyaM jnjAtuM zaknutha| ");
INSERT INTO sancol_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","tadvad EtA ghaTanA dRSTvA sa kAlO dvAryyupasthita iti jAnIta| ");
INSERT INTO sancol_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","yuSmAnahaM yathArthaM vadAmi, AdhunikalOkAnAM gamanAt pUrvvaM tAni sarvvANi ghaTiSyantE| ");
INSERT INTO sancol_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","dyAvApRthivyO rvicalitayOH satyO rmadIyA vANI na vicaliSyati| ");
INSERT INTO sancol_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","aparanjca svargasthadUtagaNO vA putrO vA tAtAdanyaH kOpi taM divasaM taM daNPaM vA na jnjApayati| ");
INSERT INTO sancol_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ataH sa samayaH kadA bhaviSyati, EtajjnjAnAbhAvAd yUyaM sAvadhAnAstiSThata, satarkAzca bhUtvA prArthayadhvaM; ");
INSERT INTO sancol_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","yadvat kazcit pumAn svanivEzanAd dUradEzaM prati yAtrAkaraNakAlE dAsESu svakAryyasya bhAramarpayitvA sarvvAn svE svE karmmaNi niyOjayati; aparaM dauvArikaM jAgarituM samAdizya yAti, tadvan naraputraH| ");
INSERT INTO sancol_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","gRhapatiH sAyaMkAlE nizIthE vA tRtIyayAmE vA prAtaHkAlE vA kadAgamiSyati tad yUyaM na jAnItha; ");
INSERT INTO sancol_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","sa haThAdAgatya yathA yuSmAn nidritAn na pazyati, tadarthaM jAgaritAstiSThata| ");
INSERT INTO sancol_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","yuSmAnahaM yad vadAmi tadEva sarvvAn vadAmi, jAgaritAstiSThatEti| ");
INSERT INTO sancol_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","tadA nistArOtsavakiNvahInapUpOtsavayOrArambhasya dinadvayE 'vaziSTE pradhAnayAjakA adhyApakAzca kEnApi chalEna yIzuM dharttAM hantunjca mRgayAnjcakrirE; ");
INSERT INTO sancol_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","kintu lOkAnAM kalahabhayAdUcirE, nacOtsavakAla ucitamEtaditi| ");
INSERT INTO sancol_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","anantaraM baithaniyApuुrE zimOnakuSThinO gRhE yOzau bhOtkumupaviSTE sati kAcid yOSit pANParapASANasya sampuTakEna mahArghyOttamatailam AnIya sampuTakaM bhaMktvA tasyOttamAggE tailadhArAM pAtayAnjcakrE| ");
INSERT INTO sancol_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","tasmAt kEcit svAntE kupyantaH kathitavaMntaH kutOyaM tailApavyayaH? ");
INSERT INTO sancol_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","yadyEtat taila vyakrESyata tarhi mudrApAdazatatrayAdapyadhikaM tasya prAptamUlyaM daridralOkEbhyO dAtumazakSyata, kathAmEtAM kathayitvA tayA yOSitA sAkaM vAcAyuhyan| ");
INSERT INTO sancol_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","kintu yIzuruvAca, kuta Etasyai kRcchraM dadAsi? mahyamiyaM karmmOttamaM kRtavatI| ");
INSERT INTO sancol_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","daridrAH sarvvadA yuSmAbhiH saha tiSThanti, tasmAd yUyaM yadEcchatha tadaiva tAnupakarttAM zaknutha, kintvahaM yubhAbhiH saha nirantaraM na tiSThAmi| ");
INSERT INTO sancol_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","asyA yathAsAdhyaM tathaivAkarOdiyaM, zmazAnayApanAt pUrvvaM samEtya madvapuSi tailam amarddayat| ");
INSERT INTO sancol_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","ahaM yuSmabhyaM yathArthaM kathayAmi, jagatAM madhyE yatra yatra susaMvAdOyaM pracArayiSyatE tatra tatra yOSita EtasyAH smaraNArthaM tatkRtakarmmaitat pracArayiSyatE| ");
INSERT INTO sancol_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","tataH paraM dvAdazAnAM ziSyANAmEka ISkariyOtIyayihUdAkhyO yIzuM parakarESu samarpayituM pradhAnayAjakAnAM samIpamiyAya| ");
INSERT INTO sancol_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","tE tasya vAkyaM samAkarNya santuSTAH santastasmai mudrA dAtuM pratyajAnata; tasmAt sa taM tESAM karESu samarpaNAyOpAyaM mRgayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","anantaraM kiNvazUnyapUpOtsavasya prathamE'hani nistArOtmavArthaM mESamAraNAsamayE ziSyAstaM papracchaH kutra gatvA vayaM nistArOtsavasya bhOjyamAsAdayiSyAmaH? kimicchati bhavAn? ");
INSERT INTO sancol_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","tadAnIM sa tESAM dvayaM prErayan babhASE yuvayOH puramadhyaM gatayOH satO ryO janaH sajalakumbhaM vahan yuvAM sAkSAt kariSyati tasyaiva pazcAd yAtaM; ");
INSERT INTO sancol_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","sa yat sadanaM pravEkSyati tadbhavanapatiM vadataM, gururAha yatra saziSyOhaM nistArOtsavIyaM bhOjanaM kariSyAmi, sA bhOjanazAlA kutrAsti? ");
INSERT INTO sancol_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","tataH sa pariSkRtAM susajjitAM bRhatIcanjca yAM zAlAM darzayiSyati tasyAmasmadarthaM bhOjyadravyANyAsAdayataM| ");
INSERT INTO sancol_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","tataH ziSyau prasthAya puraM pravizya sa yathOktavAn tathaiva prApya nistArOtsavasya bhOjyadravyANi samAsAdayEtAm| ");
INSERT INTO sancol_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","anantaraM yIzuH sAyaMkAlE dvAdazabhiH ziSyaiH sArddhaM jagAma; ");
INSERT INTO sancol_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","sarvvESu bhOjanAya prOpaviSTESu sa tAnuditavAn yuSmAnahaM yathArthaM vyAharAmi, atra yuSmAkamEkO janO yO mayA saha bhuMktE mAM parakErESu samarpayiSyatE| ");
INSERT INTO sancol_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","tadAnIM tE duHkhitAH santa EkaikazastaM praSTumArabdhavantaH sa kimahaM? pazcAd anya EkObhidadhE sa kimahaM? ");
INSERT INTO sancol_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","tataH sa pratyavadad EtESAM dvAdazAnAM yO janO mayA samaM bhOjanApAtrE pANiM majjayiSyati sa Eva| ");
INSERT INTO sancol_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","manujatanayamadhi yAdRzaM likhitamAstE tadanurUpA gatistasya bhaviSyati, kintu yO janO mAnavasutaM samarpayiSyatE hanta tasya janmAbhAvE sati bhadramabhaviSyat| ");
INSERT INTO sancol_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","aparanjca tESAM bhOjanasamayE yIzuH pUpaM gRhItvEzvaraguNAn anukIrtya bhagktvA tEbhyO dattvA babhASE, Etad gRhItvA bhunjjIdhvam Etanmama vigraharUpaM| ");
INSERT INTO sancol_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","anantaraM sa kaMsaM gRhItvEzvarasya guNAn kIrttayitvA tEbhyO dadau, tatastE sarvvE papuH| ");
INSERT INTO sancol_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","aparaM sa tAnavAdId bahUnAM nimittaM pAtitaM mama navInaniyamarUpaM zONitamEtat| ");
INSERT INTO sancol_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","yuSmAnahaM yathArthaM vadAmi, Izvarasya rAjyE yAvat sadyOjAtaM drAkSArasaM na pAsyAmi,tAvadahaM drAkSAphalarasaM puna rna pAsyAmi| ");
INSERT INTO sancol_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","tadanantaraM tE gItamEkaM saMgIya bahi rjaitunaM zikhariNaM yayuH ");
INSERT INTO sancol_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","atha yIzustAnuvAca nizAyAmasyAM mayi yuSmAkaM sarvvESAM pratyUhO bhaviSyati yatO likhitamAstE yathA, mESANAM rakSakanjcAhaM prahariSyAmi vai tataH| mESANAM nivahO nUnaM pravikIrNO bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","kantu madutthAnE jAtE yuSmAkamagrE'haM gAlIlaM vrajiSyAmi| ");
INSERT INTO sancol_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","tadA pitaraH pratibabhASE, yadyapi sarvvESAM pratyUhO bhavati tathApi mama naiva bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","tatO yIzuruktAvAn ahaM tubhyaM tathyaM kathayAmi, kSaNAdAyAmadya kukkuTasya dvitIyavAraravaNAt pUrvvaM tvaM vAratrayaM mAmapahnOSyasE| ");
INSERT INTO sancol_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","kintu sa gAPhaM vyAharad yadyapi tvayA sArddhaM mama prANO yAti tathApi kathamapi tvAM nApahnOSyE; sarvvE'pItarE tathaiva babhASirE| ");
INSERT INTO sancol_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","aparanjca tESu gEtzimAnInAmakaM sthAna gatESu sa ziSyAn jagAda, yAvadahaM prArthayE tAvadatra sthAnE yUyaM samupavizata| ");
INSERT INTO sancol_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","atha sa pitaraM yAkUbaM yOhananjca gRhItvA vavrAja; atyantaM trAsitO vyAkulitazca tEbhyaH kathayAmAsa, ");
INSERT INTO sancol_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","nidhanakAlavat prANO mE'tIva daHkhamEti, yUyaM jAgratOtra sthAnE tiSThata| ");
INSERT INTO sancol_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","tataH sa kinjciddUraM gatvA bhUmAvadhOmukhaH patitvA prArthitavAnEtat, yadi bhavituM zakyaM tarhi duHkhasamayOyaM mattO dUrIbhavatu| ");
INSERT INTO sancol_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","aparamuditavAn hE pita rhE pitaH sarvvEM tvayA sAdhyaM, tatO hEtOrimaM kaMsaM mattO dUrIkuru, kintu tan mamEcchAtO na tavEcchAtO bhavatu| ");
INSERT INTO sancol_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","tataH paraM sa Etya tAn nidritAn nirIkSya pitaraM prOvAca, zimOn tvaM kiM nidrAsi? ghaTikAmEkAm api jAgarituM na zaknOSi? ");
INSERT INTO sancol_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","parIkSAyAM yathA na patatha tadarthaM sacEtanAH santaH prArthayadhvaM; mana udyuktamiti satyaM kintu vapurazaktikaM| ");
INSERT INTO sancol_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","atha sa punarvrajitvA pUrvvavat prArthayAnjcakrE| ");
INSERT INTO sancol_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","parAvRtyAgatya punarapi tAn nidritAn dadarza tadA tESAM lOcanAni nidrayA pUrNAni, tasmAttasmai kA kathA kathayitavyA ta Etad bOddhuM na zEkuH| ");
INSERT INTO sancol_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","tataHparaM tRtIyavAraM Agatya tEbhyO 'kathayad idAnImapi zayitvA vizrAmyatha? yathESTaM jAtaM, samayazcOpasthitaH pazyata mAnavatanayaH pApilOkAnAM pANiSu samarpyatE| ");
INSERT INTO sancol_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","uttiSThata, vayaM vrajAmO yO janO mAM parapANiSu samarpayiSyatE pazyata sa samIpamAyAtaH| ");
INSERT INTO sancol_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","imAM kathAM kathayati sa, EtarhidvAdazAnAmEkO yihUdA nAmA ziSyaH pradhAnayAjakAnAm upAdhyAyAnAM prAcInalOkAnAnjca sannidhEH khaggalaguPadhAriNO bahulOkAn gRhItvA tasya samIpa upasthitavAn| ");
INSERT INTO sancol_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","aparanjcAsau parapANiSu samarpayitA pUrvvamiti sagkEtaM kRtavAn yamahaM cumbiSyAmi sa EvAsau tamEva dhRtvA sAvadhAnaM nayata| ");
INSERT INTO sancol_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","atO hEtOH sa Agatyaiva yOzOH savidhaM gatvA hE gurO hE gurO, ityuktvA taM cucumba| ");
INSERT INTO sancol_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","tadA tE tadupari pANInarpayitvA taM dadhnuH| ");
INSERT INTO sancol_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","tatastasya pArzvasthAnAM lOkAnAmEkaH khaggaM niSkOSayan mahAyAjakasya dAsamEkaM prahRtya tasya karNaM cicchEda| ");
INSERT INTO sancol_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","pazcAd yIzustAn vyAjahAra khaggAn laguPAMzca gRhItvA mAM kiM cauraM dharttAM samAyAtAH? ");
INSERT INTO sancol_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","madhyEmandiraM samupadizan pratyahaM yuSmAbhiH saha sthitavAnatahaM, tasmin kAlE yUyaM mAM nAdIdharata, kintvanEna zAstrIyaM vacanaM sEdhanIyaM| ");
INSERT INTO sancol_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","tadA sarvvE ziSyAstaM parityajya palAyAnjcakrirE| ");
INSERT INTO sancol_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","athaikO yuvA mAnavO nagnakAyE vastramEkaM nidhAya tasya pazcAd vrajan yuvalOkai rdhRtO ");
INSERT INTO sancol_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","vastraM vihAya nagnaH palAyAnjcakrE| ");
INSERT INTO sancol_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","aparanjca yasmin sthAnE pradhAnayAjakA upAdhyAyAH prAcInalOkAzca mahAyAjakEna saha sadasi sthitAstasmin sthAnE mahAyAjakasya samIpaM yIzuM ninyuH| ");
INSERT INTO sancol_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","pitarO dUrE tatpazcAd itvA mahAyAjakasyATTAlikAM pravizya kigkaraiH sahOpavizya vahnitApaM jagrAha| ");
INSERT INTO sancol_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","tadAnIM pradhAnayAjakA mantriNazca yIzuM ghAtayituM tatprAtikUlyEna sAkSiNO mRgayAnjcakrirE, kintu na prAptAH| ");
INSERT INTO sancol_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","anEkaistadviruddhaM mRSAsAkSyE dattEpi tESAM vAkyAni na samagacchanta| ");
INSERT INTO sancol_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","sarvvazESE kiyanta utthAya tasya prAtikUlyEna mRSAsAkSyaM dattvA kathayAmAsuH, ");
INSERT INTO sancol_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","idaM karakRtamandiraM vinAzya dinatrayamadhyE punaraparam akarakRtaM mandiraM nirmmAsyAmi, iti vAkyam asya mukhAt zrutamasmAbhiriti| ");
INSERT INTO sancol_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","kintu tatrApi tESAM sAkSyakathA na saggAtAH| ");
INSERT INTO sancol_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","atha mahAyAjakO madhyEsabham utthAya yIzuM vyAjahAra, EtE janAstvayi yat sAkSyamaduH tvamEtasya kimapyuttaraM kiM na dAsyasi? ");
INSERT INTO sancol_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","kintu sa kimapyuttaraM na datvA maunIbhUya tasyau; tatO mahAyAjakaH punarapi taM pRSTAvAn tvaM saccidAnandasya tanayO 'bhiSiktastratA? ");
INSERT INTO sancol_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","tadA yIzustaM prOvAca bhavAmyaham yUyanjca sarvvazaktimatO dakSINapArzvE samupavizantaM mEgha mAruhya samAyAntanjca manuSyaputraM sandrakSyatha| ");
INSERT INTO sancol_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","tadA mahAyAjakaH svaM vamanaM chitvA vyAvaharat ");
INSERT INTO sancol_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","kimasmAkaM sAkSibhiH prayOjanam? IzvaranindAvAkyaM yuSmAbhirazrAvi kiM vicArayatha? tadAnIM sarvvE jagadurayaM nidhanadaNPamarhati| ");
INSERT INTO sancol_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","tataH kazcit kazcit tadvapuSi niSThIvaM nicikSEpa tathA tanmukhamAcchAdya capETEna hatvA gaditavAn gaNayitvA vada, anucarAzca capETaistamAjaghnuH ");
INSERT INTO sancol_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","tataH paraM pitarE'TTAlikAdhaHkOSThE tiSThati mahAyAjakasyaikA dAsI samEtya ");
INSERT INTO sancol_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","taM vihnitApaM gRhlantaM vilOkya taM sunirIkSya babhASE tvamapi nAsaratIyayIzOH sagginAm EkO jana AsIH| ");
INSERT INTO sancol_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","kintu sOpahnutya jagAda tamahaM na vadmi tvaM yat kathayami tadapyahaM na buddhyE| tadAnIM pitarE catvaraM gatavati kuेkkuTO rurAva| ");
INSERT INTO sancol_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","athAnyA dAsI pitaraM dRSTvA samIpasthAn janAn jagAda ayaM tESAmEkO janaH| ");
INSERT INTO sancol_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","tataH sa dvitIyavAram apahnutavAn pazcAt tatrasthA lOkAH pitaraM prOcustvamavazyaM tESAmEkO janaH yatastvaM gAlIlIyO nara iti tavOccAraNaM prakAzayati| ");
INSERT INTO sancol_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","tadA sa zapathAbhizApau kRtvA prOvAca yUyaM kathAM kathayatha taM naraM na jAnE'haM| ");
INSERT INTO sancol_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","tadAnIM dvitIyavAraM kukkuTO 'rAvIt| kukkuTasya dvitIyaravAt pUrvvaM tvaM mAM vAratrayam apahnOSyasi, iti yadvAkyaM yIzunA samuditaM tat tadA saMsmRtya pitarO rOditum Arabhata| ");
INSERT INTO sancol_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","atha prabhAtE sati pradhAnayAjakAH prAnjca upAdhyAyAH sarvvE mantriNazca sabhAM kRtvA yIzuृM bandhayitva pIlAtAkhyasya dEzAdhipatEH savidhaM nItvA samarpayAmAsuH| ");
INSERT INTO sancol_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","tadA pIlAtastaM pRSTavAn tvaM kiM yihUdIyalOkAnAM rAjA? tataH sa pratyuktavAn satyaM vadasi| ");
INSERT INTO sancol_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","aparaM pradhAnayAjakAstasya bahuSu vAkyESu dOSamArOpayAnjcakruH kintu sa kimapi na pratyuvAca| ");
INSERT INTO sancol_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","tadAnIM pIlAtastaM punaH papraccha tvaM kiM nOttarayasi? pazyaitE tvadviruddhaM katiSu sAdhyESu sAkSaM dadati| ");
INSERT INTO sancol_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","kantu yIzustadApi nOttaraM dadau tataH pIlAta AzcaryyaM jagAma| ");
INSERT INTO sancol_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","aparanjca kArAbaddhE kastiMzcit janE tanmahOtsavakAlE lOkai ryAcitE dEzAdhipatistaM mOcayati| ");
INSERT INTO sancol_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","yE ca pUrvvamupaplavamakArSurupaplavE vadhamapi kRtavantastESAM madhyE tadAnOM barabbAnAmaka EkO baddha AsIt| ");
INSERT INTO sancol_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","atO hEtOH pUrvvAparIyAM rItikathAM kathayitvA lOkA uccairuvantaH pIlAtasya samakSaM nivEdayAmAsuH| ");
INSERT INTO sancol_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","tadA pIlAtastAnAcakhyau tarhi kiM yihUdIyAnAM rAjAnaM mOcayiSyAmi? yuSmAbhiH kimiSyatE? ");
INSERT INTO sancol_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","yataH pradhAnayAjakA IrSyAta Eva yIzuM samArpayanniti sa vivEda| ");
INSERT INTO sancol_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","kintu yathA barabbAM mOcayati tathA prArthayituM pradhAnayAjakA lOkAn pravarttayAmAsuH| ");
INSERT INTO sancol_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","atha pIlAtaH punaH pRSTavAn tarhi yaM yihUdIyAnAM rAjEti vadatha tasya kiM kariSyAmi yuSmAbhiH kimiSyatE? ");
INSERT INTO sancol_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","tadA tE punarapi prOccaiH prOcustaM kruzE vEdhaya| ");
INSERT INTO sancol_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","tasmAt pIlAtaH kathitavAn kutaH? sa kiM kukarmma kRtavAn? kintu tE punazca ruvantO vyAjahrustaM kruzE vEdhaya| ");
INSERT INTO sancol_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","tadA pIlAtaH sarvvAllOkAn tOSayitumicchan barabbAM mOcayitvA yIzuM kazAbhiH prahRtya kruzE vEddhuM taM samarpayAmbabhUva| ");
INSERT INTO sancol_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","anantaraM sainyagaNO'TTAlikAm arthAd adhipatE rgRhaM yIzuM nItvA sEnAnivahaM samAhuyat| ");
INSERT INTO sancol_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","pazcAt tE taM dhUmalavarNavastraM paridhApya kaNTakamukuTaM racayitvA zirasi samArOpya ");
INSERT INTO sancol_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","hE yihUdIyAnAM rAjan namaskAra ityuktvA taM namaskarttAmArEbhirE| ");
INSERT INTO sancol_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","tasyOttamAggE vEtrAghAtaM cakrustadgAtrE niSThIvanjca nicikSipuH, tathA tasya sammukhE jAnupAtaM praNOmuH ");
INSERT INTO sancol_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","itthamupahasya dhUmravarNavastram uttAryya tasya vastraM taM paryyadhApayan kruzE vEddhuM bahirninyuzca| ");
INSERT INTO sancol_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","tataH paraM sEkandarasya ruphasya ca pitA zimOnnAmA kurINIyalOka EkaH kutazcid grAmAdEtya pathi yAti taM tE yIzOH kruzaM vOPhuM balAd dadhnuH| ");
INSERT INTO sancol_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","atha gulgaltA arthAt ziraHkapAlanAmakaM sthAnaM yIzumAnIya ");
INSERT INTO sancol_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","tE gandharasamizritaM drAkSArasaM pAtuM tasmai daduH kintu sa na jagrAha| ");
INSERT INTO sancol_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","tasmin kruzE viddhE sati tESAmEkaikazaH kiM prApsyatIti nirNayAya ");
INSERT INTO sancol_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","tasya paridhEyAnAM vibhAgArthaM guTikApAtaM cakruH| ");
INSERT INTO sancol_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","aparam ESa yihUdIyAnAM rAjEti likhitaM dOSapatraM tasya ziraUrdvvam ArOpayAnjcakruH| ");
INSERT INTO sancol_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","tasya vAmadakSiNayO rdvau caurau kruzayO rvividhAtE| ");
INSERT INTO sancol_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","tEnaiva \"aparAdhijanaiH sArddhaM sa gaNitO bhaviSyati,\" iti zAstrOktaM vacanaM siddhamabhUta| ");
INSERT INTO sancol_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","anantaraM mArgE yE yE lOkA gamanAgamanE cakrustE sarvva Eva zirAMsyAndOlya nindantO jagaduH, rE mandiranAzaka rE dinatrayamadhyE tannirmmAyaka, ");
INSERT INTO sancol_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","adhunAtmAnam avitvA kruzAdavarOha| ");
INSERT INTO sancol_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","kinjca pradhAnayAjakA adhyApakAzca tadvat tiraskRtya parasparaM cacakSirE ESa parAnAvat kintu svamavituM na zaknOti| ");
INSERT INTO sancol_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","yadIsrAyElO rAjAbhiSiktastrAtA bhavati tarhyadhunaina kruzAdavarOhatu vayaM tad dRSTvA vizvasiSyAmaH; kinjca yau lOkau tEna sArddhaM kruzE 'vidhyEtAM tAvapi taM nirbhartsayAmAsatuH| ");
INSERT INTO sancol_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","atha dvitIyayAmAt tRtIyayAmaM yAvat sarvvO dEzaH sAndhakArObhUt| ");
INSERT INTO sancol_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","tatastRtIyapraharE yIzuruccairavadat ElI ElI lAmA zivaktanI arthAd \"hE madIza madIza tvaM paryyatyAkSIH kutO hi mAM?\" ");
INSERT INTO sancol_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","tadA samIpasthalOkAnAM kEcit tadvAkyaM nizamyAcakhyuH pazyaiSa Eliyam AhUyati| ");
INSERT INTO sancol_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","tata EkO janO dhAvitvAgatya spanjjE 'mlarasaM pUrayitvA taM naPAgrE nidhAya pAtuM tasmai dattvAvadat tiSTha Eliya EnamavarOhayitum Eti na vEti pazyAmi| ");
INSERT INTO sancol_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","atha yIzuruccaiH samAhUya prANAn jahau| ");
INSERT INTO sancol_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","tadA mandirasya javanikOrdvvAdadhaHryyantA vidIrNA dvikhaNPAbhUt| ");
INSERT INTO sancol_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","kinjca itthamuccairAhUya prANAn tyajantaM taM dRSdvA tadrakSaNAya niyuktO yaH sEnApatirAsIt sOvadat narOyam Izvaraputra iti satyam| ");
INSERT INTO sancol_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","tadAnIM magdalInI marisam kaniSThayAkUbO yOsEzca mAtAnyamariyam zAlOmI ca yAH striyO ");
INSERT INTO sancol_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","gAlIlpradEzE yIzuM sEvitvA tadanugAminyO jAtA imAstadanyAzca yA anEkA nAryO yIzunA sArddhaM yirUzAlamamAyAtAstAzca dUrAt tAni dadRzuH| ");
INSERT INTO sancol_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","athAsAdanadinasyArthAd vizrAmavArAt pUrvvadinasya sAyaMkAla Agata ");
INSERT INTO sancol_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","IzvararAjyApEkSyarimathIyayUSaphanAmA mAnyamantrI samEtya pIlAtasavidhaM nirbhayO gatvA yIzOrdEhaM yayAcE| ");
INSERT INTO sancol_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","kintu sa idAnIM mRtaH pIlAta ityasambhavaM matvA zatasEnApatimAhUya sa kadA mRta iti papraccha| ");
INSERT INTO sancol_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","zatasEmanApatimukhAt tajjnjAtvA yUSaphE yIzOrdEhaM dadau| ");
INSERT INTO sancol_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","pazcAt sa sUkSmaM vAsaH krItvA yIzOH kAyamavarOhya tEna vAsasA vESTAyitvA girau khAtazmazAnE sthApitavAn pASANaM lOThayitvA dvAri nidadhE| ");
INSERT INTO sancol_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","kintu yatra sOsthApyata tata magdalInI mariyam yOsimAtRmariyam ca dadRzatRH| ");
INSERT INTO sancol_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","atha vizrAmavArE gatE magdalInI mariyam yAkUbamAtA mariyam zAlOmI cEmAstaM marddayituM sugandhidravyANi krItvA ");
INSERT INTO sancol_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","saptAhaprathamadinE'tipratyUSE sUryyOdayakAlE zmazAnamupagatAH| ");
INSERT INTO sancol_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","kintu zmazAnadvArapASANO'tibRhan taM kO'pasArayiSyatIti tAH parasparaM gadanti! ");
INSERT INTO sancol_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Etarhi nirIkSya pASANO dvArO 'pasArita iti dadRzuH| ");
INSERT INTO sancol_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","pazcAttAH zmazAnaM pravizya zuklavarNadIrghaparicchadAvRtamEkaM yuvAnaM zmazAnadakSiNapArzva upaviSTaM dRSTvA camaccakruH| ");
INSERT INTO sancol_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","sO'vadat, mAbhaiSTa yUyaM kruzE hataM nAsaratIyayIzuM gavESayatha sOtra nAsti zmazAnAdudasthAt; tai ryatra sa sthApitaH sthAnaM tadidaM pazyata| ");
INSERT INTO sancol_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","kintu tEna yathOktaM tathA yuSmAkamagrE gAlIlaM yAsyatE tatra sa yuSmAn sAkSAt kariSyatE yUyaM gatvA tasya ziSyEbhyaH pitarAya ca vArttAmimAM kathayata| ");
INSERT INTO sancol_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","tAH kampitA vistitAzca tUrNaM zmazAnAd bahirgatvA palAyanta bhayAt kamapi kimapi nAvadaMzca| ");
INSERT INTO sancol_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","aparaM yIzuH saptAhaprathamadinE pratyUSE zmazAnAdutthAya yasyAH saptabhUtAstyAjitAstasyai magdalInImariyamE prathamaM darzanaM dadau| ");
INSERT INTO sancol_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","tataH sA gatvA zOkarOdanakRdbhyO'nugatalOkEbhyastAM vArttAM kathayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","kintu yIzuH punarjIvan tasyai darzanaM dattavAniti zrutvA tE na pratyayan| ");
INSERT INTO sancol_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","pazcAt tESAM dvAyO rgrAmayAnakAlE yIzuranyavEzaM dhRtvA tAbhyAM darzana dadau! ");
INSERT INTO sancol_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","tAvapi gatvAnyaziSyEbhyastAM kathAM kathayAnjcakratuH kintu tayOH kathAmapi tE na pratyayan| ");
INSERT INTO sancol_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","zESata EkAdazaziSyESu bhOjanOpaviSTESu yIzustEbhyO darzanaM dadau tathOtthAnAt paraM taddarzanaprAptalOkAnAM kathAyAmavizvAsakaraNAt tESAmavizvAsamanaHkAThinyAbhyAM hEtubhyAM sa tAMstarjitavAn| ");
INSERT INTO sancol_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","atha tAnAcakhyau yUyaM sarvvajagad gatvA sarvvajanAn prati susaMvAdaM pracArayata| ");
INSERT INTO sancol_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","tatra yaH kazcid vizvasya majjitO bhavEt sa paritrAsyatE kintu yO na vizvasiSyati sa daNPayiSyatE| ");
INSERT INTO sancol_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","kinjca yE pratyESyanti tairIdRg AzcaryyaM karmma prakAzayiSyatE tE mannAmnA bhUtAn tyAjayiSyanti bhASA anyAzca vadiSyanti| ");
INSERT INTO sancol_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","aparaM taiH sarpESu dhRtESu prANanAzakavastuni pItE ca tESAM kApi kSati rna bhaviSyati; rOgiNAM gAtrESu karArpitE tE'rOgA bhaviSyanti ca| ");
INSERT INTO sancol_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","atha prabhustAnityAdizya svargaM nItaH san paramEzvarasya dakSiNa upavivEza| ");
INSERT INTO sancol_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","tatastE prasthAya sarvvatra susaMvAdIyakathAM pracArayitumArEbhirE prabhustu tESAM sahAyaH san prakAzitAzcaryyakriyAbhistAM kathAM pramANavatIM cakAra| iti|");
INSERT INTO sancol_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","prathamatO yE sAkSiNO vAkyapracArakAzcAsan tE'smAkaM madhyE yadyat sapramANaM vAkyamarpayanti sma ");
INSERT INTO sancol_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","tadanusAratO'nyEpi bahavastadvRttAntaM racayituM pravRttAH| ");
INSERT INTO sancol_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ataEva hE mahAmahimathiyaphil tvaM yA yAH kathA azikSyathAstAsAM dRPhapramANAni yathA prApnOSi ");
INSERT INTO sancol_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","tadarthaM prathamamArabhya tAni sarvvANi jnjAtvAhamapi anukramAt sarvvavRttAntAn tubhyaM lEkhituM matimakArSam| ");
INSERT INTO sancol_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","yihUdAdEzIyahErOdnAmakE rAjatvaM kurvvati abIyayAjakasya paryyAyAdhikArI sikhariyanAmaka EkO yAjakO hArONavaMzOdbhavA ilIzEvAkhyA ");
INSERT INTO sancol_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","tasya jAyA dvAvimau nirdOSau prabhOH sarvvAjnjA vyavasthAzca saMmanya IzvaradRSTau dhArmmikAvAstAm| ");
INSERT INTO sancol_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","tayOH santAna EkOpi nAsIt, yata ilIzEvA bandhyA tau dvAvEva vRddhAvabhavatAm| ");
INSERT INTO sancol_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","yadA svaparyyAnukramENa sikhariya IzvAsya samakSaM yAjakIyaM karmma karOti ");
INSERT INTO sancol_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","tadA yajnjasya dinaparipAyyA paramEzvarasya mandirE pravEzakAlE dhUpajvAlanaM karmma tasya karaNIyamAsIt| ");
INSERT INTO sancol_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","taddhUpajvAlanakAlE lOkanivahE prArthanAM kartuM bahistiSThati ");
INSERT INTO sancol_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","sati sikhariyO yasyAM vEdyAM dhUpaM jvAlayati taddakSiNapArzvE paramEzvarasya dUta Eka upasthitO darzanaM dadau| ");
INSERT INTO sancol_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","taM dRSTvA sikhariya udvivijE zazagkE ca| ");
INSERT INTO sancol_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","tadA sa dUtastaM babhASE hE sikhariya mA bhaistava prArthanA grAhyA jAtA tava bhAryyA ilIzEvA putraM prasOSyatE tasya nAma yOेhan iti kariSyasi| ");
INSERT INTO sancol_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","kinjca tvaM sAnandaH saharSazca bhaviSyasi tasya janmani bahava AnandiSyanti ca| ");
INSERT INTO sancol_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","yatO hEtOH sa paramEzvarasya gOcarE mahAn bhaviSyati tathA drAkSArasaM surAM vA kimapi na pAsyati, aparaM janmArabhya pavitrENAtmanA paripUrNaH ");
INSERT INTO sancol_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","san isrAyElvaMzIyAn anEkAn prabhOH paramEzvarasya mArgamAnESyati| ");
INSERT INTO sancol_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","santAnAn prati pitRNAM manAMsi dharmmajnjAnaM pratyanAjnjAgrAhiNazca parAvarttayituM, prabhOH paramEzvarasya sEvArtham EkAM sajjitajAtiM vidhAtunjca sa EliyarUpAtmazaktiprAptastasyAgrE gamiSyati| ");
INSERT INTO sancol_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","tadA sikhariyO dUtamavAdIt kathamEtad vEtsyAmi? yatOhaM vRddhO mama bhAryyA ca vRddhA| ");
INSERT INTO sancol_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","tatO dUtaH pratyuvAca pazyEzvarasya sAkSAdvarttI jibrAyElnAmA dUtOhaM tvayA saha kathAM gadituM tubhyamimAM zubhavArttAM dAtunjca prESitaH| ");
INSERT INTO sancol_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","kintu madIyaM vAkyaM kAlE phaliSyati tat tvayA na pratItam ataH kAraNAd yAvadEva tAni na sEtsyanti tAvat tvaM vaktuMmazaktO mUkO bhava| ");
INSERT INTO sancol_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","tadAnIM yE yE lOkAH sikhariyamapaikSanta tE madhyEmandiraM tasya bahuvilambAd AzcaryyaM mEnirE| ");
INSERT INTO sancol_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","sa bahirAgatO yadA kimapi vAkyaM vaktumazaktaH sagkEtaM kRtvA niHzabdastasyau tadA madhyEmandiraM kasyacid darzanaM tEna prAptam iti sarvvE bubudhirE| ");
INSERT INTO sancol_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","anantaraM tasya sEvanaparyyAyE sampUrNE sati sa nijagEhaM jagAma| ");
INSERT INTO sancol_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","katipayadinESu gatESu tasya bhAryyA ilIzEvA garbbhavatI babhUva ");
INSERT INTO sancol_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","pazcAt sA panjcamAsAn saMgOpyAkathayat lOkAnAM samakSaM mamApamAnaM khaNPayituM paramEzvarO mayi dRSTiM pAtayitvA karmmEdRzaM kRtavAn| ");
INSERT INTO sancol_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","aparanjca tasyA garbbhasya SaSThE mAsE jAtE gAlIlpradEzIyanAsaratpurE ");
INSERT INTO sancol_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","dAyUdO vaMzIyAya yUSaphnAmnE puruSAya yA mariyamnAmakumArI vAgdattAsIt tasyAH samIpaM jibrAyEl dUta IzvarENa prahitaH| ");
INSERT INTO sancol_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","sa gatvA jagAda hE IzvarAnugRhItakanyE tava zubhaM bhUyAt prabhuH paramEzvarastava sahAyOsti nArINAM madhyE tvamEva dhanyA| ");
INSERT INTO sancol_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","tadAnIM sA taM dRSTvA tasya vAkyata udvijya kIdRzaM bhASaNamidam iti manasA cintayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","tatO dUtO'vadat hE mariyam bhayaM mAkArSIH, tvayi paramEzvarasyAnugrahOsti| ");
INSERT INTO sancol_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","pazya tvaM garbbhaM dhRtvA putraM prasOSyasE tasya nAma yIzuriti kariSyasi| ");
INSERT INTO sancol_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","sa mahAn bhaviSyati tathA sarvvEbhyaH zrESThasya putra iti khyAsyati; aparaM prabhuH paramEzvarastasya piturdAyUdaH siMhAsanaM tasmai dAsyati; ");
INSERT INTO sancol_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","tathA sa yAkUbO vaMzOpari sarvvadA rAjatvaM kariSyati, tasya rAjatvasyAntO na bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","tadA mariyam taM dUtaM babhASE nAhaM puruSasaggaM karOmi tarhi kathamEtat sambhaviSyati? ");
INSERT INTO sancol_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","tatO dUtO'kathayat pavitra AtmA tvAmAzrAyiSyati tathA sarvvazrESThasya zaktistavOpari chAyAM kariSyati tatO hEtOstava garbbhAd yaH pavitrabAlakO janiSyatE sa Izvaraputra iti khyAtiM prApsyati| ");
INSERT INTO sancol_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","aparanjca pazya tava jnjAtirilIzEvA yAM sarvvE bandhyAmavadan idAnIM sA vArddhakyE santAnamEkaM garbbhE'dhArayat tasya SaSThamAsObhUt| ");
INSERT INTO sancol_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","kimapi karmma nAsAdhyam Izvarasya| ");
INSERT INTO sancol_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","tadA mariyam jagAda, pazya prabhErahaM dAsI mahyaM tava vAkyAnusArENa sarvvamEtad ghaTatAm; ananataraM dUtastasyAH samIpAt pratasthE| ");
INSERT INTO sancol_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","atha katipayadinAt paraM mariyam tasmAt parvvatamayapradEzIyayihUdAyA nagaramEkaM zIghraM gatvA ");
INSERT INTO sancol_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","sikhariyayAjakasya gRhaM pravizya tasya jAyAm ilIzEvAM sambOdhyAvadat| ");
INSERT INTO sancol_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","tatO mariyamaH sambOdhanavAkyE ilIzEvAyAH karNayOH praviSTamAtrE sati tasyA garbbhasthabAlakO nanartta| tata ilIzEvA pavitrENAtmanA paripUrNA satI ");
INSERT INTO sancol_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","prOccairgaditumArEbhE, yOSitAM madhyE tvamEva dhanyA, tava garbbhasthaH zizuzca dhanyaH| ");
INSERT INTO sancol_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","tvaM prabhOrmAtA, mama nivEzanE tvayA caraNAvarpitau, mamAdya saubhAgyamEtat| ");
INSERT INTO sancol_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","pazya tava vAkyE mama karNayOH praviSTamAtrE sati mamOdarasthaH zizurAnandAn nanartta| ");
INSERT INTO sancol_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","yA strI vyazvasIt sA dhanyA, yatO hEtOstAM prati paramEzvarOktaM vAkyaM sarvvaM siddhaM bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","tadAnIM mariyam jagAda| dhanyavAdaM parEzasya karOti mAmakaM manaH| ");
INSERT INTO sancol_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","mamAtmA tArakEzE ca samullAsaM pragacchati| ");
INSERT INTO sancol_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","akarOt sa prabhu rduSTiM svadAsyA durgatiM prati| pazyAdyArabhya mAM dhanyAM vakSyanti puruSAH sadA| ");
INSERT INTO sancol_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","yaH sarvvazaktimAn yasya nAmApi ca pavitrakaM| sa Eva sumahatkarmma kRtavAn mannimittakaM| ");
INSERT INTO sancol_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","yE bibhyati janAstasmAt tESAM santAnapaMktiSu| anukampA tadIyA ca sarvvadaiva sutiSThati| ");
INSERT INTO sancol_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","svabAhubalatastEna prAkAzyata parAkramaH| manaHkumantraNAsArddhaM vikIryyantE'bhimAninaH| ");
INSERT INTO sancol_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","siMhAsanagatAllOkAn balinazcAvarOhya saH| padESUccESu lOkAMstu kSudrAn saMsthApayatyapi| ");
INSERT INTO sancol_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","kSudhitAn mAnavAn dravyairuttamaiH paritarpya saH| sakalAn dhaninO lOkAn visRjEd riktahastakAn| ");
INSERT INTO sancol_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ibrAhImi ca tadvaMzE yA dayAsti sadaiva tAM| smRtvA purA pitRNAM nO yathA sAkSAt pratizrutaM| ");
INSERT INTO sancol_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","isrAyElsEvakastEna tathOpakriyatE svayaM|| ");
INSERT INTO sancol_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","anantaraM mariyam prAyENa mAsatrayam ilIzEvayA sahOSitvA vyAghuyya nijanivEzanaM yayau| ");
INSERT INTO sancol_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","tadanantaram ilIzEvAyAH prasavakAla upasthitE sati sA putraM prAsOSTa| ");
INSERT INTO sancol_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","tataH paramEzvarastasyAM mahAnugrahaM kRtavAn Etat zrutvA samIpavAsinaH kuTumbAzcAgatya tayA saha mumudirE| ");
INSERT INTO sancol_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","tathASTamE dinE tE bAlakasya tvacaM chEttum Etya tasya pitRnAmAnurUpaM tannAma sikhariya iti karttumISuH| ");
INSERT INTO sancol_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","kintu tasya mAtAkathayat tanna, nAmAsya yOhan iti karttavyam| ");
INSERT INTO sancol_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","tadA tE vyAharan tava vaMzamadhyE nAmEdRzaM kasyApi nAsti| ");
INSERT INTO sancol_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","tataH paraM tasya pitaraM sikhariyaM prati sagkEtya papracchuH zizOH kiM nAma kAriSyatE? ");
INSERT INTO sancol_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","tataH sa phalakamEkaM yAcitvA lilEkha tasya nAma yOhan bhaviSyati| tasmAt sarvvE AzcaryyaM mEnirE| ");
INSERT INTO sancol_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","tatkSaNaM sikhariyasya jihvAjAPyE'pagatE sa mukhaM vyAdAya spaSTavarNamuccAryya Izvarasya guNAnuvAdaM cakAra| ");
INSERT INTO sancol_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","tasmAccaturdiksthAH samIpavAsilOkA bhItA EvamEtAH sarvvAH kathA yihUdAyAH parvvatamayapradEzasya sarvvatra pracAritAH| ");
INSERT INTO sancol_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","tasmAt zrOtArO manaHsu sthApayitvA kathayAmbabhUvuH kIdRzOyaM bAlO bhaviSyati? atha paramEzvarastasya sahAyObhUt| ");
INSERT INTO sancol_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","tadA yOhanaH pitA sikhariyaH pavitrENAtmanA paripUrNaH san EtAdRzaM bhaviSyadvAkyaM kathayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","isrAyElaH prabhu ryastu sa dhanyaH paramEzvaraH| anugRhya nijAllOkAn sa Eva parimOcayEt| ");
INSERT INTO sancol_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","vipakSajanahastEbhyO yathA mOcyAmahE vayaM| yAvajjIvanjca dharmmENa sAralyEna ca nirbhayAH| ");
INSERT INTO sancol_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","sEvAmahai tamEvaikam EtatkAraNamEva ca| svakIyaM supavitranjca saMsmRtya niyamaM sadA| ");
INSERT INTO sancol_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","kRpayA puruSAn pUrvvAn nikaSArthAttu naH pituH| ibrAhImaH samIpE yaM zapathaM kRtavAn purA| ");
INSERT INTO sancol_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","tamEva saphalaM karttaM tathA zatrugaNasya ca| RृtIyAkAriNazcaiva karEbhyO rakSaNAya naH| ");
INSERT INTO sancol_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","sRSTEH prathamataH svIyaiH pavitrai rbhAvivAdibhiH| ");
INSERT INTO sancol_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","yathOktavAn tathA svasya dAyUdaH sEvakasya tu| ");
INSERT INTO sancol_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","vaMzE trAtAramEkaM sa samutpAditavAn svayam| ");
INSERT INTO sancol_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","atO hE bAlaka tvantu sarvvEbhyaH zrESTha Eva yaH| tasyaiva bhAvivAdIti pravikhyAtO bhaviSyasi| asmAkaM caraNAn kSEmE mArgE cAlayituM sadA| EvaM dhvAntE'rthatO mRtyOzchAyAyAM yE tu mAnavAH| ");
INSERT INTO sancol_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","upaviSTAstu tAnEva prakAzayitumEva hi| kRtvA mahAnukampAM hi yAmEva paramEzvaraH| ");
INSERT INTO sancol_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","UrdvvAt sUryyamudAyyaivAsmabhyaM prAdAttu darzanaM| tayAnukampayA svasya lOkAnAM pApamOcanE| ");
INSERT INTO sancol_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","paritrANasya tEbhyO hi jnjAnavizrANanAya ca| prabhO rmArgaM pariSkarttuM tasyAgrAyI bhaviSyasi|| ");
INSERT INTO sancol_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","atha bAlakaH zarIrENa buddhyA ca varddhitumArEbhE; aparanjca sa isrAyElO vaMzIyalOkAnAM samIpE yAvanna prakaTIbhUtastAstAvat prAntarE nyavasat| ");
INSERT INTO sancol_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","aparanjca tasmin kAlE rAjyasya sarvvESAM lOkAnAM nAmAni lEkhayitum agastakaisara AjnjApayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","tadanusArENa kurINiyanAmani suriyAdEzasya zAsakE sati nAmalEkhanaM prArEbhE| ");
INSERT INTO sancol_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","atO hEtO rnAma lEkhituM sarvvE janAH svIyaM svIyaM nagaraM jagmuH| ");
INSERT INTO sancol_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","tadAnIM yUSaph nAma lEkhituM vAgdattayA svabhAryyayA garbbhavatyA mariyamA saha svayaM dAyUdaH sajAtivaMza iti kAraNAd gAlIlpradEzasya nAsaratnagarAd ");
INSERT INTO sancol_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","yihUdApradEzasya baitlEhamAkhyaM dAyUdnagaraM jagAma| ");
INSERT INTO sancol_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","anyacca tatra sthAnE tayOstiSThatOH satO rmariyamaH prasUtikAla upasthitE ");
INSERT INTO sancol_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","sA taM prathamasutaM prAsOSTa kintu tasmin vAsagRhE sthAnAbhAvAd bAlakaM vastrENa vESTayitvA gOzAlAyAM sthApayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","anantaraM yE kiyantO mESapAlakAH svamESavrajarakSAyai tatpradEzE sthitvA rajanyAM prAntarE prahariNaH karmma kurvvanti, ");
INSERT INTO sancol_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","tESAM samIpaM paramEzvarasya dUta AgatyOpatasthau; tadA catuSpArzvE paramEzvarasya tEjasaH prakAzitatvAt tE'tizazagkirE| ");
INSERT INTO sancol_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","tadA sa dUta uvAca mA bhaiSTa pazyatAdya dAyUdaH purE yuSmannimittaM trAtA prabhuH khrISTO'janiSTa, ");
INSERT INTO sancol_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","sarvvESAM lOkAnAM mahAnandajanakam imaM maggalavRttAntaM yuSmAn jnjApayAmi| ");
INSERT INTO sancol_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","yUyaM (tatsthAnaM gatvA) vastravESTitaM taM bAlakaM gOzAlAyAM zayanaM drakSyatha yuSmAn pratIdaM cihnaM bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","dUta imAM kathAM kathitavati tatrAkasmAt svargIyAH pRtanA Agatya kathAm imAM kathayitvEzvarasya guNAnanvavAdiSuH, yathA, ");
INSERT INTO sancol_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","sarvvOrdvvasthairIzvarasya mahimA samprakAzyatAM| zAntirbhUyAt pRthivyAstu santOSazca narAn prati|| ");
INSERT INTO sancol_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","tataH paraM tESAM sannidhE rdUtagaNE svargaM gatE mESapAlakAH parasparam avEcan Agacchata prabhuH paramEzvarO yAM ghaTanAM jnjApitavAn tasyA yAtharyaM jnjAtuM vayamadhunA baitlEhampuraM yAmaH| ");
INSERT INTO sancol_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","pazcAt tE tUrNaM vrajitvA mariyamaM yUSaphaM gOzAlAyAM zayanaM bAlakanjca dadRzuH| ");
INSERT INTO sancol_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","itthaM dRSTvA bAlakasyArthE prOktAM sarvvakathAM tE prAcArayAnjcakruH| ");
INSERT INTO sancol_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","tatO yE lOkA mESarakSakANAM vadanEbhyastAM vArttAM zuzruvustE mahAzcaryyaM mEnirE| ");
INSERT INTO sancol_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","kintu mariyam EtatsarvvaghaTanAnAM tAtparyyaM vivicya manasi sthApayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","tatpazcAd dUtavijnjaptAnurUpaM zrutvA dRSTvA ca mESapAlakA Izvarasya guNAnuvAdaM dhanyavAdanjca kurvvANAH parAvRtya yayuH| ");
INSERT INTO sancol_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","atha bAlakasya tvakchEdanakAlE'STamadivasE samupasthitE tasya garbbhasthitEH purvvaM svargIyadUtO yathAjnjApayat tadanurUpaM tE tannAmadhEyaM yIzuriti cakrirE| ");
INSERT INTO sancol_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","tataH paraM mUsAlikhitavyavasthAyA anusArENa mariyamaH zucitvakAla upasthitE, ");
INSERT INTO sancol_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","\"prathamajaH sarvvaH puruSasantAnaH paramEzvarE samarpyatAM,\" iti paramEzvarasya vyavasthayA ");
INSERT INTO sancol_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","yIzuM paramEzvarE samarpayitum zAstrIyavidhyuktaM kapOtadvayaM pArAvatazAvakadvayaM vA baliM dAtuM tE taM gRhItvA yirUzAlamam AyayuH| ");
INSERT INTO sancol_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","yirUzAlampuranivAsI zimiyOnnAmA dhArmmika Eka AsIt sa isrAyElaH sAntvanAmapEkSya tasthau kinjca pavitra AtmA tasminnAvirbhUtaH| ");
INSERT INTO sancol_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","aparaM prabhuNA paramEzvarENAbhiSiktE trAtari tvayA na dRSTE tvaM na mariSyasIti vAkyaM pavitrENa AtmanA tasma prAkathyata| ");
INSERT INTO sancol_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","aparanjca yadA yIzOH pitA mAtA ca tadarthaM vyavasthAnurUpaM karmma karttuM taM mandiram AninyatustadA ");
INSERT INTO sancol_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","zimiyOn Atmana AkarSaNEna mandiramAgatya taM krOPE nidhAya Izvarasya dhanyavAdaM kRtvA kathayAmAsa, yathA, ");
INSERT INTO sancol_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","hE prabhO tava dAsOyaM nijavAkyAnusArataH| idAnIntu sakalyANO bhavatA saMvisRjyatAm| ");
INSERT INTO sancol_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","yataH sakaladEzasya dIptayE dIptirUpakaM| ");
INSERT INTO sancol_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","isrAyElIyalOkasya mahAgauravarUpakaM| ");
INSERT INTO sancol_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","yaM trAyakaM janAnAntu sammukhE tvamajIjanaH| saEva vidyatE'smAkaM dhravaM nayananagOcarE|| ");
INSERT INTO sancol_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","tadAnIM tEnOktA EtAH sakalAH kathAH zrutvA tasya mAtA yUSaph ca vismayaM mEnAtE| ");
INSERT INTO sancol_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","tataH paraM zimiyOn tEbhya AziSaM dattvA tanmAtaraM mariyamam uvAca, pazya isrAyElO vaMzamadhyE bahUnAM pAtanAyOtthApanAya ca tathA virOdhapAtraM bhavituM, bahUnAM guptamanOgatAnAM prakaTIkaraNAya bAlakOyaM niyuktOsti| ");
INSERT INTO sancol_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","tasmAt tavApi prANAH zUlEna vyatsyantE| ");
INSERT INTO sancol_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","aparanjca AzErasya vaMzIyaphinUyElO duhitA hannAkhyA atijaratI bhaviSyadvAdinyEkA yA vivAhAt paraM sapta vatsarAn patyA saha nyavasat tatO vidhavA bhUtvA caturazItivarSavayaHparyyanataM ");
INSERT INTO sancol_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","mandirE sthitvA prArthanOpavAsairdivAnizam Izvaram asEvata sApi strI tasmin samayE mandiramAgatya ");
INSERT INTO sancol_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","paramEzvarasya dhanyavAdaM cakAra, yirUzAlampuravAsinO yAvantO lOkA muktimapEkSya sthitAstAn yIzOrvRttAntaM jnjApayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","itthaM paramEzvarasya vyavasthAnusArENa sarvvESu karmmasu kRtESu tau punazca gAlIlO nAsaratnAmakaM nijanagaraM pratasthAtE| ");
INSERT INTO sancol_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","tatpazcAd bAlakaH zarIrENa vRddhimEtya jnjAnEna paripUrNa AtmanA zaktimAMzca bhavitumArEbhE tathA tasmin IzvarAnugrahO babhUva| ");
INSERT INTO sancol_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","tasya pitA mAtA ca prativarSaM nistArOtsavasamayE yirUzAlamam agacchatAm| ");
INSERT INTO sancol_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","aparanjca yIzau dvAdazavarSavayaskE sati tau parvvasamayasya rItyanusArENa yirUzAlamaM gatvA ");
INSERT INTO sancol_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","pArvvaNaM sampAdya punarapi vyAghuyya yAtaH kintu yIzurbAlakO yirUzAlami tiSThati| yUSaph tanmAtA ca tad aviditvA ");
INSERT INTO sancol_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","sa saggibhiH saha vidyata Etacca budvvA dinaikagamyamArgaM jagmatuH| kintu zESE jnjAtibandhUnAM samIpE mRgayitvA taduddEेzamaprApya ");
INSERT INTO sancol_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","tau punarapi yirUzAlamam parAvRtyAgatya taM mRgayAnjcakratuH| ");
INSERT INTO sancol_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","atha dinatrayAt paraM paNPitAnAM madhyE tESAM kathAH zRNvan tattvaM pRcchaMzca mandirE samupaviSTaH sa tAbhyAM dRSTaH| ");
INSERT INTO sancol_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","tadA tasya buddhyA pratyuttaraizca sarvvE zrOtArO vismayamApadyantE| ");
INSERT INTO sancol_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","tAdRzaM dRSTvA tasya janakO jananI ca camaccakratuH kinjca tasya mAtA tamavadat, hE putra, kathamAvAM pratItthaM samAcarastvam? pazya tava pitAhanjca zOkAkulau santau tvAmanvicchAvaH sma| ");
INSERT INTO sancol_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","tataH sOvadat kutO mAm anvaicchataM? piturgRhE mayA sthAtavyam Etat kiM yuvAbhyAM na jnjAyatE? ");
INSERT INTO sancol_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","kintu tau tasyaitadvAkyasya tAtparyyaM bOddhuM nAzaknutAM| ");
INSERT INTO sancol_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","tataH paraM sa tAbhyAM saha nAsarataM gatvA tayOrvazIbhUtastasthau kintu sarvvA EtAH kathAstasya mAtA manasi sthApayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","atha yIzO rbuddhiH zarIranjca tathA tasmin Izvarasya mAnavAnAnjcAnugrahO varddhitum ArEbhE| ");
INSERT INTO sancol_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","anantaraM tibiriyakaisarasya rAjatvasya panjcadazE vatsarE sati yadA pantIyapIlAtO yihUdAdEzAdhipati rhErOd tu gAlIlpradEzasya rAjA philipanAmA tasya bhrAtA tu yitUriyAyAstrAkhOnItiyApradEzasya ca rAjAsIt luSAnIyanAmA avilInIdEzasya rAjAsIt ");
INSERT INTO sancol_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","hAnan kiyaphAzcEmau pradhAnayAjAkAvAstAM tadAnIM sikhariyasya putrAya yOhanE madhyEprAntaram Izvarasya vAkyE prakAzitE sati ");
INSERT INTO sancol_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","sa yarddana ubhayataTapradEzAn samEtya pApamOcanArthaM manaHparAvarttanasya cihnarUpaM yanmajjanaM tadIyAH kathAH sarvvatra pracArayitumArEbhE| ");
INSERT INTO sancol_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","yizayiyabhaviSyadvaktRgranthE yAdRzI lipirAstE yathA, paramEzasya panthAnaM pariSkuruta sarvvataH| tasya rAjapathanjcaiva samAnaM kurutAdhunA| ");
INSERT INTO sancol_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","kAriSyantE samucchrAyAH sakalA nimnabhUmayaH| kAriSyantE natAH sarvvE parvvatAzcOpaparvvatAH| kAriSyantE ca yA vakrAstAH sarvvAH saralA bhuvaH| kAriSyantE samAnAstA yA uccanIcabhUmayaH| ");
INSERT INTO sancol_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","IzvarENa kRtaM trANaM drakSyanti sarvvamAnavAH| ityEtat prAntarE vAkyaM vadataH kasyacid ravaH|| ");
INSERT INTO sancol_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","yE yE lOkA majjanArthaM bahirAyayustAn sOvadat rE rE sarpavaMzA AgAminaH kOpAt palAyituM yuSmAn kazcEtayAmAsa? ");
INSERT INTO sancol_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","tasmAd ibrAhIm asmAkaM pitA kathAmIdRzIM manObhi rna kathayitvA yUyaM manaHparivarttanayOgyaM phalaM phalata; yuSmAnahaM yathArthaM vadAmi pASANEbhya EtEbhya Izvara ibrAhImaH santAnOtpAdanE samarthaH| ");
INSERT INTO sancol_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","aparanjca tarumUlE'dhunApi parazuH saMlagnOsti yastaruruttamaM phalaM na phalati sa chidyatE'gnau nikSipyatE ca| ");
INSERT INTO sancol_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","tadAnIM lOkAstaM papracchustarhi kiM karttavyamasmAbhiH? ");
INSERT INTO sancol_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","tataH sOvAdIt yasya dvE vasanE vidyEtE sa vastrahInAyaikaM vitaratu kiMnjca yasya khAdyadravyaM vidyatE sOpi tathaiva karOtu| ");
INSERT INTO sancol_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","tataH paraM karasanjcAyinO majjanArtham Agatya papracchuH hE gurO kiM karttavyamasmAbhiH? ");
INSERT INTO sancol_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","tataH sOkathayat nirUpitAdadhikaM na gRhlita| ");
INSERT INTO sancol_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","anantaraM sEnAgaNa Etya papraccha kimasmAbhi rvA karttavyam? tataH sObhidadhE kasya kAmapi hAniM mA kArSTa tathA mRSApavAdaM mA kuruta nijavEtanEna ca santuSya tiSThata| ");
INSERT INTO sancol_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","aparanjca lOkA apEkSayA sthitvA sarvvEpIti manObhi rvitarkayAnjcakruH, yOhanayam abhiSiktastrAtA na vEti? ");
INSERT INTO sancol_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","tadA yOhan sarvvAn vyAjahAra, jalE'haM yuSmAn majjayAmi satyaM kintu yasya pAdukAbandhanaM mOcayitumapi na yOgyOsmi tAdRza EkO mattO gurutaraH pumAn Eti, sa yuSmAn vahnirUpE pavitra Atmani majjayiSyati| ");
INSERT INTO sancol_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","aparanjca tasya hastE zUrpa AstE sa svazasyAni zuddharUpaM prasphOTya gOdhUmAn sarvvAn bhANPAgArE saMgrahISyati kintu bUSANi sarvvANyanirvvANavahninA dAhayiSyati| ");
INSERT INTO sancol_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","yOhan upadEzEnEtthaM nAnAkathA lOkAnAM samakSaM pracArayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","aparanjca hErOd rAjA philipnAmnaH sahOdarasya bhAryyAM hErOdiyAmadhi tathAnyAni yAni yAni kukarmmANi kRtavAn tadadhi ca ");
INSERT INTO sancol_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","yOhanA tiraskRtO bhUtvA kArAgArE tasya bandhanAd aparamapi kukarmma cakAra| ");
INSERT INTO sancol_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","itaH pUrvvaM yasmin samayE sarvvE yOhanA majjitAstadAnIM yIzurapyAgatya majjitaH| ");
INSERT INTO sancol_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","tadanantaraM tEna prArthitE mEghadvAraM muktaM tasmAcca pavitra AtmA mUrttimAn bhUtvA kapOtavat taduparyyavarurOha; tadA tvaM mama priyaH putrastvayi mama paramaH santOSa ityAkAzavANI babhUva| ");
INSERT INTO sancol_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","tadAnIM yIzuH prAyENa triMzadvarSavayaska AsIt| laukikajnjAnE tu sa yUSaphaH putraH, ");
INSERT INTO sancol_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","yUSaph ElEH putraH, ElirmattataH putraH, mattat lEvEH putraH, lEvi rmalkEH putraH, malkiryAnnasya putraH; yAnnO yUSaphaH putraH| ");
INSERT INTO sancol_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","yUSaph mattathiyasya putraH, mattathiya AmOsaH putraH, AmOs nahUmaH putraH, nahUm iSlEH putraH iSlirnagEH putraH| ");
INSERT INTO sancol_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","nagirmATaH putraH, mAT mattathiyasya putraH, mattathiyaH zimiyEH putraH, zimiyiryUSaphaH putraH, yUSaph yihUdAH putraH| ");
INSERT INTO sancol_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","yihUdA yOhAnAH putraH, yOhAnA rISAH putraH, rISAH sirubbAbilaH putraH, sirubbAbil zaltIyElaH putraH, zaltIyEl nErEH putraH| ");
INSERT INTO sancol_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","nErirmalkEH putraH, malkiH adyaH putraH, addI kOSamaH putraH, kOSam ilmOdadaH putraH, ilmOdad EraH putraH| ");
INSERT INTO sancol_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er yOzEH putraH, yOziH ilIyESaraH putraH, ilIyESar yOrImaH putraH, yOrIm mattataH putraH, mattata lEvEH putraH| ");
INSERT INTO sancol_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","lEviH zimiyOnaH putraH, zimiyOn yihUdAH putraH, yihUdA yUSuphaH putraH, yUSuph yOnanaH putraH, yAnan ilIyAkImaH putraH| ");
INSERT INTO sancol_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","iliyAkImH milEyAH putraH, milEyA mainanaH putraH, mainan mattattasya putraH, mattattO nAthanaH putraH, nAthan dAyUdaH putraH| ");
INSERT INTO sancol_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","dAyUd yizayaH putraH, yizaya ObEdaH putra, ObEd bOyasaH putraH, bOyas salmOnaH putraH, salmOn nahazOnaH putraH| ");
INSERT INTO sancol_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","nahazOn ammInAdabaH putraH, ammInAdab arAmaH putraH, arAm hiSrONaH putraH, hiSrON pErasaH putraH, pEras yihUdAH putraH| ");
INSERT INTO sancol_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","yihUdA yAkUbaH putraH, yAkUb ishAkaH putraH, ishAk ibrAhImaH putraH, ibrAhIm tErahaH putraH, tErah nAhOraH putraH| ");
INSERT INTO sancol_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","nAhOr sirugaH putraH, sirug riyvaH putraH, riyUH pElagaH putraH, pElag EvaraH putraH, Evar zElahaH putraH| ");
INSERT INTO sancol_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","zElah kainanaH putraH, kainan arphakSadaH putraH, arphakSad zAmaH putraH, zAm nOhaH putraH, nOhO lEmakaH putraH| ");
INSERT INTO sancol_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","lEmak mithUzElahaH putraH, mithUzElah hanOkaH putraH, hanOk yEradaH putraH, yErad mahalalElaH putraH, mahalalEl kainanaH putraH| ");
INSERT INTO sancol_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","kainan inOzaH putraH, inOz zEtaH putraH, zEt AdamaH putra, Adam Izvarasya putraH| ");
INSERT INTO sancol_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","tataH paraM yIzuH pavitrENAtmanA pUrNaH san yarddananadyAH parAvRtyAtmanA prAntaraM nItaH san catvAriMzaddinAni yAvat zaitAnA parIkSitO'bhUt, ");
INSERT INTO sancol_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","kinjca tAni sarvvadinAni bhOjanaM vinA sthitatvAt kAlE pUrNE sa kSudhitavAn| ");
INSERT INTO sancol_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","tataH zaitAnAgatya tamavadat tvaM cEdIzvarasya putrastarhi prastarAnEtAn AjnjayA pUpAn kuru| ");
INSERT INTO sancol_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","tadA yIzuruvAca, lipirIdRzI vidyatE manujaH kEvalEna pUpEna na jIvati kintvIzvarasya sarvvAbhirAjnjAbhi rjIvati| ");
INSERT INTO sancol_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","tadA zaitAn tamuccaM parvvataM nItvA nimiSaikamadhyE jagataH sarvvarAjyAni darzitavAn| ");
INSERT INTO sancol_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","pazcAt tamavAdIt sarvvam Etad vibhavaM pratApanjca tubhyaM dAsyAmi tan mayi samarpitamAstE yaM prati mamEcchA jAyatE tasmai dAtuM zaknOmi, ");
INSERT INTO sancol_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","tvaM cEnmAM bhajasE tarhi sarvvamEtat tavaiva bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","tadA yIzustaM pratyuktavAn dUrI bhava zaitAn lipirAstE, nijaM prabhuM paramEzvaraM bhajasva kEvalaM tamEva sEvasva ca| ");
INSERT INTO sancol_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","atha zaitAn taM yirUzAlamaM nItvA mandirasya cUPAyA upari samupavEzya jagAda tvaM cEdIzvarasya putrastarhi sthAnAditO lamphitvAdhaH ");
INSERT INTO sancol_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","pata yatO lipirAstE, AjnjApayiSyati svIyAn dUtAn sa paramEzvaraH| ");
INSERT INTO sancol_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","rakSituM sarvvamArgE tvAM tEna tvaccaraNE yathA| na lagEt prastarAghAtastvAM dhariSyanti tE tathA| ");
INSERT INTO sancol_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","tadA yIzunA pratyuktam idamapyuktamasti tvaM svaprabhuM parEzaM mA parIkSasva| ");
INSERT INTO sancol_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","pazcAt zaitAn sarvvaparIkSAM samApya kSaNAttaM tyaktvA yayau| ");
INSERT INTO sancol_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","tadA yIzurAtmaprabhAvAt punargAlIlpradEzaM gatastadA tatsukhyAtizcaturdizaM vyAnazE| ");
INSERT INTO sancol_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","sa tESAM bhajanagRhESu upadizya sarvvaiH prazaMsitO babhUva| ");
INSERT INTO sancol_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","atha sa svapAlanasthAnaM nAsaratpuramEtya vizrAmavArE svAcArAd bhajanagEhaM pravizya paThitumuttasthau| ");
INSERT INTO sancol_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","tatO yizayiyabhaviSyadvAdinaH pustakE tasya karadattE sati sa tat pustakaM vistAryya yatra vakSyamANAni vacanAni santi tat sthAnaM prApya papATha| ");
INSERT INTO sancol_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","AtmA tu paramEzasya madIyOpari vidyatE| daridrESu susaMvAdaM vaktuM mAM sObhiSiktavAn| bhagnAntaH karaNAllOkAn susvasthAn karttumEva ca| bandIkRtESu lOkESu muktE rghOSayituM vacaH| nEtrANi dAtumandhEbhyastrAtuM baddhajanAnapi| ");
INSERT INTO sancol_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","parEzAnugrahE kAlaM pracArayitumEva ca| sarvvaitatkaraNArthAya mAmEva prahiNOti saH|| ");
INSERT INTO sancol_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","tataH pustakaM badvvA paricArakasya hastE samarpya cAsanE samupaviSTaH, tatO bhajanagRhE yAvantO lOkA Asan tE sarvvE'nanyadRSTyA taM vilulOkirE| ");
INSERT INTO sancol_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","anantaram adyaitAni sarvvANi likhitavacanAni yuSmAkaM madhyE siddhAni sa imAM kathAM tEbhyaH kathayitumArEbhE| ");
INSERT INTO sancol_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","tataH sarvvE tasmin anvarajyanta, kinjca tasya mukhAnnirgatAbhiranugrahasya kathAbhizcamatkRtya kathayAmAsuH kimayaM yUSaphaH putrO na? ");
INSERT INTO sancol_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","tadA sO'vAdId hE cikitsaka svamEva svasthaM kuru kapharnAhUmi yadyat kRtavAn tadazrauSma tAH sarvAH kriyA atra svadEzE kuru kathAmEtAM yUyamEvAvazyaM mAM vadiSyatha| ");
INSERT INTO sancol_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","punaH sOvAdId yuSmAnahaM yathArthaM vadAmi, kOpi bhaviSyadvAdI svadEzE satkAraM na prApnOti| ");
INSERT INTO sancol_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","aparanjca yathArthaM vacmi, Eliyasya jIvanakAlE yadA sArddhatritayavarSANi yAvat jaladapratibandhAt sarvvasmin dEzE mahAdurbhikSam ajaniSTa tadAnIm isrAyElO dEzasya madhyE bahvyO vidhavA Asan, ");
INSERT INTO sancol_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","kintu sIdOnpradEzIyasAriphatpuranivAsinIm EkAM vidhavAM vinA kasyAzcidapi samIpE EliyaH prEritO nAbhUt| ");
INSERT INTO sancol_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","aparanjca ilIzAyabhaviSyadvAdividyamAnatAkAlE isrAyEldEzE bahavaH kuSThina Asan kintu surIyadEzIyaM nAmAnkuSThinaM vinA kOpyanyaH pariSkRtO nAbhUt| ");
INSERT INTO sancol_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","imAM kathAM zrutvA bhajanagEhasthitA lOkAH sakrOdham utthAya ");
INSERT INTO sancol_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","nagarAttaM bahiSkRtya yasya zikhariNa upari tESAM nagaraM sthApitamAstE tasmAnnikSEptuM tasya zikharaM taM ninyuH ");
INSERT INTO sancol_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","kintu sa tESAM madhyAdapasRtya sthAnAntaraM jagAma| ");
INSERT INTO sancol_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","tataH paraM yIzurgAlIlpradEzIyakapharnAhUmnagara upasthAya vizrAmavArE lOkAnupadESTum ArabdhavAn| ");
INSERT INTO sancol_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","tadupadEzAt sarvvE camaccakru ryatastasya kathA gurutarA Asan| ");
INSERT INTO sancol_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","tadAnIM tadbhajanagEhasthitO'mEdhyabhUtagrasta EkO jana uccaiH kathayAmAsa, ");
INSERT INTO sancol_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","hE nAsaratIyayIzO'smAn tyaja, tvayA sahAsmAkaM kaH sambandhaH? kimasmAn vinAzayitumAyAsi? tvamIzvarasya pavitrO jana EtadahaM jAnAmi| ");
INSERT INTO sancol_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","tadA yIzustaM tarjayitvAvadat maunI bhava itO bahirbhava; tataH sOmEdhyabhUtastaM madhyasthAnE pAtayitvA kinjcidapyahiMsitvA tasmAd bahirgatavAn| ");
INSERT INTO sancol_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","tataH sarvvE lOkAzcamatkRtya parasparaM vaktumArEbhirE kOyaM camatkAraH| ESa prabhAvENa parAkramENa cAmEdhyabhUtAn AjnjApayati tEnaiva tE bahirgacchanti| ");
INSERT INTO sancol_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","anantaraM caturdiksthadEzAn tasya sukhyAtirvyApnOt| ");
INSERT INTO sancol_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","tadanantaraM sa bhajanagEhAd bahirAgatya zimOnO nivEzanaM pravivEza tadA tasya zvazrUrjvarENAtyantaM pIPitAsIt ziSyAstadarthaM tasmin vinayaM cakruH| ");
INSERT INTO sancol_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","tataH sa tasyAH samIpE sthitvA jvaraM tarjayAmAsa tEnaiva tAM jvarO'tyAkSIt tataH sA tatkSaNam utthAya tAn siSEvE| ");
INSERT INTO sancol_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","atha sUryyAstakAlE svESAM yE yE janA nAnArOgaiH pIPitA Asan lOkAstAn yIzOH samIpam AninyuH, tadA sa Ekaikasya gAtrE karamarpayitvA tAnarOgAn cakAra| ");
INSERT INTO sancol_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","tatO bhUtA bahubhyO nirgatya cItzabdaM kRtvA ca babhASirE tvamIzvarasya putrO'bhiSiktatrAtA; kintu sObhiSiktatrAtEti tE vividurEtasmAt kAraNAt tAn tarjayitvA tadvaktuM niSiSEdha| ");
INSERT INTO sancol_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","aparanjca prabhAtE sati sa vijanasthAnaM pratasthE pazcAt janAstamanvicchantastannikaTaM gatvA sthAnAntaragamanArthaM tamanvarundhan| ");
INSERT INTO sancol_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","kintu sa tAn jagAda, IzvarIyarAjyasya susaMvAdaM pracArayitum anyAni purANyapi mayA yAtavyAni yatastadarthamEva prEritOhaM| ");
INSERT INTO sancol_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","atha gAlIlO bhajanagEhESu sa upadidEza| ");
INSERT INTO sancol_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","anantaraM yIzurEkadA ginESarathdasya tIra uttiSThati, tadA lOkA IzvarIyakathAM zrOtuM tadupari prapatitAH| ");
INSERT INTO sancol_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","tadAnIM sa hdasya tIrasamIpE naudvayaM dadarza kinjca matsyOpajIvinO nAvaM vihAya jAlaM prakSAlayanti| ");
INSERT INTO sancol_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","tatastayOrdvayO rmadhyE zimOnO nAvamAruhya tIrAt kinjciddUraM yAtuM tasmin vinayaM kRtvA naukAyAmupavizya lOkAn prOpadiSTavAn| ");
INSERT INTO sancol_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","pazcAt taM prastAvaM samApya sa zimOnaM vyAjahAra, gabhIraM jalaM gatvA matsyAn dharttuM jAlaM nikSipa| ");
INSERT INTO sancol_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","tataH zimOna babhASE, hE gurO yadyapi vayaM kRtsnAM yAminIM parizramya matsyaikamapi na prAptAstathApi bhavatO nidEzatO jAlaM kSipAmaH| ");
INSERT INTO sancol_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","atha jAlE kSiptE bahumatsyapatanAd AnAyaH pracchinnaH| ");
INSERT INTO sancol_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","tasmAd upakarttum anyanausthAn saggina AyAtum iggitEna samAhvayan tatasta Agatya matsyai rnaudvayaM prapUrayAmAsu ryai rnaudvayaM pramagnam| ");
INSERT INTO sancol_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","tadA zimOnpitarastad vilOkya yIzOzcaraNayOH patitvA, hE prabhOhaM pApI narO mama nikaTAd bhavAn yAtu, iti kathitavAn| ");
INSERT INTO sancol_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","yatO jAlE patitAnAM matsyAnAM yUthAt zimOn tatsagginazca camatkRtavantaH; zimOnaH sahakAriNau sivadEH putrau yAkUb yOhan cEmau tAdRzau babhUvatuH| ");
INSERT INTO sancol_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","tadA yIzuH zimOnaM jagAda mA bhaiSIradyArabhya tvaM manuSyadharO bhaviSyasi| ");
INSERT INTO sancol_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","anantaraM sarvvAsu nausu tIram AnItAsu tE sarvvAn parityajya tasya pazcAdgAminO babhUvuH| ");
INSERT INTO sancol_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","tataH paraM yIzau kasmiMzcit purE tiSThati jana EkaH sarvvAggakuSThastaM vilOkya tasya samIpE nyubjaH patitvA savinayaM vaktumArEbhE, hE prabhO yadi bhavAnicchati tarhi mAM pariSkarttuM zaknOti| ");
INSERT INTO sancol_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","tadAnIM sa pANiM prasAryya tadaggaM spRzan babhASE tvaM pariSkriyasvEti mamEcchAsti tatastatkSaNaM sa kuSThAt muktaH| ");
INSERT INTO sancol_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","pazcAt sa tamAjnjApayAmAsa kathAmimAM kasmaicid akathayitvA yAjakasya samIpanjca gatvA svaM darzaya, lOkEbhyO nijapariSkRtatvasya pramANadAnAya mUsAjnjAnusArENa dravyamutmRjasva ca| ");
INSERT INTO sancol_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","tathApi yIzOH sukhyAti rbahu vyAptumArEbhE kinjca tasya kathAM zrOtuM svIyarOgEbhyO mOktunjca lOkA AjagmuH| ");
INSERT INTO sancol_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","atha sa prAntaraM gatvA prArthayAnjcakrE| ");
INSERT INTO sancol_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","aparanjca EkadA yIzurupadizati, Etarhi gAlIlyihUdApradEzayOH sarvvanagarEbhyO yirUzAlamazca kiyantaH phirUzilOkA vyavasthApakAzca samAgatya tadantikE samupavivizuH, tasmin kAlE lOkAnAmArOgyakAraNAt prabhOH prabhAvaH pracakAzE| ");
INSERT INTO sancol_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","pazcAt kiyantO lOkA EkaM pakSAghAtinaM khaTvAyAM nidhAya yIzOH samIpamAnEtuM sammukhE sthApayitunjca vyApriyanta| ");
INSERT INTO sancol_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","kintu bahujananivahasamvAdhAt na zaknuvantO gRhOpari gatvA gRhapRSThaM khanitvA taM pakSAghAtinaM sakhaTvaM gRhamadhyE yIzOH sammukhE 'varOhayAmAsuH| ");
INSERT INTO sancol_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","tadA yIzustESAm IdRzaM vizvAsaM vilOkya taM pakSAghAtinaM vyAjahAra, hE mAnava tava pApamakSamyata| ");
INSERT INTO sancol_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","tasmAd adhyApakAH phirUzinazca cittairitthaM pracintitavantaH, ESa jana IzvaraM nindati kOyaM? kEvalamIzvaraM vinA pApaM kSantuM kaH zaknOti? ");
INSERT INTO sancol_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","tadA yIzustESAm itthaM cintanaM viditvA tEbhyOkathayad yUyaM manObhiH kutO vitarkayatha? ");
INSERT INTO sancol_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","tava pApakSamA jAtA yadvA tvamutthAya vraja EtayO rmadhyE kA kathA sukathyA? ");
INSERT INTO sancol_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","kintu pRthivyAM pApaM kSantuM mAnavasutasya sAmarthyamastIti yathA yUyaM jnjAtuM zaknutha tadarthaM (sa taM pakSAghAtinaM jagAda) uttiSTha svazayyAM gRhItvA gRhaM yAhIti tvAmAdizAmi| ");
INSERT INTO sancol_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","tasmAt sa tatkSaNam utthAya sarvvESAM sAkSAt nijazayanIyaM gRhItvA IzvaraM dhanyaM vadan nijanivEzanaM yayau| ");
INSERT INTO sancol_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","tasmAt sarvvE vismaya prAptA manaHsu bhItAzca vayamadyAsambhavakAryyANyadarzAma ityuktvA paramEzvaraM dhanyaM prOditAH| ");
INSERT INTO sancol_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","tataH paraM bahirgacchan karasanjcayasthAnE lEvinAmAnaM karasanjcAyakaM dRSTvA yIzustamabhidadhE mama pazcAdEhi| ");
INSERT INTO sancol_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","tasmAt sa tatkSaNAt sarvvaM parityajya tasya pazcAdiyAya| ");
INSERT INTO sancol_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","anantaraM lEvi rnijagRhE tadarthaM mahAbhOjyaM cakAra, tadA taiH sahAnEkE karasanjcAyinastadanyalOkAzca bhOktumupavivizuH| ");
INSERT INTO sancol_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","tasmAt kAraNAt caNPAlAnAM pApilOkAnAnjca saggE yUyaM kutO bhaMgdhvE pivatha cEti kathAM kathayitvA phirUzinO'dhyApakAzca tasya ziSyaiH saha vAgyuddhaM karttumArEbhirE| ");
INSERT INTO sancol_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","tasmAd yIzustAn pratyavOcad arOgalOkAnAM cikitsakEna prayOjanaM nAsti kintu sarOgANAmEva| ");
INSERT INTO sancol_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ahaM dhArmmikAn AhvAtuM nAgatOsmi kintu manaH parAvarttayituM pApina Eva| ");
INSERT INTO sancol_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","tatastE prOcuH, yOhanaH phirUzinAnjca ziSyA vAraMvAram upavasanti prArthayantE ca kintu tava ziSyAH kutO bhunjjatE pivanti ca? ");
INSERT INTO sancol_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","tadA sa tAnAcakhyau varE saggE tiSThati varasya sakhigaNaM kimupavAsayituM zaknutha? ");
INSERT INTO sancol_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","kintu yadA tESAM nikaTAd varO nESyatE tadA tE samupavatsyanti| ");
INSERT INTO sancol_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","sOparamapi dRSTAntaM kathayAmbabhUva purAtanavastrE kOpi nutanavastraM na sIvyati yatastEna sEvanEna jIrNavastraM chidyatE, nUtanapurAtanavastrayO rmElanjca na bhavati| ");
INSERT INTO sancol_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","purAtanyAM kutvAM kOpi nutanaM drAkSArasaM na nidadhAti, yatO navInadrAkSArasasya tEjasA purAtanI kutU rvidIryyatE tatO drAkSArasaH patati kutUzca nazyati| ");
INSERT INTO sancol_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","tatO hEtO rnUtanyAM kutvAM navInadrAkSArasaH nidhAtavyastEnObhayasya rakSA bhavati| ");
INSERT INTO sancol_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","aparanjca purAtanaM drAkSArasaM pItvA kOpi nUtanaM na vAnjchati, yataH sa vakti nUtanAt purAtanam prazastam| ");
INSERT INTO sancol_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","acaranjca parvvaNO dvitIyadinAt paraM prathamavizrAmavArE zasyakSEtrENa yIzOrgamanakAlE tasya ziSyAH kaNizaM chittvA karESu marddayitvA khAditumArEbhirE| ");
INSERT INTO sancol_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","tasmAt kiyantaH phirUzinastAnavadan vizrAmavArE yat karmma na karttavyaM tat kutaH kurutha? ");
INSERT INTO sancol_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","yIzuH pratyuvAca dAyUd tasya sagginazca kSudhArttAH kiM cakruH sa katham Izvarasya mandiraM pravizya ");
INSERT INTO sancol_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","yE darzanIyAH pUpA yAjakAn vinAnyasya kasyApyabhOjanIyAstAnAnIya svayaM bubhajE saggibhyOpi dadau tat kiM yuSmAbhiH kadApi nApAThi? ");
INSERT INTO sancol_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","pazcAt sa tAnavadat manujasutO vizrAmavArasyApi prabhu rbhavati| ");
INSERT INTO sancol_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","anantaram anyavizrAmavArE sa bhajanagEhaM pravizya samupadizati| tadA tatsthAnE zuSkadakSiNakara EkaH pumAn upatasthivAn| ");
INSERT INTO sancol_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","tasmAd adhyApakAH phirUzinazca tasmin dOSamArOpayituM sa vizrAmavArE tasya svAsthyaM karOti navEti pratIkSitumArEbhirE| ");
INSERT INTO sancol_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","tadA yIzustESAM cintAM viditvA taM zuSkakaraM pumAMsaM prOvAca, tvamutthAya madhyasthAnE tiSTha| ");
INSERT INTO sancol_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","tasmAt tasmin utthitavati yIzustAn vyAjahAra, yuSmAn imAM kathAM pRcchAmi, vizrAmavArE hitam ahitaM vA, prANarakSaNaM prANanAzanaM vA, EtESAM kiM karmmakaraNIyam? ");
INSERT INTO sancol_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","pazcAt caturdikSu sarvvAn vilOkya taM mAnavaM babhASE, nijakaraM prasAraya; tatastEna tathA kRta itarakaravat tasya hastaH svasthObhavat| ");
INSERT INTO sancol_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","tasmAt tE pracaNPakOpAnvitA yIzuM kiM kariSyantIti parasparaM pramantritAH| ");
INSERT INTO sancol_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","tataH paraM sa parvvatamAruhyEzvaramuddizya prArthayamAnaH kRtsnAM rAtriM yApitavAn| ");
INSERT INTO sancol_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","atha dinE sati sa sarvvAn ziSyAn AhUtavAn tESAM madhyE ");
INSERT INTO sancol_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","pitaranAmnA khyAtaH zimOn tasya bhrAtA Andriyazca yAkUb yOhan ca philip barthalamayazca ");
INSERT INTO sancol_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","mathiH thOmA AlphIyasya putrO yAkUb jvalantanAmnA khyAtaH zimOn ");
INSERT INTO sancol_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ca yAkUbO bhrAtA yihUdAzca taM yaH parakarESu samarpayiSyati sa ISkarIyOtIyayihUdAzcaitAn dvAdaza janAn manOnItAn kRtvA sa jagrAha tathA prErita iti tESAM nAma cakAra| ");
INSERT INTO sancol_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","tataH paraM sa taiH saha parvvatAdavaruhya upatyakAyAM tasthau tatastasya ziSyasagghO yihUdAdEzAd yirUzAlamazca sOraH sIdOnazca jaladhE rOdhasO jananihAzca Etya tasya kathAzravaNArthaM rOgamuktyarthanjca tasya samIpE tasthuH| ");
INSERT INTO sancol_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","amEdhyabhUtagrastAzca tannikaTamAgatya svAsthyaM prApuH| ");
INSERT INTO sancol_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","sarvvESAM svAsthyakaraNaprabhAvasya prakAzitatvAt sarvvE lOkA Etya taM spraSTuM yEtirE| ");
INSERT INTO sancol_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","pazcAt sa ziSyAn prati dRSTiM kutvA jagAda, hE daridrA yUyaM dhanyA yata IzvarIyE rAjyE vO'dhikArOsti| ");
INSERT INTO sancol_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","hE adhunA kSudhitalOkA yUyaM dhanyA yatO yUyaM tarpsyatha; hE iha rOdinO janA yUyaM dhanyA yatO yUyaM hasiSyatha| ");
INSERT INTO sancol_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","yadA lOkA manuSyasUnO rnAmahEtO ryuSmAn RृtIyiSyantE pRthak kRtvA nindiSyanti, adhamAniva yuSmAn svasamIpAd dUrIkariSyanti ca tadA yUyaM dhanyAH| ");
INSERT INTO sancol_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","svargE yuSmAkaM yathESTaM phalaM bhaviSyati, EtadarthaM tasmin dinE prOllasata AnandEna nRtyata ca, tESAM pUrvvapuruSAzca bhaviSyadvAdinaH prati tathaiva vyavAharan| ");
INSERT INTO sancol_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","kintu hA hA dhanavantO yUyaM sukhaM prApnuta| hanta paritRptA yUyaM kSudhitA bhaviSyatha; ");
INSERT INTO sancol_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","iha hasantO yUyaM vata yuSmAbhiH zOcitavyaM rOditavyanjca| ");
INSERT INTO sancol_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","sarvvailAkai ryuSmAkaM sukhyAtau kRtAyAM yuSmAkaM durgati rbhaviSyati yuSmAkaM pUrvvapuruSA mRSAbhaviSyadvAdinaH prati tadvat kRtavantaH| ");
INSERT INTO sancol_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","hE zrOtArO yuSmabhyamahaM kathayAmi, yUyaM zatruSu prIyadhvaM yE ca yuSmAn dviSanti tESAmapi hitaM kuruta| ");
INSERT INTO sancol_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","yE ca yuSmAn zapanti tEbhya AziSaM datta yE ca yuSmAn avamanyantE tESAM maggalaM prArthayadhvaM| ");
INSERT INTO sancol_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","yadi kazcit tava kapOlE capETAghAtaM karOti tarhi taM prati kapOlam anyaM parAvarttya sammukhIkuru punazca yadi kazcit tava gAtrIyavastraM harati tarhi taM paridhEyavastram api grahItuM mA vAraya| ");
INSERT INTO sancol_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","yastvAM yAcatE tasmai dEhi, yazca tava sampattiM harati taM mA yAcasva| ");
INSERT INTO sancol_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","parEbhyaH svAn prati yathAcaraNam apEkSadhvE parAn prati yUyamapi tathAcarata| ");
INSERT INTO sancol_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","yE janA yuSmAsu prIyantE kEvalaM tESu prIyamANESu yuSmAkaM kiM phalaM? pApilOkA api svESu prIyamANESu prIyantE| ");
INSERT INTO sancol_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","yadi hitakAriNa Eva hitaM kurutha tarhi yuSmAkaM kiM phalaM? pApilOkA api tathA kurvvanti| ");
INSERT INTO sancol_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","yEbhya RNaparizOdhasya prAptipratyAzAstE kEvalaM tESu RNE samarpitE yuSmAkaM kiM phalaM? punaH prAptyAzayA pApIlOkA api pApijanESu RNam arpayanti| ");
INSERT INTO sancol_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","atO yUyaM ripuSvapi prIyadhvaM, parahitaM kuruta ca; punaH prAptyAzAM tyaktvA RNamarpayata, tathA kRtE yuSmAkaM mahAphalaM bhaviSyati, yUyanjca sarvvapradhAnasya santAnA iti khyAtiM prApsyatha, yatO yuSmAkaM pitA kRtaghnAnAM durvTattAnAnjca hitamAcarati| ");
INSERT INTO sancol_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ata Eva sa yathA dayAlu ryUyamapi tAdRzA dayAlavO bhavata| ");
INSERT INTO sancol_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","aparanjca parAn dOSiNO mA kuruta tasmAd yUyaM dOSIkRtA na bhaviSyatha; adaNPyAn mA daNPayata tasmAd yUyamapi daNPaM na prApsyatha; parESAM dOSAn kSamadhvaM tasmAd yuSmAkamapi dOSAH kSamiSyantE| ");
INSERT INTO sancol_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","dAnAnidatta tasmAd yUyaM dAnAni prApsyatha, varanjca lOkAH parimANapAtraM pradalayya sanjcAlya prOnjcAlya paripUryya yuSmAkaM krOPESu samarpayiSyanti; yUyaM yEna parimANEna parimAtha tEnaiva parimANEna yuSmatkRtE parimAsyatE| ");
INSERT INTO sancol_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","atha sa tEbhyO dRSTAntakathAmakathayat, andhO janaH kimandhaM panthAnaM darzayituM zaknOti? tasmAd ubhAvapi kiM garttE na patiSyataH? ");
INSERT INTO sancol_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","gurOH ziSyO na zrESThaH kintu ziSyE siddhE sati sa gurutulyO bhavituM zaknOti| ");
INSERT INTO sancol_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","aparanjca tvaM svacakSuुSi nAsAm adRSTvA tava bhrAtuzcakSuSi yattRNamasti tadEva kutaH pazyami? ");
INSERT INTO sancol_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","svacakSuSi yA nAsA vidyatE tAm ajnjAtvA, bhrAtastava nEtrAt tRNaM bahiH karOmIti vAkyaM bhrAtaraM kathaM vaktuM zaknOSi? hE kapaTin pUrvvaM svanayanAt nAsAM bahiH kuru tatO bhrAtuzcakSuSastRNaM bahiH karttuM sudRSTiM prApsyasi| ");
INSERT INTO sancol_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","anyanjca uttamastaruH kadApi phalamanuttamaM na phalati, anuttamataruzca phalamuttamaM na phalati kAraNAdataH phalaistaravO jnjAyantE| ");
INSERT INTO sancol_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","kaNTakipAdapAt kOpi uPumbaraphalAni na pAtayati tathA zRgAlakOlivRkSAdapi kOpi drAkSAphalaM na pAtayati| ");
INSERT INTO sancol_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","tadvat sAdhulOkO'ntaHkaraNarUpAt subhANPAgArAd uttamAni dravyANi bahiH karOti, duSTO lOkazcAntaHkaraNarUpAt kubhANPAgArAt kutsitAni dravyANi nirgamayati yatO'ntaHkaraNAnAM pUrNabhAvAnurUpANi vacAMsi mukhAnnirgacchanti| ");
INSERT INTO sancol_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","aparanjca mamAjnjAnurUpaM nAcaritvA kutO mAM prabhO prabhO iti vadatha? ");
INSERT INTO sancol_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","yaH kazcin mama nikaTam Agatya mama kathA nizamya tadanurUpaM karmma karOti sa kasya sadRzO bhavati tadahaM yuSmAn jnjAाpayAmi| ");
INSERT INTO sancol_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","yO janO gabhIraM khanitvA pASANasthalE bhittiM nirmmAya svagRhaM racayati tEna saha tasyOpamA bhavati; yata AplAvijalamEtya tasya mUlE vEgEna vahadapi tadgEhaM lAPayituM na zaknOti yatastasya bhittiH pASANOpari tiSThati| ");
INSERT INTO sancol_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","kintu yaH kazcin mama kathAH zrutvA tadanurUpaM nAcarati sa bhittiM vinA mRृdupari gRhanirmmAtrA samAnO bhavati; yata AplAvijalamAgatya vEgEna yadA vahati tadA tadgRhaM patati tasya mahat patanaM jAyatE| ");
INSERT INTO sancol_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","tataH paraM sa lOkAnAM karNagOcarE tAn sarvvAn upadEzAn samApya yadA kapharnAhUmpuraM pravizati ");
INSERT INTO sancol_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","tadA zatasEnApatEH priyadAsa EkO mRtakalpaH pIPita AsIt| ");
INSERT INTO sancol_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ataH sEnApati ryIzO rvArttAM nizamya dAsasyArOgyakaraNAya tasyAgamanArthaM vinayakaraNAya yihUdIyAn kiyataH prAcaH prESayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","tE yIzOrantikaM gatvA vinayAtizayaM vaktumArEbhirE, sa sEnApati rbhavatOnugrahaM prAptum arhati| ");
INSERT INTO sancol_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","yataH sOsmajjAtIyESu lOkESu prIyatE tathAsmatkRtE bhajanagEhaM nirmmitavAn| ");
INSERT INTO sancol_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","tasmAd yIzustaiH saha gatvA nivEzanasya samIpaM prApa, tadA sa zatasEnApati rvakSyamANavAkyaM taM vaktuM bandhUn prAhiNOt| hE prabhO svayaM zramO na karttavyO yad bhavatA madgEhamadhyE pAdArpaNaM kriyEta tadapyahaM nArhAmi, ");
INSERT INTO sancol_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","kinjcAhaM bhavatsamIpaM yAtumapi nAtmAnaM yOgyaM buddhavAn, tatO bhavAn vAkyamAtraM vadatu tEnaiva mama dAsaH svasthO bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","yasmAd ahaM parAdhInOpi mamAdhInA yAH sEnAH santi tAsAm EkajanaM prati yAhIti mayA prOktE sa yAti; tadanyaM prati AyAhIti prOktE sa AyAti; tathA nijadAsaM prati Etat kurvviti prOktE sa tadEva karOti| ");
INSERT INTO sancol_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","yIzuridaM vAkyaM zrutvA vismayaM yayau, mukhaM parAvartya pazcAdvarttinO lOkAn babhASE ca, yuSmAnahaM vadAmi isrAyElO vaMzamadhyEpi vizvAsamIdRzaM na prApnavaM| ");
INSERT INTO sancol_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","tatastE prESitA gRhaM gatvA taM pIPitaM dAsaM svasthaM dadRzuH| ");
INSERT INTO sancol_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","parE'hani sa nAyInAkhyaM nagaraM jagAma tasyAnEkE ziSyA anyE ca lOkAstEna sArddhaM yayuH| ");
INSERT INTO sancol_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","tESu tannagarasya dvArasannidhiM prAptESu kiyantO lOkA EkaM mRtamanujaM vahantO nagarasya bahiryAnti, sa tanmAturEkaputrastanmAtA ca vidhavA; tayA sArddhaM tannagarIyA bahavO lOkA Asan| ");
INSERT INTO sancol_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","prabhustAM vilOkya sAnukampaH kathayAmAsa, mA rOdIH| sa samIpamitvA khaTvAM pasparza tasmAd vAhakAH sthagitAstamyuH; ");
INSERT INTO sancol_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","tadA sa uvAca hE yuvamanuSya tvamuttiSTha, tvAmaham AjnjApayAmi| ");
INSERT INTO sancol_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","tasmAt sa mRtO janastatkSaNamutthAya kathAM prakathitaH; tatO yIzustasya mAtari taM samarpayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","tasmAt sarvvE lOkAH zazagkirE; EkO mahAbhaviSyadvAdI madhyE'smAkam samudait, Izvarazca svalOkAnanvagRhlAt kathAmimAM kathayitvA IzvaraM dhanyaM jagaduH| ");
INSERT INTO sancol_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","tataH paraM samastaM yihUdAdEzaM tasya caturdiksthadEzanjca tasyaitatkIrtti rvyAnazE| ");
INSERT INTO sancol_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","tataH paraM yOhanaH ziSyESu taM tadvRttAntaM jnjApitavatsu ");
INSERT INTO sancol_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","sa svaziSyANAM dvau janAvAhUya yIzuM prati vakSyamANaM vAkyaM vaktuM prESayAmAsa, yasyAgamanam apEkSya tiSThAmO vayaM kiM sa Eva janastvaM? kiM vayamanyamapEkSya sthAsyAmaH? ");
INSERT INTO sancol_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","pazcAttau mAnavau gatvA kathayAmAsatuH, yasyAgamanam apEkSya tiSThAmO vayaM, kiM saEva janastvaM? kiM vayamanyamapEkSya sthAsyAmaH? kathAmimAM tubhyaM kathayituM yOhan majjaka AvAM prESitavAn| ");
INSERT INTO sancol_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","tasmin daNPE yIzUrOgiNO mahAvyAdhimatO duSTabhUtagrastAMzca bahUn svasthAn kRtvA, anEkAndhEbhyazcakSuMSi dattvA pratyuvAca, ");
INSERT INTO sancol_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","yuvAM vrajatam andhA nEtrANi khanjjAzcaraNAni ca prApnuvanti, kuSThinaH pariSkriyantE, badhirAH zravaNAni mRtAzca jIvanAni prApnuvanti, daridrANAM samIpESu susaMvAdaH pracAryyatE, yaM prati vighnasvarUpOhaM na bhavAmi sa dhanyaH, ");
INSERT INTO sancol_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","EtAni yAni pazyathaH zRNuthazca tAni yOhanaM jnjApayatam| ");
INSERT INTO sancol_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","tayO rdUtayO rgatayOH satO ryOhani sa lOkAn vaktumupacakramE, yUyaM madhyEprAntaraM kiM draSTuM niragamata? kiM vAyunA kampitaM naPaM? ");
INSERT INTO sancol_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","yUyaM kiM draSTuM niragamata? kiM sUkSmavastraparidhAyinaM kamapi naraM? kintu yE sUkSmamRduvastrANi paridadhati sUttamAni dravyANi bhunjjatE ca tE rAjadhAnISu tiSThanti| ");
INSERT INTO sancol_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","tarhi yUyaM kiM draSTuM niragamata? kimEkaM bhaviSyadvAdinaM? tadEva satyaM kintu sa pumAn bhaviSyadvAdinOpi zrESTha ityahaM yuSmAn vadAmi; ");
INSERT INTO sancol_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","pazya svakIyadUtantu tavAgra prESayAmyahaM| gatvA tvadIyamArgantu sa hi pariSkariSyati| yadarthE lipiriyam AstE sa Eva yOhan| ");
INSERT INTO sancol_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","atO yuSmAnahaM vadAmi striyA garbbhajAtAnAM bhaviSyadvAdinAM madhyE yOhanO majjakAt zrESThaH kOpi nAsti, tatrApi Izvarasya rAjyE yaH sarvvasmAt kSudraH sa yOhanOpi zrESThaH| ");
INSERT INTO sancol_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","aparanjca sarvvE lOkAH karamanjcAyinazca tasya vAkyAni zrutvA yOhanA majjanEna majjitAH paramEzvaraM nirdOSaM mEnirE| ");
INSERT INTO sancol_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","kintu phirUzinO vyavasthApakAzca tEna na majjitAH svAn pratIzvarasyOpadEzaM niSphalam akurvvan| ");
INSERT INTO sancol_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","atha prabhuH kathayAmAsa, idAnIntanajanAn kEnOpamAmi? tE kasya sadRzAH? ");
INSERT INTO sancol_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","yE bAlakA vipaNyAm upavizya parasparam AhUya vAkyamidaM vadanti, vayaM yuSmAkaM nikaTE vaMzIravAdiSma, kintu yUyaM nAnarttiSTa, vayaM yuSmAkaM nikaTa arOdiSma, kintu yuyaM na vyalapiSTa, bAlakairEtAdRzaistESAm upamA bhavati| ");
INSERT INTO sancol_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","yatO yOhan majjaka Agatya pUpaM nAkhAdat drAkSArasanjca nApivat tasmAd yUyaM vadatha, bhUtagrastOyam| ");
INSERT INTO sancol_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","tataH paraM mAnavasuta AgatyAkhAdadapivanjca tasmAd yUyaM vadatha, khAdakaH surApazcANPAlapApinAM bandhurEkO janO dRzyatAm| ");
INSERT INTO sancol_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","kintu jnjAninO jnjAnaM nirdOSaM viduH| ");
INSERT INTO sancol_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","pazcAdEkaH phirUzI yIzuM bhOjanAya nyamantrayat tataH sa tasya gRhaM gatvA bhOktumupaviSTaH| ");
INSERT INTO sancol_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Etarhi tatphirUzinO gRhE yIzu rbhEktum upAvEkSIt tacchrutvA tannagaravAsinI kApi duSTA nArI pANParaprastarasya sampuTakE sugandhitailam AnIya ");
INSERT INTO sancol_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","tasya pazcAt pAdayOH sannidhau tasyau rudatI ca nEtrAmbubhistasya caraNau prakSAlya nijakacairamArkSIt, tatastasya caraNau cumbitvA tEna sugandhitailEna mamarda| ");
INSERT INTO sancol_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","tasmAt sa nimantrayitA phirUzI manasA cintayAmAsa, yadyayaM bhaviSyadvAdI bhavEt tarhi EnaM spRzati yA strI sA kA kIdRzI cEti jnjAtuM zaknuyAt yataH sA duSTA| ");
INSERT INTO sancol_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","tadA yAzustaM jagAda, hE zimOn tvAM prati mama kinjcid vaktavyamasti; tasmAt sa babhASE, hE gurO tad vadatu| ");
INSERT INTO sancol_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","EkOttamarNasya dvAvadhamarNAvAstAM, tayOrEkaH panjcazatAni mudrApAdAn aparazca panjcAzat mudrApAdAn dhArayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","tadanantaraM tayOH zOdhyAbhAvAt sa uttamarNastayO rRNE cakSamE; tasmAt tayOrdvayOH kastasmin prESyatE bahu? tad brUhi| ");
INSERT INTO sancol_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","zimOn pratyuvAca, mayA budhyatE yasyAdhikam RNaM cakSamE sa iti; tatO yIzustaM vyAjahAra, tvaM yathArthaM vyacArayaH| ");
INSERT INTO sancol_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","atha tAM nArIM prati vyAghuThya zimOnamavOcat, strImimAM pazyasi? tava gRhE mayyAgatE tvaM pAdaprakSAlanArthaM jalaM nAdAH kintu yOSidESA nayanajalai rmama pAdau prakSAlya kEzairamArkSIt| ");
INSERT INTO sancol_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","tvaM mAM nAcumbIH kintu yOSidESA svIyAgamanAdArabhya madIyapAdau cumbituM na vyaraMsta| ");
INSERT INTO sancol_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","tvanjca madIyOttamAggE kinjcidapi tailaM nAmardIH kintu yOSidESA mama caraNau sugandhitailEnAmarddIt| ");
INSERT INTO sancol_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","atastvAM vyAharAmi, EtasyA bahu pApamakSamyata tatO bahu prIyatE kintu yasyAlpapApaM kSamyatE sOlpaM prIyatE| ");
INSERT INTO sancol_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","tataH paraM sa tAM babhASE, tvadIyaM pApamakSamyata| ");
INSERT INTO sancol_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","tadA tEna sArddhaM yE bhOktum upavivizustE parasparaM vaktumArEbhirE, ayaM pApaM kSamatE ka ESaH? ");
INSERT INTO sancol_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","kintu sa tAM nArIM jagAda, tava vizvAsastvAM paryyatrAsta tvaM kSEmENa vraja| ");
INSERT INTO sancol_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","aparanjca yIzu rdvAdazabhiH ziSyaiH sArddhaM nAnAnagarESu nAnAgrAmESu ca gacchan izvarIyarAjatvasya susaMvAdaM pracArayituM prArEbhE| ");
INSERT INTO sancol_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","tadA yasyAH sapta bhUtA niragacchan sA magdalInIti vikhyAtA mariyam hErOdrAjasya gRhAdhipatEH hOSE rbhAryyA yOhanA zUzAnA ");
INSERT INTO sancol_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","prabhRtayO yA bahvyaH striyaH duSTabhUtEbhyO rOgEbhyazca muktAH satyO nijavibhUtI rvyayitvA tamasEvanta, tAH sarvvAstEna sArddham Asan| ");
INSERT INTO sancol_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","anantaraM nAnAnagarEbhyO bahavO lOkA Agatya tasya samIpE'milan, tadA sa tEbhya EkAM dRSTAntakathAM kathayAmAsa| EkaH kRSIbalO bIjAni vaptuM bahirjagAma, ");
INSERT INTO sancol_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","tatO vapanakAlE katipayAni bIjAni mArgapArzvE pEtuH, tatastAni padatalai rdalitAni pakSibhi rbhakSitAni ca| ");
INSERT INTO sancol_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","katipayAni bIjAni pASANasthalE patitAni yadyapi tAnyagkuritAni tathApi rasAbhAvAt zuzuSuH| ");
INSERT INTO sancol_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","katipayAni bIjAni kaNTakivanamadhyE patitAni tataH kaNTakivanAni saMvRddhya tAni jagrasuH| ");
INSERT INTO sancol_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","tadanyAni katipayabIjAni ca bhUmyAmuttamAyAM pEtustatastAnyagkurayitvA zataguNAni phalAni phEluH| sa imA kathAM kathayitvA prOccaiH prOvAca, yasya zrOtuM zrOtrE staH sa zRNOtu| ");
INSERT INTO sancol_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","tataH paraM ziSyAstaM papracchurasya dRSTAntasya kiM tAtparyyaM? ");
INSERT INTO sancol_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","tataH sa vyAjahAra, IzvarIyarAjyasya guhyAni jnjAtuM yuSmabhyamadhikArO dIyatE kintvanyE yathA dRSTvApi na pazyanti zrutvApi ma budhyantE ca tadarthaM tESAM purastAt tAH sarvvAH kathA dRSTAntEna kathyantE| ");
INSERT INTO sancol_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","dRSTAntasyAsyAbhiprAyaH, IzvarIyakathA bIjasvarUpA| ");
INSERT INTO sancol_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","yE kathAmAtraM zRNvanti kintu pazcAd vizvasya yathA paritrANaM na prApnuvanti tadAzayEna zaitAnEtya hRdayAtR tAM kathAm apaharati ta Eva mArgapArzvasthabhUmisvarUpAH| ");
INSERT INTO sancol_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","yE kathaM zrutvA sAnandaM gRhlanti kintvabaddhamUlatvAt svalpakAlamAtraM pratItya parIkSAkAlE bhrazyanti taEva pASANabhUmisvarUpAH| ");
INSERT INTO sancol_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","yE kathAM zrutvA yAnti viSayacintAyAM dhanalObhEna EेhikasukhE ca majjanta upayuktaphalAni na phalanti ta EvOptabIjakaNTakibhUsvarUpAH| ");
INSERT INTO sancol_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","kintu yE zrutvA saralaiH zuddhaizcAntaHkaraNaiH kathAM gRhlanti dhairyyam avalambya phalAnyutpAdayanti ca ta EvOttamamRtsvarUpAH| ");
INSERT INTO sancol_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","aparanjca pradIpaM prajvAlya kOpi pAtrENa nAcchAdayati tathA khaTvAdhOpi na sthApayati, kintu dIpAdhArOparyyEva sthApayati, tasmAt pravEzakA dIptiM pazyanti| ");
INSERT INTO sancol_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","yanna prakAzayiSyatE tAdRg aprakAzitaM vastu kimapi nAsti yacca na suvyaktaM pracArayiSyatE tAdRg gRptaM vastu kimapi nAsti| ");
INSERT INTO sancol_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","atO yUyaM kEna prakArENa zRNutha tatra sAvadhAnA bhavata, yasya samIpE barddhatE tasmai punardAsyatE kintu yasyAzrayE na barddhatE tasya yadyadasti tadapi tasmAt nESyatE| ");
INSERT INTO sancol_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","aparanjca yIzO rmAtA bhrAtarazca tasya samIpaM jigamiSavaH ");
INSERT INTO sancol_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","kintu janatAsambAdhAt tatsannidhiM prAptuM na zEkuH| tatpazcAt tava mAtA bhrAtarazca tvAM sAkSAt cikIrSantO bahistiSThanatIti vArttAyAM tasmai kathitAyAM ");
INSERT INTO sancol_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","sa pratyuvAca; yE janA Izvarasya kathAM zrutvA tadanurUpamAcaranti taEva mama mAtA bhrAtarazca| ");
INSERT INTO sancol_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","anantaraM EkadA yIzuH ziSyaiH sArddhaM nAvamAruhya jagAda, AyAta vayaM hradasya pAraM yAmaH, tatastE jagmuH| ");
INSERT INTO sancol_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","tESu naukAM vAhayatsu sa nidadrau; ");
INSERT INTO sancol_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","athAkasmAt prabalajhanjbhzagamAd hradE naukAyAM taraggairAcchannAyAM vipat tAn jagrAsa|tasmAd yIzOrantikaM gatvA hE gurO hE gurO prANA nO yAntIti gaditvA taM jAgarayAmbabhUvuH|tadA sa utthAya vAyuM taraggAMzca tarjayAmAsa tasmAdubhau nivRtya sthirau babhUvatuH| ");
INSERT INTO sancol_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","sa tAn babhASE yuSmAkaM vizvAsaH ka? tasmAttE bhItA vismitAzca parasparaM jagaduH, ahO kIdRgayaM manujaH pavanaM pAnIyanjcAdizati tadubhayaM tadAdEzaM vahati| ");
INSERT INTO sancol_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","tataH paraM gAlIlpradEzasya sammukhasthagidErIyapradEzE naukAyAM lagantyAM taTE'varOhamAvAd ");
INSERT INTO sancol_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","bahutithakAlaM bhUtagrasta EkO mAnuSaH purAdAgatya taM sAkSAccakAra| sa manuSO vAsO na paridadhat gRhE ca na vasan kEvalaM zmazAnam adhyuvAsa| ");
INSERT INTO sancol_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","sa yIzuM dRSTvaiva cIcchabdaM cakAra tasya sammukhE patitvA prOccairjagAda ca, hE sarvvapradhAnEzvarasya putra, mayA saha tava kaH sambandhaH? tvayi vinayaM karOmi mAM mA yAtaya| ");
INSERT INTO sancol_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","yataH sa taM mAnuSaM tyaktvA yAtum amEdhyabhUtam AdidEza; sa bhUtastaM mAnuSam asakRd dadhAra tasmAllOkAH zRgkhalEna nigaPEna ca babandhuH; sa tad bhaMktvA bhUtavazatvAt madhyEprAntaraM yayau| ");
INSERT INTO sancol_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","anantaraM yIzustaM papraccha tava kinnAma? sa uvAca, mama nAma bAhinO yatO bahavO bhUtAstamAzizriyuH| ");
INSERT INTO sancol_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","atha bhUtA vinayEna jagaduH, gabhIraM garttaM gantuM mAjnjApayAsmAn| ");
INSERT INTO sancol_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","tadA parvvatOpari varAhavrajazcarati tasmAd bhUtA vinayEna prOcuH, amuM varAhavrajam Azrayitum asmAn anujAnIhi; tataH sOnujajnjau| ");
INSERT INTO sancol_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","tataH paraM bhUtAstaM mAnuSaM vihAya varAhavrajam AzizriyuH varAhavrajAzca tatkSaNAt kaTakEna dhAvantO hradE prANAn vijRhuH| ");
INSERT INTO sancol_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","tad dRSTvA zUkararakSakAH palAyamAnA nagaraM grAmanjca gatvA tatsarvvavRttAntaM kathayAmAsuH| ");
INSERT INTO sancol_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","tataH kiM vRttam EtaddarzanArthaM lOkA nirgatya yIzOH samIpaM yayuH, taM mAnuSaM tyaktabhUtaM parihitavastraM svasthamAnuSavad yIzOzcaraNasannidhau sUpavizantaM vilOkya bibhyuH| ");
INSERT INTO sancol_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","yE lOkAstasya bhUtagrastasya svAsthyakaraNaM dadRzustE tEbhyaH sarvvavRttAntaM kathayAmAsuH| ");
INSERT INTO sancol_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","tadanantaraM tasya gidErIyapradEzasya caturdiksthA bahavO janA atitrastA vinayEna taM jagaduH, bhavAn asmAkaM nikaTAd vrajatu tasmAt sa nAvamAruhya tatO vyAghuTya jagAma| ");
INSERT INTO sancol_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","tadAnIM tyaktabhUtamanujastEna saha sthAtuM prArthayAnjcakrE ");
INSERT INTO sancol_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","kintu tadartham IzvaraH kIdRgmahAkarmma kRtavAn iti nivEzanaM gatvA vijnjApaya, yIzuH kathAmEtAM kathayitvA taM visasarja| tataH sa vrajitvA yIzustadarthaM yanmahAkarmma cakAra tat purasya sarvvatra prakAzayituM prArEbhE| ");
INSERT INTO sancol_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","atha yIzau parAvRtyAgatE lOkAstaM AdarENa jagRhu ryasmAttE sarvvE tamapEkSAnjcakrirE| ");
INSERT INTO sancol_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","tadanantaraM yAyIrnAmnO bhajanagEhasyaikOdhipa Agatya yIzOzcaraNayOH patitvA svanivEzanAgamanArthaM tasmin vinayaM cakAra, ");
INSERT INTO sancol_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","yatastasya dvAdazavarSavayaskA kanyaikAsIt sA mRtakalpAbhavat| tatastasya gamanakAlE mArgE lOkAnAM mahAn samAgamO babhUva| ");
INSERT INTO sancol_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","dvAdazavarSANi pradararOgagrastA nAnA vaidyaizcikitsitA sarvvasvaM vyayitvApi svAsthyaM na prAptA yA yOSit sA yIzOH pazcAdAgatya tasya vastragranthiM pasparza| ");
INSERT INTO sancol_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","tasmAt tatkSaNAt tasyA raktasrAvO ruddhaH| ");
INSERT INTO sancol_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","tadAnIM yIzuravadat kEnAhaM spRSTaH? tatO'nEkairanaggIkRtE pitarastasya sagginazcAvadan, hE gurO lOkA nikaTasthAH santastava dEhE gharSayanti, tathApi kEnAhaM spRSTa_iti bhavAn kutaH pRcchati? ");
INSERT INTO sancol_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","yIzuH kathayAmAsa, kEnApyahaM spRSTO, yatO mattaH zakti rnirgatEti mayA nizcitamajnjAyi| ");
INSERT INTO sancol_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","tadA sA nArI svayaM na guptEti viditvA kampamAnA satI tasya sammukhE papAta; yEna nimittEna taM pasparza sparzamAtrAcca yEna prakArENa svasthAbhavat tat sarvvaM tasya sAkSAdAcakhyau| ");
INSERT INTO sancol_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","tataH sa tAM jagAda hE kanyE susthirA bhava, tava vizvAsastvAM svasthAm akArSIt tvaM kSEmENa yAhi| ");
INSERT INTO sancol_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","yIzOrEtadvAkyavadanakAlE tasyAdhipatE rnivEzanAt kazcillOka Agatya taM babhASE, tava kanyA mRtA guruM mA klizAna| ");
INSERT INTO sancol_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","kintu yIzustadAkarNyAdhipatiM vyAjahAra, mA bhaiSIH kEvalaM vizvasihi tasmAt sA jIviSyati| ");
INSERT INTO sancol_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","atha tasya nivEzanE prAptE sa pitaraM yOhanaM yAkUbanjca kanyAyA mAtaraM pitaranjca vinA, anyaM kanjcana pravESTuM vArayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","aparanjca yE rudanti vilapanti ca tAn sarvvAn janAn uvAca, yUyaM mA rOdiSTa kanyA na mRtA nidrAti| ");
INSERT INTO sancol_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","kintu sA nizcitaM mRtEti jnjAtvA tE tamupajahasuH| ");
INSERT INTO sancol_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","pazcAt sa sarvvAn bahiH kRtvA kanyAyAH karau dhRtvAjuhuvE, hE kanyE tvamuttiSTha, ");
INSERT INTO sancol_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","tasmAt tasyAH prANESu punarAgatESu sA tatkSaNAd uttasyau| tadAnIM tasyai kinjcid bhakSyaM dAtum AdidEza| ");
INSERT INTO sancol_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","tatastasyAH pitarau vismayaM gatau kintu sa tAvAdidEza ghaTanAyA EtasyAH kathAM kasmaicidapi mA kathayataM| ");
INSERT INTO sancol_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","tataH paraM sa dvAdazaziSyAnAhUya bhUtAn tyAjayituM rOgAn pratikarttunjca tEbhyaH zaktimAdhipatyanjca dadau| ");
INSERT INTO sancol_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","aparanjca IzvarIyarAjyasya susaMvAdaM prakAzayitum rOgiNAmArOgyaM karttunjca prEraNakAlE tAn jagAda| ");
INSERT INTO sancol_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","yAtrArthaM yaSTi rvastrapuTakaM bhakSyaM mudrA dvitIyavastram, ESAM kimapi mA gRhlIta| ");
INSERT INTO sancol_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","yUyanjca yannivEzanaM pravizatha nagaratyAgaparyyanataM tannivEzanE tiSThata| ");
INSERT INTO sancol_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","tatra yadi kasyacit purasya lOkA yuSmAkamAtithyaM na kurvvanti tarhi tasmAnnagarAd gamanakAlE tESAM viruddhaM sAkSyArthaM yuSmAkaM padadhUlIH sampAtayata| ");
INSERT INTO sancol_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","atha tE prasthAya sarvvatra susaMvAdaM pracArayituM pIPitAn svasthAn karttunjca grAmESu bhramituM prArEbhirE| ");
INSERT INTO sancol_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Etarhi hErOd rAjA yIzOH sarvvakarmmaNAM vArttAM zrutvA bhRzamudvivijE ");
INSERT INTO sancol_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","yataH kEcidUcuryOhan zmazAnAdudatiSThat| kEcidUcuH, EliyO darzanaM dattavAn; EvamanyalOkA UcuH pUrvvIyaH kazcid bhaviSyadvAdI samutthitaH| ");
INSERT INTO sancol_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","kintu hErOduvAca yOhanaH zirO'hamachinadam idAnIM yasyEdRkkarmmaNAM vArttAM prApnOmi sa kaH? atha sa taM draSTum aicchat| ");
INSERT INTO sancol_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","anantaraM prEritAH pratyAgatya yAni yAni karmmANi cakrustAni yIzavE kathayAmAsuH tataH sa tAn baitsaidAnAmakanagarasya vijanaM sthAnaM nItvA guptaM jagAma| ");
INSERT INTO sancol_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","pazcAl lOkAstad viditvA tasya pazcAd yayuH; tataH sa tAn nayan IzvarIyarAjyasya prasaggamuktavAn, yESAM cikitsayA prayOjanam AsIt tAn svasthAn cakAra ca| ");
INSERT INTO sancol_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","aparanjca divAvasannE sati dvAdazaziSyA yIzOrantikam Etya kathayAmAsuH, vayamatra prAntarasthAnE tiSThAmaH, tatO nagarANi grAmANi gatvA vAsasthAnAni prApya bhakSyadravyANi krEtuM jananivahaM bhavAn visRjatu| ");
INSERT INTO sancol_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","tadA sa uvAca, yUyamEva tAn bhEjayadhvaM; tatastE prOcurasmAkaM nikaTE kEvalaM panjca pUpA dvau matsyau ca vidyantE, ataEva sthAnAntaram itvA nimittamEtESAM bhakSyadravyESu na krItESu na bhavati| ");
INSERT INTO sancol_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","tatra prAyENa panjcasahasrANi puruSA Asan| ");
INSERT INTO sancol_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","tadA sa ziSyAn jagAda panjcAzat panjcAzajjanaiH paMktIkRtya tAnupavEzayata, tasmAt tE tadanusArENa sarvvalOkAnupavEzayApAsuH| ");
INSERT INTO sancol_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","tataH sa tAn panjca pUpAn mInadvayanjca gRhItvA svargaM vilOkyEzvaraguNAn kIrttayAnjcakrE bhagktA ca lOkEbhyaH parivESaNArthaM ziSyESu samarpayAmbabhUva| ");
INSERT INTO sancol_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","tataH sarvvE bhuktvA tRptiM gatA avaziSTAnAnjca dvAdaza PallakAn saMjagRhuH| ");
INSERT INTO sancol_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","athaikadA nirjanE ziSyaiH saha prArthanAkAlE tAn papraccha, lOkA mAM kaM vadanti? ");
INSERT INTO sancol_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","tatastE prAcuH, tvAM yOhanmajjakaM vadanti; kEcit tvAm EliyaM vadanti, pUrvvakAlikaH kazcid bhaviSyadvAdI zmazAnAd udatiSThad ityapi kEcid vadanti| ");
INSERT INTO sancol_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","tadA sa uvAca, yUyaM mAM kaM vadatha? tataH pitara uktavAn tvam IzvarAbhiSiktaH puruSaH| ");
INSERT INTO sancol_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","tadA sa tAn dRPhamAdidEza, kathAmEtAM kasmaicidapi mA kathayata| ");
INSERT INTO sancol_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","sa punaruvAca, manuSyaputrENa vahuyAtanA bhOktavyAH prAcInalOkaiH pradhAnayAjakairadhyApakaizca sOvajnjAya hantavyaH kintu tRtIyadivasE zmazAnAt tEnOtthAtavyam| ");
INSERT INTO sancol_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","aparaM sa sarvvAnuvAca, kazcid yadi mama pazcAd gantuM vAnjchati tarhi sa svaM dAmyatu, dinE dinE kruzaM gRhItvA ca mama pazcAdAgacchatu| ");
INSERT INTO sancol_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","yatO yaH kazcit svaprANAn rirakSiSati sa tAn hArayiSyati, yaH kazcin madarthaM prANAn hArayiSyati sa tAn rakSiSyati| ");
INSERT INTO sancol_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","kazcid yadi sarvvaM jagat prApnOti kintu svaprANAn hArayati svayaM vinazyati ca tarhi tasya kO lAbhaH? ");
INSERT INTO sancol_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","puna ryaH kazcin mAM mama vAkyaM vA lajjAspadaM jAnAti manuSyaputrO yadA svasya pituzca pavitrANAM dUtAnAnjca tEjObhiH parivESTita AgamiSyati tadA sOpi taM lajjAspadaM jnjAsyati| ");
INSERT INTO sancol_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","kintu yuSmAnahaM yathArthaM vadAmi, IzvarIyarAjatvaM na dRSTavA mRtyuM nAsvAdiSyantE, EtAdRzAH kiyantO lOkA atra sthanE'pi daNPAyamAnAH santi| ");
INSERT INTO sancol_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","EtadAkhyAnakathanAt paraM prAyENASTasu dinESu gatESu sa pitaraM yOhanaM yAkUbanjca gRhItvA prArthayituM parvvatamEkaM samArurOha| ");
INSERT INTO sancol_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","atha tasya prArthanakAlE tasya mukhAkRtiranyarUpA jAtA, tadIyaM vastramujjvalazuklaM jAtaM| ");
INSERT INTO sancol_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","aparanjca mUsA EliyazcObhau tEjasvinau dRSTau ");
INSERT INTO sancol_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","tau tEna yirUzAlampurE yO mRtyuH sAdhiSyatE tadIyAM kathAM tEna sArddhaM kathayitum ArEbhAtE| ");
INSERT INTO sancol_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","tadA pitarAdayaH svasya sagginO nidrayAkRSTA Asan kintu jAgaritvA tasya tEjastEna sArddham uttiSThantau janau ca dadRzuH| ");
INSERT INTO sancol_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","atha tayOrubhayO rgamanakAlE pitarO yIzuM babhASE, hE gurO'smAkaM sthAnE'smin sthitiH zubhA, tata EkA tvadarthA, EkA mUsArthA, EkA EliyArthA, iti tisraH kuTyOsmAbhi rnirmmIyantAM, imAM kathAM sa na vivicya kathayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","aparanjca tadvAkyavadanakAlE payOda Eka Agatya tESAmupari chAyAM cakAra, tatastanmadhyE tayOH pravEzAt tE zazagkirE| ");
INSERT INTO sancol_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","tadA tasmAt payOdAd iyamAkAzIyA vANI nirjagAma, mamAyaM priyaH putra Etasya kathAyAM manO nidhatta| ");
INSERT INTO sancol_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","iti zabdE jAtE tE yIzumEkAkinaM dadRzuH kintu tE tadAnIM tasya darzanasya vAcamEkAmapi nOktvA manaHsu sthApayAmAsuH| ");
INSERT INTO sancol_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","parE'hani tESu tasmAcchailAd avarUPhESu taM sAkSAt karttuM bahavO lOkA AjagmuH| ");
INSERT INTO sancol_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","tESAM madhyAd EkO jana uccairuvAca, hE gurO ahaM vinayaM karOmi mama putraM prati kRpAdRSTiM karOtu, mama sa EvaikaH putraH| ");
INSERT INTO sancol_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","bhUtEna dhRtaH san saM prasabhaM cIcchabdaM karOti tanmukhAt phENA nirgacchanti ca, bhUta itthaM vidAryya kliSTvA prAyazastaM na tyajati| ");
INSERT INTO sancol_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","tasmAt taM bhUtaM tyAjayituM tava ziSyasamIpE nyavEdayaM kintu tE na zEkuH| ");
INSERT INTO sancol_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","tadA yIzuravAdIt, rE AvizvAsin vipathagAmin vaMza katikAlAn yuSmAbhiH saha sthAsyAmyahaM yuSmAkam AcaraNAni ca sahiSyE? tava putramihAnaya| ");
INSERT INTO sancol_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","tatastasminnAgatamAtrE bhUtastaM bhUmau pAtayitvA vidadAra; tadA yIzustamamEdhyaM bhUtaM tarjayitvA bAlakaM svasthaM kRtvA tasya pitari samarpayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Izvarasya mahAzaktim imAM vilOkya sarvvE camaccakruH; itthaM yIzOH sarvvAbhiH kriyAbhiH sarvvairlOkairAzcaryyE manyamAnE sati sa ziSyAn babhASE, ");
INSERT INTO sancol_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","kathEyaM yuSmAkaM karNESu pravizatu, manuSyaputrO manuSyANAM karESu samarpayiSyatE| ");
INSERT INTO sancol_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","kintu tE tAM kathAM na bubudhirE, spaSTatvAbhAvAt tasyA abhiprAyastESAM bOdhagamyO na babhUva; tasyA AzayaH ka ityapi tE bhayAt praSTuM na zEkuH| ");
INSERT INTO sancol_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","tadanantaraM tESAM madhyE kaH zrESThaH kathAmEtAM gRhItvA tE mithO vivAdaM cakruH| ");
INSERT INTO sancol_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","tatO yIzustESAM manObhiprAyaM viditvA bAlakamEkaM gRhItvA svasya nikaTE sthApayitvA tAn jagAda, ");
INSERT INTO sancol_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","yO janO mama nAmnAsya bAlAsyAtithyaM vidadhAti sa mamAtithyaM vidadhAti, yazca mamAtithyaM vidadhAti sa mama prErakasyAtithyaM vidadhAti, yuSmAkaM madhyEyaH svaM sarvvasmAt kSudraM jAnItE sa Eva zrESThO bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","aparanjca yOhan vyAjahAra hE prabhEा tava nAmnA bhUtAn tyAjayantaM mAnuSam EkaM dRSTavantO vayaM, kintvasmAkam apazcAd gAmitvAt taM nyaSEdhAm| tadAnIM yIzuruvAca, ");
INSERT INTO sancol_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","taM mA niSEdhata, yatO yO janOsmAkaM na vipakSaH sa EvAsmAkaM sapakSO bhavati| ");
INSERT INTO sancol_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","anantaraM tasyArOhaNasamaya upasthitE sa sthiracEtA yirUzAlamaM prati yAtrAM karttuM nizcityAgrE dUtAn prESayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","tasmAt tE gatvA tasya prayOjanIyadravyANi saMgrahItuM zOmirONIyAnAM grAmaM pravivizuH| ");
INSERT INTO sancol_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","kintu sa yirUzAlamaM nagaraM yAti tatO hEtO rlOkAstasyAtithyaM na cakruH| ");
INSERT INTO sancol_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ataEva yAkUbyOhanau tasya ziSyau tad dRSTvA jagadatuH, hE prabhO EliyO yathA cakAra tathA vayamapi kiM gagaNAd Agantum EtAn bhasmIkarttunjca vahnimAjnjApayAmaH? bhavAn kimicchati? ");
INSERT INTO sancol_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","kintu sa mukhaM parAvartya tAn tarjayitvA gaditavAn yuSmAkaM manObhAvaH kaH, iti yUyaM na jAnItha| ");
INSERT INTO sancol_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","manujasutO manujAnAM prANAn nAzayituM nAgacchat, kintu rakSitum Agacchat| pazcAd itaragrAmaM tE yayuH| ");
INSERT INTO sancol_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","tadanantaraM pathi gamanakAlE jana EkastaM babhASE, hE prabhO bhavAn yatra yAti bhavatA sahAhamapi tatra yAsyAmi| ");
INSERT INTO sancol_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","tadAnIM yIzustamuvAca, gOmAyUnAM garttA AsatE, vihAyasIyavihagAाnAM nIPAni ca santi, kintu mAnavatanayasya ziraH sthApayituM sthAnaM nAsti| ");
INSERT INTO sancol_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","tataH paraM sa itarajanaM jagAda, tvaM mama pazcAd Ehi; tataH sa uvAca, hE prabhO pUrvvaM pitaraM zmazAnE sthApayituM mAmAdizatu| ");
INSERT INTO sancol_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","tadA yIzuruvAca, mRtA mRtAn zmazAnE sthApayantu kintu tvaM gatvEzvarIyarAjyasya kathAM pracAraya| ");
INSERT INTO sancol_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","tatOnyaH kathayAmAsa, hE prabhO mayApi bhavataH pazcAd gaMsyatE, kintu pUrvvaM mama nivEzanasya parijanAnAm anumatiM grahItum ahamAdizyai bhavatA| ");
INSERT INTO sancol_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","tadAnIM yIzustaM prOktavAn, yO janO lAggalE karamarpayitvA pazcAt pazyati sa IzvarIyarAjyaM nArhati| ");
INSERT INTO sancol_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","tataH paraM prabhuraparAn saptatiziSyAn niyujya svayaM yAni nagarANi yAni sthAnAni ca gamiSyati tAni nagarANi tAni sthAnAni ca prati dvau dvau janau prahitavAn| ");
INSERT INTO sancol_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","tEbhyaH kathayAmAsa ca zasyAni bahUnIti satyaM kintu chEdakA alpE; tasmAddhEtOH zasyakSEtrE chEdakAn aparAnapi prESayituM kSEtrasvAminaM prArthayadhvaM| ");
INSERT INTO sancol_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","yUyaM yAta, pazyata, vRkANAM madhyE mESazAvakAniva yuSmAn prahiNOmi| ");
INSERT INTO sancol_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","yUyaM kSudraM mahad vA vasanasampuTakaM pAdukAzca mA gRhlIta, mArgamadhyE kamapi mA namata ca| ");
INSERT INTO sancol_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","aparanjca yUyaM yad yat nivEzanaM pravizatha tatra nivEzanasyAsya maggalaM bhUyAditi vAkyaM prathamaM vadata| ");
INSERT INTO sancol_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","tasmAt tasmin nivEzanE yadi maggalapAtraM sthAsyati tarhi tanmaggalaM tasya bhaviSyati, nOcEt yuSmAn prati parAvarttiSyatE| ");
INSERT INTO sancol_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","aparanjca tE yatkinjcid dAsyanti tadEva bhuktvA pItvA tasminnivEzanE sthAsyatha; yataH karmmakArI janO bhRtim arhati; gRhAd gRhaM mA yAsyatha| ");
INSERT INTO sancol_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","anyacca yuSmAsu kimapi nagaraM praviSTESu lOkA yadi yuSmAkam AtithyaM kariSyanti, tarhi yat khAdyam upasthAsyanti tadEva khAdiSyatha| ");
INSERT INTO sancol_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","tannagarasthAn rOgiNaH svasthAn kariSyatha, IzvarIyaM rAjyaM yuSmAkam antikam Agamat kathAmEtAnjca pracArayiSyatha| ");
INSERT INTO sancol_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","kintu kimapi puraM yuSmAsu praviSTESu lOkA yadi yuSmAkam AtithyaM na kariSyanti, tarhi tasya nagarasya panthAnaM gatvA kathAmEtAM vadiSyatha, ");
INSERT INTO sancol_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","yuSmAkaM nagarIyA yA dhUlyO'smAsu samalagan tA api yuSmAkaM prAtikUlyEna sAkSyArthaM sampAtayAmaH; tathApIzvararAjyaM yuSmAkaM samIpam Agatam iti nizcitaM jAnIta| ");
INSERT INTO sancol_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","ahaM yuSmabhyaM yathArthaM kathayAmi, vicAradinE tasya nagarasya dazAtaH sidOmO dazA sahyA bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","hA hA kOrAsIn nagara, hA hA baitsaidAnagara yuvayOrmadhyE yAdRzAni AzcaryyANi karmmANyakriyanta, tAni karmmANi yadi sOrasIdOnO rnagarayOrakAriSyanta, tadA itO bahudinapUrvvaM tannivAsinaH zaNavastrANi paridhAya gAtrESu bhasma vilipya samupavizya samakhEtsyanta| ");
INSERT INTO sancol_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","atO vicAradivasE yuSmAkaM dazAtaH sOrasIdOnnivAsinAM dazA sahyA bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","hE kapharnAhUm, tvaM svargaM yAvad unnatA kintu narakaM yAvat nyagbhaviSyasi| ");
INSERT INTO sancol_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","yO janO yuSmAkaM vAkyaM gRhlAti sa mamaiva vAkyaM gRhlAti; kinjca yO janO yuSmAkam avajnjAM karOti sa mamaivAvajnjAM karOti; yO janO mamAvajnjAM karOti ca sa matprErakasyaivAvajnjAM karOti| ");
INSERT INTO sancol_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","atha tE saptatiziSyA AnandEna pratyAgatya kathayAmAsuH, hE prabhO bhavatO nAmnA bhUtA apyasmAkaM vazIbhavanti| ");
INSERT INTO sancol_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","tadAnIM sa tAn jagAda, vidyutamiva svargAt patantaM zaitAnam adarzam| ");
INSERT INTO sancol_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","pazyata sarpAn vRzcikAn ripOH sarvvaparAkramAMzca padatalai rdalayituM yuSmabhyaM zaktiM dadAmi tasmAd yuSmAkaM kApi hAni rna bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","bhUtA yuSmAkaM vazIbhavanti, Etannimittat mA samullasata, svargE yuSmAkaM nAmAni likhitAni santIti nimittaM samullasata| ");
INSERT INTO sancol_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","tadghaTikAyAM yIzu rmanasi jAtAhlAdaH kathayAmAsa hE svargapRthivyOrEkAdhipatE pitastvaM jnjAnavatAM viduSAnjca lOkAnAM purastAt sarvvamEtad aprakAzya bAlakAnAM purastAt prAkAzaya EtasmAddhEtOstvAM dhanyaM vadAmi, hE pitaritthaM bhavatu yad EtadEva tava gOcara uttamam| ");
INSERT INTO sancol_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","pitrA sarvvANi mayi samarpitAni pitaraM vinA kOpi putraM na jAnAti kinjca putraM vinA yasmai janAya putrastaM prakAzitavAn tanjca vinA kOpi pitaraM na jAnAti| ");
INSERT INTO sancol_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","tapaH paraM sa ziSyAn prati parAvRtya guptaM jagAda, yUyamEtAni sarvvANi pazyatha tatO yuSmAkaM cakSUMSi dhanyAni| ");
INSERT INTO sancol_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","yuSmAnahaM vadAmi, yUyaM yAni sarvvANi pazyatha tAni bahavO bhaviSyadvAdinO bhUpatayazca draSTumicchantOpi draSTuM na prApnuvan, yuSmAbhi ryA yAH kathAzca zrUyantE tAH zrOtumicchantOpi zrOtuM nAlabhanta| ");
INSERT INTO sancol_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","anantaram EkO vyavasthApaka utthAya taM parIkSituM papraccha, hE upadEzaka anantAyuSaH prAptayE mayA kiM karaNIyaM? ");
INSERT INTO sancol_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","yIzuH pratyuvAca, atrArthE vyavasthAyAM kiM likhitamasti? tvaM kIdRk paThasi? ");
INSERT INTO sancol_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","tataH sOvadat, tvaM sarvvAntaHkaraNaiH sarvvaprANaiH sarvvazaktibhiH sarvvacittaizca prabhau paramEzvarE prEma kuru, samIpavAsini svavat prEma kuru ca| ");
INSERT INTO sancol_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","tadA sa kathayAmAsa, tvaM yathArthaM pratyavOcaH, ittham Acara tEnaiva jIviSyasi| ");
INSERT INTO sancol_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","kintu sa janaH svaM nirddOSaM jnjApayituM yIzuM papraccha, mama samIpavAsI kaH? tatO yIzuH pratyuvAca, ");
INSERT INTO sancol_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","EkO janO yirUzAlampurAd yirIhOpuraM yAti, Etarhi dasyUnAM karESu patitE tE tasya vastrAdikaM hRtavantaH tamAhatya mRtaprAyaM kRtvA tyaktvA yayuH| ");
INSERT INTO sancol_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","akasmAd EkO yAjakastEna mArgENa gacchan taM dRSTvA mArgAnyapArzvEna jagAma| ");
INSERT INTO sancol_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ittham EkO lEvIyastatsthAnaM prApya tasyAntikaM gatvA taM vilOkyAnyEna pArzvEna jagAma| ");
INSERT INTO sancol_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","kintvEkaH zOmirONIyO gacchan tatsthAnaM prApya taM dRSTvAdayata| ");
INSERT INTO sancol_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","tasyAntikaM gatvA tasya kSatESu tailaM drAkSArasanjca prakSipya kSatAni baddhvA nijavAhanOpari tamupavEzya pravAsIyagRham AnIya taM siSEvE| ");
INSERT INTO sancol_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","parasmin divasE nijagamanakAlE dvau mudrApAdau tadgRhasvAminE dattvAvadat janamEnaM sEvasva tatra yO'dhikO vyayO bhaviSyati tamahaM punarAgamanakAlE parizOtsyAmi| ");
INSERT INTO sancol_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","ESAM trayANAM madhyE tasya dasyuhastapatitasya janasya samIpavAsI kaH? tvayA kiM budhyatE? ");
INSERT INTO sancol_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","tataH sa vyavasthApakaH kathayAmAsa yastasmin dayAM cakAra| tadA yIzuH kathayAmAsa tvamapi gatvA tathAcara| ");
INSERT INTO sancol_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","tataH paraM tE gacchanta EkaM grAmaM pravivizuH; tadA marthAnAmA strI svagRhE tasyAtithyaM cakAra| ");
INSERT INTO sancol_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","tasmAt mariyam nAmadhEyA tasyA bhaginI yIzOH padasamIpa uvavizya tasyOpadEzakathAM zrOtumArEbhE| ");
INSERT INTO sancol_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","kintu marthA nAnAparicaryyAyAM vyagrA babhUva tasmAddhEtOstasya samIpamAgatya babhASE; hE prabhO mama bhaginI kEvalaM mamOpari sarvvakarmmaNAM bhAram arpitavatI tatra bhavatA kinjcidapi na manO nidhIyatE kim? mama sAhAyyaM karttuM bhavAn tAmAdizatu| ");
INSERT INTO sancol_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","tatO yIzuH pratyuvAca hE marthE hE marthE, tvaM nAnAkAryyESu cintitavatI vyagrA cAsi, ");
INSERT INTO sancol_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","kintu prayOjanIyam EkamAtram AstE| aparanjca yamuttamaM bhAgaM kOpi harttuM na zaknOti saEva mariyamA vRtaH| ");
INSERT INTO sancol_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","anantaraM sa kasmiMzcit sthAnE prArthayata tatsamAptau satyAM tasyaikaH ziSyastaM jagAda hE prabhO yOhan yathA svaziSyAn prArthayitum upadiSTavAn tathA bhavAnapyasmAn upadizatu| ");
INSERT INTO sancol_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","tasmAt sa kathayAmAsa, prArthanakAlE yUyam itthaM kathayadhvaM, hE asmAkaM svargasthapitastava nAma pUjyaM bhavatu; tava rAjatvaM bhavatu; svargE yathA tathA pRthivyAmapi tavEcchayA sarvvaM bhavatu| ");
INSERT INTO sancol_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","pratyaham asmAkaM prayOjanIyaM bhOjyaM dEhi| ");
INSERT INTO sancol_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","yathA vayaM sarvvAn aparAdhinaH kSamAmahE tathA tvamapi pApAnyasmAkaM kSamasva| asmAn parIkSAM mAnaya kintu pApAtmanO rakSa| ");
INSERT INTO sancol_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","pazcAt sOparamapi kathitavAn yadi yuSmAkaM kasyacid bandhustiSThati nizIthE ca tasya samIpaM sa gatvA vadati, ");
INSERT INTO sancol_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","hE bandhO pathika EkO bandhu rmama nivEzanam AyAtaH kintu tasyAtithyaM karttuM mamAntikE kimapi nAsti, ataEva pUpatrayaM mahyam RNaM dEhi; ");
INSERT INTO sancol_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","tadA sa yadi gRhamadhyAt prativadati mAM mA klizAna, idAnIM dvAraM ruddhaM zayanE mayA saha bAlakAzca tiSThanti tubhyaM dAtum utthAtuM na zaknOmi, ");
INSERT INTO sancol_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","tarhi yuSmAnahaM vadAmi, sa yadi mitratayA tasmai kimapi dAtuM nOttiSThati tathApi vAraM vAraM prArthanAta utthApitaH san yasmin tasya prayOjanaM tadEva dAsyati| ");
INSERT INTO sancol_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","ataH kAraNAt kathayAmi, yAcadhvaM tatO yuSmabhyaM dAsyatE, mRgayadhvaM tata uddEzaM prApsyatha, dvAram Ahata tatO yuSmabhyaM dvAraM mOkSyatE| ");
INSERT INTO sancol_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","yO yAcatE sa prApnOti, yO mRgayatE sa EvOddEzaM prApnOti, yO dvAram Ahanti tadarthaM dvAraM mOcyatE| ");
INSERT INTO sancol_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","putrENa pUpE yAcitE tasmai pASANaM dadAti vA matsyE yAcitE tasmai sarpaM dadAti ");
INSERT INTO sancol_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","vA aNPE yAcitE tasmai vRzcikaM dadAti yuSmAkaM madhyE ka EtAdRzaH pitAstE? ");
INSERT INTO sancol_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","tasmAdEva yUyamabhadrA api yadi svasvabAlakEbhya uttamAni dravyANi dAtuM jAnItha tarhyasmAkaM svargasthaH pitA nijayAcakEbhyaH kiM pavitram AtmAnaM na dAsyati? ");
INSERT INTO sancol_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","anantaraM yIzunA kasmAccid Ekasmin mUkabhUtE tyAjitE sati sa bhUtatyaktO mAnuSO vAkyaM vaktum ArEbhE; tatO lOkAH sakalA AzcaryyaM mEnirE| ");
INSERT INTO sancol_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","kintu tESAM kEcidUcu rjanOyaM bAlasibUbA arthAd bhUtarAjEna bhUtAn tyAjayati| ");
INSERT INTO sancol_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","taM parIkSituM kEcid AkAzIyam EkaM cihnaM darzayituM taM prArthayAnjcakrirE| ");
INSERT INTO sancol_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","tadA sa tESAM manaHkalpanAM jnjAtvA kathayAmAsa, kasyacid rAjyasya lOkA yadi parasparaM virundhanti tarhi tad rAjyam nazyati; kEcid gRhasthA yadi parasparaM virundhanti tarhi tEpi nazyanti| ");
INSERT INTO sancol_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","tathaiva zaitAnapi svalOkAn yadi viruNaddhi tadA tasya rAjyaM kathaM sthAsyati? bAlasibUbAhaM bhUtAn tyAjayAmi yUyamiti vadatha| ");
INSERT INTO sancol_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","yadyahaM bAlasibUbA bhUtAn tyAjayAmi tarhi yuSmAkaM santAnAH kEna tyAjayanti? tasmAt taEva kathAyA EtasyA vicArayitArO bhaviSyanti| ");
INSERT INTO sancol_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","kintu yadyaham Izvarasya parAkramENa bhUtAn tyAjayAmi tarhi yuSmAkaM nikaTam Izvarasya rAjyamavazyam upatiSThati| ");
INSERT INTO sancol_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","balavAn pumAn susajjamAnO yatikAlaM nijATTAlikAM rakSati tatikAlaM tasya dravyaM nirupadravaM tiSThati| ");
INSERT INTO sancol_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","kintu tasmAd adhikabalaH kazcidAgatya yadi taM jayati tarhi yESu zastrAstrESu tasya vizvAsa AsIt tAni sarvvANi hRtvA tasya dravyANi gRhlAti| ");
INSERT INTO sancol_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","ataH kAraNAd yO mama sapakSO na sa vipakSaH, yO mayA saha na saMgRhlAti sa vikirati| ");
INSERT INTO sancol_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","aparanjca amEdhyabhUtO mAnuSasyAntarnirgatya zuSkasthAnE bhrAntvA vizrAmaM mRgayatE kintu na prApya vadati mama yasmAd gRhAd AgatOhaM punastad gRhaM parAvRtya yAmi| ");
INSERT INTO sancol_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","tatO gatvA tad gRhaM mArjitaM zObhitanjca dRSTvA ");
INSERT INTO sancol_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","tatkSaNam apagatya svasmAdapi durmmatIn aparAn saptabhUtAn sahAnayati tE ca tadgRhaM pavizya nivasanti| tasmAt tasya manuSyasya prathamadazAtaH zESadazA duHkhatarA bhavati| ");
INSERT INTO sancol_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","asyAH kathAyAH kathanakAlE janatAmadhyasthA kAcinnArI tamuccaiHsvaraM prOvAca, yA yOSit tvAM garbbhE'dhArayat stanyamapAyayacca saiva dhanyA| ");
INSERT INTO sancol_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","kintu sOkathayat yE paramEzvarasya kathAM zrutvA tadanurUpam Acaranti taEva dhanyAH| ");
INSERT INTO sancol_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","tataH paraM tasyAntikE bahulOkAnAM samAgamE jAtE sa vaktumArEbhE, AdhunikA duSTalOkAzcihnaM draSTumicchanti kintu yUnasbhaviSyadvAdinazcihnaM vinAnyat kinjciccihnaM tAn na darzayiSyatE| ");
INSERT INTO sancol_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","yUnas tu yathA nInivIyalOkAnAM samIpE cihnarUpObhavat tathA vidyamAnalOkAnAm ESAM samIpE manuSyaputrOpi cihnarUpO bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","vicArasamayE idAnIntanalOkAnAM prAtikUlyEna dakSiNadEzIyA rAjnjI prOtthAya tAn dOSiNaH kariSyati, yataH sA rAjnjI sulEmAna upadEzakathAM zrOtuM pRthivyAH sImAta Agacchat kintu pazyata sulEmAnOpi gurutara EkO janO'smin sthAnE vidyatE| ");
INSERT INTO sancol_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","aparanjca vicArasamayE nInivIyalOkA api varttamAnakAlikAnAM lOkAnAM vaiparItyEna prOtthAya tAn dOSiNaH kariSyanti, yatO hEtOstE yUnasO vAkyAt cittAni parivarttayAmAsuH kintu pazyata yUnasOtigurutara EkO janO'smin sthAnE vidyatE| ");
INSERT INTO sancol_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","pradIpaM prajvAlya drONasyAdhaH kutrApi guptasthAnE vA kOpi na sthApayati kintu gRhapravEzibhyO dIptiM dAtaM dIpAdhArOparyyEva sthApayati| ");
INSERT INTO sancol_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","dEhasya pradIpazcakSustasmAdEva cakSu ryadi prasannaM bhavati tarhi tava sarvvazarIraM dIptimad bhaviSyati kintu cakSu ryadi malImasaM tiSThati tarhi sarvvazarIraM sAndhakAraM sthAsyati| ");
INSERT INTO sancol_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","asmAt kAraNAt tavAntaHsthaM jyOti ryathAndhakAramayaM na bhavati tadarthE sAvadhAnO bhava| ");
INSERT INTO sancol_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","yataH zarIrasya kutrApyaMzE sAndhakArE na jAtE sarvvaM yadi dIptimat tiSThati tarhi tubhyaM dIptidAyiprOjjvalan pradIpa iva tava savarvazarIraM dIptimad bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","EtatkathAyAH kathanakAlE phiruzyEkO bhEjanAya taM nimantrayAmAsa, tataH sa gatvA bhOktum upavivEza| ");
INSERT INTO sancol_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","kintu bhOjanAt pUrvvaM nAmAgkSIt Etad dRSTvA sa phiruzyAzcaryyaM mEnE| ");
INSERT INTO sancol_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","tadA prabhustaM prOvAca yUyaM phirUzilOkAH pAnapAtrANAM bhOjanapAtrANAnjca bahiH pariSkurutha kintu yuSmAkamanta rdaurAtmyai rduSkriyAbhizca paripUrNaM tiSThati| ");
INSERT INTO sancol_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","hE sarvvE nirbOdhA yO bahiH sasarja sa Eva kimanta rna sasarja? ");
INSERT INTO sancol_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","tata Eva yuSmAbhirantaHkaraNaM (IzvarAya) nivEdyatAM tasmin kRtE yuSmAkaM sarvvANi zucitAM yAsyanti| ");
INSERT INTO sancol_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","kintu hanta phirUzigaNA yUyaM nyAyam IzvarE prEma ca parityajya pOdinAyA arudAdInAM sarvvESAM zAkAnAnjca dazamAMzAn dattha kintu prathamaM pAlayitvA zESasyAlagghanaM yuSmAkam ucitamAsIt| ");
INSERT INTO sancol_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","hA hA phirUzinO yUyaM bhajanagEhE prOccAsanE ApaNESu ca namaskArESu prIyadhvE| ");
INSERT INTO sancol_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","vata kapaTinO'dhyApakAH phirUzinazca lOkAyat zmazAnam anupalabhya tadupari gacchanti yUyam tAdRgaprakAzitazmazAnavAd bhavatha| ");
INSERT INTO sancol_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","tadAnIM vyavasthApakAnAm EkA yIzumavadat, hE upadEzaka vAkyEnEdRzEnAsmAsvapi dOSam ArOpayasi| ");
INSERT INTO sancol_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","tataH sa uvAca, hA hA vyavasthApakA yUyam mAnuSANAm upari duHsahyAn bhArAn nyasyatha kintu svayam EkAgguुlyApi tAn bhArAn na spRzatha| ");
INSERT INTO sancol_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","hanta yuSmAkaM pUrvvapuruSA yAn bhaviSyadvAdinO'vadhiSustESAM zmazAnAni yUyaM nirmmAtha| ");
INSERT INTO sancol_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","tEnaiva yUyaM svapUrvvapuruSANAM karmmANi saMmanyadhvE tadEva sapramANaM kurutha ca, yatastE tAnavadhiSuH yUyaM tESAM zmazAnAni nirmmAtha| ");
INSERT INTO sancol_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ataEva Izvarasya zAstrE prOktamasti tESAmantikE bhaviSyadvAdinaH prEritAMzca prESayiSyAmi tatastE tESAM kAMzcana haniSyanti kAMzcana tAPazSyinti| ");
INSERT INTO sancol_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","EtasmAt kAraNAt hAbilaH zONitapAtamArabhya mandirayajnjavEdyO rmadhyE hatasya sikhariyasya raktapAtaparyyantaM ");
INSERT INTO sancol_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","jagataH sRSTimArabhya pRthivyAM bhaviSyadvAdinAM yatiraktapAtA jAtAstatInAm aparAdhadaNPA ESAM varttamAnalOkAnAM bhaviSyanti, yuSmAnahaM nizcitaM vadAmi sarvvE daNPA vaMzasyAsya bhaviSyanti| ");
INSERT INTO sancol_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","hA hA vyavasthapakA yUyaM jnjAnasya kunjcikAM hRtvA svayaM na praviSTA yE pravESTunjca prayAsinastAnapi pravESTuM vAritavantaH| ");
INSERT INTO sancol_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","itthaM kathAkathanAd adhyApakAH phirUzinazca satarkAH ");
INSERT INTO sancol_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","santastamapavadituM tasya kathAyA dOSaM dharttamicchantO nAnAkhyAnakathanAya taM pravarttayituM kOpayitunjca prArEbhirE| ");
INSERT INTO sancol_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","tadAnIM lOkAH sahasraM sahasram Agatya samupasthitAstata EkaikO 'nyESAmupari patitum upacakramE; tadA yIzuH ziSyAn babhASE, yUyaM phirUzinAM kiNvarUpakApaTyE vizESENa sAvadhAnAstiSThata| ");
INSERT INTO sancol_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","yatO yanna prakAzayiSyatE tadAcchannaM vastu kimapi nAsti; tathA yanna jnjAsyatE tad guptaM vastu kimapi nAsti| ");
INSERT INTO sancol_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","andhakArE tiSThanatO yAH kathA akathayata tAH sarvvAH kathA dIptau zrOSyantE nirjanE karNE ca yadakathayata gRhapRSThAt tat pracArayiSyatE| ");
INSERT INTO sancol_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","hE bandhavO yuSmAnahaM vadAmi, yE zarIrasya nAzaM vinA kimapyaparaM karttuM na zakruvanti tEbhyO mA bhaiSTa| ");
INSERT INTO sancol_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","tarhi kasmAd bhEtavyam ityahaM vadAmi, yaH zarIraM nAzayitvA narakaM nikSEptuM zaknOti tasmAdEva bhayaM kuruta, punarapi vadAmi tasmAdEva bhayaM kuruta| ");
INSERT INTO sancol_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","panjca caTakapakSiNaH kiM dvAbhyAM tAmrakhaNPAbhyAM na vikrIyantE? tathApIzvarastESAm Ekamapi na vismarati| ");
INSERT INTO sancol_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","yuSmAkaM ziraHkEzA api gaNitAH santi tasmAt mA vibhIta bahucaTakapakSibhyOpi yUyaM bahumUlyAH| ");
INSERT INTO sancol_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","aparaM yuSmabhyaM kathayAmi yaH kazcin mAnuSANAM sAkSAn mAM svIkarOti manuSyaputra IzvaradUtAnAM sAkSAt taM svIkariSyati| ");
INSERT INTO sancol_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","kintu yaH kazcinmAnuSANAM sAkSAnmAm asvIkarOti tam Izvarasya dUtAnAM sAkSAd aham asvIkariSyAmi| ");
INSERT INTO sancol_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","anyacca yaH kazcin manujasutasya nindAbhAvEna kAnjcit kathAM kathayati tasya tatpApasya mOcanaM bhaviSyati kintu yadi kazcit pavitram AtmAnaM nindati tarhi tasya tatpApasya mOcanaM na bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","yadA lOkA yuSmAn bhajanagEhaM vicArakartRrAjyakartRNAM sammukhanjca nESyanti tadA kEna prakArENa kimuttaraM vadiSyatha kiM kathayiSyatha cEtyatra mA cintayata; ");
INSERT INTO sancol_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","yatO yuSmAbhiryad yad vaktavyaM tat tasmin samayaEva pavitra AtmA yuSmAn zikSayiSyati| ");
INSERT INTO sancol_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","tataH paraM janatAmadhyasthaH kazcijjanastaM jagAda hE gurO mayA saha paitRkaM dhanaM vibhaktuM mama bhrAtaramAjnjApayatu bhavAn| ");
INSERT INTO sancol_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","kintu sa tamavadat hE manuSya yuvayO rvicAraM vibhAganjca karttuM mAM kO niyuktavAn? ");
INSERT INTO sancol_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","anantaraM sa lOkAnavadat lObhE sAvadhAnAH satarkAzca tiSThata, yatO bahusampattiprAptyA manuSyasyAyu rna bhavati| ");
INSERT INTO sancol_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","pazcAd dRSTAntakathAmutthApya kathayAmAsa, Ekasya dhaninO bhUmau bahUni zasyAni jAtAni| ");
INSERT INTO sancol_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","tataH sa manasA cintayitvA kathayAmbabhUva mamaitAni samutpannAni dravyANi sthApayituM sthAnaM nAsti kiM kariSyAmi? ");
INSERT INTO sancol_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","tatOvadad itthaM kariSyAmi, mama sarvvabhANPAgArANi bhagktvA bRhadbhANPAgArANi nirmmAya tanmadhyE sarvvaphalAni dravyANi ca sthApayiSyAmi| ");
INSERT INTO sancol_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","aparaM nijamanO vadiSyAmi, hE manO bahuvatsarArthaM nAnAdravyANi sanjcitAni santi vizrAmaM kuru bhuktvA pItvA kautukanjca kuru| kintvIzvarastam avadat, ");
INSERT INTO sancol_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","rE nirbOdha adya rAtrau tava prANAstvattO nESyantE tata EtAni yAni dravyANi tvayAsAditAni tAni kasya bhaviSyanti? ");
INSERT INTO sancol_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","ataEva yaH kazcid Izvarasya samIpE dhanasanjcayamakRtvA kEvalaM svanikaTE sanjcayaM karOti sOpi tAdRzaH| ");
INSERT INTO sancol_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","atha sa ziSyEbhyaH kathayAmAsa, yuSmAnahaM vadAmi, kiM khAdiSyAmaH? kiM paridhAsyAmaH? ityuktvA jIvanasya zarIrasya cArthaM cintAM mA kArSTa| ");
INSERT INTO sancol_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","bhakSyAjjIvanaM bhUSaNAccharIranjca zrESThaM bhavati| ");
INSERT INTO sancol_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","kAkapakSiNAM kAryyaM vicArayata, tE na vapanti zasyAni ca na chindanti, tESAM bhANPAgArANi na santi kOSAzca na santi, tathApIzvarastEbhyO bhakSyANi dadAti, yUyaM pakSibhyaH zrESThatarA na kiM? ");
INSERT INTO sancol_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","aparanjca bhAvayitvA nijAyuSaH kSaNamAtraM varddhayituM zaknOti, EtAdRzO lAkO yuSmAkaM madhyE kOsti? ");
INSERT INTO sancol_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","ataEva kSudraM kAryyaM sAdhayitum asamarthA yUyam anyasmin kAryyE kutO bhAvayatha? ");
INSERT INTO sancol_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","anyacca kAmpilapuSpaM kathaM varddhatE tadApi vicArayata, tat kanjcana zramaM na karOti tantUMzca na janayati kintu yuSmabhyaM yathArthaM kathayAmi sulEmAn bahvaizvaryyAnvitOpi puSpasyAsya sadRzO vibhUSitO nAsIt| ");
INSERT INTO sancol_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","adya kSEtrE varttamAnaM zvazcUllyAM kSEpsyamAnaM yat tRNaM, tasmai yadIzvara itthaM bhUSayati tarhi hE alpapratyayinO yuSmAna kiM na paridhApayiSyati? ");
INSERT INTO sancol_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","ataEva kiM khAdiSyAmaH? kiM paridhAsyAmaH? EtadarthaM mA cESTadhvaM mA saMdigdhvanjca| ");
INSERT INTO sancol_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","jagatO dEvArccakA EtAni sarvvANi cESTanatE; ESu vastuSu yuSmAkaM prayOjanamAstE iti yuSmAkaM pitA jAnAti| ");
INSERT INTO sancol_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","ataEvEzvarasya rAjyArthaM sacESTA bhavata tathA kRtE sarvvANyEtAni dravyANi yuSmabhyaM pradAyiSyantE| ");
INSERT INTO sancol_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","hE kSudramESavraja yUyaM mA bhaiSTa yuSmabhyaM rAjyaM dAtuM yuSmAkaM pituH sammatirasti| ");
INSERT INTO sancol_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ataEva yuSmAkaM yA yA sampattirasti tAM tAM vikrIya vitarata, yat sthAnaM caurA nAgacchanti, kITAzca na kSAyayanti tAdRzE svargE nijArtham ajarE sampuTakE 'kSayaM dhanaM sanjcinuta ca; ");
INSERT INTO sancol_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","yatO yatra yuSmAkaM dhanaM varttatE tatrEva yuSmAkaM manaH| ");
INSERT INTO sancol_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","aparanjca yUyaM pradIpaM jvAlayitvA baddhakaTayastiSThata; ");
INSERT INTO sancol_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","prabhu rvivAhAdAgatya yadaiva dvAramAhanti tadaiva dvAraM mOcayituM yathA bhRtyA apEkSya tiSThanti tathA yUyamapi tiSThata| ");
INSERT INTO sancol_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","yataH prabhurAgatya yAn dAsAn sacEtanAn tiSThatO drakSyati taEva dhanyAH; ahaM yuSmAn yathArthaM vadAmi prabhustAn bhOjanArtham upavEzya svayaM baddhakaTiH samIpamEtya parivESayiSyati| ");
INSERT INTO sancol_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","yadi dvitIyE tRtIyE vA praharE samAgatya tathaiva pazyati, tarhi taEva dAsA dhanyAH| ");
INSERT INTO sancol_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","aparanjca kasmin kSaNE caurA AgamiSyanti iti yadi gRhapati rjnjAtuM zaknOti tadAvazyaM jAgran nijagRhE sandhiM karttayituM vArayati yUyamEtad vitta| ");
INSERT INTO sancol_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","ataEva yUyamapi sajjamAnAstiSThata yatO yasmin kSaNE taM nAprEkSadhvE tasminnEva kSaNE manuSyaputra AgamiSyati| ");
INSERT INTO sancol_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","tadA pitaraH papraccha, hE prabhO bhavAn kimasmAn uddizya kiM sarvvAn uddizya dRSTAntakathAmimAM vadati? ");
INSERT INTO sancol_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","tataH prabhuH prOvAca, prabhuH samucitakAlE nijaparivArArthaM bhOjyaparivESaNAya yaM tatpadE niyOkSyati tAdRzO vizvAsyO bOddhA karmmAdhIzaH kOsti? ");
INSERT INTO sancol_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","prabhurAgatya yam EtAdRzE karmmaNi pravRttaM drakSyati saEva dAsO dhanyaH| ");
INSERT INTO sancol_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ahaM yuSmAn yathArthaM vadAmi sa taM nijasarvvasvasyAdhipatiM kariSyati| ");
INSERT INTO sancol_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","kintu prabhurvilambEnAgamiSyati, iti vicintya sa dAsO yadi tadanyadAsIdAsAn praharttum bhOktuM pAtuM maditunjca prArabhatE, ");
INSERT INTO sancol_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","tarhi yadA prabhuM nApEkSiSyatE yasmin kSaNE sO'cEtanazca sthAsyati tasminnEva kSaNE tasya prabhurAgatya taM padabhraSTaM kRtvA vizvAsahInaiH saha tasya aMzaM nirUpayiSyati| ");
INSERT INTO sancol_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","yO dAsaH prabhEाrAjnjAM jnjAtvApi sajjitO na tiSThati tadAjnjAnusArENa ca kAryyaM na karOti sOnEkAn prahArAn prApsyati; ");
INSERT INTO sancol_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","kintu yO janO'jnjAtvA prahArArhaM karmma karOti sOlpaprahArAn prApsyati| yatO yasmai bAhulyEna dattaM tasmAdEva bAhulyEna grahISyatE, mAnuSA yasya nikaTE bahu samarpayanti tasmAd bahu yAcantE| ");
INSERT INTO sancol_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","ahaM pRthivyAm anaikyarUpaM vahni nikSEptum AgatOsmi, sa cEd idAnImEva prajvalati tatra mama kA cintA? ");
INSERT INTO sancol_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","kintu yEna majjanEnAhaM magnO bhaviSyAmi yAvatkAlaM tasya siddhi rna bhaviSyati tAvadahaM katikaSTaM prApsyAmi| ");
INSERT INTO sancol_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","mElanaM karttuM jagad AgatOsmi yUyaM kimitthaM bOdhadhvE? yuSmAn vadAmi na tathA, kintvahaM mElanAbhAvaM karttuMm AgatOsmi| ");
INSERT INTO sancol_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","yasmAdEtatkAlamArabhya EkatrasthaparijanAnAM madhyE panjcajanAH pRthag bhUtvA trayO janA dvayOrjanayOH pratikUlA dvau janau ca trayANAM janAnAM pratikUlau bhaviSyanti| ");
INSERT INTO sancol_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","pitA putrasya vipakSaH putrazca pitu rvipakSO bhaviSyati mAtA kanyAyA vipakSA kanyA ca mAtu rvipakSA bhaviSyati, tathA zvazrUrbadhvA vipakSA badhUzca zvazrvA vipakSA bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","sa lOkEbhyOparamapi kathayAmAsa, pazcimadizi mEghOdgamaM dRSTvA yUyaM haThAd vadatha vRSTi rbhaviSyati tatastathaiva jAyatE| ");
INSERT INTO sancol_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","aparaM dakSiNatO vAyau vAti sati vadatha nidAghO bhaviSyati tataH sOpi jAyatE| ");
INSERT INTO sancol_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","rE rE kapaTina AkAzasya bhUmyAzca lakSaNaM bOddhuM zaknutha, ");
INSERT INTO sancol_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","kintu kAlasyAsya lakSaNaM kutO bOddhuM na zaknutha? yUyanjca svayaM kutO na nyASyaM vicArayatha? ");
INSERT INTO sancol_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","aparanjca vivAdinA sArddhaM vicArayituH samIpaM gacchan pathi tasmAduddhAraM prAptuM yatasva nOcEt sa tvAM dhRtvA vicArayituH samIpaM nayati| vicArayitA yadi tvAM praharttuH samIpaM samarpayati praharttA tvAM kArAyAM badhnAti ");
INSERT INTO sancol_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","tarhi tvAmahaM vadAmi tvayA niHzESaM kapardakESu na parizOdhitESu tvaM tatO muktiM prAptuM na zakSyasi| ");
INSERT INTO sancol_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","aparanjca pIlAtO yESAM gAlIlIyAnAM raktAni balInAM raktaiH sahAmizrayat tESAM gAlIlIyAnAM vRttAntaM katipayajanA upasthApya yIzavE kathayAmAsuH| ");
INSERT INTO sancol_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","tataH sa pratyuvAca tESAM lOkAnAm EtAdRzI durgati rghaTitA tatkAraNAd yUyaM kimanyEbhyO gAlIlIyEbhyOpyadhikapApinastAn bOdhadhvE? ");
INSERT INTO sancol_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","yuSmAnahaM vadAmi tathA na kintu manaHsu na parAvarttitESu yUyamapi tathA naMkSyatha| ");
INSERT INTO sancol_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","aparanjca zIlOhanAmna uccagRhasya patanAd yE'STAdazajanA mRtAstE yirUzAlami nivAsisarvvalOkEbhyO'dhikAparAdhinaH kiM yUyamityaM bOdhadhvE? ");
INSERT INTO sancol_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","yuSmAnahaM vadAmi tathA na kintu manaHsu na parivarttitESu yUyamapi tathA naMkSyatha| ");
INSERT INTO sancol_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","anantaraM sa imAM dRSTAntakathAmakathayad EkO janO drAkSAkSEtramadhya EkamuPumbaravRkSaM rOpitavAn| pazcAt sa Agatya tasmin phalAni gavESayAmAsa, ");
INSERT INTO sancol_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","kintu phalAprAptEH kAraNAd udyAnakAraM bhRtyaM jagAda, pazya vatsaratrayaM yAvadAgatya EtasminnuPumbaratarau kSalAnyanvicchAmi, kintu naikamapi prapnOmi tarurayaM kutO vRthA sthAnaM vyApya tiSThati? EnaM chindhi| ");
INSERT INTO sancol_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","tatO bhRtyaH pratyuvAca, hE prabhO punarvarSamEkaM sthAtum Adiza; Etasya mUlasya caturdikSu khanitvAham AlavAlaM sthApayAmi| ");
INSERT INTO sancol_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","tataH phalituM zaknOti yadi na phalati tarhi pazcAt chEtsyasi| ");
INSERT INTO sancol_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","atha vizrAmavArE bhajanagEhE yIzurupadizati ");
INSERT INTO sancol_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","tasmit samayE bhUtagrastatvAt kubjIbhUyASTAdazavarSANi yAvat kEnApyupAyEna Rju rbhavituM na zaknOti yA durbbalA strI, ");
INSERT INTO sancol_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","tAM tatrOpasthitAM vilOkya yIzustAmAhUya kathitavAn hE nAri tava daurbbalyAt tvaM muktA bhava| ");
INSERT INTO sancol_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","tataH paraM tasyA gAtrE hastArpaNamAtrAt sA RjurbhUtvEzvarasya dhanyavAdaM karttumArEbhE| ");
INSERT INTO sancol_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","kintu vizrAmavArE yIzunA tasyAH svAsthyakaraNAd bhajanagEhasyAdhipatiH prakupya lOkAn uvAca, SaTsu dinESu lOkaiH karmma karttavyaM tasmAddhEtOH svAsthyArthaM tESu dinESu Agacchata, vizrAmavArE mAgacchata| ");
INSERT INTO sancol_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","tadA pabhuH pratyuvAca rE kapaTinO yuSmAkam EkaikO janO vizrAmavArE svIyaM svIyaM vRSabhaM gardabhaM vA bandhanAnmOcayitvA jalaM pAyayituM kiM na nayati? ");
INSERT INTO sancol_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","tarhyASTAdazavatsarAn yAvat zaitAnA baddhA ibrAhImaH santatiriyaM nArI kiM vizrAmavArE na mOcayitavyA? ");
INSERT INTO sancol_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ESu vAkyESu kathitESu tasya vipakSAH salajjA jAtAH kintu tEna kRtasarvvamahAkarmmakAraNAt lOkanivahaH sAnandO'bhavat| ");
INSERT INTO sancol_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","anantaraM sOvadad Izvarasya rAjyaM kasya sadRzaM? kEna tadupamAsyAmi? ");
INSERT INTO sancol_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","yat sarSapabIjaM gRhItvA kazcijjana udyAna uptavAn tad bIjamagkuritaM sat mahAvRkSO'jAyata, tatastasya zAkhAsu vihAyasIyavihagA Agatya nyUSuH, tadrAjyaM tAdRzEna sarSapabIjEna tulyaM| ");
INSERT INTO sancol_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","punaH kathayAmAsa, Izvarasya rAjyaM kasya sadRzaM vadiSyAmi? yat kiNvaM kAcit strI gRhItvA drONatrayaparimitagOdhUmacUrNESu sthApayAmAsa, ");
INSERT INTO sancol_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","tataH kramENa tat sarvvagOdhUmacUrNaM vyApnOti, tasya kiNvasya tulyam Izvarasya rAjyaM| ");
INSERT INTO sancol_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","tataH sa yirUzAlamnagaraM prati yAtrAM kRtvA nagarE nagarE grAmE grAmE samupadizan jagAma| ");
INSERT INTO sancol_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","tadA kazcijjanastaM papraccha, hE prabhO kiM kEvalam alpE lOkAH paritrAsyantE? ");
INSERT INTO sancol_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","tataH sa lOkAn uvAca, saMkIrNadvArENa pravESTuM yataghvaM, yatOhaM yuSmAn vadAmi, bahavaH pravESTuM cESTiSyantE kintu na zakSyanti| ");
INSERT INTO sancol_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","gRhapatinOtthAya dvArE ruddhE sati yadi yUyaM bahiH sthitvA dvAramAhatya vadatha, hE prabhO hE prabhO asmatkAraNAd dvAraM mOcayatu, tataH sa iti prativakSyati, yUyaM kutratyA lOkA ityahaM na jAnAmi| ");
INSERT INTO sancol_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","tadA yUyaM vadiSyatha, tava sAkSAd vayaM bhEाjanaM pAnanjca kRtavantaH, tvanjcAsmAkaM nagarasya pathi samupadiSTavAn| ");
INSERT INTO sancol_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","kintu sa vakSyati, yuSmAnahaM vadAmi, yUyaM kutratyA lOkA ityahaM na jAnAmi; hE durAcAriNO yUyaM mattO dUrIbhavata| ");
INSERT INTO sancol_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","tadA ibrAhImaM ishAkaM yAkUbanjca sarvvabhaviSyadvAdinazca Izvarasya rAjyaM prAptAn svAMzca bahiSkRtAn dRSTvA yUyaM rOdanaM dantairdantagharSaNanjca kariSyatha| ");
INSERT INTO sancol_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","aparanjca pUrvvapazcimadakSiNOttaradigbhyO lOkA Agatya Izvarasya rAjyE nivatsyanti| ");
INSERT INTO sancol_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","pazyatEtthaM zESIyA lOkA agrA bhaviSyanti, agrIyA lOkAzca zESA bhaviSyanti| ");
INSERT INTO sancol_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","aparanjca tasmin dinE kiyantaH phirUzina Agatya yIzuM prOcuH, bahirgaccha, sthAnAdasmAt prasthAnaM kuru, hErOd tvAM jighAMsati| ");
INSERT INTO sancol_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","tataH sa pratyavOcat pazyatAdya zvazca bhUtAn vihApya rOgiNO'rOgiNaH kRtvA tRtIyEhni sEtsyAmi, kathAmEtAM yUyamitvA taM bhUrimAyaM vadata| ");
INSERT INTO sancol_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","tatrApyadya zvaH parazvazca mayA gamanAgamanE karttavyE, yatO hEtO ryirUzAlamO bahiH kutrApi kOpi bhaviSyadvAdI na ghAniSyatE| ");
INSERT INTO sancol_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","hE yirUzAlam hE yirUzAlam tvaM bhaviSyadvAdinO haMsi tavAntikE prEritAn prastarairmArayasi ca, yathA kukkuTI nijapakSAdhaH svazAvakAn saMgRhlAti, tathAhamapi tava zizUn saMgrahItuM kativArAn aicchaM kintu tvaM naicchaH| ");
INSERT INTO sancol_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","pazyata yuSmAkaM vAsasthAnAni prOcchidyamAnAni parityaktAni ca bhaviSyanti; yuSmAnahaM yathArthaM vadAmi, yaH prabhO rnAmnAgacchati sa dhanya iti vAcaM yAvatkAlaM na vadiSyatha, tAvatkAlaM yUyaM mAM na drakSyatha| ");
INSERT INTO sancol_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","anantaraM vizrAmavArE yIzau pradhAnasya phirUzinO gRhE bhOktuM gatavati tE taM vIkSitum ArEbhirE| ");
INSERT INTO sancol_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","tadA jalOdarI tasya sammukhE sthitaH| ");
INSERT INTO sancol_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","tataH sa vyavasthApakAn phirUzinazca papraccha, vizrAmavArE svAsthyaM karttavyaM na vA? tatastE kimapi na pratyUcuH| ");
INSERT INTO sancol_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","tadA sa taM rOgiNaM svasthaM kRtvA visasarja; ");
INSERT INTO sancol_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","tAnuvAca ca yuSmAkaM kasyacid garddabhO vRSabhO vA cEd garttE patati tarhi vizrAmavArE tatkSaNaM sa kiM taM nOtthApayiSyati? ");
INSERT INTO sancol_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","tatastE kathAyA EtasyAH kimapi prativaktuM na zEkuH| ");
INSERT INTO sancol_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","aparanjca pradhAnasthAnamanOnItatvakaraNaM vilOkya sa nimantritAn EtadupadEzakathAM jagAda, ");
INSERT INTO sancol_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","tvaM vivAhAdibhOjyESu nimantritaH san pradhAnasthAnE mOpAvEkSIH| tvattO gauravAnvitanimantritajana AyAtE ");
INSERT INTO sancol_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","nimantrayitAgatya manuSyAyaitasmai sthAnaM dEhIti vAkyaM cEd vakSyati tarhi tvaM sagkucitO bhUtvA sthAna itarasmin upavESTum udyaMsyasi| ");
INSERT INTO sancol_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","asmAt kAraNAdEva tvaM nimantritO gatvA'pradhAnasthAna upaviza, tatO nimantrayitAgatya vadiSyati, hE bandhO prOccasthAnaM gatvOpaviza, tathA sati bhOjanOpaviSTAnAM sakalAnAM sAkSAt tvaM mAnyO bhaviSyasi| ");
INSERT INTO sancol_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","yaH kazcit svamunnamayati sa namayiSyatE, kintu yaH kazcit svaM namayati sa unnamayiSyatE| ");
INSERT INTO sancol_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","tadA sa nimantrayitAraM janamapi jagAda, madhyAhnE rAtrau vA bhOjyE kRtE nijabandhugaNO vA bhrAtRृgaNO vA jnjAtigaNO vA dhanigaNO vA samIpavAsigaNO vA EtAn na nimantraya, tathA kRtE cEt tE tvAM nimantrayiSyanti, tarhi parizOdhO bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","kintu yadA bhEjyaM karOSi tadA daridrazuSkakarakhanjjAndhAn nimantraya, ");
INSERT INTO sancol_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","tata AziSaM lapsyasE, tESu parizOdhaM karttumazaknuvatsu zmazAnAddhArmmikAnAmutthAnakAlE tvaM phalAM lapsyasE| ");
INSERT INTO sancol_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","anantaraM tAM kathAM nizamya bhOjanOpaviSTaH kazcit kathayAmAsa, yO jana Izvarasya rAjyE bhOktuM lapsyatE saEva dhanyaH| ");
INSERT INTO sancol_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","tataH sa uvAca, kazcit janO rAtrau bhEाjyaM kRtvA bahUn nimantrayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","tatO bhOjanasamayE nimantritalOkAn AhvAtuM dAsadvArA kathayAmAsa, khadyadravyANi sarvvANi samAsAditAni santi, yUyamAgacchata| ");
INSERT INTO sancol_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","kintu tE sarvva EkaikaM chalaM kRtvA kSamAM prArthayAnjcakrirE| prathamO janaH kathayAmAsa, kSEtramEkaM krItavAnahaM tadEva draSTuM mayA gantavyam, ataEva mAM kSantuM taM nivEdaya| ");
INSERT INTO sancol_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","anyO janaH kathayAmAsa, dazavRSAnahaM krItavAn tAn parIkSituM yAmi tasmAdEva mAM kSantuM taM nivEdaya| ");
INSERT INTO sancol_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","aparaH kathayAmAsa, vyUPhavAnahaM tasmAt kAraNAd yAtuM na zaknOmi| ");
INSERT INTO sancol_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","pazcAt sa dAsO gatvA nijaprabhOH sAkSAt sarvvavRttAntaM nivEdayAmAsa, tatOsau gRhapatiH kupitvA svadAsaM vyAjahAra, tvaM satvaraM nagarasya sannivEzAn mArgAMzca gatvA daridrazuSkakarakhanjjAndhAn atrAnaya| ");
INSERT INTO sancol_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","tatO dAsO'vadat, hE prabhO bhavata AjnjAnusArENAkriyata tathApi sthAnamasti| ");
INSERT INTO sancol_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","tadA prabhuH puna rdAsAyAkathayat, rAjapathAn vRkSamUlAni ca yAtvA madIyagRhapUraNArthaM lOkAnAgantuM pravarttaya| ");
INSERT INTO sancol_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ahaM yuSmabhyaM kathayAmi, pUrvvanimantritAnamEkOpi mamAsya rAtribhOjyasyAsvAdaM na prApsyati| ");
INSERT INTO sancol_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","anantaraM bahuSu lOkESu yIzOH pazcAd vrajitESu satsu sa vyAghuTya tEbhyaH kathayAmAsa, ");
INSERT INTO sancol_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","yaH kazcin mama samIpam Agatya svasya mAtA pitA patnI santAnA bhrAtarO bhagimyO nijaprANAzca, EtEbhyaH sarvvEbhyO mayyadhikaM prEma na karOti, sa mama ziSyO bhavituM na zakSyati| ");
INSERT INTO sancol_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","yaH kazcit svIyaM kruzaM vahan mama pazcAnna gacchati, sOpi mama ziSyO bhavituM na zakSyati| ");
INSERT INTO sancol_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","durganirmmANE kativyayO bhaviSyati, tathA tasya samAptikaraNArthaM sampattirasti na vA, prathamamupavizya Etanna gaNayati, yuSmAkaM madhya EtAdRzaH kOsti? ");
INSERT INTO sancol_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","nOcEd bhittiM kRtvA zESE yadi samApayituM na zakSyati, ");
INSERT INTO sancol_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","tarhi mAnuSOyaM nicEtum Arabhata samApayituM nAzaknOt, iti vyAhRtya sarvvE tamupahasiSyanti| ");
INSERT INTO sancol_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","aparanjca bhinnabhUpatinA saha yuddhaM karttum udyamya dazasahasrANi sainyAni gRhItvA viMzatisahasrEH sainyaiH sahitasya samIpavAsinaH sammukhaM yAtuM zakSyAmi na vEti prathamaM upavizya na vicArayati EtAdRzO bhUmipatiH kaH? ");
INSERT INTO sancol_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","yadi na zaknOti tarhi ripAvatidUrE tiSThati sati nijadUtaM prESya sandhiM karttuM prArthayEta| ");
INSERT INTO sancol_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","tadvad yuSmAkaM madhyE yaH kazcin madarthaM sarvvasvaM hAtuM na zaknOti sa mama ziSyO bhavituM na zakSyati| ");
INSERT INTO sancol_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","lavaNam uttamam iti satyaM, kintu yadi lavaNasya lavaNatvam apagacchati tarhi tat kathaM svAduyuktaM bhaviSyati? ");
INSERT INTO sancol_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","tada bhUmyartham AlavAlarAzyarthamapi bhadraM na bhavati; lOkAstad bahiH kSipanti|yasya zrOtuM zrOtrE staH sa zRNOtu| ");
INSERT INTO sancol_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","tadA karasanjcAyinaH pApinazca lOkA upadEzkathAM zrOtuM yIzOH samIpam Agacchan| ");
INSERT INTO sancol_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","tataH phirUzina upAdhyAyAzca vivadamAnAH kathayAmAsuH ESa mAnuSaH pApibhiH saha praNayaM kRtvA taiH sArddhaM bhuMktE| ");
INSERT INTO sancol_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","tadA sa tEbhya imAM dRSTAntakathAM kathitavAn, ");
INSERT INTO sancol_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","kasyacit zatamESESu tiSThatmu tESAmEkaM sa yadi hArayati tarhi madhyEprAntaram EkOnazatamESAn vihAya hAritamESasya uddEzaprAptiparyyanataM na gavESayati, EtAdRzO lOkO yuSmAkaM madhyE ka AstE? ");
INSERT INTO sancol_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","tasyOddEzaM prApya hRSTamanAstaM skandhE nidhAya svasthAnam AnIya bandhubAndhavasamIpavAsina AhUya vakti, ");
INSERT INTO sancol_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","hAritaM mESaM prAptOham atO hEtO rmayA sArddham Anandata| ");
INSERT INTO sancol_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","tadvadahaM yuSmAn vadAmi, yESAM manaHparAvarttanasya prayOjanaM nAsti, tAdRzaikOnazatadhArmmikakAraNAd ya AnandastasmAd Ekasya manaHparivarttinaH pApinaH kAraNAt svargE 'dhikAnandO jAyatE| ");
INSERT INTO sancol_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","aparanjca dazAnAM rUpyakhaNPAnAm EkakhaNPE hAritE pradIpaM prajvAlya gRhaM sammArjya tasya prAptiM yAvad yatnEna na gavESayati, EtAdRzI yOSit kAstE? ");
INSERT INTO sancol_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","prAptE sati bandhubAndhavasamIpavAsinIrAhUya kathayati, hAritaM rUpyakhaNPaM prAptAhaM tasmAdEva mayA sArddham Anandata| ");
INSERT INTO sancol_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","tadvadahaM yuSmAn vyAharAmi, EkEna pApinA manasi parivarttitE, Izvarasya dUtAnAM madhyEpyAnandO jAyatE| ");
INSERT INTO sancol_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","aparanjca sa kathayAmAsa, kasyacid dvau putrAvAstAM, ");
INSERT INTO sancol_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","tayOH kaniSThaH putraH pitrE kathayAmAsa, hE pitastava sampattyA yamaMzaM prApsyAmyahaM vibhajya taM dEhi, tataH pitA nijAM sampattiM vibhajya tAbhyAM dadau| ");
INSERT INTO sancol_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","katipayAt kAlAt paraM sa kaniSThaputraH samastaM dhanaM saMgRhya dUradEzaM gatvA duSTAcaraNEna sarvvAM sampattiM nAzayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","tasya sarvvadhanE vyayaM gatE taddEzE mahAdurbhikSaM babhUva, tatastasya dainyadazA bhavitum ArEbhE| ");
INSERT INTO sancol_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","tataH paraM sa gatvA taddEzIyaM gRhasthamEkam Azrayata; tataH sataM zUkaravrajaM cArayituM prAntaraM prESayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","kEnApi tasmai bhakSyAdAnAt sa zUkaraphalavalkalEna piciNPapUraNAM vavAnjcha| ");
INSERT INTO sancol_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","zESE sa manasi cEtanAM prApya kathayAmAsa, hA mama pituH samIpE kati kati vEtanabhujO dAsA yathESTaM tatOdhikanjca bhakSyaM prApnuvanti kintvahaM kSudhA mumUrSuH| ");
INSERT INTO sancol_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ahamutthAya pituH samIpaM gatvA kathAmEtAM vadiSyAmi, hE pitar Izvarasya tava ca viruddhaM pApamakaravam ");
INSERT INTO sancol_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","tava putra_iti vikhyAtO bhavituM na yOgyOsmi ca, mAM tava vaitanikaM dAsaM kRtvA sthApaya| ");
INSERT INTO sancol_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","pazcAt sa utthAya pituH samIpaM jagAma; tatastasya pitAtidUrE taM nirIkSya dayAnjcakrE, dhAvitvA tasya kaNThaM gRhItvA taM cucumba ca| ");
INSERT INTO sancol_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","tadA putra uvAca, hE pitar Izvarasya tava ca viruddhaM pApamakaravaM, tava putra_iti vikhyAtO bhavituM na yOgyOsmi ca| ");
INSERT INTO sancol_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","kintu tasya pitA nijadAsAn AdidEza, sarvvOttamavastrANyAnIya paridhApayatainaM hastE cAggurIyakam arpayata pAdayOzcOpAnahau samarpayata; ");
INSERT INTO sancol_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","puSTaM gOvatsam AnIya mArayata ca taM bhuktvA vayam AnandAma| ");
INSERT INTO sancol_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","yatO mama putrOyam amriyata punarajIvId hAritazca labdhObhUt tatasta Ananditum ArEbhirE| ");
INSERT INTO sancol_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","tatkAlE tasya jyESThaH putraH kSEtra AsIt| atha sa nivEzanasya nikaTaM Agacchan nRtyAnAM vAdyAnAnjca zabdaM zrutvA ");
INSERT INTO sancol_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","dAsAnAm Ekam AhUya papraccha, kiM kAraNamasya? ");
INSERT INTO sancol_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","tataH sOvAdIt, tava bhrAtAgamat, tava tAtazca taM suzarIraM prApya puSTaM gOvatsaM mAritavAn| ");
INSERT INTO sancol_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","tataH sa prakupya nivEzanAntaH pravESTuM na sammEnE; tatastasya pitA bahirAgatya taM sAdhayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","tataH sa pitaraM pratyuvAca, pazya tava kAnjcidapyAjnjAM na vilaMghya bahUn vatsarAn ahaM tvAM sEvE tathApi mitraiH sArddham utsavaM karttuM kadApi chAgamEkamapi mahyaM nAdadAH; ");
INSERT INTO sancol_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","kintu tava yaH putrO vEzyAgamanAdibhistava sampattim apavyayitavAn tasminnAgatamAtrE tasyaiva nimittaM puSTaM gOvatsaM mAritavAn| ");
INSERT INTO sancol_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","tadA tasya pitAvOcat, hE putra tvaM sarvvadA mayA sahAsi tasmAn mama yadyadAstE tatsarvvaM tava| ");
INSERT INTO sancol_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","kintu tavAyaM bhrAtA mRtaH punarajIvId hAritazca bhUtvA prAptObhUt, EtasmAt kAraNAd utsavAnandau karttum ucitamasmAkam| ");
INSERT INTO sancol_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","aparanjca yIzuH ziSyEbhyOnyAmEkAM kathAM kathayAmAsa kasyacid dhanavatO manuSyasya gRhakAryyAdhIzE sampattErapavyayE'pavAditE sati ");
INSERT INTO sancol_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","tasya prabhustam AhUya jagAda, tvayi yAmimAM kathAM zRNOmi sA kIdRzI? tvaM gRhakAryyAdhIzakarmmaNO gaNanAM darzaya gRhakAryyAdhIzapadE tvaM na sthAsyasi| ");
INSERT INTO sancol_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","tadA sa gRhakAryyAdhIzO manasA cintayAmAsa, prabhu ryadi mAM gRhakAryyAdhIzapadAd bhraMzayati tarhi kiM kariSyE'haM? mRdaM khanituM mama zakti rnAsti bhikSitunjca lajjiSyE'haM| ");
INSERT INTO sancol_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ataEva mayi gRhakAryyAdhIzapadAt cyutE sati yathA lOkA mahyam AzrayaM dAsyanti tadarthaM yatkarmma mayA karaNIyaM tan nirNIyatE| ");
INSERT INTO sancol_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","pazcAt sa svaprabhOrEkaikam adhamarNam AhUya prathamaM papraccha, tvattO mE prabhuNA kati prApyam? ");
INSERT INTO sancol_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","tataH sa uvAca, EkazatAPhakatailAni; tadA gRhakAryyAdhIzaH prOvAca, tava patramAnIya zIghramupavizya tatra panjcAzataM likha| ");
INSERT INTO sancol_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","pazcAdanyamEkaM papraccha, tvattO mE prabhuNA kati prApyam? tataH sOvAdId EkazatAPhakagOdhUmAH; tadA sa kathayAmAsa, tava patramAnIya azItiM likha| ");
INSERT INTO sancol_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","tEnaiva prabhustamayathArthakRtam adhIzaM tadbuddhinaipuNyAt prazazaMsa; itthaM dIptirUpasantAnEbhya EtatsaMsArasya santAnA varttamAnakAlE'dhikabuddhimantO bhavanti| ");
INSERT INTO sancol_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","atO vadAmi yUyamapyayathArthEna dhanEna mitrANi labhadhvaM tatO yuSmAsu padabhraSTESvapi tAni cirakAlam AzrayaM dAsyanti| ");
INSERT INTO sancol_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","yaH kazcit kSudrE kAryyE vizvAsyO bhavati sa mahati kAryyEpi vizvAsyO bhavati, kintu yaH kazcit kSudrE kAryyE'vizvAsyO bhavati sa mahati kAryyEpyavizvAsyO bhavati| ");
INSERT INTO sancol_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ataEva ayathArthEna dhanEna yadi yUyamavizvAsyA jAtAstarhi satyaM dhanaM yuSmAkaM karESu kaH samarpayiSyati? ");
INSERT INTO sancol_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","yadi ca paradhanEna yUyam avizvAsyA bhavatha tarhi yuSmAkaM svakIyadhanaM yuSmabhyaM kO dAsyati? ");
INSERT INTO sancol_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","kOpi dAsa ubhau prabhU sEvituM na zaknOti, yata Ekasmin prIyamANO'nyasminnaprIyatE yadvA EkaM janaM samAdRtya tadanyaM tucchIkarOti tadvad yUyamapi dhanEzvarau sEvituM na zaknutha| ");
INSERT INTO sancol_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","tadaitAH sarvvAH kathAH zrutvA lObhiphirUzinastamupajahasuH| ");
INSERT INTO sancol_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","tataH sa uvAca, yUyaM manuSyANAM nikaTE svAn nirdOSAn darzayatha kintu yuSmAkam antaHkaraNAnIzvarO jAnAti, yat manuSyANAm ati prazaMsyaM tad Izvarasya ghRNyaM| ");
INSERT INTO sancol_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","yOhana AgamanaparyyanataM yuSmAkaM samIpE vyavasthAbhaviSyadvAdinAM lEkhanAni cAsan tataH prabhRti IzvararAjyasya susaMvAdaH pracarati, EkaikO lOkastanmadhyaM yatnEna pravizati ca| ");
INSERT INTO sancol_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","varaM nabhasaH pRthivyAzca lOpO bhaviSyati tathApi vyavasthAyA EkabindOrapi lOpO na bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","yaH kazcit svIyAM bhAryyAM vihAya striyamanyAM vivahati sa paradArAn gacchati, yazca tA tyaktAM nArIM vivahati sOpi paradArAna gacchati| ");
INSERT INTO sancol_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","EkO dhanI manuSyaH zuklAni sUkSmANi vastrANi paryyadadhAt pratidinaM paritOSarUpENAbhuMktApivacca| ");
INSERT INTO sancol_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","sarvvAggE kSatayukta iliyAsaranAmA kazcid daridrastasya dhanavatO bhOjanapAtrAt patitam ucchiSTaM bhOktuM vAnjchan tasya dvArE patitvAtiSThat; ");
INSERT INTO sancol_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","atha zvAna Agatya tasya kSatAnyalihan| ");
INSERT INTO sancol_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","kiyatkAlAtparaM sa daridraH prANAn jahau; tataH svargIyadUtAstaM nItvA ibrAhImaH krOPa upavEzayAmAsuH| ");
INSERT INTO sancol_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","pazcAt sa dhanavAnapi mamAra, taM zmazAnE sthApayAmAsuzca; kintu paralOkE sa vEdanAkulaH san UrddhvAM nirIkSya bahudUrAd ibrAhImaM tatkrOPa iliyAsaranjca vilOkya ruvannuvAca; ");
INSERT INTO sancol_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","hE pitar ibrAhIm anugRhya aggulyagrabhAgaM jalE majjayitvA mama jihvAM zItalAM karttum iliyAsaraM prEraya, yatO vahnizikhAtOhaM vyathitOsmi| ");
INSERT INTO sancol_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","tadA ibrAhIm babhASE, hE putra tvaM jIvan sampadaM prAptavAn iliyAsarastu vipadaM prAptavAn Etat smara, kintu samprati tasya sukhaM tava ca duHkhaM bhavati| ");
INSERT INTO sancol_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","aparamapi yuSmAkam asmAkanjca sthAnayO rmadhyE mahadvicchEdO'sti tata EtatsthAnasya lOkAstat sthAnaM yAtuM yadvA tatsthAnasya lOkA Etat sthAnamAyAtuM na zaknuvanti| ");
INSERT INTO sancol_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","tadA sa uktavAn, hE pitastarhi tvAM nivEdayAmi mama pitu rgEhE yE mama panjca bhrAtaraH santi ");
INSERT INTO sancol_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","tE yathaitad yAtanAsthAnaM nAyAsyanti tathA mantraNAM dAtuM tESAM samIpam iliyAsaraM prEraya| ");
INSERT INTO sancol_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","tata ibrAhIm uvAca, mUsAbhaviSyadvAdinAnjca pustakAni tESAM nikaTE santi tE tadvacanAni manyantAM| ");
INSERT INTO sancol_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","tadA sa nivEdayAmAsa, hE pitar ibrAhIm na tathA, kintu yadi mRtalOkAnAM kazcit tESAM samIpaM yAti tarhi tE manAMsi vyAghOTayiSyanti| ");
INSERT INTO sancol_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","tata ibrAhIm jagAda, tE yadi mUsAbhaviSyadvAdinAnjca vacanAni na manyantE tarhi mRtalOkAnAM kasmiMzcid utthitEpi tE tasya mantraNAM na maMsyantE| ");
INSERT INTO sancol_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","itaH paraM yIzuH ziSyAn uvAca, vighnairavazyam AgantavyaM kintu vighnA yEna ghaTiSyantE tasya durgati rbhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","EtESAM kSudraprANinAm EkasyApi vighnajananAt kaNThabaddhapESaNIkasya tasya sAgarAgAdhajalE majjanaM bhadraM| ");
INSERT INTO sancol_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","yUyaM svESu sAvadhAnAstiSThata; tava bhrAtA yadi tava kinjcid aparAdhyati tarhi taM tarjaya, tEna yadi manaH parivarttayati tarhi taM kSamasva| ");
INSERT INTO sancol_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","punarEkadinamadhyE yadi sa tava saptakRtvO'parAdhyati kintu saptakRtva Agatya manaH parivartya mayAparAddham iti vadati tarhi taM kSamasva| ");
INSERT INTO sancol_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","tadA prEritAH prabhum avadan asmAkaM vizvAsaM varddhaya| ");
INSERT INTO sancol_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","prabhuruvAca, yadi yuSmAkaM sarSapaikapramANO vizvAsOsti tarhi tvaM samUlamutpATitO bhUtvA samudrE rOpitO bhava kathAyAm EtasyAm EtaduPumbarAya kathitAyAM sa yuSmAkamAjnjAvahO bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","aparaM svadAsE halaM vAhayitvA vA pazUn cArayitvA kSEtrAd AgatE sati taM vadati, Ehi bhOktumupaviza, yuSmAkam EtAdRzaH kOsti? ");
INSERT INTO sancol_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","varanjca pUrvvaM mama khAdyamAsAdya yAvad bhunjjE pivAmi ca tAvad baddhakaTiH paricara pazcAt tvamapi bhOkSyasE pAsyasi ca kathAmIdRzIM kiM na vakSyati? ");
INSERT INTO sancol_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","tEna dAsEna prabhOrAjnjAnurUpE karmmaNi kRtE prabhuH kiM tasmin bAdhitO jAtaH? nEtthaM budhyatE mayA| ");
INSERT INTO sancol_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","itthaM nirUpitESu sarvvakarmmasu kRtESu satmu yUyamapIdaM vAkyaM vadatha, vayam anupakAriNO dAsA asmAbhiryadyatkarttavyaM tanmAtramEva kRtaM| ");
INSERT INTO sancol_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","sa yirUzAlami yAtrAM kurvvan zOmirONgAlIlpradEzamadhyEna gacchati, ");
INSERT INTO sancol_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Etarhi kutracid grAmE pravEzamAtrE dazakuSThinastaM sAkSAt kRtvA ");
INSERT INTO sancol_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","dUrE tiSThanata uccai rvaktumArEbhirE, hE prabhO yIzO dayasvAsmAn| ");
INSERT INTO sancol_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","tataH sa tAn dRSTvA jagAda, yUyaM yAjakAnAM samIpE svAn darzayata, tatastE gacchantO rOgAt pariSkRtAH| ");
INSERT INTO sancol_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","tadA tESAmEkaH svaM svasthaM dRSTvA prOccairIzvaraM dhanyaM vadan vyAghuTyAyAtO yIzO rguNAnanuvadan taccaraNAdhObhUmau papAta; ");
INSERT INTO sancol_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","sa cAsIt zOmirONI| ");
INSERT INTO sancol_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","tadA yIzuravadat, dazajanAH kiM na pariSkRtAH? tahyanyE navajanAH kutra? ");
INSERT INTO sancol_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","IzvaraM dhanyaM vadantam EnaM vidEzinaM vinA kOpyanyO na prApyata| ");
INSERT INTO sancol_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","tadA sa tamuvAca, tvamutthAya yAhi vizvAsastE tvAM svasthaM kRtavAn| ");
INSERT INTO sancol_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","atha kadEzvarasya rAjatvaM bhaviSyatIti phirUzibhiH pRSTE sa pratyuvAca, Izvarasya rAjatvam aizvaryyadarzanEna na bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ata Etasmin pazya tasmin vA pazya, iti vAkyaM lOkA vaktuM na zakSyanti, Izvarasya rAjatvaM yuSmAkam antarEvAstE| ");
INSERT INTO sancol_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","tataH sa ziSyAn jagAda, yadA yuSmAbhi rmanujasutasya dinamEkaM draSTum vAnjchiSyatE kintu na darziSyatE, IdRkkAla AyAti| ");
INSERT INTO sancol_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","tadAtra pazya vA tatra pazyEti vAkyaM lOkA vakSyanti, kintu tESAM pazcAt mA yAta, mAnugacchata ca| ");
INSERT INTO sancol_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","yatastaPid yathAkAzaikadizyudiya tadanyAmapi dizaM vyApya prakAzatE tadvat nijadinE manujasUnuH prakAziSyatE| ");
INSERT INTO sancol_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","kintu tatpUrvvaM tEnAnEkAni duHkhAni bhOktavyAnyEtadvarttamAnalOkaizca sO'vajnjAtavyaH| ");
INSERT INTO sancol_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","nOhasya vidyamAnakAlE yathAbhavat manuSyasUnOH kAlEpi tathA bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","yAvatkAlaM nOhO mahApOtaM nArOhad AplAvivAryyEtya sarvvaM nAnAzayacca tAvatkAlaM yathA lOkA abhunjjatApivan vyavahan vyavAhayaMzca; ");
INSERT INTO sancol_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","itthaM lOTO varttamAnakAlEpi yathA lOkA bhOjanapAnakrayavikrayarOpaNagRhanirmmANakarmmasu prAvarttanta, ");
INSERT INTO sancol_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","kintu yadA lOT sidOmO nirjagAma tadA nabhasaH sagandhakAgnivRSTi rbhUtvA sarvvaM vyanAzayat ");
INSERT INTO sancol_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","tadvan mAnavaputraprakAzadinEpi bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","tadA yadi kazcid gRhOpari tiSThati tarhi sa gRhamadhyAt kimapi dravyamAnEtum avaruhya naitu; yazca kSEtrE tiSThati sOpi vyAghuTya nAyAtu| ");
INSERT INTO sancol_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","lOTaH patnIM smarata| ");
INSERT INTO sancol_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","yaH prANAn rakSituM cESTiSyatE sa prANAn hArayiSyati yastu prANAn hArayiSyati saEva prANAn rakSiSyati| ");
INSERT INTO sancol_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","yuSmAnahaM vacmi tasyAM rAtrau zayyaikagatayO rlOkayOrEkO dhAriSyatE parastyakSyatE| ");
INSERT INTO sancol_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","striyau yugapat pESaNIM vyAvarttayiSyatastayOrEkA dhAriSyatE parAtyakSyatE| ");
INSERT INTO sancol_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","puruSau kSEtrE sthAsyatastayOrEkO dhAriSyatE parastyakSyatE| ");
INSERT INTO sancol_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","tadA tE papracchuH, hE prabhO kutrEtthaM bhaviSyati? tataH sa uvAca, yatra zavastiSThati tatra gRdhrA milanti| ");
INSERT INTO sancol_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","aparanjca lOkairaklAntai rnirantaraM prArthayitavyam ityAzayEna yIzunA dRSTAnta EkaH kathitaH| ");
INSERT INTO sancol_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","kutracinnagarE kazcit prAPvivAka AsIt sa IzvarAnnAbibhEt mAnuSAMzca nAmanyata| ");
INSERT INTO sancol_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","atha tatpuravAsinI kAcidvidhavA tatsamIpamEtya vivAdinA saha mama vivAdaM pariSkurvviti nivEdayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","tataH sa prAPvivAkaH kiyaddinAni na tadaggIkRtavAn pazcAccittE cintayAmAsa, yadyapIzvarAnna bibhEmi manuSyAnapi na manyE ");
INSERT INTO sancol_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","tathApyESA vidhavA mAM kliznAti tasmAdasyA vivAdaM pariSkariSyAmi nOcEt sA sadAgatya mAM vyagraM kariSyati| ");
INSERT INTO sancol_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","pazcAt prabhuravadad asAvanyAyaprAPvivAkO yadAha tatra manO nidhadhvaM| ");
INSERT INTO sancol_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Izvarasya yE 'bhirucitalOkA divAnizaM prArthayantE sa bahudinAni vilambyApi tESAM vivAdAn kiM na pariSkariSyati? ");
INSERT INTO sancol_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","yuSmAnahaM vadAmi tvarayA pariSkariSyati, kintu yadA manuSyaputra AgamiSyati tadA pRthivyAM kimIdRzaM vizvAsaM prApsyati? ");
INSERT INTO sancol_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","yE svAn dhArmmikAn jnjAtvA parAn tucchIkurvvanti EtAdRgbhyaH, kiyadbhya imaM dRSTAntaM kathayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","EkaH phirUzyaparaH karasanjcAyI dvAvimau prArthayituM mandiraM gatau| ");
INSERT INTO sancol_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","tatO'sau phirUzyEkapArzvE tiSThan hE Izvara ahamanyalOkavat lOThayitAnyAyI pAradArikazca na bhavAmi asya karasanjcAyinastulyazca na, tasmAttvAM dhanyaM vadAmi| ");
INSERT INTO sancol_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","saptasu dinESu dinadvayamupavasAmi sarvvasampattE rdazamAMzaM dadAmi ca, EtatkathAM kathayan prArthayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","kintu sa karasanjcAyi dUrE tiSThan svargaM draSTuM nEcchan vakSasi karAghAtaM kurvvan hE Izvara pApiSThaM mAM dayasva, itthaM prArthayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","yuSmAnahaM vadAmi, tayOrdvayO rmadhyE kEvalaH karasanjcAyI puNyavattvEna gaNitO nijagRhaM jagAma, yatO yaH kazcit svamunnamayati sa nAmayiSyatE kintu yaH kazcit svaM namayati sa unnamayiSyatE| ");
INSERT INTO sancol_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","atha zizUnAM gAtrasparzArthaM lOkAstAn tasya samIpamAninyuH ziSyAstad dRSTvAnEtRn tarjayAmAsuH, ");
INSERT INTO sancol_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","kintu yIzustAnAhUya jagAda, mannikaTam AgantuM zizUn anujAnIdhvaM tAMzca mA vArayata; yata IzvararAjyAdhikAriNa ESAM sadRzAH| ");
INSERT INTO sancol_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ahaM yuSmAn yathArthaM vadAmi, yO janaH zizOH sadRzO bhUtvA IzvararAjyaM na gRhlAti sa kEnApi prakArENa tat pravESTuM na zaknOti| ");
INSERT INTO sancol_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","aparam EkOdhipatistaM papraccha, hE paramagurO, anantAyuSaH prAptayE mayA kiM karttavyaM? ");
INSERT INTO sancol_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","yIzuruvAca, mAM kutaH paramaM vadasi? IzvaraM vinA kOpi paramO na bhavati| ");
INSERT INTO sancol_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","paradArAn mA gaccha, naraM mA jahi, mA cOraya, mithyAsAkSyaM mA dEhi, mAtaraM pitaranjca saMmanyasva, EtA yA AjnjAH santi tAstvaM jAnAsi| ");
INSERT INTO sancol_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","tadA sa uvAca, bAlyakAlAt sarvvA EtA AcarAmi| ");
INSERT INTO sancol_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","iti kathAM zrutvA yIzustamavadat, tathApi tavaikaM karmma nyUnamAstE, nijaM sarvvasvaM vikrIya daridrEbhyO vitara, tasmAt svargE dhanaM prApsyasi; tata Agatya mamAnugAmI bhava| ");
INSERT INTO sancol_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","kintvEtAM kathAM zrutvA sOdhipatiH zuzOca, yatastasya bahudhanamAsIt| ");
INSERT INTO sancol_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","tadA yIzustamatizOkAnvitaM dRSTvA jagAda, dhanavatAm IzvararAjyapravEzaH kIdRg duSkaraH| ");
INSERT INTO sancol_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","IzvararAjyE dhaninaH pravEzAt sUcEzchidrENa mahAggasya gamanAgamanE sukarE| ");
INSERT INTO sancol_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","zrOtAraH papracchustarhi kEna paritrANaM prApsyatE? ");
INSERT INTO sancol_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","sa uktavAn, yan mAnuSENAzakyaM tad IzvarENa zakyaM| ");
INSERT INTO sancol_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","tadA pitara uvAca, pazya vayaM sarvvasvaM parityajya tava pazcAdgAminO'bhavAma| ");
INSERT INTO sancol_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","tataH sa uvAca, yuSmAnahaM yathArthaM vadAmi, IzvararAjyArthaM gRhaM pitarau bhrAtRgaNaM jAyAM santAnAMzca tyaktavA ");
INSERT INTO sancol_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","iha kAlE tatO'dhikaM parakAlE 'nantAyuzca na prApsyati lOka IdRzaH kOpi nAsti| ");
INSERT INTO sancol_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","anantaraM sa dvAdazaziSyAnAhUya babhASE, pazyata vayaM yirUzAlamnagaraM yAmaH, tasmAt manuSyaputrE bhaviSyadvAdibhiruktaM yadasti tadanurUpaM taM prati ghaTiSyatE; ");
INSERT INTO sancol_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","vastutastu sO'nyadEzIyAnAM hastESu samarpayiSyatE, tE tamupahasiSyanti, anyAyamAcariSyanti tadvapuSi niSThIvaM nikSEpsyanti, kazAbhiH prahRtya taM haniSyanti ca, ");
INSERT INTO sancol_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","kintu tRtIyadinE sa zmazAnAd utthAsyati| ");
INSERT INTO sancol_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","EtasyAH kathAyA abhiprAyaM kinjcidapi tE bOddhuM na zEkuH tESAM nikaTE'spaSTatavAt tasyaitAsAM kathAnAm AzayaM tE jnjAtuM na zEkuzca| ");
INSERT INTO sancol_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","atha tasmin yirIhOH purasyAntikaM prAptE kazcidandhaH pathaH pArzva upavizya bhikSAm akarOt ");
INSERT INTO sancol_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","sa lOkasamUhasya gamanazabdaM zrutvA tatkAraNaM pRSTavAn| ");
INSERT INTO sancol_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","nAsaratIyayIzuryAtIti lOkairuktE sa uccairvaktumArEbhE, ");
INSERT INTO sancol_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","hE dAyUdaH santAna yIzO mAM dayasva| ");
INSERT INTO sancol_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","tatOgragAminastaM maunI tiSThEti tarjayAmAsuH kintu sa punAruvan uvAca, hE dAyUdaH santAna mAM dayasva| ");
INSERT INTO sancol_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","tadA yIzuH sthagitO bhUtvA svAntikE tamAnEtum AdidEza| ");
INSERT INTO sancol_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","tataH sa tasyAntikam Agamat, tadA sa taM papraccha, tvaM kimicchasi? tvadarthamahaM kiM kariSyAmi? sa uktavAn, hE prabhO'haM draSTuM labhai| ");
INSERT INTO sancol_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","tadA yIzuruvAca, dRSTizaktiM gRhANa tava pratyayastvAM svasthaM kRtavAn| ");
INSERT INTO sancol_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","tatastatkSaNAt tasya cakSuSI prasannE; tasmAt sa IzvaraM dhanyaM vadan tatpazcAd yayau, tadAlOkya sarvvE lOkA IzvaraM prazaMsitum ArEbhirE| ");
INSERT INTO sancol_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","yadA yIzu ryirIhOpuraM pravizya tanmadhyEna gacchaMstadA ");
INSERT INTO sancol_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","sakkEyanAmA karasanjcAyinAM pradhAnO dhanavAnEkO ");
INSERT INTO sancol_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","yIzuH kIdRgiti draSTuM cESTitavAn kintu kharvvatvAllOkasaMghamadhyE taddarzanamaprApya ");
INSERT INTO sancol_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","yEna pathA sa yAsyati tatpathE'grE dhAvitvA taM draSTum uPumbaratarumArurOha| ");
INSERT INTO sancol_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","pazcAd yIzustatsthAnam itvA UrddhvaM vilOkya taM dRSTvAvAdIt, hE sakkEya tvaM zIghramavarOha mayAdya tvadgEhE vastavyaM| ");
INSERT INTO sancol_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","tataH sa zIghramavaruhya sAhlAdaM taM jagrAha| ");
INSERT INTO sancol_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","tad dRSTvA sarvvE vivadamAnA vaktumArEbhirE, sOtithitvEna duSTalOkagRhaM gacchati| ");
INSERT INTO sancol_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","kintu sakkEyO daNPAyamAnO vaktumArEbhE, hE prabhO pazya mama yA sampattirasti tadarddhaM daridrEbhyO dadE, aparam anyAyaM kRtvA kasmAdapi yadi kadApi kinjcit mayA gRhItaM tarhi taccaturguNaM dadAmi| ");
INSERT INTO sancol_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","tadA yIzustamuktavAn ayamapi ibrAhImaH santAnO'taH kAraNAd adyAsya gRhE trANamupasthitaM| ");
INSERT INTO sancol_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","yad hAritaM tat mRgayituM rakSitunjca manuSyaputra AgatavAn| ");
INSERT INTO sancol_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","atha sa yirUzAlamaH samIpa upAtiSThad IzvararAjatvasyAnuSThAnaM tadaiva bhaviSyatIti lOkairanvabhUyata, tasmAt sa zrOtRbhyaH punardRSTAntakathAm utthApya kathayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","kOpi mahAllOkO nijArthaM rAjatvapadaM gRhItvA punarAgantuM dUradEzaM jagAma| ");
INSERT INTO sancol_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","yAtrAkAlE nijAn dazadAsAn AhUya dazasvarNamudrA dattvA mamAgamanaparyyantaM vANijyaM kurutEtyAdidEza| ");
INSERT INTO sancol_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","kintu tasya prajAstamavajnjAya manuSyamEnam asmAkamupari rAjatvaM na kArayivyAma imAM vArttAM tannikaTE prErayAmAsuH| ");
INSERT INTO sancol_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","atha sa rAjatvapadaM prApyAgatavAn EkaikO janO bANijyEna kiM labdhavAn iti jnjAtuM yESu dAsESu mudrA arpayat tAn AhUyAnEtum AdidEza| ");
INSERT INTO sancol_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","tadA prathama Agatya kathitavAn, hE prabhO tava tayaikayA mudrayA dazamudrA labdhAH| ");
INSERT INTO sancol_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","tataH sa uvAca tvamuttamO dAsaH svalpEna vizvAsyO jAta itaH kAraNAt tvaM dazanagarANAm adhipO bhava| ");
INSERT INTO sancol_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","dvitIya Agatya kathitavAn, hE prabhO tavaikayA mudrayA panjcamudrA labdhAH| ");
INSERT INTO sancol_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","tataH sa uvAca, tvaM panjcAnAM nagarANAmadhipati rbhava| ");
INSERT INTO sancol_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","tatOnya Agatya kathayAmAsa, hE prabhO pazya tava yA mudrA ahaM vastrE baddhvAsthApayaM sEyaM| ");
INSERT INTO sancol_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","tvaM kRpaNO yannAsthApayastadapi gRhlAsi, yannAvapastadEva ca chinatsi tatOhaM tvattO bhItaH| ");
INSERT INTO sancol_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","tadA sa jagAda, rE duSTadAsa tava vAkyEna tvAM dOSiNaM kariSyAmi, yadahaM nAsthApayaM tadEva gRhlAmi, yadahaM nAvapanjca tadEva chinadmi, EtAdRzaH kRpaNOhamiti yadi tvaM jAnAsi, ");
INSERT INTO sancol_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","tarhi mama mudrA baNijAM nikaTE kutO nAsthApayaH? tayA kRtE'ham Agatya kusIdEna sArddhaM nijamudrA aprApsyam| ");
INSERT INTO sancol_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","pazcAt sa samIpasthAn janAn AjnjApayat asmAt mudrA AnIya yasya dazamudrAH santi tasmai datta| ");
INSERT INTO sancol_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","tE prOcuH prabhO'sya dazamudrAH santi| ");
INSERT INTO sancol_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","yuSmAnahaM vadAmi yasyAzrayE vaddhatE 'dhikaM tasmai dAyiSyatE, kintu yasyAzrayE na varddhatE tasya yadyadasti tadapi tasmAn nAyiSyatE| ");
INSERT INTO sancol_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","kintu mamAdhipatitvasya vazatvE sthAtum asammanyamAnA yE mama ripavastAnAnIya mama samakSaM saMharata| ");
INSERT INTO sancol_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ityupadEzakathAM kathayitvA sOgragaH san yirUzAlamapuraM yayau| ");
INSERT INTO sancol_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","tatO baitphagIbaithanIyAgrAmayOH samIpE jaitunAdrErantikam itvA ziSyadvayam ityuktvA prESayAmAsa, ");
INSERT INTO sancol_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","yuvAmamuM sammukhasthagrAmaM pravizyaiva yaM kOpi mAnuSaH kadApi nArOhat taM garddabhazAvakaM baddhaM drakSyathastaM mOcayitvAnayataM| ");
INSERT INTO sancol_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","tatra kutO mOcayathaH? iti cEt kOpi vakSyati tarhi vakSyathaH prabhEाratra prayOjanam AstE| ");
INSERT INTO sancol_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","tadA tau praritau gatvA tatkathAाnusArENa sarvvaM prAptau| ");
INSERT INTO sancol_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","gardabhazAvakamOcanakAlE tatvAmina UcuH, gardabhazAvakaM kutO mOcayathaH? ");
INSERT INTO sancol_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","tAvUcatuH prabhOratra prayOjanam AstE| ");
INSERT INTO sancol_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","pazcAt tau taM gardabhazAvakaM yIzOrantikamAnIya tatpRSThE nijavasanAni pAtayitvA tadupari yIzumArOhayAmAsatuH| ");
INSERT INTO sancol_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","atha yAtrAkAlE lOkAH pathi svavastrANi pAtayitum ArEbhirE| ");
INSERT INTO sancol_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","aparaM jaitunAdrErupatyakAm itvA ziSyasaMghaH pUrvvadRSTAni mahAkarmmANi smRtvA, ");
INSERT INTO sancol_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","yO rAjA prabhO rnAmnAyAti sa dhanyaH svargE kuzalaM sarvvOccE jayadhvani rbhavatu, kathAmEtAM kathayitvA sAnandam ucairIzvaraM dhanyaM vaktumArEbhE| ");
INSERT INTO sancol_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","tadA lOkAraNyamadhyasthAH kiyantaH phirUzinastat zrutvA yIzuM prOcuH, hE upadEzaka svaziSyAn tarjaya| ");
INSERT INTO sancol_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","sa uvAca, yuSmAnahaM vadAmi yadyamI nIravAstiSThanti tarhi pASANA ucaiH kathAH kathayiSyanti| ");
INSERT INTO sancol_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","pazcAt tatpurAntikamEtya tadavalOkya sAzrupAtaM jagAda, ");
INSERT INTO sancol_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","hA hA cEt tvamagrE'jnjAsyathAH, tavAsminnEva dinE vA yadi svamaggalam upAlapsyathAH, tarhyuttamam abhaviSyat, kintu kSaNEsmin tattava dRSTEragOcaram bhavati| ");
INSERT INTO sancol_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","tvaM svatrANakAlE na manO nyadhatthA iti hEtO ryatkAlE tava ripavastvAM caturdikSu prAcIrENa vESTayitvA rOtsyanti ");
INSERT INTO sancol_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","bAlakaiH sArddhaM bhUmisAt kariSyanti ca tvanmadhyE pASANaikOpi pASANOpari na sthAsyati ca, kAla IdRza upasthAsyati| ");
INSERT INTO sancol_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","atha madhyEmandiraM pravizya tatratyAn krayivikrayiNO bahiSkurvvan ");
INSERT INTO sancol_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","avadat madgRhaM prArthanAgRhamiti lipirAstE kintu yUyaM tadEva cairANAM gahvaraM kurutha| ");
INSERT INTO sancol_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","pazcAt sa pratyahaM madhyEmandiram upadidEza; tataH pradhAnayAjakA adhyApakAH prAcInAzca taM nAzayituM cicESTirE; ");
INSERT INTO sancol_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","kintu tadupadEzE sarvvE lOkA niviSTacittAH sthitAstasmAt tE tatkarttuM nAvakAzaM prApuH| ");
INSERT INTO sancol_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","athaikadA yIzu rmanidarE susaMvAdaM pracArayan lOkAnupadizati, Etarhi pradhAnayAjakA adhyApakAH prAnjcazca tannikaTamAgatya papracchuH ");
INSERT INTO sancol_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","kayAjnjayA tvaM karmmANyEtAni karOSi? kO vA tvAmAjnjApayat? tadasmAn vada| ");
INSERT INTO sancol_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","sa pratyuvAca, tarhi yuSmAnapi kathAmEkAM pRcchAmi tasyOttaraM vadata| ");
INSERT INTO sancol_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","yOhanO majjanam Izvarasya mAnuSANAM vAjnjAtO jAtaM? ");
INSERT INTO sancol_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","tatastE mithO vivicya jagaduH, yadIzvarasya vadAmastarhi taM kutO na pratyaita sa iti vakSyati| ");
INSERT INTO sancol_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","yadi manuSyasyEti vadAmastarhi sarvvE lOkA asmAn pASANai rhaniSyanti yatO yOhan bhaviSyadvAdIti sarvvE dRPhaM jAnanti| ");
INSERT INTO sancol_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","ataEva tE pratyUcuH kasyAjnjayA jAtam iti vaktuM na zaknumaH| ");
INSERT INTO sancol_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","tadA yIzuravadat tarhi kayAjnjayA karmmANyEtAti karOmIti ca yuSmAn na vakSyAmi| ");
INSERT INTO sancol_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","atha lOkAnAM sAkSAt sa imAM dRSTAntakathAM vaktumArEbhE, kazcid drAkSAkSEtraM kRtvA tat kSEtraM kRSIvalAnAM hastESu samarpya bahukAlArthaM dUradEzaM jagAma| ");
INSERT INTO sancol_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","atha phalakAlE phalAni grahItu kRSIvalAnAM samIpE dAsaM prAhiNOt kintu kRSIvalAstaM prahRtya riktahastaM visasarjuH| ");
INSERT INTO sancol_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","tataH sOdhipatiH punaranyaM dAsaM prESayAmAsa, tE tamapi prahRtya kuvyavahRtya riktahastaM visasRjuH| ");
INSERT INTO sancol_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","tataH sa tRtIyavAram anyaM prAhiNOt tE tamapi kSatAggaM kRtvA bahi rnicikSipuH| ");
INSERT INTO sancol_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","tadA kSEtrapati rvicArayAmAsa, mamEdAnIM kiM karttavyaM? mama priyE putrE prahitE tE tamavazyaM dRSTvA samAdariSyantE| ");
INSERT INTO sancol_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","kintu kRSIvalAstaM nirIkSya parasparaM vivicya prOcuH, ayamuttarAdhikArI AgacchatainaM hanmastatOdhikArOsmAkaM bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","tatastE taM kSEtrAd bahi rnipAtya jaghnustasmAt sa kSEtrapatistAn prati kiM kariSyati? ");
INSERT INTO sancol_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","sa Agatya tAn kRSIvalAn hatvA parESAM hastESu tatkSEtraM samarpayiSyati; iti kathAM zrutvA tE 'vadan EtAdRzI ghaTanA na bhavatu| ");
INSERT INTO sancol_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","kintu yIzustAnavalOkya jagAda, tarhi, sthapatayaH kariSyanti grAvANaM yantu tucchakaM| pradhAnaprastaraH kONE sa Eva hi bhaviSyati| Etasya zAstrIyavacanasya kiM tAtparyyaM? ");
INSERT INTO sancol_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","aparaM tatpASANOpari yaH patiSyati sa bhaMkSyatE kintu yasyOpari sa pASANaH patiSyati sa tEna dhUlivac cUrNIbhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","sOsmAkaM viruddhaM dRSTAntamimaM kathitavAn iti jnjAtvA pradhAnayAjakA adhyApakAzca tadaiva taM dhartuM vavAnjchuH kintu lOkEbhyO bibhyuH| ");
INSERT INTO sancol_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ataEva taM prati satarkAH santaH kathaM tadvAkyadOSaM dhRtvA taM dEzAdhipasya sAdhuvEzadhAriNazcarAn tasya samIpE prESayAmAsuH| ");
INSERT INTO sancol_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","tadA tE taM papracchuH, hE upadEzaka bhavAn yathArthaM kathayan upadizati, kamapyanapEkSya satyatvEnaizvaraM mArgamupadizati, vayamEtajjAnImaH| ");
INSERT INTO sancol_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","kaisararAjAya karOsmAbhi rdEyO na vA? ");
INSERT INTO sancol_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","sa tESAM vanjcanaM jnjAtvAvadat kutO mAM parIkSadhvE? mAM mudrAmEkaM darzayata| ");
INSERT INTO sancol_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","iha likhitA mUrtiriyaM nAma ca kasya? tE'vadan kaisarasya| ");
INSERT INTO sancol_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","tadA sa uvAca, tarhi kaisarasya dravyaM kaisarAya datta; Izvarasya tu dravyamIzvarAya datta| ");
INSERT INTO sancol_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","tasmAllOkAnAM sAkSAt tatkathAyAH kamapi dOSaM dhartumaprApya tE tasyOttarAd AzcaryyaM manyamAnA mauninastasthuH| ");
INSERT INTO sancol_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","aparanjca zmazAnAdutthAnAnaggIkAriNAM sidUkinAM kiyantO janA Agatya taM papracchuH, ");
INSERT INTO sancol_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","hE upadEzaka zAstrE mUsA asmAn pratIti lilEkha yasya bhrAtA bhAryyAyAM satyAM niHsantAnO mriyatE sa tajjAyAM vivahya tadvaMzam utpAdayiSyati| ");
INSERT INTO sancol_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","tathAca kEcit sapta bhrAtara Asan tESAM jyESThO bhrAtA vivahya nirapatyaH prANAn jahau| ");
INSERT INTO sancol_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","atha dvitIyastasya jAyAM vivahya nirapatyaH san mamAra| tRtIyazca tAmEva vyuvAha; ");
INSERT INTO sancol_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","itthaM sapta bhrAtarastAmEva vivahya nirapatyAH santO mamruH| ");
INSERT INTO sancol_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","zESE sA strI ca mamAra| ");
INSERT INTO sancol_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ataEva zmazAnAdutthAnakAlE tESAM saptajanAnAM kasya sA bhAryyA bhaviSyati? yataH sA tESAM saptAnAmEva bhAryyAsIt| ");
INSERT INTO sancol_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","tadA yIzuH pratyuvAca, Etasya jagatO lOkA vivahanti vAgdattAzca bhavanti ");
INSERT INTO sancol_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","kintu yE tajjagatprAptiyOgyatvEna gaNitAM bhaviSyanti zmazAnAccOtthAsyanti tE na vivahanti vAgdattAzca na bhavanti, ");
INSERT INTO sancol_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","tE puna rna mriyantE kintu zmazAnAdutthApitAH santa Izvarasya santAnAH svargIyadUtAnAM sadRzAzca bhavanti| ");
INSERT INTO sancol_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","adhikantu mUsAH stambOpAkhyAnE paramEzvara IbrAhIma Izvara ishAka IzvarO yAkUbazcEzvara ityuktvA mRtAnAM zmazAnAd utthAnasya pramANaM lilEkha| ");
INSERT INTO sancol_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ataEva ya IzvaraH sa mRtAnAM prabhu rna kintu jIvatAmEva prabhuH, tannikaTE sarvvE jIvantaH santi| ");
INSERT INTO sancol_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","iti zrutvA kiyantOdhyApakA UcuH, hE upadEzaka bhavAn bhadraM pratyuktavAn| ");
INSERT INTO sancol_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","itaH paraM taM kimapi praSTaM tESAM pragalbhatA nAbhUt| ");
INSERT INTO sancol_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","pazcAt sa tAn uvAca, yaH khrISTaH sa dAyUdaH santAna EtAM kathAM lOkAH kathaM kathayanti? ");
INSERT INTO sancol_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","yataH mama prabhumidaM vAkyamavadat paramEzvaraH| tava zatrUnahaM yAvat pAdapIThaM karOmi na| tAvat kAlaM madIyE tvaM dakSapArzva upAviza| ");
INSERT INTO sancol_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","iti kathAM dAyUd svayaM gItagranthE'vadat| ");
INSERT INTO sancol_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","ataEva yadi dAyUd taM prabhuM vadati, tarhi sa kathaM tasya santAnO bhavati? ");
INSERT INTO sancol_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","pazcAd yIzuH sarvvajanAnAM karNagOcarE ziSyAnuvAca, ");
INSERT INTO sancol_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","yE'dhyApakA dIrghaparicchadaM paridhAya bhramanti, haTTApaNayO rnamaskArE bhajanagEhasya prOccAsanE bhOjanagRhasya pradhAnasthAnE ca prIyantE ");
INSERT INTO sancol_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","vidhavAnAM sarvvasvaM grasitvA chalEna dIrghakAlaM prArthayantE ca tESu sAvadhAnA bhavata, tESAmugradaNPO bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","atha dhanilOkA bhANPAgArE dhanaM nikSipanti sa tadEva pazyati, ");
INSERT INTO sancol_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Etarhi kAciddInA vidhavA paNadvayaM nikSipati tad dadarza| ");
INSERT INTO sancol_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","tatO yIzuruvAca yuSmAnahaM yathArthaM vadAmi, daridrEyaM vidhavA sarvvEbhyOdhikaM nyakSEpsIt, ");
INSERT INTO sancol_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","yatOnyE svaprAjyadhanEbhya IzvarAya kinjcit nyakSEpsuH, kintu daridrEyaM vidhavA dinayApanArthaM svasya yat kinjcit sthitaM tat sarvvaM nyakSEpsIt| ");
INSERT INTO sancol_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","aparanjca uttamaprastarairutsRSTavyaizca mandiraM suzObhatEtarAM kaizcidityuktE sa pratyuvAca ");
INSERT INTO sancol_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","yUyaM yadidaM nicayanaM pazyatha, asya pASANaikOpyanyapASANOpari na sthAsyati, sarvvE bhUsAdbhaviSyanti kAlOyamAyAti| ");
INSERT INTO sancol_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","tadA tE papracchuH, hE gurO ghaTanEdRzI kadA bhaviSyati? ghaTanAyA EtasyasazcihnaM vA kiM bhaviSyati? ");
INSERT INTO sancol_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","tadA sa jagAda, sAvadhAnA bhavata yathA yuSmAkaM bhramaM kOpi na janayati, khISTOhamityuktvA mama nAmrA bahava upasthAsyanti sa kAlaH prAyENOpasthitaH, tESAM pazcAnmA gacchata| ");
INSERT INTO sancol_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","yuddhasyOpaplavasya ca vArttAM zrutvA mA zagkadhvaM, yataH prathamam EtA ghaTanA avazyaM bhaviSyanti kintu nApAtE yugAntO bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","aparanjca kathayAmAsa, tadA dEzasya vipakSatvEna dEzO rAjyasya vipakSatvEna rAjyam utthAsyati, ");
INSERT INTO sancol_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","nAnAsthAnESu mahAbhUkampO durbhikSaM mArI ca bhaviSyanti, tathA vyOmamaNPalasya bhayagkaradarzanAnyazcaryyalakSaNAni ca prakAzayiSyantE| ");
INSERT INTO sancol_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","kintu sarvvAsAmEtAsAM ghaTanAnAM pUrvvaM lOkA yuSmAn dhRtvA tAPayiSyanti, bhajanAlayE kArAyAnjca samarpayiSyanti mama nAmakAraNAd yuSmAn bhUpAnAM zAsakAnAnjca sammukhaM nESyanti ca| ");
INSERT INTO sancol_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","sAkSyArtham EtAni yuSmAn prati ghaTiSyantE| ");
INSERT INTO sancol_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","tadA kimuttaraM vaktavyam Etat na cintayiSyAma iti manaHsu nizcitanuta| ");
INSERT INTO sancol_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","vipakSA yasmAt kimapyuttaram Apattinjca karttuM na zakSyanti tAdRzaM vAkpaTutvaM jnjAnanjca yuSmabhyaM dAsyAmi| ");
INSERT INTO sancol_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","kinjca yUyaM pitrA mAtrA bhrAtrA bandhunA jnjAtyA kuTumbEna ca parakarESu samarpayiSyadhvE; tatastE yuSmAkaM kanjcana kanjcana ghAtayiSyanti| ");
INSERT INTO sancol_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","mama nAmnaH kAraNAt sarvvai rmanuSyai ryUyam RtIyiSyadhvE| ");
INSERT INTO sancol_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","kintu yuSmAkaM ziraHkEzaikOpi na vinaMkSyati, ");
INSERT INTO sancol_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","tasmAdEva dhairyyamavalambya svasvaprANAn rakSata| ");
INSERT INTO sancol_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","aparanjca yirUzAlampuraM sainyavESTitaM vilOkya tasyOcchinnatAyAH samayaH samIpa ityavagamiSyatha| ");
INSERT INTO sancol_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","tadA yihUdAdEzasthA lOkAH parvvataM palAyantAM, yE ca nagarE tiSThanti tE dEzAntaraM palAyantA, yE ca grAmE tiSThanti tE nagaraM na pravizantu, ");
INSERT INTO sancol_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","yatastadA samucitadaNPanAya dharmmapustakE yAni sarvvANi likhitAni tAni saphalAni bhaviSyanti| ");
INSERT INTO sancol_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","kintu yA yAstadA garbhavatyaH stanyadAvyazca tAmAM durgati rbhaviSyati, yata EtAllOkAn prati kOpO dEzE ca viSamadurgati rghaTiSyatE| ");
INSERT INTO sancol_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","vastutastu tE khaggadhAraparivvaggaM lapsyantE baddhAH santaH sarvvadEzESu nAyiSyantE ca kinjcAnyadEzIyAnAM samayOpasthitiparyyantaM yirUzAlampuraM taiH padatalai rdalayiSyatE| ");
INSERT INTO sancol_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","sUryyacandranakSatrESu lakSaNAdi bhaviSyanti, bhuvi sarvvadEzIyAnAM duHkhaM cintA ca sindhau vIcInAM tarjanaM garjananjca bhaviSyanti| ");
INSERT INTO sancol_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","bhUbhau bhAvighaTanAM cintayitvA manujA bhiyAmRtakalpA bhaviSyanti, yatO vyOmamaNPalE tEjasvinO dOlAyamAnA bhaviSyanti| ");
INSERT INTO sancol_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","tadA parAkramENA mahAtEjasA ca mEghArUPhaM manuSyaputram AyAntaM drakSyanti| ");
INSERT INTO sancol_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","kintvEtAsAM ghaTanAnAmArambhE sati yUyaM mastakAnyuttOlya UrdadhvaM drakSyatha, yatO yuSmAkaM muktEH kAlaH savidhO bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","tatastEnaitadRSTAntakathA kathitA, pazyata uPumbarAdivRkSANAM ");
INSERT INTO sancol_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","navInapatrANi jAtAnIti dRSTvA nidAvakAla upasthita iti yathA yUyaM jnjAtuM zaknutha, ");
INSERT INTO sancol_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","tathA sarvvAsAmAsAM ghaTanAnAm ArambhE dRSTE satIzvarasya rAjatvaM nikaTam ityapi jnjAsyatha| ");
INSERT INTO sancol_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","yuSmAnahaM yathArthaM vadAmi, vidyamAnalOkAnAmESAM gamanAt pUrvvam EtAni ghaTiSyantE| ");
INSERT INTO sancol_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","nabhObhuvOrlOpO bhaviSyati mama vAk tu kadApi luptA na bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","ataEva viSamAzanEna pAnEna ca sAMmArikacintAbhizca yuSmAkaM cittESu mattESu taddinam akasmAd yuSmAn prati yathA nOpatiSThati tadarthaM svESu sAvadhAnAstiSThata| ");
INSERT INTO sancol_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","pRthivIsthasarvvalOkAn prati taddinam unmAtha iva upasthAsyati| ");
INSERT INTO sancol_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","yathA yUyam EtadbhAvighaTanA uttarttuM manujasutasya sammukhE saMsthAtunjca yOgyA bhavatha kAraNAdasmAt sAvadhAnAH santO nirantaraM prArthayadhvaM| ");
INSERT INTO sancol_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","aparanjca sa divA mandira upadizya rAcai jaitunAdriM gatvAtiSThat| ");
INSERT INTO sancol_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","tataH pratyUSE lAkAstatkathAM zrOtuM mandirE tadantikam Agacchan| ");
INSERT INTO sancol_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","aparanjca kiNvazUnyapUpOtsavasya kAla upasthitE ");
INSERT INTO sancol_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","pradhAnayAjakA adhyAyakAzca yathA taM hantuM zaknuvanti tathOpAyAm acESTanta kintu lOkEbhyO bibhyuH| ");
INSERT INTO sancol_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Etastin samayE dvAdazaziSyESu gaNita ISkariyOtIyarUPhimAn yO yihUdAstasyAntaHkaraNaM zaitAnAzritatvAt ");
INSERT INTO sancol_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","sa gatvA yathA yIzuM tESAM karESu samarpayituM zaknOti tathA mantraNAM pradhAnayAjakaiH sEnApatibhizca saha cakAra| ");
INSERT INTO sancol_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","tEna tE tuSTAstasmai mudrAM dAtuM paNaM cakruH| ");
INSERT INTO sancol_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","tataH sOggIkRtya yathA lOkAnAmagOcarE taM parakarESu samarpayituM zaknOti tathAvakAzaM cESTitumArEbhE| ");
INSERT INTO sancol_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","atha kiNvazUnyapUpOtmavadinE, arthAt yasmin dinE nistArOtsavasya mESO hantavyastasmin dinE ");
INSERT INTO sancol_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","yIzuH pitaraM yOhananjcAhUya jagAda, yuvAM gatvAsmAkaM bhOjanArthaM nistArOtsavasya dravyANyAsAdayataM| ");
INSERT INTO sancol_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","tadA tau papracchatuH kucAsAdayAvO bhavataH kEcchA? ");
INSERT INTO sancol_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","tadA sOvAdIt, nagarE praviSTE kazcijjalakumbhamAdAya yuvAM sAkSAt kariSyati sa yannivEzanaM pravizati yuvAmapi tannivEzanaM tatpazcAditvA nivEzanapatim iti vAkyaM vadataM, ");
INSERT INTO sancol_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","yatrAhaM nistArOtsavasya bhOjyaM ziSyaiH sArddhaM bhOktuM zaknOmi sAtithizAlAा kutra? kathAmimAM prabhustvAM pRcchati| ");
INSERT INTO sancol_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","tataH sa janO dvitIyaprakOSThIyam EkaM zastaM kOSThaM darzayiSyati tatra bhOjyamAsAdayataM| ");
INSERT INTO sancol_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","tatastau gatvA tadvAkyAnusArENa sarvvaM dRSdvA tatra nistArOtsavIyaM bhOjyamAsAdayAmAsatuH| ");
INSERT INTO sancol_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","atha kAla upasthitE yIzu rdvAdazabhiH prEritaiH saha bhOktumupavizya kathitavAn ");
INSERT INTO sancol_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","mama duHkhabhOgAt pUrvvaM yubhAbhiH saha nistArOtsavasyaitasya bhOjyaM bhOktuM mayAtivAnjchA kRtA| ");
INSERT INTO sancol_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","yuSmAn vadAmi, yAvatkAlam IzvararAjyE bhOjanaM na kariSyE tAvatkAlam idaM na bhOkSyE| ");
INSERT INTO sancol_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","tadA sa pAnapAtramAdAya Izvarasya guNAn kIrttayitvA tEbhyO datvAvadat, idaM gRhlIta yUyaM vibhajya pivata| ");
INSERT INTO sancol_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","yuSmAn vadAmi yAvatkAlam IzvararAjatvasya saMsthApanaM na bhavati tAvad drAkSAphalarasaM na pAsyAmi| ");
INSERT INTO sancol_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","tataH pUpaM gRhItvA IzvaraguNAn kIrttayitvA bhagktA tEbhyO datvAvadat, yuSmadarthaM samarpitaM yanmama vapustadidaM, Etat karmma mama smaraNArthaM kurudhvaM| ");
INSERT INTO sancol_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","atha bhOjanAntE tAdRzaM pAtraM gRhItvAvadat, yuSmatkRtE pAtitaM yanmama raktaM tEna nirNItanavaniyamarUpaM pAnapAtramidaM| ");
INSERT INTO sancol_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","pazyata yO mAM parakarESu samarpayiSyati sa mayA saha bhOjanAsana upavizati| ");
INSERT INTO sancol_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","yathA nirUpitamAstE tadanusArENA manuSyapuुtrasya gati rbhaviSyati kintu yastaM parakarESu samarpayiSyati tasya santApO bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","tadA tESAM kO jana Etat karmma kariSyati tat tE parasparaM praSTumArEbhirE| ");
INSERT INTO sancol_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","aparaM tESAM kO janaH zrESThatvEna gaNayiSyatE, atrArthE tESAM vivAdObhavat| ");
INSERT INTO sancol_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","asmAt kAraNAt sOvadat, anyadEzIyAnAM rAjAnaH prajAnAmupari prabhutvaM kurvvanti dAruNazAsanaM kRtvApi tE bhUpatitvEna vikhyAtA bhavanti ca| ");
INSERT INTO sancol_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","kintu yuSmAkaM tathA na bhaviSyati, yO yuSmAkaM zrESThO bhaviSyati sa kaniSThavad bhavatu, yazca mukhyO bhaviSyati sa sEvakavadbhavatu| ");
INSERT INTO sancol_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","bhOjanOpaviSTaparicArakayOH kaH zrESThaH? yO bhOjanAyOpavizati sa kiM zrESThO na bhavati? kintu yuSmAkaM madhyE'haM paricAraka_ivAsmi| ");
INSERT INTO sancol_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","aparanjca yuyaM mama parIkSAkAlE prathamamArabhya mayA saha sthitA ");
INSERT INTO sancol_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","EtatkAraNAt pitrA yathA madarthaM rAjyamEkaM nirUpitaM tathAhamapi yuSmadarthaM rAjyaM nirUpayAmi| ");
INSERT INTO sancol_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","tasmAn mama rAjyE bhOjanAsanE ca bhOjanapAnE kariSyadhvE siMhAsanESUpavizya cEsrAyElIyAnAM dvAdazavaMzAnAM vicAraM kariSyadhvE| ");
INSERT INTO sancol_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","aparaM prabhuruvAca, hE zimOn pazya tita_unA dhAnyAnIva yuSmAn zaitAn cAlayitum aicchat, ");
INSERT INTO sancol_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","kintu tava vizvAsasya lOpO yathA na bhavati Etat tvadarthaM prArthitaM mayA, tvanmanasi parivarttitE ca bhrAtRNAM manAMsi sthirIkuru| ");
INSERT INTO sancol_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","tadA sOvadat, hE prabhOhaM tvayA sArddhaM kArAM mRtinjca yAtuM majjitOsmi| ");
INSERT INTO sancol_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","tataH sa uvAca, hE pitara tvAM vadAmi, adya kukkuTaravAt pUrvvaM tvaM matparicayaM vAratrayam apahvOSyasE| ");
INSERT INTO sancol_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","aparaM sa papraccha, yadA mudrAsampuTaM khAdyapAtraM pAdukAnjca vinA yuSmAn prAhiNavaM tadA yuSmAkaM kasyApi nyUnatAsIt? tE prOcuH kasyApi na| ");
INSERT INTO sancol_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","tadA sOvadat kintvidAnIM mudrAsampuTaM khAdyapAtraM vA yasyAsti tEna tadgrahItavyaM, yasya ca kRpANOे nAsti tEna svavastraM vikrIya sa krEtavyaH| ");
INSERT INTO sancol_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","yatO yuSmAnahaM vadAmi, aparAdhijanaiH sArddhaM gaNitaH sa bhaviSyati| idaM yacchAstrIyaM vacanaM likhitamasti tanmayi phaliSyati yatO mama sambandhIyaM sarvvaM sEtsyati| ");
INSERT INTO sancol_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","tadA tE prOcuH prabhO pazya imau kRpANau| tataH sOvadad Etau yathESTau| ");
INSERT INTO sancol_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","atha sa tasmAdvahi rgatvA svAcArAnusArENa jaitunanAmAdriM jagAma ziSyAzca tatpazcAd yayuH| ");
INSERT INTO sancol_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","tatrOpasthAya sa tAnuvAca, yathA parIkSAyAM na patatha tadarthaM prArthayadhvaM| ");
INSERT INTO sancol_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","pazcAt sa tasmAd EkazarakSEpAd bahi rgatvA jAnunI pAtayitvA Etat prArthayAnjcakrE, ");
INSERT INTO sancol_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","hE pita ryadi bhavAn sammanyatE tarhi kaMsamEnaM mamAntikAd dUraya kintu madicchAnurUpaM na tvadicchAnurUpaM bhavatu| ");
INSERT INTO sancol_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","tadA tasmai zaktiM dAtuM svargIyadUtO darzanaM dadau| ");
INSERT INTO sancol_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","pazcAt sOtyantaM yAtanayA vyAkulO bhUtvA punardRPhaM prArthayAnjcakrE, tasmAd bRhacchONitabindava iva tasya svEdabindavaH pRthivyAM patitumArEbhirE| ");
INSERT INTO sancol_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","atha prArthanAta utthAya ziSyANAM samIpamEtya tAn manOduHkhinO nidritAn dRSTvAvadat ");
INSERT INTO sancol_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","kutO nidrAtha? parIkSAyAm apatanArthaM prarthayadhvaM| ");
INSERT INTO sancol_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","EtatkathAyAH kathanakAlE dvAdazaziSyANAM madhyE gaNitO yihUdAnAmA janatAsahitastESAm agrE calitvA yIzOzcumbanArthaM tadantikam Ayayau| ");
INSERT INTO sancol_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","tadA yIzuruvAca, hE yihUdA kiM cumbanEna manuSyaputraM parakarESu samarpayasi? ");
INSERT INTO sancol_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","tadA yadyad ghaTiSyatE tadanumAya saggibhiruktaM, hE prabhO vayaM ki khaggEna ghAtayiSyAmaH? ");
INSERT INTO sancol_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","tata EkaH karavAlEnAhatya pradhAnayAjakasya dAsasya dakSiNaM karNaM cicchEda| ");
INSERT INTO sancol_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","adhUnA nivarttasva ityuktvA yIzustasya zrutiM spRSTvA svasyaM cakAra| ");
INSERT INTO sancol_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","pazcAd yIzuH samIpasthAn pradhAnayAjakAn mandirasya sEnApatIn prAcInAMzca jagAda, yUyaM kRpANAn yaSTIMzca gRhItvA mAM kiM cOraM dharttumAyAtAH? ");
INSERT INTO sancol_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","yadAhaM yuSmAbhiH saha pratidinaM mandirE'tiSThaM tadA mAM dharttaM na pravRttAH, kintvidAnIM yuSmAkaM samayOndhakArasya cAdhipatyamasti| ");
INSERT INTO sancol_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","atha tE taM dhRtvA mahAyAjakasya nivEzanaM ninyuH| tataH pitarO dUrE dUrE pazcAditvA ");
INSERT INTO sancol_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","bRhatkOSThasya madhyE yatrAgniM jvAlayitvA lOkAH samEtyOpaviSTAstatra taiH sArddham upavivEza| ");
INSERT INTO sancol_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","atha vahnisannidhau samupavEzakAlE kAciddAsI manO nivizya taM nirIkSyAvadat pumAnayaM tasya saggE'sthAt| ");
INSERT INTO sancol_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","kintu sa tad apahnutyAvAdIt hE nAri tamahaM na paricinOmi| ");
INSERT INTO sancol_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","kSaNAntarE'nyajanastaM dRSTvAbravIt tvamapi tESAM nikarasyaikajanOsi| pitaraH pratyuvAca hE nara nAhamasmi| ");
INSERT INTO sancol_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","tataH sArddhadaNPadvayAt paraM punaranyO janO nizcitya babhASE, ESa tasya saggIti satyaM yatOyaM gAlIlIyO lOkaH| ");
INSERT INTO sancol_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","tadA pitara uvAca hE nara tvaM yad vadami tadahaM bOddhuM na zaknOmi, iti vAkyE kathitamAtrE kukkuTO rurAva| ");
INSERT INTO sancol_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","tadA prabhuNA vyAdhuTya pitarE nirIkSitE kRkavAkuravAt pUrvvaM mAM trirapahnOSyasE iti pUrvvOktaM tasya vAkyaM pitaraH smRtvA ");
INSERT INTO sancol_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","bahirgatvA mahAkhEdEna cakranda| ");
INSERT INTO sancol_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","tadA yai ryIzurdhRtastE tamupahasya praharttumArEbhirE| ");
INSERT INTO sancol_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","vastrENa tasya dRzau baddhvA kapOlE capETAghAtaM kRtvA papracchuH, kastE kapOlE capETAghAtaM kRtavAna? gaNayitvA tad vada| ");
INSERT INTO sancol_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","tadanyat tadviruddhaM bahunindAvAkyaM vaktumArEbhirE| ");
INSERT INTO sancol_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","atha prabhAtE sati lOkaprAnjcaH pradhAnayAjakA adhyApakAzca sabhAM kRtvA madhyEsabhaM yIzumAnIya papracchuH, tvam abhiSikatOsi na vAsmAn vada| ");
INSERT INTO sancol_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","sa pratyuvAca, mayA tasminnuktE'pi yUyaM na vizvasiSyatha| ");
INSERT INTO sancol_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","kasmiMzcidvAkyE yuSmAn pRSTE'pi mAM na taduttaraM vakSyatha na mAM tyakSyatha ca| ");
INSERT INTO sancol_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","kintvitaH paraM manujasutaH sarvvazaktimata Izvarasya dakSiNE pArzvE samupavEkSyati| ");
INSERT INTO sancol_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","tatastE papracchuH, rtiha tvamIzvarasya putraH? sa kathayAmAsa, yUyaM yathArthaM vadatha sa EvAhaM| ");
INSERT INTO sancol_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","tadA tE sarvvE kathayAmAsuH, rtiha sAkSyE'nsasmin asmAkaM kiM prayOjanaM? asya svamukhAdEva sAkSyaM prAptam| ");
INSERT INTO sancol_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","tataH sabhAsthAH sarvvalOkA utthAya taM pIlAtasammukhaM nItvAprOdya vaktumArEbhirE, ");
INSERT INTO sancol_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","svamabhiSiktaM rAjAnaM vadantaM kaimararAjAya karadAnaM niSEdhantaM rAjyaviparyyayaM kurttuM pravarttamAnam Ena prAptA vayaM| ");
INSERT INTO sancol_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","tadA pIlAtastaM pRSTavAn tvaM kiM yihUdIyAnAM rAjA? sa pratyuvAca tvaM satyamuktavAn| ");
INSERT INTO sancol_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","tadA pIlAtaH pradhAnayAjakAdilOkAn jagAd, ahamEtasya kamapyaparAdhaM nAptavAn| ");
INSERT INTO sancol_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","tatastE punaH sAhaminO bhUtvAvadan, ESa gAlIla EtatsthAnaparyyantE sarvvasmin yihUdAdEzE sarvvAllOkAnupadizya kupravRttiM grAhItavAn| ");
INSERT INTO sancol_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","tadA pIlAtO gAlIlapradEzasya nAma zrutvA papraccha, kimayaM gAlIlIyO lOkaH? ");
INSERT INTO sancol_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","tataH sa gAlIlpradEzIyahErOdrAjasya tadA sthitEstasya samIpE yIzuM prESayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","tadA hErOd yIzuM vilOkya santutOSa, yataH sa tasya bahuvRttAntazravaNAt tasya kinji्cadAzcaryyakarmma pazyati ityAzAM kRtvA bahukAlamArabhya taM draSTuM prayAsaM kRtavAn| ");
INSERT INTO sancol_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","tasmAt taM bahukathAH papraccha kintu sa tasya kasyApi vAkyasya pratyuttaraM nOvAca| ");
INSERT INTO sancol_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","atha pradhAnayAjakA adhyApakAzca prOttiSThantaH sAhasEna tamapavadituM prArEbhirE| ");
INSERT INTO sancol_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","hErOd tasya sEnAgaNazca tamavajnjAya upahAsatvEna rAjavastraM paridhApya punaH pIlAtaM prati taM prAhiNOt| ");
INSERT INTO sancol_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","pUrvvaM hErOdpIlAtayOH parasparaM vairabhAva AsIt kintu taddinE dvayO rmElanaM jAtam| ");
INSERT INTO sancol_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","pazcAt pIlAtaH pradhAnayAjakAn zAsakAn lOkAMzca yugapadAhUya babhASE, ");
INSERT INTO sancol_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","rAjyaviparyyayakArakOyam ityuktvA manuSyamEnaM mama nikaTamAnaiSTa kintu pazyata yuSmAkaM samakSam asya vicAraM kRtvApi prOktApavAdAnurUpENAsya kOpyaparAdhaH sapramANO na jAtaH, ");
INSERT INTO sancol_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","yUyanjca hErOdaH sannidhau prESitA mayA tatrAsya kOpyaparAdhastEnApi na prAptaH|pazyatAnEna vadhahEेtukaM kimapi nAparAddhaM| ");
INSERT INTO sancol_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","tasmAdEnaM tAPayitvA vihAsyAmi| ");
INSERT INTO sancol_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","tatrOtsavE tESAmEkO mOcayitavyaH| ");
INSERT INTO sancol_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","iti hEtOstE prOccairEkadA prOcuH, EnaM dUrIkRtya barabbAnAmAnaM mOcaya| ");
INSERT INTO sancol_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","sa barabbA nagara upaplavavadhAparAdhAbhyAM kArAyAM baddha AsIt| ");
INSERT INTO sancol_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","kintu pIlAtO yIzuM mOcayituM vAnjchan punastAnuvAca| ");
INSERT INTO sancol_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","tathApyEnaM kruzE vyadha kruzE vyadhEti vadantastE ruruvuH| ");
INSERT INTO sancol_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","tataH sa tRtIyavAraM jagAda kutaH? sa kiM karmma kRtavAn? nAhamasya kamapi vadhAparAdhaM prAptaH kEvalaM tAPayitvAmuM tyajAmi| ");
INSERT INTO sancol_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","tathApi tE punarEnaM kruzE vyadha ityuktvA prOccairdRPhaM prArthayAnjcakrirE; ");
INSERT INTO sancol_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","tataH pradhAnayAjakAdInAM kalaravE prabalE sati tESAM prArthanArUpaM karttuM pIlAta AdidEza| ");
INSERT INTO sancol_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","rAjadrOhavadhayOraparAdhEna kArAsthaM yaM janaM tE yayAcirE taM mOcayitvA yIzuM tESAmicchAyAM samArpayat| ");
INSERT INTO sancol_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","atha tE yIzuM gRhItvA yAnti, Etarhi grAmAdAgataM zimOnanAmAnaM kurINIyaM janaM dhRtvA yIzOH pazcAnnEtuM tasya skandhE kruzamarpayAmAsuH| ");
INSERT INTO sancol_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","tatO lOाkAraNyamadhyE bahustriyO rudatyO vilapantyazca yIzOH pazcAd yayuH| ");
INSERT INTO sancol_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","kintu sa vyAghuTya tA uvAca, hE yirUzAlamO nAryyO yuyaM madarthaM na ruditvA svArthaM svApatyArthanjca ruditi; ");
INSERT INTO sancol_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","pazyata yaH kadApi garbhavatyO nAbhavan stanyanjca nApAyayan tAdRzI rvandhyA yadA dhanyA vakSyanti sa kAla AyAti| ");
INSERT INTO sancol_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","tadA hE zailA asmAkamupari patata, hE upazailA asmAnAcchAdayata kathAmIdRzIM lOkA vakSyanti| ");
INSERT INTO sancol_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","yataH satEjasi zAkhini cEdEtad ghaTatE tarhi zuSkazAkhini kiM na ghaTiSyatE? ");
INSERT INTO sancol_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","tadA tE hantuM dvAvaparAdhinau tEna sArddhaM ninyuH| ");
INSERT INTO sancol_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","aparaM ziraHkapAlanAmakasthAnaM prApya taM kruzE vividhuH; taddvayOraparAdhinOrEkaM tasya dakSiNO tadanyaM vAmE kruzE vividhuH| ");
INSERT INTO sancol_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","tadA yIzurakathayat, hE pitarEtAn kSamasva yata EtE yat karmma kurvvanti tan na viduH; pazcAttE guTikApAtaM kRtvA tasya vastrANi vibhajya jagRhuH| ");
INSERT INTO sancol_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","tatra lOkasaMghastiSThan dadarza; tE tESAM zAsakAzca tamupahasya jagaduH, ESa itarAn rakSitavAn yadIzvarENAbhirucitO 'bhiSiktastrAtA bhavati tarhi svamadhunA rakSatu| ");
INSERT INTO sancol_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","tadanyaH sEnAgaNA Etya tasmai amlarasaM datvA parihasya prOvAca, ");
INSERT INTO sancol_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","cEttvaM yihUdIyAnAM rAjAsi tarhi svaM rakSa| ");
INSERT INTO sancol_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","yihUdIyAnAM rAjEti vAkyaM yUnAnIyarOmIyEbrIyAkSarai rlikhitaM tacchirasa UrddhvE'sthApyata| ");
INSERT INTO sancol_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","tadObhayapArzvayO rviddhau yAvaparAdhinau tayOrEkastaM vinindya babhASE, cEttvam abhiSiktOsi tarhi svamAvAnjca rakSa| ");
INSERT INTO sancol_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","kintvanyastaM tarjayitvAvadat, IzvarAttava kinjcidapi bhayaM nAsti kiM? tvamapi samAnadaNPOsi, ");
INSERT INTO sancol_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","yOgyapAtrE AvAM svasvakarmmaNAM samucitaphalaM prApnuvaH kintvanEna kimapi nAparAddhaM| ");
INSERT INTO sancol_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","atha sa yIzuM jagAda hE prabhE bhavAn svarAjyapravEzakAlE mAM smaratu| ");
INSERT INTO sancol_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","tadA yIzuH kathitavAn tvAM yathArthaM vadAmi tvamadyaiva mayA sArddhaM paralOkasya sukhasthAnaM prApsyasi| ");
INSERT INTO sancol_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","aparanjca dvitIyayAmAt tRtIyayAmaparyyantaM ravEstEjasOntarhitatvAt sarvvadEzO'ndhakArENAvRtO ");
INSERT INTO sancol_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","mandirasya yavanikA ca chidyamAnA dvidhA babhUva| ");
INSERT INTO sancol_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","tatO yIzuruccairuvAca, hE pita rmamAtmAnaM tava karE samarpayE, ityuktvA sa prANAn jahau| ");
INSERT INTO sancol_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","tadaitA ghaTanA dRSTvA zatasEnApatirIzvaraM dhanyamuktvA kathitavAn ayaM nitAntaM sAdhumanuSya AsIt| ");
INSERT INTO sancol_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","atha yAvantO lOkA draSTum AgatAstE tA ghaTanA dRSTvA vakSaHsu karAghAtaM kRtvA vyAcuTya gatAH| ");
INSERT INTO sancol_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","yIzO rjnjAtayO yA yA yOSitazca gAlIlastEna sArddhamAyAtAstA api dUrE sthitvA tat sarvvaM dadRzuH| ");
INSERT INTO sancol_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","tadA yihUdIyAnAM mantraNAM kriyAnjcAsammanyamAna Izvarasya rAjatvam apEkSamANO ");
INSERT INTO sancol_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","yihUdidEzIyO 'rimathIyanagarIyO yUSaphnAmA mantrI bhadrO dhArmmikazca pumAn ");
INSERT INTO sancol_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","pIlAtAntikaM gatvA yIzO rdEhaM yayAcE| ");
INSERT INTO sancol_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","pazcAd vapuravarOhya vAsasA saMvESTya yatra kOpi mAnuSO nAsthApyata tasmin zailE svAtE zmazAnE tadasthApayat| ");
INSERT INTO sancol_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","taddinamAyOjanIyaM dinaM vizrAmavArazca samIpaH| ");
INSERT INTO sancol_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","aparaM yIzunA sArddhaM gAlIla AgatA yOSitaH pazcAditvA zmazAnE tatra yathA vapuH sthApitaM tacca dRSTvA ");
INSERT INTO sancol_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","vyAghuTya sugandhidravyatailAni kRtvA vidhivad vizrAmavArE vizrAmaM cakruH| ");
INSERT INTO sancol_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","atha saptAhaprathamadinE'tipratyUSE tA yOSitaH sampAditaM sugandhidravyaM gRhItvA tadanyAbhiH kiyatIbhiH strIbhiH saha zmazAnaM yayuH| ");
INSERT INTO sancol_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","kintu zmazAnadvArAt pASANamapasAritaM dRSTvA ");
INSERT INTO sancol_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","tAH pravizya prabhO rdEhamaprApya ");
INSERT INTO sancol_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","vyAkulA bhavanti Etarhi tEjOmayavastrAnvitau dvau puruSau tAsAM samIpE samupasthitau ");
INSERT INTO sancol_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","tasmAttAH zagkAyuktA bhUmAvadhOmukhyasyasthuH| tadA tau tA Ucatu rmRtAnAM madhyE jIvantaM kutO mRgayatha? ");
INSERT INTO sancol_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","sOtra nAsti sa udasthAt| ");
INSERT INTO sancol_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","pApinAM karESu samarpitEna kruzE hatEna ca manuSyaputrENa tRtIyadivasE zmazAnAdutthAtavyam iti kathAM sa galIli tiSThan yuSmabhyaM kathitavAn tAM smarata| ");
INSERT INTO sancol_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","tadA tasya sA kathA tAsAM manaHsu jAtA| ");
INSERT INTO sancol_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","anantaraM zmazAnAd gatvA tA EkAdazaziSyAdibhyaH sarvvEbhyastAM vArttAM kathayAmAsuH| ");
INSERT INTO sancol_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","magdalInImariyam, yOhanA, yAkUbO mAtA mariyam tadanyAH sagginyO yOSitazca prEritEbhya EtAH sarvvA vArttAH kathayAmAsuH ");
INSERT INTO sancol_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","kintu tAsAM kathAm anarthakAkhyAnamAtraM buddhvA kOpi na pratyait| ");
INSERT INTO sancol_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","tadA pitara utthAya zmazAnAntikaM dadhAva, tatra ca prahvO bhUtvA pArzvaikasthApitaM kEvalaM vastraM dadarza; tasmAdAzcaryyaM manyamAnO yadaghaTata tanmanasi vicArayan pratasthE| ");
INSERT INTO sancol_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","tasminnEva dinE dvau ziyyau yirUzAlamazcatuSkrOzAntaritam immAyugrAmaM gacchantau ");
INSERT INTO sancol_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","tAsAM ghaTanAnAM kathAmakathayatAM ");
INSERT INTO sancol_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","tayOrAlApavicArayOH kAlE yIzurAgatya tAbhyAM saha jagAma ");
INSERT INTO sancol_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","kintu yathA tau taM na paricinutastadarthaM tayO rdRSTiH saMruddhA| ");
INSERT INTO sancol_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","sa tau pRSTavAn yuvAM viSaNNau kiM vicArayantau gacchathaH? ");
INSERT INTO sancol_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","tatastayOH kliyapAnAmA pratyuvAca yirUzAlamapurE'dhunA yAnyaghaTanta tvaM kEvalavidEzI kiM tadvRttAntaM na jAnAsi? ");
INSERT INTO sancol_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","sa papraccha kA ghaTanAH? tadA tau vaktumArEbhAtE yIzunAmA yO nAsaratIyO bhaviSyadvAdI Izvarasya mAnuSANAnjca sAkSAt vAkyE karmmaNi ca zaktimAnAsIt ");
INSERT INTO sancol_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","tam asmAkaM pradhAnayAjakA vicArakAzca kEnApi prakArENa kruzE viddhvA tasya prANAnanAzayan tadIyA ghaTanAH; ");
INSERT INTO sancol_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","kintu ya isrAyElIyalOkAn uddhArayiSyati sa EvAyam ityAzAsmAbhiH kRtA|tadyathA tathAstu tasyA ghaTanAyA adya dinatrayaM gataM| ");
INSERT INTO sancol_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","adhikantvasmAkaM sagginInAM kiyatstrINAM mukhEbhyO'sambhavavAkyamidaM zrutaM; ");
INSERT INTO sancol_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","tAH pratyUSE zmazAnaM gatvA tatra tasya dEham aprApya vyAghuTyEtvA prOktavatyaH svargIsadUtau dRSTAvasmAbhistau cAvAdiSTAM sa jIvitavAn| ");
INSERT INTO sancol_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","tatOsmAkaM kaizcit zmazAnamagamyata tE'pi strINAM vAkyAnurUpaM dRSTavantaH kintu taM nApazyan| ");
INSERT INTO sancol_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","tadA sa tAvuvAca, hE abOdhau hE bhaviSyadvAdibhiruktavAkyaM pratyEtuM vilambamAnau; ");
INSERT INTO sancol_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","EtatsarvvaduHkhaM bhuktvA svabhUtiprAptiH kiM khrISTasya na nyAyyA? ");
INSERT INTO sancol_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","tataH sa mUsAgranthamArabhya sarvvabhaviSyadvAdinAM sarvvazAstrE svasmin likhitAkhyAnAbhiprAyaM bOdhayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","atha gamyagrAmAbhyarNaM prApya tEnAgrE gamanalakSaNE darzitE ");
INSERT INTO sancol_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","tau sAdhayitvAvadatAM sahAvAbhyAM tiSTha dinE gatE sati rAtrirabhUt; tataH sa tAbhyAM sArddhaM sthAtuM gRhaM yayau| ");
INSERT INTO sancol_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","pazcAdbhOjanOpavEzakAlE sa pUpaM gRhItvA IzvaraguNAn jagAda tanjca bhaMktvA tAbhyAM dadau| ");
INSERT INTO sancol_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","tadA tayO rdRSTau prasannAyAM taM pratyabhijnjatuH kintu sa tayOH sAkSAdantardadhE| ");
INSERT INTO sancol_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","tatastau mithObhidhAtum Arabdhavantau gamanakAlE yadA kathAmakathayat zAstrArthanjcabOdhayat tadAvayO rbuddhiH kiM na prAjvalat? ");
INSERT INTO sancol_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","tau tatkSaNAdutthAya yirUzAlamapuraM pratyAyayatuH, tatsthAnE ziSyANAm EkAdazAnAM sagginAnjca darzanaM jAtaM| ");
INSERT INTO sancol_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","tE prOcuH prabhurudatiSThad iti satyaM zimOnE darzanamadAcca| ");
INSERT INTO sancol_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","tataH pathaH sarvvaghaTanAyAH pUpabhanjjanEna tatparicayasya ca sarvvavRttAntaM tau vaktumArEbhAtE| ");
INSERT INTO sancol_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","itthaM tE parasparaM vadanti tatkAlE yIzuH svayaM tESAM madhya prOtthaya yuSmAkaM kalyANaM bhUyAd ityuvAca, ");
INSERT INTO sancol_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","kintu bhUtaM pazyAma ityanumAya tE samudvivijirE trESuzca| ");
INSERT INTO sancol_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","sa uvAca, kutO duHkhitA bhavatha? yuSmAkaM manaHsu sandEha udEti ca kutaH? ");
INSERT INTO sancol_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ESOhaM, mama karau pazyata varaM spRSTvA pazyata, mama yAdRzAni pazyatha tAdRzAni bhUtasya mAMsAsthIni na santi| ");
INSERT INTO sancol_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ityuktvA sa hastapAdAn darzayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","tE'sambhavaM jnjAtvA sAnandA na pratyayan| tataH sa tAn papraccha, atra yuSmAkaM samIpE khAdyaM kinjcidasti? ");
INSERT INTO sancol_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","tatastE kiyaddagdhamatsyaM madhu ca daduH ");
INSERT INTO sancol_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","sa tadAdAya tESAM sAkSAd bubhujE ");
INSERT INTO sancol_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","kathayAmAsa ca mUsAvyavasthAyAM bhaviSyadvAdinAM granthESu gItapustakE ca mayi yAni sarvvANi vacanAni likhitAni tadanurUpANi ghaTiSyantE yuSmAbhiH sArddhaM sthitvAhaM yadEtadvAkyam avadaM tadidAnIM pratyakSamabhUt| ");
INSERT INTO sancol_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","atha tEbhyaH zAstrabOdhAdhikAraM datvAvadat, ");
INSERT INTO sancol_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","khrISTEnEtthaM mRtiyAtanA bhOktavyA tRtIyadinE ca zmazAnAdutthAtavyanjcEti lipirasti; ");
INSERT INTO sancol_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","tannAmnA yirUzAlamamArabhya sarvvadEzE manaHparAvarttanasya pApamOcanasya ca susaMvAdaH pracArayitavyaH, ");
INSERT INTO sancol_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ESu sarvvESu yUyaM sAkSiNaH| ");
INSERT INTO sancol_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","aparanjca pazyata pitrA yat pratijnjAtaM tat prESayiSyAmi, ataEva yAvatkAlaM yUyaM svargIyAM zaktiM na prApsyatha tAvatkAlaM yirUzAlamnagarE tiSThata| ");
INSERT INTO sancol_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","atha sa tAn baithanIyAparyyantaM nItvA hastAvuttOlya AziSa vaktumArEbhE ");
INSERT INTO sancol_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","AziSaM vadannEva ca tEbhyaH pRthag bhUtvA svargAya nItO'bhavat| ");
INSERT INTO sancol_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","tadA tE taM bhajamAnA mahAnandEna yirUzAlamaM pratyAjagmuH| ");
INSERT INTO sancol_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","tatO nirantaraM mandirE tiSThanta Izvarasya prazaMsAM dhanyavAdanjca karttam ArEbhirE| iti||");
INSERT INTO sancol_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Adau vAda AsIt sa ca vAda IzvarENa sArdhamAsIt sa vAdaH svayamIzvara Eva| ");
INSERT INTO sancol_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","sa AdAvIzvarENa sahAsIt| ");
INSERT INTO sancol_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","tEna sarvvaM vastu sasRjE sarvvESu sRSTavastuSu kimapi vastu tEnAsRSTaM nAsti| ");
INSERT INTO sancol_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","sa jIvanasyAkAraH, tacca jIvanaM manuSyANAM jyOtiH ");
INSERT INTO sancol_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","tajjyOtirandhakArE pracakAzE kintvandhakArastanna jagrAha| ");
INSERT INTO sancol_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","yOhan nAmaka EkO manuja IzvarENa prESayAnjcakrE| ");
INSERT INTO sancol_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","tadvArA yathA sarvvE vizvasanti tadarthaM sa tajjyOtiSi pramANaM dAtuM sAkSisvarUpO bhUtvAgamat, ");
INSERT INTO sancol_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","sa svayaM tajjyOti rna kintu tajjyOtiSi pramANaM dAtumAgamat| ");
INSERT INTO sancol_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","jagatyAgatya yaH sarvvamanujEbhyO dIptiM dadAti tadEva satyajyOtiH| ");
INSERT INTO sancol_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","sa yajjagadasRjat tanmadya Eva sa AsIt kintu jagatO lOkAstaM nAjAnan| ");
INSERT INTO sancol_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","nijAdhikAraM sa Agacchat kintu prajAstaM nAgRhlan| ");
INSERT INTO sancol_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","tathApi yE yE tamagRhlan arthAt tasya nAmni vyazvasan tEbhya Izvarasya putrA bhavitum adhikAram adadAt| ");
INSERT INTO sancol_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","tESAM janiH zONitAnna zArIrikAbhilASAnna mAnavAnAmicchAtO na kintvIzvarAdabhavat| ");
INSERT INTO sancol_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","sa vAdO manuSyarUpENAvatIryya satyatAnugrahAbhyAM paripUrNaH san sArdham asmAbhi rnyavasat tataH pituradvitIyaputrasya yOgyO yO mahimA taM mahimAnaM tasyApazyAma| ");
INSERT INTO sancol_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","tatO yOhanapi pracAryya sAkSyamidaM dattavAn yO mama pazcAd AgamiSyati sa mattO gurutaraH; yatO matpUrvvaM sa vidyamAna AsIt; yadartham ahaM sAkSyamidam adAM sa ESaH| ");
INSERT INTO sancol_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","aparanjca tasya pUrNatAyA vayaM sarvvE kramazaH kramazOnugrahaM prAptAH| ");
INSERT INTO sancol_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","mUsAdvArA vyavasthA dattA kintvanugrahaH satyatvanjca yIzukhrISTadvArA samupAtiSThatAM| ");
INSERT INTO sancol_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","kOpi manuja IzvaraM kadApi nApazyat kintu pituH krOPasthO'dvitIyaH putrastaM prakAzayat| ");
INSERT INTO sancol_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","tvaM kaH? iti vAkyaM prESTuM yadA yihUdIyalOkA yAjakAn lEvilOkAMzca yirUzAlamO yOhanaH samIpE prESayAmAsuH, ");
INSERT INTO sancol_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","tadA sa svIkRtavAn nApahnUtavAn nAham abhiSikta ityaggIkRtavAn| ");
INSERT INTO sancol_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","tadA tE'pRcchan tarhi kO bhavAn? kiM EliyaH? sOvadat na; tatastE'pRcchan tarhi bhavAn sa bhaviSyadvAdI? sOvadat nAhaM saH| ");
INSERT INTO sancol_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","tadA tE'pRcchan tarhi bhavAn kaH? vayaM gatvA prErakAn tvayi kiM vakSyAmaH? svasmin kiM vadasi? ");
INSERT INTO sancol_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","tadA sOvadat| paramEzasya panthAnaM pariSkuruta sarvvataH| itIdaM prAntarE vAkyaM vadataH kasyacidravaH| kathAmimAM yasmin yizayiyO bhaviSyadvAdI likhitavAn sOham| ");
INSERT INTO sancol_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","yE prESitAstE phirUzilOkAH| ");
INSERT INTO sancol_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","tadA tE'pRcchan yadi nAbhiSiktOsi EliyOsi na sa bhaviSyadvAdyapi nAsi ca, tarhi lOkAn majjayasi kutaH? ");
INSERT INTO sancol_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","tatO yOhan pratyavOcat, tOyE'haM majjayAmIti satyaM kintu yaM yUyaM na jAnItha tAdRza EkO janO yuSmAkaM madhya upatiSThati| ");
INSERT INTO sancol_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","sa matpazcAd AgatOpi matpUrvvaM varttamAna AsIt tasya pAdukAbandhanaM mOcayitumapi nAhaM yOgyOsmi| ");
INSERT INTO sancol_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","yarddananadyAH pArasthabaithabArAyAM yasminsthAnE yOhanamajjayat tasmina sthAnE sarvvamEtad aghaTata| ");
INSERT INTO sancol_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","parE'hani yOhan svanikaTamAgacchantaM yizuM vilOkya prAvOcat jagataH pApamOcakam Izvarasya mESazAvakaM pazyata| ");
INSERT INTO sancol_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","yO mama pazcAdAgamiSyati sa mattO gurutaraH, yatO hEtOrmatpUrvvaM sO'varttata yasminnahaM kathAmimAM kathitavAn sa EvAyaM| ");
INSERT INTO sancol_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","aparaM nAhamEnaM pratyabhijnjAtavAn kintu isrAyEllOkA EnaM yathA paricinvanti tadabhiprAyENAhaM jalE majjayitumAgaccham| ");
INSERT INTO sancol_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","punazca yOhanaparamEkaM pramANaM datvA kathitavAn vihAyasaH kapOtavad avatarantamAtmAnam asyOparyyavatiSThantaM ca dRSTavAnaham| ");
INSERT INTO sancol_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","nAhamEnaM pratyabhijnjAtavAn iti satyaM kintu yO jalE majjayituM mAM prairayat sa EvEmAM kathAmakathayat yasyOparyyAtmAnam avatarantam avatiSThantanjca drakSayasi saEva pavitrE Atmani majjayiSyati| ");
INSERT INTO sancol_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","avastannirIkSyAyam Izvarasya tanaya iti pramANaM dadAmi| ");
INSERT INTO sancol_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","parE'hani yOhan dvAbhyAM ziSyAbhyAM sArddhEM tiSThan ");
INSERT INTO sancol_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","yizuM gacchantaM vilOkya gaditavAn, Izvarasya mESazAvakaM pazyataM| ");
INSERT INTO sancol_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","imAM kathAM zrutvA dvau ziSyau yIzOH pazcAd IyatuH| ");
INSERT INTO sancol_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","tatO yIzuH parAvRtya tau pazcAd Agacchantau dRSTvA pRSTavAn yuvAM kiM gavEzayathaH? tAvapRcchatAM hE rabbi arthAt hE gurO bhavAn kutra tiSThati? ");
INSERT INTO sancol_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","tataH sOvAdit Etya pazyataM| tatO divasasya tRtIyapraharasya gatatvAt tau taddinaM tasya saggE'sthAtAM| ");
INSERT INTO sancol_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","yau dvau yOhanO vAkyaM zrutvA yizOH pazcAd AgamatAM tayOH zimOnpitarasya bhrAtA AndriyaH ");
INSERT INTO sancol_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","sa itvA prathamaM nijasOdaraM zimOnaM sAkSAtprApya kathitavAn vayaM khrISTam arthAt abhiSiktapuruSaM sAkSAtkRtavantaH| ");
INSERT INTO sancol_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","pazcAt sa taM yizOH samIpam Anayat| tadA yIzustaM dRSTvAvadat tvaM yUnasaH putraH zimOn kintu tvannAmadhEyaM kaiphAH vA pitaraH arthAt prastarO bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","parE'hani yIzau gAlIlaM gantuM nizcitacEtasi sati philipanAmAnaM janaM sAkSAtprApyAvOcat mama pazcAd Agaccha| ");
INSERT INTO sancol_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","baitsaidAnAmni yasmin grAmE pitarAndriyayOrvAsa AsIt tasmin grAmE tasya philipasya vasatirAsIt| ");
INSERT INTO sancol_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","pazcAt philipO nithanElaM sAkSAtprApyAvadat mUsA vyavasthA granthE bhaviSyadvAdinAM granthESu ca yasyAkhyAnaM likhitamAstE taM yUSaphaH putraM nAsaratIyaM yIzuM sAkSAd akArSma vayaM| ");
INSERT INTO sancol_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","tadA nithanEl kathitavAn nAsarannagarAta kiM kazciduttama utpantuM zaknOti? tataH philipO 'vOcat Etya pazya| ");
INSERT INTO sancol_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","aparanjca yIzuH svasya samIpaM tam AgacchantaM dRSTvA vyAhRtavAn, pazyAyaM niSkapaTaH satya isrAyEllOkaH| ");
INSERT INTO sancol_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","tataH sOvadad, bhavAn mAM kathaM pratyabhijAnAti? yIzuravAdIt philipasya AhvAnAt pUrvvaM yadA tvamuPumbarasya tarOrmUlE'sthAstadA tvAmadarzam| ");
INSERT INTO sancol_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","nithanEl acakathat, hE gurO bhavAn nitAntam Izvarasya putrOsi, bhavAn isrAyElvaMzasya rAjA| ");
INSERT INTO sancol_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","tatO yIzu rvyAharat, tvAmuPumbarasya pAdapasya mUlE dRSTavAnAhaM mamaitasmAdvAkyAt kiM tvaM vyazvasIH? EtasmAdapyAzcaryyANi kAryyANi drakSyasi| ");
INSERT INTO sancol_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","anyaccAvAdId yuSmAnahaM yathArthaM vadAmi, itaH paraM mOcitE mEghadvArE tasmAnmanujasUnunA Izvarasya dUtagaNam avarOhantamArOhantanjca drakSyatha| ");
INSERT INTO sancol_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","anantaraM trutIyadivasE gAlIl pradEziyE kAnnAnAmni nagarE vivAha AsIt tatra ca yIzOrmAtA tiSThat| ");
INSERT INTO sancol_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","tasmai vivAhAya yIzustasya ziSyAzca nimantritA Asan| ");
INSERT INTO sancol_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","tadanantaraM drAkSArasasya nyUnatvAd yIzOrmAtA tamavadat EtESAM drAkSArasO nAsti| ");
INSERT INTO sancol_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","tadA sa tAmavOcat hE nAri mayA saha tava kiM kAryyaM? mama samaya idAnIM nOpatiSThati| ");
INSERT INTO sancol_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","tatastasya mAtA dAsAnavOcad ayaM yad vadati tadEva kuruta| ");
INSERT INTO sancol_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","tasmin sthAnE yihUdIyAnAM zucitvakaraNavyavahArAnusArENAPhakaikajaladharANi pASANamayAni SaPvRhatpAtrANiAsan| ");
INSERT INTO sancol_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","tadA yIzustAn sarvvakalazAn jalaiH pUrayituM tAnAjnjApayat, tatastE sarvvAn kumbhAnAkarNaM jalaiH paryyapUrayan| ");
INSERT INTO sancol_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","atha tEbhyaH kinjciduttAryya bhOjyAdhipAtEHsamIpaM nEtuM sa tAnAdizat, tE tadanayan| ");
INSERT INTO sancol_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","aparanjca tajjalaM kathaM drAkSArasO'bhavat tajjalavAhakAdAsA jnjAtuM zaktAH kintu tadbhOjyAdhipO jnjAtuM nAzaknOt tadavalihya varaM saMmbOdyAvadata, ");
INSERT INTO sancol_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","lOkAH prathamaM uttamadrAkSArasaM dadati taSu yathESTaM pitavatsu tasmA kinjcidanuttamanjca dadati kintu tvamidAnIM yAvat uttamadrAkSArasaM sthApayasi| ");
INSERT INTO sancol_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","itthaM yIzurgAlIlapradEzE AzcaryyakArmma prArambha nijamahimAnaM prAkAzayat tataH ziSyAstasmin vyazvasan| ");
INSERT INTO sancol_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","tataH param sa nijamAtrubhrAtrusziSyaiH sArddhM kapharnAhUmam Agamat kintu tatra bahUdinAni AtiSThat| ");
INSERT INTO sancol_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","tadanantaraM yihUdiyAnAM nistArOtsavE nikaTamAgatE yIzu ryirUzAlam nagaram Agacchat| ");
INSERT INTO sancol_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","tatO mandirasya madhyE gOmESapArAvatavikrayiNO vANijakScOpaviSTAn vilOkya ");
INSERT INTO sancol_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","rajjubhiH kazAM nirmmAya sarvvagOmESAdibhiH sArddhaM tAn mandirAd dUrIkRtavAn| ");
INSERT INTO sancol_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","vaNijAM mudrAdi vikIryya AsanAni nyUbjIkRtya pArAvatavikrayibhyO'kathayad asmAt sthAnAt sarvANyEtAni nayata, mama pitugRhaM vANijyagRhaM mA kArSTa| ");
INSERT INTO sancol_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","tasmAt tanmandirArtha udyOgO yastu sa grasatIva mAm| imAM zAstrIyalipiM ziSyAHsamasmaran| ");
INSERT INTO sancol_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","tataH param yihUdIyalOkA yISimavadan tavamidRzakarmmakaraNAt kiM cihnamasmAn darzayasi? ");
INSERT INTO sancol_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","tatO yIzustAnavOcad yuSmAbhirE tasmin mandirE nAzitE dinatrayamadhyE'haM tad utthApayiSyAmi| ");
INSERT INTO sancol_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","tadA yihUdiyA vyAhArSuH, Etasya mandirasa nirmmANEna SaTcatvAriMzad vatsarA gatAH, tvaM kiM dinatrayamadhyE tad utthApayiSyasi? ");
INSERT INTO sancol_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","kintu sa nijadEharUpamandirE kathAmimAM kathitavAn| ");
INSERT INTO sancol_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","sa yadEtAdRzaM gaditavAn tacchiSyAH zmazAnAt tadIyOtthAnE sati smRtvA dharmmagranthE yIzunOktakathAyAM ca vyazvasiSuH| ");
INSERT INTO sancol_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","anantaraM nistArOtsavasya bhOjyasamayE yirUzAlam nagarE tatkrutAzcaryyakarmmANi vilOkya bahubhistasya nAmani vizvasitaM| ");
INSERT INTO sancol_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","kintu sa tESAM karESu svaM na samarpayat, yataH sa sarvvAnavait| ");
INSERT INTO sancol_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","sa mAnavESu kasyacit pramANaM nApEkSata yatO manujAnAM madhyE yadyadasti tattat sOjAnAt| ");
INSERT INTO sancol_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","nikadimanAmA yihUdIyAnAm adhipatiH phirUzI kSaNadAyAM ");
INSERT INTO sancol_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","yIzaurabhyarNam Avrajya vyAhArSIt, hE gurO bhavAn IzvarAd Agat Eka upadESTA, Etad asmAbhirjnjAyatE; yatO bhavatA yAnyAzcaryyakarmmANi kriyantE paramEzvarasya sAhAyyaM vinA kEnApi tattatkarmmANi karttuM na zakyantE| ");
INSERT INTO sancol_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","tadA yIzuruttaraM dattavAn tavAhaM yathArthataraM vyAharAmi punarjanmani na sati kOpi mAnava Izvarasya rAjyaM draSTuM na zaknOti| ");
INSERT INTO sancol_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","tatO nikadImaH pratyavOcat manujO vRddhO bhUtvA kathaM janiSyatE? sa kiM puna rmAtRrjaTharaM pravizya janituM zaknOti? ");
INSERT INTO sancol_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","yIzuravAdId yathArthataram ahaM kathayAmi manujE tOyAtmabhyAM puna rna jAtE sa Izvarasya rAjyaM pravESTuM na zaknOti| ");
INSERT INTO sancol_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","mAMsAd yat jAyatE tan mAMsamEva tathAtmanO yO jAyatE sa Atmaiva| ");
INSERT INTO sancol_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","yuSmAbhiH puna rjanitavyaM mamaitasyAM kathAyAm AzcaryaM mA maMsthAH| ");
INSERT INTO sancol_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","sadAgatiryAM dizamicchati tasyAmEva dizi vAti, tvaM tasya svanaM zuNOSi kintu sa kuta AyAti kutra yAti vA kimapi na jAnAsi tadvAd AtmanaH sakAzAt sarvvESAM manujAnAM janma bhavati| ");
INSERT INTO sancol_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","tadA nikadImaH pRSTavAn Etat kathaM bhavituM zaknOti? ");
INSERT INTO sancol_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","yIzuH pratyaktavAn tvamisrAyElO gururbhUtvApi kimEtAM kathAM na vEtsi? ");
INSERT INTO sancol_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","tubhyaM yathArthaM kathayAmi, vayaM yad vidmastad vacmaH yaMcca pazyAmastasyaiva sAkSyaM dadmaH kintu yuSmAbhirasmAkaM sAkSitvaM na gRhyatE| ");
INSERT INTO sancol_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Etasya saMsArasya kathAyAM kathitAyAM yadi yUyaM na vizvasitha tarhi svargIyAyAM kathAyAM kathaM vizvasiSyatha? ");
INSERT INTO sancol_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","yaH svargE'sti yaM ca svargAd avArOhat taM mAnavatanayaM vinA kOpi svargaM nArOhat| ");
INSERT INTO sancol_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","aparanjca mUsA yathA prAntarE sarpaM prOtthApitavAn manuSyaputrO'pi tathaivOtthApitavyaH; ");
INSERT INTO sancol_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","tasmAd yaH kazcit tasmin vizvasiSyati sO'vinAzyaH san anantAyuH prApsyati| ");
INSERT INTO sancol_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Izvara itthaM jagadadayata yat svamadvitIyaM tanayaM prAdadAt tatO yaH kazcit tasmin vizvasiSyati sO'vinAzyaH san anantAyuH prApsyati| ");
INSERT INTO sancol_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","IzvarO jagatO lOkAn daNPayituM svaputraM na prESya tAn paritrAtuM prESitavAn| ");
INSERT INTO sancol_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ataEva yaH kazcit tasmin vizvasiti sa daNPArhO na bhavati kintu yaH kazcit tasmin na vizvasiti sa idAnImEva daNPArhO bhavati,yataH sa IzvarasyAdvitIyaputrasya nAmani pratyayaM na karOti| ");
INSERT INTO sancol_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","jagatO madhyE jyOtiH prAkAzata kintu manuSyANAM karmmaNAM dRSTatvAt tE jyOtiSOpi timirE prIyantE EtadEva daNPasya kAraNAM bhavati| ");
INSERT INTO sancol_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","yaH kukarmma karOti tasyAcArasya dRSTatvAt sa jyOtirRRtIyitvA tannikaTaM nAyAti; ");
INSERT INTO sancol_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","kintu yaH satkarmma karOti tasya sarvvANi karmmANIzvarENa kRtAnIti sathA prakAzatE tadabhiprAyENa sa jyOtiSaH sannidhim AyAti| ");
INSERT INTO sancol_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","tataH param yIzuH ziSyaiH sArddhaM yihUdIyadEzaM gatvA tatra sthitvA majjayitum Arabhata| ");
INSERT INTO sancol_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","tadA zAlam nagarasya samIpasthAyini ainan grAmE bahutaratOyasthitEstatra yOhan amajjayat tathA ca lOkA Agatya tEna majjitA abhavan| ");
INSERT INTO sancol_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","tadA yOhan kArAyAM na baddhaH| ");
INSERT INTO sancol_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","aparanjca zAcakarmmaNi yOhAnaH ziSyaiH saha yihUdIyalOkAnAM vivAdE jAtE, tE yOhanaH saMnnidhiM gatvAkathayan, ");
INSERT INTO sancol_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","hE gurO yarddananadyAH pArE bhavatA sArddhaM ya AsIt yasmiMzca bhavAn sAkSyaM pradadAt pazyatu sOpi majjayati sarvvE tasya samIpaM yAnti ca| ");
INSERT INTO sancol_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","tadA yOhan pratyavOcad IzvarENa na dattE kOpi manujaH kimapi prAptuM na zaknOti| ");
INSERT INTO sancol_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","ahaM abhiSiktO na bhavAmi kintu tadagrE prESitOsmi yAmimAM kathAM kathitavAnAhaM tatra yUyaM sarvvE sAkSiNaH stha| ");
INSERT INTO sancol_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","yO janaH kanyAM labhatE sa Eva varaH kintu varasya sannidhau daNPAyamAnaM tasya yanmitraM tEna varasya zabdE zrutE'tIvAhlAdyatE mamApi tadvad AnandasiddhirjAtA| ");
INSERT INTO sancol_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","tEna kramazO varddhitavyaM kintu mayA hsitavyaM| ");
INSERT INTO sancol_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ya UrdhvAdAgacchat sa sarvvESAM mukhyO yazca saMsArAd udapadyata sa sAMsArikaH saMsArIyAM kathAnjca kathayati yastu svargAdAgacchat sa sarvvESAM mukhyaH| ");
INSERT INTO sancol_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","sa yadapazyadazRNOcca tasminnEva sAkSyaM dadAti tathApi prAyazaH kazcit tasya sAkSyaM na gRhlAti; ");
INSERT INTO sancol_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","kintu yO gRhlAti sa Izvarasya satyavAditvaM mudrAggitaM karOti| ");
INSERT INTO sancol_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","IzvarENa yaH prEritaH saEva IzvarIyakathAM kathayati yata Izvara AtmAnaM tasmai aparimitam adadAt| ");
INSERT INTO sancol_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","pitA putrE snEhaM kRtvA tasya hastE sarvvANi samarpitavAn| ");
INSERT INTO sancol_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","yaH kazcit putrE vizvasiti sa EvAnantam paramAyuH prApnOti kintu yaH kazcit putrE na vizvasiti sa paramAyuSO darzanaM na prApnOti kintvIzvarasya kOpabhAjanaM bhUtvA tiSThati| ");
INSERT INTO sancol_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","yIzuH svayaM nAmajjayat kEvalaM tasya ziSyA amajjayat kintu yOhanO'dhikaziSyAn sa karOti majjayati ca, ");
INSERT INTO sancol_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","phirUzina imAM vArttAmazRNvan iti prabhuravagatya ");
INSERT INTO sancol_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","yihUdIyadEzaM vihAya puna rgAlIlam Agat| ");
INSERT INTO sancol_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","tataH zOmirONapradEzasya madyEna tEna gantavyE sati ");
INSERT INTO sancol_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","yAkUb nijaputrAya yUSaphE yAM bhUmim adadAt tatsamIpasthAyi zOmirONapradEzasya sukhAr nAmnA vikhyAtasya nagarasya sannidhAvupAsthAt| ");
INSERT INTO sancol_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","tatra yAkUbaH prahirAsIt; tadA dvitIyayAmavElAyAM jAtAyAM sa mArgE zramApannastasya prahEH pArzvE upAvizat| ");
INSERT INTO sancol_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Etarhi kAcit zOmirONIyA yOSit tOyOttOlanArtham tatrAgamat ");
INSERT INTO sancol_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","tadA ziSyAH khAdyadravyANi krEtuM nagaram agacchan| ");
INSERT INTO sancol_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","yIzuH zOmirONIyAM tAM yOSitam vyAhArSIt mahyaM kinjcit pAnIyaM pAtuM dEhi| kintu zOmirONIyaiH sAkaM yihUdIyalOkA na vyavAharan tasmAddhEtOH sAkathayat zOmirONIyA yOSitadahaM tvaM yihUdIyOsi kathaM mattaH pAnIyaM pAtum icchasi? ");
INSERT INTO sancol_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","tatO yIzuravadad Izvarasya yaddAnaM tatkIdRk pAnIyaM pAtuM mahyaM dEhi ya itthaM tvAM yAcatE sa vA ka iti cEdajnjAsyathAstarhi tamayAciSyathAH sa ca tubhyamamRtaM tOyamadAsyat| ");
INSERT INTO sancol_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","tadA sA sImantinI bhASitavati, hE mahEccha prahirgambhIrO bhavatO nIrOttOlanapAtraM nAstI ca tasmAt tadamRtaM kIlAlaM kutaH prApsyasi? ");
INSERT INTO sancol_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","yOsmabhyam imamandhUM dadau, yasya ca parijanA gOmESAdayazca sarvvE'sya prahEH pAnIyaM papurEtAdRzO yOsmAkaM pUrvvapuruSO yAkUb tasmAdapi bhavAn mahAn kiM? ");
INSERT INTO sancol_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","tatO yIzurakathayad idaM pAnIyaM saH pivati sa punastRSArttO bhaviSyati, ");
INSERT INTO sancol_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","kintu mayA dattaM pAnIyaM yaH pivati sa punaH kadApi tRSArttO na bhaviSyati| mayA dattam idaM tOyaM tasyAntaH prasravaNarUpaM bhUtvA anantAyuryAvat srOSyati| ");
INSERT INTO sancol_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","tadA sA vanitAkathayat hE mahEccha tarhi mama punaH pIpAsA yathA na jAyatE tOyOttOlanAya yathAtrAgamanaM na bhavati ca tadarthaM mahyaM tattOyaM dEhI| ");
INSERT INTO sancol_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","tatO yIzUravadadyAhi tava patimAhUya sthAnE'trAgaccha| ");
INSERT INTO sancol_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","sA vAmAvadat mama patirnAsti| yIzuravadat mama patirnAstIti vAkyaM bhadramavOcaH| ");
INSERT INTO sancol_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","yatastava panjca patayObhavan adhunA tu tvayA sArddhaM yastiSThati sa tava bharttA na vAkyamidaM satyamavAdiH| ");
INSERT INTO sancol_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","tadA sA mahilA gaditavati hE mahEccha bhavAn EkO bhaviSyadvAdIti buddhaM mayA| ");
INSERT INTO sancol_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","asmAkaM pitRlOkA Etasmin zilOccayE'bhajanta, kintu bhavadbhirucyatE yirUzAlam nagarE bhajanayOgyaM sthAnamAstE| ");
INSERT INTO sancol_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","yIzuravOcat hE yOSit mama vAkyE vizvasihi yadA yUyaM kEvalazailE'smin vA yirUzAlam nagarE piturbhajanaM na kariSyadhvE kAla EtAdRza AyAti| ");
INSERT INTO sancol_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","yUyaM yaM bhajadhvE taM na jAnItha, kintu vayaM yaM bhajAmahE taM jAnImahE, yatO yihUdIyalOkAnAM madhyAt paritrANaM jAyatE| ");
INSERT INTO sancol_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","kintu yadA satyabhaktA AtmanA satyarUpENa ca piturbhajanaM kariSyantE samaya EtAdRza AyAti, varam idAnImapi vidyatE ; yata EtAdRzO bhatkAn pitA cESTatE| ");
INSERT INTO sancol_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Izvara AtmA; tatastasya yE bhaktAstaiH sa AtmanA satyarUpENa ca bhajanIyaH| ");
INSERT INTO sancol_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","tadA sA mahilAvAdIt khrISTanAmnA vikhyAtO'bhiSiktaH puruSa AgamiSyatIti jAnAmi sa ca sarvvAH kathA asmAn jnjApayiSyati| ");
INSERT INTO sancol_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","tatO yIzuravadat tvayA sArddhaM kathanaM karOmi yO'ham ahamEva sa puruSaH| ");
INSERT INTO sancol_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Etasmin samayE ziSyA Agatya tathA striyA sArddhaM tasya kathOpakathanE mahAzcaryyam amanyanta tathApi bhavAn kimicchati? yadvA kimartham EtayA sArddhaM kathAM kathayati? iti kOpi nApRcchat| ");
INSERT INTO sancol_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","tataH paraM sA nArI kalazaM sthApayitvA nagaramadhyaM gatvA lOkEbhyOkathAyad ");
INSERT INTO sancol_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","ahaM yadyat karmmAkaravaM tatsarvvaM mahyamakathayad EtAdRzaM mAnavamEkam Agatya pazyata ru kim abhiSiktO na bhavati ? ");
INSERT INTO sancol_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","tatastE nagarAd bahirAgatya tAtasya samIpam Ayan| ");
INSERT INTO sancol_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Etarhi ziSyAH sAdhayitvA taM vyAhArSuH hE gurO bhavAn kinjcid bhUktAM| ");
INSERT INTO sancol_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","tataH sOvadad yuSmAbhiryanna jnjAyatE tAdRzaM bhakSyaM mamAstE| ");
INSERT INTO sancol_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","tadA ziSyAH parasparaM praSTum Arambhanta, kimasmai kOpi kimapi bhakSyamAnIya dattavAn? ");
INSERT INTO sancol_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","yIzuravOcat matprErakasyAbhimatAnurUpakaraNaM tasyaiva karmmasiddhikAraNanjca mama bhakSyaM| ");
INSERT INTO sancol_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","mAsacatuSTayE jAtE zasyakarttanasamayO bhaviSyatIti vAkyaM yuSmAbhiH kiM nOdyatE? kintvahaM vadAmi, zira uttOlya kSEtrANi prati nirIkSya pazyata, idAnIM karttanayOgyAni zuklavarNAnyabhavan| ");
INSERT INTO sancol_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","yazchinatti sa vEtanaM labhatE anantAyuHsvarUpaM zasyaM sa gRhlAti ca, tEnaiva vaptA chEttA ca yugapad AnandataH| ");
INSERT INTO sancol_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","itthaM sati vapatyEkazchinatyanya iti vacanaM siddhyati| ");
INSERT INTO sancol_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","yatra yUyaM na paryyazrAmyata tAdRzaM zasyaM chEttuM yuSmAn prairayam anyE janAHparyyazrAmyan yUyaM tESAM zragasya phalam alabhadhvam| ");
INSERT INTO sancol_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","yasmin kAlE yadyat karmmAkArSaM tatsarvvaM sa mahyam akathayat tasyA vanitAyA idaM sAkSyavAkyaM zrutvA tannagaranivAsinO bahavaH zOmirONIyalOkA vyazvasan| ");
INSERT INTO sancol_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","tathA ca tasyAntikE samupasthAya svESAM sannidhau katicid dinAni sthAtuM tasmin vinayam akurvvAna tasmAt sa dinadvayaM tatsthAnE nyavaSTat ");
INSERT INTO sancol_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","tatastasyOpadEzEna bahavO'parE vizvasya ");
INSERT INTO sancol_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","tAM yOSAmavadan kEvalaM tava vAkyEna pratIma iti na, kintu sa jagatO'bhiSiktastrAtEti tasya kathAM zrutvA vayaM svayamEvAjnjAsamahi| ");
INSERT INTO sancol_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","svadEzE bhaviSyadvaktuH satkArO nAstIti yadyapi yIzuH pramANaM datvAkathayat ");
INSERT INTO sancol_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","tathApi divasadvayAt paraM sa tasmAt sthAnAd gAlIlaM gatavAn| ");
INSERT INTO sancol_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","anantaraM yE gAlIlI liyalOkA utsavE gatA utsavasamayE yirUzalam nagarE tasya sarvvAH kriyA apazyan tE gAlIlam AgataM tam AgRhlan| ");
INSERT INTO sancol_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","tataH param yIzu ryasmin kAnnAnagarE jalaM drAkSArasam AkarOt tat sthAnaM punaragAt| tasminnEva samayE kasyacid rAjasabhAstArasya putraH kapharnAhUmapurI rOgagrasta AsIt| ");
INSERT INTO sancol_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","sa yEhUdIyadEzAd yIzO rgAlIlAgamanavArttAM nizamya tasya samIpaM gatvA prArthya vyAhRtavAn mama putrasya prAyENa kAla AsannaH bhavAn Agatya taM svasthaM karOtu| ");
INSERT INTO sancol_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","tadA yIzurakathayad AzcaryyaM karmma citraM cihnaM ca na dRSTA yUyaM na pratyESyatha| ");
INSERT INTO sancol_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","tataH sa sabhAsadavadat hE mahEccha mama putrE na mRtE bhavAnAgacchatu| ");
INSERT INTO sancol_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","yIzustamavadad gaccha tava putrO'jIvIt tadA yIzunOktavAkyE sa vizvasya gatavAn| ");
INSERT INTO sancol_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","gamanakAlE mArgamadhyE dAsAstaM sAkSAtprApyAvadan bhavataH putrO'jIvIt| ");
INSERT INTO sancol_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","tataH kaM kAlamArabhya rOgapratIkArArambhO jAtA iti pRSTE tairuktaM hyaH sArddhadaNPadvayAdhikadvitIyayAmE tasya jvaratyAgO'bhavat| ");
INSERT INTO sancol_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","tadA yIzustasmin kSaNE prOktavAn tava putrO'jIvIt pitA tadbuddhvA saparivArO vyazvasIt| ");
INSERT INTO sancol_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","yihUdIyadEzAd Agatya gAlIli yIzurEtad dvitIyam AzcaryyakarmmAkarOt| ");
INSERT INTO sancol_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","tataH paraM yihUdIyAnAm utsava upasthitE yIzu ryirUzAlamaM gatavAn| ");
INSERT INTO sancol_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","tasminnagarE mESanAmnO dvArasya samIpE ibrIyabhASayA baithEsdA nAmnA piSkariNI panjcaghaTTayuktAsIt| ");
INSERT INTO sancol_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","tasyAstESu ghaTTESu kilAlakampanam apEkSya andhakhanjcazuSkAggAdayO bahavO rOgiNaH patantastiSThanti sma| ");
INSERT INTO sancol_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","yatO vizESakAlE tasya sarasO vAri svargIyadUta EtyAkampayat tatkIlAlakampanAt paraM yaH kazcid rOgI prathamaM pAnIyamavArOhat sa Eva tatkSaNAd rOgamuktO'bhavat| ");
INSERT INTO sancol_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","tadASTAtriMzadvarSANi yAvad rOgagrasta Ekajanastasmin sthAnE sthitavAn| ");
INSERT INTO sancol_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","yIzustaM zayitaM dRSTvA bahukAlikarOgIti jnjAtvA vyAhRtavAn tvaM kiM svasthO bubhUSasi? ");
INSERT INTO sancol_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","tatO rOgI kathitavAn hE mahEccha yadA kIlAlaM kampatE tadA mAM puSkariNIm avarOhayituM mama kOpi nAsti, tasmAn mama gamanakAlE kazcidanyO'grO gatvA avarOhati| ");
INSERT INTO sancol_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","tadA yIzurakathayad uttiSTha, tava zayyAmuttOlya gRhItvA yAhi| ");
INSERT INTO sancol_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","sa tatkSaNAt svasthO bhUtvA zayyAmuttOlyAdAya gatavAn kintu taddinaM vizrAmavAraH| ");
INSERT INTO sancol_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","tasmAd yihUdIyAH svasthaM naraM vyAharan adya vizrAmavArE zayanIyamAdAya na yAtavyam| ");
INSERT INTO sancol_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","tataH sa pratyavOcad yO mAM svastham akArSIt zayanIyam uttOlyAdAya yAtuM mAM sa EvAdizat| ");
INSERT INTO sancol_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","tadA tE'pRcchan zayanIyam uttOlyAdAya yAtuM ya AjnjApayat sa kaH? ");
INSERT INTO sancol_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","kintu sa ka iti svasthIbhUtO nAjAnAd yatastasmin sthAnE janatAsattvAd yIzuH sthAnAntaram Agamat| ");
INSERT INTO sancol_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","tataH paraM yEzu rmandirE taM naraM sAkSAtprApyAkathayat pazyEdAnIm anAmayO jAtOsi yathAdhikA durdazA na ghaTatE taddhEtOH pApaM karmma punarmAkArSIH| ");
INSERT INTO sancol_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","tataH sa gatvA yihUdIyAn avadad yIzu rmAm arOgiNam akArSIt| ");
INSERT INTO sancol_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","tatO yIzu rvizrAmavArE karmmEdRzaM kRtavAn iti hEtO ryihUdIyAstaM tAPayitvA hantum acESTanta| ");
INSERT INTO sancol_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","yIzustAnAkhyat mama pitA yat kAryyaM karOti tadanurUpam ahamapi karOti| ");
INSERT INTO sancol_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","tatO yihUdIyAstaM hantuM punarayatanta yatO vizrAmavAraM nAmanyata tadEva kEvalaM na adhikantu IzvaraM svapitaraM prOcya svamapIzvaratulyaM kRtavAn| ");
INSERT INTO sancol_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","pazcAd yIzuravadad yuSmAnahaM yathArthataraM vadAmi putraH pitaraM yadyat karmma kurvvantaM pazyati tadatiriktaM svEcchAtaH kimapi karmma karttuM na zaknOti| pitA yat karOti putrOpi tadEva karOti| ");
INSERT INTO sancol_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","pitA putrE snEhaM karOti tasmAt svayaM yadyat karmma karOti tatsarvvaM putraM darzayati ; yathA ca yuSmAkaM AzcaryyajnjAnaM janiSyatE tadartham itOpi mahAkarmma taM darzayiSyati| ");
INSERT INTO sancol_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","vastutastu pitA yathA pramitAn utthApya sajivAn karOti tadvat putrOpi yaM yaM icchati taM taM sajIvaM karOti| ");
INSERT INTO sancol_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","sarvvE pitaraM yathA satkurvvanti tathA putramapi satkArayituM pitA svayaM kasyApi vicAramakRtvA sarvvavicArANAM bhAraM putrE samarpitavAn| ");
INSERT INTO sancol_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","yaH putraM sat karOti sa tasya prErakamapi sat karOti| ");
INSERT INTO sancol_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","yuSmAnAhaM yathArthataraM vadAmi yO janO mama vAkyaM zrutvA matprErakE vizvasiti sOnantAyuH prApnOti kadApi daNPabAjanaM na bhavati nidhanAdutthAya paramAyuH prApnOti| ");
INSERT INTO sancol_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","ahaM yuSmAnatiyathArthaM vadAmi yadA mRtA Izvaraputrasya ninAdaM zrOSyanti yE ca zrOSyanti tE sajIvA bhaviSyanti samaya EtAdRza AyAti varam idAnImapyupatiSThati| ");
INSERT INTO sancol_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","pitA yathA svayanjjIvI tathA putrAya svayanjjIvitvAdhikAraM dattavAn| ");
INSERT INTO sancol_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","sa manuSyaputraH EtasmAt kAraNAt pitA daNPakaraNAdhikAramapi tasmin samarpitavAn| ");
INSERT INTO sancol_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","EtadarthE yUyam AzcaryyaM na manyadhvaM yatO yasmin samayE tasya ninAdaM zrutvA zmazAnasthAH sarvvE bahirAgamiSyanti samaya EtAdRza upasthAsyati| ");
INSERT INTO sancol_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","tasmAd yE satkarmmANi kRtavantasta utthAya AyuH prApsyanti yE ca kukarmANi kRtavantasta utthAya daNPaM prApsyanti| ");
INSERT INTO sancol_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","ahaM svayaM kimapi karttuM na zaknOmi yathA zuNOmi tathA vicArayAmi mama vicAranjca nyAyyaH yatOhaM svIyAbhISTaM nEhitvA matprErayituH pituriSTam IhE| ");
INSERT INTO sancol_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","yadi svasmin svayaM sAkSyaM dadAmi tarhi tatsAkSyam AgrAhyaM bhavati ; ");
INSERT INTO sancol_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","kintu madarthE'parO janaH sAkSyaM dadAti madarthE tasya yat sAkSyaM tat satyam EtadapyahaM jAnAmi| ");
INSERT INTO sancol_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","yuSmAbhi ryOhanaM prati lOkESu prEritESu sa satyakathAyAM sAkSyamadadAt| ");
INSERT INTO sancol_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","mAnuSAdahaM sAkSyaM nOpEkSE tathApi yUyaM yathA paritrayadhvE tadartham idaM vAkyaM vadAmi| ");
INSERT INTO sancol_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","yOhan dEdIpyamAnO dIpa iva tEjasvI sthitavAn yUyam alpakAlaM tasya dIptyAnandituM samamanyadhvaM| ");
INSERT INTO sancol_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","kintu tatpramANAdapi mama gurutaraM pramANaM vidyatE pitA mAM prESya yadyat karmma samApayituM zakttimadadAt mayA kRtaM tattat karmma madarthE pramANaM dadAti| ");
INSERT INTO sancol_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","yaH pitA mAM prEritavAn mOpi madarthE pramANaM dadAti| tasya vAkyaM yuSmAbhiH kadApi na zrutaM tasya rUpanjca na dRSTaM ");
INSERT INTO sancol_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","tasya vAkyanjca yuSmAkam antaH kadApi sthAnaM nApnOti yataH sa yaM prESitavAn yUyaM tasmin na vizvasitha| ");
INSERT INTO sancol_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","dharmmapustakAni yUyam AlOcayadhvaM tai rvAkyairanantAyuH prApsyAma iti yUyaM budhyadhvE taddharmmapustakAni madarthE pramANaM dadati| ");
INSERT INTO sancol_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","tathApi yUyaM paramAyuHprAptayE mama saMnidhim na jigamiSatha| ");
INSERT INTO sancol_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","ahaM mAnuSEbhyaH satkAraM na gRhlAmi| ");
INSERT INTO sancol_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ahaM yuSmAn jAnAmi; yuSmAkamantara IzvaraprEma nAsti| ");
INSERT INTO sancol_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ahaM nijapitu rnAmnAgatOsmi tathApi mAM na gRhlItha kintu kazcid yadi svanAmnA samAgamiSyati tarhi taM grahISyatha| ");
INSERT INTO sancol_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","yUyam IzvarAt satkAraM na ciSTatvA kEvalaM parasparaM satkAram cEd AdadhvvE tarhi kathaM vizvasituM zaknutha? ");
INSERT INTO sancol_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","putuH samIpE'haM yuSmAn apavadiSyAmIti mA cintayata yasmin , yasmin yuSmAkaM vizvasaH saEva mUsA yuSmAn apavadati| ");
INSERT INTO sancol_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","yadi yUyaM tasmin vyazvasiSyata tarhi mayyapi vyazvasiSyata, yat sa mayi likhitavAn| ");
INSERT INTO sancol_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","tatO yadi tEna likhitavAni na pratitha tarhi mama vAkyAni kathaM pratyESyatha? ");
INSERT INTO sancol_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","tataH paraM yIzu rgAlIl pradEzIyasya tiviriyAnAmnaH sindhOH pAraM gatavAn| ");
INSERT INTO sancol_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","tatO vyAdhimallOkasvAsthyakaraNarUpANi tasyAzcaryyANi karmmANi dRSTvA bahavO janAstatpazcAd agacchan| ");
INSERT INTO sancol_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","tatO yIzuH parvvatamAruhya tatra ziSyaiH sAkam| ");
INSERT INTO sancol_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","tasmin samaya nistArOtsavanAmni yihUdIyAnAma utsava upasthitE ");
INSERT INTO sancol_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","yIzu rnEtrE uttOlya bahulOkAn svasamIpAgatAn vilOkya philipaM pRSTavAn EtESAM bhOjanAya bhOjadravyANi vayaM kutra krEtuM zakrumaH? ");
INSERT INTO sancol_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","vAkyamidaM tasya parIkSArtham avAdIt kintu yat kariSyati tat svayam ajAnAt| ");
INSERT INTO sancol_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","philipaH pratyavOcat EtESAm EkaikO yadyalpam alpaM prApnOti tarhi mudrApAdadvizatEna krItapUpA api nyUnA bhaviSyanti| ");
INSERT INTO sancol_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","zimOn pitarasya bhrAtA AndriyAkhyaH ziSyANAmEkO vyAhRtavAn ");
INSERT INTO sancol_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","atra kasyacid bAlakasya samIpE panjca yAvapUpAH kSudramatsyadvayanjca santi kintu lOkAnAM EtAvAtAM madhyE taiH kiM bhaviSyati? ");
INSERT INTO sancol_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","pazcAd yIzuravadat lOkAnupavEzayata tatra bahuyavasasattvAt panjcasahastrEbhyO nyUnA adhikA vA puruSA bhUmyAm upAvizan| ");
INSERT INTO sancol_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","tatO yIzustAn pUpAnAdAya Izvarasya guNAn kIrttayitvA ziSyESu samArpayat tatastE tEbhya upaviSTalOkEbhyaH pUpAn yathESTamatsyanjca prAduH| ");
INSERT INTO sancol_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","tESu tRptESu sa tAnavOcad EtESAM kinjcidapi yathA nApacIyatE tathA sarvvANyavaziSTAni saMgRhlIta| ");
INSERT INTO sancol_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","tataH sarvvESAM bhOjanAt paraM tE tESAM panjcAnAM yAvapUpAnAM avaziSTAnyakhilAni saMgRhya dvAdazaPallakAn apUrayan| ");
INSERT INTO sancol_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","aparaM yIzOrEtAdRzIm AzcaryyakriyAM dRSTvA lOkA mithO vaktumArEbhirE jagati yasyAgamanaM bhaviSyati sa EvAyam avazyaM bhaviSyadvakttA| ");
INSERT INTO sancol_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ataEva lOkA Agatya tamAkramya rAjAnaM kariSyanti yIzustESAm IdRzaM mAnasaM vijnjAya punazca parvvatam EkAkI gatavAn| ");
INSERT INTO sancol_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","sAyaMkAla upasthitE ziSyA jaladhitaTaM vrajitvA nAvamAruhya nagaradizi sindhau vAhayitvAgaman| ");
INSERT INTO sancol_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","tasmin samayE timira upAtiSThat kintu yISustESAM samIpaM nAgacchat| ");
INSERT INTO sancol_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","tadA prabalapavanavahanAt sAgarE mahAtaraggO bhavitum ArEbhE| ");
INSERT INTO sancol_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","tatastE vAhayitvA dvitrAn krOzAn gatAH pazcAd yIzuM jaladhErupari padbhyAM vrajantaM naukAntikam AgacchantaM vilOkya trAsayuktA abhavan ");
INSERT INTO sancol_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","kintu sa tAnukttavAn ayamahaM mA bhaiSTa| ");
INSERT INTO sancol_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","tadA tE taM svairaM nAvi gRhItavantaH tadA tatkSaNAd uddiSTasthAnE naurupAsthAt| ");
INSERT INTO sancol_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","yayA nAvA ziSyA agacchan tadanyA kApi naukA tasmin sthAnE nAsIt tatO yIzuH ziSyaiH sAkaM nAgamat kEvalAH ziSyA agaman Etat pArasthA lOkA jnjAtavantaH| ");
INSERT INTO sancol_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","kintu tataH paraM prabhu ryatra Izvarasya guNAn anukIrttya lOkAn pUpAn abhOjayat tatsthAnasya samIpasthativiriyAyA aparAstaraNaya Agaman| ");
INSERT INTO sancol_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","yIzustatra nAsti ziSyA api tatra nA santi lOkA iti vijnjAya yIzuM gavESayituM taraNibhiH kapharnAhUm puraM gatAH| ");
INSERT INTO sancol_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","tatastE saritpatEH pArE taM sAkSAt prApya prAvOcan hE gurO bhavAn atra sthAnE kadAgamat? ");
INSERT INTO sancol_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","tadA yIzustAn pratyavAdId yuSmAnahaM yathArthataraM vadAmi AzcaryyakarmmadarzanAddhEtO rna kintu pUpabhOjanAt tEna tRptatvAnjca mAM gavESayatha| ");
INSERT INTO sancol_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","kSayaNIyabhakSyArthaM mA zrAmiSTa kintvantAyurbhakSyArthaM zrAmyata, tasmAt tAdRzaM bhakSyaM manujaputrO yuSmAbhyaM dAsyati; tasmin tAta IzvaraH pramANaM prAdAt| ");
INSERT INTO sancol_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","tadA tE'pRcchan IzvarAbhimataM karmma karttum asmAbhiH kiM karttavyaM? ");
INSERT INTO sancol_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","tatO yIzuravadad IzvarO yaM prairayat tasmin vizvasanam IzvarAbhimataM karmma| ");
INSERT INTO sancol_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","tadA tE vyAharan bhavatA kiM lakSaNaM darzitaM yaddRSTvA bhavati vizvasiSyAmaH? tvayA kiM karmma kRtaM? ");
INSERT INTO sancol_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","asmAkaM pUrvvapuruSA mahAprAntarE mAnnAM bhOkttuM prApuH yathA lipirAstE| svargIyANi tu bhakSyANi pradadau paramEzvaraH| ");
INSERT INTO sancol_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","tadA yIzuravadad ahaM yuSmAnatiyathArthaM vadAmi mUsA yuSmAbhyaM svargIyaM bhakSyaM nAdAt kintu mama pitA yuSmAbhyaM svargIyaM paramaM bhakSyaM dadAti| ");
INSERT INTO sancol_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","yaH svargAdavaruhya jagatE jIvanaM dadAti sa IzvaradattabhakSyarUpaH| ");
INSERT INTO sancol_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","tadA tE prAvOcan hE prabhO bhakSyamidaM nityamasmabhyaM dadAtu| ");
INSERT INTO sancol_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","yIzuravadad ahamEva jIvanarUpaM bhakSyaM yO janO mama sannidhim Agacchati sa jAtu kSudhArttO na bhaviSyati, tathA yO janO mAM pratyEti sa jAtu tRSArttO na bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","mAM dRSTvApi yUyaM na vizvasitha yuSmAnaham ityavOcaM| ");
INSERT INTO sancol_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","pitA mahyaM yAvatO lOkAnadadAt tE sarvva Eva mamAntikam AgamiSyanti yaH kazcicca mama sannidhim AyAsyati taM kEnApi prakArENa na dUrIkariSyAmi| ");
INSERT INTO sancol_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","nijAbhimataM sAdhayituM na hi kintu prErayiturabhimataM sAdhayituM svargAd AgatOsmi| ");
INSERT INTO sancol_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","sa yAn yAn lOkAn mahyamadadAt tESAmEkamapi na hArayitvA zESadinE sarvvAnaham utthApayAmi idaM matprErayituH piturabhimataM| ");
INSERT INTO sancol_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","yaH kazcin mAnavasutaM vilOkya vizvasiti sa zESadinE mayOtthApitaH san anantAyuH prApsyati iti matprErakasyAbhimataM| ");
INSERT INTO sancol_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","tadA svargAd yad bhakSyam avArOhat tad bhakSyam ahamEva yihUdIyalOkAstasyaitad vAkyE vivadamAnA vakttumArEbhirE ");
INSERT INTO sancol_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","yUSaphaH putrO yIzu ryasya mAtApitarau vayaM jAnIma ESa kiM saEva na? tarhi svargAd avArOham iti vAkyaM kathaM vaktti? ");
INSERT INTO sancol_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","tadA yIzustAn pratyavadat parasparaM mA vivadadhvaM ");
INSERT INTO sancol_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","matprErakENa pitrA nAkRSTaH kOpi janO mamAntikam AyAtuM na zaknOti kintvAgataM janaM caramE'hni prOtthApayiSyAmi| ");
INSERT INTO sancol_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","tE sarvva IzvarENa zikSitA bhaviSyanti bhaviSyadvAdinAM granthESu lipiritthamAstE atO yaH kazcit pituH sakAzAt zrutvA zikSatE sa Eva mama samIpam AgamiSyati| ");
INSERT INTO sancol_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ya IzvarAd ajAyata taM vinA kOpi manuSyO janakaM nAdarzat kEvalaH saEva tAtam adrAkSIt| ");
INSERT INTO sancol_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","ahaM yuSmAn yathArthataraM vadAmi yO janO mayi vizvAsaM karOti sOnantAyuH prApnOti| ");
INSERT INTO sancol_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ahamEva tajjIvanabhakSyaM| ");
INSERT INTO sancol_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","yuSmAkaM pUrvvapuruSA mahAprAntarE mannAbhakSyaM bhUkttApi mRtAH ");
INSERT INTO sancol_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","kintu yadbhakSyaM svargAdAgacchat tad yadi kazcid bhugkttE tarhi sa na mriyatE| ");
INSERT INTO sancol_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","yajjIvanabhakSyaM svargAdAgacchat sOhamEva idaM bhakSyaM yO janO bhugkttE sa nityajIvI bhaviSyati| punazca jagatO jIvanArthamahaM yat svakIyapizitaM dAsyAmi tadEva mayA vitaritaM bhakSyam| ");
INSERT INTO sancol_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","tasmAd yihUdIyAH parasparaM vivadamAnA vakttumArEbhirE ESa bhOjanArthaM svIyaM palalaM katham asmabhyaM dAsyati? ");
INSERT INTO sancol_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","tadA yIzustAn AvOcad yuSmAnahaM yathArthataraM vadAmi manuSyaputrasyAmiSE yuSmAbhi rna bhukttE tasya rudhirE ca na pItE jIvanEna sArddhaM yuSmAkaM sambandhO nAsti| ");
INSERT INTO sancol_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","yO mamAmiSaM svAdati mama sudhiranjca pivati sOnantAyuH prApnOti tataH zESE'hni tamaham utthApayiSyAmi| ");
INSERT INTO sancol_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","yatO madIyamAmiSaM paramaM bhakSyaM tathA madIyaM zONitaM paramaM pEyaM| ");
INSERT INTO sancol_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","yO janO madIyaM palalaM svAdati madIyaM rudhiranjca pivati sa mayi vasati tasminnahanjca vasAmi| ");
INSERT INTO sancol_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","matprErayitrA jIvatA tAtEna yathAhaM jIvAmi tadvad yaH kazcin mAmatti sOpi mayA jIviSyati| ");
INSERT INTO sancol_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","yadbhakSyaM svargAdAgacchat tadidaM yanmAnnAM svAditvA yuSmAkaM pitarO'mriyanta tAdRzam idaM bhakSyaM na bhavati idaM bhakSyaM yO bhakSati sa nityaM jIviSyati| ");
INSERT INTO sancol_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","yadA kapharnAhUm puryyAM bhajanagEhE upAdizat tadA kathA EtA akathayat| ");
INSERT INTO sancol_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","tadEtthaM zrutvA tasya ziSyANAm anEkE parasparam akathayan idaM gAPhaM vAkyaM vAkyamIdRzaM kaH zrOtuM zakruyAt? ");
INSERT INTO sancol_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","kintu yIzuH ziSyANAm itthaM vivAdaM svacittE vijnjAya kathitavAn idaM vAkyaM kiM yuSmAkaM vighnaM janayati? ");
INSERT INTO sancol_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","yadi manujasutaM pUrvvavAsasthAnam UrdvvaM gacchantaM pazyatha tarhi kiM bhaviSyati? ");
INSERT INTO sancol_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Atmaiva jIvanadAyakaH vapu rniSphalaM yuSmabhyamahaM yAni vacAMsi kathayAmi tAnyAtmA jIvananjca| ");
INSERT INTO sancol_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","kintu yuSmAkaM madhyE kEcana avizvAsinaH santi kE kE na vizvasanti kO vA taM parakarESu samarpayiSyati tAn yIzurAprathamAd vEtti| ");
INSERT INTO sancol_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","aparamapi kathitavAn asmAt kAraNAd akathayaM pituH sakAzAt zakttimaprApya kOpi mamAntikam AgantuM na zaknOti| ");
INSERT INTO sancol_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","tatkAlE'nEkE ziSyA vyAghuTya tEna sArddhaM puna rnAgacchan| ");
INSERT INTO sancol_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","tadA yIzu rdvAdazaziSyAn ukttavAn yUyamapi kiM yAsyatha? ");
INSERT INTO sancol_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","tataH zimOn pitaraH pratyavOcat hE prabhO kasyAbhyarNaM gamiSyAmaH? ");
INSERT INTO sancol_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","anantajIvanadAyinyO yAH kathAstAstavaiva| bhavAn amarEzvarasyAbhiSikttaputra iti vizvasya nizcitaM jAnImaH| ");
INSERT INTO sancol_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","tadA yIzuravadat kimahaM yuSmAkaM dvAdazajanAn manOnItAn na kRtavAn? kintu yuSmAkaM madhyEpi kazcidEkO vighnakArI vidyatE| ");
INSERT INTO sancol_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","imAM kathaM sa zimOnaH putram ISkarIyOtIyaM yihUdAm uddizya kathitavAn yatO dvAdazAnAM madhyE gaNitaH sa taM parakarESu samarpayiSyati| ");
INSERT INTO sancol_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","tataH paraM yihUdIyalOkAstaM hantuM samaihanta tasmAd yIzu ryihUdApradEzE paryyaTituM nEcchan gAlIl pradEzE paryyaTituM prArabhata| ");
INSERT INTO sancol_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","kintu tasmin samayE yihUdIyAnAM dUSyavAsanAmOtsava upasthitE ");
INSERT INTO sancol_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","tasya bhrAtarastam avadan yAni karmmANi tvayA kriyantE tAni yathA tava ziSyAH pazyanti tadarthaM tvamitaH sthAnAd yihUdIyadEzaM vraja| ");
INSERT INTO sancol_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","yaH kazcit svayaM pracikAziSati sa kadApi guptaM karmma na karOti yadIdRzaM karmma karOSi tarhi jagati nijaM paricAyaya| ");
INSERT INTO sancol_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","yatastasya bhrAtarOpi taM na vizvasanti| ");
INSERT INTO sancol_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","tadA yIzustAn avOcat mama samaya idAnIM nOpatiSThati kintu yuSmAkaM samayaH satatam upatiSThati| ");
INSERT INTO sancol_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","jagatO lOkA yuSmAn RtIyituM na zakruvanti kintu mAmEva RtIyantE yatastESAM karmANi duSTAni tatra sAkSyamidam ahaM dadAmi| ");
INSERT INTO sancol_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","ataEva yUyam utsavE'smin yAta nAham idAnIm asminnutsavE yAmi yatO mama samaya idAnIM na sampUrNaH| ");
INSERT INTO sancol_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","iti vAkyam ukttvA sa gAlIli sthitavAn ");
INSERT INTO sancol_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","kintu tasya bhrAtRSu tatra prasthitESu satsu sO'prakaTa utsavam agacchat| ");
INSERT INTO sancol_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","anantaram utsavam upasthitA yihUdIyAstaM mRgayitvApRcchan sa kutra? ");
INSERT INTO sancol_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","tatO lOkAnAM madhyE tasmin nAnAvidhA vivAdA bhavitum ArabdhavantaH| kEcid avOcan sa uttamaH puruSaH kEcid avOcan na tathA varaM lOkAnAM bhramaM janayati| ");
INSERT INTO sancol_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","kintu yihUdIyAnAM bhayAt kOpi tasya pakSE spaSTaM nAkathayat| ");
INSERT INTO sancol_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","tataH param utsavasya madhyasamayE yIzu rmandiraM gatvA samupadizati sma| ");
INSERT INTO sancol_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","tatO yihUdIyA lOkA AzcaryyaM jnjAtvAkathayan ESA mAnuSO nAdhItyA katham EtAdRzO vidvAnabhUt? ");
INSERT INTO sancol_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","tadA yIzuH pratyavOcad upadEzOyaM na mama kintu yO mAM prESitavAn tasya| ");
INSERT INTO sancol_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","yO janO nidEzaM tasya grahISyati mamOpadEzO mattO bhavati kim IzvarAd bhavati sa ganastajjnjAtuM zakSyati| ");
INSERT INTO sancol_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","yO janaH svataH kathayati sa svIyaM gauravam IhatE kintu yaH prErayitu rgauravam IhatE sa satyavAdI tasmin kOpyadharmmO nAsti| ");
INSERT INTO sancol_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","mUsA yuSmabhyaM vyavasthAgranthaM kiM nAdadAt? kintu yuSmAkaM kOpi tAM vyavasthAM na samAcarati| mAM hantuM kutO yatadhvE? ");
INSERT INTO sancol_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","tadA lOkA avadan tvaM bhUtagrastastvAM hantuM kO yatatE? ");
INSERT INTO sancol_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","tatO yIzuravOcad EkaM karmma mayAkAri tasmAd yUyaM sarvva mahAzcaryyaM manyadhvE| ");
INSERT INTO sancol_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","mUsA yuSmabhyaM tvakchEdavidhiM pradadau sa mUsAtO na jAtaH kintu pitRpuruSEbhyO jAtaH tEna vizrAmavArE'pi mAnuSANAM tvakchEdaM kurutha| ");
INSERT INTO sancol_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ataEva vizrAmavArE manuSyANAM tvakchEdE kRtE yadi mUsAvyavasthAmagganaM na bhavati tarhi mayA vizrAmavArE mAnuSaH sampUrNarUpENa svasthO'kAri tatkAraNAd yUyaM kiM mahyaM kupyatha? ");
INSERT INTO sancol_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","sapakSapAtaM vicAramakRtvA nyAyyaM vicAraM kuruta| ");
INSERT INTO sancol_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","tadA yirUzAlam nivAsinaH katipayajanA akathayan imE yaM hantuM cESTantE sa EvAyaM kiM na? ");
INSERT INTO sancol_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","kintu pazyata nirbhayaH san kathAM kathayati tathApi kimapi a vadantyEtE ayamEvAbhiSikttO bhavatIti nizcitaM kimadhipatayO jAnanti? ");
INSERT INTO sancol_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","manujOyaM kasmAdAgamad iti vayaM jAnOmaH kintvabhiSiktta AgatE sa kasmAdAgatavAn iti kOpi jnjAtuM na zakSyati| ");
INSERT INTO sancol_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","tadA yIzu rmadhyEmandiram upadizan uccaiHkAram ukttavAn yUyaM kiM mAM jAnItha? kasmAccAgatOsmi tadapi kiM jAnItha? nAhaM svata AgatOsmi kintu yaH satyavAdI saEva mAM prESitavAn yUyaM taM na jAnItha| ");
INSERT INTO sancol_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","tamahaM jAnE tEnAhaM prErita agatOsmi| ");
INSERT INTO sancol_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","tasmAd yihUdIyAstaM dharttum udyatAstathApi kOpi tasya gAtrE hastaM nArpayad yatO hEtOstadA tasya samayO nOpatiSThati| ");
INSERT INTO sancol_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","kintu bahavO lOkAstasmin vizvasya kathitavAntO'bhiSikttapuruSa Agatya mAnuSasyAsya kriyAbhyaH kim adhikA AzcaryyAH kriyAH kariSyati? ");
INSERT INTO sancol_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","tataH paraM lOkAstasmin itthaM vivadantE phirUzinaH pradhAnayAjakAnjcEti zrutavantastaM dhRtvA nEtuM padAtigaNaM prESayAmAsuH| ");
INSERT INTO sancol_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","tatO yIzuravadad aham alpadinAni yuSmAbhiH sArddhaM sthitvA matprErayituH samIpaM yAsyAmi| ");
INSERT INTO sancol_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","mAM mRgayiSyadhvE kintUddEzaM na lapsyadhvE ratra sthAsyAmi tatra yUyaM gantuM na zakSyatha| ");
INSERT INTO sancol_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","tadA yihUdIyAH parasparaM vakttumArEbhirE asyOddEzaM na prApsyAma EtAdRzaM kiM sthAnaM yAsyati? bhinnadEzE vikIrNAnAM yihUdIyAnAM sannidhim ESa gatvA tAn upadEkSyati kiM? ");
INSERT INTO sancol_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","nO cEt mAM gavESayiSyatha kintUddEzaM na prApsyatha ESa kOdRzaM vAkyamidaM vadati? ");
INSERT INTO sancol_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","anantaram utsavasya caramE'hani arthAt pradhAnadinE yIzuruttiSThan uccaiHkAram Ahvayan uditavAn yadi kazcit tRSArttO bhavati tarhi mamAntikam Agatya pivatu| ");
INSERT INTO sancol_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","yaH kazcinmayi vizvasiti dharmmagranthasya vacanAnusArENa tasyAbhyantaratO'mRtatOyasya srOtAMsi nirgamiSyanti| ");
INSERT INTO sancol_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","yE tasmin vizvasanti ta AtmAnaM prApsyantItyarthE sa idaM vAkyaM vyAhRtavAn EtatkAlaM yAvad yIzu rvibhavaM na prAptastasmAt pavitra AtmA nAdIyata| ");
INSERT INTO sancol_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","EtAM vANIM zrutvA bahavO lOkA avadan ayamEva nizcitaM sa bhaviSyadvAdI| ");
INSERT INTO sancol_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","kEcid akathayan ESaEva sObhiSikttaH kintu kEcid avadan sObhiSikttaH kiM gAlIl pradEzE janiSyatE? ");
INSERT INTO sancol_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","sObhiSikttO dAyUdO vaMzE dAyUdO janmasthAnE baitlEhami pattanE janiSyatE dharmmagranthE kimitthaM likhitaM nAsti? ");
INSERT INTO sancol_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","itthaM tasmin lOkAnAM bhinnavAkyatA jAtA| ");
INSERT INTO sancol_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","katipayalOkAstaM dharttum aicchan tathApi tadvapuSi kOpi hastaM nArpayat| ");
INSERT INTO sancol_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","anantaraM pAdAtigaNE pradhAnayAjakAnAM phirUzinAnjca samIpamAgatavati tE tAn apRcchan kutO hEtOstaM nAnayata? ");
INSERT INTO sancol_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","tadA padAtayaH pratyavadan sa mAnava iva kOpi kadApi nOpAdizat| ");
INSERT INTO sancol_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","tataH phirUzinaH prAvOcan yUyamapi kimabhrAmiSTa? ");
INSERT INTO sancol_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","adhipatInAM phirUzinAnjca kOpi kiM tasmin vyazvasIt? ");
INSERT INTO sancol_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","yE zAstraM na jAnanti ta imE'dhamalOkAEva zApagrastAH| ");
INSERT INTO sancol_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","tadA nikadImanAmA tESAmEkO yaH kSaNadAyAM yIzOH sannidhim agAt sa ukttavAn ");
INSERT INTO sancol_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","tasya vAkyE na zrutE karmmaNi ca na viditE 'smAkaM vyavasthA kiM kanjcana manujaM dOSIkarOti? ");
INSERT INTO sancol_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","tatastE vyAharan tvamapi kiM gAlIlIyalOkaH? vivicya pazya galIli kOpi bhaviSyadvAdI nOtpadyatE| ");
INSERT INTO sancol_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","tataH paraM sarvvE svaM svaM gRhaM gatAH kintu yIzu rjaitunanAmAnaM zilOccayaM gatavAn| ");
INSERT INTO sancol_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","pratyUSE yIzuH panarmandiram Agacchat ");
INSERT INTO sancol_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","tataH sarvvESu lOkESu tasya samIpa AgatESu sa upavizya tAn upadESTum Arabhata| ");
INSERT INTO sancol_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","tadA adhyApakAH phirUzinanjca vyabhicArakarmmaNi dhRtaM striyamEkAm Aniya sarvvESAM madhyE sthApayitvA vyAharan ");
INSERT INTO sancol_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","hE gurO yOSitam imAM vyabhicArakarmma kurvvANAM lOkA dhRtavantaH| ");
INSERT INTO sancol_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","EtAdRzalOkAH pASANAghAtEna hantavyA iti vidhirmUsAvyavasthAgranthE likhitOsti kintu bhavAn kimAdizati? ");
INSERT INTO sancol_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","tE tamapavadituM parIkSAbhiprAyENa vAkyamidam apRcchan kintu sa prahvIbhUya bhUmAvaggalyA lEkhitum Arabhata| ");
INSERT INTO sancol_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","tatastaiH punaH punaH pRSTa utthAya kathitavAn yuSmAkaM madhyE yO janO niraparAdhI saEva prathamam EnAM pASANEnAhantu| ");
INSERT INTO sancol_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","pazcAt sa punazca prahvIbhUya bhUmau lEkhitum Arabhata| ");
INSERT INTO sancol_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","tAM kathaM zrutvA tE svasvamanasi prabOdhaM prApya jyESThAnukramaM EkaikazaH sarvvE bahiragacchan tatO yIzurEkAkI tayakttObhavat madhyasthAnE daNPAyamAnA sA yOSA ca sthitA| ");
INSERT INTO sancol_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","tatpazcAd yIzurutthAya tAM vanitAM vinA kamapyaparaM na vilOkya pRSTavAn hE vAmE tavApavAdakAH kutra? kOpi tvAM kiM na daNPayati? ");
INSERT INTO sancol_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","sAvadat hE mahEccha kOpi na tadA yIzuravOcat nAhamapi daNPayAmi yAhi punaH pApaM mAkArSIH| ");
INSERT INTO sancol_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","tatO yIzuH punarapi lOkEbhya itthaM kathayitum Arabhata jagatOhaM jyOtiHsvarUpO yaH kazcin matpazcAda gacchati sa timirE na bhramitvA jIvanarUpAM dIptiM prApsyati| ");
INSERT INTO sancol_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","tataH phirUzinO'vAdiSustvaM svArthE svayaM sAkSyaM dadAsi tasmAt tava sAkSyaM grAhyaM na bhavati| ");
INSERT INTO sancol_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","tadA yIzuH pratyuditavAn yadyapi svArthE'haM svayaM sAkSyaM dadAmi tathApi mat sAkSyaM grAhyaM yasmAd ahaM kuta AgatOsmi kva yAmi ca tadahaM jAnAmi kintu kuta AgatOsmi kutra gacchAmi ca tad yUyaM na jAnItha| ");
INSERT INTO sancol_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","yUyaM laukikaM vicArayatha nAhaM kimapi vicArayAmi| ");
INSERT INTO sancol_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","kintu yadi vicArayAmi tarhi mama vicArO grahItavyO yatOham EkAkI nAsmi prErayitA pitA mayA saha vidyatE| ");
INSERT INTO sancol_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","dvayO rjanayOH sAkSyaM grahaNIyaM bhavatIti yuSmAkaM vyavasthAgranthE likhitamasti| ");
INSERT INTO sancol_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ahaM svArthE svayaM sAkSitvaM dadAmi yazca mama tAtO mAM prEritavAn sOpi madarthE sAkSyaM dadAti| ");
INSERT INTO sancol_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","tadA tE'pRcchan tava tAtaH kutra? tatO yIzuH pratyavAdId yUyaM mAM na jAnItha matpitaranjca na jAnItha yadi mAm akSAsyata tarhi mama tAtamapyakSAsyata| ");
INSERT INTO sancol_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","yIzu rmandira upadizya bhaNPAgArE kathA EtA akathayat tathApi taM prati kOpi karaM nOdatOlayat| ");
INSERT INTO sancol_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","tataH paraM yIzuH punaruditavAn adhunAhaM gacchAmi yUyaM mAM gavESayiSyatha kintu nijaiH pApai rmariSyatha yat sthAnam ahaM yAsyAmi tat sthAnam yUyaM yAtuM na zakSyatha| ");
INSERT INTO sancol_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","tadA yihUdIyAH prAvOcan kimayam AtmaghAtaM kariSyati? yatO yat sthAnam ahaM yAsyAmi tat sthAnam yUyaM yAtuM na zakSyatha iti vAkyaM bravIti| ");
INSERT INTO sancol_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","tatO yIzustEbhyaH kathitavAn yUyam adhaHsthAnIyA lOkA aham UrdvvasthAnIyaH yUyam EtajjagatsambandhIyA aham EtajjagatsambandhIyO na| ");
INSERT INTO sancol_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","tasmAt kathitavAn yUyaM nijaiH pApai rmariSyatha yatOhaM sa pumAn iti yadi na vizvasitha tarhi nijaiH pApai rmariSyatha| ");
INSERT INTO sancol_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","tadA tE 'pRcchan kastvaM? tatO yIzuH kathitavAn yuSmAkaM sannidhau yasya prastAvam A prathamAt karOmi saEva puruSOhaM| ");
INSERT INTO sancol_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","yuSmAsu mayA bahuvAkyaM vakttavyaM vicArayitavyanjca kintu matprErayitA satyavAdI tasya samIpE yadahaM zrutavAn tadEva jagatE kathayAmi| ");
INSERT INTO sancol_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","kintu sa janakE vAkyamidaM prOkttavAn iti tE nAbudhyanta| ");
INSERT INTO sancol_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","tatO yIzurakathayad yadA manuSyaputram Urdvva utthApayiSyatha tadAhaM sa pumAn kEvalaH svayaM kimapi karmma na karOmi kintu tAtO yathA zikSayati tadanusArENa vAkyamidaM vadAmIti ca yUyaM jnjAtuM zakSyatha| ");
INSERT INTO sancol_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","matprErayitA pitA mAm EkAkinaM na tyajati sa mayA sArddhaM tiSThati yatOhaM tadabhimataM karmma sadA karOmi| ");
INSERT INTO sancol_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","tadA tasyaitAni vAkyAni zrutvA bahuvastAsmin vyazvasan| ");
INSERT INTO sancol_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","yE yihUdIyA vyazvasan yIzustEbhyO'kathayat ");
INSERT INTO sancol_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","mama vAkyE yadi yUyam AsthAM kurutha tarhi mama ziSyA bhUtvA satyatvaM jnjAsyatha tataH satyatayA yuSmAkaM mOkSO bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","tadA tE pratyavAdiSuH vayam ibrAhImO vaMzaH kadApi kasyApi dAsA na jAtAstarhi yuSmAkaM muktti rbhaviSyatIti vAkyaM kathaM bravISi? ");
INSERT INTO sancol_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","tadA yIzuH pratyavadad yuSmAnahaM yathArthataraM vadAmi yaH pApaM karOti sa pApasya dAsaH| ");
INSERT INTO sancol_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","dAsazca nirantaraM nivEzanE na tiSThati kintu putrO nirantaraM tiSThati| ");
INSERT INTO sancol_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","ataH putrO yadi yuSmAn mOcayati tarhi nitAntamEva mukttA bhaviSyatha| ");
INSERT INTO sancol_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","yuyam ibrAhImO vaMza ityahaM jAnAmi kintu mama kathA yuSmAkam antaHkaraNESu sthAnaM na prApnuvanti tasmAddhEtO rmAM hantum IhadhvE| ");
INSERT INTO sancol_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","ahaM svapituH samIpE yadapazyaM tadEva kathayAmi tathA yUyamapi svapituH samIpE yadapazyata tadEva kurudhvE| ");
INSERT INTO sancol_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","tadA tE pratyavOcan ibrAhIm asmAkaM pitA tatO yIzurakathayad yadi yUyam ibrAhImaH santAnA abhaviSyata tarhi ibrAhIma AcAraNavad AcariSyata| ");
INSERT INTO sancol_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Izvarasya mukhAt satyaM vAkyaM zrutvA yuSmAn jnjApayAmi yOhaM taM mAM hantuM cESTadhvE ibrAhIm EtAdRzaM karmma na cakAra| ");
INSERT INTO sancol_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","yUyaM svasvapituH karmmANi kurutha tadA tairukttaM na vayaM jArajAtA asmAkam EkaEva pitAsti sa EvEzvaraH ");
INSERT INTO sancol_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","tatO yIzunA kathitam IzvarO yadi yuSmAkaM tAtObhaviSyat tarhi yUyaM mayi prEmAkariSyata yatOham IzvarAnnirgatyAgatOsmi svatO nAgatOhaM sa mAM prAhiNOt| ");
INSERT INTO sancol_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","yUyaM mama vAkyamidaM na budhyadhvE kutaH? yatO yUyaM mamOpadEzaM sOPhuM na zaknutha| ");
INSERT INTO sancol_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","yUyaM zaitAn pituH santAnA EtasmAd yuSmAkaM piturabhilASaM pUrayatha sa A prathamAt naraghAtI tadantaH satyatvasya lEzOpi nAsti kAraNAdataH sa satyatAyAM nAtiSThat sa yadA mRSA kathayati tadA nijasvabhAvAnusArENaiva kathayati yatO sa mRSAbhASI mRSOtpAdakazca| ");
INSERT INTO sancol_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","ahaM tathyavAkyaM vadAmi kAraNAdasmAd yUyaM mAM na pratItha| ");
INSERT INTO sancol_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","mayi pApamastIti pramANaM yuSmAkaM kO dAtuM zaknOti? yadyahaM tathyavAkyaM vadAmi tarhi kutO mAM na pratitha? ");
INSERT INTO sancol_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","yaH kazcana IzvarIyO lOkaH sa IzvarIyakathAyAM manO nidhattE yUyam IzvarIyalOkA na bhavatha tannidAnAt tatra na manAMsi nidhadvE| ");
INSERT INTO sancol_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","tadA yihUdIyAH pratyavAdiSuH tvamEkaH zOmirONIyO bhUtagrastazca vayaM kimidaM bhadraM nAvAdiSma? ");
INSERT INTO sancol_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","tatO yIzuH pratyavAdIt nAhaM bhUtagrastaH kintu nijatAtaM sammanyE tasmAd yUyaM mAm apamanyadhvE| ");
INSERT INTO sancol_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","ahaM svasukhyAtiM na cESTE kintu cESTitA vicArayitA cApara Eka AstE| ");
INSERT INTO sancol_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ahaM yuSmabhyam atIva yathArthaM kathayAmi yO narO madIyaM vAcaM manyatE sa kadAcana nidhanaM na drakSyati| ");
INSERT INTO sancol_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","yihUdIyAstamavadan tvaM bhUtagrasta itIdAnIm avaiSma| ibrAhIm bhaviSyadvAdinanjca sarvvE mRtAH kintu tvaM bhASasE yO narO mama bhAratIM gRhlAti sa jAtu nidhAnAsvAdaM na lapsyatE| ");
INSERT INTO sancol_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","tarhi tvaM kim asmAkaM pUrvvapuruSAd ibrAhImOpi mahAn? yasmAt sOpi mRtaH bhaviSyadvAdinOpi mRtAH tvaM svaM kaM pumAMsaM manuSE? ");
INSERT INTO sancol_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","yIzuH pratyavOcad yadyahaM svaM svayaM sammanyE tarhi mama tat sammananaM kimapi na kintu mama tAtO yaM yUyaM svIyam IzvaraM bhASadhvE saEva mAM sammanutE| ");
INSERT INTO sancol_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","yUyaM taM nAvagacchatha kintvahaM tamavagacchAmi taM nAvagacchAmIti vAkyaM yadi vadAmi tarhi yUyamiva mRSAbhASI bhavAmi kintvahaM tamavagacchAmi tadAkSAmapi gRhlAmi| ");
INSERT INTO sancol_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","yuSmAkaM pUrvvapuruSa ibrAhIm mama samayaM draSTum atIvAvAnjchat tannirIkSyAnandacca| ");
INSERT INTO sancol_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","tadA yihUdIyA apRcchan tava vayaH panjcAzadvatsarA na tvaM kim ibrAhImam adrAkSIH? ");
INSERT INTO sancol_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","yIzuH pratyavAdId yuSmAnahaM yathArthataraM vadAmi ibrAhImO janmanaH pUrvvakAlamArabhyAhaM vidyE| ");
INSERT INTO sancol_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","tadA tE pASANAn uttOlya tamAhantum udayacchan kintu yIzu rguptO mantirAd bahirgatya tESAM madhyEna prasthitavAn| ");
INSERT INTO sancol_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","tataH paraM yIzurgacchan mArgamadhyE janmAndhaM naram apazyat| ");
INSERT INTO sancol_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","tataH ziSyAstam apRcchan hE gurO narOyaM svapApEna vA svapitrAH pApEnAndhO'jAyata? ");
INSERT INTO sancol_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","tataH sa pratyuditavAn Etasya vAsya pitrOH pApAd EtAdRzObhUda iti nahi kintvanEna yathEzvarasya karmma prakAzyatE taddhEtOrEva| ");
INSERT INTO sancol_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","dinE tiSThati matprErayituH karmma mayA karttavyaM yadA kimapi karmma na kriyatE tAdRzI nizAgacchati| ");
INSERT INTO sancol_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ahaM yAvatkAlaM jagati tiSThAmi tAvatkAlaM jagatO jyOtiHsvarUpOsmi| ");
INSERT INTO sancol_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ityukttA bhUmau niSThIvaM nikSipya tEna pagkaM kRtavAn ");
INSERT INTO sancol_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","pazcAt tatpagkEna tasyAndhasya nEtrE pralipya tamityAdizat gatvA zilOhE 'rthAt prEritanAmni sarasi snAhi| tatOndhO gatvA tatrAsnAt tataH prannacakSu rbhUtvA vyAghuTyAgAt| ");
INSERT INTO sancol_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","aparanjca samIpavAsinO lOkA yE ca taM pUrvvamandham apazyan tE bakttum Arabhanta yOndhalOkO vartmanyupavizyAbhikSata sa EvAyaM janaH kiM na bhavati? ");
INSERT INTO sancol_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","kEcidavadan sa Eva kEcidavOcan tAdRzO bhavati kintu sa svayamabravIt sa EvAhaM bhavAmi| ");
INSERT INTO sancol_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ataEva tE 'pRcchan tvaM kathaM dRSTiM pAptavAn? ");
INSERT INTO sancol_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","tataH sOvadad yIzanAmaka EkO janO mama nayanE pagkEna pralipya ityAjnjApayat zilOhakAsAraM gatvA tatra snAhi| tatastatra gatvA mayi snAtE dRSTimahaM labdhavAn| ");
INSERT INTO sancol_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","tadA tE 'vadan sa pumAn kutra? tEnOkttaM nAhaM jAnAmi| ");
INSERT INTO sancol_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","aparaM tasmin pUrvvAndhE janE phirUzinAM nikaTam AnItE sati phirUzinOpi tamapRcchan kathaM dRSTiM prAptOsi? ");
INSERT INTO sancol_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","tataH sa kathitavAn sa pagkEna mama nEtrE 'limpat pazcAd snAtvA dRSTimalabhE| ");
INSERT INTO sancol_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","kintu yIzu rvizrAmavArE karddamaM kRtvA tasya nayanE prasannE'karOd itikAraNAt katipayaphirUzinO'vadan ");
INSERT INTO sancol_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","sa pumAn IzvarAnna yataH sa vizrAmavAraM na manyatE| tatOnyE kEcit pratyavadan pApI pumAn kim EtAdRzam AzcaryyaM karmma karttuM zaknOti? ");
INSERT INTO sancol_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","itthaM tESAM parasparaM bhinnavAkyatvam abhavat| pazcAt tE punarapi taM pUrvvAndhaM mAnuSam aprAkSuH yO janastava cakSuSI prasannE kRtavAn tasmin tvaM kiM vadasi? sa ukttavAn sa bhavizadvAdI| ");
INSERT INTO sancol_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","sa dRSTim AptavAn iti yihUdIyAstasya dRSTiM prAptasya janasya pitrO rmukhAd azrutvA na pratyayan| ");
INSERT INTO sancol_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ataEva tE tAvapRcchan yuvayO ryaM putraM janmAndhaM vadathaH sa kimayaM? tarhIdAnIM kathaM draSTuM zaknOti? ");
INSERT INTO sancol_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","tatastasya pitarau pratyavOcatAm ayam AvayOH putra A janErandhazca tadapyAvAM jAnIvaH ");
INSERT INTO sancol_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","kintvadhunA kathaM dRSTiM prAptavAn tadAvAM n jAnIvaH kOsya cakSuSI prasannE kRtavAn tadapi na jAnIva ESa vayaHprApta EnaM pRcchata svakathAM svayaM vakSyati| ");
INSERT INTO sancol_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","yihUdIyAnAM bhayAt tasya pitarau vAkyamidam avadatAM yataH kOpi manuSyO yadi yIzum abhiSiktaM vadati tarhi sa bhajanagRhAd dUrIkAriSyatE yihUdIyA iti mantraNAm akurvvan ");
INSERT INTO sancol_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","atastasya pitarau vyAharatAm ESa vayaHprApta EnaM pRcchata| ");
INSERT INTO sancol_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","tadA tE punazca taM pUrvvAndham AhUya vyAharan Izvarasya guNAn vada ESa manuSyaH pApIti vayaM jAnImaH| ");
INSERT INTO sancol_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","tadA sa ukttavAn sa pApI na vEti nAhaM jAnE pUrvAmandha Asamaham adhunA pazyAmIti mAtraM jAnAmi| ");
INSERT INTO sancol_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","tE punarapRcchan sa tvAM prati kimakarOt? kathaM nEtrE prasannE 'karOt? ");
INSERT INTO sancol_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","tataH sOvAdId EkakRtvOkathayaM yUyaM na zRNutha tarhi kutaH punaH zrOtum icchatha? yUyamapi kiM tasya ziSyA bhavitum icchatha? ");
INSERT INTO sancol_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","tadA tE taM tiraskRtya vyAharan tvaM tasya ziSyO vayaM mUsAH ziSyAH| ");
INSERT INTO sancol_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","mUsAvaktrENEzvarO jagAda tajjAnImaH kintvESa kutratyalOka iti na jAnImaH| ");
INSERT INTO sancol_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","sOvadad ESa mama lOcanE prasannE 'karOt tathApi kutratyalOka iti yUyaM na jAnItha Etad AzcaryyaM bhavati| ");
INSERT INTO sancol_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","IzvaraH pApinAM kathAM na zRNOti kintu yO janastasmin bhaktiM kRtvA tadiSTakriyAM karOti tasyaiva kathAM zRNOti Etad vayaM jAnImaH| ");
INSERT INTO sancol_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","kOpi manuSyO janmAndhAya cakSuSI adadAt jagadArambhAd EtAdRzIM kathAM kOpi kadApi nAzRNOt| ");
INSERT INTO sancol_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","asmAd ESa manuSyO yadIzvarAnnAjAyata tarhi kinjcidapIdRzaM karmma karttuM nAzaknOt| ");
INSERT INTO sancol_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","tE vyAharan tvaM pApAd ajAyathAH kimasmAn tvaM zikSayasi? pazcAttE taM bahirakurvvan| ");
INSERT INTO sancol_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","tadanantaraM yihUdIyaiH sa bahirakriyata yIzuriti vArttAM zrutvA taM sAkSAt prApya pRSTavAn Izvarasya putrE tvaM vizvasiSi? ");
INSERT INTO sancol_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","tadA sa pratyavOcat hE prabhO sa kO yat tasminnahaM vizvasimi? ");
INSERT INTO sancol_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","tatO yIzuH kathitavAn tvaM taM dRSTavAn tvayA sAkaM yaH kathaM kathayati saEva saH| ");
INSERT INTO sancol_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","tadA hE prabhO vizvasimItyuktvA sa taM praNAmat| ");
INSERT INTO sancol_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","pazcAd yIzuH kathitavAn nayanahInA nayanAni prApnuvanti nayanavantazcAndhA bhavantItyabhiprAyENa jagadAham Agaccham| ");
INSERT INTO sancol_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Etat zrutvA nikaTasthAH katipayAH phirUzinO vyAharan vayamapi kimandhAH? ");
INSERT INTO sancol_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","tadA yIzuravAdId yadyandhA abhavata tarhi pApAni nAtiSThan kintu pazyAmIti vAkyavadanAd yuSmAkaM pApAni tiSThanti| ");
INSERT INTO sancol_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","ahaM yuSmAnatiyathArthaM vadAmi, yO janO dvArENa na pravizya kEnApyanyEna mESagRhaM pravizati sa Eva stEnO dasyuzca| ");
INSERT INTO sancol_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","yO dvArENa pravizati sa Eva mESapAlakaH| ");
INSERT INTO sancol_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","dauvArikastasmai dvAraM mOcayati mESagaNazca tasya vAkyaM zRNOti sa nijAn mESAn svasvanAmnAhUya bahiH kRtvA nayati| ");
INSERT INTO sancol_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","tathA nijAn mESAn bahiH kRtvA svayaM tESAm agrE gacchati, tatO mESAstasya zabdaM budhyantE, tasmAt tasya pazcAd vrajanti| ");
INSERT INTO sancol_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","kintu parasya zabdaM na budhyantE tasmAt tasya pazcAd vrajiSyanti varaM tasya samIpAt palAyiSyantE| ");
INSERT INTO sancol_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","yIzustEbhya imAM dRSTAntakathAm akathayat kintu tEna kathitakathAyAstAtparyyaM tE nAbudhyanta| ");
INSERT INTO sancol_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","atO yIzuH punarakathayat, yuSmAnAhaM yathArthataraM vyAharAmi, mESagRhasya dvAram ahamEva| ");
INSERT INTO sancol_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","mayA na pravizya ya Agacchan tE stEnA dasyavazca kintu mESAstESAM kathA nAzRNvan| ");
INSERT INTO sancol_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","ahamEva dvArasvarUpaH, mayA yaH kazcita pravizati sa rakSAM prApsyati tathA bahirantazca gamanAgamanE kRtvA caraNasthAnaM prApsyati| ");
INSERT INTO sancol_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","yO janastEnaH sa kEvalaM stainyabadhavinAzAn karttumEva samAyAti kintvaham Ayu rdAtum arthAt bAhUlyEna tadEva dAtum Agaccham| ");
INSERT INTO sancol_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","ahamEva satyamESapAlakO yastu satyO mESapAlakaH sa mESArthaM prANatyAgaM karOti; ");
INSERT INTO sancol_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","kintu yO janO mESapAlakO na, arthAd yasya mESA nijA na bhavanti, ya EtAdRzO vaitanikaH sa vRkam AgacchantaM dRSTvA mEjavrajaM vihAya palAyatE, tasmAd vRkastaM vrajaM dhRtvA vikirati| ");
INSERT INTO sancol_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","vaitanikaH palAyatE yataH sa vEtanArthI mESArthaM na cintayati| ");
INSERT INTO sancol_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","ahamEva satyO mESapAlakaH, pitA mAM yathA jAnAti, ahanjca yathA pitaraM jAnAmi, ");
INSERT INTO sancol_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","tathA nijAn mESAnapi jAnAmi, mESAzca mAM jAnAnti, ahanjca mESArthaM prANatyAgaM karOmi| ");
INSERT INTO sancol_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","aparanjca Etad gRhIya mESEbhyO bhinnA api mESA mama santi tE sakalA AnayitavyAH; tE mama zabdaM zrOSyanti tata EkO vraja EkO rakSakO bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","prANAnahaM tyaktvA punaH prANAn grahISyAmi, tasmAt pitA mayi snEhaM karOti| ");
INSERT INTO sancol_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","kazcijjanO mama prANAn hantuM na zaknOti kintu svayaM tAn samarpayAmi tAn samarpayituM punargrahItunjca mama zaktirAstE bhAramimaM svapituH sakAzAt prAptOham| ");
INSERT INTO sancol_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","asmAdupadEzAt punazca yihUdIyAnAM madhyE bhinnavAkyatA jAtA| ");
INSERT INTO sancol_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","tatO bahavO vyAharan ESa bhUtagrasta unmattazca, kuta Etasya kathAM zRNutha? ");
INSERT INTO sancol_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","kEcid avadan Etasya kathA bhUtagrastasya kathAvanna bhavanti, bhUtaH kim andhAya cakSuSI dAtuM zaknOti? ");
INSERT INTO sancol_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","zItakAlE yirUzAlami mandirOtsargaparvvaNyupasthitE ");
INSERT INTO sancol_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","yIzuH sulEmAnO niHsArENa gamanAgamanE karOti, ");
INSERT INTO sancol_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Etasmin samayE yihUdIyAstaM vESTayitvA vyAharan kati kAlAn asmAkaM vicikitsAM sthApayiSyAmi? yadyabhiSiktO bhavati tarhi tat spaSTaM vada| ");
INSERT INTO sancol_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","tadA yIzuH pratyavadad aham acakathaM kintu yUyaM na pratItha, nijapitu rnAmnA yAM yAM kriyAM karOmi sA kriyaiva mama sAkSisvarUpA| ");
INSERT INTO sancol_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","kintvahaM pUrvvamakathayaM yUyaM mama mESA na bhavatha, kAraNAdasmAn na vizvasitha| ");
INSERT INTO sancol_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","mama mESA mama zabdaM zRNvanti tAnahaM jAnAmi tE ca mama pazcAd gacchanti| ");
INSERT INTO sancol_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","ahaM tEbhyO'nantAyu rdadAmi, tE kadApi na naMkSyanti kOpi mama karAt tAn harttuM na zakSyati| ");
INSERT INTO sancol_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","yO mama pitA tAn mahyaM dattavAn sa sarvvasmAt mahAn, kOpi mama pituH karAt tAn harttuM na zakSyati| ");
INSERT INTO sancol_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ahaM pitA ca dvayOrEkatvam| ");
INSERT INTO sancol_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","tatO yihUdIyAH punarapi taM hantuM pASANAn udatOlayan| ");
INSERT INTO sancol_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","yIzuH kathitavAn pituH sakAzAd bahUnyuttamakarmmANi yuSmAkaM prAkAzayaM tESAM kasya karmmaNaH kAraNAn mAM pASANairAhantum udyatAH stha? ");
INSERT INTO sancol_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","yihUdIyAH pratyavadan prazastakarmmahEtO rna kintu tvaM mAnuSaH svamIzvaram uktvEzvaraM nindasi kAraNAdasmAt tvAM pASANairhanmaH| ");
INSERT INTO sancol_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","tadA yIzuH pratyuktavAn mayA kathitaM yUyam IzvarA EtadvacanaM yuSmAkaM zAstrE likhitaM nAsti kiM? ");
INSERT INTO sancol_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","tasmAd yESAm uddEzE Izvarasya kathA kathitA tE yadIzvaragaNA ucyantE dharmmagranthasyApyanyathA bhavituM na zakyaM, ");
INSERT INTO sancol_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","tarhyAham Izvarasya putra iti vAkyasya kathanAt yUyaM pitrAbhiSiktaM jagati prEritanjca pumAMsaM katham IzvaranindakaM vAdaya? ");
INSERT INTO sancol_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","yadyahaM pituH karmma na karOmi tarhi mAM na pratIta; ");
INSERT INTO sancol_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","kintu yadi karOmi tarhi mayi yuSmAbhiH pratyayE na kRtE'pi kAryyE pratyayaH kriyatAM, tatO mayi pitAstIti pitaryyaham asmIti ca kSAtvA vizvasiSyatha| ");
INSERT INTO sancol_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","tadA tE punarapi taM dharttum acESTanta kintu sa tESAM karEbhyO nistIryya ");
INSERT INTO sancol_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","puna ryarddan adyAstaTE yatra purvvaM yOhan amajjayat tatrAgatya nyavasat| ");
INSERT INTO sancol_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","tatO bahavO lOkAstatsamIpam Agatya vyAharan yOhan kimapyAzcaryyaM karmma nAkarOt kintvasmin manuSyE yA yaH kathA akathayat tAH sarvvAH satyAH; ");
INSERT INTO sancol_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","tatra ca bahavO lOkAstasmin vyazvasan| ");
INSERT INTO sancol_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","anantaraM mariyam tasyA bhaginI marthA ca yasmin vaithanIyAgrAmE vasatastasmin grAmE iliyAsar nAmA pIPita Eka AsIt| ");
INSERT INTO sancol_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","yA mariyam prabhuM sugandhitElaina marddayitvA svakEzaistasya caraNau samamArjat tasyA bhrAtA sa iliyAsar rOgI| ");
INSERT INTO sancol_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","aparanjca hE prabhO bhavAn yasmin prIyatE sa Eva pIPitOstIti kathAM kathayitvA tasya bhaginyau prESitavatyau| ");
INSERT INTO sancol_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","tadA yIzurimAM vArttAM zrutvAkathayata pIPEyaM maraNArthaM na kintvIzvarasya mahimArtham Izvaraputrasya mahimaprakAzArthanjca jAtA| ");
INSERT INTO sancol_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","yIzu ryadyapimarthAyAM tadbhaginyAm iliyAsari cAprIyata, ");
INSERT INTO sancol_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","tathApi iliyAsaraH pIPAyAH kathaM zrutvA yatra AsIt tatraiva dinadvayamatiSThat| ");
INSERT INTO sancol_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","tataH param sa ziSyAnakathayad vayaM puna ryihUdIyapradEzaM yAmaH| ");
INSERT INTO sancol_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","tatastE pratyavadan, hE gurO svalpadinAni gatAni yihUdIyAstvAM pASANai rhantum udyatAstathApi kiM punastatra yAsyasi? ");
INSERT INTO sancol_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","yIzuH pratyavadat, Ekasmin dinE kiM dvAdazaghaTikA na bhavanti? kOpi divA gacchan na skhalati yataH sa EtajjagatO dIptiM prApnOti| ");
INSERT INTO sancol_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","kintu rAtrau gacchan skhalati yatO hEtOstatra dIpti rnAsti| ");
INSERT INTO sancol_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","imAM kathAM kathayitvA sa tAnavadad, asmAkaM bandhuH iliyAsar nidritObhUd idAnIM taM nidrAtO jAgarayituM gacchAmi| ");
INSERT INTO sancol_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","yIzu rmRtau kathAmimAM kathitavAn kintu vizrAmArthaM nidrAyAM kathitavAn iti jnjAtvA ziSyA akathayan, ");
INSERT INTO sancol_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","hE gurO sa yadi nidrAti tarhi bhadramEva| ");
INSERT INTO sancol_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","tadA yIzuH spaSTaM tAn vyAharat, iliyAsar amriyata; ");
INSERT INTO sancol_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","kintu yUyaM yathA pratItha tadarthamahaM tatra na sthitavAn ityasmAd yuSmannimittam AhlAditOhaM, tathApi tasya samIpE yAma| ");
INSERT INTO sancol_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","tadA thOmA yaM didumaM vadanti sa sagginaH ziSyAn avadad vayamapi gatvA tEna sArddhaM mriyAmahai| ");
INSERT INTO sancol_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","yIzustatrOpasthAya iliyAsaraH zmazAnE sthApanAt catvAri dinAni gatAnIti vArttAM zrutavAn| ");
INSERT INTO sancol_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","vaithanIyA yirUzAlamaH samIpasthA krOzaikamAtrAntaritA; ");
INSERT INTO sancol_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","tasmAd bahavO yihUdIyA marthAM mariyamanjca bhyAtRzOkApannAM sAntvayituM tayOH samIpam Agacchan| ");
INSERT INTO sancol_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","marthA yIzOrAgamanavArtAM zrutvaiva taM sAkSAd akarOt kintu mariyam gEha upavizya sthitA| ");
INSERT INTO sancol_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","tadA marthA yIzumavAdat, hE prabhO yadi bhavAn atrAsthAsyat tarhi mama bhrAtA nAmariSyat| ");
INSERT INTO sancol_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","kintvidAnImapi yad IzvarE prArthayiSyatE Izvarastad dAsyatIti jAnE'haM| ");
INSERT INTO sancol_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","yIzuravAdIt tava bhrAtA samutthAsyati| ");
INSERT INTO sancol_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","marthA vyAharat zESadivasE sa utthAnasamayE prOtthAsyatIti jAnE'haM| ");
INSERT INTO sancol_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","tadA yIzuH kathitavAn ahamEva utthApayitA jIvayitA ca yaH kazcana mayi vizvasiti sa mRtvApi jIviSyati; ");
INSERT INTO sancol_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","yaH kazcana ca jIvan mayi vizvasiti sa kadApi na mariSyati, asyAM kathAyAM kiM vizvasiSi? ");
INSERT INTO sancol_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","sAvadat prabhO yasyAvataraNApEkSAsti bhavAn saEvAbhiSiktta Izvaraputra iti vizvasimi| ");
INSERT INTO sancol_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","iti kathAM kathayitvA sA gatvA svAM bhaginIM mariyamaM guptamAhUya vyAharat gururupatiSThati tvAmAhUyati ca| ");
INSERT INTO sancol_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","kathAmimAM zrutvA sA tUrNam utthAya tasya samIpam agacchat| ");
INSERT INTO sancol_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","yIzu rgrAmamadhyaM na pravizya yatra marthA taM sAkSAd akarOt tatra sthitavAn| ");
INSERT INTO sancol_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","yE yihUdIyA mariyamA sAkaM gRhE tiSThantastAm asAntvayana tE tAM kSipram utthAya gacchantiM vilOkya vyAharan, sa zmazAnE rOdituM yAti, ityuktvA tE tasyAH pazcAd agacchan| ");
INSERT INTO sancol_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","yatra yIzuratiSThat tatra mariyam upasthAya taM dRSTvA tasya caraNayOH patitvA vyAharat hE prabhO yadi bhavAn atrAsthAsyat tarhi mama bhrAtA nAmariSyat| ");
INSERT INTO sancol_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","yIzustAM tasyAH sagginO yihUdIyAMzca rudatO vilOkya zOkArttaH san dIrghaM nizvasya kathitavAn taM kutrAsthApayata? ");
INSERT INTO sancol_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","tE vyAharan, hE prabhO bhavAn Agatya pazyatu| ");
INSERT INTO sancol_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","yIzunA kranditaM| ");
INSERT INTO sancol_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ataEva yihUdIyA avadan, pazyatAyaM tasmin kidRg apriyata| ");
INSERT INTO sancol_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","tESAM kEcid avadan yOndhAya cakSuSI dattavAn sa kim asya mRtyuM nivArayituM nAzaknOt? ");
INSERT INTO sancol_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","tatO yIzuH punarantardIrghaM nizvasya zmazAnAntikam agacchat| tat zmazAnam EkaM gahvaraM tanmukhE pASANa Eka AsIt| ");
INSERT INTO sancol_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","tadA yIzuravadad EnaM pASANam apasArayata, tataH pramItasya bhaginI marthAvadat prabhO, adhunA tatra durgandhO jAtaH, yatOdya catvAri dinAni zmazAnE sa tiSThati| ");
INSERT INTO sancol_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","tadA yIzuravAdIt, yadi vizvasiSi tarhIzvarasya mahimaprakAzaM drakSyasi kathAmimAM kiM tubhyaM nAkathayaM? ");
INSERT INTO sancol_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","tadA mRtasya zmazAnAt pASANO'pasAritE yIzurUrdvvaM pazyan akathayat, hE pita rmama nEvEsanam azRNOH kAraNAdasmAt tvAM dhanyaM vadAmi| ");
INSERT INTO sancol_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","tvaM satataM zRNOSi tadapyahaM jAnAmi, kintu tvaM mAM yat prairayastad yathAsmin sthAnE sthitA lOkA vizvasanti tadartham idaM vAkyaM vadAmi| ");
INSERT INTO sancol_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","imAM kathAM kathayitvA sa prOccairAhvayat, hE iliyAsar bahirAgaccha| ");
INSERT INTO sancol_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","tataH sa pramItaH zmazAnavastrai rbaddhahastapAdO gAtramArjanavAsasA baddhamukhazca bahirAgacchat| yIzuruditavAn bandhanAni mOcayitvA tyajatainaM| ");
INSERT INTO sancol_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","mariyamaH samIpam AgatA yE yihUdIyalOkAstadA yIzOrEtat karmmApazyan tESAM bahavO vyazvasan, ");
INSERT INTO sancol_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","kintu kEcidanyE phirUzinAM samIpaM gatvA yIzOrEtasya karmmaNO vArttAm avadan| ");
INSERT INTO sancol_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","tataH paraM pradhAnayAjakAH phirUzinAzca sabhAM kRtvA vyAharan vayaM kiM kurmmaH? ESa mAnavO bahUnyAzcaryyakarmmANi karOti| ");
INSERT INTO sancol_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","yadIdRzaM karmma karttuM na vArayAmastarhi sarvvE lOkAstasmin vizvasiSyanti rOmilOkAzcAgatyAsmAkam anayA rAjadhAnyA sArddhaM rAjyam AchEtsyanti| ");
INSERT INTO sancol_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","tadA tESAM kiyaphAnAmA yastasmin vatsarE mahAyAjakapadE nyayujyata sa pratyavadad yUyaM kimapi na jAnItha; ");
INSERT INTO sancol_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","samagradEzasya vinAzatOpi sarvvalOkArtham Ekasya janasya maraNam asmAkaM maggalahEtukam Etasya vivEcanAmapi na kurutha| ");
INSERT INTO sancol_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","EtAM kathAM sa nijabuddhyA vyAharad iti na, ");
INSERT INTO sancol_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","kintu yIzUstaddEzIyAnAM kAraNAt prANAn tyakSyati, dizi dizi vikIrNAn Izvarasya santAnAn saMgRhyaikajAtiM kariSyati ca, tasmin vatsarE kiyaphA mahAyAjakatvapadE niyuktaH san idaM bhaviSyadvAkyaM kathitavAn| ");
INSERT INTO sancol_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","taddinamArabhya tE kathaM taM hantuM zaknuvantIti mantraNAM karttuM prArEbhirE| ");
INSERT INTO sancol_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ataEva yihUdIyAnAM madhyE yIzuH saprakAzaM gamanAgamanE akRtvA tasmAd gatvA prAntarasya samIpasthAyipradEzasyEphrAyim nAmni nagarE ziSyaiH sAkaM kAlaM yApayituM prArEbhE| ");
INSERT INTO sancol_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","anantaraM yihUdIyAnAM nistArOtsavE nikaTavarttini sati tadutsavAt pUrvvaM svAn zucIn karttuM bahavO janA grAmEbhyO yirUzAlam nagaram Agacchan, ");
INSERT INTO sancol_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","yIzOranvESaNaM kRtvA mandirE daNPAyamAnAH santaH parasparaM vyAharan, yuSmAkaM kIdRzO bOdhO jAyatE? sa kim utsavE'smin atrAgamiSyati? ");
INSERT INTO sancol_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","sa ca kutrAsti yadyEtat kazcid vEtti tarhi darzayatu pradhAnayAjakAH phirUzinazca taM dharttuM pUrvvam imAm AjnjAM prAcArayan| ");
INSERT INTO sancol_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","nistArOtsavAt pUrvvaM dinaSaTkE sthitE yIzu ryaM pramItam iliyAsaraM zmazAnAd udasthAparat tasya nivAsasthAnaM baithaniyAgrAmam Agacchat| ");
INSERT INTO sancol_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","tatra tadarthaM rajanyAM bhOjyE kRtE marthA paryyavESayad iliyAsar ca tasya saggibhiH sArddhaM bhOjanAsana upAvizat| ");
INSERT INTO sancol_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","tadA mariyam arddhasETakaM bahumUlyaM jaTAmAMsIyaM tailam AnIya yIzOzcaraNayO rmarddayitvA nijakEza rmArSTum Arabhata; tadA tailasya parimalEna gRham AmOditam abhavat| ");
INSERT INTO sancol_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","yaH zimOnaH putra riSkariyOtIyO yihUdAnAmA yIzuM parakarESu samarpayiSyati sa ziSyastadA kathitavAn, ");
INSERT INTO sancol_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","EtattailaM tribhiH zatai rmudrApadai rvikrItaM sad daridrEbhyaH kutO nAdIyata? ");
INSERT INTO sancol_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","sa daridralOkArtham acintayad iti na, kintu sa caura EvaM tannikaTE mudrAsampuTakasthityA tanmadhyE yadatiSThat tadapAharat tasmAt kAraNAd imAM kathAmakathayat| ");
INSERT INTO sancol_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","tadA yIzurakathayad EnAM mA vAraya sA mama zmazAnasthApanadinArthaM tadarakSayat| ");
INSERT INTO sancol_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","daridrA yuSmAkaM sannidhau sarvvadA tiSThanti kintvahaM sarvvadA yuSmAkaM sannidhau na tiSThAmi| ");
INSERT INTO sancol_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","tataH paraM yIzustatrAstIti vArttAM zrutvA bahavO yihUdIyAstaM zmazAnAdutthApitam iliyAsaranjca draSTuM tat sthAnam Agacchana| ");
INSERT INTO sancol_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","tadA pradhAnayAjakAstam iliyAsaramapi saMharttum amantrayan ; ");
INSERT INTO sancol_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","yatastEna bahavO yihUdIyA gatvA yIzau vyazvasan| ");
INSERT INTO sancol_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","anantaraM yIzu ryirUzAlam nagaram AgacchatIti vArttAM zrutvA parE'hani utsavAgatA bahavO lOkAH ");
INSERT INTO sancol_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","kharjjUrapatrAdyAnIya taM sAkSAt karttuM bahirAgatya jaya jayEti vAcaM prOccai rvaktum Arabhanta, isrAyElO yO rAjA paramEzvarasya nAmnAgacchati sa dhanyaH| ");
INSERT INTO sancol_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","tadA \"hE siyOnaH kanyE mA bhaiSIH pazyAyaM tava rAjA garddabhazAvakam AruhyAgacchati\" ");
INSERT INTO sancol_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","iti zAstrIyavacanAnusArENa yIzurEkaM yuvagarddabhaM prApya taduparyyArOhat| ");
INSERT INTO sancol_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","asyAH ghaTanAyAstAtparyyaM ziSyAH prathamaM nAbudhyanta, kintu yIzau mahimAnaM prAptE sati vAkyamidaM tasmina akathyata lOkAzca tampratIttham akurvvan iti tE smRtavantaH| ");
INSERT INTO sancol_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","sa iliyAsaraM zmazAnAd Agantum AhvatavAn zmazAnAnjca udasthApayad yE yE lOkAstatkarmya sAkSAd apazyan tE pramANaM dAtum Arabhanta| ");
INSERT INTO sancol_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","sa EtAdRzam adbhutaM karmmakarOt tasya janazrutE rlOkAstaM sAkSAt karttum Agacchan| ");
INSERT INTO sancol_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","tataH phirUzinaH parasparaM vaktum Arabhanta yuSmAkaM sarvvAzcESTA vRthA jAtAH, iti kiM yUyaM na budhyadhvE? pazyata sarvvE lOkAstasya pazcAdvarttinObhavan| ");
INSERT INTO sancol_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","bhajanaM karttum utsavAgatAnAM lOkAnAM katipayA janA anyadEzIyA Asan , ");
INSERT INTO sancol_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","tE gAlIlIyabaitsaidAnivAsinaH philipasya samIpam Agatya vyAharan hE mahEccha vayaM yIzuM draSTum icchAmaH| ");
INSERT INTO sancol_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","tataH philipO gatvA Andriyam avadat pazcAd Andriyaphilipau yIzavE vArttAm akathayatAM| ");
INSERT INTO sancol_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","tadA yIzuH pratyuditavAn mAnavasutasya mahimaprAptisamaya upasthitaH| ");
INSERT INTO sancol_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ahaM yuSmAnatiyathArthaM vadAmi, dhAnyabIjaM mRttikAyAM patitvA yadi na mRyatE tarhyEkAkI tiSThati kintu yadi mRyatE tarhi bahuguNaM phalaM phalati| ");
INSERT INTO sancol_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","yO janEा nijaprANAn priyAn jAnAti sa tAn hArayiSyati kintu yEा jana ihalOkE nijaprANAn apriyAn jAnAti sEाnantAyuH prAptuM tAn rakSiSyati| ");
INSERT INTO sancol_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","kazcid yadi mama sEvakO bhavituM vAnjchati tarhi sa mama pazcAdgAmI bhavatu, tasmAd ahaM yatra tiSThAmi mama sEvakEाpi tatra sthAsyati; yO janO mAM sEvatE mama pitApi taM sammaMsyatE| ");
INSERT INTO sancol_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","sAmprataM mama prANA vyAkulA bhavanti, tasmAd hE pitara EtasmAt samayAn mAM rakSa, ityahaM kiM prArthayiSyE? kintvaham EtatsamayArtham avatIrNavAn| ");
INSERT INTO sancol_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","hE pita: svanAmnO mahimAnaM prakAzaya; tanaiva svanAmnO mahimAnam ahaM prAkAzayaM punarapi prakAzayiSyAmi, ESA gagaNIyA vANI tasmin samayE'jAyata| ");
INSERT INTO sancol_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","taczrutvA samIpasthalOkAnAM kEcid avadan mEghO'garjIt, kEcid avadan svargIyadUtO'nEna saha kathAmacakathat| ");
INSERT INTO sancol_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","tadA yIzuH pratyavAdIt, madarthaM zabdOyaM nAbhUt yuSmadarthamEvAbhUt| ");
INSERT INTO sancol_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","adhunA jagatOsya vicAra: sampatsyatE, adhunAsya jagata: patI rAjyAt cyOSyati| ");
INSERT INTO sancol_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","yadyaI pRthivyA UrdvvE prOtthApitOsmi tarhi sarvvAn mAnavAn svasamIpam AkarSiSyAmi| ");
INSERT INTO sancol_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","kathaM tasya mRti rbhaviSyati, Etad bOdhayituM sa imAM kathAm akathayat| ");
INSERT INTO sancol_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","tadA lOkA akathayan sObhiSiktaH sarvvadA tiSThatIti vyavasthAgranthE zrutam asmAbhiH, tarhi manuSyaputraH prOtthApitO bhaviSyatIti vAkyaM kathaM vadasi? manuSyaputrOyaM kaH? ");
INSERT INTO sancol_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","tadA yIzurakathAyad yuSmAbhiH sArddham alpadinAni jyOtirAstE, yathA yuSmAn andhakArO nAcchAdayati tadarthaM yAvatkAlaM yuSmAbhiH sArddhaM jyOtistiSThati tAvatkAlaM gacchata; yO janO'ndhakArE gacchati sa kutra yAtIti na jAnAti| ");
INSERT INTO sancol_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ataEva yAvatkAlaM yuSmAkaM nikaTE jyOtirAstE tAvatkAlaM jyOtIrUpasantAnA bhavituM jyOtiSi vizvasita; imAM kathAM kathayitvA yIzuH prasthAya tEbhyaH svaM guptavAn| ");
INSERT INTO sancol_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","yadyapi yIzustESAM samakSam EtAvadAzcaryyakarmmANi kRtavAn tathApi tE tasmin na vyazvasan| ");
INSERT INTO sancol_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ataEva kaH pratyEti susaMvAdaM parEzAsmat pracAritaM? prakAzatE parEzasya hastaH kasya ca sannidhau? yizayiyabhaviSyadvAdinA yadEtad vAkyamuktaM tat saphalam abhavat| ");
INSERT INTO sancol_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","tE pratyEtuM nAzankuvan tasmin yizayiyabhaviSyadvAdi punaravAdId, ");
INSERT INTO sancol_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","yadA, \"tE nayanai rna pazyanti buddhibhizca na budhyantE tai rmanaHsu parivarttitESu ca tAnahaM yathA svasthAn na karOmi tathA sa tESAM lOcanAnyandhAni kRtvA tESAmantaHkaraNAni gAPhAni kariSyati|\" ");
INSERT INTO sancol_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","yizayiyO yadA yIzO rmahimAnaM vilOkya tasmin kathAmakathayat tadA bhaviSyadvAkyam IdRzaM prakAzayat| ");
INSERT INTO sancol_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","tathApyadhipatinAM bahavastasmin pratyAyan| kintu phirUzinastAn bhajanagRhAd dUrIkurvvantIti bhayAt tE taM na svIkRtavantaH| ");
INSERT INTO sancol_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","yata Izvarasya prazaMsAtO mAnavAnAM prazaMsAyAM tE'priyanta| ");
INSERT INTO sancol_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","tadA yIzuruccaiHkAram akathayad yO janO mayi vizvasiti sa kEvalE mayi vizvasitIti na, sa matprErakE'pi vizvasiti| ");
INSERT INTO sancol_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","yO janO mAM pazyati sa matprErakamapi pazyati| ");
INSERT INTO sancol_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","yO janO mAM pratyEti sa yathAndhakArE na tiSThati tadartham ahaM jyOtiHsvarUpO bhUtvA jagatyasmin avatIrNavAn| ");
INSERT INTO sancol_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","mama kathAM zrutvA yadi kazcin na vizvasiti tarhi tamahaM dOSiNaM na karOmi, yatO hEtO rjagatO janAnAM dOSAn nizcitAn karttuM nAgatya tAn paricAtum AgatOsmi| ");
INSERT INTO sancol_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","yaH kazcin mAM na zraddhAya mama kathaM na gRhlAti, anyastaM dOSiNaM kariSyati vastutastu yAM kathAmaham acakathaM sA kathA caramE'nhi taM dOSiNaM kariSyati| ");
INSERT INTO sancol_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","yatO hEtOrahaM svataH kimapi na kathayAmi, kiM kiM mayA kathayitavyaM kiM samupadESTavyanjca iti matprErayitA pitA mAmAjnjApayat| ");
INSERT INTO sancol_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","tasya sAjnjA anantAyurityahaM jAnAmi, ataEvAhaM yat kathayAmi tat pitA yathAjnjApayat tathaiva kathayAmyaham| ");
INSERT INTO sancol_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","nistArOtsavasya kinjcitkAlAt pUrvvaM pRthivyAH pituH samIpagamanasya samayaH sannikarSObhUd iti jnjAtvA yIzurAprathamAd yESu jagatpravAsiSvAtmIyalOkESa prEma karOti sma tESu zESaM yAvat prEma kRtavAn| ");
INSERT INTO sancol_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","pitA tasya hastE sarvvaM samarpitavAn svayam Izvarasya samIpAd Agacchad Izvarasya samIpaM yAsyati ca, sarvvANyEtAni jnjAtvA rajanyAM bhOjanE sampUrNE sati, ");
INSERT INTO sancol_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","yadA zaitAn taM parahastESu samarpayituM zimOnaH putrasya ISkAriyOtiyasya yihUdA antaHkaraNE kupravRttiM samArpayat, ");
INSERT INTO sancol_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","tadA yIzu rbhOjanAsanAd utthAya gAtravastraM mOcayitvA gAtramArjanavastraM gRhItvA tEna svakaTim abadhnAt, ");
INSERT INTO sancol_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","pazcAd EkapAtrE jalam abhiSicya ziSyANAM pAdAn prakSAlya tEna kaTibaddhagAtramArjanavAsasA mArSTuM prArabhata| ");
INSERT INTO sancol_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","tataH zimOnpitarasya samIpamAgatE sa uktavAn hE prabhO bhavAn kiM mama pAdau prakSAlayiSyati? ");
INSERT INTO sancol_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","yIzuruditavAn ahaM yat karOmi tat samprati na jAnAsi kintu pazcAj jnjAsyasi| ");
INSERT INTO sancol_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","tataH pitaraH kathitavAn bhavAn kadApi mama pAdau na prakSAlayiSyati| yIzurakathayad yadi tvAM na prakSAlayE tarhi mayi tava kOpyaMzO nAsti| ");
INSERT INTO sancol_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","tadA zimOnpitaraH kathitavAn hE prabhO tarhi kEvalapAdau na, mama hastau zirazca prakSAlayatu| ");
INSERT INTO sancol_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","tatO yIzuravadad yO janO dhautastasya sarvvAggapariSkRtatvAt pAdau vinAnyAggasya prakSAlanApEkSA nAsti| yUyaM pariSkRtA iti satyaM kintu na sarvvE, ");
INSERT INTO sancol_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","yatO yO janastaM parakarESu samarpayiSyati taM sa jnjAtavAna; ataEva yUyaM sarvvE na pariSkRtA imAM kathAM kathitavAn| ");
INSERT INTO sancol_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","itthaM yIzustESAM pAdAn prakSAlya vastraM paridhAyAsanE samupavizya kathitavAn ahaM yuSmAn prati kiM karmmAkArSaM jAnItha? ");
INSERT INTO sancol_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","yUyaM mAM guruM prabhunjca vadatha tat satyamEva vadatha yatOhaM saEva bhavAmi| ");
INSERT INTO sancol_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","yadyahaM prabhu rguruzca san yuSmAkaM pAdAn prakSAlitavAn tarhi yuSmAkamapi parasparaM pAdaprakSAlanam ucitam| ");
INSERT INTO sancol_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","ahaM yuSmAn prati yathA vyavAharaM yuSmAn tathA vyavaharttum EkaM panthAnaM darzitavAn| ");
INSERT INTO sancol_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","ahaM yuSmAnatiyathArthaM vadAmi, prabhO rdAsO na mahAn prErakAcca prEritO na mahAn| ");
INSERT INTO sancol_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","imAM kathAM viditvA yadi tadanusArataH karmmANi kurutha tarhi yUyaM dhanyA bhaviSyatha| ");
INSERT INTO sancol_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","sarvvESu yuSmAsu kathAmimAM kathayAmi iti na, yE mama manOnItAstAnahaM jAnAmi, kintu mama bhakSyANi yO bhugktE matprANaprAtikUlyataH| utthApayati pAdasya mUlaM sa ESa mAnavaH|yadEtad dharmmapustakasya vacanaM tadanusArENAvazyaM ghaTiSyatE| ");
INSERT INTO sancol_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","ahaM sa jana ityatra yathA yuSmAkaM vizvAsO jAyatE tadarthaM EtAdRzaghaTanAt pUrvvam ahamidAnIM yuSmabhyamakathayam| ");
INSERT INTO sancol_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","ahaM yuSmAnatIva yathArthaM vadAmi, mayA prEritaM janaM yO gRhlAti sa mAmEva gRhlAti yazca mAM gRhlAti sa matprErakaM gRhlAti| ");
INSERT INTO sancol_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","EtAM kathAM kathayitvA yIzu rduHkhI san pramANaM dattvA kathitavAn ahaM yuSmAnatiyathArthaM vadAmi yuSmAkam EkO janO mAM parakarESu samarpayiSyati| ");
INSERT INTO sancol_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","tataH sa kamuddizya kathAmEtAM kathitavAn ityatra sandigdhAH ziSyAH parasparaM mukhamAlOkayituM prArabhanta| ");
INSERT INTO sancol_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","tasmin samayE yIzu ryasmin aprIyata sa ziSyastasya vakSaHsthalam avAlambata| ");
INSERT INTO sancol_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","zimOnpitarastaM sagkEtEnAvadat, ayaM kamuddizya kathAmEtAm kathayatIti pRccha| ");
INSERT INTO sancol_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","tadA sa yIzO rvakSaHsthalam avalambya pRSThavAn, hE prabhO sa janaH kaH? ");
INSERT INTO sancol_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","tatO yIzuH pratyavadad EkakhaNPaM pUpaM majjayitvA yasmai dAsyAmi saEva saH; pazcAt pUpakhaNPamEkaM majjayitvA zimOnaH putrAya ISkariyOtIyAya yihUdai dattavAn| ");
INSERT INTO sancol_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","tasmin dattE sati zaitAn tamAzrayat; tadA yIzustam avadat tvaM yat kariSyasi tat kSipraM kuru| ");
INSERT INTO sancol_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","kintu sa yEnAzayEna tAM kathAmakathAyat tam upaviSTalOkAnAM kOpi nAbudhyata; ");
INSERT INTO sancol_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","kintu yihUdAH samIpE mudrAsampuTakasthitEH kEcid ittham abudhyanta pArvvaNAsAdanArthaM kimapi dravyaM krEtuM vA daridrEbhyaH kinjcid vitarituM kathitavAn| ");
INSERT INTO sancol_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","tadA pUpakhaNPagrahaNAt paraM sa tUrNaM bahiragacchat; rAtrizca samupasyitA| ");
INSERT INTO sancol_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","yihUdE bahirgatE yIzurakathayad idAnIM mAnavasutasya mahimA prakAzatE tEnEzvarasyApi mahimA prakAzatE| ");
INSERT INTO sancol_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","yadi tEnEzvarasya mahimA prakAzatE tarhIzvarOpi svEna tasya mahimAnaM prakAzayiSyati tUrNamEva prakAzayiSyati| ");
INSERT INTO sancol_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","hE vatsA ahaM yuSmAbhiH sArddhaM kinjcitkAlamAtram AsE, tataH paraM mAM mRgayiSyadhvE kintvahaM yatsthAnaM yAmi tatsthAnaM yUyaM gantuM na zakSyatha, yAmimAM kathAM yihUdIyEbhyaH kathitavAn tathAdhunA yuSmabhyamapi kathayAmi| ");
INSERT INTO sancol_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","yUyaM parasparaM prIyadhvam ahaM yuSmAsu yathA prIyE yUyamapi parasparam tathaiva prIyadhvaM, yuSmAn imAM navInAm AjnjAm AdizAmi| ");
INSERT INTO sancol_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","tEnaiva yadi parasparaM prIyadhvE tarhi lakSaNEnAnEna yUyaM mama ziSyA iti sarvvE jnjAtuM zakSyanti| ");
INSERT INTO sancol_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","zimOnapitaraH pRSThavAn hE prabhO bhavAn kutra yAsyati? tatO yIzuH pratyavadat, ahaM yatsthAnaM yAmi tatsthAnaM sAmprataM mama pazcAd gantuM na zaknOSi kintu pazcAd gamiSyasi| ");
INSERT INTO sancol_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","tadA pitaraH pratyuditavAn, hE prabhO sAmprataM kutO hEtOstava pazcAd gantuM na zaknOmi? tvadarthaM prANAn dAtuM zaknOmi| ");
INSERT INTO sancol_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","tatO yIzuH pratyuktavAn mannimittaM kiM prANAn dAtuM zaknOSi? tvAmahaM yathArthaM vadAmi, kukkuTaravaNAt pUrvvaM tvaM tri rmAm apahnOSyasE| ");
INSERT INTO sancol_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","manOduHkhinO mA bhUta; IzvarE vizvasita mayi ca vizvasita| ");
INSERT INTO sancol_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","mama pitu gRhE bahUni vAsasthAni santi nO cEt pUrvvaM yuSmAn ajnjApayiSyaM yuSmadarthaM sthAnaM sajjayituM gacchAmi| ");
INSERT INTO sancol_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","yadi gatvAhaM yuSmannimittaM sthAnaM sajjayAmi tarhi panarAgatya yuSmAn svasamIpaM nESyAmi, tatO yatrAhaM tiSThAmi tatra yUyamapi sthAsyatha| ");
INSERT INTO sancol_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ahaM yatsthAnaM brajAmi tatsthAnaM yUyaM jAnItha tasya panthAnamapi jAnItha| ");
INSERT INTO sancol_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","tadA thOmA avadat, hE prabhO bhavAn kutra yAti tadvayaM na jAnImaH, tarhi kathaM panthAnaM jnjAtuM zaknumaH? ");
INSERT INTO sancol_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","yIzurakathayad ahamEva satyajIvanarUpapathO mayA na gantA kOpi pituH samIpaM gantuM na zaknOti| ");
INSERT INTO sancol_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","yadi mAm ajnjAsyata tarhi mama pitaramapyajnjAsyata kintvadhunAtastaM jAnItha pazyatha ca| ");
INSERT INTO sancol_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","tadA philipaH kathitavAn, hE prabhO pitaraM darzaya tasmAdasmAkaM yathESTaM bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","tatO yIzuH pratyAvAdIt, hE philipa yuSmAbhiH sArddham EtAvaddinAni sthitamapi mAM kiM na pratyabhijAnAsi? yO janO mAm apazyat sa pitaramapyapazyat tarhi pitaram asmAn darzayEti kathAM kathaM kathayasi? ");
INSERT INTO sancol_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ahaM pitari tiSThAmi pitA mayi tiSThatIti kiM tvaM na pratyaSi? ahaM yadvAkyaM vadAmi tat svatO na vadAmi kintu yaH pitA mayi virAjatE sa Eva sarvvakarmmANi karAti| ");
INSERT INTO sancol_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ataEva pitaryyahaM tiSThAmi pitA ca mayi tiSThati mamAsyAM kathAyAM pratyayaM kuruta, nO cEt karmmahEtOH pratyayaM kuruta| ");
INSERT INTO sancol_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","ahaM yuSmAnatiyathArthaM vadAmi, yO janO mayi vizvasiti sOhamiva karmmANi kariSyati varaM tatOpi mahAkarmmANi kariSyati yatO hEtOrahaM pituH samIpaM gacchAmi| ");
INSERT INTO sancol_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","yathA putrENa pitu rmahimA prakAzatE tadarthaM mama nAma prOcya yat prArthayiSyadhvE tat saphalaM kariSyAmi| ");
INSERT INTO sancol_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","yadi mama nAmnA yat kinjcid yAcadhvE tarhi tadahaM sAdhayiSyAmi| ");
INSERT INTO sancol_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","yadi mayi prIyadhvE tarhi mamAjnjAH samAcarata| ");
INSERT INTO sancol_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","tatO mayA pituH samIpE prArthitE pitA nirantaraM yuSmAbhiH sArddhaM sthAtum itaramEkaM sahAyam arthAt satyamayam AtmAnaM yuSmAkaM nikaTaM prESayiSyati| ");
INSERT INTO sancol_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","EtajjagatO lOkAstaM grahItuM na zaknuvanti yatastE taM nApazyan nAjanaMzca kintu yUyaM jAnItha yatO hEtOH sa yuSmAkamanta rnivasati yuSmAkaM madhyE sthAsyati ca| ");
INSERT INTO sancol_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","ahaM yuSmAn anAthAn kRtvA na yAsyAmi punarapi yuSmAkaM samIpam AgamiSyAmi| ");
INSERT INTO sancol_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","kiyatkAlarat param asya jagatO lOkA mAM puna rna drakSyanti kintu yUyaM drakSyatha;ahaM jIviSyAmi tasmAt kAraNAd yUyamapi jIviSyatha| ");
INSERT INTO sancol_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","pitaryyahamasmi mayi ca yUyaM stha, tathAhaM yuSmAsvasmi tadapi tadA jnjAsyatha| ");
INSERT INTO sancol_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","yO janO mamAjnjA gRhItvA tA Acarati saEva mayi prIyatE; yO janazca mayi prIyatE saEva mama pituH priyapAtraM bhaviSyati, tathAhamapi tasmin prItvA tasmai svaM prakAzayiSyAmi| ");
INSERT INTO sancol_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","tadA ISkariyOtIyAd anyO yihUdAstamavadat, hE prabhO bhavAn jagatO lOkAnAM sannidhau prakAzitO na bhUtvAsmAkaM sannidhau kutaH prakAzitO bhaviSyati? ");
INSERT INTO sancol_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","tatO yIzuH pratyuditavAn, yO janO mayi prIyatE sa mamAjnjA api gRhlAti, tEna mama pitApi tasmin prESyatE, AvAnjca tannikaTamAgatya tEna saha nivatsyAvaH| ");
INSERT INTO sancol_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","yO janO mayi na prIyatE sa mama kathA api na gRhlAti punazca yAmimAM kathAM yUyaM zRNutha sA kathA kEvalasya mama na kintu mama prErakO yaH pitA tasyApi kathA| ");
INSERT INTO sancol_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","idAnIM yuSmAkaM nikaTE vidyamAnOham EtAH sakalAH kathAH kathayAmi| ");
INSERT INTO sancol_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","kintvitaH paraM pitrA yaH sahAyO'rthAt pavitra AtmA mama nAmni prErayiSyati sa sarvvaM zikSayitvA mayOktAH samastAH kathA yuSmAn smArayiSyati| ");
INSERT INTO sancol_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","ahaM yuSmAkaM nikaTE zAntiM sthApayitvA yAmi, nijAM zAntiM yuSmabhyaM dadAmi, jagatO lOkA yathA dadAti tathAhaM na dadAmi; yuSmAkam antaHkaraNAni duHkhitAni bhItAni ca na bhavantu| ");
INSERT INTO sancol_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","ahaM gatvA punarapi yuSmAkaM samIpam AgamiSyAmi mayOktaM vAkyamidaM yUyam azrauSTa; yadi mayyaprESyadhvaM tarhyahaM pituH samIpaM gacchAmi mamAsyAM kathAyAM yUyam ahlAdiSyadhvaM yatO mama pitA mattOpi mahAn| ");
INSERT INTO sancol_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","tasyA ghaTanAyAH samayE yathA yuSmAkaM zraddhA jAyatE tadartham ahaM tasyA ghaTanAyAH pUrvvam idAnIM yuSmAn EtAM vArttAM vadAmi| ");
INSERT INTO sancol_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","itaH paraM yuSmAbhiH saha mama bahava AlApA na bhaviSyanti yataH kAraNAd Etasya jagataH patirAgacchati kintu mayA saha tasya kOpi sambandhO nAsti| ");
INSERT INTO sancol_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ahaM pitari prEma karOmi tathA pitu rvidhivat karmmANi karOmIti yEna jagatO lOkA jAnanti tadartham uttiSThata vayaM sthAnAdasmAd gacchAma| ");
INSERT INTO sancol_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","ahaM satyadrAkSAlatAsvarUpO mama pitA tUdyAnaparicArakasvarUpanjca| ");
INSERT INTO sancol_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","mama yAsu zAkhAsu phalAni na bhavanti tAH sa chinatti tathA phalavatyaH zAkhA yathAdhikaphalAni phalanti tadarthaM tAH pariSkarOti| ");
INSERT INTO sancol_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","idAnIM mayOktOpadEzEna yUyaM pariSkRtAH| ");
INSERT INTO sancol_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ataH kAraNAt mayi tiSThata tEnAhamapi yuSmAsu tiSThAmi, yatO hEtO rdrAkSAlatAyAm asaMlagnA zAkhA yathA phalavatI bhavituM na zaknOti tathA yUyamapi mayyatiSThantaH phalavantO bhavituM na zaknutha| ");
INSERT INTO sancol_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","ahaM drAkSAlatAsvarUpO yUyanjca zAkhAsvarUpOH; yO janO mayi tiSThati yatra cAhaM tiSThAmi, sa pracUraphalaiH phalavAn bhavati, kintu mAM vinA yUyaM kimapi karttuM na zaknutha| ");
INSERT INTO sancol_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","yaH kazcin mayi na tiSThati sa zuSkazAkhEva bahi rnikSipyatE lOkAzca tA AhRtya vahnau nikSipya dAhayanti| ");
INSERT INTO sancol_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","yadi yUyaM mayi tiSThatha mama kathA ca yuSmAsu tiSThati tarhi yad vAnjchitvA yAciSyadhvE yuSmAkaM tadEva saphalaM bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","yadi yUyaM pracUraphalavantO bhavatha tarhi tadvArA mama pitu rmahimA prakAziSyatE tathA yUyaM mama ziSyA iti parikSAyiSyadhvE| ");
INSERT INTO sancol_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","pitA yathA mayi prItavAn ahamapi yuSmAsu tathA prItavAn atO hEtO ryUyaM nirantaraM mama prEmapAtrANi bhUtvA tiSThata| ");
INSERT INTO sancol_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ahaM yathA piturAjnjA gRhItvA tasya prEmabhAjanaM tiSThAmi tathaiva yUyamapi yadi mamAjnjA guhlItha tarhi mama prEmabhAjanAni sthAsyatha| ");
INSERT INTO sancol_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","yuSmannimittaM mama ya AhlAdaH sa yathA ciraM tiSThati yuSmAkam Anandazca yathA pUryyatE tadarthaM yuSmabhyam EtAH kathA atrakatham| ");
INSERT INTO sancol_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","ahaM yuSmAsu yathA prIyE yUyamapi parasparaM tathA prIyadhvam ESA mamAjnjA| ");
INSERT INTO sancol_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","mitrANAM kAraNAt svaprANadAnaparyyantaM yat prEma tasmAn mahAprEma kasyApi nAsti| ");
INSERT INTO sancol_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","ahaM yadyad AdizAmi tattadEva yadi yUyam Acarata tarhi yUyamEva mama mitrANi| ");
INSERT INTO sancol_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","adyArabhya yuSmAn dAsAn na vadiSyAmi yat prabhu ryat karOti dAsastad na jAnAti; kintu pituH samIpE yadyad azRNavaM tat sarvvaM yUSmAn ajnjApayam tatkAraNAd yuSmAn mitrANi prOktavAn| ");
INSERT INTO sancol_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","yUyaM mAM rOcitavanta iti na, kintvahamEva yuSmAn rOcitavAn yUyaM gatvA yathA phalAnyutpAdayatha tAni phalAni cAkSayANi bhavanti, tadarthaM yuSmAn nyajunajaM tasmAn mama nAma prOcya pitaraM yat kinjcid yAciSyadhvE tadEva sa yuSmabhyaM dAsyati| ");
INSERT INTO sancol_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","yUyaM parasparaM prIyadhvam aham ityAjnjApayAmi| ");
INSERT INTO sancol_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","jagatO lOkai ryuSmAsu RtIyitESu tE pUrvvaM mAmEvArttIyanta iti yUyaM jAnItha| ");
INSERT INTO sancol_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","yadi yUyaM jagatO lOkA abhaviSyata tarhi jagatO lOkA yuSmAn AtmIyAn buddhvAprESyanta; kintu yUyaM jagatO lOkA na bhavatha, ahaM yuSmAn asmAjjagatO'rOcayam EtasmAt kAraNAjjagatO lOkA yuSmAn RtIyantE| ");
INSERT INTO sancol_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","dAsaH prabhO rmahAn na bhavati mamaitat pUrvvIyaM vAkyaM smarata; tE yadi mAmEvAtAPayan tarhi yuSmAnapi tAPayiSyanti, yadi mama vAkyaM gRhlanti tarhi yuSmAkamapi vAkyaM grahISyanti| ");
INSERT INTO sancol_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","kintu tE mama nAmakAraNAd yuSmAn prati tAdRzaM vyavahariSyanti yatO yO mAM prEritavAn taM tE na jAnanti| ");
INSERT INTO sancol_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","tESAM sannidhim Agatya yadyahaM nAkathayiSyaM tarhi tESAM pApaM nAbhaviSyat kintvadhunA tESAM pApamAcchAdayitum upAyO nAsti| ");
INSERT INTO sancol_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","yO janO mAm RtIyatE sa mama pitaramapi RtIyatE| ");
INSERT INTO sancol_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","yAdRzAni karmmANi kEnApi kadApi nAkriyanta tAdRzAni karmmANi yadi tESAM sAkSAd ahaM nAkariSyaM tarhi tESAM pApaM nAbhaviSyat kintvadhunA tE dRSTvApi mAM mama pitaranjcArttIyanta| ");
INSERT INTO sancol_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","tasmAt tE'kAraNaM mAm RtIyantE yadEtad vacanaM tESAM zAstrE likhitamAstE tat saphalam abhavat| ");
INSERT INTO sancol_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","kintu pitu rnirgataM yaM sahAyamarthAt satyamayam AtmAnaM pituH samIpAd yuSmAkaM samIpE prESayiSyAmi sa Agatya mayi pramANaM dAsyati| ");
INSERT INTO sancol_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","yUyaM prathamamArabhya mayA sArddhaM tiSThatha tasmAddhEtO ryUyamapi pramANaM dAsyatha| ");
INSERT INTO sancol_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","yuSmAkaM yathA vAdhA na jAyatE tadarthaM yuSmAn EtAni sarvvavAkyAni vyAharaM| ");
INSERT INTO sancol_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","lOkA yuSmAn bhajanagRhEbhyO dUrIkariSyanti tathA yasmin samayE yuSmAn hatvA Izvarasya tuSTi janakaM karmmAkurmma iti maMsyantE sa samaya Agacchanti| ");
INSERT INTO sancol_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","tE pitaraM mAnjca na jAnanti, tasmAd yuSmAn pratIdRzam AcariSyanti| ");
INSERT INTO sancol_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","atO hEtAH samayE samupasthitE yathA mama kathA yuSmAkaM manaHsuH samupatiSThati tadarthaM yuSmAbhyam EtAM kathAM kathayAmi yuSmAbhiH sArddham ahaM tiSThan prathamaM tAM yuSmabhyaM nAkathayaM| ");
INSERT INTO sancol_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","sAmprataM svasya prErayituH samIpaM gacchAmi tathApi tvaM kka gacchasi kathAmEtAM yuSmAkaM kOpi mAM na pRcchati| ");
INSERT INTO sancol_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","kintu mayOktAbhirAbhiH kathAbhi ryUSmAkam antaHkaraNAni duHkhEna pUrNAnyabhavan| ");
INSERT INTO sancol_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","tathApyahaM yathArthaM kathayAmi mama gamanaM yuSmAkaM hitArthamEva, yatO hEtO rgamanE na kRtE sahAyO yuSmAkaM samIpaM nAgamiSyati kintu yadi gacchAmi tarhi yuSmAkaM samIpE taM prESayiSyAmi| ");
INSERT INTO sancol_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","tataH sa Agatya pApapuNyadaNPESu jagatO lOkAnAM prabOdhaM janayiSyati| ");
INSERT INTO sancol_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","tE mayi na vizvasanti tasmAddhEtOH pApaprabOdhaM janayiSyati| ");
INSERT INTO sancol_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","yuSmAkam adRzyaH sannahaM pituH samIpaM gacchAmi tasmAd puNyE prabOdhaM janayiSyati| ");
INSERT INTO sancol_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","EtajjagatO'dhipati rdaNPAjnjAM prApnOti tasmAd daNPE prabOdhaM janayiSyati| ");
INSERT INTO sancol_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","yuSmabhyaM kathayituM mamAnEkAH kathA AsatE, tAH kathA idAnIM yUyaM sOPhuM na zaknutha; ");
INSERT INTO sancol_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","kintu satyamaya AtmA yadA samAgamiSyati tadA sarvvaM satyaM yuSmAn nESyati, sa svataH kimapi na vadiSyati kintu yacchrOSyati tadEva kathayitvA bhAvikAryyaM yuSmAn jnjApayiSyati| ");
INSERT INTO sancol_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","mama mahimAnaM prakAzayiSyati yatO madIyAM kathAM gRhItvA yuSmAn bOdhayiSyati| ");
INSERT INTO sancol_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","pitu ryadyad AstE tat sarvvaM mama tasmAd kAraNAd avAdiSaM sa madIyAM kathAM gRhItvA yuSmAn bOdhayiSyati| ");
INSERT INTO sancol_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","kiyatkAlAt paraM yUyaM mAM draSTuM na lapsyadhvE kintu kiyatkAlAt paraM puna rdraSTuM lapsyadhvE yatOhaM pituH samIpaM gacchAmi| ");
INSERT INTO sancol_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","tataH ziSyANAM kiyantO janAH parasparaM vaditum Arabhanta, kiyatkAlAt paraM mAM draSTuM na lapsyadhvE kintu kiyatkAlAt paraM puna rdraSTuM lapsyadhvE yatOhaM pituH samIpaM gacchAmi, iti yad vAkyam ayaM vadati tat kiM? ");
INSERT INTO sancol_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","tataH kiyatkAlAt param iti tasya vAkyaM kiM? tasya vAkyasyAbhiprAyaM vayaM bOddhuM na zaknumastairiti ");
INSERT INTO sancol_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","nigaditE yIzustESAM praznEcchAM jnjAtvA tEbhyO'kathayat kiyatkAlAt paraM mAM draSTuM na lapsyadhvE, kintu kiyatkAlAt paraM pUna rdraSTuM lapsyadhvE, yAmimAM kathAmakathayaM tasyA abhiprAyaM kiM yUyaM parasparaM mRgayadhvE? ");
INSERT INTO sancol_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","yuSmAnaham atiyathArthaM vadAmi yUyaM krandiSyatha vilapiSyatha ca, kintu jagatO lOkA AnandiSyanti; yUyaM zOkAkulA bhaviSyatha kintu zOkAt paraM AnandayuktA bhaviSyatha| ");
INSERT INTO sancol_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","prasavakAla upasthitE nArI yathA prasavavEdanayA vyAkulA bhavati kintu putrE bhUmiSThE sati manuSyaikO janmanA naralOkE praviSTa ityAnandAt tasyAstatsarvvaM duHkhaM manasi na tiSThati, ");
INSERT INTO sancol_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","tathA yUyamapi sAmprataM zOkAkulA bhavatha kintu punarapi yuSmabhyaM darzanaM dAsyAmi tEna yuSmAkam antaHkaraNAni sAnandAni bhaviSyanti, yuSmAkaM tam Anandanjca kOpi harttuM na zakSyati| ");
INSERT INTO sancol_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","tasmin divasE kAmapi kathAM mAM na prakSyatha| yuSmAnaham atiyathArthaM vadAmi, mama nAmnA yat kinjcid pitaraM yAciSyadhvE tadEva sa dAsyati| ");
INSERT INTO sancol_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","pUrvvE mama nAmnA kimapi nAyAcadhvaM, yAcadhvaM tataH prApsyatha tasmAd yuSmAkaM sampUrNAnandO janiSyatE| ");
INSERT INTO sancol_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","upamAkathAbhiH sarvvANyEtAni yuSmAn jnjApitavAn kintu yasmin samayE upamayA nOktvA pituH kathAM spaSTaM jnjApayiSyAmi samaya EtAdRza Agacchati| ");
INSERT INTO sancol_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","tadA mama nAmnA prArthayiSyadhvE 'haM yuSmannimittaM pitaraM vinESyE kathAmimAM na vadAmi; ");
INSERT INTO sancol_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","yatO yUyaM mayi prEma kurutha, tathAham Izvarasya samIpAd AgatavAn ityapi pratItha, tasmAd kAraNAt kAraNAt pitA svayaM yuSmAsu prIyatE| ");
INSERT INTO sancol_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","pituH samIpAjjajad AgatOsmi jagat parityajya ca punarapi pituH samIpaM gacchAmi| ");
INSERT INTO sancol_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","tadA ziSyA avadan, hE prabhO bhavAn upamayA nOktvAdhunA spaSTaM vadati| ");
INSERT INTO sancol_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","bhavAn sarvvajnjaH kEnacit pRSTO bhavitumapi bhavataH prayOjanaM nAstItyadhunAsmAkaM sthirajnjAnaM jAtaM tasmAd bhavAn Izvarasya samIpAd AgatavAn ityatra vayaM vizvasimaH| ");
INSERT INTO sancol_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","tatO yIzuH pratyavAdId idAnIM kiM yUyaM vizvasitha? ");
INSERT INTO sancol_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","pazyata sarvvE yUyaM vikIrNAH santO mAm EkAkinaM pIratyajya svaM svaM sthAnaM gamiSyatha, EtAdRzaH samaya Agacchati varaM prAyENOpasthitavAn; tathApyahaM naikAkI bhavAmi yataH pitA mayA sArddham AstE| ");
INSERT INTO sancol_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","yathA mayA yuSmAkaM zAnti rjAyatE tadartham EtAH kathA yuSmabhyam acakathaM; asmin jagati yuSmAkaM klEzO ghaTiSyatE kintvakSObhA bhavata yatO mayA jagajjitaM| ");
INSERT INTO sancol_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","tataH paraM yIzurEtAH kathAH kathayitvA svargaM vilOkyaitat prArthayat, hE pitaH samaya upasthitavAn; yathA tava putrastava mahimAnaM prakAzayati tadarthaM tvaM nijaputrasya mahimAnaM prakAzaya| ");
INSERT INTO sancol_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","tvaM yOllOkAn tasya hastE samarpitavAn sa yathA tEbhyO'nantAyu rdadAti tadarthaM tvaM prANimAtrANAm adhipatitvabhAraM tasmai dattavAn| ");
INSERT INTO sancol_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","yastvam advitIyaH satya IzvarastvayA prEritazca yIzuH khrISTa EtayOrubhayOH paricayE prAptE'nantAyu rbhavati| ");
INSERT INTO sancol_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","tvaM yasya karmmaNO bhAraM mahyaM dattavAn, tat sampannaM kRtvA jagatyasmin tava mahimAnaM prAkAzayaM| ");
INSERT INTO sancol_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ataEva hE pita rjagatyavidyamAnE tvayA saha tiSThatO mama yO mahimAsIt samprati tava samIpE mAM taM mahimAnaM prApaya| ");
INSERT INTO sancol_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","anyacca tvam EtajjagatO yAllOkAn mahyam adadA ahaM tEbhyastava nAmnastattvajnjAnam adadAM, tE tavaivAsan, tvaM tAn mahyamadadAH, tasmAttE tavOpadEzam agRhlan| ");
INSERT INTO sancol_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","tvaM mahyaM yat kinjcid adadAstatsarvvaM tvattO jAyatE ityadhunAjAnan| ");
INSERT INTO sancol_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","mahyaM yamupadEzam adadA ahamapi tEbhyastamupadEzam adadAM tEpi tamagRhlan tvattOhaM nirgatya tvayA prEritObhavam atra ca vyazvasan| ");
INSERT INTO sancol_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","tESAmEva nimittaM prArthayE'haM jagatO lOkanimittaM na prArthayE kintu yAllOkAn mahyam adadAstESAmEva nimittaM prArthayE'haM yatastE tavaivAsatE| ");
INSERT INTO sancol_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","yE mama tE tava yE ca tava tE mama tathA tai rmama mahimA prakAzyatE| ");
INSERT INTO sancol_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","sAmpratam asmin jagati mamAvasthitEH zESam abhavat ahaM tava samIpaM gacchAmi kintu tE jagati sthAsyanti; hE pavitra pitarAvayO ryathaikatvamAstE tathA tESAmapyEkatvaM bhavati tadarthaM yAllOkAn mahyam adadAstAn svanAmnA rakSa| ");
INSERT INTO sancol_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","yAvanti dinAni jagatyasmin taiH sahAhamAsaM tAvanti dinAni tAn tava nAmnAhaM rakSitavAn; yAllOkAn mahyam adadAstAn sarvvAn ahamarakSaM, tESAM madhyE kEvalaM vinAzapAtraM hAritaM tEna dharmmapustakasya vacanaM pratyakSaM bhavati| ");
INSERT INTO sancol_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","kintvadhunA tava sannidhiM gacchAmi mayA yathA tESAM sampUrNAnandO bhavati tadarthamahaM jagati tiSThan EtAH kathA akathayam| ");
INSERT INTO sancol_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","tavOpadEzaM tEbhyO'dadAM jagatA saha yathA mama sambandhO nAsti tathA jajatA saha tESAmapi sambandhAbhAvAj jagatO lOkAstAn RtIyantE| ");
INSERT INTO sancol_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","tvaM jagatastAn gRhANEti na prArthayE kintvazubhAd rakSEti prArthayEham| ");
INSERT INTO sancol_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","ahaM yathA jagatsambandhIyO na bhavAmi tathA tEpi jagatsambandhIyA na bhavanti| ");
INSERT INTO sancol_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","tava satyakathayA tAn pavitrIkuru tava vAkyamEva satyaM| ");
INSERT INTO sancol_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","tvaM yathA mAM jagati prairayastathAhamapi tAn jagati prairayaM| ");
INSERT INTO sancol_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","tESAM hitArthaM yathAhaM svaM pavitrIkarOmi tathA satyakathayA tEpi pavitrIbhavantu| ");
INSERT INTO sancol_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","kEvalaM EtESAmarthE prArthayE'ham iti na kintvEtESAmupadEzEna yE janA mayi vizvasiSyanti tESAmapyarthE prArthEyE'ham| ");
INSERT INTO sancol_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","hE pitastESAM sarvvESAm EkatvaM bhavatu tava yathA mayi mama ca yathA tvayyEkatvaM tathA tESAmapyAvayOrEkatvaM bhavatu tEna tvaM mAM prEritavAn iti jagatO lOkAH pratiyantu| ");
INSERT INTO sancol_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","yathAvayOrEkatvaM tathA tESAmapyEkatvaM bhavatu tESvahaM mayi ca tvam itthaM tESAM sampUrNamEkatvaM bhavatu, tvaM prEritavAn tvaM mayi yathA prIyasE ca tathA tESvapi prItavAn EtadyathA jagatO lOkA jAnanti ");
INSERT INTO sancol_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","tadarthaM tvaM yaM mahimAnaM mahyam adadAstaM mahimAnam ahamapi tEbhyO dattavAn| ");
INSERT INTO sancol_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","hE pita rjagatO nirmmANAt pUrvvaM mayi snEhaM kRtvA yaM mahimAnaM dattavAn mama taM mahimAnaM yathA tE pazyanti tadarthaM yAllOkAn mahyaM dattavAn ahaM yatra tiSThAmi tEpi yathA tatra tiSThanti mamaiSA vAnjchA| ");
INSERT INTO sancol_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","hE yathArthika pita rjagatO lOkaistvayyajnjAtEpi tvAmahaM jAnE tvaM mAM prEritavAn itImE ziSyA jAnanti| ");
INSERT INTO sancol_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","yathAhaM tESu tiSThAmi tathA mayi yEna prEmnA prEmAkarOstat tESu tiSThati tadarthaM tava nAmAhaM tAn jnjApitavAn punarapi jnjApayiSyAmi| ");
INSERT INTO sancol_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","tAH kathAH kathayitvA yIzuH ziSyAnAdAya kidrOnnAmakaM srOta uttIryya ziSyaiH saha tatratyOdyAnaM prAvizat| ");
INSERT INTO sancol_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","kintu vizvAsaghAtiyihUdAstat sthAnaM paricIyatE yatO yIzuH ziSyaiH sArddhaM kadAcit tat sthAnam agacchat| ");
INSERT INTO sancol_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","tadA sa yihUdAH sainyagaNaM pradhAnayAjakAnAM phirUzinAnjca padAtigaNanjca gRhItvA pradIpAn ulkAn astrANi cAdAya tasmin sthAna upasthitavAn| ");
INSERT INTO sancol_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","svaM prati yad ghaTiSyatE taj jnjAtvA yIzuragrEsaraH san tAnapRcchat kaM gavESayatha? ");
INSERT INTO sancol_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","tE pratyavadan, nAsaratIyaM yIzuM; tatO yIzuravAdId ahamEva saH; taiH saha vizvAsaghAtI yihUdAzcAtiSThat| ");
INSERT INTO sancol_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","tadAhamEva sa tasyaitAM kathAM zrutvaiva tE pazcAdEtya bhUmau patitAH| ");
INSERT INTO sancol_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","tatO yIzuH punarapi pRSThavAn kaM gavESayatha? tatastE pratyavadan nAsaratIyaM yIzuM| ");
INSERT INTO sancol_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","tadA yIzuH pratyuditavAn ahamEva sa imAM kathAmacakatham; yadi mAmanvicchatha tarhImAn gantuM mA vArayata| ");
INSERT INTO sancol_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","itthaM bhUtE mahyaM yAllOkAn adadAstESAm Ekamapi nAhArayam imAM yAM kathAM sa svayamakathayat sA kathA saphalA jAtA| ");
INSERT INTO sancol_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","tadA zimOnpitarasya nikaTE khaggalsthitEH sa taM niSkOSaM kRtvA mahAyAjakasya mAlkhanAmAnaM dAsam Ahatya tasya dakSiNakarNaM chinnavAn| ");
INSERT INTO sancol_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","tatO yIzuH pitaram avadat, khaggaM kOSE sthApaya mama pitA mahyaM pAtuM yaM kaMsam adadAt tEnAhaM kiM na pAsyAmi? ");
INSERT INTO sancol_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","tadA sainyagaNaH sEnApati ryihUdIyAnAM padAtayazca yIzuM ghRtvA baddhvA hAnannAmnaH kiyaphAH zvazurasya samIpaM prathamam anayan| ");
INSERT INTO sancol_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","sa kiyaphAstasmin vatsarE mahAyAjatvapadE niyuktaH ");
INSERT INTO sancol_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","san sAdhAraNalOkAnAM maggalArtham Ekajanasya maraNamucitam iti yihUdIyaiH sArddham amantrayat| ");
INSERT INTO sancol_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","tadA zimOnpitarO'nyaikaziSyazca yIzOH pazcAd agacchatAM tasyAnyaziSyasya mahAyAjakEna paricitatvAt sa yIzunA saha mahAyAjakasyATTAlikAM prAvizat| ");
INSERT INTO sancol_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","kintu pitarO bahirdvArasya samIpE'tiSThad ataEva mahAyAjakEna paricitaH sa ziSyaH punarbahirgatvA dauvAyikAyai kathayitvA pitaram abhyantaram Anayat| ");
INSERT INTO sancol_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","tadA sa dvArarakSikA pitaram avadat tvaM kiM na tasya mAnavasya ziSyaH? tataH sOvadad ahaM na bhavAmi| ");
INSERT INTO sancol_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","tataH paraM yatsthAnE dAsAH padAtayazca zItahEtOraggArai rvahniM prajvAlya tApaM sEvitavantastatsthAnE pitarastiSThan taiH saha vahnitApaM sEvitum Arabhata| ");
INSERT INTO sancol_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","tadA ziSyESUpadEzE ca mahAyAjakEna yIzuH pRSTaH ");
INSERT INTO sancol_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","san pratyuktavAn sarvvalOkAnAM samakSaM kathAmakathayaM guptaM kAmapi kathAM na kathayitvA yat sthAnaM yihUdIyAH satataM gacchanti tatra bhajanagEhE mandirE cAzikSayaM| ");
INSERT INTO sancol_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","mattaH kutaH pRcchasi? yE janA madupadEzam azRNvan tAnEva pRccha yadyad avadaM tE tat jAninta| ");
INSERT INTO sancol_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","tadEtthaM pratyuditatvAt nikaTasthapadAti ryIzuM capETEnAhatya vyAharat mahAyAjakam EvaM prativadasi? ");
INSERT INTO sancol_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","tatO yIzuH pratigaditavAn yadyayathArtham acakathaM tarhi tasyAyathArthasya pramANaM dEhi, kintu yadi yathArthaM tarhi kutO hEtO rmAm atAPayaH? ");
INSERT INTO sancol_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","pUrvvaM hAnan sabandhanaM taM kiyaphAmahAyAjakasya samIpaM praiSayat| ");
INSERT INTO sancol_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","zimOnpitarastiSThan vahnitApaM sEvatE, Etasmin samayE kiyantastam apRcchan tvaM kim Etasya janasya ziSyO na? tataH sOpahnutyAbravId ahaM na bhavAmi| ");
INSERT INTO sancol_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","tadA mahAyAjakasya yasya dAsasya pitaraH karNamacchinat tasya kuTumbaH pratyuditavAn udyAnE tEna saha tiSThantaM tvAM kiM nApazyaM? ");
INSERT INTO sancol_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","kintu pitaraH punarapahnutya kathitavAn; tadAnIM kukkuTO'raut| ");
INSERT INTO sancol_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","tadanantaraM pratyUSE tE kiyaphAgRhAd adhipatE rgRhaM yIzum anayan kintu yasmin azucitvE jAtE tai rnistArOtsavE na bhOktavyaM, tasya bhayAd yihUdIyAstadgRhaM nAvizan| ");
INSERT INTO sancol_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","aparaM pIlAtO bahirAgatya tAn pRSThavAn Etasya manuSyasya kaM dOSaM vadatha? ");
INSERT INTO sancol_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","tadA tE pEtyavadan duSkarmmakAriNi na sati bhavataH samIpE nainaM samArpayiSyAmaH| ");
INSERT INTO sancol_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","tataH pIlAtO'vadad yUyamEnaM gRhItvA svESAM vyavasthayA vicArayata| tadA yihUdIyAH pratyavadan kasyApi manuSyasya prANadaNPaM karttuM nAsmAkam adhikArO'sti| ");
INSERT INTO sancol_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","EvaM sati yIzuH svasya mRtyau yAM kathAM kathitavAn sA saphalAbhavat| ");
INSERT INTO sancol_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","tadanantaraM pIlAtaH punarapi tad rAjagRhaM gatvA yIzumAhUya pRSTavAn tvaM kiM yihUdIyAnAM rAjA? ");
INSERT INTO sancol_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","yIzuH pratyavadat tvam EtAM kathAM svataH kathayasi kimanyaH kazcin mayi kathitavAn? ");
INSERT INTO sancol_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","pIlAtO'vadad ahaM kiM yihUdIyaH? tava svadEzIyA vizESataH pradhAnayAjakA mama nikaTE tvAM samArpayana, tvaM kiM kRtavAn? ");
INSERT INTO sancol_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","yIzuH pratyavadat mama rAjyam EtajjagatsambandhIyaM na bhavati yadi mama rAjyaM jagatsambandhIyam abhaviSyat tarhi yihUdIyAnAM hastESu yathA samarpitO nAbhavaM tadarthaM mama sEvakA ayOtsyan kintu mama rAjyam aihikaM na| ");
INSERT INTO sancol_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","tadA pIlAtaH kathitavAn, tarhi tvaM rAjA bhavasi? yIzuH pratyuktavAn tvaM satyaM kathayasi, rAjAhaM bhavAmi; satyatAyAM sAkSyaM dAtuM janiM gRhItvA jagatyasmin avatIrNavAn, tasmAt satyadharmmapakSapAtinO mama kathAM zRNvanti| ");
INSERT INTO sancol_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","tadA satyaM kiM? EtAM kathAM paSTvA pIlAtaH punarapi bahirgatvA yihUdIyAn abhASata, ahaM tasya kamapyaparAdhaM na prApnOmi| ");
INSERT INTO sancol_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","nistArOtsavasamayE yuSmAbhirabhirucita EkO janO mayA mOcayitavya ESA yuSmAkaM rItirasti, ataEva yuSmAkaM nikaTE yihUdIyAnAM rAjAnaM kiM mOcayAmi, yuSmAkam icchA kA? ");
INSERT INTO sancol_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","tadA tE sarvvE ruvantO vyAharan EnaM mAnuSaM nahi barabbAM mOcaya| kintu sa barabbA dasyurAsIt| ");
INSERT INTO sancol_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","pIlAtO yIzum AnIya kazayA prAhArayat| ");
INSERT INTO sancol_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","pazcAt sEnAgaNaH kaNTakanirmmitaM mukuTaM tasya mastakE samarpya vArttAkIvarNaM rAjaparicchadaM paridhApya, ");
INSERT INTO sancol_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","hE yihUdIyAnAM rAjan namaskAra ityuktvA taM capETEnAhantum Arabhata| ");
INSERT INTO sancol_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","tadA pIlAtaH punarapi bahirgatvA lOkAn avadat, asya kamapyaparAdhaM na labhE'haM, pazyata tad yuSmAn jnjApayituM yuSmAkaM sannidhau bahirEnam AnayAmi| ");
INSERT INTO sancol_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","tataH paraM yIzuH kaNTakamukuTavAn vArttAkIvarNavasanavAMzca bahirAgacchat| tataH pIlAta uktavAn EnaM manuSyaM pazyata| ");
INSERT INTO sancol_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","tadA pradhAnayAjakAH padAtayazca taM dRSTvA, EnaM kruzE vidha, EnaM kruzE vidha, ityuktvA ravituM Arabhanta| tataH pIlAtaH kathitavAn yUyaM svayam EnaM nItvA kruzE vidhata, aham Etasya kamapyaparAdhaM na prAptavAn| ");
INSERT INTO sancol_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","yihUdIyAH pratyavadan asmAkaM yA vyavasthAstE tadanusArENAsya prANahananam ucitaM yatOyaM svam Izvarasya putramavadat| ");
INSERT INTO sancol_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","pIlAta imAM kathAM zrutvA mahAtrAsayuktaH ");
INSERT INTO sancol_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","san punarapi rAjagRha Agatya yIzuM pRSTavAn tvaM kutratyO lOkaH? kintu yIzastasya kimapi pratyuttaraM nAvadat| ");
INSERT INTO sancol_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","1# tataH pIlAt kathitavAna tvaM kiM mayA sArddhaM na saMlapiSyasi ? tvAM kruzE vEdhituM vA mOcayituM zakti rmamAstE iti kiM tvaM na jAnAsi ? tadA yIzuH pratyavadad IzvarENAdaŸाM mamOpari tava kimapyadhipatitvaM na vidyatE, tathApi yO janO mAM tava hastE samArpayat tasya mahApAtakaM jAtam| ");
INSERT INTO sancol_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","tadA yIzuH pratyavadad IzvarENAdattaM mamOpari tava kimapyadhipatitvaM na vidyatE, tathApi yO janO mAM tava hastE samArpayat tasya mahApAtakaM jAtam| ");
INSERT INTO sancol_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","tadArabhya pIlAtastaM mOcayituM cESTitavAn kintu yihUdIyA ruvantO vyAharan yadImaM mAnavaM tyajasi tarhi tvaM kaisarasya mitraM na bhavasi, yO janaH svaM rAjAnaM vakti saEva kaimarasya viruddhAM kathAM kathayati| ");
INSERT INTO sancol_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","EtAM kathAM zrutvA pIlAtO yIzuM bahirAnIya nistArOtsavasya AsAdanadinasya dvitIyapraharAt pUrvvaM prastarabandhananAmni sthAnE 'rthAt ibrIyabhASayA yad gabbithA kathyatE tasmin sthAnE vicArAsana upAvizat| ");
INSERT INTO sancol_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","anantaraM pIlAtO yihUdIyAn avadat, yuSmAkaM rAjAnaM pazyata| ");
INSERT INTO sancol_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","kintu EnaM dUrIkuru, EnaM dUrIkuru, EnaM kruzE vidha, iti kathAM kathayitvA tE ravitum Arabhanta; tadA pIlAtaH kathitavAn yuSmAkaM rAjAnaM kiM kruzE vEdhiSyAmi? pradhAnayAjakA uttaram avadan kaisaraM vinA kOpi rAjAsmAkaM nAsti| ");
INSERT INTO sancol_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","tataH pIlAtO yIzuM kruzE vEdhituM tESAM hastESu samArpayat, tatastE taM dhRtvA nItavantaH| ");
INSERT INTO sancol_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","tataH paraM yIzuH kruzaM vahan ziraHkapAlam arthAd yad ibrIyabhASayA gulgaltAM vadanti tasmin sthAna upasthitaH| ");
INSERT INTO sancol_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","tatastE madhyasthAnE taM tasyObhayapArzvE dvAvaparau kruzE'vidhan| ");
INSERT INTO sancol_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","aparam ESa yihUdIyAnAM rAjA nAsaratIyayIzuH, iti vijnjApanaM likhitvA pIlAtastasya kruzOpari samayOjayat| ");
INSERT INTO sancol_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","sA lipiH ibrIyayUnAnIyarOmIyabhASAbhi rlikhitA; yIzOH kruzavEdhanasthAnaM nagarasya samIpaM, tasmAd bahavO yihUdIyAstAM paThitum Arabhanta| ");
INSERT INTO sancol_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","yihUdIyAnAM pradhAnayAjakAH pIlAtamiti nyavEdayan yihUdIyAnAM rAjEti vAkyaM na kintu ESa svaM yihUdIyAnAM rAjAnam avadad itthaM likhatu| ");
INSERT INTO sancol_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","tataH pIlAta uttaraM dattavAn yallEkhanIyaM tallikhitavAn| ");
INSERT INTO sancol_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","itthaM sEnAgaNO yIzuM kruzE vidhitvA tasya paridhEyavastraM caturO bhAgAn kRtvA EkaikasEnA EkaikabhAgam agRhlat tasyOttarIyavastranjcAgRhlat| kintUttarIyavastraM sUcisEvanaM vinA sarvvam UtaM| ");
INSERT INTO sancol_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","tasmAttE vyAharan Etat kaH prApsyati? tanna khaNPayitvA tatra guTikApAtaM karavAma| vibhajantE'dharIyaM mE vasanaM tE parasparaM| mamOttarIyavastrArthaM guTikAM pAtayanti ca| iti yadvAkyaM dharmmapustakE likhitamAstE tat sEnAgaNEnEtthaM vyavaharaNAt siddhamabhavat| ");
INSERT INTO sancol_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","tadAnIM yIzO rmAtA mAtu rbhaginI ca yA kliyapA bhAryyA mariyam magdalInI mariyam ca EtAstasya kruzasya sannidhau samatiSThan| ");
INSERT INTO sancol_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","tatO yIzuH svamAtaraM priyatamaziSyanjca samIpE daNPAyamAnau vilOkya mAtaram avadat, hE yOSid EnaM tava putraM pazya, ");
INSERT INTO sancol_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ziSyantvavadat, EnAM tava mAtaraM pazya| tataH sa ziSyastadghaTikAyAM tAM nijagRhaM nItavAn| ");
INSERT INTO sancol_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","anantaraM sarvvaM karmmAdhunA sampannamabhUt yIzuriti jnjAtvA dharmmapustakasya vacanaM yathA siddhaM bhavati tadartham akathayat mama pipAsA jAtA| ");
INSERT INTO sancol_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","tatastasmin sthAnE amlarasEna pUrNapAtrasthityA tE spanjjamEkaM tadamlarasEnArdrIkRtya EsObnalE tad yOjayitvA tasya mukhasya sannidhAvasthApayan| ");
INSERT INTO sancol_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","tadA yIzuramlarasaM gRhItvA sarvvaM siddham iti kathAM kathayitvA mastakaM namayan prANAn paryyatyajat| ");
INSERT INTO sancol_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","tadvinam AsAdanadinaM tasmAt parE'hani vizrAmavArE dEhA yathA kruzOpari na tiSThanti, yataH sa vizrAmavArO mahAdinamAsIt, tasmAd yihUdIyAH pIlAtanikaTaM gatvA tESAM pAdabhanjjanasya sthAnAntaranayanasya cAnumatiM prArthayanta| ");
INSERT INTO sancol_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","ataH sEnA Agatya yIzunA saha kruzE hatayOH prathamadvitIyacOrayOH pAdAn abhanjjan; ");
INSERT INTO sancol_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","kintu yIzOH sannidhiM gatvA sa mRta iti dRSTvA tasya pAdau nAbhanjjan| ");
INSERT INTO sancol_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","pazcAd EkO yOddhA zUlAghAtEna tasya kukSim avidhat tatkSaNAt tasmAd raktaM jalanjca niragacchat| ");
INSERT INTO sancol_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","yO janO'sya sAkSyaM dadAti sa svayaM dRSTavAn tasyEdaM sAkSyaM satyaM tasya kathA yuSmAkaM vizvAsaM janayituM yOgyA tat sa jAnAti| ");
INSERT INTO sancol_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","tasyaikam asdhyapi na bhaMkSyatE, ");
INSERT INTO sancol_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","tadvad anyazAstrEpi likhyatE, yathA, \"dRSTipAtaM kariSyanti tE'vidhan yantu tamprati|\" ");
INSERT INTO sancol_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","arimathIyanagarasya yUSaphnAmA ziSya Eka AsIt kintu yihUdIyEbhyO bhayAt prakAzitO na bhavati; sa yIzO rdEhaM nEtuM pIlAtasyAnumatiM prArthayata, tataH pIlAtEnAnumatE sati sa gatvA yIzO rdEham anayat| ");
INSERT INTO sancol_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","aparaM yO nikadImO rAtrau yIzOH samIpam agacchat sOpi gandharasEna mizritaM prAyENa panjcAzatsETakamaguruM gRhItvAgacchat| ");
INSERT INTO sancol_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","tatastE yihUdIyAnAM zmazAnE sthApanarItyanusArENa tatsugandhidravyENa sahitaM tasya dEhaM vastrENAvESTayan| ");
INSERT INTO sancol_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","aparanjca yatra sthAnE taM kruzE'vidhan tasya nikaTasthOdyAnE yatra kimapi mRtadEhaM kadApi nAsthApyata tAdRzam EkaM nUtanaM zmazAnam AsIt| ");
INSERT INTO sancol_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","yihUdIyAnAm AsAdanadinAgamanAt tE tasmin samIpasthazmazAnE yIzum azAyayan| ");
INSERT INTO sancol_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","anantaraM saptAhasya prathamadinE 'tipratyUSE 'ndhakArE tiSThati magdalInI mariyam tasya zmazAnasya nikaTaM gatvA zmazAnasya mukhAt prastaramapasAritam apazyat| ");
INSERT INTO sancol_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","pazcAd dhAvitvA zimOnpitarAya yIzOH priyatamaziSyAya cEdam akathayat, lOkAH zmazAnAt prabhuM nItvA kutrAsthApayan tad vaktuM na zaknOmi| ");
INSERT INTO sancol_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","ataH pitaraH sOnyaziSyazca barhi rbhutvA zmazAnasthAnaM gantum ArabhEtAM| ");
INSERT INTO sancol_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ubhayOrdhAvatOH sOnyaziSyaH pitaraM pazcAt tyaktvA pUrvvaM zmazAnasthAna upasthitavAn| ");
INSERT INTO sancol_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","tadA prahvIbhUya sthApitavastrANi dRSTavAn kintu na prAvizat| ");
INSERT INTO sancol_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","aparaM zimOnpitara Agatya zmazAnasthAnaM pravizya ");
INSERT INTO sancol_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","sthApitavastrANi mastakasya vastranjca pRthak sthAnAntarE sthApitaM dRSTavAn| ");
INSERT INTO sancol_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","tataH zmazAnasthAnaM pUrvvam AgatO yOnyaziSyaH sOpi pravizya tAdRzaM dRSTA vyazvasIt| ");
INSERT INTO sancol_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","yataH zmazAnAt sa utthApayitavya Etasya dharmmapustakavacanasya bhAvaM tE tadA vOddhuM nAzankuvan| ");
INSERT INTO sancol_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","anantaraM tau dvau ziSyau svaM svaM gRhaM parAvRtyAgacchatAm| ");
INSERT INTO sancol_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","tataH paraM mariyam zmazAnadvArasya bahiH sthitvA rOditum Arabhata tatO rudatI prahvIbhUya zmazAnaM vilOkya ");
INSERT INTO sancol_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","yIzOH zayanasthAnasya ziraHsthAnE padatalE ca dvayO rdizO dvau svargIyadUtAvupaviSTau samapazyat| ");
INSERT INTO sancol_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","tau pRSTavantau hE nAri kutO rOdiSi? sAvadat lOkA mama prabhuM nItvA kutrAsthApayan iti na jAnAmi| ");
INSERT INTO sancol_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ityuktvA mukhaM parAvRtya yIzuM daNPAyamAnam apazyat kintu sa yIzuriti sA jnjAtuM nAzaknOt| ");
INSERT INTO sancol_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","tadA yIzustAm apRcchat hE nAri kutO rOdiSi? kaM vA mRgayasE? tataH sA tam udyAnasEvakaM jnjAtvA vyAharat, hE mahEccha tvaM yadItaH sthAnAt taM nItavAn tarhi kutrAsthApayastad vada tatsthAnAt tam AnayAmi| ");
INSERT INTO sancol_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","tadA yIzustAm avadat hE mariyam| tataH sA parAvRtya pratyavadat hE rabbUnI arthAt hE gurO| ");
INSERT INTO sancol_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","tadA yIzuravadat mAM mA dhara, idAnIM pituH samIpE UrddhvagamanaM na karOmi kintu yO mama yuSmAkanjca pitA mama yuSmAkanjcEzvarastasya nikaTa UrddhvagamanaM karttum udyatOsmi, imAM kathAM tvaM gatvA mama bhrAtRgaNaM jnjApaya| ");
INSERT INTO sancol_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","tatO magdalInImariyam tatkSaNAd gatvA prabhustasyai darzanaM dattvA kathA EtA akathayad iti vArttAM ziSyEbhyO'kathayat| ");
INSERT INTO sancol_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","tataH paraM saptAhasya prathamadinasya sandhyAsamayE ziSyA Ekatra militvA yihUdIyEbhyO bhiyA dvAraruddham akurvvan, Etasmin kAlE yIzustESAM madhyasthAnE tiSThan akathayad yuSmAkaM kalyANaM bhUyAt| ");
INSERT INTO sancol_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ityuktvA nijahastaM kukSinjca darzitavAn, tataH ziSyAH prabhuM dRSTvA hRSTA abhavan| ");
INSERT INTO sancol_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","yIzuH punaravadad yuSmAkaM kalyANaM bhUyAt pitA yathA mAM praiSayat tathAhamapi yuSmAn prESayAmi| ");
INSERT INTO sancol_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ityuktvA sa tESAmupari dIrghaprazvAsaM dattvA kathitavAn pavitram AtmAnaM gRhlIta| ");
INSERT INTO sancol_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","yUyaM yESAM pApAni mOcayiSyatha tE mOcayiSyantE yESAnjca pApAti na mOcayiSyatha tE na mOcayiSyantE| ");
INSERT INTO sancol_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","dvAdazamadhyE gaNitO yamajO thOmAnAmA ziSyO yIzOrAgamanakAlai taiH sArddhaM nAsIt| ");
INSERT INTO sancol_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","atO vayaM prabhUm apazyAmEti vAkyE'nyaziSyairuktE sOvadat, tasya hastayO rlauhakIlakAnAM cihnaM na vilOkya taccihnam aggulyA na spRSTvA tasya kukSau hastaM nArOpya cAhaM na vizvasiSyAmi| ");
INSERT INTO sancol_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","aparam aSTamE'hni gatE sati thOmAsahitaH ziSyagaNa Ekatra militvA dvAraM ruddhvAbhyantara AsIt, Etarhi yIzustESAM madhyasthAnE tiSThan akathayat, yuSmAkaM kuzalaM bhUyAt| ");
INSERT INTO sancol_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","pazcAt thAmai kathitavAn tvam aggulIm atrArpayitvA mama karau pazya karaM prasAryya mama kukSAvarpaya nAvizvasya| ");
INSERT INTO sancol_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","tadA thOmA avadat, hE mama prabhO hE madIzvara| ");
INSERT INTO sancol_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","yIzurakathayat, hE thOmA mAM nirIkSya vizvasiSi yE na dRSTvA vizvasanti taEva dhanyAH| ");
INSERT INTO sancol_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","EtadanyAni pustakE'smin alikhitAni bahUnyAzcaryyakarmmANi yIzuH ziSyANAM purastAd akarOt| ");
INSERT INTO sancol_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","kintu yIzurIzvarasyAbhiSiktaH suta EvEti yathA yUyaM vizvasitha vizvasya ca tasya nAmnA paramAyuH prApnutha tadartham EtAni sarvvANyalikhyanta| ");
INSERT INTO sancol_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","tataH paraM tibiriyAjaladhEstaTE yIzuH punarapi ziSyEbhyO darzanaM dattavAn darzanasyAkhyAnamidam| ");
INSERT INTO sancol_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","zimOnpitaraH yamajathOmA gAlIlIyakAnnAnagaranivAsI nithanEl sivadEH putrAvanyau dvau ziSyau caitESvEkatra militESu zimOnpitarO'kathayat matsyAn dhartuM yAmi| ");
INSERT INTO sancol_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","tatastE vyAharan tarhi vayamapi tvayA sArddhaM yAmaH tadA tE bahirgatAH santaH kSipraM nAvam ArOhan kintu tasyAM rajanyAm Ekamapi na prApnuvan| ");
INSERT INTO sancol_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","prabhAtE sati yIzustaTE sthitavAn kintu sa yIzuriti ziSyA jnjAtuM nAzaknuvan| ");
INSERT INTO sancol_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","tadA yIzurapRcchat, hE vatsA sannidhau kinjcit khAdyadravyam AstE? tE'vadan kimapi nAsti| ");
INSERT INTO sancol_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","tadA sO'vadat naukAyA dakSiNapArzvE jAlaM nikSipata tatO lapsyadhvE, tasmAt tai rnikSiptE jAlE matsyA EtAvantO'patan yEna tE jAlamAkRSya nOttOlayituM zaktAH| ");
INSERT INTO sancol_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","tasmAd yIzOH priyatamaziSyaH pitarAyAkathayat ESa prabhu rbhavEt, ESa prabhuriti vAcaM zrutvaiva zimOn nagnatAhEtO rmatsyadhAriNa uttarIyavastraM paridhAya hradaM pratyudalamphayat| ");
INSERT INTO sancol_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","aparE ziSyA matsyaiH sArddhaM jAlam AkarSantaH kSudranaukAM vAhayitvA kUlamAnayan tE kUlAd atidUrE nAsan dvizatahastEbhyO dUra Asan ityanumIyatE| ");
INSERT INTO sancol_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","tIraM prAptaistaistatra prajvalitAgnistadupari matsyAH pUpAzca dRSTAH| ");
INSERT INTO sancol_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","tatO yIzurakathayad yAn matsyAn adharata tESAM katipayAn Anayata| ");
INSERT INTO sancol_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ataH zimOnpitaraH parAvRtya gatvA bRhadbhistripanjcAzadadhikazatamatsyaiH paripUrNaM tajjAlam AkRSyOdatOlayat kintvEtAvadbhi rmatsyairapi jAlaM nAchidyata| ");
INSERT INTO sancol_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","anantaraM yIzustAn avAdIt yUyamAgatya bhuMgdhvaM; tadA saEva prabhuriti jnjAtatvAt tvaM kaH? iti praSTuM ziSyANAM kasyApi pragalbhatA nAbhavat| ");
INSERT INTO sancol_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","tatO yIzurAgatya pUpAn matsyAMzca gRhItvA tEbhyaH paryyavESayat| ");
INSERT INTO sancol_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","itthaM zmazAnAdutthAnAt paraM yIzuH ziSyEbhyastRtIyavAraM darzanaM dattavAn| ");
INSERT INTO sancol_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","bhOjanE samAptE sati yIzuH zimOnpitaraM pRSTavAn, hE yUnasaH putra zimOn tvaM kim EtEbhyOdhikaM mayi prIyasE? tataH sa uditavAn satyaM prabhO tvayi prIyE'haM tad bhavAn jAnAti; tadA yIzurakathayat tarhi mama mESazAvakagaNaM pAlaya| ");
INSERT INTO sancol_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","tataH sa dvitIyavAraM pRSTavAn hE yUnasaH putra zimOn tvaM kiM mayi prIyasE? tataH sa uktavAn satyaM prabhO tvayi prIyE'haM tad bhavAn jAnAti; tadA yIzurakathayata tarhi mama mESagaNaM pAlaya| ");
INSERT INTO sancol_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","pazcAt sa tRtIyavAraM pRSTavAn, hE yUnasaH putra zimOn tvaM kiM mayi prIyasE? EtadvAkyaM tRtIyavAraM pRSTavAn tasmAt pitarO duHkhitO bhUtvA'kathayat hE prabhO bhavataH kimapyagOcaraM nAsti tvayyahaM prIyE tad bhavAn jAnAti; tatO yIzuravadat tarhi mama mESagaNaM pAlaya| ");
INSERT INTO sancol_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","ahaM tubhyaM yathArthaM kathayAmi yauvanakAlE svayaM baddhakaTi ryatrEcchA tatra yAtavAn kintvitaH paraM vRddhE vayasi hastaM vistArayiSyasi, anyajanastvAM baddhvA yatra gantuM tavEcchA na bhavati tvAM dhRtvA tatra nESyati| ");
INSERT INTO sancol_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","phalataH kIdRzEna maraNEna sa Izvarasya mahimAnaM prakAzayiSyati tad bOdhayituM sa iti vAkyaM prOktavAn| ityuktE sati sa tamavOcat mama pazcAd Agaccha| ");
INSERT INTO sancol_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","yO janO rAtrikAlE yIzO rvakSO'valambya, hE prabhO kO bhavantaM parakarESu samarpayiSyatIti vAkyaM pRSTavAn, taM yIzOH priyatamaziSyaM pazcAd AgacchantaM ");
INSERT INTO sancol_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","pitarO mukhaM parAvarttya vilOkya yIzuM pRSTavAn, hE prabhO Etasya mAnavasya kIdRzI gati rbhaviSyati? ");
INSERT INTO sancol_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","sa pratyavadat, mama punarAgamanaparyyantaM yadi taM sthApayitum icchAmi tatra tava kiM? tvaM mama pazcAd Agaccha| ");
INSERT INTO sancol_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","tasmAt sa ziSyO na mariSyatIti bhrAtRgaNamadhyE kiMvadantI jAtA kintu sa na mariSyatIti vAkyaM yIzu rnAvadat kEvalaM mama punarAgamanaparyyantaM yadi taM sthApayitum icchAmi tatra tava kiM? iti vAkyam uktavAn| ");
INSERT INTO sancol_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","yO jana EtAni sarvvANi likhitavAn atra sAkSyanjca dattavAn saEva sa ziSyaH, tasya sAkSyaM pramANamiti vayaM jAnImaH| ");
INSERT INTO sancol_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","yIzurEtEbhyO'parANyapi bahUni karmmANi kRtavAn tAni sarvvANi yadyEkaikaM kRtvA likhyantE tarhi granthA EtAvantO bhavanti tESAM dhAraNE pRthivyAM sthAnaM na bhavati| iti||");
INSERT INTO sancol_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","hE thiyaphila, yIzuH svamanOnItAn prEritAn pavitrENAtmanA samAdizya yasmin dinE svargamArOhat yAM yAM kriyAmakarOt yadyad upAdizacca tAni sarvvANi pUrvvaM mayA likhitAni| ");
INSERT INTO sancol_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","sa svanidhanaduHkhabhOgAt param anEkapratyayakSapramANauH svaM sajIvaM darzayitvA ");
INSERT INTO sancol_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","catvAriMzaddinAni yAvat tEbhyaH prEritEbhyO darzanaM dattvEzvarIyarAjyasya varNanama akarOt| ");
INSERT INTO sancol_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","anantaraM tESAM sabhAM kRtvA ityAjnjApayat, yUyaM yirUzAlamO'nyatra gamanamakRtvA yastin pitrAggIkRtE mama vadanAt kathA azRNuta tatprAptim apEkSya tiSThata| ");
INSERT INTO sancol_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","yOhan jalE majjitAvAn kintvalpadinamadhyE yUyaM pavitra Atmani majjitA bhaviSyatha| ");
INSERT INTO sancol_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","pazcAt tE sarvvE militvA tam apRcchan hE prabhO bhavAn kimidAnIM punarapi rAjyam isrAyElIyalOkAnAM karESu samarpayiSyati? ");
INSERT INTO sancol_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","tataH sOvadat yAn sarvvAn kAlAn samayAMzca pitA svavazE'sthApayat tAn jnjAtRM yuSmAkam adhikArO na jAyatE| ");
INSERT INTO sancol_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","kintu yuSmAsu pavitrasyAtmana AvirbhAvE sati yUyaM zaktiM prApya yirUzAlami samastayihUdAzOmirONadEzayOH pRthivyAH sImAM yAvad yAvantO dEzAstESu yarvvESu ca mayi sAkSyaM dAsyatha| ");
INSERT INTO sancol_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","iti vAkyamuktvA sa tESAM samakSaM svargaM nItO'bhavat, tatO mEghamAruhya tESAM dRSTEragOcarO'bhavat| ");
INSERT INTO sancol_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","yasmin samayE tE vihAyasaM pratyananyadRSTyA tasya tAdRzam Urdvvagamanam apazyan tasminnEva samayE zuklavastrau dvau janau tESAM sannidhau daNPAyamAnau kathitavantau, ");
INSERT INTO sancol_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","hE gAlIlIyalOkA yUyaM kimarthaM gagaNaM prati nirIkSya daNPAyamAnAstiSThatha? yuSmAkaM samIpAt svargaM nItO yO yIzustaM yUyaM yathA svargam ArOhantam adarzam tathA sa punazcAgamiSyati| ");
INSERT INTO sancol_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","tataH paraM tE jaitunanAmnaH parvvatAd vizrAmavArasya pathaH parimANam arthAt prAyENArddhakrOzaM durasthaM yirUzAlamnagaraM parAvRtyAgacchan| ");
INSERT INTO sancol_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","nagaraM pravizya pitarO yAkUb yOhan AndriyaH philipaH thOmA barthajamayO mathirAlphIyaputrO yAkUb udyOgAी zimOn yAkUbO bhrAtA yihUdA EtE sarvvE yatra sthAnE pravasanti tasmin uparitanaprakOSThE prAvizan| ");
INSERT INTO sancol_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","pazcAd imE kiyatyaH striyazca yIzO rmAtA mariyam tasya bhrAtarazcaitE sarvva EkacittIbhUta satataM vinayEna vinayEna prArthayanta| ");
INSERT INTO sancol_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","tasmin samayE tatra sthAnE sAkalyEna viMzatyadhikazataM ziSyA Asan| tataH pitarastESAM madhyE tiSThan uktavAn ");
INSERT INTO sancol_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","hE bhrAtRgaNa yIzudhAriNAM lOkAnAM pathadarzakO yO yihUdAstasmin dAyUdA pavitra AtmA yAM kathAM kathayAmAsa tasyAH pratyakSIbhavanasyAvazyakatvam AsIt| ");
INSERT INTO sancol_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","sa janO'smAkaM madhyavarttI san asyAH sEvAyA aMzam alabhata| ");
INSERT INTO sancol_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","tadanantaraM kukarmmaNA labdhaM yanmUlyaM tEna kSEtramEkaM krItam aparaM tasmin adhOmukhE bhRmau patitE sati tasyOdarasya vidIrNatvAt sarvvA nAPyO niragacchan| ");
INSERT INTO sancol_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","EtAM kathAM yirUzAlamnivAsinaH sarvvE lOkA vidAnti; tESAM nijabhASayA tatkSEtranjca hakaldAmA, arthAt raktakSEtramiti vikhyAtamAstE| ");
INSERT INTO sancol_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","anyacca, nikEtanaM tadIyantu zunyamEva bhaviSyati| tasya dUSyE nivAsArthaM kOpi sthAsyati naiva hi| anya Eva janastasya padaM saMprApsyati dhruvaM| itthaM gItapustakE likhitamAstE| ");
INSERT INTO sancol_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","atO yOhanO majjanam ArabhyAsmAkaM samIpAt prabhO ryIzOH svargArOhaNadinaM yAvat sOsmAkaM madhyE yAvanti dinAni yApitavAn ");
INSERT INTO sancol_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","tAvanti dinAni yE mAnavA asmAbhiH sArddhaM tiSThanti tESAm EkEna janEnAsmAbhiH sArddhaM yIzOrutthAnE sAkSiNA bhavitavyaM| ");
INSERT INTO sancol_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","atO yasya rUPhi ryuSTO yaM barzabbEtyuktvAhUyanti sa yUSaph matathizca dvAvEtau pRthak kRtvA ta Izvarasya sannidhau prAryya kathitavantaH, ");
INSERT INTO sancol_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","hE sarvvAntaryyAmin paramEzvara, yihUdAH sEvanaprEritatvapadacyutaH ");
INSERT INTO sancol_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","san nijasthAnam agacchat, tatpadaM labdhum EnayO rjanayO rmadhyE bhavatA kO'bhirucitastadasmAn darzyatAM| ");
INSERT INTO sancol_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","tatO guTikApATE kRtE matathirniracIyata tasmAt sOnyESAm EkAdazAnAM praritAnAM madhyE gaNitObhavat| ");
INSERT INTO sancol_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","aparanjca nistArOtsavAt paraM panjcAzattamE dinE samupasthitE sati tE sarvvE EkAcittIbhUya sthAna Ekasmin militA Asan| ");
INSERT INTO sancol_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","EtasminnEva samayE'kasmAd AkAzAt pracaNPAtyugravAyOH zabdavad EkaH zabda Agatya yasmin gRhE ta upAvizan tad gRhaM samastaM vyApnOt| ");
INSERT INTO sancol_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","tataH paraM vahnizikhAsvarUpA jihvAH pratyakSIbhUya vibhaktAH satyaH pratijanOrddhvE sthagitA abhUvan| ");
INSERT INTO sancol_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","tasmAt sarvvE pavitrENAtmanA paripUrNAH santa AtmA yathA vAcitavAn tadanusArENAnyadEzIyAnAM bhASA uktavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","tasmin samayE pRthivIsthasarvvadEzEbhyO yihUdIyamatAvalambinO bhaktalOkA yirUzAlami prAvasan; ");
INSERT INTO sancol_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","tasyAH kathAyAH kiMvadantyA jAtatvAt sarvvE lOkA militvA nijanijabhASayA ziSyANAM kathAkathanaM zrutvA samudvignA abhavan| ");
INSERT INTO sancol_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","sarvvaEva vismayApannA AzcaryyAnvitAzca santaH parasparaM uktavantaH pazyata yE kathAM kathayanti tE sarvvE gAlIlIyalOkAH kiM na bhavanti? ");
INSERT INTO sancol_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","tarhi vayaM pratyEkazaH svasvajanmadEzIyabhASAbhiH kathA EtESAM zRNumaH kimidaM? ");
INSERT INTO sancol_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","pArthI-mAdI-arAmnaharayimdEzanivAsimanO yihUdA-kappadakiyA-panta-AziyA- ");
INSERT INTO sancol_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","phrugiyA-pamphuliyA-misaranivAsinaH kurINInikaTavarttilUbIyapradEzanivAsinO rOmanagarAd AgatA yihUdIyalOkA yihUdIyamatagrAhiNaH krItIyA arAbIyAdayO lOkAzca yE vayam ");
INSERT INTO sancol_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","asmAkaM nijanijabhASAbhirEtESAm IzvarIyamahAkarmmavyAkhyAnaM zRNumaH| ");
INSERT INTO sancol_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","itthaM tE sarvvaEva vismayApannAH sandigdhacittAH santaH parasparamUcuH, asya kO bhAvaH? ");
INSERT INTO sancol_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","aparE kEcit parihasya kathitavanta EtE navInadrAkSArasEna mattA abhavan| ");
INSERT INTO sancol_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","tadA pitara EkAdazabhi rjanaiH sAkaM tiSThan tAllOkAn uccaiHkAram avadat, hE yihUdIyA hE yirUzAlamnivAsinaH sarvvE, avadhAnaM kRtvA madIyavAkyaM budhyadhvaM| ");
INSERT INTO sancol_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","idAnIm EkayAmAd adhikA vElA nAsti tasmAd yUyaM yad anumAtha mAnavA imE madyapAnEna mattAstanna| ");
INSERT INTO sancol_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","kintu yOyElbhaviSyadvaktraitadvAkyamuktaM yathA, ");
INSERT INTO sancol_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","IzvaraH kathayAmAsa yugAntasamayE tvaham| varSiSyAmi svamAtmAnaM sarvvaprANyupari dhruvam| bhAvivAkyaM vadiSyanti kanyAH putrAzca vastutaH|pratyAdEzanjca prApsyanti yuSmAkaM yuvamAnavAH| tathA prAcInalOkAstu svapnAn drakSyanti nizcitaM| ");
INSERT INTO sancol_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","varSiSyAmi tadAtmAnaM dAsadAsIjanOpiri| tEnaiva bhAvivAkyaM tE vadiSyanti hi sarvvazaH| ");
INSERT INTO sancol_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","UrddhvasthE gagaNE caiva nIcasthE pRthivItalE| zONitAni bRhadbhAnUn ghanadhUmAdikAni ca| cihnAni darzayiSyAmi mahAzcaryyakriyAstathA| ");
INSERT INTO sancol_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","mahAbhayAnakasyaiva taddinasya parEzituH| purAgamAd raviH kRSNO raktazcandrO bhaviSyataH| ");
INSERT INTO sancol_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","kintu yaH paramEzasya nAmni samprArthayiSyatE| saEva manujO nUnaM paritrAtO bhaviSyati|| ");
INSERT INTO sancol_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","atO hE isrAyElvaMzIyalOkAH sarvvE kathAyAmEtasyAm manO nidhaddhvaM nAsaratIyO yIzurIzvarasya manOnItaH pumAn Etad IzvarastatkRtairAzcaryyAdbhutakarmmabhi rlakSaNaizca yuSmAkaM sAkSAdEva pratipAditavAn iti yUyaM jAnItha| ");
INSERT INTO sancol_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","tasmin yIzau Izvarasya pUrvvanizcitamantraNAnirUpaNAnusArENa mRtyau samarpitE sati yUyaM taM dhRtvA duSTalOkAnAM hastaiH kruzE vidhitvAhata| ");
INSERT INTO sancol_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","kintvIzvarastaM nidhanasya bandhanAnmOcayitvA udasthApayat yataH sa mRtyunA baddhastiSThatIti na sambhavati| ");
INSERT INTO sancol_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Etastin dAyUdapi kathitavAn yathA, sarvvadA mama sAkSAttaM sthApaya paramEzvaraM| sthitE maddakSiNE tasmin skhaliSyAmi tvahaM nahi| ");
INSERT INTO sancol_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","AnandiSyati taddhEtO rmAmakInaM manastu vai| AhlAdiSyati jihvApi madIyA tu tathaiva ca| pratyAzayA zarIrantu madIyaM vaizayiSyatE| ");
INSERT INTO sancol_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","paralOkE yatO hEtOstvaM mAM naiva hi tyakSyasi| svakIyaM puNyavantaM tvaM kSayituM naiva dAsyasi| EvaM jIvanamArgaM tvaM mAmEva darzayiSyasi| ");
INSERT INTO sancol_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","svasammukhE ya AnandO dakSiNE svasya yat sukhaM| anantaM tEna mAM pUrNaM kariSyasi na saMzayaH|| ");
INSERT INTO sancol_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","hE bhrAtarO'smAkaM tasya pUrvvapuruSasya dAyUdaH kathAM spaSTaM kathayituM mAm anumanyadhvaM, sa prANAn tyaktvA zmazAnE sthApitObhavad adyApi tat zmazAnam asmAkaM sannidhau vidyatE| ");
INSERT INTO sancol_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","phalatO laukikabhAvEna dAyUdO vaMzE khrISTaM janma grAhayitvA tasyaiva siMhAsanE samuvESTuM tamutthApayiSyati paramEzvaraH zapathaM kutvA dAyUdaH samIpa imam aggIkAraM kRtavAn, ");
INSERT INTO sancol_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","iti jnjAtvA dAyUd bhaviSyadvAdI san bhaviSyatkAlIyajnjAnEna khrISTOtthAnE kathAmimAM kathayAmAsa yathA tasyAtmA paralOkE na tyakSyatE tasya zarIranjca na kSESyati; ");
INSERT INTO sancol_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","ataH paramEzvara EnaM yIzuM zmazAnAd udasthApayat tatra vayaM sarvvE sAkSiNa AsmahE| ");
INSERT INTO sancol_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","sa Izvarasya dakSiNakarENOnnatiM prApya pavitra Atmina pitA yamaggIkAraM kRtavAn tasya phalaM prApya yat pazyatha zRNutha ca tadavarSat| ");
INSERT INTO sancol_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","yatO dAyUd svargaM nArurOha kintu svayam imAM kathAm akathayad yathA, mama prabhumidaM vAkyamavadat paramEzvaraH| ");
INSERT INTO sancol_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","tava zatrUnahaM yAvat pAdapIThaM karOmi na| tAvat kAlaM madIyE tvaM dakSavArzva upAviza| ");
INSERT INTO sancol_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","atO yaM yIzuM yUyaM kruzE'hata paramEzvarastaM prabhutvAbhiSiktatvapadE nyayuMktEti isrAyElIyA lOkA nizcitaM jAnantu| ");
INSERT INTO sancol_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","EtAdRzIM kathAM zrutvA tESAM hRdayAnAM vidIrNatvAt tE pitarAya tadanyaprEritEbhyazca kathitavantaH, hE bhrAtRgaNa vayaM kiM kariSyAmaH? ");
INSERT INTO sancol_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","tataH pitaraH pratyavadad yUyaM sarvvE svaM svaM manaH parivarttayadhvaM tathA pApamOcanArthaM yIzukhrISTasya nAmnA majjitAzca bhavata, tasmAd dAnarUpaM paritram AtmAnaM lapsyatha| ");
INSERT INTO sancol_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","yatO yuSmAkaM yuSmatsantAnAnAnjca dUrasthasarvvalOkAnAnjca nimittam arthAd asmAkaM prabhuH paramEzvarO yAvatO lAkAn AhvAsyati tESAM sarvvESAM nimittam ayamaggIkAra AstE| ");
INSERT INTO sancol_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","EtadanyAbhi rbahukathAbhiH pramANaM datvAkathayat EtEbhyO vipathagAmibhyO varttamAnalOkEbhyaH svAn rakSata| ");
INSERT INTO sancol_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","tataH paraM yE sAnandAstAM kathAm agRhlan tE majjitA abhavan| tasmin divasE prAyENa trINi sahasrANi lOkAstESAM sapakSAH santaH ");
INSERT INTO sancol_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","prEritAnAm upadEzE saggatau pUpabhanjjanE prArthanAsu ca manaHsaMyOgaM kRtvAtiSThan| ");
INSERT INTO sancol_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","prEritai rnAnAprakAralakSaNESu mahAzcaryyakarmamasu ca darzitESu sarvvalOkAnAM bhayamupasthitaM| ");
INSERT INTO sancol_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","vizvAsakAriNaH sarvva ca saha tiSThanataH| svESAM sarvvAH sampattIH sAdhAraNyEna sthApayitvAbhunjjata| ");
INSERT INTO sancol_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","phalatO gRhANi dravyANi ca sarvvANi vikrIya sarvvESAM svasvaprayOjanAnusArENa vibhajya sarvvEbhyO'dadan| ");
INSERT INTO sancol_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","sarvva EkacittIbhUya dinE dinE mandirE santiSThamAnA gRhE gRhE ca pUpAnabhanjjanta Izvarasya dhanyavAdaM kurvvantO lOkaiH samAdRtAH paramAnandEna saralAntaHkaraNEna bhOjanaM pAnanjcakurvvan| ");
INSERT INTO sancol_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","paramEzvarO dinE dinE paritrANabhAjanai rmaNPalIm avarddhayat| ");
INSERT INTO sancol_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","tRtIyayAmavElAyAM satyAM prArthanAyAH samayE pitarayOhanau sambhUya mandiraM gacchataH| ");
INSERT INTO sancol_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","tasminnEva samayE mandirapravEzakAnAM samIpE bhikSAraNArthaM yaM janmakhanjjamAnuSaM lOkA mandirasya sundaranAmni dvArE pratidinam asthApayan taM vahantastadvAraM Anayan| ");
INSERT INTO sancol_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","tadA pitarayOhanau mantiraM pravESTum udyatau vilOkya sa khanjjastau kinjcid bhikSitavAn| ");
INSERT INTO sancol_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","tasmAd yOhanA sahitaH pitarastam ananyadRSTyA nirIkSya prOktavAn AvAM prati dRSTiM kuru| ");
INSERT INTO sancol_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","tataH sa kinjcit prAptyAzayA tau prati dRSTiM kRtavAn| ");
INSERT INTO sancol_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","tadA pitarO gaditavAn mama nikaTE svarNarUpyAdi kimapi nAsti kintu yadAstE tad dadAmi nAsaratIyasya yIzukhrISTasya nAmnA tvamutthAya gamanAgamanE kuru| ");
INSERT INTO sancol_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","tataH paraM sa tasya dakSiNakaraM dhRtvA tam udatOlayat; tEna tatkSaNAt tasya janasya pAdagulphayOH sabalatvAt sa ullamphya prOtthAya gamanAgamanE 'karOt| ");
INSERT INTO sancol_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","tatO gamanAgamanE kurvvan ullamphan IzvaraM dhanyaM vadan tAbhyAM sArddhaM mandiraM prAvizat| ");
INSERT INTO sancol_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","tataH sarvvE lOkAstaM gamanAgamanE kurvvantam IzvaraM dhanyaM vadantanjca vilOkya ");
INSERT INTO sancol_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","mandirasya sundarE dvArE ya upavizya bhikSitavAn saEvAyam iti jnjAtvA taM prati tayA ghaTanayA camatkRtA vismayApannAzcAbhavan| ");
INSERT INTO sancol_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","yaH khanjjaH svasthObhavat tEna pitarayOhanOH karayOrdhTatayOH satOH sarvvE lOkA sannidhim Agacchan| ");
INSERT INTO sancol_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","tad dRSTvA pitarastEbhyO'kathayat, hE isrAyElIyalOkA yUyaM kutO 'nEnAzcaryyaM manyadhvE? AvAM nijazaktyA yadvA nijapuNyEna khanjjamanuSyamEnaM gamitavantAviti cintayitvA AvAM prati kutO'nanyadRSTiM kurutha? ");
INSERT INTO sancol_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","yaM yIzuM yUyaM parakarESu samArpayata tatO yaM pIlAtO mOcayitum Eैcchat tathApi yUyaM tasya sAkSAn nAggIkRtavanta ibrAhIma ishAkO yAkUbazcEzvarO'rthAd asmAkaM pUrvvapuruSANAm IzvaraH svaputrasya tasya yIzO rmahimAnaM prAkAzayat| ");
INSERT INTO sancol_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","kintu yUyaM taM pavitraM dhArmmikaM pumAMsaM nAggIkRtya hatyAkAriNamEkaM svEbhyO dAtum ayAcadhvaM| ");
INSERT INTO sancol_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","pazcAt taM jIvanasyAdhipatim ahata kintvIzvaraH zmazAnAt tam udasthApayata tatra vayaM sAkSiNa AsmahE| ");
INSERT INTO sancol_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","imaM yaM mAnuSaM yUyaM pazyatha paricinutha ca sa tasya nAmni vizvAsakaraNAt calanazaktiM labdhavAn tasmin tasya yO vizvAsaH sa taM yuSmAkaM sarvvESAM sAkSAt sampUrNarUpENa svastham akArSIt| ");
INSERT INTO sancol_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","hE bhrAtarO yUyaM yuSmAkam adhipatayazca ajnjAtvA karmmANyEtAni kRtavanta idAnIM mamaiSa bOdhO jAyatE| ");
INSERT INTO sancol_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","kintvIzvaraH khrISTasya duHkhabhOgE bhaviSyadvAdinAM mukhEbhyO yAM yAM kathAM pUrvvamakathayat tAH kathA itthaM siddhA akarOt| ");
INSERT INTO sancol_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","ataH svESAM pApamOcanArthaM khEdaM kRtvA manAMsi parivarttayadhvaM, tasmAd IzvarAt sAntvanAprAptEH samaya upasthAsyati; ");
INSERT INTO sancol_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","punazca pUrvvakAlam Arabhya pracAritO yO yIzukhrISTastam IzvarO yuSmAn prati prESayiSyati| ");
INSERT INTO sancol_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","kintu jagataH sRSTimArabhya IzvarO nijapavitrabhaviSyadvAdigaNOna yathA kathitavAn tadanusArENa sarvvESAM kAryyANAM siddhiparyyantaM tEna svargE vAsaH karttavyaH| ");
INSERT INTO sancol_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","yuSmAkaM prabhuH paramEzvarO yuSmAkaM bhrAtRgaNamadhyAt matsadRzaM bhaviSyadvaktAram utpAdayiSyati, tataH sa yat kinjcit kathayiSyati tatra yUyaM manAMsi nidhaddhvaM| ");
INSERT INTO sancol_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","kintu yaH kazcit prANI tasya bhaviSyadvAdinaH kathAM na grahISyati sa nijalOkAnAM madhyAd ucchEtsyatE,\" imAM kathAm asmAkaM pUrvvapuruSEbhyaH kEvalO mUsAH kathayAmAsa iti nahi, ");
INSERT INTO sancol_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","zimUyElbhaviSyadvAdinam Arabhya yAvantO bhaviSyadvAkyam akathayan tE sarvvaEva samayasyaitasya kathAm akathayan| ");
INSERT INTO sancol_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","yUyamapi tESAM bhaviSyadvAdinAM santAnAH, \"tava vaMzOdbhavapuMsA sarvvadEzIyA lOkA AziSaM prAptA bhaviSyanti\", ibrAhImE kathAmEtAM kathayitvA IzvarOsmAkaM pUrvvapuruSaiH sArddhaM yaM niyamaM sthirIkRtavAn tasya niyamasyAdhikAriNOpi yUyaM bhavatha| ");
INSERT INTO sancol_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ata IzvarO nijaputraM yIzum utthApya yuSmAkaM sarvvESAM svasvapApAt parAvarttya yuSmabhyam AziSaM dAtuM prathamatastaM yuSmAkaM nikaTaM prESitavAn| ");
INSERT INTO sancol_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","yasmin samayE pitarayOhanau lOkAn upadizatastasmin samayE yAjakA mandirasya sEnApatayaH sidUkIgaNazca ");
INSERT INTO sancol_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","tayOr upadEzakaraNE khrISTasyOtthAnam upalakSya sarvvESAM mRtAnAm utthAnaprastAvE ca vyagrAH santastAvupAgaman| ");
INSERT INTO sancol_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","tau dhRtvA dinAvasAnakAraNAt paradinaparyyanantaM ruddhvA sthApitavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","tathApi yE lOkAstayOrupadEzam azRNvan tESAM prAyENa panjcasahasrANi janA vyazvasan| ");
INSERT INTO sancol_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","parE'hani adhipatayaH prAcInA adhyApakAzca hAnananAmA mahAyAjakaH ");
INSERT INTO sancol_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","kiyaphA yOhan sikandara ityAdayO mahAyAjakasya jnjAtayaH sarvvE yirUzAlamnagarE militAH| ");
INSERT INTO sancol_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","anantaraM prEritau madhyE sthApayitvApRcchan yuvAM kayA zaktayA vA kEna nAmnA karmmANyEtAni kuruthaH? ");
INSERT INTO sancol_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","tadA pitaraH pavitrENAtmanA paripUrNaH san pratyavAdIt, hE lOkAnAm adhipatigaNa hE isrAyElIyaprAcInAH, ");
INSERT INTO sancol_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Etasya durbbalamAnuSasya hitaM yat karmmAkriyata, arthAt, sa yEna prakArENa svasthObhavat taccEd adyAvAM pRcchatha, ");
INSERT INTO sancol_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","tarhi sarvva isrAyEेlIyalOkA yUyaM jAnIta nAsaratIyO yO yIzukhrISTaH kruzE yuSmAbhiravidhyata yazcEzvarENa zmazAnAd utthApitaH, tasya nAmnA janOyaM svasthaH san yuSmAkaM sammukhE prOttiSThati| ");
INSERT INTO sancol_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","nicEtRbhi ryuSmAbhirayaM yaH prastarO'vajnjAtO'bhavat sa pradhAnakONasya prastarO'bhavat| ");
INSERT INTO sancol_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","tadbhinnAdaparAt kasmAdapi paritrANaM bhavituM na zaknOti, yEna trANaM prApyEta bhUmaNPalasyalOkAnAM madhyE tAdRzaM kimapi nAma nAsti| ");
INSERT INTO sancol_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","tadA pitarayOhanOrEtAdRzIm akSEbhatAM dRSTvA tAvavidvAMsau nIcalOkAviti buddhvA Azcaryyam amanyanta tau ca yIzOH sagginau jAtAviti jnjAtum azaknuvan| ");
INSERT INTO sancol_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","kintu tAbhyAM sArddhaM taM svasthamAnuSaM tiSThantaM dRSTvA tE kAmapyaparAm ApattiM karttaM nAzaknun| ");
INSERT INTO sancol_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","tadA tE sabhAtaH sthAnAntaraM gantuM tAn AjnjApya svayaM parasparam iti mantraNAmakurvvan ");
INSERT INTO sancol_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","tau mAnavau prati kiM karttavyaM? tAvEkaM prasiddham AzcaryyaM karmma kRtavantau tad yirUzAlamnivAsinAM sarvvESAM lOkAnAM samIpE prAkAzata tacca vayamapahnOtuM na zaknumaH| ");
INSERT INTO sancol_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","kintu lOkAnAM madhyam Etad yathA na vyApnOti tadarthaM tau bhayaM pradarzya tEna nAmnA kamapi manuSyaM nOpadizatam iti dRPhaM niSEdhAmaH| ");
INSERT INTO sancol_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","tatastE prEritAvAhUya EtadAjnjApayan itaH paraM yIzO rnAmnA kadApi kAmapi kathAM mA kathayataM kimapi nOpadizanjca| ");
INSERT INTO sancol_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","tataH pitarayOhanau pratyavadatAm IzvarasyAjnjAgrahaNaM vA yuSmAkam AjnjAgrahaNam EtayO rmadhyE Izvarasya gOcarE kiM vihitaM? yUyaM tasya vivEcanAM kuruta| ");
INSERT INTO sancol_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","vayaM yad apazyAma yadazRNuma ca tanna pracArayiSyAma Etat kadApi bhavituM na zaknOti| ");
INSERT INTO sancol_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","yadaghaTata tad dRSTA sarvvE lOkA Izvarasya guNAn anvavadan tasmAt lOkabhayAt tau daNPayituM kamapyupAyaM na prApya tE punarapi tarjayitvA tAvatyajan| ");
INSERT INTO sancol_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","yasya mAnuSasyaitat svAsthyakaraNam AzcaryyaM karmmAkriyata tasya vayazcatvAriMzadvatsarA vyatItAH| ");
INSERT INTO sancol_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","tataH paraM tau visRSTau santau svasagginAM sannidhiM gatvA pradhAnayAjakaiH prAcInalOkaizca prOktAH sarvvAH kathA jnjApitavantau| ");
INSERT INTO sancol_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","tacchrutvA sarvva EkacittIbhUya Izvaramuddizya prOccairEtat prArthayanta, hE prabhO gagaNapRthivIpayOdhInAM tESu ca yadyad AstE tESAM sraSTEzvarastvaM| ");
INSERT INTO sancol_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","tvaM nijasEvakEna dAyUdA vAkyamidam uvacitha, manuSyA anyadEzIyAH kurvvanti kalahaM kutaH| lOkAH sarvvE kimarthaM vA cintAM kurvvanti niSphalAM| ");
INSERT INTO sancol_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","paramEzasya tEnaivAbhiSiktasya janasya ca| viruddhamabhitiSThanti pRthivyAH patayaH kutaH|| ");
INSERT INTO sancol_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","phalatastava hastEna mantraNayA ca pUrvva yadyat sthirIkRtaM tad yathA siddhaM bhavati tadarthaM tvaM yam athiSiktavAn sa Eva pavitrO yIzustasya prAtikUlyEna hErOd pantIyapIlAtO ");
INSERT INTO sancol_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","'nyadEzIyalOkA isrAyEllOkAzca sarvva EtE sabhAyAm atiSThan| ");
INSERT INTO sancol_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","hE paramEzvara adhunA tESAM tarjanaM garjananjca zRNu; ");
INSERT INTO sancol_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","tathA svAsthyakaraNakarmmaNA tava bAhubalaprakAzapUrvvakaM tava sEvakAn nirbhayEna tava vAkyaM pracArayituM tava pavitraputrasya yIzO rnAmnA AzcaryyANyasambhavAni ca karmmANi karttunjcAjnjApaya| ");
INSERT INTO sancol_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","itthaM prArthanayA yatra sthAnE tE sabhAyAm Asan tat sthAnaM prAkampata; tataH sarvvE pavitrENAtmanA paripUrNAH santa Izvarasya kathAm akSObhENa prAcArayan| ");
INSERT INTO sancol_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","aparanjca pratyayakArilOkasamUhA Ekamanasa EkacittIbhUya sthitAH| tESAM kEpi nijasampattiM svIyAM nAjAnan kintu tESAM sarvvAH sampattyaH sAdhAraNyEna sthitAH| ");
INSERT INTO sancol_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","anyacca prEritA mahAzaktiprakAzapUrvvakaM prabhO ryIzOrutthAnE sAkSyam adaduH, tESu sarvvESu mahAnugrahO'bhavacca| ");
INSERT INTO sancol_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","tESAM madhyE kasyApi dravyanyUnatA nAbhavad yatastESAM gRhabhUmyAdyA yAH sampattaya Asan tA vikrIya ");
INSERT INTO sancol_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","tanmUlyamAnIya prEritAnAM caraNESu taiH sthApitaM; tataH pratyEkazaH prayOjanAnusArENa dattamabhavat| ");
INSERT INTO sancol_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","vizESataH kuprOpadvIpIyO yOsinAmakO lEvivaMzajAta EkO janO bhUmyadhikArI, yaM prEritA barNabbA arthAt sAntvanAdAyaka ityuktvA samAhUyan, ");
INSERT INTO sancol_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","sa janO nijabhUmiM vikrIya tanmUlyamAnIya prEritAnAM caraNESu sthApitavAn| ");
INSERT INTO sancol_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","tadA anAniyanAmaka EkO janO yasya bhAryyAyA nAma saphIrA sa svAdhikAraM vikrIya ");
INSERT INTO sancol_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","svabhAryyAM jnjApayitvA tanmUlyasyaikAMzaM saggOpya sthApayitvA tadanyAMzamAtramAnIya prEritAnAM caraNESu samarpitavAn| ");
INSERT INTO sancol_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","tasmAt pitarOkathayat hE anAniya bhUmE rmUlyaM kinjcit saggOpya sthApayituM pavitrasyAtmanaH sannidhau mRSAvAkyaM kathayitunjca zaitAn kutastavAntaHkaraNE pravRttimajanayat? ");
INSERT INTO sancol_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","sA bhUmi ryadA tava hastagatA tadA kiM tava svIyA nAsIt? tarhi svAntaHkaraNE kuta EtAdRzI kukalpanA tvayA kRtA? tvaM kEvalamanuSyasya nikaTE mRSAvAkyaM nAvAdIH kintvIzvarasya nikaTE'pi| ");
INSERT INTO sancol_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","EtAM kathAM zrutvaiva sO'nAniyO bhUmau patan prANAn atyajat, tadvRttAntaM yAvantO lOkA azRNvan tESAM sarvvESAM mahAbhayam ajAyat| ");
INSERT INTO sancol_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","tadA yuvalOkAstaM vastrENAcchAdya bahi rnItvA zmazAnE'sthApayan| ");
INSERT INTO sancol_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","tataH praharaikAnantaraM kiM vRttaM tannAvagatya tasya bhAryyApi tatra samupasthitA| ");
INSERT INTO sancol_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","tataH pitarastAm apRcchat, yuvAbhyAm EtAvanmudrAbhyO bhUmi rvikrItA na vA? EtatvaM vada; tadA sA pratyavAdIt satyam EtAvadbhyO mudrAbhya Eva| ");
INSERT INTO sancol_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","tataH pitarOkathayat yuvAM kathaM paramEzvarasyAtmAnaM parIkSitum EkamantraNAvabhavatAM? pazya yE tava patiM zmazAnE sthApitavantastE dvArasya samIpE samupatiSThanti tvAmapi bahirnESyanti| ");
INSERT INTO sancol_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","tataH sApi tasya caraNasannidhau patitvA prANAn atyAkSIt| pazcAt tE yuvAnO'bhyantaram Agatya tAmapi mRtAM dRSTvA bahi rnItvA tasyAH patyuH pArzvE zmazAnE sthApitavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","tasmAt maNPalyAH sarvvE lOkA anyalOkAzca tAM vArttAM zrutvA sAdhvasaM gatAH| ");
INSERT INTO sancol_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","tataH paraM prEritAnAM hastai rlOkAnAM madhyE bahvAzcaryyANyadbhutAni karmmANyakriyanta; tadA ziSyAH sarvva EkacittIbhUya sulEmAnO 'lindE sambhUyAsan| ");
INSERT INTO sancol_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","tESAM sagghAntargO bhavituM kOpi pragalbhatAM nAgamat kintu lOkAstAn samAdriyanta| ");
INSERT INTO sancol_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","striyaH puruSAzca bahavO lOkA vizvAsya prabhuM zaraNamApannAH| ");
INSERT INTO sancol_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","pitarasya gamanAgamanAbhyAM kEnApi prakArENa tasya chAyA kasmiMzcijjanE lagiSyatItyAzayA lOkA rOgiNaH zivikayA khaTvayA cAnIya pathi pathi sthApitavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","caturdiksthanagarEbhyO bahavO lOkAH sambhUya rOgiNO'pavitrabhutagrastAMzca yirUzAlamam Anayan tataH sarvvE svasthA akriyanta| ");
INSERT INTO sancol_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","anantaraM mahAyAjakaH sidUkinAM matagrAhiNastESAM sahacarAzca ");
INSERT INTO sancol_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","mahAkrOdhAntvitAH santaH prEritAn dhRtvA nIcalOkAnAM kArAyAM baddhvA sthApitavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","kintu rAtrau paramEzvarasya dUtaH kArAyA dvAraM mOcayitvA tAn bahirAnIyAkathayat, ");
INSERT INTO sancol_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","yUyaM gatvA mandirE daNPAyamAnAH santO lOkAn pratImAM jIvanadAyikAM sarvvAM kathAM pracArayata| ");
INSERT INTO sancol_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","iti zrutvA tE pratyUSE mandira upasthAya upadiSTavantaH| tadA sahacaragaNEna sahitO mahAyAjaka Agatya mantrigaNam isrAyElvaMzasya sarvvAn rAjasabhAsadaH sabhAsthAn kRtvA kArAyAstAn ApayituM padAtigaNaM prEritavAn| ");
INSERT INTO sancol_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","tatastE gatvA kArAyAM tAn aprApya pratyAgatya iti vArttAm avAdiSuH, ");
INSERT INTO sancol_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","vayaM tatra gatvA nirvvighnaM kArAyA dvAraM ruddhaM rakSakAMzca dvArasya bahirdaNPAyamAnAn adarzAma Eva kintu dvAraM mOcayitvA tanmadhyE kamapi draSTuM na prAptAH| ");
INSERT INTO sancol_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","EtAM kathAM zrutvA mahAyAjakO mandirasya sEnApatiH pradhAnayAjakAzca, ita paraM kimaparaM bhaviSyatIti cintayitvA sandigdhacittA abhavan| ");
INSERT INTO sancol_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","EtasminnEva samayE kazcit jana Agatya vArttAmEtAm avadat pazyata yUyaM yAn mAnavAn kArAyAm asthApayata tE mandirE tiSThantO lOkAn upadizanti| ");
INSERT INTO sancol_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","tadA mandirasya sEnApatiH padAtayazca tatra gatvA cEllOkAH pASANAn nikSipyAsmAn mArayantIti bhiyA vinatyAcAraM tAn Anayan| ");
INSERT INTO sancol_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","tE mahAsabhAyA madhyE tAn asthApayan tataH paraM mahAyAjakastAn apRcchat, ");
INSERT INTO sancol_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","anEna nAmnA samupadESTuM vayaM kiM dRPhaM na nyaSEdhAma? tathApi pazyata yUyaM svESAM tEnOpadEzEnE yirUzAlamaM paripUrNaM kRtvA tasya janasya raktapAtajanitAparAdham asmAn pratyAnEtuM cESTadhvE| ");
INSERT INTO sancol_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","tataH pitarOnyaprEritAzca pratyavadan mAnuSasyAjnjAgrahaNAd IzvarasyAjnjAgrahaNam asmAkamucitam| ");
INSERT INTO sancol_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","yaM yIzuM yUyaM kruzE vEdhitvAhata tam asmAkaM paitRka Izvara utthApya ");
INSERT INTO sancol_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","isrAyElvaMzAnAM manaHparivarttanaM pApakSamAnjca karttuM rAjAnaM paritrAtAranjca kRtvA svadakSiNapArzvE tasyAnnatim akarOt| ");
INSERT INTO sancol_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Etasmin vayamapi sAkSiNa AsmahE, tat kEvalaM nahi, Izvara AjnjAgrAhibhyO yaM pavitram AtmanaM dattavAn sOpi sAkSyasti| ");
INSERT INTO sancol_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","EtadvAkyE zrutE tESAM hRdayAni viddhAnyabhavan tatastE tAn hantuM mantritavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","EtasminnEva samayE tatsabhAsthAnAM sarvvalOkAnAM madhyE sukhyAtO gamilIyElnAmaka EkO janO vyavasthApakaH phirUzilOka utthAya prEritAn kSaNArthaM sthAnAntaraM gantum Adizya kathitavAn, ");
INSERT INTO sancol_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","hE isrAyElvaMzIyAH sarvvE yUyam EtAn mAnuSAn prati yat karttum udyatAstasmin sAvadhAnA bhavata| ");
INSERT INTO sancol_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","itaH pUrvvaM thUdAnAmaikO jana upasthAya svaM kamapi mahApuruSam avadat, tataH prAyENa catuHzatalOkAstasya matagrAhiNObhavan pazcAt sa hatObhavat tasyAjnjAgrAhiNO yAvantO lOkAstE sarvvE virkIrNAH santO 'kRtakAryyA abhavan| ");
INSERT INTO sancol_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","tasmAjjanAt paraM nAmalEkhanasamayE gAlIlIyayihUdAnAmaikO jana upasthAya bahUllOkAn svamataM grAhItavAn tataH sOpi vyanazyat tasyAjnjAgrAhiNO yAvantO lOkA Asan tE sarvvE vikIrNA abhavan| ");
INSERT INTO sancol_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","adhunA vadAmi, yUyam EtAn manuSyAn prati kimapi na kRtvA kSAntA bhavata, yata ESa sagkalpa Etat karmma ca yadi manuSyAdabhavat tarhi viphalaM bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","yadIzvarAdabhavat tarhi yUyaM tasyAnyathA karttuM na zakSyatha, varam IzvararOdhakA bhaviSyatha| ");
INSERT INTO sancol_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","tadA tasya mantraNAM svIkRtya tE prEritAn AhUya prahRtya yIzO rnAmnA kAmapi kathAM kathayituM niSidhya vyasarjan| ");
INSERT INTO sancol_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","kintu tasya nAmArthaM vayaM lajjAbhOgasya yOgyatvEna gaNitA ityatra tE sAnandAH santaH sabhAsthAnAM sAkSAd agacchan| ");
INSERT INTO sancol_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","tataH paraM pratidinaM mandirE gRhE gRhE cAvizrAmam upadizya yIzukhrISTasya susaMvAdaM pracAritavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","tasmin samayE ziSyANAM bAhulyAt prAtyahikadAnasya vizrANanai rbhinnadEzIyAnAM vidhavAstrIgaNa upEkSitE sati ibrIyalOkaiH sahAnyadEzIyAnAM vivAda upAtiSThat| ");
INSERT INTO sancol_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","tadA dvAdazaprEritAH sarvvAn ziSyAn saMgRhyAkathayan Izvarasya kathApracAraM parityajya bhOjanagavESaNam asmAkam ucitaM nahi| ");
INSERT INTO sancol_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","atO hE bhrAtRgaNa vayam EtatkarmmaNO bhAraM yEbhyO dAtuM zaknuma EtAdRzAn sukhyAtyApannAn pavitrENAtmanA jnjAnEna ca pUrNAn sapprajanAn yUyaM svESAM madhyE manOnItAn kuruta, ");
INSERT INTO sancol_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","kintu vayaM prArthanAyAM kathApracArakarmmaNi ca nityapravRttAH sthAsyAmaH| ");
INSERT INTO sancol_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","EtasyAM kathAyAM sarvvE lOkAH santuSTAH santaH svESAM madhyAt stiphAnaH philipaH prakharO nikAnOr tIman parmmiNA yihUdimatagrAhI-AntiyakhiyAnagarIyO nikalA EtAn paramabhaktAn pavitrENAtmanA paripUrNAn sapta janAn ");
INSERT INTO sancol_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","prEritAnAM samakSam Anayan, tatastE prArthanAM kRtvA tESAM ziraHsu hastAn Arpayan| ");
INSERT INTO sancol_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","aparanjca Izvarasya kathA dEzaM vyApnOt vizESatO yirUzAlami nagarE ziSyANAM saMkhyA prabhUtarUpENAvarddhata yAjakAnAM madhyEpi bahavaH khrISTamatagrAhiNO'bhavan| ");
INSERT INTO sancol_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","stiphAnOे vizvAsEna parAkramENa ca paripUrNaH san lOkAnAM madhyE bahuvidham adbhutam AzcaryyaM karmmAkarOt| ");
INSERT INTO sancol_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","tEna libarttinIyanAmnA vikhyAtasagghasya katipayajanAH kurINIyasikandarIya-kilikIyAzIyAdEzIyAH kiyantO janAzcOtthAya stiphAnEna sArddhaM vyavadanta| ");
INSERT INTO sancol_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","kintu stiphAnO jnjAnEna pavitrENAtmanA ca IdRzIM kathAM kathitavAn yasyAstE ApattiM karttuM nAzaknuvan| ");
INSERT INTO sancol_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","pazcAt tai rlObhitAH katipayajanAH kathAmEnAm akathayan, vayaM tasya mukhatO mUsA Izvarasya ca nindAvAkyam azrauSma| ");
INSERT INTO sancol_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","tE lOkAnAM lOkaprAcInAnAm adhyApakAnAnjca pravRttiM janayitvA stiphAnasya sannidhim Agatya taM dhRtvA mahAsabhAmadhyam Anayan| ");
INSERT INTO sancol_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","tadanantaraM katipayajanESu mithyAsAkSiSu samAnItESu tE'kathayan ESa jana EtatpuNyasthAnavyavasthayO rnindAtaH kadApi na nivarttatE| ");
INSERT INTO sancol_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","phalatO nAsaratIyayIzuH sthAnamEtad ucchinnaM kariSyati mUsAsamarpitam asmAkaM vyavaharaNam anyarUpaM kariSyati tasyaitAdRzIM kathAM vayam azRNuma| ");
INSERT INTO sancol_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","tadA mahAsabhAsthAH sarvvE taM prati sthirAM dRSTiM kRtvA svargadUtamukhasadRzaM tasya mukham apazyan| ");
INSERT INTO sancol_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","tataH paraM mahAyAjakaH pRSTavAn, ESA kathAM kiM satyA? ");
INSERT INTO sancol_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","tataH sa pratyavadat, hE pitarO hE bhrAtaraH sarvvE lAkA manAMsi nidhaddhvaM|asmAkaM pUrvvapuruSa ibrAhIm hAraNnagarE vAsakaraNAt pUrvvaM yadA arAm-naharayimadEzE AsIt tadA tEjOmaya IzvarO darzanaM datvA ");
INSERT INTO sancol_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","tamavadat tvaM svadEzajnjAtimitrANi parityajya yaM dEzamahaM darzayiSyAmi taM dEzaM vraja| ");
INSERT INTO sancol_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","ataH sa kasdIyadEzaM vihAya hAraNnagarE nyavasat, tadanantaraM tasya pitari mRtE yatra dEzE yUyaM nivasatha sa EnaM dEzamAgacchat| ");
INSERT INTO sancol_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","kintvIzvarastasmai kamapyadhikAram arthAd EkapadaparimitAM bhUmimapi nAdadAt; tadA tasya kOpi santAnO nAsIt tathApi santAnaiH sArddham Etasya dEzasyAdhikArI tvaM bhaviSyasIti tampratyaggIkRtavAn| ");
INSERT INTO sancol_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Izvara ittham aparamapi kathitavAn tava santAnAH paradEzE nivatsyanti tatastaddEzIyalOkAzcatuHzatavatsarAn yAvat tAn dAsatvE sthApayitvA tAn prati kuvyavahAraM kariSyanti| ");
INSERT INTO sancol_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","aparam Izvara EnAM kathAmapi kathitavAn, yE lOkAstAn dAsatvE sthApayiSyanti tAllOkAn ahaM daNPayiSyAmi, tataH paraM tE bahirgatAH santO mAm atra sthAnE sEviSyantE| ");
INSERT INTO sancol_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","pazcAt sa tasmai tvakchEdasya niyamaM dattavAn, ata ishAkanAmni ibrAhIma EkaputrE jAtE, aSTamadinE tasya tvakchEdam akarOt| tasya ishAkaH putrO yAkUb, tatastasya yAkUbO'smAkaM dvAdaza pUrvvapuruSA ajAyanta| ");
INSERT INTO sancol_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","tE pUrvvapuruSA IrSyayA paripUrNA misaradEzaM prESayituM yUSaphaM vyakrINan| ");
INSERT INTO sancol_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","kintvIzvarastasya sahAyO bhUtvA sarvvasyA durgatE rakSitvA tasmai buddhiM dattvA misaradEzasya rAjnjaH phirauNaH priyapAtraM kRtavAn tatO rAjA misaradEzasya svIyasarvvaparivArasya ca zAsanapadaM tasmai dattavAn| ");
INSERT INTO sancol_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","tasmin samayE misara-kinAnadEzayO rdurbhikSahEtOratikliSTatvAt naH pUrvvapuruSA bhakSyadravyaM nAlabhanta| ");
INSERT INTO sancol_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","kintu misaradEzE zasyAni santi, yAkUb imAM vArttAM zrutvA prathamam asmAkaM pUrvvapuruSAn misaraM prESitavAn| ");
INSERT INTO sancol_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","tatO dvitIyavAragamanE yUSaph svabhrAtRbhiH paricitO'bhavat; yUSaphO bhrAtaraH phirauN rAjEna paricitA abhavan| ");
INSERT INTO sancol_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","anantaraM yUSaph bhrAtRgaNaM prESya nijapitaraM yAkUbaM nijAn panjcAdhikasaptatisaMkhyakAn jnjAtijanAMzca samAhUtavAn| ");
INSERT INTO sancol_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","tasmAd yAkUb misaradEzaM gatvA svayam asmAkaM pUrvvapuruSAzca tasmin sthAnE'mriyanta| ");
INSERT INTO sancol_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","tatastE zikhimaM nItA yat zmazAnam ibrAhIm mudrAdatvA zikhimaH pitu rhamOraH putrEbhyaH krItavAn tatzmazAnE sthApayAnjcakrirE| ");
INSERT INTO sancol_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","tataH param Izvara ibrAhImaH sannidhau zapathaM kRtvA yAM pratijnjAM kRtavAn tasyAH pratijnjAyAH phalanasamayE nikaTE sati isrAyEllOkA simaradEzE varddhamAnA bahusaMkhyA abhavan| ");
INSERT INTO sancol_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","zESE yUSaphaM yO na paricinOti tAdRza EkO narapatirupasthAya ");
INSERT INTO sancol_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","asmAkaM jnjAtibhiH sArddhaM dhUrttatAM vidhAya pUrvvapuruSAn prati kuvyavaharaNapUrvvakaM tESAM vaMzanAzanAya tESAM navajAtAn zizUn bahi rnirakSEpayat| ");
INSERT INTO sancol_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Etasmin samayE mUsA jajnjE, sa tu paramasundarO'bhavat tathA pitRgRhE mAsatrayaparyyantaM pAlitO'bhavat| ");
INSERT INTO sancol_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","kintu tasmin bahirnikSiptE sati phirauNarAjasya kanyA tam uttOlya nItvA dattakaputraM kRtvA pAlitavatI| ");
INSERT INTO sancol_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","tasmAt sa mUsA misaradEzIyAyAH sarvvavidyAyAH pAradRSvA san vAkyE kriyAyAnjca zaktimAn abhavat| ");
INSERT INTO sancol_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","sa sampUrNacatvAriMzadvatsaravayaskO bhUtvA isrAyElIyavaMzanijabhrAtRn sAkSAt kartuM matiM cakrE| ");
INSERT INTO sancol_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","tESAM janamEkaM hiMsitaM dRSTvA tasya sapakSaH san hiMsitajanam upakRtya misarIyajanaM jaghAna| ");
INSERT INTO sancol_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","tasya hastEnEzvarastAn uddhariSyati tasya bhrAtRgaNa iti jnjAsyati sa ityanumAnaM cakAra, kintu tE na bubudhirE| ");
INSERT INTO sancol_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","tatparE 'hani tESAm ubhayO rjanayO rvAkkalaha upasthitE sati mUsAH samIpaM gatvA tayO rmElanaM karttuM matiM kRtvA kathayAmAsa, hE mahAzayau yuvAM bhrAtarau parasparam anyAyaM kutaH kuruthaH? ");
INSERT INTO sancol_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","tataH samIpavAsinaM prati yO janO'nyAyaM cakAra sa taM dUrIkRtya kathayAmAsa, asmAkamupari zAstRtvavicArayitRtvapadayOH kastvAM niyuktavAn? ");
INSERT INTO sancol_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","hyO yathA misarIyaM hatavAn tathA kiM mAmapi haniSyasi? ");
INSERT INTO sancol_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","tadA mUsA EtAdRzIM kathAM zrutvA palAyanaM cakrE, tatO midiyanadEzaM gatvA pravAsI san tasthau, tatastatra dvau putrau jajnjAtE| ");
INSERT INTO sancol_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","anantaraM catvAriMzadvatsarESu gatESu sInayaparvvatasya prAntarE prajvalitastambasya vahnizikhAyAM paramEzvaradUtastasmai darzanaM dadau| ");
INSERT INTO sancol_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","mUsAstasmin darzanE vismayaM matvA vizESaM jnjAtuM nikaTaM gacchati, ");
INSERT INTO sancol_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Etasmin samayE, ahaM tava pUrvvapuruSANAm IzvarO'rthAd ibrAhIma Izvara ishAka IzvarO yAkUba Izvarazca, mUsAmuddizya paramEzvarasyaitAdRzI vihAyasIyA vANI babhUva, tataH sa kampAnvitaH san puna rnirIkSituM pragalbhO na babhUva| ");
INSERT INTO sancol_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","paramEzvarastaM jagAda, tava pAdayOH pAdukE mOcaya yatra tiSThasi sA pavitrabhUmiH| ");
INSERT INTO sancol_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ahaM misaradEzasthAnAM nijalOkAnAM durddazAM nitAntam apazyaM, tESAM kAtaryyOktinjca zrutavAn tasmAt tAn uddharttum avaruhyAgamam; idAnIm Agaccha misaradEzaM tvAM prESayAmi| ");
INSERT INTO sancol_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","kastvAM zAstRtvavicArayitRtvapadayO rniyuktavAn, iti vAkyamuktvA tai ryO mUsA avajnjAtastamEva IzvaraH stambamadhyE darzanadAtrA tEna dUtEna zAstAraM muktidAtAranjca kRtvA prESayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","sa ca misaradEzE sUphnAmni samudrE ca pazcAt catvAriMzadvatsarAn yAvat mahAprAntarE nAnAprakArANyadbhutAni karmmANi lakSaNAni ca darzayitvA tAn bahiH kRtvA samAninAya| ");
INSERT INTO sancol_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","prabhuH paramEzvarO yuSmAkaM bhrAtRgaNasya madhyE mAdRzam EkaM bhaviSyadvaktAram utpAdayiSyati tasya kathAyAM yUyaM manO nidhAsyatha, yO jana isrAyElaH santAnEbhya EnAM kathAM kathayAmAsa sa ESa mUsAH| ");
INSERT INTO sancol_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","mahAprAntarasthamaNPalImadhyE'pi sa Eva sInayaparvvatOpari tEna sArddhaM saMlApinO dUtasya cAsmatpitRgaNasya madhyasthaH san asmabhyaM dAtavyani jIvanadAyakAni vAkyAni lEbhE| ");
INSERT INTO sancol_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","asmAkaM pUrvvapuruSAstam amAnyaM katvA svEbhyO dUrIkRtya misaradEzaM parAvRtya gantuM manObhirabhilaSya hArONaM jagaduH, ");
INSERT INTO sancol_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","asmAkam agrE'grE gantuुm asmadarthaM dEvagaNaM nirmmAhi yatO yO mUsA asmAn misaradEzAd bahiH kRtvAnItavAn tasya kiM jAtaM tadasmAbhi rna jnjAyatE| ");
INSERT INTO sancol_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","tasmin samayE tE gOvatsAkRtiM pratimAM nirmmAya tAmuddizya naivEdyamutmRjya svahastakRtavastunA AnanditavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","tasmAd IzvarastESAM prati vimukhaH san AkAzasthaM jyOtirgaNaM pUjayituM tEbhyO'numatiM dadau, yAdRzaM bhaviSyadvAdinAM granthESu likhitamAstE, yathA, isrAyElIyavaMzA rE catvAriMzatsamAn purA| mahati prAntarE saMsthA yUyantu yAni ca| balihOmAdikarmmANi kRtavantastu tAni kiM| mAM samuddizya yuSmAbhiH prakRtAnIti naiva ca| ");
INSERT INTO sancol_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","kintu vO mOlakAkhyasya dEvasya dUSyamEva ca| yuSmAkaM rimphanAkhyAyA dEvatAyAzca tArakA| EtayOrubhayO rmUrtI yuSmAbhiH paripUjitE| atO yuSmAMstu bAbElaH pAraM nESyAmi nizcitaM| ");
INSERT INTO sancol_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","aparanjca yannidarzanam apazyastadanusArENa dUSyaM nirmmAhi yasmin IzvarO mUsAm EtadvAkyaM babhASE tat tasya nirUpitaM sAkSyasvarUpaM dUSyam asmAkaM pUrvvapuruSaiH saha prAntarE tasthau| ");
INSERT INTO sancol_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","pazcAt yihOzUyEna sahitaistESAM vaMzajAtairasmatpUrvvapuruSaiH svESAM sammukhAd IzvarENa dUrIkRtAnAm anyadEzIyAnAM dEzAdhikRtikAlE samAnItaM tad dUSyaM dAyUdOdhikAraM yAvat tatra sthAna AsIt| ");
INSERT INTO sancol_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","sa dAyUd paramEzvarasyAnugrahaM prApya yAkUb IzvarArtham EkaM dUSyaM nirmmAtuM vavAnjcha; ");
INSERT INTO sancol_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","kintu sulEmAn tadarthaM mandiram EkaM nirmmitavAn| ");
INSERT INTO sancol_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","tathApi yaH sarvvOparisthaH sa kasmiMzcid hastakRtE mandirE nivasatIti nahi, bhaviSyadvAdI kathAmEtAM kathayati, yathA, ");
INSERT INTO sancol_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","parEzO vadati svargO rAjasiMhAsanaM mama| madIyaM pAdapIThanjca pRthivI bhavati dhruvaM| tarhi yUyaM kRtE mE kiM pranirmmAsyatha mandiraM| vizrAmAya madIyaM vA sthAnaM kiM vidyatE tviha| ");
INSERT INTO sancol_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","sarvvANyEtAni vastUni kiM mE hastakRtAni na|| ");
INSERT INTO sancol_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","hE anAjnjAgrAhakA antaHkaraNE zravaNE cApavitralOkAH yUyam anavarataM pavitrasyAtmanaH prAtikUlyam Acaratha, yuSmAkaM pUrvvapuruSA yAdRzA yUyamapi tAdRzAH| ");
INSERT INTO sancol_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","yuSmAkaM pUrvvapuruSAH kaM bhaviSyadvAdinaM nAtAPayan? yE tasya dhArmmikasya janasyAgamanakathAM kathitavantastAn aghnan yUyam adhUnA vizvAsaghAtinO bhUtvA taM dhArmmikaM janam ahata| ");
INSERT INTO sancol_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","yUyaM svargIyadUtagaNEna vyavasthAM prApyApi tAM nAcaratha| ");
INSERT INTO sancol_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","imAM kathAM zrutvA tE manaHsu biddhAH santastaM prati dantagharSaNam akurvvan| ");
INSERT INTO sancol_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","kintu stiphAnaH pavitrENAtmanA pUrNO bhUtvA gagaNaM prati sthiradRSTiM kRtvA Izvarasya dakSiNE daNPAyamAnaM yIzunjca vilOkya kathitavAn; ");
INSERT INTO sancol_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","pazya,mEghadvAraM muktam Izvarasya dakSiNE sthitaM mAnavasutanjca pazyAmi| ");
INSERT INTO sancol_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","tadA tE prOccaiH zabdaM kRtvA karNESvaggulI rnidhAya EkacittIbhUya tam Akraman| ");
INSERT INTO sancol_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","pazcAt taM nagarAd bahiH kRtvA prastarairAghnan sAkSiNO lAkAH zaulanAmnO yUnazcaraNasannidhau nijavastrANi sthApitavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","anantaraM hE prabhO yIzE madIyamAtmAnaM gRhANa stiphAnasyEti prArthanavAkyavadanasamayE tE taM prastarairAghnan| ");
INSERT INTO sancol_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","tasmAt sa jAnunI pAtayitvA prOccaiH zabdaM kRtvA, hE prabhE pApamEtad EtESu mA sthApaya, ityuktvA mahAnidrAM prApnOt| ");
INSERT INTO sancol_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","tasya hatyAkaraNaM zaulOpi samamanyata| tasmin samayE yirUzAlamnagarasthAM maNPalIM prati mahAtAPanAyAM jAtAyAM prEritalOkAn hitvA sarvvE'parE yihUdAzOmirONadEzayO rnAnAsthAnE vikIrNAH santO gatAH| ");
INSERT INTO sancol_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","anyacca bhaktalOkAstaM stiphAnaM zmazAnE sthApayitvA bahu vyalapan| ");
INSERT INTO sancol_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","kintu zaulO gRhE gRhE bhramitvA striyaH puruSAMzca dhRtvA kArAyAM baddhvA maNPalyA mahOtpAtaM kRtavAn| ");
INSERT INTO sancol_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","anyacca yE vikIrNA abhavan tE sarvvatra bhramitvA susaMvAdaM prAcArayan| ");
INSERT INTO sancol_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","tadA philipaH zOmirONnagaraM gatvA khrISTAkhyAnaM prAcArayat; ");
INSERT INTO sancol_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","tatO'zuci-bhRtagrastalOkEbhyO bhUtAzcItkRtyAgacchan tathA bahavaH pakSAghAtinaH khanjjA lOkAzca svasthA abhavan| ");
INSERT INTO sancol_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","tasmAt lAkA IdRzaM tasyAzcaryyaM karmma vilOkya nizamya ca sarvva EkacittIbhUya tEnOktAkhyAnE manAMsi nyadadhuH| ");
INSERT INTO sancol_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","tasminnagarE mahAnandazcAbhavat| ");
INSERT INTO sancol_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","tataH pUrvvaM tasminnagarE zimOnnAmA kazcijjanO bahvI rmAyAkriyAH kRtvA svaM kanjcana mahApuruSaM prOcya zOmirONIyAnAM mOhaM janayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","tasmAt sa mAnuSa Izvarasya mahAzaktisvarUpa ityuktvA bAlavRddhavanitAH sarvvE lAkAstasmin manAMsi nyadadhuH| ");
INSERT INTO sancol_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","sa bahukAlAn mAyAvikriyayA sarvvAn atIva mOhayAnjcakAra, tasmAt tE taM mEnirE| ");
INSERT INTO sancol_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","kintvIzvarasya rAjyasya yIzukhrISTasya nAmnazcAkhyAnapracAriNaH philipasya kathAyAM vizvasya tESAM strIpuruSObhayalOkA majjitA abhavan| ");
INSERT INTO sancol_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","zESE sa zimOnapi svayaM pratyait tatO majjitaH san philipEna kRtAm AzcaryyakriyAM lakSaNanjca vilOkyAsambhavaM manyamAnastEna saha sthitavAn| ");
INSERT INTO sancol_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","itthaM zOmirONdEzIyalOkA Izvarasya kathAm agRhlan iti vArttAM yirUzAlamnagarasthaprEritAH prApya pitaraM yOhananjca tESAM nikaTE prESitavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","tatastau tat sthAnam upasthAya lOkA yathA pavitram AtmAnaM prApnuvanti tadarthaM prArthayEtAM| ");
INSERT INTO sancol_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","yatastE purA kEvalaprabhuyIzO rnAmnA majjitamAtrA abhavan, na tu tESAM madhyE kamapi prati pavitrasyAtmana AvirbhAvO jAtaH| ");
INSERT INTO sancol_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","kintu prEritAbhyAM tESAM gAtrESu karESvarpitESu satsu tE pavitram AtmAnam prApnuvan| ");
INSERT INTO sancol_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","itthaM lOkAnAM gAtrESu prEritayOH karArpaNEna tAn pavitram AtmAnaM prAptAn dRSTvA sa zimOn tayOH samIpE mudrA AnIya kathitavAn; ");
INSERT INTO sancol_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ahaM yasya gAtrE hastam arpayiSyAmi tasyApi yathEtthaM pavitrAtmaprApti rbhavati tAdRzIM zaktiM mahyaM dattaM| ");
INSERT INTO sancol_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","kintu pitarastaM pratyavadat tava mudrAstvayA vinazyantu yata Izvarasya dAnaM mudrAbhiH krIyatE tvamitthaM buddhavAn; ");
INSERT INTO sancol_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","IzvarAya tAvantaHkaraNaM saralaM nahi, tasmAd atra tavAMzO'dhikArazca kOpi nAsti| ");
INSERT INTO sancol_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ata EtatpApahEtOH khEdAnvitaH san kEnApi prakArENa tava manasa EtasyAH kukalpanAyAH kSamA bhavati, Etadartham IzvarE prArthanAM kuru; ");
INSERT INTO sancol_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","yatastvaM tiktapittE pApasya bandhanE ca yadasi tanmayA buddham| ");
INSERT INTO sancol_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","tadA zimOn akathayat tarhi yuvAbhyAmuditA kathA mayi yathA na phalati tadarthaM yuvAM mannimittaM prabhau prArthanAM kurutaM| ");
INSERT INTO sancol_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","anEna prakArENa tau sAkSyaM dattvA prabhOH kathAM pracArayantau zOmirONIyAnAm anEkagrAmESu susaMvAdanjca pracArayantau yirUzAlamnagaraM parAvRtya gatau| ");
INSERT INTO sancol_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","tataH param Izvarasya dUtaH philipam ityAdizat, tvamutthAya dakSiNasyAM dizi yO mArgO prAntarasya madhyEna yirUzAlamO 'sAnagaraM yAti taM mArgaM gaccha| ");
INSERT INTO sancol_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","tataH sa utthAya gatavAn; tadA kandAkInAmnaH kUzlOkAnAM rAjnjyAH sarvvasampattEradhIzaH kUzadEzIya EkaH SaNPO bhajanArthaM yirUzAlamnagaram Agatya ");
INSERT INTO sancol_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","punarapi rathamAruhya yizayiyanAmnO bhaviSyadvAdinO granthaM paThan pratyAgacchati| ");
INSERT INTO sancol_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Etasmin samayE AtmA philipam avadat, tvam rathasya samIpaM gatvA tEna sArddhaM mila| ");
INSERT INTO sancol_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","tasmAt sa dhAvan tasya sannidhAvupasthAya tEna paThyamAnaM yizayiyathaviSyadvAdinO vAkyaM zrutvA pRSTavAn yat paThasi tat kiM budhyasE? ");
INSERT INTO sancol_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","tataH sa kathitavAn kEnacinna bOdhitOhaM kathaM budhyEya? tataH sa philipaM rathamArOPhuM svEna sArddham upavESTunjca nyavEdayat| ");
INSERT INTO sancol_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","sa zAstrasyEtadvAkyaM paThitavAn yathA, samAnIyata ghAtAya sa yathA mESazAvakaH| lOmacchEdakasAkSAcca mESazca nIravO yathA| Abadhya vadanaM svIyaM tathA sa samatiSThata| ");
INSERT INTO sancol_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","anyAyEna vicArENa sa ucchinnO 'bhavat tadA| tatkAlInamanuSyAn kO janO varNayituM kSamaH| yatO jIvannRNAM dEzAt sa ucchinnO 'bhavat dhruvaM| ");
INSERT INTO sancol_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","anantaraM sa philipam avadat nivEdayAmi, bhaviSyadvAdI yAmimAM kathAM kathayAmAsa sa kiM svasmin vA kasmiMzcid anyasmin? ");
INSERT INTO sancol_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","tataH philipastatprakaraNam Arabhya yIzOrupAkhyAnaM tasyAgrE prAstaut| ");
INSERT INTO sancol_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","itthaM mArgENa gacchantau jalAzayasya samIpa upasthitau; tadA klIbO'vAdIt pazyAtra sthAnE jalamAstE mama majjanE kA bAdhA? ");
INSERT INTO sancol_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","tataH philipa uttaraM vyAharat svAntaHkaraNEna sAkaM yadi pratyESi tarhi bAdhA nAsti| tataH sa kathitavAn yIzukhrISTa Izvarasya putra ityahaM pratyEmi| ");
INSERT INTO sancol_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","tadA rathaM sthagitaM karttum AdiSTE philipaklIbau dvau jalam avAruhatAM; tadA philipastam majjayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","tatpazcAt jalamadhyAd utthitayOH satOH paramEzvarasyAtmA philipaM hRtvA nItavAn, tasmAt klIbaH punastaM na dRSTavAn tathApi hRSTacittaH san svamArgENa gatavAn| ");
INSERT INTO sancol_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","philipazcAsdOdnagaram upasthAya tasmAt kaisariyAnagara upasthitikAlaparyyanataM sarvvasminnagarE susaMvAdaM pracArayan gatavAn| ");
INSERT INTO sancol_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","tatkAlaparyyanataM zaulaH prabhOH ziSyANAM prAtikUlyEna tAPanAbadhayOH kathAM niHsArayan mahAyAjakasya sannidhiM gatvA ");
INSERT INTO sancol_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","striyaM puruSanjca tanmatagrAhiNaM yaM kanjcit pazyati tAn dhRtvA baddhvA yirUzAlamam AnayatItyAzayEna dammESaknagarIyaM dharmmasamAjAn prati patraM yAcitavAn| ");
INSERT INTO sancol_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","gacchan tu dammESaknagaranikaTa upasthitavAn; tatO'kasmAd AkAzAt tasya caturdikSu tEjasaH prakAzanAt sa bhUmAvapatat| ");
INSERT INTO sancol_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","pazcAt hE zaula hE zaula kutO mAM tAPayasi? svaM prati prOktam EtaM zabdaM zrutvA ");
INSERT INTO sancol_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","sa pRSTavAn, hE prabhO bhavAn kaH? tadA prabhurakathayat yaM yIzuM tvaM tAPayasi sa EvAhaM; kaNTakasya mukhE padAghAtakaraNaM tava kaSTam| ");
INSERT INTO sancol_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","tadA kampamAnO vismayApannazca sOvadat hE prabhO mayA kiM karttavyaM? bhavata icchA kA? tataH prabhurAjnjApayad utthAya nagaraM gaccha tatra tvayA yat karttavyaM tad vadiSyatE| ");
INSERT INTO sancol_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","tasya sagginO lOkA api taM zabdaM zrutavantaH kintu kamapi na dRSTvA stabdhAH santaH sthitavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","anantaraM zaulO bhUmita utthAya cakSuSI unmIlya kamapi na dRSTavAn| tadA lOkAstasya hastau dhRtvA dammESaknagaram Anayan| ");
INSERT INTO sancol_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","tataH sa dinatrayaM yAvad andhO bhUtvA na bhuktavAn pItavAMzca| ");
INSERT INTO sancol_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","tadanantaraM prabhustaddammESaknagaravAsina Ekasmai ziSyAya darzanaM datvA AhUtavAn hE ananiya| tataH sa pratyavAdIt, hE prabhO pazya zRNOmi| ");
INSERT INTO sancol_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","tadA prabhustamAjnjApayat tvamutthAya saralanAmAnaM mArgaM gatvA yihUdAnivEzanE tArSanagarIyaM zaulanAmAnaM janaM gavESayan pRccha; ");
INSERT INTO sancol_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","pazya sa prArthayatE, tathA ananiyanAmaka EkO janastasya samIpam Agatya tasya gAtrE hastArpaNaM kRtvA dRSTiM dadAtItthaM svapnE dRSTavAn| ");
INSERT INTO sancol_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","tasmAd ananiyaH pratyavadat hE prabhO yirUzAlami pavitralOkAn prati sO'nEkahiMsAM kRtavAn; ");
INSERT INTO sancol_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","atra sthAnE ca yE lOkAstava nAmni prArthayanti tAnapi baddhuM sa pradhAnayAjakEbhyaH zaktiM prAptavAn, imAM kathAm aham anEkESAM mukhEbhyaH zrutavAn| ");
INSERT INTO sancol_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","kintu prabhurakathayat, yAhi bhinnadEzIyalOkAnAM bhUpatInAm isrAyEllOkAnAnjca nikaTE mama nAma pracArayituM sa janO mama manOnItapAtramAstE| ");
INSERT INTO sancol_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","mama nAmanimittanjca tEna kiyAn mahAn klEzO bhOktavya Etat taM darzayiSyAmi| ");
INSERT INTO sancol_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","tatO 'naniyO gatvA gRhaM pravizya tasya gAtrE hastArpraNaM kRtvA kathitavAn, hE bhrAtaH zaula tvaM yathA dRSTiM prApnOSi pavitrENAtmanA paripUrNO bhavasi ca, tadarthaM tavAgamanakAlE yaH prabhuyIzustubhyaM darzanam adadAt sa mAM prESitavAn| ");
INSERT INTO sancol_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ityuktamAtrE tasya cakSurbhyAm mInazalkavad vastuni nirgatE tatkSaNAt sa prasannacakSu rbhUtvA prOtthAya majjitO'bhavat bhuktvA pItvA sabalObhavacca| ");
INSERT INTO sancol_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","tataH paraM zaulaH ziSyaiH saha katipayadivasAn tasmin dammESakanagarE sthitvA'vilambaM ");
INSERT INTO sancol_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","sarvvabhajanabhavanAni gatvA yIzurIzvarasya putra imAM kathAM prAcArayat| ");
INSERT INTO sancol_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","tasmAt sarvvE zrOtArazcamatkRtya kathitavantO yO yirUzAlamnagara EtannAmnA prArthayitRlOkAn vinAzitavAn Evam EtAdRzalOkAn baddhvA pradhAnayAjakanikaTaM nayatItyAzayA EtatsthAnamapyAgacchat saEva kimayaM na bhavati? ");
INSERT INTO sancol_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","kintu zaulaH kramaza utsAhavAn bhUtvA yIzurIzvarENAbhiSiktO jana Etasmin pramANaM datvA dammESak-nivAsiyihUdIyalOkAn niruttarAn akarOt| ");
INSERT INTO sancol_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","itthaM bahutithE kAlE gatE yihUdIyalOkAstaM hantuM mantrayAmAsuH ");
INSERT INTO sancol_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","kintu zaulastESAmEtasyA mantraNAyA vArttAM prAptavAn| tE taM hantuM tu divAnizaM guptAH santO nagarasya dvArE'tiSThan; ");
INSERT INTO sancol_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","tasmAt ziSyAstaM nItvA rAtrau piTakE nidhAya prAcIrENAvArOhayan| ");
INSERT INTO sancol_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","tataH paraM zaulO yirUzAlamaM gatvA ziSyagaNEna sArddhaM sthAtum aihat, kintu sarvvE tasmAdabibhayuH sa ziSya iti ca na pratyayan| ");
INSERT INTO sancol_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","EtasmAd barNabbAstaM gRhItvA prEritAnAM samIpamAnIya mArgamadhyE prabhuH kathaM tasmai darzanaM dattavAn yAH kathAzca kathitavAn sa ca yathAkSObhaH san dammESaknagarE yIzO rnAma prAcArayat EtAn sarvvavRttAntAn tAn jnjApitavAn| ");
INSERT INTO sancol_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","tataH zaulastaiH saha yirUzAlami kAlaM yApayan nirbhayaM prabhO ryIzO rnAma prAcArayat| ");
INSERT INTO sancol_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","tasmAd anyadEzIyalOkaiH sArddhaM vivAdasyOpasthitatvAt tE taM hantum acESTanta| ");
INSERT INTO sancol_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","kintu bhrAtRgaNastajjnjAtvA taM kaisariyAnagaraM nItvA tArSanagaraM prESitavAn| ");
INSERT INTO sancol_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","itthaM sati yihUdiyAgAlIlzOmirONadEzIyAH sarvvA maNPalyO vizrAmaM prAptAstatastAsAM niSThAbhavat prabhO rbhiyA pavitrasyAtmanaH sAntvanayA ca kAlaM kSEpayitvA bahusaMkhyA abhavan| ");
INSERT INTO sancol_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","tataH paraM pitaraH sthAnE sthAnE bhramitvA zESE lOdnagaranivAsipavitralOkAnAM samIpE sthitavAn| ");
INSERT INTO sancol_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","tadA tatra pakSAghAtavyAdhinASTau vatsarAn zayyAgatam ainEyanAmAnaM manuSyaM sAkSat prApya tamavadat, ");
INSERT INTO sancol_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","hE ainEya yIzukhrISTastvAM svastham akArSIt, tvamutthAya svazayyAM nikSipa, ityuktamAtrE sa udatiSThat| ");
INSERT INTO sancol_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","EtAdRzaM dRSTvA lOdzArONanivAsinO lOkAH prabhuM prati parAvarttanta| ");
INSERT INTO sancol_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","aparanjca bhikSAdAnAdiSu nAnakriyAsu nityaM pravRttA yA yAphOnagaranivAsinI TAbithAnAmA ziSyA yAM darkkAM arthAd hariNImayuktvA Ahvayan sA nArI ");
INSERT INTO sancol_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","tasmin samayE rugnA satI prANAn atyajat, tatO lOkAstAM prakSAlyOparisthaprakOSThE zAyayitvAsthApayan| ");
INSERT INTO sancol_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","lOdnagaraM yAphOnagarasya samIpasthaM tasmAttatra pitara AstE, iti vArttAM zrutvA tUrNaM tasyAgamanArthaM tasmin vinayamuktvA ziSyagaNO dvau manujau prESitavAn| ");
INSERT INTO sancol_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","tasmAt pitara utthAya tAbhyAM sArddham Agacchat, tatra tasmin upasthita uparisthaprakOSThaM samAnItE ca vidhavAH svAbhiH saha sthitikAlE darkkayA kRtAni yAnyuttarIyANi paridhEyAni ca tAni sarvvANi taM darzayitvA rudatyazcatasRSu dikSvatiSThan| ");
INSERT INTO sancol_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","kintu pitarastAH sarvvA bahiH kRtvA jAnunI pAtayitvA prArthitavAn; pazcAt zavaM prati dRSTiM kRtvA kathitavAn, hE TAbIthE tvamuttiSTha, iti vAkya uktE sA strI cakSuSI prOnmIlya pitaram avalOkyOtthAyOpAvizat| ");
INSERT INTO sancol_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","tataH pitarastasyAH karau dhRtvA uttOlya pavitralOkAn vidhavAzcAhUya tESAM nikaTE sajIvAM tAM samArpayat| ");
INSERT INTO sancol_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ESA kathA samastayAphOnagaraM vyAptA tasmAd anEkE lOkAH prabhau vyazvasan| ");
INSERT INTO sancol_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","aparanjca pitarastadyAphOnagarIyasya kasyacit zimOnnAmnazcarmmakArasya gRhE bahudinAni nyavasat| ");
INSERT INTO sancol_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","kaisariyAnagara itAliyAkhyasainyAntargataH karNIliyanAmA sEnApatirAsIt ");
INSERT INTO sancol_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","sa saparivArO bhakta IzvaraparAyaNazcAsIt; lOkEbhyO bahUni dAnAdIni datvA nirantaram IzvarE prArthayAnjcakrE| ");
INSERT INTO sancol_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","EkadA tRtIyapraharavElAyAM sa dRSTavAn IzvarasyaikO dUtaH saprakAzaM tatsamIpam Agatya kathitavAn, hE karNIliya| ");
INSERT INTO sancol_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","kintu sa taM dRSTvA bhItO'kathayat, hE prabhO kiM? tadA tamavadat tava prArthanA dAnAdi ca sAkSisvarUpaM bhUtvEzvarasya gOcaramabhavat| ");
INSERT INTO sancol_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","idAnIM yAphOnagaraM prati lOkAn prESya samudratIrE zimOnnAmnazcarmmakArasya gRhE pravAsakArI pitaranAmnA vikhyAtO yaH zimOn tam AhvAyaya; ");
INSERT INTO sancol_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","tasmAt tvayA yadyat karttavyaM tattat sa vadiSyati| ");
INSERT INTO sancol_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ityupadizya dUtE prasthitE sati karNIliyaH svagRhasthAnAM dAsAnAM dvau janau nityaM svasagginAM sainyAnAm EkAM bhaktasEnAnjcAhUya ");
INSERT INTO sancol_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","sakalamEtaM vRttAntaM vijnjApya yAphOnagaraM tAn prAhiNOt| ");
INSERT INTO sancol_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","parasmin dinE tE yAtrAM kRtvA yadA nagarasya samIpa upAtiSThan, tadA pitarO dvitIyapraharavElAyAM prArthayituM gRhapRSTham ArOhat| ");
INSERT INTO sancol_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Etasmin samayE kSudhArttaH san kinjcid bhOktum aicchat kintu tESAm annAsAdanasamayE sa mUrcchitaH sannapatat| ");
INSERT INTO sancol_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","tatO mEghadvAraM muktaM caturbhiH kONai rlambitaM bRhadvastramiva kinjcana bhAjanam AkAzAt pRthivIm avArOhatIti dRSTavAn| ");
INSERT INTO sancol_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","tanmadhyE nAnaprakArA grAmyavanyapazavaH khEcarOrOgAmiprabhRtayO jantavazcAsan| ");
INSERT INTO sancol_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","anantaraM hE pitara utthAya hatvA bhuMkSva tampratIyaM gagaNIyA vANI jAtA| ");
INSERT INTO sancol_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","tadA pitaraH pratyavadat, hE prabhO IdRzaM mA bhavatu, aham Etat kAlaM yAvat niSiddham azuci vA dravyaM kinjcidapi na bhuktavAn| ");
INSERT INTO sancol_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","tataH punarapi tAdRzI vihayasIyA vANI jAtA yad IzvaraH zuci kRtavAn tat tvaM niSiddhaM na jAnIhi| ");
INSERT INTO sancol_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","itthaM triH sati tat pAtraM punarAkRSTaM AkAzam agacchat| ");
INSERT INTO sancol_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","tataH paraM yad darzanaM prAptavAn tasya kO bhAva ityatra pitarO manasA sandEgdhi, Etasmin samayE karNIliyasya tE prESitA manuSyA dvArasya sannidhAvupasthAya, ");
INSERT INTO sancol_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","zimOnO gRhamanvicchantaH sampRchyAhUya kathitavantaH pitaranAmnA vikhyAtO yaH zimOn sa kimatra pravasati? ");
INSERT INTO sancol_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","yadA pitarastaddarzanasya bhAvaM manasAndOlayati tadAtmA tamavadat, pazya trayO janAstvAM mRgayantE| ");
INSERT INTO sancol_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","tvam utthAyAvaruhya niHsandEhaM taiH saha gaccha mayaiva tE prESitAH| ");
INSERT INTO sancol_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","tasmAt pitarO'varuhya karNIliyaprEritalOkAnAM nikaTamAgatya kathitavAn pazyata yUyaM yaM mRgayadhvE sa janOhaM, yUyaM kinnimittam AgatAH? ");
INSERT INTO sancol_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","tatastE pratyavadan karNIliyanAmA zuddhasattva IzvaraparAyaNO yihUdIyadEzasthAnAM sarvvESAM sannidhau sukhyAtyApanna EkaH sEnApati rnijagRhaM tvAmAhUya nEtuM tvattaH kathA zrOtunjca pavitradUtEna samAdiSTaH| ");
INSERT INTO sancol_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","tadA pitarastAnabhyantaraM nItvA tESAmAtithyaM kRtavAn, parE'hani taiH sArddhaM yAtrAmakarOt, yAphOnivAsinAM bhrAtRNAM kiyantO janAzca tEna saha gatAH| ");
INSERT INTO sancol_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","parasmin divasE kaisariyAnagaramadhyapravEzasamayE karNIliyO jnjAtibandhUn AhUyAnIya tAn apEkSya sthitaH| ");
INSERT INTO sancol_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","pitarE gRha upasthitE karNIliyastaM sAkSAtkRtya caraNayOH patitvA prANamat| ");
INSERT INTO sancol_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","pitarastamutthApya kathitavAn, uttiSThAhamapi mAnuSaH| ");
INSERT INTO sancol_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","tadA karNIliyEna sAkam Alapan gRhaM prAvizat tanmadhyE ca bahulOkAnAM samAgamaM dRSTvA tAn avadat, ");
INSERT INTO sancol_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","anyajAtIyalOkaiH mahAlapanaM vA tESAM gRhamadhyE pravEzanaM yihUdIyAnAM niSiddham astIti yUyam avagacchatha; kintu kamapi mAnuSam avyavahAryyam azuciM vA jnjAtuM mama nOcitam iti paramEzvarO mAM jnjApitavAn| ");
INSERT INTO sancol_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","iti hEtOrAhvAnazravaNamAtrAt kAnjcanApattim akRtvA yuSmAkaM samIpam AgatOsmi; pRcchAmi yUyaM kinnimittaM mAm AhUyata? ");
INSERT INTO sancol_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","tadA karNIliyaH kathitavAn, adya catvAri dinAni jAtAni EtAvadvElAM yAvad aham anAhAra Asan tatastRtIyapraharE sati gRhE prArthanasamayE tEjOmayavastrabhRd EkO janO mama samakSaM tiSThan EtAM kathAm akathayat, ");
INSERT INTO sancol_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","hE karNIliya tvadIyA prArthanA Izvarasya karNagOcarIbhUtA tava dAnAdi ca sAkSisvarUpaM bhUtvA tasya dRSTigOcaramabhavat| ");
INSERT INTO sancol_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","atO yAphOnagaraM prati lOkAn prahitya tatra samudratIrE zimOnnAmnaH kasyaciccarmmakArasya gRhE pravAsakArI pitaranAmnA vikhyAtO yaH zimOn tamAhUाyaya; tataH sa Agatya tvAm upadEkSyati| ");
INSERT INTO sancol_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","iti kAraNAt tatkSaNAt tava nikaTE lOkAn prESitavAn, tvamAgatavAn iti bhadraM kRtavAn| IzvarO yAnyAkhyAnAni kathayitum Adizat tAni zrOtuM vayaM sarvvE sAmpratam Izvarasya sAkSAd upasthitAH smaH| ");
INSERT INTO sancol_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","tadA pitara imAM kathAM kathayitum ArabdhavAn, IzvarO manuSyANAm apakSapAtI san ");
INSERT INTO sancol_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","yasya kasyacid dEzasya yO lOkAstasmAdbhItvA satkarmma karOti sa tasya grAhyO bhavati, Etasya nizcayam upalabdhavAnaham| ");
INSERT INTO sancol_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","sarvvESAM prabhu ryO yIzukhrISTastEna Izvara isrAyElvaMzAnAM nikaTE susaMvAdaM prESya sammElanasya yaM saMvAdaM prAcArayat taM saMvAdaM yUyaM zrutavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","yatO yOhanA majjanE pracAritE sati sa gAlIladEzamArabhya samastayihUdIyadEzaM vyApnOt; ");
INSERT INTO sancol_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","phalata IzvarENa pavitrENAtmanA zaktyA cAbhiSiktO nAsaratIyayIzuH sthAnE sthAnE bhraman sukriyAM kurvvan zaitAnA kliSTAn sarvvalOkAn svasthAn akarOt, yata Izvarastasya sahAya AsIt; ");
INSERT INTO sancol_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","vayanjca yihUdIyadEzE yirUzAlamnagarE ca tEna kRtAnAM sarvvESAM karmmaNAM sAkSiNO bhavAmaH| lOkAstaM kruzE viddhvA hatavantaH, ");
INSERT INTO sancol_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","kintu tRtIyadivasE IzvarastamutthApya saprakAzam adarzayat| ");
INSERT INTO sancol_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","sarvvalOkAnAM nikaTa iti na hi, kintu tasmin zmazAnAdutthitE sati tEna sArddhaM bhOjanaM pAnanjca kRtavanta EtAdRzA Izvarasya manOnItAH sAkSiNO yE vayam asmAkaM nikaTE tamadarzayat| ");
INSERT INTO sancol_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","jIvitamRtObhayalOkAnAM vicAraM karttum IzvarO yaM niyuktavAn sa Eva sa janaH, imAM kathAM pracArayituM tasmin pramANaM dAtunjca sO'smAn AjnjApayat| ");
INSERT INTO sancol_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","yastasmin vizvasiti sa tasya nAmnA pApAnmuktO bhaviSyati tasmin sarvvE bhaviSyadvAdinOpi EtAdRzaM sAkSyaM dadati| ");
INSERT INTO sancol_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","pitarasyaitatkathAkathanakAlE sarvvESAM zrOtRNAmupari pavitra AtmAvArOhat| ");
INSERT INTO sancol_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","tataH pitarENa sArddham AgatAstvakchEdinO vizvAsinO lOkA anyadEzIyEbhyaH pavitra Atmani dattE sati ");
INSERT INTO sancol_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","tE nAnAjAtIyabhASAbhiH kathAM kathayanta IzvaraM prazaMsanti, iti dRSTvA zrutvA ca vismayam Apadyanta| ");
INSERT INTO sancol_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","tadA pitaraH kathitavAn, vayamiva yE pavitram AtmAnaM prAptAstESAM jalamajjanaM kiM kOpi niSEddhuM zaknOti? ");
INSERT INTO sancol_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","tataH prabhO rnAmnA majjitA bhavatEti tAnAjnjApayat| anantaraM tE svaiH sArddhaM katipayadinAni sthAtuM prArthayanta| ");
INSERT INTO sancol_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","itthaM bhinnadEzIyalOkA apIzvarasya vAkyam agRhlan imAM vArttAM yihUdIyadEzasthaprEritA bhrAtRgaNazca zrutavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","tataH pitarE yirUzAlamnagaraM gatavati tvakchEdinO lOkAstEna saha vivadamAnA avadan, ");
INSERT INTO sancol_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","tvam atvakchEdilOkAnAM gRhaM gatvA taiH sArddhaM bhuktavAn| ");
INSERT INTO sancol_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","tataH pitara AditaH kramazastatkAryyasya sarvvavRttAntamAkhyAtum ArabdhavAn| ");
INSERT INTO sancol_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","yAphOnagara EkadAhaM prArthayamAnO mUrcchitaH san darzanEna caturSu kONESu lambanamAnaM vRhadvastramiva pAtramEkam AkAzadavaruhya mannikaTam Agacchad apazyam| ");
INSERT INTO sancol_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","pazcAt tad ananyadRSTyA dRSTvA vivicya tasya madhyE nAnAprakArAn grAmyavanyapazUn urOgAmikhEcarAMzca dRSTavAn; ");
INSERT INTO sancol_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","hE pitara tvamutthAya gatvA bhuMkSva mAM sambOdhya kathayantaM zabdamEkaM zrutavAMzca| ");
INSERT INTO sancol_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","tatOhaM pratyavadaM, hE prabhO nEtthaM bhavatu, yataH kinjcana niSiddham azuci dravyaM vA mama mukhamadhyaM kadApi na prAvizat| ");
INSERT INTO sancol_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","aparam IzvarO yat zuci kRtavAn tanniSiddhaM na jAnIhi dvi rmAmpratIdRzI vihAyasIyA vANI jAtA| ");
INSERT INTO sancol_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","triritthaM sati tat sarvvaM punarAkAzam AkRSTaM| ");
INSERT INTO sancol_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","pazcAt kaisariyAnagarAt trayO janA mannikaTaM prESitA yatra nivEzanE sthitOhaM tasmin samayE tatrOpAtiSThan| ");
INSERT INTO sancol_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","tadA niHsandEhaM taiH sArddhaM yAtum AtmA mAmAdiSTavAn; tataH paraM mayA sahaitESu SaPbhrAtRSu gatESu vayaM tasya manujasya gRhaM prAvizAma| ");
INSERT INTO sancol_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","sOsmAkaM nikaTE kathAmEtAm akathayat EkadA dUta EkaH pratyakSIbhUya mama gRhamadhyE tiSTan mAmityAjnjApitavAn, yAphOnagaraM prati lOkAn prahitya pitaranAmnA vikhyAtaM zimOnam AhUyaya; ");
INSERT INTO sancol_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","tatastava tvadIyaparivArANAnjca yEna paritrANaM bhaviSyati tat sa upadEkSyati| ");
INSERT INTO sancol_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","ahaM tAM kathAmutthApya kathitavAn tEna prathamam asmAkam upari yathA pavitra AtmAvarUPhavAn tathA tESAmapyupari samavarUPhavAn| ");
INSERT INTO sancol_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","tEna yOhan jalE majjitavAn iti satyaM kintu yUyaM pavitra Atmani majjitA bhaviSyatha, iti yadvAkyaM prabhuruditavAn tat tadA mayA smRtam| ");
INSERT INTO sancol_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","ataH prabhA yIzukhrISTE pratyayakAriNO yE vayam asmabhyam IzvarO yad dattavAn tat tEbhyO lOkEbhyOpi dattavAn tataH kOhaM? kimaham IzvaraM vArayituM zaknOmi? ");
INSERT INTO sancol_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","kathAmEtAM zruvA tE kSAntA Izvarasya guNAn anukIrttya kathitavantaH, tarhi paramAyuHprAptinimittam IzvarOnyadEzIyalOkEbhyOpi manaHparivarttanarUpaM dAnam adAt| ");
INSERT INTO sancol_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","stiphAnaM prati upadravE ghaTitE yE vikIrNA abhavan tai phainIkIkuprAntiyakhiyAsu bhramitvA kEvalayihUdIyalOkAn vinA kasyApyanyasya samIpa Izvarasya kathAM na prAcArayan| ");
INSERT INTO sancol_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","aparaM tESAM kuprIyAH kurInIyAzca kiyantO janA AntiyakhiyAnagaraM gatvA yUnAnIyalOkAnAM samIpEpi prabhOryIzOH kathAM prAcArayan| ");
INSERT INTO sancol_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","prabhOH karastESAM sahAya AsIt tasmAd anEkE lOkA vizvasya prabhuM prati parAvarttanta| ");
INSERT INTO sancol_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","iti vArttAyAM yirUzAlamasthamaNPalIyalOkAnAM karNagOcarIbhUtAyAm AntiyakhiyAnagaraM gantu tE barNabbAM prairayan| ");
INSERT INTO sancol_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","tatO barNabbAstatra upasthitaH san IzvarasyAnugrahasya phalaM dRSTvA sAnandO jAtaH, ");
INSERT INTO sancol_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","sa svayaM sAdhu rvizvAsEna pavitrENAtmanA ca paripUrNaH san ganOniSTayA prabhAvAsthAM karttuM sarvvAn upadiSTavAn tEna prabhOH ziSyA anEkE babhUvuH| ");
INSERT INTO sancol_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","zESE zaulaM mRgayituM barNabbAstArSanagaraM prasthitavAn| tatra tasyOddEzaM prApya tam AntiyakhiyAnagaram Anayat; ");
INSERT INTO sancol_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","tatastau maNPalIsthalOkaiH sabhAM kRtvA saMvatsaramEkaM yAvad bahulOkAn upAdizatAM; tasmin AntiyakhiyAnagarE ziSyAH prathamaM khrISTIyanAmnA vikhyAtA abhavan| ");
INSERT INTO sancol_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","tataH paraM bhaviSyadvAdigaNE yirUzAlama AntiyakhiyAnagaram AgatE sati ");
INSERT INTO sancol_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","AgAbanAmA tESAmEka utthAya AtmanaH zikSayA sarvvadEzE durbhikSaM bhaviSyatIti jnjApitavAn; tataH klaudiyakaisarasyAdhikArE sati tat pratyakSam abhavat| ");
INSERT INTO sancol_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","tasmAt ziSyA EkaikazaH svasvazaktyanusAratO yihUdIyadEzanivAsinAM bhratRNAM dinayApanArthaM dhanaM prESayituM nizcitya ");
INSERT INTO sancol_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","barNabbAzaulayO rdvArA prAcInalOkAnAM samIpaM tat prESitavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","tasmin samayE hErOd‌rAjO maNPalyAH kiyajjanEbhyO duHkhaM dAtuM prArabhat| ");
INSERT INTO sancol_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","vizESatO yOhanaH sOdaraM yAkUbaM karavAlAghAtEn hatavAn| ");
INSERT INTO sancol_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","tasmAd yihUdIyAH santuSTA abhavan iti vijnjAya sa pitaramapi dharttuM gatavAn| ");
INSERT INTO sancol_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","tadA kiNvazUnyapUpOtsavasamaya upAtiSTat; ata utsavE gatE sati lOkAnAM samakSaM taM bahirAnEyyAmIti manasi sthirIkRtya sa taM dhArayitvA rakSNArtham yESAm EkaikasaMghE catvArO janAH santi tESAM caturNAM rakSakasaMghAnAM samIpE taM samarpya kArAyAM sthApitavAn| ");
INSERT INTO sancol_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","kintuM pitarasya kArAsthitikAraNAt maNPalyA lOkA avizrAmam Izvarasya samIpE prArthayanta| ");
INSERT INTO sancol_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","anantaraM hErOdi taM bahirAnAyituM udyatE sati tasyAM rAtrau pitarO rakSakadvayamadhyasthAnE zRgkhaladvayEna baddhvaH san nidrita AsIt, dauvArikAzca kArAyAH sammukhE tiSThanatO dvAram arakSiSuH| ");
INSERT INTO sancol_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Etasmin samayE paramEzvarasya dUtE samupasthitE kArA dIptimatI jAtA; tataH sa dUtaH pitarasya kukSAvAvAtaM kRtvA taM jAgarayitvA bhASitavAn tUrNamuttiSTha; tatastasya hastasthazRgkhaladvayaM galat patitaM| ");
INSERT INTO sancol_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","sa dUtastamavadat, baddhakaTiH san pAdayOH pAdukE arpaya; tEna tathA kRtE sati dUtastam uktavAn gAtrIyavastraM gAtrE nidhAya mama pazcAd Ehi| ");
INSERT INTO sancol_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","tataH pitarastasya pazcAd vrajana bahiragacchat, kintu dUtEna karmmaitat kRtamiti satyamajnjAtvA svapnadarzanaM jnjAtavAn| ");
INSERT INTO sancol_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","itthaM tau prathamAM dvitIyAnjca kArAM lagghitvA yEna lauhanirmmitadvArENa nagaraM gamyatE tatsamIpaM prApnutAM; tatastasya kavATaM svayaM muktamabhavat tatastau tatsthAnAd bahi rbhUtvA mArgaikasya sImAM yAvad gatau; tatO'kasmAt sa dUtaH pitaraM tyaktavAn| ");
INSERT INTO sancol_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","tadA sa cEtanAM prApya kathitavAn nijadUtaM prahitya paramEzvarO hErOdO hastAd yihUdIyalOkAnAM sarvvAzAyAzca mAM samuddhRtavAn ityahaM nizcayaM jnjAtavAn| ");
INSERT INTO sancol_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","sa vivicya mArkanAmrA vikhyAtasya yOhanO mAtu rmariyamO yasmin gRhE bahavaH sambhUya prArthayanta tannivEzanaM gataH| ");
INSERT INTO sancol_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","pitarENa bahirdvAra AhatE sati rOdAnAmA bAlikA draSTuM gatA| ");
INSERT INTO sancol_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","tataH pitarasya svaraM zruvA sA harSayuktA satI dvAraM na mOcayitvA pitarO dvArE tiSThatIti vArttAM vaktum abhyantaraM dhAvitvA gatavatI| ");
INSERT INTO sancol_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","tE prAvOcan tvamunmattA jAtAsi kintu sA muhurmuhuruktavatI satyamEvaitat| ");
INSERT INTO sancol_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","tadA tE kathitavantastarhi tasya dUtO bhavEt| ");
INSERT INTO sancol_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","pitarO dvAramAhatavAn EtasminnantarE dvAraM mOcayitvA pitaraM dRSTvA vismayaM prAptAH| ");
INSERT INTO sancol_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","tataH pitarO niHzabdaM sthAtuM tAn prati hastEna sagkEtaM kRtvA paramEzvarO yEna prakArENa taM kArAyA uddhRtyAnItavAn tasya vRttAntaM tAnajnjApayat, yUyaM gatvA yAkubaM bhrAtRgaNanjca vArttAmEtAM vadatEtyuktA sthAnAntaraM prasthitavAn| ");
INSERT INTO sancol_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","prabhAtE sati pitaraH kva gata ityatra rakSakANAM madhyE mahAn kalahO jAtaH| ");
INSERT INTO sancol_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","hErOd bahu mRgayitvA tasyOddEzE na prAptE sati rakSakAn saMpRcchya tESAM prANAn hantum AdiSTavAn| ");
INSERT INTO sancol_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","pazcAt sa yihUdIyapradEzAt kaisariyAnagaraM gatvA tatrAvAtiSThat| ");
INSERT INTO sancol_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","sOrasIdOnadEzayO rlOkEbhyO hErOdi yuyutsau sati tE sarvva EkamantraNAH santastasya samIpa upasthAya lvAstanAmAnaM tasya vastragRhAdhIzaM sahAyaM kRtvA hErOdA sArddhaM sandhiM prArthayanta yatastasya rAjnjO dEzEna tESAM dEzIyAnAM bharaNam abhavatM ");
INSERT INTO sancol_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","ataH kutracin nirupitadinE hErOd rAjakIyaM paricchadaM paridhAya siMhAsanE samupavizya tAn prati kathAm uktavAn| ");
INSERT INTO sancol_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","tatO lOkA uccaiHkAraM pratyavadan, ESa manujaravO na hi, IzvarIyaravaH| ");
INSERT INTO sancol_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","tadA hErOd Izvarasya sammAnaM nAkarOt; tasmAddhEtOH paramEzvarasya dUtO haThAt taM prAharat tEnaiva sa kITaiH kSINaH san prANAn ajahAt| kintvIzvarasya kathA dEzaM vyApya prabalAbhavat| tataH paraM barNabbAzaulau yasya karmmaNO bhAraM prApnutAM tAbhyAM tasmin sampAditE sati mArkanAmnA vikhyAtO yO yOhan taM sagginaM kRtvA yirUzAlamnagarAt pratyAgatau| ");
INSERT INTO sancol_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","aparanjca barNabbAH, zimOn yaM nigraM vadanti, kurInIyalUkiyO hErOdA rAjnjA saha kRtavidyAाbhyAsO minahEm, zaulazcaitE yE kiyantO janA bhaviSyadvAdina upadESTArazcAntiyakhiyAnagarasthamaNPalyAm Asan, ");
INSERT INTO sancol_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","tE yadOpavAsaM kRtvEzvaram asEvanta tasmin samayE pavitra AtmA kathitavAn ahaM yasmin karmmaNi barNabbAzailau niyuktavAn tatkarmma karttuM tau pRthak kuruta| ");
INSERT INTO sancol_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","tatastairupavAsaprArthanayOH kRtayOH satOstE tayO rgAtrayO rhastArpaNaM kRtvA tau vyasRjan| ");
INSERT INTO sancol_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","tataH paraM tau pavitrENAtmanA prEritau santau silUkiyAnagaram upasthAya samudrapathEna kuprOpadvIpam agacchatAM| ");
INSERT INTO sancol_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","tataH sAlAmInagaram upasthAya tatra yihUdIyAnAM bhajanabhavanAni gatvEzvarasya kathAM prAcArayatAM; yOhanapi tatsahacarO'bhavat| ");
INSERT INTO sancol_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","itthaM tE tasyOpadvIpasya sarvvatra bhramantaH pAphanagaram upasthitAH; tatra suvivEcakEna sarjiyapaulanAmnA taddEzAdhipatinA saha bhaviSyadvAdinO vEzadhArI baryIzunAmA yO mAyAvI yihUdI AsIt taM sAkSAt prAptavataH| ");
INSERT INTO sancol_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","taddEzAdhipa Izvarasya kathAM zrOtuM vAnjchan paulabarNabbau nyamantrayat| ");
INSERT INTO sancol_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","kintvilumA yaM mAyAvinaM vadanti sa dEzAdhipatiM dharmmamArgAd bahirbhUtaM karttum ayatata| ");
INSERT INTO sancol_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","tasmAt zOlO'rthAt paulaH pavitrENAtmanA paripUrNaH san taM mAyAvinaM pratyananyadRSTiM kRtvAkathayat, ");
INSERT INTO sancol_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","hE narakin dharmmadvESin kauTilyaduSkarmmaparipUrNa, tvaM kiM prabhOH satyapathasya viparyyayakaraNAt kadApi na nivarttiSyasE? ");
INSERT INTO sancol_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","adhunA paramEzvarastava samucitaM kariSyati tEna katipayadinAni tvam andhaH san sUryyamapi na drakSyasi| tatkSaNAd rAtrivad andhakArastasya dRSTim AcchAditavAn; tasmAt tasya hastaM dharttuM sa lOkamanvicchan itastatO bhramaNaM kRtavAn| ");
INSERT INTO sancol_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","EnAM ghaTanAM dRSTvA sa dEzAdhipatiH prabhUpadEzAd vismitya vizvAsaM kRtavAn| ");
INSERT INTO sancol_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","tadanantaraM paulastatsagginau ca pAphanagarAt prOtaM cAlayitvA pamphuliyAdEzasya pargInagaram agacchan kintu yOhan tayOH samIpAd Etya yirUzAlamaM pratyAgacchat| ");
INSERT INTO sancol_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","pazcAt tau pargItO yAtrAM kRtvA pisidiyAdEzasya AntiyakhiyAnagaram upasthAya vizrAmavArE bhajanabhavanaM pravizya samupAvizatAM| ");
INSERT INTO sancol_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","vyavasthAbhaviSyadvAkyayOH paThitayOH satO rhE bhrAtarau lOkAn prati yuvayOH kAcid upadEzakathA yadyasti tarhi tAM vadataM tau prati tasya bhajanabhavanasyAdhipatayaH kathAm EtAM kathayitvA praiSayan| ");
INSERT INTO sancol_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ataH paula uttiSThan hastEna sagkEtaM kurvvan kathitavAn hE isrAyElIyamanuSyA IzvaraparAyaNAH sarvvE lOkA yUyam avadhaddhaM| ");
INSERT INTO sancol_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","EtESAmisrAyEllOkAnAm IzvarO'smAkaM pUrvvaparuSAn manOnItAn katvA gRhItavAn tatO misari dEzE pravasanakAlE tESAmunnatiM kRtvA tasmAt svIyabAhubalEna tAn bahiH kRtvA samAnayat| ");
INSERT INTO sancol_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","catvAriMzadvatsarAn yAvacca mahAprAntarE tESAM bharaNaM kRtvA ");
INSERT INTO sancol_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","kinAndEzAntarvvarttINi saptarAjyAni nAzayitvA guTikApAtEna tESu sarvvadEzESu tEbhyO'dhikAraM dattavAn| ");
INSERT INTO sancol_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","panjcAzadadhikacatuHzatESu vatsarESu gatESu ca zimUyElbhaviSyadvAdiparyyantaM tESAmupari vicArayitRn niyuktavAn| ");
INSERT INTO sancol_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","taizca rAjnji prArthitE, IzvarO binyAmInO vaMzajAtasya kIzaH putraM zaulaM catvAriMzadvarSaparyyantaM tESAmupari rAjAnaM kRtavAn| ");
INSERT INTO sancol_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","pazcAt taM padacyutaM kRtvA yO madiSTakriyAH sarvvAH kariSyati tAdRzaM mama manObhimatam EkaM janaM yizayaH putraM dAyUdaM prAptavAn idaM pramANaM yasmin dAyUdi sa dattavAn taM dAyUdaM tESAmupari rAjatvaM karttum utpAditavAna| ");
INSERT INTO sancol_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","tasya svapratizrutasya vAkyasyAnusArENa isrAyEllOkAnAM nimittaM tESAM manuSyANAM vaMzAd Izvara EkaM yIzuM (trAtAram) udapAdayat| ");
INSERT INTO sancol_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","tasya prakAzanAt pUrvvaM yOhan isrAyEllOkAnAM sannidhau manaHparAvarttanarUpaM majjanaM prAcArayat| ");
INSERT INTO sancol_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","yasya ca karmmaNOे bhAraM praptavAn yOhan tan niSpAdayan EtAM kathAM kathitavAn, yUyaM mAM kaM janaM jAnItha? aham abhiSiktatrAtA nahi, kintu pazyata yasya pAdayOH pAdukayO rbandhanE mOcayitumapi yOgyO na bhavAmi tAdRza EkO janO mama pazcAd upatiSThati| ");
INSERT INTO sancol_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","hE ibrAhImO vaMzajAtA bhrAtarO hE IzvarabhItAH sarvvalOkA yuSmAn prati paritrANasya kathaiSA prEritA| ");
INSERT INTO sancol_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","yirUzAlamnivAsinastESAm adhipatayazca tasya yIzOH paricayaM na prApya prativizrAmavAraM paThyamAnAnAM bhaviSyadvAdikathAnAm abhiprAyam abuddhvA ca tasya vadhEna tAH kathAH saphalA akurvvan| ");
INSERT INTO sancol_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","prANahananasya kamapi hEtum aprApyApi pIlAtasya nikaTE tasya vadhaM prArthayanta| ");
INSERT INTO sancol_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","tasmin yAH kathA likhitAH santi tadanusArENa karmma sampAdya taM kruzAd avatAryya zmazAnE zAyitavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","kintvIzvaraH zmazAnAt tamudasthApayat, ");
INSERT INTO sancol_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","punazca gAlIlapradEzAd yirUzAlamanagaraM tEna sArddhaM yE lOkA Agacchan sa bahudinAni tEbhyO darzanaM dattavAn, atasta idAnIM lOkAn prati tasya sAkSiNaH santi| ");
INSERT INTO sancol_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","asmAkaM pUrvvapuruSANAM samakSam IzvarO yasmin pratijnjAtavAn yathA, tvaM mE putrOsi cAdya tvAM samutthApitavAnaham| ");
INSERT INTO sancol_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","idaM yadvacanaM dvitIyagItE likhitamAstE tad yIzOrutthAnEna tESAM santAnA yE vayam asmAkaM sannidhau tEna pratyakSI kRtaM, yuSmAn imaM susaMvAdaM jnjApayAmi| ");
INSERT INTO sancol_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","paramEzvarENa zmazAnAd utthApitaM tadIyaM zarIraM kadApi na kSESyatE, Etasmin sa svayaM kathitavAn yathA dAyUdaM prati pratijnjAtO yO varastamahaM tubhyaM dAsyAmi| ");
INSERT INTO sancol_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Etadanyasmin gItE'pi kathitavAn| svakIyaM puNyavantaM tvaM kSayituM na ca dAsyasi| ");
INSERT INTO sancol_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","dAyUdA IzvarAbhimatasEvAyai nijAyuSi vyayitE sati sa mahAnidrAM prApya nijaiH pUrvvapuruSaiH saha militaH san akSIyata; ");
INSERT INTO sancol_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","kintu yamIzvaraH zmazAnAd udasthApayat sa nAkSIyata| ");
INSERT INTO sancol_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","atO hE bhrAtaraH, anEna janEna pApamOcanaM bhavatIti yuSmAn prati pracAritam AstE| ");
INSERT INTO sancol_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","phalatO mUsAvyavasthayA yUyaM yEbhyO dOSEbhyO muktA bhavituM na zakSyatha tEbhyaH sarvvadOSEbhya Etasmin janE vizvAsinaH sarvvE muktA bhaviSyantIti yuSmAbhi rjnjAyatAM| ");
INSERT INTO sancol_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","aparanjca| avajnjAkAriNO lOkAzcakSurunmIlya pazyata| tathaivAsambhavaM jnjAtvA syAta yUyaM vilajjitAH| yatO yuSmAsu tiSThatsu kariSyE karmma tAdRzaM| yEnaiva tasya vRttAntE yuSmabhyaM kathitE'pi hi| yUyaM na tantu vRttAntaM pratyESyatha kadAcana|| ");
INSERT INTO sancol_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","yEyaM kathA bhaviSyadvAdinAM granthESu likhitAstE sAvadhAnA bhavata sa kathA yathA yuSmAn prati na ghaTatE| ");
INSERT INTO sancol_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","yihUdIyabhajanabhavanAn nirgatayOstayO rbhinnadEzIyai rvakSyamANA prArthanA kRtA, AgAmini vizrAmavArE'pi kathEyam asmAn prati pracAritA bhavatviti| ");
INSERT INTO sancol_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","sabhAyA bhaggE sati bahavO yihUdIyalOkA yihUdIyamatagrAhiNO bhaktalOkAzca barNabbApaulayOH pazcAd Agacchan, tEna tau taiH saha nAnAkathAH kathayitvEzvarAnugrahAzrayE sthAtuM tAn prAvarttayatAM| ");
INSERT INTO sancol_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","paravizrAmavArE nagarasya prAyENa sarvvE lAkA IzvarIyAM kathAM zrOtuM militAH, ");
INSERT INTO sancol_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","kintu yihUdIyalOkA jananivahaM vilOkya IrSyayA paripUrNAH santO viparItakathAkathanEnEzvaranindayA ca paulEnOktAM kathAM khaNPayituM cESTitavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","tataH pauैlabarNabbAvakSObhau kathitavantau prathamaM yuSmAkaM sannidhAvIzvarIyakathAyAH pracAraNam ucitamAsIt kintuM tadagrAhyatvakaraNEna yUyaM svAn anantAyuSO'yOgyAn darzayatha, EtatkAraNAd vayam anyadEzIyalOkAnAM samIpaM gacchAmaH| ");
INSERT INTO sancol_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","prabhurasmAn ittham AdiSTavAn yathA, yAvacca jagataH sImAM lOkAnAM trANakAraNAt| mayAnyadEzamadhyE tvaM sthApitO bhUH pradIpavat|| ");
INSERT INTO sancol_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","tadA kathAmIdRzIM zrutvA bhinnadEzIyA AhlAditAH santaH prabhOH kathAM dhanyAM dhanyAm avadan, yAvantO lOkAzca paramAyuH prAptinimittaM nirUpitA Asan tEे vyazvasan| ");
INSERT INTO sancol_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","itthaM prabhOH kathA sarvvEdEzaM vyApnOt| ");
INSERT INTO sancol_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","kintu yihUdIyA nagarasya pradhAnapuruSAn sammAnyAH kathipayA bhaktA yOSitazca kupravRttiM grAhayitvA paulabarNabbau tAPayitvA tasmAt pradEzAd dUrIkRtavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","ataH kAraNAt tau nijapadadhUlIstESAM prAtikUlyEna pAtayitvEेkaniyaM nagaraM gatau| ");
INSERT INTO sancol_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","tataH ziSyagaNa AnandEna pavitrENAtmanA ca paripUrNObhavat| ");
INSERT INTO sancol_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","tau dvau janau yugapad ikaniyanagarasthayihUdIyAnAM bhajanabhavanaM gatvA yathA bahavO yihUdIyA anyadEेzIyalOkAzca vyazvasan tAdRzIM kathAM kathitavantau| ");
INSERT INTO sancol_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","kintu vizvAsahInA yihUdIyA anyadEzIyalOkAn kupravRttiM grAhayitvA bhrAtRgaNaM prati tESAM vairaM janitavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ataH svAnugrahakathAyAH pramANaM datvA tayO rhastai rbahulakSaNam adbhutakarmma ca prAkAzayad yaH prabhustasya kathA akSObhEna pracAryya tau tatra bahudinAni samavAtiSThEtAM| ");
INSERT INTO sancol_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","kintu kiyantO lOkA yihUdIyAnAM sapakSAH kiyantO lOkAH prEritAnAM sapakSA jAtAH, atO nAgarikajananivahamadhyE bhinnavAkyatvam abhavat| ");
INSERT INTO sancol_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","anyadEzIyA yihUdIyAstESAm adhipatayazca daurAtmyaM kutvA tau prastarairAhantum udyatAH| ");
INSERT INTO sancol_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","tau tadvArttAM prApya palAyitvA lukAyaniyAdEzasyAntarvvarttilustrAdarbbO ");
INSERT INTO sancol_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","tatsamIpasthadEzanjca gatvA tatra susaMvAdaM pracArayatAM| ");
INSERT INTO sancol_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","tatrObhayapAdayOzcalanazaktihInO janmArabhya khanjjaH kadApi gamanaM nAkarOt EtAdRza EkO mAnuSO lustrAnagara upavizya paulasya kathAM zrutavAn| ");
INSERT INTO sancol_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Etasmin samayE paulastamprati dRSTiM kRtvA tasya svAsthyE vizvAsaM viditvA prOccaiH kathitavAn ");
INSERT INTO sancol_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","padbhyAmuttiSThan Rju rbhava|tataH sa ullamphaM kRtvA gamanAgamanE kutavAn| ");
INSERT INTO sancol_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","tadA lOkAH paulasya tat kAryyaM vilOkya lukAyanIyabhASayA prOccaiH kathAmEtAM kathitavantaH, dEvA manuSyarUpaM dhRtvAsmAkaM samIpam avArOhan| ");
INSERT INTO sancol_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","tE barNabbAM yUpitaram avadan paulazca mukhyO vaktA tasmAt taM markuriyam avadan| ");
INSERT INTO sancol_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","tasya nagarasya sammukhE sthApitasya yUpitaravigrahasya yAjakO vRSAn puSpamAlAzca dvArasamIpam AnIya lOkaiH sarddhaM tAvuddizya samutsRjya dAtum udyataH| ");
INSERT INTO sancol_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","tadvArttAM zrutvA barNabbApaulau svIyavastrANi chitvA lOkAnAM madhyaM vEgEna pravizya prOccaiH kathitavantau, ");
INSERT INTO sancol_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","hE mahEcchAH kuta EtAdRzaM karmma kurutha? AvAmapi yuSmAdRzau sukhaduHkhabhOginau manuSyau, yuyam EtAH sarvvA vRthAkalpanAH parityajya yathA gagaNavasundharAjalanidhInAM tanmadhyasthAnAM sarvvESAnjca sraSTAramamaram IzvaraM prati parAvarttadhvE tadartham AvAM yuSmAkaM sannidhau susaMvAdaM pracArayAvaH| ");
INSERT INTO sancol_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","sa IzvaraH pUrvvakAlE sarvvadEzIyalOkAn svasvamArgE calitumanumatiM dattavAn, ");
INSERT INTO sancol_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","tathApi AkAzAt tOyavarSaNEna nAnAprakArazasyOtpatyA ca yuSmAkaM hitaiSI san bhakSyairAnanadEna ca yuSmAkam antaHkaraNAni tarpayan tAni dAnAni nijasAkSisvarUpANi sthapitavAn| ");
INSERT INTO sancol_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","kintu tAdRzAyAM kathAyAM kathitAyAmapi tayOH samIpa utsarjanAt lOkanivahaM prAyENa nivarttayituM nAzaknutAm| ");
INSERT INTO sancol_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","AntiyakhiyA-ikaniyanagarAbhyAM katipayayihUdIyalOkA Agatya lOkAn prAvarttayanta tasmAt tai paulaM prastarairAghnan tEna sa mRta iti vijnjAya nagarasya bahistam AkRSya nItavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","kintu ziSyagaNE tasya caturdizi tiSThati sati sa svayam utthAya punarapi nagaramadhyaM prAvizat tatparE'hani barNabbAsahitO darbbInagaraM gatavAn| ");
INSERT INTO sancol_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","tatra susaMvAdaM pracAryya bahulOkAn ziSyAn kRtvA tau lustrAm ikaniyam AntiyakhiyAnjca parAvRtya gatau| ");
INSERT INTO sancol_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","bahuduHkhAni bhuktvApIzvararAjyaM pravESTavyam iti kAraNAd dharmmamArgE sthAtuM vinayaM kRtvA ziSyagaNasya manaHsthairyyam akurutAM| ");
INSERT INTO sancol_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","maNPalInAM prAcInavargAn niyujya prArthanOpavAsau kRtvA yatprabhau tE vyazvasan tasya hastE tAn samarpya ");
INSERT INTO sancol_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","pisidiyAmadhyEna pAmphuliyAdEzaM gatavantau| ");
INSERT INTO sancol_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","pazcAt pargAnagaraM gatvA susaMvAdaM pracAryya attAliyAnagaraM prasthitavantau| ");
INSERT INTO sancol_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","tasmAt samudrapathEna gatvA tAbhyAM yat karmma sampannaM tatkarmma sAdhayituM yannagarE dayAlOrIzvarasya hastE samarpitau jAtau tad AntiyakhiyAnagaraM gatavantA| ");
INSERT INTO sancol_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","tatrOpasthAya tannagarasthamaNPalIM saMgRhya svAbhyAma IzvarO yadyat karmmakarOt tathA yEna prakArENa bhinnadEzIyalOkAn prati vizvAsarUpadvAram amOcayad EtAn sarvvavRttAntAn tAn jnjApitavantau| ");
INSERT INTO sancol_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","tatastau ziryyaiH sArddhaM tatra bahudinAni nyavasatAm| ");
INSERT INTO sancol_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","yihUdAdEzAt kiyantO janA Agatya bhrAtRgaNamitthaM zikSitavantO mUsAvyavasthayA yadi yuSmAkaM tvakchEdO na bhavati tarhi yUyaM paritrANaM prAptuM na zakSyatha| ");
INSERT INTO sancol_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","paulabarNabbau taiH saha bahUn vicArAn vivAdAMzca kRtavantau, tatO maNPalIyanOkA EtasyAH kathAyAstattvaM jnjAtuM yirUzAlamnagarasthAn prEritAn prAcInAMzca prati paulabarNabbAprabhRtIn katipayajanAn prESayituM nizcayaM kRtavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","tE maNPalyA prEritAH santaH phaiNIkIzOmirOndEzAbhyAM gatvA bhinnadEzIyAnAM manaHparivarttanasya vArttayA bhrAtRNAM paramAhlAdam ajanayan| ");
INSERT INTO sancol_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","yirUzAlamyupasthAya prEritagaNEna lOkaprAcInagaNEna samAjEna ca samupagRhItAH santaH svairIzvarO yAni karmmANi kRtavAn tESAM sarvvavRttAntAn tESAM samakSam akathayan| ");
INSERT INTO sancol_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","kintu vizvAsinaH kiyantaH phirUzimatagrAhiNO lOkA utthAya kathAmEtAM kathitavantO bhinnadEzIyAnAM tvakchEdaM karttuM mUsAvyavasthAM pAlayitunjca samAdESTavyam| ");
INSERT INTO sancol_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","tataH prEritA lOkaprAcInAzca tasya vivEcanAM karttuM sabhAyAM sthitavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","bahuvicArESu jAtaSu pitara utthAya kathitavAn, hE bhrAtarO yathA bhinnadEzIyalOkA mama mukhAt susaMvAdaM zrutvA vizvasanti tadarthaM bahudinAt pUrvvam IzvarOsmAkaM madhyE mAM vRtvA niyuktavAn| ");
INSERT INTO sancol_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","antaryyAmIzvarO yathAsmabhyaM tathA bhinnadEzIyEbhyaH pavitramAtmAnaM pradAya vizvAsEna tESAm antaHkaraNAni pavitrANi kRtvA ");
INSERT INTO sancol_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","tESAm asmAkanjca madhyE kimapi vizESaM na sthApayitvA tAnadhi svayaM pramANaM dattavAn iti yUyaM jAnItha| ");
INSERT INTO sancol_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","ataEvAsmAkaM pUrvvapuruSA vayanjca svayaM yadyugasya bhAraM sOPhuM na zaktAH samprati taM ziSyagaNasya skandhESu nyasituM kuta Izvarasya parIkSAM kariSyatha? ");
INSERT INTO sancol_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","prabhO ryIzukhrISTasyAnugrahENa tE yathA vayamapi tathA paritrANaM prAptum AzAM kurmmaH| ");
INSERT INTO sancol_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","anantaraM barNabbApaulAbhyAm IzvarO bhinnadEzIyAnAM madhyE yadyad Azcaryyam adbhutanjca karmma kRtavAn tadvRttAntaM tau svamukhAbhyAm avarNayatAM sabhAsthAH sarvvE nIravAH santaH zrutavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","tayOH kathAyAM samAptAyAM satyAM yAkUb kathayitum ArabdhavAn ");
INSERT INTO sancol_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","hE bhrAtarO mama kathAyAm manO nidhatta| IzvaraH svanAmArthaM bhinnadEzIyalOkAnAm madhyAd EkaM lOkasaMghaM grahItuM matiM kRtvA yEna prakArENa prathamaM tAn prati kRpAvalEkanaM kRtavAn taM zimOn varNitavAn| ");
INSERT INTO sancol_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","bhaviSyadvAdibhiruktAni yAni vAkyAni taiH sArddham EtasyaikyaM bhavati yathA likhitamAstE| ");
INSERT INTO sancol_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","sarvvESAM karmmaNAM yastu sAdhakaH paramEzvaraH| sa EvEdaM vadEdvAkyaM zESAH sakalamAnavAH| bhinnadEzIyalOkAzca yAvantO mama nAmataH| bhavanti hi suvikhyAtAstE yathA paramEzituH| ");
INSERT INTO sancol_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","tatvaM samyak samIhantE tannimittamahaM kila| parAvRtya samAgatya dAyUdaH patitaM punaH| dUSyamutthApayiSyAmi tadIyaM sarvvavastu ca| patitaM punaruthApya sajjayiSyAmi sarvvathA|| ");
INSERT INTO sancol_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","A prathamAd IzvaraH svIyAni sarvvakarmmANi jAnAti| ");
INSERT INTO sancol_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","ataEva mama nivEdanamidaM bhinnadEzIyalOkAnAM madhyE yE janA IzvaraM prati parAvarttanta tESAmupari anyaM kamapi bhAraM na nyasya ");
INSERT INTO sancol_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","dEvatAprasAdAzucibhakSyaM vyabhicArakarmma kaNThasampIPanamAritaprANibhakSyaM raktabhakSyanjca EtAni parityaktuM likhAmaH| ");
INSERT INTO sancol_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","yataH pUrvvakAlatO mUsAvyavasthApracAriNO lOkA nagarE nagarE santi prativizrAmavAranjca bhajanabhavanE tasyAH pAThO bhavati| ");
INSERT INTO sancol_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","tataH paraM prEritagaNO lOkaprAcInagaNaH sarvvA maNPalI ca svESAM madhyE barzabbA nAmnA vikhyAtO manOnItau kRtvA paulabarNabbAbhyAM sArddham AntiyakhiyAnagaraM prati prESaNam ucitaM buddhvA tAbhyAM patraM praiSayan| ");
INSERT INTO sancol_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","tasmin patrE likhitamiMda, AntiyakhiyA-suriyA-kilikiyAdEzasthabhinnadEzIyabhrAtRgaNAya prEritagaNasya lOkaprAcInagaNasya bhrAtRgaNasya ca namaskAraH| ");
INSERT INTO sancol_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","vizESatO'smAkam AjnjAm aprApyApi kiyantO janA asmAkaM madhyAd gatvA tvakchEdO mUsAvyavasthA ca pAlayitavyAviti yuSmAn zikSayitvA yuSmAkaM manasAmasthairyyaM kRtvA yuSmAn sasandEhAn akurvvan EtAM kathAM vayam azRnma| ");
INSERT INTO sancol_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","tatkAraNAd vayam EkamantraNAH santaH sabhAyAM sthitvA prabhO ryIzukhrISTasya nAmanimittaM mRtyumukhagatAbhyAmasmAkaM ");
INSERT INTO sancol_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","priyabarNabbApaulAbhyAM sArddhaM manOnItalOkAnAM kESAnjcid yuSmAkaM sannidhau prESaNam ucitaM buddhavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","atO yihUdAsIlau yuSmAn prati prESitavantaH, EtayO rmukhAbhyAM sarvvAM kathAM jnjAsyatha| ");
INSERT INTO sancol_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","dEvatAprasAdabhakSyaM raktabhakSyaM galapIPanamAritaprANibhakSyaM vyabhicArakarmma cEmAni sarvvANi yuSmAbhistyAjyAni; EtatprayOjanIyAjnjAvyatirEkEna yuSmAkam upari bhAramanyaM na nyasituM pavitrasyAtmanO'smAkanjca ucitajnjAnam abhavat| ");
INSERT INTO sancol_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ataEva tEbhyaH sarvvEbhyaH svESu rakSitESu yUyaM bhadraM karmma kariSyatha| yuSmAkaM maggalaM bhUyAt| ");
INSERT INTO sancol_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","tEे visRSTAH santa AntiyakhiyAnagara upasthAya lOkanivahaM saMgRhya patram adadan| ");
INSERT INTO sancol_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","tatastE tatpatraM paThitvA sAntvanAM prApya sAnandA abhavan| ");
INSERT INTO sancol_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","yihUdAsIlau ca svayaM pracArakau bhUtvA bhrAtRgaNaM nAnOpadizya tAn susthirAn akurutAm| ");
INSERT INTO sancol_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","itthaM tau tatra taiH sAkaM katipayadinAni yApayitvA pazcAt prEritAnAM samIpE pratyAgamanArthaM tESAM sannidhEH kalyANEna visRSTAvabhavatAM| ");
INSERT INTO sancol_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","kintu sIlastatra sthAtuM vAnjchitavAn| ");
INSERT INTO sancol_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","aparaM paulabarNabbau bahavaH ziSyAzca lOkAn upadizya prabhOH susaMvAdaM pracArayanta AntiyakhiyAyAM kAlaM yApitavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","katipayadinESu gatESu paulO barNabbAm avadat AgacchAvAM yESu nagarESvIzvarasya susaMvAdaM pracAritavantau tAni sarvvanagarANi punargatvA bhrAtaraH kIdRzAH santIti draSTuM tAn sAkSAt kurvvaH| ");
INSERT INTO sancol_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","tEna mArkanAmnA vikhyAtaM yOhanaM sagginaM karttuM barNabbA matimakarOt, ");
INSERT INTO sancol_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","kintu sa pUrvvaM tAbhyAM saha kAryyArthaM na gatvA pAmphUliyAdEzE tau tyaktavAn tatkAraNAt paulastaM sagginaM karttum anucitaM jnjAtavAn| ");
INSERT INTO sancol_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","itthaM tayOratizayavirOdhasyOpasthitatvAt tau parasparaM pRthagabhavatAM tatO barNabbA mArkaM gRhItvA pOtEna kuprOpadvIpaM gatavAn; ");
INSERT INTO sancol_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","kintu paulaH sIlaM manOnItaM kRtvA bhrAtRbhirIzvarAnugrahE samarpitaH san prasthAya ");
INSERT INTO sancol_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","suriyAkilikiyAdEzAbhyAM maNPalIH sthirIkurvvan agacchat| ");
INSERT INTO sancol_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","paulO darbbIlustrAnagarayOrupasthitObhavat tatra tImathiyanAmA ziSya Eka AsIt; sa vizvAsinyA yihUdIyAyA yOSitO garbbhajAtaH kintu tasya pitAnyadEzIyalOkaH| ");
INSERT INTO sancol_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","sa janO lustrA-ikaniyanagarasthAnAM bhrAtRNAM samIpEpi sukhyAtimAn AsIt| ");
INSERT INTO sancol_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","paulastaM svasagginaM karttuM matiM kRtvA taM gRhItvA taddEzanivAsinAM yihUdIyAnAm anurOdhAt tasya tvakchEdaM kRtavAn yatastasya pitA bhinnadEzIyalOka iti sarvvairajnjAyata| ");
INSERT INTO sancol_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","tataH paraM tE nagarE nagarE bhramitvA yirUzAlamasthaiH prEritai rlOkaprAcInaizca nirUpitaM yad vyavasthApatraM tadanusArENAcarituM lOkEbhyastad dattavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","tEnaiva sarvvE dharmmasamAjAH khrISTadharmmE susthirAH santaH pratidinaM varddhitA abhavan| ");
INSERT INTO sancol_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","tESu phrugiyAgAlAtiyAdEzamadhyEna gatESu satsu pavitra AtmA tAn AziyAdEzE kathAM prakAzayituM pratiSiddhavAn| ");
INSERT INTO sancol_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","tathA musiyAdEza upasthAya bithuniyAM gantuM tairudyOgE kRtE AtmA tAn nAnvamanyata| ");
INSERT INTO sancol_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","tasmAt tE musiyAdEzaM parityajya trOyAnagaraM gatvA samupasthitAH| ");
INSERT INTO sancol_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","rAtrau paulaH svapnE dRSTavAn EkO mAkidaniyalOkastiSThan vinayaM kRtvA tasmai kathayati, mAkidaniyAdEzam AgatyAsmAn upakurvviti| ");
INSERT INTO sancol_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","tasyEtthaM svapnadarzanAt prabhustaddEzIyalOkAn prati susaMvAdaM pracArayitum asmAn AhUyatIti nizcitaM buddhvA vayaM tUrNaM mAkidaniyAdEzaM gantum udyOgam akurmma| ");
INSERT INTO sancol_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","tataH paraM vayaM trOyAnagarAd prasthAya RjumArgENa sAmathrAkiyOpadvIpEna gatvA parE'hani niyApalinagara upasthitAH| ");
INSERT INTO sancol_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","tasmAd gatvA mAkidaniyAntarvvartti rOmIyavasatisthAnaM yat philipInAmapradhAnanagaraM tatrOpasthAya katipayadinAni tatra sthitavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","vizrAmavArE nagarAd bahi rgatvA nadItaTE yatra prArthanAcAra AsIt tatrOpavizya samAgatA nArIH prati kathAM prAcArayAma| ");
INSERT INTO sancol_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","tataH thuyAtIrAnagarIyA dhUSarAmbaravikrAyiNI ludiyAnAmikA yA IzvarasEvikA yOSit zrOtrINAM madhya AsIt tayA paulOktavAkyAni yad gRhyantE tadarthaM prabhustasyA manOdvAraM muktavAn| ");
INSERT INTO sancol_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ataH sA yOSit saparivArA majjitA satI vinayaM kRtvA kathitavatI, yuSmAkaM vicArAd yadi prabhau vizvAsinI jAtAhaM tarhi mama gRham Agatya tiSThata| itthaM sA yatnEnAsmAn asthApayat| ");
INSERT INTO sancol_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","yasyA gaNanayA tadadhipatInAM bahudhanOpArjanaM jAtaM tAdRzI gaNakabhUtagrastA kAcana dAsI prArthanAsthAnagamanakAla AgatyAsmAn sAkSAt kRtavatI| ");
INSERT INTO sancol_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","sAsmAkaM paulasya ca pazcAd Etya prOccaiH kathAmimAM kathitavatI, manuSyA EtE sarvvOparisthasyEzvarasya sEvakAH santO'smAn prati paritrANasya mArgaM prakAzayanti| ");
INSERT INTO sancol_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","sA kanyA bahudinAni tAdRzam akarOt tasmAt paulO duHkhitaH san mukhaM parAvartya taM bhUtamavadad, ahaM yIzukhrISTasya nAmnA tvAmAjnjApayAmi tvamasyA bahirgaccha; tEnaiva tatkSaNAt sa bhUtastasyA bahirgataH| ");
INSERT INTO sancol_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","tataH svESAM lAbhasya pratyAzA viphalA jAtEti vilOkya tasyAH prabhavaH paulaM sIlanjca dhRtvAkRSya vicArasthAnE'dhipatInAM samIpam Anayan| ");
INSERT INTO sancol_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","tataH zAsakAnAM nikaTaM nItvA rOmilOkA vayam asmAkaM yad vyavaharaNaM grahItum Acaritunjca niSiddhaM, ");
INSERT INTO sancol_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","imE yihUdIyalOkAH santOpi tadEva zikSayitvA nagarE'smAkam atIva kalahaM kurvvanti, ");
INSERT INTO sancol_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","iti kathitE sati lOkanivahastayOH prAtikUlyEnOdatiSThat tathA zAsakAstayO rvastrANi chitvA vEtrAghAtaM karttum AjnjApayan| ");
INSERT INTO sancol_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","aparaM tE tau bahu prahAryya tvamEtau kArAM nItvA sAvadhAnaM rakSayEti kArArakSakam Adizan| ");
INSERT INTO sancol_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ittham AjnjAM prApya sa tAvabhyantarasthakArAM nItvA pAdESu pAdapAzIbhi rbaddhvA sthApitAvAn| ");
INSERT INTO sancol_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","atha nizIthasamayE paulasIlAvIzvaramuddizya prAthanAM gAnanjca kRtavantau, kArAsthitA lOkAzca tadazRNvan ");
INSERT INTO sancol_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","tadAkasmAt mahAn bhUmikampO'bhavat tEna bhittimUlEna saha kArA kampitAbhUt tatkSaNAt sarvvANi dvArANi muktAni jAtAni sarvvESAM bandhanAni ca muktAni| ");
INSERT INTO sancol_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","ataEva kArArakSakO nidrAtO jAgaritvA kArAyA dvArANi muktAni dRSTvA bandilOkAH palAyitA ityanumAya kOSAt khaggaM bahiH kRtvAtmaghAtaM karttum udyataH| ");
INSERT INTO sancol_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","kintu paulaH prOccaistamAhUya kathitavAn pazya vayaM sarvvE'trAsmahE, tvaM nijaprANahiMsAM mAkArSIH| ");
INSERT INTO sancol_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","tadA pradIpam AnEtum uktvA sa kampamAnaH san ullampyAbhyantaram Agatya paulasIlayOH pAdESu patitavAn| ");
INSERT INTO sancol_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","pazcAt sa tau bahirAnIya pRSTavAn hE mahEcchau paritrANaM prAptuM mayA kiM karttavyaM? ");
INSERT INTO sancol_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","pazcAt tau svagRhamAnIya tayOH sammukhE khAdyadravyANi sthApitavAn tathA sa svayaM tadIyAH sarvvE parivArAzcEzvarE vizvasantaH sAnanditA abhavan| ");
INSERT INTO sancol_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","tasmai tasya gRhasthitasarvvalOkEbhyazca prabhOH kathAM kathitavantau| ");
INSERT INTO sancol_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","tathA rAtrEstasminnEva daNPE sa tau gRhItvA tayOH prahArANAM kSatAni prakSAlitavAn tataH sa svayaM tasya sarvvE parijanAzca majjitA abhavan| ");
INSERT INTO sancol_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","pazcAt tau svagRhamAnIya tayOH sammukhE khAdyadravyANi sthApitavAn tathA sa svayaM tadIyAH sarvvE parivArAzcEzvarE vizvasantaH sAnanditA abhavan| ");
INSERT INTO sancol_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","dina upasthitE tau lOkau mOcayEti kathAM kathayituM zAsakAH padAtigaNaM prESitavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","tataH kArArakSakaH paulAya tAM vArttAM kathitavAn yuvAM tyAjayituM zAsakA lOkAna prESitavanta idAnIM yuvAM bahi rbhUtvA kuzalEna pratiSThEtAM| ");
INSERT INTO sancol_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","kintu paulastAn avadat rOmilOkayOrAvayOH kamapi dOSam na nizcitya sarvvESAM samakSam AvAM kazayA tAPayitvA kArAyAM baddhavanta idAnIM kimAvAM guptaM vistrakSyanti? tanna bhaviSyati, svayamAgatyAvAM bahiH kRtvA nayantu| ");
INSERT INTO sancol_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","tadA padAtibhiH zAsakEbhya EtadvArttAyAM kathitAyAM tau rOmilOkAviti kathAM zrutvA tE bhItAH ");
INSERT INTO sancol_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","santastayOH sannidhimAgatya vinayam akurvvan aparaM bahiH kRtvA nagarAt prasthAtuM prArthitavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","tatastau kArAyA nirgatya ludiyAyA gRhaM gatavantau tatra bhrAtRgaNaM sAkSAtkRtya tAn sAntvayitvA tasmAt sthAnAt prasthitau| ");
INSERT INTO sancol_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","paulasIlau AmphipalyApallOniyAnagarAbhyAM gatvA yatra yihUdIyAnAM bhajanabhavanamEkam AstE tatra thiSalanIkInagara upasthitau| ");
INSERT INTO sancol_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","tadA paulaH svAcArAnusArENa tESAM samIpaM gatvA vizrAmavAratrayE taiH sArddhaM dharmmapustakIyakathAyA vicAraM kRtavAn| ");
INSERT INTO sancol_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","phalataH khrISTEna duHkhabhOgaH karttavyaH zmazAnadutthAnanjca karttavyaM yuSmAkaM sannidhau yasya yIzOH prastAvaM karOmi sa IzvarENAbhiSiktaH sa EtAH kathAH prakAzya pramANaM datvA sthirIkRtavAn| ");
INSERT INTO sancol_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","tasmAt tESAM katipayajanA anyadEzIyA bahavO bhaktalOkA bahyaH pradhAnanAryyazca vizvasya paulasIlayOH pazcAdgAminO jAtAH| ");
INSERT INTO sancol_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","kintu vizvAsahInA yihUdIyalOkA IrSyayA paripUrNAH santO haTaTsya katinayalampaTalOkAn sagginaH kRtvA janatayA nagaramadhyE mahAkalahaM kRtvA yAsOnO gRham Akramya prEritAn dhRtvA lOkanivahasya samIpam AnEtuM cESTitavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","tESAmuddEzam aprApya ca yAsOnaM katipayAn bhrAtRMzca dhRtvA nagarAdhipatInAM nikaTamAnIya prOccaiH kathitavantO yE manuSyA jagadudvATitavantastE 'trApyupasthitAH santi, ");
INSERT INTO sancol_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ESa yAsOn AtithyaM kRtvA tAn gRhItavAn| yIzunAmaka EkO rAjastIti kathayantastE kaisarasyAjnjAviruddhaM karmma kurvvati| ");
INSERT INTO sancol_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","tESAM kathAmimAM zrutvA lOkanivahO nagarAdhipatayazca samudvignA abhavan| ");
INSERT INTO sancol_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","tadA yAsOnastadanyESAnjca dhanadaNPaM gRhItvA tAn parityaktavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","tataH paraM bhrAtRgaNO rajanyAM paulasIlau zIghraM birayAnagaraM prESitavAn tau tatrOpasthAya yihUdIyAnAM bhajanabhavanaM gatavantau| ");
INSERT INTO sancol_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","tatrasthA lOkAH thiSalanIkIsthalOkEbhyO mahAtmAna Asan yata itthaM bhavati na vEti jnjAtuM dinE dinE dharmmagranthasyAlOcanAM kRtvA svairaM kathAm agRhlan| ");
INSERT INTO sancol_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","tasmAd anEkE yihUdIyA anyadEzIyAnAM mAnyA striyaH puruSAzcAnEkE vyazvasan| ");
INSERT INTO sancol_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","kintu birayAnagarE paulEnEzvarIyA kathA pracAryyata iti thiSalanIkIsthA yihUdIyA jnjAtvA tatsthAnamapyAgatya lOkAnAM kupravRttim ajanayan| ");
INSERT INTO sancol_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","ataEva tasmAt sthAnAt samudrENa yAntIti darzayitvA bhrAtaraH kSipraM paulaM prAhiNvan kintu sIlatImathiyau tatra sthitavantau| ");
INSERT INTO sancol_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","tataH paraM paulasya mArgadarzakAstam AthInInagara upasthApayan pazcAd yuvAM tUrNam Etat sthAnaM AgamiSyathaH sIlatImathiyau pratImAm AjnjAM prApya tE pratyAgatAH| ");
INSERT INTO sancol_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","paula AthInInagarE tAvapEkSya tiSThan tannagaraM pratimAbhiH paripUrNaM dRSTvA santaptahRdayO 'bhavat| ");
INSERT INTO sancol_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","tataH sa bhajanabhavanE yAn yihUdIyAn bhaktalOkAMzca haTTE ca yAn apazyat taiH saha pratidinaM vicAritavAn| ");
INSERT INTO sancol_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","kintvipikUrIyamatagrahiNaH stOyikIyamatagrAhiNazca kiyantO janAstEna sArddhaM vyavadanta| tatra kEcid akathayan ESa vAcAlaH kiM vaktum icchati? aparE kEcid ESa janaH kESAnjcid vidEzIyadEvAnAM pracAraka ityanumIyatE yataH sa yIzum utthitinjca pracArayat| ");
INSERT INTO sancol_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","tE tam arEyapAganAma vicArasthAnam AnIya prAvOcan idaM yannavInaM mataM tvaM prAcIkaza idaM kIdRzaM Etad asmAn zrAvaya; ");
INSERT INTO sancol_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","yAmimAm asambhavakathAm asmAkaM karNagOcarIkRtavAn asyA bhAvArthaH ka iti vayaM jnjAtum icchAmaH| ");
INSERT INTO sancol_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","tadAthInInivAsinastannagarapravAsinazca kEvalaM kasyAzcana navInakathAyAH zravaNEna pracAraNEna ca kAlam ayApayan| ");
INSERT INTO sancol_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","paulO'rEyapAgasya madhyE tiSThan EtAM kathAM pracAritavAn, hE AthInIyalOkA yUyaM sarvvathA dEvapUjAyAm AsaktA ityaha pratyakSaM pazyAmi| ");
INSERT INTO sancol_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","yataH paryyaTanakAlE yuSmAkaM pUjanIyAni pazyan ‘avijnjAtEzvarAya` EtallipiyuktAM yajnjavEdImEkAM dRSTavAn; atO na viditvA yaM pUjayadhvE tasyaiva tatvaM yuSmAn prati pracArayAmi| ");
INSERT INTO sancol_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","jagatO jagatsthAnAM sarvvavastUnAnjca sraSTA ya IzvaraH sa svargapRthivyOrEkAdhipatiH san karanirmmitamandirESu na nivasati; ");
INSERT INTO sancol_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","sa Eva sarvvEbhyO jIvanaM prANAn sarvvasAmagrIzca pradadAti; ataEva sa kasyAzcit sAmagyrA abhAvahEtO rmanuSyANAM hastaiH sEvitO bhavatIti na| ");
INSERT INTO sancol_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","sa bhUmaNPalE nivAsArtham EkasmAt zONitAt sarvvAn manuSyAn sRSTvA tESAM pUrvvanirUpitasamayaM vasatisImAnjca niracinOt; ");
INSERT INTO sancol_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","tasmAt lOkaiH kEnApi prakArENa mRgayitvA paramEzvarasya tatvaM prAptuM tasya gavESaNaM karaNIyam| ");
INSERT INTO sancol_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","kintu sO'smAkaM kasmAccidapi dUrE tiSThatIti nahi, vayaM tEna nizvasanaprazvasanagamanAgamanaprANadhAraNAni kurmmaH, puुnazca yuSmAkamEva katipayAH kavayaH kathayanti ‘tasya vaMzA vayaM smO hi` iti| ");
INSERT INTO sancol_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","ataEva yadi vayam Izvarasya vaMzA bhavAmastarhi manuSyai rvidyayA kauzalEna ca takSitaM svarNaM rUpyaM dRSad vaitESAmIzvaratvam asmAbhi rna jnjAtavyaM| ");
INSERT INTO sancol_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","tESAM pUrvvIyalOkAnAm ajnjAnatAM pratIzvarO yadyapi nAvAdhatta tathApIdAnIM sarvvatra sarvvAn manaH parivarttayitum AjnjApayati, ");
INSERT INTO sancol_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","yataH svaniyuktEna puruSENa yadA sa pRthivIsthAnAM sarvvalOkAnAM vicAraM kariSyati taddinaM nyarUpayat; tasya zmazAnOtthApanEna tasmin sarvvEbhyaH pramANaM prAdAt| ");
INSERT INTO sancol_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","tadA zmazAnAd utthAnasya kathAM zrutvA kEcid upAhaman, kEcidavadan EnAM kathAM punarapi tvattaH zrOSyAmaH| ");
INSERT INTO sancol_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","tataH paulastESAM samIpAt prasthiाtavAn| ");
INSERT INTO sancol_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","tathApi kEcillOkAstEna sArddhaM militvA vyazvasan tESAM madhyE 'rEyapAgIyadiyanusiyO dAmArInAmA kAcinnArI kiyantO narAzcAsan| ");
INSERT INTO sancol_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","tadghaTanAtaH paraM paula AthInInagarAd yAtrAM kRtvA karinthanagaram Agacchat| ");
INSERT INTO sancol_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","tasmin samayE klaudiyaH sarvvAn yihUdIyAn rOmAnagaraM vihAya gantum AjnjApayat, tasmAt priskillAnAmnA jAyayA sArddham itAliyAdEzAt kinjcitpUrvvam Agamat yaH pantadEzE jAta AkkilanAmA yihUdIyalOkaH paulastaM sAkSAt prApya tayOH samIpamitavAn| ");
INSERT INTO sancol_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","tau dUSyanirmmANajIvinau, tasmAt parasparam EkavRttikatvAt sa tAbhyAM saha uSitvA tat karmmAkarOt| ");
INSERT INTO sancol_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","paulaH prativizrAmavAraM bhajanabhavanaM gatvA vicAraM kRtvA yihUdIyAn anyadEzIyAMzca pravRttiM grAhitavAn| ");
INSERT INTO sancol_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","sIlatImathiyayO rmAkidaniyAdEzAt samEtayOH satOH paula uttaptamanA bhUtvA yIzurIzvarENAbhiSiktO bhavatIti pramANaM yihUdIyAnAM samIpE prAdAt| ");
INSERT INTO sancol_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","kintu tE 'tIva virOdhaM vidhAya pASaNPIyakathAM kathitavantastataH paulO vastraM dhunvan EtAM kathAM kathitavAn, yuSmAkaM zONitapAtAparAdhO yuSmAn pratyEva bhavatu, tEnAhaM niraparAdhO 'dyArabhya bhinnadEzIyAnAM samIpaM yAmi| ");
INSERT INTO sancol_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","sa tasmAt prasthAya bhajanabhavanasamIpasthasya yustanAmna Izvarabhaktasya bhinnadEzIyasya nivEzanaM prAvizat| ");
INSERT INTO sancol_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","tataH krISpanAmA bhajanabhavanAdhipatiH saparivAraH prabhau vyazvasIt, karinthanagarIyA bahavO lOkAzca samAkarNya vizvasya majjitA abhavan| ");
INSERT INTO sancol_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","kSaNadAyAM prabhuH paulaM darzanaM datvA bhASitavAn, mA bhaiSIH, mA nirasIH kathAM pracAraya| ");
INSERT INTO sancol_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ahaM tvayA sArddham Asa hiMsArthaM kOpi tvAM spraSTuM na zakSyati nagarE'smin madIyA lOkA bahava AsatE| ");
INSERT INTO sancol_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","tasmAt paulastannagarE prAyENa sArddhavatsaraparyyantaM saMsthAyEzvarasya kathAm upAdizat| ");
INSERT INTO sancol_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","gAlliyanAmA kazcid AkhAyAdEzasya prAPvivAkaH samabhavat, tatO yihUdIyA EkavAkyAH santaH paulam Akramya vicArasthAnaM nItvA ");
INSERT INTO sancol_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","mAnuSa ESa vyavasthAya viruddham IzvarabhajanaM karttuM lOkAn kupravRttiM grAhayatIti nivEditavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","tataH paulE pratyuttaraM dAtum udyatE sati gAlliyA yihUdIyAn vyAharat, yadi kasyacid anyAyasya vAtizayaduSTatAcaraNasya vicArO'bhaviSyat tarhi yuSmAkaM kathA mayA sahanIyAbhaviSyat| ");
INSERT INTO sancol_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","kintu yadi kEvalaM kathAyA vA nAmnO vA yuSmAkaM vyavasthAyA vivAdO bhavati tarhi tasya vicAramahaM na kariSyAmi, yUyaM tasya mImAMsAM kuruta| ");
INSERT INTO sancol_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","tataH sa tAn vicArasthAnAd dUrIkRtavAn| ");
INSERT INTO sancol_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","tadA bhinnadEzIyAH sOsthininAmAnaM bhajanabhavanasya pradhAnAdhipatiM dhRtvA vicArasthAnasya sammukhE prAharan tathApi gAlliyA tESu sarvvakarmmasu na manO nyadadhAt| ");
INSERT INTO sancol_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","paulastatra punarbahudinAni nyavasat, tatO bhrAtRgaNAd visarjanaM prApya kinjcanavratanimittaM kiMkriyAnagarE zirO muNPayitvA priskillAkkilAbhyAM sahitO jalapathEna suriyAdEzaM gatavAn| ");
INSERT INTO sancol_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","tata iphiSanagara upasthAya tatra tau visRjya svayaM bhajanabhvanaM pravizya yihUdIyaiH saha vicAritavAn| ");
INSERT INTO sancol_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","tE svaiH sArddhaM punaH katipayadinAni sthAtuM taM vyanayan, sa tadanurarIkRtya kathAmEtAM kathitavAn, ");
INSERT INTO sancol_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","yirUzAlami AgAmyutsavapAlanArthaM mayA gamanIyaM; pazcAd IzvarEcchAyAM jAtAyAM yuSmAkaM samIpaM pratyAgamiSyAmi| tataH paraM sa tai rvisRSTaH san jalapathEna iphiSanagarAt prasthitavAn| ");
INSERT INTO sancol_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","tataH kaisariyAm upasthitaH san nagaraM gatvA samAjaM namaskRtya tasmAd AntiyakhiyAnagaraM prasthitavAn| ");
INSERT INTO sancol_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","tatra kiyatkAlaM yApayitvA tasmAt prasthAya sarvvESAM ziSyANAM manAMsi susthirANi kRtvA kramazO galAtiyAphrugiyAdEzayO rbhramitvA gatavAn| ");
INSERT INTO sancol_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","tasminnEva samayE sikandariyAnagarE jAta ApallOnAmA zAstravit suvaktA yihUdIya EkO jana iphiSanagaram AgatavAn| ");
INSERT INTO sancol_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","sa zikSitaprabhumArgO manasOdyOgI ca san yOhanO majjanamAtraM jnjAtvA yathArthatayA prabhOH kathAM kathayan samupAdizat| ");
INSERT INTO sancol_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ESa janO nirbhayatvEna bhajanabhavanE kathayitum ArabdhavAn, tataH priskillAkkilau tasyOpadEzakathAM nizamya taM svayOH samIpam AnIya zuddharUpENEzvarasya kathAm abOdhayatAm| ");
INSERT INTO sancol_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","pazcAt sa AkhAyAdEzaM gantuM matiM kRtavAn, tadA tatratyaH ziSyagaNO yathA taM gRhlAti tadarthaM bhrAtRgaNEna samAzvasya patrE likhitE sati, ApallAstatrOpasthitaH san anugrahENa pratyayinAM bahUpakArAn akarOt, ");
INSERT INTO sancol_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","phalatO yIzurabhiSiktastrAtEti zAstrapramANaM datvA prakAzarUpENa pratipannaM kRtvA yihUdIyAn niruttarAn kRtavAn| ");
INSERT INTO sancol_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","karinthanagara ApallasaH sthitikAlE paula uttarapradEzairAgacchan iphiSanagaram upasthitavAn| tatra katipayaziSyAn sAkSat prApya tAn apRcchat, ");
INSERT INTO sancol_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","yUyaM vizvasya pavitramAtmAnaM prAptA na vA? tatastE pratyavadan pavitra AtmA dIyatE ityasmAbhiH zrutamapi nahi| ");
INSERT INTO sancol_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","tadA sA'vadat tarhi yUyaM kEna majjitA abhavata? tE'kathayan yOhanO majjanEna| ");
INSERT INTO sancol_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","tadA paula uktavAn itaH paraM ya upasthAsyati tasmin arthata yIzukhrISTE vizvasitavyamityuktvA yOhan manaHparivarttanasUcakEna majjanEna jalE lOkAn amajjayat| ");
INSERT INTO sancol_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","tAdRzIM kathAM zrutvA tE prabhO ryIzukhrISTasya nAmnA majjitA abhavan| ");
INSERT INTO sancol_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","tataH paulEna tESAM gAtrESu karE'rpitE tESAmupari pavitra AtmAvarUPhavAn, tasmAt tE nAnAdEzIyA bhASA bhaviSyatkathAzca kathitavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","tE prAyENa dvAdazajanA Asan| ");
INSERT INTO sancol_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","paulO bhajanabhavanaM gatvA prAyENa mAsatrayam Izvarasya rAjyasya vicAraM kRtvA lOkAn pravartya sAhasEna kathAmakathayat| ");
INSERT INTO sancol_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","kintu kaThinAntaHkaraNatvAt kiyantO janA na vizvasya sarvvESAM samakSam Etatpathasya nindAM karttuM pravRttAH, ataH paulastESAM samIpAt prasthAya ziSyagaNaM pRthakkRtvA pratyahaM turAnnanAmnaH kasyacit janasya pAThazAlAyAM vicAraM kRtavAn| ");
INSERT INTO sancol_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","itthaM vatsaradvayaM gataM tasmAd AziyAdEzanivAsinaH sarvvE yihUdIyA anyadEzIyalOkAzca prabhO ryIzOH kathAm azrauSan| ");
INSERT INTO sancol_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","paulEna ca Izvara EtAdRzAnyadbhutAni karmmANi kRtavAn ");
INSERT INTO sancol_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","yat paridhEyE gAtramArjanavastrE vA tasya dEhAt pIPitalOkAnAm samIpam AnItE tE nirAmayA jAtA apavitrA bhUtAzca tEbhyO bahirgatavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","tadA dEzATanakAriNaH kiyantO yihUdIyA bhUtApasAriNO bhUtagrastanOkAnAM sannidhau prabhE ryIzO rnAma japtvA vAkyamidam avadan, yasya kathAM paulaH pracArayati tasya yIzO rnAmnA yuSmAn AjnjApayAmaH| ");
INSERT INTO sancol_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","skivanAmnO yihUdIyAnAM pradhAnayAjakasya saptabhiH puttaistathA kRtE sati ");
INSERT INTO sancol_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","kazcid apavitrO bhUtaH pratyuditavAn, yIzuM jAnAmi paulanjca paricinOmi kintu kE yUyaM? ");
INSERT INTO sancol_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ityuktvA sOpavitrabhUtagrastO manuSyO lamphaM kRtvA tESAmupari patitvA balEna tAn jitavAn, tasmAttE nagnAH kSatAggAzca santastasmAd gEhAt palAyanta| ");
INSERT INTO sancol_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","sA vAg iphiSanagaranivAsinasaM sarvvESAM yihUdIyAnAM bhinnadEzIyAnAM lOkAnAnjca zravOgOcarIbhUtA; tataH sarvvE bhayaM gatAH prabhO ryIzO rnAmnO yazO 'varddhata| ");
INSERT INTO sancol_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","yESAmanEkESAM lOkAnAM pratItirajAyata ta Agatya svaiH kRtAH kriyAH prakAzarUpENAggIkRtavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","bahavO mAyAkarmmakAriNaH svasvagranthAn AnIya rAzIkRtya sarvvESAM samakSam adAhayan, tatO gaNanAM kRtvAbudhyanta panjcAyutarUpyamudrAmUlyapustakAni dagdhAni| ");
INSERT INTO sancol_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","itthaM prabhOH kathA sarvvadEzaM vyApya prabalA jAtA| ");
INSERT INTO sancol_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","sarvvESvEtESu karmmasu sampannESu satsu paulO mAkidaniyAkhAyAdEzAbhyAM yirUzAlamaM gantuM matiM kRtvA kathitavAn tatsthAnaM yAtrAyAM kRtAyAM satyAM mayA rOmAnagaraM draSTavyaM| ");
INSERT INTO sancol_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","svAnugatalOkAnAM tImathiyErAstau dvau janau mAkidaniyAdEzaM prati prahitya svayam AziyAdEzE katipayadinAni sthitavAn| ");
INSERT INTO sancol_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","kintu tasmin samayE matE'smin kalahO jAtaH| ");
INSERT INTO sancol_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","tatkAraNamidaM, arttimIdEvyA rUpyamandiranirmmANEna sarvvESAM zilpinAM yathESTalAbham ajanayat yO dImItriyanAmA nAPIndhamaH ");
INSERT INTO sancol_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","sa tAn tatkarmmajIvinaH sarvvalOkAMzca samAhUya bhASitavAn hE mahEcchA EtEna mandiranirmmANEnAsmAkaM jIvikA bhavati, Etad yUyaM vittha; ");
INSERT INTO sancol_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","kintu hastanirmmitEzvarA IzvarA nahi paulanAmnA kEnacijjanEna kathAmimAM vyAhRtya kEvalEphiSanagarE nahi prAyENa sarvvasmin AziyAdEzE pravRttiM grAhayitvA bahulOkAnAM zEmuSI parAvarttitA, Etad yuSmAbhi rdRzyatE zrUyatE ca| ");
INSERT INTO sancol_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","tEnAsmAkaM vANijyasya sarvvathA hAnEH sambhavanaM kEvalamiti nahi, AziyAdEzasthai rvA sarvvajagatsthai rlOkaiH pUjyA yArtimI mahAdEvI tasyA mandirasyAvajnjAnasya tasyA aizvaryyasya nAzasya ca sambhAvanA vidyatEे| ");
INSERT INTO sancol_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","EtAdRzIM kathAM zrutvA tE mahAkrOdhAnvitAH santa uccaiHkAraM kathitavanta iphiSIyAnAm arttimI dEvI mahatI bhavati| ");
INSERT INTO sancol_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","tataH sarvvanagaraM kalahEna paripUrNamabhavat, tataH paraM tE mAkidanIyagAyAristArkhanAmAnau paulasya dvau sahacarau dhRtvaikacittA raggabhUmiM javEna dhAvitavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","tataH paulO lOkAnAM sannidhiM yAtum udyatavAn kintu ziSyagaNastaM vAritavAn| ");
INSERT INTO sancol_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","paulasyatmIyA AziyAdEzasthAH katipayAH pradhAnalOkAstasya samIpaM naramEkaM prESya tvaM raggabhUmiM mAgA iti nyavEdayan| ");
INSERT INTO sancol_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","tatO nAnAlOkAnAM nAnAkathAkathanAt sabhA vyAkulA jAtA kiM kAraNAd EtAvatI janatAbhavat Etad adhikai rlOkai rnAjnjAyi| ");
INSERT INTO sancol_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","tataH paraM janatAmadhyAd yihUdIyairbahiSkRtaH sikandarO hastEna sagkEtaM kRtvA lOkEbhya uttaraM dAtumudyatavAn, ");
INSERT INTO sancol_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","kintu sa yihUdIyalOka iti nizcitE sati iphiSIyAnAm arttimI dEvI mahatIti vAkyaM prAyENa panjca daNPAn yAvad EkasvarENa lOkanivahaiH prOktaM| ");
INSERT INTO sancol_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","tatO nagarAdhipatistAn sthirAn kRtvA kathitavAn hE iphiSAyAH sarvvE lOkA AkarNayata, artimImahAdEvyA mahAdEvAt patitAyAstatpratimAyAzca pUjanama iphiSanagarasthAH sarvvE lOkAH kurvvanti, Etat kE na jAnanti? ");
INSERT INTO sancol_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","tasmAd EtatpratikUlaM kEpi kathayituM na zaknuvanti, iti jnjAtvA yuSmAbhiH susthiratvEna sthAtavyam avivicya kimapi karmma na karttavyanjca| ");
INSERT INTO sancol_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","yAn EtAn manuSyAn yUyamatra samAnayata tE mandiradravyApahArakA yuSmAkaM dEvyA nindakAzca na bhavanti| ");
INSERT INTO sancol_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","yadi kanjcana prati dImItriyasya tasya sahAyAnAnjca kAcid Apatti rvidyatE tarhi pratinidhilOkA vicArasthAnanjca santi, tE tat sthAnaM gatvA uttarapratyuttarE kurvvantu| ");
INSERT INTO sancol_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","kintu yuSmAkaM kAcidaparA kathA yadi tiSThati tarhi niyamitAyAM sabhAyAM tasyA niSpatti rbhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","kintvEtasya virOdhasyOttaraM yEna dAtuM zaknum EtAdRzasya kasyacit kAraNasyAbhAvAd adyatanaghaTanAhEtO rAjadrOhiNAmivAsmAkam abhiyOgO bhaviSyatIti zagkA vidyatE| ");
INSERT INTO sancol_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","iti kathayitvA sa sabhAsthalOkAn visRSTavAn| ");
INSERT INTO sancol_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","itthaM kalahE nivRttE sati paulaH ziSyagaNam AhUya visarjanaM prApya mAkidaniyAdEzaM prasthitavAn| ");
INSERT INTO sancol_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","tEna sthAnEna gacchan taddEzIyAn ziSyAn bahUpadizya yUnAnIyadEzam upasthitavAn| ");
INSERT INTO sancol_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","tatra mAsatrayaM sthitvA tasmAt suriyAdEzaM yAtum udyataH, kintu yihUdIyAstaM hantuM guptA atiSThan tasmAt sa punarapi mAkidaniyAmArgENa pratyAgantuM matiM kRtavAn| ");
INSERT INTO sancol_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","birayAnagarIyasOpAtraH thiSalanIkIyAristArkhasikundau darbbOnagarIyagAyatImathiyau AziyAdEzIyatukhikatraphimau ca tEna sArddhaM AziyAdEzaM yAvad gatavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","EtE sarvvE 'grasarAH santO 'smAn apEkSya trOyAnagarE sthitavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","kiNvazUnyapUpOtsavadinE ca gatE sati vayaM philipInagarAt tOyapathEna gatvA panjcabhi rdinaistrOyAnagaram upasthAya tatra saptadinAnyavAtiSThAma| ");
INSERT INTO sancol_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","saptAhasya prathamadinE pUpAn bhaMktu ziSyESu militESu paulaH paradinE tasmAt prasthAtum udyataH san tadahni prAyENa kSapAyA yAmadvayaM yAvat ziSyEbhyO dharmmakathAm akathayat| ");
INSERT INTO sancol_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","uparisthE yasmin prakOSThE sabhAM kRtvAsan tatra bahavaH pradIpAH prAjvalan| ");
INSERT INTO sancol_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","utukhanAmA kazcana yuvA ca vAtAyana upavizan ghOrataranidrAgrastO 'bhUt tadA paulEna bahukSaNaM kathAyAM pracAritAyAM nidrAmagnaH sa tasmAd uparisthatRtIyaprakOSThAd apatat, tatO lOkAstaM mRtakalpaM dhRtvOdatOlayan| ");
INSERT INTO sancol_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","tataH paulO'varuhya tasya gAtrE patitvA taM krOPE nidhAya kathitavAn, yUyaM vyAkulA mA bhUta nAyaM prANai rviyuktaH| ");
INSERT INTO sancol_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","pazcAt sa punazcOpari gatvA pUpAn bhaMktvA prabhAtaM yAvat kathOpakathanE kRtvA prasthitavAn| ");
INSERT INTO sancol_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","tE ca taM jIvantaM yuvAnaM gRhItvA gatvA paramApyAyitA jAtAH| ");
INSERT INTO sancol_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","anantaraM vayaM pOtEnAgrasarA bhUtvAsmanagaram uttIryya paulaM grahItuM matim akurmma yataH sa tatra padbhyAM vrajituM matiM kRtvEti nirUpitavAn| ");
INSERT INTO sancol_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","tasmAt tatrAsmAbhiH sArddhaM tasmin militE sati vayaM taM nItvA mitulInyupadvIpaM prAptavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","tasmAt pOtaM mOcayitvA parE'hani khIyOpadvIpasya sammukhaM labdhavantastasmAd EkEnAhnA sAmOpadvIpaM gatvA pOtaM lAgayitvA trOgulliyE sthitvA parasmin divasEे milItanagaram upAtiSThAma| ");
INSERT INTO sancol_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","yataH paula AziyAdEzE kAlaM yApayitum nAbhilaSan iphiSanagaraM tyaktvA yAtuM mantraNAM sthirIkRtavAn; yasmAd yadi sAdhyaM bhavati tarhi nistArOtsavasya panjcAzattamadinE sa yirUzAlamyupasthAtuM matiM kRtavAn| ");
INSERT INTO sancol_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","paulO milItAd iphiSaM prati lOkaM prahitya samAjasya prAcInAn AhUyAnItavAn| ");
INSERT INTO sancol_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","tESu tasya samIpam upasthitESu sa tEbhya imAM kathAM kathitavAn, aham AziyAdEzE prathamAgamanam ArabhyAdya yAvad yuSmAkaM sannidhau sthitvA sarvvasamayE yathAcaritavAn tad yUyaM jAnItha; ");
INSERT INTO sancol_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","phalataH sarvvathA namramanAH san bahuzrupAtEna yihudIyAnAm kumantraNAjAtanAnAparIkSAbhiH prabhOH sEvAmakaravaM| ");
INSERT INTO sancol_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","kAmapi hitakathAाM na gOpAyitavAn tAM pracAryya saprakAzaM gRhE gRhE samupadizyEzvaraM prati manaH parAvarttanIyaM prabhau yIzukhrISTE vizvasanIyaM ");
INSERT INTO sancol_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","yihUdIyAnAm anyadEzIyalOkAnAnjca samIpa EtAdRzaM sAkSyaM dadAmi| ");
INSERT INTO sancol_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","pazyata sAmpratam AtmanAkRSTaH san yirUzAlamnagarE yAtrAM karOmi, tatra mAmprati yadyad ghaTiSyatE tAnyahaM na jAnAmi; ");
INSERT INTO sancol_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","kintu mayA bandhanaM klEzazca bhOktavya iti pavitra AtmA nagarE nagarE pramANaM dadAti| ");
INSERT INTO sancol_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","tathApi taM klEzamahaM tRNAya na manyE; IzvarasyAnugrahaviSayakasya susaMvAdasya pramANaM dAtuM, prabhO ryIzOH sakAzAda yasyAH sEvAyAH bhAraM prApnavaM tAM sEvAM sAdhayituM sAnandaM svamArgaM samApayituुnjca nijaprANAnapi priyAn na manyE| ");
INSERT INTO sancol_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","adhunA pazyata yESAM samIpE'ham IzvarIyarAjyasya susaMvAdaM pracAryya bhramaNaM kRtavAn EtAdRzA yUyaM mama vadanaM puna rdraSTuM na prApsyatha EtadapyahaM jAnAmi| ");
INSERT INTO sancol_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","yuSmabhyam aham Izvarasya sarvvAn AdEzAn prakAzayituM na nyavarttE| ");
INSERT INTO sancol_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","ahaM sarvvESAM lOkAnAM raktapAtadOSAd yannirdOSa AsE tasyAdya yuSmAn sAkSiNaH karOmi| ");
INSERT INTO sancol_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","yUyaM svESu tathA yasya vrajasyAdhyakSan AtmA yuSmAn vidhAya nyayugkta tatsarvvasmin sAvadhAnA bhavata, ya samAjanjca prabhu rnijaraktamUlyEna krItavAna tam avata, ");
INSERT INTO sancol_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","yatO mayA gamanE kRtaEva durjayA vRkA yuSmAkaM madhyaM pravizya vrajaM prati nirdayatAm AcariSyanti, ");
INSERT INTO sancol_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","yuSmAkamEva madhyAdapi lOkA utthAya ziSyagaNam apahantuM viparItam upadEkSyantItyahaM jAnAmi| ");
INSERT INTO sancol_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","iti hEtO ryUyaM sacaitanyAH santastiSTata, ahanjca sAzrupAtaH san vatsaratrayaM yAvad divAnizaM pratijanaM bOdhayituM na nyavarttE tadapi smarata| ");
INSERT INTO sancol_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","idAnIM hE bhrAtarO yuSmAkaM niSThAM janayituM pavitrIkRtalOkAnAM madhyE'dhikAranjca dAtuM samarthO ya IzvarastasyAnugrahasya yO vAdazca tayOrubhayO ryuSmAn samArpayam| ");
INSERT INTO sancol_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","kasyApi svarNaM rUpyaM vastraM vA prati mayA lObhO na kRtaH| ");
INSERT INTO sancol_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","kintu mama matsahacaralOkAnAnjcAvazyakavyayAya madIyamidaM karadvayam azrAmyad Etad yUyaM jAnItha| ");
INSERT INTO sancol_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","anEna prakArENa grahaNad dAnaM bhadramiti yadvAkyaM prabhu ryIzuH kathitavAn tat smarttuM daridralOkAnAmupakArArthaM zramaM karttunjca yuSmAkam ucitam EtatsarvvaM yuSmAnaham upadiSTavAn| ");
INSERT INTO sancol_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","EtAM kathAM kathayitvA sa jAnunI pAtayitvA sarvaiH saha prArthayata| ");
INSERT INTO sancol_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","tEna tE krandrantaH ");
INSERT INTO sancol_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","puna rmama mukhaM na drakSyatha vizESata ESA yA kathA tEnAkathi tatkAraNAt zOkaM vilApanjca kRtvA kaNThaM dhRtvA cumbitavantaH| pazcAt tE taM pOtaM nItavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","tai rvisRSTAH santO vayaM pOtaM bAhayitvA RjumArgENa kOSam upadvIpam Agatya parE'hani rOdiyOpadvIpam AgacchAma tatastasmAt pAtArAyAm upAtiSThAma| ");
INSERT INTO sancol_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","tatra phainIkiyAdEzagAminam pOtamEkaM prApya tamAruhya gatavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","kuprOpadvIpaM dRSTvA taM savyadizi sthApayitvA suriyAdEzaM gatvA pOtasthadravyANyavarOhayituM sOranagarE lAgitavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","tatra ziSyagaNasya sAkSAtkaraNAya vayaM tatra saptadinAni sthitavantaH pazcAttE pavitrENAtmanA paulaM vyAharan tvaM yirUzAlamnagaraM mA gamaH| ");
INSERT INTO sancol_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","tatastESu saptasu dinESu yApitESu satsu vayaM tasmAt sthAnAt nijavartmanA gatavantaH, tasmAt tE sabAlavRddhavanitA asmAbhiH saha nagarasya parisaraparyyantam AgatAH pazcAdvayaM jaladhitaTE jAnupAtaM prArthayAmahi| ");
INSERT INTO sancol_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","tataH parasparaM visRSTAH santO vayaM pOtaM gatAstE tu svasvagRhaM pratyAgatavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","vayaM sOranagarAt nAvA prasthAya talimAyinagaram upAtiSThAma tatrAsmAkaM samudrIyamArgasyAntO'bhavat tatra bhrAtRgaNaM namaskRtya dinamEkaM taiH sArddham uSatavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","parE 'hani paulastasya sagginO vayanjca pratiSThamAnAH kaisariyAnagaram Agatya susaMvAdapracArakAnAM saptajanAnAM philipanAmna Ekasya gRhaM pravizyAvatiSThAma| ");
INSERT INTO sancol_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","tasya catasrO duhitarO'nUPhA bhaviSyadvAdinya Asan| ");
INSERT INTO sancol_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","tatrAsmAsu bahudinAni prOSitESu yihUdIyadEzAd AgatyAgAbanAmA bhaviSyadvAdI samupasthitavAn| ");
INSERT INTO sancol_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","sOsmAkaM samIpamEtya paulasya kaTibandhanaM gRhItvA nijahastApAdAn baddhvA bhASitavAn yasyEdaM kaTibandhanaM taM yihUdIyalOkA yirUzAlamanagara itthaM baddhvA bhinnadEzIyAnAM karESu samarpayiSyantIti vAkyaM pavitra AtmA kathayati| ");
INSERT INTO sancol_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","EtAdRzIM kathAM zrutvA vayaM tannagaravAsinO bhrAtarazca yirUzAlamaM na yAtuM paulaM vyanayAmahi; ");
INSERT INTO sancol_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","kintu sa pratyAvAdIt, yUyaM kiM kurutha? kiM krandanEna mamAntaHkaraNaM vidIrNaM kariSyatha? prabhO ryIzO rnAmnO nimittaM yirUzAlami baddhO bhavituM kEvala tanna prANAn dAtumapi sasajjOsmi| ");
INSERT INTO sancol_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","tEnAsmAkaM kathAyAm agRhItAyAm Izvarasya yathEcchA tathaiva bhavatvityuktvA vayaM nirasyAma| ");
INSERT INTO sancol_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","parE'hani pAthEyadravyANi gRhItvA yirUzAlamaM prati yAtrAm akurmma| ");
INSERT INTO sancol_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","tataH kaisariyAnagaranivAsinaH katipayAH ziSyA asmAbhiH sArddham itvA kRprIyEna mnAsannAmnA yEna prAcInaziSyEna sArddham asmAbhi rvastavyaM tasya samIpam asmAn nItavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","asmAsu yirUzAlamyupasthitESu tatrasthabhrAtRgaNO'smAn AhlAdEna gRhItavAn| ");
INSERT INTO sancol_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","parasmin divasE paulE'smAbhiH saha yAkUbO gRhaM praviSTE lOkaprAcInAH sarvvE tatra pariSadi saMsthitAH| ");
INSERT INTO sancol_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","anantaraM sa tAn natvA svIyapracAraNEna bhinnadEzIyAn pratIzvarO yAni karmmANi sAdhitavAn tadIyAM kathAm anukramAt kathitavAn| ");
INSERT INTO sancol_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","iti zrutvA tE prabhuM dhanyaM prOcya vAkyamidam abhASanta, hE bhrAta ryihUdIyAnAM madhyE bahusahasrANi lOkA vizvAsina AsatE kintu tE sarvvE vyavasthAmatAcAriNa Etat pratyakSaM pazyasi| ");
INSERT INTO sancol_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","zizUnAM tvakchEdanAdyAcaraNaM pratiSidhya tvaM bhinnadEzanivAsinO yihUdIyalOkAn mUsAvAkyam azraddhAtum upadizasIti taiH zrutamasti| ");
INSERT INTO sancol_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","tvamatrAgatOsIti vArttAM samAkarNya jananivahO militvAvazyamEvAgamiSyati; ataEva kiM karaNIyam? atra vayaM mantrayitvA samupAyaM tvAM vadAmastaM tvamAcara| ");
INSERT INTO sancol_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","vrataM karttuM kRtasagkalpA yE'smAMka catvArO mAnavAH santi ");
INSERT INTO sancol_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","tAn gRhItvA taiH sahitaH svaM zuciM kuru tathA tESAM zirOmuNPanE yO vyayO bhavati taM tvaM dEhi| tathA kRtE tvadIyAcArE yA janazruti rjAyatE sAlIkA kintu tvaM vidhiM pAlayan vyavasthAnusArENEvAcarasIti tE bhOtsantE| ");
INSERT INTO sancol_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","bhinnadEzIyAnAM vizvAsilOkAnAM nikaTE vayaM patraM likhitvEtthaM sthirIkRtavantaH, dEvaprasAdabhOjanaM raktaM galapIPanamAritaprANibhOjanaM vyabhicArazcaitEbhyaH svarakSaNavyatirEkENa tESAmanyavidhipAlanaM karaNIyaM na| ");
INSERT INTO sancol_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","tataH paulastAn mAnuSAnAdAya parasmin divasE taiH saha zuci rbhUtvA mandiraM gatvA zaucakarmmaNO dinESu sampUrNESu tESAm EkaikArthaM naivEdyAdyutsargO bhaviSyatIti jnjApitavAn| ");
INSERT INTO sancol_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","tESu saptasu dinESu samAptakalpESu AziyAdEzanivAsinO yihUdIyAstaM madhyEmandiraM vilOkya jananivahasya manaHsu kupravRttiM janayitvA taM dhRtvA ");
INSERT INTO sancol_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","prOccaiH prAvOcan, hE isrAyEllOkAH sarvvE sAhAyyaM kuruta| yO manuja EtESAM lOkAnAM mUsAvyavasthAyA Etasya sthAnasyApi viparItaM sarvvatra sarvvAn zikSayati sa ESaH; vizESataH sa bhinnadEzIyalOkAn mandiram AnIya pavitrasthAnamEtad apavitramakarOt| ");
INSERT INTO sancol_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","pUrvvaM tE madhyEnagaram iphiSanagarIyaM traphimaM paulEna sahitaM dRSTavanta EtasmAt paulastaM mandiramadhyam Anayad ityanvamimata| ");
INSERT INTO sancol_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","ataEva sarvvasmin nagarE kalahOtpannatvAt dhAvantO lOkA Agatya paulaM dhRtvA mandirasya bahirAkRSyAnayan tatkSaNAd dvArANi sarvvANi ca ruddhAni| ");
INSERT INTO sancol_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","tESu taM hantumudyatEेSu yirUzAlamnagarE mahAnupadravO jAta iti vArttAyAM sahasrasEnApatEH karNagOcarIbhUtAyAM satyAM sa tatkSaNAt sainyAni sEnApatigaNanjca gRhItvA javEnAgatavAn| ");
INSERT INTO sancol_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","tatO lOkAH sEnAgaNEna saha sahasrasEnApatim AgacchantaM dRSTvA paulatAPanAtO nyavarttanta| ");
INSERT INTO sancol_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","sa sahasrasEnApatiH sannidhAvAgamya paulaM dhRtvA zRgkhaladvayEna baddham Adizya tAn pRSTavAn ESa kaH? kiM karmma cAyaM kRtavAn? ");
INSERT INTO sancol_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","tatO janasamUhasya kazcid EkaprakAraM kazcid anyaprakAraM vAkyam araut sa tatra satyaM jnjAtum kalahakAraNAd azaktaH san taM durgaM nEtum AjnjApayat| ");
INSERT INTO sancol_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","tESu sOpAnasyOpari prAptESu lOkAnAM sAhasakAraNAt sEnAgaNaH paulamuttOlya nItavAn| ");
INSERT INTO sancol_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","tataH sarvvE lOkAH pazcAdgAminaH santa EnaM durIkurutEti vAkyam uccairavadan| ");
INSERT INTO sancol_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","paulasya durgAnayanasamayE sa tasmai sahasrasEnApatayE kathitavAn, bhavataH purastAt kathAM kathayituM kim anumanyatE? sa tamapRcchat tvaM kiM yUnAnIyAM bhASAM jAnAsi? ");
INSERT INTO sancol_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","yO misarIyO janaH pUrvvaM virOdhaM kRtvA catvAri sahasrANi ghAtakAn sagginaH kRtvA vipinaM gatavAn tvaM kiM saEva na bhavasi? ");
INSERT INTO sancol_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","tadA paulO'kathayat ahaM kilikiyAdEzasya tArSanagarIyO yihUdIyO, nAhaM sAmAnyanagarIyO mAnavaH; ataEva vinayE'haM lAkAnAM samakSaM kathAM kathayituM mAmanujAnISva| ");
INSERT INTO sancol_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","tEnAnujnjAtaH paulaH sOpAnOpari tiSThan hastEnEggitaM kRtavAn, tasmAt sarvvE susthirA abhavan| tadA paula ibrIyabhASayA kathayitum Arabhata, ");
INSERT INTO sancol_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","hE pitRgaNA hE bhrAtRgaNAH, idAnIM mama nivEdanE samavadhatta| ");
INSERT INTO sancol_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","tadA sa ibrIyabhASayA kathAM kathayatIti zrutvA sarvvE lOkA atIva niHzabdA santO'tiSThan| ");
INSERT INTO sancol_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","pazcAt sO'kathayad ahaM yihUdIya iti nizcayaH kilikiyAdEzasya tArSanagaraM mama janmabhUmiH,EtannagarIyasya gamilIyElanAmnO'dhyApakasya ziSyO bhUtvA pUrvvapuruSANAM vidhivyavasthAnusArENa sampUrNarUpENa zikSitO'bhavam idAnIntanA yUyaM yAdRzA bhavatha tAdRzO'hamapIzvarasEvAyAm udyOgI jAtaH| ");
INSERT INTO sancol_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","matamEtad dviSTvA tadgrAhinArIpuruSAn kArAyAM baddhvA tESAM prANanAzaparyyantAM vipakSatAm akaravam| ");
INSERT INTO sancol_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","mahAyAjakaH sabhAsadaH prAcInalOkAzca mamaitasyAH kathAyAH pramANaM dAtuM zaknuvanti, yasmAt tESAM samIpAd dammESakanagaranivAsibhrAtRgaNArtham AjnjApatrANi gRhItvA yE tatra sthitAstAn daNPayituM yirUzAlamam AnayanArthaM dammESakanagaraM gatOsmi| ");
INSERT INTO sancol_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","kintu gacchan tannagarasya samIpaM prAptavAn tadA dvitIyapraharavElAyAM satyAm akasmAd gagaNAnnirgatya mahatI dIpti rmama caturdizi prakAzitavatI| ");
INSERT INTO sancol_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","tatO mayi bhUmauै patitE sati, hE zaula hE zaula kutO mAM tAPayasi? mAmprati bhASita EtAdRza EkO ravOpi mayA zrutaH| ");
INSERT INTO sancol_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","tadAhaM pratyavadaM, hE prabhE kO bhavAn? tataH sO'vAdIt yaM tvaM tAPayasi sa nAsaratIyO yIzurahaM| ");
INSERT INTO sancol_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","mama sagginO lOkAstAM dIptiM dRSTvA bhiyaM prAptAH, kintu mAmpratyuditaM tadvAkyaM tEे nAbudhyanta| ");
INSERT INTO sancol_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","tataH paraM pRSTavAnahaM, hE prabhO mayA kiM karttavyaM? tataH prabhurakathayat, utthAya dammESakanagaraM yAhi tvayA yadyat karttavyaM nirUpitamAstE tat tatra tvaM jnjApayiSyasE| ");
INSERT INTO sancol_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","anantaraM tasyAH kharataradIptEH kAraNAt kimapi na dRSTvA saggigaNEna dhRtahastaH san dammESakanagaraM vrajitavAn| ");
INSERT INTO sancol_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","tannagaranivAsinAM sarvvESAM yihUdIyAnAM mAnyO vyavasthAnusArENa bhaktazca hanAnIyanAmA mAnava EkO ");
INSERT INTO sancol_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","mama sannidhim Etya tiSThan akathayat, hE bhrAtaH zaula sudRSTi rbhava tasmin daNPE'haM samyak taM dRSTavAn| ");
INSERT INTO sancol_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","tataH sa mahyaM kathitavAn yathA tvam IzvarasyAbhiprAyaM vEtsi tasya zuddhasattvajanasya darzanaM prApya tasya zrImukhasya vAkyaM zRNOSi tannimittam asmAkaM pUrvvapuruSANAm IzvarastvAM manOnItaM kRtavAnaM| ");
INSERT INTO sancol_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","yatO yadyad adrAkSIrazrauSIzca sarvvESAM mAnavAnAM samIpE tvaM tESAM sAkSI bhaviSyasi| ");
INSERT INTO sancol_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","ataEva kutO vilambasE? prabhO rnAmnA prArthya nijapApaprakSAlanArthaM majjanAya samuttiSTha| ");
INSERT INTO sancol_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","tataH paraM yirUzAlamnagaraM pratyAgatya mandirE'ham EkadA prArthayE, tasmin samayE'ham abhibhUtaH san prabhUM sAkSAt pazyan, ");
INSERT INTO sancol_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","tvaM tvarayA yirUzAlamaH pratiSThasva yatO lOkAmayi tava sAkSyaM na grahISyanti, mAmpratyuditaM tasyEdaM vAkyam azrauSam| ");
INSERT INTO sancol_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","tatOhaM pratyavAdiSam hE prabhO pratibhajanabhavanaM tvayi vizvAsinO lOkAn baddhvA prahRtavAn, ");
INSERT INTO sancol_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","tathA tava sAkSiNaH stiphAnasya raktapAtanasamayE tasya vinAzaM sammanya sannidhau tiSThan hantRlOkAnAM vAsAMsi rakSitavAn, Etat tE viduH| ");
INSERT INTO sancol_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","tataH sO'kathayat pratiSThasva tvAM dUrasthabhinnadEzIyAnAM samIpaM prESayiSyE| ");
INSERT INTO sancol_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","tadA lOkA EtAvatparyyantAM tadIyAM kathAM zrutvA prOccairakathayan, EnaM bhUmaNPalAd dUrIkuruta, EtAdRzajanasya jIvanaM nOcitam| ");
INSERT INTO sancol_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ityuccaiH kathayitvA vasanAni parityajya gagaNaM prati dhUlIrakSipan ");
INSERT INTO sancol_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","tataH sahasrasEnApatiH paulaM durgAbhyantara nEtuM samAdizat| Etasya pratikUlAH santO lOkAH kinnimittam EtAvaduccaiHsvaram akurvvan, Etad vEttuM taM kazayA prahRtya tasya parIkSAM karttumAdizat| ");
INSERT INTO sancol_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","padAtayazcarmmanirmmitarajjubhistasya bandhanaM karttumudyatAstAstadAnIM paulaH sammukhasthitaM zatasEnApatim uktavAn daNPAjnjAyAm aprAptAyAM kiM rOmilOkaM praharttuM yuSmAkam adhikArOsti? ");
INSERT INTO sancol_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","EnAM kathAM zrutvA sa sahasrasEnApatEH sannidhiM gatvA tAM vArttAmavadat sa rOmilOka EtasmAt sAvadhAnaH san karmma kuru| ");
INSERT INTO sancol_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","tasmAt sahasrasEnApati rgatvA tamaprAkSIt tvaM kiM rOmilOkaH? iti mAM brUhi| sO'kathayat satyam| ");
INSERT INTO sancol_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","tataH sahasrasEnApatiH kathitavAn bahudraviNaM dattvAhaM tat paurasakhyaM prAptavAn; kintu paulaH kathitavAn ahaM janunA tat prAptO'smi| ");
INSERT INTO sancol_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","itthaM sati yE prahArENa taM parIkSituM samudyatA Asan tE tasya samIpAt prAtiSThanta; sahasrasEnApatistaM rOmilOkaM vijnjAya svayaM yat tasya bandhanam akArSIt tatkAraNAd abibhEt| ");
INSERT INTO sancol_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","yihUdIyalOkAH paulaM kutO'pavadantE tasya vRttAntaM jnjAtuM vAnjchan sahasrasEnApatiH parE'hani paulaM bandhanAt mOcayitvA pradhAnayAjakAn mahAsabhAyAH sarvvalOkAzca samupasthAtum Adizya tESAM sannidhau paulam avarOhya sthApitavAn| ");
INSERT INTO sancol_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","sabhAsadlOkAn prati paulO'nanyadRSTyA pazyan akathayat, hE bhrAtRgaNA adya yAvat saralEna sarvvAntaHkaraNEnEzvarasya sAkSAd AcarAmi| ");
INSERT INTO sancol_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","anEna hanAnIyanAmA mahAyAjakastaM kapOlE capETEnAhantuM samIpasthalOkAn AdiSTavAn| ");
INSERT INTO sancol_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","tadA paulastamavadat, hE bahiSpariSkRta, IzvarastvAM praharttum udyatOsti, yatO vyavasthAnusArENa vicArayitum upavizya vyavasthAM lagghitvA mAM praharttum AjnjApayasi| ");
INSERT INTO sancol_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","tatO nikaTasthA lOkA akathayan, tvaM kim Izvarasya mahAyAjakaM nindasi? ");
INSERT INTO sancol_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","tataH paulaH pratibhASitavAn hE bhrAtRgaNa mahAyAjaka ESa iti na buddhaM mayA tadanyacca svalOkAnAm adhipatiM prati durvvAkyaM mA kathaya, EtAdRzI lipirasti| ");
INSERT INTO sancol_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","anantaraM paulastESAm arddhaM sidUkilOkA arddhaM phirUzilOkA iti dRSTvA prOccaiH sabhAsthalOkAn avadat hE bhrAtRgaNa ahaM phirUzimatAvalambI phirUzinaH satnAnazca, mRtalOkAnAm utthAnE pratyAzAkaraNAd ahamapavAditOsmi| ");
INSERT INTO sancol_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","iti kathAyAM kathitAyAM phirUzisidUkinOH parasparaM bhinnavAkyatvAt sabhAyA madhyE dvau saMghau jAtau| ");
INSERT INTO sancol_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","yataH sidUkilOkA utthAnaM svargIyadUtA AtmAnazca sarvvESAm EtESAM kamapi na manyantE, kintu phirUzinaH sarvvam aggIkurvvanti| ");
INSERT INTO sancol_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","tataH parasparam atizayakOlAhalE samupasthitE phirUzinAM pakSIyAH sabhAsthA adhyApakAH pratipakSA uttiSThantO 'kathayan, Etasya mAnavasya kamapi dOSaM na pazyAmaH; yadi kazcid AtmA vA kazcid dUta EnaM pratyAdizat tarhi vayam Izvarasya prAtikUlyEna na yOtsyAmaH| ");
INSERT INTO sancol_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","tasmAd atIva bhinnavAkyatvE sati tE paulaM khaNPaM khaNPaM kariSyantItyAzagkayA sahasrasEnApatiH sEnAgaNaM tatsthAnaM yAtuM sabhAtO balAt paulaM dhRtvA durgaM nEtanjcAjnjApayat| ");
INSERT INTO sancol_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","rAtrO prabhustasya samIpE tiSThan kathitavAn hE paula nirbhayO bhava yathA yirUzAlamnagarE mayi sAkSyaM dattavAn tathA rOmAnagarEpi tvayA dAtavyam| ");
INSERT INTO sancol_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","dinE samupasthitE sati kiyantO yihUdIyalOkA EkamantraNAH santaH paulaM na hatvA bhOjanapAnE kariSyAma iti zapathEna svAn abadhnan| ");
INSERT INTO sancol_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","catvAriMzajjanEbhyO'dhikA lOkA iti paNam akurvvan| ");
INSERT INTO sancol_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","tE mahAyAjakAnAM prAcInalOkAnAnjca samIpaM gatvA kathayan, vayaM paulaM na hatvA kimapi na bhOkSyAmahE dRPhEnAnEna zapathEna baddhvA abhavAma| ");
INSERT INTO sancol_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","ataEva sAmprataM sabhAsadlOkaiH saha vayaM tasmin kanjcid vizESavicAraM kariSyAmastadarthaM bhavAn zvO 'smAkaM samIpaM tam Anayatviti sahasrasEnApatayE nivEdanaM kuruta tEna yuSmAkaM samIpaM upasthitEH pUrvvaM vayaM taM hantu sajjiSyAma| ");
INSERT INTO sancol_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","tadA paulasya bhAginEyastESAmiti mantraNAM vijnjAya durgaM gatvA tAM vArttAM paulam uktavAn| ");
INSERT INTO sancol_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","tasmAt paula EkaM zatasEnApatim AhUya vAkyamidam bhASitavAn sahasrasEnApatEH samIpE'sya yuvamanuSyasya kinjcinnivEdanam AstE, tasmAt tatsavidham EnaM naya| ");
INSERT INTO sancol_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","tataH sa tamAdAya sahasrasEnApatEH samIpam upasthAya kathitavAn, bhavataH samIpE'sya kimapi nivEdanamAstE tasmAt bandiH paulO mAmAhUya bhavataH samIpam Enam AnEtuM prArthitavAn| ");
INSERT INTO sancol_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","tadA sahasrasEnApatistasya hastaM dhRtvA nirjanasthAnaM nItvA pRSThavAn tava kiM nivEdanaM? tat kathaya| ");
INSERT INTO sancol_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","tataH sOkathayat, yihUdIyalAkAH paulE kamapi vizESavicAraM chalaM kRtvA taM sabhAM nEtuM bhavataH samIpE nivEdayituM amantrayan| ");
INSERT INTO sancol_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","kintu mavatA tanna svIkarttavyaM yatastESAM madhyEvarttinazcatvAriMzajjanEbhyO 'dhikalOkA EkamantraNA bhUtvA paulaM na hatvA bhOjanaM pAnanjca na kariSyAma iti zapathEna baddhAH santO ghAtakA iva sajjitA idAnIM kEvalaM bhavatO 'numatim apEkSantE| ");
INSERT INTO sancol_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","yAmimAM kathAM tvaM nivEditavAn tAM kasmaicidapi mA kathayEtyuktvA sahasrasEnApatistaM yuvAnaM visRSTavAn| ");
INSERT INTO sancol_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","anantaraM sahasrasEnApati rdvau zatasEnApatI AhUyEdam Adizat, yuvAM rAtrau praharaikAvaziSTAyAM satyAM kaisariyAnagaraM yAtuM padAtisainyAnAM dvE zatE ghOTakArOhisainyAnAM saptatiM zaktidhArisainyAnAM dvE zatE ca janAn sajjitAn kurutaM| ");
INSERT INTO sancol_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","paulam ArOhayituM phIlikSAdhipatEH samIpaM nirvvighnaM nEtunjca vAhanAni samupasthApayataM| ");
INSERT INTO sancol_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","aparaM sa patraM likhitvA dattavAn tallikhitamEtat, ");
INSERT INTO sancol_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","mahAmahimazrIyuktaphIlikSAdhipatayE klaudiyaluSiyasya namaskAraH| ");
INSERT INTO sancol_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","yihUdIyalOkAH pUrvvam EnaM mAnavaM dhRtvA svahastai rhantum udyatA EtasminnantarE sasainyOhaM tatrOpasthAya ESa janO rOmIya iti vijnjAya taM rakSitavAn| ");
INSERT INTO sancol_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","kinnimittaM tE tamapavadantE tajjnjAtuM tESA sabhAM tamAnAyitavAn| ");
INSERT INTO sancol_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","tatastESAM vyavasthAyA viruddhayA kayAcana kathayA sO'pavAditO'bhavat, kintu sa zRgkhalabandhanArhO vA prANanAzArhO bhavatIdRzaH kOpyaparAdhO mayAsya na dRSTaH| ");
INSERT INTO sancol_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","tathApi manuSyasyAsya vadhArthaM yihUdIyA ghAtakAiva sajjitA EtAM vArttAM zrutvA tatkSaNAt tava samIpamEnaM prESitavAn asyApavAdakAMzca tava samIpaM gatvApavaditum AjnjApayam| bhavataH kuzalaM bhUyAt| ");
INSERT INTO sancol_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","sainyagaNa AjnjAnusArENa paulaM gRhItvA tasyAM rajanyAm AntipAtrinagaram Anayat| ");
INSERT INTO sancol_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","parE'hani tEna saha yAtuM ghOTakArUPhasainyagaNaM sthApayitvA parAvRtya durgaM gatavAn| ");
INSERT INTO sancol_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","tataH parE ghOTakArOhisainyagaNaH kaisariyAnagaram upasthAya tatpatram adhipatEH karE samarpya tasya samIpE paulam upasthApitavAn| ");
INSERT INTO sancol_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","tadAdhipatistatpatraM paThitvA pRSThavAn ESa kimpradEzIyO janaH? sa kilikiyApradEzIya EkO jana iti jnjAtvA kathitavAn, ");
INSERT INTO sancol_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","tavApavAdakagaNa AgatE tava kathAM zrOSyAmi| hErOdrAjagRhE taM sthApayitum AdiSTavAn| ");
INSERT INTO sancol_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","panjcabhyO dinEbhyaH paraM hanAnIyanAmA mahAyAjakO'dhipatEH samakSaM paulasya prAtikUlyEna nivEdayituM tartullanAmAnaM kanjcana vaktAraM prAcInajanAMzca sagginaH kRtvA kaisariyAnagaram Agacchat| ");
INSERT INTO sancol_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","tataH paulE samAnItE sati tartullastasyApavAdakathAM kathayitum Arabhata hE mahAmahimaphIlikSa bhavatO vayam atinirvvighnaM kAlaM yApayAmO bhavataH pariNAmadarzitayA EtaddEzIyAnAM bahUni maggalAni ghaTitAni, ");
INSERT INTO sancol_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","iti hEtO rvayamatikRtajnjAH santaH sarvvatra sarvvadA bhavatO guNAn gAyamaH| ");
INSERT INTO sancol_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","kintu bahubhiH kathAbhi rbhavantaM yEna na viranjjayAmi tasmAd vinayE bhavAn banukampya madalpakathAM zRNOtu| ");
INSERT INTO sancol_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","ESa mahAmArIsvarUpO nAsaratIyamatagrAhisaMghAtasya mukhyO bhUtvA sarvvadEzESu sarvvESAM yihUdIyAnAM rAjadrOhAcaraNapravRttiM janayatItyasmAbhi rnizcitaM| ");
INSERT INTO sancol_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","sa mandiramapi azuci karttuM cESTitavAn; iti kAraNAd vayam EnaM dhRtvA svavyavasthAnusArENa vicArayituM prAvarttAmahi; ");
INSERT INTO sancol_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","kintu luSiyaH sahasrasEnApatirAgatya balAd asmAkaM karEbhya EnaM gRhItvA ");
INSERT INTO sancol_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","EtasyApavAdakAn bhavataH samIpam Agantum AjnjApayat| vayaM yasmin tamapavAdAmO bhavatA padapavAdakathAyAM vicAritAyAM satyAM sarvvaM vRttAntaM vEdituM zakSyatE| ");
INSERT INTO sancol_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","tatO yihUdIyA api svIkRtya kathitavanta ESA kathA pramANam| ");
INSERT INTO sancol_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","adhipatau kathAM kathayituM paulaM pratIggitaM kRtavati sa kathitavAn bhavAn bahUn vatsarAn yAvad EtaddEzasya zAsanaM karOtIti vijnjAya pratyuttaraM dAtum akSObhO'bhavam| ");
INSERT INTO sancol_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","adya kEvalaM dvAdaza dinAni yAtAni, aham ArAdhanAM karttuM yirUzAlamanagaraM gatavAn ESA kathA bhavatA jnjAtuM zakyatE; ");
INSERT INTO sancol_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","kintvibhE mAM madhyEmandiraM kEnApi saha vitaNPAM kurvvantaM kutrApi bhajanabhavanE nagarE vA lOkAn kupravRttiM janayantuM na dRSTavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","idAnIM yasmin yasmin mAm apavadantE tasya kimapi pramANaM dAtuM na zaknuvanti| ");
INSERT INTO sancol_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","kintu bhaviSyadvAkyagranthE vyavasthAgranthE ca yA yA kathA likhitAstE tAsu sarvvAsu vizvasya yanmatam imE vidharmmaM jAnanti tanmatAnusArENAhaM nijapitRpuruSANAm Izvaram ArAdhayAmItyahaM bhavataH samakSam aggIkarOmi| ");
INSERT INTO sancol_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","dhArmmikANAm adhArmmikANAnjca pramItalOkAnAmEvOtthAnaM bhaviSyatIti kathAmimE svIkurvvanti tathAhamapi tasmin IzvarE pratyAzAM karOmi; ");
INSERT INTO sancol_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Izvarasya mAnavAnAnjca samIpE yathA nirdOSO bhavAmi tadarthaM satataM yatnavAn asmi| ");
INSERT INTO sancol_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","bahuSu vatsarESu gatESu svadEzIyalOkAnAM nimittaM dAnIyadravyANi naivEdyAni ca samAdAya punarAgamanaM kRtavAn| ");
INSERT INTO sancol_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","tatOhaM zuci rbhUtvA lOkAnAM samAgamaM kalahaM vA na kAritavAn tathApyAziyAdEzIyAH kiyantO yihudIyalOkA madhyEmandiraM mAM dhRtavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","mamOpari yadi kAcidapavAdakathAsti tarhi bhavataH samIpam upasthAya tESAmEva sAkSyadAnam ucitam| ");
INSERT INTO sancol_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","nOcEt pUrvvE mahAsabhAsthAnAM lOkAnAM sannidhau mama daNPAyamAnatvasamayE, ahamadya mRtAnAmutthAnE yuSmAbhi rvicAritOsmi, ");
INSERT INTO sancol_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","tESAM madhyE tiSThannahaM yAmimAM kathAmuccaiH svarENa kathitavAn tadanyO mama kOpi dOSO'labhyata na vEti varam EtE samupasthitalOkA vadantu| ");
INSERT INTO sancol_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","tadA phIlikSa EtAM kathAM zrutvA tanmatasya vizESavRttAntaM vijnjAtuM vicAraM sthagitaM kRtvA kathitavAn luSiyE sahasrasEnApatau samAyAtE sati yuSmAkaM vicAram ahaM niSpAdayiSyAmi| ");
INSERT INTO sancol_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","anantaraM bandhanaM vinA paulaM rakSituM tasya sEvanAya sAkSAtkaraNAya vA tadIyAtmIyabandhujanAn na vArayitunjca zamasEnApatim AdiSTavAn| ");
INSERT INTO sancol_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","alpadinAt paraM phIlikSO'dhipati rdruSillAnAmnA yihUdIyayA svabhAryyayA sahAgatya paulamAhUya tasya mukhAt khrISTadharmmasya vRttAntam azrauSIt| ");
INSERT INTO sancol_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","paulEna nyAyasya parimitabhOgasya caramavicArasya ca kathAyAM kathitAyAM satyAM phIlikSaH kampamAnaH san vyAharad idAnIM yAhi, aham avakAzaM prApya tvAm AhUsyAmi| ");
INSERT INTO sancol_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","muktipraptyarthaM paulEna mahyaM mudrAdAsyantE iti patyAzAM kRtvA sa punaH punastamAhUya tEna sAkaM kathOpakathanaM kRtavAn| ");
INSERT INTO sancol_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","kintu vatsaradvayAt paraM parkiyaphISTa phAlikSasya padaM prAptE sati phIlikSO yihUdIyAn santuSTAn cikIrSan paulaM baddhaM saMsthApya gatavAn| ");
INSERT INTO sancol_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","anantaraM phISTO nijarAjyam Agatya dinatrayAt paraM kaisariyAtO yirUzAlamnagaram Agamat| ");
INSERT INTO sancol_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","tadA mahAyAjakO yihUdIyAnAM pradhAnalOkAzca tasya samakSaM paulam apAvadanta| ");
INSERT INTO sancol_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","bhavAn taM yirUzAlamam AnEtum AjnjApayatviti vinIya tE tasmAd anugrahaM vAnjchitavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","yataH pathimadhyE gOpanEna paulaM hantuM tai rghAtakA niyuktAH| phISTa uttaraM dattavAn paulaH kaisariyAyAM sthAsyati punaralpadinAt param ahaM tatra yAsyAmi| ");
INSERT INTO sancol_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","tatastasya mAnuSasya yadi kazcid aparAdhastiSThati tarhi yuSmAkaM yE zaknuvanti tE mayA saha tatra gatvA tamapavadantu sa EtAM kathAM kathitavAn| ");
INSERT INTO sancol_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","dazadivasEbhyO'dhikaM vilambya phISTastasmAt kaisariyAnagaraM gatvA parasmin divasE vicArAsana upadizya paulam AnEtum AjnjApayat| ");
INSERT INTO sancol_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","paulE samupasthitE sati yirUzAlamnagarAd AgatA yihUdIyalOkAstaM caturdizi saMvESTya tasya viruddhaM bahUn mahAdOSAn utthApitavantaH kintu tESAM kimapi pramANaM dAtuM na zaknuvantaH| ");
INSERT INTO sancol_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","tataH paulaH svasmin uttaramidam uditavAn, yihUdIyAnAM vyavasthAyA mandirasya kaisarasya vA pratikUlaM kimapi karmma nAhaM kRtavAn| ");
INSERT INTO sancol_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","kintu phISTO yihUdIyAn santuSTAn karttum abhilaSan paulam abhASata tvaM kiM yirUzAlamaM gatvAsmin abhiyOgE mama sAkSAd vicAritO bhaviSyasi? ");
INSERT INTO sancol_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","tataH paula uttaraM prOktavAn, yatra mama vicArO bhavituM yOgyaH kaisarasya tatra vicArAsana Eva samupasthitOsmi; ahaM yihUdIyAnAM kAmapi hAniM nAkArSam iti bhavAn yathArthatO vijAnAti| ");
INSERT INTO sancol_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","kanjcidaparAdhaM kinjcana vadhArhaM karmma vA yadyaham akariSyaM tarhi prANahananadaNPamapi bhOktum udyatO'bhaviSyaM, kintu tE mama samapavAdaM kurvvanti sa yadi kalpitamAtrO bhavati tarhi tESAM karESu mAM samarpayituM kasyApyadhikArO nAsti, kaisarasya nikaTE mama vicArO bhavatu| ");
INSERT INTO sancol_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","tadA phISTO mantribhiH sArddhaM saMmantrya paulAya kathitavAn, kaisarasya nikaTE kiM tava vicArO bhaviSyati? kaisarasya samIpaM gamiSyasi| ");
INSERT INTO sancol_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","kiyaddinEbhyaH param AgripparAjA barNIkI ca phISTaM sAkSAt karttuM kaisariyAnagaram Agatavantau| ");
INSERT INTO sancol_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","tadA tau bahudinAni tatra sthitau tataH phISTastaM rAjAnaM paulasya kathAM vijnjApya kathayitum Arabhata paulanAmAnam EkaM bandi phIlikSO baddhaM saMsthApya gatavAn| ");
INSERT INTO sancol_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","yirUzAlami mama sthitikAlE mahAyAjakO yihUdIyAnAM prAcInalOkAzca tam apOdya tamprati daNPAjnjAM prArthayanta| ");
INSERT INTO sancol_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","tatOham ityuttaram avadaM yAvad apOditO janaH svApavAdakAn sAkSAt kRtvA svasmin yO'parAdha ArOpitastasya pratyuttaraM dAtuM suyOgaM na prApnOti, tAvatkAlaM kasyApi mAnuSasya prANanAzAjnjApanaM rOmilOkAnAM rIti rnahi| ");
INSERT INTO sancol_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","tatastESvatrAgatESu parasmin divasE'ham avilambaM vicArAsana upavizya taM mAnuSam AnEtum AjnjApayam| ");
INSERT INTO sancol_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","tadanantaraM tasyApavAdakA upasthAya yAdRzam ahaM cintitavAn tAdRzaM kanjcana mahApavAdaM nOtthApya ");
INSERT INTO sancol_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","svESAM matE tathA paulO yaM sajIvaM vadati tasmin yIzunAmani mRtajanE ca tasya viruddhaM kathitavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","tatOhaM tAdRgvicArE saMzayAnaH san kathitavAn tvaM yirUzAlamaM gatvA kiM tatra vicAritO bhavitum icchasi? ");
INSERT INTO sancol_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","tadA paulO mahArAjasya nikaTE vicAritO bhavituM prArthayata, tasmAd yAvatkAlaM taM kaisarasya samIpaM prESayituM na zaknOmi tAvatkAlaM tamatra sthApayitum AdiSTavAn| ");
INSERT INTO sancol_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","tata AgrippaH phISTam uktavAn, ahamapi tasya mAnuSasya kathAM zrOtum abhilaSAmi| tadA phISTO vyAharat zvastadIyAM kathAM tvaM zrOSyasi| ");
INSERT INTO sancol_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","parasmin divasE AgrippO barNIkI ca mahAsamAgamaM kRtvA pradhAnavAhinIpatibhi rnagarasthapradhAnalOkaizca saha militvA rAjagRhamAgatya samupasthitau tadA phISTasyAjnjayA paula AnItO'bhavat| ");
INSERT INTO sancol_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","tadA phISTaH kathitavAn hE rAjan Agrippa hE upasthitAH sarvvE lOkA yirUzAlamnagarE yihUdIyalOkasamUhO yasmin mAnuSE mama samIpE nivEdanaM kRtvA prOccaiH kathAmimAM kathitavAn punaralpakAlamapi tasya jIvanaM nOcitaM tamEtaM mAnuSaM pazyata| ");
INSERT INTO sancol_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","kintvESa janaH prANanAzarhaM kimapi karmma na kRtavAn ityajAnAM tathApi sa mahArAjasya sannidhau vicAritO bhavituM prArthayata tasmAt tasya samIpaM taM prESayituM matimakaravam| ");
INSERT INTO sancol_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","kintu zrIyuktasya samIpam Etasmin kiM lEkhanIyam ityasya kasyacin nirNayasya na jAtatvAd Etasya vicArE sati yathAhaM lEkhituM kinjcana nizcitaM prApnOmi tadarthaM yuSmAkaM samakSaM vizESatO hE AgripparAja bhavataH samakSam Etam AnayE| ");
INSERT INTO sancol_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","yatO bandiprESaNasamayE tasyAbhiyOgasya kinjcidalEkhanam aham ayuktaM jAnAmi| ");
INSERT INTO sancol_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","tata AgrippaH paulam avAdIt, nijAM kathAM kathayituM tubhyam anumati rdIyatE| tasmAt paulaH karaM prasAryya svasmin uttaram avAdIt| ");
INSERT INTO sancol_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","hE AgripparAja yatkAraNAdahaM yihUdIyairapavAditO 'bhavaM tasya vRttAntam adya bhavataH sAkSAn nivEdayitumanumatOham idaM svIyaM paramaM bhAgyaM manyE; ");
INSERT INTO sancol_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","yatO yihUdIyalOkAnAM madhyE yA yA rItiH sUkSmavicArAzca santi tESu bhavAn vijnjatamaH; ataEva prArthayE dhairyyamavalambya mama nivEdanaM zRNOtu| ");
INSERT INTO sancol_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","ahaM yirUzAlamnagarE svadEzIyalOkAnAM madhyE tiSThan A yauvanakAlAd yadrUpam AcaritavAn tad yihUdIyalOkAH sarvvE vidanti| ");
INSERT INTO sancol_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","asmAkaM sarvvEbhyaH zuddhatamaM yat phirUzIyamataM tadavalambI bhUtvAhaM kAlaM yApitavAn yE janA A bAlyakAlAn mAM jAnAnti tE EtAdRzaM sAkSyaM yadi dadAti tarhi dAtuM zaknuvanti| ");
INSERT INTO sancol_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","kintu hE AgripparAja IzvarO'smAkaM pUrvvapuruSANAM nikaTE yad aggIkRtavAn tasya pratyAzAhEtOraham idAnIM vicArasthAnE daNPAyamAnOsmi| ");
INSERT INTO sancol_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","tasyAggIkArasya phalaM prAptum asmAkaM dvAdazavaMzA divAnizaM mahAyatnAd IzvarasEvanaM kRtvA yAM pratyAzAM kurvvanti tasyAH pratyAzAyA hEtOrahaM yihUdIyairapavAditO'bhavam| ");
INSERT INTO sancol_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","IzvarO mRtAn utthApayiSyatIti vAkyaM yuSmAkaM nikaTE'sambhavaM kutO bhavEt? ");
INSERT INTO sancol_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","nAsaratIyayIzO rnAmnO viruddhaM nAnAprakArapratikUlAcaraNam ucitam ityahaM manasi yathArthaM vijnjAya ");
INSERT INTO sancol_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","yirUzAlamanagarE tadakaravaM phalataH pradhAnayAjakasya nikaTAt kSamatAM prApya bahUn pavitralOkAn kArAyAM baddhavAn vizESatastESAM hananasamayE tESAM viruddhAM nijAM sammatiM prakAzitavAn| ");
INSERT INTO sancol_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","vAraM vAraM bhajanabhavanESu tEbhyO daNPaM pradattavAn balAt taM dharmmaM nindayitavAMzca punazca tAn prati mahAkrOdhAd unmattaH san vidEzIyanagarANi yAvat tAn tAPitavAn| ");
INSERT INTO sancol_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","itthaM pradhAnayAjakasya samIpAt zaktim AjnjApatranjca labdhvA dammESaknagaraM gatavAn| ");
INSERT INTO sancol_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","tadAhaM hE rAjan mArgamadhyE madhyAhnakAlE mama madIyasagginAM lOkAnAnjca catasRSu dikSu gagaNAt prakAzamAnAM bhAskaratOpi tEjasvatIM dIptiM dRSTavAn| ");
INSERT INTO sancol_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","tasmAd asmAsu sarvvESu bhUmau patitESu satsu hE zaula hai zaula kutO mAM tAPayasi? kaNTakAnAM mukhE pAdAhananaM tava duHsAdhyam ibrIyabhASayA gadita EtAdRza EkaH zabdO mayA zrutaH| ");
INSERT INTO sancol_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","tadAhaM pRSTavAn hE prabhO kO bhavAn? tataH sa kathitavAn yaM yIzuM tvaM tAPayasi sOhaM, ");
INSERT INTO sancol_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","kintu samuttiSTha tvaM yad dRSTavAn itaH punanjca yadyat tvAM darzayiSyAmi tESAM sarvvESAM kAryyANAM tvAM sAkSiNaM mama sEvakanjca karttum darzanam adAm| ");
INSERT INTO sancol_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","vizESatO yihUdIyalOkEbhyO bhinnajAtIyEbhyazca tvAM manOnItaM kRtvA tESAM yathA pApamOcanaM bhavati ");
INSERT INTO sancol_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","yathA tE mayi vizvasya pavitrIkRtAnAM madhyE bhAgaM prApnuvanti tadabhiprAyENa tESAM jnjAnacakSUMSi prasannAni karttuM tathAndhakArAd dIptiM prati zaitAnAdhikArAcca IzvaraM prati matIH parAvarttayituM tESAM samIpaM tvAM prESyAmi| ");
INSERT INTO sancol_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","hE AgripparAja EtAdRzaM svargIyapratyAdEzaM agrAhyam akRtvAhaM ");
INSERT INTO sancol_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","prathamatO dammESaknagarE tatO yirUzAlami sarvvasmin yihUdIyadEzE anyESu dEzESu ca yEेna lOkA matiM parAvarttya IzvaraM prati parAvarttayantE, manaHparAvarttanayOgyAni karmmANi ca kurvvanti tAdRzam upadEzaM pracAritavAn| ");
INSERT INTO sancol_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","EtatkAraNAd yihUdIyA madhyEmandiraM mAM dhRtvA hantum udyatAH| ");
INSERT INTO sancol_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","tathApi khrISTO duHkhaM bhuktvA sarvvESAM pUrvvaM zmazAnAd utthAya nijadEzIyAnAM bhinnadEzIyAnAnjca samIpE dIptiM prakAzayiSyati ");
INSERT INTO sancol_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","bhaviSyadvAdigaNO mUsAzca bhAvikAryyasya yadidaM pramANam adadurEtad vinAnyAM kathAM na kathayitvA IzvarAd anugrahaM labdhvA mahatAM kSudrANAnjca sarvvESAM samIpE pramANaM dattvAdya yAvat tiSThAmi| ");
INSERT INTO sancol_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","tasyamAM kathAM nizamya phISTa uccaiH svarENa kathitavAn hE paula tvam unmattOsi bahuvidyAbhyAsEna tvaM hatajnjAnO jAtaH| ");
INSERT INTO sancol_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","sa uktavAn hE mahAmahima phISTa nAham unmattaH kintu satyaM vivEcanIyanjca vAkyaM prastaumi| ");
INSERT INTO sancol_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","yasya sAkSAd akSObhaH san kathAM kathayAmi sa rAjA tadvRttAntaM jAnAti tasya samIpE kimapi guptaM nEti mayA nizcitaM budhyatE yatastad vijanE na kRtaM| ");
INSERT INTO sancol_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","hE AgripparAja bhavAn kiM bhaviSyadvAdigaNOktAni vAkyAni pratyEti? bhavAn pratyEti tadahaM jAnAmi| ");
INSERT INTO sancol_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","tata AgrippaH paulam abhihitavAn tvaM pravRttiM janayitvA prAyENa mAmapi khrISTIyaM karOSi| ");
INSERT INTO sancol_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","tataH sO'vAdIt bhavAn yE yE lOkAzca mama kathAm adya zRNvanti prAyENa iti nahi kintvEtat zRgkhalabandhanaM vinA sarvvathA tE sarvvE mAdRzA bhavantvitIzvasya samIpE prArthayE'ham| ");
INSERT INTO sancol_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","EtasyAM kathAyAM kathitAyAM sa rAjA sO'dhipati rbarNIkI sabhAsthA lOkAzca tasmAd utthAya ");
INSERT INTO sancol_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","gOpanE parasparaM vivicya kathitavanta ESa janO bandhanArhaM prANahananArhaM vA kimapi karmma nAkarOt| ");
INSERT INTO sancol_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","tata AgrippaH phISTam avadat, yadyESa mAnuSaH kaisarasya nikaTE vicAritO bhavituM na prArthayiSyat tarhi muktO bhavitum azakSyat| ");
INSERT INTO sancol_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","jalapathEnAsmAkam itOliyAdEzaM prati yAtrAyAM nizcitAyAM satyAM tE yUliyanAmnO mahArAjasya saMghAtAntargatasya sEnApatEH samIpE paulaM tadanyAn katinayajanAMzca samArpayan| ");
INSERT INTO sancol_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","vayam AdrAmuttIyaM pOtamEkam Aruhya AziyAdEzasya taTasamIpEna yAtuM matiM kRtvA laggaram utthApya pOtam amOcayAma; mAkidaniyAdEzasthathiSalanIkInivAsyAristArkhanAmA kazcid janO'smAbhiH sArddham AsIt| ");
INSERT INTO sancol_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","parasmin divasE 'smAbhiH sIdOnnagarE pOtE lAgitE tatra yUliyaH sEnApatiH paulaM prati saujanyaM pradarthya sAntvanArthaM bandhubAndhavAn upayAtum anujajnjau| ");
INSERT INTO sancol_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","tasmAt pOtE mOcitE sati sammukhavAyOH sambhavAd vayaM kuprOpadvIpasya tIrasamIpEna gatavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","kilikiyAyAH pAmphUliyAyAzca samudrasya pAraM gatvA lUkiyAdEzAntargataM murAnagaram upAtiSThAma| ");
INSERT INTO sancol_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","tatsthAnAd itAliyAdEzaM gacchati yaH sikandariyAnagarasya pOtastaM tatra prApya zatasEnApatistaM pOtam asmAn ArOhayat| ");
INSERT INTO sancol_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","tataH paraM bahUni dinAni zanaiH zanaiH rgatvA knIdapArzvOpasthtiेH pUrvvaM pratikUlEna pavanEna vayaM salmOnyAH sammukham upasthAya krItyupadvIpasya tIrasamIpEna gatavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","kaSTEna tamuttIryya lAsEyAnagarasyAdhaH sundaranAmakaM khAtam upAtiSThAma| ");
INSERT INTO sancol_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","itthaM bahutithaH kAlO yApita upavAsadinanjcAtItaM, tatkAraNAt nauvartmani bhayagkarE sati paulO vinayEna kathitavAn, ");
INSERT INTO sancol_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","hE mahEcchA ahaM nizcayaM jAnAmi yAtrAyAmasyAm asmAkaM klEzA bahUnAmapacayAzca bhaviSyanti, tE kEvalaM pOtasAmagryOriti nahi, kintvasmAkaM prANAnAmapi| ");
INSERT INTO sancol_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","tadA zatasEnApatiH pauैेlOktavAkyatOpi karNadhArasya pOtavaNijazca vAkyaM bahumaMsta| ");
INSERT INTO sancol_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","tat khAtaM zItakAlE vAsArhasthAnaM na tasmAd avAcIpratIcOrdizOH krItyAH phainIkiyakhAtaM yAtuM yadi zaknuvantastarhi tatra zItakAlaM yApayituM prAyENa sarvvE mantrayAmAsuH| ");
INSERT INTO sancol_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","tataH paraM dakSiNavAyu rmandaM vahatIti vilOkya nijAbhiprAyasya siddhEH suyOgO bhavatIti buddhvA pOtaM mOcayitvA krItyupadvIpasya tIrasamIpEna calitavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","kintvalpakSaNAt paramEva urakludOnnAmA pratikUlaH pracaNPO vAyu rvahan pOtE'lagIt ");
INSERT INTO sancol_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","tasyAbhimukhaM gantum pOtasyAzaktatvAd vayaM vAyunA svayaM nItAH| ");
INSERT INTO sancol_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","anantaraM klaudInAmna upadvIpasya kUlasamIpEna pOtaM gamayitvA bahunA kaSTEna kSudranAvam arakSAma| ");
INSERT INTO sancol_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","tE tAmAruhya rajjcA pOtasyAdhObhAgam abadhnan tadanantaraM cEt pOtO saikatE lagatIti bhayAd vAtavasanAnyamOcayan tataH pOtO vAyunA cAlitaH| ");
INSERT INTO sancol_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","kintu kramazO vAyOH prabalatvAt pOtO dOlAyamAnO'bhavat parasmin divasE pOtasthAni katipayAni dravyANi tOyE nikSiptAni| ");
INSERT INTO sancol_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","tRtIyadivasE vayaM svahastaiH pOtasajjanadravyANi nikSiptavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","tatO bahudinAni yAvat sUryyanakSatrAdIni samAcchannAni tatO 'tIva vAtyAgamAd asmAkaM prANarakSAyAH kApi pratyAzA nAtiSThat| ");
INSERT INTO sancol_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","bahudinESu lOkairanAhArENa yApitESu sarvvESAM sAkSat paulastiSThan akathayat, hE mahEcchAH krItyupadvIpAt pOtaM na mOcayitum ahaM pUrvvaM yad avadaM tadgrahaNaM yuSmAkam ucitam AsIt tathA kRtE yuSmAkam ESA vipad ESO'pacayazca nAghaTiSyEtAm| ");
INSERT INTO sancol_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","kintu sAmprataM yuSmAn vinIya bravImyahaM, yUyaM na kSubhyata yuSmAkam EkasyApi prANinO hAni rna bhaviSyati, kEvalasya pOtasya hAni rbhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","yatO yasyEzvarasya lOkO'haM yanjcAhaM paricarAmi tadIya EkO dUtO hyO rAtrau mamAntikE tiSThan kathitavAn, ");
INSERT INTO sancol_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","hE paula mA bhaiSIH kaisarasya sammukhE tvayOpasthAtavyaM; tavaitAn sagginO lOkAn IzvarastubhyaM dattavAn| ");
INSERT INTO sancol_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","ataEva hE mahEcchA yUyaM sthiramanasO bhavata mahyaM yA kathAkathi sAvazyaM ghaTiSyatE mamaitAdRzI vizvAsa IzvarE vidyatE, ");
INSERT INTO sancol_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","kintu kasyacid upadvIpasyOpari patitavyam asmAbhiH| ");
INSERT INTO sancol_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","tataH param AdriyAsamudrE pOtastathaiva dOlAyamAnaH san itastatO gacchan caturdazadivasasya rAtrE rdvitIyapraharasamayE kasyacit sthalasya samIpamupatiSThatIti pOtIyalOkA anvamanyanta| ");
INSERT INTO sancol_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","tatastE jalaM parimAya tatra viMzati rvyAmA jalAnIti jnjAtavantaH| kinjciddUraM gatvA punarapi jalaM parimitavantaH| tatra panjcadaza vyAmA jalAni dRSTvA ");
INSERT INTO sancol_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","cEt pASANE lagatIti bhayAt pOtasya pazcAdbhAgatazcaturO laggarAn nikSipya divAkaram apEkSya sarvvE sthitavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","kintu pOtIyalOkAH pOtAgrabhAgE laggaranikSEpaM chalaM kRtvA jaladhau kSudranAvam avarOhya palAyitum acESTanta| ");
INSERT INTO sancol_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","tataH paulaH sEnApatayE sainyagaNAya ca kathitavAn, EtE yadi pOtamadhyE na tiSThanti tarhi yuSmAkaM rakSaNaM na zakyaM| ");
INSERT INTO sancol_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","tadA sEnAgaNO rajjUn chitvA nAvaM jalE patitum adadAt| ");
INSERT INTO sancol_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","prabhAtasamayE paulaH sarvvAn janAn bhOjanArthaM prArthya vyAharat, adya caturdazadinAni yAvad yUyam apEkSamAnA anAhArAH kAlam ayApayata kimapi nAbhuMgdhaM| ");
INSERT INTO sancol_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","atO vinayEे'haM bhakSyaM bhujyatAM tatO yuSmAkaM maggalaM bhaviSyati, yuSmAkaM kasyacijjanasya zirasaH kEzaikOpi na naMkSyati| ");
INSERT INTO sancol_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","iti vyAhRtya paulaM pUpaM gRhItvEzvaraM dhanyaM bhASamANastaM bhaMktvA bhOktum ArabdhavAn| ");
INSERT INTO sancol_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","anantaraM sarvvE ca susthirAH santaH khAdyAni parpyagRhlan| ");
INSERT INTO sancol_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","asmAkaM pOtE SaTsaptatyadhikazatadvayalOkA Asan| ");
INSERT INTO sancol_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","sarvvESu lOkESu yathESTaM bhuktavatsu pOtasthan gOdhUmAn jaladhau nikSipya taiH pOtasya bhArO laghUkRtaH| ");
INSERT INTO sancol_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","dinE jAtE'pi sa kO dEza iti tadA na paryyacIyata; kintu tatra samataTam EkaM khAtaM dRSTvA yadi zaknumastarhi vayaM tasyAbhyantaraM pOtaM gamayAma iti matiM kRtvA tE laggarAn chittvA jaladhau tyaktavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","tathA karNabandhanaM mOcayitvA pradhAnaM vAtavasanam uttOlya tIrasamIpaM gatavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","kintu dvayOH samudrayOH saggamasthAnE saikatOpari pOtE nikSiptE 'grabhAgE bAdhitE pazcAdbhAgE prabalataraggO'lagat tEna pOtO bhagnaH| ");
INSERT INTO sancol_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","tasmAd bandayazcEd bAhubhistarantaH palAyantE ityAzagkayA sEnAgaNastAn hantum amantrayat; ");
INSERT INTO sancol_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","kintu zatasEnApatiH paulaM rakSituM prayatnaM kRtvA tAn taccESTAyA nivartya ityAdiSTavAn, yE bAhutaraNaM jAnanti tE'grE prOllampya samudrE patitvA bAhubhistIrttvA kUlaM yAntu| ");
INSERT INTO sancol_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","aparam avaziSTA janAH kASThaM pOtIyaM dravyaM vA yEna yat prApyatE tadavalambya yAntu; itthaM sarvvE bhUmiM prApya prANai rjIvitAH| ");
INSERT INTO sancol_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","itthaM sarvvESu rakSAM prAptESu tatratyOpadvIpasya nAma milItEti tE jnjAtavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","asabhyalOkA yathESTam anukampAM kRtvA varttamAnavRSTEH zItAcca vahniM prajjvAlyAsmAkam Atithyam akurvvan| ");
INSERT INTO sancol_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","kintu paula indhanAni saMgRhya yadA tasmin agrau nirakSipat, tadA vahnEH pratApAt EkaH kRSNasarpO nirgatya tasya hastE draSTavAn| ");
INSERT INTO sancol_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","tE'sabhyalOkAstasya hastE sarpam avalambamAnaM dRSTvA parasparam uktavanta ESa janO'vazyaM narahA bhaviSyati, yatO yadyapi jaladhE rakSAM prAptavAn tathApi pratiphaladAyaka EnaM jIvituM na dadAti| ");
INSERT INTO sancol_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","kintu sa hastaM vidhunvan taM sarpam agnimadhyE nikSipya kAmapi pIPAM nAptavAn| ");
INSERT INTO sancol_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","tatO viSajvAlayA Etasya zarIraM sphItaM bhaviSyati yadvA haThAdayaM prANAn tyakSyatIti nizcitya lOkA bahukSaNAni yAvat tad draSTuM sthitavantaH kintu tasya kasyAzcid vipadO'ghaTanAt tE tadviparItaM vijnjAya bhASitavanta ESa kazcid dEvO bhavEt| ");
INSERT INTO sancol_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","publiyanAmA jana EkastasyOpadvIpasyAdhipatirAsIt tatra tasya bhUmyAdi ca sthitaM| sa janO'smAn nijagRhaM nItvA saujanyaM prakAzya dinatrayaM yAvad asmAkaM Atithyam akarOt| ");
INSERT INTO sancol_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","tadA tasya publiyasya pitA jvarAtisArENa pIPyamAnaH san zayyAyAm AsIt; tataH paulastasya samIpaM gatvA prArthanAM kRtvA tasya gAtrE hastaM samarpya taM svasthaM kRtavAn| ");
INSERT INTO sancol_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","itthaM bhUtE tadvIpanivAsina itarEpi rOgilOkA Agatya nirAmayA abhavan| ");
INSERT INTO sancol_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","tasmAttE'smAkam atIva satkAraM kRtavantaH, vizESataH prasthAnasamayE prayOjanIyAni nAnadravyANi dattavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","itthaM tatra triSu mAsESu gatESu yasya cihnaM diyaskUrI tAdRza EkaH sikandarIyanagarasya pOtaH zItakAlaM yApayan tasmin upadvIpE 'tiSThat tamEva pOtaM vayam Aruhya yAtrAm akurmma| ");
INSERT INTO sancol_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","tataH prathamataH surAkUsanagaram upasthAya tatra trINi dinAni sthitavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","tasmAd AvRtya rIgiyanagaram upasthitAH dinaikasmAt paraM dakSiNavayau sAnukUlyE sati parasmin divasE patiyalInagaram upAtiSThAma| ");
INSERT INTO sancol_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","tatO'smAsu tatratyaM bhrAtRgaNaM prAptESu tE svaiH sArddham asmAn sapta dinAni sthApayitum ayatanta, itthaM vayaM rOmAnagaram pratyagacchAma| ");
INSERT INTO sancol_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","tasmAt tatratyAH bhrAtarO'smAkam AgamanavArttAM zrutvA AppiyapharaM triSTAvarNInjca yAvad agrEsarAH santOsmAn sAkSAt karttum Agaman; tESAM darzanAt paula IzvaraM dhanyaM vadan AzvAsam AptavAn| ");
INSERT INTO sancol_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","asmAsu rOmAnagaraM gatESu zatasEnApatiH sarvvAn bandIn pradhAnasEnApatEH samIpE samArpayat kintu paulAya svarakSakapadAtinA saha pRthag vastum anumatiM dattavAn| ");
INSERT INTO sancol_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","dinatrayAt paraM paulastaddEzasthAn pradhAnayihUdina AhUtavAn tatastESu samupasthitESu sa kathitavAn, hE bhrAtRgaNa nijalOkAnAM pUrvvapuruSANAM vA rItE rviparItaM kinjcana karmmAhaM nAkaravaM tathApi yirUzAlamanivAsinO lOkA mAM bandiM kRtvA rOmilOkAnAM hastESu samarpitavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","rOmilOkA vicAryya mama prANahananArhaM kimapi kAraNaM na prApya mAM mOcayitum aicchan; ");
INSERT INTO sancol_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","kintu yihUdilOkAnAm ApattyA mayA kaisararAjasya samIpE vicArasya prArthanA karttavyA jAtA nOcEt nijadEzIyalOkAn prati mama kOpyabhiyOgO nAsti| ");
INSERT INTO sancol_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","EtatkAraNAd ahaM yuSmAn draSTuM saMlapitunjcAhUyam isrAyElvazIyAnAM pratyAzAhEtOham EtEna zugkhalEna baddhO'bhavam| ");
INSERT INTO sancol_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","tadA tE tam avAdiSuH, yihUdIyadEzAd vayaM tvAmadhi kimapi patraM na prAptA yE bhrAtaraH samAyAtAstESAM kOpi tava kAmapi vArttAM nAvadat abhadramapi nAkathayacca| ");
INSERT INTO sancol_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","tava mataM kimiti vayaM tvattaH zrOtumicchAmaH| yad idaM navInaM matamutthitaM tat sarvvatra sarvvESAM nikaTE ninditaM jAtama iti vayaM jAnImaH| ");
INSERT INTO sancol_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","taistadartham Ekasmin dinE nirUpitE tasmin dinE bahava Ekatra militvA paulasya vAsagRham Agacchan tasmAt paula A prAtaHkAlAt sandhyAkAlaM yAvan mUsAvyavasthAgranthAd bhaviSyadvAdinAM granthEbhyazca yIzOH kathAm utthApya Izvarasya rAjyE pramANaM datvA tESAM pravRttiM janayituM cESTitavAn| ");
INSERT INTO sancol_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","kEcittu tasya kathAM pratyAyan kEcittu na pratyAyan; ");
INSERT INTO sancol_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","EtatkAraNAt tESAM parasparam anaikyAt sarvvE calitavantaH; tathApi paula EtAM kathAmEkAM kathitavAn pavitra AtmA yizayiyasya bhaviSyadvaktu rvadanAd asmAkaM pitRpuruSEbhya EtAM kathAM bhadraM kathayAmAsa, yathA, ");
INSERT INTO sancol_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","\"upagatya janAnEtAn tvaM bhASasva vacastvidaM| karNaiH zrOSyatha yUyaM hi kintu yUyaM na bhOtsyatha| nEtrai rdrakSyatha yUyanjca jnjAtuM yUyaM na zakSyatha| ");
INSERT INTO sancol_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","tE mAnuSA yathA nEtraiH paripazyanti naiva hi| karNaiH ryathA na zRNvanti budhyantE na ca mAnasaiH| vyAvarttayatsu cittAni kAlE kutrApi tESu vai| mattastE manujAH svasthA yathA naiva bhavanti ca| tathA tESAM manuSyANAM santi sthUlA hi buddhayaH| badhirIbhUtakarNAzca jAtAzca mudritA dRzaH|| ");
INSERT INTO sancol_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","ata IzvarAd yat paritrANaM tasya vArttA bhinnadEzIyAnAM samIpaM prESitA taEva tAM grahISyantIti yUyaM jAnIta| ");
INSERT INTO sancol_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","EtAdRzyAM kathAyAM kathitAyAM satyAM yihUdinaH parasparaM bahuvicAraM kurvvantO gatavantaH| ");
INSERT INTO sancol_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","itthaM paulaH sampUrNaM vatsaradvayaM yAvad bhATakIyE vAsagRhE vasan yE lOkAstasya sannidhim Agacchanti tAn sarvvAnEva parigRhlan, ");
INSERT INTO sancol_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","nirvighnam atizayaniHkSObham IzvarIyarAjatvasya kathAM pracArayan prabhau yIzau khrISTE kathAH samupAdizat| iti||");
INSERT INTO sancol_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","IzvarO nijaputramadhi yaM susaMvAdaM bhaviSyadvAdibhi rdharmmagranthE pratizrutavAn taM susaMvAdaM pracArayituM pRthakkRta AhUtaH prEritazca prabhO ryIzukhrISTasya sEvakO yaH paulaH ");
INSERT INTO sancol_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","sa rOmAnagarasthAn IzvarapriyAn AhUtAMzca pavitralOkAn prati patraM likhati| ");
INSERT INTO sancol_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","asmAkaM sa prabhu ryIzuH khrISTaH zArIrikasambandhEna dAyUdO vaMzOdbhavaH ");
INSERT INTO sancol_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","pavitrasyAtmanaH sambandhEna cEzvarasya prabhAvavAn putra iti zmazAnAt tasyOtthAnEna pratipannaM| ");
INSERT INTO sancol_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","aparaM yESAM madhyE yIzunA khrISTEna yUyamapyAhUtAstE 'nyadEzIyalOkAstasya nAmni vizvasya nidEzagrAhiNO yathA bhavanti ");
INSERT INTO sancol_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","tadabhiprAyENa vayaM tasmAd anugrahaM prEritatvapadanjca prAptAH| ");
INSERT INTO sancol_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","tAtEnAsmAkam IzvarENa prabhuNA yIzukhrISTEna ca yuSmabhyam anugrahaH zAntizca pradIyEtAM| ");
INSERT INTO sancol_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","prathamataH sarvvasmin jagati yuSmAkaM vizvAsasya prakAzitatvAd ahaM yuSmAkaM sarvvESAM nimittaM yIzukhrISTasya nAma gRhlan Izvarasya dhanyavAdaM karOmi| ");
INSERT INTO sancol_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","aparam Izvarasya prasAdAd bahukAlAt paraM sAmprataM yuSmAkaM samIpaM yAtuM kathamapi yat suyOgaM prApnOmi, EtadarthaM nirantaraM nAmAnyuccArayan nijAsu sarvvaprArthanAsu sarvvadA nivEdayAmi, ");
INSERT INTO sancol_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Etasmin yamahaM tatputrIyasusaMvAdapracAraNEna manasA paricarAmi sa IzvarO mama sAkSI vidyatE| ");
INSERT INTO sancol_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","yatO yuSmAkaM mama ca vizvAsEna vayam ubhayE yathA zAntiyuktA bhavAma iti kAraNAd ");
INSERT INTO sancol_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","yuSmAkaM sthairyyakaraNArthaM yuSmabhyaM kinjcitparamArthadAnadAnAya yuSmAn sAkSAt karttuM madIyA vAnjchA| ");
INSERT INTO sancol_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","hE bhrAtRgaNa bhinnadEzIyalOkAnAM madhyE yadvat tadvad yuSmAkaM madhyEpi yathA phalaM bhunjjE tadabhiprAyENa muhurmuhu ryuSmAkaM samIpaM gantum udyatO'haM kintu yAvad adya tasmin gamanE mama vighnO jAta iti yUyaM yad ajnjAtAstiSThatha tadaham ucitaM na budhyE| ");
INSERT INTO sancol_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","ahaM sabhyAsabhyAnAM vidvadavidvatAnjca sarvvESAm RNI vidyE| ");
INSERT INTO sancol_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","ataEva rOmAnivAsinAM yuSmAkaM samIpE'pi yathAzakti susaMvAdaM pracArayitum aham udyatOsmi| ");
INSERT INTO sancol_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","yataH khrISTasya susaMvAdO mama lajjAspadaM nahi sa Izvarasya zaktisvarUpaH san A yihUdIyEbhyO 'nyajAtIyAn yAvat sarvvajAtIyAnAM madhyE yaH kazcid tatra vizvasiti tasyaiva trANaM janayati| ");
INSERT INTO sancol_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","yataH pratyayasya samaparimANam IzvaradattaM puNyaM tatsusaMvAdE prakAzatE| tadadhi dharmmapustakEpi likhitamidaM \"puNyavAn janO vizvAsEna jIviSyati\"| ");
INSERT INTO sancol_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","ataEva yE mAnavAH pApakarmmaNA satyatAM rundhanti tESAM sarvvasya durAcaraNasyAdharmmasya ca viruddhaM svargAd Izvarasya kOpaH prakAzatE| ");
INSERT INTO sancol_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","yata Izvaramadhi yadyad jnjEyaM tad IzvaraH svayaM tAn prati prakAzitavAn tasmAt tESAm agOcaraM nahi| ");
INSERT INTO sancol_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","phalatastasyAnantazaktIzvaratvAdInyadRzyAnyapi sRSTikAlam Arabhya karmmasu prakAzamAnAni dRzyantE tasmAt tESAM dOSaprakSAlanasya panthA nAsti| ");
INSERT INTO sancol_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","aparam IzvaraM jnjAtvApi tE tam IzvarajnjAnEna nAdriyanta kRtajnjA vA na jAtAH; tasmAt tESAM sarvvE tarkA viphalIbhUtAH, aparanjca tESAM vivEkazUnyAni manAMsi timirE magnAni| ");
INSERT INTO sancol_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","tE svAn jnjAninO jnjAtvA jnjAnahInA abhavan ");
INSERT INTO sancol_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","anazvarasyEzvarasya gauravaM vihAya nazvaramanuSyapazupakSyurOgAmiprabhRtErAkRtiviziSTapratimAstairAzritAH| ");
INSERT INTO sancol_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","itthaM ta Izvarasya satyatAM vihAya mRSAmatam AzritavantaH saccidAnandaM sRSTikarttAraM tyaktvA sRSTavastunaH pUjAM sEvAnjca kRtavantaH; ");
INSERT INTO sancol_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","iti hEtOrIzvarastAn kukriyAyAM samarpya nijanijakucintAbhilASAbhyAM svaM svaM zarIraM parasparam apamAnitaM karttum adadAt| ");
INSERT INTO sancol_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","IzvarENa tESu kvabhilASE samarpitESu tESAM yOSitaH svAbhAvikAcaraNam apahAya viparItakRtyE prAvarttanta; ");
INSERT INTO sancol_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","tathA puruSA api svAbhAvikayOSitsaggamaM vihAya parasparaM kAmakRzAnunA dagdhAH santaH pumAMsaH puMbhiH sAkaM kukRtyE samAsajya nijanijabhrAntEH samucitaM phalam alabhanta| ");
INSERT INTO sancol_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","tE svESAM manaHsvIzvarAya sthAnaM dAtum anicchukAstatO hEtOrIzvarastAn prati duSTamanaskatvam avihitakriyatvanjca dattavAn| ");
INSERT INTO sancol_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","ataEva tE sarvvE 'nyAyO vyabhicArO duSTatvaM lObhO jighAMsA IrSyA vadhO vivAdazcAturI kumatirityAdibhi rduSkarmmabhiH paripUrNAH santaH ");
INSERT INTO sancol_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","karNEjapA apavAdina IzvaradvESakA hiMsakA ahagkAriNa AtmazlAghinaH kukarmmOtpAdakAH pitrOrAjnjAlagghakA ");
INSERT INTO sancol_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","avicArakA niyamalagghinaH snEharahitA atidvESiNO nirdayAzca jAtAH| ");
INSERT INTO sancol_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","yE janA EtAdRzaM karmma kurvvanti taEva mRtiyOgyA Izvarasya vicAramIdRzaM jnjAtvApi ta EtAdRzaM karmma svayaM kurvvanti kEvalamiti nahi kintu tAdRzakarmmakAriSu lOkESvapi prIyantE| ");
INSERT INTO sancol_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","hE paradUSaka manuSya yaH kazcana tvaM bhavasi tavOttaradAnAya panthA nAsti yatO yasmAt karmmaNaH parastvayA dUSyatE tasmAt tvamapi dUSyasE, yatastaM dUSayannapi tvaM tadvad Acarasi| ");
INSERT INTO sancol_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","kintvEtAdRgAcAribhyO yaM daNPam IzvarO nizcinOti sa yathArtha iti vayaM jAnImaH| ");
INSERT INTO sancol_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","ataEva hE mAnuSa tvaM yAdRgAcAriNO dUSayasi svayaM yadi tAdRgAcarasi tarhi tvam IzvaradaNPAt palAyituM zakSyasIti kiM budhyasE? ");
INSERT INTO sancol_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","aparaM tava manasaH parivarttanaM karttum izvarasyAnugrahO bhavati tanna buddhvA tvaM kiM tadIyAnugrahakSamAcirasahiSNutvanidhiM tucchIkarOSi? ");
INSERT INTO sancol_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","tathA svAntaHkaraNasya kaThOratvAt khEdarAhityAccEzvarasya nyAyyavicAraprakAzanasya krOdhasya ca dinaM yAvat kiM svArthaM kOpaM sanjcinOSi? ");
INSERT INTO sancol_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","kintu sa EkaikamanujAya tatkarmmAnusArENa pratiphalaM dAsyati; ");
INSERT INTO sancol_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","vastutastu yE janA dhairyyaM dhRtvA satkarmma kurvvantO mahimA satkArO'maratvanjcaitAni mRgayantE tEbhyO'nantAyu rdAsyati| ");
INSERT INTO sancol_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","aparaM yE janAH satyadharmmam agRhItvA viparItadharmmam gRhlanti tAdRzA virOdhijanAH kOpaM krOdhanjca bhOkSyantE| ");
INSERT INTO sancol_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","A yihUdinO'nyadEzinaH paryyantaM yAvantaH kukarmmakAriNaH prANinaH santi tE sarvvE duHkhaM yAtanAnjca gamiSyanti; ");
INSERT INTO sancol_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","kintu A yihUdinO bhinnadEziparyyantA yAvantaH satkarmmakAriNO lOkAH santi tAn prati mahimA satkAraH zAntizca bhaviSyanti| ");
INSERT INTO sancol_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Izvarasya vicArE pakSapAtO nAsti| ");
INSERT INTO sancol_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","alabdhavyavasthAzAstrai ryaiH pApAni kRtAni vyavasthAzAstrAlabdhatvAnurUpastESAM vinAzO bhaviSyati; kintu labdhavyavasthAzAstrA yE pApAnyakurvvan vyavasthAnusArAdEva tESAM vicArO bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","vyavasthAzrOtAra Izvarasya samIpE niSpApA bhaviSyantIti nahi kintu vyavasthAcAriNa Eva sapuNyA bhaviSyanti| ");
INSERT INTO sancol_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","yatO 'labdhavyavasthAzAstrA bhinnadEzIyalOkA yadi svabhAvatO vyavasthAnurUpAn AcArAn kurvvanti tarhyalabdhazAstrAH santO'pi tE svESAM vyavasthAzAstramiva svayamEva bhavanti| ");
INSERT INTO sancol_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","tESAM manasi sAkSisvarUpE sati tESAM vitarkESu ca kadA tAn dOSiNaH kadA vA nirdOSAn kRtavatsu tE svAntarlikhitasya vyavasthAzAstrasya pramANaM svayamEva dadati| ");
INSERT INTO sancol_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","yasmin dinE mayA prakAzitasya susaMvAdasyAnusArAd IzvarO yIzukhrISTEna mAnuSANAm antaHkaraNAnAM gUPhAbhiprAyAn dhRtvA vicArayiSyati tasmin vicAradinE tat prakAziSyatE| ");
INSERT INTO sancol_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","pazya tvaM svayaM yihUdIti vikhyAtO vyavasthOpari vizvAsaM karOSi, ");
INSERT INTO sancol_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Izvaramuddizya svaM zlAghasE, tathA vyavasthayA zikSitO bhUtvA tasyAbhimataM jAnAsi, sarvvAsAM kathAnAM sAraM viviMkSE, ");
INSERT INTO sancol_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","aparaM jnjAnasya satyatAyAzcAkarasvarUpaM zAstraM mama samIpE vidyata atO 'ndhalOkAnAM mArgadarzayitA ");
INSERT INTO sancol_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","timirasthitalOkAnAM madhyE dIptisvarUpO'jnjAnalOkEbhyO jnjAnadAtA zizUnAM zikSayitAhamEvEti manyasE| ");
INSERT INTO sancol_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","parAn zikSayan svayaM svaM kiM na zikSayasi? vastutazcauryyaniSEdhavyavasthAM pracArayan tvaM kiM svayamEva cOrayasi? ");
INSERT INTO sancol_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","tathA paradAragamanaM pratiSEdhan svayaM kiM paradArAn gacchasi? tathA tvaM svayaM pratimAdvESI san kiM mandirasya dravyANi harasi? ");
INSERT INTO sancol_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","yastvaM vyavasthAM zlAghasE sa tvaM kiM vyavasthAm avamatya nEzvaraM sammanyasE? ");
INSERT INTO sancol_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","zAstrE yathA likhati \"bhinnadEzinAM samIpE yuSmAkaM dOSAd Izvarasya nAmnO nindA bhavati|\" ");
INSERT INTO sancol_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","yadi vyavasthAM pAlayasi tarhi tava tvakchEdakriyA saphalA bhavati; yati vyavasthAM lagghasE tarhi tava tvakchEdO'tvakchEdO bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","yatO vyavasthAzAstrAdiSTadharmmakarmmAcArI pumAn atvakchEdI sannapi kiM tvakchEdinAM madhyE na gaNayiSyatE? ");
INSERT INTO sancol_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","kintu labdhazAstrazchinnatvak ca tvaM yadi vyavasthAlagghanaM karOSi tarhi vyavasthApAlakAH svAbhAvikAcchinnatvacO lOkAstvAM kiM na dUSayiSyanti? ");
INSERT INTO sancol_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","tasmAd yO bAhyE yihUdI sa yihUdI nahi tathAggasya yastvakchEdaH sa tvakchEdO nahi; ");
INSERT INTO sancol_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","kintu yO jana AntarikO yihUdI sa Eva yihUdI aparanjca kEvalalikhitayA vyavasthayA na kintu mAnasikO yastvakchEdO yasya ca prazaMsA manuSyEbhyO na bhUtvA IzvarAd bhavati sa Eva tvakchEdaH| ");
INSERT INTO sancol_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","aparanjca yihUdinaH kiM zrESThatvaM? tathA tvakchEdasya vA kiM phalaM? ");
INSERT INTO sancol_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","sarvvathA bahUni phalAni santi, vizESata Izvarasya zAstraM tEbhyO'dIyata| ");
INSERT INTO sancol_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","kaizcid avizvasanE kRtE tESAm avizvasanAt kim Izvarasya vizvAsyatAyA hAnirutpatsyatE? ");
INSERT INTO sancol_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","kEnApi prakArENa nahi| yadyapi sarvvE manuSyA mithyAvAdinastathApIzvaraH satyavAdI| zAstrE yathA likhitamAstE, atastvantu svavAkyEna nirddOSO hi bhaviSyasi| vicArE caiva niSpApO bhaviSyasi na saMzayaH| ");
INSERT INTO sancol_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","asmAkam anyAyEna yadIzvarasya nyAyaH prakAzatE tarhi kiM vadiSyAmaH? ahaM mAnuSANAM kathAmiva kathAM kathayAmi, IzvaraH samucitaM daNPaM dattvA kim anyAyI bhaviSyati? ");
INSERT INTO sancol_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","itthaM na bhavatu, tathA satIzvaraH kathaM jagatO vicArayitA bhaviSyati? ");
INSERT INTO sancol_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","mama mithyAvAkyavadanAd yadIzvarasya satyatvEna tasya mahimA varddhatE tarhi kasmAdahaM vicArE'parAdhitvEna gaNyO bhavAmi? ");
INSERT INTO sancol_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","maggalArthaM pApamapi karaNIyamiti vAkyaM tvayA kutO nOcyatE? kintu yairucyatE tE nitAntaM daNPasya pAtrANi bhavanti; tathApi tadvAkyam asmAbhirapyucyata ityasmAkaM glAniM kurvvantaH kiyantO lOkA vadanti| ");
INSERT INTO sancol_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","anyalOkEbhyO vayaM kiM zrESThAH? kadAcana nahi yatO yihUdinO 'nyadEzinazca sarvvaEva pApasyAyattA ityasya pramANaM vayaM pUrvvam adadAma| ");
INSERT INTO sancol_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","lipi ryathAstE, naikOpi dhArmmikO janaH| ");
INSERT INTO sancol_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","tathA jnjAnIzvarajnjAnI mAnavaH kOpi nAsti hi| ");
INSERT INTO sancol_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","vimArgagAminaH sarvvE sarvvE duSkarmmakAriNaH| EkO janOpi nO tESAM sAdhukarmma karOti ca| ");
INSERT INTO sancol_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","tathA tESAntu vai kaNThA anAvRtazmazAnavat| stutivAdaM prakurvvanti jihvAbhistE tu kEvalaM| tESAmOSThasya nimnE tu viSaM tiSThati sarppavat| ");
INSERT INTO sancol_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","mukhaM tESAM hi zApEna kapaTEna ca pUryyatE| ");
INSERT INTO sancol_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","raktapAtAya tESAM tu padAni kSipragAni ca| ");
INSERT INTO sancol_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","pathi tESAM manuSyANAM nAzaH klEzazca kEvalaH| ");
INSERT INTO sancol_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","tE janA nahi jAnanti panthAnaM sukhadAyinaM| ");
INSERT INTO sancol_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","paramEzAd bhayaM yattat taccakSuSOragOcaraM| ");
INSERT INTO sancol_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","vyavasthAyAM yadyallikhati tad vyavasthAdhInAn lOkAn uddizya likhatIti vayaM jAnImaH| tatO manuSyamAtrO niruttaraH san Izvarasya sAkSAd aparAdhI bhavati| ");
INSERT INTO sancol_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","ataEva vyavasthAnurUpaiH karmmabhiH kazcidapi prANIzvarasya sAkSAt sapuNyIkRtO bhavituM na zakSyati yatO vyavasthayA pApajnjAnamAtraM jAyatE| ");
INSERT INTO sancol_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","kintu vyavasthAyAH pRthag IzvarENa dEyaM yat puNyaM tad vyavasthAyA bhaviSyadvAdigaNasya ca vacanaiH pramANIkRtaM sad idAnIM prakAzatE| ");
INSERT INTO sancol_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","yIzukhrISTE vizvAsakaraNAd IzvarENa dattaM tat puNyaM sakalESu prakAzitaM sat sarvvAn vizvAsinaH prati varttatE| ");
INSERT INTO sancol_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","tESAM kOpi prabhEdO nAsti, yataH sarvvaEva pApina IzvarIyatEjOhInAzca jAtAH| ");
INSERT INTO sancol_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","ta IzvarasyAnugrahAd mUlyaM vinA khrISTakRtEna paritrANEna sapuNyIkRtA bhavanti| ");
INSERT INTO sancol_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","yasmAt svazONitEna vizvAsAt pApanAzakO balI bhavituM sa Eva pUrvvam IzvarENa nizcitaH, ittham IzvarIyasahiSNutvAt purAkRtapApAnAM mArjjanakaraNE svIyayAthArthyaM tEna prakAzyatE, ");
INSERT INTO sancol_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","varttamAnakAlIyamapi svayAthArthyaM tEna prakAzyatE, aparaM yIzau vizvAsinaM sapuNyIkurvvannapi sa yAthArthikastiSThati| ");
INSERT INTO sancol_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","tarhi kutrAtmazlAghA? sA dUrIkRtA; kayA vyavasthayA? kiM kriyArUpavyavasthayA? itthaM nahi kintu tat kEvalavizvAsarUpayA vyavasthayaiva bhavati| ");
INSERT INTO sancol_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","ataEva vyavasthAnurUpAH kriyA vinA kEvalEna vizvAsEna mAnavaH sapuNyIkRtO bhavituM zaknOtItyasya rAddhAntaM darzayAmaH| ");
INSERT INTO sancol_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","sa kiM kEvalayihUdinAm IzvarO bhavati? bhinnadEzinAm IzvarO na bhavati? bhinnadEzinAmapi bhavati; ");
INSERT INTO sancol_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","yasmAd Eka IzvarO vizvAsAt tvakchEdinO vizvAsEnAtvakchEdinazca sapuNyIkariSyati| ");
INSERT INTO sancol_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","tarhi vizvAsEna vayaM kiM vyavasthAM lumpAma? itthaM na bhavatu vayaM vyavasthAM saMsthApayAma Eva| ");
INSERT INTO sancol_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","asmAkaM pUrvvapuruSa ibrAhIm kAyikakriyayA kiM labdhavAn Etadadhi kiM vadiSyAmaH? ");
INSERT INTO sancol_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","sa yadi nijakriyAbhyaH sapuNyO bhavEt tarhi tasyAtmazlAghAM karttuM panthA bhavEditi satyaM, kintvIzvarasya samIpE nahi| ");
INSERT INTO sancol_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","zAstrE kiM likhati? ibrAhIm IzvarE vizvasanAt sa vizvAsastasmai puNyArthaM gaNitO babhUva| ");
INSERT INTO sancol_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","karmmakAriNO yad vEtanaM tad anugrahasya phalaM nahi kintu tEnOpArjitaM mantavyam| ");
INSERT INTO sancol_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","kintu yaH pApinaM sapuNyIkarOti tasmin vizvAsinaH karmmahInasya janasya yO vizvAsaH sa puNyArthaM gaNyO bhavati| ");
INSERT INTO sancol_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","aparaM yaM kriyAhInam IzvaraH sapuNyIkarOti tasya dhanyavAdaM dAyUd varNayAmAsa, yathA, ");
INSERT INTO sancol_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","sa dhanyO'ghAni mRSTAni yasyAgAMsyAvRtAni ca| ");
INSERT INTO sancol_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","sa ca dhanyaH parEzEna pApaM yasya na gaNyatE| ");
INSERT INTO sancol_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","ESa dhanyavAdastvakchEdinam atvakchEdinaM vA kaM prati bhavati? ibrAhImO vizvAsaH puNyArthaM gaNita iti vayaM vadAmaH| ");
INSERT INTO sancol_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","sa vizvAsastasya tvakchEditvAvasthAyAM kim atvakchEditvAvasthAyAM kasmin samayE puNyamiva gaNitaH? tvakchEditvAvasthAyAM nahi kintvatvakchEditvAvasthAyAM| ");
INSERT INTO sancol_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","aparanjca sa yat sarvvESAm atvakchEdinAM vizvAsinAm AdipuruSO bhavEt, tE ca puNyavattvEna gaNyEran; ");
INSERT INTO sancol_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","yE ca lOkAH kEvalaM chinnatvacO na santO 'smatpUrvvapuruSa ibrAhIm achinnatvak san yEna vizvAsamArgENa gatavAn tEnaiva tasya pAdacihnEna gacchanti tESAM tvakchEdinAmapyAdipuruSO bhavEt tadartham atvakchEdinO mAnavasya vizvAsAt puNyam utpadyata iti pramANasvarUpaM tvakchEdacihnaM sa prApnOt| ");
INSERT INTO sancol_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","ibrAhIm jagatO'dhikArI bhaviSyati yaiSA pratijnjA taM tasya vaMzanjca prati pUrvvam akriyata sA vyavasthAmUlikA nahi kintu vizvAsajanyapuNyamUlikA| ");
INSERT INTO sancol_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","yatO vyavasthAvalambinO yadyadhikAriNO bhavanti tarhi vizvAsO viphalO jAyatE sA pratijnjApi luptaiva| ");
INSERT INTO sancol_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","adhikantu vyavasthA kOpaM janayati yatO 'vidyamAnAyAM vyavasthAyAm AjnjAlagghanaM na sambhavati| ");
INSERT INTO sancol_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","ataEva sA pratijnjA yad anugrahasya phalaM bhavEt tadarthaM vizvAsamUlikA yatastathAtvE tadvaMzasamudAyaM prati arthatO yE vyavasthayA tadvaMzasambhavAH kEvalaM tAn prati nahi kintu ya ibrAhImIyavizvAsEna tatsambhavAstAnapi prati sA pratijnjA sthAsnurbhavati| ");
INSERT INTO sancol_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","yO nirjIvAn sajIvAn avidyamAnAni vastUni ca vidyamAnAni karOti ibrAhImO vizvAsabhUmEstasyEzvarasya sAkSAt sO'smAkaM sarvvESAm AdipuruSa AstE, yathA likhitaM vidyatE, ahaM tvAM bahujAtInAm AdipuruSaM kRtvA niyuktavAn| ");
INSERT INTO sancol_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","tvadIyastAdRzO vaMzO janiSyatE yadidaM vAkyaM pratizrutaM tadanusArAd ibrAhIm bahudEzIyalOkAnAm AdipuruSO yad bhavati tadarthaM sO'napEkSitavyamapyapEkSamANO vizvAsaM kRtavAn| ");
INSERT INTO sancol_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","aparanjca kSINavizvAsO na bhUtvA zatavatsaravayaskatvAt svazarIrasya jarAM sArAnAmnaH svabhAryyAyA rajOnivRttinjca tRNAya na mEnE| ");
INSERT INTO sancol_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","aparam avizvAsAd Izvarasya pratijnjAvacanE kamapi saMzayaM na cakAra; ");
INSERT INTO sancol_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","kintvIzvarENa yat pratizrutaM tat sAdhayituM zakyata iti nizcitaM vijnjAya dRPhavizvAsaH san Izvarasya mahimAnaM prakAzayAnjcakAra| ");
INSERT INTO sancol_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","iti hEtOstasya sa vizvAsastadIyapuNyamiva gaNayAnjcakrE| ");
INSERT INTO sancol_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","puNyamivAgaNyata tat kEvalasya tasya nimittaM likhitaM nahi, asmAkaM nimittamapi, ");
INSERT INTO sancol_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","yatO'smAkaM pApanAzArthaM samarpitO'smAkaM puNyaprAptyarthanjcOtthApitO'bhavat yO'smAkaM prabhu ryIzustasyOtthApayitarIzvarE ");
INSERT INTO sancol_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","yadi vayaM vizvasAmastarhyasmAkamapi saEva vizvAsaH puNyamiva gaNayiSyatE| ");
INSERT INTO sancol_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","vizvAsEna sapuNyIkRtA vayam IzvarENa sArddhaM prabhuNAsmAkaM yIzukhrISTEna mElanaM prAptAH| ");
INSERT INTO sancol_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","aparaM vayaM yasmin anugrahAzrayE tiSThAmastanmadhyaM vizvAsamArgENa tEnaivAnItA vayam IzvarIyavibhavaprAptipratyAzayA samAnandAmaH| ");
INSERT INTO sancol_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","tat kEvalaM nahi kintu klEzabhOgE'pyAnandAmO yataH klEzAाd dhairyyaM jAyata iti vayaM jAnImaH, ");
INSERT INTO sancol_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","dhairyyAcca parIkSitatvaM jAyatE, parIkSitatvAt pratyAzA jAyatE, ");
INSERT INTO sancol_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","pratyAzAtO vrIPitatvaM na jAyatE, yasmAd asmabhyaM dattEna pavitrENAtmanAsmAkam antaHkaraNAnIzvarasya prEmavAriNA siktAni| ");
INSERT INTO sancol_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","asmAsu nirupAyESu satsu khrISTa upayuktE samayE pApinAM nimittaM svIyAn praNAn atyajat| ");
INSERT INTO sancol_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","hitakAriNO janasya kRtE kOpi praNAn tyaktuM sAhasaM karttuM zaknOti, kintu dhArmmikasya kRtE prAyENa kOpi prANAn na tyajati| ");
INSERT INTO sancol_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","kintvasmAsu pApiSu satsvapi nimittamasmAkaM khrISTaH svaprANAn tyaktavAn, tata IzvarOsmAn prati nijaM paramaprEmANaM darzitavAn| ");
INSERT INTO sancol_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","ataEva tasya raktapAtEna sapuNyIkRtA vayaM nitAntaM tEna kOpAd uddhAriSyAmahE| ");
INSERT INTO sancol_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","phalatO vayaM yadA ripava Asma tadEzvarasya putrasya maraNEna tEna sArddhaM yadyasmAkaM mElanaM jAtaM tarhi mElanaprAptAH santO'vazyaM tasya jIvanEna rakSAM lapsyAmahE| ");
INSERT INTO sancol_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","tat kEvalaM nahi kintu yEna mElanam alabhAmahi tEnAsmAkaM prabhuNA yIzukhrISTEna sAmpratam IzvarE samAnandAmazca| ");
INSERT INTO sancol_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","tathA sati, EkEna mAnuSENa pApaM pApEna ca maraNaM jagatIM prAvizat aparaM sarvvESAM pApitvAt sarvvE mAnuSA mRtE rnighnA abhavat| ");
INSERT INTO sancol_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","yatO vyavasthAdAnasamayaM yAvat jagati pApam AsIt kintu yatra vyavasthA na vidyatE tatra pApasyApi gaNanA na vidyatE| ");
INSERT INTO sancol_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","tathApyAdamA yAdRzaM pApaM kRtaM tAdRzaM pApaM yai rnAkAri Adamam Arabhya mUsAM yAvat tESAmapyupari mRtyU rAjatvam akarOt sa Adam bhAvyAdamO nidarzanamEvAstE| ");
INSERT INTO sancol_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","kintu pApakarmmaNO yAdRzO bhAvastAdRg dAnakarmmaNO bhAvO na bhavati yata Ekasya janasyAparAdhEna yadi bahUnAM maraNam aghaTata tathApIzvarAnugrahastadanugrahamUlakaM dAnanjcaikEna janEnArthAd yIzunA khrISTEna bahuSu bAhulyAtibAhulyEna phalati| ");
INSERT INTO sancol_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","aparam Ekasya janasya pApakarmma yAdRk phalayuktaM dAnakarmma tAdRk na bhavati yatO vicArakarmmaikaM pApam Arabhya daNPajanakaM babhUva, kintu dAnakarmma bahupApAnyArabhya puNyajanakaM babhUva| ");
INSERT INTO sancol_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","yata Ekasya janasya pApakarmmatastEnaikEna yadi maraNasya rAjatvaM jAtaM tarhi yE janA anugrahasya bAhulyaM puNyadAnanjca prApnuvanti ta EkEna janEna, arthAt yIzukhrISTEna, jIvanE rAjatvam avazyaM kariSyanti| ");
INSERT INTO sancol_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","EkO'parAdhO yadvat sarvvamAnavAnAM daNPagAmI mArgO 'bhavat tadvad EkaM puNyadAnaM sarvvamAnavAnAM jIvanayuktapuNyagAmI mArga Eva| ");
INSERT INTO sancol_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","aparam Ekasya janasyAjnjAlagghanAd yathA bahavO 'parAdhinO jAtAstadvad EkasyAjnjAcaraNAd bahavaH sapuNyIkRtA bhavanti| ");
INSERT INTO sancol_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","adhikantu vyavasthAgamanAd aparAdhasya bAhulyaM jAtaM kintu yatra pApasya bAhulyaM tatraiva tasmAd anugrahasya bAhulyam abhavat| ");
INSERT INTO sancol_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","tEna mRtyunA yadvat pApasya rAjatvam abhavat tadvad asmAkaM prabhuyIzukhrISTadvArAnantajIvanadAyipuNyEnAnugrahasya rAjatvaM bhavati| ");
INSERT INTO sancol_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","prabhUtarUpENa yad anugrahaH prakAzatE tadarthaM pApE tiSThAma iti vAkyaM kiM vayaM vadiSyAmaH? tanna bhavatu| ");
INSERT INTO sancol_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","pApaM prati mRtA vayaM punastasmin katham jIviSyAmaH? ");
INSERT INTO sancol_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","vayaM yAvantO lOkA yIzukhrISTE majjitA abhavAma tAvanta Eva tasya maraNE majjitA iti kiM yUyaM na jAnItha? ");
INSERT INTO sancol_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","tatO yathA pituH parAkramENa zmazAnAt khrISTa utthApitastathA vayamapi yat nUtanajIvina ivAcarAmastadarthaM majjanEna tEna sArddhaM mRtyurUpE zmazAnE saMsthApitAH| ");
INSERT INTO sancol_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","aparaM vayaM yadi tEna saMyuktAH santaH sa iva maraNabhAginO jAtAstarhi sa ivOtthAnabhAginO'pi bhaviSyAmaH| ");
INSERT INTO sancol_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","vayaM yat pApasya dAsAH puna rna bhavAmastadartham asmAkaM pAparUpazarIrasya vinAzArtham asmAkaM purAtanapuruSastEna sAkaM kruzE'hanyatEti vayaM jAnImaH| ");
INSERT INTO sancol_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","yO hataH sa pApAt mukta Eva| ");
INSERT INTO sancol_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","ataEva yadi vayaM khrISTEna sArddham ahanyAmahi tarhi punarapi tEna sahitA jIviSyAma ityatrAsmAkaM vizvAsO vidyatE| ");
INSERT INTO sancol_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","yataH zmazAnAd utthApitaH khrISTO puna rna mriyata iti vayaM jAnImaH| tasmin kOpyadhikArO mRtyO rnAsti| ");
INSERT INTO sancol_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","aparanjca sa yad amriyata tEnaikadA pApam uddizyAmriyata, yacca jIvati tEnEzvaram uddizya jIvati; ");
INSERT INTO sancol_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","tadvad yUyamapi svAn pApam uddizya mRtAn asmAkaM prabhuNA yIzukhrISTEnEzvaram uddizya jIvantO jAnIta| ");
INSERT INTO sancol_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","aparanjca kutsitAbhilASAाn pUrayituM yuSmAkaM martyadEhESu pApam AdhipatyaM na karOtu| ");
INSERT INTO sancol_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","aparaM svaM svam aggam adharmmasyAstraM kRtvA pApasEvAyAM na samarpayata, kintu zmazAnAd utthitAniva svAn IzvarE samarpayata svAnyaggAni ca dharmmAstrasvarUpANIzvaram uddizya samarpayata| ");
INSERT INTO sancol_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","yuSmAkam upari pApasyAdhipatyaM puna rna bhaviSyati, yasmAd yUyaM vyavasthAyA anAyattA anugrahasya cAyattA abhavata| ");
INSERT INTO sancol_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","kintu vayaM vyavasthAyA anAyattA anugrahasya cAyattA abhavAma, iti kAraNAt kiM pApaM kariSyAmaH? tanna bhavatu| ");
INSERT INTO sancol_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","yatO mRtijanakaM pApaM puNyajanakaM nidEzAcaraNanjcaitayOrdvayO ryasmin AjnjApAlanArthaM bhRtyAniva svAn samarpayatha, tasyaiva bhRtyA bhavatha, Etat kiM yUyaM na jAnItha? ");
INSERT INTO sancol_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","aparanjca pUrvvaM yUyaM pApasya bhRtyA AstEti satyaM kintu yasyAM zikSArUpAyAM mUSAyAM nikSiptA abhavata tasyA AkRtiM manObhi rlabdhavanta iti kAraNAd Izvarasya dhanyavAdO bhavatu| ");
INSERT INTO sancol_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","itthaM yUyaM pApasEvAtO muktAH santO dharmmasya bhRtyA jAtAH| ");
INSERT INTO sancol_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","yuSmAkaM zArIrikyA durbbalatAyA hEtO rmAnavavad aham Etad bravImi; punaH punaradharmmakaraNArthaM yadvat pUrvvaM pApAmEdhyayO rbhRtyatvE nijAggAni samArpayata tadvad idAnIM sAdhukarmmakaraNArthaM dharmmasya bhRtyatvE nijAggAni samarpayata| ");
INSERT INTO sancol_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","yadA yUyaM pApasya bhRtyA Asta tadA dharmmasya nAyattA Asta| ");
INSERT INTO sancol_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","tarhi yAni karmmANi yUyam idAnIM lajjAjanakAni budhyadhvE pUrvvaM tai ryuSmAkaM kO lAbha AsIt? tESAM karmmaNAM phalaM maraNamEva| ");
INSERT INTO sancol_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","kintu sAmprataM yUyaM pApasEvAtO muktAH santa Izvarasya bhRtyA'bhavata tasmAd yuSmAkaM pavitratvarUpaM labhyam anantajIvanarUpanjca phalam AstE| ");
INSERT INTO sancol_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","yataH pApasya vEtanaM maraNaM kintvasmAkaM prabhuNA yIzukhrISTEnAnantajIvanam IzvaradattaM pAritOSikam AstE| ");
INSERT INTO sancol_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","hE bhrAtRgaNa vyavasthAvidaH prati mamEdaM nivEdanaM| vidhiH kEvalaM yAvajjIvaM mAnavOparyyadhipatitvaM karOtIti yUyaM kiM na jAnItha? ");
INSERT INTO sancol_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","yAvatkAlaM pati rjIvati tAvatkAlam UPhA bhAryyA vyavasthayA tasmin baddhA tiSThati kintu yadi pati rmriyatE tarhi sA nArI patyu rvyavasthAtO mucyatE| ");
INSERT INTO sancol_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","EtatkAraNAt patyurjIvanakAlE nArI yadyanyaM puruSaM vivahati tarhi sA vyabhicAriNI bhavati kintu yadi sa pati rmriyatE tarhi sA tasyA vyavasthAyA muktA satI puruSAntarENa vyUPhApi vyabhicAriNI na bhavati| ");
INSERT INTO sancol_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","hE mama bhrAtRgaNa, IzvaranimittaM yadasmAkaM phalaM jAyatE tadarthaM zmazAnAd utthApitEna puruSENa saha yuSmAkaM vivAhO yad bhavEt tadarthaM khrISTasya zarIrENa yUyaM vyavasthAM prati mRtavantaH| ");
INSERT INTO sancol_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","yatO'smAkaM zArIrikAcaraNasamayE maraNanimittaM phalam utpAdayituM vyavasthayA dUSitaH pApAbhilASO'smAkam aggESu jIvan AsIt| ");
INSERT INTO sancol_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","kintu tadA yasyA vyavasthAyA vazE Asmahi sAmprataM tAM prati mRtatvAd vayaM tasyA adhInatvAt muktA iti hEtOrIzvarO'smAbhiH purAtanalikhitAnusArAt na sEvitavyaH kintu navInasvabhAvEnaiva sEvitavyaH ");
INSERT INTO sancol_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","tarhi vayaM kiM brUmaH? vyavasthA kiM pApajanikA bhavati? nEtthaM bhavatu| vyavasthAm avidyamAnAyAM pApaM kim ityahaM nAvEdaM; kinjca lObhaM mA kArSIriti cEd vyavasthAgranthE likhitaM nAbhaviSyat tarhi lObhaH kimbhUtastadahaM nAjnjAsyaM| ");
INSERT INTO sancol_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","kintu vyavasthayA pApaM chidraM prApyAsmAkam antaH sarvvavidhaM kutsitAbhilASam ajanayat; yatO vyavasthAyAm avidyamAnAyAM pApaM mRtaM| ");
INSERT INTO sancol_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","aparaM pUrvvaM vyavasthAyAm avidyamAnAyAm aham ajIvaM tataH param AjnjAyAm upasthitAyAm pApam ajIvat tadAham amriyE| ");
INSERT INTO sancol_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","itthaM sati jIvananimittA yAjnjA sA mama mRtyujanikAbhavat| ");
INSERT INTO sancol_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","yataH pApaM chidraM prApya vyavasthitAdEzEna mAM vanjcayitvA tEna mAm ahan| ");
INSERT INTO sancol_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","ataEva vyavasthA pavitrA, AdEzazca pavitrO nyAyyO hitakArI ca bhavati| ");
INSERT INTO sancol_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","tarhi yat svayaM hitakRt tat kiM mama mRtyujanakam abhavat? nEtthaM bhavatu; kintu pApaM yat pAtakamiva prakAzatE tathA nidEzEna pApaM yadatIva pAtakamiva prakAzatE tadarthaM hitOpAyEna mama maraNam ajanayat| ");
INSERT INTO sancol_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","vyavasthAtmabOdhikEti vayaM jAnImaH kintvahaM zArIratAcArI pApasya krItakigkarO vidyE| ");
INSERT INTO sancol_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","yatO yat karmma karOmi tat mama manO'bhimataM nahi; aparaM yan mama manO'bhimataM tanna karOmi kintu yad RtIyE tat karOmi| ");
INSERT INTO sancol_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","tathAtvE yan mamAnabhimataM tad yadi karOmi tarhi vyavasthA sUttamEti svIkarOmi| ");
INSERT INTO sancol_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","ataEva samprati tat karmma mayA kriyata iti nahi kintu mama zarIrasthEna pApEnaiva kriyatE| ");
INSERT INTO sancol_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","yatO mayi, arthatO mama zarIrE, kimapyuttamaM na vasati, Etad ahaM jAnAmi; mamEcchukatAyAM tiSThantyAmapyaham uttamakarmmasAdhanE samarthO na bhavAmi| ");
INSERT INTO sancol_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","yatO yAmuttamAM kriyAM karttumahaM vAnjchAmi tAM na karOmi kintu yat kutsitaM karmma karttum anicchukO'smi tadEva karOmi| ");
INSERT INTO sancol_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","ataEva yadyat karmma karttuM mamEcchA na bhavati tad yadi karOmi tarhi tat mayA na kriyatE, mamAntarvarttinA pApEnaiva kriyatE| ");
INSERT INTO sancol_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","bhadraM karttum icchukaM mAM yO 'bhadraM karttuM pravarttayati tAdRzaM svabhAvamEkaM mayi pazyAmi| ");
INSERT INTO sancol_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","aham AntarikapuruSENEzvaravyavasthAyAM santuSTa AsE; ");
INSERT INTO sancol_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","kintu tadviparItaM yudhyantaM tadanyamEkaM svabhAvaM madIyAggasthitaM prapazyAmi, sa madIyAggasthitapApasvabhAvasyAyattaM mAM karttuM cESTatE| ");
INSERT INTO sancol_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","hA hA yO'haM durbhAgyO manujastaM mAm EtasmAn mRtAccharIrAt kO nistArayiSyati? ");
INSERT INTO sancol_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","asmAkaM prabhuNA yIzukhrISTEna nistArayitAram IzvaraM dhanyaM vadAmi| ataEva zarIrENa pApavyavasthAyA manasA tu IzvaravyavasthAyAH sEvanaM karOmi| ");
INSERT INTO sancol_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","yE janAH khrISTaM yIzum Azritya zArIrikaM nAcaranta AtmikamAcaranti tE'dhunA daNPArhA na bhavanti| ");
INSERT INTO sancol_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","jIvanadAyakasyAtmanO vyavasthA khrISTayIzunA pApamaraNayO rvyavasthAtO mAmamOcayat| ");
INSERT INTO sancol_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","yasmAcchArIrasya durbbalatvAd vyavasthayA yat karmmAsAdhyam IzvarO nijaputraM pApizarIrarUpaM pApanAzakabalirUpanjca prESya tasya zarIrE pApasya daNPaM kurvvan tatkarmma sAdhitavAn| ");
INSERT INTO sancol_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","tataH zArIrikaM nAcaritvAsmAbhirAtmikam AcaradbhirvyavasthAgranthE nirddiSTAni puNyakarmmANi sarvvANi sAdhyantE| ");
INSERT INTO sancol_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","yE zArIrikAcAriNastE zArIrikAn viSayAn bhAvayanti yE cAtmikAcAriNastE AtmanO viSayAn bhAvayanti| ");
INSERT INTO sancol_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","zArIrikabhAvasya phalaM mRtyuH kinjcAtmikabhAvasya phalE jIvanaM zAntizca| ");
INSERT INTO sancol_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","yataH zArIrikabhAva Izvarasya viruddhaH zatrutAbhAva Eva sa Izvarasya vyavasthAyA adhInO na bhavati bhavitunjca na zaknOti| ");
INSERT INTO sancol_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","EtasmAt zArIrikAcAriSu tOSTum IzvarENa na zakyaM| ");
INSERT INTO sancol_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","kintvIzvarasyAtmA yadi yuSmAkaM madhyE vasati tarhi yUyaM zArIrikAcAriNO na santa AtmikAcAriNO bhavathaH| yasmin tu khrISTasyAtmA na vidyatE sa tatsambhavO nahi| ");
INSERT INTO sancol_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","yadi khrISTO yuSmAn adhitiSThati tarhi pApam uddizya zarIraM mRtaM kintu puNyamuddizyAtmA jIvati| ");
INSERT INTO sancol_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","mRtagaNAd yIzu ryEnOtthApitastasyAtmA yadi yuSmanmadhyE vasati tarhi mRtagaNAt khrISTasya sa utthApayitA yuSmanmadhyavAsinA svakIyAtmanA yuSmAkaM mRtadEhAnapi puna rjIvayiSyati| ");
INSERT INTO sancol_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","hE bhrAtRgaNa zarIrasya vayamadhamarNA na bhavAmO'taH zArIrikAcArO'smAbhi rna karttavyaH| ");
INSERT INTO sancol_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","yadi yUyaM zarIrikAcAriNO bhavEta tarhi yuSmAbhi rmarttavyamEva kintvAtmanA yadi zarIrakarmmANi ghAtayEta tarhi jIviSyatha| ");
INSERT INTO sancol_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","yatO yAvantO lOkA IzvarasyAtmanAkRSyantE tE sarvva Izvarasya santAnA bhavanti| ");
INSERT INTO sancol_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","yUyaM punarapi bhayajanakaM dAsyabhAvaM na prAptAH kintu yEna bhAvEnEzvaraM pitaH pitariti prOcya sambOdhayatha tAdRzaM dattakaputratvabhAvam prApnuta| ");
INSERT INTO sancol_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","aparanjca vayam Izvarasya santAnA Etasmin pavitra AtmA svayam asmAkam AtmAbhiH sArddhaM pramANaM dadAti| ");
INSERT INTO sancol_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","ataEva vayaM yadi santAnAstarhyadhikAriNaH, arthAd Izvarasya svattvAdhikAriNaH khrISTEna sahAdhikAriNazca bhavAmaH; aparaM tEna sArddhaM yadi duHkhabhAginO bhavAmastarhi tasya vibhavasyApi bhAginO bhaviSyAmaH| ");
INSERT INTO sancol_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","kintvasmAsu yO bhAvIvibhavaH prakAziSyatE tasya samIpE varttamAnakAlInaM duHkhamahaM tRNAya manyE| ");
INSERT INTO sancol_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","yataH prANigaNa Izvarasya santAnAnAM vibhavaprAptim AkAgkSan nitAntam apEkSatE| ");
INSERT INTO sancol_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","aparanjca prANigaNaH svairam alIkatAyA vazIkRtO nAbhavat ");
INSERT INTO sancol_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","kintu prANigaNO'pi nazvaratAdhInatvAt muktaH san Izvarasya santAnAnAM paramamuktiM prApsyatItyabhiprAyENa vazIkartrA vazIcakrE| ");
INSERT INTO sancol_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","aparanjca prasUyamAnAvad vyathitaH san idAnIM yAvat kRtsnaH prANigaNa ArttasvaraM karOtIti vayaM jAnImaH| ");
INSERT INTO sancol_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","kEvalaH sa iti nahi kintu prathamajAtaphalasvarUpam AtmAnaM prAptA vayamapi dattakaputratvapadaprAptim arthAt zarIrasya muktiM pratIkSamANAstadvad antarArttarAvaM kurmmaH| ");
INSERT INTO sancol_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","vayaM pratyAzayA trANam alabhAmahi kintu pratyakSavastunO yA pratyAzA sA pratyAzA nahi, yatO manuSyO yat samIkSatE tasya pratyAzAM kutaH kariSyati? ");
INSERT INTO sancol_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","yad apratyakSaM tasya pratyAzAM yadi vayaM kurvvImahi tarhi dhairyyam avalambya pratIkSAmahE| ");
INSERT INTO sancol_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","tata AtmApi svayam asmAkaM durbbalatAyAH sahAyatvaM karOti; yataH kiM prArthitavyaM tad bOddhuM vayaM na zaknumaH, kintvaspaSTairArttarAvairAtmA svayam asmannimittaM nivEdayati| ");
INSERT INTO sancol_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","aparam IzvarAbhimatarUpENa pavitralOkAnAM kRtE nivEdayati ya AtmA tasyAbhiprAyO'ntaryyAminA jnjAyatE| ");
INSERT INTO sancol_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","aparam IzvarIyanirUpaNAnusArENAhUtAH santO yE tasmin prIyantE sarvvANi militvA tESAM maggalaM sAdhayanti, Etad vayaM jAnImaH| ");
INSERT INTO sancol_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","yata IzvarO bahubhrAtRNAM madhyE svaputraM jyESThaM karttum icchan yAn pUrvvaM lakSyIkRtavAn tAn tasya pratimUrtyAH sAdRzyaprAptyarthaM nyayuMkta| ");
INSERT INTO sancol_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","aparanjca tEna yE niyuktAsta AhUtA api yE ca tEnAhUtAstE sapuNyIkRtAH, yE ca tEna sapuNyIkRtAstE vibhavayuktAH| ");
INSERT INTO sancol_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","ityatra vayaM kiM brUmaH? IzvarO yadyasmAkaM sapakSO bhavati tarhi kO vipakSO'smAkaM? ");
INSERT INTO sancol_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","AtmaputraM na rakSitvA yO'smAkaM sarvvESAM kRtE taM pradattavAn sa kiM tEna sahAsmabhyam anyAni sarvvANi na dAsyati? ");
INSERT INTO sancol_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","IzvarasyAbhirucitESu kEna dOSa ArOpayiSyatE? ya IzvarastAn puNyavata iva gaNayati kiM tEna? ");
INSERT INTO sancol_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","aparaM tEbhyO daNPadAnAjnjA vA kEna kariSyatE? yO'smannimittaM prANAn tyaktavAn kEvalaM tanna kintu mRtagaNamadhyAd utthitavAn, api cEzvarasya dakSiNE pArzvE tiSThan adyApyasmAkaM nimittaM prArthata EvambhUtO yaH khrISTaH kiM tEna? ");
INSERT INTO sancol_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","asmAbhiH saha khrISTasya prEmavicchEdaM janayituM kaH zaknOti? klEzO vyasanaM vA tAPanA vA durbhikSaM vA vastrahInatvaM vA prANasaMzayO vA khaggO vA kimEtAni zaknuvanti? ");
INSERT INTO sancol_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","kintu likhitam AstE, yathA, vayaM tava nimittaM smO mRtyuvaktrE'khilaM dinaM| balirdEyO yathA mESO vayaM gaNyAmahE tathA| ");
INSERT INTO sancol_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","aparaM yO'smAsu prIyatE tEnaitAsu vipatsu vayaM samyag vijayAmahE| ");
INSERT INTO sancol_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","yatO'smAkaM prabhunA yIzukhrISTEnEzvarasya yat prEma tasmAd asmAkaM vicchEdaM janayituM mRtyu rjIvanaM vA divyadUtA vA balavantO mukhyadUtA vA varttamAnO vA bhaviSyan kAlO vA uccapadaM vA nIcapadaM vAparaM kimapi sRSTavastu ");
INSERT INTO sancol_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","vaitESAM kEnApi na zakyamityasmin dRPhavizvAsO mamAstE| ");
INSERT INTO sancol_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","ahaM kAnjcid kalpitAM kathAM na kathayAmi, khrISTasya sAkSAt satyamEva bravImi pavitrasyAtmanaH sAkSAn madIyaM mana Etat sAkSyaM dadAti| ");
INSERT INTO sancol_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","mamAntaratizayaduHkhaM nirantaraM khEdazca ");
INSERT INTO sancol_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","tasmAd ahaM svajAtIyabhrAtRNAM nimittAt svayaM khrISTAcchApAkrAntO bhavitum aiccham| ");
INSERT INTO sancol_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","yatasta isrAyElasya vaMzA api ca dattakaputratvaM tEjO niyamO vyavasthAdAnaM mandirE bhajanaM pratijnjAH pitRpuruSagaNazcaitESu sarvvESu tESAm adhikArO'sti| ");
INSERT INTO sancol_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","tat kEvalaM nahi kintu sarvvAdhyakSaH sarvvadA saccidAnanda IzvarO yaH khrISTaH sO'pi zArIrikasambandhEna tESAM vaMzasambhavaH| ");
INSERT INTO sancol_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Izvarasya vAkyaM viphalaM jAtam iti nahi yatkAraNAd isrAyElO vaMzE yE jAtAstE sarvvE vastuta isrAyElIyA na bhavanti| ");
INSERT INTO sancol_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","aparam ibrAhImO vaMzE jAtA api sarvvE tasyaiva santAnA na bhavanti kintu ishAkO nAmnA tava vaMzO vikhyAtO bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","arthAt zArIrikasaMsargAt jAtAH santAnA yAvantastAvanta EvEzvarasya santAnA na bhavanti kintu pratizravaNAd yE jAyantE taEvEzvaravaMzO gaNyatE| ");
INSERT INTO sancol_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","yatastatpratizrutE rvAkyamEtat, EtAdRzE samayE 'haM punarAgamiSyAmi tatpUrvvaM sArAyAH putra EkO janiSyatE| ");
INSERT INTO sancol_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","aparamapi vadAmi svamanO'bhilASata IzvarENa yannirUpitaM tat karmmatO nahi kintvAhvayitu rjAtamEtad yathA siddhyati ");
INSERT INTO sancol_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","tadarthaM ribkAnAmikayA yOSitA janaikasmAd arthAd asmAkam ishAkaH pUrvvapuruSAd garbhE dhRtE tasyAH santAnayOH prasavAt pUrvvaM kinjca tayOH zubhAzubhakarmmaNaH karaNAt pUrvvaM ");
INSERT INTO sancol_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","tAM pratIdaM vAkyam uktaM, jyESThaH kaniSThaM sEviSyatE, ");
INSERT INTO sancol_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","yathA likhitam AstE, tathApyESAvi na prItvA yAkUbi prItavAn ahaM| ");
INSERT INTO sancol_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","tarhi vayaM kiM brUmaH? IzvaraH kim anyAyakArI? tathA na bhavatu| ");
INSERT INTO sancol_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","yataH sa svayaM mUsAm avadat; ahaM yasmin anugrahaM cikIrSAmi tamEvAnugRhlAmi, yanjca dayitum icchAmi tamEva dayE| ");
INSERT INTO sancol_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","ataEvEcchatA yatamAnEna vA mAnavEna tanna sAdhyatE dayAkAriNEzvarENaiva sAdhyatE| ");
INSERT INTO sancol_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","phirauNi zAstrE likhati, ahaM tvaddvArA matparAkramaM darzayituM sarvvapRthivyAM nijanAma prakAzayitunjca tvAM sthApitavAn| ");
INSERT INTO sancol_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","ataH sa yam anugrahItum icchati tamEvAnugRhlAti, yanjca nigrahItum icchati taM nigRhlAti| ");
INSERT INTO sancol_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","yadi vadasi tarhi sa dOSaM kutO gRhlAti? tadIyEcchAyAH pratibandhakatvaM karttaM kasya sAmarthyaM vidyatE? ");
INSERT INTO sancol_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","hE Izvarasya pratipakSa martya tvaM kaH? EtAdRzaM mAM kutaH sRSTavAn? iti kathAM sRSTavastu sraSTrE kiM kathayiSyati? ");
INSERT INTO sancol_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","EkasmAn mRtpiNPAd utkRSTApakRSTau dvividhau kalazau karttuM kiM kulAlasya sAmarthyaM nAsti? ");
INSERT INTO sancol_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","IzvaraH kOpaM prakAzayituM nijazaktiM jnjApayitunjcEcchan yadi vinAzasya yOgyAni krOdhabhAjanAni prati bahukAlaM dIrghasahiSNutAm Azrayati; ");
INSERT INTO sancol_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","aparanjca vibhavaprAptyarthaM pUrvvaM niyuktAnyanugrahapAtrANi prati nijavibhavasya bAhulyaM prakAzayituM kEvalayihUdinAM nahi bhinnadEzinAmapi madhyAd ");
INSERT INTO sancol_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","asmAniva tAnyAhvayati tatra tava kiM? ");
INSERT INTO sancol_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","hOzEyagranthE yathA likhitam AstE, yO lOkO mama nAsIt taM vadiSyAmi madIyakaM| yA jAti rmE'priyA cAsIt tAM vadiSyAmyahaM priyAM| ");
INSERT INTO sancol_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","yUyaM madIyalOkA na yatrEti vAkyamaucyata| amarEzasya santAnA iti khyAsyanti tatra tE| ");
INSERT INTO sancol_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","isrAyElIyalOkESu yizAyiyO'pi vAcamEtAM prAcArayat, isrAyElIyavaMzAnAM yA saMkhyA sA tu nizcitaM| samudrasikatAsaMkhyAsamAnA yadi jAyatE| tathApi kEvalaM lOkairalpaistrANaM vrajiSyatE| ");
INSERT INTO sancol_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","yatO nyAyEna svaM karmma parEzaH sAdhayiSyati| dEzE saEva saMkSEpAnnijaM karmma kariSyati| ");
INSERT INTO sancol_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","yizAyiyO'paramapi kathayAmAsa, sainyAdhyakSaparEzEna cEt kinjcinnOdaziSyata| tadA vayaM sidOmEvAbhaviSyAma vinizcitaM| yadvA vayam amOrAyA agamiSyAma tulyatAM| ");
INSERT INTO sancol_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","tarhi vayaM kiM vakSyAmaH? itaradEzIyA lOkA api puNyArtham ayatamAnA vizvAsEna puNyam alabhanta; ");
INSERT INTO sancol_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","kintvisrAyEllOkA vyavasthApAlanEna puNyArthaM yatamAnAstan nAlabhanta| ");
INSERT INTO sancol_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","tasya kiM kAraNaM? tE vizvAsEna nahi kintu vyavasthAyAH kriyayA cESTitvA tasmin skhalanajanakE pASANE pAdaskhalanaM prAptAH| ");
INSERT INTO sancol_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","likhitaM yAdRzam AstE, pazya pAdaskhalArthaM hi sIyOni prastarantathA| bAdhAkAranjca pASANaM paristhApitavAnaham| vizvasiSyati yastatra sa janO na trapiSyatE| ");
INSERT INTO sancol_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","hE bhrAtara isrAyElIyalOkA yat paritrANaM prApnuvanti tadahaM manasAbhilaSan Izvarasya samIpE prArthayE| ");
INSERT INTO sancol_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","yata IzvarE tESAM cESTA vidyata ityatrAhaM sAkSyasmi; kintu tESAM sA cESTA sajnjAnA nahi, ");
INSERT INTO sancol_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","yatasta IzvaradattaM puNyam avijnjAya svakRtapuNyaM sthApayitum cESTamAnA Izvaradattasya puNyasya nighnatvaM na svIkurvvanti| ");
INSERT INTO sancol_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","khrISTa EkaikavizvAsijanAya puNyaM dAtuM vyavasthAyAH phalasvarUpO bhavati| ");
INSERT INTO sancol_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","vyavasthApAlanEna yat puNyaM tat mUsA varNayAmAsa, yathA, yO janastAM pAlayiSyati sa taddvArA jIviSyati| ");
INSERT INTO sancol_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","kintu pratyayEna yat puNyaM tad EtAdRzaM vAkyaM vadati, kaH svargam Aruhya khrISTam avarOhayiSyati? ");
INSERT INTO sancol_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","kO vA prEtalOkam avaruhya khrISTaM mRtagaNamadhyAd AnESyatIti vAk manasi tvayA na gaditavyA| ");
INSERT INTO sancol_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","tarhi kiM bravIti? tad vAkyaM tava samIpastham arthAt tava vadanE manasi cAstE, tacca vAkyam asmAbhiH pracAryyamANaM vizvAsasya vAkyamEva| ");
INSERT INTO sancol_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","vastutaH prabhuM yIzuM yadi vadanEna svIkarOSi, tathEzvarastaM zmazAnAd udasthApayad iti yadyantaHkaraNEna vizvasiSi tarhi paritrANaM lapsyasE| ");
INSERT INTO sancol_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","yasmAt puNyaprAptyartham antaHkaraNEna vizvasitavyaM paritrANArthanjca vadanEna svIkarttavyaM| ");
INSERT INTO sancol_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","zAstrE yAdRzaM likhati vizvasiSyati yastatra sa janO na trapiSyatE| ");
INSERT INTO sancol_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","ityatra yihUdini tadanyalOkE ca kOpi vizESO nAsti yasmAd yaH sarvvESAm advitIyaH prabhuH sa nijayAcakAna sarvvAn prati vadAnyO bhavati| ");
INSERT INTO sancol_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","yataH, yaH kazcit paramEzasya nAmnA hi prArthayiSyatE| sa Eva manujO nUnaM paritrAtO bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","yaM yE janA na pratyAyan tE tamuddizya kathaM prArthayiSyantE? yE vA yasyAkhyAnaM kadApi na zrutavantastE taM kathaM pratyESyanti? aparaM yadi pracArayitArO na tiSThanti tadA kathaM tE zrOSyanti? ");
INSERT INTO sancol_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","yadi vA prEritA na bhavanti tadA kathaM pracArayiSyanti? yAdRzaM likhitam AstE, yathA, mAggalikaM susaMvAdaM dadatyAnIya yE narAH| pracArayanti zAntEzca susaMvAdaM janAstu yE| tESAM caraNapadmAni kIdRk zObhAnvitAni hi| ");
INSERT INTO sancol_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","kintu tE sarvvE taM susaMvAdaM na gRhItavantaH| yizAyiyO yathA likhitavAn| asmatpracAritE vAkyE vizvAsamakarOddhi kaH| ");
INSERT INTO sancol_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","ataEva zravaNAd vizvAsa aizvaravAkyapracArAt zravaNanjca bhavati| ");
INSERT INTO sancol_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","tarhyahaM bravImi taiH kiM nAzrAvi? avazyam azrAvi, yasmAt tESAM zabdO mahIM vyApnOd vAkyanjca nikhilaM jagat| ");
INSERT INTO sancol_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","aparamapi vadAmi, isrAyElIyalOkAH kim EtAM kathAM na budhyantE? prathamatO mUsA idaM vAkyaM prOvAca, ahamuttApayiSyE tAn agaNyamAnavairapi| klEkSyAmi jAtim EtAnjca prOnmattabhinnajAtibhiH| ");
INSERT INTO sancol_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","aparanjca yizAyiyO'tizayAkSObhENa kathayAmAsa, yathA, adhi mAM yaistu nAcESTi samprAptastai rjanairahaM| adhi mAM yai rna sampRSTaM vijnjAtastai rjanairahaM|| ");
INSERT INTO sancol_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","kintvisrAyElIyalOkAn adhi kathayAnjcakAra, yairAjnjAlagghibhi rlOkai rviruddhaM vAkyamucyatE| tAn pratyEva dinaM kRtsnaM hastau vistArayAmyahaM|| ");
INSERT INTO sancol_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","IzvarENa svIkIyalOkA apasAritA ahaM kim IdRzaM vAkyaM bravImi? tanna bhavatu yatO'hamapi binyAmInagOtrIya ibrAhImavaMzIya isrAyElIyalOkO'smi| ");
INSERT INTO sancol_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","IzvarENa pUrvvaM yE pradRSTAstE svakIyalOkA apasAritA iti nahi| aparam EliyOpAkhyAnE zAstrE yallikhitam AstE tad yUyaM kiM na jAnItha? ");
INSERT INTO sancol_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","hE paramEzvara lOkAstvadIyAH sarvvA yajnjavEdIrabhanjjan tathA tava bhaviSyadvAdinaH sarvvAn aghnan kEvala EkO'ham avaziSTa AsE tE mamApi prANAn nAzayituM cESTanatE, EtAM kathAm isrAyElIyalOkAnAM viruddham Eliya IzvarAya nivEdayAmAsa| ");
INSERT INTO sancol_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","tatastaM pratIzvarasyOttaraM kiM jAtaM? bAlnAmnO dEvasya sAkSAt yai rjAnUni na pAtitAni tAdRzAH sapta sahasrANi lOkA avazESitA mayA| ");
INSERT INTO sancol_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","tadvad Etasmin varttamAnakAlE'pi anugrahENAbhirucitAstESAm avaziSTAH katipayA lOkAH santi| ");
INSERT INTO sancol_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","ataEva tad yadyanugrahENa bhavati tarhi kriyayA na bhavati nO cEd anugrahO'nanugraha Eva, yadi vA kriyayA bhavati tarhyanugrahENa na bhavati nO cEt kriyA kriyaiva na bhavati| ");
INSERT INTO sancol_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","tarhi kiM? isrAyElIyalOkA yad amRgayanta tanna prApuH| kintvabhirucitalOkAstat prApustadanyE sarvva andhIbhUtAH| ");
INSERT INTO sancol_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","yathA likhitam AstE, ghOranidrAlutAbhAvaM dRSTihInE ca lOcanE| karNau zrutivihInau ca pradadau tEbhya IzvaraH|| ");
INSERT INTO sancol_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","EtEsmin dAyUdapi likhitavAn yathA, atO bhuktyAsanaM tESAm unmAthavad bhaviSyati| vA vaMzayantravad bAdhA daNPavad vA bhaviSyati|| ");
INSERT INTO sancol_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","bhaviSyanti tathAndhAstE nEtraiH pazyanti nO yathA| vEpathuH kaTidEzasya tESAM nityaM bhaviSyati|| ");
INSERT INTO sancol_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","patanArthaM tE skhalitavanta iti vAcaM kimahaM vadAmi? tanna bhavatu kintu tAn udyOginaH karttuM tESAM patanAd itaradEzIyalOkaiH paritrANaM prAptaM| ");
INSERT INTO sancol_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","tESAM patanaM yadi jagatO lOkAnAM lAbhajanakam abhavat tESAM hrAsO'pi yadi bhinnadEzinAM lAbhajanakO'bhavat tarhi tESAM vRddhiH kati lAbhajanikA bhaviSyati? ");
INSERT INTO sancol_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","atO hE anyadEzinO yuSmAn sambOdhya kathayAmi nijAnAM jnjAtibandhUnAM manaHsUdyOgaM janayan tESAM madhyE kiyatAM lOkAnAM yathA paritrANaM sAdhayAmi ");
INSERT INTO sancol_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","tannimittam anyadEzinAM nikaTE prEritaH san ahaM svapadasya mahimAnaM prakAzayAmi| ");
INSERT INTO sancol_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","tESAM nigrahENa yadIzvarENa saha jagatO janAnAM mElanaM jAtaM tarhi tESAm anugRhItatvaM mRtadEhE yathA jIvanalAbhastadvat kiM na bhaviSyati? ");
INSERT INTO sancol_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","aparaM prathamajAtaM phalaM yadi pavitraM bhavati tarhi sarvvamEva phalaM pavitraM bhaviSyati; tathA mUlaM yadi pavitraM bhavati tarhi zAkhA api tathaiva bhaviSyanti| ");
INSERT INTO sancol_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","kiyatInAM zAkhAnAM chEdanE kRtE tvaM vanyajitavRkSasya zAkhA bhUtvA yadi tacchAkhAnAM sthAnE rOpitA sati jitavRkSIyamUlasya rasaM bhuMkSE, ");
INSERT INTO sancol_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","tarhi tAsAM bhinnazAkhAnAM viruddhaM mAM garvvIH; yadi garvvasi tarhi tvaM mUlaM yanna dhArayasi kintu mUlaM tvAM dhArayatIti saMsmara| ");
INSERT INTO sancol_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","aparanjca yadi vadasi mAM rOpayituM tAH zAkhA vibhannA abhavan; ");
INSERT INTO sancol_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","bhadram, apratyayakAraNAt tE vibhinnA jAtAstathA vizvAsakAraNAt tvaM rOpitO jAtastasmAd ahagkAram akRtvA sasAdhvasO bhava| ");
INSERT INTO sancol_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","yata IzvarO yadi svAbhAvikIH zAkhA na rakSati tarhi sAvadhAnO bhava cEt tvAmapi na sthApayati| ");
INSERT INTO sancol_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","ityatrEzvarasya yAdRzI kRpA tAdRzaM bhayAnakatvamapi tvayA dRzyatAM; yE patitAstAn prati tasya bhayAnakatvaM dRzyatAM, tvanjca yadi tatkRpAzritastiSThasi tarhi tvAM prati kRpA drakSyatE; nO cEt tvamapi tadvat chinnO bhaviSyasi| ");
INSERT INTO sancol_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","aparanjca tE yadyapratyayE na tiSThanti tarhi punarapi rOpayiSyantE yasmAt tAn punarapi rOpayitum izvarasya zaktirAstE| ");
INSERT INTO sancol_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","vanyajitavRkSasya zAkhA san tvaM yadi tatazchinnO rItivyatyayEnOttamajitavRkSE rOेेpitO'bhavastarhi tasya vRkSasya svIyA yAH zAkhAstAH kiM punaH svavRkSE saMlagituM na zaknuvanti? ");
INSERT INTO sancol_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","hE bhrAtarO yuSmAkam AtmAbhimAnO yanna jAyatE tadarthaM mamEdRzI vAnjchA bhavati yUyaM EtannigUPhatattvam ajAnantO yanna tiSThatha; vastutO yAvatkAlaM sampUrNarUpENa bhinnadEzinAM saMgrahO na bhaviSyati tAvatkAlam aMzatvEna isrAyElIyalOkAnAm andhatA sthAsyati; ");
INSERT INTO sancol_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","pazcAt tE sarvvE paritrAsyantE; EtAdRzaM likhitamapyAstE, AgamiSyati sIyOnAd EkO yastrANadAyakaH| adharmmaM yAkubO vaMzAt sa tu dUrIkariSyati| ");
INSERT INTO sancol_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","tathA dUrIkariSyAmi tESAM pApAnyahaM yadA| tadA tairEva sArddhaM mE niyamO'yaM bhaviSyati| ");
INSERT INTO sancol_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","susaMvAdAt tE yuSmAkaM vipakSA abhavan kintvabhirucitatvAt tE pitRlOkAnAM kRtE priyapAtrANi bhavanti| ");
INSERT INTO sancol_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","yata Izvarasya dAnAd AhvAnAnjca pazcAttApO na bhavati| ");
INSERT INTO sancol_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","ataEva pUrvvam IzvarE'vizvAsinaH santO'pi yUyaM yadvat samprati tESAm avizvAsakAraNAd Izvarasya kRpApAtrANi jAtAstadvad ");
INSERT INTO sancol_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","idAnIM tE'vizvAsinaH santi kintu yuSmAbhi rlabdhakRpAkAraNAt tairapi kRpA lapsyatE| ");
INSERT INTO sancol_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","IzvaraH sarvvAn prati kRpAM prakAzayituM sarvvAn avizvAsitvEna gaNayati| ");
INSERT INTO sancol_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","ahO Izvarasya jnjAnabuddhirUpayO rdhanayOH kIdRk prAcuryyaM| tasya rAjazAsanasya tattvaM kIdRg aprApyaM| tasya mArgAzca kIdRg anupalakSyAH| ");
INSERT INTO sancol_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","paramEzvarasya sagkalpaM kO jnjAtavAn? tasya mantrI vA kO'bhavat? ");
INSERT INTO sancol_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","kO vA tasyOpakArI bhRtvA tatkRtE tEna pratyupakarttavyaH? ");
INSERT INTO sancol_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","yatO vastumAtramEva tasmAt tEna tasmai cAbhavat tadIyO mahimA sarvvadA prakAzitO bhavatu| iti| ");
INSERT INTO sancol_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","hE bhrAtara Izvarasya kRpayAhaM yuSmAn vinayE yUyaM svaM svaM zarIraM sajIvaM pavitraM grAhyaM balim Izvaramuddizya samutsRjata, ESA sEvA yuSmAkaM yOgyA| ");
INSERT INTO sancol_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","aparaM yUyaM sAMsArikA iva mAcarata, kintu svaM svaM svabhAvaM parAvartya nUtanAcAriNO bhavata, tata Izvarasya nidEzaH kIdRg uttamO grahaNIyaH sampUrNazcEti yuSmAbhiranubhAviSyatE| ");
INSERT INTO sancol_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","kazcidapi janO yOgyatvAdadhikaM svaM na manyatAM kintu IzvarO yasmai pratyayasya yatparimANam adadAt sa tadanusAratO yOgyarUpaM svaM manutAm, IzvarAd anugrahaM prAptaH san yuSmAkam EkaikaM janam ityAjnjApayAmi| ");
INSERT INTO sancol_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","yatO yadvadasmAkam Ekasmin zarIrE bahUnyaggAni santi kintu sarvvESAmaggAnAM kAryyaM samAnaM nahi; ");
INSERT INTO sancol_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","tadvadasmAkaM bahutvE'pi sarvvE vayaM khrISTE EkazarIrAH parasparam aggapratyaggatvEna bhavAmaH| ");
INSERT INTO sancol_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","asmAd IzvarAnugrahENa vizESaM vizESaM dAnam asmAsu prAptESu satsu kOpi yadi bhaviSyadvAkyaM vadati tarhi pratyayasya parimANAnusArataH sa tad vadatu; ");
INSERT INTO sancol_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","yadvA yadi kazcit sEvanakArI bhavati tarhi sa tatsEvanaM karOtu; athavA yadi kazcid adhyApayitA bhavati tarhi sO'dhyApayatu; ");
INSERT INTO sancol_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","tathA ya upadESTA bhavati sa upadizatu yazca dAtA sa saralatayA dadAtu yastvadhipatiH sa yatnEnAdhipatitvaM karOtu yazca dayAluH sa hRSTamanasA dayatAm| ");
INSERT INTO sancol_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","aparanjca yuSmAkaM prEma kApaTyavarjitaM bhavatu yad abhadraM tad RtIyadhvaM yacca bhadraM tasmin anurajyadhvam| ");
INSERT INTO sancol_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","aparaM bhrAtRtvaprEmnA parasparaM prIyadhvaM samAdarAd EkO'parajanaM zrESThaM jAnIdhvam| ");
INSERT INTO sancol_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","tathA kAryyE nirAlasyA manasi ca sOdyOgAH santaH prabhuM sEvadhvam| ");
INSERT INTO sancol_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","aparaM pratyAzAyAm AnanditA duHkhasamayE ca dhairyyayuktA bhavata; prArthanAyAM satataM pravarttadhvaM| ");
INSERT INTO sancol_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","pavitrANAM dInatAM dUrIkurudhvam atithisEvAyAm anurajyadhvam| ");
INSERT INTO sancol_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","yE janA yuSmAn tAPayanti tAn AziSaM vadata zApam adattvA daddhvamAziSam| ");
INSERT INTO sancol_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","yE janA Anandanti taiH sArddham Anandata yE ca rudanti taiH saha rudita| ");
INSERT INTO sancol_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","aparanjca yuSmAkaM manasAM parasparam EkObhAvO bhavatu; aparam uccapadam anAkAgkSya nIcalOkaiH sahApi mArdavam Acarata; svAn jnjAninO na manyadhvaM| ");
INSERT INTO sancol_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","parasmAd apakAraM prApyApi paraM nApakuruta| sarvvESAM dRSTitO yat karmmOttamaM tadEva kuruta| ");
INSERT INTO sancol_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","yadi bhavituM zakyatE tarhi yathAzakti sarvvalOkaiH saha nirvvirOdhEna kAlaM yApayata| ");
INSERT INTO sancol_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","hE priyabandhavaH, kasmaicid apakArasya samucitaM daNPaM svayaM na daddhvaM, kintvIzvarIyakrOdhAya sthAnaM datta yatO likhitamAstE paramEzvaraH kathayati, dAnaM phalasya matkarmma sUcitaM pradadAmyahaM| ");
INSERT INTO sancol_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","itikAraNAd ripu ryadi kSudhArttastE tarhi taM tvaM prabhOjaya| tathA yadi tRSArttaH syAt tarhi taM paripAyaya| tEna tvaM mastakE tasya jvaladagniM nidhAsyasi| ");
INSERT INTO sancol_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","kukriyayA parAjitA na santa uttamakriyayA kukriyAM parAjayata| ");
INSERT INTO sancol_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","yuSmAkam EkaikajanaH zAsanapadasya nighnO bhavatu yatO yAni zAsanapadAni santi tAni sarvvANIzvarENa sthApitAni; IzvaraM vinA padasthApanaM na bhavati| ");
INSERT INTO sancol_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","iti hEtOH zAsanapadasya yat prAtikUlyaM tad IzvarIyanirUpaNasya prAtikUlyamEva; aparaM yE prAtikUlyam Acaranti tE svESAM samucitaM daNPaM svayamEva ghaTayantE| ");
INSERT INTO sancol_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","zAstA sadAcAriNAM bhayapradO nahi durAcAriNAmEva bhayapradO bhavati; tvaM kiM tasmAn nirbhayO bhavitum icchasi? tarhi satkarmmAcara, tasmAd yazO lapsyasE, ");
INSERT INTO sancol_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","yatastava sadAcaraNAya sa Izvarasya bhRtyO'sti| kintu yadi kukarmmAcarasi tarhi tvaM zagkasva yataH sa nirarthakaM khaggaM na dhArayati; kukarmmAcAriNaM samucitaM daNPayitum sa Izvarasya daNPadabhRtya Eva| ");
INSERT INTO sancol_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","ataEva kEvaladaNPabhayAnnahi kintu sadasadbOdhAdapi tasya vazyEna bhavitavyaM| ");
INSERT INTO sancol_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","EtasmAd yuSmAkaM rAjakaradAnamapyucitaM yasmAd yE karaM gRhlanti ta Izvarasya kigkarA bhUtvA satatam Etasmin karmmaNi niviSTAstiSThanti| ");
INSERT INTO sancol_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","asmAt karagrAhiNE karaM datta, tathA zulkagrAhiNE zulkaM datta, aparaM yasmAd bhEtavyaM tasmAd bibhIta, yazca samAdaraNIyastaM samAdriyadhvam; itthaM yasya yat prApyaM tat tasmai datta| ");
INSERT INTO sancol_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","yuSmAkaM parasparaM prEma vinA 'nyat kimapi dEyam RNaM na bhavatu, yatO yaH parasmin prEma karOti tEna vyavasthA sidhyati| ");
INSERT INTO sancol_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","vastutaH paradArAn mA gaccha, narahatyAM mA kArSIH, cairyyaM mA kArSIH, mithyAsAkSyaM mA dEhi, lObhaM mA kArSIH, EtAH sarvvA AjnjA EtAbhyO bhinnA yA kAcid AjnjAsti sApi svasamIpavAsini svavat prEma kurvvityanEna vacanEna vEditA| ");
INSERT INTO sancol_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","yataH prEma samIpavAsinO'zubhaM na janayati tasmAt prEmnA sarvvA vyavasthA pAlyatE| ");
INSERT INTO sancol_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","pratyayIbhavanakAlE'smAkaM paritrANasya sAmIpyAd idAnIM tasya sAmIpyam avyavahitaM; ataH samayaM vivicyAsmAbhiH sAmpratam avazyamEva nidrAtO jAgarttavyaM| ");
INSERT INTO sancol_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","bahutarA yAminI gatA prabhAtaM sannidhiM prAptaM tasmAt tAmasIyAH kriyAH parityajyAsmAbhi rvAsarIyA sajjA paridhAtavyA| ");
INSERT INTO sancol_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","atO hEtO rvayaM divA vihitaM sadAcaraNam AcariSyAmaH| raggarasO mattatvaM lampaTatvaM kAmukatvaM vivAda IrSyA caitAni parityakSyAmaH| ");
INSERT INTO sancol_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","yUyaM prabhuyIzukhrISTarUpaM paricchadaM paridhaddhvaM sukhAbhilASapUraNAya zArIrikAcaraNaM mAcarata| ");
INSERT INTO sancol_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","yO janO'dRPhavizvAsastaM yuSmAkaM sagginaM kuruta kintu sandEhavicArArthaM nahi| ");
INSERT INTO sancol_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","yatO niSiddhaM kimapi khAdyadravyaM nAsti, kasyacijjanasya pratyaya EtAdRzO vidyatE kintvadRPhavizvAsaH kazcidaparO janaH kEvalaM zAkaM bhugktaM| ");
INSERT INTO sancol_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","tarhi yO janaH sAdhAraNaM dravyaM bhugktE sa vizESadravyabhOktAraM nAvajAnIyAt tathA vizESadravyabhOktApi sAdhAraNadravyabhOktAraM dOSiNaM na kuryyAt, yasmAd Izvarastam agRhlAt| ");
INSERT INTO sancol_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","hE paradAsasya dUSayitastvaM kaH? nijaprabhOH samIpE tEna padasthEna padacyutEna vA bhavitavyaM sa ca padastha Eva bhaviSyati yata IzvarastaM padasthaM karttuM zaknOti| ");
INSERT INTO sancol_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","aparanjca kazcijjanO dinAd dinaM vizESaM manyatE kazcittuु sarvvANi dinAni samAnAni manyatE, EkaikO janaH svIyamanasi vivicya nizcinOtu| ");
INSERT INTO sancol_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","yO janaH kinjcana dinaM vizESaM manyatE sa prabhubhaktyA tan manyatE, yazca janaH kimapi dinaM vizESaM na manyatE sO'pi prabhubhaktyA tanna manyatE; aparanjca yaH sarvvANi bhakSyadravyANi bhugktE sa prabhubhaktayA tAni bhugktE yataH sa IzvaraM dhanyaM vakti, yazca na bhugktE sO'pi prabhubhaktyaiva na bhunjjAna IzvaraM dhanyaM brUtE| ");
INSERT INTO sancol_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","aparam asmAkaM kazcit nijanimittaM prANAn dhArayati nijanimittaM mriyatE vA tanna; ");
INSERT INTO sancol_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","kintu yadi vayaM prANAn dhArayAmastarhi prabhunimittaM dhArayAmaH, yadi ca prANAn tyajAmastarhyapi prabhunimittaM tyajAmaH, ataEva jIvanE maraNE vA vayaM prabhOrEvAsmahE| ");
INSERT INTO sancol_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","yatO jIvantO mRtAzcEtyubhayESAM lOkAnAM prabhutvaprAptyarthaM khrISTO mRta utthitaH punarjIvitazca| ");
INSERT INTO sancol_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","kintu tvaM nijaM bhrAtaraM kutO dUSayasi? tathA tvaM nijaM bhrAtaraM kutastucchaM jAnAsi? khrISTasya vicArasiMhAsanasya sammukhE sarvvairasmAbhirupasthAtavyaM; ");
INSERT INTO sancol_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","yAdRzaM likhitam AstE, parEzaH zapathaM kurvvan vAkyamEtat purAvadat| sarvvO janaH samIpE mE jAnupAtaM kariSyati| jihvaikaikA tathEzasya nighnatvaM svIkariSyati| ");
INSERT INTO sancol_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","ataEva IzvarasamIpE'smAkam EkaikajanEna nijA kathA kathayitavyA| ");
INSERT INTO sancol_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","itthaM sati vayam adyArabhya parasparaM na dUSayantaH svabhrAtu rvighnO vyAghAtO vA yanna jAyEta tAdRzImIhAM kurmmahE| ");
INSERT INTO sancol_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","kimapi vastu svabhAvatO nAzuci bhavatItyahaM jAnE tathA prabhunA yIzukhrISTEnApi nizcitaM jAnE, kintu yO janO yad dravyam apavitraM jAnItE tasya kRtE tad apavitram AstE| ");
INSERT INTO sancol_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","ataEva tava bhakSyadravyENa tava bhrAtA zOkAnvitO bhavati tarhi tvaM bhrAtaraM prati prEmnA nAcarasi| khrISTO yasya kRtE svaprANAn vyayitavAn tvaM nijEna bhakSyadravyENa taM na nAzaya| ");
INSERT INTO sancol_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","aparaM yuSmAkam uttamaM karmma ninditaM na bhavatu| ");
INSERT INTO sancol_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","bhakSyaM pEyanjcEzvararAjyasya sArO nahi, kintu puNyaM zAntizca pavitrENAtmanA jAta Anandazca| ");
INSERT INTO sancol_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Etai ryO janaH khrISTaM sEvatE, sa EvEzvarasya tuSTikarO manuSyaizca sukhyAtaH| ");
INSERT INTO sancol_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","ataEva yEnAsmAkaM sarvvESAM parasparam aikyaM niSThA ca jAyatE tadEvAsmAbhi ryatitavyaM| ");
INSERT INTO sancol_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","bhakSyArtham Izvarasya karmmaNO hAniM mA janayata; sarvvaM vastu pavitramiti satyaM tathApi yO janO yad bhuktvA vighnaM labhatE tadarthaM tad bhadraM nahi| ");
INSERT INTO sancol_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","tava mAMsabhakSaNasurApAnAdibhiH kriyAbhi ryadi tava bhrAtuH pAdaskhalanaM vighnO vA cAnjcalyaM vA jAyatE tarhi tadbhOjanapAnayOstyAgO bhadraH| ");
INSERT INTO sancol_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","yadi tava pratyayastiSThati tarhIzvarasya gOcarE svAntarE taM gOpaya; yO janaH svamatEna svaM dOSiNaM na karOti sa Eva dhanyaH| ");
INSERT INTO sancol_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","kintu yaH kazcit saMzayya bhugktE'rthAt na pratItya bhugktE, sa EvAvazyaM daNPArhO bhaviSyati, yatO yat pratyayajaM nahi tadEva pApamayaM bhavati| ");
INSERT INTO sancol_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","balavadbhirasmAbhi rdurbbalAnAM daurbbalyaM sOPhavyaM na ca svESAm iSTAcAra AcaritavyaH| ");
INSERT INTO sancol_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","asmAkam EkaikO janaH svasamIpavAsinO hitArthaM niSThArthanjca tasyaivESTAcAram Acaratu| ");
INSERT INTO sancol_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","yataH khrISTO'pi nijESTAcAraM nAcaritavAn, yathA likhitam AstE, tvannindakagaNasyaiva nindAbhi rninditO'smyahaM| ");
INSERT INTO sancol_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","aparanjca vayaM yat sahiSNutAsAntvanayO rjanakEna zAstrENa pratyAzAM labhEmahi tannimittaM pUrvvakAlE likhitAni sarvvavacanAnyasmAkam upadEzArthamEva lilikhirE| ");
INSERT INTO sancol_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","sahiSNutAsAntvanayOrAkarO ya IzvaraH sa EvaM karOtu yat prabhu ryIzukhrISTa iva yuSmAkam EkajanO'nyajanEna sArddhaM manasa aikyam AcarEt; ");
INSERT INTO sancol_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","yUyanjca sarvva EkacittA bhUtvA mukhaikEnEvAsmatprabhuyIzukhrISTasya piturIzvarasya guNAn kIrttayEta| ");
INSERT INTO sancol_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","aparam Izvarasya mahimnaH prakAzArthaM khrISTO yathA yuSmAn pratyagRhlAt tathA yuSmAkamapyEkO janO'nyajanaM pratigRhlAtu| ");
INSERT INTO sancol_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","yathA likhitam AstE, atO'haM sammukhE tiSThan bhinnadEzanivAsinAM| stuvaMstvAM parigAsyAmi tava nAmni parEzvara|| ");
INSERT INTO sancol_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","tasya dayAlutvAcca bhinnajAtIyA yad Izvarasya guNAn kIrttayEyustadarthaM yIzuH khrISTastvakchEdaniyamasya nighnO'bhavad ityahaM vadAmi| yathA likhitam AstE, atO'haM sammukhE tiSThan bhinnadEzanivAsinAM| stuvaMstvAM parigAsyAmi tava nAmni parEzvara|| ");
INSERT INTO sancol_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","aparamapi likhitam AstE, hE anyajAtayO yUyaM samaM nandata tajjanaiH| ");
INSERT INTO sancol_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","punazca likhitam AstE, hE sarvvadEzinO yUyaM dhanyaM brUta parEzvaraM| hE tadIyanarA yUyaM kurudhvaM tatprazaMsanaM|| ");
INSERT INTO sancol_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","apara yIzAyiyO'pi lilEkha, yIzayasya tu yat mUlaM tat prakAziSyatE tadA| sarvvajAtIyanRNAnjca zAsakaH samudESyati| tatrAnyadEzilOkaizca pratyAzA prakariSyatE|| ");
INSERT INTO sancol_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","ataEva yUyaM pavitrasyAtmanaH prabhAvAd yat sampUrNAM pratyAzAM lapsyadhvE tadarthaM tatpratyAzAjanaka IzvaraH pratyayEna yuSmAn zAntyAnandAbhyAM sampUrNAn karOtu| ");
INSERT INTO sancol_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","hE bhrAtarO yUyaM sadbhAvayuktAH sarvvaprakArENa jnjAnEna ca sampUrNAH parasparOpadEzE ca tatparA ityahaM nizcitaM jAnAmi, ");
INSERT INTO sancol_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","tathApyahaM yat pragalbhatarO bhavan yuSmAn prabOdhayAmi tasyaikaM kAraNamidaM| ");
INSERT INTO sancol_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","bhinnajAtIyAH pavitrENAtmanA pAvitanaivEdyarUpA bhUtvA yad grAhyA bhavEyustannimittamaham Izvarasya susaMvAdaM pracArayituM bhinnajAtIyAnAM madhyE yIzukhrISTasya sEvakatvaM dAnaM IzvarAt labdhavAnasmi| ");
INSERT INTO sancol_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","IzvaraM prati yIzukhrISTEna mama zlAghAkaraNasya kAraNam AstE| ");
INSERT INTO sancol_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","bhinnadEzina AjnjAgrAhiNaH karttuM khrISTO vAkyEna kriyayA ca, AzcaryyalakSaNaizcitrakriyAbhiH pavitrasyAtmanaH prabhAvEna ca yAni karmmANi mayA sAdhitavAn, ");
INSERT INTO sancol_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","kEvalaM tAnyEva vinAnyasya kasyacit karmmaNO varNanAM karttuM pragalbhO na bhavAmi| tasmAt A yirUzAlama illUrikaM yAvat sarvvatra khrISTasya susaMvAdaM prAcArayaM| ");
INSERT INTO sancol_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","anyEna nicitAyAM bhittAvahaM yanna nicinOmi tannimittaM yatra yatra sthAnE khrISTasya nAma kadApi kEnApi na jnjApitaM tatra tatra susaMvAdaM pracArayitum ahaM yatE| ");
INSERT INTO sancol_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","yAdRzaM likhitam AstE, yai rvArttA tasya na prAptA darzanaM taistu lapsyatE| yaizca naiva zrutaM kinjcit bOddhuM zakSyanti tE janAH|| ");
INSERT INTO sancol_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","tasmAd yuSmatsamIpagamanAd ahaM muhurmuhu rnivAritO'bhavaM| ");
INSERT INTO sancol_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","kintvidAnIm atra pradEzESu mayA na gataM sthAnaM kimapi nAvaziSyatE yuSmatsamIpaM gantuM bahuvatsarAnArabhya mAmakInAkAgkSA ca vidyata iti hEtOH ");
INSERT INTO sancol_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","spAniyAdEzagamanakAlE'haM yuSmanmadhyEna gacchan yuSmAn AlOkiSyE, tataH paraM yuSmatsambhASaNEna tRptiM parilabhya taddEzagamanArthaM yuSmAbhi rvisarjayiSyE, IdRzI madIyA pratyAzA vidyatE| ");
INSERT INTO sancol_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","kintu sAmprataM pavitralOkAnAM sEvanAya yirUzAlamnagaraM vrajAmi| ");
INSERT INTO sancol_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","yatO yirUzAlamasthapavitralOkAnAM madhyE yE daridrA arthavizrANanEna tAnupakarttuM mAkidaniyAdEzIyA AkhAyAdEzIyAzca lOkA aicchan| ");
INSERT INTO sancol_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","ESA tESAM sadicchA yatastE tESAm RNinaH santi yatO hEtO rbhinnajAtIyA yESAM paramArthasyAMzinO jAtA aihikaviSayE tESAmupakArastaiH karttavyaH| ");
INSERT INTO sancol_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","atO mayA tat karmma sAdhayitvA tasmin phalE tEbhyaH samarpitE yuSmanmadhyEna spAniyAdEzO gamiSyatE| ");
INSERT INTO sancol_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","yuSmatsamIpE mamAgamanasamayE khrISTasya susaMvAdasya pUrNavarENa sambalitaH san aham AgamiSyAmi iti mayA jnjAyatE| ");
INSERT INTO sancol_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","hE bhrAtRgaNa prabhO ryIzukhrISTasya nAmnA pavitrasyAtmAnaH prEmnA ca vinayE'haM ");
INSERT INTO sancol_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","yihUdAdEzasthAnAm avizvAsilOkAnAM karEbhyO yadahaM rakSAM labhEya madIyaitEna sEvanakarmmaNA ca yad yirUzAlamasthAH pavitralOkAstuSyEyuH, ");
INSERT INTO sancol_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","tadarthaM yUyaM matkRta IzvarAya prArthayamANA yatadhvaM tEnAham IzvarEcchayA sAnandaM yuSmatsamIpaM gatvA yuSmAbhiH sahitaH prANAn ApyAyituM pArayiSyAmi| ");
INSERT INTO sancol_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","zAntidAyaka IzvarO yuSmAkaM sarvvESAM saggI bhUyAt| iti| ");
INSERT INTO sancol_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","kiMkrIyAnagarIyadharmmasamAjasya paricArikA yA phaibInAmikAsmAkaM dharmmabhaginI tasyAH kRtE'haM yuSmAn nivEdayAmi, ");
INSERT INTO sancol_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","yUyaM tAM prabhumAzritAM vijnjAya tasyA AtithyaM pavitralOkArhaM kurudhvaM, yuSmattastasyA ya upakArO bhavituM zaknOti taM kurudhvaM, yasmAt tayA bahUnAM mama cOpakAraH kRtaH| ");
INSERT INTO sancol_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","aparanjca khrISTasya yIzOH karmmaNi mama sahakAriNau mama prANarakSArthanjca svaprANAn paNIkRtavantau yau priSkillAkkilau tau mama namaskAraM jnjApayadhvaM| ");
INSERT INTO sancol_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","tAbhyAm upakArAptiH kEvalaM mayA svIkarttavyEti nahi bhinnadEzIyaiH sarvvadharmmasamAjairapi| ");
INSERT INTO sancol_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","aparanjca tayO rgRhE sthitAn dharmmasamAjalOkAn mama namaskAraM jnjApayadhvaM| tadvat AziyAdEzE khrISTasya pakSE prathamajAtaphalasvarUpO ya ipEnitanAmA mama priyabandhustamapi mama namaskAraM jnjApayadhvaM| ");
INSERT INTO sancol_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","aparaM bahuzramENAsmAn asEvata yA mariyam tAmapi namaskAraM jnjApayadhvaM| ");
INSERT INTO sancol_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","aparanjca prEritESu khyAtakIrttI madagrE khrISTAzritau mama svajAtIyau sahabandinau ca yAvAndranIkayUniyau tau mama namaskAraM jnjApayadhvaM| ");
INSERT INTO sancol_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","tathA prabhau matpriyatamam Ampliyamapi mama namaskAraM jnjApayadhvaM| ");
INSERT INTO sancol_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","aparaM khrISTasEvAyAM mama sahakAriNam UrbbANaM mama priyatamaM stAkhunjca mama namaskAraM jnjApayadhvaM| ");
INSERT INTO sancol_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","aparaM khrISTEna parIkSitam ApilliM mama namaskAraM vadata, AriSTabUlasya parijanAMzca mama namaskAraM jnjApayadhvaM| ");
INSERT INTO sancol_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","aparaM mama jnjAtiM hEr