﻿USE sofia;
DROP TABLE IF EXISTS sofia.sanbur_vpl;
CREATE TABLE sanbur_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sanbur_vpl WRITE;
INSERT INTO sanbur_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ဣဗြာဟီမး သန္တာနော ဒါယူဒ် တသျ သန္တာနော ယီၑုခြီၐ္ဋသ္တသျ ပူရွွပုရုၐဝံၑၑြေဏီ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","ဣဗြာဟီမး ပုတြ ဣသှာက် တသျ ပုတြော ယာကူဗ် တသျ ပုတြော ယိဟူဒါသ္တသျ ဘြာတရၑ္စ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","တသ္မာဒ် ယိဟူဒါတသ္တာမရော ဂရ္ဘေ ပေရဿေရဟော် ဇဇ္ဉာတေ, တသျ ပေရသး ပုတြော ဟိၐြောဏ် တသျ ပုတြော 'ရာမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","တသျ ပုတြော 'မ္မီနာဒဗ် တသျ ပုတြော နဟၑောန် တသျ ပုတြး သလ္မောန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","တသ္မာဒ် ရာဟဗော ဂရ္ဘေ ဗောယမ် ဇဇ္ဉေ, တသ္မာဒ် ရူတော ဂရ္ဘေ ဩဗေဒ် ဇဇ္ဉေ, တသျ ပုတြော ယိၑယး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","တသျ ပုတြော ဒါယူဒ် ရာဇး တသ္မာဒ် မၖတောရိယသျ ဇာယာယာံ သုလေမာန် ဇဇ္ဉေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","တသျ ပုတြော ရိဟဗိယာမ်, တသျ ပုတြော'ဗိယး, တသျ ပုတြ အာသာ:၊ ");
INSERT INTO sanbur_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","တသျ သုတော ယိဟောၑာဖဋ် တသျ သုတော ယိဟောရာမ တသျ သုတ ဥၐိယး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","တသျ သုတော ယောထမ် တသျ သုတ အာဟမ် တသျ သုတော ဟိၐ္ကိယး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","တသျ သုတော မိနၑိး, တသျ သုတ အာမောန် တသျ သုတော ယောၑိယး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ဗာဗိလ္နဂရေ ပြဝသနာတ် ပူရွွံ သ ယောၑိယော ယိခနိယံ တသျ ဘြာတၖံၑ္စ ဇနယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","တတော ဗာဗိလိ ပြဝသနကာလေ ယိခနိယး ၑလ္တီယေလံ ဇနယာမာသ, တသျ သုတး သိရုဗ္ဗာဝိလ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","တသျ သုတော 'ဗောဟုဒ် တသျ သုတ ဣလီယာကီမ် တသျ သုတော'သောရ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","အသောရး သုတး သာဒေါက် တသျ သုတ အာခီမ် တသျ သုတ ဣလီဟူဒ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","တသျ သုတ ဣလိယာသရ် တသျ သုတော မတ္တန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","တသျ သုတော ယာကူဗ် တသျ သုတော ယူၐဖ် တသျ ဇာယာ မရိယမ်; တသျ ဂရ္ဘေ ယီၑုရဇနိ, တမေဝ ခြီၐ္ဋမ် (အရ္ထာဒ် အဘိၐိက္တံ) ဝဒန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ဣတ္ထမ် ဣဗြာဟီမော ဒါယူဒံ ယာဝတ် သာကလျေန စတုရ္ဒၑပုရုၐား; အာ ဒါယူဒး ကာလာဒ် ဗာဗိလိ ပြဝသနကာလံ ယာဝတ် စတုရ္ဒၑပုရုၐာ ဘဝန္တိ၊ ဗာဗိလိ ပြဝါသနကာလာတ် ခြီၐ္ဋသျ ကာလံ ယာဝတ် စတုရ္ဒၑပုရုၐာ ဘဝန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","ယီၑုခြီၐ္ဋသျ ဇန္မ ကထ္ထတေ၊ မရိယမ် နာမိကာ ကနျာ ယူၐဖေ ဝါဂ္ဒတ္တာသီတ်, တဒါ တယေား သင်္ဂမာတ် ပြာက် သာ ကနျာ  ပဝိတြေဏာတ္မနာ ဂရ္ဘဝတီ ဗဘူဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","တတြ တသျား ပတိ ရျူၐဖ် သော်ဇနျာတ် တသျား ကလင်္ဂံ ပြကာၑယိတုမ် အနိစ္ဆန် ဂေါပနေနေ တာံ ပါရိတျက္တုံ မနၑ္စကြေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","သ တထဲဝ ဘာဝယတိ, တဒါနီံ ပရမေၑွရသျ ဒူတး သွပ္နေ တံ ဒရ္ၑနံ ဒတ္တွာ ဝျာဇဟာရ, ဟေ ဒါယူဒး သန္တာန ယူၐဖ် တွံ နိဇာံ ဇာယာံ မရိယမမ် အာဒါတုံ မာ ဘဲၐီး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","ယတသ္တသျာ ဂရ္ဘး ပဝိတြာဒါတ္မနော'ဘဝတ်, သာ စ ပုတြံ ပြသဝိၐျတေ, တဒါ တွံ တသျ နာမ ယီၑုမ် (အရ္ထာတ် တြာတာရံ) ကရီၐျသေ, ယသ္မာတ် သ နိဇမနုဇာန် တေၐာံ ကလုၐေဘျ ဥဒ္ဓရိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ဣတ္ထံ သတိ, ပၑျ ဂရ္ဘဝတီ ကနျာ တနယံ ပြသဝိၐျတေ၊ ဣမ္မာနူယေလ် တဒီယဉ္စ နာမဓေယံ ဘဝိၐျတိ။ ဣမ္မာနူယေလ် အသ္မာကံ သင်္ဂီၑွရဣတျရ္ထး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","ဣတိ ယဒ် ဝစနံ ပုရွွံ ဘဝိၐျဒွက္တြာ ဤၑွရး ကထာယာမာသ, တတ် တဒါနီံ သိဒ္ဓမဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","အနန္တရံ ယူၐဖ် နိဒြာတော ဇာဂရိတ ဥတ္ထာယ ပရမေၑွရီယဒူတသျ နိဒေၑာနုသာရေဏ နိဇာံ ဇာယာံ ဇဂြာဟ, ");
INSERT INTO sanbur_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ကိန္တု ယာဝတ် သာ နိဇံ ပြထမသုတံ အ သုၐုဝေ, တာဝတ် တာံ နောပါဂစ္ဆတ်, တတး သုတသျ နာမ ယီၑုံ စကြေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","အနန္တရံ ဟေရောဒ် သံဇ္ဉကေ ရာဇ္ဉိ ရာဇျံ ၑာသတိ ယိဟူဒီယဒေၑသျ ဗဲတ္လေဟမိ နဂရေ ယီၑော် ဇာတဝတိ စ, ကတိပယာ ဇျောတိရွွုဒး ပူရွွသျာ ဒိၑော ယိရူၑာလမ္နဂရံ သမေတျ ကထယမာသုး, ");
INSERT INTO sanbur_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ယော ယိဟူဒီယာနာံ ရာဇာ ဇာတဝါန်, သ ကုတြာသ္တေ? ဝယံ ပူရွွသျာံ ဒိၑိ တိၐ္ဌန္တသ္တဒီယာံ တာရကာမ် အပၑျာမ တသ္မာတ် တံ ပြဏန္တုမ် အाဂမာမ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","တဒါ ဟေရောဒ် ရာဇာ ကထာမေတာံ နိၑမျ ယိရူၑာလမ္နဂရသ္ထိတဲး သရွွမာနဝဲး သာရ္ဒ္ဓမ် ဥဒွိဇျ ");
INSERT INTO sanbur_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","သရွွာန် ပြဓာနယာဇကာန် အဓျာပကာံၑ္စ သမာဟူယာနီယ ပပြစ္ဆ, ခြီၐ္ဋး ကုတြ ဇနိၐျတေ? ");
INSERT INTO sanbur_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","တဒါ တေ ကထယာမာသုး, ယိဟူဒီယဒေၑသျ ဗဲတ္လေဟမိ နဂရေ, ယတော ဘဝိၐျဒွါဒိနာ ဣတ္ထံ လိခိတမာသ္တေ, ");
INSERT INTO sanbur_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","သရွွာဘျော ရာဇဓာနီဘျော ယိဟူဒီယသျ နီဝၖတး၊ ဟေ ယီဟူဒီယဒေၑသျေ ဗဲတ္လေဟမ် တွံ န စာဝရာ၊ ဣသြာယေလီယလောကာန် မေ ယတော ယး ပါလယိၐျတိ၊ တာဒၖဂေကော မဟာရာဇသ္တွန္မဓျ ဥဒ္ဘဝိၐျတီ။ ");
INSERT INTO sanbur_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","တဒါနီံ ဟေရောဒ် ရာဇာ တာန် ဇျောတိရွွိဒေါ ဂေါပနမ် အာဟူယ သာ တာရကာ ကဒါ ဒၖၐ္ဋာဘဝတ် , တဒ် ဝိနိၑ္စယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","အပရံ တာန် ဗဲတ္လေဟမံ ပြဟီတျ ဂဒိတဝါန်, ယူယံ ယာတ, ယတ္နာတ် တံ ၑိၑုမ် အနွိၐျ တဒုဒ္ဒေၑေ ပြာပ္တေ မဟျံ ဝါရ္တ္တာံ ဒါသျထ, တတော မယာပိ ဂတွာ သ ပြဏံသျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","တဒါနီံ ရာဇ္ဉ ဧတာဒၖၑီမ် အာဇ္ဉာံ ပြာပျ တေ ပြတသ္ထိရေ, တတး ပူရွွရ္သျာံ ဒိၑိ သ္ထိတဲသ္တဲ ရျာ တာရကာ ဒၖၐ္ဋာ သာ တာရကာ တေၐာမဂြေ ဂတွာ ယတြ သ္ထာနေ ၑိၑူရာသ္တေ, တသျ သ္ထာနသျောပရိ သ္ထဂိတာ တသျော်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","တဒ် ဒၖၐ္ဋွာ တေ မဟာနန္ဒိတာ ဗဘူဝုး, ");
INSERT INTO sanbur_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","တတော ဂေဟမဓျ ပြဝိၑျ တသျ မာတြာ မရိယမာ သာဒ္ဓံ တံ ၑိၑုံ နိရီက္ၐယ ဒဏ္ဍဝဒ် ဘူတွာ ပြဏေမုး, အပရံ သွေၐာံ ဃနသမ္ပတ္တိံ မောစယိတွာ သုဝရ္ဏံ ကုန္ဒုရုံ ဂန္ဓရမဉ္စ တသ္မဲ ဒရ္ၑနီယံ ဒတ္တဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ပၑ္စာဒ် ဟေရောဒ် ရာဇသျ သမီပံ ပုနရပိ ဂန္တုံ သွပ္န ဤၑွရေဏ နိၐိဒ္ဓါး သန္တော 'နျေန ပထာ တေ နိဇဒေၑံ ပြတိ ပြတသ္ထိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","အနန္တရံ တေၐု ဂတဝတ္မု ပရမေၑွရသျ ဒူတော ယူၐဖေ သွပ္နေ ဒရ္ၑနံ ဒတွာ ဇဂါဒ, တွမ် ဥတ္ထာယ ၑိၑုံ တန္မာတရဉ္စ ဂၖဟီတွာ မိသရ္ဒေၑံ ပလာယသွ, အပရံ ယာဝဒဟံ တုဘျံ ဝါရ္တ္တာံ န ကထယိၐျာမိ, တာဝတ် တတြဲဝ နိဝသ, ယတော ရာဇာ ဟေရောဒ် ၑိၑုံ နာၑယိတုံ မၖဂယိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","တဒါနီံ ယူၐဖ် ဥတ္ထာယ ရဇနျာံ ၑိၑုံ တန္မာတရဉ္စ ဂၖဟီတွာ မိသရ္ဒေၑံ ပြတိ ပြတသ္ထေ, ");
INSERT INTO sanbur_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ဂတွာ စ ဟေရောဒေါ နၖပတေ ရ္မရဏပရျျန္တံ တတြ ဒေၑေ နျုဝါသ, တေန မိသရ္ဒေၑာဒဟံ ပုတြံ သွကီယံ သမုပါဟူယမ်၊ ယဒေတဒွစနမ် ဤၑွရေဏ ဘဝိၐျဒွါဒိနာ ကထိတံ တတ် သဖလမဘူတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","အနန္တရံ ဟေရောဒ် ဇျောတိရွိဒ္ဘိရာတ္မာနံ ပြဝဉ္စိတံ ဝိဇ္ဉာယ ဘၖၑံ စုကောပ; အပရံ ဇျောတိရွွိဒ္ဘျသ္တေန ဝိနိၑ္စိတံ ယဒ် ဒိနံ တဒ္ဒိနာဒ် ဂဏယိတွာ ဒွိတီယဝတ္သရံ ပြဝိၐ္ဋာ ယာဝန္တော ဗာလကာ အသ္မိန် ဗဲတ္လေဟမ္နဂရေ တတ္သီမမဓျေ စာသန်, လောကာန် ပြဟိတျ တာန် သရွွာန် ဃာတယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","အတး အနေကသျ ဝိလာပသျ နိနာဒ: ကြန္ဒနသျ စ၊ ၑောကေန ကၖတၑဗ္ဒၑ္စ ရာမာယာံ သံနိၑမျတေ၊ သွဗာလဂဏဟေတောရွဲ ရာဟေလ် နာရီ တု ရောဒိနီ၊ န မနျတေ ပြဗောဓန္တု ယတသ္တေ နဲဝ မန္တိ ဟိ။ ");
INSERT INTO sanbur_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","ယဒေတဒ် ဝစနံ ယိရီမိယနာမကဘဝိၐျဒွါဒိနာ ကထိတံ တတ် တဒါနီံ သဖလမ် အဘူတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","တဒနန္တရံ ဟေရေဒိ ရာဇနိ မၖတေ ပရမေၑွရသျ ဒူတော မိသရ္ဒေၑေ သွပ္နေ ဒရ္ၑနံ ဒတ္တွာ ယူၐဖေ ကထိတဝါန္ ");
INSERT INTO sanbur_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","တွမ် ဥတ္ထာယ ၑိၑုံ တန္မာတရဉ္စ ဂၖဟီတွာ ပုနရပီသြာယေလော ဒေၑံ ယာဟီ, ယေ ဇနား ၑိၑုံ နာၑယိတုမ် အမၖဂယန္တ, တေ မၖတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","တဒါနီံ သ ဥတ္ထာယ ၑိၑုံ တန္မာတရဉ္စ ဂၖဟ္လန် ဣသြာယေလ္ဒေၑမ် အာဇဂါမ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","ကိန္တု ယိဟူဒီယဒေၑေ အရ္ခိလာယနာမ ရာဇကုမာရော နိဇပိတု ရှေရောဒး ပဒံ ပြာပျ ရာဇတွံ ကရောတီတိ နိၑမျ တတ် သ္ထာနံ ယာတုံ ၑင်္ကိတဝါန်, ပၑ္စာတ် သွပ္န ဤၑွရာတ် ပြဗောဓံ ပြာပျ ဂါလီလ္ဒေၑသျ ပြဒေၑဲကံ ပြသ္ထာယ နာသရန္နာမ နဂရံ ဂတွာ တတြ နျုၐိတဝါန်, ");
INSERT INTO sanbur_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","တေန တံ နာသရတီယံ ကထယိၐျန္တိ, ယဒေတဒွါကျံ ဘဝိၐျဒွါဒိဘိရုက္တ္တံ တတ် သဖလမဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","တဒါနောံ ယောဟ္န္နာမာ မဇ္ဇယိတာ ယိဟူဒီယဒေၑသျ ပြာန္တရမ် ဥပသ္ထာယ ပြစာရယန် ကထယာမာသ, ");
INSERT INTO sanbur_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","မနာံသိ ပရာဝရ္တ္တယတ, သွရ္ဂီယရာဇတွံ သမီပမာဂတမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ပရမေၑသျ ပန္ထာနံ ပရိၐ္ကုရုတ သရွွတး၊ တသျ ရာဇပထာံၑ္စဲဝ သမီကုရုတ သရွွထာ၊ ဣတျေတတ် ပြာန္တရေ ဝါကျံ ဝဒတး ကသျစိဒ် ရဝး။ ");
INSERT INTO sanbur_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ဧတဒွစနံ ယိၑယိယဘဝိၐျဒွါဒိနာ ယောဟနမုဒ္ဒိၑျ ဘာၐိတမ်၊ ယောဟနော ဝသနံ မဟာင်္ဂရောမဇံ တသျ ကဋော် စရ္မ္မကဋိဗန္ဓနံ; သ စ ၑူကကီဋာန် မဓု စ ဘုက္တဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","တဒါနီံ ယိရူၑာလမ္နဂရနိဝါသိနး သရွွေ ယိဟူဒိဒေၑီယာ ယရ္ဒ္ဒန္တဋိနျာ ဥဘယတဋသ္ထာၑ္စ မာနဝါ ဗဟိရာဂတျ တသျ သမီပေ ");
INSERT INTO sanbur_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","သွီယံ သွီယံ ဒုရိတမ် အင်္ဂီကၖတျ တသျာံ ယရ္ဒ္ဒနိ တေန မဇ္ဇိတာ ဗဘူဝုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","အပရံ ဗဟူန် ဖိရူၑိနး သိဒူကိနၑ္စ မနုဇာန် မံက္တုံ သွသမီပမ် အာဂစ္ဆ္တော ဝိလောကျ သ တာန် အဘိဒဓော်, ရေ ရေ ဘုဇဂဝံၑာ အာဂါမီနး ကောပါတ် ပလာယိတုံ ယုၐ္မာန် ကၑ္စေတိတဝါန်? ");
INSERT INTO sanbur_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","မနးပရာဝရ္တ္တနသျ သမုစိတံ ဖလံ ဖလတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ကိန္တွသ္မာကံ တာတ ဣဗြာဟီမ် အသ္တီတိ သွေၐု မနးသု စီန္တယန္တော မာ ဝျာဟရတ၊ ယတော ယုၐ္မာန် အဟံ ဝဒါမိ, ဤၑွရ ဧတေဘျး ပါၐာဏေဘျ ဣဗြာဟီမး သန္တာနာန် ဥတ္ပာဒယိတုံ ၑက္နောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","အပရံ ပါဒပါနာံ မူလေ ကုဌာရ ဣဒါနီမပိ လဂန် အာသ္တေ, တသ္မာဒ် ယသ္မိန် ပါဒပေ ဥတ္တမံ ဖလံ န ဘဝတိ, သ ကၖတ္တော မဓျေ'ဂ္နိံ နိက္ၐေပ္သျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","အပရမ် အဟံ မနးပရာဝရ္တ္တနသူစကေန မဇ္ဇနေန ယုၐ္မာန် မဇ္ဇယာမီတိ သတျံ, ကိန္တု မမ ပၑ္စာဒ် ယ အာဂစ္ဆတိ, သ မတ္တောပိ မဟာန်, အဟံ တဒီယောပါနဟော် ဝေါဎုမပိ နဟိ ယောဂျောသ္မိ, သ ယုၐ္မာန် ဝဟ္နိရူပေ ပဝိတြ အာတ္မနိ သံမဇ္ဇယိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","တသျ ကာရေ သူရ္ပ အာသ္တေ, သ သွီယၑသျာနိ သမျက် ပြသ္ဖောဋျ နိဇာန် သကလဂေါဓူမာန် သံဂၖဟျ ဘာဏ္ဍာဂါရေ သ္ထာပယိၐျတိ, ကိံန္တု သရွွာဏိ ဝုၐာဏျနိရွွာဏဝဟ္နိနာ ဒါဟယိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","အနန္တရံ ယီၑု ရျောဟနာ မဇ္ဇိတော ဘဝိတုံ ဂါလီလ္ပြဒေၑာဒ် ယရ္ဒ္ဒနိ တသျ သမီပမ် အာဇဂါမ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","ကိန္တု ယောဟန် တံ နိၐိဓျ ဗဘာၐေ, တွံ ကိံ မမ သမီပမ် အာဂစ္ဆသိ? ဝရံ တွယာ မဇ္ဇနံ မမ ပြယောဇနမ် အာသ္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","တဒါနီံ ယီၑုး ပြတျဝေါစတ်; ဤဒါနီမ် အနုမနျသွ, ယတ ဣတ္ထံ သရွွဓရ္မ္မသာဓနမ် အသ္မာကံ ကရ္တ္တဝျံ, တတး သော'နွမနျတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","အနန္တရံ ယီၑုရမ္မသိ မဇ္ဇိတုး သန် တတ္က္ၐဏာတ် တောယမဓျာဒ် ဥတ္ထာယ ဇဂါမ, တဒါ ဇီမူတဒွါရေ မုက္တေ ဇာတေ, သ ဤၑွရသျာတ္မာနံ ကပေါတဝဒ် အဝရုဟျ သွောပရျျာဂစ္ဆန္တံ ဝီက္ၐာဉ္စကြေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","အပရမ် ဧၐ မမ ပြိယး ပုတြ ဧတသ္မိန္နေဝ မမ မဟာသန္တောၐ ဧတာဒၖၑီ ဝျောမဇာ ဝါဂ် ဗဘူဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","တတး ပရံ ယီၑုး ပြတာရကေဏ ပရီက္ၐိတော ဘဝိတုမ် အာတ္မနာ ပြာန္တရမ် အာကၖၐ္ဋး ");
INSERT INTO sanbur_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","သန် စတွာရိံၑဒဟောရာတြာန် အနာဟာရသ္တိၐ္ဌန် က္ၐုဓိတော ဗဘူဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","တဒါနီံ ပရီက္ၐိတာ တတ္သမီပမ် အာဂတျ ဝျာဟၖတဝါန်, ယဒိ တွမီၑွရာတ္မဇော ဘဝေသ္တရှျာဇ္ဉယာ ပါၐာဏာနေတာန် ပူပါန် ဝိဓေဟိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","တတး သ ပြတျဗြဝီတ်, ဣတ္ထံ လိခိတမာသ္တေ, \"မနုဇး ကေဝလပူပေန န ဇီဝိၐျတိ, ကိန္တွီၑွရသျ ဝဒနာဒ် ယာနိ ယာနိ ဝစာံသိ နိးသရန္တိ တဲရေဝ ဇီဝိၐျတိ၊ \" ");
INSERT INTO sanbur_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","တဒါ ပြတာရကသ္တံ ပုဏျနဂရံ နီတွာ မန္ဒိရသျ စူဍောပရိ နိဓာယ ဂဒိတဝါန်, ");
INSERT INTO sanbur_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","တွံ ယဒိၑွရသျ တနယော ဘဝေသ္တရှီတော'ဓး ပတ, ယတ ဣတ္ထံ လိခိတမာသ္တေ, အာဒေက္ၐျတိ နိဇာန် ဒူတာန် ရက္ၐိတုံ တွာံ ပရမေၑွရး၊ ယထာ သရွွေၐု မာရ္ဂေၐု တွဒီယစရဏဒွယေ၊ န လဂေတ် ပြသ္တရာဃာတသ္တွာံ ဃရိၐျန္တိ တေ ကရဲး။ ");
INSERT INTO sanbur_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","တဒါနီံ ယီၑုသ္တသ္မဲ ကထိတဝါန် ဧတဒပိ လိခိတမာသ္တေ, \"တွံ နိဇပြဘုံ ပရမေၑွရံ မာ ပရီက္ၐသွ၊ \" ");
INSERT INTO sanbur_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","အနန္တရံ ပြတာရကး ပုနရပိ တမ် အတျုဉ္စဓရာဓရောပရိ နီတွာ ဇဂတး သကလရာဇျာနိ တဒဲၑွရျျာဏိ စ ဒရ္ၑယာၑ္စကာရ ကထယာဉ္စကာရ စ, ");
INSERT INTO sanbur_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ယဒိ တွံ ဒဏ္ဍဝဒ် ဘဝန် မာံ ပြဏမေသ္တရှျဟမ် ဧတာနိ တုဘျံ ပြဒါသျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","တဒါနီံ ယီၑုသ္တမဝေါစတ်, ဒူရီဘဝ ပြတာရက, လိခိတမိဒမ် အာသ္တေ, \"တွယာ နိဇး ပြဘုး ပရမေၑွရး ပြဏမျး ကေဝလး သ သေဝျၑ္စ၊ \" ");
INSERT INTO sanbur_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","တတး ပြတာရကေဏ သ ပရျျတျာဇိ, တဒါ သွရ္ဂီယဒူတဲရာဂတျ သ သိၐေဝေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","တဒနန္တရံ ယောဟန် ကာရာယာံ ဗဗန္ဓေ, တဒွါရ္တ္တာံ နိၑမျ ယီၑုနာ ဂါလီလ် ပြာသ္ထီယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","တတး ပရံ သ နာသရန္နဂရံ ဝိဟာယ ဇလဃေသ္တဋေ သိဗူလူန္နပ္တာလီ ဧတယောရုဝဘယေား ပြဒေၑယေား သီမ္နောရ္မဓျဝရ္တ္တီ ယ: ကဖရ္နာဟူမ် တန္နဂရမ် ဣတွာ နျဝသတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","တသ္မာတ်, အနျာဒေၑီယဂါလီလိ ယရ္ဒ္ဒန္ပာရေ'ဗ္ဓိရောဓသိ၊ နပ္တာလိသိဗူလူန္ဒေၑော် ယတြ သ္ထာနေ သ္ထိတော် ပုရာ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","တတြတျာ မနုဇာ ယေ ယေ ပရျျဘြာမျန် တမိသြကေ၊ တဲရ္ဇနဲရ္ဗၖဟဒါလောကး ပရိဒရ္ၑိၐျတေ တဒါ၊ အဝသန် ယေ ဇနာ ဒေၑေ မၖတျုစ္ဆာယာသွရူပကေ၊ တေၐာမုပရိ လောကာနာမာလောကး သံပြကာၑိတး။ ");
INSERT INTO sanbur_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ယဒေတဒွစနံ ယိၑယိယဘဝိၐျဒွါဒိနာ ပြောက္တံ, တတ် တဒါ သဖလမ် အဘူတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","အနန္တရံ ယီၑုး သုသံဝါဒံ ပြစာရယန် ဧတာံ ကထာံ ကထယိတုမ် အာရေဘေ, မနာံသိ ပရာဝရ္တ္တယတ, သွရ္ဂီယရာဇတွံ သဝိဓမဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","တတး ပရံ ယီၑု ရ္ဂာလီလော ဇလဓေသ္တဋေန ဂစ္ဆန် ဂစ္ဆန် အာန္ဒြိယသ္တသျ ဘြာတာ ၑိမောန် အရ္ထတော ယံ ပိတရံ ဝဒန္တိ ဧတာဝုဘော် ဇလဃော် ဇာလံ က္ၐိပန္တော် ဒဒရ္ၑ, ယတသ္တော် မီနဓာရိဏာဝါသ္တာမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","တဒါ သ တာဝါဟူယ ဝျာဇဟာရ, ယုဝါံ မမ ပၑ္စာဒ် အာဂစ္ဆတံ, ယုဝါမဟံ မနုဇဓာရိဏော် ကရိၐျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","တေနဲဝ တော် ဇာလံ ဝိဟာယ တသျ ပၑ္စာတ် အာဂစ္ဆတာမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","အနန္တရံ တသ္မာတ် သ္ထာနာတ် ဝြဇန် ဝြဇန် သိဝဒိယသျ သုတော် ယာကူဗ် ယောဟန္နာမာနော် ဒွေါ် သဟဇော် တာတေန သာရ္ဒ္ဓံ နော်ကောပရိ ဇာလသျ ဇီရ္ဏောဒ္ဓါရံ ကုရွွန္တော် ဝီက္ၐျ တာဝါဟူတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","တတ္က္ၐဏာတ် တော် နာဝံ သွတာတဉ္စ ဝိဟာယ တသျ ပၑ္စာဒ္ဂါမိနော် ဗဘူဝတုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","အနန္တရံ ဘဇနဘဝနေ သမုပဒိၑန် ရာဇျသျ သုသံဝါဒံ ပြစာရယန် မနုဇာနာံ သရွွပြကာရာန် ရောဂါန် သရွွပြကာရပီဍာၑ္စ ၑမယန် ယီၑုး ကၖတ္သ္နံ ဂါလီလ္ဒေၑံ ဘြမိတုမ် အာရဘတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","တေန ကၖတ္သ္နသုရိယာဒေၑသျ မဓျံ တသျ ယၑော ဝျာပ္နောတ်, အပရံ ဘူတဂြသ္တာ အပသ္မာရရ္ဂီဏး ပက္ၐာဓာတိပြဘၖတယၑ္စ ယာဝန္တော မနုဇာ နာနာဝိဓဝျာဓိဘိး က္လိၐ္ဋာ အာသန်, တေၐု သရွွေၐု တသျ သမီပမ် အာနီတေၐု သ တာန် သွသ္ထာန် စကာရ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ဧတေန ဂါလီလ်-ဒိကာပနိ-ယိရူၑာလမ်-ယိဟူဒီယဒေၑေဘျော ယရ္ဒ္ဒနး ပါရာဉ္စ ဗဟဝေါ မနုဇာသ္တသျ ပၑ္စာဒ် အာဂစ္ဆန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","အနန္တရံ သ ဇနနိဝဟံ နိရီက္ၐျ ဘူဓရောပရိ ဝြဇိတွာ သမုပဝိဝေၑ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","တဒါနီံ ၑိၐျေၐု တသျ သမီပမာဂတေၐု တေန တေဘျ ဧၐာ ကထာ ကထျာဉ္စကြေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","အဘိမာနဟီနာ ဇနာ ဓနျား, ယတသ္တေ သွရ္ဂီယရာဇျမ် အဓိကရိၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ခိဒျမာနာ မနုဇာ ဓနျား, ယသ္မာတ် တေ သာန္တွနာံ ပြာပ္သန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","နမြာ မာနဝါၑ္စ ဓနျား, ယသ္မာတ် တေ မေဒိနီမ် အဓိကရိၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ဓရ္မ္မာယ ဗုဘုက္ၐိတား တၖၐာရ္တ္တာၑ္စ မနုဇာ ဓနျား, ယသ္မာတ် တေ ပရိတရ္ပ္သျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","ကၖပါလဝေါ မာနဝါ ဓနျား, ယသ္မာတ် တေ ကၖပါံ ပြာပ္သျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","နိရ္မ္မလဟၖဒယာ မနုဇာၑ္စ ဓနျား, ယသ္မာတ် တ ဤၑ္စရံ ဒြက္ၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","မေလယိတာရော မာနဝါ ဓနျား, ယသ္မာတ် တ ဤၑ္စရသျ သန္တာနတွေန ဝိချာသျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ဓရ္မ္မကာရဏာတ် တာဍိတာ မနုဇာ ဓနျာ, ယသ္မာတ် သွရ္ဂီယရာဇျေ တေၐာမဓိကရော ဝိဒျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","ယဒါ မနုဇာ မမ နာမကၖတေ ယုၐ္မာန် နိန္ဒန္တိ တာဍယန္တိ မၖၐာ နာနာဒုရွွာကျာနိ ဝဒန္တိ စ, တဒါ ယုယံ ဓနျား၊ ");
INSERT INTO sanbur_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","တဒါ အာနန္ဒတ, တထာ ဘၖၑံ ဟ္လာဒဓွဉ္စ, ယတး သွရ္ဂေ ဘူယာံသိ ဖလာနိ လပ္သျဓွေ; တေ ယုၐ္မာကံ ပုရာတနာန် ဘဝိၐျဒွါဒိနော'ပိ တာဒၖဂ် အတာဍယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","ယုယံ မေဒိနျာံ လဝဏရူပါး, ကိန္တု ယဒိ လဝဏသျ လဝဏတွမ် အပယာတိ, တရှိ တတ် ကေန ပြကာရေဏ သွာဒုယုက္တံ ဘဝိၐျတိ? တတ် ကသျာပိ ကာရျျသျာယောဂျတွာတ် ကေဝလံ ဗဟိး ပြက္ၐေပ္တုံ နရာဏာံ ပဒတလေန ဒလယိတုဉ္စ ယောဂျံ ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","ယူယံ ဇဂတိ ဒီပ္တိရူပါး, ဘူဓရောပရိ သ္ထိတံ နဂရံ ဂုပ္တံ ဘဝိတုံ နဟိ ၑက္ၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","အပရံ မနုဇား ပြဒီပါန် ပြဇွာလျ ဒြောဏာဓော န သ္ထာပယန္တိ, ကိန္တု ဒီပါဓာရောပရျျေဝ သ္ထာပယန္တိ, တေန တေ ဒီပါ ဂေဟသ္ထိတာန် သကလာန် ပြကာၑယန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","ယေန မာနဝါ ယုၐ္မာကံ သတ္ကရ္မ္မာဏိ ဝိလောကျ ယုၐ္မာကံ သွရ္ဂသ္ထံ ပိတရံ ဓနျံ ဝဒန္တိ, တေၐာံ သမက္ၐံ ယုၐ္မာကံ ဒီပ္တိသ္တာဒၖက် ပြကာၑတာမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","အဟံ ဝျဝသ္ထာံ ဘဝိၐျဒွါကျဉ္စ လောပ္တုမ် အာဂတဝါန်, ဣတ္ထံ မာနုဘဝတ, တေ ဒွေ လောပ္တုံ နာဂတဝါန်, ကိန္တု သဖလေ ကရ္တ္တုမ် အာဂတောသ္မိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","အပရံ ယုၐ္မာန် အဟံ တထျံ ဝဒါမိ ယာဝတ် ဝျောမမေဒိနျော ရ္ဓွံသော န ဘဝိၐျတိ, တာဝတ် သရွွသ္မိန် သဖလေ န ဇာတေ ဝျဝသ္ထာယာ ဧကာ မာတြာ ဗိန္ဒုရေကောပိ ဝါ န လောပ္သျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","တသ္မာတ် ယော ဇန ဧတာသာမ် အာဇ္ဉာနာမ် အတိက္ၐုဒြာမ် ဧကာဇ္ဉာမပီ လံဃတေ မနုဇာံဉ္စ တထဲဝ ၑိက္ၐယတိ, သ သွရ္ဂီယရာဇျေ သရွွေဘျး က္ၐုဒြတွေန ဝိချာသျတေ, ကိန္တု ယော ဇနသ္တာံ ပါလယတိ, တထဲဝ ၑိက္ၐယတိ စ, သ သွရ္ဂီယရာဇျေ ပြဓာနတွေန ဝိချာသျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","အပရံ ယုၐ္မာန် အဟံ ဝဒါမိ, အဓျာပကဖိရူၑိမာနဝါနာံ ဓရ္မ္မာနုၐ္ဌာနာတ် ယုၐ္မာကံ ဓရ္မ္မာနုၐ္ဌာနေ နောတ္တမေ ဇာတေ ယူယမ် ဤၑွရီယရာဇျံ ပြဝေၐ္ဋုံ န ၑက္ၐျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","အပရဉ္စ တွံ နရံ မာ ဝဓီး, ယသ္မာတ် ယော နရံ ဟန္တိ, သ ဝိစာရသဘာယာံ ဒဏ္ဍာရှော ဘဝိၐျတိ, ပူရွွကာလီနဇနေဘျ ဣတိ ကထိတမာသီတ်, ယုၐ္မာဘိရၑြာဝိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","ကိန္တွဟံ ယုၐ္မာန် ဝဒါမိ, ယး ကၑ္စိတ် ကာရဏံ ဝိနာ နိဇဘြာတြေ ကုပျတိ, သ ဝိစာရသဘာယာံ ဒဏ္ဍာရှော ဘဝိၐျတိ; ယး ကၑ္စိစ္စ သွီယသဟဇံ နိရ္ဗ္ဗောဓံ ဝဒတိ, သ မဟာသဘာယာံ ဒဏ္ဍာရှော ဘဝိၐျတိ; ပုနၑ္စ တွံ မူဎ ဣတိ ဝါကျံ ယဒိ ကၑ္စိတ် သွီယဘြာတရံ ဝက္တိ, တရှိ နရကာဂ္နော် သ ဒဏ္ဍာရှော ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","အတော ဝေဒျား သမီပံ နိဇနဲဝေဒျေ သမာနီတေ'ပိ နိဇဘြာတရံ ပြတိ ကသ္မာစ္စိတ် ကာရဏာတ် တွံ ယဒိ ဒေါၐီ ဝိဒျသေ, တဒါနီံ တဝ တသျ သ္မၖတိ ရ္ဇာယတေ စ, ");
INSERT INTO sanbur_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","တရှိ တသျာ ဝေဒျား သမီပေ နိဇနဲဝဲဒျံ နိဓာယ တဒဲဝ ဂတွာ ပူရွွံ တေန သာရ္ဒ္ဓံ မိလ, ပၑ္စာတ် အာဂတျ နိဇနဲဝေဒျံ နိဝေဒယ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","အနျဉ္စ ယာဝတ် ဝိဝါဒိနာ သာရ္ဒ္ဓံ ဝရ္တ္မနိ တိၐ္ဌသိ, တာဝတ် တေန သာရ္ဒ္ဓံ မေလနံ ကုရု; နော စေတ် ဝိဝါဒီ ဝိစာရယိတုး သမီပေ တွာံ သမရ္ပယတိ ဝိစာရယိတာ စ ရက္ၐိဏး သန္နိဓော် သမရ္ပယတိ တဒါ တွံ ကာရာယာံ ဗဓျေထား၊ ");
INSERT INTO sanbur_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","တရှိ တွာမဟံ တထ္ထံ ဗြဝီမိ, ၑေၐကပရ္ဒကေ'ပိ န ပရိၑောဓိတေ တသ္မာတ် သ္ထာနာတ် ကဒါပိ ဗဟိရာဂန္တုံ န ၑက္ၐျသိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","အပရံ တွံ မာ ဝျဘိစရ, ယဒေတဒ် ဝစနံ ပူရွွကာလီနလောကေဘျး ကထိတမာသီတ်, တဒ် ယူယံ ၑြုတဝန္တး; ");
INSERT INTO sanbur_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","ကိန္တွဟံ ယုၐ္မာန် ဝဒါမိ, ယဒိ ကၑ္စိတ် ကာမတး ကာဉ္စန ယောၐိတံ ပၑျတိ, တရှိ သ မနသာ တဒဲဝ ဝျဘိစရိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","တသ္မာတ် တဝ ဒက္ၐိဏံ နေတြံ ယဒိ တွာံ ဗာဓတေ, တရှိ တန္နေတြမ် ဥတ္ပာဋျ ဒူရေ နိက္ၐိပ, ယသ္မာတ် တဝ သရွွဝပုၐော နရကေ နိက္ၐေပါတ် တဝဲကာင်္ဂသျ နာၑော ဝရံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","ယဒွါ တဝ ဒက္ၐိဏး ကရော ယဒိ တွာံ ဗာဓတေ, တရှိ တံ ကရံ ဆိတ္တွာ ဒူရေ နိက္ၐိပ, ယတး သရွွဝပုၐော နရကေ နိက္ၐေပါတ် ဧကာင်္ဂသျ နာၑော ဝရံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","ဥက္တမာသ္တေ, ယဒိ ကၑ္စိန် နိဇဇာယာံ ပရိတျက္တ္တုမ် ဣစ္ဆတိ, တရှိ သ တသျဲ တျာဂပတြံ ဒဒါတု၊ ");
INSERT INTO sanbur_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","ကိန္တွဟံ ယုၐ္မာန် ဝျာဟရာမိ, ဝျဘိစာရဒေါၐေ န ဇာတေ ယဒိ ကၑ္စိန် နိဇဇာယာံ ပရိတျဇတိ, တရှိ သ တာံ ဝျဘိစာရယတိ; ယၑ္စ တာံ တျက္တာံ သ္တြိယံ ဝိဝဟတိ, သောပိ ဝျဘိစရတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","ပုနၑ္စ တွံ မၖၐာ ၑပထမ် န ကုရွွန် ဤၑ္စရာယ နိဇၑပထံ ပါလယ, ပူရွွကာလီနလောကေဘျော ယဲၐာ ကထာ ကထိတာ, တာမပိ ယူယံ ၑြုတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","ကိန္တွဟံ ယုၐ္မာန် ဝဒါမိ, ကမပိ ၑပထံ မာ ကာရ္ၐ္ဋ, အရ္ထတး သွရ္ဂနာမ္နာ န, ယတး သ ဤၑွရသျ သိံဟာသနံ; ");
INSERT INTO sanbur_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ပၖထိဝျာ နာမ္နာပိ န, ယတး သာ တသျ ပါဒပီဌံ; ယိရူၑာလမော နာမ္နာပိ န, ယတး သာ မဟာရာဇသျ ပုရီ; ");
INSERT INTO sanbur_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","နိဇၑိရောနာမ္နာပိ န, ယသ္မာတ် တသျဲကံ ကစမပိ သိတမ် အသိတံ ဝါ ကရ္တ္တုံ တွယာ န ၑကျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","အပရံ ယူယံ သံလာပသမယေ ကေဝလံ ဘဝတီတိ န ဘဝတီတိ စ ဝဒတ ယတ ဣတော'ဓိကံ ယတ် တတ် ပါပါတ္မနော ဇာယတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","အပရံ လောစနသျ ဝိနိမယေန လောစနံ ဒန္တသျ ဝိနိမယေန ဒန္တး ပူရွွက္တမိဒံ ဝစနဉ္စ ယုၐ္မာဘိရၑြူယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","ကိန္တွဟံ ယုၐ္မာန် ဝဒါမိ ယူယံ ဟိံသကံ နရံ မာ ဝျာဃာတယတ၊ ကိန္တု ကေနစိတ် တဝ ဒက္ၐိဏကပေါလေ စပေဋာဃာတေ ကၖတေ တံ ပြတိ ဝါမံ ကပေါလဉ္စ ဝျာဃောဋယ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","အပရံ ကေနစိတ် တွယာ သာရ္ဓ္ဒံ ဝိဝါဒံ ကၖတွာ တဝ ပရိဓေယဝသနေ ဇိဃၖတိတေ တသ္မာယုတ္တရီယဝသနမပိ ဒေဟိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ယဒိ ကၑ္စိတ် တွာံ ကြောၑမေကံ နယနာရ္ထံ အနျာယတော ဓရတိ, တဒါ တေန သာရ္ဓ္ဒံ ကြောၑဒွယံ ယာဟိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ယၑ္စ မာနဝသ္တွာံ ယာစတေ, တသ္မဲ ဒေဟိ, ယဒိ ကၑ္စိတ် တုဘျံ ဓာရယိတုမ် ဣစ္ဆတိ, တရှိ တံ ပြတိ ပရာံမုခေါ မာ ဘူး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","နိဇသမီပဝသိနိ ပြေမ ကုရု, ကိန္တု ၑတြုံ ပြတိ ဒွေၐံ ကုရု, ယဒေတတ် ပုရောက္တံ ဝစနံ ဧတဒပိ ယူယံ ၑြုတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","ကိန္တွဟံ ယုၐ္မာန် ဝဒါမိ, ယူယံ ရိပုဝွပိ ပြေမ ကုရုတ, ယေ စ ယုၐ္မာန် ၑပန္တေ, တာန, အာၑိၐံ ဝဒတ, ယေ စ ယုၐ္မာန် ၒृတီယန္တေ, တေၐာံ မင်္ဂလံ ကုရုတ, ယေ စ ယုၐ္မာန် နိန္ဒန္တိ, တာဍယန္တိ စ, တေၐာံ ကၖတေ ပြာရ္ထယဓွံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","တတြ ယး သတာမသတာဉ္စောပရိ ပြဘာကရမ် ဥဒါယယတိ, တထာ ဓာရ္မ္မိကာနာမဓာရ္မ္မိကာနာဉ္စောပရိ နီရံ ဝရ္ၐယတိ တာဒၖၑော ယော ယုၐ္မာကံ သွရ္ဂသ္ထး ပိတာ, ယူယံ တသျဲဝ သန္တာနာ ဘဝိၐျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ယေ ယုၐ္မာသု ပြေမ ကုရွွန္တိ, ယူယံ ယဒိ ကေဝလံ တေဝွေဝ ပြေမ ကုရုထ, တရှိ ယုၐ္မာကံ ကိံ ဖလံ ဘဝိၐျတိ? စဏ္ဍာလာ အပိ တာဒၖၑံ ကိံ န ကုရွွန္တိ? ");
INSERT INTO sanbur_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","အပရံ ယူယံ ယဒိ ကေဝလံ သွီယဘြာတၖတွေန နမတ, တရှိ ကိံ မဟတ် ကရ္မ္မ ကုရုထ? စဏ္ဍာလာ အပိ တာဒၖၑံ ကိံ န ကုရွွန္တိ? ");
INSERT INTO sanbur_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","တသ္မာတ် ယုၐ္မာကံ သွရ္ဂသ္ထး ပိတာ ယထာ ပူရ္ဏော ဘဝတိ, ယူယမပိ တာဒၖၑာ ဘဝတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","သာဝဓာနာ ဘဝတ, မနုဇာန် ဒရ္ၑယိတုံ တေၐာံ ဂေါစရေ ဓရ္မ္မကရ္မ္မ မာ ကုရုတ, တထာ ကၖတေ ယုၐ္မာကံ သွရ္ဂသ္ထပိတုး သကာၑာတ် ကိဉ္စန ဖလံ န ပြာပ္သျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","တွံ ယဒါ ဒဒါသိ တဒါ ကပဋိနော ဇနာ ယထာ မနုဇေဘျး ပြၑံသာံ ပြာပ္တုံ ဘဇနဘဝနေ ရာဇမာရ္ဂေ စ တူရီံ ဝါဒယန္တိ, တထာ မာ ကုရိु, အဟံ တုဘျံ ယထာရ္ထံ ကထယာမိ, တေ သွကာယံ ဖလမ် အလဘန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","ကိန္တု တွံ ယဒါ ဒဒါသိ, တဒါ နိဇဒက္ၐိဏကရော ယတ် ကရောတိ, တဒ် ဝါမကရံ မာ ဇ္ဉာပယ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","တေန တဝ ဒါနံ ဂုပ္တံ ဘဝိၐျတိ ယသ္တု တဝ ပိတာ ဂုပ္တဒရ္ၑီ, သ ပြကာၑျ တုဘျံ ဖလံ ဒါသျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","အပရံ ယဒါ ပြာရ္ထယသေ, တဒါ ကပဋိနဣဝ မာ ကုရု, ယသ္မာတ် တေ ဘဇနဘဝနေ ရာဇမာရ္ဂသျ ကောဏေ တိၐ္ဌန္တော လောကာန် ဒရ္ၑယန္တး ပြာရ္ထယိတုံ ပြီယန္တေ; အဟံ ယုၐ္မာန် တထျံ ဝဒါမိ, တေ သွကီယဖလံ ပြာပ္နုဝန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","တသ္မာတ် ပြာရ္ထနာကာလေ အန္တရာဂါရံ ပြဝိၑျ ဒွါရံ ရုဒွွာ ဂုပ္တံ ပၑျတသ္တဝ ပိတုး သမီပေ ပြာရ္ထယသွ; တေန တဝ ယး ပိတာ ဂုပ္တဒရ္ၑီ, သ ပြကာၑျ တုဘျံ ဖလံ ဒါသျတိl ");
INSERT INTO sanbur_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","အပရံ ပြာရ္ထနာကာလေ ဒေဝပူဇကာဣဝ မုဓာ ပုနရုက္တိံ မာ ကုရု, ယသ္မာတ် တေ ဗောဓန္တေ, ဗဟုဝါရံ ကထာယာံ ကထိတာယာံ တေၐာံ ပြာရ္ထနာ ဂြာဟိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","ယူယံ တေၐာမိဝ မာ ကုရုတ, ယသ္မာတ် ယုၐ္မာကံ ယဒ် ယတ် ပြယောဇနံ ယာစနာတး ပြာဂေဝ ယုၐ္မာကံ ပိတာ တတ် ဇာနာတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","အတဧဝ ယူယမ ဤဒၖက် ပြာရ္ထယဓွံ, ဟေ အသ္မာကံ သွရ္ဂသ္ထပိတး, တဝ နာမ ပူဇျံ ဘဝတု၊ ");
INSERT INTO sanbur_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","တဝ ရာဇတွံ ဘဝတု; တဝေစ္ဆာ သွရ္ဂေ ယထာ တထဲဝ မေဒိနျာမပိ သဖလာ ဘဝတု၊ ");
INSERT INTO sanbur_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","အသ္မာကံ ပြယောဇနီယမ် အာဟာရမ် အဒျ ဒေဟိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ဝယံ ယထာ နိဇာပရာဓိနး က္ၐမာမဟေ, တထဲဝါသ္မာကမ် အပရာဓာန် က္ၐမသွ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","အသ္မာန် ပရီက္ၐာံ မာနယ, ကိန္တု ပါပါတ္မနော ရက္ၐ; ရာဇတွံ ဂေါ်ရဝံ ပရာကြမး ဧတေ သရွွေ သရွွဒါ တဝ; တထာသ္တု၊ ");
INSERT INTO sanbur_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","ယဒိ ယူယမ် အနျေၐာမ် အပရာဓာန် က္ၐမဓွေ တရှိ ယုၐ္မာကံ သွရ္ဂသ္ထပိတာပိ ယုၐ္မာန် က္ၐမိၐျတေ; ");
INSERT INTO sanbur_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ကိန္တု ယဒိ ယူယမ် အနျေၐာမ် အပရာဓာန် န က္ၐမဓွေ, တရှိ ယုၐ္မာကံ ဇနကောပိ ယုၐ္မာကမ် အပရာဓာန် န က္ၐမိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","အပရမ် ဥပဝါသကာလေ ကပဋိနော ဇနာ မာနုၐာန် ဥပဝါသံ ဇ္ဉာပယိတုံ သွေၐာံ ဝဒနာနိ မ္လာနာနိ ကုရွွန္တိ, ယူယံ တဣဝ ဝိၐဏဝဒနာ မာ ဘဝတ; အဟံ ယုၐ္မာန် တထျံ ဝဒါမိ တေ သွကီယဖလမ် အလဘန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","ယဒါ တွမ် ဥပဝသသိ, တဒါ ယထာ လောကဲသ္တွံ ဥပဝါသီဝ န ဒၖၑျသေ, ကိန္တု တဝ ယော'ဂေါစရး ပိတာ တေနဲဝ ဒၖၑျသေ, တတ္ကၖတေ နိဇၑိရသိ တဲလံ မရ္ဒ္ဒယ ဝဒနဉ္စ ပြက္ၐာလယ; ");
INSERT INTO sanbur_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","တေန တဝ ယး ပိတာ ဂုပ္တဒရ္ၑီ သ ပြကာၑျ တုဘျံ ဖလံ ဒါသျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","အပရံ ယတြ သ္ထာနေ ကီဋား ကလင်္ကာၑ္စ က္ၐယံ နယန္တိ, စော်ရာၑ္စ သန္ဓိံ ကရ္တ္တယိတွာ စောရယိတုံ ၑက္နုဝန္တိ, တာဒၖၑျာံ မေဒိနျာံ သွာရ္ထံ ဓနံ မာ သံစိနုတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","ကိန္တု ယတြ သ္ထာနေ ကီဋား ကလင်္ကာၑ္စ က္ၐယံ န နယန္တိ, စော်ရာၑ္စ သန္ဓိံ ကရ္တ္တယိတွာ စောရယိတုံ န ၑက္နုဝန္တိ, တာဒၖၑေ သွရ္ဂေ ဓနံ သဉ္စိနုတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","ယသ္မာတ် ယတြ သ္ထာနေ ယုၐ္မာံက ဓနံ တတြဲဝ ခါနေ ယုၐ္မာကံ မနာံသိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","လောစနံ ဒေဟသျ ပြဒီပကံ, တသ္မာတ် ယဒိ တဝ လောစနံ ပြသန္နံ ဘဝတိ, တရှိ တဝ ကၖတ္သ္နံ ဝပု ရ္ဒီပ္တိယုက္တံ ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ကိန္တု လောစနေ'ပြသန္နေ တဝ ကၖတ္သ္နံ ဝပုး တမိသြယုက္တံ ဘဝိၐျတိ၊ အတဧဝ ယာ ဒီပ္တိသ္တွယိ ဝိဒျတေ, သာ ယဒိ တမိသြယုက္တာ ဘဝတိ, တရှိ တတ် တမိသြံ ကိယန် မဟတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","ကောပိ မနုဇော ဒွေါ် ပြဘူ သေဝိတုံ န ၑက္နောတိ, ယသ္မာဒ် ဧကံ သံမနျ တဒနျံ န သမ္မနျတေ, ယဒွါ ဧကတြ မနော နိဓာယ တဒနျမ် အဝမနျတေ; တထာ ယူယမပီၑွရံ လက္ၐ္မီဉ္စေတျုဘေ သေဝိတုံ န ၑက္နုထ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","အပရမ် အဟံ ယုၐ္မဘျံ တထျံ ကထယာမိ, ကိံ ဘက္ၐိၐျာမး? ကိံ ပါသျာမး? ဣတိ ပြာဏဓာရဏာယ မာ စိန္တယတ; ကိံ ပရိဓာသျာမး? ဣတိ ကာယရက္ၐဏာယ န စိန္တယတ; ဘက္ၐျာတ် ပြာဏာ ဝသနာဉ္စ ဝပူံၐိ ကိံ ၑြေၐ္ဌာဏိ န ဟိ? ");
INSERT INTO sanbur_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ဝိဟာယသော ဝိဟင်္ဂမာန် ဝိလောကယတ; တဲ ရ္နောပျတေ န ကၖတျတေ ဘာဏ္ဍာဂါရေ န သဉ္စီယတေ'ပိ; တထာပိ ယုၐ္မာကံ သွရ္ဂသ္ထး ပိတာ တေဘျ အာဟာရံ ဝိတရတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","ယူယံ တေဘျး ကိံ ၑြေၐ္ဌာ န ဘဝထ? ယုၐ္မာကံ ကၑ္စိတ် မနုဇး စိန္တယန် နိဇာယုၐး က္ၐဏမပိ ဝရ္ဒ္ဓယိတုံ ၑက္နောတိ? ");
INSERT INTO sanbur_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","အပရံ ဝသနာယ ကုတၑ္စိန္တယတ? က္ၐေတြောတ္ပန္နာနိ ပုၐ္ပာဏိ ကထံ ဝရ္ဒ္ဓန္တေ တဒါလောစယတ၊ တာနိ တန္တူန် နောတ္ပာဒယန္တိ ကိမပိ ကာရျျံ န ကုရွွန္တိ; ");
INSERT INTO sanbur_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","တထာပျဟံ ယုၐ္မာန် ဝဒါမိ, သုလေမာန် တာဒၖဂ် အဲၑွရျျဝါနပိ တတ္ပုၐ္ပမိဝ ဝိဘူၐိတော နာသီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","တသ္မာတ် က္ၐဒျ ဝိဒျမာနံ ၑ္စး စုလ္လျာံ နိက္ၐေပ္သျတေ တာဒၖၑံ ယတ် က္ၐေတြသ္ထိတံ ကုသုမံ တတ် ယဒီၑ္စရ ဣတ္ထံ ဗိဘူၐယတိ, တရှိ ဟေ သ္တောကပြတျယိနော ယုၐ္မာန် ကိံ န ပရိဓာပယိၐျတိ? ");
INSERT INTO sanbur_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","တသ္မာတ် အသ္မာဘိး ကိမတ္သျတေ? ကိဉ္စ ပါယိၐျတေ? ကိံ ဝါ ပရိဓာယိၐျတေ, ဣတိ န စိန္တယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ယသ္မာတ် ဒေဝါရ္စ္စကာ အပီတိ စေၐ္ဋန္တေ; ဧတေၐု ဒြဝျေၐု ပြယောဇနမသ္တီတိ ယုၐ္မာကံ သွရ္ဂသ္ထး ပိတာ ဇာနာတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","အတဧဝ ပြထမတ ဤၑွရီယရာဇျံ ဓရ္မ္မဉ္စ စေၐ္ဋဓွံ, တတ ဧတာနိ ဝသ္တူနိ ယုၐ္မဘျံ ပြဒါယိၐျန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","ၑွး ကၖတေ မာ စိန္တယတ, ၑွဧဝ သွယံ သွမုဒ္ဒိၑျ စိန္တယိၐျတိ; အဒျတနီ ယာ စိန္တာ သာဒျကၖတေ ပြစုရတရာ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","ယထာ ယူယံ ဒေါၐီကၖတာ န ဘဝထ, တတ္ကၖတေ'နျံ ဒေါၐိဏံ မာ ကုရုတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ယတော ယာဒၖၑေန ဒေါၐေဏ ယူယံ ပရာန် ဒေါၐိဏး ကုရုထ, တာဒၖၑေန ဒေါၐေဏ ယူယမပိ ဒေါၐီကၖတာ ဘဝိၐျထ, အနျဉ္စ ယေန ပရိမာဏေန ယုၐ္မာဘိး ပရိမီယတေ, တေနဲဝ ပရိမာဏေန ယုၐ္မတ္ကၖတေ ပရိမာယိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","အပရဉ္စ နိဇနယနေ ယာ နာသာ ဝိဒျတေ, တာမ် အနာလောစျ တဝ သဟဇသျ လောစနေ ယတ် တၖဏမ် အာသ္တေ, တဒေဝ ကုတော ဝီက္ၐသေ? ");
INSERT INTO sanbur_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","တဝ နိဇလောစနေ နာသာယာံ ဝိဒျမာနာယာံ, ဟေ ဘြာတး, တဝ နယနာတ် တၖဏံ ဗဟိၐျရ္တုံ အနုဇာနီဟိ, ကထာမေတာံ နိဇသဟဇာယ ကထံ ကထယိတုံ ၑက္နောၐိ? ");
INSERT INTO sanbur_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ဟေ ကပဋိန်, အာဒေါ် နိဇနယနာတ် နာသာံ ဗဟိၐ္ကုရု တတော နိဇဒၖၐ္ဋော် သုပြသန္နာယာံ တဝ ဘြာတၖ ရ္လောစနာတ် တၖဏံ ဗဟိၐ္ကရ္တုံ ၑက္ၐျသိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","အနျဉ္စ သာရမေယေဘျး ပဝိတြဝသ္တူနိ မာ ဝိတရတ, ဝရာဟာဏာံ သမက္ၐဉ္စ မုက္တာ မာ နိက္ၐိပတ; နိက္ၐေပဏာတ် တေ တား သရွွား ပဒဲ ရ္ဒလယိၐျန္တိ, ပရာဝၖတျ ယုၐ္မာနပိ ဝိဒါရယိၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","ယာစဓွံ တတော ယုၐ္မဘျံ ဒါယိၐျတေ; မၖဂယဓွံ တတ ဥဒ္ဒေၑံ လပ္သျဓွေ; ဒွါရမ် အာဟတ, တတော ယုၐ္မတ္ကၖတေ မုက္တံ ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","ယသ္မာဒ် ယေန ယာစျတေ, တေန လဘျတေ; ယေန မၖဂျတေ တေနောဒ္ဒေၑး ပြာပျတေ; ယေန စ ဒွါရမ် အာဟနျတေ, တတ္ကၖတေ ဒွါရံ မောစျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","အာတ္မဇေန ပူပေ ပြာရ္ထိတေ တသ္မဲ ပါၐာဏံ ဝိၑြာဏယတိ, ");
INSERT INTO sanbur_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","မီနေ ယာစိတေ စ တသ္မဲ ဘုဇဂံ ဝိတရတိ, ဧတာဒၖၑး ပိတာ ယုၐ္မာကံ မဓျေ က အာသ္တေ? ");
INSERT INTO sanbur_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","တသ္မာဒ် ယူယမ် အဘဒြား သန္တော'ပိ ယဒိ နိဇဗာလကေဘျ ဥတ္တမံ ဒြဝျံ ဒါတုံ ဇာနီထ, တရှိ ယုၐ္မာကံ သွရ္ဂသ္ထး ပိတာ သွီယယာစကေဘျး ကိမုတ္တမာနိ ဝသ္တူနိ န ဒါသျတိ? ");
INSERT INTO sanbur_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","ယူၐ္မာန် ပြတီတရေၐာံ ယာဒၖၑော ဝျဝဟာရော ယုၐ္မာကံ ပြိယး, ယူယံ တာန် ပြတိ တာဒၖၑာနေဝ ဝျဝဟာရာန် ဝိဓတ္တ; ယသ္မာဒ် ဝျဝသ္ထာဘဝိၐျဒွါဒိနာံ ဝစနာနာမ် ဣတိ သာရမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","သင်္ကီရ္ဏဒွါရေဏ ပြဝိၑတ; ယတော နရကဂမနာယ ယဒ် ဒွါရံ တဒ် ဝိသ္တီရ္ဏံ ယစ္စ ဝရ္တ္မ တဒ် ဗၖဟတ် တေန ဗဟဝး ပြဝိၑန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","အပရံ သွရ္ဂဂမနာယ ယဒ် ဒွါရံ တတ် ကီဒၖက် သံကီရ္ဏံ၊ ယစ္စ ဝရ္တ္မ တတ် ကီဒၖဂ် ဒုရ္ဂမမ်၊ တဒုဒ္ဒေၐ္ဋာရး ကိယန္တော'လ္ပား၊ ");
INSERT INTO sanbur_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","အပရဉ္စ ယေ ဇနာ မေၐဝေၑေန ယုၐ္မာကံ သမီပမ် အာဂစ္ဆန္တိ, ကိန္တွန္တရ္ဒုရန္တာ ဝၖကာ ဧတာဒၖၑေဘျော ဘဝိၐျဒွါဒိဘျး သာဝဓာနာ ဘဝတ, ယူယံ ဖလေန တာန် ပရိစေတုံ ၑက္နုထ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","မနုဇား ကိံ ကဏ္ဋကိနော ဝၖက္ၐာဒ် ဒြာက္ၐာဖလာနိ ၑၖဂါလကောလိတၑ္စ ဥဍုမ္ဗရဖလာနိ ၑာတယန္တိ? ");
INSERT INTO sanbur_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","တဒွဒ် ဥတ္တမ ဧဝ ပါဒပ ဥတ္တမဖလာနိ ဇနယတိ, အဓမပါဒပဧဝါဓမဖလာနိ ဇနယတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","ကိန္တူတ္တမပါဒပး ကဒါပျဓမဖလာနိ ဇနယိတုံ န ၑက္နောတိ, တထာဓမောပိ ပါဒပ ဥတ္တမဖလာနိ ဇနယိတုံ န ၑက္နောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","အပရံ ယေ ယေ ပါဒပါ အဓမဖလာနိ ဇနယန္တိ, တေ ကၖတ္တာ ဝဟ္နော် က္ၐိပျန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","အတဧဝ ယူယံ ဖလေန တာန် ပရိစေၐျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","ယေ ဇနာ မာံ ပြဘုံ ဝဒန္တိ, တေ သရွွေ သွရ္ဂရာဇျံ ပြဝေက္ၐျန္တိ တန္န, ကိန္တု ယော မာနဝေါ မမ သွရ္ဂသ္ထသျ ပိတုရိၐ္ဋံ ကရ္မ္မ ကရောတိ သ ဧဝ ပြဝေက္ၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","တဒ် ဒိနေ ဗဟဝေါ မာံ ဝဒိၐျန္တိ, ဟေ ပြဘော ဟေ ပြဘော, တဝ နာမ္နာ ကိမသ္မာမိ ရ္ဘဝိၐျဒွါကျံ န ဝျာဟၖတံ? တဝ နာမ္နာ ဘူတား ကိံ န တျာဇိတား? တဝ နာမ္နာ ကိံ နာနာဒ္ဘုတာနိ ကရ္မ္မာဏိ န ကၖတာနိ? ");
INSERT INTO sanbur_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","တဒါဟံ ဝဒိၐျာမိ, ဟေ ကုကရ္မ္မကာရိဏော ယုၐ္မာန် အဟံ န ဝေဒ္မိ, ယူယံ မတ္သမီပါဒ် ဒူရီဘဝတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","ယး ကၑ္စိတ် မမဲတား ကထား ၑြုတွာ ပါလယတိ, သ ပါၐာဏောပရိ ဂၖဟနိရ္မ္မာတြာ ဇ္ဉာနိနာ သဟ မယောပမီယတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","ယတော ဝၖၐ္ဋော် သတျာမ် အာပ္လာဝ အာဂတေ ဝါယော် ဝါတေ စ တေၐု တဒ္ဂေဟံ လဂ္နေၐု ပါၐာဏောပရိ တသျ ဘိတ္တေသ္တန္န ပတတိl ");
INSERT INTO sanbur_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","ကိန္တု ယး ကၑ္စိတ် မမဲတား ကထား ၑြုတွာ န ပါလယတိ သ သဲကတေ ဂေဟနိရ္မ္မာတြာ 'ဇ္ဉာနိနာ ဥပမီယတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","ယတော ဇလဝၖၐ္ဋော် သတျာမ် အာပ္လာဝ အာဂတေ ပဝနေ ဝါတေ စ တဲ ရ္ဂၖဟေ သမာဃာတေ တတ် ပတတိ တတ္ပတနံ မဟဒ် ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","ယီၑုနဲတေၐု ဝါကျေၐု သမာပိတေၐု မာနဝါသ္တဒီယောပဒေၑမ် အာၑ္စရျျံ မေနိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ယသ္မာတ် သ ဥပါဓျာယာ ဣဝ တာန် နောပဒိဒေၑ ကိန္တု သမရ္ထပုရုၐဣဝ သမုပဒိဒေၑ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","ယဒါ သ ပရွွတာဒ် အဝါရောဟတ် တဒါ ဗဟဝေါ မာနဝါသ္တတ္ပၑ္စာဒ် ဝဝြဇုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ဧကး ကုၐ္ဌဝါန် အာဂတျ တံ ပြဏမျ ဗဘာၐေ, ဟေ ပြဘော, ယဒိ ဘဝါန် သံမနျတေ, တရှိ မာံ နိရာမယံ ကရ္တ္တုံ ၑက္နောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","တတော ယီၑုး ကရံ ပြသာရျျ တသျာင်္ဂံ သ္ပၖၑန် ဝျာဇဟာရ, သမ္မနျေ'ဟံ တွံ နိရာမယော ဘဝ; တေန သ တတ္က္ၐဏာတ် ကုၐ္ဌေနာမောစိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","တတော ယီၑုသ္တံ ဇဂါဒ, အဝဓေဟိ ကထာမေတာံ ကၑ္စိဒပိ မာ ဗြူဟိ, ကိန္တု ယာဇကသျ သန္နိဓိံ ဂတွာ သွာတ္မာနံ ဒရ္ၑယ မနုဇေဘျော နိဇနိရာမယတွံ ပြမာဏယိတုံ မူသာနိရူပိတံ ဒြဝျမ် ဥတ္သၖဇ စ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","တဒနန္တရံ ယီၑုနာ ကဖရ္နာဟူမ္နာမနိ နဂရေ ပြဝိၐ္ဋေ ကၑ္စိတ် ၑတသေနာပတိသ္တတ္သမီပမ် အာဂတျ ဝိနီယ ဗဘာၐေ, ");
INSERT INTO sanbur_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ဟေ ပြဘော, မဒီယ ဧကော ဒါသး ပက္ၐာဃာတဝျာဓိနာ ဘၖၑံ ဝျထိတး, သတု ၑယနီယ အာသ္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","တဒါနီံ ယီၑုသ္တသ္မဲ ကထိတဝါန်, အဟံ ဂတွာ တံ နိရာမယံ ကရိၐျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","တတး သ ၑတသေနာပတိး ပြတျဝဒတ်, ဟေ ပြဘော, ဘဝါန် ယတ် မမ ဂေဟမဓျံ ယာတိ တဒျောဂျဘာဇနံ နာဟမသ္မိ; ဝါင်္မာတြမ် အာဒိၑတု, တေနဲဝ မမ ဒါသော နိရာမယော ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","ယတော မယိ ပရနိဓ္နေ'ပိ မမ နိဒေၑဝၑျား ကတိ ကတိ သေနား သန္တိ, တတ ဧကသ္မိန် ယာဟီတျုက္တေ သ ယာတိ, တဒနျသ္မိန် ဧဟီတျုက္တေ သ အာယာတိ, တထာ မမ နိဇဒါသေ ကရ္မ္မဲတတ် ကုရွွိတျုက္တေ သ တတ် ကရောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","တဒါနီံ ယီၑုသ္တသျဲတတ် ဝစော နိၑမျ ဝိသ္မယာပန္နော'ဘူတ်; နိဇပၑ္စာဒ္ဂါမိနော မာနဝါန် အဝေါစ္စ, ယုၐ္မာန် တထျံ ဝစ္မိ, ဣသြာယေလီယလောကာနာံ မဓျေ'ပိ နဲတာဒၖၑော ဝိၑွာသော မယာ ပြာပ္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","အနျစ္စာဟံ ယုၐ္မာန် ဝဒါမိ, ဗဟဝး ပူရွွသျား ပၑ္စိမာယာၑ္စ ဒိၑ အာဂတျ ဣဗြာဟီမာ ဣသှာကာ ယာကူဗာ စ သာကမ် မိလိတွာ သမုပဝေက္ၐျန္တိ; ");
INSERT INTO sanbur_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ကိန္တု ယတြ သ္ထာနေ ရောဒနဒန္တဃရ္ၐဏေ ဘဝတသ္တသ္မိန် ဗဟိရ္ဘူတတမိသြေ ရာဇျသျ သန္တာနာ နိက္ၐေသျန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","တတး ပရံ ယီၑုသ္တံ ၑတသေနာပတိံ ဇဂါဒ, ယာဟိ, တဝ ပြတီတျနုသာရတော မင်္ဂလံ ဘူယာတ်; တဒါ တသ္မိန္နေဝ ဒဏ္ဍေ တဒီယဒါသော နိရာမယော ဗဘူဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","အနန္တရံ ယီၑုး ပိတရသျ ဂေဟမုပသ္ထာယ ဇွရေဏ ပီဍိတာံ ၑယနီယသ္ထိတာံ တသျ ၑွၑြူံ ဝီက္ၐာဉ္စကြေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","တတသ္တေန တသျား ကရသျ သ္ပၖၐ္ဋတဝါတ် ဇွရသ္တာံ တတျာဇ, တဒါ သာ သမုတ္ထာယ တာန် သိၐေဝေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","အနန္တရံ သန္ဓျာယာံ သတျာံ ဗဟုၑော ဘူတဂြသ္တမနုဇာန် တသျ သမီပမ် အာနိနျုး သ စ ဝါကျေန ဘူတာန် တျာဇယာမာသ, သရွွပြကာရပီဍိတဇနာံၑ္စ နိရာမယာန် စကာရ; ");
INSERT INTO sanbur_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","တသ္မာတ်, သရွွာ ဒုရ္ဗ္ဗလတာသ္မာကံ တေနဲဝ ပရိဓာရိတာ၊ အသ္မာကံ သကလံ ဝျာဓိံ သဧဝ သံဂၖဟီတဝါန်၊ ယဒေတဒွစနံ ယိၑယိယဘဝိၐျဒွါဒိနောက္တမာသီတ်, တတ္တဒါ သဖလမဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","အနန္တရံ ယီၑုၑ္စတုရ္ဒိက္ၐု ဇနနိဝဟံ ဝိလောကျ တဋိနျား ပါရံ ယာတုံ ၑိၐျာန် အာဒိဒေၑ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","တဒါနီမ် ဧက ဥပါဓျာယ အာဂတျ ကထိတဝါန်, ဟေ ဂုရော, ဘဝါန် ယတြ ယာသျတိ တတြာဟမပိ ဘဝတး ပၑ္စာဒ် ယာသျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","တတော ယီၑု ရ္ဇဂါဒ, ကြောၐ္ဋုး သ္ထာတုံ သ္ထာနံ ဝိဒျတေ, ဝိဟာယသော ဝိဟင်္ဂမာနာံ နီဍာနိ စ သန္တိ; ကိန္တု မနုၐျပုတြသျ ၑိရး သ္ထာပယိတုံ သ္ထာနံ န ဝိဒျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","အနန္တရမ် အပရ ဧကး ၑိၐျသ္တံ ဗဘာၐေ, ဟေ ပြဘော, ပြထမတော မမ ပိတရံ ၑ္မၑာနေ နိဓာတုံ ဂမနာရ္ထံ မာမ် အနုမနျသွ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","တတော ယီၑုရုက္တဝါန် မၖတာ မၖတာန် ၑ္မၑာနေ နိဒဓတု, တွံ မမ ပၑ္စာဒ် အာဂစ္ဆ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","အနန္တရံ တသ္မိန် နာဝမာရူဎေ တသျ ၑိၐျာသ္တတ္ပၑ္စာတ် ဇဂ္မုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ပၑ္စာတ် သာဂရသျ မဓျံ တေၐု ဂတေၐု တာဒၖၑး ပြဗလော ဈဉ္ဘ္ၑနိလ ဥဒတိၐ္ဌတ်, ယေန မဟာတရင်္ဂ ဥတ္ထာယ တရဏိံ ဆာဒိတဝါန်, ကိန္တု သ နိဒြိတ အာသီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","တဒါ ၑိၐျာ အာဂတျ တသျ နိဒြာဘင်္ဂံ ကၖတွာ ကထယာမာသုး, ဟေ ပြဘော, ဝယံ မြိယာမဟေ, ဘဝါန် အသ္မာကံ ပြာဏာန် ရက္ၐတု၊ ");
INSERT INTO sanbur_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","တဒါ သ တာန် ဥက္တဝါန်, ဟေ အလ္ပဝိၑွာသိနော ယူယံ ကုတော ဝိဘီထ? တတး သ ဥတ္ထာယ ဝါတံ သာဂရဉ္စ တရ္ဇယာမာသ, တတော နိရွွာတမဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","အပရံ မနုဇာ ဝိသ္မယံ ဝိလောကျ ကထယာမာသုး, အဟော ဝါတသရိတ္ပတီ အသျ ကိမာဇ္ဉာဂြာဟိဏော်? ကီဒၖၑော'ယံ မာနဝး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","အနန္တရံ သ ပါရံ ဂတွာ ဂိဒေရီယဒေၑမ် ဥပသ္ထိတဝါန်; တဒါ ဒွေါ် ဘူတဂြသ္တမနုဇော် ၑ္မၑာနသ္ထာနာဒ် ဗဟိ ရ္ဘူတွာ တံ သာက္ၐာတ် ကၖတဝန္တော်, တာဝေတာဒၖၑော် ပြစဏ္ဍာဝါသ္တာံ ယတ် တေန သ္ထာနေန ကောပိ ယာတုံ နာၑက္နောတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","တာဝုစဲး ကထယာမာသတုး, ဟေ ဤၑွရသျ သူနော ယီၑော, တွယာ သာကမ် အာဝယေား ကး သမ္ဗန္ဓး? နိရူပိတကာလာတ် ပြာဂေဝ ကိမာဝါဘျာံ ယာတနာံ ဒါတုမ် အတြာဂတောသိ? ");
INSERT INTO sanbur_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","တဒါနီံ တာဘျာံ ကိဉ္စိဒ် ဒူရေ ဝရာဟာဏာမ် ဧကော မဟာဝြဇော'စရတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","တတော ဘူတော် တော် တသျာန္တိကေ ဝိနီယ ကထယာမာသတုး, ယဒျာဝါံ တျာဇယသိ, တရှိ ဝရာဟာဏာံ မဓျေဝြဇမ် အာဝါံ ပြေရယ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","တဒါ ယီၑုရဝဒတ် ယာတံ, အနန္တရံ တော် ယဒါ မနုဇော် ဝိဟာယ ဝရာဟာန် အာၑြိတဝန္တော်, တဒါ တေ သရွွေ ဝရာဟာ ဥစ္စသ္ထာနာတ် မဟာဇဝေန ဓာဝန္တး သာဂရီယတောယေ မဇ္ဇန္တော မမြုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","တတော ဝရာဟရက္ၐကား ပလာယမာနာ မဓျေနဂရံ တော် ဘူတဂြသ္တော် ပြတိ ယဒျဒ် အဃဋတ, တား သရွွဝါရ္တ္တာ အဝဒန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","တတော နာဂရိကား သရွွေ မနုဇာ ယီၑုံ သာက္ၐာတ် ကရ္တ္တုံ ဗဟိရာယာတား တဉ္စ ဝိလောကျ ပြာရ္ထယာဉ္စကြိရေ ဘဝါန် အသ္မာကံ သီမာတော ယာတု၊ ");
INSERT INTO sanbur_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","အနန္တရံ ယီၑု ရ္နော်ကာမာရုဟျ ပုနး ပါရမာဂတျ နိဇဂြာမမ် အာယယော်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","တတး ကတိပယာ ဇနာ ဧကံ ပက္ၐာဃာတိနံ သွဋ္ဋောပရိ ၑာယယိတွာ တတ္သမီပမ် အာနယန်; တတော ယီၑုသ္တေၐာံ ပြတီတိံ ဝိဇ္ဉာယ တံ ပက္ၐာဃာတိနံ ဇဂါဒ, ဟေ ပုတြ, သုသ္ထိရော ဘဝ, တဝ ကလုၐသျ မရ္ၐဏံ ဇာတမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","တာံ ကထာံ နိၑမျ ကိယန္တ ဥပါဓျာယာ မနးသု စိန္တိတဝန္တ ဧၐ မနုဇ ဤၑွရံ နိန္ဒတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","တတး သ တေၐာမ် ဧတာဒၖၑီံ စိန္တာံ ဝိဇ္ဉာယ ကထိတဝါန်, ယူယံ မနးသု ကၖတ ဧတာဒၖၑီံ ကုစိန္တာံ ကုရုထ? ");
INSERT INTO sanbur_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","တဝ ပါပမရ္ၐဏံ ဇာတံ, ယဒွါ တွမုတ္ထာယ ဂစ္ဆ, ဒွယောရနယော ရွာကျယေား ကိံ ဝါကျံ ဝက္တုံ သုဂမံ? ");
INSERT INTO sanbur_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","ကိန္တု မေဒိနျာံ ကလုၐံ က္ၐမိတုံ မနုဇသုတသျ သာမရ္ထျမသ္တီတိ ယူယံ ယထာ ဇာနီထ, တဒရ္ထံ သ တံ ပက္ၐာဃာတိနံ ဂဒိတဝါန်, ဥတ္တိၐ္ဌ, နိဇၑယနီယံ အာဒါယ ဂေဟံ ဂစ္ဆ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","တတး သ တတ္က္ၐဏာဒ် ဥတ္ထာယ နိဇဂေဟံ ပြသ္ထိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","မာနဝါ ဣတ္ထံ ဝိလောကျ ဝိသ္မယံ မေနိရေ, ဤၑွရေဏ မာနဝါယ သာမရ္ထျမ် ဤဒၖၑံ ဒတ္တံ ဣတိ ကာရဏာတ် တံ ဓနျံ ဗဘာၐိရေ စ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","အနန္တရံ ယီၑုသ္တတ္သ္ထာနာဒ် ဂစ္ဆန် ဂစ္ဆန် ကရသံဂြဟသ္ထာနေ သမုပဝိၐ္ဋံ မထိနာမာနမ် ဧကံ မနုဇံ ဝိလောကျ တံ ဗဘာၐေ, မမ ပၑ္စာဒ် အာဂစ္ဆ, တတး သ ဥတ္ထာယ တသျ ပၑ္စာဒ် ဝဝြာဇ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","တတး ပရံ ယီၑော် ဂၖဟေ ဘောက္တုမ် ဥပဝိၐ္ဋေ ဗဟဝး ကရသံဂြာဟိဏး ကလုၐိဏၑ္စ မာနဝါ အာဂတျ တေန သာကံ တသျ ၑိၐျဲၑ္စ သာကမ် ဥပဝိဝိၑုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ဖိရူၑိနသ္တဒ် ဒၖၐ္ဋွာ တသျ ၑိၐျာန် ဗဘာၐိရေ, ယုၐ္မာကံ ဂုရုး ကိံ နိမိတ္တံ ကရသံဂြာဟိဘိး ကလုၐိဘိၑ္စ သာကံ ဘုံက္တေ? ");
INSERT INTO sanbur_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ယီၑုသ္တတ် ၑြုတွာ တာန် ပြတျဝဒတ်, နိရာမယလောကာနာံ စိကိတ္သကေန ပြယောဇနံ နာသ္တိ, ကိန္တု သာမယလောကာနာံ ပြယောဇနမာသ္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","အတော ယူယံ ယာတွာ ဝစနသျာသျာရ္ထံ ၑိက္ၐဓွမ်, ဒယာယာံ မေ ယထာ ပြီတိ ရ္န တထာ ယဇ္ဉကရ္မ္မဏိ၊ ယတော'ဟံ ဓာရ္မ္မိကာန် အာဟွာတုံ နာဂတော'သ္မိ ကိန္တု မနး ပရိဝရ္တ္တယိတုံ ပါပိန အာဟွာတုမ် အာဂတော'သ္မိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","အနန္တရံ ယောဟနး ၑိၐျာသ္တသျ သမီပမ် အာဂတျ ကထယာမာသုး, ဖိရူၑိနော ဝယဉ္စ ပုနး ပုနရုပဝသာမး, ကိန္တု တဝ ၑိၐျာ နောပဝသန္တိ, ကုတး? ");
INSERT INTO sanbur_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","တဒါ ယီၑုသ္တာန် အဝေါစတ် ယာဝတ် သခီနာံ သံင်္ဂေ ကနျာယာ ဝရသ္တိၐ္ဌတိ, တာဝတ် ကိံ တေ ဝိလာပံ ကရ္တ္တုံ ၑက္လုဝန္တိ? ကိန္တု ယဒါ တေၐာံ သံင်္ဂါဒ် ဝရံ နယန္တိ, တာဒၖၑး သမယ အာဂမိၐျတိ, တဒါ တေ ဥပဝတ္သျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","ပုရာတနဝသနေ ကောပိ နဝီနဝသ္တြံ န ယောဇယတိ, ယသ္မာတ် တေန ယောဇိတေန ပုရာတနဝသနံ ဆိနတ္တိ တစ္ဆိဒြဉ္စ ဗဟုကုတ္သိတံ ဒၖၑျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","အနျဉ္စ ပုရာတနကုတွာံ ကောပိ နဝါနဂေါသ္တနီရသံ န နိဒဓာတိ, ယသ္မာတ် တထာ ကၖတေ ကုတူ ရွိဒီရျျတေ တေန ဂေါသ္တနီရသး ပတတိ ကုတူၑ္စ နၑျတိ; တသ္မာတ် နဝီနာယာံ ကုတွာံ နဝီနော ဂေါသ္တနီရသး သ္ထာပျတေ, တေန ဒွယောရဝနံ ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","အပရံ တေနဲတတ္ကထာကထနကာလေ ဧကော'ဓိပတိသ္တံ ပြဏမျ ဗဘာၐေ, မမ ဒုဟိတာ ပြာယေဏဲတာဝတ္ကာလေ မၖတာ, တသ္မာဒ် ဘဝါနာဂတျ တသျာ ဂါတြေ ဟသ္တမရ္ပယတု, တေန သာ ဇီဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","တဒါနီံ ယီၑုး ၑိၐျဲး သာကမ် ဥတ္ထာယ တသျ ပၑ္စာဒ် ဝဝြာဇ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ဣတျနန္တရေ ဒွါဒၑဝတ္သရာန် ယာဝတ် ပြဒရာမယေန ၑီရ္ဏဲကာ နာရီ တသျ ပၑ္စာဒ် အာဂတျ တသျ ဝသနသျ ဂြန္ထိံ ပသ္ပရ္ၑ; ");
INSERT INTO sanbur_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ယသ္မာတ် မယာ ကေဝလံ တသျ ဝသနံ သ္ပၖၐ္ဋွာ သွာသ္ထျံ ပြာပ္သျတေ, သာ နာရီတိ မနသိ နိၑ္စိတဝတီ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","တတော ယီၑုရွဒနံ ပရာဝရ္တ္တျ တာံ ဇဂါဒ, ဟေ ကနျေ, တွံ သုသ္ထိရာ ဘဝ, တဝ ဝိၑွာသသ္တွာံ သွသ္ထာမကာရ္ၐီတ်၊ ဧတဒွါကျေ ဂဒိတဧဝ သာ ယောၐိတ် သွသ္ထာဘူတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","အပရံ ယီၑုသ္တသျာဓျက္ၐသျ ဂေဟံ ဂတွာ ဝါဒကပြဘၖတီန် ဗဟူန် လောကာန် ၑဗ္ဒာယမာနာန် ဝိလောကျ တာန် အဝဒတ်, ");
INSERT INTO sanbur_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ပန္ထာနံ တျဇ, ကနျေယံ နာမြိယတ နိဒြိတာသ္တေ; ကထာမေတာံ ၑြုတွာ တေ တမုပဇဟသုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","ကိန္တု သရွွေၐု ဗဟိၐ္ကၖတေၐု သော'ဘျန္တရံ ဂတွာ ကနျာယား ကရံ ဓၖတဝါန်, တေန သောဒတိၐ္ဌတ်; ");
INSERT INTO sanbur_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","တတသ္တတ္ကရ္မ္မဏော ယၑး ကၖတ္သ္နံ တံ ဒေၑံ ဝျာပ္တဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","တတး ပရံ ယီၑုသ္တသ္မာတ် သ္ထာနာဒ် ယာတြာံ စကာရ; တဒါ ဟေ ဒါယူဒး သန္တာန, အသ္မာန် ဒယသွ, ဣတိ ဝဒန္တော် ဒွေါ် ဇနာဝန္ဓော် ပြောစဲရာဟူယန္တော် တတ္ပၑ္စာဒ် ဝဝြဇတုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","တတော ယီၑော် ဂေဟမဓျံ ပြဝိၐ္ဋံ တာဝပိ တသျ သမီပမ် ဥပသ္ထိတဝန္တော်, တဒါနီံ သ တော် ပၖၐ္ဋဝါန် ကရ္မ္မဲတတ် ကရ္တ္တုံ မမ သာမရ္ထျမ် အာသ္တေ, ယုဝါံ ကိမိတိ ပြတီထး? တဒါ တော် ပြတျူစတုး, သတျံ ပြဘော၊ ");
INSERT INTO sanbur_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","တဒါနီံ သ တယော ရ္လောစနာနိ သ္ပၖၑန် ဗဘာၐေ, ယုဝယေား ပြတီတျနုသာရာဒ် ယုဝယော ရ္မင်္ဂလံ ဘူယာတ်၊ တေန တတ္က္ၐဏာတ် တယော ရ္နေတြာဏိ ပြသန္နာနျဘဝန်, ");
INSERT INTO sanbur_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ပၑ္စာဒ် ယီၑုသ္တော် ဒၖဎမာဇ္ဉာပျ ဇဂါဒ, အဝဓတ္တမ် ဧတာံ ကထာံ ကောပိ မနုဇော မ ဇာနီယာတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","ကိန္တု တော် ပြသ္ထာယ တသ္မိန် ကၖတ္သ္နေ ဒေၑေ တသျ ကီရ္တ္တိံ ပြကာၑယာမာသတုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","အပရံ တော် ဗဟိရျာတ ဧတသ္မိန္နန္တရေ မနုဇာ ဧကံ ဘူတဂြသ္တမူကံ တသျ သမီပမ် အာနီတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","တေန ဘူတေ တျာဇိတေ သ မူကး ကထာံ ကထယိတုံ ပြာရဘတ, တေန ဇနာ ဝိသ္မယံ ဝိဇ္ဉာယ ကထယာမာသုး, ဣသြာယေလော ဝံၑေ ကဒါပိ နေဒၖဂဒၖၑျတ; ");
INSERT INTO sanbur_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","ကိန္တု ဖိရူၑိနး ကထယာဉ္စကြုး ဘူတာဓိပတိနာ သ ဘူတာန် တျာဇယတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","တတး ပရံ ယီၑုသ္တေၐာံ ဘဇနဘဝန ဥပဒိၑန် ရာဇျသျ သုသံဝါဒံ ပြစာရယန် လောကာနာံ ယသျ ယ အာမယော ယာ စ ပီဍာသီတ်, တာန် ၑမယန် ၑမယံၑ္စ သရွွာဏိ နဂရာဏိ ဂြာမာံၑ္စ ဗဘြာမ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","အနျဉ္စ မနုဇာန် ဝျာကုလာန် အရက္ၐကမေၐာနိဝ စ တျက္တာန် နိရီက္ၐျ တေၐု ကာရုဏိကး သန် ၑိၐျာန် အဝဒတ်, ");
INSERT INTO sanbur_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ၑသျာနိ ပြစုရာဏိ သန္တိ, ကိန္တု ဆေတ္တာရး သ္တောကား၊ ");
INSERT INTO sanbur_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","က္ၐေတြံ ပြတျပရာန် ဆေဒကာန် ပြဟေတုံ ၑသျသွာမိနံ ပြာရ္ထယဓွမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","အနန္တရံ ယီၑု ရ္ဒွါဒၑၑိၐျာန် အာဟူယာမေဓျဘူတာန် တျာဇယိတုံ သရွွပြကာရရောဂါန် ပီဍာၑ္စ ၑမယိတုံ တေဘျး သာမရ္ထျမဒါတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","တေၐာံ ဒွါဒၑပြေၐျာဏာံ နာမာနျေတာနိ၊ ပြထမံ ၑိမောန် ယံ ပိတရံ ဝဒန္တိ, တတး ပရံ တသျ သဟဇ အာန္ဒြိယး, သိဝဒိယသျ ပုတြော ယာကူဗ္ ");
INSERT INTO sanbur_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","တသျ သဟဇော ယောဟန်; ဖိလိပ် ဗရ္ထလမယ် ထောမား ကရသံဂြာဟီ မထိး, အာလ္ဖေယပုတြော ယာကူဗ်, ");
INSERT INTO sanbur_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ကိနာနီယး ၑိမောန်, ယ ဤၐ္ကရိယောတီယယိဟူဒါး ခြီၐ္ဋံ ပရကရေ'ရ္ပယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ဧတာန် ဒွါဒၑၑိၐျာန် ယီၑုး ပြေၐယန် ဣတျာဇ္ဉာပယတ်, ယူယမ် အနျဒေၑီယာနာံ ပဒဝီံ ၑေမိရောဏီယာနာံ ကိမပိ နဂရဉ္စ န ပြဝိၑျေ ");
INSERT INTO sanbur_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ဣသြာယေလ္ဂောတြသျ ဟာရိတာ ယေ ယေ မေၐာသ္တေၐာမေဝ သမီပံ ယာတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","ဂတွာ ဂတွာ သွရ္ဂသျ ရာဇတွံ သဝိဓမဘဝတ်, ဧတာံ ကထာံ ပြစာရယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","အာမယဂြသ္တာန် သွသ္ထာန် ကုရုတ, ကုၐ္ဌိနး ပရိၐ္ကုရုတ, မၖတလောကာန် ဇီဝယတ, ဘူတာန် တျာဇယတ, ဝိနာ မူလျံ ယူယမ် အလဘဓွံ ဝိနဲဝ မူလျံ ဝိၑြာဏယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","ကိန္တု သွေၐာံ ကဋိဗန္ဓေၐု သွရ္ဏရူပျတာမြာဏာံ ကိမပိ န ဂၖဟ္လီတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","အနျစ္စ ယာတြာယဲ စေလသမ္ပုဋံ ဝါ ဒွိတီယဝသနံ ဝါ ပါဒုကေ ဝါ ယၐ္ဋိး, ဧတာန် မာ ဂၖဟ္လီတ, ယတး ကာရျျကၖတ် ဘရ္တ္တုံ ယောဂျော ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","အပရံ ယူယံ ယတ် ပုရံ ယဉ္စ ဂြာမံ ပြဝိၑထ, တတြ ယော ဇနော ယောဂျပါတြံ တမဝဂတျ ယာနကာလံ ယာဝတ် တတြ တိၐ္ဌတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","ယဒါ ယူယံ တဒ္ဂေဟံ ပြဝိၑထ, တဒါ တမာၑိၐံ ဝဒတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ယဒိ သ ယောဂျပါတြံ ဘဝတိ, တရှိ တတ္ကလျာဏံ တသ္မဲ ဘဝိၐျတိ, နောစေတ် သာၑီရျုၐ္မဘျမေဝ ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","ကိန္တု ယေ ဇနာ ယုၐ္မာကမာတိထျံ န ဝိဒဓတိ ယုၐ္မာကံ ကထာဉ္စ န ၑၖဏွန္တိ တေၐာံ ဂေဟာတ် ပုရာဒွါ ပြသ္ထာနကာလေ သွပဒူလီး ပါတယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","ယုၐ္မာနဟံ တထျံ ဝစ္မိ ဝိစာရဒိနေ တတ္ပုရသျ ဒၑာတး သိဒေါမမောရာပုရယောရ္ဒၑာ သဟျတရာ ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","ပၑျတ, ဝၖကယူထမဓျေ မေၐး ယထာဝိသ္တထာ ယုၐ္မာန ပြဟိဏောမိ, တသ္မာဒ် ယူယမ် အဟိရိဝ သတရ္ကား ကပေါတာဣဝါဟိံသကာ ဘဝတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","နၖဘျး သာဝဓာနာ ဘဝတ; ယတသ္တဲ ရျူယံ ရာဇသံသဒိ သမရ္ပိၐျဓွေ တေၐာံ ဘဇနဂေဟေ ပြဟာရိၐျဓွေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ယူယံ မန္နာမဟေတေား ၑာသ္တၖဏာံ ရာဇ္ဉာဉ္စ သမက္ၐံ တာနနျဒေၑိနၑ္စာဓိ သာက္ၐိတွာရ္ထမာနေၐျဓွေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","ကိန္တွိတ္ထံ သမရ္ပိတာ ယူယံ ကထံ ကိမုတ္တရံ ဝက္ၐျထ တတြ မာ စိန္တယတ, ယတသ္တဒါ ယုၐ္မာဘိ ရျဒ် ဝက္တဝျံ တတ် တဒ္ဒဏ္ဍေ ယုၐ္မန္မနး သု သမုပသ္ထာသျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","ယသ္မာတ် တဒါ ယော ဝက္ၐျတိ သ န ယူယံ ကိန္တု ယုၐ္မာကမန္တရသ္ထး ပိတြာတ္မာ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","သဟဇး သဟဇံ တာတး သုတဉ္စ မၖတော် သမရ္ပယိၐျတိ, အပတျာဂိ သွသွပိတြောे ရွိပက္ၐီဘူယ တော် ဃာတယိၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","မန္နမဟေတေား သရွွေ ဇနာ ယုၐ္မာန် ၒृတီယိၐျန္တေ, ကိန္တု ယး ၑေၐံ ယာဝဒ် ဓဲရျျံ ဃၖတွာ သ္ထာသျတိ, သ တြာယိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","တဲ ရျဒါ ယူယမေကပုရေ တာဍိၐျဓွေ, တဒါ ယူယမနျပုရံ ပလာယဓွံ ယုၐ္မာနဟံ တထျံ ဝစ္မိ ယာဝန္မနုဇသုတော နဲတိ တာဝဒ် ဣသြာယေလ္ဒေၑီယသရွွနဂရဘြမဏံ သမာပယိတုံ န ၑက္ၐျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","ဂုရေား ၑိၐျော န မဟာန်, ပြဘောရ္ဒာသော န မဟာန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","ယဒိ ၑိၐျော နိဇဂုရော ရ္ဒာသၑ္စ သွပြဘေား သမာနော ဘဝတိ တရှိ တဒ် ယထေၐ္ဋံ၊ စေတ္တဲရ္ဂၖဟပတိရ္ဘူတရာဇ ဥစျတေ, တရှိ ပရိဝါရား ကိံ တထာ န ဝက္ၐျန္တေ? ");
INSERT INTO sanbur_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","ကိန္တု တေဘျော ယူယံ မာ ဗိဘီတ, ယတော ယန္န ပြကာၑိၐျတေ, တာဒၖက် ဆာဒိတံ ကိမပိ နာသ္တိ, ယစ္စ န ဝျဉ္စိၐျတေ, တာဒၖဂ် ဂုပ္တံ ကိမပိ နာသ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ယဒဟံ ယုၐ္မာန် တမသိ ဝစ္မိ တဒ် ယုၐ္မာဘိရ္ဒီပ္တော် ကထျတာံ; ကရ္ဏာဘျာံ ယတ် ၑြူယတေ တဒ် ဂေဟောပရိ ပြစာရျျတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ယေ ကာယံ ဟန္တုံ ၑက္နုဝန္တိ နာတ္မာနံ, တေဘျော မာ ဘဲၐ္ဋ; ယး ကာယာတ္မာနော် နိရယေ နာၑယိတုံ, ၑက္နောတိ, တတော ဗိဘီတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ဒွေါ် စဋကော် ကိမေကတာမြမုဒြယာ န ဝိကြီယေတေ? တထာပိ ယုၐ္မတ္တာတာနုမတိံ ဝိနာ တေၐာမေကောပိ ဘုဝိ န ပတတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","ယုၐ္မစ္ဆိရသာံ သရွွကစာ ဂဏိတာံး သန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","အတော မာ ဗိဘီတ, ယူယံ ဗဟုစဋကေဘျော ဗဟုမူလျား၊ ");
INSERT INTO sanbur_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","ယော မနုဇသာက္ၐာန္မာမင်္ဂီကုရုတေ တမဟံ သွရ္ဂသ္ထတာတသာက္ၐာဒင်္ဂီကရိၐျေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ပၖထွျာမဟံ ၑာန္တိံ ဒါတုမာဂတဣတိ မာနုဘဝတ, ၑာန္တိံ ဒါတုံ န ကိန္တွသိံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","ပိတၖမာတၖၑ္စၑြူဘိး သာကံ သုတသုတာဗဓူ ရွိရောဓယိတုဉ္စာဂတေाသ္မိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","တတး သွသွပရိဝါရဧဝ နၖၑတြု ရ္ဘဝိတာ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ယး ပိတရိ မာတရိ ဝါ မတ္တောဓိကံ ပြီယတေ, သ န မဒရှး; ");
INSERT INTO sanbur_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","ယၑ္စ သုတေ သုတာယာံ ဝါ မတ္တောဓိကံ ပြီယတေ, သေाပိ န မဒရှး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ယး သွကြုၑံ ဂၖဟ္လန် မတ္ပၑ္စာန္နဲတိ, သေाပိ န မဒရှး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ယး သွပြာဏာနဝတိ, သ တာန် ဟာရယိၐျတေ, ယသ္တု မတ္ကၖတေ သွပြာဏာန် ဟာရယတိ, သ တာနဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","ယော ယုၐ္မာကမာတိထျံ ဝိဒဓာတိ, သ မမာတိထျံ ဝိဒဓာတိ, ယၑ္စ မမာတိထျံ ဝိဒဓာတိ, သ မတ္ပြေရကသျာတိထျံ ဝိဒဓာတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ယော ဘဝိၐျဒွါဒီတိ ဇ္ဉာတွာ တသျာတိထျံ ဝိဓတ္တေ, သ ဘဝိၐျဒွါဒိနး ဖလံ လပ္သျတေ, ယၑ္စ ဓာရ္မ္မိက ဣတိ ဝိဒိတွာ တသျာတိထျံ ဝိဓတ္တေ သ ဓာရ္မ္မိကမာနဝသျ ဖလံ ပြာပ္သျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ယၑ္စ ကၑ္စိတ် ဧတေၐာံ က္ၐုဒြနရာဏာမ် ယံ ကဉ္စနဲကံ ၑိၐျ ဣတိ ဝိဒိတွာ ကံသဲကံ ၑီတလသလိလံ တသ္မဲ ဒတ္တေ, ယုၐ္မာနဟံ တထျံ ဝဒါမိ, သ ကေနာပိ ပြကာရေဏ ဖလေန န ဝဉ္စိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ဣတ္ထံ ယီၑုး သွဒွါဒၑၑိၐျာဏာမာဇ္ဉာပနံ သမာပျ ပုရေ ပုရ ဥပဒေၐ္ဋုံ သုသံဝါဒံ ပြစာရယိတုံ တတ္သ္ထာနာတ် ပြတသ္ထေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","အနန္တရံ ယောဟန် ကာရာယာံ တိၐ္ဌန် ခြိၐ္ဋသျ ကရ္မ္မဏာံ ဝါရ္တ္တံ ပြာပျ ယသျာဂမနဝါရ္တ္တာသီတ် သဧဝ ကိံ တွံ? ဝါ ဝယမနျမ် အပေက္ၐိၐျာမဟေ? ");
INSERT INTO sanbur_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ဧတတ် ပြၐ္ဋုံ နိဇော် ဒွေါ် ၑိၐျော် ပြာဟိဏောတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ယီၑုး ပြတျဝေါစတ်, အန္ဓာ နေတြာဏိ လဘန္တေ, ခဉ္စာ ဂစ္ဆန္တိ, ကုၐ္ဌိနး သွသ္ထာ ဘဝန္တိ, ဗဓိရား ၑၖဏွန္တိ, မၖတာ ဇီဝန္တ ဥတ္တိၐ္ဌန္တိ, ဒရိဒြာဏာံ သမီပေ သုသံဝါဒး ပြစာရျျတ, ");
INSERT INTO sanbur_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ဧတာနိ ယဒျဒ် ယုဝါံ ၑၖဏုထး ပၑျထၑ္စ ဂတွာ တဒွါရ္တ္တာံ ယောဟနံ ဂဒတံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ယသျာဟံ န ဝိဃ္နီဘဝါမိ, သဧဝ ဓနျး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","အနန္တရံ တယေား ပြသ္ထိတယော ရျီၑု ရျောဟနမ် ဥဒ္ဒိၑျ ဇနာန် ဇဂါဒ, ယူယံ ကိံ ဒြၐ္ဋုံ ဝဟိရ္မဓျေပြာန္တရမ် အဂစ္ဆတ? ကိံ ဝါတေန ကမ္ပိတံ နလံ? ");
INSERT INTO sanbur_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","ဝါ ကိံ ဝီက္ၐိတုံ ဝဟိရ္ဂတဝန္တး? ကိံ ပရိဟိတသူက္ၐ္မဝသနံ မနုဇမေကံ? ပၑျတ, ယေ သူက္ၐ္မဝသနာနိ ပရိဒဓတိ, တေ ရာဇဓာနျာံ တိၐ္ဌန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","တရှိ ယူယံ ကိံ ဒြၐ္ဋုံ ဗဟိရဂမတ, ကိမေကံ ဘဝိၐျဒွါဒိနံ? တဒေဝ သတျံ၊ ယုၐ္မာနဟံ ဝဒါမိ, သ ဘဝိၐျဒွါဒိနောပိ မဟာန်; ");
INSERT INTO sanbur_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","ယတး, ပၑျ သွကီယဒူတောယံ တွဒဂြေ ပြေၐျတေ မယာ၊ သ ဂတွာ တဝ ပန္ထာနံ သ္မယက် ပရိၐ္ကရိၐျတိ။ ဧတဒွစနံ ယမဓိ လိခိတမာသ္တေ သော'ယံ ယောဟန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","အပရံ ယုၐ္မာနဟံ တထျံ ဗြဝီမိ, မဇ္ဇယိတု ရျောဟနး ၑြေၐ္ဌး ကောပိ နာရီတော နာဇာယတ; တထာပိ သွရ္ဂရာဇျမဓျေ သရွွေဘျော ယး က္ၐုဒြး သ ယောဟနး ၑြေၐ္ဌး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","အပရဉ္စ အာ ယောဟနော'ဒျ ယာဝတ် သွရ္ဂရာဇျံ ဗလာဒါကြာန္တံ ဘဝတိ အာကြမိနၑ္စ ဇနာ ဗလေန တဒဓိကုရွွန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","ယတော ယောဟနံ ယာဝတ် သရွွဘဝိၐျဒွါဒိဘိ ရွျဝသ္ထယာ စ ဥပဒေၑး ပြာကာၑျတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ယဒိ ယူယမိဒံ ဝါကျံ ဂြဟီတုံ ၑက္နုထ, တရှိ ၑြေယး, ယသျာဂမနသျ ဝစနမာသ္တေ သော'ယမ် ဧလိယး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ယသျ ၑြောတုံ ကရ္ဏော် သ္တး သ ၑၖဏောတု၊ ");
INSERT INTO sanbur_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","ဧတေ ဝိဒျမာနဇနား ကဲ ရ္မယောပမီယန္တေ? ယေ ဗာလကာ ဟဋ္ဋ ဥပဝိၑျ သွံ သွံ ဗန္ဓုမာဟူယ ဝဒန္တိ, ");
INSERT INTO sanbur_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","ဝယံ ယုၐ္မာကံ သမီပေ ဝံၑီရဝါဒယာမ, ကိန္တု ယူယံ နာနၖတျတ; ယုၐ္မာကံ သမီပေ စ ဝယမရောဒိမ, ကိန္တု ယူယံ န ဝျလပတ, တာဒၖၑဲ ရ္ဗာလကဲသ္တ ဥပမာယိၐျန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","ယတော ယောဟန် အာဂတျ န ဘုက္တဝါန် န ပီတဝါံၑ္စ, တေန လောကာ ဝဒန္တိ, သ ဘူတဂြသ္တ ဣတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","မနုဇသုတ အာဂတျ ဘုက္တဝါန် ပီတဝါံၑ္စ, တေန လောကာ ဝဒန္တိ, ပၑျတ ဧၐ ဘောက္တာ မဒျပါတာ စဏ္ဍာလပါပိနာံ ဗန္ဓၑ္စ, ကိန္တု ဇ္ဉာနိနော ဇ္ဉာနဝျဝဟာရံ နိရ္ဒောၐံ ဇာနန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","သ ယတြ ယတြ ပုရေ ဗဟွာၑ္စရျျံ ကရ္မ္မ ကၖတဝါန်, တန္နိဝါသိနာံ မနးပရာဝၖတ္တျဘာဝါတ် တာနိ နဂရာဏိ ပြတိ ဟန္တေတျုက္တာ ကထိတဝါန်, ");
INSERT INTO sanbur_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","ဟာ ကောရာသီန်, ဟာ ဗဲတ္သဲဒေ, ယုၐ္မန္မဓျေ ယဒျဒါၑ္စရျျံ ကရ္မ္မ ကၖတံ ယဒိ တတ် သောရသီဒေါန္နဂရ အကာရိၐျတ, တရှိ ပူရွွမေဝ တန္နိဝါသိနး ၑာဏဝသနေ ဘသ္မနိ စောပဝိၑန္တော မနာံသိ ပရာဝရ္တ္တိၐျန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","တသ္မာဒဟံ ယုၐ္မာန် ဝဒါမိ, ဝိစာရဒိနေ ယုၐ္မာကံ ဒၑာတး သောရသီဒေါနော ရ္ဒၑာ သဟျတရာ ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","အပရဉ္စ ဗတ ကဖရ္နာဟူမ်, တွံ သွရ္ဂံ ယာဝဒုန္နတောသိ, ကိန္တု နရကေ နိက္ၐေပ္သျသေ, ယသ္မာတ် တွယိ ယာနျာၑ္စရျျာဏိ ကရ္မ္မဏျကာရိၐတ, ယဒိ တာနိ သိဒေါမ္နဂရ အကာရိၐျန္တ, တရှိ တဒဒျ ယာဝဒသ္ထာသျတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","ကိန္တွဟံ ယုၐ္မာန် ဝဒါမိ, ဝိစာရဒိနေ တဝ ဒဏ္ဍတး သိဒေါမော ဒဏ္ဍော သဟျတရော ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ဧတသ္မိန္နေဝ သမယေ ယီၑုး ပုနရုဝါစ, ဟေ သွရ္ဂပၖထိဝျောရေကာဓိပတေ ပိတသ္တွံ ဇ္ဉာနဝတော ဝိဒုၐၑ္စ လောကာန် ပြတျေတာနိ န ပြကာၑျ ဗာလကာန် ပြတိ ပြကာၑိတဝါန်, ဣတိ ဟေတောသ္တွာံ ဓနျံ ဝဒါမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ဟေ ပိတး, ဣတ္ထံ ဘဝေတ် ယတ ဣဒံ တွဒၖၐ္ဋာဝုတ္တမံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","ပိတြာ မယိ သရွွာဏိ သမရ္ပိတာနိ, ပိတရံ ဝိနာ ကောပိ ပုတြံ န ဇာနာတိ, ယာန် ပြတိ ပုတြေဏ ပိတာ ပြကာၑျတေ တာန် ဝိနာ ပုတြာဒ် အနျး ကောပိ ပိတရံ န ဇာနာတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","ဟေ ပရိၑြာန္တာ ဘာရာကြာန္တာၑ္စ လောကာ ယူယံ မတ္သန္နိဓိမ် အာဂစ္ဆတ, အဟံ ယုၐ္မာန် ဝိၑြမယိၐျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","အဟံ က္ၐမဏၑီလော နမြမနာၑ္စ, တသ္မာတ် မမ ယုဂံ သွေၐာမုပရိ ဓာရယတ မတ္တး ၑိက္ၐဓွဉ္စ, တေန ယူယံ သွေ သွေ မနသိ ဝိၑြာမံ လပ္သျဓ္ဗေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ယတော မမ ယုဂမ် အနာယာသံ မမ ဘာရၑ္စ လဃုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","အနန္တရံ ယီၑု ရွိၑြာမဝါရေ ၑ္သျမဓျေန ဂစ္ဆတိ, တဒါ တစ္ဆိၐျာ ဗုဘုက္ၐိတား သန္တး ၑ္သျမဉ္ဇရီၑ္ဆတွာ ဆိတွာ ခါဒိတုမာရဘန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","တဒ် ဝိလောကျ ဖိရူၑိနော ယီၑုံ ဇဂဒုး, ပၑျ ဝိၑြာမဝါရေ ယတ် ကရ္မ္မာကရ္တ္တဝျံ တဒေဝ တဝ ၑိၐျား ကုရွွန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","သ တာန် ပြတျာဝဒတ, ဒါယူဒ် တတ္သင်္ဂိနၑ္စ ဗုဘုက္ၐိတား သန္တော ယတ် ကရ္မ္မာကုရွွန် တတ် ကိံ ယုၐ္မာဘိ ရ္နာပါဌိ? ");
INSERT INTO sanbur_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ယေ ဒရ္ၑနီယား ပူပါး ယာဇကာန် ဝိနာ တသျ တတ္သင်္ဂိမနုဇာနာဉ္စာဘောဇနီယာသ္တ ဤၑွရာဝါသံ ပြဝိၐ္ဋေန တေန ဘုက္တား၊ ");
INSERT INTO sanbur_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","အနျစ္စ ဝိၑြာမဝါရေ မဓျေမန္ဒိရံ ဝိၑြာမဝါရီယံ နိယမံ လငွန္တောပိ ယာဇကာ နိရ္ဒောၐာ ဘဝန္တိ, ၑာသ္တြမဓျေ ကိမိဒမပိ ယုၐ္မာဘိ ရ္န ပဌိတံ? ");
INSERT INTO sanbur_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","ယုၐ္မာနဟံ ဝဒါမိ, အတြ သ္ထာနေ မန္ဒိရာဒပိ ဂရီယာန် ဧက အာသ္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","ကိန္တု ဒယာယာံ မေ ယထာ ပြီတိ ရ္န တထာ ယဇ္ဉကရ္မ္မဏိ၊ ဧတဒွစနသျာရ္ထံ ယဒိ ယုယမ် အဇ္ဉာသိၐ္ဋ တရှိ နိရ္ဒောၐာန် ဒေါၐိဏော နာကာရ္ၐ္ဋ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","အနျစ္စ မနုဇသုတော ဝိၑြာမဝါရသျာပိ ပတိရာသ္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","အနန္တရံ သ တတ္သ္ထာနာတ် ပြသ္ထာယ တေၐာံ ဘဇနဘဝနံ ပြဝိၐ္ဋဝါန်, တဒါနီမ် ဧကး ၑုၐ္ကကရာမယဝါန် ဥပသ္ထိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","တတော ယီၑုမ် အပဝဒိတုံ မာနုၐား ပပြစ္ဆုး, ဝိၑြာမဝါရေ နိရာမယတွံ ကရဏီယံ န ဝါ? ");
INSERT INTO sanbur_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","တေန သ ပြတျုဝါစ, ဝိၑြာမဝါရေ ယဒိ ကသျစိဒ် အဝိ ရ္ဂရ္တ္တေ ပတတိ, တရှိ ယသ္တံ ဃၖတွာ န တောလယတိ, ဧတာဒၖၑော မနုဇော ယုၐ္မာကံ မဓျေ က အာသ္တေ? ");
INSERT INTO sanbur_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","အဝေ ရ္မာနဝး ကိံ နဟိ ၑြေယာန်? အတော ဝိၑြာမဝါရေ ဟိတကရ္မ္မ ကရ္တ္တဝျံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","အနန္တရံ သ တံ မာနဝံ ဂဒိတဝါန်, ကရံ ပြသာရယ; တေန ကရေ ပြသာရိတေ သောနျကရဝတ် သွသ္ထော'ဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","တဒါ ဖိရူၑိနော ဗဟိရ္ဘူယ ကထံ တံ ဟနိၐျာမ ဣတိ ကုမန္တြဏာံ တတ္ပြာတိကူလျေန စကြုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","တတော ယီၑုသ္တဒ် ဝိဒိတွာ သ္ထနာန္တရံ ဂတဝါန်; အနျေၐု ဗဟုနရေၐု တတ္ပၑ္စာဒ် ဂတေၐု တာန် သ နိရာမယာန် ကၖတွာ ဣတျာဇ္ဉာပယတ်, ");
INSERT INTO sanbur_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ယူယံ မာံ န ပရိစာယယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","တသ္မာတ် မမ ပြီယော မနောနီတော မနသသ္တုၐ္ဋိကာရကး၊ မဒီယး သေဝကော ယသ္တု ဝိဒျတေ တံ သမီက္ၐတာံ၊ တသျောပရိ သွကီယာတ္မာ မယာ သံသ္ထာပယိၐျတေ၊ တေနာနျဒေၑဇာတေၐု ဝျဝသ္ထာ သံပြကာၑျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","ကေနာပိ န ဝိရောဓံ သ ဝိဝါဒဉ္စ ကရိၐျတိ၊ န စ ရာဇပထေ တေန ဝစနံ ၑြာဝယိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ဝျဝသ္ထာ စလိတာ ယာဝတ် နဟိ တေန ကရိၐျတေ၊ တာဝတ် နလော ဝိဒီရ္ဏော'ပိ ဘံက္ၐျတေ နဟိ တေန စ၊ တထာ သဓူမဝရ္တ္တိဉ္စ န သ နိရွွာပယိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ပြတျာၑာဉ္စ ကရိၐျန္တိ တန္နာမ္နိ ဘိန္နဒေၑဇား၊ ");
INSERT INTO sanbur_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ယာနျေတာနိ ဝစနာနိ ယိၑယိယဘဝိၐျဒွါဒိနာ ပြောက္တာနျာသန်, တာနိ သဖလာနျဘဝန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","အနန္တရံ လောကဲ သ္တတ္သမီပမ် အာနီတော ဘူတဂြသ္တာန္ဓမူကဲကမနုဇသ္တေန သွသ္ထီကၖတး, တတး သော'န္ဓော မူကော ဒြၐ္ဋုံ ဝက္တုဉ္စာရဗ္ဓဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","အနေန သရွွေ ဝိသ္မိတား ကထယာဉ္စကြုး, ဧၐး ကိံ ဒါယူဒး သန္တာနော နဟိ? ");
INSERT INTO sanbur_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","ကိန္တု ဖိရူၑိနသ္တတ် ၑြုတွာ ဂဒိတဝန္တး, ဗာလ္သိဗူဗ္နာမ္နော ဘူတရာဇသျ သာဟာယျံ ဝိနာ နာယံ ဘူတာန် တျာဇယတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","တဒါနီံ ယီၑုသ္တေၐာမ် ဣတိ မာနသံ ဝိဇ္ဉာယ တာန် အဝဒတ် ကိဉ္စန ရာဇျံ ယဒိ သွဝိပက္ၐာဒ် ဘိဒျတေ, တရှိ တတ် ဥစ္ဆိဒျတေ; ယစ္စ ကိဉ္စန နဂရံ ဝါ ဂၖဟံ သွဝိပက္ၐာဒ် ဝိဘိဒျတေ, တတ် သ္ထာတုံ န ၑက္နောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","တဒွတ် ၑယတာနော ယဒိ ၑယတာနံ ဗဟိး ကၖတွာ သွဝိပက္ၐာတ် ပၖထက် ပၖထက် ဘဝတိ, တရှိ တသျ ရာဇျံ ကေန ပြကာရေဏ သ္ထာသျတိ? ");
INSERT INTO sanbur_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","အဟဉ္စ ယဒိ ဗာလ္သိဗူဗာ ဘူတာန် တျာဇယာမိ, တရှိ ယုၐ္မာကံ သန္တာနား ကေန ဘူတာန် တျာဇယန္တိ? တသ္မာဒ် ယုၐ္မာကမ် ဧတဒွိစာရယိတာရသ္တ ဧဝ ဘဝိၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","ကိန္တဝဟံ ယဒီၑွရာတ္မနာ ဘူတာန် တျာဇယာမိ, တရှီၑွရသျ ရာဇျံ ယုၐ္မာကံ သန္နိဓိမာဂတဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","အနျဉ္စ ကောပိ ဗလဝန္တ ဇနံ ပြထမတော န ဗဒွွာ ကေန ပြကာရေဏ တသျ ဂၖဟံ ပြဝိၑျ တဒ္ဒြဝျာဒိ လောဌယိတုံ ၑက္နောတိ? ကိန္တု တတ် ကၖတွာ တဒီယဂၖသျ ဒြဝျာဒိ လောဌယိတုံ ၑက္နောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","ယး ကၑ္စိတ် မမ သွပက္ၐီယော နဟိ သ ဝိပက္ၐီယ အာသ္တေ, ယၑ္စ မယာ သာကံ န သံဂၖဟ္လာတိ, သ ဝိကိရတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","အတဧဝ ယုၐ္မာနဟံ ဝဒါမိ, မနုဇာနာံ သရွွပြကာရပါပါနာံ နိန္ဒာယာၑ္စ မရ္ၐဏံ ဘဝိတုံ ၑက္နောတိ, ကိန္တု ပဝိတြသျာတ္မနော ဝိရုဒ္ဓနိန္ဒာယာ မရ္ၐဏံ ဘဝိတုံ န ၑက္နောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","ယော မနုဇသုတသျ ဝိရုဒ္ဓါံ ကထာံ ကထယတိ, တသျာပရာဓသျ က္ၐမာ ဘဝိတုံ ၑက္နောတိ, ကိန္တု ယး ကၑ္စိတ် ပဝိတြသျာတ္မနော ဝိရုဒ္ဓါံ ကထာံ ကထယတိ နေဟလောကေ န ပြေတျ တသျာပရာဓသျ က္ၐမာ ဘဝိတုံ ၑက္နောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","ပါဒပံ ယဒိ ဘဒြံ ဝဒထ, တရှိ တသျ ဖလမပိ သာဓု ဝက္တဝျံ, ယဒိ စ ပါဒပံ အသာဓုံ ဝဒထ, တရှိ တသျ ဖလမပျသာဓု ဝက္တဝျံ; ယတး သွီယသွီယဖလေန ပါဒပး ပရိစီယတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","ရေ ဘုဇဂဝံၑာ ယူယမသာဓဝး သန္တး ကထံ သာဓု ဝါကျံ ဝက္တုံ ၑက္ၐျထ? ယသ္မာဒ် အန္တးကရဏသျ ပူရ္ဏဘာဝါနုသာရာဒ် ဝဒနာဒ် ဝစော နိရ္ဂစ္ဆတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","တေန သာဓုရ္မာနဝေါ'န္တးကရဏရူပါတ် သာဓုဘာဏ္ဍာဂါရာတ် သာဓု ဒြဝျံ နိရ္ဂမယတိ, အသာဓုရ္မာနုၐသ္တွသာဓုဘာဏ္ဍာဂါရာဒ် အသာဓုဝသ္တူနိ နိရ္ဂမယတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","ကိန္တွဟံ ယုၐ္မာန် ဝဒါမိ, မနုဇာ ယာဝန္တျာလသျဝစာံသိ ဝဒန္တိ, ဝိစာရဒိနေ တဒုတ္တရမဝၑျံ ဒါတဝျံ, ");
INSERT INTO sanbur_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","ယတသ္တွံ သွီယဝစောဘိ ရ္နိရပရာဓး သွီယဝစောဘိၑ္စ သာပရာဓော ဂဏိၐျသေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","တဒါနီံ ကတိပယာ ဥပါဓျာယား ဖိရူၑိနၑ္စ ဇဂဒုး, ဟေ ဂုရော ဝယံ ဘဝတ္တး ကိဉ္စန လက္ၐ္မ ဒိဒၖက္ၐာမး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","တဒါ သ ပြတျုက္တဝါန်, ဒုၐ္ဋော ဝျဘိစာရီ စ ဝံၑော လက္ၐ္မ မၖဂယတေ, ကိန္တု ဘဝိၐျဒွါဒိနော ယူနသော လက္ၐ္မ ဝိဟာယာနျတ် ကိမပိ လက္ၐ္မ တေ န ပြဒရ္ၑယိၐျန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ယတော ယူနမ် ယထာ တြျဟောရာတြံ ဗၖဟန္မီနသျ ကုက္ၐာဝါသီတ်, တထာ မနုဇပုတြောပိ တြျဟောရာတြံ မေဒိနျာ မဓျေ သ္ထာသျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","အပရံ နီနိဝီယာ မာနဝါ ဝိစာရဒိန ဧတဒွံၑီယာနာံ ပြတိကူလမ် ဥတ္ထာယ တာန် ဒေါၐိဏး ကရိၐျန္တိ, ယသ္မာတ္တေ ယူနသ ဥပဒေၑာတ် မနာံသိ ပရာဝရ္တ္တယာဉ္စကြိရေ, ကိန္တွတြ ယူနသောပိ ဂုရုတရ ဧက အာသ္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","ပုနၑ္စ ဒက္ၐိဏဒေၑီယာ ရာဇ္ဉီ ဝိစာရဒိန ဧတဒွံၑီယာနာံ ပြတိကူလမုတ္ထာယ တာန် ဒေါၐိဏး ကရိၐျတိ ယတး သာ ရာဇ္ဉီ သုလေမနော ဝိဒျာယား ကထာံ ၑြောတုံ မေဒိနျား သီမ္န အာဂစ္ဆတ်, ကိန္တု သုလေမနောပိ ဂုရုတရ ဧကော ဇနော'တြ အာသ္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","အပရံ မနုဇာဒ် ဗဟိရ္ဂတော 'ပဝိတြဘူတး ၑုၐ္ကသ္ထာနေန ဂတွာ ဝိၑြာမံ ဂဝေၐယတိ, ကိန္တု တဒလဘမာနး သ ဝက္တိ, ယသ္မာ; နိကေတနာဒ် အာဂမံ, တဒေဝ ဝေၑ္မ ပကာဝၖတျ ယာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ပၑ္စာတ် သ တတ် သ္ထာနမ် ဥပသ္ထာယ တတ် ၑူနျံ မာရ္ဇ္ဇိတံ ၑောဘိတဉ္စ ဝိလောကျ ဝြဇန် သွတောပိ ဒုၐ္ဋတရာန် အနျသပ္တဘူတာန် သင်္ဂိနး ကရောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","တတသ္တေ တတ် သ္ထာနံ ပြဝိၑျ နိဝသန္တိ, တေန တသျ မနုဇသျ ၑေၐဒၑာ ပူရွွဒၑာတောတီဝါၑုဘာ ဘဝတိ, ဧတေၐာံ ဒုၐ္ဋဝံၑျာနာမပိ တထဲဝ ဃဋိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","မာနဝေဘျ ဧတာသာံ ကထနာံ ကထနကာလေ တသျ မာတာ သဟဇာၑ္စ တေန သာကံ ကာဉ္စိတ် ကထာံ ကထယိတုံ ဝါဉ္ဆန္တော ဗဟိရေဝ သ္ထိတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","တတး ကၑ္စိတ် တသ္မဲ ကထိတဝါန်, ပၑျ တဝ ဇနနီ သဟဇာၑ္စ တွယာ သာကံ ကာဉ္စန ကထာံ ကထယိတုံ ကာမယမာနာ ဗဟိသ္တိၐ္ဌန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","ကိန္တု သ တံ ပြတျဝဒတ်, မမ ကာ ဇနနီ? ကေ ဝါ မမ သဟဇား? ");
INSERT INTO sanbur_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ပၑ္စာတ် ၑိၐျာန် ပြတိ ကရံ ပြသာရျျ ကထိတဝါန်, ပၑျ မမ ဇနနီ မမ သဟဇာၑ္စဲတေ; ");
INSERT INTO sanbur_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ယး ကၑ္စိတ် မမ သွရ္ဂသ္ထသျ ပိတုရိၐ္ဋံ ကရ္မ္မ ကုရုတေ, သဧဝ မမ ဘြာတာ ဘဂိနီ ဇနနီ စ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","အပရဉ္စ တသ္မိန် ဒိနေ ယီၑုး သဒ္မနော ဂတွာ သရိတ္ပတေ ရောဓသိ သမုပဝိဝေၑ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","တတြ တတ္သန္နိဓော် ဗဟုဇနာနာံ နိဝဟောပသ္ထိတေး သ တရဏိမာရုဟျ သမုပါဝိၑတ်, တေန မာနဝါ ရောဓသိ သ္ထိတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","တဒါနီံ သ ဒၖၐ္ဋာန္တဲသ္တာန် ဣတ္ထံ ဗဟုၑ ဥပဒိၐ္ဋဝါန်၊ ပၑျတ, ကၑ္စိတ် ကၖၐီဝလော ဗီဇာနိ ဝပ္တုံ ဗဟိရ္ဇဂါမ, ");
INSERT INTO sanbur_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","တသျ ဝပနကာလေ ကတိပယဗီဇေၐု မာရ္ဂပါရ္ၑွေ ပတိတေၐု ဝိဟဂါသ္တာနိ ဘက္ၐိတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","အပရံ ကတိပယဗီဇေၐု သ္တောကမၖဒျုက္တပါၐာဏေ ပတိတေၐု မၖဒလ္ပတွာတ် တတ္က္ၐဏာတ် တာနျင်္ကုရိတာနိ, ");
INSERT INTO sanbur_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ကိန္တု ရဝါဝုဒိတေ ဒဂ္ဓာနိ တေၐာံ မူလာပြဝိၐ္ဋတွာတ် ၑုၐ္ကတာံ ဂတာနိ စ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","အပရံ ကတိပယဗီဇေၐု ကဏ္ဋကာနာံ မဓျေ ပတိတေၐု ကဏ္ဋကာနျေဓိတွာ တာနိ ဇဂြသုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","အပရဉ္စ ကတိပယဗီဇာနိ ဥရွွရာယာံ ပတိတာနိ; တေၐာံ မဓျေ ကာနိစိတ် ၑတဂုဏာနိ ကာနိစိတ် ၐၐ္ဋိဂုဏာနိ ကာနိစိတ် တြိံၑဂုံဏာနိ ဖလာနိ ဖလိတဝန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ၑြောတုံ ယသျ ၑြုတီ အာသာတေ သ ၑၖဏုယာတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","အနန္တရံ ၑိၐျဲရာဂတျ သော'ပၖစ္ဆျတ, ဘဝတာ တေဘျး ကုတော ဒၖၐ္ဋာန္တကထာ ကထျတေ? ");
INSERT INTO sanbur_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","တတး သ ပြတျဝဒတ်, သွရ္ဂရာဇျသျ နိဂူဎာံ ကထာံ ဝေဒိတုံ ယုၐ္မဘျံ သာမရ္ထျမဒါယိ, ကိန္တု တေဘျော နာဒါယိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","ယသ္မာဒ် ယသျာန္တိကေ ဝရ္ဒ္ဓတေ, တသ္မာယေဝ ဒါယိၐျတေ, တသ္မာတ် တသျ ဗာဟုလျံ ဘဝိၐျတိ, ကိန္တု ယသျာန္တိကေ န ဝရ္ဒ္ဓတေ, တသျ ယတ် ကိဉ္စနာသ္တေ, တဒပိ တသ္မာဒ် အာဒါယိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","တေ ပၑျန္တောပိ န ပၑျန္တိ, ၑၖဏွန္တောပိ န ၑၖဏွန္တိ, ဗုဓျမာနာ အပိ န ဗုဓျန္တေ စ, တသ္မာတ် တေဘျော ဒၖၐ္ဋာန္တကထာ ကထျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","ယထာ ကရ္ဏဲး ၑြောၐျထ ယူယံ ဝဲ ကိန္တု ယူယံ န ဘောတ္သျထ၊ နေတြဲရ္ဒြက္ၐျထ ယူယဉ္စ ပရိဇ္ဉာတုံ န ၑက္ၐျထ၊ တေ မာနုၐာ ယထာ နဲဝ ပရိပၑျန္တိ လောစနဲး၊ ကရ္ဏဲ ရျထာ န ၑၖဏွန္တိ န ဗုဓျန္တေ စ မာနသဲး၊ ဝျာဝရ္တ္တိတေၐု စိတ္တေၐု ကာလေ ကုတြာပိ တဲရ္ဇနဲး၊ မတ္တသ္တေ မနုဇား သွသ္ထာ ယထာ နဲဝ ဘဝန္တိ စ၊ တထာ တေၐာံ မနုၐျာဏာံ ကြိယန္တေ သ္ထူလဗုဒ္ဓယး၊ ဗဓိရီဘူတကရ္ဏာၑ္စ ဇာတာၑ္စ မုဒြိတာ ဒၖၑး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ယဒေတာနိ ဝစနာနိ ယိၑယိယဘဝိၐျဒွါဒိနာ ပြောက္တာနိ တေၐု တာနိ ဖလန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","ကိန္တု ယုၐ္မာကံ နယနာနိ ဓနျာနိ, ယသ္မာတ် တာနိ ဝီက္ၐန္တေ; ဓနျာၑ္စ ယုၐ္မာကံ ၑဗ္ဒဂြဟား, ယသ္မာတ် တဲရာကရ္ဏျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","မယာ ယူယံ တထျံ ဝစာမိ ယုၐ္မာဘိ ရျဒျဒ် ဝီက္ၐျတေ, တဒ် ဗဟဝေါ ဘဝိၐျဒွါဒိနော ဓာရ္မ္မိကာၑ္စ မာနဝါ ဒိဒၖက္ၐန္တောပိ ဒြၐ္ဋုံ နာလဘန္တ, ပုနၑ္စ ယူယံ ယဒျတ် ၑၖဏုထ, တတ် တေ ၑုၑြူၐမာဏာ အပိ ၑြောတုံ နာလဘန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","ကၖၐီဝလီယဒၖၐ္ဋာန္တသျာရ္ထံ ၑၖဏုတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","မာရ္ဂပါရ္ၑွေ ဗီဇာနျုပ္တာနိ တသျာရ္ထ ဧၐး, ယဒါ ကၑ္စိတ် ရာဇျသျ ကထာံ နိၑမျ န ဗုဓျတေ, တဒါ ပါပါတ္မာဂတျ တဒီယမနသ ဥပ္တာံ ကထာံ ဟရန် နယတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","အပရံ ပါၐာဏသ္ထလေ ဗီဇာနျုပ္တာနိ တသျာရ္ထ ဧၐး; ကၑ္စိတ် ကထာံ ၑြုတွဲဝ ဟရ္ၐစိတ္တေန ဂၖဟ္လာတိ, ");
INSERT INTO sanbur_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ကိန္တု တသျ မနသိ မူလာပြဝိၐ္ဋတွာတ် သ ကိဉ္စိတ္ကာလမာတြံ သ္ထိရသ္တိၐ္ဌတိ; ပၑ္စာတ တတ္ကထာကာရဏာတ် ကောပိ က္လေသ္တာဍနာ ဝါ စေတ် ဇာယတေ, တရှိ သ တတ္က္ၐဏာဒ် ဝိဃ္နမေတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","အပရံ ကဏ္ဋကာနာံ မဓျေ ဗီဇာနျုပ္တာနိ တဒရ္ထ ဧၐး; ကေနစိတ် ကထာယာံ ၑြုတာယာံ သာံသာရိကစိန္တာဘိ ရ္ဘြာန္တိဘိၑ္စ သာ ဂြသျတေ, တေန သာ မာ ဝိဖလာ ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","အပရမ် ဥရွွရာယာံ ဗီဇာနျုပ္တာနိ တဒရ္ထ ဧၐး; ယေ တာံ ကထာံ ၑြုတွာ ဝုဓျန္တေ, တေ ဖလိတား သန္တး ကေစိတ် ၑတဂုဏာနိ ကေစိတ ၐၐ္ဋိဂုဏာနိ ကေစိစ္စ တြိံၑဒ္ဂုဏာနိ ဖလာနိ ဇနယန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","အနန္တရံ သောပရာမေကာံ ဒၖၐ္ဋာန္တကထာမုပသ္ထာပျ တေဘျး ကထယာမာသ; သွရ္ဂီယရာဇျံ တာဒၖၑေန ကေနစိဒ် ဂၖဟသ္ထေနောပမီယတေ, ယေန သွီယက္ၐေတြေ ပြၑသ္တဗီဇာနျော်ပျန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ကိန္တု က္ၐဏဒါယာံ သကလလောကေၐု သုပ္တေၐု တသျ ရိပုရာဂတျ တေၐာံ ဂေါဓူမဗီဇာနာံ မဓျေ ဝနျယဝမဗီဇာနျုပ္တွာ ဝဝြာဇ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","တတော ယဒါ ဗီဇေဘျော'င်္ကရာ ဇာယမာနား ကဏိၑာနိ ဃၖတဝန္တး; တဒါ ဝနျယဝသာနျပိ ဒၖၑျမာနာနျဘဝန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","တတော ဂၖဟသ္ထသျ ဒါသေယာ အာဂမျ တသ္မဲ ကထယာဉ္စကြုး, ဟေ မဟေစ္ဆ, ဘဝတာ ကိံ က္ၐေတြေ ဘဒြဗီဇာနိ နော်ပျန္တ? တထာတွေ ဝနျယဝသာနိ ကၖတ အာယန်? ");
INSERT INTO sanbur_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","တဒါနီံ တေန တေ ပြတိဂဒိတား, ကေနစိတ် ရိပုဏာ ကရ္မ္မဒမကာရိ၊ ဒါသေယား ကထယာမာသုး, ဝယံ ဂတွာ တာနျုတ္ပာယျ က္ၐိပါမော ဘဝတး ကီဒၖၑီစ္ဆာ ဇာယတေ? ");
INSERT INTO sanbur_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","တေနာဝါဒိ, နဟိ, ၑင်္ကေ'ဟံ ဝနျယဝသောတ္ပာဋနကာလေ ယုၐ္မာဘိသ္တဲး သာကံ ဂေါဓူမာ အပျုတ္ပာဋိၐျန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","အတး ၑ္သျကရ္တ္တနကာလံ ယာဝဒ် ဥဘယာနျပိ သဟ ဝရ္ဒ္ဓန္တာံ, ပၑ္စာတ် ကရ္တ္တနကာလေ ကရ္တ္တကာန် ဝက္ၐျာမိ, ယူယမာဒေါ် ဝနျယဝသာနိ သံဂၖဟျ ဒါဟယိတုံ ဝီဋိကာ ဗဒွွာ သ္ထာပယတ; ကိန္တု သရွွေ ဂေါဓူမာ ယုၐ္မာဘိ ရ္ဘာဏ္ဍာဂါရံ နီတွာ သ္ထာပျန္တာမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","အနန္တရံ သောပရာမေကာံ ဒၖၐ္ဋာန္တကထာမုတ္ထာပျ တေဘျး ကထိတဝါန် ကၑ္စိန္မနုဇး သရ္ၐပဗီဇမေကံ နီတွာ သွက္ၐေတြ ဥဝါပ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","သရ္ၐပဗီဇံ သရွွသ္မာဒ် ဗီဇာတ် က္ၐုဒြမပိ သဒင်္ကုရိတံ သရွွသ္မာတ် ၑာကာတ် ဗၖဟဒ် ဘဝတိ; သ တာဒၖၑသ္တရု ရ္ဘဝတိ, ယသျ ၑာခါသု နဘသး ခဂါ အာဂတျ နိဝသန္တိ; သွရ္ဂီယရာဇျံ တာဒၖၑသျ သရ္ၐပဲကသျ သမမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ပုနရပိ သ ဥပမာကထာမေကာံ တေဘျး ကထယာဉ္စကာရ; ကာစန ယောၐိတ် ယတ် ကိဏွမာဒါယ ဒြောဏတြယမိတဂေါဓူမစူရ္ဏာနာံ မဓျေ သရွွေၐာံ မိၑြီဘဝနပရျျန္တံ သမာစ္ဆာဒျ နိဓတ္တဝတီ, တတ္ကိဏွမိဝ သွရ္ဂရာဇျံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ဣတ္ထံ ယီၑု ရ္မနုဇနိဝဟာနာံ သန္နိဓာဝုပမာကထာဘိရေတာနျာချာနာနိ ကထိတဝါန် ဥပမာံ ဝိနာ တေဘျး ကိမပိ ကထာံ နာကထယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ဧတေန ဒၖၐ္ဋာန္တီယေန ဝါကျေန ဝျာဒါယ ဝဒနံ နိဇံ၊ အဟံ ပြကာၑယိၐျာမိ ဂုပ္တဝါကျံ ပုရာဘဝံ၊ ယဒေတဒွစနံ ဘဝိၐျဒွါဒိနာ ပြောက္တမာသီတ်, တတ် သိဒ္ဓမဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","သရွွာန် မနုဇာန် ဝိသၖဇျ ယီၑော် ဂၖဟံ ပြဝိၐ္ဋေ တစ္ဆိၐျာ အာဂတျ ယီၑဝေ ကထိတဝန္တး, က္ၐေတြသျ ဝနျယဝသီယဒၖၐ္ဋာန္တကထာမ် ဘဝါန အသ္မာန် သ္ပၐ္ဋီကၖတျ ဝဒတု၊ ");
INSERT INTO sanbur_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","တတး သ ပြတျုဝါစ, ယေန ဘဒြဗီဇာနျုပျန္တေ သ မနုဇပုတြး, ");
INSERT INTO sanbur_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","က္ၐေတြံ ဇဂတ်, ဘဒြဗီဇာနီ ရာဇျသျ သန္တာနား, ");
INSERT INTO sanbur_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ဝနျယဝသာနိ ပါပါတ္မနး သန္တာနား၊ ယေန ရိပုဏာ တာနျုပ္တာနိ သ ၑယတာနး, ကရ္တ္တနသမယၑ္စ ဇဂတး ၑေၐး, ကရ္တ္တကား သွရ္ဂီယဒူတား၊ ");
INSERT INTO sanbur_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","ယထာ ဝနျယဝသာနိ သံဂၖဟျ ဒါဟျန္တေ, တထာ ဇဂတး ၑေၐေ ဘဝိၐျတိ; ");
INSERT INTO sanbur_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","အရ္ထာတ် မနုဇသုတး သွာံယဒူတာန် ပြေၐယိၐျတိ, တေန တေ စ တသျ ရာဇျာတ် သရွွာန် ဝိဃ္နကာရိဏော'ဓာရ္မ္မိကလောကာံၑ္စ သံဂၖဟျ ");
INSERT INTO sanbur_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ယတြ ရောဒနံ ဒန္တဃရ္ၐဏဉ္စ ဘဝတိ, တတြာဂ္နိကုဏ္ဍေ နိက္ၐေပ္သျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","တဒါနီံ ဓာရ္မ္မိကလောကား သွေၐာံ ပိတူ ရာဇျေ ဘာသ္ကရဣဝ တေဇသွိနော ဘဝိၐျန္တိ၊ ၑြောတုံ ယသျ ၑြုတီ အာသာတေ, မ ၑၖဏုယာတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","အပရဉ္စ က္ၐေတြမဓျေ နိဓိံ ပၑျန် ယော ဂေါပယတိ, တတး ပရံ သာနန္ဒော ဂတွာ သွီယသရွွသွံ ဝိကြီယ တ္တက္ၐေတြံ ကြီဏာတိ, သ ဣဝ သွရ္ဂရာဇျံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","အနျဉ္စ ယော ဝဏိက် ဥတ္တမာံ မုက္တာံ ဂဝေၐယန္ ");
INSERT INTO sanbur_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","မဟာရ္ဃာံ မုက္တာံ ဝိလောကျ နိဇသရွွသွံ ဝိကြီယ တာံ ကြီဏာတိ, သ ဣဝ သွရ္ဂရာဇျံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","ပုနၑ္စ သမုဒြော နိက္ၐိပ္တး သရွွပြကာရမီနသံဂြာဟျာနာယဣဝ သွရ္ဂရာဇျံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","တသ္မိန် အာနာယေ ပူရ္ဏေ ဇနာ ယထာ ရောဓသျုတ္တောလျ သမုပဝိၑျ ပြၑသ္တမီနာန် သံဂြဟျ ဘာဇနေၐု နိဒဓတေ, ကုတ္သိတာန် နိက္ၐိပန္တိ; ");
INSERT INTO sanbur_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","တထဲဝ ဇဂတး ၑေၐေ ဘဝိၐျတိ, ဖလတး သွရ္ဂီယဒူတာ အာဂတျ ပုဏျဝဇ္ဇနာနာံ မဓျာတ် ပါပိနး ပၖထက် ကၖတွာ ဝဟ္နိကုဏ္ဍေ နိက္ၐေပ္သျန္တိ, ");
INSERT INTO sanbur_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","တတြ ရောဒနံ ဒန္တဲ ရ္ဒန္တဃရ္ၐဏဉ္စ ဘဝိၐျတး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","ယီၑုနာ တေ ပၖၐ္ဋာ ယုၐ္မာဘိး ကိမေတာနျာချာနာနျဗုဓျန္တ? တဒါ တေ ပြတျဝဒန်, သတျံ ပြဘော၊ ");
INSERT INTO sanbur_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","တဒါနီံ သ ကထိတဝါန်, နိဇဘာဏ္ဍာဂါရာတ် နဝီနပုရာတနာနိ ဝသ္တူနိ နိရ္ဂမယတိ ယော ဂၖဟသ္ထး သ ဣဝ သွရ္ဂရာဇျမဓိ ၑိက္ၐိတား သွရွ ဥပဒေၐ္ဋာရး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","အနန္တရံ ယီၑုရေတား သရွွာ ဒၖၐ္ဋာန္တကထား သမာပျ တသ္မာတ် သ္ထာနာတ် ပြတသ္ထေ၊ အပရံ သွဒေၑမာဂတျ ဇနာန် ဘဇနဘဝန ဥပဒိၐ္ဋဝါန်; ");
INSERT INTO sanbur_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","တေ ဝိသ္မယံ ဂတွာ ကထိတဝန္တ ဧတသျဲတာဒၖၑံ ဇ္ဉာနမ် အာၑ္စရျျံ ကရ္မ္မ စ ကသ္မာဒ် အဇာယတ? ");
INSERT INTO sanbur_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","ကိမယံ သူတြဓာရသျ ပုတြော နဟိ? ဧတသျ မာတု ရ္နာမ စ ကိံ မရိယမ် နဟိ? ယာကုဗ်-ယူၐဖ်-ၑိမောန်-ယိဟူဒါၑ္စ ကိမေတသျ ဘြာတရော နဟိ? ");
INSERT INTO sanbur_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ဧတသျ ဘဂိနျၑ္စ ကိမသ္မာကံ မဓျေ န သန္တိ? တရှိ ကသ္မာဒယမေတာနိ လဗ္ဓဝါန်? ဣတ္ထံ သ တေၐာံ ဝိဃ္နရူပေါ ဗဘူဝ; ");
INSERT INTO sanbur_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","တတော ယီၑုနာ နိဂဒိတံ သွဒေၑီယဇနာနာံ မဓျံ ဝိနာ ဘဝိၐျဒွါဒီ ကုတြာပျနျတြ နာသမ္မာနျော ဘဝတီ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","တေၐာမဝိၑွာသဟေတေား သ တတြ သ္ထာနေ ဗဟွာၑ္စရျျကရ္မ္မာဏိ န ကၖတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","တဒါနီံ ရာဇာ ဟေရောဒ် ယီၑော ရျၑး ၑြုတွာ နိဇဒါသေယာန် ဇဂါဒ်, ");
INSERT INTO sanbur_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ဧၐ မဇ္ဇယိတာ ယောဟန်, ပြမိတေဘယသ္တသျောတ္ထာနာတ် တေနေတ္ထမဒ္ဘုတံ ကရ္မ္မ ပြကာၑျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","ပုရာ ဟေရောဒ် နိဇဘြာတု: ဖိလိပေါ ဇာယာယာ ဟေရောဒီယာယာ အနုရောဓာဒ် ယောဟနံ ဓာရယိတွာ ဗဒ္ဓါ ကာရာယာံ သ္ထာပိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ယတော ယောဟန် ဥက္တဝါန်, ဧတ္သယား သံဂြဟော ဘဝတော နောစိတး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","တသ္မာတ် နၖပတိသ္တံ ဟန္တုမိစ္ဆန္နပိ လောကေဘျော ဝိဘယာဉ္စကာရ; ယတး သရွွေ ယောဟနံ ဘဝိၐျဒွါဒိနံ မေနိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","ကိန္တု ဟေရောဒေါ ဇန္မာဟီယမဟ ဥပသ္ထိတေ ဟေရောဒီယာယာ ဒုဟိတာ တေၐာံ သမက္ၐံ နၖတိတွာ ဟေရောဒမပြီဏျတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","တသ္မာတ် ဘူပတိး ၑပထံ ကုရွွန် ဣတိ ပြတျဇ္ဉာသီတ်, တွယာ ယဒ် ယာစျတေ, တဒေဝါဟံ ဒါသျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","သာ ကုမာရီ သွီယမာတုး ၑိက္ၐာံ လဗ္ဓာ ဗဘာၐေ, မဇ္ဇယိတုရျောဟန ဥတ္တမာင်္ဂံ ဘာဇနေ သမာနီယ မဟျံ ဝိၑြာဏယ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","တတော ရာဇာ ၑုၑောစ, ကိန္တု ဘောဇနာယောပဝိၑတာံ သင်္ဂိနာံ သွကၖတၑပထသျ စာနုရောဓာတ် တတ် ပြဒါတုမ အာဒိဒေၑ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ပၑ္စာတ် ကာရာံ ပြတိ နရံ ပြဟိတျ ယောဟန ဥတ္တမာင်္ဂံ ဆိတ္တွာ ");
INSERT INTO sanbur_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","တတ် ဘာဇန အာနာယျ တသျဲ ကုမာရျျဲ ဝျၑြာဏယတ်, တတး သာ သွဇနနျား သမီပံ တန္နိနာယ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ပၑ္စာတ် ယောဟနး ၑိၐျာ အာဂတျ ကာယံ နီတွာ ၑ္မၑာနေ သ္ထာပယာမာသုသ္တတော ယီၑေား သန္နိဓိံ ဝြဇိတွာ တဒွါရ္တ္တာံ ဗဘာၐိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","အနန္တရံ ယီၑုရိတိ နိၑဘျ နာဝါ နိရ္ဇနသ္ထာနမ် ဧကာကီ ဂတဝါန်, ပၑ္စာတ် မာနဝါသ္တတ် ၑြုတွာ နာနာနဂရေဘျ အာဂတျ ပဒဲသ္တတ္ပၑ္စာဒ် ဤယုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","တဒါနီံ ယီၑု ရ္ဗဟိရာဂတျ မဟာန္တံ ဇနနိဝဟံ နိရီက္ၐျ တေၐု ကာရုဏိကး မန် တေၐာံ ပီဍိတဇနာန် နိရာမယာန် စကာရ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","တတး ပရံ သန္ဓျာယာံ ၑိၐျာသ္တဒန္တိကမာဂတျ ကထယာဉ္စကြုး, ဣဒံ နိရ္ဇနသ္ထာနံ ဝေလာပျဝသန္နာ; တသ္မာတ် မနုဇာန် သွသွဂြာမံ ဂန္တုံ သွာရ္ထံ ဘက္ၐျာဏိ ကြေတုဉ္စ ဘဝါန် တာန် ဝိသၖဇတု၊ ");
INSERT INTO sanbur_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","ကိန္တု ယီၑုသ္တာနဝါဒီတ်, တေၐာံ ဂမနေ ပြယောဇနံ နာသ္တိ, ယူယမေဝ တာန် ဘောဇယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","တဒါ တေ ပြတျဝဒန်, အသ္မာကမတြ ပူပပဉ္စကံ မီနဒွယဉ္စာသ္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","တဒါနီံ တေနောက္တံ တာနိ မဒန္တိကမာနယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","အနန္တရံ သ မနုဇာန် ယဝသောပရျျုပဝေၐ္ဋုမ် အာဇ္ဉာပယာမာသ; အပရ တတ် ပူပပဉ္စကံ မီနဒွယဉ္စ ဂၖဟ္လန် သွရ္ဂံ ပြတိ နိရီက္ၐျေၑွရီယဂုဏာန် အနူဒျ ဘံက္တွာ ၑိၐျေဘျော ဒတ္တဝါန်, ၑိၐျာၑ္စ လောကေဘျော ဒဒုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","တတး သရွွေ ဘုက္တွာ ပရိတၖပ္တဝန္တး, တတသ္တဒဝၑိၐ္ဋဘက္ၐျဲး ပူရ္ဏာန် ဒွါဒၑဍလကာန် ဂၖဟီတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","တေ ဘောက္တာရး သ္တြီရ္ဗာလကာံၑ္စ ဝိဟာယ ပြာယေဏ ပဉ္စ သဟသြာဏိ ပုမာံသ အာသန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","တဒနန္တရံ ယီၑု ရ္လောကာနာံ ဝိသရ္ဇနကာလေ ၑိၐျာန် တရဏိမာရောဎုံ သွာဂြေ ပါရံ ယာတုဉ္စ ဂါဎမာဒိၐ္ဋဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","တတော လောကေၐု ဝိသၖၐ္ဋေၐု သ ဝိဝိက္တေ ပြာရ္ထယိတုံ ဂိရိမေကံ ဂတွာ သန္ဓျာံ ယာဝတ် တတြဲကာကီ သ္ထိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ကိန္တု တဒါနီံ သမ္မုခဝါတတွာတ် သရိတ္ပတေ ရ္မဓျေ တရင်္ဂဲသ္တရဏိရ္ဒောလာယမာနာဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","တဒါ သ ယာမိနျာၑ္စတုရ္ထပြဟရေ ပဒ္ဘျာံ ဝြဇန် တေၐာမန္တိကံ ဂတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ကိန္တု ၑိၐျာသ္တံ သာဂရောပရိ ဝြဇန္တံ ဝိလောကျ သမုဒွိဂ္နာ ဇဂဒုး, ဧၐ ဘူတ ဣတိ ၑင်္ကမာနာ ဥစ္စဲး ၑဗ္ဒာယာဉ္စကြိရေ စ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","တဒဲဝ ယီၑုသ္တာနဝဒတ်, သုသ္ထိရာ ဘဝတ, မာ ဘဲၐ္ဋ, ဧၐော'ဟမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","တတး ပိတရ ဣတျုက္တဝါန်, ဟေ ပြဘော, ယဒိ ဘဝါနေဝ, တရှိ မာံ ဘဝတ္သမီပံ ယာတုမာဇ္ဉာပယတု၊ ");
INSERT INTO sanbur_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","တတး တေနာဒိၐ္ဋး ပိတရသ္တရဏိတော'ဝရုဟျ ယီၑေाရန္တိကံ ပြာပ္တုံ တောယောပရိ ဝဝြာဇ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","ကိန္တု ပြစဏ္ဍံ ပဝနံ ဝိလောကျ ဘယာတ် တောယေ မံက္တုမ် အာရေဘေ, တသ္မာဒ် ဥစ္စဲး ၑဗ္ဒာယမာနး ကထိတဝါန်, ဟေ ပြဘော, မာမဝတု၊ ");
INSERT INTO sanbur_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ယီၑုသ္တတ္က္ၐဏာတ် ကရံ ပြသာရျျ တံ ဓရန် ဥက္တဝါန်, ဟ သ္တောကပြတျယိန် တွံ ကုတး သမၑေထား? ");
INSERT INTO sanbur_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","အနန္တရံ တယောသ္တရဏိမာရူဎယေား ပဝနော နိဝဝၖတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","တဒါနီံ ယေ တရဏျာမာသန်, တ အာဂတျ တံ ပြဏဘျ ကထိတဝန္တး, ယထာရ္ထသ္တွမေဝေၑွရသုတး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","အနန္တရံ ပါရံ ပြာပျ တေ ဂိနေၐရန္နာမကံ နဂရမုပတသ္ထုး, ");
INSERT INTO sanbur_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","တဒါ တတြတျာ ဇနာ ယီၑုံ ပရိစီယ တဒ္ဒေၑ္သျ စတုရ္ဒိၑော ဝါရ္တ္တာံ ပြဟိတျ ယတြ ယာဝန္တး ပီဍိတာ အာသန်, တာဝတဧဝ တဒန္တိကမာနယာမာသုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","အပရံ တဒီယဝသနသျ ဂြန္ထိမာတြံ သ္ပြၐ္ဋုံ ဝိနီယ ယာဝန္တော ဇနာသ္တတ် သ္ပရ္ၑံ စကြိရေ, တေ သရွွဧဝ နိရာမယာ ဗဘူဝုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","အပရံ ယိရူၑာလမ္နဂရီယား ကတိပယာ အဓျာပကား ဖိရူၑိနၑ္စ ယီၑေား သမီပမာဂတျ ကထယာမာသုး, ");
INSERT INTO sanbur_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","တဝ ၑိၐျား ကိမရ္ထမ် အပြက္ၐာလိတကရဲ ရ္ဘက္ၐိတွာ ပရမ္ပရာဂတံ ပြာစီနာနာံ ဝျဝဟာရံ လငွန္တေ? ");
INSERT INTO sanbur_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","တတော ယီၑုး ပြတျုဝါစ, ယူယံ ပရမ္ပရာဂတာစာရေဏ ကုတ ဤၑွရာဇ္ဉာံ လငွဓွေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ဤၑွရ ဣတျာဇ္ဉာပယတ်, တွံ နိဇပိတရော် သံမနျေထား, ယေန စ နိဇပိတရော် နိန္ဒျေတေ, သ နိၑ္စိတံ မြိယေတ; ");
INSERT INTO sanbur_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","ကိန္တု ယူယံ ဝဒထ, ယး သွဇနကံ သွဇနနီံ ဝါ ဝါကျမိဒံ ဝဒတိ, ယုဝါံ မတ္တော ယလ္လဘေထေ, တတ် နျဝိဒျတ, ");
INSERT INTO sanbur_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","သ နိဇပိတရော် ပုန ရ္န သံမံသျတေ၊ ဣတ္ထံ ယူယံ ပရမ္ပရာဂတေန သွေၐာမာစာရေဏေၑွရီယာဇ္ဉာံ လုမ္ပထ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ရေ ကပဋိနး သရွွေ ယိၑယိယော ယုၐ္မာနဓိ ဘဝိၐျဒွစနာနျေတာနိ သမျဂ် ဥက္တဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","ဝဒနဲ ရ္မနုဇာ ဧတေ သမာယာန္တိ မဒန္တိကံ၊ တထာဓရဲ ရ္မဒီယဉ္စ မာနံ ကုရွွန္တိ တေ နရား၊ ");
INSERT INTO sanbur_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ကိန္တု တေၐာံ မနော မတ္တော ဝိဒူရဧဝ တိၐ္ဌတိ၊ ၑိက္ၐယန္တော ဝိဓီန် နြာဇ္ဉာ ဘဇန္တေ မာံ မုဓဲဝ တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","တတော ယီၑု ရ္လောကာန် အာဟူယ ပြောက္တဝါန်, ယူယံ ၑြုတွာ ဗုဓျဓ္ဗံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ယန္မုခံ ပြဝိၑတိ, တတ် မနုဇမ် အမေဓျံ န ကရောတိ, ကိန္တု ယဒါသျာတ် နိရ္ဂစ္ဆတိ, တဒေဝ မာနုၐမမေဓျီ ကရောတီ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","တဒါနီံ ၑိၐျာ အာဂတျ တသ္မဲ ကထယာဉ္စကြုး, ဧတာံ ကထာံ ၑြုတွာ ဖိရူၑိနော ဝျရဇျန္တ, တတ် ကိံ ဘဝတာ ဇ္ဉာယတေ? ");
INSERT INTO sanbur_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","သ ပြတျဝဒတ်, မမ သွရ္ဂသ္ထး ပိတာ ယံ ကဉ္စိဒင်္ကုရံ နာရောပယတ်, သ ဥတ္ပာဝ္ဒျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","တေ တိၐ္ဌန္တု, တေ အန္ဓမနုဇာနာမ် အန္ဓမာရ္ဂဒရ္ၑကာ ဧဝ; ယဒျန္ဓော'န္ဓံ ပန္ထာနံ ဒရ္ၑယတိ, တရှျုဘော် ဂရ္တ္တေ ပတတး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","တဒါ ပိတရသ္တံ ပြတျဝဒတ်, ဒၖၐ္ဋာန္တမိမမသ္မာန် ဗောဓယတု၊ ");
INSERT INTO sanbur_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ယီၑုနာ ပြောက္တံ, ယူယမဒျ ယာဝတ် ကိမဗောဓား သ္ထ? ");
INSERT INTO sanbur_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","ကထာမိမာံ ကိံ န ဗုဓျဓ္ဗေ ? ယဒါသျံ ပြေဝိၑတိ, တဒ် ဥဒရေ ပတန် ဗဟိရ္နိရျာတိ, ");
INSERT INTO sanbur_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","ကိန္တွာသျာဒ် ယန္နိရျာတိ, တဒ် အန္တးကရဏာတ် နိရျာတတွာတ် မနုဇမမေဓျံ ကရောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","ယတော'န္တးကရဏာတ် ကုစိန္တာ ဗဓး ပါရဒါရိကတာ ဝေၑျာဂမနံ စဲရျျံ မိထျာသာက္ၐျမ် ဤၑွရနိန္ဒာ စဲတာနိ သရွွာဏိ နိရျျာန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ဧတာနိ မနုၐျမပဝိတြီ ကုရွွန္တိ ကိန္တွပြက္ၐာလိတကရေဏ ဘောဇနံ မနုဇမမေဓျံ န ကရောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","အနန္တရံ ယီၑုသ္တသ္မာတ် သ္ထာနာတ် ပြသ္ထာယ သောရသီဒေါန္နဂရယေား သီမာမုပတသျော်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","တဒါ တတ္သီမာတး ကာစိတ် ကိနာနီယာ ယောၐိဒ် အာဂတျ တမုစ္စဲရုဝါစ, ဟေ ပြဘော ဒါယူဒး သန္တာန, မမဲကာ ဒုဟိတာသ္တေ သာ ဘူတဂြသ္တာ သတီ မဟာက္လေၑံ ပြာပ္နောတိ မမ ဒယသွ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","ကိန္တု ယီၑုသ္တာံ ကိမပိ နောက္တဝါန်, တတး ၑိၐျာ အာဂတျ တံ နိဝေဒယာမာသုး, ဧၐာ ယောၐိဒ် အသ္မာကံ ပၑ္စာဒ် ဥစ္စဲရာဟူယာဂစ္ဆတိ, ဧနာံ ဝိသၖဇတု၊ ");
INSERT INTO sanbur_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","တဒါ သ ပြတျဝဒတ်, ဣသြာယေလ္ဂောတြသျ ဟာရိတမေၐာန် ဝိနာ ကသျာပျနျသျ သမီပံ နာဟံ ပြေၐိတောသ္မိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","တတး သာ နာရီသမာဂတျ တံ ပြဏမျ ဇဂါဒ, ဟေ ပြဘော မာမုပကုရု၊ ");
INSERT INTO sanbur_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","သ ဥက္တဝါန်, ဗာလကာနာံ ဘက္ၐျမာဒါယ သာရမေယေဘျော ဒါနံ နောစိတံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","တဒါ သာ ဗဘာၐေ, ဟေ ပြဘော, တတ် သတျံ, တထာပိ ပြဘော ရ္ဘဉ္စာဒ် ယဒုစ္ဆိၐ္ဋံ ပတတိ, တတ် သာရမေယား ခါဒန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","တတော ယီၑုး ပြတျဝဒတ်, ဟေ ယောၐိတ်, တဝ ဝိၑွာသော မဟာန် တသ္မာတ် တဝ မနောဘိလၐိတံ သိဒျျတု, တေန တသျား ကနျာ တသ္မိန္နေဝ ဒဏ္ဍေ နိရာမယာဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","အနန္တရံ ယီၑသ္တသ္မာတ် သ္ထာနာတ် ပြသ္ထာယ ဂါလီလ္သာဂရသျ သန္နိဓိမာဂတျ ဓရာဓရမာရုဟျ တတြောပဝိဝေၑ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ပၑ္စာတ် ဇနနိဝဟော ဗဟူန် ခဉ္စာန္ဓမူကၑုၐ္ကကရမာနုၐာန် အာဒါယ ယီၑေား သမီပမာဂတျ တစ္စရဏာန္တိကေ သ္ထာပယာမာသုး, တတး သာ တာန် နိရာမယာန် အကရောတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ဣတ္ထံ မူကာ ဝါကျံ ဝဒန္တိ, ၑုၐ္ကကရား သွာသ္ထျမာယာန္တိ, ပင်္ဂဝေါ ဂစ္ဆန္တိ, အန္ဓာ ဝီက္ၐန္တေ, ဣတိ ဝိလောကျ လောကာ ဝိသ္မယံ မနျမာနာ ဣသြာယေလ ဤၑွရံ ဓနျံ ဗဘာၐိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","တဒါနီံ ယီၑုး သွၑိၐျာန် အာဟူယ ဂဒိတဝါန်, ဧတဇ္ဇနနိဝဟေၐု မမ ဒယာ ဇာယတေ, ဧတေ ဒိနတြယံ မယာ သာကံ သန္တိ, ဧၐာံ ဘက္ၐျဝသ္တု စ ကဉ္စိဒပိ နာသ္တိ, တသ္မာဒဟမေတာနကၖတာဟာရာန် န ဝိသြက္ၐျာမိ, တထာတွေ ဝရ္တ္မမဓျေ က္လာမျေၐုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","တဒါ ၑိၐျာ ဦစုး, ဧတသ္မိန် ပြာန္တရမဓျ ဧတာဝတော မရ္တျာန် တရ္ပယိတုံ ဝယံ ကုတြ ပူပါန် ပြာပ္သျာမး? ");
INSERT INTO sanbur_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ယီၑုရပၖစ္ဆတ်, ယုၐ္မာကံ နိကဋေ ကတိ ပူပါ အာသတေ? တ ဦစုး, သပ္တပူပါ အလ္ပား က္ၐုဒြမီနာၑ္စ သန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","တဒါနီံ သ လောကနိဝဟံ ဘူမာဝုပဝေၐ္ဋုမ် အာဒိၑျ ");
INSERT INTO sanbur_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","တာန် သပ္တပူပါန် မီနာံၑ္စ ဂၖဟ္လန် ဤၑွရီယဂုဏာန် အနူဒျ ဘံက္တွာ ၑိၐျေဘျော ဒဒေါ်, ၑိၐျာ လောကေဘျော ဒဒုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","တတး သရွွေ ဘုက္တွာ တၖပ္တဝန္တး; တဒဝၑိၐ္ဋဘက္ၐျေဏ သပ္တဍလကာန် ပရိပူရျျ သံဇဂၖဟုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","တေ ဘောက္တာရော ယောၐိတော ဗာလကာံၑ္စ ဝိဟာယ ပြာယေဏ စတုးသဟသြာဏိ ပုရုၐာ အာသန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","တတး ပရံ သ ဇနနိဝဟံ ဝိသၖဇျ တရိမာရုဟျ မဂ္ဒလာပြဒေၑံ ဂတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","တဒါနီံ ဖိရူၑိနး သိဒူကိနၑ္စာဂတျ တံ ပရီက္ၐိတုံ နဘမီယံ ကိဉ္စန လက္ၐ္မ ဒရ္ၑယိတုံ တသ္မဲ နိဝေဒယာမာသုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","တတး သ ဥက္တဝါန်, သန္ဓျာယာံ နဘသော ရက္တတွာဒ် ယူယံ ဝဒထ, ၑွော နိရ္မ္မလံ ဒိနံ ဘဝိၐျတိ; ");
INSERT INTO sanbur_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ပြာတးကာလေ စ နဘသော ရက္တတွာတ် မလိနတွာဉ္စ ဝဒထ, ဈဉ္ဘ္ၑဒျ ဘဝိၐျတိ၊ ဟေ ကပဋိနော ယဒိ ယူယမ် အန္တရီက္ၐသျ လက္ၐ္မ ဗောဒ္ဓုံ ၑက္နုထ, တရှိ ကာလသျဲတသျ လက္ၐ္မ ကထံ ဗောဒ္ဓုံ န ၑက္နုထ? ");
INSERT INTO sanbur_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ဧတတ္ကာလသျ ဒုၐ္ဋော ဝျဘိစာရီ စ ဝံၑော လက္ၐ္မ ဂဝေၐယတိ, ကိန္တု ယူနသော ဘဝိၐျဒွါဒိနော လက္ၐ္မ ဝိနာနျတ် ကိမပိ လက္ၐ္မ တာန် န ဒရ္ၑယိယျတေ၊ တဒါနီံ သ တာန် ဝိဟာယ ပြတသ္ထေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","အနန္တရမနျပါရဂမနကာလေ တသျ ၑိၐျား ပူပမာနေတုံ ဝိသ္မၖတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ယီၑုသ္တာနဝါဒီတ်, ယူယံ ဖိရူၑိနာံ သိဒူကိနာဉ္စ ကိဏွံ ပြတိ သာဝဓာနား သတရ္ကာၑ္စ ဘဝတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","တေန တေ ပရသ္ပရံ ဝိဝိစျ ကထယိတုမာရေဘိရေ, ဝယံ ပူပါနာနေတုံ ဝိသ္မၖတဝန္တ ဧတတ္ကာရဏာဒ် ဣတိ ကထယတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","ကိန္တု ယီၑုသ္တဒွိဇ္ဉာယ တာနဝေါစတ်, ဟေ သ္တောကဝိၑွာသိနော ယူယံ ပူပါနာနယနမဓိ ကုတး ပရသ္ပရမေတဒ် ဝိဝိံကျ? ");
INSERT INTO sanbur_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","ယုၐ္မာဘိး ကိမဒျာပိ န ဇ္ဉာယတေ? ပဉ္စဘိး ပူပဲး ပဉ္စသဟသြပုရုၐေၐု ဘောဇိတေၐု ဘက္ၐျောစ္ဆိၐ္ဋပူရ္ဏာန် ကတိ ဍလကာန် သမဂၖဟ္လီတံ; ");
INSERT INTO sanbur_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","တထာ သပ္တဘိး ပူပဲၑ္စတုးသဟသြပုရုၐေၐု ဘေဇိတေၐု ကတိ ဍလကာန် သမဂၖဟ္လီတ, တတ် ကိံ ယုၐ္မာဘိရ္န သ္မရျျတေ? ");
INSERT INTO sanbur_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","တသ္မာတ် ဖိရူၑိနာံ သိဒူကိနာဉ္စ ကိဏွံ ပြတိ သာဝဓာနာသ္တိၐ္ဌတ, ကထာမိမာမ် အဟံ ပူပါနဓိ နာကထယံ, ဧတဒ် ယူယံ ကုတော န ဗုဓျဓွေ? ");
INSERT INTO sanbur_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","တဒါနီံ ပူပကိဏွံ ပြတိ သာဝဓာနာသ္တိၐ္ဌတေတိ နောက္တွာ ဖိရူၑိနာံ သိဒူကိနာဉ္စ ဥပဒေၑံ ပြတိ သာဝဓာနာသ္တိၐ္ဌတေတိ ကထိတဝါန်, ဣတိ တဲရဗောဓိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","အပရဉ္စ ယီၑုး ကဲသရိယာ-ဖိလိပိပြဒေၑမာဂတျ ၑိၐျာန် အပၖစ္ဆတ်, ယော'ဟံ မနုဇသုတး သော'ဟံ ကး? လောကဲရဟံ ကိမုစျေ? ");
INSERT INTO sanbur_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","တဒါနီံ တေ ကထိတဝန္တး, ကေစိဒ် ဝဒန္တိ တွံ မဇ္ဇယိတာ ယောဟန်, ကေစိဒွဒန္တိ, တွမ် ဧလိယး, ကေစိစ္စ ဝဒန္တိ, တွံ ယိရိမိယော ဝါ ကၑ္စိဒ် ဘဝိၐျဒွါဒီတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","ပၑ္စာတ် သ တာန် ပပြစ္ဆ, ယူယံ မာံ ကံ ဝဒထ? တတး ၑိမောန် ပိတရ ဥဝါစ, ");
INSERT INTO sanbur_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","တွမမရေၑွရသျာဘိၐိက္တပုတြး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","တတော ယီၑုး ကထိတဝါန်, ဟေ ယူနသး ပုတြ ၑိမောန် တွံ ဓနျး; ယတး ကောပိ အနုဇသ္တွယျေတဇ္ဇ္ဉာနံ နောဒပါဒယတ်, ကိန္တု မမ သွရ္ဂသျး ပိတောဒပါဒယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","အတော'ဟံ တွာံ ဝဒါမိ, တွံ ပိတရး (ပြသ္တရး) အဟဉ္စ တသျ ပြသ္တရသျောပရိ သွမဏ္ဍလီံ နိရ္မ္မာသျာမိ, တေန နိရယော ဗလာတ် တာံ ပရာဇေတုံ န ၑက္ၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","အဟံ တုဘျံ သွရ္ဂီယရာဇျသျ ကုဉ္ဇိကာံ ဒါသျာမိ, တေန ယတ် ကိဉ္စန တွံ ပၖထိဝျာံ ဘံတ္သျသိ တတ္သွရ္ဂေ ဘံတ္သျတေ, ယစ္စ ကိဉ္စန မဟျာံ မောက္ၐျသိ တတ် သွရ္ဂေ မောက္ၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","ပၑ္စာတ် သ ၑိၐျာနာဒိၑတ်, အဟမဘိၐိက္တော ယီၑုရိတိ ကထာံ ကသ္မဲစိဒပိ ယူယံ မာ ကထယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","အနျဉ္စ ယိရူၑာလမ္နဂရံ ဂတွာ ပြာစီနလောကေဘျး ပြဓာနယာဇကေဘျ ဥပါဓျာယေဘျၑ္စ ဗဟုဒုးခဘောဂသ္တဲ ရှတတွံ တၖတီယဒိနေ ပုနရုတ္ထာနဉ္စ မမာဝၑျကမ် ဧတား ကထာ ယီၑုသ္တတ္ကာလမာရဘျ ၑိၐျာန် ဇ္ဉာပယိတုမ် အာရဗ္ဓဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","တဒါနီံ ပိတရသ္တသျ ကရံ ဃၖတွာ တရ္ဇယိတွာ ကထယိတုမာရဗ္ဓဝါန်, ဟေ ပြဘော, တတ် တွတ္တော ဒူရံ ယာတု, တွာံ ပြတိ ကဒါပိ န ဃဋိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ကိန္တု သ ဝဒနံ ပရာဝရ္တျ ပိတရံ ဇဂါဒ, ဟေ ဝိဃ္နကာရိန်, မတ္သမ္မုခါဒ် ဒူရီဘဝ, တွံ မာံ ဗာဓသေ, ဤၑွရီယကာရျျာတ် မာနုၐီယကာရျျံ တုဘျံ ရောစတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","အနန္တရံ ယီၑုး သွီယၑိၐျာန် ဥက္တဝါန် ယး ကၑ္စိတ် မမ ပၑ္စာဒ္ဂါမီ ဘဝိတုမ် ဣစ္ဆတိ, သ သွံ ဒါမျတု, တထာ သွကြုၑံ ဂၖဟ္လန် မတ္ပၑ္စာဒါယာတု၊ ");
INSERT INTO sanbur_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","ယတော ယး ပြာဏာန် ရက္ၐိတုမိစ္ဆတိ, သ တာန် ဟာရယိၐျတိ, ကိန္တု ယော မဒရ္ထံ နိဇပြာဏာန် ဟာရယတိ, သ တာန် ပြာပ္သျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","မာနုၐော ယဒိ သရွွံ ဇဂတ် လဘတေ နိဇပြဏာန် ဟာရယတိ, တရှိ တသျ ကော လာဘး? မနုဇော နိဇပြာဏာနာံ ဝိနိမယေန ဝါ ကိံ ဒါတုံ ၑက္နောတိ? ");
INSERT INTO sanbur_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","မနုဇသုတး သွဒူတဲး သာကံ ပိတုး ပြဘာဝေဏာဂမိၐျတိ; တဒါ ပြတိမနုဇံ သွသွကရ္မ္မာနုသာရာတ် ဖလံ ဒါသျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","အဟံ ယုၐ္မာန် တထျံ ဝစ္မိ, သရာဇျံ မနုဇသုတမ် အာဂတံ န ပၑျန္တော မၖတျုံ န သွာဒိၐျန္တိ, ဧတာဒၖၑား ကတိပယဇနာ အတြာပိ ဒဏ္ဍာယမာနား သန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","အနန္တရံ ၐဍ္ဒိနေဘျး ပရံ ယီၑုး ပိတရံ ယာကူဗံ တတ္သဟဇံ ယောဟနဉ္စ ဂၖဟ္လန် ဥစ္စာဒြေ ရွိဝိက္တသ္ထာနမ် အာဂတျ တေၐာံ သမက္ၐံ ရူပမနျတ် ဒဓာရ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","တေန တဒါသျံ တေဇသွိ, တဒါဘရဏမ် အာလောကဝတ် ပါဏ္ဍရမဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","အနျစ္စ တေန သာကံ သံလပန္တော် မူသာ ဧလိယၑ္စ တေဘျော ဒရ္ၑနံ ဒဒတုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","တဒါနီံ ပိတရော ယီၑုံ ဇဂါဒ, ဟေ ပြဘော သ္ထိတိရတြာသ္မာကံ ၑုဘာ, ယဒိ ဘဝတာနုမနျတေ, တရှိ ဘဝဒရ္ထမေကံ မူသာရ္ထမေကမ် ဧလိယာရ္ထဉ္စဲကမ် ဣတိ တြီဏိ ဒူၐျာဏိ နိရ္မ္မမ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ဧတတ္ကထနကာလ ဧက ဥဇ္ဇဝလး ပယောဒသ္တေၐာမုပရိ ဆာယာံ ကၖတဝါန်, ဝါရိဒါဒ် ဧၐာ နဘသီယာ ဝါဂ် ဗဘူဝ, မမာယံ ပြိယး ပုတြး, အသ္မိန် မမ မဟာသန္တောၐ ဧတသျ ဝါကျံ ယူယံ နိၑာမယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","ကိန္တု ဝါစမေတာံ ၑၖဏွန္တဧဝ ၑိၐျာ မၖၑံ ၑင်္ကမာနာ နျုဗ္ဇာ နျပတန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","တဒါ ယီၑုရာဂတျ တေၐာံ ဂါတြာဏိ သ္ပၖၑန် ဥဝါစ, ဥတ္တိၐ္ဌတ, မာ ဘဲၐ္ဋ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","တဒါနီံ နေတြာဏျုန္မီလျ ယီၑုံ ဝိနာ ကမပိ န ဒဒၖၑုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","တတး ပရမ် အဒြေရဝရောဟဏကာလေ ယီၑုသ္တာန် ဣတျာဒိဒေၑ, မနုဇသုတသျ မၖတာနာံ မဓျာဒုတ္ထာနံ ယာဝန္န ဇာယတေ, တာဝတ် ယုၐ္မာဘိရေတဒ္ဒရ္ၑနံ ကသ္မဲစိဒပိ န ကထယိတဝျံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","တဒါ ၑိၐျာသ္တံ ပပြစ္ဆုး, ပြထမမ် ဧလိယ အာယာသျတီတိ ကုတ ဥပါဓျာယဲရုစျတေ? ");
INSERT INTO sanbur_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","တတော ယီၑုး ပြတျဝါဒီတ်, ဧလိယး ပြာဂေတျ သရွွာဏိ သာဓယိၐျတီတိ သတျံ, ");
INSERT INTO sanbur_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","ကိန္တွဟံ ယုၐ္မာန် ဝစ္မိ, ဧလိယ ဧတျ ဂတး, တေ တမပရိစိတျ တသ္မိန် ယထေစ္ဆံ ဝျဝဇဟုး; မနုဇသုတေနာပိ တေၐာမန္တိကေ တာဒၖဂ် ဒုးခံ ဘောက္တဝျံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","တဒါနီံ သ မဇ္ဇယိတာရံ ယောဟနမဓိ ကထာမေတာံ ဝျာဟၖတဝါန်, ဣတ္ထံ တစ္ဆိၐျာ ဗုဗုဓိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","ပၑ္စာတ် တေၐု ဇနနိဝဟသျာန္တိကမာဂတေၐု ကၑ္စိတ် မနုဇသ္တဒန္တိကမေတျ ဇာနူနီ ပါတယိတွာ ကထိတဝါန်, ");
INSERT INTO sanbur_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ဟေ ပြဘော, မတ္ပုတြံ ပြတိ ကၖပါံ ဝိဒဓာတု, သောပသ္မာရာမယေန ဘၖၑံ ဝျထိတး သန် ပုနး ပုန ရွဟ္နော် မုဟု ရ္ဇလမဓျေ ပတတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","တသ္မာဒ် ဘဝတး ၑိၐျာဏာံ သမီပေ တမာနယံ ကိန္တု တေ တံ သွာသ္ထံ ကရ္တ္တုံ န ၑက္တား၊ ");
INSERT INTO sanbur_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","တဒါ ယီၑုး ကထိတဝါန် ရေ အဝိၑွာသိနး, ရေ ဝိပထဂါမိနး, ပုနး ကတိကာလာန် အဟံ ယုၐ္မာကံ သန္နိဓော် သ္ထာသျာမိ? ကတိကာလာန် ဝါ ယုၐ္မာန် သဟိၐျေ? တမတြ မမာန္တိကမာနယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ပၑ္စာဒ် ယီၑုနာ တရ္ဇတဧဝ သ ဘူတသ္တံ ဝိဟာယ ဂတဝါန်, တဒ္ဒဏ္ဍဧဝ သ ဗာလကော နိရာမယော'ဘူတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","တတး ၑိၐျာ ဂုပ္တံ ယီၑုမုပါဂတျ ဗဘာၐိရေ, ကုတော ဝယံ တံ ဘူတံ တျာဇယိတုံ န ၑက္တား? ");
INSERT INTO sanbur_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ယီၑုနာ တေ ပြောက္တား, ယုၐ္မာကမပြတျယာတ်; ");
INSERT INTO sanbur_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","ယုၐ္မာနဟံ တထျံ ဝစ္မိ ယဒိ ယုၐ္မာကံ သရ္ၐပဲကမာတြောပိ ဝိၑွာသော ဇာယတေ, တရှိ ယုၐ္မာဘိရသ္မိန် ၑဲလေ တွမိတး သ္ထာနာတ် တတ် သ္ထာနံ ယာဟီတိ ဗြူတေ သ တဒဲဝ စလိၐျတိ, ယုၐ္မာကံ ကိမပျသာဓျဉ္စ ကရ္မ္မ န သ္ထာသျာတိ၊ ကိန္တု ပြာရ္ထနောပဝါသော် ဝိနဲတာဒၖၑော ဘူတော န တျာဇျေတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","အပရံ တေၐာံ ဂါလီလ္ပြဒေၑေ ဘြမဏကာလေ ယီၑုနာ တေ ဂဒိတား, မနုဇသုတော ဇနာနာံ ကရေၐု သမရ္ပယိၐျတေ တဲ ရှနိၐျတေ စ, ");
INSERT INTO sanbur_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ကိန္တု တၖတီယေ'ဟိ्န မ ဥတ္ထာပိၐျတေ, တေန တေ ဘၖၑံ ဒုးခိတာ ဗဘူဝး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","တဒနန္တရံ တေၐု ကဖရ္နာဟူမ္နဂရမာဂတေၐု ကရသံဂြာဟိဏး ပိတရာန္တိကမာဂတျ ပပြစ္ဆုး, ယုၐ္မာကံ ဂုရုး ကိံ မန္ဒိရာရ္ထံ ကရံ န ဒဒါတိ? တတး ပိတရး ကထိတဝါန် ဒဒါတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","တတသ္တသ္မိန် ဂၖဟမဓျမာဂတေ တသျ ကထာကထနာတ် ပူရွွမေဝ ယီၑုရုဝါစ, ဟေ ၑိမောန်, မေဒိနျာ ရာဇာနး သွသွာပတျေဘျး ကိံ ဝိဒေၑိဘျး ကေဘျး ကရံ ဂၖဟ္လန္တိ? အတြ တွံ ကိံ ဗုဓျသေ? တတး ပိတရ ဥက္တဝါန်, ဝိဒေၑိဘျး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","တဒါ ယီၑုရုက္တဝါန်, တရှိ သန္တာနာ မုက္တား သန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","တထာပိ ယထာသ္မာဘိသ္တေၐာမန္တရာယော န ဇနျတေ, တတ္ကၖတေ ဇလဓေသ္တီရံ ဂတွာ ဝဍိၑံ က္ၐိပ, တေနာဒေါ် ယော မီန ဥတ္ထာသျတိ, တံ ဃၖတွာ တန္မုခေ မောစိတေ တောလကဲကံ ရူပျံ ပြာပ္သျသိ, တဒ် ဂၖဟီတွာ တဝ မမ စ ကၖတေ တေဘျော ဒေဟိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","တဒါနီံ ၑိၐျာ ယီၑေား သမီပမာဂတျ ပၖၐ္ဋဝန္တး သွရ္ဂရာဇျေ ကး ၑြေၐ္ဌး? ");
INSERT INTO sanbur_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","တတော ယီၑုး က္ၐုဒြမေကံ ဗာလကံ သွသမီပမာနီယ တေၐာံ မဓျေ နိဓာယ ဇဂါဒ, ");
INSERT INTO sanbur_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ယုၐ္မာနဟံ သတျံ ဗြဝီမိ, ယူယံ မနောဝိနိမယေန က္ၐုဒြဗာလဝတ် န သန္တး သွရ္ဂရာဇျံ ပြဝေၐ္ဋုံ န ၑက္နုထ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","ယး ကၑ္စိဒ် ဧတသျ က္ၐုဒြဗာလကသျ သမမာတ္မာနံ နမြီကရောတိ, သဧဝ သွရ္ဂရာဇယေ ၑြေၐ္ဌး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ယး ကၑ္စိဒ် ဧတာဒၖၑံ က္ၐုဒြဗာလကမေကံ မမ နာမ္နိ ဂၖဟ္လာတိ, သ မာမေဝ ဂၖဟ္လာတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","ကိန္တု ယော ဇနော မယိ ကၖတဝိၑွာသာနာမေတေၐာံ က္ၐုဒြပြာဏိနာမ် ဧကသျာပိ ဝိဓ္နိံ ဇနယတိ, ကဏ္ဌဗဒ္ဓပေၐဏီကသျ တသျ သာဂရာဂါဓဇလေ မဇ္ဇနံ ၑြေယး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","ဝိဃ္နာတ် ဇဂတး သန္တာပေါ ဘဝိၐျတိ, ဝိဃ္နော'ဝၑျံ ဇနယိၐျတေ, ကိန္တု ယေန မနုဇေန ဝိဃ္နော ဇနိၐျတေ တသျဲဝ သန္တာပေါ ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","တသ္မာတ် တဝ ကရၑ္စရဏော ဝါ ယဒိ တွာံ ဗာဓတေ, တရှိ တံ ဆိတ္တွာ နိက္ၐိပ, ဒွိကရသျ ဒွိပဒသျ ဝါ တဝါနပ္တဝဟ္နော် နိက္ၐေပါတ်, ခဉ္ဇသျ ဝါ ဆိန္နဟသ္တသျ တဝ ဇီဝနေ ပြဝေၑော ဝရံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","အပရံ တဝ နေတြံ ယဒိ တွာံ ဗာဓတေ, တရှိ တဒပျုတ္ပာဝျ နိက္ၐိပ, ဒွိနေတြသျ နရကာဂ္နော် နိက္ၐေပါတ် ကာဏသျ တဝ ဇီဝနေ ပြဝေၑော ဝရံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","တသ္မာဒဝဓဒ္ဓံ, ဧတေၐာံ က္ၐုဒြပြာဏိနာမ် ဧကမပိ မာ တုစ္ဆီကုရုတ, ");
INSERT INTO sanbur_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","ယတော ယုၐ္မာနဟံ တထျံ ဗြဝီမိ, သွရ္ဂေ တေၐာံ ဒူတာ မမ သွရ္ဂသ္ထသျ ပိတုရာသျံ နိတျံ ပၑျန္တိ၊ ဧဝံ ယေ ယေ ဟာရိတာသ္တာန် ရက္ၐိတုံ မနုဇပုတြ အာဂစ္ဆတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","ယူယမတြ ကိံ ဝိဝိံဂ္ဃွေ? ကသျစိဒ် ယဒိ ၑတံ မေၐား သန္တိ, တေၐာမေကော ဟာရျျတေ စ, တရှိ သ ဧကောနၑတံ မေၐာန် ဝိဟာယ ပရွွတံ ဂတွာ တံ ဟာရိတမေကံ ကိံ န မၖဂယတေ? ");
INSERT INTO sanbur_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ယဒိ စ ကဒါစိတ် တန္မေၐောဒ္ဒေၑံ လမတေ, တရှိ ယုၐ္မာနဟံ သတျံ ကထယာမိ, သော'ဝိပထဂါမိဘျ ဧကောနၑတမေၐေဘျောပိ တဒေကဟေတောရဓိကမ် အာဟ္လာဒတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","တဒွဒ် ဧတေၐာံ က္ၐုဒြပြာဧिနာမ် ဧကောပိ နၑျတီတိ ယုၐ္မာကံ သွရ္ဂသ္ထပိတု ရ္နာဘိမတမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","ယဒျပိ တဝ ဘြာတာ တွယိ ကိမပျပရာဓျတိ, တရှိ ဂတွာ ယုဝယောရ္ဒွယေား သ္ထိတယောသ္တသျာပရာဓံ တံ ဇ္ဉာပယ၊ တတြ သ ယဒိ တဝ ဝါကျံ ၑၖဏောတိ, တရှိ တွံ သွဘြာတရံ ပြာပ္တဝါန်, ");
INSERT INTO sanbur_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","ကိန္တု ယဒိ န ၑၖဏောတိ, တရှိ ဒွါဘျာံ တြိဘိ ရွာ သာက္ၐီဘိး သရွွံ ဝါကျံ ယထာ နိၑ္စိတံ ဇာယတေ, တဒရ္ထမ် ဧကံ ဒွေါ် ဝါ သာက္ၐိဏော် ဂၖဟီတွာ ယာဟိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","တေန သ ယဒိ တယော ရွာကျံ န မာနျတေ, တရှိ သမာဇံ တဇ္ဇ္ဉာပယ, ကိန္တု ယဒိ သမာဇသျာပိ ဝါကျံ န မာနျတေ,တရှိ သ တဝ သမီပေ ဒေဝပူဇကဣဝ စဏ္ဍာလဣဝ စ ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","အဟံ ယုၐ္မာန် သတျံ ဝဒါမိ, ယုၐ္မာဘိး ပၖထိဝျာံ ယဒ် ဗဓျတေ တတ် သွရ္ဂေ ဘံတ္သျတေ; မေဒိနျာံ ယတ် ဘောစျတေ, သွရ္ဂေ'ပိ တတ် မောက္ၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","ပုနရဟံ ယုၐ္မာန် ဝဒါမိ, မေဒိနျာံ ယုၐ္မာကံ ယဒိ ဒွါဝေကဝါကျီဘူယ ကိဉ္စိတ် ပြာရ္ထယေတေ, တရှိ မမ သွရ္ဂသ္ထပိတြာ တတ် တယေား ကၖတေ သမ္ပန္နံ ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","ယတော ယတြ ဒွေါ် တြယော ဝါ မမ နာန္နိ မိလန္တိ, တတြဲဝါဟံ တေၐာံ မဓျေ'သ္မိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","တဒါနီံ ပိတရသ္တတ္သမီပမာဂတျ ကထိတဝါန် ဟေ ပြဘော, မမ ဘြာတာ မမ ယဒျပရာဓျတိ, တရှိ တံ ကတိကၖတွး က္ၐမိၐျေ? ");
INSERT INTO sanbur_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","ကိံ သပ္တကၖတွး? ယီၑုသ္တံ ဇဂါဒ, တွာံ ကေဝလံ သပ္တကၖတွော ယာဝတ် န ဝဒါမိ, ကိန္တု သပ္တတျာ ဂုဏိတံ သပ္တကၖတွော ယာဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","အပရံ နိဇဒါသဲး သဟ ဇိဂဏယိၐုး ကၑ္စိဒ် ရာဇေဝ သွရ္ဂရာဇယံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","အာရဗ္ဓေ တသ္မိန် ဂဏနေ သာရ္ဒ္ဓသဟသြမုဒြာပူရိတာနာံ ဒၑသဟသြပုဋကာနာမ် ဧကော'ဃမရ္ဏသ္တတ္သမက္ၐမာနာယိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","တသျ ပရိၑောဓနာယ ဒြဝျာဘာဝါတ် ပရိၑောဓနာရ္ထံ သ တဒီယဘာရျျာပုတြာဒိသရွွသွဉ္စ ဝိကြီယတာမိတိ တတ္ပြဘုရာဒိဒေၑ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","တေန သ ဒါသသ္တသျ ပါဒယေား ပတန် ပြဏမျ ကထိတဝါန် , ဟေ ပြဘော ဘဝတာ ဃဲရျျေ ကၖတေ မယာ သရွွံ ပရိၑောဓိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","တဒါနီံ ဒါသသျ ပြဘုး သကရုဏး သန် သကလရ္ဏံ က္ၐမိတွာ တံ တတျာဇ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","ကိန္တု တသ္မိန် ဒါသေ ဗဟိ ရျာတေ, တသျ ၑတံ မုဒြာစတုရ္ထာံၑာန် ယော ဓာရယတိ, တံ သဟဒါသံ ဒၖၐ္ဒွါ တသျ ကဏ္ဌံ နိၐ္ပီဍျ ဂဒိတဝါန်, မမ ယတ် ပြာပျံ တတ် ပရိၑောဓယ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","တဒါ တသျ သဟဒါသသ္တတ္ပာဒယေား ပတိတွာ ဝိနီယ ဗဘာၐေ, တွယာ ဓဲရျျေ ကၖတေ မယာ သရွွံ ပရိၑောဓိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","တထာပိ သ တတ် နာငဂီကၖတျ ယာဝတ် သရွွမၖဏံ န ပရိၑောဓိတဝါန် တာဝတ် တံ ကာရာယာံ သ္ထာပယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","တဒါ တသျ သဟဒါသာသ္တသျဲတာဒၖဂ် အာစရဏံ ဝိလောကျ ပြဘေား သမီပံ ဂတွာ သရွွံ ဝၖတ္တာန္တံ နိဝေဒယာမာသုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","တဒါ တသျ ပြဘုသ္တမာဟူယ ဇဂါဒ, ရေ ဒုၐ္ဋ ဒါသ, တွယာ မတ္သန္နိဓော် ပြာရ္ထိတေ မယာ တဝ သရွွမၖဏံ တျက္တံ; ");
INSERT INTO sanbur_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ယထာ စာဟံ တွယိ ကရုဏာံ ကၖတဝါန်, တထဲဝ တွတ္သဟဒါသေ ကရုဏာကရဏံ ကိံ တဝ နောစိတံ? ");
INSERT INTO sanbur_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ဣတိ ကထယိတွာ တသျ ပြဘုး ကြုဒ္ဓျန် နိဇပြာပျံ ယာဝတ် သ န ပရိၑောဓိတဝါန်, တာဝတ် ပြဟာရကာနာံ ကရေၐု တံ သမရ္ပိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","ယဒိ ယူယံ သွာန္တးကရဏဲး သွသွသဟဇာနာမ် အပရာဓာန် န က္ၐမဓွေ, တရှိ မမ သွရ္ဂသျး ပိတာပိ ယုၐ္မာန် ပြတီတ္ထံ ကရိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","အနန္တရမ် ဧတာသု ကထာသု သမာပ္တာသု ယီၑု ရ္ဂာလီလပြဒေၑာတ် ပြသ္ထာယ ယရ္ဒန္တီရသ္ထံ ယိဟူဒါပြဒေၑံ ပြာပ္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","တဒါ တတ္ပၑ္စာတ် ဇနနိဝဟေ ဂတေ သ တတြ တာန် နိရာမယာန် အကရောတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","တဒနန္တရံ ဖိရူၑိနသ္တတ္သမီပမာဂတျ ပါရီက္ၐိတုံ တံ ပပြစ္ဆုး, ကသ္မာဒပိ ကာရဏာတ် နရေဏ သွဇာယာ ပရိတျာဇျာ န ဝါ? ");
INSERT INTO sanbur_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","သ ပြတျုဝါစ, ပြထမမ် ဤၑွရော နရတွေန နာရီတွေန စ မနုဇာန် သသရ္ဇ, တသ္မာတ် ကထိတဝါန်, ");
INSERT INTO sanbur_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","မာနုၐး သွပိတရော် ပရိတျဇျ သွပတ္နျာမ် အာသက္ၐျတေ, တော် ဒွေါ် ဇနာဝေကာင်္ဂေါ် ဘဝိၐျတး, ကိမေတဒ် ယုၐ္မာဘိ ရ္န ပဌိတမ်? ");
INSERT INTO sanbur_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","အတသ္တော် ပုန ရ္န ဒွေါ် တယောရေကာင်္ဂတွံ ဇာတံ, ဤၑွရေဏ ယစ္စ သမယုဇျတ, မနုဇော န တဒ် ဘိန္ဒျာတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","တဒါနီံ တေ တံ ပြတျဝဒန်, တထာတွေ တျာဇျပတြံ ဒတ္တွာ သွာံ သွာံ ဇာယာံ တျက္တုံ ဝျဝသ္ထာံ မူသား ကထံ လိလေခ? ");
INSERT INTO sanbur_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","တတး သ ကထိတဝါန်, ယုၐ္မာကံ မနသာံ ကာဌိနျာဒ် ယုၐ္မာန် သွာံ သွာံ ဇာယာံ တျက္တုမ် အနွမနျတ ကိန္တု ပြထမာဒ် ဧၐော ဝိဓိရ္နာသီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","အတော ယုၐ္မာနဟံ ဝဒါမိ, ဝျဘိစာရံ ဝိနာ ယော နိဇဇာယာံ တျဇေတ် အနျာဉ္စ ဝိဝဟေတ်, သ ပရဒါရာန် ဂစ္ဆတိ; ယၑ္စ တျက္တာံ နာရီံ ဝိဝဟတိ သောပိ ပရဒါရေၐု ရမတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","တဒါ တသျ ၑိၐျာသ္တံ ဗဘာၐိရေ, ယဒိ သွဇာယယာ သာကံ ပုံသ ဧတာဒၖက် သမ္ဗန္ဓော ဇာယတေ, တရှိ ဝိဝဟနမေဝ န ဘဒြံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","တတး သ ဥက္တဝါန်, ယေဘျသ္တတ္သာမရ္ထျံ အာဒါယိ, တာန် ဝိနာနျး ကောပိ မနုဇ ဧတန္မတံ ဂြဟီတုံ န ၑက္နောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","ကတိပယာ ဇနနက္လီဗး ကတိပယာ နရကၖတက္လီဗး သွရ္ဂရာဇျာယ ကတိပယား သွကၖတက္လီဗာၑ္စ သန္တိ, ယေ ဂြဟီတုံ ၑက္နုဝန္တိ တေ ဂၖဟ္လန္တု၊ ");
INSERT INTO sanbur_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","အပရမ် ယထာ သ ၑိၑူနာံ ဂါတြေၐု ဟသ္တံ ဒတွာ ပြာရ္ထယတေ, တဒရ္ထံ တတ္သမီံပံ ၑိၑဝ အာနီယန္တ, တတ အာနယိတၖန် ၑိၐျာသ္တိရသ္ကၖတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ကိန္တု ယီၑုရုဝါစ, ၑိၑဝေါ မဒန္တိကမ် အာဂစ္ဆန္တု, တာန် မာ ဝါရယတ, ဧတာဒၖၑာံ ၑိၑူနာမေဝ သွရ္ဂရာဇျံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","တတး သ တေၐာံ ဂါတြေၐု ဟသ္တံ ဒတွာ တသ္မာတ် သ္ထာနာတ် ပြတသ္ထေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","အပရမ် ဧက အာဂတျ တံ ပပြစ္ဆ, ဟေ ပရမဂုရော, အနန္တာယုး ပြာပ္တုံ မယာ ကိံ ကိံ သတ္ကရ္မ္မ ကရ္တ္တဝျံ? ");
INSERT INTO sanbur_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","တတး သ ဥဝါစ, မာံ ပရမံ ကုတော ဝဒသိ? ဝိနေၑ္စရံ န ကောပိ ပရမး, ကိန္တု ယဒျနန္တာယုး ပြာပ္တုံ ဝါဉ္ဆသိ, တရှျာဇ္ဉား ပါလယ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","တဒါ သ ပၖၐ္ဋဝါန်, ကား ကာ အာဇ္ဉား? တတော ယီၑုး ကထိတဝါန်, နရံ မာ ဟနျား, ပရဒါရာန် မာ ဂစ္ဆေး, မာ စောရယေး, မၖၐာသာက္ၐျံ မာ ဒဒျား, ");
INSERT INTO sanbur_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","နိဇပိတရော် သံမနျသွ, သွသမီပဝါသိနိ သွဝတ် ပြေမ ကုရု၊ ");
INSERT INTO sanbur_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","သ ယုဝါ ကထိတဝါန်, အာ ဗာလျာဒ် ဧတား ပါလယာမိ, ဣဒါနီံ ကိံ နျူနမာသ္တေ? ");
INSERT INTO sanbur_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","တတော ယီၑုရဝဒတ်, ယဒိ သိဒ္ဓေါ ဘဝိတုံ ဝါဉ္ဆသိ, တရှိ ဂတွာ နိဇသရွွသွံ ဝိကြီယ ဒရိဒြေဘျော ဝိတရ, တတး သွရ္ဂေ ဝိတ္တံ လပ္သျသေ; အာဂစ္ဆ, မတ္ပၑ္စာဒွရ္တ္တီ စ ဘဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ဧတာံ ဝါစံ ၑြုတွာ သ ယုဝါ သွီယဗဟုသမ္ပတ္တေ ရွိၐဏး သန် စလိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","တဒါ ယီၑုး သွၑိၐျာန် အဝဒတ်, ဓနိနာံ သွရ္ဂရာဇျပြဝေၑော မဟာဒုၐ္ကရ ဣတိ ယုၐ္မာနဟံ တထျံ ဝဒါမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","ပုနရပိ ယုၐ္မာနဟံ ဝဒါမိ, ဓနိနာံ သွရ္ဂရာဇျပြဝေၑာတ် သူစီဆိဒြေဏ မဟာင်္ဂဂမနံ သုကရံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ဣတိ ဝါကျံ နိၑမျ ၑိၐျာ အတိစမတ္ကၖတျ ကထယာမာသုး; တရှိ ကသျ ပရိတြာဏံ ဘဝိတုံ ၑက္နောတိ? ");
INSERT INTO sanbur_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","တဒါ သ တာန် ဒၖၐ္ဒွါ ကထယာမာသ, တတ် မာနုၐာဏာမၑကျံ ဘဝတိ, ကိန္တွီၑွရသျ သရွွံ ၑကျမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","တဒါ ပိတရသ္တံ ဂဒိတဝါန်, ပၑျ, ဝယံ သရွွံ ပရိတျဇျ ဘဝတး ပၑ္စာဒွရ္တ္တိနော 'ဘဝါမ; ဝယံ ကိံ ပြာပ္သျာမး? ");
INSERT INTO sanbur_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","တတော ယီၑုး ကထိတဝါန်, ယုၐ္မာနဟံ တထျံ ဝဒါမိ, ယူယံ မမ ပၑ္စာဒွရ္တ္တိနော ဇာတာ ဣတိ ကာရဏာတ် နဝီနသၖၐ္ဋိကာလေ ယဒါ မနုဇသုတး သွီယဲၑ္စရျျသိံဟာသန ဥပဝေက္ၐျတိ, တဒါ ယူယမပိ ဒွါဒၑသိံဟာသနေၐူပဝိၑျ ဣသြာယေလီယဒွါဒၑဝံၑာနာံ ဝိစာရံ ကရိၐျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","အနျစ္စ ယး ကၑ္စိတ် မမ နာမကာရဏာတ် ဂၖဟံ ဝါ ဘြာတရံ ဝါ ဘဂိနီံ ဝါ ပိတရံ ဝါ မာတရံ ဝါ ဇာယာံ ဝါ ဗာလကံ ဝါ ဘူမိံ ပရိတျဇတိ, သ တေၐာံ ၑတဂုဏံ လပ္သျတေ, အနန္တာယုမော'ဓိကာရိတွဉ္စ ပြာပ္သျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","ကိန္တု အဂြီယာ အနေကေ ဇနား ပၑ္စာတ်, ပၑ္စာတီယာၑ္စာနေကေ လောကာ အဂြေ ဘဝိၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","သွရ္ဂရာဇျမ် ဧတာဒၖၑာ ကေနစိဒ် ဂၖဟသျေန သမံ, ယော'တိပြဘာတေ နိဇဒြာက္ၐာက္ၐေတြေ ကၖၐကာန် နိယောက္တုံ ဂတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ပၑ္စာတ် တဲး သာကံ ဒိနဲကဘၖတိံ မုဒြာစတုရ္ထာံၑံ နိရူပျ တာန် ဒြာက္ၐာက္ၐေတြံ ပြေရယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","အနန္တရံ ပြဟရဲကဝေလာယာံ ဂတွာ ဟဋ္ဋေ ကတိပယာန် နိၐ္ကရ္မ္မကာန် ဝိလောကျ တာနဝဒတ်, ");
INSERT INTO sanbur_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ယူယမပိ မမ ဒြာက္ၐာက္ၐေတြံ ယာတ, ယုၐ္မဘျမဟံ ယောဂျဘၖတိံ ဒါသျာမိ, တတသ္တေ ဝဝြဇုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","ပုနၑ္စ သ ဒွိတီယတၖတီယယေား ပြဟရယော ရ္ဗဟိ ရ္ဂတွာ တထဲဝ ကၖတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","တတော ဒဏ္ဍဒွယာဝၑိၐ္ဋာယာံ ဝေလာယာံ ဗဟိ ရ္ဂတွာပရာန် ကတိပယဇနာန် နိၐ္ကရ္မ္မကာန် ဝိလောကျ ပၖၐ္ဋဝါန်, ယူယံ ကိမရ္ထမ် အတြ သရွွံ ဒိနံ နိၐ္ကရ္မ္မာဏသ္တိၐ္ဌထ? ");
INSERT INTO sanbur_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","တေ ပြတျဝဒန်, အသ္မာန် န ကောပိ ကရ္မမဏိ နိယုံက္တေ၊ တဒါနီံ သ ကထိတဝါန်, ယူယမပိ မမ ဒြာက္ၐာက္ၐေတြံ ယာတ, တေန ယောဂျာံ ဘၖတိံ လပ္သျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","တဒနန္တရံ သန္ဓျာယာံ သတျာံ သဧဝ ဒြာက္ၐာက္ၐေတြပတိရဓျက္ၐံ ဂဒိဝါန်, ကၖၐကာန် အာဟူယ ၑေၐဇနမာရဘျ ပြထမံ ယာဝတ် တေဘျော ဘၖတိံ ဒေဟိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","တေန ယေ ဒဏ္ဍဒွယာဝသ္ထိတေ သမာယာတာသ္တေၐာမ် ဧကဲကော ဇနော မုဒြာစတုရ္ထာံၑံ ပြာပ္နောတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","တဒါနီံ ပြထမနိယုက္တာ ဇနာ အာဂတျာနုမိတဝန္တော ဝယမဓိကံ ပြပ္သျာမး, ကိန္တု တဲရပိ မုဒြာစတုရ္ထာံၑော'လာဘိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","တတသ္တေ တံ ဂၖဟီတွာ တေန က္ၐေတြပတိနာ သာကံ ဝါဂျုဒ္ဓံ ကုရွွန္တး ကထယာမာသုး, ");
INSERT INTO sanbur_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ဝယံ ကၖတ္သ္နံ ဒိနံ တာပက္လေၑော် သောဎဝန္တး, ကိန္တု ပၑ္စာတာယာ သေ ဇနာ ဒဏ္ဍဒွယမာတြံ ပရိၑြာန္တဝန္တသ္တေ'သ္မာဘိး သမာနာံၑား ကၖတား၊ ");
INSERT INTO sanbur_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","တတး သ တေၐာမေကံ ပြတျုဝါစ, ဟေ ဝတ္သ, မယာ တွာံ ပြတိ ကောပျနျာယော န ကၖတး ကိံ တွယာ မတ္သမက္ၐံ မုဒြာစတုရ္ထာံၑော နာင်္ဂီကၖတး? ");
INSERT INTO sanbur_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","တသ္မာတ် တဝ ယတ် ပြာပျံ တဒါဒါယ ယာဟိ, တုဘျံ ယတိ, ပၑ္စာတီယနိယုက္တလောကာယာပိ တတိ ဒါတုမိစ္ဆာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","သွေစ္ဆယာ နိဇဒြဝျဝျဝဟရဏံ ကိံ မယာ န ကရ္တ္တဝျံ? မမ ဒါတၖတွာတ် တွယာ ကိမ် ဤရ္ၐျာဒၖၐ္ဋိး ကြိယတေ? ");
INSERT INTO sanbur_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","ဣတ္ထမ် အဂြီယလောကား ပၑ္စတီယာ ဘဝိၐျန္တိ, ပၑ္စာတီယဇနာၑ္စဂြီယာ ဘဝိၐျန္တိ, အဟူတာ ဗဟဝး ကိန္တွလ္ပေ မနောဘိလၐိတား၊ ");
INSERT INTO sanbur_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","တဒနန္တရံ ယီၑု ရျိရူၑာလမ္နဂရံ ဂစ္ဆန် မာရ္ဂမဓျေ ၑိၐျာန် ဧကာန္တေ ဝဘာၐေ, ");
INSERT INTO sanbur_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","ပၑျ ဝယံ ယိရူၑာလမ္နဂရံ ယာမး, တတြ ပြဓာနယာဇကာဓျာပကာနာံ ကရေၐု မနုၐျပုတြး သမရ္ပိၐျတေ; ");
INSERT INTO sanbur_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","တေ စ တံ ဟန္တုမာဇ္ဉာပျ တိရသ္ကၖတျ ဝေတြေဏ ပြဟရ္တ္တုံ ကြုၑေ ဓာတယိတုဉ္စာနျဒေၑီယာနာံ ကရေၐု သမရ္ပယိၐျန္တိ, ကိန္တု သ တၖတီယဒိဝသေ ၑ္မၑာနာဒ် ဥတ္ထာပိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","တဒါနီံ သိဝဒီယသျ နာရီ သွပုတြာဝါဒါယ ယီၑေား သမီပမ် ဧတျ ပြဏမျ ကဉ္စနာနုဂြဟံ တံ ယယာစေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","တဒါ ယီၑုသ္တာံ ပြောက္တဝါန်, တွံ ကိံ ယာစသေ? တတး သာ ဗဘာၐေ, ဘဝတော ရာဇတွေ မမာနယေား သုတယောရေကံ ဘဝဒ္ဒက္ၐိဏပါရ္ၑွေ ဒွိတီယံ ဝါမပါရ္ၑွ ဥပဝေၐ္ဋုမ် အာဇ္ဉာပယတု၊ ");
INSERT INTO sanbur_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ယီၑုး ပြတျုဝါစ, ယုဝါဘျာံ ယဒ် ယာစျတေ, တန္န ဗုဓျတေ, အဟံ ယေန ကံသေန ပါသျာမိ ယုဝါဘျာံ ကိံ တေန ပါတုံ ၑကျတေ? အဟဉ္စ ယေန မဇ္ဇေနေန မဇ္ဇိၐျေ, ယုဝါဘျာံ ကိံ တေန မဇ္ဇယိတုံ ၑကျတေ? တေ ဇဂဒုး ၑကျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","တဒါ သ ဥက္တဝါန်, ယုဝါံ မမ ကံသေနာဝၑျံ ပါသျထး, မမ မဇ္ဇနေန စ ယုဝါမပိ မဇ္ဇိၐျေထေ, ကိန္တု ယေၐာံ ကၖတေ မတ္တာတေန နိရူပိတမ် ဣဒံ တာန် ဝိဟာယာနျံ ကမပိ မဒ္ဒက္ၐိဏပါရ္ၑွေ ဝါမပါရ္ၑွေ စ သမုပဝေၑယိတုံ မမာဓိကာရော နာသ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ဧတာံ ကထာံ ၑြုတွာနျေ ဒၑၑိၐျာသ္တော် ဘြာတရော် ပြတိ စုကုပုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","ကိန္တု ယီၑုး သွသမီပံ တာနာဟူယ ဇဂါဒ, အနျဒေၑီယလောကာနာံ နရပတယသ္တာန် အဓိကုရွွန္တိ, ယေ တု မဟာန္တသ္တေ တာန် ၑာသတိ, ဣတိ ယူယံ ဇာနီထ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","ကိန္တု ယုၐ္မာကံ မဓျေ န တထာ ဘဝေတ်, ယုၐ္မာကံ ယး ကၑ္စိတ် မဟာန် ဗုဘူၐတိ, သ ယုၐ္မာန် သေဝေတ; ");
INSERT INTO sanbur_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ယၑ္စ ယုၐ္မာကံ မဓျေ မုချော ဗုဘူၐတိ, သ ယုၐ္မာကံ ဒါသော ဘဝေတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ဣတ္ထံ မနုဇပုတြး သေဝျော ဘဝိတုံ နဟိ, ကိန္တု သေဝိတုံ ဗဟူနာံ ပရိတြာဏမူလျာရ္ထံ သွပြာဏာန် ဒါတုဉ္စာဂတး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","အနန္တရံ ယိရီဟောနဂရာတ် တေၐာံ ဗဟိရ္ဂမနသမယေ တသျ ပၑ္စာဒ် ဗဟဝေါ လောကာ ဝဝြဇုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","အပရံ ဝရ္တ္မပါရ္ၑွ ဥပဝိၑန္တော် ဒွါဝန္ဓော် တေန မာရ္ဂေဏ ယီၑော ရ္ဂမနံ နိၑမျ ပြောစ္စဲး ကထယာမာသတုး, ဟေ ပြဘော ဒါယူဒး သန္တာန, အာဝယော ရ္ဒယာံ ဝိဓေဟိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","တတော လောကား သရွွေ တုၐ္ဏီမ္ဘဝတမိတျုက္တွာ တော် တရ္ဇယာမာသုး; တထာပိ တော် ပုနရုစ္စဲး ကထယာမာသတုး ဟေ ပြဘော ဒါယူဒး သန္တာန, အာဝါံ ဒယသွ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","တဒါနီံ ယီၑုး သ္ထဂိတး သန် တာဝါဟူယ ဘာၐိတဝါန်, ယုဝယေား ကၖတေ မယာ ကိံ ကရ္တ္တရွျံ? ယုဝါံ ကိံ ကာမယေထေ? ");
INSERT INTO sanbur_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","တဒါ တာဝုက္တဝန္တော်, ပြဘော နေတြာဏိ နော် ပြသန္နာနိ ဘဝေယုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","တဒါနီံ ယီၑုသ္တော် ပြတိ ပြမန္နး သန် တယော ရ္နေတြာဏိ ပသ္ပရ္ၑ, တေနဲဝ တော် သုဝီက္ၐာဉ္စကြာတေ တတ္ပၑ္စာတ် ဇဂ္မုတုၑ္စ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","အနန္တရံ တေၐု ယိရူၑာလမ္နဂရသျ သမီပဝေရ္တ္တိနော ဇဲတုနနာမကဓရာဓရသျ သမီပသ္ထ္တိံ ဗဲတ္ဖဂိဂြာမမ် အာဂတေၐု, ယီၑုး ၑိၐျဒွယံ ပြေၐယန် ဇဂါဒ, ");
INSERT INTO sanbur_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ယုဝါံ သမ္မုခသ္ထဂြာမံ ဂတွာ ဗဒ္ဓါံ ယာံ သဝတ္သာံ ဂရ္ဒ္ဒဘီံ ဟဌာတ် ပြာပ္သျထး, တာံ မောစယိတွာ မဒန္တိကမ် အာနယတံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","တတြ ယဒိ ကၑ္စိတ် ကိဉ္စိဒ် ဝက္ၐျတိ, တရှိ ဝဒိၐျထး, ဧတသျာံ ပြဘေား ပြယောဇနမာသ္တေ, တေန သ တတ္က္ၐဏာတ် ပြဟေၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","သီယောနး ကနျကာံ ယူယံ ဘာၐဓွမိတိ ဘာရတီံ၊ ပၑျ တေ နမြၑီလး သန် နၖပ အာရုဟျ ဂရ္ဒဘီံ၊ အရ္ထာဒါရုဟျ တဒွတ္သမာယာသျတိ တွဒန္တိကံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","ဘဝိၐျဒွါဒိနောက္တံ ဝစနမိဒံ တဒါ သဖလမဘူတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","အနန္တရံ တော် ၑ္ၐျိौ ယီၑော ရျထာနိဒေၑံ တံ ဂြာမံ ဂတွာ ");
INSERT INTO sanbur_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ဂရ္ဒဘီံ တဒွတ္သဉ္စ သမာနီတဝန္တော်, ပၑ္စာတ် တဒုပရိ သွီယဝသနာနီ ပါတယိတွာ တမာရောဟယာမာသတုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","တတော ဗဟဝေါ လောကာ နိဇဝသနာနိ ပထိ ပြသာရယိတုမာရေဘိရေ, ကတိပယာ ဇနာၑ္စ ပါဒပပရ္ဏာဒိကံ ဆိတွာ ပထိ ဝိသ္တာရယာမာသုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","အဂြဂါမိနး ပၑ္စာဒ္ဂါမိနၑ္စ မနုဇာ ဥစ္စဲရ္ဇယ ဇယ ဒါယူဒး သန္တာနေတိ ဇဂဒုး ပရမေၑွရသျ နာမ္နာ ယ အာယာတိ သ ဓနျး, သရွွောပရိသ္ထသွရ္ဂေပိ ဇယတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ဣတ္ထံ တသ္မိန် ယိရူၑာလမံ ပြဝိၐ္ဋေ ကော'ယမိတိ ကထနာတ် ကၖတ္သ္နံ နဂရံ စဉ္စလမဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","တတြ လောကေား ကထယာမာသုး, ဧၐ ဂါလီလ္ပြဒေၑီယ-နာသရတီယ-ဘဝိၐျဒွါဒီ ယီၑုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","အနန္တရံ ယီၑုရီၑွရသျ မန္ဒိရံ ပြဝိၑျ တန္မဓျာတ် ကြယဝိကြယိဏော ဝဟိၑ္စကာရ; ဝဏိဇာံ မုဒြာသနာနီ ကပေါတဝိကြယိဏာဉ္စသနာနီ စ နျုဝ္ဇယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","အပရံ တာနုဝါစ, ဧၐာ လိပိရာသ္တေ, \"မမ ဂၖဟံ ပြာရ္ထနာဂၖဟမိတိ ဝိချာသျတိ\", ကိန္တု ယူယံ တဒ် ဒသျူနာံ ဂဟွရံ ကၖတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","တဒနန္တရမ် အန္ဓခဉ္စလောကာသ္တသျ သမီပမာဂတား, သ တာန် နိရာမယာန် ကၖတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ယဒါ ပြဓာနယာဇကာ အဓျာပကာၑ္စ တေန ကၖတာနျေတာနိ စိတြကရ္မ္မာဏိ ဒဒၖၑုး, ဇယ ဇယ ဒါယူဒး သန္တာန, မန္ဒိရေ ဗာလကာနာမ် ဧတာဒၖၑမ် ဥစ္စဓွနိံ ၑုၑြုဝုၑ္စ, တဒါ မဟာကြုဒ္ဓါ ဗဘူဝး, ");
INSERT INTO sanbur_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","တံ ပပြစ္ဆုၑ္စ, ဣမေ ယဒ် ဝဒန္တိ, တတ် ကိံ တွံ ၑၖဏောၐိ? တတော ယီၑုသ္တာန် အဝေါစတ်, သတျမ်; သ္တနျပါယိၑိၑူနာဉ္စ ဗာလကာနာဉ္စ ဝက္တြတး၊ သွကီယံ မဟိမာနံ တွံ သံပြကာၑယသိ သွယံ၊ ဧတဒွါကျံ ယူယံ ကိံ နာပဌတ? ");
INSERT INTO sanbur_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","တတသ္တာန် ဝိဟာယ သ နဂရာဒ် ဗဲထနိယာဂြာမံ ဂတွာ တတြ ရဇနီံ ယာပယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","အနန္တရံ ပြဘာတေ သတိ ယီၑုး ပုနရပိ နဂရမာဂစ္ဆန် က္ၐုဓာရ္တ္တော ဗဘူဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","တတော မာရ္ဂပါရ္ၑွ ဥဍုမ္ဗရဝၖက္ၐမေကံ ဝိလောကျ တတ္သမီပံ ဂတွာ ပတြာဏိ ဝိနာ ကိမပိ န ပြာပျ တံ ပါဒပံ ပြောဝါစ, အဒျာရဘျ ကဒါပိ တွယိ ဖလံ န ဘဝတု; တေန တတ္က္ၐဏာတ် သ ဥဍုမ္ဗရမာဟီရုဟး ၑုၐ္ကတာံ ဂတး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","တဒ် ဒၖၐ္ဋွာ ၑိၐျာ အာၑ္စရျျံ ဝိဇ္ဉာယ ကထယာမာသုး, အား, ဥဍုမွရပါဒပေါ'တိတူရ္ဏံ ၑုၐ္ကော'ဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","တတော ယီၑုသ္တာနုဝါစ, ယုၐ္မာနဟံ သတျံ ဝဒါမိ, ယဒိ ယူယမသန္ဒိဂ္ဓား ပြတီထ, တရှိ ယူယမပိ ကေဝလောဍုမွရပါဒပံ ပြတီတ္ထံ ကရ္တ္တုံ ၑက္ၐျထ, တန္န, တွံ စလိတွာ သာဂရေ ပတေတိ ဝါကျံ ယုၐ္မာဘိရသ္မိန ၑဲလေ ပြောက္တေပိ တဒဲဝ တဒ် ဃဋိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","တထာ ဝိၑွသျ ပြာရ္ထျ ယုၐ္မာဘိ ရျဒ် ယာစိၐျတေ, တဒေဝ ပြာပ္သျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","အနန္တရံ မန္ဒိရံ ပြဝိၑျောပဒေၑနသမယေ တတ္သမီပံ ပြဓာနယာဇကား ပြာစီနလောကာၑ္စာဂတျ ပပြစ္ဆုး, တွယာ ကေန သာမရ္ထျနဲတာနိ ကရ္မ္မာဏိ ကြိယန္တေ? ကေန ဝါ တုဘျမေတာနိ သာမရ္ထျာနိ ဒတ္တာနိ? ");
INSERT INTO sanbur_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","တတော ယီၑုး ပြတျဝဒတ်, အဟမပိ ယုၐ္မာန် ဝါစမေကာံ ပၖစ္ဆာမိ, ယဒိ ယူယံ တဒုတ္တရံ ဒါတုံ ၑက္ၐျထ, တဒါ ကေန သာမရ္ထျေန ကရ္မ္မာဏျေတာနိ ကရောမိ, တဒဟံ ယုၐ္မာန် ဝက္ၐျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","ယောဟနော မဇ္ဇနံ ကသျာဇ္ဉယာဘဝတ်? ကိမီၑွရသျ မနုၐျသျ ဝါ? တတသ္တေ ပရသ္ပရံ ဝိဝိစျ ကထယာမာသုး, ယဒီၑွရသျေတိ ဝဒါမသ္တရှိ ယူယံ တံ ကုတော န ပြတျဲတ? ဝါစမေတာံ ဝက္ၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","မနုၐျသျေတိ ဝက္တုမပိ လောကေဘျော ဗိဘီမး, ယတး သရွွဲရပိ ယောဟန် ဘဝိၐျဒွါဒီတိ ဇ္ဉာယတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","တသ္မာတ် တေ ယီၑုံ ပြတျဝဒန်, တဒ် ဝယံ န ဝိဒ္မး၊ တဒါ သ တာနုက္တဝါန်, တရှိ ကေန သာမရထျေန ကရ္မ္မာဏျေတာနျဟံ ကရောမိ, တဒပျဟံ ယုၐ္မာန် န ဝက္ၐျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","ကသျစိဇ္ဇနသျ ဒွေါ် သုတာဝါသ္တာံ သ ဧကသျ သုတသျ သမီပံ ဂတွာ ဇဂါဒ, ဟေ သုတ, တွမဒျ မမ ဒြာက္ၐာက္ၐေတြေ ကရ္မ္မ ကရ္တုံ ဝြဇ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","တတး သ ဥက္တဝါန်, န ယာသျာမိ, ကိန္တု ၑေၐေ'နုတပျ ဇဂါမ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","အနန္တရံ သောနျသုတသျ သမီပံ ဂတွာ တထဲဝ ကထ္တိဝါန်; တတး သ ပြတျုဝါစ, မဟေစ္ဆ ယာမိ, ကိန္တု န ဂတး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","ဧတယေား ပုတြယော ရ္မဓျေ ပိတုရဘိမတံ ကေန ပါလိတံ? ယုၐ္မာဘိး ကိံ ဗုဓျတေ? တတသ္တေ ပြတျူစုး, ပြထမေန ပုुတြေဏ၊ တဒါနီံ ယီၑုသ္တာနုဝါစ, အဟံ ယုၐ္မာန် တထျံ ဝဒါမိ, စဏ္ဍာလာ ဂဏိကာၑ္စ ယုၐ္မာကမဂြတ ဤၑွရသျ ရာဇျံ ပြဝိၑန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ယတော ယုၐ္မာကံ သမီပံ ယောဟနိ ဓရ္မ္မပထေနာဂတေ ယူယံ တံ န ပြတီထ, ကိန္တု စဏ္ဍာလာ ဂဏိကာၑ္စ တံ ပြတျာယန်, တဒ် ဝိလောကျာပိ ယူယံ ပြတျေတုံ နာခိဒျဓွံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","အပရမေကံ ဒၖၐ္ဋာန္တံ ၑၖဏုတ, ကၑ္စိဒ် ဂၖဟသ္ထး က္ၐေတြေ ဒြာက္ၐာလတာ ရောပယိတွာ တစ္စတုရ္ဒိက္ၐု ဝါရဏီံ ဝိဓာယ တန္မဓျေ ဒြာက္ၐာယန္တြံ သ္ထာပိတဝါန်, မာဉ္စဉ္စ နိရ္မ္မိတဝါန်, တတး ကၖၐကေၐု တတ် က္ၐေတြံ သမရ္ပျ သွယံ ဒူရဒေၑံ ဇဂါမ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","တဒနန္တရံ ဖလသမယ ဥပသ္ထိတေ သ ဖလာနိ ပြာပ္တုံ ကၖၐီဝလာနာံ သမီပံ နိဇဒါသာန် ပြေၐယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","ကိန္တု ကၖၐီဝလာသ္တသျ တာန် ဒါသေယာန် ဓၖတွာ ကဉ္စန ပြဟၖတဝန္တး, ကဉ္စန ပါၐာဏဲရာဟတဝန္တး, ကဉ္စန စ ဟတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","ပုနရပိ သ ပြဘုး ပြထမတော'ဓိကဒါသေယာန် ပြေၐယာမာသ, ကိန္တု တေ တာန် ပြတျပိ တထဲဝ စကြုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","အနန္တရံ မမ သုတေ ဂတေ တံ သမာဒရိၐျန္တေ, ဣတျုက္တွာ ၑေၐေ သ နိဇသုတံ တေၐာံ သန္နိဓိံ ပြေၐယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","ကိန္တု တေ ကၖၐီဝလား သုတံ ဝီက္ၐျ ပရသ္ပရမ် ဣတိ မန္တြယိတုမ် အာရေဘိရေ, အယမုတ္တရာဓိကာရီ ဝယမေနံ နိဟတျာသျာဓိကာရံ သွဝၑီကရိၐျာမး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","ပၑ္စာတ် တေ တံ ဓၖတွာ ဒြာက္ၐာက္ၐေတြာဒ် ဗဟိး ပါတယိတွာဗဓိၐုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","ယဒါ သ ဒြာက္ၐာက္ၐေတြပတိရာဂမိၐျတိ, တဒါ တာန် ကၖၐီဝလာန် ကိံ ကရိၐျတိ? ");
INSERT INTO sanbur_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","တတသ္တေ ပြတျဝဒန်, တာန် ကလုၐိဏော ဒါရုဏယာတနာဘိရာဟနိၐျတိ, ယေ စ သမယာနုကြမာတ် ဖလာနိ ဒါသျန္တိ, တာဒၖၑေၐု ကၖၐီဝလေၐု က္ၐေတြံ သမရ္ပယိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","တဒါ ယီၑုနာ တေ ဂဒိတား, ဂြဟဏံ န ကၖတံ ယသျ ပါၐာဏသျ နိစာယကဲး၊ ပြဓာနပြသ္တရး ကောဏေ သဧဝ သံဘဝိၐျတိ၊ ဧတတ် ပရေၑိတုး ကရ္မ္မာသ္မဒၖၐ္ဋာဝဒ္ဘုတံ ဘဝေတ်၊ ဓရ္မ္မဂြန္ထေ လိခိတမေတဒွစနံ ယုၐ္မာဘိး ကိံ နာပါဌိ? ");
INSERT INTO sanbur_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","တသ္မာဒဟံ ယုၐ္မာန် ဝဒါမိ, ယုၐ္မတ္တ ဤၑွရီယရာဇျမပနီယ ဖလောတ္ပာဒယိတြနျဇာတယေ ဒါယိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","ယော ဇန ဧတတ္ပာၐာဏောပရိ ပတိၐျတိ, တံ သ ဘံက္ၐျတေ, ကိန္တွယံ ပါၐာဏော ယသျောပရိ ပတိၐျတိ, တံ သ ဓူလိဝတ် စူရ္ဏီကရိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","တဒါနီံ ပြာဓနယာဇကား ဖိရူၑိနၑ္စ တသျေမာံ ဒၖၐ္ဋာန္တကထာံ ၑြုတွာ သော'သ္မာနုဒ္ဒိၑျ ကထိတဝါန်, ဣတိ ဝိဇ္ဉာယ တံ ဓရ္တ္တုံ စေၐ္ဋိတဝန္တး; ");
INSERT INTO sanbur_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ကိန္တု လောကေဘျော ဗိဘျုး, ယတော လောကဲး သ ဘဝိၐျဒွါဒီတျဇ္ဉာယိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","အနန္တရံ ယီၑုး ပုနရပိ ဒၖၐ္ဋာန္တေန တာန် အဝါဒီတ်, ");
INSERT INTO sanbur_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","သွရ္ဂီယရာဇျမ် ဧတာဒၖၑသျ နၖပတေး သမံ, ယော နိဇ ပုတြံ ဝိဝါဟယန် သရွွာန် နိမန္တြိတာန် အာနေတုံ ဒါသေယာန် ပြဟိတဝါန်, ");
INSERT INTO sanbur_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ကိန္တု တေ သမာဂန္တုံ နေၐ္ဋဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","တတော ရာဇာ ပုနရပိ ဒါသာနနျာန် ဣတျုက္တွာ ပြေၐယာမာသ, နိမန္တြိတာန် ဝဒတ, ပၑျတ, မမ ဘေဇျမာသာဒိတမာသ္တေ, နိဇဝ္ဋၐာဒိပုၐ္ဋဇန္တူန် မာရယိတွာ သရွွံ ခါဒျဒြဝျမာသာဒိတဝါန်, ယူယံ ဝိဝါဟမာဂစ္ဆတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","တထပိ တေ တုစ္ဆီကၖတျ ကေစိတ် နိဇက္ၐေတြံ ကေစိဒ် ဝါဏိဇျံ ပြတိ သွသွမာရ္ဂေဏ စလိတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","အနျေ လောကာသ္တသျ ဒါသေယာန် ဓၖတွာ ဒေါ်ရာတ္မျံ ဝျဝဟၖတျ တာနဝဓိၐုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","အနန္တရံ သ နၖပတိသ္တာံ ဝါရ္တ္တာံ ၑြုတွာ ကြုဓျန် သဲနျာနိ ပြဟိတျ တာန် ဃာတကာန် ဟတွာ တေၐာံ နဂရံ ဒါဟယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","တတး သ နိဇဒါသေယာန် ဗဘာၐေ, ဝိဝါဟီယံ ဘောဇျမာသာဒိတမာသ္တေ, ကိန္တု နိမန္တြိတာ ဇနာ အယောဂျား၊ ");
INSERT INTO sanbur_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","တသ္မာဒ် ယူယံ ရာဇမာရ္ဂံ ဂတွာ ယာဝတော မနုဇာန် ပၑျတ, တာဝတဧဝ ဝိဝါဟီယဘောဇျာယ နိမန္တြယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","တဒါ တေ ဒါသေယာ ရာဇမာရ္ဂံ ဂတွာ ဘဒြာန် အဘဒြာန် ဝါ ယာဝတော ဇနာန် ဒဒၖၑုး, တာဝတဧဝ သံဂၖဟျာနယန်; တတော'ဘျာဂတမနုဇဲ ရွိဝါဟဂၖဟမ် အပူရျျတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","တဒါနီံ သ ရာဇာ သရွွာနဘျာဂတာန် ဒြၐ္ဋုမ် အဘျန္တရမာဂတဝါန်; တဒါ တတြ ဝိဝါဟီယဝသနဟီနမေကံ ဇနံ ဝီက္ၐျ တံ ဇဂါဒ်, ");
INSERT INTO sanbur_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ဟေ မိတြ,တွံ ဝိဝါဟီယဝသနံ ဝိနာ ကထမတြ ပြဝိၐ္ဋဝါန်? တေန သ နိရုတ္တရော ဗဘူဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","တဒါ ရာဇာ နိဇာနုစရာန် အဝဒတ်, ဧတသျ ကရစရဏာန် ဗဒ္ဓါ ယတြ ရောဒနံ ဒန္တဲရ္ဒန္တဃရ္ၐဏဉ္စ ဘဝတိ, တတြ ဝဟိရ္ဘူတတမိသြေ တံ နိက္ၐိပတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","ဣတ္ထံ ဗဟဝ အာဟူတာ အလ္ပေ မနောဘိမတား၊ ");
INSERT INTO sanbur_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","အနန္တရံ ဖိရူၑိနး ပြဂတျ ယထာ သံလာပေန တမ် ဥန္မာထေ ပါတယေယုသ္တထာ မန္တြယိတွာ ");
INSERT INTO sanbur_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ဟေရောဒီယမနုဇဲး သာကံ နိဇၑိၐျဂဏေန တံ ပြတိ ကထယာမာသုး, ဟေ ဂုရော, ဘဝါန် သတျး သတျမီၑွရီယမာရ္ဂမုပဒိၑတိ, ကမပိ မာနုၐံ နာနုရုဓျတေ, ကမပိ နာပေက္ၐတေ စ, တဒ် ဝယံ ဇာနီမး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","အတး ကဲသရဘူပါယ ကရော'သ္မာကံ ဒါတဝျော န ဝါ? အတြ ဘဝတာ ကိံ ဗုဓျတေ? တဒ် အသ္မာန် ဝဒတု၊ ");
INSERT INTO sanbur_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","တတော ယီၑုသ္တေၐာံ ခလတာံ ဝိဇ္ဉာယ ကထိတဝါန်, ရေ ကပဋိနး ယုယံ ကုတော မာံ ပရိက္ၐဓွေ? ");
INSERT INTO sanbur_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","တတ္ကရဒါနသျ မုဒြာံ မာံ ဒရ္ၑယတ၊ တဒါနီံ တဲသ္တသျ သမီပံ မုဒြာစတုရ္ထဘာဂ အာနီတေ ");
INSERT INTO sanbur_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","သ တာန် ပပြစ္ဆ, အတြ ကသျေယံ မူရ္တ္တိ ရ္နာမ စာသ္တေ? တေ ဇဂဒုး, ကဲသရဘူပသျ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","တတး သ ဥက္တဝါန, ကဲသရသျ ယတ် တတ် ကဲသရာယ ဒတ္တ, ဤၑွရသျ ယတ် တဒ် ဤၑွရာယ ဒတ္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ဣတိ ဝါကျံ နိၑမျ တေ ဝိသ္မယံ ဝိဇ္ဉာယ တံ ဝိဟာယ စလိတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","တသ္မိန္နဟနိ သိဒူကိနော'ရ္ထာတ် ၑ္မၑာနာတ် နောတ္ထာသျန္တီတိ ဝါကျံ ယေ ဝဒန္တိ, တေ ယီၑေाရန္တိကမ် အာဂတျ ပပြစ္ဆုး, ");
INSERT INTO sanbur_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ဟေ ဂုရော, ကၑ္စိန္မနုဇၑ္စေတ် နိးသန္တာနး သန် ပြာဏာန် တျဇတိ, တရှိ တသျ ဘြာတာ တသျ ဇာယာံ ဝျုဟျ ဘြာတုး သန္တာနမ် ဥတ္ပာဒယိၐျတီတိ မူသာ အာဒိၐ္ဋဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","ကိန္တွသ္မာကမတြ ကေ'ပိ ဇနား သပ္တသဟောဒရာ အာသန်, တေၐာံ ဇျေၐ္ဌ ဧကာံ ကနျာံ ဝျဝဟာတ်, အပရံ ပြာဏတျာဂကာလေ သွယံ နိးသန္တာနး သန် တာံ သ္တြိယံ သွဘြာတရိ သမရ္ပိတဝါန်, ");
INSERT INTO sanbur_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","တတော ဒွိတီယာဒိသပ္တမာန္တာၑ္စ တထဲဝ စကြုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ၑေၐေ သာပီ နာရီ မမာရ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","မၖတာနာမ် ဥတ္ထာနသမယေ တေၐာံ သပ္တာနာံ မဓျေ သာ နာရီ ကသျ ဘာရျျာ ဘဝိၐျတိ? ယသ္မာတ် သရွွဧဝ တာံ ဝျဝဟန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","တတော ယီၑုး ပြတျဝါဒီတ်, ယူယံ ဓရ္မ္မပုသ္တကမ် ဤၑွရီယာံ ၑက္တိဉ္စ န ဝိဇ္ဉာယ ဘြာန္တိမန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","ဥတ္ထာနပြာပ္တာ လောကာ န ဝိဝဟန္တိ, န စ ဝါစာ ဒီယန္တေ, ကိန္တွီၑွရသျ သွရ္ဂသ္ထဒူတာနာံ သဒၖၑာ ဘဝန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","အပရံ မၖတာနာမုတ္ထာနမဓိ ယုၐ္မာန် ပြတီယမီၑွရောက္တိး, ");
INSERT INTO sanbur_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","\"အဟမိဗြာဟီမ ဤၑွရ ဣသှာက ဤၑွရော ယာကူဗ ဤၑွရ\" ဣတိ ကိံ ယုၐ္မာဘိ ရ္နာပါဌိ? ကိန္တွီၑွရော ဇီဝတာမ် ဤၑွရ:, သ မၖတာနာမီၑွရော နဟိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ဣတိ ၑြုတွာ သရွွေ လောကာသ္တသျောပဒေၑာဒ် ဝိသ္မယံ ဂတား၊ ");
INSERT INTO sanbur_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","အနန္တရံ သိဒူကိနာမ် နိရုတ္တရတွဝါရ္တာံ နိၑမျ ဖိရူၑိန ဧကတြ မိလိတဝန္တး, ");
INSERT INTO sanbur_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","တေၐာမေကော ဝျဝသ္ထာပကော ယီၑုံ ပရီက္ၐိတုံ ပပစ္ဆ, ");
INSERT INTO sanbur_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","ဟေ ဂုရော ဝျဝသ္ထာၑာသ္တြမဓျေ ကာဇ္ဉာ ၑြေၐ္ဌာ? ");
INSERT INTO sanbur_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","တတော ယီၑုရုဝါစ, တွံ သရွွာန္တးကရဏဲး သရွွပြာဏဲး သရွွစိတ္တဲၑ္စ သာကံ ပြဘော် ပရမေၑွရေ ပြီယသွ, ");
INSERT INTO sanbur_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ဧၐာ ပြထမမဟာဇ္ဉာ၊ တသျား သဒၖၑီ ဒွိတီယာဇ္ဉဲၐာ, ");
INSERT INTO sanbur_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","တဝ သမီပဝါသိနိ သွာတ္မနီဝ ပြေမ ကုရု၊ ");
INSERT INTO sanbur_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","အနယော ရ္ဒွယောရာဇ္ဉယေား ကၖတ္သ္နဝျဝသ္ထာယာ ဘဝိၐျဒွက္တၖဂြန္ထသျ စ ဘာရသ္တိၐ္ဌတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","အနန္တရံ ဖိရူၑိနာမ် ဧကတြ သ္ထိတိကာလေ ယီၑုသ္တာန် ပပြစ္ဆ, ");
INSERT INTO sanbur_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","ခြီၐ္ဋမဓိ ယုၐ္မာကံ ကီဒၖဂ္ဗောဓော ဇာယတေ? သ ကသျ သန္တာနး? တတသ္တေ ပြတျဝဒန်, ဒါယူဒး သန္တာနး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","တဒါ သ ဥက္တဝါန်, တရှိ ဒါယူဒ် ကထမ် အာတ္မာဓိၐ္ဌာနေန တံ ပြဘုံ ဝဒတိ ? ");
INSERT INTO sanbur_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","ယထာ မမ ပြဘုမိဒံ ဝါကျမဝဒတ် ပရမေၑွရး၊ တဝါရီန် ပါဒပီဌံ တေ ယာဝန္နဟိ ကရောမျဟံ၊ တာဝတ် ကာလံ မဒီယေ တွံ ဒက္ၐပါရ္ၑွ ဥပါဝိၑ၊ အတော ယဒိ ဒါယူဒ် တံ ပြဘုံ ဝဒတိ, ရ္တိဟ သ ကထံ တသျ သန္တာနော ဘဝတိ? ");
INSERT INTO sanbur_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","တဒါနီံ တေၐာံ ကောပိ တဒွါကျသျ ကိမပျုတ္တရံ ဒါတုံ နာၑက္နောတ်; ");
INSERT INTO sanbur_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","တဒ္ဒိနမာရဘျ တံ ကိမပိ ဝါကျံ ပြၐ္ဋုံ ကသျာပိ သာဟသော နာဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","အနန္တရံ ယီၑု ရ္ဇနနိဝဟံ ၑိၐျာံၑ္စာဝဒတ်, ");
INSERT INTO sanbur_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","အဓျာပကား ဖိရူၑိနၑ္စ မူသာသနေ ဥပဝိၑန္တိ, ");
INSERT INTO sanbur_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","အတသ္တေ ယုၐ္မာန် ယဒျတ် မန္တုမ် အာဇ္ဉာပယန္တိ, တတ် မနျဓွံ ပါလယဓွဉ္စ, ကိန္တု တေၐာံ ကရ္မ္မာနုရူပံ ကရ္မ္မ န ကုရုဓွံ; ယတသ္တေၐာံ ဝါကျမာတြံ သာရံ ကာရျျေ ကိမပိ နာသ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","တေ ဒုရွွဟာန် ဂုရုတရာန် ဘာရာန် ဗဒွွာ မနုၐျာဏာံ သ္ကန္ဓေပရိ သမရ္ပယန္တိ, ကိန္တု သွယမင်္ဂုလျဲကယာပိ န စာလယန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","ကေဝလံ လောကဒရ္ၑနာယ သရွွကရ္မ္မာဏိ ကုရွွန္တိ; ဖလတး ပဋ္ဋဗန္ဓာန် ပြသာရျျ ဓာရယန္တိ, သွဝသ္တြေၐု စ ဒီရ္ဃဂြန္ထီန် ဓာရယန္တိ; ");
INSERT INTO sanbur_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ဘောဇနဘဝန ဥစ္စသ္ထာနံ, ဘဇနဘဝနေ ပြဓာနမာသနံ, ");
INSERT INTO sanbur_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ဟဋ္ဌေ နမသ္ကာရံ ဂုရုရိတိ သမ္ဗောဓနဉ္စဲတာနိ သရွွာဏိ ဝါဉ္ဆန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","ကိန္တု ယူယံ ဂုရဝ ဣတိ သမ္ဗောဓနီယာ မာ ဘဝတ, ယတော ယုၐ္မာကမ် ဧကး ခြီၐ္ဋဧဝ ဂုရု ");
INSERT INTO sanbur_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ရျူယံ သရွွေ မိထော ဘြာတရၑ္စ၊ ပုနး ပၖထိဝျာံ ကမပိ ပိတေတိ မာ သမ္ဗုဓျဓွံ, ယတော ယုၐ္မာကမေကး သွရ္ဂသ္ထဧဝ ပိတာ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","ယူယံ နာယကေတိ သမ္ဘာၐိတာ မာ ဘဝတ, ယတော ယုၐ္မာကမေကး ခြီၐ္ဋဧဝ နာယကး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","အပရံ ယုၐ္မာကံ မဓျေ ယး ပုမာန် ၑြေၐ္ဌး သ ယုၐ္မာန် သေဝိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ယတော ယး သွမုန္နမတိ, သ နတး ကရိၐျတေ; ကိန္တု ယး ကၑ္စိတ် သွမဝနတံ ကရောတိ, သ ဥန္နတး ကရိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","ဟန္တ ကပဋိန ဥပါဓျာယား ဖိရူၑိနၑ္စ, ယူယံ မနုဇာနာံ သမက္ၐံ သွရ္ဂဒွါရံ ရုန္ဓ, ယူယံ သွယံ တေန န ပြဝိၑထ, ပြဝိဝိက္ၐူနပိ ဝါရယထ၊ ဝတ ကပဋိန ဥပါဓျာယား ဖိရူၑိနၑ္စ ယူယံ ဆလာဒ် ဒီရ္ဃံ ပြာရ္ထျ ဝိဓဝါနာံ သရွွသွံ ဂြသထ, ယုၐ္မာကံ ဃောရတရဒဏ္ဍော ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","ဟန္တ ကပဋိန ဥပါဓျာယား ဖိရူၑိနၑ္စ, ယူယမေကံ သွဓရ္မ္မာဝလမ္ဗိနံ ကရ္တ္တုံ သာဂရံ ဘူမဏ္ဍလဉ္စ ပြဒက္ၐိဏီကုရုထ, ");
INSERT INTO sanbur_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","ကဉ္စန ပြာပျ သွတော ဒွိဂုဏနရကဘာဇနံ တံ ကုရုထ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","ဝတ အန္ဓပထဒရ္ၑကား သရွွေ, ယူယံ ဝဒထ, မန္ဒိရသျ ၑပထကရဏာတ် ကိမပိ န ဒေယံ; ကိန္တု မန္ဒိရသ္ထသုဝရ္ဏသျ ၑပထကရဏာဒ် ဒေယံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ဟေ မူဎာ ဟေ အန္ဓား သုဝရ္ဏံ တတ္သုဝရ္ဏပါဝကမန္ဒိရမ် ဧတယောရုဘယော ရ္မဓျေ ကိံ ၑြေယး? ");
INSERT INTO sanbur_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","အနျစ္စ ဝဒထ, ယဇ္ဉဝေဒျား ၑပထကရဏာတ် ကိမပိ န ဒေယံ, ကိန္တု တဒုပရိသ္ထိတသျ နဲဝေဒျသျ ၑပထကရဏာဒ် ဒေယံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ဟေ မူဎာ ဟေ အန္ဓား, နဲဝေဒျံ တန္နဲဝေဒျပါဝကဝေဒိရေတယောရုဘယော ရ္မဓျေ ကိံ ၑြေယး? ");
INSERT INTO sanbur_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","အတး ကေနစိဒ် ယဇ္ဉဝေဒျား ၑပထေ ကၖတေ တဒုပရိသ္ထသျ သရွွသျ ၑပထး ကြိယတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ကေနစိတ် မန္ဒိရသျ ၑပထေ ကၖတေ မန္ဒိရတန္နိဝါသိနေား ၑပထး ကြိယတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ကေနစိတ် သွရ္ဂသျ ၑပထေ ကၖတေ ဤၑွရီယသိံဟာသနတဒုပရျျုပဝိၐ္ဋယေား ၑပထး ကြိယတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","ဟန္တ ကပဋိန ဥပါဓျာယား ဖိရူၑိနၑ္စ, ယူယံ ပေါဒိနာယား သိတစ္ဆတြာယာ ဇီရကသျ စ ဒၑမာံၑာန် ဒတ္ထ, ကိန္တု ဝျဝသ္ထာယာ ဂုရုတရာန် နျာယဒယာဝိၑွာသာန် ပရိတျဇထ; ဣမေ ယုၐ္မာဘိရာစရဏီယာ အမီ စ န လံဃနီယား၊ ");
INSERT INTO sanbur_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ဟေ အန္ဓပထဒရ္ၑကာ ယူယံ မၑကာန် အပသာရယထ, ကိန္တု မဟာင်္ဂါန် ဂြသထ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","ဟန္တ ကပဋိန ဥပါဓျာယား ဖိရူၑိနၑ္စ, ယူယံ ပါနပါတြာဏာံ ဘောဇနပါတြာဏာဉ္စ ဗဟိး ပရိၐ္ကုရုထ; ကိန္တု တဒဘျန္တရံ ဒုရာတ္မတယာ ကလုၐေဏ စ ပရိပူရ္ဏမာသ္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","ဟေ အန္ဓား ဖိရူၑိလောကာ အာဒေါ် ပါနပါတြာဏာံ ဘောဇနပါတြာဏာဉ္စာဘျန္တရံ ပရိၐ္ကုရုတ, တေန တေၐာံ ဗဟိရပိ ပရိၐ္ကာရိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","ဟန္တ ကပဋိန ဥပါဓျာယား ဖိရူၑိနၑ္စ, ယူယံ ၑုက္လီကၖတၑ္မၑာနသွရူပါ ဘဝထ, ယထာ ၑ္မၑာနဘဝနသျ ဗဟိၑ္စာရု, ကိန္တွဘျန္တရံ မၖတလောကာနာံ ကီကၑဲး သရွွပြကာရမလေန စ ပရိပူရ္ဏမ်; ");
INSERT INTO sanbur_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","တထဲဝ ယူယမပိ လောကာနာံ သမက္ၐံ ဗဟိရ္ဓာရ္မ္မိကား ကိန္တွန္တးကရဏေၐု ကေဝလကာပဋျာဓရ္မ္မာဘျာံ ပရိပူရ္ဏား၊ ");
INSERT INTO sanbur_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","ဟာ ဟာ ကပဋိန ဥပါဓျာယား ဖိရူၑိနၑ္စ, ယူယံ ဘဝိၐျဒွါဒိနာံ ၑ္မၑာနဂေဟံ နိရ္မ္မာထ, သာဓူနာံ ၑ္မၑာနနိကေတနံ ၑောဘယထ ");
INSERT INTO sanbur_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ဝဒထ စ ယဒိ ဝယံ သွေၐာံ ပူရွွပုရုၐာဏာံ ကာလ အသ္ထာသျာမ, တရှိ ဘဝိၐျဒွါဒိနာံ ၑောဏိတပါတနေ တေၐာံ သဟဘာဂိနော နာဘဝိၐျာမ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","အတော ယူယံ ဘဝိၐျဒွါဒိဃာတကာနာံ သန္တာနာ ဣတိ သွယမေဝ သွေၐာံ သာက္ၐျံ ဒတ္ထ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","အတော ယူယံ နိဇပူရွွပုရုၐာဏာံ ပရိမာဏပါတြံ ပရိပူရယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","ရေ ဘုဇဂါး ကၖၐ္ဏဘုဇဂဝံၑား, ယူယံ ကထံ နရကဒဏ္ဍာဒ် ရက္ၐိၐျဓွေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","ပၑျတ, ယုၐ္မာကမန္တိကမ် အဟံ ဘဝိၐျဒွါဒိနော ဗုဒ္ဓိမတ ဥပါဓျာယာံၑ္စ ပြေၐယိၐျာမိ, ကိန္တု တေၐာံ ကတိပယာ ယုၐ္မာဘိ ရ္ဃာနိၐျန္တေ, ကြုၑေ စ ဃာနိၐျန္တေ, ကေစိဒ် ဘဇနဘဝနေ ကၐာဘိရာဃာနိၐျန္တေ, နဂရေ နဂရေ တာဍိၐျန္တေ စ; ");
INSERT INTO sanbur_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","တေန သတ္ပုရုၐသျ ဟာဗိလော ရက္တပါတမာရဘျ ဗေရိခိယး ပုတြံ ယံ သိခရိယံ ယူယံ မန္ဒိရယဇ္ဉဝေဒျော ရ္မဓျေ ဟတဝန္တး, တဒီယၑောဏိတပါတံ ယာဝဒ် အသ္မိန် ဒေၑေ ယာဝတာံ သာဓုပုရုၐာဏာံ ၑောဏိတပါတော 'ဘဝတ် တတ် သရွွေၐာမာဂသာံ ဒဏ္ဍာ ယုၐ္မာသု ဝရ္တ္တိၐျန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","အဟံ ယုၐ္မာန္တ တထျံ ဝဒါမိ, ဝိဒျမာနေ'သ္မိန် ပုရုၐေ သရွွေ ဝရ္တ္တိၐျန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","ဟေ ယိရူၑာလမ် ဟေ ယိရူၑာလမ် နဂရိ တွံ ဘဝိၐျဒွါဒိနော ဟတဝတီ, တဝ သမီပံ ပြေရိတာံၑ္စ ပါၐာဏဲရာဟတဝတီ, ယထာ ကုက္ကုဋီ ၑာဝကာန် ပက္ၐာဓး သံဂၖဟ္လာတိ, တထာ တဝ သန္တာနာန် သံဂြဟီတုံ အဟံ ဗဟုဝါရမ် အဲစ္ဆံ; ကိန္တု တွံ န သမမနျထား၊ ");
INSERT INTO sanbur_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ပၑျတ ယၐ္မာကံ ဝါသသ္ထာနမ် ဥစ္ဆိန္နံ တျက္ၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","အဟံ ယုၐ္မာန် တထျံ ဝဒါမိ, ယး ပရမေၑွရသျ နာမ္နာဂစ္ဆတိ, သ ဓနျ ဣတိ ဝါဏီံ ယာဝန္န ဝဒိၐျထ, တာဝတ် မာံ ပုန ရ္န ဒြက္ၐျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","အနန္တရံ ယီၑု ရျဒါ မန္ဒိရာဒ် ဗဟိ ရ္ဂစ္ဆတိ, တဒါနီံ ၑိၐျာသ္တံ မန္ဒိရနိရ္မ္မာဏံ ဒရ္ၑယိတုမာဂတား၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","တတော ယီၑုသ္တာနုဝါစ, ယူယံ ကိမေတာနိ န ပၑျထ? ယုၐ္မာနဟံ သတျံ ဝဒါမိ, ဧတန္နိစယနသျ ပါၐာဏဲကမပျနျပါၐာဏေाပရိ န သ္ထာသျတိ သရွွာဏိ ဘူမိသာတ် ကာရိၐျန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","အနန္တရံ တသ္မိန် ဇဲတုနပရွွတောပရိ သမုပဝိၐ္ဋေ ၑိၐျာသ္တသျ သမီပမာဂတျ ဂုပ္တံ ပပြစ္ဆုး, ဧတာ ဃဋနား ကဒါ ဘဝိၐျန္တိ? ဘဝတ အာဂမနသျ ယုဂါန္တသျ စ ကိံ လက္ၐ္မ? တဒသ္မာန် ဝဒတု၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","တဒါနီံ ယီၑုသ္တာနဝေါစတ်, အဝဓဒွွံ, ကောပိ ယုၐ္မာန် န ဘြမယေတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ဗဟဝေါ မမ နာမ ဂၖဟ္လန္တ အာဂမိၐျန္တိ, ခြီၐ္ဋော'ဟမေဝေတိ ဝါစံ ဝဒန္တော ဗဟူန် ဘြမယိၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","ယူယဉ္စ သံဂြာမသျ ရဏသျ စာဍမ္ဗရံ ၑြောၐျထ, အဝဓဒွွံ တေန စဉ္စလာ မာ ဘဝတ, ဧတာနျဝၑျံ ဃဋိၐျန္တေ, ကိန္တု တဒါ ယုဂါန္တော နဟိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","အပရံ ဒေၑသျ ဝိပက္ၐော ဒေၑော ရာဇျသျ ဝိပက္ၐော ရာဇျံ ဘဝိၐျတိ, သ္ထာနေ သ္ထာနေ စ ဒုရ္ဘိက္ၐံ မဟာမာရီ ဘူကမ္ပၑ္စ ဘဝိၐျန္တိ, ");
INSERT INTO sanbur_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ဧတာနိ ဒုးခေါပကြမား၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","တဒါနီံ လောကာ ဒုးခံ ဘောဇယိတုံ ယုၐ္မာန် ပရကရေၐု သမရ္ပယိၐျန္တိ ဟနိၐျန္တိ စ, တထာ မမ နာမကာရဏာဒ် ယူယံ သရွွဒေၑီယမနုဇာနာံ သမီပေ ဃၖဏာရှာ ဘဝိၐျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","ဗဟုၐု ဝိဃ္နံ ပြာပ္တဝတ္သု ပရသ္ပရမ် ၒृတီယာံ ကၖတဝတ္သု စ ဧကော'ပရံ ပရကရေၐု သမရ္ပယိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","တထာ ဗဟဝေါ မၖၐာဘဝိၐျဒွါဒိန ဥပသ္ထာယ ဗဟူန် ဘြမယိၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","ဒုၐ္ကရ္မ္မဏာံ ဗာဟုလျာဉ္စ ဗဟူနာံ ပြေမ ၑီတလံ ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","ကိန္တု ယး ကၑ္စိတ် ၑေၐံ ယာဝဒ် ဓဲရျျမာၑြယတေ, သဧဝ ပရိတြာယိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","အပရံ သရွွဒေၑီယလောကာန် ပြတိမာက္ၐီ ဘဝိတုံ ရာဇသျ ၑုဘသမာစာရး သရွွဇဂတိ ပြစာရိၐျတေ, ဧတာဒၖၑိ သတိ ယုဂါန္တ ဥပသ္ထာသျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","အတော ယတ် သရွွနာၑကၖဒ္ဃၖဏာရှံ ဝသ္တု ဒါနိယေလ္ဘဝိၐျဒွဒိနာ ပြောက္တံ တဒ် ယဒါ ပုဏျသ္ထာနေ သ္ထာပိတံ ဒြက္ၐျထ, (ယး ပဌတိ, သ ဗုဓျတာံ) ");
INSERT INTO sanbur_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","တဒါနီံ ယေ ယိဟူဒီယဒေၑေ တိၐ္ဌန္တိ, တေ ပရွွတေၐု ပလာယန္တာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ယး ကၑ္စိဒ် ဂၖဟပၖၐ္ဌေ တိၐ္ဌတိ, သ ဂၖဟာတ် ကိမပိ ဝသ္တွာနေတုမ် အဓေा နာဝရောဟေတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ယၑ္စ က္ၐေတြေ တိၐ္ဌတိ, သောပိ ဝသ္တြမာနေတုံ ပရာဝၖတျ န ယာယာတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","တဒါနီံ ဂရ္ဘိဏီသ္တနျပါယယိတြီဏာံ ဒုရ္ဂတိ ရ္ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","အတော ယၐ္မာကံ ပလာယနံ ၑီတကာလေ ဝိၑြာမဝါရေ ဝါ ယန္န ဘဝေတ်, တဒရ္ထံ ပြာရ္ထယဓွမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","အာ ဇဂဒါရမ္ဘာဒ် ဧတတ္ကာလပရျျနန္တံ ယာဒၖၑး ကဒါပိ နာဘဝတ် န စ ဘဝိၐျတိ တာဒၖၑော မဟာက္လေၑသ္တဒါနီမ် ဥပသ္ထာသျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","တသျ က္လေၑသျ သမယော ယဒိ ဟ္သွော န ကြိယေတ, တရှိ ကသျာပိ ပြာဏိနော ရက္ၐဏံ ဘဝိတုံ န ၑက္နုယာတ်, ကိန္တု မနောနီတမနုဇာနာံ ကၖတေ သ ကာလော ဟ္သွီကရိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","အပရဉ္စ ပၑျတ, ခြီၐ္ဋော'တြ ဝိဒျတေ, ဝါ တတြ ဝိဒျတေ, တဒါနီံ ယဒီ ကၑ္စိဒ် ယုၐ္မာန ဣတိ ဝါကျံ ဝဒတိ, တထာပိ တတ် န ပြတီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","ယတော ဘာက္တခြီၐ္ဋာ ဘာက္တဘဝိၐျဒွါဒိနၑ္စ ဥပသ္ထာယ ယာနိ မဟန္တိ လက္ၐ္မာဏိ စိတြကရ္မ္မာဏိ စ ပြကာၑယိၐျန္တိ, တဲ ရျဒိ သမ္ဘဝေတ် တရှိ မနောနီတမာနဝါ အပိ ဘြာမိၐျန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","ပၑျတ, ဃဋနာတး ပူရွွံ ယုၐ္မာန် ဝါရ္တ္တာမ် အဝါဒိၐမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","အတး ပၑျတ, သ ပြာန္တရေ ဝိဒျတ ဣတိ ဝါကျေ ကေနစိတ် ကထိတေပိ ဗဟိ ရ္မာ ဂစ္ဆတ, ဝါ ပၑျတ, သောန္တးပုရေ ဝိဒျတေ, ဧတဒွါကျ ဥက္တေပိ မာ ပြတီတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","ယတော ယထာ ဝိဒျုတ် ပူရွွဒိၑော နိရ္ဂတျ ပၑ္စိမဒိၑံ ယာဝတ် ပြကာၑတေ, တထာ မာနုၐပုတြသျာပျာဂမနံ ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","ယတြ ၑဝသ္တိၐ္ဌတိ, တတြေဝ ဂၖဓြာ မိလန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","အပရံ တသျ က္လေၑသမယသျာဝျဝဟိတပရတြ သူရျျသျ တေဇော လောပ္သျတေ, စန္ဒြမာ ဇျောသ္နာံ န ကရိၐျတိ, နဘသော နက္ၐတြာဏိ ပတိၐျန္တိ, ဂဂဏီယာ ဂြဟာၑ္စ ဝိစလိၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","တဒါနီမ် အာကာၑမဓျေ မနုဇသုတသျ လက္ၐ္မ ဒရ္ၑိၐျတေ, တတော နိဇပရာကြမေဏ မဟာတေဇသာ စ မေဃာရူဎံ မနုဇသုတံ နဘသာဂစ္ဆန္တံ ဝိလောကျ ပၖထိဝျား သရွွဝံၑီယာ ဝိလပိၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","တဒါနီံ သ မဟာၑဗ္ဒာယမာနတူရျျာ ဝါဒကာန် နိဇဒူတာန် ပြဟေၐျတိ, တေ ဝျောမ္န ဧကသီမာတော'ပရသီမာံ ယာဝတ် စတုရ္ဒိၑသ္တသျ မနောနီတဇနာန် အာနီယ မေလယိၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","ဥဍုမ္ဗရပါဒပသျ ဒၖၐ္ဋာန္တံ ၑိက္ၐဓွံ; ယဒါ တသျ နဝီနား ၑာခါ ဇာယန္တေ, ပလ္လဝါဒိၑ္စ နိရ္ဂစ္ဆတိ, တဒါ နိဒါဃကာလး သဝိဓော ဘဝတီတိ ယူယံ ဇာနီထ; ");
INSERT INTO sanbur_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","တဒွဒ် ဧတာ ဃဋနာ ဒၖၐ္ဋွာ သ သမယော ဒွါရ ဥပါသ္ထာဒ် ဣတိ ဇာနီတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","ယုၐ္မာနဟံ တထျံ ဝဒါမိ, ဣဒါနီန္တနဇနာနာံ ဂမနာတ် ပူရွွမေဝ တာနိ သရွွာဏိ ဃဋိၐျန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","နဘောမေဒိနျော ရ္လုပ္တယောရပိ မမ ဝါက် ကဒါပိ န လောပ္သျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","အပရံ မမ တာတံ ဝိနာ မာနုၐး သွရ္ဂသ္ထော ဒူတော ဝါ ကောပိ တဒ္ဒိနံ တဒ္ဒဏ္ဍဉ္စ န ဇ္ဉာပယတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","အပရံ နောဟေ ဝိဒျမာနေ ယာဒၖၑမဘဝတ် တာဒၖၑံ မနုဇသုတသျာဂမနကာလေပိ ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","ဖလတော ဇလာပ္လာဝနာတ် ပူရွွံ ယဒ္ဒိနံ ယာဝတ် နောဟး ပေါတံ နာရောဟတ်, တာဝတ္ကာလံ ယထာ မနုၐျာ ဘောဇနေ ပါနေ ဝိဝဟနေ ဝိဝါဟနေ စ ပြဝၖတ္တာ အာသန်; ");
INSERT INTO sanbur_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","အပရမ် အာပ္လာဝိတောယမာဂတျ ယာဝတ် သကလမနုဇာန် ပ္လာဝယိတွာ နာနယတ်, တာဝတ် တေ ယထာ န ဝိဒါမာသုး, တထာ မနုဇသုတာဂမနေပိ ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","တဒါ က္ၐေတြသ္ထိတယောရ္ဒွယောရေကော ဓာရိၐျတေ, အပရသ္တျာဇိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","တထာ ပေၐဏျာ ပိံၐတျောရုဘယော ရျောၐိတောရေကာ ဓာရိၐျတေ'ပရာ တျာဇိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","ယုၐ္မာကံ ပြဘုး ကသ္မိန် ဒဏ္ဍ အာဂမိၐျတိ, တဒ် ယုၐ္မာဘိ ရ္နာဝဂမျတေ, တသ္မာတ် ဇာဂြတး သန္တသ္တိၐ္ဌတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","ကုတြ ယာမေ သ္တေန အာဂမိၐျတီတိ စေဒ် ဂၖဟသ္ထော ဇ္ဉာတုမ် အၑက္ၐျတ်, တရှိ ဇာဂရိတွာ တံ သန္ဓိံ ကရ္တ္တိတုမ် အဝါရယိၐျတ် တဒ် ဇာနီတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","ယုၐ္မာဘိရဝဓီယတာံ, ယတော ယုၐ္မာဘိ ရျတြ န ဗုဓျတေ, တတြဲဝ ဒဏ္ဍေ မနုဇသုတ အာယာသျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","ပြဘု ရ္နိဇပရိဝါရာန် ယထာကာလံ ဘောဇယိတုံ ယံ ဒါသမ် အဓျက္ၐီကၖတျ သ္ထာပယတိ, တာဒၖၑော ဝိၑွာသျော ဓီမာန် ဒါသး ကး? ");
INSERT INTO sanbur_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ပြဘုရာဂတျ ယံ ဒါသံ တထာစရန္တံ ဝီက္ၐတေ, သဧဝ ဓနျး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","ယုၐ္မာနဟံ သတျံ ဝဒါမိ, သ တံ နိဇသရွွသွသျာဓိပံ ကရိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","ကိန္တု ပြဘုရာဂန္တုံ ဝိလမ္ဗတ ဣတိ မနသိ စိန္တယိတွာ ယော ဒုၐ္ဋော ဒါသော ");
INSERT INTO sanbur_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","'ပရဒါသာန် ပြဟရ္တ္တုံ မတ္တာနာံ သင်္ဂေ ဘောက္တုံ ပါတုဉ္စ ပြဝရ္တ္တတေ, ");
INSERT INTO sanbur_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","သ ဒါသော ယဒါ နာပေက္ၐတေ, ယဉ္စ ဒဏ္ဍံ န ဇာနာတိ, တတ္ကာလဧဝ တတ္ပြဘုရုပသ္ထာသျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","တဒါ တံ ဒဏ္ဍယိတွာ ယတြ သ္ထာနေ ရောဒနံ ဒန္တဃရ္ၐဏဉ္စာသာတေ, တတြ ကပဋိဘိး သာကံ တဒ္ဒၑာံ နိရူပယိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","ယာ ဒၑ ကနျား ပြဒီပါန် ဂၖဟ္လတျော ဝရံ သာက္ၐာတ် ကရ္တ္တုံ ဗဟိရိတား, တာဘိသ္တဒါ သွရ္ဂီယရာဇျသျ သာဒၖၑျံ ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","တာသာံ ကနျာနာံ မဓျေ ပဉ္စ သုဓိယး ပဉ္စ ဒုရ္ဓိယ အာသန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ယာ ဒုရ္ဓိယသ္တား ပြဒီပါန် သင်္ဂေ ဂၖဟီတွာ တဲလံ န ဇဂၖဟုး, ");
INSERT INTO sanbur_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ကိန္တု သုဓိယး ပြဒီပါန် ပါတြေဏ တဲလဉ္စ ဇဂၖဟုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","အနန္တရံ ဝရေ ဝိလမ္ဗိတေ တား သရွွာ နိဒြာဝိၐ္ဋာ နိဒြာံ ဇဂ္မုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","အနန္တရမ် အရ္ဒ္ဓရာတြေ ပၑျတ ဝရ အာဂစ္ဆတိ, တံ သာက္ၐာတ် ကရ္တ္တုံ ဗဟိရျာတေတိ ဇနရဝါတ္ ");
INSERT INTO sanbur_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","တား သရွွား ကနျာ ဥတ္ထာယ ပြဒီပါန် အာသာဒယိတုံ အာရဘန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","တတော ဒုရ္ဓိယး သုဓိယ ဦစုး, ကိဉ္စိတ် တဲလံ ဒတ္တ, ပြဒီပါ အသ္မာကံ နိရွွာဏား၊ ");
INSERT INTO sanbur_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","ကိန္တု သုဓိယး ပြတျဝဒန်, ဒတ္တေ ယုၐ္မာနသ္မာံၑ္စ ပြတိ တဲလံ နျူနီဘဝေတ်, တသ္မာဒ် ဝိကြေတၖဏာံ သမီပံ ဂတွာ သွာရ္ထံ တဲလံ ကြီဏီတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","တဒါ တာသု ကြေတုံ ဂတာသု ဝရ အာဇဂါမ, တတော ယား သဇ္ဇိတာ အာသန်, တာသ္တေန သာကံ ဝိဝါဟီယံ ဝေၑ္မ ပြဝိဝိၑုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","အနန္တရံ ဒွါရေ ရုဒ္ဓေ အပရား ကနျာ အာဂတျ ဇဂဒုး, ဟေ ပြဘော, ဟေ ပြဘော, အသ္မာန် ပြတိ ဒွါရံ မောစယ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","ကိန္တု သ ဥက္တဝါန်, တထျံ ဝဒါမိ, ယုၐ္မာနဟံ န ဝေဒ္မိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","အတော ဇာဂြတး သန္တသ္တိၐ္ဌတ, မနုဇသုတး ကသ္မိန် ဒိနေ ကသ္မိန် ဒဏ္ဍေ ဝါဂမိၐျတိ, တဒ် ယုၐ္မာဘိ ရ္န ဇ္ဉာယတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","အပရံ သ ဧတာဒၖၑး ကသျစိတ် ပုံသသ္တုလျး, ယော ဒူရဒေၑံ ပြတိ ယာတြာကာလေ နိဇဒါသာန် အာဟူယ တေၐာံ သွသွသာမရ္ထျာနုရူပမ္ ");
INSERT INTO sanbur_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ဧကသ္မိန် မုဒြာဏာံ ပဉ္စ ပေါဋလိကား အနျသ္မိံၑ္စ ဒွေ ပေါဋလိကေ အပရသ္မိံၑ္စ ပေါဋလိကဲကာမ် ဣတ္ထံ ပြတိဇနံ သမရ္ပျ သွယံ ပြဝါသံ ဂတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","အနန္တရံ ယော ဒါသး ပဉ္စ ပေါဋလိကား လဗ္ဓဝါန်, သ ဂတွာ ဝါဏိဇျံ ဝိဓာယ တာ ဒွိဂုဏီစကာရ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ယၑ္စ ဒါသော ဒွေ ပေါဋလိကေ အလဘတ, သောပိ တာ မုဒြာ ဒွိဂုဏီစကာရ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","ကိန္တု ယော ဒါသ ဧကာံ ပေါဋလိကာံ လဗ္ဓဝါန်, သ ဂတွာ ဘူမိံ ခနိတွာ တန္မဓျေ နိဇပြဘောသ္တာ မုဒြာ ဂေါပယာဉ္စကာရ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","တဒနန္တရံ ဗဟုတိထေ ကာလေ ဂတေ တေၐာံ ဒါသာနာံ ပြဘုရာဂတျ တဲရ္ဒာသဲး သမံ ဂဏယာဉ္စကာရ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","တဒါနီံ ယး ပဉ္စ ပေါဋလိကား ပြာပ္တဝါန် သ တာ ဒွိဂုဏီကၖတမုဒြာ အာနီယ ဇဂါဒ; ဟေ ပြဘော, ဘဝတာ မယိ ပဉ္စ ပေါဋလိကား သမရ္ပိတား, ပၑျတု, တာ မယာ ဒွိဂုဏီကၖတား၊ ");
INSERT INTO sanbur_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","တဒါနီံ တသျ ပြဘုသ္တမုဝါစ, ဟေ ဥတ္တမ ဝိၑွာသျ ဒါသ, တွံ ဓနျောသိ, သ္တောကေန ဝိၑွာသျော ဇာတး, တသ္မာတ် တွာံ ဗဟုဝိတ္တာဓိပံ ကရောမိ, တွံ သွပြဘေား သုခသျ ဘာဂီ ဘဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","တတော ယေန ဒွေ ပေါဋလိကေ လဗ္ဓေ သောပျာဂတျ ဇဂါဒ, ဟေ ပြဘော, ဘဝတာ မယိ ဒွေ ပေါဋလိကေ သမရ္ပိတေ, ပၑျတု တေ မယာ ဒွိဂုဏီကၖတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","တေန တသျ ပြဘုသ္တမဝေါစတ်, ဟေ ဥတ္တမ ဝိၑွာသျ ဒါသ, တွံ ဓနျောသိ, သ္တောကေန ဝိၑွာသျော ဇာတး, တသ္မာတ် တွာံ ဗဟုဒြဝိဏာဓိပံ ကရောမိ, တွံ နိဇပြဘေား သုခသျ ဘာဂီ ဘဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","အနန္တရံ ယ ဧကာံ ပေါဋလိကာံ လဗ္ဓဝါန်, သ ဧတျ ကထိတဝါန်, ဟေ ပြဘော, တွာံ ကဌိနနရံ ဇ္ဉာတဝါန်, တွယာ ယတြ နောပ္တံ, တတြဲဝ ကၖတျတေ, ယတြ စ န ကီရ္ဏံ, တတြဲဝ သံဂၖဟျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","အတောဟံ သၑင်္ကး သန် ဂတွာ တဝ မုဒြာ ဘူမဓျေ သံဂေါပျ သ္ထာပိတဝါန်, ပၑျ, တဝ ယတ် တဒေဝ ဂၖဟာဏ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","တဒါ တသျ ပြဘုး ပြတျဝဒတ် ရေ ဒုၐ္ဋာလသ ဒါသ, ယတြာဟံ န ဝပါမိ, တတြ ဆိနဒ္မိ, ယတြ စ န ကိရာမိ, တတြေဝ သံဂၖဟ္လာမီတိ စေဒဇာနာသ္တရှိ ");
INSERT INTO sanbur_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ဝဏိက္ၐု မမ ဝိတ္တာရ္ပဏံ တဝေါစိတမာသီတ်, ယေနာဟမာဂတျ ဝၖဒွျာ သာကံ မူလမုဒြား ပြာပ္သျမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","အတောသ္မာတ် တာံ ပေါဋလိကာမ် အာဒါယ ယသျ ဒၑ ပေါဋလိကား သန္တိ တသ္မိန္နရ္ပယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","ယေန ဝရ္ဒွျတေ တသ္မိန္နဲဝါရ္ပိၐျတေ, တသျဲဝ စ ဗာဟုလျံ ဘဝိၐျတိ, ကိန္တု ယေန န ဝရ္ဒွျတေ, တသျာန္တိကေ ယတ် ကိဉ္စန တိၐ္ဌတိ, တဒပိ ပုနရ္နေၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","အပရံ ယူယံ တမကရ္မ္မဏျံ ဒါသံ နီတွာ ယတြ သ္ထာနေ ကြန္ဒနံ ဒန္တဃရ္ၐဏဉ္စ ဝိဒျေတေ, တသ္မိန် ဗဟိရ္ဘူတတမသိ နိက္ၐိပတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","ယဒါ မနုဇသုတး ပဝိတြဒူတာန် သင်္ဂိနး ကၖတွာ နိဇပြဘာဝေနာဂတျ နိဇတေဇောမယေ သိံဟာသနေ နိဝေက္ၐျတိ, ");
INSERT INTO sanbur_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","တဒါ တတ္သမ္မုခေ သရွွဇာတီယာ ဇနာ သံမေလိၐျန္တိ၊ တတော မေၐပါလကော ယထာ ဆာဂေဘျော'ဝီန် ပၖထက် ကရောတိ တထာ သောပျေကသ္မာဒနျမ် ဣတ္ထံ တာန် ပၖထက ကၖတွာဝီန္ ");
INSERT INTO sanbur_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ဒက္ၐိဏေ ဆာဂါံၑ္စ ဝါမေ သ္ထာပယိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","တတး ပရံ ရာဇာ ဒက္ၐိဏသ္ထိတာန် မာနဝါန် ဝဒိၐျတိ, အာဂစ္ဆတ မတ္တာတသျာနုဂြဟဘာဇနာနိ, ယုၐ္မတ္ကၖတ အာ ဇဂဒါရမ္ဘတ် ယဒ် ရာဇျမ် အာသာဒိတံ တဒဓိကုရုတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","ယတော ဗုဘုက္ၐိတာယ မဟျံ ဘောဇျမ် အဒတ္တ, ပိပါသိတာယ ပေယမဒတ္တ, ဝိဒေၑိနံ မာံ သွသ္ထာနမနယတ, ");
INSERT INTO sanbur_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ဝသ္တြဟီနံ မာံ ဝသနံ ပရျျဓာပယတ, ပီဍီတံ မာံ ဒြၐ္ဋုမာဂစ္ဆတ, ကာရာသ္ထဉ္စ မာံ ဝီက္ၐိတုမ အာဂစ္ဆတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","တဒါ ဓာရ္မ္မိကား ပြတိဝဒိၐျန္တိ, ဟေ ပြဘော, ကဒါ တွာံ က္ၐုဓိတံ ဝီက္ၐျ ဝယမဘောဇယာမ? ဝါ ပိပါသိတံ ဝီက္ၐျ အပါယယာမ? ");
INSERT INTO sanbur_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ကဒါ ဝါ တွာံ ဝိဒေၑိနံ ဝိလောကျ သွသ္ထာနမနယာမ? ကဒါ ဝါ တွာံ နဂ္နံ ဝီက္ၐျ ဝသနံ ပရျျဓာပယာမ? ");
INSERT INTO sanbur_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ကဒါ ဝါ တွာံ ပီဍိတံ ကာရာသ္ထဉ္စ ဝီက္ၐျ တွဒန္တိကမဂစ္ဆာမ? ");
INSERT INTO sanbur_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","တဒါနီံ ရာဇာ တာန် ပြတိဝဒိၐျတိ, ယုၐ္မာနဟံ သတျံ ဝဒါမိ, မမဲတေၐာံ ဘြာတၖဏာံ မဓျေ ကဉ္စနဲကံ က္ၐုဒြတမံ ပြတိ ယဒ် အကုရုတ, တန္မာံ ပြတျကုရုတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","ပၑ္စာတ် သ ဝါမသ္ထိတာန် ဇနာန် ဝဒိၐျတိ, ရေ ၑာပဂြသ္တား သရွွေ, ၑဲတာနေ တသျ ဒူတေဘျၑ္စ ယော'နန္တဝဟ္နိရာသာဒိတ အာသ္တေ, ယူယံ မဒန္တိကာတ် တမဂ္နိံ ဂစ္ဆတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ယတော က္ၐုဓိတာယ မဟျမာဟာရံ နာဒတ္တ, ပိပါသိတာယ မဟျံ ပေယံ နာဒတ္တ, ");
INSERT INTO sanbur_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ဝိဒေၑိနံ မာံ သွသ္ထာနံ နာနယတ, ဝသနဟီနံ မာံ ဝသနံ န ပရျျဓာပယတ, ပီဍိတံ ကာရာသ္ထဉ္စ မာံ ဝီက္ၐိတုံ နာဂစ္ဆတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","တဒါ တေ ပြတိဝဒိၐျန္တိ, ဟေ ပြဘော, ကဒါ တွာံ က္ၐုဓိတံ ဝါ ပိပါသိတံ ဝါ ဝိဒေၑိနံ ဝါ နဂ္နံ ဝါ ပီဍိတံ ဝါ ကာရာသ္ထံ ဝီက္ၐျ တွာံ နာသေဝါမဟိ? ");
INSERT INTO sanbur_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","တဒါ သ တာန် ဝဒိၐျတိ, တထျမဟံ ယုၐ္မာန် ဗြဝီမိ, ယုၐ္မာဘိရေၐာံ ကဉ္စန က္ၐောဒိၐ္ဌံ ပြတိ ယန္နာကာရိ, တန္မာံ ပြတျေဝ နာကာရိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","ပၑ္စာဒမျနန္တၑာသ္တိံ ကိန္တု ဓာရ္မ္မိကာ အနန္တာယုၐံ ဘောက္တုံ ယာသျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","ယီၑုရေတာန် ပြသ္တာဝါန် သမာပျ ၑိၐျာနူစေ, ");
INSERT INTO sanbur_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","ယုၐ္မာဘိ ရ္ဇ္ဉာတံ ဒိနဒွယာတ် ပရံ နိသ္တာရမဟ ဥပသ္ထာသျတိ, တတြ မနုဇသုတး ကြုၑေန ဟန္တုံ ပရကရေၐု သမရ္ပိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","တတး ပရံ ပြဓာနယာဇကာဓျာပကပြာဉ္စး ကိယဖာနာမ္နော မဟာယာဇကသျာဋ္ဋာလိကာယာံ မိလိတွာ ");
INSERT INTO sanbur_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ကေနောပါယေန ယီၑုံ ဓၖတွာ ဟန္တုံ ၑက္နုယုရိတိ မန္တြယာဉ္စကြုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","ကိန္တု တဲရုက္တံ မဟကာလေ န ဓရ္တ္တဝျး, ဓၖတေ ပြဇာနာံ ကလဟေန ဘဝိတုံ ၑကျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","တတော ဗဲထနိယာပုရေ ၑိမောနာချသျ ကုၐ္ဌိနော ဝေၑ္မနိ ယီၑော် တိၐ္ဌတိ ");
INSERT INTO sanbur_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ကာစန ယောၐာ ၑွေတောပလဘာဇနေန မဟာရ္ဃျံ သုဂန္ဓိ တဲလမာနီယ ဘောဇနာယောပဝိၑတသ္တသျ ၑိရောဘျၐေစတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","ကိန္တု တဒါလောကျ တစ္ဆိၐျဲး ကုပိတဲရုက္တံ, ကုတ ဣတ္ထမပဝျယတေ? ");
INSERT INTO sanbur_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","စေဒိဒံ ဝျကြေၐျတ, တရှိ ဘူရိမူလျံ ပြာပျ ဒရိဒြေဘျော ဝျတာရိၐျတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","ယီၑုနာ တဒဝဂတျ တေ သမုဒိတား, ယောၐာမေနာံ ကုတော ဒုးခိနီံ ကုရုထ, သာ မာံ ပြတိ သာဓု ကရ္မ္မာကာရ္ၐီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","ယုၐ္မာကမံ သမီပေ ဒရိဒြား သတတမေဝါသတေ, ကိန္တု ယုၐ္မာကမန္တိကေဟံ နာသေ သတတံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","သာ မမ ကာယောပရိ သုဂန္ဓိတဲလံ သိက္တွာ မမ ၑ္မၑာနဒါနကရ္မ္မာကာရ္ၐီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","အတောဟံ ယုၐ္မာန် တထျံ ဝဒါမိ သရွွသ္မိန် ဇဂတိ ယတြ ယတြဲၐ သုသမာစာရး ပြစာရိၐျတေ, တတြ တတြဲတသျာ နာရျျား သ္မရဏာရ္ထမ် ကရ္မ္မေဒံ ပြစာရိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","တတော ဒွါဒၑၑိၐျာဏာမ် ဤၐ္ကရိယောတီယယိဟူဒါနာမက ဧကး ၑိၐျး ပြဓာနယာဇကာနာမန္တိကံ ဂတွာ ကထိတဝါန်, ");
INSERT INTO sanbur_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ယဒိ ယုၐ္မာကံ ကရေၐု ယီၑုံ သမရ္ပယာမိ, တရှိ ကိံ ဒါသျထ? တဒါနီံ တေ တသ္မဲ တြိံၑန္မုဒြာ ဒါတုံ သ္ထိရီကၖတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","သ တဒါရဘျ တံ ပရကရေၐု သမရ္ပယိတုံ သုယောဂံ စေၐ္ဋိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","အနန္တရံ ကိဏွၑူနျပူပပရွွဏး ပြထမေဟ္နိ ၑိၐျာ ယီၑုမ် ဥပဂတျ ပပြစ္ဆုး ဘဝတ္ကၖတေ ကုတြ ဝယံ နိသ္တာရမဟဘောဇျမ် အာယောဇယိၐျာမး? ဘဝတး ကေစ္ဆာ? ");
INSERT INTO sanbur_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","တဒါ သ ဂဒိတဝါန်, မဓျေနဂရမမုကပုံသး သမီပံ ဝြဇိတွာ ဝဒတ, ဂုရု ရ္ဂဒိတဝါန်, မတ္ကာလး သဝိဓး, သဟ ၑိၐျဲသ္တွဒါလယေ နိသ္တာရမဟဘောဇျံ ဘောက္ၐျေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","တဒါ ၑိၐျာ ယီၑောသ္တာဒၖၑနိဒေၑာနုရူပကရ္မ္မ ဝိဓာယ တတြ နိသ္တာရမဟဘောဇျမာသာဒယာမာသုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","တတး သန္ဓျာယာံ သတျာံ ဒွါဒၑဘိး ၑိၐျဲး သာကံ သ နျဝိၑတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","အပရံ ဘုဉ္ဇာန ဥက္တဝါန် ယုၐ္မာန် တထျံ ဝဒါမိ, ယုၐ္မာကမေကော မာံ ပရကရေၐု သမရ္ပယိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","တဒါ တေ'တီဝ ဒုးခိတာ ဧကဲကၑော ဝက္တုမာရေဘိရေ, ဟေ ပြဘော, သ ကိမဟံ? ");
INSERT INTO sanbur_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","တတး သ ဇဂါဒ, မယာ သာကံ ယော ဇနော ဘောဇနပါတြေ ကရံ သံက္ၐိပတိ, သ ဧဝ မာံ ပရကရေၐု သမရ္ပယိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","မနုဇသုတမဓိ ယာဒၖၑံ လိခိတမာသ္တေ, တဒနုရူပါ တဒ္ဂတိ ရ္ဘဝိၐျတိ; ကိန္တု ယေန ပုံသာ သ ပရကရေၐု သမရ္ပယိၐျတေ, ဟာ ဟာ စေတ် သ နာဇနိၐျတ, တဒါ တသျ က္ၐေမမဘဝိၐျတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","တဒါ ယိဟူဒါနာမာ ယော ဇနသ္တံ ပရကရေၐု သမရ္ပယိၐျတိ, သ ဥက္တဝါန်, ဟေ ဂုရော, သ ကိမဟံ? တတး သ ပြတျုက္တဝါန်, တွယာ သတျံ ဂဒိတမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","အနန္တရံ တေၐာမၑနကာလေ ယီၑုး ပူပမာဒါယေၑွရီယဂုဏာနနူဒျ ဘံက္တွာ ၑိၐျေဘျး ပြဒါယ ဇဂါဒ, မဒွပုးသွရူပမိမံ ဂၖဟီတွာ ခါဒတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ပၑ္စာတ် သ ကံသံ ဂၖဟ္လန် ဤၑွရီယဂုဏာနနူဒျ တေဘျး ပြဒါယ ကထိတဝါန်, သရွွဲ ရျုၐ္မာဘိရနေန ပါတဝျံ, ");
INSERT INTO sanbur_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ယသ္မာဒနေကေၐာံ ပါပမရ္ၐဏာယ ပါတိတံ ယန္မန္နူတ္နနိယမရူပၑောဏိတံ တဒေတတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","အပရမဟံ နူတ္နဂေါသ္တနီရသံ န ပါသျာမိ, တာဝတ် ဂေါသ္တနီဖလရသံ ပုနး ကဒါပိ န ပါသျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ပၑ္စာတ် တေ ဂီတမေကံ သံဂီယ ဇဲတုနာချဂိရိံ ဂတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","တဒါနီံ ယီၑုသ္တာနဝေါစတ်, အသျာံ ရဇနျာမဟံ ယုၐ္မာကံ သရွွေၐာံ ဝိဃ္နရူပေါ ဘဝိၐျာမိ, ယတော လိခိတမာသ္တေ, \"မေၐာဏာံ ရက္ၐကော ယသ္တံ ပြဟရိၐျာမျဟံ တတး၊ မေၐာဏာံ နိဝဟော နူနံ ပြဝိကီရ္ဏော ဘဝိၐျတိ\"။ ");
INSERT INTO sanbur_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","ကိန္တု ၑ္မၑာနာတ် သမုတ္ထာယ ယုၐ္မာကမဂြေ'ဟံ ဂါလီလံ ဂမိၐျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","ပိတရသ္တံ ပြောဝါစ, ဘဝါံၑ္စေတ် သရွွေၐာံ ဝိဃ္နရူပေါ ဘဝတိ, တထာပိ မမ န ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","တတော ယီၑုနာ သ ဥက္တး, တုဘျမဟံ တထျံ ကထယာမိ, ယာမိနျာမသျာံ စရဏာယုဓသျ ရဝါတ် ပူရွွံ တွံ မာံ တြိ ရ္နာင်္ဂီကရိၐျသိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","တတး ပိတရ ဥဒိတဝါန်, ယဒျပိ တွယာ သမံ မရ္တ္တဝျံ, တထာပိ ကဒါပိ တွာံ န နာင်္ဂီကရိၐျာမိ; တထဲဝ သရွွေ ၑိၐျာၑ္စောစုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","အနန္တရံ ယီၑုး ၑိၐျဲး သာကံ ဂေတ္ၑိမာနီနာမကံ သ္ထာနံ ပြသ္ထာယ တေဘျး ကထိတဝါန်, အဒး သ္ထာနံ ဂတွာ ယာဝဒဟံ ပြာရ္ထယိၐျေ တာဝဒ် ယူယမတြောပဝိၑတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ပၑ္စာတ် သ ပိတရံ သိဝဒိယသုတော် စ သင်္ဂိနး ကၖတွာ ဂတဝါန်, ၑောကာကုလော'တီဝ ဝျထိတၑ္စ ဗဘူဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","တာနဝါဒီစ္စ မၖတိယာတနေဝ မတ္ပြာဏာနာံ ယာတနာ ဇာယတေ, ယူယမတြ မယာ သာရ္ဒ္ဓံ ဇာဂၖတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","တတး သ ကိဉ္စိဒ္ဒူရံ ဂတွာဓောမုခး ပတန် ပြာရ္ထယာဉ္စကြေ, ဟေ မတ္ပိတရျဒိ ဘဝိတုံ ၑက္နောတိ, တရှိ ကံသော'ယံ မတ္တော ဒူရံ ယာတု; ကိန္တု မဒိစ္ဆာဝတ် န ဘဝတု, တွဒိစ္ဆာဝဒ် ဘဝတု၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","တတး သ ၑိၐျာနုပေတျ တာန် နိဒြတော နိရီက္ၐျ ပိတရာယ ကထယာမာသ, ယူယံ မယာ သာကံ ဒဏ္ဍမေကမပိ ဇာဂရိတုံ နာၑန္ကုတ? ");
INSERT INTO sanbur_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","ပရီက္ၐာယာံ န ပတိတုံ ဇာဂၖတ ပြာရ္ထယဓွဉ္စ; အာတ္မာ သမုဒျတောသ္တိ, ကိန္တု ဝပု ရ္ဒုရ္ဗ္ဗလံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","သ ဒွိတီယဝါရံ ပြာရ္ထယာဉ္စကြေ, ဟေ မတ္တာတ, န ပီတေ ယဒိ ကံသမိဒံ မတ္တော ဒူရံ ယာတုံ န ၑက္နောတိ, တရှိ တွဒိစ္ဆာဝဒ် ဘဝတု၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","သ ပုနရေတျ တာန် နိဒြတော ဒဒရ္ၑ, ယတသ္တေၐာံ နေတြာဏိ နိဒြယာ ပူရ္ဏာနျာသန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ပၑ္စာတ် သ တာန် ဝိဟာယ ဝြဇိတွာ တၖတီယဝါရံ ပူရွွဝတ် ကထယန် ပြာရ္ထိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","တတး ၑိၐျာနုပါဂတျ ဂဒိတဝါန်, သာမ္ပြတံ ၑယာနား ကိံ ဝိၑြာမျထ? ပၑျတ, သမယ ဥပါသ္ထာတ်, မနုဇသုတး ပါပိနာံ ကရေၐု သမရ္ပျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ဥတ္တိၐ္ဌတ, ဝယံ ယာမး, ယော မာံ ပရကရေၐု မသရ္ပယိၐျတိ, ပၑျတ, သ သမီပမာယာတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ဧတတ္ကထာကထနကာလေ ဒွါဒၑၑိၐျာဏာမေကော ယိဟူဒါနာမကော မုချယာဇကလောကပြာစီနဲး ပြဟိတာန် အသိဓာရိယၐ္ဋိဓာရိဏော မနုဇာန် ဂၖဟီတွာ တတ္သမီပမုပတသ္ထော်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","အသော် ပရကရေၐွရ္ပယိတာ ပူရွွံ တာန် ဣတ္ထံ သင်္ကေတယာမာသ, ယမဟံ စုမ္ဗိၐျေ, သော'သော် မနုဇး,သဧဝ ယုၐ္မာဘိ ရ္ဓာရျျတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","တဒါ သ သပဒိ ယီၑုမုပါဂတျ ဟေ ဂုရော, ပြဏမာမီတျုက္တွာ တံ စုစုမ္ဗေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","တဒါ ယီၑုသ္တမုဝါစ, ဟေ မိတြံ ကိမရ္ထမာဂတောသိ? တဒါ တဲရာဂတျ ယီၑုရာကြမျ ဒဃြေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","တတော ယီၑေား သင်္ဂိနာမေကး ကရံ ပြသာရျျ ကောၐာဒသိံ ဗဟိၐ္ကၖတျ မဟာယာဇကသျ ဒါသမေကမာဟတျ တသျ ကရ္ဏံ စိစ္ဆေဒ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","တတော ယီၑုသ္တံ ဇဂါဒ, ခဍ္ဂံ သွသ္ထာနေे နိဓေဟိ ယတော ယေ ယေ ဇနာ အသိံ ဓာရယန္တိ, တဧဝါသိနာ ဝိနၑျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","အပရံ ပိတာ ယထာ မဒန္တိကံ သွရ္ဂီယဒူတာနာံ ဒွါဒၑဝါဟိနီတော'ဓိကံ ပြဟိဏုယာတ် မယာ တမုဒ္ဒိၑျေဒါနီမေဝ တထာ ပြာရ္ထယိတုံ န ၑကျတေ, တွယာ ကိမိတ္ထံ ဇ္ဉာယတေ? ");
INSERT INTO sanbur_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","တထာ သတီတ္ထံ ဃဋိၐျတေ ဓရ္မ္မပုသ္တကသျ ယဒိဒံ ဝါကျံ တတ် ကထံ သိဓျေတ်? ");
INSERT INTO sanbur_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","တဒါနီံ ယီၑု ရ္ဇနနိဝဟံ ဇဂါဒ, ယူယံ ခဍ္ဂယၐ္ဋီန် အာဒါယ မာံ ကိံ စော်ရံ ဓရ္တ္တုမာယာတား? အဟံ ပြတျဟံ ယုၐ္မာဘိး သာကမုပဝိၑျ သမုပါဒိၑံ, တဒါ မာံ နာဓရတ; ");
INSERT INTO sanbur_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","ကိန္တု ဘဝိၐျဒွါဒိနာံ ဝါကျာနာံ သံသိဒ္ဓယေ သရွွမေတဒဘူတ်၊ တဒါ သရွွေ ၑိၐျာသ္တံ ဝိဟာယ ပလာယန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","အနန္တရံ တေ မနုဇာ ယီၑုံ ဓၖတွာ ယတြာဓျာပကပြာဉ္စး ပရိၐဒံ ကုရွွန္တ ဥပါဝိၑန် တတြ ကိယဖာနာाမကမဟာယာဇကသျာန္တိကံ နိနျုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","ကိန္တု ၑေၐေ ကိံ ဘဝိၐျတီတိ ဝေတ္တုံ ပိတရော ဒူရေ တတ္ပၑ္စာဒ် ဝြဇိတွာ မဟာယာဇကသျာဋ္ဋာလိကာံ ပြဝိၑျ ဒါသဲး သဟိတ ဥပါဝိၑတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","တဒါနီံ ပြဓာနယာဇကပြာစီနမန္တြိဏး သရွွေ ယီၑုံ ဟန္တုံ မၖၐာသာက္ၐျမ် အလိပ္သန္တ, ");
INSERT INTO sanbur_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ကိန္တု န လေဘိရေ၊ အနေကေၐု မၖၐာသာက္ၐိၐွာဂတေၐွပိ တန္န ပြာပုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ၑေၐေ ဒွေါ် မၖၐာသာက္ၐိဏာဝါဂတျ ဇဂဒတုး, ပုမာနယမကထယတ်, အဟမီၑွရမန္ဒိရံ ဘံက္တွာ ဒိနတြယမဓျေ တန္နိရ္မ္မာတုံ ၑက္နောမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","တဒါ မဟာယာဇက ဥတ္ထာယ ယီၑုမ် အဝါဒီတ်၊ တွံ ကိမပိ န ပြတိဝဒသိ? တွာမဓိ ကိမေတေ သာက္ၐျံ ဝဒန္တိ? ");
INSERT INTO sanbur_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","ကိန္တု ယီၑု ရ္မော်နီဘူယ တသျော်၊ တတော မဟာယာဇက ဥက္တဝါန်, တွာမ် အမရေၑွရနာမ္နာ ၑပယာမိ, တွမီၑွရသျ ပုတြော'ဘိၐိက္တော ဘဝသိ နဝေတိ ဝဒ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","ယီၑုး ပြတျဝဒတ်, တွံ သတျမုက္တဝါန်; အဟံ ယုၐ္မာန် တထျံ ဝဒါမိ, ဣတးပရံ မနုဇသုတံ သရွွၑက္တိမတော ဒက္ၐိဏပါရ္ၑွေ သ္ထာတုံ ဂဂဏသ္ထံ ဇလဓရာနာရုဟျာယာန္တံ ဝီက္ၐဓွေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","တဒါ မဟာယာဇကော နိဇဝသနံ ဆိတ္တွာ ဇဂါဒ, ဧၐ ဤၑွရံ နိန္ဒိတဝါန်, အသ္မာကမပရသာက္ၐျေဏ ကိံ ပြယောဇနံ? ပၑျတ, ယူယမေဝါသျာသျာဒ် ဤၑွရနိန္ဒာံ ၑြုတဝန္တး, ");
INSERT INTO sanbur_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","ယုၐ္မာဘိး ကိံ ဝိဝိစျတေ? တေ ပြတျူစုး, ဝဓာရှော'ယံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","တတော လောကဲသ္တဒါသျေ နိၐ္ဌီဝိတံ ကေစိတ် ပြတလမာဟတျ ကေစိစ္စ စပေဋမာဟတျ ဗဘာၐိရေ, ");
INSERT INTO sanbur_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ဟေ ခြီၐ္ဋ တွာံ ကၑ္စပေဋမာဟတဝါန်? ဣတိ ဂဏယိတွာ ဝဒါသ္မာန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","ပိတရော ဗဟိရင်္ဂန ဥပဝိၑတိ, တဒါနီမေကာ ဒါသီ တမုပါဂတျ ဗဘာၐေ, တွံ ဂါလီလီယယီၑေား သဟစရဧကး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","ကိန္တု သ သရွွေၐာံ သမက္ၐမ် အနင်္ဂီကၖတျာဝါဒီတ်, တွယာ ယဒုစျတေ, တဒရ္ထမဟံ န ဝေဒ္မိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","တဒါ တသ္မိန် ဗဟိရ္ဒွါရံ ဂတေ 'နျာ ဒါသီ တံ နိရီက္ၐျ တတြတျဇနာနဝဒတ်, အယမပိ နာသရတီယယီၑုနာ သာရ္ဒ္ဓမ် အာသီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","တတး သ ၑပထေန ပုနရနင်္ဂီကၖတျ ကထိတဝါန်, တံ နရံ န ပရိစိနောမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","က္ၐဏာတ် ပရံ တိၐ္ဌန္တော ဇနာ ဧတျ ပိတရမ် အဝဒန်, တွမဝၑျံ တေၐာမေက ဣတိ တွဒုစ္စာရဏမေဝ ဒျောတယတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","ကိန္တု သော'ဘိၑပျ ကထိတဝါန်, တံ ဇနံ နာဟံ ပရိစိနောမိ, တဒါ သပဒိ ကုက္ကုဋော ရုရာဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ကုက္ကုဋရဝါတ် ပြာက် တွံ မာံ တြိရပါဟ္နောၐျသေ, ယဲၐာ ဝါဂ် ယီၑုနာဝါဒိ တာံ ပိတရး သံသ္မၖတျ ဗဟိရိတွာ ခေဒါဒ် ဘၖၑံ စကြန္ဒ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ပြဘာတေ ဇာတေ ပြဓာနယာဇကလောကပြာစီနာ ယီၑုံ ဟန္တုံ တတ္ပြတိကူလံ မန္တြယိတွာ ");
INSERT INTO sanbur_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","တံ ဗဒွွာ နီတွာ ပန္တီယပီလာတာချာဓိပေ သမရ္ပယာမာသုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","တတော ယီၑေား ပရကရေဝွရ္ပယိတာ ယိဟူဒါသ္တတ္ပြာဏာဒဏ္ဍာဇ္ဉာံ ဝိဒိတွာ သန္တပ္တမနား ပြဓာနယာဇကလောကပြာစီနာနာံ သမက္ၐံ တာသ္တြီံၑန္မုဒြား ပြတိဒါယာဝါဒီတ်, ");
INSERT INTO sanbur_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ဧတန္နိရာဂေါနရပြာဏပရကရာရ္ပဏာတ် ကလုၐံ ကၖတဝါနဟံ၊ တဒါ တ ဥဒိတဝန္တး, တေနာသ္မာကံ ကိံ? တွယာ တဒ် ဗုဓျတာမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","တတော ယိဟူဒါ မန္ဒိရမဓျေ တာ မုဒြာ နိက္ၐိပျ ပြသ္ထိတဝါန် ဣတွာ စ သွယမာတ္မာနမုဒ္ဗဗန္ဓ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","ပၑ္စာတ် ပြဓာနယာဇကာသ္တာ မုဒြာ အာဒါယ ကထိတဝန္တး, ဧတာ မုဒြား ၑောဏိတမူလျံ တသ္မာဒ် ဘာဏ္ဍာဂါရေ န နိဓာတဝျား၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","အနန္တရံ တေ မန္တြယိတွာ ဝိဒေၑိနာံ ၑ္မၑာနသ္ထာနာယ တာဘိး ကုလာလသျ က္ၐေတြမကြီဏန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","အတော'ဒျာပိ တတ္သ္ထာနံ ရက္တက္ၐေတြံ ဝဒန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ဣတ္ထံ သတိ ဣသြာယေလီယသန္တာနဲ ရျသျ မူလျံ နိရုပိတံ, တသျ တြိံၑန္မုဒြာမာနံ မူလျံ ");
INSERT INTO sanbur_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","မာံ ပြတိ ပရမေၑွရသျာဒေၑာတ် တေဘျ အာဒီယတ, တေန စ ကုလာလသျ က္ၐေတြံ ကြီတမိတိ ယဒွစနံ ယိရိမိယဘဝိၐျဒွါဒိနာ ပြောက္တံ တတ် တဒါသိဓျတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","အနန္တရံ ယီၑော် တဒဓိပတေး သမ္မုခ ဥပတိၐ္ဌတိ သ တံ ပပြစ္ဆ, တွံ ကိံ ယိဟူဒီယာနာံ ရာဇာ? တဒါ ယီၑုသ္တမဝဒတ်, တွံ သတျမုက္တဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","ကိန္တု ပြဓာနယာဇကပြာစီနဲရဘိယုက္တေန တေန ကိမပိ န ပြတျဝါဒိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","တတး ပီလာတေန သ ဥဒိတး, ဣမေ တွတ္ပြတိကူလတး ကတိ ကတိ သာက္ၐျံ ဒဒတိ, တတ် တွံ န ၑၖဏောၐိ? ");
INSERT INTO sanbur_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","တထာပိ သ တေၐာမေကသျာပိ ဝစသ ဥတ္တရံ နောဒိတဝါန်; တေန သော'ဓိပတိ ရ္မဟာစိတြံ ဝိဒါမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","အနျစ္စ တန္မဟကာလေ'ဓိပတေရေတာဒၖၑီ ရာတိရာသီတ်, ပြဇာ ယံ ကဉ္စန ဗန္ဓိနံ ယာစန္တေ, တမေဝ သ မောစယတီတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","တဒါနီံ ဗရဗ္ဗာနာမာ ကၑ္စိတ် ချာတဗန္ဓျာသီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","တတး ပီလာတသ္တတြ မိလိတာန် လောကာန် အပၖစ္ဆတ်, ဧၐ ဗရဗ္ဗာ ဗန္ဓီ ခြီၐ္ဋဝိချာတော ယီၑုၑ္စဲတယေား ကံ မောစယိၐျာမိ? ယုၐ္မာကံ ကိမီပ္သိတံ? ");
INSERT INTO sanbur_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","တဲရီရ္ၐျယာ သ သမရ္ပိတ ဣတိ သ ဇ္ဉာတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","အပရံ ဝိစာရာသနောပဝေၑနကာလေ ပီလာတသျ ပတ္နီ ဘၖတျံ ပြဟိတျ တသ္မဲ ကထယာမာသ, တံ ဓာရ္မ္မိကမနုဇံ ပြတိ တွယာ ကိမပိ န ကရ္တ္တဝျံ; ယသ္မာတ် တတ္ကၖတေ'ဒျာဟံ သွပ္နေ ပြဘူတကၐ္ဋမလဘေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","အနန္တရံ ပြဓာနယာဇကပြာစီနာ ဗရဗ္ဗာံ ယာစိတွာဒါတုံ ယီၑုဉ္စ ဟန္တုံ သကလလောကာန် ပြာဝရ္တ္တယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","တတော'ဓိပတိသ္တာန် ပၖၐ္ဋဝါန်, ဧတယေား ကမဟံ မောစယိၐျာမိ? ယုၐ္မာကံ ကေစ္ဆာ? တေ ပြောစု ရ္ဗရဗ္ဗာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","တဒါ ပီလာတး ပပြစ္ဆ, တရှိ ယံ ခြီၐ္ဋံ ဝဒန္တိ, တံ ယီၑုံ ကိံ ကရိၐျာမိ? သရွွေ ကထယာမာသုး, သ ကြုၑေန ဝိဓျတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","တတော'ဓိပတိရဝါဒီတ်, ကုတး? ကိံ တေနာပရာဒ္ဓံ? ကိန္တု တေ ပုနရုစဲ ရ္ဇဂဒုး, သ ကြုၑေန ဝိဓျတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","တဒါ နိဇဝါကျမဂြာဟျမဘူတ်, ကလဟၑ္စာပျဘူတ်, ပီလာတ ဣတိ ဝိလောကျ လောကာနာံ သမက္ၐံ တောယမာဒါယ ကရော် ပြက္ၐာလျာဝေါစတ်, ဧတသျ ဓာရ္မ္မိကမနုၐျသျ ၑောဏိတပါတေ နိရ္ဒောၐော'ဟံ, ယုၐ္မာဘိရေဝ တဒ် ဗုဓျတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","တဒါ သရွွား ပြဇား ပြတျဝေါစန်, တသျ ၑောဏိတပါတာပရာဓော'သ္မာကမ် အသ္မတ္သန္တာနာနာဉ္စောပရိ ဘဝတု၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","တတး သ တေၐာံ သမီပေ ဗရဗ္ဗာံ မောစယာမာသ ယီၑုန္တု ကၐာဘိရာဟတျ ကြုၑေန ဝေဓိတုံ သမရ္ပယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","အနန္တရမ် အဓိပတေး သေနာ အဓိပတေ ရ္ဂၖဟံ ယီၑုမာနီယ တသျ သမီပေ သေနာသမူဟံ သံဇဂၖဟုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","တတသ္တေ တသျ ဝသနံ မောစယိတွာ ကၖၐ္ဏလောဟိတဝရ္ဏဝသနံ ပရိဓာပယာမာသုး ");
INSERT INTO sanbur_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ကဏ္ဋကာနာံ မုကုဋံ နိရ္မ္မာယ တစ္ဆိရသိ ဒဒုး, တသျ ဒက္ၐိဏကရေ ဝေတြမေကံ ဒတ္တွာ တသျ သမ္မုခေ ဇာနူနိ ပါတယိတွာ, ဟေ ယိဟူဒီယာနာံ ရာဇန်, တုဘျံ နမ ဣတျုက္တွာ တံ တိရၑ္စကြုး, ");
INSERT INTO sanbur_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","တတသ္တသျ ဂါတြေ နိၐ္ဌီဝံ ဒတွာ တေန ဝေတြေဏ ၑိရ အာဇဃ္နုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ဣတ္ထံ တံ တိရသ္ကၖတျ တဒ် ဝသနံ မောစယိတွာ ပုနရ္နိဇဝသနံ ပရိဓာပယာဉ္စကြုး, တံ ကြုၑေန ဝေဓိတုံ နီတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","ပၑ္စာတ္တေ ဗဟိရ္ဘူယ ကုရီဏီယံ ၑိမောန္နာမကမေကံ ဝိလောကျ ကြုၑံ ဝေါဎုံ တမာဒဒိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","အနန္တရံ ဂုလ္ဂလ္တာမ် အရ္ထာတ် ၑိရသ္ကပါလနာမကသ္ထာနမု ပသ္ထာယ တေ ယီၑဝေ ပိတ္တမိၑြိတာမ္လရသံ ပါတုံ ဒဒုး, ");
INSERT INTO sanbur_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ကိန္တု သ တမာသွာဒျ န ပပေါ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","တဒါနီံ တေ တံ ကြုၑေန သံဝိဓျ တသျ ဝသနာနိ ဂုဋိကာပါတေန ဝိဘဇျ ဇဂၖဟုး, တသ္မာတ်, ဝိဘဇန္တေ'ဓရီယံ မေ တေ မနုၐျား ပရသ္ပရံ၊ မဒုတ္တရီယဝသ္တြာရ္ထံ ဂုဋိကာံ ပါတယန္တိ စ။ ယဒေတဒွစနံ ဘဝိၐျဒွါဒိဘိရုက္တမာသီတ်, တဒါ တဒ် အသိဓျတ်, ");
INSERT INTO sanbur_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ပၑ္စာတ် တေ တတြောပဝိၑျ တဒြက္ၐဏကရွွဏိ နိယုက္တာသ္တသ္ထုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","အပရမ် ဧၐ ယိဟူဒီယာနာံ ရာဇာ ယီၑုရိတျပဝါဒလိပိပတြံ တစ္ဆိရသ ဦရ္ဒွွေ ယောဇယာမာသုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","တတသ္တသျ ဝါမေ ဒက္ၐိဏေ စ ဒွေါ် စဲရော် တေန သာကံ ကြုၑေန ဝိဝိဓုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","တဒါ ပါန္ထာ နိဇၑိရော လာဍယိတွာ တံ နိန္ဒန္တော ဇဂဒုး, ");
INSERT INTO sanbur_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ဟေ ဤၑွရမန္ဒိရဘဉ္ဇက ဒိနတြယေ တန္နိရ္မ္မာတး သွံ ရက္ၐ, စေတ္တွမီၑွရသုတသ္တရှိ ကြုၑာဒဝရောဟ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","ပြဓာနယာဇကာဓျာပကပြာစီနာၑ္စ တထာ တိရသ္ကၖတျ ဇဂဒုး, ");
INSERT INTO sanbur_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","သော'နျဇနာနာဝတ်, ကိန္တု သွမဝိတုံ န ၑက္နောတိ၊ ယဒီသြာယေလော ရာဇာ ဘဝေတ်, တရှီဒါနီမေဝ ကြုၑာဒဝရောဟတု, တေန တံ ဝယံ ပြတျေၐျာမး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","သ ဤၑွရေ ပြတျာၑာမကရောတ်, ယဒီၑွရသ္တသ္မိန် သန္တုၐ္ဋသ္တရှီဒါနီမေဝ တမဝေတ်, ယတး သ ဥက္တဝါန် အဟမီၑွရသုတး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","ယော် သ္တေနော် သာကံ တေန ကြုၑေန ဝိဒ္ဓေါ် တော် တဒွဒေဝ တံ နိနိန္ဒတုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","တဒါ ဒွိတီယယာမာတ် တၖတီယယာမံ ယာဝတ် သရွွဒေၑေ တမိရံ ဗဘူဝ, ");
INSERT INTO sanbur_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","တၖတီယယာမေ \"ဧလီ ဧလီ လာမာ ၑိဝက္တနီ\", အရ္ထာတ် မဒီၑွရ မဒီၑွရ ကုတော မာမတျာက္ၐီး? ယီၑုရုစ္စဲရိတိ ဇဂါဒ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","တဒါ တတြ သ္ထိတား ကေစိတ် တတ် ၑြုတွာ ဗဘာၐိရေ, အယမ် ဧလိယမာဟူယတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","တေၐာံ မဓျာဒ် ဧကး ၑီဃြံ ဂတွာ သ္ပဉ္ဇံ ဂၖဟီတွာ တတြာမ္လရသံ ဒတ္တွာ နလေန ပါတုံ တသ္မဲ ဒဒေါ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ဣတရေ'ကထယန် တိၐ္ဌတ, တံ ရက္ၐိတုမ် ဧလိယ အာယာတိ နဝေတိ ပၑျာမး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","ယီၑုး ပုနရုစဲရာဟူယ ပြာဏာန် ဇဟော်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","တတော မန္ဒိရသျ ဝိစ္ဆေဒဝသနမ် ဦရ္ဒွွာဒဓော ယာဝတ် ဆိဒျမာနံ ဒွိဓာဘဝတ်, ");
INSERT INTO sanbur_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ဘူမိၑ္စကမ္ပေ ဘူဓရောဝျဒီရျျတ စ၊ ၑ္မၑာနေ မုက္တေ ဘူရိပုဏျဝတာံ သုပ္တဒေဟာ ဥဒတိၐ္ဌန်, ");
INSERT INTO sanbur_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ၑ္မၑာနာဒ် ဝဟိရ္ဘူယ တဒုတ္ထာနာတ် ပရံ ပုဏျပုရံ ဂတွာ ဗဟုဇနာန် ဒရ္ၑယာမာသုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ယီၑုရက္ၐဏာယ နိယုက္တး ၑတသေနာပတိသ္တတ္သင်္ဂိနၑ္စ တာဒၖၑီံ ဘူကမ္ပာဒိဃဋနာံ ဒၖၐ္ဋွာ ဘီတာ အဝဒန်, ဧၐ ဤၑွရပုတြော ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ယာ ဗဟုယောၐိတော ယီၑုံ သေဝမာနာ ဂါလီလသ္တတ္ပၑ္စာဒါဂတာသ္တာသာံ မဓျေ ");
INSERT INTO sanbur_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","မဂ္ဒလီနီ မရိယမ် ယာကူဗျောၑျော ရ္မာတာ ယာ မရိယမ် သိဗဒိယပုတြယော ရ္မာတာ စ ယောၐိတ ဧတာ ဒူရေ တိၐ္ဌန္တျော ဒဒၖၑုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","သန္ဓျာယာံ သတျမ် အရိမထိယာနဂရသျ ယူၐဖ္နာမာ ဓနီ မနုဇော ယီၑေား ၑိၐျတွာတ္ ");
INSERT INTO sanbur_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ပီလာတသျ သမီပံ ဂတွာ ယီၑေား ကာယံ ယယာစေ, တေန ပီလာတး ကာယံ ဒါတုမ် အာဒိဒေၑ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ယူၐဖ် တတ္ကာယံ နီတွာ ၑုစိဝသ္တြေဏာစ္ဆာဒျ ");
INSERT INTO sanbur_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","သွာရ္ထံ ၑဲလေ ယတ် ၑ္မၑာနံ စခါန, တန္မဓျေ တတ္ကာယံ နိဓာယ တသျ ဒွါရိ ဝၖဟတ္ပာၐာဏံ ဒဒေါ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","ကိန္တု မဂ္ဒလီနီ မရိယမ် အနျမရိယမ် ဧတေ သ္တြိယော် တတြ ၑ္မၑာနသမ္မုခ ဥပဝိဝိၑတုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","တဒနန္တရံ နိသ္တာရောတ္သဝသျာယောဇနဒိနာတ် ပရေ'ဟနိ ပြဓာနယာဇကား ဖိရူၑိနၑ္စ မိလိတွာ ပီလာတမုပါဂတျာကထယန်, ");
INSERT INTO sanbur_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ဟေ မဟေစ္ဆ သ ပြတာရကော ဇီဝန အကထယတ်, ဒိနတြယာတ် ပရံ ၑ္မၑာနာဒုတ္ထာသျာမိ တဒွါကျံ သ္မရာမော ဝယံ; ");
INSERT INTO sanbur_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","တသ္မာတ် တၖတီယဒိနံ ယာဝတ် တတ် ၑ္မၑာနံ ရက္ၐိတုမာဒိၑတု, နောစေတ် တစ္ဆိၐျာ ယာမိနျာမာဂတျ တံ ဟၖတွာ လောကာန် ဝဒိၐျန္တိ, သ ၑ္မၑာနာဒုဒတိၐ္ဌတ်, တထာ သတိ ပြထမဘြာန္တေး ၑေၐီယဘြာန္တိ ရ္မဟတီ ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","တဒါ ပီလာတ အဝါဒီတ်, ယုၐ္မာကံ သမီပေ ရက္ၐိဂဏ အာသ္တေ, ယူယံ ဂတွာ ယထာ သာဓျံ ရက္ၐယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","တတသ္တေ ဂတွာ တဒ္ဒူाရပါၐာဏံ မုဒြာင်္ကိတံ ကၖတွာ ရက္ၐိဂဏံ နိယောဇျ ၑ္မၑာနံ ရက္ၐယာမာသုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","တတး ပရံ ဝိၑြာမဝါရသျ ၑေၐေ သပ္တာဟပြထမဒိနသျ ပြဘောတေ ဇာတေ မဂ္ဒလီနီ မရိယမ် အနျမရိယမ် စ ၑ္မၑာနံ ဒြၐ္ဋုမာဂတာ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","တဒါ မဟာန် ဘူကမ္ပော'ဘဝတ်; ပရမေၑွရီယဒူတး သွရ္ဂာဒဝရုဟျ ၑ္မၑာနဒွါရာတ် ပါၐာဏမပသာရျျ တဒုပရျျုပဝိဝေၑ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","တဒွဒနံ ဝိဒျုဒွတ် တေဇောမယံ ဝသနံ ဟိမၑုဘြဉ္စ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","တဒါနီံ ရက္ၐိဏသ္တဒ္ဘယာတ် ကမ္ပိတာ မၖတဝဒ် ဗဘူဝး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","သ ဒူတော ယောၐိတော ဇဂါဒ, ယူယံ မာ ဘဲၐ္ဋ, ကြုၑဟတယီၑုံ မၖဂယဓွေ တဒဟံ ဝေဒ္မိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","သော'တြ နာသ္တိ, ယထာဝဒတ် တထောတ္ထိတဝါန်; ဧတတ် ပြဘေား ၑယနသ္ထာနံ ပၑျတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","တူရ္ဏံ ဂတွာ တစ္ဆိၐျာန် ဣတိ ဝဒတ, သ ၑ္မၑာနာဒ် ဥဒတိၐ္ဌတ်, ယုၐ္မာကမဂြေ ဂါလီလံ ယာသျတိ ယူယံ တတြ တံ ဝီက္ၐိၐျဓွေ, ပၑျတာဟံ ဝါရ္တ္တာမိမာံ ယုၐ္မာနဝါဒိၐံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","တတသ္တာ ဘယာတ် မဟာနန္ဒာဉ္စ ၑ္မၑာနာတ် တူရ္ဏံ ဗဟိရ္ဘူယ တစ္ဆိၐျာန် ဝါရ္တ္တာံ ဝက္တုံ ဓာဝိတဝတျး၊ ကိန္တု ၑိၐျာန် ဝါရ္တ္တာံ ဝက္တုံ ယာန္တိ, တဒါ ယီၑု ရ္ဒရ္ၑနံ ဒတ္တွာ တာ ဇဂါဒ, ");
INSERT INTO sanbur_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ယုၐ္မာကံ ကလျာဏံ ဘူယာတ်, တတသ္တာ အာဂတျ တတ္ပာဒယေား ပတိတွာ ပြဏေမုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","ယီၑုသ္တာ အဝါဒီတ်, မာ ဗိဘီတ, ယူယံ ဂတွာ မမ ဘြာတၖန် ဂါလီလံ ယာတုံ ဝဒတ, တတြ တေ မာံ ဒြက္ၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","သ္တြိယော ဂစ္ဆန္တိ, တဒါ ရက္ၐိဏာံ ကေစိတ် ပုရံ ဂတွာ ယဒျဒ် ဃဋိတံ တတ္သရွွံ ပြဓာနယာဇကာန် ဇ္ဉာပိတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","တေ ပြာစီနဲး သမံ သံသဒံ ကၖတွာ မန္တြယန္တော ဗဟုမုဒြား သေနာဘျော ဒတ္တွာဝဒန်, ");
INSERT INTO sanbur_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","အသ္မာသု နိဒြိတေၐု တစ္ဆိၐျာ ယာမိနျာမာဂတျ တံ ဟၖတွာနယန်, ဣတိ ယူယံ ပြစာရယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ယဒျေတဒဓိပတေး ၑြောတြဂေါစရီဘဝေတ်, တရှိ တံ ဗောဓယိတွာ ယုၐ္မာနဝိၐျာမး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","တတသ္တေ မုဒြာ ဂၖဟီတွာ ၑိက္ၐာနုရူပံ ကရ္မ္မ စကြုး, ယိဟူဒီယာနာံ မဓျေ တသျာဒျာပိ ကိံဝဒန္တီ ဝိဒျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ဧကာဒၑ ၑိၐျာ ယီၑုနိရူပိတာဂါလီလသျာဒြိံ ဂတွာ ");
INSERT INTO sanbur_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","တတြ တံ သံဝီက္ၐျ ပြဏေမုး, ကိန္တု ကေစိတ် သန္ဒိဂ္ဓဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ယီၑုသ္တေၐာံ သမီပမာဂတျ ဝျာဟၖတဝါန်, သွရ္ဂမေဒိနျေား သရွွာဓိပတိတွဘာရော မယျရ္ပိတ အာသ္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","အတော ယူယံ ပြယာယ သရွွဒေၑီယာန် ၑိၐျာန် ကၖတွာ ပိတုး ပုတြသျ ပဝိတြသျာတ္မနၑ္စ နာမ္နာ တာနဝဂါဟယတ; အဟံ ယုၐ္မာန် ယဒျဒါဒိၑံ တဒပိ ပါလယိတုံ တာနုပါဒိၑတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ပၑျတ, ဇဂဒန္တံ ယာဝတ် သဒါဟံ ယုၐ္မာဘိး သာကံ တိၐ္ဌာမိ၊ ဣတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ဤၑွရပုတြသျ ယီၑုခြီၐ္ဋသျ သုသံဝါဒါရမ္ဘး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ဘဝိၐျဒွါဒိနာံ ဂြန္ထေၐု လိပိရိတ္ထမာသ္တေ, ပၑျ သွကီယဒူတန္တု တဝါဂြေ ပြေၐယာမျဟမ်၊ ဂတွာ တွဒီယပန္ထာနံ သ ဟိ ပရိၐ္ကရိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","\"ပရမေၑသျ ပန္ထာနံ ပရိၐ္ကုရုတ သရွွတး၊ တသျ ရာဇပထဉ္စဲဝ သမာနံ ကုရုတာဓုနာ၊ \" ဣတျေတတ် ပြာန္တရေ ဝါကျံ ဝဒတး ကသျစိဒြဝး။ ");
INSERT INTO sanbur_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","သဧဝ ယောဟန် ပြာန္တရေ မဇ္ဇိတဝါန် တထာ ပါပမာရ္ဇနနိမိတ္တံ မနောဝျာဝရ္တ္တကမဇ္ဇနသျ ကထာဉ္စ ပြစာရိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","တတော ယိဟူဒါဒေၑယိရူၑာလမ္နဂရနိဝါသိနး သရွွေ လောကာ ဗဟိ ရ္ဘူတွာ တသျ သမီပမာဂတျ သွာနိ သွာနိ ပါပါနျင်္ဂီကၖတျ ယရ္ဒ္ဒနနဒျာံ တေန မဇ္ဇိတာ ဗဘူဝုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","အသျ ယောဟနး ပရိဓေယာနိ ကြမေလကလောမဇာနိ, တသျ ကဋိဗန္ဓနံ စရ္မ္မဇာတမ်, တသျ ဘက္ၐျာဏိ စ ၑူကကီဋာ ဝနျမဓူနိ စာသန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","သ ပြစာရယန် ကထယာဉ္စကြေ, အဟံ နမြီဘူယ ယသျ ပါဒုကာဗန္ဓနံ မောစယိတုမပိ န ယောဂျောသ္မိ, တာဒၖၑော မတ္တော ဂုရုတရ ဧကး ပုရုၐော မတ္ပၑ္စာဒါဂစ္ဆတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","အဟံ ယုၐ္မာန် ဇလေ မဇ္ဇိတဝါန် ကိန္တု သ ပဝိတြ အာတ္မာနိ သံမဇ္ဇယိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","အပရဉ္စ တသ္မိန္နေဝ ကာလေ ဂါလီလ္ပြဒေၑသျ နာသရဒ္ဂြာမာဒ် ယီၑုရာဂတျ ယောဟနာ ယရ္ဒ္ဒနနဒျာံ မဇ္ဇိတော'ဘူတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","သ ဇလာဒုတ္ထိတမာတြော မေဃဒွါရံ မုက္တံ ကပေါတဝတ် သွသျောပရိ အဝရောဟန္တမာတ္မာနဉ္စ ဒၖၐ္ဋဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","တွံ မမ ပြိယး ပုတြသ္တွယျေဝ မမမဟာသန္တောၐ ဣယမာကာၑီယာ ဝါဏီ ဗဘူဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","တသ္မိန် ကာလေ အာတ္မာ တံ ပြာန္တရမဓျံ နိနာယ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","အထ သ စတွာရိံၑဒ္ဒိနာနိ တသ္မိန် သ္ထာနေ ဝနျပၑုဘိး သဟ တိၐ္ဌန် ၑဲတာနာ ပရီက္ၐိတး; ပၑ္စာတ် သွရ္ဂီယဒူတာသ္တံ သိၐေဝိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","အနန္တရံ ယောဟနိ ဗန္ဓနာလယေ ဗဒ္ဓေ သတိ ယီၑု ရ္ဂာလီလ္ပြဒေၑမာဂတျ ဤၑွရရာဇျသျ သုသံဝါဒံ ပြစာရယန် ကထယာမာသ, ");
INSERT INTO sanbur_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ကာလး သမ္ပူရ္ဏ ဤၑွရရာဇျဉ္စ သမီပမာဂတံ; အတောဟေတော ရျူယံ မနာံသိ ဝျာဝရ္တ္တယဓွံ သုသံဝါဒေ စ ဝိၑွာသိတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","တဒနန္တရံ သ ဂါလီလီယသမုဒြသျ တီရေ ဂစ္ဆန် ၑိမောန် တသျ ဘြာတာ အန္ဒြိယနာမာ စ ဣမော် ဒွေါ် ဇနော် မတ္သျဓာရိဏော် သာဂရမဓျေ ဇာလံ ပြက္ၐိပန္တော် ဒၖၐ္ဋွာ တာဝဝဒတ်, ");
INSERT INTO sanbur_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ယုဝါံ မမ ပၑ္စာဒါဂစ္ဆတံ, ယုဝါမဟံ မနုၐျဓာရိဏော် ကရိၐျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","တတသ္တော် တတ္က္ၐဏမေဝ ဇာလာနိ ပရိတျဇျ တသျ ပၑ္စာတ် ဇဂ္မတုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","တတး ပရံ တတ္သ္ထာနာတ် ကိဉ္စိဒ် ဒူရံ ဂတွာ သ သိဝဒီပုတြယာကူဗ် တဒ္ဘြာတၖယောဟန် စ ဣမော် နော်ကာယာံ ဇာလာနာံ ဇီရ္ဏမုဒ္ဓါရယန္တော် ဒၖၐ္ဋွာ တာဝါဟူယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","တတသ္တော် နော်ကာယာံ ဝေတနဘုဂ္ဘိး သဟိတံ သွပိတရံ ဝိဟာယ တတ္ပၑ္စာဒီယတုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","တတး ပရံ ကဖရ္နာဟူမ္နာမကံ နဂရမုပသ္ထာယ သ ဝိၑြာမဒိဝသေ ဘဇနဂြဟံ ပြဝိၑျ သမုပဒိဒေၑ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","တသျောပဒေၑာလ္လောကာ အာၑ္စရျျံ မေနိရေ ယတး သောဓျာပကာဣဝ နောပဒိၑန် ပြဘာဝဝါနိဝ ပြောပဒိဒေၑ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","အပရဉ္စ တသ္မိန် ဘဇနဂၖဟေ အပဝိတြဘူတေန ဂြသ္တ ဧကော မာနုၐ အာသီတ်၊ သ စီတ္ၑဗ္ဒံ ကၖတွာ ကထယာဉ္စကေ ");
INSERT INTO sanbur_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ဘော နာသရတီယ ယီၑော တွမသ္မာန် တျဇ, တွယာ သဟာသ္မာကံ ကး သမ္ဗန္ဓး? တွံ ကိမသ္မာန် နာၑယိတုံ သမာဂတး? တွမီၑွရသျ ပဝိတြလောက ဣတျဟံ ဇာနာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","တဒါ ယီၑုသ္တံ တရ္ဇယိတွာ ဇဂါဒ တူၐ္ဏီံ ဘဝ ဣတော ဗဟိရ္ဘဝ စ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","တတး သော'ပဝိတြဘူတသ္တံ သမ္ပီဍျ အတျုစဲၑ္စီတ္ကၖတျ နိရ္ဇဂါမ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","တေနဲဝ သရွွေ စမတ္ကၖတျ ပရသ္ပရံ ကထယာဉ္စကြိရေ, အဟော ကိမိဒံ? ကီဒၖၑော'ယံ နဝျ ဥပဒေၑး? အနေန ပြဘာဝေနာပဝိတြဘူတေၐွာဇ္ဉာပိတေၐု တေ တဒါဇ္ဉာနုဝရ္တ္တိနော ဘဝန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","တဒါ တသျ ယၑော ဂါလီလၑ္စတုရ္ဒိက္သ္ထသရွွဒေၑာန် ဝျာပ္နောတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","အပရဉ္စ တေ ဘဇနဂၖဟာဒ် ဗဟိ ရ္ဘူတွာ ယာကူဗျောဟန္ဘျာံ သဟ ၑိမောန အာန္ဒြိယသျ စ နိဝေၑနံ ပြဝိဝိၑုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","တဒါ ပိတရသျ ၑွၑြူရ္ဇွရပီဍိတာ ၑယျာယာမာသ္တ ဣတိ တေ တံ ဈဋိတိ ဝိဇ္ဉာပယာဉ္စကြုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","တတး သ အာဂတျ တသျာ ဟသ္တံ ဓၖတွာ တာမုဒသ္ထာပယတ်; တဒဲဝ တာံ ဇွရော'တျာက္ၐီတ် တတး ပရံ သာ တာန် သိၐေဝေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","အထာသ္တံ ဂတေ ရဝေါ် သန္ဓျာကာလေ သတိ လောကာသ္တတ္သမီပံ သရွွာန် ရောဂိဏော ဘူတဓၖတာံၑ္စ သမာနိနျုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","သရွွေ နာဂရိကာ လောကာ ဒွါရိ သံမိလိတာၑ္စ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","တတး သ နာနာဝိဓရောဂိဏော ဗဟူန် မနုဇာနရောဂိဏၑ္စကာရ တထာ ဗဟူန် ဘူတာန် တျာဇယာဉ္စကာရ တာန် ဘူတာန် ကိမပိ ဝါကျံ ဝက္တုံ နိၐိၐေဓ စ ယတောဟေတောသ္တေ တမဇာနန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","အပရဉ္စ သော'တိပြတျူၐေ ဝသ္တုတသ္တု ရာတြိၑေၐေ သမုတ္ထာယ ဗဟိရ္ဘူယ နိရ္ဇနံ သ္ထာနံ ဂတွာ တတြ ပြာရ္ထယာဉ္စကြေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","အနန္တရံ ၑိမောန် တတ္သင်္ဂိနၑ္စ တသျ ပၑ္စာဒ် ဂတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","တဒုဒ္ဒေၑံ ပြာပျ တမဝဒန် သရွွေ လောကာသ္တွာံ မၖဂယန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","တဒါ သော'ကထယတ် အာဂစ္ဆတ ဝယံ သမီပသ္ထာနိ နဂရာဏိ ယာမး, ယတော'ဟံ တတြ ကထာံ ပြစာရယိတုံ ဗဟိရာဂမမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","အထ သ တေၐာံ ဂါလီလ္ပြဒေၑသျ သရွွေၐု ဘဇနဂၖဟေၐု ကထား ပြစာရယာဉ္စကြေ ဘူတာနတျာဇယဉ္စ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","အနန္တရမေကး ကုၐ္ဌီ သမာဂတျ တတ္သမ္မုခေ ဇာနုပါတံ ဝိနယဉ္စ ကၖတွာ ကထိတဝါန် ယဒိ ဘဝါန် ဣစ္ဆတိ တရှိ မာံ ပရိၐ္ကရ္တ္တုံ ၑက္နောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","တတး ကၖပါလု ရျီၑုး ကရော် ပြသာရျျ တံ သ္ပၐ္ဋွာ ကထယာမာသ ");
INSERT INTO sanbur_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","မမေစ္ဆာ ဝိဒျတေ တွံ ပရိၐ္ကၖတော ဘဝ၊ ဧတတ္ကထာယား ကထနမာတြာတ် သ ကုၐ္ဌီ ရောဂါန္မုက္တး ပရိၐ္ကၖတော'ဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","တဒါ သ တံ ဝိသၖဇန် ဂါဎမာဒိၑျ ဇဂါဒ ");
INSERT INTO sanbur_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","သာဝဓာနော ဘဝ ကထာမိမာံ ကမပိ မာ ဝဒ; သွာတ္မာနံ ယာဇကံ ဒရ္ၑယ, လောကေဘျး သွပရိၐ္ကၖတေး ပြမာဏဒါနာယ မူသာနိရ္ဏီတံ ယဒ္ဒါနံ တဒုတ္သၖဇသွ စ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","ကိန္တု သ ဂတွာ တတ် ကရ္မ္မ ဣတ္ထံ ဝိသ္တာရျျ ပြစာရယိတုံ ပြာရေဘေ တေနဲဝ ယီၑုး ပုနး သပြကာၑံ နဂရံ ပြဝေၐ္ဋုံ နာၑက္နောတ် တတောဟေတောရ္ဗဟိး ကာနနသ္ထာနေ တသျော်; တထာပိ စတုရ္ဒ္ဒိဂ္ဘျော လောကာသ္တသျ သမီပမာယယုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","တဒနန္တရံ ယီၑဲ ကတိပယဒိနာနိ ဝိလမ္ဗျ ပုနး ကဖရ္နာဟူမ္နဂရံ ပြဝိၐ္ဋေ သ ဂၖဟ အာသ္တ ဣတိ ကိံဝဒန္တျာ တတ္က္ၐဏံ တတ္သမီပံ ဗဟဝေါ လောကာ အာဂတျ သမုပတသ္ထုး, ");
INSERT INTO sanbur_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","တသ္မာဒ် ဂၖဟမဓျေ သရွွေၐာံ ကၖတေ သ္ထာနံ နာဘဝဒ် ဒွါရသျ စတုရ္ဒိက္ၐွပိ နာဘဝတ်, တတ္ကာလေ သ တာန် ပြတိ ကထာံ ပြစာရယာဉ္စကြေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","တတး ပရံ လောကာၑ္စတုရ္ဘိ ရ္မာနဝဲရေကံ ပက္ၐာဃာတိနံ ဝါဟယိတွာ တတ္သမီပမ် အာနိနျုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ကိန္တု ဇနာနာံ ဗဟုတွာတ် တံ ယီၑေား သမ္မုခမာနေတုံ န ၑက္နုဝန္တော ယသ္မိန် သ္ထာနေ သ အာသ္တေ တဒုပရိဂၖဟပၖၐ္ဌံ ခနိတွာ ဆိဒြံ ကၖတွာ တေန မာရ္ဂေဏ သၑယျံ ပက္ၐာဃာတိနမ် အဝရောဟယာမာသုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","တတော ယီၑုသ္တေၐာံ ဝိၑွာသံ ဒၖၐ္ဋွာ တံ ပက္ၐာဃာတိနံ ဗဘာၐေ ဟေ ဝတ္သ တဝ ပါပါနာံ မာရ္ဇနံ ဘဝတု၊ ");
INSERT INTO sanbur_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","တဒါ ကိယန္တော'ဓျာပကာသ္တတြောပဝိၑန္တော မနောဘိ ရွိတရ္ကယာဉ္စကြုး, ဧၐ မနုၐျ ဧတာဒၖၑီမီၑွရနိန္ဒာံ ကထာံ ကုတး ကထယတိ? ");
INSERT INTO sanbur_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","ဤၑွရံ ဝိနာ ပါပါနိ မာရ္ၐ္ဋုံ ကသျ သာမရ္ထျမ် အာသ္တေ? ");
INSERT INTO sanbur_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ဣတ္ထံ တေ ဝိတရ္ကယန္တိ ယီၑုသ္တတ္က္ၐဏံ မနသာ တဒ် ဗုဒွွာ တာနဝဒဒ် ယူယမန္တးကရဏဲး ကုတ ဧတာနိ ဝိတရ္ကယထ? ");
INSERT INTO sanbur_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","တဒနန္တရံ ယီၑုသ္တတ္သ္ထာနာတ် ပုနး သမုဒြတဋံ ယယော်; လောကနိဝဟေ တတ္သမီပမာဂတေ သ တာန် သမုပဒိဒေၑ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","ကိန္တု ပၖထိဝျာံ ပါပါနိ မာရ္ၐ္ဋုံ မနုၐျပုတြသျ သာမရ္ထျမသ္တိ, ဧတဒ် ယုၐ္မာန် ဇ္ဉာပယိတုံ (သ တသ္မဲ ပက္ၐာဃာတိနေ ကထယာမာသ) ");
INSERT INTO sanbur_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","ဥတ္တိၐ္ဌ တဝ ၑယျာံ ဂၖဟီတွာ သွဂၖဟံ ယာဟိ, အဟံ တွာမိဒမ် အာဇ္ဉာပယာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","တတး သ တတ္က္ၐဏမ် ဥတ္ထာယ ၑယျာံ ဂၖဟီတွာ သရွွေၐာံ သာက္ၐာတ် ဇဂါမ; သရွွေ ဝိသ္မိတာ ဧတာဒၖၑံ ကရ္မ္မ ဝယမ် ကဒါပိ နာပၑျာမ, ဣမာံ ကထာံ ကထယိတွေၑွရံ ဓနျမဗြုဝန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","တဒနန္တရံ ယီၑုသ္တတ္သ္ထာနာတ် ပုနး သမုဒြတဋံ ယယော်; လောကနိဝဟေ တတ္သမီပမာဂတေ သ တာန် သမုပဒိဒေၑ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","အထ ဂစ္ဆန် ကရသဉ္စယဂၖဟ ဥပဝိၐ္ဋမ် အာလ္ဖီယပုတြံ လေဝိံ ဒၖၐ္ဋွာ တမာဟူယ ကထိတဝါန် မတ္ပၑ္စာတ် တွာမာမစ္ဆ တတး သ ဥတ္ထာယ တတ္ပၑ္စာဒ် ယယော်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","အနန္တရံ ယီၑော် တသျ ဂၖဟေ ဘောက္တုမ် ဥပဝိၐ္ဋေ ဗဟဝး ကရမဉ္စာယိနး ပါပိနၑ္စ တေန တစ္ဆိၐျဲၑ္စ သဟောပဝိဝိၑုး, ယတော ဗဟဝသ္တတ္ပၑ္စာဒါဇဂ္မုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","တဒါ သ ကရမဉ္စာယိဘိး ပါပိဘိၑ္စ သဟ ခါဒတိ, တဒ် ဒၖၐ္ဋွာဓျာပကား ဖိရူၑိနၑ္စ တသျ ၑိၐျာနူစုး ကရမဉ္စာယိဘိး ပါပိဘိၑ္စ သဟာယံ ကုတော ဘုံက္တေ ပိဝတိ စ? ");
INSERT INTO sanbur_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","တဒွါကျံ ၑြုတွာ ယီၑုး ပြတျုဝါစ,အရောဂိလောကာနာံ စိကိတ္သကေန ပြယောဇနံ နာသ္တိ, ကိန္တု ရောဂိဏာမေဝ; အဟံ ဓာရ္မ္မိကာနာဟွာတုံ နာဂတး ကိန္တု မနော ဝျာဝရ္တ္တယိတုံ ပါပိန ဧဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","တတး ပရံ ယောဟနး ဖိရူၑိနာဉ္စောပဝါသာစာရိၑိၐျာ ယီၑေား သမီပမ် အာဂတျ ကထယာမာသုး, ယောဟနး ဖိရူၑိနာဉ္စ ၑိၐျာ ဥပဝသန္တိ ကိန္တု ဘဝတး ၑိၐျာ နောပဝသန္တိ ကိံ ကာရဏမသျ? ");
INSERT INTO sanbur_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","တဒါ ယီၑုသ္တာန် ဗဘာၐေ ယာဝတ် ကာလံ သခိဘိး သဟ ကနျာယာ ဝရသ္တိၐ္ဌတိ တာဝတ္ကာလံ တေ ကိမုပဝသ္တုံ ၑက္နုဝန္တိ? ယာဝတ္ကာလံ ဝရသ္တဲး သဟ တိၐ္ဌတိ တာဝတ္ကာလံ တ ဥပဝသ္တုံ န ၑက္နုဝန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","ယသ္မိန် ကာလေ တေဘျး သကာၑာဒ် ဝရော နေၐျတေ သ ကာလ အာဂစ္ဆတိ, တသ္မိန် ကာလေ တေ ဇနာ ဥပဝတ္သျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","ကောပိ ဇနး ပုရာတနဝသ္တြေ နူတနဝသ္တြံ န သီဝျတိ, ယတော နူတနဝသ္တြေဏ သဟ သေဝနေ ကၖတေ ဇီရ္ဏံ ဝသ္တြံ ဆိဒျတေ တသ္မာတ် ပုန ရ္မဟတ် ဆိဒြံ ဇာယတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","ကောပိ ဇနး ပုရာတနကုတူၐု နူတနံ ဒြာက္ၐာရသံ န သ္ထာပယတိ, ယတော နူတနဒြာက္ၐာရသသျ တေဇသာ တား ကုတွော ဝိဒီရျျန္တေ တတော ဒြာက္ၐာရသၑ္စ ပတတိ ကုတွၑ္စ နၑျန္တိ, အတဧဝ နူတနဒြာက္ၐာရသော နူတနကုတူၐု သ္ထာပနီယး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","တဒနန္တရံ ယီၑု ရျဒါ ဝိၑြာမဝါရေ ၑသျက္ၐေတြေဏ ဂစ္ဆတိ တဒါ တသျ ၑိၐျာ ဂစ္ဆန္တး ၑသျမဉ္ဇရီၑ္ဆေတ္တုံ ပြဝၖတ္တား၊ ");
INSERT INTO sanbur_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","အတး ဖိရူၑိနော ယီၑဝေ ကထယာမာသုး ပၑျတု ဝိၑြာမဝါသရေ ယတ် ကရ္မ္မ န ကရ္တ္တဝျံ တဒ် ဣမေ ကုတး ကုရွွန္တိ? ");
INSERT INTO sanbur_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","တဒါ သ တေဘျော'ကထယတ် ဒါယူဒ် တတ္သံင်္ဂိနၑ္စ ဘက္ၐျာဘာဝါတ် က္ၐုဓိတား သန္တော ယတ် ကရ္မ္မ ကၖတဝန္တသ္တတ် ကိံ ယုၐ္မာဘိ ရ္န ပဌိတမ်? ");
INSERT INTO sanbur_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","အဗိယာထရ္နာမကေ မဟာယာဇကတာံ ကုရွွတိ သ ကထမီၑွရသျာဝါသံ ပြဝိၑျ ယေ ဒရ္ၑနီယပူပါ ယာဇကာန် ဝိနာနျသျ ကသျာပိ န ဘက္ၐျာသ္တာနေဝ ဗုဘုဇေ သင်္ဂိလောကေဘျော'ပိ ဒဒေါ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","သော'ပရမပိ ဇဂါဒ, ဝိၑြာမဝါရော မနုၐျာရ္ထမေဝ နိရူပိတော'သ္တိ ကိန္တု မနုၐျော ဝိၑြာမဝါရာရ္ထံ နဲဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","မနုၐျပုတြော ဝိၑြာမဝါရသျာပိ ပြဘုရာသ္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","အနန္တရံ ယီၑုး ပုန ရ္ဘဇနဂၖဟံ ပြဝိၐ္ဋသ္တသ္မိန် သ္ထာနေ ၑုၐ္ကဟသ္တ ဧကော မာနဝ အာသီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","သ ဝိၑြာမဝါရေ တမရောဂိဏံ ကရိၐျတိ နဝေတျတြ ဗဟဝသ္တမ် အပဝဒိတုံ ဆိဒြမပေက္ၐိတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","တဒါ သ တံ ၑုၐ္ကဟသ္တံ မနုၐျံ ဇဂါဒ မဓျသ္ထာနေ တွမုတ္တိၐ္ဌ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","တတး ပရံ သ တာန် ပပြစ္ဆ ဝိၑြာမဝါရေ ဟိတမဟိတံ တထာ ဟိ ပြာဏရက္ၐာ ဝါ ပြာဏနာၑ ဧၐာံ မဓျေ ကိံ ကရဏီယံ ? ကိန္တု တေ နိးၑဗ္ဒာသ္တသ္ထုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","တဒါ သ တေၐာမန္တးကရဏာနာံ ကာဌိနျာဒ္ဓေတော ရ္ဒုးခိတး ကြောဓာတ် စရ္တုिဒၑော ဒၖၐ္ဋဝါန် တံ မာနုၐံ ဂဒိတဝါန် တံ ဟသ္တံ ဝိသ္တာရယ, တတသ္တေန ဟသ္တေ ဝိသ္တၖတေ တဒ္ဓသ္တော'နျဟသ္တဝဒ် အရောဂေါ ဇာတး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","အထ ဖိရူၑိနး ပြသ္ထာယ တံ နာၑယိတုံ ဟေရောဒီယဲး သဟ မန္တြယိတုမာရေဘိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","အတဧဝ ယီၑုသ္တတ္သ္ထာနံ ပရိတျဇျ ၑိၐျဲး သဟ ပုနး သာဂရသမီပံ ဂတး; ");
INSERT INTO sanbur_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","တတော ဂါလီလျိဟူဒါ-ယိရူၑာလမ်-ဣဒေါမ်-ယရ္ဒန္နဒီပါရသ္ထာနေဘျော လောကသမူဟသ္တသျ ပၑ္စာဒ် ဂတး; တဒနျး သောရသီဒနေား သမီပဝါသိလောကသမူဟၑ္စ တသျ မဟာကရ္မ္မဏာံ ဝါရ္တ္တံ ၑြုတွာ တသျ သန္နိဓိမာဂတး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","တဒါ လောကသမူဟၑ္စေတ် တသျောပရိ ပတတိ ဣတျာၑင်္ကျ သ နာဝမေကာံ နိကဋေ သ္ထာပယိတုံ ၑိၐျာနာဒိၐ္ဋဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ယတော'နေကမနုၐျာဏာမာရောဂျကရဏာဒ် ဝျာဓိဂြသ္တား သရွွေ တံ သ္ပြၐ္ဋုံ ပရသ္ပရံ ဗလေန ယတ္နဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","အပရဉ္စ အပဝိတြဘူတာသ္တံ ဒၖၐ္ဋွာ တစ္စရဏယေား ပတိတွာ ပြောစဲး ပြောစုး, တွမီၑွရသျ ပုတြး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","ကိန္တု သ တာန် ဒၖဎမ် အာဇ္ဉာပျ သွံ ပရိစာယိတုံ နိၐိဒ္ဓဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","အနန္တရံ သ ပရွွတမာရုဟျ ယံ ယံ ပြတိစ္ဆာ တံ တမာဟူတဝါန် တတသ္တေ တတ္သမီပမာဂတား၊ ");
INSERT INTO sanbur_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","တဒါ သ ဒွါဒၑဇနာန် သွေန သဟ သ္ထာတုံ သုသံဝါဒပြစာရာယ ပြေရိတာ ဘဝိတုံ ");
INSERT INTO sanbur_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","သရွွပြကာရဝျာဓီနာံ ၑမနကရဏာယ ပြဘာဝံ ပြာပ္တုံ ဘူတာန် တျာဇယိတုဉ္စ နိယုက္တဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","တေၐာံ နာမာနီမာနိ, ၑိမောန် သိဝဒိပုတြော ");
INSERT INTO sanbur_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ယာကူဗ် တသျ ဘြာတာ ယောဟန် စ အာန္ဒြိယး ဖိလိပေါ ဗရ္ထလမယး, ");
INSERT INTO sanbur_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","မထီ ထောမာ စ အာလ္ဖီယပုတြော ယာကူဗ် ထဒ္ဒီယး ကိနာနီယး ၑိမောန် ယသ္တံ ပရဟသ္တေၐွရ္ပယိၐျတိ သ ဤၐ္ကရိယောတီယယိဟူဒါၑ္စ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","သ ၑိမောနေ ပိတရ ဣတျုပနာမ ဒဒေါ် ယာကူဗျောဟန္ဘျာံ စ ဗိနေရိဂိၑ် အရ္ထတော မေဃနာဒပုတြာဝိတျုပနာမ ဒဒေါ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","အနန္တရံ တေ နိဝေၑနံ ဂတား, ကိန္တု တတြာပိ ပုနရ္မဟာန် ဇနသမာဂမော 'ဘဝတ် တသ္မာတ္တေ ဘောက္တုမပျဝကာၑံ န ပြာပ္တား၊ ");
INSERT INTO sanbur_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","တတသ္တသျ သုဟၖလ္လောကာ ဣမာံ ဝါရ္တ္တာံ ပြာပျ သ ဟတဇ္ဉာနောဘူဒ် ဣတိ ကထာံ ကထယိတွာ တံ ဓၖတွာနေတုံ ဂတား၊ ");
INSERT INTO sanbur_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","အပရဉ္စ ယိရူၑာလမ အာဂတာ ယေ ယေ'ဓျာပကာသ္တေ ဇဂဒုရယံ ပုရုၐော ဘူတပတျာဗိၐ္ဋသ္တေန ဘူတပတိနာ ဘူတာန် တျာဇယတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","တတသ္တာနာဟူယ ယီၑု ရ္ဒၖၐ္ဋာန္တဲး ကထာံ ကထိတဝါန် ၑဲတာန် ကထံ ၑဲတာနံ တျာဇယိတုံ ၑက္နောတိ? ");
INSERT INTO sanbur_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","ကိဉ္စန ရာဇျံ ယဒိ သွဝိရောဓေန ပၖထဂ် ဘဝတိ တရှိ တဒ် ရာဇျံ သ္ထိရံ သ္ထာတုံ န ၑက္နောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","တထာ ကသျာပိ ပရိဝါရော ယဒိ ပရသ္ပရံ ဝိရောဓီ ဘဝတိ တရှိ သောပိ ပရိဝါရး သ္ထိရံ သ္ထာတုံ န ၑက္နောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","တဒွတ် ၑဲတာန် ယဒိ သွဝိပက္ၐတယာ ဥတ္တိၐ္ဌန် ဘိန္နော ဘဝတိ တရှိ သောပိ သ္ထိရံ သ္ထာတုံ န ၑက္နောတိ ကိန္တူစ္ဆိန္နော ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","အပရဉ္စ ပြဗလံ ဇနံ ပြထမံ န ဗဒ္ဓါ ကောပိ တသျ ဂၖဟံ ပြဝိၑျ ဒြဝျာဏိ လုဏ္ဌယိတုံ န ၑက္နောတိ, တံ ဗဒွွဲဝ တသျ ဂၖဟသျ ဒြဝျာဏိ လုဏ္ဌယိတုံ ၑက္နောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","အတောဟေတော ရျုၐ္မဘျမဟံ သတျံ ကထယာမိ မနုၐျာဏာံ သန္တာနာ ယာနိ ယာနိ ပါပါနီၑွရနိန္ဒာဉ္စ ကုရွွန္တိ တေၐာံ တတ္သရွွေၐာမပရာဓာနာံ က္ၐမာ ဘဝိတုံ ၑက္နောတိ, ");
INSERT INTO sanbur_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ကိန္တု ယး ကၑ္စိတ် ပဝိတြမာတ္မာနံ နိန္ဒတိ တသျာပရာဓသျ က္ၐမာ ကဒါပိ န ဘဝိၐျတိ သောနန္တဒဏ္ဍသျာရှော ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","တသျာပဝိတြဘူတော'သ္တိ တေၐာမေတတ္ကထာဟေတေား သ ဣတ္ထံ ကထိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","အထ တသျ မာတာ ဘြာတၖဂဏၑ္စာဂတျ ဗဟိသ္တိၐ္ဌနတော လောကာန် ပြေၐျ တမာဟူတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","တတသ္တတ္သန္နိဓော် သမုပဝိၐ္ဋာ လောကာသ္တံ ဗဘာၐိရေ ပၑျ ဗဟိသ္တဝ မာတာ ဘြာတရၑ္စ တွာမ် အနွိစ္ဆန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","တဒါ သ တာန် ပြတျုဝါစ မမ မာတာ ကာ ဘြာတရော ဝါ ကေ? တတး ပရံ သ သွမီပေါပဝိၐ္ဋာန် ၑိၐျာန် ပြတိ အဝလောကနံ ကၖတွာ ကထယာမာသ ");
INSERT INTO sanbur_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ပၑျတဲတေ မမ မာတာ ဘြာတရၑ္စ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ယး ကၑ္စိဒ် ဤၑွရသျေၐ္ဋာံ ကြိယာံ ကရောတိ သ ဧဝ မမ ဘြာတာ ဘဂိနီ မာတာ စ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","အနန္တရံ သ သမုဒြတဋေ ပုနရုပဒေၐ္ဋုံ ပြာရေဘေ, တတသ္တတြ ဗဟုဇနာနာံ သမာဂမာတ် သ သာဂရောပရိ နော်ကာမာရုဟျ သမုပဝိၐ္ဋး; သရွွေ လောကား သမုဒြကူလေ တသ္ထုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","တဒါ သ ဒၖၐ္ဋာန္တကထာဘိ ရ္ဗဟူပဒိၐ္ဋဝါန် ဥပဒိၑံၑ္စ ကထိတဝါန်, ");
INSERT INTO sanbur_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","အဝဓာနံ ကုရုတ, ဧကော ဗီဇဝပ္တာ ဗီဇာနိ ဝပ္တုံ ဂတး; ");
INSERT INTO sanbur_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ဝပနကာလေ ကိယန္တိ ဗီဇာနိ မာရ္ဂပါၑွေ ပတိတာနိ, တတ အာကာၑီယပက္ၐိဏ ဧတျ တာနိ စခါဒုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","ကိယန္တိ ဗီဇာနိ သွလ္ပမၖတ္တိကာဝတ္ပာၐာဏဘူမော် ပတိတာနိ တာနိ မၖဒေါလ္ပတွာတ် ၑီဃြမင်္ကုရိတာနိ; ");
INSERT INTO sanbur_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ကိန္တူဒိတေ သူရျျေ ဒဂ္ဓာနိ တထာ မူလာနော နာဓောဂတတွာတ် ၑုၐ္ကာဏိ စ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","ကိယန္တိ ဗီဇာနိ ကဏ္ဋကိဝနမဓျေ ပတိတာနိ တတး ကဏ္ဋကာနိ သံဝၖဒွျ တာနိ ဇဂြသုသ္တာနိ န စ ဖလိတာနိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","တထာ ကိယန္တိ ဗီဇာနျုတ္တမဘူမော် ပတိတာနိ တာနိ သံဝၖဒွျ ဖလာနျုတ္ပာဒိတာနိ ကိယန္တိ ဗီဇာနိ တြိံၑဒ္ဂုဏာနိ ကိယန္တိ ၐၐ္ဋိဂုဏာနိ ကိယန္တိ ၑတဂုဏာနိ ဖလာနိ ဖလိတဝန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","အထ သ တာနဝဒတ် ယသျ ၑြောတုံ ကရ္ဏော် သ္တး သ ၑၖဏောတု၊ ");
INSERT INTO sanbur_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","တဒနန္တရံ နိရ္ဇနသမယေ တတ္သင်္ဂိနော ဒွါဒၑၑိၐျာၑ္စ တံ တဒ္ဒၖၐ္ဋာန္တဝါကျသျာရ္ထံ ပပြစ္ဆုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","တဒါ သ တာနုဒိတဝါန် ဤၑွရရာဇျသျ နိဂူဎဝါကျံ ဗောဒ္ဓုံ ယုၐ္မာကမဓိကာရော'သ္တိ; ");
INSERT INTO sanbur_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ကိန္တု ယေ ဝဟိရ္ဘူတား \"တေ ပၑျန္တး ပၑျန္တိ ကိန္တု န ဇာနန္တိ, ၑၖဏွန္တး ၑၖဏွန္တိ ကိန္တု န ဗုဓျန္တေ, စေတ္တဲ ရ္မနးသု ကဒါပိ ပရိဝရ္တ္တိတေၐု တေၐာံ ပါပါနျမောစယိၐျန္တ,\" အတောဟေတောသ္တာန် ပြတိ ဒၖၐ္ဋာန္တဲရေဝ တာနိ မယာ ကထိတာနိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","အထ သ ကထိတဝါန် ယူယံ ကိမေတဒ် ဒၖၐ္ဋာန္တဝါကျံ န ဗုဓျဓွေ? တရှိ ကထံ သရွွာန် ဒၖၐ္ဋာန္တာန ဘောတ္သျဓွေ? ");
INSERT INTO sanbur_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ဗီဇဝပ္တာ ဝါကျရူပါဏိ ဗီဇာနိ ဝပတိ; ");
INSERT INTO sanbur_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","တတြ ယေ ယေ လောကာ ဝါကျံ ၑၖဏွန္တိ, ကိန္တု ၑြုတမာတြာတ် ၑဲတာန် ၑီဃြမာဂတျ တေၐာံ မနးသူပ္တာနိ တာနိ ဝါကျရူပါဏိ ဗီဇာနျပနယတိ တဧဝ ဥပ္တဗီဇမာရ္ဂပါရ္ၑွေသွရူပါး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ယေ ဇနာ ဝါကျံ ၑြုတွာ သဟသာ ပရမာနန္ဒေန ဂၖဟ္လန္တိ, ကိန္တု ဟၖဒိ သ္ထဲရျျာဘာဝါတ် ကိဉ္စိတ် ကာလမာတြံ တိၐ္ဌန္တိ တတ္ပၑ္စာတ် တဒွါကျဟေတေား ");
INSERT INTO sanbur_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ကုတြစိတ် က္လေၑေ ဥပဒြဝေ ဝါ သမုပသ္ထိတေ တဒဲဝ ဝိဃ္နံ ပြာပ္နုဝန္တိ တဧဝ ဥပ္တဗီဇပါၐာဏဘူမိသွရူပါး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","ယေ ဇနား ကထာံ ၑၖဏွန္တိ ကိန္တု သာံသာရိကီ စိန္တာ ဓနဘြာန္တိ ရွိၐယလောဘၑ္စ ဧတေ သရွွေ ဥပသ္ထာယ တာံ ကထာံ ဂြသန္တိ တတး မာ ဝိဖလာ ဘဝတိ ");
INSERT INTO sanbur_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","တဧဝ ဥပ္တဗီဇသကဏ္ဋကဘူမိသွရူပါး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ယေ ဇနာ ဝါကျံ ၑြုတွာ ဂၖဟ္လန္တိ တေၐာံ ကသျ ဝါ တြိံၑဒ္ဂုဏာနိ ကသျ ဝါ ၐၐ္ဋိဂုဏာနိ ကသျ ဝါ ၑတဂုဏာနိ ဖလာနိ ဘဝန္တိ တဧဝ ဥပ္တဗီဇောရွွရဘူမိသွရူပါး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","တဒါ သော'ပရမပိ ကထိတဝါန် ကောပိ ဇနော ဒီပါဓာရံ ပရိတျဇျ ဒြောဏသျာဓး ခဋွာယာ အဓေ ဝါ သ္ထာပယိတုံ ဒီပမာနယတိ ကိံ? ");
INSERT INTO sanbur_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","အတောဟေတော ရျန္န ပြကာၑယိၐျတေ တာဒၖဂ် လုက္ကာယိတံ ကိမပိ ဝသ္တု နာသ္တိ; ယဒ် ဝျက္တံ န ဘဝိၐျတိ တာဒၖၑံ ဂုပ္တံ ကိမပိ ဝသ္တု နာသ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ယသျ ၑြောတုံ ကရ္ဏော် သ္တး သ ၑၖဏောတု၊ ");
INSERT INTO sanbur_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","အပရမပိ ကထိတဝါန် ယူယံ ယဒ် ယဒ် ဝါကျံ ၑၖဏုထ တတြ သာဝဓာနာ ဘဝတ, ယတော ယူယံ ယေန ပရိမာဏေန ပရိမာထ တေနဲဝ ပရိမာဏေန ယုၐ္မဒရ္ထမပိ ပရိမာသျတေ; ၑြောတာရော ယူယံ ယုၐ္မဘျမဓိကံ ဒါသျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","ယသျာၑြယေ ဝရ္ဒ္ဓတေ တသ္မဲ အပရမပိ ဒါသျတေ, ကိန္တု ယသျာၑြယေ န ဝရ္ဒ္ဓတေ တသျ ယတ် ကိဉ္စိဒသ္တိ တဒပိ တသ္မာန် နေၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","အနန္တရံ သ ကထိတဝါန် ဧကော လောကး က္ၐေတြေ ဗီဇာနျုပ္တွာ ");
INSERT INTO sanbur_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ဇာဂရဏနိဒြာဘျာံ ဒိဝါနိၑံ ဂမယတိ, ပရန္တု တဒွီဇံ တသျာဇ္ဉာတရူပေဏာင်္ကုရယတိ ဝရ္ဒ္ဓတေ စ; ");
INSERT INTO sanbur_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ယတောဟေတေား ပြထမတး ပတြာဏိ တတး ပရံ ကဏိၑာနိ တတ္ပၑ္စာတ် ကဏိၑပူရ္ဏာနိ ၑသျာနိ ဘူမိး သွယမုတ္ပာဒယတိ; ");
INSERT INTO sanbur_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ကိန္တု ဖလေၐု ပက္ကေၐု ၑသျစ္ဆေဒနကာလံ ဇ္ဉာတွာ သ တတ္က္ၐဏံ ၑသျာနိ ဆိနတ္တိ, အနေန တုလျမီၑွရရာဇျံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","ပုနး သော'ကထယဒ် ဤၑွရရာဇျံ ကေန သမံ? ကေန ဝသ္တုနာ သဟ ဝါ တဒုပမာသျာမိ? ");
INSERT INTO sanbur_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","တတ် သရ္ၐပဲကေန တုလျံ ယတော မၖဒိ ဝပနကာလေ သရ္ၐပဗီဇံ သရွွပၖထိဝီသ္ထဗီဇာတ် က္ၐုဒြံ ");
INSERT INTO sanbur_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ကိန္တု ဝပနာတ် ပရမ် အင်္ကုရယိတွာ သရွွၑာကာဒ် ဗၖဟဒ် ဘဝတိ, တသျ ဗၖဟတျး ၑာခါၑ္စ ဇာယန္တေ တတသ္တစ္ဆာယာံ ပက္ၐိဏ အာၑြယန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ဣတ္ထံ တေၐာံ ဗောဓာနုရူပံ သော'နေကဒၖၐ္ဋာန္တဲသ္တာနုပဒိၐ္ဋဝါန်, ");
INSERT INTO sanbur_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ဒၖၐ္ဋာန္တံ ဝိနာ ကာမပိ ကထာံ တေဘျော န ကထိတဝါန် ပၑ္စာန် နိရ္ဇနေ သ ၑိၐျာန် သရွွဒၖၐ္ဋာန္တာရ္ထံ ဗောဓိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","တဒ္ဒိနသျ သန္ဓျာယာံ သ တေဘျော'ကထယဒ် အာဂစ္ဆတ ဝယံ ပါရံ ယာမ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","တဒါ တေ လောကာန် ဝိသၖဇျ တမဝိလမ္ဗံ ဂၖဟီတွာ နော်ကယာ ပြတသ္ထိရေ; အပရာ အပိ နာဝသ္တယာ သဟ သ္ထိတား၊ ");
INSERT INTO sanbur_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","တတး ပရံ မဟာဈဉ္ဘ္ၑဂမာတ် နော် ရ္ဒောလာယမာနာ တရင်္ဂေဏ ဇလဲး ပူရ္ဏာဘဝစ္စ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","တဒါ သ နော်ကာစၑ္စာဒ္ဘါဂေ ဥပဓာနေ ၑိရော နိဓာယ နိဒြိတ အာသီတ် တတသ္တေ တံ ဇာဂရယိတွာ ဇဂဒုး, ဟေ ပြဘော, အသ္မာကံ ပြာဏာ ယာန္တိ ကိမတြ ဘဝတၑ္စိန္တာ နာသ္တိ? ");
INSERT INTO sanbur_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","တဒါ သ ဥတ္ထာယ ဝါယုံ တရ္ဇိတဝါန် သမုဒြဉ္စောက္တဝါန် ၑာန္တး သုသ္ထိရၑ္စ ဘဝ; တတော ဝါယော် နိဝၖတ္တေ'ဗ္ဓိရ္နိသ္တရင်္ဂေါဘူတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","တဒါ သ တာနုဝါစ ယူယံ ကုတ ဧတာဒၖက္ၑင်္ကာကုလာ ဘဝတ? ကိံ ဝေါ ဝိၑွာသော နာသ္တိ? ");
INSERT INTO sanbur_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","တသ္မာတ္တေ'တီဝဘီတား ပရသ္ပရံ ဝက္တုမာရေဘိရေ, အဟော ဝါယုး သိန္ဓုၑ္စာသျ နိဒေၑဂြာဟိဏော် ကီဒၖဂယံ မနုဇး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","အထ တူ သိန္ဓုပါရံ ဂတွာ ဂိဒေရီယပြဒေၑ ဥပတသ္ထုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","နော်ကာတော နိရ္ဂတမာတြာဒ် အပဝိတြဘူတဂြသ္တ ဧကး ၑ္မၑာနာဒေတျ တံ သာက္ၐာစ် စကာရ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","သ ၑ္မၑာနေ'ဝါတ္သီတ် ကောပိ တံ ၑၖင်္ခလေန ဗဒွွာ သ္ထာပယိတုံ နာၑက္နောတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ဇနဲရွာရံ နိဂဍဲး ၑၖင်္ခလဲၑ္စ သ ဗဒ္ဓေါပိ ၑၖင်္ခလာနျာကၖၐျ မောစိတဝါန် နိဂဍာနိ စ ဘံက္တွာ ခဏ္ဍံ ခဏ္ဍံ ကၖတဝါန် ကောပိ တံ ဝၑီကရ္တ္တုံ န ၑၑက၊ ");
INSERT INTO sanbur_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ဒိဝါနိၑံ သဒါ ပရွွတံ ၑ္မၑာနဉ္စ ဘြမိတွာ စီတ္ၑဗ္ဒံ ကၖတဝါန် ဂြာဝဘိၑ္စ သွယံ သွံ ကၖတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","သ ယီၑုံ ဒူရာတ် ပၑျန္နေဝ ဓာဝန် တံ ပြဏနာမ ဥစဲရုဝံၑ္စောဝါစ, ");
INSERT INTO sanbur_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ဟေ သရွွောပရိသ္ထေၑွရပုတြ ယီၑော ဘဝတာ သဟ မေ ကး သမ္ဗန္ဓး? အဟံ တွာမီၑွရေဏ ၑာပယေ မာံ မာ ယာတယ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","ယတော ယီၑုသ္တံ ကထိတဝါန် ရေ အပဝိတြဘူတ, အသ္မာန္နရာဒ် ဗဟိရ္နိရ္ဂစ္ဆ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","အထ သ တံ ပၖၐ္ဋဝါန် ကိန္တေ နာမ? တေန ပြတျုက္တံ ဝယမနေကေ 'သ္မသ္တတော'သ္မန္နာမ ဗာဟိနီ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","တတောသ္မာန် ဒေၑာန္န ပြေၐယေတိ တေ တံ ပြာရ္ထယန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","တဒါနီံ ပရွွတံ နိကၐာ ဗၖဟန် ဝရာဟဝြဇၑ္စရန္နာသီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","တသ္မာဒ် ဘူတာ ဝိနယေန ဇဂဒုး, အမုံ ဝရာဟဝြဇမ် အာၑြယိတုမ် အသ္မာန် ပြဟိဏု၊ ");
INSERT INTO sanbur_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ယီၑုနာနုဇ္ဉာတာသ္တေ'ပဝိတြဘူတာ ဗဟိရ္နိရျာယ ဝရာဟဝြဇံ ပြာဝိၑန် တတး သရွွေ ဝရာဟာ ဝသ္တုတသ္တု ပြာယောဒွိသဟသြသံင်္ချကား ကဋကေန မဟာဇဝါဒ် ဓာဝန္တး သိန္ဓော် ပြာဏာန် ဇဟုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","တသ္မာဒ် ဝရာဟပါလကား ပလာယမာနား ပုရေ ဂြာမေ စ တဒွါရ္တ္တံ ကထယာဉ္စကြုး၊ တဒါ လောကာ ဃဋိတံ တတ္ကာရျျံ ဒြၐ္ဋုံ ဗဟိရ္ဇဂ္မုး ");
INSERT INTO sanbur_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ယီၑေား သန္နိဓိံ ဂတွာ တံ ဘူတဂြသ္တမ် အရ္ထာဒ် ဗာဟိနီဘူတဂြသ္တံ နရံ သဝသ္တြံ သစေတနံ သမုပဝိၐ္ဋဉ္စ ဒၖृၐ္ဋွာ ဗိဘျုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","တတော ဒၖၐ္ဋတတ္ကာရျျလောကာသ္တသျ ဘူတဂြသ္တနရသျ ဝရာဟဝြဇသျာပိ တာံ ဓဋနာံ ဝရ္ဏယာမာသုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","တတသ္တေ သွသီမာတော ဗဟိရ္ဂန္တုံ ယီၑုံ ဝိနေတုမာရေဘိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","အထ တသျ နော်ကာရောဟဏကာလေ သ ဘူတမုက္တော နာ ယီၑုနာ သဟ သ္ထာတုံ ပြာရ္ထယတေ; ");
INSERT INTO sanbur_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","ကိန္တု သ တမနနုမတျ ကထိတဝါန် တွံ နိဇာတ္မီယာနာံ သမီပံ ဂၖဟဉ္စ ဂစ္ဆ ပြဘုသ္တွယိ ကၖပါံ ကၖတွာ ယာနိ ကရ္မ္မာဏိ ကၖတဝါန် တာနိ တာန် ဇ္ဉာပယ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","အတး သ ပြသ္ထာယ ယီၑုနာ ကၖတံ တတ္သရွွာၑ္စရျျံ ကရ္မ္မ ဒိကာပလိဒေၑေ ပြစာရယိတုံ ပြာရဗ္ဓဝါန် တတး သရွွေ လောကာ အာၑ္စရျျံ မေနိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","အနန္တရံ ယီၑော် နာဝါ ပုနရနျပါရ ဥတ္တီရ္ဏေ သိန္ဓုတဋေ စ တိၐ္ဌတိ သတိ တတ္သမီပေ ဗဟုလောကာနာံ သမာဂမော'ဘူတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","အပရံ ယာယီရ် နာမ္နာ ကၑ္စိဒ် ဘဇနဂၖဟသျာဓိပ အာဂတျ တံ ဒၖၐ္ဋွဲဝ စရဏယေား ပတိတွာ ဗဟု နိဝေဒျ ကထိတဝါန်; ");
INSERT INTO sanbur_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","မမ ကနျာ မၖတပြာယာဘူဒ် အတော ဘဝါနေတျ တဒါရောဂျာယ တသျာ ဂါတြေ ဟသ္တမ် အရ္ပယတု တေနဲဝ သာ ဇီဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","တဒါ ယီၑုသ္တေန သဟ စလိတး ကိန္တု တတ္ပၑ္စာဒ် ဗဟုလောကာၑ္စလိတွာ တာဒ္ဂါတြေ ပတိတား၊ ");
INSERT INTO sanbur_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","အထ ဒွါဒၑဝရ္ၐာဏိ ပြဒရရောဂေဏ ");
INSERT INTO sanbur_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ၑီရ္ဏာ စိကိတ္သကာနာံ နာနာစိကိတ္သာဘိၑ္စ ဒုးခံ ဘုက္တဝတီ စ သရွွသွံ ဝျယိတွာပိ နာရောဂျံ ပြာပ္တာ စ ပုနရပိ ပီဍိတာသီစ္စ ");
INSERT INTO sanbur_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ယာ သ္တြီ သာ ယီၑော ရွာရ္တ္တာံ ပြာပျ မနသာကထယတ် ယဒျဟံ တသျ ဝသ္တြမာတြ သ္ပြၐ္ဋုံ လဘေယံ တဒါ ရောဂဟီနာ ဘဝိၐျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","အတောဟေတေား သာ လောကာရဏျမဓျေ တတ္ပၑ္စာဒါဂတျ တသျ ဝသ္တြံ ပသ္ပရ္ၑ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","တေနဲဝ တတ္က္ၐဏံ တသျာ ရက္တသြောတး ၑုၐ္ကံ သွယံ တသ္မာဒ် ရောဂါန္မုက္တာ ဣတျပိ ဒေဟေ'နုဘူတာ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","အထ သွသ္မာတ် ၑက္တိ ရ္နိရ္ဂတာ ယီၑုရေတန္မနသာ ဇ္ဉာတွာ လောကနိဝဟံ ပြတိ မုခံ ဝျာဝၖတျ ပၖၐ္ဋဝါန် ကေန မဒွသ္တြံ သ္ပၖၐ္ဋံ? ");
INSERT INTO sanbur_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","တတသ္တသျ ၑိၐျာ ဦစုး ဘဝတော ဝပုၐိ လောကား သံဃရ္ၐန္တိ တဒ် ဒၖၐ္ဋွာ ကေန မဒွသ္တြံ သ္ပၖၐ္ဋမိတိ ကုတး ကထယတိ? ");
INSERT INTO sanbur_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","ကိန္တု ကေန တတ် ကရ္မ္မ ကၖတံ တဒ် ဒြၐ္ဋုံ ယီၑုၑ္စတုရ္ဒိၑော ဒၖၐ္ဋဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","တတး သာ သ္တြီ ဘီတာ ကမ္ပိတာ စ သတီ သွသျာ ရုက္ပြတိကြိယာ ဇာတေတိ ဇ္ဉာတွာဂတျ တတ္သမ္မုခေ ပတိတွာ သရွွဝၖတ္တာန္တံ သတျံ တသ္မဲ ကထယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","တဒါနီံ ယီၑုသ္တာံ ဂဒိတဝါန်, ဟေ ကနျေ တဝ ပြတီတိသ္တွာမ် အရောဂါမကရောတ် တွံ က္ၐေမေဏ ဝြဇ သွရောဂါန္မုက္တာ စ တိၐ္ဌ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ဣတိဝါကျဝဒနကာလေ ဘဇနဂၖဟာဓိပသျ နိဝေၑနာလ် လောကာ ဧတျာဓိပံ ဗဘာၐိရေ တဝ ကနျာ မၖတာ တသ္မာဒ် ဂုရုံ ပုနး ကုတး က္လိၑ္နာသိ? ");
INSERT INTO sanbur_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","ကိန္တု ယီၑုသ္တဒ် ဝါကျံ ၑြုတွဲဝ ဘဇနဂၖဟာဓိပံ ဂဒိတဝါန် မာ ဘဲၐီး ကေဝလံ ဝိၑွာသိဟိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","အထ ပိတရော ယာကူဗ် တဒ္ဘြာတာ ယောဟန် စ ဧတာန် ဝိနာ ကမပိ သွပၑ္စာဒ် ယာတုံ နာနွမနျတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","တသျ ဘဇနဂၖဟာဓိပသျ နိဝေၑနသမီပမ် အာဂတျ ကလဟံ ဗဟုရောဒနံ ဝိလာပဉ္စ ကုရွွတော လောကာန် ဒဒရ္ၑ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","တသ္မာန် နိဝေၑနံ ပြဝိၑျ ပြောက္တဝါန် ယူယံ ကုတ ဣတ္ထံ ကလဟံ ရောဒနဉ္စ ကုရုထ? ကနျာ န မၖတာ နိဒြာတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","တသ္မာတ္တေ တမုပဇဟသုး ကိန္တု ယီၑုး သရွွာန ဗဟိၐ္ကၖတျ ကနျာယား ပိတရော် သွသင်္ဂိနၑ္စ ဂၖဟီတွာ ယတြ ကနျာသီတ် တတ် သ္ထာနံ ပြဝိၐ္ဋဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","အထ သ တသျား ကနျာယာ ဟသ္တော် ဓၖတွာ တာံ ဗဘာၐေ ဋာလီထာ ကူမီ, အရ္ထတော ဟေ ကနျေ တွမုတ္တိၐ္ဌ ဣတျာဇ္ဉာပယာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","တုနဲဝ တတ္က္ၐဏံ သာ ဒွါဒၑဝရ္ၐဝယသ္ကာ ကနျာ ပေါတ္ထာယ စလိတုမာရေဘေ, ဣတး သရွွေ မဟာဝိသ္မယံ ဂတား၊ ");
INSERT INTO sanbur_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","တတ ဧတသျဲ ကိဉ္စိတ် ခါဒျံ ဒတ္တေတိ ကထယိတွာ ဧတတ္ကရ္မ္မ ကမပိ န ဇ္ဉာပယတေတိ ဒၖဎမာဒိၐ္ဋဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","အနန္တရံ သ တတ္သ္ထာနာတ် ပြသ္ထာယ သွပြဒေၑမာဂတး ၑိၐျာၑ္စ တတ္ပၑ္စာဒ် ဂတား၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","အထ ဝိၑြာမဝါရေ သတိ သ ဘဇနဂၖဟေ ဥပဒေၐ္ဋုမာရဗ္ဓဝါန် တတော'နေကေ လောကာသ္တတ္ကထာံ ၑြုတွာ ဝိသ္မိတျ ဇဂဒုး, အသျ မနုဇသျ ဤဒၖၑီ အာၑ္စရျျကြိယာ ကသ္မာဇ် ဇာတာ? တထာ သွကရာဘျာမ် ဣတ္ထမဒ္ဘုတံ ကရ္မ္မ ကရ္တ္တာुမ် ဧတသ္မဲ ကထံ ဇ္ဉာနံ ဒတ္တမ်? ");
INSERT INTO sanbur_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","ကိမယံ မရိယမး ပုတြသ္တဇ္ဉာ နော? ကိမယံ ယာကူဗ်-ယောသိ-ယိဟုဒါ-ၑိမောနာံ ဘြာတာ နော? အသျ ဘဂိနျး ကိမိဟာသ္မာဘိး သဟ နော? ဣတ္ထံ တေ တဒရ္ထေ ပြတျူဟံ ဂတား၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","တဒါ ယီၑုသ္တေဘျော'ကထယတ် သွဒေၑံ သွကုဋုမ္ဗာန် သွပရိဇနာံၑ္စ ဝိနာ ကုတြာပိ ဘဝိၐျဒွါဒီ အသတ္ကၖတော န ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","အပရဉ္စ တေၐာမပြတျယာတ် သ ဝိသ္မိတး ကိယတာံ ရောဂိဏာံ ဝပုးၐု ဟသ္တမ် အရ္ပယိတွာ ကေဝလံ တေၐာမာရောဂျကရဏာဒ် အနျတ် ကိမပိ စိတြကာရျျံ ကရ္တ္တာံ န ၑက္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","အထ သ စတုရ္ဒိက္သ္ထ ဂြာမာန် ဘြမိတွာ ဥပဒိၐ္ဋဝါန္ ");
INSERT INTO sanbur_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ဒွါဒၑၑိၐျာန် အာဟူယ အမေဓျဘူတာန် ဝၑီကရ္တ္တာံ ၑက္တိံ ဒတ္တွာ တေၐာံ ဒွေါ် ဒွေါ် ဇနော ပြေၐိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ပုနရိတျာဒိၑဒ် ယူယမ် ဧကဲကာံ ယၐ္ဋိံ ဝိနာ ဝသ္တြသံပုဋး ပူပး ကဋိဗန္ဓေ တာမြခဏ္ဍဉ္စ ဧၐာံ ကိမပိ မာ ဂြဟ္လီတ, ");
INSERT INTO sanbur_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","မာရ္ဂယာတြာယဲ ပါဒေၐူပါနဟော် ဒတ္တွာ ဒွေ ဥတ္တရီယေ မာ ပရိဓဒွွံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","အပရမပျုက္တံ တေန ယူယံ ယသျာံ ပုရျျာံ ယသျ နိဝေၑနံ ပြဝေက္ၐျထ တာံ ပုရီံ ယာဝန္န တျက္ၐျထ တာဝတ် တန္နိဝေၑနေ သ္ထာသျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","တတြ ယဒိ ကေပိ ယုၐ္မာကမာတိထျံ န ဝိဒဓတိ ယုၐ္မာကံ ကထာၑ္စ န ၑၖဏွန္တိ တရှိ တတ္သ္ထာနာတ် ပြသ္ထာနသမယေ တေၐာံ ဝိရုဒ္ဓံ သာက္ၐျံ ဒါတုံ သွပါဒါနာသ္ဖာလျ ရဇး သမ္ပာတယတ; အဟံ ယုၐ္မာန် ယထာရ္ထံ ဝစ္မိ ဝိစာရဒိနေ တန္နဂရသျာဝသ္ထာတး သိဒေါမာမောရယော ရ္နဂရယောရဝသ္ထာ သဟျတရာ ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","အထ တေ ဂတွာ လောကာနာံ မနးပရာဝရ္တ္တနီး ကထာ ပြစာရိတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ဧဝမနေကာန် ဘူတာံၑ္စ တျာဇိတဝန္တသ္တထာ တဲလေန မရ္ဒ္ဒယိတွာ ဗဟူန် ဇနာနရောဂါနကာရ္ၐုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ဣတ္ထံ တသျ သုချာတိၑ္စတုရ္ဒိၑော ဝျာပ္တာ တဒါ ဟေရောဒ် ရာဇာ တန္နိၑမျ ကထိတဝါန်, ယောဟန် မဇ္ဇကး ၑ္မၑာနာဒ် ဥတ္ထိတ အတောဟေတောသ္တေန သရွွာ ဧတာ အဒ္ဘုတကြိယား ပြကာၑန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","အနျေ'ကထယန် အယမ် ဧလိယး, ကေပိ ကထိတဝန္တ ဧၐ ဘဝိၐျဒွါဒီ ယဒွါ ဘဝိၐျဒွါဒိနာံ သဒၖၑ ဧကောယမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","ကိန္တု ဟေရောဒ် ဣတျာကရ္ဏျ ဘာၐိတဝါန် ယသျာဟံ ၑိရၑ္ဆိန္နဝါန် သ ဧဝ ယောဟနယံ သ ၑ္မၑာနာဒုဒတိၐ္ဌတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","ပူရွွံ သွဘြာတုး ဖိလိပသျ ပတ္နျာ ဥဒွါဟံ ကၖတဝန္တံ ဟေရောဒံ ယောဟနဝါဒီတ် သွဘာတၖဝဓူ ရ္န ဝိဝါဟျာ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","အတး ကာရဏာတ် ဟေရောဒ် လောကံ ပြဟိတျ ယောဟနံ ဓၖတွာ ဗန္ဓနာလယေ ဗဒ္ဓဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ဟေရောဒိယာ တသ္မဲ ယောဟနေ ပြကုပျ တံ ဟန္တုမ် အဲစ္ဆတ် ကိန္တု န ၑက္တာ, ");
INSERT INTO sanbur_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ယသ္မာဒ် ဟေရောဒ် တံ ဓာရ္မ္မိကံ သတ္ပုရုၐဉ္စ ဇ္ဉာတွာ သမ္မနျ ရက္ၐိတဝါန်; တတ္ကထာံ ၑြုတွာ တဒနုသာရေဏ ဗဟူနိ ကရ္မ္မာဏိ ကၖတဝါန် ဟၖၐ္ဋမနာသ္တဒုပဒေၑံ ၑြုတဝါံၑ္စ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","ကိန္တု ဟေရောဒ် ယဒါ သွဇန္မဒိနေ ပြဓာနလောကေဘျး သေနာနီဘျၑ္စ ဂါလီလ္ပြဒေၑီယၑြေၐ္ဌလောကေဘျၑ္စ ရာတြော် ဘောဇျမေကံ ကၖတဝါန္ ");
INSERT INTO sanbur_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","တသ္မိန် ၑုဘဒိနေ ဟေရောဒိယာယား ကနျာ သမေတျ တေၐာံ သမက္ၐံ သံနၖတျ ဟေရောဒသ္တေန သဟောပဝိၐ္ဋာနာဉ္စ တောၐမဇီဇနတ် တတာ နၖပး ကနျာမာဟ သ္မ မတ္တော ယဒ် ယာစသေ တဒေဝ တုဘျံ ဒါသျေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ၑပထံ ကၖတွာကထယတ် စေဒ် ရာဇျာရ္ဒ္ဓမပိ ယာစသေ တဒပိ တုဘျံ ဒါသျေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","တတး သာ ဗဟိ ရ္ဂတွာ သွမာတရံ ပပြစ္ဆ ကိမဟံ ယာစိၐျေ? တဒါ သာကထယတ် ယောဟနော မဇ္ဇကသျ ၑိရး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","အထ တူရ္ဏံ ဘူပသမီပမ် ဧတျ ယာစမာနာဝဒတ် က္ၐဏေသ္မိန် ယောဟနော မဇ္ဇကသျ ၑိရး ပါတြေ နိဓာယ ဒေဟိ, ဧတဒ် ယာစေ'ဟံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","တသ္မာတ် ဘူပေါ'တိဒုးခိတး, တထာပိ သွၑပထသျ သဟဘောဇိနာဉ္စာနုရောဓာတ် တဒနင်္ဂီကရ္တ္တုံ န ၑက္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","တတ္က္ၐဏံ ရာဇာ ဃာတကံ ပြေၐျ တသျ ၑိရ အာနေတုမာဒိၐ္ဋဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","တတး သ ကာရာဂါရံ ဂတွာ တစ္ဆိရၑ္ဆိတွာ ပါတြေ နိဓာယာနီယ တသျဲ ကနျာယဲ ဒတ္တဝါန် ကနျာ စ သွမာတြေ ဒဒေါ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","အနနတရံ ယောဟနး ၑိၐျာသ္တဒွါရ္တ္တာံ ပြာပျာဂတျ တသျ ကုဏပံ ၑ္မၑာနေ'သ္ထာပယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","အထ ပြေၐိတာ ယီၑေား သန္နိဓော် မိလိတာ ယဒ် ယစ် စကြုး ၑိက္ၐယာမာသုၑ္စ တတ္သရွွဝါရ္တ္တာသ္တသ္မဲ ကထိတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","သ တာနုဝါစ ယူယံ ဝိဇနသ္ထာနံ ဂတွာ ဝိၑြာမျတ ယတသ္တတ္သန္နိဓော် ဗဟုလောကာနာံ သမာဂမာတ် တေ ဘောက္တုံ နာဝကာၑံ ပြာပ္တား၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","တတသ္တေ နာဝါ ဝိဇနသ္ထာနံ ဂုပ္တံ ဂဂ္မုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","တတော လောကနိဝဟသ္တေၐာံ သ္ထာနာန္တရယာနံ ဒဒရ္ၑ, အနေကေ တံ ပရိစိတျ နာနာပုရေဘျး ပဒဲရွြဇိတွာ ဇဝေန တဲၐာမဂြေ ယီၑေား သမီပ ဥပတသ္ထုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","တဒါ ယီၑု ရ္နာဝေါ ဗဟိရ္ဂတျ လောကာရဏျာနီံ ဒၖၐ္ဋွာ တေၐု ကရုဏာံ ကၖတဝါန် ယတသ္တေ'ရက္ၐကမေၐာ ဣဝါသန် တဒါ သ တာန နာနာပြသင်္ဂါန် ဥပဒိၐ္ဋဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","အထ ဒိဝါန္တေ သတိ ၑိၐျာ ဧတျ ယီၑုမူစိရေ, ဣဒံ ဝိဇနသ္ထာနံ ဒိနဉ္စာဝသန္နံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","လောကာနာံ ကိမပိ ခါဒျံ နာသ္တိ, အတၑ္စတုရ္ဒိက္ၐု ဂြာမာန် ဂန္တုံ ဘောဇျဒြဝျာဏိ ကြေတုဉ္စ ဘဝါန် တာန် ဝိသၖဇတု၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","တဒါ သ တာနုဝါစ ယူယမေဝ တာန် ဘောဇယတ; တတသ္တေ ဇဂဒု ရွယံ ဂတွာ ဒွိၑတသံချကဲ ရ္မုဒြာပါဒဲး ပူပါန် ကြီတွာ ကိံ တာန် ဘောဇယိၐျာမး? ");
INSERT INTO sanbur_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","တဒါ သ တာန် ပၖၐ္ဌဝါန် ယုၐ္မာကံ သန္နိဓော် ကတိ ပူပါ အာသတေ? ဂတွာ ပၑျတ; တတသ္တေ ဒၖၐ္ဋွာ တမဝဒန် ပဉ္စ ပူပါ ဒွေါ် မတ္သျော် စ သန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","တဒါ သ လောကာန် ၑသ္ပောပရိ ပံက္တိဘိရုပဝေၑယိတုမ် အာဒိၐ္ဋဝါန်, ");
INSERT INTO sanbur_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","တတသ္တေ ၑတံ ၑတံ ဇနား ပဉ္စာၑတ် ပဉ္စာၑဇ္ဇနာၑ္စ ပံက္တိဘိ ရ္ဘုဝိ သမုပဝိဝိၑုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","အထ သ တာန် ပဉ္စပူပါန် မတ္သျဒွယဉ္စ ဓၖတွာ သွရ္ဂံ ပၑျန် ဤၑွရဂုဏာန် အနွကီရ္တ္တယတ် တာန် ပူပါန် ဘံက္တွာ လောကေဘျး ပရိဝေၐယိတုံ ၑိၐျေဘျော ဒတ္တဝါန် ဒွါ မတ္သျော် စ ဝိဘဇျ သရွွေဘျော ဒတ္တဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","တတး သရွွေ ဘုက္တွာတၖပျန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","အနန္တရံ ၑိၐျာ အဝၑိၐ္ဋဲး ပူပဲ ရ္မတ္သျဲၑ္စ ပူရ္ဏာန် ဒွဒၑ ဍလ္လကာန် ဇဂၖဟုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","တေ ဘောက္တာရး ပြာယး ပဉ္စ သဟသြာဏိ ပုရုၐာ အာသန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","အထ သ လောကာန် ဝိသၖဇန္နေဝ နာဝမာရောဎုံ သွသ္မာဒဂြေ ပါရေ ဗဲတ္သဲဒါပုရံ ယာတုဉ္စ ၑ္ၐျိाန် ဝါဎမာဒိၐ္ဋဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","တဒါ သ သရွွာန် ဝိသၖဇျ ပြာရ္ထယိတုံ ပရွွတံ ဂတး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","တတး သန္ဓျာယာံ သတျာံ နော်း သိန္ဓုမဓျ ဥပသ္ထိတာ ကိန္တု သ ဧကာကီ သ္ထလေ သ္ထိတး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","အထ သမ္မုခဝါတဝဟနာတ် ၑိၐျာ နာဝံ ဝါဟယိတွာ ပရိၑြာန္တာ ဣတိ ဇ္ဉာတွာ သ နိၑာစတုရ္ထယာမေ သိန္ဓူပရိ ပဒ္ဘျာံ ဝြဇန် တေၐာံ သမီပမေတျ တေၐာမဂြေ ယာတုမ် ဥဒျတး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ကိန္တု ၑိၐျား သိန္ဓူပရိ တံ ဝြဇန္တံ ဒၖၐ္ဋွာ ဘူတမနုမာယ ရုရုဝုး, ");
INSERT INTO sanbur_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ယတး သရွွေ တံ ဒၖၐ္ဋွာ ဝျာကုလိတား၊ အတဧဝ ယီၑုသ္တတ္က္ၐဏံ တဲး သဟာလပျ ကထိတဝါန်, သုသ္ထိရာ ဘူတ, အယမဟံ မာ ဘဲၐ္ဋ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","အထ နော်ကာမာရုဟျ တသ္မိန် တေၐာံ သန္နိဓိံ ဂတေ ဝါတော နိဝၖတ္တး; တသ္မာတ္တေ မနးသု ဝိသ္မိတာ အာၑ္စရျျံ မေနိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ယတသ္တေ မနသာံ ကာဌိနျာတ် တတ် ပူပီယမ် အာၑ္စရျျံ ကရ္မ္မ န ဝိဝိက္တဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","အထ တေ ပါရံ ဂတွာ ဂိနေၐရတ္ပြဒေၑမေတျ တဋ ဥပသ္ထိတား၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","တေၐု နော်ကာတော ဗဟိရ္ဂတေၐု တတ္ပြဒေၑီယာ လောကာသ္တံ ပရိစိတျ ");
INSERT INTO sanbur_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","စတုရ္ဒိက္ၐု ဓာဝန္တော ယတြ ယတြ ရောဂိဏော နရာ အာသန် တာန် သရွွာန ခဋွောပရိ နိဓာယ ယတြ ကုတြစိတ် တဒွါရ္တ္တာံ ပြာပုး တတ် သ္ထာနမ် အာနေတုမ် အာရေဘိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","တထာ ယတြ ယတြ ဂြာမေ ယတြ ယတြ ပုရေ ယတြ ယတြ ပလ္လျာဉ္စ တေန ပြဝေၑး ကၖတသ္တဒွရ္တ္မမဓျေ လောကား ပီဍိတာန် သ္ထာပယိတွာ တသျ စေလဂြန္ထိမာတြံ သ္ပြၐ္ဋုမ် တေၐာမရ္ထေ တဒနုဇ္ဉာံ ပြာရ္ထယန္တး ယာဝန္တော လောကား ပသ္ပၖၑုသ္တာဝန္တ ဧဝ ဂဒါန္မုက္တား၊ ");
INSERT INTO sanbur_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","အနန္တရံ ယိရူၑာလမ အာဂတား ဖိရူၑိနော'ဓျာပကာၑ္စ ယီၑေား သမီပမ် အာဂတား၊ ");
INSERT INTO sanbur_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","တေ တသျ ကိယတး ၑိၐျာန် အၑုစိကရဲရရ္ထာဒ အပြက္ၐာလိတဟသ္တဲ ရ္ဘုဉ္ဇတော ဒၖၐ္ဋွာ တာနဒူၐယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ယတး ဖိရူၑိနး သရွွယိဟူဒီယာၑ္စ ပြာစာံ ပရမ္ပရာဂတဝါကျံ သမ္မနျ ပြတလေန ဟသ္တာန် အပြက္ၐာလျ န ဘုဉ္ဇတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","အာပနာဒါဂတျ မဇ္ဇနံ ဝိနာ န ခါဒန္တိ; တထာ ပါနပါတြာဏာံ ဇလပါတြာဏာံ ပိတ္တလပါတြာဏာမ် အာသနာနာဉ္စ ဇလေ မဇ္ဇနမ် ဣတျာဒယောနျေပိ ဗဟဝသ္တေၐာမာစာရား သန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","တေ ဖိရူၑိနော'ဓျာပကာၑ္စ ယီၑုံ ပပြစ္ဆုး, တဝ ၑိၐျား ပြာစာံ ပရမ္ပရာဂတဝါကျာနုသာရေဏ နာစရန္တော'ပြက္ၐာလိတကရဲး ကုတော ဘုဇံတေ? ");
INSERT INTO sanbur_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","တတး သ ပြတျုဝါစ ကပဋိနော ယုၐ္မာန် ဥဒ္ဒိၑျ ယိၑယိယဘဝိၐျဒွါဒီ ယုက္တမဝါဒီတ်၊ ယထာ သွကီယဲရဓရဲရေတေ သမ္မနျနတေ သဒဲဝ မာံ၊ ကိန္တု မတ္တော ဝိပြကရ္ၐေ သန္တိ တေၐာံ မနာံသိ စ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ၑိက္ၐယန္တော ဗိဓီန် န္နာဇ္ဉာ ဘဇန္တေ မာံ မုဓဲဝ တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","ယူယံ ဇလပါတြပါနပါတြာဒီနိ မဇ္ဇယန္တော မနုဇပရမ္ပရာဂတဝါကျံ ရက္ၐထ ကိန္တု ဤၑွရာဇ္ဉာံ လံဃဓွေ; အပရာ ဤဒၖၑျောနေကား ကြိယာ အပိ ကုရုဓွေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","အနျဉ္စာကထယတ် ယူယံ သွပရမ္ပရာဂတဝါကျသျ ရက္ၐာရ္ထံ သ္ပၐ္ဋရူပေဏ ဤၑွရာဇ္ဉာံ လောပယထ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","ယတော မူသာဒွါရာ ပြောက္တမသ္တိ သွပိတရော် သမ္မနျဓွံ ယသ္တု မာတရံ ပိတရံ ဝါ ဒုရွွာကျံ ဝက္တိ သ နိတာန္တံ ဟနျတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","ကိန္တု မဒီယေန ယေန ဒြဝျေဏ တဝေါပကာရောဘဝတ် တတ် ကရ္ဗ္ဗာဏမရ္ထာဒ် ဤၑွရာယ နိဝေဒိတမ် ဣဒံ ဝါကျံ ယဒိ ကောပိ ပိတရံ မာတရံ ဝါ ဝက္တိ ");
INSERT INTO sanbur_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","တရှိ ယူယံ မာတုး ပိတု ရွောပကာရံ ကရ္တ္တာံ တံ ဝါရယထ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ဣတ္ထံ သွပြစာရိတပရမ္ပရာဂတဝါကျေန ယူယမ် ဤၑွရာဇ္ဉာံ မုဓာ ဝိဓဒွွေ, ဤဒၖၑာနျနျာနျနေကာနိ ကရ္မ္မာဏိ ကုရုဓွေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","အထ သ လောကာနာဟူယ ဗဘာၐေ ယူယံ သရွွေ မဒွါကျံ ၑၖဏုတ ဗုဓျဓွဉ္စ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ဗာဟျာဒန္တရံ ပြဝိၑျ နရမမေဓျံ ကရ္တ္တာံ ၑက္နောတိ ဤဒၖၑံ ကိမပိ ဝသ္တု နာသ္တိ, ဝရမ် အန္တရာဒ် ဗဟိရ္ဂတံ ယဒွသ္တု တန္မနုဇမ် အမေဓျံ ကရောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","ယသျ ၑြောတုံ ၑြောတြေ သ္တး သ ၑၖဏောတု၊ ");
INSERT INTO sanbur_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","တတး သ လောကာန် ဟိတွာ ဂၖဟမဓျံ ပြဝိၐ္ဋသ္တဒါ ၑိၐျာသ္တဒၖၐ္ဋာန္တဝါကျာရ္ထံ ပပြစ္ဆုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","တသ္မာတ် သ တာန် ဇဂါဒ ယူယမပိ ကိမေတာဒၖဂဗောဓား? ကိမပိ ဒြဝျံ ဗာဟျာဒန္တရံ ပြဝိၑျ နရမမေဓျံ ကရ္တ္တာံ န ၑက္နောတိ ကထာမိမာံ ကိံ န ဗုဓျဓွေ? ");
INSERT INTO sanbur_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","တတ် တဒန္တရ္န ပြဝိၑတိ ကိန္တု ကုက္ၐိမဓျံ ပြဝိၑတိ ၑေၐေ သရွွဘုက္တဝသ္တုဂြာဟိဏိ ဗဟိရ္ဒေၑေ နိရျာတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","အပရမပျဝါဒီဒ် ယန္နရာန္နိရေတိ တဒေဝ နရမမေဓျံ ကရောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","ယတော'န္တရာဒ် အရ္ထာန် မာနဝါနာံ မနောဘျး ကုစိန္တာ ပရသ္တြီဝေၑျာဂမနံ ");
INSERT INTO sanbur_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","နရဝဓၑ္စော်ရျျံ လောဘော ဒုၐ္ဋတာ ပြဝဉ္စနာ ကာမုကတာ ကုဒၖၐ္ဋိရီၑွရနိန္ဒာ ဂရွွသ္တမ ဣတျာဒီနိ နိရ္ဂစ္ဆန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ဧတာနိ သရွွာဏိ ဒုရိတာနျန္တရာဒေတျ နရမမေဓျံ ကုရွွန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","အထ သ ဥတ္ထာယ တတ္သ္ထာနာတ် သောရသီဒေါန္ပုရပြဒေၑံ ဇဂါမ တတြ ကိမပိ နိဝေၑနံ ပြဝိၑျ သရွွဲရဇ္ဉာတး သ္ထာတုံ မတိဉ္စကြေ ကိန္တု ဂုပ္တး သ္ထာတုံ န ၑၑာက၊ ");
INSERT INTO sanbur_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ယတး သုရဖဲနိကီဒေၑီယယူနာနီဝံၑောဒ္ဘဝသ္တြိယား ကနျာ ဘူတဂြသ္တာသီတ်၊ သာ သ္တြီ တဒွါရ္တ္တာံ ပြာပျ တတ္သမီပမာဂတျ တစ္စရဏယေား ပတိတွာ ");
INSERT INTO sanbur_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","သွကနျာတော ဘူတံ နိရာကရ္တ္တာံ တသ္မိန် ဝိနယံ ကၖတဝတီ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","ကိန္တု ယီၑုသ္တာမဝဒတ် ပြထမံ ဗာလကာသ္တၖပျန္တု ယတော ဗာလကာနာံ ခါဒျံ ဂၖဟီတွာ ကုက္ကုရေဘျော နိက္ၐေပေါ'နုစိတး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","တဒါ သာ သ္တြီ တမဝါဒီတ် ဘေား ပြဘော တတ် သတျံ တထာပိ မဉ္စာဓးသ္ထား ကုက္ကုရာ ဗာလာနာံ ကရပတိတာနိ ခါဒျခဏ္ဍာနိ ခါဒန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","တတး သော'ကထယဒ် ဧတတ္ကထာဟေတေား သကုၑလာ ယာဟိ တဝ ကနျာံ တျက္တွာ ဘူတော ဂတး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","အထ သာ သ္တြီ ဂၖဟံ ဂတွာ ကနျာံ ဘူတတျက္တာံ ၑယျာသ္ထိတာံ ဒဒရ္ၑ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","ပုနၑ္စ သ သောရသီဒေါန္ပုရပြဒေၑာတ် ပြသ္ထာယ ဒိကာပလိဒေၑသျ ပြာန္တရဘာဂေန ဂါလီလ္ဇလဓေး သမီပံ ဂတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","တဒါ လောကဲရေကံ ဗဓိရံ ကဒွဒဉ္စ နရံ တန္နိကဋမာနီယ တသျ ဂါတြေ ဟသ္တမရ္ပယိတုံ ဝိနယး ကၖတး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","တတော ယီၑု ရ္လောကာရဏျာတ် တံ နိရ္ဇနမာနီယ တသျ ကရ္ဏယောင်္ဂုလီ ရ္ဒဒေါ် နိၐ္ဌီဝံ ဒတ္တွာ စ တဇ္ဇိဟွာံ ပသ္ပရ္ၑ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","အနန္တရံ သွရ္ဂံ နိရီက္ၐျ ဒီရ္ဃံ နိၑွသျ တမဝဒတ် ဣတဖတး အရ္ထာန် မုက္တော ဘူယာတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","တတသ္တတ္က္ၐဏံ တသျ ကရ္ဏော် မုက္တော် ဇိဟွာယာၑ္စ ဇာဍျာပဂမာတ် သ သုသ္ပၐ္ဋဝါကျမကထယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","အထ သ တာန် ဝါဎမိတျာဒိဒေၑ ယူယမိမာံ ကထာံ ကသ္မဲစိဒပိ မာ ကထယတ, ကိန္တု သ ယတိ နျၐေဓတ် တေ တတိ ဗာဟုလျေန ပြာစာရယန်; ");
INSERT INTO sanbur_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","တေ'တိစမတ္ကၖတျ ပရသ္ပရံ ကထယာမာသုး သ ဗဓိရာယ ၑြဝဏၑက္တိံ မူကာယ စ ကထနၑက္တိံ ဒတ္တွာ သရွွံ ကရ္မ္မောတ္တမရူပေဏ စကာရ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","တဒါ တတ္သမီပံ ဗဟဝေါ လောကာ အာယာတာ အတသ္တေၐာံ ဘောဇျဒြဝျာဘာဝါဒ် ယီၑုး ၑိၐျာနာဟူယ ဇဂါဒ,၊ ");
INSERT INTO sanbur_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","လောကနိဝဟေ မမ ကၖပါ ဇာယတေ တေ ဒိနတြယံ မယာ သာရ္ဒ္ဓံ သန္တိ တေၐာံ ဘောဇျံ ကိမပိ နာသ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","တေၐာံ မဓျေ'နေကေ ဒူရာဒ် အာဂတား, အဘုက္တေၐု တေၐု မယာ သွဂၖဟမဘိပြဟိတေၐု တေ ပထိ က္လမိၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ၑိၐျာ အဝါဒိၐုး, ဧတာဝတော လောကာန် တရ္ပယိတုမ် အတြ ပြန္တရေ ပူပါန် ပြာပ္တုံ ကေန ၑကျတေ? ");
INSERT INTO sanbur_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","တတး သ တာန် ပပြစ္ဆ ယုၐ္မာကံ ကတိ ပူပါး သန္တိ? တေ'ကထယန် သပ္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","တတး သ တာလ္လောကာန် ဘုဝိ သမုပဝေၐ္ဋုမ် အာဒိၑျ တာန် သပ္တ ပူပါန် ဓၖတွာ ဤၑွရဂုဏာန် အနုကီရ္တ္တယာမာသ, ဘံက္တွာ ပရိဝေၐယိတုံ ၑိၐျာန် ပြတိ ဒဒေါ်, တတသ္တေ လောကေဘျး ပရိဝေၐယာမာသုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","တထာ တေၐာံ သမီပေ ယေ က္ၐုဒြမတ္သျာ အာသန် တာနပျာဒါယ ဤၑွရဂုဏာန် သံကီရ္တျ ပရိဝေၐယိတုမ် အာဒိၐ္ဋဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","တတော လောကာ ဘုက္တွာ တၖပ္တိံ ဂတာ အဝၑိၐ္ဋခါဒျဲး ပူရ္ဏား သပ္တဍလ္လကာ ဂၖဟီတာၑ္စ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ဧတေ ဘောက္တာရး ပြာယၑ္စတုး သဟသြပုရုၐာ အာသန် တတး သ တာန် ဝိသသရ္ဇ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","အထ သ ၑိၐျး သဟ နာဝမာရုဟျ ဒလ္မာနူထာသီမာမာဂတး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","တတး ပရံ ဖိရူၑိန အာဂတျ တေန သဟ ဝိဝဒမာနာသ္တသျ ပရီက္ၐာရ္ထမ် အာကာၑီယစိဟ္နံ ဒြၐ္ဋုံ ယာစိတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","တဒါ သော'န္တရ္ဒီရ္ဃံ နိၑွသျာကထယတ်, ဧတေ ဝိဒျမာနနရား ကုတၑ္စိနှံ မၖဂယန္တေ? ယုၐ္မာနဟံ ယထာရ္ထံ ဗြဝီမိ လောကာနေတာန် ကိမပိ စိဟ္နံ န ဒရ္ၑယိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","အထ တာန် ဟိတွာ ပုန ရ္နာဝမ် အာရုဟျ ပါရမဂါတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ဧတရှိ ၑိၐျဲး ပူပေၐု ဝိသ္မၖတေၐု နာဝိ တေၐာံ သန္နိဓော် ပူပ ဧကဧဝ သ္ထိတး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","တဒါနီံ ယီၑုသ္တာန် အာဒိၐ္ဋဝါန် ဖိရူၑိနာံ ဟေရောဒၑ္စ ကိဏွံ ပြတိ သတရ္ကား သာဝဓာနာၑ္စ ဘဝတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","တတသ္တေ'နျောနျံ ဝိဝေစနံ ကရ္တုမ် အာရေဘိရေ, အသ္မာကံ သန္နိဓော် ပူပေါ နာသ္တီတိ ဟေတောရိဒံ ကထယတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","တဒ် ဗုဒွွာ ယီၑုသ္တေဘျော'ကထယတ် ယုၐ္မာကံ သ္ထာနေ ပူပါဘာဝါတ် ကုတ ဣတ္ထံ ဝိတရ္ကယထ? ယူယံ ကိမဒျာပိ ကိမပိ န ဇာနီထ? ဗောဒ္ဓုဉ္စ န ၑက္နုထ? ယာဝဒဒျ ကိံ ယုၐ္မာကံ မနာံသိ ကဌိနာနိ သန္တိ? ");
INSERT INTO sanbur_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","သတ္သု နေတြေၐု ကိံ န ပၑျထ? သတ္သု ကရ္ဏေၐု ကိံ န ၑၖဏုထ? န သ္မရထ စ? ");
INSERT INTO sanbur_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ယဒါဟံ ပဉ္စပူပါန် ပဉ္စသဟသြာဏာံ ပုရုၐာဏာံ မဓျေ ဘံက္တွာ ဒတ္တဝါန် တဒါနီံ ယူယမ် အဝၑိၐ္ဋပူပဲး ပူရ္ဏာန် ကတိ ဍလ္လကာန် ဂၖဟီတဝန္တး? တေ'ကထယန် ဒွါဒၑဍလ္လကာန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","အပရဉ္စ ယဒါ စတုးသဟသြာဏာံ ပုရုၐာဏာံ မဓျေ ပူပါန် ဘံက္တွာဒဒါံ တဒါ ယူယမ် အတိရိက္တပူပါနာံ ကတိ ဍလ္လကာန် ဂၖဟီတဝန္တး? တေ ကထယာမာသုး သပ္တဍလ္လကာန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","တဒါ သ ကထိတဝါန် တရှိ ယူယမ် အဓုနာပိ ကုတော ဗောဒွွုံ န ၑက္နုထ? ");
INSERT INTO sanbur_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","အနန္တရံ တသ္မိန် ဗဲတ္သဲဒါနဂရေ ပြာပ္တေ လောကာ အန္ဓမေကံ နရံ တတ္သမီပမာနီယ တံ သ္ပြၐ္ဋုံ တံ ပြာရ္ထယာဉ္စကြိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","တဒါ တသျာန္ဓသျ ကရော် ဂၖဟီတွာ နဂရာဒ် ဗဟိရ္ဒေၑံ တံ နီတဝါန်; တန္နေတြေ နိၐ္ဌီဝံ ဒတ္တွာ တဒ္ဂါတြေ ဟသ္တာဝရ္ပယိတွာ တံ ပပြစ္ဆ, ကိမပိ ပၑျသိ? ");
INSERT INTO sanbur_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","သ နေတြေ ဥန္မီလျ ဇဂါဒ, ဝၖက္ၐဝတ် မနုဇာန် ဂစ္ဆတော နိရီက္ၐေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","တတော ယီၑုး ပုနသ္တသျ နယနယော ရှသ္တာဝရ္ပယိတွာ တသျ နေတြေ ဥန္မီလယာမာသ; တသ္မာတ် သ သွသ္ထော ဘူတွာ သ္ပၐ္ဋရူပံ သရွွလောကာန် ဒဒရ္ၑ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","တတး ပရံ တွံ ဂြာမံ မာ ဂစ္ဆ ဂြာမသ္ထံ ကမပိ စ ကိမပျနုက္တွာ နိဇဂၖဟံ ယာဟီတျာဒိၑျ ယီၑုသ္တံ နိဇဂၖဟံ ပြဟိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","အနန္တရံ ၑိၐျဲး သဟိတော ယီၑုး ကဲသရီယာဖိလိပိပုရံ ဇဂါမ, ပထိ ဂစ္ဆန် တာနပၖစ္ဆတ် ကော'ဟမ် အတြ လောကား ကိံ ဝဒန္တိ? ");
INSERT INTO sanbur_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","တေ ပြတျူစုး တွာံ ယောဟနံ မဇ္ဇကံ ဝဒန္တိ ကိန္တု ကေပိ ကေပိ ဧလိယံ ဝဒန္တိ; အပရေ ကေပိ ကေပိ ဘဝိၐျဒွါဒိနာမ် ဧကော ဇန ဣတိ ဝဒန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","အထ သ တာနပၖစ္ဆတ် ကိန္တု ကောဟမ်? ဣတျတြ ယူယံ ကိံ ဝဒထ? တဒါ ပိတရး ပြတျဝဒတ် ဘဝါန် အဘိၐိက္တသ္တြာတာ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","တတး သ တာန် ဂါဎမာဒိၑဒ် ယူယံ မမ ကထာ ကသ္မဲစိဒပိ မာ ကထယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","မနုၐျပုတြေဏာဝၑျံ ဗဟဝေါ ယာတနာ ဘောက္တဝျား ပြာစီနလောကဲး ပြဓာနယာဇကဲရဓျာပကဲၑ္စ သ နိန္ဒိတး သန် ဃာတယိၐျတေ တၖတီယဒိနေ ဥတ္ထာသျတိ စ, ယီၑုး ၑိၐျာနုပဒေၐ္ဋုမာရဘျ ကထာမိမာံ သ္ပၐ္ဋမာစၐ္ဋ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","တသ္မာတ် ပိတရသ္တသျ ဟသ္တော် ဓၖတွာ တံ တရ္ဇ္ဇိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","ကိန္တု သ မုခံ ပရာဝရ္တျ ၑိၐျဂဏံ နိရီက္ၐျ ပိတရံ တရ္ဇယိတွာဝါဒီဒ် ဒူရီဘဝ ဝိဃ္နကာရိန် ဤၑွရီယကာရျျာဒပိ မနုၐျကာရျျံ တုဘျံ ရောစတတရာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","အထ သ လောကာန် ၑိၐျာံၑ္စာဟူယ ဇဂါဒ ယး ကၑ္စိန် မာမနုဂန္တုမ် ဣစ္ဆတိ သ အာတ္မာနံ ဒါမျတု, သွကြုၑံ ဂၖဟီတွာ မတ္ပၑ္စာဒ် အာယာတု၊ ");
INSERT INTO sanbur_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ယတော ယး ကၑ္စိတ် သွပြာဏံ ရက္ၐိတုမိစ္ဆတိ သ တံ ဟာရယိၐျတိ, ကိန္တု ယး ကၑ္စိန် မဒရ္ထံ သုသံဝါဒါရ္ထဉ္စ ပြာဏံ ဟာရယတိ သ တံ ရက္ၐိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","အပရဉ္စ မနုဇး သရွွံ ဇဂတ် ပြာပျ ယဒိ သွပြာဏံ ဟာရယတိ တရှိ တသျ ကော လာဘး? ");
INSERT INTO sanbur_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","နရး သွပြာဏဝိနိမယေန ကိံ ဒါတုံ ၑက္နောတိ? ");
INSERT INTO sanbur_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ဧတေၐာံ ဝျဘိစာရိဏာံ ပါပိနာဉ္စ လောကာနာံ သာက္ၐာဒ် ယဒိ ကောပိ မာံ မတ္ကထာဉ္စ လဇ္ဇာသ္ပဒံ ဇာနာတိ တရှိ မနုဇပုတြော ယဒါ ဓရ္မ္မဒူတဲး သဟ ပိတုး ပြဘာဝေဏာဂမိၐျတိ တဒါ သောပိ တံ လဇ္ဇာသ္ပဒံ ဇ္ဉာသျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","အထ သ တာနဝါဒီတ် ယုၐ္မဘျမဟံ ယထာရ္ထံ ကထယာမိ, ဤၑွရရာဇျံ ပရာကြမေဏောပသ္ထိတံ န ဒၖၐ္ဋွာ မၖတျုံ နာသွာဒိၐျန္တေ, အတြ ဒဏ္ဍာယမာနာနာံ မဓျေပိ တာဒၖၑာ လောကား သန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","အထ ၐဍ္ဒိနေဘျး ပရံ ယီၑုး ပိတရံ ယာကူဗံ ယောဟနဉ္စ ဂၖဟီတွာ ဂိရေရုစ္စသျ နိရ္ဇနသ္ထာနံ ဂတွာ တေၐာံ ပြတျက္ၐေ မူရ္တျန္တရံ ဒဓာရ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","တတသ္တသျ ပရိဓေယမ် ဤဒၖၑမ် ဥဇ္ဇွလဟိမပါဏဍရံ ဇာတံ ယဒ် ဇဂတိ ကောပိ ရဇကော န တာဒၖက် ပါဏဍရံ ကရ္တ္တာံ ၑက္နောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","အပရဉ္စ ဧလိယော မူသာၑ္စ တေဘျော ဒရ္ၑနံ ဒတ္တွာ ယီၑုနာ သဟ ကထနံ ကရ္တ္တုမာရေဘာတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","တဒါ ပိတရော ယီၑုမဝါဒီတ် ဟေ ဂုရော'သ္မာကမတြ သ္ထိတိရုတ္တမာ, တတဧဝ ဝယံ တွတ္ကၖတေ ဧကာံ မူသာကၖတေ ဧကာမ် ဧလိယကၖတေ စဲကာံ, ဧတာသ္တိသြး ကုဋီ ရ္နိရ္မ္မာမ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","ကိန္တု သ ယဒုက္တဝါန် တတ် သွယံ န ဗုဗုဓေ တတး သရွွေ ဗိဘယာဉ္စကြုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ဧတရှိ ပယောဒသ္တာန် ဆာဒယာမာသ, မမယာံ ပြိယး ပုတြး ကထာသု တသျ မနာံသိ နိဝေၑယတေတိ နဘောဝါဏီ တန္မေဒျာန္နိရျယော်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","အထ ဟဌာတ္တေ စတုရ္ဒိၑော ဒၖၐ္ဋွာ ယီၑုံ ဝိနာ သွဲး သဟိတံ ကမပိ န ဒဒၖၑုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","တတး ပရံ ဂိရေရဝရောဟဏကာလေ သ တာန် ဂါဎမ် ဒူတျာဒိဒေၑ ယာဝန္နရသူနေား ၑ္မၑာနာဒုတ္ထာနံ န ဘဝတိ, တာဝတ် ဒရ္ၑနသျာသျ ဝါရ္တ္တာ ယုၐ္မာဘိး ကသ္မဲစိဒပိ န ဝက္တဝျာ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","တဒါ ၑ္မၑာနာဒုတ္ထာနသျ ကောဘိပြာယ ဣတိ ဝိစာရျျ တေ တဒွါကျံ သွေၐု ဂေါပါယာဉ္စကြိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","အထ တေ ယီၑုံ ပပြစ္ဆုး ပြထမတ ဧလိယေနာဂန္တဝျမ် ဣတိ ဝါကျံ ကုတ ဥပါဓျာယာ အာဟုး? ");
INSERT INTO sanbur_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","တဒါ သ ပြတျုဝါစ , ဧလိယး ပြထမမေတျ သရွွကာရျျာဏိ သာဓယိၐျတိ; နရပုတြေ စ လိပိ ရျထာသ္တေ တထဲဝ သောပိ ဗဟုဒုးခံ ပြာပျာဝဇ္ဉာသျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","ကိန္တွဟံ ယုၐ္မာန် ဝဒါမိ , ဧလိယာရ္ထေ လိပိ ရျထာသ္တေ တထဲဝ သ ဧတျ ယယော်, လောကာ: သွေစ္ဆာနုရူပံ တမဘိဝျဝဟရန္တိ သ္မ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","အနန္တရံ သ ၑိၐျသမီပမေတျ တေၐာံ စတုးပါရ္ၑွေ တဲး သဟ ဗဟုဇနာန် ဝိဝဒမာနာန် အဓျာပကာံၑ္စ ဒၖၐ္ဋဝါန်; ");
INSERT INTO sanbur_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ကိန္တု သရွွလောကာသ္တံ ဒၖၐ္ဋွဲဝ စမတ္ကၖတျ တဒါသန္နံ ဓာဝန္တသ္တံ ပြဏေမုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","တဒါ ယီၑုရဓျာပကာနပြာက္ၐီဒ် ဧတဲး သဟ ယူယံ ကိံ ဝိဝဒဓွေ? ");
INSERT INTO sanbur_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","တတော လောကာနာံ ကၑ္စိဒေကး ပြတျဝါဒီတ် ဟေ ဂုရော မမ သူနုံ မူကံ ဘူတဓၖတဉ္စ ဘဝဒါသန္နမ် အာနယံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ယဒါသော် ဘူတသ္တမာကြမတေ တဒဲဝ ပါတသတိ တထာ သ ဖေဏာယတေ, ဒန္တဲရ္ဒန္တာန် ဃရ္ၐတိ က္ၐီဏော ဘဝတိ စ; တတော ဟေတောသ္တံ ဘူတံ တျာဇယိတုံ ဘဝစ္ဆိၐျာန် နိဝေဒိတဝါန် ကိန္တု တေ န ၑေကုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","တဒါ သ တမဝါဒီတ်, ရေ အဝိၑွာသိနး သန္တာနာ ယုၐ္မာဘိး သဟ ကတိ ကာလာနဟံ သ္ထာသျာမိ? အပရာန် ကတိ ကာလာန် ဝါ ဝ အာစာရာန် သဟိၐျေ? တံ မဒါသန္နမာနယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","တတသ္တတ္သန္နိဓိံ သ အာနီယတ ကိန္တု တံ ဒၖၐ္ဋွဲဝ ဘူတော ဗာလကံ ဓၖတဝါန်; သ စ ဘူမော် ပတိတွာ ဖေဏာယမာနော လုလောဌ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","တဒါ သ တတ္ပိတရံ ပပြစ္ဆ, အသျေဒၖၑီ ဒၑာ ကတိ ဒိနာနိ ဘူတာ? တတး သောဝါဒီတ် ဗာလျကာလာတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","ဘူတောယံ တံ နာၑယိတုံ ဗဟုဝါရာန် ဝဟ္နော် ဇလေ စ နျက္ၐိပတ် ကိန္တု ယဒိ ဘဝါန ကိမပိ ကရ္တ္တာံ ၑက္နောတိ တရှိ ဒယာံ ကၖတွာသ္မာန် ဥပကရောတု၊ ");
INSERT INTO sanbur_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","တဒါ ယီၑုသ္တမဝဒတ် ယဒိ ပြတျေတုံ ၑက္နောၐိ တရှိ ပြတျယိနေ ဇနာယ သရွွံ သာဓျမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","တတသ္တတ္က္ၐဏံ တဒ္ဗါလကသျ ပိတာ ပြောစ္စဲ ရူဝန် သာၑြုနေတြး ပြောဝါစ, ပြဘော ပြတျေမိ မမာပြတျယံ ပြတိကုရု၊ ");
INSERT INTO sanbur_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","အထ ယီၑု ရ္လောကသင်္ဃံ ဓာဝိတွာယာန္တံ ဒၖၐ္ဋွာ တမပူတဘူတံ တရ္ဇယိတွာ ဇဂါဒ, ရေ ဗဓိရ မူက ဘူတ တွမေတသ္မာဒ် ဗဟိရ္ဘဝ ပုနး ကဒါပိ မာၑြယဲနံ တွာမဟမ် ဣတျာဒိၑာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","တဒါ သ ဘူတၑ္စီတ္ၑဗ္ဒံ ကၖတွာ တမာပီဍျ ဗဟိရ္ဇဇာမ, တတော ဗာလကော မၖတကလ္ပော ဗဘူဝ တသ္မာဒယံ မၖတဣတျနေကေ ကထယာမာသုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","ကိန္တု ကရံ ဓၖတွာ ယီၑုနောတ္ထာပိတး သ ဥတ္တသ္ထော်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","အထ ယီၑော် ဂၖဟံ ပြဝိၐ္ဋေ ၑိၐျာ ဂုပ္တံ တံ ပပြစ္ဆုး, ဝယမေနံ ဘူတံ တျာဇယိတုံ ကုတော န ၑက္တား? ");
INSERT INTO sanbur_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","သ ဥဝါစ, ပြာရ္ထနောပဝါသော် ဝိနာ ကေနာပျနျေန ကရ္မ္မဏာ ဘူတမီဒၖၑံ တျာဇယိတုံ န ၑကျံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","အနန္တရံ သ တတ္သ္ထာနာဒိတွာ ဂါလီလ္မဓျေန ယယော်, ကိန္တု တတ် ကောပိ ဇာနီယာဒိတိ သ နဲစ္ဆတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","အပရဉ္စ သ ၑိၐျာနုပဒိၑန် ဗဘာၐေ, နရပုတြော နရဟသ္တေၐု သမရ္ပယိၐျတေ တေ စ တံ ဟနိၐျန္တိ တဲသ္တသ္မိန် ဟတေ တၖတီယဒိနေ သ ဥတ္ထာသျတီတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","ကိန္တု တတ္ကထာံ တေ နာဗုဓျန္တ ပြၐ္ဋုဉ္စ ဗိဘျး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","အထ ယီၑုး ကဖရ္နာဟူမ္ပုရမာဂတျ မဓျေဂၖဟဉ္စေတျ တာနပၖစ္ဆဒ် ဝရ္တ္မမဓျေ ယူယမနျောနျံ ကိံ ဝိဝဒဓွေ သ္မ? ");
INSERT INTO sanbur_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","ကိန္တု တေ နိရုတ္တရာသ္တသ္ထု ရျသ္မာတ္တေၐာံ ကော မုချ ဣတိ ဝရ္တ္မာနိ တေ'နျောနျံ ဝျဝဒန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","တတး သ ဥပဝိၑျ ဒွါဒၑၑိၐျာန် အာဟူယ ဗဘာၐေ ယး ကၑ္စိတ် မုချော ဘဝိတုမိစ္ဆတိ သ သရွွေဘျော ဂေါ်ဏး သရွွေၐာံ သေဝကၑ္စ ဘဝတု၊ ");
INSERT INTO sanbur_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","တဒါ သ ဗာလကမေကံ ဂၖဟီတွာ မဓျေ သမုပါဝေၑယတ် တတသ္တံ ကြောဍေ ကၖတွာ တာနဝါဒါတ္ ");
INSERT INTO sanbur_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","ယး ကၑ္စိဒီဒၖၑသျ ကသျာပိ ဗာလသျာတိထျံ ကရောတိ သ မမာတိထျံ ကရောတိ; ယး ကၑ္စိန္မမာတိထျံ ကရောတိ သ ကေဝလမ် မမာတိထျံ ကရောတိ တန္န မတ္ပြေရကသျာပျာတိထျံ ကရောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","အထ ယောဟန် တမဗြဝီတ် ဟေ ဂုရော, အသ္မာကမနနုဂါမိနမ် ဧကံ တွာန္နာမ္နာ ဘူတာန် တျာဇယန္တံ ဝယံ ဒၖၐ္ဋဝန္တး, အသ္မာကမပၑ္စာဒ္ဂါမိတွာစ္စ တံ နျၐေဓာမ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","ကိန္တု ယီၑုရဝဒတ် တံ မာ နိၐေဓတ်, ယတော ယး ကၑ္စိန် မန္နာမ္နာ စိတြံ ကရ္မ္မ ကရောတိ သ သဟသာ မာံ နိန္ဒိတုံ န ၑက္နောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","တထာ ယး ကၑ္စိဒ် ယုၐ္မာကံ ဝိပက္ၐတာံ န ကရောတိ သ ယုၐ္မာကမေဝ သပက္ၐး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ယး ကၑ္စိဒ် ယုၐ္မာန် ခြီၐ္ဋၑိၐျာန် ဇ္ဉာတွာ မန္နာမ္နာ ကံသဲကေန ပါနီယံ ပါတုံ ဒဒါတိ, ယုၐ္မာနဟံ ယထာရ္ထံ ဝစ္မိ, သ ဖလေန ဝဉ္စိတော န ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","ကိန္တု ယဒိ ကၑ္စိန် မယိ ဝိၑွာသိနာမေၐာံ က္ၐုဒြပြာဏိနာမ် ဧကသျာပိ ဝိဃ္နံ ဇနယတိ, တရှိ တသျဲတတ္ကရ္မ္မ ကရဏာတ် ကဏ္ဌဗဒ္ဓပေၐဏီကသျ တသျ သာဂရာဂါဓဇလ မဇ္ဇနံ ဘဒြံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","အတး သွကရော ယဒိ တွာံ ဗာဓတေ တရှိ တံ ဆိန္ဓိ; ");
INSERT INTO sanbur_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ယသ္မာတ် ယတြ ကီဋာ န မြိယန္တေ ဝဟ္နိၑ္စ န နိရွွာတိ, တသ္မိန် အနိရွွာဏာနလနရကေ ကရဒွယဝသ္တဝ ဂမနာတ် ကရဟီနသျ သွရ္ဂပြဝေၑသ္တဝ က္ၐေမံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","ယဒိ တဝ ပါဒေါ ဝိဃ္နံ ဇနယတိ တရှိ တံ ဆိန္ဓိ, ");
INSERT INTO sanbur_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ယတော ယတြ ကီဋာ န မြိယန္တေ ဝဟ္နိၑ္စ န နိရွွာတိ, တသ္မိန် 'နိရွွာဏဝဟ္နော် နရကေ ဒွိပါဒဝတသ္တဝ နိက္ၐေပါတ် ပါဒဟီနသျ သွရ္ဂပြဝေၑသ္တဝ က္ၐေမံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","သွနေတြံ ယဒိ တွာံ ဗာဓတေ တရှိ တဒပျုတ္ပာဋယ, ယတော ယတြ ကီဋာ န မြိယန္တေ ဝဟ္နိၑ္စ န နိရွွာတိ, ");
INSERT INTO sanbur_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","တသ္မိန 'နိရွွာဏဝဟ္နော် နရကေ ဒွိနေတြသျ တဝ နိက္ၐေပါဒ် ဧကနေတြဝတ ဤၑွရရာဇျေ ပြဝေၑသ္တဝ က္ၐေမံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","ယထာ သရွွော ဗလိ ရ္လဝဏာက္တး ကြိယတေ တထာ သရွွော ဇနော ဝဟ္နိရူပေဏ လဝဏာက္တး ကာရိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","လဝဏံ ဘဒြံ ကိန္တု ယဒိ လဝဏေ သွာဒုတာ န တိၐ္ဌတိ, တရှိ ကထမ် အာသွာဒျုက္တံ ကရိၐျထ? ယူယံ လဝဏယုက္တာ ဘဝတ ပရသ္ပရံ ပြေမ ကုရုတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","အနန္တရံ သ တတ္သ္ထာနာတ် ပြသ္ထာယ ယရ္ဒ္ဒနနဒျား ပါရေ ယိဟူဒါပြဒေၑ ဥပသ္ထိတဝါန်, တတြ တဒန္တိကေ လောကာနာံ သမာဂမေ ဇာတေ သ နိဇရီတျနုသာရေဏ ပုနသ္တာန် ဥပဒိဒေၑ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","တဒါ ဖိရူၑိနသ္တတ္သမီပမ် ဧတျ တံ ပရီက္ၐိတုံ ပပြစ္ဆး သွဇာယာ မနုဇာနာံ တျဇျာ န ဝေတိ? ");
INSERT INTO sanbur_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","တတး သ ပြတျဝါဒီတ်, အတြ ကာရျျေ မူသာ ယုၐ္မာန် ပြတိ ကိမာဇ္ဉာပယတ်? ");
INSERT INTO sanbur_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","တ ဦစုး တျာဂပတြံ လေခိတုံ သွပတ္နီံ တျက္တုဉ္စ မူသာ'နုမနျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","တဒါ ယီၑုး ပြတျုဝါစ, ယုၐ္မာကံ မနသာံ ကာဌိနျာဒ္ဓေတော ရ္မူသာ နိဒေၑမိမမ် အလိခတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","ကိန္တု သၖၐ္ဋေရာဒေါ် ဤၑွရော နရာန် ပုံရူပေဏ သ္တြီရူပေဏ စ သသရ္ဇ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","\"တတး ကာရဏာတ် ပုမာန် ပိတရံ မာတရဉ္စ တျက္တွာ သွဇာယာယာမ် အာသက္တော ဘဝိၐျတိ, ");
INSERT INTO sanbur_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","တော် ဒွါဝ် ဧကာင်္ဂေါ် ဘဝိၐျတး၊ \" တသ္မာတ် တတ္ကာလမာရဘျ တော် န ဒွါဝ် ဧကာင်္ဂေါ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","အတး ကာရဏာဒ် ဤၑွရော ယဒယောဇယတ် ကောပိ နရသ္တန္န ဝိယေဇယေတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","အထ ယီၑု ရ္ဂၖဟံ ပြဝိၐ္ဋသ္တဒါ ၑိၐျား ပုနသ္တတ္ကထာံ တံ ပပြစ္ဆုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","တတး သောဝဒတ် ကၑ္စိဒ် ယဒိ သွဘာရျျာံ တျက္တဝါနျာမ် ဥဒွဟတိ တရှိ သ သွဘာရျျာယား ပြာတိကူလျေန ဝျဘိစာရီ ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","ကာစိန္နာရီ ယဒိ သွပတိံ ဟိတွာနျပုံသာ ဝိဝါဟိတာ ဘဝတိ တရှိ သာပိ ဝျဘိစာရိဏီ ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","အထ သ ယထာ ၑိၑူန် သ္ပၖၑေတ်, တဒရ္ထံ လောကဲသ္တဒန္တိကံ ၑိၑဝ အာနီယန္တ, ကိန္တု ၑိၐျာသ္တာနာနီတဝတသ္တရ္ဇယာမာသုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ယီၑုသ္တဒ် ဒၖၐ္ဋွာ ကြုဓျန် ဇဂါဒ, မန္နိကဋမ် အာဂန္တုံ ၑိၑူန် မာ ဝါရယတ, ယတ ဧတာဒၖၑာ ဤၑွရရာဇျာဓိကာရိဏး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","ယုၐ္မာနဟံ ယထာရ္ထံ ဝစ္မိ, ယး ကၑ္စိတ် ၑိၑုဝဒ် ဘူတွာ ရာဇျမီၑွရသျ န ဂၖဟ္လီယာတ် သ ကဒါပိ တဒြာဇျံ ပြဝေၐ္ဋုံ န ၑက္နောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","အနနတရံ သ ၑိၑူနင်္ကေ နိဓာယ တေၐာံ ဂါတြေၐု ဟသ္တော် ဒတ္တွာၑိၐံ ဗဘာၐေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","အထ သ ဝရ္တ္မနာ ယာတိ, ဧတရှိ ဇန ဧကော ဓာဝန် အာဂတျ တတ္သမ္မုခေ ဇာနုနီ ပါတယိတွာ ပၖၐ္ဋဝါန်, ဘေား ပရမဂုရော, အနန္တာယုး ပြာပ္တယေ မယာ ကိံ ကရ္တ္တဝျံ? ");
INSERT INTO sanbur_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","တဒါ ယီၑုရုဝါစ, မာံ ပရမံ ကုတော ဝဒသိ? ဝိနေၑွရံ ကောပိ ပရမော န ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","ပရသ္တြီံ နာဘိဂစ္ဆ; နရံ မာ ဃာတယ; သ္တေယံ မာ ကုရု; မၖၐာသာက္ၐျံ မာ ဒေဟိ; ဟိံသာဉ္စ မာ ကုရု; ပိတရော် သမ္မနျသွ; နိဒေၑာ ဧတေ တွယာ ဇ္ဉာတား၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","တတသ္တန ပြတျုက္တံ, ဟေ ဂုရော ဗာလျကာလာဒဟံ သရွွာနေတာန် အာစရာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","တဒါ ယီၑုသ္တံ ဝိလောကျ သ္နေဟေန ဗဘာၐေ, တဝဲကသျာဘာဝ အာသ္တေ; တွံ ဂတွာ သရွွသွံ ဝိကြီယ ဒရိဒြေဘျော ဝိၑြာဏယ, တတး သွရ္ဂေ ဓနံ ပြာပ္သျသိ; တတး ပရမ် ဧတျ ကြုၑံ ဝဟန် မဒနုဝရ္တ္တီ ဘဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ကိန္တု တသျ ဗဟုသမ္ပဒွိဒျမာနတွာတ် သ ဣမာံ ကထာမာကရ္ဏျ ဝိၐဏော ဒုးခိတၑ္စ သန် ဇဂါမ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","အထ ယီၑုၑ္စတုရ္ဒိၑော နိရီက္ၐျ ၑိၐျာန် အဝါဒီတ်, ဓနိလောကာနာမ် ဤၑွရရာဇျပြဝေၑး ကီဒၖဂ် ဒုၐ္ကရး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","တသျ ကထာတး ၑိၐျာၑ္စမစ္စကြုး, ကိန္တု သ ပုနရဝဒတ်, ဟေ ဗာလကာ ယေ ဓနေ ဝိၑွသန္တိ တေၐာမ် ဤၑွရရာဇျပြဝေၑး ကီဒၖဂ် ဒုၐ္ကရး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ဤၑွရရာဇျေ ဓနိနာံ ပြဝေၑာတ် သူစိရန္ဓြေဏ မဟာင်္ဂသျ ဂမနာဂမနံ သုကရံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","တဒါ ၑိၐျာ အတီဝ ဝိသ္မိတား ပရသ္ပရံ ပြောစုး, တရှိ ကး ပရိတြာဏံ ပြာပ္တုံ ၑက္နောတိ? ");
INSERT INTO sanbur_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","တတော ယီၑုသ္တာန် ဝိလောကျ ဗဘာၐေ, တန် နရသျာသာဓျံ ကိန္တု နေၑွရသျ, ယတော ဟေတောရီၑွရသျ သရွွံ သာဓျမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","တဒါ ပိတရ ဥဝါစ, ပၑျ ဝယံ သရွွံ ပရိတျဇျ ဘဝတောနုဂါမိနော ဇာတား၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","တတော ယီၑုး ပြတျဝဒတ်, ယုၐ္မာနဟံ ယထာရ္ထံ ဝဒါမိ, မဒရ္ထံ သုသံဝါဒါရ္ထံ ဝါ ယော ဇနး သဒနံ ဘြာတရံ ဘဂိနီံ ပိတရံ မာတရံ ဇာယာံ သန္တာနာန် ဘူမိ ဝါ တျက္တွာ ");
INSERT INTO sanbur_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ဂၖဟဘြာတၖဘဂိနီပိတၖမာတၖပတ္နီသန္တာနဘူမီနာမိဟ ၑတဂုဏာန် ပြေတျာနန္တာယုၑ္စ န ပြာပ္နောတိ တာဒၖၑး ကောပိ နာသ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","ကိန္တွဂြီယာ အနေကေ လောကား ၑေၐား, ၑေၐီယာ အနေကေ လောကာၑ္စာဂြာ ဘဝိၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","အထ ယိရူၑာလမျာနကာလေ ယီၑုသ္တေၐာမ် အဂြဂါမီ ဗဘူဝ, တသ္မာတ္တေ စိတြံ ဇ္ဉာတွာ ပၑ္စာဒ္ဂါမိနော ဘူတွာ ဗိဘျုး၊ တဒါ သ ပုန ရ္ဒွါဒၑၑိၐျာန် ဂၖဟီတွာ သွီယံ ယဒျဒ် ဃဋိၐျတေ တတ္တတ် တေဘျး ကထယိတုံ ပြာရေဘေ; ");
INSERT INTO sanbur_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ပၑျတ ဝယံ ယိရူၑာလမ္ပုရံ ယာမး, တတြ မနုၐျပုတြး ပြဓာနယာဇကာနာမ် ဥပါဓျာယာနာဉ္စ ကရေၐု သမရ္ပယိၐျတေ; တေ စ ဝဓဒဏ္ဍာဇ္ဉာံ ဒါပယိတွာ ပရဒေၑီယာနာံ ကရေၐု တံ သမရ္ပယိၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","တေ တမုပဟသျ ကၑယာ ပြဟၖတျ တဒွပုၐိ နိၐ္ဌီဝံ နိက္ၐိပျ တံ ဟနိၐျန္တိ, တတး သ တၖတီယဒိနေ ပြောတ္ထာသျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","တတး သိဝဒေး ပုတြော် ယာကူဗျောဟနော် တဒန္တိကမ် ဧတျ ပြောစတုး, ဟေ ဂုရော ယဒ် အာဝါဘျာံ ယာစိၐျတေ တဒသ္မဒရ္ထံ ဘဝါန် ကရောတု နိဝေဒနမိဒမာဝယေား၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","တတး သ ကထိတဝါန်, ယုဝါံ ကိမိစ္ဆထး? ကိံ မယာ ယုၐ္မဒရ္ထံ ကရဏီယံ? ");
INSERT INTO sanbur_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","တဒါ တော် ပြောစတုး, အာဝယောရေကံ ဒက္ၐိဏပါရ္ၑွေ ဝါမပါရ္ၑွေ စဲကံ တဝဲၑွရျျပဒေ သမုပဝေၐ္ဋုမ် အာဇ္ဉာပယ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","ကိန္တု ယီၑုး ပြတျုဝါစ ယုဝါမဇ္ဉာတွေဒံ ပြာရ္ထယေထေ, ယေန ကံသေနာဟံ ပါသျာမိ တေန ယုဝါဘျာံ ကိံ ပါတုံ ၑက္ၐျတေ? ယသ္မိန် မဇ္ဇနေနာဟံ မဇ္ဇိၐျေ တန္မဇ္ဇနေ မဇ္ဇယိတုံ ကိံ ယုဝါဘျာံ ၑက္ၐျတေ? တော် ပြတျူစတုး ၑက္ၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","တဒါ ယီၑုရဝဒတ် ယေန ကံသေနာဟံ ပါသျာမိ တေနာဝၑျံ ယုဝါမပိ ပါသျထး, ယေန မဇ္ဇနေန စာဟံ မဇ္ဇိယျေ တတြ ယုဝါမပိ မဇ္ဇိၐျေထေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ကိန္တု ယေၐာမရ္ထမ် ဣဒံ နိရူပိတံ, တာန် ဝိဟာယာနျံ ကမပိ မမ ဒက္ၐိဏပါရ္ၑွေ ဝါမပါရ္ၑွေ ဝါ သမုပဝေၑယိတုံ မမာဓိကာရော နာသ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","အထာနျဒၑၑိၐျာ ဣမာံ ကထာံ ၑြုတွာ ယာကူဗျောဟန္ဘျာံ စုကုပုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ကိန္တု ယီၑုသ္တာန် သမာဟူယ ဗဘာၐေ, အနျဒေၑီယာနာံ ရာဇတွံ ယေ ကုရွွန္တိ တေ တေၐာမေဝ ပြဘုတွံ ကုရွွန္တိ, တထာ ယေ မဟာလောကာသ္တေ တေၐာမ် အဓိပတိတွံ ကုရွွန္တီတိ ယူယံ ဇာနီထ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","ကိန္တု ယုၐ္မာကံ မဓျေ န တထာ ဘဝိၐျတိ, ယုၐ္မာကံ မဓျေ ယး ပြာဓာနျံ ဝါဉ္ဆတိ သ ယုၐ္မာကံ သေဝကော ဘဝိၐျတိ, ");
INSERT INTO sanbur_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ယုၐ္မာကံ ယော မဟာန် ဘဝိတုမိစ္ဆတိ သ သရွွေၐာံ ကိင်္ကရော ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","ယတော မနုၐျပုတြး သေဝျော ဘဝိတုံ နာဂတး သေဝါံ ကရ္တ္တာံ တထာနေကေၐာံ ပရိတြာဏသျ မူလျရူပသွပြာဏံ ဒါတုဉ္စာဂတး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","အထ တေ ယိရီဟောနဂရံ ပြာပ္တာသ္တသ္မာတ် ၑိၐျဲ ရ္လောကဲၑ္စ သဟ ယီၑော ရ္ဂမနကာလေ ဋီမယသျ ပုတြော ဗရ္ဋီမယနာမာ အန္ဓသ္တန္မာရ္ဂပါရ္ၑွေ ဘိက္ၐာရ္ထမ် ဥပဝိၐ္ဋး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","သ နာသရတီယသျ ယီၑောရာဂမနဝါရ္တ္တာံ ပြာပျ ပြောစဲ ရွက္တုမာရေဘေ, ဟေ ယီၑော ဒါယူဒး သန္တာန မာံ ဒယသွ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","တတောနေကေ လောကာ မော်နီဘဝေတိ တံ တရ္ဇယာမာသုး, ကိန္တု သ ပုနရဓိကမုစ္စဲ ရ္ဇဂါဒ, ဟေ ယီၑော ဒါယူဒး သန္တာန မာံ ဒယသွ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","တဒါ ယီၑုး သ္ထိတွာ တမာဟွာတုံ သမာဒိဒေၑ, တတော လောကာသ္တမန္ဓမာဟူယ ဗဘာၐိရေ, ဟေ နရ, သ္ထိရော ဘဝ, ဥတ္တိၐ္ဌ, သ တွာမာဟွယတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","တဒါ သ ဥတ္တရီယဝသ္တြံ နိက္ၐိပျ ပြောတ္ထာယ ယီၑေား သမီပံ ဂတး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","တတော ယီၑုသ္တမဝဒတ် တွယာ ကိံ ပြာရ္ထျတေ? တုဘျမဟံ ကိံ ကရိၐျာမီ? တဒါ သောန္ဓသ္တမုဝါစ, ဟေ ဂုရော မဒီယာ ဒၖၐ္ဋိရ္ဘဝေတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","တတော ယီၑုသ္တမုဝါစ ယာဟိ တဝ ဝိၑွာသသ္တွာံ သွသ္ထမကာရ္ၐီတ်, တသ္မာတ် တတ္က္ၐဏံ သ ဒၖၐ္ဋိံ ပြာပျ ပထာ ယီၑေား ပၑ္စာဒ် ယယော်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","အနန္တရံ တေၐု ယိရူၑာလမး သမီပသ္ထယော ရ္ဗဲတ္ဖဂီဗဲထနီယပုရယောရန္တိကသ္ထံ ဇဲတုနနာမာဒြိမာဂတေၐု ယီၑုး ပြေၐဏကာလေ ဒွေါ် ၑိၐျာဝိဒံ ဝါကျံ ဇဂါဒ, ");
INSERT INTO sanbur_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ယုဝါမမုံ သမ္မုခသ္ထံ ဂြာမံ ယာတံ, တတြ ပြဝိၑျ ယော နရံ နာဝဟတ် တံ ဂရ္ဒ္ဒဘၑာဝကံ ဒြက္ၐျထသ္တံ မောစယိတွာနယတံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","ကိန္တု ယုဝါံ ကရ္မ္မေဒံ ကုတး ကုရုထး? ကထာမိမာံ ယဒိ ကောပိ ပၖစ္ဆတိ တရှိ ပြဘောရတြ ပြယောဇနမသ္တီတိ ကထိတေ သ ၑီဃြံ တမတြ ပြေၐယိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","တတသ္တော် ဂတွာ ဒွိမာရ္ဂမေလနေ ကသျစိဒ် ဒွါရသျ ပါရ္ၑွေ တံ ဂရ္ဒ္ဒဘၑာဝကံ ပြာပျ မောစယတး, ");
INSERT INTO sanbur_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ဧတရှိ တတြောပသ္ထိတလောကာနာံ ကၑ္စိဒ် အပၖစ္ဆတ်, ဂရ္ဒ္ဒဘၑိၑုံ ကုတော မောစယထး? ");
INSERT INTO sanbur_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","တဒါ ယီၑောရာဇ္ဉာနုသာရေဏ တေဘျး ပြတျုဒိတေ တတ္က္ၐဏံ တမာဒါတုံ တေ'နုဇဇ္ဉုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","အထ တော် ယီၑေား သန္နိဓိံ ဂရ္ဒ္ဒဘၑိၑုမ် အာနီယ တဒုပရိ သွဝသ္တြာဏိ ပါတယာမာသတုး; တတး သ တဒုပရိ သမုပဝိၐ္ဋး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","တဒါနေကေ ပထိ သွဝါသာံသိ ပါတယာမာသုး, ပရဲၑ္စ တရုၑာခါၑ္ဆိတဝါ မာရ္ဂေ ဝိကီရ္ဏား၊ ");
INSERT INTO sanbur_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","အပရဉ္စ ပၑ္စာဒ္ဂါမိနော'ဂြဂါမိနၑ္စ သရွွေ ဇနာ ဥစဲးသွရေဏ ဝက္တုမာရေဘိရေ, ဇယ ဇယ ယး ပရမေၑွရသျ နာမ္နာဂစ္ဆတိ သ ဓနျ ဣတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","တထာသ္မာကမံ ပူရွွပုရုၐသျ ဒါယူဒေါ ယဒြာဇျံ ပရမေၑွရနာမ္နာယာတိ တဒပိ ဓနျံ, သရွွသ္မာဒုစ္ဆြာယေ သွရ္ဂေ ဤၑွရသျ ဇယော ဘဝေတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ဣတ္ထံ ယီၑု ရျိရူၑာလမိ မန္ဒိရံ ပြဝိၑျ စတုရ္ဒိက္သ္ထာနိ သရွွာဏိ ဝသ္တူနိ ဒၖၐ္ဋဝါန်; အထ သာယံကာလ ဥပသ္ထိတေ ဒွါဒၑၑိၐျသဟိတော ဗဲထနိယံ ဇဂါမ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","အပရေဟနိ ဗဲထနိယာဒ် အာဂမနသမယေ က္ၐုဓာရ္တ္တော ဗဘူဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","တတော ဒူရေ သပတြမုဍုမ္ဗရပါဒပံ ဝိလောကျ တတြ ကိဉ္စိတ် ဖလံ ပြာပ္တုံ တသျ သန္နိကၖၐ္ဋံ ယယော်, တဒါနီံ ဖလပါတနသျ သမယော နာဂစ္ဆတိ၊ တတသ္တတြောပသ္ထိတး ပတြာဏိ ဝိနာ ကိမပျပရံ န ပြာပျ သ ကထိတဝါန်, ");
INSERT INTO sanbur_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","အဒျာရဘျ ကောပိ မာနဝသ္တွတ္တး ဖလံ န ဘုဉ္ဇီတ; ဣမာံ ကထာံ တသျ ၑိၐျား ၑုၑြုဝုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","တဒနန္တရံ တေၐု ယိရူၑာလမမာယာတေၐု ယီၑု ရ္မန္ဒိရံ ဂတွာ တတြသ္ထာနာံ ဗဏိဇာံ မုဒြာသနာနိ ပါရာဝတဝိကြေတၖဏာမ် အာသနာနိ စ နျုဗ္ဇယာဉ္စကာရ သရွွာန် ကြေတၖန် ဝိကြေတၖံၑ္စ ဗဟိၑ္စကာရ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","အပရံ မန္ဒိရမဓျေန ကိမပိ ပါတြံ ဝေါဎုံ သရွွဇနံ နိဝါရယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","လောကာနုပဒိၑန် ဇဂါဒ, မမ ဂၖဟံ သရွွဇာတီယာနာံ ပြာရ္ထနာဂၖဟမ် ဣတိ နာမ္နာ ပြထိတံ ဘဝိၐျတိ ဧတတ် ကိံ ၑာသ္တြေ လိခိတံ နာသ္တိ? ကိန္တု ယူယံ တဒေဝ စောရာဏာံ ဂဟွရံ ကုရုထ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ဣမာံ ဝါဏီံ ၑြုတွာဓျာပကား ပြဓာနယာဇကာၑ္စ တံ ယထာ နာၑယိတုံ ၑက္နုဝန္တိ တထောेပါယံ မၖဂယာမာသုး, ကိန္တု တသျောပဒေၑာတ် သရွွေ လောကာ ဝိသ္မယံ ဂတာ အတသ္တေ တသ္မာဒ် ဗိဘျုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","အထ သာယံသမယ ဥပသ္ထိတေ ယီၑုရ္နဂရာဒ် ဗဟိရွဝြာဇ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","အနန္တရံ ပြာတးကာလေ တေ တေန မာရ္ဂေဏ ဂစ္ဆန္တသ္တမုဍုမ္ဗရမဟီရုဟံ သမူလံ ၑုၐ္ကံ ဒဒၖၑုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","တတး ပိတရး ပူရွွဝါကျံ သ္မရန် ယီၑုံ ဗဘာၐံ, ဟေ ဂုရော ပၑျတု ယ ဥဍုမ္ဗရဝိဋပီ ဘဝတာ ၑပ္တး သ ၑုၐ္ကော ဗဘူဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","တတော ယီၑုး ပြတျဝါဒီတ်, ယူယမီၑွရေ ဝိၑွသိတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ယုၐ္မာနဟံ ယထာရ္ထံ ဝဒါမိ ကောပိ ယဒျေတဒ္ဂိရိံ ဝဒတိ, တွမုတ္ထာယ ဂတွာ ဇလဓော် ပတ, ပြောက္တမိဒံ ဝါကျမဝၑျံ ဃဋိၐျတေ, မနသာ ကိမပိ န သန္ဒိဟျ စေဒိဒံ ဝိၑွသေတ် တရှိ တသျ ဝါကျာနုသာရေဏ တဒ် ဃဋိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","အတော ဟေတောရဟံ ယုၐ္မာန် ဝစ္မိ, ပြာရ္ထနာကာလေ ယဒျဒါကာံက္ၐိၐျဓွေ တတ္တဒဝၑျံ ပြာပ္သျထ, ဣတ္ထံ ဝိၑွသိတ, တတး ပြာပ္သျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","အပရဉ္စ ယုၐ္မာသု ပြာရ္ထယိတုံ သမုတ္ထိတေၐု ယဒိ ကောပိ ယုၐ္မာကမ် အပရာဓီ တိၐ္ဌတိ, တရှိ တံ က္ၐမဓွံ, တထာ ကၖတေ ယုၐ္မာကံ သွရ္ဂသ္ထး ပိတာပိ ယုၐ္မာကမာဂါံမိ က္ၐမိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","ကိန္တု ယဒိ န က္ၐမဓွေ တရှိ ဝး သွရ္ဂသ္ထး ပိတာပိ ယုၐ္မာကမာဂါံသိ န က္ၐမိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","အနန္တရံ တေ ပုန ရျိရူၑာလမံ ပြဝိဝိၑုး, ယီၑု ရျဒါ မဓျေမန္ဒိရမ် ဣတသ္တတော ဂစ္ဆတိ, တဒါနီံ ပြဓာနယာဇကာ ဥပါဓျာယား ပြာဉ္စၑ္စ တဒန္တိကမေတျ ကထာမိမာံ ပပြစ္ဆုး, ");
INSERT INTO sanbur_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","တွံ ကေနာဒေၑေန ကရ္မ္မာဏျေတာနိ ကရောၐိ? တထဲတာနိ ကရ္မ္မာဏိ ကရ္တ္တာံ ကေနာဒိၐ္ဋောသိ? ");
INSERT INTO sanbur_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","တတော ယီၑုး ပြတိဂဒိတဝါန် အဟမပိ ယုၐ္မာန် ဧကကထာံ ပၖစ္ဆာမိ, ယဒိ ယူယံ တသျာ ဥတ္တရံ ကုရုထ, တရှိ ကယာဇ္ဉယာဟံ ကရ္မ္မာဏျေတာနိ ကရောမိ တဒ် ယုၐ္မဘျံ ကထယိၐျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ယောဟနော မဇ္ဇနမ် ဤၑွရာတ် ဇာတံ ကိံ မာနဝါတ်? တန္မဟျံ ကထယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","တေ ပရသ္ပရံ ဝိဝေက္တုံ ပြာရေဘိရေ, တဒ် ဤၑွရာဒ် ဗဘူဝေတိ စေဒ် ဝဒါမသ္တရှိ ကုတသ္တံ န ပြတျဲတ? ကထမေတာံ ကထယိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","မာနဝါဒ် အဘဝဒိတိ စေဒ် ဝဒါမသ္တရှိ လောကေဘျော ဘယမသ္တိ ယတော ဟေတေား သရွွေ ယောဟနံ သတျံ ဘဝိၐျဒွါဒိနံ မနျန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","အတဧဝ တေ ယီၑုံ ပြတျဝါဒိၐု ရွယံ တဒ် ဝက္တုံ န ၑက္နုမး၊ ယီၑုရုဝါစ, တရှိ ယေနာဒေၑေန ကရ္မ္မာဏျေတာနိ ကရောမိ, အဟမပိ ယုၐ္မဘျံ တန္န ကထယိၐျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","အနန္တရံ ယီၑု ရ္ဒၖၐ္ဋာန္တေန တေဘျး ကထယိတုမာရေဘေ, ကၑ္စိဒေကော ဒြာက္ၐာက္ၐေတြံ ဝိဓာယ တစ္စတုရ္ဒိက္ၐု ဝါရဏီံ ကၖတွာ တန္မဓျေ ဒြာက္ၐာပေၐဏကုဏ္ဍမ် အခနတ်, တထာ တသျ ဂဍမပိ နိရ္မ္မိတဝါန် တတသ္တတ္က္ၐေတြံ ကၖၐီဝလေၐု သမရ္ပျ ဒူရဒေၑံ ဇဂါမ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","တဒနန္တရံ ဖလကာလေ ကၖၐီဝလေဘျော ဒြာက္ၐာက္ၐေတြဖလာနိ ပြာပ္တုံ တေၐာံ သဝိဓေ ဘၖတျမ် ဧကံ ပြာဟိဏောတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","ကိန္တု ကၖၐီဝလာသ္တံ ဓၖတွာ ပြဟၖတျ ရိက္တဟသ္တံ ဝိသသၖဇုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","တတး သ ပုနရနျမေကံ ဘၖတျံ ပြၐယာမာသ, ကိန္တု တေ ကၖၐီဝလား ပါၐာဏာဃာတဲသ္တသျ ၑိရော ဘင်္က္တွာ သာပမာနံ တံ ဝျသရ္ဇန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","တတး ပရံ သောပရံ ဒါသံ ပြာဟိဏောတ် တဒါ တေ တံ ဇဃ္နုး, ဧဝမ် အနေကေၐာံ ကသျစိတ် ပြဟာရး ကသျစိဒ် ဝဓၑ္စ တဲး ကၖတး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","တတး ပရံ မယာ သွပုတြေ ပြဟိတေ တေ တမဝၑျံ သမ္မံသျန္တေ, ဣတျုက္တွာဝၑေၐေ တေၐာံ သန္နိဓော် နိဇပြိယမ် အဒွိတီယံ ပုတြံ ပြေၐယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","ကိန္တု ကၖၐီဝလား ပရသ္ပရံ ဇဂဒုး, ဧၐ ဥတ္တရာဓိကာရီ, အာဂစ္ဆတ ဝယမေနံ ဟန္မသ္တထာ ကၖတေ 'ဓိကာရောယမ် အသ္မာကံ ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","တတသ္တံ ဓၖတွာ ဟတွာ ဒြာက္ၐာက္ၐေတြာဒ် ဗဟိး ပြာက္ၐိပန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","အနေနာသော် ဒြာက္ၐာက္ၐေတြပတိး ကိံ ကရိၐျတိ? သ ဧတျ တာန် ကၖၐီဝလာန် သံဟတျ တတ္က္ၐေတြမ် အနျေၐု ကၖၐီဝလေၐု သမရ္ပယိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","အပရဉ္စ, \"သ္ထပတယး ကရိၐျန္တိ ဂြာဝါဏံ ယန္တု တုစ္ဆကံ၊ ပြာဓာနပြသ္တရး ကောဏေ သ ဧဝ သံဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ဧတတ် ကရ္မ္မ ပရေၑသျာံဒ္ဘုတံ နော ဒၖၐ္ဋိတော ဘဝေတ်။ \" ဣမာံ ၑာသ္တြီယာံ လိပိံ ယူယံ ကိံ နာပါဌိၐ္ဋ? ");
INSERT INTO sanbur_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","တဒါနီံ သ တာနုဒ္ဒိၑျ တာံ ဒၖၐ္ဋာန္တကထာံ ကထိတဝါန်, တ ဣတ္ထံ ဗုဒွွာ တံ ဓရ္တ္တာမုဒျတား, ကိန္တု လောကေဘျော ဗိဘျုး, တဒနန္တရံ တေ တံ ဝိဟာယ ဝဝြဇုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","အပရဉ္စ တေ တသျ ဝါကျဒေါၐံ ဓရ္တ္တာံ ကတိပယာန် ဖိရူၑိနော ဟေရောဒီယာံၑ္စ လောကာန် တဒန္တိကံ ပြေၐယာမာသုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","တ အာဂတျ တမဝဒန်, ဟေ ဂုရော ဘဝါန် တထျဘာၐီ ကသျာပျနုရောဓံ န မနျတေ, ပက္ၐပါတဉ္စ န ကရောတိ, ယထာရ္ထတ ဤၑွရီယံ မာရ္ဂံ ဒရ္ၑယတိ ဝယမေတတ် ပြဇာနီမး, ကဲသရာယ ကရော ဒေယော န ဝါံ? ဝယံ ဒါသျာမော န ဝါ? ");
INSERT INTO sanbur_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","ကိန္တု သ တေၐာံ ကပဋံ ဇ္ဉာတွာ ဇဂါဒ, ကုတော မာံ ပရီက္ၐဓွေ? ဧကံ မုဒြာပါဒံ သမာနီယ မာံ ဒရ္ၑယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","တဒါ တဲရေကသ္မိန် မုဒြာပါဒေ သမာနီတေ သ တာန် ပပြစ္ဆ, အတြ လိခိတံ နာမ မူရ္တ္တိ ရွာ ကသျ? တေ ပြတျူစုး, ကဲသရသျ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","တဒါ ယီၑုရဝဒတ် တရှိ ကဲသရသျ ဒြဝျာဏိ ကဲသရာယ ဒတ္တ, ဤၑွရသျ ဒြဝျာဏိ တု ဤၑွရာယ ဒတ္တ; တတသ္တေ ဝိသ္မယံ မေနိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","အထ မၖတာနာမုတ္ထာနံ ယေ န မနျန္တေ တေ သိဒူကိနော ယီၑေား သမီပမာဂတျ တံ ပပြစ္ဆုး; ");
INSERT INTO sanbur_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","ဟေ ဂုရော ကၑ္စိဇ္ဇနော ယဒိ နိးသန္တတိး သန် ဘာရျျာယာံ သတျာံ မြိယတေ တရှိ တသျ ဘြာတာ တသျ ဘာရျျာံ ဂၖဟီတွာ ဘြာတု ရွံၑောတ္ပတ္တိံ ကရိၐျတိ, ဝျဝသ္ထာမိမာံ မူသာ အသ္မာန် ပြတိ ဝျလိခတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","ကိန္တု ကေစိတ် သပ္တ ဘြာတရ အာသန်, တတသ္တေၐာံ ဇျေၐ္ဌဘြာတာ ဝိဝဟျ နိးသန္တတိး သန် အမြိယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","တတော ဒွိတီယော ဘြာတာ တာံ သ္တြိယမဂၖဟဏတ် ကိန္တု သောပိ နိးသန္တတိး သန် အမြိယတ; အထ တၖတီယောပိ ဘြာတာ တာဒၖၑောဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ဣတ္ထံ သပ္တဲဝ ဘြာတရသ္တာံ သ္တြိယံ ဂၖဟီတွာ နိးသန္တာနား သန္တော'မြိယန္တ, သရွွၑေၐေ သာပိ သ္တြီ မြိယတေ သ္မ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","အထ မၖတာနာမုတ္ထာနကာလေ ယဒါ တ ဥတ္ထာသျန္တိ တဒါ တေၐာံ ကသျ ဘာရျျာ သာ ဘဝိၐျတိ? ယတသ္တေ သပ္တဲဝ တာံ ဝျဝဟန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","တတော ယီၑုး ပြတျုဝါစ ၑာသ္တြမ် ဤၑွရၑက္တိဉ္စ ယူယမဇ္ဉာတွာ ကိမဘြာမျတ န? ");
INSERT INTO sanbur_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","မၖတလောကာနာမုတ္ထာနံ သတိ တေ န ဝိဝဟန္တိ ဝါဂ္ဒတ္တာ အပိ န ဘဝန္တိ, ကိန္တု သွရ္ဂီယဒူတာနာံ သဒၖၑာ ဘဝန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","ပုနၑ္စ \"အဟမ် ဣဗြာဟီမ ဤၑွရ ဣသှာက ဤၑွရော ယာကူဗၑ္စေၑွရး\" ယာမိမာံ ကထာံ သ္တမ္ဗမဓျေ တိၐ္ဌန် ဤၑွရော မူသာမဝါဒီတ် မၖတာနာမုတ္ထာနာရ္ထေ သာ ကထာ မူသာလိခိတေ ပုသ္တကေ ကိံ ယုၐ္မာဘိ ရ္နာပါဌိ? ");
INSERT INTO sanbur_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ဤၑွရော ဇီဝတာံ ပြဘုး ကိန္တု မၖတာနာံ ပြဘု ရ္န ဘဝတိ, တသ္မာဒ္ဓေတော ရျူယံ မဟာဘြမေဏ တိၐ္ဌထ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ဧတရှိ ဧကောဓျာပက ဧတျ တေၐာမိတ္ထံ ဝိစာရံ ၑုၑြာဝ; ယီၑုသ္တေၐာံ ဝါကျသျ သဒုတ္တရံ ဒတ္တဝါန် ဣတိ ဗုဒွွာ တံ ပၖၐ္ဋဝါန် သရွွာသာမ် အာဇ္ဉာနာံ ကာ ၑြေၐ္ဌာ? တတော ယီၑုး ပြတျုဝါစ, ");
INSERT INTO sanbur_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","\"ဟေ ဣသြာယေလ္လောကာ အဝဓတ္တ, အသ္မာကံ ပြဘုး ပရမေၑွရ ဧက ဧဝ, ");
INSERT INTO sanbur_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","ယူယံ သရွွန္တးကရဏဲး သရွွပြာဏဲး သရွွစိတ္တဲး သရွွၑက္တိဘိၑ္စ တသ္မိန် ပြဘော် ပရမေၑွရေ ပြီယဓွံ,\" ဣတျာဇ္ဉာ ၑြေၐ္ဌာ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","တထာ \"သွပြတိဝါသိနိ သွဝတ် ပြေမ ကုရုဓွံ,\" ဧၐာ ယာ ဒွိတီယာဇ္ဉာ သာ တာဒၖၑီ; ဧတာဘျာံ ဒွါဘျာမ် အာဇ္ဉာဘျာမ် အနျာ ကာပျာဇ္ဉာ ၑြေၐ္ဌာ နာသ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","တဒါ သောဓျာပကသ္တမဝဒတ်, ဟေ ဂုရော သတျံ ဘဝါန် ယထာရ္ထံ ပြောက္တဝါန် ယတ ဧကသ္မာဒ် ဤၑွရာဒ် အနျော ဒွိတီယ ဤၑွရော နာသ္တိ; ");
INSERT INTO sanbur_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","အပရံ သရွွာန္တးကရဏဲး သရွွပြာဏဲး သရွွစိတ္တဲး သရွွၑက္တိဘိၑ္စ ဤၑွရေ ပြေမကရဏံ တထာ သွမီပဝါသိနိ သွဝတ် ပြေမကရဏဉ္စ သရွွေဘျော ဟောမဗလိဒါနာဒိဘျး ၑြၐ္ဌံ ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","တတော ယီၑုး သုဗုဒ္ဓေရိဝ တသျေဒမ် ဥတ္တရံ ၑြုတွာ တံ ဘာၐိတဝါန် တွမီၑွရသျ ရာဇျာန္န ဒူရောသိ၊ ဣတး ပရံ တေန သဟ ကသျာပိ ဝါကျသျ ဝိစာရံ ကရ္တ္တာံ ကသျာပိ ပြဂလ္ဘတာ န ဇာတာ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","အနန္တရံ မဓျေမန္ဒိရမ် ဥပဒိၑန် ယီၑုရိမံ ပြၑ္နံ စကာရ, အဓျာပကာ အဘိၐိက္တံ (တာရကံ) ကုတော ဒါယူဒး သန္တာနံ ဝဒန္တိ? ");
INSERT INTO sanbur_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","သွယံ ဒါယူဒ် ပဝိတြသျာတ္မန အာဝေၑေနေဒံ ကထယာမာသ၊ ယထာ၊ \"မမ ပြဘုမိဒံ ဝါကျဝဒတ် ပရမေၑွရး၊ တဝ ၑတြူနဟံ ယာဝတ် ပါဒပီဌံ ကရောမိ န၊ တာဝတ် ကာလံ မဒီယေ တွံ ဒက္ၐပါရ္ၑွ် ဥပါဝိၑ၊ \" ");
INSERT INTO sanbur_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","ယဒိ ဒါယူဒ် တံ ပြဘူံ ဝဒတိ တရှိ ကထံ သ တသျ သန္တာနော ဘဝိတုမရှတိ? ဣတရေ လောကာသ္တတ္ကထာံ ၑြုတွာနနန္ဒုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","တဒါနီံ သ တာနုပဒိၑျ ကထိတဝါန် ယေ နရာ ဒီရ္ဃပရိဓေယာနိ ဟဋ္ဋေ ဝိပနော် စ ");
INSERT INTO sanbur_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","လောကကၖတနမသ္ကာရာန် ဘဇနဂၖဟေ ပြဓာနာသနာနိ ဘောဇနကာလေ ပြဓာနသ္ထာနာနိ စ ကာင်္က္ၐန္တေ; ");
INSERT INTO sanbur_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ဝိဓဝါနာံ သရွွသွံ ဂြသိတွာ ဆလာဒ် ဒီရ္ဃကာလံ ပြာရ္ထယန္တေ တေဘျ ဥပါဓျာယေဘျး သာဝဓာနာ ဘဝတ; တေ'ဓိကတရာန် ဒဏ္ဍာန် ပြာပ္သျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","တဒနန္တရံ လောကာ ဘာဏ္ဍာဂါရေ မုဒြာ ယထာ နိက္ၐိပန္တိ ဘာဏ္ဍာဂါရသျ သမ္မုခေ သမုပဝိၑျ ယီၑုသ္တဒဝလုလောက; တဒါနီံ ဗဟဝေါ ဓနိနသ္တသျ မဓျေ ဗဟူနိ ဓနာနိ နိရက္ၐိပန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ပၑ္စာဒ် ဧကာ ဒရိဒြာ ဝိဓဝါ သမာဂတျ ဒွိပဏမူလျာံ မုဒြဲကာံ တတြ နိရက္ၐိပတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","တဒါ ယီၑုး ၑိၐျာန် အာဟူယ ကထိတဝါန် ယုၐ္မာနဟံ ယထာရ္ထံ ဝဒါမိ ယေ ယေ ဘာဏ္ဍာဂါရေ'သ္မိန ဓနာနိ နိးက္ၐိပန္တိ သ္မ တေဘျး သရွွေဘျ ဣယံ ဝိဓဝါ ဒရိဒြာဓိကမ် နိးက္ၐိပတိ သ္မ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ယတသ္တေ ပြဘူတဓနသျ ကိဉ္စိတ် နိရက္ၐိပန် ကိန္တု ဒီနေယံ သွဒိနယာပနယောဂျံ ကိဉ္စိဒပိ န သ္ထာပယိတွာ သရွွသွံ နိရက္ၐိပတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","အနန္တရံ မန္ဒိရာဒ် ဗဟိရ္ဂမနကာလေ တသျ ၑိၐျာဏာမေကသ္တံ ဝျာဟၖတဝါန် ဟေ ဂုရော ပၑျတု ကီဒၖၑား ပါၐာဏား ကီဒၖက် စ နိစယနံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","တဒါ ယီၑုသ္တမ် အဝဒတ် တွံ ကိမေတဒ် ဗၖဟန္နိစယနံ ပၑျသိ? အသျဲကပါၐာဏောပိ ဒွိတီယပါၐာဏောပရိ န သ္ထာသျတိ သရွွေ 'ဓးက္ၐေပ္သျန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","အထ ယသ္မိန် ကာလေ ဇဲတုန္ဂိရော် မန္ဒိရသျ သမ္မုခေ သ သမုပဝိၐ္ဋသ္တသ္မိန် ကာလေ ပိတရော ယာကူဗ် ယောဟန် အာန္ဒြိယၑ္စဲတေ တံ ရဟသိ ပပြစ္ဆုး, ");
INSERT INTO sanbur_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","ဧတာ ဃဋနား ကဒါ ဘဝိၐျန္တိ? တထဲတတ္သရွွာသာံ သိဒ္ဓျုပကြမသျ ဝါ ကိံ စိဟ္နံ? တဒသ္မဘျံ ကထယတု ဘဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","တတော ယာၑုသ္တာန် ဝက္တုမာရေဘေ, ကောပိ ယထာ ယုၐ္မာန် န ဘြာမယတိ တထာတြ ယူယံ သာဝဓာနာ ဘဝတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ယတး ခြီၐ္ဋောဟမိတိ ကထယိတွာ မမ နာမ္နာနေကေ သမာဂတျ လောကာနာံ ဘြမံ ဇနယိၐျန္တိ; ");
INSERT INTO sanbur_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","ကိန္တု ယူယံ ရဏသျ ဝါရ္တ္တာံ ရဏာဍမ္ဗရဉ္စ ၑြုတွာ မာ ဝျာကုလာ ဘဝတ, ဃဋနာ ဧတာ အဝၑျမ္မာဝိနျး; ကိန္တွာပါတတော န ယုဂါန္တော ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","ဒေၑသျ ဝိပက္ၐတယာ ဒေၑော ရာဇျသျ ဝိပက္ၐတယာ စ ရာဇျမုတ္ထာသျတိ, တထာ သ္ထာနေ သ္ထာနေ ဘူမိကမ္ပော ဒုရ္ဘိက္ၐံ မဟာက္လေၑာၑ္စ သမုပသ္ထာသျန္တိ, သရွွ ဧတေ ဒုးခသျာရမ္ဘား၊ ");
INSERT INTO sanbur_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","ကိန္တု ယူယမ် အာတ္မာရ္ထေ သာဝဓာနာသ္တိၐ္ဌတ, ယတော လောကာ ရာဇသဘာယာံ ယုၐ္မာန် သမရ္ပယိၐျန္တိ, တထာ ဘဇနဂၖဟေ ပြဟရိၐျန္တိ; ယူယံ မဒရ္ထေ ဒေၑာဓိပါန် ဘူပါံၑ္စ ပြတိ သာက္ၐျဒါနာယ တေၐာံ သမ္မုခေ ဥပသ္ထာပယိၐျဓွေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ၑေၐီဘဝနာတ် ပူရွွံ သရွွာန် ဒေၑီယာန် ပြတိ သုသံဝါဒး ပြစာရယိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","ကိန္တု ယဒါ တေ ယုၐ္မာန် ဓၖတွာ သမရ္ပယိၐျန္တိ တဒါ ယူယံ ယဒျဒ် ဥတ္တရံ ဒါသျထ, တဒဂြ တသျ ဝိဝေစနံ မာ ကုရုတ တဒရ္ထံ ကိဉ္စိဒပိ မာ စိန္တယတ စ, တဒါနီံ ယုၐ္မာကံ မနးသု ယဒျဒ် ဝါကျမ် ဥပသ္ထာပယိၐျတေ တဒေဝ ဝဒိၐျထ, ယတော ယူယံ န တဒွက္တာရး ကိန္တု ပဝိတြ အာတ္မာ တသျ ဝက္တာ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","တဒါ ဘြာတာ ဘြာတရံ ပိတာ ပုတြံ ဃာတနာရ္ထံ ပရဟသ္တေၐု သမရ္ပယိၐျတေ, တထာ ပတျာနိ မာတာပိတြော ရွိပက္ၐတယာ တော် ဃာတယိၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","မမ နာမဟေတေား သရွွေၐာံ သဝိဓေ ယူယံ ဇုဂုပ္သိတာ ဘဝိၐျထ, ကိန္တု ယး ကၑ္စိတ် ၑေၐပရျျန္တံ ဓဲရျျမ် အာလမ္ဗိၐျတေ သဧဝ ပရိတြာသျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","ဒါနိယေလ္ဘဝိၐျဒွါဒိနာ ပြောက္တံ သရွွနာၑိ ဇုဂုပ္သိတဉ္စ ဝသ္တု ယဒါ တွယောဂျသ္ထာနေ ဝိဒျမာနံ ဒြက္ၐထ (ယော ဇနး ပဌတိ သ ဗုဓျတာံ) တဒါ ယေ ယိဟူဒီယဒေၑေ တိၐ္ဌန္တိ တေ မဟီဓြံ ပြတိ ပလာယန္တာံ; ");
INSERT INTO sanbur_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","တထာ ယော နရော ဂၖဟောပရိ တိၐ္ဌတိ သ ဂၖဟမဓျံ နာဝရောဟတု, တထာ ကိမပိ ဝသ္တု ဂြဟီတုံ မဓျေဂၖဟံ န ပြဝိၑတု; ");
INSERT INTO sanbur_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","တထာ စ ယော နရး က္ၐေတြေ တိၐ္ဌတိ သောပိ သွဝသ္တြံ ဂြဟီတုံ ပရာဝၖတျ န ဝြဇတု၊ ");
INSERT INTO sanbur_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","တဒါနီံ ဂရ္ဗ္ဘဝတီနာံ သ္တနျဒါတြီဏာဉ္စ ယောၐိတာံ ဒုရ္ဂတိ ရ္ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ယုၐ္မာကံ ပလာယနံ ၑီတကာလေ ယထာ န ဘဝတိ တဒရ္ထံ ပြာရ္ထယဓွံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ယတသ္တဒါ ယာဒၖၑီ ဒုရ္ဃဋနာ ဃဋိၐျတေ တာဒၖၑီ ဒုရ္ဃဋနာ ဤၑွရသၖၐ္ဋေး ပြထမမာရဘျာဒျ ယာဝတ် ကဒါပိ န ဇာတာ န ဇနိၐျတေ စ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","အပရဉ္စ ပရမေၑွရော ယဒိ တသျ သမယသျ သံက္ၐေပံ န ကရောတိ တရှိ ကသျာပိ ပြာဏဘၖတော ရက္ၐာ ဘဝိတုံ န ၑက္ၐျတိ, ကိန္တု ယာန် ဇနာန် မနောနီတာန် အကရောတ် တေၐာံ သွမနောနီတာနာံ ဟေတေား သ တဒနေဟသံ သံက္ၐေပ္သျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","အနျစ္စ ပၑျတ ခြီၐ္ဋောတြ သ္ထာနေ ဝါ တတြ သ္ထာနေ ဝိဒျတေ, တသ္မိန္ကာလေ ယဒိ ကၑ္စိဒ် ယုၐ္မာန် ဧတာဒၖၑံ ဝါကျံ ဝျာဟရတိ, တရှိ တသ္မိန် ဝါကျေ ဘဲဝ ဝိၑွသိတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ယတောနေကေ မိထျာခြီၐ္ဋာ မိထျာဘဝိၐျဒွါဒိနၑ္စ သမုပသ္ထာယ ဗဟူနိ စိဟ္နာနျဒ္ဘုတာနိ ကရ္မ္မာဏိ စ ဒရ္ၑယိၐျန္တိ; တထာ ယဒိ သမ္ဘဝတိ တရှိ မနောနီတလောကာနာမပိ မိထျာမတိံ ဇနယိၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","ပၑျတ ဃဋနာတး ပူရွွံ သရွွကာရျျသျ ဝါရ္တ္တာံ ယုၐ္မဘျမဒါမ်, ယူယံ သာဝဓာနာသ္တိၐ္ဌတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","အပရဉ္စ တသျ က္လေၑကာလသျာဝျဝဟိတေ ပရကာလေ ဘာသ္ကရး သာန္ဓကာရော ဘဝိၐျတိ တထဲဝ စန္ဒြၑ္စန္ဒြိကာံ န ဒါသျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","နဘးသ္ထာနိ နက္ၐတြာဏိ ပတိၐျန္တိ, ဝျောမမဏ္ဍလသ္ထာ ဂြဟာၑ္စ ဝိစလိၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","တဒါနီံ မဟာပရာကြမေဏ မဟဲၑွရျျေဏ စ မေဃမာရုဟျ သမာယာန္တံ မာနဝသုတံ မာနဝါး သမီက္ၐိၐျန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","အနျစ္စ သ နိဇဒူတာန် ပြဟိတျ နဘောဘူမျေား သီမာံ ယာဝဒ် ဇဂတၑ္စတုရ္ဒိဂ္ဘျး သွမနောနီတလောကာန် သံဂြဟီၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","ဥဍုမ္ဗရတရော ရ္ဒၖၐ္ဋာန္တံ ၑိက္ၐဓွံ ယဒေါဍုမ္ဗရသျ တရော ရ္နဝီနား ၑာခါ ဇာယန္တေ ပလ္လဝါဒီနိ စ ရ္နိဂစ္ဆန္တိ, တဒါ နိဒါဃကာလး သဝိဓော ဘဝတီတိ ယူယံ ဇ္ဉာတုံ ၑက္နုထ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","တဒွဒ် ဧတာ ဃဋနာ ဒၖၐ္ဋွာ သ ကာလော ဒွါရျျုပသ္ထိတ ဣတိ ဇာနီတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ယုၐ္မာနဟံ ယထာရ္ထံ ဝဒါမိ, အာဓုနိကလောကာနာံ ဂမနာတ် ပူရွွံ တာနိ သရွွာဏိ ဃဋိၐျန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ဒျာဝါပၖထိဝျော ရွိစလိတယေား သတျော ရ္မဒီယာ ဝါဏီ န ဝိစလိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","အပရဉ္စ သွရ္ဂသ္ထဒူတဂဏော ဝါ ပုတြော ဝါ တာတာဒနျး ကောပိ တံ ဒိဝသံ တံ ဒဏ္ဍံ ဝါ န ဇ္ဉာပယတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","အတး သ သမယး ကဒါ ဘဝိၐျတိ, ဧတဇ္ဇ္ဉာနာဘာဝါဒ် ယူယံ သာဝဓာနာသ္တိၐ္ဌတ, သတရ္ကာၑ္စ ဘူတွာ ပြာရ္ထယဓွံ; ");
INSERT INTO sanbur_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ယဒွတ် ကၑ္စိတ် ပုမာန် သွနိဝေၑနာဒ် ဒူရဒေၑံ ပြတိ ယာတြာကရဏကာလေ ဒါသေၐု သွကာရျျသျ ဘာရမရ္ပယိတွာ သရွွာန် သွေ သွေ ကရ္မ္မဏိ နိယောဇယတိ; အပရံ ဒေါ်ဝါရိကံ ဇာဂရိတုံ သမာဒိၑျ ယာတိ, တဒွန် နရပုတြး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","ဂၖဟပတိး သာယံကာလေ နိၑီထေ ဝါ တၖတီယယာမေ ဝါ ပြာတးကာလေ ဝါ ကဒါဂမိၐျတိ တဒ် ယူယံ န ဇာနီထ; ");
INSERT INTO sanbur_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","သ ဟဌာဒါဂတျ ယထာ ယုၐ္မာန် နိဒြိတာန် န ပၑျတိ, တဒရ္ထံ ဇာဂရိတာသ္တိၐ္ဌတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","ယုၐ္မာနဟံ ယဒ် ဝဒါမိ တဒေဝ သရွွာန် ဝဒါမိ, ဇာဂရိတာသ္တိၐ္ဌတေတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","တဒါ နိသ္တာရောတ္သဝကိဏွဟီနပူပေါတ္သဝယောရာရမ္ဘသျ ဒိနဒွယေ 'ဝၑိၐ္ဋေ ပြဓာနယာဇကာ အဓျာပကာၑ္စ ကေနာပိ ဆလေန ယီၑုံ ဓရ္တ္တာံ ဟန္တုဉ္စ မၖဂယာဉ္စကြိရေ; ");
INSERT INTO sanbur_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","ကိန္တု လောကာနာံ ကလဟဘယာဒူစိရေ, နစောတ္သဝကာလ ဥစိတမေတဒိတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","အနန္တရံ ဗဲထနိယာပုुရေ ၑိမောနကုၐ္ဌိနော ဂၖဟေ ယောၑော် ဘောတ္ကုမုပဝိၐ္ဋေ သတိ ကာစိဒ် ယောၐိတ် ပါဏ္ဍရပါၐာဏသျ သမ္ပုဋကေန မဟာရ္ဃျောတ္တမတဲလမ် အာနီယ သမ္ပုဋကံ ဘံက္တွာ တသျောတ္တမာင်္ဂေ တဲလဓာရာံ ပါတယာဉ္စကြေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","တသ္မာတ် ကေစိတ် သွာန္တေ ကုပျန္တး ကထိတဝံန္တး ကုတောယံ တဲလာပဝျယး? ");
INSERT INTO sanbur_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ယဒျေတတ် တဲလ ဝျကြေၐျတ တရှိ မုဒြာပါဒၑတတြယာဒပျဓိကံ တသျ ပြာပ္တမူလျံ ဒရိဒြလောကေဘျော ဒါတုမၑက္ၐျတ, ကထာမေတာံ ကထယိတွာ တယာ ယောၐိတာ သာကံ ဝါစာယုဟျန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","ကိန္တု ယီၑုရုဝါစ, ကုတ ဧတသျဲ ကၖစ္ဆြံ ဒဒါသိ? မဟျမိယံ ကရ္မ္မောတ္တမံ ကၖတဝတီ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ဒရိဒြား သရွွဒါ ယုၐ္မာဘိး သဟ တိၐ္ဌန္တိ, တသ္မာဒ် ယူယံ ယဒေစ္ဆထ တဒဲဝ တာနုပကရ္တ္တာံ ၑက္နုထ, ကိန္တွဟံ ယုဘာဘိး သဟ နိရန္တရံ န တိၐ္ဌာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","အသျာ ယထာသာဓျံ တထဲဝါကရောဒိယံ, ၑ္မၑာနယာပနာတ် ပူရွွံ သမေတျ မဒွပုၐိ တဲလမ် အမရ္ဒ္ဒယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","အဟံ ယုၐ္မဘျံ ယထာရ္ထံ ကထယာမိ, ဇဂတာံ မဓျေ ယတြ ယတြ သုသံဝါဒေါယံ ပြစာရယိၐျတေ တတြ တတြ ယောၐိတ ဧတသျား သ္မရဏာရ္ထံ တတ္ကၖတကရ္မ္မဲတတ် ပြစာရယိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","တတး ပရံ ဒွါဒၑာနာံ ၑိၐျာဏာမေက ဤၐ္ကရိယောတီယယိဟူဒါချော ယီၑုံ ပရကရေၐု သမရ္ပယိတုံ ပြဓာနယာဇကာနာံ သမီပမိယာယ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","တေ တသျ ဝါကျံ သမာကရ္ဏျ သန္တုၐ္ဋား သန္တသ္တသ္မဲ မုဒြာ ဒါတုံ ပြတျဇာနတ; တသ္မာတ် သ တံ တေၐာံ ကရေၐု သမရ္ပဏာယောပါယံ မၖဂယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","အနန္တရံ ကိဏွၑူနျပူပေါတ္သဝသျ ပြထမေ'ဟနိ နိသ္တာရောတ္မဝါရ္ထံ မေၐမာရဏာသမယေ ၑိၐျာသ္တံ ပပြစ္ဆး ကုတြ ဂတွာ ဝယံ နိသ္တာရောတ္သဝသျ ဘောဇျမာသာဒယိၐျာမး? ကိမိစ္ဆတိ ဘဝါန်? ");
INSERT INTO sanbur_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","တဒါနီံ သ တေၐာံ ဒွယံ ပြေရယန် ဗဘာၐေ ယုဝယေား ပုရမဓျံ ဂတယေား သတော ရျော ဇနး သဇလကုမ္ဘံ ဝဟန် ယုဝါံ သာက္ၐာတ် ကရိၐျတိ တသျဲဝ ပၑ္စာဒ် ယာတံ; ");
INSERT INTO sanbur_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","သ ယတ် သဒနံ ပြဝေက္ၐျတိ တဒ္ဘဝနပတိံ ဝဒတံ, ဂုရုရာဟ ယတြ သၑိၐျောဟံ နိသ္တာရောတ္သဝီယံ ဘောဇနံ ကရိၐျာမိ, သာ ဘောဇနၑာလာ ကုတြာသ္တိ? ");
INSERT INTO sanbur_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","တတး သ ပရိၐ္ကၖတာံ သုသဇ္ဇိတာံ ဗၖဟတီစဉ္စ ယာံ ၑာလာံ ဒရ္ၑယိၐျတိ တသျာမသ္မဒရ္ထံ ဘောဇျဒြဝျာဏျာသာဒယတံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","တတး ၑိၐျော် ပြသ္ထာယ ပုရံ ပြဝိၑျ သ ယထောက္တဝါန် တထဲဝ ပြာပျ နိသ္တာရောတ္သဝသျ ဘောဇျဒြဝျာဏိ သမာသာဒယေတာမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","အနန္တရံ ယီၑုး သာယံကာလေ ဒွါဒၑဘိး ၑိၐျဲး သာရ္ဒ္ဓံ ဇဂါမ; ");
INSERT INTO sanbur_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","သရွွေၐု ဘောဇနာယ ပြောပဝိၐ္ဋေၐု သ တာနုဒိတဝါန် ယုၐ္မာနဟံ ယထာရ္ထံ ဝျာဟရာမိ, အတြ ယုၐ္မာကမေကော ဇနော ယော မယာ သဟ ဘုံက္တေ မာံ ပရကေရေၐု သမရ္ပယိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","တဒါနီံ တေ ဒုးခိတား သန္တ ဧကဲကၑသ္တံ ပြၐ္ဋုမာရဗ္ဓဝန္တး သ ကိမဟံ? ပၑ္စာဒ် အနျ ဧကောဘိဒဓေ သ ကိမဟံ? ");
INSERT INTO sanbur_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","တတး သ ပြတျဝဒဒ် ဧတေၐာံ ဒွါဒၑာနာံ ယော ဇနော မယာ သမံ ဘောဇနာပါတြေ ပါဏိံ မဇ္ဇယိၐျတိ သ ဧဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","မနုဇတနယမဓိ ယာဒၖၑံ လိခိတမာသ္တေ တဒနုရူပါ ဂတိသ္တသျ ဘဝိၐျတိ, ကိန္တု ယော ဇနော မာနဝသုတံ သမရ္ပယိၐျတေ ဟန္တ တသျ ဇန္မာဘာဝေ သတိ ဘဒြမဘဝိၐျတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","အပရဉ္စ တေၐာံ ဘောဇနသမယေ ယီၑုး ပူပံ ဂၖဟီတွေၑွရဂုဏာန် အနုကီရ္တျ ဘင်္က္တွာ တေဘျော ဒတ္တွာ ဗဘာၐေ, ဧတဒ် ဂၖဟီတွာ ဘုဉ္ဇီဓွမ် ဧတန္မမ ဝိဂြဟရူပံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","အနန္တရံ သ ကံသံ ဂၖဟီတွေၑွရသျ ဂုဏာန် ကီရ္တ္တယိတွာ တေဘျော ဒဒေါ်, တတသ္တေ သရွွေ ပပုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","အပရံ သ တာနဝါဒီဒ် ဗဟူနာံ နိမိတ္တံ ပါတိတံ မမ နဝီနနိယမရူပံ ၑောဏိတမေတတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","ယုၐ္မာနဟံ ယထာရ္ထံ ဝဒါမိ, ဤၑွရသျ ရာဇျေ ယာဝတ် သဒျောဇာတံ ဒြာက္ၐာရသံ န ပါသျာမိ,တာဝဒဟံ ဒြာက္ၐာဖလရသံ ပုန ရ္န ပါသျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","တဒနန္တရံ တေ ဂီတမေကံ သံဂီယ ဗဟိ ရ္ဇဲတုနံ ၑိခရိဏံ ယယုး ");
INSERT INTO sanbur_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","အထ ယီၑုသ္တာနုဝါစ နိၑာယာမသျာံ မယိ ယုၐ္မာကံ သရွွေၐာံ ပြတျူဟော ဘဝိၐျတိ ယတော လိခိတမာသ္တေ ယထာ, မေၐာဏာံ ရက္ၐကဉ္စာဟံ ပြဟရိၐျာမိ ဝဲ တတး၊ မေၐာဏာံ နိဝဟော နူနံ ပြဝိကီရ္ဏော ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","ကန္တု မဒုတ္ထာနေ ဇာတေ ယုၐ္မာကမဂြေ'ဟံ ဂါလီလံ ဝြဇိၐျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","တဒါ ပိတရး ပြတိဗဘာၐေ, ယဒျပိ သရွွေၐာံ ပြတျူဟော ဘဝတိ တထာပိ မမ နဲဝ ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","တတော ယီၑုရုက္တာဝါန် အဟံ တုဘျံ တထျံ ကထယာမိ, က္ၐဏာဒါယာမဒျ ကုက္ကုဋသျ ဒွိတီယဝါရရဝဏာတ် ပူရွွံ တွံ ဝါရတြယံ မာမပဟ္နောၐျသေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","ကိန္တု သ ဂါဎံ ဝျာဟရဒ် ယဒျပိ တွယာ သာရ္ဒ္ဓံ မမ ပြာဏော ယာတိ တထာပိ ကထမပိ တွာံ နာပဟ္နောၐျေ; သရွွေ'ပီတရေ တထဲဝ ဗဘာၐိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","အပရဉ္စ တေၐု ဂေတ္ၑိမာနီနာမကံ သ္ထာန ဂတေၐု သ ၑိၐျာန် ဇဂါဒ, ယာဝဒဟံ ပြာရ္ထယေ တာဝဒတြ သ္ထာနေ ယူယံ သမုပဝိၑတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","အထ သ ပိတရံ ယာကူဗံ ယောဟနဉ္စ ဂၖဟီတွာ ဝဝြာဇ; အတျန္တံ တြာသိတော ဝျာကုလိတၑ္စ တေဘျး ကထယာမာသ, ");
INSERT INTO sanbur_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","နိဓနကာလဝတ် ပြာဏော မေ'တီဝ ဒးခမေတိ, ယူယံ ဇာဂြတောတြ သ္ထာနေ တိၐ္ဌတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","တတး သ ကိဉ္စိဒ္ဒူရံ ဂတွာ ဘူမာဝဓောမုခး ပတိတွာ ပြာရ္ထိတဝါနေတတ်, ယဒိ ဘဝိတုံ ၑကျံ တရှိ ဒုးခသမယောယံ မတ္တော ဒူရီဘဝတု၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","အပရမုဒိတဝါန် ဟေ ပိတ ရှေ ပိတး သရွွေံ တွယာ သာဓျံ, တတော ဟေတောရိမံ ကံသံ မတ္တော ဒူရီကုရု, ကိန္တု တန် မမေစ္ဆာတော န တဝေစ္ဆာတော ဘဝတု၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","တတး ပရံ သ ဧတျ တာန် နိဒြိတာန် နိရီက္ၐျ ပိတရံ ပြောဝါစ, ၑိမောန် တွံ ကိံ နိဒြာသိ? ဃဋိကာမေကာမ် အပိ ဇာဂရိတုံ န ၑက္နောၐိ? ");
INSERT INTO sanbur_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","ပရီက္ၐာယာံ ယထာ န ပတထ တဒရ္ထံ သစေတနား သန္တး ပြာရ္ထယဓွံ; မန ဥဒျုက္တမိတိ သတျံ ကိန္တု ဝပုရၑက္တိကံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","အထ သ ပုနရွြဇိတွာ ပူရွွဝတ် ပြာရ္ထယာဉ္စကြေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ပရာဝၖတျာဂတျ ပုနရပိ တာန် နိဒြိတာန် ဒဒရ္ၑ တဒါ တေၐာံ လောစနာနိ နိဒြယာ ပူရ္ဏာနိ, တသ္မာတ္တသ္မဲ ကာ ကထာ ကထယိတဝျာ တ ဧတဒ် ဗောဒ္ဓုံ န ၑေကုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","တတးပရံ တၖတီယဝါရံ အာဂတျ တေဘျော 'ကထယဒ် ဣဒါနီမပိ ၑယိတွာ ဝိၑြာမျထ? ယထေၐ္ဋံ ဇာတံ, သမယၑ္စောပသ္ထိတး ပၑျတ မာနဝတနယး ပါပိလောကာနာံ ပါဏိၐု သမရ္ပျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ဥတ္တိၐ္ဌတ, ဝယံ ဝြဇာမော ယော ဇနော မာံ ပရပါဏိၐု သမရ္ပယိၐျတေ ပၑျတ သ သမီပမာယာတး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ဣမာံ ကထာံ ကထယတိ သ, ဧတရှိဒွါဒၑာနာမေကော ယိဟူဒါ နာမာ ၑိၐျး ပြဓာနယာဇကာနာမ် ဥပါဓျာယာနာံ ပြာစီနလောကာနာဉ္စ သန္နိဓေး ခင်္ဂလဂုဍဓာရိဏော ဗဟုလောကာန် ဂၖဟီတွာ တသျ သမီပ ဥပသ္ထိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","အပရဉ္စာသော် ပရပါဏိၐု သမရ္ပယိတာ ပူရွွမိတိ သင်္ကေတံ ကၖတဝါန် ယမဟံ စုမ္ဗိၐျာမိ သ ဧဝါသော် တမေဝ ဓၖတွာ သာဝဓာနံ နယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","အတော ဟေတေား သ အာဂတျဲဝ ယောၑေား သဝိဓံ ဂတွာ ဟေ ဂုရော ဟေ ဂုရော, ဣတျုက္တွာ တံ စုစုမ္ဗ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","တဒါ တေ တဒုပရိ ပါဏီနရ္ပယိတွာ တံ ဒဓ္နုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","တတသ္တသျ ပါရ္ၑွသ္ထာနာံ လောကာနာမေကး ခင်္ဂံ နိၐ္ကောၐယန် မဟာယာဇကသျ ဒါသမေကံ ပြဟၖတျ တသျ ကရ္ဏံ စိစ္ဆေဒ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","ပၑ္စာဒ် ယီၑုသ္တာန် ဝျာဇဟာရ ခင်္ဂါန် လဂုဍာံၑ္စ ဂၖဟီတွာ မာံ ကိံ စော်ရံ ဓရ္တ္တာံ သမာယာတား? ");
INSERT INTO sanbur_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","မဓျေမန္ဒိရံ သမုပဒိၑန် ပြတျဟံ ယုၐ္မာဘိး သဟ သ္ထိတဝါနတဟံ, တသ္မိန် ကာလေ ယူယံ မာံ နာဒီဓရတ, ကိန္တွနေန ၑာသ္တြီယံ ဝစနံ သေဓနီယံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","တဒါ သရွွေ ၑိၐျာသ္တံ ပရိတျဇျ ပလာယာဉ္စကြိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","အထဲကော ယုဝါ မာနဝေါ နဂ္နကာယေ ဝသ္တြမေကံ နိဓာယ တသျ ပၑ္စာဒ် ဝြဇန် ယုဝလောကဲ ရ္ဓၖတော ");
INSERT INTO sanbur_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ဝသ္တြံ ဝိဟာယ နဂ္နး ပလာယာဉ္စကြေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","အပရဉ္စ ယသ္မိန် သ္ထာနေ ပြဓာနယာဇကာ ဥပါဓျာယား ပြာစီနလောကာၑ္စ မဟာယာဇကေန သဟ သဒသိ သ္ထိတာသ္တသ္မိန် သ္ထာနေ မဟာယာဇကသျ သမီပံ ယီၑုံ နိနျုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ပိတရော ဒူရေ တတ္ပၑ္စာဒ် ဣတွာ မဟာယာဇကသျာဋ္ဋာလိကာံ ပြဝိၑျ ကိင်္ကရဲး သဟောပဝိၑျ ဝဟ္နိတာပံ ဇဂြာဟ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","တဒါနီံ ပြဓာနယာဇကာ မန္တြိဏၑ္စ ယီၑုံ ဃာတယိတုံ တတ္ပြာတိကူလျေန သာက္ၐိဏော မၖဂယာဉ္စကြိရေ, ကိန္တု န ပြာပ္တား၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","အနေကဲသ္တဒွိရုဒ္ဓံ မၖၐာသာက္ၐျေ ဒတ္တေပိ တေၐာံ ဝါကျာနိ န သမဂစ္ဆန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","သရွွၑေၐေ ကိယန္တ ဥတ္ထာယ တသျ ပြာတိကူလျေန မၖၐာသာက္ၐျံ ဒတ္တွာ ကထယာမာသုး, ");
INSERT INTO sanbur_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","ဣဒံ ကရကၖတမန္ဒိရံ ဝိနာၑျ ဒိနတြယမဓျေ ပုနရပရမ် အကရကၖတံ မန္ဒိရံ နိရ္မ္မာသျာမိ, ဣတိ ဝါကျမ် အသျ မုခါတ် ၑြုတမသ္မာဘိရိတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","ကိန္တု တတြာပိ တေၐာံ သာက္ၐျကထာ န သင်္ဂါတား၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","အထ မဟာယာဇကော မဓျေသဘမ် ဥတ္ထာယ ယီၑုံ ဝျာဇဟာရ, ဧတေ ဇနာသ္တွယိ ယတ် သာက္ၐျမဒုး တွမေတသျ ကိမပျုတ္တရံ ကိံ န ဒါသျသိ? ");
INSERT INTO sanbur_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","ကိန္တု သ ကိမပျုတ္တရံ န ဒတွာ မော်နီဘူယ တသျော်; တတော မဟာယာဇကး ပုနရပိ တံ ပၖၐ္ဋာဝါန် တွံ သစ္စိဒါနန္ဒသျ တနယော 'ဘိၐိက္တသ္တြတာ? ");
INSERT INTO sanbur_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","တဒါ ယီၑုသ္တံ ပြောဝါစ ဘဝါမျဟမ် ယူယဉ္စ သရွွၑက္တိမတော ဒက္ၐီဏပါရ္ၑွေ သမုပဝိၑန္တံ မေဃ မာရုဟျ သမာယာန္တဉ္စ မနုၐျပုတြံ သန္ဒြက္ၐျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","တဒါ မဟာယာဇကး သွံ ဝမနံ ဆိတွာ ဝျာဝဟရတ္ ");
INSERT INTO sanbur_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ကိမသ္မာကံ သာက္ၐိဘိး ပြယောဇနမ်? ဤၑွရနိန္ဒာဝါကျံ ယုၐ္မာဘိရၑြာဝိ ကိံ ဝိစာရယထ? တဒါနီံ သရွွေ ဇဂဒုရယံ နိဓနဒဏ္ဍမရှတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","တတး ကၑ္စိတ် ကၑ္စိတ် တဒွပုၐိ နိၐ္ဌီဝံ နိစိက္ၐေပ တထာ တန္မုခမာစ္ဆာဒျ စပေဋေန ဟတွာ ဂဒိတဝါန် ဂဏယိတွာ ဝဒ, အနုစရာၑ္စ စပေဋဲသ္တမာဇဃ္နုး ");
INSERT INTO sanbur_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","တတး ပရံ ပိတရေ'ဋ္ဋာလိကာဓးကောၐ္ဌေ တိၐ္ဌတိ မဟာယာဇကသျဲကာ ဒါသီ သမေတျ ");
INSERT INTO sanbur_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","တံ ဝိဟ္နိတာပံ ဂၖဟ္လန္တံ ဝိလောကျ တံ သုနိရီက္ၐျ ဗဘာၐေ တွမပိ နာသရတီယယီၑေား သင်္ဂိနာမ် ဧကော ဇန အာသီး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","ကိန္တု သောပဟ္နုတျ ဇဂါဒ တမဟံ န ဝဒ္မိ တွံ ယတ် ကထယမိ တဒပျဟံ န ဗုဒ္ဓျေ၊ တဒါနီံ ပိတရေ စတွရံ ဂတဝတိ ကုेက္ကုဋော ရုရာဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","အထာနျာ ဒါသီ ပိတရံ ဒၖၐ္ဋွာ သမီပသ္ထာန် ဇနာန် ဇဂါဒ အယံ တေၐာမေကော ဇနး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","တတး သ ဒွိတီယဝါရမ် အပဟ္နုတဝါန် ပၑ္စာတ် တတြသ္ထာ လောကား ပိတရံ ပြောစုသ္တွမဝၑျံ တေၐာမေကော ဇနး ယတသ္တွံ ဂါလီလီယော နရ ဣတိ တဝေါစ္စာရဏံ ပြကာၑယတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","တဒါ သ ၑပထာဘိၑာပေါ် ကၖတွာ ပြောဝါစ ယူယံ ကထာံ ကထယထ တံ နရံ န ဇာနေ'ဟံ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","တဒါနီံ ဒွိတီယဝါရံ ကုက္ကုဋော 'ရာဝီတ်၊ ကုက္ကုဋသျ ဒွိတီယရဝါတ် ပူရွွံ တွံ မာံ ဝါရတြယမ် အပဟ္နောၐျသိ, ဣတိ ယဒွါကျံ ယီၑုနာ သမုဒိတံ တတ် တဒါ သံသ္မၖတျ ပိတရော ရောဒိတုမ် အာရဘတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","အထ ပြဘာတေ သတိ ပြဓာနယာဇကား ပြာဉ္စ ဥပါဓျာယား သရွွေ မန္တြိဏၑ္စ သဘာံ ကၖတွာ ယီၑုृံ ဗန္ဓယိတွ ပီလာတာချသျ ဒေၑာဓိပတေး သဝိဓံ နီတွာ သမရ္ပယာမာသုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","တဒါ ပီလာတသ္တံ ပၖၐ္ဋဝါန် တွံ ကိံ ယိဟူဒီယလောကာနာံ ရာဇာ? တတး သ ပြတျုက္တဝါန် သတျံ ဝဒသိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","အပရံ ပြဓာနယာဇကာသ္တသျ ဗဟုၐု ဝါကျေၐု ဒေါၐမာရောပယာဉ္စကြုး ကိန္တု သ ကိမပိ န ပြတျုဝါစ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","တဒါနီံ ပီလာတသ္တံ ပုနး ပပြစ္ဆ တွံ ကိံ နောတ္တရယသိ? ပၑျဲတေ တွဒွိရုဒ္ဓံ ကတိၐု သာဓျေၐု သာက္ၐံ ဒဒတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","ကန္တု ယီၑုသ္တဒါပိ နောတ္တရံ ဒဒေါ် တတး ပီလာတ အာၑ္စရျျံ ဇဂါမ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","အပရဉ္စ ကာရာဗဒ္ဓေ ကသ္တိံၑ္စိတ် ဇနေ တန္မဟောတ္သဝကာလေ လောကဲ ရျာစိတေ ဒေၑာဓိပတိသ္တံ မောစယတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ယေ စ ပူရွွမုပပ္လဝမကာရ္ၐုရုပပ္လဝေ ဝဓမပိ ကၖတဝန္တသ္တေၐာံ မဓျေ တဒါနောံ ဗရဗ္ဗာနာမက ဧကော ဗဒ္ဓ အာသီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","အတော ဟေတေား ပူရွွာပရီယာံ ရီတိကထာံ ကထယိတွာ လောကာ ဥစ္စဲရုဝန္တး ပီလာတသျ သမက္ၐံ နိဝေဒယာမာသုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","တဒါ ပီလာတသ္တာနာစချော် တရှိ ကိံ ယိဟူဒီယာနာံ ရာဇာနံ မောစယိၐျာမိ? ယုၐ္မာဘိး ကိမိၐျတေ? ");
INSERT INTO sanbur_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ယတး ပြဓာနယာဇကာ ဤရ္ၐျာတ ဧဝ ယီၑုံ သမာရ္ပယန္နိတိ သ ဝိဝေဒ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","ကိန္တု ယထာ ဗရဗ္ဗာံ မောစယတိ တထာ ပြာရ္ထယိတုံ ပြဓာနယာဇကာ လောကာန် ပြဝရ္တ္တယာမာသုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","အထ ပီလာတး ပုနး ပၖၐ္ဋဝါန် တရှိ ယံ ယိဟူဒီယာနာံ ရာဇေတိ ဝဒထ တသျ ကိံ ကရိၐျာမိ ယုၐ္မာဘိး ကိမိၐျတေ? ");
INSERT INTO sanbur_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","တဒါ တေ ပုနရပိ ပြောစ္စဲး ပြောစုသ္တံ ကြုၑေ ဝေဓယ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","တသ္မာတ် ပီလာတး ကထိတဝါန် ကုတး? သ ကိံ ကုကရ္မ္မ ကၖတဝါန်? ကိန္တု တေ ပုနၑ္စ ရုဝန္တော ဝျာဇဟြုသ္တံ ကြုၑေ ဝေဓယ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","တဒါ ပီလာတး သရွွာလ္လောကာန် တောၐယိတုမိစ္ဆန် ဗရဗ္ဗာံ မောစယိတွာ ယီၑုံ ကၑာဘိး ပြဟၖတျ ကြုၑေ ဝေဒ္ဓုံ တံ သမရ္ပယာမ္ဗဘူဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","အနန္တရံ သဲနျဂဏော'ဋ္ဋာလိကာမ် အရ္ထာဒ် အဓိပတေ ရ္ဂၖဟံ ယီၑုံ နီတွာ သေနာနိဝဟံ သမာဟုယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ပၑ္စာတ် တေ တံ ဓူမလဝရ္ဏဝသ္တြံ ပရိဓာပျ ကဏ္ဋကမုကုဋံ ရစယိတွာ ၑိရသိ သမာရောပျ ");
INSERT INTO sanbur_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ဟေ ယိဟူဒီယာနာံ ရာဇန် နမသ္ကာရ ဣတျုက္တွာ တံ နမသ္ကရ္တ္တာမာရေဘိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","တသျောတ္တမာင်္ဂေ ဝေတြာဃာတံ စကြုသ္တဒ္ဂါတြေ နိၐ္ဌီဝဉ္စ နိစိက္ၐိပုး, တထာ တသျ သမ္မုခေ ဇာနုပါတံ ပြဏောမုး ");
INSERT INTO sanbur_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ဣတ္ထမုပဟသျ ဓူမြဝရ္ဏဝသ္တြမ် ဥတ္တာရျျ တသျ ဝသ္တြံ တံ ပရျျဓာပယန် ကြုၑေ ဝေဒ္ဓုံ ဗဟိရ္နိနျုၑ္စ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","တတး ပရံ သေကန္ဒရသျ ရုဖသျ စ ပိတာ ၑိမောန္နာမာ ကုရီဏီယလောက ဧကး ကုတၑ္စိဒ် ဂြာမာဒေတျ ပထိ ယာတိ တံ တေ ယီၑေား ကြုၑံ ဝေါဎုံ ဗလာဒ် ဒဓ္နုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","အထ ဂုလ္ဂလ္တာ အရ္ထာတ် ၑိရးကပါလနာမကံ သ္ထာနံ ယီၑုမာနီယ ");
INSERT INTO sanbur_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","တေ ဂန္ဓရသမိၑြိတံ ဒြာက္ၐာရသံ ပါတုံ တသ္မဲ ဒဒုး ကိန္တု သ န ဇဂြာဟ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","တသ္မိန် ကြုၑေ ဝိဒ္ဓေ သတိ တေၐာမေကဲကၑး ကိံ ပြာပ္သျတီတိ နိရ္ဏယာယ ");
INSERT INTO sanbur_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","တသျ ပရိဓေယာနာံ ဝိဘာဂါရ္ထံ ဂုဋိကာပါတံ စကြုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","အပရမ် ဧၐ ယိဟူဒီယာနာံ ရာဇေတိ လိခိတံ ဒေါၐပတြံ တသျ ၑိရဦရ္ဒွွမ် အာရောပယာဉ္စကြုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","တသျ ဝါမဒက္ၐိဏယော ရ္ဒွေါ် စော်ရော် ကြုၑယော ရွိဝိဓာတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","တေနဲဝ \"အပရာဓိဇနဲး သာရ္ဒ္ဓံ သ ဂဏိတော ဘဝိၐျတိ,\" ဣတိ ၑာသ္တြောက္တံ ဝစနံ သိဒ္ဓမဘူတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","အနန္တရံ မာရ္ဂေ ယေ ယေ လောကာ ဂမနာဂမနေ စကြုသ္တေ သရွွ ဧဝ ၑိရာံသျာန္ဒောလျ နိန္ဒန္တော ဇဂဒုး, ရေ မန္ဒိရနာၑက ရေ ဒိနတြယမဓျေ တန္နိရ္မ္မာယက, ");
INSERT INTO sanbur_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","အဓုနာတ္မာနမ် အဝိတွာ ကြုၑာဒဝရောဟ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","ကိဉ္စ ပြဓာနယာဇကာ အဓျာပကာၑ္စ တဒွတ် တိရသ္ကၖတျ ပရသ္ပရံ စစက္ၐိရေ ဧၐ ပရာနာဝတ် ကိန္တု သွမဝိတုံ န ၑက္နောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ယဒီသြာယေလော ရာဇာဘိၐိက္တသ္တြာတာ ဘဝတိ တရှျဓုနဲန ကြုၑာဒဝရောဟတု ဝယံ တဒ် ဒၖၐ္ဋွာ ဝိၑွသိၐျာမး; ကိဉ္စ ယော် လောကော် တေန သာရ္ဒ္ဓံ ကြုၑေ 'ဝိဓျေတာံ တာဝပိ တံ နိရ္ဘရ္တ္သယာမာသတုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","အထ ဒွိတီယယာမာတ် တၖတီယယာမံ ယာဝတ် သရွွော ဒေၑး သာန္ဓကာရောဘူတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","တတသ္တၖတီယပြဟရေ ယီၑုရုစ္စဲရဝဒတ် ဧလီ ဧလီ လာမာ ၑိဝက္တနီ အရ္ထာဒ် \"ဟေ မဒီၑ မဒီၑ တွံ ပရျျတျာက္ၐီး ကုတော ဟိ မာံ?\" ");
INSERT INTO sanbur_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","တဒါ သမီပသ္ထလောကာနာံ ကေစိတ် တဒွါကျံ နိၑမျာစချုး ပၑျဲၐ ဧလိယမ် အာဟူယတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","တတ ဧကော ဇနော ဓာဝိတွာဂတျ သ္ပဉ္ဇေ 'မ္လရသံ ပူရယိတွာ တံ နဍာဂြေ နိဓာယ ပါတုံ တသ္မဲ ဒတ္တွာဝဒတ် တိၐ္ဌ ဧလိယ ဧနမဝရောဟယိတုမ် ဧတိ န ဝေတိ ပၑျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","အထ ယီၑုရုစ္စဲး သမာဟူယ ပြာဏာန် ဇဟော်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","တဒါ မန္ဒိရသျ ဇဝနိကောရ္ဒွွာဒဓးရျျန္တာ ဝိဒီရ္ဏာ ဒွိခဏ္ဍာဘူတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","ကိဉ္စ ဣတ္ထမုစ္စဲရာဟူယ ပြာဏာန် တျဇန္တံ တံ ဒၖၐ္ဒွါ တဒြက္ၐဏာယ နိယုက္တော ယး သေနာပတိရာသီတ် သောဝဒတ် နရောယမ် ဤၑွရပုတြ ဣတိ သတျမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","တဒါနီံ မဂ္ဒလီနီ မရိသမ် ကနိၐ္ဌယာကူဗော ယောသေၑ္စ မာတာနျမရိယမ် ၑာလောမီ စ ယား သ္တြိယော ");
INSERT INTO sanbur_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","ဂါလီလ္ပြဒေၑေ ယီၑုံ သေဝိတွာ တဒနုဂါမိနျော ဇာတာ ဣမာသ္တဒနျာၑ္စ ယာ အနေကာ နာရျော ယီၑုနာ သာရ္ဒ္ဓံ ယိရူၑာလမမာယာတာသ္တာၑ္စ ဒူရာတ် တာနိ ဒဒၖၑုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","အထာသာဒနဒိနသျာရ္ထာဒ် ဝိၑြာမဝါရာတ် ပူရွွဒိနသျ သာယံကာလ အာဂတ ");
INSERT INTO sanbur_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ဤၑွရရာဇျာပေက္ၐျရိမထီယယူၐဖနာမာ မာနျမန္တြီ သမေတျ ပီလာတသဝိဓံ နိရ္ဘယော ဂတွာ ယီၑောရ္ဒေဟံ ယယာစေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","ကိန္တု သ ဣဒါနီံ မၖတး ပီလာတ ဣတျသမ္ဘဝံ မတွာ ၑတသေနာပတိမာဟူယ သ ကဒါ မၖတ ဣတိ ပပြစ္ဆ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ၑတသေမနာပတိမုခါတ် တဇ္ဇ္ဉာတွာ ယူၐဖေ ယီၑောရ္ဒေဟံ ဒဒေါ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","ပၑ္စာတ် သ သူက္ၐ္မံ ဝါသး ကြီတွာ ယီၑေား ကာယမဝရောဟျ တေန ဝါသသာ ဝေၐ္ဋာယိတွာ ဂိရော် ခါတၑ္မၑာနေ သ္ထာပိတဝါန် ပါၐာဏံ လောဌယိတွာ ဒွါရိ နိဒဓေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","ကိန္တု ယတြ သောသ္ထာပျတ တတ မဂ္ဒလီနီ မရိယမ် ယောသိမာတၖမရိယမ် စ ဒဒၖၑတၖး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","အထ ဝိၑြာမဝါရေ ဂတေ မဂ္ဒလီနီ မရိယမ် ယာကူဗမာတာ မရိယမ် ၑာလောမီ စေမာသ္တံ မရ္ဒ္ဒယိတုံ သုဂန္ဓိဒြဝျာဏိ ကြီတွာ ");
INSERT INTO sanbur_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","သပ္တာဟပြထမဒိနေ'တိပြတျူၐေ သူရျျောဒယကာလေ ၑ္မၑာနမုပဂတား၊ ");
INSERT INTO sanbur_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ကိန္တု ၑ္မၑာနဒွါရပါၐာဏော'တိဗၖဟန် တံ ကော'ပသာရယိၐျတီတိ တား ပရသ္ပရံ ဂဒန္တိ! ");
INSERT INTO sanbur_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ဧတရှိ နိရီက္ၐျ ပါၐာဏော ဒွါရော 'ပသာရိတ ဣတိ ဒဒၖၑုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ပၑ္စာတ္တား ၑ္မၑာနံ ပြဝိၑျ ၑုက္လဝရ္ဏဒီရ္ဃပရိစ္ဆဒါဝၖတမေကံ ယုဝါနံ ၑ္မၑာနဒက္ၐိဏပါရ္ၑွ ဥပဝိၐ္ဋံ ဒၖၐ္ဋွာ စမစ္စကြုး၊ ");
INSERT INTO sanbur_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","သော'ဝဒတ်, မာဘဲၐ္ဋ ယူယံ ကြုၑေ ဟတံ နာသရတီယယီၑုံ ဂဝေၐယထ သောတြ နာသ္တိ ၑ္မၑာနာဒုဒသ္ထာတ်; တဲ ရျတြ သ သ္ထာပိတး သ္ထာနံ တဒိဒံ ပၑျတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","ကိန္တု တေန ယထောက္တံ တထာ ယုၐ္မာကမဂြေ ဂါလီလံ ယာသျတေ တတြ သ ယုၐ္မာန် သာက္ၐာတ် ကရိၐျတေ ယူယံ ဂတွာ တသျ ၑိၐျေဘျး ပိတရာယ စ ဝါရ္တ္တာမိမာံ ကထယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","တား ကမ္ပိတာ ဝိသ္တိတာၑ္စ တူရ္ဏံ ၑ္မၑာနာဒ် ဗဟိရ္ဂတွာ ပလာယန္တ ဘယာတ် ကမပိ ကိမပိ နာဝဒံၑ္စ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","အပရံ ယီၑုး သပ္တာဟပြထမဒိနေ ပြတျူၐေ ၑ္မၑာနာဒုတ္ထာယ ယသျား သပ္တဘူတာသ္တျာဇိတာသ္တသျဲ မဂ္ဒလီနီမရိယမေ ပြထမံ ဒရ္ၑနံ ဒဒေါ်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","တတး သာ ဂတွာ ၑောကရောဒနကၖဒ္ဘျော'နုဂတလောကေဘျသ္တာံ ဝါရ္တ္တာံ ကထယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","ကိန္တု ယီၑုး ပုနရ္ဇီဝန် တသျဲ ဒရ္ၑနံ ဒတ္တဝါနိတိ ၑြုတွာ တေ န ပြတျယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ပၑ္စာတ် တေၐာံ ဒွါယော ရ္ဂြာမယာနကာလေ ယီၑုရနျဝေၑံ ဓၖတွာ တာဘျာံ ဒရ္ၑန ဒဒေါ်! ");
INSERT INTO sanbur_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","တာဝပိ ဂတွာနျၑိၐျေဘျသ္တာံ ကထာံ ကထယာဉ္စကြတုး ကိန္တု တယေား ကထာမပိ တေ န ပြတျယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ၑေၐတ ဧကာဒၑၑိၐျေၐု ဘောဇနောပဝိၐ္ဋေၐု ယီၑုသ္တေဘျော ဒရ္ၑနံ ဒဒေါ် တထောတ္ထာနာတ် ပရံ တဒ္ဒရ္ၑနပြာပ္တလောကာနာံ ကထာယာမဝိၑွာသကရဏာတ် တေၐာမဝိၑွာသမနးကာဌိနျာဘျာံ ဟေတုဘျာံ သ တာံသ္တရ္ဇိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","အထ တာနာစချော် ယူယံ သရွွဇဂဒ် ဂတွာ သရွွဇနာန် ပြတိ သုသံဝါဒံ ပြစာရယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","တတြ ယး ကၑ္စိဒ် ဝိၑွသျ မဇ္ဇိတော ဘဝေတ် သ ပရိတြာသျတေ ကိန္တု ယော န ဝိၑွသိၐျတိ သ ဒဏ္ဍယိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","ကိဉ္စ ယေ ပြတျေၐျန္တိ တဲရီဒၖဂ် အာၑ္စရျျံ ကရ္မ္မ ပြကာၑယိၐျတေ တေ မန္နာမ္နာ ဘူတာန် တျာဇယိၐျန္တိ ဘာၐာ အနျာၑ္စ ဝဒိၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","အပရံ တဲး သရ္ပေၐု ဓၖတေၐု ပြာဏနာၑကဝသ္တုနိ ပီတေ စ တေၐာံ ကာပိ က္ၐတိ ရ္န ဘဝိၐျတိ; ရောဂိဏာံ ဂါတြေၐု ကရာရ္ပိတေ တေ'ရောဂါ ဘဝိၐျန္တိ စ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","အထ ပြဘုသ္တာနိတျာဒိၑျ သွရ္ဂံ နီတး သန် ပရမေၑွရသျ ဒက္ၐိဏ ဥပဝိဝေၑ၊ ");
INSERT INTO sanbur_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","တတသ္တေ ပြသ္ထာယ သရွွတြ သုသံဝါဒီယကထာံ ပြစာရယိတုမာရေဘိရေ ပြဘုသ္တု တေၐာံ သဟာယး သန် ပြကာၑိတာၑ္စရျျကြိယာဘိသ္တာံ ကထာံ ပြမာဏဝတီံ စကာရ၊ ဣတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","ပြထမတော ယေ သာက္ၐိဏော ဝါကျပြစာရကာၑ္စာသန် တေ'သ္မာကံ မဓျေ ယဒျတ် သပြမာဏံ ဝါကျမရ္ပယန္တိ သ္မ ");
INSERT INTO sanbur_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","တဒနုသာရတော'နျေပိ ဗဟဝသ္တဒွၖတ္တာန္တံ ရစယိတုံ ပြဝၖတ္တား၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","အတဧဝ ဟေ မဟာမဟိမထိယဖိလ် တွံ ယာ ယား ကထာ အၑိက္ၐျထာသ္တာသာံ ဒၖဎပြမာဏာနိ ယထာ ပြာပ္နောၐိ ");
INSERT INTO sanbur_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","တဒရ္ထံ ပြထမမာရဘျ တာနိ သရွွာဏိ ဇ္ဉာတွာဟမပိ အနုကြမာတ် သရွွဝၖတ္တာန္တာန် တုဘျံ လေခိတုံ မတိမကာရ္ၐမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ယိဟူဒါဒေၑီယဟေရောဒ္နါမကေ ရာဇတွံ ကုရွွတိ အဗီယယာဇကသျ ပရျျာယာဓိကာရီ သိခရိယနာမက ဧကော ယာဇကော ဟာရောဏဝံၑောဒ္ဘဝါ ဣလီၑေဝါချာ ");
INSERT INTO sanbur_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","တသျ ဇာယာ ဒွါဝိမော် နိရ္ဒောၐော် ပြဘေား သရွွာဇ္ဉာ ဝျဝသ္ထာၑ္စ သံမနျ ဤၑွရဒၖၐ္ဋော် ဓာရ္မ္မိကာဝါသ္တာမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","တယေား သန္တာန ဧကောပိ နာသီတ်, ယတ ဣလီၑေဝါ ဗန္ဓျာ တော် ဒွါဝေဝ ဝၖဒ္ဓါဝဘဝတာမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","ယဒါ သွပရျျာနုကြမေဏ သိခရိယ ဤၑွာသျ သမက္ၐံ ယာဇကီယံ ကရ္မ္မ ကရောတိ ");
INSERT INTO sanbur_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","တဒါ ယဇ္ဉသျ ဒိနပရိပါယျာ ပရမေၑွရသျ မန္ဒိရေ ပြဝေၑကာလေ ဓူပဇွာလနံ ကရ္မ္မ တသျ ကရဏီယမာသီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","တဒ္ဓူပဇွာလနကာလေ လောကနိဝဟေ ပြာရ္ထနာံ ကရ္တုံ ဗဟိသ္တိၐ္ဌတိ ");
INSERT INTO sanbur_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","သတိ သိခရိယော ယသျာံ ဝေဒျာံ ဓူပံ ဇွာလယတိ တဒ္ဒက္ၐိဏပါရ္ၑွေ ပရမေၑွရသျ ဒူတ ဧက ဥပသ္ထိတော ဒရ္ၑနံ ဒဒေါ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","တံ ဒၖၐ္ဋွာ သိခရိယ ဥဒွိဝိဇေ ၑၑင်္ကေ စ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","တဒါ သ ဒူတသ္တံ ဗဘာၐေ ဟေ သိခရိယ မာ ဘဲသ္တဝ ပြာရ္ထနာ ဂြာဟျာ ဇာတာ တဝ ဘာရျျာ ဣလီၑေဝါ ပုတြံ ပြသောၐျတေ တသျ နာမ ယောेဟန် ဣတိ ကရိၐျသိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ကိဉ္စ တွံ သာနန္ဒး သဟရ္ၐၑ္စ ဘဝိၐျသိ တသျ ဇန္မနိ ဗဟဝ အာနန္ဒိၐျန္တိ စ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ယတော ဟေတေား သ ပရမေၑွရသျ ဂေါစရေ မဟာန် ဘဝိၐျတိ တထာ ဒြာက္ၐာရသံ သုရာံ ဝါ ကိမပိ န ပါသျတိ, အပရံ ဇန္မာရဘျ ပဝိတြေဏာတ္မနာ ပရိပူရ္ဏး ");
INSERT INTO sanbur_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","သန် ဣသြာယေလွံၑီယာန် အနေကာန် ပြဘေား ပရမေၑွရသျ မာရ္ဂမာနေၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","သန္တာနာန် ပြတိ ပိတၖဏာံ မနာံသိ ဓရ္မ္မဇ္ဉာနံ ပြတျနာဇ္ဉာဂြာဟိဏၑ္စ ပရာဝရ္တ္တယိတုံ, ပြဘေား ပရမေၑွရသျ သေဝါရ္ထမ် ဧကာံ သဇ္ဇိတဇာတိံ ဝိဓာတုဉ္စ သ ဧလိယရူပါတ္မၑက္တိပြာပ္တသ္တသျာဂြေ ဂမိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","တဒါ သိခရိယော ဒူတမဝါဒီတ် ကထမေတဒ် ဝေတ္သျာမိ? ယတောဟံ ဝၖဒ္ဓေါ မမ ဘာရျျာ စ ဝၖဒ္ဓါ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","တတော ဒူတး ပြတျုဝါစ ပၑျေၑွရသျ သာက္ၐာဒွရ္တ္တီ ဇိဗြာယေလ္နာမာ ဒူတောဟံ တွယာ သဟ ကထာံ ဂဒိတုံ တုဘျမိမာံ ၑုဘဝါရ္တ္တာံ ဒါတုဉ္စ ပြေၐိတး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ကိန္တု မဒီယံ ဝါကျံ ကာလေ ဖလိၐျတိ တတ် တွယာ န ပြတီတမ် အတး ကာရဏာဒ် ယာဝဒေဝ တာနိ န သေတ္သျန္တိ တာဝတ် တွံ ဝက္တုံမၑက္တော မူကော ဘဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","တဒါနီံ ယေ ယေ လောကား သိခရိယမပဲက္ၐန္တ တေ မဓျေမန္ဒိရံ တသျ ဗဟုဝိလမ္ဗာဒ် အာၑ္စရျျံ မေနိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","သ ဗဟိရာဂတော ယဒါ ကိမပိ ဝါကျံ ဝက္တုမၑက္တး သင်္ကေတံ ကၖတွာ နိးၑဗ္ဒသ္တသျော် တဒါ မဓျေမန္ဒိရံ ကသျစိဒ် ဒရ္ၑနံ တေန ပြာပ္တမ် ဣတိ သရွွေ ဗုဗုဓိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","အနန္တရံ တသျ သေဝနပရျျာယေ သမ္ပူရ္ဏေ သတိ သ နိဇဂေဟံ ဇဂါမ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","ကတိပယဒိနေၐု ဂတေၐု တသျ ဘာရျျာ ဣလီၑေဝါ ဂရ္ဗ္ဘဝတီ ဗဘူဝ ");
INSERT INTO sanbur_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ပၑ္စာတ် သာ ပဉ္စမာသာန် သံဂေါပျာကထယတ် လောကာနာံ သမက္ၐံ မမာပမာနံ ခဏ္ဍယိတုံ ပရမေၑွရော မယိ ဒၖၐ္ဋိံ ပါတယိတွာ ကရ္မ္မေဒၖၑံ ကၖတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","အပရဉ္စ တသျာ ဂရ္ဗ္ဘသျ ၐၐ္ဌေ မာသေ ဇာတေ ဂါလီလ္ပြဒေၑီယနာသရတ္ပုရေ ");
INSERT INTO sanbur_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ဒါယူဒေါ ဝံၑီယာယ ယူၐဖ္နာမ္နေ ပုရုၐာယ ယာ မရိယမ္နာမကုမာရီ ဝါဂ္ဒတ္တာသီတ် တသျား သမီပံ ဇိဗြာယေလ် ဒူတ ဤၑွရေဏ ပြဟိတး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","သ ဂတွာ ဇဂါဒ ဟေ ဤၑွရာနုဂၖဟီတကနျေ တဝ ၑုဘံ ဘူယာတ် ပြဘုး ပရမေၑွရသ္တဝ သဟာယောသ္တိ နာရီဏာံ မဓျေ တွမေဝ ဓနျာ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","တဒါနီံ သာ တံ ဒၖၐ္ဋွာ တသျ ဝါကျတ ဥဒွိဇျ ကီဒၖၑံ ဘာၐဏမိဒမ် ဣတိ မနသာ စိန္တယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","တတော ဒူတော'ဝဒတ် ဟေ မရိယမ် ဘယံ မာကာရ္ၐီး, တွယိ ပရမေၑွရသျာနုဂြဟောသ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ပၑျ တွံ ဂရ္ဗ္ဘံ ဓၖတွာ ပုတြံ ပြသောၐျသေ တသျ နာမ ယီၑုရိတိ ကရိၐျသိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","သ မဟာန် ဘဝိၐျတိ တထာ သရွွေဘျး ၑြေၐ္ဌသျ ပုတြ ဣတိ ချာသျတိ; အပရံ ပြဘုး ပရမေၑွရသ္တသျ ပိတုရ္ဒာယူဒး သိံဟာသနံ တသ္မဲ ဒါသျတိ; ");
INSERT INTO sanbur_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","တထာ သ ယာကူဗော ဝံၑောပရိ သရွွဒါ ရာဇတွံ ကရိၐျတိ, တသျ ရာဇတွသျာန္တော န ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","တဒါ မရိယမ် တံ ဒူတံ ဗဘာၐေ နာဟံ ပုရုၐသင်္ဂံ ကရောမိ တရှိ ကထမေတတ် သမ္ဘဝိၐျတိ? ");
INSERT INTO sanbur_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","တတော ဒူတော'ကထယတ် ပဝိတြ အာတ္မာ တွာမာၑြာယိၐျတိ တထာ သရွွၑြေၐ္ဌသျ ၑက္တိသ္တဝေါပရိ ဆာယာံ ကရိၐျတိ တတော ဟေတောသ္တဝ ဂရ္ဗ္ဘာဒ် ယး ပဝိတြဗာလကော ဇနိၐျတေ သ ဤၑွရပုတြ ဣတိ ချာတိံ ပြာပ္သျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","အပရဉ္စ ပၑျ တဝ ဇ္ဉာတိရိလီၑေဝါ ယာံ သရွွေ ဗန္ဓျာမဝဒန် ဣဒါနီံ သာ ဝါရ္ဒ္ဓကျေ သန္တာနမေကံ ဂရ္ဗ္ဘေ'ဓာရယတ် တသျ ၐၐ္ဌမာသောဘူတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","ကိမပိ ကရ္မ္မ နာသာဓျမ် ဤၑွရသျ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","တဒါ မရိယမ် ဇဂါဒ, ပၑျ ပြဘေရဟံ ဒါသီ မဟျံ တဝ ဝါကျာနုသာရေဏ သရွွမေတဒ် ဃဋတာမ်; အနနတရံ ဒူတသ္တသျား သမီပါတ် ပြတသ္ထေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","အထ ကတိပယဒိနာတ် ပရံ မရိယမ် တသ္မာတ် ပရွွတမယပြဒေၑီယယိဟူဒါယာ နဂရမေကံ ၑီဃြံ ဂတွာ ");
INSERT INTO sanbur_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","သိခရိယယာဇကသျ ဂၖဟံ ပြဝိၑျ တသျ ဇာယာမ် ဣလီၑေဝါံ သမ္ဗောဓျာဝဒတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","တတော မရိယမး သမ္ဗောဓနဝါကျေ ဣလီၑေဝါယား ကရ္ဏယေား ပြဝိၐ္ဋမာတြေ သတိ တသျာ ဂရ္ဗ္ဘသ္ထဗာလကော နနရ္တ္တ၊ တတ ဣလီၑေဝါ ပဝိတြေဏာတ္မနာ ပရိပူရ္ဏာ သတီ ");
INSERT INTO sanbur_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ပြောစ္စဲရ္ဂဒိတုမာရေဘေ, ယောၐိတာံ မဓျေ တွမေဝ ဓနျာ, တဝ ဂရ္ဗ္ဘသ္ထး ၑိၑုၑ္စ ဓနျး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","တွံ ပြဘောရ္မာတာ, မမ နိဝေၑနေ တွယာ စရဏာဝရ္ပိတော်, မမာဒျ သော်ဘာဂျမေတတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","ပၑျ တဝ ဝါကျေ မမ ကရ္ဏယေား ပြဝိၐ္ဋမာတြေ သတိ မမောဒရသ္ထး ၑိၑုရာနန္ဒာန် နနရ္တ္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","ယာ သ္တြီ ဝျၑွသီတ် သာ ဓနျာ, ယတော ဟေတောသ္တာံ ပြတိ ပရမေၑွရောက္တံ ဝါကျံ သရွွံ သိဒ္ဓံ ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","တဒါနီံ မရိယမ် ဇဂါဒ၊ ဓနျဝါဒံ ပရေၑသျ ကရောတိ မာမကံ မနး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","မမာတ္မာ တာရကေၑေ စ သမုလ္လာသံ ပြဂစ္ဆတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","အကရောတ် သ ပြဘု ရ္ဒုၐ္ဋိံ သွဒါသျာ ဒုရ္ဂတိံ ပြတိ၊ ပၑျာဒျာရဘျ မာံ ဓနျာံ ဝက္ၐျန္တိ ပုရုၐား သဒါ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ယး သရွွၑက္တိမာန် ယသျ နာမာပိ စ ပဝိတြကံ၊ သ ဧဝ သုမဟတ္ကရ္မ္မ ကၖတဝါန် မန္နိမိတ္တကံ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ယေ ဗိဘျတိ ဇနာသ္တသ္မာတ် တေၐာံ သန္တာနပံက္တိၐု၊ အနုကမ္ပာ တဒီယာ စ သရွွဒဲဝ သုတိၐ္ဌတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","သွဗာဟုဗလတသ္တေန ပြာကာၑျတ ပရာကြမး၊ မနးကုမန္တြဏာသာရ္ဒ္ဓံ ဝိကီရျျန္တေ'ဘိမာနိနး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","သိံဟာသနဂတာလ္လောကာန် ဗလိနၑ္စာဝရောဟျ သး၊ ပဒေၐူစ္စေၐု လောကာံသ္တု က္ၐုဒြာန် သံသ္ထာပယတျပိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","က္ၐုဓိတာန် မာနဝါန် ဒြဝျဲရုတ္တမဲး ပရိတရ္ပျ သး၊ သကလာန် ဓနိနော လောကာန် ဝိသၖဇေဒ် ရိက္တဟသ္တကာန်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ဣဗြာဟီမိ စ တဒွံၑေ ယာ ဒယာသ္တိ သဒဲဝ တာံ၊ သ္မၖတွာ ပုရာ ပိတၖဏာံ နော ယထာ သာက္ၐာတ် ပြတိၑြုတံ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ဣသြာယေလ္သေဝကသ္တေန တထောပကြိယတေ သွယံ။ ");
INSERT INTO sanbur_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","အနန္တရံ မရိယမ် ပြာယေဏ မာသတြယမ် ဣလီၑေဝယာ သဟောၐိတွာ ဝျာဃုယျ နိဇနိဝေၑနံ ယယော်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","တဒနန္တရမ် ဣလီၑေဝါယား ပြသဝကာလ ဥပသ္ထိတေ သတိ သာ ပုတြံ ပြာသောၐ္ဋ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","တတး ပရမေၑွရသ္တသျာံ မဟာနုဂြဟံ ကၖတဝါန် ဧတတ် ၑြုတွာ သမီပဝါသိနး ကုဋုမ္ဗာၑ္စာဂတျ တယာ သဟ မုမုဒိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","တထာၐ္ဋမေ ဒိနေ တေ ဗာလကသျ တွစံ ဆေတ္တုမ် ဧတျ တသျ ပိတၖနာမာနုရူပံ တန္နာမ သိခရိယ ဣတိ ကရ္တ္တုမီၐုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ကိန္တု တသျ မာတာကထယတ် တန္န, နာမာသျ ယောဟန် ဣတိ ကရ္တ္တဝျမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","တဒါ တေ ဝျာဟရန် တဝ ဝံၑမဓျေ နာမေဒၖၑံ ကသျာပိ နာသ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","တတး ပရံ တသျ ပိတရံ သိခရိယံ ပြတိ သင်္ကေတျ ပပြစ္ဆုး ၑိၑေား ကိံ နာမ ကာရိၐျတေ? ");
INSERT INTO sanbur_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","တတး သ ဖလကမေကံ ယာစိတွာ လိလေခ တသျ နာမ ယောဟန် ဘဝိၐျတိ၊ တသ္မာတ် သရွွေ အာၑ္စရျျံ မေနိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","တတ္က္ၐဏံ သိခရိယသျ ဇိဟွာဇာဍျေ'ပဂတေ သ မုခံ ဝျာဒါယ သ္ပၐ္ဋဝရ္ဏမုစ္စာရျျ ဤၑွရသျ ဂုဏာနုဝါဒံ စကာရ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","တသ္မာစ္စတုရ္ဒိက္သ္ထား သမီပဝါသိလောကာ ဘီတာ ဧဝမေတား သရွွား ကထာ ယိဟူဒါယား ပရွွတမယပြဒေၑသျ သရွွတြ ပြစာရိတား၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","တသ္မာတ် ၑြောတာရော မနးသု သ္ထာပယိတွာ ကထယာမ္ဗဘူဝုး ကီဒၖၑောယံ ဗာလော ဘဝိၐျတိ? အထ ပရမေၑွရသ္တသျ သဟာယောဘူတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","တဒါ ယောဟနး ပိတာ သိခရိယး ပဝိတြေဏာတ္မနာ ပရိပူရ္ဏး သန် ဧတာဒၖၑံ ဘဝိၐျဒွါကျံ ကထယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","ဣသြာယေလး ပြဘု ရျသ္တု သ ဓနျး ပရမေၑွရး၊ အနုဂၖဟျ နိဇာလ္လောကာန် သ ဧဝ ပရိမောစယေတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ဝိပက္ၐဇနဟသ္တေဘျော ယထာ မောစျာမဟေ ဝယံ၊ ယာဝဇ္ဇီဝဉ္စ ဓရ္မ္မေဏ သာရလျေန စ နိရ္ဘယား၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","သေဝါမဟဲ တမေဝဲကမ် ဧတတ္ကာရဏမေဝ စ၊ သွကီယံ သုပဝိတြဉ္စ သံသ္မၖတျ နိယမံ သဒါ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ကၖပယာ ပုရုၐာန် ပူရွွာန် နိကၐာရ္ထာတ္တု နး ပိတုး၊ ဣဗြာဟီမး သမီပေ ယံ ၑပထံ ကၖတဝါန် ပုရာ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","တမေဝ သဖလံ ကရ္တ္တံ တထာ ၑတြုဂဏသျ စ၊ ၒृတီယာကာရိဏၑ္စဲဝ ကရေဘျော ရက္ၐဏာယ နး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","သၖၐ္ဋေး ပြထမတး သွီယဲး ပဝိတြဲ ရ္ဘာဝိဝါဒိဘိး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ယထောက္တဝါန် တထာ သွသျ ဒါယူဒး သေဝကသျ တု၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ဝံၑေ တြာတာရမေကံ သ သမုတ္ပာဒိတဝါန် သွယမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","အတော ဟေ ဗာလက တွန္တု သရွွေဘျး ၑြေၐ္ဌ ဧဝ ယး၊ တသျဲဝ ဘာဝိဝါဒီတိ ပြဝိချာတော ဘဝိၐျသိ၊ အသ္မာကံ စရဏာန် က္ၐေမေ မာရ္ဂေ စာလယိတုံ သဒါ၊ ဧဝံ ဓွာန္တေ'ရ္ထတော မၖတျောၑ္ဆာယာယာံ ယေ တု မာနဝါး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ဥပဝိၐ္ဋာသ္တု တာနေဝ ပြကာၑယိတုမေဝ ဟိ၊ ကၖတွာ မဟာနုကမ္ပာံ ဟိ ယာမေဝ ပရမေၑွရး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ဦရ္ဒွွာတ် သူရျျမုဒါယျဲဝါသ္မဘျံ ပြာဒါတ္တု ဒရ္ၑနံ၊ တယာနုကမ္ပယာ သွသျ လောကာနာံ ပါပမောစနေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ပရိတြာဏသျ တေဘျော ဟိ ဇ္ဉာနဝိၑြာဏနာယ စ၊ ပြဘော ရ္မာရ္ဂံ ပရိၐ္ကရ္တ္တုံ တသျာဂြာယီ ဘဝိၐျသိ။ ");
INSERT INTO sanbur_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","အထ ဗာလကး ၑရီရေဏ ဗုဒ္ဓျာ စ ဝရ္ဒ္ဓိတုမာရေဘေ; အပရဉ္စ သ ဣသြာယေလော ဝံၑီယလောကာနာံ သမီပေ ယာဝန္န ပြကဋီဘူတသ္တာသ္တာဝတ် ပြာန္တရေ နျဝသတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","အပရဉ္စ တသ္မိန် ကာလေ ရာဇျသျ သရွွေၐာံ လောကာနာံ နာမာနိ လေခယိတုမ် အဂသ္တကဲသရ အာဇ္ဉာပယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","တဒနုသာရေဏ ကုရီဏိယနာမနိ သုရိယာဒေၑသျ ၑာသကေ သတိ နာမလေခနံ ပြာရေဘေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","အတော ဟေတော ရ္နာမ လေခိတုံ သရွွေ ဇနား သွီယံ သွီယံ နဂရံ ဇဂ္မုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","တဒါနီံ ယူၐဖ် နာမ လေခိတုံ ဝါဂ္ဒတ္တယာ သွဘာရျျယာ ဂရ္ဗ္ဘဝတျာ မရိယမာ သဟ သွယံ ဒါယူဒး သဇာတိဝံၑ ဣတိ ကာရဏာဒ် ဂါလီလ္ပြဒေၑသျ နာသရတ္နဂရာဒ္ ");
INSERT INTO sanbur_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ယိဟူဒါပြဒေၑသျ ဗဲတ္လေဟမာချံ ဒါယူဒ္နဂရံ ဇဂါမ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","အနျစ္စ တတြ သ္ထာနေ တယောသ္တိၐ္ဌတေား သတော ရ္မရိယမး ပြသူတိကာလ ဥပသ္ထိတေ ");
INSERT INTO sanbur_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","သာ တံ ပြထမသုတံ ပြာသောၐ္ဋ ကိန္တု တသ္မိန် ဝါသဂၖဟေ သ္ထာနာဘာဝါဒ် ဗာလကံ ဝသ္တြေဏ ဝေၐ္ဋယိတွာ ဂေါၑာလာယာံ သ္ထာပယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","အနန္တရံ ယေ ကိယန္တော မေၐပါလကား သွမေၐဝြဇရက္ၐာယဲ တတ္ပြဒေၑေ သ္ထိတွာ ရဇနျာံ ပြာန္တရေ ပြဟရိဏး ကရ္မ္မ ကုရွွန္တိ, ");
INSERT INTO sanbur_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","တေၐာံ သမီပံ ပရမေၑွရသျ ဒူတ အာဂတျောပတသ္ထော်; တဒါ စတုၐ္ပာရ္ၑွေ ပရမေၑွရသျ တေဇသး ပြကာၑိတတွာတ် တေ'တိၑၑင်္ကိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","တဒါ သ ဒူတ ဥဝါစ မာ ဘဲၐ္ဋ ပၑျတာဒျ ဒါယူဒး ပုရေ ယုၐ္မန္နိမိတ္တံ တြာတာ ပြဘုး ခြီၐ္ဋော'ဇနိၐ္ဋ, ");
INSERT INTO sanbur_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","သရွွေၐာံ လောကာနာံ မဟာနန္ဒဇနကမ် ဣမံ မင်္ဂလဝၖတ္တာန္တံ ယုၐ္မာန် ဇ္ဉာပယာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","ယူယံ (တတ္သ္ထာနံ ဂတွာ) ဝသ္တြဝေၐ္ဋိတံ တံ ဗာလကံ ဂေါၑာလာယာံ ၑယနံ ဒြက္ၐျထ ယုၐ္မာန် ပြတီဒံ စိဟ္နံ ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ဒူတ ဣမာံ ကထာံ ကထိတဝတိ တတြာကသ္မာတ် သွရ္ဂီယား ပၖတနာ အာဂတျ ကထာမ် ဣမာံ ကထယိတွေၑွရသျ ဂုဏာနနွဝါဒိၐုး, ယထာ, ");
INSERT INTO sanbur_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","သရွွောရ္ဒွွသ္ထဲရီၑွရသျ မဟိမာ သမ္ပြကာၑျတာံ၊ ၑာန္တိရ္ဘူယာတ် ပၖထိဝျာသ္တု သန္တောၐၑ္စ နရာန် ပြတိ။ ");
INSERT INTO sanbur_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","တတး ပရံ တေၐာံ သန္နိဓေ ရ္ဒူတဂဏေ သွရ္ဂံ ဂတေ မေၐပါလကား ပရသ္ပရမ် အဝေစန် အာဂစ္ဆတ ပြဘုး ပရမေၑွရော ယာံ ဃဋနာံ ဇ္ဉာပိတဝါန် တသျာ ယာထရျံ ဇ္ဉာတုံ ဝယမဓုနာ ဗဲတ္လေဟမ္ပုရံ ယာမး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ပၑ္စာတ် တေ တူရ္ဏံ ဝြဇိတွာ မရိယမံ ယူၐဖံ ဂေါၑာလာယာံ ၑယနံ ဗာလကဉ္စ ဒဒၖၑုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ဣတ္ထံ ဒၖၐ္ဋွာ ဗာလကသျာရ္ထေ ပြောက္တာံ သရွွကထာံ တေ ပြာစာရယာဉ္စကြုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","တတော ယေ လောကာ မေၐရက္ၐကာဏာံ ဝဒနေဘျသ္တာံ ဝါရ္တ္တာံ ၑုၑြုဝုသ္တေ မဟာၑ္စရျျံ မေနိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","ကိန္တု မရိယမ် ဧတတ္သရွွဃဋနာနာံ တာတ္ပရျျံ ဝိဝိစျ မနသိ သ္ထာပယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","တတ္ပၑ္စာဒ် ဒူတဝိဇ္ဉပ္တာနုရူပံ ၑြုတွာ ဒၖၐ္ဋွာ စ မေၐပါလကာ ဤၑွရသျ ဂုဏာနုဝါဒံ ဓနျဝါဒဉ္စ ကုရွွာဏား ပရာဝၖတျ ယယုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","အထ ဗာလကသျ တွက္ဆေဒနကာလေ'ၐ္ဋမဒိဝသေ သမုပသ္ထိတေ တသျ ဂရ္ဗ္ဘသ္ထိတေး ပုရွွံ သွရ္ဂီယဒူတော ယထာဇ္ဉာပယတ် တဒနုရူပံ တေ တန္နာမဓေယံ ယီၑုရိတိ စကြိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","တတး ပရံ မူသာလိခိတဝျဝသ္ထာယာ အနုသာရေဏ မရိယမး ၑုစိတွကာလ ဥပသ္ထိတေ, ");
INSERT INTO sanbur_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","\"ပြထမဇး သရွွး ပုရုၐသန္တာနး ပရမေၑွရေ သမရ္ပျတာံ,\" ဣတိ ပရမေၑွရသျ ဝျဝသ္ထယာ ");
INSERT INTO sanbur_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ယီၑုံ ပရမေၑွရေ သမရ္ပယိတုမ် ၑာသ္တြီယဝိဓျုက္တံ ကပေါတဒွယံ ပါရာဝတၑာဝကဒွယံ ဝါ ဗလိံ ဒါတုံ တေ တံ ဂၖဟီတွာ ယိရူၑာလမမ် အာယယုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","ယိရူၑာလမ္ပုရနိဝါသီ ၑိမိယောန္နာမာ ဓာရ္မ္မိက ဧက အာသီတ် သ ဣသြာယေလး သာန္တွနာမပေက္ၐျ တသ္ထော် ကိဉ္စ ပဝိတြ အာတ္မာ တသ္မိန္နာဝိရ္ဘူတး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","အပရံ ပြဘုဏာ ပရမေၑွရေဏာဘိၐိက္တေ တြာတရိ တွယာ န ဒၖၐ္ဋေ တွံ န မရိၐျသီတိ ဝါကျံ ပဝိတြေဏ အာတ္မနာ တသ္မ ပြာကထျတ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","အပရဉ္စ ယဒါ ယီၑေား ပိတာ မာတာ စ တဒရ္ထံ ဝျဝသ္ထာနုရူပံ ကရ္မ္မ ကရ္တ္တုံ တံ မန္ဒိရမ် အာနိနျတုသ္တဒါ ");
INSERT INTO sanbur_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ၑိမိယောန် အာတ္မန အာကရ္ၐဏေန မန္ဒိရမာဂတျ တံ ကြောဍေ နိဓာယ ဤၑွရသျ ဓနျဝါဒံ ကၖတွာ ကထယာမာသ, ယထာ, ");
INSERT INTO sanbur_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","ဟေ ပြဘော တဝ ဒါသောယံ နိဇဝါကျာနုသာရတး၊ ဣဒါနီန္တု သကလျာဏော ဘဝတာ သံဝိသၖဇျတာမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ယတး သကလဒေၑသျ ဒီပ္တယေ ဒီပ္တိရူပကံ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ဣသြာယေလီယလောကသျ မဟာဂေါ်ရဝရူပကံ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ယံ တြာယကံ ဇနာနာန္တု သမ္မုခေ တွမဇီဇနး၊ သဧဝ ဝိဒျတေ'သ္မာကံ ဓြဝံ နယနနဂေါစရေ။ ");
INSERT INTO sanbur_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","တဒါနီံ တေနောက္တာ ဧတား သကလား ကထား ၑြုတွာ တသျ မာတာ ယူၐဖ် စ ဝိသ္မယံ မေနာတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","တတး ပရံ ၑိမိယောန် တေဘျ အာၑိၐံ ဒတ္တွာ တန္မာတရံ မရိယမမ် ဥဝါစ, ပၑျ ဣသြာယေလော ဝံၑမဓျေ ဗဟူနာံ ပါတနာယောတ္ထာပနာယ စ တထာ ဝိရောဓပါတြံ ဘဝိတုံ, ဗဟူနာံ ဂုပ္တမနောဂတာနာံ ပြကဋီကရဏာယ ဗာလကောယံ နိယုက္တောသ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","တသ္မာတ် တဝါပိ ပြာဏား ၑူလေန ဝျတ္သျန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","အပရဉ္စ အာၑေရသျ ဝံၑီယဖိနူယေလော ဒုဟိတာ ဟန္နာချာ အတိဇရတီ ဘဝိၐျဒွါဒိနျေကာ ယာ ဝိဝါဟာတ် ပရံ သပ္တ ဝတ္သရာန် ပတျာ သဟ နျဝသတ် တတော ဝိဓဝါ ဘူတွာ စတုရၑီတိဝရ္ၐဝယးပရျျနတံ ");
INSERT INTO sanbur_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","မန္ဒိရေ သ္ထိတွာ ပြာရ္ထနောပဝါသဲရ္ဒိဝါနိၑမ် ဤၑွရမ် အသေဝတ သာပိ သ္တြီ တသ္မိန် သမယေ မန္ဒိရမာဂတျ ");
INSERT INTO sanbur_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","ပရမေၑွရသျ ဓနျဝါဒံ စကာရ, ယိရူၑာလမ္ပုရဝါသိနော ယာဝန္တော လောကာ မုက္တိမပေက္ၐျ သ္ထိတာသ္တာန် ယီၑောရွၖတ္တာန္တံ ဇ္ဉာပယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ဣတ္ထံ ပရမေၑွရသျ ဝျဝသ္ထာနုသာရေဏ သရွွေၐု ကရ္မ္မသု ကၖတေၐု တော် ပုနၑ္စ ဂါလီလော နာသရတ္နာမကံ နိဇနဂရံ ပြတသ္ထာတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","တတ္ပၑ္စာဒ် ဗာလကး ၑရီရေဏ ဝၖဒ္ဓိမေတျ ဇ္ဉာနေန ပရိပူရ္ဏ အာတ္မနာ ၑက္တိမာံၑ္စ ဘဝိတုမာရေဘေ တထာ တသ္မိန် ဤၑွရာနုဂြဟော ဗဘူဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","တသျ ပိတာ မာတာ စ ပြတိဝရ္ၐံ နိသ္တာရောတ္သဝသမယေ ယိရူၑာလမမ် အဂစ္ဆတာမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","အပရဉ္စ ယီၑော် ဒွါဒၑဝရ္ၐဝယသ္ကေ သတိ တော် ပရွွသမယသျ ရီတျနုသာရေဏ ယိရူၑာလမံ ဂတွာ ");
INSERT INTO sanbur_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","ပါရွွဏံ သမ္ပာဒျ ပုနရပိ ဝျာဃုယျ ယာတး ကိန္တု ယီၑုရ္ဗာလကော ယိရူၑာလမိ တိၐ္ဌတိ၊ ယူၐဖ် တန္မာတာ စ တဒ် အဝိဒိတွာ ");
INSERT INTO sanbur_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","သ သင်္ဂိဘိး သဟ ဝိဒျတ ဧတစ္စ ဗုဒွွာ ဒိနဲကဂမျမာရ္ဂံ ဇဂ္မတုး၊ ကိန္တု ၑေၐေ ဇ္ဉာတိဗန္ဓူနာံ သမီပေ မၖဂယိတွာ တဒုဒ္ဒေेၑမပြာပျ ");
INSERT INTO sanbur_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","တော် ပုနရပိ ယိရူၑာလမမ် ပရာဝၖတျာဂတျ တံ မၖဂယာဉ္စကြတုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","အထ ဒိနတြယာတ် ပရံ ပဏ္ဍိတာနာံ မဓျေ တေၐာံ ကထား ၑၖဏွန် တတ္တွံ ပၖစ္ဆံၑ္စ မန္ဒိရေ သမုပဝိၐ္ဋး သ တာဘျာံ ဒၖၐ္ဋး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","တဒါ တသျ ဗုဒ္ဓျာ ပြတျုတ္တရဲၑ္စ သရွွေ ၑြောတာရော ဝိသ္မယမာပဒျန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","တာဒၖၑံ ဒၖၐ္ဋွာ တသျ ဇနကော ဇနနီ စ စမစ္စကြတုး ကိဉ္စ တသျ မာတာ တမဝဒတ်, ဟေ ပုတြ, ကထမာဝါံ ပြတီတ္ထံ သမာစရသ္တွမ်? ပၑျ တဝ ပိတာဟဉ္စ ၑောကာကုလော် သန္တော် တွာမနွိစ္ဆာဝး သ္မ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","တတး သောဝဒတ် ကုတော မာမ် အနွဲစ္ဆတံ? ပိတုရ္ဂၖဟေ မယာ သ္ထာတဝျမ် ဧတတ် ကိံ ယုဝါဘျာံ န ဇ္ဉာယတေ? ");
INSERT INTO sanbur_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","ကိန္တု တော် တသျဲတဒွါကျသျ တာတ္ပရျျံ ဗောဒ္ဓုံ နာၑက္နုတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","တတး ပရံ သ တာဘျာံ သဟ နာသရတံ ဂတွာ တယောရွၑီဘူတသ္တသ္ထော် ကိန္တု သရွွာ ဧတား ကထာသ္တသျ မာတာ မနသိ သ္ထာပယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","အထ ယီၑော ရ္ဗုဒ္ဓိး ၑရီရဉ္စ တထာ တသ္မိန် ဤၑွရသျ မာနဝါနာဉ္စာနုဂြဟော ဝရ္ဒ္ဓိတုမ် အာရေဘေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","အနန္တရံ တိဗိရိယကဲသရသျ ရာဇတွသျ ပဉ္စဒၑေ ဝတ္သရေ သတိ ယဒါ ပန္တီယပီလာတော ယိဟူဒါဒေၑာဓိပတိ ရှေရောဒ် တု ဂါလီလ္ပြဒေၑသျ ရာဇာ ဖိလိပနာမာ တသျ ဘြာတာ တု ယိတူရိယာယာသ္တြာခေါနီတိယာပြဒေၑသျ စ ရာဇာသီတ် လုၐာနီယနာမာ အဝိလီနီဒေၑသျ ရာဇာသီတ္ ");
INSERT INTO sanbur_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ဟာနန် ကိယဖာၑ္စေမော် ပြဓာနယာဇာကာဝါသ္တာံ တဒါနီံ သိခရိယသျ ပုတြာယ ယောဟနေ မဓျေပြာန္တရမ် ဤၑွရသျ ဝါကျေ ပြကာၑိတေ သတိ ");
INSERT INTO sanbur_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","သ ယရ္ဒ္ဒန ဥဘယတဋပြဒေၑာန် သမေတျ ပါပမောစနာရ္ထံ မနးပရာဝရ္တ္တနသျ စိဟ္နရူပံ ယန္မဇ္ဇနံ တဒီယား ကထား သရွွတြ ပြစာရယိတုမာရေဘေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ယိၑယိယဘဝိၐျဒွက္တၖဂြန္ထေ ယာဒၖၑီ လိပိရာသ္တေ ယထာ, ပရမေၑသျ ပန္ထာနံ ပရိၐ္ကုရုတ သရွွတး၊ တသျ ရာဇပထဉ္စဲဝ သမာနံ ကုရုတာဓုနာ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ကာရိၐျန္တေ သမုစ္ဆြာယား သကလာ နိမ္နဘူမယး၊ ကာရိၐျန္တေ နတား သရွွေ ပရွွတာၑ္စောပပရွွတား၊ ကာရိၐျန္တေ စ ယာ ဝကြာသ္တား သရွွား သရလာ ဘုဝး၊ ကာရိၐျန္တေ သမာနာသ္တာ ယာ ဥစ္စနီစဘူမယး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ဤၑွရေဏ ကၖတံ တြာဏံ ဒြက္ၐျန္တိ သရွွမာနဝါး၊ ဣတျေတတ် ပြာန္တရေ ဝါကျံ ဝဒတး ကသျစိဒ် ရဝး။ ");
INSERT INTO sanbur_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ယေ ယေ လောကာ မဇ္ဇနာရ္ထံ ဗဟိရာယယုသ္တာန် သောဝဒတ် ရေ ရေ သရ္ပဝံၑာ အာဂါမိနး ကောပါတ် ပလာယိတုံ ယုၐ္မာန် ကၑ္စေတယာမာသ? ");
INSERT INTO sanbur_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","တသ္မာဒ် ဣဗြာဟီမ် အသ္မာကံ ပိတာ ကထာမီဒၖၑီံ မနောဘိ ရ္န ကထယိတွာ ယူယံ မနးပရိဝရ္တ္တနယောဂျံ ဖလံ ဖလတ; ယုၐ္မာနဟံ ယထာရ္ထံ ဝဒါမိ ပါၐာဏေဘျ ဧတေဘျ ဤၑွရ ဣဗြာဟီမး သန္တာနောတ္ပာဒနေ သမရ္ထး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","အပရဉ္စ တရုမူလေ'ဓုနာပိ ပရၑုး သံလဂ္နောသ္တိ ယသ္တရုရုတ္တမံ ဖလံ န ဖလတိ သ ဆိဒျတေ'ဂ္နော် နိက္ၐိပျတေ စ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","တဒါနီံ လောကာသ္တံ ပပြစ္ဆုသ္တရှိ ကိံ ကရ္တ္တဝျမသ္မာဘိး? ");
INSERT INTO sanbur_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","တတး သောဝါဒီတ် ယသျ ဒွေ ဝသနေ ဝိဒျေတေ သ ဝသ္တြဟီနာယဲကံ ဝိတရတု ကိံဉ္စ ယသျ ခါဒျဒြဝျံ ဝိဒျတေ သောပိ တထဲဝ ကရောတု၊ ");
INSERT INTO sanbur_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","တတး ပရံ ကရသဉ္စာယိနော မဇ္ဇနာရ္ထမ် အာဂတျ ပပြစ္ဆုး ဟေ ဂုရော ကိံ ကရ္တ္တဝျမသ္မာဘိး? ");
INSERT INTO sanbur_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","တတး သောကထယတ် နိရူပိတာဒဓိကံ န ဂၖဟ္လိတ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","အနန္တရံ သေနာဂဏ ဧတျ ပပြစ္ဆ ကိမသ္မာဘိ ရွာ ကရ္တ္တဝျမ်? တတး သောဘိဒဓေ ကသျ ကာမပိ ဟာနိံ မာ ကာရ္ၐ္ဋ တထာ မၖၐာပဝါဒံ မာ ကုရုတ နိဇဝေတနေန စ သန္တုၐျ တိၐ္ဌတ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","အပရဉ္စ လောကာ အပေက္ၐယာ သ္ထိတွာ သရွွေပီတိ မနောဘိ ရွိတရ္ကယာဉ္စကြုး, ယောဟနယမ် အဘိၐိက္တသ္တြာတာ န ဝေတိ? ");
INSERT INTO sanbur_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","တဒါ ယောဟန် သရွွာန် ဝျာဇဟာရ, ဇလေ'ဟံ ယုၐ္မာန် မဇ္ဇယာမိ သတျံ ကိန္တု ယသျ ပါဒုကာဗန္ဓနံ မောစယိတုမပိ န ယောဂျောသ္မိ တာဒၖၑ ဧကော မတ္တော ဂုရုတရး ပုမာန် ဧတိ, သ ယုၐ္မာန် ဝဟ္နိရူပေ ပဝိတြ အာတ္မနိ မဇ္ဇယိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","အပရဉ္စ တသျ ဟသ္တေ ၑူရ္ပ အာသ္တေ သ သွၑသျာနိ ၑုဒ္ဓရူပံ ပြသ္ဖောဋျ ဂေါဓူမာန် သရွွာန် ဘာဏ္ဍာဂါရေ သံဂြဟီၐျတိ ကိန္တု ဗူၐာဏိ သရွွာဏျနိရွွာဏဝဟ္နိနာ ဒါဟယိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","ယောဟန် ဥပဒေၑေနေတ္ထံ နာနာကထာ လောကာနာံ သမက္ၐံ ပြစာရယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","အပရဉ္စ ဟေရောဒ် ရာဇာ ဖိလိပ္နာမ္နး သဟောဒရသျ ဘာရျျာံ ဟေရောဒိယာမဓိ တထာနျာနိ ယာနိ ယာနိ ကုကရ္မ္မာဏိ ကၖတဝါန် တဒဓိ စ ");
INSERT INTO sanbur_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ယောဟနာ တိရသ္ကၖတော ဘူတွာ ကာရာဂါရေ တသျ ဗန္ဓနာဒ် အပရမပိ ကုကရ္မ္မ စကာရ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ဣတး ပူရွွံ ယသ္မိန် သမယေ သရွွေ ယောဟနာ မဇ္ဇိတာသ္တဒါနီံ ယီၑုရပျာဂတျ မဇ္ဇိတး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","တဒနန္တရံ တေန ပြာရ္ထိတေ မေဃဒွါရံ မုက္တံ တသ္မာစ္စ ပဝိတြ အာတ္မာ မူရ္တ္တိမာန် ဘူတွာ ကပေါတဝတ် တဒုပရျျဝရုရောဟ; တဒါ တွံ မမ ပြိယး ပုတြသ္တွယိ မမ ပရမး သန္တောၐ ဣတျာကာၑဝါဏီ ဗဘူဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","တဒါနီံ ယီၑုး ပြာယေဏ တြိံၑဒွရ္ၐဝယသ္က အာသီတ်၊ လော်ကိကဇ္ဉာနေ တု သ ယူၐဖး ပုတြး, ");
INSERT INTO sanbur_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ယူၐဖ် ဧလေး ပုတြး, ဧလိရ္မတ္တတး ပုတြး, မတ္တတ် လေဝေး ပုတြး, လေဝိ ရ္မလ္ကေး ပုတြး, မလ္ကိရျာန္နသျ ပုတြး; ယာန္နော ယူၐဖး ပုတြး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ယူၐဖ် မတ္တထိယသျ ပုတြး, မတ္တထိယ အာမောသး ပုတြး, အာမောသ် နဟူမး ပုတြး, နဟူမ် ဣၐ္လေး ပုတြး ဣၐ္လိရ္နဂေး ပုတြး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","နဂိရ္မာဋး ပုတြး, မာဋ် မတ္တထိယသျ ပုတြး, မတ္တထိယး ၑိမိယေး ပုတြး, ၑိမိယိရျူၐဖး ပုတြး, ယူၐဖ် ယိဟူဒါး ပုတြး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ယိဟူဒါ ယောဟာနား ပုတြး, ယောဟာနာ ရီၐား ပုတြး, ရီၐား သိရုဗ္ဗာဗိလး ပုတြး, သိရုဗ္ဗာဗိလ် ၑလ္တီယေလး ပုတြး, ၑလ္တီယေလ် နေရေး ပုတြး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","နေရိရ္မလ္ကေး ပုတြး, မလ္ကိး အဒျး ပုတြး, အဒ္ဒီ ကောၐမး ပုတြး, ကောၐမ် ဣလ္မောဒဒး ပုတြး, ဣလ္မောဒဒ် ဧရး ပုတြး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ဧရ် ယောၑေး ပုတြး, ယောၑိး ဣလီယေၐရး ပုတြး, ဣလီယေၐရ် ယောရီမး ပုတြး, ယောရီမ် မတ္တတး ပုတြး, မတ္တတ လေဝေး ပုတြး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","လေဝိး ၑိမိယောနး ပုတြး, ၑိမိယောန် ယိဟူဒါး ပုတြး, ယိဟူဒါ ယူၐုဖး ပုတြး, ယူၐုဖ် ယောနနး ပုတြး, ယာနန် ဣလီယာကီမး ပုတြး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ဣလိယာကီမ္း မိလေယား ပုတြး, မိလေယာ မဲနနး ပုတြး, မဲနန် မတ္တတ္တသျ ပုတြး, မတ္တတ္တော နာထနး ပုတြး, နာထန် ဒါယူဒး ပုတြး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ဒါယူဒ် ယိၑယး ပုတြး, ယိၑယ ဩဗေဒး ပုတြ, ဩဗေဒ် ဗောယသး ပုတြး, ဗောယသ် သလ္မောနး ပုတြး, သလ္မောန် နဟၑောနး ပုတြး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","နဟၑောန် အမ္မီနာဒဗး ပုတြး, အမ္မီနာဒဗ် အရာမး ပုတြး, အရာမ် ဟိၐြောဏး ပုတြး, ဟိၐြောဏ် ပေရသး ပုတြး, ပေရသ် ယိဟူဒါး ပုတြး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ယိဟူဒါ ယာကူဗး ပုတြး, ယာကူဗ် ဣသှာကး ပုတြး, ဣသှာက် ဣဗြာဟီမး ပုတြး, ဣဗြာဟီမ် တေရဟး ပုတြး, တေရဟ် နာဟောရး ပုတြး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","နာဟောရ် သိရုဂး ပုတြး, သိရုဂ် ရိယွး ပုတြး, ရိယူး ပေလဂး ပုတြး, ပေလဂ် ဧဝရး ပုတြး, ဧဝရ် ၑေလဟး ပုတြး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ၑေလဟ် ကဲနနး ပုတြး, ကဲနန် အရ္ဖက္ၐဒး ပုတြး, အရ္ဖက္ၐဒ် ၑာမး ပုတြး, ၑာမ် နောဟး ပုတြး, နောဟော လေမကး ပုတြး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","လေမက် မိထူၑေလဟး ပုတြး, မိထူၑေလဟ် ဟနောကး ပုတြး, ဟနောက် ယေရဒး ပုတြး, ယေရဒ် မဟလလေလး ပုတြး, မဟလလေလ် ကဲနနး ပုတြး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ကဲနန် ဣနောၑး ပုတြး, ဣနောၑ် ၑေတး ပုတြး, ၑေတ် အာဒမး ပုတြ, အာဒမ် ဤၑွရသျ ပုတြး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","တတး ပရံ ယီၑုး ပဝိတြေဏာတ္မနာ ပူရ္ဏး သန် ယရ္ဒ္ဒနနဒျား ပရာဝၖတျာတ္မနာ ပြာန္တရံ နီတး သန် စတွာရိံၑဒ္ဒိနာနိ ယာဝတ် ၑဲတာနာ ပရီက္ၐိတော'ဘူတ်, ");
INSERT INTO sanbur_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ကိဉ္စ တာနိ သရွွဒိနာနိ ဘောဇနံ ဝိနာ သ္ထိတတွာတ် ကာလေ ပူရ္ဏေ သ က္ၐုဓိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","တတး ၑဲတာနာဂတျ တမဝဒတ် တွံ စေဒီၑွရသျ ပုတြသ္တရှိ ပြသ္တရာနေတာန် အာဇ္ဉယာ ပူပါန် ကုရု၊ ");
INSERT INTO sanbur_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","တဒါ ယီၑုရုဝါစ, လိပိရီဒၖၑီ ဝိဒျတေ မနုဇး ကေဝလေန ပူပေန န ဇီဝတိ ကိန္တွီၑွရသျ သရွွာဘိရာဇ္ဉာဘိ ရ္ဇီဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","တဒါ ၑဲတာန် တမုစ္စံ ပရွွတံ နီတွာ နိမိၐဲကမဓျေ ဇဂတး သရွွရာဇျာနိ ဒရ္ၑိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ပၑ္စာတ် တမဝါဒီတ် သရွွမ် ဧတဒ် ဝိဘဝံ ပြတာပဉ္စ တုဘျံ ဒါသျာမိ တန် မယိ သမရ္ပိတမာသ္တေ ယံ ပြတိ မမေစ္ဆာ ဇာယတေ တသ္မဲ ဒါတုံ ၑက္နောမိ, ");
INSERT INTO sanbur_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","တွံ စေန္မာံ ဘဇသေ တရှိ သရွွမေတတ် တဝဲဝ ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","တဒါ ယီၑုသ္တံ ပြတျုက္တဝါန် ဒူရီ ဘဝ ၑဲတာန် လိပိရာသ္တေ, နိဇံ ပြဘုံ ပရမေၑွရံ ဘဇသွ ကေဝလံ တမေဝ သေဝသွ စ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","အထ ၑဲတာန် တံ ယိရူၑာလမံ နီတွာ မန္ဒိရသျ စူဍာယာ ဥပရိ သမုပဝေၑျ ဇဂါဒ တွံ စေဒီၑွရသျ ပုတြသ္တရှိ သ္ထာနာဒိတော လမ္ဖိတွာဓး ");
INSERT INTO sanbur_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ပတ ယတော လိပိရာသ္တေ, အာဇ္ဉာပယိၐျတိ သွီယာန် ဒူတာန် သ ပရမေၑွရး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ရက္ၐိတုံ သရွွမာရ္ဂေ တွာံ တေန တွစ္စရဏေ ယထာ၊ န လဂေတ် ပြသ္တရာဃာတသ္တွာံ ဓရိၐျန္တိ တေ တထာ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","တဒါ ယီၑုနာ ပြတျုက္တမ် ဣဒမပျုက္တမသ္တိ တွံ သွပြဘုံ ပရေၑံ မာ ပရီက္ၐသွ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","ပၑ္စာတ် ၑဲတာန် သရွွပရီက္ၐာံ သမာပျ က္ၐဏာတ္တံ တျက္တွာ ယယော်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","တဒါ ယီၑုရာတ္မပြဘာဝါတ် ပုနရ္ဂာလီလ္ပြဒေၑံ ဂတသ္တဒါ တတ္သုချာတိၑ္စတုရ္ဒိၑံ ဝျာနၑေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","သ တေၐာံ ဘဇနဂၖဟေၐု ဥပဒိၑျ သရွွဲး ပြၑံသိတော ဗဘူဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","အထ သ သွပါလနသ္ထာနံ နာသရတ္ပုရမေတျ ဝိၑြာမဝါရေ သွာစာရာဒ် ဘဇနဂေဟံ ပြဝိၑျ ပဌိတုမုတ္တသ္ထော်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","တတော ယိၑယိယဘဝိၐျဒွါဒိနး ပုသ္တကေ တသျ ကရဒတ္တေ သတိ သ တတ် ပုသ္တကံ ဝိသ္တာရျျ ယတြ ဝက္ၐျမာဏာနိ ဝစနာနိ သန္တိ တတ် သ္ထာနံ ပြာပျ ပပါဌ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","အာတ္မာ တု ပရမေၑသျ မဒီယောပရိ ဝိဒျတေ၊ ဒရိဒြေၐု သုသံဝါဒံ ဝက္တုံ မာံ သောဘိၐိက္တဝါန်၊ ဘဂ္နာန္တး ကရဏာလ္လောကာန် သုသွသ္ထာန် ကရ္တ္တုမေဝ စ၊ ဗန္ဒီကၖတေၐု လောကေၐု မုက္တေ ရ္ဃောၐယိတုံ ဝစး၊ နေတြာဏိ ဒါတုမန္ဓေဘျသ္တြာတုံ ဗဒ္ဓဇနာနပိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ပရေၑာနုဂြဟေ ကာလံ ပြစာရယိတုမေဝ စ၊ သရွွဲတတ္ကရဏာရ္ထာယ မာမေဝ ပြဟိဏောတိ သး။ ");
INSERT INTO sanbur_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","တတး ပုသ္တကံ ဗဒွွာ ပရိစာရကသျ ဟသ္တေ သမရ္ပျ စာသနေ သမုပဝိၐ္ဋး, တတော ဘဇနဂၖဟေ ယာဝန္တော လောကာ အာသန် တေ သရွွေ'နနျဒၖၐ္ဋျာ တံ ဝိလုလောကိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","အနန္တရမ် အဒျဲတာနိ သရွွာဏိ လိခိတဝစနာနိ ယုၐ္မာကံ မဓျေ သိဒ္ဓါနိ သ ဣမာံ ကထာံ တေဘျး ကထယိတုမာရေဘေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","တတး သရွွေ တသ္မိန် အနွရဇျန္တ, ကိဉ္စ တသျ မုခါန္နိရ္ဂတာဘိရနုဂြဟသျ ကထာဘိၑ္စမတ္ကၖတျ ကထယာမာသုး ကိမယံ ယူၐဖး ပုတြော န? ");
INSERT INTO sanbur_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","တဒါ သော'ဝါဒီဒ် ဟေ စိကိတ္သက သွမေဝ သွသ္ထံ ကုရု ကဖရ္နာဟူမိ ယဒျတ် ကၖတဝါန် တဒၑြော်ၐ္မ တား သရွား ကြိယာ အတြ သွဒေၑေ ကုရု ကထာမေတာံ ယူယမေဝါဝၑျံ မာံ ဝဒိၐျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ပုနး သောဝါဒီဒ် ယုၐ္မာနဟံ ယထာရ္ထံ ဝဒါမိ, ကောပိ ဘဝိၐျဒွါဒီ သွဒေၑေ သတ္ကာရံ န ပြာပ္နောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","အပရဉ္စ ယထာရ္ထံ ဝစ္မိ, ဧလိယသျ ဇီဝနကာလေ ယဒါ သာရ္ဒ္ဓတြိတယဝရ္ၐာဏိ ယာဝတ် ဇလဒပြတိဗန္ဓာတ် သရွွသ္မိန် ဒေၑေ မဟာဒုရ္ဘိက္ၐမ် အဇနိၐ္ဋ တဒါနီမ် ဣသြာယေလော ဒေၑသျ မဓျေ ဗဟွျော ဝိဓဝါ အာသန်, ");
INSERT INTO sanbur_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ကိန္တု သီဒေါန္ပြဒေၑီယသာရိဖတ္ပုရနိဝါသိနီမ် ဧကာံ ဝိဓဝါံ ဝိနာ ကသျာၑ္စိဒပိ သမီပေ ဧလိယး ပြေရိတော နာဘူတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","အပရဉ္စ ဣလီၑာယဘဝိၐျဒွါဒိဝိဒျမာနတာကာလေ ဣသြာယေလ္ဒေၑေ ဗဟဝး ကုၐ္ဌိန အာသန် ကိန္တု သုရီယဒေၑီယံ နာမာန္ကုၐ္ဌိနံ ဝိနာ ကောပျနျး ပရိၐ္ကၖတော နာဘူတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ဣမာံ ကထာံ ၑြုတွာ ဘဇနဂေဟသ္ထိတာ လောကား သကြောဓမ် ဥတ္ထာယ ");
INSERT INTO sanbur_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","နဂရာတ္တံ ဗဟိၐ္ကၖတျ ယသျ ၑိခရိဏ ဥပရိ တေၐာံ နဂရံ သ္ထာပိတမာသ္တေ တသ္မာန္နိက္ၐေပ္တုံ တသျ ၑိခရံ တံ နိနျုး ");
INSERT INTO sanbur_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","ကိန္တု သ တေၐာံ မဓျာဒပသၖတျ သ္ထာနာန္တရံ ဇဂါမ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","တတး ပရံ ယီၑုရ္ဂာလီလ္ပြဒေၑီယကဖရ္နာဟူမ္နဂရ ဥပသ္ထာယ ဝိၑြာမဝါရေ လောကာနုပဒေၐ္ဋုမ် အာရဗ္ဓဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","တဒုပဒေၑာတ် သရွွေ စမစ္စကြု ရျတသ္တသျ ကထာ ဂုရုတရာ အာသန်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","တဒါနီံ တဒ္ဘဇနဂေဟသ္ထိတော'မေဓျဘူတဂြသ္တ ဧကော ဇန ဥစ္စဲး ကထယာမာသ, ");
INSERT INTO sanbur_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","ဟေ နာသရတီယယီၑော'သ္မာန် တျဇ, တွယာ သဟာသ္မာကံ ကး သမ္ဗန္ဓး? ကိမသ္မာန် ဝိနာၑယိတုမာယာသိ? တွမီၑွရသျ ပဝိတြော ဇန ဧတဒဟံ ဇာနာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","တဒါ ယီၑုသ္တံ တရ္ဇယိတွာဝဒတ် မော်နီ ဘဝ ဣတော ဗဟိရ္ဘဝ; တတး သောမေဓျဘူတသ္တံ မဓျသ္ထာနေ ပါတယိတွာ ကိဉ္စိဒပျဟိံသိတွာ တသ္မာဒ် ဗဟိရ္ဂတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","တတး သရွွေ လောကာၑ္စမတ္ကၖတျ ပရသ္ပရံ ဝက္တုမာရေဘိရေ ကောယံ စမတ္ကာရး၊ ဧၐ ပြဘာဝေဏ ပရာကြမေဏ စာမေဓျဘူတာန် အာဇ္ဉာပယတိ တေနဲဝ တေ ဗဟိရ္ဂစ္ဆန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","အနန္တရံ စတုရ္ဒိက္သ္ထဒေၑာန် တသျ သုချာတိရွျာပ္နောတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","တဒနန္တရံ သ ဘဇနဂေဟာဒ် ဗဟိရာဂတျ ၑိမောနော နိဝေၑနံ ပြဝိဝေၑ တဒါ တသျ ၑွၑြူရ္ဇွရေဏာတျန္တံ ပီဍိတာသီတ် ၑိၐျာသ္တဒရ္ထံ တသ္မိန် ဝိနယံ စကြုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","တတး သ တသျား သမီပေ သ္ထိတွာ ဇွရံ တရ္ဇယာမာသ တေနဲဝ တာံ ဇွရော'တျာက္ၐီတ် တတး သာ တတ္က္ၐဏမ် ဥတ္ထာယ တာန် သိၐေဝေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","အထ သူရျျာသ္တကာလေ သွေၐာံ ယေ ယေ ဇနာ နာနာရောဂဲး ပီဍိတာ အာသန် လောကာသ္တာန် ယီၑေား သမီပမ် အာနိနျုး, တဒါ သ ဧကဲကသျ ဂါတြေ ကရမရ္ပယိတွာ တာနရောဂါန် စကာရ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","တတော ဘူတာ ဗဟုဘျော နိရ္ဂတျ စီတ္ၑဗ္ဒံ ကၖတွာ စ ဗဘာၐိရေ တွမီၑွရသျ ပုတြော'ဘိၐိက္တတြာတာ; ကိန္တု သောဘိၐိက္တတြာတေတိ တေ ဝိဝိဒုရေတသ္မာတ် ကာရဏာတ် တာန် တရ္ဇယိတွာ တဒွက္တုံ နိၐိၐေဓ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","အပရဉ္စ ပြဘာတေ သတိ သ ဝိဇနသ္ထာနံ ပြတသ္ထေ ပၑ္စာတ် ဇနာသ္တမနွိစ္ဆန္တသ္တန္နိကဋံ ဂတွာ သ္ထာနာန္တရဂမနာရ္ထံ တမနွရုန္ဓန်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","ကိန္တု သ တာန် ဇဂါဒ, ဤၑွရီယရာဇျသျ သုသံဝါဒံ ပြစာရယိတုမ် အနျာနိ ပုရာဏျပိ မယာ ယာတဝျာနိ ယတသ္တဒရ္ထမေဝ ပြေရိတောဟံ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","အထ ဂါလီလော ဘဇနဂေဟေၐု သ ဥပဒိဒေၑ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","အနန္တရံ ယီၑုရေကဒါ ဂိနေၐရထ္ဒသျ တီရ ဥတ္တိၐ္ဌတိ, တဒါ လောကာ ဤၑွရီယကထာံ ၑြောတုံ တဒုပရိ ပြပတိတား၊ ");
INSERT INTO sanbur_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","တဒါနီံ သ ဟ္ဒသျ တီရသမီပေ နော်ဒွယံ ဒဒရ္ၑ ကိဉ္စ မတ္သျောပဇီဝိနော နာဝံ ဝိဟာယ ဇာလံ ပြက္ၐာလယန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","တတသ္တယောရ္ဒွယော ရ္မဓျေ ၑိမောနော နာဝမာရုဟျ တီရာတ် ကိဉ္စိဒ္ဒူရံ ယာတုံ တသ္မိန် ဝိနယံ ကၖတွာ နော်ကာယာမုပဝိၑျ လောကာန် ပြောပဒိၐ္ဋဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ပၑ္စာတ် တံ ပြသ္တာဝံ သမာပျ သ ၑိမောနံ ဝျာဇဟာရ, ဂဘီရံ ဇလံ ဂတွာ မတ္သျာန် ဓရ္တ္တုံ ဇာလံ နိက္ၐိပ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","တတး ၑိမောန ဗဘာၐေ, ဟေ ဂုရော ယဒျပိ ဝယံ ကၖတ္သ္နာံ ယာမိနီံ ပရိၑြမျ မတ္သျဲကမပိ န ပြာပ္တာသ္တထာပိ ဘဝတော နိဒေၑတော ဇာလံ က္ၐိပါမး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","အထ ဇာလေ က္ၐိပ္တေ ဗဟုမတ္သျပတနာဒ် အာနာယး ပြစ္ဆိန္နး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","တသ္မာဒ် ဥပကရ္တ္တုမ် အနျနော်သ္ထာန် သင်္ဂိန အာယာတုမ် ဣင်္ဂိတေန သမာဟွယန် တတသ္တ အာဂတျ မတ္သျဲ ရ္နော်ဒွယံ ပြပူရယာမာသု ရျဲ ရ္နော်ဒွယံ ပြမဂ္နမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","တဒါ ၑိမောန္ပိတရသ္တဒ် ဝိလောကျ ယီၑောၑ္စရဏယေား ပတိတွာ, ဟေ ပြဘောဟံ ပါပီ နရော မမ နိကဋာဒ် ဘဝါန် ယာတု, ဣတိ ကထိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","ယတော ဇာလေ ပတိတာနာံ မတ္သျာနာံ ယူထာတ် ၑိမောန် တတ္သင်္ဂိနၑ္စ စမတ္ကၖတဝန္တး; ၑိမောနး သဟကာရိဏော် သိဝဒေး ပုတြော် ယာကူဗ် ယောဟန် စေမော် တာဒၖၑော် ဗဘူဝတုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","တဒါ ယီၑုး ၑိမောနံ ဇဂါဒ မာ ဘဲၐီရဒျာရဘျ တွံ မနုၐျဓရော ဘဝိၐျသိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","အနန္တရံ သရွွာသု နော်သု တီရမ် အာနီတာသု တေ သရွွာန် ပရိတျဇျ တသျ ပၑ္စာဒ္ဂါမိနော ဗဘူဝုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","တတး ပရံ ယီၑော် ကသ္မိံၑ္စိတ် ပုရေ တိၐ္ဌတိ ဇန ဧကး သရွွာင်္ဂကုၐ္ဌသ္တံ ဝိလောကျ တသျ သမီပေ နျုဗ္ဇး ပတိတွာ သဝိနယံ ဝက္တုမာရေဘေ, ဟေ ပြဘော ယဒိ ဘဝါနိစ္ဆတိ တရှိ မာံ ပရိၐ္ကရ္တ္တုံ ၑက္နောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","တဒါနီံ သ ပါဏိံ ပြသာရျျ တဒင်္ဂံ သ္ပၖၑန် ဗဘာၐေ တွံ ပရိၐ္ကြိယသွေတိ မမေစ္ဆာသ္တိ တတသ္တတ္က္ၐဏံ သ ကုၐ္ဌာတ် မုက္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","ပၑ္စာတ် သ တမာဇ္ဉာပယာမာသ ကထာမိမာံ ကသ္မဲစိဒ် အကထယိတွာ ယာဇကသျ သမီပဉ္စ ဂတွာ သွံ ဒရ္ၑယ, လောကေဘျော နိဇပရိၐ္ကၖတတွသျ ပြမာဏဒါနာယ မူသာဇ္ဉာနုသာရေဏ ဒြဝျမုတ္မၖဇသွ စ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","တထာပိ ယီၑေား သုချာတိ ရ္ဗဟု ဝျာပ္တုမာရေဘေ ကိဉ္စ တသျ ကထာံ ၑြောတုံ သွီယရောဂေဘျော မောက္တုဉ္စ လောကာ အာဇဂ္မုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","အထ သ ပြာန္တရံ ဂတွာ ပြာရ္ထယာဉ္စကြေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","အပရဉ္စ ဧကဒါ ယီၑုရုပဒိၑတိ, ဧတရှိ ဂါလီလျိဟူဒါပြဒေၑယေား သရွွနဂရေဘျော ယိရူၑာလမၑ္စ ကိယန္တး ဖိရူၑိလောကာ ဝျဝသ္ထာပကာၑ္စ သမာဂတျ တဒန္တိကေ သမုပဝိဝိၑုး, တသ္မိန် ကာလေ လောကာနာမာရောဂျကာရဏာတ် ပြဘေား ပြဘာဝး ပြစကာၑေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","ပၑ္စာတ် ကိယန္တော လောကာ ဧကံ ပက္ၐာဃာတိနံ ခဋွာယာံ နိဓာယ ယီၑေား သမီပမာနေတုံ သမ္မုခေ သ္ထာပယိတုဉ္စ ဝျာပြိယန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ကိန္တု ဗဟုဇနနိဝဟသမွာဓာတ် န ၑက္နုဝန္တော ဂၖဟောပရိ ဂတွာ ဂၖဟပၖၐ္ဌံ ခနိတွာ တံ ပက္ၐာဃာတိနံ သခဋွံ ဂၖဟမဓျေ ယီၑေား သမ္မုခေ 'ဝရောဟယာမာသုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","တဒါ ယီၑုသ္တေၐာမ် ဤဒၖၑံ ဝိၑွာသံ ဝိလောကျ တံ ပက္ၐာဃာတိနံ ဝျာဇဟာရ, ဟေ မာနဝ တဝ ပါပမက္ၐမျတ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","တသ္မာဒ် အဓျာပကား ဖိရူၑိနၑ္စ စိတ္တဲရိတ္ထံ ပြစိန္တိတဝန္တး, ဧၐ ဇန ဤၑွရံ နိန္ဒတိ ကောယံ? ကေဝလမီၑွရံ ဝိနာ ပါပံ က္ၐန္တုံ ကး ၑက္နောတိ? ");
INSERT INTO sanbur_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","တဒါ ယီၑုသ္တေၐာမ် ဣတ္ထံ စိန္တနံ ဝိဒိတွာ တေဘျောကထယဒ် ယူယံ မနောဘိး ကုတော ဝိတရ္ကယထ? ");
INSERT INTO sanbur_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","တဝ ပါပက္ၐမာ ဇာတာ ယဒွါ တွမုတ္ထာယ ဝြဇ ဧတယော ရ္မဓျေ ကာ ကထာ သုကထျာ? ");
INSERT INTO sanbur_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","ကိန္တု ပၖထိဝျာံ ပါပံ က္ၐန္တုံ မာနဝသုတသျ သာမရ္ထျမသ္တီတိ ယထာ ယူယံ ဇ္ဉာတုံ ၑက္နုထ တဒရ္ထံ (သ တံ ပက္ၐာဃာတိနံ ဇဂါဒ) ဥတ္တိၐ္ဌ သွၑယျာံ ဂၖဟီတွာ ဂၖဟံ ယာဟီတိ တွာမာဒိၑာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","တသ္မာတ် သ တတ္က္ၐဏမ် ဥတ္ထာယ သရွွေၐာံ သာက္ၐာတ် နိဇၑယနီယံ ဂၖဟီတွာ ဤၑွရံ ဓနျံ ဝဒန် နိဇနိဝေၑနံ ယယော်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","တသ္မာတ် သရွွေ ဝိသ္မယ ပြာပ္တာ မနးသု ဘီတာၑ္စ ဝယမဒျာသမ္ဘဝကာရျျာဏျဒရ္ၑာမ ဣတျုက္တွာ ပရမေၑွရံ ဓနျံ ပြောဒိတား၊ ");
INSERT INTO sanbur_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","တတး ပရံ ဗဟိရ္ဂစ္ဆန် ကရသဉ္စယသ္ထာနေ လေဝိနာမာနံ ကရသဉ္စာယကံ ဒၖၐ္ဋွာ ယီၑုသ္တမဘိဒဓေ မမ ပၑ္စာဒေဟိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","တသ္မာတ် သ တတ္က္ၐဏာတ် သရွွံ ပရိတျဇျ တသျ ပၑ္စာဒိယာယ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","အနန္တရံ လေဝိ ရ္နိဇဂၖဟေ တဒရ္ထံ မဟာဘောဇျံ စကာရ, တဒါ တဲး သဟာနေကေ ကရသဉ္စာယိနသ္တဒနျလောကာၑ္စ ဘောက္တုမုပဝိဝိၑုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","တသ္မာတ် ကာရဏာတ် စဏ္ဍာလာနာံ ပါပိလောကာနာဉ္စ သင်္ဂေ ယူယံ ကုတော ဘံဂ္ဓွေ ပိဝထ စေတိ ကထာံ ကထယိတွာ ဖိရူၑိနော'ဓျာပကာၑ္စ တသျ ၑိၐျဲး သဟ ဝါဂျုဒ္ဓံ ကရ္တ္တုမာရေဘိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","တသ္မာဒ် ယီၑုသ္တာန် ပြတျဝေါစဒ် အရောဂလောကာနာံ စိကိတ္သကေန ပြယောဇနံ နာသ္တိ ကိန္တု သရောဂါဏာမေဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","အဟံ ဓာရ္မ္မိကာန် အာဟွာတုံ နာဂတောသ္မိ ကိန္တု မနး ပရာဝရ္တ္တယိတုံ ပါပိန ဧဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","တတသ္တေ ပြောစုး, ယောဟနး ဖိရူၑိနာဉ္စ ၑိၐျာ ဝါရံဝါရမ် ဥပဝသန္တိ ပြာရ္ထယန္တေ စ ကိန္တု တဝ ၑိၐျား ကုတော ဘုဉ္ဇတေ ပိဝန္တိ စ? ");
INSERT INTO sanbur_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","တဒါ သ တာနာစချော် ဝရေ သင်္ဂေ တိၐ္ဌတိ ဝရသျ သခိဂဏံ ကိမုပဝါသယိတုံ ၑက္နုထ? ");
INSERT INTO sanbur_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","ကိန္တု ယဒါ တေၐာံ နိကဋာဒ် ဝရော နေၐျတေ တဒါ တေ သမုပဝတ္သျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","သောပရမပိ ဒၖၐ္ဋာန္တံ ကထယာမ္ဗဘူဝ ပုရာတနဝသ္တြေ ကောပိ နုတနဝသ္တြံ န သီဝျတိ ယတသ္တေန သေဝနေန ဇီရ္ဏဝသ္တြံ ဆိဒျတေ, နူတနပုရာတနဝသ္တြယော ရ္မေလဉ္စ န ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","ပုရာတနျာံ ကုတွာံ ကောပိ နုတနံ ဒြာက္ၐာရသံ န နိဒဓာတိ, ယတော နဝီနဒြာက္ၐာရသသျ တေဇသာ ပုရာတနီ ကုတူ ရွိဒီရျျတေ တတော ဒြာက္ၐာရသး ပတတိ ကုတူၑ္စ နၑျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","တတော ဟေတော ရ္နူတနျာံ ကုတွာံ နဝီနဒြာက္ၐာရသး နိဓာတဝျသ္တေနောဘယသျ ရက္ၐာ ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","အပရဉ္စ ပုရာတနံ ဒြာက္ၐာရသံ ပီတွာ ကောပိ နူတနံ န ဝါဉ္ဆတိ, ယတး သ ဝက္တိ နူတနာတ် ပုရာတနမ် ပြၑသ္တမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","အစရဉ္စ ပရွွဏော ဒွိတီယဒိနာတ် ပရံ ပြထမဝိၑြာမဝါရေ ၑသျက္ၐေတြေဏ ယီၑောရ္ဂမနကာလေ တသျ ၑိၐျား ကဏိၑံ ဆိတ္တွာ ကရေၐု မရ္ဒ္ဒယိတွာ ခါဒိတုမာရေဘိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","တသ္မာတ် ကိယန္တး ဖိရူၑိနသ္တာနဝဒန် ဝိၑြာမဝါရေ ယတ် ကရ္မ္မ န ကရ္တ္တဝျံ တတ် ကုတး ကုရုထ? ");
INSERT INTO sanbur_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","ယီၑုး ပြတျုဝါစ ဒါယူဒ် တသျ သင်္ဂိနၑ္စ က္ၐုဓာရ္တ္တား ကိံ စကြုး သ ကထမ် ဤၑွရသျ မန္ဒိရံ ပြဝိၑျ ");
INSERT INTO sanbur_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ယေ ဒရ္ၑနီယား ပူပါ ယာဇကာန် ဝိနာနျသျ ကသျာပျဘောဇနီယာသ္တာနာနီယ သွယံ ဗုဘဇေ သင်္ဂိဘျောပိ ဒဒေါ် တတ် ကိံ ယုၐ္မာဘိး ကဒါပိ နာပါဌိ? ");
INSERT INTO sanbur_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ပၑ္စာတ် သ တာနဝဒတ် မနုဇသုတော ဝိၑြာမဝါရသျာပိ ပြဘု ရ္ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","အနန္တရမ် အနျဝိၑြာမဝါရေ သ ဘဇနဂေဟံ ပြဝိၑျ သမုပဒိၑတိ၊ တဒါ တတ္သ္ထာနေ ၑုၐ္ကဒက္ၐိဏကရ ဧကး ပုမာန် ဥပတသ္ထိဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","တသ္မာဒ် အဓျာပကား ဖိရူၑိနၑ္စ တသ္မိန် ဒေါၐမာရောပယိတုံ သ ဝိၑြာမဝါရေ တသျ သွာသ္ထျံ ကရောတိ နဝေတိ ပြတီက္ၐိတုမာရေဘိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","တဒါ ယီၑုသ္တေၐာံ စိန္တာံ ဝိဒိတွာ တံ ၑုၐ္ကကရံ ပုမာံသံ ပြောဝါစ, တွမုတ္ထာယ မဓျသ္ထာနေ တိၐ္ဌ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","တသ္မာတ် တသ္မိန် ဥတ္ထိတဝတိ ယီၑုသ္တာန် ဝျာဇဟာရ, ယုၐ္မာန် ဣမာံ ကထာံ ပၖစ္ဆာမိ, ဝိၑြာမဝါရေ ဟိတမ် အဟိတံ ဝါ, ပြာဏရက္ၐဏံ ပြာဏနာၑနံ ဝါ, ဧတေၐာံ ကိံ ကရ္မ္မကရဏီယမ်? ");
INSERT INTO sanbur_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","ပၑ္စာတ် စတုရ္ဒိက္ၐု သရွွာန် ဝိလောကျ တံ မာနဝံ ဗဘာၐေ, နိဇကရံ ပြသာရယ; တတသ္တေန တထာ ကၖတ ဣတရကရဝတ် တသျ ဟသ္တး သွသ္ထောဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","တသ္မာတ် တေ ပြစဏ္ဍကောပါနွိတာ ယီၑုံ ကိံ ကရိၐျန္တီတိ ပရသ္ပရံ ပြမန္တြိတား၊ ");
INSERT INTO sanbur_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","တတး ပရံ သ ပရွွတမာရုဟျေၑွရမုဒ္ဒိၑျ ပြာရ္ထယမာနး ကၖတ္သ္နာံ ရာတြိံ ယာပိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","အထ ဒိနေ သတိ သ သရွွာန် ၑိၐျာန် အာဟူတဝါန် တေၐာံ မဓျေ ");
INSERT INTO sanbur_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ပိတရနာမ္နာ ချာတး ၑိမောန် တသျ ဘြာတာ အာန္ဒြိယၑ္စ ယာကူဗ် ယောဟန် စ ဖိလိပ် ဗရ္ထလမယၑ္စ ");
INSERT INTO sanbur_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","မထိး ထောမာ အာလ္ဖီယသျ ပုတြော ယာကူဗ် ဇွလန္တနာမ္နာ ချာတး ၑိမောန္ ");
INSERT INTO sanbur_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","စ ယာကူဗော ဘြာတာ ယိဟူဒါၑ္စ တံ ယး ပရကရေၐု သမရ္ပယိၐျတိ သ ဤၐ္ကရီယောတီယယိဟူဒါၑ္စဲတာန် ဒွါဒၑ ဇနာန် မနောနီတာန် ကၖတွာ သ ဇဂြာဟ တထာ ပြေရိတ ဣတိ တေၐာံ နာမ စကာရ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","တတး ပရံ သ တဲး သဟ ပရွွတာဒဝရုဟျ ဥပတျကာယာံ တသ္ထော် တတသ္တသျ ၑိၐျသင်္ဃော ယိဟူဒါဒေၑာဒ် ယိရူၑာလမၑ္စ သောရး သီဒေါနၑ္စ ဇလဓေ ရောဓသော ဇနနိဟာၑ္စ ဧတျ တသျ ကထာၑြဝဏာရ္ထံ ရောဂမုက္တျရ္ထဉ္စ တသျ သမီပေ တသ္ထုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","အမေဓျဘူတဂြသ္တာၑ္စ တန္နိကဋမာဂတျ သွာသ္ထျံ ပြာပုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","သရွွေၐာံ သွာသ္ထျကရဏပြဘာဝသျ ပြကာၑိတတွာတ် သရွွေ လောကာ ဧတျ တံ သ္ပြၐ္ဋုံ ယေတိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","ပၑ္စာတ် သ ၑိၐျာန် ပြတိ ဒၖၐ္ဋိံ ကုတွာ ဇဂါဒ, ဟေ ဒရိဒြာ ယူယံ ဓနျာ ယတ ဤၑွရီယေ ရာဇျေ ဝေါ'ဓိကာရောသ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ဟေ အဓုနာ က္ၐုဓိတလောကာ ယူယံ ဓနျာ ယတော ယူယံ တရ္ပ္သျထ; ဟေ ဣဟ ရောဒိနော ဇနာ ယူယံ ဓနျာ ယတော ယူယံ ဟသိၐျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","ယဒါ လောကာ မနုၐျသူနော ရ္နာမဟေတော ရျုၐ္မာန် ၒृတီယိၐျန္တေ ပၖထက် ကၖတွာ နိန္ဒိၐျန္တိ, အဓမာနိဝ ယုၐ္မာန် သွသမီပါဒ် ဒူရီကရိၐျန္တိ စ တဒါ ယူယံ ဓနျား၊ ");
INSERT INTO sanbur_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","သွရ္ဂေ ယုၐ္မာကံ ယထေၐ္ဋံ ဖလံ ဘဝိၐျတိ, ဧတဒရ္ထံ တသ္မိန် ဒိနေ ပြောလ္လသတ အာနန္ဒေန နၖတျတ စ, တေၐာံ ပူရွွပုရုၐာၑ္စ ဘဝိၐျဒွါဒိနး ပြတိ တထဲဝ ဝျဝါဟရန်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","ကိန္တု ဟာ ဟာ ဓနဝန္တော ယူယံ သုခံ ပြာပ္နုတ၊ ဟန္တ ပရိတၖပ္တာ ယူယံ က္ၐုဓိတာ ဘဝိၐျထ; ");
INSERT INTO sanbur_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ဣဟ ဟသန္တော ယူယံ ဝတ ယုၐ္မာဘိး ၑောစိတဝျံ ရောဒိတဝျဉ္စ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","သရွွဲလာကဲ ရျုၐ္မာကံ သုချာတော် ကၖတာယာံ ယုၐ္မာကံ ဒုရ္ဂတိ ရ္ဘဝိၐျတိ ယုၐ္မာကံ ပူရွွပုရုၐာ မၖၐာဘဝိၐျဒွါဒိနး ပြတိ တဒွတ် ကၖတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","ဟေ ၑြောတာရော ယုၐ္မဘျမဟံ ကထယာမိ, ယူယံ ၑတြုၐု ပြီယဓွံ ယေ စ ယုၐ္မာန် ဒွိၐန္တိ တေၐာမပိ ဟိတံ ကုရုတ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ယေ စ ယုၐ္မာန် ၑပန္တိ တေဘျ အာၑိၐံ ဒတ္တ ယေ စ ယုၐ္မာန် အဝမနျန္တေ တေၐာံ မင်္ဂလံ ပြာရ္ထယဓွံ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","ယဒိ ကၑ္စိတ် တဝ ကပေါလေ စပေဋာဃာတံ ကရောတိ တရှိ တံ ပြတိ ကပေါလမ် အနျံ ပရာဝရ္တ္တျ သမ္မုခီကုရု ပုနၑ္စ ယဒိ ကၑ္စိတ် တဝ ဂါတြီယဝသ္တြံ ဟရတိ တရှိ တံ ပရိဓေယဝသ္တြမ် အပိ ဂြဟီတုံ မာ ဝါရယ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ယသ္တွာံ ယာစတေ တသ္မဲ ဒေဟိ, ယၑ္စ တဝ သမ္ပတ္တိံ ဟရတိ တံ မာ ယာစသွ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","ပရေဘျး သွာန် ပြတိ ယထာစရဏမ် အပေက္ၐဓွေ ပရာန် ပြတိ ယူယမပိ တထာစရတ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","ယေ ဇနာ ယုၐ္မာသု ပြီယန္တေ ကေဝလံ တေၐု ပြီယမာဏေၐု ယုၐ္မာကံ ကိံ ဖလံ? ပါပိလောကာ အပိ သွေၐု ပြီယမာဏေၐု ပြီယန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","ယဒိ ဟိတကာရိဏ ဧဝ ဟိတံ ကုရုထ တရှိ ယုၐ္မာကံ ကိံ ဖလံ? ပါပိလောကာ အပိ တထာ ကုရွွန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","ယေဘျ ၒဏပရိၑောဓသျ ပြာပ္တိပြတျာၑာသ္တေ ကေဝလံ တေၐု ၒဏေ သမရ္ပိတေ ယုၐ္မာကံ ကိံ ဖလံ? ပုနး ပြာပ္တျာၑယာ ပါပီလောကာ အပိ ပါပိဇနေၐု ၒဏမ် အရ္ပယန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","အတော ယူယံ ရိပုၐွပိ ပြီယဓွံ, ပရဟိတံ ကုရုတ စ; ပုနး ပြာပ္တျာၑာံ တျက္တွာ ၒဏမရ္ပယတ, တထာ ကၖတေ ယုၐ္မာကံ မဟာဖလံ ဘဝိၐျတိ, ယူယဉ္စ သရွွပြဓာနသျ သန္တာနာ ဣတိ ချာတိံ ပြာပ္သျထ, ယတော ယုၐ္မာကံ ပိတာ ကၖတဃ္နာနာံ ဒုရွ္ဋတ္တာနာဉ္စ ဟိတမာစရတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","အတ ဧဝ သ ယထာ ဒယာလု ရျူယမပိ တာဒၖၑာ ဒယာလဝေါ ဘဝတ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","အပရဉ္စ ပရာန် ဒေါၐိဏော မာ ကုရုတ တသ္မာဒ် ယူယံ ဒေါၐီကၖတာ န ဘဝိၐျထ; အဒဏ္ဍျာန် မာ ဒဏ္ဍယတ တသ္မာဒ် ယူယမပိ ဒဏ္ဍံ န ပြာပ္သျထ; ပရေၐာံ ဒေါၐာန် က္ၐမဓွံ တသ္မာဒ် ယုၐ္မာကမပိ ဒေါၐား က္ၐမိၐျန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","ဒါနာနိဒတ္တ တသ္မာဒ် ယူယံ ဒါနာနိ ပြာပ္သျထ, ဝရဉ္စ လောကား ပရိမာဏပါတြံ ပြဒလယျ သဉ္စာလျ ပြောဉ္စာလျ ပရိပူရျျ ယုၐ္မာကံ ကြောဍေၐု သမရ္ပယိၐျန္တိ; ယူယံ ယေန ပရိမာဏေန ပရိမာထ တေနဲဝ ပရိမာဏေန ယုၐ္မတ္ကၖတေ ပရိမာသျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","အထ သ တေဘျော ဒၖၐ္ဋာန္တကထာမကထယတ်, အန္ဓော ဇနး ကိမန္ဓံ ပန္ထာနံ ဒရ္ၑယိတုံ ၑက္နောတိ? တသ္မာဒ် ဥဘာဝပိ ကိံ ဂရ္တ္တေ န ပတိၐျတး? ");
INSERT INTO sanbur_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ဂုရေား ၑိၐျော န ၑြေၐ္ဌး ကိန္တု ၑိၐျေ သိဒ္ဓေ သတိ သ ဂုရုတုလျော ဘဝိတုံ ၑက္နောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","အပရဉ္စ တွံ သွစက္ၐုुၐိ နာသာမ် အဒၖၐ္ဋွာ တဝ ဘြာတုၑ္စက္ၐုၐိ ယတ္တၖဏမသ္တိ တဒေဝ ကုတး ပၑျမိ? ");
INSERT INTO sanbur_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","သွစက္ၐုၐိ ယာ နာသာ ဝိဒျတေ တာမ် အဇ္ဉာတွာ, ဘြာတသ္တဝ နေတြာတ် တၖဏံ ဗဟိး ကရောမီတိ ဝါကျံ ဘြာတရံ ကထံ ဝက္တုံ ၑက္နောၐိ? ဟေ ကပဋိန် ပူရွွံ သွနယနာတ် နာသာံ ဗဟိး ကုရု တတော ဘြာတုၑ္စက္ၐုၐသ္တၖဏံ ဗဟိး ကရ္တ္တုံ သုဒၖၐ္ဋိံ ပြာပ္သျသိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","အနျဉ္စ ဥတ္တမသ္တရုး ကဒါပိ ဖလမနုတ္တမံ န ဖလတိ, အနုတ္တမတရုၑ္စ ဖလမုတ္တမံ န ဖလတိ ကာရဏာဒတး ဖလဲသ္တရဝေါ ဇ္ဉာယန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","ကဏ္ဋကိပါဒပါတ် ကောပိ ဥဍုမ္ဗရဖလာနိ န ပါတယတိ တထာ ၑၖဂါလကောလိဝၖက္ၐာဒပိ ကောပိ ဒြာက္ၐာဖလံ န ပါတယတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","တဒွတ် သာဓုလောကော'န္တးကရဏရူပါတ် သုဘာဏ္ဍာဂါရာဒ် ဥတ္တမာနိ ဒြဝျာဏိ ဗဟိး ကရောတိ, ဒုၐ္ဋော လောကၑ္စာန္တးကရဏရူပါတ် ကုဘာဏ္ဍာဂါရာတ် ကုတ္သိတာနိ ဒြဝျာဏိ နိရ္ဂမယတိ ယတော'န္တးကရဏာနာံ ပူရ္ဏဘာဝါနုရူပါဏိ ဝစာံသိ မုခါန္နိရ္ဂစ္ဆန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","အပရဉ္စ မမာဇ္ဉာနုရူပံ နာစရိတွာ ကုတော မာံ ပြဘော ပြဘော ဣတိ ဝဒထ? ");
INSERT INTO sanbur_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","ယး ကၑ္စိန် မမ နိကဋမ် အာဂတျ မမ ကထာ နိၑမျ တဒနုရူပံ ကရ္မ္မ ကရောတိ သ ကသျ သဒၖၑော ဘဝတိ တဒဟံ ယုၐ္မာန် ဇ္ဉာाပယာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ယော ဇနော ဂဘီရံ ခနိတွာ ပါၐာဏသ္ထလေ ဘိတ္တိံ နိရ္မ္မာယ သွဂၖဟံ ရစယတိ တေန သဟ တသျောပမာ ဘဝတိ; ယတ အာပ္လာဝိဇလမေတျ တသျ မူလေ ဝေဂေန ဝဟဒပိ တဒ္ဂေဟံ လာဍယိတုံ န ၑက္နောတိ ယတသ္တသျ ဘိတ္တိး ပါၐာဏောပရိ တိၐ္ဌတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","ကိန္တု ယး ကၑ္စိန် မမ ကထား ၑြုတွာ တဒနုရူပံ နာစရတိ သ ဘိတ္တိံ ဝိနာ မၖृဒုပရိ ဂၖဟနိရ္မ္မာတြာ သမာနော ဘဝတိ; ယတ အာပ္လာဝိဇလမာဂတျ ဝေဂေန ယဒါ ဝဟတိ တဒါ တဒ္ဂၖဟံ ပတတိ တသျ မဟတ် ပတနံ ဇာယတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","တတး ပရံ သ လောကာနာံ ကရ္ဏဂေါစရေ တာန် သရွွာန် ဥပဒေၑာန် သမာပျ ယဒါ ကဖရ္နာဟူမ္ပုရံ ပြဝိၑတိ ");
INSERT INTO sanbur_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","တဒါ ၑတသေနာပတေး ပြိယဒါသ ဧကော မၖတကလ္ပး ပီဍိတ အာသီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","အတး သေနာပတိ ရျီၑော ရွာရ္တ္တာံ နိၑမျ ဒါသသျာရောဂျကရဏာယ တသျာဂမနာရ္ထံ ဝိနယကရဏာယ ယိဟူဒီယာန် ကိယတး ပြာစး ပြေၐယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","တေ ယီၑောရန္တိကံ ဂတွာ ဝိနယာတိၑယံ ဝက္တုမာရေဘိရေ, သ သေနာပတိ ရ္ဘဝတောနုဂြဟံ ပြာပ္တုမ် အရှတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ယတး သောသ္မဇ္ဇာတီယေၐု လောကေၐု ပြီယတေ တထာသ္မတ္ကၖတေ ဘဇနဂေဟံ နိရ္မ္မိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","တသ္မာဒ် ယီၑုသ္တဲး သဟ ဂတွာ နိဝေၑနသျ သမီပံ ပြာပ, တဒါ သ ၑတသေနာပတိ ရွက္ၐျမာဏဝါကျံ တံ ဝက္တုံ ဗန္ဓူန် ပြာဟိဏောတ်၊ ဟေ ပြဘော သွယံ ၑြမော န ကရ္တ္တဝျော ယဒ် ဘဝတာ မဒ္ဂေဟမဓျေ ပါဒါရ္ပဏံ ကြိယေတ တဒပျဟံ နာရှာမိ, ");
INSERT INTO sanbur_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ကိဉ္စာဟံ ဘဝတ္သမီပံ ယာတုမပိ နာတ္မာနံ ယောဂျံ ဗုဒ္ဓဝါန်, တတော ဘဝါန် ဝါကျမာတြံ ဝဒတု တေနဲဝ မမ ဒါသး သွသ္ထော ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","ယသ္မာဒ် အဟံ ပရာဓီနောပိ မမာဓီနာ ယား သေနား သန္တိ တာသာမ် ဧကဇနံ ပြတိ ယာဟီတိ မယာ ပြောက္တေ သ ယာတိ; တဒနျံ ပြတိ အာယာဟီတိ ပြောက္တေ သ အာယာတိ; တထာ နိဇဒါသံ ပြတိ ဧတတ် ကုရွွိတိ ပြောက္တေ သ တဒေဝ ကရောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","ယီၑုရိဒံ ဝါကျံ ၑြုတွာ ဝိသ္မယံ ယယော်, မုခံ ပရာဝရ္တျ ပၑ္စာဒွရ္တ္တိနော လောကာန် ဗဘာၐေ စ, ယုၐ္မာနဟံ ဝဒါမိ ဣသြာယေလော ဝံၑမဓျေပိ ဝိၑွာသမီဒၖၑံ န ပြာပ္နဝံ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","တတသ္တေ ပြေၐိတာ ဂၖဟံ ဂတွာ တံ ပီဍိတံ ဒါသံ သွသ္ထံ ဒဒၖၑုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","ပရေ'ဟနိ သ နာယီနာချံ နဂရံ ဇဂါမ တသျာနေကေ ၑိၐျာ အနျေ စ လောကာသ္တေန သာရ္ဒ္ဓံ ယယုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","တေၐု တန္နဂရသျ ဒွါရသန္နိဓိံ ပြာပ္တေၐု ကိယန္တော လောကာ ဧကံ မၖတမနုဇံ ဝဟန္တော နဂရသျ ဗဟိရျာန္တိ, သ တန္မာတုရေကပုတြသ္တန္မာတာ စ ဝိဓဝါ; တယာ သာရ္ဒ္ဓံ တန္နဂရီယာ ဗဟဝေါ လောကာ အာသန်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ပြဘုသ္တာံ ဝိလောကျ သာနုကမ္ပး ကထယာမာသ, မာ ရောဒီး၊ သ သမီပမိတွာ ခဋွာံ ပသ္ပရ္ၑ တသ္မာဒ် ဝါဟကား သ္ထဂိတာသ္တမျုး; ");
INSERT INTO sanbur_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","တဒါ သ ဥဝါစ ဟေ ယုဝမနုၐျ တွမုတ္တိၐ္ဌ, တွာမဟမ် အာဇ္ဉာပယာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","တသ္မာတ် သ မၖတော ဇနသ္တတ္က္ၐဏမုတ္ထာယ ကထာံ ပြကထိတး; တတော ယီၑုသ္တသျ မာတရိ တံ သမရ္ပယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","တသ္မာတ် သရွွေ လောကား ၑၑင်္ကိရေ; ဧကော မဟာဘဝိၐျဒွါဒီ မဓျေ'သ္မာကမ် သမုဒဲတ်, ဤၑွရၑ္စ သွလောကာနနွဂၖဟ္လာတ် ကထာမိမာံ ကထယိတွာ ဤၑွရံ ဓနျံ ဇဂဒုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","တတး ပရံ သမသ္တံ ယိဟူဒါဒေၑံ တသျ စတုရ္ဒိက္သ္ထဒေၑဉ္စ တသျဲတတ္ကီရ္တ္တိ ရွျာနၑေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","တတး ပရံ ယောဟနး ၑိၐျေၐု တံ တဒွၖတ္တာန္တံ ဇ္ဉာပိတဝတ္သု ");
INSERT INTO sanbur_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","သ သွၑိၐျာဏာံ ဒွေါ် ဇနာဝါဟူယ ယီၑုံ ပြတိ ဝက္ၐျမာဏံ ဝါကျံ ဝက္တုံ ပြေၐယာမာသ, ယသျာဂမနမ် အပေက္ၐျ တိၐ္ဌာမော ဝယံ ကိံ သ ဧဝ ဇနသ္တွံ? ကိံ ဝယမနျမပေက္ၐျ သ္ထာသျာမး? ");
INSERT INTO sanbur_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","ပၑ္စာတ္တော် မာနဝေါ် ဂတွာ ကထယာမာသတုး, ယသျာဂမနမ် အပေက္ၐျ တိၐ္ဌာမော ဝယံ, ကိံ သဧဝ ဇနသ္တွံ? ကိံ ဝယမနျမပေက္ၐျ သ္ထာသျာမး? ကထာမိမာံ တုဘျံ ကထယိတုံ ယောဟန် မဇ္ဇက အာဝါံ ပြေၐိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","တသ္မိန် ဒဏ္ဍေ ယီၑူရောဂိဏော မဟာဝျာဓိမတော ဒုၐ္ဋဘူတဂြသ္တာံၑ္စ ဗဟူန် သွသ္ထာန် ကၖတွာ, အနေကာန္ဓေဘျၑ္စက္ၐုံၐိ ဒတ္တွာ ပြတျုဝါစ, ");
INSERT INTO sanbur_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ယုဝါံ ဝြဇတမ် အန္ဓာ နေတြာဏိ ခဉ္ဇာၑ္စရဏာနိ စ ပြာပ္နုဝန္တိ, ကုၐ္ဌိနး ပရိၐ္ကြိယန္တေ, ဗဓိရား ၑြဝဏာနိ မၖတာၑ္စ ဇီဝနာနိ ပြာပ္နုဝန္တိ, ဒရိဒြာဏာံ သမီပေၐု သုသံဝါဒး ပြစာရျျတေ, ယံ ပြတိ ဝိဃ္နသွရူပေါဟံ န ဘဝါမိ သ ဓနျး, ");
INSERT INTO sanbur_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ဧတာနိ ယာနိ ပၑျထး ၑၖဏုထၑ္စ တာနိ ယောဟနံ ဇ္ဉာပယတမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","တယော ရ္ဒူတယော ရ္ဂတယေား သတော ရျောဟနိ သ လောကာန် ဝက္တုမုပစကြမေ, ယူယံ မဓျေပြာန္တရံ ကိံ ဒြၐ္ဋုံ နိရဂမတ? ကိံ ဝါယုနာ ကမ္ပိတံ နဍံ? ");
INSERT INTO sanbur_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","ယူယံ ကိံ ဒြၐ္ဋုံ နိရဂမတ? ကိံ သူက္ၐ္မဝသ္တြပရိဓာယိနံ ကမပိ နရံ? ကိန္တု ယေ သူက္ၐ္မမၖဒုဝသ္တြာဏိ ပရိဒဓတိ သူတ္တမာနိ ဒြဝျာဏိ ဘုဉ္ဇတေ စ တေ ရာဇဓာနီၐု တိၐ္ဌန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","တရှိ ယူယံ ကိံ ဒြၐ္ဋုံ နိရဂမတ? ကိမေကံ ဘဝိၐျဒွါဒိနံ? တဒေဝ သတျံ ကိန္တု သ ပုမာန် ဘဝိၐျဒွါဒိနောပိ ၑြေၐ္ဌ ဣတျဟံ ယုၐ္မာန် ဝဒါမိ; ");
INSERT INTO sanbur_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ပၑျ သွကီယဒူတန္တု တဝါဂြ ပြေၐယာမျဟံ၊ ဂတွာ တွဒီယမာရ္ဂန္တု သ ဟိ ပရိၐ္ကရိၐျတိ၊ ယဒရ္ထေ လိပိရိယမ် အာသ္တေ သ ဧဝ ယောဟန်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","အတော ယုၐ္မာနဟံ ဝဒါမိ သ္တြိယာ ဂရ္ဗ္ဘဇာတာနာံ ဘဝိၐျဒွါဒိနာံ မဓျေ ယောဟနော မဇ္ဇကာတ် ၑြေၐ္ဌး ကောပိ နာသ္တိ, တတြာပိ ဤၑွရသျ ရာဇျေ ယး သရွွသ္မာတ် က္ၐုဒြး သ ယောဟနောပိ ၑြေၐ္ဌး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","အပရဉ္စ သရွွေ လောကား ကရမဉ္စာယိနၑ္စ တသျ ဝါကျာနိ ၑြုတွာ ယောဟနာ မဇ္ဇနေန မဇ္ဇိတား ပရမေၑွရံ နိရ္ဒောၐံ မေနိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","ကိန္တု ဖိရူၑိနော ဝျဝသ္ထာပကာၑ္စ တေန န မဇ္ဇိတား သွာန် ပြတီၑွရသျောပဒေၑံ နိၐ္ဖလမ် အကုရွွန်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","အထ ပြဘုး ကထယာမာသ, ဣဒါနီန္တနဇနာန် ကေနောပမာမိ? တေ ကသျ သဒၖၑား? ");
INSERT INTO sanbur_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ယေ ဗာလကာ ဝိပဏျာမ် ဥပဝိၑျ ပရသ္ပရမ် အာဟူယ ဝါကျမိဒံ ဝဒန္တိ, ဝယံ ယုၐ္မာကံ နိကဋေ ဝံၑီရဝါဒိၐ္မ, ကိန္တု ယူယံ နာနရ္တ္တိၐ္ဋ, ဝယံ ယုၐ္မာကံ နိကဋ အရောဒိၐ္မ, ကိန္တု ယုယံ န ဝျလပိၐ္ဋ, ဗာလကဲရေတာဒၖၑဲသ္တေၐာမ် ဥပမာ ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","ယတော ယောဟန် မဇ္ဇက အာဂတျ ပူပံ နာခါဒတ် ဒြာက္ၐာရသဉ္စ နာပိဝတ် တသ္မာဒ် ယူယံ ဝဒထ, ဘူတဂြသ္တောယမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","တတး ပရံ မာနဝသုတ အာဂတျာခါဒဒပိဝဉ္စ တသ္မာဒ် ယူယံ ဝဒထ, ခါဒကး သုရာပၑ္စာဏ္ဍာလပါပိနာံ ဗန္ဓုရေကော ဇနော ဒၖၑျတာမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","ကိန္တု ဇ္ဉာနိနော ဇ္ဉာနံ နိရ္ဒောၐံ ဝိဒုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ပၑ္စာဒေကး ဖိရူၑီ ယီၑုံ ဘောဇနာယ နျမန္တြယတ် တတး သ တသျ ဂၖဟံ ဂတွာ ဘောက္တုမုပဝိၐ္ဋး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ဧတရှိ တတ္ဖိရူၑိနော ဂၖဟေ ယီၑု ရ္ဘေက္တုမ် ဥပါဝေက္ၐီတ် တစ္ဆြုတွာ တန္နဂရဝါသိနီ ကာပိ ဒုၐ္ဋာ နာရီ ပါဏ္ဍရပြသ္တရသျ သမ္ပုဋကေ သုဂန္ဓိတဲလမ် အာနီယ ");
INSERT INTO sanbur_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","တသျ ပၑ္စာတ် ပါဒယေား သန္နိဓော် တသျော် ရုဒတီ စ နေတြာမ္ဗုဘိသ္တသျ စရဏော် ပြက္ၐာလျ နိဇကစဲရမာရ္က္ၐီတ်, တတသ္တသျ စရဏော် စုမ္ဗိတွာ တေန သုဂန္ဓိတဲလေန မမရ္ဒ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","တသ္မာတ် သ နိမန္တြယိတာ ဖိရူၑီ မနသာ စိန္တယာမာသ, ယဒျယံ ဘဝိၐျဒွါဒီ ဘဝေတ် တရှိ ဧနံ သ္ပၖၑတိ ယာ သ္တြီ သာ ကာ ကီဒၖၑီ စေတိ ဇ္ဉာတုံ ၑက္နုယာတ် ယတး သာ ဒုၐ္ဋာ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","တဒါ ယာၑုသ္တံ ဇဂါဒ, ဟေ ၑိမောန် တွာံ ပြတိ မမ ကိဉ္စိဒ် ဝက္တဝျမသ္တိ; တသ္မာတ် သ ဗဘာၐေ, ဟေ ဂုရော တဒ် ဝဒတု၊ ");
INSERT INTO sanbur_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ဧကောတ္တမရ္ဏသျ ဒွါဝဓမရ္ဏာဝါသ္တာံ, တယောရေကး ပဉ္စၑတာနိ မုဒြာပါဒါန် အပရၑ္စ ပဉ္စာၑတ် မုဒြာပါဒါန် ဓာရယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","တဒနန္တရံ တယေား ၑောဓျာဘာဝါတ် သ ဥတ္တမရ္ဏသ္တယော ရၖဏေ စက္ၐမေ; တသ္မာတ် တယောရ္ဒွယေား ကသ္တသ္မိန် ပြေၐျတေ ဗဟု? တဒ် ဗြူဟိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ၑိမောန် ပြတျုဝါစ, မယာ ဗုဓျတေ ယသျာဓိကမ် ၒဏံ စက္ၐမေ သ ဣတိ; တတော ယီၑုသ္တံ ဝျာဇဟာရ, တွံ ယထာရ္ထံ ဝျစာရယး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","အထ တာံ နာရီံ ပြတိ ဝျာဃုဌျ ၑိမောနမဝေါစတ်, သ္တြီမိမာံ ပၑျသိ? တဝ ဂၖဟေ မယျာဂတေ တွံ ပါဒပြက္ၐာလနာရ္ထံ ဇလံ နာဒါး ကိန္တု ယောၐိဒေၐာ နယနဇလဲ ရ္မမ ပါဒေါ် ပြက္ၐာလျ ကေၑဲရမာရ္က္ၐီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","တွံ မာံ နာစုမ္ဗီး ကိန္တု ယောၐိဒေၐာ သွီယာဂမနာဒါရဘျ မဒီယပါဒေါ် စုမ္ဗိတုံ န ဝျရံသ္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","တွဉ္စ မဒီယောတ္တမာင်္ဂေ ကိဉ္စိဒပိ တဲလံ နာမရ္ဒီး ကိန္တု ယောၐိဒေၐာ မမ စရဏော် သုဂန္ဓိတဲလေနာမရ္ဒ္ဒီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","အတသ္တွာံ ဝျာဟရာမိ, ဧတသျာ ဗဟု ပါပမက္ၐမျတ တတော ဗဟု ပြီယတေ ကိန္တု ယသျာလ္ပပါပံ က္ၐမျတေ သောလ္ပံ ပြီယတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","တတး ပရံ သ တာံ ဗဘာၐေ, တွဒီယံ ပါပမက္ၐမျတ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","တဒါ တေန သာရ္ဒ္ဓံ ယေ ဘောက္တုမ် ဥပဝိဝိၑုသ္တေ ပရသ္ပရံ ဝက္တုမာရေဘိရေ, အယံ ပါပံ က္ၐမတေ က ဧၐး? ");
INSERT INTO sanbur_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","ကိန္တု သ တာံ နာရီံ ဇဂါဒ, တဝ ဝိၑွာသသ္တွာံ ပရျျတြာသ္တ တွံ က္ၐေမေဏ ဝြဇ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","အပရဉ္စ ယီၑု ရ္ဒွါဒၑဘိး ၑိၐျဲး သာရ္ဒ္ဓံ နာနာနဂရေၐု နာနာဂြာမေၐု စ ဂစ္ဆန် ဣၑွရီယရာဇတွသျ သုသံဝါဒံ ပြစာရယိတုံ ပြာရေဘေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","တဒါ ယသျား သပ္တ ဘူတာ နိရဂစ္ဆန် သာ မဂ္ဒလီနီတိ ဝိချာတာ မရိယမ် ဟေရောဒြာဇသျ ဂၖဟာဓိပတေး ဟောၐေ ရ္ဘာရျျာ ယောဟနာ ၑူၑာနာ ");
INSERT INTO sanbur_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ပြဘၖတယော ယာ ဗဟွျး သ္တြိယး ဒုၐ္ဋဘူတေဘျော ရောဂေဘျၑ္စ မုက္တား သတျော နိဇဝိဘူတီ ရွျယိတွာ တမသေဝန္တ, တား သရွွာသ္တေန သာရ္ဒ္ဓမ် အာသန်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","အနန္တရံ နာနာနဂရေဘျော ဗဟဝေါ လောကာ အာဂတျ တသျ သမီပေ'မိလန်, တဒါ သ တေဘျ ဧကာံ ဒၖၐ္ဋာန္တကထာံ ကထယာမာသ၊ ဧကး ကၖၐီဗလော ဗီဇာနိ ဝပ္တုံ ဗဟိရ္ဇဂါမ, ");
INSERT INTO sanbur_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","တတော ဝပနကာလေ ကတိပယာနိ ဗီဇာနိ မာရ္ဂပါရ္ၑွေ ပေတုး, တတသ္တာနိ ပဒတလဲ ရ္ဒလိတာနိ ပက္ၐိဘိ ရ္ဘက္ၐိတာနိ စ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","ကတိပယာနိ ဗီဇာနိ ပါၐာဏသ္ထလေ ပတိတာနိ ယဒျပိ တာနျင်္ကုရိတာနိ တထာပိ ရသာဘာဝါတ် ၑုၑုၐုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","ကတိပယာနိ ဗီဇာနိ ကဏ္ဋကိဝနမဓျေ ပတိတာနိ တတး ကဏ္ဋကိဝနာနိ သံဝၖဒ္ဓျ တာနိ ဇဂြသုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","တဒနျာနိ ကတိပယဗီဇာနိ စ ဘူမျာမုတ္တမာယာံ ပေတုသ္တတသ္တာနျင်္ကုရယိတွာ ၑတဂုဏာနိ ဖလာနိ ဖေလုး၊ သ ဣမာ ကထာံ ကထယိတွာ ပြောစ္စဲး ပြောဝါစ, ယသျ ၑြောတုံ ၑြောတြေ သ္တး သ ၑၖဏောတု၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","တတး ပရံ ၑိၐျာသ္တံ ပပြစ္ဆုရသျ ဒၖၐ္ဋာန္တသျ ကိံ တာတ္ပရျျံ? ");
INSERT INTO sanbur_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","တတး သ ဝျာဇဟာရ, ဤၑွရီယရာဇျသျ ဂုဟျာနိ ဇ္ဉာတုံ ယုၐ္မဘျမဓိကာရော ဒီယတေ ကိန္တွနျေ ယထာ ဒၖၐ္ဋွာပိ န ပၑျန္တိ ၑြုတွာပိ မ ဗုဓျန္တေ စ တဒရ္ထံ တေၐာံ ပုရသ္တာတ် တား သရွွား ကထာ ဒၖၐ္ဋာန္တေန ကထျန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","ဒၖၐ္ဋာန္တသျာသျာဘိပြာယး, ဤၑွရီယကထာ ဗီဇသွရူပါ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ယေ ကထာမာတြံ ၑၖဏွန္တိ ကိန္တု ပၑ္စာဒ် ဝိၑွသျ ယထာ ပရိတြာဏံ န ပြာပ္နုဝန္တိ တဒါၑယေန ၑဲတာနေတျ ဟၖဒယာတၖ တာံ ကထာမ် အပဟရတိ တ ဧဝ မာရ္ဂပါရ္ၑွသ္ထဘူမိသွရူပါး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ယေ ကထံ ၑြုတွာ သာနန္ဒံ ဂၖဟ္လန္တိ ကိန္တွဗဒ္ဓမူလတွာတ် သွလ္ပကာလမာတြံ ပြတီတျ ပရီက္ၐာကာလေ ဘြၑျန္တိ တဧဝ ပါၐာဏဘူမိသွရူပါး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ယေ ကထာံ ၑြုတွာ ယာန္တိ ဝိၐယစိန္တာယာံ ဓနလောဘေန ဧेဟိကသုခေ စ မဇ္ဇန္တ ဥပယုက္တဖလာနိ န ဖလန္တိ တ ဧဝေါပ္တဗီဇကဏ္ဋကိဘူသွရူပါး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","ကိန္တု ယေ ၑြုတွာ သရလဲး ၑုဒ္ဓဲၑ္စာန္တးကရဏဲး ကထာံ ဂၖဟ္လန္တိ ဓဲရျျမ် အဝလမ္ဗျ ဖလာနျုတ္ပာဒယန္တိ စ တ ဧဝေါတ္တမမၖတ္သွရူပါး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","အပရဉ္စ ပြဒီပံ ပြဇွာလျ ကောပိ ပါတြေဏ နာစ္ဆာဒယတိ တထာ ခဋွာဓောပိ န သ္ထာပယတိ, ကိန္တု ဒီပါဓာရောပရျျေဝ သ္ထာပယတိ, တသ္မာတ် ပြဝေၑကာ ဒီပ္တိံ ပၑျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","ယန္န ပြကာၑယိၐျတေ တာဒၖဂ် အပြကာၑိတံ ဝသ္တု ကိမပိ နာသ္တိ ယစ္စ န သုဝျက္တံ ပြစာရယိၐျတေ တာဒၖဂ် ဂၖပ္တံ ဝသ္တု ကိမပိ နာသ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","အတော ယူယံ ကေန ပြကာရေဏ ၑၖဏုထ တတြ သာဝဓာနာ ဘဝတ, ယသျ သမီပေ ဗရ္ဒ္ဓတေ တသ္မဲ ပုနရ္ဒာသျတေ ကိန္တု ယသျာၑြယေ န ဗရ္ဒ္ဓတေ တသျ ယဒျဒသ္တိ တဒပိ တသ္မာတ် နေၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","အပရဉ္စ ယီၑော ရ္မာတာ ဘြာတရၑ္စ တသျ သမီပံ ဇိဂမိၐဝး ");
INSERT INTO sanbur_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","ကိန္တု ဇနတာသမ္ဗာဓာတ် တတ္သန္နိဓိံ ပြာပ္တုံ န ၑေကုး၊ တတ္ပၑ္စာတ် တဝ မာတာ ဘြာတရၑ္စ တွာံ သာက္ၐာတ် စိကီရ္ၐန္တော ဗဟိသ္တိၐ္ဌနတီတိ ဝါရ္တ္တာယာံ တသ္မဲ ကထိတာယာံ ");
INSERT INTO sanbur_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","သ ပြတျုဝါစ; ယေ ဇနာ ဤၑွရသျ ကထာံ ၑြုတွာ တဒနုရူပမာစရန္တိ တဧဝ မမ မာတာ ဘြာတရၑ္စ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","အနန္တရံ ဧကဒါ ယီၑုး ၑိၐျဲး သာရ္ဒ္ဓံ နာဝမာရုဟျ ဇဂါဒ, အာယာတ ဝယံ ဟြဒသျ ပါရံ ယာမး, တတသ္တေ ဇဂ္မုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","တေၐု နော်ကာံ ဝါဟယတ္သု သ နိဒဒြော်; ");
INSERT INTO sanbur_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","အထာကသ္မာတ် ပြဗလဈဉ္ဘ္ၑဂမာဒ် ဟြဒေ နော်ကာယာံ တရင်္ဂဲရာစ္ဆန္နာယာံ ဝိပတ် တာန် ဇဂြာသ၊ တသ္မာဒ် ယီၑောရန္တိကံ ဂတွာ ဟေ ဂုရော ဟေ ဂုရော ပြာဏာ နော ယာန္တီတိ ဂဒိတွာ တံ ဇာဂရယာမ္ဗဘူဝုး၊ တဒါ သ ဥတ္ထာယ ဝါယုံ တရင်္ဂါံၑ္စ တရ္ဇယာမာသ တသ္မာဒုဘော် နိဝၖတျ သ္ထိရော် ဗဘူဝတုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","သ တာန် ဗဘာၐေ ယုၐ္မာကံ ဝိၑွာသး က? တသ္မာတ္တေ ဘီတာ ဝိသ္မိတာၑ္စ ပရသ္ပရံ ဇဂဒုး, အဟော ကီဒၖဂယံ မနုဇး ပဝနံ ပါနီယဉ္စာဒိၑတိ တဒုဘယံ တဒါဒေၑံ ဝဟတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","တတး ပရံ ဂါလီလ္ပြဒေၑသျ သမ္မုခသ္ထဂိဒေရီယပြဒေၑေ နော်ကာယာံ လဂန္တျာံ တဋေ'ဝရောဟမာဝါဒ္ ");
INSERT INTO sanbur_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ဗဟုတိထကာလံ ဘူတဂြသ္တ ဧကော မာနုၐး ပုရာဒါဂတျ တံ သာက္ၐာစ္စကာရ၊ သ မနုၐော ဝါသော န ပရိဒဓတ် ဂၖဟေ စ န ဝသန် ကေဝလံ ၑ္မၑာနမ် အဓျုဝါသ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","သ ယီၑုံ ဒၖၐ္ဋွဲဝ စီစ္ဆဗ္ဒံ စကာရ တသျ သမ္မုခေ ပတိတွာ ပြောစ္စဲရ္ဇဂါဒ စ, ဟေ သရွွပြဓာနေၑွရသျ ပုတြ, မယာ သဟ တဝ ကး သမ္ဗန္ဓး? တွယိ ဝိနယံ ကရောမိ မာံ မာ ယာတယ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","ယတး သ တံ မာနုၐံ တျက္တွာ ယာတုမ် အမေဓျဘူတမ် အာဒိဒေၑ; သ ဘူတသ္တံ မာနုၐမ် အသကၖဒ် ဒဓာရ တသ္မာလ္လောကား ၑၖင်္ခလေန နိဂဍေန စ ဗဗန္ဓုး; သ တဒ် ဘံက္တွာ ဘူတဝၑတွာတ် မဓျေပြာန္တရံ ယယော်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","အနန္တရံ ယီၑုသ္တံ ပပြစ္ဆ တဝ ကိန္နာမ? သ ဥဝါစ, မမ နာမ ဗာဟိနော ယတော ဗဟဝေါ ဘူတာသ္တမာၑိၑြိယုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","အထ ဘူတာ ဝိနယေန ဇဂဒုး, ဂဘီရံ ဂရ္တ္တံ ဂန္တုံ မာဇ္ဉာပယာသ္မာန်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","တဒါ ပရွွတောပရိ ဝရာဟဝြဇၑ္စရတိ တသ္မာဒ် ဘူတာ ဝိနယေန ပြောစုး, အမုံ ဝရာဟဝြဇမ် အာၑြယိတုမ် အသ္မာန် အနုဇာနီဟိ; တတး သောနုဇဇ္ဉော်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","တတး ပရံ ဘူတာသ္တံ မာနုၐံ ဝိဟာယ ဝရာဟဝြဇမ် အာၑိၑြိယုး ဝရာဟဝြဇာၑ္စ တတ္က္ၐဏာတ် ကဋကေန ဓာဝန္တော ဟြဒေ ပြာဏာန် ဝိဇၖဟုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","တဒ် ဒၖၐ္ဋွာ ၑူကရရက္ၐကား ပလာယမာနာ နဂရံ ဂြာမဉ္စ ဂတွာ တတ္သရွွဝၖတ္တာန္တံ ကထယာမာသုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","တတး ကိံ ဝၖတ္တမ် ဧတဒ္ဒရ္ၑနာရ္ထံ လောကာ နိရ္ဂတျ ယီၑေား သမီပံ ယယုး, တံ မာနုၐံ တျက္တဘူတံ ပရိဟိတဝသ္တြံ သွသ္ထမာနုၐဝဒ် ယီၑောၑ္စရဏသန္နိဓော် သူပဝိၑန္တံ ဝိလောကျ ဗိဘျုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ယေ လောကာသ္တသျ ဘူတဂြသ္တသျ သွာသ္ထျကရဏံ ဒဒၖၑုသ္တေ တေဘျး သရွွဝၖတ္တာန္တံ ကထယာမာသုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","တဒနန္တရံ တသျ ဂိဒေရီယပြဒေၑသျ စတုရ္ဒိက္သ္ထာ ဗဟဝေါ ဇနာ အတိတြသ္တာ ဝိနယေန တံ ဇဂဒုး, ဘဝါန် အသ္မာကံ နိကဋာဒ် ဝြဇတု တသ္မာတ် သ နာဝမာရုဟျ တတော ဝျာဃုဋျ ဇဂါမ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","တဒါနီံ တျက္တဘူတမနုဇသ္တေန သဟ သ္ထာတုံ ပြာရ္ထယာဉ္စကြေ ");
INSERT INTO sanbur_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","ကိန္တု တဒရ္ထမ် ဤၑွရး ကီဒၖင်္မဟာကရ္မ္မ ကၖတဝါန် ဣတိ နိဝေၑနံ ဂတွာ ဝိဇ္ဉာပယ, ယီၑုး ကထာမေတာံ ကထယိတွာ တံ ဝိသသရ္ဇ၊ တတး သ ဝြဇိတွာ ယီၑုသ္တဒရ္ထံ ယန္မဟာကရ္မ္မ စကာရ တတ် ပုရသျ သရွွတြ ပြကာၑယိတုံ ပြာရေဘေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","အထ ယီၑော် ပရာဝၖတျာဂတေ လောကာသ္တံ အာဒရေဏ ဇဂၖဟု ရျသ္မာတ္တေ သရွွေ တမပေက္ၐာဉ္စကြိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","တဒနန္တရံ ယာယီရ္နာမ္နော ဘဇနဂေဟသျဲကောဓိပ အာဂတျ ယီၑောၑ္စရဏယေား ပတိတွာ သွနိဝေၑနာဂမနာရ္ထံ တသ္မိန် ဝိနယံ စကာရ, ");
INSERT INTO sanbur_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ယတသ္တသျ ဒွါဒၑဝရ္ၐဝယသ္ကာ ကနျဲကာသီတ် သာ မၖတကလ္ပာဘဝတ်၊ တတသ္တသျ ဂမနကာလေ မာရ္ဂေ လောကာနာံ မဟာန် သမာဂမော ဗဘူဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ဒွါဒၑဝရ္ၐာဏိ ပြဒရရောဂဂြသ္တာ နာနာ ဝဲဒျဲၑ္စိကိတ္သိတာ သရွွသွံ ဝျယိတွာပိ သွာသ္ထျံ န ပြာပ္တာ ယာ ယောၐိတ် သာ ယီၑေား ပၑ္စာဒါဂတျ တသျ ဝသ္တြဂြန္ထိံ ပသ္ပရ္ၑ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","တသ္မာတ် တတ္က္ၐဏာတ် တသျာ ရက္တသြာဝေါ ရုဒ္ဓး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","တဒါနီံ ယီၑုရဝဒတ် ကေနာဟံ သ္ပၖၐ္ဋး? တတော'နေကဲရနင်္ဂီကၖတေ ပိတရသ္တသျ သင်္ဂိနၑ္စာဝဒန်, ဟေ ဂုရော လောကာ နိကဋသ္ထား သန္တသ္တဝ ဒေဟေ ဃရ္ၐယန္တိ, တထာပိ ကေနာဟံ သ္ပၖၐ္ဋဣတိ ဘဝါန် ကုတး ပၖစ္ဆတိ? ");
INSERT INTO sanbur_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","ယီၑုး ကထယာမာသ, ကေနာပျဟံ သ္ပၖၐ္ဋော, ယတော မတ္တး ၑက္တိ ရ္နိရ္ဂတေတိ မယာ နိၑ္စိတမဇ္ဉာယိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","တဒါ သာ နာရီ သွယံ န ဂုပ္တေတိ ဝိဒိတွာ ကမ္ပမာနာ သတီ တသျ သမ္မုခေ ပပါတ; ယေန နိမိတ္တေန တံ ပသ္ပရ္ၑ သ္ပရ္ၑမာတြာစ္စ ယေန ပြကာရေဏ သွသ္ထာဘဝတ် တတ် သရွွံ တသျ သာက္ၐာဒါစချော်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","တတး သ တာံ ဇဂါဒ ဟေ ကနျေ သုသ္ထိရာ ဘဝ, တဝ ဝိၑွာသသ္တွာံ သွသ္ထာမ် အကာရ္ၐီတ် တွံ က္ၐေမေဏ ယာဟိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","ယီၑောရေတဒွါကျဝဒနကာလေ တသျာဓိပတေ ရ္နိဝေၑနာတ် ကၑ္စိလ္လောက အာဂတျ တံ ဗဘာၐေ, တဝ ကနျာ မၖတာ ဂုရုံ မာ က္လိၑာန၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","ကိန္တု ယီၑုသ္တဒါကရ္ဏျာဓိပတိံ ဝျာဇဟာရ, မာ ဘဲၐီး ကေဝလံ ဝိၑွသိဟိ တသ္မာတ် သာ ဇီဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","အထ တသျ နိဝေၑနေ ပြာပ္တေ သ ပိတရံ ယောဟနံ ယာကူဗဉ္စ ကနျာယာ မာတရံ ပိတရဉ္စ ဝိနာ, အနျံ ကဉ္စန ပြဝေၐ္ဋုံ ဝါရယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","အပရဉ္စ ယေ ရုဒန္တိ ဝိလပန္တိ စ တာန် သရွွာန် ဇနာန် ဥဝါစ, ယူယံ မာ ရောဒိၐ္ဋ ကနျာ န မၖတာ နိဒြာတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","ကိန္တု သာ နိၑ္စိတံ မၖတေတိ ဇ္ဉာတွာ တေ တမုပဇဟသုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","ပၑ္စာတ် သ သရွွာန် ဗဟိး ကၖတွာ ကနျာယား ကရော် ဓၖတွာဇုဟုဝေ, ဟေ ကနျေ တွမုတ္တိၐ္ဌ, ");
INSERT INTO sanbur_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","တသ္မာတ် တသျား ပြာဏေၐု ပုနရာဂတေၐု သာ တတ္က္ၐဏာဒ် ဥတ္တသျော်၊ တဒါနီံ တသျဲ ကိဉ္စိဒ် ဘက္ၐျံ ဒါတုမ် အာဒိဒေၑ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","တတသ္တသျား ပိတရော် ဝိသ္မယံ ဂတော် ကိန္တု သ တာဝါဒိဒေၑ ဃဋနာယာ ဧတသျား ကထာံ ကသ္မဲစိဒပိ မာ ကထယတံ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","တတး ပရံ သ ဒွါဒၑၑိၐျာနာဟူယ ဘူတာန် တျာဇယိတုံ ရောဂါန် ပြတိကရ္တ္တုဉ္စ တေဘျး ၑက္တိမာဓိပတျဉ္စ ဒဒေါ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","အပရဉ္စ ဤၑွရီယရာဇျသျ သုသံဝါဒံ ပြကာၑယိတုမ် ရောဂိဏာမာရောဂျံ ကရ္တ္တုဉ္စ ပြေရဏကာလေ တာန် ဇဂါဒ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ယာတြာရ္ထံ ယၐ္ဋိ ရွသ္တြပုဋကံ ဘက္ၐျံ မုဒြာ ဒွိတီယဝသ္တြမ်, ဧၐာံ ကိမပိ မာ ဂၖဟ္လီတ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ယူယဉ္စ ယန္နိဝေၑနံ ပြဝိၑထ နဂရတျာဂပရျျနတံ တန္နိဝေၑနေ တိၐ္ဌတ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","တတြ ယဒိ ကသျစိတ် ပုရသျ လောကာ ယုၐ္မာကမာတိထျံ န ကုရွွန္တိ တရှိ တသ္မာန္နဂရာဒ် ဂမနကာလေ တေၐာံ ဝိရုဒ္ဓံ သာက္ၐျာရ္ထံ ယုၐ္မာကံ ပဒဓူလီး သမ္ပာတယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","အထ တေ ပြသ္ထာယ သရွွတြ သုသံဝါဒံ ပြစာရယိတုံ ပီဍိတာန် သွသ္ထာန် ကရ္တ္တုဉ္စ ဂြာမေၐု ဘြမိတုံ ပြာရေဘိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ဧတရှိ ဟေရောဒ် ရာဇာ ယီၑေား သရွွကရ္မ္မဏာံ ဝါရ္တ္တာံ ၑြုတွာ ဘၖၑမုဒွိဝိဇေ ");
INSERT INTO sanbur_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ယတး ကေစိဒူစုရျောဟန် ၑ္မၑာနာဒုဒတိၐ္ဌတ်၊ ကေစိဒူစုး, ဧလိယော ဒရ္ၑနံ ဒတ္တဝါန်; ဧဝမနျလောကာ ဦစုး ပူရွွီယး ကၑ္စိဒ် ဘဝိၐျဒွါဒီ သမုတ္ထိတး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","ကိန္တု ဟေရောဒုဝါစ ယောဟနး ၑိရော'ဟမဆိနဒမ် ဣဒါနီံ ယသျေဒၖက္ကရ္မ္မဏာံ ဝါရ္တ္တာံ ပြာပ္နောမိ သ ကး? အထ သ တံ ဒြၐ္ဋုမ် အဲစ္ဆတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","အနန္တရံ ပြေရိတား ပြတျာဂတျ ယာနိ ယာနိ ကရ္မ္မာဏိ စကြုသ္တာနိ ယီၑဝေ ကထယာမာသုး တတး သ တာန် ဗဲတ္သဲဒါနာမကနဂရသျ ဝိဇနံ သ္ထာနံ နီတွာ ဂုပ္တံ ဇဂါမ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ပၑ္စာလ် လောကာသ္တဒ် ဝိဒိတွာ တသျ ပၑ္စာဒ် ယယုး; တတး သ တာန် နယန် ဤၑွရီယရာဇျသျ ပြသင်္ဂမုက္တဝါန်, ယေၐာံ စိကိတ္သယာ ပြယောဇနမ် အာသီတ် တာန် သွသ္ထာန် စကာရ စ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","အပရဉ္စ ဒိဝါဝသန္နေ သတိ ဒွါဒၑၑိၐျာ ယီၑောရန္တိကမ် ဧတျ ကထယာမာသုး, ဝယမတြ ပြာန္တရသ္ထာနေ တိၐ္ဌာမး, တတော နဂရာဏိ ဂြာမာဏိ ဂတွာ ဝါသသ္ထာနာနိ ပြာပျ ဘက္ၐျဒြဝျာဏိ ကြေတုံ ဇနနိဝဟံ ဘဝါန် ဝိသၖဇတု၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","တဒါ သ ဥဝါစ, ယူယမေဝ တာန် ဘေဇယဓွံ; တတသ္တေ ပြောစုရသ္မာကံ နိကဋေ ကေဝလံ ပဉ္စ ပူပါ ဒွေါ် မတ္သျော် စ ဝိဒျန္တေ, အတဧဝ သ္ထာနာန္တရမ် ဣတွာ နိမိတ္တမေတေၐာံ ဘက္ၐျဒြဝျေၐု န ကြီတေၐု န ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","တတြ ပြာယေဏ ပဉ္စသဟသြာဏိ ပုရုၐာ အာသန်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","တဒါ သ ၑိၐျာန် ဇဂါဒ ပဉ္စာၑတ် ပဉ္စာၑဇ္ဇနဲး ပံက္တီကၖတျ တာနုပဝေၑယတ, တသ္မာတ် တေ တဒနုသာရေဏ သရွွလောကာနုပဝေၑယာပါသုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","တတး သ တာန် ပဉ္စ ပူပါန် မီနဒွယဉ္စ ဂၖဟီတွာ သွရ္ဂံ ဝိလောကျေၑွရဂုဏာန် ကီရ္တ္တယာဉ္စကြေ ဘင်္က္တာ စ လောကေဘျး ပရိဝေၐဏာရ္ထံ ၑိၐျေၐု သမရ္ပယာမ္ဗဘူဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","တတး သရွွေ ဘုက္တွာ တၖပ္တိံ ဂတာ အဝၑိၐ္ဋာနာဉ္စ ဒွါဒၑ ဍလ္လကာန် သံဇဂၖဟုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","အထဲကဒါ နိရ္ဇနေ ၑိၐျဲး သဟ ပြာရ္ထနာကာလေ တာန် ပပြစ္ဆ, လောကာ မာံ ကံ ဝဒန္တိ? ");
INSERT INTO sanbur_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","တတသ္တေ ပြာစုး, တွာံ ယောဟန္မဇ္ဇကံ ဝဒန္တိ; ကေစိတ် တွာမ် ဧလိယံ ဝဒန္တိ, ပူရွွကာလိကး ကၑ္စိဒ် ဘဝိၐျဒွါဒီ ၑ္မၑာနာဒ် ဥဒတိၐ္ဌဒ် ဣတျပိ ကေစိဒ် ဝဒန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","တဒါ သ ဥဝါစ, ယူယံ မာံ ကံ ဝဒထ? တတး ပိတရ ဥက္တဝါန် တွမ် ဤၑွရာဘိၐိက္တး ပုရုၐး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","တဒါ သ တာန် ဒၖဎမာဒိဒေၑ, ကထာမေတာံ ကသ္မဲစိဒပိ မာ ကထယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","သ ပုနရုဝါစ, မနုၐျပုတြေဏ ဝဟုယာတနာ ဘောက္တဝျား ပြာစီနလောကဲး ပြဓာနယာဇကဲရဓျာပကဲၑ္စ သောဝဇ္ဉာယ ဟန္တဝျး ကိန္တု တၖတီယဒိဝသေ ၑ္မၑာနာတ် တေနောတ္ထာတဝျမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","အပရံ သ သရွွာနုဝါစ, ကၑ္စိဒ် ယဒိ မမ ပၑ္စာဒ် ဂန္တုံ ဝါဉ္ဆတိ တရှိ သ သွံ ဒါမျတု, ဒိနေ ဒိနေ ကြုၑံ ဂၖဟီတွာ စ မမ ပၑ္စာဒါဂစ္ဆတု၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ယတော ယး ကၑ္စိတ် သွပြာဏာန် ရိရက္ၐိၐတိ သ တာန် ဟာရယိၐျတိ, ယး ကၑ္စိန် မဒရ္ထံ ပြာဏာန် ဟာရယိၐျတိ သ တာန် ရက္ၐိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","ကၑ္စိဒ် ယဒိ သရွွံ ဇဂတ် ပြာပ္နောတိ ကိန္တု သွပြာဏာန် ဟာရယတိ သွယံ ဝိနၑျတိ စ တရှိ တသျ ကော လာဘး? ");
INSERT INTO sanbur_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","ပုန ရျး ကၑ္စိန် မာံ မမ ဝါကျံ ဝါ လဇ္ဇာသ္ပဒံ ဇာနာတိ မနုၐျပုတြော ယဒါ သွသျ ပိတုၑ္စ ပဝိတြာဏာံ ဒူတာနာဉ္စ တေဇောဘိး ပရိဝေၐ္ဋိတ အာဂမိၐျတိ တဒါ သောပိ တံ လဇ္ဇာသ္ပဒံ ဇ္ဉာသျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","ကိန္တု ယုၐ္မာနဟံ ယထာရ္ထံ ဝဒါမိ, ဤၑွရီယရာဇတွံ န ဒၖၐ္ဋဝါ မၖတျုံ နာသွာဒိၐျန္တေ, ဧတာဒၖၑား ကိယန္တော လောကာ အတြ သ္ထနေ'ပိ ဒဏ္ဍာယမာနား သန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ဧတဒါချာနကထနာတ် ပရံ ပြာယေဏာၐ္ဋသု ဒိနေၐု ဂတေၐု သ ပိတရံ ယောဟနံ ယာကူဗဉ္စ ဂၖဟီတွာ ပြာရ္ထယိတုံ ပရွွတမေကံ သမာရုရောဟ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","အထ တသျ ပြာရ္ထနကာလေ တသျ မုခါကၖတိရနျရူပါ ဇာတာ, တဒီယံ ဝသ္တြမုဇ္ဇွလၑုက္လံ ဇာတံ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","အပရဉ္စ မူသာ ဧလိယၑ္စောဘော် တေဇသွိနော် ဒၖၐ္ဋော် ");
INSERT INTO sanbur_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","တော် တေန ယိရူၑာလမ္ပုရေ ယော မၖတျုး သာဓိၐျတေ တဒီယာံ ကထာံ တေန သာရ္ဒ္ဓံ ကထယိတုမ် အာရေဘာတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","တဒါ ပိတရာဒယး သွသျ သင်္ဂိနော နိဒြယာကၖၐ္ဋာ အာသန် ကိန္တု ဇာဂရိတွာ တသျ တေဇသ္တေန သာရ္ဒ္ဓမ် ဥတ္တိၐ္ဌန္တော် ဇနော် စ ဒဒၖၑုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","အထ တယောရုဘယော ရ္ဂမနကာလေ ပိတရော ယီၑုံ ဗဘာၐေ, ဟေ ဂုရော'သ္မာကံ သ္ထာနေ'သ္မိန် သ္ထိတိး ၑုဘာ, တတ ဧကာ တွဒရ္ထာ, ဧကာ မူသာရ္ထာ, ဧကာ ဧလိယာရ္ထာ, ဣတိ တိသြး ကုဋျောသ္မာဘိ ရ္နိရ္မ္မီယန္တာံ, ဣမာံ ကထာံ သ န ဝိဝိစျ ကထယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","အပရဉ္စ တဒွါကျဝဒနကာလေ ပယောဒ ဧက အာဂတျ တေၐာမုပရိ ဆာယာံ စကာရ, တတသ္တန္မဓျေ တယေား ပြဝေၑာတ် တေ ၑၑင်္ကိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","တဒါ တသ္မာတ် ပယောဒါဒ် ဣယမာကာၑီယာ ဝါဏီ နိရ္ဇဂါမ, မမာယံ ပြိယး ပုတြ ဧတသျ ကထာယာံ မနော နိဓတ္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ဣတိ ၑဗ္ဒေ ဇာတေ တေ ယီၑုမေကာကိနံ ဒဒၖၑုး ကိန္တု တေ တဒါနီံ တသျ ဒရ္ၑနသျ ဝါစမေကာမပိ နောက္တွာ မနးသု သ္ထာပယာမာသုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","ပရေ'ဟနိ တေၐု တသ္မာစ္ဆဲလာဒ် အဝရူဎေၐု တံ သာက္ၐာတ် ကရ္တ္တုံ ဗဟဝေါ လောကာ အာဇဂ္မုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","တေၐာံ မဓျာဒ် ဧကော ဇန ဥစ္စဲရုဝါစ, ဟေ ဂုရော အဟံ ဝိနယံ ကရောမိ မမ ပုတြံ ပြတိ ကၖပါဒၖၐ္ဋိံ ကရောတု, မမ သ ဧဝဲကး ပုတြး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ဘူတေန ဓၖတး သန် သံ ပြသဘံ စီစ္ဆဗ္ဒံ ကရောတိ တန္မုခါတ် ဖေဏာ နိရ္ဂစ္ဆန္တိ စ, ဘူတ ဣတ္ထံ ဝိဒါရျျ က္လိၐ္ဋွာ ပြာယၑသ္တံ န တျဇတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","တသ္မာတ် တံ ဘူတံ တျာဇယိတုံ တဝ ၑိၐျသမီပေ နျဝေဒယံ ကိန္တု တေ န ၑေကုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","တဒါ ယီၑုရဝါဒီတ်, ရေ အာဝိၑွာသိန် ဝိပထဂါမိန် ဝံၑ ကတိကာလာန် ယုၐ္မာဘိး သဟ သ္ထာသျာမျဟံ ယုၐ္မာကမ် အာစရဏာနိ စ သဟိၐျေ? တဝ ပုတြမိဟာနယ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","တတသ္တသ္မိန္နာဂတမာတြေ ဘူတသ္တံ ဘူမော် ပါတယိတွာ ဝိဒဒါရ; တဒါ ယီၑုသ္တမမေဓျံ ဘူတံ တရ္ဇယိတွာ ဗာလကံ သွသ္ထံ ကၖတွာ တသျ ပိတရိ သမရ္ပယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ဤၑွရသျ မဟာၑက္တိမ် ဣမာံ ဝိလောကျ သရွွေ စမစ္စကြုး; ဣတ္ထံ ယီၑေား သရွွာဘိး ကြိယာဘိး သရွွဲရ္လောကဲရာၑ္စရျျေ မနျမာနေ သတိ သ ၑိၐျာန် ဗဘာၐေ, ");
INSERT INTO sanbur_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","ကထေယံ ယုၐ္မာကံ ကရ္ဏေၐု ပြဝိၑတု, မနုၐျပုတြော မနုၐျာဏာံ ကရေၐု သမရ္ပယိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","ကိန္တု တေ တာံ ကထာံ န ဗုဗုဓိရေ, သ္ပၐ္ဋတွာဘာဝါတ် တသျာ အဘိပြာယသ္တေၐာံ ဗောဓဂမျော န ဗဘူဝ; တသျာ အာၑယး က ဣတျပိ တေ ဘယာတ် ပြၐ္ဋုံ န ၑေကုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","တဒနန္တရံ တေၐာံ မဓျေ ကး ၑြေၐ္ဌး ကထာမေတာံ ဂၖဟီတွာ တေ မိထော ဝိဝါဒံ စကြုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","တတော ယီၑုသ္တေၐာံ မနောဘိပြာယံ ဝိဒိတွာ ဗာလကမေကံ ဂၖဟီတွာ သွသျ နိကဋေ သ္ထာပယိတွာ တာန် ဇဂါဒ, ");
INSERT INTO sanbur_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ယော ဇနော မမ နာမ္နာသျ ဗာလာသျာတိထျံ ဝိဒဓာတိ သ မမာတိထျံ ဝိဒဓာတိ, ယၑ္စ မမာတိထျံ ဝိဒဓာတိ သ မမ ပြေရကသျာတိထျံ ဝိဒဓာတိ, ယုၐ္မာကံ မဓျေယး သွံ သရွွသ္မာတ် က္ၐုဒြံ ဇာနီတေ သ ဧဝ ၑြေၐ္ဌော ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","အပရဉ္စ ယောဟန် ဝျာဇဟာရ ဟေ ပြဘေा တဝ နာမ္နာ ဘူတာန် တျာဇယန္တံ မာနုၐမ် ဧကံ ဒၖၐ္ဋဝန္တော ဝယံ, ကိန္တွသ္မာကမ် အပၑ္စာဒ် ဂါမိတွာတ် တံ နျၐေဓာမ်၊ တဒါနီံ ယီၑုရုဝါစ, ");
INSERT INTO sanbur_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","တံ မာ နိၐေဓတ, ယတော ယော ဇနောသ္မာကံ န ဝိပက္ၐး သ ဧဝါသ္မာကံ သပက္ၐော ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","အနန္တရံ တသျာရောဟဏသမယ ဥပသ္ထိတေ သ သ္ထိရစေတာ ယိရူၑာလမံ ပြတိ ယာတြာံ ကရ္တ္တုံ နိၑ္စိတျာဂြေ ဒူတာန် ပြေၐယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","တသ္မာတ် တေ ဂတွာ တသျ ပြယောဇနီယဒြဝျာဏိ သံဂြဟီတုံ ၑောမိရောဏီယာနာံ ဂြာမံ ပြဝိဝိၑုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ကိန္တု သ ယိရူၑာလမံ နဂရံ ယာတိ တတော ဟေတော ရ္လောကာသ္တသျာတိထျံ န စကြုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","အတဧဝ ယာကူဗျောဟနော် တသျ ၑိၐျော် တဒ် ဒၖၐ္ဋွာ ဇဂဒတုး, ဟေ ပြဘော ဧလိယော ယထာ စကာရ တထာ ဝယမပိ ကိံ ဂဂဏာဒ် အာဂန္တုမ် ဧတာန် ဘသ္မီကရ္တ္တုဉ္စ ဝဟ္နိမာဇ္ဉာပယာမး? ဘဝါန် ကိမိစ္ဆတိ? ");
INSERT INTO sanbur_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","ကိန္တု သ မုခံ ပရာဝရ္တျ တာန် တရ္ဇယိတွာ ဂဒိတဝါန် ယုၐ္မာကံ မနောဘာဝး ကး, ဣတိ ယူယံ န ဇာနီထ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","မနုဇသုတော မနုဇာနာံ ပြာဏာန် နာၑယိတုံ နာဂစ္ဆတ်, ကိန္တု ရက္ၐိတုမ် အာဂစ္ဆတ်၊ ပၑ္စာဒ် ဣတရဂြာမံ တေ ယယုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","တဒနန္တရံ ပထိ ဂမနကာလေ ဇန ဧကသ္တံ ဗဘာၐေ, ဟေ ပြဘော ဘဝါန် ယတြ ယာတိ ဘဝတာ သဟာဟမပိ တတြ ယာသျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","တဒါနီံ ယီၑုသ္တမုဝါစ, ဂေါမာယူနာံ ဂရ္တ္တာ အာသတေ, ဝိဟာယသီယဝိဟဂါाနာံ နီဍာနိ စ သန္တိ, ကိန္တု မာနဝတနယသျ ၑိရး သ္ထာပယိတုံ သ္ထာနံ နာသ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","တတး ပရံ သ ဣတရဇနံ ဇဂါဒ, တွံ မမ ပၑ္စာဒ် ဧဟိ; တတး သ ဥဝါစ, ဟေ ပြဘော ပူရွွံ ပိတရံ ၑ္မၑာနေ သ္ထာပယိတုံ မာမာဒိၑတု၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","တဒါ ယီၑုရုဝါစ, မၖတာ မၖတာန် ၑ္မၑာနေ သ္ထာပယန္တု ကိန္တု တွံ ဂတွေၑွရီယရာဇျသျ ကထာံ ပြစာရယ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","တတောနျး ကထယာမာသ, ဟေ ပြဘော မယာပိ ဘဝတး ပၑ္စာဒ် ဂံသျတေ, ကိန္တု ပူရွွံ မမ နိဝေၑနသျ ပရိဇနာနာမ် အနုမတိံ ဂြဟီတုမ် အဟမာဒိၑျဲ ဘဝတာ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","တဒါနီံ ယီၑုသ္တံ ပြောက္တဝါန်, ယော ဇနော လာင်္ဂလေ ကရမရ္ပယိတွာ ပၑ္စာတ် ပၑျတိ သ ဤၑွရီယရာဇျံ နာရှတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","တတး ပရံ ပြဘုရပရာန် သပ္တတိၑိၐျာန် နိယုဇျ သွယံ ယာနိ နဂရာဏိ ယာနိ သ္ထာနာနိ စ ဂမိၐျတိ တာနိ နဂရာဏိ တာနိ သ္ထာနာနိ စ ပြတိ ဒွေါ် ဒွေါ် ဇနော် ပြဟိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","တေဘျး ကထယာမာသ စ ၑသျာနိ ဗဟူနီတိ သတျံ ကိန္တု ဆေဒကာ အလ္ပေ; တသ္မာဒ္ဓေတေား ၑသျက္ၐေတြေ ဆေဒကာန် အပရာနပိ ပြေၐယိတုံ က္ၐေတြသွာမိနံ ပြာရ္ထယဓွံ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","ယူယံ ယာတ, ပၑျတ, ဝၖကာဏာံ မဓျေ မေၐၑာဝကာနိဝ ယုၐ္မာန် ပြဟိဏောမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","ယူယံ က္ၐုဒြံ မဟဒ် ဝါ ဝသနသမ္ပုဋကံ ပါဒုကာၑ္စ မာ ဂၖဟ္လီတ, မာရ္ဂမဓျေ ကမပိ မာ နမတ စ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","အပရဉ္စ ယူယံ ယဒ် ယတ် နိဝေၑနံ ပြဝိၑထ တတြ နိဝေၑနသျာသျ မင်္ဂလံ ဘူယာဒိတိ ဝါကျံ ပြထမံ ဝဒတ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","တသ္မာတ် တသ္မိန် နိဝေၑနေ ယဒိ မင်္ဂလပါတြံ သ္ထာသျတိ တရှိ တန္မင်္ဂလံ တသျ ဘဝိၐျတိ, နောစေတ် ယုၐ္မာန် ပြတိ ပရာဝရ္တ္တိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","အပရဉ္စ တေ ယတ္ကိဉ္စိဒ် ဒါသျန္တိ တဒေဝ ဘုက္တွာ ပီတွာ တသ္မိန္နိဝေၑနေ သ္ထာသျထ; ယတး ကရ္မ္မကာရီ ဇနော ဘၖတိမ် အရှတိ; ဂၖဟာဒ် ဂၖဟံ မာ ယာသျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","အနျစ္စ ယုၐ္မာသု ကိမပိ နဂရံ ပြဝိၐ္ဋေၐု လောကာ ယဒိ ယုၐ္မာကမ် အာတိထျံ ကရိၐျန္တိ, တရှိ ယတ် ခါဒျမ် ဥပသ္ထာသျန္တိ တဒေဝ ခါဒိၐျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","တန္နဂရသ္ထာန် ရောဂိဏး သွသ္ထာန် ကရိၐျထ, ဤၑွရီယံ ရာဇျံ ယုၐ္မာကမ် အန္တိကမ် အာဂမတ် ကထာမေတာဉ္စ ပြစာရယိၐျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","ကိန္တု ကိမပိ ပုရံ ယုၐ္မာသု ပြဝိၐ္ဋေၐု လောကာ ယဒိ ယုၐ္မာကမ် အာတိထျံ န ကရိၐျန္တိ, တရှိ တသျ နဂရသျ ပန္ထာနံ ဂတွာ ကထာမေတာံ ဝဒိၐျထ, ");
INSERT INTO sanbur_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","ယုၐ္မာကံ နဂရီယာ ယာ ဓူလျော'သ္မာသု သမလဂန် တာ အပိ ယုၐ္မာကံ ပြာတိကူလျေန သာက္ၐျာရ္ထံ သမ္ပာတယာမး; တထာပီၑွရရာဇျံ ယုၐ္မာကံ သမီပမ် အာဂတမ် ဣတိ နိၑ္စိတံ ဇာနီတ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","အဟံ ယုၐ္မဘျံ ယထာရ္ထံ ကထယာမိ, ဝိစာရဒိနေ တသျ နဂရသျ ဒၑာတး သိဒေါမော ဒၑာ သဟျာ ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","ဟာ ဟာ ကောရာသီန် နဂရ, ဟာ ဟာ ဗဲတ္သဲဒါနဂရ ယုဝယောရ္မဓျေ ယာဒၖၑာနိ အာၑ္စရျျာဏိ ကရ္မ္မာဏျကြိယန္တ, တာနိ ကရ္မ္မာဏိ ယဒိ သောရသီဒေါနော ရ္နဂရယောရကာရိၐျန္တ, တဒါ ဣတော ဗဟုဒိနပူရွွံ တန္နိဝါသိနး ၑဏဝသ္တြာဏိ ပရိဓာယ ဂါတြေၐု ဘသ္မ ဝိလိပျ သမုပဝိၑျ သမခေတ္သျန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","အတော ဝိစာရဒိဝသေ ယုၐ္မာကံ ဒၑာတး သောရသီဒေါန္နိဝါသိနာံ ဒၑာ သဟျာ ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ဟေ ကဖရ္နာဟူမ်, တွံ သွရ္ဂံ ယာဝဒ် ဥန္နတာ ကိန္တု နရကံ ယာဝတ် နျဂ္ဘဝိၐျသိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ယော ဇနော ယုၐ္မာကံ ဝါကျံ ဂၖဟ္လာတိ သ မမဲဝ ဝါကျံ ဂၖဟ္လာတိ; ကိဉ္စ ယော ဇနော ယုၐ္မာကမ် အဝဇ္ဉာံ ကရောတိ သ မမဲဝါဝဇ္ဉာံ ကရောတိ; ယော ဇနော မမာဝဇ္ဉာံ ကရောတိ စ သ မတ္ပြေရကသျဲဝါဝဇ္ဉာံ ကရောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","အထ တေ သပ္တတိၑိၐျာ အာနန္ဒေန ပြတျာဂတျ ကထယာမာသုး, ဟေ ပြဘော ဘဝတော နာမ္နာ ဘူတာ အပျသ္မာကံ ဝၑီဘဝန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","တဒါနီံ သ တာန် ဇဂါဒ, ဝိဒျုတမိဝ သွရ္ဂာတ် ပတန္တံ ၑဲတာနမ် အဒရ္ၑမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","ပၑျတ သရ္ပာန် ဝၖၑ္စိကာန် ရိပေါး သရွွပရာကြမာံၑ္စ ပဒတလဲ ရ္ဒလယိတုံ ယုၐ္မဘျံ ၑက္တိံ ဒဒါမိ တသ္မာဒ် ယုၐ္မာကံ ကာပိ ဟာနိ ရ္န ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","ဘူတာ ယုၐ္မာကံ ဝၑီဘဝန္တိ, ဧတန္နိမိတ္တတ် မာ သမုလ္လသတ, သွရ္ဂေ ယုၐ္မာကံ နာမာနိ လိခိတာနိ သန္တီတိ နိမိတ္တံ သမုလ္လသတ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","တဒ္ဃဋိကာယာံ ယီၑု ရ္မနသိ ဇာတာဟ္လာဒး ကထယာမာသ ဟေ သွရ္ဂပၖထိဝျောရေကာဓိပတေ ပိတသ္တွံ ဇ္ဉာနဝတာံ ဝိဒုၐာဉ္စ လောကာနာံ ပုရသ္တာတ် သရွွမေတဒ် အပြကာၑျ ဗာလကာနာံ ပုရသ္တာတ် ပြာကာၑယ ဧတသ္မာဒ္ဓေတောသ္တွာံ ဓနျံ ဝဒါမိ, ဟေ ပိတရိတ္ထံ ဘဝတု ယဒ် ဧတဒေဝ တဝ ဂေါစရ ဥတ္တမမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","ပိတြာ သရွွာဏိ မယိ သမရ္ပိတာနိ ပိတရံ ဝိနာ ကောပိ ပုတြံ န ဇာနာတိ ကိဉ္စ ပုတြံ ဝိနာ ယသ္မဲ ဇနာယ ပုတြသ္တံ ပြကာၑိတဝါန် တဉ္စ ဝိနာ ကောပိ ပိတရံ န ဇာနာတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","တပး ပရံ သ ၑိၐျာန် ပြတိ ပရာဝၖတျ ဂုပ္တံ ဇဂါဒ, ယူယမေတာနိ သရွွာဏိ ပၑျထ တတော ယုၐ္မာကံ စက္ၐူံၐိ ဓနျာနိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ယုၐ္မာနဟံ ဝဒါမိ, ယူယံ ယာနိ သရွွာဏိ ပၑျထ တာနိ ဗဟဝေါ ဘဝိၐျဒွါဒိနော ဘူပတယၑ္စ ဒြၐ္ဋုမိစ္ဆန္တောပိ ဒြၐ္ဋုံ န ပြာပ္နုဝန်, ယုၐ္မာဘိ ရျာ ယား ကထာၑ္စ ၑြူယန္တေ တား ၑြောတုမိစ္ဆန္တောပိ ၑြောတုံ နာလဘန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","အနန္တရမ် ဧကော ဝျဝသ္ထာပက ဥတ္ထာယ တံ ပရီက္ၐိတုံ ပပြစ္ဆ, ဟေ ဥပဒေၑက အနန္တာယုၐး ပြာပ္တယေ မယာ ကိံ ကရဏီယံ? ");
INSERT INTO sanbur_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","ယီၑုး ပြတျုဝါစ, အတြာရ္ထေ ဝျဝသ္ထာယာံ ကိံ လိခိတမသ္တိ? တွံ ကီဒၖက် ပဌသိ? ");
INSERT INTO sanbur_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","တတး သောဝဒတ်, တွံ သရွွာန္တးကရဏဲး သရွွပြာဏဲး သရွွၑက္တိဘိး သရွွစိတ္တဲၑ္စ ပြဘော် ပရမေၑွရေ ပြေမ ကုရု, သမီပဝါသိနိ သွဝတ် ပြေမ ကုရု စ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","တဒါ သ ကထယာမာသ, တွံ ယထာရ္ထံ ပြတျဝေါစး, ဣတ္ထမ် အာစရ တေနဲဝ ဇီဝိၐျသိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","ကိန္တု သ ဇနး သွံ နိရ္ဒ္ဒေါၐံ ဇ္ဉာပယိတုံ ယီၑုံ ပပြစ္ဆ, မမ သမီပဝါသီ ကး? တတော ယီၑုး ပြတျုဝါစ, ");
INSERT INTO sanbur_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ဧကော ဇနော ယိရူၑာလမ္ပုရာဒ် ယိရီဟောပုရံ ယာတိ, ဧတရှိ ဒသျူနာံ ကရေၐု ပတိတေ တေ တသျ ဝသ္တြာဒိကံ ဟၖတဝန္တး တမာဟတျ မၖတပြာယံ ကၖတွာ တျက္တွာ ယယုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","အကသ္မာဒ် ဧကော ယာဇကသ္တေန မာရ္ဂေဏ ဂစ္ဆန် တံ ဒၖၐ္ဋွာ မာရ္ဂာနျပါရ္ၑွေန ဇဂါမ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ဣတ္ထမ် ဧကော လေဝီယသ္တတ္သ္ထာနံ ပြာပျ တသျာန္တိကံ ဂတွာ တံ ဝိလောကျာနျေန ပါရ္ၑွေန ဇဂါမ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","ကိန္တွေကး ၑောမိရောဏီယော ဂစ္ဆန် တတ္သ္ထာနံ ပြာပျ တံ ဒၖၐ္ဋွာဒယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","တသျာန္တိကံ ဂတွာ တသျ က္ၐတေၐု တဲလံ ဒြာက္ၐာရသဉ္စ ပြက္ၐိပျ က္ၐတာနိ ဗဒ္ဓွာ နိဇဝါဟနောပရိ တမုပဝေၑျ ပြဝါသီယဂၖဟမ် အာနီယ တံ သိၐေဝေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","ပရသ္မိန် ဒိဝသေ နိဇဂမနကာလေ ဒွေါ် မုဒြာပါဒေါ် တဒ္ဂၖဟသွာမိနေ ဒတ္တွာဝဒတ် ဇနမေနံ သေဝသွ တတြ ယော'ဓိကော ဝျယော ဘဝိၐျတိ တမဟံ ပုနရာဂမနကာလေ ပရိၑောတ္သျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","ဧၐာံ တြယာဏာံ မဓျေ တသျ ဒသျုဟသ္တပတိတသျ ဇနသျ သမီပဝါသီ ကး? တွယာ ကိံ ဗုဓျတေ? ");
INSERT INTO sanbur_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","တတး သ ဝျဝသ္ထာပကး ကထယာမာသ ယသ္တသ္မိန် ဒယာံ စကာရ၊ တဒါ ယီၑုး ကထယာမာသ တွမပိ ဂတွာ တထာစရ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","တတး ပရံ တေ ဂစ္ဆန္တ ဧကံ ဂြာမံ ပြဝိဝိၑုး; တဒါ မရ္ထာနာမာ သ္တြီ သွဂၖဟေ တသျာတိထျံ စကာရ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","တသ္မာတ် မရိယမ် နာမဓေယာ တသျာ ဘဂိနီ ယီၑေား ပဒသမီပ ဥဝဝိၑျ တသျောပဒေၑကထာံ ၑြောတုမာရေဘေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","ကိန္တု မရ္ထာ နာနာပရိစရျျာယာံ ဝျဂြာ ဗဘူဝ တသ္မာဒ္ဓေတောသ္တသျ သမီပမာဂတျ ဗဘာၐေ; ဟေ ပြဘော မမ ဘဂိနီ ကေဝလံ မမောပရိ သရွွကရ္မ္မဏာံ ဘာရမ် အရ္ပိတဝတီ တတြ ဘဝတာ ကိဉ္စိဒပိ န မနော နိဓီယတေ ကိမ်? မမ သာဟာယျံ ကရ္တ္တုံ ဘဝါန် တာမာဒိၑတု၊ ");
INSERT INTO sanbur_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","တတော ယီၑုး ပြတျုဝါစ ဟေ မရ္ထေ ဟေ မရ္ထေ, တွံ နာနာကာရျျေၐု စိန္တိတဝတီ ဝျဂြာ စာသိ, ");
INSERT INTO sanbur_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ကိန္တု ပြယောဇနီယမ် ဧကမာတြမ် အာသ္တေ၊ အပရဉ္စ ယမုတ္တမံ ဘာဂံ ကောပိ ဟရ္တ္တုံ န ၑက္နောတိ သဧဝ မရိယမာ ဝၖတး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","အနန္တရံ သ ကသ္မိံၑ္စိတ် သ္ထာနေ ပြာရ္ထယတ တတ္သမာပ္တော် သတျာံ တသျဲကး ၑိၐျသ္တံ ဇဂါဒ ဟေ ပြဘော ယောဟန် ယထာ သွၑိၐျာန် ပြာရ္ထယိတုမ် ဥပဒိၐ္ဋဝါန် တထာ ဘဝါနပျသ္မာန် ဥပဒိၑတု၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","တသ္မာတ် သ ကထယာမာသ, ပြာရ္ထနကာလေ ယူယမ် ဣတ္ထံ ကထယဓွံ, ဟေ အသ္မာကံ သွရ္ဂသ္ထပိတသ္တဝ နာမ ပူဇျံ ဘဝတု; တဝ ရာဇတွံ ဘဝတု; သွရ္ဂေ ယထာ တထာ ပၖထိဝျာမပိ တဝေစ္ဆယာ သရွွံ ဘဝတု၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ပြတျဟမ် အသ္မာကံ ပြယောဇနီယံ ဘောဇျံ ဒေဟိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ယထာ ဝယံ သရွွာန် အပရာဓိနး က္ၐမာမဟေ တထာ တွမပိ ပါပါနျသ္မာကံ က္ၐမသွ၊ အသ္မာန် ပရီက္ၐာံ မာနယ ကိန္တု ပါပါတ္မနော ရက္ၐ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","ပၑ္စာတ် သောပရမပိ ကထိတဝါန် ယဒိ ယုၐ္မာကံ ကသျစိဒ် ဗန္ဓုသ္တိၐ္ဌတိ နိၑီထေ စ တသျ သမီပံ သ ဂတွာ ဝဒတိ, ");
INSERT INTO sanbur_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ဟေ ဗန္ဓော ပထိက ဧကော ဗန္ဓု ရ္မမ နိဝေၑနမ် အာယာတး ကိန္တု တသျာတိထျံ ကရ္တ္တုံ မမာန္တိကေ ကိမပိ နာသ္တိ, အတဧဝ ပူပတြယံ မဟျမ် ၒဏံ ဒေဟိ; ");
INSERT INTO sanbur_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","တဒါ သ ယဒိ ဂၖဟမဓျာတ် ပြတိဝဒတိ မာံ မာ က္လိၑာန, ဣဒါနီံ ဒွါရံ ရုဒ္ဓံ ၑယနေ မယာ သဟ ဗာလကာၑ္စ တိၐ္ဌန္တိ တုဘျံ ဒါတုမ် ဥတ္ထာတုံ န ၑက္နောမိ, ");
INSERT INTO sanbur_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","တရှိ ယုၐ္မာနဟံ ဝဒါမိ, သ ယဒိ မိတြတယာ တသ္မဲ ကိမပိ ဒါတုံ နောတ္တိၐ္ဌတိ တထာပိ ဝါရံ ဝါရံ ပြာရ္ထနာတ ဥတ္ထာပိတး သန် ယသ္မိန် တသျ ပြယောဇနံ တဒေဝ ဒါသျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","အတး ကာရဏာတ် ကထယာမိ, ယာစဓွံ တတော ယုၐ္မဘျံ ဒါသျတေ, မၖဂယဓွံ တတ ဥဒ္ဒေၑံ ပြာပ္သျထ, ဒွါရမ် အာဟတ တတော ယုၐ္မဘျံ ဒွါရံ မောက္ၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","ယော ယာစတေ သ ပြာပ္နောတိ, ယော မၖဂယတေ သ ဧဝေါဒ္ဒေၑံ ပြာပ္နောတိ, ယော ဒွါရမ် အာဟန္တိ တဒရ္ထံ ဒွါရံ မောစျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","ပုတြေဏ ပူပေ ယာစိတေ တသ္မဲ ပါၐာဏံ ဒဒါတိ ဝါ မတ္သျေ ယာစိတေ တသ္မဲ သရ္ပံ ဒဒါတိ ");
INSERT INTO sanbur_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ဝါ အဏ္ဍေ ယာစိတေ တသ္မဲ ဝၖၑ္စိကံ ဒဒါတိ ယုၐ္မာကံ မဓျေ က ဧတာဒၖၑး ပိတာသ္တေ? ");
INSERT INTO sanbur_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","တသ္မာဒေဝ ယူယမဘဒြာ အပိ ယဒိ သွသွဗာလကေဘျ ဥတ္တမာနိ ဒြဝျာဏိ ဒါတုံ ဇာနီထ တရှျသ္မာကံ သွရ္ဂသ္ထး ပိတာ နိဇယာစကေဘျး ကိံ ပဝိတြမ် အာတ္မာနံ န ဒါသျတိ? ");
INSERT INTO sanbur_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","အနန္တရံ ယီၑုနာ ကသ္မာစ္စိဒ် ဧကသ္မိန် မူကဘူတေ တျာဇိတေ သတိ သ ဘူတတျက္တော မာနုၐော ဝါကျံ ဝက္တုမ် အာရေဘေ; တတော လောကား သကလာ အာၑ္စရျျံ မေနိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ကိန္တု တေၐာံ ကေစိဒူစု ရ္ဇနောယံ ဗာလသိဗူဗာ အရ္ထာဒ် ဘူတရာဇေန ဘူတာန် တျာဇယတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","တံ ပရီက္ၐိတုံ ကေစိဒ် အာကာၑီယမ် ဧကံ စိဟ္နံ ဒရ္ၑယိတုံ တံ ပြာရ္ထယာဉ္စကြိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","တဒါ သ တေၐာံ မနးကလ္ပနာံ ဇ္ဉာတွာ ကထယာမာသ, ကသျစိဒ် ရာဇျသျ လောကာ ယဒိ ပရသ္ပရံ ဝိရုန္ဓန္တိ တရှိ တဒ် ရာဇျမ် နၑျတိ; ကေစိဒ် ဂၖဟသ္ထာ ယဒိ ပရသ္ပရံ ဝိရုန္ဓန္တိ တရှိ တေပိ နၑျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","တထဲဝ ၑဲတာနပိ သွလောကာန် ယဒိ ဝိရုဏဒ္ဓိ တဒါ တသျ ရာဇျံ ကထံ သ္ထာသျတိ? ဗာလသိဗူဗာဟံ ဘူတာန် တျာဇယာမိ ယူယမိတိ ဝဒထ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ယဒျဟံ ဗာလသိဗူဗာ ဘူတာန် တျာဇယာမိ တရှိ ယုၐ္မာကံ သန္တာနား ကေန တျာဇယန္တိ? တသ္မာတ် တဧဝ ကထာယာ ဧတသျာ ဝိစာရယိတာရော ဘဝိၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","ကိန္တု ယဒျဟမ် ဤၑွရသျ ပရာကြမေဏ ဘူတာန် တျာဇယာမိ တရှိ ယုၐ္မာကံ နိကဋမ် ဤၑွရသျ ရာဇျမဝၑျမ် ဥပတိၐ္ဌတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","ဗလဝါန် ပုမာန် သုသဇ္ဇမာနော ယတိကာလံ နိဇာဋ္ဋာလိကာံ ရက္ၐတိ တတိကာလံ တသျ ဒြဝျံ နိရုပဒြဝံ တိၐ္ဌတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","ကိန္တု တသ္မာဒ် အဓိကဗလး ကၑ္စိဒါဂတျ ယဒိ တံ ဇယတိ တရှိ ယေၐု ၑသ္တြာသ္တြေၐု တသျ ဝိၑွာသ အာသီတ် တာနိ သရွွာဏိ ဟၖတွာ တသျ ဒြဝျာဏိ ဂၖဟ္လာတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","အတး ကာရဏာဒ် ယော မမ သပက္ၐော န သ ဝိပက္ၐး, ယော မယာ သဟ န သံဂၖဟ္လာတိ သ ဝိကိရတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","အပရဉ္စ အမေဓျဘူတော မာနုၐသျာန္တရ္နိရ္ဂတျ ၑုၐ္ကသ္ထာနေ ဘြာန္တွာ ဝိၑြာမံ မၖဂယတေ ကိန္တု န ပြာပျ ဝဒတိ မမ ယသ္မာဒ် ဂၖဟာဒ် အာဂတောဟံ ပုနသ္တဒ် ဂၖဟံ ပရာဝၖတျ ယာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","တတော ဂတွာ တဒ် ဂၖဟံ မာရ္ဇိတံ ၑောဘိတဉ္စ ဒၖၐ္ဋွာ ");
INSERT INTO sanbur_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","တတ္က္ၐဏမ် အပဂတျ သွသ္မာဒပိ ဒုရ္မ္မတီန် အပရာန် သပ္တဘူတာန် သဟာနယတိ တေ စ တဒ္ဂၖဟံ ပဝိၑျ နိဝသန္တိ၊ တသ္မာတ် တသျ မနုၐျသျ ပြထမဒၑာတး ၑေၐဒၑာ ဒုးခတရာ ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","အသျား ကထာယား ကထနကာလေ ဇနတာမဓျသ္ထာ ကာစိန္နာရီ တမုစ္စဲးသွရံ ပြောဝါစ, ယာ ယောၐိတ် တွာံ ဂရ္ဗ္ဘေ'ဓာရယတ် သ္တနျမပါယယစ္စ သဲဝ ဓနျာ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","ကိန္တု သောကထယတ် ယေ ပရမေၑွရသျ ကထာံ ၑြုတွာ တဒနုရူပမ် အာစရန္တိ တဧဝ ဓနျား၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","တတး ပရံ တသျာန္တိကေ ဗဟုလောကာနာံ သမာဂမေ ဇာတေ သ ဝက္တုမာရေဘေ, အာဓုနိကာ ဒုၐ္ဋလောကာၑ္စိဟ္နံ ဒြၐ္ဋုမိစ္ဆန္တိ ကိန္တု ယူနသ္ဘဝိၐျဒွါဒိနၑ္စိဟ္နံ ဝိနာနျတ် ကိဉ္စိစ္စိဟ္နံ တာန် န ဒရ္ၑယိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","ယူနသ် တု ယထာ နီနိဝီယလောကာနာံ သမီပေ စိဟ္နရူပေါဘဝတ် တထာ ဝိဒျမာနလောကာနာမ် ဧၐာံ သမီပေ မနုၐျပုတြောပိ စိဟ္နရူပေါ ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ဝိစာရသမယေ ဣဒါနီန္တနလောကာနာံ ပြာတိကူလျေန ဒက္ၐိဏဒေၑီယာ ရာဇ္ဉီ ပြောတ္ထာယ တာန် ဒေါၐိဏး ကရိၐျတိ, ယတး သာ ရာဇ္ဉီ သုလေမာန ဥပဒေၑကထာံ ၑြောတုံ ပၖထိဝျား သီမာတ အာဂစ္ဆတ် ကိန္တု ပၑျတ သုလေမာနောပိ ဂုရုတရ ဧကော ဇနော'သ္မိန် သ္ထာနေ ဝိဒျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","အပရဉ္စ ဝိစာရသမယေ နီနိဝီယလောကာ အပိ ဝရ္တ္တမာနကာလိကာနာံ လောကာနာံ ဝဲပရီတျေန ပြောတ္ထာယ တာန် ဒေါၐိဏး ကရိၐျန္တိ, ယတော ဟေတောသ္တေ ယူနသော ဝါကျာတ် စိတ္တာနိ ပရိဝရ္တ္တယာမာသုး ကိန္တု ပၑျတ ယူနသောတိဂုရုတရ ဧကော ဇနော'သ္မိန် သ္ထာနေ ဝိဒျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","ပြဒီပံ ပြဇွာလျ ဒြောဏသျာဓး ကုတြာပိ ဂုပ္တသ္ထာနေ ဝါ ကောပိ န သ္ထာပယတိ ကိန္တု ဂၖဟပြဝေၑိဘျော ဒီပ္တိံ ဒါတံ ဒီပါဓာရောပရျျေဝ သ္ထာပယတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","ဒေဟသျ ပြဒီပၑ္စက္ၐုသ္တသ္မာဒေဝ စက္ၐု ရျဒိ ပြသန္နံ ဘဝတိ တရှိ တဝ သရွွၑရီရံ ဒီပ္တိမဒ် ဘဝိၐျတိ ကိန္တု စက္ၐု ရျဒိ မလီမသံ တိၐ္ဌတိ တရှိ သရွွၑရီရံ သာန္ဓကာရံ သ္ထာသျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","အသ္မာတ် ကာရဏာတ် တဝါန္တးသ္ထံ ဇျောတိ ရျထာန္ဓကာရမယံ န ဘဝတိ တဒရ္ထေ သာဝဓာနော ဘဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","ယတး ၑရီရသျ ကုတြာပျံၑေ သာန္ဓကာရေ န ဇာတေ သရွွံ ယဒိ ဒီပ္တိမတ် တိၐ္ဌတိ တရှိ တုဘျံ ဒီပ္တိဒါယိပြောဇ္ဇွလန် ပြဒီပ ဣဝ တဝ သဝရွၑရီရံ ဒီပ္တိမဒ် ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ဧတတ္ကထာယား ကထနကာလေ ဖိရုၑျေကော ဘေဇနာယ တံ နိမန္တြယာမာသ, တတး သ ဂတွာ ဘောက္တုမ် ဥပဝိဝေၑ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ကိန္တု ဘောဇနာတ် ပူရွွံ နာမာင်္က္ၐီတ် ဧတဒ် ဒၖၐ္ဋွာ သ ဖိရုၑျာၑ္စရျျံ မေနေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","တဒါ ပြဘုသ္တံ ပြောဝါစ ယူယံ ဖိရူၑိလောကား ပါနပါတြာဏာံ ဘောဇနပါတြာဏာဉ္စ ဗဟိး ပရိၐ္ကုရုထ ကိန္တု ယုၐ္မာကမန္တ ရ္ဒော်ရာတ္မျဲ ရ္ဒုၐ္ကြိယာဘိၑ္စ ပရိပူရ္ဏံ တိၐ္ဌတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ဟေ သရွွေ နိရ္ဗောဓာ ယော ဗဟိး သသရ္ဇ သ ဧဝ ကိမန္တ ရ္န သသရ္ဇ? ");
INSERT INTO sanbur_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","တတ ဧဝ ယုၐ္မာဘိရန္တးကရဏံ (ဤၑွရာယ) နိဝေဒျတာံ တသ္မိန် ကၖတေ ယုၐ္မာကံ သရွွာဏိ ၑုစိတာံ ယာသျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","ကိန္တု ဟန္တ ဖိရူၑိဂဏာ ယူယံ နျာယမ် ဤၑွရေ ပြေမ စ ပရိတျဇျ ပေါဒိနာယာ အရုဒါဒီနာံ သရွွေၐာံ ၑာကာနာဉ္စ ဒၑမာံၑာန် ဒတ္ထ ကိန္တု ပြထမံ ပါလယိတွာ ၑေၐသျာလင်္ဃနံ ယုၐ္မာကမ် ဥစိတမာသီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","ဟာ ဟာ ဖိရူၑိနော ယူယံ ဘဇနဂေဟေ ပြောစ္စာသနေ အာပဏေၐု စ နမသ္ကာရေၐု ပြီယဓွေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","ဝတ ကပဋိနော'ဓျာပကား ဖိရူၑိနၑ္စ လောကာယတ် ၑ္မၑာနမ် အနုပလဘျ တဒုပရိ ဂစ္ဆန္တိ ယူယမ် တာဒၖဂပြကာၑိတၑ္မၑာနဝါဒ် ဘဝထ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","တဒါနီံ ဝျဝသ္ထာပကာနာမ် ဧကာ ယီၑုမဝဒတ်, ဟေ ဥပဒေၑက ဝါကျေနေဒၖၑေနာသ္မာသွပိ ဒေါၐမ် အာရောပယသိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","တတး သ ဥဝါစ, ဟာ ဟာ ဝျဝသ္ထာပကာ ယူယမ် မာနုၐာဏာမ် ဥပရိ ဒုးသဟျာန် ဘာရာန် နျသျထ ကိန္တု သွယမ် ဧကာင်္ဂုुလျာပိ တာန် ဘာရာန် န သ္ပၖၑထ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","ဟန္တ ယုၐ္မာကံ ပူရွွပုရုၐာ ယာန် ဘဝိၐျဒွါဒိနော'ဝဓိၐုသ္တေၐာံ ၑ္မၑာနာနိ ယူယံ နိရ္မ္မာထ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","တေနဲဝ ယူယံ သွပူရွွပုရုၐာဏာံ ကရ္မ္မာဏိ သံမနျဓွေ တဒေဝ သပြမာဏံ ကုရုထ စ, ယတသ္တေ တာနဝဓိၐုး ယူယံ တေၐာံ ၑ္မၑာနာနိ နိရ္မ္မာထ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","အတဧဝ ဤၑွရသျ ၑာသ္တြေ ပြောက္တမသ္တိ တေၐာမန္တိကေ ဘဝိၐျဒွါဒိနး ပြေရိတာံၑ္စ ပြေၐယိၐျာမိ တတသ္တေ တေၐာံ ကာံၑ္စန ဟနိၐျန္တိ ကာံၑ္စန တာဍၑ္ၐျိန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ဧတသ္မာတ် ကာရဏာတ် ဟာဗိလး ၑောဏိတပါတမာရဘျ မန္ဒိရယဇ္ဉဝေဒျော ရ္မဓျေ ဟတသျ သိခရိယသျ ရက္တပါတပရျျန္တံ ");
INSERT INTO sanbur_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ဇဂတး သၖၐ္ဋိမာရဘျ ပၖထိဝျာံ ဘဝိၐျဒွါဒိနာံ ယတိရက္တပါတာ ဇာတာသ္တတီနာမ် အပရာဓဒဏ္ဍာ ဧၐာံ ဝရ္တ္တမာနလောကာနာံ ဘဝိၐျန္တိ, ယုၐ္မာနဟံ နိၑ္စိတံ ဝဒါမိ သရွွေ ဒဏ္ဍာ ဝံၑသျာသျ ဘဝိၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","ဟာ ဟာ ဝျဝသ္ထပကာ ယူယံ ဇ္ဉာနသျ ကုဉ္စိကာံ ဟၖတွာ သွယံ န ပြဝိၐ္ဋာ ယေ ပြဝေၐ္ဋုဉ္စ ပြယာသိနသ္တာနပိ ပြဝေၐ္ဋုံ ဝါရိတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","ဣတ္ထံ ကထာကထနာဒ် အဓျာပကား ဖိရူၑိနၑ္စ သတရ္ကား ");
INSERT INTO sanbur_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","သန္တသ္တမပဝဒိတုံ တသျ ကထာယာ ဒေါၐံ ဓရ္တ္တမိစ္ဆန္တော နာနာချာနကထနာယ တံ ပြဝရ္တ္တယိတုံ ကောပယိတုဉ္စ ပြာရေဘိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","တဒါနီံ လောကား သဟသြံ သဟသြမ် အာဂတျ သမုပသ္ထိတာသ္တတ ဧကဲကော 'နျေၐာမုပရိ ပတိတုမ် ဥပစကြမေ; တဒါ ယီၑုး ၑိၐျာန် ဗဘာၐေ, ယူယံ ဖိရူၑိနာံ ကိဏွရူပကာပဋျေ ဝိၑေၐေဏ သာဝဓာနာသ္တိၐ္ဌတ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","ယတော ယန္န ပြကာၑယိၐျတေ တဒါစ္ဆန္နံ ဝသ္တု ကိမပိ နာသ္တိ; တထာ ယန္န ဇ္ဉာသျတေ တဒ် ဂုပ္တံ ဝသ္တု ကိမပိ နာသ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","အန္ဓကာရေ တိၐ္ဌနတော ယား ကထာ အကထယတ တား သရွွား ကထာ ဒီပ္တော် ၑြောၐျန္တေ နိရ္ဇနေ ကရ္ဏေ စ ယဒကထယတ ဂၖဟပၖၐ္ဌာတ် တတ် ပြစာရယိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","ဟေ ဗန္ဓဝေါ ယုၐ္မာနဟံ ဝဒါမိ, ယေ ၑရီရသျ နာၑံ ဝိနာ ကိမပျပရံ ကရ္တ္တုံ န ၑကြုဝန္တိ တေဘျော မာ ဘဲၐ္ဋ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","တရှိ ကသ္မာဒ် ဘေတဝျမ် ဣတျဟံ ဝဒါမိ, ယး ၑရီရံ နာၑယိတွာ နရကံ နိက္ၐေပ္တုံ ၑက္နောတိ တသ္မာဒေဝ ဘယံ ကုရုတ, ပုနရပိ ဝဒါမိ တသ္မာဒေဝ ဘယံ ကုရုတ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","ပဉ္စ စဋကပက္ၐိဏး ကိံ ဒွါဘျာံ တာမြခဏ္ဍာဘျာံ န ဝိကြီယန္တေ? တထာပီၑွရသ္တေၐာမ် ဧကမပိ န ဝိသ္မရတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","ယုၐ္မာကံ ၑိရးကေၑာ အပိ ဂဏိတား သန္တိ တသ္မာတ် မာ ဝိဘီတ ဗဟုစဋကပက္ၐိဘျောပိ ယူယံ ဗဟုမူလျား၊ ");
INSERT INTO sanbur_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","အပရံ ယုၐ္မဘျံ ကထယာမိ ယး ကၑ္စိန် မာနုၐာဏာံ သာက္ၐာန် မာံ သွီကရောတိ မနုၐျပုတြ ဤၑွရဒူတာနာံ သာက္ၐာတ် တံ သွီကရိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","ကိန္တု ယး ကၑ္စိန္မာနုၐာဏာံ သာက္ၐာန္မာမ် အသွီကရောတိ တမ် ဤၑွရသျ ဒူတာနာံ သာက္ၐာဒ် အဟမ် အသွီကရိၐျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","အနျစ္စ ယး ကၑ္စိန် မနုဇသုတသျ နိန္ဒာဘာဝေန ကာဉ္စိတ် ကထာံ ကထယတိ တသျ တတ္ပာပသျ မောစနံ ဘဝိၐျတိ ကိန္တု ယဒိ ကၑ္စိတ် ပဝိတြမ် အာတ္မာနံ နိန္ဒတိ တရှိ တသျ တတ္ပာပသျ မောစနံ န ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","ယဒါ လောကာ ယုၐ္မာန် ဘဇနဂေဟံ ဝိစာရကရ္တၖရာဇျကရ္တၖဏာံ သမ္မုခဉ္စ နေၐျန္တိ တဒါ ကေန ပြကာရေဏ ကိမုတ္တရံ ဝဒိၐျထ ကိံ ကထယိၐျထ စေတျတြ မာ စိန္တယတ; ");
INSERT INTO sanbur_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ယတော ယုၐ္မာဘိရျဒ် ယဒ် ဝက္တဝျံ တတ် တသ္မိန် သမယဧဝ ပဝိတြ အာတ္မာ ယုၐ္မာန် ၑိက္ၐယိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","တတး ပရံ ဇနတာမဓျသ္ထး ကၑ္စိဇ္ဇနသ္တံ ဇဂါဒ ဟေ ဂုရော မယာ သဟ ပဲတၖကံ ဓနံ ဝိဘက္တုံ မမ ဘြာတရမာဇ္ဉာပယတု ဘဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","ကိန္တု သ တမဝဒတ် ဟေ မနုၐျ ယုဝယော ရွိစာရံ ဝိဘာဂဉ္စ ကရ္တ္တုံ မာံ ကော နိယုက္တဝါန်? ");
INSERT INTO sanbur_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","အနန္တရံ သ လောကာနဝဒတ် လောဘေ သာဝဓာနား သတရ္ကာၑ္စ တိၐ္ဌတ, ယတော ဗဟုသမ္ပတ္တိပြာပ္တျာ မနုၐျသျာယု ရ္န ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ပၑ္စာဒ် ဒၖၐ္ဋာန္တကထာမုတ္ထာပျ ကထယာမာသ, ဧကသျ ဓနိနော ဘူမော် ဗဟူနိ ၑသျာနိ ဇာတာနိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","တတး သ မနသာ စိန္တယိတွာ ကထယာမ္ဗဘူဝ မမဲတာနိ သမုတ္ပန္နာနိ ဒြဝျာဏိ သ္ထာပယိတုံ သ္ထာနံ နာသ္တိ ကိံ ကရိၐျာမိ? ");
INSERT INTO sanbur_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","တတောဝဒဒ် ဣတ္ထံ ကရိၐျာမိ, မမ သရွွဘာဏ္ဍာဂါရာဏိ ဘင်္က္တွာ ဗၖဟဒ္ဘါဏ္ဍာဂါရာဏိ နိရ္မ္မာယ တန္မဓျေ သရွွဖလာနိ ဒြဝျာဏိ စ သ္ထာပယိၐျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","အပရံ နိဇမနော ဝဒိၐျာမိ, ဟေ မနော ဗဟုဝတ္သရာရ္ထံ နာနာဒြဝျာဏိ သဉ္စိတာနိ သန္တိ ဝိၑြာမံ ကုရု ဘုက္တွာ ပီတွာ ကော်တုကဉ္စ ကုရု၊ ကိန္တွီၑွရသ္တမ် အဝဒတ်, ");
INSERT INTO sanbur_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","ရေ နိရ္ဗောဓ အဒျ ရာတြော် တဝ ပြာဏာသ္တွတ္တော နေၐျန္တေ တတ ဧတာနိ ယာနိ ဒြဝျာဏိ တွယာသာဒိတာနိ တာနိ ကသျ ဘဝိၐျန္တိ? ");
INSERT INTO sanbur_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","အတဧဝ ယး ကၑ္စိဒ် ဤၑွရသျ သမီပေ ဓနသဉ္စယမကၖတွာ ကေဝလံ သွနိကဋေ သဉ္စယံ ကရောတိ သောပိ တာဒၖၑး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","အထ သ ၑိၐျေဘျး ကထယာမာသ, ယုၐ္မာနဟံ ဝဒါမိ, ကိံ ခါဒိၐျာမး? ကိံ ပရိဓာသျာမး? ဣတျုက္တွာ ဇီဝနသျ ၑရီရသျ စာရ္ထံ စိန္တာံ မာ ကာရ္ၐ္ဋ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ဘက္ၐျာဇ္ဇီဝနံ ဘူၐဏာစ္ဆရီရဉ္စ ၑြေၐ္ဌံ ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","ကာကပက္ၐိဏာံ ကာရျျံ ဝိစာရယတ, တေ န ဝပန္တိ ၑသျာနိ စ န ဆိန္ဒန္တိ, တေၐာံ ဘာဏ္ဍာဂါရာဏိ န သန္တိ ကောၐာၑ္စ န သန္တိ, တထာပီၑွရသ္တေဘျော ဘက္ၐျာဏိ ဒဒါတိ, ယူယံ ပက္ၐိဘျး ၑြေၐ္ဌတရာ န ကိံ? ");
INSERT INTO sanbur_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","အပရဉ္စ ဘာဝယိတွာ နိဇာယုၐး က္ၐဏမာတြံ ဝရ္ဒ္ဓယိတုံ ၑက္နောတိ, ဧတာဒၖၑော လာကော ယုၐ္မာကံ မဓျေ ကောသ္တိ? ");
INSERT INTO sanbur_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","အတဧဝ က္ၐုဒြံ ကာရျျံ သာဓယိတုမ် အသမရ္ထာ ယူယမ် အနျသ္မိန် ကာရျျေ ကုတော ဘာဝယထ? ");
INSERT INTO sanbur_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","အနျစ္စ ကာမ္ပိလပုၐ္ပံ ကထံ ဝရ္ဒ္ဓတေ တဒါပိ ဝိစာရယတ, တတ် ကဉ္စန ၑြမံ န ကရောတိ တန္တူံၑ္စ န ဇနယတိ ကိန္တု ယုၐ္မဘျံ ယထာရ္ထံ ကထယာမိ သုလေမာန် ဗဟွဲၑွရျျာနွိတောပိ ပုၐ္ပသျာသျ သဒၖၑော ဝိဘူၐိတော နာသီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","အဒျ က္ၐေတြေ ဝရ္တ္တမာနံ ၑွၑ္စူလ္လျာံ က္ၐေပ္သျမာနံ ယတ် တၖဏံ, တသ္မဲ ယဒီၑွရ ဣတ္ထံ ဘူၐယတိ တရှိ ဟေ အလ္ပပြတျယိနော ယုၐ္မာန ကိံ န ပရိဓာပယိၐျတိ? ");
INSERT INTO sanbur_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","အတဧဝ ကိံ ခါဒိၐျာမး? ကိံ ပရိဓာသျာမး? ဧတဒရ္ထံ မာ စေၐ္ဋဓွံ မာ သံဒိဂ္ဓွဉ္စ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ဇဂတော ဒေဝါရ္စ္စကာ ဧတာနိ သရွွာဏိ စေၐ္ဋနတေ; ဧၐု ဝသ္တုၐု ယုၐ္မာကံ ပြယောဇနမာသ္တေ ဣတိ ယုၐ္မာကံ ပိတာ ဇာနာတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","အတဧဝေၑွရသျ ရာဇျာရ္ထံ သစေၐ္ဋာ ဘဝတ တထာ ကၖတေ သရွွာဏျေတာနိ ဒြဝျာဏိ ယုၐ္မဘျံ ပြဒါယိၐျန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","ဟေ က္ၐုဒြမေၐဝြဇ ယူယံ မာ ဘဲၐ္ဋ ယုၐ္မဘျံ ရာဇျံ ဒါတုံ ယုၐ္မာကံ ပိတုး သမ္မတိရသ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","အတဧဝ ယုၐ္မာကံ ယာ ယာ သမ္ပတ္တိရသ္တိ တာံ တာံ ဝိကြီယ ဝိတရတ, ယတ် သ္ထာနံ စော်ရာ နာဂစ္ဆန္တိ, ကီဋာၑ္စ န က္ၐာယယန္တိ တာဒၖၑေ သွရ္ဂေ နိဇာရ္ထမ် အဇရေ သမ္ပုဋကေ 'က္ၐယံ ဓနံ သဉ္စိနုတ စ; ");
INSERT INTO sanbur_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","ယတော ယတြ ယုၐ္မာကံ ဓနံ ဝရ္တ္တတေ တတြေဝ ယုၐ္မာကံ မနး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","အပရဉ္စ ယူယံ ပြဒီပံ ဇွာလယိတွာ ဗဒ္ဓကဋယသ္တိၐ္ဌတ; ");
INSERT INTO sanbur_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ပြဘု ရွိဝါဟာဒါဂတျ ယဒဲဝ ဒွါရမာဟန္တိ တဒဲဝ ဒွါရံ မောစယိတုံ ယထာ ဘၖတျာ အပေက္ၐျ တိၐ္ဌန္တိ တထာ ယူယမပိ တိၐ္ဌတ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","ယတး ပြဘုရာဂတျ ယာန် ဒါသာန် သစေတနာန် တိၐ္ဌတော ဒြက္ၐျတိ တဧဝ ဓနျား; အဟံ ယုၐ္မာန် ယထာရ္ထံ ဝဒါမိ ပြဘုသ္တာန် ဘောဇနာရ္ထမ် ဥပဝေၑျ သွယံ ဗဒ္ဓကဋိး သမီပမေတျ ပရိဝေၐယိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","ယဒိ ဒွိတီယေ တၖတီယေ ဝါ ပြဟရေ သမာဂတျ တထဲဝ ပၑျတိ, တရှိ တဧဝ ဒါသာ ဓနျား၊ ");
INSERT INTO sanbur_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","အပရဉ္စ ကသ္မိန် က္ၐဏေ စော်ရာ အာဂမိၐျန္တိ ဣတိ ယဒိ ဂၖဟပတိ ရ္ဇ္ဉာတုံ ၑက္နောတိ တဒါဝၑျံ ဇာဂြန် နိဇဂၖဟေ သန္ဓိံ ကရ္တ္တယိတုံ ဝါရယတိ ယူယမေတဒ် ဝိတ္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","အတဧဝ ယူယမပိ သဇ္ဇမာနာသ္တိၐ္ဌတ ယတော ယသ္မိန် က္ၐဏေ တံ နာပြေက္ၐဓွေ တသ္မိန္နေဝ က္ၐဏေ မနုၐျပုတြ အာဂမိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","တဒါ ပိတရး ပပြစ္ဆ, ဟေ ပြဘော ဘဝါန် ကိမသ္မာန် ဥဒ္ဒိၑျ ကိံ သရွွာန် ဥဒ္ဒိၑျ ဒၖၐ္ဋာန္တကထာမိမာံ ဝဒတိ? ");
INSERT INTO sanbur_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","တတး ပြဘုး ပြောဝါစ, ပြဘုး သမုစိတကာလေ နိဇပရိဝါရာရ္ထံ ဘောဇျပရိဝေၐဏာယ ယံ တတ္ပဒေ နိယောက္ၐျတိ တာဒၖၑော ဝိၑွာသျော ဗောဒ္ဓါ ကရ္မ္မာဓီၑး ကောသ္တိ? ");
INSERT INTO sanbur_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ပြဘုရာဂတျ ယမ် ဧတာဒၖၑေ ကရ္မ္မဏိ ပြဝၖတ္တံ ဒြက္ၐျတိ သဧဝ ဒါသော ဓနျး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","အဟံ ယုၐ္မာန် ယထာရ္ထံ ဝဒါမိ သ တံ နိဇသရွွသွသျာဓိပတိံ ကရိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","ကိန္တု ပြဘုရွိလမ္ဗေနာဂမိၐျတိ, ဣတိ ဝိစိန္တျ သ ဒါသော ယဒိ တဒနျဒါသီဒါသာန် ပြဟရ္တ္တုမ် ဘောက္တုံ ပါတုံ မဒိတုဉ္စ ပြာရဘတေ, ");
INSERT INTO sanbur_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","တရှိ ယဒါ ပြဘုံ နာပေက္ၐိၐျတေ ယသ္မိန် က္ၐဏေ သော'စေတနၑ္စ သ္ထာသျတိ တသ္မိန္နေဝ က္ၐဏေ တသျ ပြဘုရာဂတျ တံ ပဒဘြၐ္ဋံ ကၖတွာ ဝိၑွာသဟီနဲး သဟ တသျ အံၑံ နိရူပယိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","ယော ဒါသး ပြဘေाရာဇ္ဉာံ ဇ္ဉာတွာပိ သဇ္ဇိတော န တိၐ္ဌတိ တဒါဇ္ဉာနုသာရေဏ စ ကာရျျံ န ကရောတိ သောနေကာန် ပြဟာရာန် ပြာပ္သျတိ; ");
INSERT INTO sanbur_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","ကိန္တု ယော ဇနော'ဇ္ဉာတွာ ပြဟာရာရှံ ကရ္မ္မ ကရောတိ သောလ္ပပြဟာရာန် ပြာပ္သျတိ၊ ယတော ယသ္မဲ ဗာဟုလျေန ဒတ္တံ တသ္မာဒေဝ ဗာဟုလျေန ဂြဟီၐျတေ, မာနုၐာ ယသျ နိကဋေ ဗဟု သမရ္ပယန္တိ တသ္မာဒ် ဗဟု ယာစန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","အဟံ ပၖထိဝျာမ် အနဲကျရူပံ ဝဟ္နိ နိက္ၐေပ္တုမ် အာဂတောသ္မိ, သ စေဒ် ဣဒါနီမေဝ ပြဇွလတိ တတြ မမ ကာ စိန္တာ? ");
INSERT INTO sanbur_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","ကိန္တု ယေန မဇ္ဇနေနာဟံ မဂ္နော ဘဝိၐျာမိ ယာဝတ္ကာလံ တသျ သိဒ္ဓိ ရ္န ဘဝိၐျတိ တာဝဒဟံ ကတိကၐ္ဋံ ပြာပ္သျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","မေလနံ ကရ္တ္တုံ ဇဂဒ် အာဂတောသ္မိ ယူယံ ကိမိတ္ထံ ဗောဓဓွေ? ယုၐ္မာန် ဝဒါမိ န တထာ, ကိန္တွဟံ မေလနာဘာဝံ ကရ္တ္တုံမ် အာဂတောသ္မိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ယသ္မာဒေတတ္ကာလမာရဘျ ဧကတြသ္ထပရိဇနာနာံ မဓျေ ပဉ္စဇနား ပၖထဂ် ဘူတွာ တြယော ဇနာ ဒွယောရ္ဇနယေား ပြတိကူလာ ဒွေါ် ဇနော် စ တြယာဏာံ ဇနာနာံ ပြတိကူလော် ဘဝိၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","ပိတာ ပုတြသျ ဝိပက္ၐး ပုတြၑ္စ ပိတု ရွိပက္ၐော ဘဝိၐျတိ မာတာ ကနျာယာ ဝိပက္ၐာ ကနျာ စ မာတု ရွိပက္ၐာ ဘဝိၐျတိ, တထာ ၑွၑြူရ္ဗဓွာ ဝိပက္ၐာ ဗဓူၑ္စ ၑွၑြွာ ဝိပက္ၐာ ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","သ လောကေဘျောပရမပိ ကထယာမာသ, ပၑ္စိမဒိၑိ မေဃောဒ္ဂမံ ဒၖၐ္ဋွာ ယူယံ ဟဌာဒ် ဝဒထ ဝၖၐ္ဋိ ရ္ဘဝိၐျတိ တတသ္တထဲဝ ဇာယတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","အပရံ ဒက္ၐိဏတော ဝါယော် ဝါတိ သတိ ဝဒထ နိဒါဃော ဘဝိၐျတိ တတး သောပိ ဇာယတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","ရေ ရေ ကပဋိန အာကာၑသျ ဘူမျာၑ္စ လက္ၐဏံ ဗောဒ္ဓုံ ၑက္နုထ, ");
INSERT INTO sanbur_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","ကိန္တု ကာလသျာသျ လက္ၐဏံ ကုတော ဗောဒ္ဓုံ န ၑက္နုထ? ယူယဉ္စ သွယံ ကုတော န နျာၐျံ ဝိစာရယထ? ");
INSERT INTO sanbur_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","အပရဉ္စ ဝိဝါဒိနာ သာရ္ဒ္ဓံ ဝိစာရယိတုး သမီပံ ဂစ္ဆန် ပထိ တသ္မာဒုဒ္ဓါရံ ပြာပ္တုံ ယတသွ နောစေတ် သ တွာံ ဓၖတွာ ဝိစာရယိတုး သမီပံ နယတိ၊ ဝိစာရယိတာ ယဒိ တွာံ ပြဟရ္တ္တုး သမီပံ သမရ္ပယတိ ပြဟရ္တ္တာ တွာံ ကာရာယာံ ဗဓ္နာတိ ");
INSERT INTO sanbur_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","တရှိ တွာမဟံ ဝဒါမိ တွယာ နိးၑေၐံ ကပရ္ဒကေၐု န ပရိၑောဓိတေၐု တွံ တတော မုက္တိံ ပြာပ္တုံ န ၑက္ၐျသိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","အပရဉ္စ ပီလာတော ယေၐာံ ဂါလီလီယာနာံ ရက္တာနိ ဗလီနာံ ရက္တဲး သဟာမိၑြယတ် တေၐာံ ဂါလီလီယာနာံ ဝၖတ္တာန္တံ ကတိပယဇနာ ဥပသ္ထာပျ ယီၑဝေ ကထယာမာသုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","တတး သ ပြတျုဝါစ တေၐာံ လောကာနာမ် ဧတာဒၖၑီ ဒုရ္ဂတိ ရ္ဃဋိတာ တတ္ကာရဏာဒ် ယူယံ ကိမနျေဘျော ဂါလီလီယေဘျောပျဓိကပါပိနသ္တာန် ဗောဓဓွေ? ");
INSERT INTO sanbur_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","ယုၐ္မာနဟံ ဝဒါမိ တထာ န ကိန္တု မနးသု န ပရာဝရ္တ္တိတေၐု ယူယမပိ တထာ နံက္ၐျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","အပရဉ္စ ၑီလောဟနာမ္န ဥစ္စဂၖဟသျ ပတနာဒ် ယေ'ၐ္ဋာဒၑဇနာ မၖတာသ္တေ ယိရူၑာလမိ နိဝါသိသရွွလောကေဘျော'ဓိကာပရာဓိနး ကိံ ယူယမိတျံ ဗောဓဓွေ? ");
INSERT INTO sanbur_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","ယုၐ္မာနဟံ ဝဒါမိ တထာ န ကိန္တု မနးသု န ပရိဝရ္တ္တိတေၐု ယူယမပိ တထာ နံက္ၐျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","အနန္တရံ သ ဣမာံ ဒၖၐ္ဋာန္တကထာမကထယဒ် ဧကော ဇနော ဒြာက္ၐာက္ၐေတြမဓျ ဧကမုဍုမ္ဗရဝၖက္ၐံ ရောပိတဝါန်၊ ပၑ္စာတ် သ အာဂတျ တသ္မိန် ဖလာနိ ဂဝေၐယာမာသ, ");
INSERT INTO sanbur_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","ကိန္တု ဖလာပြာပ္တေး ကာရဏာဒ် ဥဒျာနကာရံ ဘၖတျံ ဇဂါဒ, ပၑျ ဝတ္သရတြယံ ယာဝဒါဂတျ ဧတသ္မိန္နုဍုမ္ဗရတရော် က္ၐလာနျနွိစ္ဆာမိ, ကိန္တု နဲကမပိ ပြပ္နောမိ တရုရယံ ကုတော ဝၖထာ သ္ထာနံ ဝျာပျ တိၐ္ဌတိ? ဧနံ ဆိန္ဓိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","တတော ဘၖတျး ပြတျုဝါစ, ဟေ ပြဘော ပုနရွရ္ၐမေကံ သ္ထာတုမ် အာဒိၑ; ဧတသျ မူလသျ စတုရ္ဒိက္ၐု ခနိတွာဟမ် အာလဝါလံ သ္ထာပယာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","တတး ဖလိတုံ ၑက္နောတိ ယဒိ န ဖလတိ တရှိ ပၑ္စာတ် ဆေတ္သျသိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","အထ ဝိၑြာမဝါရေ ဘဇနဂေဟေ ယီၑုရုပဒိၑတိ ");
INSERT INTO sanbur_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","တသ္မိတ် သမယေ ဘူတဂြသ္တတွာတ် ကုဗ္ဇီဘူယာၐ္ဋာဒၑဝရ္ၐာဏိ ယာဝတ် ကေနာပျုပါယေန ၒဇု ရ္ဘဝိတုံ န ၑက္နောတိ ယာ ဒုရ္ဗ္ဗလာ သ္တြီ, ");
INSERT INTO sanbur_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","တာံ တတြောပသ္ထိတာံ ဝိလောကျ ယီၑုသ္တာမာဟူယ ကထိတဝါန် ဟေ နာရိ တဝ ဒေါ်ရ္ဗ္ဗလျာတ် တွံ မုက္တာ ဘဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","တတး ပရံ တသျာ ဂါတြေ ဟသ္တာရ္ပဏမာတြာတ် သာ ၒဇုရ္ဘူတွေၑွရသျ ဓနျဝါဒံ ကရ္တ္တုမာရေဘေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","ကိန္တု ဝိၑြာမဝါရေ ယီၑုနာ တသျား သွာသ္ထျကရဏာဒ် ဘဇနဂေဟသျာဓိပတိး ပြကုပျ လောကာန် ဥဝါစ, ၐဋ္သု ဒိနေၐု လောကဲး ကရ္မ္မ ကရ္တ္တဝျံ တသ္မာဒ္ဓေတေား သွာသ္ထျာရ္ထံ တေၐု ဒိနေၐု အာဂစ္ဆတ, ဝိၑြာမဝါရေ မာဂစ္ဆတ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","တဒါ ပဘုး ပြတျုဝါစ ရေ ကပဋိနော ယုၐ္မာကမ် ဧကဲကော ဇနော ဝိၑြာမဝါရေ သွီယံ သွီယံ ဝၖၐဘံ ဂရ္ဒဘံ ဝါ ဗန္ဓနာန္မောစယိတွာ ဇလံ ပါယယိတုံ ကိံ န နယတိ? ");
INSERT INTO sanbur_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","တရှျာၐ္ဋာဒၑဝတ္သရာန် ယာဝတ် ၑဲတာနာ ဗဒ္ဓါ ဣဗြာဟီမး သန္တတိရိယံ နာရီ ကိံ ဝိၑြာမဝါရေ န မောစယိတဝျာ? ");
INSERT INTO sanbur_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ဧၐု ဝါကျေၐု ကထိတေၐု တသျ ဝိပက္ၐား သလဇ္ဇာ ဇာတား ကိန္တု တေန ကၖတသရွွမဟာကရ္မ္မကာရဏာတ် လောကနိဝဟး သာနန္ဒော'ဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","အနန္တရံ သောဝဒဒ် ဤၑွရသျ ရာဇျံ ကသျ သဒၖၑံ? ကေန တဒုပမာသျာမိ? ");
INSERT INTO sanbur_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","ယတ် သရ္ၐပဗီဇံ ဂၖဟီတွာ ကၑ္စိဇ္ဇန ဥဒျာန ဥပ္တဝါန် တဒ် ဗီဇမင်္ကုရိတံ သတ် မဟာဝၖက္ၐော'ဇာယတ, တတသ္တသျ ၑာခါသု ဝိဟာယသီယဝိဟဂါ အာဂတျ နျူၐုး, တဒြာဇျံ တာဒၖၑေန သရ္ၐပဗီဇေန တုလျံ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ပုနး ကထယာမာသ, ဤၑွရသျ ရာဇျံ ကသျ သဒၖၑံ ဝဒိၐျာမိ? ယတ် ကိဏွံ ကာစိတ် သ္တြီ ဂၖဟီတွာ ဒြောဏတြယပရိမိတဂေါဓူမစူရ္ဏေၐု သ္ထာပယာမာသ, ");
INSERT INTO sanbur_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","တတး ကြမေဏ တတ် သရွွဂေါဓူမစူရ္ဏံ ဝျာပ္နောတိ, တသျ ကိဏွသျ တုလျမ် ဤၑွရသျ ရာဇျံ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","တတး သ ယိရူၑာလမ္နဂရံ ပြတိ ယာတြာံ ကၖတွာ နဂရေ နဂရေ ဂြာမေ ဂြာမေ သမုပဒိၑန် ဇဂါမ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","တဒါ ကၑ္စိဇ္ဇနသ္တံ ပပြစ္ဆ, ဟေ ပြဘော ကိံ ကေဝလမ် အလ္ပေ လောကား ပရိတြာသျန္တေ? ");
INSERT INTO sanbur_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","တတး သ လောကာန် ဥဝါစ, သံကီရ္ဏဒွါရေဏ ပြဝေၐ္ဋုံ ယတဃွံ, ယတောဟံ ယုၐ္မာန် ဝဒါမိ, ဗဟဝး ပြဝေၐ္ဋုံ စေၐ္ဋိၐျန္တေ ကိန္တု န ၑက္ၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ဂၖဟပတိနောတ္ထာယ ဒွါရေ ရုဒ္ဓေ သတိ ယဒိ ယူယံ ဗဟိး သ္ထိတွာ ဒွါရမာဟတျ ဝဒထ, ဟေ ပြဘော ဟေ ပြဘော အသ္မတ္ကာရဏာဒ် ဒွါရံ မောစယတု, တတး သ ဣတိ ပြတိဝက္ၐျတိ, ယူယံ ကုတြတျာ လောကာ ဣတျဟံ န ဇာနာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","တဒါ ယူယံ ဝဒိၐျထ, တဝ သာက္ၐာဒ် ဝယံ ဘေाဇနံ ပါနဉ္စ ကၖတဝန္တး, တွဉ္စာသ္မာကံ နဂရသျ ပထိ သမုပဒိၐ္ဋဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","ကိန္တု သ ဝက္ၐျတိ, ယုၐ္မာနဟံ ဝဒါမိ, ယူယံ ကုတြတျာ လောကာ ဣတျဟံ န ဇာနာမိ; ဟေ ဒုရာစာရိဏော ယူယံ မတ္တော ဒူရီဘဝတ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","တဒါ ဣဗြာဟီမံ ဣသှာကံ ယာကူဗဉ္စ သရွွဘဝိၐျဒွါဒိနၑ္စ ဤၑွရသျ ရာဇျံ ပြာပ္တာန် သွာံၑ္စ ဗဟိၐ္ကၖတာန် ဒၖၐ္ဋွာ ယူယံ ရောဒနံ ဒန္တဲရ္ဒန္တဃရ္ၐဏဉ္စ ကရိၐျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","အပရဉ္စ ပူရွွပၑ္စိမဒက္ၐိဏောတ္တရဒိဂ္ဘျော လောကာ အာဂတျ ဤၑွရသျ ရာဇျေ နိဝတ္သျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ပၑျတေတ္ထံ ၑေၐီယာ လောကာ အဂြာ ဘဝိၐျန္တိ, အဂြီယာ လောကာၑ္စ ၑေၐာ ဘဝိၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","အပရဉ္စ တသ္မိန် ဒိနေ ကိယန္တး ဖိရူၑိန အာဂတျ ယီၑုံ ပြောစုး, ဗဟိရ္ဂစ္ဆ, သ္ထာနာဒသ္မာတ် ပြသ္ထာနံ ကုရု, ဟေရောဒ် တွာံ ဇိဃာံသတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","တတး သ ပြတျဝေါစတ် ပၑျတာဒျ ၑွၑ္စ ဘူတာန် ဝိဟာပျ ရောဂိဏော'ရောဂိဏး ကၖတွာ တၖတီယေဟ္နိ သေတ္သျာမိ, ကထာမေတာံ ယူယမိတွာ တံ ဘူရိမာယံ ဝဒတ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","တတြာပျဒျ ၑွး ပရၑွၑ္စ မယာ ဂမနာဂမနေ ကရ္တ္တဝျေ, ယတော ဟေတော ရျိရူၑာလမော ဗဟိး ကုတြာပိ ကောပိ ဘဝိၐျဒွါဒီ န ဃာနိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","ဟေ ယိရူၑာလမ် ဟေ ယိရူၑာလမ် တွံ ဘဝိၐျဒွါဒိနော ဟံသိ တဝါန္တိကေ ပြေရိတာန် ပြသ္တရဲရ္မာရယသိ စ, ယထာ ကုက္ကုဋီ နိဇပက္ၐာဓး သွၑာဝကာန် သံဂၖဟ္လာတိ, တထာဟမပိ တဝ ၑိၑူန် သံဂြဟီတုံ ကတိဝါရာန် အဲစ္ဆံ ကိန္တု တွံ နဲစ္ဆး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ပၑျတ ယုၐ္မာကံ ဝါသသ္ထာနာနိ ပြောစ္ဆိဒျမာနာနိ ပရိတျက္တာနိ စ ဘဝိၐျန္တိ; ယုၐ္မာနဟံ ယထာရ္ထံ ဝဒါမိ, ယး ပြဘော ရ္နာမ္နာဂစ္ဆတိ သ ဓနျ ဣတိ ဝါစံ ယာဝတ္ကာလံ န ဝဒိၐျထ, တာဝတ္ကာလံ ယူယံ မာံ န ဒြက္ၐျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","အနန္တရံ ဝိၑြာမဝါရေ ယီၑော် ပြဓာနသျ ဖိရူၑိနော ဂၖဟေ ဘောက္တုံ ဂတဝတိ တေ တံ ဝီက္ၐိတုမ် အာရေဘိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","တဒါ ဇလောဒရီ တသျ သမ္မုခေ သ္ထိတး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","တတး သ ဝျဝသ္ထာပကာန် ဖိရူၑိနၑ္စ ပပြစ္ဆ, ဝိၑြာမဝါရေ သွာသ္ထျံ ကရ္တ္တဝျံ န ဝါ? တတသ္တေ ကိမပိ န ပြတျူစုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","တဒါ သ တံ ရောဂိဏံ သွသ္ထံ ကၖတွာ ဝိသသရ္ဇ; ");
INSERT INTO sanbur_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","တာနုဝါစ စ ယုၐ္မာကံ ကသျစိဒ် ဂရ္ဒ္ဒဘော ဝၖၐဘော ဝါ စေဒ် ဂရ္တ္တေ ပတတိ တရှိ ဝိၑြာမဝါရေ တတ္က္ၐဏံ သ ကိံ တံ နောတ္ထာပယိၐျတိ? ");
INSERT INTO sanbur_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","တတသ္တေ ကထာယာ ဧတသျား ကိမပိ ပြတိဝက္တုံ န ၑေကုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","အပရဉ္စ ပြဓာနသ္ထာနမနောနီတတွကရဏံ ဝိလောကျ သ နိမန္တြိတာန် ဧတဒုပဒေၑကထာံ ဇဂါဒ, ");
INSERT INTO sanbur_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","တွံ ဝိဝါဟာဒိဘောဇျေၐု နိမန္တြိတး သန် ပြဓာနသ္ထာနေ မောပါဝေက္ၐီး၊ တွတ္တော ဂေါ်ရဝါနွိတနိမန္တြိတဇန အာယာတေ ");
INSERT INTO sanbur_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","နိမန္တြယိတာဂတျ မနုၐျာယဲတသ္မဲ သ္ထာနံ ဒေဟီတိ ဝါကျံ စေဒ် ဝက္ၐျတိ တရှိ တွံ သင်္ကုစိတော ဘူတွာ သ္ထာန ဣတရသ္မိန် ဥပဝေၐ္ဋုမ် ဥဒျံသျသိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","အသ္မာတ် ကာရဏာဒေဝ တွံ နိမန္တြိတော ဂတွာ'ပြဓာနသ္ထာန ဥပဝိၑ, တတော နိမန္တြယိတာဂတျ ဝဒိၐျတိ, ဟေ ဗန္ဓော ပြောစ္စသ္ထာနံ ဂတွောပဝိၑ, တထာ သတိ ဘောဇနောပဝိၐ္ဋာနာံ သကလာနာံ သာက္ၐာတ် တွံ မာနျော ဘဝိၐျသိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","ယး ကၑ္စိတ် သွမုန္နမယတိ သ နမယိၐျတေ, ကိန္တု ယး ကၑ္စိတ် သွံ နမယတိ သ ဥန္နမယိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","တဒါ သ နိမန္တြယိတာရံ ဇနမပိ ဇဂါဒ, မဓျာဟ္နေ ရာတြော် ဝါ ဘောဇျေ ကၖတေ နိဇဗန္ဓုဂဏော ဝါ ဘြာတၖृဂဏော ဝါ ဇ္ဉာတိဂဏော ဝါ ဓနိဂဏော ဝါ သမီပဝါသိဂဏော ဝါ ဧတာန် န နိမန္တြယ, တထာ ကၖတေ စေတ် တေ တွာံ နိမန္တြယိၐျန္တိ, တရှိ ပရိၑောဓော ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","ကိန္တု ယဒါ ဘေဇျံ ကရောၐိ တဒါ ဒရိဒြၑုၐ္ကကရခဉ္ဇာန္ဓာန် နိမန္တြယ, ");
INSERT INTO sanbur_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","တတ အာၑိၐံ လပ္သျသေ, တေၐု ပရိၑောဓံ ကရ္တ္တုမၑက္နုဝတ္သု ၑ္မၑာနာဒ္ဓါရ္မ္မိကာနာမုတ္ထာနကာလေ တွံ ဖလာံ လပ္သျသေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","အနန္တရံ တာံ ကထာံ နိၑမျ ဘောဇနောပဝိၐ္ဋး ကၑ္စိတ် ကထယာမာသ, ယော ဇန ဤၑွရသျ ရာဇျေ ဘောက္တုံ လပ္သျတေ သဧဝ ဓနျး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","တတး သ ဥဝါစ, ကၑ္စိတ် ဇနော ရာတြော် ဘေाဇျံ ကၖတွာ ဗဟူန် နိမန္တြယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","တတော ဘောဇနသမယေ နိမန္တြိတလောကာန် အာဟွာတုံ ဒါသဒွါရာ ကထယာမာသ, ခဒျဒြဝျာဏိ သရွွာဏိ သမာသာဒိတာနိ သန္တိ, ယူယမာဂစ္ဆတ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","ကိန္တု တေ သရွွ ဧကဲကံ ဆလံ ကၖတွာ က္ၐမာံ ပြာရ္ထယာဉ္စကြိရေ၊ ပြထမော ဇနး ကထယာမာသ, က္ၐေတြမေကံ ကြီတဝါနဟံ တဒေဝ ဒြၐ္ဋုံ မယာ ဂန္တဝျမ်, အတဧဝ မာံ က္ၐန္တုံ တံ နိဝေဒယ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","အနျော ဇနး ကထယာမာသ, ဒၑဝၖၐာနဟံ ကြီတဝါန် တာန် ပရီက္ၐိတုံ ယာမိ တသ္မာဒေဝ မာံ က္ၐန္တုံ တံ နိဝေဒယ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","အပရး ကထယာမာသ, ဝျူဎဝါနဟံ တသ္မာတ် ကာရဏာဒ် ယာတုံ န ၑက္နောမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","ပၑ္စာတ် သ ဒါသော ဂတွာ နိဇပြဘေား သာက္ၐာတ် သရွွဝၖတ္တာန္တံ နိဝေဒယာမာသ, တတောသော် ဂၖဟပတိး ကုပိတွာ သွဒါသံ ဝျာဇဟာရ, တွံ သတွရံ နဂရသျ သန္နိဝေၑာန် မာရ္ဂာံၑ္စ ဂတွာ ဒရိဒြၑုၐ္ကကရခဉ္ဇာန္ဓာန် အတြာနယ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","တတော ဒါသော'ဝဒတ်, ဟေ ပြဘော ဘဝတ အာဇ္ဉာနုသာရေဏာကြိယတ တထာပိ သ္ထာနမသ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","တဒါ ပြဘုး ပုန ရ္ဒာသာယာကထယတ်, ရာဇပထာန် ဝၖက္ၐမူလာနိ စ ယာတွာ မဒီယဂၖဟပူရဏာရ္ထံ လောကာနာဂန္တုံ ပြဝရ္တ္တယ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","အဟံ ယုၐ္မဘျံ ကထယာမိ, ပူရွွနိမန္တြိတာနမေကောပိ မမာသျ ရာတြိဘောဇျသျာသွာဒံ န ပြာပ္သျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","အနန္တရံ ဗဟုၐု လောကေၐု ယီၑေား ပၑ္စာဒ် ဝြဇိတေၐု သတ္သု သ ဝျာဃုဋျ တေဘျး ကထယာမာသ, ");
INSERT INTO sanbur_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","ယး ကၑ္စိန် မမ သမီပမ် အာဂတျ သွသျ မာတာ ပိတာ ပတ္နီ သန္တာနာ ဘြာတရော ဘဂိမျော နိဇပြာဏာၑ္စ, ဧတေဘျး သရွွေဘျော မယျဓိကံ ပြေမ န ကရောတိ, သ မမ ၑိၐျော ဘဝိတုံ န ၑက္ၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ယး ကၑ္စိတ် သွီယံ ကြုၑံ ဝဟန် မမ ပၑ္စာန္န ဂစ္ဆတိ, သောပိ မမ ၑိၐျော ဘဝိတုံ န ၑက္ၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","ဒုရ္ဂနိရ္မ္မာဏေ ကတိဝျယော ဘဝိၐျတိ, တထာ တသျ သမာပ္တိကရဏာရ္ထံ သမ္ပတ္တိရသ္တိ န ဝါ, ပြထမမုပဝိၑျ ဧတန္န ဂဏယတိ, ယုၐ္မာကံ မဓျ ဧတာဒၖၑး ကောသ္တိ? ");
INSERT INTO sanbur_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","နောစေဒ် ဘိတ္တိံ ကၖတွာ ၑေၐေ ယဒိ သမာပယိတုံ န ၑက္ၐျတိ, ");
INSERT INTO sanbur_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","တရှိ မာနုၐောယံ နိစေတုမ် အာရဘတ သမာပယိတုံ နာၑက္နောတ်, ဣတိ ဝျာဟၖတျ သရွွေ တမုပဟသိၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","အပရဉ္စ ဘိန္နဘူပတိနာ သဟ ယုဒ္ဓံ ကရ္တ္တုမ် ဥဒျမျ ဒၑသဟသြာဏိ သဲနျာနိ ဂၖဟီတွာ ဝိံၑတိသဟသြေး သဲနျဲး သဟိတသျ သမီပဝါသိနး သမ္မုခံ ယာတုံ ၑက္ၐျာမိ န ဝေတိ ပြထမံ ဥပဝိၑျ န ဝိစာရယတိ ဧတာဒၖၑော ဘူမိပတိး ကး? ");
INSERT INTO sanbur_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","ယဒိ န ၑက္နောတိ တရှိ ရိပါဝတိဒူရေ တိၐ္ဌတိ သတိ နိဇဒူတံ ပြေၐျ သန္ဓိံ ကရ္တ္တုံ ပြာရ္ထယေတ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","တဒွဒ် ယုၐ္မာကံ မဓျေ ယး ကၑ္စိန် မဒရ္ထံ သရွွသွံ ဟာတုံ န ၑက္နောတိ သ မမ ၑိၐျော ဘဝိတုံ န ၑက္ၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","လဝဏမ် ဥတ္တမမ် ဣတိ သတျံ, ကိန္တု ယဒိ လဝဏသျ လဝဏတွမ် အပဂစ္ဆတိ တရှိ တတ် ကထံ သွာဒုယုက္တံ ဘဝိၐျတိ? ");
INSERT INTO sanbur_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","တဒ ဘူမျရ္ထမ် အာလဝါလရာၑျရ္ထမပိ ဘဒြံ န ဘဝတိ; လောကာသ္တဒ် ဗဟိး က္ၐိပန္တိ၊ ယသျ ၑြောတုံ ၑြောတြေ သ္တး သ ၑၖဏောတု၊ ");
INSERT INTO sanbur_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","တဒါ ကရသဉ္စာယိနး ပါပိနၑ္စ လောကာ ဥပဒေၑ္ကထာံ ၑြောတုံ ယီၑေား သမီပမ် အာဂစ္ဆန်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","တတး ဖိရူၑိန ဥပါဓျာယာၑ္စ ဝိဝဒမာနား ကထယာမာသုး ဧၐ မာနုၐး ပါပိဘိး သဟ ပြဏယံ ကၖတွာ တဲး သာရ္ဒ္ဓံ ဘုံက္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","တဒါ သ တေဘျ ဣမာံ ဒၖၐ္ဋာန္တကထာံ ကထိတဝါန်, ");
INSERT INTO sanbur_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","ကသျစိတ် ၑတမေၐေၐု တိၐ္ဌတ္မု တေၐာမေကံ သ ယဒိ ဟာရယတိ တရှိ မဓျေပြာန္တရမ် ဧကောနၑတမေၐာန် ဝိဟာယ ဟာရိတမေၐသျ ဥဒ္ဒေၑပြာပ္တိပရျျနတံ န ဂဝေၐယတိ, ဧတာဒၖၑော လောကော ယုၐ္မာကံ မဓျေ က အာသ္တေ? ");
INSERT INTO sanbur_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","တသျောဒ္ဒေၑံ ပြာပျ ဟၖၐ္ဋမနာသ္တံ သ္ကန္ဓေ နိဓာယ သွသ္ထာနမ် အာနီယ ဗန္ဓုဗာန္ဓဝသမီပဝါသိန အာဟူယ ဝက္တိ, ");
INSERT INTO sanbur_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ဟာရိတံ မေၐံ ပြာပ္တောဟမ် အတော ဟေတော ရ္မယာ သာရ္ဒ္ဓမ် အာနန္ဒတ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","တဒွဒဟံ ယုၐ္မာန် ဝဒါမိ, ယေၐာံ မနးပရာဝရ္တ္တနသျ ပြယောဇနံ နာသ္တိ, တာဒၖၑဲကောနၑတဓာရ္မ္မိကကာရဏာဒ် ယ အာနန္ဒသ္တသ္မာဒ် ဧကသျ မနးပရိဝရ္တ္တိနး ပါပိနး ကာရဏာတ် သွရ္ဂေ 'ဓိကာနန္ဒော ဇာယတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","အပရဉ္စ ဒၑာနာံ ရူပျခဏ္ဍာနာမ် ဧကခဏ္ဍေ ဟာရိတေ ပြဒီပံ ပြဇွာလျ ဂၖဟံ သမ္မာရ္ဇျ တသျ ပြာပ္တိံ ယာဝဒ် ယတ္နေန န ဂဝေၐယတိ, ဧတာဒၖၑီ ယောၐိတ် ကာသ္တေ? ");
INSERT INTO sanbur_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ပြာပ္တေ သတိ ဗန္ဓုဗာန္ဓဝသမီပဝါသိနီရာဟူယ ကထယတိ, ဟာရိတံ ရူပျခဏ္ဍံ ပြာပ္တာဟံ တသ္မာဒေဝ မယာ သာရ္ဒ္ဓမ် အာနန္ဒတ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","တဒွဒဟံ ယုၐ္မာန် ဝျာဟရာမိ, ဧကေန ပါပိနာ မနသိ ပရိဝရ္တ္တိတေ, ဤၑွရသျ ဒူတာနာံ မဓျေပျာနန္ဒော ဇာယတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","အပရဉ္စ သ ကထယာမာသ, ကသျစိဒ် ဒွေါ် ပုတြာဝါသ္တာံ, ");
INSERT INTO sanbur_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","တယေား ကနိၐ္ဌး ပုတြး ပိတြေ ကထယာမာသ, ဟေ ပိတသ္တဝ သမ္ပတ္တျာ ယမံၑံ ပြာပ္သျာမျဟံ ဝိဘဇျ တံ ဒေဟိ, တတး ပိတာ နိဇာံ သမ္ပတ္တိံ ဝိဘဇျ တာဘျာံ ဒဒေါ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","ကတိပယာတ် ကာလာတ် ပရံ သ ကနိၐ္ဌပုတြး သမသ္တံ ဓနံ သံဂၖဟျ ဒူရဒေၑံ ဂတွာ ဒုၐ္ဋာစရဏေန သရွွာံ သမ္ပတ္တိံ နာၑယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","တသျ သရွွဓနေ ဝျယံ ဂတေ တဒ္ဒေၑေ မဟာဒုရ္ဘိက္ၐံ ဗဘူဝ, တတသ္တသျ ဒဲနျဒၑာ ဘဝိတုမ် အာရေဘေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","တတး ပရံ သ ဂတွာ တဒ္ဒေၑီယံ ဂၖဟသ္ထမေကမ် အာၑြယတ; တတး သတံ ၑူကရဝြဇံ စာရယိတုံ ပြာန္တရံ ပြေၐယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","ကေနာပိ တသ္မဲ ဘက္ၐျာဒါနာတ် သ ၑူကရဖလဝလ္ကလေန ပိစိဏ္ဍပူရဏာံ ဝဝါဉ္ဆ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ၑေၐေ သ မနသိ စေတနာံ ပြာပျ ကထယာမာသ, ဟာ မမ ပိတုး သမီပေ ကတိ ကတိ ဝေတနဘုဇော ဒါသာ ယထေၐ္ဋံ တတောဓိကဉ္စ ဘက္ၐျံ ပြာပ္နုဝန္တိ ကိန္တွဟံ က္ၐုဓာ မုမူရ္ၐုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","အဟမုတ္ထာယ ပိတုး သမီပံ ဂတွာ ကထာမေတာံ ဝဒိၐျာမိ, ဟေ ပိတရ် ဤၑွရသျ တဝ စ ဝိရုဒ္ဓံ ပါပမကရဝမ္ ");
INSERT INTO sanbur_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","တဝ ပုတြဣတိ ဝိချာတော ဘဝိတုံ န ယောဂျောသ္မိ စ, မာံ တဝ ဝဲတနိကံ ဒါသံ ကၖတွာ သ္ထာပယ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","ပၑ္စာတ် သ ဥတ္ထာယ ပိတုး သမီပံ ဇဂါမ; တတသ္တသျ ပိတာတိဒူရေ တံ နိရီက္ၐျ ဒယာဉ္စကြေ, ဓာဝိတွာ တသျ ကဏ္ဌံ ဂၖဟီတွာ တံ စုစုမ္ဗ စ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","တဒါ ပုတြ ဥဝါစ, ဟေ ပိတရ် ဤၑွရသျ တဝ စ ဝိရုဒ္ဓံ ပါပမကရဝံ, တဝ ပုတြဣတိ ဝိချာတော ဘဝိတုံ န ယောဂျောသ္မိ စ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","ကိန္တု တသျ ပိတာ နိဇဒါသာန် အာဒိဒေၑ, သရွွောတ္တမဝသ္တြာဏျာနီယ ပရိဓာပယတဲနံ ဟသ္တေ စာင်္ဂုရီယကမ် အရ္ပယတ ပါဒယောၑ္စောပါနဟော် သမရ္ပယတ; ");
INSERT INTO sanbur_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ပုၐ္ဋံ ဂေါဝတ္သမ် အာနီယ မာရယတ စ တံ ဘုက္တွာ ဝယမ် အာနန္ဒာမ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ယတော မမ ပုတြောယမ် အမြိယတ ပုနရဇီဝီဒ် ဟာရိတၑ္စ လဗ္ဓောဘူတ် တတသ္တ အာနန္ဒိတုမ် အာရေဘိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","တတ္ကာလေ တသျ ဇျေၐ္ဌး ပုတြး က္ၐေတြ အာသီတ်၊ အထ သ နိဝေၑနသျ နိကဋံ အာဂစ္ဆန် နၖတျာနာံ ဝါဒျာနာဉ္စ ၑဗ္ဒံ ၑြုတွာ ");
INSERT INTO sanbur_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ဒါသာနာမ် ဧကမ် အာဟူယ ပပြစ္ဆ, ကိံ ကာရဏမသျ? ");
INSERT INTO sanbur_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","တတး သောဝါဒီတ်, တဝ ဘြာတာဂမတ်, တဝ တာတၑ္စ တံ သုၑရီရံ ပြာပျ ပုၐ္ဋံ ဂေါဝတ္သံ မာရိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","တတး သ ပြကုပျ နိဝေၑနာန္တး ပြဝေၐ္ဋုံ န သမ္မေနေ; တတသ္တသျ ပိတာ ဗဟိရာဂတျ တံ သာဓယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","တတး သ ပိတရံ ပြတျုဝါစ, ပၑျ တဝ ကာဉ္စိဒပျာဇ္ဉာံ န ဝိလံဃျ ဗဟူန် ဝတ္သရာန် အဟံ တွာံ သေဝေ တထာပိ မိတြဲး သာရ္ဒ္ဓမ် ဥတ္သဝံ ကရ္တ္တုံ ကဒါပိ ဆာဂမေကမပိ မဟျံ နာဒဒါး; ");
INSERT INTO sanbur_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","ကိန္တု တဝ ယး ပုတြော ဝေၑျာဂမနာဒိဘိသ္တဝ သမ္ပတ္တိမ် အပဝျယိတဝါန် တသ္မိန္နာဂတမာတြေ တသျဲဝ နိမိတ္တံ ပုၐ္ဋံ ဂေါဝတ္သံ မာရိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","တဒါ တသျ ပိတာဝေါစတ်, ဟေ ပုတြ တွံ သရွွဒါ မယာ သဟာသိ တသ္မာန် မမ ယဒျဒါသ္တေ တတ္သရွွံ တဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","ကိန္တု တဝါယံ ဘြာတာ မၖတး ပုနရဇီဝီဒ် ဟာရိတၑ္စ ဘူတွာ ပြာပ္တောဘူတ်, ဧတသ္မာတ် ကာရဏာဒ် ဥတ္သဝါနန္ဒော် ကရ္တ္တုမ် ဥစိတမသ္မာကမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","အပရဉ္စ ယီၑုး ၑိၐျေဘျောနျာမေကာံ ကထာံ ကထယာမာသ ကသျစိဒ် ဓနဝတော မနုၐျသျ ဂၖဟကာရျျာဓီၑေ သမ္ပတ္တေရပဝျယေ'ပဝါဒိတေ သတိ ");
INSERT INTO sanbur_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","တသျ ပြဘုသ္တမ် အာဟူယ ဇဂါဒ, တွယိ ယာမိမာံ ကထာံ ၑၖဏောမိ သာ ကီဒၖၑီ? တွံ ဂၖဟကာရျျာဓီၑကရ္မ္မဏော ဂဏနာံ ဒရ္ၑယ ဂၖဟကာရျျာဓီၑပဒေ တွံ န သ္ထာသျသိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","တဒါ သ ဂၖဟကာရျျာဓီၑော မနသာ စိန္တယာမာသ, ပြဘု ရျဒိ မာံ ဂၖဟကာရျျာဓီၑပဒါဒ် ဘြံၑယတိ တရှိ ကိံ ကရိၐျေ'ဟံ? မၖဒံ ခနိတုံ မမ ၑက္တိ ရ္နာသ္တိ ဘိက္ၐိတုဉ္စ လဇ္ဇိၐျေ'ဟံ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","အတဧဝ မယိ ဂၖဟကာရျျာဓီၑပဒါတ် စျုတေ သတိ ယထာ လောကာ မဟျမ် အာၑြယံ ဒါသျန္တိ တဒရ္ထံ ယတ္ကရ္မ္မ မယာ ကရဏီယံ တန် နိရ္ဏီယတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","ပၑ္စာတ် သ သွပြဘောရေကဲကမ် အဓမရ္ဏမ် အာဟူယ ပြထမံ ပပြစ္ဆ, တွတ္တော မေ ပြဘုဏာ ကတိ ပြာပျမ်? ");
INSERT INTO sanbur_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","တတး သ ဥဝါစ, ဧကၑတာဎကတဲလာနိ; တဒါ ဂၖဟကာရျျာဓီၑး ပြောဝါစ, တဝ ပတြမာနီယ ၑီဃြမုပဝိၑျ တတြ ပဉ္စာၑတံ လိခ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","ပၑ္စာဒနျမေကံ ပပြစ္ဆ, တွတ္တော မေ ပြဘုဏာ ကတိ ပြာပျမ်? တတး သောဝါဒီဒ် ဧကၑတာဎကဂေါဓူမား; တဒါ သ ကထယာမာသ, တဝ ပတြမာနီယ အၑီတိံ လိခ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","တေနဲဝ ပြဘုသ္တမယထာရ္ထကၖတမ် အဓီၑံ တဒ္ဗုဒ္ဓိနဲပုဏျာတ် ပြၑၑံသ; ဣတ္ထံ ဒီပ္တိရူပသန္တာနေဘျ ဧတတ္သံသာရသျ သန္တာနာ ဝရ္တ္တမာနကာလေ'ဓိကဗုဒ္ဓိမန္တော ဘဝန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","အတော ဝဒါမိ ယူယမပျယထာရ္ထေန ဓနေန မိတြာဏိ လဘဓွံ တတော ယုၐ္မာသု ပဒဘြၐ္ဋေၐွပိ တာနိ စိရကာလမ် အာၑြယံ ဒါသျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ယး ကၑ္စိတ် က္ၐုဒြေ ကာရျျေ ဝိၑွာသျော ဘဝတိ သ မဟတိ ကာရျျေပိ ဝိၑွာသျော ဘဝတိ, ကိန္တု ယး ကၑ္စိတ် က္ၐုဒြေ ကာရျျေ'ဝိၑွာသျော ဘဝတိ သ မဟတိ ကာရျျေပျဝိၑွာသျော ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","အတဧဝ အယထာရ္ထေန ဓနေန ယဒိ ယူယမဝိၑွာသျာ ဇာတာသ္တရှိ သတျံ ဓနံ ယုၐ္မာကံ ကရေၐု ကး သမရ္ပယိၐျတိ? ");
INSERT INTO sanbur_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","ယဒိ စ ပရဓနေန ယူယမ် အဝိၑွာသျာ ဘဝထ တရှိ ယုၐ္မာကံ သွကီယဓနံ ယုၐ္မဘျံ ကော ဒါသျတိ? ");
INSERT INTO sanbur_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","ကောပိ ဒါသ ဥဘော် ပြဘူ သေဝိတုံ န ၑက္နောတိ, ယတ ဧကသ္မိန် ပြီယမာဏော'နျသ္မိန္နပြီယတေ ယဒွါ ဧကံ ဇနံ သမာဒၖတျ တဒနျံ တုစ္ဆီကရောတိ တဒွဒ် ယူယမပိ ဓနေၑွရော် သေဝိတုံ န ၑက္နုထ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","တဒဲတား သရွွား ကထား ၑြုတွာ လောဘိဖိရူၑိနသ္တမုပဇဟသုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","တတး သ ဥဝါစ, ယူယံ မနုၐျာဏာံ နိကဋေ သွာန် နိရ္ဒောၐာန် ဒရ္ၑယထ ကိန္တု ယုၐ္မာကမ် အန္တးကရဏာနီၑွရော ဇာနာတိ, ယတ် မနုၐျာဏာမ် အတိ ပြၑံသျံ တဒ် ဤၑွရသျ ဃၖဏျံ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","ယောဟန အာဂမနပရျျနတံ ယုၐ္မာကံ သမီပေ ဝျဝသ္ထာဘဝိၐျဒွါဒိနာံ လေခနာနိ စာသန် တတး ပြဘၖတိ ဤၑွရရာဇျသျ သုသံဝါဒး ပြစရတိ, ဧကဲကော လောကသ္တန္မဓျံ ယတ္နေန ပြဝိၑတိ စ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ဝရံ နဘသး ပၖထိဝျာၑ္စ လောပေါ ဘဝိၐျတိ တထာပိ ဝျဝသ္ထာယာ ဧကဗိန္ဒောရပိ လောပေါ န ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","ယး ကၑ္စိတ် သွီယာံ ဘာရျျာံ ဝိဟာယ သ္တြိယမနျာံ ဝိဝဟတိ သ ပရဒါရာန် ဂစ္ဆတိ, ယၑ္စ တာ တျက္တာံ နာရီံ ဝိဝဟတိ သောပိ ပရဒါရာန ဂစ္ဆတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ဧကော ဓနီ မနုၐျး ၑုက္လာနိ သူက္ၐ္မာဏိ ဝသ္တြာဏိ ပရျျဒဓာတ် ပြတိဒိနံ ပရိတောၐရူပေဏာဘုံက္တာပိဝစ္စ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","သရွွာင်္ဂေ က္ၐတယုက္တ ဣလိယာသရနာမာ ကၑ္စိဒ် ဒရိဒြသ္တသျ ဓနဝတော ဘောဇနပါတြာတ် ပတိတမ် ဥစ္ဆိၐ္ဋံ ဘောက္တုံ ဝါဉ္ဆန် တသျ ဒွါရေ ပတိတွာတိၐ္ဌတ်; ");
INSERT INTO sanbur_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","အထ ၑွာန အာဂတျ တသျ က္ၐတာနျလိဟန်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","ကိယတ္ကာလာတ္ပရံ သ ဒရိဒြး ပြာဏာန် ဇဟော်; တတး သွရ္ဂီယဒူတာသ္တံ နီတွာ ဣဗြာဟီမး ကြောဍ ဥပဝေၑယာမာသုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ပၑ္စာတ် သ ဓနဝါနပိ မမာရ, တံ ၑ္မၑာနေ သ္ထာပယာမာသုၑ္စ; ကိန္တု ပရလောကေ သ ဝေဒနာကုလး သန် ဦရ္ဒ္ဓွာံ နိရီက္ၐျ ဗဟုဒူရာဒ် ဣဗြာဟီမံ တတ္ကြောဍ ဣလိယာသရဉ္စ ဝိလောကျ ရုဝန္နုဝါစ; ");
INSERT INTO sanbur_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ဟေ ပိတရ် ဣဗြာဟီမ် အနုဂၖဟျ အင်္ဂုလျဂြဘာဂံ ဇလေ မဇ္ဇယိတွာ မမ ဇိဟွာံ ၑီတလာံ ကရ္တ္တုမ် ဣလိယာသရံ ပြေရယ, ယတော ဝဟ္နိၑိခါတောဟံ ဝျထိတောသ္မိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","တဒါ ဣဗြာဟီမ် ဗဘာၐေ, ဟေ ပုတြ တွံ ဇီဝန် သမ္ပဒံ ပြာပ္တဝါန် ဣလိယာသရသ္တု ဝိပဒံ ပြာပ္တဝါန် ဧတတ် သ္မရ, ကိန္တု သမ္ပြတိ တသျ သုခံ တဝ စ ဒုးခံ ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","အပရမပိ ယုၐ္မာကမ် အသ္မာကဉ္စ သ္ထာနယော ရ္မဓျေ မဟဒွိစ္ဆေဒေါ'သ္တိ တတ ဧတတ္သ္ထာနသျ လောကာသ္တတ် သ္ထာနံ ယာတုံ ယဒွါ တတ္သ္ထာနသျ လောကာ ဧတတ် သ္ထာနမာယာတုံ န ၑက္နုဝန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","တဒါ သ ဥက္တဝါန်, ဟေ ပိတသ္တရှိ တွာံ နိဝေဒယာမိ မမ ပိတု ရ္ဂေဟေ ယေ မမ ပဉ္စ ဘြာတရး သန္တိ ");
INSERT INTO sanbur_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","တေ ယထဲတဒ် ယာတနာသ္ထာနံ နာယာသျန္တိ တထာ မန္တြဏာံ ဒါတုံ တေၐာံ သမီပမ် ဣလိယာသရံ ပြေရယ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","တတ ဣဗြာဟီမ် ဥဝါစ, မူသာဘဝိၐျဒွါဒိနာဉ္စ ပုသ္တကာနိ တေၐာံ နိကဋေ သန္တိ တေ တဒွစနာနိ မနျန္တာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","တဒါ သ နိဝေဒယာမာသ, ဟေ ပိတရ် ဣဗြာဟီမ် န တထာ, ကိန္တု ယဒိ မၖတလောကာနာံ ကၑ္စိတ် တေၐာံ သမီပံ ယာတိ တရှိ တေ မနာံသိ ဝျာဃောဋယိၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","တတ ဣဗြာဟီမ် ဇဂါဒ, တေ ယဒိ မူသာဘဝိၐျဒွါဒိနာဉ္စ ဝစနာနိ န မနျန္တေ တရှိ မၖတလောကာနာံ ကသ္မိံၑ္စိဒ် ဥတ္ထိတေပိ တေ တသျ မန္တြဏာံ န မံသျန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ဣတး ပရံ ယီၑုး ၑိၐျာန် ဥဝါစ, ဝိဃ္နဲရဝၑျမ် အာဂန္တဝျံ ကိန္တု ဝိဃ္နာ ယေန ဃဋိၐျန္တေ တသျ ဒုရ္ဂတိ ရ္ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ဧတေၐာံ က္ၐုဒြပြာဏိနာမ် ဧကသျာပိ ဝိဃ္နဇနနာတ် ကဏ္ဌဗဒ္ဓပေၐဏီကသျ တသျ သာဂရာဂါဓဇလေ မဇ္ဇနံ ဘဒြံ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","ယူယံ သွေၐု သာဝဓာနာသ္တိၐ္ဌတ; တဝ ဘြာတာ ယဒိ တဝ ကိဉ္စိဒ် အပရာဓျတိ တရှိ တံ တရ္ဇယ, တေန ယဒိ မနး ပရိဝရ္တ္တယတိ တရှိ တံ က္ၐမသွ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","ပုနရေကဒိနမဓျေ ယဒိ သ တဝ သပ္တကၖတွော'ပရာဓျတိ ကိန္တု သပ္တကၖတွ အာဂတျ မနး ပရိဝရ္တျ မယာပရာဒ္ဓမ် ဣတိ ဝဒတိ တရှိ တံ က္ၐမသွ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","တဒါ ပြေရိတား ပြဘုမ် အဝဒန် အသ္မာကံ ဝိၑွာသံ ဝရ္ဒ္ဓယ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ပြဘုရုဝါစ, ယဒိ ယုၐ္မာကံ သရ္ၐပဲကပြမာဏော ဝိၑွာသောသ္တိ တရှိ တွံ သမူလမုတ္ပာဋိတော ဘူတွာ သမုဒြေ ရောပိတော ဘဝ ကထာယာမ် ဧတသျာမ် ဧတဒုဍုမ္ဗရာယ ကထိတာယာံ သ ယုၐ္မာကမာဇ္ဉာဝဟော ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","အပရံ သွဒါသေ ဟလံ ဝါဟယိတွာ ဝါ ပၑူန် စာရယိတွာ က္ၐေတြာဒ် အာဂတေ သတိ တံ ဝဒတိ, ဧဟိ ဘောက္တုမုပဝိၑ, ယုၐ္မာကမ် ဧတာဒၖၑး ကောသ္တိ? ");
INSERT INTO sanbur_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ဝရဉ္စ ပူရွွံ မမ ခါဒျမာသာဒျ ယာဝဒ် ဘုဉ္ဇေ ပိဝါမိ စ တာဝဒ် ဗဒ္ဓကဋိး ပရိစရ ပၑ္စာတ် တွမပိ ဘောက္ၐျသေ ပါသျသိ စ ကထာမီဒၖၑီံ ကိံ န ဝက္ၐျတိ? ");
INSERT INTO sanbur_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","တေန ဒါသေန ပြဘောရာဇ္ဉာနုရူပေ ကရ္မ္မဏိ ကၖတေ ပြဘုး ကိံ တသ္မိန် ဗာဓိတော ဇာတး? နေတ္ထံ ဗုဓျတေ မယာ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ဣတ္ထံ နိရူပိတေၐု သရွွကရ္မ္မသု ကၖတေၐု သတ္မု ယူယမပီဒံ ဝါကျံ ဝဒထ, ဝယမ် အနုပကာရိဏော ဒါသာ အသ္မာဘိရျဒျတ္ကရ္တ္တဝျံ တန္မာတြမေဝ ကၖတံ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","သ ယိရူၑာလမိ ယာတြာံ ကုရွွန် ၑောမိရောဏ္ဂာလီလ္ပြဒေၑမဓျေန ဂစ္ဆတိ, ");
INSERT INTO sanbur_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ဧတရှိ ကုတြစိဒ် ဂြာမေ ပြဝေၑမာတြေ ဒၑကုၐ္ဌိနသ္တံ သာက္ၐာတ် ကၖတွာ ");
INSERT INTO sanbur_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ဒူရေ တိၐ္ဌနတ ဥစ္စဲ ရွက္တုမာရေဘိရေ, ဟေ ပြဘော ယီၑော ဒယသွာသ္မာန်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","တတး သ တာန် ဒၖၐ္ဋွာ ဇဂါဒ, ယူယံ ယာဇကာနာံ သမီပေ သွာန် ဒရ္ၑယတ, တတသ္တေ ဂစ္ဆန္တော ရောဂါတ် ပရိၐ္ကၖတား၊ ");
INSERT INTO sanbur_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","တဒါ တေၐာမေကး သွံ သွသ္ထံ ဒၖၐ္ဋွာ ပြောစ္စဲရီၑွရံ ဓနျံ ဝဒန် ဝျာဃုဋျာယာတော ယီၑော ရ္ဂုဏာနနုဝဒန် တစ္စရဏာဓောဘူမော် ပပါတ; ");
INSERT INTO sanbur_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","သ စာသီတ် ၑောမိရောဏီ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","တဒါ ယီၑုရဝဒတ်, ဒၑဇနား ကိံ န ပရိၐ္ကၖတား? တဟျနျေ နဝဇနား ကုတြ? ");
INSERT INTO sanbur_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ဤၑွရံ ဓနျံ ဝဒန္တမ် ဧနံ ဝိဒေၑိနံ ဝိနာ ကောပျနျော န ပြာပျတ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","တဒါ သ တမုဝါစ, တွမုတ္ထာယ ယာဟိ ဝိၑွာသသ္တေ တွာံ သွသ္ထံ ကၖတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","အထ ကဒေၑွရသျ ရာဇတွံ ဘဝိၐျတီတိ ဖိရူၑိဘိး ပၖၐ္ဋေ သ ပြတျုဝါစ, ဤၑွရသျ ရာဇတွမ် အဲၑွရျျဒရ္ၑနေန န ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","အတ ဧတသ္မိန် ပၑျ တသ္မိန် ဝါ ပၑျ, ဣတိ ဝါကျံ လောကာ ဝက္တုံ န ၑက္ၐျန္တိ, ဤၑွရသျ ရာဇတွံ ယုၐ္မာကမ် အန္တရေဝါသ္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","တတး သ ၑိၐျာန် ဇဂါဒ, ယဒါ ယုၐ္မာဘိ ရ္မနုဇသုတသျ ဒိနမေကံ ဒြၐ္ဋုမ် ဝါဉ္ဆိၐျတေ ကိန္တု န ဒရ္ၑိၐျတေ, ဤဒၖက္ကာလ အာယာတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","တဒါတြ ပၑျ ဝါ တတြ ပၑျေတိ ဝါကျံ လောကာ ဝက္ၐျန္တိ, ကိန္တု တေၐာံ ပၑ္စာတ် မာ ယာတ, မာနုဂစ္ဆတ စ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","ယတသ္တဍိဒ် ယထာကာၑဲကဒိၑျုဒိယ တဒနျာမပိ ဒိၑံ ဝျာပျ ပြကာၑတေ တဒွတ် နိဇဒိနေ မနုဇသူနုး ပြကာၑိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","ကိန္တု တတ္ပူရွွံ တေနာနေကာနိ ဒုးခါနိ ဘောက္တဝျာနျေတဒွရ္တ္တမာနလောကဲၑ္စ သော'ဝဇ္ဉာတဝျး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","နောဟသျ ဝိဒျမာနကာလေ ယထာဘဝတ် မနုၐျသူနေား ကာလေပိ တထာ ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","ယာဝတ္ကာလံ နောဟော မဟာပေါတံ နာရောဟဒ် အာပ္လာဝိဝါရျျေတျ သရွွံ နာနာၑယစ္စ တာဝတ္ကာလံ ယထာ လောကာ အဘုဉ္ဇတာပိဝန် ဝျဝဟန် ဝျဝါဟယံၑ္စ; ");
INSERT INTO sanbur_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ဣတ္ထံ လောဋော ဝရ္တ္တမာနကာလေပိ ယထာ လောကာ ဘောဇနပါနကြယဝိကြယရောပဏဂၖဟနိရ္မ္မာဏကရ္မ္မသု ပြာဝရ္တ္တန္တ, ");
INSERT INTO sanbur_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ကိန္တု ယဒါ လောဋ် သိဒေါမော နိရ္ဇဂါမ တဒါ နဘသး သဂန္ဓကာဂ္နိဝၖၐ္ဋိ ရ္ဘူတွာ သရွွံ ဝျနာၑယတ္ ");
INSERT INTO sanbur_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","တဒွန် မာနဝပုတြပြကာၑဒိနေပိ ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","တဒါ ယဒိ ကၑ္စိဒ် ဂၖဟောပရိ တိၐ္ဌတိ တရှိ သ ဂၖဟမဓျာတ် ကိမပိ ဒြဝျမာနေတုမ် အဝရုဟျ နဲတု; ယၑ္စ က္ၐေတြေ တိၐ္ဌတိ သောပိ ဝျာဃုဋျ နာယာတု၊ ");
INSERT INTO sanbur_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","လောဋး ပတ္နီံ သ္မရတ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ယး ပြာဏာန် ရက္ၐိတုံ စေၐ္ဋိၐျတေ သ ပြာဏာန် ဟာရယိၐျတိ ယသ္တု ပြာဏာန် ဟာရယိၐျတိ သဧဝ ပြာဏာန် ရက္ၐိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","ယုၐ္မာနဟံ ဝစ္မိ တသျာံ ရာတြော် ၑယျဲကဂတယော ရ္လောကယောရေကော ဓာရိၐျတေ ပရသ္တျက္ၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","သ္တြိယော် ယုဂပတ် ပေၐဏီံ ဝျာဝရ္တ္တယိၐျတသ္တယောရေကာ ဓာရိၐျတေ ပရာတျက္ၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","ပုရုၐော် က္ၐေတြေ သ္ထာသျတသ္တယောရေကော ဓာရိၐျတေ ပရသ္တျက္ၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","တဒါ တေ ပပြစ္ဆုး, ဟေ ပြဘော ကုတြေတ္ထံ ဘဝိၐျတိ? တတး သ ဥဝါစ, ယတြ ၑဝသ္တိၐ္ဌတိ တတြ ဂၖဓြာ မိလန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","အပရဉ္စ လောကဲရက္လာန္တဲ ရ္နိရန္တရံ ပြာရ္ထယိတဝျမ် ဣတျာၑယေန ယီၑုနာ ဒၖၐ္ဋာန္တ ဧကး ကထိတး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","ကုတြစိန္နဂရေ ကၑ္စိတ် ပြာဍွိဝါက အာသီတ် သ ဤၑွရာန္နာဗိဘေတ် မာနုၐာံၑ္စ နာမနျတ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","အထ တတ္ပုရဝါသိနီ ကာစိဒွိဓဝါ တတ္သမီပမေတျ ဝိဝါဒိနာ သဟ မမ ဝိဝါဒံ ပရိၐ္ကုရွွိတိ နိဝေဒယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","တတး သ ပြာဍွိဝါကး ကိယဒ္ဒိနာနိ န တဒင်္ဂီကၖတဝါန် ပၑ္စာစ္စိတ္တေ စိန္တယာမာသ, ယဒျပီၑွရာန္န ဗိဘေမိ မနုၐျာနပိ န မနျေ ");
INSERT INTO sanbur_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","တထာပျေၐာ ဝိဓဝါ မာံ က္လိၑ္နာတိ တသ္မာဒသျာ ဝိဝါဒံ ပရိၐ္ကရိၐျာမိ နောစေတ် သာ သဒါဂတျ မာံ ဝျဂြံ ကရိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ပၑ္စာတ် ပြဘုရဝဒဒ် အသာဝနျာယပြာဍွိဝါကော ယဒါဟ တတြ မနော နိဓဓွံ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ဤၑွရသျ ယေ 'ဘိရုစိတလောကာ ဒိဝါနိၑံ ပြာရ္ထယန္တေ သ ဗဟုဒိနာနိ ဝိလမ္ဗျာပိ တေၐာံ ဝိဝါဒါန် ကိံ န ပရိၐ္ကရိၐျတိ? ");
INSERT INTO sanbur_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","ယုၐ္မာနဟံ ဝဒါမိ တွရယာ ပရိၐ္ကရိၐျတိ, ကိန္တု ယဒါ မနုၐျပုတြ အာဂမိၐျတိ တဒါ ပၖထိဝျာံ ကိမီဒၖၑံ ဝိၑွာသံ ပြာပ္သျတိ? ");
INSERT INTO sanbur_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ယေ သွာန် ဓာရ္မ္မိကာန် ဇ္ဉာတွာ ပရာန် တုစ္ဆီကုရွွန္တိ ဧတာဒၖဂ္ဘျး, ကိယဒ္ဘျ ဣမံ ဒၖၐ္ဋာန္တံ ကထယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","ဧကး ဖိရူၑျပရး ကရသဉ္စာယီ ဒွါဝိမော် ပြာရ္ထယိတုံ မန္ဒိရံ ဂတော်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","တတော'သော် ဖိရူၑျေကပါရ္ၑွေ တိၐ္ဌန် ဟေ ဤၑွရ အဟမနျလောကဝတ် လောဌယိတာနျာယီ ပါရဒါရိကၑ္စ န ဘဝါမိ အသျ ကရသဉ္စာယိနသ္တုလျၑ္စ န, တသ္မာတ္တွာံ ဓနျံ ဝဒါမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","သပ္တသု ဒိနေၐု ဒိနဒွယမုပဝသာမိ သရွွသမ္ပတ္တေ ရ္ဒၑမာံၑံ ဒဒါမိ စ, ဧတတ္ကထာံ ကထယန် ပြာရ္ထယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","ကိန္တု သ ကရသဉ္စာယိ ဒူရေ တိၐ္ဌန် သွရ္ဂံ ဒြၐ္ဋုံ နေစ္ဆန် ဝက္ၐသိ ကရာဃာတံ ကုရွွန် ဟေ ဤၑွရ ပါပိၐ္ဌံ မာံ ဒယသွ, ဣတ္ထံ ပြာရ္ထယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","ယုၐ္မာနဟံ ဝဒါမိ, တယောရ္ဒွယော ရ္မဓျေ ကေဝလး ကရသဉ္စာယီ ပုဏျဝတ္တွေန ဂဏိတော နိဇဂၖဟံ ဇဂါမ, ယတော ယး ကၑ္စိတ် သွမုန္နမယတိ သ နာမယိၐျတေ ကိန္တု ယး ကၑ္စိတ် သွံ နမယတိ သ ဥန္နမယိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","အထ ၑိၑူနာံ ဂါတြသ္ပရ္ၑာရ္ထံ လောကာသ္တာန် တသျ သမီပမာနိနျုး ၑိၐျာသ္တဒ် ဒၖၐ္ဋွာနေတၖန် တရ္ဇယာမာသုး, ");
INSERT INTO sanbur_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","ကိန္တု ယီၑုသ္တာနာဟူယ ဇဂါဒ, မန္နိကဋမ် အာဂန္တုံ ၑိၑူန် အနုဇာနီဓွံ တာံၑ္စ မာ ဝါရယတ; ယတ ဤၑွရရာဇျာဓိကာရိဏ ဧၐာံ သဒၖၑား၊ ");
INSERT INTO sanbur_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","အဟံ ယုၐ္မာန် ယထာရ္ထံ ဝဒါမိ, ယော ဇနး ၑိၑေား သဒၖၑော ဘူတွာ ဤၑွရရာဇျံ န ဂၖဟ္လာတိ သ ကေနာပိ ပြကာရေဏ တတ် ပြဝေၐ္ဋုံ န ၑက္နောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","အပရမ် ဧကောဓိပတိသ္တံ ပပြစ္ဆ, ဟေ ပရမဂုရော, အနန္တာယုၐး ပြာပ္တယေ မယာ ကိံ ကရ္တ္တဝျံ? ");
INSERT INTO sanbur_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","ယီၑုရုဝါစ, မာံ ကုတး ပရမံ ဝဒသိ? ဤၑွရံ ဝိနာ ကောပိ ပရမော န ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","ပရဒါရာန် မာ ဂစ္ဆ, နရံ မာ ဇဟိ, မာ စောရယ, မိထျာသာက္ၐျံ မာ ဒေဟိ, မာတရံ ပိတရဉ္စ သံမနျသွ, ဧတာ ယာ အာဇ္ဉား သန္တိ တာသ္တွံ ဇာနာသိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","တဒါ သ ဥဝါစ, ဗာလျကာလာတ် သရွွာ ဧတာ အာစရာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ဣတိ ကထာံ ၑြုတွာ ယီၑုသ္တမဝဒတ်, တထာပိ တဝဲကံ ကရ္မ္မ နျူနမာသ္တေ, နိဇံ သရွွသွံ ဝိကြီယ ဒရိဒြေဘျော ဝိတရ, တသ္မာတ် သွရ္ဂေ ဓနံ ပြာပ္သျသိ; တတ အာဂတျ မမာနုဂါမီ ဘဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","ကိန္တွေတာံ ကထာံ ၑြုတွာ သောဓိပတိး ၑုၑောစ, ယတသ္တသျ ဗဟုဓနမာသီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","တဒါ ယီၑုသ္တမတိၑောကာနွိတံ ဒၖၐ္ဋွာ ဇဂါဒ, ဓနဝတာမ် ဤၑွရရာဇျပြဝေၑး ကီဒၖဂ် ဒုၐ္ကရး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ဤၑွရရာဇျေ ဓနိနး ပြဝေၑာတ် သူစေၑ္ဆိဒြေဏ မဟာင်္ဂသျ ဂမနာဂမနေ သုကရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","ၑြောတာရး ပပြစ္ဆုသ္တရှိ ကေန ပရိတြာဏံ ပြာပ္သျတေ? ");
INSERT INTO sanbur_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","သ ဥက္တဝါန်, ယန် မာနုၐေဏာၑကျံ တဒ် ဤၑွရေဏ ၑကျံ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","တဒါ ပိတရ ဥဝါစ, ပၑျ ဝယံ သရွွသွံ ပရိတျဇျ တဝ ပၑ္စာဒ္ဂါမိနော'ဘဝါမ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","တတး သ ဥဝါစ, ယုၐ္မာနဟံ ယထာရ္ထံ ဝဒါမိ, ဤၑွရရာဇျာရ္ထံ ဂၖဟံ ပိတရော် ဘြာတၖဂဏံ ဇာယာံ သန္တာနာံၑ္စ တျက္တဝါ ");
INSERT INTO sanbur_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ဣဟ ကာလေ တတော'ဓိကံ ပရကာလေ 'နန္တာယုၑ္စ န ပြာပ္သျတိ လောက ဤဒၖၑး ကောပိ နာသ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","အနန္တရံ သ ဒွါဒၑၑိၐျာနာဟူယ ဗဘာၐေ, ပၑျတ ဝယံ ယိရူၑာလမ္နဂရံ ယာမး, တသ္မာတ် မနုၐျပုတြေ ဘဝိၐျဒွါဒိဘိရုက္တံ ယဒသ္တိ တဒနုရူပံ တံ ပြတိ ဃဋိၐျတေ; ");
INSERT INTO sanbur_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","ဝသ္တုတသ္တု သော'နျဒေၑီယာနာံ ဟသ္တေၐု သမရ္ပယိၐျတေ, တေ တမုပဟသိၐျန္တိ, အနျာယမာစရိၐျန္တိ တဒွပုၐိ နိၐ္ဌီဝံ နိက္ၐေပ္သျန္တိ, ကၑာဘိး ပြဟၖတျ တံ ဟနိၐျန္တိ စ, ");
INSERT INTO sanbur_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ကိန္တု တၖတီယဒိနေ သ ၑ္မၑာနာဒ် ဥတ္ထာသျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ဧတသျား ကထာယာ အဘိပြာယံ ကိဉ္စိဒပိ တေ ဗောဒ္ဓုံ န ၑေကုး တေၐာံ နိကဋေ'သ္ပၐ္ဋတဝါတ် တသျဲတာသာံ ကထာနာမ် အာၑယံ တေ ဇ္ဉာတုံ န ၑေကုၑ္စ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","အထ တသ္မိန် ယိရီဟေား ပုရသျာန္တိကံ ပြာပ္တေ ကၑ္စိဒန္ဓး ပထး ပါရ္ၑွ ဥပဝိၑျ ဘိက္ၐာမ် အကရောတ္ ");
INSERT INTO sanbur_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","သ လောကသမူဟသျ ဂမနၑဗ္ဒံ ၑြုတွာ တတ္ကာရဏံ ပၖၐ္ဋဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","နာသရတီယယီၑုရျာတီတိ လောကဲရုက္တေ သ ဥစ္စဲရွက္တုမာရေဘေ, ");
INSERT INTO sanbur_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ဟေ ဒါယူဒး သန္တာန ယီၑော မာံ ဒယသွ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","တတောဂြဂါမိနသ္တံ မော်နီ တိၐ္ဌေတိ တရ္ဇယာမာသုး ကိန္တု သ ပုနာရုဝန် ဥဝါစ, ဟေ ဒါယူဒး သန္တာန မာံ ဒယသွ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","တဒါ ယီၑုး သ္ထဂိတော ဘူတွာ သွာန္တိကေ တမာနေတုမ် အာဒိဒေၑ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","တတး သ တသျာန္တိကမ် အာဂမတ်, တဒါ သ တံ ပပြစ္ဆ, တွံ ကိမိစ္ဆသိ? တွဒရ္ထမဟံ ကိံ ကရိၐျာမိ? သ ဥက္တဝါန်, ဟေ ပြဘော'ဟံ ဒြၐ္ဋုံ လဘဲ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","တဒါ ယီၑုရုဝါစ, ဒၖၐ္ဋိၑက္တိံ ဂၖဟာဏ တဝ ပြတျယသ္တွာံ သွသ္ထံ ကၖတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","တတသ္တတ္က္ၐဏာတ် တသျ စက္ၐုၐီ ပြသန္နေ; တသ္မာတ် သ ဤၑွရံ ဓနျံ ဝဒန် တတ္ပၑ္စာဒ် ယယော်, တဒါလောကျ သရွွေ လောကာ ဤၑွရံ ပြၑံသိတုမ် အာရေဘိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","ယဒါ ယီၑု ရျိရီဟောပုရံ ပြဝိၑျ တန္မဓျေန ဂစ္ဆံသ္တဒါ ");
INSERT INTO sanbur_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","သက္ကေယနာမာ ကရသဉ္စာယိနာံ ပြဓာနော ဓနဝါနေကော ");
INSERT INTO sanbur_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ယီၑုး ကီဒၖဂိတိ ဒြၐ္ဋုံ စေၐ္ဋိတဝါန် ကိန္တု ခရွွတွာလ္လောကသံဃမဓျေ တဒ္ဒရ္ၑနမပြာပျ ");
INSERT INTO sanbur_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","ယေန ပထာ သ ယာသျတိ တတ္ပထေ'ဂြေ ဓာဝိတွာ တံ ဒြၐ္ဋုမ် ဥဍုမ္ဗရတရုမာရုရောဟ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","ပၑ္စာဒ် ယီၑုသ္တတ္သ္ထာနမ် ဣတွာ ဦရ္ဒ္ဓွံ ဝိလောကျ တံ ဒၖၐ္ဋွာဝါဒီတ်, ဟေ သက္ကေယ တွံ ၑီဃြမဝရောဟ မယာဒျ တွဒ္ဂေဟေ ဝသ္တဝျံ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","တတး သ ၑီဃြမဝရုဟျ သာဟ္လာဒံ တံ ဇဂြာဟ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","တဒ် ဒၖၐ္ဋွာ သရွွေ ဝိဝဒမာနာ ဝက္တုမာရေဘိရေ, သောတိထိတွေန ဒုၐ္ဋလောကဂၖဟံ ဂစ္ဆတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","ကိန္တု သက္ကေယော ဒဏ္ဍာယမာနော ဝက္တုမာရေဘေ, ဟေ ပြဘော ပၑျ မမ ယာ သမ္ပတ္တိရသ္တိ တဒရ္ဒ္ဓံ ဒရိဒြေဘျော ဒဒေ, အပရမ် အနျာယံ ကၖတွာ ကသ္မာဒပိ ယဒိ ကဒါပိ ကိဉ္စိတ် မယာ ဂၖဟီတံ တရှိ တစ္စတုရ္ဂုဏံ ဒဒါမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","တဒါ ယီၑုသ္တမုက္တဝါန် အယမပိ ဣဗြာဟီမး သန္တာနော'တး ကာရဏာဒ် အဒျာသျ ဂၖဟေ တြာဏမုပသ္ထိတံ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","ယဒ် ဟာရိတံ တတ် မၖဂယိတုံ ရက္ၐိတုဉ္စ မနုၐျပုတြ အာဂတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","အထ သ ယိရူၑာလမး သမီပ ဥပါတိၐ္ဌဒ် ဤၑွရရာဇတွသျာနုၐ္ဌာနံ တဒဲဝ ဘဝိၐျတီတိ လောကဲရနွဘူယတ, တသ္မာတ် သ ၑြောတၖဘျး ပုနရ္ဒၖၐ္ဋာန္တကထာမ် ဥတ္ထာပျ ကထယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ကောပိ မဟာလ္လောကော နိဇာရ္ထံ ရာဇတွပဒံ ဂၖဟီတွာ ပုနရာဂန္တုံ ဒူရဒေၑံ ဇဂါမ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ယာတြာကာလေ နိဇာန် ဒၑဒါသာန် အာဟူယ ဒၑသွရ္ဏမုဒြာ ဒတ္တွာ မမာဂမနပရျျန္တံ ဝါဏိဇျံ ကုရုတေတျာဒိဒေၑ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","ကိန္တု တသျ ပြဇာသ္တမဝဇ္ဉာယ မနုၐျမေနမ် အသ္မာကမုပရိ ရာဇတွံ န ကာရယိဝျာမ ဣမာံ ဝါရ္တ္တာံ တန္နိကဋေ ပြေရယာမာသုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","အထ သ ရာဇတွပဒံ ပြာပျာဂတဝါန် ဧကဲကော ဇနော ဗာဏိဇျေန ကိံ လဗ္ဓဝါန် ဣတိ ဇ္ဉာတုံ ယေၐု ဒါသေၐု မုဒြာ အရ္ပယတ် တာန် အာဟူယာနေတုမ် အာဒိဒေၑ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","တဒါ ပြထမ အာဂတျ ကထိတဝါန်, ဟေ ပြဘော တဝ တယဲကယာ မုဒြယာ ဒၑမုဒြာ လဗ္ဓား၊ ");
INSERT INTO sanbur_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","တတး သ ဥဝါစ တွမုတ္တမော ဒါသး သွလ္ပေန ဝိၑွာသျော ဇာတ ဣတး ကာရဏာတ် တွံ ဒၑနဂရာဏာမ် အဓိပေါ ဘဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","ဒွိတီယ အာဂတျ ကထိတဝါန်, ဟေ ပြဘော တဝဲကယာ မုဒြယာ ပဉ္စမုဒြာ လဗ္ဓား၊ ");
INSERT INTO sanbur_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","တတး သ ဥဝါစ, တွံ ပဉ္စာနာံ နဂရာဏာမဓိပတိ ရ္ဘဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","တတောနျ အာဂတျ ကထယာမာသ, ဟေ ပြဘော ပၑျ တဝ ယာ မုဒြာ အဟံ ဝသ္တြေ ဗဒ္ဓွာသ္ထာပယံ သေယံ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","တွံ ကၖပဏော ယန္နာသ္ထာပယသ္တဒပိ ဂၖဟ္လာသိ, ယန္နာဝပသ္တဒေဝ စ ဆိနတ္သိ တတောဟံ တွတ္တော ဘီတး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","တဒါ သ ဇဂါဒ, ရေ ဒုၐ္ဋဒါသ တဝ ဝါကျေန တွာံ ဒေါၐိဏံ ကရိၐျာမိ, ယဒဟံ နာသ္ထာပယံ တဒေဝ ဂၖဟ္လာမိ, ယဒဟံ နာဝပဉ္စ တဒေဝ ဆိနဒ္မိ, ဧတာဒၖၑး ကၖပဏောဟမိတိ ယဒိ တွံ ဇာနာသိ, ");
INSERT INTO sanbur_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","တရှိ မမ မုဒြာ ဗဏိဇာံ နိကဋေ ကုတော နာသ္ထာပယး? တယာ ကၖတေ'ဟမ် အာဂတျ ကုသီဒေန သာရ္ဒ္ဓံ နိဇမုဒြာ အပြာပ္သျမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","ပၑ္စာတ် သ သမီပသ္ထာန် ဇနာန် အာဇ္ဉာပယတ် အသ္မာတ် မုဒြာ အာနီယ ယသျ ဒၑမုဒြား သန္တိ တသ္မဲ ဒတ္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","တေ ပြောစုး ပြဘော'သျ ဒၑမုဒြား သန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","ယုၐ္မာနဟံ ဝဒါမိ ယသျာၑြယေ ဝဒ္ဓတေ 'ဓိကံ တသ္မဲ ဒါယိၐျတေ, ကိန္တု ယသျာၑြယေ န ဝရ္ဒ္ဓတေ တသျ ယဒျဒသ္တိ တဒပိ တသ္မာန် နာယိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ကိန္တု မမာဓိပတိတွသျ ဝၑတွေ သ္ထာတုမ် အသမ္မနျမာနာ ယေ မမ ရိပဝသ္တာနာနီယ မမ သမက္ၐံ သံဟရတ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ဣတျုပဒေၑကထာံ ကထယိတွာ သောဂြဂး သန် ယိရူၑာလမပုရံ ယယော်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","တတော ဗဲတ္ဖဂီဗဲထနီယာဂြာမယေား သမီပေ ဇဲတုနာဒြေရန္တိကမ် ဣတွာ ၑိၐျဒွယမ် ဣတျုက္တွာ ပြေၐယာမာသ, ");
INSERT INTO sanbur_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ယုဝါမမုံ သမ္မုခသ္ထဂြာမံ ပြဝိၑျဲဝ ယံ ကောပိ မာနုၐး ကဒါပိ နာရောဟတ် တံ ဂရ္ဒ္ဒဘၑာဝကံ ဗဒ္ဓံ ဒြက္ၐျထသ္တံ မောစယိတွာနယတံ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","တတြ ကုတော မောစယထး? ဣတိ စေတ် ကောပိ ဝက္ၐျတိ တရှိ ဝက္ၐျထး ပြဘေाရတြ ပြယောဇနမ် အာသ္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","တဒါ တော် ပြရိတော် ဂတွာ တတ္ကထာाနုသာရေဏ သရွွံ ပြာပ္တော်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ဂရ္ဒဘၑာဝကမောစနကာလေ တတွာမိန ဦစုး, ဂရ္ဒဘၑာဝကံ ကုတော မောစယထး? ");
INSERT INTO sanbur_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","တာဝူစတုး ပြဘောရတြ ပြယောဇနမ် အာသ္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","ပၑ္စာတ် တော် တံ ဂရ္ဒဘၑာဝကံ ယီၑောရန္တိကမာနီယ တတ္ပၖၐ္ဌေ နိဇဝသနာနိ ပါတယိတွာ တဒုပရိ ယီၑုမာရောဟယာမာသတုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","အထ ယာတြာကာလေ လောကား ပထိ သွဝသ္တြာဏိ ပါတယိတုမ် အာရေဘိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","အပရံ ဇဲတုနာဒြေရုပတျကာမ် ဣတွာ ၑိၐျသံဃး ပူရွွဒၖၐ္ဋာနိ မဟာကရ္မ္မာဏိ သ္မၖတွာ, ");
INSERT INTO sanbur_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","ယော ရာဇာ ပြဘော ရ္နာမ္နာယာတိ သ ဓနျး သွရ္ဂေ ကုၑလံ သရွွောစ္စေ ဇယဓွနိ ရ္ဘဝတု, ကထာမေတာံ ကထယိတွာ သာနန္ဒမ် ဥစဲရီၑွရံ ဓနျံ ဝက္တုမာရေဘေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","တဒါ လောကာရဏျမဓျသ္ထား ကိယန္တး ဖိရူၑိနသ္တတ် ၑြုတွာ ယီၑုံ ပြောစုး, ဟေ ဥပဒေၑက သွၑိၐျာန် တရ္ဇယ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","သ ဥဝါစ, ယုၐ္မာနဟံ ဝဒါမိ ယဒျမီ နီရဝါသ္တိၐ္ဌန္တိ တရှိ ပါၐာဏာ ဥစဲး ကထား ကထယိၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","ပၑ္စာတ် တတ္ပုရာန္တိကမေတျ တဒဝလောကျ သာၑြုပါတံ ဇဂါဒ, ");
INSERT INTO sanbur_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ဟာ ဟာ စေတ် တွမဂြေ'ဇ္ဉာသျထား, တဝါသ္မိန္နေဝ ဒိနေ ဝါ ယဒိ သွမင်္ဂလမ် ဥပါလပ္သျထား, တရှျုတ္တမမ် အဘဝိၐျတ်, ကိန္တု က္ၐဏေသ္မိန် တတ္တဝ ဒၖၐ္ဋေရဂေါစရမ် ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","တွံ သွတြာဏကာလေ န မနော နျဓတ္ထာ ဣတိ ဟေတော ရျတ္ကာလေ တဝ ရိပဝသ္တွာံ စတုရ္ဒိက္ၐု ပြာစီရေဏ ဝေၐ္ဋယိတွာ ရောတ္သျန္တိ ");
INSERT INTO sanbur_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ဗာလကဲး သာရ္ဒ္ဓံ ဘူမိသာတ် ကရိၐျန္တိ စ တွန္မဓျေ ပါၐာဏဲကောပိ ပါၐာဏောပရိ န သ္ထာသျတိ စ, ကာလ ဤဒၖၑ ဥပသ္ထာသျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","အထ မဓျေမန္ဒိရံ ပြဝိၑျ တတြတျာန် ကြယိဝိကြယိဏော ဗဟိၐ္ကုရွွန္ ");
INSERT INTO sanbur_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","အဝဒတ် မဒ္ဂၖဟံ ပြာရ္ထနာဂၖဟမိတိ လိပိရာသ္တေ ကိန္တု ယူယံ တဒေဝ စဲရာဏာံ ဂဟွရံ ကုရုထ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","ပၑ္စာတ် သ ပြတျဟံ မဓျေမန္ဒိရမ် ဥပဒိဒေၑ; တတး ပြဓာနယာဇကာ အဓျာပကား ပြာစီနာၑ္စ တံ နာၑယိတုံ စိစေၐ္ဋိရေ; ");
INSERT INTO sanbur_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ကိန္တု တဒုပဒေၑေ သရွွေ လောကာ နိဝိၐ္ဋစိတ္တား သ္ထိတာသ္တသ္မာတ် တေ တတ္ကရ္တ္တုံ နာဝကာၑံ ပြာပုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","အထဲကဒါ ယီၑု ရ္မနိဒရေ သုသံဝါဒံ ပြစာရယန် လောကာနုပဒိၑတိ, ဧတရှိ ပြဓာနယာဇကာ အဓျာပကား ပြာဉ္စၑ္စ တန္နိကဋမာဂတျ ပပြစ္ဆုး ");
INSERT INTO sanbur_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ကယာဇ္ဉယာ တွံ ကရ္မ္မာဏျေတာနိ ကရောၐိ? ကော ဝါ တွာမာဇ္ဉာပယတ်? တဒသ္မာန် ဝဒ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","သ ပြတျုဝါစ, တရှိ ယုၐ္မာနပိ ကထာမေကာံ ပၖစ္ဆာမိ တသျောတ္တရံ ဝဒတ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ယောဟနော မဇ္ဇနမ် ဤၑွရသျ မာနုၐာဏာံ ဝါဇ္ဉာတော ဇာတံ? ");
INSERT INTO sanbur_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","တတသ္တေ မိထော ဝိဝိစျ ဇဂဒုး, ယဒီၑွရသျ ဝဒါမသ္တရှိ တံ ကုတော န ပြတျဲတ သ ဣတိ ဝက္ၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","ယဒိ မနုၐျသျေတိ ဝဒါမသ္တရှိ သရွွေ လောကာ အသ္မာန် ပါၐာဏဲ ရှနိၐျန္တိ ယတော ယောဟန် ဘဝိၐျဒွါဒီတိ သရွွေ ဒၖဎံ ဇာနန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","အတဧဝ တေ ပြတျူစုး ကသျာဇ္ဉယာ ဇာတမ် ဣတိ ဝက္တုံ န ၑက္နုမး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","တဒါ ယီၑုရဝဒတ် တရှိ ကယာဇ္ဉယာ ကရ္မ္မာဏျေတာတိ ကရောမီတိ စ ယုၐ္မာန် န ဝက္ၐျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","အထ လောကာနာံ သာက္ၐာတ် သ ဣမာံ ဒၖၐ္ဋာန္တကထာံ ဝက္တုမာရေဘေ, ကၑ္စိဒ် ဒြာက္ၐာက္ၐေတြံ ကၖတွာ တတ် က္ၐေတြံ ကၖၐီဝလာနာံ ဟသ္တေၐု သမရ္ပျ ဗဟုကာလာရ္ထံ ဒူရဒေၑံ ဇဂါမ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","အထ ဖလကာလေ ဖလာနိ ဂြဟီတု ကၖၐီဝလာနာံ သမီပေ ဒါသံ ပြာဟိဏောတ် ကိန္တု ကၖၐီဝလာသ္တံ ပြဟၖတျ ရိက္တဟသ္တံ ဝိသသရ္ဇုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","တတး သောဓိပတိး ပုနရနျံ ဒါသံ ပြေၐယာမာသ, တေ တမပိ ပြဟၖတျ ကုဝျဝဟၖတျ ရိက္တဟသ္တံ ဝိသသၖဇုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","တတး သ တၖတီယဝါရမ် အနျံ ပြာဟိဏောတ် တေ တမပိ က္ၐတာင်္ဂံ ကၖတွာ ဗဟိ ရ္နိစိက္ၐိပုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","တဒါ က္ၐေတြပတိ ရွိစာရယာမာသ, မမေဒါနီံ ကိံ ကရ္တ္တဝျံ? မမ ပြိယေ ပုတြေ ပြဟိတေ တေ တမဝၑျံ ဒၖၐ္ဋွာ သမာဒရိၐျန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","ကိန္တု ကၖၐီဝလာသ္တံ နိရီက္ၐျ ပရသ္ပရံ ဝိဝိစျ ပြောစုး, အယမုတ္တရာဓိကာရီ အာဂစ္ဆတဲနံ ဟန္မသ္တတောဓိကာရောသ္မာကံ ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","တတသ္တေ တံ က္ၐေတြာဒ် ဗဟိ ရ္နိပါတျ ဇဃ္နုသ္တသ္မာတ် သ က္ၐေတြပတိသ္တာန် ပြတိ ကိံ ကရိၐျတိ? ");
INSERT INTO sanbur_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","သ အာဂတျ တာန် ကၖၐီဝလာန် ဟတွာ ပရေၐာံ ဟသ္တေၐု တတ္က္ၐေတြံ သမရ္ပယိၐျတိ; ဣတိ ကထာံ ၑြုတွာ တေ 'ဝဒန် ဧတာဒၖၑီ ဃဋနာ န ဘဝတု၊ ");
INSERT INTO sanbur_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","ကိန္တု ယီၑုသ္တာနဝလောကျ ဇဂါဒ, တရှိ, သ္ထပတယး ကရိၐျန္တိ ဂြာဝါဏံ ယန္တု တုစ္ဆကံ၊ ပြဓာနပြသ္တရး ကောဏေ သ ဧဝ ဟိ ဘဝိၐျတိ၊ ဧတသျ ၑာသ္တြီယဝစနသျ ကိံ တာတ္ပရျျံ? ");
INSERT INTO sanbur_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","အပရံ တတ္ပာၐာဏောပရိ ယး ပတိၐျတိ သ ဘံက္ၐျတေ ကိန္တု ယသျောပရိ သ ပါၐာဏး ပတိၐျတိ သ တေန ဓူလိဝစ် စူရ္ဏီဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","သောသ္မာကံ ဝိရုဒ္ဓံ ဒၖၐ္ဋာန္တမိမံ ကထိတဝါန် ဣတိ ဇ္ဉာတွာ ပြဓာနယာဇကာ အဓျာပကာၑ္စ တဒဲဝ တံ ဓရ္တုံ ဝဝါဉ္ဆုး ကိန္တု လောကေဘျော ဗိဘျုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","အတဧဝ တံ ပြတိ သတရ္ကား သန္တး ကထံ တဒွါကျဒေါၐံ ဓၖတွာ တံ ဒေၑာဓိပသျ သာဓုဝေၑဓာရိဏၑ္စရာန် တသျ သမီပေ ပြေၐယာမာသုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","တဒါ တေ တံ ပပြစ္ဆုး, ဟေ ဥပဒေၑက ဘဝါန် ယထာရ္ထံ ကထယန် ဥပဒိၑတိ, ကမပျနပေက္ၐျ သတျတွေနဲၑွရံ မာရ္ဂမုပဒိၑတိ, ဝယမေတဇ္ဇာနီမး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ကဲသရရာဇာယ ကရောသ္မာဘိ ရ္ဒေယော န ဝါ? ");
INSERT INTO sanbur_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","သ တေၐာံ ဝဉ္စနံ ဇ္ဉာတွာဝဒတ် ကုတော မာံ ပရီက္ၐဓွေ? မာံ မုဒြာမေကံ ဒရ္ၑယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","ဣဟ လိခိတာ မူရ္တိရိယံ နာမ စ ကသျ? တေ'ဝဒန် ကဲသရသျ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","တဒါ သ ဥဝါစ, တရှိ ကဲသရသျ ဒြဝျံ ကဲသရာယ ဒတ္တ; ဤၑွရသျ တု ဒြဝျမီၑွရာယ ဒတ္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","တသ္မာလ္လောကာနာံ သာက္ၐာတ် တတ္ကထာယား ကမပိ ဒေါၐံ ဓရ္တုမပြာပျ တေ တသျောတ္တရာဒ် အာၑ္စရျျံ မနျမာနာ မော်နိနသ္တသ္ထုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","အပရဉ္စ ၑ္မၑာနာဒုတ္ထာနာနင်္ဂီကာရိဏာံ သိဒူကိနာံ ကိယန္တော ဇနာ အာဂတျ တံ ပပြစ္ဆုး, ");
INSERT INTO sanbur_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","ဟေ ဥပဒေၑက ၑာသ္တြေ မူသာ အသ္မာန် ပြတီတိ လိလေခ ယသျ ဘြာတာ ဘာရျျာယာံ သတျာံ နိးသန္တာနော မြိယတေ သ တဇ္ဇာယာံ ဝိဝဟျ တဒွံၑမ် ဥတ္ပာဒယိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","တထာစ ကေစိတ် သပ္တ ဘြာတရ အာသန် တေၐာံ ဇျေၐ္ဌော ဘြာတာ ဝိဝဟျ နိရပတျး ပြာဏာန် ဇဟော်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","အထ ဒွိတီယသ္တသျ ဇာယာံ ဝိဝဟျ နိရပတျး သန် မမာရ၊ တၖတီယၑ္စ တာမေဝ ဝျုဝါဟ; ");
INSERT INTO sanbur_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ဣတ္ထံ သပ္တ ဘြာတရသ္တာမေဝ ဝိဝဟျ နိရပတျား သန္တော မမြုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ၑေၐေ သာ သ္တြီ စ မမာရ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","အတဧဝ ၑ္မၑာနာဒုတ္ထာနကာလေ တေၐာံ သပ္တဇနာနာံ ကသျ သာ ဘာရျျာ ဘဝိၐျတိ? ယတး သာ တေၐာံ သပ္တာနာမေဝ ဘာရျျာသီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","တဒါ ယီၑုး ပြတျုဝါစ, ဧတသျ ဇဂတော လောကာ ဝိဝဟန္တိ ဝါဂ္ဒတ္တာၑ္စ ဘဝန္တိ ");
INSERT INTO sanbur_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ကိန္တု ယေ တဇ္ဇဂတ္ပြာပ္တိယောဂျတွေန ဂဏိတာံ ဘဝိၐျန္တိ ၑ္မၑာနာစ္စောတ္ထာသျန္တိ တေ န ဝိဝဟန္တိ ဝါဂ္ဒတ္တာၑ္စ န ဘဝန္တိ, ");
INSERT INTO sanbur_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","တေ ပုန ရ္န မြိယန္တေ ကိန္တု ၑ္မၑာနာဒုတ္ထာပိတား သန္တ ဤၑွရသျ သန္တာနား သွရ္ဂီယဒူတာနာံ သဒၖၑာၑ္စ ဘဝန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","အဓိကန္တု မူသား သ္တမ္ဗောပါချာနေ ပရမေၑွရ ဤဗြာဟီမ ဤၑွရ ဣသှာက ဤၑွရော ယာကူဗၑ္စေၑွရ ဣတျုက္တွာ မၖတာနာံ ၑ္မၑာနာဒ် ဥတ္ထာနသျ ပြမာဏံ လိလေခ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","အတဧဝ ယ ဤၑွရး သ မၖတာနာံ ပြဘု ရ္န ကိန္တု ဇီဝတာမေဝ ပြဘုး, တန္နိကဋေ သရွွေ ဇီဝန္တး သန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ဣတိ ၑြုတွာ ကိယန္တောဓျာပကာ ဦစုး, ဟေ ဥပဒေၑက ဘဝါန် ဘဒြံ ပြတျုက္တဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ဣတး ပရံ တံ ကိမပိ ပြၐ္ဋံ တေၐာံ ပြဂလ္ဘတာ နာဘူတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ပၑ္စာတ် သ တာန် ဥဝါစ, ယး ခြီၐ္ဋး သ ဒါယူဒး သန္တာန ဧတာံ ကထာံ လောကား ကထံ ကထယန္တိ? ");
INSERT INTO sanbur_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","ယတး မမ ပြဘုမိဒံ ဝါကျမဝဒတ် ပရမေၑွရး၊ တဝ ၑတြူနဟံ ယာဝတ် ပါဒပီဌံ ကရောမိ န၊ တာဝတ် ကာလံ မဒီယေ တွံ ဒက္ၐပါရ္ၑွ ဥပါဝိၑ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ဣတိ ကထာံ ဒါယူဒ် သွယံ ဂီတဂြန္ထေ'ဝဒတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","အတဧဝ ယဒိ ဒါယူဒ် တံ ပြဘုံ ဝဒတိ, တရှိ သ ကထံ တသျ သန္တာနော ဘဝတိ? ");
INSERT INTO sanbur_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","ပၑ္စာဒ် ယီၑုး သရွွဇနာနာံ ကရ္ဏဂေါစရေ ၑိၐျာနုဝါစ, ");
INSERT INTO sanbur_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","ယေ'ဓျာပကာ ဒီရ္ဃပရိစ္ဆဒံ ပရိဓာယ ဘြမန္တိ, ဟဋ္ဋာပဏယော ရ္နမသ္ကာရေ ဘဇနဂေဟသျ ပြောစ္စာသနေ ဘောဇနဂၖဟသျ ပြဓာနသ္ထာနေ စ ပြီယန္တေ ");
INSERT INTO sanbur_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ဝိဓဝါနာံ သရွွသွံ ဂြသိတွာ ဆလေန ဒီရ္ဃကာလံ ပြာရ္ထယန္တေ စ တေၐု သာဝဓာနာ ဘဝတ, တေၐာမုဂြဒဏ္ဍော ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","အထ ဓနိလောကာ ဘာဏ္ဍာဂါရေ ဓနံ နိက္ၐိပန္တိ သ တဒေဝ ပၑျတိ, ");
INSERT INTO sanbur_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ဧတရှိ ကာစိဒ္ဒီနာ ဝိဓဝါ ပဏဒွယံ နိက္ၐိပတိ တဒ် ဒဒရ္ၑ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","တတော ယီၑုရုဝါစ ယုၐ္မာနဟံ ယထာရ္ထံ ဝဒါမိ, ဒရိဒြေယံ ဝိဓဝါ သရွွေဘျောဓိကံ နျက္ၐေပ္သီတ်, ");
INSERT INTO sanbur_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ယတောနျေ သွပြာဇျဓနေဘျ ဤၑွရာယ ကိဉ္စိတ် နျက္ၐေပ္သုး, ကိန္တု ဒရိဒြေယံ ဝိဓဝါ ဒိနယာပနာရ္ထံ သွသျ ယတ် ကိဉ္စိတ် သ္ထိတံ တတ် သရွွံ နျက္ၐေပ္သီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","အပရဉ္စ ဥတ္တမပြသ္တရဲရုတ္သၖၐ္ဋဝျဲၑ္စ မန္ဒိရံ သုၑောဘတေတရာံ ကဲၑ္စိဒိတျုက္တေ သ ပြတျုဝါစ ");
INSERT INTO sanbur_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","ယူယံ ယဒိဒံ နိစယနံ ပၑျထ, အသျ ပါၐာဏဲကောပျနျပါၐာဏောပရိ န သ္ထာသျတိ, သရွွေ ဘူသာဒ္ဘဝိၐျန္တိ ကာလောယမာယာတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","တဒါ တေ ပပြစ္ဆုး, ဟေ ဂုရော ဃဋနေဒၖၑီ ကဒါ ဘဝိၐျတိ? ဃဋနာယာ ဧတသျသၑ္စိဟ္နံ ဝါ ကိံ ဘဝိၐျတိ? ");
INSERT INTO sanbur_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","တဒါ သ ဇဂါဒ, သာဝဓာနာ ဘဝတ ယထာ ယုၐ္မာကံ ဘြမံ ကောပိ န ဇနယတိ, ခီၐ္ဋောဟမိတျုက္တွာ မမ နာမြာ ဗဟဝ ဥပသ္ထာသျန္တိ သ ကာလး ပြာယေဏောပသ္ထိတး, တေၐာံ ပၑ္စာန္မာ ဂစ္ဆတ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","ယုဒ္ဓသျောပပ္လဝသျ စ ဝါရ္တ္တာံ ၑြုတွာ မာ ၑင်္ကဓွံ, ယတး ပြထမမ် ဧတာ ဃဋနာ အဝၑျံ ဘဝိၐျန္တိ ကိန္တု နာပါတေ ယုဂါန္တော ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","အပရဉ္စ ကထယာမာသ, တဒါ ဒေၑသျ ဝိပက္ၐတွေန ဒေၑော ရာဇျသျ ဝိပက္ၐတွေန ရာဇျမ် ဥတ္ထာသျတိ, ");
INSERT INTO sanbur_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","နာနာသ္ထာနေၐု မဟာဘူကမ္ပော ဒုရ္ဘိက္ၐံ မာရီ စ ဘဝိၐျန္တိ, တထာ ဝျောမမဏ္ဍလသျ ဘယင်္ကရဒရ္ၑနာနျၑ္စရျျလက္ၐဏာနိ စ ပြကာၑယိၐျန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","ကိန္တု သရွွာသာမေတာသာံ ဃဋနာနာံ ပူရွွံ လောကာ ယုၐ္မာန် ဓၖတွာ တာဍယိၐျန္တိ, ဘဇနာလယေ ကာရာယာဉ္စ သမရ္ပယိၐျန္တိ မမ နာမကာရဏာဒ် ယုၐ္မာန် ဘူပါနာံ ၑာသကာနာဉ္စ သမ္မုခံ နေၐျန္တိ စ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","သာက္ၐျာရ္ထမ် ဧတာနိ ယုၐ္မာန် ပြတိ ဃဋိၐျန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","တဒါ ကိမုတ္တရံ ဝက္တဝျမ် ဧတတ် န စိန္တယိၐျာမ ဣတိ မနးသု နိၑ္စိတနုတ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ဝိပက္ၐာ ယသ္မာတ် ကိမပျုတ္တရမ် အာပတ္တိဉ္စ ကရ္တ္တုံ န ၑက္ၐျန္တိ တာဒၖၑံ ဝါက္ပဋုတွံ ဇ္ဉာနဉ္စ ယုၐ္မဘျံ ဒါသျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","ကိဉ္စ ယူယံ ပိတြာ မာတြာ ဘြာတြာ ဗန္ဓုနာ ဇ္ဉာတျာ ကုဋုမ္ဗေန စ ပရကရေၐု သမရ္ပယိၐျဓွေ; တတသ္တေ ယုၐ္မာကံ ကဉ္စန ကဉ္စန ဃာတယိၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","မမ နာမ္နး ကာရဏာတ် သရွွဲ ရ္မနုၐျဲ ရျူယမ် ၒတီယိၐျဓွေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","ကိန္တု ယုၐ္မာကံ ၑိရးကေၑဲကောပိ န ဝိနံက္ၐျတိ, ");
INSERT INTO sanbur_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","တသ္မာဒေဝ ဓဲရျျမဝလမ္ဗျ သွသွပြာဏာန် ရက္ၐတ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","အပရဉ္စ ယိရူၑာလမ္ပုရံ သဲနျဝေၐ္ဋိတံ ဝိလောကျ တသျောစ္ဆိန္နတာယား သမယး သမီပ ဣတျဝဂမိၐျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","တဒါ ယိဟူဒါဒေၑသ္ထာ လောကား ပရွွတံ ပလာယန္တာံ, ယေ စ နဂရေ တိၐ္ဌန္တိ တေ ဒေၑာန္တရံ ပလာယန္တာ, ယေ စ ဂြာမေ တိၐ္ဌန္တိ တေ နဂရံ န ပြဝိၑန္တု, ");
INSERT INTO sanbur_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","ယတသ္တဒါ သမုစိတဒဏ္ဍနာယ ဓရ္မ္မပုသ္တကေ ယာနိ သရွွာဏိ လိခိတာနိ တာနိ သဖလာနိ ဘဝိၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","ကိန္တု ယာ ယာသ္တဒါ ဂရ္ဘဝတျး သ္တနျဒါဝျၑ္စ တာမာံ ဒုရ္ဂတိ ရ္ဘဝိၐျတိ, ယတ ဧတာလ္လောကာန် ပြတိ ကောပေါ ဒေၑေ စ ဝိၐမဒုရ္ဂတိ ရ္ဃဋိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","ဝသ္တုတသ္တု တေ ခင်္ဂဓာရပရိဝွင်္ဂံ လပ္သျန္တေ ဗဒ္ဓါး သန္တး သရွွဒေၑေၐု နာယိၐျန္တေ စ ကိဉ္စာနျဒေၑီယာနာံ သမယောပသ္ထိတိပရျျန္တံ ယိရူၑာလမ္ပုရံ တဲး ပဒတလဲ ရ္ဒလယိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","သူရျျစန္ဒြနက္ၐတြေၐု လက္ၐဏာဒိ ဘဝိၐျန္တိ, ဘုဝိ သရွွဒေၑီယာနာံ ဒုးခံ စိန္တာ စ သိန္ဓော် ဝီစီနာံ တရ္ဇနံ ဂရ္ဇနဉ္စ ဘဝိၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ဘူဘော် ဘာဝိဃဋနာံ စိန္တယိတွာ မနုဇာ ဘိယာမၖတကလ္ပာ ဘဝိၐျန္တိ, ယတော ဝျောမမဏ္ဍလေ တေဇသွိနော ဒေါလာယမာနာ ဘဝိၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","တဒါ ပရာကြမေဏာ မဟာတေဇသာ စ မေဃာရူဎံ မနုၐျပုတြမ် အာယာန္တံ ဒြက္ၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","ကိန္တွေတာသာံ ဃဋနာနာမာရမ္ဘေ သတိ ယူယံ မသ္တကာနျုတ္တောလျ ဦရ္ဒဓွံ ဒြက္ၐျထ, ယတော ယုၐ္မာကံ မုက္တေး ကာလး သဝိဓော ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","တတသ္တေနဲတဒၖၐ္ဋာန္တကထာ ကထိတာ, ပၑျတ ဥဍုမ္ဗရာဒိဝၖက္ၐာဏာံ ");
INSERT INTO sanbur_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","နဝီနပတြာဏိ ဇာတာနီတိ ဒၖၐ္ဋွာ နိဒါဝကာလ ဥပသ္ထိတ ဣတိ ယထာ ယူယံ ဇ္ဉာတုံ ၑက္နုထ, ");
INSERT INTO sanbur_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","တထာ သရွွာသာမာသာံ ဃဋနာနာမ် အာရမ္ဘေ ဒၖၐ္ဋေ သတီၑွရသျ ရာဇတွံ နိကဋမ် ဣတျပိ ဇ္ဉာသျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","ယုၐ္မာနဟံ ယထာရ္ထံ ဝဒါမိ, ဝိဒျမာနလောကာနာမေၐာံ ဂမနာတ် ပူရွွမ် ဧတာနိ ဃဋိၐျန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","နဘောဘုဝေါရ္လောပေါ ဘဝိၐျတိ မမ ဝါက် တု ကဒါပိ လုပ္တာ န ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","အတဧဝ ဝိၐမာၑနေန ပါနေန စ သာံမာရိကစိန္တာဘိၑ္စ ယုၐ္မာကံ စိတ္တေၐု မတ္တေၐု တဒ္ဒိနမ် အကသ္မာဒ် ယုၐ္မာန် ပြတိ ယထာ နောပတိၐ္ဌတိ တဒရ္ထံ သွေၐု သာဝဓာနာသ္တိၐ္ဌတ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ပၖထိဝီသ္ထသရွွလောကာန် ပြတိ တဒ္ဒိနမ် ဥန္မာထ ဣဝ ဥပသ္ထာသျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ယထာ ယူယမ် ဧတဒ္ဘါဝိဃဋနာ ဥတ္တရ္တ္တုံ မနုဇသုတသျ သမ္မုခေ သံသ္ထာတုဉ္စ ယောဂျာ ဘဝထ ကာရဏာဒသ္မာတ် သာဝဓာနား သန္တော နိရန္တရံ ပြာရ္ထယဓွံ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","အပရဉ္စ သ ဒိဝါ မန္ဒိရ ဥပဒိၑျ ရာစဲ ဇဲတုနာဒြိံ ဂတွာတိၐ္ဌတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","တတး ပြတျူၐေ လာကာသ္တတ္ကထာံ ၑြောတုံ မန္ဒိရေ တဒန္တိကမ် အာဂစ္ဆန်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","အပရဉ္စ ကိဏွၑူနျပူပေါတ္သဝသျ ကာလ ဥပသ္ထိတေ ");
INSERT INTO sanbur_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ပြဓာနယာဇကာ အဓျာယကာၑ္စ ယထာ တံ ဟန္တုံ ၑက္နုဝန္တိ တထောပါယာမ် အစေၐ္ဋန္တ ကိန္တု လောကေဘျော ဗိဘျုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ဧတသ္တိန် သမယေ ဒွါဒၑၑိၐျေၐု ဂဏိတ ဤၐ္ကရိယောတီယရူဎိမာန် ယော ယိဟူဒါသ္တသျာန္တးကရဏံ ၑဲတာနာၑြိတတွာတ္ ");
INSERT INTO sanbur_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","သ ဂတွာ ယထာ ယီၑုံ တေၐာံ ကရေၐု သမရ္ပယိတုံ ၑက္နောတိ တထာ မန္တြဏာံ ပြဓာနယာဇကဲး သေနာပတိဘိၑ္စ သဟ စကာရ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","တေန တေ တုၐ္ဋာသ္တသ္မဲ မုဒြာံ ဒါတုံ ပဏံ စကြုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","တတး သောင်္ဂီကၖတျ ယထာ လောကာနာမဂေါစရေ တံ ပရကရေၐု သမရ္ပယိတုံ ၑက္နောတိ တထာဝကာၑံ စေၐ္ဋိတုမာရေဘေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","အထ ကိဏွၑူနျပူပေါတ္မဝဒိနေ, အရ္ထာတ် ယသ္မိန် ဒိနေ နိသ္တာရောတ္သဝသျ မေၐော ဟန္တဝျသ္တသ္မိန် ဒိနေ ");
INSERT INTO sanbur_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ယီၑုး ပိတရံ ယောဟနဉ္စာဟူယ ဇဂါဒ, ယုဝါံ ဂတွာသ္မာကံ ဘောဇနာရ္ထံ နိသ္တာရောတ္သဝသျ ဒြဝျာဏျာသာဒယတံ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","တဒါ တော် ပပြစ္ဆတုး ကုစာသာဒယာဝေါ ဘဝတး ကေစ္ဆာ? ");
INSERT INTO sanbur_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","တဒါ သောဝါဒီတ်, နဂရေ ပြဝိၐ္ဋေ ကၑ္စိဇ္ဇလကုမ္ဘမာဒါယ ယုဝါံ သာက္ၐာတ် ကရိၐျတိ သ ယန္နိဝေၑနံ ပြဝိၑတိ ယုဝါမပိ တန္နိဝေၑနံ တတ္ပၑ္စာဒိတွာ နိဝေၑနပတိမ် ဣတိ ဝါကျံ ဝဒတံ, ");
INSERT INTO sanbur_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ယတြာဟံ နိသ္တာရောတ္သဝသျ ဘောဇျံ ၑိၐျဲး သာရ္ဒ္ဓံ ဘောက္တုံ ၑက္နောမိ သာတိထိၑာလာा ကုတြ? ကထာမိမာံ ပြဘုသ္တွာံ ပၖစ္ဆတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","တတး သ ဇနော ဒွိတီယပြကောၐ္ဌီယမ် ဧကံ ၑသ္တံ ကောၐ္ဌံ ဒရ္ၑယိၐျတိ တတြ ဘောဇျမာသာဒယတံ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","တတသ္တော် ဂတွာ တဒွါကျာနုသာရေဏ သရွွံ ဒၖၐ္ဒွါ တတြ နိသ္တာရောတ္သဝီယံ ဘောဇျမာသာဒယာမာသတုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","အထ ကာလ ဥပသ္ထိတေ ယီၑု ရ္ဒွါဒၑဘိး ပြေရိတဲး သဟ ဘောက္တုမုပဝိၑျ ကထိတဝါန္ ");
INSERT INTO sanbur_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","မမ ဒုးခဘောဂါတ် ပူရွွံ ယုဘာဘိး သဟ နိသ္တာရောတ္သဝသျဲတသျ ဘောဇျံ ဘောက္တုံ မယာတိဝါဉ္ဆာ ကၖတာ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","ယုၐ္မာန် ဝဒါမိ, ယာဝတ္ကာလမ် ဤၑွရရာဇျေ ဘောဇနံ န ကရိၐျေ တာဝတ္ကာလမ် ဣဒံ န ဘောက္ၐျေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","တဒါ သ ပါနပါတြမာဒါယ ဤၑွရသျ ဂုဏာန် ကီရ္တ္တယိတွာ တေဘျော ဒတွာဝဒတ်, ဣဒံ ဂၖဟ္လီတ ယူယံ ဝိဘဇျ ပိဝတ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ယုၐ္မာန် ဝဒါမိ ယာဝတ္ကာလမ် ဤၑွရရာဇတွသျ သံသ္ထာပနံ န ဘဝတိ တာဝဒ် ဒြာက္ၐာဖလရသံ န ပါသျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","တတး ပူပံ ဂၖဟီတွာ ဤၑွရဂုဏာန် ကီရ္တ္တယိတွာ ဘင်္က္တာ တေဘျော ဒတွာဝဒတ်, ယုၐ္မဒရ္ထံ သမရ္ပိတံ ယန္မမ ဝပုသ္တဒိဒံ, ဧတတ် ကရ္မ္မ မမ သ္မရဏာရ္ထံ ကုရုဓွံ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","အထ ဘောဇနာန္တေ တာဒၖၑံ ပါတြံ ဂၖဟီတွာဝဒတ်, ယုၐ္မတ္ကၖတေ ပါတိတံ ယန္မမ ရက္တံ တေန နိရ္ဏီတနဝနိယမရူပံ ပါနပါတြမိဒံ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","ပၑျတ ယော မာံ ပရကရေၐု သမရ္ပယိၐျတိ သ မယာ သဟ ဘောဇနာသန ဥပဝိၑတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","ယထာ နိရူပိတမာသ္တေ တဒနုသာရေဏာ မနုၐျပုुတြသျ ဂတိ ရ္ဘဝိၐျတိ ကိန္တု ယသ္တံ ပရကရေၐု သမရ္ပယိၐျတိ တသျ သန္တာပေါ ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","တဒါ တေၐာံ ကော ဇန ဧတတ် ကရ္မ္မ ကရိၐျတိ တတ် တေ ပရသ္ပရံ ပြၐ္ဋုမာရေဘိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","အပရံ တေၐာံ ကော ဇနး ၑြေၐ္ဌတွေန ဂဏယိၐျတေ, အတြာရ္ထေ တေၐာံ ဝိဝါဒေါဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","အသ္မာတ် ကာရဏာတ် သောဝဒတ်, အနျဒေၑီယာနာံ ရာဇာနး ပြဇာနာမုပရိ ပြဘုတွံ ကုရွွန္တိ ဒါရုဏၑာသနံ ကၖတွာပိ တေ ဘူပတိတွေန ဝိချာတာ ဘဝန္တိ စ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","ကိန္တု ယုၐ္မာကံ တထာ န ဘဝိၐျတိ, ယော ယုၐ္မာကံ ၑြေၐ္ဌော ဘဝိၐျတိ သ ကနိၐ္ဌဝဒ် ဘဝတု, ယၑ္စ မုချော ဘဝိၐျတိ သ သေဝကဝဒ္ဘဝတု၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","ဘောဇနောပဝိၐ္ဋပရိစာရကယေား ကး ၑြေၐ္ဌး? ယော ဘောဇနာယောပဝိၑတိ သ ကိံ ၑြေၐ္ဌော န ဘဝတိ? ကိန္တု ယုၐ္မာကံ မဓျေ'ဟံ ပရိစာရကဣဝါသ္မိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","အပရဉ္စ ယုယံ မမ ပရီက္ၐာကာလေ ပြထမမာရဘျ မယာ သဟ သ္ထိတာ ");
INSERT INTO sanbur_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ဧတတ္ကာရဏာတ် ပိတြာ ယထာ မဒရ္ထံ ရာဇျမေကံ နိရူပိတံ တထာဟမပိ ယုၐ္မဒရ္ထံ ရာဇျံ နိရူပယာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","တသ္မာန် မမ ရာဇျေ ဘောဇနာသနေ စ ဘောဇနပါနေ ကရိၐျဓွေ သိံဟာသနေၐူပဝိၑျ စေသြာယေလီယာနာံ ဒွါဒၑဝံၑာနာံ ဝိစာရံ ကရိၐျဓွေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","အပရံ ပြဘုရုဝါစ, ဟေ ၑိမောန် ပၑျ တိတဥနာ ဓာနျာနီဝ ယုၐ္မာန် ၑဲတာန် စာလယိတုမ် အဲစ္ဆတ်, ");
INSERT INTO sanbur_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","ကိန္တု တဝ ဝိၑွာသသျ လောပေါ ယထာ န ဘဝတိ ဧတတ် တွဒရ္ထံ ပြာရ္ထိတံ မယာ, တွန္မနသိ ပရိဝရ္တ္တိတေ စ ဘြာတၖဏာံ မနာံသိ သ္ထိရီကုရု၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","တဒါ သောဝဒတ်, ဟေ ပြဘောဟံ တွယာ သာရ္ဒ္ဓံ ကာရာံ မၖတိဉ္စ ယာတုံ မဇ္ဇိတောသ္မိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","တတး သ ဥဝါစ, ဟေ ပိတရ တွာံ ဝဒါမိ, အဒျ ကုက္ကုဋရဝါတ် ပူရွွံ တွံ မတ္ပရိစယံ ဝါရတြယမ် အပဟွောၐျသေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","အပရံ သ ပပြစ္ဆ, ယဒါ မုဒြာသမ္ပုဋံ ခါဒျပါတြံ ပါဒုကာဉ္စ ဝိနာ ယုၐ္မာန် ပြာဟိဏဝံ တဒါ ယုၐ္မာကံ ကသျာပိ နျူနတာသီတ်? တေ ပြောစုး ကသျာပိ န၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","တဒါ သောဝဒတ် ကိန္တွိဒါနီံ မုဒြာသမ္ပုဋံ ခါဒျပါတြံ ဝါ ယသျာသ္တိ တေန တဒ္ဂြဟီတဝျံ, ယသျ စ ကၖပါဏောे နာသ္တိ တေန သွဝသ္တြံ ဝိကြီယ သ ကြေတဝျး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","ယတော ယုၐ္မာနဟံ ဝဒါမိ, အပရာဓိဇနဲး သာရ္ဒ္ဓံ ဂဏိတး သ ဘဝိၐျတိ၊ ဣဒံ ယစ္ဆာသ္တြီယံ ဝစနံ လိခိတမသ္တိ တန္မယိ ဖလိၐျတိ ယတော မမ သမ္ဗန္ဓီယံ သရွွံ သေတ္သျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","တဒါ တေ ပြောစုး ပြဘော ပၑျ ဣမော် ကၖပါဏော်၊ တတး သောဝဒဒ် ဧတော် ယထေၐ္ဋော်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","အထ သ တသ္မာဒွဟိ ရ္ဂတွာ သွာစာရာနုသာရေဏ ဇဲတုနနာမာဒြိံ ဇဂါမ ၑိၐျာၑ္စ တတ္ပၑ္စာဒ် ယယုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","တတြောပသ္ထာယ သ တာနုဝါစ, ယထာ ပရီက္ၐာယာံ န ပတထ တဒရ္ထံ ပြာရ္ထယဓွံ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ပၑ္စာတ် သ တသ္မာဒ် ဧကၑရက္ၐေပါဒ် ဗဟိ ရ္ဂတွာ ဇာနုနီ ပါတယိတွာ ဧတတ် ပြာရ္ထယာဉ္စကြေ, ");
INSERT INTO sanbur_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ဟေ ပိတ ရျဒိ ဘဝါန် သမ္မနျတေ တရှိ ကံသမေနံ မမာန္တိကာဒ် ဒူရယ ကိန္တု မဒိစ္ဆာနုရူပံ န တွဒိစ္ဆာနုရူပံ ဘဝတု၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","တဒါ တသ္မဲ ၑက္တိံ ဒါတုံ သွရ္ဂီယဒူတော ဒရ္ၑနံ ဒဒေါ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ပၑ္စာတ် သောတျန္တံ ယာတနယာ ဝျာကုလော ဘူတွာ ပုနရ္ဒၖဎံ ပြာရ္ထယာဉ္စကြေ, တသ္မာဒ် ဗၖဟစ္ဆောဏိတဗိန္ဒဝ ဣဝ တသျ သွေဒဗိန္ဒဝး ပၖထိဝျာံ ပတိတုမာရေဘိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","အထ ပြာရ္ထနာတ ဥတ္ထာယ ၑိၐျာဏာံ သမီပမေတျ တာန် မနောဒုးခိနော နိဒြိတာန် ဒၖၐ္ဋွာဝဒတ္ ");
INSERT INTO sanbur_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ကုတော နိဒြာထ? ပရီက္ၐာယာမ် အပတနာရ္ထံ ပြရ္ထယဓွံ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ဧတတ္ကထာယား ကထနကာလေ ဒွါဒၑၑိၐျာဏာံ မဓျေ ဂဏိတော ယိဟူဒါနာမာ ဇနတာသဟိတသ္တေၐာမ် အဂြေ စလိတွာ ယီၑောၑ္စုမ္ဗနာရ္ထံ တဒန္တိကမ် အာယယော်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","တဒါ ယီၑုရုဝါစ, ဟေ ယိဟူဒါ ကိံ စုမ္ဗနေန မနုၐျပုတြံ ပရကရေၐု သမရ္ပယသိ? ");
INSERT INTO sanbur_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","တဒါ ယဒျဒ် ဃဋိၐျတေ တဒနုမာယ သင်္ဂိဘိရုက္တံ, ဟေ ပြဘော ဝယံ ကိ ခင်္ဂေန ဃာတယိၐျာမး? ");
INSERT INTO sanbur_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","တတ ဧကး ကရဝါလေနာဟတျ ပြဓာနယာဇကသျ ဒါသသျ ဒက္ၐိဏံ ကရ္ဏံ စိစ္ဆေဒ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","အဓူနာ နိဝရ္တ္တသွ ဣတျုက္တွာ ယီၑုသ္တသျ ၑြုတိံ သ္ပၖၐ္ဋွာ သွသျံ စကာရ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ပၑ္စာဒ် ယီၑုး သမီပသ္ထာန် ပြဓာနယာဇကာန် မန္ဒိရသျ သေနာပတီန် ပြာစီနာံၑ္စ ဇဂါဒ, ယူယံ ကၖပါဏာန် ယၐ္ဋီံၑ္စ ဂၖဟီတွာ မာံ ကိံ စောရံ ဓရ္တ္တုမာယာတား? ");
INSERT INTO sanbur_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ယဒါဟံ ယုၐ္မာဘိး သဟ ပြတိဒိနံ မန္ဒိရေ'တိၐ္ဌံ တဒါ မာံ ဓရ္တ္တံ န ပြဝၖတ္တား, ကိန္တွိဒါနီံ ယုၐ္မာကံ သမယောန္ဓကာရသျ စာဓိပတျမသ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","အထ တေ တံ ဓၖတွာ မဟာယာဇကသျ နိဝေၑနံ နိနျုး၊ တတး ပိတရော ဒူရေ ဒူရေ ပၑ္စာဒိတွာ ");
INSERT INTO sanbur_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","ဗၖဟတ္ကောၐ္ဌသျ မဓျေ ယတြာဂ္နိံ ဇွာလယိတွာ လောကား သမေတျောပဝိၐ္ဋာသ္တတြ တဲး သာရ္ဒ္ဓမ် ဥပဝိဝေၑ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","အထ ဝဟ္နိသန္နိဓော် သမုပဝေၑကာလေ ကာစိဒ္ဒါသီ မနော နိဝိၑျ တံ နိရီက္ၐျာဝဒတ် ပုမာနယံ တသျ သင်္ဂေ'သ္ထာတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","ကိန္တု သ တဒ် အပဟ္နုတျာဝါဒီတ် ဟေ နာရိ တမဟံ န ပရိစိနောမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","က္ၐဏာန္တရေ'နျဇနသ္တံ ဒၖၐ္ဋွာဗြဝီတ် တွမပိ တေၐာံ နိကရသျဲကဇနောသိ၊ ပိတရး ပြတျုဝါစ ဟေ နရ နာဟမသ္မိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","တတး သာရ္ဒ္ဓဒဏ္ဍဒွယာတ် ပရံ ပုနရနျော ဇနော နိၑ္စိတျ ဗဘာၐေ, ဧၐ တသျ သင်္ဂီတိ သတျံ ယတောယံ ဂါလီလီယော လောကး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","တဒါ ပိတရ ဥဝါစ ဟေ နရ တွံ ယဒ် ဝဒမိ တဒဟံ ဗောဒ္ဓုံ န ၑက္နောမိ, ဣတိ ဝါကျေ ကထိတမာတြေ ကုက္ကုဋော ရုရာဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","တဒါ ပြဘုဏာ ဝျာဓုဋျ ပိတရေ နိရီက္ၐိတေ ကၖကဝါကုရဝါတ် ပူရွွံ မာံ တြိရပဟ္နောၐျသေ ဣတိ ပူရွွောက္တံ တသျ ဝါကျံ ပိတရး သ္မၖတွာ ");
INSERT INTO sanbur_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ဗဟိရ္ဂတွာ မဟာခေဒေန စကြန္ဒ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","တဒါ ယဲ ရျီၑုရ္ဓၖတသ္တေ တမုပဟသျ ပြဟရ္တ္တုမာရေဘိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ဝသ္တြေဏ တသျ ဒၖၑော် ဗဒ္ဓွာ ကပေါလေ စပေဋာဃာတံ ကၖတွာ ပပြစ္ဆုး, ကသ္တေ ကပေါလေ စပေဋာဃာတံ ကၖတဝါန? ဂဏယိတွာ တဒ် ဝဒ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","တဒနျတ် တဒွိရုဒ္ဓံ ဗဟုနိန္ဒာဝါကျံ ဝက္တုမာရေဘိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","အထ ပြဘာတေ သတိ လောကပြာဉ္စး ပြဓာနယာဇကာ အဓျာပကာၑ္စ သဘာံ ကၖတွာ မဓျေသဘံ ယီၑုမာနီယ ပပြစ္ဆုး, တွမ် အဘိၐိကတောသိ န ဝါသ္မာန် ဝဒ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","သ ပြတျုဝါစ, မယာ တသ္မိန္နုက္တေ'ပိ ယူယံ န ဝိၑွသိၐျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ကသ္မိံၑ္စိဒွါကျေ ယုၐ္မာန် ပၖၐ္ဋေ'ပိ မာံ န တဒုတ္တရံ ဝက္ၐျထ န မာံ တျက္ၐျထ စ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","ကိန္တွိတး ပရံ မနုဇသုတး သရွွၑက္တိမတ ဤၑွရသျ ဒက္ၐိဏေ ပါရ္ၑွေ သမုပဝေက္ၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","တတသ္တေ ပပြစ္ဆုး, ရ္တိဟ တွမီၑွရသျ ပုတြး? သ ကထယာမာသ, ယူယံ ယထာရ္ထံ ဝဒထ သ ဧဝါဟံ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","တဒါ တေ သရွွေ ကထယာမာသုး, ရ္တိဟ သာက္ၐျေ'န္သသ္မိန် အသ္မာကံ ကိံ ပြယောဇနံ? အသျ သွမုခါဒေဝ သာက္ၐျံ ပြာပ္တမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","တတး သဘာသ္ထား သရွွလောကာ ဥတ္ထာယ တံ ပီလာတသမ္မုခံ နီတွာပြောဒျ ဝက္တုမာရေဘိရေ, ");
INSERT INTO sanbur_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","သွမဘိၐိက္တံ ရာဇာနံ ဝဒန္တံ ကဲမရရာဇာယ ကရဒါနံ နိၐေဓန္တံ ရာဇျဝိပရျျယံ ကုရ္တ္တုံ ပြဝရ္တ္တမာနမ် ဧန ပြာပ္တာ ဝယံ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","တဒါ ပီလာတသ္တံ ပၖၐ္ဋဝါန် တွံ ကိံ ယိဟူဒီယာနာံ ရာဇာ? သ ပြတျုဝါစ တွံ သတျမုက္တဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","တဒါ ပီလာတး ပြဓာနယာဇကာဒိလောကာန် ဇဂါဒ်, အဟမေတသျ ကမပျပရာဓံ နာပ္တဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","တတသ္တေ ပုနး သာဟမိနော ဘူတွာဝဒန်, ဧၐ ဂါလီလ ဧတတ္သ္ထာနပရျျန္တေ သရွွသ္မိန် ယိဟူဒါဒေၑေ သရွွာလ္လောကာနုပဒိၑျ ကုပြဝၖတ္တိံ ဂြာဟီတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","တဒါ ပီလာတော ဂါလီလပြဒေၑသျ နာမ ၑြုတွာ ပပြစ္ဆ, ကိမယံ ဂါလီလီယော လောကး? ");
INSERT INTO sanbur_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","တတး သ ဂါလီလ္ပြဒေၑီယဟေရောဒြာဇသျ တဒါ သ္ထိတေသ္တသျ သမီပေ ယီၑုံ ပြေၐယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","တဒါ ဟေရောဒ် ယီၑုံ ဝိလောကျ သန္တုတောၐ, ယတး သ တသျ ဗဟုဝၖတ္တာန္တၑြဝဏာတ် တသျ ကိဉိ्စဒါၑ္စရျျကရ္မ္မ ပၑျတိ ဣတျာၑာံ ကၖတွာ ဗဟုကာလမာရဘျ တံ ဒြၐ္ဋုံ ပြယာသံ ကၖတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","တသ္မာတ် တံ ဗဟုကထား ပပြစ္ဆ ကိန္တု သ တသျ ကသျာပိ ဝါကျသျ ပြတျုတ္တရံ နောဝါစ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","အထ ပြဓာနယာဇကာ အဓျာပကာၑ္စ ပြောတ္တိၐ္ဌန္တး သာဟသေန တမပဝဒိတုံ ပြာရေဘိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ဟေရောဒ် တသျ သေနာဂဏၑ္စ တမဝဇ္ဉာယ ဥပဟာသတွေန ရာဇဝသ္တြံ ပရိဓာပျ ပုနး ပီလာတံ ပြတိ တံ ပြာဟိဏောတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ပူရွွံ ဟေရောဒ္ပီလာတယေား ပရသ္ပရံ ဝဲရဘာဝ အာသီတ် ကိန္တု တဒ္ဒိနေ ဒွယော ရ္မေလနံ ဇာတမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","ပၑ္စာတ် ပီလာတး ပြဓာနယာဇကာန် ၑာသကာန် လောကာံၑ္စ ယုဂပဒါဟူယ ဗဘာၐေ, ");
INSERT INTO sanbur_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ရာဇျဝိပရျျယကာရကောယမ် ဣတျုက္တွာ မနုၐျမေနံ မမ နိကဋမာနဲၐ္ဋ ကိန္တု ပၑျတ ယုၐ္မာကံ သမက္ၐမ် အသျ ဝိစာရံ ကၖတွာပိ ပြောက္တာပဝါဒါနုရူပေဏာသျ ကောပျပရာဓး သပြမာဏော န ဇာတး, ");
INSERT INTO sanbur_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ယူယဉ္စ ဟေရောဒး သန္နိဓော် ပြေၐိတာ မယာ တတြာသျ ကောပျပရာဓသ္တေနာပိ န ပြာပ္တး၊ ပၑျတာနေန ဝဓဟေेတုကံ ကိမပိ နာပရာဒ္ဓံ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","တသ္မာဒေနံ တာဍယိတွာ ဝိဟာသျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","တတြောတ္သဝေ တေၐာမေကော မောစယိတဝျး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ဣတိ ဟေတောသ္တေ ပြောစ္စဲရေကဒါ ပြောစုး, ဧနံ ဒူရီကၖတျ ဗရဗ္ဗာနာမာနံ မောစယ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","သ ဗရဗ္ဗာ နဂရ ဥပပ္လဝဝဓာပရာဓာဘျာံ ကာရာယာံ ဗဒ္ဓ အာသီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","ကိန္တု ပီလာတော ယီၑုံ မောစယိတုံ ဝါဉ္ဆန် ပုနသ္တာနုဝါစ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","တထာပျေနံ ကြုၑေ ဝျဓ ကြုၑေ ဝျဓေတိ ဝဒန္တသ္တေ ရုရုဝုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","တတး သ တၖတီယဝါရံ ဇဂါဒ ကုတး? သ ကိံ ကရ္မ္မ ကၖတဝါန်? နာဟမသျ ကမပိ ဝဓာပရာဓံ ပြာပ္တး ကေဝလံ တာဍယိတွာမုံ တျဇာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","တထာပိ တေ ပုနရေနံ ကြုၑေ ဝျဓ ဣတျုက္တွာ ပြောစ္စဲရ္ဒၖဎံ ပြာရ္ထယာဉ္စကြိရေ; ");
INSERT INTO sanbur_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","တတး ပြဓာနယာဇကာဒီနာံ ကလရဝေ ပြဗလေ သတိ တေၐာံ ပြာရ္ထနာရူပံ ကရ္တ္တုံ ပီလာတ အာဒိဒေၑ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ရာဇဒြောဟဝဓယောရပရာဓေန ကာရာသ္ထံ ယံ ဇနံ တေ ယယာစိရေ တံ မောစယိတွာ ယီၑုံ တေၐာမိစ္ဆာယာံ သမာရ္ပယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","အထ တေ ယီၑုံ ဂၖဟီတွာ ယာန္တိ, ဧတရှိ ဂြာမာဒါဂတံ ၑိမောနနာမာနံ ကုရီဏီယံ ဇနံ ဓၖတွာ ယီၑေား ပၑ္စာန္နေတုံ တသျ သ္ကန္ဓေ ကြုၑမရ္ပယာမာသုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","တတော လောाကာရဏျမဓျေ ဗဟုသ္တြိယော ရုဒတျော ဝိလပန္တျၑ္စ ယီၑေား ပၑ္စာဒ် ယယုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","ကိန္တု သ ဝျာဃုဋျ တာ ဥဝါစ, ဟေ ယိရူၑာလမော နာရျျော ယုယံ မဒရ္ထံ န ရုဒိတွာ သွာရ္ထံ သွာပတျာရ္ထဉ္စ ရုဒိတိ; ");
INSERT INTO sanbur_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ပၑျတ ယး ကဒါပိ ဂရ္ဘဝတျော နာဘဝန် သ္တနျဉ္စ နာပါယယန် တာဒၖၑီ ရွန္ဓျာ ယဒါ ဓနျာ ဝက္ၐျန္တိ သ ကာလ အာယာတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","တဒါ ဟေ ၑဲလာ အသ္မာကမုပရိ ပတတ, ဟေ ဥပၑဲလာ အသ္မာနာစ္ဆာဒယတ ကထာမီဒၖၑီံ လောကာ ဝက္ၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","ယတး သတေဇသိ ၑာခိနိ စေဒေတဒ် ဃဋတေ တရှိ ၑုၐ္ကၑာခိနိ ကိံ န ဃဋိၐျတေ? ");
INSERT INTO sanbur_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","တဒါ တေ ဟန္တုံ ဒွါဝပရာဓိနော် တေန သာရ္ဒ္ဓံ နိနျုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","အပရံ ၑိရးကပါလနာမကသ္ထာနံ ပြာပျ တံ ကြုၑေ ဝိဝိဓုး; တဒ္ဒွယောရပရာဓိနောရေကံ တသျ ဒက္ၐိဏော တဒနျံ ဝါမေ ကြုၑေ ဝိဝိဓုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","တဒါ ယီၑုရကထယတ်, ဟေ ပိတရေတာန် က္ၐမသွ ယတ ဧတေ ယတ် ကရ္မ္မ ကုရွွန္တိ တန် န ဝိဒုး; ပၑ္စာတ္တေ ဂုဋိကာပါတံ ကၖတွာ တသျ ဝသ္တြာဏိ ဝိဘဇျ ဇဂၖဟုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","တတြ လောကသံဃသ္တိၐ္ဌန် ဒဒရ္ၑ; တေ တေၐာံ ၑာသကာၑ္စ တမုပဟသျ ဇဂဒုး, ဧၐ ဣတရာန် ရက္ၐိတဝါန် ယဒီၑွရေဏာဘိရုစိတော 'ဘိၐိက္တသ္တြာတာ ဘဝတိ တရှိ သွမဓုနာ ရက္ၐတု၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","တဒနျး သေနာဂဏာ ဧတျ တသ္မဲ အမ္လရသံ ဒတွာ ပရိဟသျ ပြောဝါစ, ");
INSERT INTO sanbur_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","စေတ္တွံ ယိဟူဒီယာနာံ ရာဇာသိ တရှိ သွံ ရက္ၐ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ယိဟူဒီယာနာံ ရာဇေတိ ဝါကျံ ယူနာနီယရောမီယေဗြီယာက္ၐရဲ ရ္လိခိတံ တစ္ဆိရသ ဦရ္ဒ္ဓွေ'သ္ထာပျတ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","တဒေါဘယပါရ္ၑွယော ရွိဒ္ဓေါ် ယာဝပရာဓိနော် တယောရေကသ္တံ ဝိနိန္ဒျ ဗဘာၐေ, စေတ္တွမ် အဘိၐိက္တောသိ တရှိ သွမာဝါဉ္စ ရက္ၐ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","ကိန္တွနျသ္တံ တရ္ဇယိတွာဝဒတ်, ဤၑွရာတ္တဝ ကိဉ္စိဒပိ ဘယံ နာသ္တိ ကိံ? တွမပိ သမာနဒဏ္ဍောသိ, ");
INSERT INTO sanbur_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ယောဂျပါတြေ အာဝါံ သွသွကရ္မ္မဏာံ သမုစိတဖလံ ပြာပ္နုဝး ကိန္တွနေန ကိမပိ နာပရာဒ္ဓံ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","အထ သ ယီၑုံ ဇဂါဒ ဟေ ပြဘေ ဘဝါန် သွရာဇျပြဝေၑကာလေ မာံ သ္မရတု၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","တဒါ ယီၑုး ကထိတဝါန် တွာံ ယထာရ္ထံ ဝဒါမိ တွမဒျဲဝ မယာ သာရ္ဒ္ဓံ ပရလောကသျ သုခသ္ထာနံ ပြာပ္သျသိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","အပရဉ္စ ဒွိတီယယာမာတ် တၖတီယယာမပရျျန္တံ ရဝေသ္တေဇသောန္တရှိတတွာတ် သရွွဒေၑော'န္ဓကာရေဏာဝၖတော ");
INSERT INTO sanbur_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","မန္ဒိရသျ ယဝနိကာ စ ဆိဒျမာနာ ဒွိဓာ ဗဘူဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","တတော ယီၑုရုစ္စဲရုဝါစ, ဟေ ပိတ ရ္မမာတ္မာနံ တဝ ကရေ သမရ္ပယေ, ဣတျုက္တွာ သ ပြာဏာန် ဇဟော်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","တဒဲတာ ဃဋနာ ဒၖၐ္ဋွာ ၑတသေနာပတိရီၑွရံ ဓနျမုက္တွာ ကထိတဝါန် အယံ နိတာန္တံ သာဓုမနုၐျ အာသီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","အထ ယာဝန္တော လောကာ ဒြၐ္ဋုမ် အာဂတာသ္တေ တာ ဃဋနာ ဒၖၐ္ဋွာ ဝက္ၐးသု ကရာဃာတံ ကၖတွာ ဝျာစုဋျ ဂတား၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","ယီၑော ရ္ဇ္ဉာတယော ယာ ယာ ယောၐိတၑ္စ ဂါလီလသ္တေန သာရ္ဒ္ဓမာယာတာသ္တာ အပိ ဒူရေ သ္ထိတွာ တတ် သရွွံ ဒဒၖၑုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","တဒါ ယိဟူဒီယာနာံ မန္တြဏာံ ကြိယာဉ္စာသမ္မနျမာန ဤၑွရသျ ရာဇတွမ် အပေက္ၐမာဏော ");
INSERT INTO sanbur_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ယိဟူဒိဒေၑီယော 'ရိမထီယနဂရီယော ယူၐဖ္နာမာ မန္တြီ ဘဒြော ဓာရ္မ္မိကၑ္စ ပုမာန္ ");
INSERT INTO sanbur_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ပီလာတာန္တိကံ ဂတွာ ယီၑော ရ္ဒေဟံ ယယာစေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ပၑ္စာဒ် ဝပုရဝရောဟျ ဝါသသာ သံဝေၐ္ဋျ ယတြ ကောပိ မာနုၐော နာသ္ထာပျတ တသ္မိန် ၑဲလေ သွာတေ ၑ္မၑာနေ တဒသ္ထာပယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","တဒ္ဒိနမာယောဇနီယံ ဒိနံ ဝိၑြာမဝါရၑ္စ သမီပး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","အပရံ ယီၑုနာ သာရ္ဒ္ဓံ ဂါလီလ အာဂတာ ယောၐိတး ပၑ္စာဒိတွာ ၑ္မၑာနေ တတြ ယထာ ဝပုး သ္ထာပိတံ တစ္စ ဒၖၐ္ဋွာ ");
INSERT INTO sanbur_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ဝျာဃုဋျ သုဂန္ဓိဒြဝျတဲလာနိ ကၖတွာ ဝိဓိဝဒ် ဝိၑြာမဝါရေ ဝိၑြာမံ စကြုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","အထ သပ္တာဟပြထမဒိနေ'တိပြတျူၐေ တာ ယောၐိတး သမ္ပာဒိတံ သုဂန္ဓိဒြဝျံ ဂၖဟီတွာ တဒနျာဘိး ကိယတီဘိး သ္တြီဘိး သဟ ၑ္မၑာနံ ယယုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","ကိန္တု ၑ္မၑာနဒွါရာတ် ပါၐာဏမပသာရိတံ ဒၖၐ္ဋွာ ");
INSERT INTO sanbur_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","တား ပြဝိၑျ ပြဘော ရ္ဒေဟမပြာပျ ");
INSERT INTO sanbur_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ဝျာကုလာ ဘဝန္တိ ဧတရှိ တေဇောမယဝသ္တြာနွိတော် ဒွေါ် ပုရုၐော် တာသာံ သမီပေ သမုပသ္ထိတော် ");
INSERT INTO sanbur_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","တသ္မာတ္တား ၑင်္ကာယုက္တာ ဘူမာဝဓောမုချသျသ္ထုး၊ တဒါ တော် တာ ဦစတု ရ္မၖတာနာံ မဓျေ ဇီဝန္တံ ကုတော မၖဂယထ? ");
INSERT INTO sanbur_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","သောတြ နာသ္တိ သ ဥဒသ္ထာတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ပါပိနာံ ကရေၐု သမရ္ပိတေန ကြုၑေ ဟတေန စ မနုၐျပုတြေဏ တၖတီယဒိဝသေ ၑ္မၑာနာဒုတ္ထာတဝျမ် ဣတိ ကထာံ သ ဂလီလိ တိၐ္ဌန် ယုၐ္မဘျံ ကထိတဝါန် တာံ သ္မရတ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","တဒါ တသျ သာ ကထာ တာသာံ မနးသု ဇာတာ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","အနန္တရံ ၑ္မၑာနာဒ် ဂတွာ တာ ဧကာဒၑၑိၐျာဒိဘျး သရွွေဘျသ္တာံ ဝါရ္တ္တာံ ကထယာမာသုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","မဂ္ဒလီနီမရိယမ်, ယောဟနာ, ယာကူဗော မာတာ မရိယမ် တဒနျား သင်္ဂိနျော ယောၐိတၑ္စ ပြေရိတေဘျ ဧတား သရွွာ ဝါရ္တ္တား ကထယာမာသုး ");
INSERT INTO sanbur_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ကိန္တု တာသာံ ကထာမ် အနရ္ထကာချာနမာတြံ ဗုဒ္ဓွာ ကောပိ န ပြတျဲတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","တဒါ ပိတရ ဥတ္ထာယ ၑ္မၑာနာန္တိကံ ဒဓာဝ, တတြ စ ပြဟွော ဘူတွာ ပါရ္ၑွဲကသ္ထာပိတံ ကေဝလံ ဝသ္တြံ ဒဒရ္ၑ; တသ္မာဒါၑ္စရျျံ မနျမာနော ယဒဃဋတ တန္မနသိ ဝိစာရယန် ပြတသ္ထေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","တသ္မိန္နေဝ ဒိနေ ဒွေါ် ၑိယျော် ယိရူၑာလမၑ္စတုၐ္ကြောၑာန္တရိတမ် ဣမ္မာယုဂြာမံ ဂစ္ဆန္တော် ");
INSERT INTO sanbur_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","တာသာံ ဃဋနာနာံ ကထာမကထယတာံ ");
INSERT INTO sanbur_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","တယောရာလာပဝိစာရယေား ကာလေ ယီၑုရာဂတျ တာဘျာံ သဟ ဇဂါမ ");
INSERT INTO sanbur_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ကိန္တု ယထာ တော် တံ န ပရိစိနုတသ္တဒရ္ထံ တယော ရ္ဒၖၐ္ဋိး သံရုဒ္ဓါ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","သ တော် ပၖၐ္ဋဝါန် ယုဝါံ ဝိၐဏ္ဏော် ကိံ ဝိစာရယန္တော် ဂစ္ဆထး? ");
INSERT INTO sanbur_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","တတသ္တယေား က္လိယပါနာမာ ပြတျုဝါစ ယိရူၑာလမပုရေ'ဓုနာ ယာနျဃဋန္တ တွံ ကေဝလဝိဒေၑီ ကိံ တဒွၖတ္တာန္တံ န ဇာနာသိ? ");
INSERT INTO sanbur_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","သ ပပြစ္ဆ ကာ ဃဋနား? တဒါ တော် ဝက္တုမာရေဘာတေ ယီၑုနာမာ ယော နာသရတီယော ဘဝိၐျဒွါဒီ ဤၑွရသျ မာနုၐာဏာဉ္စ သာက္ၐာတ် ဝါကျေ ကရ္မ္မဏိ စ ၑက္တိမာနာသီတ္ ");
INSERT INTO sanbur_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","တမ် အသ္မာကံ ပြဓာနယာဇကာ ဝိစာရကာၑ္စ ကေနာပိ ပြကာရေဏ ကြုၑေ ဝိဒ္ဓွာ တသျ ပြာဏာနနာၑယန် တဒီယာ ဃဋနား; ");
INSERT INTO sanbur_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","ကိန္တု ယ ဣသြာယေလီယလောကာန် ဥဒ္ဓါရယိၐျတိ သ ဧဝါယမ် ဣတျာၑာသ္မာဘိး ကၖတာ၊ တဒျထာ တထာသ္တု တသျာ ဃဋနာယာ အဒျ ဒိနတြယံ ဂတံ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","အဓိကန္တွသ္မာကံ သင်္ဂိနီနာံ ကိယတ္သ္တြီဏာံ မုခေဘျော'သမ္ဘဝဝါကျမိဒံ ၑြုတံ; ");
INSERT INTO sanbur_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","တား ပြတျူၐေ ၑ္မၑာနံ ဂတွာ တတြ တသျ ဒေဟမ် အပြာပျ ဝျာဃုဋျေတွာ ပြောက္တဝတျး သွရ္ဂီသဒူတော် ဒၖၐ္ဋာဝသ္မာဘိသ္တော် စာဝါဒိၐ္ဋာံ သ ဇီဝိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","တတောသ္မာကံ ကဲၑ္စိတ် ၑ္မၑာနမဂမျတ တေ'ပိ သ္တြီဏာံ ဝါကျာနုရူပံ ဒၖၐ္ဋဝန္တး ကိန္တု တံ နာပၑျန်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","တဒါ သ တာဝုဝါစ, ဟေ အဗောဓော် ဟေ ဘဝိၐျဒွါဒိဘိရုက္တဝါကျံ ပြတျေတုံ ဝိလမ္ဗမာနော်; ");
INSERT INTO sanbur_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","ဧတတ္သရွွဒုးခံ ဘုက္တွာ သွဘူတိပြာပ္တိး ကိံ ခြီၐ္ဋသျ န နျာယျာ? ");
INSERT INTO sanbur_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","တတး သ မူသာဂြန္ထမာရဘျ သရွွဘဝိၐျဒွါဒိနာံ သရွွၑာသ္တြေ သွသ္မိန် လိခိတာချာနာဘိပြာယံ ဗောဓယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","အထ ဂမျဂြာမာဘျရ္ဏံ ပြာပျ တေနာဂြေ ဂမနလက္ၐဏေ ဒရ္ၑိတေ ");
INSERT INTO sanbur_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","တော် သာဓယိတွာဝဒတာံ သဟာဝါဘျာံ တိၐ္ဌ ဒိနေ ဂတေ သတိ ရာတြိရဘူတ်; တတး သ တာဘျာံ သာရ္ဒ္ဓံ သ္ထာတုံ ဂၖဟံ ယယော်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","ပၑ္စာဒ္ဘေါဇနောပဝေၑကာလေ သ ပူပံ ဂၖဟီတွာ ဤၑွရဂုဏာန် ဇဂါဒ တဉ္စ ဘံက္တွာ တာဘျာံ ဒဒေါ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","တဒါ တယော ရ္ဒၖၐ္ဋော် ပြသန္နာယာံ တံ ပြတျဘိဇ္ဉတုး ကိန္တု သ တယေား သာက္ၐာဒန္တရ္ဒဓေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","တတသ္တော် မိထောဘိဓာတုမ် အာရဗ္ဓဝန္တော် ဂမနကာလေ ယဒါ ကထာမကထယတ် ၑာသ္တြာရ္ထဉ္စဗောဓယတ် တဒါဝယော ရ္ဗုဒ္ဓိး ကိံ န ပြာဇွလတ်? ");
INSERT INTO sanbur_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","တော် တတ္က္ၐဏာဒုတ္ထာယ ယိရူၑာလမပုရံ ပြတျာယယတုး, တတ္သ္ထာနေ ၑိၐျာဏာမ် ဧကာဒၑာနာံ သင်္ဂိနာဉ္စ ဒရ္ၑနံ ဇာတံ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","တေ ပြောစုး ပြဘုရုဒတိၐ္ဌဒ် ဣတိ သတျံ ၑိမောနေ ဒရ္ၑနမဒါစ္စ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","တတး ပထး သရွွဃဋနာယား ပူပဘဉ္ဇနေန တတ္ပရိစယသျ စ သရွွဝၖတ္တာန္တံ တော် ဝက္တုမာရေဘာတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ဣတ္ထံ တေ ပရသ္ပရံ ဝဒန္တိ တတ္ကာလေ ယီၑုး သွယံ တေၐာံ မဓျ ပြောတ္ထယ ယုၐ္မာကံ ကလျာဏံ ဘူယာဒ် ဣတျုဝါစ, ");
INSERT INTO sanbur_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ကိန္တု ဘူတံ ပၑျာမ ဣတျနုမာယ တေ သမုဒွိဝိဇိရေ တြေၐုၑ္စ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","သ ဥဝါစ, ကုတော ဒုးခိတာ ဘဝထ? ယုၐ္မာကံ မနးသု သန္ဒေဟ ဥဒေတိ စ ကုတး? ");
INSERT INTO sanbur_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ဧၐောဟံ, မမ ကရော် ပၑျတ ဝရံ သ္ပၖၐ္ဋွာ ပၑျတ, မမ ယာဒၖၑာနိ ပၑျထ တာဒၖၑာနိ ဘူတသျ မာံသာသ္ထီနိ န သန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ဣတျုက္တွာ သ ဟသ္တပါဒါန် ဒရ္ၑယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","တေ'သမ္ဘဝံ ဇ္ဉာတွာ သာနန္ဒာ န ပြတျယန်၊ တတး သ တာန် ပပြစ္ဆ, အတြ ယုၐ္မာကံ သမီပေ ခါဒျံ ကိဉ္စိဒသ္တိ? ");
INSERT INTO sanbur_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","တတသ္တေ ကိယဒ္ဒဂ္ဓမတ္သျံ မဓု စ ဒဒုး ");
INSERT INTO sanbur_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","သ တဒါဒါယ တေၐာံ သာက္ၐာဒ် ဗုဘုဇေ ");
INSERT INTO sanbur_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","ကထယာမာသ စ မူသာဝျဝသ္ထာယာံ ဘဝိၐျဒွါဒိနာံ ဂြန္ထေၐု ဂီတပုသ္တကေ စ မယိ ယာနိ သရွွာဏိ ဝစနာနိ လိခိတာနိ တဒနုရူပါဏိ ဃဋိၐျန္တေ ယုၐ္မာဘိး သာရ္ဒ္ဓံ သ္ထိတွာဟံ ယဒေတဒွါကျမ် အဝဒံ တဒိဒါနီံ ပြတျက္ၐမဘူတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","အထ တေဘျး ၑာသ္တြဗောဓာဓိကာရံ ဒတွာဝဒတ်, ");
INSERT INTO sanbur_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ခြီၐ္ဋေနေတ္ထံ မၖတိယာတနာ ဘောက္တဝျာ တၖတီယဒိနေ စ ၑ္မၑာနာဒုတ္ထာတဝျဉ္စေတိ လိပိရသ္တိ; ");
INSERT INTO sanbur_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","တန္နာမ္နာ ယိရူၑာလမမာရဘျ သရွွဒေၑေ မနးပရာဝရ္တ္တနသျ ပါပမောစနသျ စ သုသံဝါဒး ပြစာရယိတဝျး, ");
INSERT INTO sanbur_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ဧၐု သရွွေၐု ယူယံ သာက္ၐိဏး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","အပရဉ္စ ပၑျတ ပိတြာ ယတ် ပြတိဇ္ဉာတံ တတ် ပြေၐယိၐျာမိ, အတဧဝ ယာဝတ္ကာလံ ယူယံ သွရ္ဂီယာံ ၑက္တိံ န ပြာပ္သျထ တာဝတ္ကာလံ ယိရူၑာလမ္နဂရေ တိၐ္ဌတ၊ ");
INSERT INTO sanbur_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","အထ သ တာန် ဗဲထနီယာပရျျန္တံ နီတွာ ဟသ္တာဝုတ္တောလျ အာၑိၐ ဝက္တုမာရေဘေ ");
INSERT INTO sanbur_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","အာၑိၐံ ဝဒန္နေဝ စ တေဘျး ပၖထဂ် ဘူတွာ သွရ္ဂာယ နီတော'ဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","တဒါ တေ တံ ဘဇမာနာ မဟာနန္ဒေန ယိရူၑာလမံ ပြတျာဇဂ္မုး၊ ");
INSERT INTO sanbur_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","တတော နိရန္တရံ မန္ဒိရေ တိၐ္ဌန္တ ဤၑွရသျ ပြၑံသာံ ဓနျဝါဒဉ္စ ကရ္တ္တမ် အာရေဘိရေ၊ ဣတိ။ ");
INSERT INTO sanbur_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","အာဒေါ် ဝါဒ အာသီတ် သ စ ဝါဒ ဤၑွရေဏ သာရ္ဓမာသီတ် သ ဝါဒး သွယမီၑွရ ဧဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","သ အာဒါဝီၑွရေဏ သဟာသီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","တေန သရွွံ ဝသ္တု သသၖဇေ သရွွေၐု သၖၐ္ဋဝသ္တုၐု ကိမပိ ဝသ္တု တေနာသၖၐ္ဋံ နာသ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","သ ဇီဝနသျာကာရး, တစ္စ ဇီဝနံ မနုၐျာဏာံ ဇျောတိး ");
INSERT INTO sanbur_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","တဇ္ဇျောတိရန္ဓကာရေ ပြစကာၑေ ကိန္တွန္ဓကာရသ္တန္န ဇဂြာဟ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","ယောဟန် နာမက ဧကော မနုဇ ဤၑွရေဏ ပြေၐယာဉ္စကြေ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","တဒွါရာ ယထာ သရွွေ ဝိၑွသန္တိ တဒရ္ထံ သ တဇ္ဇျောတိၐိ ပြမာဏံ ဒါတုံ သာက္ၐိသွရူပေါ ဘူတွာဂမတ်, ");
INSERT INTO sanbur_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","သ သွယံ တဇ္ဇျောတိ ရ္န ကိန္တု တဇ္ဇျောတိၐိ ပြမာဏံ ဒါတုမာဂမတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ဇဂတျာဂတျ ယး သရွွမနုဇေဘျော ဒီပ္တိံ ဒဒါတိ တဒေဝ သတျဇျောတိး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","သ ယဇ္ဇဂဒသၖဇတ် တန္မဒျ ဧဝ သ အာသီတ် ကိန္တု ဇဂတော လောကာသ္တံ နာဇာနန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","နိဇာဓိကာရံ သ အာဂစ္ဆတ် ကိန္တု ပြဇာသ္တံ နာဂၖဟ္လန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","တထာပိ ယေ ယေ တမဂၖဟ္လန် အရ္ထာတ် တသျ နာမ္နိ ဝျၑွသန် တေဘျ ဤၑွရသျ ပုတြာ ဘဝိတုမ် အဓိကာရမ် အဒဒါတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","တေၐာံ ဇနိး ၑောဏိတာန္န ၑာရီရိကာဘိလာၐာန္န မာနဝါနာမိစ္ဆာတော န ကိန္တွီၑွရာဒဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","သ ဝါဒေါ မနုၐျရူပေဏာဝတီရျျ သတျတာနုဂြဟာဘျာံ ပရိပူရ္ဏး သန် သာရ္ဓမ် အသ္မာဘိ ရ္နျဝသတ် တတး ပိတုရဒွိတီယပုတြသျ ယောဂျော ယော မဟိမာ တံ မဟိမာနံ တသျာပၑျာမ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","တတော ယောဟနပိ ပြစာရျျ သာက္ၐျမိဒံ ဒတ္တဝါန် ယော မမ ပၑ္စာဒ် အာဂမိၐျတိ သ မတ္တော ဂုရုတရး; ယတော မတ္ပူရွွံ သ ဝိဒျမာန အာသီတ်; ယဒရ္ထမ် အဟံ သာက္ၐျမိဒမ် အဒါံ သ ဧၐး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","အပရဉ္စ တသျ ပူရ္ဏတာယာ ဝယံ သရွွေ ကြမၑး ကြမၑောနုဂြဟံ ပြာပ္တား၊ ");
INSERT INTO sanbur_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","မူသာဒွါရာ ဝျဝသ္ထာ ဒတ္တာ ကိန္တွနုဂြဟး သတျတွဉ္စ ယီၑုခြီၐ္ဋဒွါရာ သမုပါတိၐ္ဌတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","ကောပိ မနုဇ ဤၑွရံ ကဒါပိ နာပၑျတ် ကိန္တု ပိတုး ကြောဍသ္ထော'ဒွိတီယး ပုတြသ္တံ ပြကာၑယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","တွံ ကး? ဣတိ ဝါကျံ ပြေၐ္ဋုံ ယဒါ ယိဟူဒီယလောကာ ယာဇကာန် လေဝိလောကာံၑ္စ ယိရူၑာလမော ယောဟနး သမီပေ ပြေၐယာမာသုး, ");
INSERT INTO sanbur_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","တဒါ သ သွီကၖတဝါန် နာပဟ္နူတဝါန် နာဟမ် အဘိၐိက္တ ဣတျင်္ဂီကၖတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","တဒါ တေ'ပၖစ္ဆန် တရှိ ကော ဘဝါန်? ကိံ ဧလိယး? သောဝဒတ် န; တတသ္တေ'ပၖစ္ဆန် တရှိ ဘဝါန် သ ဘဝိၐျဒွါဒီ? သောဝဒတ် နာဟံ သး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","တဒါ တေ'ပၖစ္ဆန် တရှိ ဘဝါန် ကး? ဝယံ ဂတွာ ပြေရကာန် တွယိ ကိံ ဝက္ၐျာမး? သွသ္မိန် ကိံ ဝဒသိ? ");
INSERT INTO sanbur_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","တဒါ သောဝဒတ်၊ ပရမေၑသျ ပန္ထာနံ ပရိၐ္ကုရုတ သရွွတး၊ ဣတီဒံ ပြာန္တရေ ဝါကျံ ဝဒတး ကသျစိဒြဝး၊ ကထာမိမာံ ယသ္မိန် ယိၑယိယော ဘဝိၐျဒွါဒီ လိခိတဝါန် သောဟမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ယေ ပြေၐိတာသ္တေ ဖိရူၑိလောကား၊ ");
INSERT INTO sanbur_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","တဒါ တေ'ပၖစ္ဆန် ယဒိ နာဘိၐိက္တောသိ ဧလိယောသိ န သ ဘဝိၐျဒွါဒျပိ နာသိ စ, တရှိ လောကာန် မဇ္ဇယသိ ကုတး? ");
INSERT INTO sanbur_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","တတော ယောဟန် ပြတျဝေါစတ်, တောယေ'ဟံ မဇ္ဇယာမီတိ သတျံ ကိန္တု ယံ ယူယံ န ဇာနီထ တာဒၖၑ ဧကော ဇနော ယုၐ္မာကံ မဓျ ဥပတိၐ္ဌတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","သ မတ္ပၑ္စာဒ် အာဂတောပိ မတ္ပူရွွံ ဝရ္တ္တမာန အာသီတ် တသျ ပါဒုကာဗန္ဓနံ မောစယိတုမပိ နာဟံ ယောဂျောသ္မိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ယရ္ဒ္ဒနနဒျား ပါရသ္ထဗဲထဗာရာယာံ ယသ္မိန္သ္ထာနေ ယောဟနမဇ္ဇယတ် တသ္မိန သ္ထာနေ သရွွမေတဒ် အဃဋတ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","ပရေ'ဟနိ ယောဟန် သွနိကဋမာဂစ္ဆန္တံ ယိၑုံ ဝိလောကျ ပြာဝေါစတ် ဇဂတး ပါပမောစကမ် ဤၑွရသျ မေၐၑာဝကံ ပၑျတ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","ယော မမ ပၑ္စာဒါဂမိၐျတိ သ မတ္တော ဂုရုတရး, ယတော ဟေတောရ္မတ္ပူရွွံ သော'ဝရ္တ္တတ ယသ္မိန္နဟံ ကထာမိမာံ ကထိတဝါန် သ ဧဝါယံ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","အပရံ နာဟမေနံ ပြတျဘိဇ္ဉာတဝါန် ကိန္တု ဣသြာယေလ္လောကာ ဧနံ ယထာ ပရိစိနွန္တိ တဒဘိပြာယေဏာဟံ ဇလေ မဇ္ဇယိတုမာဂစ္ဆမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","ပုနၑ္စ ယောဟနပရမေကံ ပြမာဏံ ဒတွာ ကထိတဝါန် ဝိဟာယသး ကပေါတဝဒ် အဝတရန္တမာတ္မာနမ် အသျောပရျျဝတိၐ္ဌန္တံ စ ဒၖၐ္ဋဝါနဟမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","နာဟမေနံ ပြတျဘိဇ္ဉာတဝါန် ဣတိ သတျံ ကိန္တု ယော ဇလေ မဇ္ဇယိတုံ မာံ ပြဲရယတ် သ ဧဝေမာံ ကထာမကထယတ် ယသျောပရျျာတ္မာနမ် အဝတရန္တမ် အဝတိၐ္ဌန္တဉ္စ ဒြက္ၐယသိ သဧဝ ပဝိတြေ အာတ္မနိ မဇ္ဇယိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","အဝသ္တန္နိရီက္ၐျာယမ် ဤၑွရသျ တနယ ဣတိ ပြမာဏံ ဒဒါမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","ပရေ'ဟနိ ယောဟန် ဒွါဘျာံ ၑိၐျာဘျာံ သာရ္ဒ္ဓေံ တိၐ္ဌန္ ");
INSERT INTO sanbur_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ယိၑုံ ဂစ္ဆန္တံ ဝိလောကျ ဂဒိတဝါန်, ဤၑွရသျ မေၐၑာဝကံ ပၑျတံ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ဣမာံ ကထာံ ၑြုတွာ ဒွေါ် ၑိၐျော် ယီၑေား ပၑ္စာဒ် ဤယတုး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","တတော ယီၑုး ပရာဝၖတျ တော် ပၑ္စာဒ် အာဂစ္ဆန္တော် ဒၖၐ္ဋွာ ပၖၐ္ဋဝါန် ယုဝါံ ကိံ ဂဝေၑယထး? တာဝပၖစ္ဆတာံ ဟေ ရဗ္ဗိ အရ္ထာတ် ဟေ ဂုရော ဘဝါန် ကုတြ တိၐ္ဌတိ? ");
INSERT INTO sanbur_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","တတး သောဝါဒိတ် ဧတျ ပၑျတံ၊ တတော ဒိဝသသျ တၖတီယပြဟရသျ ဂတတွာတ် တော် တဒ္ဒိနံ တသျ သင်္ဂေ'သ္ထာတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ယော် ဒွေါ် ယောဟနော ဝါကျံ ၑြုတွာ ယိၑေား ပၑ္စာဒ် အာဂမတာံ တယေား ၑိမောန္ပိတရသျ ဘြာတာ အာန္ဒြိယး ");
INSERT INTO sanbur_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","သ ဣတွာ ပြထမံ နိဇသောဒရံ ၑိမောနံ သာက္ၐာတ္ပြာပျ ကထိတဝါန် ဝယံ ခြီၐ္ဋမ် အရ္ထာတ် အဘိၐိက္တပုရုၐံ သာက္ၐာတ္ကၖတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","ပၑ္စာတ် သ တံ ယိၑေား သမီပမ် အာနယတ်၊ တဒါ ယီၑုသ္တံ ဒၖၐ္ဋွာဝဒတ် တွံ ယူနသး ပုတြး ၑိမောန် ကိန္တု တွန္နာမဓေယံ ကဲဖား ဝါ ပိတရး အရ္ထာတ် ပြသ္တရော ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","ပရေ'ဟနိ ယီၑော် ဂါလီလံ ဂန္တုံ နိၑ္စိတစေတသိ သတိ ဖိလိပနာမာနံ ဇနံ သာက္ၐာတ္ပြာပျာဝေါစတ် မမ ပၑ္စာဒ် အာဂစ္ဆ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ဗဲတ္သဲဒါနာမ္နိ ယသ္မိန် ဂြာမေ ပိတရာန္ဒြိယယောရွာသ အာသီတ် တသ္မိန် ဂြာမေ တသျ ဖိလိပသျ ဝသတိရာသီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ပၑ္စာတ် ဖိလိပေါ နိထနေလံ သာက္ၐာတ္ပြာပျာဝဒတ် မူသာ ဝျဝသ္ထာ ဂြန္ထေ ဘဝိၐျဒွါဒိနာံ ဂြန္ထေၐု စ ယသျာချာနံ လိခိတမာသ္တေ တံ ယူၐဖး ပုတြံ နာသရတီယံ ယီၑုံ သာက္ၐာဒ် အကာရ္ၐ္မ ဝယံ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","တဒါ နိထနေလ် ကထိတဝါန် နာသရန္နဂရာတ ကိံ ကၑ္စိဒုတ္တမ ဥတ္ပန္တုံ ၑက္နောတိ? တတး ဖိလိပေါ 'ဝေါစတ် ဧတျ ပၑျ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","အပရဉ္စ ယီၑုး သွသျ သမီပံ တမ် အာဂစ္ဆန္တံ ဒၖၐ္ဋွာ ဝျာဟၖတဝါန်, ပၑျာယံ နိၐ္ကပဋး သတျ ဣသြာယေလ္လောကး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","တတး သောဝဒဒ်, ဘဝါန် မာံ ကထံ ပြတျဘိဇာနာတိ? ယီၑုရဝါဒီတ် ဖိလိပသျ အာဟွာနာတ် ပူရွွံ ယဒါ တွမုဍုမ္ဗရသျ တရောရ္မူလေ'သ္ထာသ္တဒါ တွာမဒရ္ၑမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","နိထနေလ် အစကထတ်, ဟေ ဂုရော ဘဝါန် နိတာန္တမ် ဤၑွရသျ ပုတြောသိ, ဘဝါန် ဣသြာယေလွံၑသျ ရာဇာ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","တတော ယီၑု ရွျာဟရတ်, တွာမုဍုမ္ဗရသျ ပါဒပသျ မူလေ ဒၖၐ္ဋဝါနာဟံ မမဲတသ္မာဒွါကျာတ် ကိံ တွံ ဝျၑွသီး? ဧတသ္မာဒပျာၑ္စရျျာဏိ ကာရျျာဏိ ဒြက္ၐျသိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","အနျစ္စာဝါဒီဒ် ယုၐ္မာနဟံ ယထာရ္ထံ ဝဒါမိ, ဣတး ပရံ မောစိတေ မေဃဒွါရေ တသ္မာန္မနုဇသူနုနာ ဤၑွရသျ ဒူတဂဏမ် အဝရောဟန္တမာရောဟန္တဉ္စ ဒြက္ၐျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","အနန္တရံ တြုတီယဒိဝသေ ဂါလီလ် ပြဒေၑိယေ ကာန္နာနာမ္နိ နဂရေ ဝိဝါဟ အာသီတ် တတြ စ ယီၑောရ္မာတာ တိၐ္ဌတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","တသ္မဲ ဝိဝါဟာယ ယီၑုသ္တသျ ၑိၐျာၑ္စ နိမန္တြိတာ အာသန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","တဒနန္တရံ ဒြာက္ၐာရသသျ နျူနတွာဒ် ယီၑောရ္မာတာ တမဝဒတ် ဧတေၐာံ ဒြာက္ၐာရသော နာသ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","တဒါ သ တာမဝေါစတ် ဟေ နာရိ မယာ သဟ တဝ ကိံ ကာရျျံ? မမ သမယ ဣဒါနီံ နောပတိၐ္ဌတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","တတသ္တသျ မာတာ ဒါသာနဝေါစဒ် အယံ ယဒ် ဝဒတိ တဒေဝ ကုရုတ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","တသ္မိန် သ္ထာနေ ယိဟူဒီယာနာံ ၑုစိတွကရဏဝျဝဟာရာနုသာရေဏာဎကဲကဇလဓရာဏိ ပါၐာဏမယာနိ ၐဍွၖဟတ္ပာတြာဏိအာသန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","တဒါ ယီၑုသ္တာန် သရွွကလၑာန် ဇလဲး ပူရယိတုံ တာနာဇ္ဉာပယတ်, တတသ္တေ သရွွာန် ကုမ္ဘာနာကရ္ဏံ ဇလဲး ပရျျပူရယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","အထ တေဘျး ကိဉ္စိဒုတ္တာရျျ ဘောဇျာဓိပါတေးသမီပံ နေတုံ သ တာနာဒိၑတ်, တေ တဒနယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","အပရဉ္စ တဇ္ဇလံ ကထံ ဒြာက္ၐာရသော'ဘဝတ် တဇ္ဇလဝါဟကာဒါသာ ဇ္ဉာတုံ ၑက္တား ကိန္တု တဒ္ဘေါဇျာဓိပေါ ဇ္ဉာတုံ နာၑက္နောတ် တဒဝလိဟျ ဝရံ သံမ္ဗောဒျာဝဒတ, ");
INSERT INTO sanbur_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","လောကား ပြထမံ ဥတ္တမဒြာက္ၐာရသံ ဒဒတိ တၐု ယထေၐ္ဋံ ပိတဝတ္သု တသ္မာ ကိဉ္စိဒနုတ္တမဉ္စ ဒဒတိ ကိန္တု တွမိဒါနီံ ယာဝတ် ဥတ္တမဒြာက္ၐာရသံ သ္ထာပယသိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ဣတ္ထံ ယီၑုရ္ဂာလီလပြဒေၑေ အာၑ္စရျျကာရ္မ္မ ပြာရမ္ဘ နိဇမဟိမာနံ ပြာကာၑယတ် တတး ၑိၐျာသ္တသ္မိန် ဝျၑွသန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","တတး ပရမ် သ နိဇမာတြုဘြာတြုသ္ၑိၐျဲး သာရ္ဒ္ဓ္ံ ကဖရ္နာဟူမမ် အာဂမတ် ကိန္တု တတြ ဗဟူဒိနာနိ အာတိၐ္ဌတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","တဒနန္တရံ ယိဟူဒိယာနာံ နိသ္တာရောတ္သဝေ နိကဋမာဂတေ ယီၑု ရျိရူၑာလမ် နဂရမ် အာဂစ္ဆတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","တတော မန္ဒိရသျ မဓျေ ဂေါမေၐပါရာဝတဝိကြယိဏော ဝါဏိဇက္ၐ္စောပဝိၐ္ဋာန် ဝိလောကျ ");
INSERT INTO sanbur_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ရဇ္ဇုဘိး ကၑာံ နိရ္မ္မာယ သရွွဂေါမေၐာဒိဘိး သာရ္ဒ္ဓံ တာန် မန္ဒိရာဒ် ဒူရီကၖတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ဝဏိဇာံ မုဒြာဒိ ဝိကီရျျ အာသနာနိ နျူဗ္ဇီကၖတျ ပါရာဝတဝိကြယိဘျော'ကထယဒ် အသ္မာတ် သ္ထာနာတ် သရွာဏျေတာနိ နယတ, မမ ပိတုဂၖဟံ ဝါဏိဇျဂၖဟံ မာ ကာရ္ၐ္ဋ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","တသ္မာတ် တန္မန္ဒိရာရ္ထ ဥဒျောဂေါ ယသ္တု သ ဂြသတီဝ မာမ်၊ ဣမာံ ၑာသ္တြီယလိပိံ ၑိၐျားသမသ္မရန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","တတး ပရမ် ယိဟူဒီယလောကာ ယီၐိမဝဒန် တဝမိဒၖၑကရ္မ္မကရဏာတ် ကိံ စိဟ္နမသ္မာန် ဒရ္ၑယသိ? ");
INSERT INTO sanbur_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","တတော ယီၑုသ္တာနဝေါစဒ် ယုၐ္မာဘိရေ တသ္မိန် မန္ဒိရေ နာၑိတေ ဒိနတြယမဓျေ'ဟံ တဒ် ဥတ္ထာပယိၐျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","တဒါ ယိဟူဒိယာ ဝျာဟာရ္ၐုး, ဧတသျ မန္ဒိရသ နိရ္မ္မာဏေန ၐဋ္စတွာရိံၑဒ် ဝတ္သရာ ဂတား, တွံ ကိံ ဒိနတြယမဓျေ တဒ် ဥတ္ထာပယိၐျသိ? ");
INSERT INTO sanbur_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","ကိန္တု သ နိဇဒေဟရူပမန္ဒိရေ ကထာမိမာံ ကထိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","သ ယဒေတာဒၖၑံ ဂဒိတဝါန် တစ္ဆိၐျား ၑ္မၑာနာတ် တဒီယောတ္ထာနေ သတိ သ္မၖတွာ ဓရ္မ္မဂြန္ထေ ယီၑုနောက္တကထာယာံ စ ဝျၑွသိၐုး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","အနန္တရံ နိသ္တာရောတ္သဝသျ ဘောဇျသမယေ ယိရူၑာလမ် နဂရေ တတ္ကြုတာၑ္စရျျကရ္မ္မာဏိ ဝိလောကျ ဗဟုဘိသ္တသျ နာမနိ ဝိၑွသိတံ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","ကိန္တု သ တေၐာံ ကရေၐု သွံ န သမရ္ပယတ်, ယတး သ သရွွာနဝဲတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","သ မာနဝေၐု ကသျစိတ် ပြမာဏံ နာပေက္ၐတ ယတော မနုဇာနာံ မဓျေ ယဒျဒသ္တိ တတ္တတ် သောဇာနာတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","နိကဒိမနာမာ ယိဟူဒီယာနာမ် အဓိပတိး ဖိရူၑီ က္ၐဏဒါယာံ ");
INSERT INTO sanbur_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ယီၑော်ရဘျရ္ဏမ် အာဝြဇျ ဝျာဟာရ္ၐီတ်, ဟေ ဂုရော ဘဝါန် ဤၑွရာဒ် အာဂတ် ဧက ဥပဒေၐ္ဋာ, ဧတဒ် အသ္မာဘိရ္ဇ္ဉာယတေ; ယတော ဘဝတာ ယာနျာၑ္စရျျကရ္မ္မာဏိ ကြိယန္တေ ပရမေၑွရသျ သာဟာယျံ ဝိနာ ကေနာပိ တတ္တတ္ကရ္မ္မာဏိ ကရ္တ္တုံ န ၑကျန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","တဒါ ယီၑုရုတ္တရံ ဒတ္တဝါန် တဝါဟံ ယထာရ္ထတရံ ဝျာဟရာမိ ပုနရ္ဇန္မနိ န သတိ ကောပိ မာနဝ ဤၑွရသျ ရာဇျံ ဒြၐ္ဋုံ န ၑက္နောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","တတော နိကဒီမး ပြတျဝေါစတ် မနုဇော ဝၖဒ္ဓေါ ဘူတွာ ကထံ ဇနိၐျတေ? သ ကိံ ပုန ရ္မာတၖရ္ဇဌရံ ပြဝိၑျ ဇနိတုံ ၑက္နောတိ? ");
INSERT INTO sanbur_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","ယီၑုရဝါဒီဒ် ယထာရ္ထတရမ် အဟံ ကထယာမိ မနုဇေ တောယာတ္မဘျာံ ပုန ရ္န ဇာတေ သ ဤၑွရသျ ရာဇျံ ပြဝေၐ္ဋုံ န ၑက္နောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","မာံသာဒ် ယတ် ဇာယတေ တန် မာံသမေဝ တထာတ္မနော ယော ဇာယတေ သ အာတ္မဲဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","ယုၐ္မာဘိး ပုန ရ္ဇနိတဝျံ မမဲတသျာံ ကထာယာမ် အာၑ္စရျံ မာ မံသ္ထား၊ ");
INSERT INTO sanbur_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","သဒါဂတိရျာံ ဒိၑမိစ္ဆတိ တသျာမေဝ ဒိၑိ ဝါတိ, တွံ တသျ သွနံ ၑုဏောၐိ ကိန္တု သ ကုတ အာယာတိ ကုတြ ယာတိ ဝါ ကိမပိ န ဇာနာသိ တဒွါဒ် အာတ္မနး သကာၑာတ် သရွွေၐာံ မနုဇာနာံ ဇန္မ ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","တဒါ နိကဒီမး ပၖၐ္ဋဝါန် ဧတတ် ကထံ ဘဝိတုံ ၑက္နောတိ? ");
INSERT INTO sanbur_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","ယီၑုး ပြတျက္တဝါန် တွမိသြာယေလော ဂုရုရ္ဘူတွာပိ ကိမေတာံ ကထာံ န ဝေတ္သိ? ");
INSERT INTO sanbur_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","တုဘျံ ယထာရ္ထံ ကထယာမိ, ဝယံ ယဒ် ဝိဒ္မသ္တဒ် ဝစ္မး ယံစ္စ ပၑျာမသ္တသျဲဝ သာက္ၐျံ ဒဒ္မး ကိန္တု ယုၐ္မာဘိရသ္မာကံ သာက္ၐိတွံ န ဂၖဟျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ဧတသျ သံသာရသျ ကထာယာံ ကထိတာယာံ ယဒိ ယူယံ န ဝိၑွသိထ တရှိ သွရ္ဂီယာယာံ ကထာယာံ ကထံ ဝိၑွသိၐျထ? ");
INSERT INTO sanbur_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ယး သွရ္ဂေ'သ္တိ ယံ စ သွရ္ဂာဒ် အဝါရောဟတ် တံ မာနဝတနယံ ဝိနာ ကောပိ သွရ္ဂံ နာရောဟတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","အပရဉ္စ မူသာ ယထာ ပြာန္တရေ သရ္ပံ ပြောတ္ထာပိတဝါန် မနုၐျပုတြော'ပိ တထဲဝေါတ္ထာပိတဝျး; ");
INSERT INTO sanbur_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","တသ္မာဒ် ယး ကၑ္စိတ် တသ္မိန် ဝိၑွသိၐျတိ သော'ဝိနာၑျး သန် အနန္တာယုး ပြာပ္သျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ဤၑွရ ဣတ္ထံ ဇဂဒဒယတ ယတ် သွမဒွိတီယံ တနယံ ပြာဒဒါတ် တတော ယး ကၑ္စိတ် တသ္မိန် ဝိၑွသိၐျတိ သော'ဝိနာၑျး သန် အနန္တာယုး ပြာပ္သျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ဤၑွရော ဇဂတော လောကာန် ဒဏ္ဍယိတုံ သွပုတြံ န ပြေၐျ တာန် ပရိတြာတုံ ပြေၐိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","အတဧဝ ယး ကၑ္စိတ် တသ္မိန် ဝိၑွသိတိ သ ဒဏ္ဍာရှော န ဘဝတိ ကိန္တု ယး ကၑ္စိတ် တသ္မိန် န ဝိၑွသိတိ သ ဣဒါနီမေဝ ဒဏ္ဍာရှော ဘဝတိ,ယတး သ ဤၑွရသျာဒွိတီယပုတြသျ နာမနိ ပြတျယံ န ကရောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","ဇဂတော မဓျေ ဇျောတိး ပြာကာၑတ ကိန္တု မနုၐျာဏာံ ကရ္မ္မဏာံ ဒၖၐ္ဋတွာတ် တေ ဇျောတိၐောပိ တိမိရေ ပြီယန္တေ ဧတဒေဝ ဒဏ္ဍသျ ကာရဏာံ ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ယး ကုကရ္မ္မ ကရောတိ တသျာစာရသျ ဒၖၐ္ဋတွာတ် သ ဇျောတိရၗတီယိတွာ တန္နိကဋံ နာယာတိ; ");
INSERT INTO sanbur_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","ကိန္တု ယး သတ္ကရ္မ္မ ကရောတိ တသျ သရွွာဏိ ကရ္မ္မာဏီၑွရေဏ ကၖတာနီတိ သထာ ပြကာၑတေ တဒဘိပြာယေဏ သ ဇျောတိၐး သန္နိဓိမ် အာယာတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","တတး ပရမ် ယီၑုး ၑိၐျဲး သာရ္ဒ္ဓံ ယိဟူဒီယဒေၑံ ဂတွာ တတြ သ္ထိတွာ မဇ္ဇယိတုမ် အာရဘတ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","တဒါ ၑာလမ် နဂရသျ သမီပသ္ထာယိနိ အဲနန် ဂြာမေ ဗဟုတရတောယသ္ထိတေသ္တတြ ယောဟန် အမဇ္ဇယတ် တထာ စ လောကာ အာဂတျ တေန မဇ္ဇိတာ အဘဝန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","တဒါ ယောဟန် ကာရာယာံ န ဗဒ္ဓး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","အပရဉ္စ ၑာစကရ္မ္မဏိ ယောဟာနး ၑိၐျဲး သဟ ယိဟူဒီယလောကာနာံ ဝိဝါဒေ ဇာတေ, တေ ယောဟနး သံန္နိဓိံ ဂတွာကထယန်, ");
INSERT INTO sanbur_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ဟေ ဂုရော ယရ္ဒ္ဒနနဒျား ပါရေ ဘဝတာ သာရ္ဒ္ဓံ ယ အာသီတ် ယသ္မိံၑ္စ ဘဝါန် သာက္ၐျံ ပြဒဒါတ် ပၑျတု သောပိ မဇ္ဇယတိ သရွွေ တသျ သမီပံ ယာန္တိ စ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","တဒါ ယောဟန် ပြတျဝေါစဒ် ဤၑွရေဏ န ဒတ္တေ ကောပိ မနုဇး ကိမပိ ပြာပ္တုံ န ၑက္နောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","အဟံ အဘိၐိက္တော န ဘဝါမိ ကိန္တု တဒဂြေ ပြေၐိတောသ္မိ ယာမိမာံ ကထာံ ကထိတဝါနာဟံ တတြ ယူယံ သရွွေ သာက္ၐိဏး သ္ထ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","ယော ဇနး ကနျာံ လဘတေ သ ဧဝ ဝရး ကိန္တု ဝရသျ သန္နိဓော် ဒဏ္ဍာယမာနံ တသျ ယန္မိတြံ တေန ဝရသျ ၑဗ္ဒေ ၑြုတေ'တီဝါဟ္လာဒျတေ မမာပိ တဒွဒ် အာနန္ဒသိဒ္ဓိရ္ဇာတာ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","တေန ကြမၑော ဝရ္ဒ္ဓိတဝျံ ကိန္တု မယာ ဟ္သိတဝျံ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ယ ဦရ္ဓွာဒါဂစ္ဆတ် သ သရွွေၐာံ မုချော ယၑ္စ သံသာရာဒ် ဥဒပဒျတ သ သာံသာရိကး သံသာရီယာံ ကထာဉ္စ ကထယတိ ယသ္တု သွရ္ဂာဒါဂစ္ဆတ် သ သရွွေၐာံ မုချး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","သ ယဒပၑျဒၑၖဏောစ္စ တသ္မိန္နေဝ သာက္ၐျံ ဒဒါတိ တထာပိ ပြာယၑး ကၑ္စိတ် တသျ သာက္ၐျံ န ဂၖဟ္လာတိ; ");
INSERT INTO sanbur_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ကိန္တု ယော ဂၖဟ္လာတိ သ ဤၑွရသျ သတျဝါဒိတွံ မုဒြာင်္ဂိတံ ကရောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ဤၑွရေဏ ယး ပြေရိတး သဧဝ ဤၑွရီယကထာံ ကထယတိ ယတ ဤၑွရ အာတ္မာနံ တသ္မဲ အပရိမိတမ် အဒဒါတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","ပိတာ ပုတြေ သ္နေဟံ ကၖတွာ တသျ ဟသ္တေ သရွွာဏိ သမရ္ပိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","ယး ကၑ္စိတ် ပုတြေ ဝိၑွသိတိ သ ဧဝါနန္တမ် ပရမာယုး ပြာပ္နောတိ ကိန္တု ယး ကၑ္စိတ် ပုတြေ န ဝိၑွသိတိ သ ပရမာယုၐော ဒရ္ၑနံ န ပြာပ္နောတိ ကိန္တွီၑွရသျ ကောပဘာဇနံ ဘူတွာ တိၐ္ဌတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","ယီၑုး သွယံ နာမဇ္ဇယတ် ကေဝလံ တသျ ၑိၐျာ အမဇ္ဇယတ် ကိန္တု ယောဟနော'ဓိကၑိၐျာန် သ ကရောတိ မဇ္ဇယတိ စ, ");
INSERT INTO sanbur_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ဖိရူၑိန ဣမာံ ဝါရ္တ္တာမၑၖဏွန် ဣတိ ပြဘုရဝဂတျ ");
INSERT INTO sanbur_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ယိဟူဒီယဒေၑံ ဝိဟာယ ပုန ရ္ဂာလီလမ် အာဂတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","တတး ၑောမိရောဏပြဒေၑသျ မဒျေန တေန ဂန္တဝျေ သတိ ");
INSERT INTO sanbur_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ယာကူဗ် နိဇပုတြာယ ယူၐဖေ ယာံ ဘူမိမ် အဒဒါတ် တတ္သမီပသ္ထာယိ ၑောမိရောဏပြဒေၑသျ သုခါရ် နာမ္နာ ဝိချာတသျ နဂရသျ သန္နိဓာဝုပါသ္ထာတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","တတြ ယာကူဗး ပြဟိရာသီတ်; တဒါ ဒွိတီယယာမဝေလာယာံ ဇာတာယာံ သ မာရ္ဂေ ၑြမာပန္နသ္တသျ ပြဟေး ပါရ္ၑွေ ဥပါဝိၑတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ဧတရှိ ကာစိတ် ၑောမိရောဏီယာ ယောၐိတ် တောယောတ္တောလနာရ္ထမ် တတြာဂမတ္ ");
INSERT INTO sanbur_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","တဒါ ၑိၐျား ခါဒျဒြဝျာဏိ ကြေတုံ နဂရမ် အဂစ္ဆန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","ယီၑုး ၑောမိရောဏီယာံ တာံ ယောၐိတမ် ဝျာဟာရ္ၐီတ် မဟျံ ကိဉ္စိတ် ပါနီယံ ပါတုံ ဒေဟိ၊ ကိန္တု ၑောမိရောဏီယဲး သာကံ ယိဟူဒီယလောကာ န ဝျဝါဟရန် တသ္မာဒ္ဓေတေား သာကထယတ် ၑောမိရောဏီယာ ယောၐိတဒဟံ တွံ ယိဟူဒီယောသိ ကထံ မတ္တး ပါနီယံ ပါတုမ် ဣစ္ဆသိ? ");
INSERT INTO sanbur_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","တတော ယီၑုရဝဒဒ် ဤၑွရသျ ယဒ္ဒါနံ တတ္ကီဒၖက် ပါနီယံ ပါတုံ မဟျံ ဒေဟိ ယ ဣတ္ထံ တွာံ ယာစတေ သ ဝါ က ဣတိ စေဒဇ္ဉာသျထာသ္တရှိ တမယာစိၐျထား သ စ တုဘျမမၖတံ တောယမဒါသျတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","တဒါ သာ သီမန္တိနီ ဘာၐိတဝတိ, ဟေ မဟေစ္ဆ ပြဟိရ္ဂမ္ဘီရော ဘဝတော နီရောတ္တောလနပါတြံ နာသ္တီ စ တသ္မာတ် တဒမၖတံ ကီလာလံ ကုတး ပြာပ္သျသိ? ");
INSERT INTO sanbur_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","ယောသ္မဘျမ် ဣမမန္ဓူံ ဒဒေါ်, ယသျ စ ပရိဇနာ ဂေါမေၐာဒယၑ္စ သရွွေ'သျ ပြဟေး ပါနီယံ ပပုရေတာဒၖၑော ယောသ္မာကံ ပူရွွပုရုၐော ယာကူဗ် တသ္မာဒပိ ဘဝါန် မဟာန် ကိံ? ");
INSERT INTO sanbur_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","တတော ယီၑုရကထယဒ် ဣဒံ ပါနီယံ သး ပိဝတိ သ ပုနသ္တၖၐာရ္တ္တော ဘဝိၐျတိ, ");
INSERT INTO sanbur_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ကိန္တု မယာ ဒတ္တံ ပါနီယံ ယး ပိဝတိ သ ပုနး ကဒါပိ တၖၐာရ္တ္တော န ဘဝိၐျတိ၊ မယာ ဒတ္တမ် ဣဒံ တောယံ တသျာန္တး ပြသြဝဏရူပံ ဘူတွာ အနန္တာယုရျာဝတ် သြောၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","တဒါ သာ ဝနိတာကထယတ် ဟေ မဟေစ္ဆ တရှိ မမ ပုနး ပီပါသာ ယထာ န ဇာယတေ တောယောတ္တောလနာယ ယထာတြာဂမနံ န ဘဝတိ စ တဒရ္ထံ မဟျံ တတ္တောယံ ဒေဟီ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","တတော ယီၑူရဝဒဒျာဟိ တဝ ပတိမာဟူယ သ္ထာနေ'တြာဂစ္ဆ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","သာ ဝါမာဝဒတ် မမ ပတိရ္နာသ္တိ၊ ယီၑုရဝဒတ် မမ ပတိရ္နာသ္တီတိ ဝါကျံ ဘဒြမဝေါစး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ယတသ္တဝ ပဉ္စ ပတယောဘဝန် အဓုနာ တု တွယာ သာရ္ဒ္ဓံ ယသ္တိၐ္ဌတိ သ တဝ ဘရ္တ္တာ န ဝါကျမိဒံ သတျမဝါဒိး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","တဒါ သာ မဟိလာ ဂဒိတဝတိ ဟေ မဟေစ္ဆ ဘဝါန် ဧကော ဘဝိၐျဒွါဒီတိ ဗုဒ္ဓံ မယာ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","အသ္မာကံ ပိတၖလောကာ ဧတသ္မိန် ၑိလောစ္စယေ'ဘဇန္တ, ကိန္တု ဘဝဒ္ဘိရုစျတေ ယိရူၑာလမ် နဂရေ ဘဇနယောဂျံ သ္ထာနမာသ္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","ယီၑုရဝေါစတ် ဟေ ယောၐိတ် မမ ဝါကျေ ဝိၑွသိဟိ ယဒါ ယူယံ ကေဝလၑဲလေ'သ္မိန် ဝါ ယိရူၑာလမ် နဂရေ ပိတုရ္ဘဇနံ န ကရိၐျဓွေ ကာလ ဧတာဒၖၑ အာယာတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","ယူယံ ယံ ဘဇဓွေ တံ န ဇာနီထ, ကိန္တု ဝယံ ယံ ဘဇာမဟေ တံ ဇာနီမဟေ, ယတော ယိဟူဒီယလောကာနာံ မဓျာတ် ပရိတြာဏံ ဇာယတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","ကိန္တု ယဒါ သတျဘက္တာ အာတ္မနာ သတျရူပေဏ စ ပိတုရ္ဘဇနံ ကရိၐျန္တေ သမယ ဧတာဒၖၑ အာယာတိ, ဝရမ် ဣဒါနီမပိ ဝိဒျတေ ; ယတ ဧတာဒၖၑော ဘတ္ကာန် ပိတာ စေၐ္ဋတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ဤၑွရ အာတ္မာ; တတသ္တသျ ယေ ဘက္တာသ္တဲး သ အာတ္မနာ သတျရူပေဏ စ ဘဇနီယး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","တဒါ သာ မဟိလာဝါဒီတ် ခြီၐ္ဋနာမ္နာ ဝိချာတော'ဘိၐိက္တး ပုရုၐ အာဂမိၐျတီတိ ဇာနာမိ သ စ သရွွား ကထာ အသ္မာန် ဇ္ဉာပယိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","တတော ယီၑုရဝဒတ် တွယာ သာရ္ဒ္ဓံ ကထနံ ကရောမိ ယော'ဟမ် အဟမေဝ သ ပုရုၐး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ဧတသ္မိန် သမယေ ၑိၐျာ အာဂတျ တထာ သ္တြိယာ သာရ္ဒ္ဓံ တသျ ကထောပကထနေ မဟာၑ္စရျျမ် အမနျန္တ တထာပိ ဘဝါန် ကိမိစ္ဆတိ? ယဒွါ ကိမရ္ထမ် ဧတယာ သာရ္ဒ္ဓံ ကထာံ ကထယတိ? ဣတိ ကောပိ နာပၖစ္ဆတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","တတး ပရံ သာ နာရီ ကလၑံ သ္ထာပယိတွာ နဂရမဓျံ ဂတွာ လောကေဘျောကထာယဒ္ ");
INSERT INTO sanbur_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","အဟံ ယဒျတ် ကရ္မ္မာကရဝံ တတ္သရွွံ မဟျမကထယဒ် ဧတာဒၖၑံ မာနဝမေကမ် အာဂတျ ပၑျတ ရု ကိမ် အဘိၐိက္တော န ဘဝတိ ? ");
INSERT INTO sanbur_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","တတသ္တေ နဂရာဒ် ဗဟိရာဂတျ တာတသျ သမီပမ် အာယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ဧတရှိ ၑိၐျား သာဓယိတွာ တံ ဝျာဟာရ္ၐုး ဟေ ဂုရော ဘဝါန် ကိဉ္စိဒ် ဘူက္တာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","တတး သောဝဒဒ် ယုၐ္မာဘိရျန္န ဇ္ဉာယတေ တာဒၖၑံ ဘက္ၐျံ မမာသ္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","တဒါ ၑိၐျား ပရသ္ပရံ ပြၐ္ဋုမ် အာရမ္ဘန္တ, ကိမသ္မဲ ကောပိ ကိမပိ ဘက္ၐျမာနီယ ဒတ္တဝါန်? ");
INSERT INTO sanbur_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","ယီၑုရဝေါစတ် မတ္ပြေရကသျာဘိမတာနုရူပကရဏံ တသျဲဝ ကရ္မ္မသိဒ္ဓိကာရဏဉ္စ မမ ဘက္ၐျံ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","မာသစတုၐ္ဋယေ ဇာတေ ၑသျကရ္တ္တနသမယော ဘဝိၐျတီတိ ဝါကျံ ယုၐ္မာဘိး ကိံ နောဒျတေ? ကိန္တွဟံ ဝဒါမိ, ၑိရ ဥတ္တောလျ က္ၐေတြာဏိ ပြတိ နိရီက္ၐျ ပၑျတ, ဣဒါနီံ ကရ္တ္တနယောဂျာနိ ၑုက္လဝရ္ဏာနျဘဝန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","ယၑ္ဆိနတ္တိ သ ဝေတနံ လဘတေ အနန္တာယုးသွရူပံ ၑသျံ သ ဂၖဟ္လာတိ စ, တေနဲဝ ဝပ္တာ ဆေတ္တာ စ ယုဂပဒ် အာနန္ဒတး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ဣတ္ထံ သတိ ဝပတျေကၑ္ဆိနတျနျ ဣတိ ဝစနံ သိဒ္ဓျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","ယတြ ယူယံ န ပရျျၑြာမျတ တာဒၖၑံ ၑသျံ ဆေတ္တုံ ယုၐ္မာန် ပြဲရယမ် အနျေ ဇနားပရျျၑြာမျန် ယူယံ တေၐာံ ၑြဂသျ ဖလမ် အလဘဓွမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","ယသ္မိန် ကာလေ ယဒျတ် ကရ္မ္မာကာရ္ၐံ တတ္သရွွံ သ မဟျမ် အကထယတ် တသျာ ဝနိတာယာ ဣဒံ သာက္ၐျဝါကျံ ၑြုတွာ တန္နဂရနိဝါသိနော ဗဟဝး ၑောမိရောဏီယလောကာ ဝျၑွသန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","တထာ စ တသျာန္တိကေ သမုပသ္ထာယ သွေၐာံ သန္နိဓော် ကတိစိဒ် ဒိနာနိ သ္ထာတုံ တသ္မိန် ဝိနယမ် အကုရွွာန တသ္မာတ် သ ဒိနဒွယံ တတ္သ္ထာနေ နျဝၐ္ဋတ္ ");
INSERT INTO sanbur_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","တတသ္တသျောပဒေၑေန ဗဟဝေါ'ပရေ ဝိၑွသျ ");
INSERT INTO sanbur_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","တာံ ယောၐာမဝဒန် ကေဝလံ တဝ ဝါကျေန ပြတီမ ဣတိ န, ကိန္တု သ ဇဂတော'ဘိၐိက္တသ္တြာတေတိ တသျ ကထာံ ၑြုတွာ ဝယံ သွယမေဝါဇ္ဉာသမဟိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","သွဒေၑေ ဘဝိၐျဒွက္တုး သတ္ကာရော နာသ္တီတိ ယဒျပိ ယီၑုး ပြမာဏံ ဒတွာကထယတ္ ");
INSERT INTO sanbur_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","တထာပိ ဒိဝသဒွယာတ် ပရံ သ တသ္မာတ် သ္ထာနာဒ် ဂါလီလံ ဂတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","အနန္တရံ ယေ ဂါလီလီ လိယလောကာ ဥတ္သဝေ ဂတာ ဥတ္သဝသမယေ ယိရူၑလမ် နဂရေ တသျ သရွွား ကြိယာ အပၑျန် တေ ဂါလီလမ် အာဂတံ တမ် အာဂၖဟ္လန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","တတး ပရမ် ယီၑု ရျသ္မိန် ကာန္နာနဂရေ ဇလံ ဒြာက္ၐာရသမ် အာကရောတ် တတ် သ္ထာနံ ပုနရဂါတ်၊ တသ္မိန္နေဝ သမယေ ကသျစိဒ် ရာဇသဘာသ္တာရသျ ပုတြး ကဖရ္နာဟူမပုရီ ရောဂဂြသ္တ အာသီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","သ ယေဟူဒီယဒေၑာဒ် ယီၑော ရ္ဂာလီလာဂမနဝါရ္တ္တာံ နိၑမျ တသျ သမီပံ ဂတွာ ပြာရ္ထျ ဝျာဟၖတဝါန် မမ ပုတြသျ ပြာယေဏ ကာလ အာသန္နး ဘဝါန် အာဂတျ တံ သွသ္ထံ ကရောတု၊ ");
INSERT INTO sanbur_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","တဒါ ယီၑုရကထယဒ် အာၑ္စရျျံ ကရ္မ္မ စိတြံ စိဟ္နံ စ န ဒၖၐ္ဋာ ယူယံ န ပြတျေၐျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","တတး သ သဘာသဒဝဒတ် ဟေ မဟေစ္ဆ မမ ပုတြေ န မၖတေ ဘဝါနာဂစ္ဆတု၊ ");
INSERT INTO sanbur_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","ယီၑုသ္တမဝဒဒ် ဂစ္ဆ တဝ ပုတြော'ဇီဝီတ် တဒါ ယီၑုနောက္တဝါကျေ သ ဝိၑွသျ ဂတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ဂမနကာလေ မာရ္ဂမဓျေ ဒါသာသ္တံ သာက္ၐာတ္ပြာပျာဝဒန် ဘဝတး ပုတြော'ဇီဝီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","တတး ကံ ကာလမာရဘျ ရောဂပြတီကာရာရမ္ဘော ဇာတာ ဣတိ ပၖၐ္ဋေ တဲရုက္တံ ဟျး သာရ္ဒ္ဓဒဏ္ဍဒွယာဓိကဒွိတီယယာမေ တသျ ဇွရတျာဂေါ'ဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","တဒါ ယီၑုသ္တသ္မိန် က္ၐဏေ ပြောက္တဝါန် တဝ ပုတြော'ဇီဝီတ် ပိတာ တဒ္ဗုဒ္ဓွာ သပရိဝါရော ဝျၑွသီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","ယိဟူဒီယဒေၑာဒ် အာဂတျ ဂါလီလိ ယီၑုရေတဒ် ဒွိတီယမ် အာၑ္စရျျကရ္မ္မာကရောတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","တတး ပရံ ယိဟူဒီယာနာမ် ဥတ္သဝ ဥပသ္ထိတေ ယီၑု ရျိရူၑာလမံ ဂတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","တသ္မိန္နဂရေ မေၐနာမ္နော ဒွါရသျ သမီပေ ဣဗြီယဘာၐယာ ဗဲထေသ္ဒာ နာမ္နာ ပိၐ္ကရိဏီ ပဉ္စဃဋ္ဋယုက္တာသီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","တသျာသ္တေၐု ဃဋ္ဋေၐု ကိလာလကမ္ပနမ် အပေက္ၐျ အန္ဓခဉ္စၑုၐ္ကာင်္ဂါဒယော ဗဟဝေါ ရောဂိဏး ပတန္တသ္တိၐ္ဌန္တိ သ္မ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ယတော ဝိၑေၐကာလေ တသျ သရသော ဝါရိ သွရ္ဂီယဒူတ ဧတျာကမ္ပယတ် တတ္ကီလာလကမ္ပနာတ် ပရံ ယး ကၑ္စိဒ် ရောဂီ ပြထမံ ပါနီယမဝါရောဟတ် သ ဧဝ တတ္က္ၐဏာဒ် ရောဂမုက္တော'ဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","တဒါၐ္ဋာတြိံၑဒွရ္ၐာဏိ ယာဝဒ် ရောဂဂြသ္တ ဧကဇနသ္တသ္မိန် သ္ထာနေ သ္ထိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","ယီၑုသ္တံ ၑယိတံ ဒၖၐ္ဋွာ ဗဟုကာလိကရောဂီတိ ဇ္ဉာတွာ ဝျာဟၖတဝါန် တွံ ကိံ သွသ္ထော ဗုဘူၐသိ? ");
INSERT INTO sanbur_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","တတော ရောဂီ ကထိတဝါန် ဟေ မဟေစ္ဆ ယဒါ ကီလာလံ ကမ္ပတေ တဒါ မာံ ပုၐ္ကရိဏီမ် အဝရောဟယိတုံ မမ ကောပိ နာသ္တိ, တသ္မာန် မမ ဂမနကာလေ ကၑ္စိဒနျော'ဂြော ဂတွာ အဝရောဟတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","တဒါ ယီၑုရကထယဒ် ဥတ္တိၐ္ဌ, တဝ ၑယျာမုတ္တောလျ ဂၖဟီတွာ ယာဟိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","သ တတ္က္ၐဏာတ် သွသ္ထော ဘူတွာ ၑယျာမုတ္တောလျာဒါယ ဂတဝါန် ကိန္တု တဒ္ဒိနံ ဝိၑြာမဝါရး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","တသ္မာဒ် ယိဟူဒီယား သွသ္ထံ နရံ ဝျာဟရန် အဒျ ဝိၑြာမဝါရေ ၑယနီယမာဒါယ န ယာတဝျမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","တတး သ ပြတျဝေါစဒ် ယော မာံ သွသ္ထမ် အကာရ္ၐီတ် ၑယနီယမ် ဥတ္တောလျာဒါယ ယာတုံ မာံ သ ဧဝါဒိၑတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","တဒါ တေ'ပၖစ္ဆန် ၑယနီယမ် ဥတ္တောလျာဒါယ ယာတုံ ယ အာဇ္ဉာပယတ် သ ကး? ");
INSERT INTO sanbur_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","ကိန္တု သ က ဣတိ သွသ္ထီဘူတော နာဇာနာဒ် ယတသ္တသ္မိန် သ္ထာနေ ဇနတာသတ္တွာဒ် ယီၑုး သ္ထာနာန္တရမ် အာဂမတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","တတး ပရံ ယေၑု ရ္မန္ဒိရေ တံ နရံ သာက္ၐာတ္ပြာပျာကထယတ် ပၑျေဒါနီမ် အနာမယော ဇာတောသိ ယထာဓိကာ ဒုရ္ဒၑာ န ဃဋတေ တဒ္ဓေတေား ပါပံ ကရ္မ္မ ပုနရ္မာကာရ္ၐီး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","တတး သ ဂတွာ ယိဟူဒီယာန် အဝဒဒ် ယီၑု ရ္မာမ် အရောဂိဏမ် အကာရ္ၐီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","တတော ယီၑု ရွိၑြာမဝါရေ ကရ္မ္မေဒၖၑံ ကၖတဝါန် ဣတိ ဟေတော ရျိဟူဒီယာသ္တံ တာဍယိတွာ ဟန္တုမ် အစေၐ္ဋန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","ယီၑုသ္တာနာချတ် မမ ပိတာ ယတ် ကာရျျံ ကရောတိ တဒနုရူပမ် အဟမပိ ကရောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","တတော ယိဟူဒီယာသ္တံ ဟန္တုံ ပုနရယတန္တ ယတော ဝိၑြာမဝါရံ နာမနျတ တဒေဝ ကေဝလံ န အဓိကန္တု ဤၑွရံ သွပိတရံ ပြောစျ သွမပီၑွရတုလျံ ကၖတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","ပၑ္စာဒ် ယီၑုရဝဒဒ် ယုၐ္မာနဟံ ယထာရ္ထတရံ ဝဒါမိ ပုတြး ပိတရံ ယဒျတ် ကရ္မ္မ ကုရွွန္တံ ပၑျတိ တဒတိရိက္တံ သွေစ္ဆာတး ကိမပိ ကရ္မ္မ ကရ္တ္တုံ န ၑက္နောတိ၊ ပိတာ ယတ် ကရောတိ ပုတြောပိ တဒေဝ ကရောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ပိတာ ပုတြေ သ္နေဟံ ကရောတိ တသ္မာတ် သွယံ ယဒျတ် ကရ္မ္မ ကရောတိ တတ္သရွွံ ပုတြံ ဒရ္ၑယတိ ; ယထာ စ ယုၐ္မာကံ အာၑ္စရျျဇ္ဉာနံ ဇနိၐျတေ တဒရ္ထမ် ဣတောပိ မဟာကရ္မ္မ တံ ဒရ္ၑယိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","ဝသ္တုတသ္တု ပိတာ ယထာ ပြမိတာန် ဥတ္ထာပျ သဇိဝါန် ကရောတိ တဒွတ် ပုတြောပိ ယံ ယံ ဣစ္ဆတိ တံ တံ သဇီဝံ ကရောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","သရွွေ ပိတရံ ယထာ သတ္ကုရွွန္တိ တထာ ပုတြမပိ သတ္ကာရယိတုံ ပိတာ သွယံ ကသျာပိ ဝိစာရမကၖတွာ သရွွဝိစာရာဏာံ ဘာရံ ပုတြေ သမရ္ပိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ယး ပုတြံ သတ် ကရောတိ သ တသျ ပြေရကမပိ သတ် ကရောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","ယုၐ္မာနာဟံ ယထာရ္ထတရံ ဝဒါမိ ယော ဇနော မမ ဝါကျံ ၑြုတွာ မတ္ပြေရကေ ဝိၑွသိတိ သောနန္တာယုး ပြာပ္နောတိ ကဒါပိ ဒဏ္ဍဗာဇနံ န ဘဝတိ နိဓနာဒုတ္ထာယ ပရမာယုး ပြာပ္နောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","အဟံ ယုၐ္မာနတိယထာရ္ထံ ဝဒါမိ ယဒါ မၖတာ ဤၑွရပုတြသျ နိနာဒံ ၑြောၐျန္တိ ယေ စ ၑြောၐျန္တိ တေ သဇီဝါ ဘဝိၐျန္တိ သမယ ဧတာဒၖၑ အာယာတိ ဝရမ် ဣဒါနီမပျုပတိၐ္ဌတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","ပိတာ ယထာ သွယဉ္ဇီဝီ တထာ ပုတြာယ သွယဉ္ဇီဝိတွာဓိကာရံ ဒတ္တဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","သ မနုၐျပုတြး ဧတသ္မာတ် ကာရဏာတ် ပိတာ ဒဏ္ဍကရဏာဓိကာရမပိ တသ္မိန် သမရ္ပိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","ဧတဒရ္ထေ ယူယမ် အာၑ္စရျျံ န မနျဓွံ ယတော ယသ္မိန် သမယေ တသျ နိနာဒံ ၑြုတွာ ၑ္မၑာနသ္ထား သရွွေ ဗဟိရာဂမိၐျန္တိ သမယ ဧတာဒၖၑ ဥပသ္ထာသျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","တသ္မာဒ် ယေ သတ္ကရ္မ္မာဏိ ကၖတဝန္တသ္တ ဥတ္ထာယ အာယုး ပြာပ္သျန္တိ ယေ စ ကုကရ္မာဏိ ကၖတဝန္တသ္တ ဥတ္ထာယ ဒဏ္ဍံ ပြာပ္သျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","အဟံ သွယံ ကိမပိ ကရ္တ္တုံ န ၑက္နောမိ ယထာ ၑုဏောမိ တထာ ဝိစာရယာမိ မမ ဝိစာရဉ္စ နျာယျး ယတောဟံ သွီယာဘီၐ္ဋံ နေဟိတွာ မတ္ပြေရယိတုး ပိတုရိၐ္ဋမ် ဤဟေ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","ယဒိ သွသ္မိန် သွယံ သာက္ၐျံ ဒဒါမိ တရှိ တတ္သာက္ၐျမ် အာဂြာဟျံ ဘဝတိ ; ");
INSERT INTO sanbur_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","ကိန္တု မဒရ္ထေ'ပရော ဇနး သာက္ၐျံ ဒဒါတိ မဒရ္ထေ တသျ ယတ် သာက္ၐျံ တတ် သတျမ် ဧတဒပျဟံ ဇာနာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","ယုၐ္မာဘိ ရျောဟနံ ပြတိ လောကေၐု ပြေရိတေၐု သ သတျကထာယာံ သာက္ၐျမဒဒါတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","မာနုၐာဒဟံ သာက္ၐျံ နောပေက္ၐေ တထာပိ ယူယံ ယထာ ပရိတြယဓွေ တဒရ္ထမ် ဣဒံ ဝါကျံ ဝဒါမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","ယောဟန် ဒေဒီပျမာနော ဒီပ ဣဝ တေဇသွီ သ္ထိတဝါန် ယူယမ် အလ္ပကာလံ တသျ ဒီပ္တျာနန္ဒိတုံ သမမနျဓွံ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","ကိန္တု တတ္ပြမာဏာဒပိ မမ ဂုရုတရံ ပြမာဏံ ဝိဒျတေ ပိတာ မာံ ပြေၐျ ယဒျတ် ကရ္မ္မ သမာပယိတုံ ၑက္တ္တိမဒဒါတ် မယာ ကၖတံ တတ္တတ် ကရ္မ္မ မဒရ္ထေ ပြမာဏံ ဒဒါတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ယး ပိတာ မာံ ပြေရိတဝါန် မောပိ မဒရ္ထေ ပြမာဏံ ဒဒါတိ၊ တသျ ဝါကျံ ယုၐ္မာဘိး ကဒါပိ န ၑြုတံ တသျ ရူပဉ္စ န ဒၖၐ္ဋံ ");
INSERT INTO sanbur_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","တသျ ဝါကျဉ္စ ယုၐ္မာကမ် အန္တး ကဒါပိ သ္ထာနံ နာပ္နောတိ ယတး သ ယံ ပြေၐိတဝါန် ယူယံ တသ္မိန် န ဝိၑွသိထ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","ဓရ္မ္မပုသ္တကာနိ ယူယမ် အာလောစယဓွံ တဲ ရွာကျဲရနန္တာယုး ပြာပ္သျာမ ဣတိ ယူယံ ဗုဓျဓွေ တဒ္ဓရ္မ္မပုသ္တကာနိ မဒရ္ထေ ပြမာဏံ ဒဒတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","တထာပိ ယူယံ ပရမာယုးပြာပ္တယေ မမ သံနိဓိမ် န ဇိဂမိၐထ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","အဟံ မာနုၐေဘျး သတ္ကာရံ န ဂၖဟ္လာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","အဟံ ယုၐ္မာန် ဇာနာမိ; ယုၐ္မာကမန္တရ ဤၑွရပြေမ နာသ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","အဟံ နိဇပိတု ရ္နာမ္နာဂတောသ္မိ တထာပိ မာံ န ဂၖဟ္လီထ ကိန္တု ကၑ္စိဒ် ယဒိ သွနာမ္နာ သမာဂမိၐျတိ တရှိ တံ ဂြဟီၐျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","ယူယမ် ဤၑွရာတ် သတ္ကာရံ န စိၐ္ဋတွာ ကေဝလံ ပရသ္ပရံ သတ္ကာရမ် စေဒ် အာဒဓွွေ တရှိ ကထံ ဝိၑွသိတုံ ၑက္နုထ? ");
INSERT INTO sanbur_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","ပုတုး သမီပေ'ဟံ ယုၐ္မာန် အပဝဒိၐျာမီတိ မာ စိန္တယတ ယသ္မိန် , ယသ္မိန် ယုၐ္မာကံ ဝိၑွသး သဧဝ မူသာ ယုၐ္မာန် အပဝဒတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","ယဒိ ယူယံ တသ္မိန် ဝျၑွသိၐျတ တရှိ မယျပိ ဝျၑွသိၐျတ, ယတ် သ မယိ လိခိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","တတော ယဒိ တေန လိခိတဝါနိ န ပြတိထ တရှိ မမ ဝါကျာနိ ကထံ ပြတျေၐျထ? ");
INSERT INTO sanbur_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","တတး ပရံ ယီၑု ရ္ဂာလီလ် ပြဒေၑီယသျ တိဝိရိယာနာမ္နး သိန္ဓေား ပါရံ ဂတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","တတော ဝျာဓိမလ္လောကသွာသ္ထျကရဏရူပါဏိ တသျာၑ္စရျျာဏိ ကရ္မ္မာဏိ ဒၖၐ္ဋွာ ဗဟဝေါ ဇနာသ္တတ္ပၑ္စာဒ် အဂစ္ဆန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","တတော ယီၑုး ပရွွတမာရုဟျ တတြ ၑိၐျဲး သာကမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","တသ္မိန် သမယ နိသ္တာရောတ္သဝနာမ္နိ ယိဟူဒီယာနာမ ဥတ္သဝ ဥပသ္ထိတေ ");
INSERT INTO sanbur_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","ယီၑု ရ္နေတြေ ဥတ္တောလျ ဗဟုလောကာန် သွသမီပါဂတာန် ဝိလောကျ ဖိလိပံ ပၖၐ္ဋဝါန် ဧတေၐာံ ဘောဇနာယ ဘောဇဒြဝျာဏိ ဝယံ ကုတြ ကြေတုံ ၑကြုမး? ");
INSERT INTO sanbur_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ဝါကျမိဒံ တသျ ပရီက္ၐာရ္ထမ် အဝါဒီတ် ကိန္တု ယတ် ကရိၐျတိ တတ် သွယမ် အဇာနာတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ဖိလိပး ပြတျဝေါစတ် ဧတေၐာမ် ဧကဲကော ယဒျလ္ပမ် အလ္ပံ ပြာပ္နောတိ တရှိ မုဒြာပါဒဒွိၑတေန ကြီတပူပါ အပိ နျူနာ ဘဝိၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ၑိမောန် ပိတရသျ ဘြာတာ အာန္ဒြိယာချး ၑိၐျာဏာမေကော ဝျာဟၖတဝါန္ ");
INSERT INTO sanbur_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","အတြ ကသျစိဒ် ဗာလကသျ သမီပေ ပဉ္စ ယာဝပူပါး က္ၐုဒြမတ္သျဒွယဉ္စ သန္တိ ကိန္တု လောကာနာံ ဧတာဝါတာံ မဓျေ တဲး ကိံ ဘဝိၐျတိ? ");
INSERT INTO sanbur_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","ပၑ္စာဒ် ယီၑုရဝဒတ် လောကာနုပဝေၑယတ တတြ ဗဟုယဝသသတ္တွာတ် ပဉ္စသဟသ္တြေဘျော နျူနာ အဓိကာ ဝါ ပုရုၐာ ဘူမျာမ် ဥပါဝိၑန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","တတော ယီၑုသ္တာန် ပူပါနာဒါယ ဤၑွရသျ ဂုဏာန် ကီရ္တ္တယိတွာ ၑိၐျေၐု သမာရ္ပယတ် တတသ္တေ တေဘျ ဥပဝိၐ္ဋလောကေဘျး ပူပါန် ယထေၐ္ဋမတ္သျဉ္စ ပြာဒုး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","တေၐု တၖပ္တေၐု သ တာနဝေါစဒ် ဧတေၐာံ ကိဉ္စိဒပိ ယထာ နာပစီယတေ တထာ သရွွာဏျဝၑိၐ္ဋာနိ သံဂၖဟ္လီတ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","တတး သရွွေၐာံ ဘောဇနာတ် ပရံ တေ တေၐာံ ပဉ္စာနာံ ယာဝပူပါနာံ အဝၑိၐ္ဋာနျခိလာနိ သံဂၖဟျ ဒွါဒၑဍလ္လကာန် အပူရယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","အပရံ ယီၑောရေတာဒၖၑီမ် အာၑ္စရျျကြိယာံ ဒၖၐ္ဋွာ လောကာ မိထော ဝက္တုမာရေဘိရေ ဇဂတိ ယသျာဂမနံ ဘဝိၐျတိ သ ဧဝါယမ် အဝၑျံ ဘဝိၐျဒွက္တ္တာ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","အတဧဝ လောကာ အာဂတျ တမာကြမျ ရာဇာနံ ကရိၐျန္တိ ယီၑုသ္တေၐာမ် ဤဒၖၑံ မာနသံ ဝိဇ္ဉာယ ပုနၑ္စ ပရွွတမ် ဧကာကီ ဂတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","သာယံကာလ ဥပသ္ထိတေ ၑိၐျာ ဇလဓိတဋံ ဝြဇိတွာ နာဝမာရုဟျ နဂရဒိၑိ သိန္ဓော် ဝါဟယိတွာဂမန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","တသ္မိန် သမယေ တိမိရ ဥပါတိၐ္ဌတ် ကိန္တု ယီၐုသ္တေၐာံ သမီပံ နာဂစ္ဆတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","တဒါ ပြဗလပဝနဝဟနာတ် သာဂရေ မဟာတရင်္ဂေါ ဘဝိတုမ် အာရေဘေ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","တတသ္တေ ဝါဟယိတွာ ဒွိတြာန် ကြောၑာန် ဂတား ပၑ္စာဒ် ယီၑုံ ဇလဓေရုပရိ ပဒ္ဘျာံ ဝြဇန္တံ နော်ကာန္တိကမ် အာဂစ္ဆန္တံ ဝိလောကျ တြာသယုက္တာ အဘဝန္ ");
INSERT INTO sanbur_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","ကိန္တု သ တာနုက္တ္တဝါန် အယမဟံ မာ ဘဲၐ္ဋ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","တဒါ တေ တံ သွဲရံ နာဝိ ဂၖဟီတဝန္တး တဒါ တတ္က္ၐဏာဒ် ဥဒ္ဒိၐ္ဋသ္ထာနေ နော်ရုပါသ္ထာတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","ယယာ နာဝါ ၑိၐျာ အဂစ္ဆန် တဒနျာ ကာပိ နော်ကာ တသ္မိန် သ္ထာနေ နာသီတ် တတော ယီၑုး ၑိၐျဲး သာကံ နာဂမတ် ကေဝလား ၑိၐျာ အဂမန် ဧတတ် ပါရသ္ထာ လောကာ ဇ္ဉာတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","ကိန္တု တတး ပရံ ပြဘု ရျတြ ဤၑွရသျ ဂုဏာန် အနုကီရ္တ္တျ လောကာန် ပူပါန် အဘောဇယတ် တတ္သ္ထာနသျ သမီပသ္ထတိဝိရိယာယာ အပရာသ္တရဏယ အာဂမန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","ယီၑုသ္တတြ နာသ္တိ ၑိၐျာ အပိ တတြ နာ သန္တိ လောကာ ဣတိ ဝိဇ္ဉာယ ယီၑုံ ဂဝေၐယိတုံ တရဏိဘိး ကဖရ္နာဟူမ် ပုရံ ဂတား၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","တတသ္တေ သရိတ္ပတေး ပါရေ တံ သာက္ၐာတ် ပြာပျ ပြာဝေါစန် ဟေ ဂုရော ဘဝါန် အတြ သ္ထာနေ ကဒါဂမတ်? ");
INSERT INTO sanbur_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","တဒါ ယီၑုသ္တာန် ပြတျဝါဒီဒ် ယုၐ္မာနဟံ ယထာရ္ထတရံ ဝဒါမိ အာၑ္စရျျကရ္မ္မဒရ္ၑနာဒ္ဓေတော ရ္န ကိန္တု ပူပဘောဇနာတ် တေန တၖပ္တတွာဉ္စ မာံ ဂဝေၐယထ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","က္ၐယဏီယဘက္ၐျာရ္ထံ မာ ၑြာမိၐ္ဋ ကိန္တွန္တာယုရ္ဘက္ၐျာရ္ထံ ၑြာမျတ, တသ္မာတ် တာဒၖၑံ ဘက္ၐျံ မနုဇပုတြော ယုၐ္မာဘျံ ဒါသျတိ; တသ္မိန် တာတ ဤၑွရး ပြမာဏံ ပြာဒါတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","တဒါ တေ'ပၖစ္ဆန် ဤၑွရာဘိမတံ ကရ္မ္မ ကရ္တ္တုမ် အသ္မာဘိး ကိံ ကရ္တ္တဝျံ? ");
INSERT INTO sanbur_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","တတော ယီၑုရဝဒဒ် ဤၑွရော ယံ ပြဲရယတ် တသ္မိန် ဝိၑွသနမ် ဤၑွရာဘိမတံ ကရ္မ္မ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","တဒါ တေ ဝျာဟရန် ဘဝတာ ကိံ လက္ၐဏံ ဒရ္ၑိတံ ယဒ္ဒၖၐ္ဋွာ ဘဝတိ ဝိၑွသိၐျာမး? တွယာ ကိံ ကရ္မ္မ ကၖတံ? ");
INSERT INTO sanbur_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","အသ္မာကံ ပူရွွပုရုၐာ မဟာပြာန္တရေ မာန္နာံ ဘောက္တ္တုံ ပြာပုး ယထာ လိပိရာသ္တေ၊ သွရ္ဂီယာဏိ တု ဘက္ၐျာဏိ ပြဒဒေါ် ပရမေၑွရး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","တဒါ ယီၑုရဝဒဒ် အဟံ ယုၐ္မာနတိယထာရ္ထံ ဝဒါမိ မူသာ ယုၐ္မာဘျံ သွရ္ဂီယံ ဘက္ၐျံ နာဒါတ် ကိန္တု မမ ပိတာ ယုၐ္မာဘျံ သွရ္ဂီယံ ပရမံ ဘက္ၐျံ ဒဒါတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ယး သွရ္ဂာဒဝရုဟျ ဇဂတေ ဇီဝနံ ဒဒါတိ သ ဤၑွရဒတ္တဘက္ၐျရူပး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","တဒါ တေ ပြာဝေါစန် ဟေ ပြဘော ဘက္ၐျမိဒံ နိတျမသ္မဘျံ ဒဒါတု၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","ယီၑုရဝဒဒ် အဟမေဝ ဇီဝနရူပံ ဘက္ၐျံ ယော ဇနော မမ သန္နိဓိမ် အာဂစ္ဆတိ သ ဇာတု က္ၐုဓာရ္တ္တော န ဘဝိၐျတိ, တထာ ယော ဇနော မာံ ပြတျေတိ သ ဇာတု တၖၐာရ္တ္တော န ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","မာံ ဒၖၐ္ဋွာပိ ယူယံ န ဝိၑွသိထ ယုၐ္မာနဟမ် ဣတျဝေါစံ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","ပိတာ မဟျံ ယာဝတော လောကာနဒဒါတ် တေ သရွွ ဧဝ မမာန္တိကမ် အာဂမိၐျန္တိ ယး ကၑ္စိစ္စ မမ သန္နိဓိမ် အာယာသျတိ တံ ကေနာပိ ပြကာရေဏ န ဒူရီကရိၐျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","နိဇာဘိမတံ သာဓယိတုံ န ဟိ ကိန္တု ပြေရယိတုရဘိမတံ သာဓယိတုံ သွရ္ဂာဒ် အာဂတောသ္မိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","သ ယာန် ယာန် လောကာန် မဟျမဒဒါတ် တေၐာမေကမပိ န ဟာရယိတွာ ၑေၐဒိနေ သရွွာနဟမ် ဥတ္ထာပယာမိ ဣဒံ မတ္ပြေရယိတုး ပိတုရဘိမတံ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","ယး ကၑ္စိန် မာနဝသုတံ ဝိလောကျ ဝိၑွသိတိ သ ၑေၐဒိနေ မယောတ္ထာပိတး သန် အနန္တာယုး ပြာပ္သျတိ ဣတိ မတ္ပြေရကသျာဘိမတံ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","တဒါ သွရ္ဂာဒ် ယဒ် ဘက္ၐျမ် အဝါရောဟတ် တဒ် ဘက္ၐျမ် အဟမေဝ ယိဟူဒီယလောကာသ္တသျဲတဒ် ဝါကျေ ဝိဝဒမာနာ ဝက္တ္တုမာရေဘိရေ ");
INSERT INTO sanbur_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ယူၐဖး ပုတြော ယီၑု ရျသျ မာတာပိတရော် ဝယံ ဇာနီမ ဧၐ ကိံ သဧဝ န? တရှိ သွရ္ဂာဒ် အဝါရောဟမ် ဣတိ ဝါကျံ ကထံ ဝက္တ္တိ? ");
INSERT INTO sanbur_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","တဒါ ယီၑုသ္တာန် ပြတျဝဒတ် ပရသ္ပရံ မာ ဝိဝဒဓွံ ");
INSERT INTO sanbur_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","မတ္ပြေရကေဏ ပိတြာ နာကၖၐ္ဋး ကောပိ ဇနော မမာန္တိကမ် အာယာတုံ န ၑက္နောတိ ကိန္တွာဂတံ ဇနံ စရမေ'ဟ္နိ ပြောတ္ထာပယိၐျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","တေ သရွွ ဤၑွရေဏ ၑိက္ၐိတာ ဘဝိၐျန္တိ ဘဝိၐျဒွါဒိနာံ ဂြန္ထေၐု လိပိရိတ္ထမာသ္တေ အတော ယး ကၑ္စိတ် ပိတုး သကာၑာတ် ၑြုတွာ ၑိက္ၐတေ သ ဧဝ မမ သမီပမ် အာဂမိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ယ ဤၑွရာဒ် အဇာယတ တံ ဝိနာ ကောပိ မနုၐျော ဇနကံ နာဒရ္ၑတ် ကေဝလး သဧဝ တာတမ် အဒြာက္ၐီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","အဟံ ယုၐ္မာန် ယထာရ္ထတရံ ဝဒါမိ ယော ဇနော မယိ ဝိၑွာသံ ကရောတိ သောနန္တာယုး ပြာပ္နောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","အဟမေဝ တဇ္ဇီဝနဘက္ၐျံ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","ယုၐ္မာကံ ပူရွွပုရုၐာ မဟာပြာန္တရေ မန္နာဘက္ၐျံ ဘူက္တ္တာပိ မၖတား ");
INSERT INTO sanbur_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","ကိန္တု ယဒ္ဘက္ၐျံ သွရ္ဂာဒါဂစ္ဆတ် တဒ် ယဒိ ကၑ္စိဒ် ဘုင်္က္တ္တေ တရှိ သ န မြိယတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","ယဇ္ဇီဝနဘက္ၐျံ သွရ္ဂာဒါဂစ္ဆတ် သောဟမေဝ ဣဒံ ဘက္ၐျံ ယော ဇနော ဘုင်္က္တ္တေ သ နိတျဇီဝီ ဘဝိၐျတိ၊ ပုနၑ္စ ဇဂတော ဇီဝနာရ္ထမဟံ ယတ် သွကီယပိၑိတံ ဒါသျာမိ တဒေဝ မယာ ဝိတရိတံ ဘက္ၐျမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","တသ္မာဒ် ယိဟူဒီယား ပရသ္ပရံ ဝိဝဒမာနာ ဝက္တ္တုမာရေဘိရေ ဧၐ ဘောဇနာရ္ထံ သွီယံ ပလလံ ကထမ် အသ္မဘျံ ဒါသျတိ? ");
INSERT INTO sanbur_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","တဒါ ယီၑုသ္တာန် အာဝေါစဒ် ယုၐ္မာနဟံ ယထာရ္ထတရံ ဝဒါမိ မနုၐျပုတြသျာမိၐေ ယုၐ္မာဘိ ရ္န ဘုက္တ္တေ တသျ ရုဓိရေ စ န ပီတေ ဇီဝနေန သာရ္ဒ္ဓံ ယုၐ္မာကံ သမ္ဗန္ဓော နာသ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ယော မမာမိၐံ သွာဒတိ မမ သုဓိရဉ္စ ပိဝတိ သောနန္တာယုး ပြာပ္နောတိ တတး ၑေၐေ'ဟ္နိ တမဟမ် ဥတ္ထာပယိၐျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","ယတော မဒီယမာမိၐံ ပရမံ ဘက္ၐျံ တထာ မဒီယံ ၑောဏိတံ ပရမံ ပေယံ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ယော ဇနော မဒီယံ ပလလံ သွာဒတိ မဒီယံ ရုဓိရဉ္စ ပိဝတိ သ မယိ ဝသတိ တသ္မိန္နဟဉ္စ ဝသာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","မတ္ပြေရယိတြာ ဇီဝတာ တာတေန ယထာဟံ ဇီဝါမိ တဒွဒ် ယး ကၑ္စိန် မာမတ္တိ သောပိ မယာ ဇီဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","ယဒ္ဘက္ၐျံ သွရ္ဂာဒါဂစ္ဆတ် တဒိဒံ ယန္မာန္နာံ သွာဒိတွာ ယုၐ္မာကံ ပိတရော'မြိယန္တ တာဒၖၑမ် ဣဒံ ဘက္ၐျံ န ဘဝတိ ဣဒံ ဘက္ၐျံ ယော ဘက္ၐတိ သ နိတျံ ဇီဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","ယဒါ ကဖရ္နာဟူမ် ပုရျျာံ ဘဇနဂေဟေ ဥပါဒိၑတ် တဒါ ကထာ ဧတာ အကထယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","တဒေတ္ထံ ၑြုတွာ တသျ ၑိၐျာဏာမ် အနေကေ ပရသ္ပရမ် အကထယန် ဣဒံ ဂါဎံ ဝါကျံ ဝါကျမီဒၖၑံ ကး ၑြောတုံ ၑကြုယာတ်? ");
INSERT INTO sanbur_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","ကိန္တု ယီၑုး ၑိၐျာဏာမ် ဣတ္ထံ ဝိဝါဒံ သွစိတ္တေ ဝိဇ္ဉာယ ကထိတဝါန် ဣဒံ ဝါကျံ ကိံ ယုၐ္မာကံ ဝိဃ္နံ ဇနယတိ? ");
INSERT INTO sanbur_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","ယဒိ မနုဇသုတံ ပူရွွဝါသသ္ထာနမ် ဦရ္ဒွွံ ဂစ္ဆန္တံ ပၑျထ တရှိ ကိံ ဘဝိၐျတိ? ");
INSERT INTO sanbur_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","အာတ္မဲဝ ဇီဝနဒါယကး ဝပု ရ္နိၐ္ဖလံ ယုၐ္မဘျမဟံ ယာနိ ဝစာံသိ ကထယာမိ တာနျာတ္မာ ဇီဝနဉ္စ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","ကိန္တု ယုၐ္မာကံ မဓျေ ကေစန အဝိၑွာသိနး သန္တိ ကေ ကေ န ဝိၑွသန္တိ ကော ဝါ တံ ပရကရေၐု သမရ္ပယိၐျတိ တာန် ယီၑုရာပြထမာဒ် ဝေတ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","အပရမပိ ကထိတဝါန် အသ္မာတ် ကာရဏာဒ် အကထယံ ပိတုး သကာၑာတ် ၑက္တ္တိမပြာပျ ကောပိ မမာန္တိကမ် အာဂန္တုံ န ၑက္နောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","တတ္ကာလေ'နေကေ ၑိၐျာ ဝျာဃုဋျ တေန သာရ္ဒ္ဓံ ပုန ရ္နာဂစ္ဆန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","တဒါ ယီၑု ရ္ဒွါဒၑၑိၐျာန် ဥက္တ္တဝါန် ယူယမပိ ကိံ ယာသျထ? ");
INSERT INTO sanbur_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","တတး ၑိမောန် ပိတရး ပြတျဝေါစတ် ဟေ ပြဘော ကသျာဘျရ္ဏံ ဂမိၐျာမး? ");
INSERT INTO sanbur_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","အနန္တဇီဝနဒါယိနျော ယား ကထာသ္တာသ္တဝဲဝ၊ ဘဝါန် အမရေၑွရသျာဘိၐိက္တ္တပုတြ ဣတိ ဝိၑွသျ နိၑ္စိတံ ဇာနီမး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","တဒါ ယီၑုရဝဒတ် ကိမဟံ ယုၐ္မာကံ ဒွါဒၑဇနာန် မနောနီတာန် န ကၖတဝါန်? ကိန္တု ယုၐ္မာကံ မဓျေပိ ကၑ္စိဒေကော ဝိဃ္နကာရီ ဝိဒျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ဣမာံ ကထံ သ ၑိမောနး ပုတြမ် ဤၐ္ကရီယောတီယံ ယိဟူဒါမ် ဥဒ္ဒိၑျ ကထိတဝါန် ယတော ဒွါဒၑာနာံ မဓျေ ဂဏိတး သ တံ ပရကရေၐု သမရ္ပယိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","တတး ပရံ ယိဟူဒီယလောကာသ္တံ ဟန္တုံ သမဲဟန္တ တသ္မာဒ် ယီၑု ရျိဟူဒါပြဒေၑေ ပရျျဋိတုံ နေစ္ဆန် ဂါလီလ် ပြဒေၑေ ပရျျဋိတုံ ပြာရဘတ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","ကိန္တု တသ္မိန် သမယေ ယိဟူဒီယာနာံ ဒူၐျဝါသနာမောတ္သဝ ဥပသ္ထိတေ ");
INSERT INTO sanbur_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","တသျ ဘြာတရသ္တမ် အဝဒန် ယာနိ ကရ္မ္မာဏိ တွယာ ကြိယန္တေ တာနိ ယထာ တဝ ၑိၐျား ပၑျန္တိ တဒရ္ထံ တွမိတး သ္ထာနာဒ် ယိဟူဒီယဒေၑံ ဝြဇ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ယး ကၑ္စိတ် သွယံ ပြစိကာၑိၐတိ သ ကဒါပိ ဂုပ္တံ ကရ္မ္မ န ကရောတိ ယဒီဒၖၑံ ကရ္မ္မ ကရောၐိ တရှိ ဇဂတိ နိဇံ ပရိစာယယ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ယတသ္တသျ ဘြာတရောပိ တံ န ဝိၑွသန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","တဒါ ယီၑုသ္တာန် အဝေါစတ် မမ သမယ ဣဒါနီံ နောပတိၐ္ဌတိ ကိန္တု ယုၐ္မာကံ သမယး သတတမ် ဥပတိၐ္ဌတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","ဇဂတော လောကာ ယုၐ္မာန် ၒတီယိတုံ န ၑကြုဝန္တိ ကိန္တု မာမေဝ ၒတီယန္တေ ယတသ္တေၐာံ ကရ္မာဏိ ဒုၐ္ဋာနိ တတြ သာက္ၐျမိဒမ် အဟံ ဒဒါမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","အတဧဝ ယူယမ် ဥတ္သဝေ'သ္မိန် ယာတ နာဟမ် ဣဒါနီမ် အသ္မိန္နုတ္သဝေ ယာမိ ယတော မမ သမယ ဣဒါနီံ န သမ္ပူရ္ဏး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ဣတိ ဝါကျမ် ဥက္တ္တွာ သ ဂါလီလိ သ္ထိတဝါန္ ");
INSERT INTO sanbur_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","ကိန္တု တသျ ဘြာတၖၐု တတြ ပြသ္ထိတေၐု သတ္သု သော'ပြကဋ ဥတ္သဝမ် အဂစ္ဆတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","အနန္တရမ် ဥတ္သဝမ် ဥပသ္ထိတာ ယိဟူဒီယာသ္တံ မၖဂယိတွာပၖစ္ဆန် သ ကုတြ? ");
INSERT INTO sanbur_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","တတော လောကာနာံ မဓျေ တသ္မိန် နာနာဝိဓာ ဝိဝါဒါ ဘဝိတုမ် အာရဗ္ဓဝန္တး၊ ကေစိဒ် အဝေါစန် သ ဥတ္တမး ပုရုၐး ကေစိဒ် အဝေါစန် န တထာ ဝရံ လောကာနာံ ဘြမံ ဇနယတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","ကိန္တု ယိဟူဒီယာနာံ ဘယာတ် ကောပိ တသျ ပက္ၐေ သ္ပၐ္ဋံ နာကထယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","တတး ပရမ် ဥတ္သဝသျ မဓျသမယေ ယီၑု ရ္မန္ဒိရံ ဂတွာ သမုပဒိၑတိ သ္မ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","တတော ယိဟူဒီယာ လောကာ အာၑ္စရျျံ ဇ္ဉာတွာကထယန် ဧၐာ မာနုၐော နာဓီတျာ ကထမ် ဧတာဒၖၑော ဝိဒွါနဘူတ်? ");
INSERT INTO sanbur_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","တဒါ ယီၑုး ပြတျဝေါစဒ် ဥပဒေၑောယံ န မမ ကိန္တု ယော မာံ ပြေၐိတဝါန် တသျ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","ယော ဇနော နိဒေၑံ တသျ ဂြဟီၐျတိ မမောပဒေၑော မတ္တော ဘဝတိ ကိမ် ဤၑွရာဒ် ဘဝတိ သ ဂနသ္တဇ္ဇ္ဉာတုံ ၑက္ၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","ယော ဇနး သွတး ကထယတိ သ သွီယံ ဂေါ်ရဝမ် ဤဟတေ ကိန္တု ယး ပြေရယိတု ရ္ဂော်ရဝမ် ဤဟတေ သ သတျဝါဒီ တသ္မိန် ကောပျဓရ္မ္မော နာသ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","မူသာ ယုၐ္မဘျံ ဝျဝသ္ထာဂြန္ထံ ကိံ နာဒဒါတ်? ကိန္တု ယုၐ္မာကံ ကောပိ တာံ ဝျဝသ္ထာံ န သမာစရတိ၊ မာံ ဟန္တုံ ကုတော ယတဓွေ? ");
INSERT INTO sanbur_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","တဒါ လောကာ အဝဒန် တွံ ဘူတဂြသ္တသ္တွာံ ဟန္တုံ ကော ယတတေ? ");
INSERT INTO sanbur_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","တတော ယီၑုရဝေါစဒ် ဧကံ ကရ္မ္မ မယာကာရိ တသ္မာဒ် ယူယံ သရွွ မဟာၑ္စရျျံ မနျဓွေ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","မူသာ ယုၐ္မဘျံ တွက္ဆေဒဝိဓိံ ပြဒဒေါ် သ မူသာတော န ဇာတး ကိန္တု ပိတၖပုရုၐေဘျော ဇာတး တေန ဝိၑြာမဝါရေ'ပိ မာနုၐာဏာံ တွက္ဆေဒံ ကုရုထ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","အတဧဝ ဝိၑြာမဝါရေ မနုၐျာဏာံ တွက္ဆေဒေ ကၖတေ ယဒိ မူသာဝျဝသ္ထာမင်္ဂနံ န ဘဝတိ တရှိ မယာ ဝိၑြာမဝါရေ မာနုၐး သမ္ပူရ္ဏရူပေဏ သွသ္ထော'ကာရိ တတ္ကာရဏာဒ် ယူယံ ကိံ မဟျံ ကုပျထ? ");
INSERT INTO sanbur_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","သပက္ၐပါတံ ဝိစာရမကၖတွာ နျာယျံ ဝိစာရံ ကုရုတ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","တဒါ ယိရူၑာလမ် နိဝါသိနး ကတိပယဇနာ အကထယန် ဣမေ ယံ ဟန္တုံ စေၐ္ဋန္တေ သ ဧဝါယံ ကိံ န? ");
INSERT INTO sanbur_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","ကိန္တု ပၑျတ နိရ္ဘယး သန် ကထာံ ကထယတိ တထာပိ ကိမပိ အ ဝဒန္တျေတေ အယမေဝါဘိၐိက္တ္တော ဘဝတီတိ နိၑ္စိတံ ကိမဓိပတယော ဇာနန္တိ? ");
INSERT INTO sanbur_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","မနုဇောယံ ကသ္မာဒါဂမဒ် ဣတိ ဝယံ ဇာနောမး ကိန္တွဘိၐိက္တ္တ အာဂတေ သ ကသ္မာဒါဂတဝါန် ဣတိ ကောပိ ဇ္ဉာတုံ န ၑက္ၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","တဒါ ယီၑု ရ္မဓျေမန္ဒိရမ် ဥပဒိၑန် ဥစ္စဲးကာရမ် ဥက္တ္တဝါန် ယူယံ ကိံ မာံ ဇာနီထ? ကသ္မာစ္စာဂတောသ္မိ တဒပိ ကိံ ဇာနီထ? နာဟံ သွတ အာဂတောသ္မိ ကိန္တု ယး သတျဝါဒီ သဧဝ မာံ ပြေၐိတဝါန် ယူယံ တံ န ဇာနီထ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","တမဟံ ဇာနေ တေနာဟံ ပြေရိတ အဂတောသ္မိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","တသ္မာဒ် ယိဟူဒီယာသ္တံ ဓရ္တ္တုမ် ဥဒျတာသ္တထာပိ ကောပိ တသျ ဂါတြေ ဟသ္တံ နာရ္ပယဒ် ယတော ဟေတောသ္တဒါ တသျ သမယော နောပတိၐ္ဌတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","ကိန္တု ဗဟဝေါ လောကာသ္တသ္မိန် ဝိၑွသျ ကထိတဝါန္တော'ဘိၐိက္တ္တပုရုၐ အာဂတျ မာနုၐသျာသျ ကြိယာဘျး ကိမ် အဓိကာ အာၑ္စရျျား ကြိယား ကရိၐျတိ? ");
INSERT INTO sanbur_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","တတး ပရံ လောကာသ္တသ္မိန် ဣတ္ထံ ဝိဝဒန္တေ ဖိရူၑိနး ပြဓာနယာဇကာဉ္စေတိ ၑြုတဝန္တသ္တံ ဓၖတွာ နေတုံ ပဒါတိဂဏံ ပြေၐယာမာသုး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","တတော ယီၑုရဝဒဒ် အဟမ် အလ္ပဒိနာနိ ယုၐ္မာဘိး သာရ္ဒ္ဓံ သ္ထိတွာ မတ္ပြေရယိတုး သမီပံ ယာသျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","မာံ မၖဂယိၐျဓွေ ကိန္တူဒ္ဒေၑံ န လပ္သျဓွေ ရတြ သ္ထာသျာမိ တတြ ယူယံ ဂန္တုံ န ၑက္ၐျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","တဒါ ယိဟူဒီယား ပရသ္ပရံ ဝက္တ္တုမာရေဘိရေ အသျောဒ္ဒေၑံ န ပြာပ္သျာမ ဧတာဒၖၑံ ကိံ သ္ထာနံ ယာသျတိ? ဘိန္နဒေၑေ ဝိကီရ္ဏာနာံ ယိဟူဒီယာနာံ သန္နိဓိမ် ဧၐ ဂတွာ တာန် ဥပဒေက္ၐျတိ ကိံ? ");
INSERT INTO sanbur_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","နော စေတ် မာံ ဂဝေၐယိၐျထ ကိန္တူဒ္ဒေၑံ န ပြာပ္သျထ ဧၐ ကောဒၖၑံ ဝါကျမိဒံ ဝဒတိ? ");
INSERT INTO sanbur_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","အနန္တရမ် ဥတ္သဝသျ စရမေ'ဟနိ အရ္ထာတ် ပြဓာနဒိနေ ယီၑုရုတ္တိၐ္ဌန် ဥစ္စဲးကာရမ် အာဟွယန် ဥဒိတဝါန် ယဒိ ကၑ္စိတ် တၖၐာရ္တ္တော ဘဝတိ တရှိ မမာန္တိကမ် အာဂတျ ပိဝတု၊ ");
INSERT INTO sanbur_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ယး ကၑ္စိန္မယိ ဝိၑွသိတိ ဓရ္မ္မဂြန္ထသျ ဝစနာနုသာရေဏ တသျာဘျန္တရတော'မၖတတောယသျ သြောတာံသိ နိရ္ဂမိၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ယေ တသ္မိန် ဝိၑွသန္တိ တ အာတ္မာနံ ပြာပ္သျန္တီတျရ္ထေ သ ဣဒံ ဝါကျံ ဝျာဟၖတဝါန် ဧတတ္ကာလံ ယာဝဒ် ယီၑု ရွိဘဝံ န ပြာပ္တသ္တသ္မာတ် ပဝိတြ အာတ္မာ နာဒီယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ဧတာံ ဝါဏီံ ၑြုတွာ ဗဟဝေါ လောကာ အဝဒန် အယမေဝ နိၑ္စိတံ သ ဘဝိၐျဒွါဒီ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","ကေစိဒ် အကထယန် ဧၐဧဝ သောဘိၐိက္တ္တး ကိန္တု ကေစိဒ် အဝဒန် သောဘိၐိက္တ္တး ကိံ ဂါလီလ် ပြဒေၑေ ဇနိၐျတေ? ");
INSERT INTO sanbur_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","သောဘိၐိက္တ္တော ဒါယူဒေါ ဝံၑေ ဒါယူဒေါ ဇန္မသ္ထာနေ ဗဲတ္လေဟမိ ပတ္တနေ ဇနိၐျတေ ဓရ္မ္မဂြန္ထေ ကိမိတ္ထံ လိခိတံ နာသ္တိ? ");
INSERT INTO sanbur_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ဣတ္ထံ တသ္မိန် လောကာနာံ ဘိန္နဝါကျတာ ဇာတာ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","ကတိပယလောကာသ္တံ ဓရ္တ္တုမ် အဲစ္ဆန် တထာပိ တဒွပုၐိ ကောပိ ဟသ္တံ နာရ္ပယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","အနန္တရံ ပါဒါတိဂဏေ ပြဓာနယာဇကာနာံ ဖိရူၑိနာဉ္စ သမီပမာဂတဝတိ တေ တာန် အပၖစ္ဆန် ကုတော ဟေတောသ္တံ နာနယတ? ");
INSERT INTO sanbur_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","တဒါ ပဒါတယး ပြတျဝဒန် သ မာနဝ ဣဝ ကောပိ ကဒါပိ နောပါဒိၑတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","တတး ဖိရူၑိနး ပြာဝေါစန် ယူယမပိ ကိမဘြာမိၐ္ဋ? ");
INSERT INTO sanbur_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","အဓိပတီနာံ ဖိရူၑိနာဉ္စ ကောပိ ကိံ တသ္မိန် ဝျၑွသီတ်? ");
INSERT INTO sanbur_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ယေ ၑာသ္တြံ န ဇာနန္တိ တ ဣမေ'ဓမလောကာဧဝ ၑာပဂြသ္တား၊ ");
INSERT INTO sanbur_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","တဒါ နိကဒီမနာမာ တေၐာမေကော ယး က္ၐဏဒါယာံ ယီၑေား သန္နိဓိမ် အဂါတ် သ ဥက္တ္တဝါန္ ");
INSERT INTO sanbur_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","တသျ ဝါကျေ န ၑြုတေ ကရ္မ္မဏိ စ န ဝိဒိတေ 'သ္မာကံ ဝျဝသ္ထာ ကိံ ကဉ္စန မနုဇံ ဒေါၐီကရောတိ? ");
INSERT INTO sanbur_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","တတသ္တေ ဝျာဟရန် တွမပိ ကိံ ဂါလီလီယလောကး? ဝိဝိစျ ပၑျ ဂလီလိ ကောပိ ဘဝိၐျဒွါဒီ နောတ္ပဒျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","တတး ပရံ သရွွေ သွံ သွံ ဂၖဟံ ဂတား ကိန္တု ယီၑု ရ္ဇဲတုနနာမာနံ ၑိလောစ္စယံ ဂတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ပြတျူၐေ ယီၑုး ပနရ္မန္ဒိရမ် အာဂစ္ဆတ္ ");
INSERT INTO sanbur_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","တတး သရွွေၐု လောကေၐု တသျ သမီပ အာဂတေၐု သ ဥပဝိၑျ တာန် ဥပဒေၐ္ဋုမ် အာရဘတ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","တဒါ အဓျာပကား ဖိရူၑိနဉ္စ ဝျဘိစာရကရ္မ္မဏိ ဓၖတံ သ္တြိယမေကာမ် အာနိယ သရွွေၐာံ မဓျေ သ္ထာပယိတွာ ဝျာဟရန္ ");
INSERT INTO sanbur_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ဟေ ဂုရော ယောၐိတမ် ဣမာံ ဝျဘိစာရကရ္မ္မ ကုရွွာဏာံ လောကာ ဓၖတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ဧတာဒၖၑလောကား ပါၐာဏာဃာတေန ဟန္တဝျာ ဣတိ ဝိဓိရ္မူသာဝျဝသ္ထာဂြန္ထေ လိခိတောသ္တိ ကိန္တု ဘဝါန် ကိမာဒိၑတိ? ");
INSERT INTO sanbur_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","တေ တမပဝဒိတုံ ပရီက္ၐာဘိပြာယေဏ ဝါကျမိဒမ် အပၖစ္ဆန် ကိန္တု သ ပြဟွီဘူယ ဘူမာဝင်္ဂလျာ လေခိတုမ် အာရဘတ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","တတသ္တဲး ပုနး ပုနး ပၖၐ္ဋ ဥတ္ထာယ ကထိတဝါန် ယုၐ္မာကံ မဓျေ ယော ဇနော နိရပရာဓီ သဧဝ ပြထမမ် ဧနာံ ပါၐာဏေနာဟန္တု၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ပၑ္စာတ် သ ပုနၑ္စ ပြဟွီဘူယ ဘူမော် လေခိတုမ် အာရဘတ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","တာံ ကထံ ၑြုတွာ တေ သွသွမနသိ ပြဗောဓံ ပြာပျ ဇျေၐ္ဌာနုကြမံ ဧကဲကၑး သရွွေ ဗဟိရဂစ္ဆန် တတော ယီၑုရေကာကီ တယက္တ္တောဘဝတ် မဓျသ္ထာနေ ဒဏ္ဍာယမာနာ သာ ယောၐာ စ သ္ထိတာ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","တတ္ပၑ္စာဒ် ယီၑုရုတ္ထာယ တာံ ဝနိတာံ ဝိနာ ကမပျပရံ န ဝိလောကျ ပၖၐ္ဋဝါန် ဟေ ဝါမေ တဝါပဝါဒကား ကုတြ? ကောပိ တွာံ ကိံ န ဒဏ္ဍယတိ? ");
INSERT INTO sanbur_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","သာဝဒတ် ဟေ မဟေစ္ဆ ကောပိ န တဒါ ယီၑုရဝေါစတ် နာဟမပိ ဒဏ္ဍယာမိ ယာဟိ ပုနး ပါပံ မာကာရ္ၐီး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","တတော ယီၑုး ပုနရပိ လောကေဘျ ဣတ္ထံ ကထယိတုမ် အာရဘတ ဇဂတောဟံ ဇျောတိးသွရူပေါ ယး ကၑ္စိန် မတ္ပၑ္စာဒ ဂစ္ဆတိ သ တိမိရေ န ဘြမိတွာ ဇီဝနရူပါံ ဒီပ္တိံ ပြာပ္သျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","တတး ဖိရူၑိနော'ဝါဒိၐုသ္တွံ သွာရ္ထေ သွယံ သာက္ၐျံ ဒဒါသိ တသ္မာတ် တဝ သာက္ၐျံ ဂြာဟျံ န ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","တဒါ ယီၑုး ပြတျုဒိတဝါန် ယဒျပိ သွာရ္ထေ'ဟံ သွယံ သာက္ၐျံ ဒဒါမိ တထာပိ မတ် သာက္ၐျံ ဂြာဟျံ ယသ္မာဒ် အဟံ ကုတ အာဂတောသ္မိ ကွ ယာမိ စ တဒဟံ ဇာနာမိ ကိန္တု ကုတ အာဂတောသ္မိ ကုတြ ဂစ္ဆာမိ စ တဒ် ယူယံ န ဇာနီထ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","ယူယံ လော်ကိကံ ဝိစာရယထ နာဟံ ကိမပိ ဝိစာရယာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","ကိန္တု ယဒိ ဝိစာရယာမိ တရှိ မမ ဝိစာရော ဂြဟီတဝျော ယတောဟမ် ဧကာကီ နာသ္မိ ပြေရယိတာ ပိတာ မယာ သဟ ဝိဒျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","ဒွယော ရ္ဇနယေား သာက္ၐျံ ဂြဟဏီယံ ဘဝတီတိ ယုၐ္မာကံ ဝျဝသ္ထာဂြန္ထေ လိခိတမသ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","အဟံ သွာရ္ထေ သွယံ သာက္ၐိတွံ ဒဒါမိ ယၑ္စ မမ တာတော မာံ ပြေရိတဝါန် သောပိ မဒရ္ထေ သာက္ၐျံ ဒဒါတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","တဒါ တေ'ပၖစ္ဆန် တဝ တာတး ကုတြ? တတော ယီၑုး ပြတျဝါဒီဒ် ယူယံ မာံ န ဇာနီထ မတ္ပိတရဉ္စ န ဇာနီထ ယဒိ မာမ် အက္ၐာသျတ တရှိ မမ တာတမပျက္ၐာသျတ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ယီၑု ရ္မန္ဒိရ ဥပဒိၑျ ဘဏ္ဍာဂါရေ ကထာ ဧတာ အကထယတ် တထာပိ တံ ပြတိ ကောပိ ကရံ နောဒတောလယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","တတး ပရံ ယီၑုး ပုနရုဒိတဝါန် အဓုနာဟံ ဂစ္ဆာမိ ယူယံ မာံ ဂဝေၐယိၐျထ ကိန္တု နိဇဲး ပါပဲ ရ္မရိၐျထ ယတ် သ္ထာနမ် အဟံ ယာသျာမိ တတ် သ္ထာနမ် ယူယံ ယာတုံ န ၑက္ၐျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","တဒါ ယိဟူဒီယား ပြာဝေါစန် ကိမယမ် အာတ္မဃာတံ ကရိၐျတိ? ယတော ယတ် သ္ထာနမ် အဟံ ယာသျာမိ တတ် သ္ထာနမ် ယူယံ ယာတုံ န ၑက္ၐျထ ဣတိ ဝါကျံ ဗြဝီတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","တတော ယီၑုသ္တေဘျး ကထိတဝါန် ယူယမ် အဓးသ္ထာနီယာ လောကာ အဟမ် ဦရ္ဒွွသ္ထာနီယး ယူယမ် ဧတဇ္ဇဂတ္သမ္ဗန္ဓီယာ အဟမ် ဧတဇ္ဇဂတ္သမ္ဗန္ဓီယော န၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","တသ္မာတ် ကထိတဝါန် ယူယံ နိဇဲး ပါပဲ ရ္မရိၐျထ ယတောဟံ သ ပုမာန် ဣတိ ယဒိ န ဝိၑွသိထ တရှိ နိဇဲး ပါပဲ ရ္မရိၐျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","တဒါ တေ 'ပၖစ္ဆန် ကသ္တွံ? တတော ယီၑုး ကထိတဝါန် ယုၐ္မာကံ သန္နိဓော် ယသျ ပြသ္တာဝမ် အာ ပြထမာတ် ကရောမိ သဧဝ ပုရုၐောဟံ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","ယုၐ္မာသု မယာ ဗဟုဝါကျံ ဝက္တ္တဝျံ ဝိစာရယိတဝျဉ္စ ကိန္တု မတ္ပြေရယိတာ သတျဝါဒီ တသျ သမီပေ ယဒဟံ ၑြုတဝါန် တဒေဝ ဇဂတေ ကထယာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","ကိန္တု သ ဇနကေ ဝါကျမိဒံ ပြောက္တ္တဝါန် ဣတိ တေ နာဗုဓျန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","တတော ယီၑုရကထယဒ် ယဒါ မနုၐျပုတြမ် ဦရ္ဒွွ ဥတ္ထာပယိၐျထ တဒါဟံ သ ပုမာန် ကေဝလး သွယံ ကိမပိ ကရ္မ္မ န ကရောမိ ကိန္တု တာတော ယထာ ၑိက္ၐယတိ တဒနုသာရေဏ ဝါကျမိဒံ ဝဒါမီတိ စ ယူယံ ဇ္ဉာတုံ ၑက္ၐျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","မတ္ပြေရယိတာ ပိတာ မာမ် ဧကာကိနံ န တျဇတိ သ မယာ သာရ္ဒ္ဓံ တိၐ္ဌတိ ယတောဟံ တဒဘိမတံ ကရ္မ္မ သဒါ ကရောမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","တဒါ တသျဲတာနိ ဝါကျာနိ ၑြုတွာ ဗဟုဝသ္တာသ္မိန် ဝျၑွသန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","ယေ ယိဟူဒီယာ ဝျၑွသန် ယီၑုသ္တေဘျော'ကထယတ္ ");
INSERT INTO sanbur_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","မမ ဝါကျေ ယဒိ ယူယမ် အာသ္ထာံ ကုရုထ တရှိ မမ ၑိၐျာ ဘူတွာ သတျတွံ ဇ္ဉာသျထ တတး သတျတယာ ယုၐ္မာကံ မောက္ၐော ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","တဒါ တေ ပြတျဝါဒိၐုး ဝယမ် ဣဗြာဟီမော ဝံၑး ကဒါပိ ကသျာပိ ဒါသာ န ဇာတာသ္တရှိ ယုၐ္မာကံ မုက္တ္တိ ရ္ဘဝိၐျတီတိ ဝါကျံ ကထံ ဗြဝီၐိ? ");
INSERT INTO sanbur_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","တဒါ ယီၑုး ပြတျဝဒဒ် ယုၐ္မာနဟံ ယထာရ္ထတရံ ဝဒါမိ ယး ပါပံ ကရောတိ သ ပါပသျ ဒါသး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","ဒါသၑ္စ နိရန္တရံ နိဝေၑနေ န တိၐ္ဌတိ ကိန္တု ပုတြော နိရန္တရံ တိၐ္ဌတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","အတး ပုတြော ယဒိ ယုၐ္မာန် မောစယတိ တရှိ နိတာန္တမေဝ မုက္တ္တာ ဘဝိၐျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","ယုယမ် ဣဗြာဟီမော ဝံၑ ဣတျဟံ ဇာနာမိ ကိန္တု မမ ကထာ ယုၐ္မာကမ် အန္တးကရဏေၐု သ္ထာနံ န ပြာပ္နုဝန္တိ တသ္မာဒ္ဓေတော ရ္မာံ ဟန္တုမ် ဤဟဓွေ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","အဟံ သွပိတုး သမီပေ ယဒပၑျံ တဒေဝ ကထယာမိ တထာ ယူယမပိ သွပိတုး သမီပေ ယဒပၑျတ တဒေဝ ကုရုဓွေ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","တဒါ တေ ပြတျဝေါစန် ဣဗြာဟီမ် အသ္မာကံ ပိတာ တတော ယီၑုရကထယဒ် ယဒိ ယူယမ် ဣဗြာဟီမး သန္တာနာ အဘဝိၐျတ တရှိ ဣဗြာဟီမ အာစာရဏဝဒ် အာစရိၐျတ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ဤၑွရသျ မုခါတ် သတျံ ဝါကျံ ၑြုတွာ ယုၐ္မာန် ဇ္ဉာပယာမိ ယောဟံ တံ မာံ ဟန္တုံ စေၐ္ဋဓွေ ဣဗြာဟီမ် ဧတာဒၖၑံ ကရ္မ္မ န စကာရ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","ယူယံ သွသွပိတုး ကရ္မ္မာဏိ ကုရုထ တဒါ တဲရုက္တ္တံ န ဝယံ ဇာရဇာတာ အသ္မာကမ် ဧကဧဝ ပိတာသ္တိ သ ဧဝေၑွရး ");
INSERT INTO sanbur_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","တတော ယီၑုနာ ကထိတမ် ဤၑွရော ယဒိ ယုၐ္မာကံ တာတောဘဝိၐျတ် တရှိ ယူယံ မယိ ပြေမာကရိၐျတ ယတောဟမ် ဤၑွရာန္နိရ္ဂတျာဂတောသ္မိ သွတော နာဂတောဟံ သ မာံ ပြာဟိဏောတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","ယူယံ မမ ဝါကျမိဒံ န ဗုဓျဓွေ ကုတး? ယတော ယူယံ မမောပဒေၑံ သောဎုံ န ၑက္နုထ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","ယူယံ ၑဲတာန် ပိတုး သန္တာနာ ဧတသ္မာဒ် ယုၐ္မာကံ ပိတုရဘိလာၐံ ပူရယထ သ အာ ပြထမာတ် နရဃာတီ တဒန္တး သတျတွသျ လေၑောပိ နာသ္တိ ကာရဏာဒတး သ သတျတာယာံ နာတိၐ္ဌတ် သ ယဒါ မၖၐာ ကထယတိ တဒါ နိဇသွဘာဝါနုသာရေဏဲဝ ကထယတိ ယတော သ မၖၐာဘာၐီ မၖၐောတ္ပာဒကၑ္စ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","အဟံ တထျဝါကျံ ဝဒါမိ ကာရဏာဒသ္မာဒ် ယူယံ မာံ န ပြတီထ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","မယိ ပါပမသ္တီတိ ပြမာဏံ ယုၐ္မာကံ ကော ဒါတုံ ၑက္နောတိ? ယဒျဟံ တထျဝါကျံ ဝဒါမိ တရှိ ကုတော မာံ န ပြတိထ? ");
INSERT INTO sanbur_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ယး ကၑ္စန ဤၑွရီယော လောကး သ ဤၑွရီယကထာယာံ မနော နိဓတ္တေ ယူယမ် ဤၑွရီယလောကာ န ဘဝထ တန္နိဒါနာတ် တတြ န မနာံသိ နိဓဒွေ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","တဒါ ယိဟူဒီယား ပြတျဝါဒိၐုး တွမေကး ၑောမိရောဏီယော ဘူတဂြသ္တၑ္စ ဝယံ ကိမိဒံ ဘဒြံ နာဝါဒိၐ္မ? ");
INSERT INTO sanbur_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","တတော ယီၑုး ပြတျဝါဒီတ် နာဟံ ဘူတဂြသ္တး ကိန္တု နိဇတာတံ သမ္မနျေ တသ္မာဒ် ယူယံ မာမ် အပမနျဓွေ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","အဟံ သွသုချာတိံ န စေၐ္ဋေ ကိန္တု စေၐ္ဋိတာ ဝိစာရယိတာ စာပရ ဧက အာသ္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","အဟံ ယုၐ္မဘျမ် အတီဝ ယထာရ္ထံ ကထယာမိ ယော နရော မဒီယံ ဝါစံ မနျတေ သ ကဒါစန နိဓနံ န ဒြက္ၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","ယိဟူဒီယာသ္တမဝဒန် တွံ ဘူတဂြသ္တ ဣတီဒါနီမ် အဝဲၐ္မ၊ ဣဗြာဟီမ် ဘဝိၐျဒွါဒိနဉ္စ သရွွေ မၖတား ကိန္တု တွံ ဘာၐသေ ယော နရော မမ ဘာရတီံ ဂၖဟ္လာတိ သ ဇာတု နိဓာနာသွာဒံ န လပ္သျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","တရှိ တွံ ကိမ် အသ္မာကံ ပူရွွပုရုၐာဒ် ဣဗြာဟီမောပိ မဟာန်? ယသ္မာတ် သောပိ မၖတး ဘဝိၐျဒွါဒိနောပိ မၖတား တွံ သွံ ကံ ပုမာံသံ မနုၐေ? ");
INSERT INTO sanbur_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","ယီၑုး ပြတျဝေါစဒ် ယဒျဟံ သွံ သွယံ သမ္မနျေ တရှိ မမ တတ် သမ္မနနံ ကိမပိ န ကိန္တု မမ တာတော ယံ ယူယံ သွီယမ် ဤၑွရံ ဘာၐဓွေ သဧဝ မာံ သမ္မနုတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ယူယံ တံ နာဝဂစ္ဆထ ကိန္တွဟံ တမဝဂစ္ဆာမိ တံ နာဝဂစ္ဆာမီတိ ဝါကျံ ယဒိ ဝဒါမိ တရှိ ယူယမိဝ မၖၐာဘာၐီ ဘဝါမိ ကိန္တွဟံ တမဝဂစ္ဆာမိ တဒါက္ၐာမပိ ဂၖဟ္လာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","ယုၐ္မာကံ ပူရွွပုရုၐ ဣဗြာဟီမ် မမ သမယံ ဒြၐ္ဋုမ် အတီဝါဝါဉ္ဆတ် တန္နိရီက္ၐျာနန္ဒစ္စ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","တဒါ ယိဟူဒီယာ အပၖစ္ဆန် တဝ ဝယး ပဉ္စာၑဒွတ္သရာ န တွံ ကိမ် ဣဗြာဟီမမ် အဒြာက္ၐီး? ");
INSERT INTO sanbur_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","ယီၑုး ပြတျဝါဒီဒ် ယုၐ္မာနဟံ ယထာရ္ထတရံ ဝဒါမိ ဣဗြာဟီမော ဇန္မနး ပူရွွကာလမာရဘျာဟံ ဝိဒျေ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","တဒါ တေ ပါၐာဏာန် ဥတ္တောလျ တမာဟန္တုမ် ဥဒယစ္ဆန် ကိန္တု ယီၑု ရ္ဂုပ္တော မန္တိရာဒ် ဗဟိရ္ဂတျ တေၐာံ မဓျေန ပြသ္ထိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","တတး ပရံ ယီၑုရ္ဂစ္ဆန် မာရ္ဂမဓျေ ဇန္မာန္ဓံ နရမ် အပၑျတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","တတး ၑိၐျာသ္တမ် အပၖစ္ဆန် ဟေ ဂုရော နရောယံ သွပါပေန ဝါ သွပိတြား ပါပေနာန္ဓော'ဇာယတ? ");
INSERT INTO sanbur_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","တတး သ ပြတျုဒိတဝါန် ဧတသျ ဝါသျ ပိတြေား ပါပါဒ် ဧတာဒၖၑောဘူဒ ဣတိ နဟိ ကိန္တွနေန ယထေၑွရသျ ကရ္မ္မ ပြကာၑျတေ တဒ္ဓေတောရေဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","ဒိနေ တိၐ္ဌတိ မတ္ပြေရယိတုး ကရ္မ္မ မယာ ကရ္တ္တဝျံ ယဒါ ကိမပိ ကရ္မ္မ န ကြိယတေ တာဒၖၑီ နိၑာဂစ္ဆတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","အဟံ ယာဝတ္ကာလံ ဇဂတိ တိၐ္ဌာမိ တာဝတ္ကာလံ ဇဂတော ဇျောတိးသွရူပေါသ္မိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ဣတျုက္တ္တာ ဘူမော် နိၐ္ဌီဝံ နိက္ၐိပျ တေန ပင်္ကံ ကၖတဝါန္ ");
INSERT INTO sanbur_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ပၑ္စာတ် တတ္ပင်္ကေန တသျာန္ဓသျ နေတြေ ပြလိပျ တမိတျာဒိၑတ် ဂတွာ ၑိလောဟေ 'ရ္ထာတ် ပြေရိတနာမ္နိ သရသိ သ္နာဟိ၊ တတောန္ဓော ဂတွာ တတြာသ္နာတ် တတး ပြန္နစက္ၐု ရ္ဘူတွာ ဝျာဃုဋျာဂါတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","အပရဉ္စ သမီပဝါသိနော လောကာ ယေ စ တံ ပူရွွမန္ဓမ် အပၑျန် တေ ဗက္တ္တုမ် အာရဘန္တ ယောန္ဓလောကော ဝရ္တ္မနျုပဝိၑျာဘိက္ၐတ သ ဧဝါယံ ဇနး ကိံ န ဘဝတိ? ");
INSERT INTO sanbur_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","ကေစိဒဝဒန် သ ဧဝ ကေစိဒဝေါစန် တာဒၖၑော ဘဝတိ ကိန္တု သ သွယမဗြဝီတ် သ ဧဝါဟံ ဘဝါမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","အတဧဝ တေ 'ပၖစ္ဆန် တွံ ကထံ ဒၖၐ္ဋိံ ပါပ္တဝါန်? ");
INSERT INTO sanbur_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","တတး သောဝဒဒ် ယီၑနာမက ဧကော ဇနော မမ နယနေ ပင်္ကေန ပြလိပျ ဣတျာဇ္ဉာပယတ် ၑိလောဟကာသာရံ ဂတွာ တတြ သ္နာဟိ၊ တတသ္တတြ ဂတွာ မယိ သ္နာတေ ဒၖၐ္ဋိမဟံ လဗ္ဓဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","တဒါ တေ 'ဝဒန် သ ပုမာန် ကုတြ? တေနောက္တ္တံ နာဟံ ဇာနာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","အပရံ တသ္မိန် ပူရွွာန္ဓေ ဇနေ ဖိရူၑိနာံ နိကဋမ် အာနီတေ သတိ ဖိရူၑိနောပိ တမပၖစ္ဆန် ကထံ ဒၖၐ္ဋိံ ပြာပ္တောသိ? ");
INSERT INTO sanbur_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","တတး သ ကထိတဝါန် သ ပင်္ကေန မမ နေတြေ 'လိမ္ပတ် ပၑ္စာဒ် သ္နာတွာ ဒၖၐ္ဋိမလဘေ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","ကိန္တု ယီၑု ရွိၑြာမဝါရေ ကရ္ဒ္ဒမံ ကၖတွာ တသျ နယနေ ပြသန္နေ'ကရောဒ် ဣတိကာရဏာတ် ကတိပယဖိရူၑိနော'ဝဒန္ ");
INSERT INTO sanbur_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","သ ပုမာန် ဤၑွရာန္န ယတး သ ဝိၑြာမဝါရံ န မနျတေ၊ တတောနျေ ကေစိတ် ပြတျဝဒန် ပါပီ ပုမာန် ကိမ် ဧတာဒၖၑမ် အာၑ္စရျျံ ကရ္မ္မ ကရ္တ္တုံ ၑက္နောတိ? ");
INSERT INTO sanbur_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ဣတ္ထံ တေၐာံ ပရသ္ပရံ ဘိန္နဝါကျတွမ် အဘဝတ်၊ ပၑ္စာတ် တေ ပုနရပိ တံ ပူရွွာန္ဓံ မာနုၐမ် အပြာက္ၐုး ယော ဇနသ္တဝ စက္ၐုၐီ ပြသန္နေ ကၖတဝါန် တသ္မိန် တွံ ကိံ ဝဒသိ? သ ဥက္တ္တဝါန် သ ဘဝိၑဒွါဒီ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","သ ဒၖၐ္ဋိမ် အာပ္တဝါန် ဣတိ ယိဟူဒီယာသ္တသျ ဒၖၐ္ဋိံ ပြာပ္တသျ ဇနသျ ပိတြော ရ္မုခါဒ် အၑြုတွာ န ပြတျယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","အတဧဝ တေ တာဝပၖစ္ဆန် ယုဝယော ရျံ ပုတြံ ဇန္မာန္ဓံ ဝဒထး သ ကိမယံ? တရှီဒါနီံ ကထံ ဒြၐ္ဋုံ ၑက္နောတိ? ");
INSERT INTO sanbur_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","တတသ္တသျ ပိတရော် ပြတျဝေါစတာမ် အယမ် အာဝယေား ပုတြ အာ ဇနေရန္ဓၑ္စ တဒပျာဝါံ ဇာနီဝး ");
INSERT INTO sanbur_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ကိန္တွဓုနာ ကထံ ဒၖၐ္ဋိံ ပြာပ္တဝါန် တဒါဝါံ န် ဇာနီဝး ကောသျ စက္ၐုၐီ ပြသန္နေ ကၖတဝါန် တဒပိ န ဇာနီဝ ဧၐ ဝယးပြာပ္တ ဧနံ ပၖစ္ဆတ သွကထာံ သွယံ ဝက္ၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ယိဟူဒီယာနာံ ဘယာတ် တသျ ပိတရော် ဝါကျမိဒမ် အဝဒတာံ ယတး ကောပိ မနုၐျော ယဒိ ယီၑုမ် အဘိၐိက္တံ ဝဒတိ တရှိ သ ဘဇနဂၖဟာဒ် ဒူရီကာရိၐျတေ ယိဟူဒီယာ ဣတိ မန္တြဏာမ် အကုရွွန္ ");
INSERT INTO sanbur_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","အတသ္တသျ ပိတရော် ဝျာဟရတာမ် ဧၐ ဝယးပြာပ္တ ဧနံ ပၖစ္ဆတ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","တဒါ တေ ပုနၑ္စ တံ ပူရွွာန္ဓမ် အာဟူယ ဝျာဟရန် ဤၑွရသျ ဂုဏာန် ဝဒ ဧၐ မနုၐျး ပါပီတိ ဝယံ ဇာနီမး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","တဒါ သ ဥက္တ္တဝါန် သ ပါပီ န ဝေတိ နာဟံ ဇာနေ ပူရွာမန္ဓ အာသမဟမ် အဓုနာ ပၑျာမီတိ မာတြံ ဇာနာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","တေ ပုနရပၖစ္ဆန် သ တွာံ ပြတိ ကိမကရောတ်? ကထံ နေတြေ ပြသန္နေ 'ကရောတ်? ");
INSERT INTO sanbur_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","တတး သောဝါဒီဒ် ဧကကၖတွောကထယံ ယူယံ န ၑၖဏုထ တရှိ ကုတး ပုနး ၑြောတုမ် ဣစ္ဆထ? ယူယမပိ ကိံ တသျ ၑိၐျာ ဘဝိတုမ် ဣစ္ဆထ? ");
INSERT INTO sanbur_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","တဒါ တေ တံ တိရသ္ကၖတျ ဝျာဟရန် တွံ တသျ ၑိၐျော ဝယံ မူသား ၑိၐျား၊ ");
INSERT INTO sanbur_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","မူသာဝက္တြေဏေၑွရော ဇဂါဒ တဇ္ဇာနီမး ကိန္တွေၐ ကုတြတျလောက ဣတိ န ဇာနီမး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","သောဝဒဒ် ဧၐ မမ လောစနေ ပြသန္နေ 'ကရောတ် တထာပိ ကုတြတျလောက ဣတိ ယူယံ န ဇာနီထ ဧတဒ် အာၑ္စရျျံ ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ဤၑွရး ပါပိနာံ ကထာံ န ၑၖဏောတိ ကိန္တု ယော ဇနသ္တသ္မိန် ဘက္တိံ ကၖတွာ တဒိၐ္ဋကြိယာံ ကရောတိ တသျဲဝ ကထာံ ၑၖဏောတိ ဧတဒ် ဝယံ ဇာနီမး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","ကောပိ မနုၐျော ဇန္မာန္ဓာယ စက္ၐုၐီ အဒဒါတ် ဇဂဒါရမ္ဘာဒ် ဧတာဒၖၑီံ ကထာံ ကောပိ ကဒါပိ နာၑၖဏောတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","အသ္မာဒ် ဧၐ မနုၐျော ယဒီၑွရာန္နာဇာယတ တရှိ ကိဉ္စိဒပီဒၖၑံ ကရ္မ္မ ကရ္တ္တုံ နာၑက္နောတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","တေ ဝျာဟရန် တွံ ပါပါဒ် အဇာယထား ကိမသ္မာန် တွံ ၑိက္ၐယသိ? ပၑ္စာတ္တေ တံ ဗဟိရကုရွွန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","တဒနန္တရံ ယိဟူဒီယဲး သ ဗဟိရကြိယတ ယီၑုရိတိ ဝါရ္တ္တာံ ၑြုတွာ တံ သာက္ၐာတ် ပြာပျ ပၖၐ္ဋဝါန် ဤၑွရသျ ပုတြေ တွံ ဝိၑွသိၐိ? ");
INSERT INTO sanbur_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","တဒါ သ ပြတျဝေါစတ် ဟေ ပြဘော သ ကော ယတ် တသ္မိန္နဟံ ဝိၑွသိမိ? ");
INSERT INTO sanbur_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","တတော ယီၑုး ကထိတဝါန် တွံ တံ ဒၖၐ္ဋဝါန် တွယာ သာကံ ယး ကထံ ကထယတိ သဧဝ သး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","တဒါ ဟေ ပြဘော ဝိၑွသိမီတျုက္တွာ သ တံ ပြဏာမတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","ပၑ္စာဒ် ယီၑုး ကထိတဝါန် နယနဟီနာ နယနာနိ ပြာပ္နုဝန္တိ နယနဝန္တၑ္စာန္ဓာ ဘဝန္တီတျဘိပြာယေဏ ဇဂဒါဟမ် အာဂစ္ဆမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ဧတတ် ၑြုတွာ နိကဋသ္ထား ကတိပယား ဖိရူၑိနော ဝျာဟရန် ဝယမပိ ကိမန္ဓား? ");
INSERT INTO sanbur_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","တဒါ ယီၑုရဝါဒီဒ် ယဒျန္ဓာ အဘဝတ တရှိ ပါပါနိ နာတိၐ္ဌန် ကိန္တု ပၑျာမီတိ ဝါကျဝဒနာဒ် ယုၐ္မာကံ ပါပါနိ တိၐ္ဌန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","အဟံ ယုၐ္မာနတိယထာရ္ထံ ဝဒါမိ, ယော ဇနော ဒွါရေဏ န ပြဝိၑျ ကေနာပျနျေန မေၐဂၖဟံ ပြဝိၑတိ သ ဧဝ သ္တေနော ဒသျုၑ္စ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","ယော ဒွါရေဏ ပြဝိၑတိ သ ဧဝ မေၐပါလကး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ဒေါ်ဝါရိကသ္တသ္မဲ ဒွါရံ မောစယတိ မေၐဂဏၑ္စ တသျ ဝါကျံ ၑၖဏောတိ သ နိဇာန် မေၐာန် သွသွနာမ္နာဟူယ ဗဟိး ကၖတွာ နယတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","တထာ နိဇာန် မေၐာန် ဗဟိး ကၖတွာ သွယံ တေၐာမ် အဂြေ ဂစ္ဆတိ, တတော မေၐာသ္တသျ ၑဗ္ဒံ ဗုဓျန္တေ, တသ္မာတ် တသျ ပၑ္စာဒ် ဝြဇန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","ကိန္တု ပရသျ ၑဗ္ဒံ န ဗုဓျန္တေ တသ္မာတ် တသျ ပၑ္စာဒ် ဝြဇိၐျန္တိ ဝရံ တသျ သမီပါတ် ပလာယိၐျန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","ယီၑုသ္တေဘျ ဣမာံ ဒၖၐ္ဋာန္တကထာမ် အကထယတ် ကိန္တု တေန ကထိတကထာယာသ္တာတ္ပရျျံ တေ နာဗုဓျန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","အတော ယီၑုး ပုနရကထယတ်, ယုၐ္မာနာဟံ ယထာရ္ထတရံ ဝျာဟရာမိ, မေၐဂၖဟသျ ဒွါရမ် အဟမေဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","မယာ န ပြဝိၑျ ယ အာဂစ္ဆန် တေ သ္တေနာ ဒသျဝၑ္စ ကိန္တု မေၐာသ္တေၐာံ ကထာ နာၑၖဏွန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","အဟမေဝ ဒွါရသွရူပး, မယာ ယး ကၑ္စိတ ပြဝိၑတိ သ ရက္ၐာံ ပြာပ္သျတိ တထာ ဗဟိရန္တၑ္စ ဂမနာဂမနေ ကၖတွာ စရဏသ္ထာနံ ပြာပ္သျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","ယော ဇနသ္တေနး သ ကေဝလံ သ္တဲနျဗဓဝိနာၑာန် ကရ္တ္တုမေဝ သမာယာတိ ကိန္တွဟမ် အာယု ရ္ဒာတုမ် အရ္ထာတ် ဗာဟူလျေန တဒေဝ ဒါတုမ် အာဂစ္ဆမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","အဟမေဝ သတျမေၐပါလကော ယသ္တု သတျော မေၐပါလကး သ မေၐာရ္ထံ ပြာဏတျာဂံ ကရောတိ; ");
INSERT INTO sanbur_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","ကိန္တု ယော ဇနော မေၐပါလကော န, အရ္ထာဒ် ယသျ မေၐာ နိဇာ န ဘဝန္တိ, ယ ဧတာဒၖၑော ဝဲတနိကး သ ဝၖကမ် အာဂစ္ဆန္တံ ဒၖၐ္ဋွာ မေဇဝြဇံ ဝိဟာယ ပလာယတေ, တသ္မာဒ် ဝၖကသ္တံ ဝြဇံ ဓၖတွာ ဝိကိရတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ဝဲတနိကး ပလာယတေ ယတး သ ဝေတနာရ္ထီ မေၐာရ္ထံ န စိန္တယတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","အဟမေဝ သတျော မေၐပါလကး, ပိတာ မာံ ယထာ ဇာနာတိ, အဟဉ္စ ယထာ ပိတရံ ဇာနာမိ, ");
INSERT INTO sanbur_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","တထာ နိဇာန် မေၐာနပိ ဇာနာမိ, မေၐာၑ္စ မာံ ဇာနာန္တိ, အဟဉ္စ မေၐာရ္ထံ ပြာဏတျာဂံ ကရောမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","အပရဉ္စ ဧတဒ် ဂၖဟီယ မေၐေဘျော ဘိန္နာ အပိ မေၐာ မမ သန္တိ တေ သကလာ အာနယိတဝျား; တေ မမ ၑဗ္ဒံ ၑြောၐျန္တိ တတ ဧကော ဝြဇ ဧကော ရက္ၐကော ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","ပြာဏာနဟံ တျက္တွာ ပုနး ပြာဏာန် ဂြဟီၐျာမိ, တသ္မာတ် ပိတာ မယိ သ္နေဟံ ကရောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","ကၑ္စိဇ္ဇနော မမ ပြာဏာန် ဟန္တုံ န ၑက္နောတိ ကိန္တု သွယံ တာန် သမရ္ပယာမိ တာန် သမရ္ပယိတုံ ပုနရ္ဂြဟီတုဉ္စ မမ ၑက္တိရာသ္တေ ဘာရမိမံ သွပိတုး သကာၑာတ် ပြာပ္တောဟမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","အသ္မာဒုပဒေၑာတ် ပုနၑ္စ ယိဟူဒီယာနာံ မဓျေ ဘိန္နဝါကျတာ ဇာတာ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","တတော ဗဟဝေါ ဝျာဟရန် ဧၐ ဘူတဂြသ္တ ဥန္မတ္တၑ္စ, ကုတ ဧတသျ ကထာံ ၑၖဏုထ? ");
INSERT INTO sanbur_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","ကေစိဒ် အဝဒန် ဧတသျ ကထာ ဘူတဂြသ္တသျ ကထာဝန္န ဘဝန္တိ, ဘူတး ကိမ် အန္ဓာယ စက္ၐုၐီ ဒါတုံ ၑက္နောတိ? ");
INSERT INTO sanbur_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","ၑီတကာလေ ယိရူၑာလမိ မန္ဒိရောတ္သရ္ဂပရွွဏျုပသ္ထိတေ ");
INSERT INTO sanbur_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ယီၑုး သုလေမာနော နိးသာရေဏ ဂမနာဂမနေ ကရောတိ, ");
INSERT INTO sanbur_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ဧတသ္မိန် သမယေ ယိဟူဒီယာသ္တံ ဝေၐ္ဋယိတွာ ဝျာဟရန် ကတိ ကာလာန် အသ္မာကံ ဝိစိကိတ္သာံ သ္ထာပယိၐျာမိ? ယဒျဘိၐိက္တော ဘဝတိ တရှိ တတ် သ္ပၐ္ဋံ ဝဒ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","တဒါ ယီၑုး ပြတျဝဒဒ် အဟမ် အစကထံ ကိန္တု ယူယံ န ပြတီထ, နိဇပိတု ရ္နာမ္နာ ယာံ ယာံ ကြိယာံ ကရောမိ သာ ကြိယဲဝ မမ သာက္ၐိသွရူပါ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ကိန္တွဟံ ပူရွွမကထယံ ယူယံ မမ မေၐာ န ဘဝထ, ကာရဏာဒသ္မာန် န ဝိၑွသိထ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","မမ မေၐာ မမ ၑဗ္ဒံ ၑၖဏွန္တိ တာနဟံ ဇာနာမိ တေ စ မမ ပၑ္စာဒ် ဂစ္ဆန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","အဟံ တေဘျော'နန္တာယု ရ္ဒဒါမိ, တေ ကဒါပိ န နံက္ၐျန္တိ ကောပိ မမ ကရာတ် တာန် ဟရ္တ္တုံ န ၑက္ၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","ယော မမ ပိတာ တာန် မဟျံ ဒတ္တဝါန် သ သရွွသ္မာတ် မဟာန်, ကောပိ မမ ပိတုး ကရာတ် တာန် ဟရ္တ္တုံ န ၑက္ၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","အဟံ ပိတာ စ ဒွယောရေကတွမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","တတော ယိဟူဒီယား ပုနရပိ တံ ဟန္တုံ ပါၐာဏာန် ဥဒတောလယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ယီၑုး ကထိတဝါန် ပိတုး သကာၑာဒ် ဗဟူနျုတ္တမကရ္မ္မာဏိ ယုၐ္မာကံ ပြာကာၑယံ တေၐာံ ကသျ ကရ္မ္မဏး ကာရဏာန် မာံ ပါၐာဏဲရာဟန္တုမ် ဥဒျတား သ္ထ? ");
INSERT INTO sanbur_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","ယိဟူဒီယား ပြတျဝဒန် ပြၑသ္တကရ္မ္မဟေတော ရ္န ကိန္တု တွံ မာနုၐး သွမီၑွရမ် ဥက္တွေၑွရံ နိန္ဒသိ ကာရဏာဒသ္မာတ် တွာံ ပါၐာဏဲရှန္မး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","တဒါ ယီၑုး ပြတျုက္တဝါန် မယာ ကထိတံ ယူယမ် ဤၑွရာ ဧတဒွစနံ ယုၐ္မာကံ ၑာသ္တြေ လိခိတံ နာသ္တိ ကိံ? ");
INSERT INTO sanbur_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","တသ္မာဒ် ယေၐာမ် ဥဒ္ဒေၑေ ဤၑွရသျ ကထာ ကထိတာ တေ ယဒီၑွရဂဏာ ဥစျန္တေ ဓရ္မ္မဂြန္ထသျာပျနျထာ ဘဝိတုံ န ၑကျံ, ");
INSERT INTO sanbur_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","တရှျာဟမ် ဤၑွရသျ ပုတြ ဣတိ ဝါကျသျ ကထနာတ် ယူယံ ပိတြာဘိၐိက္တံ ဇဂတိ ပြေရိတဉ္စ ပုမာံသံ ကထမ် ဤၑွရနိန္ဒကံ ဝါဒယ? ");
INSERT INTO sanbur_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","ယဒျဟံ ပိတုး ကရ္မ္မ န ကရောမိ တရှိ မာံ န ပြတီတ; ");
INSERT INTO sanbur_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","ကိန္တု ယဒိ ကရောမိ တရှိ မယိ ယုၐ္မာဘိး ပြတျယေ န ကၖတေ'ပိ ကာရျျေ ပြတျယး ကြိယတာံ, တတော မယိ ပိတာသ္တီတိ ပိတရျျဟမ် အသ္မီတိ စ က္ၐာတွာ ဝိၑွသိၐျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","တဒါ တေ ပုနရပိ တံ ဓရ္တ္တုမ် အစေၐ္ဋန္တ ကိန္တု သ တေၐာံ ကရေဘျော နိသ္တီရျျ ");
INSERT INTO sanbur_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ပုန ရျရ္ဒ္ဒန် အဒျာသ္တဋေ ယတြ ပုရွွံ ယောဟန် အမဇ္ဇယတ် တတြာဂတျ နျဝသတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","တတော ဗဟဝေါ လောကာသ္တတ္သမီပမ် အာဂတျ ဝျာဟရန် ယောဟန် ကိမပျာၑ္စရျျံ ကရ္မ္မ နာကရောတ် ကိန္တွသ္မိန် မနုၐျေ ယာ ယး ကထာ အကထယတ် တား သရွွား သတျား; ");
INSERT INTO sanbur_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","တတြ စ ဗဟဝေါ လောကာသ္တသ္မိန် ဝျၑွသန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","အနန္တရံ မရိယမ် တသျာ ဘဂိနီ မရ္ထာ စ ယသ္မိန် ဝဲထနီယာဂြာမေ ဝသတသ္တသ္မိန် ဂြာမေ ဣလိယာသရ် နာမာ ပီဍိတ ဧက အာသီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ယာ မရိယမ် ပြဘုံ သုဂန္ဓိတေလဲန မရ္ဒ္ဒယိတွာ သွကေၑဲသ္တသျ စရဏော် သမမာရ္ဇတ် တသျာ ဘြာတာ သ ဣလိယာသရ် ရောဂီ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","အပရဉ္စ ဟေ ပြဘော ဘဝါန် ယသ္မိန် ပြီယတေ သ ဧဝ ပီဍိတောသ္တီတိ ကထာံ ကထယိတွာ တသျ ဘဂိနျော် ပြေၐိတဝတျော်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","တဒါ ယီၑုရိမာံ ဝါရ္တ္တာံ ၑြုတွာကထယတ ပီဍေယံ မရဏာရ္ထံ န ကိန္တွီၑွရသျ မဟိမာရ္ထမ် ဤၑွရပုတြသျ မဟိမပြကာၑာရ္ထဉ္စ ဇာတာ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","ယီၑု ရျဒျပိမရ္ထာယာံ တဒ္ဘဂိနျာမ် ဣလိယာသရိ စာပြီယတ, ");
INSERT INTO sanbur_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","တထာပိ ဣလိယာသရး ပီဍာယား ကထံ ၑြုတွာ ယတြ အာသီတ် တတြဲဝ ဒိနဒွယမတိၐ္ဌတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","တတး ပရမ် သ ၑိၐျာနကထယဒ် ဝယံ ပုန ရျိဟူဒီယပြဒေၑံ ယာမး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","တတသ္တေ ပြတျဝဒန်, ဟေ ဂုရော သွလ္ပဒိနာနိ ဂတာနိ ယိဟူဒီယာသ္တွာံ ပါၐာဏဲ ရှန္တုမ် ဥဒျတာသ္တထာပိ ကိံ ပုနသ္တတြ ယာသျသိ? ");
INSERT INTO sanbur_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","ယီၑုး ပြတျဝဒတ်, ဧကသ္မိန် ဒိနေ ကိံ ဒွါဒၑဃဋိကာ န ဘဝန္တိ? ကောပိ ဒိဝါ ဂစ္ဆန် န သ္ခလတိ ယတး သ ဧတဇ္ဇဂတော ဒီပ္တိံ ပြာပ္နောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","ကိန္တု ရာတြော် ဂစ္ဆန် သ္ခလတိ ယတော ဟေတောသ္တတြ ဒီပ္တိ ရ္နာသ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ဣမာံ ကထာံ ကထယိတွာ သ တာနဝဒဒ်, အသ္မာကံ ဗန္ဓုး ဣလိယာသရ် နိဒြိတောဘူဒ် ဣဒါနီံ တံ နိဒြာတော ဇာဂရယိတုံ ဂစ္ဆာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","ယီၑု ရ္မၖတော် ကထာမိမာံ ကထိတဝါန် ကိန္တု ဝိၑြာမာရ္ထံ နိဒြာယာံ ကထိတဝါန် ဣတိ ဇ္ဉာတွာ ၑိၐျာ အကထယန်, ");
INSERT INTO sanbur_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","ဟေ ဂုရော သ ယဒိ နိဒြာတိ တရှိ ဘဒြမေဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","တဒါ ယီၑုး သ္ပၐ္ဋံ တာန် ဝျာဟရတ်, ဣလိယာသရ် အမြိယတ; ");
INSERT INTO sanbur_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ကိန္တု ယူယံ ယထာ ပြတီထ တဒရ္ထမဟံ တတြ န သ္ထိတဝါန် ဣတျသ္မာဒ် ယုၐ္မန္နိမိတ္တမ် အာဟ္လာဒိတောဟံ, တထာပိ တသျ သမီပေ ယာမ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","တဒါ ထောမာ ယံ ဒိဒုမံ ဝဒန္တိ သ သင်္ဂိနး ၑိၐျာန် အဝဒဒ် ဝယမပိ ဂတွာ တေန သာရ္ဒ္ဓံ မြိယာမဟဲ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","ယီၑုသ္တတြောပသ္ထာယ ဣလိယာသရး ၑ္မၑာနေ သ္ထာပနာတ် စတွာရိ ဒိနာနိ ဂတာနီတိ ဝါရ္တ္တာံ ၑြုတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","ဝဲထနီယာ ယိရူၑာလမး သမီပသ္ထာ ကြောၑဲကမာတြာန္တရိတာ; ");
INSERT INTO sanbur_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","တသ္မာဒ် ဗဟဝေါ ယိဟူဒီယာ မရ္ထာံ မရိယမဉ္စ ဘျာတၖၑောကာပန္နာံ သာန္တွယိတုံ တယေား သမီပမ် အာဂစ္ဆန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","မရ္ထာ ယီၑောရာဂမနဝါရ္တာံ ၑြုတွဲဝ တံ သာက္ၐာဒ် အကရောတ် ကိန္တု မရိယမ် ဂေဟ ဥပဝိၑျ သ္ထိတာ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","တဒါ မရ္ထာ ယီၑုမဝါဒတ်, ဟေ ပြဘော ယဒိ ဘဝါန် အတြာသ္ထာသျတ် တရှိ မမ ဘြာတာ နာမရိၐျတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","ကိန္တွိဒါနီမပိ ယဒ် ဤၑွရေ ပြာရ္ထယိၐျတေ ဤၑွရသ္တဒ် ဒါသျတီတိ ဇာနေ'ဟံ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","ယီၑုရဝါဒီတ် တဝ ဘြာတာ သမုတ္ထာသျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","မရ္ထာ ဝျာဟရတ် ၑေၐဒိဝသေ သ ဥတ္ထာနသမယေ ပြောတ္ထာသျတီတိ ဇာနေ'ဟံ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","တဒါ ယီၑုး ကထိတဝါန် အဟမေဝ ဥတ္ထာပယိတာ ဇီဝယိတာ စ ယး ကၑ္စန မယိ ဝိၑွသိတိ သ မၖတွာပိ ဇီဝိၐျတိ; ");
INSERT INTO sanbur_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ယး ကၑ္စန စ ဇီဝန် မယိ ဝိၑွသိတိ သ ကဒါပိ န မရိၐျတိ, အသျာံ ကထာယာံ ကိံ ဝိၑွသိၐိ? ");
INSERT INTO sanbur_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","သာဝဒတ် ပြဘော ယသျာဝတရဏာပေက္ၐာသ္တိ ဘဝါန် သဧဝါဘိၐိက္တ္တ ဤၑွရပုတြ ဣတိ ဝိၑွသိမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ဣတိ ကထာံ ကထယိတွာ သာ ဂတွာ သွာံ ဘဂိနီံ မရိယမံ ဂုပ္တမာဟူယ ဝျာဟရတ် ဂုရုရုပတိၐ္ဌတိ တွာမာဟူယတိ စ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","ကထာမိမာံ ၑြုတွာ သာ တူရ္ဏမ် ဥတ္ထာယ တသျ သမီပမ် အဂစ္ဆတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ယီၑု ရ္ဂြာမမဓျံ န ပြဝိၑျ ယတြ မရ္ထာ တံ သာက္ၐာဒ် အကရောတ် တတြ သ္ထိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","ယေ ယိဟူဒီယာ မရိယမာ သာကံ ဂၖဟေ တိၐ္ဌန္တသ္တာမ် အသာန္တွယန တေ တာံ က္ၐိပြမ် ဥတ္ထာယ ဂစ္ဆန္တိံ ဝိလောကျ ဝျာဟရန်, သ ၑ္မၑာနေ ရောဒိတုံ ယာတိ, ဣတျုက္တွာ တေ တသျား ပၑ္စာဒ် အဂစ္ဆန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","ယတြ ယီၑုရတိၐ္ဌတ် တတြ မရိယမ် ဥပသ္ထာယ တံ ဒၖၐ္ဋွာ တသျ စရဏယေား ပတိတွာ ဝျာဟရတ် ဟေ ပြဘော ယဒိ ဘဝါန် အတြာသ္ထာသျတ် တရှိ မမ ဘြာတာ နာမရိၐျတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","ယီၑုသ္တာံ တသျား သင်္ဂိနော ယိဟူဒီယာံၑ္စ ရုဒတော ဝိလောကျ ၑောကာရ္တ္တး သန် ဒီရ္ဃံ နိၑွသျ ကထိတဝါန် တံ ကုတြာသ္ထာပယတ? ");
INSERT INTO sanbur_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","တေ ဝျာဟရန်, ဟေ ပြဘော ဘဝါန် အာဂတျ ပၑျတု၊ ");
INSERT INTO sanbur_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","ယီၑုနာ ကြန္ဒိတံ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","အတဧဝ ယိဟူဒီယာ အဝဒန်, ပၑျတာယံ တသ္မိန် ကိဒၖဂ် အပြိယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","တေၐာံ ကေစိဒ် အဝဒန် ယောန္ဓာယ စက္ၐုၐီ ဒတ္တဝါန် သ ကိမ် အသျ မၖတျုံ နိဝါရယိတုံ နာၑက္နောတ်? ");
INSERT INTO sanbur_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","တတော ယီၑုး ပုနရန္တရ္ဒီရ္ဃံ နိၑွသျ ၑ္မၑာနာန္တိကမ် အဂစ္ဆတ်၊ တတ် ၑ္မၑာနမ် ဧကံ ဂဟွရံ တန္မုခေ ပါၐာဏ ဧက အာသီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","တဒါ ယီၑုရဝဒဒ် ဧနံ ပါၐာဏမ် အပသာရယတ, တတး ပြမီတသျ ဘဂိနီ မရ္ထာဝဒတ် ပြဘော, အဓုနာ တတြ ဒုရ္ဂန္ဓော ဇာတး, ယတောဒျ စတွာရိ ဒိနာနိ ၑ္မၑာနေ သ တိၐ္ဌတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","တဒါ ယီၑုရဝါဒီတ်, ယဒိ ဝိၑွသိၐိ တရှီၑွရသျ မဟိမပြကာၑံ ဒြက္ၐျသိ ကထာမိမာံ ကိံ တုဘျံ နာကထယံ? ");
INSERT INTO sanbur_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","တဒါ မၖတသျ ၑ္မၑာနာတ် ပါၐာဏော'ပသာရိတေ ယီၑုရူရ္ဒွွံ ပၑျန် အကထယတ်, ဟေ ပိတ ရ္မမ နေဝေသနမ် အၑၖဏေား ကာရဏာဒသ္မာတ် တွာံ ဓနျံ ဝဒါမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","တွံ သတတံ ၑၖဏောၐိ တဒပျဟံ ဇာနာမိ, ကိန္တု တွံ မာံ ယတ် ပြဲရယသ္တဒ် ယထာသ္မိန် သ္ထာနေ သ္ထိတာ လောကာ ဝိၑွသန္တိ တဒရ္ထမ် ဣဒံ ဝါကျံ ဝဒါမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ဣမာံ ကထာံ ကထယိတွာ သ ပြောစ္စဲရာဟွယတ်, ဟေ ဣလိယာသရ် ဗဟိရာဂစ္ဆ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","တတး သ ပြမီတး ၑ္မၑာနဝသ္တြဲ ရ္ဗဒ္ဓဟသ္တပါဒေါ ဂါတြမာရ္ဇနဝါသသာ ဗဒ္ဓမုခၑ္စ ဗဟိရာဂစ္ဆတ်၊ ယီၑုရုဒိတဝါန် ဗန္ဓနာနိ မောစယိတွာ တျဇတဲနံ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","မရိယမး သမီပမ် အာဂတာ ယေ ယိဟူဒီယလောကာသ္တဒါ ယီၑောရေတတ် ကရ္မ္မာပၑျန် တေၐာံ ဗဟဝေါ ဝျၑွသန်, ");
INSERT INTO sanbur_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","ကိန္တု ကေစိဒနျေ ဖိရူၑိနာံ သမီပံ ဂတွာ ယီၑောရေတသျ ကရ္မ္မဏော ဝါရ္တ္တာမ် အဝဒန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","တတး ပရံ ပြဓာနယာဇကား ဖိရူၑိနာၑ္စ သဘာံ ကၖတွာ ဝျာဟရန် ဝယံ ကိံ ကုရ္မ္မး? ဧၐ မာနဝေါ ဗဟူနျာၑ္စရျျကရ္မ္မာဏိ ကရောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","ယဒီဒၖၑံ ကရ္မ္မ ကရ္တ္တုံ န ဝါရယာမသ္တရှိ သရွွေ လောကာသ္တသ္မိန် ဝိၑွသိၐျန္တိ ရောမိလောကာၑ္စာဂတျာသ္မာကမ် အနယာ ရာဇဓာနျာ သာရ္ဒ္ဓံ ရာဇျမ် အာဆေတ္သျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","တဒါ တေၐာံ ကိယဖာနာမာ ယသ္တသ္မိန် ဝတ္သရေ မဟာယာဇကပဒေ နျယုဇျတ သ ပြတျဝဒဒ် ယူယံ ကိမပိ န ဇာနီထ; ");
INSERT INTO sanbur_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","သမဂြဒေၑသျ ဝိနာၑတောပိ သရွွလောကာရ္ထမ် ဧကသျ ဇနသျ မရဏမ် အသ္မာကံ မင်္ဂလဟေတုကမ် ဧတသျ ဝိဝေစနာမပိ န ကုရုထ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","ဧတာံ ကထာံ သ နိဇဗုဒ္ဓျာ ဝျာဟရဒ် ဣတိ န, ");
INSERT INTO sanbur_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ကိန္တု ယီၑူသ္တဒ္ဒေၑီယာနာံ ကာရဏာတ် ပြာဏာန် တျက္ၐျတိ, ဒိၑိ ဒိၑိ ဝိကီရ္ဏာန် ဤၑွရသျ သန္တာနာန် သံဂၖဟျဲကဇာတိံ ကရိၐျတိ စ, တသ္မိန် ဝတ္သရေ ကိယဖာ မဟာယာဇကတွပဒေ နိယုက္တး သန် ဣဒံ ဘဝိၐျဒွါကျံ ကထိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","တဒ္ဒိနမာရဘျ တေ ကထံ တံ ဟန္တုံ ၑက္နုဝန္တီတိ မန္တြဏာံ ကရ္တ္တုံ ပြာရေဘိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","အတဧဝ ယိဟူဒီယာနာံ မဓျေ ယီၑုး သပြကာၑံ ဂမနာဂမနေ အကၖတွာ တသ္မာဒ် ဂတွာ ပြာန္တရသျ သမီပသ္ထာယိပြဒေၑသျေဖြာယိမ် နာမ္နိ နဂရေ ၑိၐျဲး သာကံ ကာလံ ယာပယိတုံ ပြာရေဘေ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","အနန္တရံ ယိဟူဒီယာနာံ နိသ္တာရောတ္သဝေ နိကဋဝရ္တ္တိနိ သတိ တဒုတ္သဝါတ် ပူရွွံ သွာန် ၑုစီန် ကရ္တ္တုံ ဗဟဝေါ ဇနာ ဂြာမေဘျော ယိရူၑာလမ် နဂရမ် အာဂစ္ဆန်, ");
INSERT INTO sanbur_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ယီၑောရနွေၐဏံ ကၖတွာ မန္ဒိရေ ဒဏ္ဍာယမာနား သန္တး ပရသ္ပရံ ဝျာဟရန်, ယုၐ္မာကံ ကီဒၖၑော ဗောဓော ဇာယတေ? သ ကိမ် ဥတ္သဝေ'သ္မိန် အတြာဂမိၐျတိ? ");
INSERT INTO sanbur_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","သ စ ကုတြာသ္တိ ယဒျေတတ် ကၑ္စိဒ် ဝေတ္တိ တရှိ ဒရ္ၑယတု ပြဓာနယာဇကား ဖိရူၑိနၑ္စ တံ ဓရ္တ္တုံ ပူရွွမ် ဣမာမ် အာဇ္ဉာံ ပြာစာရယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","နိသ္တာရောတ္သဝါတ် ပူရွွံ ဒိနၐဋ္ကေ သ္ထိတေ ယီၑု ရျံ ပြမီတမ် ဣလိယာသရံ ၑ္မၑာနာဒ် ဥဒသ္ထာပရတ် တသျ နိဝါသသ္ထာနံ ဗဲထနိယာဂြာမမ် အာဂစ္ဆတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","တတြ တဒရ္ထံ ရဇနျာံ ဘောဇျေ ကၖတေ မရ္ထာ ပရျျဝေၐယဒ် ဣလိယာသရ် စ တသျ သင်္ဂိဘိး သာရ္ဒ္ဓံ ဘောဇနာသန ဥပါဝိၑတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","တဒါ မရိယမ် အရ္ဒ္ဓသေဋကံ ဗဟုမူလျံ ဇဋာမာံသီယံ တဲလမ် အာနီယ ယီၑောၑ္စရဏယော ရ္မရ္ဒ္ဒယိတွာ နိဇကေၑ ရ္မာရ္ၐ္ဋုမ် အာရဘတ; တဒါ တဲလသျ ပရိမလေန ဂၖဟမ် အာမောဒိတမ် အဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ယး ၑိမောနး ပုတြ ရိၐ္ကရိယောတီယော ယိဟူဒါနာမာ ယီၑုံ ပရကရေၐု သမရ္ပယိၐျတိ သ ၑိၐျသ္တဒါ ကထိတဝါန်, ");
INSERT INTO sanbur_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","ဧတတ္တဲလံ တြိဘိး ၑတဲ ရ္မုဒြာပဒဲ ရွိကြီတံ သဒ် ဒရိဒြေဘျး ကုတော နာဒီယတ? ");
INSERT INTO sanbur_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","သ ဒရိဒြလောကာရ္ထမ် အစိန္တယဒ် ဣတိ န, ကိန္တု သ စော်ရ ဧဝံ တန္နိကဋေ မုဒြာသမ္ပုဋကသ္ထိတျာ တန္မဓျေ ယဒတိၐ္ဌတ် တဒပါဟရတ် တသ္မာတ် ကာရဏာဒ် ဣမာံ ကထာမကထယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","တဒါ ယီၑုရကထယဒ် ဧနာံ မာ ဝါရယ သာ မမ ၑ္မၑာနသ္ထာပနဒိနာရ္ထံ တဒရက္ၐယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","ဒရိဒြာ ယုၐ္မာကံ သန္နိဓော် သရွွဒါ တိၐ္ဌန္တိ ကိန္တွဟံ သရွွဒါ ယုၐ္မာကံ သန္နိဓော် န တိၐ္ဌာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","တတး ပရံ ယီၑုသ္တတြာသ္တီတိ ဝါရ္တ္တာံ ၑြုတွာ ဗဟဝေါ ယိဟူဒီယာသ္တံ ၑ္မၑာနာဒုတ္ထာပိတမ် ဣလိယာသရဉ္စ ဒြၐ္ဋုံ တတ် သ္ထာနမ် အာဂစ္ဆန၊ ");
INSERT INTO sanbur_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","တဒါ ပြဓာနယာဇကာသ္တမ် ဣလိယာသရမပိ သံဟရ္တ္တုမ် အမန္တြယန် ; ");
INSERT INTO sanbur_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ယတသ္တေန ဗဟဝေါ ယိဟူဒီယာ ဂတွာ ယီၑော် ဝျၑွသန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","အနန္တရံ ယီၑု ရျိရူၑာလမ် နဂရမ် အာဂစ္ဆတီတိ ဝါရ္တ္တာံ ၑြုတွာ ပရေ'ဟနိ ဥတ္သဝါဂတာ ဗဟဝေါ လောကား ");
INSERT INTO sanbur_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ခရ္ဇ္ဇူရပတြာဒျာနီယ တံ သာက္ၐာတ် ကရ္တ္တုံ ဗဟိရာဂတျ ဇယ ဇယေတိ ဝါစံ ပြောစ္စဲ ရွက္တုမ် အာရဘန္တ, ဣသြာယေလော ယော ရာဇာ ပရမေၑွရသျ နာမ္နာဂစ္ဆတိ သ ဓနျး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","တဒါ \"ဟေ သိယောနး ကနျေ မာ ဘဲၐီး ပၑျာယံ တဝ ရာဇာ ဂရ္ဒ္ဒဘၑာဝကမ် အာရုဟျာဂစ္ဆတိ\" ");
INSERT INTO sanbur_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","ဣတိ ၑာသ္တြီယဝစနာနုသာရေဏ ယီၑုရေကံ ယုဝဂရ္ဒ္ဒဘံ ပြာပျ တဒုပရျျာရောဟတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","အသျား ဃဋနာယာသ္တာတ္ပရျျံ ၑိၐျား ပြထမံ နာဗုဓျန္တ, ကိန္တု ယီၑော် မဟိမာနံ ပြာပ္တေ သတိ ဝါကျမိဒံ တသ္မိန အကထျတ လောကာၑ္စ တမ္ပြတီတ္ထမ် အကုရွွန် ဣတိ တေ သ္မၖတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","သ ဣလိယာသရံ ၑ္မၑာနာဒ် အာဂန္တုမ် အာဟွတဝါန် ၑ္မၑာနာဉ္စ ဥဒသ္ထာပယဒ် ယေ ယေ လောကာသ္တတ္ကရ္မျ သာက္ၐာဒ် အပၑျန် တေ ပြမာဏံ ဒါတုမ် အာရဘန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","သ ဧတာဒၖၑမ် အဒ္ဘုတံ ကရ္မ္မကရောတ် တသျ ဇနၑြုတေ ရ္လောကာသ္တံ သာက္ၐာတ် ကရ္တ္တုမ် အာဂစ္ဆန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","တတး ဖိရူၑိနး ပရသ္ပရံ ဝက္တုမ် အာရဘန္တ ယုၐ္မာကံ သရွွာၑ္စေၐ္ဋာ ဝၖထာ ဇာတား, ဣတိ ကိံ ယူယံ န ဗုဓျဓွေ? ပၑျတ သရွွေ လောကာသ္တသျ ပၑ္စာဒွရ္တ္တိနောဘဝန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ဘဇနံ ကရ္တ္တုမ် ဥတ္သဝါဂတာနာံ လောကာနာံ ကတိပယာ ဇနာ အနျဒေၑီယာ အာသန် , ");
INSERT INTO sanbur_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","တေ ဂါလီလီယဗဲတ္သဲဒါနိဝါသိနး ဖိလိပသျ သမီပမ် အာဂတျ ဝျာဟရန် ဟေ မဟေစ္ဆ ဝယံ ယီၑုံ ဒြၐ္ဋုမ် ဣစ္ဆာမး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","တတး ဖိလိပေါ ဂတွာ အာန္ဒြိယမ် အဝဒတ် ပၑ္စာဒ် အာန္ဒြိယဖိလိပေါ် ယီၑဝေ ဝါရ္တ္တာမ် အကထယတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","တဒါ ယီၑုး ပြတျုဒိတဝါန် မာနဝသုတသျ မဟိမပြာပ္တိသမယ ဥပသ္ထိတး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","အဟံ ယုၐ္မာနတိယထာရ္ထံ ဝဒါမိ, ဓာနျဗီဇံ မၖတ္တိကာယာံ ပတိတွာ ယဒိ န မၖယတေ တရှျေကာကီ တိၐ္ဌတိ ကိန္တု ယဒိ မၖယတေ တရှိ ဗဟုဂုဏံ ဖလံ ဖလတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","ယော ဇနေा နိဇပြာဏာန် ပြိယာန် ဇာနာတိ သ တာန် ဟာရယိၐျတိ ကိန္တု ယေा ဇန ဣဟလောကေ နိဇပြာဏာန် အပြိယာန် ဇာနာတိ သေाနန္တာယုး ပြာပ္တုံ တာန် ရက္ၐိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","ကၑ္စိဒ် ယဒိ မမ သေဝကော ဘဝိတုံ ဝါဉ္ဆတိ တရှိ သ မမ ပၑ္စာဒ္ဂါမီ ဘဝတု, တသ္မာဒ် အဟံ ယတြ တိၐ္ဌာမိ မမ သေဝကေाပိ တတြ သ္ထာသျတိ; ယော ဇနော မာံ သေဝတေ မမ ပိတာပိ တံ သမ္မံသျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","သာမ္ပြတံ မမ ပြာဏာ ဝျာကုလာ ဘဝန္တိ, တသ္မာဒ် ဟေ ပိတရ ဧတသ္မာတ် သမယာန် မာံ ရက္ၐ, ဣတျဟံ ကိံ ပြာရ္ထယိၐျေ? ကိန္တွဟမ် ဧတတ္သမယာရ္ထမ် အဝတီရ္ဏဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ဟေ ပိတ: သွနာမ္နော မဟိမာနံ ပြကာၑယ; တနဲဝ သွနာမ္နော မဟိမာနမ် အဟံ ပြာကာၑယံ ပုနရပိ ပြကာၑယိၐျာမိ, ဧၐာ ဂဂဏီယာ ဝါဏီ တသ္မိန် သမယေ'ဇာယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","တစ္ၑြုတွာ သမီပသ္ထလောကာနာံ ကေစိဒ် အဝဒန် မေဃော'ဂရ္ဇီတ်, ကေစိဒ် အဝဒန် သွရ္ဂီယဒူတော'နေန သဟ ကထာမစကထတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","တဒါ ယီၑုး ပြတျဝါဒီတ်, မဒရ္ထံ ၑဗ္ဒောယံ နာဘူတ် ယုၐ္မဒရ္ထမေဝါဘူတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","အဓုနာ ဇဂတောသျ ဝိစာရ: သမ္ပတ္သျတေ, အဓုနာသျ ဇဂတ: ပတီ ရာဇျာတ် စျောၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","ယဒျဤ ပၖထိဝျာ ဦရ္ဒွွေ ပြောတ္ထာပိတောသ္မိ တရှိ သရွွာန် မာနဝါန် သွသမီပမ် အာကရ္ၐိၐျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","ကထံ တသျ မၖတိ ရ္ဘဝိၐျတိ, ဧတဒ် ဗောဓယိတုံ သ ဣမာံ ကထာမ် အကထယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","တဒါ လောကာ အကထယန် သောဘိၐိက္တး သရွွဒါ တိၐ္ဌတီတိ ဝျဝသ္ထာဂြန္ထေ ၑြုတမ် အသ္မာဘိး, တရှိ မနုၐျပုတြး ပြောတ္ထာပိတော ဘဝိၐျတီတိ ဝါကျံ ကထံ ဝဒသိ? မနုၐျပုတြောယံ ကး? ");
INSERT INTO sanbur_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","တဒါ ယီၑုရကထာယဒ် ယုၐ္မာဘိး သာရ္ဒ္ဓမ် အလ္ပဒိနာနိ ဇျောတိရာသ္တေ, ယထာ ယုၐ္မာန် အန္ဓကာရော နာစ္ဆာဒယတိ တဒရ္ထံ ယာဝတ္ကာလံ ယုၐ္မာဘိး သာရ္ဒ္ဓံ ဇျောတိသ္တိၐ္ဌတိ တာဝတ္ကာလံ ဂစ္ဆတ; ယော ဇနော'န္ဓကာရေ ဂစ္ဆတိ သ ကုတြ ယာတီတိ န ဇာနာတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","အတဧဝ ယာဝတ္ကာလံ ယုၐ္မာကံ နိကဋေ ဇျောတိရာသ္တေ တာဝတ္ကာလံ ဇျောတီရူပသန္တာနာ ဘဝိတုံ ဇျောတိၐိ ဝိၑွသိတ; ဣမာံ ကထာံ ကထယိတွာ ယီၑုး ပြသ္ထာယ တေဘျး သွံ ဂုပ္တဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","ယဒျပိ ယီၑုသ္တေၐာံ သမက္ၐမ် ဧတာဝဒါၑ္စရျျကရ္မ္မာဏိ ကၖတဝါန် တထာပိ တေ တသ္မိန် န ဝျၑွသန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","အတဧဝ ကး ပြတျေတိ သုသံဝါဒံ ပရေၑာသ္မတ် ပြစာရိတံ? ပြကာၑတေ ပရေၑသျ ဟသ္တး ကသျ စ သန္နိဓော်? ယိၑယိယဘဝိၐျဒွါဒိနာ ယဒေတဒ် ဝါကျမုက္တံ တတ် သဖလမ် အဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","တေ ပြတျေတုံ နာၑန္ကုဝန် တသ္မိန် ယိၑယိယဘဝိၐျဒွါဒိ ပုနရဝါဒီဒ်, ");
INSERT INTO sanbur_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","ယဒါ, \"တေ နယနဲ ရ္န ပၑျန္တိ ဗုဒ္ဓိဘိၑ္စ န ဗုဓျန္တေ တဲ ရ္မနးသု ပရိဝရ္တ္တိတေၐု စ တာနဟံ ယထာ သွသ္ထာန် န ကရောမိ တထာ သ တေၐာံ လောစနာနျန္ဓာနိ ကၖတွာ တေၐာမန္တးကရဏာနိ ဂါဎာနိ ကရိၐျတိ၊ \" ");
INSERT INTO sanbur_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","ယိၑယိယော ယဒါ ယီၑော ရ္မဟိမာနံ ဝိလောကျ တသ္မိန် ကထာမကထယတ် တဒါ ဘဝိၐျဒွါကျမ် ဤဒၖၑံ ပြကာၑယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","တထာပျဓိပတိနာံ ဗဟဝသ္တသ္မိန် ပြတျာယန်၊ ကိန္တု ဖိရူၑိနသ္တာန် ဘဇနဂၖဟာဒ် ဒူရီကုရွွန္တီတိ ဘယာတ် တေ တံ န သွီကၖတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ယတ ဤၑွရသျ ပြၑံသာတော မာနဝါနာံ ပြၑံသာယာံ တေ'ပြိယန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","တဒါ ယီၑုရုစ္စဲးကာရမ် အကထယဒ် ယော ဇနော မယိ ဝိၑွသိတိ သ ကေဝလေ မယိ ဝိၑွသိတီတိ န, သ မတ္ပြေရကေ'ပိ ဝိၑွသိတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ယော ဇနော မာံ ပၑျတိ သ မတ္ပြေရကမပိ ပၑျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","ယော ဇနော မာံ ပြတျေတိ သ ယထာန္ဓကာရေ န တိၐ္ဌတိ တဒရ္ထမ် အဟံ ဇျောတိးသွရူပေါ ဘူတွာ ဇဂတျသ္မိန် အဝတီရ္ဏဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","မမ ကထာံ ၑြုတွာ ယဒိ ကၑ္စိန် န ဝိၑွသိတိ တရှိ တမဟံ ဒေါၐိဏံ န ကရောမိ, ယတော ဟေတော ရ္ဇဂတော ဇနာနာံ ဒေါၐာန် နိၑ္စိတာန် ကရ္တ္တုံ နာဂတျ တာန် ပရိစာတုမ် အာဂတောသ္မိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ယး ကၑ္စိန် မာံ န ၑြဒ္ဓါယ မမ ကထံ န ဂၖဟ္လာတိ, အနျသ္တံ ဒေါၐိဏံ ကရိၐျတိ ဝသ္တုတသ္တု ယာံ ကထာမဟမ် အစကထံ သာ ကထာ စရမေ'နှိ တံ ဒေါၐိဏံ ကရိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","ယတော ဟေတောရဟံ သွတး ကိမပိ န ကထယာမိ, ကိံ ကိံ မယာ ကထယိတဝျံ ကိံ သမုပဒေၐ္ဋဝျဉ္စ ဣတိ မတ္ပြေရယိတာ ပိတာ မာမာဇ္ဉာပယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","တသျ သာဇ္ဉာ အနန္တာယုရိတျဟံ ဇာနာမိ, အတဧဝါဟံ ယတ် ကထယာမိ တတ် ပိတာ ယထာဇ္ဉာပယတ် တထဲဝ ကထယာမျဟမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","နိသ္တာရောတ္သဝသျ ကိဉ္စိတ္ကာလာတ် ပူရွွံ ပၖထိဝျား ပိတုး သမီပဂမနသျ သမယး သန္နိကရ္ၐောဘူဒ် ဣတိ ဇ္ဉာတွာ ယီၑုရာပြထမာဒ် ယေၐု ဇဂတ္ပြဝါသိၐွာတ္မီယလောကေၐ ပြေမ ကရောတိ သ္မ တေၐု ၑေၐံ ယာဝတ် ပြေမ ကၖတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","ပိတာ တသျ ဟသ္တေ သရွွံ သမရ္ပိတဝါန် သွယမ် ဤၑွရသျ သမီပါဒ် အာဂစ္ဆဒ် ဤၑွရသျ သမီပံ ယာသျတိ စ, သရွွာဏျေတာနိ ဇ္ဉာတွာ ရဇနျာံ ဘောဇနေ သမ္ပူရ္ဏေ သတိ, ");
INSERT INTO sanbur_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ယဒါ ၑဲတာန် တံ ပရဟသ္တေၐု သမရ္ပယိတုံ ၑိမောနး ပုတြသျ ဤၐ္ကာရိယောတိယသျ ယိဟူဒါ အန္တးကရဏေ ကုပြဝၖတ္တိံ သမာရ္ပယတ်, ");
INSERT INTO sanbur_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","တဒါ ယီၑု ရ္ဘောဇနာသနာဒ် ဥတ္ထာယ ဂါတြဝသ္တြံ မောစယိတွာ ဂါတြမာရ္ဇနဝသ္တြံ ဂၖဟီတွာ တေန သွကဋိမ် အဗဓ္နာတ်, ");
INSERT INTO sanbur_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ပၑ္စာဒ် ဧကပါတြေ ဇလမ် အဘိၐိစျ ၑိၐျာဏာံ ပါဒါန် ပြက္ၐာလျ တေန ကဋိဗဒ္ဓဂါတြမာရ္ဇနဝါသသာ မာရ္ၐ္ဋုံ ပြာရဘတ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","တတး ၑိမောန္ပိတရသျ သမီပမာဂတေ သ ဥက္တဝါန် ဟေ ပြဘော ဘဝါန် ကိံ မမ ပါဒေါ် ပြက္ၐာလယိၐျတိ? ");
INSERT INTO sanbur_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","ယီၑုရုဒိတဝါန် အဟံ ယတ် ကရောမိ တတ် သမ္ပြတိ န ဇာနာသိ ကိန္တု ပၑ္စာဇ် ဇ္ဉာသျသိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","တတး ပိတရး ကထိတဝါန် ဘဝါန် ကဒါပိ မမ ပါဒေါ် န ပြက္ၐာလယိၐျတိ၊ ယီၑုရကထယဒ် ယဒိ တွာံ န ပြက္ၐာလယေ တရှိ မယိ တဝ ကောပျံၑော နာသ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","တဒါ ၑိမောန္ပိတရး ကထိတဝါန် ဟေ ပြဘော တရှိ ကေဝလပါဒေါ် န, မမ ဟသ္တော် ၑိရၑ္စ ပြက္ၐာလယတု၊ ");
INSERT INTO sanbur_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","တတော ယီၑုရဝဒဒ် ယော ဇနော ဓော်တသ္တသျ သရွွာင်္ဂပရိၐ္ကၖတတွာတ် ပါဒေါ် ဝိနာနျာင်္ဂသျ ပြက္ၐာလနာပေက္ၐာ နာသ္တိ၊ ယူယံ ပရိၐ္ကၖတာ ဣတိ သတျံ ကိန္တု န သရွွေ, ");
INSERT INTO sanbur_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","ယတော ယော ဇနသ္တံ ပရကရေၐု သမရ္ပယိၐျတိ တံ သ ဇ္ဉာတဝါန; အတဧဝ ယူယံ သရွွေ န ပရိၐ္ကၖတာ ဣမာံ ကထာံ ကထိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ဣတ္ထံ ယီၑုသ္တေၐာံ ပါဒါန် ပြက္ၐာလျ ဝသ္တြံ ပရိဓာယာသနေ သမုပဝိၑျ ကထိတဝါန် အဟံ ယုၐ္မာန် ပြတိ ကိံ ကရ္မ္မာကာရ္ၐံ ဇာနီထ? ");
INSERT INTO sanbur_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","ယူယံ မာံ ဂုရုံ ပြဘုဉ္စ ဝဒထ တတ် သတျမေဝ ဝဒထ ယတောဟံ သဧဝ ဘဝါမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ယဒျဟံ ပြဘု ရ္ဂုရုၑ္စ သန် ယုၐ္မာကံ ပါဒါန် ပြက္ၐာလိတဝါန် တရှိ ယုၐ္မာကမပိ ပရသ္ပရံ ပါဒပြက္ၐာလနမ် ဥစိတမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","အဟံ ယုၐ္မာန် ပြတိ ယထာ ဝျဝါဟရံ ယုၐ္မာန် တထာ ဝျဝဟရ္တ္တုမ် ဧကံ ပန္ထာနံ ဒရ္ၑိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","အဟံ ယုၐ္မာနတိယထာရ္ထံ ဝဒါမိ, ပြဘော ရ္ဒာသော န မဟာန် ပြေရကာစ္စ ပြေရိတော န မဟာန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ဣမာံ ကထာံ ဝိဒိတွာ ယဒိ တဒနုသာရတး ကရ္မ္မာဏိ ကုရုထ တရှိ ယူယံ ဓနျာ ဘဝိၐျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","သရွွေၐု ယုၐ္မာသု ကထာမိမာံ ကထယာမိ ဣတိ န, ယေ မမ မနောနီတာသ္တာနဟံ ဇာနာမိ, ကိန္တု မမ ဘက္ၐျာဏိ ယော ဘုင်္က္တေ မတ္ပြာဏပြာတိကူလျတး၊ ဥတ္ထာပယတိ ပါဒသျ မူလံ သ ဧၐ မာနဝး၊ ယဒေတဒ် ဓရ္မ္မပုသ္တကသျ ဝစနံ တဒနုသာရေဏာဝၑျံ ဃဋိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","အဟံ သ ဇန ဣတျတြ ယထာ ယုၐ္မာကံ ဝိၑွာသော ဇာယတေ တဒရ္ထံ ဧတာဒၖၑဃဋနာတ် ပူရွွမ် အဟမိဒါနီံ ယုၐ္မဘျမကထယမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","အဟံ ယုၐ္မာနတီဝ ယထာရ္ထံ ဝဒါမိ, မယာ ပြေရိတံ ဇနံ ယော ဂၖဟ္လာတိ သ မာမေဝ ဂၖဟ္လာတိ ယၑ္စ မာံ ဂၖဟ္လာတိ သ မတ္ပြေရကံ ဂၖဟ္လာတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ဧတာံ ကထာံ ကထယိတွာ ယီၑု ရ္ဒုးခီ သန် ပြမာဏံ ဒတ္တွာ ကထိတဝါန် အဟံ ယုၐ္မာနတိယထာရ္ထံ ဝဒါမိ ယုၐ္မာကမ် ဧကော ဇနော မာံ ပရကရေၐု သမရ္ပယိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","တတး သ ကမုဒ္ဒိၑျ ကထာမေတာံ ကထိတဝါန် ဣတျတြ သန္ဒိဂ္ဓား ၑိၐျား ပရသ္ပရံ မုခမာလောကယိတုံ ပြာရဘန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","တသ္မိန် သမယေ ယီၑု ရျသ္မိန် အပြီယတ သ ၑိၐျသ္တသျ ဝက္ၐးသ္ထလမ် အဝါလမ္ဗတ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ၑိမောန္ပိတရသ္တံ သင်္ကေတေနာဝဒတ်, အယံ ကမုဒ္ဒိၑျ ကထာမေတာမ် ကထယတီတိ ပၖစ္ဆ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","တဒါ သ ယီၑော ရွက္ၐးသ္ထလမ် အဝလမ္ဗျ ပၖၐ္ဌဝါန်, ဟေ ပြဘော သ ဇနး ကး? ");
INSERT INTO sanbur_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","တတော ယီၑုး ပြတျဝဒဒ် ဧကခဏ္ဍံ ပူပံ မဇ္ဇယိတွာ ယသ္မဲ ဒါသျာမိ သဧဝ သး; ပၑ္စာတ် ပူပခဏ္ဍမေကံ မဇ္ဇယိတွာ ၑိမောနး ပုတြာယ ဤၐ္ကရိယောတီယာယ ယိဟူဒဲ ဒတ္တဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","တသ္မိန် ဒတ္တေ သတိ ၑဲတာန် တမာၑြယတ်; တဒါ ယီၑုသ္တမ် အဝဒတ် တွံ ယတ် ကရိၐျသိ တတ် က္ၐိပြံ ကုရု၊ ");
INSERT INTO sanbur_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","ကိန္တု သ ယေနာၑယေန တာံ ကထာမကထာယတ် တမ် ဥပဝိၐ္ဋလောကာနာံ ကောပိ နာဗုဓျတ; ");
INSERT INTO sanbur_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ကိန္တု ယိဟူဒါး သမီပေ မုဒြာသမ္ပုဋကသ္ထိတေး ကေစိဒ် ဣတ္ထမ် အဗုဓျန္တ ပါရွွဏာသာဒနာရ္ထံ ကိမပိ ဒြဝျံ ကြေတုံ ဝါ ဒရိဒြေဘျး ကိဉ္စိဒ် ဝိတရိတုံ ကထိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","တဒါ ပူပခဏ္ဍဂြဟဏာတ် ပရံ သ တူရ္ဏံ ဗဟိရဂစ္ဆတ်; ရာတြိၑ္စ သမုပသျိတာ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","ယိဟူဒေ ဗဟိရ္ဂတေ ယီၑုရကထယဒ် ဣဒါနီံ မာနဝသုတသျ မဟိမာ ပြကာၑတေ တေနေၑွရသျာပိ မဟိမာ ပြကာၑတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ယဒိ တေနေၑွရသျ မဟိမာ ပြကာၑတေ တရှီၑွရောပိ သွေန တသျ မဟိမာနံ ပြကာၑယိၐျတိ တူရ္ဏမေဝ ပြကာၑယိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ဟေ ဝတ္သာ အဟံ ယုၐ္မာဘိး သာရ္ဒ္ဓံ ကိဉ္စိတ္ကာလမာတြမ် အာသေ, တတး ပရံ မာံ မၖဂယိၐျဓွေ ကိန္တွဟံ ယတ္သ္ထာနံ ယာမိ တတ္သ္ထာနံ ယူယံ ဂန္တုံ န ၑက္ၐျထ, ယာမိမာံ ကထာံ ယိဟူဒီယေဘျး ကထိတဝါန် တထာဓုနာ ယုၐ္မဘျမပိ ကထယာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","ယူယံ ပရသ္ပရံ ပြီယဓွမ် အဟံ ယုၐ္မာသု ယထာ ပြီယေ ယူယမပိ ပရသ္ပရမ် တထဲဝ ပြီယဓွံ, ယုၐ္မာန် ဣမာံ နဝီနာမ် အာဇ္ဉာမ် အာဒိၑာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","တေနဲဝ ယဒိ ပရသ္ပရံ ပြီယဓွေ တရှိ လက္ၐဏေနာနေန ယူယံ မမ ၑိၐျာ ဣတိ သရွွေ ဇ္ဉာတုံ ၑက္ၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ၑိမောနပိတရး ပၖၐ္ဌဝါန် ဟေ ပြဘော ဘဝါန် ကုတြ ယာသျတိ? တတော ယီၑုး ပြတျဝဒတ်, အဟံ ယတ္သ္ထာနံ ယာမိ တတ္သ္ထာနံ သာမ္ပြတံ မမ ပၑ္စာဒ် ဂန္တုံ န ၑက္နောၐိ ကိန္တု ပၑ္စာဒ် ဂမိၐျသိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","တဒါ ပိတရး ပြတျုဒိတဝါန်, ဟေ ပြဘော သာမ္ပြတံ ကုတော ဟေတောသ္တဝ ပၑ္စာဒ် ဂန္တုံ န ၑက္နောမိ? တွဒရ္ထံ ပြာဏာန် ဒါတုံ ၑက္နောမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","တတော ယီၑုး ပြတျုက္တဝါန် မန္နိမိတ္တံ ကိံ ပြာဏာန် ဒါတုံ ၑက္နောၐိ? တွာမဟံ ယထာရ္ထံ ဝဒါမိ, ကုက္ကုဋရဝဏာတ် ပူရွွံ တွံ တြိ ရ္မာမ် အပဟ္နောၐျသေ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","မနောဒုးခိနော မာ ဘူတ; ဤၑွရေ ဝိၑွသိတ မယိ စ ဝိၑွသိတ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","မမ ပိတု ဂၖဟေ ဗဟူနိ ဝါသသ္ထာနိ သန္တိ နော စေတ် ပူရွွံ ယုၐ္မာန် အဇ္ဉာပယိၐျံ ယုၐ္မဒရ္ထံ သ္ထာနံ သဇ္ဇယိတုံ ဂစ္ဆာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","ယဒိ ဂတွာဟံ ယုၐ္မန္နိမိတ္တံ သ္ထာနံ သဇ္ဇယာမိ တရှိ ပနရာဂတျ ယုၐ္မာန် သွသမီပံ နေၐျာမိ, တတော ယတြာဟံ တိၐ္ဌာမိ တတြ ယူယမပိ သ္ထာသျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","အဟံ ယတ္သ္ထာနံ ဗြဇာမိ တတ္သ္ထာနံ ယူယံ ဇာနီထ တသျ ပန္ထာနမပိ ဇာနီထ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","တဒါ ထောမာ အဝဒတ်, ဟေ ပြဘော ဘဝါန် ကုတြ ယာတိ တဒွယံ န ဇာနီမး, တရှိ ကထံ ပန္ထာနံ ဇ္ဉာတုံ ၑက္နုမး? ");
INSERT INTO sanbur_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","ယီၑုရကထယဒ် အဟမေဝ သတျဇီဝနရူပပထော မယာ န ဂန္တာ ကောပိ ပိတုး သမီပံ ဂန္တုံ န ၑက္နောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","ယဒိ မာမ် အဇ္ဉာသျတ တရှိ မမ ပိတရမပျဇ္ဉာသျတ ကိန္တွဓုနာတသ္တံ ဇာနီထ ပၑျထ စ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","တဒါ ဖိလိပး ကထိတဝါန်, ဟေ ပြဘော ပိတရံ ဒရ္ၑယ တသ္မာဒသ္မာကံ ယထေၐ္ဋံ ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","တတော ယီၑုး ပြတျာဝါဒီတ်, ဟေ ဖိလိပ ယုၐ္မာဘိး သာရ္ဒ္ဓမ် ဧတာဝဒ္ဒိနာနိ သ္ထိတမပိ မာံ ကိံ န ပြတျဘိဇာနာသိ? ယော ဇနော မာမ် အပၑျတ် သ ပိတရမပျပၑျတ် တရှိ ပိတရမ် အသ္မာန် ဒရ္ၑယေတိ ကထာံ ကထံ ကထယသိ? ");
INSERT INTO sanbur_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","အဟံ ပိတရိ တိၐ္ဌာမိ ပိတာ မယိ တိၐ္ဌတီတိ ကိံ တွံ န ပြတျၐိ? အဟံ ယဒွါကျံ ဝဒါမိ တတ် သွတော န ဝဒါမိ ကိန္တု ယး ပိတာ မယိ ဝိရာဇတေ သ ဧဝ သရွွကရ္မ္မာဏိ ကရာတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","အတဧဝ ပိတရျျဟံ တိၐ္ဌာမိ ပိတာ စ မယိ တိၐ္ဌတိ မမာသျာံ ကထာယာံ ပြတျယံ ကုရုတ, နော စေတ် ကရ္မ္မဟေတေား ပြတျယံ ကုရုတ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","အဟံ ယုၐ္မာနတိယထာရ္ထံ ဝဒါမိ, ယော ဇနော မယိ ဝိၑွသိတိ သောဟမိဝ ကရ္မ္မာဏိ ကရိၐျတိ ဝရံ တတောပိ မဟာကရ္မ္မာဏိ ကရိၐျတိ ယတော ဟေတောရဟံ ပိတုး သမီပံ ဂစ္ဆာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","ယထာ ပုတြေဏ ပိတု ရ္မဟိမာ ပြကာၑတေ တဒရ္ထံ မမ နာမ ပြောစျ ယတ် ပြာရ္ထယိၐျဓွေ တတ် သဖလံ ကရိၐျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","ယဒိ မမ နာမ္နာ ယတ် ကိဉ္စိဒ် ယာစဓွေ တရှိ တဒဟံ သာဓယိၐျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","ယဒိ မယိ ပြီယဓွေ တရှိ မမာဇ္ဉား သမာစရတ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","တတော မယာ ပိတုး သမီပေ ပြာရ္ထိတေ ပိတာ နိရန္တရံ ယုၐ္မာဘိး သာရ္ဒ္ဓံ သ္ထာတုမ် ဣတရမေကံ သဟာယမ် အရ္ထာတ် သတျမယမ် အာတ္မာနံ ယုၐ္မာကံ နိကဋံ ပြေၐယိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ဧတဇ္ဇဂတော လောကာသ္တံ ဂြဟီတုံ န ၑက္နုဝန္တိ ယတသ္တေ တံ နာပၑျန် နာဇနံၑ္စ ကိန္တု ယူယံ ဇာနီထ ယတော ဟေတေား သ ယုၐ္မာကမန္တ ရ္နိဝသတိ ယုၐ္မာကံ မဓျေ သ္ထာသျတိ စ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","အဟံ ယုၐ္မာန် အနာထာန် ကၖတွာ န ယာသျာမိ ပုနရပိ ယုၐ္မာကံ သမီပမ် အာဂမိၐျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ကိယတ္ကာလရတ် ပရမ် အသျ ဇဂတော လောကာ မာံ ပုန ရ္န ဒြက္ၐျန္တိ ကိန္တု ယူယံ ဒြက္ၐျထ;အဟံ ဇီဝိၐျာမိ တသ္မာတ် ကာရဏာဒ် ယူယမပိ ဇီဝိၐျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","ပိတရျျဟမသ္မိ မယိ စ ယူယံ သ္ထ, တထာဟံ ယုၐ္မာသွသ္မိ တဒပိ တဒါ ဇ္ဉာသျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","ယော ဇနော မမာဇ္ဉာ ဂၖဟီတွာ တာ အာစရတိ သဧဝ မယိ ပြီယတေ; ယော ဇနၑ္စ မယိ ပြီယတေ သဧဝ မမ ပိတုး ပြိယပါတြံ ဘဝိၐျတိ, တထာဟမပိ တသ္မိန် ပြီတွာ တသ္မဲ သွံ ပြကာၑယိၐျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","တဒါ ဤၐ္ကရိယောတီယာဒ် အနျော ယိဟူဒါသ္တမဝဒတ်, ဟေ ပြဘော ဘဝါန် ဇဂတော လောကာနာံ သန္နိဓော် ပြကာၑိတော န ဘူတွာသ္မာကံ သန္နိဓော် ကုတး ပြကာၑိတော ဘဝိၐျတိ? ");
INSERT INTO sanbur_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","တတော ယီၑုး ပြတျုဒိတဝါန်, ယော ဇနော မယိ ပြီယတေ သ မမာဇ္ဉာ အပိ ဂၖဟ္လာတိ, တေန မမ ပိတာပိ တသ္မိန် ပြေၐျတေ, အာဝါဉ္စ တန္နိကဋမာဂတျ တေန သဟ နိဝတ္သျာဝး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ယော ဇနော မယိ န ပြီယတေ သ မမ ကထာ အပိ န ဂၖဟ္လာတိ ပုနၑ္စ ယာမိမာံ ကထာံ ယူယံ ၑၖဏုထ သာ ကထာ ကေဝလသျ မမ န ကိန္တု မမ ပြေရကော ယး ပိတာ တသျာပိ ကထာ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","ဣဒါနီံ ယုၐ္မာကံ နိကဋေ ဝိဒျမာနောဟမ် ဧတား သကလား ကထား ကထယာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ကိန္တွိတး ပရံ ပိတြာ ယး သဟာယော'ရ္ထာတ် ပဝိတြ အာတ္မာ မမ နာမ္နိ ပြေရယိၐျတိ သ သရွွံ ၑိက္ၐယိတွာ မယောက္တား သမသ္တား ကထာ ယုၐ္မာန် သ္မာရယိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","အဟံ ယုၐ္မာကံ နိကဋေ ၑာန္တိံ သ္ထာပယိတွာ ယာမိ, နိဇာံ ၑာန္တိံ ယုၐ္မဘျံ ဒဒါမိ, ဇဂတော လောကာ ယထာ ဒဒါတိ တထာဟံ န ဒဒါမိ; ယုၐ္မာကမ် အန္တးကရဏာနိ ဒုးခိတာနိ ဘီတာနိ စ န ဘဝန္တု၊ ");
INSERT INTO sanbur_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","အဟံ ဂတွာ ပုနရပိ ယုၐ္မာကံ သမီပမ် အာဂမိၐျာမိ မယောက္တံ ဝါကျမိဒံ ယူယမ် အၑြော်ၐ္ဋ; ယဒိ မယျပြေၐျဓွံ တရှျဟံ ပိတုး သမီပံ ဂစ္ဆာမိ မမာသျာံ ကထာယာံ ယူယမ် အဟ္လာဒိၐျဓွံ ယတော မမ ပိတာ မတ္တောပိ မဟာန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","တသျာ ဃဋနာယား သမယေ ယထာ ယုၐ္မာကံ ၑြဒ္ဓါ ဇာယတေ တဒရ္ထမ် အဟံ တသျာ ဃဋနာယား ပူရွွမ် ဣဒါနီံ ယုၐ္မာန် ဧတာံ ဝါရ္တ္တာံ ဝဒါမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ဣတး ပရံ ယုၐ္မာဘိး သဟ မမ ဗဟဝ အာလာပါ န ဘဝိၐျန္တိ ယတး ကာရဏာဒ် ဧတသျ ဇဂတး ပတိရာဂစ္ဆတိ ကိန္တု မယာ သဟ တသျ ကောပိ သမ္ဗန္ဓော နာသ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","အဟံ ပိတရိ ပြေမ ကရောမိ တထာ ပိတု ရွိဓိဝတ် ကရ္မ္မာဏိ ကရောမီတိ ယေန ဇဂတော လောကာ ဇာနန္တိ တဒရ္ထမ် ဥတ္တိၐ္ဌတ ဝယံ သ္ထာနာဒသ္မာဒ် ဂစ္ဆာမ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","အဟံ သတျဒြာက္ၐာလတာသွရူပေါ မမ ပိတာ တူဒျာနပရိစာရကသွရူပဉ္စ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","မမ ယာသု ၑာခါသု ဖလာနိ န ဘဝန္တိ တား သ ဆိနတ္တိ တထာ ဖလဝတျး ၑာခါ ယထာဓိကဖလာနိ ဖလန္တိ တဒရ္ထံ တား ပရိၐ္ကရောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ဣဒါနီံ မယောက္တောပဒေၑေန ယူယံ ပရိၐ္ကၖတား၊ ");
INSERT INTO sanbur_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","အတး ကာရဏာတ် မယိ တိၐ္ဌတ တေနာဟမပိ ယုၐ္မာသု တိၐ္ဌာမိ, ယတော ဟေတော ရ္ဒြာက္ၐာလတာယာမ် အသံလဂ္နာ ၑာခါ ယထာ ဖလဝတီ ဘဝိတုံ န ၑက္နောတိ တထာ ယူယမပိ မယျတိၐ္ဌန္တး ဖလဝန္တော ဘဝိတုံ န ၑက္နုထ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","အဟံ ဒြာက္ၐာလတာသွရူပေါ ယူယဉ္စ ၑာခါသွရူပေါး; ယော ဇနော မယိ တိၐ္ဌတိ ယတြ စာဟံ တိၐ္ဌာမိ, သ ပြစူရဖလဲး ဖလဝါန် ဘဝတိ, ကိန္တု မာံ ဝိနာ ယူယံ ကိမပိ ကရ္တ္တုံ န ၑက္နုထ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ယး ကၑ္စိန် မယိ န တိၐ္ဌတိ သ ၑုၐ္ကၑာခေဝ ဗဟိ ရ္နိက္ၐိပျတေ လောကာၑ္စ တာ အာဟၖတျ ဝဟ္နော် နိက္ၐိပျ ဒါဟယန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","ယဒိ ယူယံ မယိ တိၐ္ဌထ မမ ကထာ စ ယုၐ္မာသု တိၐ္ဌတိ တရှိ ယဒ် ဝါဉ္ဆိတွာ ယာစိၐျဓွေ ယုၐ္မာကံ တဒေဝ သဖလံ ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","ယဒိ ယူယံ ပြစူရဖလဝန္တော ဘဝထ တရှိ တဒွါရာ မမ ပိတု ရ္မဟိမာ ပြကာၑိၐျတေ တထာ ယူယံ မမ ၑိၐျာ ဣတိ ပရိက္ၐာယိၐျဓွေ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","ပိတာ ယထာ မယိ ပြီတဝါန် အဟမပိ ယုၐ္မာသု တထာ ပြီတဝါန် အတော ဟေတော ရျူယံ နိရန္တရံ မမ ပြေမပါတြာဏိ ဘူတွာ တိၐ္ဌတ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","အဟံ ယထာ ပိတုရာဇ္ဉာ ဂၖဟီတွာ တသျ ပြေမဘာဇနံ တိၐ္ဌာမိ တထဲဝ ယူယမပိ ယဒိ မမာဇ္ဉာ ဂုဟ္လီထ တရှိ မမ ပြေမဘာဇနာနိ သ္ထာသျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","ယုၐ္မန္နိမိတ္တံ မမ ယ အာဟ္လာဒး သ ယထာ စိရံ တိၐ္ဌတိ ယုၐ္မာကမ် အာနန္ဒၑ္စ ယထာ ပူရျျတေ တဒရ္ထံ ယုၐ္မဘျမ် ဧတား ကထာ အတြကထမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","အဟံ ယုၐ္မာသု ယထာ ပြီယေ ယူယမပိ ပရသ္ပရံ တထာ ပြီယဓွမ် ဧၐာ မမာဇ္ဉာ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","မိတြာဏာံ ကာရဏာတ် သွပြာဏဒါနပရျျန္တံ ယတ် ပြေမ တသ္မာန် မဟာပြေမ ကသျာပိ နာသ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","အဟံ ယဒျဒ် အာဒိၑာမိ တတ္တဒေဝ ယဒိ ယူယမ် အာစရတ တရှိ ယူယမေဝ မမ မိတြာဏိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","အဒျာရဘျ ယုၐ္မာန် ဒါသာန် န ဝဒိၐျာမိ ယတ် ပြဘု ရျတ် ကရောတိ ဒါသသ္တဒ် န ဇာနာတိ; ကိန္တု ပိတုး သမီပေ ယဒျဒ် အၑၖဏဝံ တတ် သရွွံ ယူၐ္မာန် အဇ္ဉာပယမ် တတ္ကာရဏာဒ် ယုၐ္မာန် မိတြာဏိ ပြောက္တဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","ယူယံ မာံ ရောစိတဝန္တ ဣတိ န, ကိန္တွဟမေဝ ယုၐ္မာန် ရောစိတဝါန် ယူယံ ဂတွာ ယထာ ဖလာနျုတ္ပာဒယထ တာနိ ဖလာနိ စာက္ၐယာဏိ ဘဝန္တိ, တဒရ္ထံ ယုၐ္မာန် နျဇုနဇံ တသ္မာန် မမ နာမ ပြောစျ ပိတရံ ယတ် ကိဉ္စိဒ် ယာစိၐျဓွေ တဒေဝ သ ယုၐ္မဘျံ ဒါသျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","ယူယံ ပရသ္ပရံ ပြီယဓွမ် အဟမ် ဣတျာဇ္ဉာပယာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","ဇဂတော လောကဲ ရျုၐ္မာသု ၒတီယိတေၐု တေ ပူရွွံ မာမေဝါရ္တ္တီယန္တ ဣတိ ယူယံ ဇာနီထ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","ယဒိ ယူယံ ဇဂတော လောကာ အဘဝိၐျတ တရှိ ဇဂတော လောကာ ယုၐ္မာန် အာတ္မီယာန် ဗုဒ္ဓွာပြေၐျန္တ; ကိန္တု ယူယံ ဇဂတော လောကာ န ဘဝထ, အဟံ ယုၐ္မာန် အသ္မာဇ္ဇဂတော'ရောစယမ် ဧတသ္မာတ် ကာရဏာဇ္ဇဂတော လောကာ ယုၐ္မာန် ၒတီယန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","ဒါသး ပြဘော ရ္မဟာန် န ဘဝတိ မမဲတတ် ပူရွွီယံ ဝါကျံ သ္မရတ; တေ ယဒိ မာမေဝါတာဍယန် တရှိ ယုၐ္မာနပိ တာဍယိၐျန္တိ, ယဒိ မမ ဝါကျံ ဂၖဟ္လန္တိ တရှိ ယုၐ္မာကမပိ ဝါကျံ ဂြဟီၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","ကိန္တု တေ မမ နာမကာရဏာဒ် ယုၐ္မာန် ပြတိ တာဒၖၑံ ဝျဝဟရိၐျန္တိ ယတော ယော မာံ ပြေရိတဝါန် တံ တေ န ဇာနန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","တေၐာံ သန္နိဓိမ် အာဂတျ ယဒျဟံ နာကထယိၐျံ တရှိ တေၐာံ ပါပံ နာဘဝိၐျတ် ကိန္တွဓုနာ တေၐာံ ပါပမာစ္ဆာဒယိတုမ် ဥပါယော နာသ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","ယော ဇနော မာမ် ၒတီယတေ သ မမ ပိတရမပိ ၒတီယတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","ယာဒၖၑာနိ ကရ္မ္မာဏိ ကေနာပိ ကဒါပိ နာကြိယန္တ တာဒၖၑာနိ ကရ္မ္မာဏိ ယဒိ တေၐာံ သာက္ၐာဒ် အဟံ နာကရိၐျံ တရှိ တေၐာံ ပါပံ နာဘဝိၐျတ် ကိန္တွဓုနာ တေ ဒၖၐ္ဋွာပိ မာံ မမ ပိတရဉ္စာရ္တ္တီယန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","တသ္မာတ် တေ'ကာရဏံ မာမ် ၒတီယန္တေ ယဒေတဒ် ဝစနံ တေၐာံ ၑာသ္တြေ လိခိတမာသ္တေ တတ် သဖလမ် အဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","ကိန္တု ပိတု ရ္နိရ္ဂတံ ယံ သဟာယမရ္ထာတ် သတျမယမ် အာတ္မာနံ ပိတုး သမီပါဒ် ယုၐ္မာကံ သမီပေ ပြေၐယိၐျာမိ သ အာဂတျ မယိ ပြမာဏံ ဒါသျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ယူယံ ပြထမမာရဘျ မယာ သာရ္ဒ္ဓံ တိၐ္ဌထ တသ္မာဒ္ဓေတော ရျူယမပိ ပြမာဏံ ဒါသျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","ယုၐ္မာကံ ယထာ ဝါဓာ န ဇာယတေ တဒရ္ထံ ယုၐ္မာန် ဧတာနိ သရွွဝါကျာနိ ဝျာဟရံ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","လောကာ ယုၐ္မာန် ဘဇနဂၖဟေဘျော ဒူရီကရိၐျန္တိ တထာ ယသ္မိန် သမယေ ယုၐ္မာန် ဟတွာ ဤၑွရသျ တုၐ္ဋိ ဇနကံ ကရ္မ္မာကုရ္မ္မ ဣတိ မံသျန္တေ သ သမယ အာဂစ္ဆန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","တေ ပိတရံ မာဉ္စ န ဇာနန္တိ, တသ္မာဒ် ယုၐ္မာန် ပြတီဒၖၑမ် အာစရိၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","အတော ဟေတား သမယေ သမုပသ္ထိတေ ယထာ မမ ကထာ ယုၐ္မာကံ မနးသုး သမုပတိၐ္ဌတိ တဒရ္ထံ ယုၐ္မာဘျမ် ဧတာံ ကထာံ ကထယာမိ ယုၐ္မာဘိး သာရ္ဒ္ဓမ် အဟံ တိၐ္ဌန် ပြထမံ တာံ ယုၐ္မဘျံ နာကထယံ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","သာမ္ပြတံ သွသျ ပြေရယိတုး သမီပံ ဂစ္ဆာမိ တထာပိ တွံ က္က ဂစ္ဆသိ ကထာမေတာံ ယုၐ္မာကံ ကောပိ မာံ န ပၖစ္ဆတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","ကိန္တု မယောက္တာဘိရာဘိး ကထာဘိ ရျူၐ္မာကမ် အန္တးကရဏာနိ ဒုးခေန ပူရ္ဏာနျဘဝန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","တထာပျဟံ ယထာရ္ထံ ကထယာမိ မမ ဂမနံ ယုၐ္မာကံ ဟိတာရ္ထမေဝ, ယတော ဟေတော ရ္ဂမနေ န ကၖတေ သဟာယော ယုၐ္မာကံ သမီပံ နာဂမိၐျတိ ကိန္တု ယဒိ ဂစ္ဆာမိ တရှိ ယုၐ္မာကံ သမီပေ တံ ပြေၐယိၐျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","တတး သ အာဂတျ ပါပပုဏျဒဏ္ဍေၐု ဇဂတော လောကာနာံ ပြဗောဓံ ဇနယိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","တေ မယိ န ဝိၑွသန္တိ တသ္မာဒ္ဓေတေား ပါပပြဗောဓံ ဇနယိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ယုၐ္မာကမ် အဒၖၑျး သန္နဟံ ပိတုး သမီပံ ဂစ္ဆာမိ တသ္မာဒ် ပုဏျေ ပြဗောဓံ ဇနယိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ဧတဇ္ဇဂတော'ဓိပတိ ရ္ဒဏ္ဍာဇ္ဉာံ ပြာပ္နောတိ တသ္မာဒ် ဒဏ္ဍေ ပြဗောဓံ ဇနယိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","ယုၐ္မဘျံ ကထယိတုံ မမာနေကား ကထာ အာသတေ, တား ကထာ ဣဒါနီံ ယူယံ သောဎုံ န ၑက္နုထ; ");
INSERT INTO sanbur_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","ကိန္တု သတျမယ အာတ္မာ ယဒါ သမာဂမိၐျတိ တဒါ သရွွံ သတျံ ယုၐ္မာန် နေၐျတိ, သ သွတး ကိမပိ န ဝဒိၐျတိ ကိန္တု ယစ္ဆြောၐျတိ တဒေဝ ကထယိတွာ ဘာဝိကာရျျံ ယုၐ္မာန် ဇ္ဉာပယိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","မမ မဟိမာနံ ပြကာၑယိၐျတိ ယတော မဒီယာံ ကထာံ ဂၖဟီတွာ ယုၐ္မာန် ဗောဓယိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","ပိတု ရျဒျဒ် အာသ္တေ တတ် သရွွံ မမ တသ္မာဒ် ကာရဏာဒ် အဝါဒိၐံ သ မဒီယာံ ကထာံ ဂၖဟီတွာ ယုၐ္မာန် ဗောဓယိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","ကိယတ္ကာလာတ် ပရံ ယူယံ မာံ ဒြၐ္ဋုံ န လပ္သျဓွေ ကိန္တု ကိယတ္ကာလာတ် ပရံ ပုန ရ္ဒြၐ္ဋုံ လပ္သျဓွေ ယတောဟံ ပိတုး သမီပံ ဂစ္ဆာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","တတး ၑိၐျာဏာံ ကိယန္တော ဇနား ပရသ္ပရံ ဝဒိတုမ် အာရဘန္တ, ကိယတ္ကာလာတ် ပရံ မာံ ဒြၐ္ဋုံ န လပ္သျဓွေ ကိန္တု ကိယတ္ကာလာတ် ပရံ ပုန ရ္ဒြၐ္ဋုံ လပ္သျဓွေ ယတောဟံ ပိတုး သမီပံ ဂစ္ဆာမိ, ဣတိ ယဒ် ဝါကျမ် အယံ ဝဒတိ တတ် ကိံ? ");
INSERT INTO sanbur_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","တတး ကိယတ္ကာလာတ် ပရမ် ဣတိ တသျ ဝါကျံ ကိံ? တသျ ဝါကျသျာဘိပြာယံ ဝယံ ဗောဒ္ဓုံ န ၑက္နုမသ္တဲရိတိ ");
INSERT INTO sanbur_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","နိဂဒိတေ ယီၑုသ္တေၐာံ ပြၑ္နေစ္ဆာံ ဇ္ဉာတွာ တေဘျော'ကထယတ် ကိယတ္ကာလာတ် ပရံ မာံ ဒြၐ္ဋုံ န လပ္သျဓွေ, ကိန္တု ကိယတ္ကာလာတ် ပရံ ပူန ရ္ဒြၐ္ဋုံ လပ္သျဓွေ, ယာမိမာံ ကထာမကထယံ တသျာ အဘိပြာယံ ကိံ ယူယံ ပရသ္ပရံ မၖဂယဓွေ? ");
INSERT INTO sanbur_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","ယုၐ္မာနဟမ် အတိယထာရ္ထံ ဝဒါမိ ယူယံ ကြန္ဒိၐျထ ဝိလပိၐျထ စ, ကိန္တု ဇဂတော လောကာ အာနန္ဒိၐျန္တိ; ယူယံ ၑောကာကုလာ ဘဝိၐျထ ကိန္တု ၑောကာတ် ပရံ အာနန္ဒယုက္တာ ဘဝိၐျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","ပြသဝကာလ ဥပသ္ထိတေ နာရီ ယထာ ပြသဝဝေဒနယာ ဝျာကုလာ ဘဝတိ ကိန္တု ပုတြေ ဘူမိၐ္ဌေ သတိ မနုၐျဲကော ဇန္မနာ နရလောကေ ပြဝိၐ္ဋ ဣတျာနန္ဒာတ် တသျာသ္တတ္သရွွံ ဒုးခံ မနသိ န တိၐ္ဌတိ, ");
INSERT INTO sanbur_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","တထာ ယူယမပိ သာမ္ပြတံ ၑောကာကုလာ ဘဝထ ကိန္တု ပုနရပိ ယုၐ္မဘျံ ဒရ္ၑနံ ဒါသျာမိ တေန ယုၐ္မာကမ် အန္တးကရဏာနိ သာနန္ဒာနိ ဘဝိၐျန္တိ, ယုၐ္မာကံ တမ် အာနန္ဒဉ္စ ကောပိ ဟရ္တ္တုံ န ၑက္ၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","တသ္မိန် ဒိဝသေ ကာမပိ ကထာံ မာံ န ပြက္ၐျထ၊ ယုၐ္မာနဟမ် အတိယထာရ္ထံ ဝဒါမိ, မမ နာမ္နာ ယတ် ကိဉ္စိဒ် ပိတရံ ယာစိၐျဓွေ တဒေဝ သ ဒါသျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","ပူရွွေ မမ နာမ္နာ ကိမပိ နာယာစဓွံ, ယာစဓွံ တတး ပြာပ္သျထ တသ္မာဒ် ယုၐ္မာကံ သမ္ပူရ္ဏာနန္ဒော ဇနိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","ဥပမာကထာဘိး သရွွာဏျေတာနိ ယုၐ္မာန် ဇ္ဉာပိတဝါန် ကိန္တု ယသ္မိန် သမယေ ဥပမယာ နောက္တွာ ပိတုး ကထာံ သ္ပၐ္ဋံ ဇ္ဉာပယိၐျာမိ သမယ ဧတာဒၖၑ အာဂစ္ဆတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","တဒါ မမ နာမ္နာ ပြာရ္ထယိၐျဓွေ 'ဟံ ယုၐ္မန္နိမိတ္တံ ပိတရံ ဝိနေၐျေ ကထာမိမာံ န ဝဒါမိ; ");
INSERT INTO sanbur_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ယတော ယူယံ မယိ ပြေမ ကုရုထ, တထာဟမ် ဤၑွရသျ သမီပါဒ် အာဂတဝါန် ဣတျပိ ပြတီထ, တသ္မာဒ် ကာရဏာတ် ကာရဏာတ် ပိတာ သွယံ ယုၐ္မာသု ပြီယတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","ပိတုး သမီပါဇ္ဇဇဒ် အာဂတောသ္မိ ဇဂတ် ပရိတျဇျ စ ပုနရပိ ပိတုး သမီပံ ဂစ္ဆာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","တဒါ ၑိၐျာ အဝဒန်, ဟေ ပြဘော ဘဝါန် ဥပမယာ နောက္တွာဓုနာ သ္ပၐ္ဋံ ဝဒတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ဘဝါန် သရွွဇ္ဉး ကေနစိတ် ပၖၐ္ဋော ဘဝိတုမပိ ဘဝတး ပြယောဇနံ နာသ္တီတျဓုနာသ္မာကံ သ္ထိရဇ္ဉာနံ ဇာတံ တသ္မာဒ် ဘဝါန် ဤၑွရသျ သမီပါဒ် အာဂတဝါန် ဣတျတြ ဝယံ ဝိၑွသိမး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","တတော ယီၑုး ပြတျဝါဒီဒ် ဣဒါနီံ ကိံ ယူယံ ဝိၑွသိထ? ");
INSERT INTO sanbur_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","ပၑျတ သရွွေ ယူယံ ဝိကီရ္ဏား သန္တော မာမ် ဧကာကိနံ ပီရတျဇျ သွံ သွံ သ္ထာနံ ဂမိၐျထ, ဧတာဒၖၑး သမယ အာဂစ္ဆတိ ဝရံ ပြာယေဏောပသ္ထိတဝါန်; တထာပျဟံ နဲကာကီ ဘဝါမိ ယတး ပိတာ မယာ သာရ္ဒ္ဓမ် အာသ္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","ယထာ မယာ ယုၐ္မာကံ ၑာန္တိ ရ္ဇာယတေ တဒရ္ထမ် ဧတား ကထာ ယုၐ္မဘျမ် အစကထံ; အသ္မိန် ဇဂတိ ယုၐ္မာကံ က္လေၑော ဃဋိၐျတေ ကိန္တွက္ၐောဘာ ဘဝတ ယတော မယာ ဇဂဇ္ဇိတံ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","တတး ပရံ ယီၑုရေတား ကထား ကထယိတွာ သွရ္ဂံ ဝိလောကျဲတတ် ပြာရ္ထယတ်, ဟေ ပိတး သမယ ဥပသ္ထိတဝါန်; ယထာ တဝ ပုတြသ္တဝ မဟိမာနံ ပြကာၑယတိ တဒရ္ထံ တွံ နိဇပုတြသျ မဟိမာနံ ပြကာၑယ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","တွံ ယောလ္လောကာန် တသျ ဟသ္တေ သမရ္ပိတဝါန် သ ယထာ တေဘျော'နန္တာယု ရ္ဒဒါတိ တဒရ္ထံ တွံ ပြာဏိမာတြာဏာမ် အဓိပတိတွဘာရံ တသ္မဲ ဒတ္တဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","ယသ္တွမ် အဒွိတီယး သတျ ဤၑွရသ္တွယာ ပြေရိတၑ္စ ယီၑုး ခြီၐ္ဋ ဧတယောရုဘယေား ပရိစယေ ပြာပ္တေ'နန္တာယု ရ္ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","တွံ ယသျ ကရ္မ္မဏော ဘာရံ မဟျံ ဒတ္တဝါန်, တတ် သမ္ပန္နံ ကၖတွာ ဇဂတျသ္မိန် တဝ မဟိမာနံ ပြာကာၑယံ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","အတဧဝ ဟေ ပိတ ရ္ဇဂတျဝိဒျမာနေ တွယာ သဟ တိၐ္ဌတော မမ ယော မဟိမာသီတ် သမ္ပြတိ တဝ သမီပေ မာံ တံ မဟိမာနံ ပြာပယ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","အနျစ္စ တွမ် ဧတဇ္ဇဂတော ယာလ္လောကာန် မဟျမ် အဒဒါ အဟံ တေဘျသ္တဝ နာမ္နသ္တတ္တွဇ္ဉာနမ် အဒဒါံ, တေ တဝဲဝါသန်, တွံ တာန် မဟျမဒဒါး, တသ္မာတ္တေ တဝေါပဒေၑမ် အဂၖဟ္လန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","တွံ မဟျံ ယတ် ကိဉ္စိဒ် အဒဒါသ္တတ္သရွွံ တွတ္တော ဇာယတေ ဣတျဓုနာဇာနန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","မဟျံ ယမုပဒေၑမ် အဒဒါ အဟမပိ တေဘျသ္တမုပဒေၑမ် အဒဒါံ တေပိ တမဂၖဟ္လန် တွတ္တောဟံ နိရ္ဂတျ တွယာ ပြေရိတောဘဝမ် အတြ စ ဝျၑွသန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","တေၐာမေဝ နိမိတ္တံ ပြာရ္ထယေ'ဟံ ဇဂတော လောကနိမိတ္တံ န ပြာရ္ထယေ ကိန္တု ယာလ္လောကာန် မဟျမ် အဒဒါသ္တေၐာမေဝ နိမိတ္တံ ပြာရ္ထယေ'ဟံ ယတသ္တေ တဝဲဝါသတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ယေ မမ တေ တဝ ယေ စ တဝ တေ မမ တထာ တဲ ရ္မမ မဟိမာ ပြကာၑျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","သာမ္ပြတမ် အသ္မိန် ဇဂတိ မမာဝသ္ထိတေး ၑေၐမ် အဘဝတ် အဟံ တဝ သမီပံ ဂစ္ဆာမိ ကိန္တု တေ ဇဂတိ သ္ထာသျန္တိ; ဟေ ပဝိတြ ပိတရာဝယော ရျထဲကတွမာသ္တေ တထာ တေၐာမပျေကတွံ ဘဝတိ တဒရ္ထံ ယာလ္လောကာန် မဟျမ် အဒဒါသ္တာန် သွနာမ္နာ ရက္ၐ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","ယာဝန္တိ ဒိနာနိ ဇဂတျသ္မိန် တဲး သဟာဟမာသံ တာဝန္တိ ဒိနာနိ တာန် တဝ နာမ္နာဟံ ရက္ၐိတဝါန်; ယာလ္လောကာန် မဟျမ် အဒဒါသ္တာန် သရွွာန် အဟမရက္ၐံ, တေၐာံ မဓျေ ကေဝလံ ဝိနာၑပါတြံ ဟာရိတံ တေန ဓရ္မ္မပုသ္တကသျ ဝစနံ ပြတျက္ၐံ ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","ကိန္တွဓုနာ တဝ သန္နိဓိံ ဂစ္ဆာမိ မယာ ယထာ တေၐာံ သမ္ပူရ္ဏာနန္ဒော ဘဝတိ တဒရ္ထမဟံ ဇဂတိ တိၐ္ဌန် ဧတား ကထာ အကထယမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","တဝေါပဒေၑံ တေဘျော'ဒဒါံ ဇဂတာ သဟ ယထာ မမ သမ္ဗန္ဓော နာသ္တိ တထာ ဇဇတာ သဟ တေၐာမပိ သမ္ဗန္ဓာဘာဝါဇ် ဇဂတော လောကာသ္တာန် ၒတီယန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","တွံ ဇဂတသ္တာန် ဂၖဟာဏေတိ န ပြာရ္ထယေ ကိန္တွၑုဘာဒ် ရက္ၐေတိ ပြာရ္ထယေဟမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","အဟံ ယထာ ဇဂတ္သမ္ဗန္ဓီယော န ဘဝါမိ တထာ တေပိ ဇဂတ္သမ္ဗန္ဓီယာ န ဘဝန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","တဝ သတျကထယာ တာန် ပဝိတြီကုရု တဝ ဝါကျမေဝ သတျံ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","တွံ ယထာ မာံ ဇဂတိ ပြဲရယသ္တထာဟမပိ တာန် ဇဂတိ ပြဲရယံ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","တေၐာံ ဟိတာရ္ထံ ယထာဟံ သွံ ပဝိတြီကရောမိ တထာ သတျကထယာ တေပိ ပဝိတြီဘဝန္တု၊ ");
INSERT INTO sanbur_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","ကေဝလံ ဧတေၐာမရ္ထေ ပြာရ္ထယေ'ဟမ် ဣတိ န ကိန္တွေတေၐာမုပဒေၑေန ယေ ဇနာ မယိ ဝိၑွသိၐျန္တိ တေၐာမပျရ္ထေ ပြာရ္ထေယေ'ဟမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ဟေ ပိတသ္တေၐာံ သရွွေၐာမ် ဧကတွံ ဘဝတု တဝ ယထာ မယိ မမ စ ယထာ တွယျေကတွံ တထာ တေၐာမပျာဝယောရေကတွံ ဘဝတု တေန တွံ မာံ ပြေရိတဝါန် ဣတိ ဇဂတော လောကား ပြတိယန္တု၊ ");
INSERT INTO sanbur_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","ယထာဝယောရေကတွံ တထာ တေၐာမပျေကတွံ ဘဝတု တေၐွဟံ မယိ စ တွမ် ဣတ္ထံ တေၐာံ သမ္ပူရ္ဏမေကတွံ ဘဝတု, တွံ ပြေရိတဝါန် တွံ မယိ ယထာ ပြီယသေ စ တထာ တေၐွပိ ပြီတဝါန် ဧတဒျထာ ဇဂတော လောကာ ဇာနန္တိ ");
INSERT INTO sanbur_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","တဒရ္ထံ တွံ ယံ မဟိမာနံ မဟျမ် အဒဒါသ္တံ မဟိမာနမ် အဟမပိ တေဘျော ဒတ္တဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","ဟေ ပိတ ရ္ဇဂတော နိရ္မ္မာဏာတ် ပူရွွံ မယိ သ္နေဟံ ကၖတွာ ယံ မဟိမာနံ ဒတ္တဝါန် မမ တံ မဟိမာနံ ယထာ တေ ပၑျန္တိ တဒရ္ထံ ယာလ္လောကာန် မဟျံ ဒတ္တဝါန် အဟံ ယတြ တိၐ္ဌာမိ တေပိ ယထာ တတြ တိၐ္ဌန္တိ မမဲၐာ ဝါဉ္ဆာ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ဟေ ယထာရ္ထိက ပိတ ရ္ဇဂတော လောကဲသ္တွယျဇ္ဉာတေပိ တွာမဟံ ဇာနေ တွံ မာံ ပြေရိတဝါန် ဣတီမေ ၑိၐျာ ဇာနန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","ယထာဟံ တေၐု တိၐ္ဌာမိ တထာ မယိ ယေန ပြေမ္နာ ပြေမာကရောသ္တတ် တေၐု တိၐ္ဌတိ တဒရ္ထံ တဝ နာမာဟံ တာန် ဇ္ဉာပိတဝါန် ပုနရပိ ဇ္ဉာပယိၐျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","တား ကထား ကထယိတွာ ယီၑုး ၑိၐျာနာဒါယ ကိဒြောန္နာမကံ သြောတ ဥတ္တီရျျ ၑိၐျဲး သဟ တတြတျောဒျာနံ ပြာဝိၑတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","ကိန္တု ဝိၑွာသဃာတိယိဟူဒါသ္တတ် သ္ထာနံ ပရိစီယတေ ယတော ယီၑုး ၑိၐျဲး သာရ္ဒ္ဓံ ကဒါစိတ် တတ် သ္ထာနမ် အဂစ္ဆတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","တဒါ သ ယိဟူဒါး သဲနျဂဏံ ပြဓာနယာဇကာနာံ ဖိရူၑိနာဉ္စ ပဒါတိဂဏဉ္စ ဂၖဟီတွာ ပြဒီပါန် ဥလ္ကာန် အသ္တြာဏိ စာဒါယ တသ္မိန် သ္ထာန ဥပသ္ထိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","သွံ ပြတိ ယဒ် ဃဋိၐျတေ တဇ် ဇ္ဉာတွာ ယီၑုရဂြေသရး သန် တာနပၖစ္ဆတ် ကံ ဂဝေၐယထ? ");
INSERT INTO sanbur_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","တေ ပြတျဝဒန်, နာသရတီယံ ယီၑုံ; တတော ယီၑုရဝါဒီဒ် အဟမေဝ သး; တဲး သဟ ဝိၑွာသဃာတီ ယိဟူဒါၑ္စာတိၐ္ဌတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","တဒါဟမေဝ သ တသျဲတာံ ကထာံ ၑြုတွဲဝ တေ ပၑ္စာဒေတျ ဘူမော် ပတိတား၊ ");
INSERT INTO sanbur_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","တတော ယီၑုး ပုနရပိ ပၖၐ္ဌဝါန် ကံ ဂဝေၐယထ? တတသ္တေ ပြတျဝဒန် နာသရတီယံ ယီၑုံ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","တဒါ ယီၑုး ပြတျုဒိတဝါန် အဟမေဝ သ ဣမာံ ကထာမစကထမ်; ယဒိ မာမနွိစ္ဆထ တရှီမာန် ဂန္တုံ မာ ဝါရယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ဣတ္ထံ ဘူတေ မဟျံ ယာလ္လောကာန် အဒဒါသ္တေၐာမ် ဧကမပိ နာဟာရယမ် ဣမာံ ယာံ ကထာံ သ သွယမကထယတ် သာ ကထာ သဖလာ ဇာတာ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","တဒါ ၑိမောန္ပိတရသျ နိကဋေ ခင်္ဂလ္သ္ထိတေး သ တံ နိၐ္ကောၐံ ကၖတွာ မဟာယာဇကသျ မာလ္ခနာမာနံ ဒါသမ် အာဟတျ တသျ ဒက္ၐိဏကရ္ဏံ ဆိန္နဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","တတော ယီၑုး ပိတရမ် အဝဒတ်, ခင်္ဂံ ကောၐေ သ္ထာပယ မမ ပိတာ မဟျံ ပါတုံ ယံ ကံသမ် အဒဒါတ် တေနာဟံ ကိံ န ပါသျာမိ? ");
INSERT INTO sanbur_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","တဒါ သဲနျဂဏး သေနာပတိ ရျိဟူဒီယာနာံ ပဒါတယၑ္စ ယီၑုံ ဃၖတွာ ဗဒ္ဓွာ ဟာနန္နာမ္နး ကိယဖား ၑွၑုရသျ သမီပံ ပြထမမ် အနယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","သ ကိယဖာသ္တသ္မိန် ဝတ္သရေ မဟာယာဇတွပဒေ နိယုက္တး ");
INSERT INTO sanbur_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","သန် သာဓာရဏလောကာနာံ မင်္ဂလာရ္ထမ် ဧကဇနသျ မရဏမုစိတမ် ဣတိ ယိဟူဒီယဲး သာရ္ဒ္ဓမ် အမန္တြယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","တဒါ ၑိမောန္ပိတရော'နျဲကၑိၐျၑ္စ ယီၑေား ပၑ္စာဒ် အဂစ္ဆတာံ တသျာနျၑိၐျသျ မဟာယာဇကေန ပရိစိတတွာတ် သ ယီၑုနာ သဟ မဟာယာဇကသျာဋ္ဋာလိကာံ ပြာဝိၑတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ကိန္တု ပိတရော ဗဟိရ္ဒွါရသျ သမီပေ'တိၐ္ဌဒ် အတဧဝ မဟာယာဇကေန ပရိစိတး သ ၑိၐျး ပုနရ္ဗဟိရ္ဂတွာ ဒေါ်ဝါယိကာယဲ ကထယိတွာ ပိတရမ် အဘျန္တရမ် အာနယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","တဒါ သ ဒွါရရက္ၐိကာ ပိတရမ် အဝဒတ် တွံ ကိံ န တသျ မာနဝသျ ၑိၐျး? တတး သောဝဒဒ် အဟံ န ဘဝါမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","တတး ပရံ ယတ္သ္ထာနေ ဒါသား ပဒါတယၑ္စ ၑီတဟေတောရင်္ဂါရဲ ရွဟ္နိံ ပြဇွာလျ တာပံ သေဝိတဝန္တသ္တတ္သ္ထာနေ ပိတရသ္တိၐ္ဌန် တဲး သဟ ဝဟ္နိတာပံ သေဝိတုမ် အာရဘတ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","တဒါ ၑိၐျေၐူပဒေၑေ စ မဟာယာဇကေန ယီၑုး ပၖၐ္ဋး ");
INSERT INTO sanbur_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","သန် ပြတျုက္တဝါန် သရွွလောကာနာံ သမက္ၐံ ကထာမကထယံ ဂုပ္တံ ကာမပိ ကထာံ န ကထယိတွာ ယတ် သ္ထာနံ ယိဟူဒီယား သတတံ ဂစ္ဆန္တိ တတြ ဘဇနဂေဟေ မန္ဒိရေ စာၑိက္ၐယံ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","မတ္တး ကုတး ပၖစ္ဆသိ? ယေ ဇနာ မဒုပဒေၑမ် အၑၖဏွန် တာနေဝ ပၖစ္ဆ ယဒျဒ် အဝဒံ တေ တတ် ဇာနိန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","တဒေတ္ထံ ပြတျုဒိတတွာတ် နိကဋသ္ထပဒါတိ ရျီၑုံ စပေဋေနာဟတျ ဝျာဟရတ် မဟာယာဇကမ် ဧဝံ ပြတိဝဒသိ? ");
INSERT INTO sanbur_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","တတော ယီၑုး ပြတိဂဒိတဝါန် ယဒျယထာရ္ထမ် အစကထံ တရှိ တသျာယထာရ္ထသျ ပြမာဏံ ဒေဟိ, ကိန္တု ယဒိ ယထာရ္ထံ တရှိ ကုတော ဟေတော ရ္မာမ် အတာဍယး? ");
INSERT INTO sanbur_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","ပူရွွံ ဟာနန် သဗန္ဓနံ တံ ကိယဖာမဟာယာဇကသျ သမီပံ ပြဲၐယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ၑိမောန္ပိတရသ္တိၐ္ဌန် ဝဟ္နိတာပံ သေဝတေ, ဧတသ္မိန် သမယေ ကိယန္တသ္တမ် အပၖစ္ဆန် တွံ ကိမ် ဧတသျ ဇနသျ ၑိၐျော န? တတး သောပဟ္နုတျာဗြဝီဒ် အဟံ န ဘဝါမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","တဒါ မဟာယာဇကသျ ယသျ ဒါသသျ ပိတရး ကရ္ဏမစ္ဆိနတ် တသျ ကုဋုမ္ဗး ပြတျုဒိတဝါန် ဥဒျာနေ တေန သဟ တိၐ္ဌန္တံ တွာံ ကိံ နာပၑျံ? ");
INSERT INTO sanbur_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","ကိန္တု ပိတရး ပုနရပဟ္နုတျ ကထိတဝါန်; တဒါနီံ ကုက္ကုဋော'ရော်တ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","တဒနန္တရံ ပြတျူၐေ တေ ကိယဖာဂၖဟာဒ် အဓိပတေ ရ္ဂၖဟံ ယီၑုမ် အနယန် ကိန္တု ယသ္မိန် အၑုစိတွေ ဇာတေ တဲ ရ္နိသ္တာရောတ္သဝေ န ဘောက္တဝျံ, တသျ ဘယာဒ် ယိဟူဒီယာသ္တဒ္ဂၖဟံ နာဝိၑန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","အပရံ ပီလာတော ဗဟိရာဂတျ တာန် ပၖၐ္ဌဝါန် ဧတသျ မနုၐျသျ ကံ ဒေါၐံ ဝဒထ? ");
INSERT INTO sanbur_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","တဒါ တေ ပေတျဝဒန် ဒုၐ္ကရ္မ္မကာရိဏိ န သတိ ဘဝတး သမီပေ နဲနံ သမာရ္ပယိၐျာမး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","တတး ပီလာတော'ဝဒဒ် ယူယမေနံ ဂၖဟီတွာ သွေၐာံ ဝျဝသ္ထယာ ဝိစာရယတ၊ တဒါ ယိဟူဒီယား ပြတျဝဒန် ကသျာပိ မနုၐျသျ ပြာဏဒဏ္ဍံ ကရ္တ္တုံ နာသ္မာကမ် အဓိကာရော'သ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ဧဝံ သတိ ယီၑုး သွသျ မၖတျော် ယာံ ကထာံ ကထိတဝါန် သာ သဖလာဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","တဒနန္တရံ ပီလာတး ပုနရပိ တဒ် ရာဇဂၖဟံ ဂတွာ ယီၑုမာဟူယ ပၖၐ္ဋဝါန် တွံ ကိံ ယိဟူဒီယာနာံ ရာဇာ? ");
INSERT INTO sanbur_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","ယီၑုး ပြတျဝဒတ် တွမ် ဧတာံ ကထာံ သွတး ကထယသိ ကိမနျး ကၑ္စိန် မယိ ကထိတဝါန်? ");
INSERT INTO sanbur_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ပီလာတော'ဝဒဒ် အဟံ ကိံ ယိဟူဒီယး? တဝ သွဒေၑီယာ ဝိၑေၐတး ပြဓာနယာဇကာ မမ နိကဋေ တွာံ သမာရ္ပယန, တွံ ကိံ ကၖတဝါန်? ");
INSERT INTO sanbur_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","ယီၑုး ပြတျဝဒတ် မမ ရာဇျမ် ဧတဇ္ဇဂတ္သမ္ဗန္ဓီယံ န ဘဝတိ ယဒိ မမ ရာဇျံ ဇဂတ္သမ္ဗန္ဓီယမ် အဘဝိၐျတ် တရှိ ယိဟူဒီယာနာံ ဟသ္တေၐု ယထာ သမရ္ပိတော နာဘဝံ တဒရ္ထံ မမ သေဝကာ အယောတ္သျန် ကိန္တု မမ ရာဇျမ် အဲဟိကံ န၊ ");
INSERT INTO sanbur_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","တဒါ ပီလာတး ကထိတဝါန်, တရှိ တွံ ရာဇာ ဘဝသိ? ယီၑုး ပြတျုက္တဝါန် တွံ သတျံ ကထယသိ, ရာဇာဟံ ဘဝါမိ; သတျတာယာံ သာက္ၐျံ ဒါတုံ ဇနိံ ဂၖဟီတွာ ဇဂတျသ္မိန် အဝတီရ္ဏဝါန်, တသ္မာတ် သတျဓရ္မ္မပက္ၐပါတိနော မမ ကထာံ ၑၖဏွန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","တဒါ သတျံ ကိံ? ဧတာံ ကထာံ ပၐ္ဋွာ ပီလာတး ပုနရပိ ဗဟိရ္ဂတွာ ယိဟူဒီယာန် အဘာၐတ, အဟံ တသျ ကမပျပရာဓံ န ပြာပ္နောမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","နိသ္တာရောတ္သဝသမယေ ယုၐ္မာဘိရဘိရုစိတ ဧကော ဇနော မယာ မောစယိတဝျ ဧၐာ ယုၐ္မာကံ ရီတိရသ္တိ, အတဧဝ ယုၐ္မာကံ နိကဋေ ယိဟူဒီယာနာံ ရာဇာနံ ကိံ မောစယာမိ, ယုၐ္မာကမ် ဣစ္ဆာ ကာ? ");
INSERT INTO sanbur_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","တဒါ တေ သရွွေ ရုဝန္တော ဝျာဟရန် ဧနံ မာနုၐံ နဟိ ဗရဗ္ဗာံ မောစယ၊ ကိန္တု သ ဗရဗ္ဗာ ဒသျုရာသီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","ပီလာတော ယီၑုမ် အာနီယ ကၑယာ ပြာဟာရယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ပၑ္စာတ် သေနာဂဏး ကဏ္ဋကနိရ္မ္မိတံ မုကုဋံ တသျ မသ္တကေ သမရ္ပျ ဝါရ္တ္တာကီဝရ္ဏံ ရာဇပရိစ္ဆဒံ ပရိဓာပျ, ");
INSERT INTO sanbur_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ဟေ ယိဟူဒီယာနာံ ရာဇန် နမသ္ကာရ ဣတျုက္တွာ တံ စပေဋေနာဟန္တုမ် အာရဘတ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","တဒါ ပီလာတး ပုနရပိ ဗဟိရ္ဂတွာ လောကာန် အဝဒတ်, အသျ ကမပျပရာဓံ န လဘေ'ဟံ, ပၑျတ တဒ် ယုၐ္မာန် ဇ္ဉာပယိတုံ ယုၐ္မာကံ သန္နိဓော် ဗဟိရေနမ် အာနယာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","တတး ပရံ ယီၑုး ကဏ္ဋကမုကုဋဝါန် ဝါရ္တ္တာကီဝရ္ဏဝသနဝါံၑ္စ ဗဟိရာဂစ္ဆတ်၊ တတး ပီလာတ ဥက္တဝါန် ဧနံ မနုၐျံ ပၑျတ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","တဒါ ပြဓာနယာဇကား ပဒါတယၑ္စ တံ ဒၖၐ္ဋွာ, ဧနံ ကြုၑေ ဝိဓ, ဧနံ ကြုၑေ ဝိဓ, ဣတျုက္တွာ ရဝိတုံ အာရဘန္တ၊ တတး ပီလာတး ကထိတဝါန် ယူယံ သွယမ် ဧနံ နီတွာ ကြုၑေ ဝိဓတ, အဟမ် ဧတသျ ကမပျပရာဓံ န ပြာပ္တဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","ယိဟူဒီယား ပြတျဝဒန် အသ္မာကံ ယာ ဝျဝသ္ထာသ္တေ တဒနုသာရေဏာသျ ပြာဏဟနနမ် ဥစိတံ ယတောယံ သွမ် ဤၑွရသျ ပုတြမဝဒတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ပီလာတ ဣမာံ ကထာံ ၑြုတွာ မဟာတြာသယုက္တး ");
INSERT INTO sanbur_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","သန် ပုနရပိ ရာဇဂၖဟ အာဂတျ ယီၑုံ ပၖၐ္ဋဝါန် တွံ ကုတြတျော လောကး? ကိန္တု ယီၑသ္တသျ ကိမပိ ပြတျုတ္တရံ နာဝဒတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","၁॰ တတး ပီလာတ် ကထိတဝါန တွံ ကိံ မယာ သာရ္ဒ္ဓံ န သံလပိၐျသိ ? တွာံ ကြုၑေ ဝေဓိတုံ ဝါ မောစယိတုံ ၑက္တိ ရ္မမာသ္တေ ဣတိ ကိံ တွံ န ဇာနာသိ ? တဒါ ယီၑုး ပြတျဝဒဒ် ဤၑွရေဏာဒŸाံ မမောပရိ တဝ ကိမပျဓိပတိတွံ န ဝိဒျတေ, တထာပိ ယော ဇနော မာံ တဝ ဟသ္တေ သမာရ္ပယတ် တသျ မဟာပါတကံ ဇာတမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","တဒါ ယီၑုး ပြတျဝဒဒ် ဤၑွရေဏာဒတ္တံ မမောပရိ တဝ ကိမပျဓိပတိတွံ န ဝိဒျတေ, တထာပိ ယော ဇနော မာံ တဝ ဟသ္တေ သမာရ္ပယတ် တသျ မဟာပါတကံ ဇာတမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","တဒါရဘျ ပီလာတသ္တံ မောစယိတုံ စေၐ္ဋိတဝါန် ကိန္တု ယိဟူဒီယာ ရုဝန္တော ဝျာဟရန် ယဒီမံ မာနဝံ တျဇသိ တရှိ တွံ ကဲသရသျ မိတြံ န ဘဝသိ, ယော ဇနး သွံ ရာဇာနံ ဝက္တိ သဧဝ ကဲမရသျ ဝိရုဒ္ဓါံ ကထာံ ကထယတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ဧတာံ ကထာံ ၑြုတွာ ပီလာတော ယီၑုံ ဗဟိရာနီယ နိသ္တာရောတ္သဝသျ အာသာဒနဒိနသျ ဒွိတီယပြဟရာတ် ပူရွွံ ပြသ္တရဗန္ဓနနာမ္နိ သ္ထာနေ 'ရ္ထာတ် ဣဗြီယဘာၐယာ ယဒ် ဂဗ္ဗိထာ ကထျတေ တသ္မိန် သ္ထာနေ ဝိစာရာသန ဥပါဝိၑတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","အနန္တရံ ပီလာတော ယိဟူဒီယာန် အဝဒတ်, ယုၐ္မာကံ ရာဇာနံ ပၑျတ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","ကိန္တု ဧနံ ဒူရီကုရု, ဧနံ ဒူရီကုရု, ဧနံ ကြုၑေ ဝိဓ, ဣတိ ကထာံ ကထယိတွာ တေ ရဝိတုမ် အာရဘန္တ; တဒါ ပီလာတး ကထိတဝါန် ယုၐ္မာကံ ရာဇာနံ ကိံ ကြုၑေ ဝေဓိၐျာမိ? ပြဓာနယာဇကာ ဥတ္တရမ် အဝဒန် ကဲသရံ ဝိနာ ကောပိ ရာဇာသ္မာကံ နာသ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","တတး ပီလာတော ယီၑုံ ကြုၑေ ဝေဓိတုံ တေၐာံ ဟသ္တေၐု သမာရ္ပယတ်, တတသ္တေ တံ ဓၖတွာ နီတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","တတး ပရံ ယီၑုး ကြုၑံ ဝဟန် ၑိရးကပါလမ် အရ္ထာဒ် ယဒ် ဣဗြီယဘာၐယာ ဂုလ္ဂလ္တာံ ဝဒန္တိ တသ္မိန် သ္ထာန ဥပသ္ထိတး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","တတသ္တေ မဓျသ္ထာနေ တံ တသျောဘယပါရ္ၑွေ ဒွါဝပရော် ကြုၑေ'ဝိဓန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","အပရမ် ဧၐ ယိဟူဒီယာနာံ ရာဇာ နာသရတီယယီၑုး, ဣတိ ဝိဇ္ဉာပနံ လိခိတွာ ပီလာတသ္တသျ ကြုၑောပရိ သမယောဇယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","သာ လိပိး ဣဗြီယယူနာနီယရောမီယဘာၐာဘိ ရ္လိခိတာ; ယီၑေား ကြုၑဝေဓနသ္ထာနံ နဂရသျ သမီပံ, တသ္မာဒ် ဗဟဝေါ ယိဟူဒီယာသ္တာံ ပဌိတုမ် အာရဘန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","ယိဟူဒီယာနာံ ပြဓာနယာဇကား ပီလာတမိတိ နျဝေဒယန် ယိဟူဒီယာနာံ ရာဇေတိ ဝါကျံ န ကိန္တု ဧၐ သွံ ယိဟူဒီယာနာံ ရာဇာနမ် အဝဒဒ် ဣတ္ထံ လိခတု၊ ");
INSERT INTO sanbur_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","တတး ပီလာတ ဥတ္တရံ ဒတ္တဝါန် ယလ္လေခနီယံ တလ္လိခိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","ဣတ္ထံ သေနာဂဏော ယီၑုံ ကြုၑေ ဝိဓိတွာ တသျ ပရိဓေယဝသ္တြံ စတုရော ဘာဂါန် ကၖတွာ ဧကဲကသေနာ ဧကဲကဘာဂမ် အဂၖဟ္လတ် တသျောတ္တရီယဝသ္တြဉ္စာဂၖဟ္လတ်၊ ကိန္တူတ္တရီယဝသ္တြံ သူစိသေဝနံ ဝိနာ သရွွမ် ဦတံ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","တသ္မာတ္တေ ဝျာဟရန် ဧတတ် ကး ပြာပ္သျတိ? တန္န ခဏ္ဍယိတွာ တတြ ဂုဋိကာပါတံ ကရဝါမ၊ ဝိဘဇန္တေ'ဓရီယံ မေ ဝသနံ တေ ပရသ္ပရံ၊ မမောတ္တရီယဝသ္တြာရ္ထံ ဂုဋိကာံ ပါတယန္တိ စ၊ ဣတိ ယဒွါကျံ ဓရ္မ္မပုသ္တကေ လိခိတမာသ္တေ တတ် သေနာဂဏေနေတ္ထံ ဝျဝဟရဏာတ် သိဒ္ဓမဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","တဒါနီံ ယီၑော ရ္မာတာ မာတု ရ္ဘဂိနီ စ ယာ က္လိယပါ ဘာရျျာ မရိယမ် မဂ္ဒလီနီ မရိယမ် စ ဧတာသ္တသျ ကြုၑသျ သန္နိဓော် သမတိၐ္ဌန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","တတော ယီၑုး သွမာတရံ ပြိယတမၑိၐျဉ္စ သမီပေ ဒဏ္ဍာယမာနော် ဝိလောကျ မာတရမ် အဝဒတ်, ဟေ ယောၐိဒ် ဧနံ တဝ ပုတြံ ပၑျ, ");
INSERT INTO sanbur_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ၑိၐျန္တွဝဒတ်, ဧနာံ တဝ မာတရံ ပၑျ၊ တတး သ ၑိၐျသ္တဒ္ဃဋိကာယာံ တာံ နိဇဂၖဟံ နီတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","အနန္တရံ သရွွံ ကရ္မ္မာဓုနာ သမ္ပန္နမဘူတ် ယီၑုရိတိ ဇ္ဉာတွာ ဓရ္မ္မပုသ္တကသျ ဝစနံ ယထာ သိဒ္ဓံ ဘဝတိ တဒရ္ထမ် အကထယတ် မမ ပိပါသာ ဇာတာ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","တတသ္တသ္မိန် သ္ထာနေ အမ္လရသေန ပူရ္ဏပါတြသ္ထိတျာ တေ သ္ပဉ္ဇမေကံ တဒမ္လရသေနာရ္ဒြီကၖတျ ဧသောဗ္နလေ တဒ် ယောဇယိတွာ တသျ မုခသျ သန္နိဓာဝသ္ထာပယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","တဒါ ယီၑုရမ္လရသံ ဂၖဟီတွာ သရွွံ သိဒ္ဓမ် ဣတိ ကထာံ ကထယိတွာ မသ္တကံ နမယန် ပြာဏာန် ပရျျတျဇတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","တဒွိနမ် အာသာဒနဒိနံ တသ္မာတ် ပရေ'ဟနိ ဝိၑြာမဝါရေ ဒေဟာ ယထာ ကြုၑောပရိ န တိၐ္ဌန္တိ, ယတး သ ဝိၑြာမဝါရော မဟာဒိနမာသီတ်, တသ္မာဒ် ယိဟူဒီယား ပီလာတနိကဋံ ဂတွာ တေၐာံ ပါဒဘဉ္ဇနသျ သ္ထာနာန္တရနယနသျ စာနုမတိံ ပြာရ္ထယန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","အတး သေနာ အာဂတျ ယီၑုနာ သဟ ကြုၑေ ဟတယေား ပြထမဒွိတီယစောရယေား ပါဒါန် အဘဉ္ဇန်; ");
INSERT INTO sanbur_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","ကိန္တု ယီၑေား သန္နိဓိံ ဂတွာ သ မၖတ ဣတိ ဒၖၐ္ဋွာ တသျ ပါဒေါ် နာဘဉ္ဇန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","ပၑ္စာဒ် ဧကော ယောဒ္ဓါ ၑူလာဃာတေန တသျ ကုက္ၐိမ် အဝိဓတ် တတ္က္ၐဏာတ် တသ္မာဒ် ရက္တံ ဇလဉ္စ နိရဂစ္ဆတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","ယော ဇနော'သျ သာက္ၐျံ ဒဒါတိ သ သွယံ ဒၖၐ္ဋဝါန် တသျေဒံ သာက္ၐျံ သတျံ တသျ ကထာ ယုၐ္မာကံ ဝိၑွာသံ ဇနယိတုံ ယောဂျာ တတ် သ ဇာနာတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","တသျဲကမ် အသ္ဓျပိ န ဘံက္ၐျတေ, ");
INSERT INTO sanbur_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","တဒွဒ် အနျၑာသ္တြေပိ လိချတေ, ယထာ, \"ဒၖၐ္ဋိပါတံ ကရိၐျန္တိ တေ'ဝိဓန် ယန္တု တမ္ပြတိ၊ \" ");
INSERT INTO sanbur_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","အရိမထီယနဂရသျ ယူၐဖ္နာမာ ၑိၐျ ဧက အာသီတ် ကိန္တု ယိဟူဒီယေဘျော ဘယာတ် ပြကာၑိတော န ဘဝတိ; သ ယီၑော ရ္ဒေဟံ နေတုံ ပီလာတသျာနုမတိံ ပြာရ္ထယတ, တတး ပီလာတေနာနုမတေ သတိ သ ဂတွာ ယီၑော ရ္ဒေဟမ် အနယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","အပရံ ယော နိကဒီမော ရာတြော် ယီၑေား သမီပမ် အဂစ္ဆတ် သောပိ ဂန္ဓရသေန မိၑြိတံ ပြာယေဏ ပဉ္စာၑတ္သေဋကမဂုရုံ ဂၖဟီတွာဂစ္ဆတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","တတသ္တေ ယိဟူဒီယာနာံ ၑ္မၑာနေ သ္ထာပနရီတျနုသာရေဏ တတ္သုဂန္ဓိဒြဝျေဏ သဟိတံ တသျ ဒေဟံ ဝသ္တြေဏာဝေၐ္ဋယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","အပရဉ္စ ယတြ သ္ထာနေ တံ ကြုၑေ'ဝိဓန် တသျ နိကဋသ္ထောဒျာနေ ယတြ ကိမပိ မၖတဒေဟံ ကဒါပိ နာသ္ထာပျတ တာဒၖၑမ် ဧကံ နူတနံ ၑ္မၑာနမ် အာသီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","ယိဟူဒီယာနာမ် အာသာဒနဒိနာဂမနာတ် တေ တသ္မိန် သမီပသ္ထၑ္မၑာနေ ယီၑုမ် အၑာယယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","အနန္တရံ သပ္တာဟသျ ပြထမဒိနေ 'တိပြတျူၐေ 'န္ဓကာရေ တိၐ္ဌတိ မဂ္ဒလီနီ မရိယမ် တသျ ၑ္မၑာနသျ နိကဋံ ဂတွာ ၑ္မၑာနသျ မုခါတ် ပြသ္တရမပသာရိတမ် အပၑျတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","ပၑ္စာဒ် ဓာဝိတွာ ၑိမောန္ပိတရာယ ယီၑေား ပြိယတမၑိၐျာယ စေဒမ် အကထယတ်, လောကား ၑ္မၑာနာတ် ပြဘုံ နီတွာ ကုတြာသ္ထာပယန် တဒ် ဝက္တုံ န ၑက္နောမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","အတး ပိတရး သောနျၑိၐျၑ္စ ဗရှိ ရ္ဘုတွာ ၑ္မၑာနသ္ထာနံ ဂန္တုမ် အာရဘေတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ဥဘယောရ္ဓာဝတေား သောနျၑိၐျး ပိတရံ ပၑ္စာတ် တျက္တွာ ပူရွွံ ၑ္မၑာနသ္ထာန ဥပသ္ထိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","တဒါ ပြဟွီဘူယ သ္ထာပိတဝသ္တြာဏိ ဒၖၐ္ဋဝါန် ကိန္တု န ပြာဝိၑတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","အပရံ ၑိမောန္ပိတရ အာဂတျ ၑ္မၑာနသ္ထာနံ ပြဝိၑျ ");
INSERT INTO sanbur_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","သ္ထာပိတဝသ္တြာဏိ မသ္တကသျ ဝသ္တြဉ္စ ပၖထက် သ္ထာနာန္တရေ သ္ထာပိတံ ဒၖၐ္ဋဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","တတး ၑ္မၑာနသ္ထာနံ ပူရွွမ် အာဂတော ယောနျၑိၐျး သောပိ ပြဝိၑျ တာဒၖၑံ ဒၖၐ္ဋာ ဝျၑွသီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","ယတး ၑ္မၑာနာတ် သ ဥတ္ထာပယိတဝျ ဧတသျ ဓရ္မ္မပုသ္တကဝစနသျ ဘာဝံ တေ တဒါ ဝေါဒ္ဓုံ နာၑန္ကုဝန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","အနန္တရံ တော် ဒွေါ် ၑိၐျော် သွံ သွံ ဂၖဟံ ပရာဝၖတျာဂစ္ဆတာမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","တတး ပရံ မရိယမ် ၑ္မၑာနဒွါရသျ ဗဟိး သ္ထိတွာ ရောဒိတုမ် အာရဘတ တတော ရုဒတီ ပြဟွီဘူယ ၑ္မၑာနံ ဝိလောကျ ");
INSERT INTO sanbur_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ယီၑေား ၑယနသ္ထာနသျ ၑိရးသ္ထာနေ ပဒတလေ စ ဒွယော ရ္ဒိၑော ဒွေါ် သွရ္ဂီယဒူတာဝုပဝိၐ္ဋော် သမပၑျတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","တော် ပၖၐ္ဋဝန္တော် ဟေ နာရိ ကုတော ရောဒိၐိ? သာဝဒတ် လောကာ မမ ပြဘုံ နီတွာ ကုတြာသ္ထာပယန် ဣတိ န ဇာနာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ဣတျုက္တွာ မုခံ ပရာဝၖတျ ယီၑုံ ဒဏ္ဍာယမာနမ် အပၑျတ် ကိန္တု သ ယီၑုရိတိ သာ ဇ္ဉာတုံ နာၑက္နောတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","တဒါ ယီၑုသ္တာမ် အပၖစ္ဆတ် ဟေ နာရိ ကုတော ရောဒိၐိ? ကံ ဝါ မၖဂယသေ? တတး သာ တမ် ဥဒျာနသေဝကံ ဇ္ဉာတွာ ဝျာဟရတ်, ဟေ မဟေစ္ဆ တွံ ယဒီတး သ္ထာနာတ် တံ နီတဝါန် တရှိ ကုတြာသ္ထာပယသ္တဒ် ဝဒ တတ္သ္ထာနာတ် တမ် အာနယာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","တဒါ ယီၑုသ္တာမ် အဝဒတ် ဟေ မရိယမ်၊ တတး သာ ပရာဝၖတျ ပြတျဝဒတ် ဟေ ရဗ္ဗူနီ အရ္ထာတ် ဟေ ဂုရော၊ ");
INSERT INTO sanbur_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","တဒါ ယီၑုရဝဒတ် မာံ မာ ဓရ, ဣဒါနီံ ပိတုး သမီပေ ဦရ္ဒ္ဓွဂမနံ န ကရောမိ ကိန္တု ယော မမ ယုၐ္မာကဉ္စ ပိတာ မမ ယုၐ္မာကဉ္စေၑွရသ္တသျ နိကဋ ဦရ္ဒ္ဓွဂမနံ ကရ္တ္တုမ် ဥဒျတောသ္မိ, ဣမာံ ကထာံ တွံ ဂတွာ မမ ဘြာတၖဂဏံ ဇ္ဉာပယ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","တတော မဂ္ဒလီနီမရိယမ် တတ္က္ၐဏာဒ် ဂတွာ ပြဘုသ္တသျဲ ဒရ္ၑနံ ဒတ္တွာ ကထာ ဧတာ အကထယဒ် ဣတိ ဝါရ္တ္တာံ ၑိၐျေဘျော'ကထယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","တတး ပရံ သပ္တာဟသျ ပြထမဒိနသျ သန္ဓျာသမယေ ၑိၐျာ ဧကတြ မိလိတွာ ယိဟူဒီယေဘျော ဘိယာ ဒွါရရုဒ္ဓမ် အကုရွွန်, ဧတသ္မိန် ကာလေ ယီၑုသ္တေၐာံ မဓျသ္ထာနေ တိၐ္ဌန် အကထယဒ် ယုၐ္မာကံ ကလျာဏံ ဘူယာတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ဣတျုက္တွာ နိဇဟသ္တံ ကုက္ၐိဉ္စ ဒရ္ၑိတဝါန်, တတး ၑိၐျား ပြဘုံ ဒၖၐ္ဋွာ ဟၖၐ္ဋာ အဘဝန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","ယီၑုး ပုနရဝဒဒ် ယုၐ္မာကံ ကလျာဏံ ဘူယာတ် ပိတာ ယထာ မာံ ပြဲၐယတ် တထာဟမပိ ယုၐ္မာန် ပြေၐယာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ဣတျုက္တွာ သ တေၐာမုပရိ ဒီရ္ဃပြၑွာသံ ဒတ္တွာ ကထိတဝါန် ပဝိတြမ် အာတ္မာနံ ဂၖဟ္လီတ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","ယူယံ ယေၐာံ ပါပါနိ မောစယိၐျထ တေ မောစယိၐျန္တေ ယေၐာဉ္စ ပါပါတိ န မောစယိၐျထ တေ န မောစယိၐျန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","ဒွါဒၑမဓျေ ဂဏိတော ယမဇော ထောမာနာမာ ၑိၐျော ယီၑောရာဂမနကာလဲ တဲး သာရ္ဒ္ဓံ နာသီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","အတော ဝယံ ပြဘူမ် အပၑျာမေတိ ဝါကျေ'နျၑိၐျဲရုက္တေ သောဝဒတ်, တသျ ဟသ္တယော ရ္လော်ဟကီလကာနာံ စိဟ္နံ န ဝိလောကျ တစ္စိဟ္နမ် အင်္ဂုလျာ န သ္ပၖၐ္ဋွာ တသျ ကုက္ၐော် ဟသ္တံ နာရောပျ စာဟံ န ဝိၑွသိၐျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","အပရမ် အၐ္ဋမေ'ဟ္နိ ဂတေ သတိ ထောမာသဟိတး ၑိၐျဂဏ ဧကတြ မိလိတွာ ဒွါရံ ရုဒ္ဓွာဘျန္တရ အာသီတ်, ဧတရှိ ယီၑုသ္တေၐာံ မဓျသ္ထာနေ တိၐ္ဌန် အကထယတ်, ယုၐ္မာကံ ကုၑလံ ဘူယာတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","ပၑ္စာတ် ထာမဲ ကထိတဝါန် တွမ် အင်္ဂုလီမ် အတြာရ္ပယိတွာ မမ ကရော် ပၑျ ကရံ ပြသာရျျ မမ ကုက္ၐာဝရ္ပယ နာဝိၑွသျ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","တဒါ ထောမာ အဝဒတ်, ဟေ မမ ပြဘော ဟေ မဒီၑွရ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","ယီၑုရကထယတ်, ဟေ ထောမာ မာံ နိရီက္ၐျ ဝိၑွသိၐိ ယေ န ဒၖၐ္ဋွာ ဝိၑွသန္တိ တဧဝ ဓနျား၊ ");
INSERT INTO sanbur_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ဧတဒနျာနိ ပုသ္တကေ'သ္မိန် အလိခိတာနိ ဗဟူနျာၑ္စရျျကရ္မ္မာဏိ ယီၑုး ၑိၐျာဏာံ ပုရသ္တာဒ် အကရောတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ကိန္တု ယီၑုရီၑွရသျာဘိၐိက္တး သုတ ဧဝေတိ ယထာ ယူယံ ဝိၑွသိထ ဝိၑွသျ စ တသျ နာမ္နာ ပရမာယုး ပြာပ္နုထ တဒရ္ထမ် ဧတာနိ သရွွာဏျလိချန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","တတး ပရံ တိဗိရိယာဇလဓေသ္တဋေ ယီၑုး ပုနရပိ ၑိၐျေဘျော ဒရ္ၑနံ ဒတ္တဝါန် ဒရ္ၑနသျာချာနမိဒမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ၑိမောန္ပိတရး ယမဇထောမာ ဂါလီလီယကာန္နာနဂရနိဝါသီ နိထနေလ် သိဝဒေး ပုတြာဝနျော် ဒွေါ် ၑိၐျော် စဲတေၐွေကတြ မိလိတေၐု ၑိမောန္ပိတရော'ကထယတ် မတ္သျာန် ဓရ္တုံ ယာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","တတသ္တေ ဝျာဟရန် တရှိ ဝယမပိ တွယာ သာရ္ဒ္ဓံ ယာမး တဒါ တေ ဗဟိရ္ဂတား သန္တး က္ၐိပြံ နာဝမ် အာရောဟန် ကိန္တု တသျာံ ရဇနျာမ် ဧကမပိ န ပြာပ္နုဝန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","ပြဘာတေ သတိ ယီၑုသ္တဋေ သ္ထိတဝါန် ကိန္တု သ ယီၑုရိတိ ၑိၐျာ ဇ္ဉာတုံ နာၑက္နုဝန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","တဒါ ယီၑုရပၖစ္ဆတ်, ဟေ ဝတ္သာ သန္နိဓော် ကိဉ္စိတ် ခါဒျဒြဝျမ် အာသ္တေ? တေ'ဝဒန် ကိမပိ နာသ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","တဒါ သော'ဝဒတ် နော်ကာယာ ဒက္ၐိဏပါရ္ၑွေ ဇာလံ နိက္ၐိပတ တတော လပ္သျဓွေ, တသ္မာတ် တဲ ရ္နိက္ၐိပ္တေ ဇာလေ မတ္သျာ ဧတာဝန္တော'ပတန် ယေန တေ ဇာလမာကၖၐျ နောတ္တောလယိတုံ ၑက္တား၊ ");
INSERT INTO sanbur_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","တသ္မာဒ် ယီၑေား ပြိယတမၑိၐျး ပိတရာယာကထယတ် ဧၐ ပြဘု ရ္ဘဝေတ်, ဧၐ ပြဘုရိတိ ဝါစံ ၑြုတွဲဝ ၑိမောန် နဂ္နတာဟေတော ရ္မတ္သျဓာရိဏ ဥတ္တရီယဝသ္တြံ ပရိဓာယ ဟြဒံ ပြတျုဒလမ္ဖယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","အပရေ ၑိၐျာ မတ္သျဲး သာရ္ဒ္ဓံ ဇာလမ် အာကရ္ၐန္တး က္ၐုဒြနော်ကာံ ဝါဟယိတွာ ကူလမာနယန် တေ ကူလာဒ် အတိဒူရေ နာသန် ဒွိၑတဟသ္တေဘျော ဒူရ အာသန် ဣတျနုမီယတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","တီရံ ပြာပ္တဲသ္တဲသ္တတြ ပြဇွလိတာဂ္နိသ္တဒုပရိ မတ္သျား ပူပါၑ္စ ဒၖၐ္ဋား၊ ");
INSERT INTO sanbur_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","တတော ယီၑုရကထယဒ် ယာန် မတ္သျာန် အဓရတ တေၐာံ ကတိပယာန် အာနယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","အတး ၑိမောန္ပိတရး ပရာဝၖတျ ဂတွာ ဗၖဟဒ္ဘိသ္တြိပဉ္စာၑဒဓိကၑတမတ္သျဲး ပရိပူရ္ဏံ တဇ္ဇာလမ် အာကၖၐျောဒတောလယတ် ကိန္တွေတာဝဒ္ဘိ ရ္မတ္သျဲရပိ ဇာလံ နာဆိဒျတ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","အနန္တရံ ယီၑုသ္တာန် အဝါဒီတ် ယူယမာဂတျ ဘုံဂ္ဓွံ; တဒါ သဧဝ ပြဘုရိတိ ဇ္ဉာတတွာတ် တွံ ကး? ဣတိ ပြၐ္ဋုံ ၑိၐျာဏာံ ကသျာပိ ပြဂလ္ဘတာ နာဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","တတော ယီၑုရာဂတျ ပူပါန် မတ္သျာံၑ္စ ဂၖဟီတွာ တေဘျး ပရျျဝေၐယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ဣတ္ထံ ၑ္မၑာနာဒုတ္ထာနာတ် ပရံ ယီၑုး ၑိၐျေဘျသ္တၖတီယဝါရံ ဒရ္ၑနံ ဒတ္တဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ဘောဇနေ သမာပ္တေ သတိ ယီၑုး ၑိမောန္ပိတရံ ပၖၐ္ဋဝါန်, ဟေ ယူနသး ပုတြ ၑိမောန် တွံ ကိမ် ဧတေဘျောဓိကံ မယိ ပြီယသေ? တတး သ ဥဒိတဝါန် သတျံ ပြဘော တွယိ ပြီယေ'ဟံ တဒ် ဘဝါန် ဇာနာတိ; တဒါ ယီၑုရကထယတ် တရှိ မမ မေၐၑာဝကဂဏံ ပါလယ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","တတး သ ဒွိတီယဝါရံ ပၖၐ္ဋဝါန် ဟေ ယူနသး ပုတြ ၑိမောန် တွံ ကိံ မယိ ပြီယသေ? တတး သ ဥက္တဝါန် သတျံ ပြဘော တွယိ ပြီယေ'ဟံ တဒ် ဘဝါန် ဇာနာတိ; တဒါ ယီၑုရကထယတ တရှိ မမ မေၐဂဏံ ပါလယ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ပၑ္စာတ် သ တၖတီယဝါရံ ပၖၐ္ဋဝါန်, ဟေ ယူနသး ပုတြ ၑိမောန် တွံ ကိံ မယိ ပြီယသေ? ဧတဒွါကျံ တၖတီယဝါရံ ပၖၐ္ဋဝါန် တသ္မာတ် ပိတရော ဒုးခိတော ဘူတွာ'ကထယတ် ဟေ ပြဘော ဘဝတး ကိမပျဂေါစရံ နာသ္တိ တွယျဟံ ပြီယေ တဒ် ဘဝါန် ဇာနာတိ; တတော ယီၑုရဝဒတ် တရှိ မမ မေၐဂဏံ ပါလယ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","အဟံ တုဘျံ ယထာရ္ထံ ကထယာမိ ယော်ဝနကာလေ သွယံ ဗဒ္ဓကဋိ ရျတြေစ္ဆာ တတြ ယာတဝါန် ကိန္တွိတး ပရံ ဝၖဒ္ဓေ ဝယသိ ဟသ္တံ ဝိသ္တာရယိၐျသိ, အနျဇနသ္တွာံ ဗဒ္ဓွာ ယတြ ဂန္တုံ တဝေစ္ဆာ န ဘဝတိ တွာံ ဓၖတွာ တတြ နေၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ဖလတး ကီဒၖၑေန မရဏေန သ ဤၑွရသျ မဟိမာနံ ပြကာၑယိၐျတိ တဒ် ဗောဓယိတုံ သ ဣတိ ဝါကျံ ပြောက္တဝါန်၊ ဣတျုက္တေ သတိ သ တမဝေါစတ် မမ ပၑ္စာဒ် အာဂစ္ဆ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","ယော ဇနော ရာတြိကာလေ ယီၑော ရွက္ၐော'ဝလမ္ဗျ, ဟေ ပြဘော ကော ဘဝန္တံ ပရကရေၐု သမရ္ပယိၐျတီတိ ဝါကျံ ပၖၐ္ဋဝါန်, တံ ယီၑေား ပြိယတမၑိၐျံ ပၑ္စာဒ် အာဂစ္ဆန္တံ ");
INSERT INTO sanbur_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ပိတရော မုခံ ပရာဝရ္တ္တျ ဝိလောကျ ယီၑုံ ပၖၐ္ဋဝါန်, ဟေ ပြဘော ဧတသျ မာနဝသျ ကီဒၖၑီ ဂတိ ရ္ဘဝိၐျတိ? ");
INSERT INTO sanbur_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","သ ပြတျဝဒတ်, မမ ပုနရာဂမနပရျျန္တံ ယဒိ တံ သ္ထာပယိတုမ် ဣစ္ဆာမိ တတြ တဝ ကိံ? တွံ မမ ပၑ္စာဒ် အာဂစ္ဆ၊ ");
INSERT INTO sanbur_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","တသ္မာတ် သ ၑိၐျော န မရိၐျတီတိ ဘြာတၖဂဏမဓျေ ကိံဝဒန္တီ ဇာတာ ကိန္တု သ န မရိၐျတီတိ ဝါကျံ ယီၑု ရ္နာဝဒတ် ကေဝလံ မမ ပုနရာဂမနပရျျန္တံ ယဒိ တံ သ္ထာပယိတုမ် ဣစ္ဆာမိ တတြ တဝ ကိံ? ဣတိ ဝါကျမ် ဥက္တဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","ယော ဇန ဧတာနိ သရွွာဏိ လိခိတဝါန် အတြ သာက္ၐျဉ္စ ဒတ္တဝါန် သဧဝ သ ၑိၐျး, တသျ သာက္ၐျံ ပြမာဏမိတိ ဝယံ ဇာနီမး၊ ");
INSERT INTO sanbur_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","ယီၑုရေတေဘျော'ပရာဏျပိ ဗဟူနိ ကရ္မ္မာဏိ ကၖတဝါန် တာနိ သရွွာဏိ ယဒျေကဲကံ ကၖတွာ လိချန္တေ တရှိ ဂြန္ထာ ဧတာဝန္တော ဘဝန္တိ တေၐာံ ဓာရဏေ ပၖထိဝျာံ သ္ထာနံ န ဘဝတိ၊ ဣတိ။ ");
INSERT INTO sanbur_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","ဟေ ထိယဖိလ, ယီၑုး သွမနောနီတာန် ပြေရိတာန် ပဝိတြေဏာတ္မနာ သမာဒိၑျ ယသ္မိန် ဒိနေ သွရ္ဂမာရောဟတ် ယာံ ယာံ ကြိယာမကရောတ် ယဒျဒ် ဥပါဒိၑစ္စ တာနိ သရွွာဏိ ပူရွွံ မယာ လိခိတာနိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","သ သွနိဓနဒုးခဘောဂါတ် ပရမ် အနေကပြတျယက္ၐပြမာဏော်း သွံ သဇီဝံ ဒရ္ၑယိတွာ ");
INSERT INTO sanbur_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","စတွာရိံၑဒ္ဒိနာနိ ယာဝတ် တေဘျး ပြေရိတေဘျော ဒရ္ၑနံ ဒတ္တွေၑွရီယရာဇျသျ ဝရ္ဏနမ အကရောတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","အနန္တရံ တေၐာံ သဘာံ ကၖတွာ ဣတျာဇ္ဉာပယတ်, ယူယံ ယိရူၑာလမော'နျတြ ဂမနမကၖတွာ ယသ္တိန် ပိတြာင်္ဂီကၖတေ မမ ဝဒနာတ် ကထာ အၑၖဏုတ တတ္ပြာပ္တိမ် အပေက္ၐျ တိၐ္ဌတ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","ယောဟန် ဇလေ မဇ္ဇိတာဝါန် ကိန္တွလ္ပဒိနမဓျေ ယူယံ ပဝိတြ အာတ္မနိ မဇ္ဇိတာ ဘဝိၐျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","ပၑ္စာတ် တေ သရွွေ မိလိတွာ တမ် အပၖစ္ဆန် ဟေ ပြဘော ဘဝါန် ကိမိဒါနီံ ပုနရပိ ရာဇျမ် ဣသြာယေလီယလောကာနာံ ကရေၐု သမရ္ပယိၐျတိ? ");
INSERT INTO sanbur_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","တတး သောဝဒတ် ယာန် သရွွာန် ကာလာန် သမယာံၑ္စ ပိတာ သွဝၑေ'သ္ထာပယတ် တာန် ဇ္ဉာတၖံ ယုၐ္မာကမ် အဓိကာရော န ဇာယတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","ကိန္တု ယုၐ္မာသု ပဝိတြသျာတ္မန အာဝိရ္ဘာဝေ သတိ ယူယံ ၑက္တိံ ပြာပျ ယိရူၑာလမိ သမသ္တယိဟူဒါၑောမိရောဏဒေၑယေား ပၖထိဝျား သီမာံ ယာဝဒ် ယာဝန္တော ဒေၑာသ္တေၐု ယရွွေၐု စ မယိ သာက္ၐျံ ဒါသျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ဣတိ ဝါကျမုက္တွာ သ တေၐာံ သမက္ၐံ သွရ္ဂံ နီတော'ဘဝတ်, တတော မေဃမာရုဟျ တေၐာံ ဒၖၐ္ဋေရဂေါစရော'ဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ယသ္မိန် သမယေ တေ ဝိဟာယသံ ပြတျနနျဒၖၐ္ဋျာ တသျ တာဒၖၑမ် ဦရ္ဒွွဂမနမ် အပၑျန် တသ္မိန္နေဝ သမယေ ၑုက္လဝသ္တြော် ဒွေါ် ဇနော် တေၐာံ သန္နိဓော် ဒဏ္ဍာယမာနော် ကထိတဝန္တော်, ");
INSERT INTO sanbur_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ဟေ ဂါလီလီယလောကာ ယူယံ ကိမရ္ထံ ဂဂဏံ ပြတိ နိရီက္ၐျ ဒဏ္ဍာယမာနာသ္တိၐ္ဌထ? ယုၐ္မာကံ သမီပါတ် သွရ္ဂံ နီတော ယော ယီၑုသ္တံ ယူယံ ယထာ သွရ္ဂမ် အာရောဟန္တမ် အဒရ္ၑမ် တထာ သ ပုနၑ္စာဂမိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","တတး ပရံ တေ ဇဲတုနနာမ္နး ပရွွတာဒ် ဝိၑြာမဝါရသျ ပထး ပရိမာဏမ် အရ္ထာတ် ပြာယေဏာရ္ဒ္ဓကြောၑံ ဒုရသ္ထံ ယိရူၑာလမ္နဂရံ ပရာဝၖတျာဂစ္ဆန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","နဂရံ ပြဝိၑျ ပိတရော ယာကူဗ် ယောဟန် အာန္ဒြိယး ဖိလိပး ထောမာ ဗရ္ထဇမယော မထိရာလ္ဖီယပုတြော ယာကူဗ် ဥဒျောဂါी ၑိမောန် ယာကူဗော ဘြာတာ ယိဟူဒါ ဧတေ သရွွေ ယတြ သ္ထာနေ ပြဝသန္တိ တသ္မိန် ဥပရိတနပြကောၐ္ဌေ ပြာဝိၑန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","ပၑ္စာဒ် ဣမေ ကိယတျး သ္တြိယၑ္စ ယီၑော ရ္မာတာ မရိယမ် တသျ ဘြာတရၑ္စဲတေ သရွွ ဧကစိတ္တီဘူတ သတတံ ဝိနယေန ဝိနယေန ပြာရ္ထယန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","တသ္မိန် သမယေ တတြ သ္ထာနေ သာကလျေန ဝိံၑတျဓိကၑတံ ၑိၐျာ အာသန်၊ တတး ပိတရသ္တေၐာံ မဓျေ တိၐ္ဌန် ဥက္တဝါန္ ");
INSERT INTO sanbur_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","ဟေ ဘြာတၖဂဏ ယီၑုဓာရိဏာံ လောကာနာံ ပထဒရ္ၑကော ယော ယိဟူဒါသ္တသ္မိန် ဒါယူဒါ ပဝိတြ အာတ္မာ ယာံ ကထာံ ကထယာမာသ တသျား ပြတျက္ၐီဘဝနသျာဝၑျကတွမ် အာသီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","သ ဇနော'သ္မာကံ မဓျဝရ္တ္တီ သန် အသျား သေဝါယာ အံၑမ် အလဘတ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","တဒနန္တရံ ကုကရ္မ္မဏာ လဗ္ဓံ ယန္မူလျံ တေန က္ၐေတြမေကံ ကြီတမ် အပရံ တသ္မိန် အဓောမုခေ ဘၖမော် ပတိတေ သတိ တသျောဒရသျ ဝိဒီရ္ဏတွာတ် သရွွာ နာဍျော နိရဂစ္ဆန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ဧတာံ ကထာံ ယိရူၑာလမ္နိဝါသိနး သရွွေ လောကာ ဝိဒါန္တိ; တေၐာံ နိဇဘာၐယာ တတ္က္ၐေတြဉ္စ ဟကလ္ဒာမာ, အရ္ထာတ် ရက္တက္ၐေတြမိတိ ဝိချာတမာသ္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","အနျစ္စ, နိကေတနံ တဒီယန္တု ၑုနျမေဝ ဘဝိၐျတိ၊ တသျ ဒူၐျေ နိဝါသာရ္ထံ ကောပိ သ္ထာသျတိ နဲဝ ဟိ၊ အနျ ဧဝ ဇနသ္တသျ ပဒံ သံပြာပ္သျတိ ဓြုဝံ၊ ဣတ္ထံ ဂီတပုသ္တကေ လိခိတမာသ္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","အတော ယောဟနော မဇ္ဇနမ် အာရဘျာသ္မာကံ သမီပါတ် ပြဘော ရျီၑေား သွရ္ဂာရောဟဏဒိနံ ယာဝတ် သောသ္မာကံ မဓျေ ယာဝန္တိ ဒိနာနိ ယာပိတဝါန္ ");
INSERT INTO sanbur_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","တာဝန္တိ ဒိနာနိ ယေ မာနဝါ အသ္မာဘိး သာရ္ဒ္ဓံ တိၐ္ဌန္တိ တေၐာမ် ဧကေန ဇနေနာသ္မာဘိး သာရ္ဒ္ဓံ ယီၑောရုတ္ထာနေ သာက္ၐိဏာ ဘဝိတဝျံ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","အတော ယသျ ရူဎိ ရျုၐ္ဋော ယံ ဗရ္ၑဗ္ဗေတျုက္တွာဟူယန္တိ သ ယူၐဖ် မတထိၑ္စ ဒွါဝေတော် ပၖထက် ကၖတွာ တ ဤၑွရသျ သန္နိဓော် ပြာရျျ ကထိတဝန္တး, ");
INSERT INTO sanbur_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","ဟေ သရွွာန္တရျျာမိန် ပရမေၑွရ, ယိဟူဒါး သေဝနပြေရိတတွပဒစျုတး ");
INSERT INTO sanbur_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","သန် နိဇသ္ထာနမ် အဂစ္ဆတ်, တတ္ပဒံ လဗ္ဓုမ် ဧနယော ရ္ဇနယော ရ္မဓျေ ဘဝတာ ကော'ဘိရုစိတသ္တဒသ္မာန် ဒရ္ၑျတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","တတော ဂုဋိကာပါဋေ ကၖတေ မတထိရ္နိရစီယတ တသ္မာတ် သောနျေၐာမ် ဧကာဒၑာနာံ ပြရိတာနာံ မဓျေ ဂဏိတောဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","အပရဉ္စ နိသ္တာရောတ္သဝါတ် ပရံ ပဉ္စာၑတ္တမေ ဒိနေ သမုပသ္ထိတေ သတိ တေ သရွွေ ဧကာစိတ္တီဘူယ သ္ထာန ဧကသ္မိန် မိလိတာ အာသန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ဧတသ္မိန္နေဝ သမယေ'ကသ္မာဒ် အာကာၑာတ် ပြစဏ္ဍာတျုဂြဝါယေား ၑဗ္ဒဝဒ် ဧကး ၑဗ္ဒ အာဂတျ ယသ္မိန် ဂၖဟေ တ ဥပါဝိၑန် တဒ် ဂၖဟံ သမသ္တံ ဝျာပ္နောတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","တတး ပရံ ဝဟ္နိၑိခါသွရူပါ ဇိဟွား ပြတျက္ၐီဘူယ ဝိဘက္တား သတျး ပြတိဇနောရ္ဒ္ဓွေ သ္ထဂိတာ အဘူဝန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","တသ္မာတ် သရွွေ ပဝိတြေဏာတ္မနာ ပရိပူရ္ဏား သန္တ အာတ္မာ ယထာ ဝါစိတဝါန် တဒနုသာရေဏာနျဒေၑီယာနာံ ဘာၐာ ဥက္တဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","တသ္မိန် သမယေ ပၖထိဝီသ္ထသရွွဒေၑေဘျော ယိဟူဒီယမတာဝလမ္ဗိနော ဘက္တလောကာ ယိရူၑာလမိ ပြာဝသန်; ");
INSERT INTO sanbur_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","တသျား ကထာယား ကိံဝဒန္တျာ ဇာတတွာတ် သရွွေ လောကာ မိလိတွာ နိဇနိဇဘာၐယာ ၑိၐျာဏာံ ကထာကထနံ ၑြုတွာ သမုဒွိဂ္နာ အဘဝန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","သရွွဧဝ ဝိသ္မယာပန္နာ အာၑ္စရျျာနွိတာၑ္စ သန္တး ပရသ္ပရံ ဥက္တဝန္တး ပၑျတ ယေ ကထာံ ကထယန္တိ တေ သရွွေ ဂါလီလီယလောကား ကိံ န ဘဝန္တိ? ");
INSERT INTO sanbur_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","တရှိ ဝယံ ပြတျေကၑး သွသွဇန္မဒေၑီယဘာၐာဘိး ကထာ ဧတေၐာံ ၑၖဏုမး ကိမိဒံ? ");
INSERT INTO sanbur_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","ပါရ္ထီ-မာဒီ-အရာမ္နဟရယိမ္ဒေၑနိဝါသိမနော ယိဟူဒါ-ကပ္ပဒကိယာ-ပန္တ-အာၑိယာ- ");
INSERT INTO sanbur_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ဖြုဂိယာ-ပမ္ဖုလိယာ-မိသရနိဝါသိနး ကုရီဏီနိကဋဝရ္တ္တိလူဗီယပြဒေၑနိဝါသိနော ရောမနဂရာဒ် အာဂတာ ယိဟူဒီယလောကာ ယိဟူဒီယမတဂြာဟိဏး ကြီတီယာ အရာဗီယာဒယော လောကာၑ္စ ယေ ဝယမ္ ");
INSERT INTO sanbur_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","အသ္မာကံ နိဇနိဇဘာၐာဘိရေတေၐာမ် ဤၑွရီယမဟာကရ္မ္မဝျာချာနံ ၑၖဏုမး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ဣတ္ထံ တေ သရွွဧဝ ဝိသ္မယာပန္နား သန္ဒိဂ္ဓစိတ္တား သန္တး ပရသ္ပရမူစုး, အသျ ကော ဘာဝး? ");
INSERT INTO sanbur_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","အပရေ ကေစိတ် ပရိဟသျ ကထိတဝန္တ ဧတေ နဝီနဒြာက္ၐာရသေန မတ္တာ အဘဝန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","တဒါ ပိတရ ဧကာဒၑဘိ ရ္ဇနဲး သာကံ တိၐ္ဌန် တာလ္လောကာန် ဥစ္စဲးကာရမ် အဝဒတ်, ဟေ ယိဟူဒီယာ ဟေ ယိရူၑာလမ္နိဝါသိနး သရွွေ, အဝဓာနံ ကၖတွာ မဒီယဝါကျံ ဗုဓျဓွံ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ဣဒါနီမ် ဧကယာမာဒ် အဓိကာ ဝေလာ နာသ္တိ တသ္မာဒ် ယူယံ ယဒ် အနုမာထ မာနဝါ ဣမေ မဒျပါနေန မတ္တာသ္တန္န၊ ");
INSERT INTO sanbur_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","ကိန္တု ယောယေလ္ဘဝိၐျဒွက္တြဲတဒွါကျမုက္တံ ယထာ, ");
INSERT INTO sanbur_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","ဤၑွရး ကထယာမာသ ယုဂါန္တသမယေ တွဟမ်၊ ဝရ္ၐိၐျာမိ သွမာတ္မာနံ သရွွပြာဏျုပရိ ဓြုဝမ်၊ ဘာဝိဝါကျံ ဝဒိၐျန္တိ ကနျား ပုတြာၑ္စ ဝသ္တုတး၊ ပြတျာဒေၑဉ္စ ပြာပ္သျန္တိ ယုၐ္မာကံ ယုဝမာနဝါး၊ တထာ ပြာစီနလောကာသ္တု သွပ္နာန် ဒြက္ၐျန္တိ နိၑ္စိတံ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","ဝရ္ၐိၐျာမိ တဒါတ္မာနံ ဒါသဒါသီဇနောပိရိ၊ တေနဲဝ ဘာဝိဝါကျံ တေ ဝဒိၐျန္တိ ဟိ သရွွၑး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ဦရ္ဒ္ဓွသ္ထေ ဂဂဏေ စဲဝ နီစသ္ထေ ပၖထိဝီတလေ၊ ၑောဏိတာနိ ဗၖဟဒ္ဘါနူန် ဃနဓူမာဒိကာနိ စ၊ စိဟ္နာနိ ဒရ္ၑယိၐျာမိ မဟာၑ္စရျျကြိယာသ္တထာ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","မဟာဘယာနကသျဲဝ တဒ္ဒိနသျ ပရေၑိတုး၊ ပုရာဂမာဒ် ရဝိး ကၖၐ္ဏော ရက္တၑ္စန္ဒြော ဘဝိၐျတး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","ကိန္တု ယး ပရမေၑသျ နာမ္နိ သမ္ပြာရ္ထယိၐျတေ၊ သဧဝ မနုဇော နူနံ ပရိတြာတော ဘဝိၐျတိ။ ");
INSERT INTO sanbur_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","အတော ဟေ ဣသြာယေလွံၑီယလောကား သရွွေ ကထာယာမေတသျာမ် မနော နိဓဒ္ဓွံ နာသရတီယော ယီၑုရီၑွရသျ မနောနီတး ပုမာန် ဧတဒ် ဤၑွရသ္တတ္ကၖတဲရာၑ္စရျျာဒ္ဘုတကရ္မ္မဘိ ရ္လက္ၐဏဲၑ္စ ယုၐ္မာကံ သာက္ၐာဒေဝ ပြတိပါဒိတဝါန် ဣတိ ယူယံ ဇာနီထ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","တသ္မိန် ယီၑော် ဤၑွရသျ ပူရွွနိၑ္စိတမန္တြဏာနိရူပဏာနုသာရေဏ မၖတျော် သမရ္ပိတေ သတိ ယူယံ တံ ဓၖတွာ ဒုၐ္ဋလောကာနာံ ဟသ္တဲး ကြုၑေ ဝိဓိတွာဟတ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","ကိန္တွီၑွရသ္တံ နိဓနသျ ဗန္ဓနာန္မောစယိတွာ ဥဒသ္ထာပယတ် ယတး သ မၖတျုနာ ဗဒ္ဓသ္တိၐ္ဌတီတိ န သမ္ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ဧတသ္တိန် ဒါယူဒပိ ကထိတဝါန် ယထာ, သရွွဒါ မမ သာက္ၐာတ္တံ သ္ထာပယ ပရမေၑွရံ၊ သ္ထိတေ မဒ္ဒက္ၐိဏေ တသ္မိန် သ္ခလိၐျာမိ တွဟံ နဟိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","အာနန္ဒိၐျတိ တဒ္ဓေတော ရ္မာမကီနံ မနသ္တု ဝဲ၊ အာဟ္လာဒိၐျတိ ဇိဟွာပိ မဒီယာ တု တထဲဝ စ၊ ပြတျာၑယာ ၑရီရန္တု မဒီယံ ဝဲၑယိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ပရလောကေ ယတော ဟေတောသ္တွံ မာံ နဲဝ ဟိ တျက္ၐျသိ၊ သွကီယံ ပုဏျဝန္တံ တွံ က္ၐယိတုံ နဲဝ ဒါသျသိ၊ ဧဝံ ဇီဝနမာရ္ဂံ တွံ မာမေဝ ဒရ္ၑယိၐျသိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","သွသမ္မုခေ ယ အာနန္ဒော ဒက္ၐိဏေ သွသျ ယတ် သုခံ၊ အနန္တံ တေန မာံ ပူရ္ဏံ ကရိၐျသိ န သံၑယး။ ");
INSERT INTO sanbur_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","ဟေ ဘြာတရော'သ္မာကံ တသျ ပူရွွပုရုၐသျ ဒါယူဒး ကထာံ သ္ပၐ္ဋံ ကထယိတုံ မာမ် အနုမနျဓွံ, သ ပြာဏာန် တျက္တွာ ၑ္မၑာနေ သ္ထာပိတောဘဝဒ် အဒျာပိ တတ် ၑ္မၑာနမ် အသ္မာကံ သန္နိဓော် ဝိဒျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","ဖလတော လော်ကိကဘာဝေန ဒါယူဒေါ ဝံၑေ ခြီၐ္ဋံ ဇန္မ ဂြာဟယိတွာ တသျဲဝ သိံဟာသနေ သမုဝေၐ္ဋုံ တမုတ္ထာပယိၐျတိ ပရမေၑွရး ၑပထံ ကုတွာ ဒါယူဒး သမီပ ဣမမ် အင်္ဂီကာရံ ကၖတဝါန်, ");
INSERT INTO sanbur_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ဣတိ ဇ္ဉာတွာ ဒါယူဒ် ဘဝိၐျဒွါဒီ သန် ဘဝိၐျတ္ကာလီယဇ္ဉာနေန ခြီၐ္ဋောတ္ထာနေ ကထာမိမာံ ကထယာမာသ ယထာ တသျာတ္မာ ပရလောကေ န တျက္ၐျတေ တသျ ၑရီရဉ္စ န က္ၐေၐျတိ; ");
INSERT INTO sanbur_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","အတး ပရမေၑွရ ဧနံ ယီၑုံ ၑ္မၑာနာဒ် ဥဒသ္ထာပယတ် တတြ ဝယံ သရွွေ သာက္ၐိဏ အာသ္မဟေ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","သ ဤၑွရသျ ဒက္ၐိဏကရေဏောန္နတိံ ပြာပျ ပဝိတြ အာတ္မိန ပိတာ ယမင်္ဂီကာရံ ကၖတဝါန် တသျ ဖလံ ပြာပျ ယတ် ပၑျထ ၑၖဏုထ စ တဒဝရ္ၐတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","ယတော ဒါယူဒ် သွရ္ဂံ နာရုရောဟ ကိန္တု သွယမ် ဣမာံ ကထာမ် အကထယဒ် ယထာ, မမ ပြဘုမိဒံ ဝါကျမဝဒတ် ပရမေၑွရး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","တဝ ၑတြူနဟံ ယာဝတ် ပါဒပီဌံ ကရောမိ န၊ တာဝတ် ကာလံ မဒီယေ တွံ ဒက္ၐဝါရ္ၑွ ဥပါဝိၑ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","အတော ယံ ယီၑုံ ယူယံ ကြုၑေ'ဟတ ပရမေၑွရသ္တံ ပြဘုတွာဘိၐိက္တတွပဒေ နျယုံက္တေတိ ဣသြာယေလီယာ လောကာ နိၑ္စိတံ ဇာနန္တု၊ ");
INSERT INTO sanbur_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ဧတာဒၖၑီံ ကထာံ ၑြုတွာ တေၐာံ ဟၖဒယာနာံ ဝိဒီရ္ဏတွာတ် တေ ပိတရာယ တဒနျပြေရိတေဘျၑ္စ ကထိတဝန္တး, ဟေ ဘြာတၖဂဏ ဝယံ ကိံ ကရိၐျာမး? ");
INSERT INTO sanbur_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","တတး ပိတရး ပြတျဝဒဒ် ယူယံ သရွွေ သွံ သွံ မနး ပရိဝရ္တ္တယဓွံ တထာ ပါပမောစနာရ္ထံ ယီၑုခြီၐ္ဋသျ နာမ္နာ မဇ္ဇိတာၑ္စ ဘဝတ, တသ္မာဒ် ဒါနရူပံ ပရိတြမ် အာတ္မာနံ လပ္သျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","ယတော ယုၐ္မာကံ ယုၐ္မတ္သန္တာနာနာဉ္စ ဒူရသ္ထသရွွလောကာနာဉ္စ နိမိတ္တမ် အရ္ထာဒ် အသ္မာကံ ပြဘုး ပရမေၑွရော ယာဝတော လာကာန် အာဟွာသျတိ တေၐာံ သရွွေၐာံ နိမိတ္တမ် အယမင်္ဂီကာရ အာသ္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ဧတဒနျာဘိ ရ္ဗဟုကထာဘိး ပြမာဏံ ဒတွာကထယတ် ဧတေဘျော ဝိပထဂါမိဘျော ဝရ္တ္တမာနလောကေဘျး သွာန် ရက္ၐတ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","တတး ပရံ ယေ သာနန္ဒာသ္တာံ ကထာမ် အဂၖဟ္လန် တေ မဇ္ဇိတာ အဘဝန်၊ တသ္မိန် ဒိဝသေ ပြာယေဏ တြီဏိ သဟသြာဏိ လောကာသ္တေၐာံ သပက္ၐား သန္တး ");
INSERT INTO sanbur_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ပြေရိတာနာမ် ဥပဒေၑေ သင်္ဂတော် ပူပဘဉ္ဇနေ ပြာရ္ထနာသု စ မနးသံယောဂံ ကၖတွာတိၐ္ဌန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","ပြေရိတဲ ရ္နာနာပြကာရလက္ၐဏေၐု မဟာၑ္စရျျကရ္မမသု စ ဒရ္ၑိတေၐု သရွွလောကာနာံ ဘယမုပသ္ထိတံ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","ဝိၑွာသကာရိဏး သရွွ စ သဟ တိၐ္ဌနတး၊ သွေၐာံ သရွွား သမ္ပတ္တီး သာဓာရဏျေန သ္ထာပယိတွာဘုဉ္ဇတ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ဖလတော ဂၖဟာဏိ ဒြဝျာဏိ စ သရွွာဏိ ဝိကြီယ သရွွေၐာံ သွသွပြယောဇနာနုသာရေဏ ဝိဘဇျ သရွွေဘျော'ဒဒန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","သရွွ ဧကစိတ္တီဘူယ ဒိနေ ဒိနေ မန္ဒိရေ သန္တိၐ္ဌမာနာ ဂၖဟေ ဂၖဟေ စ ပူပါနဘဉ္ဇန္တ ဤၑွရသျ ဓနျဝါဒံ ကုရွွန္တော လောကဲး သမာဒၖတား ပရမာနန္ဒေန သရလာန္တးကရဏေန ဘောဇနံ ပါနဉ္စကုရွွန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ပရမေၑွရော ဒိနေ ဒိနေ ပရိတြာဏဘာဇနဲ ရ္မဏ္ဍလီမ် အဝရ္ဒ္ဓယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","တၖတီယယာမဝေလာယာံ သတျာံ ပြာရ္ထနာယား သမယေ ပိတရယောဟနော် သမ္ဘူယ မန္ဒိရံ ဂစ္ဆတး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","တသ္မိန္နေဝ သမယေ မန္ဒိရပြဝေၑကာနာံ သမီပေ ဘိက္ၐာရဏာရ္ထံ ယံ ဇန္မခဉ္ဇမာနုၐံ လောကာ မန္ဒိရသျ သုန္ဒရနာမ္နိ ဒွါရေ ပြတိဒိနမ် အသ္ထာပယန် တံ ဝဟန္တသ္တဒွါရံ အာနယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","တဒါ ပိတရယောဟနော် မန္တိရံ ပြဝေၐ္ဋုမ် ဥဒျတော် ဝိလောကျ သ ခဉ္ဇသ္တော် ကိဉ္စိဒ် ဘိက္ၐိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","တသ္မာဒ် ယောဟနာ သဟိတး ပိတရသ္တမ် အနနျဒၖၐ္ဋျာ နိရီက္ၐျ ပြောက္တဝါန် အာဝါံ ပြတိ ဒၖၐ္ဋိံ ကုရု၊ ");
INSERT INTO sanbur_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","တတး သ ကိဉ္စိတ် ပြာပ္တျာၑယာ တော် ပြတိ ဒၖၐ္ဋိံ ကၖတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","တဒါ ပိတရော ဂဒိတဝါန် မမ နိကဋေ သွရ္ဏရူပျာဒိ ကိမပိ နာသ္တိ ကိန္တု ယဒါသ္တေ တဒ် ဒဒါမိ နာသရတီယသျ ယီၑုခြီၐ္ဋသျ နာမ္နာ တွမုတ္ထာယ ဂမနာဂမနေ ကုရု၊ ");
INSERT INTO sanbur_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","တတး ပရံ သ တသျ ဒက္ၐိဏကရံ ဓၖတွာ တမ် ဥဒတောလယတ်; တေန တတ္က္ၐဏာတ် တသျ ဇနသျ ပါဒဂုလ္ဖယေား သဗလတွာတ် သ ဥလ္လမ္ဖျ ပြောတ္ထာယ ဂမနာဂမနေ 'ကရောတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","တတော ဂမနာဂမနေ ကုရွွန် ဥလ္လမ္ဖန် ဤၑွရံ ဓနျံ ဝဒန် တာဘျာံ သာရ္ဒ္ဓံ မန္ဒိရံ ပြာဝိၑတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","တတး သရွွေ လောကာသ္တံ ဂမနာဂမနေ ကုရွွန္တမ် ဤၑွရံ ဓနျံ ဝဒန္တဉ္စ ဝိလောကျ ");
INSERT INTO sanbur_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","မန္ဒိရသျ သုန္ဒရေ ဒွါရေ ယ ဥပဝိၑျ ဘိက္ၐိတဝါန် သဧဝါယမ် ဣတိ ဇ္ဉာတွာ တံ ပြတိ တယာ ဃဋနယာ စမတ္ကၖတာ ဝိသ္မယာပန္နာၑ္စာဘဝန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","ယး ခဉ္ဇး သွသ္ထောဘဝတ် တေန ပိတရယောဟနေား ကရယောရ္ဓ္ဋတယေား သတေား သရွွေ လောကာ သန္နိဓိမ် အာဂစ္ဆန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","တဒ် ဒၖၐ္ဋွာ ပိတရသ္တေဘျော'ကထယတ်, ဟေ ဣသြာယေလီယလောကာ ယူယံ ကုတော 'နေနာၑ္စရျျံ မနျဓွေ? အာဝါံ နိဇၑက္တျာ ယဒွါ နိဇပုဏျေန ခဉ္ဇမနုၐျမေနံ ဂမိတဝန္တာဝိတိ စိန္တယိတွာ အာဝါံ ပြတိ ကုတော'နနျဒၖၐ္ဋိံ ကုရုထ? ");
INSERT INTO sanbur_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","ယံ ယီၑုံ ယူယံ ပရကရေၐု သမာရ္ပယတ တတော ယံ ပီလာတော မောစယိတုမ် ဧैစ္ဆတ် တထာပိ ယူယံ တသျ သာက္ၐာန် နာင်္ဂီကၖတဝန္တ ဣဗြာဟီမ ဣသှာကော ယာကူဗၑ္စေၑွရော'ရ္ထာဒ် အသ္မာကံ ပူရွွပုရုၐာဏာမ် ဤၑွရး သွပုတြသျ တသျ ယီၑော ရ္မဟိမာနံ ပြာကာၑယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","ကိန္တု ယူယံ တံ ပဝိတြံ ဓာရ္မ္မိကံ ပုမာံသံ နာင်္ဂီကၖတျ ဟတျာကာရိဏမေကံ သွေဘျော ဒါတုမ် အယာစဓွံ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ပၑ္စာတ် တံ ဇီဝနသျာဓိပတိမ် အဟတ ကိန္တွီၑွရး ၑ္မၑာနာတ် တမ် ဥဒသ္ထာပယတ တတြ ဝယံ သာက္ၐိဏ အာသ္မဟေ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ဣမံ ယံ မာနုၐံ ယူယံ ပၑျထ ပရိစိနုထ စ သ တသျ နာမ္နိ ဝိၑွာသကရဏာတ် စလနၑက္တိံ လဗ္ဓဝါန် တသ္မိန် တသျ ယော ဝိၑွာသး သ တံ ယုၐ္မာကံ သရွွေၐာံ သာက္ၐာတ် သမ္ပူရ္ဏရူပေဏ သွသ္ထမ် အကာရ္ၐီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","ဟေ ဘြာတရော ယူယံ ယုၐ္မာကမ် အဓိပတယၑ္စ အဇ္ဉာတွာ ကရ္မ္မာဏျေတာနိ ကၖတဝန္တ ဣဒါနီံ မမဲၐ ဗောဓော ဇာယတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","ကိန္တွီၑွရး ခြီၐ္ဋသျ ဒုးခဘောဂေ ဘဝိၐျဒွါဒိနာံ မုခေဘျော ယာံ ယာံ ကထာံ ပူရွွမကထယတ် တား ကထာ ဣတ္ထံ သိဒ္ဓါ အကရောတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","အတး သွေၐာံ ပါပမောစနာရ္ထံ ခေဒံ ကၖတွာ မနာံသိ ပရိဝရ္တ္တယဓွံ, တသ္မာဒ် ဤၑွရာတ် သာန္တွနာပြာပ္တေး သမယ ဥပသ္ထာသျတိ; ");
INSERT INTO sanbur_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ပုနၑ္စ ပူရွွကာလမ် အာရဘျ ပြစာရိတော ယော ယီၑုခြီၐ္ဋသ္တမ် ဤၑွရော ယုၐ္မာန် ပြတိ ပြေၐယိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","ကိန္တု ဇဂတး သၖၐ္ဋိမာရဘျ ဤၑွရော နိဇပဝိတြဘဝိၐျဒွါဒိဂဏောန ယထာ ကထိတဝါန် တဒနုသာရေဏ သရွွေၐာံ ကာရျျာဏာံ သိဒ္ဓိပရျျန္တံ တေန သွရ္ဂေ ဝါသး ကရ္တ္တဝျး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","ယုၐ္မာကံ ပြဘုး ပရမေၑွရော ယုၐ္မာကံ ဘြာတၖဂဏမဓျာတ် မတ္သဒၖၑံ ဘဝိၐျဒွက္တာရမ် ဥတ္ပာဒယိၐျတိ, တတး သ ယတ် ကိဉ္စိတ် ကထယိၐျတိ တတြ ယူယံ မနာံသိ နိဓဒ္ဓွံ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","ကိန္တု ယး ကၑ္စိတ် ပြာဏီ တသျ ဘဝိၐျဒွါဒိနး ကထာံ န ဂြဟီၐျတိ သ နိဇလောကာနာံ မဓျာဒ် ဥစ္ဆေတ္သျတေ,\" ဣမာံ ကထာမ် အသ္မာကံ ပူရွွပုရုၐေဘျး ကေဝလော မူသား ကထယာမာသ ဣတိ နဟိ, ");
INSERT INTO sanbur_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","ၑိမူယေလ္ဘဝိၐျဒွါဒိနမ် အာရဘျ ယာဝန္တော ဘဝိၐျဒွါကျမ် အကထယန် တေ သရွွဧဝ သမယသျဲတသျ ကထာမ် အကထယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","ယူယမပိ တေၐာံ ဘဝိၐျဒွါဒိနာံ သန္တာနား, \"တဝ ဝံၑောဒ္ဘဝပုံသာ သရွွဒေၑီယာ လောကာ အာၑိၐံ ပြာပ္တာ ဘဝိၐျန္တိ\", ဣဗြာဟီမေ ကထာမေတာံ ကထယိတွာ ဤၑွရောသ္မာကံ ပူရွွပုရုၐဲး သာရ္ဒ္ဓံ ယံ နိယမံ သ္ထိရီကၖတဝါန် တသျ နိယမသျာဓိကာရိဏောပိ ယူယံ ဘဝထ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","အတ ဤၑွရော နိဇပုတြံ ယီၑုမ် ဥတ္ထာပျ ယုၐ္မာကံ သရွွေၐာံ သွသွပါပါတ် ပရာဝရ္တ္တျ ယုၐ္မဘျမ် အာၑိၐံ ဒါတုံ ပြထမတသ္တံ ယုၐ္မာကံ နိကဋံ ပြေၐိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","ယသ္မိန် သမယေ ပိတရယောဟနော် လောကာန် ဥပဒိၑတသ္တသ္မိန် သမယေ ယာဇကာ မန္ဒိရသျ သေနာပတယး သိဒူကီဂဏၑ္စ ");
INSERT INTO sanbur_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","တယောရ် ဥပဒေၑကရဏေ ခြီၐ္ဋသျောတ္ထာနမ် ဥပလက္ၐျ သရွွေၐာံ မၖတာနာမ် ဥတ္ထာနပြသ္တာဝေ စ ဝျဂြား သန္တသ္တာဝုပါဂမန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","တော် ဓၖတွာ ဒိနာဝသာနကာရဏာတ် ပရဒိနပရျျနန္တံ ရုဒ္ဓွာ သ္ထာပိတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","တထာပိ ယေ လောကာသ္တယောရုပဒေၑမ် အၑၖဏွန် တေၐာံ ပြာယေဏ ပဉ္စသဟသြာဏိ ဇနာ ဝျၑွသန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","ပရေ'ဟနိ အဓိပတယး ပြာစီနာ အဓျာပကာၑ္စ ဟာနနနာမာ မဟာယာဇကး ");
INSERT INTO sanbur_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ကိယဖာ ယောဟန် သိကန္ဒရ ဣတျာဒယော မဟာယာဇကသျ ဇ္ဉာတယး သရွွေ ယိရူၑာလမ္နဂရေ မိလိတား၊ ");
INSERT INTO sanbur_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","အနန္တရံ ပြေရိတော် မဓျေ သ္ထာပယိတွာပၖစ္ဆန် ယုဝါံ ကယာ ၑက္တယာ ဝါ ကေန နာမ္နာ ကရ္မ္မာဏျေတာနိ ကုရုထး? ");
INSERT INTO sanbur_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","တဒါ ပိတရး ပဝိတြေဏာတ္မနာ ပရိပူရ္ဏး သန် ပြတျဝါဒီတ်, ဟေ လောကာနာမ် အဓိပတိဂဏ ဟေ ဣသြာယေလီယပြာစီနား, ");
INSERT INTO sanbur_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ဧတသျ ဒုရ္ဗ္ဗလမာနုၐသျ ဟိတံ ယတ် ကရ္မ္မာကြိယတ, အရ္ထာတ်, သ ယေန ပြကာရေဏ သွသ္ထောဘဝတ် တစ္စေဒ် အဒျာဝါံ ပၖစ္ဆထ, ");
INSERT INTO sanbur_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","တရှိ သရွွ ဣသြာယေेလီယလောကာ ယူယံ ဇာနီတ နာသရတီယော ယော ယီၑုခြီၐ္ဋး ကြုၑေ ယုၐ္မာဘိရဝိဓျတ ယၑ္စေၑွရေဏ ၑ္မၑာနာဒ် ဥတ္ထာပိတး, တသျ နာမ္နာ ဇနောယံ သွသ္ထး သန် ယုၐ္မာကံ သမ္မုခေ ပြောတ္တိၐ္ဌတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","နိစေတၖဘိ ရျုၐ္မာဘိရယံ ယး ပြသ္တရော'ဝဇ္ဉာတော'ဘဝတ် သ ပြဓာနကောဏသျ ပြသ္တရော'ဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","တဒ္ဘိန္နာဒပရာတ် ကသ္မာဒပိ ပရိတြာဏံ ဘဝိတုံ န ၑက္နောတိ, ယေန တြာဏံ ပြာပျေတ ဘူမဏ္ဍလသျလောကာနာံ မဓျေ တာဒၖၑံ ကိမပိ နာမ နာသ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","တဒါ ပိတရယောဟနောရေတာဒၖၑီမ် အက္ၐေဘတာံ ဒၖၐ္ဋွာ တာဝဝိဒွါံသော် နီစလောကာဝိတိ ဗုဒ္ဓွာ အာၑ္စရျျမ် အမနျန္တ တော် စ ယီၑေား သင်္ဂိနော် ဇာတာဝိတိ ဇ္ဉာတုမ် အၑက္နုဝန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","ကိန္တု တာဘျာံ သာရ္ဒ္ဓံ တံ သွသ္ထမာနုၐံ တိၐ္ဌန္တံ ဒၖၐ္ဋွာ တေ ကာမပျပရာမ် အာပတ္တိံ ကရ္တ္တံ နာၑက္နုန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","တဒါ တေ သဘာတး သ္ထာနာန္တရံ ဂန္တုံ တာန် အာဇ္ဉာပျ သွယံ ပရသ္ပရမ် ဣတိ မန္တြဏာမကုရွွန္ ");
INSERT INTO sanbur_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","တော် မာနဝေါ် ပြတိ ကိံ ကရ္တ္တဝျံ? တာဝေကံ ပြသိဒ္ဓမ် အာၑ္စရျျံ ကရ္မ္မ ကၖတဝန္တော် တဒ် ယိရူၑာလမ္နိဝါသိနာံ သရွွေၐာံ လောကာနာံ သမီပေ ပြာကာၑတ တစ္စ ဝယမပဟ္နောတုံ န ၑက္နုမး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","ကိန္တု လောကာနာံ မဓျမ် ဧတဒ် ယထာ န ဝျာပ္နောတိ တဒရ္ထံ တော် ဘယံ ပြဒရ္ၑျ တေန နာမ္နာ ကမပိ မနုၐျံ နောပဒိၑတမ် ဣတိ ဒၖဎံ နိၐေဓာမး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","တတသ္တေ ပြေရိတာဝါဟူယ ဧတဒါဇ္ဉာပယန် ဣတး ပရံ ယီၑော ရ္နာမ္နာ ကဒါပိ ကာမပိ ကထာံ မာ ကထယတံ ကိမပိ နောပဒိၑဉ္စ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","တတး ပိတရယောဟနော် ပြတျဝဒတာမ် ဤၑွရသျာဇ္ဉာဂြဟဏံ ဝါ ယုၐ္မာကမ် အာဇ္ဉာဂြဟဏမ် ဧတယော ရ္မဓျေ ဤၑွရသျ ဂေါစရေ ကိံ ဝိဟိတံ? ယူယံ တသျ ဝိဝေစနာံ ကုရုတ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","ဝယံ ယဒ် အပၑျာမ ယဒၑၖဏုမ စ တန္န ပြစာရယိၐျာမ ဧတတ် ကဒါပိ ဘဝိတုံ န ၑက္နောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","ယဒဃဋတ တဒ် ဒၖၐ္ဋာ သရွွေ လောကာ ဤၑွရသျ ဂုဏာန် အနွဝဒန် တသ္မာတ် လောကဘယာတ် တော် ဒဏ္ဍယိတုံ ကမပျုပါယံ န ပြာပျ တေ ပုနရပိ တရ္ဇယိတွာ တာဝတျဇန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ယသျ မာနုၐသျဲတတ် သွာသ္ထျကရဏမ် အာၑ္စရျျံ ကရ္မ္မာကြိယတ တသျ ဝယၑ္စတွာရိံၑဒွတ္သရာ ဝျတီတား၊ ");
INSERT INTO sanbur_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","တတး ပရံ တော် ဝိသၖၐ္ဋော် သန္တော် သွသင်္ဂိနာံ သန္နိဓိံ ဂတွာ ပြဓာနယာဇကဲး ပြာစီနလောကဲၑ္စ ပြောက္တား သရွွား ကထာ ဇ္ဉာပိတဝန္တော်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","တစ္ဆြုတွာ သရွွ ဧကစိတ္တီဘူယ ဤၑွရမုဒ္ဒိၑျ ပြောစ္စဲရေတတ် ပြာရ္ထယန္တ, ဟေ ပြဘော ဂဂဏပၖထိဝီပယောဓီနာံ တေၐု စ ယဒျဒ် အာသ္တေ တေၐာံ သြၐ္ဋေၑွရသ္တွံ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","တွံ နိဇသေဝကေန ဒါယူဒါ ဝါကျမိဒမ် ဥဝစိထ, မနုၐျာ အနျဒေၑီယား ကုရွွန္တိ ကလဟံ ကုတး၊ လောကား သရွွေ ကိမရ္ထံ ဝါ စိန္တာံ ကုရွွန္တိ နိၐ္ဖလာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ပရမေၑသျ တေနဲဝါဘိၐိက္တသျ ဇနသျ စ၊ ဝိရုဒ္ဓမဘိတိၐ္ဌန္တိ ပၖထိဝျား ပတယး ကုတး။ ");
INSERT INTO sanbur_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","ဖလတသ္တဝ ဟသ္တေန မန္တြဏယာ စ ပူရွွ ယဒျတ် သ္ထိရီကၖတံ တဒ် ယထာ သိဒ္ဓံ ဘဝတိ တဒရ္ထံ တွံ ယမ် အထိၐိက္တဝါန် သ ဧဝ ပဝိတြော ယီၑုသ္တသျ ပြာတိကူလျေန ဟေရောဒ် ပန္တီယပီလာတော ");
INSERT INTO sanbur_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","'နျဒေၑီယလောကာ ဣသြာယေလ္လောကာၑ္စ သရွွ ဧတေ သဘာယာမ် အတိၐ္ဌန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","ဟေ ပရမေၑွရ အဓုနာ တေၐာံ တရ္ဇနံ ဂရ္ဇနဉ္စ ၑၖဏု; ");
INSERT INTO sanbur_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","တထာ သွာသ္ထျကရဏကရ္မ္မဏာ တဝ ဗာဟုဗလပြကာၑပူရွွကံ တဝ သေဝကာန် နိရ္ဘယေန တဝ ဝါကျံ ပြစာရယိတုံ တဝ ပဝိတြပုတြသျ ယီၑော ရ္နာမ္နာ အာၑ္စရျျာဏျသမ္ဘဝါနိ စ ကရ္မ္မာဏိ ကရ္တ္တုဉ္စာဇ္ဉာပယ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ဣတ္ထံ ပြာရ္ထနယာ ယတြ သ္ထာနေ တေ သဘာယာမ် အာသန် တတ် သ္ထာနံ ပြာကမ္ပတ; တတး သရွွေ ပဝိတြေဏာတ္မနာ ပရိပူရ္ဏား သန္တ ဤၑွရသျ ကထာမ် အက္ၐောဘေဏ ပြာစာရယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","အပရဉ္စ ပြတျယကာရိလောကသမူဟာ ဧကမနသ ဧကစိတ္တီဘူယ သ္ထိတား၊ တေၐာံ ကေပိ နိဇသမ္ပတ္တိံ သွီယာံ နာဇာနန် ကိန္တု တေၐာံ သရွွား သမ္ပတ္တျး သာဓာရဏျေန သ္ထိတား၊ ");
INSERT INTO sanbur_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","အနျစ္စ ပြေရိတာ မဟာၑက္တိပြကာၑပူရွွကံ ပြဘော ရျီၑောရုတ္ထာနေ သာက္ၐျမ် အဒဒုး, တေၐု သရွွေၐု မဟာနုဂြဟော'ဘဝစ္စ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","တေၐာံ မဓျေ ကသျာပိ ဒြဝျနျူနတာ နာဘဝဒ် ယတသ္တေၐာံ ဂၖဟဘူမျာဒျာ ယား သမ္ပတ္တယ အာသန် တာ ဝိကြီယ ");
INSERT INTO sanbur_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","တန္မူလျမာနီယ ပြေရိတာနာံ စရဏေၐု တဲး သ္ထာပိတံ; တတး ပြတျေကၑး ပြယောဇနာနုသာရေဏ ဒတ္တမဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","ဝိၑေၐတး ကုပြောပဒွီပီယော ယောသိနာမကော လေဝိဝံၑဇာတ ဧကော ဇနော ဘူမျဓိကာရီ, ယံ ပြေရိတာ ဗရ္ဏဗ္ဗာ အရ္ထာတ် သာန္တွနာဒါယက ဣတျုက္တွာ သမာဟူယန်, ");
INSERT INTO sanbur_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","သ ဇနော နိဇဘူမိံ ဝိကြီယ တန္မူလျမာနီယ ပြေရိတာနာံ စရဏေၐု သ္ထာပိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","တဒါ အနာနိယနာမက ဧကော ဇနော ယသျ ဘာရျျာယာ နာမ သဖီရာ သ သွာဓိကာရံ ဝိကြီယ ");
INSERT INTO sanbur_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","သွဘာရျျာံ ဇ္ဉာပယိတွာ တန္မူလျသျဲကာံၑံ သင်္ဂေါပျ သ္ထာပယိတွာ တဒနျာံၑမာတြမာနီယ ပြေရိတာနာံ စရဏေၐု သမရ္ပိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","တသ္မာတ် ပိတရောကထယတ် ဟေ အနာနိယ ဘူမေ ရ္မူလျံ ကိဉ္စိတ် သင်္ဂေါပျ သ္ထာပယိတုံ ပဝိတြသျာတ္မနး သန္နိဓော် မၖၐာဝါကျံ ကထယိတုဉ္စ ၑဲတာန် ကုတသ္တဝါန္တးကရဏေ ပြဝၖတ္တိမဇနယတ်? ");
INSERT INTO sanbur_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","သာ ဘူမိ ရျဒါ တဝ ဟသ္တဂတာ တဒါ ကိံ တဝ သွီယာ နာသီတ်? တရှိ သွာန္တးကရဏေ ကုတ ဧတာဒၖၑီ ကုကလ္ပနာ တွယာ ကၖတာ? တွံ ကေဝလမနုၐျသျ နိကဋေ မၖၐာဝါကျံ နာဝါဒီး ကိန္တွီၑွရသျ နိကဋေ'ပိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ဧတာံ ကထာံ ၑြုတွဲဝ သော'နာနိယော ဘူမော် ပတန် ပြာဏာန် အတျဇတ်, တဒွၖတ္တာန္တံ ယာဝန္တော လောကာ အၑၖဏွန် တေၐာံ သရွွေၐာံ မဟာဘယမ် အဇာယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","တဒါ ယုဝလောကာသ္တံ ဝသ္တြေဏာစ္ဆာဒျ ဗဟိ ရ္နီတွာ ၑ္မၑာနေ'သ္ထာပယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","တတး ပြဟရဲကာနန္တရံ ကိံ ဝၖတ္တံ တန္နာဝဂတျ တသျ ဘာရျျာပိ တတြ သမုပသ္ထိတာ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","တတး ပိတရသ္တာမ် အပၖစ္ဆတ်, ယုဝါဘျာမ် ဧတာဝန္မုဒြာဘျော ဘူမိ ရွိကြီတာ န ဝါ? ဧတတွံ ဝဒ; တဒါ သာ ပြတျဝါဒီတ် သတျမ် ဧတာဝဒ္ဘျော မုဒြာဘျ ဧဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","တတး ပိတရောကထယတ် ယုဝါံ ကထံ ပရမေၑွရသျာတ္မာနံ ပရီက္ၐိတုမ် ဧကမန္တြဏာဝဘဝတာံ? ပၑျ ယေ တဝ ပတိံ ၑ္မၑာနေ သ္ထာပိတဝန္တသ္တေ ဒွါရသျ သမီပေ သမုပတိၐ္ဌန္တိ တွာမပိ ဗဟိရ္နေၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","တတး သာပိ တသျ စရဏသန္နိဓော် ပတိတွာ ပြာဏာန် အတျာက္ၐီတ်၊ ပၑ္စာတ် တေ ယုဝါနော'ဘျန္တရမ် အာဂတျ တာမပိ မၖတာံ ဒၖၐ္ဋွာ ဗဟိ ရ္နီတွာ တသျား ပတျုး ပါရ္ၑွေ ၑ္မၑာနေ သ္ထာပိတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","တသ္မာတ် မဏ္ဍလျား သရွွေ လောကာ အနျလောကာၑ္စ တာံ ဝါရ္တ္တာံ ၑြုတွာ သာဓွသံ ဂတား၊ ");
INSERT INTO sanbur_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","တတး ပရံ ပြေရိတာနာံ ဟသ္တဲ ရ္လောကာနာံ မဓျေ ဗဟွာၑ္စရျျာဏျဒ္ဘုတာနိ ကရ္မ္မာဏျကြိယန္တ; တဒါ ၑိၐျား သရွွ ဧကစိတ္တီဘူယ သုလေမာနော 'လိန္ဒေ သမ္ဘူယာသန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","တေၐာံ သင်္ဃာန္တရ္ဂော ဘဝိတုံ ကောပိ ပြဂလ္ဘတာံ နာဂမတ် ကိန္တု လောကာသ္တာန် သမာဒြိယန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","သ္တြိယး ပုရုၐာၑ္စ ဗဟဝေါ လောကာ ဝိၑွာသျ ပြဘုံ ၑရဏမာပန္နား၊ ");
INSERT INTO sanbur_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","ပိတရသျ ဂမနာဂမနာဘျာံ ကေနာပိ ပြကာရေဏ တသျ ဆာယာ ကသ္မိံၑ္စိဇ္ဇနေ လဂိၐျတီတျာၑယာ လောကာ ရောဂိဏး ၑိဝိကယာ ခဋွယာ စာနီယ ပထိ ပထိ သ္ထာပိတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","စတုရ္ဒိက္သ္ထနဂရေဘျော ဗဟဝေါ လောကား သမ္ဘူယ ရောဂိဏော'ပဝိတြဘုတဂြသ္တာံၑ္စ ယိရူၑာလမမ် အာနယန် တတး သရွွေ သွသ္ထာ အကြိယန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","အနန္တရံ မဟာယာဇကး သိဒူကိနာံ မတဂြာဟိဏသ္တေၐာံ သဟစရာၑ္စ ");
INSERT INTO sanbur_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","မဟာကြောဓာန္တွိတား သန္တး ပြေရိတာန် ဓၖတွာ နီစလောကာနာံ ကာရာယာံ ဗဒ္ဓွာ သ္ထာပိတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","ကိန္တု ရာတြော် ပရမေၑွရသျ ဒူတး ကာရာယာ ဒွါရံ မောစယိတွာ တာန် ဗဟိရာနီယာကထယတ်, ");
INSERT INTO sanbur_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","ယူယံ ဂတွာ မန္ဒိရေ ဒဏ္ဍာယမာနား သန္တော လောကာန် ပြတီမာံ ဇီဝနဒါယိကာံ သရွွာံ ကထာံ ပြစာရယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ဣတိ ၑြုတွာ တေ ပြတျူၐေ မန္ဒိရ ဥပသ္ထာယ ဥပဒိၐ္ဋဝန္တး၊ တဒါ သဟစရဂဏေန သဟိတော မဟာယာဇက အာဂတျ မန္တြိဂဏမ် ဣသြာယေလွံၑသျ သရွွာန် ရာဇသဘာသဒး သဘာသ္ထာန် ကၖတွာ ကာရာယာသ္တာန် အာပယိတုံ ပဒါတိဂဏံ ပြေရိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","တတသ္တေ ဂတွာ ကာရာယာံ တာန် အပြာပျ ပြတျာဂတျ ဣတိ ဝါရ္တ္တာမ် အဝါဒိၐုး, ");
INSERT INTO sanbur_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ဝယံ တတြ ဂတွာ နိရွွိဃ္နံ ကာရာယာ ဒွါရံ ရုဒ္ဓံ ရက္ၐကာံၑ္စ ဒွါရသျ ဗဟိရ္ဒဏ္ဍာယမာနာန် အဒရ္ၑာမ ဧဝ ကိန္တု ဒွါရံ မောစယိတွာ တန္မဓျေ ကမပိ ဒြၐ္ဋုံ န ပြာပ္တား၊ ");
INSERT INTO sanbur_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ဧတာံ ကထာံ ၑြုတွာ မဟာယာဇကော မန္ဒိရသျ သေနာပတိး ပြဓာနယာဇကာၑ္စ, ဣတ ပရံ ကိမပရံ ဘဝိၐျတီတိ စိန္တယိတွာ သန္ဒိဂ္ဓစိတ္တာ အဘဝန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ဧတသ္မိန္နေဝ သမယေ ကၑ္စိတ် ဇန အာဂတျ ဝါရ္တ္တာမေတာမ် အဝဒတ် ပၑျတ ယူယံ ယာန် မာနဝါန် ကာရာယာမ် အသ္ထာပယတ တေ မန္ဒိရေ တိၐ္ဌန္တော လောကာန် ဥပဒိၑန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","တဒါ မန္ဒိရသျ သေနာပတိး ပဒါတယၑ္စ တတြ ဂတွာ စေလ္လောကား ပါၐာဏာန် နိက္ၐိပျာသ္မာန် မာရယန္တီတိ ဘိယာ ဝိနတျာစာရံ တာန် အာနယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","တေ မဟာသဘာယာ မဓျေ တာန် အသ္ထာပယန် တတး ပရံ မဟာယာဇကသ္တာန် အပၖစ္ဆတ်, ");
INSERT INTO sanbur_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","အနေန နာမ္နာ သမုပဒေၐ္ဋုံ ဝယံ ကိံ ဒၖဎံ န နျၐေဓာမ? တထာပိ ပၑျတ ယူယံ သွေၐာံ တေနောပဒေၑေနေ ယိရူၑာလမံ ပရိပူရ္ဏံ ကၖတွာ တသျ ဇနသျ ရက္တပါတဇနိတာပရာဓမ် အသ္မာန် ပြတျာနေတုံ စေၐ္ဋဓွေ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","တတး ပိတရောနျပြေရိတာၑ္စ ပြတျဝဒန် မာနုၐသျာဇ္ဉာဂြဟဏာဒ် ဤၑွရသျာဇ္ဉာဂြဟဏမ် အသ္မာကမုစိတမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","ယံ ယီၑုံ ယူယံ ကြုၑေ ဝေဓိတွာဟတ တမ် အသ္မာကံ ပဲတၖက ဤၑွရ ဥတ္ထာပျ ");
INSERT INTO sanbur_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ဣသြာယေလွံၑာနာံ မနးပရိဝရ္တ္တနံ ပါပက္ၐမာဉ္စ ကရ္တ္တုံ ရာဇာနံ ပရိတြာတာရဉ္စ ကၖတွာ သွဒက္ၐိဏပါရ္ၑွေ တသျာန္နတိမ် အကရောတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ဧတသ္မိန် ဝယမပိ သာက္ၐိဏ အာသ္မဟေ, တတ် ကေဝလံ နဟိ, ဤၑွရ အာဇ္ဉာဂြာဟိဘျော ယံ ပဝိတြမ် အာတ္မနံ ဒတ္တဝါန် သောပိ သာက္ၐျသ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","ဧတဒွါကျေ ၑြုတေ တေၐာံ ဟၖဒယာနိ ဝိဒ္ဓါနျဘဝန် တတသ္တေ တာန် ဟန္တုံ မန္တြိတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ဧတသ္မိန္နေဝ သမယေ တတ္သဘာသ္ထာနာံ သရွွလောကာနာံ မဓျေ သုချာတော ဂမိလီယေလ္နာမက ဧကော ဇနော ဝျဝသ္ထာပကး ဖိရူၑိလောက ဥတ္ထာယ ပြေရိတာန် က္ၐဏာရ္ထံ သ္ထာနာန္တရံ ဂန္တုမ် အာဒိၑျ ကထိတဝါန်, ");
INSERT INTO sanbur_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ဟေ ဣသြာယေလွံၑီယား သရွွေ ယူယမ် ဧတာန် မာနုၐာန် ပြတိ ယတ် ကရ္တ္တုမ် ဥဒျတာသ္တသ္မိန် သာဝဓာနာ ဘဝတ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","ဣတး ပူရွွံ ထူဒါနာမဲကော ဇန ဥပသ္ထာယ သွံ ကမပိ မဟာပုရုၐမ် အဝဒတ်, တတး ပြာယေဏ စတုးၑတလောကာသ္တသျ မတဂြာဟိဏောဘဝန် ပၑ္စာတ် သ ဟတောဘဝတ် တသျာဇ္ဉာဂြာဟိဏော ယာဝန္တော လောကာသ္တေ သရွွေ ဝိရ္ကီရ္ဏား သန္တော 'ကၖတကာရျျာ အဘဝန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","တသ္မာဇ္ဇနာတ် ပရံ နာမလေခနသမယေ ဂါလီလီယယိဟူဒါနာမဲကော ဇန ဥပသ္ထာယ ဗဟူလ္လောကာန် သွမတံ ဂြာဟီတဝါန် တတး သောပိ ဝျနၑျတ် တသျာဇ္ဉာဂြာဟိဏော ယာဝန္တော လောကာ အာသန် တေ သရွွေ ဝိကီရ္ဏာ အဘဝန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","အဓုနာ ဝဒါမိ, ယူယမ် ဧတာန် မနုၐျာန် ပြတိ ကိမပိ န ကၖတွာ က္ၐာန္တာ ဘဝတ, ယတ ဧၐ သင်္ကလ္ပ ဧတတ် ကရ္မ္မ စ ယဒိ မနုၐျာဒဘဝတ် တရှိ ဝိဖလံ ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ယဒီၑွရာဒဘဝတ် တရှိ ယူယံ တသျာနျထာ ကရ္တ္တုံ န ၑက္ၐျထ, ဝရမ် ဤၑွရရောဓကာ ဘဝိၐျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","တဒါ တသျ မန္တြဏာံ သွီကၖတျ တေ ပြေရိတာန် အာဟူယ ပြဟၖတျ ယီၑော ရ္နာမ္နာ ကာမပိ ကထာံ ကထယိတုံ နိၐိဓျ ဝျသရ္ဇန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","ကိန္တု တသျ နာမာရ္ထံ ဝယံ လဇ္ဇာဘောဂသျ ယောဂျတွေန ဂဏိတာ ဣတျတြ တေ သာနန္ဒား သန္တး သဘာသ္ထာနာံ သာက္ၐာဒ် အဂစ္ဆန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","တတး ပရံ ပြတိဒိနံ မန္ဒိရေ ဂၖဟေ ဂၖဟေ စာဝိၑြာမမ် ဥပဒိၑျ ယီၑုခြီၐ္ဋသျ သုသံဝါဒံ ပြစာရိတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","တသ္မိန် သမယေ ၑိၐျာဏာံ ဗာဟုလျာတ် ပြာတျဟိကဒါနသျ ဝိၑြာဏနဲ ရ္ဘိန္နဒေၑီယာနာံ ဝိဓဝါသ္တြီဂဏ ဥပေက္ၐိတေ သတိ ဣဗြီယလောကဲး သဟာနျဒေၑီယာနာံ ဝိဝါဒ ဥပါတိၐ္ဌတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","တဒါ ဒွါဒၑပြေရိတား သရွွာန် ၑိၐျာန် သံဂၖဟျာကထယန် ဤၑွရသျ ကထာပြစာရံ ပရိတျဇျ ဘောဇနဂဝေၐဏမ် အသ္မာကမ် ဥစိတံ နဟိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","အတော ဟေ ဘြာတၖဂဏ ဝယမ် ဧတတ္ကရ္မ္မဏော ဘာရံ ယေဘျော ဒါတုံ ၑက္နုမ ဧတာဒၖၑာန် သုချာတျာပန္နာန် ပဝိတြေဏာတ္မနာ ဇ္ဉာနေန စ ပူရ္ဏာန် သပ္ပြဇနာန် ယူယံ သွေၐာံ မဓျေ မနောနီတာန် ကုရုတ, ");
INSERT INTO sanbur_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ကိန္တု ဝယံ ပြာရ္ထနာယာံ ကထာပြစာရကရ္မ္မဏိ စ နိတျပြဝၖတ္တား သ္ထာသျာမး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ဧတသျာံ ကထာယာံ သရွွေ လောကား သန္တုၐ္ဋား သန္တး သွေၐာံ မဓျာတ် သ္တိဖာနး ဖိလိပး ပြခရော နိကာနောရ် တီမန် ပရ္မ္မိဏာ ယိဟူဒိမတဂြာဟီ-အာန္တိယခိယာနဂရီယော နိကလာ ဧတာန် ပရမဘက္တာန် ပဝိတြေဏာတ္မနာ ပရိပူရ္ဏာန် သပ္တ ဇနာန္ ");
INSERT INTO sanbur_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ပြေရိတာနာံ သမက္ၐမ် အာနယန်, တတသ္တေ ပြာရ္ထနာံ ကၖတွာ တေၐာံ ၑိရးသု ဟသ္တာန် အာရ္ပယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","အပရဉ္စ ဤၑွရသျ ကထာ ဒေၑံ ဝျာပ္နောတ် ဝိၑေၐတော ယိရူၑာလမိ နဂရေ ၑိၐျာဏာံ သံချာ ပြဘူတရူပေဏာဝရ္ဒ္ဓတ ယာဇကာနာံ မဓျေပိ ဗဟဝး ခြီၐ္ဋမတဂြာဟိဏော'ဘဝန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","သ္တိဖာနောे ဝိၑွာသေန ပရာကြမေဏ စ ပရိပူရ္ဏး သန် လောကာနာံ မဓျေ ဗဟုဝိဓမ် အဒ္ဘုတမ် အာၑ္စရျျံ ကရ္မ္မာကရောတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","တေန လိဗရ္တ္တိနီယနာမ္နာ ဝိချာတသင်္ဃသျ ကတိပယဇနား ကုရီဏီယသိကန္ဒရီယ-ကိလိကီယာၑီယာဒေၑီယား ကိယန္တော ဇနာၑ္စောတ္ထာယ သ္တိဖာနေန သာရ္ဒ္ဓံ ဝျဝဒန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ကိန္တု သ္တိဖာနော ဇ္ဉာနေန ပဝိတြေဏာတ္မနာ စ ဤဒၖၑီံ ကထာံ ကထိတဝါန် ယသျာသ္တေ အာပတ္တိံ ကရ္တ္တုံ နာၑက္နုဝန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","ပၑ္စာတ် တဲ ရ္လောဘိတား ကတိပယဇနား ကထာမေနာမ် အကထယန်, ဝယံ တသျ မုခတော မူသာ ဤၑွရသျ စ နိန္ဒာဝါကျမ် အၑြော်ၐ္မ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","တေ လောကာနာံ လောကပြာစီနာနာမ် အဓျာပကာနာဉ္စ ပြဝၖတ္တိံ ဇနယိတွာ သ္တိဖာနသျ သန္နိဓိမ် အာဂတျ တံ ဓၖတွာ မဟာသဘာမဓျမ် အာနယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","တဒနန္တရံ ကတိပယဇနေၐု မိထျာသာက္ၐိၐု သမာနီတေၐု တေ'ကထယန် ဧၐ ဇန ဧတတ္ပုဏျသ္ထာနဝျဝသ္ထယော ရ္နိန္ဒာတး ကဒါပိ န နိဝရ္တ္တတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ဖလတော နာသရတီယယီၑုး သ္ထာနမေတဒ် ဥစ္ဆိန္နံ ကရိၐျတိ မူသာသမရ္ပိတမ် အသ္မာကံ ဝျဝဟရဏမ် အနျရူပံ ကရိၐျတိ တသျဲတာဒၖၑီံ ကထာံ ဝယမ် အၑၖဏုမ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","တဒါ မဟာသဘာသ္ထား သရွွေ တံ ပြတိ သ္ထိရာံ ဒၖၐ္ဋိံ ကၖတွာ သွရ္ဂဒူတမုခသဒၖၑံ တသျ မုခမ် အပၑျန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","တတး ပရံ မဟာယာဇကး ပၖၐ္ဋဝါန်, ဧၐာ ကထာံ ကိံ သတျာ? ");
INSERT INTO sanbur_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","တတး သ ပြတျဝဒတ်, ဟေ ပိတရော ဟေ ဘြာတရး သရွွေ လာကာ မနာံသိ နိဓဒ္ဓွံ၊ အသ္မာကံ ပူရွွပုရုၐ ဣဗြာဟီမ် ဟာရဏ္နဂရေ ဝါသကရဏာတ် ပူရွွံ ယဒါ အရာမ်-နဟရယိမဒေၑေ အာသီတ် တဒါ တေဇောမယ ဤၑွရော ဒရ္ၑနံ ဒတွာ ");
INSERT INTO sanbur_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","တမဝဒတ် တွံ သွဒေၑဇ္ဉာတိမိတြာဏိ ပရိတျဇျ ယံ ဒေၑမဟံ ဒရ္ၑယိၐျာမိ တံ ဒေၑံ ဝြဇ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","အတး သ ကသ္ဒီယဒေၑံ ဝိဟာယ ဟာရဏ္နဂရေ နျဝသတ်, တဒနန္တရံ တသျ ပိတရိ မၖတေ ယတြ ဒေၑေ ယူယံ နိဝသထ သ ဧနံ ဒေၑမာဂစ္ဆတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","ကိန္တွီၑွရသ္တသ္မဲ ကမပျဓိကာရမ် အရ္ထာဒ် ဧကပဒပရိမိတာံ ဘူမိမပိ နာဒဒါတ်; တဒါ တသျ ကောပိ သန္တာနော နာသီတ် တထာပိ သန္တာနဲး သာရ္ဒ္ဓမ် ဧတသျ ဒေၑသျာဓိကာရီ တွံ ဘဝိၐျသီတိ တမ္ပြတျင်္ဂီကၖတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ဤၑွရ ဣတ္ထမ် အပရမပိ ကထိတဝါန် တဝ သန္တာနား ပရဒေၑေ နိဝတ္သျန္တိ တတသ္တဒ္ဒေၑီယလောကာၑ္စတုးၑတဝတ္သရာန် ယာဝတ် တာန် ဒါသတွေ သ္ထာပယိတွာ တာန် ပြတိ ကုဝျဝဟာရံ ကရိၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","အပရမ် ဤၑွရ ဧနာံ ကထာမပိ ကထိတဝါန်, ယေ လောကာသ္တာန် ဒါသတွေ သ္ထာပယိၐျန္တိ တာလ္လောကာန် အဟံ ဒဏ္ဍယိၐျာမိ, တတး ပရံ တေ ဗဟိရ္ဂတား သန္တော မာမ် အတြ သ္ထာနေ သေဝိၐျန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","ပၑ္စာတ် သ တသ္မဲ တွက္ဆေဒသျ နိယမံ ဒတ္တဝါန်, အတ ဣသှာကနာမ္နိ ဣဗြာဟီမ ဧကပုတြေ ဇာတေ, အၐ္ဋမဒိနေ တသျ တွက္ဆေဒမ် အကရောတ်၊ တသျ ဣသှာကး ပုတြော ယာကူဗ်, တတသ္တသျ ယာကူဗော'သ္မာကံ ဒွါဒၑ ပူရွွပုရုၐာ အဇာယန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","တေ ပူရွွပုရုၐာ ဤရ္ၐျယာ ပရိပူရ္ဏာ မိသရဒေၑံ ပြေၐယိတုံ ယူၐဖံ ဝျကြီဏန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ကိန္တွီၑွရသ္တသျ သဟာယော ဘူတွာ သရွွသျာ ဒုရ္ဂတေ ရက္ၐိတွာ တသ္မဲ ဗုဒ္ဓိံ ဒတ္တွာ မိသရဒေၑသျ ရာဇ္ဉး ဖိရော်ဏး ပြိယပါတြံ ကၖတဝါန် တတော ရာဇာ မိသရဒေၑသျ သွီယသရွွပရိဝါရသျ စ ၑာသနပဒံ တသ္မဲ ဒတ္တဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","တသ္မိန် သမယေ မိသရ-ကိနာနဒေၑယော ရ္ဒုရ္ဘိက္ၐဟေတောရတိက္လိၐ္ဋတွာတ် နး ပူရွွပုရုၐာ ဘက္ၐျဒြဝျံ နာလဘန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","ကိန္တု မိသရဒေၑေ ၑသျာနိ သန္တိ, ယာကူဗ် ဣမာံ ဝါရ္တ္တာံ ၑြုတွာ ပြထမမ် အသ္မာကံ ပူရွွပုရုၐာန် မိသရံ ပြေၐိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","တတော ဒွိတီယဝါရဂမနေ ယူၐဖ် သွဘြာတၖဘိး ပရိစိတော'ဘဝတ်; ယူၐဖော ဘြာတရး ဖိရော်ဏ် ရာဇေန ပရိစိတာ အဘဝန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","အနန္တရံ ယူၐဖ် ဘြာတၖဂဏံ ပြေၐျ နိဇပိတရံ ယာကူဗံ နိဇာန် ပဉ္စာဓိကသပ္တတိသံချကာန် ဇ္ဉာတိဇနာံၑ္စ သမာဟူတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","တသ္မာဒ် ယာကူဗ် မိသရဒေၑံ ဂတွာ သွယမ် အသ္မာကံ ပူရွွပုရုၐာၑ္စ တသ္မိန် သ္ထာနေ'မြိယန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","တတသ္တေ ၑိခိမံ နီတာ ယတ် ၑ္မၑာနမ် ဣဗြာဟီမ် မုဒြာဒတွာ ၑိခိမး ပိတု ရှမောရး ပုတြေဘျး ကြီတဝါန် တတ္ၑ္မၑာနေ သ္ထာပယာဉ္စကြိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","တတး ပရမ် ဤၑွရ ဣဗြာဟီမး သန္နိဓော် ၑပထံ ကၖတွာ ယာံ ပြတိဇ္ဉာံ ကၖတဝါန် တသျား ပြတိဇ္ဉာယား ဖလနသမယေ နိကဋေ သတိ ဣသြာယေလ္လောကာ သိမရဒေၑေ ဝရ္ဒ္ဓမာနာ ဗဟုသံချာ အဘဝန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ၑေၐေ ယူၐဖံ ယော န ပရိစိနောတိ တာဒၖၑ ဧကော နရပတိရုပသ္ထာယ ");
INSERT INTO sanbur_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","အသ္မာကံ ဇ္ဉာတိဘိး သာရ္ဒ္ဓံ ဓူရ္တ္တတာံ ဝိဓာယ ပူရွွပုရုၐာန် ပြတိ ကုဝျဝဟရဏပူရွွကံ တေၐာံ ဝံၑနာၑနာယ တေၐာံ နဝဇာတာန် ၑိၑူန် ဗဟိ ရ္နိရက္ၐေပယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","ဧတသ္မိန် သမယေ မူသာ ဇဇ္ဉေ, သ တု ပရမသုန္ဒရော'ဘဝတ် တထာ ပိတၖဂၖဟေ မာသတြယပရျျန္တံ ပါလိတော'ဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ကိန္တု တသ္မိန် ဗဟိရ္နိက္ၐိပ္တေ သတိ ဖိရော်ဏရာဇသျ ကနျာ တမ် ဥတ္တောလျ နီတွာ ဒတ္တကပုတြံ ကၖတွာ ပါလိတဝတီ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","တသ္မာတ် သ မူသာ မိသရဒေၑီယာယား သရွွဝိဒျာယား ပါရဒၖၐွာ သန် ဝါကျေ ကြိယာယာဉ္စ ၑက္တိမာန် အဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","သ သမ္ပူရ္ဏစတွာရိံၑဒွတ္သရဝယသ္ကော ဘူတွာ ဣသြာယေလီယဝံၑနိဇဘြာတၖန် သာက္ၐာတ် ကရ္တုံ မတိံ စကြေ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","တေၐာံ ဇနမေကံ ဟိံသိတံ ဒၖၐ္ဋွာ တသျ သပက္ၐး သန် ဟိံသိတဇနမ် ဥပကၖတျ မိသရီယဇနံ ဇဃာန၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","တသျ ဟသ္တေနေၑွရသ္တာန် ဥဒ္ဓရိၐျတိ တသျ ဘြာတၖဂဏ ဣတိ ဇ္ဉာသျတိ သ ဣတျနုမာနံ စကာရ, ကိန္တု တေ န ဗုဗုဓိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","တတ္ပရေ 'ဟနိ တေၐာမ် ဥဘယော ရ္ဇနယော ရွာက္ကလဟ ဥပသ္ထိတေ သတိ မူသား သမီပံ ဂတွာ တယော ရ္မေလနံ ကရ္တ္တုံ မတိံ ကၖတွာ ကထယာမာသ, ဟေ မဟာၑယော် ယုဝါံ ဘြာတရော် ပရသ္ပရမ် အနျာယံ ကုတး ကုရုထး? ");
INSERT INTO sanbur_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","တတး သမီပဝါသိနံ ပြတိ ယော ဇနော'နျာယံ စကာရ သ တံ ဒူရီကၖတျ ကထယာမာသ, အသ္မာကမုပရိ ၑာသ္တၖတွဝိစာရယိတၖတွပဒယေား ကသ္တွာံ နိယုက္တဝါန်? ");
INSERT INTO sanbur_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","ဟျော ယထာ မိသရီယံ ဟတဝါန် တထာ ကိံ မာမပိ ဟနိၐျသိ? ");
INSERT INTO sanbur_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","တဒါ မူသာ ဧတာဒၖၑီံ ကထာံ ၑြုတွာ ပလာယနံ စကြေ, တတော မိဒိယနဒေၑံ ဂတွာ ပြဝါသီ သန် တသ္ထော်, တတသ္တတြ ဒွေါ် ပုတြော် ဇဇ္ဉာတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","အနန္တရံ စတွာရိံၑဒွတ္သရေၐု ဂတေၐု သီနယပရွွတသျ ပြာန္တရေ ပြဇွလိတသ္တမ္ဗသျ ဝဟ္နိၑိခါယာံ ပရမေၑွရဒူတသ္တသ္မဲ ဒရ္ၑနံ ဒဒေါ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","မူသာသ္တသ္မိန် ဒရ္ၑနေ ဝိသ္မယံ မတွာ ဝိၑေၐံ ဇ္ဉာတုံ နိကဋံ ဂစ္ဆတိ, ");
INSERT INTO sanbur_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","ဧတသ္မိန် သမယေ, အဟံ တဝ ပူရွွပုရုၐာဏာမ် ဤၑွရော'ရ္ထာဒ် ဣဗြာဟီမ ဤၑွရ ဣသှာက ဤၑွရော ယာကူဗ ဤၑွရၑ္စ, မူသာမုဒ္ဒိၑျ ပရမေၑွရသျဲတာဒၖၑီ ဝိဟာယသီယာ ဝါဏီ ဗဘူဝ, တတး သ ကမ္ပာနွိတး သန် ပုန ရ္နိရီက္ၐိတုံ ပြဂလ္ဘော န ဗဘူဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","ပရမေၑွရသ္တံ ဇဂါဒ, တဝ ပါဒယေား ပါဒုကေ မောစယ ယတြ တိၐ္ဌသိ သာ ပဝိတြဘူမိး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","အဟံ မိသရဒေၑသ္ထာနာံ နိဇလောကာနာံ ဒုရ္ဒ္ဒၑာံ နိတာန္တမ် အပၑျံ, တေၐာံ ကာတရျျောက္တိဉ္စ ၑြုတဝါန် တသ္မာတ် တာန် ဥဒ္ဓရ္တ္တုမ် အဝရုဟျာဂမမ်; ဣဒါနီမ် အာဂစ္ဆ မိသရဒေၑံ တွာံ ပြေၐယာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","ကသ္တွာံ ၑာသ္တၖတွဝိစာရယိတၖတွပဒယော ရ္နိယုက္တဝါန်, ဣတိ ဝါကျမုက္တွာ တဲ ရျော မူသာ အဝဇ္ဉာတသ္တမေဝ ဤၑွရး သ္တမ္ဗမဓျေ ဒရ္ၑနဒါတြာ တေန ဒူတေန ၑာသ္တာရံ မုက္တိဒါတာရဉ္စ ကၖတွာ ပြေၐယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","သ စ မိသရဒေၑေ သူဖ္နာမ္နိ သမုဒြေ စ ပၑ္စာတ် စတွာရိံၑဒွတ္သရာန် ယာဝတ် မဟာပြာန္တရေ နာနာပြကာရာဏျဒ္ဘုတာနိ ကရ္မ္မာဏိ လက္ၐဏာနိ စ ဒရ္ၑယိတွာ တာန် ဗဟိး ကၖတွာ သမာနိနာယ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","ပြဘုး ပရမေၑွရော ယုၐ္မာကံ ဘြာတၖဂဏသျ မဓျေ မာဒၖၑမ် ဧကံ ဘဝိၐျဒွက္တာရမ် ဥတ္ပာဒယိၐျတိ တသျ ကထာယာံ ယူယံ မနော နိဓာသျထ, ယော ဇန ဣသြာယေလး သန္တာနေဘျ ဧနာံ ကထာံ ကထယာမာသ သ ဧၐ မူသား၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","မဟာပြာန္တရသ္ထမဏ္ဍလီမဓျေ'ပိ သ ဧဝ သီနယပရွွတောပရိ တေန သာရ္ဒ္ဓံ သံလာပိနော ဒူတသျ စာသ္မတ္ပိတၖဂဏသျ မဓျသ္ထး သန် အသ္မဘျံ ဒါတဝျနိ ဇီဝနဒါယကာနိ ဝါကျာနိ လေဘေ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","အသ္မာကံ ပူရွွပုရုၐာသ္တမ် အမာနျံ ကတွာ သွေဘျော ဒူရီကၖတျ မိသရဒေၑံ ပရာဝၖတျ ဂန္တုံ မနောဘိရဘိလၐျ ဟာရောဏံ ဇဂဒုး, ");
INSERT INTO sanbur_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","အသ္မာကမ် အဂြေ'ဂြေ ဂန္တုुမ် အသ္မဒရ္ထံ ဒေဝဂဏံ နိရ္မ္မာဟိ ယတော ယော မူသာ အသ္မာန် မိသရဒေၑာဒ် ဗဟိး ကၖတွာနီတဝါန် တသျ ကိံ ဇာတံ တဒသ္မာဘိ ရ္န ဇ္ဉာယတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","တသ္မိန် သမယေ တေ ဂေါဝတ္သာကၖတိံ ပြတိမာံ နိရ္မ္မာယ တာမုဒ္ဒိၑျ နဲဝေဒျမုတ္မၖဇျ သွဟသ္တကၖတဝသ္တုနာ အာနန္ဒိတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","တသ္မာဒ် ဤၑွရသ္တေၐာံ ပြတိ ဝိမုခး သန် အာကာၑသ္ထံ ဇျောတိရ္ဂဏံ ပူဇယိတုံ တေဘျော'နုမတိံ ဒဒေါ်, ယာဒၖၑံ ဘဝိၐျဒွါဒိနာံ ဂြန္ထေၐု လိခိတမာသ္တေ, ယထာ, ဣသြာယေလီယဝံၑာ ရေ စတွာရိံၑတ္သမာန် ပုရာ၊ မဟတိ ပြာန္တရေ သံသ္ထာ ယူယန္တု ယာနိ စ၊ ဗလိဟောမာဒိကရ္မ္မာဏိ ကၖတဝန္တသ္တု တာနိ ကိံ၊ မာံ သမုဒ္ဒိၑျ ယုၐ္မာဘိး ပြကၖတာနီတိ နဲဝ စ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","ကိန္တု ဝေါ မောလကာချသျ ဒေဝသျ ဒူၐျမေဝ စ၊ ယုၐ္မာကံ ရိမ္ဖနာချာယာ ဒေဝတာယာၑ္စ တာရကာ၊ ဧတယောရုဘယော ရ္မူရ္တီ ယုၐ္မာဘိး ပရိပူဇိတေ၊ အတော ယုၐ္မာံသ္တု ဗာဗေလး ပါရံ နေၐျာမိ နိၑ္စိတံ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","အပရဉ္စ ယန္နိဒရ္ၑနမ် အပၑျသ္တဒနုသာရေဏ ဒူၐျံ နိရ္မ္မာဟိ ယသ္မိန် ဤၑွရော မူသာမ် ဧတဒွါကျံ ဗဘာၐေ တတ် တသျ နိရူပိတံ သာက္ၐျသွရူပံ ဒူၐျမ် အသ္မာကံ ပူရွွပုရုၐဲး သဟ ပြာန္တရေ တသ္ထော်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","ပၑ္စာတ် ယိဟောၑူယေန သဟိတဲသ္တေၐာံ ဝံၑဇာတဲရသ္မတ္ပူရွွပုရုၐဲး သွေၐာံ သမ္မုခါဒ် ဤၑွရေဏ ဒူရီကၖတာနာမ် အနျဒေၑီယာနာံ ဒေၑာဓိကၖတိကာလေ သမာနီတံ တဒ် ဒူၐျံ ဒါယူဒေါဓိကာရံ ယာဝတ် တတြ သ္ထာန အာသီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","သ ဒါယူဒ် ပရမေၑွရသျာနုဂြဟံ ပြာပျ ယာကူဗ် ဤၑွရာရ္ထမ် ဧကံ ဒူၐျံ နိရ္မ္မာတုံ ဝဝါဉ္ဆ; ");
INSERT INTO sanbur_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","ကိန္တု သုလေမာန် တဒရ္ထံ မန္ဒိရမ် ဧကံ နိရ္မ္မိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","တထာပိ ယး သရွွောပရိသ္ထး သ ကသ္မိံၑ္စိဒ် ဟသ္တကၖတေ မန္ဒိရေ နိဝသတီတိ နဟိ, ဘဝိၐျဒွါဒီ ကထာမေတာံ ကထယတိ, ယထာ, ");
INSERT INTO sanbur_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","ပရေၑော ဝဒတိ သွရ္ဂော ရာဇသိံဟာသနံ မမ၊ မဒီယံ ပါဒပီဌဉ္စ ပၖထိဝီ ဘဝတိ ဓြုဝံ၊ တရှိ ယူယံ ကၖတေ မေ ကိံ ပြနိရ္မ္မာသျထ မန္ဒိရံ၊ ဝိၑြာမာယ မဒီယံ ဝါ သ္ထာနံ ကိံ ဝိဒျတေ တွိဟ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","သရွွာဏျေတာနိ ဝသ္တူနိ ကိံ မေ ဟသ္တကၖတာနိ န။ ");
INSERT INTO sanbur_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","ဟေ အနာဇ္ဉာဂြာဟကာ အန္တးကရဏေ ၑြဝဏေ စာပဝိတြလောကား ယူယမ် အနဝရတံ ပဝိတြသျာတ္မနး ပြာတိကူလျမ် အာစရထ, ယုၐ္မာကံ ပူရွွပုရုၐာ ယာဒၖၑာ ယူယမပိ တာဒၖၑား၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","ယုၐ္မာကံ ပူရွွပုရုၐား ကံ ဘဝိၐျဒွါဒိနံ နာတာဍယန်? ယေ တသျ ဓာရ္မ္မိကသျ ဇနသျာဂမနကထာံ ကထိတဝန္တသ္တာန် အဃ္နန် ယူယမ် အဓူနာ ဝိၑွာသဃာတိနော ဘူတွာ တံ ဓာရ္မ္မိကံ ဇနမ် အဟတ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","ယူယံ သွရ္ဂီယဒူတဂဏေန ဝျဝသ္ထာံ ပြာပျာပိ တာံ နာစရထ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ဣမာံ ကထာံ ၑြုတွာ တေ မနးသု ဗိဒ္ဓါး သန္တသ္တံ ပြတိ ဒန္တဃရ္ၐဏမ် အကုရွွန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","ကိန္တု သ္တိဖာနး ပဝိတြေဏာတ္မနာ ပူရ္ဏော ဘူတွာ ဂဂဏံ ပြတိ သ္ထိရဒၖၐ္ဋိံ ကၖတွာ ဤၑွရသျ ဒက္ၐိဏေ ဒဏ္ဍာယမာနံ ယီၑုဉ္စ ဝိလောကျ ကထိတဝါန်; ");
INSERT INTO sanbur_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","ပၑျ,မေဃဒွါရံ မုက္တမ် ဤၑွရသျ ဒက္ၐိဏေ သ္ထိတံ မာနဝသုတဉ္စ ပၑျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","တဒါ တေ ပြောစ္စဲး ၑဗ္ဒံ ကၖတွာ ကရ္ဏေၐွင်္ဂုလီ ရ္နိဓာယ ဧကစိတ္တီဘူယ တမ် အာကြမန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ပၑ္စာတ် တံ နဂရာဒ် ဗဟိး ကၖတွာ ပြသ္တရဲရာဃ္နန် သာက္ၐိဏော လာကား ၑော်လနာမ္နော ယူနၑ္စရဏသန္နိဓော် နိဇဝသ္တြာဏိ သ္ထာပိတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","အနန္တရံ ဟေ ပြဘော ယီၑေ မဒီယမာတ္မာနံ ဂၖဟာဏ သ္တိဖာနသျေတိ ပြာရ္ထနဝါကျဝဒနသမယေ တေ တံ ပြသ္တရဲရာဃ္နန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","တသ္မာတ် သ ဇာနုနီ ပါတယိတွာ ပြောစ္စဲး ၑဗ္ဒံ ကၖတွာ, ဟေ ပြဘေ ပါပမေတဒ် ဧတေၐု မာ သ္ထာပယ, ဣတျုက္တွာ မဟာနိဒြာံ ပြာပ္နောတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","တသျ ဟတျာကရဏံ ၑော်လောပိ သမမနျတ၊ တသ္မိန် သမယေ ယိရူၑာလမ္နဂရသ္ထာံ မဏ္ဍလီံ ပြတိ မဟာတာဍနာယာံ ဇာတာယာံ ပြေရိတလောကာန် ဟိတွာ သရွွေ'ပရေ ယိဟူဒါၑောမိရောဏဒေၑယော ရ္နာနာသ္ထာနေ ဝိကီရ္ဏား သန္တော ဂတား၊ ");
INSERT INTO sanbur_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","အနျစ္စ ဘက္တလောကာသ္တံ သ္တိဖာနံ ၑ္မၑာနေ သ္ထာပယိတွာ ဗဟု ဝျလပန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","ကိန္တု ၑော်လော ဂၖဟေ ဂၖဟေ ဘြမိတွာ သ္တြိယး ပုရုၐာံၑ္စ ဓၖတွာ ကာရာယာံ ဗဒ္ဓွာ မဏ္ဍလျာ မဟောတ္ပာတံ ကၖတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","အနျစ္စ ယေ ဝိကီရ္ဏာ အဘဝန် တေ သရွွတြ ဘြမိတွာ သုသံဝါဒံ ပြာစာရယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","တဒါ ဖိလိပး ၑောမိရောဏ္နဂရံ ဂတွာ ခြီၐ္ဋာချာနံ ပြာစာရယတ်; ");
INSERT INTO sanbur_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","တတော'ၑုစိ-ဘၖတဂြသ္တလောကေဘျော ဘူတာၑ္စီတ္ကၖတျာဂစ္ဆန် တထာ ဗဟဝး ပက္ၐာဃာတိနး ခဉ္ဇာ လောကာၑ္စ သွသ္ထာ အဘဝန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","တသ္မာတ် လာကာ ဤဒၖၑံ တသျာၑ္စရျျံ ကရ္မ္မ ဝိလောကျ နိၑမျ စ သရွွ ဧကစိတ္တီဘူယ တေနောက္တာချာနေ မနာံသိ နျဒဓုး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","တသ္မိန္နဂရေ မဟာနန္ဒၑ္စာဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","တတး ပူရွွံ တသ္မိန္နဂရေ ၑိမောန္နာမာ ကၑ္စိဇ္ဇနော ဗဟွီ ရ္မာယာကြိယား ကၖတွာ သွံ ကဉ္စန မဟာပုရုၐံ ပြောစျ ၑောမိရောဏီယာနာံ မောဟံ ဇနယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","တသ္မာတ် သ မာနုၐ ဤၑွရသျ မဟာၑက္တိသွရူပ ဣတျုက္တွာ ဗာလဝၖဒ္ဓဝနိတား သရွွေ လာကာသ္တသ္မိန် မနာံသိ နျဒဓုး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","သ ဗဟုကာလာန် မာယာဝိကြိယယာ သရွွာန် အတီဝ မောဟယာဉ္စကာရ, တသ္မာတ် တေ တံ မေနိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","ကိန္တွီၑွရသျ ရာဇျသျ ယီၑုခြီၐ္ဋသျ နာမ္နၑ္စာချာနပြစာရိဏး ဖိလိပသျ ကထာယာံ ဝိၑွသျ တေၐာံ သ္တြီပုရုၐောဘယလောကာ မဇ္ဇိတာ အဘဝန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ၑေၐေ သ ၑိမောနပိ သွယံ ပြတျဲတ် တတော မဇ္ဇိတး သန် ဖိလိပေန ကၖတာမ် အာၑ္စရျျကြိယာံ လက္ၐဏဉ္စ ဝိလောကျာသမ္ဘဝံ မနျမာနသ္တေန သဟ သ္ထိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","ဣတ္ထံ ၑောမိရောဏ္ဒေၑီယလောကာ ဤၑွရသျ ကထာမ် အဂၖဟ္လန် ဣတိ ဝါရ္တ္တာံ ယိရူၑာလမ္နဂရသ္ထပြေရိတား ပြာပျ ပိတရံ ယောဟနဉ္စ တေၐာံ နိကဋေ ပြေၐိတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","တတသ္တော် တတ် သ္ထာနမ် ဥပသ္ထာယ လောကာ ယထာ ပဝိတြမ် အာတ္မာနံ ပြာပ္နုဝန္တိ တဒရ္ထံ ပြာရ္ထယေတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ယတသ္တေ ပုရာ ကေဝလပြဘုယီၑော ရ္နာမ္နာ မဇ္ဇိတမာတြာ အဘဝန်, န တု တေၐာံ မဓျေ ကမပိ ပြတိ ပဝိတြသျာတ္မန အာဝိရ္ဘာဝေါ ဇာတး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","ကိန္တု ပြေရိတာဘျာံ တေၐာံ ဂါတြေၐု ကရေၐွရ္ပိတေၐု သတ္သု တေ ပဝိတြမ် အာတ္မာနမ် ပြာပ္နုဝန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","ဣတ္ထံ လောကာနာံ ဂါတြေၐု ပြေရိတယေား ကရာရ္ပဏေန တာန် ပဝိတြမ် အာတ္မာနံ ပြာပ္တာန် ဒၖၐ္ဋွာ သ ၑိမောန် တယေား သမီပေ မုဒြာ အာနီယ ကထိတဝါန်; ");
INSERT INTO sanbur_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","အဟံ ယသျ ဂါတြေ ဟသ္တမ် အရ္ပယိၐျာမိ တသျာပိ ယထေတ္ထံ ပဝိတြာတ္မပြာပ္တိ ရ္ဘဝတိ တာဒၖၑီံ ၑက္တိံ မဟျံ ဒတ္တံ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","ကိန္တု ပိတရသ္တံ ပြတျဝဒတ် တဝ မုဒြာသ္တွယာ ဝိနၑျန္တု ယတ ဤၑွရသျ ဒါနံ မုဒြာဘိး ကြီယတေ တွမိတ္ထံ ဗုဒ္ဓဝါန်; ");
INSERT INTO sanbur_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ဤၑွရာယ တာဝန္တးကရဏံ သရလံ နဟိ, တသ္မာဒ် အတြ တဝါံၑော'ဓိကာရၑ္စ ကောပိ နာသ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","အတ ဧတတ္ပာပဟေတေား ခေဒါနွိတး သန် ကေနာပိ ပြကာရေဏ တဝ မနသ ဧတသျား ကုကလ္ပနာယား က္ၐမာ ဘဝတိ, ဧတဒရ္ထမ် ဤၑွရေ ပြာရ္ထနာံ ကုရု; ");
INSERT INTO sanbur_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","ယတသ္တွံ တိက္တပိတ္တေ ပါပသျ ဗန္ဓနေ စ ယဒသိ တန္မယာ ဗုဒ္ဓမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","တဒါ ၑိမောန် အကထယတ် တရှိ ယုဝါဘျာမုဒိတာ ကထာ မယိ ယထာ န ဖလတိ တဒရ္ထံ ယုဝါံ မန္နိမိတ္တံ ပြဘော် ပြာရ္ထနာံ ကုရုတံ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","အနေန ပြကာရေဏ တော် သာက္ၐျံ ဒတ္တွာ ပြဘေား ကထာံ ပြစာရယန္တော် ၑောမိရောဏီယာနာမ် အနေကဂြာမေၐု သုသံဝါဒဉ္စ ပြစာရယန္တော် ယိရူၑာလမ္နဂရံ ပရာဝၖတျ ဂတော်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","တတး ပရမ် ဤၑွရသျ ဒူတး ဖိလိပမ် ဣတျာဒိၑတ်, တွမုတ္ထာယ ဒက္ၐိဏသျာံ ဒိၑိ ယော မာရ္ဂော ပြာန္တရသျ မဓျေန ယိရူၑာလမော 'သာနဂရံ ယာတိ တံ မာရ္ဂံ ဂစ္ဆ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","တတး သ ဥတ္ထာယ ဂတဝါန်; တဒါ ကန္ဒာကီနာမ္နး ကူၑ္လောကာနာံ ရာဇ္ဉျား သရွွသမ္ပတ္တေရဓီၑး ကူၑဒေၑီယ ဧကး ၐဏ္ဍော ဘဇနာရ္ထံ ယိရူၑာလမ္နဂရမ် အာဂတျ ");
INSERT INTO sanbur_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ပုနရပိ ရထမာရုဟျ ယိၑယိယနာမ္နော ဘဝိၐျဒွါဒိနော ဂြန္ထံ ပဌန် ပြတျာဂစ္ဆတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ဧတသ္မိန် သမယေ အာတ္မာ ဖိလိပမ် အဝဒတ်, တွမ် ရထသျ သမီပံ ဂတွာ တေန သာရ္ဒ္ဓံ မိလ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","တသ္မာတ် သ ဓာဝန် တသျ သန္နိဓာဝုပသ္ထာယ တေန ပဌျမာနံ ယိၑယိယထဝိၐျဒွါဒိနော ဝါကျံ ၑြုတွာ ပၖၐ္ဋဝါန် ယတ် ပဌသိ တတ် ကိံ ဗုဓျသေ? ");
INSERT INTO sanbur_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","တတး သ ကထိတဝါန် ကေနစိန္န ဗောဓိတောဟံ ကထံ ဗုဓျေယ? တတး သ ဖိလိပံ ရထမာရောဎုံ သွေန သာရ္ဒ္ဓမ် ဥပဝေၐ္ဋုဉ္စ နျဝေဒယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","သ ၑာသ္တြသျေတဒွါကျံ ပဌိတဝါန် ယထာ, သမာနီယတ ဃာတာယ သ ယထာ မေၐၑာဝကး၊ လောမစ္ဆေဒကသာက္ၐာစ္စ မေၐၑ္စ နီရဝေါ ယထာ၊ အာဗဓျ ဝဒနံ သွီယံ တထာ သ သမတိၐ္ဌတ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","အနျာယေန ဝိစာရေဏ သ ဥစ္ဆိန္နော 'ဘဝတ် တဒါ၊ တတ္ကာလီနမနုၐျာန် ကော ဇနော ဝရ္ဏယိတုံ က္ၐမး၊ ယတော ဇီဝန္နၖဏာံ ဒေၑာတ် သ ဥစ္ဆိန္နော 'ဘဝတ် ဓြုဝံ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","အနန္တရံ သ ဖိလိပမ် အဝဒတ် နိဝေဒယာမိ, ဘဝိၐျဒွါဒီ ယာမိမာံ ကထာံ ကထယာမာသ သ ကိံ သွသ္မိန် ဝါ ကသ္မိံၑ္စိဒ် အနျသ္မိန်? ");
INSERT INTO sanbur_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","တတး ဖိလိပသ္တတ္ပြကရဏမ် အာရဘျ ယီၑောရုပါချာနံ တသျာဂြေ ပြာသ္တော်တ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ဣတ္ထံ မာရ္ဂေဏ ဂစ္ဆန္တော် ဇလာၑယသျ သမီပ ဥပသ္ထိတော်; တဒါ က္လီဗော'ဝါဒီတ် ပၑျာတြ သ္ထာနေ ဇလမာသ္တေ မမ မဇ္ဇနေ ကာ ဗာဓာ? ");
INSERT INTO sanbur_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","တတး ဖိလိပ ဥတ္တရံ ဝျာဟရတ် သွာန္တးကရဏေန သာကံ ယဒိ ပြတျေၐိ တရှိ ဗာဓာ နာသ္တိ၊ တတး သ ကထိတဝါန် ယီၑုခြီၐ္ဋ ဤၑွရသျ ပုတြ ဣတျဟံ ပြတျေမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","တဒါ ရထံ သ္ထဂိတံ ကရ္တ္တုမ် အာဒိၐ္ဋေ ဖိလိပက္လီဗော် ဒွေါ် ဇလမ် အဝါရုဟတာံ; တဒါ ဖိလိပသ္တမ် မဇ္ဇယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","တတ္ပၑ္စာတ် ဇလမဓျာဒ် ဥတ္ထိတယေား သတေား ပရမေၑွရသျာတ္မာ ဖိလိပံ ဟၖတွာ နီတဝါန်, တသ္မာတ် က္လီဗး ပုနသ္တံ န ဒၖၐ္ဋဝါန် တထာပိ ဟၖၐ္ဋစိတ္တး သန် သွမာရ္ဂေဏ ဂတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ဖိလိပၑ္စာသ္ဒောဒ္နဂရမ် ဥပသ္ထာယ တသ္မာတ် ကဲသရိယာနဂရ ဥပသ္ထိတိကာလပရျျနတံ သရွွသ္မိန္နဂရေ သုသံဝါဒံ ပြစာရယန် ဂတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","တတ္ကာလပရျျနတံ ၑော်လး ပြဘေား ၑိၐျာဏာံ ပြာတိကူလျေန တာဍနာဗဓယေား ကထာံ နိးသာရယန် မဟာယာဇကသျ သန္နိဓိံ ဂတွာ ");
INSERT INTO sanbur_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","သ္တြိယံ ပုရုၐဉ္စ တန္မတဂြာဟိဏံ ယံ ကဉ္စိတ် ပၑျတိ တာန် ဓၖတွာ ဗဒ္ဓွာ ယိရူၑာလမမ် အာနယတီတျာၑယေန ဒမ္မေၐက္နဂရီယံ ဓရ္မ္မသမာဇာန် ပြတိ ပတြံ ယာစိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","ဂစ္ဆန် တု ဒမ္မေၐက္နဂရနိကဋ ဥပသ္ထိတဝါန်; တတော'ကသ္မာဒ် အာကာၑာတ် တသျ စတုရ္ဒိက္ၐု တေဇသး ပြကာၑနာတ် သ ဘူမာဝပတတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","ပၑ္စာတ် ဟေ ၑော်လ ဟေ ၑော်လ ကုတော မာံ တာဍယသိ? သွံ ပြတိ ပြောက္တမ် ဧတံ ၑဗ္ဒံ ၑြုတွာ ");
INSERT INTO sanbur_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","သ ပၖၐ္ဋဝါန်, ဟေ ပြဘော ဘဝါန် ကး? တဒါ ပြဘုရကထယတ် ယံ ယီၑုံ တွံ တာဍယသိ သ ဧဝါဟံ; ကဏ္ဋကသျ မုခေ ပဒါဃာတကရဏံ တဝ ကၐ္ဋမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","တဒါ ကမ္ပမာနော ဝိသ္မယာပန္နၑ္စ သောဝဒတ် ဟေ ပြဘော မယာ ကိံ ကရ္တ္တဝျံ? ဘဝတ ဣစ္ဆာ ကာ? တတး ပြဘုရာဇ္ဉာပယဒ် ဥတ္ထာယ နဂရံ ဂစ္ဆ တတြ တွယာ ယတ် ကရ္တ္တဝျံ တဒ် ဝဒိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","တသျ သင်္ဂိနော လောကာ အပိ တံ ၑဗ္ဒံ ၑြုတဝန္တး ကိန္တု ကမပိ န ဒၖၐ္ဋွာ သ္တဗ္ဓား သန္တး သ္ထိတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","အနန္တရံ ၑော်လော ဘူမိတ ဥတ္ထာယ စက္ၐုၐီ ဥန္မီလျ ကမပိ န ဒၖၐ္ဋဝါန်၊ တဒါ လောကာသ္တသျ ဟသ္တော် ဓၖတွာ ဒမ္မေၐက္နဂရမ် အာနယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","တတး သ ဒိနတြယံ ယာဝဒ် အန္ဓော ဘူတွာ န ဘုက္တဝါန် ပီတဝါံၑ္စ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","တဒနန္တရံ ပြဘုသ္တဒ္ဒမ္မေၐက္နဂရဝါသိန ဧကသ္မဲ ၑိၐျာယ ဒရ္ၑနံ ဒတွာ အာဟူတဝါန် ဟေ အနနိယ၊ တတး သ ပြတျဝါဒီတ်, ဟေ ပြဘော ပၑျ ၑၖဏောမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","တဒါ ပြဘုသ္တမာဇ္ဉာပယတ် တွမုတ္ထာယ သရလနာမာနံ မာရ္ဂံ ဂတွာ ယိဟူဒါနိဝေၑနေ တာရ္ၐနဂရီယံ ၑော်လနာမာနံ ဇနံ ဂဝေၐယန် ပၖစ္ဆ; ");
INSERT INTO sanbur_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ပၑျ သ ပြာရ္ထယတေ, တထာ အနနိယနာမက ဧကော ဇနသ္တသျ သမီပမ် အာဂတျ တသျ ဂါတြေ ဟသ္တာရ္ပဏံ ကၖတွာ ဒၖၐ္ဋိံ ဒဒါတီတ္ထံ သွပ္နေ ဒၖၐ္ဋဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","တသ္မာဒ် အနနိယး ပြတျဝဒတ် ဟေ ပြဘော ယိရူၑာလမိ ပဝိတြလောကာန် ပြတိ သော'နေကဟိံသာံ ကၖတဝါန်; ");
INSERT INTO sanbur_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","အတြ သ္ထာနေ စ ယေ လောကာသ္တဝ နာမ္နိ ပြာရ္ထယန္တိ တာနပိ ဗဒ္ဓုံ သ ပြဓာနယာဇကေဘျး ၑက္တိံ ပြာပ္တဝါန်, ဣမာံ ကထာမ် အဟမ် အနေကေၐာံ မုခေဘျး ၑြုတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","ကိန္တု ပြဘုရကထယတ်, ယာဟိ ဘိန္နဒေၑီယလောကာနာံ ဘူပတီနာမ် ဣသြာယေလ္လောကာနာဉ္စ နိကဋေ မမ နာမ ပြစာရယိတုံ သ ဇနော မမ မနောနီတပါတြမာသ္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","မမ နာမနိမိတ္တဉ္စ တေန ကိယာန် မဟာန် က္လေၑော ဘောက္တဝျ ဧတတ် တံ ဒရ္ၑယိၐျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","တတော 'နနိယော ဂတွာ ဂၖဟံ ပြဝိၑျ တသျ ဂါတြေ ဟသ္တာရ္ပြဏံ ကၖတွာ ကထိတဝါန်, ဟေ ဘြာတး ၑော်လ တွံ ယထာ ဒၖၐ္ဋိံ ပြာပ္နောၐိ ပဝိတြေဏာတ္မနာ ပရိပူရ္ဏော ဘဝသိ စ, တဒရ္ထံ တဝါဂမနကာလေ ယး ပြဘုယီၑုသ္တုဘျံ ဒရ္ၑနမ် အဒဒါတ် သ မာံ ပြေၐိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ဣတျုက္တမာတြေ တသျ စက္ၐုရ္ဘျာမ် မီနၑလ္ကဝဒ် ဝသ္တုနိ နိရ္ဂတေ တတ္က္ၐဏာတ် သ ပြသန္နစက္ၐု ရ္ဘူတွာ ပြောတ္ထာယ မဇ္ဇိတော'ဘဝတ် ဘုက္တွာ ပီတွာ သဗလောဘဝစ္စ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","တတး ပရံ ၑော်လး ၑိၐျဲး သဟ ကတိပယဒိဝသာန် တသ္မိန် ဒမ္မေၐကနဂရေ သ္ထိတွာ'ဝိလမ္ဗံ ");
INSERT INTO sanbur_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","သရွွဘဇနဘဝနာနိ ဂတွာ ယီၑုရီၑွရသျ ပုတြ ဣမာံ ကထာံ ပြာစာရယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","တသ္မာတ် သရွွေ ၑြောတာရၑ္စမတ္ကၖတျ ကထိတဝန္တော ယော ယိရူၑာလမ္နဂရ ဧတန္နာမ္နာ ပြာရ္ထယိတၖလောကာန် ဝိနာၑိတဝါန် ဧဝမ် ဧတာဒၖၑလောကာန် ဗဒ္ဓွာ ပြဓာနယာဇကနိကဋံ နယတီတျာၑယာ ဧတတ္သ္ထာနမပျာဂစ္ဆတ် သဧဝ ကိမယံ န ဘဝတိ? ");
INSERT INTO sanbur_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","ကိန္တု ၑော်လး ကြမၑ ဥတ္သာဟဝါန် ဘူတွာ ယီၑုရီၑွရေဏာဘိၐိက္တော ဇန ဧတသ္မိန် ပြမာဏံ ဒတွာ ဒမ္မေၐက်-နိဝါသိယိဟူဒီယလောကာန် နိရုတ္တရာန် အကရောတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ဣတ္ထံ ဗဟုတိထေ ကာလေ ဂတေ ယိဟူဒီယလောကာသ္တံ ဟန္တုံ မန္တြယာမာသုး ");
INSERT INTO sanbur_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ကိန္တု ၑော်လသ္တေၐာမေတသျာ မန္တြဏာယာ ဝါရ္တ္တာံ ပြာပ္တဝါန်၊ တေ တံ ဟန္တုံ တု ဒိဝါနိၑံ ဂုပ္တား သန္တော နဂရသျ ဒွါရေ'တိၐ္ဌန်; ");
INSERT INTO sanbur_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","တသ္မာတ် ၑိၐျာသ္တံ နီတွာ ရာတြော် ပိဋကေ နိဓာယ ပြာစီရေဏာဝါရောဟယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","တတး ပရံ ၑော်လော ယိရူၑာလမံ ဂတွာ ၑိၐျဂဏေန သာရ္ဒ္ဓံ သ္ထာတုမ် အဲဟတ်, ကိန္တု သရွွေ တသ္မာဒဗိဘယုး သ ၑိၐျ ဣတိ စ န ပြတျယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","ဧတသ္မာဒ် ဗရ္ဏဗ္ဗာသ္တံ ဂၖဟီတွာ ပြေရိတာနာံ သမီပမာနီယ မာရ္ဂမဓျေ ပြဘုး ကထံ တသ္မဲ ဒရ္ၑနံ ဒတ္တဝါန် ယား ကထာၑ္စ ကထိတဝါန် သ စ ယထာက္ၐောဘး သန် ဒမ္မေၐက္နဂရေ ယီၑော ရ္နာမ ပြာစာရယတ် ဧတာန် သရွွဝၖတ္တာန္တာန် တာန် ဇ္ဉာပိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","တတး ၑော်လသ္တဲး သဟ ယိရူၑာလမိ ကာလံ ယာပယန် နိရ္ဘယံ ပြဘော ရျီၑော ရ္နာမ ပြာစာရယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","တသ္မာဒ် အနျဒေၑီယလောကဲး သာရ္ဒ္ဓံ ဝိဝါဒသျောပသ္ထိတတွာတ် တေ တံ ဟန္တုမ် အစေၐ္ဋန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","ကိန္တု ဘြာတၖဂဏသ္တဇ္ဇ္ဉာတွာ တံ ကဲသရိယာနဂရံ နီတွာ တာရ္ၐနဂရံ ပြေၐိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ဣတ္ထံ သတိ ယိဟူဒိယာဂါလီလ္ၑောမိရောဏဒေၑီယား သရွွာ မဏ္ဍလျော ဝိၑြာမံ ပြာပ္တာသ္တတသ္တာသာံ နိၐ္ဌာဘဝတ် ပြဘော ရ္ဘိယာ ပဝိတြသျာတ္မနး သာန္တွနယာ စ ကာလံ က္ၐေပယိတွာ ဗဟုသံချာ အဘဝန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","တတး ပရံ ပိတရး သ္ထာနေ သ္ထာနေ ဘြမိတွာ ၑေၐေ လောဒ္နဂရနိဝါသိပဝိတြလောကာနာံ သမီပေ သ္ထိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","တဒါ တတြ ပက္ၐာဃာတဝျာဓိနာၐ္ဋော် ဝတ္သရာန် ၑယျာဂတမ် အဲနေယနာမာနံ မနုၐျံ သာက္ၐတ် ပြာပျ တမဝဒတ်, ");
INSERT INTO sanbur_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ဟေ အဲနေယ ယီၑုခြီၐ္ဋသ္တွာံ သွသ္ထမ် အကာရ္ၐီတ်, တွမုတ္ထာယ သွၑယျာံ နိက္ၐိပ, ဣတျုက္တမာတြေ သ ဥဒတိၐ္ဌတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ဧတာဒၖၑံ ဒၖၐ္ဋွာ လောဒ္ၑါရောဏနိဝါသိနော လောကား ပြဘုံ ပြတိ ပရာဝရ္တ္တန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","အပရဉ္စ ဘိက္ၐာဒါနာဒိၐု နာနကြိယာသု နိတျံ ပြဝၖတ္တာ ယာ ယာဖောနဂရနိဝါသိနီ ဋာဗိထာနာမာ ၑိၐျာ ယာံ ဒရ္က္ကာံ အရ္ထာဒ် ဟရိဏီမယုက္တွာ အာဟွယန် သာ နာရီ ");
INSERT INTO sanbur_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","တသ္မိန် သမယေ ရုဂ္နာ သတီ ပြာဏာန် အတျဇတ်, တတော လောကာသ္တာံ ပြက္ၐာလျောပရိသ္ထပြကောၐ္ဌေ ၑာယယိတွာသ္ထာပယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","လောဒ္နဂရံ ယာဖောနဂရသျ သမီပသ္ထံ တသ္မာတ္တတြ ပိတရ အာသ္တေ, ဣတိ ဝါရ္တ္တာံ ၑြုတွာ တူရ္ဏံ တသျာဂမနာရ္ထံ တသ္မိန် ဝိနယမုက္တွာ ၑိၐျဂဏော ဒွေါ် မနုဇော် ပြေၐိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","တသ္မာတ် ပိတရ ဥတ္ထာယ တာဘျာံ သာရ္ဒ္ဓမ် အာဂစ္ဆတ်, တတြ တသ္မိန် ဥပသ္ထိတ ဥပရိသ္ထပြကောၐ္ဌံ သမာနီတေ စ ဝိဓဝါး သွာဘိး သဟ သ္ထိတိကာလေ ဒရ္က္ကယာ ကၖတာနိ ယာနျုတ္တရီယာဏိ ပရိဓေယာနိ စ တာနိ သရွွာဏိ တံ ဒရ္ၑယိတွာ ရုဒတျၑ္စတသၖၐု ဒိက္ၐွတိၐ္ဌန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","ကိန္တု ပိတရသ္တား သရွွာ ဗဟိး ကၖတွာ ဇာနုနီ ပါတယိတွာ ပြာရ္ထိတဝါန်; ပၑ္စာတ် ၑဝံ ပြတိ ဒၖၐ္ဋိံ ကၖတွာ ကထိတဝါန်, ဟေ ဋာဗီထေ တွမုတ္တိၐ္ဌ, ဣတိ ဝါကျ ဥက္တေ သာ သ္တြီ စက္ၐုၐီ ပြောန္မီလျ ပိတရမ် အဝလောကျောတ္ထာယောပါဝိၑတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","တတး ပိတရသ္တသျား ကရော် ဓၖတွာ ဥတ္တောလျ ပဝိတြလောကာန် ဝိဓဝါၑ္စာဟူယ တေၐာံ နိကဋေ သဇီဝါံ တာံ သမာရ္ပယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ဧၐာ ကထာ သမသ္တယာဖောနဂရံ ဝျာပ္တာ တသ္မာဒ် အနေကေ လောကား ပြဘော် ဝျၑွသန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","အပရဉ္စ ပိတရသ္တဒျာဖောနဂရီယသျ ကသျစိတ် ၑိမောန္နာမ္နၑ္စရ္မ္မကာရသျ ဂၖဟေ ဗဟုဒိနာနိ နျဝသတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","ကဲသရိယာနဂရ ဣတာလိယာချသဲနျာန္တရ္ဂတး ကရ္ဏီလိယနာမာ သေနာပတိရာသီတ္ ");
INSERT INTO sanbur_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","သ သပရိဝါရော ဘက္တ ဤၑွရပရာယဏၑ္စာသီတ်; လောကေဘျော ဗဟူနိ ဒါနာဒီနိ ဒတွာ နိရန္တရမ် ဤၑွရေ ပြာရ္ထယာဉ္စကြေ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ဧကဒါ တၖတီယပြဟရဝေလာယာံ သ ဒၖၐ္ဋဝါန် ဤၑွရသျဲကော ဒူတး သပြကာၑံ တတ္သမီပမ် အာဂတျ ကထိတဝါန်, ဟေ ကရ္ဏီလိယ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","ကိန္တု သ တံ ဒၖၐ္ဋွာ ဘီတော'ကထယတ်, ဟေ ပြဘော ကိံ? တဒါ တမဝဒတ် တဝ ပြာရ္ထနာ ဒါနာဒိ စ သာက္ၐိသွရူပံ ဘူတွေၑွရသျ ဂေါစရမဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ဣဒါနီံ ယာဖောနဂရံ ပြတိ လောကာန် ပြေၐျ သမုဒြတီရေ ၑိမောန္နာမ္နၑ္စရ္မ္မကာရသျ ဂၖဟေ ပြဝါသကာရီ ပိတရနာမ္နာ ဝိချာတော ယး ၑိမောန် တမ် အာဟွာယယ; ");
INSERT INTO sanbur_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","တသ္မာတ် တွယာ ယဒျတ် ကရ္တ္တဝျံ တတ္တတ် သ ဝဒိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ဣတျုပဒိၑျ ဒူတေ ပြသ္ထိတေ သတိ ကရ္ဏီလိယး သွဂၖဟသ္ထာနာံ ဒါသာနာံ ဒွေါ် ဇနော် နိတျံ သွသင်္ဂိနာံ သဲနျာနာမ် ဧကာံ ဘက္တသေနာဉ္စာဟူယ ");
INSERT INTO sanbur_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","သကလမေတံ ဝၖတ္တာန္တံ ဝိဇ္ဉာပျ ယာဖောနဂရံ တာန် ပြာဟိဏောတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","ပရသ္မိန် ဒိနေ တေ ယာတြာံ ကၖတွာ ယဒါ နဂရသျ သမီပ ဥပါတိၐ္ဌန်, တဒါ ပိတရော ဒွိတီယပြဟရဝေလာယာံ ပြာရ္ထယိတုံ ဂၖဟပၖၐ္ဌမ် အာရောဟတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ဧတသ္မိန် သမယေ က္ၐုဓာရ္တ္တး သန် ကိဉ္စိဒ် ဘောက္တုမ် အဲစ္ဆတ် ကိန္တု တေၐာမ် အန္နာသာဒနသမယေ သ မူရ္စ္ဆိတး သန္နပတတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","တတော မေဃဒွါရံ မုက္တံ စတုရ္ဘိး ကောဏဲ ရ္လမ္ဗိတံ ဗၖဟဒွသ္တြမိဝ ကိဉ္စန ဘာဇနမ် အာကာၑာတ် ပၖထိဝီမ် အဝါရောဟတီတိ ဒၖၐ္ဋဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","တန္မဓျေ နာနပြကာရာ ဂြာမျဝနျပၑဝး ခေစရောရောဂါမိပြဘၖတယော ဇန္တဝၑ္စာသန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","အနန္တရံ ဟေ ပိတရ ဥတ္ထာယ ဟတွာ ဘုံက္ၐွ တမ္ပြတီယံ ဂဂဏီယာ ဝါဏီ ဇာတာ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","တဒါ ပိတရး ပြတျဝဒတ်, ဟေ ပြဘော ဤဒၖၑံ မာ ဘဝတု, အဟမ် ဧတတ် ကာလံ ယာဝတ် နိၐိဒ္ဓမ် အၑုစိ ဝါ ဒြဝျံ ကိဉ္စိဒပိ န ဘုက္တဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","တတး ပုနရပိ တာဒၖၑီ ဝိဟယသီယာ ဝါဏီ ဇာတာ ယဒ် ဤၑွရး ၑုစိ ကၖတဝါန် တတ် တွံ နိၐိဒ္ဓံ န ဇာနီဟိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ဣတ္ထံ တြိး သတိ တတ် ပါတြံ ပုနရာကၖၐ္ဋံ အာကာၑမ် အဂစ္ဆတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","တတး ပရံ ယဒ် ဒရ္ၑနံ ပြာပ္တဝါန် တသျ ကော ဘာဝ ဣတျတြ ပိတရော မနသာ သန္ဒေဂ္ဓိ, ဧတသ္မိန် သမယေ ကရ္ဏီလိယသျ တေ ပြေၐိတာ မနုၐျာ ဒွါရသျ သန္နိဓာဝုပသ္ထာယ, ");
INSERT INTO sanbur_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ၑိမောနော ဂၖဟမနွိစ္ဆန္တး သမ္ပၖဆျာဟူယ ကထိတဝန္တး ပိတရနာမ္နာ ဝိချာတော ယး ၑိမောန် သ ကိမတြ ပြဝသတိ? ");
INSERT INTO sanbur_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","ယဒါ ပိတရသ္တဒ္ဒရ္ၑနသျ ဘာဝံ မနသာန္ဒောလယတိ တဒါတ္မာ တမဝဒတ်, ပၑျ တြယော ဇနာသ္တွာံ မၖဂယန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","တွမ် ဥတ္ထာယာဝရုဟျ နိးသန္ဒေဟံ တဲး သဟ ဂစ္ဆ မယဲဝ တေ ပြေၐိတား၊ ");
INSERT INTO sanbur_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","တသ္မာတ် ပိတရော'ဝရုဟျ ကရ္ဏီလိယပြေရိတလောကာနာံ နိကဋမာဂတျ ကထိတဝါန် ပၑျတ ယူယံ ယံ မၖဂယဓွေ သ ဇနောဟံ, ယူယံ ကိန္နိမိတ္တမ် အာဂတား? ");
INSERT INTO sanbur_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","တတသ္တေ ပြတျဝဒန် ကရ္ဏီလိယနာမာ ၑုဒ္ဓသတ္တွ ဤၑွရပရာယဏော ယိဟူဒီယဒေၑသ္ထာနာံ သရွွေၐာံ သန္နိဓော် သုချာတျာပန္န ဧကး သေနာပတိ ရ္နိဇဂၖဟံ တွာမာဟူယ နေတုံ တွတ္တး ကထာ ၑြောတုဉ္စ ပဝိတြဒူတေန သမာဒိၐ္ဋး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","တဒါ ပိတရသ္တာနဘျန္တရံ နီတွာ တေၐာမာတိထျံ ကၖတဝါန်, ပရေ'ဟနိ တဲး သာရ္ဒ္ဓံ ယာတြာမကရောတ်, ယာဖောနိဝါသိနာံ ဘြာတၖဏာံ ကိယန္တော ဇနာၑ္စ တေန သဟ ဂတား၊ ");
INSERT INTO sanbur_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","ပရသ္မိန် ဒိဝသေ ကဲသရိယာနဂရမဓျပြဝေၑသမယေ ကရ္ဏီလိယော ဇ္ဉာတိဗန္ဓူန် အာဟူယာနီယ တာန် အပေက္ၐျ သ္ထိတး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","ပိတရေ ဂၖဟ ဥပသ္ထိတေ ကရ္ဏီလိယသ္တံ သာက္ၐာတ္ကၖတျ စရဏယေား ပတိတွာ ပြာဏမတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","ပိတရသ္တမုတ္ထာပျ ကထိတဝါန်, ဥတ္တိၐ္ဌာဟမပိ မာနုၐး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","တဒါ ကရ္ဏီလိယေန သာကမ် အာလပန် ဂၖဟံ ပြာဝိၑတ် တန္မဓျေ စ ဗဟုလောကာနာံ သမာဂမံ ဒၖၐ္ဋွာ တာန် အဝဒတ်, ");
INSERT INTO sanbur_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","အနျဇာတီယလောကဲး မဟာလပနံ ဝါ တေၐာံ ဂၖဟမဓျေ ပြဝေၑနံ ယိဟူဒီယာနာံ နိၐိဒ္ဓမ် အသ္တီတိ ယူယမ် အဝဂစ္ဆထ; ကိန္တု ကမပိ မာနုၐမ် အဝျဝဟာရျျမ် အၑုစိံ ဝါ ဇ္ဉာတုံ မမ နောစိတမ် ဣတိ ပရမေၑွရော မာံ ဇ္ဉာပိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ဣတိ ဟေတောရာဟွာနၑြဝဏမာတြာတ် ကာဉ္စနာပတ္တိမ် အကၖတွာ ယုၐ္မာကံ သမီပမ် အာဂတောသ္မိ; ပၖစ္ဆာမိ ယူယံ ကိန္နိမိတ္တံ မာမ် အာဟူယတ? ");
INSERT INTO sanbur_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","တဒါ ကရ္ဏီလိယး ကထိတဝါန်, အဒျ စတွာရိ ဒိနာနိ ဇာတာနိ ဧတာဝဒွေလာံ ယာဝဒ် အဟမ် အနာဟာရ အာသန် တတသ္တၖတီယပြဟရေ သတိ ဂၖဟေ ပြာရ္ထနသမယေ တေဇောမယဝသ္တြဘၖဒ် ဧကော ဇနော မမ သမက္ၐံ တိၐ္ဌန် ဧတာံ ကထာမ် အကထယတ်, ");
INSERT INTO sanbur_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ဟေ ကရ္ဏီလိယ တွဒီယာ ပြာရ္ထနာ ဤၑွရသျ ကရ္ဏဂေါစရီဘူတာ တဝ ဒါနာဒိ စ သာက္ၐိသွရူပံ ဘူတွာ တသျ ဒၖၐ္ဋိဂေါစရမဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","အတော ယာဖောနဂရံ ပြတိ လောကာန် ပြဟိတျ တတြ သမုဒြတီရေ ၑိမောန္နာမ္နး ကသျစိစ္စရ္မ္မကာရသျ ဂၖဟေ ပြဝါသကာရီ ပိတရနာမ္နာ ဝိချာတော ယး ၑိမောန် တမာဟူाယယ; တတး သ အာဂတျ တွာမ် ဥပဒေက္ၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ဣတိ ကာရဏာတ် တတ္က္ၐဏာတ် တဝ နိကဋေ လောကာန် ပြေၐိတဝါန်, တွမာဂတဝါန် ဣတိ ဘဒြံ ကၖတဝါန်၊ ဤၑွရော ယာနျာချာနာနိ ကထယိတုမ် အာဒိၑတ် တာနိ ၑြောတုံ ဝယံ သရွွေ သာမ္ပြတမ် ဤၑွရသျ သာက္ၐာဒ် ဥပသ္ထိတား သ္မး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","တဒါ ပိတရ ဣမာံ ကထာံ ကထယိတုမ် အာရဗ္ဓဝါန်, ဤၑွရော မနုၐျာဏာမ် အပက္ၐပါတီ သန္ ");
INSERT INTO sanbur_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ယသျ ကသျစိဒ် ဒေၑသျ ယော လောကာသ္တသ္မာဒ္ဘီတွာ သတ္ကရ္မ္မ ကရောတိ သ တသျ ဂြာဟျော ဘဝတိ, ဧတသျ နိၑ္စယမ် ဥပလဗ္ဓဝါနဟမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","သရွွေၐာံ ပြဘု ရျော ယီၑုခြီၐ္ဋသ္တေန ဤၑွရ ဣသြာယေလွံၑာနာံ နိကဋေ သုသံဝါဒံ ပြေၐျ သမ္မေလနသျ ယံ သံဝါဒံ ပြာစာရယတ် တံ သံဝါဒံ ယူယံ ၑြုတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","ယတော ယောဟနာ မဇ္ဇနေ ပြစာရိတေ သတိ သ ဂါလီလဒေၑမာရဘျ သမသ္တယိဟူဒီယဒေၑံ ဝျာပ္နောတ်; ");
INSERT INTO sanbur_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ဖလတ ဤၑွရေဏ ပဝိတြေဏာတ္မနာ ၑက္တျာ စာဘိၐိက္တော နာသရတီယယီၑုး သ္ထာနေ သ္ထာနေ ဘြမန် သုကြိယာံ ကုရွွန် ၑဲတာနာ က္လိၐ္ဋာန် သရွွလောကာန် သွသ္ထာန် အကရောတ်, ယတ ဤၑွရသ္တသျ သဟာယ အာသီတ်; ");
INSERT INTO sanbur_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","ဝယဉ္စ ယိဟူဒီယဒေၑေ ယိရူၑာလမ္နဂရေ စ တေန ကၖတာနာံ သရွွေၐာံ ကရ္မ္မဏာံ သာက္ၐိဏော ဘဝါမး၊ လောကာသ္တံ ကြုၑေ ဝိဒ္ဓွာ ဟတဝန္တး, ");
INSERT INTO sanbur_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ကိန္တု တၖတီယဒိဝသေ ဤၑွရသ္တမုတ္ထာပျ သပြကာၑမ် အဒရ္ၑယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","သရွွလောကာနာံ နိကဋ ဣတိ န ဟိ, ကိန္တု တသ္မိန် ၑ္မၑာနာဒုတ္ထိတေ သတိ တေန သာရ္ဒ္ဓံ ဘောဇနံ ပါနဉ္စ ကၖတဝန္တ ဧတာဒၖၑာ ဤၑွရသျ မနောနီတား သာက္ၐိဏော ယေ ဝယမ် အသ္မာကံ နိကဋေ တမဒရ္ၑယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ဇီဝိတမၖတောဘယလောကာနာံ ဝိစာရံ ကရ္တ္တုမ် ဤၑွရော ယံ နိယုက္တဝါန် သ ဧဝ သ ဇနး, ဣမာံ ကထာံ ပြစာရယိတုံ တသ္မိန် ပြမာဏံ ဒါတုဉ္စ သော'သ္မာန် အာဇ္ဉာပယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","ယသ္တသ္မိန် ဝိၑွသိတိ သ တသျ နာမ္နာ ပါပါန္မုက္တော ဘဝိၐျတိ တသ္မိန် သရွွေ ဘဝိၐျဒွါဒိနောပိ ဧတာဒၖၑံ သာက္ၐျံ ဒဒတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","ပိတရသျဲတတ္ကထာကထနကာလေ သရွွေၐာံ ၑြောတၖဏာမုပရိ ပဝိတြ အာတ္မာဝါရောဟတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","တတး ပိတရေဏ သာရ္ဒ္ဓမ် အာဂတာသ္တွက္ဆေဒိနော ဝိၑွာသိနော လောကာ အနျဒေၑီယေဘျး ပဝိတြ အာတ္မနိ ဒတ္တေ သတိ ");
INSERT INTO sanbur_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","တေ နာနာဇာတီယဘာၐာဘိး ကထာံ ကထယန္တ ဤၑွရံ ပြၑံသန္တိ, ဣတိ ဒၖၐ္ဋွာ ၑြုတွာ စ ဝိသ္မယမ် အာပဒျန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","တဒါ ပိတရး ကထိတဝါန်, ဝယမိဝ ယေ ပဝိတြမ် အာတ္မာနံ ပြာပ္တာသ္တေၐာံ ဇလမဇ္ဇနံ ကိံ ကောပိ နိၐေဒ္ဓုံ ၑက္နောတိ? ");
INSERT INTO sanbur_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","တတး ပြဘော ရ္နာမ္နာ မဇ္ဇိတာ ဘဝတေတိ တာနာဇ္ဉာပယတ်၊ အနန္တရံ တေ သွဲး သာရ္ဒ္ဓံ ကတိပယဒိနာနိ သ္ထာတုံ ပြာရ္ထယန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","ဣတ္ထံ ဘိန္နဒေၑီယလောကာ အပီၑွရသျ ဝါကျမ် အဂၖဟ္လန် ဣမာံ ဝါရ္တ္တာံ ယိဟူဒီယဒေၑသ္ထပြေရိတာ ဘြာတၖဂဏၑ္စ ၑြုတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","တတး ပိတရေ ယိရူၑာလမ္နဂရံ ဂတဝတိ တွက္ဆေဒိနော လောကာသ္တေန သဟ ဝိဝဒမာနာ အဝဒန်, ");
INSERT INTO sanbur_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","တွမ် အတွက္ဆေဒိလောကာနာံ ဂၖဟံ ဂတွာ တဲး သာရ္ဒ္ဓံ ဘုက္တဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","တတး ပိတရ အာဒိတး ကြမၑသ္တတ္ကာရျျသျ သရွွဝၖတ္တာန္တမာချာတုမ် အာရဗ္ဓဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","ယာဖောနဂရ ဧကဒါဟံ ပြာရ္ထယမာနော မူရ္စ္ဆိတး သန် ဒရ္ၑနေန စတုရ္ၐု ကောဏေၐု လမ္ဗနမာနံ ဝၖဟဒွသ္တြမိဝ ပါတြမေကမ် အာကာၑဒဝရုဟျ မန္နိကဋမ် အာဂစ္ဆဒ် အပၑျမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ပၑ္စာတ် တဒ် အနနျဒၖၐ္ဋျာ ဒၖၐ္ဋွာ ဝိဝိစျ တသျ မဓျေ နာနာပြကာရာန် ဂြာမျဝနျပၑူန် ဥရောဂါမိခေစရာံၑ္စ ဒၖၐ္ဋဝါန်; ");
INSERT INTO sanbur_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","ဟေ ပိတရ တွမုတ္ထာယ ဂတွာ ဘုံက္ၐွ မာံ သမ္ဗောဓျ ကထယန္တံ ၑဗ္ဒမေကံ ၑြုတဝါံၑ္စ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","တတောဟံ ပြတျဝဒံ, ဟေ ပြဘော နေတ္ထံ ဘဝတု, ယတး ကိဉ္စန နိၐိဒ္ဓမ် အၑုစိ ဒြဝျံ ဝါ မမ မုခမဓျံ ကဒါပိ န ပြာဝိၑတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","အပရမ် ဤၑွရော ယတ် ၑုစိ ကၖတဝါန် တန္နိၐိဒ္ဓံ န ဇာနီဟိ ဒွိ ရ္မာမ္ပြတီဒၖၑီ ဝိဟာယသီယာ ဝါဏီ ဇာတာ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","တြိရိတ္ထံ သတိ တတ် သရွွံ ပုနရာကာၑမ် အာကၖၐ္ဋံ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","ပၑ္စာတ် ကဲသရိယာနဂရာတ် တြယော ဇနာ မန္နိကဋံ ပြေၐိတာ ယတြ နိဝေၑနေ သ္ထိတောဟံ တသ္မိန် သမယေ တတြောပါတိၐ္ဌန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","တဒါ နိးသန္ဒေဟံ တဲး သာရ္ဒ္ဓံ ယာတုမ် အာတ္မာ မာမာဒိၐ္ဋဝါန်; တတး ပရံ မယာ သဟဲတေၐု ၐဍ္ဘြာတၖၐု ဂတေၐု ဝယံ တသျ မနုဇသျ ဂၖဟံ ပြာဝိၑာမ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","သောသ္မာကံ နိကဋေ ကထာမေတာမ် အကထယတ် ဧကဒါ ဒူတ ဧကး ပြတျက္ၐီဘူယ မမ ဂၖဟမဓျေ တိၐ္ဋန် မာမိတျာဇ္ဉာပိတဝါန်, ယာဖောနဂရံ ပြတိ လောကာန် ပြဟိတျ ပိတရနာမ္နာ ဝိချာတံ ၑိမောနမ် အာဟူယယ; ");
INSERT INTO sanbur_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","တတသ္တဝ တွဒီယပရိဝါရာဏာဉ္စ ယေန ပရိတြာဏံ ဘဝိၐျတိ တတ် သ ဥပဒေက္ၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","အဟံ တာံ ကထာမုတ္ထာပျ ကထိတဝါန် တေန ပြထမမ် အသ္မာကမ် ဥပရိ ယထာ ပဝိတြ အာတ္မာဝရူဎဝါန် တထာ တေၐာမပျုပရိ သမဝရူဎဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","တေန ယောဟန် ဇလေ မဇ္ဇိတဝါန် ဣတိ သတျံ ကိန္တု ယူယံ ပဝိတြ အာတ္မနိ မဇ္ဇိတာ ဘဝိၐျထ, ဣတိ ယဒွါကျံ ပြဘုရုဒိတဝါန် တတ် တဒါ မယာ သ္မၖတမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","အတး ပြဘာ ယီၑုခြီၐ္ဋေ ပြတျယကာရိဏော ယေ ဝယမ် အသ္မဘျမ် ဤၑွရော ယဒ် ဒတ္တဝါန် တတ် တေဘျော လောကေဘျောပိ ဒတ္တဝါန် တတး ကောဟံ? ကိမဟမ် ဤၑွရံ ဝါရယိတုံ ၑက္နောမိ? ");
INSERT INTO sanbur_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","ကထာမေတာံ ၑြုဝါ တေ က္ၐာန္တာ ဤၑွရသျ ဂုဏာန် အနုကီရ္တ္တျ ကထိတဝန္တး, တရှိ ပရမာယုးပြာပ္တိနိမိတ္တမ် ဤၑွရောနျဒေၑီယလောကေဘျောပိ မနးပရိဝရ္တ္တနရူပံ ဒါနမ် အဒါတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","သ္တိဖာနံ ပြတိ ဥပဒြဝေ ဃဋိတေ ယေ ဝိကီရ္ဏာ အဘဝန် တဲ ဖဲနီကီကုပြာန္တိယခိယာသု ဘြမိတွာ ကေဝလယိဟူဒီယလောကာန် ဝိနာ ကသျာပျနျသျ သမီပ ဤၑွရသျ ကထာံ န ပြာစာရယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","အပရံ တေၐာံ ကုပြီယား ကုရီနီယာၑ္စ ကိယန္တော ဇနာ အာန္တိယခိယာနဂရံ ဂတွာ ယူနာနီယလောကာနာံ သမီပေပိ ပြဘောရျီၑေား ကထာံ ပြာစာရယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ပြဘေား ကရသ္တေၐာံ သဟာယ အာသီတ် တသ္မာဒ် အနေကေ လောကာ ဝိၑွသျ ပြဘုံ ပြတိ ပရာဝရ္တ္တန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ဣတိ ဝါရ္တ္တာယာံ ယိရူၑာလမသ္ထမဏ္ဍလီယလောကာနာံ ကရ္ဏဂေါစရီဘူတာယာမ် အာန္တိယခိယာနဂရံ ဂန္တု တေ ဗရ္ဏဗ္ဗာံ ပြဲရယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","တတော ဗရ္ဏဗ္ဗာသ္တတြ ဥပသ္ထိတး သန် ဤၑွရသျာနုဂြဟသျ ဖလံ ဒၖၐ္ဋွာ သာနန္ဒော ဇာတး, ");
INSERT INTO sanbur_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","သ သွယံ သာဓု ရွိၑွာသေန ပဝိတြေဏာတ္မနာ စ ပရိပူရ္ဏး သန် ဂနောနိၐ္ဋယာ ပြဘာဝါသ္ထာံ ကရ္တ္တုံ သရွွာန် ဥပဒိၐ္ဋဝါန် တေန ပြဘေား ၑိၐျာ အနေကေ ဗဘူဝုး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","ၑေၐေ ၑော်လံ မၖဂယိတုံ ဗရ္ဏဗ္ဗာသ္တာရ္ၐနဂရံ ပြသ္ထိတဝါန်၊ တတြ တသျောဒ္ဒေၑံ ပြာပျ တမ် အာန္တိယခိယာနဂရမ် အာနယတ်; ");
INSERT INTO sanbur_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","တတသ္တော် မဏ္ဍလီသ္ထလောကဲး သဘာံ ကၖတွာ သံဝတ္သရမေကံ ယာဝဒ် ဗဟုလောကာန် ဥပါဒိၑတာံ; တသ္မိန် အာန္တိယခိယာနဂရေ ၑိၐျား ပြထမံ ခြီၐ္ဋီယနာမ္နာ ဝိချာတာ အဘဝန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","တတး ပရံ ဘဝိၐျဒွါဒိဂဏေ ယိရူၑာလမ အာန္တိယခိယာနဂရမ် အာဂတေ သတိ ");
INSERT INTO sanbur_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","အာဂါဗနာမာ တေၐာမေက ဥတ္ထာယ အာတ္မနး ၑိက္ၐယာ သရွွဒေၑေ ဒုရ္ဘိက္ၐံ ဘဝိၐျတီတိ ဇ္ဉာပိတဝါန်; တတး က္လော်ဒိယကဲသရသျာဓိကာရေ သတိ တတ် ပြတျက္ၐမ် အဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","တသ္မာတ် ၑိၐျာ ဧကဲကၑး သွသွၑက္တျနုသာရတော ယိဟူဒီယဒေၑနိဝါသိနာံ ဘြတၖဏာံ ဒိနယာပနာရ္ထံ ဓနံ ပြေၐယိတုံ နိၑ္စိတျ ");
INSERT INTO sanbur_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ဗရ္ဏဗ္ဗာၑော်လယော ရ္ဒွါရာ ပြာစီနလောကာနာံ သမီပံ တတ် ပြေၐိတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","တသ္မိန် သမယေ ဟေရောဒ်ရာဇော မဏ္ဍလျား ကိယဇ္ဇနေဘျော ဒုးခံ ဒါတုံ ပြာရဘတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ဝိၑေၐတော ယောဟနး သောဒရံ ယာကူဗံ ကရဝါလာဃာတေန် ဟတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","တသ္မာဒ် ယိဟူဒီယား သန္တုၐ္ဋာ အဘဝန် ဣတိ ဝိဇ္ဉာယ သ ပိတရမပိ ဓရ္တ္တုံ ဂတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","တဒါ ကိဏွၑူနျပူပေါတ္သဝသမယ ဥပါတိၐ္ဋတ်; အတ ဥတ္သဝေ ဂတေ သတိ လောကာနာံ သမက္ၐံ တံ ဗဟိရာနေယျာမီတိ မနသိ သ္ထိရီကၖတျ သ တံ ဓာရယိတွာ ရက္ၐ္ဏာရ္ထမ် ယေၐာမ် ဧကဲကသံဃေ စတွာရော ဇနား သန္တိ တေၐာံ စတုရ္ဏာံ ရက္ၐကသံဃာနာံ သမီပေ တံ သမရ္ပျ ကာရာယာံ သ္ထာပိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","ကိန္တုံ ပိတရသျ ကာရာသ္ထိတိကာရဏာတ် မဏ္ဍလျာ လောကာ အဝိၑြာမမ် ဤၑွရသျ သမီပေ ပြာရ္ထယန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","အနန္တရံ ဟေရောဒိ တံ ဗဟိရာနာယိတုံ ဥဒျတေ သတိ တသျာံ ရာတြော် ပိတရော ရက္ၐကဒွယမဓျသ္ထာနေ ၑၖင်္ခလဒွယေန ဗဒ္ဓွး သန် နိဒြိတ အာသီတ်, ဒေါ်ဝါရိကာၑ္စ ကာရာယား သမ္မုခေ တိၐ္ဌနတော ဒွါရမ် အရက္ၐိၐုး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ဧတသ္မိန် သမယေ ပရမေၑွရသျ ဒူတေ သမုပသ္ထိတေ ကာရာ ဒီပ္တိမတီ ဇာတာ; တတး သ ဒူတး ပိတရသျ ကုက္ၐာဝါဝါတံ ကၖတွာ တံ ဇာဂရယိတွာ ဘာၐိတဝါန် တူရ္ဏမုတ္တိၐ္ဌ; တတသ္တသျ ဟသ္တသ္ထၑၖင်္ခလဒွယံ ဂလတ် ပတိတံ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","သ ဒူတသ္တမဝဒတ်, ဗဒ္ဓကဋိး သန် ပါဒယေား ပါဒုကေ အရ္ပယ; တေန တထာ ကၖတေ သတိ ဒူတသ္တမ် ဥက္တဝါန် ဂါတြီယဝသ္တြံ ဂါတြေ နိဓာယ မမ ပၑ္စာဒ် ဧဟိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","တတး ပိတရသ္တသျ ပၑ္စာဒ် ဝြဇန ဗဟိရဂစ္ဆတ်, ကိန္တု ဒူတေန ကရ္မ္မဲတတ် ကၖတမိတိ သတျမဇ္ဉာတွာ သွပ္နဒရ္ၑနံ ဇ္ဉာတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ဣတ္ထံ တော် ပြထမာံ ဒွိတီယာဉ္စ ကာရာံ လင်္ဃိတွာ ယေန လော်ဟနိရ္မ္မိတဒွါရေဏ နဂရံ ဂမျတေ တတ္သမီပံ ပြာပ္နုတာံ; တတသ္တသျ ကဝါဋံ သွယံ မုက္တမဘဝတ် တတသ္တော် တတ္သ္ထာနာဒ် ဗဟိ ရ္ဘူတွာ မာရ္ဂဲကသျ သီမာံ ယာဝဒ် ဂတော်; တတော'ကသ္မာတ် သ ဒူတး ပိတရံ တျက္တဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","တဒါ သ စေတနာံ ပြာပျ ကထိတဝါန် နိဇဒူတံ ပြဟိတျ ပရမေၑွရော ဟေရောဒေါ ဟသ္တာဒ် ယိဟူဒီယလောကာနာံ သရွွာၑာယာၑ္စ မာံ သမုဒ္ဓၖတဝါန် ဣတျဟံ နိၑ္စယံ ဇ္ဉာတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","သ ဝိဝိစျ မာရ္ကနာမြာ ဝိချာတသျ ယောဟနော မာတု ရ္မရိယမော ယသ္မိန် ဂၖဟေ ဗဟဝး သမ္ဘူယ ပြာရ္ထယန္တ တန္နိဝေၑနံ ဂတး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","ပိတရေဏ ဗဟိရ္ဒွါရ အာဟတေ သတိ ရောဒါနာမာ ဗာလိကာ ဒြၐ္ဋုံ ဂတာ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","တတး ပိတရသျ သွရံ ၑြုဝါ သာ ဟရ္ၐယုက္တာ သတီ ဒွါရံ န မောစယိတွာ ပိတရော ဒွါရေ တိၐ္ဌတီတိ ဝါရ္တ္တာံ ဝက္တုမ် အဘျန္တရံ ဓာဝိတွာ ဂတဝတီ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","တေ ပြာဝေါစန် တွမုန္မတ္တာ ဇာတာသိ ကိန္တု သာ မုဟုရ္မုဟုရုက္တဝတီ သတျမေဝဲတတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","တဒါ တေ ကထိတဝန္တသ္တရှိ တသျ ဒူတော ဘဝေတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","ပိတရော ဒွါရမာဟတဝါန် ဧတသ္မိန္နန္တရေ ဒွါရံ မောစယိတွာ ပိတရံ ဒၖၐ္ဋွာ ဝိသ္မယံ ပြာပ္တား၊ ");
INSERT INTO sanbur_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","တတး ပိတရော နိးၑဗ္ဒံ သ္ထာတုံ တာန် ပြတိ ဟသ္တေန သင်္ကေတံ ကၖတွာ ပရမေၑွရော ယေန ပြကာရေဏ တံ ကာရာယာ ဥဒ္ဓၖတျာနီတဝါန် တသျ ဝၖတ္တာန္တံ တာနဇ္ဉာပယတ်, ယူယံ ဂတွာ ယာကုဗံ ဘြာတၖဂဏဉ္စ ဝါရ္တ္တာမေတာံ ဝဒတေတျုက္တာ သ္ထာနာန္တရံ ပြသ္ထိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ပြဘာတေ သတိ ပိတရး ကွ ဂတ ဣတျတြ ရက္ၐကာဏာံ မဓျေ မဟာန် ကလဟော ဇာတး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ဟေရောဒ် ဗဟု မၖဂယိတွာ တသျောဒ္ဒေၑေ န ပြာပ္တေ သတိ ရက္ၐကာန် သံပၖစ္ဆျ တေၐာံ ပြာဏာန် ဟန္တုမ် အာဒိၐ္ဋဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ပၑ္စာတ် သ ယိဟူဒီယပြဒေၑာတ် ကဲသရိယာနဂရံ ဂတွာ တတြာဝါတိၐ္ဌတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","သောရသီဒေါနဒေၑယော ရ္လောကေဘျော ဟေရောဒိ ယုယုတ္သော် သတိ တေ သရွွ ဧကမန္တြဏား သန္တသ္တသျ သမီပ ဥပသ္ထာယ လွာသ္တနာမာနံ တသျ ဝသ္တြဂၖဟာဓီၑံ သဟာယံ ကၖတွာ ဟေရောဒါ သာရ္ဒ္ဓံ သန္ဓိံ ပြာရ္ထယန္တ ယတသ္တသျ ရာဇ္ဉော ဒေၑေန တေၐာံ ဒေၑီယာနာံ ဘရဏမ် အဘဝတ္ံ ");
INSERT INTO sanbur_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","အတး ကုတြစိန် နိရုပိတဒိနေ ဟေရောဒ် ရာဇကီယံ ပရိစ္ဆဒံ ပရိဓာယ သိံဟာသနေ သမုပဝိၑျ တာန် ပြတိ ကထာမ် ဥက္တဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","တတော လောကာ ဥစ္စဲးကာရံ ပြတျဝဒန်, ဧၐ မနုဇရဝေါ န ဟိ, ဤၑွရီယရဝး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","တဒါ ဟေရောဒ် ဤၑွရသျ သမ္မာနံ နာကရောတ်; တသ္မာဒ္ဓေတေား ပရမေၑွရသျ ဒူတော ဟဌာတ် တံ ပြာဟရတ် တေနဲဝ သ ကီဋဲး က္ၐီဏး သန် ပြာဏာန် အဇဟာတ်၊ ကိန္တွီၑွရသျ ကထာ ဒေၑံ ဝျာပျ ပြဗလာဘဝတ်၊ တတး ပရံ ဗရ္ဏဗ္ဗာၑော်လော် ယသျ ကရ္မ္မဏော ဘာရံ ပြာပ္နုတာံ တာဘျာံ တသ္မိန် သမ္ပာဒိတေ သတိ မာရ္ကနာမ္နာ ဝိချာတော ယော ယောဟန် တံ သင်္ဂိနံ ကၖတွာ ယိရူၑာလမ္နဂရာတ် ပြတျာဂတော်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","အပရဉ္စ ဗရ္ဏဗ္ဗား, ၑိမောန် ယံ နိဂြံ ဝဒန္တိ, ကုရီနီယလူကိယော ဟေရောဒါ ရာဇ္ဉာ သဟ ကၖတဝိဒျာाဘျာသော မိနဟေမ်, ၑော်လၑ္စဲတေ ယေ ကိယန္တော ဇနာ ဘဝိၐျဒွါဒိန ဥပဒေၐ္ဋာရၑ္စာန္တိယခိယာနဂရသ္ထမဏ္ဍလျာမ် အာသန်, ");
INSERT INTO sanbur_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","တေ ယဒေါပဝါသံ ကၖတွေၑွရမ် အသေဝန္တ တသ္မိန် သမယေ ပဝိတြ အာတ္မာ ကထိတဝါန် အဟံ ယသ္မိန် ကရ္မ္မဏိ ဗရ္ဏဗ္ဗာၑဲလော် နိယုက္တဝါန် တတ္ကရ္မ္မ ကရ္တ္တုံ တော် ပၖထက် ကုရုတ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","တတသ္တဲရုပဝါသပြာရ္ထနယေား ကၖတယေား သတောသ္တေ တယော ရ္ဂာတြယော ရှသ္တာရ္ပဏံ ကၖတွာ တော် ဝျသၖဇန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","တတး ပရံ တော် ပဝိတြေဏာတ္မနာ ပြေရိတော် သန္တော် သိလူကိယာနဂရမ် ဥပသ္ထာယ သမုဒြပထေန ကုပြောပဒွီပမ် အဂစ္ဆတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","တတး သာလာမီနဂရမ် ဥပသ္ထာယ တတြ ယိဟူဒီယာနာံ ဘဇနဘဝနာနိ ဂတွေၑွရသျ ကထာံ ပြာစာရယတာံ; ယောဟနပိ တတ္သဟစရော'ဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ဣတ္ထံ တေ တသျောပဒွီပသျ သရွွတြ ဘြမန္တး ပါဖနဂရမ် ဥပသ္ထိတား; တတြ သုဝိဝေစကေန သရ္ဇိယပေါ်လနာမ္နာ တဒ္ဒေၑာဓိပတိနာ သဟ ဘဝိၐျဒွါဒိနော ဝေၑဓာရီ ဗရျီၑုနာမာ ယော မာယာဝီ ယိဟူဒီ အာသီတ် တံ သာက္ၐာတ် ပြာပ္တဝတး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","တဒ္ဒေၑာဓိပ ဤၑွရသျ ကထာံ ၑြောတုံ ဝါဉ္ဆန် ပေါ်လဗရ္ဏဗ္ဗော် နျမန္တြယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","ကိန္တွိလုမာ ယံ မာယာဝိနံ ဝဒန္တိ သ ဒေၑာဓိပတိံ ဓရ္မ္မမာရ္ဂာဒ် ဗဟိရ္ဘူတံ ကရ္တ္တုမ် အယတတ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","တသ္မာတ် ၑောလော'ရ္ထာတ် ပေါ်လး ပဝိတြေဏာတ္မနာ ပရိပူရ္ဏး သန် တံ မာယာဝိနံ ပြတျနနျဒၖၐ္ဋိံ ကၖတွာကထယတ်, ");
INSERT INTO sanbur_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ဟေ နရကိန် ဓရ္မ္မဒွေၐိန် ကော်ဋိလျဒုၐ္ကရ္မ္မပရိပူရ္ဏ, တွံ ကိံ ပြဘေား သတျပထသျ ဝိပရျျယကရဏာတ် ကဒါပိ န နိဝရ္တ္တိၐျသေ? ");
INSERT INTO sanbur_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","အဓုနာ ပရမေၑွရသ္တဝ သမုစိတံ ကရိၐျတိ တေန ကတိပယဒိနာနိ တွမ် အန္ဓး သန် သူရျျမပိ န ဒြက္ၐျသိ၊ တတ္က္ၐဏာဒ် ရာတြိဝဒ် အန္ဓကာရသ္တသျ ဒၖၐ္ဋိမ် အာစ္ဆာဒိတဝါန်; တသ္မာတ် တသျ ဟသ္တံ ဓရ္တ္တုံ သ လောကမနွိစ္ဆန် ဣတသ္တတော ဘြမဏံ ကၖတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ဧနာံ ဃဋနာံ ဒၖၐ္ဋွာ သ ဒေၑာဓိပတိး ပြဘူပဒေၑာဒ် ဝိသ္မိတျ ဝိၑွာသံ ကၖတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","တဒနန္တရံ ပေါ်လသ္တတ္သင်္ဂိနော် စ ပါဖနဂရာတ် ပြောတံ စာလယိတွာ ပမ္ဖုလိယာဒေၑသျ ပရ္ဂီနဂရမ် အဂစ္ဆန် ကိန္တု ယောဟန် တယေား သမီပါဒ် ဧတျ ယိရူၑာလမံ ပြတျာဂစ္ဆတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","ပၑ္စာတ် တော် ပရ္ဂီတော ယာတြာံ ကၖတွာ ပိသိဒိယာဒေၑသျ အာန္တိယခိယာနဂရမ် ဥပသ္ထာယ ဝိၑြာမဝါရေ ဘဇနဘဝနံ ပြဝိၑျ သမုပါဝိၑတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ဝျဝသ္ထာဘဝိၐျဒွါကျယေား ပဌိတယေား သတော ရှေ ဘြာတရော် လောကာန် ပြတိ ယုဝယေား ကာစိဒ် ဥပဒေၑကထာ ယဒျသ္တိ တရှိ တာံ ဝဒတံ တော် ပြတိ တသျ ဘဇနဘဝနသျာဓိပတယး ကထာမ် ဧတာံ ကထယိတွာ ပြဲၐယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","အတး ပေါ်လ ဥတ္တိၐ္ဌန် ဟသ္တေန သင်္ကေတံ ကုရွွန် ကထိတဝါန် ဟေ ဣသြာယေလီယမနုၐျာ ဤၑွရပရာယဏား သရွွေ လောကာ ယူယမ် အဝဓဒ္ဓံ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ဧတေၐာမိသြာယေလ္လောကာနာမ် ဤၑွရော'သ္မာကံ ပူရွွပရုၐာန် မနောနီတာန် ကတွာ ဂၖဟီတဝါန် တတော မိသရိ ဒေၑေ ပြဝသနကာလေ တေၐာမုန္နတိံ ကၖတွာ တသ္မာတ် သွီယဗာဟုဗလေန တာန် ဗဟိး ကၖတွာ သမာနယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","စတွာရိံၑဒွတ္သရာန် ယာဝစ္စ မဟာပြာန္တရေ တေၐာံ ဘရဏံ ကၖတွာ ");
INSERT INTO sanbur_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ကိနာန္ဒေၑာန္တရွွရ္တ္တီဏိ သပ္တရာဇျာနိ နာၑယိတွာ ဂုဋိကာပါတေန တေၐု သရွွဒေၑေၐု တေဘျော'ဓိကာရံ ဒတ္တဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","ပဉ္စာၑဒဓိကစတုးၑတေၐု ဝတ္သရေၐု ဂတေၐု စ ၑိမူယေလ္ဘဝိၐျဒွါဒိပရျျန္တံ တေၐာမုပရိ ဝိစာရယိတၖန် နိယုက္တဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","တဲၑ္စ ရာဇ္ဉိ ပြာရ္ထိတေ, ဤၑွရော ဗိနျာမီနော ဝံၑဇာတသျ ကီၑး ပုတြံ ၑော်လံ စတွာရိံၑဒွရ္ၐပရျျန္တံ တေၐာမုပရိ ရာဇာနံ ကၖတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","ပၑ္စာတ် တံ ပဒစျုတံ ကၖတွာ ယော မဒိၐ္ဋကြိယား သရွွား ကရိၐျတိ တာဒၖၑံ မမ မနောဘိမတမ် ဧကံ ဇနံ ယိၑယး ပုတြံ ဒါယူဒံ ပြာပ္တဝါန် ဣဒံ ပြမာဏံ ယသ္မိန် ဒါယူဒိ သ ဒတ္တဝါန် တံ ဒါယူဒံ တေၐာမုပရိ ရာဇတွံ ကရ္တ္တုမ် ဥတ္ပာဒိတဝါန၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","တသျ သွပြတိၑြုတသျ ဝါကျသျာနုသာရေဏ ဣသြာယေလ္လောကာနာံ နိမိတ္တံ တေၐာံ မနုၐျာဏာံ ဝံၑာဒ် ဤၑွရ ဧကံ ယီၑုံ (တြာတာရမ်) ဥဒပါဒယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","တသျ ပြကာၑနာတ် ပူရွွံ ယောဟန် ဣသြာယေလ္လောကာနာံ သန္နိဓော် မနးပရာဝရ္တ္တနရူပံ မဇ္ဇနံ ပြာစာရယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ယသျ စ ကရ္မ္မဏောे ဘာရံ ပြပ္တဝါန် ယောဟန် တန် နိၐ္ပာဒယန် ဧတာံ ကထာံ ကထိတဝါန်, ယူယံ မာံ ကံ ဇနံ ဇာနီထ? အဟမ် အဘိၐိက္တတြာတာ နဟိ, ကိန္တု ပၑျတ ယသျ ပါဒယေား ပါဒုကယော ရ္ဗန္ဓနေ မောစယိတုမပိ ယောဂျော န ဘဝါမိ တာဒၖၑ ဧကော ဇနော မမ ပၑ္စာဒ် ဥပတိၐ္ဌတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","ဟေ ဣဗြာဟီမော ဝံၑဇာတာ ဘြာတရော ဟေ ဤၑွရဘီတား သရွွလောကာ ယုၐ္မာန် ပြတိ ပရိတြာဏသျ ကထဲၐာ ပြေရိတာ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","ယိရူၑာလမ္နိဝါသိနသ္တေၐာမ် အဓိပတယၑ္စ တသျ ယီၑေား ပရိစယံ န ပြာပျ ပြတိဝိၑြာမဝါရံ ပဌျမာနာနာံ ဘဝိၐျဒွါဒိကထာနာမ် အဘိပြာယမ် အဗုဒ္ဓွာ စ တသျ ဝဓေန တား ကထား သဖလာ အကုရွွန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","ပြာဏဟနနသျ ကမပိ ဟေတုမ် အပြာပျာပိ ပီလာတသျ နိကဋေ တသျ ဝဓံ ပြာရ္ထယန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","တသ္မိန် ယား ကထာ လိခိတား သန္တိ တဒနုသာရေဏ ကရ္မ္မ သမ္ပာဒျ တံ ကြုၑာဒ် အဝတာရျျ ၑ္မၑာနေ ၑာယိတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","ကိန္တွီၑွရး ၑ္မၑာနာတ် တမုဒသ္ထာပယတ်, ");
INSERT INTO sanbur_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ပုနၑ္စ ဂါလီလပြဒေၑာဒ် ယိရူၑာလမနဂရံ တေန သာရ္ဒ္ဓံ ယေ လောကာ အာဂစ္ဆန် သ ဗဟုဒိနာနိ တေဘျော ဒရ္ၑနံ ဒတ္တဝါန်, အတသ္တ ဣဒါနီံ လောကာန် ပြတိ တသျ သာက္ၐိဏး သန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","အသ္မာကံ ပူရွွပုရုၐာဏာံ သမက္ၐမ် ဤၑွရော ယသ္မိန် ပြတိဇ္ဉာတဝါန် ယထာ, တွံ မေ ပုတြောသိ စာဒျ တွာံ သမုတ္ထာပိတဝါနဟမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ဣဒံ ယဒွစနံ ဒွိတီယဂီတေ လိခိတမာသ္တေ တဒ် ယီၑောရုတ္ထာနေန တေၐာံ သန္တာနာ ယေ ဝယမ် အသ္မာကံ သန္နိဓော် တေန ပြတျက္ၐီ ကၖတံ, ယုၐ္မာန် ဣမံ သုသံဝါဒံ ဇ္ဉာပယာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","ပရမေၑွရေဏ ၑ္မၑာနာဒ် ဥတ္ထာပိတံ တဒီယံ ၑရီရံ ကဒါပိ န က္ၐေၐျတေ, ဧတသ္မိန် သ သွယံ ကထိတဝါန် ယထာ ဒါယူဒံ ပြတိ ပြတိဇ္ဉာတော ယော ဝရသ္တမဟံ တုဘျံ ဒါသျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","ဧတဒနျသ္မိန် ဂီတေ'ပိ ကထိတဝါန်၊ သွကီယံ ပုဏျဝန္တံ တွံ က္ၐယိတုံ န စ ဒါသျသိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","ဒါယူဒါ ဤၑွရာဘိမတသေဝါယဲ နိဇာယုၐိ ဝျယိတေ သတိ သ မဟာနိဒြာံ ပြာပျ နိဇဲး ပူရွွပုရုၐဲး သဟ မိလိတး သန် အက္ၐီယတ; ");
INSERT INTO sanbur_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","ကိန္တု ယမီၑွရး ၑ္မၑာနာဒ် ဥဒသ္ထာပယတ် သ နာက္ၐီယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","အတော ဟေ ဘြာတရး, အနေန ဇနေန ပါပမောစနံ ဘဝတီတိ ယုၐ္မာန် ပြတိ ပြစာရိတမ် အာသ္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ဖလတော မူသာဝျဝသ္ထယာ ယူယံ ယေဘျော ဒေါၐေဘျော မုက္တာ ဘဝိတုံ န ၑက္ၐျထ တေဘျး သရွွဒေါၐေဘျ ဧတသ္မိန် ဇနေ ဝိၑွာသိနး သရွွေ မုက္တာ ဘဝိၐျန္တီတိ ယုၐ္မာဘိ ရ္ဇ္ဉာယတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","အပရဉ္စ၊ အဝဇ္ဉာကာရိဏော လောကာၑ္စက္ၐုရုန္မီလျ ပၑျတ၊ တထဲဝါသမ္ဘဝံ ဇ္ဉာတွာ သျာတ ယူယံ ဝိလဇ္ဇိတား၊ ယတော ယုၐ္မာသု တိၐ္ဌတ္သု ကရိၐျေ ကရ္မ္မ တာဒၖၑံ၊ ယေနဲဝ တသျ ဝၖတ္တာန္တေ ယုၐ္မဘျံ ကထိတေ'ပိ ဟိ၊ ယူယံ န တန္တု ဝၖတ္တာန္တံ ပြတျေၐျထ ကဒါစန။ ");
INSERT INTO sanbur_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","ယေယံ ကထာ ဘဝိၐျဒွါဒိနာံ ဂြန္ထေၐု လိခိတာသ္တေ သာဝဓာနာ ဘဝတ သ ကထာ ယထာ ယုၐ္မာန် ပြတိ န ဃဋတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","ယိဟူဒီယဘဇနဘဝနာန် နိရ္ဂတယောသ္တယော ရ္ဘိန္နဒေၑီယဲ ရွက္ၐျမာဏာ ပြာရ္ထနာ ကၖတာ, အာဂါမိနိ ဝိၑြာမဝါရေ'ပိ ကထေယမ် အသ္မာန် ပြတိ ပြစာရိတာ ဘဝတွိတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","သဘာယာ ဘင်္ဂေ သတိ ဗဟဝေါ ယိဟူဒီယလောကာ ယိဟူဒီယမတဂြာဟိဏော ဘက္တလောကာၑ္စ ဗရ္ဏဗ္ဗာပေါ်လယေား ပၑ္စာဒ် အာဂစ္ဆန်, တေန တော် တဲး သဟ နာနာကထား ကထယိတွေၑွရာနုဂြဟာၑြယေ သ္ထာတုံ တာန် ပြာဝရ္တ္တယတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","ပရဝိၑြာမဝါရေ နဂရသျ ပြာယေဏ သရွွေ လာကာ ဤၑွရီယာံ ကထာံ ၑြောတုံ မိလိတား, ");
INSERT INTO sanbur_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","ကိန္တု ယိဟူဒီယလောကာ ဇနနိဝဟံ ဝိလောကျ ဤရ္ၐျယာ ပရိပူရ္ဏား သန္တော ဝိပရီတကထာကထနေနေၑွရနိန္ဒယာ စ ပေါ်လေနောက္တာံ ကထာံ ခဏ္ဍယိတုံ စေၐ္ဋိတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","တတး ပေါ်ैလဗရ္ဏဗ္ဗာဝက္ၐောဘော် ကထိတဝန္တော် ပြထမံ ယုၐ္မာကံ သန္နိဓာဝီၑွရီယကထာယား ပြစာရဏမ် ဥစိတမာသီတ် ကိန္တုံ တဒဂြာဟျတွကရဏေန ယူယံ သွာန် အနန္တာယုၐော'ယောဂျာန် ဒရ္ၑယထ, ဧတတ္ကာရဏာဒ် ဝယမ် အနျဒေၑီယလောကာနာံ သမီပံ ဂစ္ဆာမး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","ပြဘုရသ္မာန် ဣတ္ထမ် အာဒိၐ္ဋဝါန် ယထာ, ယာဝစ္စ ဇဂတး သီမာံ လောကာနာံ တြာဏကာရဏာတ်၊ မယာနျဒေၑမဓျေ တွံ သ္ထာပိတော ဘူး ပြဒီပဝတ်။ ");
INSERT INTO sanbur_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","တဒါ ကထာမီဒၖၑီံ ၑြုတွာ ဘိန္နဒေၑီယာ အာဟ္လာဒိတား သန္တး ပြဘေား ကထာံ ဓနျာံ ဓနျာမ် အဝဒန်, ယာဝန္တော လောကာၑ္စ ပရမာယုး ပြာပ္တိနိမိတ္တံ နိရူပိတာ အာသန် တေे ဝျၑွသန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ဣတ္ထံ ပြဘေား ကထာ သရွွေဒေၑံ ဝျာပ္နောတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","ကိန္တု ယိဟူဒီယာ နဂရသျ ပြဓာနပုရုၐာန် သမ္မာနျား ကထိပယာ ဘက္တာ ယောၐိတၑ္စ ကုပြဝၖတ္တိံ ဂြာဟယိတွာ ပေါ်လဗရ္ဏဗ္ဗော် တာဍယိတွာ တသ္မာတ် ပြဒေၑာဒ် ဒူရီကၖတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","အတး ကာရဏာတ် တော် နိဇပဒဓူလီသ္တေၐာံ ပြာတိကူလျေန ပါတယိတွေेကနိယံ နဂရံ ဂတော်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","တတး ၑိၐျဂဏ အာနန္ဒေန ပဝိတြေဏာတ္မနာ စ ပရိပူရ္ဏောဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","တော် ဒွေါ် ဇနော် ယုဂပဒ် ဣကနိယနဂရသ္ထယိဟူဒီယာနာံ ဘဇနဘဝနံ ဂတွာ ယထာ ဗဟဝေါ ယိဟူဒီယာ အနျဒေेၑီယလောကာၑ္စ ဝျၑွသန် တာဒၖၑီံ ကထာံ ကထိတဝန္တော်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","ကိန္တု ဝိၑွာသဟီနာ ယိဟူဒီယာ အနျဒေၑီယလောကာန် ကုပြဝၖတ္တိံ ဂြာဟယိတွာ ဘြာတၖဂဏံ ပြတိ တေၐာံ ဝဲရံ ဇနိတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","အတး သွာနုဂြဟကထာယား ပြမာဏံ ဒတွာ တယော ရှသ္တဲ ရ္ဗဟုလက္ၐဏမ် အဒ္ဘုတကရ္မ္မ စ ပြာကာၑယဒ် ယး ပြဘုသ္တသျ ကထာ အက္ၐောဘေန ပြစာရျျ တော် တတြ ဗဟုဒိနာနိ သမဝါတိၐ္ဌေတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","ကိန္တု ကိယန္တော လောကာ ယိဟူဒီယာနာံ သပက္ၐား ကိယန္တော လောကား ပြေရိတာနာံ သပက္ၐာ ဇာတား, အတော နာဂရိကဇနနိဝဟမဓျေ ဘိန္နဝါကျတွမ် အဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","အနျဒေၑီယာ ယိဟူဒီယာသ္တေၐာမ် အဓိပတယၑ္စ ဒေါ်ရာတ္မျံ ကုတွာ တော် ပြသ္တရဲရာဟန္တုမ် ဥဒျတား၊ ");
INSERT INTO sanbur_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","တော် တဒွါရ္တ္တာံ ပြာပျ ပလာယိတွာ လုကာယနိယာဒေၑသျာန္တရွွရ္တ္တိလုသ္တြာဒရ္ဗ္ဗော ");
INSERT INTO sanbur_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","တတ္သမီပသ္ထဒေၑဉ္စ ဂတွာ တတြ သုသံဝါဒံ ပြစာရယတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","တတြောဘယပါဒယောၑ္စလနၑက္တိဟီနော ဇန္မာရဘျ ခဉ္ဇး ကဒါပိ ဂမနံ နာကရောတ် ဧတာဒၖၑ ဧကော မာနုၐော လုသ္တြာနဂရ ဥပဝိၑျ ပေါ်လသျ ကထာံ ၑြုတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ဧတသ္မိန် သမယေ ပေါ်လသ္တမ္ပြတိ ဒၖၐ္ဋိံ ကၖတွာ တသျ သွာသ္ထျေ ဝိၑွာသံ ဝိဒိတွာ ပြောစ္စဲး ကထိတဝါန္ ");
INSERT INTO sanbur_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ပဒ္ဘျာမုတ္တိၐ္ဌန် ၒဇု ရ္ဘဝ၊ တတး သ ဥလ္လမ္ဖံ ကၖတွာ ဂမနာဂမနေ ကုတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","တဒါ လောကား ပေါ်လသျ တတ် ကာရျျံ ဝိလောကျ လုကာယနီယဘာၐယာ ပြောစ္စဲး ကထာမေတာံ ကထိတဝန္တး, ဒေဝါ မနုၐျရူပံ ဓၖတွာသ္မာကံ သမီပမ် အဝါရောဟန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","တေ ဗရ္ဏဗ္ဗာံ ယူပိတရမ် အဝဒန် ပေါ်လၑ္စ မုချော ဝက္တာ တသ္မာတ် တံ မရ္ကုရိယမ် အဝဒန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","တသျ နဂရသျ သမ္မုခေ သ္ထာပိတသျ ယူပိတရဝိဂြဟသျ ယာဇကော ဝၖၐာန် ပုၐ္ပမာလာၑ္စ ဒွါရသမီပမ် အာနီယ လောကဲး သရ္ဒ္ဓံ တာဝုဒ္ဒိၑျ သမုတ္သၖဇျ ဒါတုမ် ဥဒျတး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","တဒွါရ္တ္တာံ ၑြုတွာ ဗရ္ဏဗ္ဗာပေါ်လော် သွီယဝသ္တြာဏိ ဆိတွာ လောကာနာံ မဓျံ ဝေဂေန ပြဝိၑျ ပြောစ္စဲး ကထိတဝန္တော်, ");
INSERT INTO sanbur_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","ဟေ မဟေစ္ဆား ကုတ ဧတာဒၖၑံ ကရ္မ္မ ကုရုထ? အာဝါမပိ ယုၐ္မာဒၖၑော် သုခဒုးခဘောဂိနော် မနုၐျော်, ယုယမ် ဧတား သရွွာ ဝၖထာကလ္ပနား ပရိတျဇျ ယထာ ဂဂဏဝသုန္ဓရာဇလနိဓီနာံ တန္မဓျသ္ထာနာံ သရွွေၐာဉ္စ သြၐ္ဋာရမမရမ် ဤၑွရံ ပြတိ ပရာဝရ္တ္တဓွေ တဒရ္ထမ် အာဝါံ ယုၐ္မာကံ သန္နိဓော် သုသံဝါဒံ ပြစာရယာဝး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","သ ဤၑွရး ပူရွွကာလေ သရွွဒေၑီယလောကာန် သွသွမာရ္ဂေ စလိတုမနုမတိံ ဒတ္တဝါန်, ");
INSERT INTO sanbur_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","တထာပိ အာကာၑာတ် တောယဝရ္ၐဏေန နာနာပြကာရၑသျောတ္ပတျာ စ ယုၐ္မာကံ ဟိတဲၐီ သန် ဘက္ၐျဲရာနနဒေန စ ယုၐ္မာကမ် အန္တးကရဏာနိ တရ္ပယန် တာနိ ဒါနာနိ နိဇသာက္ၐိသွရူပါဏိ သ္ထပိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","ကိန္တု တာဒၖၑာယာံ ကထာယာံ ကထိတာယာမပိ တယေား သမီပ ဥတ္သရ္ဇနာတ် လောကနိဝဟံ ပြာယေဏ နိဝရ္တ္တယိတုံ နာၑက္နုတာမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","အာန္တိယခိယာ-ဣကနိယနဂရာဘျာံ ကတိပယယိဟူဒီယလောကာ အာဂတျ လောကာန် ပြာဝရ္တ္တယန္တ တသ္မာတ် တဲ ပေါ်လံ ပြသ္တရဲရာဃ္နန် တေန သ မၖတ ဣတိ ဝိဇ္ဉာယ နဂရသျ ဗဟိသ္တမ် အာကၖၐျ နီတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","ကိန္တု ၑိၐျဂဏေ တသျ စတုရ္ဒိၑိ တိၐ္ဌတိ သတိ သ သွယမ် ဥတ္ထာယ ပုနရပိ နဂရမဓျံ ပြာဝိၑတ် တတ္ပရေ'ဟနိ ဗရ္ဏဗ္ဗာသဟိတော ဒရ္ဗ္ဗီနဂရံ ဂတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","တတြ သုသံဝါဒံ ပြစာရျျ ဗဟုလောကာန် ၑိၐျာန် ကၖတွာ တော် လုသ္တြာမ် ဣကနိယမ် အာန္တိယခိယာဉ္စ ပရာဝၖတျ ဂတော်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ဗဟုဒုးခါနိ ဘုက္တွာပီၑွရရာဇျံ ပြဝေၐ္ဋဝျမ် ဣတိ ကာရဏာဒ် ဓရ္မ္မမာရ္ဂေ သ္ထာတုံ ဝိနယံ ကၖတွာ ၑိၐျဂဏသျ မနးသ္ထဲရျျမ် အကုရုတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","မဏ္ဍလီနာံ ပြာစီနဝရ္ဂာန် နိယုဇျ ပြာရ္ထနောပဝါသော် ကၖတွာ ယတ္ပြဘော် တေ ဝျၑွသန် တသျ ဟသ္တေ တာန် သမရ္ပျ ");
INSERT INTO sanbur_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","ပိသိဒိယာမဓျေန ပါမ္ဖုလိယာဒေၑံ ဂတဝန္တော်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ပၑ္စာတ် ပရ္ဂာနဂရံ ဂတွာ သုသံဝါဒံ ပြစာရျျ အတ္တာလိယာနဂရံ ပြသ္ထိတဝန္တော်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","တသ္မာတ် သမုဒြပထေန ဂတွာ တာဘျာံ ယတ် ကရ္မ္မ သမ္ပန္နံ တတ္ကရ္မ္မ သာဓယိတုံ ယန္နဂရေ ဒယာလောရီၑွရသျ ဟသ္တေ သမရ္ပိတော် ဇာတော် တဒ် အာန္တိယခိယာနဂရံ ဂတဝန္တာ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","တတြောပသ္ထာယ တန္နဂရသ္ထမဏ္ဍလီံ သံဂၖဟျ သွာဘျာမ ဤၑွရော ယဒျတ် ကရ္မ္မကရောတ် တထာ ယေန ပြကာရေဏ ဘိန္နဒေၑီယလောကာန် ပြတိ ဝိၑွာသရူပဒွါရမ် အမောစယဒ် ဧတာန် သရွွဝၖတ္တာန္တာန် တာန် ဇ္ဉာပိတဝန္တော်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","တတသ္တော် ၑိရျျဲး သာရ္ဒ္ဓံ တတြ ဗဟုဒိနာနိ နျဝသတာမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","ယိဟူဒါဒေၑာတ် ကိယန္တော ဇနာ အာဂတျ ဘြာတၖဂဏမိတ္ထံ ၑိက္ၐိတဝန္တော မူသာဝျဝသ္ထယာ ယဒိ ယုၐ္မာကံ တွက္ဆေဒေါ န ဘဝတိ တရှိ ယူယံ ပရိတြာဏံ ပြာပ္တုံ န ၑက္ၐျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","ပေါ်လဗရ္ဏဗ္ဗော် တဲး သဟ ဗဟူန် ဝိစာရာန် ဝိဝါဒါံၑ္စ ကၖတဝန္တော်, တတော မဏ္ဍလီယနောကာ ဧတသျား ကထာယာသ္တတ္တွံ ဇ္ဉာတုံ ယိရူၑာလမ္နဂရသ္ထာန် ပြေရိတာန် ပြာစီနာံၑ္စ ပြတိ ပေါ်လဗရ္ဏဗ္ဗာပြဘၖတီန် ကတိပယဇနာန် ပြေၐယိတုံ နိၑ္စယံ ကၖတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","တေ မဏ္ဍလျာ ပြေရိတား သန္တး ဖဲဏီကီၑောမိရောန္ဒေၑာဘျာံ ဂတွာ ဘိန္နဒေၑီယာနာံ မနးပရိဝရ္တ္တနသျ ဝါရ္တ္တယာ ဘြာတၖဏာံ ပရမာဟ္လာဒမ် အဇနယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","ယိရူၑာလမျုပသ္ထာယ ပြေရိတဂဏေန လောကပြာစီနဂဏေန သမာဇေန စ သမုပဂၖဟီတား သန္တး သွဲရီၑွရော ယာနိ ကရ္မ္မာဏိ ကၖတဝါန် တေၐာံ သရွွဝၖတ္တာန္တာန် တေၐာံ သမက္ၐမ် အကထယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","ကိန္တု ဝိၑွာသိနး ကိယန္တး ဖိရူၑိမတဂြာဟိဏော လောကာ ဥတ္ထာယ ကထာမေတာံ ကထိတဝန္တော ဘိန္နဒေၑီယာနာံ တွက္ဆေဒံ ကရ္တ္တုံ မူသာဝျဝသ္ထာံ ပါလယိတုဉ္စ သမာဒေၐ္ဋဝျမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","တတး ပြေရိတာ လောကပြာစီနာၑ္စ တသျ ဝိဝေစနာံ ကရ္တ္တုံ သဘာယာံ သ္ထိတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","ဗဟုဝိစာရေၐု ဇာတၐု ပိတရ ဥတ္ထာယ ကထိတဝါန်, ဟေ ဘြာတရော ယထာ ဘိန္နဒေၑီယလောကာ မမ မုခါတ် သုသံဝါဒံ ၑြုတွာ ဝိၑွသန္တိ တဒရ္ထံ ဗဟုဒိနာတ် ပူရွွမ် ဤၑွရောသ္မာကံ မဓျေ မာံ ဝၖတွာ နိယုက္တဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","အန္တရျျာမီၑွရော ယထာသ္မဘျံ တထာ ဘိန္နဒေၑီယေဘျး ပဝိတြမာတ္မာနံ ပြဒါယ ဝိၑွာသေန တေၐာမ် အန္တးကရဏာနိ ပဝိတြာဏိ ကၖတွာ ");
INSERT INTO sanbur_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","တေၐာမ် အသ္မာကဉ္စ မဓျေ ကိမပိ ဝိၑေၐံ န သ္ထာပယိတွာ တာနဓိ သွယံ ပြမာဏံ ဒတ္တဝါန် ဣတိ ယူယံ ဇာနီထ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","အတဧဝါသ္မာကံ ပူရွွပုရုၐာ ဝယဉ္စ သွယံ ယဒျုဂသျ ဘာရံ သောဎုံ န ၑက္တား သမ္ပြတိ တံ ၑိၐျဂဏသျ သ္ကန္ဓေၐု နျသိတုံ ကုတ ဤၑွရသျ ပရီက္ၐာံ ကရိၐျထ? ");
INSERT INTO sanbur_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","ပြဘော ရျီၑုခြီၐ္ဋသျာနုဂြဟေဏ တေ ယထာ ဝယမပိ တထာ ပရိတြာဏံ ပြာပ္တုမ် အာၑာံ ကုရ္မ္မး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","အနန္တရံ ဗရ္ဏဗ္ဗာပေါ်လာဘျာမ် ဤၑွရော ဘိန္နဒေၑီယာနာံ မဓျေ ယဒျဒ် အာၑ္စရျျမ် အဒ္ဘုတဉ္စ ကရ္မ္မ ကၖတဝါန် တဒွၖတ္တာန္တံ တော် သွမုခါဘျာမ် အဝရ္ဏယတာံ သဘာသ္ထား သရွွေ နီရဝါး သန္တး ၑြုတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","တယေား ကထာယာံ သမာပ္တာယာံ သတျာံ ယာကူဗ် ကထယိတုမ် အာရဗ္ဓဝါန္ ");
INSERT INTO sanbur_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ဟေ ဘြာတရော မမ ကထာယာမ် မနော နိဓတ္တ၊ ဤၑွရး သွနာမာရ္ထံ ဘိန္နဒေၑီယလောကာနာမ် မဓျာဒ် ဧကံ လောကသံဃံ ဂြဟီတုံ မတိံ ကၖတွာ ယေန ပြကာရေဏ ပြထမံ တာန် ပြတိ ကၖပါဝလေကနံ ကၖတဝါန် တံ ၑိမောန် ဝရ္ဏိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ဘဝိၐျဒွါဒိဘိရုက္တာနိ ယာနိ ဝါကျာနိ တဲး သာရ္ဒ္ဓမ် ဧတသျဲကျံ ဘဝတိ ယထာ လိခိတမာသ္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","သရွွေၐာံ ကရ္မ္မဏာံ ယသ္တု သာဓကး ပရမေၑွရး၊ သ ဧဝေဒံ ဝဒေဒွါကျံ ၑေၐား သကလမာနဝါး၊ ဘိန္နဒေၑီယလောကာၑ္စ ယာဝန္တော မမ နာမတး၊ ဘဝန္တိ ဟိ သုဝိချာတာသ္တေ ယထာ ပရမေၑိတုး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","တတွံ သမျက် သမီဟန္တေ တန္နိမိတ္တမဟံ ကိလ၊ ပရာဝၖတျ သမာဂတျ ဒါယူဒး ပတိတံ ပုနး၊ ဒူၐျမုတ္ထာပယိၐျာမိ တဒီယံ သရွွဝသ္တု စ၊ ပတိတံ ပုနရုထာပျ သဇ္ဇယိၐျာမိ သရွွထာ။ ");
INSERT INTO sanbur_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","အာ ပြထမာဒ် ဤၑွရး သွီယာနိ သရွွကရ္မ္မာဏိ ဇာနာတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","အတဧဝ မမ နိဝေဒနမိဒံ ဘိန္နဒေၑီယလောကာနာံ မဓျေ ယေ ဇနာ ဤၑွရံ ပြတိ ပရာဝရ္တ္တန္တ တေၐာမုပရိ အနျံ ကမပိ ဘာရံ န နျသျ ");
INSERT INTO sanbur_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ဒေဝတာပြသာဒါၑုစိဘက္ၐျံ ဝျဘိစာရကရ္မ္မ ကဏ္ဌသမ္ပီဍနမာရိတပြာဏိဘက္ၐျံ ရက္တဘက္ၐျဉ္စ ဧတာနိ ပရိတျက္တုံ လိခါမး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","ယတး ပူရွွကာလတော မူသာဝျဝသ္ထာပြစာရိဏော လောကာ နဂရေ နဂရေ သန္တိ ပြတိဝိၑြာမဝါရဉ္စ ဘဇနဘဝနေ တသျား ပါဌော ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","တတး ပရံ ပြေရိတဂဏော လောကပြာစီနဂဏး သရွွာ မဏ္ဍလီ စ သွေၐာံ မဓျေ ဗရ္ၑဗ္ဗာ နာမ္နာ ဝိချာတော မနောနီတော် ကၖတွာ ပေါ်လဗရ္ဏဗ္ဗာဘျာံ သာရ္ဒ္ဓမ် အာန္တိယခိယာနဂရံ ပြတိ ပြေၐဏမ် ဥစိတံ ဗုဒ္ဓွာ တာဘျာံ ပတြံ ပြဲၐယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","တသ္မိန် ပတြေ လိခိတမိံဒ, အာန္တိယခိယာ-သုရိယာ-ကိလိကိယာဒေၑသ္ထဘိန္နဒေၑီယဘြာတၖဂဏာယ ပြေရိတဂဏသျ လောကပြာစီနဂဏသျ ဘြာတၖဂဏသျ စ နမသ္ကာရး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","ဝိၑေၐတော'သ္မာကမ် အာဇ္ဉာမ် အပြာပျာပိ ကိယန္တော ဇနာ အသ္မာကံ မဓျာဒ် ဂတွာ တွက္ဆေဒေါ မူသာဝျဝသ္ထာ စ ပါလယိတဝျာဝိတိ ယုၐ္မာန် ၑိက္ၐယိတွာ ယုၐ္မာကံ မနသာမသ္ထဲရျျံ ကၖတွာ ယုၐ္မာန် သသန္ဒေဟာန် အကုရွွန် ဧတာံ ကထာံ ဝယမ် အၑၖန္မ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","တတ္ကာရဏာဒ် ဝယမ် ဧကမန္တြဏား သန္တး သဘာယာံ သ္ထိတွာ ပြဘော ရျီၑုခြီၐ္ဋသျ နာမနိမိတ္တံ မၖတျုမုခဂတာဘျာမသ္မာကံ ");
INSERT INTO sanbur_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ပြိယဗရ္ဏဗ္ဗာပေါ်လာဘျာံ သာရ္ဒ္ဓံ မနောနီတလောကာနာံ ကေၐာဉ္စိဒ် ယုၐ္မာကံ သန္နိဓော် ပြေၐဏမ် ဥစိတံ ဗုဒ္ဓဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","အတော ယိဟူဒါသီလော် ယုၐ္မာန် ပြတိ ပြေၐိတဝန္တး, ဧတယော ရ္မုခါဘျာံ သရွွာံ ကထာံ ဇ္ဉာသျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","ဒေဝတာပြသာဒဘက္ၐျံ ရက္တဘက္ၐျံ ဂလပီဍနမာရိတပြာဏိဘက္ၐျံ ဝျဘိစာရကရ္မ္မ စေမာနိ သရွွာဏိ ယုၐ္မာဘိသ္တျာဇျာနိ; ဧတတ္ပြယောဇနီယာဇ္ဉာဝျတိရေကေန ယုၐ္မာကမ် ဥပရိ ဘာရမနျံ န နျသိတုံ ပဝိတြသျာတ္မနော'သ္မာကဉ္စ ဥစိတဇ္ဉာနမ် အဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","အတဧဝ တေဘျး သရွွေဘျး သွေၐု ရက္ၐိတေၐု ယူယံ ဘဒြံ ကရ္မ္မ ကရိၐျထ၊ ယုၐ္မာကံ မင်္ဂလံ ဘူယာတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","တေे ဝိသၖၐ္ဋား သန္တ အာန္တိယခိယာနဂရ ဥပသ္ထာယ လောကနိဝဟံ သံဂၖဟျ ပတြမ် အဒဒန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","တတသ္တေ တတ္ပတြံ ပဌိတွာ သာန္တွနာံ ပြာပျ သာနန္ဒာ အဘဝန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","ယိဟူဒါသီလော် စ သွယံ ပြစာရကော် ဘူတွာ ဘြာတၖဂဏံ နာနောပဒိၑျ တာန် သုသ္ထိရာန် အကုရုတာမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ဣတ္ထံ တော် တတြ တဲး သာကံ ကတိပယဒိနာနိ ယာပယိတွာ ပၑ္စာတ် ပြေရိတာနာံ သမီပေ ပြတျာဂမနာရ္ထံ တေၐာံ သန္နိဓေး ကလျာဏေန ဝိသၖၐ္ဋာဝဘဝတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","ကိန္တု သီလသ္တတြ သ္ထာတုံ ဝါဉ္ဆိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","အပရံ ပေါ်လဗရ္ဏဗ္ဗော် ဗဟဝး ၑိၐျာၑ္စ လောကာန် ဥပဒိၑျ ပြဘေား သုသံဝါဒံ ပြစာရယန္တ အာန္တိယခိယာယာံ ကာလံ ယာပိတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","ကတိပယဒိနေၐု ဂတေၐု ပေါ်လော ဗရ္ဏဗ္ဗာမ် အဝဒတ် အာဂစ္ဆာဝါံ ယေၐု နဂရေၐွီၑွရသျ သုသံဝါဒံ ပြစာရိတဝန္တော် တာနိ သရွွနဂရာဏိ ပုနရ္ဂတွာ ဘြာတရး ကီဒၖၑား သန္တီတိ ဒြၐ္ဋုံ တာန် သာက္ၐာတ် ကုရွွး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","တေန မာရ္ကနာမ္နာ ဝိချာတံ ယောဟနံ သင်္ဂိနံ ကရ္တ္တုံ ဗရ္ဏဗ္ဗာ မတိမကရောတ်, ");
INSERT INTO sanbur_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ကိန္တု သ ပူရွွံ တာဘျာံ သဟ ကာရျျာရ္ထံ န ဂတွာ ပါမ္ဖူလိယာဒေၑေ တော် တျက္တဝါန် တတ္ကာရဏာတ် ပေါ်လသ္တံ သင်္ဂိနံ ကရ္တ္တုမ် အနုစိတံ ဇ္ဉာတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ဣတ္ထံ တယောရတိၑယဝိရောဓသျောပသ္ထိတတွာတ် တော် ပရသ္ပရံ ပၖထဂဘဝတာံ တတော ဗရ္ဏဗ္ဗာ မာရ္ကံ ဂၖဟီတွာ ပေါတေန ကုပြောပဒွီပံ ဂတဝါန်; ");
INSERT INTO sanbur_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","ကိန္တု ပေါ်လး သီလံ မနောနီတံ ကၖတွာ ဘြာတၖဘိရီၑွရာနုဂြဟေ သမရ္ပိတး သန် ပြသ္ထာယ ");
INSERT INTO sanbur_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","သုရိယာကိလိကိယာဒေၑာဘျာံ မဏ္ဍလီး သ္ထိရီကုရွွန် အဂစ္ဆတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","ပေါ်လော ဒရ္ဗ္ဗီလုသ္တြာနဂရယောရုပသ္ထိတောဘဝတ် တတြ တီမထိယနာမာ ၑိၐျ ဧက အာသီတ်; သ ဝိၑွာသိနျာ ယိဟူဒီယာယာ ယောၐိတော ဂရ္ဗ္ဘဇာတး ကိန္တု တသျ ပိတာနျဒေၑီယလောကး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","သ ဇနော လုသ္တြာ-ဣကနိယနဂရသ္ထာနာံ ဘြာတၖဏာံ သမီပေပိ သုချာတိမာန် အာသီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","ပေါ်လသ္တံ သွသင်္ဂိနံ ကရ္တ္တုံ မတိံ ကၖတွာ တံ ဂၖဟီတွာ တဒ္ဒေၑနိဝါသိနာံ ယိဟူဒီယာနာမ် အနုရောဓာတ် တသျ တွက္ဆေဒံ ကၖတဝါန် ယတသ္တသျ ပိတာ ဘိန္နဒေၑီယလောက ဣတိ သရွွဲရဇ္ဉာယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","တတး ပရံ တေ နဂရေ နဂရေ ဘြမိတွာ ယိရူၑာလမသ္ထဲး ပြေရိတဲ ရ္လောကပြာစီနဲၑ္စ နိရူပိတံ ယဒ် ဝျဝသ္ထာပတြံ တဒနုသာရေဏာစရိတုံ လောကေဘျသ္တဒ် ဒတ္တဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","တေနဲဝ သရွွေ ဓရ္မ္မသမာဇား ခြီၐ္ဋဓရ္မ္မေ သုသ္ထိရား သန္တး ပြတိဒိနံ ဝရ္ဒ္ဓိတာ အဘဝန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","တေၐု ဖြုဂိယာဂါလာတိယာဒေၑမဓျေန ဂတေၐု သတ္သု ပဝိတြ အာတ္မာ တာန် အာၑိယာဒေၑေ ကထာံ ပြကာၑယိတုံ ပြတိၐိဒ္ဓဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","တထာ မုသိယာဒေၑ ဥပသ္ထာယ ဗိထုနိယာံ ဂန္တုံ တဲရုဒျောဂေ ကၖတေ အာတ္မာ တာန် နာနွမနျတ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","တသ္မာတ် တေ မုသိယာဒေၑံ ပရိတျဇျ တြောယာနဂရံ ဂတွာ သမုပသ္ထိတား၊ ");
INSERT INTO sanbur_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ရာတြော် ပေါ်လး သွပ္နေ ဒၖၐ္ဋဝါန် ဧကော မာကိဒနိယလောကသ္တိၐ္ဌန် ဝိနယံ ကၖတွာ တသ္မဲ ကထယတိ, မာကိဒနိယာဒေၑမ် အာဂတျာသ္မာန် ဥပကုရွွိတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","တသျေတ္ထံ သွပ္နဒရ္ၑနာတ် ပြဘုသ္တဒ္ဒေၑီယလောကာန် ပြတိ သုသံဝါဒံ ပြစာရယိတုမ် အသ္မာန် အာဟူယတီတိ နိၑ္စိတံ ဗုဒ္ဓွာ ဝယံ တူရ္ဏံ မာကိဒနိယာဒေၑံ ဂန္တုမ် ဥဒျောဂမ် အကုရ္မ္မ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","တတး ပရံ ဝယံ တြောယာနဂရာဒ် ပြသ္ထာယ ၒဇုမာရ္ဂေဏ သာမထြာကိယောပဒွီပေန ဂတွာ ပရေ'ဟနိ နိယာပလိနဂရ ဥပသ္ထိတား၊ ");
INSERT INTO sanbur_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","တသ္မာဒ် ဂတွာ မာကိဒနိယာန္တရွွရ္တ္တိ ရောမီယဝသတိသ္ထာနံ ယတ် ဖိလိပီနာမပြဓာနနဂရံ တတြောပသ္ထာယ ကတိပယဒိနာနိ တတြ သ္ထိတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","ဝိၑြာမဝါရေ နဂရာဒ် ဗဟိ ရ္ဂတွာ နဒီတဋေ ယတြ ပြာရ္ထနာစာရ အာသီတ် တတြောပဝိၑျ သမာဂတာ နာရီး ပြတိ ကထာံ ပြာစာရယာမ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","တတး ထုယာတီရာနဂရီယာ ဓူၐရာမ္ဗရဝိကြာယိဏီ လုဒိယာနာမိကာ ယာ ဤၑွရသေဝိကာ ယောၐိတ် ၑြောတြီဏာံ မဓျ အာသီတ် တယာ ပေါ်လောက္တဝါကျာနိ ယဒ် ဂၖဟျန္တေ တဒရ္ထံ ပြဘုသ္တသျာ မနောဒွါရံ မုက္တဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","အတး သာ ယောၐိတ် သပရိဝါရာ မဇ္ဇိတာ သတီ ဝိနယံ ကၖတွာ ကထိတဝတီ, ယုၐ္မာကံ ဝိစာရာဒ် ယဒိ ပြဘော် ဝိၑွာသိနီ ဇာတာဟံ တရှိ မမ ဂၖဟမ် အာဂတျ တိၐ္ဌတ၊ ဣတ္ထံ သာ ယတ္နေနာသ္မာန် အသ္ထာပယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","ယသျာ ဂဏနယာ တဒဓိပတီနာံ ဗဟုဓနောပါရ္ဇနံ ဇာတံ တာဒၖၑီ ဂဏကဘူတဂြသ္တာ ကာစန ဒါသီ ပြာရ္ထနာသ္ထာနဂမနကာလ အာဂတျာသ္မာန် သာက္ၐာတ် ကၖတဝတီ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","သာသ္မာကံ ပေါ်လသျ စ ပၑ္စာဒ် ဧတျ ပြောစ္စဲး ကထာမိမာံ ကထိတဝတီ, မနုၐျာ ဧတေ သရွွောပရိသ္ထသျေၑွရသျ သေဝကား သန္တော'သ္မာန် ပြတိ ပရိတြာဏသျ မာရ္ဂံ ပြကာၑယန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","သာ ကနျာ ဗဟုဒိနာနိ တာဒၖၑမ် အကရောတ် တသ္မာတ် ပေါ်လော ဒုးခိတး သန် မုခံ ပရာဝရ္တျ တံ ဘူတမဝဒဒ်, အဟံ ယီၑုခြီၐ္ဋသျ နာမ္နာ တွာမာဇ္ဉာပယာမိ တွမသျာ ဗဟိရ္ဂစ္ဆ; တေနဲဝ တတ္က္ၐဏာတ် သ ဘူတသ္တသျာ ဗဟိရ္ဂတး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","တတး သွေၐာံ လာဘသျ ပြတျာၑာ ဝိဖလာ ဇာတေတိ ဝိလောကျ တသျား ပြဘဝး ပေါ်လံ သီလဉ္စ ဓၖတွာကၖၐျ ဝိစာရသ္ထာနေ'ဓိပတီနာံ သမီပမ် အာနယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","တတး ၑာသကာနာံ နိကဋံ နီတွာ ရောမိလောကာ ဝယမ် အသ္မာကံ ယဒ် ဝျဝဟရဏံ ဂြဟီတုမ် အာစရိတုဉ္စ နိၐိဒ္ဓံ, ");
INSERT INTO sanbur_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ဣမေ ယိဟူဒီယလောကား သန္တောပိ တဒေဝ ၑိက္ၐယိတွာ နဂရေ'သ္မာကမ် အတီဝ ကလဟံ ကုရွွန္တိ, ");
INSERT INTO sanbur_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","ဣတိ ကထိတေ သတိ လောကနိဝဟသ္တယေား ပြာတိကူလျေနောဒတိၐ္ဌတ် တထာ ၑာသကာသ္တယော ရွသ္တြာဏိ ဆိတွာ ဝေတြာဃာတံ ကရ္တ္တုမ် အာဇ္ဉာပယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","အပရံ တေ တော် ဗဟု ပြဟာရျျ တွမေတော် ကာရာံ နီတွာ သာဝဓာနံ ရက္ၐယေတိ ကာရာရက္ၐကမ် အာဒိၑန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ဣတ္ထမ် အာဇ္ဉာံ ပြာပျ သ တာဝဘျန္တရသ္ထကာရာံ နီတွာ ပါဒေၐု ပါဒပါၑီဘိ ရ္ဗဒ္ဓွာ သ္ထာပိတာဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","အထ နိၑီထသမယေ ပေါ်လသီလာဝီၑွရမုဒ္ဒိၑျ ပြာထနာံ ဂါနဉ္စ ကၖတဝန္တော်, ကာရာသ္ထိတာ လောကာၑ္စ တဒၑၖဏွန္ ");
INSERT INTO sanbur_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","တဒါကသ္မာတ် မဟာန် ဘူမိကမ္ပော'ဘဝတ် တေန ဘိတ္တိမူလေန သဟ ကာရာ ကမ္ပိတာဘူတ် တတ္က္ၐဏာတ် သရွွာဏိ ဒွါရာဏိ မုက္တာနိ ဇာတာနိ သရွွေၐာံ ဗန္ဓနာနိ စ မုက္တာနိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","အတဧဝ ကာရာရက္ၐကော နိဒြာတော ဇာဂရိတွာ ကာရာယာ ဒွါရာဏိ မုက္တာနိ ဒၖၐ္ဋွာ ဗန္ဒိလောကား ပလာယိတာ ဣတျနုမာယ ကောၐာတ် ခင်္ဂံ ဗဟိး ကၖတွာတ္မဃာတံ ကရ္တ္တုမ် ဥဒျတး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","ကိန္တု ပေါ်လး ပြောစ္စဲသ္တမာဟူယ ကထိတဝါန် ပၑျ ဝယံ သရွွေ'တြာသ္မဟေ, တွံ နိဇပြာဏဟိံသာံ မာကာရ္ၐီး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","တဒါ ပြဒီပမ် အာနေတုမ် ဥက္တွာ သ ကမ္ပမာနး သန် ဥလ္လမ္ပျာဘျန္တရမ် အာဂတျ ပေါ်လသီလယေား ပါဒေၐု ပတိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ပၑ္စာတ် သ တော် ဗဟိရာနီယ ပၖၐ္ဋဝါန် ဟေ မဟေစ္ဆော် ပရိတြာဏံ ပြာပ္တုံ မယာ ကိံ ကရ္တ္တဝျံ? ");
INSERT INTO sanbur_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","ပၑ္စာတ် တော် သွဂၖဟမာနီယ တယေား သမ္မုခေ ခါဒျဒြဝျာဏိ သ္ထာပိတဝါန် တထာ သ သွယံ တဒီယား သရွွေ ပရိဝါရာၑ္စေၑွရေ ဝိၑွသန္တး သာနန္ဒိတာ အဘဝန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","တသ္မဲ တသျ ဂၖဟသ္ထိတသရွွလောကေဘျၑ္စ ပြဘေား ကထာံ ကထိတဝန္တော်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","တထာ ရာတြေသ္တသ္မိန္နေဝ ဒဏ္ဍေ သ တော် ဂၖဟီတွာ တယေား ပြဟာရာဏာံ က္ၐတာနိ ပြက္ၐာလိတဝါန် တတး သ သွယံ တသျ သရွွေ ပရိဇနာၑ္စ မဇ္ဇိတာ အဘဝန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","ပၑ္စာတ် တော် သွဂၖဟမာနီယ တယေား သမ္မုခေ ခါဒျဒြဝျာဏိ သ္ထာပိတဝါန် တထာ သ သွယံ တဒီယား သရွွေ ပရိဝါရာၑ္စေၑွရေ ဝိၑွသန္တး သာနန္ဒိတာ အဘဝန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","ဒိန ဥပသ္ထိတေ တော် လောကော် မောစယေတိ ကထာံ ကထယိတုံ ၑာသကား ပဒါတိဂဏံ ပြေၐိတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","တတး ကာရာရက္ၐကး ပေါ်လာယ တာံ ဝါရ္တ္တာံ ကထိတဝါန် ယုဝါံ တျာဇယိတုံ ၑာသကာ လောကာန ပြေၐိတဝန္တ ဣဒါနီံ ယုဝါံ ဗဟိ ရ္ဘူတွာ ကုၑလေန ပြတိၐ္ဌေတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","ကိန္တု ပေါ်လသ္တာန် အဝဒတ် ရောမိလောကယောရာဝယေား ကမပိ ဒေါၐမ် န နိၑ္စိတျ သရွွေၐာံ သမက္ၐမ် အာဝါံ ကၑယာ တာဍယိတွာ ကာရာယာံ ဗဒ္ဓဝန္တ ဣဒါနီံ ကိမာဝါံ ဂုပ္တံ ဝိသ္တြက္ၐျန္တိ? တန္န ဘဝိၐျတိ, သွယမာဂတျာဝါံ ဗဟိး ကၖတွာ နယန္တု၊ ");
INSERT INTO sanbur_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","တဒါ ပဒါတိဘိး ၑာသကေဘျ ဧတဒွါရ္တ္တာယာံ ကထိတာယာံ တော် ရောမိလောကာဝိတိ ကထာံ ၑြုတွာ တေ ဘီတား ");
INSERT INTO sanbur_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","သန္တသ္တယေား သန္နိဓိမာဂတျ ဝိနယမ် အကုရွွန် အပရံ ဗဟိး ကၖတွာ နဂရာတ် ပြသ္ထာတုံ ပြာရ္ထိတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","တတသ္တော် ကာရာယာ နိရ္ဂတျ လုဒိယာယာ ဂၖဟံ ဂတဝန္တော် တတြ ဘြာတၖဂဏံ သာက္ၐာတ္ကၖတျ တာန် သာန္တွယိတွာ တသ္မာတ် သ္ထာနာတ် ပြသ္ထိတော်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","ပေါ်လသီလော် အာမ္ဖိပလျာပလ္လောနိယာနဂရာဘျာံ ဂတွာ ယတြ ယိဟူဒီယာနာံ ဘဇနဘဝနမေကမ် အာသ္တေ တတြ ထိၐလနီကီနဂရ ဥပသ္ထိတော်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","တဒါ ပေါ်လး သွာစာရာနုသာရေဏ တေၐာံ သမီပံ ဂတွာ ဝိၑြာမဝါရတြယေ တဲး သာရ္ဒ္ဓံ ဓရ္မ္မပုသ္တကီယကထာယာ ဝိစာရံ ကၖတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ဖလတး ခြီၐ္ဋေန ဒုးခဘောဂး ကရ္တ္တဝျး ၑ္မၑာနဒုတ္ထာနဉ္စ ကရ္တ္တဝျံ ယုၐ္မာကံ သန္နိဓော် ယသျ ယီၑေား ပြသ္တာဝံ ကရောမိ သ ဤၑွရေဏာဘိၐိက္တး သ ဧတား ကထား ပြကာၑျ ပြမာဏံ ဒတွာ သ္ထိရီကၖတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","တသ္မာတ် တေၐာံ ကတိပယဇနာ အနျဒေၑီယာ ဗဟဝေါ ဘက္တလောကာ ဗဟျး ပြဓာနနာရျျၑ္စ ဝိၑွသျ ပေါ်လသီလယေား ပၑ္စာဒ္ဂါမိနော ဇာတား၊ ");
INSERT INTO sanbur_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","ကိန္တု ဝိၑွာသဟီနာ ယိဟူဒီယလောကာ ဤရ္ၐျယာ ပရိပူရ္ဏား သန္တော ဟဋဋ္သျ ကတိနယလမ္ပဋလောကာန် သင်္ဂိနး ကၖတွာ ဇနတယာ နဂရမဓျေ မဟာကလဟံ ကၖတွာ ယာသောနော ဂၖဟမ် အာကြမျ ပြေရိတာန် ဓၖတွာ လောကနိဝဟသျ သမီပမ် အာနေတုံ စေၐ္ဋိတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","တေၐာမုဒ္ဒေၑမ် အပြာပျ စ ယာသောနံ ကတိပယာန် ဘြာတၖံၑ္စ ဓၖတွာ နဂရာဓိပတီနာံ နိကဋမာနီယ ပြောစ္စဲး ကထိတဝန္တော ယေ မနုၐျာ ဇဂဒုဒွါဋိတဝန္တသ္တေ 'တြာပျုပသ္ထိတား သန္တိ, ");
INSERT INTO sanbur_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ဧၐ ယာသောန် အာတိထျံ ကၖတွာ တာန် ဂၖဟီတဝါန်၊ ယီၑုနာမက ဧကော ရာဇသ္တီတိ ကထယန္တသ္တေ ကဲသရသျာဇ္ဉာဝိရုဒ္ဓံ ကရ္မ္မ ကုရွွတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","တေၐာံ ကထာမိမာံ ၑြုတွာ လောကနိဝဟော နဂရာဓိပတယၑ္စ သမုဒွိဂ္နာ အဘဝန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","တဒါ ယာသောနသ္တဒနျေၐာဉ္စ ဓနဒဏ္ဍံ ဂၖဟီတွာ တာန် ပရိတျက္တဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","တတး ပရံ ဘြာတၖဂဏော ရဇနျာံ ပေါ်လသီလော် ၑီဃြံ ဗိရယာနဂရံ ပြေၐိတဝါန် တော် တတြောပသ္ထာယ ယိဟူဒီယာနာံ ဘဇနဘဝနံ ဂတဝန္တော်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","တတြသ္ထာ လောကား ထိၐလနီကီသ္ထလောကေဘျော မဟာတ္မာန အာသန် ယတ ဣတ္ထံ ဘဝတိ န ဝေတိ ဇ္ဉာတုံ ဒိနေ ဒိနေ ဓရ္မ္မဂြန္ထသျာလောစနာံ ကၖတွာ သွဲရံ ကထာမ် အဂၖဟ္လန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","တသ္မာဒ် အနေကေ ယိဟူဒီယာ အနျဒေၑီယာနာံ မာနျာ သ္တြိယး ပုရုၐာၑ္စာနေကေ ဝျၑွသန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","ကိန္တု ဗိရယာနဂရေ ပေါ်လေနေၑွရီယာ ကထာ ပြစာရျျတ ဣတိ ထိၐလနီကီသ္ထာ ယိဟူဒီယာ ဇ္ဉာတွာ တတ္သ္ထာနမပျာဂတျ လောကာနာံ ကုပြဝၖတ္တိမ် အဇနယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","အတဧဝ တသ္မာတ် သ္ထာနာတ် သမုဒြေဏ ယာန္တီတိ ဒရ္ၑယိတွာ ဘြာတရး က္ၐိပြံ ပေါ်လံ ပြာဟိဏွန် ကိန္တု သီလတီမထိယော် တတြ သ္ထိတဝန္တော်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","တတး ပရံ ပေါ်လသျ မာရ္ဂဒရ္ၑကာသ္တမ် အာထီနီနဂရ ဥပသ္ထာပယန် ပၑ္စာဒ် ယုဝါံ တူရ္ဏမ် ဧတတ် သ္ထာနံ အာဂမိၐျထး သီလတီမထိယော် ပြတီမာမ် အာဇ္ဉာံ ပြာပျ တေ ပြတျာဂတား၊ ");
INSERT INTO sanbur_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","ပေါ်လ အာထီနီနဂရေ တာဝပေက္ၐျ တိၐ္ဌန် တန္နဂရံ ပြတိမာဘိး ပရိပူရ္ဏံ ဒၖၐ္ဋွာ သန္တပ္တဟၖဒယော 'ဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","တတး သ ဘဇနဘဝနေ ယာန် ယိဟူဒီယာန် ဘက္တလောကာံၑ္စ ဟဋ္ဋေ စ ယာန် အပၑျတ် တဲး သဟ ပြတိဒိနံ ဝိစာရိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","ကိန္တွိပိကူရီယမတဂြဟိဏး သ္တောယိကီယမတဂြာဟိဏၑ္စ ကိယန္တော ဇနာသ္တေန သာရ္ဒ္ဓံ ဝျဝဒန္တ၊ တတြ ကေစိဒ် အကထယန် ဧၐ ဝါစာလး ကိံ ဝက္တုမ် ဣစ္ဆတိ? အပရေ ကေစိဒ် ဧၐ ဇနး ကေၐာဉ္စိဒ် ဝိဒေၑီယဒေဝါနာံ ပြစာရက ဣတျနုမီယတေ ယတး သ ယီၑုမ် ဥတ္ထိတိဉ္စ ပြစာရယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","တေ တမ် အရေယပါဂနာမ ဝိစာရသ္ထာနမ် အာနီယ ပြာဝေါစန် ဣဒံ ယန္နဝီနံ မတံ တွံ ပြာစီကၑ ဣဒံ ကီဒၖၑံ ဧတဒ် အသ္မာန် ၑြာဝယ; ");
INSERT INTO sanbur_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","ယာမိမာမ် အသမ္ဘဝကထာမ် အသ္မာကံ ကရ္ဏဂေါစရီကၖတဝါန် အသျာ ဘာဝါရ္ထး က ဣတိ ဝယံ ဇ္ဉာတုမ် ဣစ္ဆာမး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","တဒါထီနီနိဝါသိနသ္တန္နဂရပြဝါသိနၑ္စ ကေဝလံ ကသျာၑ္စန နဝီနကထာယား ၑြဝဏေန ပြစာရဏေန စ ကာလမ် အယာပယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","ပေါ်လော'ရေယပါဂသျ မဓျေ တိၐ္ဌန် ဧတာံ ကထာံ ပြစာရိတဝါန်, ဟေ အာထီနီယလောကာ ယူယံ သရွွထာ ဒေဝပူဇာယာမ် အာသက္တာ ဣတျဟ ပြတျက္ၐံ ပၑျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","ယတး ပရျျဋနကာလေ ယုၐ္မာကံ ပူဇနီယာနိ ပၑျန် ‘အဝိဇ္ဉာတေၑွရာယ’ ဧတလ္လိပိယုက္တာံ ယဇ္ဉဝေဒီမေကာံ ဒၖၐ္ဋဝါန်; အတော န ဝိဒိတွာ ယံ ပူဇယဓွေ တသျဲဝ တတွံ ယုၐ္မာန် ပြတိ ပြစာရယာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","ဇဂတော ဇဂတ္သ္ထာနာံ သရွွဝသ္တူနာဉ္စ သြၐ္ဋာ ယ ဤၑွရး သ သွရ္ဂပၖထိဝျောရေကာဓိပတိး သန် ကရနိရ္မ္မိတမန္ဒိရေၐု န နိဝသတိ; ");
INSERT INTO sanbur_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","သ ဧဝ သရွွေဘျော ဇီဝနံ ပြာဏာန် သရွွသာမဂြီၑ္စ ပြဒဒါတိ; အတဧဝ သ ကသျာၑ္စိတ် သာမဂျြာ အဘာဝဟေတော ရ္မနုၐျာဏာံ ဟသ္တဲး သေဝိတော ဘဝတီတိ န၊ ");
INSERT INTO sanbur_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","သ ဘူမဏ္ဍလေ နိဝါသာရ္ထမ် ဧကသ္မာတ် ၑောဏိတာတ် သရွွာန် မနုၐျာန် သၖၐ္ဋွာ တေၐာံ ပူရွွနိရူပိတသမယံ ဝသတိသီမာဉ္စ နိရစိနောတ်; ");
INSERT INTO sanbur_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","တသ္မာတ် လောကဲး ကေနာပိ ပြကာရေဏ မၖဂယိတွာ ပရမေၑွရသျ တတွံ ပြာပ္တုံ တသျ ဂဝေၐဏံ ကရဏီယမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","ကိန္တု သော'သ္မာကံ ကသ္မာစ္စိဒပိ ဒူရေ တိၐ္ဌတီတိ နဟိ, ဝယံ တေန နိၑွသနပြၑွသနဂမနာဂမနပြာဏဓာရဏာနိ ကုရ္မ္မး, ပုुနၑ္စ ယုၐ္မာကမေဝ ကတိပယား ကဝယး ကထယန္တိ ‘တသျ ဝံၑာ ဝယံ သ္မော ဟိ’ ဣတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","အတဧဝ ယဒိ ဝယမ် ဤၑွရသျ ဝံၑာ ဘဝါမသ္တရှိ မနုၐျဲ ရွိဒျယာ ကော်ၑလေန စ တက္ၐိတံ သွရ္ဏံ ရူပျံ ဒၖၐဒ် ဝဲတေၐာမီၑွရတွမ် အသ္မာဘိ ရ္န ဇ္ဉာတဝျံ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","တေၐာံ ပူရွွီယလောကာနာမ် အဇ္ဉာနတာံ ပြတီၑွရော ယဒျပိ နာဝါဓတ္တ တထာပီဒါနီံ သရွွတြ သရွွာန် မနး ပရိဝရ္တ္တယိတုမ် အာဇ္ဉာပယတိ, ");
INSERT INTO sanbur_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","ယတး သွနိယုက္တေန ပုရုၐေဏ ယဒါ သ ပၖထိဝီသ္ထာနာံ သရွွလောကာနာံ ဝိစာရံ ကရိၐျတိ တဒ္ဒိနံ နျရူပယတ်; တသျ ၑ္မၑာနောတ္ထာပနေန တသ္မိန် သရွွေဘျး ပြမာဏံ ပြာဒါတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","တဒါ ၑ္မၑာနာဒ် ဥတ္ထာနသျ ကထာံ ၑြုတွာ ကေစိဒ် ဥပါဟမန်, ကေစိဒဝဒန် ဧနာံ ကထာံ ပုနရပိ တွတ္တး ၑြောၐျာမး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","တတး ပေါ်လသ္တေၐာံ သမီပါတ် ပြသ္ထိाတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","တထာပိ ကေစိလ္လောကာသ္တေန သာရ္ဒ္ဓံ မိလိတွာ ဝျၑွသန် တေၐာံ မဓျေ 'ရေယပါဂီယဒိယနုသိယော ဒါမာရီနာမာ ကာစိန္နာရီ ကိယန္တော နရာၑ္စာသန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","တဒ္ဃဋနာတး ပရံ ပေါ်လ အာထီနီနဂရာဒ် ယာတြာံ ကၖတွာ ကရိန္ထနဂရမ် အာဂစ္ဆတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","တသ္မိန် သမယေ က္လော်ဒိယး သရွွာန် ယိဟူဒီယာန် ရောမာနဂရံ ဝိဟာယ ဂန္တုမ် အာဇ္ဉာပယတ်, တသ္မာတ် ပြိသ္ကိလ္လာနာမ္နာ ဇာယယာ သာရ္ဒ္ဓမ် ဣတာလိယာဒေၑာတ် ကိဉ္စိတ္ပူရွွမ် အာဂမတ် ယး ပန္တဒေၑေ ဇာတ အာက္ကိလနာမာ ယိဟူဒီယလောကး ပေါ်လသ္တံ သာက္ၐာတ် ပြာပျ တယေား သမီပမိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","တော် ဒူၐျနိရ္မ္မာဏဇီဝိနော်, တသ္မာတ် ပရသ္ပရမ် ဧကဝၖတ္တိကတွာတ် သ တာဘျာံ သဟ ဥၐိတွာ တတ် ကရ္မ္မာကရောတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","ပေါ်လး ပြတိဝိၑြာမဝါရံ ဘဇနဘဝနံ ဂတွာ ဝိစာရံ ကၖတွာ ယိဟူဒီယာန် အနျဒေၑီယာံၑ္စ ပြဝၖတ္တိံ ဂြာဟိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","သီလတီမထိယယော ရ္မာကိဒနိယာဒေၑာတ် သမေတယေား သတေား ပေါ်လ ဥတ္တပ္တမနာ ဘူတွာ ယီၑုရီၑွရေဏာဘိၐိက္တော ဘဝတီတိ ပြမာဏံ ယိဟူဒီယာနာံ သမီပေ ပြာဒါတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","ကိန္တု တေ 'တီဝ ဝိရောဓံ ဝိဓာယ ပါၐဏ္ဍီယကထာံ ကထိတဝန္တသ္တတး ပေါ်လော ဝသ္တြံ ဓုနွန် ဧတာံ ကထာံ ကထိတဝါန်, ယုၐ္မာကံ ၑောဏိတပါတာပရာဓော ယုၐ္မာန် ပြတျေဝ ဘဝတု, တေနာဟံ နိရပရာဓော 'ဒျာရဘျ ဘိန္နဒေၑီယာနာံ သမီပံ ယာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","သ တသ္မာတ် ပြသ္ထာယ ဘဇနဘဝနသမီပသ္ထသျ ယုသ္တနာမ္န ဤၑွရဘက္တသျ ဘိန္နဒေၑီယသျ နိဝေၑနံ ပြာဝိၑတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","တတး ကြီၐ္ပနာမာ ဘဇနဘဝနာဓိပတိး သပရိဝါရး ပြဘော် ဝျၑွသီတ်, ကရိန္ထနဂရီယာ ဗဟဝေါ လောကာၑ္စ သမာကရ္ဏျ ဝိၑွသျ မဇ္ဇိတာ အဘဝန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","က္ၐဏဒါယာံ ပြဘုး ပေါ်လံ ဒရ္ၑနံ ဒတွာ ဘာၐိတဝါန်, မာ ဘဲၐီး, မာ နိရသီး ကထာံ ပြစာရယ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","အဟံ တွယာ သာရ္ဒ္ဓမ် အာသ ဟိံသာရ္ထံ ကောပိ တွာံ သ္ပြၐ္ဋုံ န ၑက္ၐျတိ နဂရေ'သ္မိန် မဒီယာ လောကာ ဗဟဝ အာသတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","တသ္မာတ် ပေါ်လသ္တန္နဂရေ ပြာယေဏ သာရ္ဒ္ဓဝတ္သရပရျျန္တံ သံသ္ထာယေၑွရသျ ကထာမ် ဥပါဒိၑတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","ဂါလ္လိယနာမာ ကၑ္စိဒ် အာခါယာဒေၑသျ ပြာဍွိဝါကး သမဘဝတ်, တတော ယိဟူဒီယာ ဧကဝါကျား သန္တး ပေါ်လမ် အာကြမျ ဝိစာရသ္ထာနံ နီတွာ ");
INSERT INTO sanbur_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","မာနုၐ ဧၐ ဝျဝသ္ထာယ ဝိရုဒ္ဓမ် ဤၑွရဘဇနံ ကရ္တ္တုံ လောကာန် ကုပြဝၖတ္တိံ ဂြာဟယတီတိ နိဝေဒိတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","တတး ပေါ်လေ ပြတျုတ္တရံ ဒါတုမ် ဥဒျတေ သတိ ဂါလ္လိယာ ယိဟူဒီယာန် ဝျာဟရတ်, ယဒိ ကသျစိဒ် အနျာယသျ ဝါတိၑယဒုၐ္ဋတာစရဏသျ ဝိစာရော'ဘဝိၐျတ် တရှိ ယုၐ္မာကံ ကထာ မယာ သဟနီယာဘဝိၐျတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","ကိန္တု ယဒိ ကေဝလံ ကထာယာ ဝါ နာမ္နော ဝါ ယုၐ္မာကံ ဝျဝသ္ထာယာ ဝိဝါဒေါ ဘဝတိ တရှိ တသျ ဝိစာရမဟံ န ကရိၐျာမိ, ယူယံ တသျ မီမာံသာံ ကုရုတ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","တတး သ တာန် ဝိစာရသ္ထာနာဒ် ဒူရီကၖတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","တဒါ ဘိန္နဒေၑီယား သောသ္ထိနိနာမာနံ ဘဇနဘဝနသျ ပြဓာနာဓိပတိံ ဓၖတွာ ဝိစာရသ္ထာနသျ သမ္မုခေ ပြာဟရန် တထာပိ ဂါလ္လိယာ တေၐု သရွွကရ္မ္မသု န မနော နျဒဓာတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","ပေါ်လသ္တတြ ပုနရ္ဗဟုဒိနာနိ နျဝသတ်, တတော ဘြာတၖဂဏာဒ် ဝိသရ္ဇနံ ပြာပျ ကိဉ္စနဝြတနိမိတ္တံ ကိံကြိယာနဂရေ ၑိရော မုဏ္ဍယိတွာ ပြိသ္ကိလ္လာက္ကိလာဘျာံ သဟိတော ဇလပထေန သုရိယာဒေၑံ ဂတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","တတ ဣဖိၐနဂရ ဥပသ္ထာယ တတြ တော် ဝိသၖဇျ သွယံ ဘဇနဘွနံ ပြဝိၑျ ယိဟူဒီယဲး သဟ ဝိစာရိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","တေ သွဲး သာရ္ဒ္ဓံ ပုနး ကတိပယဒိနာနိ သ္ထာတုံ တံ ဝျနယန်, သ တဒနုရရီကၖတျ ကထာမေတာံ ကထိတဝါန်, ");
INSERT INTO sanbur_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ယိရူၑာလမိ အာဂါမျုတ္သဝပါလနာရ္ထံ မယာ ဂမနီယံ; ပၑ္စာဒ် ဤၑွရေစ္ဆာယာံ ဇာတာယာံ ယုၐ္မာကံ သမီပံ ပြတျာဂမိၐျာမိ၊ တတး ပရံ သ တဲ ရွိသၖၐ္ဋး သန် ဇလပထေန ဣဖိၐနဂရာတ် ပြသ္ထိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","တတး ကဲသရိယာမ် ဥပသ္ထိတး သန် နဂရံ ဂတွာ သမာဇံ နမသ္ကၖတျ တသ္မာဒ် အာန္တိယခိယာနဂရံ ပြသ္ထိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","တတြ ကိယတ္ကာလံ ယာပယိတွာ တသ္မာတ် ပြသ္ထာယ သရွွေၐာံ ၑိၐျာဏာံ မနာံသိ သုသ္ထိရာဏိ ကၖတွာ ကြမၑော ဂလာတိယာဖြုဂိယာဒေၑယော ရ္ဘြမိတွာ ဂတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","တသ္မိန္နေဝ သမယေ သိကန္ဒရိယာနဂရေ ဇာတ အာပလ္လောနာမာ ၑာသ္တြဝိတ် သုဝက္တာ ယိဟူဒီယ ဧကော ဇန ဣဖိၐနဂရမ် အာဂတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","သ ၑိက္ၐိတပြဘုမာရ္ဂော မနသောဒျောဂီ စ သန် ယောဟနော မဇ္ဇနမာတြံ ဇ္ဉာတွာ ယထာရ္ထတယာ ပြဘေား ကထာံ ကထယန် သမုပါဒိၑတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ဧၐ ဇနော နိရ္ဘယတွေန ဘဇနဘဝနေ ကထယိတုမ် အာရဗ္ဓဝါန်, တတး ပြိသ္ကိလ္လာက္ကိလော် တသျောပဒေၑကထာံ နိၑမျ တံ သွယေား သမီပမ် အာနီယ ၑုဒ္ဓရူပေဏေၑွရသျ ကထာမ် အဗောဓယတာမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","ပၑ္စာတ် သ အာခါယာဒေၑံ ဂန္တုံ မတိံ ကၖတဝါန်, တဒါ တတြတျး ၑိၐျဂဏော ယထာ တံ ဂၖဟ္လာတိ တဒရ္ထံ ဘြာတၖဂဏေန သမာၑွသျ ပတြေ လိခိတေ သတိ, အာပလ္လာသ္တတြောပသ္ထိတး သန် အနုဂြဟေဏ ပြတျယိနာံ ဗဟူပကာရာန် အကရောတ်, ");
INSERT INTO sanbur_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ဖလတော ယီၑုရဘိၐိက္တသ္တြာတေတိ ၑာသ္တြပြမာဏံ ဒတွာ ပြကာၑရူပေဏ ပြတိပန္နံ ကၖတွာ ယိဟူဒီယာန် နိရုတ္တရာန် ကၖတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","ကရိန္ထနဂရ အာပလ္လသး သ္ထိတိကာလေ ပေါ်လ ဥတ္တရပြဒေၑဲရာဂစ္ဆန် ဣဖိၐနဂရမ် ဥပသ္ထိတဝါန်၊ တတြ ကတိပယၑိၐျာန် သာက္ၐတ် ပြာပျ တာန် အပၖစ္ဆတ်, ");
INSERT INTO sanbur_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ယူယံ ဝိၑွသျ ပဝိတြမာတ္မာနံ ပြာပ္တာ န ဝါ? တတသ္တေ ပြတျဝဒန် ပဝိတြ အာတ္မာ ဒီယတေ ဣတျသ္မာဘိး ၑြုတမပိ နဟိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","တဒါ သာ'ဝဒတ် တရှိ ယူယံ ကေန မဇ္ဇိတာ အဘဝတ? တေ'ကထယန် ယောဟနော မဇ္ဇနေန၊ ");
INSERT INTO sanbur_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","တဒါ ပေါ်လ ဥက္တဝါန် ဣတး ပရံ ယ ဥပသ္ထာသျတိ တသ္မိန် အရ္ထတ ယီၑုခြီၐ္ဋေ ဝိၑွသိတဝျမိတျုက္တွာ ယောဟန် မနးပရိဝရ္တ္တနသူစကေန မဇ္ဇနေန ဇလေ လောကာန် အမဇ္ဇယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","တာဒၖၑီံ ကထာံ ၑြုတွာ တေ ပြဘော ရျီၑုခြီၐ္ဋသျ နာမ္နာ မဇ္ဇိတာ အဘဝန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","တတး ပေါ်လေန တေၐာံ ဂါတြေၐု ကရေ'ရ္ပိတေ တေၐာမုပရိ ပဝိတြ အာတ္မာဝရူဎဝါန်, တသ္မာတ် တေ နာနာဒေၑီယာ ဘာၐာ ဘဝိၐျတ္ကထာၑ္စ ကထိတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","တေ ပြာယေဏ ဒွါဒၑဇနာ အာသန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","ပေါ်လော ဘဇနဘဝနံ ဂတွာ ပြာယေဏ မာသတြယမ် ဤၑွရသျ ရာဇျသျ ဝိစာရံ ကၖတွာ လောကာန် ပြဝရ္တျ သာဟသေန ကထာမကထယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","ကိန္တု ကဌိနာန္တးကရဏတွာတ် ကိယန္တော ဇနာ န ဝိၑွသျ သရွွေၐာံ သမက္ၐမ် ဧတတ္ပထသျ နိန္ဒာံ ကရ္တ္တုံ ပြဝၖတ္တား, အတး ပေါ်လသ္တေၐာံ သမီပါတ် ပြသ္ထာယ ၑိၐျဂဏံ ပၖထက္ကၖတွာ ပြတျဟံ တုရာန္နနာမ္နး ကသျစိတ် ဇနသျ ပါဌၑာလာယာံ ဝိစာရံ ကၖတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ဣတ္ထံ ဝတ္သရဒွယံ ဂတံ တသ္မာဒ် အာၑိယာဒေၑနိဝါသိနး သရွွေ ယိဟူဒီယာ အနျဒေၑီယလောကာၑ္စ ပြဘော ရျီၑေား ကထာမ် အၑြော်ၐန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","ပေါ်လေန စ ဤၑွရ ဧတာဒၖၑာနျဒ္ဘုတာနိ ကရ္မ္မာဏိ ကၖတဝါန္ ");
INSERT INTO sanbur_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ယတ် ပရိဓေယေ ဂါတြမာရ္ဇနဝသ္တြေ ဝါ တသျ ဒေဟာတ် ပီဍိတလောကာနာမ် သမီပမ် အာနီတေ တေ နိရာမယာ ဇာတာ အပဝိတြာ ဘူတာၑ္စ တေဘျော ဗဟိရ္ဂတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","တဒါ ဒေၑာဋနကာရိဏး ကိယန္တော ယိဟူဒီယာ ဘူတာပသာရိဏော ဘူတဂြသ္တနောကာနာံ သန္နိဓော် ပြဘေ ရျီၑော ရ္နာမ ဇပ္တွာ ဝါကျမိဒမ် အဝဒန်, ယသျ ကထာံ ပေါ်လး ပြစာရယတိ တသျ ယီၑော ရ္နာမ္နာ ယုၐ္မာန် အာဇ္ဉာပယာမး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","သ္ကိဝနာမ္နော ယိဟူဒီယာနာံ ပြဓာနယာဇကသျ သပ္တဘိး ပုတ္တဲသ္တထာ ကၖတေ သတိ ");
INSERT INTO sanbur_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","ကၑ္စိဒ် အပဝိတြော ဘူတး ပြတျုဒိတဝါန်, ယီၑုံ ဇာနာမိ ပေါ်လဉ္စ ပရိစိနောမိ ကိန္တု ကေ ယူယံ? ");
INSERT INTO sanbur_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ဣတျုက္တွာ သောပဝိတြဘူတဂြသ္တော မနုၐျော လမ္ဖံ ကၖတွာ တေၐာမုပရိ ပတိတွာ ဗလေန တာန် ဇိတဝါန်, တသ္မာတ္တေ နဂ္နား က္ၐတာင်္ဂါၑ္စ သန္တသ္တသ္မာဒ် ဂေဟာတ် ပလာယန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","သာ ဝါဂ် ဣဖိၐနဂရနိဝါသိနသံ သရွွေၐာံ ယိဟူဒီယာနာံ ဘိန္နဒေၑီယာနာံ လောကာနာဉ္စ ၑြဝေါဂေါစရီဘူတာ; တတး သရွွေ ဘယံ ဂတား ပြဘော ရျီၑော ရ္နာမ္နော ယၑော 'ဝရ္ဒ္ဓတ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","ယေၐာမနေကေၐာံ လောကာနာံ ပြတီတိရဇာယတ တ အာဂတျ သွဲး ကၖတား ကြိယား ပြကာၑရူပေဏာင်္ဂီကၖတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","ဗဟဝေါ မာယာကရ္မ္မကာရိဏး သွသွဂြန္ထာန် အာနီယ ရာၑီကၖတျ သရွွေၐာံ သမက္ၐမ် အဒါဟယန်, တတော ဂဏနာံ ကၖတွာဗုဓျန္တ ပဉ္စာယုတရူပျမုဒြာမူလျပုသ္တကာနိ ဒဂ္ဓာနိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ဣတ္ထံ ပြဘေား ကထာ သရွွဒေၑံ ဝျာပျ ပြဗလာ ဇာတာ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","သရွွေၐွေတေၐု ကရ္မ္မသု သမ္ပန္နေၐု သတ္သု ပေါ်လော မာကိဒနိယာခါယာဒေၑာဘျာံ ယိရူၑာလမံ ဂန္တုံ မတိံ ကၖတွာ ကထိတဝါန် တတ္သ္ထာနံ ယာတြာယာံ ကၖတာယာံ သတျာံ မယာ ရောမာနဂရံ ဒြၐ္ဋဝျံ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","သွာနုဂတလောကာနာံ တီမထိယေရာသ္တော် ဒွေါ် ဇနော် မာကိဒနိယာဒေၑံ ပြတိ ပြဟိတျ သွယမ် အာၑိယာဒေၑေ ကတိပယဒိနာနိ သ္ထိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","ကိန္တု တသ္မိန် သမယေ မတေ'သ္မိန် ကလဟော ဇာတး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","တတ္ကာရဏမိဒံ, အရ္တ္တိမီဒေဝျာ ရူပျမန္ဒိရနိရ္မ္မာဏေန သရွွေၐာံ ၑိလ္ပိနာံ ယထေၐ္ဋလာဘမ် အဇနယတ် ယော ဒီမီတြိယနာမာ နာဍီန္ဓမး ");
INSERT INTO sanbur_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","သ တာန် တတ္ကရ္မ္မဇီဝိနး သရွွလောကာံၑ္စ သမာဟူယ ဘာၐိတဝါန် ဟေ မဟေစ္ဆာ ဧတေန မန္ဒိရနိရ္မ္မာဏေနာသ္မာကံ ဇီဝိကာ ဘဝတိ, ဧတဒ် ယူယံ ဝိတ္ထ; ");
INSERT INTO sanbur_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","ကိန္တု ဟသ္တနိရ္မ္မိတေၑွရာ ဤၑွရာ နဟိ ပေါ်လနာမ္နာ ကေနစိဇ္ဇနေန ကထာမိမာံ ဝျာဟၖတျ ကေဝလေဖိၐနဂရေ နဟိ ပြာယေဏ သရွွသ္မိန် အာၑိယာဒေၑေ ပြဝၖတ္တိံ ဂြာဟယိတွာ ဗဟုလောကာနာံ ၑေမုၐီ ပရာဝရ္တ္တိတာ, ဧတဒ် ယုၐ္မာဘိ ရ္ဒၖၑျတေ ၑြူယတေ စ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","တေနာသ္မာကံ ဝါဏိဇျသျ သရွွထာ ဟာနေး သမ္ဘဝနံ ကေဝလမိတိ နဟိ, အာၑိယာဒေၑသ္ထဲ ရွာ သရွွဇဂတ္သ္ထဲ ရ္လောကဲး ပူဇျာ ယာရ္တိမီ မဟာဒေဝီ တသျာ မန္ဒိရသျာဝဇ္ဉာနသျ တသျာ အဲၑွရျျသျ နာၑသျ စ သမ္ဘာဝနာ ဝိဒျတေे၊ ");
INSERT INTO sanbur_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","ဧတာဒၖၑီံ ကထာံ ၑြုတွာ တေ မဟာကြောဓာနွိတား သန္တ ဥစ္စဲးကာရံ ကထိတဝန္တ ဣဖိၐီယာနာမ် အရ္တ္တိမီ ဒေဝီ မဟတီ ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","တတး သရွွနဂရံ ကလဟေန ပရိပူရ္ဏမဘဝတ်, တတး ပရံ တေ မာကိဒနီယဂါယာရိသ္တာရ္ခနာမာနော် ပေါ်လသျ ဒွေါ် သဟစရော် ဓၖတွဲကစိတ္တာ ရင်္ဂဘူမိံ ဇဝေန ဓာဝိတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","တတး ပေါ်လော လောကာနာံ သန္နိဓိံ ယာတုမ် ဥဒျတဝါန် ကိန္တု ၑိၐျဂဏသ္တံ ဝါရိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","ပေါ်လသျတ္မီယာ အာၑိယာဒေၑသ္ထား ကတိပယား ပြဓာနလောကာသ္တသျ သမီပံ နရမေကံ ပြေၐျ တွံ ရင်္ဂဘူမိံ မာဂါ ဣတိ နျဝေဒယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","တတော နာနာလောကာနာံ နာနာကထာကထနာတ် သဘာ ဝျာကုလာ ဇာတာ ကိံ ကာရဏာဒ် ဧတာဝတီ ဇနတာဘဝတ် ဧတဒ် အဓိကဲ ရ္လောကဲ ရ္နာဇ္ဉာယိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","တတး ပရံ ဇနတာမဓျာဒ် ယိဟူဒီယဲရ္ဗဟိၐ္ကၖတး သိကန္ဒရော ဟသ္တေန သင်္ကေတံ ကၖတွာ လောကေဘျ ဥတ္တရံ ဒါတုမုဒျတဝါန်, ");
INSERT INTO sanbur_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","ကိန္တု သ ယိဟူဒီယလောက ဣတိ နိၑ္စိတေ သတိ ဣဖိၐီယာနာမ် အရ္တ္တိမီ ဒေဝီ မဟတီတိ ဝါကျံ ပြာယေဏ ပဉ္စ ဒဏ္ဍာန် ယာဝဒ် ဧကသွရေဏ လောကနိဝဟဲး ပြောက္တံ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","တတော နဂရာဓိပတိသ္တာန် သ္ထိရာန် ကၖတွာ ကထိတဝါန် ဟေ ဣဖိၐာယား သရွွေ လောကာ အာကရ္ဏယတ, အရ္တိမီမဟာဒေဝျာ မဟာဒေဝါတ် ပတိတာယာသ္တတ္ပြတိမာယာၑ္စ ပူဇနမ ဣဖိၐနဂရသ္ထား သရွွေ လောကား ကုရွွန္တိ, ဧတတ် ကေ န ဇာနန္တိ? ");
INSERT INTO sanbur_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","တသ္မာဒ် ဧတတ္ပြတိကူလံ ကေပိ ကထယိတုံ န ၑက္နုဝန္တိ, ဣတိ ဇ္ဉာတွာ ယုၐ္မာဘိး သုသ္ထိရတွေန သ္ထာတဝျမ် အဝိဝိစျ ကိမပိ ကရ္မ္မ န ကရ္တ္တဝျဉ္စ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","ယာန် ဧတာန် မနုၐျာန် ယူယမတြ သမာနယတ တေ မန္ဒိရဒြဝျာပဟာရကာ ယုၐ္မာကံ ဒေဝျာ နိန္ဒကာၑ္စ န ဘဝန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","ယဒိ ကဉ္စန ပြတိ ဒီမီတြိယသျ တသျ သဟာယာနာဉ္စ ကာစိဒ် အာပတ္တိ ရွိဒျတေ တရှိ ပြတိနိဓိလောကာ ဝိစာရသ္ထာနဉ္စ သန္တိ, တေ တတ် သ္ထာနံ ဂတွာ ဥတ္တရပြတျုတ္တရေ ကုရွွန္တု၊ ");
INSERT INTO sanbur_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","ကိန္တု ယုၐ္မာကံ ကာစိဒပရာ ကထာ ယဒိ တိၐ္ဌတိ တရှိ နိယမိတာယာံ သဘာယာံ တသျာ နိၐ္ပတ္တိ ရ္ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","ကိန္တွေတသျ ဝိရောဓသျောတ္တရံ ယေန ဒါတုံ ၑက္နုမ် ဧတာဒၖၑသျ ကသျစိတ် ကာရဏသျာဘာဝါဒ် အဒျတနဃဋနာဟေတော ရာဇဒြောဟိဏာမိဝါသ္မာကမ် အဘိယောဂေါ ဘဝိၐျတီတိ ၑင်္ကာ ဝိဒျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","ဣတိ ကထယိတွာ သ သဘာသ္ထလောကာန် ဝိသၖၐ္ဋဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ဣတ္ထံ ကလဟေ နိဝၖတ္တေ သတိ ပေါ်လး ၑိၐျဂဏမ် အာဟူယ ဝိသရ္ဇနံ ပြာပျ မာကိဒနိယာဒေၑံ ပြသ္ထိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","တေန သ္ထာနေန ဂစ္ဆန် တဒ္ဒေၑီယာန် ၑိၐျာန် ဗဟူပဒိၑျ ယူနာနီယဒေၑမ် ဥပသ္ထိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","တတြ မာသတြယံ သ္ထိတွာ တသ္မာတ် သုရိယာဒေၑံ ယာတုမ် ဥဒျတး, ကိန္တု ယိဟူဒီယာသ္တံ ဟန္တုံ ဂုပ္တာ အတိၐ္ဌန် တသ္မာတ် သ ပုနရပိ မာကိဒနိယာမာရ္ဂေဏ ပြတျာဂန္တုံ မတိံ ကၖတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","ဗိရယာနဂရီယသောပါတြး ထိၐလနီကီယာရိသ္တာရ္ခသိကုန္ဒော် ဒရ္ဗ္ဗောနဂရီယဂါယတီမထိယော် အာၑိယာဒေၑီယတုခိကတြဖိမော် စ တေန သာရ္ဒ္ဓံ အာၑိယာဒေၑံ ယာဝဒ် ဂတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ဧတေ သရွွေ 'ဂြသရား သန္တော 'သ္မာန် အပေက္ၐျ တြောယာနဂရေ သ္ထိတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","ကိဏွၑူနျပူပေါတ္သဝဒိနေ စ ဂတေ သတိ ဝယံ ဖိလိပီနဂရာတ် တောယပထေန ဂတွာ ပဉ္စဘိ ရ္ဒိနဲသ္တြောယာနဂရမ် ဥပသ္ထာယ တတြ သပ္တဒိနာနျဝါတိၐ္ဌာမ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","သပ္တာဟသျ ပြထမဒိနေ ပူပါန် ဘံက္တု ၑိၐျေၐု မိလိတေၐု ပေါ်လး ပရဒိနေ တသ္မာတ် ပြသ္ထာတုမ် ဥဒျတး သန် တဒဟ္နိ ပြာယေဏ က္ၐပါယာ ယာမဒွယံ ယာဝတ် ၑိၐျေဘျော ဓရ္မ္မကထာမ် အကထယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ဥပရိသ္ထေ ယသ္မိန် ပြကောၐ္ဌေ သဘာံ ကၖတွာသန် တတြ ဗဟဝး ပြဒီပါး ပြာဇွလန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ဥတုခနာမာ ကၑ္စန ယုဝါ စ ဝါတာယန ဥပဝိၑန် ဃောရတရနိဒြာဂြသ္တော 'ဘူတ် တဒါ ပေါ်လေန ဗဟုက္ၐဏံ ကထာယာံ ပြစာရိတာယာံ နိဒြာမဂ္နး သ တသ္မာဒ် ဥပရိသ္ထတၖတီယပြကောၐ္ဌာဒ် အပတတ်, တတော လောကာသ္တံ မၖတကလ္ပံ ဓၖတွောဒတောလယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","တတး ပေါ်လော'ဝရုဟျ တသျ ဂါတြေ ပတိတွာ တံ ကြောဍေ နိဓာယ ကထိတဝါန်, ယူယံ ဝျာကုလာ မာ ဘူတ နာယံ ပြာဏဲ ရွိယုက္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","ပၑ္စာတ် သ ပုနၑ္စောပရိ ဂတွာ ပူပါန် ဘံက္တွာ ပြဘာတံ ယာဝတ် ကထောပကထနေ ကၖတွာ ပြသ္ထိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","တေ စ တံ ဇီဝန္တံ ယုဝါနံ ဂၖဟီတွာ ဂတွာ ပရမာပျာယိတာ ဇာတား၊ ");
INSERT INTO sanbur_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","အနန္တရံ ဝယံ ပေါတေနာဂြသရာ ဘူတွာသ္မနဂရမ် ဥတ္တီရျျ ပေါ်လံ ဂြဟီတုံ မတိမ် အကုရ္မ္မ ယတး သ တတြ ပဒ္ဘျာံ ဝြဇိတုံ မတိံ ကၖတွေတိ နိရူပိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","တသ္မာတ် တတြာသ္မာဘိး သာရ္ဒ္ဓံ တသ္မိန် မိလိတေ သတိ ဝယံ တံ နီတွာ မိတုလီနျုပဒွီပံ ပြာပ္တဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","တသ္မာတ် ပေါတံ မောစယိတွာ ပရေ'ဟနိ ခီယောပဒွီပသျ သမ္မုခံ လဗ္ဓဝန္တသ္တသ္မာဒ် ဧကေနာဟ္နာ သာမောပဒွီပံ ဂတွာ ပေါတံ လာဂယိတွာ တြောဂုလ္လိယေ သ္ထိတွာ ပရသ္မိန် ဒိဝသေे မိလီတနဂရမ် ဥပါတိၐ္ဌာမ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","ယတး ပေါ်လ အာၑိယာဒေၑေ ကာလံ ယာပယိတုမ် နာဘိလၐန် ဣဖိၐနဂရံ တျက္တွာ ယာတုံ မန္တြဏာံ သ္ထိရီကၖတဝါန်; ယသ္မာဒ် ယဒိ သာဓျံ ဘဝတိ တရှိ နိသ္တာရောတ္သဝသျ ပဉ္စာၑတ္တမဒိနေ သ ယိရူၑာလမျုပသ္ထာတုံ မတိံ ကၖတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","ပေါ်လော မိလီတာဒ် ဣဖိၐံ ပြတိ လောကံ ပြဟိတျ သမာဇသျ ပြာစီနာန် အာဟူယာနီတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","တေၐု တသျ သမီပမ် ဥပသ္ထိတေၐု သ တေဘျ ဣမာံ ကထာံ ကထိတဝါန်, အဟမ် အာၑိယာဒေၑေ ပြထမာဂမနမ် အာရဘျာဒျ ယာဝဒ် ယုၐ္မာကံ သန္နိဓော် သ္ထိတွာ သရွွသမယေ ယထာစရိတဝါန် တဒ် ယူယံ ဇာနီထ; ");
INSERT INTO sanbur_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ဖလတး သရွွထာ နမြမနား သန် ဗဟုၑြုပါတေန ယိဟုဒီယာနာမ် ကုမန္တြဏာဇာတနာနာပရီက္ၐာဘိး ပြဘေား သေဝါမကရဝံ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","ကာမပိ ဟိတကထာाံ န ဂေါပါယိတဝါန် တာံ ပြစာရျျ သပြကာၑံ ဂၖဟေ ဂၖဟေ သမုပဒိၑျေၑွရံ ပြတိ မနး ပရာဝရ္တ္တနီယံ ပြဘော် ယီၑုခြီၐ္ဋေ ဝိၑွသနီယံ ");
INSERT INTO sanbur_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","ယိဟူဒီယာနာမ် အနျဒေၑီယလောကာနာဉ္စ သမီပ ဧတာဒၖၑံ သာက္ၐျံ ဒဒါမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","ပၑျတ သာမ္ပြတမ် အာတ္မနာကၖၐ္ဋး သန် ယိရူၑာလမ္နဂရေ ယာတြာံ ကရောမိ, တတြ မာမ္ပြတိ ယဒျဒ် ဃဋိၐျတေ တာနျဟံ န ဇာနာမိ; ");
INSERT INTO sanbur_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","ကိန္တု မယာ ဗန္ဓနံ က္လေၑၑ္စ ဘောက္တဝျ ဣတိ ပဝိတြ အာတ္မာ နဂရေ နဂရေ ပြမာဏံ ဒဒါတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","တထာပိ တံ က္လေၑမဟံ တၖဏာယ န မနျေ; ဤၑွရသျာနုဂြဟဝိၐယကသျ သုသံဝါဒသျ ပြမာဏံ ဒါတုံ, ပြဘော ရျီၑေား သကာၑာဒ ယသျား သေဝါယား ဘာရံ ပြာပ္နဝံ တာံ သေဝါံ သာဓယိတုံ သာနန္ဒံ သွမာရ္ဂံ သမာပယိတုुဉ္စ နိဇပြာဏာနပိ ပြိယာန် န မနျေ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","အဓုနာ ပၑျတ ယေၐာံ သမီပေ'ဟမ် ဤၑွရီယရာဇျသျ သုသံဝါဒံ ပြစာရျျ ဘြမဏံ ကၖတဝါန် ဧတာဒၖၑာ ယူယံ မမ ဝဒနံ ပုန ရ္ဒြၐ္ဋုံ န ပြာပ္သျထ ဧတဒပျဟံ ဇာနာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","ယုၐ္မဘျမ် အဟမ် ဤၑွရသျ သရွွာန် အာဒေၑာန် ပြကာၑယိတုံ န နျဝရ္တ္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","အဟံ သရွွေၐာံ လောကာနာံ ရက္တပါတဒေါၐာဒ် ယန္နိရ္ဒောၐ အာသေ တသျာဒျ ယုၐ္မာန် သာက္ၐိဏး ကရောမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","ယူယံ သွေၐု တထာ ယသျ ဝြဇသျာဓျက္ၐန် အာတ္မာ ယုၐ္မာန် ဝိဓာယ နျယုင်္က္တ တတ္သရွွသ္မိန် သာဝဓာနာ ဘဝတ, ယ သမာဇဉ္စ ပြဘု ရ္နိဇရက္တမူလျေန ကြီတဝါန တမ် အဝတ, ");
INSERT INTO sanbur_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","ယတော မယာ ဂမနေ ကၖတဧဝ ဒုရ္ဇယာ ဝၖကာ ယုၐ္မာကံ မဓျံ ပြဝိၑျ ဝြဇံ ပြတိ နိရ္ဒယတာမ် အာစရိၐျန္တိ, ");
INSERT INTO sanbur_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","ယုၐ္မာကမေဝ မဓျာဒပိ လောကာ ဥတ္ထာယ ၑိၐျဂဏမ် အပဟန္တုံ ဝိပရီတမ် ဥပဒေက္ၐျန္တီတျဟံ ဇာနာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","ဣတိ ဟေတော ရျူယံ သစဲတနျား သန္တသ္တိၐ္ဋတ, အဟဉ္စ သာၑြုပါတး သန် ဝတ္သရတြယံ ယာဝဒ် ဒိဝါနိၑံ ပြတိဇနံ ဗောဓယိတုံ န နျဝရ္တ္တေ တဒပိ သ္မရတ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","ဣဒါနီံ ဟေ ဘြာတရော ယုၐ္မာကံ နိၐ္ဌာံ ဇနယိတုံ ပဝိတြီကၖတလောကာနာံ မဓျေ'ဓိကာရဉ္စ ဒါတုံ သမရ္ထော ယ ဤၑွရသ္တသျာနုဂြဟသျ ယော ဝါဒၑ္စ တယောရုဘယော ရျုၐ္မာန် သမာရ္ပယမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","ကသျာပိ သွရ္ဏံ ရူပျံ ဝသ္တြံ ဝါ ပြတိ မယာ လောဘော န ကၖတး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","ကိန္တု မမ မတ္သဟစရလောကာနာဉ္စာဝၑျကဝျယာယ မဒီယမိဒံ ကရဒွယမ် အၑြာမျဒ် ဧတဒ် ယူယံ ဇာနီထ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","အနေန ပြကာရေဏ ဂြဟဏဒ် ဒါနံ ဘဒြမိတိ ယဒွါကျံ ပြဘု ရျီၑုး ကထိတဝါန် တတ် သ္မရ္တ္တုံ ဒရိဒြလောကာနာမုပကာရာရ္ထံ ၑြမံ ကရ္တ္တုဉ္စ ယုၐ္မာကမ် ဥစိတမ် ဧတတ္သရွွံ ယုၐ္မာနဟမ် ဥပဒိၐ္ဋဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ဧတာံ ကထာံ ကထယိတွာ သ ဇာနုနီ ပါတယိတွာ သရွဲး သဟ ပြာရ္ထယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","တေန တေ ကြန္ဒြန္တး ");
INSERT INTO sanbur_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ပုန ရ္မမ မုခံ န ဒြက္ၐျထ ဝိၑေၐတ ဧၐာ ယာ ကထာ တေနာကထိ တတ္ကာရဏာတ် ၑောကံ ဝိလာပဉ္စ ကၖတွာ ကဏ္ဌံ ဓၖတွာ စုမ္ဗိတဝန္တး၊ ပၑ္စာတ် တေ တံ ပေါတံ နီတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","တဲ ရွိသၖၐ္ဋား သန္တော ဝယံ ပေါတံ ဗာဟယိတွာ ၒဇုမာရ္ဂေဏ ကောၐမ် ဥပဒွီပမ် အာဂတျ ပရေ'ဟနိ ရောဒိယောပဒွီပမ် အာဂစ္ဆာမ တတသ္တသ္မာတ် ပါတာရာယာမ် ဥပါတိၐ္ဌာမ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","တတြ ဖဲနီကိယာဒေၑဂါမိနမ် ပေါတမေကံ ပြာပျ တမာရုဟျ ဂတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","ကုပြောပဒွီပံ ဒၖၐ္ဋွာ တံ သဝျဒိၑိ သ္ထာပယိတွာ သုရိယာဒေၑံ ဂတွာ ပေါတသ္ထဒြဝျာဏျဝရောဟယိတုံ သောရနဂရေ လာဂိတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","တတြ ၑိၐျဂဏသျ သာက္ၐာတ္ကရဏာယ ဝယံ တတြ သပ္တဒိနာနိ သ္ထိတဝန္တး ပၑ္စာတ္တေ ပဝိတြေဏာတ္မနာ ပေါ်လံ ဝျာဟရန် တွံ ယိရူၑာလမ္နဂရံ မာ ဂမး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","တတသ္တေၐု သပ္တသု ဒိနေၐု ယာပိတေၐု သတ္သု ဝယံ တသ္မာတ် သ္ထာနာတ် နိဇဝရ္တ္မနာ ဂတဝန္တး, တသ္မာတ် တေ သဗာလဝၖဒ္ဓဝနိတာ အသ္မာဘိး သဟ နဂရသျ ပရိသရပရျျန္တမ် အာဂတား ပၑ္စာဒွယံ ဇလဓိတဋေ ဇာနုပါတံ ပြာရ္ထယာမဟိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","တတး ပရသ္ပရံ ဝိသၖၐ္ဋား သန္တော ဝယံ ပေါတံ ဂတာသ္တေ တု သွသွဂၖဟံ ပြတျာဂတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","ဝယံ သောရနဂရာတ် နာဝါ ပြသ္ထာယ တလိမာယိနဂရမ် ဥပါတိၐ္ဌာမ တတြာသ္မာကံ သမုဒြီယမာရ္ဂသျာန္တော'ဘဝတ် တတြ ဘြာတၖဂဏံ နမသ္ကၖတျ ဒိနမေကံ တဲး သာရ္ဒ္ဓမ် ဥၐတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","ပရေ 'ဟနိ ပေါ်လသ္တသျ သင်္ဂိနော ဝယဉ္စ ပြတိၐ္ဌမာနား ကဲသရိယာနဂရမ် အာဂတျ သုသံဝါဒပြစာရကာနာံ သပ္တဇနာနာံ ဖိလိပနာမ္န ဧကသျ ဂၖဟံ ပြဝိၑျာဝတိၐ္ဌာမ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","တသျ စတသြော ဒုဟိတရော'နူဎာ ဘဝိၐျဒွါဒိနျ အာသန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","တတြာသ္မာသု ဗဟုဒိနာနိ ပြောၐိတေၐု ယိဟူဒီယဒေၑာဒ် အာဂတျာဂါဗနာမာ ဘဝိၐျဒွါဒီ သမုပသ္ထိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","သောသ္မာကံ သမီပမေတျ ပေါ်လသျ ကဋိဗန္ဓနံ ဂၖဟီတွာ နိဇဟသ္တာပါဒါန် ဗဒ္ဓွာ ဘာၐိတဝါန် ယသျေဒံ ကဋိဗန္ဓနံ တံ ယိဟူဒီယလောကာ ယိရူၑာလမနဂရ ဣတ္ထံ ဗဒ္ဓွာ ဘိန္နဒေၑီယာနာံ ကရေၐု သမရ္ပယိၐျန္တီတိ ဝါကျံ ပဝိတြ အာတ္မာ ကထယတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ဧတာဒၖၑီံ ကထာံ ၑြုတွာ ဝယံ တန္နဂရဝါသိနော ဘြာတရၑ္စ ယိရူၑာလမံ န ယာတုံ ပေါ်လံ ဝျနယာမဟိ; ");
INSERT INTO sanbur_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","ကိန္တု သ ပြတျာဝါဒီတ်, ယူယံ ကိံ ကုရုထ? ကိံ ကြန္ဒနေန မမာန္တးကရဏံ ဝိဒီရ္ဏံ ကရိၐျထ? ပြဘော ရျီၑော ရ္နာမ္နော နိမိတ္တံ ယိရူၑာလမိ ဗဒ္ဓေါ ဘဝိတုံ ကေဝလ တန္န ပြာဏာန် ဒါတုမပိ သသဇ္ဇောသ္မိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","တေနာသ္မာကံ ကထာယာမ် အဂၖဟီတာယာမ် ဤၑွရသျ ယထေစ္ဆာ တထဲဝ ဘဝတွိတျုက္တွာ ဝယံ နိရသျာမ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","ပရေ'ဟနိ ပါထေယဒြဝျာဏိ ဂၖဟီတွာ ယိရူၑာလမံ ပြတိ ယာတြာမ် အကုရ္မ္မ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","တတး ကဲသရိယာနဂရနိဝါသိနး ကတိပယား ၑိၐျာ အသ္မာဘိး သာရ္ဒ္ဓမ် ဣတွာ ကၖပြီယေန မ္နာသန္နာမ္နာ ယေန ပြာစီနၑိၐျေန သာရ္ဒ္ဓမ် အသ္မာဘိ ရွသ္တဝျံ တသျ သမီပမ် အသ္မာန် နီတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","အသ္မာသု ယိရူၑာလမျုပသ္ထိတေၐု တတြသ္ထဘြာတၖဂဏော'သ္မာန် အာဟ္လာဒေန ဂၖဟီတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","ပရသ္မိန် ဒိဝသေ ပေါ်လေ'သ္မာဘိး သဟ ယာကူဗော ဂၖဟံ ပြဝိၐ္ဋေ လောကပြာစီနား သရွွေ တတြ ပရိၐဒိ သံသ္ထိတား၊ ");
INSERT INTO sanbur_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","အနန္တရံ သ တာန် နတွာ သွီယပြစာရဏေန ဘိန္နဒေၑီယာန် ပြတီၑွရော ယာနိ ကရ္မ္မာဏိ သာဓိတဝါန် တဒီယာံ ကထာမ် အနုကြမာတ် ကထိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ဣတိ ၑြုတွာ တေ ပြဘုံ ဓနျံ ပြောစျ ဝါကျမိဒမ် အဘာၐန္တ, ဟေ ဘြာတ ရျိဟူဒီယာနာံ မဓျေ ဗဟုသဟသြာဏိ လောကာ ဝိၑွာသိန အာသတေ ကိန္တု တေ သရွွေ ဝျဝသ္ထာမတာစာရိဏ ဧတတ် ပြတျက္ၐံ ပၑျသိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","ၑိၑူနာံ တွက္ဆေဒနာဒျာစရဏံ ပြတိၐိဓျ တွံ ဘိန္နဒေၑနိဝါသိနော ယိဟူဒီယလောကာန် မူသာဝါကျမ် အၑြဒ္ဓါတုမ် ဥပဒိၑသီတိ တဲး ၑြုတမသ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","တွမတြာဂတောသီတိ ဝါရ္တ္တာံ သမာကရ္ဏျ ဇနနိဝဟော မိလိတွာဝၑျမေဝါဂမိၐျတိ; အတဧဝ ကိံ ကရဏီယမ်? အတြ ဝယံ မန္တြယိတွာ သမုပါယံ တွာံ ဝဒါမသ္တံ တွမာစရ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","ဝြတံ ကရ္တ္တုံ ကၖတသင်္ကလ္ပာ ယေ'သ္မာံက စတွာရော မာနဝါး သန္တိ ");
INSERT INTO sanbur_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","တာန် ဂၖဟီတွာ တဲး သဟိတး သွံ ၑုစိံ ကုရု တထာ တေၐာံ ၑိရောမုဏ္ဍနေ ယော ဝျယော ဘဝတိ တံ တွံ ဒေဟိ၊ တထာ ကၖတေ တွဒီယာစာရေ ယာ ဇနၑြုတိ ရ္ဇာယတေ သာလီကာ ကိန္တု တွံ ဝိဓိံ ပါလယန် ဝျဝသ္ထာနုသာရေဏေဝါစရသီတိ တေ ဘောတ္သန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","ဘိန္နဒေၑီယာနာံ ဝိၑွာသိလောကာနာံ နိကဋေ ဝယံ ပတြံ လိခိတွေတ္ထံ သ္ထိရီကၖတဝန္တး, ဒေဝပြသာဒဘောဇနံ ရက္တံ ဂလပီဍနမာရိတပြာဏိဘောဇနံ ဝျဘိစာရၑ္စဲတေဘျး သွရက္ၐဏဝျတိရေကေဏ တေၐာမနျဝိဓိပါလနံ ကရဏီယံ န၊ ");
INSERT INTO sanbur_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","တတး ပေါ်လသ္တာန် မာနုၐာနာဒါယ ပရသ္မိန် ဒိဝသေ တဲး သဟ ၑုစိ ရ္ဘူတွာ မန္ဒိရံ ဂတွာ ၑော်စကရ္မ္မဏော ဒိနေၐု သမ္ပူရ္ဏေၐု တေၐာမ် ဧကဲကာရ္ထံ နဲဝေဒျာဒျုတ္သရ္ဂော ဘဝိၐျတီတိ ဇ္ဉာပိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","တေၐု သပ္တသု ဒိနေၐု သမာပ္တကလ္ပေၐု အာၑိယာဒေၑနိဝါသိနော ယိဟူဒီယာသ္တံ မဓျေမန္ဒိရံ ဝိလောကျ ဇနနိဝဟသျ မနးသု ကုပြဝၖတ္တိံ ဇနယိတွာ တံ ဓၖတွာ ");
INSERT INTO sanbur_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ပြောစ္စဲး ပြာဝေါစန်, ဟေ ဣသြာယေလ္လောကား သရွွေ သာဟာယျံ ကုရုတ၊ ယော မနုဇ ဧတေၐာံ လောကာနာံ မူသာဝျဝသ္ထာယာ ဧတသျ သ္ထာနသျာပိ ဝိပရီတံ သရွွတြ သရွွာန် ၑိက္ၐယတိ သ ဧၐး; ဝိၑေၐတး သ ဘိန္နဒေၑီယလောကာန် မန္ဒိရမ် အာနီယ ပဝိတြသ္ထာနမေတဒ် အပဝိတြမကရောတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","ပူရွွံ တေ မဓျေနဂရမ် ဣဖိၐနဂရီယံ တြဖိမံ ပေါ်လေန သဟိတံ ဒၖၐ္ဋဝန္တ ဧတသ္မာတ် ပေါ်လသ္တံ မန္ဒိရမဓျမ် အာနယဒ် ဣတျနွမိမတ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","အတဧဝ သရွွသ္မိန် နဂရေ ကလဟောတ္ပန္နတွာတ် ဓာဝန္တော လောကာ အာဂတျ ပေါ်လံ ဓၖတွာ မန္ဒိရသျ ဗဟိရာကၖၐျာနယန် တတ္က္ၐဏာဒ် ဒွါရာဏိ သရွွာဏိ စ ရုဒ္ဓါနိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","တေၐု တံ ဟန္တုမုဒျတေेၐု ယိရူၑာလမ္နဂရေ မဟာနုပဒြဝေါ ဇာတ ဣတိ ဝါရ္တ္တာယာံ သဟသြသေနာပတေး ကရ္ဏဂေါစရီဘူတာယာံ သတျာံ သ တတ္က္ၐဏာတ် သဲနျာနိ သေနာပတိဂဏဉ္စ ဂၖဟီတွာ ဇဝေနာဂတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","တတော လောကား သေနာဂဏေန သဟ သဟသြသေနာပတိမ် အာဂစ္ဆန္တံ ဒၖၐ္ဋွာ ပေါ်လတာဍနာတော နျဝရ္တ္တန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","သ သဟသြသေနာပတိး သန္နိဓာဝါဂမျ ပေါ်လံ ဓၖတွာ ၑၖင်္ခလဒွယေန ဗဒ္ဓမ် အာဒိၑျ တာန် ပၖၐ္ဋဝါန် ဧၐ ကး? ကိံ ကရ္မ္မ စာယံ ကၖတဝါန်? ");
INSERT INTO sanbur_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","တတော ဇနသမူဟသျ ကၑ္စိဒ် ဧကပြကာရံ ကၑ္စိဒ် အနျပြကာရံ ဝါကျမ် အရော်တ် သ တတြ သတျံ ဇ္ဉာတုမ် ကလဟကာရဏာဒ် အၑက္တး သန် တံ ဒုရ္ဂံ နေတုမ် အာဇ္ဉာပယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","တေၐု သောပါနသျောပရိ ပြာပ္တေၐု လောကာနာံ သာဟသကာရဏာတ် သေနာဂဏး ပေါ်လမုတ္တောလျ နီတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","တတး သရွွေ လောကား ပၑ္စာဒ္ဂါမိနး သန္တ ဧနံ ဒုရီကုရုတေတိ ဝါကျမ် ဥစ္စဲရဝဒန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","ပေါ်လသျ ဒုရ္ဂာနယနသမယေ သ တသ္မဲ သဟသြသေနာပတယေ ကထိတဝါန်, ဘဝတး ပုရသ္တာတ် ကထာံ ကထယိတုံ ကိမ် အနုမနျတေ? သ တမပၖစ္ဆတ် တွံ ကိံ ယူနာနီယာံ ဘာၐာံ ဇာနာသိ? ");
INSERT INTO sanbur_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","ယော မိသရီယော ဇနး ပူရွွံ ဝိရောဓံ ကၖတွာ စတွာရိ သဟသြာဏိ ဃာတကာန် သင်္ဂိနး ကၖတွာ ဝိပိနံ ဂတဝါန် တွံ ကိံ သဧဝ န ဘဝသိ? ");
INSERT INTO sanbur_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","တဒါ ပေါ်လော'ကထယတ် အဟံ ကိလိကိယာဒေၑသျ တာရ္ၐနဂရီယော ယိဟူဒီယော, နာဟံ သာမာနျနဂရီယော မာနဝး; အတဧဝ ဝိနယေ'ဟံ လာကာနာံ သမက္ၐံ ကထာံ ကထယိတုံ မာမနုဇာနီၐွ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","တေနာနုဇ္ဉာတး ပေါ်လး သောပါနောပရိ တိၐ္ဌန် ဟသ္တေနေင်္ဂိတံ ကၖတဝါန်, တသ္မာတ် သရွွေ သုသ္ထိရာ အဘဝန်၊ တဒါ ပေါ်လ ဣဗြီယဘာၐယာ ကထယိတုမ် အာရဘတ, ");
INSERT INTO sanbur_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","ဟေ ပိတၖဂဏာ ဟေ ဘြာတၖဂဏား, ဣဒါနီံ မမ နိဝေဒနေ သမဝဓတ္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","တဒါ သ ဣဗြီယဘာၐယာ ကထာံ ကထယတီတိ ၑြုတွာ သရွွေ လောကာ အတီဝ နိးၑဗ္ဒာ သန္တော'တိၐ္ဌန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","ပၑ္စာတ် သော'ကထယဒ် အဟံ ယိဟူဒီယ ဣတိ နိၑ္စယး ကိလိကိယာဒေၑသျ တာရ္ၐနဂရံ မမ ဇန္မဘူမိး,ဧတန္နဂရီယသျ ဂမိလီယေလနာမ္နော'ဓျာပကသျ ၑိၐျော ဘူတွာ ပူရွွပုရုၐာဏာံ ဝိဓိဝျဝသ္ထာနုသာရေဏ သမ္ပူရ္ဏရူပေဏ ၑိက္ၐိတော'ဘဝမ် ဣဒါနီန္တနာ ယူယံ ယာဒၖၑာ ဘဝထ တာဒၖၑော'ဟမပီၑွရသေဝါယာမ် ဥဒျောဂီ ဇာတး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","မတမေတဒ် ဒွိၐ္ဋွာ တဒ္ဂြာဟိနာရီပုရုၐာန် ကာရာယာံ ဗဒ္ဓွာ တေၐာံ ပြာဏနာၑပရျျန္တာံ ဝိပက္ၐတာမ် အကရဝမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","မဟာယာဇကး သဘာသဒး ပြာစီနလောကာၑ္စ မမဲတသျား ကထာယား ပြမာဏံ ဒါတုံ ၑက္နုဝန္တိ, ယသ္မာတ် တေၐာံ သမီပါဒ် ဒမ္မေၐကနဂရနိဝါသိဘြာတၖဂဏာရ္ထမ် အာဇ္ဉာပတြာဏိ ဂၖဟီတွာ ယေ တတြ သ္ထိတာသ္တာန် ဒဏ္ဍယိတုံ ယိရူၑာလမမ် အာနယနာရ္ထံ ဒမ္မေၐကနဂရံ ဂတောသ္မိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","ကိန္တု ဂစ္ဆန် တန္နဂရသျ သမီပံ ပြာပ္တဝါန် တဒါ ဒွိတီယပြဟရဝေလာယာံ သတျာမ် အကသ္မာဒ် ဂဂဏာန္နိရ္ဂတျ မဟတီ ဒီပ္တိ ရ္မမ စတုရ္ဒိၑိ ပြကာၑိတဝတီ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","တတော မယိ ဘူမော်ै ပတိတေ သတိ, ဟေ ၑော်လ ဟေ ၑော်လ ကုတော မာံ တာဍယသိ? မာမ္ပြတိ ဘာၐိတ ဧတာဒၖၑ ဧကော ရဝေါပိ မယာ ၑြုတး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","တဒါဟံ ပြတျဝဒံ, ဟေ ပြဘေ ကော ဘဝါန်? တတး သော'ဝါဒီတ် ယံ တွံ တာဍယသိ သ နာသရတီယော ယီၑုရဟံ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","မမ သင်္ဂိနော လောကာသ္တာံ ဒီပ္တိံ ဒၖၐ္ဋွာ ဘိယံ ပြာပ္တား, ကိန္တု မာမ္ပြတျုဒိတံ တဒွါကျံ တေे နာဗုဓျန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","တတး ပရံ ပၖၐ္ဋဝါနဟံ, ဟေ ပြဘော မယာ ကိံ ကရ္တ္တဝျံ? တတး ပြဘုရကထယတ်, ဥတ္ထာယ ဒမ္မေၐကနဂရံ ယာဟိ တွယာ ယဒျတ် ကရ္တ္တဝျံ နိရူပိတမာသ္တေ တတ် တတြ တွံ ဇ္ဉာပယိၐျသေ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","အနန္တရံ တသျား ခရတရဒီပ္တေး ကာရဏာတ် ကိမပိ န ဒၖၐ္ဋွာ သင်္ဂိဂဏေန ဓၖတဟသ္တး သန် ဒမ္မေၐကနဂရံ ဝြဇိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","တန္နဂရနိဝါသိနာံ သရွွေၐာံ ယိဟူဒီယာနာံ မာနျော ဝျဝသ္ထာနုသာရေဏ ဘက္တၑ္စ ဟနာနီယနာမာ မာနဝ ဧကော ");
INSERT INTO sanbur_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","မမ သန္နိဓိမ် ဧတျ တိၐ္ဌန် အကထယတ်, ဟေ ဘြာတး ၑော်လ သုဒၖၐ္ဋိ ရ္ဘဝ တသ္မိန် ဒဏ္ဍေ'ဟံ သမျက် တံ ဒၖၐ္ဋဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","တတး သ မဟျံ ကထိတဝါန် ယထာ တွမ် ဤၑွရသျာဘိပြာယံ ဝေတ္သိ တသျ ၑုဒ္ဓသတ္တွဇနသျ ဒရ္ၑနံ ပြာပျ တသျ ၑြီမုခသျ ဝါကျံ ၑၖဏောၐိ တန္နိမိတ္တမ် အသ္မာကံ ပူရွွပုရုၐာဏာမ် ဤၑွရသ္တွာံ မနောနီတံ ကၖတဝါနံ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","ယတော ယဒျဒ် အဒြာက္ၐီရၑြော်ၐီၑ္စ သရွွေၐာံ မာနဝါနာံ သမီပေ တွံ တေၐာံ သာက္ၐီ ဘဝိၐျသိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","အတဧဝ ကုတော ဝိလမ္ဗသေ? ပြဘော ရ္နာမ္နာ ပြာရ္ထျ နိဇပါပပြက္ၐာလနာရ္ထံ မဇ္ဇနာယ သမုတ္တိၐ္ဌ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","တတး ပရံ ယိရူၑာလမ္နဂရံ ပြတျာဂတျ မန္ဒိရေ'ဟမ် ဧကဒါ ပြာရ္ထယေ, တသ္မိန် သမယေ'ဟမ် အဘိဘူတး သန် ပြဘူံ သာက္ၐာတ် ပၑျန်, ");
INSERT INTO sanbur_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","တွံ တွရယာ ယိရူၑာလမး ပြတိၐ္ဌသွ ယတော လောကာမယိ တဝ သာက္ၐျံ န ဂြဟီၐျန္တိ, မာမ္ပြတျုဒိတံ တသျေဒံ ဝါကျမ် အၑြော်ၐမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","တတောဟံ ပြတျဝါဒိၐမ် ဟေ ပြဘော ပြတိဘဇနဘဝနံ တွယိ ဝိၑွာသိနော လောကာန် ဗဒ္ဓွာ ပြဟၖတဝါန်, ");
INSERT INTO sanbur_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","တထာ တဝ သာက္ၐိဏး သ္တိဖာနသျ ရက္တပါတနသမယေ တသျ ဝိနာၑံ သမ္မနျ သန္နိဓော် တိၐ္ဌန် ဟန္တၖလောကာနာံ ဝါသာံသိ ရက္ၐိတဝါန်, ဧတတ် တေ ဝိဒုး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","တတး သော'ကထယတ် ပြတိၐ္ဌသွ တွာံ ဒူရသ္ထဘိန္နဒေၑီယာနာံ သမီပံ ပြေၐယိၐျေ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","တဒါ လောကာ ဧတာဝတ္ပရျျန္တာံ တဒီယာံ ကထာံ ၑြုတွာ ပြောစ္စဲရကထယန်, ဧနံ ဘူမဏ္ဍလာဒ် ဒူရီကုရုတ, ဧတာဒၖၑဇနသျ ဇီဝနံ နောစိတမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ဣတျုစ္စဲး ကထယိတွာ ဝသနာနိ ပရိတျဇျ ဂဂဏံ ပြတိ ဓူလီရက္ၐိပန္ ");
INSERT INTO sanbur_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","တတး သဟသြသေနာပတိး ပေါ်လံ ဒုရ္ဂာဘျန္တရ နေတုံ သမာဒိၑတ်၊ ဧတသျ ပြတိကူလား သန္တော လောကား ကိန္နိမိတ္တမ် ဧတာဝဒုစ္စဲးသွရမ် အကုရွွန်, ဧတဒ် ဝေတ္တုံ တံ ကၑယာ ပြဟၖတျ တသျ ပရီက္ၐာံ ကရ္တ္တုမာဒိၑတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","ပဒါတယၑ္စရ္မ္မနိရ္မ္မိတရဇ္ဇုဘိသ္တသျ ဗန္ဓနံ ကရ္တ္တုမုဒျတာသ္တာသ္တဒါနီံ ပေါ်လး သမ္မုခသ္ထိတံ ၑတသေနာပတိမ် ဥက္တဝါန် ဒဏ္ဍာဇ္ဉာယာမ် အပြာပ္တာယာံ ကိံ ရောမိလောကံ ပြဟရ္တ္တုံ ယုၐ္မာကမ် အဓိကာရောသ္တိ? ");
INSERT INTO sanbur_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","ဧနာံ ကထာံ ၑြုတွာ သ သဟသြသေနာပတေး သန္နိဓိံ ဂတွာ တာံ ဝါရ္တ္တာမဝဒတ် သ ရောမိလောက ဧတသ္မာတ် သာဝဓာနး သန် ကရ္မ္မ ကုရု၊ ");
INSERT INTO sanbur_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","တသ္မာတ် သဟသြသေနာပတိ ရ္ဂတွာ တမပြာက္ၐီတ် တွံ ကိံ ရောမိလောကး? ဣတိ မာံ ဗြူဟိ၊ သော'ကထယတ် သတျမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","တတး သဟသြသေနာပတိး ကထိတဝါန် ဗဟုဒြဝိဏံ ဒတ္တွာဟံ တတ် ပေါ်ရသချံ ပြာပ္တဝါန်; ကိန္တု ပေါ်လး ကထိတဝါန် အဟံ ဇနုနာ တတ် ပြာပ္တော'သ္မိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","ဣတ္ထံ သတိ ယေ ပြဟာရေဏ တံ ပရီက္ၐိတုံ သမုဒျတာ အာသန် တေ တသျ သမီပါတ် ပြာတိၐ္ဌန္တ; သဟသြသေနာပတိသ္တံ ရောမိလောကံ ဝိဇ္ဉာယ သွယံ ယတ် တသျ ဗန္ဓနမ် အကာရ္ၐီတ် တတ္ကာရဏာဒ် အဗိဘေတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","ယိဟူဒီယလောကား ပေါ်လံ ကုတော'ပဝဒန္တေ တသျ ဝၖတ္တာန္တံ ဇ္ဉာတုံ ဝါဉ္ဆန် သဟသြသေနာပတိး ပရေ'ဟနိ ပေါ်လံ ဗန္ဓနာတ် မောစယိတွာ ပြဓာနယာဇကာန် မဟာသဘာယား သရွွလောကာၑ္စ သမုပသ္ထာတုမ် အာဒိၑျ တေၐာံ သန္နိဓော် ပေါ်လမ် အဝရောဟျ သ္ထာပိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","သဘာသဒ္လေါကာန် ပြတိ ပေါ်လော'နနျဒၖၐ္ဋျာ ပၑျန် အကထယတ်, ဟေ ဘြာတၖဂဏာ အဒျ ယာဝတ် သရလေန သရွွာန္တးကရဏေနေၑွရသျ သာက္ၐာဒ် အာစရာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","အနေန ဟနာနီယနာမာ မဟာယာဇကသ္တံ ကပေါလေ စပေဋေနာဟန္တုံ သမီပသ္ထလောကာန် အာဒိၐ္ဋဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","တဒါ ပေါ်လသ္တမဝဒတ်, ဟေ ဗဟိၐ္ပရိၐ္ကၖတ, ဤၑွရသ္တွာံ ပြဟရ္တ္တုမ် ဥဒျတောသ္တိ, ယတော ဝျဝသ္ထာနုသာရေဏ ဝိစာရယိတုမ် ဥပဝိၑျ ဝျဝသ္ထာံ လင်္ဃိတွာ မာံ ပြဟရ္တ္တုမ် အာဇ္ဉာပယသိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","တတော နိကဋသ္ထာ လောကာ အကထယန်, တွံ ကိမ် ဤၑွရသျ မဟာယာဇကံ နိန္ဒသိ? ");
INSERT INTO sanbur_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","တတး ပေါ်လး ပြတိဘာၐိတဝါန် ဟေ ဘြာတၖဂဏ မဟာယာဇက ဧၐ ဣတိ န ဗုဒ္ဓံ မယာ တဒနျစ္စ သွလောကာနာမ် အဓိပတိံ ပြတိ ဒုရွွာကျံ မာ ကထယ, ဧတာဒၖၑီ လိပိရသ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","အနန္တရံ ပေါ်လသ္တေၐာမ် အရ္ဒ္ဓံ သိဒူကိလောကာ အရ္ဒ္ဓံ ဖိရူၑိလောကာ ဣတိ ဒၖၐ္ဋွာ ပြောစ္စဲး သဘာသ္ထလောကာန် အဝဒတ် ဟေ ဘြာတၖဂဏ အဟံ ဖိရူၑိမတာဝလမ္ဗီ ဖိရူၑိနး သတ္နာနၑ္စ, မၖတလောကာနာမ် ဥတ္ထာနေ ပြတျာၑာကရဏာဒ် အဟမပဝါဒိတောသ္မိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","ဣတိ ကထာယာံ ကထိတာယာံ ဖိရူၑိသိဒူကိနေား ပရသ္ပရံ ဘိန္နဝါကျတွာတ် သဘာယာ မဓျေ ဒွေါ် သံဃော် ဇာတော်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","ယတး သိဒူကိလောကာ ဥတ္ထာနံ သွရ္ဂီယဒူတာ အာတ္မာနၑ္စ သရွွေၐာမ် ဧတေၐာံ ကမပိ န မနျန္တေ, ကိန္တု ဖိရူၑိနး သရွွမ် အင်္ဂီကုရွွန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","တတး ပရသ္ပရမ် အတိၑယကောလာဟလေ သမုပသ္ထိတေ ဖိရူၑိနာံ ပက္ၐီယား သဘာသ္ထာ အဓျာပကား ပြတိပက္ၐာ ဥတ္တိၐ္ဌန္တော 'ကထယန်, ဧတသျ မာနဝသျ ကမပိ ဒေါၐံ န ပၑျာမး; ယဒိ ကၑ္စိဒ် အာတ္မာ ဝါ ကၑ္စိဒ် ဒူတ ဧနံ ပြတျာဒိၑတ် တရှိ ဝယမ် ဤၑွရသျ ပြာတိကူလျေန န ယောတ္သျာမး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","တသ္မာဒ် အတီဝ ဘိန္နဝါကျတွေ သတိ တေ ပေါ်လံ ခဏ္ဍံ ခဏ္ဍံ ကရိၐျန္တီတျာၑင်္ကယာ သဟသြသေနာပတိး သေနာဂဏံ တတ္သ္ထာနံ ယာတုံ သဘာတော ဗလာတ် ပေါ်လံ ဓၖတွာ ဒုရ္ဂံ နေတဉ္စာဇ္ဉာပယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","ရာတြော ပြဘုသ္တသျ သမီပေ တိၐ္ဌန် ကထိတဝါန် ဟေ ပေါ်လ နိရ္ဘယော ဘဝ ယထာ ယိရူၑာလမ္နဂရေ မယိ သာက္ၐျံ ဒတ္တဝါန် တထာ ရောမာနဂရေပိ တွယာ ဒါတဝျမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","ဒိနေ သမုပသ္ထိတေ သတိ ကိယန္တော ယိဟူဒီယလောကာ ဧကမန္တြဏား သန္တး ပေါ်လံ န ဟတွာ ဘောဇနပါနေ ကရိၐျာမ ဣတိ ၑပထေန သွာန် အဗဓ္နန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","စတွာရိံၑဇ္ဇနေဘျော'ဓိကာ လောကာ ဣတိ ပဏမ် အကုရွွန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","တေ မဟာယာဇကာနာံ ပြာစီနလောကာနာဉ္စ သမီပံ ဂတွာ ကထယန်, ဝယံ ပေါ်လံ န ဟတွာ ကိမပိ န ဘောက္ၐျာမဟေ ဒၖဎေနာနေန ၑပထေန ဗဒ္ဓွာ အဘဝါမ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","အတဧဝ သာမ္ပြတံ သဘာသဒ္လေါကဲး သဟ ဝယံ တသ္မိန် ကဉ္စိဒ် ဝိၑေၐဝိစာရံ ကရိၐျာမသ္တဒရ္ထံ ဘဝါန် ၑွော 'သ္မာကံ သမီပံ တမ် အာနယတွိတိ သဟသြသေနာပတယေ နိဝေဒနံ ကုရုတ တေန ယုၐ္မာကံ သမီပံ ဥပသ္ထိတေး ပူရွွံ ဝယံ တံ ဟန္တု သဇ္ဇိၐျာမ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","တဒါ ပေါ်လသျ ဘာဂိနေယသ္တေၐာမိတိ မန္တြဏာံ ဝိဇ္ဉာယ ဒုရ္ဂံ ဂတွာ တာံ ဝါရ္တ္တာံ ပေါ်လမ် ဥက္တဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","တသ္မာတ် ပေါ်လ ဧကံ ၑတသေနာပတိမ် အာဟူယ ဝါကျမိဒမ် ဘာၐိတဝါန် သဟသြသေနာပတေး သမီပေ'သျ ယုဝမနုၐျသျ ကိဉ္စိန္နိဝေဒနမ် အာသ္တေ, တသ္မာတ် တတ္သဝိဓမ် ဧနံ နယ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","တတး သ တမာဒါယ သဟသြသေနာပတေး သမီပမ် ဥပသ္ထာယ ကထိတဝါန်, ဘဝတး သမီပေ'သျ ကိမပိ နိဝေဒနမာသ္တေ တသ္မာတ် ဗန္ဒိး ပေါ်လော မာမာဟူယ ဘဝတး သမီပမ် ဧနမ် အာနေတုံ ပြာရ္ထိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","တဒါ သဟသြသေနာပတိသ္တသျ ဟသ္တံ ဓၖတွာ နိရ္ဇနသ္ထာနံ နီတွာ ပၖၐ္ဌဝါန် တဝ ကိံ နိဝေဒနံ? တတ် ကထယ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","တတး သောကထယတ်, ယိဟူဒီယလာကား ပေါ်လေ ကမပိ ဝိၑေၐဝိစာရံ ဆလံ ကၖတွာ တံ သဘာံ နေတုံ ဘဝတး သမီပေ နိဝေဒယိတုံ အမန္တြယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","ကိန္တု မဝတာ တန္န သွီကရ္တ္တဝျံ ယတသ္တေၐာံ မဓျေဝရ္တ္တိနၑ္စတွာရိံၑဇ္ဇနေဘျော 'ဓိကလောကာ ဧကမန္တြဏာ ဘူတွာ ပေါ်လံ န ဟတွာ ဘောဇနံ ပါနဉ္စ န ကရိၐျာမ ဣတိ ၑပထေန ဗဒ္ဓါး သန္တော ဃာတကာ ဣဝ သဇ္ဇိတာ ဣဒါနီံ ကေဝလံ ဘဝတော 'နုမတိမ် အပေက္ၐန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","ယာမိမာံ ကထာံ တွံ နိဝေဒိတဝါန် တာံ ကသ္မဲစိဒပိ မာ ကထယေတျုက္တွာ သဟသြသေနာပတိသ္တံ ယုဝါနံ ဝိသၖၐ္ဋဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","အနန္တရံ သဟသြသေနာပတိ ရ္ဒွေါ် ၑတသေနာပတီ အာဟူယေဒမ် အာဒိၑတ်, ယုဝါံ ရာတြော် ပြဟရဲကာဝၑိၐ္ဋာယာံ သတျာံ ကဲသရိယာနဂရံ ယာတုံ ပဒါတိသဲနျာနာံ ဒွေ ၑတေ ဃောဋကာရောဟိသဲနျာနာံ သပ္တတိံ ၑက္တိဓာရိသဲနျာနာံ ဒွေ ၑတေ စ ဇနာန် သဇ္ဇိတာန် ကုရုတံ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","ပေါ်လမ် အာရောဟယိတုံ ဖီလိက္ၐာဓိပတေး သမီပံ နိရွွိဃ္နံ နေတုဉ္စ ဝါဟနာနိ သမုပသ္ထာပယတံ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","အပရံ သ ပတြံ လိခိတွာ ဒတ္တဝါန် တလ္လိခိတမေတတ်, ");
INSERT INTO sanbur_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","မဟာမဟိမၑြီယုက္တဖီလိက္ၐာဓိပတယေ က္လော်ဒိယလုၐိယသျ နမသ္ကာရး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","ယိဟူဒီယလောကား ပူရွွမ် ဧနံ မာနဝံ ဓၖတွာ သွဟသ္တဲ ရှန္တုမ် ဥဒျတာ ဧတသ္မိန္နန္တရေ သသဲနျောဟံ တတြောပသ္ထာယ ဧၐ ဇနော ရောမီယ ဣတိ ဝိဇ္ဉာယ တံ ရက္ၐိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","ကိန္နိမိတ္တံ တေ တမပဝဒန္တေ တဇ္ဇ္ဉာတုံ တေၐာ သဘာံ တမာနာယိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","တတသ္တေၐာံ ဝျဝသ္ထာယာ ဝိရုဒ္ဓယာ ကယာစန ကထယာ သော'ပဝါဒိတော'ဘဝတ်, ကိန္တု သ ၑၖင်္ခလဗန္ဓနာရှော ဝါ ပြာဏနာၑာရှော ဘဝတီဒၖၑး ကောပျပရာဓော မယာသျ န ဒၖၐ္ဋး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","တထာပိ မနုၐျသျာသျ ဝဓာရ္ထံ ယိဟူဒီယာ ဃာတကာဣဝ သဇ္ဇိတာ ဧတာံ ဝါရ္တ္တာံ ၑြုတွာ တတ္က္ၐဏာတ် တဝ သမီပမေနံ ပြေၐိတဝါန် အသျာပဝါဒကာံၑ္စ တဝ သမီပံ ဂတွာပဝဒိတုမ် အာဇ္ဉာပယမ်၊ ဘဝတး ကုၑလံ ဘူယာတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","သဲနျဂဏ အာဇ္ဉာနုသာရေဏ ပေါ်လံ ဂၖဟီတွာ တသျာံ ရဇနျာမ် အာန္တိပါတြိနဂရမ် အာနယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","ပရေ'ဟနိ တေန သဟ ယာတုံ ဃောဋကာရူဎသဲနျဂဏံ သ္ထာပယိတွာ ပရာဝၖတျ ဒုရ္ဂံ ဂတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","တတး ပရေ ဃောဋကာရောဟိသဲနျဂဏး ကဲသရိယာနဂရမ် ဥပသ္ထာယ တတ္ပတြမ် အဓိပတေး ကရေ သမရ္ပျ တသျ သမီပေ ပေါ်လမ် ဥပသ္ထာပိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","တဒါဓိပတိသ္တတ္ပတြံ ပဌိတွာ ပၖၐ္ဌဝါန် ဧၐ ကိမ္ပြဒေၑီယော ဇနး? သ ကိလိကိယာပြဒေၑီယ ဧကော ဇန ဣတိ ဇ္ဉာတွာ ကထိတဝါန်, ");
INSERT INTO sanbur_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","တဝါပဝါဒကဂဏ အာဂတေ တဝ ကထာံ ၑြောၐျာမိ၊ ဟေရောဒြာဇဂၖဟေ တံ သ္ထာပယိတုမ် အာဒိၐ္ဋဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","ပဉ္စဘျော ဒိနေဘျး ပရံ ဟနာနီယနာမာ မဟာယာဇကော'ဓိပတေး သမက္ၐံ ပေါ်လသျ ပြာတိကူလျေန နိဝေဒယိတုံ တရ္တုလ္လနာမာနံ ကဉ္စန ဝက္တာရံ ပြာစီနဇနာံၑ္စ သင်္ဂိနး ကၖတွာ ကဲသရိယာနဂရမ် အာဂစ္ဆတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","တတး ပေါ်လေ သမာနီတေ သတိ တရ္တုလ္လသ္တသျာပဝါဒကထာံ ကထယိတုမ် အာရဘတ ဟေ မဟာမဟိမဖီလိက္ၐ ဘဝတော ဝယမ် အတိနိရွွိဃ္နံ ကာလံ ယာပယာမော ဘဝတး ပရိဏာမဒရ္ၑိတယာ ဧတဒ္ဒေၑီယာနာံ ဗဟူနိ မင်္ဂလာနိ ဃဋိတာနိ, ");
INSERT INTO sanbur_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","ဣတိ ဟေတော ရွယမတိကၖတဇ္ဉား သန္တး သရွွတြ သရွွဒါ ဘဝတော ဂုဏာန် ဂါယမး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","ကိန္တု ဗဟုဘိး ကထာဘိ ရ္ဘဝန္တံ ယေန န ဝိရဉ္ဇယာမိ တသ္မာဒ် ဝိနယေ ဘဝါန် ဗနုကမ္ပျ မဒလ္ပကထာံ ၑၖဏောတု၊ ");
INSERT INTO sanbur_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","ဧၐ မဟာမာရီသွရူပေါ နာသရတီယမတဂြာဟိသံဃာတသျ မုချော ဘူတွာ သရွွဒေၑေၐု သရွွေၐာံ ယိဟူဒီယာနာံ ရာဇဒြောဟာစရဏပြဝၖတ္တိံ ဇနယတီတျသ္မာဘိ ရ္နိၑ္စိတံ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","သ မန္ဒိရမပိ အၑုစိ ကရ္တ္တုံ စေၐ္ဋိတဝါန်; ဣတိ ကာရဏာဒ် ဝယမ် ဧနံ ဓၖတွာ သွဝျဝသ္ထာနုသာရေဏ ဝိစာရယိတုံ ပြာဝရ္တ္တာမဟိ; ");
INSERT INTO sanbur_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","ကိန္တု လုၐိယး သဟသြသေနာပတိရာဂတျ ဗလာဒ် အသ္မာကံ ကရေဘျ ဧနံ ဂၖဟီတွာ ");
INSERT INTO sanbur_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ဧတသျာပဝါဒကာန် ဘဝတး သမီပမ် အာဂန္တုမ် အာဇ္ဉာပယတ်၊ ဝယံ ယသ္မိန် တမပဝါဒါမော ဘဝတာ ပဒပဝါဒကထာယာံ ဝိစာရိတာယာံ သတျာံ သရွွံ ဝၖတ္တာန္တံ ဝေဒိတုံ ၑက္ၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","တတော ယိဟူဒီယာ အပိ သွီကၖတျ ကထိတဝန္တ ဧၐာ ကထာ ပြမာဏမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","အဓိပတော် ကထာံ ကထယိတုံ ပေါ်လံ ပြတီင်္ဂိတံ ကၖတဝတိ သ ကထိတဝါန် ဘဝါန် ဗဟူန် ဝတ္သရာန် ယာဝဒ် ဧတဒ္ဒေၑသျ ၑာသနံ ကရောတီတိ ဝိဇ္ဉာယ ပြတျုတ္တရံ ဒါတုမ် အက္ၐောဘော'ဘဝမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","အဒျ ကေဝလံ ဒွါဒၑ ဒိနာနိ ယာတာနိ, အဟမ် အာရာဓနာံ ကရ္တ္တုံ ယိရူၑာလမနဂရံ ဂတဝါန် ဧၐာ ကထာ ဘဝတာ ဇ္ဉာတုံ ၑကျတေ; ");
INSERT INTO sanbur_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","ကိန္တွိဘေ မာံ မဓျေမန္ဒိရံ ကေနာပိ သဟ ဝိတဏ္ဍာံ ကုရွွန္တံ ကုတြာပိ ဘဇနဘဝနေ နဂရေ ဝါ လောကာန် ကုပြဝၖတ္တိံ ဇနယန္တုံ န ဒၖၐ္ဋဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","ဣဒါနီံ ယသ္မိန် ယသ္မိန် မာမ် အပဝဒန္တေ တသျ ကိမပိ ပြမာဏံ ဒါတုံ န ၑက္နုဝန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","ကိန္တု ဘဝိၐျဒွါကျဂြန္ထေ ဝျဝသ္ထာဂြန္ထေ စ ယာ ယာ ကထာ လိခိတာသ္တေ တာသု သရွွာသု ဝိၑွသျ ယန္မတမ် ဣမေ ဝိဓရ္မ္မံ ဇာနန္တိ တန္မတာနုသာရေဏာဟံ နိဇပိတၖပုရုၐာဏာမ် ဤၑွရမ် အာရာဓယာမီတျဟံ ဘဝတး သမက္ၐမ် အင်္ဂီကရောမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","ဓာရ္မ္မိကာဏာမ် အဓာရ္မ္မိကာဏာဉ္စ ပြမီတလောကာနာမေဝေါတ္ထာနံ ဘဝိၐျတီတိ ကထာမိမေ သွီကုရွွန္တိ တထာဟမပိ တသ္မိန် ဤၑွရေ ပြတျာၑာံ ကရောမိ; ");
INSERT INTO sanbur_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","ဤၑွရသျ မာနဝါနာဉ္စ သမီပေ ယထာ နိရ္ဒောၐော ဘဝါမိ တဒရ္ထံ သတတံ ယတ္နဝါန် အသ္မိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","ဗဟုၐု ဝတ္သရေၐု ဂတေၐု သွဒေၑီယလောကာနာံ နိမိတ္တံ ဒါနီယဒြဝျာဏိ နဲဝေဒျာနိ စ သမာဒါယ ပုနရာဂမနံ ကၖတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","တတောဟံ ၑုစိ ရ္ဘူတွာ လောကာနာံ သမာဂမံ ကလဟံ ဝါ န ကာရိတဝါန် တထာပျာၑိယာဒေၑီယား ကိယန္တော ယိဟုဒီယလောကာ မဓျေမန္ဒိရံ မာံ ဓၖတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","မမောပရိ ယဒိ ကာစိဒပဝါဒကထာသ္တိ တရှိ ဘဝတး သမီပမ် ဥပသ္ထာယ တေၐာမေဝ သာက္ၐျဒါနမ် ဥစိတမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","နောစေတ် ပူရွွေ မဟာသဘာသ္ထာနာံ လောကာနာံ သန္နိဓော် မမ ဒဏ္ဍာယမာနတွသမယေ, အဟမဒျ မၖတာနာမုတ္ထာနေ ယုၐ္မာဘိ ရွိစာရိတောသ္မိ, ");
INSERT INTO sanbur_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","တေၐာံ မဓျေ တိၐ္ဌန္နဟံ ယာမိမာံ ကထာမုစ္စဲး သွရေဏ ကထိတဝါန် တဒနျော မမ ကောပိ ဒေါၐော'လဘျတ န ဝေတိ ဝရမ် ဧတေ သမုပသ္ထိတလောကာ ဝဒန္တု၊ ");
INSERT INTO sanbur_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","တဒါ ဖီလိက္ၐ ဧတာံ ကထာံ ၑြုတွာ တန္မတသျ ဝိၑေၐဝၖတ္တာန္တံ ဝိဇ္ဉာတုံ ဝိစာရံ သ္ထဂိတံ ကၖတွာ ကထိတဝါန် လုၐိယေ သဟသြသေနာပတော် သမာယာတေ သတိ ယုၐ္မာကံ ဝိစာရမ် အဟံ နိၐ္ပာဒယိၐျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","အနန္တရံ ဗန္ဓနံ ဝိနာ ပေါ်လံ ရက္ၐိတုံ တသျ သေဝနာယ သာက္ၐာတ္ကရဏာယ ဝါ တဒီယာတ္မီယဗန္ဓုဇနာန် န ဝါရယိတုဉ္စ ၑမသေနာပတိမ် အာဒိၐ္ဋဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","အလ္ပဒိနာတ် ပရံ ဖီလိက္ၐော'ဓိပတိ ရ္ဒြုၐိလ္လာနာမ္နာ ယိဟူဒီယယာ သွဘာရျျယာ သဟာဂတျ ပေါ်လမာဟူယ တသျ မုခါတ် ခြီၐ္ဋဓရ္မ္မသျ ဝၖတ္တာန္တမ် အၑြော်ၐီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","ပေါ်လေန နျာယသျ ပရိမိတဘောဂသျ စရမဝိစာရသျ စ ကထာယာံ ကထိတာယာံ သတျာံ ဖီလိက္ၐး ကမ္ပမာနး သန် ဝျာဟရဒ် ဣဒါနီံ ယာဟိ, အဟမ် အဝကာၑံ ပြာပျ တွာမ် အာဟူသျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","မုက္တိပြပ္တျရ္ထံ ပေါ်လေန မဟျံ မုဒြာဒါသျန္တေ ဣတိ ပတျာၑာံ ကၖတွာ သ ပုနး ပုနသ္တမာဟူယ တေန သာကံ ကထောပကထနံ ကၖတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","ကိန္တု ဝတ္သရဒွယာတ် ပရံ ပရ္ကိယဖီၐ္ဋ ဖာလိက္ၐသျ ပဒံ ပြာပ္တေ သတိ ဖီလိက္ၐော ယိဟူဒီယာန် သန္တုၐ္ဋာန် စိကီရ္ၐန် ပေါ်လံ ဗဒ္ဓံ သံသ္ထာပျ ဂတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","အနန္တရံ ဖီၐ္ဋော နိဇရာဇျမ် အာဂတျ ဒိနတြယာတ် ပရံ ကဲသရိယာတော ယိရူၑာလမ္နဂရမ် အာဂမတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","တဒါ မဟာယာဇကော ယိဟူဒီယာနာံ ပြဓာနလောကာၑ္စ တသျ သမက္ၐံ ပေါ်လမ် အပါဝဒန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ဘဝါန် တံ ယိရူၑာလမမ် အာနေတုမ် အာဇ္ဉာပယတွိတိ ဝိနီယ တေ တသ္မာဒ် အနုဂြဟံ ဝါဉ္ဆိတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","ယတး ပထိမဓျေ ဂေါပနေန ပေါ်လံ ဟန္တုံ တဲ ရ္ဃာတကာ နိယုက္တား၊ ဖီၐ္ဋ ဥတ္တရံ ဒတ္တဝါန် ပေါ်လး ကဲသရိယာယာံ သ္ထာသျတိ ပုနရလ္ပဒိနာတ် ပရမ် အဟံ တတြ ယာသျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","တတသ္တသျ မာနုၐသျ ယဒိ ကၑ္စိဒ် အပရာဓသ္တိၐ္ဌတိ တရှိ ယုၐ္မာကံ ယေ ၑက္နုဝန္တိ တေ မယာ သဟ တတြ ဂတွာ တမပဝဒန္တု သ ဧတာံ ကထာံ ကထိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","ဒၑဒိဝသေဘျော'ဓိကံ ဝိလမ္ဗျ ဖီၐ္ဋသ္တသ္မာတ် ကဲသရိယာနဂရံ ဂတွာ ပရသ္မိန် ဒိဝသေ ဝိစာရာသန ဥပဒိၑျ ပေါ်လမ် အာနေတုမ် အာဇ္ဉာပယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","ပေါ်လေ သမုပသ္ထိတေ သတိ ယိရူၑာလမ္နဂရာဒ် အာဂတာ ယိဟူဒီယလောကာသ္တံ စတုရ္ဒိၑိ သံဝေၐ္ဋျ တသျ ဝိရုဒ္ဓံ ဗဟူန် မဟာဒေါၐာန် ဥတ္ထာပိတဝန္တး ကိန္တု တေၐာံ ကိမပိ ပြမာဏံ ဒါတုံ န ၑက္နုဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","တတး ပေါ်လး သွသ္မိန် ဥတ္တရမိဒမ် ဥဒိတဝါန်, ယိဟူဒီယာနာံ ဝျဝသ္ထာယာ မန္ဒိရသျ ကဲသရသျ ဝါ ပြတိကူလံ ကိမပိ ကရ္မ္မ နာဟံ ကၖတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","ကိန္တု ဖီၐ္ဋော ယိဟူဒီယာန် သန္တုၐ္ဋာန် ကရ္တ္တုမ် အဘိလၐန် ပေါ်လမ် အဘာၐတ တွံ ကိံ ယိရူၑာလမံ ဂတွာသ္မိန် အဘိယောဂေ မမ သာက္ၐာဒ် ဝိစာရိတော ဘဝိၐျသိ? ");
INSERT INTO sanbur_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","တတး ပေါ်လ ဥတ္တရံ ပြောက္တဝါန်, ယတြ မမ ဝိစာရော ဘဝိတုံ ယောဂျး ကဲသရသျ တတြ ဝိစာရာသန ဧဝ သမုပသ္ထိတောသ္မိ; အဟံ ယိဟူဒီယာနာံ ကာမပိ ဟာနိံ နာကာရ္ၐမ် ဣတိ ဘဝါန် ယထာရ္ထတော ဝိဇာနာတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","ကဉ္စိဒပရာဓံ ကိဉ္စန ဝဓာရှံ ကရ္မ္မ ဝါ ယဒျဟမ် အကရိၐျံ တရှိ ပြာဏဟနနဒဏ္ဍမပိ ဘောက္တုမ် ဥဒျတော'ဘဝိၐျံ, ကိန္တု တေ မမ သမပဝါဒံ ကုရွွန္တိ သ ယဒိ ကလ္ပိတမာတြော ဘဝတိ တရှိ တေၐာံ ကရေၐု မာံ သမရ္ပယိတုံ ကသျာပျဓိကာရော နာသ္တိ, ကဲသရသျ နိကဋေ မမ ဝိစာရော ဘဝတု၊ ");
INSERT INTO sanbur_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","တဒါ ဖီၐ္ဋော မန္တြိဘိး သာရ္ဒ္ဓံ သံမန္တြျ ပေါ်လာယ ကထိတဝါန်, ကဲသရသျ နိကဋေ ကိံ တဝ ဝိစာရော ဘဝိၐျတိ? ကဲသရသျ သမီပံ ဂမိၐျသိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","ကိယဒ္ဒိနေဘျး ပရမ် အာဂြိပ္ပရာဇာ ဗရ္ဏီကီ စ ဖီၐ္ဋံ သာက္ၐာတ် ကရ္တ္တုံ ကဲသရိယာနဂရမ် အာဂတဝန္တော်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","တဒါ တော် ဗဟုဒိနာနိ တတြ သ္ထိတော် တတး ဖီၐ္ဋသ္တံ ရာဇာနံ ပေါ်လသျ ကထာံ ဝိဇ္ဉာပျ ကထယိတုမ် အာရဘတ ပေါ်လနာမာနမ် ဧကံ ဗန္ဒိ ဖီလိက္ၐော ဗဒ္ဓံ သံသ္ထာပျ ဂတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","ယိရူၑာလမိ မမ သ္ထိတိကာလေ မဟာယာဇကော ယိဟူဒီယာနာံ ပြာစီနလောကာၑ္စ တမ် အပေါဒျ တမ္ပြတိ ဒဏ္ဍာဇ္ဉာံ ပြာရ္ထယန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","တတောဟမ် ဣတျုတ္တရမ် အဝဒံ ယာဝဒ် အပေါဒိတော ဇနး သွာပဝါဒကာန် သာက္ၐာတ် ကၖတွာ သွသ္မိန် ယော'ပရာဓ အာရောပိတသ္တသျ ပြတျုတ္တရံ ဒါတုံ သုယောဂံ န ပြာပ္နောတိ, တာဝတ္ကာလံ ကသျာပိ မာနုၐသျ ပြာဏနာၑာဇ္ဉာပနံ ရောမိလောကာနာံ ရီတိ ရ္နဟိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","တတသ္တေၐွတြာဂတေၐု ပရသ္မိန် ဒိဝသေ'ဟမ် အဝိလမ္ဗံ ဝိစာရာသန ဥပဝိၑျ တံ မာနုၐမ် အာနေတုမ် အာဇ္ဉာပယမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","တဒနန္တရံ တသျာပဝါဒကာ ဥပသ္ထာယ ယာဒၖၑမ် အဟံ စိန္တိတဝါန် တာဒၖၑံ ကဉ္စန မဟာပဝါဒံ နောတ္ထာပျ ");
INSERT INTO sanbur_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","သွေၐာံ မတေ တထာ ပေါ်လော ယံ သဇီဝံ ဝဒတိ တသ္မိန် ယီၑုနာမနိ မၖတဇနေ စ တသျ ဝိရုဒ္ဓံ ကထိတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","တတောဟံ တာဒၖဂွိစာရေ သံၑယာနး သန် ကထိတဝါန် တွံ ယိရူၑာလမံ ဂတွာ ကိံ တတြ ဝိစာရိတော ဘဝိတုမ် ဣစ္ဆသိ? ");
INSERT INTO sanbur_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","တဒါ ပေါ်လော မဟာရာဇသျ နိကဋေ ဝိစာရိတော ဘဝိတုံ ပြာရ္ထယတ, တသ္မာဒ် ယာဝတ္ကာလံ တံ ကဲသရသျ သမီပံ ပြေၐယိတုံ န ၑက္နောမိ တာဝတ္ကာလံ တမတြ သ္ထာပယိတုမ် အာဒိၐ္ဋဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","တတ အာဂြိပ္ပး ဖီၐ္ဋမ် ဥက္တဝါန်, အဟမပိ တသျ မာနုၐသျ ကထာံ ၑြောတုမ် အဘိလၐာမိ၊ တဒါ ဖီၐ္ဋော ဝျာဟရတ် ၑွသ္တဒီယာံ ကထာံ တွံ ၑြောၐျသိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","ပရသ္မိန် ဒိဝသေ အာဂြိပ္ပော ဗရ္ဏီကီ စ မဟာသမာဂမံ ကၖတွာ ပြဓာနဝါဟိနီပတိဘိ ရ္နဂရသ္ထပြဓာနလောကဲၑ္စ သဟ မိလိတွာ ရာဇဂၖဟမာဂတျ သမုပသ္ထိတော် တဒါ ဖီၐ္ဋသျာဇ္ဉယာ ပေါ်လ အာနီတော'ဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","တဒါ ဖီၐ္ဋး ကထိတဝါန် ဟေ ရာဇန် အာဂြိပ္ပ ဟေ ဥပသ္ထိတား သရွွေ လောကာ ယိရူၑာလမ္နဂရေ ယိဟူဒီယလောကသမူဟော ယသ္မိန် မာနုၐေ မမ သမီပေ နိဝေဒနံ ကၖတွာ ပြောစ္စဲး ကထာမိမာံ ကထိတဝါန် ပုနရလ္ပကာလမပိ တသျ ဇီဝနံ နောစိတံ တမေတံ မာနုၐံ ပၑျတ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","ကိန္တွေၐ ဇနး ပြာဏနာၑရှံ ကိမပိ ကရ္မ္မ န ကၖတဝါန် ဣတျဇာနာံ တထာပိ သ မဟာရာဇသျ သန္နိဓော် ဝိစာရိတော ဘဝိတုံ ပြာရ္ထယတ တသ္မာတ် တသျ သမီပံ တံ ပြေၐယိတုံ မတိမကရဝမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","ကိန္တု ၑြီယုက္တသျ သမီပမ် ဧတသ္မိန် ကိံ လေခနီယမ် ဣတျသျ ကသျစိန် နိရ္ဏယသျ န ဇာတတွာဒ် ဧတသျ ဝိစာရေ သတိ ယထာဟံ လေခိတုံ ကိဉ္စန နိၑ္စိတံ ပြာပ္နောမိ တဒရ္ထံ ယုၐ္မာကံ သမက္ၐံ ဝိၑေၐတော ဟေ အာဂြိပ္ပရာဇ ဘဝတး သမက္ၐမ် ဧတမ် အာနယေ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","ယတော ဗန္ဒိပြေၐဏသမယေ တသျာဘိယောဂသျ ကိဉ္စိဒလေခနမ် အဟမ် အယုက္တံ ဇာနာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","တတ အာဂြိပ္ပး ပေါ်လမ် အဝါဒီတ်, နိဇာံ ကထာံ ကထယိတုံ တုဘျမ် အနုမတိ ရ္ဒီယတေ၊ တသ္မာတ် ပေါ်လး ကရံ ပြသာရျျ သွသ္မိန် ဥတ္တရမ် အဝါဒီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","ဟေ အာဂြိပ္ပရာဇ ယတ္ကာရဏာဒဟံ ယိဟူဒီယဲရပဝါဒိတော 'ဘဝံ တသျ ဝၖတ္တာန္တမ် အဒျ ဘဝတး သာက္ၐာန် နိဝေဒယိတုမနုမတောဟမ် ဣဒံ သွီယံ ပရမံ ဘာဂျံ မနျေ; ");
INSERT INTO sanbur_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","ယတော ယိဟူဒီယလောကာနာံ မဓျေ ယာ ယာ ရီတိး သူက္ၐ္မဝိစာရာၑ္စ သန္တိ တေၐု ဘဝါန် ဝိဇ္ဉတမး; အတဧဝ ပြာရ္ထယေ ဓဲရျျမဝလမ္ဗျ မမ နိဝေဒနံ ၑၖဏောတု၊ ");
INSERT INTO sanbur_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","အဟံ ယိရူၑာလမ္နဂရေ သွဒေၑီယလောကာနာံ မဓျေ တိၐ္ဌန် အာ ယော်ဝနကာလာဒ် ယဒြူပမ် အာစရိတဝါန် တဒ် ယိဟူဒီယလောကား သရွွေ ဝိဒန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","အသ္မာကံ သရွွေဘျး ၑုဒ္ဓတမံ ယတ် ဖိရူၑီယမတံ တဒဝလမ္ဗီ ဘူတွာဟံ ကာလံ ယာပိတဝါန် ယေ ဇနာ အာ ဗာလျကာလာန် မာံ ဇာနာန္တိ တေ ဧတာဒၖၑံ သာက္ၐျံ ယဒိ ဒဒါတိ တရှိ ဒါတုံ ၑက္နုဝန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","ကိန္တု ဟေ အာဂြိပ္ပရာဇ ဤၑွရော'သ္မာကံ ပူရွွပုရုၐာဏာံ နိကဋေ ယဒ် အင်္ဂီကၖတဝါန် တသျ ပြတျာၑာဟေတောရဟမ် ဣဒါနီံ ဝိစာရသ္ထာနေ ဒဏ္ဍာယမာနောသ္မိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","တသျာင်္ဂီကာရသျ ဖလံ ပြာပ္တုမ် အသ္မာကံ ဒွါဒၑဝံၑာ ဒိဝါနိၑံ မဟာယတ္နာဒ် ဤၑွရသေဝနံ ကၖတွာ ယာံ ပြတျာၑာံ ကုရွွန္တိ တသျား ပြတျာၑာယာ ဟေတောရဟံ ယိဟူဒီယဲရပဝါဒိတော'ဘဝမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","ဤၑွရော မၖတာန် ဥတ္ထာပယိၐျတီတိ ဝါကျံ ယုၐ္မာကံ နိကဋေ'သမ္ဘဝံ ကုတော ဘဝေတ်? ");
INSERT INTO sanbur_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","နာသရတီယယီၑော ရ္နာမ္နော ဝိရုဒ္ဓံ နာနာပြကာရပြတိကူလာစရဏမ် ဥစိတမ် ဣတျဟံ မနသိ ယထာရ္ထံ ဝိဇ္ဉာယ ");
INSERT INTO sanbur_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","ယိရူၑာလမနဂရေ တဒကရဝံ ဖလတး ပြဓာနယာဇကသျ နိကဋာတ် က္ၐမတာံ ပြာပျ ဗဟူန် ပဝိတြလောကာန် ကာရာယာံ ဗဒ္ဓဝါန် ဝိၑေၐတသ္တေၐာံ ဟနနသမယေ တေၐာံ ဝိရုဒ္ဓါံ နိဇာံ သမ္မတိံ ပြကာၑိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","ဝါရံ ဝါရံ ဘဇနဘဝနေၐု တေဘျော ဒဏ္ဍံ ပြဒတ္တဝါန် ဗလာတ် တံ ဓရ္မ္မံ နိန္ဒယိတဝါံၑ္စ ပုနၑ္စ တာန် ပြတိ မဟာကြောဓာဒ် ဥန္မတ္တး သန် ဝိဒေၑီယနဂရာဏိ ယာဝတ် တာန် တာဍိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","ဣတ္ထံ ပြဓာနယာဇကသျ သမီပါတ် ၑက္တိမ် အာဇ္ဉာပတြဉ္စ လဗ္ဓွာ ဒမ္မေၐက္နဂရံ ဂတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","တဒါဟံ ဟေ ရာဇန် မာရ္ဂမဓျေ မဓျာဟ္နကာလေ မမ မဒီယသင်္ဂိနာံ လောကာနာဉ္စ စတသၖၐု ဒိက္ၐု ဂဂဏာတ် ပြကာၑမာနာံ ဘာသ္ကရတောပိ တေဇသွတီံ ဒီပ္တိံ ဒၖၐ္ဋဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","တသ္မာဒ် အသ္မာသု သရွွေၐု ဘူမော် ပတိတေၐု သတ္သု ဟေ ၑော်လ ဟဲ ၑော်လ ကုတော မာံ တာဍယသိ? ကဏ္ဋကာနာံ မုခေ ပါဒါဟနနံ တဝ ဒုးသာဓျမ် ဣဗြီယဘာၐယာ ဂဒိတ ဧတာဒၖၑ ဧကး ၑဗ္ဒော မယာ ၑြုတး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","တဒါဟံ ပၖၐ္ဋဝါန် ဟေ ပြဘော ကော ဘဝါန်? တတး သ ကထိတဝါန် ယံ ယီၑုံ တွံ တာဍယသိ သောဟံ, ");
INSERT INTO sanbur_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","ကိန္တု သမုတ္တိၐ္ဌ တွံ ယဒ် ဒၖၐ္ဋဝါန် ဣတး ပုနဉ္စ ယဒျတ် တွာံ ဒရ္ၑယိၐျာမိ တေၐာံ သရွွေၐာံ ကာရျျာဏာံ တွာံ သာက္ၐိဏံ မမ သေဝကဉ္စ ကရ္တ္တုမ် ဒရ္ၑနမ် အဒါမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","ဝိၑေၐတော ယိဟူဒီယလောကေဘျော ဘိန္နဇာတီယေဘျၑ္စ တွာံ မနောနီတံ ကၖတွာ တေၐာံ ယထာ ပါပမောစနံ ဘဝတိ ");
INSERT INTO sanbur_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ယထာ တေ မယိ ဝိၑွသျ ပဝိတြီကၖတာနာံ မဓျေ ဘာဂံ ပြာပ္နုဝန္တိ တဒဘိပြာယေဏ တေၐာံ ဇ္ဉာနစက္ၐူံၐိ ပြသန္နာနိ ကရ္တ္တုံ တထာန္ဓကာရာဒ် ဒီပ္တိံ ပြတိ ၑဲတာနာဓိကာရာစ္စ ဤၑွရံ ပြတိ မတီး ပရာဝရ္တ္တယိတုံ တေၐာံ သမီပံ တွာံ ပြေၐျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","ဟေ အာဂြိပ္ပရာဇ ဧတာဒၖၑံ သွရ္ဂီယပြတျာဒေၑံ အဂြာဟျမ် အကၖတွာဟံ ");
INSERT INTO sanbur_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","ပြထမတော ဒမ္မေၐက္နဂရေ တတော ယိရူၑာလမိ သရွွသ္မိန် ယိဟူဒီယဒေၑေ အနျေၐု ဒေၑေၐု စ ယေेန လောကာ မတိံ ပရာဝရ္တ္တျ ဤၑွရံ ပြတိ ပရာဝရ္တ္တယန္တေ, မနးပရာဝရ္တ္တနယောဂျာနိ ကရ္မ္မာဏိ စ ကုရွွန္တိ တာဒၖၑမ် ဥပဒေၑံ ပြစာရိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","ဧတတ္ကာရဏာဒ် ယိဟူဒီယာ မဓျေမန္ဒိရံ မာံ ဓၖတွာ ဟန္တုမ် ဥဒျတား၊ ");
INSERT INTO sanbur_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","တထာပိ ခြီၐ္ဋော ဒုးခံ ဘုက္တွာ သရွွေၐာံ ပူရွွံ ၑ္မၑာနာဒ် ဥတ္ထာယ နိဇဒေၑီယာနာံ ဘိန္နဒေၑီယာနာဉ္စ သမီပေ ဒီပ္တိံ ပြကာၑယိၐျတိ ");
INSERT INTO sanbur_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","ဘဝိၐျဒွါဒိဂဏော မူသာၑ္စ ဘာဝိကာရျျသျ ယဒိဒံ ပြမာဏမ် အဒဒုရေတဒ် ဝိနာနျာံ ကထာံ န ကထယိတွာ ဤၑွရာဒ် အနုဂြဟံ လဗ္ဓွာ မဟတာံ က္ၐုဒြာဏာဉ္စ သရွွေၐာံ သမီပေ ပြမာဏံ ဒတ္တွာဒျ ယာဝတ် တိၐ္ဌာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","တသျမာံ ကထာံ နိၑမျ ဖီၐ္ဋ ဥစ္စဲး သွရေဏ ကထိတဝါန် ဟေ ပေါ်လ တွမ် ဥန္မတ္တောသိ ဗဟုဝိဒျာဘျာသေန တွံ ဟတဇ္ဉာနော ဇာတး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","သ ဥက္တဝါန် ဟေ မဟာမဟိမ ဖီၐ္ဋ နာဟမ် ဥန္မတ္တး ကိန္တု သတျံ ဝိဝေစနီယဉ္စ ဝါကျံ ပြသ္တော်မိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","ယသျ သာက္ၐာဒ် အက္ၐောဘး သန် ကထာံ ကထယာမိ သ ရာဇာ တဒွၖတ္တာန္တံ ဇာနာတိ တသျ သမီပေ ကိမပိ ဂုပ္တံ နေတိ မယာ နိၑ္စိတံ ဗုဓျတေ ယတသ္တဒ် ဝိဇနေ န ကၖတံ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","ဟေ အာဂြိပ္ပရာဇ ဘဝါန် ကိံ ဘဝိၐျဒွါဒိဂဏောက္တာနိ ဝါကျာနိ ပြတျေတိ? ဘဝါန် ပြတျေတိ တဒဟံ ဇာနာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","တတ အာဂြိပ္ပး ပေါ်လမ် အဘိဟိတဝါန် တွံ ပြဝၖတ္တိံ ဇနယိတွာ ပြာယေဏ မာမပိ ခြီၐ္ဋီယံ ကရောၐိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","တတး သော'ဝါဒီတ် ဘဝါန် ယေ ယေ လောကာၑ္စ မမ ကထာမ် အဒျ ၑၖဏွန္တိ ပြာယေဏ ဣတိ နဟိ ကိန္တွေတတ် ၑၖင်္ခလဗန္ဓနံ ဝိနာ သရွွထာ တေ သရွွေ မာဒၖၑာ ဘဝန္တွိတီၑွသျ သမီပေ ပြာရ္ထယေ'ဟမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","ဧတသျာံ ကထာယာံ ကထိတာယာံ သ ရာဇာ သော'ဓိပတိ ရ္ဗရ္ဏီကီ သဘာသ္ထာ လောကာၑ္စ တသ္မာဒ် ဥတ္ထာယ ");
INSERT INTO sanbur_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ဂေါပနေ ပရသ္ပရံ ဝိဝိစျ ကထိတဝန္တ ဧၐ ဇနော ဗန္ဓနာရှံ ပြာဏဟနနာရှံ ဝါ ကိမပိ ကရ္မ္မ နာကရောတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","တတ အာဂြိပ္ပး ဖီၐ္ဋမ် အဝဒတ်, ယဒျေၐ မာနုၐး ကဲသရသျ နိကဋေ ဝိစာရိတော ဘဝိတုံ န ပြာရ္ထယိၐျတ် တရှိ မုက္တော ဘဝိတုမ် အၑက္ၐျတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","ဇလပထေနာသ္မာကမ် ဣတောလိယာဒေၑံ ပြတိ ယာတြာယာံ နိၑ္စိတာယာံ သတျာံ တေ ယူလိယနာမ္နော မဟာရာဇသျ သံဃာတာန္တရ္ဂတသျ သေနာပတေး သမီပေ ပေါ်လံ တဒနျာန် ကတိနယဇနာံၑ္စ သမာရ္ပယန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","ဝယမ် အာဒြာမုတ္တီယံ ပေါတမေကမ် အာရုဟျ အာၑိယာဒေၑသျ တဋသမီပေန ယာတုံ မတိံ ကၖတွာ လင်္ဂရမ် ဥတ္ထာပျ ပေါတမ် အမောစယာမ; မာကိဒနိယာဒေၑသ္ထထိၐလနီကီနိဝါသျာရိသ္တာရ္ခနာမာ ကၑ္စိဒ် ဇနော'သ္မာဘိး သာရ္ဒ္ဓမ် အာသီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","ပရသ္မိန် ဒိဝသေ 'သ္မာဘိး သီဒေါန္နဂရေ ပေါတေ လာဂိတေ တတြ ယူလိယး သေနာပတိး ပေါ်လံ ပြတိ သော်ဇနျံ ပြဒရ္ထျ သာန္တွနာရ္ထံ ဗန္ဓုဗာန္ဓဝါန် ဥပယာတုမ် အနုဇဇ္ဉော်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","တသ္မာတ် ပေါတေ မောစိတေ သတိ သမ္မုခဝါယေား သမ္ဘဝါဒ် ဝယံ ကုပြောပဒွီပသျ တီရသမီပေန ဂတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","ကိလိကိယာယား ပါမ္ဖူလိယာယာၑ္စ သမုဒြသျ ပါရံ ဂတွာ လူကိယာဒေၑာန္တရ္ဂတံ မုရာနဂရမ် ဥပါတိၐ္ဌာမ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","တတ္သ္ထာနာဒ် ဣတာလိယာဒေၑံ ဂစ္ဆတိ ယး သိကန္ဒရိယာနဂရသျ ပေါတသ္တံ တတြ ပြာပျ ၑတသေနာပတိသ္တံ ပေါတမ် အသ္မာန် အာရောဟယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","တတး ပရံ ဗဟူနိ ဒိနာနိ ၑနဲး ၑနဲး ရ္ဂတွာ က္နီဒပါရ္ၑွောပသ္ထ္တိेး ပူရွွံ ပြတိကူလေန ပဝနေန ဝယံ သလ္မောနျား သမ္မုခမ် ဥပသ္ထာယ ကြီတျုပဒွီပသျ တီရသမီပေန ဂတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","ကၐ္ဋေန တမုတ္တီရျျ လာသေယာနဂရသျာဓး သုန္ဒရနာမကံ ခါတမ် ဥပါတိၐ္ဌာမ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","ဣတ္ထံ ဗဟုတိထး ကာလော ယာပိတ ဥပဝါသဒိနဉ္စာတီတံ, တတ္ကာရဏာတ် နော်ဝရ္တ္မနိ ဘယင်္ကရေ သတိ ပေါ်လော ဝိနယေန ကထိတဝါန်, ");
INSERT INTO sanbur_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","ဟေ မဟေစ္ဆာ အဟံ နိၑ္စယံ ဇာနာမိ ယာတြာယာမသျာမ် အသ္မာကံ က္လေၑာ ဗဟူနာမပစယာၑ္စ ဘဝိၐျန္တိ, တေ ကေဝလံ ပေါတသာမဂြျောရိတိ နဟိ, ကိန္တွသ္မာကံ ပြာဏာနာမပိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","တဒါ ၑတသေနာပတိး ပေါ်ैेလောက္တဝါကျတောပိ ကရ္ဏဓာရသျ ပေါတဝဏိဇၑ္စ ဝါကျံ ဗဟုမံသ္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","တတ် ခါတံ ၑီတကာလေ ဝါသာရှသ္ထာနံ န တသ္မာဒ် အဝါစီပြတီစောရ္ဒိၑေား ကြီတျား ဖဲနီကိယခါတံ ယာတုံ ယဒိ ၑက္နုဝန္တသ္တရှိ တတြ ၑီတကာလံ ယာပယိတုံ ပြာယေဏ သရွွေ မန္တြယာမာသုး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","တတး ပရံ ဒက္ၐိဏဝါယု ရ္မန္ဒံ ဝဟတီတိ ဝိလောကျ နိဇာဘိပြာယသျ သိဒ္ဓေး သုယောဂေါ ဘဝတီတိ ဗုဒ္ဓွာ ပေါတံ မောစယိတွာ ကြီတျုပဒွီပသျ တီရသမီပေန စလိတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","ကိန္တွလ္ပက္ၐဏာတ် ပရမေဝ ဥရက္လုဒေါန္နာမာ ပြတိကူလး ပြစဏ္ဍော ဝါယု ရွဟန် ပေါတေ'လဂီတ္ ");
INSERT INTO sanbur_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","တသျာဘိမုခံ ဂန္တုမ် ပေါတသျာၑက္တတွာဒ် ဝယံ ဝါယုနာ သွယံ နီတား၊ ");
INSERT INTO sanbur_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","အနန္တရံ က္လော်ဒီနာမ္န ဥပဒွီပသျ ကူလသမီပေန ပေါတံ ဂမယိတွာ ဗဟုနာ ကၐ္ဋေန က္ၐုဒြနာဝမ် အရက္ၐာမ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","တေ တာမာရုဟျ ရဇ္ဇ္စာ ပေါတသျာဓောဘာဂမ် အဗဓ္နန် တဒနန္တရံ စေတ် ပေါတော သဲကတေ လဂတီတိ ဘယာဒ် ဝါတဝသနာနျမောစယန် တတး ပေါတော ဝါယုနာ စာလိတး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","ကိန္တု ကြမၑော ဝါယေား ပြဗလတွာတ် ပေါတော ဒေါလာယမာနော'ဘဝတ် ပရသ္မိန် ဒိဝသေ ပေါတသ္ထာနိ ကတိပယာနိ ဒြဝျာဏိ တောယေ နိက္ၐိပ္တာနိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","တၖတီယဒိဝသေ ဝယံ သွဟသ္တဲး ပေါတသဇ္ဇနဒြဝျာဏိ နိက္ၐိပ္တဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","တတော ဗဟုဒိနာနိ ယာဝတ် သူရျျနက္ၐတြာဒီနိ သမာစ္ဆန္နာနိ တတော 'တီဝ ဝါတျာဂမာဒ် အသ္မာကံ ပြာဏရက္ၐာယား ကာပိ ပြတျာၑာ နာတိၐ္ဌတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","ဗဟုဒိနေၐု လောကဲရနာဟာရေဏ ယာပိတေၐု သရွွေၐာံ သာက္ၐတ် ပေါ်လသ္တိၐ္ဌန် အကထယတ်, ဟေ မဟေစ္ဆား ကြီတျုပဒွီပါတ် ပေါတံ န မောစယိတုမ် အဟံ ပူရွွံ ယဒ် အဝဒံ တဒ္ဂြဟဏံ ယုၐ္မာကမ် ဥစိတမ် အာသီတ် တထာ ကၖတေ ယုၐ္မာကမ် ဧၐာ ဝိပဒ် ဧၐော'ပစယၑ္စ နာဃဋိၐျေတာမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","ကိန္တု သာမ္ပြတံ ယုၐ္မာန် ဝိနီယ ဗြဝီမျဟံ, ယူယံ န က္ၐုဘျတ ယုၐ္မာကမ် ဧကသျာပိ ပြာဏိနော ဟာနိ ရ္န ဘဝိၐျတိ, ကေဝလသျ ပေါတသျ ဟာနိ ရ္ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","ယတော ယသျေၑွရသျ လောကော'ဟံ ယဉ္စာဟံ ပရိစရာမိ တဒီယ ဧကော ဒူတော ဟျော ရာတြော် မမာန္တိကေ တိၐ္ဌန် ကထိတဝါန်, ");
INSERT INTO sanbur_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ဟေ ပေါ်လ မာ ဘဲၐီး ကဲသရသျ သမ္မုခေ တွယောပသ္ထာတဝျံ; တဝဲတာန် သင်္ဂိနော လောကာန် ဤၑွရသ္တုဘျံ ဒတ္တဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","အတဧဝ ဟေ မဟေစ္ဆာ ယူယံ သ္ထိရမနသော ဘဝတ မဟျံ ယာ ကထာကထိ သာဝၑျံ ဃဋိၐျတေ မမဲတာဒၖၑီ ဝိၑွာသ ဤၑွရေ ဝိဒျတေ, ");
INSERT INTO sanbur_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","ကိန္တု ကသျစိဒ် ဥပဒွီပသျောပရိ ပတိတဝျမ် အသ္မာဘိး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","တတး ပရမ် အာဒြိယာသမုဒြေ ပေါတသ္တထဲဝ ဒေါလာယမာနး သန် ဣတသ္တတော ဂစ္ဆန် စတုရ္ဒၑဒိဝသသျ ရာတြေ ရ္ဒွိတီယပြဟရသမယေ ကသျစိတ် သ္ထလသျ သမီပမုပတိၐ္ဌတီတိ ပေါတီယလောကာ အနွမနျန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","တတသ္တေ ဇလံ ပရိမာယ တတြ ဝိံၑတိ ရွျာမာ ဇလာနီတိ ဇ္ဉာတဝန္တး၊ ကိဉ္စိဒ္ဒူရံ ဂတွာ ပုနရပိ ဇလံ ပရိမိတဝန္တး၊ တတြ ပဉ္စဒၑ ဝျာမာ ဇလာနိ ဒၖၐ္ဋွာ ");
INSERT INTO sanbur_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","စေတ် ပါၐာဏေ လဂတီတိ ဘယာတ် ပေါတသျ ပၑ္စာဒ္ဘါဂတၑ္စတုရော လင်္ဂရာန် နိက္ၐိပျ ဒိဝါကရမ် အပေက္ၐျ သရွွေ သ္ထိတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","ကိန္တု ပေါတီယလောကား ပေါတာဂြဘာဂေ လင်္ဂရနိက္ၐေပံ ဆလံ ကၖတွာ ဇလဓော် က္ၐုဒြနာဝမ် အဝရောဟျ ပလာယိတုမ် အစေၐ္ဋန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","တတး ပေါ်လး သေနာပတယေ သဲနျဂဏာယ စ ကထိတဝါန်, ဧတေ ယဒိ ပေါတမဓျေ န တိၐ္ဌန္တိ တရှိ ယုၐ္မာကံ ရက္ၐဏံ န ၑကျံ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","တဒါ သေနာဂဏော ရဇ္ဇူန် ဆိတွာ နာဝံ ဇလေ ပတိတုမ် အဒဒါတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","ပြဘာတသမယေ ပေါ်လး သရွွာန် ဇနာန် ဘောဇနာရ္ထံ ပြာရ္ထျ ဝျာဟရတ်, အဒျ စတုရ္ဒၑဒိနာနိ ယာဝဒ် ယူယမ် အပေက္ၐမာနာ အနာဟာရား ကာလမ် အယာပယတ ကိမပိ နာဘုံဂ္ဓံ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","အတော ဝိနယေे'ဟံ ဘက္ၐျံ ဘုဇျတာံ တတော ယုၐ္မာကံ မင်္ဂလံ ဘဝိၐျတိ, ယုၐ္မာကံ ကသျစိဇ္ဇနသျ ၑိရသး ကေၑဲကောပိ န နံက္ၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","ဣတိ ဝျာဟၖတျ ပေါ်လံ ပူပံ ဂၖဟီတွေၑွရံ ဓနျံ ဘာၐမာဏသ္တံ ဘံက္တွာ ဘောက္တုမ် အာရဗ္ဓဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","အနန္တရံ သရွွေ စ သုသ္ထိရား သန္တး ခါဒျာနိ ပရ္ပျဂၖဟ္လန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","အသ္မာကံ ပေါတေ ၐဋ္သပ္တတျဓိကၑတဒွယလောကာ အာသန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","သရွွေၐု လောကေၐု ယထေၐ္ဋံ ဘုက္တဝတ္သု ပေါတသ္ထန် ဂေါဓူမာန် ဇလဓော် နိက္ၐိပျ တဲး ပေါတသျ ဘာရော လဃူကၖတး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","ဒိနေ ဇာတေ'ပိ သ ကော ဒေၑ ဣတိ တဒါ န ပရျျစီယတ; ကိန္တု တတြ သမတဋမ် ဧကံ ခါတံ ဒၖၐ္ဋွာ ယဒိ ၑက္နုမသ္တရှိ ဝယံ တသျာဘျန္တရံ ပေါတံ ဂမယာမ ဣတိ မတိံ ကၖတွာ တေ လင်္ဂရာန် ဆိတ္တွာ ဇလဓော် တျက္တဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","တထာ ကရ္ဏဗန္ဓနံ မောစယိတွာ ပြဓာနံ ဝါတဝသနမ် ဥတ္တောလျ တီရသမီပံ ဂတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","ကိန္တု ဒွယေား သမုဒြယေား သင်္ဂမသ္ထာနေ သဲကတောပရိ ပေါတေ နိက္ၐိပ္တေ 'ဂြဘာဂေ ဗာဓိတေ ပၑ္စာဒ္ဘါဂေ ပြဗလတရင်္ဂေါ'လဂတ် တေန ပေါတော ဘဂ္နး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","တသ္မာဒ် ဗန္ဒယၑ္စေဒ် ဗာဟုဘိသ္တရန္တး ပလာယန္တေ ဣတျာၑင်္ကယာ သေနာဂဏသ္တာန် ဟန္တုမ် အမန္တြယတ်; ");
INSERT INTO sanbur_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","ကိန္တု ၑတသေနာပတိး ပေါ်လံ ရက္ၐိတုံ ပြယတ္နံ ကၖတွာ တာန် တစ္စေၐ္ဋာယာ နိဝရ္တျ ဣတျာဒိၐ္ဋဝါန်, ယေ ဗာဟုတရဏံ ဇာနန္တိ တေ'ဂြေ ပြောလ္လမ္ပျ သမုဒြေ ပတိတွာ ဗာဟုဘိသ္တီရ္တ္တွာ ကူလံ ယာန္တု၊ ");
INSERT INTO sanbur_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","အပရမ် အဝၑိၐ္ဋာ ဇနား ကာၐ္ဌံ ပေါတီယံ ဒြဝျံ ဝါ ယေန ယတ် ပြာပျတေ တဒဝလမ္ဗျ ယာန္တု; ဣတ္ထံ သရွွေ ဘူမိံ ပြာပျ ပြာဏဲ ရ္ဇီဝိတား၊ ");
INSERT INTO sanbur_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","ဣတ္ထံ သရွွေၐု ရက္ၐာံ ပြာပ္တေၐု တတြတျောပဒွီပသျ နာမ မိလီတေတိ တေ ဇ္ဉာတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","အသဘျလောကာ ယထေၐ္ဋမ် အနုကမ္ပာံ ကၖတွာ ဝရ္တ္တမာနဝၖၐ္ဋေး ၑီတာစ္စ ဝဟ္နိံ ပြဇ္ဇွာလျာသ္မာကမ် အာတိထျမ် အကုရွွန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","ကိန္တု ပေါ်လ ဣန္ဓနာနိ သံဂၖဟျ ယဒါ တသ္မိန် အဂြော် နိရက္ၐိပတ်, တဒါ ဝဟ္နေး ပြတာပါတ် ဧကး ကၖၐ္ဏသရ္ပော နိရ္ဂတျ တသျ ဟသ္တေ ဒြၐ္ဋဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","တေ'သဘျလောကာသ္တသျ ဟသ္တေ သရ္ပမ် အဝလမ္ဗမာနံ ဒၖၐ္ဋွာ ပရသ္ပရမ် ဥက္တဝန္တ ဧၐ ဇနော'ဝၑျံ နရဟာ ဘဝိၐျတိ, ယတော ယဒျပိ ဇလဓေ ရက္ၐာံ ပြာပ္တဝါန် တထာပိ ပြတိဖလဒါယက ဧနံ ဇီဝိတုံ န ဒဒါတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","ကိန္တု သ ဟသ္တံ ဝိဓုနွန် တံ သရ္ပမ် အဂ္နိမဓျေ နိက္ၐိပျ ကာမပိ ပီဍာံ နာပ္တဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","တတော ဝိၐဇွာလယာ ဧတသျ ၑရီရံ သ္ဖီတံ ဘဝိၐျတိ ယဒွါ ဟဌာဒယံ ပြာဏာန် တျက္ၐျတီတိ နိၑ္စိတျ လောကာ ဗဟုက္ၐဏာနိ ယာဝတ် တဒ် ဒြၐ္ဋုံ သ္ထိတဝန္တး ကိန္တု တသျ ကသျာၑ္စိဒ် ဝိပဒေါ'ဃဋနာတ် တေ တဒွိပရီတံ ဝိဇ္ဉာယ ဘာၐိတဝန္တ ဧၐ ကၑ္စိဒ် ဒေဝေါ ဘဝေတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","ပုဗ္လိယနာမာ ဇန ဧကသ္တသျောပဒွီပသျာဓိပတိရာသီတ် တတြ တသျ ဘူမျာဒိ စ သ္ထိတံ၊ သ ဇနော'သ္မာန် နိဇဂၖဟံ နီတွာ သော်ဇနျံ ပြကာၑျ ဒိနတြယံ ယာဝဒ် အသ္မာကံ အာတိထျမ် အကရောတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","တဒါ တသျ ပုဗ္လိယသျ ပိတာ ဇွရာတိသာရေဏ ပီဍျမာနး သန် ၑယျာယာမ် အာသီတ်; တတး ပေါ်လသ္တသျ သမီပံ ဂတွာ ပြာရ္ထနာံ ကၖတွာ တသျ ဂါတြေ ဟသ္တံ သမရ္ပျ တံ သွသ္ထံ ကၖတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","ဣတ္ထံ ဘူတေ တဒွီပနိဝါသိန ဣတရေပိ ရောဂိလောကာ အာဂတျ နိရာမယာ အဘဝန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","တသ္မာတ္တေ'သ္မာကမ် အတီဝ သတ္ကာရံ ကၖတဝန္တး, ဝိၑေၐတး ပြသ္ထာနသမယေ ပြယောဇနီယာနိ နာနဒြဝျာဏိ ဒတ္တဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","ဣတ္ထံ တတြ တြိၐု မာသေၐု ဂတေၐု ယသျ စိဟ္နံ ဒိယသ္ကူရီ တာဒၖၑ ဧကး သိကန္ဒရီယနဂရသျ ပေါတး ၑီတကာလံ ယာပယန် တသ္မိန် ဥပဒွီပေ 'တိၐ္ဌတ် တမေဝ ပေါတံ ဝယမ် အာရုဟျ ယာတြာမ် အကုရ္မ္မ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","တတး ပြထမတး သုရာကူသနဂရမ် ဥပသ္ထာယ တတြ တြီဏိ ဒိနာနိ သ္ထိတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","တသ္မာဒ် အာဝၖတျ ရီဂိယနဂရမ် ဥပသ္ထိတား ဒိနဲကသ္မာတ် ပရံ ဒက္ၐိဏဝယော် သာနုကူလျေ သတိ ပရသ္မိန် ဒိဝသေ ပတိယလီနဂရမ် ဥပါတိၐ္ဌာမ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","တတော'သ္မာသု တတြတျံ ဘြာတၖဂဏံ ပြာပ္တေၐု တေ သွဲး သာရ္ဒ္ဓမ် အသ္မာန် သပ္တ ဒိနာနိ သ္ထာပယိတုမ် အယတန္တ, ဣတ္ထံ ဝယံ ရောမာနဂရမ် ပြတျဂစ္ဆာမ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","တသ္မာတ် တတြတျား ဘြာတရော'သ္မာကမ် အာဂမနဝါရ္တ္တာံ ၑြုတွာ အာပ္ပိယဖရံ တြိၐ္ဋာဝရ္ဏီဉ္စ ယာဝဒ် အဂြေသရား သန္တောသ္မာန် သာက္ၐာတ် ကရ္တ္တုမ် အာဂမန်; တေၐာံ ဒရ္ၑနာတ် ပေါ်လ ဤၑွရံ ဓနျံ ဝဒန် အာၑွာသမ် အာပ္တဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","အသ္မာသု ရောမာနဂရံ ဂတေၐု ၑတသေနာပတိး သရွွာန် ဗန္ဒီန် ပြဓာနသေနာပတေး သမီပေ သမာရ္ပယတ် ကိန္တု ပေါ်လာယ သွရက္ၐကပဒါတိနာ သဟ ပၖထဂ် ဝသ္တုမ် အနုမတိံ ဒတ္တဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","ဒိနတြယာတ် ပရံ ပေါ်လသ္တဒ္ဒေၑသ္ထာန် ပြဓာနယိဟူဒိန အာဟူတဝါန် တတသ္တေၐု သမုပသ္ထိတေၐု သ ကထိတဝါန်, ဟေ ဘြာတၖဂဏ နိဇလောကာနာံ ပူရွွပုရုၐာဏာံ ဝါ ရီတေ ရွိပရီတံ ကိဉ္စန ကရ္မ္မာဟံ နာကရဝံ တထာပိ ယိရူၑာလမနိဝါသိနော လောကာ မာံ ဗန္ဒိံ ကၖတွာ ရောမိလောကာနာံ ဟသ္တေၐု သမရ္ပိတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","ရောမိလောကာ ဝိစာရျျ မမ ပြာဏဟနနာရှံ ကိမပိ ကာရဏံ န ပြာပျ မာံ မောစယိတုမ် အဲစ္ဆန်; ");
INSERT INTO sanbur_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","ကိန္တု ယိဟူဒိလောကာနာမ် အာပတ္တျာ မယာ ကဲသရရာဇသျ သမီပေ ဝိစာရသျ ပြာရ္ထနာ ကရ္တ္တဝျာ ဇာတာ နောစေတ် နိဇဒေၑီယလောကာန် ပြတိ မမ ကောပျဘိယောဂေါ နာသ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","ဧတတ္ကာရဏာဒ် အဟံ ယုၐ္မာန် ဒြၐ္ဋုံ သံလပိတုဉ္စာဟူယမ် ဣသြာယေလွၑီယာနာံ ပြတျာၑာဟေတောဟမ် ဧတေန ၑုင်္ခလေန ဗဒ္ဓေါ'ဘဝမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","တဒါ တေ တမ် အဝါဒိၐုး, ယိဟူဒီယဒေၑာဒ် ဝယံ တွာမဓိ ကိမပိ ပတြံ န ပြာပ္တာ ယေ ဘြာတရး သမာယာတာသ္တေၐာံ ကောပိ တဝ ကာမပိ ဝါရ္တ္တာံ နာဝဒတ် အဘဒြမပိ နာကထယစ္စ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","တဝ မတံ ကိမိတိ ဝယံ တွတ္တး ၑြောတုမိစ္ဆာမး၊ ယဒ် ဣဒံ နဝီနံ မတမုတ္ထိတံ တတ် သရွွတြ သရွွေၐာံ နိကဋေ နိန္ဒိတံ ဇာတမ ဣတိ ဝယံ ဇာနီမး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","တဲသ္တဒရ္ထမ် ဧကသ္မိန် ဒိနေ နိရူပိတေ တသ္မိန် ဒိနေ ဗဟဝ ဧကတြ မိလိတွာ ပေါ်လသျ ဝါသဂၖဟမ် အာဂစ္ဆန် တသ္မာတ် ပေါ်လ အာ ပြာတးကာလာတ် သန္ဓျာကာလံ ယာဝန် မူသာဝျဝသ္ထာဂြန္ထာဒ် ဘဝိၐျဒွါဒိနာံ ဂြန္ထေဘျၑ္စ ယီၑေား ကထာမ် ဥတ္ထာပျ ဤၑွရသျ ရာဇျေ ပြမာဏံ ဒတွာ တေၐာံ ပြဝၖတ္တိံ ဇနယိတုံ စေၐ္ဋိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","ကေစိတ္တု တသျ ကထာံ ပြတျာယန် ကေစိတ္တု န ပြတျာယန်; ");
INSERT INTO sanbur_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","ဧတတ္ကာရဏာတ် တေၐာံ ပရသ္ပရမ် အနဲကျာတ် သရွွေ စလိတဝန္တး; တထာပိ ပေါ်လ ဧတာံ ကထာမေကာံ ကထိတဝါန် ပဝိတြ အာတ္မာ ယိၑယိယသျ ဘဝိၐျဒွက္တု ရွဒနာဒ် အသ္မာကံ ပိတၖပုရုၐေဘျ ဧတာံ ကထာံ ဘဒြံ ကထယာမာသ, ယထာ, ");
INSERT INTO sanbur_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","\"ဥပဂတျ ဇနာနေတာန် တွံ ဘာၐသွ ဝစသ္တွိဒံ၊ ကရ္ဏဲး ၑြောၐျထ ယူယံ ဟိ ကိန္တု ယူယံ န ဘောတ္သျထ၊ နေတြဲ ရ္ဒြက္ၐျထ ယူယဉ္စ ဇ္ဉာတုံ ယူယံ န ၑက္ၐျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","တေ မာနုၐာ ယထာ နေတြဲး ပရိပၑျန္တိ နဲဝ ဟိ၊ ကရ္ဏဲး ရျထာ န ၑၖဏွန္တိ ဗုဓျန္တေ န စ မာနသဲး၊ ဝျာဝရ္တ္တယတ္သု စိတ္တာနိ ကာလေ ကုတြာပိ တေၐု ဝဲ၊ မတ္တသ္တေ မနုဇား သွသ္ထာ ယထာ နဲဝ ဘဝန္တိ စ၊ တထာ တေၐာံ မနုၐျာဏာံ သန္တိ သ္ထူလာ ဟိ ဗုဒ္ဓယး၊ ဗဓိရီဘူတကရ္ဏာၑ္စ ဇာတာၑ္စ မုဒြိတာ ဒၖၑး။ ");
INSERT INTO sanbur_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","အတ ဤၑွရာဒ် ယတ် ပရိတြာဏံ တသျ ဝါရ္တ္တာ ဘိန္နဒေၑီယာနာံ သမီပံ ပြေၐိတာ တဧဝ တာံ ဂြဟီၐျန္တီတိ ယူယံ ဇာနီတ၊ ");
INSERT INTO sanbur_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","ဧတာဒၖၑျာံ ကထာယာံ ကထိတာယာံ သတျာံ ယိဟူဒိနး ပရသ္ပရံ ဗဟုဝိစာရံ ကုရွွန္တော ဂတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","ဣတ္ထံ ပေါ်လး သမ္ပူရ္ဏံ ဝတ္သရဒွယံ ယာဝဒ် ဘာဋကီယေ ဝါသဂၖဟေ ဝသန် ယေ လောကာသ္တသျ သန္နိဓိမ် အာဂစ္ဆန္တိ တာန် သရွွာနေဝ ပရိဂၖဟ္လန်, ");
INSERT INTO sanbur_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","နိရွိဃ္နမ် အတိၑယနိးက္ၐောဘမ် ဤၑွရီယရာဇတွသျ ကထာံ ပြစာရယန် ပြဘော် ယီၑော် ခြီၐ္ဋေ ကထား သမုပါဒိၑတ်၊ ဣတိ။ ");
INSERT INTO sanbur_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","ဤၑွရော နိဇပုတြမဓိ ယံ သုသံဝါဒံ ဘဝိၐျဒွါဒိဘိ ရ္ဓရ္မ္မဂြန္ထေ ပြတိၑြုတဝါန် တံ သုသံဝါဒံ ပြစာရယိတုံ ပၖထက္ကၖတ အာဟူတး ပြေရိတၑ္စ ပြဘော ရျီၑုခြီၐ္ဋသျ သေဝကော ယး ပေါ်လး ");
INSERT INTO sanbur_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","သ ရောမာနဂရသ္ထာန် ဤၑွရပြိယာန် အာဟူတာံၑ္စ ပဝိတြလောကာန် ပြတိ ပတြံ လိခတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","အသ္မာကံ သ ပြဘု ရျီၑုး ခြီၐ္ဋး ၑာရီရိကသမ္ဗန္ဓေန ဒါယူဒေါ ဝံၑောဒ္ဘဝး ");
INSERT INTO sanbur_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","ပဝိတြသျာတ္မနး သမ္ဗန္ဓေန စေၑွရသျ ပြဘာဝဝါန် ပုတြ ဣတိ ၑ္မၑာနာတ် တသျောတ္ထာနေန ပြတိပန္နံ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","အပရံ ယေၐာံ မဓျေ ယီၑုနာ ခြီၐ္ဋေန ယူယမပျာဟူတာသ္တေ 'နျဒေၑီယလောကာသ္တသျ နာမ္နိ ဝိၑွသျ နိဒေၑဂြာဟိဏော ယထာ ဘဝန္တိ ");
INSERT INTO sanbur_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","တဒဘိပြာယေဏ ဝယံ တသ္မာဒ် အနုဂြဟံ ပြေရိတတွပဒဉ္စ ပြာပ္တား၊ ");
INSERT INTO sanbur_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","တာတေနာသ္မာကမ် ဤၑွရေဏ ပြဘုဏာ ယီၑုခြီၐ္ဋေန စ ယုၐ္မဘျမ် အနုဂြဟး ၑာန္တိၑ္စ ပြဒီယေတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","ပြထမတး သရွွသ္မိန် ဇဂတိ ယုၐ္မာကံ ဝိၑွာသသျ ပြကာၑိတတွာဒ် အဟံ ယုၐ္မာကံ သရွွေၐာံ နိမိတ္တံ ယီၑုခြီၐ္ဋသျ နာမ ဂၖဟ္လန် ဤၑွရသျ ဓနျဝါဒံ ကရောမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","အပရမ် ဤၑွရသျ ပြသာဒါဒ် ဗဟုကာလာတ် ပရံ သာမ္ပြတံ ယုၐ္မာကံ သမီပံ ယာတုံ ကထမပိ ယတ် သုယောဂံ ပြာပ္နောမိ, ဧတဒရ္ထံ နိရန္တရံ နာမာနျုစ္စာရယန် နိဇာသု သရွွပြာရ္ထနာသု သရွွဒါ နိဝေဒယာမိ, ");
INSERT INTO sanbur_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ဧတသ္မိန် ယမဟံ တတ္ပုတြီယသုသံဝါဒပြစာရဏေန မနသာ ပရိစရာမိ သ ဤၑွရော မမ သာက္ၐီ ဝိဒျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","ယတော ယုၐ္မာကံ မမ စ ဝိၑွာသေန ဝယမ် ဥဘယေ ယထာ ၑာန္တိယုက္တာ ဘဝါမ ဣတိ ကာရဏာဒ္ ");
INSERT INTO sanbur_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","ယုၐ္မာကံ သ္ထဲရျျကရဏာရ္ထံ ယုၐ္မဘျံ ကိဉ္စိတ္ပရမာရ္ထဒါနဒါနာယ ယုၐ္မာန် သာက္ၐာတ် ကရ္တ္တုံ မဒီယာ ဝါဉ္ဆာ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","ဟေ ဘြာတၖဂဏ ဘိန္နဒေၑီယလောကာနာံ မဓျေ ယဒွတ် တဒွဒ် ယုၐ္မာကံ မဓျေပိ ယထာ ဖလံ ဘုဉ္ဇေ တဒဘိပြာယေဏ မုဟုရ္မုဟု ရျုၐ္မာကံ သမီပံ ဂန္တုမ် ဥဒျတော'ဟံ ကိန္တု ယာဝဒ် အဒျ တသ္မိန် ဂမနေ မမ ဝိဃ္နော ဇာတ ဣတိ ယူယံ ယဒ် အဇ္ဉာတာသ္တိၐ္ဌထ တဒဟမ် ဥစိတံ န ဗုဓျေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","အဟံ သဘျာသဘျာနာံ ဝိဒွဒဝိဒွတာဉ္စ သရွွေၐာမ် ၒဏီ ဝိဒျေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","အတဧဝ ရောမာနိဝါသိနာံ ယုၐ္မာကံ သမီပေ'ပိ ယထာၑက္တိ သုသံဝါဒံ ပြစာရယိတုမ် အဟမ် ဥဒျတောသ္မိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","ယတး ခြီၐ္ဋသျ သုသံဝါဒေါ မမ လဇ္ဇာသ္ပဒံ နဟိ သ ဤၑွရသျ ၑက္တိသွရူပး သန် အာ ယိဟူဒီယေဘျော 'နျဇာတီယာန် ယာဝတ် သရွွဇာတီယာနာံ မဓျေ ယး ကၑ္စိဒ် တတြ ဝိၑွသိတိ တသျဲဝ တြာဏံ ဇနယတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","ယတး ပြတျယသျ သမပရိမာဏမ် ဤၑွရဒတ္တံ ပုဏျံ တတ္သုသံဝါဒေ ပြကာၑတေ၊ တဒဓိ ဓရ္မ္မပုသ္တကေပိ လိခိတမိဒံ \"ပုဏျဝါန် ဇနော ဝိၑွာသေန ဇီဝိၐျတိ\"၊ ");
INSERT INTO sanbur_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","အတဧဝ ယေ မာနဝါး ပါပကရ္မ္မဏာ သတျတာံ ရုန္ဓန္တိ တေၐာံ သရွွသျ ဒုရာစရဏသျာဓရ္မ္မသျ စ ဝိရုဒ္ဓံ သွရ္ဂာဒ် ဤၑွရသျ ကောပး ပြကာၑတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","ယတ ဤၑွရမဓိ ယဒျဒ် ဇ္ဉေယံ တဒ် ဤၑွရး သွယံ တာန် ပြတိ ပြကာၑိတဝါန် တသ္မာတ် တေၐာမ် အဂေါစရံ နဟိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","ဖလတသ္တသျာနန္တၑက္တီၑွရတွာဒီနျဒၖၑျာနျပိ သၖၐ္ဋိကာလမ် အာရဘျ ကရ္မ္မသု ပြကာၑမာနာနိ ဒၖၑျန္တေ တသ္မာတ် တေၐာံ ဒေါၐပြက္ၐာလနသျ ပန္ထာ နာသ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","အပရမ် ဤၑွရံ ဇ္ဉာတွာပိ တေ တမ် ဤၑွရဇ္ဉာနေန နာဒြိယန္တ ကၖတဇ္ဉာ ဝါ န ဇာတား; တသ္မာတ် တေၐာံ သရွွေ တရ္ကာ ဝိဖလီဘူတား, အပရဉ္စ တေၐာံ ဝိဝေကၑူနျာနိ မနာံသိ တိမိရေ မဂ္နာနိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","တေ သွာန် ဇ္ဉာနိနော ဇ္ဉာတွာ ဇ္ဉာနဟီနာ အဘဝန္ ");
INSERT INTO sanbur_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","အနၑွရသျေၑွရသျ ဂေါ်ရဝံ ဝိဟာယ နၑွရမနုၐျပၑုပက္ၐျုရောဂါမိပြဘၖတေရာကၖတိဝိၑိၐ္ဋပြတိမာသ္တဲရာၑြိတား၊ ");
INSERT INTO sanbur_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","ဣတ္ထံ တ ဤၑွရသျ သတျတာံ ဝိဟာယ မၖၐာမတမ် အာၑြိတဝန္တး သစ္စိဒါနန္ဒံ သၖၐ္ဋိကရ္တ္တာရံ တျက္တွာ သၖၐ္ဋဝသ္တုနး ပူဇာံ သေဝါဉ္စ ကၖတဝန္တး; ");
INSERT INTO sanbur_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","ဣတိ ဟေတောရီၑွရသ္တာန် ကုကြိယာယာံ သမရ္ပျ နိဇနိဇကုစိန္တာဘိလာၐာဘျာံ သွံ သွံ ၑရီရံ ပရသ္ပရမ် အပမာနိတံ ကရ္တ္တုမ် အဒဒါတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","ဤၑွရေဏ တေၐု ကွဘိလာၐေ သမရ္ပိတေၐု တေၐာံ ယောၐိတး သွာဘာဝိကာစရဏမ် အပဟာယ ဝိပရီတကၖတျေ ပြာဝရ္တ္တန္တ; ");
INSERT INTO sanbur_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","တထာ ပုရုၐာ အပိ သွာဘာဝိကယောၐိတ္သင်္ဂမံ ဝိဟာယ ပရသ္ပရံ ကာမကၖၑာနုနာ ဒဂ္ဓား သန္တး ပုမာံသး ပုံဘိး သာကံ ကုကၖတျေ သမာသဇျ နိဇနိဇဘြာန္တေး သမုစိတံ ဖလမ် အလဘန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","တေ သွေၐာံ မနးသွီၑွရာယ သ္ထာနံ ဒါတုမ် အနိစ္ဆုကာသ္တတော ဟေတောရီၑွရသ္တာန် ပြတိ ဒုၐ္ဋမနသ္ကတွမ် အဝိဟိတကြိယတွဉ္စ ဒတ္တဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","အတဧဝ တေ သရွွေ 'နျာယော ဝျဘိစာရော ဒုၐ္ဋတွံ လောဘော ဇိဃာံသာ ဤရ္ၐျာ ဝဓော ဝိဝါဒၑ္စာတုရီ ကုမတိရိတျာဒိဘိ ရ္ဒုၐ္ကရ္မ္မဘိး ပရိပူရ္ဏား သန္တး ");
INSERT INTO sanbur_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","ကရ္ဏေဇပါ အပဝါဒိန ဤၑွရဒွေၐကာ ဟိံသကာ အဟင်္ကာရိဏ အာတ္မၑ္လာဃိနး ကုကရ္မ္မောတ္ပာဒကား ပိတြောရာဇ္ဉာလင်္ဃကာ ");
INSERT INTO sanbur_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","အဝိစာရကာ နိယမလင်္ဃိနး သ္နေဟရဟိတာ အတိဒွေၐိဏော နိရ္ဒယာၑ္စ ဇာတား၊ ");
INSERT INTO sanbur_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","ယေ ဇနာ ဧတာဒၖၑံ ကရ္မ္မ ကုရွွန္တိ တဧဝ မၖတိယောဂျာ ဤၑွရသျ ဝိစာရမီဒၖၑံ ဇ္ဉာတွာပိ တ ဧတာဒၖၑံ ကရ္မ္မ သွယံ ကုရွွန္တိ ကေဝလမိတိ နဟိ ကိန္တု တာဒၖၑကရ္မ္မကာရိၐု လောကေၐွပိ ပြီယန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","ဟေ ပရဒူၐက မနုၐျ ယး ကၑ္စန တွံ ဘဝသိ တဝေါတ္တရဒါနာယ ပန္ထာ နာသ္တိ ယတော ယသ္မာတ် ကရ္မ္မဏး ပရသ္တွယာ ဒူၐျတေ တသ္မာတ် တွမပိ ဒူၐျသေ, ယတသ္တံ ဒူၐယန္နပိ တွံ တဒွဒ် အာစရသိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","ကိန္တွေတာဒၖဂါစာရိဘျော ယံ ဒဏ္ဍမ် ဤၑွရော နိၑ္စိနောတိ သ ယထာရ္ထ ဣတိ ဝယံ ဇာနီမး၊ ");
INSERT INTO sanbur_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","အတဧဝ ဟေ မာနုၐ တွံ ယာဒၖဂါစာရိဏော ဒူၐယသိ သွယံ ယဒိ တာဒၖဂါစရသိ တရှိ တွမ် ဤၑွရဒဏ္ဍာတ် ပလာယိတုံ ၑက္ၐျသီတိ ကိံ ဗုဓျသေ? ");
INSERT INTO sanbur_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","အပရံ တဝ မနသး ပရိဝရ္တ္တနံ ကရ္တ္တုမ် ဣၑွရသျာနုဂြဟော ဘဝတိ တန္န ဗုဒ္ဓွာ တွံ ကိံ တဒီယာနုဂြဟက္ၐမာစိရသဟိၐ္ဏုတွနိဓိံ တုစ္ဆီကရောၐိ? ");
INSERT INTO sanbur_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","တထာ သွာန္တးကရဏသျ ကဌောရတွာတ် ခေဒရာဟိတျာစ္စေၑွရသျ နျာယျဝိစာရပြကာၑနသျ ကြောဓသျ စ ဒိနံ ယာဝတ် ကိံ သွာရ္ထံ ကောပံ သဉ္စိနောၐိ? ");
INSERT INTO sanbur_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","ကိန္တု သ ဧကဲကမနုဇာယ တတ္ကရ္မ္မာနုသာရေဏ ပြတိဖလံ ဒါသျတိ; ");
INSERT INTO sanbur_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","ဝသ္တုတသ္တု ယေ ဇနာ ဓဲရျျံ ဓၖတွာ သတ္ကရ္မ္မ ကုရွွန္တော မဟိမာ သတ္ကာရော'မရတွဉ္စဲတာနိ မၖဂယန္တေ တေဘျော'နန္တာယု ရ္ဒာသျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","အပရံ ယေ ဇနား သတျဓရ္မ္မမ် အဂၖဟီတွာ ဝိပရီတဓရ္မ္မမ် ဂၖဟ္လန္တိ တာဒၖၑာ ဝိရောဓိဇနား ကောပံ ကြောဓဉ္စ ဘောက္ၐျန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","အာ ယိဟူဒိနော'နျဒေၑိနး ပရျျန္တံ ယာဝန္တး ကုကရ္မ္မကာရိဏး ပြာဏိနး သန္တိ တေ သရွွေ ဒုးခံ ယာတနာဉ္စ ဂမိၐျန္တိ; ");
INSERT INTO sanbur_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","ကိန္တု အာ ယိဟူဒိနော ဘိန္နဒေၑိပရျျန္တာ ယာဝန္တး သတ္ကရ္မ္မကာရိဏော လောကား သန္တိ တာန် ပြတိ မဟိမာ သတ္ကာရး ၑာန္တိၑ္စ ဘဝိၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","ဤၑွရသျ ဝိစာရေ ပက္ၐပါတော နာသ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","အလဗ္ဓဝျဝသ္ထာၑာသ္တြဲ ရျဲး ပါပါနိ ကၖတာနိ ဝျဝသ္ထာၑာသ္တြာလဗ္ဓတွာနုရူပသ္တေၐာံ ဝိနာၑော ဘဝိၐျတိ; ကိန္တု လဗ္ဓဝျဝသ္ထာၑာသ္တြာ ယေ ပါပါနျကုရွွန် ဝျဝသ္ထာနုသာရာဒေဝ တေၐာံ ဝိစာရော ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","ဝျဝသ္ထာၑြောတာရ ဤၑွရသျ သမီပေ နိၐ္ပာပါ ဘဝိၐျန္တီတိ နဟိ ကိန္တု ဝျဝသ္ထာစာရိဏ ဧဝ သပုဏျာ ဘဝိၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","ယတော 'လဗ္ဓဝျဝသ္ထာၑာသ္တြာ ဘိန္နဒေၑီယလောကာ ယဒိ သွဘာဝတော ဝျဝသ္ထာနုရူပါန် အာစာရာန် ကုရွွန္တိ တရှျလဗ္ဓၑာသ္တြား သန္တော'ပိ တေ သွေၐာံ ဝျဝသ္ထာၑာသ္တြမိဝ သွယမေဝ ဘဝန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","တေၐာံ မနသိ သာက္ၐိသွရူပေ သတိ တေၐာံ ဝိတရ္ကေၐု စ ကဒါ တာန် ဒေါၐိဏး ကဒါ ဝါ နိရ္ဒောၐာန် ကၖတဝတ္သု တေ သွာန္တရ္လိခိတသျ ဝျဝသ္ထာၑာသ္တြသျ ပြမာဏံ သွယမေဝ ဒဒတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","ယသ္မိန် ဒိနေ မယာ ပြကာၑိတသျ သုသံဝါဒသျာနုသာရာဒ် ဤၑွရော ယီၑုခြီၐ္ဋေန မာနုၐာဏာမ် အန္တးကရဏာနာံ ဂူဎာဘိပြာယာန် ဓၖတွာ ဝိစာရယိၐျတိ တသ္မိန် ဝိစာရဒိနေ တတ် ပြကာၑိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","ပၑျ တွံ သွယံ ယိဟူဒီတိ ဝိချာတော ဝျဝသ္ထောပရိ ဝိၑွာသံ ကရောၐိ, ");
INSERT INTO sanbur_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ဤၑွရမုဒ္ဒိၑျ သွံ ၑ္လာဃသေ, တထာ ဝျဝသ္ထယာ ၑိက္ၐိတော ဘူတွာ တသျာဘိမတံ ဇာနာသိ, သရွွာသာံ ကထာနာံ သာရံ ဝိဝိံက္ၐေ, ");
INSERT INTO sanbur_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","အပရံ ဇ္ဉာနသျ သတျတာယာၑ္စာကရသွရူပံ ၑာသ္တြံ မမ သမီပေ ဝိဒျတ အတော 'န္ဓလောကာနာံ မာရ္ဂဒရ္ၑယိတာ ");
INSERT INTO sanbur_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","တိမိရသ္ထိတလောကာနာံ မဓျေ ဒီပ္တိသွရူပေါ'ဇ္ဉာနလောကေဘျော ဇ္ဉာနဒါတာ ၑိၑူနာံ ၑိက္ၐယိတာဟမေဝေတိ မနျသေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","ပရာန် ၑိက္ၐယန် သွယံ သွံ ကိံ န ၑိက္ၐယသိ? ဝသ္တုတၑ္စော်ရျျနိၐေဓဝျဝသ္ထာံ ပြစာရယန် တွံ ကိံ သွယမေဝ စောရယသိ? ");
INSERT INTO sanbur_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","တထာ ပရဒါရဂမနံ ပြတိၐေဓန် သွယံ ကိံ ပရဒါရာန် ဂစ္ဆသိ? တထာ တွံ သွယံ ပြတိမာဒွေၐီ သန် ကိံ မန္ဒိရသျ ဒြဝျာဏိ ဟရသိ? ");
INSERT INTO sanbur_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","ယသ္တွံ ဝျဝသ္ထာံ ၑ္လာဃသေ သ တွံ ကိံ ဝျဝသ္ထာမ် အဝမတျ နေၑွရံ သမ္မနျသေ? ");
INSERT INTO sanbur_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","ၑာသ္တြေ ယထာ လိခတိ \"ဘိန္နဒေၑိနာံ သမီပေ ယုၐ္မာကံ ဒေါၐာဒ် ဤၑွရသျ နာမ္နော နိန္ဒာ ဘဝတိ၊ \" ");
INSERT INTO sanbur_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","ယဒိ ဝျဝသ္ထာံ ပါလယသိ တရှိ တဝ တွက္ဆေဒကြိယာ သဖလာ ဘဝတိ; ယတိ ဝျဝသ္ထာံ လင်္ဃသေ တရှိ တဝ တွက္ဆေဒေါ'တွက္ဆေဒေါ ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","ယတော ဝျဝသ္ထာၑာသ္တြာဒိၐ္ဋဓရ္မ္မကရ္မ္မာစာရီ ပုမာန် အတွက္ဆေဒီ သန္နပိ ကိံ တွက္ဆေဒိနာံ မဓျေ န ဂဏယိၐျတေ? ");
INSERT INTO sanbur_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","ကိန္တု လဗ္ဓၑာသ္တြၑ္ဆိန္နတွက် စ တွံ ယဒိ ဝျဝသ္ထာလင်္ဃနံ ကရောၐိ တရှိ ဝျဝသ္ထာပါလကား သွာဘာဝိကာစ္ဆိန္နတွစော လောကာသ္တွာံ ကိံ န ဒူၐယိၐျန္တိ? ");
INSERT INTO sanbur_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","တသ္မာဒ် ယော ဗာဟျေ ယိဟူဒီ သ ယိဟူဒီ နဟိ တထာင်္ဂသျ ယသ္တွက္ဆေဒး သ တွက္ဆေဒေါ နဟိ; ");
INSERT INTO sanbur_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","ကိန္တု ယော ဇန အာန္တရိကော ယိဟူဒီ သ ဧဝ ယိဟူဒီ အပရဉ္စ ကေဝလလိခိတယာ ဝျဝသ္ထယာ န ကိန္တု မာနသိကော ယသ္တွက္ဆေဒေါ ယသျ စ ပြၑံသာ မနုၐျေဘျော န ဘူတွာ ဤၑွရာဒ် ဘဝတိ သ ဧဝ တွက္ဆေဒး၊ ");
INSERT INTO sanbur_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","အပရဉ္စ ယိဟူဒိနး ကိံ ၑြေၐ္ဌတွံ? တထာ တွက္ဆေဒသျ ဝါ ကိံ ဖလံ? ");
INSERT INTO sanbur_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","သရွွထာ ဗဟူနိ ဖလာနိ သန္တိ, ဝိၑေၐတ ဤၑွရသျ ၑာသ္တြံ တေဘျော'ဒီယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","ကဲၑ္စိဒ် အဝိၑွသနေ ကၖတေ တေၐာမ် အဝိၑွသနာတ် ကိမ် ဤၑွရသျ ဝိၑွာသျတာယာ ဟာနိရုတ္ပတ္သျတေ? ");
INSERT INTO sanbur_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","ကေနာပိ ပြကာရေဏ နဟိ၊ ယဒျပိ သရွွေ မနုၐျာ မိထျာဝါဒိနသ္တထာပီၑွရး သတျဝါဒီ၊ ၑာသ္တြေ ယထာ လိခိတမာသ္တေ, အတသ္တွန္တု သွဝါကျေန နိရ္ဒ္ဒေါၐော ဟိ ဘဝိၐျသိ၊ ဝိစာရေ စဲဝ နိၐ္ပာပေါ ဘဝိၐျသိ န သံၑယး၊ ");
INSERT INTO sanbur_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","အသ္မာကမ် အနျာယေန ယဒီၑွရသျ နျာယး ပြကာၑတေ တရှိ ကိံ ဝဒိၐျာမး? အဟံ မာနုၐာဏာံ ကထာမိဝ ကထာံ ကထယာမိ, ဤၑွရး သမုစိတံ ဒဏ္ဍံ ဒတ္တွာ ကိမ် အနျာယီ ဘဝိၐျတိ? ");
INSERT INTO sanbur_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","ဣတ္ထံ န ဘဝတု, တထာ သတီၑွရး ကထံ ဇဂတော ဝိစာရယိတာ ဘဝိၐျတိ? ");
INSERT INTO sanbur_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","မမ မိထျာဝါကျဝဒနာဒ် ယဒီၑွရသျ သတျတွေန တသျ မဟိမာ ဝရ္ဒ္ဓတေ တရှိ ကသ္မာဒဟံ ဝိစာရေ'ပရာဓိတွေန ဂဏျော ဘဝါမိ? ");
INSERT INTO sanbur_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","မင်္ဂလာရ္ထံ ပါပမပိ ကရဏီယမိတိ ဝါကျံ တွယာ ကုတော နောစျတေ? ကိန္တု ယဲရုစျတေ တေ နိတာန္တံ ဒဏ္ဍသျ ပါတြာဏိ ဘဝန္တိ; တထာပိ တဒွါကျမ် အသ္မာဘိရပျုစျတ ဣတျသ္မာကံ ဂ္လာနိံ ကုရွွန္တး ကိယန္တော လောကာ ဝဒန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","အနျလောကေဘျော ဝယံ ကိံ ၑြေၐ္ဌား? ကဒါစန နဟိ ယတော ယိဟူဒိနော 'နျဒေၑိနၑ္စ သရွွဧဝ ပါပသျာယတ္တာ ဣတျသျ ပြမာဏံ ဝယံ ပူရွွမ် အဒဒါမ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","လိပိ ရျထာသ္တေ, နဲကောပိ ဓာရ္မ္မိကော ဇနး၊ ");
INSERT INTO sanbur_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","တထာ ဇ္ဉာနီၑွရဇ္ဉာနီ မာနဝး ကောပိ နာသ္တိ ဟိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","ဝိမာရ္ဂဂါမိနး သရွွေ သရွွေ ဒုၐ္ကရ္မ္မကာရိဏး၊ ဧကော ဇနောပိ နော တေၐာံ သာဓုကရ္မ္မ ကရောတိ စ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","တထာ တေၐာန္တု ဝဲ ကဏ္ဌာ အနာဝၖတၑ္မၑာနဝတ်၊ သ္တုတိဝါဒံ ပြကုရွွန္တိ ဇိဟွာဘိသ္တေ တု ကေဝလံ၊ တေၐာမောၐ္ဌသျ နိမ္နေ တု ဝိၐံ တိၐ္ဌတိ သရ္ပ္ပဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","မုခံ တေၐာံ ဟိ ၑာပေန ကပဋေန စ ပူရျျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","ရက္တပါတာယ တေၐာံ တု ပဒါနိ က္ၐိပြဂါနိ စ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","ပထိ တေၐာံ မနုၐျာဏာံ နာၑး က္လေၑၑ္စ ကေဝလး၊ ");
INSERT INTO sanbur_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","တေ ဇနာ နဟိ ဇာနန္တိ ပန္ထာနံ သုခဒါယိနံ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","ပရမေၑာဒ် ဘယံ ယတ္တတ် တစ္စက္ၐုၐောရဂေါစရံ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","ဝျဝသ္ထာယာံ ယဒျလ္လိခတိ တဒ် ဝျဝသ္ထာဓီနာန် လောကာန် ဥဒ္ဒိၑျ လိခတီတိ ဝယံ ဇာနီမး၊ တတော မနုၐျမာတြော နိရုတ္တရး သန် ဤၑွရသျ သာက္ၐာဒ် အပရာဓီ ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","အတဧဝ ဝျဝသ္ထာနုရူပဲး ကရ္မ္မဘိး ကၑ္စိဒပိ ပြာဏီၑွရသျ သာက္ၐာတ် သပုဏျီကၖတော ဘဝိတုံ န ၑက္ၐျတိ ယတော ဝျဝသ္ထယာ ပါပဇ္ဉာနမာတြံ ဇာယတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","ကိန္တု ဝျဝသ္ထာယား ပၖထဂ် ဤၑွရေဏ ဒေယံ ယတ် ပုဏျံ တဒ် ဝျဝသ္ထာယာ ဘဝိၐျဒွါဒိဂဏသျ စ ဝစနဲး ပြမာဏီကၖတံ သဒ် ဣဒါနီံ ပြကာၑတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","ယီၑုခြီၐ္ဋေ ဝိၑွာသကရဏာဒ် ဤၑွရေဏ ဒတ္တံ တတ် ပုဏျံ သကလေၐု ပြကာၑိတံ သတ် သရွွာန် ဝိၑွာသိနး ပြတိ ဝရ္တ္တတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","တေၐာံ ကောပိ ပြဘေဒေါ နာသ္တိ, ယတး သရွွဧဝ ပါပိန ဤၑွရီယတေဇောဟီနာၑ္စ ဇာတား၊ ");
INSERT INTO sanbur_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","တ ဤၑွရသျာနုဂြဟာဒ် မူလျံ ဝိနာ ခြီၐ္ဋကၖတေန ပရိတြာဏေန သပုဏျီကၖတာ ဘဝန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","ယသ္မာတ် သွၑောဏိတေန ဝိၑွာသာတ် ပါပနာၑကော ဗလီ ဘဝိတုံ သ ဧဝ ပူရွွမ် ဤၑွရေဏ နိၑ္စိတး, ဣတ္ထမ် ဤၑွရီယသဟိၐ္ဏုတွာတ် ပုရာကၖတပါပါနာံ မာရ္ဇ္ဇနကရဏေ သွီယယာထာရ္ထျံ တေန ပြကာၑျတေ, ");
INSERT INTO sanbur_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","ဝရ္တ္တမာနကာလီယမပိ သွယာထာရ္ထျံ တေန ပြကာၑျတေ, အပရံ ယီၑော် ဝိၑွာသိနံ သပုဏျီကုရွွန္နပိ သ ယာထာရ္ထိကသ္တိၐ္ဌတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","တရှိ ကုတြာတ္မၑ္လာဃာ? သာ ဒူရီကၖတာ; ကယာ ဝျဝသ္ထယာ? ကိံ ကြိယာရူပဝျဝသ္ထယာ? ဣတ္ထံ နဟိ ကိန္တု တတ် ကေဝလဝိၑွာသရူပယာ ဝျဝသ္ထယဲဝ ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","အတဧဝ ဝျဝသ္ထာနုရူပါး ကြိယာ ဝိနာ ကေဝလေန ဝိၑွာသေန မာနဝး သပုဏျီကၖတော ဘဝိတုံ ၑက္နောတီတျသျ ရာဒ္ဓါန္တံ ဒရ္ၑယာမး၊ ");
INSERT INTO sanbur_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","သ ကိံ ကေဝလယိဟူဒိနာမ် ဤၑွရော ဘဝတိ? ဘိန္နဒေၑိနာမ် ဤၑွရော န ဘဝတိ? ဘိန္နဒေၑိနာမပိ ဘဝတိ; ");
INSERT INTO sanbur_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","ယသ္မာဒ် ဧက ဤၑွရော ဝိၑွာသာတ် တွက္ဆေဒိနော ဝိၑွာသေနာတွက္ဆေဒိနၑ္စ သပုဏျီကရိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","တရှိ ဝိၑွာသေန ဝယံ ကိံ ဝျဝသ္ထာံ လုမ္ပာမ? ဣတ္ထံ န ဘဝတု ဝယံ ဝျဝသ္ထာံ သံသ္ထာပယာမ ဧဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","အသ္မာကံ ပူရွွပုရုၐ ဣဗြာဟီမ် ကာယိကကြိယယာ ကိံ လဗ္ဓဝါန် ဧတဒဓိ ကိံ ဝဒိၐျာမး? ");
INSERT INTO sanbur_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","သ ယဒိ နိဇကြိယာဘျး သပုဏျော ဘဝေတ် တရှိ တသျာတ္မၑ္လာဃာံ ကရ္တ္တုံ ပန္ထာ ဘဝေဒိတိ သတျံ, ကိန္တွီၑွရသျ သမီပေ နဟိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","ၑာသ္တြေ ကိံ လိခတိ? ဣဗြာဟီမ် ဤၑွရေ ဝိၑွသနာတ် သ ဝိၑွာသသ္တသ္မဲ ပုဏျာရ္ထံ ဂဏိတော ဗဘူဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","ကရ္မ္မကာရိဏော ယဒ် ဝေတနံ တဒ် အနုဂြဟသျ ဖလံ နဟိ ကိန္တု တေနောပါရ္ဇိတံ မန္တဝျမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","ကိန္တု ယး ပါပိနံ သပုဏျီကရောတိ တသ္မိန် ဝိၑွာသိနး ကရ္မ္မဟီနသျ ဇနသျ ယော ဝိၑွာသး သ ပုဏျာရ္ထံ ဂဏျော ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","အပရံ ယံ ကြိယာဟီနမ် ဤၑွရး သပုဏျီကရောတိ တသျ ဓနျဝါဒံ ဒါယူဒ် ဝရ္ဏယာမာသ, ယထာ, ");
INSERT INTO sanbur_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","သ ဓနျော'ဃာနိ မၖၐ္ဋာနိ ယသျာဂါံသျာဝၖတာနိ စ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","သ စ ဓနျး ပရေၑေန ပါပံ ယသျ န ဂဏျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","ဧၐ ဓနျဝါဒသ္တွက္ဆေဒိနမ် အတွက္ဆေဒိနံ ဝါ ကံ ပြတိ ဘဝတိ? ဣဗြာဟီမော ဝိၑွာသး ပုဏျာရ္ထံ ဂဏိတ ဣတိ ဝယံ ဝဒါမး၊ ");
INSERT INTO sanbur_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","သ ဝိၑွာသသ္တသျ တွက္ဆေဒိတွာဝသ္ထာယာံ ကိမ် အတွက္ဆေဒိတွာဝသ္ထာယာံ ကသ္မိန် သမယေ ပုဏျမိဝ ဂဏိတး? တွက္ဆေဒိတွာဝသ္ထာယာံ နဟိ ကိန္တွတွက္ဆေဒိတွာဝသ္ထာယာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","အပရဉ္စ သ ယတ် သရွွေၐာမ် အတွက္ဆေဒိနာံ ဝိၑွာသိနာမ် အာဒိပုရုၐော ဘဝေတ်, တေ စ ပုဏျဝတ္တွေန ဂဏျေရန်; ");
INSERT INTO sanbur_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","ယေ စ လောကား ကေဝလံ ဆိန္နတွစော န သန္တော 'သ္မတ္ပူရွွပုရုၐ ဣဗြာဟီမ် အဆိန္နတွက် သန် ယေန ဝိၑွာသမာရ္ဂေဏ ဂတဝါန် တေနဲဝ တသျ ပါဒစိဟ္နေန ဂစ္ဆန္တိ တေၐာံ တွက္ဆေဒိနာမပျာဒိပုရုၐော ဘဝေတ် တဒရ္ထမ် အတွက္ဆေဒိနော မာနဝသျ ဝိၑွာသာတ် ပုဏျမ် ဥတ္ပဒျတ ဣတိ ပြမာဏသွရူပံ တွက္ဆေဒစိဟ္နံ သ ပြာပ္နောတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","ဣဗြာဟီမ် ဇဂတော'ဓိကာရီ ဘဝိၐျတိ ယဲၐာ ပြတိဇ္ဉာ တံ တသျ ဝံၑဉ္စ ပြတိ ပူရွွမ် အကြိယတ သာ ဝျဝသ္ထာမူလိကာ နဟိ ကိန္တု ဝိၑွာသဇနျပုဏျမူလိကာ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","ယတော ဝျဝသ္ထာဝလမ္ဗိနော ယဒျဓိကာရိဏော ဘဝန္တိ တရှိ ဝိၑွာသော ဝိဖလော ဇာယတေ သာ ပြတိဇ္ဉာပိ လုပ္တဲဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","အဓိကန္တု ဝျဝသ္ထာ ကောပံ ဇနယတိ ယတော 'ဝိဒျမာနာယာံ ဝျဝသ္ထာယာမ် အာဇ္ဉာလင်္ဃနံ န သမ္ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","အတဧဝ သာ ပြတိဇ္ဉာ ယဒ် အနုဂြဟသျ ဖလံ ဘဝေတ် တဒရ္ထံ ဝိၑွာသမူလိကာ ယတသ္တထာတွေ တဒွံၑသမုဒါယံ ပြတိ အရ္ထတော ယေ ဝျဝသ္ထယာ တဒွံၑသမ္ဘဝါး ကေဝလံ တာန် ပြတိ နဟိ ကိန္တု ယ ဣဗြာဟီမီယဝိၑွာသေန တတ္သမ္ဘဝါသ္တာနပိ ပြတိ သာ ပြတိဇ္ဉာ သ္ထာသ္နုရ္ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","ယော နိရ္ဇီဝါန် သဇီဝါန် အဝိဒျမာနာနိ ဝသ္တူနိ စ ဝိဒျမာနာနိ ကရောတိ ဣဗြာဟီမော ဝိၑွာသဘူမေသ္တသျေၑွရသျ သာက္ၐာတ် သော'သ္မာကံ သရွွေၐာမ် အာဒိပုရုၐ အာသ္တေ, ယထာ လိခိတံ ဝိဒျတေ, အဟံ တွာံ ဗဟုဇာတီနာမ် အာဒိပုရုၐံ ကၖတွာ နိယုက္တဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","တွဒီယသ္တာဒၖၑော ဝံၑော ဇနိၐျတေ ယဒိဒံ ဝါကျံ ပြတိၑြုတံ တဒနုသာရာဒ် ဣဗြာဟီမ် ဗဟုဒေၑီယလောကာနာမ် အာဒိပုရုၐော ယဒ် ဘဝတိ တဒရ္ထံ သော'နပေက္ၐိတဝျမပျပေက္ၐမာဏော ဝိၑွာသံ ကၖတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","အပရဉ္စ က္ၐီဏဝိၑွာသော န ဘူတွာ ၑတဝတ္သရဝယသ္ကတွာတ် သွၑရီရသျ ဇရာံ သာရာနာမ္နး သွဘာရျျာယာ ရဇောနိဝၖတ္တိဉ္စ တၖဏာယ န မေနေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","အပရမ် အဝိၑွာသာဒ် ဤၑွရသျ ပြတိဇ္ဉာဝစနေ ကမပိ သံၑယံ န စကာရ; ");
INSERT INTO sanbur_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","ကိန္တွီၑွရေဏ ယတ် ပြတိၑြုတံ တတ် သာဓယိတုံ ၑကျတ ဣတိ နိၑ္စိတံ ဝိဇ္ဉာယ ဒၖဎဝိၑွာသး သန် ဤၑွရသျ မဟိမာနံ ပြကာၑယာဉ္စကာရ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","ဣတိ ဟေတောသ္တသျ သ ဝိၑွာသသ္တဒီယပုဏျမိဝ ဂဏယာဉ္စကြေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","ပုဏျမိဝါဂဏျတ တတ် ကေဝလသျ တသျ နိမိတ္တံ လိခိတံ နဟိ, အသ္မာကံ နိမိတ္တမပိ, ");
INSERT INTO sanbur_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","ယတော'သ္မာကံ ပါပနာၑာရ္ထံ သမရ္ပိတော'သ္မာကံ ပုဏျပြာပ္တျရ္ထဉ္စောတ္ထာပိတော'ဘဝတ် ယော'သ္မာကံ ပြဘု ရျီၑုသ္တသျောတ္ထာပယိတရီၑွရေ ");
INSERT INTO sanbur_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","ယဒိ ဝယံ ဝိၑွသာမသ္တရှျသ္မာကမပိ သဧဝ ဝိၑွာသး ပုဏျမိဝ ဂဏယိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","ဝိၑွာသေန သပုဏျီကၖတာ ဝယမ် ဤၑွရေဏ သာရ္ဒ္ဓံ ပြဘုဏာသ္မာကံ ယီၑုခြီၐ္ဋေန မေလနံ ပြာပ္တား၊ ");
INSERT INTO sanbur_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","အပရံ ဝယံ ယသ္မိန် အနုဂြဟာၑြယေ တိၐ္ဌာမသ္တန္မဓျံ ဝိၑွာသမာရ္ဂေဏ တေနဲဝါနီတာ ဝယမ် ဤၑွရီယဝိဘဝပြာပ္တိပြတျာၑယာ သမာနန္ဒာမး၊ ");
INSERT INTO sanbur_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","တတ် ကေဝလံ နဟိ ကိန္တု က္လေၑဘောဂေ'ပျာနန္ဒာမော ယတး က္လေၑာाဒ် ဓဲရျျံ ဇာယတ ဣတိ ဝယံ ဇာနီမး, ");
INSERT INTO sanbur_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ဓဲရျျာစ္စ ပရီက္ၐိတတွံ ဇာယတေ, ပရီက္ၐိတတွာတ် ပြတျာၑာ ဇာယတေ, ");
INSERT INTO sanbur_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","ပြတျာၑာတော ဝြီဍိတတွံ န ဇာယတေ, ယသ္မာဒ် အသ္မဘျံ ဒတ္တေန ပဝိတြေဏာတ္မနာသ္မာကမ် အန္တးကရဏာနီၑွရသျ ပြေမဝါရိဏာ သိက္တာနိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","အသ္မာသု နိရုပါယေၐု သတ္သု ခြီၐ္ဋ ဥပယုက္တေ သမယေ ပါပိနာံ နိမိတ္တံ သွီယာန် ပြဏာန် အတျဇတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","ဟိတကာရိဏော ဇနသျ ကၖတေ ကောပိ ပြဏာန် တျက္တုံ သာဟသံ ကရ္တ္တုံ ၑက္နောတိ, ကိန္တု ဓာရ္မ္မိကသျ ကၖတေ ပြာယေဏ ကောပိ ပြာဏာန် န တျဇတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","ကိန္တွသ္မာသု ပါပိၐု သတ္သွပိ နိမိတ္တမသ္မာကံ ခြီၐ္ဋး သွပြာဏာန် တျက္တဝါန်, တတ ဤၑွရောသ္မာန် ပြတိ နိဇံ ပရမပြေမာဏံ ဒရ္ၑိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","အတဧဝ တသျ ရက္တပါတေန သပုဏျီကၖတာ ဝယံ နိတာန္တံ တေန ကောပါဒ် ဥဒ္ဓါရိၐျာမဟေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","ဖလတော ဝယံ ယဒါ ရိပဝ အာသ္မ တဒေၑွရသျ ပုတြသျ မရဏေန တေန သာရ္ဒ္ဓံ ယဒျသ္မာကံ မေလနံ ဇာတံ တရှိ မေလနပြာပ္တား သန္တော'ဝၑျံ တသျ ဇီဝနေန ရက္ၐာံ လပ္သျာမဟေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","တတ် ကေဝလံ နဟိ ကိန္တု ယေန မေလနမ် အလဘာမဟိ တေနာသ္မာကံ ပြဘုဏာ ယီၑုခြီၐ္ဋေန သာမ္ပြတမ် ဤၑွရေ သမာနန္ဒာမၑ္စ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","တထာ သတိ, ဧကေန မာနုၐေဏ ပါပံ ပါပေန စ မရဏံ ဇဂတီံ ပြာဝိၑတ် အပရံ သရွွေၐာံ ပါပိတွာတ် သရွွေ မာနုၐာ မၖတေ ရ္နိဃ္နာ အဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","ယတော ဝျဝသ္ထာဒါနသမယံ ယာဝတ် ဇဂတိ ပါပမ် အာသီတ် ကိန္တု ယတြ ဝျဝသ္ထာ န ဝိဒျတေ တတြ ပါပသျာပိ ဂဏနာ န ဝိဒျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","တထာပျာဒမာ ယာဒၖၑံ ပါပံ ကၖတံ တာဒၖၑံ ပါပံ ယဲ ရ္နာကာရိ အာဒမမ် အာရဘျ မူသာံ ယာဝတ် တေၐာမပျုပရိ မၖတျူ ရာဇတွမ် အကရောတ် သ အာဒမ် ဘာဝျာဒမော နိဒရ္ၑနမေဝါသ္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","ကိန္တု ပါပကရ္မ္မဏော ယာဒၖၑော ဘာဝသ္တာဒၖဂ် ဒါနကရ္မ္မဏော ဘာဝေါ န ဘဝတိ ယတ ဧကသျ ဇနသျာပရာဓေန ယဒိ ဗဟူနာံ မရဏမ် အဃဋတ တထာပီၑွရာနုဂြဟသ္တဒနုဂြဟမူလကံ ဒါနဉ္စဲကေန ဇနေနာရ္ထာဒ် ယီၑုနာ ခြီၐ္ဋေန ဗဟုၐု ဗာဟုလျာတိဗာဟုလျေန ဖလတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","အပရမ် ဧကသျ ဇနသျ ပါပကရ္မ္မ ယာဒၖက် ဖလယုက္တံ ဒါနကရ္မ္မ တာဒၖက် န ဘဝတိ ယတော ဝိစာရကရ္မ္မဲကံ ပါပမ် အာရဘျ ဒဏ္ဍဇနကံ ဗဘူဝ, ကိန္တု ဒါနကရ္မ္မ ဗဟုပါပါနျာရဘျ ပုဏျဇနကံ ဗဘူဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","ယတ ဧကသျ ဇနသျ ပါပကရ္မ္မတသ္တေနဲကေန ယဒိ မရဏသျ ရာဇတွံ ဇာတံ တရှိ ယေ ဇနာ အနုဂြဟသျ ဗာဟုလျံ ပုဏျဒါနဉ္စ ပြာပ္နုဝန္တိ တ ဧကေန ဇနေန, အရ္ထာတ် ယီၑုခြီၐ္ဋေန, ဇီဝနေ ရာဇတွမ် အဝၑျံ ကရိၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","ဧကော'ပရာဓော ယဒွတ် သရွွမာနဝါနာံ ဒဏ္ဍဂါမီ မာရ္ဂော 'ဘဝတ် တဒွဒ် ဧကံ ပုဏျဒါနံ သရွွမာနဝါနာံ ဇီဝနယုက္တပုဏျဂါမီ မာရ္ဂ ဧဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","အပရမ် ဧကသျ ဇနသျာဇ္ဉာလင်္ဃနာဒ် ယထာ ဗဟဝေါ 'ပရာဓိနော ဇာတာသ္တဒွဒ် ဧကသျာဇ္ဉာစရဏာဒ် ဗဟဝး သပုဏျီကၖတာ ဘဝန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","အဓိကန္တု ဝျဝသ္ထာဂမနာဒ် အပရာဓသျ ဗာဟုလျံ ဇာတံ ကိန္တု ယတြ ပါပသျ ဗာဟုလျံ တတြဲဝ တသ္မာဒ် အနုဂြဟသျ ဗာဟုလျမ် အဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","တေန မၖတျုနာ ယဒွတ် ပါပသျ ရာဇတွမ် အဘဝတ် တဒွဒ် အသ္မာကံ ပြဘုယီၑုခြီၐ္ဋဒွါရာနန္တဇီဝနဒါယိပုဏျေနာနုဂြဟသျ ရာဇတွံ ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","ပြဘူတရူပေဏ ယဒ် အနုဂြဟး ပြကာၑတေ တဒရ္ထံ ပါပေ တိၐ္ဌာမ ဣတိ ဝါကျံ ကိံ ဝယံ ဝဒိၐျာမး? တန္န ဘဝတု၊ ");
INSERT INTO sanbur_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","ပါပံ ပြတိ မၖတာ ဝယံ ပုနသ္တသ္မိန် ကထမ် ဇီဝိၐျာမး? ");
INSERT INTO sanbur_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","ဝယံ ယာဝန္တော လောကာ ယီၑုခြီၐ္ဋေ မဇ္ဇိတာ အဘဝါမ တာဝန္တ ဧဝ တသျ မရဏေ မဇ္ဇိတာ ဣတိ ကိံ ယူယံ န ဇာနီထ? ");
INSERT INTO sanbur_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","တတော ယထာ ပိတုး ပရာကြမေဏ ၑ္မၑာနာတ် ခြီၐ္ဋ ဥတ္ထာပိတသ္တထာ ဝယမပိ ယတ် နူတနဇီဝိန ဣဝါစရာမသ္တဒရ္ထံ မဇ္ဇနေန တေန သာရ္ဒ္ဓံ မၖတျုရူပေ ၑ္မၑာနေ သံသ္ထာပိတား၊ ");
INSERT INTO sanbur_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","အပရံ ဝယံ ယဒိ တေန သံယုက္တား သန္တး သ ဣဝ မရဏဘာဂိနော ဇာတာသ္တရှိ သ ဣဝေါတ္ထာနဘာဂိနော'ပိ ဘဝိၐျာမး၊ ");
INSERT INTO sanbur_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","ဝယံ ယတ် ပါပသျ ဒါသား ပုန ရ္န ဘဝါမသ္တဒရ္ထမ် အသ္မာကံ ပါပရူပၑရီရသျ ဝိနာၑာရ္ထမ် အသ္မာကံ ပုရာတနပုရုၐသ္တေန သာကံ ကြုၑေ'ဟနျတေတိ ဝယံ ဇာနီမး၊ ");
INSERT INTO sanbur_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","ယော ဟတး သ ပါပါတ် မုက္တ ဧဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","အတဧဝ ယဒိ ဝယံ ခြီၐ္ဋေန သာရ္ဒ္ဓမ် အဟနျာမဟိ တရှိ ပုနရပိ တေန သဟိတာ ဇီဝိၐျာမ ဣတျတြာသ္မာကံ ဝိၑွာသော ဝိဒျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","ယတး ၑ္မၑာနာဒ် ဥတ္ထာပိတး ခြီၐ္ဋော ပုန ရ္န မြိယတ ဣတိ ဝယံ ဇာနီမး၊ တသ္မိန် ကောပျဓိကာရော မၖတျော ရ္နာသ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","အပရဉ္စ သ ယဒ် အမြိယတ တေနဲကဒါ ပါပမ် ဥဒ္ဒိၑျာမြိယတ, ယစ္စ ဇီဝတိ တေနေၑွရမ် ဥဒ္ဒိၑျ ဇီဝတိ; ");
INSERT INTO sanbur_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","တဒွဒ် ယူယမပိ သွာန် ပါပမ် ဥဒ္ဒိၑျ မၖတာန် အသ္မာကံ ပြဘုဏာ ယီၑုခြီၐ္ဋေနေၑွရမ် ဥဒ္ဒိၑျ ဇီဝန္တော ဇာနီတ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","အပရဉ္စ ကုတ္သိတာဘိလာၐာाန် ပူရယိတုံ ယုၐ္မာကံ မရ္တျဒေဟေၐု ပါပမ် အာဓိပတျံ န ကရောတု၊ ");
INSERT INTO sanbur_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","အပရံ သွံ သွမ် အင်္ဂမ် အဓရ္မ္မသျာသ္တြံ ကၖတွာ ပါပသေဝါယာံ န သမရ္ပယတ, ကိန္တု ၑ္မၑာနာဒ် ဥတ္ထိတာနိဝ သွာန် ဤၑွရေ သမရ္ပယတ သွာနျင်္ဂါနိ စ ဓရ္မ္မာသ္တြသွရူပါဏီၑွရမ် ဥဒ္ဒိၑျ သမရ္ပယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","ယုၐ္မာကမ် ဥပရိ ပါပသျာဓိပတျံ ပုန ရ္န ဘဝိၐျတိ, ယသ္မာဒ် ယူယံ ဝျဝသ္ထာယာ အနာယတ္တာ အနုဂြဟသျ စာယတ္တာ အဘဝတ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","ကိန္တု ဝယံ ဝျဝသ္ထာယာ အနာယတ္တာ အနုဂြဟသျ စာယတ္တာ အဘဝါမ, ဣတိ ကာရဏာတ် ကိံ ပါပံ ကရိၐျာမး? တန္န ဘဝတု၊ ");
INSERT INTO sanbur_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","ယတော မၖတိဇနကံ ပါပံ ပုဏျဇနကံ နိဒေၑာစရဏဉ္စဲတယောရ္ဒွယော ရျသ္မိန် အာဇ္ဉာပါလနာရ္ထံ ဘၖတျာနိဝ သွာန် သမရ္ပယထ, တသျဲဝ ဘၖတျာ ဘဝထ, ဧတတ် ကိံ ယူယံ န ဇာနီထ? ");
INSERT INTO sanbur_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","အပရဉ္စ ပူရွွံ ယူယံ ပါပသျ ဘၖတျာ အာသ္တေတိ သတျံ ကိန္တု ယသျာံ ၑိက္ၐာရူပါယာံ မူၐာယာံ နိက္ၐိပ္တာ အဘဝတ တသျာ အာကၖတိံ မနောဘိ ရ္လဗ္ဓဝန္တ ဣတိ ကာရဏာဒ် ဤၑွရသျ ဓနျဝါဒေါ ဘဝတု၊ ");
INSERT INTO sanbur_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","ဣတ္ထံ ယူယံ ပါပသေဝါတော မုက္တား သန္တော ဓရ္မ္မသျ ဘၖတျာ ဇာတား၊ ");
INSERT INTO sanbur_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","ယုၐ္မာကံ ၑာရီရိကျာ ဒုရ္ဗ္ဗလတာယာ ဟေတော ရ္မာနဝဝဒ် အဟမ် ဧတဒ် ဗြဝီမိ; ပုနး ပုနရဓရ္မ္မကရဏာရ္ထံ ယဒွတ် ပူရွွံ ပါပါမေဓျယော ရ္ဘၖတျတွေ နိဇာင်္ဂါနိ သမာရ္ပယတ တဒွဒ် ဣဒါနီံ သာဓုကရ္မ္မကရဏာရ္ထံ ဓရ္မ္မသျ ဘၖတျတွေ နိဇာင်္ဂါနိ သမရ္ပယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","ယဒါ ယူယံ ပါပသျ ဘၖတျာ အာသ္တ တဒါ ဓရ္မ္မသျ နာယတ္တာ အာသ္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","တရှိ ယာနိ ကရ္မ္မာဏိ ယူယမ် ဣဒါနီံ လဇ္ဇာဇနကာနိ ဗုဓျဓွေ ပူရွွံ တဲ ရျုၐ္မာကံ ကော လာဘ အာသီတ်? တေၐာံ ကရ္မ္မဏာံ ဖလံ မရဏမေဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","ကိန္တု သာမ္ပြတံ ယူယံ ပါပသေဝါတော မုက္တား သန္တ ဤၑွရသျ ဘၖတျာ'ဘဝတ တသ္မာဒ် ယုၐ္မာကံ ပဝိတြတွရူပံ လဘျမ် အနန္တဇီဝနရူပဉ္စ ဖလမ် အာသ္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","ယတး ပါပသျ ဝေတနံ မရဏံ ကိန္တွသ္မာကံ ပြဘုဏာ ယီၑုခြီၐ္ဋေနာနန္တဇီဝနမ် ဤၑွရဒတ္တံ ပါရိတောၐိကမ် အာသ္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","ဟေ ဘြာတၖဂဏ ဝျဝသ္ထာဝိဒး ပြတိ မမေဒံ နိဝေဒနံ၊ ဝိဓိး ကေဝလံ ယာဝဇ္ဇီဝံ မာနဝေါပရျျဓိပတိတွံ ကရောတီတိ ယူယံ ကိံ န ဇာနီထ? ");
INSERT INTO sanbur_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","ယာဝတ္ကာလံ ပတိ ရ္ဇီဝတိ တာဝတ္ကာလမ် ဦဎာ ဘာရျျာ ဝျဝသ္ထယာ တသ္မိန် ဗဒ္ဓါ တိၐ္ဌတိ ကိန္တု ယဒိ ပတိ ရ္မြိယတေ တရှိ သာ နာရီ ပတျု ရွျဝသ္ထာတော မုစျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","ဧတတ္ကာရဏာတ် ပတျုရ္ဇီဝနကာလေ နာရီ ယဒျနျံ ပုရုၐံ ဝိဝဟတိ တရှိ သာ ဝျဘိစာရိဏီ ဘဝတိ ကိန္တု ယဒိ သ ပတိ ရ္မြိယတေ တရှိ သာ တသျာ ဝျဝသ္ထာယာ မုက္တာ သတီ ပုရုၐာန္တရေဏ ဝျူဎာပိ ဝျဘိစာရိဏီ န ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","ဟေ မမ ဘြာတၖဂဏ, ဤၑွရနိမိတ္တံ ယဒသ္မာကံ ဖလံ ဇာယတေ တဒရ္ထံ ၑ္မၑာနာဒ် ဥတ္ထာပိတေန ပုရုၐေဏ သဟ ယုၐ္မာကံ ဝိဝါဟော ယဒ် ဘဝေတ် တဒရ္ထံ ခြီၐ္ဋသျ ၑရီရေဏ ယူယံ ဝျဝသ္ထာံ ပြတိ မၖတဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","ယတော'သ္မာကံ ၑာရီရိကာစရဏသမယေ မရဏနိမိတ္တံ ဖလမ် ဥတ္ပာဒယိတုံ ဝျဝသ္ထယာ ဒူၐိတး ပါပါဘိလာၐော'သ္မာကမ် အင်္ဂေၐု ဇီဝန် အာသီတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","ကိန္တု တဒါ ယသျာ ဝျဝသ္ထာယာ ဝၑေ အာသ္မဟိ သာမ္ပြတံ တာံ ပြတိ မၖတတွာဒ် ဝယံ တသျာ အဓီနတွာတ် မုက္တာ ဣတိ ဟေတောရီၑွရော'သ္မာဘိး ပုရာတနလိခိတာနုသာရာတ် န သေဝိတဝျး ကိန္တု နဝီနသွဘာဝေနဲဝ သေဝိတဝျး ");
INSERT INTO sanbur_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","တရှိ ဝယံ ကိံ ဗြူမး? ဝျဝသ္ထာ ကိံ ပါပဇနိကာ ဘဝတိ? နေတ္ထံ ဘဝတု၊ ဝျဝသ္ထာမ် အဝိဒျမာနာယာံ ပါပံ ကိမ် ဣတျဟံ နာဝေဒံ; ကိဉ္စ လောဘံ မာ ကာရ္ၐီရိတိ စေဒ် ဝျဝသ္ထာဂြန္ထေ လိခိတံ နာဘဝိၐျတ် တရှိ လောဘး ကိမ္ဘူတသ္တဒဟံ နာဇ္ဉာသျံ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","ကိန္တု ဝျဝသ္ထယာ ပါပံ ဆိဒြံ ပြာပျာသ္မာကမ် အန္တး သရွွဝိဓံ ကုတ္သိတာဘိလာၐမ် အဇနယတ်; ယတော ဝျဝသ္ထာယာမ် အဝိဒျမာနာယာံ ပါပံ မၖတံ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","အပရံ ပူရွွံ ဝျဝသ္ထာယာမ် အဝိဒျမာနာယာမ် အဟမ် အဇီဝံ တတး ပရမ် အာဇ္ဉာယာမ် ဥပသ္ထိတာယာမ် ပါပမ် အဇီဝတ် တဒါဟမ် အမြိယေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","ဣတ္ထံ သတိ ဇီဝနနိမိတ္တာ ယာဇ္ဉာ သာ မမ မၖတျုဇနိကာဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","ယတး ပါပံ ဆိဒြံ ပြာပျ ဝျဝသ္ထိတာဒေၑေန မာံ ဝဉ္စယိတွာ တေန မာမ် အဟန်၊ ");
INSERT INTO sanbur_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","အတဧဝ ဝျဝသ္ထာ ပဝိတြာ, အာဒေၑၑ္စ ပဝိတြော နျာယျော ဟိတကာရီ စ ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","တရှိ ယတ် သွယံ ဟိတကၖတ် တတ် ကိံ မမ မၖတျုဇနကမ် အဘဝတ်? နေတ္ထံ ဘဝတု; ကိန္တု ပါပံ ယတ် ပါတကမိဝ ပြကာၑတေ တထာ နိဒေၑေန ပါပံ ယဒတီဝ ပါတကမိဝ ပြကာၑတေ တဒရ္ထံ ဟိတောပါယေန မမ မရဏမ် အဇနယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","ဝျဝသ္ထာတ္မဗောဓိကေတိ ဝယံ ဇာနီမး ကိန္တွဟံ ၑာရီရတာစာရီ ပါပသျ ကြီတကိင်္ကရော ဝိဒျေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","ယတော ယတ် ကရ္မ္မ ကရောမိ တတ် မမ မနော'ဘိမတံ နဟိ; အပရံ ယန် မမ မနော'ဘိမတံ တန္န ကရောမိ ကိန္တု ယဒ် ၒတီယေ တတ် ကရောမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","တထာတွေ ယန် မမာနဘိမတံ တဒ် ယဒိ ကရောမိ တရှိ ဝျဝသ္ထာ သူတ္တမေတိ သွီကရောမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","အတဧဝ သမ္ပြတိ တတ် ကရ္မ္မ မယာ ကြိယတ ဣတိ နဟိ ကိန္တု မမ ၑရီရသ္ထေန ပါပေနဲဝ ကြိယတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","ယတော မယိ, အရ္ထတော မမ ၑရီရေ, ကိမပျုတ္တမံ န ဝသတိ, ဧတဒ် အဟံ ဇာနာမိ; မမေစ္ဆုကတာယာံ တိၐ္ဌန္တျာမပျဟမ် ဥတ္တမကရ္မ္မသာဓနေ သမရ္ထော န ဘဝါမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","ယတော ယာမုတ္တမာံ ကြိယာံ ကရ္တ္တုမဟံ ဝါဉ္ဆာမိ တာံ န ကရောမိ ကိန္တု ယတ် ကုတ္သိတံ ကရ္မ္မ ကရ္တ္တုမ် အနိစ္ဆုကော'သ္မိ တဒေဝ ကရောမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","အတဧဝ ယဒျတ် ကရ္မ္မ ကရ္တ္တုံ မမေစ္ဆာ န ဘဝတိ တဒ် ယဒိ ကရောမိ တရှိ တတ် မယာ န ကြိယတေ, မမာန္တရွရ္တ္တိနာ ပါပေနဲဝ ကြိယတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","ဘဒြံ ကရ္တ္တုမ် ဣစ္ဆုကံ မာံ ယော 'ဘဒြံ ကရ္တ္တုံ ပြဝရ္တ္တယတိ တာဒၖၑံ သွဘာဝမေကံ မယိ ပၑျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","အဟမ် အာန္တရိကပုရုၐေဏေၑွရဝျဝသ္ထာယာံ သန္တုၐ္ဋ အာသေ; ");
INSERT INTO sanbur_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","ကိန္တု တဒွိပရီတံ ယုဓျန္တံ တဒနျမေကံ သွဘာဝံ မဒီယာင်္ဂသ္ထိတံ ပြပၑျာမိ, သ မဒီယာင်္ဂသ္ထိတပါပသွဘာဝသျာယတ္တံ မာံ ကရ္တ္တုံ စေၐ္ဋတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","ဟာ ဟာ ယော'ဟံ ဒုရ္ဘာဂျော မနုဇသ္တံ မာမ် ဧတသ္မာန် မၖတာစ္ဆရီရာတ် ကော နိသ္တာရယိၐျတိ? ");
INSERT INTO sanbur_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","အသ္မာကံ ပြဘုဏာ ယီၑုခြီၐ္ဋေန နိသ္တာရယိတာရမ် ဤၑွရံ ဓနျံ ဝဒါမိ၊ အတဧဝ ၑရီရေဏ ပါပဝျဝသ္ထာယာ မနသာ တု ဤၑွရဝျဝသ္ထာယား သေဝနံ ကရောမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","ယေ ဇနား ခြီၐ္ဋံ ယီၑုမ် အာၑြိတျ ၑာရီရိကံ နာစရန္တ အာတ္မိကမာစရန္တိ တေ'ဓုနာ ဒဏ္ဍာရှာ န ဘဝန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","ဇီဝနဒါယကသျာတ္မနော ဝျဝသ္ထာ ခြီၐ္ဋယီၑုနာ ပါပမရဏယော ရွျဝသ္ထာတော မာမမောစယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","ယသ္မာစ္ဆာရီရသျ ဒုရ္ဗ္ဗလတွာဒ် ဝျဝသ္ထယာ ယတ် ကရ္မ္မာသာဓျမ် ဤၑွရော နိဇပုတြံ ပါပိၑရီရရူပံ ပါပနာၑကဗလိရူပဉ္စ ပြေၐျ တသျ ၑရီရေ ပါပသျ ဒဏ္ဍံ ကုရွွန် တတ္ကရ္မ္မ သာဓိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","တတး ၑာရီရိကံ နာစရိတွာသ္မာဘိရာတ္မိကမ် အာစရဒ္ဘိရွျဝသ္ထာဂြန္ထေ နိရ္ဒ္ဒိၐ္ဋာနိ ပုဏျကရ္မ္မာဏိ သရွွာဏိ သာဓျန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","ယေ ၑာရီရိကာစာရိဏသ္တေ ၑာရီရိကာန် ဝိၐယာန် ဘာဝယန္တိ ယေ စာတ္မိကာစာရိဏသ္တေ အာတ္မနော ဝိၐယာန် ဘာဝယန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","ၑာရီရိကဘာဝသျ ဖလံ မၖတျုး ကိဉ္စာတ္မိကဘာဝသျ ဖလေ ဇီဝနံ ၑာန္တိၑ္စ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","ယတး ၑာရီရိကဘာဝ ဤၑွရသျ ဝိရုဒ္ဓး ၑတြုတာဘာဝ ဧဝ သ ဤၑွရသျ ဝျဝသ္ထာယာ အဓီနော န ဘဝတိ ဘဝိတုဉ္စ န ၑက္နောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","ဧတသ္မာတ် ၑာရီရိကာစာရိၐု တောၐ္ဋုမ် ဤၑွရေဏ န ၑကျံ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","ကိန္တွီၑွရသျာတ္မာ ယဒိ ယုၐ္မာကံ မဓျေ ဝသတိ တရှိ ယူယံ ၑာရီရိကာစာရိဏော န သန္တ အာတ္မိကာစာရိဏော ဘဝထး၊ ယသ္မိန် တု ခြီၐ္ဋသျာတ္မာ န ဝိဒျတေ သ တတ္သမ္ဘဝေါ နဟိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","ယဒိ ခြီၐ္ဋော ယုၐ္မာန် အဓိတိၐ္ဌတိ တရှိ ပါပမ် ဥဒ္ဒိၑျ ၑရီရံ မၖတံ ကိန္တု ပုဏျမုဒ္ဒိၑျာတ္မာ ဇီဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","မၖတဂဏာဒ် ယီၑု ရျေနောတ္ထာပိတသ္တသျာတ္မာ ယဒိ ယုၐ္မန္မဓျေ ဝသတိ တရှိ မၖတဂဏာတ် ခြီၐ္ဋသျ သ ဥတ္ထာပယိတာ ယုၐ္မန္မဓျဝါသိနာ သွကီယာတ္မနာ ယုၐ္မာကံ မၖတဒေဟာနပိ ပုန ရ္ဇီဝယိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","ဟေ ဘြာတၖဂဏ ၑရီရသျ ဝယမဓမရ္ဏာ န ဘဝါမော'တး ၑာရီရိကာစာရော'သ္မာဘိ ရ္န ကရ္တ္တဝျး၊ ");
INSERT INTO sanbur_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","ယဒိ ယူယံ ၑရီရိကာစာရိဏော ဘဝေတ တရှိ ယုၐ္မာဘိ ရ္မရ္တ္တဝျမေဝ ကိန္တွာတ္မနာ ယဒိ ၑရီရကရ္မ္မာဏိ ဃာတယေတ တရှိ ဇီဝိၐျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","ယတော ယာဝန္တော လောကာ ဤၑွရသျာတ္မနာကၖၐျန္တေ တေ သရွွ ဤၑွရသျ သန္တာနာ ဘဝန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","ယူယံ ပုနရပိ ဘယဇနကံ ဒါသျဘာဝံ န ပြာပ္တား ကိန္တု ယေန ဘာဝေနေၑွရံ ပိတး ပိတရိတိ ပြောစျ သမ္ဗောဓယထ တာဒၖၑံ ဒတ္တကပုတြတွဘာဝမ် ပြာပ္နုတ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","အပရဉ္စ ဝယမ် ဤၑွရသျ သန္တာနာ ဧတသ္မိန် ပဝိတြ အာတ္မာ သွယမ် အသ္မာကမ် အာတ္မာဘိး သာရ္ဒ္ဓံ ပြမာဏံ ဒဒါတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","အတဧဝ ဝယံ ယဒိ သန္တာနာသ္တရှျဓိကာရိဏး, အရ္ထာဒ် ဤၑွရသျ သွတ္တွာဓိကာရိဏး ခြီၐ္ဋေန သဟာဓိကာရိဏၑ္စ ဘဝါမး; အပရံ တေန သာရ္ဒ္ဓံ ယဒိ ဒုးခဘာဂိနော ဘဝါမသ္တရှိ တသျ ဝိဘဝသျာပိ ဘာဂိနော ဘဝိၐျာမး၊ ");
INSERT INTO sanbur_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","ကိန္တွသ္မာသု ယော ဘာဝီဝိဘဝး ပြကာၑိၐျတေ တသျ သမီပေ ဝရ္တ္တမာနကာလီနံ ဒုးခမဟံ တၖဏာယ မနျေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","ယတး ပြာဏိဂဏ ဤၑွရသျ သန္တာနာနာံ ဝိဘဝပြာပ္တိမ် အာကာင်္က္ၐန် နိတာန္တမ် အပေက္ၐတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","အပရဉ္စ ပြာဏိဂဏး သွဲရမ် အလီကတာယာ ဝၑီကၖတော နာဘဝတ္ ");
INSERT INTO sanbur_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","ကိန္တု ပြာဏိဂဏော'ပိ နၑွရတာဓီနတွာတ် မုက္တး သန် ဤၑွရသျ သန္တာနာနာံ ပရမမုက္တိံ ပြာပ္သျတီတျဘိပြာယေဏ ဝၑီကရ္တြာ ဝၑီစကြေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","အပရဉ္စ ပြသူယမာနာဝဒ် ဝျထိတး သန် ဣဒါနီံ ယာဝတ် ကၖတ္သ္နး ပြာဏိဂဏ အာရ္တ္တသွရံ ကရောတီတိ ဝယံ ဇာနီမး၊ ");
INSERT INTO sanbur_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","ကေဝလး သ ဣတိ နဟိ ကိန္တု ပြထမဇာတဖလသွရူပမ် အာတ္မာနံ ပြာပ္တာ ဝယမပိ ဒတ္တကပုတြတွပဒပြာပ္တိမ် အရ္ထာတ် ၑရီရသျ မုက္တိံ ပြတီက္ၐမာဏာသ္တဒွဒ် အန္တရာရ္တ္တရာဝံ ကုရ္မ္မး၊ ");
INSERT INTO sanbur_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","ဝယံ ပြတျာၑယာ တြာဏမ် အလဘာမဟိ ကိန္တု ပြတျက္ၐဝသ္တုနော ယာ ပြတျာၑာ သာ ပြတျာၑာ နဟိ, ယတော မနုၐျော ယတ် သမီက္ၐတေ တသျ ပြတျာၑာံ ကုတး ကရိၐျတိ? ");
INSERT INTO sanbur_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","ယဒ် အပြတျက္ၐံ တသျ ပြတျာၑာံ ယဒိ ဝယံ ကုရွွီမဟိ တရှိ ဓဲရျျမ် အဝလမ္ဗျ ပြတီက္ၐာမဟေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","တတ အာတ္မာပိ သွယမ် အသ္မာကံ ဒုရ္ဗ္ဗလတာယား သဟာယတွံ ကရောတိ; ယတး ကိံ ပြာရ္ထိတဝျံ တဒ် ဗောဒ္ဓုံ ဝယံ န ၑက္နုမး, ကိန္တွသ္ပၐ္ဋဲရာရ္တ္တရာဝဲရာတ္မာ သွယမ် အသ္မန္နိမိတ္တံ နိဝေဒယတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","အပရမ် ဤၑွရာဘိမတရူပေဏ ပဝိတြလောကာနာံ ကၖတေ နိဝေဒယတိ ယ အာတ္မာ တသျာဘိပြာယော'န္တရျျာမိနာ ဇ္ဉာယတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","အပရမ် ဤၑွရီယနိရူပဏာနုသာရေဏာဟူတား သန္တော ယေ တသ္မိန် ပြီယန္တေ သရွွာဏိ မိလိတွာ တေၐာံ မင်္ဂလံ သာဓယန္တိ, ဧတဒ် ဝယံ ဇာနီမး၊ ");
INSERT INTO sanbur_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","ယတ ဤၑွရော ဗဟုဘြာတၖဏာံ မဓျေ သွပုတြံ ဇျေၐ္ဌံ ကရ္တ္တုမ် ဣစ္ဆန် ယာန် ပူရွွံ လက္ၐျီကၖတဝါန် တာန် တသျ ပြတိမူရ္တျား သာဒၖၑျပြာပ္တျရ္ထံ နျယုံက္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","အပရဉ္စ တေန ယေ နိယုက္တာသ္တ အာဟူတာ အပိ ယေ စ တေနာဟူတာသ္တေ သပုဏျီကၖတား, ယေ စ တေန သပုဏျီကၖတာသ္တေ ဝိဘဝယုက္တား၊ ");
INSERT INTO sanbur_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","ဣတျတြ ဝယံ ကိံ ဗြူမး? ဤၑွရော ယဒျသ္မာကံ သပက္ၐော ဘဝတိ တရှိ ကော ဝိပက္ၐော'သ္မာကံ? ");
INSERT INTO sanbur_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","အာတ္မပုတြံ န ရက္ၐိတွာ ယော'သ္မာကံ သရွွေၐာံ ကၖတေ တံ ပြဒတ္တဝါန် သ ကိံ တေန သဟာသ္မဘျမ် အနျာနိ သရွွာဏိ န ဒါသျတိ? ");
INSERT INTO sanbur_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","ဤၑွရသျာဘိရုစိတေၐု ကေန ဒေါၐ အာရောပယိၐျတေ? ယ ဤၑွရသ္တာန် ပုဏျဝတ ဣဝ ဂဏယတိ ကိံ တေန? ");
INSERT INTO sanbur_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","အပရံ တေဘျော ဒဏ္ဍဒါနာဇ္ဉာ ဝါ ကေန ကရိၐျတေ? ယော'သ္မန္နိမိတ္တံ ပြာဏာန် တျက္တဝါန် ကေဝလံ တန္န ကိန္တု မၖတဂဏမဓျာဒ် ဥတ္ထိတဝါန်, အပိ စေၑွရသျ ဒက္ၐိဏေ ပါရ္ၑွေ တိၐ္ဌန် အဒျာပျသ္မာကံ နိမိတ္တံ ပြာရ္ထတ ဧဝမ္ဘူတော ယး ခြီၐ္ဋး ကိံ တေန? ");
INSERT INTO sanbur_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","အသ္မာဘိး သဟ ခြီၐ္ဋသျ ပြေမဝိစ္ဆေဒံ ဇနယိတုံ ကး ၑက္နောတိ? က္လေၑော ဝျသနံ ဝါ တာဍနာ ဝါ ဒုရ္ဘိက္ၐံ ဝါ ဝသ္တြဟီနတွံ ဝါ ပြာဏသံၑယော ဝါ ခင်္ဂေါ ဝါ ကိမေတာနိ ၑက္နုဝန္တိ? ");
INSERT INTO sanbur_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","ကိန္တု လိခိတမ် အာသ္တေ, ယထာ, ဝယံ တဝ နိမိတ္တံ သ္မော မၖတျုဝက္တြေ'ခိလံ ဒိနံ၊ ဗလိရ္ဒေယော ယထာ မေၐော ဝယံ ဂဏျာမဟေ တထာ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","အပရံ ယော'သ္မာသု ပြီယတေ တေနဲတာသု ဝိပတ္သု ဝယံ သမျဂ် ဝိဇယာမဟေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","ယတော'သ္မာကံ ပြဘုနာ ယီၑုခြီၐ္ဋေနေၑွရသျ ယတ် ပြေမ တသ္မာဒ် အသ္မာကံ ဝိစ္ဆေဒံ ဇနယိတုံ မၖတျု ရ္ဇီဝနံ ဝါ ဒိဝျဒူတာ ဝါ ဗလဝန္တော မုချဒူတာ ဝါ ဝရ္တ္တမာနော ဝါ ဘဝိၐျန် ကာလော ဝါ ဥစ္စပဒံ ဝါ နီစပဒံ ဝါပရံ ကိမပိ သၖၐ္ဋဝသ္တု ");
INSERT INTO sanbur_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ဝဲတေၐာံ ကေနာပိ န ၑကျမိတျသ္မိန် ဒၖဎဝိၑွာသော မမာသ္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","အဟံ ကာဉ္စိဒ် ကလ္ပိတာံ ကထာံ န ကထယာမိ, ခြီၐ္ဋသျ သာက္ၐာတ် သတျမေဝ ဗြဝီမိ ပဝိတြသျာတ္မနး သာက္ၐာန် မဒီယံ မန ဧတတ် သာက္ၐျံ ဒဒါတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","မမာန္တရတိၑယဒုးခံ နိရန္တရံ ခေဒၑ္စ ");
INSERT INTO sanbur_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","တသ္မာဒ် အဟံ သွဇာတီယဘြာတၖဏာံ နိမိတ္တာတ် သွယံ ခြီၐ္ဋာစ္ဆာပါကြာန္တော ဘဝိတုမ် အဲစ္ဆမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","ယတသ္တ ဣသြာယေလသျ ဝံၑာ အပိ စ ဒတ္တကပုတြတွံ တေဇော နိယမော ဝျဝသ္ထာဒါနံ မန္ဒိရေ ဘဇနံ ပြတိဇ္ဉား ပိတၖပုရုၐဂဏၑ္စဲတေၐု သရွွေၐု တေၐာမ် အဓိကာရော'သ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","တတ် ကေဝလံ နဟိ ကိန္တု သရွွာဓျက္ၐး သရွွဒါ သစ္စိဒါနန္ဒ ဤၑွရော ယး ခြီၐ္ဋး သော'ပိ ၑာရီရိကသမ္ဗန္ဓေန တေၐာံ ဝံၑသမ္ဘဝး၊ ");
INSERT INTO sanbur_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","ဤၑွရသျ ဝါကျံ ဝိဖလံ ဇာတမ် ဣတိ နဟိ ယတ္ကာရဏာဒ် ဣသြာယေလော ဝံၑေ ယေ ဇာတာသ္တေ သရွွေ ဝသ္တုတ ဣသြာယေလီယာ န ဘဝန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","အပရမ် ဣဗြာဟီမော ဝံၑေ ဇာတာ အပိ သရွွေ တသျဲဝ သန္တာနာ န ဘဝန္တိ ကိန္တု ဣသှာကော နာမ္နာ တဝ ဝံၑော ဝိချာတော ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","အရ္ထာတ် ၑာရီရိကသံသရ္ဂာတ် ဇာတား သန္တာနာ ယာဝန္တသ္တာဝန္တ ဧဝေၑွရသျ သန္တာနာ န ဘဝန္တိ ကိန္တု ပြတိၑြဝဏာဒ် ယေ ဇာယန္တေ တဧဝေၑွရဝံၑော ဂဏျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","ယတသ္တတ္ပြတိၑြုတေ ရွာကျမေတတ်, ဧတာဒၖၑေ သမယေ 'ဟံ ပုနရာဂမိၐျာမိ တတ္ပူရွွံ သာရာယား ပုတြ ဧကော ဇနိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","အပရမပိ ဝဒါမိ သွမနော'ဘိလာၐတ ဤၑွရေဏ ယန္နိရူပိတံ တတ် ကရ္မ္မတော နဟိ ကိန္တွာဟွယိတု ရ္ဇာတမေတဒ် ယထာ သိဒ္ဓျတိ ");
INSERT INTO sanbur_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","တဒရ္ထံ ရိဗ္ကာနာမိကယာ ယောၐိတာ ဇနဲကသ္မာဒ် အရ္ထာဒ် အသ္မာကမ် ဣသှာကး ပူရွွပုရုၐာဒ် ဂရ္ဘေ ဓၖတေ တသျား သန္တာနယေား ပြသဝါတ် ပူရွွံ ကိဉ္စ တယေား ၑုဘာၑုဘကရ္မ္မဏး ကရဏာတ် ပူရွွံ ");
INSERT INTO sanbur_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","တာံ ပြတီဒံ ဝါကျမ် ဥက္တံ, ဇျေၐ္ဌး ကနိၐ္ဌံ သေဝိၐျတေ, ");
INSERT INTO sanbur_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","ယထာ လိခိတမ် အာသ္တေ, တထာပျေၐာဝိ န ပြီတွာ ယာကူဗိ ပြီတဝါန် အဟံ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","တရှိ ဝယံ ကိံ ဗြူမး? ဤၑွရး ကိမ် အနျာယကာရီ? တထာ န ဘဝတု၊ ");
INSERT INTO sanbur_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","ယတး သ သွယံ မူသာမ် အဝဒတ်; အဟံ ယသ္မိန် အနုဂြဟံ စိကီရ္ၐာမိ တမေဝါနုဂၖဟ္လာမိ, ယဉ္စ ဒယိတုမ် ဣစ္ဆာမိ တမေဝ ဒယေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","အတဧဝေစ္ဆတာ ယတမာနေန ဝါ မာနဝေန တန္န သာဓျတေ ဒယာကာရိဏေၑွရေဏဲဝ သာဓျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","ဖိရော်ဏိ ၑာသ္တြေ လိခတိ, အဟံ တွဒ္ဒွါရာ မတ္ပရာကြမံ ဒရ္ၑယိတုံ သရွွပၖထိဝျာံ နိဇနာမ ပြကာၑယိတုဉ္စ တွာံ သ္ထာပိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","အတး သ ယမ် အနုဂြဟီတုမ် ဣစ္ဆတိ တမေဝါနုဂၖဟ္လာတိ, ယဉ္စ နိဂြဟီတုမ် ဣစ္ဆတိ တံ နိဂၖဟ္လာတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","ယဒိ ဝဒသိ တရှိ သ ဒေါၐံ ကုတော ဂၖဟ္လာတိ? တဒီယေစ္ဆာယား ပြတိဗန္ဓကတွံ ကရ္တ္တံ ကသျ သာမရ္ထျံ ဝိဒျတေ? ");
INSERT INTO sanbur_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","ဟေ ဤၑွရသျ ပြတိပက္ၐ မရ္တျ တွံ ကး? ဧတာဒၖၑံ မာံ ကုတး သၖၐ္ဋဝါန်? ဣတိ ကထာံ သၖၐ္ဋဝသ္တု သြၐ္ဋြေ ကိံ ကထယိၐျတိ? ");
INSERT INTO sanbur_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","ဧကသ္မာန် မၖတ္ပိဏ္ဍာဒ် ဥတ္ကၖၐ္ဋာပကၖၐ္ဋော် ဒွိဝိဓော် ကလၑော် ကရ္တ္တုံ ကိံ ကုလာလသျ သာမရ္ထျံ နာသ္တိ? ");
INSERT INTO sanbur_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","ဤၑွရး ကောပံ ပြကာၑယိတုံ နိဇၑက္တိံ ဇ္ဉာပယိတုဉ္စေစ္ဆန် ယဒိ ဝိနာၑသျ ယောဂျာနိ ကြောဓဘာဇနာနိ ပြတိ ဗဟုကာလံ ဒီရ္ဃသဟိၐ္ဏုတာမ် အာၑြယတိ; ");
INSERT INTO sanbur_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","အပရဉ္စ ဝိဘဝပြာပ္တျရ္ထံ ပူရွွံ နိယုက္တာနျနုဂြဟပါတြာဏိ ပြတိ နိဇဝိဘဝသျ ဗာဟုလျံ ပြကာၑယိတုံ ကေဝလယိဟူဒိနာံ နဟိ ဘိန္နဒေၑိနာမပိ မဓျာဒ္ ");
INSERT INTO sanbur_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","အသ္မာနိဝ တာနျာဟွယတိ တတြ တဝ ကိံ? ");
INSERT INTO sanbur_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","ဟောၑေယဂြန္ထေ ယထာ လိခိတမ် အာသ္တေ, ယော လောကော မမ နာသီတ် တံ ဝဒိၐျာမိ မဒီယကံ၊ ယာ ဇာတိ ရ္မေ'ပြိယာ စာသီတ် တာံ ဝဒိၐျာမျဟံ ပြိယာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","ယူယံ မဒီယလောကာ န ယတြေတိ ဝါကျမော်စျတ၊ အမရေၑသျ သန္တာနာ ဣတိ ချာသျန္တိ တတြ တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","ဣသြာယေလီယလောကေၐု ယိၑာယိယော'ပိ ဝါစမေတာံ ပြာစာရယတ်, ဣသြာယေလီယဝံၑာနာံ ယာ သံချာ သာ တု နိၑ္စိတံ၊ သမုဒြသိကတာသံချာသမာနာ ယဒိ ဇာယတေ၊ တထာပိ ကေဝလံ လောကဲရလ္ပဲသ္တြာဏံ ဝြဇိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","ယတော နျာယေန သွံ ကရ္မ္မ ပရေၑး သာဓယိၐျတိ၊ ဒေၑေ သဧဝ သံက္ၐေပါန္နိဇံ ကရ္မ္မ ကရိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","ယိၑာယိယော'ပရမပိ ကထယာမာသ, သဲနျာဓျက္ၐပရေၑေန စေတ် ကိဉ္စိန္နောဒၑိၐျတ၊ တဒါ ဝယံ သိဒေါမေဝါဘဝိၐျာမ ဝိနိၑ္စိတံ၊ ယဒွါ ဝယမ် အမောရာယာ အဂမိၐျာမ တုလျတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","တရှိ ဝယံ ကိံ ဝက္ၐျာမး? ဣတရဒေၑီယာ လောကာ အပိ ပုဏျာရ္ထမ် အယတမာနာ ဝိၑွာသေန ပုဏျမ် အလဘန္တ; ");
INSERT INTO sanbur_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","ကိန္တွိသြာယေလ္လောကာ ဝျဝသ္ထာပါလနေန ပုဏျာရ္ထံ ယတမာနာသ္တန် နာလဘန္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","တသျ ကိံ ကာရဏံ? တေ ဝိၑွာသေန နဟိ ကိန္တု ဝျဝသ္ထာယား ကြိယယာ စေၐ္ဋိတွာ တသ္မိန် သ္ခလနဇနကေ ပါၐာဏေ ပါဒသ္ခလနံ ပြာပ္တား၊ ");
INSERT INTO sanbur_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","လိခိတံ ယာဒၖၑမ် အာသ္တေ, ပၑျ ပါဒသ္ခလာရ္ထံ ဟိ သီယောနိ ပြသ္တရန္တထာ၊ ဗာဓာကာရဉ္စ ပါၐာဏံ ပရိသ္ထာပိတဝါနဟမ်၊ ဝိၑွသိၐျတိ ယသ္တတြ သ ဇနော န တြပိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","ဟေ ဘြာတရ ဣသြာယေလီယလောကာ ယတ် ပရိတြာဏံ ပြာပ္နုဝန္တိ တဒဟံ မနသာဘိလၐန် ဤၑွရသျ သမီပေ ပြာရ္ထယေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","ယတ ဤၑွရေ တေၐာံ စေၐ္ဋာ ဝိဒျတ ဣတျတြာဟံ သာက္ၐျသ္မိ; ကိန္တု တေၐာံ သာ စေၐ္ဋာ သဇ္ဉာနာ နဟိ, ");
INSERT INTO sanbur_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","ယတသ္တ ဤၑွရဒတ္တံ ပုဏျမ် အဝိဇ္ဉာယ သွကၖတပုဏျံ သ္ထာပယိတုမ် စေၐ္ဋမာနာ ဤၑွရဒတ္တသျ ပုဏျသျ နိဃ္နတွံ န သွီကုရွွန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","ခြီၐ္ဋ ဧကဲကဝိၑွာသိဇနာယ ပုဏျံ ဒါတုံ ဝျဝသ္ထာယား ဖလသွရူပေါ ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","ဝျဝသ္ထာပါလနေန ယတ် ပုဏျံ တတ် မူသာ ဝရ္ဏယာမာသ, ယထာ, ယော ဇနသ္တာံ ပါလယိၐျတိ သ တဒ္ဒွါရာ ဇီဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","ကိန္တု ပြတျယေန ယတ် ပုဏျံ တဒ် ဧတာဒၖၑံ ဝါကျံ ဝဒတိ, ကး သွရ္ဂမ် အာရုဟျ ခြီၐ္ဋမ် အဝရောဟယိၐျတိ? ");
INSERT INTO sanbur_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","ကော ဝါ ပြေတလောကမ် အဝရုဟျ ခြီၐ္ဋံ မၖတဂဏမဓျာဒ် အာနေၐျတီတိ ဝါက် မနသိ တွယာ န ဂဒိတဝျာ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","တရှိ ကိံ ဗြဝီတိ? တဒ် ဝါကျံ တဝ သမီပသ္ထမ် အရ္ထာတ် တဝ ဝဒနေ မနသိ စာသ္တေ, တစ္စ ဝါကျမ် အသ္မာဘိး ပြစာရျျမာဏံ ဝိၑွာသသျ ဝါကျမေဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","ဝသ္တုတး ပြဘုံ ယီၑုံ ယဒိ ဝဒနေန သွီကရောၐိ, တထေၑွရသ္တံ ၑ္မၑာနာဒ် ဥဒသ္ထာပယဒ် ဣတိ ယဒျန္တးကရဏေန ဝိၑွသိၐိ တရှိ ပရိတြာဏံ လပ္သျသေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","ယသ္မာတ် ပုဏျပြာပ္တျရ္ထမ် အန္တးကရဏေန ဝိၑွသိတဝျံ ပရိတြာဏာရ္ထဉ္စ ဝဒနေန သွီကရ္တ္တဝျံ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","ၑာသ္တြေ ယာဒၖၑံ လိခတိ ဝိၑွသိၐျတိ ယသ္တတြ သ ဇနော န တြပိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","ဣတျတြ ယိဟူဒိနိ တဒနျလောကေ စ ကောပိ ဝိၑေၐော နာသ္တိ ယသ္မာဒ် ယး သရွွေၐာမ် အဒွိတီယး ပြဘုး သ နိဇယာစကာန သရွွာန် ပြတိ ဝဒါနျော ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","ယတး, ယး ကၑ္စိတ် ပရမေၑသျ နာမ္နာ ဟိ ပြာရ္ထယိၐျတေ၊ သ ဧဝ မနုဇော နူနံ ပရိတြာတော ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","ယံ ယေ ဇနာ န ပြတျာယန် တေ တမုဒ္ဒိၑျ ကထံ ပြာရ္ထယိၐျန္တေ? ယေ ဝါ ယသျာချာနံ ကဒါပိ န ၑြုတဝန္တသ္တေ တံ ကထံ ပြတျေၐျန္တိ? အပရံ ယဒိ ပြစာရယိတာရော န တိၐ္ဌန္တိ တဒါ ကထံ တေ ၑြောၐျန္တိ? ");
INSERT INTO sanbur_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","ယဒိ ဝါ ပြေရိတာ န ဘဝန္တိ တဒါ ကထံ ပြစာရယိၐျန္တိ? ယာဒၖၑံ လိခိတမ် အာသ္တေ, ယထာ, မာင်္ဂလိကံ သုသံဝါဒံ ဒဒတျာနီယ ယေ နရား၊ ပြစာရယန္တိ ၑာန္တေၑ္စ သုသံဝါဒံ ဇနာသ္တု ယေ၊ တေၐာံ စရဏပဒ္မါနိ ကီဒၖက် ၑောဘာနွိတာနိ ဟိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","ကိန္တု တေ သရွွေ တံ သုသံဝါဒံ န ဂၖဟီတဝန္တး၊ ယိၑာယိယော ယထာ လိခိတဝါန်၊ အသ္မတ္ပြစာရိတေ ဝါကျေ ဝိၑွာသမကရောဒ္ဓိ ကး၊ ");
INSERT INTO sanbur_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","အတဧဝ ၑြဝဏာဒ် ဝိၑွာသ အဲၑွရဝါကျပြစာရာတ် ၑြဝဏဉ္စ ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","တရှျဟံ ဗြဝီမိ တဲး ကိံ နာၑြာဝိ? အဝၑျမ် အၑြာဝိ, ယသ္မာတ် တေၐာံ ၑဗ္ဒော မဟီံ ဝျာပ္နောဒ် ဝါကျဉ္စ နိခိလံ ဇဂတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","အပရမပိ ဝဒါမိ, ဣသြာယေလီယလောကား ကိမ် ဧတာံ ကထာံ န ဗုဓျန္တေ? ပြထမတော မူသာ ဣဒံ ဝါကျံ ပြောဝါစ, အဟမုတ္တာပယိၐျေ တာန် အဂဏျမာနဝဲရပိ၊ က္လေက္ၐျာမိ ဇာတိမ် ဧတာဉ္စ ပြောန္မတ္တဘိန္နဇာတိဘိး၊ ");
INSERT INTO sanbur_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","အပရဉ္စ ယိၑာယိယော'တိၑယာက္ၐောဘေဏ ကထယာမာသ, ယထာ, အဓိ မာံ ယဲသ္တု နာစေၐ္ဋိ သမ္ပြာပ္တသ္တဲ ရ္ဇနဲရဟံ၊ အဓိ မာံ ယဲ ရ္န သမ္ပၖၐ္ဋံ ဝိဇ္ဉာတသ္တဲ ရ္ဇနဲရဟံ။ ");
INSERT INTO sanbur_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","ကိန္တွိသြာယေလီယလောကာန် အဓိ ကထယာဉ္စကာရ, ယဲရာဇ္ဉာလင်္ဃိဘိ ရ္လောကဲ ရွိရုဒ္ဓံ ဝါကျမုစျတေ၊ တာန် ပြတျေဝ ဒိနံ ကၖတ္သ္နံ ဟသ္တော် ဝိသ္တာရယာမျဟံ။ ");
INSERT INTO sanbur_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","ဤၑွရေဏ သွီကီယလောကာ အပသာရိတာ အဟံ ကိမ် ဤဒၖၑံ ဝါကျံ ဗြဝီမိ? တန္န ဘဝတု ယတော'ဟမပိ ဗိနျာမီနဂေါတြီယ ဣဗြာဟီမဝံၑီယ ဣသြာယေလီယလောကော'သ္မိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","ဤၑွရေဏ ပူရွွံ ယေ ပြဒၖၐ္ဋာသ္တေ သွကီယလောကာ အပသာရိတာ ဣတိ နဟိ၊ အပရမ် ဧလိယောပါချာနေ ၑာသ္တြေ ယလ္လိခိတမ် အာသ္တေ တဒ် ယူယံ ကိံ န ဇာနီထ? ");
INSERT INTO sanbur_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","ဟေ ပရမေၑွရ လောကာသ္တွဒီယား သရွွာ ယဇ္ဉဝေဒီရဘဉ္ဇန် တထာ တဝ ဘဝိၐျဒွါဒိနး သရွွာန် အဃ္နန် ကေဝလ ဧကော'ဟမ် အဝၑိၐ္ဋ အာသေ တေ မမာပိ ပြာဏာန် နာၑယိတုံ စေၐ္ဋနတေ, ဧတာံ ကထာမ် ဣသြာယေလီယလောကာနာံ ဝိရုဒ္ဓမ် ဧလိယ ဤၑွရာယ နိဝေဒယာမာသ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","တတသ္တံ ပြတီၑွရသျောတ္တရံ ကိံ ဇာတံ? ဗာလ္နာမ္နော ဒေဝသျ သာက္ၐာတ် ယဲ ရ္ဇာနူနိ န ပါတိတာနိ တာဒၖၑား သပ္တ သဟသြာဏိ လောကာ အဝၑေၐိတာ မယာ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","တဒွဒ် ဧတသ္မိန် ဝရ္တ္တမာနကာလေ'ပိ အနုဂြဟေဏာဘိရုစိတာသ္တေၐာမ် အဝၑိၐ္ဋား ကတိပယာ လောကား သန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","အတဧဝ တဒ် ယဒျနုဂြဟေဏ ဘဝတိ တရှိ ကြိယယာ န ဘဝတိ နော စေဒ် အနုဂြဟော'နနုဂြဟ ဧဝ, ယဒိ ဝါ ကြိယယာ ဘဝတိ တရှျနုဂြဟေဏ န ဘဝတိ နော စေတ် ကြိယာ ကြိယဲဝ န ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","တရှိ ကိံ? ဣသြာယေလီယလောကာ ယဒ် အမၖဂယန္တ တန္န ပြာပုး၊ ကိန္တွဘိရုစိတလောကာသ္တတ် ပြာပုသ္တဒနျေ သရွွ အန္ဓီဘူတား၊ ");
INSERT INTO sanbur_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","ယထာ လိခိတမ် အာသ္တေ, ဃောရနိဒြာလုတာဘာဝံ ဒၖၐ္ဋိဟီနေ စ လောစနေ၊ ကရ္ဏော် ၑြုတိဝိဟီနော် စ ပြဒဒေါ် တေဘျ ဤၑွရး။ ");
INSERT INTO sanbur_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","ဧတေသ္မိန် ဒါယူဒပိ လိခိတဝါန် ယထာ, အတော ဘုက္တျာသနံ တေၐာမ် ဥန္မာထဝဒ် ဘဝိၐျတိ၊ ဝါ ဝံၑယန္တြဝဒ် ဗာဓာ ဒဏ္ဍဝဒ် ဝါ ဘဝိၐျတိ။ ");
INSERT INTO sanbur_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","ဘဝိၐျန္တိ တထာန္ဓာသ္တေ နေတြဲး ပၑျန္တိ နော ယထာ၊ ဝေပထုး ကဋိဒေၑသျ တေၐာံ နိတျံ ဘဝိၐျတိ။ ");
INSERT INTO sanbur_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","ပတနာရ္ထံ တေ သ္ခလိတဝန္တ ဣတိ ဝါစံ ကိမဟံ ဝဒါမိ? တန္န ဘဝတု ကိန္တု တာန် ဥဒျောဂိနး ကရ္တ္တုံ တေၐာံ ပတနာဒ် ဣတရဒေၑီယလောကဲး ပရိတြာဏံ ပြာပ္တံ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","တေၐာံ ပတနံ ယဒိ ဇဂတော လောကာနာံ လာဘဇနကမ် အဘဝတ် တေၐာံ ဟြာသော'ပိ ယဒိ ဘိန္နဒေၑိနာံ လာဘဇနကော'ဘဝတ် တရှိ တေၐာံ ဝၖဒ္ဓိး ကတိ လာဘဇနိကာ ဘဝိၐျတိ? ");
INSERT INTO sanbur_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","အတော ဟေ အနျဒေၑိနော ယုၐ္မာန် သမ္ဗောဓျ ကထယာမိ နိဇာနာံ ဇ္ဉာတိဗန္ဓူနာံ မနးသူဒျောဂံ ဇနယန် တေၐာံ မဓျေ ကိယတာံ လောကာနာံ ယထာ ပရိတြာဏံ သာဓယာမိ ");
INSERT INTO sanbur_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","တန္နိမိတ္တမ် အနျဒေၑိနာံ နိကဋေ ပြေရိတး သန် အဟံ သွပဒသျ မဟိမာနံ ပြကာၑယာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","တေၐာံ နိဂြဟေဏ ယဒီၑွရေဏ သဟ ဇဂတော ဇနာနာံ မေလနံ ဇာတံ တရှိ တေၐာမ် အနုဂၖဟီတတွံ မၖတဒေဟေ ယထာ ဇီဝနလာဘသ္တဒွတ် ကိံ န ဘဝိၐျတိ? ");
INSERT INTO sanbur_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","အပရံ ပြထမဇာတံ ဖလံ ယဒိ ပဝိတြံ ဘဝတိ တရှိ သရွွမေဝ ဖလံ ပဝိတြံ ဘဝိၐျတိ; တထာ မူလံ ယဒိ ပဝိတြံ ဘဝတိ တရှိ ၑာခါ အပိ တထဲဝ ဘဝိၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","ကိယတီနာံ ၑာခါနာံ ဆေဒနေ ကၖတေ တွံ ဝနျဇိတဝၖက္ၐသျ ၑာခါ ဘူတွာ ယဒိ တစ္ဆာခါနာံ သ္ထာနေ ရောပိတာ သတိ ဇိတဝၖက္ၐီယမူလသျ ရသံ ဘုံက္ၐေ, ");
INSERT INTO sanbur_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","တရှိ တာသာံ ဘိန္နၑာခါနာံ ဝိရုဒ္ဓံ မာံ ဂရွွီး; ယဒိ ဂရွွသိ တရှိ တွံ မူလံ ယန္န ဓာရယသိ ကိန္တု မူလံ တွာံ ဓာရယတီတိ သံသ္မရ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","အပရဉ္စ ယဒိ ဝဒသိ မာံ ရောပယိတုံ တား ၑာခါ ဝိဘန္နာ အဘဝန်; ");
INSERT INTO sanbur_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","ဘဒြမ်, အပြတျယကာရဏာတ် တေ ဝိဘိန္နာ ဇာတာသ္တထာ ဝိၑွာသကာရဏာတ် တွံ ရောပိတော ဇာတသ္တသ္မာဒ် အဟင်္ကာရမ် အကၖတွာ သသာဓွသော ဘဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","ယတ ဤၑွရော ယဒိ သွာဘာဝိကီး ၑာခါ န ရက္ၐတိ တရှိ သာဝဓာနော ဘဝ စေတ် တွာမပိ န သ္ထာပယတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","ဣတျတြေၑွရသျ ယာဒၖၑီ ကၖပါ တာဒၖၑံ ဘယာနကတွမပိ တွယာ ဒၖၑျတာံ; ယေ ပတိတာသ္တာန် ပြတိ တသျ ဘယာနကတွံ ဒၖၑျတာံ, တွဉ္စ ယဒိ တတ္ကၖပါၑြိတသ္တိၐ္ဌသိ တရှိ တွာံ ပြတိ ကၖပါ ဒြက္ၐျတေ; နော စေတ် တွမပိ တဒွတ် ဆိန္နော ဘဝိၐျသိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","အပရဉ္စ တေ ယဒျပြတျယေ န တိၐ္ဌန္တိ တရှိ ပုနရပိ ရောပယိၐျန္တေ ယသ္မာတ် တာန် ပုနရပိ ရောပယိတုမ် ဣၑွရသျ ၑက္တိရာသ္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","ဝနျဇိတဝၖက္ၐသျ ၑာခါ သန် တွံ ယဒိ တတၑ္ဆိန္နော ရီတိဝျတျယေနောတ္တမဇိတဝၖက္ၐေ ရောेेပိတော'ဘဝသ္တရှိ တသျ ဝၖက္ၐသျ သွီယာ ယား ၑာခါသ္တား ကိံ ပုနး သွဝၖက္ၐေ သံလဂိတုံ န ၑက္နုဝန္တိ? ");
INSERT INTO sanbur_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","ဟေ ဘြာတရော ယုၐ္မာကမ် အာတ္မာဘိမာနော ယန္န ဇာယတေ တဒရ္ထံ မမေဒၖၑီ ဝါဉ္ဆာ ဘဝတိ ယူယံ ဧတန္နိဂူဎတတ္တွမ် အဇာနန္တော ယန္န တိၐ္ဌထ; ဝသ္တုတော ယာဝတ္ကာလံ သမ္ပူရ္ဏရူပေဏ ဘိန္နဒေၑိနာံ သံဂြဟော န ဘဝိၐျတိ တာဝတ္ကာလမ် အံၑတွေန ဣသြာယေလီယလောကာနာမ် အန္ဓတာ သ္ထာသျတိ; ");
INSERT INTO sanbur_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","ပၑ္စာတ် တေ သရွွေ ပရိတြာသျန္တေ; ဧတာဒၖၑံ လိခိတမပျာသ္တေ, အာဂမိၐျတိ သီယောနာဒ် ဧကော ယသ္တြာဏဒါယကး၊ အဓရ္မ္မံ ယာကုဗော ဝံၑာတ် သ တု ဒူရီကရိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","တထာ ဒူရီကရိၐျာမိ တေၐာံ ပါပါနျဟံ ယဒါ၊ တဒါ တဲရေဝ သာရ္ဒ္ဓံ မေ နိယမော'ယံ ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","သုသံဝါဒါတ် တေ ယုၐ္မာကံ ဝိပက္ၐာ အဘဝန် ကိန္တွဘိရုစိတတွာတ် တေ ပိတၖလောကာနာံ ကၖတေ ပြိယပါတြာဏိ ဘဝန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","ယတ ဤၑွရသျ ဒါနာဒ် အာဟွာနာဉ္စ ပၑ္စာတ္တာပေါ န ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","အတဧဝ ပူရွွမ် ဤၑွရေ'ဝိၑွာသိနး သန္တော'ပိ ယူယံ ယဒွတ် သမ္ပြတိ တေၐာမ် အဝိၑွာသကာရဏာဒ် ဤၑွရသျ ကၖပါပါတြာဏိ ဇာတာသ္တဒွဒ္ ");
INSERT INTO sanbur_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","ဣဒါနီံ တေ'ဝိၑွာသိနး သန္တိ ကိန္တု ယုၐ္မာဘိ ရ္လဗ္ဓကၖပါကာရဏာတ် တဲရပိ ကၖပါ လပ္သျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","ဤၑွရး သရွွာန် ပြတိ ကၖပါံ ပြကာၑယိတုံ သရွွာန် အဝိၑွာသိတွေန ဂဏယတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","အဟော ဤၑွရသျ ဇ္ဉာနဗုဒ္ဓိရူပယော ရ္ဓနယေား ကီဒၖက် ပြာစုရျျံ၊ တသျ ရာဇၑာသနသျ တတ္တွံ ကီဒၖဂ် အပြာပျံ၊ တသျ မာရ္ဂာၑ္စ ကီဒၖဂ် အနုပလက္ၐျား၊ ");
INSERT INTO sanbur_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","ပရမေၑွရသျ သင်္ကလ္ပံ ကော ဇ္ဉာတဝါန်? တသျ မန္တြီ ဝါ ကော'ဘဝတ်? ");
INSERT INTO sanbur_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","ကော ဝါ တသျောပကာရီ ဘၖတွာ တတ္ကၖတေ တေန ပြတျုပကရ္တ္တဝျး? ");
INSERT INTO sanbur_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","ယတော ဝသ္တုမာတြမေဝ တသ္မာတ် တေန တသ္မဲ စာဘဝတ် တဒီယော မဟိမာ သရွွဒါ ပြကာၑိတော ဘဝတု၊ ဣတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","ဟေ ဘြာတရ ဤၑွရသျ ကၖပယာဟံ ယုၐ္မာန် ဝိနယေ ယူယံ သွံ သွံ ၑရီရံ သဇီဝံ ပဝိတြံ ဂြာဟျံ ဗလိမ် ဤၑွရမုဒ္ဒိၑျ သမုတ္သၖဇတ, ဧၐာ သေဝါ ယုၐ္မာကံ ယောဂျာ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","အပရံ ယူယံ သာံသာရိကာ ဣဝ မာစရတ, ကိန္တု သွံ သွံ သွဘာဝံ ပရာဝရ္တျ နူတနာစာရိဏော ဘဝတ, တတ ဤၑွရသျ နိဒေၑး ကီဒၖဂ် ဥတ္တမော ဂြဟဏီယး သမ္ပူရ္ဏၑ္စေတိ ယုၐ္မာဘိရနုဘာဝိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","ကၑ္စိဒပိ ဇနော ယောဂျတွာဒဓိကံ သွံ န မနျတာံ ကိန္တု ဤၑွရော ယသ္မဲ ပြတျယသျ ယတ္ပရိမာဏမ် အဒဒါတ် သ တဒနုသာရတော ယောဂျရူပံ သွံ မနုတာမ်, ဤၑွရာဒ် အနုဂြဟံ ပြာပ္တး သန် ယုၐ္မာကမ် ဧကဲကံ ဇနမ် ဣတျာဇ္ဉာပယာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","ယတော ယဒွဒသ္မာကမ် ဧကသ္မိန် ၑရီရေ ဗဟူနျင်္ဂါနိ သန္တိ ကိန္တု သရွွေၐာမင်္ဂါနာံ ကာရျျံ သမာနံ နဟိ; ");
INSERT INTO sanbur_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","တဒွဒသ္မာကံ ဗဟုတွေ'ပိ သရွွေ ဝယံ ခြီၐ္ဋေ ဧကၑရီရား ပရသ္ပရမ် အင်္ဂပြတျင်္ဂတွေန ဘဝါမး၊ ");
INSERT INTO sanbur_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","အသ္မာဒ် ဤၑွရာနုဂြဟေဏ ဝိၑေၐံ ဝိၑေၐံ ဒါနမ် အသ္မာသု ပြာပ္တေၐု သတ္သု ကောပိ ယဒိ ဘဝိၐျဒွါကျံ ဝဒတိ တရှိ ပြတျယသျ ပရိမာဏာနုသာရတး သ တဒ် ဝဒတု; ");
INSERT INTO sanbur_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","ယဒွါ ယဒိ ကၑ္စိတ် သေဝနကာရီ ဘဝတိ တရှိ သ တတ္သေဝနံ ကရောတု; အထဝါ ယဒိ ကၑ္စိဒ် အဓျာပယိတာ ဘဝတိ တရှိ သော'ဓျာပယတု; ");
INSERT INTO sanbur_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","တထာ ယ ဥပဒေၐ္ဋာ ဘဝတိ သ ဥပဒိၑတု ယၑ္စ ဒါတာ သ သရလတယာ ဒဒါတု ယသ္တွဓိပတိး သ ယတ္နေနာဓိပတိတွံ ကရောတု ယၑ္စ ဒယာလုး သ ဟၖၐ္ဋမနသာ ဒယတာမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","အပရဉ္စ ယုၐ္မာကံ ပြေမ ကာပဋျဝရ္ဇိတံ ဘဝတု ယဒ် အဘဒြံ တဒ် ၒတီယဓွံ ယစ္စ ဘဒြံ တသ္မိန် အနုရဇျဓွမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","အပရံ ဘြာတၖတွပြေမ္နာ ပရသ္ပရံ ပြီယဓွံ သမာဒရာဒ် ဧကော'ပရဇနံ ၑြေၐ္ဌံ ဇာနီဓွမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","တထာ ကာရျျေ နိရာလသျာ မနသိ စ သောဒျောဂါး သန္တး ပြဘုံ သေဝဓွမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","အပရံ ပြတျာၑာယာမ် အာနန္ဒိတာ ဒုးခသမယေ စ ဓဲရျျယုက္တာ ဘဝတ; ပြာရ္ထနာယာံ သတတံ ပြဝရ္တ္တဓွံ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","ပဝိတြာဏာံ ဒီနတာံ ဒူရီကုရုဓွမ် အတိထိသေဝါယာမ် အနုရဇျဓွမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","ယေ ဇနာ ယုၐ္မာန် တာဍယန္တိ တာန် အာၑိၐံ ဝဒတ ၑာပမ် အဒတ္တွာ ဒဒ္ဓွမာၑိၐမ်၊ ");
INSERT INTO sanbur_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","ယေ ဇနာ အာနန္ဒန္တိ တဲး သာရ္ဒ္ဓမ် အာနန္ဒတ ယေ စ ရုဒန္တိ တဲး သဟ ရုဒိတ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","အပရဉ္စ ယုၐ္မာကံ မနသာံ ပရသ္ပရမ် ဧကောဘာဝေါ ဘဝတု; အပရမ် ဥစ္စပဒမ် အနာကာင်္က္ၐျ နီစလောကဲး သဟာပိ မာရ္ဒဝမ် အာစရတ; သွာန် ဇ္ဉာနိနော န မနျဓွံ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","ပရသ္မာဒ် အပကာရံ ပြာပျာပိ ပရံ နာပကုရုတ၊ သရွွေၐာံ ဒၖၐ္ဋိတော ယတ် ကရ္မ္မောတ္တမံ တဒေဝ ကုရုတ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","ယဒိ ဘဝိတုံ ၑကျတေ တရှိ ယထာၑက္တိ သရွွလောကဲး သဟ နိရွွိရောဓေန ကာလံ ယာပယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","ဟေ ပြိယဗန္ဓဝး, ကသ္မဲစိဒ် အပကာရသျ သမုစိတံ ဒဏ္ဍံ သွယံ န ဒဒ္ဓွံ, ကိန္တွီၑွရီယကြောဓာယ သ္ထာနံ ဒတ္တ ယတော လိခိတမာသ္တေ ပရမေၑွရး ကထယတိ, ဒါနံ ဖလသျ မတ္ကရ္မ္မ သူစိတံ ပြဒဒါမျဟံ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","ဣတိကာရဏာဒ် ရိပု ရျဒိ က္ၐုဓာရ္တ္တသ္တေ တရှိ တံ တွံ ပြဘောဇယ၊ တထာ ယဒိ တၖၐာရ္တ္တး သျာတ် တရှိ တံ ပရိပါယယ၊ တေန တွံ မသ္တကေ တသျ ဇွလဒဂ္နိံ နိဓာသျသိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","ကုကြိယယာ ပရာဇိတာ န သန္တ ဥတ္တမကြိယယာ ကုကြိယာံ ပရာဇယတ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","ယုၐ္မာကမ် ဧကဲကဇနး ၑာသနပဒသျ နိဃ္နော ဘဝတု ယတော ယာနိ ၑာသနပဒါနိ သန္တိ တာနိ သရွွာဏီၑွရေဏ သ္ထာပိတာနိ; ဤၑွရံ ဝိနာ ပဒသ္ထာပနံ န ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","ဣတိ ဟေတေား ၑာသနပဒသျ ယတ် ပြာတိကူလျံ တဒ် ဤၑွရီယနိရူပဏသျ ပြာတိကူလျမေဝ; အပရံ ယေ ပြာတိကူလျမ် အာစရန္တိ တေ သွေၐာံ သမုစိတံ ဒဏ္ဍံ သွယမေဝ ဃဋယန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","ၑာသ္တာ သဒါစာရိဏာံ ဘယပြဒေါ နဟိ ဒုရာစာရိဏာမေဝ ဘယပြဒေါ ဘဝတိ; တွံ ကိံ တသ္မာန် နိရ္ဘယော ဘဝိတုမ် ဣစ္ဆသိ? တရှိ သတ္ကရ္မ္မာစရ, တသ္မာဒ် ယၑော လပ္သျသေ, ");
INSERT INTO sanbur_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","ယတသ္တဝ သဒါစရဏာယ သ ဤၑွရသျ ဘၖတျော'သ္တိ၊ ကိန္တု ယဒိ ကုကရ္မ္မာစရသိ တရှိ တွံ ၑင်္ကသွ ယတး သ နိရရ္ထကံ ခင်္ဂံ န ဓာရယတိ; ကုကရ္မ္မာစာရိဏံ သမုစိတံ ဒဏ္ဍယိတုမ် သ ဤၑွရသျ ဒဏ္ဍဒဘၖတျ ဧဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","အတဧဝ ကေဝလဒဏ္ဍဘယာန္နဟိ ကိန္တု သဒသဒ္ဗေါဓာဒပိ တသျ ဝၑျေန ဘဝိတဝျံ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","ဧတသ္မာဒ် ယုၐ္မာကံ ရာဇကရဒါနမပျုစိတံ ယသ္မာဒ် ယေ ကရံ ဂၖဟ္လန္တိ တ ဤၑွရသျ ကိင်္ကရာ ဘူတွာ သတတမ် ဧတသ္မိန် ကရ္မ္မဏိ နိဝိၐ္ဋာသ္တိၐ္ဌန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","အသ္မာတ် ကရဂြာဟိဏေ ကရံ ဒတ္တ, တထာ ၑုလ္ကဂြာဟိဏေ ၑုလ္ကံ ဒတ္တ, အပရံ ယသ္မာဒ် ဘေတဝျံ တသ္မာဒ် ဗိဘီတ, ယၑ္စ သမာဒရဏီယသ္တံ သမာဒြိယဓွမ်; ဣတ္ထံ ယသျ ယတ် ပြာပျံ တတ် တသ္မဲ ဒတ္တ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","ယုၐ္မာကံ ပရသ္ပရံ ပြေမ ဝိနာ 'နျတ် ကိမပိ ဒေယမ် ၒဏံ န ဘဝတု, ယတော ယး ပရသ္မိန် ပြေမ ကရောတိ တေန ဝျဝသ္ထာ သိဓျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","ဝသ္တုတး ပရဒါရာန် မာ ဂစ္ဆ, နရဟတျာံ မာ ကာရ္ၐီး, စဲရျျံ မာ ကာရ္ၐီး, မိထျာသာက္ၐျံ မာ ဒေဟိ, လောဘံ မာ ကာရ္ၐီး, ဧတား သရွွာ အာဇ္ဉာ ဧတာဘျော ဘိန္နာ ယာ ကာစိဒ် အာဇ္ဉာသ္တိ သာပိ သွသမီပဝါသိနိ သွဝတ် ပြေမ ကုရွွိတျနေန ဝစနေန ဝေဒိတာ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","ယတး ပြေမ သမီပဝါသိနော'ၑုဘံ န ဇနယတိ တသ္မာတ် ပြေမ္နာ သရွွာ ဝျဝသ္ထာ ပါလျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","ပြတျယီဘဝနကာလေ'သ္မာကံ ပရိတြာဏသျ သာမီပျာဒ် ဣဒါနီံ တသျ သာမီပျမ် အဝျဝဟိတံ; အတး သမယံ ဝိဝိစျာသ္မာဘိး သာမ္ပြတမ် အဝၑျမေဝ နိဒြာတော ဇာဂရ္တ္တဝျံ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","ဗဟုတရာ ယာမိနီ ဂတာ ပြဘာတံ သန္နိဓိံ ပြာပ္တံ တသ္မာတ် တာမသီယား ကြိယား ပရိတျဇျာသ္မာဘိ ရွာသရီယာ သဇ္ဇာ ပရိဓာတဝျာ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","အတော ဟေတော ရွယံ ဒိဝါ ဝိဟိတံ သဒါစရဏမ် အာစရိၐျာမး၊ ရင်္ဂရသော မတ္တတွံ လမ္ပဋတွံ ကာမုကတွံ ဝိဝါဒ ဤရ္ၐျာ စဲတာနိ ပရိတျက္ၐျာမး၊ ");
INSERT INTO sanbur_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","ယူယံ ပြဘုယီၑုခြီၐ္ဋရူပံ ပရိစ္ဆဒံ ပရိဓဒ္ဓွံ သုခါဘိလာၐပူရဏာယ ၑာရီရိကာစရဏံ မာစရတ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","ယော ဇနော'ဒၖဎဝိၑွာသသ္တံ ယုၐ္မာကံ သင်္ဂိနံ ကုရုတ ကိန္တု သန္ဒေဟဝိစာရာရ္ထံ နဟိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","ယတော နိၐိဒ္ဓံ ကိမပိ ခါဒျဒြဝျံ နာသ္တိ, ကသျစိဇ္ဇနသျ ပြတျယ ဧတာဒၖၑော ဝိဒျတေ ကိန္တွဒၖဎဝိၑွာသး ကၑ္စိဒပရော ဇနး ကေဝလံ ၑာကံ ဘုင်္က္တံ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","တရှိ ယော ဇနး သာဓာရဏံ ဒြဝျံ ဘုင်္က္တေ သ ဝိၑေၐဒြဝျဘောက္တာရံ နာဝဇာနီယာတ် တထာ ဝိၑေၐဒြဝျဘောက္တာပိ သာဓာရဏဒြဝျဘောက္တာရံ ဒေါၐိဏံ န ကုရျျာတ်, ယသ္မာဒ် ဤၑွရသ္တမ် အဂၖဟ္လာတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","ဟေ ပရဒါသသျ ဒူၐယိတသ္တွံ ကး? နိဇပြဘေား သမီပေ တေန ပဒသ္ထေန ပဒစျုတေန ဝါ ဘဝိတဝျံ သ စ ပဒသ္ထ ဧဝ ဘဝိၐျတိ ယတ ဤၑွရသ္တံ ပဒသ္ထံ ကရ္တ္တုံ ၑက္နောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","အပရဉ္စ ကၑ္စိဇ္ဇနော ဒိနာဒ် ဒိနံ ဝိၑေၐံ မနျတေ ကၑ္စိတ္တုु သရွွာဏိ ဒိနာနိ သမာနာနိ မနျတေ, ဧကဲကော ဇနး သွီယမနသိ ဝိဝိစျ နိၑ္စိနောတု၊ ");
INSERT INTO sanbur_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","ယော ဇနး ကိဉ္စန ဒိနံ ဝိၑေၐံ မနျတေ သ ပြဘုဘက္တျာ တန် မနျတေ, ယၑ္စ ဇနး ကိမပိ ဒိနံ ဝိၑေၐံ န မနျတေ သော'ပိ ပြဘုဘက္တျာ တန္န မနျတေ; အပရဉ္စ ယး သရွွာဏိ ဘက္ၐျဒြဝျာဏိ ဘုင်္က္တေ သ ပြဘုဘက္တယာ တာနိ ဘုင်္က္တေ ယတး သ ဤၑွရံ ဓနျံ ဝက္တိ, ယၑ္စ န ဘုင်္က္တေ သော'ပိ ပြဘုဘက္တျဲဝ န ဘုဉ္ဇာန ဤၑွရံ ဓနျံ ဗြူတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","အပရမ် အသ္မာကံ ကၑ္စိတ် နိဇနိမိတ္တံ ပြာဏာန် ဓာရယတိ နိဇနိမိတ္တံ မြိယတေ ဝါ တန္န; ");
INSERT INTO sanbur_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","ကိန္တု ယဒိ ဝယံ ပြာဏာန် ဓာရယာမသ္တရှိ ပြဘုနိမိတ္တံ ဓာရယာမး, ယဒိ စ ပြာဏာန် တျဇာမသ္တရှျပိ ပြဘုနိမိတ္တံ တျဇာမး, အတဧဝ ဇီဝနေ မရဏေ ဝါ ဝယံ ပြဘောရေဝါသ္မဟေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","ယတော ဇီဝန္တော မၖတာၑ္စေတျုဘယေၐာံ လောကာနာံ ပြဘုတွပြာပ္တျရ္ထံ ခြီၐ္ဋော မၖတ ဥတ္ထိတး ပုနရ္ဇီဝိတၑ္စ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","ကိန္တု တွံ နိဇံ ဘြာတရံ ကုတော ဒူၐယသိ? တထာ တွံ နိဇံ ဘြာတရံ ကုတသ္တုစ္ဆံ ဇာနာသိ? ခြီၐ္ဋသျ ဝိစာရသိံဟာသနသျ သမ္မုခေ သရွွဲရသ္မာဘိရုပသ္ထာတဝျံ; ");
INSERT INTO sanbur_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","ယာဒၖၑံ လိခိတမ် အာသ္တေ, ပရေၑး ၑပထံ ကုရွွန် ဝါကျမေတတ် ပုရာဝဒတ်၊ သရွွော ဇနး သမီပေ မေ ဇာနုပါတံ ကရိၐျတိ၊ ဇိဟွဲကဲကာ တထေၑသျ နိဃ္နတွံ သွီကရိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","အတဧဝ ဤၑွရသမီပေ'သ္မာကမ် ဧကဲကဇနေန နိဇာ ကထာ ကထယိတဝျာ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","ဣတ္ထံ သတိ ဝယမ် အဒျာရဘျ ပရသ္ပရံ န ဒူၐယန္တး သွဘြာတု ရွိဃ္နော ဝျာဃာတော ဝါ ယန္န ဇာယေတ တာဒၖၑီမီဟာံ ကုရ္မ္မဟေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","ကိမပိ ဝသ္တု သွဘာဝတော နာၑုစိ ဘဝတီတျဟံ ဇာနေ တထာ ပြဘုနာ ယီၑုခြီၐ္ဋေနာပိ နိၑ္စိတံ ဇာနေ, ကိန္တု ယော ဇနော ယဒ် ဒြဝျမ် အပဝိတြံ ဇာနီတေ တသျ ကၖတေ တဒ် အပဝိတြမ် အာသ္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","အတဧဝ တဝ ဘက္ၐျဒြဝျေဏ တဝ ဘြာတာ ၑောကာနွိတော ဘဝတိ တရှိ တွံ ဘြာတရံ ပြတိ ပြေမ္နာ နာစရသိ၊ ခြီၐ္ဋော ယသျ ကၖတေ သွပြာဏာန် ဝျယိတဝါန် တွံ နိဇေန ဘက္ၐျဒြဝျေဏ တံ န နာၑယ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","အပရံ ယုၐ္မာကမ် ဥတ္တမံ ကရ္မ္မ နိန္ဒိတံ န ဘဝတု၊ ");
INSERT INTO sanbur_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","ဘက္ၐျံ ပေယဉ္စေၑွရရာဇျသျ သာရော နဟိ, ကိန္တု ပုဏျံ ၑာန္တိၑ္စ ပဝိတြေဏာတ္မနာ ဇာတ အာနန္ဒၑ္စ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","ဧတဲ ရျော ဇနး ခြီၐ္ဋံ သေဝတေ, သ ဧဝေၑွရသျ တုၐ္ဋိကရော မနုၐျဲၑ္စ သုချာတး၊ ");
INSERT INTO sanbur_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","အတဧဝ ယေနာသ္မာကံ သရွွေၐာံ ပရသ္ပရမ် အဲကျံ နိၐ္ဌာ စ ဇာယတေ တဒေဝါသ္မာဘိ ရျတိတဝျံ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","ဘက္ၐျာရ္ထမ် ဤၑွရသျ ကရ္မ္မဏော ဟာနိံ မာ ဇနယတ; သရွွံ ဝသ္တု ပဝိတြမိတိ သတျံ တထာပိ ယော ဇနော ယဒ် ဘုက္တွာ ဝိဃ္နံ လဘတေ တဒရ္ထံ တဒ် ဘဒြံ နဟိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","တဝ မာံသဘက္ၐဏသုရာပါနာဒိဘိး ကြိယာဘိ ရျဒိ တဝ ဘြာတုး ပါဒသ္ခလနံ ဝိဃ္နော ဝါ စာဉ္စလျံ ဝါ ဇာယတေ တရှိ တဒ္ဘေါဇနပါနယောသ္တျာဂေါ ဘဒြး၊ ");
INSERT INTO sanbur_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","ယဒိ တဝ ပြတျယသ္တိၐ္ဌတိ တရှီၑွရသျ ဂေါစရေ သွာန္တရေ တံ ဂေါပယ; ယော ဇနး သွမတေန သွံ ဒေါၐိဏံ န ကရောတိ သ ဧဝ ဓနျး၊ ");
INSERT INTO sanbur_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","ကိန္တု ယး ကၑ္စိတ် သံၑယျ ဘုင်္က္တေ'ရ္ထာတ် န ပြတီတျ ဘုင်္က္တေ, သ ဧဝါဝၑျံ ဒဏ္ဍာရှော ဘဝိၐျတိ, ယတော ယတ် ပြတျယဇံ နဟိ တဒေဝ ပါပမယံ ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","ဗလဝဒ္ဘိရသ္မာဘိ ရ္ဒုရ္ဗ္ဗလာနာံ ဒေါ်ရ္ဗ္ဗလျံ သောဎဝျံ န စ သွေၐာမ် ဣၐ္ဋာစာရ အာစရိတဝျး၊ ");
INSERT INTO sanbur_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","အသ္မာကမ် ဧကဲကော ဇနး သွသမီပဝါသိနော ဟိတာရ္ထံ နိၐ္ဌာရ္ထဉ္စ တသျဲဝေၐ္ဋာစာရမ် အာစရတု၊ ");
INSERT INTO sanbur_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","ယတး ခြီၐ္ဋော'ပိ နိဇေၐ္ဋာစာရံ နာစရိတဝါန်, ယထာ လိခိတမ် အာသ္တေ, တွန္နိန္ဒကဂဏသျဲဝ နိန္ဒာဘိ ရ္နိန္ဒိတော'သ္မျဟံ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","အပရဉ္စ ဝယံ ယတ် သဟိၐ္ဏုတာသာန္တွနယော ရ္ဇနကေန ၑာသ္တြေဏ ပြတျာၑာံ လဘေမဟိ တန္နိမိတ္တံ ပူရွွကာလေ လိခိတာနိ သရွွဝစနာနျသ္မာကမ် ဥပဒေၑာရ္ထမေဝ လိလိခိရေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","သဟိၐ္ဏုတာသာန္တွနယောရာကရော ယ ဤၑွရး သ ဧဝံ ကရောတု ယတ် ပြဘု ရျီၑုခြီၐ္ဋ ဣဝ ယုၐ္မာကမ် ဧကဇနော'နျဇနေန သာရ္ဒ္ဓံ မနသ အဲကျမ် အာစရေတ်; ");
INSERT INTO sanbur_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","ယူယဉ္စ သရွွ ဧကစိတ္တာ ဘူတွာ မုခဲကေနေဝါသ္မတ္ပြဘုယီၑုခြီၐ္ဋသျ ပိတုရီၑွရသျ ဂုဏာန် ကီရ္တ္တယေတ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","အပရမ် ဤၑွရသျ မဟိမ္နး ပြကာၑာရ္ထံ ခြီၐ္ဋော ယထာ ယုၐ္မာန် ပြတျဂၖဟ္လာတ် တထာ ယုၐ္မာကမပျေကော ဇနော'နျဇနံ ပြတိဂၖဟ္လာတု၊ ");
INSERT INTO sanbur_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","ယထာ လိခိတမ် အာသ္တေ, အတော'ဟံ သမ္မုခေ တိၐ္ဌန် ဘိန္နဒေၑနိဝါသိနာံ၊ သ္တုဝံသ္တွာံ ပရိဂါသျာမိ တဝ နာမ္နိ ပရေၑွရ။ ");
INSERT INTO sanbur_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","တသျ ဒယာလုတွာစ္စ ဘိန္နဇာတီယာ ယဒ် ဤၑွရသျ ဂုဏာန် ကီရ္တ္တယေယုသ္တဒရ္ထံ ယီၑုး ခြီၐ္ဋသ္တွက္ဆေဒနိယမသျ နိဃ္နော'ဘဝဒ် ဣတျဟံ ဝဒါမိ၊ ယထာ လိခိတမ် အာသ္တေ, အတော'ဟံ သမ္မုခေ တိၐ္ဌန် ဘိန္နဒေၑနိဝါသိနာံ၊ သ္တုဝံသ္တွာံ ပရိဂါသျာမိ တဝ နာမ္နိ ပရေၑွရ။ ");
INSERT INTO sanbur_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","အပရမပိ လိခိတမ် အာသ္တေ, ဟေ အနျဇာတယော ယူယံ သမံ နန္ဒတ တဇ္ဇနဲး၊ ");
INSERT INTO sanbur_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","ပုနၑ္စ လိခိတမ် အာသ္တေ, ဟေ သရွွဒေၑိနော ယူယံ ဓနျံ ဗြူတ ပရေၑွရံ၊ ဟေ တဒီယနရာ ယူယံ ကုရုဓွံ တတ္ပြၑံသနံ။ ");
INSERT INTO sanbur_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","အပရ ယီၑာယိယော'ပိ လိလေခ, ယီၑယသျ တု ယတ် မူလံ တတ် ပြကာၑိၐျတေ တဒါ၊ သရွွဇာတီယနၖဏာဉ္စ ၑာသကး သမုဒေၐျတိ၊ တတြာနျဒေၑိလောကဲၑ္စ ပြတျာၑာ ပြကရိၐျတေ။ ");
INSERT INTO sanbur_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","အတဧဝ ယူယံ ပဝိတြသျာတ္မနး ပြဘာဝါဒ် ယတ် သမ္ပူရ္ဏာံ ပြတျာၑာံ လပ္သျဓွေ တဒရ္ထံ တတ္ပြတျာၑာဇနက ဤၑွရး ပြတျယေန ယုၐ္မာန် ၑာန္တျာနန္ဒာဘျာံ သမ္ပူရ္ဏာန် ကရောတု၊ ");
INSERT INTO sanbur_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","ဟေ ဘြာတရော ယူယံ သဒ္ဘါဝယုက္တား သရွွပြကာရေဏ ဇ္ဉာနေန စ သမ္ပူရ္ဏား ပရသ္ပရောပဒေၑေ စ တတ္ပရာ ဣတျဟံ နိၑ္စိတံ ဇာနာမိ, ");
INSERT INTO sanbur_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","တထာပျဟံ ယတ် ပြဂလ္ဘတရော ဘဝန် ယုၐ္မာန် ပြဗောဓယာမိ တသျဲကံ ကာရဏမိဒံ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","ဘိန္နဇာတီယား ပဝိတြေဏာတ္မနာ ပါဝိတနဲဝေဒျရူပါ ဘူတွာ ယဒ် ဂြာဟျာ ဘဝေယုသ္တန္နိမိတ္တမဟမ် ဤၑွရသျ သုသံဝါဒံ ပြစာရယိတုံ ဘိန္နဇာတီယာနာံ မဓျေ ယီၑုခြီၐ္ဋသျ သေဝကတွံ ဒါနံ ဤၑွရာတ် လဗ္ဓဝါနသ္မိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","ဤၑွရံ ပြတိ ယီၑုခြီၐ္ဋေန မမ ၑ္လာဃာကရဏသျ ကာရဏမ် အာသ္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","ဘိန္နဒေၑိန အာဇ္ဉာဂြာဟိဏး ကရ္တ္တုံ ခြီၐ္ဋော ဝါကျေန ကြိယယာ စ, အာၑ္စရျျလက္ၐဏဲၑ္စိတြကြိယာဘိး ပဝိတြသျာတ္မနး ပြဘာဝေန စ ယာနိ ကရ္မ္မာဏိ မယာ သာဓိတဝါန်, ");
INSERT INTO sanbur_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","ကေဝလံ တာနျေဝ ဝိနာနျသျ ကသျစိတ် ကရ္မ္မဏော ဝရ္ဏနာံ ကရ္တ္တုံ ပြဂလ္ဘော န ဘဝါမိ၊ တသ္မာတ် အာ ယိရူၑာလမ ဣလ္လူရိကံ ယာဝတ် သရွွတြ ခြီၐ္ဋသျ သုသံဝါဒံ ပြာစာရယံ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","အနျေန နိစိတာယာံ ဘိတ္တာဝဟံ ယန္န နိစိနောမိ တန္နိမိတ္တံ ယတြ ယတြ သ္ထာနေ ခြီၐ္ဋသျ နာမ ကဒါပိ ကေနာပိ န ဇ္ဉာပိတံ တတြ တတြ သုသံဝါဒံ ပြစာရယိတုမ် အဟံ ယတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","ယာဒၖၑံ လိခိတမ် အာသ္တေ, ယဲ ရွာရ္တ္တာ တသျ န ပြာပ္တာ ဒရ္ၑနံ တဲသ္တု လပ္သျတေ၊ ယဲၑ္စ နဲဝ ၑြုတံ ကိဉ္စိတ် ဗောဒ္ဓုံ ၑက္ၐျန္တိ တေ ဇနား။ ");
INSERT INTO sanbur_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","တသ္မာဒ် ယုၐ္မတ္သမီပဂမနာဒ် အဟံ မုဟုရ္မုဟု ရ္နိဝါရိတော'ဘဝံ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","ကိန္တွိဒါနီမ် အတြ ပြဒေၑေၐု မယာ န ဂတံ သ္ထာနံ ကိမပိ နာဝၑိၐျတေ ယုၐ္မတ္သမီပံ ဂန္တုံ ဗဟုဝတ္သရာနာရဘျ မာမကီနာကာင်္က္ၐာ စ ဝိဒျတ ဣတိ ဟေတေား ");
INSERT INTO sanbur_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","သ္ပာနိယာဒေၑဂမနကာလေ'ဟံ ယုၐ္မန္မဓျေန ဂစ္ဆန် ယုၐ္မာန် အာလောကိၐျေ, တတး ပရံ ယုၐ္မတ္သမ္ဘာၐဏေန တၖပ္တိံ ပရိလဘျ တဒ္ဒေၑဂမနာရ္ထံ ယုၐ္မာဘိ ရွိသရ္ဇယိၐျေ, ဤဒၖၑီ မဒီယာ ပြတျာၑာ ဝိဒျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","ကိန္တု သာမ္ပြတံ ပဝိတြလောကာနာံ သေဝနာယ ယိရူၑာလမ္နဂရံ ဝြဇာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","ယတော ယိရူၑာလမသ္ထပဝိတြလောကာနာံ မဓျေ ယေ ဒရိဒြာ အရ္ထဝိၑြာဏနေန တာနုပကရ္တ္တုံ မာကိဒနိယာဒေၑီယာ အာခါယာဒေၑီယာၑ္စ လောကာ အဲစ္ဆန်၊ ");
INSERT INTO sanbur_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","ဧၐာ တေၐာံ သဒိစ္ဆာ ယတသ္တေ တေၐာမ် ၒဏိနး သန္တိ ယတော ဟေတော ရ္ဘိန္နဇာတီယာ ယေၐာံ ပရမာရ္ထသျာံၑိနော ဇာတာ အဲဟိကဝိၐယေ တေၐာမုပကာရသ္တဲး ကရ္တ္တဝျး၊ ");
INSERT INTO sanbur_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","အတော မယာ တတ် ကရ္မ္မ သာဓယိတွာ တသ္မိန် ဖလေ တေဘျး သမရ္ပိတေ ယုၐ္မန္မဓျေန သ္ပာနိယာဒေၑော ဂမိၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","ယုၐ္မတ္သမီပေ မမာဂမနသမယေ ခြီၐ္ဋသျ သုသံဝါဒသျ ပူရ္ဏဝရေဏ သမ္ဗလိတး သန် အဟမ် အာဂမိၐျာမိ ဣတိ မယာ ဇ္ဉာယတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","ဟေ ဘြာတၖဂဏ ပြဘော ရျီၑုခြီၐ္ဋသျ နာမ္နာ ပဝိတြသျာတ္မာနး ပြေမ္နာ စ ဝိနယေ'ဟံ ");
INSERT INTO sanbur_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","ယိဟူဒါဒေၑသ္ထာနာမ် အဝိၑွာသိလောကာနာံ ကရေဘျော ယဒဟံ ရက္ၐာံ လဘေယ မဒီယဲတေန သေဝနကရ္မ္မဏာ စ ယဒ် ယိရူၑာလမသ္ထား ပဝိတြလောကာသ္တုၐျေယုး, ");
INSERT INTO sanbur_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","တဒရ္ထံ ယူယံ မတ္ကၖတ ဤၑွရာယ ပြာရ္ထယမာဏာ ယတဓွံ တေနာဟမ် ဤၑွရေစ္ဆယာ သာနန္ဒံ ယုၐ္မတ္သမီပံ ဂတွာ ယုၐ္မာဘိး သဟိတး ပြာဏာန် အာပျာယိတုံ ပါရယိၐျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","ၑာန္တိဒါယက ဤၑွရော ယုၐ္မာကံ သရွွေၐာံ သင်္ဂီ ဘူယာတ်၊ ဣတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","ကိံကြီယာနဂရီယဓရ္မ္မသမာဇသျ ပရိစာရိကာ ယာ ဖဲဗီနာမိကာသ္မာကံ ဓရ္မ္မဘဂိနီ တသျား ကၖတေ'ဟံ ယုၐ္မာန် နိဝေဒယာမိ, ");
INSERT INTO sanbur_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","ယူယံ တာံ ပြဘုမာၑြိတာံ ဝိဇ္ဉာယ တသျာ အာတိထျံ ပဝိတြလောကာရှံ ကုရုဓွံ, ယုၐ္မတ္တသ္တသျာ ယ ဥပကာရော ဘဝိတုံ ၑက္နောတိ တံ ကုရုဓွံ, ယသ္မာတ် တယာ ဗဟူနာံ မမ စောပကာရး ကၖတး၊ ");
INSERT INTO sanbur_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","အပရဉ္စ ခြီၐ္ဋသျ ယီၑေား ကရ္မ္မဏိ မမ သဟကာရိဏော် မမ ပြာဏရက္ၐာရ္ထဉ္စ သွပြာဏာန် ပဏီကၖတဝန္တော် ယော် ပြိၐ္ကိလ္လာက္ကိလော် တော် မမ နမသ္ကာရံ ဇ္ဉာပယဓွံ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","တာဘျာမ် ဥပကာရာပ္တိး ကေဝလံ မယာ သွီကရ္တ္တဝျေတိ နဟိ ဘိန္နဒေၑီယဲး သရွွဓရ္မ္မသမာဇဲရပိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","အပရဉ္စ တယော ရ္ဂၖဟေ သ္ထိတာန် ဓရ္မ္မသမာဇလောကာန် မမ နမသ္ကာရံ ဇ္ဉာပယဓွံ၊ တဒွတ် အာၑိယာဒေၑေ ခြီၐ္ဋသျ ပက္ၐေ ပြထမဇာတဖလသွရူပေါ ယ ဣပေနိတနာမာ မမ ပြိယဗန္ဓုသ္တမပိ မမ နမသ္ကာရံ ဇ္ဉာပယဓွံ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","အပရံ ဗဟုၑြမေဏာသ္မာန် အသေဝတ ယာ မရိယမ် တာမပိ နမသ္ကာရံ ဇ္ဉာပယဓွံ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","အပရဉ္စ ပြေရိတေၐု ချာတကီရ္တ္တီ မဒဂြေ ခြီၐ္ဋာၑြိတော် မမ သွဇာတီယော် သဟဗန္ဒိနော် စ ယာဝါန္ဒြနီကယူနိယော် တော် မမ နမသ္ကာရံ ဇ္ဉာပယဓွံ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","တထာ ပြဘော် မတ္ပြိယတမမ် အာမ္ပ္လိယမပိ မမ နမသ္ကာရံ ဇ္ဉာပယဓွံ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","အပရံ ခြီၐ္ဋသေဝါယာံ မမ သဟကာရိဏမ် ဦရ္ဗ္ဗာဏံ မမ ပြိယတမံ သ္တာခုဉ္စ မမ နမသ္ကာရံ ဇ္ဉာပယဓွံ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","အပရံ ခြီၐ္ဋေန ပရီက္ၐိတမ် အာပိလ္လိံ မမ နမသ္ကာရံ ဝဒတ, အာရိၐ္ဋဗူလသျ ပရိဇနာံၑ္စ မမ နမသ္ကာရံ ဇ္ဉာပယဓွံ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","အပရံ မမ ဇ္ဉာတိံ ဟေရောဒိယောနံ မမ နမသ္ကာရံ ဝဒတ, တထာ နာရ္ကိသသျ ပရိဝါရာဏာံ မဓျေ ယေ ပြဘုမာၑြိတာသ္တာန် မမ နမသ္ကာရံ ဝဒတ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","အပရံ ပြဘေား သေဝါယာံ ပရိၑြမကာရိဏျော် တြုဖေနာတြုဖောၐေ မမ နမသ္ကာရံ ဝဒတ, တထာ ပြဘေား သေဝါယာမ် အတျန္တံ ပရိၑြမကာရိဏီ ယာ ပြိယာ ပရ္ၐိသ္တာံ နမသ္ကာရံ ဇ္ဉာပယဓွံ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","အပရံ ပြဘောရဘိရုစိတံ ရူဖံ မမ ဓရ္မ္မမာတာ ယာ တသျ မာတာ တာမပိ နမသ္ကာရံ ဝဒတ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","အပရမ် အသုံကၖတံ ဖ္လိဂေါနံ ဟရ္မ္မံ ပါတြဗံ ဟရ္မ္မိမ် ဧတေၐာံ သင်္ဂိဘြာတၖဂဏဉ္စ နမသ္ကာရံ ဇ္ဉာပယဓွံ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","အပရံ ဖိလလဂေါ ယူလိယာ နီရိယသ္တသျ ဘဂိနျလုမ္ပာ စဲတာန် ဧတဲး သာရ္ဒ္ဓံ ယာဝန္တး ပဝိတြလောကာ အာသတေ တာနပိ နမသ္ကာရံ ဇ္ဉာပယဓွံ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","ယူယံ ပရသ္ပရံ ပဝိတြစုမ္ဗနေန နမသ္ကုရုဓွံ၊ ခြီၐ္ဋသျ ဓရ္မ္မသမာဇဂဏော ယုၐ္မာန် နမသ္ကုရုတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","ဟေ ဘြာတရော ယုၐ္မာန် ဝိနယေ'ဟံ ယုၐ္မာဘိ ရျာ ၑိက္ၐာ လဗ္ဓာ တာမ် အတိကြမျ ယေ ဝိစ္ဆေဒါန် ဝိဃ္နာံၑ္စ ကုရွွန္တိ တာန် နိၑ္စိနုတ တေၐာံ သင်္ဂံ ဝရ္ဇယတ စ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","ယတသ္တာဒၖၑာ လောကာ အသ္မာကံ ပြဘော ရျီၑုခြီၐ္ဋသျ ဒါသာ ဣတိ နဟိ ကိန္တု သွောဒရသျဲဝ ဒါသား; အပရံ ပြဏယဝစနဲ ရ္မဓုရဝါကျဲၑ္စ သရလလောကာနာံ မနာံသိ မောဟယန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","ယုၐ္မာကမ် အာဇ္ဉာဂြာဟိတွံ သရွွတြ သရွွဲ ရ္ဇ္ဉာတံ တတော'ဟံ ယုၐ္မာသု သာနန္ဒော'ဘဝံ တထာပိ ယူယံ ယတ် သတ္ဇ္ဉာနေန ဇ္ဉာနိနး ကုဇ္ဉာနေे စာတတ္ပရာ ဘဝေတေတိ မမာဘိလာၐး၊ ");
INSERT INTO sanbur_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","အဓိကန္တု ၑာန္တိဒါယက ဤၑွရး ၑဲတာနမ် အဝိလမ္ဗံ ယုၐ္မာကံ ပဒါနာမ် အဓော မရ္ဒ္ဒိၐျတိ၊ အသ္မာကံ ပြဘု ရျီၑုခြီၐ္ဋော ယုၐ္မာသု ပြသာဒံ ကြိယာတ်၊ ဣတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","မမ သဟကာရီ တီမထိယော မမ ဇ္ဉာတယော လူကိယော ယာသောန် သောသိပါတြၑ္စေမေ ယုၐ္မာန် နမသ္ကုရွွန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","အပရမ် ဧတတ္ပတြလေခကသ္တရ္တ္တိယနာမာဟမပိ ပြဘော ရ္နာမ္နာ ယုၐ္မာန် နမသ္ကရောမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","တထာ ကၖတ္သ္နဓရ္မ္မသမာဇသျ မမ စာတိထျကာရီ ဂါယော ယုၐ္မာန် နမသ္ကရောတိ၊ အပရမ် ဧတန္နဂရသျ ဓနရက္ၐက ဣရာသ္တး က္ကာရ္တ္တနာမကၑ္စဲကော ဘြာတာ တာဝပိ ယုၐ္မာန် နမသ္ကုရုတး၊ ");
INSERT INTO sanbur_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","အသ္မာကံ ပြဘု ရျီၑုခြီၐ္ဋာ ယုၐ္မာသု သရွွေၐု ပြသာဒံ ကြိယာတ်၊ ဣတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","ပူရွွကာလိကယုဂေၐု ပြစ္ဆန္နာ ယာ မန္တြဏာဓုနာ ပြကာၑိတာ ဘူတွာ ဘဝိၐျဒွါဒိလိခိတဂြန္ထဂဏသျ ပြမာဏာဒ် ဝိၑွာသေန ဂြဟဏာရ္ထံ သဒါတနသျေၑွရသျာဇ္ဉယာ သရွွဒေၑီယလောကာန် ဇ္ဉာပျတေ, ");
INSERT INTO sanbur_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","တသျာ မန္တြဏာယာ ဇ္ဉာနံ လဗ္ဓွာ မယာ ယး သုသံဝါဒေါ ယီၑုခြီၐ္ဋမဓိ ပြစာရျျတေ, တဒနုသာရာဒ် ယုၐ္မာန် ဓရ္မ္မေ သုသ္ထိရာန် ကရ္တ္တုံ သမရ္ထော ယော'ဒွိတီယး ");
INSERT INTO sanbur_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","သရွွဇ္ဉ ဤၑွရသ္တသျ ဓနျဝါဒေါ ယီၑုခြီၐ္ဋေန သန္တတံ ဘူယာတ်၊ ဣတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","ယာဝန္တး ပဝိတြာ လောကား သွေၐာမ် အသ္မာကဉ္စ ဝသတိသ္ထာနေၐွသ္မာကံ ပြဘော ရျီၑေား ခြီၐ္ဋသျ နာမ္နာ ပြာရ္ထယန္တေ တဲး သဟာဟူတာနာံ ခြီၐ္ဋေန ယီၑုနာ ပဝိတြီကၖတာနာံ လောကာနာံ ယ ဤၑွရီယဓရ္မ္မသမာဇး ကရိန္ထနဂရေ ဝိဒျတေ ");
INSERT INTO sanbur_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","တံ ပြတီၑွရသျေစ္ဆယာဟူတော ယီၑုခြီၐ္ဋသျ ပြေရိတး ပေါ်လး သောသ္ထိနိနာမာ ဘြာတာ စ ပတြံ လိခတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","အသ္မာကံ ပိတြေၑွရေဏ ပြဘုနာ ယီၑုခြီၐ္ဋေန စ ပြသာဒး ၑာန္တိၑ္စ ယုၐ္မဘျံ ဒီယတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","ဤၑွရော ယီၑုခြီၐ္ဋေန ယုၐ္မာန် ပြတိ ပြသာဒံ ပြကာၑိတဝါန်, တသ္မာဒဟံ ယုၐ္မန္နိမိတ္တံ သရွွဒါ မဒီယေၑွရံ ဓနျံ ဝဒါမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","ခြီၐ္ဋသမ္ဗန္ဓီယံ သာက္ၐျံ ယုၐ္မာကံ မဓျေ ယေန ပြကာရေဏ သပြမာဏမ် အဘဝတ္ ");
INSERT INTO sanbur_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","တေန ယူယံ ခြီၐ္ဋာတ် သရွွဝိဓဝက္တၖတာဇ္ဉာနာဒီနိ သရွွဓနာနိ လဗ္ဓဝန္တး၊ ");
INSERT INTO sanbur_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","တတော'သ္မတ္ပြဘော ရျီၑုခြီၐ္ဋသျ ပုနရာဂမနံ ပြတီက္ၐမာဏာနာံ ယုၐ္မာကံ ကသျာပိ ဝရသျာဘာဝေါ န ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","အပရမ် အသ္မာကံ ပြဘော ရျီၑုခြီၐ္ဋသျ ဒိဝသေ ယူယံ ယန္နိရ္ဒ္ဒေါၐာ ဘဝေတ တဒရ္ထံ သဧဝ ယာဝဒန္တံ ယုၐ္မာန် သုသ္ထိရာန် ကရိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","ယ ဤၑွရး သွပုတြသျာသ္မတ္ပြဘော ရျီၑုခြီၐ္ဋသျာံၑိနး ကရ္တ္တုံ ယုၐ္မာန် အာဟူတဝါန် သ ဝိၑွသနီယး၊ ");
INSERT INTO sanbur_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","ဟေ ဘြာတရး, အသ္မာကံ ပြဘုယီၑုခြီၐ္ဋသျ နာမ္နာ ယုၐ္မာန် ဝိနယေ'ဟံ သရွွဲ ရျုၐ္မာဘိရေကရူပါဏိ ဝါကျာနိ ကထျန္တာံ ယုၐ္မန္မဓျေ ဘိန္နသင်္ဃာတာ န ဘဝန္တု မနောဝိစာရယောရဲကျေန ယုၐ္မာကံ သိဒ္ဓတွံ ဘဝတု၊ ");
INSERT INTO sanbur_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","ဟေ မမ ဘြာတရော ယုၐ္မန္မဓျေ ဝိဝါဒါ ဇာတာ ဣတိ ဝါရ္တ္တာမဟံ က္လောယျား ပရိဇနဲ ရ္ဇ္ဉာပိတး၊ ");
INSERT INTO sanbur_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","မမာဘိပြေတမိဒံ ယုၐ္မာကံ ကၑ္စိတ် ကၑ္စိဒ် ဝဒတိ ပေါ်လသျ ၑိၐျော'ဟမ် အာပလ္လေား ၑိၐျော'ဟံ ကဲဖား ၑိၐျော'ဟံ ခြီၐ္ဋသျ ၑိၐျော'ဟမိတိ စ၊ ");
INSERT INTO sanbur_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","ခြီၐ္ဋသျ ကိံ ဝိဘေဒး ကၖတး? ပေါ်လး ကိံ ယုၐ္မတ္ကၖတေ ကြုၑေ ဟတး? ပေါ်လသျ နာမ္နာ ဝါ ယူယံ ကိံ မဇ္ဇိတား? ");
INSERT INTO sanbur_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","ကြိၐ္ပဂါယော် ဝိနာ ယုၐ္မာကံ မဓျေ'နျး ကော'ပိ မယာ န မဇ္ဇိတ ဣတိ ဟေတောရဟမ် ဤၑွရံ ဓနျံ ဝဒါမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","ဧတေန မမ နာမ္နာ မာနဝါ မယာ မဇ္ဇိတာ ဣတိ ဝက္တုံ ကေနာပိ န ၑကျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","အပရံ သ္တိဖာနသျ ပရိဇနာ မယာ မဇ္ဇိတာသ္တဒနျး ကၑ္စိဒ် ယန္မယာ မဇ္ဇိတသ္တဒဟံ န ဝေဒ္မိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","ခြီၐ္ဋေနာဟံ မဇ္ဇနာရ္ထံ န ပြေရိတး ကိန္တု သုသံဝါဒသျ ပြစာရာရ္ထမေဝ; သော'ပိ ဝါက္ပဋုတယာ မယာ န ပြစာရိတဝျး, ယတသ္တထာ ပြစာရိတေ ခြီၐ္ဋသျ ကြုၑေ မၖတျုး ဖလဟီနော ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","ယတော ဟေတော ရျေ ဝိနၑျန္တိ တေ တာံ ကြုၑသျ ဝါရ္တ္တာံ ပြလာပမိဝ မနျန္တေ ကိဉ္စ ပရိတြာဏံ လဘမာနေၐွသ္မာသု သာ ဤၑွရီယၑက္တိသွရူပါ၊ ");
INSERT INTO sanbur_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","တသ္မာဒိတ္ထံ လိခိတမာသ္တေ, ဇ္ဉာနဝတာန္တု ယတ် ဇ္ဉာနံ တန္မယာ နာၑယိၐျတေ၊ ဝိလောပယိၐျတေ တဒွဒ် ဗုဒ္ဓိ ရ္ဗဒ္ဓိမတာံ မယာ။ ");
INSERT INTO sanbur_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","ဇ္ဉာနီ ကုတြ? ၑာသ္တြီ ဝါ ကုတြ? ဣဟလောကသျ ဝိစာရတတ္ပရော ဝါ ကုတြ? ဣဟလောကသျ ဇ္ဉာနံ ကိမီၑွရေဏ မောဟီကၖတံ နဟိ? ");
INSERT INTO sanbur_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","ဤၑွရသျ ဇ္ဉာနာဒ် ဣဟလောကသျ မာနဝါး သွဇ္ဉာနေနေၑွရသျ တတ္တွဗောဓံ န ပြာပ္တဝန္တသ္တသ္မာဒ် ဤၑွရး ပြစာရရူပိဏာ ပြလာပေန ဝိၑွာသိနး ပရိတြာတုံ ရောစိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","ယိဟူဒီယလောကာ လက္ၐဏာနိ ဒိဒၖက္ၐန္တိ ဘိန္နဒေၑီယလောကာသ္တု ဝိဒျာံ မၖဂယန္တေ, ");
INSERT INTO sanbur_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","ဝယဉ္စ ကြုၑေ ဟတံ ခြီၐ္ဋံ ပြစာရယာမး၊ တသျ ပြစာရော ယိဟူဒီယဲ ရွိဃ္န ဣဝ ဘိန္နဒေၑီယဲၑ္စ ပြလာပ ဣဝ မနျတေ, ");
INSERT INTO sanbur_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","ကိန္တု ယိဟူဒီယာနာံ ဘိန္နဒေၑီယာနာဉ္စ မဓျေ ယေ အာဟူတာသ္တေၐု သ ခြီၐ္ဋ ဤၑွရီယၑက္တိရိဝေၑွရီယဇ္ဉာနမိဝ စ ပြကာၑတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","ယတ ဤၑွရေ ယး ပြလာပ အာရောပျတေ သ မာနဝါတိရိက္တံ ဇ္ဉာနမေဝ ယစ္စ ဒေါ်ရ္ဗ္ဗလျမ် ဤၑွရ အာရောပျတေ တတ် မာနဝါတိရိက္တံ ဗလမေဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","ဟေ ဘြာတရး, အာဟူတယုၐ္မဒ္ဂဏော ယၐ္မာဘိရာလောကျတာံ တန္မဓျေ သာံသာရိကဇ္ဉာနေန ဇ္ဉာနဝန္တး ပရာကြမိဏော ဝါ ကုလီနာ ဝါ ဗဟဝေါ န ဝိဒျန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","ယတ ဤၑွရော ဇ္ဉာနဝတသ္တြပယိတုံ မူရ္ခလောကာန် ရောစိတဝါန် ဗလာနိ စ တြပယိတုမ် ဤၑွရော ဒုရ္ဗ္ဗလာန် ရောစိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","တထာ ဝရ္တ္တမာနလောကာန် သံသ္ထိတိဘြၐ္ဋာန် ကရ္တ္တုမ် ဤၑွရော ဇဂတော'ပကၖၐ္ဋာန် ဟေယာန် အဝရ္တ္တမာနာံၑ္စာဘိရောစိတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","တတ ဤၑွရသျ သာက္ၐာတ် ကေနာပျာတ္မၑ္လာဃာ န ကရ္တ္တဝျာ၊ ");
INSERT INTO sanbur_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","ယူယဉ္စ တသ္မာတ် ခြီၐ္ဋေ ယီၑော် သံသ္ထိတိံ ပြာပ္တဝန္တး သ ဤၑွရာဒ် ယုၐ္မာကံ ဇ္ဉာနံ ပုဏျံ ပဝိတြတွံ မုက္တိၑ္စ ဇာတာ၊ ");
INSERT INTO sanbur_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","အတဧဝ ယဒွဒ် လိခိတမာသ္တေ တဒွတ်, ယး ကၑ္စိတ် ၑ္လာဃမာနး သျာတ် ၑ္လာဃတာံ ပြဘုနာ သ ဟိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","ဟေ ဘြာတရော ယုၐ္မတ္သမီပေ မမာဂမနကာလေ'ဟံ ဝက္တၖတာယာ ဝိဒျာယာ ဝါ နဲပုဏျေနေၑွရသျ သာက္ၐျံ ပြစာရိတဝါန် တန္နဟိ; ");
INSERT INTO sanbur_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","ယတော ယီၑုခြီၐ္ဋံ တသျ ကြုၑေ ဟတတွဉ္စ ဝိနာ နာနျတ် ကိမပိ ယုၐ္မန္မဓျေ ဇ္ဉာပယိတုံ ဝိဟိတံ ဗုဒ္ဓဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","အပရဉ္စာတီဝ ဒေါ်ရ္ဗ္ဗလျဘီတိကမ္ပယုက္တော ယုၐ္မာဘိး သာရ္ဒ္ဓမာသံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","အပရံ ယုၐ္မာကံ ဝိၑွာသော ယတ် မာနုၐိကဇ္ဉာနသျ ဖလံ န ဘဝေတ် ကိန္တွီၑွရီယၑက္တေး ဖလံ ဘဝေတ်, ");
INSERT INTO sanbur_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","တဒရ္ထံ မမ ဝက္တၖတာ မဒီယပြစာရၑ္စ မာနုၐိကဇ္ဉာနသျ မဓုရဝါကျသမ္ဗလိတော် နာသ္တာံ ကိန္တွာတ္မနး ၑက္တေၑ္စ ပြမာဏယုက္တာဝါသ္တာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","ဝယံ ဇ္ဉာနံ ဘာၐာမဟေ တစ္စ သိဒ္ဓလောကဲ ရ္ဇ္ဉာနမိဝ မနျတေ, တဒိဟလောကသျ ဇ္ဉာနံ နဟိ, ဣဟလောကသျ နၑွရာဏာမ် အဓိပတီနာံ ဝါ ဇ္ဉာနံ နဟိ; ");
INSERT INTO sanbur_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","ကိန္တု ကာလာဝသ္ထာယား ပူရွွသ္မာဒ် ယတ် ဇ္ဉာနမ် အသ္မာကံ ဝိဘဝါရ္ထမ် ဤၑွရေဏ နိၑ္စိတျ ပြစ္ဆန္နံ တန္နိဂူဎမ် ဤၑွရီယဇ္ဉာနံ ပြဘာၐာမဟေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","ဣဟလောကသျာဓိပတီနာံ ကေနာပိ တတ် ဇ္ဉာနံ န လဗ္ဓံ, လဗ္ဓေ သတိ တေ ပြဘာဝဝိၑိၐ္ဋံ ပြဘုံ ကြုၑေ နာဟနိၐျန်၊ ");
INSERT INTO sanbur_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","တဒွလ္လိခိတမာသ္တေ, နေတြေဏ က္ကာပိ နော ဒၖၐ္ဋံ ကရ္ဏေနာပိ စ န ၑြုတံ၊ မနောမဓျေ တု ကသျာပိ န ပြဝိၐ္ဋံ ကဒါပိ ယတ်၊ ဤၑွရေ ပြီယမာဏာနာံ ကၖတေ တတ် တေန သဉ္စိတံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","အပရမီၑွရး သွာတ္မနာ တဒသ္မာကံ သာက္ၐာတ် ပြာကာၑယတ်; ယတ အာတ္မာ သရွွမေဝါနုသန္ဓတ္တေ တေန စေၑွရသျ မရ္မ္မတတ္တွမပိ ဗုဓျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","မနုဇသျာန္တးသ္ထမာတ္မာနံ ဝိနာ ကေန မနုဇေန တသျ မနုဇသျ တတ္တွံ ဗုဓျတေ? တဒွဒီၑွရသျာတ္မာနံ ဝိနာ ကေနာပီၑွရသျ တတ္တွံ န ဗုဓျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","ဝယဉ္စေဟလောကသျာတ္မာနံ လဗ္ဓဝန္တသ္တန္နဟိ ကိန္တွီၑွရသျဲဝါတ္မာနံ လဗ္ဓဝန္တး, တတော ဟေတောရီၑွရေဏ သွပြသာဒါဒ် အသ္မဘျံ ယဒ် ယဒ် ဒတ္တံ တတ္သရွွမ် အသ္မာဘိ ရ္ဇ္ဉာတုံ ၑကျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","တစ္စာသ္မာဘိ ရ္မာနုၐိကဇ္ဉာနသျ ဝါကျာနိ ၑိက္ၐိတွာ ကထျတ ဣတိ နဟိ ကိန္တွာတ္မတော ဝါကျာနိ ၑိက္ၐိတွာတ္မိကဲ ရွာကျဲရာတ္မိကံ ဘာဝံ ပြကာၑယဒ္ဘိး ကထျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","ပြာဏီ မနုၐျ ဤၑွရီယာတ္မနး ၑိက္ၐာံ န ဂၖဟ္လာတိ ယတ အာတ္မိကဝိစာရေဏ သာ ဝိစာရျျေတိ ဟေတေား သ တာံ ပြလာပမိဝ မနျတေ ဗောဒ္ဓုဉ္စ န ၑက္နောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","အာတ္မိကော မာနဝး သရွွာဏိ ဝိစာရယတိ ကိန္တု သွယံ ကေနာပိ န ဝိစာရျျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","ယတ ဤၑွရသျ မနော ဇ္ဉာတွာ တမုပဒေၐ္ဋုံ ကး ၑက္နောတိ? ကိန္တု ခြီၐ္ဋသျ မနော'သ္မာဘိ ရ္လဗ္ဓံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","ဟေ ဘြာတရး, အဟမာတ္မိကဲရိဝ ယုၐ္မာဘိး သမံ သမ္ဘာၐိတုံ နာၑက္နဝံ ကိန္တု ၑာရီရိကာစာရိဘိး ခြီၐ္ဋဓရ္မ္မေ ၑိၑုတုလျဲၑ္စ ဇနဲရိဝ ယုၐ္မာဘိး သဟ သမဘာၐေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","ယုၐ္မာန် ကဌိနဘက္ၐျံ န ဘောဇယန် ဒုဂ္ဓမ် အပါယယံ ယတော ယူယံ ဘက္ၐျံ ဂြဟီတုံ တဒါ နာၑက္နုတ ဣဒါနီမပိ န ၑက္နုထ, ယတော ဟေတောရဓုနာပိ ၑာရီရိကာစာရိဏ အာဓွေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","ယုၐ္မန္မဓျေ မာတ္သရျျဝိဝါဒဘေဒါ ဘဝန္တိ တတး ကိံ ၑာရီရိကာစာရိဏော နာဓွေ မာနုၐိကမာရ္ဂေဏ စ န စရထ? ");
INSERT INTO sanbur_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","ပေါ်လသျာဟမိတျာပလ္လောရဟမိတိ ဝါ ယဒွါကျံ ယုၐ္မာကံ ကဲၑ္စိတ် ကဲၑ္စိတ် ကထျတေ တသ္မာဒ် ယူယံ ၑာရီရိကာစာရိဏ န ဘဝထ? ");
INSERT INTO sanbur_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","ပေါ်လး ကး? အာပလ္လော ရွာ ကး? တော် ပရိစာရကမာတြော် တယောရေကဲကသ္မဲ စ ပြဘု ရျာဒၖက် ဖလမဒဒါတ် တဒွတ် တယောရ္ဒွါရာ ယူယံ ဝိၑွာသိနော ဇာတား၊ ");
INSERT INTO sanbur_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","အဟံ ရောပိတဝါန် အာပလ္လောၑ္စ နိၐိက္တဝါန် ဤၑွရၑ္စာဝရ္ဒ္ဓယတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","အတော ရောပယိတၖသေက္တာရာဝသာရော် ဝရ္ဒ္ဓယိတေၑွရ ဧဝ သာရး၊ ");
INSERT INTO sanbur_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","ရောပယိတၖသေက္တာရော် စ သမော် တယောရေကဲကၑ္စ သွၑြမယောဂျံ သွဝေတနံ လပ္သျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","အာဝါမီၑွရေဏ သဟ ကရ္မ္မကာရိဏော်, ဤၑွရသျ ယတ် က္ၐေတြမ် ဤၑွရသျ ယာ နိရ္မ္မိတိး သာ ယူယမေဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","ဤၑွရသျ ပြသာဒါတ် မယာ ယတ် ပဒံ လဗ္ဓံ တသ္မာတ် ဇ္ဉာနိနာ ဂၖဟကာရိဏေဝ မယာ ဘိတ္တိမူလံ သ္ထာပိတံ တဒုပရိ စာနျေန နိစီယတေ၊ ကိန္တု ယေန ယန္နိစီယတေ တတ် တေန ဝိဝိစျတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","ယတော ယီၑုခြီၐ္ဋရူပံ ယဒ် ဘိတ္တိမူလံ သ္ထာပိတံ တဒနျတ် ကိမပိ ဘိတ္တိမူလံ သ္ထာပယိတုံ ကေနာပိ န ၑကျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","ဧတဒ္ဘိတ္တိမူလသျောပရိ ယဒိ ကေစိတ် သွရ္ဏရူပျမဏိကာၐ္ဌတၖဏနလာန် နိစိနွန္တိ, ");
INSERT INTO sanbur_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","တရှျေကဲကသျ ကရ္မ္မ ပြကာၑိၐျတေ ယတး သ ဒိဝသသ္တတ် ပြကာၑယိၐျတိ၊ ယတော ဟတောသ္တန ဒိဝသေန ဝဟ္နိမယေနောဒေတဝျံ တတ ဧကဲကသျ ကရ္မ္မ ကီဒၖၑမေတသျ ပရီက္ၐာ ဗဟ္နိနာ ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","ယသျ နိစယနရူပံ ကရ္မ္မ သ္ထာသ္နု ဘဝိၐျတိ သ ဝေတနံ လပ္သျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","ယသျ စ ကရ္မ္မ ဓက္ၐျတေ တသျ က္ၐတိ ရ္ဘဝိၐျတိ ကိန္တု ဝဟ္နေ ရ္နိရ္ဂတဇန ဣဝ သ သွယံ ပရိတြာဏံ ပြာပ္သျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","ယူယမ် ဤၑွရသျ မန္ဒိရံ ယုၐ္မန္မဓျေ စေၑွရသျာတ္မာ နိဝသတီတိ ကိံ န ဇာနီထ? ");
INSERT INTO sanbur_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","ဤၑွရသျ မန္ဒိရံ ယေန ဝိနာၑျတေ သော'ပီၑွရေဏ ဝိနာၑယိၐျတေ ယတ ဤၑွရသျ မန္ဒိရံ ပဝိတြမေဝ ယူယံ တု တန္မန္ဒိရမ် အာဓွေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","ကောပိ သွံ န ဝဉ္စယတာံ၊ ယုၐ္မာကံ ကၑ္စန စေဒိဟလောကသျ ဇ္ဉာနေန ဇ္ဉာနဝါနဟမိတိ ဗုဓျတေ တရှိ သ ယတ် ဇ္ဉာနီ ဘဝေတ် တဒရ္ထံ မူဎော ဘဝတု၊ ");
INSERT INTO sanbur_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","ယသ္မာဒိဟလောကသျ ဇ္ဉာနမ် ဤၑွရသျ သာက္ၐာတ် မူဎတွမေဝ၊ ဧတသ္မိန် လိခိတမပျာသ္တေ, တီက္ၐ္ဏာ ယာ ဇ္ဉာနိနာံ ဗုဒ္ဓိသ္တယာ တာန် ဓရတီၑွရး၊ ");
INSERT INTO sanbur_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","ပုနၑ္စ၊ ဇ္ဉာနိနာံ ကလ္ပနာ ဝေတ္တိ ပရမေၑော နိရရ္ထကား၊ ");
INSERT INTO sanbur_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","အတဧဝ ကော'ပိ မနုဇဲရာတ္မာနံ န ၑ္လာဃတာံ ယတး သရွွာဏိ ယုၐ္မာကမေဝ, ");
INSERT INTO sanbur_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","ပေါ်လ ဝါ အာပလ္လော ရွာ ကဲဖာ ဝါ ဇဂဒ် ဝါ ဇီဝနံ ဝါ မရဏံ ဝါ ဝရ္တ္တမာနံ ဝါ ဘဝိၐျဒွါ သရွွာဏျေဝ ယုၐ္မာကံ, ");
INSERT INTO sanbur_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","ယူယဉ္စ ခြီၐ္ဋသျ, ခြီၐ္ဋၑ္စေၑွရသျ၊ ");
INSERT INTO sanbur_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","လောကာ အသ္မာန် ခြီၐ္ဋသျ ပရိစာရကာန် ဤၑွရသျ နိဂူဌဝါကျဓနသျာဓျက္ၐာံၑ္စ မနျန္တာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","ကိဉ္စ ဓနာဓျက္ၐေဏ ဝိၑွသနီယေန ဘဝိတဝျမေတဒေဝ လောကဲ ရျာစျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","အတော ဝိစာရယဒ္ဘိ ရျုၐ္မာဘိရနျဲး ကဲၑ္စိန် မနုဇဲ ရွာ မမ ပရီက္ၐဏံ မယာတီဝ လဃု မနျတေ 'ဟမပျာတ္မာနံ န ဝိစာရယာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","မယာ ကိမပျပရာဒ္ဓမိတျဟံ န ဝေဒ္မိ ကိန္တွေတေန မမ နိရပရာဓတွံ န နိၑ္စီယတေ ပြဘုရေဝ မမ ဝိစာရယိတာသ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","အတ ဥပယုက္တသမယာတ် ပူရွွမ် အရ္ထတး ပြဘောရာဂမနာတ် ပူရွွံ ယုၐ္မာဘိ ရွိစာရော န ကြိယတာံ၊ ပြဘုရာဂတျ တိမိရေဏ ပြစ္ဆန္နာနိ သရွွာဏိ ဒီပယိၐျတိ မနသာံ မန္တြဏာၑ္စ ပြကာၑယိၐျတိ တသ္မိန် သမယ ဤၑွရာဒ် ဧကဲကသျ ပြၑံသာ ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","ဟေ ဘြာတရး သရွွာဏျေတာနိ မယာတ္မာနမ် အာပလ္လဝဉ္စောဒ္ဒိၑျ ကထိတာနိ တသျဲတတ် ကာရဏံ ယုယံ ယထာ ၑာသ္တြီယဝိဓိမတိကြမျ မာနဝမ် အတီဝ နာဒရိၐျဓ္ဗ ဤတ္ထဉ္စဲကေန ဝဲပရီတျာဒ် အပရေဏ န ၑ္လာဃိၐျဓ္ဗ ဧတာဒၖၑီံ ၑိက္ၐာမာဝယောရ္ဒၖၐ္ဋာန္တာတ် လပ္သျဓွေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","အပရာတ် ကသ္တွာံ ဝိၑေၐယတိ? တုဘျံ ယန္န ဒတ္တ တာဒၖၑံ ကိံ ဓာရယသိ? အဒတ္တေနေဝ ဒတ္တေန ဝသ္တုနာ ကုတး ၑ္လာဃသေ? ");
INSERT INTO sanbur_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","ဣဒါနီမေဝ ယူယံ ကိံ တၖပ္တာ လဗ္ဓဓနာ ဝါ? အသ္မာသွဝိဒျမာနေၐု ယူယံ ကိံ ရာဇတွပဒံ ပြာပ္တား? ယုၐ္မာကံ ရာဇတွံ မယာဘိလၐိတံ ယတသ္တေန ယုၐ္မာဘိး သဟ ဝယမပိ ရာဇျာံၑိနော ဘဝိၐျာမး၊ ");
INSERT INTO sanbur_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","ပြေရိတာ ဝယံ ၑေၐာ ဟန္တဝျာၑ္စေဝေၑွရေဏ နိဒရ္ၑိတား၊ ယတော ဝယံ သရွွလောကာနာမ် အရ္ထတး သွရ္ဂီယဒူတာနာံ မာနဝါနာဉ္စ ကော်တုကာသ္ပဒါနိ ဇာတား၊ ");
INSERT INTO sanbur_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","ခြီၐ္ဋသျ ကၖတေ ဝယံ မူဎား ကိန္တု ယူယံ ခြီၐ္ဋေန ဇ္ဉာနိနး, ဝယံ ဒုရ္ဗ္ဗလာ ယူယဉ္စ သဗလား, ယူယံ သမ္မာနိတာ ဝယဉ္စာပမာနိတား၊ ");
INSERT INTO sanbur_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","ဝယမဒျာပိ က္ၐုဓာရ္တ္တာသ္တၖၐ္ဏာရ္တ္တာ ဝသ္တြဟီနာသ္တာဍိတာ အာၑြမရဟိတာၑ္စ သန္တး ");
INSERT INTO sanbur_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","ကရ္မ္မဏိ သွကရာန် ဝျာပါရယန္တၑ္စ ဒုးခဲး ကာလံ ယာပယာမး၊ ဂရှိတဲရသ္မာဘိရာၑီး ကထျတေ ဒူရီကၖတဲး သဟျတေ နိန္ဒိတဲး ပြသာဒျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","ဝယမဒျာပိ ဇဂတး သမ္မာရ္ဇနီယောဂျာ အဝကရာ ဣဝ သရွွဲ ရ္မနျာမဟေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","ယုၐ္မာန် တြပယိတုမဟမေတာနိ လိခါမီတိ နဟိ ကိန္တု ပြိယာတ္မဇာနိဝ ယုၐ္မာန် ပြဗောဓယာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","ယတး ခြီၐ္ဋဓရ္မ္မေ ယဒျပိ ယုၐ္မာကံ ဒၑသဟသြာဏိ ဝိနေတာရော ဘဝန္တိ တထာပိ ဗဟဝေါ ဇနကာ န ဘဝန္တိ ယတော'ဟမေဝ သုသံဝါဒေန ယီၑုခြီၐ္ဋေ ယုၐ္မာန် အဇနယံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","အတော ယုၐ္မာန် ဝိနယေ'ဟံ ယူယံ မဒနုဂါမိနော ဘဝတ၊ ");
INSERT INTO sanbur_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","ဣတျရ္ထံ သရွွေၐု ဓရ္မ္မသမာဇေၐု သရွွတြ ခြီၐ္ဋဓရ္မ္မယောဂျာ ယေ ဝိဓယော မယောပဒိၑျန္တေ တာန် ယော ယုၐ္မာန် သ္မာရယိၐျတျေဝမ္ဘူတံ ပြဘေား ကၖတေ ပြိယံ ဝိၑွာသိနဉ္စ မဒီယတနယံ တီမထိယံ ယုၐ္မာကံ သမီပံ ပြေၐိတဝါနဟံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","အပရမဟံ ယုၐ္မာကံ သမီပံ န ဂမိၐျာမီတိ ဗုဒ္ဓွာ ယုၐ္မာကံ ကိယန္တော လောကာ ဂရွွန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","ကိန္တု ယဒိ ပြဘေရိစ္ဆာ ဘဝတိ တရှျဟမဝိလမ္ဗံ ယုၐ္မတ္သမီပမုပသ္ထာယ တေၐာံ ဒရ္ပဓ္မာတာနာံ လောကာနာံ ဝါစံ ဇ္ဉာသျာမီတိ နဟိ သာမရ္ထျမေဝ ဇ္ဉာသျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","ယသ္မာဒီၑွရသျ ရာဇတွံ ဝါဂျုက္တံ နဟိ ကိန္တု သာမရ္ထျယုက္တံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","ယုၐ္မာကံ ကာ ဝါဉ္ဆာ? ယုၐ္မတ္သမီပေ မယာ ကိံ ဒဏ္ဍပါဏိနာ ဂန္တဝျမုတ ပြေမနမြတာတ္မယုက္တေန ဝါ? ");
INSERT INTO sanbur_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","အပရံ ယုၐ္မာကံ မဓျေ ဝျဘိစာရော ဝိဒျတေ သ စ ဝျဘိစာရသ္တာဒၖၑော ယဒ် ဒေဝပူဇကာနာံ မဓျေ'ပိ တတ္တုလျော န ဝိဒျတေ ဖလတော ယုၐ္မာကမေကော ဇနော ဝိမာတၖဂမနံ ကၖရုတ ဣတိ ဝါရ္တ္တာ သရွွတြ ဝျာပ္တာ၊ ");
INSERT INTO sanbur_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","တထာစ ယူယံ ဒရ္ပဓ္မာတာ အာဓ္ဗေ, တတ် ကရ္မ္မ ယေန ကၖတံ သ ယထာ ယုၐ္မန္မဓျာဒ် ဒူရီကြိယတေ တထာ ၑောကော ယုၐ္မာဘိ ရ္န ကြိယတေ ကိမ် ဧတတ်? ");
INSERT INTO sanbur_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","အဝိဒျမာနေ မဒီယၑရီရေ မမာတ္မာ ယုၐ္မန္မဓျေ ဝိဒျတေ အတော'ဟံ ဝိဒျမာန ဣဝ တတ္ကရ္မ္မကာရိဏော ဝိစာရံ နိၑ္စိတဝါန်, ");
INSERT INTO sanbur_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","အသ္မတ္ပြဘော ရျီၑုခြီၐ္ဋသျ နာမ္နာ ယုၐ္မာကံ မဒီယာတ္မနၑ္စ မိလနေ ဇာတေ 'သ္မတ္ပြဘော ရျီၑုခြီၐ္ဋသျ ၑက္တေး သာဟာယျေန ");
INSERT INTO sanbur_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","သ နရး ၑရီရနာၑာရ္ထမသ္မာဘိး ၑယတာနော ဟသ္တေ သမရ္ပယိတဝျသ္တတော'သ္မာကံ ပြဘော ရျီၑော ရ္ဒိဝသေ တသျာတ္မာ ရက္ၐာံ ဂန္တုံ ၑက္ၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","ယုၐ္မာကံ ဒရ္ပော န ဘဒြာယ ယူယံ ကိမေတန္န ဇာနီထ, ယထာ, ဝိကာရး ကၖတ္သ္နၑက္တူနာံ သွလ္ပကိဏွေန ဇာယတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","ယူယံ ယတ် နဝီနၑက္တုသွရူပါ ဘဝေတ တဒရ္ထံ ပုရာတနံ ကိဏွမ် အဝမာရ္ဇ္ဇတ ယတော ယုၐ္မာဘိး ကိဏွၑူနျဲ ရ္ဘဝိတဝျံ၊ အပရမ် အသ္မာကံ နိသ္တာရောတ္သဝီယမေၐၑာဝကော ယး ခြီၐ္ဋး သော'သ္မဒရ္ထံ ဗလီကၖတော 'ဘဝတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","အတး ပုရာတနကိဏွေနာရ္ထတော ဒုၐ္ဋတာဇိဃာံသာရူပေဏ ကိဏွေန တန္နဟိ ကိန္တု သာရလျသတျတွရူပယာ ကိဏွၑူနျတယာသ္မာဘိရုတ္သဝး ကရ္တ္တဝျး၊ ");
INSERT INTO sanbur_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","ဝျာဘိစာရိဏာံ သံသရ္ဂော ယုၐ္မာဘိ ရွိဟာတဝျ ဣတိ မယာ ပတြေ လိခိတံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","ကိန္တွဲဟိကလောကာနာံ မဓျေ ယေ ဝျဘိစာရိဏော လောဘိန ဥပဒြာဝိဏော ဒေဝပူဇကာ ဝါ တေၐာံ သံသရ္ဂး သရွွထာ ဝိဟာတဝျ ဣတိ နဟိ, ဝိဟာတဝျေ သတိ ယုၐ္မာဘိ ရ္ဇဂတော နိရ္ဂန္တဝျမေဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","ကိန္တု ဘြာတၖတွေန ဝိချာတး ကၑ္စိဇ္ဇနော ယဒိ ဝျဘိစာရီ လောဘီ ဒေဝပူဇကော နိန္ဒကော မဒျပ ဥပဒြာဝီ ဝါ ဘဝေတ် တရှိ တာဒၖၑေန မာနဝေန သဟ ဘောဇနပါနေ'ပိ ယုၐ္မာဘိ ရ္န ကရ္တ္တဝျေ ဣတျဓုနာ မယာ လိခိတံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","သမာဇဗဟိးသ္ထိတာနာံ လောကာနာံ ဝိစာရကရဏေ မမ ကော'ဓိကာရး? ကိန္တု တဒန္တရ္ဂတာနာံ ဝိစာရဏံ ယုၐ္မာဘိး ကိံ န ကရ္တ္တဝျံ ဘဝေတ်? ");
INSERT INTO sanbur_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","ဗဟိးသ္ထာနာံ တု ဝိစာရ ဤၑွရေဏ ကာရိၐျတေ၊ အတော ယုၐ္မာဘိး သ ပါတကီ သွမဓျာဒ် ဗဟိၐ္ကြိယတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","ယုၐ္မာကမေကသျ ဇနသျာပရေဏ သဟ ဝိဝါဒေ ဇာတေ သ ပဝိတြလောကဲ ရွိစာရမကာရယန် ကိမ် အဓာရ္မ္မိကလောကဲ ရွိစာရယိတုံ ပြောတ္သဟတေ? ");
INSERT INTO sanbur_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","ဇဂတော'ပိ ဝိစာရဏံ ပဝိတြလောကဲး ကာရိၐျတ ဧတဒ် ယူယံ ကိံ န ဇာနီထ? အတော ဇဂဒ် ယဒိ ယုၐ္မာဘိ ရွိစာရယိတဝျံ တရှိ က္ၐုဒြတမဝိစာရေၐု ယူယံ ကိမသမရ္ထား? ");
INSERT INTO sanbur_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","ဒူတာ အပျသ္မာဘိ ရွိစာရယိၐျန္တ ဣတိ ကိံ န ဇာနီထ? အတ အဲဟိကဝိၐယား ကိမ် အသ္မာဘိ ရ္န ဝိစာရယိတဝျာ ဘဝေယုး? ");
INSERT INTO sanbur_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","အဲဟိကဝိၐယသျ ဝိစာရေ ယုၐ္မာဘိး ကရ္တ္တဝျေ ယေ လောကား သမိတော် က္ၐုဒြတမာသ္တ ဧဝ နိယုဇျန္တာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","အဟံ ယုၐ္မာန် တြပယိတုမိစ္ဆန် ဝဒါမိ ယၖၐ္မန္မဓျေ ကိမေကော'ပိ မနုၐျသ္တာဒၖဂ် ဗုဒ္ဓိမာန္နဟိ ယော ဘြာတၖဝိဝါဒဝိစာရဏေ သမရ္ထး သျာတ်? ");
INSERT INTO sanbur_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","ကိဉ္စဲကော ဘြာတာ ဘြာတြာနျေန ကိမဝိၑွာသိနာံ ဝိစာရကာဏာံ သာက္ၐာဒ် ဝိဝဒတေ? ယၐ္မန္မဓျေ ဝိဝါဒါ ဝိဒျန္တ ဧတဒပိ ယုၐ္မာကံ ဒေါၐး၊ ");
INSERT INTO sanbur_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","ယူယံ ကုတော'နျာယသဟနံ က္ၐတိသဟနံ ဝါ ၑြေယော န မနျဓွေ? ");
INSERT INTO sanbur_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","ကိန္တု ယူယမပိ ဘြာတၖနေဝ ပြတျနျာယံ က္ၐတိဉ္စ ကုရုထ ကိမေတတ်? ");
INSERT INTO sanbur_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","ဤၑွရသျ ရာဇျေ'နျာယကာရိဏာံ လောကာနာမဓိကာရော နာသ္တျေတဒ် ယူယံ ကိံ န ဇာနီထ? မာ ဝဉ္စျဓွံ, ယေ ဝျဘိစာရိဏော ဒေဝါရ္စ္စိနး ပါရဒါရိကား သ္တြီဝဒါစာရိဏး ပုံမဲထုနကာရိဏသ္တသ္ကရာ ");
INSERT INTO sanbur_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","လောဘိနော မဒျပါ နိန္ဒကာ ဥပဒြာဝိဏော ဝါ တ ဤၑွရသျ ရာဇျဘာဂိနော န ဘဝိၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","ယူယဉ္စဲဝံဝိဓာ လောကာ အာသ္တ ကိန္တု ပြဘော ရျီၑော ရ္နာမ္နာသ္မဒီၑွရသျာတ္မနာ စ ယူယံ ပြက္ၐာလိတား ပါဝိတား သပုဏျီကၖတာၑ္စ၊ ");
INSERT INTO sanbur_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","မဒရ္ထံ သရွွံ ဒြဝျမ် အပြတိၐိဒ္ဓံ ကိန္တု န သရွွံ ဟိတဇနကံ၊ မဒရ္ထံ သရွွမပြတိၐိဒ္ဓံ တထာပျဟံ ကသျာပိ ဒြဝျသျ ဝၑီကၖတော န ဘဝိၐျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","ဥဒရာယ ဘက္ၐျာဏိ ဘက္ၐျေဘျၑ္စောဒရံ, ကိန္တု ဘက္ၐျောဒရေ ဤၑွရေဏ နာၑယိၐျေတေ; အပရံ ဒေဟော န ဝျဘိစာရာယ ကိန္တု ပြဘဝေ ပြဘုၑ္စ ဒေဟာယ၊ ");
INSERT INTO sanbur_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","ယၑ္စေၑွရး ပြဘုမုတ္ထာပိတဝါန် သ သွၑက္တျာသ္မာနပျုတ္ထာပယိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","ယုၐ္မာကံ ယာနိ ၑရီရာဏိ တာနိ ခြီၐ္ဋသျာင်္ဂါနီတိ ကိံ ယူယံ န ဇာနီထ? အတး ခြီၐ္ဋသျ ယာနျင်္ဂါနိ တာနိ မယာပဟၖတျ ဝေၑျာယာ အင်္ဂါနိ ကိံ ကာရိၐျန္တေ? တန္န ဘဝတု၊ ");
INSERT INTO sanbur_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","ယး ကၑ္စိဒ် ဝေၑျာယာမ် အာသဇျတေ သ တယာ သဟဲကဒေဟော ဘဝတိ ကိံ ယူယမေတန္န ဇာနီထ? ယတော လိခိတမာသ္တေ, ယထာ, တော် ဒွေါ် ဇနာဝေကာင်္ဂေါ် ဘဝိၐျတး၊ ");
INSERT INTO sanbur_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","မာနဝါ ယာနျနျာနိ ကလုၐာဏိ ကုရွွတေ တာနိ ဝပု ရ္န သမာဝိၑန္တိ ကိန္တု ဝျဘိစာရိဏာ သွဝိဂြဟသျ ဝိရုဒ္ဓံ ကလ္မၐံ ကြိယတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","မာနဝါ ယာနျနျာနိ ကလုၐာဏိ ကုရွွတေ တာနိ ဝပု ရ္န သမာဝိၑန္တိ ကိန္တု ဝျဘိစာရိဏာ သွဝိဂြဟသျ ဝိရုဒ္ဓံ ကလ္မၐံ ကြိယတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","ယုၐ္မာကံ ယာနိ ဝပူံသိ တာနိ ယုၐ္မဒန္တးသ္ထိတသျေၑွရာလ္လဗ္ဓသျ ပဝိတြသျာတ္မနော မန္ဒိရာဏိ ယူယဉ္စ သွေၐာံ သွာမိနော နာဓွေ ကိမေတဒ် ယုၐ္မာဘိ ရ္န ဇ္ဉာယတေ? ");
INSERT INTO sanbur_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","ယူယံ မူလျေန ကြီတာ အတော ဝပုရ္မနောဘျာမ် ဤၑွရော ယုၐ္မာဘိး ပူဇျတာံ ယတ ဤၑွရ ဧဝ တယေား သွာမီ၊ ");
INSERT INTO sanbur_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","အပရဉ္စ ယုၐ္မာဘိ ရ္မာံ ပြတိ ယတ် ပတြမလေခိ တသျောတ္တရမေတတ်, ယောၐိတော'သ္ပရ္ၑနံ မနုဇသျ ဝရံ; ");
INSERT INTO sanbur_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","ကိန္တု ဝျဘိစာရဘယာဒ် ဧကဲကသျ ပုံသး သွကီယဘာရျျာ ဘဝတု တဒွဒ် ဧကဲကသျာ ယောၐိတော 'ပိ သွကီယဘရ္တ္တာ ဘဝတု၊ ");
INSERT INTO sanbur_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","ဘာရျျာယဲ ဘရ္တြာ ယဒျဒ် ဝိတရဏီယံ တဒ် ဝိတီရျျတာံ တဒွဒ် ဘရ္တြေ'ပိ ဘာရျျယာ ဝိတရဏီယံ ဝိတီရျျတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","ဘာရျျာယား သွဒေဟေ သွတွံ နာသ္တိ ဘရ္တ္တုရေဝ, တဒွဒ် ဘရ္တ္တုရပိ သွဒေဟေ သွတွံ နာသ္တိ ဘာရျျာယာ ဧဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","ဥပေါၐဏပြာရ္ထနယေား သေဝနာရ္ထမ် ဧကမန္တြဏာနာံ ယုၐ္မာကံ ကိယတ္ကာလံ ယာဝဒ် ယာ ပၖထက္သ္ထိတိ ရ္ဘဝတိ တဒနျော ဝိစ္ဆေဒေါ ယုၐ္မန္မဓျေ န ဘဝတု, တတး ပရမ် ဣန္ဒြိယာဏာမ် အဓဲရျျာတ် ၑယတာန် ယဒ် ယုၐ္မာန် ပရီက္ၐာံ န နယေတ် တဒရ္ထံ ပုနရေကတြ မိလတ၊ ");
INSERT INTO sanbur_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","ဧတဒ် အာဒေၑတော နဟိ ကိန္တွနုဇ္ဉာတ ဧဝ မယာ ကထျတေ, ");
INSERT INTO sanbur_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","ယတော မမာဝသ္ထေဝ သရွွမာနဝါနာမဝသ္ထာ ဘဝတွိတိ မမ ဝါဉ္ဆာ ကိန္တွီၑွရာဒ် ဧကေနဲကော ဝရော'နျေန စာနျော ဝရ ဣတ္ထမေကဲကေန သွကီယဝရော လဗ္ဓး၊ ");
INSERT INTO sanbur_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","အပရမ် အကၖတဝိဝါဟာန် ဝိဓဝါၑ္စ ပြတိ မမဲတန္နိဝေဒနံ မမေဝ တေၐာမဝသ္ထိတိ ရ္ဘဒြာ; ");
INSERT INTO sanbur_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","ကိဉ္စ ယဒိ တဲရိန္ဒြိယာဏိ နိယန္တုံ န ၑကျန္တေ တရှိ ဝိဝါဟး ကြိယတာံ ယတး ကာမဒဟနာဒ် ဝျူဎတွံ ဘဒြံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","ယေ စ ကၖတဝိဝါဟာသ္တေ မယာ နဟိ ပြဘုနဲဝဲတဒ် အာဇ္ဉာပျန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","ဘာရျျာ ဘရ္တ္တၖတး ပၖထက် န ဘဝတု၊ ယဒိ ဝါ ပၖထဂ္ဘူတာ သျာတ် တရှိ နိရွိဝါဟာ တိၐ္ဌတု သွီယပတိနာ ဝါ သန္ဒဓာတု ဘရ္တ္တာပိ ဘာရျျာံ န တျဇတု၊ ");
INSERT INTO sanbur_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","ဣတရာန် ဇနာန် ပြတိ ပြဘု ရ္န ဗြဝီတိ ကိန္တွဟံ ဗြဝီမိ; ကသျစိဒ် ဘြာတုရျောၐိဒ် အဝိၑွာသိနီ သတျပိ ယဒိ တေန သဟဝါသေ တုၐျတိ တရှိ သာ တေန န တျဇျတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","တဒွတ် ကသျာၑ္စိဒ် ယောၐိတး ပတိရဝိၑွာသီ သန္နပိ ယဒိ တယာ သဟဝါသေ တုၐျတိ တရှိ သ တယာ န တျဇျတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","ယတော'ဝိၑွာသီ ဘရ္တ္တာ ဘာရျျယာ ပဝိတြီဘူတး, တဒွဒဝိၑွာသိနီ ဘာရျျာ ဘရ္တြာ ပဝိတြီဘူတာ; နောစေဒ် ယုၐ္မာကမပတျာနျၑုစီနျဘဝိၐျန် ကိန္တွဓုနာ တာနိ ပဝိတြာဏိ သန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","အဝိၑွာသီ ဇနော ယဒိ ဝါ ပၖထဂ် ဘဝတိ တရှိ ပၖထဂ် ဘဝတု; ဧတေန ဘြာတာ ဘဂိနီ ဝါ န နိဗဓျတေ တထာပိ ဝယမီၑွရေဏ ၑာန္တယေ သမာဟူတား၊ ");
INSERT INTO sanbur_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","ဟေ နာရိ တဝ ဘရ္တ္တုး ပရိတြာဏံ တွတ္တော ဘဝိၐျတိ န ဝေတိ တွယာ ကိံ ဇ္ဉာယတေ? ဟေ နရ တဝ ဇာယာယား ပရိတြာဏံ တွတ္တေा ဘဝိၐျတိ န ဝေတိ တွယာ ကိံ ဇ္ဉာယတေ? ");
INSERT INTO sanbur_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","ဧကဲကော ဇနး ပရမေၑွရာလ္လဗ္ဓံ ယဒ် ဘဇတေ ယသျာဉ္စာဝသ္ထာယာမ် ဤၑွရေဏာဟွာယိ တဒနုသာရေဏဲဝါစရတု တဒဟံ သရွွသမာဇသ္ထာန် အာဒိၑာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","ဆိန္နတွဂ် ဘၖတွာ ယ အာဟူတး သ ပြကၖၐ္ဋတွက် န ဘဝတု, တဒွဒ် အဆိန္နတွဂ် ဘူတွာ ယ အာဟူတး သ ဆိန္နတွက် န ဘဝတု၊ ");
INSERT INTO sanbur_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","တွက္ဆေဒး သာရော နဟိ တဒွဒတွက္ဆေဒေါ'ပိ သာရော နဟိ ကိန္တွီၑွရသျာဇ္ဉာနာံ ပါလနမေဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","ယော ဇနော ယသျာမဝသ္ထာယာမာဟွာယိ သ တသျာမေဝါဝတိၐ္ဌတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","ဒါသး သန် တွံ ကိမာဟူတော'သိ? တန္မာ စိန္တယ, တထာစ ယဒိ သွတန္တြော ဘဝိတုံ ၑက္နုယာသ္တရှိ တဒေဝ ဝၖဏု၊ ");
INSERT INTO sanbur_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","ယတး ပြဘုနာဟူတော ယော ဒါသး သ ပြဘော ရ္မောစိတဇနး၊ တဒွဒ် တေနာဟူတး သွတန္တြော ဇနော'ပိ ခြီၐ္ဋသျ ဒါသ ဧဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","ယူယံ မူလျေန ကြီတာ အတော ဟေတော ရ္မာနဝါနာံ ဒါသာ မာ ဘဝတ၊ ");
INSERT INTO sanbur_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","ဟေ ဘြာတရော ယသျာမဝသ္ထာယာံ ယသျာဟွာနမဘဝတ် တယာ သ ဤၑွရသျ သာက္ၐာတ် တိၐ္ဌတု၊ ");
INSERT INTO sanbur_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","အပရမ် အကၖတဝိဝါဟာန် ဇနာန် ပြတိ ပြဘေား ကော'ပျာဒေၑော မယာ န လဗ္ဓး ကိန္တု ပြဘောရနုကမ္ပယာ ဝိၑွာသျော ဘူတော'ဟံ ယဒ် ဘဒြံ မနျေ တဒ် ဝဒါမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","ဝရ္တ္တမာနာတ် က္လေၑသမယာတ် မနုၐျသျာနူဎတွံ ဘဒြမိတိ မယာ ဗုဓျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","တွံ ကိံ ယောၐိတိ နိဗဒ္ဓေါ'သိ တရှိ မောစနံ ပြာပ္တုံ မာ ယတသွ၊ ကိံ ဝါ ယောၐိတော မုက္တော'သိ? တရှိ ဇာယာံ မာ ဂဝေၐယ၊ ");
INSERT INTO sanbur_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","ဝိဝါဟံ ကုရွွတာ တွယာ ကိမပိ နာပါရာဓျတေ တဒွဒ် ဝျူဟျမာနယာ ယုဝတျာပိ ကိမပိ နာပရာဓျတေ တထာစ တာဒၖၑော် ဒွေါ် ဇနော် ၑာရီရိကံ က္လေၑံ လပ္သျေတေ ကိန္တု ယုၐ္မာန် ပြတိ မမ ကရုဏာ ဝိဒျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","ဟေ ဘြာတရော'ဟမိဒံ ဗြဝီမိ, ဣတး ပရံ သမယော'တီဝ သံက္ၐိပ္တး, ");
INSERT INTO sanbur_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","အတး ကၖတဒါရဲရကၖတဒါရဲရိဝ ရုဒဒ္ဘိၑ္စာရုဒဒ္ဘိရိဝ သာနန္ဒဲၑ္စ နိရာနန္ဒဲရိဝ ကြေတၖဘိၑ္စာဘာဂိဘိရိဝါစရိတဝျံ ");
INSERT INTO sanbur_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","ယေ စ သံသာရေ စရန္တိ တဲ ရ္နာတိစရိတဝျံ ယတ ဣဟလေाကသျ ကော်တုကော ဝိစလတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","ကိန္တု ယူယံ ယန္နိၑ္စိန္တာ ဘဝေတေတိ မမ ဝါဉ္ဆာ၊ အကၖတဝိဝါဟော ဇနော ယထာ ပြဘုံ ပရိတောၐယေတ် တထာ ပြဘုံ စိန္တယတိ, ");
INSERT INTO sanbur_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","ကိန္တု ကၖတဝိဝါဟော ဇနော ယထာ ဘာရျျာံ ပရိတောၐယေတ် တထာ သံသာရံ စိန္တယတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","တဒွဒ် ဦဎယောၐိတော 'နူဎာ ဝိၑိၐျတေ၊ ယာနူဎာ သာ ယထာ ကာယမနသေား ပဝိတြာ ဘဝေတ် တထာ ပြဘုံ စိန္တယတိ ယာ စောဎာ သာ ယထာ ဘရ္တ္တာရံ ပရိတောၐယေတ် တထာ သံသာရံ စိန္တယတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","အဟံ ယဒ် ယုၐ္မာန် မၖဂဗန္ဓိနျာ ပရိက္ၐိပေယံ တဒရ္ထံ နဟိ ကိန္တု ယူယံ ယဒနိန္ဒိတာ ဘူတွာ ပြဘေား သေဝနေ'ဗာဓမ် အာသက္တာ ဘဝေတ တဒရ္ထမေတာနိ သရွွာဏိ ယုၐ္မာကံ ဟိတာယ မယာ ကထျန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","ကသျစိတ် ကနျာယာံ ယော်ဝနပြာပ္တာယာံ ယဒိ သ တသျာ အနူဎတွံ နိန္ဒနီယံ ဝိဝါဟၑ္စ သာဓယိတဝျ ဣတိ မနျတေ တရှိ ယထာဘိလာၐံ ကရောတု, ဧတေန ကိမပိ နာပရာတ္သျတိ ဝိဝါဟး ကြိယတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","ကိန္တု ဒုးခေနာက္လိၐ္ဋး ကၑ္စိတ် ပိတာ ယဒိ သ္ထိရမနောဂတး သွမနော'ဘိလာၐသာဓနေ သမရ္ထၑ္စ သျာတ် မမ ကနျာ မယာ ရက္ၐိတဝျေတိ မနသိ နိၑ္စိနောတိ စ တရှိ သ ဘဒြံ ကရ္မ္မ ကရောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","အတော ယော ဝိဝါဟံ ကရောတိ သ ဘဒြံ ကရ္မ္မ ကရောတိ ယၑ္စ ဝိဝါဟံ န ကရောတိ သ ဘဒြတရံ ကရ္မ္မ ကရောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","ယာဝတ္ကာလံ ပတိ ရ္ဇီဝတိ တာဝဒ် ဘာရျျာ ဝျဝသ္ထယာ နိဗဒ္ဓါ တိၐ္ဌတိ ကိန္တု ပတျော် မဟာနိဒြာံ ဂတေ သာ မုက္တီဘူယ ယမဘိလၐတိ တေန သဟ တသျာ ဝိဝါဟော ဘဝိတုံ ၑက္နောတိ, ကိန္တွေတတ် ကေဝလံ ပြဘုဘက္တာနာံ မဓျေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","တထာစ သာ ယဒိ နိၐ္ပတိကာ တိၐ္ဌတိ တရှိ တသျား က္ၐေမံ ဘဝိၐျတီတိ မမ ဘာဝး၊ အပရမ် ဤၑွရသျာတ္မာ မမာပျန္တ ရွိဒျတ ဣတိ မယာ ဗုဓျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","ဒေဝပြသာဒေ သရွွေၐာမ် အသ္မာကံ ဇ္ဉာနမာသ္တေ တဒွယံ ဝိဒ္မး၊ တထာပိ ဇ္ဉာနံ ဂရွွံ ဇနယတိ ကိန္တု ပြေမတော နိၐ္ဌာ ဇာယတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","အတး ကၑ္စန ယဒိ မနျတေ မမ ဇ္ဉာနမာသ္တ ဣတိ တရှိ တေန ယာဒၖၑံ ဇ္ဉာနံ စေၐ္ဋိတဝျံ တာဒၖၑံ ကိမပိ ဇ္ဉာနမဒျာပိ န လဗ္ဓံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","ကိန္တု ယ ဤၑွရေ ပြီယတေ သ ဤၑွရေဏာပိ ဇ္ဉာယတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","ဒေဝတာဗလိပြသာဒဘက္ၐဏေ ဝယမိဒံ ဝိဒ္မေါ ယတ် ဇဂန္မဓျေ ကော'ပိ ဒေဝေါ န ဝိဒျတေ, ဧကၑ္စေၑွရော ဒွိတီယော နာသ္တီတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","သွရ္ဂေ ပၖထိဝျာံ ဝါ ယဒျပိ ကေၐုစိဒ် ဤၑွရ ဣတိ နာမာရောပျတေ တာဒၖၑာၑ္စ ဗဟဝ ဤၑွရာ ဗဟဝၑ္စ ပြဘဝေါ ဝိဒျန္တေ ");
INSERT INTO sanbur_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","တထာပျသ္မာကမဒွိတီယ ဤၑွရး သ ပိတာ ယသ္မာတ် သရွွေၐာံ ယဒရ္ထဉ္စာသ္မာကံ သၖၐ္ဋိ ရ္ဇာတာ, အသ္မာကဉ္စာဒွိတီယး ပြဘုး သ ယီၑုး ခြီၐ္ဋော ယေန သရွွဝသ္တူနာံ ယေနာသ္မာကမပိ သၖၐ္ဋိး ကၖတာ၊ ");
INSERT INTO sanbur_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","အဓိကန္တု ဇ္ဉာနံ သရွွေၐာံ နာသ္တိ ယတး ကေစိဒဒျာပိ ဒေဝတာံ သမ္မနျ ဒေဝပြသာဒမိဝ တဒ် ဘက္ၐျံ ဘုဉ္ဇတေ တေန ဒုရ္ဗ္ဗလတယာ တေၐာံ သွာန္တာနိ မလီမသာနိ ဘဝန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","ကိန္တု ဘက္ၐျဒြဝျာဒ် ဝယမ် ဤၑွရေဏ ဂြာဟျာ ဘဝါမသ္တန္နဟိ ယတော ဘုင်္က္တွာ ဝယမုတ္ကၖၐ္ဋာ န ဘဝါမသ္တဒွဒဘုင်္က္တွာပျပကၖၐ္ဋာ န ဘဝါမး၊ ");
INSERT INTO sanbur_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","အတော ယုၐ္မာကံ ယာ က္ၐမတာ သာ ဒုရ္ဗ္ဗလာနာမ် ဥန္မာထသွရူပါ ယန္န ဘဝေတ် တဒရ္ထံ သာဝဓာနာ ဘဝတ၊ ");
INSERT INTO sanbur_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","ယတော ဇ္ဉာနဝိၑိၐ္ဋသ္တွံ ယဒိ ဒေဝါလယေ ဥပဝိၐ္ဋး ကေနာပိ ဒၖၑျသေ တရှိ တသျ ဒုရ္ဗ္ဗလသျ မနသိ ကိံ ပြသာဒဘက္ၐဏ ဥတ္သာဟော န ဇနိၐျတေ? ");
INSERT INTO sanbur_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","တထာ သတိ ယသျ ကၖတေ ခြီၐ္ဋော မမာရ တဝ သ ဒုရ္ဗ္ဗလော ဘြာတာ တဝ ဇ္ဉာနာတ် ကိံ န ဝိနံက္ၐျတိ? ");
INSERT INTO sanbur_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","ဣတျနေန ပြကာရေဏ ဘြာတၖဏာံ ဝိရုဒ္ဓမ် အပရာဓျဒ္ဘိသ္တေၐာံ ဒုရ္ဗ္ဗလာနိ မနာံသိ ဝျာဃာတယဒ္ဘိၑ္စ ယုၐ္မာဘိး ခြီၐ္ဋသျ ဝဲပရီတျေနာပရာဓျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","အတော ဟေတေား ပိၑိတာၑနံ ယဒိ မမ ဘြာတု ရွိဃ္နသွရူပံ ဘဝေတ် တရှျဟံ ယတ် သွဘြာတု ရွိဃ္နဇနကော န ဘဝေယံ တဒရ္ထံ ယာဝဇ္ဇီဝနံ ပိၑိတံ န ဘောက္ၐျေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","အဟံ ကိမ် ဧကး ပြေရိတော နာသ္မိ? ကိမဟံ သွတန္တြော နာသ္မိ? အသ္မာကံ ပြဘု ရျီၑုး ခြီၐ္ဋး ကိံ မယာ နာဒရ္ၑိ? ယူယမပိ ကိံ ပြဘုနာ မဒီယၑြမဖလသွရူပါ န ဘဝထ? ");
INSERT INTO sanbur_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","အနျလောကာနာံ ကၖတေ ယဒျပျဟံ ပြေရိတော န ဘဝေယံ တထာစ ယုၐ္မတ္ကၖတေ ပြေရိတော'သ္မိ ယတး ပြဘုနာ မမ ပြေရိတတွပဒသျ မုဒြာသွရူပါ ယူယမေဝါဓွေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","ယေ လောကာ မယိ ဒေါၐမာရောပယန္တိ တာန် ပြတိ မမ ပြတျုတ္တရမေတတ်၊ ");
INSERT INTO sanbur_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","ဘောဇနပါနယေား ကိမသ္မာကံ က္ၐမတာ နာသ္တိ? ");
INSERT INTO sanbur_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","အနျေ ပြေရိတား ပြဘော ရ္ဘြာတရော် ကဲဖာၑ္စ ယတ် ကုရွွန္တိ တဒွတ် ကာဉ္စိတ် ဓရ္မ္မဘဂိနီံ ဝျူဟျ တယာ သာရ္ဒ္ဓံ ပရျျဋိတုံ ဝယံ ကိံ န ၑက္နုမး? ");
INSERT INTO sanbur_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","သာံသာရိကၑြမသျ ပရိတျာဂါတ် ကိံ ကေဝလမဟံ ဗရ္ဏဗ္ဗာၑ္စ နိဝါရိတော်? ");
INSERT INTO sanbur_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","နိဇဓနဝျယေန ကး သံဂြာမံ ကရောတိ? ကော ဝါ ဒြာက္ၐာက္ၐေတြံ ကၖတွာ တတ္ဖလာနိ န ဘုင်္က္တေ? ကော ဝါ ပၑုဝြဇံ ပါလယန် တတ္ပယော န ပိဝတိ? ");
INSERT INTO sanbur_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","ကိမဟံ ကေဝလာံ မာနုၐိကာံ ဝါစံ ဝဒါမိ? ဝျဝသ္ထာယာံ ကိမေတာဒၖၑံ ဝစနံ န ဝိဒျတေ? ");
INSERT INTO sanbur_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","မူသာဝျဝသ္ထာဂြန္ထေ လိခိတမာသ္တေ, တွံ ၑသျမရ္ဒ္ဒကဝၖၐသျာသျံ န ဘံတ္သျသီတိ၊ ဤၑွရေဏ ဗလီဝရ္ဒ္ဒါနာမေဝ စိန္တာ ကိံ ကြိယတေ? ");
INSERT INTO sanbur_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","ကိံ ဝါ သရွွထာသ္မာကံ ကၖတေ တဒွစနံ တေနောက္တံ? အသ္မာကမေဝ ကၖတေ တလ္လိခိတံ၊ ယး က္ၐေတြံ ကရ္ၐတိ တေန ပြတျာၑာယုက္တေန ကရ္ၐ္ဋဝျံ, ယၑ္စ ၑသျာနိ မရ္ဒ္ဒယတိ တေန လာဘပြတျာၑာယုက္တေန မရ္ဒ္ဒိတဝျံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","ယုၐ္မတ္ကၖတေ'သ္မာဘိး ပါရတြိကာဏိ ဗီဇာနိ ရောပိတာနိ, အတော ယုၐ္မာကမဲဟိကဖလာနာံ ဝယမ် အံၑိနော ဘဝိၐျာမး ကိမေတတ် မဟတ် ကရ္မ္မ? ");
INSERT INTO sanbur_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","ယုၐ္မာသု ယော'ဓိကာရသ္တသျ ဘာဂိနော ယဒျနျေ ဘဝေယုသ္တရှျသ္မာဘိသ္တတော'ဓိကံ ကိံ တသျ ဘာဂိဘိ ရ္န ဘဝိတဝျံ? အဓိကန္တု ဝယံ တေနာဓိကာရေဏ န ဝျဝဟၖတဝန္တး ကိန္တု ခြီၐ္ဋီယသုသံဝါဒသျ ကော'ပိ ဝျာဃာတော'သ္မာဘိရျန္န ဇာယေတ တဒရ္ထံ သရွွံ သဟာမဟေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","အပရံ ယေ ပဝိတြဝသ္တူနာံ ပရိစရျျာံ ကုရွွန္တိ တေ ပဝိတြဝသ္တုတော ဘက္ၐျာဏိ လဘန္တေ, ယေ စ ဝေဒျား ပရိစရျျာံ ကုရွွန္တိ တေ ဝေဒိသ္ထဝသ္တူနာမ် အံၑိနော ဘဝန္တျေတဒ် ယူယံ ကိံ န ဝိဒ? ");
INSERT INTO sanbur_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","တဒွဒ် ယေ သုသံဝါဒံ ဃောၐယန္တိ တဲး သုသံဝါဒေန ဇီဝိတဝျမိတိ ပြဘုနာဒိၐ္ဋံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","အဟမေတေၐာံ သရွွေၐာံ ကိမပိ နာၑြိတဝါန် မာံ ပြတိ တဒနုသာရာတ် အာစရိတဝျမိတျာၑယေနာပိ ပတြမိဒံ မယာ န လိချတေ ယတး ကေနာပိ ဇနေန မမ ယၑသော မုဓာကရဏာတ် မမ မရဏံ ဝရံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","သုသံဝါဒဃေၐဏာတ် မမ ယၑော န ဇာယတေ ယတသ္တဒ္ဃေါၐဏံ မမာဝၑျကံ ယဒျဟံ သုသံဝါဒံ န ဃောၐယေယံ တရှိ မာံ ဓိက်၊ ");
INSERT INTO sanbur_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","ဣစ္ဆုကေန တတ် ကုရွွတာ မယာ ဖလံ လပ္သျတေ ကိန္တွနိစ္ဆုကေ'ပိ မယိ တတ္ကရ္မ္မဏော ဘာရော'ရ္ပိတော'သ္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","ဧတေန မယာ လဘျံ ဖလံ ကိံ? သုသံဝါဒေန မမ ယော'ဓိကာရ အာသ္တေ တံ ယဒဘဒြဘာဝေန နာစရေယံ တဒရ္ထံ သုသံဝါဒဃောၐဏသမယေ တသျ ခြီၐ္ဋီယသုသံဝါဒသျ နိရွျယီကရဏမေဝ မမ ဖလံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","သရွွေၐာမ် အနာယတ္တော'ဟံ ယဒ် ဘူရိၑော လောကာန် ပြတိပဒျေ တဒရ္ထံ သရွွေၐာံ ဒါသတွမင်္ဂီကၖတဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","ယိဟူဒီယာန် ယတ် ပြတိပဒျေ တဒရ္ထံ ယိဟူဒီယာနာံ ကၖတေ ယိဟူဒီယဣဝါဘဝံ၊ ယေ စ ဝျဝသ္ထာယတ္တာသ္တာန် ယတ် ပြတိပဒျေ တဒရ္ထံ ဝျဝသ္ထာနာယတ္တော ယော'ဟံ သော'ဟံ ဝျဝသ္ထာယတ္တာနာံ ကၖတေ ဝျဝသ္ထာယတ္တဣဝါဘဝံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","ယေ စာလဗ္ဓဝျဝသ္ထာသ္တာန် ယတ် ပြတိပဒျေ တဒရ္ထမ် ဤၑွရသျ သာက္ၐာဒ် အလဗ္ဓဝျဝသ္ထော န ဘူတွာ ခြီၐ္ဋေန လဗ္ဓဝျဝသ္ထော ယော'ဟံ သော'ဟမ် အလဗ္ဓဝျဝသ္ထာနာံ ကၖတေ'လဗ္ဓဝျဝသ္ထ ဣဝါဘဝံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","ဒုရ္ဗ္ဗလာန် ယတ် ပြတိပဒျေ တဒရ္ထမဟံ ဒုရ္ဗ္ဗလာနာံ ကၖတေ ဒုရ္ဗ္ဗလဣဝါဘဝံ၊ ဣတ္ထံ ကေနာပိ ပြကာရေဏ ကတိပယာ လောကာ ယန္မယာ ပရိတြာဏံ ပြာပ္နုယုသ္တဒရ္ထံ ယော ယာဒၖၑ အာသီတ် တသျ ကၖတေ 'ဟံ တာဒၖၑဣဝါဘဝံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","ဣဒၖၑ အာစာရး သုသံဝါဒါရ္ထံ မယာ ကြိယတေ ယတော'ဟံ တသျ ဖလာနာံ သဟဘာဂီ ဘဝိတုမိစ္ဆာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","ပဏျလာဘာရ္ထံ ယေ ဓာဝန္တိ ဓာဝတာံ တေၐာံ သရွွေၐာံ ကေဝလ ဧကး ပဏျံ လဘတေ ယုၐ္မာဘိး ကိမေတန္န ဇ္ဉာယတေ? အတော ယူယံ ယထာ ပဏျံ လပ္သျဓွေ တထဲဝ ဓာဝတ၊ ");
INSERT INTO sanbur_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","မလ္လာ အပိ သရွွဘောဂေ ပရိမိတဘောဂိနော ဘဝန္တိ တေ တု မ္လာနာံ သြဇံ လိပ္သန္တေ ကိန္တု ဝယမ် အမ္လာနာံ လိပ္သာမဟေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","တသ္မာဒ် အဟမပိ ဓာဝါမိ ကိန္တု လက္ၐျမနုဒ္ဒိၑျ ဓာဝါမိ တန္နဟိ၊ အဟံ မလ္လဣဝ ယုဓျာမိ စ ကိန္တု ဆာယာမာဃာတယန္နိဝ ယုဓျာမိ တန္နဟိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","ဣတရာန် ပြတိ သုသံဝါဒံ ဃောၐယိတွာဟံ ယတ် သွယမဂြာဟျော န ဘဝါမိ တဒရ္ထံ ဒေဟမ် အာဟန္မိ ဝၑီကုရွွေ စ၊ ");
INSERT INTO sanbur_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","ဟေ ဘြာတရး, အသ္မတ္ပိတၖပုရုၐာနဓိ ယူယံ ယဒဇ္ဉာတာ န တိၐ္ဌတေတိ မမ ဝါဉ္ဆာ, တေ သရွွေ မေဃာဓးသ္ထိတာ ဗဘူဝုး သရွွေ သမုဒြမဓျေန ဝဝြဇုး, ");
INSERT INTO sanbur_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","သရွွေ မူသာမုဒ္ဒိၑျ မေဃသမုဒြယော ရ္မဇ္ဇိတာ ဗဘူဝုး ");
INSERT INTO sanbur_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","သရွွ ဧကမ် အာတ္မိကံ ဘက္ၐျံ ဗုဘုဇိရ ဧကမ် အာတ္မိကံ ပေယံ ပပုၑ္စ ");
INSERT INTO sanbur_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","ယတသ္တေ'နုစရတ အာတ္မိကာဒ် အစလာတ် လဗ္ဓံ တောယံ ပပုး သော'စလး ခြီၐ္ဋဧဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","တထာ သတျပိ တေၐာံ မဓျေ'ဓိကေၐု လောကေၐွီၑွရော န သန္တုတောၐေတိ ဟေတောသ္တေ ပြန္တရေ နိပါတိတား၊ ");
INSERT INTO sanbur_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","ဧတသ္မိန် တေ 'သ္မာကံ နိဒရ္ၑနသွရူပါ ဗဘူဝုး; အတသ္တေ ယထာ ကုတ္သိတာဘိလာၐိဏော ဗဘူဝုရသ္မာဘိသ္တထာ ကုတ္သိတာဘိလာၐိဘိ ရ္န ဘဝိတဝျံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","လိခိတမာသ္တေ, လောကာ ဘောက္တုံ ပါတုဉ္စောပဝိဝိၑုသ္တတး ကြီဍိတုမုတ္ထိတာ ဣတယနေန ပြကာရေဏ တေၐာံ ကဲၑ္စိဒ် ယဒွဒ် ဒေဝပူဇာ ကၖတာ ယုၐ္မာဘိသ္တဒွတ် န ကြိယတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","အပရံ တေၐာံ ကဲၑ္စိဒ် ယဒွဒ် ဝျဘိစာရး ကၖတသ္တေန စဲကသ္မိန် ဒိနေ တြယောဝိံၑတိသဟသြာဏိ လောကာ နိပါတိတာသ္တဒွဒ် အသ္မာဘိ ရွျဘိစာရော န ကရ္တ္တဝျး၊ ");
INSERT INTO sanbur_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","တေၐာံ ကေစိဒ် ယဒွတ် ခြီၐ္ဋံ ပရီက္ၐိတဝန္တသ္တသ္မာဒ် ဘုဇင်္ဂဲ ရ္နၐ္ဋာၑ္စ တဒွဒ် အသ္မာဘိး ခြီၐ္ဋော န ပရီက္ၐိတဝျး၊ ");
INSERT INTO sanbur_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","တေၐာံ ကေစိဒ် ယထာ ဝါက္ကလဟံ ကၖတဝန္တသ္တတ္ကာရဏာတ် ဟန္တြာ ဝိနာၑိတာၑ္စ ယုၐ္မာဘိသ္တဒွဒ် ဝါက္ကလဟော န ကြိယတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","တာန် ပြတိ ယာနျေတာနိ ဇဃဋိရေ တာနျသ္မာကံ နိဒရ္ၑနာနိ ဇဂတး ၑေၐယုဂေ ဝရ္တ္တမာနာနာမ် အသ္မာကံ ၑိက္ၐာရ္ထံ လိခိတာနိ စ ဗဘူဝုး၊ ");
INSERT INTO sanbur_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","အတဧဝ ယး ကၑ္စိဒ် သုသ္ထိရံမနျး သ ယန္န ပတေတ် တတြ သာဝဓာနော ဘဝတု၊ ");
INSERT INTO sanbur_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","မာနုၐိကပရီက္ၐာတိရိက္တာ ကာပိ ပရီက္ၐာ ယုၐ္မာန် နာကြာမတ်, ဤၑွရၑ္စ ဝိၑွာသျး သော'တိၑက္တျာံ ပရီက္ၐာယာံ ပတနာတ် ယုၐ္မာန် ရက္ၐိၐျတိ, ပရီက္ၐာ စ ယဒ် ယုၐ္မာဘိး သောဎုံ ၑကျတေ တဒရ္ထံ တယာ သဟ နိသ္တာရသျ ပန္ထာနံ နိရူပယိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","ဟေ ပြိယဘြာတရး, ဒေဝပူဇာတော ဒူရမ် အပသရတ၊ ");
INSERT INTO sanbur_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","အဟံ ယုၐ္မာန် ဝိဇ္ဉာန် မတွာ ပြဘာၐေ မယာ ယတ် ကထျတေ တဒ် ယုၐ္မာဘိ ရွိဝိစျတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","ယဒ် ဓနျဝါဒပါတြမ် အသ္မာဘိ ရ္ဓနျံ ဂဒျတေ တတ် ကိံ ခြီၐ္ဋသျ ၑောဏိတသျ သဟဘာဂိတွံ နဟိ? ယၑ္စ ပူပေါ'သ္မာဘိ ရ္ဘဇျတေ သ ကိံ ခြီၐ္ဋသျ ဝပုၐး သဟဘာဂိတွံ နဟိ? ");
INSERT INTO sanbur_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","ဝယံ ဗဟဝး သန္တော'ပျေကပူပသွရူပါ ဧကဝပုးသွရူပါၑ္စ ဘဝါမး, ယတော ဝယံ သရွွ ဧကပူပသျ သဟဘာဂိနး၊ ");
INSERT INTO sanbur_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","ယူယံ ၑာရီရိကမ် ဣသြာယေလီယဝံၑံ နိရီက္ၐဓွံ၊ ယေ ဗလီနာံ မာံသာနိ ဘုဉ္ဇတေ တေ ကိံ ယဇ္ဉဝေဒျား သဟဘာဂိနော န ဘဝန္တိ? ");
INSERT INTO sanbur_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","ဣတျနေန မယာ ကိံ ကထျတေ? ဒေဝတာ ဝါသ္တဝိကီ ဒေဝတာယဲ ဗလိဒါနံ ဝါ ဝါသ္တဝိကံ ကိံ ဘဝေတ်? ");
INSERT INTO sanbur_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","တန္နဟိ ကိန္တု ဘိန္နဇာတိဘိ ရျေ ဗလယော ဒီယန္တေ တ ဤၑွရာယ တန္နဟိ ဘူတေဘျဧဝ ဒီယန္တေ တသ္မာဒ် ယူယံ ယဒ် ဘူတာနာံ သဟဘာဂိနော ဘဝထေတျဟံ နာဘိလၐာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","ပြဘေား ကံသေန ဘူတာနာမပိ ကံသေန ပါနံ ယုၐ္မာဘိရသာဓျံ; ယူယံ ပြဘော ရ္ဘောဇျသျ ဘူတာနာမပိ ဘောဇျသျ သဟဘာဂိနော ဘဝိတုံ န ၑက္နုထ၊ ");
INSERT INTO sanbur_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","ဝယံ ကိံ ပြဘုံ သ္ပရ္ဒ္ဓိၐျာမဟေ? ဝယံ ကိံ တသ္မာဒ် ဗလဝန္တး? ");
INSERT INTO sanbur_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","မာံ ပြတိ သရွွံ ကရ္မ္မာပြတိၐိဒ္ဓံ ကိန္တု န သရွွံ ဟိတဇနကံ သရွွမ် အပြတိၐိဒ္ဓံ ကိန္တု န သရွွံ နိၐ္ဌာဇနကံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","အာတ္မဟိတး ကေနာပိ န စေၐ္ဋိတဝျး ကိန္တု သရွွဲး ပရဟိတၑ္စေၐ္ဋိတဝျး၊ ");
INSERT INTO sanbur_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","အာပဏေ ယတ် ကြယျံ တဒ် ယုၐ္မာဘိး သံဝေဒသျာရ္ထံ ကိမပိ န ပၖၐ္ဋွာ ဘုဇျတာံ ");
INSERT INTO sanbur_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","ယတး ပၖထိဝီ တန္မဓျသ္ထဉ္စ သရွွံ ပရမေၑွရသျ၊ ");
INSERT INTO sanbur_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","အပရမ် အဝိၑွာသိလောကာနာံ ကေနစိတ် နိမန္တြိတာ ယူယံ ယဒိ တတြ ဇိဂမိၐထ တရှိ တေန ယဒ် ယဒ် ဥပသ္ထာပျတေ တဒ် ယုၐ္မာဘိး သံဝေဒသျာရ္ထံ ကိမပိ န ပၖၐ္ဋွာ ဘုဇျတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","ကိန္တု တတြ ယဒိ ကၑ္စိဒ် ယုၐ္မာန် ဝဒေတ် ဘက္ၐျမေတဒ် ဒေဝတာယား ပြသာဒ ဣတိ တရှိ တသျ ဇ္ဉာပယိတုရနုရောဓာတ် သံဝေဒသျာရ္ထဉ္စ တဒ် ယုၐ္မာဘိ ရ္န ဘောက္တဝျံ၊ ပၖထိဝီ တန္မဓျသ္ထဉ္စ သရွွံ ပရမေၑွရသျ, ");
INSERT INTO sanbur_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","သတျမေတတ်, ကိန္တု မယာ ယး သံဝေဒေါ နိရ္ဒ္ဒိၑျတေ သ တဝ နဟိ ပရသျဲဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","အနုဂြဟပါတြေဏ မယာ ဓနျဝါဒံ ကၖတွာ ယဒ် ဘုဇျတေ တတ္ကာရဏာဒ် အဟံ ကုတော နိန္ဒိၐျေ? ");
INSERT INTO sanbur_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","တသ္မာဒ် ဘောဇနံ ပါနမ် အနျဒွါ ကရ္မ္မ ကုရွွဒ္ဘိ ရျုၐ္မာဘိး သရွွမေဝေၑွရသျ မဟိမ္နး ပြကာၑာရ္ထံ ကြိယတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","ယိဟူဒီယာနာံ ဘိန္နဇာတီယာနာမ် ဤၑွရသျ သမာဇသျ ဝါ ဝိဃ္နဇနကဲ ရျုၐ္မာဘိ ရ္န ဘဝိတဝျံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","အဟမပျာတ္မဟိတမ် အစေၐ္ဋမာနော ဗဟူနာံ ပရိတြာဏာရ္ထံ တေၐာံ ဟိတံ စေၐ္ဋမာနး သရွွဝိၐယေ သရွွေၐာံ တုၐ္ဋိကရော ဘဝါမီတျနေနာဟံ ယဒွတ် ခြီၐ္ဋသျာနုဂါမီ တဒွဒ် ယူယံ မမာနုဂါမိနော ဘဝတ၊ ");
INSERT INTO sanbur_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","ဟေ ဘြာတရး, ယူယံ သရွွသ္မိန် ကာရျျေ မာံ သ္မရထ မယာ စ ယာဒၖဂုပဒိၐ္ဋာသ္တာဒၖဂါစရထဲတတ္ကာရဏာတ် မယာ ပြၑံသနီယာ အာဓ္ဗေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","တထာပိ မမဲၐာ ဝါဉ္ဆာ ယဒ် ယူယမိဒမ် အဝဂတာ ဘဝထ, ");
INSERT INTO sanbur_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","ဧကဲကသျ ပုရုၐသျောတ္တမာင်္ဂသွရူပး ခြီၐ္ဋး, ယောၐိတၑ္စောတ္တမာင်္ဂသွရူပး ပုမာန်, ခြီၐ္ဋသျ စောတ္တမာင်္ဂသွရူပ ဤၑွရး၊ ");
INSERT INTO sanbur_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","အပရမ် အာစ္ဆာဒိတောတ္တမာင်္ဂေန ယေန ပုံသာ ပြာရ္ထနာ ကြိယတ ဤၑွရီယဝါဏီ ကထျတေ ဝါ တေန သွီယောတ္တမာင်္ဂမ် အဝဇ္ဉာယတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","အနာစ္ဆာဒိတောတ္တမာင်္ဂယာ ယယာ ယောၐိတာ စ ပြာရ္ထနာ ကြိယတ ဤၑွရီယဝါဏီ ကထျတေ ဝါ တယာပိ သွီယောတ္တမာင်္ဂမ် အဝဇ္ဉာယတေ ယတး သာ မုဏ္ဍိတၑိရးသဒၖၑာ၊ ");
INSERT INTO sanbur_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","အနာစ္ဆာဒိတမသ္တကာ ယာ ယောၐိတ် တသျား ၑိရး မုဏ္ဍနီယမေဝ ကိန္တု ယောၐိတး ကေၑစ္ဆေဒနံ ၑိရောမုဏ္ဍနံ ဝါ ယဒိ လဇ္ဇာဇနကံ ဘဝေတ် တရှိ တယာ သွၑိရ အာစ္ဆာဒျတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","ပုမာန် ဤၑွရသျ ပြတိမူရ္တ္တိး ပြတိတေဇးသွရူပၑ္စ တသ္မာတ် တေန ၑိရော နာစ္ဆာဒနီယံ ကိန္တု သီမန္တိနီ ပုံသး ပြတိဗိမ္ဗသွရူပါ၊ ");
INSERT INTO sanbur_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","ယတော ယောၐာတး ပုမာန် နောဒပါဒိ ကိန္တု ပုံသော ယောၐိဒ် ဥဒပါဒိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","အဓိကန္တု ယောၐိတး ကၖတေ ပုံသး သၖၐ္ဋိ ရ္န ဗဘူဝ ကိန္တု ပုံသး ကၖတေ ယောၐိတး သၖၐ္ဋိ ရ္ဗဘူဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","ဣတိ ဟေတော ရ္ဒူတာနာမ် အာဒရာဒ် ယောၐိတာ ၑိရသျဓီနတာသူစကမ် အာဝရဏံ ဓရ္တ္တဝျံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","တထာပိ ပြဘော ရွိဓိနာ ပုမာံသံ ဝိနာ ယောၐိန္န ဇာယတေ ယောၐိတဉ္စ ဝိနာ ပုမာန် န ဇာယတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","ယတော ယထာ ပုံသော ယောၐိဒ် ဥဒပါဒိ တထာ ယောၐိတး ပုမာန် ဇာယတေ, သရွွဝသ္တူနိ စေၑွရာဒ် ဥတ္ပဒျန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","ယုၐ္မာဘိရေဝဲတဒ် ဝိဝိစျတာံ, အနာဝၖတယာ ယောၐိတာ ပြာရ္ထနံ ကိံ သုဒၖၑျံ ဘဝေတ်? ");
INSERT INTO sanbur_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","ပုရုၐသျ ဒီရ္ဃကေၑတွံ တသျ လဇ္ဇာဇနကံ, ကိန္တု ယောၐိတော ဒီရ္ဃကေၑတွံ တသျာ ဂေါ်ရဝဇနကံ ");
INSERT INTO sanbur_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","ယတ အာစ္ဆာဒနာယ တသျဲ ကေၑာ ဒတ္တာ ဣတိ ကိံ ယုၐ္မာဘိး သွဘာဝတော န ၑိက္ၐျတေ? ");
INSERT INTO sanbur_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","အတြ ယဒိ ကၑ္စိဒ် ဝိဝဒိတုမ် ဣစ္ဆေတ် တရှျသ္မာကမ် ဤၑွရီယသမိတီနာဉ္စ တာဒၖၑီ ရီတိ ရ္န ဝိဒျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","ယုၐ္မာဘိ ရ္န ဘဒြာယ ကိန္တု ကုတ္သိတာယ သမာဂမျတေ တသ္မာဒ် ဧတာနိ ဘာၐမာဏေန မယာ ယူယံ န ပြၑံသနီယား၊ ");
INSERT INTO sanbur_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","ပြထမတး သမိတော် သမာဂတာနာံ ယုၐ္မာကံ မဓျေ ဘေဒါး သန္တီတိ ဝါရ္တ္တာ မယာ ၑြူယတေ တန္မဓျေ ကိဉ္စိတ် သတျံ မနျတေ စ၊ ");
INSERT INTO sanbur_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","ယတော ဟေတော ရျုၐ္မန္မဓျေ ယေ ပရီက္ၐိတာသ္တေ ယတ် ပြကာၑျန္တေ တဒရ္ထံ ဘေဒဲ ရ္ဘဝိတဝျမေဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","ဧကတြ သမာဂတဲ ရျုၐ္မာဘိး ပြဘာဝံ ဘေाဇျံ ဘုဇျတ ဣတိ နဟိ; ");
INSERT INTO sanbur_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","ယတော ဘောဇနကာလေ ယုၐ္မာကမေကဲကေန သွကီယံ ဘက္ၐျံ တူရ္ဏံ ဂြသျတေ တသ္မာဒ် ဧကော ဇနော ဗုဘုက္ၐိတသ္တိၐ္ဌတိ, အနျၑ္စ ပရိတၖပ္တော ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","ဘောဇနပါနာရ္ထံ ယုၐ္မာကံ ကိံ ဝေၑ္မာနိ န သန္တိ? ယုၐ္မာဘိ ရွာ ကိမ် ဤၑွရသျ သမိတိံ တုစ္ဆီကၖတျ ဒီနာ လောကာ အဝဇ္ဉာယန္တေ? ဣတျနေန မယာ ကိံ ဝက္တဝျံ? ယူယံ ကိံ မယာ ပြၑံသနီယား? ဧတသ္မိန် ယူယံ န ပြၑံသနီယား၊ ");
INSERT INTO sanbur_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","ပြဘုတော ယ ဥပဒေၑော မယာ လဗ္ဓော ယုၐ္မာသု သမရ္ပိတၑ္စ သ ဧၐး၊ ");
INSERT INTO sanbur_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","ပရကရသမရ္ပဏက္ၐပါယာံ ပြဘု ရျီၑုး ပူပမာဒါယေၑွရံ ဓနျံ ဝျာဟၖတျ တံ ဘင်္က္တွာ ဘာၐိတဝါန် ယုၐ္မာဘိရေတဒ် ဂၖဟျတာံ ဘုဇျတာဉ္စ တဒ် ယုၐ္မတ္ကၖတေ ဘဂ္နံ မမ ၑရီရံ; မမ သ္မရဏာရ္ထံ ယုၐ္မာဘိရေတတ် ကြိယတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","ပုနၑ္စ ဘေဇနာတ် ပရံ တထဲဝ ကံသမ် အာဒါယ တေနောက္တံ ကံသော'ယံ မမ ၑောဏိတေန သ္ထာပိတော နူတနနိယမး; ယတိဝါရံ ယုၐ္မာဘိရေတတ် ပီယတေ တတိဝါရံ မမ သ္မရဏာရ္ထံ ပီယတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","ယတိဝါရံ ယုၐ္မာဘိရေၐ ပူပေါ ဘုဇျတေ ဘာဇနေနာနေန ပီယတေ စ တတိဝါရံ ပြဘောရာဂမနံ ယာဝတ် တသျ မၖတျုး ပြကာၑျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","အပရဉ္စ ယး ကၑ္စိဒ် အယောဂျတွေန ပြဘောရိမံ ပူပမ် အၑ္နာတိ တသျာနေန ဘာဇနေန ပိဝတိ စ သ ပြဘေား ကာယရုဓိရယော ရ္ဒဏ္ဍဒါယီ ဘဝိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","တသ္မာတ် မာနဝေနာဂြ အာတ္မာန ပရီက္ၐျ ပၑ္စာဒ် ဧၐ ပူပေါ ဘုဇျတာံ ကံသေနာနေန စ ပီယတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","ယေန စာနရှတွေန ဘုဇျတေ ပီယတေ စ ပြဘေား ကာယမ် အဝိမၖၑတာ တေန ဒဏ္ဍပြာပ္တယေ ဘုဇျတေ ပီယတေ စ၊ ");
INSERT INTO sanbur_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","ဧတတ္ကာရဏာဒ် ယုၐ္မာကံ ဘူရိၑော လောကာ ဒုရ္ဗ္ဗလာ ရောဂိဏၑ္စ သန္တိ ဗဟဝၑ္စ မဟာနိဒြာံ ဂတား၊ ");
INSERT INTO sanbur_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","အသ္မာဘိ ရျဒျာတ္မဝိစာရော'ကာရိၐျတ တရှိ ဒဏ္ဍော နာလပ္သျတ; ");
INSERT INTO sanbur_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","ကိန္တု ယဒါသ္မာကံ ဝိစာရော ဘဝတိ တဒါ ဝယံ ဇဂတော ဇနဲး သမံ ယဒ် ဒဏ္ဍံ န လဘာမဟေ တဒရ္ထံ ပြဘုနာ ၑာသ္တိံ ဘုံဇ္မဟေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","ဟေ မမ ဘြာတရး, ဘောဇနာရ္ထံ မိလိတာနာံ ယုၐ္မာကမ် ဧကေနေတရော'နုဂၖဟျတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","ယၑ္စ ဗုဘုက္ၐိတး သ သွဂၖဟေ ဘုင်္က္တာံ၊ ဒဏ္ဍပြာပ္တယေ ယုၐ္မာဘိ ရ္န သမာဂမျတာံ၊ ဧတဒ္ဘိန္နံ ယဒ် အာဒေၐ္ဋဝျံ တဒ် ယုၐ္မတ္သမီပါဂမနကာလေ မယာဒေက္ၐျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","ဟေ ဘြာတရး, ယူယံ ယဒ် အာတ္မိကာန် ဒါယာန် အနဝဂတာသ္တိၐ္ဌထ တဒဟံ နာဘိလၐာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","ပူရွွံ ဘိန္နဇာတီယာ ယူယံ ယဒွဒ် ဝိနီတာသ္တဒွဒ် အဝါက္ပြတိမာနာမ် အနုဂါမိန အာဓ္ဗမ် ဣတိ ဇာနီထ၊ ");
INSERT INTO sanbur_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","ဣတိ ဟေတောရဟံ ယုၐ္မဘျံ နိဝေဒယာမိ, ဤၑွရသျာတ္မနာ ဘာၐမာဏး ကော'ပိ ယီၑုံ ၑပ္တ ဣတိ န ဝျာဟရတိ, ပုနၑ္စ ပဝိတြေဏာတ္မနာ ဝိနီတံ ဝိနာနျး ကော'ပိ ယီၑုံ ပြဘုရိတိ ဝျာဟရ္တ္တုံ န ၑက္နောတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","ဒါယာ ဗဟုဝိဓား ကိန္တွေက အာတ္မာ ");
INSERT INTO sanbur_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","ပရိစရျျာၑ္စ ဗဟုဝိဓား ကိန္တွေကး ပြဘုး၊ ");
INSERT INTO sanbur_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","သာဓနာနိ ဗဟုဝိဓာနိ ကိန္တု သရွွေၐု သရွွသာဓက ဤၑွရ ဧကး၊ ");
INSERT INTO sanbur_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","ဧကဲကသ္မဲ တသျာတ္မနော ဒရ္ၑနံ ပရဟိတာရ္ထံ ဒီယတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","ဧကသ္မဲ တေနာတ္မနာ ဇ္ဉာနဝါကျံ ဒီယတေ, အနျသ္မဲ တေနဲဝါတ္မနာဒိၐ္ဋံ ဝိဒျာဝါကျမ်, ");
INSERT INTO sanbur_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","အနျသ္မဲ တေနဲဝါတ္မနာ ဝိၑွာသး, အနျသ္မဲ တေနဲဝါတ္မနာ သွာသ္ထျဒါနၑက္တိး, ");
INSERT INTO sanbur_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","အနျသ္မဲ ဒုးသာဓျသာဓနၑက္တိရနျသ္မဲ စေၑွရီယာဒေၑး, အနျသ္မဲ စာတိမာနုၐိကသျာဒေၑသျ ဝိစာရသာမရ္ထျမ်, အနျသ္မဲ ပရဘာၐာဘာၐဏၑက္တိရနျသ္မဲ စ ဘာၐာရ္ထဘာၐဏသာမရျံ ဒီယတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","ဧကေနာဒွိတီယေနာတ္မနာ ယထာဘိလာၐမ် ဧကဲကသ္မဲ ဇနာယဲကဲကံ ဒါနံ ဝိတရတာ တာနိ သရွွာဏိ သာဓျန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","ဒေဟ ဧကး သန္နပိ ယဒွဒ် ဗဟွင်္ဂယုက္တော ဘဝတိ, တသျဲကသျ ဝပုၐော 'င်္ဂါနာံ ဗဟုတွေန ယဒွဒ် ဧကံ ဝပု ရ္ဘဝတိ, တဒွတ် ခြီၐ္ဋး၊ ");
INSERT INTO sanbur_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","ယတော ဟေတော ရျိဟူဒိဘိန္နဇာတီယဒါသသွတန္တြာ ဝယံ သရွွေ မဇ္ဇနေနဲကေနာတ္မနဲကဒေဟီကၖတား သရွွေ စဲကာတ္မဘုက္တာ အဘဝါမ၊ ");
INSERT INTO sanbur_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","ဧကေနာင်္ဂေန ဝပု ရ္န ဘဝတိ ကိန္တု ဗဟုဘိး၊ ");
INSERT INTO sanbur_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","တတြ စရဏံ ယဒိ ဝဒေတ် နာဟံ ဟသ္တသ္တသ္မာတ် ၑရီရသျ ဘာဂေါ နာသ္မီတိ တရှျနေန ၑရီရာတ် တသျ ဝိယောဂေါ န ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","ၑြောတြံ ဝါ ယဒိ ဝဒေတ် နာဟံ နယနံ တသ္မာတ် ၑရီရသျာံၑော နာသ္မီတိ တရှျနေန ၑရီရာတ် တသျ ဝိယောဂေါ န ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","ကၖတ္သ္နံ ၑရီရံ ယဒိ ဒရ္ၑနေန္ဒြိယံ ဘဝေတ် တရှိ ၑြဝဏေန္ဒြိယံ ကုတြ သ္ထာသျတိ? တတ် ကၖတ္သ္နံ ယဒိ ဝါ ၑြဝဏေန္ဒြိယံ ဘဝေတ် တရှိ ဃြဏေန္ဒြိယံ ကုတြ သ္ထာသျတိ? ");
INSERT INTO sanbur_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","ကိန္တွိဒါနီမ် ဤၑွရေဏ ယထာဘိလၐိတံ တထဲဝါင်္ဂပြတျင်္ဂါနာမ် ဧကဲကံ ၑရီရေ သ္ထာပိတံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","တတ် ကၖတ္သ္နံ ယဒျေကာင်္ဂရူပိ ဘဝေတ် တရှိ ၑရီရေ ကုတြ သ္ထာသျတိ? ");
INSERT INTO sanbur_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","တသ္မာဒ် အင်္ဂါနိ ဗဟူနိ သန္တိ ၑရီရံ တွေကမေဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","အတဧဝ တွယာ မမ ပြယောဇနံ နာသ္တီတိ ဝါစံ ပါဏိံ ဝဒိတုံ နယနံ န ၑက္နောတိ, တထာ ယုဝါဘျာံ မမ ပြယောဇနံ နာသ္တီတိ မူရ္ဒ္ဓါ စရဏော် ဝဒိတုံ န ၑက္နောတိး; ");
INSERT INTO sanbur_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","ဝသ္တုတသ္တု ဝိဂြဟသျ ယာနျင်္ဂါနျသ္မာဘိ ရ္ဒုရ္ဗ္ဗလာနိ ဗုဓျန္တေ တာနျေဝ သပြယောဇနာနိ သန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","ယာနိ စ ၑရီရမဓျေ'ဝမနျာနိ ဗုဓျတေ တာနျသ္မာဘိရဓိကံ ၑောဘျန္တေ၊ ယာနိ စ ကုဒၖၑျာနိ တာနိ သုဒၖၑျတရာဏိ ကြိယန္တေ ");
INSERT INTO sanbur_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","ကိန္တု ယာနိ သွယံ သုဒၖၑျာနိ တေၐာံ ၑောဘနမ် နိၐ္ပြယောဇနံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","ၑရီရမဓျေ ယဒ် ဘေဒေါ န ဘဝေတ် ကိန္တု သရွွာဏျင်္ဂါနိ ယဒ် အဲကျဘာဝေန သရွွေၐာံ ဟိတံ စိန္တယန္တိ တဒရ္ထမ် ဤၑွရေဏာပြဓာနမ် အာဒရဏီယံ ကၖတွာ ၑရီရံ ဝိရစိတံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","တသ္မာဒ် ဧကသျာင်္ဂသျ ပီဍာယာံ ဇာတာယာံ သရွွာဏျင်္ဂါနိ တေန သဟ ပီဍျန္တေ, ဧကသျ သမာဒရေ ဇာတေ စ သရွွာဏိ တေန သဟ သံဟၖၐျန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","ယူယဉ္စ ခြီၐ္ဋသျ ၑရီရံ, ယုၐ္မာကမ် ဧကဲကၑ္စ တသျဲကဲကမ် အင်္ဂံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","ကေစိတ် ကေစိတ် သမိတာဝီၑွရေဏ ပြထမတး ပြေရိတာ ဒွိတီယတ ဤၑွရီယာဒေၑဝက္တာရသ္တၖတီယတ ဥပဒေၐ္ဋာရော နိယုက္တား, တတး ပရံ ကေဘျော'ပိ စိတြကာရျျသာဓနသာမရ္ထျမ် အနာမယကရဏၑက္တိရုပကၖတော် လောကၑာသနေ ဝါ နဲပုဏျံ နာနာဘာၐာဘာၐဏသာမရ္ထျံ ဝါ တေန ဝျတာရိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","သရွွေ ကိံ ပြေရိတား? သရွွေ ကိမ် ဤၑွရီယာဒေၑဝက္တာရး? သရွွေ ကိမ် ဥပဒေၐ္ဋာရး? သရွွေ ကိံ စိတြကာရျျသာဓကား? ");
INSERT INTO sanbur_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","သရွွေ ကိမ် အနာမယကရဏၑက္တိယုက္တား? သရွွေ ကိံ ပရဘာၐာဝါဒိနး? သရွွေ ဝါ ကိံ ပရဘာၐာရ္ထပြကာၑကား? ");
INSERT INTO sanbur_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","ယူယံ ၑြေၐ္ဌဒါယာန် လဗ္ဓုံ ယတဓွံ၊ အနေန ယူယံ မယာ သရွွောတ္တမမာရ္ဂံ ဒရ္ၑယိတဝျား၊ ");
INSERT INTO sanbur_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","မရ္တျသွရ္ဂီယာဏာံ ဘာၐာ ဘာၐမာဏော'ဟံ ယဒိ ပြေမဟီနော ဘဝေယံ တရှိ ဝါဒကတာလသွရူပေါ နိနာဒကာရိဘေရီသွရူပၑ္စ ဘဝါမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","အပရဉ္စ ယဒျဟမ် ဤၑွရီယာဒေၑာဎျး သျာံ သရွွာဏိ ဂုပ္တဝါကျာနိ သရွွဝိဒျာဉ္စ ဇာနီယာံ ပူရ္ဏဝိၑွာသး သန် ၑဲလာန် သ္ထာနာန္တရီကရ္တ္တုံ ၑက္နုယာဉ္စ ကိန္တု ယဒိ ပြေမဟီနော ဘဝေယံ တရှျဂဏနီယ ဧဝ ဘဝါမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","အပရံ ယဒျဟမ် အန္နဒါနေန သရွွသွံ တျဇေယံ ဒါဟနာယ သွၑရီရံ သမရ္ပယေယဉ္စ ကိန္တု ယဒိ ပြေမဟီနော ဘဝေယံ တရှိ တတ္သရွွံ မဒရ္ထံ နိၐ္ဖလံ ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","ပြေမ စိရသဟိၐ္ဏု ဟိတဲၐိ စ, ပြေမ နိရ္ဒွေၐမ် အၑဌံ နိရ္ဂရွွဉ္စ၊ ");
INSERT INTO sanbur_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","အပရံ တတ် ကုတ္သိတံ နာစရတိ, အာတ္မစေၐ္ဋာံ န ကုရုတေ သဟသာ န ကြုဓျတိ ပရာနိၐ္ဋံ န စိန္တယတိ, ");
INSERT INTO sanbur_vpl VALUES ("C113_6","076_13_6","1CO","13","6","6","အဓရ္မ္မေ န တုၐျတိ သတျ ဧဝ သန္တုၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C113_7","076_13_7","1CO","13","7","7","တတ် သရွွံ တိတိက္ၐတေ သရွွတြ ဝိၑွသိတိ သရွွတြ ဘဒြံ ပြတီက္ၐတေ သရွွံ သဟတေ စ၊ ");
INSERT INTO sanbur_vpl VALUES ("C113_8","076_13_8","1CO","13","8","8","ပြေမ္နော လောပး ကဒါပိ န ဘဝိၐျတိ, ဤၑွရီယာဒေၑကထနံ လောပ္သျတေ ပရဘာၐာဘာၐဏံ နိဝရ္တ္တိၐျတေ ဇ္ဉာနမပိ လောပံ ယာသျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C113_9","076_13_9","1CO","13","9","9","ယတော'သ္မာကံ ဇ္ဉာနံ ခဏ္ဍမာတြမ် ဤၑွရီယာဒေၑကထနမပိ ခဏ္ဍမာတြံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C113_10","076_13_10","1CO","13","10","10","ကိန္တွသ္မာသု သိဒ္ဓတာံ ဂတေၐု တာနိ ခဏ္ဍမာတြာဏိ လောပံ ယာသျန္တေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C113_11","076_13_11","1CO","13","11","11","ဗာလျကာလေ'ဟံ ဗာလ ဣဝါဘာၐေ ဗာလ ဣဝါစိန္တယဉ္စ ကိန္တု ယော်ဝနေ ဇာတေ တတ္သရွွံ ဗာလျာစရဏံ ပရိတျက္တဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("C113_12","076_13_12","1CO","13","12","12","ဣဒါနီမ် အဘြမဓျေနာသ္ပၐ္ဋံ ဒရ္ၑနမ် အသ္မာဘိ ရ္လဘျတေ ကိန္တု တဒါ သာက္ၐာတ် ဒရ္ၑနံ လပ္သျတေ၊ အဓုနာ မမ ဇ္ဉာနမ် အလ္ပိၐ္ဌံ ကိန္တု တဒါဟံ ယထာဝဂမျသ္တထဲဝါဝဂတော ဘဝိၐျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C113_13","076_13_13","1CO","13","13","13","ဣဒါနီံ ပြတျယး ပြတျာၑာ ပြေမ စ တြီဏျေတာနိ တိၐ္ဌန္တိ တေၐာံ မဓျေ စ ပြေမ ၑြေၐ္ဌံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C114_1","076_14_1","1CO","14","1","1","ယူယံ ပြေမာစရဏေ ပြယတဓွမ် အာတ္မိကာန် ဒါယာနပိ ဝိၑေၐတ ဤၑွရီယာဒေၑကထနသာမရ္ထျံ ပြာပ္တုံ စေၐ္ဋဓွံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C114_2","076_14_2","1CO","14","2","2","ယော ဇနး ပရဘာၐာံ ဘာၐတေ သ မာနုၐာန် န သမ္ဘာၐတေ ကိန္တွီၑွရမေဝ ယတး ကေနာပိ ကိမပိ န ဗုဓျတေ သ စာတ္မနာ နိဂူဎဝါကျာနိ ကထယတိ; ");
INSERT INTO sanbur_vpl VALUES ("C114_3","076_14_3","1CO","14","3","3","ကိန္တု ယော ဇန ဤၑွရီယာဒေၑံ ကထယတိ သ ပရေၐာံ နိၐ္ဌာယဲ ဟိတောပဒေၑာယ သာန္တွနာယဲ စ ဘာၐတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C114_4","076_14_4","1CO","14","4","4","ပရဘာၐာဝါဒျာတ္မန ဧဝ နိၐ္ဌာံ ဇနယတိ ကိန္တွီၑွရီယာဒေၑဝါဒီ သမိတေ ရ္နိၐ္ဌာံ ဇနယတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C114_5","076_14_5","1CO","14","5","5","ယုၐ္မာကံ သရွွေၐာံ ပရဘာၐာဘာၐဏမ် ဣစ္ဆာမျဟံ ကိန္တွီၑွရီယာဒေၑကထနမ် အဓိကမပီစ္ဆာမိ၊ ယတး သမိတေ ရ္နိၐ္ဌာယဲ ယေန သွဝါကျာနာမ် အရ္ထော န ကြိယတေ တသ္မာတ် ပရဘာၐာဝါဒိတ ဤၑွရီယာဒေၑဝါဒီ ၑြေယာန်၊ ");
INSERT INTO sanbur_vpl VALUES ("C114_6","076_14_6","1CO","14","6","6","ဟေ ဘြာတရး, ဣဒါနီံ မယာ ယဒိ ယုၐ္မတ္သမီပံ ဂမျတေ တရှီၑွရီယဒရ္ၑနသျ ဇ္ဉာနသျ ဝေၑွရီယာဒေၑသျ ဝါ ၑိက္ၐာယာ ဝါ ဝါကျာနိ န ဘာၐိတွာ ပရဘာၐာံ ဘာၐမာဏေန မယာ ယူယံ ကိမုပကာရိၐျဓွေ? ");
INSERT INTO sanbur_vpl VALUES ("C114_7","076_14_7","1CO","14","7","7","အပရံ ဝံၑီဝလ္လကျာဒိၐု နိၐ္ပြာဏိၐု ဝါဒျယန္တြေၐု ဝါဒိတေၐု ယဒိ က္ကဏာ န ဝိၑိၐျန္တေ တရှိ ကိံ ဝါဒျံ ကိံ ဝါ ဂါနံ ဘဝတိ တတ် ကေန ဗောဒ္ဓုံ ၑကျတေ? ");
INSERT INTO sanbur_vpl VALUES ("C114_8","076_14_8","1CO","14","8","8","အပရံ ရဏတူရျျာ နိသွဏော ယဒျဝျက္တော ဘဝေတ် တရှိ ယုဒ္ဓါယ ကး သဇ္ဇိၐျတေ? ");
INSERT INTO sanbur_vpl VALUES ("C114_9","076_14_9","1CO","14","9","9","တဒွတ် ဇိဟွာဘိ ရျဒိ သုဂမျာ ဝါက် ယုၐ္မာဘိ ရ္န ဂဒျေတ တရှိ ယဒ် ဂဒျတေ တတ် ကေန ဘောတ္သျတေ? ဝသ္တုတော ယူယံ ဒိဂါလာပိန ဣဝ ဘဝိၐျထ၊ ");
INSERT INTO sanbur_vpl VALUES ("C114_10","076_14_10","1CO","14","10","10","ဇဂတိ ကတိပြကာရာ ဥက္တယော ဝိဒျန္တေ? တာသာမေကာပိ နိရရ္ထိကာ နဟိ; ");
INSERT INTO sanbur_vpl VALUES ("C114_11","076_14_11","1CO","14","11","11","ကိန္တူက္တေရရ္ထော ယဒိ မယာ န ဗုဓျတေ တရှျဟံ ဝက္တြာ မ္လေစ္ဆ ဣဝ မံသျေ ဝက္တာပိ မယာ မ္လေစ္ဆ ဣဝ မံသျတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C114_12","076_14_12","1CO","14","12","12","တသ္မာဒ် အာတ္မိကဒါယလိပ္သဝေါ ယူယံ သမိတေ ရ္နိၐ္ဌာရ္ထံ ပြာပ္တဗဟုဝရာ ဘဝိတုံ ယတဓွံ, ");
INSERT INTO sanbur_vpl VALUES ("C114_13","076_14_13","1CO","14","13","13","အတဧဝ ပရဘာၐာဝါဒီ ယဒ် အရ္ထကရော'ပိ ဘဝေတ် တတ် ပြာရ္ထယတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C114_14","076_14_14","1CO","14","14","14","ယဒျဟံ ပရဘာၐယာ ပြရ္ထနာံ ကုရျျာံ တရှိ မဒီယ အာတ္မာ ပြာရ္ထယတေ, ကိန္တု မမ ဗုဒ္ဓိ ရ္နိၐ္ဖလာ တိၐ္ဌတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C114_15","076_14_15","1CO","14","15","15","ဣတျနေန ကိံ ကရဏီယံ? အဟမ် အာတ္မနာ ပြာရ္ထယိၐျေ ဗုဒ္ဓျာပိ ပြာရ္ထယိၐျေ; အပရံ အာတ္မနာ ဂါသျာမိ ဗုဒ္ဓျာပိ ဂါသျာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C114_16","076_14_16","1CO","14","16","16","တွံ ယဒါတ္မနာ ဓနျဝါဒံ ကရောၐိ တဒါ ယဒ် ဝဒသိ တဒ် ယဒိ ၑိၐျေနေဝေါပသ္ထိတေန ဇနေန န ဗုဒ္ဓျတေ တရှိ တဝ ဓနျဝါဒသျာန္တေ တထာသ္တွိတိ တေန ဝက္တံ ကထံ ၑကျတေ? ");
INSERT INTO sanbur_vpl VALUES ("C114_17","076_14_17","1CO","14","17","17","တွံ သမျဂ် ဤၑွရံ ဓနျံ ဝဒသီတိ သတျံ တထာပိ တတြ ပရသျ နိၐ္ဌာ န ဘဝတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C114_18","076_14_18","1CO","14","18","18","ယုၐ္မာကံ သရွွေဘျော'ဟံ ပရဘာၐာဘာၐဏေ သမရ္ထော'သ္မီတိ ကာရဏာဒ် ဤၑွရံ ဓနျံ ဝဒါမိ; ");
INSERT INTO sanbur_vpl VALUES ("C114_19","076_14_19","1CO","14","19","19","တထာပိ သမိတော် ပရောပဒေၑာရ္ထံ မယာ ကထိတာနိ ပဉ္စ ဝါကျာနိ ဝရံ န စ လက္ၐံ ပရဘာၐီယာနိ ဝါကျာနိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C114_20","076_14_20","1CO","14","20","20","ဟေ ဘြာတရး,ယူယံ ဗုဒ္ဓျာ ဗာလကာဣဝ မာ ဘူတ ပရန္တု ဒုၐ္ဋတယာ ၑိၑဝဣဝ ဘူတွာ ဗုဒ္ဓျာ သိဒ္ဓါ ဘဝတ၊ ");
INSERT INTO sanbur_vpl VALUES ("C114_21","076_14_21","1CO","14","21","21","ၑာသ္တြ ဣဒံ လိခိတမာသ္တေ, ယထာ, ဣတျဝေါစတ် ပရေၑော'ဟမ် အာဘာၐိၐျ ဣမာန် ဇနာန်၊ ဘာၐာဘိး ပရကီယာဘိ ရွက္တြဲၑ္စ ပရဒေၑိဘိး၊ တထာ မယာ ကၖတေ'ပီမေ န ဂြဟီၐျန္တိ မဒွစး။ ");
INSERT INTO sanbur_vpl VALUES ("C114_22","076_14_22","1CO","14","22","22","အတဧဝ တတ် ပရဘာၐာဘာၐဏံ အဝိၑ္စာသိနး ပြတိ စိဟ္နရူပံ ဘဝတိ န စ ဝိၑွာသိနး ပြတိ; ကိန္တွီၑွရီယာဒေၑကထနံ နာဝိၑွာသိနး ပြတိ တဒ် ဝိၑွာသိနး ပြတျေဝ၊ ");
INSERT INTO sanbur_vpl VALUES ("C114_23","076_14_23","1CO","14","23","23","သမိတိဘုက္တေၐု သရွွေၐု ဧကသ္မိန် သ္ထာနေ မိလိတွာ ပရဘာၐာံ ဘာၐမာဏေၐု ယဒိ ဇ္ဉာနာကာင်္က္ၐိဏော'ဝိၑွာသိနော ဝါ တတြာဂစ္ဆေယုသ္တရှိ ယုၐ္မာန် ဥန္မတ္တာန် ကိံ န ဝဒိၐျန္တိ? ");
INSERT INTO sanbur_vpl VALUES ("C114_24","076_14_24","1CO","14","24","24","ကိန္တု သရွွေၐွီၑွရီယာဒေၑံ ပြကာၑယတ္သု ယဒျဝိၑွာသီ ဇ္ဉာနာကာင်္က္ၐီ ဝါ ကၑ္စိတ် တတြာဂစ္ဆတိ တရှိ သရွွဲရေဝ တသျ ပါပဇ္ဉာနံ ပရီက္ၐာ စ ဇာယတေ, ");
INSERT INTO sanbur_vpl VALUES ("C114_25","076_14_25","1CO","14","25","25","တတသ္တသျာန္တးကရဏသျ ဂုပ္တကလ္ပနာသု ဝျက္တီဘူတာသု သော'ဓောမုခး ပတန် ဤၑွရမာရာဓျ ယုၐ္မန္မဓျ ဤၑွရော ဝိဒျတေ ဣတိ သတျံ ကထာမေတာံ ကထယိၐျတိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C114_26","076_14_26","1CO","14","26","26","ဟေ ဘြာတရး, သမ္မိလိတာနာံ ယုၐ္မာကမ် ဧကေန ဂီတမ် အနျေနောပဒေၑော'နျေန ပရဘာၐာနျေန အဲၑွရိကဒရ္ၑနမ် အနျေနာရ္ထဗောဓကံ ဝါကျံ လဘျတေ ကိမေတတ်? သရွွမေဝ ပရနိၐ္ဌာရ္ထံ ယုၐ္မာဘိး ကြိယတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C114_27","076_14_27","1CO","14","27","27","ယဒိ ကၑ္စိဒ် ဘာၐာန္တရံ ဝိဝက္ၐတိ တရှျေကသ္မိန် ဒိနေ ဒွိဇနေန တြိဇနေန ဝါ ပရဘာाၐာ ကထျတာံ တဒဓိကဲရ္န ကထျတာံ တဲရပိ ပရျျာယာနုသာရာတ် ကထျတာံ, ဧကေန စ တဒရ္ထော ဗောဓျတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C114_28","076_14_28","1CO","14","28","28","ကိန္တွရ္ထာဘိဓာယကး ကော'ပိ ယဒိ န ဝိဒျတေ တရှိ သ သမိတော် ဝါစံယမး သ္ထိတွေၑွရာယာတ္မနေ စ ကထာံ ကထယတု၊ ");
INSERT INTO sanbur_vpl VALUES ("C114_29","076_14_29","1CO","14","29","29","အပရံ ဒွေါ် တြယော ဝေၑွရီယာဒေၑဝက္တာရး သွံ သွမာဒေၑံ ကထယန္တု တဒနျေ စ တံ ဝိစာရယန္တု၊ ");
INSERT INTO sanbur_vpl VALUES ("C114_30","076_14_30","1CO","14","30","30","ကိန္တု တတြာပရေဏ ကေနစိတ် ဇနေနေၑွရီယာဒေၑေ လဗ္ဓေ ပြထမေန ကထနာတ် နိဝရ္တ္တိတဝျံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C114_31","076_14_31","1CO","14","31","31","သရွွေ ယတ် ၑိက္ၐာံ သာန္တွနာဉ္စ လဘန္တေ တဒရ္ထံ ယူယံ သရွွေ ပရျျာယေဏေၑွရီယာဒေၑံ ကထယိတုံ ၑက္နုထ၊ ");
INSERT INTO sanbur_vpl VALUES ("C114_32","076_14_32","1CO","14","32","32","ဤၑွရီယာဒေၑဝက္တၖဏာံ မနာံသိ တေၐာမ် အဓီနာနိ ဘဝန္တိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C114_33","076_14_33","1CO","14","33","33","ယတ ဤၑွရး ကုၑာသနဇနကော နဟိ သုၑာသနဇနက ဧဝေတိ ပဝိတြလောကာနာံ သရွွသမိတိၐု ပြကာၑတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C114_34","076_14_34","1CO","14","34","34","အပရဉ္စ ယုၐ္မာကံ ဝနိတား သမိတိၐု တူၐ္ဏီမ္ဘူတာသ္တိၐ္ဌန္တု ယတး ၑာသ္တြလိခိတေန ဝိဓိနာ တား ကထာပြစာရဏာတ် နိဝါရိတာသ္တာဘိ ရ္နိဃြာဘိ ရ္ဘဝိတဝျံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C114_35","076_14_35","1CO","14","35","35","အတသ္တာ ယဒိ ကိမပိ ဇိဇ္ဉာသန္တေ တရှိ ဂေဟေၐု ပတီန် ပၖစ္ဆန္တု ယတး သမိတိမဓျေ ယောၐိတာံ ကထာကထနံ နိန္ဒနီယံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C114_36","076_14_36","1CO","14","36","36","အဲၑွရံ ဝစး ကိံ ယုၐ္မတ္တော နိရဂမတ? ကေဝလံ ယုၐ္မာန် ဝါ တတ် ကိမ် ဥပါဂတံ? ");
INSERT INTO sanbur_vpl VALUES ("C114_37","076_14_37","1CO","14","37","37","ယး ကၑ္စိဒ် အာတ္မာနမ် ဤၑွရီယာဒေၑဝက္တာရမ် အာတ္မနာဝိၐ္ဋံ ဝါ မနျတေ သ ယုၐ္မာန် ပြတိ မယာ ယဒ် ယတ် လိချတေ တတ္ပြဘုနာဇ္ဉာပိတမ် ဤတျုရရီ ကရောတု၊ ");
INSERT INTO sanbur_vpl VALUES ("C114_38","076_14_38","1CO","14","38","38","ကိန္တု ယး ကၑ္စိတ် အဇ္ဉော ဘဝတိ သော'ဇ္ဉ ဧဝ တိၐ္ဌတု၊ ");
INSERT INTO sanbur_vpl VALUES ("C114_39","076_14_39","1CO","14","39","39","အတဧဝ ဟေ ဘြာတရး, ယူယမ် ဤၑွရီယာဒေၑကထနသာမရ္ထျံ လဗ္ဓုံ ယတဓွံ ပရဘာၐာဘာၐဏမပိ ယုၐ္မာဘိ ရ္န နိဝါရျျတာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C114_40","076_14_40","1CO","14","40","40","သရွွကရ္မ္မာဏိ စ ဝိဓျနုသာရတး သုပရိပါဋျာ ကြိယန္တာံ၊ ");
INSERT INTO sanbur_vpl VALUES ("C115_1","076_15_1","1CO","15","1","1","ဟေ ဘြာတရး, ယး သုသံဝါဒေါ မယာ ယုၐ္မတ္သမီပေ နိဝေဒိတော ယူယဉ္စ ယံ ဂၖဟီတဝန္တ အာၑြိတဝန္တၑ္စ တံ ပုန ရျုၐ္မာန် ဝိဇ္ဉာပယာမိ၊ ");
INSERT INTO sanbur_vpl VALUES ("C115_2","076_15_2","1CO","15","2","2","ယုၐ္မာကံ ဝိၑွာသော ယဒိ ဝိတထော န ဘဝေတ် တရှိ သုသံဝါဒယုက္တာနိ မမ ဝါကျာနိ သ္မရတာံ ယုၐ္မာကံ တေန သုသံဝါဒေန ပရိတြာဏံ ဇာယတေ၊ ");
INSERT INTO sanbur_vpl VALUES ("C115_3","076_15_3","1CO","15","3","3","ယတော'ဟံ ယဒ် ယတ် ဇ္ဉာပိတသ္တဒနုသာရာတ် ယုၐ္မာသု မုချာံ ယာံ ၑိက္ၐာံ သမာရ္ပယံ သေယံ, ၑာသ္တြာနုသာရာတ် ခြီၐ္ဋော'သ္မာကံ ပါပမောစနာရ္ထံ ပြာဏာန် တျက္တဝါန်, ");
INSERT INTO sanbur_vpl VALUES ("C115_4","076_15_4","1CO","15","4","4","ၑ္မၑာနေ သ္ထာပိတၑ္စ တၖတီယဒိနေ ၑာသ္တြာနုသာရာတ် ပုနရုတ္ထာပိတး၊ ");
INSERT INTO sanbur_vpl VALUES ("C115_5","076_15_5","1CO","15","5","5","သ စာဂြေ ကဲဖဲ တတး ပရံ ဒွါဒၑၑိၐျေဘျော ဒရ္ၑနံ ဒတ္တဝါန်၊ ");
INSERT INTO sanbur_vpl VALUES ("C115_6","076_15_6","1CO","15","6","6","တတး ပရံ ပဉ္စၑတာဓိကသံချကေဘျော ဘြာတၖဘျော ယုဂပဒ် ဒရ္ၑနံ ဒတ္တဝါန် တေၐာံ ကေစိတ် မဟာနိဒြာံ ဂတာ ဗဟုတရာၑ္စာဒျာပိ ဝရ္တ