﻿USE sofia;
DROP TABLE IF EXISTS sofia.sanben_vpl;
CREATE TABLE sanben_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sanben_vpl WRITE;
INSERT INTO sanben_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ইব্রাহীমঃ সন্তানো দাযূদ্ তস্য সন্তানো যীশুখ্রীষ্টস্তস্য পূর্ৱ্ৱপুরুষৱংশশ্রেণী| ");
INSERT INTO sanben_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","ইব্রাহীমঃ পুত্র ইস্হাক্ তস্য পুত্রো যাকূব্ তস্য পুত্রো যিহূদাস্তস্য ভ্রাতরশ্চ| ");
INSERT INTO sanben_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","তস্মাদ্ যিহূদাতস্তামরো গর্ভে পেরস্সেরহৌ জজ্ঞাতে, তস্য পেরসঃ পুত্রো হিষ্রোণ্ তস্য পুত্রো ঽরাম্| ");
INSERT INTO sanben_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","তস্য পুত্রো ঽম্মীনাদব্ তস্য পুত্রো নহশোন্ তস্য পুত্রঃ সল্মোন্| ");
INSERT INTO sanben_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","তস্মাদ্ রাহবো গর্ভে বোযম্ জজ্ঞে, তস্মাদ্ রূতো গর্ভে ওবেদ্ জজ্ঞে, তস্য পুত্রো যিশযঃ| ");
INSERT INTO sanben_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","তস্য পুত্রো দাযূদ্ রাজঃ তস্মাদ্ মৃতোরিযস্য জাযাযাং সুলেমান্ জজ্ঞে| ");
INSERT INTO sanben_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","তস্য পুত্রো রিহবিযাম্, তস্য পুত্রোঽবিযঃ, তস্য পুত্র আসা:| ");
INSERT INTO sanben_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","তস্য সুতো যিহোশাফট্ তস্য সুতো যিহোরাম তস্য সুত উষিযঃ| ");
INSERT INTO sanben_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","তস্য সুতো যোথম্ তস্য সুত আহম্ তস্য সুতো হিষ্কিযঃ| ");
INSERT INTO sanben_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","তস্য সুতো মিনশিঃ, তস্য সুত আমোন্ তস্য সুতো যোশিযঃ| ");
INSERT INTO sanben_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","বাবিল্নগরে প্রৱসনাৎ পূর্ৱ্ৱং স যোশিযো যিখনিযং তস্য ভ্রাতৃংশ্চ জনযামাস| ");
INSERT INTO sanben_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ততো বাবিলি প্রৱসনকালে যিখনিযঃ শল্তীযেলং জনযামাস, তস্য সুতঃ সিরুব্বাৱিল্| ");
INSERT INTO sanben_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","তস্য সুতো ঽবোহুদ্ তস্য সুত ইলীযাকীম্ তস্য সুতোঽসোর্| ");
INSERT INTO sanben_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","অসোরঃ সুতঃ সাদোক্ তস্য সুত আখীম্ তস্য সুত ইলীহূদ্| ");
INSERT INTO sanben_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","তস্য সুত ইলিযাসর্ তস্য সুতো মত্তন্| ");
INSERT INTO sanben_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","তস্য সুতো যাকূব্ তস্য সুতো যূষফ্ তস্য জাযা মরিযম্; তস্য গর্ভে যীশুরজনি, তমেৱ খ্রীষ্টম্ (অর্থাদ্ অভিষিক্তং) ৱদন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ইত্থম্ ইব্রাহীমো দাযূদং যাৱৎ সাকল্যেন চতুর্দশপুরুষাঃ; আ দাযূদঃ কালাদ্ বাবিলি প্রৱসনকালং যাৱৎ চতুর্দশপুরুষা ভৱন্তি| বাবিলি প্রৱাসনকালাৎ খ্রীষ্টস্য কালং যাৱৎ চতুর্দশপুরুষা ভৱন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","যীশুখ্রীষ্টস্য জন্ম কথ্থতে| মরিযম্ নামিকা কন্যা যূষফে ৱাগ্দত্তাসীৎ, তদা তযোঃ সঙ্গমাৎ প্রাক্ সা কন্যা  পৱিত্রেণাত্মনা গর্ভৱতী বভূৱ| ");
INSERT INTO sanben_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","তত্র তস্যাঃ পতি র্যূষফ্ সৌজন্যাৎ তস্যাঃ কলঙ্গং প্রকাশযিতুম্ অনিচ্ছন্ গোপনেনে তাং পারিত্যক্তুং মনশ্চক্রে| ");
INSERT INTO sanben_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","স তথৈৱ ভাৱযতি, তদানীং পরমেশ্ৱরস্য দূতঃ স্ৱপ্নে তং দর্শনং দত্ত্ৱা ৱ্যাজহার, হে দাযূদঃ সন্তান যূষফ্ ৎৱং নিজাং জাযাং মরিযমম্ আদাতুং মা ভৈষীঃ| ");
INSERT INTO sanben_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","যতস্তস্যা গর্ভঃ পৱিত্রাদাত্মনোঽভৱৎ, সা চ পুত্রং প্রসৱিষ্যতে, তদা ৎৱং তস্য নাম যীশুম্ (অর্থাৎ ত্রাতারং) করীষ্যসে, যস্মাৎ স নিজমনুজান্ তেষাং কলুষেভ্য উদ্ধরিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ইত্থং সতি, পশ্য গর্ভৱতী কন্যা তনযং প্রসৱিষ্যতে| ইম্মানূযেল্ তদীযঞ্চ নামধেযং ভৱিষ্যতি|| ইম্মানূযেল্ অস্মাকং সঙ্গীশ্ৱরইত্যর্থঃ| ");
INSERT INTO sanben_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","ইতি যদ্ ৱচনং পুর্ৱ্ৱং ভৱিষ্যদ্ৱক্ত্রা ঈশ্ৱরঃ কথাযামাস, তৎ তদানীং সিদ্ধমভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","অনন্তরং যূষফ্ নিদ্রাতো জাগরিত উত্থায পরমেশ্ৱরীযদূতস্য নিদেশানুসারেণ নিজাং জাযাং জগ্রাহ, ");
INSERT INTO sanben_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","কিন্তু যাৱৎ সা নিজং প্রথমসুতং অ সুষুৱে, তাৱৎ তাং নোপাগচ্ছৎ, ততঃ সুতস্য নাম যীশুং চক্রে| ");
INSERT INTO sanben_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","অনন্তরং হেরোদ্ সংজ্ঞকে রাজ্ঞি রাজ্যং শাসতি যিহূদীযদেশস্য বৈৎলেহমি নগরে যীশৌ জাতৱতি চ, কতিপযা জ্যোতির্ৱ্ৱুদঃ পূর্ৱ্ৱস্যা দিশো যিরূশালম্নগরং সমেত্য কথযমাসুঃ, ");
INSERT INTO sanben_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","যো যিহূদীযানাং রাজা জাতৱান্, স কুত্রাস্তে? ৱযং পূর্ৱ্ৱস্যাং দিশি তিষ্ঠন্তস্তদীযাং তারকাম্ অপশ্যাম তস্মাৎ তং প্রণন্তুম্ অाগমাম| ");
INSERT INTO sanben_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","তদা হেরোদ্ রাজা কথামেতাং নিশম্য যিরূশালম্নগরস্থিতৈঃ সর্ৱ্ৱমানৱৈঃ সার্দ্ধম্ উদ্ৱিজ্য ");
INSERT INTO sanben_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","সর্ৱ্ৱান্ প্রধানযাজকান্ অধ্যাপকাংশ্চ সমাহূযানীয পপ্রচ্ছ, খ্রীষ্টঃ কুত্র জনিষ্যতে? ");
INSERT INTO sanben_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","তদা তে কথযামাসুঃ, যিহূদীযদেশস্য বৈৎলেহমি নগরে, যতো ভৱিষ্যদ্ৱাদিনা ইত্থং লিখিতমাস্তে, ");
INSERT INTO sanben_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","সর্ৱ্ৱাভ্যো রাজধানীভ্যো যিহূদীযস্য নীৱৃতঃ| হে যীহূদীযদেশস্যে বৈৎলেহম্ ৎৱং ন চাৱরা| ইস্রাযেলীযলোকান্ মে যতো যঃ পালযিষ্যতি| তাদৃগেকো মহারাজস্ত্ৱন্মধ্য উদ্ভৱিষ্যতী|| ");
INSERT INTO sanben_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","তদানীং হেরোদ্ রাজা তান্ জ্যোতির্ৱ্ৱিদো গোপনম্ আহূয সা তারকা কদা দৃষ্টাভৱৎ , তদ্ ৱিনিশ্চযামাস| ");
INSERT INTO sanben_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","অপরং তান্ বৈৎলেহমং প্রহীত্য গদিতৱান্, যূযং যাত, যত্নাৎ তং শিশুম্ অন্ৱিষ্য তদুদ্দেশে প্রাপ্তে মহ্যং ৱার্ত্তাং দাস্যথ, ততো মযাপি গৎৱা স প্রণংস্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","তদানীং রাজ্ঞ এতাদৃশীম্ আজ্ঞাং প্রাপ্য তে প্রতস্থিরে, ততঃ পূর্ৱ্ৱর্স্যাং দিশি স্থিতৈস্তৈ র্যা তারকা দৃষ্টা সা তারকা তেষামগ্রে গৎৱা যত্র স্থানে শিশূরাস্তে, তস্য স্থানস্যোপরি স্থগিতা তস্যৌ| ");
INSERT INTO sanben_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","তদ্ দৃষ্ট্ৱা তে মহানন্দিতা বভূৱুঃ, ");
INSERT INTO sanben_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ততো গেহমধ্য প্রৱিশ্য তস্য মাত্রা মরিযমা সাদ্ধং তং শিশুং নিরীক্ষয দণ্ডৱদ্ ভূৎৱা প্রণেমুঃ, অপরং স্ৱেষাং ঘনসম্পত্তিং মোচযিৎৱা সুৱর্ণং কুন্দুরুং গন্ধরমঞ্চ তস্মৈ দর্শনীযং দত্তৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","পশ্চাদ্ হেরোদ্ রাজস্য সমীপং পুনরপি গন্তুং স্ৱপ্ন ঈশ্ৱরেণ নিষিদ্ধাঃ সন্তো ঽন্যেন পথা তে নিজদেশং প্রতি প্রতস্থিরে| ");
INSERT INTO sanben_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","অনন্তরং তেষু গতৱত্মু পরমেশ্ৱরস্য দূতো যূষফে স্ৱপ্নে দর্শনং দৎৱা জগাদ, ৎৱম্ উত্থায শিশুং তন্মাতরঞ্চ গৃহীৎৱা মিসর্দেশং পলাযস্ৱ, অপরং যাৱদহং তুভ্যং ৱার্ত্তাং ন কথযিষ্যামি, তাৱৎ তত্রৈৱ নিৱস, যতো রাজা হেরোদ্ শিশুং নাশযিতুং মৃগযিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","তদানীং যূষফ্ উত্থায রজন্যাং শিশুং তন্মাতরঞ্চ গৃহীৎৱা মিসর্দেশং প্রতি প্রতস্থে, ");
INSERT INTO sanben_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","গৎৱা চ হেরোদো নৃপতে র্মরণপর্য্যন্তং তত্র দেশে ন্যুৱাস, তেন মিসর্দেশাদহং পুত্রং স্ৱকীযং সমুপাহূযম্| যদেতদ্ৱচনম্ ঈশ্ৱরেণ ভৱিষ্যদ্ৱাদিনা কথিতং তৎ সফলমভূৎ| ");
INSERT INTO sanben_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","অনন্তরং হেরোদ্ জ্যোতির্ৱিদ্ভিরাত্মানং প্রৱঞ্চিতং ৱিজ্ঞায ভৃশং চুকোপ; অপরং জ্যোতির্ৱ্ৱিদ্ভ্যস্তেন ৱিনিশ্চিতং যদ্ দিনং তদ্দিনাদ্ গণযিৎৱা দ্ৱিতীযৱৎসরং প্রৱিষ্টা যাৱন্তো বালকা অস্মিন্ বৈৎলেহম্নগরে তৎসীমমধ্যে চাসন্, লোকান্ প্রহিত্য তান্ সর্ৱ্ৱান্ ঘাতযামাস| ");
INSERT INTO sanben_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","অতঃ অনেকস্য ৱিলাপস্য নিনাদ: ক্রন্দনস্য চ| শোকেন কৃতশব্দশ্চ রামাযাং সংনিশম্যতে| স্ৱবালগণহেতোর্ৱৈ রাহেল্ নারী তু রোদিনী| ন মন্যতে প্রবোধন্তু যতস্তে নৈৱ মন্তি হি|| ");
INSERT INTO sanben_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","যদেতদ্ ৱচনং যিরীমিযনামকভৱিষ্যদ্ৱাদিনা কথিতং তৎ তদানীং সফলম্ অভূৎ| ");
INSERT INTO sanben_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","তদনন্তরং হেরেদি রাজনি মৃতে পরমেশ্ৱরস্য দূতো মিসর্দেশে স্ৱপ্নে দর্শনং দত্ত্ৱা যূষফে কথিতৱান্ ");
INSERT INTO sanben_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ৎৱম্ উত্থায শিশুং তন্মাতরঞ্চ গৃহীৎৱা পুনরপীস্রাযেলো দেশং যাহী, যে জনাঃ শিশুং নাশযিতুম্ অমৃগযন্ত, তে মৃতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","তদানীং স উত্থায শিশুং তন্মাতরঞ্চ গৃহ্লন্ ইস্রাযেল্দেশম্ আজগাম| ");
INSERT INTO sanben_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","কিন্তু যিহূদীযদেশে অর্খিলাযনাম রাজকুমারো নিজপিতু র্হেরোদঃ পদং প্রাপ্য রাজৎৱং করোতীতি নিশম্য তৎ স্থানং যাতুং শঙ্কিতৱান্, পশ্চাৎ স্ৱপ্ন ঈশ্ৱরাৎ প্রবোধং প্রাপ্য গালীল্দেশস্য প্রদেশৈকং প্রস্থায নাসরন্নাম নগরং গৎৱা তত্র ন্যুষিতৱান্, ");
INSERT INTO sanben_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","তেন তং নাসরতীযং কথযিষ্যন্তি, যদেতদ্ৱাক্যং ভৱিষ্যদ্ৱাদিভিরুক্ত্তং তৎ সফলমভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","তদানোং যোহ্ন্নামা মজ্জযিতা যিহূদীযদেশস্য প্রান্তরম্ উপস্থায প্রচারযন্ কথযামাস, ");
INSERT INTO sanben_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","মনাংসি পরাৱর্ত্তযত, স্ৱর্গীযরাজৎৱং সমীপমাগতম্| ");
INSERT INTO sanben_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","পরমেশস্য পন্থানং পরিষ্কুরুত সর্ৱ্ৱতঃ| তস্য রাজপথাংশ্চৈৱ সমীকুরুত সর্ৱ্ৱথা| ইত্যেতৎ প্রান্তরে ৱাক্যং ৱদতঃ কস্যচিদ্ রৱঃ|| ");
INSERT INTO sanben_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","এতদ্ৱচনং যিশযিযভৱিষ্যদ্ৱাদিনা যোহনমুদ্দিশ্য ভাষিতম্| যোহনো ৱসনং মহাঙ্গরোমজং তস্য কটৌ চর্ম্মকটিবন্ধনং; স চ শূককীটান্ মধু চ ভুক্তৱান্| ");
INSERT INTO sanben_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","তদানীং যিরূশালম্নগরনিৱাসিনঃ সর্ৱ্ৱে যিহূদিদেশীযা যর্দ্দন্তটিন্যা উভযতটস্থাশ্চ মানৱা বহিরাগত্য তস্য সমীপে ");
INSERT INTO sanben_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","স্ৱীযং স্ৱীযং দুরিতম্ অঙ্গীকৃত্য তস্যাং যর্দ্দনি তেন মজ্জিতা বভূৱুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","অপরং বহূন্ ফিরূশিনঃ সিদূকিনশ্চ মনুজান্ মংক্তুং স্ৱসমীপম্ আগচ্ছ্তো ৱিলোক্য স তান্ অভিদধৌ, রে রে ভুজগৱংশা আগামীনঃ কোপাৎ পলাযিতুং যুষ্মান্ কশ্চেতিতৱান্? ");
INSERT INTO sanben_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","মনঃপরাৱর্ত্তনস্য সমুচিতং ফলং ফলত| ");
INSERT INTO sanben_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","কিন্ত্ৱস্মাকং তাত ইব্রাহীম্ অস্তীতি স্ৱেষু মনঃসু চীন্তযন্তো মা ৱ্যাহরত| যতো যুষ্মান্ অহং ৱদামি, ঈশ্ৱর এতেভ্যঃ পাষাণেভ্য ইব্রাহীমঃ সন্তানান্ উৎপাদযিতুং শক্নোতি| ");
INSERT INTO sanben_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","অপরং পাদপানাং মূলে কুঠার ইদানীমপি লগন্ আস্তে, তস্মাদ্ যস্মিন্ পাদপে উত্তমং ফলং ন ভৱতি, স কৃত্তো মধ্যেঽগ্নিং নিক্ষেপ্স্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","অপরম্ অহং মনঃপরাৱর্ত্তনসূচকেন মজ্জনেন যুষ্মান্ মজ্জযামীতি সত্যং, কিন্তু মম পশ্চাদ্ য আগচ্ছতি, স মত্তোপি মহান্, অহং তদীযোপানহৌ ৱোঢুমপি নহি যোগ্যোস্মি, স যুষ্মান্ ৱহ্নিরূপে পৱিত্র আত্মনি সংমজ্জযিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","তস্য কারে সূর্প আস্তে, স স্ৱীযশস্যানি সম্যক্ প্রস্ফোট্য নিজান্ সকলগোধূমান্ সংগৃহ্য ভাণ্ডাগারে স্থাপযিষ্যতি, কিংন্তু সর্ৱ্ৱাণি ৱুষাণ্যনির্ৱ্ৱাণৱহ্নিনা দাহযিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","অনন্তরং যীশু র্যোহনা মজ্জিতো ভৱিতুং গালীল্প্রদেশাদ্ যর্দ্দনি তস্য সমীপম্ আজগাম| ");
INSERT INTO sanben_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","কিন্তু যোহন্ তং নিষিধ্য বভাষে, ৎৱং কিং মম সমীপম্ আগচ্ছসি? ৱরং ৎৱযা মজ্জনং মম প্রযোজনম্ আস্তে| ");
INSERT INTO sanben_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","তদানীং যীশুঃ প্রত্যৱোচৎ; ঈদানীম্ অনুমন্যস্ৱ, যত ইত্থং সর্ৱ্ৱধর্ম্মসাধনম্ অস্মাকং কর্ত্তৱ্যং, ততঃ সোঽন্ৱমন্যত| ");
INSERT INTO sanben_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","অনন্তরং যীশুরম্মসি মজ্জিতুঃ সন্ তৎক্ষণাৎ তোযমধ্যাদ্ উত্থায জগাম, তদা জীমূতদ্ৱারে মুক্তে জাতে, স ঈশ্ৱরস্যাত্মানং কপোতৱদ্ অৱরুহ্য স্ৱোপর্য্যাগচ্ছন্তং ৱীক্ষাঞ্চক্রে| ");
INSERT INTO sanben_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","অপরম্ এষ মম প্রিযঃ পুত্র এতস্মিন্নেৱ মম মহাসন্তোষ এতাদৃশী ৱ্যোমজা ৱাগ্ বভূৱ| ");
INSERT INTO sanben_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","ততঃ পরং যীশুঃ প্রতারকেণ পরীক্ষিতো ভৱিতুম্ আত্মনা প্রান্তরম্ আকৃষ্টঃ ");
INSERT INTO sanben_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","সন্ চৎৱারিংশদহোরাত্রান্ অনাহারস্তিষ্ঠন্ ক্ষুধিতো বভূৱ| ");
INSERT INTO sanben_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","তদানীং পরীক্ষিতা তৎসমীপম্ আগত্য ৱ্যাহৃতৱান্, যদি ৎৱমীশ্ৱরাত্মজো ভৱেস্তর্হ্যাজ্ঞযা পাষাণানেতান্ পূপান্ ৱিধেহি| ");
INSERT INTO sanben_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","ততঃ স প্রত্যব্রৱীৎ, ইত্থং লিখিতমাস্তে, \"মনুজঃ কেৱলপূপেন ন জীৱিষ্যতি, কিন্ত্ৱীশ্ৱরস্য ৱদনাদ্ যানি যানি ৱচাংসি নিঃসরন্তি তৈরেৱ জীৱিষ্যতি| \" ");
INSERT INTO sanben_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","তদা প্রতারকস্তং পুণ্যনগরং নীৎৱা মন্দিরস্য চূডোপরি নিধায গদিতৱান্, ");
INSERT INTO sanben_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ৎৱং যদিশ্ৱরস্য তনযো ভৱেস্তর্হীতোঽধঃ পত, যত ইত্থং লিখিতমাস্তে, আদেক্ষ্যতি নিজান্ দূতান্ রক্ষিতুং ৎৱাং পরমেশ্ৱরঃ| যথা সর্ৱ্ৱেষু মার্গেষু ৎৱদীযচরণদ্ৱযে| ন লগেৎ প্রস্তরাঘাতস্ত্ৱাং ঘরিষ্যন্তি তে করৈঃ|| ");
INSERT INTO sanben_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","তদানীং যীশুস্তস্মৈ কথিতৱান্ এতদপি লিখিতমাস্তে, \"ৎৱং নিজপ্রভুং পরমেশ্ৱরং মা পরীক্ষস্ৱ| \" ");
INSERT INTO sanben_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","অনন্তরং প্রতারকঃ পুনরপি তম্ অত্যুঞ্চধরাধরোপরি নীৎৱা জগতঃ সকলরাজ্যানি তদৈশ্ৱর্য্যাণি চ দর্শযাশ্চকার কথযাঞ্চকার চ, ");
INSERT INTO sanben_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","যদি ৎৱং দণ্ডৱদ্ ভৱন্ মাং প্রণমেস্তর্হ্যহম্ এতানি তুভ্যং প্রদাস্যামি| ");
INSERT INTO sanben_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","তদানীং যীশুস্তমৱোচৎ, দূরীভৱ প্রতারক, লিখিতমিদম্ আস্তে, \"ৎৱযা নিজঃ প্রভুঃ পরমেশ্ৱরঃ প্রণম্যঃ কেৱলঃ স সেৱ্যশ্চ| \" ");
INSERT INTO sanben_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","ততঃ প্রতারকেণ স পর্য্যত্যাজি, তদা স্ৱর্গীযদূতৈরাগত্য স সিষেৱে| ");
INSERT INTO sanben_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","তদনন্তরং যোহন্ কারাযাং ববন্ধে, তদ্ৱার্ত্তাং নিশম্য যীশুনা গালীল্ প্রাস্থীযত| ");
INSERT INTO sanben_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ততঃ পরং স নাসরন্নগরং ৱিহায জলঘেস্তটে সিবূলূন্নপ্তালী এতযোরুৱভযোঃ প্রদেশযোঃ সীম্নোর্মধ্যৱর্ত্তী য: কফর্নাহূম্ তন্নগরম্ ইৎৱা ন্যৱসৎ| ");
INSERT INTO sanben_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","তস্মাৎ, অন্যাদেশীযগালীলি যর্দ্দন্পারেঽব্ধিরোধসি| নপ্তালিসিবূলূন্দেশৌ যত্র স্থানে স্থিতৌ পুরা| ");
INSERT INTO sanben_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","তত্রত্যা মনুজা যে যে পর্য্যভ্রাম্যন্ তমিস্রকে| তৈর্জনৈর্বৃহদালোকঃ পরিদর্শিষ্যতে তদা| অৱসন্ যে জনা দেশে মৃত্যুচ্ছাযাস্ৱরূপকে| তেষামুপরি লোকানামালোকঃ সংপ্রকাশিতঃ|| ");
INSERT INTO sanben_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","যদেতদ্ৱচনং যিশযিযভৱিষ্যদ্ৱাদিনা প্রোক্তং, তৎ তদা সফলম্ অভূৎ| ");
INSERT INTO sanben_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","অনন্তরং যীশুঃ সুসংৱাদং প্রচারযন্ এতাং কথাং কথযিতুম্ আরেভে, মনাংসি পরাৱর্ত্তযত, স্ৱর্গীযরাজৎৱং সৱিধমভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ততঃ পরং যীশু র্গালীলো জলধেস্তটেন গচ্ছন্ গচ্ছন্ আন্দ্রিযস্তস্য ভ্রাতা শিমোন্ অর্থতো যং পিতরং ৱদন্তি এতাৱুভৌ জলঘৌ জালং ক্ষিপন্তৌ দদর্শ, যতস্তৌ মীনধারিণাৱাস্তাম্| ");
INSERT INTO sanben_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","তদা স তাৱাহূয ৱ্যাজহার, যুৱাং মম পশ্চাদ্ আগচ্ছতং, যুৱামহং মনুজধারিণৌ করিষ্যামি| ");
INSERT INTO sanben_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","তেনৈৱ তৌ জালং ৱিহায তস্য পশ্চাৎ আগচ্ছতাম্| ");
INSERT INTO sanben_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","অনন্তরং তস্মাৎ স্থানাৎ ৱ্রজন্ ৱ্রজন্ সিৱদিযস্য সুতৌ যাকূব্ যোহন্নামানৌ দ্ৱৌ সহজৌ তাতেন সার্দ্ধং নৌকোপরি জালস্য জীর্ণোদ্ধারং কুর্ৱ্ৱন্তৌ ৱীক্ষ্য তাৱাহূতৱান্| ");
INSERT INTO sanben_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","তৎক্ষণাৎ তৌ নাৱং স্ৱতাতঞ্চ ৱিহায তস্য পশ্চাদ্গামিনৌ বভূৱতুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","অনন্তরং ভজনভৱনে সমুপদিশন্ রাজ্যস্য সুসংৱাদং প্রচারযন্ মনুজানাং সর্ৱ্ৱপ্রকারান্ রোগান্ সর্ৱ্ৱপ্রকারপীডাশ্চ শমযন্ যীশুঃ কৃৎস্নং গালীল্দেশং ভ্রমিতুম্ আরভত| ");
INSERT INTO sanben_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","তেন কৃৎস্নসুরিযাদেশস্য মধ্যং তস্য যশো ৱ্যাপ্নোৎ, অপরং ভূতগ্রস্তা অপস্মারর্গীণঃ পক্ষাধাতিপ্রভৃতযশ্চ যাৱন্তো মনুজা নানাৱিধৱ্যাধিভিঃ ক্লিষ্টা আসন্, তেষু সর্ৱ্ৱেষু তস্য সমীপম্ আনীতেষু স তান্ স্ৱস্থান্ চকার| ");
INSERT INTO sanben_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","এতেন গালীল্-দিকাপনি-যিরূশালম্-যিহূদীযদেশেভ্যো যর্দ্দনঃ পারাঞ্চ বহৱো মনুজাস্তস্য পশ্চাদ্ আগচ্ছন্| ");
INSERT INTO sanben_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","অনন্তরং স জননিৱহং নিরীক্ষ্য ভূধরোপরি ৱ্রজিৎৱা সমুপৱিৱেশ| ");
INSERT INTO sanben_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","তদানীং শিষ্যেষু তস্য সমীপমাগতেষু তেন তেভ্য এষা কথা কথ্যাঞ্চক্রে| ");
INSERT INTO sanben_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","অভিমানহীনা জনা ধন্যাঃ, যতস্তে স্ৱর্গীযরাজ্যম্ অধিকরিষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","খিদ্যমানা মনুজা ধন্যাঃ, যস্মাৎ তে সান্ত্ৱনাং প্রাপ্সন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","নম্রা মানৱাশ্চ ধন্যাঃ, যস্মাৎ তে মেদিনীম্ অধিকরিষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ধর্ম্মায বুভুক্ষিতাঃ তৃষার্ত্তাশ্চ মনুজা ধন্যাঃ, যস্মাৎ তে পরিতর্প্স্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","কৃপালৱো মানৱা ধন্যাঃ, যস্মাৎ তে কৃপাং প্রাপ্স্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","নির্ম্মলহৃদযা মনুজাশ্চ ধন্যাঃ, যস্মাৎ ত ঈশ্চরং দ্রক্ষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","মেলযিতারো মানৱা ধন্যাঃ, যস্মাৎ ত ঈশ্চরস্য সন্তানৎৱেন ৱিখ্যাস্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ধর্ম্মকারণাৎ তাডিতা মনুজা ধন্যা, যস্মাৎ স্ৱর্গীযরাজ্যে তেষামধিকরো ৱিদ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","যদা মনুজা মম নামকৃতে যুষ্মান্ নিন্দন্তি তাডযন্তি মৃষা নানাদুর্ৱ্ৱাক্যানি ৱদন্তি চ, তদা যুযং ধন্যাঃ| ");
INSERT INTO sanben_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","তদা আনন্দত, তথা ভৃশং হ্লাদধ্ৱঞ্চ, যতঃ স্ৱর্গে ভূযাংসি ফলানি লপ্স্যধ্ৱে; তে যুষ্মাকং পুরাতনান্ ভৱিষ্যদ্ৱাদিনোঽপি তাদৃগ্ অতাডযন্| ");
INSERT INTO sanben_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","যুযং মেদিন্যাং লৱণরূপাঃ, কিন্তু যদি লৱণস্য লৱণৎৱম্ অপযাতি, তর্হি তৎ কেন প্রকারেণ স্ৱাদুযুক্তং ভৱিষ্যতি? তৎ কস্যাপি কার্য্যস্যাযোগ্যৎৱাৎ কেৱলং বহিঃ প্রক্ষেপ্তুং নরাণাং পদতলেন দলযিতুঞ্চ যোগ্যং ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","যূযং জগতি দীপ্তিরূপাঃ, ভূধরোপরি স্থিতং নগরং গুপ্তং ভৱিতুং নহি শক্ষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","অপরং মনুজাঃ প্রদীপান্ প্রজ্ৱাল্য দ্রোণাধো ন স্থাপযন্তি, কিন্তু দীপাধারোপর্য্যেৱ স্থাপযন্তি, তেন তে দীপা গেহস্থিতান্ সকলান্ প্রকাশযন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","যেন মানৱা যুষ্মাকং সৎকর্ম্মাণি ৱিলোক্য যুষ্মাকং স্ৱর্গস্থং পিতরং ধন্যং ৱদন্তি, তেষাং সমক্ষং যুষ্মাকং দীপ্তিস্তাদৃক্ প্রকাশতাম্| ");
INSERT INTO sanben_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","অহং ৱ্যৱস্থাং ভৱিষ্যদ্ৱাক্যঞ্চ লোপ্তুম্ আগতৱান্, ইত্থং মানুভৱত, তে দ্ৱে লোপ্তুং নাগতৱান্, কিন্তু সফলে কর্ত্তুম্ আগতোস্মি| ");
INSERT INTO sanben_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","অপরং যুষ্মান্ অহং তথ্যং ৱদামি যাৱৎ ৱ্যোমমেদিন্যো র্ধ্ৱংসো ন ভৱিষ্যতি, তাৱৎ সর্ৱ্ৱস্মিন্ সফলে ন জাতে ৱ্যৱস্থাযা একা মাত্রা বিন্দুরেকোপি ৱা ন লোপ্স্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","তস্মাৎ যো জন এতাসাম্ আজ্ঞানাম্ অতিক্ষুদ্রাম্ একাজ্ঞামপী লংঘতে মনুজাংঞ্চ তথৈৱ শিক্ষযতি, স স্ৱর্গীযরাজ্যে সর্ৱ্ৱেভ্যঃ ক্ষুদ্রৎৱেন ৱিখ্যাস্যতে, কিন্তু যো জনস্তাং পালযতি, তথৈৱ শিক্ষযতি চ, স স্ৱর্গীযরাজ্যে প্রধানৎৱেন ৱিখ্যাস্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","অপরং যুষ্মান্ অহং ৱদামি, অধ্যাপকফিরূশিমানৱানাং ধর্ম্মানুষ্ঠানাৎ যুষ্মাকং ধর্ম্মানুষ্ঠানে নোত্তমে জাতে যূযম্ ঈশ্ৱরীযরাজ্যং প্রৱেষ্টুং ন শক্ষ্যথ| ");
INSERT INTO sanben_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","অপরঞ্চ ৎৱং নরং মা ৱধীঃ, যস্মাৎ যো নরং হন্তি, স ৱিচারসভাযাং দণ্ডার্হো ভৱিষ্যতি, পূর্ৱ্ৱকালীনজনেভ্য ইতি কথিতমাসীৎ, যুষ্মাভিরশ্রাৱি| ");
INSERT INTO sanben_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","কিন্ত্ৱহং যুষ্মান্ ৱদামি, যঃ কশ্চিৎ কারণং ৱিনা নিজভ্রাত্রে কুপ্যতি, স ৱিচারসভাযাং দণ্ডার্হো ভৱিষ্যতি; যঃ কশ্চিচ্চ স্ৱীযসহজং নির্ব্বোধং ৱদতি, স মহাসভাযাং দণ্ডার্হো ভৱিষ্যতি; পুনশ্চ ৎৱং মূঢ ইতি ৱাক্যং যদি কশ্চিৎ স্ৱীযভ্রাতরং ৱক্তি, তর্হি নরকাগ্নৌ স দণ্ডার্হো ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","অতো ৱেদ্যাঃ সমীপং নিজনৈৱেদ্যে সমানীতেঽপি নিজভ্রাতরং প্রতি কস্মাচ্চিৎ কারণাৎ ৎৱং যদি দোষী ৱিদ্যসে, তদানীং তৱ তস্য স্মৃতি র্জাযতে চ, ");
INSERT INTO sanben_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","তর্হি তস্যা ৱেদ্যাঃ সমীপে নিজনৈৱৈদ্যং নিধায তদৈৱ গৎৱা পূর্ৱ্ৱং তেন সার্দ্ধং মিল, পশ্চাৎ আগত্য নিজনৈৱেদ্যং নিৱেদয| ");
INSERT INTO sanben_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","অন্যঞ্চ যাৱৎ ৱিৱাদিনা সার্দ্ধং ৱর্ত্মনি তিষ্ঠসি, তাৱৎ তেন সার্দ্ধং মেলনং কুরু; নো চেৎ ৱিৱাদী ৱিচারযিতুঃ সমীপে ৎৱাং সমর্পযতি ৱিচারযিতা চ রক্ষিণঃ সন্নিধৌ সমর্পযতি তদা ৎৱং কারাযাং বধ্যেথাঃ| ");
INSERT INTO sanben_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","তর্হি ৎৱামহং তথ্থং ব্রৱীমি, শেষকপর্দকেঽপি ন পরিশোধিতে তস্মাৎ স্থানাৎ কদাপি বহিরাগন্তুং ন শক্ষ্যসি| ");
INSERT INTO sanben_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","অপরং ৎৱং মা ৱ্যভিচর, যদেতদ্ ৱচনং পূর্ৱ্ৱকালীনলোকেভ্যঃ কথিতমাসীৎ, তদ্ যূযং শ্রুতৱন্তঃ; ");
INSERT INTO sanben_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","কিন্ত্ৱহং যুষ্মান্ ৱদামি, যদি কশ্চিৎ কামতঃ কাঞ্চন যোষিতং পশ্যতি, তর্হি স মনসা তদৈৱ ৱ্যভিচরিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","তস্মাৎ তৱ দক্ষিণং নেত্রং যদি ৎৱাং বাধতে, তর্হি তন্নেত্রম্ উৎপাট্য দূরে নিক্ষিপ, যস্মাৎ তৱ সর্ৱ্ৱৱপুষো নরকে নিক্ষেপাৎ তৱৈকাঙ্গস্য নাশো ৱরং| ");
INSERT INTO sanben_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","যদ্ৱা তৱ দক্ষিণঃ করো যদি ৎৱাং বাধতে, তর্হি তং করং ছিত্ত্ৱা দূরে নিক্ষিপ, যতঃ সর্ৱ্ৱৱপুষো নরকে নিক্ষেপাৎ একাঙ্গস্য নাশো ৱরং| ");
INSERT INTO sanben_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","উক্তমাস্তে, যদি কশ্চিন্ নিজজাযাং পরিত্যক্ত্তুম্ ইচ্ছতি, তর্হি স তস্যৈ ত্যাগপত্রং দদাতু| ");
INSERT INTO sanben_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","কিন্ত্ৱহং যুষ্মান্ ৱ্যাহরামি, ৱ্যভিচারদোষে ন জাতে যদি কশ্চিন্ নিজজাযাং পরিত্যজতি, তর্হি স তাং ৱ্যভিচারযতি; যশ্চ তাং ত্যক্তাং স্ত্রিযং ৱিৱহতি, সোপি ৱ্যভিচরতি| ");
INSERT INTO sanben_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","পুনশ্চ ৎৱং মৃষা শপথম্ ন কুর্ৱ্ৱন্ ঈশ্চরায নিজশপথং পালয, পূর্ৱ্ৱকালীনলোকেভ্যো যৈষা কথা কথিতা, তামপি যূযং শ্রুতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","কিন্ত্ৱহং যুষ্মান্ ৱদামি, কমপি শপথং মা কার্ষ্ট, অর্থতঃ স্ৱর্গনাম্না ন, যতঃ স ঈশ্ৱরস্য সিংহাসনং; ");
INSERT INTO sanben_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","পৃথিৱ্যা নাম্নাপি ন, যতঃ সা তস্য পাদপীঠং; যিরূশালমো নাম্নাপি ন, যতঃ সা মহারাজস্য পুরী; ");
INSERT INTO sanben_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","নিজশিরোনাম্নাপি ন, যস্মাৎ তস্যৈকং কচমপি সিতম্ অসিতং ৱা কর্ত্তুং ৎৱযা ন শক্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","অপরং যূযং সংলাপসমযে কেৱলং ভৱতীতি ন ভৱতীতি চ ৱদত যত ইতোঽধিকং যৎ তৎ পাপাত্মনো জাযতে| ");
INSERT INTO sanben_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","অপরং লোচনস্য ৱিনিমযেন লোচনং দন্তস্য ৱিনিমযেন দন্তঃ পূর্ৱ্ৱক্তমিদং ৱচনঞ্চ যুষ্মাভিরশ্রূযত| ");
INSERT INTO sanben_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","কিন্ত্ৱহং যুষ্মান্ ৱদামি যূযং হিংসকং নরং মা ৱ্যাঘাতযত| কিন্তু কেনচিৎ তৱ দক্ষিণকপোলে চপেটাঘাতে কৃতে তং প্রতি ৱামং কপোলঞ্চ ৱ্যাঘোটয| ");
INSERT INTO sanben_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","অপরং কেনচিৎ ৎৱযা সার্ধ্দং ৱিৱাদং কৃৎৱা তৱ পরিধেযৱসনে জিঘৃতিতে তস্মাযুত্তরীযৱসনমপি দেহি| ");
INSERT INTO sanben_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","যদি কশ্চিৎ ৎৱাং ক্রোশমেকং নযনার্থং অন্যাযতো ধরতি, তদা তেন সার্ধ্দং ক্রোশদ্ৱযং যাহি| ");
INSERT INTO sanben_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","যশ্চ মানৱস্ত্ৱাং যাচতে, তস্মৈ দেহি, যদি কশ্চিৎ তুভ্যং ধারযিতুম্ ইচ্ছতি, তর্হি তং প্রতি পরাংমুখো মা ভূঃ| ");
INSERT INTO sanben_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","নিজসমীপৱসিনি প্রেম কুরু, কিন্তু শত্রুং প্রতি দ্ৱেষং কুরু, যদেতৎ পুরোক্তং ৱচনং এতদপি যূযং শ্রুতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","কিন্ত্ৱহং যুষ্মান্ ৱদামি, যূযং রিপুৱ্ৱপি প্রেম কুরুত, যে চ যুষ্মান্ শপন্তে, তান, আশিষং ৱদত, যে চ যুষ্মান্ ঋृতীযন্তে, তেষাং মঙ্গলং কুরুত, যে চ যুষ্মান্ নিন্দন্তি, তাডযন্তি চ, তেষাং কৃতে প্রার্থযধ্ৱং| ");
INSERT INTO sanben_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","তত্র যঃ সতামসতাঞ্চোপরি প্রভাকরম্ উদাযযতি, তথা ধার্ম্মিকানামধার্ম্মিকানাঞ্চোপরি নীরং ৱর্ষযতি তাদৃশো যো যুষ্মাকং স্ৱর্গস্থঃ পিতা, যূযং তস্যৈৱ সন্তানা ভৱিষ্যথ| ");
INSERT INTO sanben_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","যে যুষ্মাসু প্রেম কুর্ৱ্ৱন্তি, যূযং যদি কেৱলং তেৱ্ৱেৱ প্রেম কুরুথ, তর্হি যুষ্মাকং কিং ফলং ভৱিষ্যতি? চণ্ডালা অপি তাদৃশং কিং ন কুর্ৱ্ৱন্তি? ");
INSERT INTO sanben_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","অপরং যূযং যদি কেৱলং স্ৱীযভ্রাতৃৎৱেন নমত, তর্হি কিং মহৎ কর্ম্ম কুরুথ? চণ্ডালা অপি তাদৃশং কিং ন কুর্ৱ্ৱন্তি? ");
INSERT INTO sanben_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","তস্মাৎ যুষ্মাকং স্ৱর্গস্থঃ পিতা যথা পূর্ণো ভৱতি, যূযমপি তাদৃশা ভৱত| ");
INSERT INTO sanben_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","সাৱধানা ভৱত, মনুজান্ দর্শযিতুং তেষাং গোচরে ধর্ম্মকর্ম্ম মা কুরুত, তথা কৃতে যুষ্মাকং স্ৱর্গস্থপিতুঃ সকাশাৎ কিঞ্চন ফলং ন প্রাপ্স্যথ| ");
INSERT INTO sanben_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","ৎৱং যদা দদাসি তদা কপটিনো জনা যথা মনুজেভ্যঃ প্রশংসাং প্রাপ্তুং ভজনভৱনে রাজমার্গে চ তূরীং ৱাদযন্তি, তথা মা কুরিु, অহং তুভ্যং যথার্থং কথযামি, তে স্ৱকাযং ফলম্ অলভন্ত| ");
INSERT INTO sanben_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","কিন্তু ৎৱং যদা দদাসি, তদা নিজদক্ষিণকরো যৎ করোতি, তদ্ ৱামকরং মা জ্ঞাপয| ");
INSERT INTO sanben_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","তেন তৱ দানং গুপ্তং ভৱিষ্যতি যস্তু তৱ পিতা গুপ্তদর্শী, স প্রকাশ্য তুভ্যং ফলং দাস্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","অপরং যদা প্রার্থযসে, তদা কপটিনইৱ মা কুরু, যস্মাৎ তে ভজনভৱনে রাজমার্গস্য কোণে তিষ্ঠন্তো লোকান্ দর্শযন্তঃ প্রার্থযিতুং প্রীযন্তে; অহং যুষ্মান্ তথ্যং ৱদামি, তে স্ৱকীযফলং প্রাপ্নুৱন্| ");
INSERT INTO sanben_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","তস্মাৎ প্রার্থনাকালে অন্তরাগারং প্রৱিশ্য দ্ৱারং রুদ্ৱ্ৱা গুপ্তং পশ্যতস্তৱ পিতুঃ সমীপে প্রার্থযস্ৱ; তেন তৱ যঃ পিতা গুপ্তদর্শী, স প্রকাশ্য তুভ্যং ফলং দাস্যতিl ");
INSERT INTO sanben_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","অপরং প্রার্থনাকালে দেৱপূজকাইৱ মুধা পুনরুক্তিং মা কুরু, যস্মাৎ তে বোধন্তে, বহুৱারং কথাযাং কথিতাযাং তেষাং প্রার্থনা গ্রাহিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","যূযং তেষামিৱ মা কুরুত, যস্মাৎ যুষ্মাকং যদ্ যৎ প্রযোজনং যাচনাতঃ প্রাগেৱ যুষ্মাকং পিতা তৎ জানাতি| ");
INSERT INTO sanben_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","অতএৱ যূযম ঈদৃক্ প্রার্থযধ্ৱং, হে অস্মাকং স্ৱর্গস্থপিতঃ, তৱ নাম পূজ্যং ভৱতু| ");
INSERT INTO sanben_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","তৱ রাজৎৱং ভৱতু; তৱেচ্ছা স্ৱর্গে যথা তথৈৱ মেদিন্যামপি সফলা ভৱতু| ");
INSERT INTO sanben_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","অস্মাকং প্রযোজনীযম্ আহারম্ অদ্য দেহি| ");
INSERT INTO sanben_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ৱযং যথা নিজাপরাধিনঃ ক্ষমামহে, তথৈৱাস্মাকম্ অপরাধান্ ক্ষমস্ৱ| ");
INSERT INTO sanben_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","অস্মান্ পরীক্ষাং মানয, কিন্তু পাপাত্মনো রক্ষ; রাজৎৱং গৌরৱং পরাক্রমঃ এতে সর্ৱ্ৱে সর্ৱ্ৱদা তৱ; তথাস্তু| ");
INSERT INTO sanben_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","যদি যূযম্ অন্যেষাম্ অপরাধান্ ক্ষমধ্ৱে তর্হি যুষ্মাকং স্ৱর্গস্থপিতাপি যুষ্মান্ ক্ষমিষ্যতে; ");
INSERT INTO sanben_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","কিন্তু যদি যূযম্ অন্যেষাম্ অপরাধান্ ন ক্ষমধ্ৱে, তর্হি যুষ্মাকং জনকোপি যুষ্মাকম্ অপরাধান্ ন ক্ষমিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","অপরম্ উপৱাসকালে কপটিনো জনা মানুষান্ উপৱাসং জ্ঞাপযিতুং স্ৱেষাং ৱদনানি ম্লানানি কুর্ৱ্ৱন্তি, যূযং তইৱ ৱিষণৱদনা মা ভৱত; অহং যুষ্মান্ তথ্যং ৱদামি তে স্ৱকীযফলম্ অলভন্ত| ");
INSERT INTO sanben_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","যদা ৎৱম্ উপৱসসি, তদা যথা লোকৈস্ত্ৱং উপৱাসীৱ ন দৃশ্যসে, কিন্তু তৱ যোঽগোচরঃ পিতা তেনৈৱ দৃশ্যসে, তৎকৃতে নিজশিরসি তৈলং মর্দ্দয ৱদনঞ্চ প্রক্ষালয; ");
INSERT INTO sanben_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","তেন তৱ যঃ পিতা গুপ্তদর্শী স প্রকাশ্য তুভ্যং ফলং দাস্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","অপরং যত্র স্থানে কীটাঃ কলঙ্কাশ্চ ক্ষযং নযন্তি, চৌরাশ্চ সন্ধিং কর্ত্তযিৎৱা চোরযিতুং শক্নুৱন্তি, তাদৃশ্যাং মেদিন্যাং স্ৱার্থং ধনং মা সংচিনুত| ");
INSERT INTO sanben_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","কিন্তু যত্র স্থানে কীটাঃ কলঙ্কাশ্চ ক্ষযং ন নযন্তি, চৌরাশ্চ সন্ধিং কর্ত্তযিৎৱা চোরযিতুং ন শক্নুৱন্তি, তাদৃশে স্ৱর্গে ধনং সঞ্চিনুত| ");
INSERT INTO sanben_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","যস্মাৎ যত্র স্থানে যুষ্মাংক ধনং তত্রৈৱ খানে যুষ্মাকং মনাংসি| ");
INSERT INTO sanben_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","লোচনং দেহস্য প্রদীপকং, তস্মাৎ যদি তৱ লোচনং প্রসন্নং ভৱতি, তর্হি তৱ কৃৎস্নং ৱপু র্দীপ্তিযুক্তং ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","কিন্তু লোচনেঽপ্রসন্নে তৱ কৃৎস্নং ৱপুঃ তমিস্রযুক্তং ভৱিষ্যতি| অতএৱ যা দীপ্তিস্ত্ৱযি ৱিদ্যতে, সা যদি তমিস্রযুক্তা ভৱতি, তর্হি তৎ তমিস্রং কিযন্ মহৎ| ");
INSERT INTO sanben_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","কোপি মনুজো দ্ৱৌ প্রভূ সেৱিতুং ন শক্নোতি, যস্মাদ্ একং সংমন্য তদন্যং ন সম্মন্যতে, যদ্ৱা একত্র মনো নিধায তদন্যম্ অৱমন্যতে; তথা যূযমপীশ্ৱরং লক্ষ্মীঞ্চেত্যুভে সেৱিতুং ন শক্নুথ| ");
INSERT INTO sanben_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","অপরম্ অহং যুষ্মভ্যং তথ্যং কথযামি, কিং ভক্ষিষ্যামঃ? কিং পাস্যামঃ? ইতি প্রাণধারণায মা চিন্তযত; কিং পরিধাস্যামঃ? ইতি কাযরক্ষণায ন চিন্তযত; ভক্ষ্যাৎ প্রাণা ৱসনাঞ্চ ৱপূংষি কিং শ্রেষ্ঠাণি ন হি? ");
INSERT INTO sanben_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ৱিহাযসো ৱিহঙ্গমান্ ৱিলোকযত; তৈ র্নোপ্যতে ন কৃত্যতে ভাণ্ডাগারে ন সঞ্চীযতেঽপি; তথাপি যুষ্মাকং স্ৱর্গস্থঃ পিতা তেভ্য আহারং ৱিতরতি| ");
INSERT INTO sanben_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","যূযং তেভ্যঃ কিং শ্রেষ্ঠা ন ভৱথ? যুষ্মাকং কশ্চিৎ মনুজঃ চিন্তযন্ নিজাযুষঃ ক্ষণমপি ৱর্দ্ধযিতুং শক্নোতি? ");
INSERT INTO sanben_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","অপরং ৱসনায কুতশ্চিন্তযত? ক্ষেত্রোৎপন্নানি পুষ্পাণি কথং ৱর্দ্ধন্তে তদালোচযত| তানি তন্তূন্ নোৎপাদযন্তি কিমপি কার্য্যং ন কুর্ৱ্ৱন্তি; ");
INSERT INTO sanben_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","তথাপ্যহং যুষ্মান্ ৱদামি, সুলেমান্ তাদৃগ্ ঐশ্ৱর্য্যৱানপি তৎপুষ্পমিৱ ৱিভূষিতো নাসীৎ| ");
INSERT INTO sanben_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","তস্মাৎ ক্ষদ্য ৱিদ্যমানং শ্চঃ চুল্ল্যাং নিক্ষেপ্স্যতে তাদৃশং যৎ ক্ষেত্রস্থিতং কুসুমং তৎ যদীশ্চর ইত্থং বিভূষযতি, তর্হি হে স্তোকপ্রত্যযিনো যুষ্মান্ কিং ন পরিধাপযিষ্যতি? ");
INSERT INTO sanben_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","তস্মাৎ অস্মাভিঃ কিমৎস্যতে? কিঞ্চ পাযিষ্যতে? কিং ৱা পরিধাযিষ্যতে, ইতি ন চিন্তযত| ");
INSERT INTO sanben_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","যস্মাৎ দেৱার্চ্চকা অপীতি চেষ্টন্তে; এতেষু দ্রৱ্যেষু প্রযোজনমস্তীতি যুষ্মাকং স্ৱর্গস্থঃ পিতা জানাতি| ");
INSERT INTO sanben_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","অতএৱ প্রথমত ঈশ্ৱরীযরাজ্যং ধর্ম্মঞ্চ চেষ্টধ্ৱং, তত এতানি ৱস্তূনি যুষ্মভ্যং প্রদাযিষ্যন্তে| ");
INSERT INTO sanben_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","শ্ৱঃ কৃতে মা চিন্তযত, শ্ৱএৱ স্ৱযং স্ৱমুদ্দিশ্য চিন্তযিষ্যতি; অদ্যতনী যা চিন্তা সাদ্যকৃতে প্রচুরতরা| ");
INSERT INTO sanben_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","যথা যূযং দোষীকৃতা ন ভৱথ, তৎকৃতেঽন্যং দোষিণং মা কুরুত| ");
INSERT INTO sanben_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","যতো যাদৃশেন দোষেণ যূযং পরান্ দোষিণঃ কুরুথ, তাদৃশেন দোষেণ যূযমপি দোষীকৃতা ভৱিষ্যথ, অন্যঞ্চ যেন পরিমাণেন যুষ্মাভিঃ পরিমীযতে, তেনৈৱ পরিমাণেন যুষ্মৎকৃতে পরিমাযিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","অপরঞ্চ নিজনযনে যা নাসা ৱিদ্যতে, তাম্ অনালোচ্য তৱ সহজস্য লোচনে যৎ তৃণম্ আস্তে, তদেৱ কুতো ৱীক্ষসে? ");
INSERT INTO sanben_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","তৱ নিজলোচনে নাসাযাং ৱিদ্যমানাযাং, হে ভ্রাতঃ, তৱ নযনাৎ তৃণং বহিষ্যর্তুং অনুজানীহি, কথামেতাং নিজসহজায কথং কথযিতুং শক্নোষি? ");
INSERT INTO sanben_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","হে কপটিন্, আদৌ নিজনযনাৎ নাসাং বহিষ্কুরু ততো নিজদৃষ্টৌ সুপ্রসন্নাযাং তৱ ভ্রাতৃ র্লোচনাৎ তৃণং বহিষ্কর্তুং শক্ষ্যসি| ");
INSERT INTO sanben_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","অন্যঞ্চ সারমেযেভ্যঃ পৱিত্রৱস্তূনি মা ৱিতরত, ৱরাহাণাং সমক্ষঞ্চ মুক্তা মা নিক্ষিপত; নিক্ষেপণাৎ তে তাঃ সর্ৱ্ৱাঃ পদৈ র্দলযিষ্যন্তি, পরাৱৃত্য যুষ্মানপি ৱিদারযিষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","যাচধ্ৱং ততো যুষ্মভ্যং দাযিষ্যতে; মৃগযধ্ৱং তত উদ্দেশং লপ্স্যধ্ৱে; দ্ৱারম্ আহত, ততো যুষ্মৎকৃতে মুক্তং ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","যস্মাদ্ যেন যাচ্যতে, তেন লভ্যতে; যেন মৃগ্যতে তেনোদ্দেশঃ প্রাপ্যতে; যেন চ দ্ৱারম্ আহন্যতে, তৎকৃতে দ্ৱারং মোচ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","আত্মজেন পূপে প্রার্থিতে তস্মৈ পাষাণং ৱিশ্রাণযতি, ");
INSERT INTO sanben_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","মীনে যাচিতে চ তস্মৈ ভুজগং ৱিতরতি, এতাদৃশঃ পিতা যুষ্মাকং মধ্যে ক আস্তে? ");
INSERT INTO sanben_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","তস্মাদ্ যূযম্ অভদ্রাঃ সন্তোঽপি যদি নিজবালকেভ্য উত্তমং দ্রৱ্যং দাতুং জানীথ, তর্হি যুষ্মাকং স্ৱর্গস্থঃ পিতা স্ৱীযযাচকেভ্যঃ কিমুত্তমানি ৱস্তূনি ন দাস্যতি? ");
INSERT INTO sanben_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","যূষ্মান্ প্রতীতরেষাং যাদৃশো ৱ্যৱহারো যুষ্মাকং প্রিযঃ, যূযং তান্ প্রতি তাদৃশানেৱ ৱ্যৱহারান্ ৱিধত্ত; যস্মাদ্ ৱ্যৱস্থাভৱিষ্যদ্ৱাদিনাং ৱচনানাম্ ইতি সারম্| ");
INSERT INTO sanben_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","সঙ্কীর্ণদ্ৱারেণ প্রৱিশত; যতো নরকগমনায যদ্ দ্ৱারং তদ্ ৱিস্তীর্ণং যচ্চ ৱর্ত্ম তদ্ বৃহৎ তেন বহৱঃ প্রৱিশন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","অপরং স্ৱর্গগমনায যদ্ দ্ৱারং তৎ কীদৃক্ সংকীর্ণং| যচ্চ ৱর্ত্ম তৎ কীদৃগ্ দুর্গমম্| তদুদ্দেষ্টারঃ কিযন্তোঽল্পাঃ| ");
INSERT INTO sanben_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","অপরঞ্চ যে জনা মেষৱেশেন যুষ্মাকং সমীপম্ আগচ্ছন্তি, কিন্ত্ৱন্তর্দুরন্তা ৱৃকা এতাদৃশেভ্যো ভৱিষ্যদ্ৱাদিভ্যঃ সাৱধানা ভৱত, যূযং ফলেন তান্ পরিচেতুং শক্নুথ| ");
INSERT INTO sanben_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","মনুজাঃ কিং কণ্টকিনো ৱৃক্ষাদ্ দ্রাক্ষাফলানি শৃগালকোলিতশ্চ উডুম্বরফলানি শাতযন্তি? ");
INSERT INTO sanben_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","তদ্ৱদ্ উত্তম এৱ পাদপ উত্তমফলানি জনযতি, অধমপাদপএৱাধমফলানি জনযতি| ");
INSERT INTO sanben_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","কিন্তূত্তমপাদপঃ কদাপ্যধমফলানি জনযিতুং ন শক্নোতি, তথাধমোপি পাদপ উত্তমফলানি জনযিতুং ন শক্নোতি| ");
INSERT INTO sanben_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","অপরং যে যে পাদপা অধমফলানি জনযন্তি, তে কৃত্তা ৱহ্নৌ ক্ষিপ্যন্তে| ");
INSERT INTO sanben_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","অতএৱ যূযং ফলেন তান্ পরিচেষ্যথ| ");
INSERT INTO sanben_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","যে জনা মাং প্রভুং ৱদন্তি, তে সর্ৱ্ৱে স্ৱর্গরাজ্যং প্রৱেক্ষ্যন্তি তন্ন, কিন্তু যো মানৱো মম স্ৱর্গস্থস্য পিতুরিষ্টং কর্ম্ম করোতি স এৱ প্রৱেক্ষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","তদ্ দিনে বহৱো মাং ৱদিষ্যন্তি, হে প্রভো হে প্রভো, তৱ নাম্না কিমস্মামি র্ভৱিষ্যদ্ৱাক্যং ন ৱ্যাহৃতং? তৱ নাম্না ভূতাঃ কিং ন ত্যাজিতাঃ? তৱ নাম্না কিং নানাদ্ভুতানি কর্ম্মাণি ন কৃতানি? ");
INSERT INTO sanben_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","তদাহং ৱদিষ্যামি, হে কুকর্ম্মকারিণো যুষ্মান্ অহং ন ৱেদ্মি, যূযং মৎসমীপাদ্ দূরীভৱত| ");
INSERT INTO sanben_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","যঃ কশ্চিৎ মমৈতাঃ কথাঃ শ্রুৎৱা পালযতি, স পাষাণোপরি গৃহনির্ম্মাত্রা জ্ঞানিনা সহ মযোপমীযতে| ");
INSERT INTO sanben_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","যতো ৱৃষ্টৌ সত্যাম্ আপ্লাৱ আগতে ৱাযৌ ৱাতে চ তেষু তদ্গেহং লগ্নেষু পাষাণোপরি তস্য ভিত্তেস্তন্ন পততিl ");
INSERT INTO sanben_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","কিন্তু যঃ কশ্চিৎ মমৈতাঃ কথাঃ শ্রুৎৱা ন পালযতি স সৈকতে গেহনির্ম্মাত্রা ঽজ্ঞানিনা উপমীযতে| ");
INSERT INTO sanben_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","যতো জলৱৃষ্টৌ সত্যাম্ আপ্লাৱ আগতে পৱনে ৱাতে চ তৈ র্গৃহে সমাঘাতে তৎ পততি তৎপতনং মহদ্ ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","যীশুনৈতেষু ৱাক্যেষু সমাপিতেষু মানৱাস্তদীযোপদেশম্ আশ্চর্য্যং মেনিরে| ");
INSERT INTO sanben_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","যস্মাৎ স উপাধ্যাযা ইৱ তান্ নোপদিদেশ কিন্তু সমর্থপুরুষইৱ সমুপদিদেশ| ");
INSERT INTO sanben_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","যদা স পর্ৱ্ৱতাদ্ অৱারোহৎ তদা বহৱো মানৱাস্তৎপশ্চাদ্ ৱৱ্রজুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","একঃ কুষ্ঠৱান্ আগত্য তং প্রণম্য বভাষে, হে প্রভো, যদি ভৱান্ সংমন্যতে, তর্হি মাং নিরামযং কর্ত্তুং শক্নোতি| ");
INSERT INTO sanben_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ততো যীশুঃ করং প্রসার্য্য তস্যাঙ্গং স্পৃশন্ ৱ্যাজহার, সম্মন্যেঽহং ৎৱং নিরামযো ভৱ; তেন স তৎক্ষণাৎ কুষ্ঠেনামোচি| ");
INSERT INTO sanben_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ততো যীশুস্তং জগাদ, অৱধেহি কথামেতাং কশ্চিদপি মা ব্রূহি, কিন্তু যাজকস্য সন্নিধিং গৎৱা স্ৱাত্মানং দর্শয মনুজেভ্যো নিজনিরামযৎৱং প্রমাণযিতুং মূসানিরূপিতং দ্রৱ্যম্ উৎসৃজ চ| ");
INSERT INTO sanben_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","তদনন্তরং যীশুনা কফর্নাহূম্নামনি নগরে প্রৱিষ্টে কশ্চিৎ শতসেনাপতিস্তৎসমীপম্ আগত্য ৱিনীয বভাষে, ");
INSERT INTO sanben_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","হে প্রভো, মদীয একো দাসঃ পক্ষাঘাতৱ্যাধিনা ভৃশং ৱ্যথিতঃ, সতু শযনীয আস্তে| ");
INSERT INTO sanben_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","তদানীং যীশুস্তস্মৈ কথিতৱান্, অহং গৎৱা তং নিরামযং করিষ্যামি| ");
INSERT INTO sanben_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ততঃ স শতসেনাপতিঃ প্রত্যৱদৎ, হে প্রভো, ভৱান্ যৎ মম গেহমধ্যং যাতি তদ্যোগ্যভাজনং নাহমস্মি; ৱাঙ্মাত্রম্ আদিশতু, তেনৈৱ মম দাসো নিরামযো ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","যতো মযি পরনিধ্নেঽপি মম নিদেশৱশ্যাঃ কতি কতি সেনাঃ সন্তি, তত একস্মিন্ যাহীত্যুক্তে স যাতি, তদন্যস্মিন্ এহীত্যুক্তে স আযাতি, তথা মম নিজদাসে কর্ম্মৈতৎ কুর্ৱ্ৱিত্যুক্তে স তৎ করোতি| ");
INSERT INTO sanben_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","তদানীং যীশুস্তস্যৈতৎ ৱচো নিশম্য ৱিস্মযাপন্নোঽভূৎ; নিজপশ্চাদ্গামিনো মানৱান্ অৱোচ্চ, যুষ্মান্ তথ্যং ৱচ্মি, ইস্রাযেলীযলোকানাং মধ্যেঽপি নৈতাদৃশো ৱিশ্ৱাসো মযা প্রাপ্তঃ| ");
INSERT INTO sanben_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","অন্যচ্চাহং যুষ্মান্ ৱদামি, বহৱঃ পূর্ৱ্ৱস্যাঃ পশ্চিমাযাশ্চ দিশ আগত্য ইব্রাহীমা ইস্হাকা যাকূবা চ সাকম্ মিলিৎৱা সমুপৱেক্ষ্যন্তি; ");
INSERT INTO sanben_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","কিন্তু যত্র স্থানে রোদনদন্তঘর্ষণে ভৱতস্তস্মিন্ বহির্ভূততমিস্রে রাজ্যস্য সন্তানা নিক্ষেস্যন্তে| ");
INSERT INTO sanben_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","ততঃ পরং যীশুস্তং শতসেনাপতিং জগাদ, যাহি, তৱ প্রতীত্যনুসারতো মঙ্গলং ভূযাৎ; তদা তস্মিন্নেৱ দণ্ডে তদীযদাসো নিরামযো বভূৱ| ");
INSERT INTO sanben_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","অনন্তরং যীশুঃ পিতরস্য গেহমুপস্থায জ্ৱরেণ পীডিতাং শযনীযস্থিতাং তস্য শ্ৱশ্রূং ৱীক্ষাঞ্চক্রে| ");
INSERT INTO sanben_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ততস্তেন তস্যাঃ করস্য স্পৃষ্টতৱাৎ জ্ৱরস্তাং তত্যাজ, তদা সা সমুত্থায তান্ সিষেৱে| ");
INSERT INTO sanben_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","অনন্তরং সন্ধ্যাযাং সত্যাং বহুশো ভূতগ্রস্তমনুজান্ তস্য সমীপম্ আনিন্যুঃ স চ ৱাক্যেন ভূতান্ ত্যাজযামাস, সর্ৱ্ৱপ্রকারপীডিতজনাংশ্চ নিরামযান্ চকার; ");
INSERT INTO sanben_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","তস্মাৎ, সর্ৱ্ৱা দুর্ব্বলতাস্মাকং তেনৈৱ পরিধারিতা| অস্মাকং সকলং ৱ্যাধিং সএৱ সংগৃহীতৱান্| যদেতদ্ৱচনং যিশযিযভৱিষ্যদ্ৱাদিনোক্তমাসীৎ, তত্তদা সফলমভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","অনন্তরং যীশুশ্চতুর্দিক্ষু জননিৱহং ৱিলোক্য তটিন্যাঃ পারং যাতুং শিষ্যান্ আদিদেশ| ");
INSERT INTO sanben_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","তদানীম্ এক উপাধ্যায আগত্য কথিতৱান্, হে গুরো, ভৱান্ যত্র যাস্যতি তত্রাহমপি ভৱতঃ পশ্চাদ্ যাস্যামি| ");
INSERT INTO sanben_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ততো যীশু র্জগাদ, ক্রোষ্টুঃ স্থাতুং স্থানং ৱিদ্যতে, ৱিহাযসো ৱিহঙ্গমানাং নীডানি চ সন্তি; কিন্তু মনুষ্যপুত্রস্য শিরঃ স্থাপযিতুং স্থানং ন ৱিদ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","অনন্তরম্ অপর একঃ শিষ্যস্তং বভাষে, হে প্রভো, প্রথমতো মম পিতরং শ্মশানে নিধাতুং গমনার্থং মাম্ অনুমন্যস্ৱ| ");
INSERT INTO sanben_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ততো যীশুরুক্তৱান্ মৃতা মৃতান্ শ্মশানে নিদধতু, ৎৱং মম পশ্চাদ্ আগচ্ছ| ");
INSERT INTO sanben_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","অনন্তরং তস্মিন্ নাৱমারূঢে তস্য শিষ্যাস্তৎপশ্চাৎ জগ্মুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","পশ্চাৎ সাগরস্য মধ্যং তেষু গতেষু তাদৃশঃ প্রবলো ঝঞ্ভ্শনিল উদতিষ্ঠৎ, যেন মহাতরঙ্গ উত্থায তরণিং ছাদিতৱান্, কিন্তু স নিদ্রিত আসীৎ| ");
INSERT INTO sanben_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","তদা শিষ্যা আগত্য তস্য নিদ্রাভঙ্গং কৃৎৱা কথযামাসুঃ, হে প্রভো, ৱযং ম্রিযামহে, ভৱান্ অস্মাকং প্রাণান্ রক্ষতু| ");
INSERT INTO sanben_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","তদা স তান্ উক্তৱান্, হে অল্পৱিশ্ৱাসিনো যূযং কুতো ৱিভীথ? ততঃ স উত্থায ৱাতং সাগরঞ্চ তর্জযামাস, ততো নির্ৱ্ৱাতমভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","অপরং মনুজা ৱিস্মযং ৱিলোক্য কথযামাসুঃ, অহো ৱাতসরিৎপতী অস্য কিমাজ্ঞাগ্রাহিণৌ? কীদৃশোঽযং মানৱঃ| ");
INSERT INTO sanben_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","অনন্তরং স পারং গৎৱা গিদেরীযদেশম্ উপস্থিতৱান্; তদা দ্ৱৌ ভূতগ্রস্তমনুজৌ শ্মশানস্থানাদ্ বহি র্ভূৎৱা তং সাক্ষাৎ কৃতৱন্তৌ, তাৱেতাদৃশৌ প্রচণ্ডাৱাস্তাং যৎ তেন স্থানেন কোপি যাতুং নাশক্নোৎ| ");
INSERT INTO sanben_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","তাৱুচৈঃ কথযামাসতুঃ, হে ঈশ্ৱরস্য সূনো যীশো, ৎৱযা সাকম্ আৱযোঃ কঃ সম্বন্ধঃ? নিরূপিতকালাৎ প্রাগেৱ কিমাৱাভ্যাং যাতনাং দাতুম্ অত্রাগতোসি? ");
INSERT INTO sanben_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","তদানীং তাভ্যাং কিঞ্চিদ্ দূরে ৱরাহাণাম্ একো মহাৱ্রজোঽচরৎ| ");
INSERT INTO sanben_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ততো ভূতৌ তৌ তস্যান্তিকে ৱিনীয কথযামাসতুঃ, যদ্যাৱাং ত্যাজযসি, তর্হি ৱরাহাণাং মধ্যেৱ্রজম্ আৱাং প্রেরয| ");
INSERT INTO sanben_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","তদা যীশুরৱদৎ যাতং, অনন্তরং তৌ যদা মনুজৌ ৱিহায ৱরাহান্ আশ্রিতৱন্তৌ, তদা তে সর্ৱ্ৱে ৱরাহা উচ্চস্থানাৎ মহাজৱেন ধাৱন্তঃ সাগরীযতোযে মজ্জন্তো মম্রুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ততো ৱরাহরক্ষকাঃ পলাযমানা মধ্যেনগরং তৌ ভূতগ্রস্তৌ প্রতি যদ্যদ্ অঘটত, তাঃ সর্ৱ্ৱৱার্ত্তা অৱদন্| ");
INSERT INTO sanben_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ততো নাগরিকাঃ সর্ৱ্ৱে মনুজা যীশুং সাক্ষাৎ কর্ত্তুং বহিরাযাতাঃ তঞ্চ ৱিলোক্য প্রার্থযাঞ্চক্রিরে ভৱান্ অস্মাকং সীমাতো যাতু| ");
INSERT INTO sanben_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","অনন্তরং যীশু র্নৌকামারুহ্য পুনঃ পারমাগত্য নিজগ্রামম্ আযযৌ| ");
INSERT INTO sanben_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ততঃ কতিপযা জনা একং পক্ষাঘাতিনং স্ৱট্টোপরি শাযযিৎৱা তৎসমীপম্ আনযন্; ততো যীশুস্তেষাং প্রতীতিং ৱিজ্ঞায তং পক্ষাঘাতিনং জগাদ, হে পুত্র, সুস্থিরো ভৱ, তৱ কলুষস্য মর্ষণং জাতম্| ");
INSERT INTO sanben_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","তাং কথাং নিশম্য কিযন্ত উপাধ্যাযা মনঃসু চিন্তিতৱন্ত এষ মনুজ ঈশ্ৱরং নিন্দতি| ");
INSERT INTO sanben_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ততঃ স তেষাম্ এতাদৃশীং চিন্তাং ৱিজ্ঞায কথিতৱান্, যূযং মনঃসু কৃত এতাদৃশীং কুচিন্তাং কুরুথ? ");
INSERT INTO sanben_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","তৱ পাপমর্ষণং জাতং, যদ্ৱা ৎৱমুত্থায গচ্ছ, দ্ৱযোরনযো র্ৱাক্যযোঃ কিং ৱাক্যং ৱক্তুং সুগমং? ");
INSERT INTO sanben_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","কিন্তু মেদিন্যাং কলুষং ক্ষমিতুং মনুজসুতস্য সামর্থ্যমস্তীতি যূযং যথা জানীথ, তদর্থং স তং পক্ষাঘাতিনং গদিতৱান্, উত্তিষ্ঠ, নিজশযনীযং আদায গেহং গচ্ছ| ");
INSERT INTO sanben_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ততঃ স তৎক্ষণাদ্ উত্থায নিজগেহং প্রস্থিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","মানৱা ইত্থং ৱিলোক্য ৱিস্মযং মেনিরে, ঈশ্ৱরেণ মানৱায সামর্থ্যম্ ঈদৃশং দত্তং ইতি কারণাৎ তং ধন্যং বভাষিরে চ| ");
INSERT INTO sanben_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","অনন্তরং যীশুস্তৎস্থানাদ্ গচ্ছন্ গচ্ছন্ করসংগ্রহস্থানে সমুপৱিষ্টং মথিনামানম্ একং মনুজং ৱিলোক্য তং বভাষে, মম পশ্চাদ্ আগচ্ছ, ততঃ স উত্থায তস্য পশ্চাদ্ ৱৱ্রাজ| ");
INSERT INTO sanben_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ততঃ পরং যীশৌ গৃহে ভোক্তুম্ উপৱিষ্টে বহৱঃ করসংগ্রাহিণঃ কলুষিণশ্চ মানৱা আগত্য তেন সাকং তস্য শিষ্যৈশ্চ সাকম্ উপৱিৱিশুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ফিরূশিনস্তদ্ দৃষ্ট্ৱা তস্য শিষ্যান্ বভাষিরে, যুষ্মাকং গুরুঃ কিং নিমিত্তং করসংগ্রাহিভিঃ কলুষিভিশ্চ সাকং ভুংক্তে? ");
INSERT INTO sanben_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","যীশুস্তৎ শ্রুৎৱা তান্ প্রত্যৱদৎ, নিরামযলোকানাং চিকিৎসকেন প্রযোজনং নাস্তি, কিন্তু সামযলোকানাং প্রযোজনমাস্তে| ");
INSERT INTO sanben_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","অতো যূযং যাৎৱা ৱচনস্যাস্যার্থং শিক্ষধ্ৱম্, দযাযাং মে যথা প্রীতি র্ন তথা যজ্ঞকর্ম্মণি| যতোঽহং ধার্ম্মিকান্ আহ্ৱাতুং নাগতোঽস্মি কিন্তু মনঃ পরিৱর্ত্তযিতুং পাপিন আহ্ৱাতুম্ আগতোঽস্মি| ");
INSERT INTO sanben_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","অনন্তরং যোহনঃ শিষ্যাস্তস্য সমীপম্ আগত্য কথযামাসুঃ, ফিরূশিনো ৱযঞ্চ পুনঃ পুনরুপৱসামঃ, কিন্তু তৱ শিষ্যা নোপৱসন্তি, কুতঃ? ");
INSERT INTO sanben_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","তদা যীশুস্তান্ অৱোচৎ যাৱৎ সখীনাং সংঙ্গে কন্যাযা ৱরস্তিষ্ঠতি, তাৱৎ কিং তে ৱিলাপং কর্ত্তুং শক্লুৱন্তি? কিন্তু যদা তেষাং সংঙ্গাদ্ ৱরং নযন্তি, তাদৃশঃ সময আগমিষ্যতি, তদা তে উপৱৎস্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","পুরাতনৱসনে কোপি নৱীনৱস্ত্রং ন যোজযতি, যস্মাৎ তেন যোজিতেন পুরাতনৱসনং ছিনত্তি তচ্ছিদ্রঞ্চ বহুকুৎসিতং দৃশ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","অন্যঞ্চ পুরাতনকুৎৱাং কোপি নৱানগোস্তনীরসং ন নিদধাতি, যস্মাৎ তথা কৃতে কুতূ র্ৱিদীর্য্যতে তেন গোস্তনীরসঃ পততি কুতূশ্চ নশ্যতি; তস্মাৎ নৱীনাযাং কুৎৱাং নৱীনো গোস্তনীরসঃ স্থাপ্যতে, তেন দ্ৱযোরৱনং ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","অপরং তেনৈতৎকথাকথনকালে একোঽধিপতিস্তং প্রণম্য বভাষে, মম দুহিতা প্রাযেণৈতাৱৎকালে মৃতা, তস্মাদ্ ভৱানাগত্য তস্যা গাত্রে হস্তমর্পযতু, তেন সা জীৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","তদানীং যীশুঃ শিষ্যৈঃ সাকম্ উত্থায তস্য পশ্চাদ্ ৱৱ্রাজ| ");
INSERT INTO sanben_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ইত্যনন্তরে দ্ৱাদশৱৎসরান্ যাৱৎ প্রদরামযেন শীর্ণৈকা নারী তস্য পশ্চাদ্ আগত্য তস্য ৱসনস্য গ্রন্থিং পস্পর্শ; ");
INSERT INTO sanben_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","যস্মাৎ মযা কেৱলং তস্য ৱসনং স্পৃষ্ট্ৱা স্ৱাস্থ্যং প্রাপ্স্যতে, সা নারীতি মনসি নিশ্চিতৱতী| ");
INSERT INTO sanben_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ততো যীশুর্ৱদনং পরাৱর্ত্ত্য তাং জগাদ, হে কন্যে, ৎৱং সুস্থিরা ভৱ, তৱ ৱিশ্ৱাসস্ত্ৱাং স্ৱস্থামকার্ষীৎ| এতদ্ৱাক্যে গদিতএৱ সা যোষিৎ স্ৱস্থাভূৎ| ");
INSERT INTO sanben_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","অপরং যীশুস্তস্যাধ্যক্ষস্য গেহং গৎৱা ৱাদকপ্রভৃতীন্ বহূন্ লোকান্ শব্দাযমানান্ ৱিলোক্য তান্ অৱদৎ, ");
INSERT INTO sanben_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","পন্থানং ত্যজ, কন্যেযং নাম্রিযত নিদ্রিতাস্তে; কথামেতাং শ্রুৎৱা তে তমুপজহসুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","কিন্তু সর্ৱ্ৱেষু বহিষ্কৃতেষু সোঽভ্যন্তরং গৎৱা কন্যাযাঃ করং ধৃতৱান্, তেন সোদতিষ্ঠৎ; ");
INSERT INTO sanben_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ততস্তৎকর্ম্মণো যশঃ কৃৎস্নং তং দেশং ৱ্যাপ্তৱৎ| ");
INSERT INTO sanben_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","ততঃ পরং যীশুস্তস্মাৎ স্থানাদ্ যাত্রাং চকার; তদা হে দাযূদঃ সন্তান, অস্মান্ দযস্ৱ, ইতি ৱদন্তৌ দ্ৱৌ জনাৱন্ধৌ প্রোচৈরাহূযন্তৌ তৎপশ্চাদ্ ৱৱ্রজতুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ততো যীশৌ গেহমধ্যং প্রৱিষ্টং তাৱপি তস্য সমীপম্ উপস্থিতৱন্তৌ, তদানীং স তৌ পৃষ্টৱান্ কর্ম্মৈতৎ কর্ত্তুং মম সামর্থ্যম্ আস্তে, যুৱাং কিমিতি প্রতীথঃ? তদা তৌ প্রত্যূচতুঃ, সত্যং প্রভো| ");
INSERT INTO sanben_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","তদানীং স তযো র্লোচনানি স্পৃশন্ বভাষে, যুৱযোঃ প্রতীত্যনুসারাদ্ যুৱযো র্মঙ্গলং ভূযাৎ| তেন তৎক্ষণাৎ তযো র্নেত্রাণি প্রসন্নান্যভৱন্, ");
INSERT INTO sanben_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","পশ্চাদ্ যীশুস্তৌ দৃঢমাজ্ঞাপ্য জগাদ, অৱধত্তম্ এতাং কথাং কোপি মনুজো ম জানীযাৎ| ");
INSERT INTO sanben_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","কিন্তু তৌ প্রস্থায তস্মিন্ কৃৎস্নে দেশে তস্য কীর্ত্তিং প্রকাশযামাসতুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","অপরং তৌ বহির্যাত এতস্মিন্নন্তরে মনুজা একং ভূতগ্রস্তমূকং তস্য সমীপম্ আনীতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","তেন ভূতে ত্যাজিতে স মূকঃ কথাং কথযিতুং প্রারভত, তেন জনা ৱিস্মযং ৱিজ্ঞায কথযামাসুঃ, ইস্রাযেলো ৱংশে কদাপি নেদৃগদৃশ্যত; ");
INSERT INTO sanben_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","কিন্তু ফিরূশিনঃ কথযাঞ্চক্রুঃ ভূতাধিপতিনা স ভূতান্ ত্যাজযতি| ");
INSERT INTO sanben_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ততঃ পরং যীশুস্তেষাং ভজনভৱন উপদিশন্ রাজ্যস্য সুসংৱাদং প্রচারযন্ লোকানাং যস্য য আমযো যা চ পীডাসীৎ, তান্ শমযন্ শমযংশ্চ সর্ৱ্ৱাণি নগরাণি গ্রামাংশ্চ বভ্রাম| ");
INSERT INTO sanben_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","অন্যঞ্চ মনুজান্ ৱ্যাকুলান্ অরক্ষকমেষানিৱ চ ত্যক্তান্ নিরীক্ষ্য তেষু কারুণিকঃ সন্ শিষ্যান্ অৱদৎ, ");
INSERT INTO sanben_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","শস্যানি প্রচুরাণি সন্তি, কিন্তু ছেত্তারঃ স্তোকাঃ| ");
INSERT INTO sanben_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ক্ষেত্রং প্রত্যপরান্ ছেদকান্ প্রহেতুং শস্যস্ৱামিনং প্রার্থযধ্ৱম্| ");
INSERT INTO sanben_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","অনন্তরং যীশু র্দ্ৱাদশশিষ্যান্ আহূযামেধ্যভূতান্ ত্যাজযিতুং সর্ৱ্ৱপ্রকাররোগান্ পীডাশ্চ শমযিতুং তেভ্যঃ সামর্থ্যমদাৎ| ");
INSERT INTO sanben_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","তেষাং দ্ৱাদশপ্রেষ্যাণাং নামান্যেতানি| প্রথমং শিমোন্ যং পিতরং ৱদন্তি, ততঃ পরং তস্য সহজ আন্দ্রিযঃ, সিৱদিযস্য পুত্রো যাকূব্ ");
INSERT INTO sanben_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","তস্য সহজো যোহন্; ফিলিপ্ বর্থলময্ থোমাঃ করসংগ্রাহী মথিঃ, আল্ফেযপুত্রো যাকূব্, ");
INSERT INTO sanben_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","কিনানীযঃ শিমোন্, য ঈষ্করিযোতীযযিহূদাঃ খ্রীষ্টং পরকরেঽর্পযৎ| ");
INSERT INTO sanben_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","এতান্ দ্ৱাদশশিষ্যান্ যীশুঃ প্রেষযন্ ইত্যাজ্ঞাপযৎ, যূযম্ অন্যদেশীযানাং পদৱীং শেমিরোণীযানাং কিমপি নগরঞ্চ ন প্রৱিশ্যে ");
INSERT INTO sanben_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ইস্রাযেল্গোত্রস্য হারিতা যে যে মেষাস্তেষামেৱ সমীপং যাত| ");
INSERT INTO sanben_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","গৎৱা গৎৱা স্ৱর্গস্য রাজৎৱং সৱিধমভৱৎ, এতাং কথাং প্রচারযত| ");
INSERT INTO sanben_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","আমযগ্রস্তান্ স্ৱস্থান্ কুরুত, কুষ্ঠিনঃ পরিষ্কুরুত, মৃতলোকান্ জীৱযত, ভূতান্ ত্যাজযত, ৱিনা মূল্যং যূযম্ অলভধ্ৱং ৱিনৈৱ মূল্যং ৱিশ্রাণযত| ");
INSERT INTO sanben_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","কিন্তু স্ৱেষাং কটিবন্ধেষু স্ৱর্ণরূপ্যতাম্রাণাং কিমপি ন গৃহ্লীত| ");
INSERT INTO sanben_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","অন্যচ্চ যাত্রাযৈ চেলসম্পুটং ৱা দ্ৱিতীযৱসনং ৱা পাদুকে ৱা যষ্টিঃ, এতান্ মা গৃহ্লীত, যতঃ কার্য্যকৃৎ ভর্ত্তুং যোগ্যো ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","অপরং যূযং যৎ পুরং যঞ্চ গ্রামং প্রৱিশথ, তত্র যো জনো যোগ্যপাত্রং তমৱগত্য যানকালং যাৱৎ তত্র তিষ্ঠত| ");
INSERT INTO sanben_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","যদা যূযং তদ্গেহং প্রৱিশথ, তদা তমাশিষং ৱদত| ");
INSERT INTO sanben_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","যদি স যোগ্যপাত্রং ভৱতি, তর্হি তৎকল্যাণং তস্মৈ ভৱিষ্যতি, নোচেৎ সাশীর্যুষ্মভ্যমেৱ ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","কিন্তু যে জনা যুষ্মাকমাতিথ্যং ন ৱিদধতি যুষ্মাকং কথাঞ্চ ন শৃণ্ৱন্তি তেষাং গেহাৎ পুরাদ্ৱা প্রস্থানকালে স্ৱপদূলীঃ পাতযত| ");
INSERT INTO sanben_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","যুষ্মানহং তথ্যং ৱচ্মি ৱিচারদিনে তৎপুরস্য দশাতঃ সিদোমমোরাপুরযোর্দশা সহ্যতরা ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","পশ্যত, ৱৃকযূথমধ্যে মেষঃ যথাৱিস্তথা যুষ্মান প্রহিণোমি, তস্মাদ্ যূযম্ অহিরিৱ সতর্কাঃ কপোতাইৱাহিংসকা ভৱত| ");
INSERT INTO sanben_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","নৃভ্যঃ সাৱধানা ভৱত; যতস্তৈ র্যূযং রাজসংসদি সমর্পিষ্যধ্ৱে তেষাং ভজনগেহে প্রহারিষ্যধ্ৱে| ");
INSERT INTO sanben_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","যূযং মন্নামহেতোঃ শাস্তৃণাং রাজ্ঞাঞ্চ সমক্ষং তানন্যদেশিনশ্চাধি সাক্ষিৎৱার্থমানেষ্যধ্ৱে| ");
INSERT INTO sanben_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","কিন্ত্ৱিত্থং সমর্পিতা যূযং কথং কিমুত্তরং ৱক্ষ্যথ তত্র মা চিন্তযত, যতস্তদা যুষ্মাভি র্যদ্ ৱক্তৱ্যং তৎ তদ্দণ্ডে যুষ্মন্মনঃ সু সমুপস্থাস্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","যস্মাৎ তদা যো ৱক্ষ্যতি স ন যূযং কিন্তু যুষ্মাকমন্তরস্থঃ পিত্রাত্মা| ");
INSERT INTO sanben_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","সহজঃ সহজং তাতঃ সুতঞ্চ মৃতৌ সমর্পযিষ্যতি, অপত্যাগি স্ৱস্ৱপিত্রোे র্ৱিপক্ষীভূয তৌ ঘাতযিষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","মন্নমহেতোঃ সর্ৱ্ৱে জনা যুষ্মান্ ঋृতীযিষ্যন্তে, কিন্তু যঃ শেষং যাৱদ্ ধৈর্য্যং ঘৃৎৱা স্থাস্যতি, স ত্রাযিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","তৈ র্যদা যূযমেকপুরে তাডিষ্যধ্ৱে, তদা যূযমন্যপুরং পলাযধ্ৱং যুষ্মানহং তথ্যং ৱচ্মি যাৱন্মনুজসুতো নৈতি তাৱদ্ ইস্রাযেল্দেশীযসর্ৱ্ৱনগরভ্রমণং সমাপযিতুং ন শক্ষ্যথ| ");
INSERT INTO sanben_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","গুরোঃ শিষ্যো ন মহান্, প্রভোর্দাসো ন মহান্| ");
INSERT INTO sanben_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","যদি শিষ্যো নিজগুরো র্দাসশ্চ স্ৱপ্রভোঃ সমানো ভৱতি তর্হি তদ্ যথেষ্টং| চেত্তৈর্গৃহপতির্ভূতরাজ উচ্যতে, তর্হি পরিৱারাঃ কিং তথা ন ৱক্ষ্যন্তে? ");
INSERT INTO sanben_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","কিন্তু তেভ্যো যূযং মা বিভীত, যতো যন্ন প্রকাশিষ্যতে, তাদৃক্ ছাদিতং কিমপি নাস্তি, যচ্চ ন ৱ্যঞ্চিষ্যতে, তাদৃগ্ গুপ্তং কিমপি নাস্তি| ");
INSERT INTO sanben_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","যদহং যুষ্মান্ তমসি ৱচ্মি তদ্ যুষ্মাভির্দীপ্তৌ কথ্যতাং; কর্ণাভ্যাং যৎ শ্রূযতে তদ্ গেহোপরি প্রচার্য্যতাং| ");
INSERT INTO sanben_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","যে কাযং হন্তুং শক্নুৱন্তি নাত্মানং, তেভ্যো মা ভৈষ্ট; যঃ কাযাত্মানৌ নিরযে নাশযিতুং, শক্নোতি, ততো বিভীত| ");
INSERT INTO sanben_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","দ্ৱৌ চটকৌ কিমেকতাম্রমুদ্রযা ন ৱিক্রীযেতে? তথাপি যুষ্মত্তাতানুমতিং ৱিনা তেষামেকোপি ভুৱি ন পততি| ");
INSERT INTO sanben_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","যুষ্মচ্ছিরসাং সর্ৱ্ৱকচা গণিতাংঃ সন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","অতো মা বিভীত, যূযং বহুচটকেভ্যো বহুমূল্যাঃ| ");
INSERT INTO sanben_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","যো মনুজসাক্ষান্মামঙ্গীকুরুতে তমহং স্ৱর্গস্থতাতসাক্ষাদঙ্গীকরিষ্যে| ");
INSERT INTO sanben_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","পৃথ্ৱ্যামহং শান্তিং দাতুমাগতইতি মানুভৱত, শান্তিং দাতুং ন কিন্ত্ৱসিং| ");
INSERT INTO sanben_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","পিতৃমাতৃশ্চশ্রূভিঃ সাকং সুতসুতাবধূ র্ৱিরোধযিতুঞ্চাগতেाস্মি| ");
INSERT INTO sanben_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","ততঃ স্ৱস্ৱপরিৱারএৱ নৃশত্রু র্ভৱিতা| ");
INSERT INTO sanben_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","যঃ পিতরি মাতরি ৱা মত্তোধিকং প্রীযতে, স ন মদর্হঃ; ");
INSERT INTO sanben_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","যশ্চ সুতে সুতাযাং ৱা মত্তোধিকং প্রীযতে, সেाপি ন মদর্হঃ| ");
INSERT INTO sanben_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","যঃ স্ৱক্রুশং গৃহ্লন্ মৎপশ্চান্নৈতি, সেाপি ন মদর্হঃ| ");
INSERT INTO sanben_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","যঃ স্ৱপ্রাণানৱতি, স তান্ হারযিষ্যতে, যস্তু মৎকৃতে স্ৱপ্রাণান্ হারযতি, স তানৱতি| ");
INSERT INTO sanben_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","যো যুষ্মাকমাতিথ্যং ৱিদধাতি, স মমাতিথ্যং ৱিদধাতি, যশ্চ মমাতিথ্যং ৱিদধাতি, স মৎপ্রেরকস্যাতিথ্যং ৱিদধাতি| ");
INSERT INTO sanben_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","যো ভৱিষ্যদ্ৱাদীতি জ্ঞাৎৱা তস্যাতিথ্যং ৱিধত্তে, স ভৱিষ্যদ্ৱাদিনঃ ফলং লপ্স্যতে, যশ্চ ধার্ম্মিক ইতি ৱিদিৎৱা তস্যাতিথ্যং ৱিধত্তে স ধার্ম্মিকমানৱস্য ফলং প্রাপ্স্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","যশ্চ কশ্চিৎ এতেষাং ক্ষুদ্রনরাণাম্ যং কঞ্চনৈকং শিষ্য ইতি ৱিদিৎৱা কংসৈকং শীতলসলিলং তস্মৈ দত্তে, যুষ্মানহং তথ্যং ৱদামি, স কেনাপি প্রকারেণ ফলেন ন ৱঞ্চিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ইত্থং যীশুঃ স্ৱদ্ৱাদশশিষ্যাণামাজ্ঞাপনং সমাপ্য পুরে পুর উপদেষ্টুং সুসংৱাদং প্রচারযিতুং তৎস্থানাৎ প্রতস্থে| ");
INSERT INTO sanben_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","অনন্তরং যোহন্ কারাযাং তিষ্ঠন্ খ্রিষ্টস্য কর্ম্মণাং ৱার্ত্তং প্রাপ্য যস্যাগমনৱার্ত্তাসীৎ সএৱ কিং ৎৱং? ৱা ৱযমন্যম্ অপেক্ষিষ্যামহে? ");
INSERT INTO sanben_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","এতৎ প্রষ্টুং নিজৌ দ্ৱৌ শিষ্যৌ প্রাহিণোৎ| ");
INSERT INTO sanben_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","যীশুঃ প্রত্যৱোচৎ, অন্ধা নেত্রাণি লভন্তে, খঞ্চা গচ্ছন্তি, কুষ্ঠিনঃ স্ৱস্থা ভৱন্তি, বধিরাঃ শৃণ্ৱন্তি, মৃতা জীৱন্ত উত্তিষ্ঠন্তি, দরিদ্রাণাং সমীপে সুসংৱাদঃ প্রচার্য্যত, ");
INSERT INTO sanben_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","এতানি যদ্যদ্ যুৱাং শৃণুথঃ পশ্যথশ্চ গৎৱা তদ্ৱার্ত্তাং যোহনং গদতং| ");
INSERT INTO sanben_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","যস্যাহং ন ৱিঘ্নীভৱামি, সএৱ ধন্যঃ| ");
INSERT INTO sanben_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","অনন্তরং তযোঃ প্রস্থিতযো র্যীশু র্যোহনম্ উদ্দিশ্য জনান্ জগাদ, যূযং কিং দ্রষ্টুং ৱহির্মধ্যেপ্রান্তরম্ অগচ্ছত? কিং ৱাতেন কম্পিতং নলং? ");
INSERT INTO sanben_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","ৱা কিং ৱীক্ষিতুং ৱহির্গতৱন্তঃ? কিং পরিহিতসূক্ষ্মৱসনং মনুজমেকং? পশ্যত, যে সূক্ষ্মৱসনানি পরিদধতি, তে রাজধান্যাং তিষ্ঠন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","তর্হি যূযং কিং দ্রষ্টুং বহিরগমত, কিমেকং ভৱিষ্যদ্ৱাদিনং? তদেৱ সত্যং| যুষ্মানহং ৱদামি, স ভৱিষ্যদ্ৱাদিনোপি মহান্; ");
INSERT INTO sanben_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","যতঃ, পশ্য স্ৱকীযদূতোযং ৎৱদগ্রে প্রেষ্যতে মযা| স গৎৱা তৱ পন্থানং স্মযক্ পরিষ্করিষ্যতি|| এতদ্ৱচনং যমধি লিখিতমাস্তে সোঽযং যোহন্| ");
INSERT INTO sanben_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","অপরং যুষ্মানহং তথ্যং ব্রৱীমি, মজ্জযিতু র্যোহনঃ শ্রেষ্ঠঃ কোপি নারীতো নাজাযত; তথাপি স্ৱর্গরাজ্যমধ্যে সর্ৱ্ৱেভ্যো যঃ ক্ষুদ্রঃ স যোহনঃ শ্রেষ্ঠঃ| ");
INSERT INTO sanben_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","অপরঞ্চ আ যোহনোঽদ্য যাৱৎ স্ৱর্গরাজ্যং বলাদাক্রান্তং ভৱতি আক্রমিনশ্চ জনা বলেন তদধিকুর্ৱ্ৱন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","যতো যোহনং যাৱৎ সর্ৱ্ৱভৱিষ্যদ্ৱাদিভি র্ৱ্যৱস্থযা চ উপদেশঃ প্রাকাশ্যত| ");
INSERT INTO sanben_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","যদি যূযমিদং ৱাক্যং গ্রহীতুং শক্নুথ, তর্হি শ্রেযঃ, যস্যাগমনস্য ৱচনমাস্তে সোঽযম্ এলিযঃ| ");
INSERT INTO sanben_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","যস্য শ্রোতুং কর্ণৌ স্তঃ স শৃণোতু| ");
INSERT INTO sanben_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","এতে ৱিদ্যমানজনাঃ কৈ র্মযোপমীযন্তে? যে বালকা হট্ট উপৱিশ্য স্ৱং স্ৱং বন্ধুমাহূয ৱদন্তি, ");
INSERT INTO sanben_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","ৱযং যুষ্মাকং সমীপে ৱংশীরৱাদযাম, কিন্তু যূযং নানৃত্যত; যুষ্মাকং সমীপে চ ৱযমরোদিম, কিন্তু যূযং ন ৱ্যলপত, তাদৃশৈ র্বালকৈস্ত উপমাযিষ্যন্তে| ");
INSERT INTO sanben_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","যতো যোহন্ আগত্য ন ভুক্তৱান্ ন পীতৱাংশ্চ, তেন লোকা ৱদন্তি, স ভূতগ্রস্ত ইতি| ");
INSERT INTO sanben_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","মনুজসুত আগত্য ভুক্তৱান্ পীতৱাংশ্চ, তেন লোকা ৱদন্তি, পশ্যত এষ ভোক্তা মদ্যপাতা চণ্ডালপাপিনাং বন্ধশ্চ, কিন্তু জ্ঞানিনো জ্ঞানৱ্যৱহারং নির্দোষং জানন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","স যত্র যত্র পুরে বহ্ৱাশ্চর্য্যং কর্ম্ম কৃতৱান্, তন্নিৱাসিনাং মনঃপরাৱৃত্ত্যভাৱাৎ তানি নগরাণি প্রতি হন্তেত্যুক্তা কথিতৱান্, ");
INSERT INTO sanben_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","হা কোরাসীন্, হা বৈৎসৈদে, যুষ্মন্মধ্যে যদ্যদাশ্চর্য্যং কর্ম্ম কৃতং যদি তৎ সোরসীদোন্নগর অকারিষ্যত, তর্হি পূর্ৱ্ৱমেৱ তন্নিৱাসিনঃ শাণৱসনে ভস্মনি চোপৱিশন্তো মনাংসি পরাৱর্ত্তিষ্যন্ত| ");
INSERT INTO sanben_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","তস্মাদহং যুষ্মান্ ৱদামি, ৱিচারদিনে যুষ্মাকং দশাতঃ সোরসীদোনো র্দশা সহ্যতরা ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","অপরঞ্চ বত কফর্নাহূম্, ৎৱং স্ৱর্গং যাৱদুন্নতোসি, কিন্তু নরকে নিক্ষেপ্স্যসে, যস্মাৎ ৎৱযি যান্যাশ্চর্য্যাণি কর্ম্মণ্যকারিষত, যদি তানি সিদোম্নগর অকারিষ্যন্ত, তর্হি তদদ্য যাৱদস্থাস্যৎ| ");
INSERT INTO sanben_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","কিন্ত্ৱহং যুষ্মান্ ৱদামি, ৱিচারদিনে তৱ দণ্ডতঃ সিদোমো দণ্ডো সহ্যতরো ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","এতস্মিন্নেৱ সমযে যীশুঃ পুনরুৱাচ, হে স্ৱর্গপৃথিৱ্যোরেকাধিপতে পিতস্ত্ৱং জ্ঞানৱতো ৱিদুষশ্চ লোকান্ প্রত্যেতানি ন প্রকাশ্য বালকান্ প্রতি প্রকাশিতৱান্, ইতি হেতোস্ত্ৱাং ধন্যং ৱদামি| ");
INSERT INTO sanben_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","হে পিতঃ, ইত্থং ভৱেৎ যত ইদং ৎৱদৃষ্টাৱুত্তমং| ");
INSERT INTO sanben_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","পিত্রা মযি সর্ৱ্ৱাণি সমর্পিতানি, পিতরং ৱিনা কোপি পুত্রং ন জানাতি, যান্ প্রতি পুত্রেণ পিতা প্রকাশ্যতে তান্ ৱিনা পুত্রাদ্ অন্যঃ কোপি পিতরং ন জানাতি| ");
INSERT INTO sanben_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","হে পরিশ্রান্তা ভারাক্রান্তাশ্চ লোকা যূযং মৎসন্নিধিম্ আগচ্ছত, অহং যুষ্মান্ ৱিশ্রমযিষ্যামি| ");
INSERT INTO sanben_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","অহং ক্ষমণশীলো নম্রমনাশ্চ, তস্মাৎ মম যুগং স্ৱেষামুপরি ধারযত মত্তঃ শিক্ষধ্ৱঞ্চ, তেন যূযং স্ৱে স্ৱে মনসি ৱিশ্রামং লপ্স্যধ্বে| ");
INSERT INTO sanben_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","যতো মম যুগম্ অনাযাসং মম ভারশ্চ লঘুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","অনন্তরং যীশু র্ৱিশ্রামৱারে শ্স্যমধ্যেন গচ্ছতি, তদা তচ্ছিষ্যা বুভুক্ষিতাঃ সন্তঃ শ্স্যমঞ্জরীশ্ছৎৱা ছিৎৱা খাদিতুমারভন্ত| ");
INSERT INTO sanben_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","তদ্ ৱিলোক্য ফিরূশিনো যীশুং জগদুঃ, পশ্য ৱিশ্রামৱারে যৎ কর্ম্মাকর্ত্তৱ্যং তদেৱ তৱ শিষ্যাঃ কুর্ৱ্ৱন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","স তান্ প্রত্যাৱদত, দাযূদ্ তৎসঙ্গিনশ্চ বুভুক্ষিতাঃ সন্তো যৎ কর্ম্মাকুর্ৱ্ৱন্ তৎ কিং যুষ্মাভি র্নাপাঠি? ");
INSERT INTO sanben_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","যে দর্শনীযাঃ পূপাঃ যাজকান্ ৱিনা তস্য তৎসঙ্গিমনুজানাঞ্চাভোজনীযাস্ত ঈশ্ৱরাৱাসং প্রৱিষ্টেন তেন ভুক্তাঃ| ");
INSERT INTO sanben_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","অন্যচ্চ ৱিশ্রামৱারে মধ্যেমন্দিরং ৱিশ্রামৱারীযং নিযমং লঙ্ৱন্তোপি যাজকা নির্দোষা ভৱন্তি, শাস্ত্রমধ্যে কিমিদমপি যুষ্মাভি র্ন পঠিতং? ");
INSERT INTO sanben_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","যুষ্মানহং ৱদামি, অত্র স্থানে মন্দিরাদপি গরীযান্ এক আস্তে| ");
INSERT INTO sanben_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","কিন্তু দযাযাং মে যথা প্রীতি র্ন তথা যজ্ঞকর্ম্মণি| এতদ্ৱচনস্যার্থং যদি যুযম্ অজ্ঞাসিষ্ট তর্হি নির্দোষান্ দোষিণো নাকার্ষ্ট| ");
INSERT INTO sanben_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","অন্যচ্চ মনুজসুতো ৱিশ্রামৱারস্যাপি পতিরাস্তে| ");
INSERT INTO sanben_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","অনন্তরং স তৎস্থানাৎ প্রস্থায তেষাং ভজনভৱনং প্রৱিষ্টৱান্, তদানীম্ একঃ শুষ্ককরামযৱান্ উপস্থিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ততো যীশুম্ অপৱদিতুং মানুষাঃ পপ্রচ্ছুঃ, ৱিশ্রামৱারে নিরামযৎৱং করণীযং ন ৱা? ");
INSERT INTO sanben_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","তেন স প্রত্যুৱাচ, ৱিশ্রামৱারে যদি কস্যচিদ্ অৱি র্গর্ত্তে পততি, তর্হি যস্তং ঘৃৎৱা ন তোলযতি, এতাদৃশো মনুজো যুষ্মাকং মধ্যে ক আস্তে? ");
INSERT INTO sanben_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","অৱে র্মানৱঃ কিং নহি শ্রেযান্? অতো ৱিশ্রামৱারে হিতকর্ম্ম কর্ত্তৱ্যং| ");
INSERT INTO sanben_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","অনন্তরং স তং মানৱং গদিতৱান্, করং প্রসারয; তেন করে প্রসারিতে সোন্যকরৱৎ স্ৱস্থোঽভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","তদা ফিরূশিনো বহির্ভূয কথং তং হনিষ্যাম ইতি কুমন্ত্রণাং তৎপ্রাতিকূল্যেন চক্রুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ততো যীশুস্তদ্ ৱিদিৎৱা স্থনান্তরং গতৱান্; অন্যেষু বহুনরেষু তৎপশ্চাদ্ গতেষু তান্ স নিরামযান্ কৃৎৱা ইত্যাজ্ঞাপযৎ, ");
INSERT INTO sanben_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","যূযং মাং ন পরিচাযযত| ");
INSERT INTO sanben_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","তস্মাৎ মম প্রীযো মনোনীতো মনসস্তুষ্টিকারকঃ| মদীযঃ সেৱকো যস্তু ৱিদ্যতে তং সমীক্ষতাং| তস্যোপরি স্ৱকীযাত্মা মযা সংস্থাপযিষ্যতে| তেনান্যদেশজাতেষু ৱ্যৱস্থা সংপ্রকাশ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","কেনাপি ন ৱিরোধং স ৱিৱাদঞ্চ করিষ্যতি| ন চ রাজপথে তেন ৱচনং শ্রাৱযিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ৱ্যৱস্থা চলিতা যাৱৎ নহি তেন করিষ্যতে| তাৱৎ নলো ৱিদীর্ণোঽপি ভংক্ষ্যতে নহি তেন চ| তথা সধূমৱর্ত্তিঞ্চ ন স নির্ৱ্ৱাপযিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","প্রত্যাশাঞ্চ করিষ্যন্তি তন্নাম্নি ভিন্নদেশজাঃ| ");
INSERT INTO sanben_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","যান্যেতানি ৱচনানি যিশযিযভৱিষ্যদ্ৱাদিনা প্রোক্তান্যাসন্, তানি সফলান্যভৱন্| ");
INSERT INTO sanben_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","অনন্তরং লোকৈ স্তৎসমীপম্ আনীতো ভূতগ্রস্তান্ধমূকৈকমনুজস্তেন স্ৱস্থীকৃতঃ, ততঃ সোঽন্ধো মূকো দ্রষ্টুং ৱক্তুঞ্চারব্ধৱান্| ");
INSERT INTO sanben_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","অনেন সর্ৱ্ৱে ৱিস্মিতাঃ কথযাঞ্চক্রুঃ, এষঃ কিং দাযূদঃ সন্তানো নহি? ");
INSERT INTO sanben_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","কিন্তু ফিরূশিনস্তৎ শ্রুৎৱা গদিতৱন্তঃ, বাল্সিবূব্নাম্নো ভূতরাজস্য সাহায্যং ৱিনা নাযং ভূতান্ ত্যাজযতি| ");
INSERT INTO sanben_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","তদানীং যীশুস্তেষাম্ ইতি মানসং ৱিজ্ঞায তান্ অৱদৎ কিঞ্চন রাজ্যং যদি স্ৱৱিপক্ষাদ্ ভিদ্যতে, তর্হি তৎ উচ্ছিদ্যতে; যচ্চ কিঞ্চন নগরং ৱা গৃহং স্ৱৱিপক্ষাদ্ ৱিভিদ্যতে, তৎ স্থাতুং ন শক্নোতি| ");
INSERT INTO sanben_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","তদ্ৱৎ শযতানো যদি শযতানং বহিঃ কৃৎৱা স্ৱৱিপক্ষাৎ পৃথক্ পৃথক্ ভৱতি, তর্হি তস্য রাজ্যং কেন প্রকারেণ স্থাস্যতি? ");
INSERT INTO sanben_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","অহঞ্চ যদি বাল্সিবূবা ভূতান্ ত্যাজযামি, তর্হি যুষ্মাকং সন্তানাঃ কেন ভূতান্ ত্যাজযন্তি? তস্মাদ্ যুষ্মাকম্ এতদ্ৱিচারযিতারস্ত এৱ ভৱিষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","কিন্তৱহং যদীশ্ৱরাত্মনা ভূতান্ ত্যাজযামি, তর্হীশ্ৱরস্য রাজ্যং যুষ্মাকং সন্নিধিমাগতৱৎ| ");
INSERT INTO sanben_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","অন্যঞ্চ কোপি বলৱন্ত জনং প্রথমতো ন বদ্ৱ্ৱা কেন প্রকারেণ তস্য গৃহং প্রৱিশ্য তদ্দ্রৱ্যাদি লোঠযিতুং শক্নোতি? কিন্তু তৎ কৃৎৱা তদীযগৃস্য দ্রৱ্যাদি লোঠযিতুং শক্নোতি| ");
INSERT INTO sanben_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","যঃ কশ্চিৎ মম স্ৱপক্ষীযো নহি স ৱিপক্ষীয আস্তে, যশ্চ মযা সাকং ন সংগৃহ্লাতি, স ৱিকিরতি| ");
INSERT INTO sanben_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","অতএৱ যুষ্মানহং ৱদামি, মনুজানাং সর্ৱ্ৱপ্রকারপাপানাং নিন্দাযাশ্চ মর্ষণং ভৱিতুং শক্নোতি, কিন্তু পৱিত্রস্যাত্মনো ৱিরুদ্ধনিন্দাযা মর্ষণং ভৱিতুং ন শক্নোতি| ");
INSERT INTO sanben_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","যো মনুজসুতস্য ৱিরুদ্ধাং কথাং কথযতি, তস্যাপরাধস্য ক্ষমা ভৱিতুং শক্নোতি, কিন্তু যঃ কশ্চিৎ পৱিত্রস্যাত্মনো ৱিরুদ্ধাং কথাং কথযতি নেহলোকে ন প্রেত্য তস্যাপরাধস্য ক্ষমা ভৱিতুং শক্নোতি| ");
INSERT INTO sanben_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","পাদপং যদি ভদ্রং ৱদথ, তর্হি তস্য ফলমপি সাধু ৱক্তৱ্যং, যদি চ পাদপং অসাধুং ৱদথ, তর্হি তস্য ফলমপ্যসাধু ৱক্তৱ্যং; যতঃ স্ৱীযস্ৱীযফলেন পাদপঃ পরিচীযতে| ");
INSERT INTO sanben_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","রে ভুজগৱংশা যূযমসাধৱঃ সন্তঃ কথং সাধু ৱাক্যং ৱক্তুং শক্ষ্যথ? যস্মাদ্ অন্তঃকরণস্য পূর্ণভাৱানুসারাদ্ ৱদনাদ্ ৱচো নির্গচ্ছতি| ");
INSERT INTO sanben_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","তেন সাধুর্মানৱোঽন্তঃকরণরূপাৎ সাধুভাণ্ডাগারাৎ সাধু দ্রৱ্যং নির্গমযতি, অসাধুর্মানুষস্ত্ৱসাধুভাণ্ডাগারাদ্ অসাধুৱস্তূনি নির্গমযতি| ");
INSERT INTO sanben_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","কিন্ত্ৱহং যুষ্মান্ ৱদামি, মনুজা যাৱন্ত্যালস্যৱচাংসি ৱদন্তি, ৱিচারদিনে তদুত্তরমৱশ্যং দাতৱ্যং, ");
INSERT INTO sanben_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","যতস্ত্ৱং স্ৱীযৱচোভি র্নিরপরাধঃ স্ৱীযৱচোভিশ্চ সাপরাধো গণিষ্যসে| ");
INSERT INTO sanben_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","তদানীং কতিপযা উপাধ্যাযাঃ ফিরূশিনশ্চ জগদুঃ, হে গুরো ৱযং ভৱত্তঃ কিঞ্চন লক্ষ্ম দিদৃক্ষামঃ| ");
INSERT INTO sanben_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","তদা স প্রত্যুক্তৱান্, দুষ্টো ৱ্যভিচারী চ ৱংশো লক্ষ্ম মৃগযতে, কিন্তু ভৱিষ্যদ্ৱাদিনো যূনসো লক্ষ্ম ৱিহাযান্যৎ কিমপি লক্ষ্ম তে ন প্রদর্শযিষ্যন্তে| ");
INSERT INTO sanben_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","যতো যূনম্ যথা ত্র্যহোরাত্রং বৃহন্মীনস্য কুক্ষাৱাসীৎ, তথা মনুজপুত্রোপি ত্র্যহোরাত্রং মেদিন্যা মধ্যে স্থাস্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","অপরং নীনিৱীযা মানৱা ৱিচারদিন এতদ্ৱংশীযানাং প্রতিকূলম্ উত্থায তান্ দোষিণঃ করিষ্যন্তি, যস্মাত্তে যূনস উপদেশাৎ মনাংসি পরাৱর্ত্তযাঞ্চক্রিরে, কিন্ত্ৱত্র যূনসোপি গুরুতর এক আস্তে| ");
INSERT INTO sanben_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","পুনশ্চ দক্ষিণদেশীযা রাজ্ঞী ৱিচারদিন এতদ্ৱংশীযানাং প্রতিকূলমুত্থায তান্ দোষিণঃ করিষ্যতি যতঃ সা রাজ্ঞী সুলেমনো ৱিদ্যাযাঃ কথাং শ্রোতুং মেদিন্যাঃ সীম্ন আগচ্ছৎ, কিন্তু সুলেমনোপি গুরুতর একো জনোঽত্র আস্তে| ");
INSERT INTO sanben_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","অপরং মনুজাদ্ বহির্গতো ঽপৱিত্রভূতঃ শুষ্কস্থানেন গৎৱা ৱিশ্রামং গৱেষযতি, কিন্তু তদলভমানঃ স ৱক্তি, যস্মা; নিকেতনাদ্ আগমং, তদেৱ ৱেশ্ম পকাৱৃত্য যামি| ");
INSERT INTO sanben_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","পশ্চাৎ স তৎ স্থানম্ উপস্থায তৎ শূন্যং মার্জ্জিতং শোভিতঞ্চ ৱিলোক্য ৱ্রজন্ স্ৱতোপি দুষ্টতরান্ অন্যসপ্তভূতান্ সঙ্গিনঃ করোতি| ");
INSERT INTO sanben_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ততস্তে তৎ স্থানং প্রৱিশ্য নিৱসন্তি, তেন তস্য মনুজস্য শেষদশা পূর্ৱ্ৱদশাতোতীৱাশুভা ভৱতি, এতেষাং দুষ্টৱংশ্যানামপি তথৈৱ ঘটিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","মানৱেভ্য এতাসাং কথনাং কথনকালে তস্য মাতা সহজাশ্চ তেন সাকং কাঞ্চিৎ কথাং কথযিতুং ৱাঞ্ছন্তো বহিরেৱ স্থিতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ততঃ কশ্চিৎ তস্মৈ কথিতৱান্, পশ্য তৱ জননী সহজাশ্চ ৎৱযা সাকং কাঞ্চন কথাং কথযিতুং কামযমানা বহিস্তিষ্ঠন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","কিন্তু স তং প্রত্যৱদৎ, মম কা জননী? কে ৱা মম সহজাঃ? ");
INSERT INTO sanben_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","পশ্চাৎ শিষ্যান্ প্রতি করং প্রসার্য্য কথিতৱান্, পশ্য মম জননী মম সহজাশ্চৈতে; ");
INSERT INTO sanben_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","যঃ কশ্চিৎ মম স্ৱর্গস্থস্য পিতুরিষ্টং কর্ম্ম কুরুতে, সএৱ মম ভ্রাতা ভগিনী জননী চ| ");
INSERT INTO sanben_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","অপরঞ্চ তস্মিন্ দিনে যীশুঃ সদ্মনো গৎৱা সরিৎপতে রোধসি সমুপৱিৱেশ| ");
INSERT INTO sanben_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","তত্র তৎসন্নিধৌ বহুজনানাং নিৱহোপস্থিতেঃ স তরণিমারুহ্য সমুপাৱিশৎ, তেন মানৱা রোধসি স্থিতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","তদানীং স দৃষ্টান্তৈস্তান্ ইত্থং বহুশ উপদিষ্টৱান্| পশ্যত, কশ্চিৎ কৃষীৱলো বীজানি ৱপ্তুং বহির্জগাম, ");
INSERT INTO sanben_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","তস্য ৱপনকালে কতিপযবীজেষু মার্গপার্শ্ৱে পতিতেষু ৱিহগাস্তানি ভক্ষিতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","অপরং কতিপযবীজেষু স্তোকমৃদ্যুক্তপাষাণে পতিতেষু মৃদল্পৎৱাৎ তৎক্ষণাৎ তান্যঙ্কুরিতানি, ");
INSERT INTO sanben_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","কিন্তু রৱাৱুদিতে দগ্ধানি তেষাং মূলাপ্রৱিষ্টৎৱাৎ শুষ্কতাং গতানি চ| ");
INSERT INTO sanben_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","অপরং কতিপযবীজেষু কণ্টকানাং মধ্যে পতিতেষু কণ্টকান্যেধিৎৱা তানি জগ্রসুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","অপরঞ্চ কতিপযবীজানি উর্ৱ্ৱরাযাং পতিতানি; তেষাং মধ্যে কানিচিৎ শতগুণানি কানিচিৎ ষষ্টিগুণানি কানিচিৎ ত্রিংশগুংণানি ফলানি ফলিতৱন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","শ্রোতুং যস্য শ্রুতী আসাতে স শৃণুযাৎ| ");
INSERT INTO sanben_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","অনন্তরং শিষ্যৈরাগত্য সোঽপৃচ্ছ্যত, ভৱতা তেভ্যঃ কুতো দৃষ্টান্তকথা কথ্যতে? ");
INSERT INTO sanben_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ততঃ স প্রত্যৱদৎ, স্ৱর্গরাজ্যস্য নিগূঢাং কথাং ৱেদিতুং যুষ্মভ্যং সামর্থ্যমদাযি, কিন্তু তেভ্যো নাদাযি| ");
INSERT INTO sanben_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","যস্মাদ্ যস্যান্তিকে ৱর্দ্ধতে, তস্মাযেৱ দাযিষ্যতে, তস্মাৎ তস্য বাহুল্যং ভৱিষ্যতি, কিন্তু যস্যান্তিকে ন ৱর্দ্ধতে, তস্য যৎ কিঞ্চনাস্তে, তদপি তস্মাদ্ আদাযিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","তে পশ্যন্তোপি ন পশ্যন্তি, শৃণ্ৱন্তোপি ন শৃণ্ৱন্তি, বুধ্যমানা অপি ন বুধ্যন্তে চ, তস্মাৎ তেভ্যো দৃষ্টান্তকথা কথ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","যথা কর্ণৈঃ শ্রোষ্যথ যূযং ৱৈ কিন্তু যূযং ন ভোৎস্যথ| নেত্রৈর্দ্রক্ষ্যথ যূযঞ্চ পরিজ্ঞাতুং ন শক্ষ্যথ| তে মানুষা যথা নৈৱ পরিপশ্যন্তি লোচনৈঃ| কর্ণৈ র্যথা ন শৃণ্ৱন্তি ন বুধ্যন্তে চ মানসৈঃ| ৱ্যাৱর্ত্তিতেষু চিত্তেষু কালে কুত্রাপি তৈর্জনৈঃ| মত্তস্তে মনুজাঃ স্ৱস্থা যথা নৈৱ ভৱন্তি চ| তথা তেষাং মনুষ্যাণাং ক্রিযন্তে স্থূলবুদ্ধযঃ| বধিরীভূতকর্ণাশ্চ জাতাশ্চ মুদ্রিতা দৃশঃ| ");
INSERT INTO sanben_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","যদেতানি ৱচনানি যিশযিযভৱিষ্যদ্ৱাদিনা প্রোক্তানি তেষু তানি ফলন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","কিন্তু যুষ্মাকং নযনানি ধন্যানি, যস্মাৎ তানি ৱীক্ষন্তে; ধন্যাশ্চ যুষ্মাকং শব্দগ্রহাঃ, যস্মাৎ তৈরাকর্ণ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","মযা যূযং তথ্যং ৱচামি যুষ্মাভি র্যদ্যদ্ ৱীক্ষ্যতে, তদ্ বহৱো ভৱিষ্যদ্ৱাদিনো ধার্ম্মিকাশ্চ মানৱা দিদৃক্ষন্তোপি দ্রষ্টুং নালভন্ত, পুনশ্চ যূযং যদ্যৎ শৃণুথ, তৎ তে শুশ্রূষমাণা অপি শ্রোতুং নালভন্ত| ");
INSERT INTO sanben_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","কৃষীৱলীযদৃষ্টান্তস্যার্থং শৃণুত| ");
INSERT INTO sanben_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","মার্গপার্শ্ৱে বীজান্যুপ্তানি তস্যার্থ এষঃ, যদা কশ্চিৎ রাজ্যস্য কথাং নিশম্য ন বুধ্যতে, তদা পাপাত্মাগত্য তদীযমনস উপ্তাং কথাং হরন্ নযতি| ");
INSERT INTO sanben_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","অপরং পাষাণস্থলে বীজান্যুপ্তানি তস্যার্থ এষঃ; কশ্চিৎ কথাং শ্রুৎৱৈৱ হর্ষচিত্তেন গৃহ্লাতি, ");
INSERT INTO sanben_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","কিন্তু তস্য মনসি মূলাপ্রৱিষ্টৎৱাৎ স কিঞ্চিৎকালমাত্রং স্থিরস্তিষ্ঠতি; পশ্চাত তৎকথাকারণাৎ কোপি ক্লেস্তাডনা ৱা চেৎ জাযতে, তর্হি স তৎক্ষণাদ্ ৱিঘ্নমেতি| ");
INSERT INTO sanben_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","অপরং কণ্টকানাং মধ্যে বীজান্যুপ্তানি তদর্থ এষঃ; কেনচিৎ কথাযাং শ্রুতাযাং সাংসারিকচিন্তাভি র্ভ্রান্তিভিশ্চ সা গ্রস্যতে, তেন সা মা ৱিফলা ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","অপরম্ উর্ৱ্ৱরাযাং বীজান্যুপ্তানি তদর্থ এষঃ; যে তাং কথাং শ্রুৎৱা ৱুধ্যন্তে, তে ফলিতাঃ সন্তঃ কেচিৎ শতগুণানি কেচিত ষষ্টিগুণানি কেচিচ্চ ত্রিংশদ্গুণানি ফলানি জনযন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","অনন্তরং সোপরামেকাং দৃষ্টান্তকথামুপস্থাপ্য তেভ্যঃ কথযামাস; স্ৱর্গীযরাজ্যং তাদৃশেন কেনচিদ্ গৃহস্থেনোপমীযতে, যেন স্ৱীযক্ষেত্রে প্রশস্তবীজান্যৌপ্যন্ত| ");
INSERT INTO sanben_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","কিন্তু ক্ষণদাযাং সকললোকেষু সুপ্তেষু তস্য রিপুরাগত্য তেষাং গোধূমবীজানাং মধ্যে ৱন্যযৱমবীজান্যুপ্ত্ৱা ৱৱ্রাজ| ");
INSERT INTO sanben_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ততো যদা বীজেভ্যোঽঙ্করা জাযমানাঃ কণিশানি ঘৃতৱন্তঃ; তদা ৱন্যযৱসান্যপি দৃশ্যমানান্যভৱন্| ");
INSERT INTO sanben_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ততো গৃহস্থস্য দাসেযা আগম্য তস্মৈ কথযাঞ্চক্রুঃ, হে মহেচ্ছ, ভৱতা কিং ক্ষেত্রে ভদ্রবীজানি নৌপ্যন্ত? তথাৎৱে ৱন্যযৱসানি কৃত আযন্? ");
INSERT INTO sanben_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","তদানীং তেন তে প্রতিগদিতাঃ, কেনচিৎ রিপুণা কর্ম্মদমকারি| দাসেযাঃ কথযামাসুঃ, ৱযং গৎৱা তান্যুৎপায্য ক্ষিপামো ভৱতঃ কীদৃশীচ্ছা জাযতে? ");
INSERT INTO sanben_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","তেনাৱাদি, নহি, শঙ্কেঽহং ৱন্যযৱসোৎপাটনকালে যুষ্মাভিস্তৈঃ সাকং গোধূমা অপ্যুৎপাটিষ্যন্তে| ");
INSERT INTO sanben_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","অতঃ শ্স্যকর্ত্তনকালং যাৱদ্ উভযান্যপি সহ ৱর্দ্ধন্তাং, পশ্চাৎ কর্ত্তনকালে কর্ত্তকান্ ৱক্ষ্যামি, যূযমাদৌ ৱন্যযৱসানি সংগৃহ্য দাহযিতুং ৱীটিকা বদ্ৱ্ৱা স্থাপযত; কিন্তু সর্ৱ্ৱে গোধূমা যুষ্মাভি র্ভাণ্ডাগারং নীৎৱা স্থাপ্যন্তাম্| ");
INSERT INTO sanben_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","অনন্তরং সোপরামেকাং দৃষ্টান্তকথামুত্থাপ্য তেভ্যঃ কথিতৱান্ কশ্চিন্মনুজঃ সর্ষপবীজমেকং নীৎৱা স্ৱক্ষেত্র উৱাপ| ");
INSERT INTO sanben_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","সর্ষপবীজং সর্ৱ্ৱস্মাদ্ বীজাৎ ক্ষুদ্রমপি সদঙ্কুরিতং সর্ৱ্ৱস্মাৎ শাকাৎ বৃহদ্ ভৱতি; স তাদৃশস্তরু র্ভৱতি, যস্য শাখাসু নভসঃ খগা আগত্য নিৱসন্তি; স্ৱর্গীযরাজ্যং তাদৃশস্য সর্ষপৈকস্য সমম্| ");
INSERT INTO sanben_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","পুনরপি স উপমাকথামেকাং তেভ্যঃ কথযাঞ্চকার; কাচন যোষিৎ যৎ কিণ্ৱমাদায দ্রোণত্রযমিতগোধূমচূর্ণানাং মধ্যে সর্ৱ্ৱেষাং মিশ্রীভৱনপর্য্যন্তং সমাচ্ছাদ্য নিধত্তৱতী, তৎকিণ্ৱমিৱ স্ৱর্গরাজ্যং| ");
INSERT INTO sanben_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ইত্থং যীশু র্মনুজনিৱহানাং সন্নিধাৱুপমাকথাভিরেতান্যাখ্যানানি কথিতৱান্ উপমাং ৱিনা তেভ্যঃ কিমপি কথাং নাকথযৎ| ");
INSERT INTO sanben_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","এতেন দৃষ্টান্তীযেন ৱাক্যেন ৱ্যাদায ৱদনং নিজং| অহং প্রকাশযিষ্যামি গুপ্তৱাক্যং পুরাভৱং| যদেতদ্ৱচনং ভৱিষ্যদ্ৱাদিনা প্রোক্তমাসীৎ, তৎ সিদ্ধমভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","সর্ৱ্ৱান্ মনুজান্ ৱিসৃজ্য যীশৌ গৃহং প্রৱিষ্টে তচ্ছিষ্যা আগত্য যীশৱে কথিতৱন্তঃ, ক্ষেত্রস্য ৱন্যযৱসীযদৃষ্টান্তকথাম্ ভৱান অস্মান্ স্পষ্টীকৃত্য ৱদতু| ");
INSERT INTO sanben_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ততঃ স প্রত্যুৱাচ, যেন ভদ্রবীজান্যুপ্যন্তে স মনুজপুত্রঃ, ");
INSERT INTO sanben_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ক্ষেত্রং জগৎ, ভদ্রবীজানী রাজ্যস্য সন্তানাঃ, ");
INSERT INTO sanben_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ৱন্যযৱসানি পাপাত্মনঃ সন্তানাঃ| যেন রিপুণা তান্যুপ্তানি স শযতানঃ, কর্ত্তনসমযশ্চ জগতঃ শেষঃ, কর্ত্তকাঃ স্ৱর্গীযদূতাঃ| ");
INSERT INTO sanben_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","যথা ৱন্যযৱসানি সংগৃহ্য দাহ্যন্তে, তথা জগতঃ শেষে ভৱিষ্যতি; ");
INSERT INTO sanben_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","অর্থাৎ মনুজসুতঃ স্ৱাংযদূতান্ প্রেষযিষ্যতি, তেন তে চ তস্য রাজ্যাৎ সর্ৱ্ৱান্ ৱিঘ্নকারিণোঽধার্ম্মিকলোকাংশ্চ সংগৃহ্য ");
INSERT INTO sanben_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","যত্র রোদনং দন্তঘর্ষণঞ্চ ভৱতি, তত্রাগ্নিকুণ্ডে নিক্ষেপ্স্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","তদানীং ধার্ম্মিকলোকাঃ স্ৱেষাং পিতূ রাজ্যে ভাস্করইৱ তেজস্ৱিনো ভৱিষ্যন্তি| শ্রোতুং যস্য শ্রুতী আসাতে, ম শৃণুযাৎ| ");
INSERT INTO sanben_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","অপরঞ্চ ক্ষেত্রমধ্যে নিধিং পশ্যন্ যো গোপযতি, ততঃ পরং সানন্দো গৎৱা স্ৱীযসর্ৱ্ৱস্ৱং ৱিক্রীয ত্তক্ষেত্রং ক্রীণাতি, স ইৱ স্ৱর্গরাজ্যং| ");
INSERT INTO sanben_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","অন্যঞ্চ যো ৱণিক্ উত্তমাং মুক্তাং গৱেষযন্ ");
INSERT INTO sanben_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","মহার্ঘাং মুক্তাং ৱিলোক্য নিজসর্ৱ্ৱস্ৱং ৱিক্রীয তাং ক্রীণাতি, স ইৱ স্ৱর্গরাজ্যং| ");
INSERT INTO sanben_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","পুনশ্চ সমুদ্রো নিক্ষিপ্তঃ সর্ৱ্ৱপ্রকারমীনসংগ্রাহ্যানাযইৱ স্ৱর্গরাজ্যং| ");
INSERT INTO sanben_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","তস্মিন্ আনাযে পূর্ণে জনা যথা রোধস্যুত্তোল্য সমুপৱিশ্য প্রশস্তমীনান্ সংগ্রহ্য ভাজনেষু নিদধতে, কুৎসিতান্ নিক্ষিপন্তি; ");
INSERT INTO sanben_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","তথৈৱ জগতঃ শেষে ভৱিষ্যতি, ফলতঃ স্ৱর্গীযদূতা আগত্য পুণ্যৱজ্জনানাং মধ্যাৎ পাপিনঃ পৃথক্ কৃৎৱা ৱহ্নিকুণ্ডে নিক্ষেপ্স্যন্তি, ");
INSERT INTO sanben_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","তত্র রোদনং দন্তৈ র্দন্তঘর্ষণঞ্চ ভৱিষ্যতঃ| ");
INSERT INTO sanben_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","যীশুনা তে পৃষ্টা যুষ্মাভিঃ কিমেতান্যাখ্যানান্যবুধ্যন্ত? তদা তে প্রত্যৱদন্, সত্যং প্রভো| ");
INSERT INTO sanben_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","তদানীং স কথিতৱান্, নিজভাণ্ডাগারাৎ নৱীনপুরাতনানি ৱস্তূনি নির্গমযতি যো গৃহস্থঃ স ইৱ স্ৱর্গরাজ্যমধি শিক্ষিতাঃ স্ৱর্ৱ উপদেষ্টারঃ| ");
INSERT INTO sanben_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","অনন্তরং যীশুরেতাঃ সর্ৱ্ৱা দৃষ্টান্তকথাঃ সমাপ্য তস্মাৎ স্থানাৎ প্রতস্থে| অপরং স্ৱদেশমাগত্য জনান্ ভজনভৱন উপদিষ্টৱান্; ");
INSERT INTO sanben_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","তে ৱিস্মযং গৎৱা কথিতৱন্ত এতস্যৈতাদৃশং জ্ঞানম্ আশ্চর্য্যং কর্ম্ম চ কস্মাদ্ অজাযত? ");
INSERT INTO sanben_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","কিমযং সূত্রধারস্য পুত্রো নহি? এতস্য মাতু র্নাম চ কিং মরিযম্ নহি? যাকুব্-যূষফ্-শিমোন্-যিহূদাশ্চ কিমেতস্য ভ্রাতরো নহি? ");
INSERT INTO sanben_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","এতস্য ভগিন্যশ্চ কিমস্মাকং মধ্যে ন সন্তি? তর্হি কস্মাদযমেতানি লব্ধৱান্? ইত্থং স তেষাং ৱিঘ্নরূপো বভূৱ; ");
INSERT INTO sanben_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ততো যীশুনা নিগদিতং স্ৱদেশীযজনানাং মধ্যং ৱিনা ভৱিষ্যদ্ৱাদী কুত্রাপ্যন্যত্র নাসম্মান্যো ভৱতী| ");
INSERT INTO sanben_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","তেষামৱিশ্ৱাসহেতোঃ স তত্র স্থানে বহ্ৱাশ্চর্য্যকর্ম্মাণি ন কৃতৱান্| ");
INSERT INTO sanben_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","তদানীং রাজা হেরোদ্ যীশো র্যশঃ শ্রুৎৱা নিজদাসেযান্ জগাদ্, ");
INSERT INTO sanben_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","এষ মজ্জযিতা যোহন্, প্রমিতেভযস্তস্যোত্থানাৎ তেনেত্থমদ্ভুতং কর্ম্ম প্রকাশ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","পুরা হেরোদ্ নিজভ্রাতু: ফিলিপো জাযাযা হেরোদীযাযা অনুরোধাদ্ যোহনং ধারযিৎৱা বদ্ধা কারাযাং স্থাপিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","যতো যোহন্ উক্তৱান্, এৎসযাঃ সংগ্রহো ভৱতো নোচিতঃ| ");
INSERT INTO sanben_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","তস্মাৎ নৃপতিস্তং হন্তুমিচ্ছন্নপি লোকেভ্যো ৱিভযাঞ্চকার; যতঃ সর্ৱ্ৱে যোহনং ভৱিষ্যদ্ৱাদিনং মেনিরে| ");
INSERT INTO sanben_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","কিন্তু হেরোদো জন্মাহীযমহ উপস্থিতে হেরোদীযাযা দুহিতা তেষাং সমক্ষং নৃতিৎৱা হেরোদমপ্রীণ্যৎ| ");
INSERT INTO sanben_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","তস্মাৎ ভূপতিঃ শপথং কুর্ৱ্ৱন্ ইতি প্রত্যজ্ঞাসীৎ, ৎৱযা যদ্ যাচ্যতে, তদেৱাহং দাস্যামি| ");
INSERT INTO sanben_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","সা কুমারী স্ৱীযমাতুঃ শিক্ষাং লব্ধা বভাষে, মজ্জযিতুর্যোহন উত্তমাঙ্গং ভাজনে সমানীয মহ্যং ৱিশ্রাণয| ");
INSERT INTO sanben_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ততো রাজা শুশোচ, কিন্তু ভোজনাযোপৱিশতাং সঙ্গিনাং স্ৱকৃতশপথস্য চানুরোধাৎ তৎ প্রদাতুম আদিদেশ| ");
INSERT INTO sanben_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","পশ্চাৎ কারাং প্রতি নরং প্রহিত্য যোহন উত্তমাঙ্গং ছিত্ত্ৱা ");
INSERT INTO sanben_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","তৎ ভাজন আনায্য তস্যৈ কুমার্য্যৈ ৱ্যশ্রাণযৎ, ততঃ সা স্ৱজনন্যাঃ সমীপং তন্নিনায| ");
INSERT INTO sanben_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","পশ্চাৎ যোহনঃ শিষ্যা আগত্য কাযং নীৎৱা শ্মশানে স্থাপযামাসুস্ততো যীশোঃ সন্নিধিং ৱ্রজিৎৱা তদ্ৱার্ত্তাং বভাষিরে| ");
INSERT INTO sanben_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","অনন্তরং যীশুরিতি নিশভ্য নাৱা নির্জনস্থানম্ একাকী গতৱান্, পশ্চাৎ মানৱাস্তৎ শ্রুৎৱা নানানগরেভ্য আগত্য পদৈস্তৎপশ্চাদ্ ঈযুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","তদানীং যীশু র্বহিরাগত্য মহান্তং জননিৱহং নিরীক্ষ্য তেষু কারুণিকঃ মন্ তেষাং পীডিতজনান্ নিরামযান্ চকার| ");
INSERT INTO sanben_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ততঃ পরং সন্ধ্যাযাং শিষ্যাস্তদন্তিকমাগত্য কথযাঞ্চক্রুঃ, ইদং নির্জনস্থানং ৱেলাপ্যৱসন্না; তস্মাৎ মনুজান্ স্ৱস্ৱগ্রামং গন্তুং স্ৱার্থং ভক্ষ্যাণি ক্রেতুঞ্চ ভৱান্ তান্ ৱিসৃজতু| ");
INSERT INTO sanben_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","কিন্তু যীশুস্তানৱাদীৎ, তেষাং গমনে প্রযোজনং নাস্তি, যূযমেৱ তান্ ভোজযত| ");
INSERT INTO sanben_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","তদা তে প্রত্যৱদন্, অস্মাকমত্র পূপপঞ্চকং মীনদ্ৱযঞ্চাস্তে| ");
INSERT INTO sanben_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","তদানীং তেনোক্তং তানি মদন্তিকমানযত| ");
INSERT INTO sanben_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","অনন্তরং স মনুজান্ যৱসোপর্য্যুপৱেষ্টুম্ আজ্ঞাপযামাস; অপর তৎ পূপপঞ্চকং মীনদ্ৱযঞ্চ গৃহ্লন্ স্ৱর্গং প্রতি নিরীক্ষ্যেশ্ৱরীযগুণান্ অনূদ্য ভংক্ত্ৱা শিষ্যেভ্যো দত্তৱান্, শিষ্যাশ্চ লোকেভ্যো দদুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ততঃ সর্ৱ্ৱে ভুক্ত্ৱা পরিতৃপ্তৱন্তঃ, ততস্তদৱশিষ্টভক্ষ্যৈঃ পূর্ণান্ দ্ৱাদশডলকান্ গৃহীতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","তে ভোক্তারঃ স্ত্রীর্বালকাংশ্চ ৱিহায প্রাযেণ পঞ্চ সহস্রাণি পুমাংস আসন্| ");
INSERT INTO sanben_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","তদনন্তরং যীশু র্লোকানাং ৱিসর্জনকালে শিষ্যান্ তরণিমারোঢুং স্ৱাগ্রে পারং যাতুঞ্চ গাঢমাদিষ্টৱান্| ");
INSERT INTO sanben_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ততো লোকেষু ৱিসৃষ্টেষু স ৱিৱিক্তে প্রার্থযিতুং গিরিমেকং গৎৱা সন্ধ্যাং যাৱৎ তত্রৈকাকী স্থিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","কিন্তু তদানীং সম্মুখৱাতৎৱাৎ সরিৎপতে র্মধ্যে তরঙ্গৈস্তরণির্দোলাযমানাভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","তদা স যামিন্যাশ্চতুর্থপ্রহরে পদ্ভ্যাং ৱ্রজন্ তেষামন্তিকং গতৱান্| ");
INSERT INTO sanben_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","কিন্তু শিষ্যাস্তং সাগরোপরি ৱ্রজন্তং ৱিলোক্য সমুদ্ৱিগ্না জগদুঃ, এষ ভূত ইতি শঙ্কমানা উচ্চৈঃ শব্দাযাঞ্চক্রিরে চ| ");
INSERT INTO sanben_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","তদৈৱ যীশুস্তানৱদৎ, সুস্থিরা ভৱত, মা ভৈষ্ট, এষোঽহম্| ");
INSERT INTO sanben_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","ততঃ পিতর ইত্যুক্তৱান্, হে প্রভো, যদি ভৱানেৱ, তর্হি মাং ভৱৎসমীপং যাতুমাজ্ঞাপযতু| ");
INSERT INTO sanben_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ততঃ তেনাদিষ্টঃ পিতরস্তরণিতোঽৱরুহ্য যীশেाরন্তিকং প্রাপ্তুং তোযোপরি ৱৱ্রাজ| ");
INSERT INTO sanben_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","কিন্তু প্রচণ্ডং পৱনং ৱিলোক্য ভযাৎ তোযে মংক্তুম্ আরেভে, তস্মাদ্ উচ্চৈঃ শব্দাযমানঃ কথিতৱান্, হে প্রভো, মামৱতু| ");
INSERT INTO sanben_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","যীশুস্তৎক্ষণাৎ করং প্রসার্য্য তং ধরন্ উক্তৱান্, হ স্তোকপ্রত্যযিন্ ৎৱং কুতঃ সমশেথাঃ? ");
INSERT INTO sanben_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","অনন্তরং তযোস্তরণিমারূঢযোঃ পৱনো নিৱৱৃতে| ");
INSERT INTO sanben_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","তদানীং যে তরণ্যামাসন্, ত আগত্য তং প্রণভ্য কথিতৱন্তঃ, যথার্থস্ত্ৱমেৱেশ্ৱরসুতঃ| ");
INSERT INTO sanben_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","অনন্তরং পারং প্রাপ্য তে গিনেষরন্নামকং নগরমুপতস্থুঃ, ");
INSERT INTO sanben_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","তদা তত্রত্যা জনা যীশুং পরিচীয তদ্দেশ্স্য চতুর্দিশো ৱার্ত্তাং প্রহিত্য যত্র যাৱন্তঃ পীডিতা আসন্, তাৱতএৱ তদন্তিকমানযামাসুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","অপরং তদীযৱসনস্য গ্রন্থিমাত্রং স্প্রষ্টুং ৱিনীয যাৱন্তো জনাস্তৎ স্পর্শং চক্রিরে, তে সর্ৱ্ৱএৱ নিরামযা বভূৱুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","অপরং যিরূশালম্নগরীযাঃ কতিপযা অধ্যাপকাঃ ফিরূশিনশ্চ যীশোঃ সমীপমাগত্য কথযামাসুঃ, ");
INSERT INTO sanben_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","তৱ শিষ্যাঃ কিমর্থম্ অপ্রক্ষালিতকরৈ র্ভক্ষিৎৱা পরম্পরাগতং প্রাচীনানাং ৱ্যৱহারং লঙ্ৱন্তে? ");
INSERT INTO sanben_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ততো যীশুঃ প্রত্যুৱাচ, যূযং পরম্পরাগতাচারেণ কুত ঈশ্ৱরাজ্ঞাং লঙ্ৱধ্ৱে| ");
INSERT INTO sanben_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ঈশ্ৱর ইত্যাজ্ঞাপযৎ, ৎৱং নিজপিতরৌ সংমন্যেথাঃ, যেন চ নিজপিতরৌ নিন্দ্যেতে, স নিশ্চিতং ম্রিযেত; ");
INSERT INTO sanben_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","কিন্তু যূযং ৱদথ, যঃ স্ৱজনকং স্ৱজননীং ৱা ৱাক্যমিদং ৱদতি, যুৱাং মত্তো যল্লভেথে, তৎ ন্যৱিদ্যত, ");
INSERT INTO sanben_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","স নিজপিতরৌ পুন র্ন সংমংস্যতে| ইত্থং যূযং পরম্পরাগতেন স্ৱেষামাচারেণেশ্ৱরীযাজ্ঞাং লুম্পথ| ");
INSERT INTO sanben_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","রে কপটিনঃ সর্ৱ্ৱে যিশযিযো যুষ্মানধি ভৱিষ্যদ্ৱচনান্যেতানি সম্যগ্ উক্তৱান্| ");
INSERT INTO sanben_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","ৱদনৈ র্মনুজা এতে সমাযান্তি মদন্তিকং| তথাধরৈ র্মদীযঞ্চ মানং কুর্ৱ্ৱন্তি তে নরাঃ| ");
INSERT INTO sanben_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","কিন্তু তেষাং মনো মত্তো ৱিদূরএৱ তিষ্ঠতি| শিক্ষযন্তো ৱিধীন্ ন্রাজ্ঞা ভজন্তে মাং মুধৈৱ তে| ");
INSERT INTO sanben_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ততো যীশু র্লোকান্ আহূয প্রোক্তৱান্, যূযং শ্রুৎৱা বুধ্যধ্বং| ");
INSERT INTO sanben_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","যন্মুখং প্রৱিশতি, তৎ মনুজম্ অমেধ্যং ন করোতি, কিন্তু যদাস্যাৎ নির্গচ্ছতি, তদেৱ মানুষমমেধ্যী করোতী| ");
INSERT INTO sanben_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","তদানীং শিষ্যা আগত্য তস্মৈ কথযাঞ্চক্রুঃ, এতাং কথাং শ্রুৎৱা ফিরূশিনো ৱ্যরজ্যন্ত, তৎ কিং ভৱতা জ্ঞাযতে? ");
INSERT INTO sanben_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","স প্রত্যৱদৎ, মম স্ৱর্গস্থঃ পিতা যং কঞ্চিদঙ্কুরং নারোপযৎ, স উৎপাৱ্দ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","তে তিষ্ঠন্তু, তে অন্ধমনুজানাম্ অন্ধমার্গদর্শকা এৱ; যদ্যন্ধোঽন্ধং পন্থানং দর্শযতি, তর্হ্যুভৌ গর্ত্তে পততঃ| ");
INSERT INTO sanben_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","তদা পিতরস্তং প্রত্যৱদৎ, দৃষ্টান্তমিমমস্মান্ বোধযতু| ");
INSERT INTO sanben_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","যীশুনা প্রোক্তং, যূযমদ্য যাৱৎ কিমবোধাঃ স্থ? ");
INSERT INTO sanben_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","কথামিমাং কিং ন বুধ্যধ্বে ? যদাস্যং প্রেৱিশতি, তদ্ উদরে পতন্ বহির্নির্যাতি, ");
INSERT INTO sanben_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","কিন্ত্ৱাস্যাদ্ যন্নির্যাতি, তদ্ অন্তঃকরণাৎ নির্যাতৎৱাৎ মনুজমমেধ্যং করোতি| ");
INSERT INTO sanben_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","যতোঽন্তঃকরণাৎ কুচিন্তা বধঃ পারদারিকতা ৱেশ্যাগমনং চৈর্য্যং মিথ্যাসাক্ষ্যম্ ঈশ্ৱরনিন্দা চৈতানি সর্ৱ্ৱাণি নির্য্যান্তি| ");
INSERT INTO sanben_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","এতানি মনুষ্যমপৱিত্রী কুর্ৱ্ৱন্তি কিন্ত্ৱপ্রক্ষালিতকরেণ ভোজনং মনুজমমেধ্যং ন করোতি| ");
INSERT INTO sanben_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","অনন্তরং যীশুস্তস্মাৎ স্থানাৎ প্রস্থায সোরসীদোন্নগরযোঃ সীমামুপতস্যৌ| ");
INSERT INTO sanben_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","তদা তৎসীমাতঃ কাচিৎ কিনানীযা যোষিদ্ আগত্য তমুচ্চৈরুৱাচ, হে প্রভো দাযূদঃ সন্তান, মমৈকা দুহিতাস্তে সা ভূতগ্রস্তা সতী মহাক্লেশং প্রাপ্নোতি মম দযস্ৱ| ");
INSERT INTO sanben_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","কিন্তু যীশুস্তাং কিমপি নোক্তৱান্, ততঃ শিষ্যা আগত্য তং নিৱেদযামাসুঃ, এষা যোষিদ্ অস্মাকং পশ্চাদ্ উচ্চৈরাহূযাগচ্ছতি, এনাং ৱিসৃজতু| ");
INSERT INTO sanben_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","তদা স প্রত্যৱদৎ, ইস্রাযেল্গোত্রস্য হারিতমেষান্ ৱিনা কস্যাপ্যন্যস্য সমীপং নাহং প্রেষিতোস্মি| ");
INSERT INTO sanben_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","ততঃ সা নারীসমাগত্য তং প্রণম্য জগাদ, হে প্রভো মামুপকুরু| ");
INSERT INTO sanben_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","স উক্তৱান্, বালকানাং ভক্ষ্যমাদায সারমেযেভ্যো দানং নোচিতং| ");
INSERT INTO sanben_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","তদা সা বভাষে, হে প্রভো, তৎ সত্যং, তথাপি প্রভো র্ভঞ্চাদ্ যদুচ্ছিষ্টং পততি, তৎ সারমেযাঃ খাদন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ততো যীশুঃ প্রত্যৱদৎ, হে যোষিৎ, তৱ ৱিশ্ৱাসো মহান্ তস্মাৎ তৱ মনোভিলষিতং সিদ্য্যতু, তেন তস্যাঃ কন্যা তস্মিন্নেৱ দণ্ডে নিরামযাভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","অনন্তরং যীশস্তস্মাৎ স্থানাৎ প্রস্থায গালীল্সাগরস্য সন্নিধিমাগত্য ধরাধরমারুহ্য তত্রোপৱিৱেশ| ");
INSERT INTO sanben_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","পশ্চাৎ জননিৱহো বহূন্ খঞ্চান্ধমূকশুষ্ককরমানুষান্ আদায যীশোঃ সমীপমাগত্য তচ্চরণান্তিকে স্থাপযামাসুঃ, ততঃ সা তান্ নিরামযান্ অকরোৎ| ");
INSERT INTO sanben_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ইত্থং মূকা ৱাক্যং ৱদন্তি, শুষ্ককরাঃ স্ৱাস্থ্যমাযান্তি, পঙ্গৱো গচ্ছন্তি, অন্ধা ৱীক্ষন্তে, ইতি ৱিলোক্য লোকা ৱিস্মযং মন্যমানা ইস্রাযেল ঈশ্ৱরং ধন্যং বভাষিরে| ");
INSERT INTO sanben_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","তদানীং যীশুঃ স্ৱশিষ্যান্ আহূয গদিতৱান্, এতজ্জননিৱহেষু মম দযা জাযতে, এতে দিনত্রযং মযা সাকং সন্তি, এষাং ভক্ষ্যৱস্তু চ কঞ্চিদপি নাস্তি, তস্মাদহমেতানকৃতাহারান্ ন ৱিস্রক্ষ্যামি, তথাৎৱে ৱর্ত্মমধ্যে ক্লাম্যেষুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","তদা শিষ্যা ঊচুঃ, এতস্মিন্ প্রান্তরমধ্য এতাৱতো মর্ত্যান্ তর্পযিতুং ৱযং কুত্র পূপান্ প্রাপ্স্যামঃ? ");
INSERT INTO sanben_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","যীশুরপৃচ্ছৎ, যুষ্মাকং নিকটে কতি পূপা আসতে? ত ঊচুঃ, সপ্তপূপা অল্পাঃ ক্ষুদ্রমীনাশ্চ সন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","তদানীং স লোকনিৱহং ভূমাৱুপৱেষ্টুম্ আদিশ্য ");
INSERT INTO sanben_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","তান্ সপ্তপূপান্ মীনাংশ্চ গৃহ্লন্ ঈশ্ৱরীযগুণান্ অনূদ্য ভংক্ত্ৱা শিষ্যেভ্যো দদৌ, শিষ্যা লোকেভ্যো দদুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ততঃ সর্ৱ্ৱে ভুক্ত্ৱা তৃপ্তৱন্তঃ; তদৱশিষ্টভক্ষ্যেণ সপ্তডলকান্ পরিপূর্য্য সংজগৃহুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","তে ভোক্তারো যোষিতো বালকাংশ্চ ৱিহায প্রাযেণ চতুঃসহস্রাণি পুরুষা আসন্| ");
INSERT INTO sanben_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","ততঃ পরং স জননিৱহং ৱিসৃজ্য তরিমারুহ্য মগ্দলাপ্রদেশং গতৱান্| ");
INSERT INTO sanben_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","তদানীং ফিরূশিনঃ সিদূকিনশ্চাগত্য তং পরীক্ষিতুং নভমীযং কিঞ্চন লক্ষ্ম দর্শযিতুং তস্মৈ নিৱেদযামাসুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ততঃ স উক্তৱান্, সন্ধ্যাযাং নভসো রক্তৎৱাদ্ যূযং ৱদথ, শ্ৱো নির্ম্মলং দিনং ভৱিষ্যতি; ");
INSERT INTO sanben_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","প্রাতঃকালে চ নভসো রক্তৎৱাৎ মলিনৎৱাঞ্চ ৱদথ, ঝঞ্ভ্শদ্য ভৱিষ্যতি| হে কপটিনো যদি যূযম্ অন্তরীক্ষস্য লক্ষ্ম বোদ্ধুং শক্নুথ, তর্হি কালস্যৈতস্য লক্ষ্ম কথং বোদ্ধুং ন শক্নুথ? ");
INSERT INTO sanben_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","এতৎকালস্য দুষ্টো ৱ্যভিচারী চ ৱংশো লক্ষ্ম গৱেষযতি, কিন্তু যূনসো ভৱিষ্যদ্ৱাদিনো লক্ষ্ম ৱিনান্যৎ কিমপি লক্ষ্ম তান্ ন দর্শযিয্যতে| তদানীং স তান্ ৱিহায প্রতস্থে| ");
INSERT INTO sanben_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","অনন্তরমন্যপারগমনকালে তস্য শিষ্যাঃ পূপমানেতুং ৱিস্মৃতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","যীশুস্তানৱাদীৎ, যূযং ফিরূশিনাং সিদূকিনাঞ্চ কিণ্ৱং প্রতি সাৱধানাঃ সতর্কাশ্চ ভৱত| ");
INSERT INTO sanben_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","তেন তে পরস্পরং ৱিৱিচ্য কথযিতুমারেভিরে, ৱযং পূপানানেতুং ৱিস্মৃতৱন্ত এতৎকারণাদ্ ইতি কথযতি| ");
INSERT INTO sanben_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","কিন্তু যীশুস্তদ্ৱিজ্ঞায তানৱোচৎ, হে স্তোকৱিশ্ৱাসিনো যূযং পূপানানযনমধি কুতঃ পরস্পরমেতদ্ ৱিৱিংক্য? ");
INSERT INTO sanben_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","যুষ্মাভিঃ কিমদ্যাপি ন জ্ঞাযতে? পঞ্চভিঃ পূপৈঃ পঞ্চসহস্রপুরুষেষু ভোজিতেষু ভক্ষ্যোচ্ছিষ্টপূর্ণান্ কতি ডলকান্ সমগৃহ্লীতং; ");
INSERT INTO sanben_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","তথা সপ্তভিঃ পূপৈশ্চতুঃসহস্রপুরুষেষু ভেজিতেষু কতি ডলকান্ সমগৃহ্লীত, তৎ কিং যুষ্মাভির্ন স্মর্য্যতে? ");
INSERT INTO sanben_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","তস্মাৎ ফিরূশিনাং সিদূকিনাঞ্চ কিণ্ৱং প্রতি সাৱধানাস্তিষ্ঠত, কথামিমাম্ অহং পূপানধি নাকথযং, এতদ্ যূযং কুতো ন বুধ্যধ্ৱে? ");
INSERT INTO sanben_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","তদানীং পূপকিণ্ৱং প্রতি সাৱধানাস্তিষ্ঠতেতি নোক্ত্ৱা ফিরূশিনাং সিদূকিনাঞ্চ উপদেশং প্রতি সাৱধানাস্তিষ্ঠতেতি কথিতৱান্, ইতি তৈরবোধি| ");
INSERT INTO sanben_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","অপরঞ্চ যীশুঃ কৈসরিযা-ফিলিপিপ্রদেশমাগত্য শিষ্যান্ অপৃচ্ছৎ, যোঽহং মনুজসুতঃ সোঽহং কঃ? লোকৈরহং কিমুচ্যে? ");
INSERT INTO sanben_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","তদানীং তে কথিতৱন্তঃ, কেচিদ্ ৱদন্তি ৎৱং মজ্জযিতা যোহন্, কেচিদ্ৱদন্তি, ৎৱম্ এলিযঃ, কেচিচ্চ ৱদন্তি, ৎৱং যিরিমিযো ৱা কশ্চিদ্ ভৱিষ্যদ্ৱাদীতি| ");
INSERT INTO sanben_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","পশ্চাৎ স তান্ পপ্রচ্ছ, যূযং মাং কং ৱদথ? ততঃ শিমোন্ পিতর উৱাচ, ");
INSERT INTO sanben_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ৎৱমমরেশ্ৱরস্যাভিষিক্তপুত্রঃ| ");
INSERT INTO sanben_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ততো যীশুঃ কথিতৱান্, হে যূনসঃ পুত্র শিমোন্ ৎৱং ধন্যঃ; যতঃ কোপি অনুজস্ত্ৱয্যেতজ্জ্ঞানং নোদপাদযৎ, কিন্তু মম স্ৱর্গস্যঃ পিতোদপাদযৎ| ");
INSERT INTO sanben_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","অতোঽহং ৎৱাং ৱদামি, ৎৱং পিতরঃ (প্রস্তরঃ) অহঞ্চ তস্য প্রস্তরস্যোপরি স্ৱমণ্ডলীং নির্ম্মাস্যামি, তেন নিরযো বলাৎ তাং পরাজেতুং ন শক্ষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","অহং তুভ্যং স্ৱর্গীযরাজ্যস্য কুঞ্জিকাং দাস্যামি, তেন যৎ কিঞ্চন ৎৱং পৃথিৱ্যাং ভংৎস্যসি তৎস্ৱর্গে ভংৎস্যতে, যচ্চ কিঞ্চন মহ্যাং মোক্ষ্যসি তৎ স্ৱর্গে মোক্ষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","পশ্চাৎ স শিষ্যানাদিশৎ, অহমভিষিক্তো যীশুরিতি কথাং কস্মৈচিদপি যূযং মা কথযত| ");
INSERT INTO sanben_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","অন্যঞ্চ যিরূশালম্নগরং গৎৱা প্রাচীনলোকেভ্যঃ প্রধানযাজকেভ্য উপাধ্যাযেভ্যশ্চ বহুদুঃখভোগস্তৈ র্হতৎৱং তৃতীযদিনে পুনরুত্থানঞ্চ মমাৱশ্যকম্ এতাঃ কথা যীশুস্তৎকালমারভ্য শিষ্যান্ জ্ঞাপযিতুম্ আরব্ধৱান্| ");
INSERT INTO sanben_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","তদানীং পিতরস্তস্য করং ঘৃৎৱা তর্জযিৎৱা কথযিতুমারব্ধৱান্, হে প্রভো, তৎ ৎৱত্তো দূরং যাতু, ৎৱাং প্রতি কদাপি ন ঘটিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","কিন্তু স ৱদনং পরাৱর্ত্য পিতরং জগাদ, হে ৱিঘ্নকারিন্, মৎসম্মুখাদ্ দূরীভৱ, ৎৱং মাং বাধসে, ঈশ্ৱরীযকার্য্যাৎ মানুষীযকার্য্যং তুভ্যং রোচতে| ");
INSERT INTO sanben_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","অনন্তরং যীশুঃ স্ৱীযশিষ্যান্ উক্তৱান্ যঃ কশ্চিৎ মম পশ্চাদ্গামী ভৱিতুম্ ইচ্ছতি, স স্ৱং দাম্যতু, তথা স্ৱক্রুশং গৃহ্লন্ মৎপশ্চাদাযাতু| ");
INSERT INTO sanben_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","যতো যঃ প্রাণান্ রক্ষিতুমিচ্ছতি, স তান্ হারযিষ্যতি, কিন্তু যো মদর্থং নিজপ্রাণান্ হারযতি, স তান্ প্রাপ্স্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","মানুষো যদি সর্ৱ্ৱং জগৎ লভতে নিজপ্রণান্ হারযতি, তর্হি তস্য কো লাভঃ? মনুজো নিজপ্রাণানাং ৱিনিমযেন ৱা কিং দাতুং শক্নোতি? ");
INSERT INTO sanben_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","মনুজসুতঃ স্ৱদূতৈঃ সাকং পিতুঃ প্রভাৱেণাগমিষ্যতি; তদা প্রতিমনুজং স্ৱস্ৱকর্ম্মানুসারাৎ ফলং দাস্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","অহং যুষ্মান্ তথ্যং ৱচ্মি, সরাজ্যং মনুজসুতম্ আগতং ন পশ্যন্তো মৃত্যুং ন স্ৱাদিষ্যন্তি, এতাদৃশাঃ কতিপযজনা অত্রাপি দণ্ডাযমানাঃ সন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","অনন্তরং ষড্দিনেভ্যঃ পরং যীশুঃ পিতরং যাকূবং তৎসহজং যোহনঞ্চ গৃহ্লন্ উচ্চাদ্রে র্ৱিৱিক্তস্থানম্ আগত্য তেষাং সমক্ষং রূপমন্যৎ দধার| ");
INSERT INTO sanben_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","তেন তদাস্যং তেজস্ৱি, তদাভরণম্ আলোকৱৎ পাণ্ডরমভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","অন্যচ্চ তেন সাকং সংলপন্তৌ মূসা এলিযশ্চ তেভ্যো দর্শনং দদতুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","তদানীং পিতরো যীশুং জগাদ, হে প্রভো স্থিতিরত্রাস্মাকং শুভা, যদি ভৱতানুমন্যতে, তর্হি ভৱদর্থমেকং মূসার্থমেকম্ এলিযার্থঞ্চৈকম্ ইতি ত্রীণি দূষ্যাণি নির্ম্মম| ");
INSERT INTO sanben_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","এতৎকথনকাল এক উজ্জৱলঃ পযোদস্তেষামুপরি ছাযাং কৃতৱান্, ৱারিদাদ্ এষা নভসীযা ৱাগ্ বভূৱ, মমাযং প্রিযঃ পুত্রঃ, অস্মিন্ মম মহাসন্তোষ এতস্য ৱাক্যং যূযং নিশামযত| ");
INSERT INTO sanben_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","কিন্তু ৱাচমেতাং শৃণ্ৱন্তএৱ শিষ্যা মৃশং শঙ্কমানা ন্যুব্জা ন্যপতন্| ");
INSERT INTO sanben_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","তদা যীশুরাগত্য তেষাং গাত্রাণি স্পৃশন্ উৱাচ, উত্তিষ্ঠত, মা ভৈষ্ট| ");
INSERT INTO sanben_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","তদানীং নেত্রাণ্যুন্মীল্য যীশুং ৱিনা কমপি ন দদৃশুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ততঃ পরম্ অদ্রেরৱরোহণকালে যীশুস্তান্ ইত্যাদিদেশ, মনুজসুতস্য মৃতানাং মধ্যাদুত্থানং যাৱন্ন জাযতে, তাৱৎ যুষ্মাভিরেতদ্দর্শনং কস্মৈচিদপি ন কথযিতৱ্যং| ");
INSERT INTO sanben_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","তদা শিষ্যাস্তং পপ্রচ্ছুঃ, প্রথমম্ এলিয আযাস্যতীতি কুত উপাধ্যাযৈরুচ্যতে? ");
INSERT INTO sanben_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ততো যীশুঃ প্রত্যৱাদীৎ, এলিযঃ প্রাগেত্য সর্ৱ্ৱাণি সাধযিষ্যতীতি সত্যং, ");
INSERT INTO sanben_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","কিন্ত্ৱহং যুষ্মান্ ৱচ্মি, এলিয এত্য গতঃ, তে তমপরিচিত্য তস্মিন্ যথেচ্ছং ৱ্যৱজহুঃ; মনুজসুতেনাপি তেষামন্তিকে তাদৃগ্ দুঃখং ভোক্তৱ্যং| ");
INSERT INTO sanben_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","তদানীং স মজ্জযিতারং যোহনমধি কথামেতাং ৱ্যাহৃতৱান্, ইত্থং তচ্ছিষ্যা বুবুধিরে| ");
INSERT INTO sanben_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","পশ্চাৎ তেষু জননিৱহস্যান্তিকমাগতেষু কশ্চিৎ মনুজস্তদন্তিকমেত্য জানূনী পাতযিৎৱা কথিতৱান্, ");
INSERT INTO sanben_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","হে প্রভো, মৎপুত্রং প্রতি কৃপাং ৱিদধাতু, সোপস্মারামযেন ভৃশং ৱ্যথিতঃ সন্ পুনঃ পুন র্ৱহ্নৌ মুহু র্জলমধ্যে পততি| ");
INSERT INTO sanben_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","তস্মাদ্ ভৱতঃ শিষ্যাণাং সমীপে তমানযং কিন্তু তে তং স্ৱাস্থং কর্ত্তুং ন শক্তাঃ| ");
INSERT INTO sanben_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","তদা যীশুঃ কথিতৱান্ রে অৱিশ্ৱাসিনঃ, রে ৱিপথগামিনঃ, পুনঃ কতিকালান্ অহং যুষ্মাকং সন্নিধৌ স্থাস্যামি? কতিকালান্ ৱা যুষ্মান্ সহিষ্যে? তমত্র মমান্তিকমানযত| ");
INSERT INTO sanben_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","পশ্চাদ্ যীশুনা তর্জতএৱ স ভূতস্তং ৱিহায গতৱান্, তদ্দণ্ডএৱ স বালকো নিরামযোঽভূৎ| ");
INSERT INTO sanben_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ততঃ শিষ্যা গুপ্তং যীশুমুপাগত্য বভাষিরে, কুতো ৱযং তং ভূতং ত্যাজযিতুং ন শক্তাঃ? ");
INSERT INTO sanben_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","যীশুনা তে প্রোক্তাঃ, যুষ্মাকমপ্রত্যযাৎ; ");
INSERT INTO sanben_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","যুষ্মানহং তথ্যং ৱচ্মি যদি যুষ্মাকং সর্ষপৈকমাত্রোপি ৱিশ্ৱাসো জাযতে, তর্হি যুষ্মাভিরস্মিন্ শৈলে ৎৱমিতঃ স্থানাৎ তৎ স্থানং যাহীতি ব্রূতে স তদৈৱ চলিষ্যতি, যুষ্মাকং কিমপ্যসাধ্যঞ্চ কর্ম্ম ন স্থাস্যাতি| কিন্তু প্রার্থনোপৱাসৌ ৱিনৈতাদৃশো ভূতো ন ত্যাজ্যেত| ");
INSERT INTO sanben_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","অপরং তেষাং গালীল্প্রদেশে ভ্রমণকালে যীশুনা তে গদিতাঃ, মনুজসুতো জনানাং করেষু সমর্পযিষ্যতে তৈ র্হনিষ্যতে চ, ");
INSERT INTO sanben_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","কিন্তু তৃতীযেঽহি्ন ম উত্থাপিষ্যতে, তেন তে ভৃশং দুঃখিতা বভূৱঃ| ");
INSERT INTO sanben_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","তদনন্তরং তেষু কফর্নাহূম্নগরমাগতেষু করসংগ্রাহিণঃ পিতরান্তিকমাগত্য পপ্রচ্ছুঃ, যুষ্মাকং গুরুঃ কিং মন্দিরার্থং করং ন দদাতি? ততঃ পিতরঃ কথিতৱান্ দদাতি| ");
INSERT INTO sanben_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ততস্তস্মিন্ গৃহমধ্যমাগতে তস্য কথাকথনাৎ পূর্ৱ্ৱমেৱ যীশুরুৱাচ, হে শিমোন্, মেদিন্যা রাজানঃ স্ৱস্ৱাপত্যেভ্যঃ কিং ৱিদেশিভ্যঃ কেভ্যঃ করং গৃহ্লন্তি? অত্র ৎৱং কিং বুধ্যসে? ততঃ পিতর উক্তৱান্, ৱিদেশিভ্যঃ| ");
INSERT INTO sanben_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","তদা যীশুরুক্তৱান্, তর্হি সন্তানা মুক্তাঃ সন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","তথাপি যথাস্মাভিস্তেষামন্তরাযো ন জন্যতে, তৎকৃতে জলধেস্তীরং গৎৱা ৱডিশং ক্ষিপ, তেনাদৌ যো মীন উত্থাস্যতি, তং ঘৃৎৱা তন্মুখে মোচিতে তোলকৈকং রূপ্যং প্রাপ্স্যসি, তদ্ গৃহীৎৱা তৱ মম চ কৃতে তেভ্যো দেহি| ");
INSERT INTO sanben_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","তদানীং শিষ্যা যীশোঃ সমীপমাগত্য পৃষ্টৱন্তঃ স্ৱর্গরাজ্যে কঃ শ্রেষ্ঠঃ? ");
INSERT INTO sanben_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","ততো যীশুঃ ক্ষুদ্রমেকং বালকং স্ৱসমীপমানীয তেষাং মধ্যে নিধায জগাদ, ");
INSERT INTO sanben_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","যুষ্মানহং সত্যং ব্রৱীমি, যূযং মনোৱিনিমযেন ক্ষুদ্রবালৱৎ ন সন্তঃ স্ৱর্গরাজ্যং প্রৱেষ্টুং ন শক্নুথ| ");
INSERT INTO sanben_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","যঃ কশ্চিদ্ এতস্য ক্ষুদ্রবালকস্য সমমাত্মানং নম্রীকরোতি, সএৱ স্ৱর্গরাজযে শ্রেষ্ঠঃ| ");
INSERT INTO sanben_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","যঃ কশ্চিদ্ এতাদৃশং ক্ষুদ্রবালকমেকং মম নাম্নি গৃহ্লাতি, স মামেৱ গৃহ্লাতি| ");
INSERT INTO sanben_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","কিন্তু যো জনো মযি কৃতৱিশ্ৱাসানামেতেষাং ক্ষুদ্রপ্রাণিনাম্ একস্যাপি ৱিধ্নিং জনযতি, কণ্ঠবদ্ধপেষণীকস্য তস্য সাগরাগাধজলে মজ্জনং শ্রেযঃ| ");
INSERT INTO sanben_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","ৱিঘ্নাৎ জগতঃ সন্তাপো ভৱিষ্যতি, ৱিঘ্নোঽৱশ্যং জনযিষ্যতে, কিন্তু যেন মনুজেন ৱিঘ্নো জনিষ্যতে তস্যৈৱ সন্তাপো ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","তস্মাৎ তৱ করশ্চরণো ৱা যদি ৎৱাং বাধতে, তর্হি তং ছিত্ত্ৱা নিক্ষিপ, দ্ৱিকরস্য দ্ৱিপদস্য ৱা তৱানপ্তৱহ্নৌ নিক্ষেপাৎ, খঞ্জস্য ৱা ছিন্নহস্তস্য তৱ জীৱনে প্রৱেশো ৱরং| ");
INSERT INTO sanben_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","অপরং তৱ নেত্রং যদি ৎৱাং বাধতে, তর্হি তদপ্যুৎপাৱ্য নিক্ষিপ, দ্ৱিনেত্রস্য নরকাগ্নৌ নিক্ষেপাৎ কাণস্য তৱ জীৱনে প্রৱেশো ৱরং| ");
INSERT INTO sanben_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","তস্মাদৱধদ্ধং, এতেষাং ক্ষুদ্রপ্রাণিনাম্ একমপি মা তুচ্ছীকুরুত, ");
INSERT INTO sanben_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","যতো যুষ্মানহং তথ্যং ব্রৱীমি, স্ৱর্গে তেষাং দূতা মম স্ৱর্গস্থস্য পিতুরাস্যং নিত্যং পশ্যন্তি| এৱং যে যে হারিতাস্তান্ রক্ষিতুং মনুজপুত্র আগচ্ছৎ| ");
INSERT INTO sanben_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","যূযমত্র কিং ৱিৱিংগ্ঘ্ৱে? কস্যচিদ্ যদি শতং মেষাঃ সন্তি, তেষামেকো হার্য্যতে চ, তর্হি স একোনশতং মেষান্ ৱিহায পর্ৱ্ৱতং গৎৱা তং হারিতমেকং কিং ন মৃগযতে? ");
INSERT INTO sanben_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","যদি চ কদাচিৎ তন্মেষোদ্দেশং লমতে, তর্হি যুষ্মানহং সত্যং কথযামি, সোঽৱিপথগামিভ্য একোনশতমেষেভ্যোপি তদেকহেতোরধিকম্ আহ্লাদতে| ");
INSERT INTO sanben_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","তদ্ৱদ্ এতেষাং ক্ষুদ্রপ্রাএिনাম্ একোপি নশ্যতীতি যুষ্মাকং স্ৱর্গস্থপিতু র্নাভিমতম্| ");
INSERT INTO sanben_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","যদ্যপি তৱ ভ্রাতা ৎৱযি কিমপ্যপরাধ্যতি, তর্হি গৎৱা যুৱযোর্দ্ৱযোঃ স্থিতযোস্তস্যাপরাধং তং জ্ঞাপয| তত্র স যদি তৱ ৱাক্যং শৃণোতি, তর্হি ৎৱং স্ৱভ্রাতরং প্রাপ্তৱান্, ");
INSERT INTO sanben_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","কিন্তু যদি ন শৃণোতি, তর্হি দ্ৱাভ্যাং ত্রিভি র্ৱা সাক্ষীভিঃ সর্ৱ্ৱং ৱাক্যং যথা নিশ্চিতং জাযতে, তদর্থম্ একং দ্ৱৌ ৱা সাক্ষিণৌ গৃহীৎৱা যাহি| ");
INSERT INTO sanben_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","তেন স যদি তযো র্ৱাক্যং ন মান্যতে, তর্হি সমাজং তজ্জ্ঞাপয, কিন্তু যদি সমাজস্যাপি ৱাক্যং ন মান্যতে,তর্হি স তৱ সমীপে দেৱপূজকইৱ চণ্ডালইৱ চ ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","অহং যুষ্মান্ সত্যং ৱদামি, যুষ্মাভিঃ পৃথিৱ্যাং যদ্ বধ্যতে তৎ স্ৱর্গে ভংৎস্যতে; মেদিন্যাং যৎ ভোচ্যতে, স্ৱর্গেঽপি তৎ মোক্ষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","পুনরহং যুষ্মান্ ৱদামি, মেদিন্যাং যুষ্মাকং যদি দ্ৱাৱেকৱাক্যীভূয কিঞ্চিৎ প্রার্থযেতে, তর্হি মম স্ৱর্গস্থপিত্রা তৎ তযোঃ কৃতে সম্পন্নং ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","যতো যত্র দ্ৱৌ ত্রযো ৱা মম নান্নি মিলন্তি, তত্রৈৱাহং তেষাং মধ্যেঽস্মি| ");
INSERT INTO sanben_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","তদানীং পিতরস্তৎসমীপমাগত্য কথিতৱান্ হে প্রভো, মম ভ্রাতা মম যদ্যপরাধ্যতি, তর্হি তং কতিকৃৎৱঃ ক্ষমিষ্যে? ");
INSERT INTO sanben_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","কিং সপ্তকৃৎৱঃ? যীশুস্তং জগাদ, ৎৱাং কেৱলং সপ্তকৃৎৱো যাৱৎ ন ৱদামি, কিন্তু সপ্তত্যা গুণিতং সপ্তকৃৎৱো যাৱৎ| ");
INSERT INTO sanben_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","অপরং নিজদাসৈঃ সহ জিগণযিষুঃ কশ্চিদ্ রাজেৱ স্ৱর্গরাজযং| ");
INSERT INTO sanben_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","আরব্ধে তস্মিন্ গণনে সার্দ্ধসহস্রমুদ্রাপূরিতানাং দশসহস্রপুটকানাম্ একোঽঘমর্ণস্তৎসমক্ষমানাযি| ");
INSERT INTO sanben_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","তস্য পরিশোধনায দ্রৱ্যাভাৱাৎ পরিশোধনার্থং স তদীযভার্য্যাপুত্রাদিসর্ৱ্ৱস্ৱঞ্চ ৱিক্রীযতামিতি তৎপ্রভুরাদিদেশ| ");
INSERT INTO sanben_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","তেন স দাসস্তস্য পাদযোঃ পতন্ প্রণম্য কথিতৱান্ , হে প্রভো ভৱতা ঘৈর্য্যে কৃতে মযা সর্ৱ্ৱং পরিশোধিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","তদানীং দাসস্য প্রভুঃ সকরুণঃ সন্ সকলর্ণং ক্ষমিৎৱা তং তত্যাজ| ");
INSERT INTO sanben_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","কিন্তু তস্মিন্ দাসে বহি র্যাতে, তস্য শতং মুদ্রাচতুর্থাংশান্ যো ধারযতি, তং সহদাসং দৃষ্দ্ৱা তস্য কণ্ঠং নিষ্পীড্য গদিতৱান্, মম যৎ প্রাপ্যং তৎ পরিশোধয| ");
INSERT INTO sanben_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","তদা তস্য সহদাসস্তৎপাদযোঃ পতিৎৱা ৱিনীয বভাষে, ৎৱযা ধৈর্য্যে কৃতে মযা সর্ৱ্ৱং পরিশোধিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","তথাপি স তৎ নাঙগীকৃত্য যাৱৎ সর্ৱ্ৱমৃণং ন পরিশোধিতৱান্ তাৱৎ তং কারাযাং স্থাপযামাস| ");
INSERT INTO sanben_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","তদা তস্য সহদাসাস্তস্যৈতাদৃগ্ আচরণং ৱিলোক্য প্রভোঃ সমীপং গৎৱা সর্ৱ্ৱং ৱৃত্তান্তং নিৱেদযামাসুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","তদা তস্য প্রভুস্তমাহূয জগাদ, রে দুষ্ট দাস, ৎৱযা মৎসন্নিধৌ প্রার্থিতে মযা তৱ সর্ৱ্ৱমৃণং ত্যক্তং; ");
INSERT INTO sanben_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","যথা চাহং ৎৱযি করুণাং কৃতৱান্, তথৈৱ ৎৱৎসহদাসে করুণাকরণং কিং তৱ নোচিতং? ");
INSERT INTO sanben_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ইতি কথযিৎৱা তস্য প্রভুঃ ক্রুদ্ধ্যন্ নিজপ্রাপ্যং যাৱৎ স ন পরিশোধিতৱান্, তাৱৎ প্রহারকানাং করেষু তং সমর্পিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","যদি যূযং স্ৱান্তঃকরণৈঃ স্ৱস্ৱসহজানাম্ অপরাধান্ ন ক্ষমধ্ৱে, তর্হি মম স্ৱর্গস্যঃ পিতাপি যুষ্মান্ প্রতীত্থং করিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","অনন্তরম্ এতাসু কথাসু সমাপ্তাসু যীশু র্গালীলপ্রদেশাৎ প্রস্থায যর্দন্তীরস্থং যিহূদাপ্রদেশং প্রাপ্তঃ| ");
INSERT INTO sanben_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","তদা তৎপশ্চাৎ জননিৱহে গতে স তত্র তান্ নিরামযান্ অকরোৎ| ");
INSERT INTO sanben_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","তদনন্তরং ফিরূশিনস্তৎসমীপমাগত্য পারীক্ষিতুং তং পপ্রচ্ছুঃ, কস্মাদপি কারণাৎ নরেণ স্ৱজাযা পরিত্যাজ্যা ন ৱা? ");
INSERT INTO sanben_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","স প্রত্যুৱাচ, প্রথমম্ ঈশ্ৱরো নরৎৱেন নারীৎৱেন চ মনুজান্ সসর্জ, তস্মাৎ কথিতৱান্, ");
INSERT INTO sanben_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","মানুষঃ স্ৱপিতরৌ পরিত্যজ্য স্ৱপত্ন্যাম্ আসক্ষ্যতে, তৌ দ্ৱৌ জনাৱেকাঙ্গৌ ভৱিষ্যতঃ, কিমেতদ্ যুষ্মাভি র্ন পঠিতম্? ");
INSERT INTO sanben_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","অতস্তৌ পুন র্ন দ্ৱৌ তযোরেকাঙ্গৎৱং জাতং, ঈশ্ৱরেণ যচ্চ সমযুজ্যত, মনুজো ন তদ্ ভিন্দ্যাৎ| ");
INSERT INTO sanben_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","তদানীং তে তং প্রত্যৱদন্, তথাৎৱে ত্যাজ্যপত্রং দত্ত্ৱা স্ৱাং স্ৱাং জাযাং ত্যক্তুং ৱ্যৱস্থাং মূসাঃ কথং লিলেখ? ");
INSERT INTO sanben_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ততঃ স কথিতৱান্, যুষ্মাকং মনসাং কাঠিন্যাদ্ যুষ্মান্ স্ৱাং স্ৱাং জাযাং ত্যক্তুম্ অন্ৱমন্যত কিন্তু প্রথমাদ্ এষো ৱিধির্নাসীৎ| ");
INSERT INTO sanben_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","অতো যুষ্মানহং ৱদামি, ৱ্যভিচারং ৱিনা যো নিজজাযাং ত্যজেৎ অন্যাঞ্চ ৱিৱহেৎ, স পরদারান্ গচ্ছতি; যশ্চ ত্যক্তাং নারীং ৱিৱহতি সোপি পরদারেষু রমতে| ");
INSERT INTO sanben_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","তদা তস্য শিষ্যাস্তং বভাষিরে, যদি স্ৱজাযযা সাকং পুংস এতাদৃক্ সম্বন্ধো জাযতে, তর্হি ৱিৱহনমেৱ ন ভদ্রং| ");
INSERT INTO sanben_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ততঃ স উক্তৱান্, যেভ্যস্তৎসামর্থ্যং আদাযি, তান্ ৱিনান্যঃ কোপি মনুজ এতন্মতং গ্রহীতুং ন শক্নোতি| ");
INSERT INTO sanben_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","কতিপযা জননক্লীবঃ কতিপযা নরকৃতক্লীবঃ স্ৱর্গরাজ্যায কতিপযাঃ স্ৱকৃতক্লীবাশ্চ সন্তি, যে গ্রহীতুং শক্নুৱন্তি তে গৃহ্লন্তু| ");
INSERT INTO sanben_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","অপরম্ যথা স শিশূনাং গাত্রেষু হস্তং দৎৱা প্রার্থযতে, তদর্থং তৎসমীংপং শিশৱ আনীযন্ত, তত আনযিতৃন্ শিষ্যাস্তিরস্কৃতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","কিন্তু যীশুরুৱাচ, শিশৱো মদন্তিকম্ আগচ্ছন্তু, তান্ মা ৱারযত, এতাদৃশাং শিশূনামেৱ স্ৱর্গরাজ্যং| ");
INSERT INTO sanben_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ততঃ স তেষাং গাত্রেষু হস্তং দৎৱা তস্মাৎ স্থানাৎ প্রতস্থে| ");
INSERT INTO sanben_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","অপরম্ এক আগত্য তং পপ্রচ্ছ, হে পরমগুরো, অনন্তাযুঃ প্রাপ্তুং মযা কিং কিং সৎকর্ম্ম কর্ত্তৱ্যং? ");
INSERT INTO sanben_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ততঃ স উৱাচ, মাং পরমং কুতো ৱদসি? ৱিনেশ্চরং ন কোপি পরমঃ, কিন্তু যদ্যনন্তাযুঃ প্রাপ্তুং ৱাঞ্ছসি, তর্হ্যাজ্ঞাঃ পালয| ");
INSERT INTO sanben_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","তদা স পৃষ্টৱান্, কাঃ কা আজ্ঞাঃ? ততো যীশুঃ কথিতৱান্, নরং মা হন্যাঃ, পরদারান্ মা গচ্ছেঃ, মা চোরযেঃ, মৃষাসাক্ষ্যং মা দদ্যাঃ, ");
INSERT INTO sanben_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","নিজপিতরৌ সংমন্যস্ৱ, স্ৱসমীপৱাসিনি স্ৱৱৎ প্রেম কুরু| ");
INSERT INTO sanben_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","স যুৱা কথিতৱান্, আ বাল্যাদ্ এতাঃ পালযামি, ইদানীং কিং ন্যূনমাস্তে? ");
INSERT INTO sanben_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ততো যীশুরৱদৎ, যদি সিদ্ধো ভৱিতুং ৱাঞ্ছসি, তর্হি গৎৱা নিজসর্ৱ্ৱস্ৱং ৱিক্রীয দরিদ্রেভ্যো ৱিতর, ততঃ স্ৱর্গে ৱিত্তং লপ্স্যসে; আগচ্ছ, মৎপশ্চাদ্ৱর্ত্তী চ ভৱ| ");
INSERT INTO sanben_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","এতাং ৱাচং শ্রুৎৱা স যুৱা স্ৱীযবহুসম্পত্তে র্ৱিষণঃ সন্ চলিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","তদা যীশুঃ স্ৱশিষ্যান্ অৱদৎ, ধনিনাং স্ৱর্গরাজ্যপ্রৱেশো মহাদুষ্কর ইতি যুষ্মানহং তথ্যং ৱদামি| ");
INSERT INTO sanben_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","পুনরপি যুষ্মানহং ৱদামি, ধনিনাং স্ৱর্গরাজ্যপ্রৱেশাৎ সূচীছিদ্রেণ মহাঙ্গগমনং সুকরং| ");
INSERT INTO sanben_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ইতি ৱাক্যং নিশম্য শিষ্যা অতিচমৎকৃত্য কথযামাসুঃ; তর্হি কস্য পরিত্রাণং ভৱিতুং শক্নোতি? ");
INSERT INTO sanben_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","তদা স তান্ দৃষ্দ্ৱা কথযামাস, তৎ মানুষাণামশক্যং ভৱতি, কিন্ত্ৱীশ্ৱরস্য সর্ৱ্ৱং শক্যম্| ");
INSERT INTO sanben_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","তদা পিতরস্তং গদিতৱান্, পশ্য, ৱযং সর্ৱ্ৱং পরিত্যজ্য ভৱতঃ পশ্চাদ্ৱর্ত্তিনো ঽভৱাম; ৱযং কিং প্রাপ্স্যামঃ? ");
INSERT INTO sanben_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ততো যীশুঃ কথিতৱান্, যুষ্মানহং তথ্যং ৱদামি, যূযং মম পশ্চাদ্ৱর্ত্তিনো জাতা ইতি কারণাৎ নৱীনসৃষ্টিকালে যদা মনুজসুতঃ স্ৱীযৈশ্চর্য্যসিংহাসন উপৱেক্ষ্যতি, তদা যূযমপি দ্ৱাদশসিংহাসনেষূপৱিশ্য ইস্রাযেলীযদ্ৱাদশৱংশানাং ৱিচারং করিষ্যথ| ");
INSERT INTO sanben_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","অন্যচ্চ যঃ কশ্চিৎ মম নামকারণাৎ গৃহং ৱা ভ্রাতরং ৱা ভগিনীং ৱা পিতরং ৱা মাতরং ৱা জাযাং ৱা বালকং ৱা ভূমিং পরিত্যজতি, স তেষাং শতগুণং লপ্স্যতে, অনন্তাযুমোঽধিকারিৎৱঞ্চ প্রাপ্স্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","কিন্তু অগ্রীযা অনেকে জনাঃ পশ্চাৎ, পশ্চাতীযাশ্চানেকে লোকা অগ্রে ভৱিষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","স্ৱর্গরাজ্যম্ এতাদৃশা কেনচিদ্ গৃহস্যেন সমং, যোঽতিপ্রভাতে নিজদ্রাক্ষাক্ষেত্রে কৃষকান্ নিযোক্তুং গতৱান্| ");
INSERT INTO sanben_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","পশ্চাৎ তৈঃ সাকং দিনৈকভৃতিং মুদ্রাচতুর্থাংশং নিরূপ্য তান্ দ্রাক্ষাক্ষেত্রং প্রেরযামাস| ");
INSERT INTO sanben_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","অনন্তরং প্রহরৈকৱেলাযাং গৎৱা হট্টে কতিপযান্ নিষ্কর্ম্মকান্ ৱিলোক্য তানৱদৎ, ");
INSERT INTO sanben_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","যূযমপি মম দ্রাক্ষাক্ষেত্রং যাত, যুষ্মভ্যমহং যোগ্যভৃতিং দাস্যামি, ততস্তে ৱৱ্রজুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","পুনশ্চ স দ্ৱিতীযতৃতীযযোঃ প্রহরযো র্বহি র্গৎৱা তথৈৱ কৃতৱান্| ");
INSERT INTO sanben_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","ততো দণ্ডদ্ৱযাৱশিষ্টাযাং ৱেলাযাং বহি র্গৎৱাপরান্ কতিপযজনান্ নিষ্কর্ম্মকান্ ৱিলোক্য পৃষ্টৱান্, যূযং কিমর্থম্ অত্র সর্ৱ্ৱং দিনং নিষ্কর্ম্মাণস্তিষ্ঠথ? ");
INSERT INTO sanben_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","তে প্রত্যৱদন্, অস্মান্ ন কোপি কর্মমণি নিযুংক্তে| তদানীং স কথিতৱান্, যূযমপি মম দ্রাক্ষাক্ষেত্রং যাত, তেন যোগ্যাং ভৃতিং লপ্স্যথ| ");
INSERT INTO sanben_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","তদনন্তরং সন্ধ্যাযাং সত্যাং সএৱ দ্রাক্ষাক্ষেত্রপতিরধ্যক্ষং গদিৱান্, কৃষকান্ আহূয শেষজনমারভ্য প্রথমং যাৱৎ তেভ্যো ভৃতিং দেহি| ");
INSERT INTO sanben_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","তেন যে দণ্ডদ্ৱযাৱস্থিতে সমাযাতাস্তেষাম্ একৈকো জনো মুদ্রাচতুর্থাংশং প্রাপ্নোৎ| ");
INSERT INTO sanben_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","তদানীং প্রথমনিযুক্তা জনা আগত্যানুমিতৱন্তো ৱযমধিকং প্রপ্স্যামঃ, কিন্তু তৈরপি মুদ্রাচতুর্থাংশোঽলাভি| ");
INSERT INTO sanben_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ততস্তে তং গৃহীৎৱা তেন ক্ষেত্রপতিনা সাকং ৱাগ্যুদ্ধং কুর্ৱ্ৱন্তঃ কথযামাসুঃ, ");
INSERT INTO sanben_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ৱযং কৃৎস্নং দিনং তাপক্লেশৌ সোঢৱন্তঃ, কিন্তু পশ্চাতাযা সে জনা দণ্ডদ্ৱযমাত্রং পরিশ্রান্তৱন্তস্তেঽস্মাভিঃ সমানাংশাঃ কৃতাঃ| ");
INSERT INTO sanben_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","ততঃ স তেষামেকং প্রত্যুৱাচ, হে ৱৎস, মযা ৎৱাং প্রতি কোপ্যন্যাযো ন কৃতঃ কিং ৎৱযা মৎসমক্ষং মুদ্রাচতুর্থাংশো নাঙ্গীকৃতঃ? ");
INSERT INTO sanben_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","তস্মাৎ তৱ যৎ প্রাপ্যং তদাদায যাহি, তুভ্যং যতি, পশ্চাতীযনিযুক্তলোকাযাপি ততি দাতুমিচ্ছামি| ");
INSERT INTO sanben_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","স্ৱেচ্ছযা নিজদ্রৱ্যৱ্যৱহরণং কিং মযা ন কর্ত্তৱ্যং? মম দাতৃৎৱাৎ ৎৱযা কিম্ ঈর্ষ্যাদৃষ্টিঃ ক্রিযতে? ");
INSERT INTO sanben_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","ইত্থম্ অগ্রীযলোকাঃ পশ্চতীযা ভৱিষ্যন্তি, পশ্চাতীযজনাশ্চগ্রীযা ভৱিষ্যন্তি, অহূতা বহৱঃ কিন্ত্ৱল্পে মনোভিলষিতাঃ| ");
INSERT INTO sanben_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","তদনন্তরং যীশু র্যিরূশালম্নগরং গচ্ছন্ মার্গমধ্যে শিষ্যান্ একান্তে ৱভাষে, ");
INSERT INTO sanben_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","পশ্য ৱযং যিরূশালম্নগরং যামঃ, তত্র প্রধানযাজকাধ্যাপকানাং করেষু মনুষ্যপুত্রঃ সমর্পিষ্যতে; ");
INSERT INTO sanben_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","তে চ তং হন্তুমাজ্ঞাপ্য তিরস্কৃত্য ৱেত্রেণ প্রহর্ত্তুং ক্রুশে ধাতযিতুঞ্চান্যদেশীযানাং করেষু সমর্পযিষ্যন্তি, কিন্তু স তৃতীযদিৱসে শ্মশানাদ্ উত্থাপিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","তদানীং সিৱদীযস্য নারী স্ৱপুত্রাৱাদায যীশোঃ সমীপম্ এত্য প্রণম্য কঞ্চনানুগ্রহং তং যযাচে| ");
INSERT INTO sanben_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","তদা যীশুস্তাং প্রোক্তৱান্, ৎৱং কিং যাচসে? ততঃ সা বভাষে, ভৱতো রাজৎৱে মমানযোঃ সুতযোরেকং ভৱদ্দক্ষিণপার্শ্ৱে দ্ৱিতীযং ৱামপার্শ্ৱ উপৱেষ্টুম্ আজ্ঞাপযতু| ");
INSERT INTO sanben_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","যীশুঃ প্রত্যুৱাচ, যুৱাভ্যাং যদ্ যাচ্যতে, তন্ন বুধ্যতে, অহং যেন কংসেন পাস্যামি যুৱাভ্যাং কিং তেন পাতুং শক্যতে? অহঞ্চ যেন মজ্জেনেন মজ্জিষ্যে, যুৱাভ্যাং কিং তেন মজ্জযিতুং শক্যতে? তে জগদুঃ শক্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","তদা স উক্তৱান্, যুৱাং মম কংসেনাৱশ্যং পাস্যথঃ, মম মজ্জনেন চ যুৱামপি মজ্জিষ্যেথে, কিন্তু যেষাং কৃতে মত্তাতেন নিরূপিতম্ ইদং তান্ ৱিহাযান্যং কমপি মদ্দক্ষিণপার্শ্ৱে ৱামপার্শ্ৱে চ সমুপৱেশযিতুং মমাধিকারো নাস্তি| ");
INSERT INTO sanben_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","এতাং কথাং শ্রুৎৱান্যে দশশিষ্যাস্তৌ ভ্রাতরৌ প্রতি চুকুপুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","কিন্তু যীশুঃ স্ৱসমীপং তানাহূয জগাদ, অন্যদেশীযলোকানাং নরপতযস্তান্ অধিকুর্ৱ্ৱন্তি, যে তু মহান্তস্তে তান্ শাসতি, ইতি যূযং জানীথ| ");
INSERT INTO sanben_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","কিন্তু যুষ্মাকং মধ্যে ন তথা ভৱেৎ, যুষ্মাকং যঃ কশ্চিৎ মহান্ বুভূষতি, স যুষ্মান্ সেৱেত; ");
INSERT INTO sanben_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","যশ্চ যুষ্মাকং মধ্যে মুখ্যো বুভূষতি, স যুষ্মাকং দাসো ভৱেৎ| ");
INSERT INTO sanben_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ইত্থং মনুজপুত্রঃ সেৱ্যো ভৱিতুং নহি, কিন্তু সেৱিতুং বহূনাং পরিত্রাণমূল্যার্থং স্ৱপ্রাণান্ দাতুঞ্চাগতঃ| ");
INSERT INTO sanben_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","অনন্তরং যিরীহোনগরাৎ তেষাং বহির্গমনসমযে তস্য পশ্চাদ্ বহৱো লোকা ৱৱ্রজুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","অপরং ৱর্ত্মপার্শ্ৱ উপৱিশন্তৌ দ্ৱাৱন্ধৌ তেন মার্গেণ যীশো র্গমনং নিশম্য প্রোচ্চৈঃ কথযামাসতুঃ, হে প্রভো দাযূদঃ সন্তান, আৱযো র্দযাং ৱিধেহি| ");
INSERT INTO sanben_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ততো লোকাঃ সর্ৱ্ৱে তুষ্ণীম্ভৱতমিত্যুক্ত্ৱা তৌ তর্জযামাসুঃ; তথাপি তৌ পুনরুচ্চৈঃ কথযামাসতুঃ হে প্রভো দাযূদঃ সন্তান, আৱাং দযস্ৱ| ");
INSERT INTO sanben_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","তদানীং যীশুঃ স্থগিতঃ সন্ তাৱাহূয ভাষিতৱান্, যুৱযোঃ কৃতে মযা কিং কর্ত্তর্ৱ্যং? যুৱাং কিং কামযেথে? ");
INSERT INTO sanben_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","তদা তাৱুক্তৱন্তৌ, প্রভো নেত্রাণি নৌ প্রসন্নানি ভৱেযুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","তদানীং যীশুস্তৌ প্রতি প্রমন্নঃ সন্ তযো র্নেত্রাণি পস্পর্শ, তেনৈৱ তৌ সুৱীক্ষাঞ্চক্রাতে তৎপশ্চাৎ জগ্মুতুশ্চ| ");
INSERT INTO sanben_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","অনন্তরং তেষু যিরূশালম্নগরস্য সমীপৱের্ত্তিনো জৈতুননামকধরাধরস্য সমীপস্থ্তিং বৈৎফগিগ্রামম্ আগতেষু, যীশুঃ শিষ্যদ্ৱযং প্রেষযন্ জগাদ, ");
INSERT INTO sanben_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","যুৱাং সম্মুখস্থগ্রামং গৎৱা বদ্ধাং যাং সৱৎসাং গর্দ্দভীং হঠাৎ প্রাপ্স্যথঃ, তাং মোচযিৎৱা মদন্তিকম্ আনযতং| ");
INSERT INTO sanben_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","তত্র যদি কশ্চিৎ কিঞ্চিদ্ ৱক্ষ্যতি, তর্হি ৱদিষ্যথঃ, এতস্যাং প্রভোঃ প্রযোজনমাস্তে, তেন স তৎক্ষণাৎ প্রহেষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","সীযোনঃ কন্যকাং যূযং ভাষধ্ৱমিতি ভারতীং| পশ্য তে নম্রশীলঃ সন্ নৃপ আরুহ্য গর্দভীং| অর্থাদারুহ্য তদ্ৱৎসমাযাস্যতি ৎৱদন্তিকং| ");
INSERT INTO sanben_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","ভৱিষ্যদ্ৱাদিনোক্তং ৱচনমিদং তদা সফলমভূৎ| ");
INSERT INTO sanben_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","অনন্তরং তৌ শ্ষ্যিौ যীশো র্যথানিদেশং তং গ্রামং গৎৱা ");
INSERT INTO sanben_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","গর্দভীং তদ্ৱৎসঞ্চ সমানীতৱন্তৌ, পশ্চাৎ তদুপরি স্ৱীযৱসনানী পাতযিৎৱা তমারোহযামাসতুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ততো বহৱো লোকা নিজৱসনানি পথি প্রসারযিতুমারেভিরে, কতিপযা জনাশ্চ পাদপপর্ণাদিকং ছিৎৱা পথি ৱিস্তারযামাসুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","অগ্রগামিনঃ পশ্চাদ্গামিনশ্চ মনুজা উচ্চৈর্জয জয দাযূদঃ সন্তানেতি জগদুঃ পরমেশ্ৱরস্য নাম্না য আযাতি স ধন্যঃ, সর্ৱ্ৱোপরিস্থস্ৱর্গেপি জযতি| ");
INSERT INTO sanben_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ইত্থং তস্মিন্ যিরূশালমং প্রৱিষ্টে কোঽযমিতি কথনাৎ কৃৎস্নং নগরং চঞ্চলমভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","তত্র লোকোঃ কথযামাসুঃ, এষ গালীল্প্রদেশীয-নাসরতীয-ভৱিষ্যদ্ৱাদী যীশুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","অনন্তরং যীশুরীশ্ৱরস্য মন্দিরং প্রৱিশ্য তন্মধ্যাৎ ক্রযৱিক্রযিণো ৱহিশ্চকার; ৱণিজাং মুদ্রাসনানী কপোতৱিক্রযিণাঞ্চসনানী চ ন্যুৱ্জযামাস| ");
INSERT INTO sanben_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","অপরং তানুৱাচ, এষা লিপিরাস্তে, \"মম গৃহং প্রার্থনাগৃহমিতি ৱিখ্যাস্যতি\", কিন্তু যূযং তদ্ দস্যূনাং গহ্ৱরং কৃতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","তদনন্তরম্ অন্ধখঞ্চলোকাস্তস্য সমীপমাগতাঃ, স তান্ নিরামযান্ কৃতৱান্| ");
INSERT INTO sanben_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","যদা প্রধানযাজকা অধ্যাপকাশ্চ তেন কৃতান্যেতানি চিত্রকর্ম্মাণি দদৃশুঃ, জয জয দাযূদঃ সন্তান, মন্দিরে বালকানাম্ এতাদৃশম্ উচ্চধ্ৱনিং শুশ্রুৱুশ্চ, তদা মহাক্রুদ্ধা বভূৱঃ, ");
INSERT INTO sanben_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","তং পপ্রচ্ছুশ্চ, ইমে যদ্ ৱদন্তি, তৎ কিং ৎৱং শৃণোষি? ততো যীশুস্তান্ অৱোচৎ, সত্যম্; স্তন্যপাযিশিশূনাঞ্চ বালকানাঞ্চ ৱক্ত্রতঃ| স্ৱকীযং মহিমানং ৎৱং সংপ্রকাশযসি স্ৱযং| এতদ্ৱাক্যং যূযং কিং নাপঠত? ");
INSERT INTO sanben_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ততস্তান্ ৱিহায স নগরাদ্ বৈথনিযাগ্রামং গৎৱা তত্র রজনীং যাপযামাস| ");
INSERT INTO sanben_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","অনন্তরং প্রভাতে সতি যীশুঃ পুনরপি নগরমাগচ্ছন্ ক্ষুধার্ত্তো বভূৱ| ");
INSERT INTO sanben_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ততো মার্গপার্শ্ৱ উডুম্বরৱৃক্ষমেকং ৱিলোক্য তৎসমীপং গৎৱা পত্রাণি ৱিনা কিমপি ন প্রাপ্য তং পাদপং প্রোৱাচ, অদ্যারভ্য কদাপি ৎৱযি ফলং ন ভৱতু; তেন তৎক্ষণাৎ স উডুম্বরমাহীরুহঃ শুষ্কতাং গতঃ| ");
INSERT INTO sanben_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","তদ্ দৃষ্ট্ৱা শিষ্যা আশ্চর্য্যং ৱিজ্ঞায কথযামাসুঃ, আঃ, উডুম্ৱরপাদপোঽতিতূর্ণং শুষ্কোঽভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ততো যীশুস্তানুৱাচ, যুষ্মানহং সত্যং ৱদামি, যদি যূযমসন্দিগ্ধাঃ প্রতীথ, তর্হি যূযমপি কেৱলোডুম্ৱরপাদপং প্রতীত্থং কর্ত্তুং শক্ষ্যথ, তন্ন, ৎৱং চলিৎৱা সাগরে পতেতি ৱাক্যং যুষ্মাভিরস্মিন শৈলে প্রোক্তেপি তদৈৱ তদ্ ঘটিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","তথা ৱিশ্ৱস্য প্রার্থ্য যুষ্মাভি র্যদ্ যাচিষ্যতে, তদেৱ প্রাপ্স্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","অনন্তরং মন্দিরং প্রৱিশ্যোপদেশনসমযে তৎসমীপং প্রধানযাজকাঃ প্রাচীনলোকাশ্চাগত্য পপ্রচ্ছুঃ, ৎৱযা কেন সামর্থ্যনৈতানি কর্ম্মাণি ক্রিযন্তে? কেন ৱা তুভ্যমেতানি সামর্থ্যানি দত্তানি? ");
INSERT INTO sanben_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ততো যীশুঃ প্রত্যৱদৎ, অহমপি যুষ্মান্ ৱাচমেকাং পৃচ্ছামি, যদি যূযং তদুত্তরং দাতুং শক্ষ্যথ, তদা কেন সামর্থ্যেন কর্ম্মাণ্যেতানি করোমি, তদহং যুষ্মান্ ৱক্ষ্যামি| ");
INSERT INTO sanben_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","যোহনো মজ্জনং কস্যাজ্ঞযাভৱৎ? কিমীশ্ৱরস্য মনুষ্যস্য ৱা? ততস্তে পরস্পরং ৱিৱিচ্য কথযামাসুঃ, যদীশ্ৱরস্যেতি ৱদামস্তর্হি যূযং তং কুতো ন প্রত্যৈত? ৱাচমেতাং ৱক্ষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","মনুষ্যস্যেতি ৱক্তুমপি লোকেভ্যো বিভীমঃ, যতঃ সর্ৱ্ৱৈরপি যোহন্ ভৱিষ্যদ্ৱাদীতি জ্ঞাযতে| ");
INSERT INTO sanben_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","তস্মাৎ তে যীশুং প্রত্যৱদন্, তদ্ ৱযং ন ৱিদ্মঃ| তদা স তানুক্তৱান্, তর্হি কেন সামরথ্যেন কর্ম্মাণ্যেতান্যহং করোমি, তদপ্যহং যুষ্মান্ ন ৱক্ষ্যামি| ");
INSERT INTO sanben_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","কস্যচিজ্জনস্য দ্ৱৌ সুতাৱাস্তাং স একস্য সুতস্য সমীপং গৎৱা জগাদ, হে সুত, ৎৱমদ্য মম দ্রাক্ষাক্ষেত্রে কর্ম্ম কর্তুং ৱ্রজ| ");
INSERT INTO sanben_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ততঃ স উক্তৱান্, ন যাস্যামি, কিন্তু শেষেঽনুতপ্য জগাম| ");
INSERT INTO sanben_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","অনন্তরং সোন্যসুতস্য সমীপং গৎৱা তথৈৱ কথ্তিৱান্; ততঃ স প্রত্যুৱাচ, মহেচ্ছ যামি, কিন্তু ন গতঃ| ");
INSERT INTO sanben_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","এতযোঃ পুত্রযো র্মধ্যে পিতুরভিমতং কেন পালিতং? যুষ্মাভিঃ কিং বুধ্যতে? ততস্তে প্রত্যূচুঃ, প্রথমেন পুुত্রেণ| তদানীং যীশুস্তানুৱাচ, অহং যুষ্মান্ তথ্যং ৱদামি, চণ্ডালা গণিকাশ্চ যুষ্মাকমগ্রত ঈশ্ৱরস্য রাজ্যং প্রৱিশন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","যতো যুষ্মাকং সমীপং যোহনি ধর্ম্মপথেনাগতে যূযং তং ন প্রতীথ, কিন্তু চণ্ডালা গণিকাশ্চ তং প্রত্যাযন্, তদ্ ৱিলোক্যাপি যূযং প্রত্যেতুং নাখিদ্যধ্ৱং| ");
INSERT INTO sanben_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","অপরমেকং দৃষ্টান্তং শৃণুত, কশ্চিদ্ গৃহস্থঃ ক্ষেত্রে দ্রাক্ষালতা রোপযিৎৱা তচ্চতুর্দিক্ষু ৱারণীং ৱিধায তন্মধ্যে দ্রাক্ষাযন্ত্রং স্থাপিতৱান্, মাঞ্চঞ্চ নির্ম্মিতৱান্, ততঃ কৃষকেষু তৎ ক্ষেত্রং সমর্প্য স্ৱযং দূরদেশং জগাম| ");
INSERT INTO sanben_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","তদনন্তরং ফলসময উপস্থিতে স ফলানি প্রাপ্তুং কৃষীৱলানাং সমীপং নিজদাসান্ প্রেষযামাস| ");
INSERT INTO sanben_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","কিন্তু কৃষীৱলাস্তস্য তান্ দাসেযান্ ধৃৎৱা কঞ্চন প্রহৃতৱন্তঃ, কঞ্চন পাষাণৈরাহতৱন্তঃ, কঞ্চন চ হতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","পুনরপি স প্রভুঃ প্রথমতোঽধিকদাসেযান্ প্রেষযামাস, কিন্তু তে তান্ প্রত্যপি তথৈৱ চক্রুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","অনন্তরং মম সুতে গতে তং সমাদরিষ্যন্তে, ইত্যুক্ত্ৱা শেষে স নিজসুতং তেষাং সন্নিধিং প্রেষযামাস| ");
INSERT INTO sanben_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","কিন্তু তে কৃষীৱলাঃ সুতং ৱীক্ষ্য পরস্পরম্ ইতি মন্ত্রযিতুম্ আরেভিরে, অযমুত্তরাধিকারী ৱযমেনং নিহত্যাস্যাধিকারং স্ৱৱশীকরিষ্যামঃ| ");
INSERT INTO sanben_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","পশ্চাৎ তে তং ধৃৎৱা দ্রাক্ষাক্ষেত্রাদ্ বহিঃ পাতযিৎৱাবধিষুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","যদা স দ্রাক্ষাক্ষেত্রপতিরাগমিষ্যতি, তদা তান্ কৃষীৱলান্ কিং করিষ্যতি? ");
INSERT INTO sanben_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ততস্তে প্রত্যৱদন্, তান্ কলুষিণো দারুণযাতনাভিরাহনিষ্যতি, যে চ সমযানুক্রমাৎ ফলানি দাস্যন্তি, তাদৃশেষু কৃষীৱলেষু ক্ষেত্রং সমর্পযিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","তদা যীশুনা তে গদিতাঃ, গ্রহণং ন কৃতং যস্য পাষাণস্য নিচাযকৈঃ| প্রধানপ্রস্তরঃ কোণে সএৱ সংভৱিষ্যতি| এতৎ পরেশিতুঃ কর্ম্মাস্মদৃষ্টাৱদ্ভুতং ভৱেৎ| ধর্ম্মগ্রন্থে লিখিতমেতদ্ৱচনং যুষ্মাভিঃ কিং নাপাঠি? ");
INSERT INTO sanben_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","তস্মাদহং যুষ্মান্ ৱদামি, যুষ্মত্ত ঈশ্ৱরীযরাজ্যমপনীয ফলোৎপাদযিত্রন্যজাতযে দাযিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","যো জন এতৎপাষাণোপরি পতিষ্যতি, তং স ভংক্ষ্যতে, কিন্ত্ৱযং পাষাণো যস্যোপরি পতিষ্যতি, তং স ধূলিৱৎ চূর্ণীকরিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","তদানীং প্রাধনযাজকাঃ ফিরূশিনশ্চ তস্যেমাং দৃষ্টান্তকথাং শ্রুৎৱা সোঽস্মানুদ্দিশ্য কথিতৱান্, ইতি ৱিজ্ঞায তং ধর্ত্তুং চেষ্টিতৱন্তঃ; ");
INSERT INTO sanben_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","কিন্তু লোকেভ্যো বিভ্যুঃ, যতো লোকৈঃ স ভৱিষ্যদ্ৱাদীত্যজ্ঞাযি| ");
INSERT INTO sanben_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","অনন্তরং যীশুঃ পুনরপি দৃষ্টান্তেন তান্ অৱাদীৎ, ");
INSERT INTO sanben_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","স্ৱর্গীযরাজ্যম্ এতাদৃশস্য নৃপতেঃ সমং, যো নিজ পুত্রং ৱিৱাহযন্ সর্ৱ্ৱান্ নিমন্ত্রিতান্ আনেতুং দাসেযান্ প্রহিতৱান্, ");
INSERT INTO sanben_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","কিন্তু তে সমাগন্তুং নেষ্টৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","ততো রাজা পুনরপি দাসানন্যান্ ইত্যুক্ত্ৱা প্রেষযামাস, নিমন্ত্রিতান্ ৱদত, পশ্যত, মম ভেজ্যমাসাদিতমাস্তে, নিজৱ্টষাদিপুষ্টজন্তূন্ মারযিৎৱা সর্ৱ্ৱং খাদ্যদ্রৱ্যমাসাদিতৱান্, যূযং ৱিৱাহমাগচ্ছত| ");
INSERT INTO sanben_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","তথপি তে তুচ্ছীকৃত্য কেচিৎ নিজক্ষেত্রং কেচিদ্ ৱাণিজ্যং প্রতি স্ৱস্ৱমার্গেণ চলিতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","অন্যে লোকাস্তস্য দাসেযান্ ধৃৎৱা দৌরাত্ম্যং ৱ্যৱহৃত্য তানৱধিষুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","অনন্তরং স নৃপতিস্তাং ৱার্ত্তাং শ্রুৎৱা ক্রুধ্যন্ সৈন্যানি প্রহিত্য তান্ ঘাতকান্ হৎৱা তেষাং নগরং দাহযামাস| ");
INSERT INTO sanben_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","ততঃ স নিজদাসেযান্ বভাষে, ৱিৱাহীযং ভোজ্যমাসাদিতমাস্তে, কিন্তু নিমন্ত্রিতা জনা অযোগ্যাঃ| ");
INSERT INTO sanben_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","তস্মাদ্ যূযং রাজমার্গং গৎৱা যাৱতো মনুজান্ পশ্যত, তাৱতএৱ ৱিৱাহীযভোজ্যায নিমন্ত্রযত| ");
INSERT INTO sanben_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","তদা তে দাসেযা রাজমার্গং গৎৱা ভদ্রান্ অভদ্রান্ ৱা যাৱতো জনান্ দদৃশুঃ, তাৱতএৱ সংগৃহ্যানযন্; ততোঽভ্যাগতমনুজৈ র্ৱিৱাহগৃহম্ অপূর্য্যত| ");
INSERT INTO sanben_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","তদানীং স রাজা সর্ৱ্ৱানভ্যাগতান্ দ্রষ্টুম্ অভ্যন্তরমাগতৱান্; তদা তত্র ৱিৱাহীযৱসনহীনমেকং জনং ৱীক্ষ্য তং জগাদ্, ");
INSERT INTO sanben_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","হে মিত্র,ৎৱং ৱিৱাহীযৱসনং ৱিনা কথমত্র প্রৱিষ্টৱান্? তেন স নিরুত্তরো বভূৱ| ");
INSERT INTO sanben_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","তদা রাজা নিজানুচরান্ অৱদৎ, এতস্য করচরণান্ বদ্ধা যত্র রোদনং দন্তৈর্দন্তঘর্ষণঞ্চ ভৱতি, তত্র ৱহির্ভূততমিস্রে তং নিক্ষিপত| ");
INSERT INTO sanben_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","ইত্থং বহৱ আহূতা অল্পে মনোভিমতাঃ| ");
INSERT INTO sanben_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","অনন্তরং ফিরূশিনঃ প্রগত্য যথা সংলাপেন তম্ উন্মাথে পাতযেযুস্তথা মন্ত্রযিৎৱা ");
INSERT INTO sanben_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","হেরোদীযমনুজৈঃ সাকং নিজশিষ্যগণেন তং প্রতি কথযামাসুঃ, হে গুরো, ভৱান্ সত্যঃ সত্যমীশ্ৱরীযমার্গমুপদিশতি, কমপি মানুষং নানুরুধ্যতে, কমপি নাপেক্ষতে চ, তদ্ ৱযং জানীমঃ| ");
INSERT INTO sanben_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","অতঃ কৈসরভূপায করোঽস্মাকং দাতৱ্যো ন ৱা? অত্র ভৱতা কিং বুধ্যতে? তদ্ অস্মান্ ৱদতু| ");
INSERT INTO sanben_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","ততো যীশুস্তেষাং খলতাং ৱিজ্ঞায কথিতৱান্, রে কপটিনঃ যুযং কুতো মাং পরিক্ষধ্ৱে? ");
INSERT INTO sanben_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","তৎকরদানস্য মুদ্রাং মাং দর্শযত| তদানীং তৈস্তস্য সমীপং মুদ্রাচতুর্থভাগ আনীতে ");
INSERT INTO sanben_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","স তান্ পপ্রচ্ছ, অত্র কস্যেযং মূর্ত্তি র্নাম চাস্তে? তে জগদুঃ, কৈসরভূপস্য| ");
INSERT INTO sanben_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ততঃ স উক্তৱান, কৈসরস্য যৎ তৎ কৈসরায দত্ত, ঈশ্ৱরস্য যৎ তদ্ ঈশ্ৱরায দত্ত| ");
INSERT INTO sanben_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ইতি ৱাক্যং নিশম্য তে ৱিস্মযং ৱিজ্ঞায তং ৱিহায চলিতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","তস্মিন্নহনি সিদূকিনোঽর্থাৎ শ্মশানাৎ নোত্থাস্যন্তীতি ৱাক্যং যে ৱদন্তি, তে যীশেाরন্তিকম্ আগত্য পপ্রচ্ছুঃ, ");
INSERT INTO sanben_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","হে গুরো, কশ্চিন্মনুজশ্চেৎ নিঃসন্তানঃ সন্ প্রাণান্ ত্যজতি, তর্হি তস্য ভ্রাতা তস্য জাযাং ৱ্যুহ্য ভ্রাতুঃ সন্তানম্ উৎপাদযিষ্যতীতি মূসা আদিষ্টৱান্| ");
INSERT INTO sanben_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","কিন্ত্ৱস্মাকমত্র কেঽপি জনাঃ সপ্তসহোদরা আসন্, তেষাং জ্যেষ্ঠ একাং কন্যাং ৱ্যৱহাৎ, অপরং প্রাণত্যাগকালে স্ৱযং নিঃসন্তানঃ সন্ তাং স্ত্রিযং স্ৱভ্রাতরি সমর্পিতৱান্, ");
INSERT INTO sanben_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ততো দ্ৱিতীযাদিসপ্তমান্তাশ্চ তথৈৱ চক্রুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","শেষে সাপী নারী মমার| ");
INSERT INTO sanben_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","মৃতানাম্ উত্থানসমযে তেষাং সপ্তানাং মধ্যে সা নারী কস্য ভার্য্যা ভৱিষ্যতি? যস্মাৎ সর্ৱ্ৱএৱ তাং ৱ্যৱহন্| ");
INSERT INTO sanben_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ততো যীশুঃ প্রত্যৱাদীৎ, যূযং ধর্ম্মপুস্তকম্ ঈশ্ৱরীযাং শক্তিঞ্চ ন ৱিজ্ঞায ভ্রান্তিমন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","উত্থানপ্রাপ্তা লোকা ন ৱিৱহন্তি, ন চ ৱাচা দীযন্তে, কিন্ত্ৱীশ্ৱরস্য স্ৱর্গস্থদূতানাং সদৃশা ভৱন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","অপরং মৃতানামুত্থানমধি যুষ্মান্ প্রতীযমীশ্ৱরোক্তিঃ, ");
INSERT INTO sanben_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","\"অহমিব্রাহীম ঈশ্ৱর ইস্হাক ঈশ্ৱরো যাকূব ঈশ্ৱর\" ইতি কিং যুষ্মাভি র্নাপাঠি? কিন্ত্ৱীশ্ৱরো জীৱতাম্ ঈশ্ৱর:, স মৃতানামীশ্ৱরো নহি| ");
INSERT INTO sanben_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ইতি শ্রুৎৱা সর্ৱ্ৱে লোকাস্তস্যোপদেশাদ্ ৱিস্মযং গতাঃ| ");
INSERT INTO sanben_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","অনন্তরং সিদূকিনাম্ নিরুত্তরৎৱৱার্তাং নিশম্য ফিরূশিন একত্র মিলিতৱন্তঃ, ");
INSERT INTO sanben_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","তেষামেকো ৱ্যৱস্থাপকো যীশুং পরীক্ষিতুং পপচ্ছ, ");
INSERT INTO sanben_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","হে গুরো ৱ্যৱস্থাশাস্ত্রমধ্যে কাজ্ঞা শ্রেষ্ঠা? ");
INSERT INTO sanben_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ততো যীশুরুৱাচ, ৎৱং সর্ৱ্ৱান্তঃকরণৈঃ সর্ৱ্ৱপ্রাণৈঃ সর্ৱ্ৱচিত্তৈশ্চ সাকং প্রভৌ পরমেশ্ৱরে প্রীযস্ৱ, ");
INSERT INTO sanben_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","এষা প্রথমমহাজ্ঞা| তস্যাঃ সদৃশী দ্ৱিতীযাজ্ঞৈষা, ");
INSERT INTO sanben_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","তৱ সমীপৱাসিনি স্ৱাত্মনীৱ প্রেম কুরু| ");
INSERT INTO sanben_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","অনযো র্দ্ৱযোরাজ্ঞযোঃ কৃৎস্নৱ্যৱস্থাযা ভৱিষ্যদ্ৱক্তৃগ্রন্থস্য চ ভারস্তিষ্ঠতি| ");
INSERT INTO sanben_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","অনন্তরং ফিরূশিনাম্ একত্র স্থিতিকালে যীশুস্তান্ পপ্রচ্ছ, ");
INSERT INTO sanben_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","খ্রীষ্টমধি যুষ্মাকং কীদৃগ্বোধো জাযতে? স কস্য সন্তানঃ? ততস্তে প্রত্যৱদন্, দাযূদঃ সন্তানঃ| ");
INSERT INTO sanben_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","তদা স উক্তৱান্, তর্হি দাযূদ্ কথম্ আত্মাধিষ্ঠানেন তং প্রভুং ৱদতি ? ");
INSERT INTO sanben_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","যথা মম প্রভুমিদং ৱাক্যমৱদৎ পরমেশ্ৱরঃ| তৱারীন্ পাদপীঠং তে যাৱন্নহি করোম্যহং| তাৱৎ কালং মদীযে ৎৱং দক্ষপার্শ্ৱ উপাৱিশ| অতো যদি দাযূদ্ তং প্রভুং ৱদতি, র্তিহ স কথং তস্য সন্তানো ভৱতি? ");
INSERT INTO sanben_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","তদানীং তেষাং কোপি তদ্ৱাক্যস্য কিমপ্যুত্তরং দাতুং নাশক্নোৎ; ");
INSERT INTO sanben_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","তদ্দিনমারভ্য তং কিমপি ৱাক্যং প্রষ্টুং কস্যাপি সাহসো নাভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","অনন্তরং যীশু র্জননিৱহং শিষ্যাংশ্চাৱদৎ, ");
INSERT INTO sanben_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","অধ্যাপকাঃ ফিরূশিনশ্চ মূসাসনে উপৱিশন্তি, ");
INSERT INTO sanben_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","অতস্তে যুষ্মান্ যদ্যৎ মন্তুম্ আজ্ঞাপযন্তি, তৎ মন্যধ্ৱং পালযধ্ৱঞ্চ, কিন্তু তেষাং কর্ম্মানুরূপং কর্ম্ম ন কুরুধ্ৱং; যতস্তেষাং ৱাক্যমাত্রং সারং কার্য্যে কিমপি নাস্তি| ");
INSERT INTO sanben_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","তে দুর্ৱ্ৱহান্ গুরুতরান্ ভারান্ বদ্ৱ্ৱা মনুষ্যাণাং স্কন্ধেপরি সমর্পযন্তি, কিন্তু স্ৱযমঙ্গুল্যৈকযাপি ন চালযন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","কেৱলং লোকদর্শনায সর্ৱ্ৱকর্ম্মাণি কুর্ৱ্ৱন্তি; ফলতঃ পট্টবন্ধান্ প্রসার্য্য ধারযন্তি, স্ৱৱস্ত্রেষু চ দীর্ঘগ্রন্থীন্ ধারযন্তি; ");
INSERT INTO sanben_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ভোজনভৱন উচ্চস্থানং, ভজনভৱনে প্রধানমাসনং, ");
INSERT INTO sanben_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","হট্ঠে নমস্কারং গুরুরিতি সম্বোধনঞ্চৈতানি সর্ৱ্ৱাণি ৱাঞ্ছন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","কিন্তু যূযং গুরৱ ইতি সম্বোধনীযা মা ভৱত, যতো যুষ্মাকম্ একঃ খ্রীষ্টএৱ গুরু ");
INSERT INTO sanben_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","র্যূযং সর্ৱ্ৱে মিথো ভ্রাতরশ্চ| পুনঃ পৃথিৱ্যাং কমপি পিতেতি মা সম্বুধ্যধ্ৱং, যতো যুষ্মাকমেকঃ স্ৱর্গস্থএৱ পিতা| ");
INSERT INTO sanben_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","যূযং নাযকেতি সম্ভাষিতা মা ভৱত, যতো যুষ্মাকমেকঃ খ্রীষ্টএৱ নাযকঃ| ");
INSERT INTO sanben_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","অপরং যুষ্মাকং মধ্যে যঃ পুমান্ শ্রেষ্ঠঃ স যুষ্মান্ সেৱিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","যতো যঃ স্ৱমুন্নমতি, স নতঃ করিষ্যতে; কিন্তু যঃ কশ্চিৎ স্ৱমৱনতং করোতি, স উন্নতঃ করিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","হন্ত কপটিন উপাধ্যাযাঃ ফিরূশিনশ্চ, যূযং মনুজানাং সমক্ষং স্ৱর্গদ্ৱারং রুন্ধ, যূযং স্ৱযং তেন ন প্রৱিশথ, প্রৱিৱিক্ষূনপি ৱারযথ| ৱত কপটিন উপাধ্যাযাঃ ফিরূশিনশ্চ যূযং ছলাদ্ দীর্ঘং প্রার্থ্য ৱিধৱানাং সর্ৱ্ৱস্ৱং গ্রসথ, যুষ্মাকং ঘোরতরদণ্ডো ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","হন্ত কপটিন উপাধ্যাযাঃ ফিরূশিনশ্চ, যূযমেকং স্ৱধর্ম্মাৱলম্বিনং কর্ত্তুং সাগরং ভূমণ্ডলঞ্চ প্রদক্ষিণীকুরুথ, ");
INSERT INTO sanben_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","কঞ্চন প্রাপ্য স্ৱতো দ্ৱিগুণনরকভাজনং তং কুরুথ| ");
INSERT INTO sanben_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","ৱত অন্ধপথদর্শকাঃ সর্ৱ্ৱে, যূযং ৱদথ, মন্দিরস্য শপথকরণাৎ কিমপি ন দেযং; কিন্তু মন্দিরস্থসুৱর্ণস্য শপথকরণাদ্ দেযং| ");
INSERT INTO sanben_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","হে মূঢা হে অন্ধাঃ সুৱর্ণং তৎসুৱর্ণপাৱকমন্দিরম্ এতযোরুভযো র্মধ্যে কিং শ্রেযঃ? ");
INSERT INTO sanben_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","অন্যচ্চ ৱদথ, যজ্ঞৱেদ্যাঃ শপথকরণাৎ কিমপি ন দেযং, কিন্তু তদুপরিস্থিতস্য নৈৱেদ্যস্য শপথকরণাদ্ দেযং| ");
INSERT INTO sanben_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","হে মূঢা হে অন্ধাঃ, নৈৱেদ্যং তন্নৈৱেদ্যপাৱকৱেদিরেতযোরুভযো র্মধ্যে কিং শ্রেযঃ? ");
INSERT INTO sanben_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","অতঃ কেনচিদ্ যজ্ঞৱেদ্যাঃ শপথে কৃতে তদুপরিস্থস্য সর্ৱ্ৱস্য শপথঃ ক্রিযতে| ");
INSERT INTO sanben_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","কেনচিৎ মন্দিরস্য শপথে কৃতে মন্দিরতন্নিৱাসিনোঃ শপথঃ ক্রিযতে| ");
INSERT INTO sanben_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","কেনচিৎ স্ৱর্গস্য শপথে কৃতে ঈশ্ৱরীযসিংহাসনতদুপর্য্যুপৱিষ্টযোঃ শপথঃ ক্রিযতে| ");
INSERT INTO sanben_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","হন্ত কপটিন উপাধ্যাযাঃ ফিরূশিনশ্চ, যূযং পোদিনাযাঃ সিতচ্ছত্রাযা জীরকস্য চ দশমাংশান্ দত্থ, কিন্তু ৱ্যৱস্থাযা গুরুতরান্ ন্যাযদযাৱিশ্ৱাসান্ পরিত্যজথ; ইমে যুষ্মাভিরাচরণীযা অমী চ ন লংঘনীযাঃ| ");
INSERT INTO sanben_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","হে অন্ধপথদর্শকা যূযং মশকান্ অপসারযথ, কিন্তু মহাঙ্গান্ গ্রসথ| ");
INSERT INTO sanben_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","হন্ত কপটিন উপাধ্যাযাঃ ফিরূশিনশ্চ, যূযং পানপাত্রাণাং ভোজনপাত্রাণাঞ্চ বহিঃ পরিষ্কুরুথ; কিন্তু তদভ্যন্তরং দুরাত্মতযা কলুষেণ চ পরিপূর্ণমাস্তে| ");
INSERT INTO sanben_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","হে অন্ধাঃ ফিরূশিলোকা আদৌ পানপাত্রাণাং ভোজনপাত্রাণাঞ্চাভ্যন্তরং পরিষ্কুরুত, তেন তেষাং বহিরপি পরিষ্কারিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","হন্ত কপটিন উপাধ্যাযাঃ ফিরূশিনশ্চ, যূযং শুক্লীকৃতশ্মশানস্ৱরূপা ভৱথ, যথা শ্মশানভৱনস্য বহিশ্চারু, কিন্ত্ৱভ্যন্তরং মৃতলোকানাং কীকশৈঃ সর্ৱ্ৱপ্রকারমলেন চ পরিপূর্ণম্; ");
INSERT INTO sanben_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","তথৈৱ যূযমপি লোকানাং সমক্ষং বহির্ধার্ম্মিকাঃ কিন্ত্ৱন্তঃকরণেষু কেৱলকাপট্যাধর্ম্মাভ্যাং পরিপূর্ণাঃ| ");
INSERT INTO sanben_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","হা হা কপটিন উপাধ্যাযাঃ ফিরূশিনশ্চ, যূযং ভৱিষ্যদ্ৱাদিনাং শ্মশানগেহং নির্ম্মাথ, সাধূনাং শ্মশাননিকেতনং শোভযথ ");
INSERT INTO sanben_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ৱদথ চ যদি ৱযং স্ৱেষাং পূর্ৱ্ৱপুরুষাণাং কাল অস্থাস্যাম, তর্হি ভৱিষ্যদ্ৱাদিনাং শোণিতপাতনে তেষাং সহভাগিনো নাভৱিষ্যাম| ");
INSERT INTO sanben_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","অতো যূযং ভৱিষ্যদ্ৱাদিঘাতকানাং সন্তানা ইতি স্ৱযমেৱ স্ৱেষাং সাক্ষ্যং দত্থ| ");
INSERT INTO sanben_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","অতো যূযং নিজপূর্ৱ্ৱপুরুষাণাং পরিমাণপাত্রং পরিপূরযত| ");
INSERT INTO sanben_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","রে ভুজগাঃ কৃষ্ণভুজগৱংশাঃ, যূযং কথং নরকদণ্ডাদ্ রক্ষিষ্যধ্ৱে| ");
INSERT INTO sanben_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","পশ্যত, যুষ্মাকমন্তিকম্ অহং ভৱিষ্যদ্ৱাদিনো বুদ্ধিমত উপাধ্যাযাংশ্চ প্রেষযিষ্যামি, কিন্তু তেষাং কতিপযা যুষ্মাভি র্ঘানিষ্যন্তে, ক্রুশে চ ঘানিষ্যন্তে, কেচিদ্ ভজনভৱনে কষাভিরাঘানিষ্যন্তে, নগরে নগরে তাডিষ্যন্তে চ; ");
INSERT INTO sanben_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","তেন সৎপুরুষস্য হাবিলো রক্তপাতমারভ্য বেরিখিযঃ পুত্রং যং সিখরিযং যূযং মন্দিরযজ্ঞৱেদ্যো র্মধ্যে হতৱন্তঃ, তদীযশোণিতপাতং যাৱদ্ অস্মিন্ দেশে যাৱতাং সাধুপুরুষাণাং শোণিতপাতো ঽভৱৎ তৎ সর্ৱ্ৱেষামাগসাং দণ্ডা যুষ্মাসু ৱর্ত্তিষ্যন্তে| ");
INSERT INTO sanben_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","অহং যুষ্মান্ত তথ্যং ৱদামি, ৱিদ্যমানেঽস্মিন্ পুরুষে সর্ৱ্ৱে ৱর্ত্তিষ্যন্তে| ");
INSERT INTO sanben_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","হে যিরূশালম্ হে যিরূশালম্ নগরি ৎৱং ভৱিষ্যদ্ৱাদিনো হতৱতী, তৱ সমীপং প্রেরিতাংশ্চ পাষাণৈরাহতৱতী, যথা কুক্কুটী শাৱকান্ পক্ষাধঃ সংগৃহ্লাতি, তথা তৱ সন্তানান্ সংগ্রহীতুং অহং বহুৱারম্ ঐচ্ছং; কিন্তু ৎৱং ন সমমন্যথাঃ| ");
INSERT INTO sanben_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","পশ্যত যষ্মাকং ৱাসস্থানম্ উচ্ছিন্নং ত্যক্ষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","অহং যুষ্মান্ তথ্যং ৱদামি, যঃ পরমেশ্ৱরস্য নাম্নাগচ্ছতি, স ধন্য ইতি ৱাণীং যাৱন্ন ৱদিষ্যথ, তাৱৎ মাং পুন র্ন দ্রক্ষ্যথ| ");
INSERT INTO sanben_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","অনন্তরং যীশু র্যদা মন্দিরাদ্ বহি র্গচ্ছতি, তদানীং শিষ্যাস্তং মন্দিরনির্ম্মাণং দর্শযিতুমাগতাঃ| ");
INSERT INTO sanben_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ততো যীশুস্তানুৱাচ, যূযং কিমেতানি ন পশ্যথ? যুষ্মানহং সত্যং ৱদামি, এতন্নিচযনস্য পাষাণৈকমপ্যন্যপাষাণেाপরি ন স্থাস্যতি সর্ৱ্ৱাণি ভূমিসাৎ কারিষ্যন্তে| ");
INSERT INTO sanben_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","অনন্তরং তস্মিন্ জৈতুনপর্ৱ্ৱতোপরি সমুপৱিষ্টে শিষ্যাস্তস্য সমীপমাগত্য গুপ্তং পপ্রচ্ছুঃ, এতা ঘটনাঃ কদা ভৱিষ্যন্তি? ভৱত আগমনস্য যুগান্তস্য চ কিং লক্ষ্ম? তদস্মান্ ৱদতু| ");
INSERT INTO sanben_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","তদানীং যীশুস্তানৱোচৎ, অৱধদ্ৱ্ৱং, কোপি যুষ্মান্ ন ভ্রমযেৎ| ");
INSERT INTO sanben_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","বহৱো মম নাম গৃহ্লন্ত আগমিষ্যন্তি, খ্রীষ্টোঽহমেৱেতি ৱাচং ৱদন্তো বহূন্ ভ্রমযিষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","যূযঞ্চ সংগ্রামস্য রণস্য চাডম্বরং শ্রোষ্যথ, অৱধদ্ৱ্ৱং তেন চঞ্চলা মা ভৱত, এতান্যৱশ্যং ঘটিষ্যন্তে, কিন্তু তদা যুগান্তো নহি| ");
INSERT INTO sanben_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","অপরং দেশস্য ৱিপক্ষো দেশো রাজ্যস্য ৱিপক্ষো রাজ্যং ভৱিষ্যতি, স্থানে স্থানে চ দুর্ভিক্ষং মহামারী ভূকম্পশ্চ ভৱিষ্যন্তি, ");
INSERT INTO sanben_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","এতানি দুঃখোপক্রমাঃ| ");
INSERT INTO sanben_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","তদানীং লোকা দুঃখং ভোজযিতুং যুষ্মান্ পরকরেষু সমর্পযিষ্যন্তি হনিষ্যন্তি চ, তথা মম নামকারণাদ্ যূযং সর্ৱ্ৱদেশীযমনুজানাং সমীপে ঘৃণার্হা ভৱিষ্যথ| ");
INSERT INTO sanben_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","বহুষু ৱিঘ্নং প্রাপ্তৱৎসু পরস্পরম্ ঋृতীযাং কৃতৱৎসু চ একোঽপরং পরকরেষু সমর্পযিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","তথা বহৱো মৃষাভৱিষ্যদ্ৱাদিন উপস্থায বহূন্ ভ্রমযিষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","দুষ্কর্ম্মণাং বাহুল্যাঞ্চ বহূনাং প্রেম শীতলং ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","কিন্তু যঃ কশ্চিৎ শেষং যাৱদ্ ধৈর্য্যমাশ্রযতে, সএৱ পরিত্রাযিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","অপরং সর্ৱ্ৱদেশীযলোকান্ প্রতিমাক্ষী ভৱিতুং রাজস্য শুভসমাচারঃ সর্ৱ্ৱজগতি প্রচারিষ্যতে, এতাদৃশি সতি যুগান্ত উপস্থাস্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","অতো যৎ সর্ৱ্ৱনাশকৃদ্ঘৃণার্হং ৱস্তু দানিযেল্ভৱিষ্যদ্ৱদিনা প্রোক্তং তদ্ যদা পুণ্যস্থানে স্থাপিতং দ্রক্ষ্যথ, (যঃ পঠতি, স বুধ্যতাং) ");
INSERT INTO sanben_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","তদানীং যে যিহূদীযদেশে তিষ্ঠন্তি, তে পর্ৱ্ৱতেষু পলাযন্তাং| ");
INSERT INTO sanben_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","যঃ কশ্চিদ্ গৃহপৃষ্ঠে তিষ্ঠতি, স গৃহাৎ কিমপি ৱস্ত্ৱানেতুম্ অধেा নাৱরোহেৎ| ");
INSERT INTO sanben_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","যশ্চ ক্ষেত্রে তিষ্ঠতি, সোপি ৱস্ত্রমানেতুং পরাৱৃত্য ন যাযাৎ| ");
INSERT INTO sanben_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","তদানীং গর্ভিণীস্তন্যপাযযিত্রীণাং দুর্গতি র্ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","অতো যষ্মাকং পলাযনং শীতকালে ৱিশ্রামৱারে ৱা যন্ন ভৱেৎ, তদর্থং প্রার্থযধ্ৱম্| ");
INSERT INTO sanben_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","আ জগদারম্ভাদ্ এতৎকালপর্য্যনন্তং যাদৃশঃ কদাপি নাভৱৎ ন চ ভৱিষ্যতি তাদৃশো মহাক্লেশস্তদানীম্ উপস্থাস্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","তস্য ক্লেশস্য সমযো যদি হ্স্ৱো ন ক্রিযেত, তর্হি কস্যাপি প্রাণিনো রক্ষণং ভৱিতুং ন শক্নুযাৎ, কিন্তু মনোনীতমনুজানাং কৃতে স কালো হ্স্ৱীকরিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","অপরঞ্চ পশ্যত, খ্রীষ্টোঽত্র ৱিদ্যতে, ৱা তত্র ৱিদ্যতে, তদানীং যদী কশ্চিদ্ যুষ্মান ইতি ৱাক্যং ৱদতি, তথাপি তৎ ন প্রতীৎ| ");
INSERT INTO sanben_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","যতো ভাক্তখ্রীষ্টা ভাক্তভৱিষ্যদ্ৱাদিনশ্চ উপস্থায যানি মহন্তি লক্ষ্মাণি চিত্রকর্ম্মাণি চ প্রকাশযিষ্যন্তি, তৈ র্যদি সম্ভৱেৎ তর্হি মনোনীতমানৱা অপি ভ্রামিষ্যন্তে| ");
INSERT INTO sanben_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","পশ্যত, ঘটনাতঃ পূর্ৱ্ৱং যুষ্মান্ ৱার্ত্তাম্ অৱাদিষম্| ");
INSERT INTO sanben_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","অতঃ পশ্যত, স প্রান্তরে ৱিদ্যত ইতি ৱাক্যে কেনচিৎ কথিতেপি বহি র্মা গচ্ছত, ৱা পশ্যত, সোন্তঃপুরে ৱিদ্যতে, এতদ্ৱাক্য উক্তেপি মা প্রতীত| ");
INSERT INTO sanben_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","যতো যথা ৱিদ্যুৎ পূর্ৱ্ৱদিশো নির্গত্য পশ্চিমদিশং যাৱৎ প্রকাশতে, তথা মানুষপুত্রস্যাপ্যাগমনং ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","যত্র শৱস্তিষ্ঠতি, তত্রেৱ গৃধ্রা মিলন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","অপরং তস্য ক্লেশসমযস্যাৱ্যৱহিতপরত্র সূর্য্যস্য তেজো লোপ্স্যতে, চন্দ্রমা জ্যোস্নাং ন করিষ্যতি, নভসো নক্ষত্রাণি পতিষ্যন্তি, গগণীযা গ্রহাশ্চ ৱিচলিষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","তদানীম্ আকাশমধ্যে মনুজসুতস্য লক্ষ্ম দর্শিষ্যতে, ততো নিজপরাক্রমেণ মহাতেজসা চ মেঘারূঢং মনুজসুতং নভসাগচ্ছন্তং ৱিলোক্য পৃথিৱ্যাঃ সর্ৱ্ৱৱংশীযা ৱিলপিষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","তদানীং স মহাশব্দাযমানতূর্য্যা ৱাদকান্ নিজদূতান্ প্রহেষ্যতি, তে ৱ্যোম্ন একসীমাতোঽপরসীমাং যাৱৎ চতুর্দিশস্তস্য মনোনীতজনান্ আনীয মেলযিষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","উডুম্বরপাদপস্য দৃষ্টান্তং শিক্ষধ্ৱং; যদা তস্য নৱীনাঃ শাখা জাযন্তে, পল্লৱাদিশ্চ নির্গচ্ছতি, তদা নিদাঘকালঃ সৱিধো ভৱতীতি যূযং জানীথ; ");
INSERT INTO sanben_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","তদ্ৱদ্ এতা ঘটনা দৃষ্ট্ৱা স সমযো দ্ৱার উপাস্থাদ্ ইতি জানীত| ");
INSERT INTO sanben_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","যুষ্মানহং তথ্যং ৱদামি, ইদানীন্তনজনানাং গমনাৎ পূর্ৱ্ৱমেৱ তানি সর্ৱ্ৱাণি ঘটিষ্যন্তে| ");
INSERT INTO sanben_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","নভোমেদিন্যো র্লুপ্তযোরপি মম ৱাক্ কদাপি ন লোপ্স্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","অপরং মম তাতং ৱিনা মানুষঃ স্ৱর্গস্থো দূতো ৱা কোপি তদ্দিনং তদ্দণ্ডঞ্চ ন জ্ঞাপযতি| ");
INSERT INTO sanben_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","অপরং নোহে ৱিদ্যমানে যাদৃশমভৱৎ তাদৃশং মনুজসুতস্যাগমনকালেপি ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","ফলতো জলাপ্লাৱনাৎ পূর্ৱ্ৱং যদ্দিনং যাৱৎ নোহঃ পোতং নারোহৎ, তাৱৎকালং যথা মনুষ্যা ভোজনে পানে ৱিৱহনে ৱিৱাহনে চ প্রৱৃত্তা আসন্; ");
INSERT INTO sanben_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","অপরম্ আপ্লাৱিতোযমাগত্য যাৱৎ সকলমনুজান্ প্লাৱযিৎৱা নানযৎ, তাৱৎ তে যথা ন ৱিদামাসুঃ, তথা মনুজসুতাগমনেপি ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","তদা ক্ষেত্রস্থিতযোর্দ্ৱযোরেকো ধারিষ্যতে, অপরস্ত্যাজিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","তথা পেষণ্যা পিংষত্যোরুভযো র্যোষিতোরেকা ধারিষ্যতেঽপরা ত্যাজিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","যুষ্মাকং প্রভুঃ কস্মিন্ দণ্ড আগমিষ্যতি, তদ্ যুষ্মাভি র্নাৱগম্যতে, তস্মাৎ জাগ্রতঃ সন্তস্তিষ্ঠত| ");
INSERT INTO sanben_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","কুত্র যামে স্তেন আগমিষ্যতীতি চেদ্ গৃহস্থো জ্ঞাতুম্ অশক্ষ্যৎ, তর্হি জাগরিৎৱা তং সন্ধিং কর্ত্তিতুম্ অৱারযিষ্যৎ তদ্ জানীত| ");
INSERT INTO sanben_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","যুষ্মাভিরৱধীযতাং, যতো যুষ্মাভি র্যত্র ন বুধ্যতে, তত্রৈৱ দণ্ডে মনুজসুত আযাস্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","প্রভু র্নিজপরিৱারান্ যথাকালং ভোজযিতুং যং দাসম্ অধ্যক্ষীকৃত্য স্থাপযতি, তাদৃশো ৱিশ্ৱাস্যো ধীমান্ দাসঃ কঃ? ");
INSERT INTO sanben_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","প্রভুরাগত্য যং দাসং তথাচরন্তং ৱীক্ষতে, সএৱ ধন্যঃ| ");
INSERT INTO sanben_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","যুষ্মানহং সত্যং ৱদামি, স তং নিজসর্ৱ্ৱস্ৱস্যাধিপং করিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","কিন্তু প্রভুরাগন্তুং ৱিলম্বত ইতি মনসি চিন্তযিৎৱা যো দুষ্টো দাসো ");
INSERT INTO sanben_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ঽপরদাসান্ প্রহর্ত্তুং মত্তানাং সঙ্গে ভোক্তুং পাতুঞ্চ প্রৱর্ত্ততে, ");
INSERT INTO sanben_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","স দাসো যদা নাপেক্ষতে, যঞ্চ দণ্ডং ন জানাতি, তৎকালএৱ তৎপ্রভুরুপস্থাস্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","তদা তং দণ্ডযিৎৱা যত্র স্থানে রোদনং দন্তঘর্ষণঞ্চাসাতে, তত্র কপটিভিঃ সাকং তদ্দশাং নিরূপযিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","যা দশ কন্যাঃ প্রদীপান্ গৃহ্লত্যো ৱরং সাক্ষাৎ কর্ত্তুং বহিরিতাঃ, তাভিস্তদা স্ৱর্গীযরাজ্যস্য সাদৃশ্যং ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","তাসাং কন্যানাং মধ্যে পঞ্চ সুধিযঃ পঞ্চ দুর্ধিয আসন্| ");
INSERT INTO sanben_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","যা দুর্ধিযস্তাঃ প্রদীপান্ সঙ্গে গৃহীৎৱা তৈলং ন জগৃহুঃ, ");
INSERT INTO sanben_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","কিন্তু সুধিযঃ প্রদীপান্ পাত্রেণ তৈলঞ্চ জগৃহুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","অনন্তরং ৱরে ৱিলম্বিতে তাঃ সর্ৱ্ৱা নিদ্রাৱিষ্টা নিদ্রাং জগ্মুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","অনন্তরম্ অর্দ্ধরাত্রে পশ্যত ৱর আগচ্ছতি, তং সাক্ষাৎ কর্ত্তুং বহির্যাতেতি জনরৱাৎ ");
INSERT INTO sanben_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","তাঃ সর্ৱ্ৱাঃ কন্যা উত্থায প্রদীপান্ আসাদযিতুং আরভন্ত| ");
INSERT INTO sanben_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ততো দুর্ধিযঃ সুধিয ঊচুঃ, কিঞ্চিৎ তৈলং দত্ত, প্রদীপা অস্মাকং নির্ৱ্ৱাণাঃ| ");
INSERT INTO sanben_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","কিন্তু সুধিযঃ প্রত্যৱদন্, দত্তে যুষ্মানস্মাংশ্চ প্রতি তৈলং ন্যূনীভৱেৎ, তস্মাদ্ ৱিক্রেতৃণাং সমীপং গৎৱা স্ৱার্থং তৈলং ক্রীণীত| ");
INSERT INTO sanben_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","তদা তাসু ক্রেতুং গতাসু ৱর আজগাম, ততো যাঃ সজ্জিতা আসন্, তাস্তেন সাকং ৱিৱাহীযং ৱেশ্ম প্রৱিৱিশুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","অনন্তরং দ্ৱারে রুদ্ধে অপরাঃ কন্যা আগত্য জগদুঃ, হে প্রভো, হে প্রভো, অস্মান্ প্রতি দ্ৱারং মোচয| ");
INSERT INTO sanben_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","কিন্তু স উক্তৱান্, তথ্যং ৱদামি, যুষ্মানহং ন ৱেদ্মি| ");
INSERT INTO sanben_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","অতো জাগ্রতঃ সন্তস্তিষ্ঠত, মনুজসুতঃ কস্মিন্ দিনে কস্মিন্ দণ্ডে ৱাগমিষ্যতি, তদ্ যুষ্মাভি র্ন জ্ঞাযতে| ");
INSERT INTO sanben_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","অপরং স এতাদৃশঃ কস্যচিৎ পুংসস্তুল্যঃ, যো দূরদেশং প্রতি যাত্রাকালে নিজদাসান্ আহূয তেষাং স্ৱস্ৱসামর্থ্যানুরূপম্ ");
INSERT INTO sanben_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","একস্মিন্ মুদ্রাণাং পঞ্চ পোটলিকাঃ অন্যস্মিংশ্চ দ্ৱে পোটলিকে অপরস্মিংশ্চ পোটলিকৈকাম্ ইত্থং প্রতিজনং সমর্প্য স্ৱযং প্রৱাসং গতৱান্| ");
INSERT INTO sanben_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","অনন্তরং যো দাসঃ পঞ্চ পোটলিকাঃ লব্ধৱান্, স গৎৱা ৱাণিজ্যং ৱিধায তা দ্ৱিগুণীচকার| ");
INSERT INTO sanben_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","যশ্চ দাসো দ্ৱে পোটলিকে অলভত, সোপি তা মুদ্রা দ্ৱিগুণীচকার| ");
INSERT INTO sanben_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","কিন্তু যো দাস একাং পোটলিকাং লব্ধৱান্, স গৎৱা ভূমিং খনিৎৱা তন্মধ্যে নিজপ্রভোস্তা মুদ্রা গোপযাঞ্চকার| ");
INSERT INTO sanben_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","তদনন্তরং বহুতিথে কালে গতে তেষাং দাসানাং প্রভুরাগত্য তৈর্দাসৈঃ সমং গণযাঞ্চকার| ");
INSERT INTO sanben_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","তদানীং যঃ পঞ্চ পোটলিকাঃ প্রাপ্তৱান্ স তা দ্ৱিগুণীকৃতমুদ্রা আনীয জগাদ; হে প্রভো, ভৱতা মযি পঞ্চ পোটলিকাঃ সমর্পিতাঃ, পশ্যতু, তা মযা দ্ৱিগুণীকৃতাঃ| ");
INSERT INTO sanben_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","তদানীং তস্য প্রভুস্তমুৱাচ, হে উত্তম ৱিশ্ৱাস্য দাস, ৎৱং ধন্যোসি, স্তোকেন ৱিশ্ৱাস্যো জাতঃ, তস্মাৎ ৎৱাং বহুৱিত্তাধিপং করোমি, ৎৱং স্ৱপ্রভোঃ সুখস্য ভাগী ভৱ| ");
INSERT INTO sanben_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","ততো যেন দ্ৱে পোটলিকে লব্ধে সোপ্যাগত্য জগাদ, হে প্রভো, ভৱতা মযি দ্ৱে পোটলিকে সমর্পিতে, পশ্যতু তে মযা দ্ৱিগুণীকৃতে| ");
INSERT INTO sanben_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","তেন তস্য প্রভুস্তমৱোচৎ, হে উত্তম ৱিশ্ৱাস্য দাস, ৎৱং ধন্যোসি, স্তোকেন ৱিশ্ৱাস্যো জাতঃ, তস্মাৎ ৎৱাং বহুদ্রৱিণাধিপং করোমি, ৎৱং নিজপ্রভোঃ সুখস্য ভাগী ভৱ| ");
INSERT INTO sanben_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","অনন্তরং য একাং পোটলিকাং লব্ধৱান্, স এত্য কথিতৱান্, হে প্রভো, ৎৱাং কঠিননরং জ্ঞাতৱান্, ৎৱযা যত্র নোপ্তং, তত্রৈৱ কৃত্যতে, যত্র চ ন কীর্ণং, তত্রৈৱ সংগৃহ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","অতোহং সশঙ্কঃ সন্ গৎৱা তৱ মুদ্রা ভূমধ্যে সংগোপ্য স্থাপিতৱান্, পশ্য, তৱ যৎ তদেৱ গৃহাণ| ");
INSERT INTO sanben_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","তদা তস্য প্রভুঃ প্রত্যৱদৎ রে দুষ্টালস দাস, যত্রাহং ন ৱপামি, তত্র ছিনদ্মি, যত্র চ ন কিরামি, তত্রেৱ সংগৃহ্লামীতি চেদজানাস্তর্হি ");
INSERT INTO sanben_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ৱণিক্ষু মম ৱিত্তার্পণং তৱোচিতমাসীৎ, যেনাহমাগত্য ৱৃদ্ৱ্যা সাকং মূলমুদ্রাঃ প্রাপ্স্যম্| ");
INSERT INTO sanben_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","অতোস্মাৎ তাং পোটলিকাম্ আদায যস্য দশ পোটলিকাঃ সন্তি তস্মিন্নর্পযত| ");
INSERT INTO sanben_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","যেন ৱর্দ্ৱ্যতে তস্মিন্নৈৱার্পিষ্যতে, তস্যৈৱ চ বাহুল্যং ভৱিষ্যতি, কিন্তু যেন ন ৱর্দ্ৱ্যতে, তস্যান্তিকে যৎ কিঞ্চন তিষ্ঠতি, তদপি পুনর্নেষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","অপরং যূযং তমকর্ম্মণ্যং দাসং নীৎৱা যত্র স্থানে ক্রন্দনং দন্তঘর্ষণঞ্চ ৱিদ্যেতে, তস্মিন্ বহির্ভূততমসি নিক্ষিপত| ");
INSERT INTO sanben_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","যদা মনুজসুতঃ পৱিত্রদূতান্ সঙ্গিনঃ কৃৎৱা নিজপ্রভাৱেনাগত্য নিজতেজোমযে সিংহাসনে নিৱেক্ষ্যতি, ");
INSERT INTO sanben_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","তদা তৎসম্মুখে সর্ৱ্ৱজাতীযা জনা সংমেলিষ্যন্তি| ততো মেষপালকো যথা ছাগেভ্যোঽৱীন্ পৃথক্ করোতি তথা সোপ্যেকস্মাদন্যম্ ইত্থং তান্ পৃথক কৃৎৱাৱীন্ ");
INSERT INTO sanben_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","দক্ষিণে ছাগাংশ্চ ৱামে স্থাপযিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","ততঃ পরং রাজা দক্ষিণস্থিতান্ মানৱান্ ৱদিষ্যতি, আগচ্ছত মত্তাতস্যানুগ্রহভাজনানি, যুষ্মৎকৃত আ জগদারম্ভৎ যদ্ রাজ্যম্ আসাদিতং তদধিকুরুত| ");
INSERT INTO sanben_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","যতো বুভুক্ষিতায মহ্যং ভোজ্যম্ অদত্ত, পিপাসিতায পেযমদত্ত, ৱিদেশিনং মাং স্ৱস্থানমনযত, ");
INSERT INTO sanben_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ৱস্ত্রহীনং মাং ৱসনং পর্য্যধাপযত, পীডীতং মাং দ্রষ্টুমাগচ্ছত, কারাস্থঞ্চ মাং ৱীক্ষিতুম আগচ্ছত| ");
INSERT INTO sanben_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","তদা ধার্ম্মিকাঃ প্রতিৱদিষ্যন্তি, হে প্রভো, কদা ৎৱাং ক্ষুধিতং ৱীক্ষ্য ৱযমভোজযাম? ৱা পিপাসিতং ৱীক্ষ্য অপাযযাম? ");
INSERT INTO sanben_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","কদা ৱা ৎৱাং ৱিদেশিনং ৱিলোক্য স্ৱস্থানমনযাম? কদা ৱা ৎৱাং নগ্নং ৱীক্ষ্য ৱসনং পর্য্যধাপযাম? ");
INSERT INTO sanben_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","কদা ৱা ৎৱাং পীডিতং কারাস্থঞ্চ ৱীক্ষ্য ৎৱদন্তিকমগচ্ছাম? ");
INSERT INTO sanben_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","তদানীং রাজা তান্ প্রতিৱদিষ্যতি, যুষ্মানহং সত্যং ৱদামি, মমৈতেষাং ভ্রাতৃণাং মধ্যে কঞ্চনৈকং ক্ষুদ্রতমং প্রতি যদ্ অকুরুত, তন্মাং প্রত্যকুরুত| ");
INSERT INTO sanben_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","পশ্চাৎ স ৱামস্থিতান্ জনান্ ৱদিষ্যতি, রে শাপগ্রস্তাঃ সর্ৱ্ৱে, শৈতানে তস্য দূতেভ্যশ্চ যোঽনন্তৱহ্নিরাসাদিত আস্তে, যূযং মদন্তিকাৎ তমগ্নিং গচ্ছত| ");
INSERT INTO sanben_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","যতো ক্ষুধিতায মহ্যমাহারং নাদত্ত, পিপাসিতায মহ্যং পেযং নাদত্ত, ");
INSERT INTO sanben_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ৱিদেশিনং মাং স্ৱস্থানং নানযত, ৱসনহীনং মাং ৱসনং ন পর্য্যধাপযত, পীডিতং কারাস্থঞ্চ মাং ৱীক্ষিতুং নাগচ্ছত| ");
INSERT INTO sanben_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","তদা তে প্রতিৱদিষ্যন্তি, হে প্রভো, কদা ৎৱাং ক্ষুধিতং ৱা পিপাসিতং ৱা ৱিদেশিনং ৱা নগ্নং ৱা পীডিতং ৱা কারাস্থং ৱীক্ষ্য ৎৱাং নাসেৱামহি? ");
INSERT INTO sanben_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","তদা স তান্ ৱদিষ্যতি, তথ্যমহং যুষ্মান্ ব্রৱীমি, যুষ্মাভিরেষাং কঞ্চন ক্ষোদিষ্ঠং প্রতি যন্নাকারি, তন্মাং প্রত্যেৱ নাকারি| ");
INSERT INTO sanben_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","পশ্চাদম্যনন্তশাস্তিং কিন্তু ধার্ম্মিকা অনন্তাযুষং ভোক্তুং যাস্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","যীশুরেতান্ প্রস্তাৱান্ সমাপ্য শিষ্যানূচে, ");
INSERT INTO sanben_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","যুষ্মাভি র্জ্ঞাতং দিনদ্ৱযাৎ পরং নিস্তারমহ উপস্থাস্যতি, তত্র মনুজসুতঃ ক্রুশেন হন্তুং পরকরেষু সমর্পিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","ততঃ পরং প্রধানযাজকাধ্যাপকপ্রাঞ্চঃ কিযফানাম্নো মহাযাজকস্যাট্টালিকাযাং মিলিৎৱা ");
INSERT INTO sanben_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","কেনোপাযেন যীশুং ধৃৎৱা হন্তুং শক্নুযুরিতি মন্ত্রযাঞ্চক্রুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","কিন্তু তৈরুক্তং মহকালে ন ধর্ত্তৱ্যঃ, ধৃতে প্রজানাং কলহেন ভৱিতুং শক্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","ততো বৈথনিযাপুরে শিমোনাখ্যস্য কুষ্ঠিনো ৱেশ্মনি যীশৌ তিষ্ঠতি ");
INSERT INTO sanben_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","কাচন যোষা শ্ৱেতোপলভাজনেন মহার্ঘ্যং সুগন্ধি তৈলমানীয ভোজনাযোপৱিশতস্তস্য শিরোভ্যষেচৎ| ");
INSERT INTO sanben_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","কিন্তু তদালোক্য তচ্ছিষ্যৈঃ কুপিতৈরুক্তং, কুত ইত্থমপৱ্যযতে? ");
INSERT INTO sanben_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","চেদিদং ৱ্যক্রেষ্যত, তর্হি ভূরিমূল্যং প্রাপ্য দরিদ্রেভ্যো ৱ্যতারিষ্যত| ");
INSERT INTO sanben_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","যীশুনা তদৱগত্য তে সমুদিতাঃ, যোষামেনাং কুতো দুঃখিনীং কুরুথ, সা মাং প্রতি সাধু কর্ম্মাকার্ষীৎ| ");
INSERT INTO sanben_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","যুষ্মাকমং সমীপে দরিদ্রাঃ সততমেৱাসতে, কিন্তু যুষ্মাকমন্তিকেহং নাসে সততং| ");
INSERT INTO sanben_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","সা মম কাযোপরি সুগন্ধিতৈলং সিক্ত্ৱা মম শ্মশানদানকর্ম্মাকার্ষীৎ| ");
INSERT INTO sanben_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","অতোহং যুষ্মান্ তথ্যং ৱদামি সর্ৱ্ৱস্মিন্ জগতি যত্র যত্রৈষ সুসমাচারঃ প্রচারিষ্যতে, তত্র তত্রৈতস্যা নার্য্যাঃ স্মরণার্থম্ কর্ম্মেদং প্রচারিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","ততো দ্ৱাদশশিষ্যাণাম্ ঈষ্করিযোতীযযিহূদানামক একঃ শিষ্যঃ প্রধানযাজকানামন্তিকং গৎৱা কথিতৱান্, ");
INSERT INTO sanben_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","যদি যুষ্মাকং করেষু যীশুং সমর্পযামি, তর্হি কিং দাস্যথ? তদানীং তে তস্মৈ ত্রিংশন্মুদ্রা দাতুং স্থিরীকৃতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","স তদারভ্য তং পরকরেষু সমর্পযিতুং সুযোগং চেষ্টিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","অনন্তরং কিণ্ৱশূন্যপূপপর্ৱ্ৱণঃ প্রথমেহ্নি শিষ্যা যীশুম্ উপগত্য পপ্রচ্ছুঃ ভৱৎকৃতে কুত্র ৱযং নিস্তারমহভোজ্যম্ আযোজযিষ্যামঃ? ভৱতঃ কেচ্ছা? ");
INSERT INTO sanben_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","তদা স গদিতৱান্, মধ্যেনগরমমুকপুংসঃ সমীপং ৱ্রজিৎৱা ৱদত, গুরু র্গদিতৱান্, মৎকালঃ সৱিধঃ, সহ শিষ্যৈস্ত্ৱদালযে নিস্তারমহভোজ্যং ভোক্ষ্যে| ");
INSERT INTO sanben_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","তদা শিষ্যা যীশোস্তাদৃশনিদেশানুরূপকর্ম্ম ৱিধায তত্র নিস্তারমহভোজ্যমাসাদযামাসুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ততঃ সন্ধ্যাযাং সত্যাং দ্ৱাদশভিঃ শিষ্যৈঃ সাকং স ন্যৱিশৎ| ");
INSERT INTO sanben_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","অপরং ভুঞ্জান উক্তৱান্ যুষ্মান্ তথ্যং ৱদামি, যুষ্মাকমেকো মাং পরকরেষু সমর্পযিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","তদা তেঽতীৱ দুঃখিতা একৈকশো ৱক্তুমারেভিরে, হে প্রভো, স কিমহং? ");
INSERT INTO sanben_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ততঃ স জগাদ, মযা সাকং যো জনো ভোজনপাত্রে করং সংক্ষিপতি, স এৱ মাং পরকরেষু সমর্পযিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","মনুজসুতমধি যাদৃশং লিখিতমাস্তে, তদনুরূপা তদ্গতি র্ভৱিষ্যতি; কিন্তু যেন পুংসা স পরকরেষু সমর্পযিষ্যতে, হা হা চেৎ স নাজনিষ্যত, তদা তস্য ক্ষেমমভৱিষ্যৎ| ");
INSERT INTO sanben_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","তদা যিহূদানামা যো জনস্তং পরকরেষু সমর্পযিষ্যতি, স উক্তৱান্, হে গুরো, স কিমহং? ততঃ স প্রত্যুক্তৱান্, ৎৱযা সত্যং গদিতম্| ");
INSERT INTO sanben_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","অনন্তরং তেষামশনকালে যীশুঃ পূপমাদাযেশ্ৱরীযগুণাননূদ্য ভংক্ত্ৱা শিষ্যেভ্যঃ প্রদায জগাদ, মদ্ৱপুঃস্ৱরূপমিমং গৃহীৎৱা খাদত| ");
INSERT INTO sanben_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","পশ্চাৎ স কংসং গৃহ্লন্ ঈশ্ৱরীযগুণাননূদ্য তেভ্যঃ প্রদায কথিতৱান্, সর্ৱ্ৱৈ র্যুষ্মাভিরনেন পাতৱ্যং, ");
INSERT INTO sanben_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","যস্মাদনেকেষাং পাপমর্ষণায পাতিতং যন্মন্নূত্ননিযমরূপশোণিতং তদেতৎ| ");
INSERT INTO sanben_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","অপরমহং নূত্নগোস্তনীরসং ন পাস্যামি, তাৱৎ গোস্তনীফলরসং পুনঃ কদাপি ন পাস্যামি| ");
INSERT INTO sanben_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","পশ্চাৎ তে গীতমেকং সংগীয জৈতুনাখ্যগিরিং গতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","তদানীং যীশুস্তানৱোচৎ, অস্যাং রজন্যামহং যুষ্মাকং সর্ৱ্ৱেষাং ৱিঘ্নরূপো ভৱিষ্যামি, যতো লিখিতমাস্তে, \"মেষাণাং রক্ষকো যস্তং প্রহরিষ্যাম্যহং ততঃ| মেষাণাং নিৱহো নূনং প্রৱিকীর্ণো ভৱিষ্যতি\"|| ");
INSERT INTO sanben_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","কিন্তু শ্মশানাৎ সমুত্থায যুষ্মাকমগ্রেঽহং গালীলং গমিষ্যামি| ");
INSERT INTO sanben_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","পিতরস্তং প্রোৱাচ, ভৱাংশ্চেৎ সর্ৱ্ৱেষাং ৱিঘ্নরূপো ভৱতি, তথাপি মম ন ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ততো যীশুনা স উক্তঃ, তুভ্যমহং তথ্যং কথযামি, যামিন্যামস্যাং চরণাযুধস্য রৱাৎ পূর্ৱ্ৱং ৎৱং মাং ত্রি র্নাঙ্গীকরিষ্যসি| ");
INSERT INTO sanben_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ততঃ পিতর উদিতৱান্, যদ্যপি ৎৱযা সমং মর্ত্তৱ্যং, তথাপি কদাপি ৎৱাং ন নাঙ্গীকরিষ্যামি; তথৈৱ সর্ৱ্ৱে শিষ্যাশ্চোচুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","অনন্তরং যীশুঃ শিষ্যৈঃ সাকং গেৎশিমানীনামকং স্থানং প্রস্থায তেভ্যঃ কথিতৱান্, অদঃ স্থানং গৎৱা যাৱদহং প্রার্থযিষ্যে তাৱদ্ যূযমত্রোপৱিশত| ");
INSERT INTO sanben_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","পশ্চাৎ স পিতরং সিৱদিযসুতৌ চ সঙ্গিনঃ কৃৎৱা গতৱান্, শোকাকুলোঽতীৱ ৱ্যথিতশ্চ বভূৱ| ");
INSERT INTO sanben_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","তানৱাদীচ্চ মৃতিযাতনেৱ মৎপ্রাণানাং যাতনা জাযতে, যূযমত্র মযা সার্দ্ধং জাগৃত| ");
INSERT INTO sanben_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ততঃ স কিঞ্চিদ্দূরং গৎৱাধোমুখঃ পতন্ প্রার্থযাঞ্চক্রে, হে মৎপিতর্যদি ভৱিতুং শক্নোতি, তর্হি কংসোঽযং মত্তো দূরং যাতু; কিন্তু মদিচ্ছাৱৎ ন ভৱতু, ৎৱদিচ্ছাৱদ্ ভৱতু| ");
INSERT INTO sanben_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ততঃ স শিষ্যানুপেত্য তান্ নিদ্রতো নিরীক্ষ্য পিতরায কথযামাস, যূযং মযা সাকং দণ্ডমেকমপি জাগরিতুং নাশন্কুত? ");
INSERT INTO sanben_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","পরীক্ষাযাং ন পতিতুং জাগৃত প্রার্থযধ্ৱঞ্চ; আত্মা সমুদ্যতোস্তি, কিন্তু ৱপু র্দুর্ব্বলং| ");
INSERT INTO sanben_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","স দ্ৱিতীযৱারং প্রার্থযাঞ্চক্রে, হে মত্তাত, ন পীতে যদি কংসমিদং মত্তো দূরং যাতুং ন শক্নোতি, তর্হি ৎৱদিচ্ছাৱদ্ ভৱতু| ");
INSERT INTO sanben_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","স পুনরেত্য তান্ নিদ্রতো দদর্শ, যতস্তেষাং নেত্রাণি নিদ্রযা পূর্ণান্যাসন্| ");
INSERT INTO sanben_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","পশ্চাৎ স তান্ ৱিহায ৱ্রজিৎৱা তৃতীযৱারং পূর্ৱ্ৱৱৎ কথযন্ প্রার্থিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ততঃ শিষ্যানুপাগত্য গদিতৱান্, সাম্প্রতং শযানাঃ কিং ৱিশ্রাম্যথ? পশ্যত, সময উপাস্থাৎ, মনুজসুতঃ পাপিনাং করেষু সমর্প্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","উত্তিষ্ঠত, ৱযং যামঃ, যো মাং পরকরেষু মসর্পযিষ্যতি, পশ্যত, স সমীপমাযাতি| ");
INSERT INTO sanben_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","এতৎকথাকথনকালে দ্ৱাদশশিষ্যাণামেকো যিহূদানামকো মুখ্যযাজকলোকপ্রাচীনৈঃ প্রহিতান্ অসিধারিযষ্টিধারিণো মনুজান্ গৃহীৎৱা তৎসমীপমুপতস্থৌ| ");
INSERT INTO sanben_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","অসৌ পরকরেষ্ৱর্পযিতা পূর্ৱ্ৱং তান্ ইত্থং সঙ্কেতযামাস, যমহং চুম্বিষ্যে, সোঽসৌ মনুজঃ,সএৱ যুষ্মাভি র্ধার্য্যতাং| ");
INSERT INTO sanben_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","তদা স সপদি যীশুমুপাগত্য হে গুরো, প্রণমামীত্যুক্ত্ৱা তং চুচুম্বে| ");
INSERT INTO sanben_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","তদা যীশুস্তমুৱাচ, হে মিত্রং কিমর্থমাগতোসি? তদা তৈরাগত্য যীশুরাক্রম্য দঘ্রে| ");
INSERT INTO sanben_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ততো যীশোঃ সঙ্গিনামেকঃ করং প্রসার্য্য কোষাদসিং বহিষ্কৃত্য মহাযাজকস্য দাসমেকমাহত্য তস্য কর্ণং চিচ্ছেদ| ");
INSERT INTO sanben_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","ততো যীশুস্তং জগাদ, খড্গং স্ৱস্থানেे নিধেহি যতো যে যে জনা অসিং ধারযন্তি, তএৱাসিনা ৱিনশ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","অপরং পিতা যথা মদন্তিকং স্ৱর্গীযদূতানাং দ্ৱাদশৱাহিনীতোঽধিকং প্রহিণুযাৎ মযা তমুদ্দিশ্যেদানীমেৱ তথা প্রার্থযিতুং ন শক্যতে, ৎৱযা কিমিত্থং জ্ঞাযতে? ");
INSERT INTO sanben_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","তথা সতীত্থং ঘটিষ্যতে ধর্ম্মপুস্তকস্য যদিদং ৱাক্যং তৎ কথং সিধ্যেৎ? ");
INSERT INTO sanben_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","তদানীং যীশু র্জননিৱহং জগাদ, যূযং খড্গযষ্টীন্ আদায মাং কিং চৌরং ধর্ত্তুমাযাতাঃ? অহং প্রত্যহং যুষ্মাভিঃ সাকমুপৱিশ্য সমুপাদিশং, তদা মাং নাধরত; ");
INSERT INTO sanben_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","কিন্তু ভৱিষ্যদ্ৱাদিনাং ৱাক্যানাং সংসিদ্ধযে সর্ৱ্ৱমেতদভূৎ| তদা সর্ৱ্ৱে শিষ্যাস্তং ৱিহায পলাযন্ত| ");
INSERT INTO sanben_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","অনন্তরং তে মনুজা যীশুং ধৃৎৱা যত্রাধ্যাপকপ্রাঞ্চঃ পরিষদং কুর্ৱ্ৱন্ত উপাৱিশন্ তত্র কিযফানাाমকমহাযাজকস্যান্তিকং নিন্যুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","কিন্তু শেষে কিং ভৱিষ্যতীতি ৱেত্তুং পিতরো দূরে তৎপশ্চাদ্ ৱ্রজিৎৱা মহাযাজকস্যাট্টালিকাং প্রৱিশ্য দাসৈঃ সহিত উপাৱিশৎ| ");
INSERT INTO sanben_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","তদানীং প্রধানযাজকপ্রাচীনমন্ত্রিণঃ সর্ৱ্ৱে যীশুং হন্তুং মৃষাসাক্ষ্যম্ অলিপ্সন্ত, ");
INSERT INTO sanben_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","কিন্তু ন লেভিরে| অনেকেষু মৃষাসাক্ষিষ্ৱাগতেষ্ৱপি তন্ন প্রাপুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","শেষে দ্ৱৌ মৃষাসাক্ষিণাৱাগত্য জগদতুঃ, পুমানযমকথযৎ, অহমীশ্ৱরমন্দিরং ভংক্ত্ৱা দিনত্রযমধ্যে তন্নির্ম্মাতুং শক্নোমি| ");
INSERT INTO sanben_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","তদা মহাযাজক উত্থায যীশুম্ অৱাদীৎ| ৎৱং কিমপি ন প্রতিৱদসি? ৎৱামধি কিমেতে সাক্ষ্যং ৱদন্তি? ");
INSERT INTO sanben_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","কিন্তু যীশু র্মৌনীভূয তস্যৌ| ততো মহাযাজক উক্তৱান্, ৎৱাম্ অমরেশ্ৱরনাম্না শপযামি, ৎৱমীশ্ৱরস্য পুত্রোঽভিষিক্তো ভৱসি নৱেতি ৱদ| ");
INSERT INTO sanben_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","যীশুঃ প্রত্যৱদৎ, ৎৱং সত্যমুক্তৱান্; অহং যুষ্মান্ তথ্যং ৱদামি, ইতঃপরং মনুজসুতং সর্ৱ্ৱশক্তিমতো দক্ষিণপার্শ্ৱে স্থাতুং গগণস্থং জলধরানারুহ্যাযান্তং ৱীক্ষধ্ৱে| ");
INSERT INTO sanben_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","তদা মহাযাজকো নিজৱসনং ছিত্ত্ৱা জগাদ, এষ ঈশ্ৱরং নিন্দিতৱান্, অস্মাকমপরসাক্ষ্যেণ কিং প্রযোজনং? পশ্যত, যূযমেৱাস্যাস্যাদ্ ঈশ্ৱরনিন্দাং শ্রুতৱন্তঃ, ");
INSERT INTO sanben_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","যুষ্মাভিঃ কিং ৱিৱিচ্যতে? তে প্রত্যূচুঃ, ৱধার্হোঽযং| ");
INSERT INTO sanben_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ততো লোকৈস্তদাস্যে নিষ্ঠীৱিতং কেচিৎ প্রতলমাহত্য কেচিচ্চ চপেটমাহত্য বভাষিরে, ");
INSERT INTO sanben_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","হে খ্রীষ্ট ৎৱাং কশ্চপেটমাহতৱান্? ইতি গণযিৎৱা ৱদাস্মান্| ");
INSERT INTO sanben_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","পিতরো বহিরঙ্গন উপৱিশতি, তদানীমেকা দাসী তমুপাগত্য বভাষে, ৎৱং গালীলীযযীশোঃ সহচরএকঃ| ");
INSERT INTO sanben_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","কিন্তু স সর্ৱ্ৱেষাং সমক্ষম্ অনঙ্গীকৃত্যাৱাদীৎ, ৎৱযা যদুচ্যতে, তদর্থমহং ন ৱেদ্মি| ");
INSERT INTO sanben_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","তদা তস্মিন্ বহির্দ্ৱারং গতে ঽন্যা দাসী তং নিরীক্ষ্য তত্রত্যজনানৱদৎ, অযমপি নাসরতীযযীশুনা সার্দ্ধম্ আসীৎ| ");
INSERT INTO sanben_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","ততঃ স শপথেন পুনরনঙ্গীকৃত্য কথিতৱান্, তং নরং ন পরিচিনোমি| ");
INSERT INTO sanben_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ক্ষণাৎ পরং তিষ্ঠন্তো জনা এত্য পিতরম্ অৱদন্, ৎৱমৱশ্যং তেষামেক ইতি ৎৱদুচ্চারণমেৱ দ্যোতযতি| ");
INSERT INTO sanben_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","কিন্তু সোঽভিশপ্য কথিতৱান্, তং জনং নাহং পরিচিনোমি, তদা সপদি কুক্কুটো রুরাৱ| ");
INSERT INTO sanben_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","কুক্কুটরৱাৎ প্রাক্ ৎৱং মাং ত্রিরপাহ্নোষ্যসে, যৈষা ৱাগ্ যীশুনাৱাদি তাং পিতরঃ সংস্মৃত্য বহিরিৎৱা খেদাদ্ ভৃশং চক্রন্দ| ");
INSERT INTO sanben_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","প্রভাতে জাতে প্রধানযাজকলোকপ্রাচীনা যীশুং হন্তুং তৎপ্রতিকূলং মন্ত্রযিৎৱা ");
INSERT INTO sanben_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","তং বদ্ৱ্ৱা নীৎৱা পন্তীযপীলাতাখ্যাধিপে সমর্পযামাসুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","ততো যীশোঃ পরকরেৱ্ৱর্পযিতা যিহূদাস্তৎপ্রাণাদণ্ডাজ্ঞাং ৱিদিৎৱা সন্তপ্তমনাঃ প্রধানযাজকলোকপ্রাচীনানাং সমক্ষং তাস্ত্রীংশন্মুদ্রাঃ প্রতিদাযাৱাদীৎ, ");
INSERT INTO sanben_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","এতন্নিরাগোনরপ্রাণপরকরার্পণাৎ কলুষং কৃতৱানহং| তদা ত উদিতৱন্তঃ, তেনাস্মাকং কিং? ৎৱযা তদ্ বুধ্যতাম্| ");
INSERT INTO sanben_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ততো যিহূদা মন্দিরমধ্যে তা মুদ্রা নিক্ষিপ্য প্রস্থিতৱান্ ইৎৱা চ স্ৱযমাত্মানমুদ্ববন্ধ| ");
INSERT INTO sanben_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","পশ্চাৎ প্রধানযাজকাস্তা মুদ্রা আদায কথিতৱন্তঃ, এতা মুদ্রাঃ শোণিতমূল্যং তস্মাদ্ ভাণ্ডাগারে ন নিধাতৱ্যাঃ| ");
INSERT INTO sanben_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","অনন্তরং তে মন্ত্রযিৎৱা ৱিদেশিনাং শ্মশানস্থানায তাভিঃ কুলালস্য ক্ষেত্রমক্রীণন্| ");
INSERT INTO sanben_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","অতোঽদ্যাপি তৎস্থানং রক্তক্ষেত্রং ৱদন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ইত্থং সতি ইস্রাযেলীযসন্তানৈ র্যস্য মূল্যং নিরুপিতং, তস্য ত্রিংশন্মুদ্রামানং মূল্যং ");
INSERT INTO sanben_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","মাং প্রতি পরমেশ্ৱরস্যাদেশাৎ তেভ্য আদীযত, তেন চ কুলালস্য ক্ষেত্রং ক্রীতমিতি যদ্ৱচনং যিরিমিযভৱিষ্যদ্ৱাদিনা প্রোক্তং তৎ তদাসিধ্যৎ| ");
INSERT INTO sanben_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","অনন্তরং যীশৌ তদধিপতেঃ সম্মুখ উপতিষ্ঠতি স তং পপ্রচ্ছ, ৎৱং কিং যিহূদীযানাং রাজা? তদা যীশুস্তমৱদৎ, ৎৱং সত্যমুক্তৱান্| ");
INSERT INTO sanben_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","কিন্তু প্রধানযাজকপ্রাচীনৈরভিযুক্তেন তেন কিমপি ন প্রত্যৱাদি| ");
INSERT INTO sanben_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","ততঃ পীলাতেন স উদিতঃ, ইমে ৎৱৎপ্রতিকূলতঃ কতি কতি সাক্ষ্যং দদতি, তৎ ৎৱং ন শৃণোষি? ");
INSERT INTO sanben_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","তথাপি স তেষামেকস্যাপি ৱচস উত্তরং নোদিতৱান্; তেন সোঽধিপতি র্মহাচিত্রং ৱিদামাস| ");
INSERT INTO sanben_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","অন্যচ্চ তন্মহকালেঽধিপতেরেতাদৃশী রাতিরাসীৎ, প্রজা যং কঞ্চন বন্ধিনং যাচন্তে, তমেৱ স মোচযতীতি| ");
INSERT INTO sanben_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","তদানীং বরব্বানামা কশ্চিৎ খ্যাতবন্ধ্যাসীৎ| ");
INSERT INTO sanben_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ততঃ পীলাতস্তত্র মিলিতান্ লোকান্ অপৃচ্ছৎ, এষ বরব্বা বন্ধী খ্রীষ্টৱিখ্যাতো যীশুশ্চৈতযোঃ কং মোচযিষ্যামি? যুষ্মাকং কিমীপ্সিতং? ");
INSERT INTO sanben_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","তৈরীর্ষ্যযা স সমর্পিত ইতি স জ্ঞাতৱান্| ");
INSERT INTO sanben_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","অপরং ৱিচারাসনোপৱেশনকালে পীলাতস্য পত্নী ভৃত্যং প্রহিত্য তস্মৈ কথযামাস, তং ধার্ম্মিকমনুজং প্রতি ৎৱযা কিমপি ন কর্ত্তৱ্যং; যস্মাৎ তৎকৃতেঽদ্যাহং স্ৱপ্নে প্রভূতকষ্টমলভে| ");
INSERT INTO sanben_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","অনন্তরং প্রধানযাজকপ্রাচীনা বরব্বাং যাচিৎৱাদাতুং যীশুঞ্চ হন্তুং সকললোকান্ প্রাৱর্ত্তযন্| ");
INSERT INTO sanben_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ততোঽধিপতিস্তান্ পৃষ্টৱান্, এতযোঃ কমহং মোচযিষ্যামি? যুষ্মাকং কেচ্ছা? তে প্রোচু র্বরব্বাং| ");
INSERT INTO sanben_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","তদা পীলাতঃ পপ্রচ্ছ, তর্হি যং খ্রীষ্টং ৱদন্তি, তং যীশুং কিং করিষ্যামি? সর্ৱ্ৱে কথযামাসুঃ, স ক্রুশেন ৱিধ্যতাং| ");
INSERT INTO sanben_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ততোঽধিপতিরৱাদীৎ, কুতঃ? কিং তেনাপরাদ্ধং? কিন্তু তে পুনরুচৈ র্জগদুঃ, স ক্রুশেন ৱিধ্যতাং| ");
INSERT INTO sanben_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","তদা নিজৱাক্যমগ্রাহ্যমভূৎ, কলহশ্চাপ্যভূৎ, পীলাত ইতি ৱিলোক্য লোকানাং সমক্ষং তোযমাদায করৌ প্রক্ষাল্যাৱোচৎ, এতস্য ধার্ম্মিকমনুষ্যস্য শোণিতপাতে নির্দোষোঽহং, যুষ্মাভিরেৱ তদ্ বুধ্যতাং| ");
INSERT INTO sanben_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","তদা সর্ৱ্ৱাঃ প্রজাঃ প্রত্যৱোচন্, তস্য শোণিতপাতাপরাধোঽস্মাকম্ অস্মৎসন্তানানাঞ্চোপরি ভৱতু| ");
INSERT INTO sanben_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","ততঃ স তেষাং সমীপে বরব্বাং মোচযামাস যীশুন্তু কষাভিরাহত্য ক্রুশেন ৱেধিতুং সমর্পযামাস| ");
INSERT INTO sanben_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","অনন্তরম্ অধিপতেঃ সেনা অধিপতে র্গৃহং যীশুমানীয তস্য সমীপে সেনাসমূহং সংজগৃহুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ততস্তে তস্য ৱসনং মোচযিৎৱা কৃষ্ণলোহিতৱর্ণৱসনং পরিধাপযামাসুঃ ");
INSERT INTO sanben_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","কণ্টকানাং মুকুটং নির্ম্মায তচ্ছিরসি দদুঃ, তস্য দক্ষিণকরে ৱেত্রমেকং দত্ত্ৱা তস্য সম্মুখে জানূনি পাতযিৎৱা, হে যিহূদীযানাং রাজন্, তুভ্যং নম ইত্যুক্ত্ৱা তং তিরশ্চক্রুঃ, ");
INSERT INTO sanben_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ততস্তস্য গাত্রে নিষ্ঠীৱং দৎৱা তেন ৱেত্রেণ শির আজঘ্নুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ইত্থং তং তিরস্কৃত্য তদ্ ৱসনং মোচযিৎৱা পুনর্নিজৱসনং পরিধাপযাঞ্চক্রুঃ, তং ক্রুশেন ৱেধিতুং নীতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","পশ্চাত্তে বহির্ভূয কুরীণীযং শিমোন্নামকমেকং ৱিলোক্য ক্রুশং ৱোঢুং তমাদদিরে| ");
INSERT INTO sanben_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","অনন্তরং গুল্গল্তাম্ অর্থাৎ শিরস্কপালনামকস্থানমু পস্থায তে যীশৱে পিত্তমিশ্রিতাম্লরসং পাতুং দদুঃ, ");
INSERT INTO sanben_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","কিন্তু স তমাস্ৱাদ্য ন পপৌ| ");
INSERT INTO sanben_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","তদানীং তে তং ক্রুশেন সংৱিধ্য তস্য ৱসনানি গুটিকাপাতেন ৱিভজ্য জগৃহুঃ, তস্মাৎ, ৱিভজন্তেঽধরীযং মে তে মনুষ্যাঃ পরস্পরং| মদুত্তরীযৱস্ত্রার্থং গুটিকাং পাতযন্তি চ|| যদেতদ্ৱচনং ভৱিষ্যদ্ৱাদিভিরুক্তমাসীৎ, তদা তদ্ অসিধ্যৎ, ");
INSERT INTO sanben_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","পশ্চাৎ তে তত্রোপৱিশ্য তদ্রক্ষণকর্ৱ্ৱণি নিযুক্তাস্তস্থুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","অপরম্ এষ যিহূদীযানাং রাজা যীশুরিত্যপৱাদলিপিপত্রং তচ্ছিরস ঊর্দ্ৱ্ৱে যোজযামাসুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ততস্তস্য ৱামে দক্ষিণে চ দ্ৱৌ চৈরৌ তেন সাকং ক্রুশেন ৱিৱিধুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","তদা পান্থা নিজশিরো লাডযিৎৱা তং নিন্দন্তো জগদুঃ, ");
INSERT INTO sanben_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","হে ঈশ্ৱরমন্দিরভঞ্জক দিনত্রযে তন্নির্ম্মাতঃ স্ৱং রক্ষ, চেত্ত্ৱমীশ্ৱরসুতস্তর্হি ক্রুশাদৱরোহ| ");
INSERT INTO sanben_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","প্রধানযাজকাধ্যাপকপ্রাচীনাশ্চ তথা তিরস্কৃত্য জগদুঃ, ");
INSERT INTO sanben_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","সোঽন্যজনানাৱৎ, কিন্তু স্ৱমৱিতুং ন শক্নোতি| যদীস্রাযেলো রাজা ভৱেৎ, তর্হীদানীমেৱ ক্রুশাদৱরোহতু, তেন তং ৱযং প্রত্যেষ্যামঃ| ");
INSERT INTO sanben_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","স ঈশ্ৱরে প্রত্যাশামকরোৎ, যদীশ্ৱরস্তস্মিন্ সন্তুষ্টস্তর্হীদানীমেৱ তমৱেৎ, যতঃ স উক্তৱান্ অহমীশ্ৱরসুতঃ| ");
INSERT INTO sanben_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","যৌ স্তেনৌ সাকং তেন ক্রুশেন ৱিদ্ধৌ তৌ তদ্ৱদেৱ তং নিনিন্দতুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","তদা দ্ৱিতীযযামাৎ তৃতীযযামং যাৱৎ সর্ৱ্ৱদেশে তমিরং বভূৱ, ");
INSERT INTO sanben_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","তৃতীযযামে \"এলী এলী লামা শিৱক্তনী\", অর্থাৎ মদীশ্ৱর মদীশ্ৱর কুতো মামত্যাক্ষীঃ? যীশুরুচ্চৈরিতি জগাদ| ");
INSERT INTO sanben_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","তদা তত্র স্থিতাঃ কেচিৎ তৎ শ্রুৎৱা বভাষিরে, অযম্ এলিযমাহূযতি| ");
INSERT INTO sanben_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","তেষাং মধ্যাদ্ একঃ শীঘ্রং গৎৱা স্পঞ্জং গৃহীৎৱা তত্রাম্লরসং দত্ত্ৱা নলেন পাতুং তস্মৈ দদৌ| ");
INSERT INTO sanben_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ইতরেঽকথযন্ তিষ্ঠত, তং রক্ষিতুম্ এলিয আযাতি নৱেতি পশ্যামঃ| ");
INSERT INTO sanben_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","যীশুঃ পুনরুচৈরাহূয প্রাণান্ জহৌ| ");
INSERT INTO sanben_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","ততো মন্দিরস্য ৱিচ্ছেদৱসনম্ ঊর্দ্ৱ্ৱাদধো যাৱৎ ছিদ্যমানং দ্ৱিধাভৱৎ, ");
INSERT INTO sanben_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ভূমিশ্চকম্পে ভূধরোৱ্যদীর্য্যত চ| শ্মশানে মুক্তে ভূরিপুণ্যৱতাং সুপ্তদেহা উদতিষ্ঠন্, ");
INSERT INTO sanben_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","শ্মশানাদ্ ৱহির্ভূয তদুত্থানাৎ পরং পুণ্যপুরং গৎৱা বহুজনান্ দর্শযামাসুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","যীশুরক্ষণায নিযুক্তঃ শতসেনাপতিস্তৎসঙ্গিনশ্চ তাদৃশীং ভূকম্পাদিঘটনাং দৃষ্ট্ৱা ভীতা অৱদন্, এষ ঈশ্ৱরপুত্রো ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","যা বহুযোষিতো যীশুং সেৱমানা গালীলস্তৎপশ্চাদাগতাস্তাসাং মধ্যে ");
INSERT INTO sanben_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","মগ্দলীনী মরিযম্ যাকূব্যোশ্যো র্মাতা যা মরিযম্ সিবদিযপুত্রযো র্মাতা চ যোষিত এতা দূরে তিষ্ঠন্ত্যো দদৃশুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","সন্ধ্যাযাং সত্যম্ অরিমথিযানগরস্য যূষফ্নামা ধনী মনুজো যীশোঃ শিষ্যৎৱাৎ ");
INSERT INTO sanben_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","পীলাতস্য সমীপং গৎৱা যীশোঃ কাযং যযাচে, তেন পীলাতঃ কাযং দাতুম্ আদিদেশ| ");
INSERT INTO sanben_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","যূষফ্ তৎকাযং নীৎৱা শুচিৱস্ত্রেণাচ্ছাদ্য ");
INSERT INTO sanben_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","স্ৱার্থং শৈলে যৎ শ্মশানং চখান, তন্মধ্যে তৎকাযং নিধায তস্য দ্ৱারি ৱৃহৎপাষাণং দদৌ| ");
INSERT INTO sanben_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","কিন্তু মগ্দলীনী মরিযম্ অন্যমরিযম্ এতে স্ত্রিযৌ তত্র শ্মশানসম্মুখ উপৱিৱিশতুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","তদনন্তরং নিস্তারোৎসৱস্যাযোজনদিনাৎ পরেঽহনি প্রধানযাজকাঃ ফিরূশিনশ্চ মিলিৎৱা পীলাতমুপাগত্যাকথযন্, ");
INSERT INTO sanben_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","হে মহেচ্ছ স প্রতারকো জীৱন অকথযৎ, দিনত্রযাৎ পরং শ্মশানাদুত্থাস্যামি তদ্ৱাক্যং স্মরামো ৱযং; ");
INSERT INTO sanben_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","তস্মাৎ তৃতীযদিনং যাৱৎ তৎ শ্মশানং রক্ষিতুমাদিশতু, নোচেৎ তচ্ছিষ্যা যামিন্যামাগত্য তং হৃৎৱা লোকান্ ৱদিষ্যন্তি, স শ্মশানাদুদতিষ্ঠৎ, তথা সতি প্রথমভ্রান্তেঃ শেষীযভ্রান্তি র্মহতী ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","তদা পীলাত অৱাদীৎ, যুষ্মাকং সমীপে রক্ষিগণ আস্তে, যূযং গৎৱা যথা সাধ্যং রক্ষযত| ");
INSERT INTO sanben_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ততস্তে গৎৱা তদ্দূाরপাষাণং মুদ্রাঙ্কিতং কৃৎৱা রক্ষিগণং নিযোজ্য শ্মশানং রক্ষযামাসুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ততঃ পরং ৱিশ্রামৱারস্য শেষে সপ্তাহপ্রথমদিনস্য প্রভোতে জাতে মগ্দলীনী মরিযম্ অন্যমরিযম্ চ শ্মশানং দ্রষ্টুমাগতা| ");
INSERT INTO sanben_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","তদা মহান্ ভূকম্পোঽভৱৎ; পরমেশ্ৱরীযদূতঃ স্ৱর্গাদৱরুহ্য শ্মশানদ্ৱারাৎ পাষাণমপসার্য্য তদুপর্য্যুপৱিৱেশ| ");
INSERT INTO sanben_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","তদ্ৱদনং ৱিদ্যুদ্ৱৎ তেজোমযং ৱসনং হিমশুভ্রঞ্চ| ");
INSERT INTO sanben_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","তদানীং রক্ষিণস্তদ্ভযাৎ কম্পিতা মৃতৱদ্ বভূৱঃ| ");
INSERT INTO sanben_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","স দূতো যোষিতো জগাদ, যূযং মা ভৈষ্ট, ক্রুশহতযীশুং মৃগযধ্ৱে তদহং ৱেদ্মি| ");
INSERT INTO sanben_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","সোঽত্র নাস্তি, যথাৱদৎ তথোত্থিতৱান্; এতৎ প্রভোঃ শযনস্থানং পশ্যত| ");
INSERT INTO sanben_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","তূর্ণং গৎৱা তচ্ছিষ্যান্ ইতি ৱদত, স শ্মশানাদ্ উদতিষ্ঠৎ, যুষ্মাকমগ্রে গালীলং যাস্যতি যূযং তত্র তং ৱীক্ষিষ্যধ্ৱে, পশ্যতাহং ৱার্ত্তামিমাং যুষ্মানৱাদিষং| ");
INSERT INTO sanben_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ততস্তা ভযাৎ মহানন্দাঞ্চ শ্মশানাৎ তূর্ণং বহির্ভূয তচ্ছিষ্যান্ ৱার্ত্তাং ৱক্তুং ধাৱিতৱত্যঃ| কিন্তু শিষ্যান্ ৱার্ত্তাং ৱক্তুং যান্তি, তদা যীশু র্দর্শনং দত্ত্ৱা তা জগাদ, ");
INSERT INTO sanben_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","যুষ্মাকং কল্যাণং ভূযাৎ, ততস্তা আগত্য তৎপাদযোঃ পতিৎৱা প্রণেমুঃ| ");
INSERT INTO sanben_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","যীশুস্তা অৱাদীৎ, মা বিভীত, যূযং গৎৱা মম ভ্রাতৃন্ গালীলং যাতুং ৱদত, তত্র তে মাং দ্রক্ষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","স্ত্রিযো গচ্ছন্তি, তদা রক্ষিণাং কেচিৎ পুরং গৎৱা যদ্যদ্ ঘটিতং তৎসর্ৱ্ৱং প্রধানযাজকান্ জ্ঞাপিতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","তে প্রাচীনৈঃ সমং সংসদং কৃৎৱা মন্ত্রযন্তো বহুমুদ্রাঃ সেনাভ্যো দত্ত্ৱাৱদন্, ");
INSERT INTO sanben_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","অস্মাসু নিদ্রিতেষু তচ্ছিষ্যা যামিন্যামাগত্য তং হৃৎৱানযন্, ইতি যূযং প্রচারযত| ");
INSERT INTO sanben_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","যদ্যেতদধিপতেঃ শ্রোত্রগোচরীভৱেৎ, তর্হি তং বোধযিৎৱা যুষ্মানৱিষ্যামঃ| ");
INSERT INTO sanben_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","ততস্তে মুদ্রা গৃহীৎৱা শিক্ষানুরূপং কর্ম্ম চক্রুঃ, যিহূদীযানাং মধ্যে তস্যাদ্যাপি কিংৱদন্তী ৱিদ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","একাদশ শিষ্যা যীশুনিরূপিতাগালীলস্যাদ্রিং গৎৱা ");
INSERT INTO sanben_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","তত্র তং সংৱীক্ষ্য প্রণেমুঃ, কিন্তু কেচিৎ সন্দিগ্ধৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","যীশুস্তেষাং সমীপমাগত্য ৱ্যাহৃতৱান্, স্ৱর্গমেদিন্যোঃ সর্ৱ্ৱাধিপতিৎৱভারো ময্যর্পিত আস্তে| ");
INSERT INTO sanben_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","অতো যূযং প্রযায সর্ৱ্ৱদেশীযান্ শিষ্যান্ কৃৎৱা পিতুঃ পুত্রস্য পৱিত্রস্যাত্মনশ্চ নাম্না তানৱগাহযত; অহং যুষ্মান্ যদ্যদাদিশং তদপি পালযিতুং তানুপাদিশত| ");
INSERT INTO sanben_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","পশ্যত, জগদন্তং যাৱৎ সদাহং যুষ্মাভিঃ সাকং তিষ্ঠামি| ইতি|");
INSERT INTO sanben_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ঈশ্ৱরপুত্রস্য যীশুখ্রীষ্টস্য সুসংৱাদারম্ভঃ| ");
INSERT INTO sanben_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ভৱিষ্যদ্ৱাদিনাং গ্রন্থেষু লিপিরিত্থমাস্তে, পশ্য স্ৱকীযদূতন্তু তৱাগ্রে প্রেষযাম্যহম্| গৎৱা ৎৱদীযপন্থানং স হি পরিষ্করিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","\"পরমেশস্য পন্থানং পরিষ্কুরুত সর্ৱ্ৱতঃ| তস্য রাজপথঞ্চৈৱ সমানং কুরুতাধুনা| \" ইত্যেতৎ প্রান্তরে ৱাক্যং ৱদতঃ কস্যচিদ্রৱঃ|| ");
INSERT INTO sanben_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","সএৱ যোহন্ প্রান্তরে মজ্জিতৱান্ তথা পাপমার্জননিমিত্তং মনোৱ্যাৱর্ত্তকমজ্জনস্য কথাঞ্চ প্রচারিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ততো যিহূদাদেশযিরূশালম্নগরনিৱাসিনঃ সর্ৱ্ৱে লোকা বহি র্ভূৎৱা তস্য সমীপমাগত্য স্ৱানি স্ৱানি পাপান্যঙ্গীকৃত্য যর্দ্দননদ্যাং তেন মজ্জিতা বভূৱুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","অস্য যোহনঃ পরিধেযানি ক্রমেলকলোমজানি, তস্য কটিবন্ধনং চর্ম্মজাতম্, তস্য ভক্ষ্যাণি চ শূককীটা ৱন্যমধূনি চাসন্| ");
INSERT INTO sanben_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","স প্রচারযন্ কথযাঞ্চক্রে, অহং নম্রীভূয যস্য পাদুকাবন্ধনং মোচযিতুমপি ন যোগ্যোস্মি, তাদৃশো মত্তো গুরুতর একঃ পুরুষো মৎপশ্চাদাগচ্ছতি| ");
INSERT INTO sanben_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","অহং যুষ্মান্ জলে মজ্জিতৱান্ কিন্তু স পৱিত্র আত্মানি সংমজ্জযিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","অপরঞ্চ তস্মিন্নেৱ কালে গালীল্প্রদেশস্য নাসরদ্গ্রামাদ্ যীশুরাগত্য যোহনা যর্দ্দননদ্যাং মজ্জিতোঽভূৎ| ");
INSERT INTO sanben_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","স জলাদুত্থিতমাত্রো মেঘদ্ৱারং মুক্তং কপোতৱৎ স্ৱস্যোপরি অৱরোহন্তমাত্মানঞ্চ দৃষ্টৱান্| ");
INSERT INTO sanben_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ৎৱং মম প্রিযঃ পুত্রস্ত্ৱয্যেৱ মমমহাসন্তোষ ইযমাকাশীযা ৱাণী বভূৱ| ");
INSERT INTO sanben_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","তস্মিন্ কালে আত্মা তং প্রান্তরমধ্যং নিনায| ");
INSERT INTO sanben_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","অথ স চৎৱারিংশদ্দিনানি তস্মিন্ স্থানে ৱন্যপশুভিঃ সহ তিষ্ঠন্ শৈতানা পরীক্ষিতঃ; পশ্চাৎ স্ৱর্গীযদূতাস্তং সিষেৱিরে| ");
INSERT INTO sanben_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","অনন্তরং যোহনি বন্ধনালযে বদ্ধে সতি যীশু র্গালীল্প্রদেশমাগত্য ঈশ্ৱররাজ্যস্য সুসংৱাদং প্রচারযন্ কথযামাস, ");
INSERT INTO sanben_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","কালঃ সম্পূর্ণ ঈশ্ৱররাজ্যঞ্চ সমীপমাগতং; অতোহেতো র্যূযং মনাংসি ৱ্যাৱর্ত্তযধ্ৱং সুসংৱাদে চ ৱিশ্ৱাসিত| ");
INSERT INTO sanben_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","তদনন্তরং স গালীলীযসমুদ্রস্য তীরে গচ্ছন্ শিমোন্ তস্য ভ্রাতা অন্দ্রিযনামা চ ইমৌ দ্ৱৌ জনৌ মৎস্যধারিণৌ সাগরমধ্যে জালং প্রক্ষিপন্তৌ দৃষ্ট্ৱা তাৱৱদৎ, ");
INSERT INTO sanben_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","যুৱাং মম পশ্চাদাগচ্ছতং, যুৱামহং মনুষ্যধারিণৌ করিষ্যামি| ");
INSERT INTO sanben_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ততস্তৌ তৎক্ষণমেৱ জালানি পরিত্যজ্য তস্য পশ্চাৎ জগ্মতুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ততঃ পরং তৎস্থানাৎ কিঞ্চিদ্ দূরং গৎৱা স সিৱদীপুত্রযাকূব্ তদ্ভ্রাতৃযোহন্ চ ইমৌ নৌকাযাং জালানাং জীর্ণমুদ্ধারযন্তৌ দৃষ্ট্ৱা তাৱাহূযৎ| ");
INSERT INTO sanben_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ততস্তৌ নৌকাযাং ৱেতনভুগ্ভিঃ সহিতং স্ৱপিতরং ৱিহায তৎপশ্চাদীযতুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ততঃ পরং কফর্নাহূম্নামকং নগরমুপস্থায স ৱিশ্রামদিৱসে ভজনগ্রহং প্রৱিশ্য সমুপদিদেশ| ");
INSERT INTO sanben_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","তস্যোপদেশাল্লোকা আশ্চর্য্যং মেনিরে যতঃ সোধ্যাপকাইৱ নোপদিশন্ প্রভাৱৱানিৱ প্রোপদিদেশ| ");
INSERT INTO sanben_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","অপরঞ্চ তস্মিন্ ভজনগৃহে অপৱিত্রভূতেন গ্রস্ত একো মানুষ আসীৎ| স চীৎশব্দং কৃৎৱা কথযাঞ্চকে ");
INSERT INTO sanben_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ভো নাসরতীয যীশো ৎৱমস্মান্ ত্যজ, ৎৱযা সহাস্মাকং কঃ সম্বন্ধঃ? ৎৱং কিমস্মান্ নাশযিতুং সমাগতঃ? ৎৱমীশ্ৱরস্য পৱিত্রলোক ইত্যহং জানামি| ");
INSERT INTO sanben_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","তদা যীশুস্তং তর্জযিৎৱা জগাদ তূষ্ণীং ভৱ ইতো বহির্ভৱ চ| ");
INSERT INTO sanben_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ততঃ সোঽপৱিত্রভূতস্তং সম্পীড্য অত্যুচৈশ্চীৎকৃত্য নির্জগাম| ");
INSERT INTO sanben_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","তেনৈৱ সর্ৱ্ৱে চমৎকৃত্য পরস্পরং কথযাঞ্চক্রিরে, অহো কিমিদং? কীদৃশোঽযং নৱ্য উপদেশঃ? অনেন প্রভাৱেনাপৱিত্রভূতেষ্ৱাজ্ঞাপিতেষু তে তদাজ্ঞানুৱর্ত্তিনো ভৱন্তি| ");
INSERT INTO sanben_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","তদা তস্য যশো গালীলশ্চতুর্দিক্স্থসর্ৱ্ৱদেশান্ ৱ্যাপ্নোৎ| ");
INSERT INTO sanben_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","অপরঞ্চ তে ভজনগৃহাদ্ বহি র্ভূৎৱা যাকূব্যোহন্ভ্যাং সহ শিমোন আন্দ্রিযস্য চ নিৱেশনং প্রৱিৱিশুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","তদা পিতরস্য শ্ৱশ্রূর্জ্ৱরপীডিতা শয্যাযামাস্ত ইতি তে তং ঝটিতি ৱিজ্ঞাপযাঞ্চক্রুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ততঃ স আগত্য তস্যা হস্তং ধৃৎৱা তামুদস্থাপযৎ; তদৈৱ তাং জ্ৱরোঽত্যাক্ষীৎ ততঃ পরং সা তান্ সিষেৱে| ");
INSERT INTO sanben_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","অথাস্তং গতে রৱৌ সন্ধ্যাকালে সতি লোকাস্তৎসমীপং সর্ৱ্ৱান্ রোগিণো ভূতধৃতাংশ্চ সমানিন্যুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","সর্ৱ্ৱে নাগরিকা লোকা দ্ৱারি সংমিলিতাশ্চ| ");
INSERT INTO sanben_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ততঃ স নানাৱিধরোগিণো বহূন্ মনুজানরোগিণশ্চকার তথা বহূন্ ভূতান্ ত্যাজযাঞ্চকার তান্ ভূতান্ কিমপি ৱাক্যং ৱক্তুং নিষিষেধ চ যতোহেতোস্তে তমজানন্| ");
INSERT INTO sanben_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","অপরঞ্চ সোঽতিপ্রত্যূষে ৱস্তুতস্তু রাত্রিশেষে সমুত্থায বহির্ভূয নির্জনং স্থানং গৎৱা তত্র প্রার্থযাঞ্চক্রে| ");
INSERT INTO sanben_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","অনন্তরং শিমোন্ তৎসঙ্গিনশ্চ তস্য পশ্চাদ্ গতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","তদুদ্দেশং প্রাপ্য তমৱদন্ সর্ৱ্ৱে লোকাস্ত্ৱাং মৃগযন্তে| ");
INSERT INTO sanben_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","তদা সোঽকথযৎ আগচ্ছত ৱযং সমীপস্থানি নগরাণি যামঃ, যতোঽহং তত্র কথাং প্রচারযিতুং বহিরাগমম্| ");
INSERT INTO sanben_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","অথ স তেষাং গালীল্প্রদেশস্য সর্ৱ্ৱেষু ভজনগৃহেষু কথাঃ প্রচারযাঞ্চক্রে ভূতানত্যাজযঞ্চ| ");
INSERT INTO sanben_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","অনন্তরমেকঃ কুষ্ঠী সমাগত্য তৎসম্মুখে জানুপাতং ৱিনযঞ্চ কৃৎৱা কথিতৱান্ যদি ভৱান্ ইচ্ছতি তর্হি মাং পরিষ্কর্ত্তুং শক্নোতি| ");
INSERT INTO sanben_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ততঃ কৃপালু র্যীশুঃ করৌ প্রসার্য্য তং স্পষ্ট্ৱা কথযামাস ");
INSERT INTO sanben_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","মমেচ্ছা ৱিদ্যতে ৎৱং পরিষ্কৃতো ভৱ| এতৎকথাযাঃ কথনমাত্রাৎ স কুষ্ঠী রোগান্মুক্তঃ পরিষ্কৃতোঽভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","তদা স তং ৱিসৃজন্ গাঢমাদিশ্য জগাদ ");
INSERT INTO sanben_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","সাৱধানো ভৱ কথামিমাং কমপি মা ৱদ; স্ৱাত্মানং যাজকং দর্শয, লোকেভ্যঃ স্ৱপরিষ্কৃতেঃ প্রমাণদানায মূসানির্ণীতং যদ্দানং তদুৎসৃজস্ৱ চ| ");
INSERT INTO sanben_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","কিন্তু স গৎৱা তৎ কর্ম্ম ইত্থং ৱিস্তার্য্য প্রচারযিতুং প্রারেভে তেনৈৱ যীশুঃ পুনঃ সপ্রকাশং নগরং প্রৱেষ্টুং নাশক্নোৎ ততোহেতোর্বহিঃ কাননস্থানে তস্যৌ; তথাপি চতুর্দ্দিগ্ভ্যো লোকাস্তস্য সমীপমাযযুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","তদনন্তরং যীশৈ কতিপযদিনানি ৱিলম্ব্য পুনঃ কফর্নাহূম্নগরং প্রৱিষ্টে স গৃহ আস্ত ইতি কিংৱদন্ত্যা তৎক্ষণং তৎসমীপং বহৱো লোকা আগত্য সমুপতস্থুঃ, ");
INSERT INTO sanben_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","তস্মাদ্ গৃহমধ্যে সর্ৱ্ৱেষাং কৃতে স্থানং নাভৱদ্ দ্ৱারস্য চতুর্দিক্ষ্ৱপি নাভৱৎ, তৎকালে স তান্ প্রতি কথাং প্রচারযাঞ্চক্রে| ");
INSERT INTO sanben_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ততঃ পরং লোকাশ্চতুর্ভি র্মানৱৈরেকং পক্ষাঘাতিনং ৱাহযিৎৱা তৎসমীপম্ আনিন্যুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","কিন্তু জনানাং বহুৎৱাৎ তং যীশোঃ সম্মুখমানেতুং ন শক্নুৱন্তো যস্মিন্ স্থানে স আস্তে তদুপরিগৃহপৃষ্ঠং খনিৎৱা ছিদ্রং কৃৎৱা তেন মার্গেণ সশয্যং পক্ষাঘাতিনম্ অৱরোহযামাসুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ততো যীশুস্তেষাং ৱিশ্ৱাসং দৃষ্ট্ৱা তং পক্ষাঘাতিনং বভাষে হে ৱৎস তৱ পাপানাং মার্জনং ভৱতু| ");
INSERT INTO sanben_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","তদা কিযন্তোঽধ্যাপকাস্তত্রোপৱিশন্তো মনোভি র্ৱিতর্কযাঞ্চক্রুঃ, এষ মনুষ্য এতাদৃশীমীশ্ৱরনিন্দাং কথাং কুতঃ কথযতি? ");
INSERT INTO sanben_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","ঈশ্ৱরং ৱিনা পাপানি মার্ষ্টুং কস্য সামর্থ্যম্ আস্তে? ");
INSERT INTO sanben_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ইত্থং তে ৱিতর্কযন্তি যীশুস্তৎক্ষণং মনসা তদ্ বুদ্ৱ্ৱা তানৱদদ্ যূযমন্তঃকরণৈঃ কুত এতানি ৱিতর্কযথ? ");
INSERT INTO sanben_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","তদনন্তরং যীশুস্তৎস্থানাৎ পুনঃ সমুদ্রতটং যযৌ; লোকনিৱহে তৎসমীপমাগতে স তান্ সমুপদিদেশ| ");
INSERT INTO sanben_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","কিন্তু পৃথিৱ্যাং পাপানি মার্ষ্টুং মনুষ্যপুত্রস্য সামর্থ্যমস্তি, এতদ্ যুষ্মান্ জ্ঞাপযিতুং (স তস্মৈ পক্ষাঘাতিনে কথযামাস) ");
INSERT INTO sanben_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","উত্তিষ্ঠ তৱ শয্যাং গৃহীৎৱা স্ৱগৃহং যাহি, অহং ৎৱামিদম্ আজ্ঞাপযামি| ");
INSERT INTO sanben_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ততঃ স তৎক্ষণম্ উত্থায শয্যাং গৃহীৎৱা সর্ৱ্ৱেষাং সাক্ষাৎ জগাম; সর্ৱ্ৱে ৱিস্মিতা এতাদৃশং কর্ম্ম ৱযম্ কদাপি নাপশ্যাম, ইমাং কথাং কথযিৎৱেশ্ৱরং ধন্যমব্রুৱন্| ");
INSERT INTO sanben_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","তদনন্তরং যীশুস্তৎস্থানাৎ পুনঃ সমুদ্রতটং যযৌ; লোকনিৱহে তৎসমীপমাগতে স তান্ সমুপদিদেশ| ");
INSERT INTO sanben_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","অথ গচ্ছন্ করসঞ্চযগৃহ উপৱিষ্টম্ আল্ফীযপুত্রং লেৱিং দৃষ্ট্ৱা তমাহূয কথিতৱান্ মৎপশ্চাৎ ৎৱামামচ্ছ ততঃ স উত্থায তৎপশ্চাদ্ যযৌ| ");
INSERT INTO sanben_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","অনন্তরং যীশৌ তস্য গৃহে ভোক্তুম্ উপৱিষ্টে বহৱঃ করমঞ্চাযিনঃ পাপিনশ্চ তেন তচ্ছিষ্যৈশ্চ সহোপৱিৱিশুঃ, যতো বহৱস্তৎপশ্চাদাজগ্মুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","তদা স করমঞ্চাযিভিঃ পাপিভিশ্চ সহ খাদতি, তদ্ দৃষ্ট্ৱাধ্যাপকাঃ ফিরূশিনশ্চ তস্য শিষ্যানূচুঃ করমঞ্চাযিভিঃ পাপিভিশ্চ সহাযং কুতো ভুংক্তে পিৱতি চ? ");
INSERT INTO sanben_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","তদ্ৱাক্যং শ্রুৎৱা যীশুঃ প্রত্যুৱাচ,অরোগিলোকানাং চিকিৎসকেন প্রযোজনং নাস্তি, কিন্তু রোগিণামেৱ; অহং ধার্ম্মিকানাহ্ৱাতুং নাগতঃ কিন্তু মনো ৱ্যাৱর্ত্তযিতুং পাপিন এৱ| ");
INSERT INTO sanben_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ততঃ পরং যোহনঃ ফিরূশিনাঞ্চোপৱাসাচারিশিষ্যা যীশোঃ সমীপম্ আগত্য কথযামাসুঃ, যোহনঃ ফিরূশিনাঞ্চ শিষ্যা উপৱসন্তি কিন্তু ভৱতঃ শিষ্যা নোপৱসন্তি কিং কারণমস্য? ");
INSERT INTO sanben_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","তদা যীশুস্তান্ বভাষে যাৱৎ কালং সখিভিঃ সহ কন্যাযা ৱরস্তিষ্ঠতি তাৱৎকালং তে কিমুপৱস্তুং শক্নুৱন্তি? যাৱৎকালং ৱরস্তৈঃ সহ তিষ্ঠতি তাৱৎকালং ত উপৱস্তুং ন শক্নুৱন্তি| ");
INSERT INTO sanben_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","যস্মিন্ কালে তেভ্যঃ সকাশাদ্ ৱরো নেষ্যতে স কাল আগচ্ছতি, তস্মিন্ কালে তে জনা উপৱৎস্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","কোপি জনঃ পুরাতনৱস্ত্রে নূতনৱস্ত্রং ন সীৱ্যতি, যতো নূতনৱস্ত্রেণ সহ সেৱনে কৃতে জীর্ণং ৱস্ত্রং ছিদ্যতে তস্মাৎ পুন র্মহৎ ছিদ্রং জাযতে| ");
INSERT INTO sanben_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","কোপি জনঃ পুরাতনকুতূষু নূতনং দ্রাক্ষারসং ন স্থাপযতি, যতো নূতনদ্রাক্ষারসস্য তেজসা তাঃ কুৎৱো ৱিদীর্য্যন্তে ততো দ্রাক্ষারসশ্চ পততি কুৎৱশ্চ নশ্যন্তি, অতএৱ নূতনদ্রাক্ষারসো নূতনকুতূষু স্থাপনীযঃ| ");
INSERT INTO sanben_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","তদনন্তরং যীশু র্যদা ৱিশ্রামৱারে শস্যক্ষেত্রেণ গচ্ছতি তদা তস্য শিষ্যা গচ্ছন্তঃ শস্যমঞ্জরীশ্ছেত্তুং প্রৱৃত্তাঃ| ");
INSERT INTO sanben_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","অতঃ ফিরূশিনো যীশৱে কথযামাসুঃ পশ্যতু ৱিশ্রামৱাসরে যৎ কর্ম্ম ন কর্ত্তৱ্যং তদ্ ইমে কুতঃ কুর্ৱ্ৱন্তি? ");
INSERT INTO sanben_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","তদা স তেভ্যোঽকথযৎ দাযূদ্ তৎসংঙ্গিনশ্চ ভক্ষ্যাভাৱাৎ ক্ষুধিতাঃ সন্তো যৎ কর্ম্ম কৃতৱন্তস্তৎ কিং যুষ্মাভি র্ন পঠিতম্? ");
INSERT INTO sanben_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","অবিযাথর্নামকে মহাযাজকতাং কুর্ৱ্ৱতি স কথমীশ্ৱরস্যাৱাসং প্রৱিশ্য যে দর্শনীযপূপা যাজকান্ ৱিনান্যস্য কস্যাপি ন ভক্ষ্যাস্তানেৱ বুভুজে সঙ্গিলোকেভ্যোঽপি দদৌ| ");
INSERT INTO sanben_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","সোঽপরমপি জগাদ, ৱিশ্রামৱারো মনুষ্যার্থমেৱ নিরূপিতোঽস্তি কিন্তু মনুষ্যো ৱিশ্রামৱারার্থং নৈৱ| ");
INSERT INTO sanben_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","মনুষ্যপুত্রো ৱিশ্রামৱারস্যাপি প্রভুরাস্তে| ");
INSERT INTO sanben_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","অনন্তরং যীশুঃ পুন র্ভজনগৃহং প্রৱিষ্টস্তস্মিন্ স্থানে শুষ্কহস্ত একো মানৱ আসীৎ| ");
INSERT INTO sanben_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","স ৱিশ্রামৱারে তমরোগিণং করিষ্যতি নৱেত্যত্র বহৱস্তম্ অপৱদিতুং ছিদ্রমপেক্ষিতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","তদা স তং শুষ্কহস্তং মনুষ্যং জগাদ মধ্যস্থানে ৎৱমুত্তিষ্ঠ| ");
INSERT INTO sanben_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ততঃ পরং স তান্ পপ্রচ্ছ ৱিশ্রামৱারে হিতমহিতং তথা হি প্রাণরক্ষা ৱা প্রাণনাশ এষাং মধ্যে কিং করণীযং ? কিন্তু তে নিঃশব্দাস্তস্থুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","তদা স তেষামন্তঃকরণানাং কাঠিন্যাদ্ধেতো র্দুঃখিতঃ ক্রোধাৎ চর্তুिদশো দৃষ্টৱান্ তং মানুষং গদিতৱান্ তং হস্তং ৱিস্তারয, ততস্তেন হস্তে ৱিস্তৃতে তদ্ধস্তোঽন্যহস্তৱদ্ অরোগো জাতঃ| ");
INSERT INTO sanben_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","অথ ফিরূশিনঃ প্রস্থায তং নাশযিতুং হেরোদীযৈঃ সহ মন্ত্রযিতুমারেভিরে| ");
INSERT INTO sanben_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","অতএৱ যীশুস্তৎস্থানং পরিত্যজ্য শিষ্যৈঃ সহ পুনঃ সাগরসমীপং গতঃ; ");
INSERT INTO sanben_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ততো গালীল্যিহূদা-যিরূশালম্-ইদোম্-যর্দন্নদীপারস্থানেভ্যো লোকসমূহস্তস্য পশ্চাদ্ গতঃ; তদন্যঃ সোরসীদনোঃ সমীপৱাসিলোকসমূহশ্চ তস্য মহাকর্ম্মণাং ৱার্ত্তং শ্রুৎৱা তস্য সন্নিধিমাগতঃ| ");
INSERT INTO sanben_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","তদা লোকসমূহশ্চেৎ তস্যোপরি পততি ইত্যাশঙ্ক্য স নাৱমেকাং নিকটে স্থাপযিতুং শিষ্যানাদিষ্টৱান্| ");
INSERT INTO sanben_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","যতোঽনেকমনুষ্যাণামারোগ্যকরণাদ্ ৱ্যাধিগ্রস্তাঃ সর্ৱ্ৱে তং স্প্রষ্টুং পরস্পরং বলেন যত্নৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","অপরঞ্চ অপৱিত্রভূতাস্তং দৃষ্ট্ৱা তচ্চরণযোঃ পতিৎৱা প্রোচৈঃ প্রোচুঃ, ৎৱমীশ্ৱরস্য পুত্রঃ| ");
INSERT INTO sanben_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","কিন্তু স তান্ দৃঢম্ আজ্ঞাপ্য স্ৱং পরিচাযিতুং নিষিদ্ধৱান্| ");
INSERT INTO sanben_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","অনন্তরং স পর্ৱ্ৱতমারুহ্য যং যং প্রতিচ্ছা তং তমাহূতৱান্ ততস্তে তৎসমীপমাগতাঃ| ");
INSERT INTO sanben_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","তদা স দ্ৱাদশজনান্ স্ৱেন সহ স্থাতুং সুসংৱাদপ্রচারায প্রেরিতা ভৱিতুং ");
INSERT INTO sanben_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","সর্ৱ্ৱপ্রকারৱ্যাধীনাং শমনকরণায প্রভাৱং প্রাপ্তুং ভূতান্ ত্যাজযিতুঞ্চ নিযুক্তৱান্| ");
INSERT INTO sanben_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","তেষাং নামানীমানি, শিমোন্ সিৱদিপুত্রো ");
INSERT INTO sanben_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","যাকূব্ তস্য ভ্রাতা যোহন্ চ আন্দ্রিযঃ ফিলিপো বর্থলমযঃ, ");
INSERT INTO sanben_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","মথী থোমা চ আল্ফীযপুত্রো যাকূব্ থদ্দীযঃ কিনানীযঃ শিমোন্ যস্তং পরহস্তেষ্ৱর্পযিষ্যতি স ঈষ্করিযোতীযযিহূদাশ্চ| ");
INSERT INTO sanben_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","স শিমোনে পিতর ইত্যুপনাম দদৌ যাকূব্যোহন্ভ্যাং চ বিনেরিগিশ্ অর্থতো মেঘনাদপুত্রাৱিত্যুপনাম দদৌ| ");
INSERT INTO sanben_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","অনন্তরং তে নিৱেশনং গতাঃ, কিন্তু তত্রাপি পুনর্মহান্ জনসমাগমো ঽভৱৎ তস্মাত্তে ভোক্তুমপ্যৱকাশং ন প্রাপ্তাঃ| ");
INSERT INTO sanben_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ততস্তস্য সুহৃল্লোকা ইমাং ৱার্ত্তাং প্রাপ্য স হতজ্ঞানোভূদ্ ইতি কথাং কথযিৎৱা তং ধৃৎৱানেতুং গতাঃ| ");
INSERT INTO sanben_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","অপরঞ্চ যিরূশালম আগতা যে যেঽধ্যাপকাস্তে জগদুরযং পুরুষো ভূতপত্যাবিষ্টস্তেন ভূতপতিনা ভূতান্ ত্যাজযতি| ");
INSERT INTO sanben_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","ততস্তানাহূয যীশু র্দৃষ্টান্তৈঃ কথাং কথিতৱান্ শৈতান্ কথং শৈতানং ত্যাজযিতুং শক্নোতি? ");
INSERT INTO sanben_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","কিঞ্চন রাজ্যং যদি স্ৱৱিরোধেন পৃথগ্ ভৱতি তর্হি তদ্ রাজ্যং স্থিরং স্থাতুং ন শক্নোতি| ");
INSERT INTO sanben_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","তথা কস্যাপি পরিৱারো যদি পরস্পরং ৱিরোধী ভৱতি তর্হি সোপি পরিৱারঃ স্থিরং স্থাতুং ন শক্নোতি| ");
INSERT INTO sanben_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","তদ্ৱৎ শৈতান্ যদি স্ৱৱিপক্ষতযা উত্তিষ্ঠন্ ভিন্নো ভৱতি তর্হি সোপি স্থিরং স্থাতুং ন শক্নোতি কিন্তূচ্ছিন্নো ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","অপরঞ্চ প্রবলং জনং প্রথমং ন বদ্ধা কোপি তস্য গৃহং প্রৱিশ্য দ্রৱ্যাণি লুণ্ঠযিতুং ন শক্নোতি, তং বদ্ৱ্ৱৈৱ তস্য গৃহস্য দ্রৱ্যাণি লুণ্ঠযিতুং শক্নোতি| ");
INSERT INTO sanben_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","অতোহেতো র্যুষ্মভ্যমহং সত্যং কথযামি মনুষ্যাণাং সন্তানা যানি যানি পাপানীশ্ৱরনিন্দাঞ্চ কুর্ৱ্ৱন্তি তেষাং তৎসর্ৱ্ৱেষামপরাধানাং ক্ষমা ভৱিতুং শক্নোতি, ");
INSERT INTO sanben_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","কিন্তু যঃ কশ্চিৎ পৱিত্রমাত্মানং নিন্দতি তস্যাপরাধস্য ক্ষমা কদাপি ন ভৱিষ্যতি সোনন্তদণ্ডস্যার্হো ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","তস্যাপৱিত্রভূতোঽস্তি তেষামেতৎকথাহেতোঃ স ইত্থং কথিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","অথ তস্য মাতা ভ্রাতৃগণশ্চাগত্য বহিস্তিষ্ঠনতো লোকান্ প্রেষ্য তমাহূতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ততস্তৎসন্নিধৌ সমুপৱিষ্টা লোকাস্তং বভাষিরে পশ্য বহিস্তৱ মাতা ভ্রাতরশ্চ ৎৱাম্ অন্ৱিচ্ছন্তি| ");
INSERT INTO sanben_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","তদা স তান্ প্রত্যুৱাচ মম মাতা কা ভ্রাতরো ৱা কে? ততঃ পরং স স্ৱমীপোপৱিষ্টান্ শিষ্যান্ প্রতি অৱলোকনং কৃৎৱা কথযামাস ");
INSERT INTO sanben_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","পশ্যতৈতে মম মাতা ভ্রাতরশ্চ| ");
INSERT INTO sanben_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","যঃ কশ্চিদ্ ঈশ্ৱরস্যেষ্টাং ক্রিযাং করোতি স এৱ মম ভ্রাতা ভগিনী মাতা চ| ");
INSERT INTO sanben_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","অনন্তরং স সমুদ্রতটে পুনরুপদেষ্টুং প্রারেভে, ততস্তত্র বহুজনানাং সমাগমাৎ স সাগরোপরি নৌকামারুহ্য সমুপৱিষ্টঃ; সর্ৱ্ৱে লোকাঃ সমুদ্রকূলে তস্থুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","তদা স দৃষ্টান্তকথাভি র্বহূপদিষ্টৱান্ উপদিশংশ্চ কথিতৱান্, ");
INSERT INTO sanben_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","অৱধানং কুরুত, একো বীজৱপ্তা বীজানি ৱপ্তুং গতঃ; ");
INSERT INTO sanben_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ৱপনকালে কিযন্তি বীজানি মার্গপাশ্ৱে পতিতানি, তত আকাশীযপক্ষিণ এত্য তানি চখাদুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","কিযন্তি বীজানি স্ৱল্পমৃত্তিকাৱৎপাষাণভূমৌ পতিতানি তানি মৃদোল্পৎৱাৎ শীঘ্রমঙ্কুরিতানি; ");
INSERT INTO sanben_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","কিন্তূদিতে সূর্য্যে দগ্ধানি তথা মূলানো নাধোগতৎৱাৎ শুষ্কাণি চ| ");
INSERT INTO sanben_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","কিযন্তি বীজানি কণ্টকিৱনমধ্যে পতিতানি ততঃ কণ্টকানি সংৱৃদ্ৱ্য তানি জগ্রসুস্তানি ন চ ফলিতানি| ");
INSERT INTO sanben_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","তথা কিযন্তি বীজান্যুত্তমভূমৌ পতিতানি তানি সংৱৃদ্ৱ্য ফলান্যুৎপাদিতানি কিযন্তি বীজানি ত্রিংশদ্গুণানি কিযন্তি ষষ্টিগুণানি কিযন্তি শতগুণানি ফলানি ফলিতৱন্তি| ");
INSERT INTO sanben_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","অথ স তানৱদৎ যস্য শ্রোতুং কর্ণৌ স্তঃ স শৃণোতু| ");
INSERT INTO sanben_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","তদনন্তরং নির্জনসমযে তৎসঙ্গিনো দ্ৱাদশশিষ্যাশ্চ তং তদ্দৃষ্টান্তৱাক্যস্যার্থং পপ্রচ্ছুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","তদা স তানুদিতৱান্ ঈশ্ৱররাজ্যস্য নিগূঢৱাক্যং বোদ্ধুং যুষ্মাকমধিকারোঽস্তি; ");
INSERT INTO sanben_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","কিন্তু যে ৱহির্ভূতাঃ \"তে পশ্যন্তঃ পশ্যন্তি কিন্তু ন জানন্তি, শৃণ্ৱন্তঃ শৃণ্ৱন্তি কিন্তু ন বুধ্যন্তে, চেত্তৈ র্মনঃসু কদাপি পরিৱর্ত্তিতেষু তেষাং পাপান্যমোচযিষ্যন্ত,\" অতোহেতোস্তান্ প্রতি দৃষ্টান্তৈরেৱ তানি মযা কথিতানি| ");
INSERT INTO sanben_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","অথ স কথিতৱান্ যূযং কিমেতদ্ দৃষ্টান্তৱাক্যং ন বুধ্যধ্ৱে? তর্হি কথং সর্ৱ্ৱান্ দৃষ্টান্তান ভোৎস্যধ্ৱে? ");
INSERT INTO sanben_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","বীজৱপ্তা ৱাক্যরূপাণি বীজানি ৱপতি; ");
INSERT INTO sanben_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","তত্র যে যে লোকা ৱাক্যং শৃণ্ৱন্তি, কিন্তু শ্রুতমাত্রাৎ শৈতান্ শীঘ্রমাগত্য তেষাং মনঃসূপ্তানি তানি ৱাক্যরূপাণি বীজান্যপনযতি তএৱ উপ্তবীজমার্গপার্শ্ৱেস্ৱরূপাঃ| ");
INSERT INTO sanben_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","যে জনা ৱাক্যং শ্রুৎৱা সহসা পরমানন্দেন গৃহ্লন্তি, কিন্তু হৃদি স্থৈর্য্যাভাৱাৎ কিঞ্চিৎ কালমাত্রং তিষ্ঠন্তি তৎপশ্চাৎ তদ্ৱাক্যহেতোঃ ");
INSERT INTO sanben_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","কুত্রচিৎ ক্লেশে উপদ্রৱে ৱা সমুপস্থিতে তদৈৱ ৱিঘ্নং প্রাপ্নুৱন্তি তএৱ উপ্তবীজপাষাণভূমিস্ৱরূপাঃ| ");
INSERT INTO sanben_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","যে জনাঃ কথাং শৃণ্ৱন্তি কিন্তু সাংসারিকী চিন্তা ধনভ্রান্তি র্ৱিষযলোভশ্চ এতে সর্ৱ্ৱে উপস্থায তাং কথাং গ্রসন্তি ততঃ মা ৱিফলা ভৱতি ");
INSERT INTO sanben_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","তএৱ উপ্তবীজসকণ্টকভূমিস্ৱরূপাঃ| ");
INSERT INTO sanben_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","যে জনা ৱাক্যং শ্রুৎৱা গৃহ্লন্তি তেষাং কস্য ৱা ত্রিংশদ্গুণানি কস্য ৱা ষষ্টিগুণানি কস্য ৱা শতগুণানি ফলানি ভৱন্তি তএৱ উপ্তবীজোর্ৱ্ৱরভূমিস্ৱরূপাঃ| ");
INSERT INTO sanben_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","তদা সোঽপরমপি কথিতৱান্ কোপি জনো দীপাধারং পরিত্যজ্য দ্রোণস্যাধঃ খট্ৱাযা অধে ৱা স্থাপযিতুং দীপমানযতি কিং? ");
INSERT INTO sanben_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","অতোহেতো র্যন্ন প্রকাশযিষ্যতে তাদৃগ্ লুক্কাযিতং কিমপি ৱস্তু নাস্তি; যদ্ ৱ্যক্তং ন ভৱিষ্যতি তাদৃশং গুপ্তং কিমপি ৱস্তু নাস্তি| ");
INSERT INTO sanben_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","যস্য শ্রোতুং কর্ণৌ স্তঃ স শৃণোতু| ");
INSERT INTO sanben_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","অপরমপি কথিতৱান্ যূযং যদ্ যদ্ ৱাক্যং শৃণুথ তত্র সাৱধানা ভৱত, যতো যূযং যেন পরিমাণেন পরিমাথ তেনৈৱ পরিমাণেন যুষ্মদর্থমপি পরিমাস্যতে; শ্রোতারো যূযং যুষ্মভ্যমধিকং দাস্যতে| ");
INSERT INTO sanben_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","যস্যাশ্রযে ৱর্দ্ধতে তস্মৈ অপরমপি দাস্যতে, কিন্তু যস্যাশ্রযে ন ৱর্দ্ধতে তস্য যৎ কিঞ্চিদস্তি তদপি তস্মান্ নেষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","অনন্তরং স কথিতৱান্ একো লোকঃ ক্ষেত্রে বীজান্যুপ্ত্ৱা ");
INSERT INTO sanben_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","জাগরণনিদ্রাভ্যাং দিৱানিশং গমযতি, পরন্তু তদ্ৱীজং তস্যাজ্ঞাতরূপেণাঙ্কুরযতি ৱর্দ্ধতে চ; ");
INSERT INTO sanben_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","যতোহেতোঃ প্রথমতঃ পত্রাণি ততঃ পরং কণিশানি তৎপশ্চাৎ কণিশপূর্ণানি শস্যানি ভূমিঃ স্ৱযমুৎপাদযতি; ");
INSERT INTO sanben_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","কিন্তু ফলেষু পক্কেষু শস্যচ্ছেদনকালং জ্ঞাৎৱা স তৎক্ষণং শস্যানি ছিনত্তি, অনেন তুল্যমীশ্ৱররাজ্যং| ");
INSERT INTO sanben_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","পুনঃ সোঽকথযদ্ ঈশ্ৱররাজ্যং কেন সমং? কেন ৱস্তুনা সহ ৱা তদুপমাস্যামি? ");
INSERT INTO sanben_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","তৎ সর্ষপৈকেন তুল্যং যতো মৃদি ৱপনকালে সর্ষপবীজং সর্ৱ্ৱপৃথিৱীস্থবীজাৎ ক্ষুদ্রং ");
INSERT INTO sanben_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","কিন্তু ৱপনাৎ পরম্ অঙ্কুরযিৎৱা সর্ৱ্ৱশাকাদ্ বৃহদ্ ভৱতি, তস্য বৃহত্যঃ শাখাশ্চ জাযন্তে ততস্তচ্ছাযাং পক্ষিণ আশ্রযন্তে| ");
INSERT INTO sanben_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ইত্থং তেষাং বোধানুরূপং সোঽনেকদৃষ্টান্তৈস্তানুপদিষ্টৱান্, ");
INSERT INTO sanben_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","দৃষ্টান্তং ৱিনা কামপি কথাং তেভ্যো ন কথিতৱান্ পশ্চান্ নির্জনে স শিষ্যান্ সর্ৱ্ৱদৃষ্টান্তার্থং বোধিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","তদ্দিনস্য সন্ধ্যাযাং স তেভ্যোঽকথযদ্ আগচ্ছত ৱযং পারং যাম| ");
INSERT INTO sanben_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","তদা তে লোকান্ ৱিসৃজ্য তমৱিলম্বং গৃহীৎৱা নৌকযা প্রতস্থিরে; অপরা অপি নাৱস্তযা সহ স্থিতাঃ| ");
INSERT INTO sanben_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ততঃ পরং মহাঝঞ্ভ্শগমাৎ নৌ র্দোলাযমানা তরঙ্গেণ জলৈঃ পূর্ণাভৱচ্চ| ");
INSERT INTO sanben_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","তদা স নৌকাচশ্চাদ্ভাগে উপধানে শিরো নিধায নিদ্রিত আসীৎ ততস্তে তং জাগরযিৎৱা জগদুঃ, হে প্রভো, অস্মাকং প্রাণা যান্তি কিমত্র ভৱতশ্চিন্তা নাস্তি? ");
INSERT INTO sanben_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","তদা স উত্থায ৱাযুং তর্জিতৱান্ সমুদ্রঞ্চোক্তৱান্ শান্তঃ সুস্থিরশ্চ ভৱ; ততো ৱাযৌ নিৱৃত্তেঽব্ধির্নিস্তরঙ্গোভূৎ| ");
INSERT INTO sanben_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","তদা স তানুৱাচ যূযং কুত এতাদৃক্শঙ্কাকুলা ভৱত? কিং ৱো ৱিশ্ৱাসো নাস্তি? ");
INSERT INTO sanben_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","তস্মাত্তেঽতীৱভীতাঃ পরস্পরং ৱক্তুমারেভিরে, অহো ৱাযুঃ সিন্ধুশ্চাস্য নিদেশগ্রাহিণৌ কীদৃগযং মনুজঃ| ");
INSERT INTO sanben_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","অথ তূ সিন্ধুপারং গৎৱা গিদেরীযপ্রদেশ উপতস্থুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","নৌকাতো নির্গতমাত্রাদ্ অপৱিত্রভূতগ্রস্ত একঃ শ্মশানাদেত্য তং সাক্ষাচ্ চকার| ");
INSERT INTO sanben_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","স শ্মশানেঽৱাৎসীৎ কোপি তং শৃঙ্খলেন বদ্ৱ্ৱা স্থাপযিতুং নাশক্নোৎ| ");
INSERT INTO sanben_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","জনৈর্ৱারং নিগডৈঃ শৃঙ্খলৈশ্চ স বদ্ধোপি শৃঙ্খলান্যাকৃষ্য মোচিতৱান্ নিগডানি চ ভংক্ত্ৱা খণ্ডং খণ্ডং কৃতৱান্ কোপি তং ৱশীকর্ত্তুং ন শশক| ");
INSERT INTO sanben_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","দিৱানিশং সদা পর্ৱ্ৱতং শ্মশানঞ্চ ভ্রমিৎৱা চীৎশব্দং কৃতৱান্ গ্রাৱভিশ্চ স্ৱযং স্ৱং কৃতৱান্| ");
INSERT INTO sanben_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","স যীশুং দূরাৎ পশ্যন্নেৱ ধাৱন্ তং প্রণনাম উচৈরুৱংশ্চোৱাচ, ");
INSERT INTO sanben_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","হে সর্ৱ্ৱোপরিস্থেশ্ৱরপুত্র যীশো ভৱতা সহ মে কঃ সম্বন্ধঃ? অহং ৎৱামীশ্ৱরেণ শাপযে মাং মা যাতয| ");
INSERT INTO sanben_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","যতো যীশুস্তং কথিতৱান্ রে অপৱিত্রভূত, অস্মান্নরাদ্ বহির্নির্গচ্ছ| ");
INSERT INTO sanben_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","অথ স তং পৃষ্টৱান্ কিন্তে নাম? তেন প্রত্যুক্তং ৱযমনেকে ঽস্মস্ততোঽস্মন্নাম বাহিনী| ");
INSERT INTO sanben_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ততোস্মান্ দেশান্ন প্রেষযেতি তে তং প্রার্থযন্ত| ");
INSERT INTO sanben_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","তদানীং পর্ৱ্ৱতং নিকষা বৃহন্ ৱরাহৱ্রজশ্চরন্নাসীৎ| ");
INSERT INTO sanben_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","তস্মাদ্ ভূতা ৱিনযেন জগদুঃ, অমুং ৱরাহৱ্রজম্ আশ্রযিতুম্ অস্মান্ প্রহিণু| ");
INSERT INTO sanben_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","যীশুনানুজ্ঞাতাস্তেঽপৱিত্রভূতা বহির্নির্যায ৱরাহৱ্রজং প্রাৱিশন্ ততঃ সর্ৱ্ৱে ৱরাহা ৱস্তুতস্তু প্রাযোদ্ৱিসহস্রসংঙ্খ্যকাঃ কটকেন মহাজৱাদ্ ধাৱন্তঃ সিন্ধৌ প্রাণান্ জহুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","তস্মাদ্ ৱরাহপালকাঃ পলাযমানাঃ পুরে গ্রামে চ তদ্ৱার্ত্তং কথযাঞ্চক্রুঃ| তদা লোকা ঘটিতং তৎকার্য্যং দ্রষ্টুং বহির্জগ্মুঃ ");
INSERT INTO sanben_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","যীশোঃ সন্নিধিং গৎৱা তং ভূতগ্রস্তম্ অর্থাদ্ বাহিনীভূতগ্রস্তং নরং সৱস্ত্রং সচেতনং সমুপৱিষ্টঞ্চ দৃृষ্ট্ৱা বিভ্যুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ততো দৃষ্টতৎকার্য্যলোকাস্তস্য ভূতগ্রস্তনরস্য ৱরাহৱ্রজস্যাপি তাং ধটনাং ৱর্ণযামাসুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ততস্তে স্ৱসীমাতো বহির্গন্তুং যীশুং ৱিনেতুমারেভিরে| ");
INSERT INTO sanben_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","অথ তস্য নৌকারোহণকালে স ভূতমুক্তো না যীশুনা সহ স্থাতুং প্রার্থযতে; ");
INSERT INTO sanben_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","কিন্তু স তমননুমত্য কথিতৱান্ ৎৱং নিজাত্মীযানাং সমীপং গৃহঞ্চ গচ্ছ প্রভুস্ত্ৱযি কৃপাং কৃৎৱা যানি কর্ম্মাণি কৃতৱান্ তানি তান্ জ্ঞাপয| ");
INSERT INTO sanben_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","অতঃ স প্রস্থায যীশুনা কৃতং তৎসর্ৱ্ৱাশ্চর্য্যং কর্ম্ম দিকাপলিদেশে প্রচারযিতুং প্রারব্ধৱান্ ততঃ সর্ৱ্ৱে লোকা আশ্চর্য্যং মেনিরে| ");
INSERT INTO sanben_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","অনন্তরং যীশৌ নাৱা পুনরন্যপার উত্তীর্ণে সিন্ধুতটে চ তিষ্ঠতি সতি তৎসমীপে বহুলোকানাং সমাগমোঽভূৎ| ");
INSERT INTO sanben_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","অপরং যাযীর্ নাম্না কশ্চিদ্ ভজনগৃহস্যাধিপ আগত্য তং দৃষ্ট্ৱৈৱ চরণযোঃ পতিৎৱা বহু নিৱেদ্য কথিতৱান্; ");
INSERT INTO sanben_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","মম কন্যা মৃতপ্রাযাভূদ্ অতো ভৱানেত্য তদারোগ্যায তস্যা গাত্রে হস্তম্ অর্পযতু তেনৈৱ সা জীৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","তদা যীশুস্তেন সহ চলিতঃ কিন্তু তৎপশ্চাদ্ বহুলোকাশ্চলিৎৱা তাদ্গাত্রে পতিতাঃ| ");
INSERT INTO sanben_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","অথ দ্ৱাদশৱর্ষাণি প্রদররোগেণ ");
INSERT INTO sanben_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","শীর্ণা চিকিৎসকানাং নানাচিকিৎসাভিশ্চ দুঃখং ভুক্তৱতী চ সর্ৱ্ৱস্ৱং ৱ্যযিৎৱাপি নারোগ্যং প্রাপ্তা চ পুনরপি পীডিতাসীচ্চ ");
INSERT INTO sanben_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","যা স্ত্রী সা যীশো র্ৱার্ত্তাং প্রাপ্য মনসাকথযৎ যদ্যহং তস্য ৱস্ত্রমাত্র স্প্রষ্টুং লভেযং তদা রোগহীনা ভৱিষ্যামি| ");
INSERT INTO sanben_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","অতোহেতোঃ সা লোকারণ্যমধ্যে তৎপশ্চাদাগত্য তস্য ৱস্ত্রং পস্পর্শ| ");
INSERT INTO sanben_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","তেনৈৱ তৎক্ষণং তস্যা রক্তস্রোতঃ শুষ্কং স্ৱযং তস্মাদ্ রোগান্মুক্তা ইত্যপি দেহেঽনুভূতা| ");
INSERT INTO sanben_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","অথ স্ৱস্মাৎ শক্তি র্নির্গতা যীশুরেতন্মনসা জ্ঞাৎৱা লোকনিৱহং প্রতি মুখং ৱ্যাৱৃত্য পৃষ্টৱান্ কেন মদ্ৱস্ত্রং স্পৃষ্টং? ");
INSERT INTO sanben_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ততস্তস্য শিষ্যা ঊচুঃ ভৱতো ৱপুষি লোকাঃ সংঘর্ষন্তি তদ্ দৃষ্ট্ৱা কেন মদ্ৱস্ত্রং স্পৃষ্টমিতি কুতঃ কথযতি? ");
INSERT INTO sanben_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","কিন্তু কেন তৎ কর্ম্ম কৃতং তদ্ দ্রষ্টুং যীশুশ্চতুর্দিশো দৃষ্টৱান্| ");
INSERT INTO sanben_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ততঃ সা স্ত্রী ভীতা কম্পিতা চ সতী স্ৱস্যা রুক্প্রতিক্রিযা জাতেতি জ্ঞাৎৱাগত্য তৎসম্মুখে পতিৎৱা সর্ৱ্ৱৱৃত্তান্তং সত্যং তস্মৈ কথযামাস| ");
INSERT INTO sanben_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","তদানীং যীশুস্তাং গদিতৱান্, হে কন্যে তৱ প্রতীতিস্ত্ৱাম্ অরোগামকরোৎ ৎৱং ক্ষেমেণ ৱ্রজ স্ৱরোগান্মুক্তা চ তিষ্ঠ| ");
INSERT INTO sanben_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ইতিৱাক্যৱদনকালে ভজনগৃহাধিপস্য নিৱেশনাল্ লোকা এত্যাধিপং বভাষিরে তৱ কন্যা মৃতা তস্মাদ্ গুরুং পুনঃ কুতঃ ক্লিশ্নাসি? ");
INSERT INTO sanben_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","কিন্তু যীশুস্তদ্ ৱাক্যং শ্রুৎৱৈৱ ভজনগৃহাধিপং গদিতৱান্ মা ভৈষীঃ কেৱলং ৱিশ্ৱাসিহি| ");
INSERT INTO sanben_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","অথ পিতরো যাকূব্ তদ্ভ্রাতা যোহন্ চ এতান্ ৱিনা কমপি স্ৱপশ্চাদ্ যাতুং নান্ৱমন্যত| ");
INSERT INTO sanben_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","তস্য ভজনগৃহাধিপস্য নিৱেশনসমীপম্ আগত্য কলহং বহুরোদনং ৱিলাপঞ্চ কুর্ৱ্ৱতো লোকান্ দদর্শ| ");
INSERT INTO sanben_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","তস্মান্ নিৱেশনং প্রৱিশ্য প্রোক্তৱান্ যূযং কুত ইত্থং কলহং রোদনঞ্চ কুরুথ? কন্যা ন মৃতা নিদ্রাতি| ");
INSERT INTO sanben_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","তস্মাত্তে তমুপজহসুঃ কিন্তু যীশুঃ সর্ৱ্ৱান বহিষ্কৃত্য কন্যাযাঃ পিতরৌ স্ৱসঙ্গিনশ্চ গৃহীৎৱা যত্র কন্যাসীৎ তৎ স্থানং প্রৱিষ্টৱান্| ");
INSERT INTO sanben_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","অথ স তস্যাঃ কন্যাযা হস্তৌ ধৃৎৱা তাং বভাষে টালীথা কূমী, অর্থতো হে কন্যে ৎৱমুত্তিষ্ঠ ইত্যাজ্ঞাপযামি| ");
INSERT INTO sanben_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","তুনৈৱ তৎক্ষণং সা দ্ৱাদশৱর্ষৱযস্কা কন্যা পোত্থায চলিতুমারেভে, ইতঃ সর্ৱ্ৱে মহাৱিস্মযং গতাঃ| ");
INSERT INTO sanben_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","তত এতস্যৈ কিঞ্চিৎ খাদ্যং দত্তেতি কথযিৎৱা এতৎকর্ম্ম কমপি ন জ্ঞাপযতেতি দৃঢমাদিষ্টৱান্| ");
INSERT INTO sanben_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","অনন্তরং স তৎস্থানাৎ প্রস্থায স্ৱপ্রদেশমাগতঃ শিষ্যাশ্চ তৎপশ্চাদ্ গতাঃ| ");
INSERT INTO sanben_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","অথ ৱিশ্রামৱারে সতি স ভজনগৃহে উপদেষ্টুমারব্ধৱান্ ততোঽনেকে লোকাস্তৎকথাং শ্রুৎৱা ৱিস্মিত্য জগদুঃ, অস্য মনুজস্য ঈদৃশী আশ্চর্য্যক্রিযা কস্মাজ্ জাতা? তথা স্ৱকরাভ্যাম্ ইত্থমদ্ভুতং কর্ম্ম কর্ত্তাुম্ এতস্মৈ কথং জ্ঞানং দত্তম্? ");
INSERT INTO sanben_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","কিমযং মরিযমঃ পুত্রস্তজ্ঞা নো? কিমযং যাকূব্-যোসি-যিহুদা-শিমোনাং ভ্রাতা নো? অস্য ভগিন্যঃ কিমিহাস্মাভিঃ সহ নো? ইত্থং তে তদর্থে প্রত্যূহং গতাঃ| ");
INSERT INTO sanben_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","তদা যীশুস্তেভ্যোঽকথযৎ স্ৱদেশং স্ৱকুটুম্বান্ স্ৱপরিজনাংশ্চ ৱিনা কুত্রাপি ভৱিষ্যদ্ৱাদী অসৎকৃতো ন ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","অপরঞ্চ তেষামপ্রত্যযাৎ স ৱিস্মিতঃ কিযতাং রোগিণাং ৱপুঃষু হস্তম্ অর্পযিৎৱা কেৱলং তেষামারোগ্যকরণাদ্ অন্যৎ কিমপি চিত্রকার্য্যং কর্ত্তাং ন শক্তঃ| ");
INSERT INTO sanben_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","অথ স চতুর্দিক্স্থ গ্রামান্ ভ্রমিৎৱা উপদিষ্টৱান্ ");
INSERT INTO sanben_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","দ্ৱাদশশিষ্যান্ আহূয অমেধ্যভূতান্ ৱশীকর্ত্তাং শক্তিং দত্ত্ৱা তেষাং দ্ৱৌ দ্ৱৌ জনো প্রেষিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","পুনরিত্যাদিশদ্ যূযম্ একৈকাং যষ্টিং ৱিনা ৱস্ত্রসংপুটঃ পূপঃ কটিবন্ধে তাম্রখণ্ডঞ্চ এষাং কিমপি মা গ্রহ্লীত, ");
INSERT INTO sanben_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","মার্গযাত্রাযৈ পাদেষূপানহৌ দত্ত্ৱা দ্ৱে উত্তরীযে মা পরিধদ্ৱ্ৱং| ");
INSERT INTO sanben_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","অপরমপ্যুক্তং তেন যূযং যস্যাং পুর্য্যাং যস্য নিৱেশনং প্রৱেক্ষ্যথ তাং পুরীং যাৱন্ন ত্যক্ষ্যথ তাৱৎ তন্নিৱেশনে স্থাস্যথ| ");
INSERT INTO sanben_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","তত্র যদি কেপি যুষ্মাকমাতিথ্যং ন ৱিদধতি যুষ্মাকং কথাশ্চ ন শৃণ্ৱন্তি তর্হি তৎস্থানাৎ প্রস্থানসমযে তেষাং ৱিরুদ্ধং সাক্ষ্যং দাতুং স্ৱপাদানাস্ফাল্য রজঃ সম্পাতযত; অহং যুষ্মান্ যথার্থং ৱচ্মি ৱিচারদিনে তন্নগরস্যাৱস্থাতঃ সিদোমামোরযো র্নগরযোরৱস্থা সহ্যতরা ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","অথ তে গৎৱা লোকানাং মনঃপরাৱর্ত্তনীঃ কথা প্রচারিতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","এৱমনেকান্ ভূতাংশ্চ ত্যাজিতৱন্তস্তথা তৈলেন মর্দ্দযিৎৱা বহূন্ জনানরোগানকার্ষুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ইত্থং তস্য সুখ্যাতিশ্চতুর্দিশো ৱ্যাপ্তা তদা হেরোদ্ রাজা তন্নিশম্য কথিতৱান্, যোহন্ মজ্জকঃ শ্মশানাদ্ উত্থিত অতোহেতোস্তেন সর্ৱ্ৱা এতা অদ্ভুতক্রিযাঃ প্রকাশন্তে| ");
INSERT INTO sanben_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","অন্যেঽকথযন্ অযম্ এলিযঃ, কেপি কথিতৱন্ত এষ ভৱিষ্যদ্ৱাদী যদ্ৱা ভৱিষ্যদ্ৱাদিনাং সদৃশ একোযম্| ");
INSERT INTO sanben_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","কিন্তু হেরোদ্ ইত্যাকর্ণ্য ভাষিতৱান্ যস্যাহং শিরশ্ছিন্নৱান্ স এৱ যোহনযং স শ্মশানাদুদতিষ্ঠৎ| ");
INSERT INTO sanben_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","পূর্ৱ্ৱং স্ৱভ্রাতুঃ ফিলিপস্য পত্ন্যা উদ্ৱাহং কৃতৱন্তং হেরোদং যোহনৱাদীৎ স্ৱভাতৃৱধূ র্ন ৱিৱাহ্যা| ");
INSERT INTO sanben_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","অতঃ কারণাৎ হেরোদ্ লোকং প্রহিত্য যোহনং ধৃৎৱা বন্ধনালযে বদ্ধৱান্| ");
INSERT INTO sanben_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","হেরোদিযা তস্মৈ যোহনে প্রকুপ্য তং হন্তুম্ ঐচ্ছৎ কিন্তু ন শক্তা, ");
INSERT INTO sanben_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","যস্মাদ্ হেরোদ্ তং ধার্ম্মিকং সৎপুরুষঞ্চ জ্ঞাৎৱা সম্মন্য রক্ষিতৱান্; তৎকথাং শ্রুৎৱা তদনুসারেণ বহূনি কর্ম্মাণি কৃতৱান্ হৃষ্টমনাস্তদুপদেশং শ্রুতৱাংশ্চ| ");
INSERT INTO sanben_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","কিন্তু হেরোদ্ যদা স্ৱজন্মদিনে প্রধানলোকেভ্যঃ সেনানীভ্যশ্চ গালীল্প্রদেশীযশ্রেষ্ঠলোকেভ্যশ্চ রাত্রৌ ভোজ্যমেকং কৃতৱান্ ");
INSERT INTO sanben_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","তস্মিন্ শুভদিনে হেরোদিযাযাঃ কন্যা সমেত্য তেষাং সমক্ষং সংনৃত্য হেরোদস্তেন সহোপৱিষ্টানাঞ্চ তোষমজীজনৎ ততা নৃপঃ কন্যামাহ স্ম মত্তো যদ্ যাচসে তদেৱ তুভ্যং দাস্যে| ");
INSERT INTO sanben_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","শপথং কৃৎৱাকথযৎ চেদ্ রাজ্যার্দ্ধমপি যাচসে তদপি তুভ্যং দাস্যে| ");
INSERT INTO sanben_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ততঃ সা বহি র্গৎৱা স্ৱমাতরং পপ্রচ্ছ কিমহং যাচিষ্যে? তদা সাকথযৎ যোহনো মজ্জকস্য শিরঃ| ");
INSERT INTO sanben_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","অথ তূর্ণং ভূপসমীপম্ এত্য যাচমানাৱদৎ ক্ষণেস্মিন্ যোহনো মজ্জকস্য শিরঃ পাত্রে নিধায দেহি, এতদ্ যাচেঽহং| ");
INSERT INTO sanben_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","তস্মাৎ ভূপোঽতিদুঃখিতঃ, তথাপি স্ৱশপথস্য সহভোজিনাঞ্চানুরোধাৎ তদনঙ্গীকর্ত্তুং ন শক্তঃ| ");
INSERT INTO sanben_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","তৎক্ষণং রাজা ঘাতকং প্রেষ্য তস্য শির আনেতুমাদিষ্টৱান্| ");
INSERT INTO sanben_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ততঃ স কারাগারং গৎৱা তচ্ছিরশ্ছিৎৱা পাত্রে নিধাযানীয তস্যৈ কন্যাযৈ দত্তৱান্ কন্যা চ স্ৱমাত্রে দদৌ| ");
INSERT INTO sanben_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","অননতরং যোহনঃ শিষ্যাস্তদ্ৱার্ত্তাং প্রাপ্যাগত্য তস্য কুণপং শ্মশানেঽস্থাপযন্| ");
INSERT INTO sanben_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","অথ প্রেষিতা যীশোঃ সন্নিধৌ মিলিতা যদ্ যচ্ চক্রুঃ শিক্ষযামাসুশ্চ তৎসর্ৱ্ৱৱার্ত্তাস্তস্মৈ কথিতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","স তানুৱাচ যূযং ৱিজনস্থানং গৎৱা ৱিশ্রাম্যত যতস্তৎসন্নিধৌ বহুলোকানাং সমাগমাৎ তে ভোক্তুং নাৱকাশং প্রাপ্তাঃ| ");
INSERT INTO sanben_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ততস্তে নাৱা ৱিজনস্থানং গুপ্তং গগ্মুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ততো লোকনিৱহস্তেষাং স্থানান্তরযানং দদর্শ, অনেকে তং পরিচিত্য নানাপুরেভ্যঃ পদৈর্ৱ্রজিৎৱা জৱেন তৈষামগ্রে যীশোঃ সমীপ উপতস্থুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","তদা যীশু র্নাৱো বহির্গত্য লোকারণ্যানীং দৃষ্ট্ৱা তেষু করুণাং কৃতৱান্ যতস্তেঽরক্ষকমেষা ইৱাসন্ তদা স তান নানাপ্রসঙ্গান্ উপদিষ্টৱান্| ");
INSERT INTO sanben_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","অথ দিৱান্তে সতি শিষ্যা এত্য যীশুমূচিরে, ইদং ৱিজনস্থানং দিনঞ্চাৱসন্নং| ");
INSERT INTO sanben_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","লোকানাং কিমপি খাদ্যং নাস্তি, অতশ্চতুর্দিক্ষু গ্রামান্ গন্তুং ভোজ্যদ্রৱ্যাণি ক্রেতুঞ্চ ভৱান্ তান্ ৱিসৃজতু| ");
INSERT INTO sanben_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","তদা স তানুৱাচ যূযমেৱ তান্ ভোজযত; ততস্তে জগদু র্ৱযং গৎৱা দ্ৱিশতসংখ্যকৈ র্মুদ্রাপাদৈঃ পূপান্ ক্রীৎৱা কিং তান্ ভোজযিষ্যামঃ? ");
INSERT INTO sanben_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","তদা স তান্ পৃষ্ঠৱান্ যুষ্মাকং সন্নিধৌ কতি পূপা আসতে? গৎৱা পশ্যত; ততস্তে দৃষ্ট্ৱা তমৱদন্ পঞ্চ পূপা দ্ৱৌ মৎস্যৌ চ সন্তি| ");
INSERT INTO sanben_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","তদা স লোকান্ শস্পোপরি পংক্তিভিরুপৱেশযিতুম্ আদিষ্টৱান্, ");
INSERT INTO sanben_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ততস্তে শতং শতং জনাঃ পঞ্চাশৎ পঞ্চাশজ্জনাশ্চ পংক্তিভি র্ভুৱি সমুপৱিৱিশুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","অথ স তান্ পঞ্চপূপান্ মৎস্যদ্ৱযঞ্চ ধৃৎৱা স্ৱর্গং পশ্যন্ ঈশ্ৱরগুণান্ অন্ৱকীর্ত্তযৎ তান্ পূপান্ ভংক্ত্ৱা লোকেভ্যঃ পরিৱেষযিতুং শিষ্যেভ্যো দত্তৱান্ দ্ৱা মৎস্যৌ চ ৱিভজ্য সর্ৱ্ৱেভ্যো দত্তৱান্| ");
INSERT INTO sanben_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ততঃ সর্ৱ্ৱে ভুক্ত্ৱাতৃপ্যন্| ");
INSERT INTO sanben_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","অনন্তরং শিষ্যা অৱশিষ্টৈঃ পূপৈ র্মৎস্যৈশ্চ পূর্ণান্ দ্ৱদশ ডল্লকান্ জগৃহুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","তে ভোক্তারঃ প্রাযঃ পঞ্চ সহস্রাণি পুরুষা আসন্| ");
INSERT INTO sanben_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","অথ স লোকান্ ৱিসৃজন্নেৱ নাৱমারোঢুং স্ৱস্মাদগ্রে পারে বৈৎসৈদাপুরং যাতুঞ্চ শ্ষ্যিाন্ ৱাঢমাদিষ্টৱান্| ");
INSERT INTO sanben_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","তদা স সর্ৱ্ৱান্ ৱিসৃজ্য প্রার্থযিতুং পর্ৱ্ৱতং গতঃ| ");
INSERT INTO sanben_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ততঃ সন্ধ্যাযাং সত্যাং নৌঃ সিন্ধুমধ্য উপস্থিতা কিন্তু স একাকী স্থলে স্থিতঃ| ");
INSERT INTO sanben_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","অথ সম্মুখৱাতৱহনাৎ শিষ্যা নাৱং ৱাহযিৎৱা পরিশ্রান্তা ইতি জ্ঞাৎৱা স নিশাচতুর্থযামে সিন্ধূপরি পদ্ভ্যাং ৱ্রজন্ তেষাং সমীপমেত্য তেষামগ্রে যাতুম্ উদ্যতঃ| ");
INSERT INTO sanben_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","কিন্তু শিষ্যাঃ সিন্ধূপরি তং ৱ্রজন্তং দৃষ্ট্ৱা ভূতমনুমায রুরুৱুঃ, ");
INSERT INTO sanben_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","যতঃ সর্ৱ্ৱে তং দৃষ্ট্ৱা ৱ্যাকুলিতাঃ| অতএৱ যীশুস্তৎক্ষণং তৈঃ সহালপ্য কথিতৱান্, সুস্থিরা ভূত, অযমহং মা ভৈষ্ট| ");
INSERT INTO sanben_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","অথ নৌকামারুহ্য তস্মিন্ তেষাং সন্নিধিং গতে ৱাতো নিৱৃত্তঃ; তস্মাত্তে মনঃসু ৱিস্মিতা আশ্চর্য্যং মেনিরে| ");
INSERT INTO sanben_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","যতস্তে মনসাং কাঠিন্যাৎ তৎ পূপীযম্ আশ্চর্য্যং কর্ম্ম ন ৱিৱিক্তৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","অথ তে পারং গৎৱা গিনেষরৎপ্রদেশমেত্য তট উপস্থিতাঃ| ");
INSERT INTO sanben_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","তেষু নৌকাতো বহির্গতেষু তৎপ্রদেশীযা লোকাস্তং পরিচিত্য ");
INSERT INTO sanben_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","চতুর্দিক্ষু ধাৱন্তো যত্র যত্র রোগিণো নরা আসন্ তান্ সর্ৱ্ৱান খট্ৱোপরি নিধায যত্র কুত্রচিৎ তদ্ৱার্ত্তাং প্রাপুঃ তৎ স্থানম্ আনেতুম্ আরেভিরে| ");
INSERT INTO sanben_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","তথা যত্র যত্র গ্রামে যত্র যত্র পুরে যত্র যত্র পল্ল্যাঞ্চ তেন প্রৱেশঃ কৃতস্তদ্ৱর্ত্মমধ্যে লোকাঃ পীডিতান্ স্থাপযিৎৱা তস্য চেলগ্রন্থিমাত্রং স্প্রষ্টুম্ তেষামর্থে তদনুজ্ঞাং প্রার্থযন্তঃ যাৱন্তো লোকাঃ পস্পৃশুস্তাৱন্ত এৱ গদান্মুক্তাঃ| ");
INSERT INTO sanben_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","অনন্তরং যিরূশালম আগতাঃ ফিরূশিনোঽধ্যাপকাশ্চ যীশোঃ সমীপম্ আগতাঃ| ");
INSERT INTO sanben_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","তে তস্য কিযতঃ শিষ্যান্ অশুচিকরৈরর্থাদ অপ্রক্ষালিতহস্তৈ র্ভুঞ্জতো দৃষ্ট্ৱা তানদূষযন্| ");
INSERT INTO sanben_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","যতঃ ফিরূশিনঃ সর্ৱ্ৱযিহূদীযাশ্চ প্রাচাং পরম্পরাগতৱাক্যং সম্মন্য প্রতলেন হস্তান্ অপ্রক্ষাল্য ন ভুঞ্জতে| ");
INSERT INTO sanben_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","আপনাদাগত্য মজ্জনং ৱিনা ন খাদন্তি; তথা পানপাত্রাণাং জলপাত্রাণাং পিত্তলপাত্রাণাম্ আসনানাঞ্চ জলে মজ্জনম্ ইত্যাদযোন্যেপি বহৱস্তেষামাচারাঃ সন্তি| ");
INSERT INTO sanben_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","তে ফিরূশিনোঽধ্যাপকাশ্চ যীশুং পপ্রচ্ছুঃ, তৱ শিষ্যাঃ প্রাচাং পরম্পরাগতৱাক্যানুসারেণ নাচরন্তোঽপ্রক্ষালিতকরৈঃ কুতো ভুজংতে? ");
INSERT INTO sanben_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ততঃ স প্রত্যুৱাচ কপটিনো যুষ্মান্ উদ্দিশ্য যিশযিযভৱিষ্যদ্ৱাদী যুক্তমৱাদীৎ| যথা স্ৱকীযৈরধরৈরেতে সম্মন্যনতে সদৈৱ মাং| কিন্তু মত্তো ৱিপ্রকর্ষে সন্তি তেষাং মনাংসি চ| ");
INSERT INTO sanben_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","শিক্ষযন্তো বিধীন্ ন্নাজ্ঞা ভজন্তে মাং মুধৈৱ তে| ");
INSERT INTO sanben_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","যূযং জলপাত্রপানপাত্রাদীনি মজ্জযন্তো মনুজপরম্পরাগতৱাক্যং রক্ষথ কিন্তু ঈশ্ৱরাজ্ঞাং লংঘধ্ৱে; অপরা ঈদৃশ্যোনেকাঃ ক্রিযা অপি কুরুধ্ৱে| ");
INSERT INTO sanben_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","অন্যঞ্চাকথযৎ যূযং স্ৱপরম্পরাগতৱাক্যস্য রক্ষার্থং স্পষ্টরূপেণ ঈশ্ৱরাজ্ঞাং লোপযথ| ");
INSERT INTO sanben_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","যতো মূসাদ্ৱারা প্রোক্তমস্তি স্ৱপিতরৌ সম্মন্যধ্ৱং যস্তু মাতরং পিতরং ৱা দুর্ৱ্ৱাক্যং ৱক্তি স নিতান্তং হন্যতাং| ");
INSERT INTO sanben_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","কিন্তু মদীযেন যেন দ্রৱ্যেণ তৱোপকারোভৱৎ তৎ কর্ব্বাণমর্থাদ্ ঈশ্ৱরায নিৱেদিতম্ ইদং ৱাক্যং যদি কোপি পিতরং মাতরং ৱা ৱক্তি ");
INSERT INTO sanben_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","তর্হি যূযং মাতুঃ পিতু র্ৱোপকারং কর্ত্তাং তং ৱারযথ| ");
INSERT INTO sanben_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ইত্থং স্ৱপ্রচারিতপরম্পরাগতৱাক্যেন যূযম্ ঈশ্ৱরাজ্ঞাং মুধা ৱিধদ্ৱ্ৱে, ঈদৃশান্যন্যান্যনেকানি কর্ম্মাণি কুরুধ্ৱে| ");
INSERT INTO sanben_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","অথ স লোকানাহূয বভাষে যূযং সর্ৱ্ৱে মদ্ৱাক্যং শৃণুত বুধ্যধ্ৱঞ্চ| ");
INSERT INTO sanben_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","বাহ্যাদন্তরং প্রৱিশ্য নরমমেধ্যং কর্ত্তাং শক্নোতি ঈদৃশং কিমপি ৱস্তু নাস্তি, ৱরম্ অন্তরাদ্ বহির্গতং যদ্ৱস্তু তন্মনুজম্ অমেধ্যং করোতি| ");
INSERT INTO sanben_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","যস্য শ্রোতুং শ্রোত্রে স্তঃ স শৃণোতু| ");
INSERT INTO sanben_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","ততঃ স লোকান্ হিৎৱা গৃহমধ্যং প্রৱিষ্টস্তদা শিষ্যাস্তদৃষ্টান্তৱাক্যার্থং পপ্রচ্ছুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","তস্মাৎ স তান্ জগাদ যূযমপি কিমেতাদৃগবোধাঃ? কিমপি দ্রৱ্যং বাহ্যাদন্তরং প্রৱিশ্য নরমমেধ্যং কর্ত্তাং ন শক্নোতি কথামিমাং কিং ন বুধ্যধ্ৱে? ");
INSERT INTO sanben_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","তৎ তদন্তর্ন প্রৱিশতি কিন্তু কুক্ষিমধ্যং প্রৱিশতি শেষে সর্ৱ্ৱভুক্তৱস্তুগ্রাহিণি বহির্দেশে নির্যাতি| ");
INSERT INTO sanben_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","অপরমপ্যৱাদীদ্ যন্নরান্নিরেতি তদেৱ নরমমেধ্যং করোতি| ");
INSERT INTO sanben_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","যতোঽন্তরাদ্ অর্থান্ মানৱানাং মনোভ্যঃ কুচিন্তা পরস্ত্রীৱেশ্যাগমনং ");
INSERT INTO sanben_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","নরৱধশ্চৌর্য্যং লোভো দুষ্টতা প্রৱঞ্চনা কামুকতা কুদৃষ্টিরীশ্ৱরনিন্দা গর্ৱ্ৱস্তম ইত্যাদীনি নির্গচ্ছন্তি| ");
INSERT INTO sanben_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","এতানি সর্ৱ্ৱাণি দুরিতান্যন্তরাদেত্য নরমমেধ্যং কুর্ৱ্ৱন্তি| ");
INSERT INTO sanben_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","অথ স উত্থায তৎস্থানাৎ সোরসীদোন্পুরপ্রদেশং জগাম তত্র কিমপি নিৱেশনং প্রৱিশ্য সর্ৱ্ৱৈরজ্ঞাতঃ স্থাতুং মতিঞ্চক্রে কিন্তু গুপ্তঃ স্থাতুং ন শশাক| ");
INSERT INTO sanben_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","যতঃ সুরফৈনিকীদেশীযযূনানীৱংশোদ্ভৱস্ত্রিযাঃ কন্যা ভূতগ্রস্তাসীৎ| সা স্ত্রী তদ্ৱার্ত্তাং প্রাপ্য তৎসমীপমাগত্য তচ্চরণযোঃ পতিৎৱা ");
INSERT INTO sanben_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","স্ৱকন্যাতো ভূতং নিরাকর্ত্তাং তস্মিন্ ৱিনযং কৃতৱতী| ");
INSERT INTO sanben_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","কিন্তু যীশুস্তামৱদৎ প্রথমং বালকাস্তৃপ্যন্তু যতো বালকানাং খাদ্যং গৃহীৎৱা কুক্কুরেভ্যো নিক্ষেপোঽনুচিতঃ| ");
INSERT INTO sanben_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","তদা সা স্ত্রী তমৱাদীৎ ভোঃ প্রভো তৎ সত্যং তথাপি মঞ্চাধঃস্থাঃ কুক্কুরা বালানাং করপতিতানি খাদ্যখণ্ডানি খাদন্তি| ");
INSERT INTO sanben_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ততঃ সোঽকথযদ্ এতৎকথাহেতোঃ সকুশলা যাহি তৱ কন্যাং ত্যক্ত্ৱা ভূতো গতঃ| ");
INSERT INTO sanben_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","অথ সা স্ত্রী গৃহং গৎৱা কন্যাং ভূতত্যক্তাং শয্যাস্থিতাং দদর্শ| ");
INSERT INTO sanben_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","পুনশ্চ স সোরসীদোন্পুরপ্রদেশাৎ প্রস্থায দিকাপলিদেশস্য প্রান্তরভাগেন গালীল্জলধেঃ সমীপং গতৱান্| ");
INSERT INTO sanben_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","তদা লোকৈরেকং বধিরং কদ্ৱদঞ্চ নরং তন্নিকটমানীয তস্য গাত্রে হস্তমর্পযিতুং ৱিনযঃ কৃতঃ| ");
INSERT INTO sanben_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ততো যীশু র্লোকারণ্যাৎ তং নির্জনমানীয তস্য কর্ণযোঙ্গুলী র্দদৌ নিষ্ঠীৱং দত্ত্ৱা চ তজ্জিহ্ৱাং পস্পর্শ| ");
INSERT INTO sanben_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","অনন্তরং স্ৱর্গং নিরীক্ষ্য দীর্ঘং নিশ্ৱস্য তমৱদৎ ইতফতঃ অর্থান্ মুক্তো ভূযাৎ| ");
INSERT INTO sanben_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ততস্তৎক্ষণং তস্য কর্ণৌ মুক্তৌ জিহ্ৱাযাশ্চ জাড্যাপগমাৎ স সুস্পষ্টৱাক্যমকথযৎ| ");
INSERT INTO sanben_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","অথ স তান্ ৱাঢমিত্যাদিদেশ যূযমিমাং কথাং কস্মৈচিদপি মা কথযত, কিন্তু স যতি ন্যষেধৎ তে ততি বাহুল্যেন প্রাচারযন্; ");
INSERT INTO sanben_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","তেঽতিচমৎকৃত্য পরস্পরং কথযামাসুঃ স বধিরায শ্রৱণশক্তিং মূকায চ কথনশক্তিং দত্ত্ৱা সর্ৱ্ৱং কর্ম্মোত্তমরূপেণ চকার| ");
INSERT INTO sanben_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","তদা তৎসমীপং বহৱো লোকা আযাতা অতস্তেষাং ভোজ্যদ্রৱ্যাভাৱাদ্ যীশুঃ শিষ্যানাহূয জগাদ,| ");
INSERT INTO sanben_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","লোকনিৱহে মম কৃপা জাযতে তে দিনত্রযং মযা সার্দ্ধং সন্তি তেষাং ভোজ্যং কিমপি নাস্তি| ");
INSERT INTO sanben_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","তেষাং মধ্যেঽনেকে দূরাদ্ আগতাঃ, অভুক্তেষু তেষু মযা স্ৱগৃহমভিপ্রহিতেষু তে পথি ক্লমিষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","শিষ্যা অৱাদিষুঃ, এতাৱতো লোকান্ তর্পযিতুম্ অত্র প্রন্তরে পূপান্ প্রাপ্তুং কেন শক্যতে? ");
INSERT INTO sanben_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ততঃ স তান্ পপ্রচ্ছ যুষ্মাকং কতি পূপাঃ সন্তি? তেঽকথযন্ সপ্ত| ");
INSERT INTO sanben_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","ততঃ স তাল্লোকান্ ভুৱি সমুপৱেষ্টুম্ আদিশ্য তান্ সপ্ত পূপান্ ধৃৎৱা ঈশ্ৱরগুণান্ অনুকীর্ত্তযামাস, ভংক্ত্ৱা পরিৱেষযিতুং শিষ্যান্ প্রতি দদৌ, ততস্তে লোকেভ্যঃ পরিৱেষযামাসুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","তথা তেষাং সমীপে যে ক্ষুদ্রমৎস্যা আসন্ তানপ্যাদায ঈশ্ৱরগুণান্ সংকীর্ত্য পরিৱেষযিতুম্ আদিষ্টৱান্| ");
INSERT INTO sanben_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ততো লোকা ভুক্ত্ৱা তৃপ্তিং গতা অৱশিষ্টখাদ্যৈঃ পূর্ণাঃ সপ্তডল্লকা গৃহীতাশ্চ| ");
INSERT INTO sanben_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","এতে ভোক্তারঃ প্রাযশ্চতুঃ সহস্রপুরুষা আসন্ ততঃ স তান্ ৱিসসর্জ| ");
INSERT INTO sanben_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","অথ স শিষ্যঃ সহ নাৱমারুহ্য দল্মানূথাসীমামাগতঃ| ");
INSERT INTO sanben_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ততঃ পরং ফিরূশিন আগত্য তেন সহ ৱিৱদমানাস্তস্য পরীক্ষার্থম্ আকাশীযচিহ্নং দ্রষ্টুং যাচিতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","তদা সোঽন্তর্দীর্ঘং নিশ্ৱস্যাকথযৎ, এতে ৱিদ্যমাননরাঃ কুতশ্চিন্হং মৃগযন্তে? যুষ্মানহং যথার্থং ব্রৱীমি লোকানেতান্ কিমপি চিহ্নং ন দর্শযিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","অথ তান্ হিৎৱা পুন র্নাৱম্ আরুহ্য পারমগাৎ| ");
INSERT INTO sanben_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","এতর্হি শিষ্যৈঃ পূপেষু ৱিস্মৃতেষু নাৱি তেষাং সন্নিধৌ পূপ একএৱ স্থিতঃ| ");
INSERT INTO sanben_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","তদানীং যীশুস্তান্ আদিষ্টৱান্ ফিরূশিনাং হেরোদশ্চ কিণ্ৱং প্রতি সতর্কাঃ সাৱধানাশ্চ ভৱত| ");
INSERT INTO sanben_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ততস্তেঽন্যোন্যং ৱিৱেচনং কর্তুম্ আরেভিরে, অস্মাকং সন্নিধৌ পূপো নাস্তীতি হেতোরিদং কথযতি| ");
INSERT INTO sanben_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","তদ্ বুদ্ৱ্ৱা যীশুস্তেভ্যোঽকথযৎ যুষ্মাকং স্থানে পূপাভাৱাৎ কুত ইত্থং ৱিতর্কযথ? যূযং কিমদ্যাপি কিমপি ন জানীথ? বোদ্ধুঞ্চ ন শক্নুথ? যাৱদদ্য কিং যুষ্মাকং মনাংসি কঠিনানি সন্তি? ");
INSERT INTO sanben_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","সৎসু নেত্রেষু কিং ন পশ্যথ? সৎসু কর্ণেষু কিং ন শৃণুথ? ন স্মরথ চ? ");
INSERT INTO sanben_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","যদাহং পঞ্চপূপান্ পঞ্চসহস্রাণাং পুরুষাণাং মধ্যে ভংক্ত্ৱা দত্তৱান্ তদানীং যূযম্ অৱশিষ্টপূপৈঃ পূর্ণান্ কতি ডল্লকান্ গৃহীতৱন্তঃ? তেঽকথযন্ দ্ৱাদশডল্লকান্| ");
INSERT INTO sanben_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","অপরঞ্চ যদা চতুঃসহস্রাণাং পুরুষাণাং মধ্যে পূপান্ ভংক্ত্ৱাদদাং তদা যূযম্ অতিরিক্তপূপানাং কতি ডল্লকান্ গৃহীতৱন্তঃ? তে কথযামাসুঃ সপ্তডল্লকান্| ");
INSERT INTO sanben_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","তদা স কথিতৱান্ তর্হি যূযম্ অধুনাপি কুতো বোদ্ৱ্ৱুং ন শক্নুথ? ");
INSERT INTO sanben_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","অনন্তরং তস্মিন্ বৈৎসৈদানগরে প্রাপ্তে লোকা অন্ধমেকং নরং তৎসমীপমানীয তং স্প্রষ্টুং তং প্রার্থযাঞ্চক্রিরে| ");
INSERT INTO sanben_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","তদা তস্যান্ধস্য করৌ গৃহীৎৱা নগরাদ্ বহির্দেশং তং নীতৱান্; তন্নেত্রে নিষ্ঠীৱং দত্ত্ৱা তদ্গাত্রে হস্তাৱর্পযিৎৱা তং পপ্রচ্ছ, কিমপি পশ্যসি? ");
INSERT INTO sanben_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","স নেত্রে উন্মীল্য জগাদ, ৱৃক্ষৱৎ মনুজান্ গচ্ছতো নিরীক্ষে| ");
INSERT INTO sanben_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ততো যীশুঃ পুনস্তস্য নযনযো র্হস্তাৱর্পযিৎৱা তস্য নেত্রে উন্মীলযামাস; তস্মাৎ স স্ৱস্থো ভূৎৱা স্পষ্টরূপং সর্ৱ্ৱলোকান্ দদর্শ| ");
INSERT INTO sanben_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ততঃ পরং ৎৱং গ্রামং মা গচ্ছ গ্রামস্থং কমপি চ কিমপ্যনুক্ত্ৱা নিজগৃহং যাহীত্যাদিশ্য যীশুস্তং নিজগৃহং প্রহিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","অনন্তরং শিষ্যৈঃ সহিতো যীশুঃ কৈসরীযাফিলিপিপুরং জগাম, পথি গচ্ছন্ তানপৃচ্ছৎ কোঽহম্ অত্র লোকাঃ কিং ৱদন্তি? ");
INSERT INTO sanben_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","তে প্রত্যূচুঃ ৎৱাং যোহনং মজ্জকং ৱদন্তি কিন্তু কেপি কেপি এলিযং ৱদন্তি; অপরে কেপি কেপি ভৱিষ্যদ্ৱাদিনাম্ একো জন ইতি ৱদন্তি| ");
INSERT INTO sanben_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","অথ স তানপৃচ্ছৎ কিন্তু কোহম্? ইত্যত্র যূযং কিং ৱদথ? তদা পিতরঃ প্রত্যৱদৎ ভৱান্ অভিষিক্তস্ত্রাতা| ");
INSERT INTO sanben_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","ততঃ স তান্ গাঢমাদিশদ্ যূযং মম কথা কস্মৈচিদপি মা কথযত| ");
INSERT INTO sanben_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","মনুষ্যপুত্রেণাৱশ্যং বহৱো যাতনা ভোক্তৱ্যাঃ প্রাচীনলোকৈঃ প্রধানযাজকৈরধ্যাপকৈশ্চ স নিন্দিতঃ সন্ ঘাতযিষ্যতে তৃতীযদিনে উত্থাস্যতি চ, যীশুঃ শিষ্যানুপদেষ্টুমারভ্য কথামিমাং স্পষ্টমাচষ্ট| ");
INSERT INTO sanben_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","তস্মাৎ পিতরস্তস্য হস্তৌ ধৃৎৱা তং তর্জ্জিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","কিন্তু স মুখং পরাৱর্ত্য শিষ্যগণং নিরীক্ষ্য পিতরং তর্জযিৎৱাৱাদীদ্ দূরীভৱ ৱিঘ্নকারিন্ ঈশ্ৱরীযকার্য্যাদপি মনুষ্যকার্য্যং তুভ্যং রোচততরাং| ");
INSERT INTO sanben_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","অথ স লোকান্ শিষ্যাংশ্চাহূয জগাদ যঃ কশ্চিন্ মামনুগন্তুম্ ইচ্ছতি স আত্মানং দাম্যতু, স্ৱক্রুশং গৃহীৎৱা মৎপশ্চাদ্ আযাতু| ");
INSERT INTO sanben_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","যতো যঃ কশ্চিৎ স্ৱপ্রাণং রক্ষিতুমিচ্ছতি স তং হারযিষ্যতি, কিন্তু যঃ কশ্চিন্ মদর্থং সুসংৱাদার্থঞ্চ প্রাণং হারযতি স তং রক্ষিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","অপরঞ্চ মনুজঃ সর্ৱ্ৱং জগৎ প্রাপ্য যদি স্ৱপ্রাণং হারযতি তর্হি তস্য কো লাভঃ? ");
INSERT INTO sanben_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","নরঃ স্ৱপ্রাণৱিনিমযেন কিং দাতুং শক্নোতি? ");
INSERT INTO sanben_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","এতেষাং ৱ্যভিচারিণাং পাপিনাঞ্চ লোকানাং সাক্ষাদ্ যদি কোপি মাং মৎকথাঞ্চ লজ্জাস্পদং জানাতি তর্হি মনুজপুত্রো যদা ধর্ম্মদূতৈঃ সহ পিতুঃ প্রভাৱেণাগমিষ্যতি তদা সোপি তং লজ্জাস্পদং জ্ঞাস্যতি| ");
INSERT INTO sanben_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","অথ স তানৱাদীৎ যুষ্মভ্যমহং যথার্থং কথযামি, ঈশ্ৱররাজ্যং পরাক্রমেণোপস্থিতং ন দৃষ্ট্ৱা মৃত্যুং নাস্ৱাদিষ্যন্তে, অত্র দণ্ডাযমানানাং মধ্যেপি তাদৃশা লোকাঃ সন্তি| ");
INSERT INTO sanben_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","অথ ষড্দিনেভ্যঃ পরং যীশুঃ পিতরং যাকূবং যোহনঞ্চ গৃহীৎৱা গিরেরুচ্চস্য নির্জনস্থানং গৎৱা তেষাং প্রত্যক্ষে মূর্ত্যন্তরং দধার| ");
INSERT INTO sanben_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ততস্তস্য পরিধেযম্ ঈদৃশম্ উজ্জ্ৱলহিমপাণডরং জাতং যদ্ জগতি কোপি রজকো ন তাদৃক্ পাণডরং কর্ত্তাং শক্নোতি| ");
INSERT INTO sanben_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","অপরঞ্চ এলিযো মূসাশ্চ তেভ্যো দর্শনং দত্ত্ৱা যীশুনা সহ কথনং কর্ত্তুমারেভাতে| ");
INSERT INTO sanben_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","তদা পিতরো যীশুমৱাদীৎ হে গুরোঽস্মাকমত্র স্থিতিরুত্তমা, ততএৱ ৱযং ৎৱৎকৃতে একাং মূসাকৃতে একাম্ এলিযকৃতে চৈকাং, এতাস্তিস্রঃ কুটী র্নির্ম্মাম| ");
INSERT INTO sanben_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","কিন্তু স যদুক্তৱান্ তৎ স্ৱযং ন বুবুধে ততঃ সর্ৱ্ৱে বিভযাঞ্চক্রুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","এতর্হি পযোদস্তান্ ছাদযামাস, মমযাং প্রিযঃ পুত্রঃ কথাসু তস্য মনাংসি নিৱেশযতেতি নভোৱাণী তন্মেদ্যান্নির্যযৌ| ");
INSERT INTO sanben_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","অথ হঠাত্তে চতুর্দিশো দৃষ্ট্ৱা যীশুং ৱিনা স্ৱৈঃ সহিতং কমপি ন দদৃশুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ততঃ পরং গিরেরৱরোহণকালে স তান্ গাঢম্ দূত্যাদিদেশ যাৱন্নরসূনোঃ শ্মশানাদুত্থানং ন ভৱতি, তাৱৎ দর্শনস্যাস্য ৱার্ত্তা যুষ্মাভিঃ কস্মৈচিদপি ন ৱক্তৱ্যা| ");
INSERT INTO sanben_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","তদা শ্মশানাদুত্থানস্য কোভিপ্রায ইতি ৱিচার্য্য তে তদ্ৱাক্যং স্ৱেষু গোপাযাঞ্চক্রিরে| ");
INSERT INTO sanben_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","অথ তে যীশুং পপ্রচ্ছুঃ প্রথমত এলিযেনাগন্তৱ্যম্ ইতি ৱাক্যং কুত উপাধ্যাযা আহুঃ? ");
INSERT INTO sanben_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","তদা স প্রত্যুৱাচ , এলিযঃ প্রথমমেত্য সর্ৱ্ৱকার্য্যাণি সাধযিষ্যতি; নরপুত্রে চ লিপি র্যথাস্তে তথৈৱ সোপি বহুদুঃখং প্রাপ্যাৱজ্ঞাস্যতে| ");
INSERT INTO sanben_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","কিন্ত্ৱহং যুষ্মান্ ৱদামি , এলিযার্থে লিপি র্যথাস্তে তথৈৱ স এত্য যযৌ, লোকা: স্ৱেচ্ছানুরূপং তমভিৱ্যৱহরন্তি স্ম| ");
INSERT INTO sanben_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","অনন্তরং স শিষ্যসমীপমেত্য তেষাং চতুঃপার্শ্ৱে তৈঃ সহ বহুজনান্ ৱিৱদমানান্ অধ্যাপকাংশ্চ দৃষ্টৱান্; ");
INSERT INTO sanben_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","কিন্তু সর্ৱ্ৱলোকাস্তং দৃষ্ট্ৱৈৱ চমৎকৃত্য তদাসন্নং ধাৱন্তস্তং প্রণেমুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","তদা যীশুরধ্যাপকানপ্রাক্ষীদ্ এতৈঃ সহ যূযং কিং ৱিৱদধ্ৱে? ");
INSERT INTO sanben_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ততো লোকানাং কশ্চিদেকঃ প্রত্যৱাদীৎ হে গুরো মম সূনুং মূকং ভূতধৃতঞ্চ ভৱদাসন্নম্ আনযং| ");
INSERT INTO sanben_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","যদাসৌ ভূতস্তমাক্রমতে তদৈৱ পাতসতি তথা স ফেণাযতে, দন্তৈর্দন্তান্ ঘর্ষতি ক্ষীণো ভৱতি চ; ততো হেতোস্তং ভূতং ত্যাজযিতুং ভৱচ্ছিষ্যান্ নিৱেদিতৱান্ কিন্তু তে ন শেকুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","তদা স তমৱাদীৎ, রে অৱিশ্ৱাসিনঃ সন্তানা যুষ্মাভিঃ সহ কতি কালানহং স্থাস্যামি? অপরান্ কতি কালান্ ৱা ৱ আচারান্ সহিষ্যে? তং মদাসন্নমানযত| ");
INSERT INTO sanben_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ততস্তৎসন্নিধিং স আনীযত কিন্তু তং দৃষ্ট্ৱৈৱ ভূতো বালকং ধৃতৱান্; স চ ভূমৌ পতিৎৱা ফেণাযমানো লুলোঠ| ");
INSERT INTO sanben_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","তদা স তৎপিতরং পপ্রচ্ছ, অস্যেদৃশী দশা কতি দিনানি ভূতা? ততঃ সোৱাদীৎ বাল্যকালাৎ| ");
INSERT INTO sanben_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","ভূতোযং তং নাশযিতুং বহুৱারান্ ৱহ্নৌ জলে চ ন্যক্ষিপৎ কিন্তু যদি ভৱান কিমপি কর্ত্তাং শক্নোতি তর্হি দযাং কৃৎৱাস্মান্ উপকরোতু| ");
INSERT INTO sanben_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","তদা যীশুস্তমৱদৎ যদি প্রত্যেতুং শক্নোষি তর্হি প্রত্যযিনে জনায সর্ৱ্ৱং সাধ্যম্| ");
INSERT INTO sanben_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ততস্তৎক্ষণং তদ্বালকস্য পিতা প্রোচ্চৈ রূৱন্ সাশ্রুনেত্রঃ প্রোৱাচ, প্রভো প্রত্যেমি মমাপ্রত্যযং প্রতিকুরু| ");
INSERT INTO sanben_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","অথ যীশু র্লোকসঙ্ঘং ধাৱিৎৱাযান্তং দৃষ্ট্ৱা তমপূতভূতং তর্জযিৎৱা জগাদ, রে বধির মূক ভূত ৎৱমেতস্মাদ্ বহির্ভৱ পুনঃ কদাপি মাশ্রযৈনং ৎৱামহম্ ইত্যাদিশামি| ");
INSERT INTO sanben_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","তদা স ভূতশ্চীৎশব্দং কৃৎৱা তমাপীড্য বহির্জজাম, ততো বালকো মৃতকল্পো বভূৱ তস্মাদযং মৃতইত্যনেকে কথযামাসুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","কিন্তু করং ধৃৎৱা যীশুনোত্থাপিতঃ স উত্তস্থৌ| ");
INSERT INTO sanben_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","অথ যীশৌ গৃহং প্রৱিষ্টে শিষ্যা গুপ্তং তং পপ্রচ্ছুঃ, ৱযমেনং ভূতং ত্যাজযিতুং কুতো ন শক্তাঃ? ");
INSERT INTO sanben_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","স উৱাচ, প্রার্থনোপৱাসৌ ৱিনা কেনাপ্যন্যেন কর্ম্মণা ভূতমীদৃশং ত্যাজযিতুং ন শক্যং| ");
INSERT INTO sanben_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","অনন্তরং স তৎস্থানাদিৎৱা গালীল্মধ্যেন যযৌ, কিন্তু তৎ কোপি জানীযাদিতি স নৈচ্ছৎ| ");
INSERT INTO sanben_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","অপরঞ্চ স শিষ্যানুপদিশন্ বভাষে, নরপুত্রো নরহস্তেষু সমর্পযিষ্যতে তে চ তং হনিষ্যন্তি তৈস্তস্মিন্ হতে তৃতীযদিনে স উত্থাস্যতীতি| ");
INSERT INTO sanben_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","কিন্তু তৎকথাং তে নাবুধ্যন্ত প্রষ্টুঞ্চ বিভ্যঃ| ");
INSERT INTO sanben_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","অথ যীশুঃ কফর্নাহূম্পুরমাগত্য মধ্যেগৃহঞ্চেত্য তানপৃচ্ছদ্ ৱর্ত্মমধ্যে যূযমন্যোন্যং কিং ৱিৱদধ্ৱে স্ম? ");
INSERT INTO sanben_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","কিন্তু তে নিরুত্তরাস্তস্থু র্যস্মাত্তেষাং কো মুখ্য ইতি ৱর্ত্মানি তেঽন্যোন্যং ৱ্যৱদন্ত| ");
INSERT INTO sanben_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ততঃ স উপৱিশ্য দ্ৱাদশশিষ্যান্ আহূয বভাষে যঃ কশ্চিৎ মুখ্যো ভৱিতুমিচ্ছতি স সর্ৱ্ৱেভ্যো গৌণঃ সর্ৱ্ৱেষাং সেৱকশ্চ ভৱতু| ");
INSERT INTO sanben_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","তদা স বালকমেকং গৃহীৎৱা মধ্যে সমুপাৱেশযৎ ততস্তং ক্রোডে কৃৎৱা তানৱাদাৎ ");
INSERT INTO sanben_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","যঃ কশ্চিদীদৃশস্য কস্যাপি বালস্যাতিথ্যং করোতি স মমাতিথ্যং করোতি; যঃ কশ্চিন্মমাতিথ্যং করোতি স কেৱলম্ মমাতিথ্যং করোতি তন্ন মৎপ্রেরকস্যাপ্যাতিথ্যং করোতি| ");
INSERT INTO sanben_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","অথ যোহন্ তমব্রৱীৎ হে গুরো, অস্মাকমননুগামিনম্ একং ৎৱান্নাম্না ভূতান্ ত্যাজযন্তং ৱযং দৃষ্টৱন্তঃ, অস্মাকমপশ্চাদ্গামিৎৱাচ্চ তং ন্যষেধাম| ");
INSERT INTO sanben_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","কিন্তু যীশুরৱদৎ তং মা নিষেধৎ, যতো যঃ কশ্চিন্ মন্নাম্না চিত্রং কর্ম্ম করোতি স সহসা মাং নিন্দিতুং ন শক্নোতি| ");
INSERT INTO sanben_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","তথা যঃ কশ্চিদ্ যুষ্মাকং ৱিপক্ষতাং ন করোতি স যুষ্মাকমেৱ সপক্ষঃ| ");
INSERT INTO sanben_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","যঃ কশ্চিদ্ যুষ্মান্ খ্রীষ্টশিষ্যান্ জ্ঞাৎৱা মন্নাম্না কংসৈকেন পানীযং পাতুং দদাতি, যুষ্মানহং যথার্থং ৱচ্মি, স ফলেন ৱঞ্চিতো ন ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","কিন্তু যদি কশ্চিন্ মযি ৱিশ্ৱাসিনামেষাং ক্ষুদ্রপ্রাণিনাম্ একস্যাপি ৱিঘ্নং জনযতি, তর্হি তস্যৈতৎকর্ম্ম করণাৎ কণ্ঠবদ্ধপেষণীকস্য তস্য সাগরাগাধজল মজ্জনং ভদ্রং| ");
INSERT INTO sanben_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","অতঃ স্ৱকরো যদি ৎৱাং বাধতে তর্হি তং ছিন্ধি; ");
INSERT INTO sanben_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","যস্মাৎ যত্র কীটা ন ম্রিযন্তে ৱহ্নিশ্চ ন নির্ৱ্ৱাতি, তস্মিন্ অনির্ৱ্ৱাণানলনরকে করদ্ৱযৱস্তৱ গমনাৎ করহীনস্য স্ৱর্গপ্রৱেশস্তৱ ক্ষেমং| ");
INSERT INTO sanben_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","যদি তৱ পাদো ৱিঘ্নং জনযতি তর্হি তং ছিন্ধি, ");
INSERT INTO sanben_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","যতো যত্র কীটা ন ম্রিযন্তে ৱহ্নিশ্চ ন নির্ৱ্ৱাতি, তস্মিন্ ঽনির্ৱ্ৱাণৱহ্নৌ নরকে দ্ৱিপাদৱতস্তৱ নিক্ষেপাৎ পাদহীনস্য স্ৱর্গপ্রৱেশস্তৱ ক্ষেমং| ");
INSERT INTO sanben_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","স্ৱনেত্রং যদি ৎৱাং বাধতে তর্হি তদপ্যুৎপাটয, যতো যত্র কীটা ন ম্রিযন্তে ৱহ্নিশ্চ ন নির্ৱ্ৱাতি, ");
INSERT INTO sanben_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","তস্মিন ঽনির্ৱ্ৱাণৱহ্নৌ নরকে দ্ৱিনেত্রস্য তৱ নিক্ষেপাদ্ একনেত্রৱত ঈশ্ৱররাজ্যে প্রৱেশস্তৱ ক্ষেমং| ");
INSERT INTO sanben_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","যথা সর্ৱ্ৱো বলি র্লৱণাক্তঃ ক্রিযতে তথা সর্ৱ্ৱো জনো ৱহ্নিরূপেণ লৱণাক্তঃ কারিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","লৱণং ভদ্রং কিন্তু যদি লৱণে স্ৱাদুতা ন তিষ্ঠতি, তর্হি কথম্ আস্ৱাদ্যুক্তং করিষ্যথ? যূযং লৱণযুক্তা ভৱত পরস্পরং প্রেম কুরুত| ");
INSERT INTO sanben_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","অনন্তরং স তৎস্থানাৎ প্রস্থায যর্দ্দননদ্যাঃ পারে যিহূদাপ্রদেশ উপস্থিতৱান্, তত্র তদন্তিকে লোকানাং সমাগমে জাতে স নিজরীত্যনুসারেণ পুনস্তান্ উপদিদেশ| ");
INSERT INTO sanben_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","তদা ফিরূশিনস্তৎসমীপম্ এত্য তং পরীক্ষিতুং পপ্রচ্ছঃ স্ৱজাযা মনুজানাং ত্যজ্যা ন ৱেতি? ");
INSERT INTO sanben_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ততঃ স প্রত্যৱাদীৎ, অত্র কার্য্যে মূসা যুষ্মান্ প্রতি কিমাজ্ঞাপযৎ? ");
INSERT INTO sanben_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ত ঊচুঃ ত্যাগপত্রং লেখিতুং স্ৱপত্নীং ত্যক্তুঞ্চ মূসাঽনুমন্যতে| ");
INSERT INTO sanben_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","তদা যীশুঃ প্রত্যুৱাচ, যুষ্মাকং মনসাং কাঠিন্যাদ্ধেতো র্মূসা নিদেশমিমম্ অলিখৎ| ");
INSERT INTO sanben_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","কিন্তু সৃষ্টেরাদৌ ঈশ্ৱরো নরান্ পুংরূপেণ স্ত্রীরূপেণ চ সসর্জ| ");
INSERT INTO sanben_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","\"ততঃ কারণাৎ পুমান্ পিতরং মাতরঞ্চ ত্যক্ত্ৱা স্ৱজাযাযাম্ আসক্তো ভৱিষ্যতি, ");
INSERT INTO sanben_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","তৌ দ্ৱাৱ্ একাঙ্গৌ ভৱিষ্যতঃ| \" তস্মাৎ তৎকালমারভ্য তৌ ন দ্ৱাৱ্ একাঙ্গৌ| ");
INSERT INTO sanben_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","অতঃ কারণাদ্ ঈশ্ৱরো যদযোজযৎ কোপি নরস্তন্ন ৱিযেজযেৎ| ");
INSERT INTO sanben_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","অথ যীশু র্গৃহং প্রৱিষ্টস্তদা শিষ্যাঃ পুনস্তৎকথাং তং পপ্রচ্ছুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ততঃ সোৱদৎ কশ্চিদ্ যদি স্ৱভার্য্যাং ত্যক্তৱান্যাম্ উদ্ৱহতি তর্হি স স্ৱভার্য্যাযাঃ প্রাতিকূল্যেন ৱ্যভিচারী ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","কাচিন্নারী যদি স্ৱপতিং হিৎৱান্যপুংসা ৱিৱাহিতা ভৱতি তর্হি সাপি ৱ্যভিচারিণী ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","অথ স যথা শিশূন্ স্পৃশেৎ, তদর্থং লোকৈস্তদন্তিকং শিশৱ আনীযন্ত, কিন্তু শিষ্যাস্তানানীতৱতস্তর্জযামাসুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","যীশুস্তদ্ দৃষ্ট্ৱা ক্রুধ্যন্ জগাদ, মন্নিকটম্ আগন্তুং শিশূন্ মা ৱারযত, যত এতাদৃশা ঈশ্ৱররাজ্যাধিকারিণঃ| ");
INSERT INTO sanben_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","যুষ্মানহং যথার্থং ৱচ্মি, যঃ কশ্চিৎ শিশুৱদ্ ভূৎৱা রাজ্যমীশ্ৱরস্য ন গৃহ্লীযাৎ স কদাপি তদ্রাজ্যং প্রৱেষ্টুং ন শক্নোতি| ");
INSERT INTO sanben_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","অননতরং স শিশূনঙ্কে নিধায তেষাং গাত্রেষু হস্তৌ দত্ত্ৱাশিষং বভাষে| ");
INSERT INTO sanben_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","অথ স ৱর্ত্মনা যাতি, এতর্হি জন একো ধাৱন্ আগত্য তৎসম্মুখে জানুনী পাতযিৎৱা পৃষ্টৱান্, ভোঃ পরমগুরো, অনন্তাযুঃ প্রাপ্তযে মযা কিং কর্ত্তৱ্যং? ");
INSERT INTO sanben_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","তদা যীশুরুৱাচ, মাং পরমং কুতো ৱদসি? ৱিনেশ্ৱরং কোপি পরমো ন ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","পরস্ত্রীং নাভিগচ্ছ; নরং মা ঘাতয; স্তেযং মা কুরু; মৃষাসাক্ষ্যং মা দেহি; হিংসাঞ্চ মা কুরু; পিতরৌ সম্মন্যস্ৱ; নিদেশা এতে ৎৱযা জ্ঞাতাঃ| ");
INSERT INTO sanben_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ততস্তন প্রত্যুক্তং, হে গুরো বাল্যকালাদহং সর্ৱ্ৱানেতান্ আচরামি| ");
INSERT INTO sanben_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","তদা যীশুস্তং ৱিলোক্য স্নেহেন বভাষে, তৱৈকস্যাভাৱ আস্তে; ৎৱং গৎৱা সর্ৱ্ৱস্ৱং ৱিক্রীয দরিদ্রেভ্যো ৱিশ্রাণয, ততঃ স্ৱর্গে ধনং প্রাপ্স্যসি; ততঃ পরম্ এত্য ক্রুশং ৱহন্ মদনুৱর্ত্তী ভৱ| ");
INSERT INTO sanben_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","কিন্তু তস্য বহুসম্পদ্ৱিদ্যমানৎৱাৎ স ইমাং কথামাকর্ণ্য ৱিষণো দুঃখিতশ্চ সন্ জগাম| ");
INSERT INTO sanben_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","অথ যীশুশ্চতুর্দিশো নিরীক্ষ্য শিষ্যান্ অৱাদীৎ, ধনিলোকানাম্ ঈশ্ৱররাজ্যপ্রৱেশঃ কীদৃগ্ দুষ্করঃ| ");
INSERT INTO sanben_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","তস্য কথাতঃ শিষ্যাশ্চমচ্চক্রুঃ, কিন্তু স পুনরৱদৎ, হে বালকা যে ধনে ৱিশ্ৱসন্তি তেষাম্ ঈশ্ৱররাজ্যপ্রৱেশঃ কীদৃগ্ দুষ্করঃ| ");
INSERT INTO sanben_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ঈশ্ৱররাজ্যে ধনিনাং প্রৱেশাৎ সূচিরন্ধ্রেণ মহাঙ্গস্য গমনাগমনং সুকরং| ");
INSERT INTO sanben_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","তদা শিষ্যা অতীৱ ৱিস্মিতাঃ পরস্পরং প্রোচুঃ, তর্হি কঃ পরিত্রাণং প্রাপ্তুং শক্নোতি? ");
INSERT INTO sanben_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ততো যীশুস্তান্ ৱিলোক্য বভাষে, তন্ নরস্যাসাধ্যং কিন্তু নেশ্ৱরস্য, যতো হেতোরীশ্ৱরস্য সর্ৱ্ৱং সাধ্যম্| ");
INSERT INTO sanben_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","তদা পিতর উৱাচ, পশ্য ৱযং সর্ৱ্ৱং পরিত্যজ্য ভৱতোনুগামিনো জাতাঃ| ");
INSERT INTO sanben_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","ততো যীশুঃ প্রত্যৱদৎ, যুষ্মানহং যথার্থং ৱদামি, মদর্থং সুসংৱাদার্থং ৱা যো জনঃ সদনং ভ্রাতরং ভগিনীং পিতরং মাতরং জাযাং সন্তানান্ ভূমি ৱা ত্যক্ত্ৱা ");
INSERT INTO sanben_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","গৃহভ্রাতৃভগিনীপিতৃমাতৃপত্নীসন্তানভূমীনামিহ শতগুণান্ প্রেত্যানন্তাযুশ্চ ন প্রাপ্নোতি তাদৃশঃ কোপি নাস্তি| ");
INSERT INTO sanben_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","কিন্ত্ৱগ্রীযা অনেকে লোকাঃ শেষাঃ, শেষীযা অনেকে লোকাশ্চাগ্রা ভৱিষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","অথ যিরূশালম্যানকালে যীশুস্তেষাম্ অগ্রগামী বভূৱ, তস্মাত্তে চিত্রং জ্ঞাৎৱা পশ্চাদ্গামিনো ভূৎৱা বিভ্যুঃ| তদা স পুন র্দ্ৱাদশশিষ্যান্ গৃহীৎৱা স্ৱীযং যদ্যদ্ ঘটিষ্যতে তত্তৎ তেভ্যঃ কথযিতুং প্রারেভে; ");
INSERT INTO sanben_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","পশ্যত ৱযং যিরূশালম্পুরং যামঃ, তত্র মনুষ্যপুত্রঃ প্রধানযাজকানাম্ উপাধ্যাযানাঞ্চ করেষু সমর্পযিষ্যতে; তে চ ৱধদণ্ডাজ্ঞাং দাপযিৎৱা পরদেশীযানাং করেষু তং সমর্পযিষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","তে তমুপহস্য কশযা প্রহৃত্য তদ্ৱপুষি নিষ্ঠীৱং নিক্ষিপ্য তং হনিষ্যন্তি, ততঃ স তৃতীযদিনে প্রোত্থাস্যতি| ");
INSERT INTO sanben_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ততঃ সিৱদেঃ পুত্রৌ যাকূব্যোহনৌ তদন্তিকম্ এত্য প্রোচতুঃ, হে গুরো যদ্ আৱাভ্যাং যাচিষ্যতে তদস্মদর্থং ভৱান্ করোতু নিৱেদনমিদমাৱযোঃ| ");
INSERT INTO sanben_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ততঃ স কথিতৱান্, যুৱাং কিমিচ্ছথঃ? কিং মযা যুষ্মদর্থং করণীযং? ");
INSERT INTO sanben_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","তদা তৌ প্রোচতুঃ, আৱযোরেকং দক্ষিণপার্শ্ৱে ৱামপার্শ্ৱে চৈকং তৱৈশ্ৱর্য্যপদে সমুপৱেষ্টুম্ আজ্ঞাপয| ");
INSERT INTO sanben_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","কিন্তু যীশুঃ প্রত্যুৱাচ যুৱামজ্ঞাৎৱেদং প্রার্থযেথে, যেন কংসেনাহং পাস্যামি তেন যুৱাভ্যাং কিং পাতুং শক্ষ্যতে? যস্মিন্ মজ্জনেনাহং মজ্জিষ্যে তন্মজ্জনে মজ্জযিতুং কিং যুৱাভ্যাং শক্ষ্যতে? তৌ প্রত্যূচতুঃ শক্ষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","তদা যীশুরৱদৎ যেন কংসেনাহং পাস্যামি তেনাৱশ্যং যুৱামপি পাস্যথঃ, যেন মজ্জনেন চাহং মজ্জিয্যে তত্র যুৱামপি মজ্জিষ্যেথে| ");
INSERT INTO sanben_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","কিন্তু যেষামর্থম্ ইদং নিরূপিতং, তান্ ৱিহাযান্যং কমপি মম দক্ষিণপার্শ্ৱে ৱামপার্শ্ৱে ৱা সমুপৱেশযিতুং মমাধিকারো নাস্তি| ");
INSERT INTO sanben_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","অথান্যদশশিষ্যা ইমাং কথাং শ্রুৎৱা যাকূব্যোহন্ভ্যাং চুকুপুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","কিন্তু যীশুস্তান্ সমাহূয বভাষে, অন্যদেশীযানাং রাজৎৱং যে কুর্ৱ্ৱন্তি তে তেষামেৱ প্রভুৎৱং কুর্ৱ্ৱন্তি, তথা যে মহালোকাস্তে তেষাম্ অধিপতিৎৱং কুর্ৱ্ৱন্তীতি যূযং জানীথ| ");
INSERT INTO sanben_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","কিন্তু যুষ্মাকং মধ্যে ন তথা ভৱিষ্যতি, যুষ্মাকং মধ্যে যঃ প্রাধান্যং ৱাঞ্ছতি স যুষ্মাকং সেৱকো ভৱিষ্যতি, ");
INSERT INTO sanben_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","যুষ্মাকং যো মহান্ ভৱিতুমিচ্ছতি স সর্ৱ্ৱেষাং কিঙ্করো ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","যতো মনুষ্যপুত্রঃ সেৱ্যো ভৱিতুং নাগতঃ সেৱাং কর্ত্তাং তথানেকেষাং পরিত্রাণস্য মূল্যরূপস্ৱপ্রাণং দাতুঞ্চাগতঃ| ");
INSERT INTO sanben_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","অথ তে যিরীহোনগরং প্রাপ্তাস্তস্মাৎ শিষ্যৈ র্লোকৈশ্চ সহ যীশো র্গমনকালে টীমযস্য পুত্রো বর্টীমযনামা অন্ধস্তন্মার্গপার্শ্ৱে ভিক্ষার্থম্ উপৱিষ্টঃ| ");
INSERT INTO sanben_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","স নাসরতীযস্য যীশোরাগমনৱার্ত্তাং প্রাপ্য প্রোচৈ র্ৱক্তুমারেভে, হে যীশো দাযূদঃ সন্তান মাং দযস্ৱ| ");
INSERT INTO sanben_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ততোনেকে লোকা মৌনীভৱেতি তং তর্জযামাসুঃ, কিন্তু স পুনরধিকমুচ্চৈ র্জগাদ, হে যীশো দাযূদঃ সন্তান মাং দযস্ৱ| ");
INSERT INTO sanben_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","তদা যীশুঃ স্থিৎৱা তমাহ্ৱাতুং সমাদিদেশ, ততো লোকাস্তমন্ধমাহূয বভাষিরে, হে নর, স্থিরো ভৱ, উত্তিষ্ঠ, স ৎৱামাহ্ৱযতি| ");
INSERT INTO sanben_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","তদা স উত্তরীযৱস্ত্রং নিক্ষিপ্য প্রোত্থায যীশোঃ সমীপং গতঃ| ");
INSERT INTO sanben_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ততো যীশুস্তমৱদৎ ৎৱযা কিং প্রার্থ্যতে? তুভ্যমহং কিং করিষ্যামী? তদা সোন্ধস্তমুৱাচ, হে গুরো মদীযা দৃষ্টির্ভৱেৎ| ");
INSERT INTO sanben_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ততো যীশুস্তমুৱাচ যাহি তৱ ৱিশ্ৱাসস্ত্ৱাং স্ৱস্থমকার্ষীৎ, তস্মাৎ তৎক্ষণং স দৃষ্টিং প্রাপ্য পথা যীশোঃ পশ্চাদ্ যযৌ| ");
INSERT INTO sanben_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","অনন্তরং তেষু যিরূশালমঃ সমীপস্থযো র্বৈৎফগীবৈথনীযপুরযোরন্তিকস্থং জৈতুননামাদ্রিমাগতেষু যীশুঃ প্রেষণকালে দ্ৱৌ শিষ্যাৱিদং ৱাক্যং জগাদ, ");
INSERT INTO sanben_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","যুৱামমুং সম্মুখস্থং গ্রামং যাতং, তত্র প্রৱিশ্য যো নরং নাৱহৎ তং গর্দ্দভশাৱকং দ্রক্ষ্যথস্তং মোচযিৎৱানযতং| ");
INSERT INTO sanben_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","কিন্তু যুৱাং কর্ম্মেদং কুতঃ কুরুথঃ? কথামিমাং যদি কোপি পৃচ্ছতি তর্হি প্রভোরত্র প্রযোজনমস্তীতি কথিতে স শীঘ্রং তমত্র প্রেষযিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ততস্তৌ গৎৱা দ্ৱিমার্গমেলনে কস্যচিদ্ দ্ৱারস্য পার্শ্ৱে তং গর্দ্দভশাৱকং প্রাপ্য মোচযতঃ, ");
INSERT INTO sanben_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","এতর্হি তত্রোপস্থিতলোকানাং কশ্চিদ্ অপৃচ্ছৎ, গর্দ্দভশিশুং কুতো মোচযথঃ? ");
INSERT INTO sanben_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","তদা যীশোরাজ্ঞানুসারেণ তেভ্যঃ প্রত্যুদিতে তৎক্ষণং তমাদাতুং তেঽনুজজ্ঞুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","অথ তৌ যীশোঃ সন্নিধিং গর্দ্দভশিশুম্ আনীয তদুপরি স্ৱৱস্ত্রাণি পাতযামাসতুঃ; ততঃ স তদুপরি সমুপৱিষ্টঃ| ");
INSERT INTO sanben_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","তদানেকে পথি স্ৱৱাসাংসি পাতযামাসুঃ, পরৈশ্চ তরুশাখাশ্ছিতৱা মার্গে ৱিকীর্ণাঃ| ");
INSERT INTO sanben_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","অপরঞ্চ পশ্চাদ্গামিনোঽগ্রগামিনশ্চ সর্ৱ্ৱে জনা উচৈঃস্ৱরেণ ৱক্তুমারেভিরে, জয জয যঃ পরমেশ্ৱরস্য নাম্নাগচ্ছতি স ধন্য ইতি| ");
INSERT INTO sanben_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","তথাস্মাকমং পূর্ৱ্ৱপুরুষস্য দাযূদো যদ্রাজ্যং পরমেশ্ৱরনাম্নাযাতি তদপি ধন্যং, সর্ৱ্ৱস্মাদুচ্ছ্রাযে স্ৱর্গে ঈশ্ৱরস্য জযো ভৱেৎ| ");
INSERT INTO sanben_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ইত্থং যীশু র্যিরূশালমি মন্দিরং প্রৱিশ্য চতুর্দিক্স্থানি সর্ৱ্ৱাণি ৱস্তূনি দৃষ্টৱান্; অথ সাযংকাল উপস্থিতে দ্ৱাদশশিষ্যসহিতো বৈথনিযং জগাম| ");
INSERT INTO sanben_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","অপরেহনি বৈথনিযাদ্ আগমনসমযে ক্ষুধার্ত্তো বভূৱ| ");
INSERT INTO sanben_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ততো দূরে সপত্রমুডুম্বরপাদপং ৱিলোক্য তত্র কিঞ্চিৎ ফলং প্রাপ্তুং তস্য সন্নিকৃষ্টং যযৌ, তদানীং ফলপাতনস্য সমযো নাগচ্ছতি| ততস্তত্রোপস্থিতঃ পত্রাণি ৱিনা কিমপ্যপরং ন প্রাপ্য স কথিতৱান্, ");
INSERT INTO sanben_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","অদ্যারভ্য কোপি মানৱস্ত্ৱত্তঃ ফলং ন ভুঞ্জীত; ইমাং কথাং তস্য শিষ্যাঃ শুশ্রুৱুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","তদনন্তরং তেষু যিরূশালমমাযাতেষু যীশু র্মন্দিরং গৎৱা তত্রস্থানাং বণিজাং মুদ্রাসনানি পারাৱতৱিক্রেতৃণাম্ আসনানি চ ন্যুব্জযাঞ্চকার সর্ৱ্ৱান্ ক্রেতৃন্ ৱিক্রেতৃংশ্চ বহিশ্চকার| ");
INSERT INTO sanben_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","অপরং মন্দিরমধ্যেন কিমপি পাত্রং ৱোঢুং সর্ৱ্ৱজনং নিৱারযামাস| ");
INSERT INTO sanben_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","লোকানুপদিশন্ জগাদ, মম গৃহং সর্ৱ্ৱজাতীযানাং প্রার্থনাগৃহম্ ইতি নাম্না প্রথিতং ভৱিষ্যতি এতৎ কিং শাস্ত্রে লিখিতং নাস্তি? কিন্তু যূযং তদেৱ চোরাণাং গহ্ৱরং কুরুথ| ");
INSERT INTO sanben_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ইমাং ৱাণীং শ্রুৎৱাধ্যাপকাঃ প্রধানযাজকাশ্চ তং যথা নাশযিতুং শক্নুৱন্তি তথোेপাযং মৃগযামাসুঃ, কিন্তু তস্যোপদেশাৎ সর্ৱ্ৱে লোকা ৱিস্মযং গতা অতস্তে তস্মাদ্ বিভ্যুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","অথ সাযংসময উপস্থিতে যীশুর্নগরাদ্ বহির্ৱৱ্রাজ| ");
INSERT INTO sanben_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","অনন্তরং প্রাতঃকালে তে তেন মার্গেণ গচ্ছন্তস্তমুডুম্বরমহীরুহং সমূলং শুষ্কং দদৃশুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ততঃ পিতরঃ পূর্ৱ্ৱৱাক্যং স্মরন্ যীশুং বভাষং, হে গুরো পশ্যতু য উডুম্বরৱিটপী ভৱতা শপ্তঃ স শুষ্কো বভূৱ| ");
INSERT INTO sanben_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ততো যীশুঃ প্রত্যৱাদীৎ, যূযমীশ্ৱরে ৱিশ্ৱসিত| ");
INSERT INTO sanben_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","যুষ্মানহং যথার্থং ৱদামি কোপি যদ্যেতদ্গিরিং ৱদতি, ৎৱমুত্থায গৎৱা জলধৌ পত, প্রোক্তমিদং ৱাক্যমৱশ্যং ঘটিষ্যতে, মনসা কিমপি ন সন্দিহ্য চেদিদং ৱিশ্ৱসেৎ তর্হি তস্য ৱাক্যানুসারেণ তদ্ ঘটিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","অতো হেতোরহং যুষ্মান্ ৱচ্মি, প্রার্থনাকালে যদ্যদাকাংক্ষিষ্যধ্ৱে তত্তদৱশ্যং প্রাপ্স্যথ, ইত্থং ৱিশ্ৱসিত, ততঃ প্রাপ্স্যথ| ");
INSERT INTO sanben_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","অপরঞ্চ যুষ্মাসু প্রার্থযিতুং সমুত্থিতেষু যদি কোপি যুষ্মাকম্ অপরাধী তিষ্ঠতি, তর্হি তং ক্ষমধ্ৱং, তথা কৃতে যুষ্মাকং স্ৱর্গস্থঃ পিতাপি যুষ্মাকমাগাংমি ক্ষমিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","কিন্তু যদি ন ক্ষমধ্ৱে তর্হি ৱঃ স্ৱর্গস্থঃ পিতাপি যুষ্মাকমাগাংসি ন ক্ষমিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","অনন্তরং তে পুন র্যিরূশালমং প্রৱিৱিশুঃ, যীশু র্যদা মধ্যেমন্দিরম্ ইতস্ততো গচ্ছতি, তদানীং প্রধানযাজকা উপাধ্যাযাঃ প্রাঞ্চশ্চ তদন্তিকমেত্য কথামিমাং পপ্রচ্ছুঃ, ");
INSERT INTO sanben_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ৎৱং কেনাদেশেন কর্ম্মাণ্যেতানি করোষি? তথৈতানি কর্ম্মাণি কর্ত্তাং কেনাদিষ্টোসি? ");
INSERT INTO sanben_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ততো যীশুঃ প্রতিগদিতৱান্ অহমপি যুষ্মান্ এককথাং পৃচ্ছামি, যদি যূযং তস্যা উত্তরং কুরুথ, তর্হি কযাজ্ঞযাহং কর্ম্মাণ্যেতানি করোমি তদ্ যুষ্মভ্যং কথযিষ্যামি| ");
INSERT INTO sanben_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","যোহনো মজ্জনম্ ঈশ্ৱরাৎ জাতং কিং মানৱাৎ? তন্মহ্যং কথযত| ");
INSERT INTO sanben_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","তে পরস্পরং ৱিৱেক্তুং প্রারেভিরে, তদ্ ঈশ্ৱরাদ্ বভূৱেতি চেদ্ ৱদামস্তর্হি কুতস্তং ন প্রত্যৈত? কথমেতাং কথযিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","মানৱাদ্ অভৱদিতি চেদ্ ৱদামস্তর্হি লোকেভ্যো ভযমস্তি যতো হেতোঃ সর্ৱ্ৱে যোহনং সত্যং ভৱিষ্যদ্ৱাদিনং মন্যন্তে| ");
INSERT INTO sanben_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","অতএৱ তে যীশুং প্রত্যৱাদিষু র্ৱযং তদ্ ৱক্তুং ন শক্নুমঃ| যীশুরুৱাচ, তর্হি যেনাদেশেন কর্ম্মাণ্যেতানি করোমি, অহমপি যুষ্মভ্যং তন্ন কথযিষ্যামি| ");
INSERT INTO sanben_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","অনন্তরং যীশু র্দৃষ্টান্তেন তেভ্যঃ কথযিতুমারেভে, কশ্চিদেকো দ্রাক্ষাক্ষেত্রং ৱিধায তচ্চতুর্দিক্ষু ৱারণীং কৃৎৱা তন্মধ্যে দ্রাক্ষাপেষণকুণ্ডম্ অখনৎ, তথা তস্য গডমপি নির্ম্মিতৱান্ ততস্তৎক্ষেত্রং কৃষীৱলেষু সমর্প্য দূরদেশং জগাম| ");
INSERT INTO sanben_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","তদনন্তরং ফলকালে কৃষীৱলেভ্যো দ্রাক্ষাক্ষেত্রফলানি প্রাপ্তুং তেষাং সৱিধে ভৃত্যম্ একং প্রাহিণোৎ| ");
INSERT INTO sanben_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","কিন্তু কৃষীৱলাস্তং ধৃৎৱা প্রহৃত্য রিক্তহস্তং ৱিসসৃজুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ততঃ স পুনরন্যমেকং ভৃত্যং প্রষযামাস, কিন্তু তে কৃষীৱলাঃ পাষাণাঘাতৈস্তস্য শিরো ভঙ্ক্ত্ৱা সাপমানং তং ৱ্যসর্জন্| ");
INSERT INTO sanben_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ততঃ পরং সোপরং দাসং প্রাহিণোৎ তদা তে তং জঘ্নুঃ, এৱম্ অনেকেষাং কস্যচিৎ প্রহারঃ কস্যচিদ্ ৱধশ্চ তৈঃ কৃতঃ| ");
INSERT INTO sanben_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ততঃ পরং মযা স্ৱপুত্রে প্রহিতে তে তমৱশ্যং সম্মংস্যন্তে, ইত্যুক্ত্ৱাৱশেষে তেষাং সন্নিধৌ নিজপ্রিযম্ অদ্ৱিতীযং পুত্রং প্রেষযামাস| ");
INSERT INTO sanben_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","কিন্তু কৃষীৱলাঃ পরস্পরং জগদুঃ, এষ উত্তরাধিকারী, আগচ্ছত ৱযমেনং হন্মস্তথা কৃতে ঽধিকারোযম্ অস্মাকং ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ততস্তং ধৃৎৱা হৎৱা দ্রাক্ষাক্ষেত্রাদ্ বহিঃ প্রাক্ষিপন্| ");
INSERT INTO sanben_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","অনেনাসৌ দ্রাক্ষাক্ষেত্রপতিঃ কিং করিষ্যতি? স এত্য তান্ কৃষীৱলান্ সংহত্য তৎক্ষেত্রম্ অন্যেষু কৃষীৱলেষু সমর্পযিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","অপরঞ্চ, \"স্থপতযঃ করিষ্যন্তি গ্রাৱাণং যন্তু তুচ্ছকং| প্রাধানপ্রস্তরঃ কোণে স এৱ সংভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","এতৎ কর্ম্ম পরেশস্যাংদ্ভুতং নো দৃষ্টিতো ভৱেৎ|| \" ইমাং শাস্ত্রীযাং লিপিং যূযং কিং নাপাঠিষ্ট? ");
INSERT INTO sanben_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","তদানীং স তানুদ্দিশ্য তাং দৃষ্টান্তকথাং কথিতৱান্, ত ইত্থং বুদ্ৱ্ৱা তং ধর্ত্তামুদ্যতাঃ, কিন্তু লোকেভ্যো বিভ্যুঃ, তদনন্তরং তে তং ৱিহায ৱৱ্রজুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","অপরঞ্চ তে তস্য ৱাক্যদোষং ধর্ত্তাং কতিপযান্ ফিরূশিনো হেরোদীযাংশ্চ লোকান্ তদন্তিকং প্রেষযামাসুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ত আগত্য তমৱদন্, হে গুরো ভৱান্ তথ্যভাষী কস্যাপ্যনুরোধং ন মন্যতে, পক্ষপাতঞ্চ ন করোতি, যথার্থত ঈশ্ৱরীযং মার্গং দর্শযতি ৱযমেতৎ প্রজানীমঃ, কৈসরায করো দেযো ন ৱাং? ৱযং দাস্যামো ন ৱা? ");
INSERT INTO sanben_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","কিন্তু স তেষাং কপটং জ্ঞাৎৱা জগাদ, কুতো মাং পরীক্ষধ্ৱে? একং মুদ্রাপাদং সমানীয মাং দর্শযত| ");
INSERT INTO sanben_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","তদা তৈরেকস্মিন্ মুদ্রাপাদে সমানীতে স তান্ পপ্রচ্ছ, অত্র লিখিতং নাম মূর্ত্তি র্ৱা কস্য? তে প্রত্যূচুঃ, কৈসরস্য| ");
INSERT INTO sanben_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","তদা যীশুরৱদৎ তর্হি কৈসরস্য দ্রৱ্যাণি কৈসরায দত্ত, ঈশ্ৱরস্য দ্রৱ্যাণি তু ঈশ্ৱরায দত্ত; ততস্তে ৱিস্মযং মেনিরে| ");
INSERT INTO sanben_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","অথ মৃতানামুত্থানং যে ন মন্যন্তে তে সিদূকিনো যীশোঃ সমীপমাগত্য তং পপ্রচ্ছুঃ; ");
INSERT INTO sanben_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","হে গুরো কশ্চিজ্জনো যদি নিঃসন্ততিঃ সন্ ভার্য্যাযাং সত্যাং ম্রিযতে তর্হি তস্য ভ্রাতা তস্য ভার্য্যাং গৃহীৎৱা ভ্রাতু র্ৱংশোৎপত্তিং করিষ্যতি, ৱ্যৱস্থামিমাং মূসা অস্মান্ প্রতি ৱ্যলিখৎ| ");
INSERT INTO sanben_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","কিন্তু কেচিৎ সপ্ত ভ্রাতর আসন্, ততস্তেষাং জ্যেষ্ঠভ্রাতা ৱিৱহ্য নিঃসন্ততিঃ সন্ অম্রিযত| ");
INSERT INTO sanben_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ততো দ্ৱিতীযো ভ্রাতা তাং স্ত্রিযমগৃহণৎ কিন্তু সোপি নিঃসন্ততিঃ সন্ অম্রিযত; অথ তৃতীযোপি ভ্রাতা তাদৃশোভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ইত্থং সপ্তৈৱ ভ্রাতরস্তাং স্ত্রিযং গৃহীৎৱা নিঃসন্তানাঃ সন্তোঽম্রিযন্ত, সর্ৱ্ৱশেষে সাপি স্ত্রী ম্রিযতে স্ম| ");
INSERT INTO sanben_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","অথ মৃতানামুত্থানকালে যদা ত উত্থাস্যন্তি তদা তেষাং কস্য ভার্য্যা সা ভৱিষ্যতি? যতস্তে সপ্তৈৱ তাং ৱ্যৱহন্| ");
INSERT INTO sanben_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ততো যীশুঃ প্রত্যুৱাচ শাস্ত্রম্ ঈশ্ৱরশক্তিঞ্চ যূযমজ্ঞাৎৱা কিমভ্রাম্যত ন? ");
INSERT INTO sanben_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","মৃতলোকানামুত্থানং সতি তে ন ৱিৱহন্তি ৱাগ্দত্তা অপি ন ভৱন্তি, কিন্তু স্ৱর্গীযদূতানাং সদৃশা ভৱন্তি| ");
INSERT INTO sanben_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","পুনশ্চ \"অহম্ ইব্রাহীম ঈশ্ৱর ইস্হাক ঈশ্ৱরো যাকূবশ্চেশ্ৱরঃ\" যামিমাং কথাং স্তম্বমধ্যে তিষ্ঠন্ ঈশ্ৱরো মূসামৱাদীৎ মৃতানামুত্থানার্থে সা কথা মূসালিখিতে পুস্তকে কিং যুষ্মাভি র্নাপাঠি? ");
INSERT INTO sanben_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ঈশ্ৱরো জীৱতাং প্রভুঃ কিন্তু মৃতানাং প্রভু র্ন ভৱতি, তস্মাদ্ধেতো র্যূযং মহাভ্রমেণ তিষ্ঠথ| ");
INSERT INTO sanben_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","এতর্হি একোধ্যাপক এত্য তেষামিত্থং ৱিচারং শুশ্রাৱ; যীশুস্তেষাং ৱাক্যস্য সদুত্তরং দত্তৱান্ ইতি বুদ্ৱ্ৱা তং পৃষ্টৱান্ সর্ৱ্ৱাসাম্ আজ্ঞানাং কা শ্রেষ্ঠা? ততো যীশুঃ প্রত্যুৱাচ, ");
INSERT INTO sanben_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","\"হে ইস্রাযেল্লোকা অৱধত্ত, অস্মাকং প্রভুঃ পরমেশ্ৱর এক এৱ, ");
INSERT INTO sanben_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","যূযং সর্ৱ্ৱন্তঃকরণৈঃ সর্ৱ্ৱপ্রাণৈঃ সর্ৱ্ৱচিত্তৈঃ সর্ৱ্ৱশক্তিভিশ্চ তস্মিন্ প্রভৌ পরমেশ্ৱরে প্রীযধ্ৱং,\" ইত্যাজ্ঞা শ্রেষ্ঠা| ");
INSERT INTO sanben_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","তথা \"স্ৱপ্রতিৱাসিনি স্ৱৱৎ প্রেম কুরুধ্ৱং,\" এষা যা দ্ৱিতীযাজ্ঞা সা তাদৃশী; এতাভ্যাং দ্ৱাভ্যাম্ আজ্ঞাভ্যাম্ অন্যা কাপ্যাজ্ঞা শ্রেষ্ঠা নাস্তি| ");
INSERT INTO sanben_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","তদা সোধ্যাপকস্তমৱদৎ, হে গুরো সত্যং ভৱান্ যথার্থং প্রোক্তৱান্ যত একস্মাদ্ ঈশ্ৱরাদ্ অন্যো দ্ৱিতীয ঈশ্ৱরো নাস্তি; ");
INSERT INTO sanben_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","অপরং সর্ৱ্ৱান্তঃকরণৈঃ সর্ৱ্ৱপ্রাণৈঃ সর্ৱ্ৱচিত্তৈঃ সর্ৱ্ৱশক্তিভিশ্চ ঈশ্ৱরে প্রেমকরণং তথা স্ৱমীপৱাসিনি স্ৱৱৎ প্রেমকরণঞ্চ সর্ৱ্ৱেভ্যো হোমবলিদানাদিভ্যঃ শ্রষ্ঠং ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","ততো যীশুঃ সুবুদ্ধেরিৱ তস্যেদম্ উত্তরং শ্রুৎৱা তং ভাষিতৱান্ ৎৱমীশ্ৱরস্য রাজ্যান্ন দূরোসি| ইতঃ পরং তেন সহ কস্যাপি ৱাক্যস্য ৱিচারং কর্ত্তাং কস্যাপি প্রগল্ভতা ন জাতা| ");
INSERT INTO sanben_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","অনন্তরং মধ্যেমন্দিরম্ উপদিশন্ যীশুরিমং প্রশ্নং চকার, অধ্যাপকা অভিষিক্তং (তারকং) কুতো দাযূদঃ সন্তানং ৱদন্তি? ");
INSERT INTO sanben_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","স্ৱযং দাযূদ্ পৱিত্রস্যাত্মন আৱেশেনেদং কথযামাস| যথা| \"মম প্রভুমিদং ৱাক্যৱদৎ পরমেশ্ৱরঃ| তৱ শত্রূনহং যাৱৎ পাদপীঠং করোমি ন| তাৱৎ কালং মদীযে ৎৱং দক্ষপার্শ্ৱ্ উপাৱিশ| \" ");
INSERT INTO sanben_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","যদি দাযূদ্ তং প্রভূং ৱদতি তর্হি কথং স তস্য সন্তানো ভৱিতুমর্হতি? ইতরে লোকাস্তৎকথাং শ্রুৎৱাননন্দুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","তদানীং স তানুপদিশ্য কথিতৱান্ যে নরা দীর্ঘপরিধেযানি হট্টে ৱিপনৌ চ ");
INSERT INTO sanben_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","লোককৃতনমস্কারান্ ভজনগৃহে প্রধানাসনানি ভোজনকালে প্রধানস্থানানি চ কাঙ্ক্ষন্তে; ");
INSERT INTO sanben_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ৱিধৱানাং সর্ৱ্ৱস্ৱং গ্রসিৎৱা ছলাদ্ দীর্ঘকালং প্রার্থযন্তে তেভ্য উপাধ্যাযেভ্যঃ সাৱধানা ভৱত; তেঽধিকতরান্ দণ্ডান্ প্রাপ্স্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","তদনন্তরং লোকা ভাণ্ডাগারে মুদ্রা যথা নিক্ষিপন্তি ভাণ্ডাগারস্য সম্মুখে সমুপৱিশ্য যীশুস্তদৱলুলোক; তদানীং বহৱো ধনিনস্তস্য মধ্যে বহূনি ধনানি নিরক্ষিপন্| ");
INSERT INTO sanben_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","পশ্চাদ্ একা দরিদ্রা ৱিধৱা সমাগত্য দ্ৱিপণমূল্যাং মুদ্রৈকাং তত্র নিরক্ষিপৎ| ");
INSERT INTO sanben_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","তদা যীশুঃ শিষ্যান্ আহূয কথিতৱান্ যুষ্মানহং যথার্থং ৱদামি যে যে ভাণ্ডাগারেঽস্মিন ধনানি নিঃক্ষিপন্তি স্ম তেভ্যঃ সর্ৱ্ৱেভ্য ইযং ৱিধৱা দরিদ্রাধিকম্ নিঃক্ষিপতি স্ম| ");
INSERT INTO sanben_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","যতস্তে প্রভূতধনস্য কিঞ্চিৎ নিরক্ষিপন্ কিন্তু দীনেযং স্ৱদিনযাপনযোগ্যং কিঞ্চিদপি ন স্থাপযিৎৱা সর্ৱ্ৱস্ৱং নিরক্ষিপৎ| ");
INSERT INTO sanben_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","অনন্তরং মন্দিরাদ্ বহির্গমনকালে তস্য শিষ্যাণামেকস্তং ৱ্যাহৃতৱান্ হে গুরো পশ্যতু কীদৃশাঃ পাষাণাঃ কীদৃক্ চ নিচযনং| ");
INSERT INTO sanben_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","তদা যীশুস্তম্ অৱদৎ ৎৱং কিমেতদ্ বৃহন্নিচযনং পশ্যসি? অস্যৈকপাষাণোপি দ্ৱিতীযপাষাণোপরি ন স্থাস্যতি সর্ৱ্ৱে ঽধঃক্ষেপ্স্যন্তে| ");
INSERT INTO sanben_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","অথ যস্মিন্ কালে জৈতুন্গিরৌ মন্দিরস্য সম্মুখে স সমুপৱিষ্টস্তস্মিন্ কালে পিতরো যাকূব্ যোহন্ আন্দ্রিযশ্চৈতে তং রহসি পপ্রচ্ছুঃ, ");
INSERT INTO sanben_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","এতা ঘটনাঃ কদা ভৱিষ্যন্তি? তথৈতৎসর্ৱ্ৱাসাং সিদ্ধ্যুপক্রমস্য ৱা কিং চিহ্নং? তদস্মভ্যং কথযতু ভৱান্| ");
INSERT INTO sanben_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ততো যাশুস্তান্ ৱক্তুমারেভে, কোপি যথা যুষ্মান্ ন ভ্রামযতি তথাত্র যূযং সাৱধানা ভৱত| ");
INSERT INTO sanben_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","যতঃ খ্রীষ্টোহমিতি কথযিৎৱা মম নাম্নানেকে সমাগত্য লোকানাং ভ্রমং জনযিষ্যন্তি; ");
INSERT INTO sanben_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","কিন্তু যূযং রণস্য ৱার্ত্তাং রণাডম্বরঞ্চ শ্রুৎৱা মা ৱ্যাকুলা ভৱত, ঘটনা এতা অৱশ্যম্মাৱিন্যঃ; কিন্ত্ৱাপাততো ন যুগান্তো ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","দেশস্য ৱিপক্ষতযা দেশো রাজ্যস্য ৱিপক্ষতযা চ রাজ্যমুত্থাস্যতি, তথা স্থানে স্থানে ভূমিকম্পো দুর্ভিক্ষং মহাক্লেশাশ্চ সমুপস্থাস্যন্তি, সর্ৱ্ৱ এতে দুঃখস্যারম্ভাঃ| ");
INSERT INTO sanben_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","কিন্তু যূযম্ আত্মার্থে সাৱধানাস্তিষ্ঠত, যতো লোকা রাজসভাযাং যুষ্মান্ সমর্পযিষ্যন্তি, তথা ভজনগৃহে প্রহরিষ্যন্তি; যূযং মদর্থে দেশাধিপান্ ভূপাংশ্চ প্রতি সাক্ষ্যদানায তেষাং সম্মুখে উপস্থাপযিষ্যধ্ৱে| ");
INSERT INTO sanben_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","শেষীভৱনাৎ পূর্ৱ্ৱং সর্ৱ্ৱান্ দেশীযান্ প্রতি সুসংৱাদঃ প্রচারযিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","কিন্তু যদা তে যুষ্মান্ ধৃৎৱা সমর্পযিষ্যন্তি তদা যূযং যদ্যদ্ উত্তরং দাস্যথ, তদগ্র তস্য ৱিৱেচনং মা কুরুত তদর্থং কিঞ্চিদপি মা চিন্তযত চ, তদানীং যুষ্মাকং মনঃসু যদ্যদ্ ৱাক্যম্ উপস্থাপযিষ্যতে তদেৱ ৱদিষ্যথ, যতো যূযং ন তদ্ৱক্তারঃ কিন্তু পৱিত্র আত্মা তস্য ৱক্তা| ");
INSERT INTO sanben_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","তদা ভ্রাতা ভ্রাতরং পিতা পুত্রং ঘাতনার্থং পরহস্তেষু সমর্পযিষ্যতে, তথা পত্যানি মাতাপিত্রো র্ৱিপক্ষতযা তৌ ঘাতযিষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","মম নামহেতোঃ সর্ৱ্ৱেষাং সৱিধে যূযং জুগুপ্সিতা ভৱিষ্যথ, কিন্তু যঃ কশ্চিৎ শেষপর্য্যন্তং ধৈর্য্যম্ আলম্বিষ্যতে সএৱ পরিত্রাস্যতে| ");
INSERT INTO sanben_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","দানিযেল্ভৱিষ্যদ্ৱাদিনা প্রোক্তং সর্ৱ্ৱনাশি জুগুপ্সিতঞ্চ ৱস্তু যদা ৎৱযোগ্যস্থানে ৱিদ্যমানং দ্রক্ষথ (যো জনঃ পঠতি স বুধ্যতাং) তদা যে যিহূদীযদেশে তিষ্ঠন্তি তে মহীধ্রং প্রতি পলাযন্তাং; ");
INSERT INTO sanben_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","তথা যো নরো গৃহোপরি তিষ্ঠতি স গৃহমধ্যং নাৱরোহতু, তথা কিমপি ৱস্তু গ্রহীতুং মধ্যেগৃহং ন প্রৱিশতু; ");
INSERT INTO sanben_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","তথা চ যো নরঃ ক্ষেত্রে তিষ্ঠতি সোপি স্ৱৱস্ত্রং গ্রহীতুং পরাৱৃত্য ন ৱ্রজতু| ");
INSERT INTO sanben_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","তদানীং গর্ব্ভৱতীনাং স্তন্যদাত্রীণাঞ্চ যোষিতাং দুর্গতি র্ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","যুষ্মাকং পলাযনং শীতকালে যথা ন ভৱতি তদর্থং প্রার্থযধ্ৱং| ");
INSERT INTO sanben_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","যতস্তদা যাদৃশী দুর্ঘটনা ঘটিষ্যতে তাদৃশী দুর্ঘটনা ঈশ্ৱরসৃষ্টেঃ প্রথমমারভ্যাদ্য যাৱৎ কদাপি ন জাতা ন জনিষ্যতে চ| ");
INSERT INTO sanben_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","অপরঞ্চ পরমেশ্ৱরো যদি তস্য সমযস্য সংক্ষেপং ন করোতি তর্হি কস্যাপি প্রাণভৃতো রক্ষা ভৱিতুং ন শক্ষ্যতি, কিন্তু যান্ জনান্ মনোনীতান্ অকরোৎ তেষাং স্ৱমনোনীতানাং হেতোঃ স তদনেহসং সংক্ষেপ্স্যতি| ");
INSERT INTO sanben_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","অন্যচ্চ পশ্যত খ্রীষ্টোত্র স্থানে ৱা তত্র স্থানে ৱিদ্যতে, তস্মিন্কালে যদি কশ্চিদ্ যুষ্মান্ এতাদৃশং ৱাক্যং ৱ্যাহরতি, তর্হি তস্মিন্ ৱাক্যে ভৈৱ ৱিশ্ৱসিত| ");
INSERT INTO sanben_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","যতোনেকে মিথ্যাখ্রীষ্টা মিথ্যাভৱিষ্যদ্ৱাদিনশ্চ সমুপস্থায বহূনি চিহ্নান্যদ্ভুতানি কর্ম্মাণি চ দর্শযিষ্যন্তি; তথা যদি সম্ভৱতি তর্হি মনোনীতলোকানামপি মিথ্যামতিং জনযিষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","পশ্যত ঘটনাতঃ পূর্ৱ্ৱং সর্ৱ্ৱকার্য্যস্য ৱার্ত্তাং যুষ্মভ্যমদাম্, যূযং সাৱধানাস্তিষ্ঠত| ");
INSERT INTO sanben_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","অপরঞ্চ তস্য ক্লেশকালস্যাৱ্যৱহিতে পরকালে ভাস্করঃ সান্ধকারো ভৱিষ্যতি তথৈৱ চন্দ্রশ্চন্দ্রিকাং ন দাস্যতি| ");
INSERT INTO sanben_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","নভঃস্থানি নক্ষত্রাণি পতিষ্যন্তি, ৱ্যোমমণ্ডলস্থা গ্রহাশ্চ ৱিচলিষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","তদানীং মহাপরাক্রমেণ মহৈশ্ৱর্য্যেণ চ মেঘমারুহ্য সমাযান্তং মানৱসুতং মানৱাঃ সমীক্ষিষ্যন্তে| ");
INSERT INTO sanben_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","অন্যচ্চ স নিজদূতান্ প্রহিত্য নভোভূম্যোঃ সীমাং যাৱদ্ জগতশ্চতুর্দিগ্ভ্যঃ স্ৱমনোনীতলোকান্ সংগ্রহীষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","উডুম্বরতরো র্দৃষ্টান্তং শিক্ষধ্ৱং যদোডুম্বরস্য তরো র্নৱীনাঃ শাখা জাযন্তে পল্লৱাদীনি চ র্নিগচ্ছন্তি, তদা নিদাঘকালঃ সৱিধো ভৱতীতি যূযং জ্ঞাতুং শক্নুথ| ");
INSERT INTO sanben_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","তদ্ৱদ্ এতা ঘটনা দৃষ্ট্ৱা স কালো দ্ৱার্য্যুপস্থিত ইতি জানীত| ");
INSERT INTO sanben_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","যুষ্মানহং যথার্থং ৱদামি, আধুনিকলোকানাং গমনাৎ পূর্ৱ্ৱং তানি সর্ৱ্ৱাণি ঘটিষ্যন্তে| ");
INSERT INTO sanben_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","দ্যাৱাপৃথিৱ্যো র্ৱিচলিতযোঃ সত্যো র্মদীযা ৱাণী ন ৱিচলিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","অপরঞ্চ স্ৱর্গস্থদূতগণো ৱা পুত্রো ৱা তাতাদন্যঃ কোপি তং দিৱসং তং দণ্ডং ৱা ন জ্ঞাপযতি| ");
INSERT INTO sanben_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","অতঃ স সমযঃ কদা ভৱিষ্যতি, এতজ্জ্ঞানাভাৱাদ্ যূযং সাৱধানাস্তিষ্ঠত, সতর্কাশ্চ ভূৎৱা প্রার্থযধ্ৱং; ");
INSERT INTO sanben_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","যদ্ৱৎ কশ্চিৎ পুমান্ স্ৱনিৱেশনাদ্ দূরদেশং প্রতি যাত্রাকরণকালে দাসেষু স্ৱকার্য্যস্য ভারমর্পযিৎৱা সর্ৱ্ৱান্ স্ৱে স্ৱে কর্ম্মণি নিযোজযতি; অপরং দৌৱারিকং জাগরিতুং সমাদিশ্য যাতি, তদ্ৱন্ নরপুত্রঃ| ");
INSERT INTO sanben_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","গৃহপতিঃ সাযংকালে নিশীথে ৱা তৃতীযযামে ৱা প্রাতঃকালে ৱা কদাগমিষ্যতি তদ্ যূযং ন জানীথ; ");
INSERT INTO sanben_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","স হঠাদাগত্য যথা যুষ্মান্ নিদ্রিতান্ ন পশ্যতি, তদর্থং জাগরিতাস্তিষ্ঠত| ");
INSERT INTO sanben_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","যুষ্মানহং যদ্ ৱদামি তদেৱ সর্ৱ্ৱান্ ৱদামি, জাগরিতাস্তিষ্ঠতেতি| ");
INSERT INTO sanben_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","তদা নিস্তারোৎসৱকিণ্ৱহীনপূপোৎসৱযোরারম্ভস্য দিনদ্ৱযে ঽৱশিষ্টে প্রধানযাজকা অধ্যাপকাশ্চ কেনাপি ছলেন যীশুং ধর্ত্তাং হন্তুঞ্চ মৃগযাঞ্চক্রিরে; ");
INSERT INTO sanben_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","কিন্তু লোকানাং কলহভযাদূচিরে, নচোৎসৱকাল উচিতমেতদিতি| ");
INSERT INTO sanben_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","অনন্তরং বৈথনিযাপুुরে শিমোনকুষ্ঠিনো গৃহে যোশৌ ভোৎকুমুপৱিষ্টে সতি কাচিদ্ যোষিৎ পাণ্ডরপাষাণস্য সম্পুটকেন মহার্ঘ্যোত্তমতৈলম্ আনীয সম্পুটকং ভংক্ত্ৱা তস্যোত্তমাঙ্গে তৈলধারাং পাতযাঞ্চক্রে| ");
INSERT INTO sanben_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","তস্মাৎ কেচিৎ স্ৱান্তে কুপ্যন্তঃ কথিতৱংন্তঃ কুতোযং তৈলাপৱ্যযঃ? ");
INSERT INTO sanben_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","যদ্যেতৎ তৈল ৱ্যক্রেষ্যত তর্হি মুদ্রাপাদশতত্রযাদপ্যধিকং তস্য প্রাপ্তমূল্যং দরিদ্রলোকেভ্যো দাতুমশক্ষ্যত, কথামেতাং কথযিৎৱা তযা যোষিতা সাকং ৱাচাযুহ্যন্| ");
INSERT INTO sanben_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","কিন্তু যীশুরুৱাচ, কুত এতস্যৈ কৃচ্ছ্রং দদাসি? মহ্যমিযং কর্ম্মোত্তমং কৃতৱতী| ");
INSERT INTO sanben_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","দরিদ্রাঃ সর্ৱ্ৱদা যুষ্মাভিঃ সহ তিষ্ঠন্তি, তস্মাদ্ যূযং যদেচ্ছথ তদৈৱ তানুপকর্ত্তাং শক্নুথ, কিন্ত্ৱহং যুভাভিঃ সহ নিরন্তরং ন তিষ্ঠামি| ");
INSERT INTO sanben_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","অস্যা যথাসাধ্যং তথৈৱাকরোদিযং, শ্মশানযাপনাৎ পূর্ৱ্ৱং সমেত্য মদ্ৱপুষি তৈলম্ অমর্দ্দযৎ| ");
INSERT INTO sanben_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","অহং যুষ্মভ্যং যথার্থং কথযামি, জগতাং মধ্যে যত্র যত্র সুসংৱাদোযং প্রচারযিষ্যতে তত্র তত্র যোষিত এতস্যাঃ স্মরণার্থং তৎকৃতকর্ম্মৈতৎ প্রচারযিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ততঃ পরং দ্ৱাদশানাং শিষ্যাণামেক ঈষ্করিযোতীযযিহূদাখ্যো যীশুং পরকরেষু সমর্পযিতুং প্রধানযাজকানাং সমীপমিযায| ");
INSERT INTO sanben_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","তে তস্য ৱাক্যং সমাকর্ণ্য সন্তুষ্টাঃ সন্তস্তস্মৈ মুদ্রা দাতুং প্রত্যজানত; তস্মাৎ স তং তেষাং করেষু সমর্পণাযোপাযং মৃগযামাস| ");
INSERT INTO sanben_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","অনন্তরং কিণ্ৱশূন্যপূপোৎসৱস্য প্রথমেঽহনি নিস্তারোত্মৱার্থং মেষমারণাসমযে শিষ্যাস্তং পপ্রচ্ছঃ কুত্র গৎৱা ৱযং নিস্তারোৎসৱস্য ভোজ্যমাসাদযিষ্যামঃ? কিমিচ্ছতি ভৱান্? ");
INSERT INTO sanben_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","তদানীং স তেষাং দ্ৱযং প্রেরযন্ বভাষে যুৱযোঃ পুরমধ্যং গতযোঃ সতো র্যো জনঃ সজলকুম্ভং ৱহন্ যুৱাং সাক্ষাৎ করিষ্যতি তস্যৈৱ পশ্চাদ্ যাতং; ");
INSERT INTO sanben_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","স যৎ সদনং প্রৱেক্ষ্যতি তদ্ভৱনপতিং ৱদতং, গুরুরাহ যত্র সশিষ্যোহং নিস্তারোৎসৱীযং ভোজনং করিষ্যামি, সা ভোজনশালা কুত্রাস্তি? ");
INSERT INTO sanben_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ততঃ স পরিষ্কৃতাং সুসজ্জিতাং বৃহতীচঞ্চ যাং শালাং দর্শযিষ্যতি তস্যামস্মদর্থং ভোজ্যদ্রৱ্যাণ্যাসাদযতং| ");
INSERT INTO sanben_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ততঃ শিষ্যৌ প্রস্থায পুরং প্রৱিশ্য স যথোক্তৱান্ তথৈৱ প্রাপ্য নিস্তারোৎসৱস্য ভোজ্যদ্রৱ্যাণি সমাসাদযেতাম্| ");
INSERT INTO sanben_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","অনন্তরং যীশুঃ সাযংকালে দ্ৱাদশভিঃ শিষ্যৈঃ সার্দ্ধং জগাম; ");
INSERT INTO sanben_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","সর্ৱ্ৱেষু ভোজনায প্রোপৱিষ্টেষু স তানুদিতৱান্ যুষ্মানহং যথার্থং ৱ্যাহরামি, অত্র যুষ্মাকমেকো জনো যো মযা সহ ভুংক্তে মাং পরকেরেষু সমর্পযিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","তদানীং তে দুঃখিতাঃ সন্ত একৈকশস্তং প্রষ্টুমারব্ধৱন্তঃ স কিমহং? পশ্চাদ্ অন্য একোভিদধে স কিমহং? ");
INSERT INTO sanben_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ততঃ স প্রত্যৱদদ্ এতেষাং দ্ৱাদশানাং যো জনো মযা সমং ভোজনাপাত্রে পাণিং মজ্জযিষ্যতি স এৱ| ");
INSERT INTO sanben_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","মনুজতনযমধি যাদৃশং লিখিতমাস্তে তদনুরূপা গতিস্তস্য ভৱিষ্যতি, কিন্তু যো জনো মানৱসুতং সমর্পযিষ্যতে হন্ত তস্য জন্মাভাৱে সতি ভদ্রমভৱিষ্যৎ| ");
INSERT INTO sanben_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","অপরঞ্চ তেষাং ভোজনসমযে যীশুঃ পূপং গৃহীৎৱেশ্ৱরগুণান্ অনুকীর্ত্য ভঙ্ক্ত্ৱা তেভ্যো দত্ত্ৱা বভাষে, এতদ্ গৃহীৎৱা ভুঞ্জীধ্ৱম্ এতন্মম ৱিগ্রহরূপং| ");
INSERT INTO sanben_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","অনন্তরং স কংসং গৃহীৎৱেশ্ৱরস্য গুণান্ কীর্ত্তযিৎৱা তেভ্যো দদৌ, ততস্তে সর্ৱ্ৱে পপুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","অপরং স তানৱাদীদ্ বহূনাং নিমিত্তং পাতিতং মম নৱীননিযমরূপং শোণিতমেতৎ| ");
INSERT INTO sanben_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","যুষ্মানহং যথার্থং ৱদামি, ঈশ্ৱরস্য রাজ্যে যাৱৎ সদ্যোজাতং দ্রাক্ষারসং ন পাস্যামি,তাৱদহং দ্রাক্ষাফলরসং পুন র্ন পাস্যামি| ");
INSERT INTO sanben_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","তদনন্তরং তে গীতমেকং সংগীয বহি র্জৈতুনং শিখরিণং যযুঃ ");
INSERT INTO sanben_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","অথ যীশুস্তানুৱাচ নিশাযামস্যাং মযি যুষ্মাকং সর্ৱ্ৱেষাং প্রত্যূহো ভৱিষ্যতি যতো লিখিতমাস্তে যথা, মেষাণাং রক্ষকঞ্চাহং প্রহরিষ্যামি ৱৈ ততঃ| মেষাণাং নিৱহো নূনং প্রৱিকীর্ণো ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","কন্তু মদুত্থানে জাতে যুষ্মাকমগ্রেঽহং গালীলং ৱ্রজিষ্যামি| ");
INSERT INTO sanben_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","তদা পিতরঃ প্রতিবভাষে, যদ্যপি সর্ৱ্ৱেষাং প্রত্যূহো ভৱতি তথাপি মম নৈৱ ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ততো যীশুরুক্তাৱান্ অহং তুভ্যং তথ্যং কথযামি, ক্ষণাদাযামদ্য কুক্কুটস্য দ্ৱিতীযৱাররৱণাৎ পূর্ৱ্ৱং ৎৱং ৱারত্রযং মামপহ্নোষ্যসে| ");
INSERT INTO sanben_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","কিন্তু স গাঢং ৱ্যাহরদ্ যদ্যপি ৎৱযা সার্দ্ধং মম প্রাণো যাতি তথাপি কথমপি ৎৱাং নাপহ্নোষ্যে; সর্ৱ্ৱেঽপীতরে তথৈৱ বভাষিরে| ");
INSERT INTO sanben_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","অপরঞ্চ তেষু গেৎশিমানীনামকং স্থান গতেষু স শিষ্যান্ জগাদ, যাৱদহং প্রার্থযে তাৱদত্র স্থানে যূযং সমুপৱিশত| ");
INSERT INTO sanben_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","অথ স পিতরং যাকূবং যোহনঞ্চ গৃহীৎৱা ৱৱ্রাজ; অত্যন্তং ত্রাসিতো ৱ্যাকুলিতশ্চ তেভ্যঃ কথযামাস, ");
INSERT INTO sanben_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","নিধনকালৱৎ প্রাণো মেঽতীৱ দঃখমেতি, যূযং জাগ্রতোত্র স্থানে তিষ্ঠত| ");
INSERT INTO sanben_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ততঃ স কিঞ্চিদ্দূরং গৎৱা ভূমাৱধোমুখঃ পতিৎৱা প্রার্থিতৱানেতৎ, যদি ভৱিতুং শক্যং তর্হি দুঃখসমযোযং মত্তো দূরীভৱতু| ");
INSERT INTO sanben_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","অপরমুদিতৱান্ হে পিত র্হে পিতঃ সর্ৱ্ৱেং ৎৱযা সাধ্যং, ততো হেতোরিমং কংসং মত্তো দূরীকুরু, কিন্তু তন্ মমেচ্ছাতো ন তৱেচ্ছাতো ভৱতু| ");
INSERT INTO sanben_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","ততঃ পরং স এত্য তান্ নিদ্রিতান্ নিরীক্ষ্য পিতরং প্রোৱাচ, শিমোন্ ৎৱং কিং নিদ্রাসি? ঘটিকামেকাম্ অপি জাগরিতুং ন শক্নোষি? ");
INSERT INTO sanben_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","পরীক্ষাযাং যথা ন পতথ তদর্থং সচেতনাঃ সন্তঃ প্রার্থযধ্ৱং; মন উদ্যুক্তমিতি সত্যং কিন্তু ৱপুরশক্তিকং| ");
INSERT INTO sanben_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","অথ স পুনর্ৱ্রজিৎৱা পূর্ৱ্ৱৱৎ প্রার্থযাঞ্চক্রে| ");
INSERT INTO sanben_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","পরাৱৃত্যাগত্য পুনরপি তান্ নিদ্রিতান্ দদর্শ তদা তেষাং লোচনানি নিদ্রযা পূর্ণানি, তস্মাত্তস্মৈ কা কথা কথযিতৱ্যা ত এতদ্ বোদ্ধুং ন শেকুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ততঃপরং তৃতীযৱারং আগত্য তেভ্যো ঽকথযদ্ ইদানীমপি শযিৎৱা ৱিশ্রাম্যথ? যথেষ্টং জাতং, সমযশ্চোপস্থিতঃ পশ্যত মানৱতনযঃ পাপিলোকানাং পাণিষু সমর্প্যতে| ");
INSERT INTO sanben_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","উত্তিষ্ঠত, ৱযং ৱ্রজামো যো জনো মাং পরপাণিষু সমর্পযিষ্যতে পশ্যত স সমীপমাযাতঃ| ");
INSERT INTO sanben_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ইমাং কথাং কথযতি স, এতর্হিদ্ৱাদশানামেকো যিহূদা নামা শিষ্যঃ প্রধানযাজকানাম্ উপাধ্যাযানাং প্রাচীনলোকানাঞ্চ সন্নিধেঃ খঙ্গলগুডধারিণো বহুলোকান্ গৃহীৎৱা তস্য সমীপ উপস্থিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","অপরঞ্চাসৌ পরপাণিষু সমর্পযিতা পূর্ৱ্ৱমিতি সঙ্কেতং কৃতৱান্ যমহং চুম্বিষ্যামি স এৱাসৌ তমেৱ ধৃৎৱা সাৱধানং নযত| ");
INSERT INTO sanben_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","অতো হেতোঃ স আগত্যৈৱ যোশোঃ সৱিধং গৎৱা হে গুরো হে গুরো, ইত্যুক্ত্ৱা তং চুচুম্ব| ");
INSERT INTO sanben_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","তদা তে তদুপরি পাণীনর্পযিৎৱা তং দধ্নুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ততস্তস্য পার্শ্ৱস্থানাং লোকানামেকঃ খঙ্গং নিষ্কোষযন্ মহাযাজকস্য দাসমেকং প্রহৃত্য তস্য কর্ণং চিচ্ছেদ| ");
INSERT INTO sanben_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","পশ্চাদ্ যীশুস্তান্ ৱ্যাজহার খঙ্গান্ লগুডাংশ্চ গৃহীৎৱা মাং কিং চৌরং ধর্ত্তাং সমাযাতাঃ? ");
INSERT INTO sanben_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","মধ্যেমন্দিরং সমুপদিশন্ প্রত্যহং যুষ্মাভিঃ সহ স্থিতৱানতহং, তস্মিন্ কালে যূযং মাং নাদীধরত, কিন্ত্ৱনেন শাস্ত্রীযং ৱচনং সেধনীযং| ");
INSERT INTO sanben_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","তদা সর্ৱ্ৱে শিষ্যাস্তং পরিত্যজ্য পলাযাঞ্চক্রিরে| ");
INSERT INTO sanben_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","অথৈকো যুৱা মানৱো নগ্নকাযে ৱস্ত্রমেকং নিধায তস্য পশ্চাদ্ ৱ্রজন্ যুৱলোকৈ র্ধৃতো ");
INSERT INTO sanben_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ৱস্ত্রং ৱিহায নগ্নঃ পলাযাঞ্চক্রে| ");
INSERT INTO sanben_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","অপরঞ্চ যস্মিন্ স্থানে প্রধানযাজকা উপাধ্যাযাঃ প্রাচীনলোকাশ্চ মহাযাজকেন সহ সদসি স্থিতাস্তস্মিন্ স্থানে মহাযাজকস্য সমীপং যীশুং নিন্যুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","পিতরো দূরে তৎপশ্চাদ্ ইৎৱা মহাযাজকস্যাট্টালিকাং প্রৱিশ্য কিঙ্করৈঃ সহোপৱিশ্য ৱহ্নিতাপং জগ্রাহ| ");
INSERT INTO sanben_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","তদানীং প্রধানযাজকা মন্ত্রিণশ্চ যীশুং ঘাতযিতুং তৎপ্রাতিকূল্যেন সাক্ষিণো মৃগযাঞ্চক্রিরে, কিন্তু ন প্রাপ্তাঃ| ");
INSERT INTO sanben_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","অনেকৈস্তদ্ৱিরুদ্ধং মৃষাসাক্ষ্যে দত্তেপি তেষাং ৱাক্যানি ন সমগচ্ছন্ত| ");
INSERT INTO sanben_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","সর্ৱ্ৱশেষে কিযন্ত উত্থায তস্য প্রাতিকূল্যেন মৃষাসাক্ষ্যং দত্ত্ৱা কথযামাসুঃ, ");
INSERT INTO sanben_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","ইদং করকৃতমন্দিরং ৱিনাশ্য দিনত্রযমধ্যে পুনরপরম্ অকরকৃতং মন্দিরং নির্ম্মাস্যামি, ইতি ৱাক্যম্ অস্য মুখাৎ শ্রুতমস্মাভিরিতি| ");
INSERT INTO sanben_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","কিন্তু তত্রাপি তেষাং সাক্ষ্যকথা ন সঙ্গাতাঃ| ");
INSERT INTO sanben_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","অথ মহাযাজকো মধ্যেসভম্ উত্থায যীশুং ৱ্যাজহার, এতে জনাস্ত্ৱযি যৎ সাক্ষ্যমদুঃ ৎৱমেতস্য কিমপ্যুত্তরং কিং ন দাস্যসি? ");
INSERT INTO sanben_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","কিন্তু স কিমপ্যুত্তরং ন দৎৱা মৌনীভূয তস্যৌ; ততো মহাযাজকঃ পুনরপি তং পৃষ্টাৱান্ ৎৱং সচ্চিদানন্দস্য তনযো ঽভিষিক্তস্ত্রতা? ");
INSERT INTO sanben_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","তদা যীশুস্তং প্রোৱাচ ভৱাম্যহম্ যূযঞ্চ সর্ৱ্ৱশক্তিমতো দক্ষীণপার্শ্ৱে সমুপৱিশন্তং মেঘ মারুহ্য সমাযান্তঞ্চ মনুষ্যপুত্রং সন্দ্রক্ষ্যথ| ");
INSERT INTO sanben_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","তদা মহাযাজকঃ স্ৱং ৱমনং ছিৎৱা ৱ্যাৱহরৎ ");
INSERT INTO sanben_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","কিমস্মাকং সাক্ষিভিঃ প্রযোজনম্? ঈশ্ৱরনিন্দাৱাক্যং যুষ্মাভিরশ্রাৱি কিং ৱিচারযথ? তদানীং সর্ৱ্ৱে জগদুরযং নিধনদণ্ডমর্হতি| ");
INSERT INTO sanben_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","ততঃ কশ্চিৎ কশ্চিৎ তদ্ৱপুষি নিষ্ঠীৱং নিচিক্ষেপ তথা তন্মুখমাচ্ছাদ্য চপেটেন হৎৱা গদিতৱান্ গণযিৎৱা ৱদ, অনুচরাশ্চ চপেটৈস্তমাজঘ্নুঃ ");
INSERT INTO sanben_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ততঃ পরং পিতরেঽট্টালিকাধঃকোষ্ঠে তিষ্ঠতি মহাযাজকস্যৈকা দাসী সমেত্য ");
INSERT INTO sanben_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","তং ৱিহ্নিতাপং গৃহ্লন্তং ৱিলোক্য তং সুনিরীক্ষ্য বভাষে ৎৱমপি নাসরতীযযীশোঃ সঙ্গিনাম্ একো জন আসীঃ| ");
INSERT INTO sanben_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","কিন্তু সোপহ্নুত্য জগাদ তমহং ন ৱদ্মি ৎৱং যৎ কথযমি তদপ্যহং ন বুদ্ধ্যে| তদানীং পিতরে চৎৱরং গতৱতি কুेক্কুটো রুরাৱ| ");
INSERT INTO sanben_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","অথান্যা দাসী পিতরং দৃষ্ট্ৱা সমীপস্থান্ জনান্ জগাদ অযং তেষামেকো জনঃ| ");
INSERT INTO sanben_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","ততঃ স দ্ৱিতীযৱারম্ অপহ্নুতৱান্ পশ্চাৎ তত্রস্থা লোকাঃ পিতরং প্রোচুস্ত্ৱমৱশ্যং তেষামেকো জনঃ যতস্ত্ৱং গালীলীযো নর ইতি তৱোচ্চারণং প্রকাশযতি| ");
INSERT INTO sanben_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","তদা স শপথাভিশাপৌ কৃৎৱা প্রোৱাচ যূযং কথাং কথযথ তং নরং ন জানেঽহং| ");
INSERT INTO sanben_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","তদানীং দ্ৱিতীযৱারং কুক্কুটো ঽরাৱীৎ| কুক্কুটস্য দ্ৱিতীযরৱাৎ পূর্ৱ্ৱং ৎৱং মাং ৱারত্রযম্ অপহ্নোষ্যসি, ইতি যদ্ৱাক্যং যীশুনা সমুদিতং তৎ তদা সংস্মৃত্য পিতরো রোদিতুম্ আরভত| ");
INSERT INTO sanben_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","অথ প্রভাতে সতি প্রধানযাজকাঃ প্রাঞ্চ উপাধ্যাযাঃ সর্ৱ্ৱে মন্ত্রিণশ্চ সভাং কৃৎৱা যীশুृং বন্ধযিৎৱ পীলাতাখ্যস্য দেশাধিপতেঃ সৱিধং নীৎৱা সমর্পযামাসুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","তদা পীলাতস্তং পৃষ্টৱান্ ৎৱং কিং যিহূদীযলোকানাং রাজা? ততঃ স প্রত্যুক্তৱান্ সত্যং ৱদসি| ");
INSERT INTO sanben_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","অপরং প্রধানযাজকাস্তস্য বহুষু ৱাক্যেষু দোষমারোপযাঞ্চক্রুঃ কিন্তু স কিমপি ন প্রত্যুৱাচ| ");
INSERT INTO sanben_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","তদানীং পীলাতস্তং পুনঃ পপ্রচ্ছ ৎৱং কিং নোত্তরযসি? পশ্যৈতে ৎৱদ্ৱিরুদ্ধং কতিষু সাধ্যেষু সাক্ষং দদতি| ");
INSERT INTO sanben_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","কন্তু যীশুস্তদাপি নোত্তরং দদৌ ততঃ পীলাত আশ্চর্য্যং জগাম| ");
INSERT INTO sanben_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","অপরঞ্চ কারাবদ্ধে কস্তিংশ্চিৎ জনে তন্মহোৎসৱকালে লোকৈ র্যাচিতে দেশাধিপতিস্তং মোচযতি| ");
INSERT INTO sanben_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","যে চ পূর্ৱ্ৱমুপপ্লৱমকার্ষুরুপপ্লৱে ৱধমপি কৃতৱন্তস্তেষাং মধ্যে তদানোং বরব্বানামক একো বদ্ধ আসীৎ| ");
INSERT INTO sanben_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","অতো হেতোঃ পূর্ৱ্ৱাপরীযাং রীতিকথাং কথযিৎৱা লোকা উচ্চৈরুৱন্তঃ পীলাতস্য সমক্ষং নিৱেদযামাসুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","তদা পীলাতস্তানাচখ্যৌ তর্হি কিং যিহূদীযানাং রাজানং মোচযিষ্যামি? যুষ্মাভিঃ কিমিষ্যতে? ");
INSERT INTO sanben_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","যতঃ প্রধানযাজকা ঈর্ষ্যাত এৱ যীশুং সমার্পযন্নিতি স ৱিৱেদ| ");
INSERT INTO sanben_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","কিন্তু যথা বরব্বাং মোচযতি তথা প্রার্থযিতুং প্রধানযাজকা লোকান্ প্রৱর্ত্তযামাসুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","অথ পীলাতঃ পুনঃ পৃষ্টৱান্ তর্হি যং যিহূদীযানাং রাজেতি ৱদথ তস্য কিং করিষ্যামি যুষ্মাভিঃ কিমিষ্যতে? ");
INSERT INTO sanben_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","তদা তে পুনরপি প্রোচ্চৈঃ প্রোচুস্তং ক্রুশে ৱেধয| ");
INSERT INTO sanben_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","তস্মাৎ পীলাতঃ কথিতৱান্ কুতঃ? স কিং কুকর্ম্ম কৃতৱান্? কিন্তু তে পুনশ্চ রুৱন্তো ৱ্যাজহ্রুস্তং ক্রুশে ৱেধয| ");
INSERT INTO sanben_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","তদা পীলাতঃ সর্ৱ্ৱাল্লোকান্ তোষযিতুমিচ্ছন্ বরব্বাং মোচযিৎৱা যীশুং কশাভিঃ প্রহৃত্য ক্রুশে ৱেদ্ধুং তং সমর্পযাম্বভূৱ| ");
INSERT INTO sanben_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","অনন্তরং সৈন্যগণোঽট্টালিকাম্ অর্থাদ্ অধিপতে র্গৃহং যীশুং নীৎৱা সেনানিৱহং সমাহুযৎ| ");
INSERT INTO sanben_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","পশ্চাৎ তে তং ধূমলৱর্ণৱস্ত্রং পরিধাপ্য কণ্টকমুকুটং রচযিৎৱা শিরসি সমারোপ্য ");
INSERT INTO sanben_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","হে যিহূদীযানাং রাজন্ নমস্কার ইত্যুক্ত্ৱা তং নমস্কর্ত্তামারেভিরে| ");
INSERT INTO sanben_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","তস্যোত্তমাঙ্গে ৱেত্রাঘাতং চক্রুস্তদ্গাত্রে নিষ্ঠীৱঞ্চ নিচিক্ষিপুঃ, তথা তস্য সম্মুখে জানুপাতং প্রণোমুঃ ");
INSERT INTO sanben_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ইত্থমুপহস্য ধূম্রৱর্ণৱস্ত্রম্ উত্তার্য্য তস্য ৱস্ত্রং তং পর্য্যধাপযন্ ক্রুশে ৱেদ্ধুং বহির্নিন্যুশ্চ| ");
INSERT INTO sanben_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","ততঃ পরং সেকন্দরস্য রুফস্য চ পিতা শিমোন্নামা কুরীণীযলোক একঃ কুতশ্চিদ্ গ্রামাদেত্য পথি যাতি তং তে যীশোঃ ক্রুশং ৱোঢুং বলাদ্ দধ্নুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","অথ গুল্গল্তা অর্থাৎ শিরঃকপালনামকং স্থানং যীশুমানীয ");
INSERT INTO sanben_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","তে গন্ধরসমিশ্রিতং দ্রাক্ষারসং পাতুং তস্মৈ দদুঃ কিন্তু স ন জগ্রাহ| ");
INSERT INTO sanben_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","তস্মিন্ ক্রুশে ৱিদ্ধে সতি তেষামেকৈকশঃ কিং প্রাপ্স্যতীতি নির্ণযায ");
INSERT INTO sanben_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","তস্য পরিধেযানাং ৱিভাগার্থং গুটিকাপাতং চক্রুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","অপরম্ এষ যিহূদীযানাং রাজেতি লিখিতং দোষপত্রং তস্য শিরঊর্দ্ৱ্ৱম্ আরোপযাঞ্চক্রুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","তস্য ৱামদক্ষিণযো র্দ্ৱৌ চৌরৌ ক্রুশযো র্ৱিৱিধাতে| ");
INSERT INTO sanben_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","তেনৈৱ \"অপরাধিজনৈঃ সার্দ্ধং স গণিতো ভৱিষ্যতি,\" ইতি শাস্ত্রোক্তং ৱচনং সিদ্ধমভূত| ");
INSERT INTO sanben_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","অনন্তরং মার্গে যে যে লোকা গমনাগমনে চক্রুস্তে সর্ৱ্ৱ এৱ শিরাংস্যান্দোল্য নিন্দন্তো জগদুঃ, রে মন্দিরনাশক রে দিনত্রযমধ্যে তন্নির্ম্মাযক, ");
INSERT INTO sanben_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","অধুনাত্মানম্ অৱিৎৱা ক্রুশাদৱরোহ| ");
INSERT INTO sanben_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","কিঞ্চ প্রধানযাজকা অধ্যাপকাশ্চ তদ্ৱৎ তিরস্কৃত্য পরস্পরং চচক্ষিরে এষ পরানাৱৎ কিন্তু স্ৱমৱিতুং ন শক্নোতি| ");
INSERT INTO sanben_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","যদীস্রাযেলো রাজাভিষিক্তস্ত্রাতা ভৱতি তর্হ্যধুনৈন ক্রুশাদৱরোহতু ৱযং তদ্ দৃষ্ট্ৱা ৱিশ্ৱসিষ্যামঃ; কিঞ্চ যৌ লোকৌ তেন সার্দ্ধং ক্রুশে ঽৱিধ্যেতাং তাৱপি তং নির্ভর্ত্সযামাসতুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","অথ দ্ৱিতীযযামাৎ তৃতীযযামং যাৱৎ সর্ৱ্ৱো দেশঃ সান্ধকারোভূৎ| ");
INSERT INTO sanben_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ততস্তৃতীযপ্রহরে যীশুরুচ্চৈরৱদৎ এলী এলী লামা শিৱক্তনী অর্থাদ্ \"হে মদীশ মদীশ ৎৱং পর্য্যত্যাক্ষীঃ কুতো হি মাং?\" ");
INSERT INTO sanben_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","তদা সমীপস্থলোকানাং কেচিৎ তদ্ৱাক্যং নিশম্যাচখ্যুঃ পশ্যৈষ এলিযম্ আহূযতি| ");
INSERT INTO sanben_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","তত একো জনো ধাৱিৎৱাগত্য স্পঞ্জে ঽম্লরসং পূরযিৎৱা তং নডাগ্রে নিধায পাতুং তস্মৈ দত্ত্ৱাৱদৎ তিষ্ঠ এলিয এনমৱরোহযিতুম্ এতি ন ৱেতি পশ্যামি| ");
INSERT INTO sanben_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","অথ যীশুরুচ্চৈঃ সমাহূয প্রাণান্ জহৌ| ");
INSERT INTO sanben_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","তদা মন্দিরস্য জৱনিকোর্দ্ৱ্ৱাদধঃর্য্যন্তা ৱিদীর্ণা দ্ৱিখণ্ডাভূৎ| ");
INSERT INTO sanben_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","কিঞ্চ ইত্থমুচ্চৈরাহূয প্রাণান্ ত্যজন্তং তং দৃষ্দ্ৱা তদ্রক্ষণায নিযুক্তো যঃ সেনাপতিরাসীৎ সোৱদৎ নরোযম্ ঈশ্ৱরপুত্র ইতি সত্যম্| ");
INSERT INTO sanben_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","তদানীং মগ্দলীনী মরিসম্ কনিষ্ঠযাকূবো যোসেশ্চ মাতান্যমরিযম্ শালোমী চ যাঃ স্ত্রিযো ");
INSERT INTO sanben_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","গালীল্প্রদেশে যীশুং সেৱিৎৱা তদনুগামিন্যো জাতা ইমাস্তদন্যাশ্চ যা অনেকা নার্যো যীশুনা সার্দ্ধং যিরূশালমমাযাতাস্তাশ্চ দূরাৎ তানি দদৃশুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","অথাসাদনদিনস্যার্থাদ্ ৱিশ্রামৱারাৎ পূর্ৱ্ৱদিনস্য সাযংকাল আগত ");
INSERT INTO sanben_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ঈশ্ৱররাজ্যাপেক্ষ্যরিমথীযযূষফনামা মান্যমন্ত্রী সমেত্য পীলাতসৱিধং নির্ভযো গৎৱা যীশোর্দেহং যযাচে| ");
INSERT INTO sanben_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","কিন্তু স ইদানীং মৃতঃ পীলাত ইত্যসম্ভৱং মৎৱা শতসেনাপতিমাহূয স কদা মৃত ইতি পপ্রচ্ছ| ");
INSERT INTO sanben_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","শতসেমনাপতিমুখাৎ তজ্জ্ঞাৎৱা যূষফে যীশোর্দেহং দদৌ| ");
INSERT INTO sanben_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","পশ্চাৎ স সূক্ষ্মং ৱাসঃ ক্রীৎৱা যীশোঃ কাযমৱরোহ্য তেন ৱাসসা ৱেষ্টাযিৎৱা গিরৌ খাতশ্মশানে স্থাপিতৱান্ পাষাণং লোঠযিৎৱা দ্ৱারি নিদধে| ");
INSERT INTO sanben_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","কিন্তু যত্র সোস্থাপ্যত তত মগ্দলীনী মরিযম্ যোসিমাতৃমরিযম্ চ দদৃশতৃঃ| ");
INSERT INTO sanben_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","অথ ৱিশ্রামৱারে গতে মগ্দলীনী মরিযম্ যাকূবমাতা মরিযম্ শালোমী চেমাস্তং মর্দ্দযিতুং সুগন্ধিদ্রৱ্যাণি ক্রীৎৱা ");
INSERT INTO sanben_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","সপ্তাহপ্রথমদিনেঽতিপ্রত্যূষে সূর্য্যোদযকালে শ্মশানমুপগতাঃ| ");
INSERT INTO sanben_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","কিন্তু শ্মশানদ্ৱারপাষাণোঽতিবৃহন্ তং কোঽপসারযিষ্যতীতি তাঃ পরস্পরং গদন্তি! ");
INSERT INTO sanben_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","এতর্হি নিরীক্ষ্য পাষাণো দ্ৱারো ঽপসারিত ইতি দদৃশুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","পশ্চাত্তাঃ শ্মশানং প্রৱিশ্য শুক্লৱর্ণদীর্ঘপরিচ্ছদাৱৃতমেকং যুৱানং শ্মশানদক্ষিণপার্শ্ৱ উপৱিষ্টং দৃষ্ট্ৱা চমচ্চক্রুঃ| ");
INSERT INTO sanben_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","সোঽৱদৎ, মাভৈষ্ট যূযং ক্রুশে হতং নাসরতীযযীশুং গৱেষযথ সোত্র নাস্তি শ্মশানাদুদস্থাৎ; তৈ র্যত্র স স্থাপিতঃ স্থানং তদিদং পশ্যত| ");
INSERT INTO sanben_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","কিন্তু তেন যথোক্তং তথা যুষ্মাকমগ্রে গালীলং যাস্যতে তত্র স যুষ্মান্ সাক্ষাৎ করিষ্যতে যূযং গৎৱা তস্য শিষ্যেভ্যঃ পিতরায চ ৱার্ত্তামিমাং কথযত| ");
INSERT INTO sanben_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","তাঃ কম্পিতা ৱিস্তিতাশ্চ তূর্ণং শ্মশানাদ্ বহির্গৎৱা পলাযন্ত ভযাৎ কমপি কিমপি নাৱদংশ্চ| ");
INSERT INTO sanben_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","অপরং যীশুঃ সপ্তাহপ্রথমদিনে প্রত্যূষে শ্মশানাদুত্থায যস্যাঃ সপ্তভূতাস্ত্যাজিতাস্তস্যৈ মগ্দলীনীমরিযমে প্রথমং দর্শনং দদৌ| ");
INSERT INTO sanben_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ততঃ সা গৎৱা শোকরোদনকৃদ্ভ্যোঽনুগতলোকেভ্যস্তাং ৱার্ত্তাং কথযামাস| ");
INSERT INTO sanben_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","কিন্তু যীশুঃ পুনর্জীৱন্ তস্যৈ দর্শনং দত্তৱানিতি শ্রুৎৱা তে ন প্রত্যযন্| ");
INSERT INTO sanben_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","পশ্চাৎ তেষাং দ্ৱাযো র্গ্রামযানকালে যীশুরন্যৱেশং ধৃৎৱা তাভ্যাং দর্শন দদৌ! ");
INSERT INTO sanben_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","তাৱপি গৎৱান্যশিষ্যেভ্যস্তাং কথাং কথযাঞ্চক্রতুঃ কিন্তু তযোঃ কথামপি তে ন প্রত্যযন্| ");
INSERT INTO sanben_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","শেষত একাদশশিষ্যেষু ভোজনোপৱিষ্টেষু যীশুস্তেভ্যো দর্শনং দদৌ তথোত্থানাৎ পরং তদ্দর্শনপ্রাপ্তলোকানাং কথাযামৱিশ্ৱাসকরণাৎ তেষামৱিশ্ৱাসমনঃকাঠিন্যাভ্যাং হেতুভ্যাং স তাংস্তর্জিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","অথ তানাচখ্যৌ যূযং সর্ৱ্ৱজগদ্ গৎৱা সর্ৱ্ৱজনান্ প্রতি সুসংৱাদং প্রচারযত| ");
INSERT INTO sanben_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","তত্র যঃ কশ্চিদ্ ৱিশ্ৱস্য মজ্জিতো ভৱেৎ স পরিত্রাস্যতে কিন্তু যো ন ৱিশ্ৱসিষ্যতি স দণ্ডযিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","কিঞ্চ যে প্রত্যেষ্যন্তি তৈরীদৃগ্ আশ্চর্য্যং কর্ম্ম প্রকাশযিষ্যতে তে মন্নাম্না ভূতান্ ত্যাজযিষ্যন্তি ভাষা অন্যাশ্চ ৱদিষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","অপরং তৈঃ সর্পেষু ধৃতেষু প্রাণনাশকৱস্তুনি পীতে চ তেষাং কাপি ক্ষতি র্ন ভৱিষ্যতি; রোগিণাং গাত্রেষু করার্পিতে তেঽরোগা ভৱিষ্যন্তি চ| ");
INSERT INTO sanben_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","অথ প্রভুস্তানিত্যাদিশ্য স্ৱর্গং নীতঃ সন্ পরমেশ্ৱরস্য দক্ষিণ উপৱিৱেশ| ");
INSERT INTO sanben_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ততস্তে প্রস্থায সর্ৱ্ৱত্র সুসংৱাদীযকথাং প্রচারযিতুমারেভিরে প্রভুস্তু তেষাং সহাযঃ সন্ প্রকাশিতাশ্চর্য্যক্রিযাভিস্তাং কথাং প্রমাণৱতীং চকার| ইতি|");
INSERT INTO sanben_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","প্রথমতো যে সাক্ষিণো ৱাক্যপ্রচারকাশ্চাসন্ তেঽস্মাকং মধ্যে যদ্যৎ সপ্রমাণং ৱাক্যমর্পযন্তি স্ম ");
INSERT INTO sanben_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","তদনুসারতোঽন্যেপি বহৱস্তদ্ৱৃত্তান্তং রচযিতুং প্রৱৃত্তাঃ| ");
INSERT INTO sanben_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","অতএৱ হে মহামহিমথিযফিল্ ৎৱং যা যাঃ কথা অশিক্ষ্যথাস্তাসাং দৃঢপ্রমাণানি যথা প্রাপ্নোষি ");
INSERT INTO sanben_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","তদর্থং প্রথমমারভ্য তানি সর্ৱ্ৱাণি জ্ঞাৎৱাহমপি অনুক্রমাৎ সর্ৱ্ৱৱৃত্তান্তান্ তুভ্যং লেখিতুং মতিমকার্ষম্| ");
INSERT INTO sanben_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","যিহূদাদেশীযহেরোদ্নামকে রাজৎৱং কুর্ৱ্ৱতি অবীযযাজকস্য পর্য্যাযাধিকারী সিখরিযনামক একো যাজকো হারোণৱংশোদ্ভৱা ইলীশেৱাখ্যা ");
INSERT INTO sanben_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","তস্য জাযা দ্ৱাৱিমৌ নির্দোষৌ প্রভোঃ সর্ৱ্ৱাজ্ঞা ৱ্যৱস্থাশ্চ সংমন্য ঈশ্ৱরদৃষ্টৌ ধার্ম্মিকাৱাস্তাম্| ");
INSERT INTO sanben_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","তযোঃ সন্তান একোপি নাসীৎ, যত ইলীশেৱা বন্ধ্যা তৌ দ্ৱাৱেৱ ৱৃদ্ধাৱভৱতাম্| ");
INSERT INTO sanben_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","যদা স্ৱপর্য্যানুক্রমেণ সিখরিয ঈশ্ৱাস্য সমক্ষং যাজকীযং কর্ম্ম করোতি ");
INSERT INTO sanben_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","তদা যজ্ঞস্য দিনপরিপায্যা পরমেশ্ৱরস্য মন্দিরে প্রৱেশকালে ধূপজ্ৱালনং কর্ম্ম তস্য করণীযমাসীৎ| ");
INSERT INTO sanben_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","তদ্ধূপজ্ৱালনকালে লোকনিৱহে প্রার্থনাং কর্তুং বহিস্তিষ্ঠতি ");
INSERT INTO sanben_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","সতি সিখরিযো যস্যাং ৱেদ্যাং ধূপং জ্ৱালযতি তদ্দক্ষিণপার্শ্ৱে পরমেশ্ৱরস্য দূত এক উপস্থিতো দর্শনং দদৌ| ");
INSERT INTO sanben_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","তং দৃষ্ট্ৱা সিখরিয উদ্ৱিৱিজে শশঙ্কে চ| ");
INSERT INTO sanben_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","তদা স দূতস্তং বভাষে হে সিখরিয মা ভৈস্তৱ প্রার্থনা গ্রাহ্যা জাতা তৱ ভার্য্যা ইলীশেৱা পুত্রং প্রসোষ্যতে তস্য নাম যোेহন্ ইতি করিষ্যসি| ");
INSERT INTO sanben_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","কিঞ্চ ৎৱং সানন্দঃ সহর্ষশ্চ ভৱিষ্যসি তস্য জন্মনি বহৱ আনন্দিষ্যন্তি চ| ");
INSERT INTO sanben_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","যতো হেতোঃ স পরমেশ্ৱরস্য গোচরে মহান্ ভৱিষ্যতি তথা দ্রাক্ষারসং সুরাং ৱা কিমপি ন পাস্যতি, অপরং জন্মারভ্য পৱিত্রেণাত্মনা পরিপূর্ণঃ ");
INSERT INTO sanben_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","সন্ ইস্রাযেল্ৱংশীযান্ অনেকান্ প্রভোঃ পরমেশ্ৱরস্য মার্গমানেষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","সন্তানান্ প্রতি পিতৃণাং মনাংসি ধর্ম্মজ্ঞানং প্রত্যনাজ্ঞাগ্রাহিণশ্চ পরাৱর্ত্তযিতুং, প্রভোঃ পরমেশ্ৱরস্য সেৱার্থম্ একাং সজ্জিতজাতিং ৱিধাতুঞ্চ স এলিযরূপাত্মশক্তিপ্রাপ্তস্তস্যাগ্রে গমিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","তদা সিখরিযো দূতমৱাদীৎ কথমেতদ্ ৱেৎস্যামি? যতোহং ৱৃদ্ধো মম ভার্য্যা চ ৱৃদ্ধা| ");
INSERT INTO sanben_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ততো দূতঃ প্রত্যুৱাচ পশ্যেশ্ৱরস্য সাক্ষাদ্ৱর্ত্তী জিব্রাযেল্নামা দূতোহং ৎৱযা সহ কথাং গদিতুং তুভ্যমিমাং শুভৱার্ত্তাং দাতুঞ্চ প্রেষিতঃ| ");
INSERT INTO sanben_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","কিন্তু মদীযং ৱাক্যং কালে ফলিষ্যতি তৎ ৎৱযা ন প্রতীতম্ অতঃ কারণাদ্ যাৱদেৱ তানি ন সেৎস্যন্তি তাৱৎ ৎৱং ৱক্তুংমশক্তো মূকো ভৱ| ");
INSERT INTO sanben_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","তদানীং যে যে লোকাঃ সিখরিযমপৈক্ষন্ত তে মধ্যেমন্দিরং তস্য বহুৱিলম্বাদ্ আশ্চর্য্যং মেনিরে| ");
INSERT INTO sanben_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","স বহিরাগতো যদা কিমপি ৱাক্যং ৱক্তুমশক্তঃ সঙ্কেতং কৃৎৱা নিঃশব্দস্তস্যৌ তদা মধ্যেমন্দিরং কস্যচিদ্ দর্শনং তেন প্রাপ্তম্ ইতি সর্ৱ্ৱে বুবুধিরে| ");
INSERT INTO sanben_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","অনন্তরং তস্য সেৱনপর্য্যাযে সম্পূর্ণে সতি স নিজগেহং জগাম| ");
INSERT INTO sanben_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","কতিপযদিনেষু গতেষু তস্য ভার্য্যা ইলীশেৱা গর্ব্ভৱতী বভূৱ ");
INSERT INTO sanben_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","পশ্চাৎ সা পঞ্চমাসান্ সংগোপ্যাকথযৎ লোকানাং সমক্ষং মমাপমানং খণ্ডযিতুং পরমেশ্ৱরো মযি দৃষ্টিং পাতযিৎৱা কর্ম্মেদৃশং কৃতৱান্| ");
INSERT INTO sanben_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","অপরঞ্চ তস্যা গর্ব্ভস্য ষষ্ঠে মাসে জাতে গালীল্প্রদেশীযনাসরৎপুরে ");
INSERT INTO sanben_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","দাযূদো ৱংশীযায যূষফ্নাম্নে পুরুষায যা মরিযম্নামকুমারী ৱাগ্দত্তাসীৎ তস্যাঃ সমীপং জিব্রাযেল্ দূত ঈশ্ৱরেণ প্রহিতঃ| ");
INSERT INTO sanben_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","স গৎৱা জগাদ হে ঈশ্ৱরানুগৃহীতকন্যে তৱ শুভং ভূযাৎ প্রভুঃ পরমেশ্ৱরস্তৱ সহাযোস্তি নারীণাং মধ্যে ৎৱমেৱ ধন্যা| ");
INSERT INTO sanben_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","তদানীং সা তং দৃষ্ট্ৱা তস্য ৱাক্যত উদ্ৱিজ্য কীদৃশং ভাষণমিদম্ ইতি মনসা চিন্তযামাস| ");
INSERT INTO sanben_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ততো দূতোঽৱদৎ হে মরিযম্ ভযং মাকার্ষীঃ, ৎৱযি পরমেশ্ৱরস্যানুগ্রহোস্তি| ");
INSERT INTO sanben_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","পশ্য ৎৱং গর্ব্ভং ধৃৎৱা পুত্রং প্রসোষ্যসে তস্য নাম যীশুরিতি করিষ্যসি| ");
INSERT INTO sanben_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","স মহান্ ভৱিষ্যতি তথা সর্ৱ্ৱেভ্যঃ শ্রেষ্ঠস্য পুত্র ইতি খ্যাস্যতি; অপরং প্রভুঃ পরমেশ্ৱরস্তস্য পিতুর্দাযূদঃ সিংহাসনং তস্মৈ দাস্যতি; ");
INSERT INTO sanben_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","তথা স যাকূবো ৱংশোপরি সর্ৱ্ৱদা রাজৎৱং করিষ্যতি, তস্য রাজৎৱস্যান্তো ন ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","তদা মরিযম্ তং দূতং বভাষে নাহং পুরুষসঙ্গং করোমি তর্হি কথমেতৎ সম্ভৱিষ্যতি? ");
INSERT INTO sanben_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ততো দূতোঽকথযৎ পৱিত্র আত্মা ৎৱামাশ্রাযিষ্যতি তথা সর্ৱ্ৱশ্রেষ্ঠস্য শক্তিস্তৱোপরি ছাযাং করিষ্যতি ততো হেতোস্তৱ গর্ব্ভাদ্ যঃ পৱিত্রবালকো জনিষ্যতে স ঈশ্ৱরপুত্র ইতি খ্যাতিং প্রাপ্স্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","অপরঞ্চ পশ্য তৱ জ্ঞাতিরিলীশেৱা যাং সর্ৱ্ৱে বন্ধ্যামৱদন্ ইদানীং সা ৱার্দ্ধক্যে সন্তানমেকং গর্ব্ভেঽধারযৎ তস্য ষষ্ঠমাসোভূৎ| ");
INSERT INTO sanben_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","কিমপি কর্ম্ম নাসাধ্যম্ ঈশ্ৱরস্য| ");
INSERT INTO sanben_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","তদা মরিযম্ জগাদ, পশ্য প্রভেরহং দাসী মহ্যং তৱ ৱাক্যানুসারেণ সর্ৱ্ৱমেতদ্ ঘটতাম্; অননতরং দূতস্তস্যাঃ সমীপাৎ প্রতস্থে| ");
INSERT INTO sanben_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","অথ কতিপযদিনাৎ পরং মরিযম্ তস্মাৎ পর্ৱ্ৱতমযপ্রদেশীযযিহূদাযা নগরমেকং শীঘ্রং গৎৱা ");
INSERT INTO sanben_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","সিখরিযযাজকস্য গৃহং প্রৱিশ্য তস্য জাযাম্ ইলীশেৱাং সম্বোধ্যাৱদৎ| ");
INSERT INTO sanben_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ততো মরিযমঃ সম্বোধনৱাক্যে ইলীশেৱাযাঃ কর্ণযোঃ প্রৱিষ্টমাত্রে সতি তস্যা গর্ব্ভস্থবালকো ননর্ত্ত| তত ইলীশেৱা পৱিত্রেণাত্মনা পরিপূর্ণা সতী ");
INSERT INTO sanben_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","প্রোচ্চৈর্গদিতুমারেভে, যোষিতাং মধ্যে ৎৱমেৱ ধন্যা, তৱ গর্ব্ভস্থঃ শিশুশ্চ ধন্যঃ| ");
INSERT INTO sanben_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ৎৱং প্রভোর্মাতা, মম নিৱেশনে ৎৱযা চরণাৱর্পিতৌ, মমাদ্য সৌভাগ্যমেতৎ| ");
INSERT INTO sanben_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","পশ্য তৱ ৱাক্যে মম কর্ণযোঃ প্রৱিষ্টমাত্রে সতি মমোদরস্থঃ শিশুরানন্দান্ ননর্ত্ত| ");
INSERT INTO sanben_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","যা স্ত্রী ৱ্যশ্ৱসীৎ সা ধন্যা, যতো হেতোস্তাং প্রতি পরমেশ্ৱরোক্তং ৱাক্যং সর্ৱ্ৱং সিদ্ধং ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","তদানীং মরিযম্ জগাদ| ধন্যৱাদং পরেশস্য করোতি মামকং মনঃ| ");
INSERT INTO sanben_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","মমাত্মা তারকেশে চ সমুল্লাসং প্রগচ্ছতি| ");
INSERT INTO sanben_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","অকরোৎ স প্রভু র্দুষ্টিং স্ৱদাস্যা দুর্গতিং প্রতি| পশ্যাদ্যারভ্য মাং ধন্যাং ৱক্ষ্যন্তি পুরুষাঃ সদা| ");
INSERT INTO sanben_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","যঃ সর্ৱ্ৱশক্তিমান্ যস্য নামাপি চ পৱিত্রকং| স এৱ সুমহৎকর্ম্ম কৃতৱান্ মন্নিমিত্তকং| ");
INSERT INTO sanben_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","যে বিভ্যতি জনাস্তস্মাৎ তেষাং সন্তানপংক্তিষু| অনুকম্পা তদীযা চ সর্ৱ্ৱদৈৱ সুতিষ্ঠতি| ");
INSERT INTO sanben_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","স্ৱবাহুবলতস্তেন প্রাকাশ্যত পরাক্রমঃ| মনঃকুমন্ত্রণাসার্দ্ধং ৱিকীর্য্যন্তেঽভিমানিনঃ| ");
INSERT INTO sanben_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","সিংহাসনগতাল্লোকান্ বলিনশ্চাৱরোহ্য সঃ| পদেষূচ্চেষু লোকাংস্তু ক্ষুদ্রান্ সংস্থাপযত্যপি| ");
INSERT INTO sanben_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ক্ষুধিতান্ মানৱান্ দ্রৱ্যৈরুত্তমৈঃ পরিতর্প্য সঃ| সকলান্ ধনিনো লোকান্ ৱিসৃজেদ্ রিক্তহস্তকান্| ");
INSERT INTO sanben_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ইব্রাহীমি চ তদ্ৱংশে যা দযাস্তি সদৈৱ তাং| স্মৃৎৱা পুরা পিতৃণাং নো যথা সাক্ষাৎ প্রতিশ্রুতং| ");
INSERT INTO sanben_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ইস্রাযেল্সেৱকস্তেন তথোপক্রিযতে স্ৱযং|| ");
INSERT INTO sanben_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","অনন্তরং মরিযম্ প্রাযেণ মাসত্রযম্ ইলীশেৱযা সহোষিৎৱা ৱ্যাঘুয্য নিজনিৱেশনং যযৌ| ");
INSERT INTO sanben_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","তদনন্তরম্ ইলীশেৱাযাঃ প্রসৱকাল উপস্থিতে সতি সা পুত্রং প্রাসোষ্ট| ");
INSERT INTO sanben_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ততঃ পরমেশ্ৱরস্তস্যাং মহানুগ্রহং কৃতৱান্ এতৎ শ্রুৎৱা সমীপৱাসিনঃ কুটুম্বাশ্চাগত্য তযা সহ মুমুদিরে| ");
INSERT INTO sanben_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","তথাষ্টমে দিনে তে বালকস্য ৎৱচং ছেত্তুম্ এত্য তস্য পিতৃনামানুরূপং তন্নাম সিখরিয ইতি কর্ত্তুমীষুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","কিন্তু তস্য মাতাকথযৎ তন্ন, নামাস্য যোহন্ ইতি কর্ত্তৱ্যম্| ");
INSERT INTO sanben_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","তদা তে ৱ্যাহরন্ তৱ ৱংশমধ্যে নামেদৃশং কস্যাপি নাস্তি| ");
INSERT INTO sanben_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ততঃ পরং তস্য পিতরং সিখরিযং প্রতি সঙ্কেত্য পপ্রচ্ছুঃ শিশোঃ কিং নাম কারিষ্যতে? ");
INSERT INTO sanben_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ততঃ স ফলকমেকং যাচিৎৱা লিলেখ তস্য নাম যোহন্ ভৱিষ্যতি| তস্মাৎ সর্ৱ্ৱে আশ্চর্য্যং মেনিরে| ");
INSERT INTO sanben_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","তৎক্ষণং সিখরিযস্য জিহ্ৱাজাড্যেঽপগতে স মুখং ৱ্যাদায স্পষ্টৱর্ণমুচ্চার্য্য ঈশ্ৱরস্য গুণানুৱাদং চকার| ");
INSERT INTO sanben_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","তস্মাচ্চতুর্দিক্স্থাঃ সমীপৱাসিলোকা ভীতা এৱমেতাঃ সর্ৱ্ৱাঃ কথা যিহূদাযাঃ পর্ৱ্ৱতমযপ্রদেশস্য সর্ৱ্ৱত্র প্রচারিতাঃ| ");
INSERT INTO sanben_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","তস্মাৎ শ্রোতারো মনঃসু স্থাপযিৎৱা কথযাম্বভূৱুঃ কীদৃশোযং বালো ভৱিষ্যতি? অথ পরমেশ্ৱরস্তস্য সহাযোভূৎ| ");
INSERT INTO sanben_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","তদা যোহনঃ পিতা সিখরিযঃ পৱিত্রেণাত্মনা পরিপূর্ণঃ সন্ এতাদৃশং ভৱিষ্যদ্ৱাক্যং কথযামাস| ");
INSERT INTO sanben_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","ইস্রাযেলঃ প্রভু র্যস্তু স ধন্যঃ পরমেশ্ৱরঃ| অনুগৃহ্য নিজাল্লোকান্ স এৱ পরিমোচযেৎ| ");
INSERT INTO sanben_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ৱিপক্ষজনহস্তেভ্যো যথা মোচ্যামহে ৱযং| যাৱজ্জীৱঞ্চ ধর্ম্মেণ সারল্যেন চ নির্ভযাঃ| ");
INSERT INTO sanben_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","সেৱামহৈ তমেৱৈকম্ এতৎকারণমেৱ চ| স্ৱকীযং সুপৱিত্রঞ্চ সংস্মৃত্য নিযমং সদা| ");
INSERT INTO sanben_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","কৃপযা পুরুষান্ পূর্ৱ্ৱান্ নিকষার্থাত্তু নঃ পিতুঃ| ইব্রাহীমঃ সমীপে যং শপথং কৃতৱান্ পুরা| ");
INSERT INTO sanben_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","তমেৱ সফলং কর্ত্তং তথা শত্রুগণস্য চ| ঋृতীযাকারিণশ্চৈৱ করেভ্যো রক্ষণায নঃ| ");
INSERT INTO sanben_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","সৃষ্টেঃ প্রথমতঃ স্ৱীযৈঃ পৱিত্রৈ র্ভাৱিৱাদিভিঃ| ");
INSERT INTO sanben_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","যথোক্তৱান্ তথা স্ৱস্য দাযূদঃ সেৱকস্য তু| ");
INSERT INTO sanben_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ৱংশে ত্রাতারমেকং স সমুৎপাদিতৱান্ স্ৱযম্| ");
INSERT INTO sanben_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","অতো হে বালক ৎৱন্তু সর্ৱ্ৱেভ্যঃ শ্রেষ্ঠ এৱ যঃ| তস্যৈৱ ভাৱিৱাদীতি প্রৱিখ্যাতো ভৱিষ্যসি| অস্মাকং চরণান্ ক্ষেমে মার্গে চালযিতুং সদা| এৱং ধ্ৱান্তেঽর্থতো মৃত্যোশ্ছাযাযাং যে তু মানৱাঃ| ");
INSERT INTO sanben_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","উপৱিষ্টাস্তু তানেৱ প্রকাশযিতুমেৱ হি| কৃৎৱা মহানুকম্পাং হি যামেৱ পরমেশ্ৱরঃ| ");
INSERT INTO sanben_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ঊর্দ্ৱ্ৱাৎ সূর্য্যমুদায্যৈৱাস্মভ্যং প্রাদাত্তু দর্শনং| তযানুকম্পযা স্ৱস্য লোকানাং পাপমোচনে| ");
INSERT INTO sanben_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","পরিত্রাণস্য তেভ্যো হি জ্ঞানৱিশ্রাণনায চ| প্রভো র্মার্গং পরিষ্কর্ত্তুং তস্যাগ্রাযী ভৱিষ্যসি|| ");
INSERT INTO sanben_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","অথ বালকঃ শরীরেণ বুদ্ধ্যা চ ৱর্দ্ধিতুমারেভে; অপরঞ্চ স ইস্রাযেলো ৱংশীযলোকানাং সমীপে যাৱন্ন প্রকটীভূতস্তাস্তাৱৎ প্রান্তরে ন্যৱসৎ| ");
INSERT INTO sanben_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","অপরঞ্চ তস্মিন্ কালে রাজ্যস্য সর্ৱ্ৱেষাং লোকানাং নামানি লেখযিতুম্ অগস্তকৈসর আজ্ঞাপযামাস| ");
INSERT INTO sanben_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","তদনুসারেণ কুরীণিযনামনি সুরিযাদেশস্য শাসকে সতি নামলেখনং প্রারেভে| ");
INSERT INTO sanben_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","অতো হেতো র্নাম লেখিতুং সর্ৱ্ৱে জনাঃ স্ৱীযং স্ৱীযং নগরং জগ্মুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","তদানীং যূষফ্ নাম লেখিতুং ৱাগ্দত্তযা স্ৱভার্য্যযা গর্ব্ভৱত্যা মরিযমা সহ স্ৱযং দাযূদঃ সজাতিৱংশ ইতি কারণাদ্ গালীল্প্রদেশস্য নাসরত্নগরাদ্ ");
INSERT INTO sanben_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","যিহূদাপ্রদেশস্য বৈৎলেহমাখ্যং দাযূদ্নগরং জগাম| ");
INSERT INTO sanben_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","অন্যচ্চ তত্র স্থানে তযোস্তিষ্ঠতোঃ সতো র্মরিযমঃ প্রসূতিকাল উপস্থিতে ");
INSERT INTO sanben_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","সা তং প্রথমসুতং প্রাসোষ্ট কিন্তু তস্মিন্ ৱাসগৃহে স্থানাভাৱাদ্ বালকং ৱস্ত্রেণ ৱেষ্টযিৎৱা গোশালাযাং স্থাপযামাস| ");
INSERT INTO sanben_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","অনন্তরং যে কিযন্তো মেষপালকাঃ স্ৱমেষৱ্রজরক্ষাযৈ তৎপ্রদেশে স্থিৎৱা রজন্যাং প্রান্তরে প্রহরিণঃ কর্ম্ম কুর্ৱ্ৱন্তি, ");
INSERT INTO sanben_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","তেষাং সমীপং পরমেশ্ৱরস্য দূত আগত্যোপতস্থৌ; তদা চতুষ্পার্শ্ৱে পরমেশ্ৱরস্য তেজসঃ প্রকাশিতৎৱাৎ তেঽতিশশঙ্কিরে| ");
INSERT INTO sanben_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","তদা স দূত উৱাচ মা ভৈষ্ট পশ্যতাদ্য দাযূদঃ পুরে যুষ্মন্নিমিত্তং ত্রাতা প্রভুঃ খ্রীষ্টোঽজনিষ্ট, ");
INSERT INTO sanben_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","সর্ৱ্ৱেষাং লোকানাং মহানন্দজনকম্ ইমং মঙ্গলৱৃত্তান্তং যুষ্মান্ জ্ঞাপযামি| ");
INSERT INTO sanben_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","যূযং (তৎস্থানং গৎৱা) ৱস্ত্রৱেষ্টিতং তং বালকং গোশালাযাং শযনং দ্রক্ষ্যথ যুষ্মান্ প্রতীদং চিহ্নং ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","দূত ইমাং কথাং কথিতৱতি তত্রাকস্মাৎ স্ৱর্গীযাঃ পৃতনা আগত্য কথাম্ ইমাং কথযিৎৱেশ্ৱরস্য গুণানন্ৱৱাদিষুঃ, যথা, ");
INSERT INTO sanben_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","সর্ৱ্ৱোর্দ্ৱ্ৱস্থৈরীশ্ৱরস্য মহিমা সম্প্রকাশ্যতাং| শান্তির্ভূযাৎ পৃথিৱ্যাস্তু সন্তোষশ্চ নরান্ প্রতি|| ");
INSERT INTO sanben_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ততঃ পরং তেষাং সন্নিধে র্দূতগণে স্ৱর্গং গতে মেষপালকাঃ পরস্পরম্ অৱেচন্ আগচ্ছত প্রভুঃ পরমেশ্ৱরো যাং ঘটনাং জ্ঞাপিতৱান্ তস্যা যাথর্যং জ্ঞাতুং ৱযমধুনা বৈৎলেহম্পুরং যামঃ| ");
INSERT INTO sanben_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","পশ্চাৎ তে তূর্ণং ৱ্রজিৎৱা মরিযমং যূষফং গোশালাযাং শযনং বালকঞ্চ দদৃশুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ইত্থং দৃষ্ট্ৱা বালকস্যার্থে প্রোক্তাং সর্ৱ্ৱকথাং তে প্রাচারযাঞ্চক্রুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ততো যে লোকা মেষরক্ষকাণাং ৱদনেভ্যস্তাং ৱার্ত্তাং শুশ্রুৱুস্তে মহাশ্চর্য্যং মেনিরে| ");
INSERT INTO sanben_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","কিন্তু মরিযম্ এতৎসর্ৱ্ৱঘটনানাং তাৎপর্য্যং ৱিৱিচ্য মনসি স্থাপযামাস| ");
INSERT INTO sanben_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","তৎপশ্চাদ্ দূতৱিজ্ঞপ্তানুরূপং শ্রুৎৱা দৃষ্ট্ৱা চ মেষপালকা ঈশ্ৱরস্য গুণানুৱাদং ধন্যৱাদঞ্চ কুর্ৱ্ৱাণাঃ পরাৱৃত্য যযুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","অথ বালকস্য ৎৱক্ছেদনকালেঽষ্টমদিৱসে সমুপস্থিতে তস্য গর্ব্ভস্থিতেঃ পুর্ৱ্ৱং স্ৱর্গীযদূতো যথাজ্ঞাপযৎ তদনুরূপং তে তন্নামধেযং যীশুরিতি চক্রিরে| ");
INSERT INTO sanben_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","ততঃ পরং মূসালিখিতৱ্যৱস্থাযা অনুসারেণ মরিযমঃ শুচিৎৱকাল উপস্থিতে, ");
INSERT INTO sanben_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","\"প্রথমজঃ সর্ৱ্ৱঃ পুরুষসন্তানঃ পরমেশ্ৱরে সমর্প্যতাং,\" ইতি পরমেশ্ৱরস্য ৱ্যৱস্থযা ");
INSERT INTO sanben_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","যীশুং পরমেশ্ৱরে সমর্পযিতুম্ শাস্ত্রীযৱিধ্যুক্তং কপোতদ্ৱযং পারাৱতশাৱকদ্ৱযং ৱা বলিং দাতুং তে তং গৃহীৎৱা যিরূশালমম্ আযযুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","যিরূশালম্পুরনিৱাসী শিমিযোন্নামা ধার্ম্মিক এক আসীৎ স ইস্রাযেলঃ সান্ত্ৱনামপেক্ষ্য তস্থৌ কিঞ্চ পৱিত্র আত্মা তস্মিন্নাৱির্ভূতঃ| ");
INSERT INTO sanben_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","অপরং প্রভুণা পরমেশ্ৱরেণাভিষিক্তে ত্রাতরি ৎৱযা ন দৃষ্টে ৎৱং ন মরিষ্যসীতি ৱাক্যং পৱিত্রেণ আত্মনা তস্ম প্রাকথ্যত| ");
INSERT INTO sanben_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","অপরঞ্চ যদা যীশোঃ পিতা মাতা চ তদর্থং ৱ্যৱস্থানুরূপং কর্ম্ম কর্ত্তুং তং মন্দিরম্ আনিন্যতুস্তদা ");
INSERT INTO sanben_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","শিমিযোন্ আত্মন আকর্ষণেন মন্দিরমাগত্য তং ক্রোডে নিধায ঈশ্ৱরস্য ধন্যৱাদং কৃৎৱা কথযামাস, যথা, ");
INSERT INTO sanben_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","হে প্রভো তৱ দাসোযং নিজৱাক্যানুসারতঃ| ইদানীন্তু সকল্যাণো ভৱতা সংৱিসৃজ্যতাম্| ");
INSERT INTO sanben_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","যতঃ সকলদেশস্য দীপ্তযে দীপ্তিরূপকং| ");
INSERT INTO sanben_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ইস্রাযেলীযলোকস্য মহাগৌরৱরূপকং| ");
INSERT INTO sanben_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","যং ত্রাযকং জনানান্তু সম্মুখে ৎৱমজীজনঃ| সএৱ ৱিদ্যতেঽস্মাকং ধ্রৱং নযননগোচরে|| ");
INSERT INTO sanben_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","তদানীং তেনোক্তা এতাঃ সকলাঃ কথাঃ শ্রুৎৱা তস্য মাতা যূষফ্ চ ৱিস্মযং মেনাতে| ");
INSERT INTO sanben_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ততঃ পরং শিমিযোন্ তেভ্য আশিষং দত্ত্ৱা তন্মাতরং মরিযমম্ উৱাচ, পশ্য ইস্রাযেলো ৱংশমধ্যে বহূনাং পাতনাযোত্থাপনায চ তথা ৱিরোধপাত্রং ভৱিতুং, বহূনাং গুপ্তমনোগতানাং প্রকটীকরণায বালকোযং নিযুক্তোস্তি| ");
INSERT INTO sanben_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","তস্মাৎ তৱাপি প্রাণাঃ শূলেন ৱ্যৎস্যন্তে| ");
INSERT INTO sanben_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","অপরঞ্চ আশেরস্য ৱংশীযফিনূযেলো দুহিতা হন্নাখ্যা অতিজরতী ভৱিষ্যদ্ৱাদিন্যেকা যা ৱিৱাহাৎ পরং সপ্ত ৱৎসরান্ পত্যা সহ ন্যৱসৎ ততো ৱিধৱা ভূৎৱা চতুরশীতিৱর্ষৱযঃপর্য্যনতং ");
INSERT INTO sanben_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","মন্দিরে স্থিৎৱা প্রার্থনোপৱাসৈর্দিৱানিশম্ ঈশ্ৱরম্ অসেৱত সাপি স্ত্রী তস্মিন্ সমযে মন্দিরমাগত্য ");
INSERT INTO sanben_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","পরমেশ্ৱরস্য ধন্যৱাদং চকার, যিরূশালম্পুরৱাসিনো যাৱন্তো লোকা মুক্তিমপেক্ষ্য স্থিতাস্তান্ যীশোর্ৱৃত্তান্তং জ্ঞাপযামাস| ");
INSERT INTO sanben_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ইত্থং পরমেশ্ৱরস্য ৱ্যৱস্থানুসারেণ সর্ৱ্ৱেষু কর্ম্মসু কৃতেষু তৌ পুনশ্চ গালীলো নাসরত্নামকং নিজনগরং প্রতস্থাতে| ");
INSERT INTO sanben_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","তৎপশ্চাদ্ বালকঃ শরীরেণ ৱৃদ্ধিমেত্য জ্ঞানেন পরিপূর্ণ আত্মনা শক্তিমাংশ্চ ভৱিতুমারেভে তথা তস্মিন্ ঈশ্ৱরানুগ্রহো বভূৱ| ");
INSERT INTO sanben_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","তস্য পিতা মাতা চ প্রতিৱর্ষং নিস্তারোৎসৱসমযে যিরূশালমম্ অগচ্ছতাম্| ");
INSERT INTO sanben_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","অপরঞ্চ যীশৌ দ্ৱাদশৱর্ষৱযস্কে সতি তৌ পর্ৱ্ৱসমযস্য রীত্যনুসারেণ যিরূশালমং গৎৱা ");
INSERT INTO sanben_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","পার্ৱ্ৱণং সম্পাদ্য পুনরপি ৱ্যাঘুয্য যাতঃ কিন্তু যীশুর্বালকো যিরূশালমি তিষ্ঠতি| যূষফ্ তন্মাতা চ তদ্ অৱিদিৎৱা ");
INSERT INTO sanben_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","স সঙ্গিভিঃ সহ ৱিদ্যত এতচ্চ বুদ্ৱ্ৱা দিনৈকগম্যমার্গং জগ্মতুঃ| কিন্তু শেষে জ্ঞাতিবন্ধূনাং সমীপে মৃগযিৎৱা তদুদ্দেेশমপ্রাপ্য ");
INSERT INTO sanben_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","তৌ পুনরপি যিরূশালমম্ পরাৱৃত্যাগত্য তং মৃগযাঞ্চক্রতুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","অথ দিনত্রযাৎ পরং পণ্ডিতানাং মধ্যে তেষাং কথাঃ শৃণ্ৱন্ তত্ত্ৱং পৃচ্ছংশ্চ মন্দিরে সমুপৱিষ্টঃ স তাভ্যাং দৃষ্টঃ| ");
INSERT INTO sanben_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","তদা তস্য বুদ্ধ্যা প্রত্যুত্তরৈশ্চ সর্ৱ্ৱে শ্রোতারো ৱিস্মযমাপদ্যন্তে| ");
INSERT INTO sanben_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","তাদৃশং দৃষ্ট্ৱা তস্য জনকো জননী চ চমচ্চক্রতুঃ কিঞ্চ তস্য মাতা তমৱদৎ, হে পুত্র, কথমাৱাং প্রতীত্থং সমাচরস্ত্ৱম্? পশ্য তৱ পিতাহঞ্চ শোকাকুলৌ সন্তৌ ৎৱামন্ৱিচ্ছাৱঃ স্ম| ");
INSERT INTO sanben_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","ততঃ সোৱদৎ কুতো মাম্ অন্ৱৈচ্ছতং? পিতুর্গৃহে মযা স্থাতৱ্যম্ এতৎ কিং যুৱাভ্যাং ন জ্ঞাযতে? ");
INSERT INTO sanben_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","কিন্তু তৌ তস্যৈতদ্ৱাক্যস্য তাৎপর্য্যং বোদ্ধুং নাশক্নুতাং| ");
INSERT INTO sanben_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ততঃ পরং স তাভ্যাং সহ নাসরতং গৎৱা তযোর্ৱশীভূতস্তস্থৌ কিন্তু সর্ৱ্ৱা এতাঃ কথাস্তস্য মাতা মনসি স্থাপযামাস| ");
INSERT INTO sanben_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","অথ যীশো র্বুদ্ধিঃ শরীরঞ্চ তথা তস্মিন্ ঈশ্ৱরস্য মানৱানাঞ্চানুগ্রহো ৱর্দ্ধিতুম্ আরেভে| ");
INSERT INTO sanben_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","অনন্তরং তিবিরিযকৈসরস্য রাজৎৱস্য পঞ্চদশে ৱৎসরে সতি যদা পন্তীযপীলাতো যিহূদাদেশাধিপতি র্হেরোদ্ তু গালীল্প্রদেশস্য রাজা ফিলিপনামা তস্য ভ্রাতা তু যিতূরিযাযাস্ত্রাখোনীতিযাপ্রদেশস্য চ রাজাসীৎ লুষানীযনামা অৱিলীনীদেশস্য রাজাসীৎ ");
INSERT INTO sanben_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","হানন্ কিযফাশ্চেমৌ প্রধানযাজাকাৱাস্তাং তদানীং সিখরিযস্য পুত্রায যোহনে মধ্যেপ্রান্তরম্ ঈশ্ৱরস্য ৱাক্যে প্রকাশিতে সতি ");
INSERT INTO sanben_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","স যর্দ্দন উভযতটপ্রদেশান্ সমেত্য পাপমোচনার্থং মনঃপরাৱর্ত্তনস্য চিহ্নরূপং যন্মজ্জনং তদীযাঃ কথাঃ সর্ৱ্ৱত্র প্রচারযিতুমারেভে| ");
INSERT INTO sanben_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","যিশযিযভৱিষ্যদ্ৱক্তৃগ্রন্থে যাদৃশী লিপিরাস্তে যথা, পরমেশস্য পন্থানং পরিষ্কুরুত সর্ৱ্ৱতঃ| তস্য রাজপথঞ্চৈৱ সমানং কুরুতাধুনা| ");
INSERT INTO sanben_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","কারিষ্যন্তে সমুচ্ছ্রাযাঃ সকলা নিম্নভূমযঃ| কারিষ্যন্তে নতাঃ সর্ৱ্ৱে পর্ৱ্ৱতাশ্চোপপর্ৱ্ৱতাঃ| কারিষ্যন্তে চ যা ৱক্রাস্তাঃ সর্ৱ্ৱাঃ সরলা ভুৱঃ| কারিষ্যন্তে সমানাস্তা যা উচ্চনীচভূমযঃ| ");
INSERT INTO sanben_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ঈশ্ৱরেণ কৃতং ত্রাণং দ্রক্ষ্যন্তি সর্ৱ্ৱমানৱাঃ| ইত্যেতৎ প্রান্তরে ৱাক্যং ৱদতঃ কস্যচিদ্ রৱঃ|| ");
INSERT INTO sanben_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","যে যে লোকা মজ্জনার্থং বহিরাযযুস্তান্ সোৱদৎ রে রে সর্পৱংশা আগামিনঃ কোপাৎ পলাযিতুং যুষ্মান্ কশ্চেতযামাস? ");
INSERT INTO sanben_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","তস্মাদ্ ইব্রাহীম্ অস্মাকং পিতা কথামীদৃশীং মনোভি র্ন কথযিৎৱা যূযং মনঃপরিৱর্ত্তনযোগ্যং ফলং ফলত; যুষ্মানহং যথার্থং ৱদামি পাষাণেভ্য এতেভ্য ঈশ্ৱর ইব্রাহীমঃ সন্তানোৎপাদনে সমর্থঃ| ");
INSERT INTO sanben_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","অপরঞ্চ তরুমূলেঽধুনাপি পরশুঃ সংলগ্নোস্তি যস্তরুরুত্তমং ফলং ন ফলতি স ছিদ্যতেঽগ্নৌ নিক্ষিপ্যতে চ| ");
INSERT INTO sanben_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","তদানীং লোকাস্তং পপ্রচ্ছুস্তর্হি কিং কর্ত্তৱ্যমস্মাভিঃ? ");
INSERT INTO sanben_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ততঃ সোৱাদীৎ যস্য দ্ৱে ৱসনে ৱিদ্যেতে স ৱস্ত্রহীনাযৈকং ৱিতরতু কিংঞ্চ যস্য খাদ্যদ্রৱ্যং ৱিদ্যতে সোপি তথৈৱ করোতু| ");
INSERT INTO sanben_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ততঃ পরং করসঞ্চাযিনো মজ্জনার্থম্ আগত্য পপ্রচ্ছুঃ হে গুরো কিং কর্ত্তৱ্যমস্মাভিঃ? ");
INSERT INTO sanben_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ততঃ সোকথযৎ নিরূপিতাদধিকং ন গৃহ্লিত| ");
INSERT INTO sanben_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","অনন্তরং সেনাগণ এত্য পপ্রচ্ছ কিমস্মাভি র্ৱা কর্ত্তৱ্যম্? ততঃ সোভিদধে কস্য কামপি হানিং মা কার্ষ্ট তথা মৃষাপৱাদং মা কুরুত নিজৱেতনেন চ সন্তুষ্য তিষ্ঠত| ");
INSERT INTO sanben_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","অপরঞ্চ লোকা অপেক্ষযা স্থিৎৱা সর্ৱ্ৱেপীতি মনোভি র্ৱিতর্কযাঞ্চক্রুঃ, যোহনযম্ অভিষিক্তস্ত্রাতা ন ৱেতি? ");
INSERT INTO sanben_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","তদা যোহন্ সর্ৱ্ৱান্ ৱ্যাজহার, জলেঽহং যুষ্মান্ মজ্জযামি সত্যং কিন্তু যস্য পাদুকাবন্ধনং মোচযিতুমপি ন যোগ্যোস্মি তাদৃশ একো মত্তো গুরুতরঃ পুমান্ এতি, স যুষ্মান্ ৱহ্নিরূপে পৱিত্র আত্মনি মজ্জযিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","অপরঞ্চ তস্য হস্তে শূর্প আস্তে স স্ৱশস্যানি শুদ্ধরূপং প্রস্ফোট্য গোধূমান্ সর্ৱ্ৱান্ ভাণ্ডাগারে সংগ্রহীষ্যতি কিন্তু বূষাণি সর্ৱ্ৱাণ্যনির্ৱ্ৱাণৱহ্নিনা দাহযিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","যোহন্ উপদেশেনেত্থং নানাকথা লোকানাং সমক্ষং প্রচারযামাস| ");
INSERT INTO sanben_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","অপরঞ্চ হেরোদ্ রাজা ফিলিপ্নাম্নঃ সহোদরস্য ভার্য্যাং হেরোদিযামধি তথান্যানি যানি যানি কুকর্ম্মাণি কৃতৱান্ তদধি চ ");
INSERT INTO sanben_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","যোহনা তিরস্কৃতো ভূৎৱা কারাগারে তস্য বন্ধনাদ্ অপরমপি কুকর্ম্ম চকার| ");
INSERT INTO sanben_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ইতঃ পূর্ৱ্ৱং যস্মিন্ সমযে সর্ৱ্ৱে যোহনা মজ্জিতাস্তদানীং যীশুরপ্যাগত্য মজ্জিতঃ| ");
INSERT INTO sanben_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","তদনন্তরং তেন প্রার্থিতে মেঘদ্ৱারং মুক্তং তস্মাচ্চ পৱিত্র আত্মা মূর্ত্তিমান্ ভূৎৱা কপোতৱৎ তদুপর্য্যৱরুরোহ; তদা ৎৱং মম প্রিযঃ পুত্রস্ত্ৱযি মম পরমঃ সন্তোষ ইত্যাকাশৱাণী বভূৱ| ");
INSERT INTO sanben_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","তদানীং যীশুঃ প্রাযেণ ত্রিংশদ্ৱর্ষৱযস্ক আসীৎ| লৌকিকজ্ঞানে তু স যূষফঃ পুত্রঃ, ");
INSERT INTO sanben_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","যূষফ্ এলেঃ পুত্রঃ, এলির্মত্ততঃ পুত্রঃ, মত্তৎ লেৱেঃ পুত্রঃ, লেৱি র্মল্কেঃ পুত্রঃ, মল্কির্যান্নস্য পুত্রঃ; যান্নো যূষফঃ পুত্রঃ| ");
INSERT INTO sanben_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","যূষফ্ মত্তথিযস্য পুত্রঃ, মত্তথিয আমোসঃ পুত্রঃ, আমোস্ নহূমঃ পুত্রঃ, নহূম্ ইষ্লেঃ পুত্রঃ ইষ্লির্নগেঃ পুত্রঃ| ");
INSERT INTO sanben_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","নগির্মাটঃ পুত্রঃ, মাট্ মত্তথিযস্য পুত্রঃ, মত্তথিযঃ শিমিযেঃ পুত্রঃ, শিমিযির্যূষফঃ পুত্রঃ, যূষফ্ যিহূদাঃ পুত্রঃ| ");
INSERT INTO sanben_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","যিহূদা যোহানাঃ পুত্রঃ, যোহানা রীষাঃ পুত্রঃ, রীষাঃ সিরুব্বাবিলঃ পুত্রঃ, সিরুব্বাবিল্ শল্তীযেলঃ পুত্রঃ, শল্তীযেল্ নেরেঃ পুত্রঃ| ");
INSERT INTO sanben_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","নেরির্মল্কেঃ পুত্রঃ, মল্কিঃ অদ্যঃ পুত্রঃ, অদ্দী কোষমঃ পুত্রঃ, কোষম্ ইল্মোদদঃ পুত্রঃ, ইল্মোদদ্ এরঃ পুত্রঃ| ");
INSERT INTO sanben_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","এর্ যোশেঃ পুত্রঃ, যোশিঃ ইলীযেষরঃ পুত্রঃ, ইলীযেষর্ যোরীমঃ পুত্রঃ, যোরীম্ মত্ততঃ পুত্রঃ, মত্তত লেৱেঃ পুত্রঃ| ");
INSERT INTO sanben_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","লেৱিঃ শিমিযোনঃ পুত্রঃ, শিমিযোন্ যিহূদাঃ পুত্রঃ, যিহূদা যূষুফঃ পুত্রঃ, যূষুফ্ যোননঃ পুত্রঃ, যানন্ ইলীযাকীমঃ পুত্রঃ| ");
INSERT INTO sanben_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ইলিযাকীম্ঃ মিলেযাঃ পুত্রঃ, মিলেযা মৈননঃ পুত্রঃ, মৈনন্ মত্তত্তস্য পুত্রঃ, মত্তত্তো নাথনঃ পুত্রঃ, নাথন্ দাযূদঃ পুত্রঃ| ");
INSERT INTO sanben_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","দাযূদ্ যিশযঃ পুত্রঃ, যিশয ওবেদঃ পুত্র, ওবেদ্ বোযসঃ পুত্রঃ, বোযস্ সল্মোনঃ পুত্রঃ, সল্মোন্ নহশোনঃ পুত্রঃ| ");
INSERT INTO sanben_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","নহশোন্ অম্মীনাদবঃ পুত্রঃ, অম্মীনাদব্ অরামঃ পুত্রঃ, অরাম্ হিষ্রোণঃ পুত্রঃ, হিষ্রোণ্ পেরসঃ পুত্রঃ, পেরস্ যিহূদাঃ পুত্রঃ| ");
INSERT INTO sanben_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","যিহূদা যাকূবঃ পুত্রঃ, যাকূব্ ইস্হাকঃ পুত্রঃ, ইস্হাক্ ইব্রাহীমঃ পুত্রঃ, ইব্রাহীম্ তেরহঃ পুত্রঃ, তেরহ্ নাহোরঃ পুত্রঃ| ");
INSERT INTO sanben_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","নাহোর্ সিরুগঃ পুত্রঃ, সিরুগ্ রিয্ৱঃ পুত্রঃ, রিযূঃ পেলগঃ পুত্রঃ, পেলগ্ এৱরঃ পুত্রঃ, এৱর্ শেলহঃ পুত্রঃ| ");
INSERT INTO sanben_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","শেলহ্ কৈননঃ পুত্রঃ, কৈনন্ অর্ফক্ষদঃ পুত্রঃ, অর্ফক্ষদ্ শামঃ পুত্রঃ, শাম্ নোহঃ পুত্রঃ, নোহো লেমকঃ পুত্রঃ| ");
INSERT INTO sanben_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","লেমক্ মিথূশেলহঃ পুত্রঃ, মিথূশেলহ্ হনোকঃ পুত্রঃ, হনোক্ যেরদঃ পুত্রঃ, যেরদ্ মহললেলঃ পুত্রঃ, মহললেল্ কৈননঃ পুত্রঃ| ");
INSERT INTO sanben_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","কৈনন্ ইনোশঃ পুত্রঃ, ইনোশ্ শেতঃ পুত্রঃ, শেৎ আদমঃ পুত্র, আদম্ ঈশ্ৱরস্য পুত্রঃ| ");
INSERT INTO sanben_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ততঃ পরং যীশুঃ পৱিত্রেণাত্মনা পূর্ণঃ সন্ যর্দ্দননদ্যাঃ পরাৱৃত্যাত্মনা প্রান্তরং নীতঃ সন্ চৎৱারিংশদ্দিনানি যাৱৎ শৈতানা পরীক্ষিতোঽভূৎ, ");
INSERT INTO sanben_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","কিঞ্চ তানি সর্ৱ্ৱদিনানি ভোজনং ৱিনা স্থিতৎৱাৎ কালে পূর্ণে স ক্ষুধিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ততঃ শৈতানাগত্য তমৱদৎ ৎৱং চেদীশ্ৱরস্য পুত্রস্তর্হি প্রস্তরানেতান্ আজ্ঞযা পূপান্ কুরু| ");
INSERT INTO sanben_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","তদা যীশুরুৱাচ, লিপিরীদৃশী ৱিদ্যতে মনুজঃ কেৱলেন পূপেন ন জীৱতি কিন্ত্ৱীশ্ৱরস্য সর্ৱ্ৱাভিরাজ্ঞাভি র্জীৱতি| ");
INSERT INTO sanben_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","তদা শৈতান্ তমুচ্চং পর্ৱ্ৱতং নীৎৱা নিমিষৈকমধ্যে জগতঃ সর্ৱ্ৱরাজ্যানি দর্শিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","পশ্চাৎ তমৱাদীৎ সর্ৱ্ৱম্ এতদ্ ৱিভৱং প্রতাপঞ্চ তুভ্যং দাস্যামি তন্ মযি সমর্পিতমাস্তে যং প্রতি মমেচ্ছা জাযতে তস্মৈ দাতুং শক্নোমি, ");
INSERT INTO sanben_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ৎৱং চেন্মাং ভজসে তর্হি সর্ৱ্ৱমেতৎ তৱৈৱ ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","তদা যীশুস্তং প্রত্যুক্তৱান্ দূরী ভৱ শৈতান্ লিপিরাস্তে, নিজং প্রভুং পরমেশ্ৱরং ভজস্ৱ কেৱলং তমেৱ সেৱস্ৱ চ| ");
INSERT INTO sanben_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","অথ শৈতান্ তং যিরূশালমং নীৎৱা মন্দিরস্য চূডাযা উপরি সমুপৱেশ্য জগাদ ৎৱং চেদীশ্ৱরস্য পুত্রস্তর্হি স্থানাদিতো লম্ফিৎৱাধঃ ");
INSERT INTO sanben_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","পত যতো লিপিরাস্তে, আজ্ঞাপযিষ্যতি স্ৱীযান্ দূতান্ স পরমেশ্ৱরঃ| ");
INSERT INTO sanben_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","রক্ষিতুং সর্ৱ্ৱমার্গে ৎৱাং তেন ৎৱচ্চরণে যথা| ন লগেৎ প্রস্তরাঘাতস্ত্ৱাং ধরিষ্যন্তি তে তথা| ");
INSERT INTO sanben_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","তদা যীশুনা প্রত্যুক্তম্ ইদমপ্যুক্তমস্তি ৎৱং স্ৱপ্রভুং পরেশং মা পরীক্ষস্ৱ| ");
INSERT INTO sanben_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","পশ্চাৎ শৈতান্ সর্ৱ্ৱপরীক্ষাং সমাপ্য ক্ষণাত্তং ত্যক্ত্ৱা যযৌ| ");
INSERT INTO sanben_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","তদা যীশুরাত্মপ্রভাৱাৎ পুনর্গালীল্প্রদেশং গতস্তদা তৎসুখ্যাতিশ্চতুর্দিশং ৱ্যানশে| ");
INSERT INTO sanben_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","স তেষাং ভজনগৃহেষু উপদিশ্য সর্ৱ্ৱৈঃ প্রশংসিতো বভূৱ| ");
INSERT INTO sanben_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","অথ স স্ৱপালনস্থানং নাসরৎপুরমেত্য ৱিশ্রামৱারে স্ৱাচারাদ্ ভজনগেহং প্রৱিশ্য পঠিতুমুত্তস্থৌ| ");
INSERT INTO sanben_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ততো যিশযিযভৱিষ্যদ্ৱাদিনঃ পুস্তকে তস্য করদত্তে সতি স তৎ পুস্তকং ৱিস্তার্য্য যত্র ৱক্ষ্যমাণানি ৱচনানি সন্তি তৎ স্থানং প্রাপ্য পপাঠ| ");
INSERT INTO sanben_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","আত্মা তু পরমেশস্য মদীযোপরি ৱিদ্যতে| দরিদ্রেষু সুসংৱাদং ৱক্তুং মাং সোভিষিক্তৱান্| ভগ্নান্তঃ করণাল্লোকান্ সুস্ৱস্থান্ কর্ত্তুমেৱ চ| বন্দীকৃতেষু লোকেষু মুক্তে র্ঘোষযিতুং ৱচঃ| নেত্রাণি দাতুমন্ধেভ্যস্ত্রাতুং বদ্ধজনানপি| ");
INSERT INTO sanben_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","পরেশানুগ্রহে কালং প্রচারযিতুমেৱ চ| সর্ৱ্ৱৈতৎকরণার্থায মামেৱ প্রহিণোতি সঃ|| ");
INSERT INTO sanben_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ততঃ পুস্তকং বদ্ৱ্ৱা পরিচারকস্য হস্তে সমর্প্য চাসনে সমুপৱিষ্টঃ, ততো ভজনগৃহে যাৱন্তো লোকা আসন্ তে সর্ৱ্ৱেঽনন্যদৃষ্ট্যা তং ৱিলুলোকিরে| ");
INSERT INTO sanben_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","অনন্তরম্ অদ্যৈতানি সর্ৱ্ৱাণি লিখিতৱচনানি যুষ্মাকং মধ্যে সিদ্ধানি স ইমাং কথাং তেভ্যঃ কথযিতুমারেভে| ");
INSERT INTO sanben_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","ততঃ সর্ৱ্ৱে তস্মিন্ অন্ৱরজ্যন্ত, কিঞ্চ তস্য মুখান্নির্গতাভিরনুগ্রহস্য কথাভিশ্চমৎকৃত্য কথযামাসুঃ কিমযং যূষফঃ পুত্রো ন? ");
INSERT INTO sanben_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","তদা সোঽৱাদীদ্ হে চিকিৎসক স্ৱমেৱ স্ৱস্থং কুরু কফর্নাহূমি যদ্যৎ কৃতৱান্ তদশ্রৌষ্ম তাঃ সর্ৱাঃ ক্রিযা অত্র স্ৱদেশে কুরু কথামেতাং যূযমেৱাৱশ্যং মাং ৱদিষ্যথ| ");
INSERT INTO sanben_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","পুনঃ সোৱাদীদ্ যুষ্মানহং যথার্থং ৱদামি, কোপি ভৱিষ্যদ্ৱাদী স্ৱদেশে সৎকারং ন প্রাপ্নোতি| ");
INSERT INTO sanben_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","অপরঞ্চ যথার্থং ৱচ্মি, এলিযস্য জীৱনকালে যদা সার্দ্ধত্রিতযৱর্ষাণি যাৱৎ জলদপ্রতিবন্ধাৎ সর্ৱ্ৱস্মিন্ দেশে মহাদুর্ভিক্ষম্ অজনিষ্ট তদানীম্ ইস্রাযেলো দেশস্য মধ্যে বহ্ৱ্যো ৱিধৱা আসন্, ");
INSERT INTO sanben_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","কিন্তু সীদোন্প্রদেশীযসারিফৎপুরনিৱাসিনীম্ একাং ৱিধৱাং ৱিনা কস্যাশ্চিদপি সমীপে এলিযঃ প্রেরিতো নাভূৎ| ");
INSERT INTO sanben_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","অপরঞ্চ ইলীশাযভৱিষ্যদ্ৱাদিৱিদ্যমানতাকালে ইস্রাযেল্দেশে বহৱঃ কুষ্ঠিন আসন্ কিন্তু সুরীযদেশীযং নামান্কুষ্ঠিনং ৱিনা কোপ্যন্যঃ পরিষ্কৃতো নাভূৎ| ");
INSERT INTO sanben_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ইমাং কথাং শ্রুৎৱা ভজনগেহস্থিতা লোকাঃ সক্রোধম্ উত্থায ");
INSERT INTO sanben_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","নগরাত্তং বহিষ্কৃত্য যস্য শিখরিণ উপরি তেষাং নগরং স্থাপিতমাস্তে তস্মান্নিক্ষেপ্তুং তস্য শিখরং তং নিন্যুঃ ");
INSERT INTO sanben_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","কিন্তু স তেষাং মধ্যাদপসৃত্য স্থানান্তরং জগাম| ");
INSERT INTO sanben_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ততঃ পরং যীশুর্গালীল্প্রদেশীযকফর্নাহূম্নগর উপস্থায ৱিশ্রামৱারে লোকানুপদেষ্টুম্ আরব্ধৱান্| ");
INSERT INTO sanben_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","তদুপদেশাৎ সর্ৱ্ৱে চমচ্চক্রু র্যতস্তস্য কথা গুরুতরা আসন্| ");
INSERT INTO sanben_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","তদানীং তদ্ভজনগেহস্থিতোঽমেধ্যভূতগ্রস্ত একো জন উচ্চৈঃ কথযামাস, ");
INSERT INTO sanben_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","হে নাসরতীযযীশোঽস্মান্ ত্যজ, ৎৱযা সহাস্মাকং কঃ সম্বন্ধঃ? কিমস্মান্ ৱিনাশযিতুমাযাসি? ৎৱমীশ্ৱরস্য পৱিত্রো জন এতদহং জানামি| ");
INSERT INTO sanben_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","তদা যীশুস্তং তর্জযিৎৱাৱদৎ মৌনী ভৱ ইতো বহির্ভৱ; ততঃ সোমেধ্যভূতস্তং মধ্যস্থানে পাতযিৎৱা কিঞ্চিদপ্যহিংসিৎৱা তস্মাদ্ বহির্গতৱান্| ");
INSERT INTO sanben_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","ততঃ সর্ৱ্ৱে লোকাশ্চমৎকৃত্য পরস্পরং ৱক্তুমারেভিরে কোযং চমৎকারঃ| এষ প্রভাৱেণ পরাক্রমেণ চামেধ্যভূতান্ আজ্ঞাপযতি তেনৈৱ তে বহির্গচ্ছন্তি| ");
INSERT INTO sanben_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","অনন্তরং চতুর্দিক্স্থদেশান্ তস্য সুখ্যাতির্ৱ্যাপ্নোৎ| ");
INSERT INTO sanben_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","তদনন্তরং স ভজনগেহাদ্ বহিরাগত্য শিমোনো নিৱেশনং প্রৱিৱেশ তদা তস্য শ্ৱশ্রূর্জ্ৱরেণাত্যন্তং পীডিতাসীৎ শিষ্যাস্তদর্থং তস্মিন্ ৱিনযং চক্রুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ততঃ স তস্যাঃ সমীপে স্থিৎৱা জ্ৱরং তর্জযামাস তেনৈৱ তাং জ্ৱরোঽত্যাক্ষীৎ ততঃ সা তৎক্ষণম্ উত্থায তান্ সিষেৱে| ");
INSERT INTO sanben_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","অথ সূর্য্যাস্তকালে স্ৱেষাং যে যে জনা নানারোগৈঃ পীডিতা আসন্ লোকাস্তান্ যীশোঃ সমীপম্ আনিন্যুঃ, তদা স একৈকস্য গাত্রে করমর্পযিৎৱা তানরোগান্ চকার| ");
INSERT INTO sanben_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ততো ভূতা বহুভ্যো নির্গত্য চীৎশব্দং কৃৎৱা চ বভাষিরে ৎৱমীশ্ৱরস্য পুত্রোঽভিষিক্তত্রাতা; কিন্তু সোভিষিক্তত্রাতেতি তে ৱিৱিদুরেতস্মাৎ কারণাৎ তান্ তর্জযিৎৱা তদ্ৱক্তুং নিষিষেধ| ");
INSERT INTO sanben_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","অপরঞ্চ প্রভাতে সতি স ৱিজনস্থানং প্রতস্থে পশ্চাৎ জনাস্তমন্ৱিচ্ছন্তস্তন্নিকটং গৎৱা স্থানান্তরগমনার্থং তমন্ৱরুন্ধন্| ");
INSERT INTO sanben_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","কিন্তু স তান্ জগাদ, ঈশ্ৱরীযরাজ্যস্য সুসংৱাদং প্রচারযিতুম্ অন্যানি পুরাণ্যপি মযা যাতৱ্যানি যতস্তদর্থমেৱ প্রেরিতোহং| ");
INSERT INTO sanben_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","অথ গালীলো ভজনগেহেষু স উপদিদেশ| ");
INSERT INTO sanben_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","অনন্তরং যীশুরেকদা গিনেষরথ্দস্য তীর উত্তিষ্ঠতি, তদা লোকা ঈশ্ৱরীযকথাং শ্রোতুং তদুপরি প্রপতিতাঃ| ");
INSERT INTO sanben_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","তদানীং স হ্দস্য তীরসমীপে নৌদ্ৱযং দদর্শ কিঞ্চ মৎস্যোপজীৱিনো নাৱং ৱিহায জালং প্রক্ষালযন্তি| ");
INSERT INTO sanben_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ততস্তযোর্দ্ৱযো র্মধ্যে শিমোনো নাৱমারুহ্য তীরাৎ কিঞ্চিদ্দূরং যাতুং তস্মিন্ ৱিনযং কৃৎৱা নৌকাযামুপৱিশ্য লোকান্ প্রোপদিষ্টৱান্| ");
INSERT INTO sanben_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","পশ্চাৎ তং প্রস্তাৱং সমাপ্য স শিমোনং ৱ্যাজহার, গভীরং জলং গৎৱা মৎস্যান্ ধর্ত্তুং জালং নিক্ষিপ| ");
INSERT INTO sanben_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ততঃ শিমোন বভাষে, হে গুরো যদ্যপি ৱযং কৃৎস্নাং যামিনীং পরিশ্রম্য মৎস্যৈকমপি ন প্রাপ্তাস্তথাপি ভৱতো নিদেশতো জালং ক্ষিপামঃ| ");
INSERT INTO sanben_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","অথ জালে ক্ষিপ্তে বহুমৎস্যপতনাদ্ আনাযঃ প্রচ্ছিন্নঃ| ");
INSERT INTO sanben_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","তস্মাদ্ উপকর্ত্তুম্ অন্যনৌস্থান্ সঙ্গিন আযাতুম্ ইঙ্গিতেন সমাহ্ৱযন্ ততস্ত আগত্য মৎস্যৈ র্নৌদ্ৱযং প্রপূরযামাসু র্যৈ র্নৌদ্ৱযং প্রমগ্নম্| ");
INSERT INTO sanben_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","তদা শিমোন্পিতরস্তদ্ ৱিলোক্য যীশোশ্চরণযোঃ পতিৎৱা, হে প্রভোহং পাপী নরো মম নিকটাদ্ ভৱান্ যাতু, ইতি কথিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","যতো জালে পতিতানাং মৎস্যানাং যূথাৎ শিমোন্ তৎসঙ্গিনশ্চ চমৎকৃতৱন্তঃ; শিমোনঃ সহকারিণৌ সিৱদেঃ পুত্রৌ যাকূব্ যোহন্ চেমৌ তাদৃশৌ বভূৱতুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","তদা যীশুঃ শিমোনং জগাদ মা ভৈষীরদ্যারভ্য ৎৱং মনুষ্যধরো ভৱিষ্যসি| ");
INSERT INTO sanben_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","অনন্তরং সর্ৱ্ৱাসু নৌসু তীরম্ আনীতাসু তে সর্ৱ্ৱান্ পরিত্যজ্য তস্য পশ্চাদ্গামিনো বভূৱুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","ততঃ পরং যীশৌ কস্মিংশ্চিৎ পুরে তিষ্ঠতি জন একঃ সর্ৱ্ৱাঙ্গকুষ্ঠস্তং ৱিলোক্য তস্য সমীপে ন্যুব্জঃ পতিৎৱা সৱিনযং ৱক্তুমারেভে, হে প্রভো যদি ভৱানিচ্ছতি তর্হি মাং পরিষ্কর্ত্তুং শক্নোতি| ");
INSERT INTO sanben_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","তদানীং স পাণিং প্রসার্য্য তদঙ্গং স্পৃশন্ বভাষে ৎৱং পরিষ্ক্রিযস্ৱেতি মমেচ্ছাস্তি ততস্তৎক্ষণং স কুষ্ঠাৎ মুক্তঃ| ");
INSERT INTO sanben_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","পশ্চাৎ স তমাজ্ঞাপযামাস কথামিমাং কস্মৈচিদ্ অকথযিৎৱা যাজকস্য সমীপঞ্চ গৎৱা স্ৱং দর্শয, লোকেভ্যো নিজপরিষ্কৃতৎৱস্য প্রমাণদানায মূসাজ্ঞানুসারেণ দ্রৱ্যমুত্মৃজস্ৱ চ| ");
INSERT INTO sanben_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","তথাপি যীশোঃ সুখ্যাতি র্বহু ৱ্যাপ্তুমারেভে কিঞ্চ তস্য কথাং শ্রোতুং স্ৱীযরোগেভ্যো মোক্তুঞ্চ লোকা আজগ্মুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","অথ স প্রান্তরং গৎৱা প্রার্থযাঞ্চক্রে| ");
INSERT INTO sanben_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","অপরঞ্চ একদা যীশুরুপদিশতি, এতর্হি গালীল্যিহূদাপ্রদেশযোঃ সর্ৱ্ৱনগরেভ্যো যিরূশালমশ্চ কিযন্তঃ ফিরূশিলোকা ৱ্যৱস্থাপকাশ্চ সমাগত্য তদন্তিকে সমুপৱিৱিশুঃ, তস্মিন্ কালে লোকানামারোগ্যকারণাৎ প্রভোঃ প্রভাৱঃ প্রচকাশে| ");
INSERT INTO sanben_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","পশ্চাৎ কিযন্তো লোকা একং পক্ষাঘাতিনং খট্ৱাযাং নিধায যীশোঃ সমীপমানেতুং সম্মুখে স্থাপযিতুঞ্চ ৱ্যাপ্রিযন্ত| ");
INSERT INTO sanben_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","কিন্তু বহুজননিৱহসম্ৱাধাৎ ন শক্নুৱন্তো গৃহোপরি গৎৱা গৃহপৃষ্ঠং খনিৎৱা তং পক্ষাঘাতিনং সখট্ৱং গৃহমধ্যে যীশোঃ সম্মুখে ঽৱরোহযামাসুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","তদা যীশুস্তেষাম্ ঈদৃশং ৱিশ্ৱাসং ৱিলোক্য তং পক্ষাঘাতিনং ৱ্যাজহার, হে মানৱ তৱ পাপমক্ষম্যত| ");
INSERT INTO sanben_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","তস্মাদ্ অধ্যাপকাঃ ফিরূশিনশ্চ চিত্তৈরিত্থং প্রচিন্তিতৱন্তঃ, এষ জন ঈশ্ৱরং নিন্দতি কোযং? কেৱলমীশ্ৱরং ৱিনা পাপং ক্ষন্তুং কঃ শক্নোতি? ");
INSERT INTO sanben_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","তদা যীশুস্তেষাম্ ইত্থং চিন্তনং ৱিদিৎৱা তেভ্যোকথযদ্ যূযং মনোভিঃ কুতো ৱিতর্কযথ? ");
INSERT INTO sanben_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","তৱ পাপক্ষমা জাতা যদ্ৱা ৎৱমুত্থায ৱ্রজ এতযো র্মধ্যে কা কথা সুকথ্যা? ");
INSERT INTO sanben_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","কিন্তু পৃথিৱ্যাং পাপং ক্ষন্তুং মানৱসুতস্য সামর্থ্যমস্তীতি যথা যূযং জ্ঞাতুং শক্নুথ তদর্থং (স তং পক্ষাঘাতিনং জগাদ) উত্তিষ্ঠ স্ৱশয্যাং গৃহীৎৱা গৃহং যাহীতি ৎৱামাদিশামি| ");
INSERT INTO sanben_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","তস্মাৎ স তৎক্ষণম্ উত্থায সর্ৱ্ৱেষাং সাক্ষাৎ নিজশযনীযং গৃহীৎৱা ঈশ্ৱরং ধন্যং ৱদন্ নিজনিৱেশনং যযৌ| ");
INSERT INTO sanben_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","তস্মাৎ সর্ৱ্ৱে ৱিস্ময প্রাপ্তা মনঃসু ভীতাশ্চ ৱযমদ্যাসম্ভৱকার্য্যাণ্যদর্শাম ইত্যুক্ত্ৱা পরমেশ্ৱরং ধন্যং প্রোদিতাঃ| ");
INSERT INTO sanben_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","ততঃ পরং বহির্গচ্ছন্ করসঞ্চযস্থানে লেৱিনামানং করসঞ্চাযকং দৃষ্ট্ৱা যীশুস্তমভিদধে মম পশ্চাদেহি| ");
INSERT INTO sanben_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","তস্মাৎ স তৎক্ষণাৎ সর্ৱ্ৱং পরিত্যজ্য তস্য পশ্চাদিযায| ");
INSERT INTO sanben_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","অনন্তরং লেৱি র্নিজগৃহে তদর্থং মহাভোজ্যং চকার, তদা তৈঃ সহানেকে করসঞ্চাযিনস্তদন্যলোকাশ্চ ভোক্তুমুপৱিৱিশুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","তস্মাৎ কারণাৎ চণ্ডালানাং পাপিলোকানাঞ্চ সঙ্গে যূযং কুতো ভংগ্ধ্ৱে পিৱথ চেতি কথাং কথযিৎৱা ফিরূশিনোঽধ্যাপকাশ্চ তস্য শিষ্যৈঃ সহ ৱাগ্যুদ্ধং কর্ত্তুমারেভিরে| ");
INSERT INTO sanben_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","তস্মাদ্ যীশুস্তান্ প্রত্যৱোচদ্ অরোগলোকানাং চিকিৎসকেন প্রযোজনং নাস্তি কিন্তু সরোগাণামেৱ| ");
INSERT INTO sanben_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","অহং ধার্ম্মিকান্ আহ্ৱাতুং নাগতোস্মি কিন্তু মনঃ পরাৱর্ত্তযিতুং পাপিন এৱ| ");
INSERT INTO sanben_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","ততস্তে প্রোচুঃ, যোহনঃ ফিরূশিনাঞ্চ শিষ্যা ৱারংৱারম্ উপৱসন্তি প্রার্থযন্তে চ কিন্তু তৱ শিষ্যাঃ কুতো ভুঞ্জতে পিৱন্তি চ? ");
INSERT INTO sanben_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","তদা স তানাচখ্যৌ ৱরে সঙ্গে তিষ্ঠতি ৱরস্য সখিগণং কিমুপৱাসযিতুং শক্নুথ? ");
INSERT INTO sanben_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","কিন্তু যদা তেষাং নিকটাদ্ ৱরো নেষ্যতে তদা তে সমুপৱৎস্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","সোপরমপি দৃষ্টান্তং কথযাম্বভূৱ পুরাতনৱস্ত্রে কোপি নুতনৱস্ত্রং ন সীৱ্যতি যতস্তেন সেৱনেন জীর্ণৱস্ত্রং ছিদ্যতে, নূতনপুরাতনৱস্ত্রযো র্মেলঞ্চ ন ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","পুরাতন্যাং কুৎৱাং কোপি নুতনং দ্রাক্ষারসং ন নিদধাতি, যতো নৱীনদ্রাক্ষারসস্য তেজসা পুরাতনী কুতূ র্ৱিদীর্য্যতে ততো দ্রাক্ষারসঃ পততি কুতূশ্চ নশ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","ততো হেতো র্নূতন্যাং কুৎৱাং নৱীনদ্রাক্ষারসঃ নিধাতৱ্যস্তেনোভযস্য রক্ষা ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","অপরঞ্চ পুরাতনং দ্রাক্ষারসং পীৎৱা কোপি নূতনং ন ৱাঞ্ছতি, যতঃ স ৱক্তি নূতনাৎ পুরাতনম্ প্রশস্তম্| ");
INSERT INTO sanben_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","অচরঞ্চ পর্ৱ্ৱণো দ্ৱিতীযদিনাৎ পরং প্রথমৱিশ্রামৱারে শস্যক্ষেত্রেণ যীশোর্গমনকালে তস্য শিষ্যাঃ কণিশং ছিত্ত্ৱা করেষু মর্দ্দযিৎৱা খাদিতুমারেভিরে| ");
INSERT INTO sanben_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","তস্মাৎ কিযন্তঃ ফিরূশিনস্তানৱদন্ ৱিশ্রামৱারে যৎ কর্ম্ম ন কর্ত্তৱ্যং তৎ কুতঃ কুরুথ? ");
INSERT INTO sanben_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","যীশুঃ প্রত্যুৱাচ দাযূদ্ তস্য সঙ্গিনশ্চ ক্ষুধার্ত্তাঃ কিং চক্রুঃ স কথম্ ঈশ্ৱরস্য মন্দিরং প্রৱিশ্য ");
INSERT INTO sanben_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","যে দর্শনীযাঃ পূপা যাজকান্ ৱিনান্যস্য কস্যাপ্যভোজনীযাস্তানানীয স্ৱযং বুভজে সঙ্গিভ্যোপি দদৌ তৎ কিং যুষ্মাভিঃ কদাপি নাপাঠি? ");
INSERT INTO sanben_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","পশ্চাৎ স তানৱদৎ মনুজসুতো ৱিশ্রামৱারস্যাপি প্রভু র্ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","অনন্তরম্ অন্যৱিশ্রামৱারে স ভজনগেহং প্রৱিশ্য সমুপদিশতি| তদা তৎস্থানে শুষ্কদক্ষিণকর একঃ পুমান্ উপতস্থিৱান্| ");
INSERT INTO sanben_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","তস্মাদ্ অধ্যাপকাঃ ফিরূশিনশ্চ তস্মিন্ দোষমারোপযিতুং স ৱিশ্রামৱারে তস্য স্ৱাস্থ্যং করোতি নৱেতি প্রতীক্ষিতুমারেভিরে| ");
INSERT INTO sanben_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","তদা যীশুস্তেষাং চিন্তাং ৱিদিৎৱা তং শুষ্ককরং পুমাংসং প্রোৱাচ, ৎৱমুত্থায মধ্যস্থানে তিষ্ঠ| ");
INSERT INTO sanben_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","তস্মাৎ তস্মিন্ উত্থিতৱতি যীশুস্তান্ ৱ্যাজহার, যুষ্মান্ ইমাং কথাং পৃচ্ছামি, ৱিশ্রামৱারে হিতম্ অহিতং ৱা, প্রাণরক্ষণং প্রাণনাশনং ৱা, এতেষাং কিং কর্ম্মকরণীযম্? ");
INSERT INTO sanben_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","পশ্চাৎ চতুর্দিক্ষু সর্ৱ্ৱান্ ৱিলোক্য তং মানৱং বভাষে, নিজকরং প্রসারয; ততস্তেন তথা কৃত ইতরকরৱৎ তস্য হস্তঃ স্ৱস্থোভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","তস্মাৎ তে প্রচণ্ডকোপান্ৱিতা যীশুং কিং করিষ্যন্তীতি পরস্পরং প্রমন্ত্রিতাঃ| ");
INSERT INTO sanben_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ততঃ পরং স পর্ৱ্ৱতমারুহ্যেশ্ৱরমুদ্দিশ্য প্রার্থযমানঃ কৃৎস্নাং রাত্রিং যাপিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","অথ দিনে সতি স সর্ৱ্ৱান্ শিষ্যান্ আহূতৱান্ তেষাং মধ্যে ");
INSERT INTO sanben_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","পিতরনাম্না খ্যাতঃ শিমোন্ তস্য ভ্রাতা আন্দ্রিযশ্চ যাকূব্ যোহন্ চ ফিলিপ্ বর্থলমযশ্চ ");
INSERT INTO sanben_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","মথিঃ থোমা আল্ফীযস্য পুত্রো যাকূব্ জ্ৱলন্তনাম্না খ্যাতঃ শিমোন্ ");
INSERT INTO sanben_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","চ যাকূবো ভ্রাতা যিহূদাশ্চ তং যঃ পরকরেষু সমর্পযিষ্যতি স ঈষ্করীযোতীযযিহূদাশ্চৈতান্ দ্ৱাদশ জনান্ মনোনীতান্ কৃৎৱা স জগ্রাহ তথা প্রেরিত ইতি তেষাং নাম চকার| ");
INSERT INTO sanben_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","ততঃ পরং স তৈঃ সহ পর্ৱ্ৱতাদৱরুহ্য উপত্যকাযাং তস্থৌ ততস্তস্য শিষ্যসঙ্ঘো যিহূদাদেশাদ্ যিরূশালমশ্চ সোরঃ সীদোনশ্চ জলধে রোধসো জননিহাশ্চ এত্য তস্য কথাশ্রৱণার্থং রোগমুক্ত্যর্থঞ্চ তস্য সমীপে তস্থুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","অমেধ্যভূতগ্রস্তাশ্চ তন্নিকটমাগত্য স্ৱাস্থ্যং প্রাপুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","সর্ৱ্ৱেষাং স্ৱাস্থ্যকরণপ্রভাৱস্য প্রকাশিতৎৱাৎ সর্ৱ্ৱে লোকা এত্য তং স্প্রষ্টুং যেতিরে| ");
INSERT INTO sanben_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","পশ্চাৎ স শিষ্যান্ প্রতি দৃষ্টিং কুৎৱা জগাদ, হে দরিদ্রা যূযং ধন্যা যত ঈশ্ৱরীযে রাজ্যে ৱোঽধিকারোস্তি| ");
INSERT INTO sanben_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","হে অধুনা ক্ষুধিতলোকা যূযং ধন্যা যতো যূযং তর্প্স্যথ; হে ইহ রোদিনো জনা যূযং ধন্যা যতো যূযং হসিষ্যথ| ");
INSERT INTO sanben_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","যদা লোকা মনুষ্যসূনো র্নামহেতো র্যুষ্মান্ ঋृতীযিষ্যন্তে পৃথক্ কৃৎৱা নিন্দিষ্যন্তি, অধমানিৱ যুষ্মান্ স্ৱসমীপাদ্ দূরীকরিষ্যন্তি চ তদা যূযং ধন্যাঃ| ");
INSERT INTO sanben_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","স্ৱর্গে যুষ্মাকং যথেষ্টং ফলং ভৱিষ্যতি, এতদর্থং তস্মিন্ দিনে প্রোল্লসত আনন্দেন নৃত্যত চ, তেষাং পূর্ৱ্ৱপুরুষাশ্চ ভৱিষ্যদ্ৱাদিনঃ প্রতি তথৈৱ ৱ্যৱাহরন্| ");
INSERT INTO sanben_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","কিন্তু হা হা ধনৱন্তো যূযং সুখং প্রাপ্নুত| হন্ত পরিতৃপ্তা যূযং ক্ষুধিতা ভৱিষ্যথ; ");
INSERT INTO sanben_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ইহ হসন্তো যূযং ৱত যুষ্মাভিঃ শোচিতৱ্যং রোদিতৱ্যঞ্চ| ");
INSERT INTO sanben_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","সর্ৱ্ৱৈলাকৈ র্যুষ্মাকং সুখ্যাতৌ কৃতাযাং যুষ্মাকং দুর্গতি র্ভৱিষ্যতি যুষ্মাকং পূর্ৱ্ৱপুরুষা মৃষাভৱিষ্যদ্ৱাদিনঃ প্রতি তদ্ৱৎ কৃতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","হে শ্রোতারো যুষ্মভ্যমহং কথযামি, যূযং শত্রুষু প্রীযধ্ৱং যে চ যুষ্মান্ দ্ৱিষন্তি তেষামপি হিতং কুরুত| ");
INSERT INTO sanben_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","যে চ যুষ্মান্ শপন্তি তেভ্য আশিষং দত্ত যে চ যুষ্মান্ অৱমন্যন্তে তেষাং মঙ্গলং প্রার্থযধ্ৱং| ");
INSERT INTO sanben_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","যদি কশ্চিৎ তৱ কপোলে চপেটাঘাতং করোতি তর্হি তং প্রতি কপোলম্ অন্যং পরাৱর্ত্ত্য সম্মুখীকুরু পুনশ্চ যদি কশ্চিৎ তৱ গাত্রীযৱস্ত্রং হরতি তর্হি তং পরিধেযৱস্ত্রম্ অপি গ্রহীতুং মা ৱারয| ");
INSERT INTO sanben_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","যস্ত্ৱাং যাচতে তস্মৈ দেহি, যশ্চ তৱ সম্পত্তিং হরতি তং মা যাচস্ৱ| ");
INSERT INTO sanben_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","পরেভ্যঃ স্ৱান্ প্রতি যথাচরণম্ অপেক্ষধ্ৱে পরান্ প্রতি যূযমপি তথাচরত| ");
INSERT INTO sanben_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","যে জনা যুষ্মাসু প্রীযন্তে কেৱলং তেষু প্রীযমাণেষু যুষ্মাকং কিং ফলং? পাপিলোকা অপি স্ৱেষু প্রীযমাণেষু প্রীযন্তে| ");
INSERT INTO sanben_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","যদি হিতকারিণ এৱ হিতং কুরুথ তর্হি যুষ্মাকং কিং ফলং? পাপিলোকা অপি তথা কুর্ৱ্ৱন্তি| ");
INSERT INTO sanben_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","যেভ্য ঋণপরিশোধস্য প্রাপ্তিপ্রত্যাশাস্তে কেৱলং তেষু ঋণে সমর্পিতে যুষ্মাকং কিং ফলং? পুনঃ প্রাপ্ত্যাশযা পাপীলোকা অপি পাপিজনেষু ঋণম্ অর্পযন্তি| ");
INSERT INTO sanben_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","অতো যূযং রিপুষ্ৱপি প্রীযধ্ৱং, পরহিতং কুরুত চ; পুনঃ প্রাপ্ত্যাশাং ত্যক্ত্ৱা ঋণমর্পযত, তথা কৃতে যুষ্মাকং মহাফলং ভৱিষ্যতি, যূযঞ্চ সর্ৱ্ৱপ্রধানস্য সন্তানা ইতি খ্যাতিং প্রাপ্স্যথ, যতো যুষ্মাকং পিতা কৃতঘ্নানাং দুর্ৱ্টত্তানাঞ্চ হিতমাচরতি| ");
INSERT INTO sanben_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","অত এৱ স যথা দযালু র্যূযমপি তাদৃশা দযালৱো ভৱত| ");
INSERT INTO sanben_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","অপরঞ্চ পরান্ দোষিণো মা কুরুত তস্মাদ্ যূযং দোষীকৃতা ন ভৱিষ্যথ; অদণ্ড্যান্ মা দণ্ডযত তস্মাদ্ যূযমপি দণ্ডং ন প্রাপ্স্যথ; পরেষাং দোষান্ ক্ষমধ্ৱং তস্মাদ্ যুষ্মাকমপি দোষাঃ ক্ষমিষ্যন্তে| ");
INSERT INTO sanben_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","দানানিদত্ত তস্মাদ্ যূযং দানানি প্রাপ্স্যথ, ৱরঞ্চ লোকাঃ পরিমাণপাত্রং প্রদলয্য সঞ্চাল্য প্রোঞ্চাল্য পরিপূর্য্য যুষ্মাকং ক্রোডেষু সমর্পযিষ্যন্তি; যূযং যেন পরিমাণেন পরিমাথ তেনৈৱ পরিমাণেন যুষ্মৎকৃতে পরিমাস্যতে| ");
INSERT INTO sanben_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","অথ স তেভ্যো দৃষ্টান্তকথামকথযৎ, অন্ধো জনঃ কিমন্ধং পন্থানং দর্শযিতুং শক্নোতি? তস্মাদ্ উভাৱপি কিং গর্ত্তে ন পতিষ্যতঃ? ");
INSERT INTO sanben_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","গুরোঃ শিষ্যো ন শ্রেষ্ঠঃ কিন্তু শিষ্যে সিদ্ধে সতি স গুরুতুল্যো ভৱিতুং শক্নোতি| ");
INSERT INTO sanben_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","অপরঞ্চ ৎৱং স্ৱচক্ষুुষি নাসাম্ অদৃষ্ট্ৱা তৱ ভ্রাতুশ্চক্ষুষি যত্তৃণমস্তি তদেৱ কুতঃ পশ্যমি? ");
INSERT INTO sanben_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","স্ৱচক্ষুষি যা নাসা ৱিদ্যতে তাম্ অজ্ঞাৎৱা, ভ্রাতস্তৱ নেত্রাৎ তৃণং বহিঃ করোমীতি ৱাক্যং ভ্রাতরং কথং ৱক্তুং শক্নোষি? হে কপটিন্ পূর্ৱ্ৱং স্ৱনযনাৎ নাসাং বহিঃ কুরু ততো ভ্রাতুশ্চক্ষুষস্তৃণং বহিঃ কর্ত্তুং সুদৃষ্টিং প্রাপ্স্যসি| ");
INSERT INTO sanben_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","অন্যঞ্চ উত্তমস্তরুঃ কদাপি ফলমনুত্তমং ন ফলতি, অনুত্তমতরুশ্চ ফলমুত্তমং ন ফলতি কারণাদতঃ ফলৈস্তরৱো জ্ঞাযন্তে| ");
INSERT INTO sanben_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","কণ্টকিপাদপাৎ কোপি উডুম্বরফলানি ন পাতযতি তথা শৃগালকোলিৱৃক্ষাদপি কোপি দ্রাক্ষাফলং ন পাতযতি| ");
INSERT INTO sanben_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","তদ্ৱৎ সাধুলোকোঽন্তঃকরণরূপাৎ সুভাণ্ডাগারাদ্ উত্তমানি দ্রৱ্যাণি বহিঃ করোতি, দুষ্টো লোকশ্চান্তঃকরণরূপাৎ কুভাণ্ডাগারাৎ কুৎসিতানি দ্রৱ্যাণি নির্গমযতি যতোঽন্তঃকরণানাং পূর্ণভাৱানুরূপাণি ৱচাংসি মুখান্নির্গচ্ছন্তি| ");
INSERT INTO sanben_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","অপরঞ্চ মমাজ্ঞানুরূপং নাচরিৎৱা কুতো মাং প্রভো প্রভো ইতি ৱদথ? ");
INSERT INTO sanben_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","যঃ কশ্চিন্ মম নিকটম্ আগত্য মম কথা নিশম্য তদনুরূপং কর্ম্ম করোতি স কস্য সদৃশো ভৱতি তদহং যুষ্মান্ জ্ঞাाপযামি| ");
INSERT INTO sanben_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","যো জনো গভীরং খনিৎৱা পাষাণস্থলে ভিত্তিং নির্ম্মায স্ৱগৃহং রচযতি তেন সহ তস্যোপমা ভৱতি; যত আপ্লাৱিজলমেত্য তস্য মূলে ৱেগেন ৱহদপি তদ্গেহং লাডযিতুং ন শক্নোতি যতস্তস্য ভিত্তিঃ পাষাণোপরি তিষ্ঠতি| ");
INSERT INTO sanben_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","কিন্তু যঃ কশ্চিন্ মম কথাঃ শ্রুৎৱা তদনুরূপং নাচরতি স ভিত্তিং ৱিনা মৃृদুপরি গৃহনির্ম্মাত্রা সমানো ভৱতি; যত আপ্লাৱিজলমাগত্য ৱেগেন যদা ৱহতি তদা তদ্গৃহং পততি তস্য মহৎ পতনং জাযতে| ");
INSERT INTO sanben_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","ততঃ পরং স লোকানাং কর্ণগোচরে তান্ সর্ৱ্ৱান্ উপদেশান্ সমাপ্য যদা কফর্নাহূম্পুরং প্রৱিশতি ");
INSERT INTO sanben_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","তদা শতসেনাপতেঃ প্রিযদাস একো মৃতকল্পঃ পীডিত আসীৎ| ");
INSERT INTO sanben_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","অতঃ সেনাপতি র্যীশো র্ৱার্ত্তাং নিশম্য দাসস্যারোগ্যকরণায তস্যাগমনার্থং ৱিনযকরণায যিহূদীযান্ কিযতঃ প্রাচঃ প্রেষযামাস| ");
INSERT INTO sanben_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","তে যীশোরন্তিকং গৎৱা ৱিনযাতিশযং ৱক্তুমারেভিরে, স সেনাপতি র্ভৱতোনুগ্রহং প্রাপ্তুম্ অর্হতি| ");
INSERT INTO sanben_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","যতঃ সোস্মজ্জাতীযেষু লোকেষু প্রীযতে তথাস্মৎকৃতে ভজনগেহং নির্ম্মিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","তস্মাদ্ যীশুস্তৈঃ সহ গৎৱা নিৱেশনস্য সমীপং প্রাপ, তদা স শতসেনাপতি র্ৱক্ষ্যমাণৱাক্যং তং ৱক্তুং বন্ধূন্ প্রাহিণোৎ| হে প্রভো স্ৱযং শ্রমো ন কর্ত্তৱ্যো যদ্ ভৱতা মদ্গেহমধ্যে পাদার্পণং ক্রিযেত তদপ্যহং নার্হামি, ");
INSERT INTO sanben_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","কিঞ্চাহং ভৱৎসমীপং যাতুমপি নাত্মানং যোগ্যং বুদ্ধৱান্, ততো ভৱান্ ৱাক্যমাত্রং ৱদতু তেনৈৱ মম দাসঃ স্ৱস্থো ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","যস্মাদ্ অহং পরাধীনোপি মমাধীনা যাঃ সেনাঃ সন্তি তাসাম্ একজনং প্রতি যাহীতি মযা প্রোক্তে স যাতি; তদন্যং প্রতি আযাহীতি প্রোক্তে স আযাতি; তথা নিজদাসং প্রতি এতৎ কুর্ৱ্ৱিতি প্রোক্তে স তদেৱ করোতি| ");
INSERT INTO sanben_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","যীশুরিদং ৱাক্যং শ্রুৎৱা ৱিস্মযং যযৌ, মুখং পরাৱর্ত্য পশ্চাদ্ৱর্ত্তিনো লোকান্ বভাষে চ, যুষ্মানহং ৱদামি ইস্রাযেলো ৱংশমধ্যেপি ৱিশ্ৱাসমীদৃশং ন প্রাপ্নৱং| ");
INSERT INTO sanben_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ততস্তে প্রেষিতা গৃহং গৎৱা তং পীডিতং দাসং স্ৱস্থং দদৃশুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","পরেঽহনি স নাযীনাখ্যং নগরং জগাম তস্যানেকে শিষ্যা অন্যে চ লোকাস্তেন সার্দ্ধং যযুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","তেষু তন্নগরস্য দ্ৱারসন্নিধিং প্রাপ্তেষু কিযন্তো লোকা একং মৃতমনুজং ৱহন্তো নগরস্য বহির্যান্তি, স তন্মাতুরেকপুত্রস্তন্মাতা চ ৱিধৱা; তযা সার্দ্ধং তন্নগরীযা বহৱো লোকা আসন্| ");
INSERT INTO sanben_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","প্রভুস্তাং ৱিলোক্য সানুকম্পঃ কথযামাস, মা রোদীঃ| স সমীপমিৎৱা খট্ৱাং পস্পর্শ তস্মাদ্ ৱাহকাঃ স্থগিতাস্তম্যুঃ; ");
INSERT INTO sanben_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","তদা স উৱাচ হে যুৱমনুষ্য ৎৱমুত্তিষ্ঠ, ৎৱামহম্ আজ্ঞাপযামি| ");
INSERT INTO sanben_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","তস্মাৎ স মৃতো জনস্তৎক্ষণমুত্থায কথাং প্রকথিতঃ; ততো যীশুস্তস্য মাতরি তং সমর্পযামাস| ");
INSERT INTO sanben_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","তস্মাৎ সর্ৱ্ৱে লোকাঃ শশঙ্কিরে; একো মহাভৱিষ্যদ্ৱাদী মধ্যেঽস্মাকম্ সমুদৈৎ, ঈশ্ৱরশ্চ স্ৱলোকানন্ৱগৃহ্লাৎ কথামিমাং কথযিৎৱা ঈশ্ৱরং ধন্যং জগদুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ততঃ পরং সমস্তং যিহূদাদেশং তস্য চতুর্দিক্স্থদেশঞ্চ তস্যৈতৎকীর্ত্তি র্ৱ্যানশে| ");
INSERT INTO sanben_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ততঃ পরং যোহনঃ শিষ্যেষু তং তদ্ৱৃত্তান্তং জ্ঞাপিতৱৎসু ");
INSERT INTO sanben_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","স স্ৱশিষ্যাণাং দ্ৱৌ জনাৱাহূয যীশুং প্রতি ৱক্ষ্যমাণং ৱাক্যং ৱক্তুং প্রেষযামাস, যস্যাগমনম্ অপেক্ষ্য তিষ্ঠামো ৱযং কিং স এৱ জনস্ত্ৱং? কিং ৱযমন্যমপেক্ষ্য স্থাস্যামঃ? ");
INSERT INTO sanben_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","পশ্চাত্তৌ মানৱৌ গৎৱা কথযামাসতুঃ, যস্যাগমনম্ অপেক্ষ্য তিষ্ঠামো ৱযং, কিং সএৱ জনস্ত্ৱং? কিং ৱযমন্যমপেক্ষ্য স্থাস্যামঃ? কথামিমাং তুভ্যং কথযিতুং যোহন্ মজ্জক আৱাং প্রেষিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","তস্মিন্ দণ্ডে যীশূরোগিণো মহাৱ্যাধিমতো দুষ্টভূতগ্রস্তাংশ্চ বহূন্ স্ৱস্থান্ কৃৎৱা, অনেকান্ধেভ্যশ্চক্ষুংষি দত্ত্ৱা প্রত্যুৱাচ, ");
INSERT INTO sanben_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","যুৱাং ৱ্রজতম্ অন্ধা নেত্রাণি খঞ্জাশ্চরণানি চ প্রাপ্নুৱন্তি, কুষ্ঠিনঃ পরিষ্ক্রিযন্তে, বধিরাঃ শ্রৱণানি মৃতাশ্চ জীৱনানি প্রাপ্নুৱন্তি, দরিদ্রাণাং সমীপেষু সুসংৱাদঃ প্রচার্য্যতে, যং প্রতি ৱিঘ্নস্ৱরূপোহং ন ভৱামি স ধন্যঃ, ");
INSERT INTO sanben_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","এতানি যানি পশ্যথঃ শৃণুথশ্চ তানি যোহনং জ্ঞাপযতম্| ");
INSERT INTO sanben_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","তযো র্দূতযো র্গতযোঃ সতো র্যোহনি স লোকান্ ৱক্তুমুপচক্রমে, যূযং মধ্যেপ্রান্তরং কিং দ্রষ্টুং নিরগমত? কিং ৱাযুনা কম্পিতং নডং? ");
INSERT INTO sanben_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","যূযং কিং দ্রষ্টুং নিরগমত? কিং সূক্ষ্মৱস্ত্রপরিধাযিনং কমপি নরং? কিন্তু যে সূক্ষ্মমৃদুৱস্ত্রাণি পরিদধতি সূত্তমানি দ্রৱ্যাণি ভুঞ্জতে চ তে রাজধানীষু তিষ্ঠন্তি| ");
INSERT INTO sanben_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","তর্হি যূযং কিং দ্রষ্টুং নিরগমত? কিমেকং ভৱিষ্যদ্ৱাদিনং? তদেৱ সত্যং কিন্তু স পুমান্ ভৱিষ্যদ্ৱাদিনোপি শ্রেষ্ঠ ইত্যহং যুষ্মান্ ৱদামি; ");
INSERT INTO sanben_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","পশ্য স্ৱকীযদূতন্তু তৱাগ্র প্রেষযাম্যহং| গৎৱা ৎৱদীযমার্গন্তু স হি পরিষ্করিষ্যতি| যদর্থে লিপিরিযম্ আস্তে স এৱ যোহন্| ");
INSERT INTO sanben_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","অতো যুষ্মানহং ৱদামি স্ত্রিযা গর্ব্ভজাতানাং ভৱিষ্যদ্ৱাদিনাং মধ্যে যোহনো মজ্জকাৎ শ্রেষ্ঠঃ কোপি নাস্তি, তত্রাপি ঈশ্ৱরস্য রাজ্যে যঃ সর্ৱ্ৱস্মাৎ ক্ষুদ্রঃ স যোহনোপি শ্রেষ্ঠঃ| ");
INSERT INTO sanben_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","অপরঞ্চ সর্ৱ্ৱে লোকাঃ করমঞ্চাযিনশ্চ তস্য ৱাক্যানি শ্রুৎৱা যোহনা মজ্জনেন মজ্জিতাঃ পরমেশ্ৱরং নির্দোষং মেনিরে| ");
INSERT INTO sanben_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","কিন্তু ফিরূশিনো ৱ্যৱস্থাপকাশ্চ তেন ন মজ্জিতাঃ স্ৱান্ প্রতীশ্ৱরস্যোপদেশং নিষ্ফলম্ অকুর্ৱ্ৱন্| ");
INSERT INTO sanben_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","অথ প্রভুঃ কথযামাস, ইদানীন্তনজনান্ কেনোপমামি? তে কস্য সদৃশাঃ? ");
INSERT INTO sanben_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","যে বালকা ৱিপণ্যাম্ উপৱিশ্য পরস্পরম্ আহূয ৱাক্যমিদং ৱদন্তি, ৱযং যুষ্মাকং নিকটে ৱংশীরৱাদিষ্ম, কিন্তু যূযং নানর্ত্তিষ্ট, ৱযং যুষ্মাকং নিকট অরোদিষ্ম, কিন্তু যুযং ন ৱ্যলপিষ্ট, বালকৈরেতাদৃশৈস্তেষাম্ উপমা ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","যতো যোহন্ মজ্জক আগত্য পূপং নাখাদৎ দ্রাক্ষারসঞ্চ নাপিৱৎ তস্মাদ্ যূযং ৱদথ, ভূতগ্রস্তোযম্| ");
INSERT INTO sanben_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","ততঃ পরং মানৱসুত আগত্যাখাদদপিৱঞ্চ তস্মাদ্ যূযং ৱদথ, খাদকঃ সুরাপশ্চাণ্ডালপাপিনাং বন্ধুরেকো জনো দৃশ্যতাম্| ");
INSERT INTO sanben_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","কিন্তু জ্ঞানিনো জ্ঞানং নির্দোষং ৱিদুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","পশ্চাদেকঃ ফিরূশী যীশুং ভোজনায ন্যমন্ত্রযৎ ততঃ স তস্য গৃহং গৎৱা ভোক্তুমুপৱিষ্টঃ| ");
INSERT INTO sanben_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","এতর্হি তৎফিরূশিনো গৃহে যীশু র্ভেক্তুম্ উপাৱেক্ষীৎ তচ্ছ্রুৎৱা তন্নগরৱাসিনী কাপি দুষ্টা নারী পাণ্ডরপ্রস্তরস্য সম্পুটকে সুগন্ধিতৈলম্ আনীয ");
INSERT INTO sanben_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","তস্য পশ্চাৎ পাদযোঃ সন্নিধৌ তস্যৌ রুদতী চ নেত্রাম্বুভিস্তস্য চরণৌ প্রক্ষাল্য নিজকচৈরমার্ক্ষীৎ, ততস্তস্য চরণৌ চুম্বিৎৱা তেন সুগন্ধিতৈলেন মমর্দ| ");
INSERT INTO sanben_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","তস্মাৎ স নিমন্ত্রযিতা ফিরূশী মনসা চিন্তযামাস, যদ্যযং ভৱিষ্যদ্ৱাদী ভৱেৎ তর্হি এনং স্পৃশতি যা স্ত্রী সা কা কীদৃশী চেতি জ্ঞাতুং শক্নুযাৎ যতঃ সা দুষ্টা| ");
INSERT INTO sanben_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","তদা যাশুস্তং জগাদ, হে শিমোন্ ৎৱাং প্রতি মম কিঞ্চিদ্ ৱক্তৱ্যমস্তি; তস্মাৎ স বভাষে, হে গুরো তদ্ ৱদতু| ");
INSERT INTO sanben_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","একোত্তমর্ণস্য দ্ৱাৱধমর্ণাৱাস্তাং, তযোরেকঃ পঞ্চশতানি মুদ্রাপাদান্ অপরশ্চ পঞ্চাশৎ মুদ্রাপাদান্ ধারযামাস| ");
INSERT INTO sanben_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","তদনন্তরং তযোঃ শোধ্যাভাৱাৎ স উত্তমর্ণস্তযো রৃণে চক্ষমে; তস্মাৎ তযোর্দ্ৱযোঃ কস্তস্মিন্ প্রেষ্যতে বহু? তদ্ ব্রূহি| ");
INSERT INTO sanben_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","শিমোন্ প্রত্যুৱাচ, মযা বুধ্যতে যস্যাধিকম্ ঋণং চক্ষমে স ইতি; ততো যীশুস্তং ৱ্যাজহার, ৎৱং যথার্থং ৱ্যচারযঃ| ");
INSERT INTO sanben_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","অথ তাং নারীং প্রতি ৱ্যাঘুঠ্য শিমোনমৱোচৎ, স্ত্রীমিমাং পশ্যসি? তৱ গৃহে ময্যাগতে ৎৱং পাদপ্রক্ষালনার্থং জলং নাদাঃ কিন্তু যোষিদেষা নযনজলৈ র্মম পাদৌ প্রক্ষাল্য কেশৈরমার্ক্ষীৎ| ");
INSERT INTO sanben_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ৎৱং মাং নাচুম্বীঃ কিন্তু যোষিদেষা স্ৱীযাগমনাদারভ্য মদীযপাদৌ চুম্বিতুং ন ৱ্যরংস্ত| ");
INSERT INTO sanben_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ৎৱঞ্চ মদীযোত্তমাঙ্গে কিঞ্চিদপি তৈলং নামর্দীঃ কিন্তু যোষিদেষা মম চরণৌ সুগন্ধিতৈলেনামর্দ্দীৎ| ");
INSERT INTO sanben_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","অতস্ত্ৱাং ৱ্যাহরামি, এতস্যা বহু পাপমক্ষম্যত ততো বহু প্রীযতে কিন্তু যস্যাল্পপাপং ক্ষম্যতে সোল্পং প্রীযতে| ");
INSERT INTO sanben_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ততঃ পরং স তাং বভাষে, ৎৱদীযং পাপমক্ষম্যত| ");
INSERT INTO sanben_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","তদা তেন সার্দ্ধং যে ভোক্তুম্ উপৱিৱিশুস্তে পরস্পরং ৱক্তুমারেভিরে, অযং পাপং ক্ষমতে ক এষঃ? ");
INSERT INTO sanben_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","কিন্তু স তাং নারীং জগাদ, তৱ ৱিশ্ৱাসস্ত্ৱাং পর্য্যত্রাস্ত ৎৱং ক্ষেমেণ ৱ্রজ| ");
INSERT INTO sanben_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","অপরঞ্চ যীশু র্দ্ৱাদশভিঃ শিষ্যৈঃ সার্দ্ধং নানানগরেষু নানাগ্রামেষু চ গচ্ছন্ ইশ্ৱরীযরাজৎৱস্য সুসংৱাদং প্রচারযিতুং প্রারেভে| ");
INSERT INTO sanben_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","তদা যস্যাঃ সপ্ত ভূতা নিরগচ্ছন্ সা মগ্দলীনীতি ৱিখ্যাতা মরিযম্ হেরোদ্রাজস্য গৃহাধিপতেঃ হোষে র্ভার্য্যা যোহনা শূশানা ");
INSERT INTO sanben_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","প্রভৃতযো যা বহ্ৱ্যঃ স্ত্রিযঃ দুষ্টভূতেভ্যো রোগেভ্যশ্চ মুক্তাঃ সত্যো নিজৱিভূতী র্ৱ্যযিৎৱা তমসেৱন্ত, তাঃ সর্ৱ্ৱাস্তেন সার্দ্ধম্ আসন্| ");
INSERT INTO sanben_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","অনন্তরং নানানগরেভ্যো বহৱো লোকা আগত্য তস্য সমীপেঽমিলন্, তদা স তেভ্য একাং দৃষ্টান্তকথাং কথযামাস| একঃ কৃষীবলো বীজানি ৱপ্তুং বহির্জগাম, ");
INSERT INTO sanben_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","ততো ৱপনকালে কতিপযানি বীজানি মার্গপার্শ্ৱে পেতুঃ, ততস্তানি পদতলৈ র্দলিতানি পক্ষিভি র্ভক্ষিতানি চ| ");
INSERT INTO sanben_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","কতিপযানি বীজানি পাষাণস্থলে পতিতানি যদ্যপি তান্যঙ্কুরিতানি তথাপি রসাভাৱাৎ শুশুষুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","কতিপযানি বীজানি কণ্টকিৱনমধ্যে পতিতানি ততঃ কণ্টকিৱনানি সংৱৃদ্ধ্য তানি জগ্রসুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","তদন্যানি কতিপযবীজানি চ ভূম্যামুত্তমাযাং পেতুস্ততস্তান্যঙ্কুরযিৎৱা শতগুণানি ফলানি ফেলুঃ| স ইমা কথাং কথযিৎৱা প্রোচ্চৈঃ প্রোৱাচ, যস্য শ্রোতুং শ্রোত্রে স্তঃ স শৃণোতু| ");
INSERT INTO sanben_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ততঃ পরং শিষ্যাস্তং পপ্রচ্ছুরস্য দৃষ্টান্তস্য কিং তাৎপর্য্যং? ");
INSERT INTO sanben_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ততঃ স ৱ্যাজহার, ঈশ্ৱরীযরাজ্যস্য গুহ্যানি জ্ঞাতুং যুষ্মভ্যমধিকারো দীযতে কিন্ত্ৱন্যে যথা দৃষ্ট্ৱাপি ন পশ্যন্তি শ্রুৎৱাপি ম বুধ্যন্তে চ তদর্থং তেষাং পুরস্তাৎ তাঃ সর্ৱ্ৱাঃ কথা দৃষ্টান্তেন কথ্যন্তে| ");
INSERT INTO sanben_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","দৃষ্টান্তস্যাস্যাভিপ্রাযঃ, ঈশ্ৱরীযকথা বীজস্ৱরূপা| ");
INSERT INTO sanben_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","যে কথামাত্রং শৃণ্ৱন্তি কিন্তু পশ্চাদ্ ৱিশ্ৱস্য যথা পরিত্রাণং ন প্রাপ্নুৱন্তি তদাশযেন শৈতানেত্য হৃদযাতৃ তাং কথাম্ অপহরতি ত এৱ মার্গপার্শ্ৱস্থভূমিস্ৱরূপাঃ| ");
INSERT INTO sanben_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","যে কথং শ্রুৎৱা সানন্দং গৃহ্লন্তি কিন্ত্ৱবদ্ধমূলৎৱাৎ স্ৱল্পকালমাত্রং প্রতীত্য পরীক্ষাকালে ভ্রশ্যন্তি তএৱ পাষাণভূমিস্ৱরূপাঃ| ");
INSERT INTO sanben_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","যে কথাং শ্রুৎৱা যান্তি ৱিষযচিন্তাযাং ধনলোভেন এेহিকসুখে চ মজ্জন্ত উপযুক্তফলানি ন ফলন্তি ত এৱোপ্তবীজকণ্টকিভূস্ৱরূপাঃ| ");
INSERT INTO sanben_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","কিন্তু যে শ্রুৎৱা সরলৈঃ শুদ্ধৈশ্চান্তঃকরণৈঃ কথাং গৃহ্লন্তি ধৈর্য্যম্ অৱলম্ব্য ফলান্যুৎপাদযন্তি চ ত এৱোত্তমমৃৎস্ৱরূপাঃ| ");
INSERT INTO sanben_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","অপরঞ্চ প্রদীপং প্রজ্ৱাল্য কোপি পাত্রেণ নাচ্ছাদযতি তথা খট্ৱাধোপি ন স্থাপযতি, কিন্তু দীপাধারোপর্য্যেৱ স্থাপযতি, তস্মাৎ প্রৱেশকা দীপ্তিং পশ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","যন্ন প্রকাশযিষ্যতে তাদৃগ্ অপ্রকাশিতং ৱস্তু কিমপি নাস্তি যচ্চ ন সুৱ্যক্তং প্রচারযিষ্যতে তাদৃগ্ গৃপ্তং ৱস্তু কিমপি নাস্তি| ");
INSERT INTO sanben_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","অতো যূযং কেন প্রকারেণ শৃণুথ তত্র সাৱধানা ভৱত, যস্য সমীপে বর্দ্ধতে তস্মৈ পুনর্দাস্যতে কিন্তু যস্যাশ্রযে ন বর্দ্ধতে তস্য যদ্যদস্তি তদপি তস্মাৎ নেষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","অপরঞ্চ যীশো র্মাতা ভ্রাতরশ্চ তস্য সমীপং জিগমিষৱঃ ");
INSERT INTO sanben_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","কিন্তু জনতাসম্বাধাৎ তৎসন্নিধিং প্রাপ্তুং ন শেকুঃ| তৎপশ্চাৎ তৱ মাতা ভ্রাতরশ্চ ৎৱাং সাক্ষাৎ চিকীর্ষন্তো বহিস্তিষ্ঠনতীতি ৱার্ত্তাযাং তস্মৈ কথিতাযাং ");
INSERT INTO sanben_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","স প্রত্যুৱাচ; যে জনা ঈশ্ৱরস্য কথাং শ্রুৎৱা তদনুরূপমাচরন্তি তএৱ মম মাতা ভ্রাতরশ্চ| ");
INSERT INTO sanben_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","অনন্তরং একদা যীশুঃ শিষ্যৈঃ সার্দ্ধং নাৱমারুহ্য জগাদ, আযাত ৱযং হ্রদস্য পারং যামঃ, ততস্তে জগ্মুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","তেষু নৌকাং ৱাহযৎসু স নিদদ্রৌ; ");
INSERT INTO sanben_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","অথাকস্মাৎ প্রবলঝঞ্ভ্শগমাদ্ হ্রদে নৌকাযাং তরঙ্গৈরাচ্ছন্নাযাং ৱিপৎ তান্ জগ্রাস| তস্মাদ্ যীশোরন্তিকং গৎৱা হে গুরো হে গুরো প্রাণা নো যান্তীতি গদিৎৱা তং জাগরযাম্বভূৱুঃ| তদা স উত্থায ৱাযুং তরঙ্গাংশ্চ তর্জযামাস তস্মাদুভৌ নিৱৃত্য স্থিরৌ বভূৱতুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","স তান্ বভাষে যুষ্মাকং ৱিশ্ৱাসঃ ক? তস্মাত্তে ভীতা ৱিস্মিতাশ্চ পরস্পরং জগদুঃ, অহো কীদৃগযং মনুজঃ পৱনং পানীযঞ্চাদিশতি তদুভযং তদাদেশং ৱহতি| ");
INSERT INTO sanben_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ততঃ পরং গালীল্প্রদেশস্য সম্মুখস্থগিদেরীযপ্রদেশে নৌকাযাং লগন্ত্যাং তটেঽৱরোহমাৱাদ্ ");
INSERT INTO sanben_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","বহুতিথকালং ভূতগ্রস্ত একো মানুষঃ পুরাদাগত্য তং সাক্ষাচ্চকার| স মনুষো ৱাসো ন পরিদধৎ গৃহে চ ন ৱসন্ কেৱলং শ্মশানম্ অধ্যুৱাস| ");
INSERT INTO sanben_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","স যীশুং দৃষ্ট্ৱৈৱ চীচ্ছব্দং চকার তস্য সম্মুখে পতিৎৱা প্রোচ্চৈর্জগাদ চ, হে সর্ৱ্ৱপ্রধানেশ্ৱরস্য পুত্র, মযা সহ তৱ কঃ সম্বন্ধঃ? ৎৱযি ৱিনযং করোমি মাং মা যাতয| ");
INSERT INTO sanben_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","যতঃ স তং মানুষং ত্যক্ত্ৱা যাতুম্ অমেধ্যভূতম্ আদিদেশ; স ভূতস্তং মানুষম্ অসকৃদ্ দধার তস্মাল্লোকাঃ শৃঙ্খলেন নিগডেন চ ববন্ধুঃ; স তদ্ ভংক্ত্ৱা ভূতৱশৎৱাৎ মধ্যেপ্রান্তরং যযৌ| ");
INSERT INTO sanben_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","অনন্তরং যীশুস্তং পপ্রচ্ছ তৱ কিন্নাম? স উৱাচ, মম নাম বাহিনো যতো বহৱো ভূতাস্তমাশিশ্রিযুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","অথ ভূতা ৱিনযেন জগদুঃ, গভীরং গর্ত্তং গন্তুং মাজ্ঞাপযাস্মান্| ");
INSERT INTO sanben_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","তদা পর্ৱ্ৱতোপরি ৱরাহৱ্রজশ্চরতি তস্মাদ্ ভূতা ৱিনযেন প্রোচুঃ, অমুং ৱরাহৱ্রজম্ আশ্রযিতুম্ অস্মান্ অনুজানীহি; ততঃ সোনুজজ্ঞৌ| ");
INSERT INTO sanben_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ততঃ পরং ভূতাস্তং মানুষং ৱিহায ৱরাহৱ্রজম্ আশিশ্রিযুঃ ৱরাহৱ্রজাশ্চ তৎক্ষণাৎ কটকেন ধাৱন্তো হ্রদে প্রাণান্ ৱিজৃহুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","তদ্ দৃষ্ট্ৱা শূকররক্ষকাঃ পলাযমানা নগরং গ্রামঞ্চ গৎৱা তৎসর্ৱ্ৱৱৃত্তান্তং কথযামাসুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","ততঃ কিং ৱৃত্তম্ এতদ্দর্শনার্থং লোকা নির্গত্য যীশোঃ সমীপং যযুঃ, তং মানুষং ত্যক্তভূতং পরিহিতৱস্ত্রং স্ৱস্থমানুষৱদ্ যীশোশ্চরণসন্নিধৌ সূপৱিশন্তং ৱিলোক্য বিভ্যুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","যে লোকাস্তস্য ভূতগ্রস্তস্য স্ৱাস্থ্যকরণং দদৃশুস্তে তেভ্যঃ সর্ৱ্ৱৱৃত্তান্তং কথযামাসুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","তদনন্তরং তস্য গিদেরীযপ্রদেশস্য চতুর্দিক্স্থা বহৱো জনা অতিত্রস্তা ৱিনযেন তং জগদুঃ, ভৱান্ অস্মাকং নিকটাদ্ ৱ্রজতু তস্মাৎ স নাৱমারুহ্য ততো ৱ্যাঘুট্য জগাম| ");
INSERT INTO sanben_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","তদানীং ত্যক্তভূতমনুজস্তেন সহ স্থাতুং প্রার্থযাঞ্চক্রে ");
INSERT INTO sanben_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","কিন্তু তদর্থম্ ঈশ্ৱরঃ কীদৃঙ্মহাকর্ম্ম কৃতৱান্ ইতি নিৱেশনং গৎৱা ৱিজ্ঞাপয, যীশুঃ কথামেতাং কথযিৎৱা তং ৱিসসর্জ| ততঃ স ৱ্রজিৎৱা যীশুস্তদর্থং যন্মহাকর্ম্ম চকার তৎ পুরস্য সর্ৱ্ৱত্র প্রকাশযিতুং প্রারেভে| ");
INSERT INTO sanben_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","অথ যীশৌ পরাৱৃত্যাগতে লোকাস্তং আদরেণ জগৃহু র্যস্মাত্তে সর্ৱ্ৱে তমপেক্ষাঞ্চক্রিরে| ");
INSERT INTO sanben_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","তদনন্তরং যাযীর্নাম্নো ভজনগেহস্যৈকোধিপ আগত্য যীশোশ্চরণযোঃ পতিৎৱা স্ৱনিৱেশনাগমনার্থং তস্মিন্ ৱিনযং চকার, ");
INSERT INTO sanben_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","যতস্তস্য দ্ৱাদশৱর্ষৱযস্কা কন্যৈকাসীৎ সা মৃতকল্পাভৱৎ| ততস্তস্য গমনকালে মার্গে লোকানাং মহান্ সমাগমো বভূৱ| ");
INSERT INTO sanben_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","দ্ৱাদশৱর্ষাণি প্রদররোগগ্রস্তা নানা ৱৈদ্যৈশ্চিকিৎসিতা সর্ৱ্ৱস্ৱং ৱ্যযিৎৱাপি স্ৱাস্থ্যং ন প্রাপ্তা যা যোষিৎ সা যীশোঃ পশ্চাদাগত্য তস্য ৱস্ত্রগ্রন্থিং পস্পর্শ| ");
INSERT INTO sanben_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","তস্মাৎ তৎক্ষণাৎ তস্যা রক্তস্রাৱো রুদ্ধঃ| ");
INSERT INTO sanben_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","তদানীং যীশুরৱদৎ কেনাহং স্পৃষ্টঃ? ততোঽনেকৈরনঙ্গীকৃতে পিতরস্তস্য সঙ্গিনশ্চাৱদন্, হে গুরো লোকা নিকটস্থাঃ সন্তস্তৱ দেহে ঘর্ষযন্তি, তথাপি কেনাহং স্পৃষ্টইতি ভৱান্ কুতঃ পৃচ্ছতি? ");
INSERT INTO sanben_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","যীশুঃ কথযামাস, কেনাপ্যহং স্পৃষ্টো, যতো মত্তঃ শক্তি র্নির্গতেতি মযা নিশ্চিতমজ্ঞাযি| ");
INSERT INTO sanben_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","তদা সা নারী স্ৱযং ন গুপ্তেতি ৱিদিৎৱা কম্পমানা সতী তস্য সম্মুখে পপাত; যেন নিমিত্তেন তং পস্পর্শ স্পর্শমাত্রাচ্চ যেন প্রকারেণ স্ৱস্থাভৱৎ তৎ সর্ৱ্ৱং তস্য সাক্ষাদাচখ্যৌ| ");
INSERT INTO sanben_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ততঃ স তাং জগাদ হে কন্যে সুস্থিরা ভৱ, তৱ ৱিশ্ৱাসস্ত্ৱাং স্ৱস্থাম্ অকার্ষীৎ ৎৱং ক্ষেমেণ যাহি| ");
INSERT INTO sanben_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","যীশোরেতদ্ৱাক্যৱদনকালে তস্যাধিপতে র্নিৱেশনাৎ কশ্চিল্লোক আগত্য তং বভাষে, তৱ কন্যা মৃতা গুরুং মা ক্লিশান| ");
INSERT INTO sanben_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","কিন্তু যীশুস্তদাকর্ণ্যাধিপতিং ৱ্যাজহার, মা ভৈষীঃ কেৱলং ৱিশ্ৱসিহি তস্মাৎ সা জীৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","অথ তস্য নিৱেশনে প্রাপ্তে স পিতরং যোহনং যাকূবঞ্চ কন্যাযা মাতরং পিতরঞ্চ ৱিনা, অন্যং কঞ্চন প্রৱেষ্টুং ৱারযামাস| ");
INSERT INTO sanben_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","অপরঞ্চ যে রুদন্তি ৱিলপন্তি চ তান্ সর্ৱ্ৱান্ জনান্ উৱাচ, যূযং মা রোদিষ্ট কন্যা ন মৃতা নিদ্রাতি| ");
INSERT INTO sanben_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","কিন্তু সা নিশ্চিতং মৃতেতি জ্ঞাৎৱা তে তমুপজহসুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","পশ্চাৎ স সর্ৱ্ৱান্ বহিঃ কৃৎৱা কন্যাযাঃ করৌ ধৃৎৱাজুহুৱে, হে কন্যে ৎৱমুত্তিষ্ঠ, ");
INSERT INTO sanben_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","তস্মাৎ তস্যাঃ প্রাণেষু পুনরাগতেষু সা তৎক্ষণাদ্ উত্তস্যৌ| তদানীং তস্যৈ কিঞ্চিদ্ ভক্ষ্যং দাতুম্ আদিদেশ| ");
INSERT INTO sanben_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ততস্তস্যাঃ পিতরৌ ৱিস্মযং গতৌ কিন্তু স তাৱাদিদেশ ঘটনাযা এতস্যাঃ কথাং কস্মৈচিদপি মা কথযতং| ");
INSERT INTO sanben_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","ততঃ পরং স দ্ৱাদশশিষ্যানাহূয ভূতান্ ত্যাজযিতুং রোগান্ প্রতিকর্ত্তুঞ্চ তেভ্যঃ শক্তিমাধিপত্যঞ্চ দদৌ| ");
INSERT INTO sanben_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","অপরঞ্চ ঈশ্ৱরীযরাজ্যস্য সুসংৱাদং প্রকাশযিতুম্ রোগিণামারোগ্যং কর্ত্তুঞ্চ প্রেরণকালে তান্ জগাদ| ");
INSERT INTO sanben_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","যাত্রার্থং যষ্টি র্ৱস্ত্রপুটকং ভক্ষ্যং মুদ্রা দ্ৱিতীযৱস্ত্রম্, এষাং কিমপি মা গৃহ্লীত| ");
INSERT INTO sanben_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","যূযঞ্চ যন্নিৱেশনং প্রৱিশথ নগরত্যাগপর্য্যনতং তন্নিৱেশনে তিষ্ঠত| ");
INSERT INTO sanben_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","তত্র যদি কস্যচিৎ পুরস্য লোকা যুষ্মাকমাতিথ্যং ন কুর্ৱ্ৱন্তি তর্হি তস্মান্নগরাদ্ গমনকালে তেষাং ৱিরুদ্ধং সাক্ষ্যার্থং যুষ্মাকং পদধূলীঃ সম্পাতযত| ");
INSERT INTO sanben_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","অথ তে প্রস্থায সর্ৱ্ৱত্র সুসংৱাদং প্রচারযিতুং পীডিতান্ স্ৱস্থান্ কর্ত্তুঞ্চ গ্রামেষু ভ্রমিতুং প্রারেভিরে| ");
INSERT INTO sanben_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","এতর্হি হেরোদ্ রাজা যীশোঃ সর্ৱ্ৱকর্ম্মণাং ৱার্ত্তাং শ্রুৎৱা ভৃশমুদ্ৱিৱিজে ");
INSERT INTO sanben_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","যতঃ কেচিদূচুর্যোহন্ শ্মশানাদুদতিষ্ঠৎ| কেচিদূচুঃ, এলিযো দর্শনং দত্তৱান্; এৱমন্যলোকা ঊচুঃ পূর্ৱ্ৱীযঃ কশ্চিদ্ ভৱিষ্যদ্ৱাদী সমুত্থিতঃ| ");
INSERT INTO sanben_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","কিন্তু হেরোদুৱাচ যোহনঃ শিরোঽহমছিনদম্ ইদানীং যস্যেদৃক্কর্ম্মণাং ৱার্ত্তাং প্রাপ্নোমি স কঃ? অথ স তং দ্রষ্টুম্ ঐচ্ছৎ| ");
INSERT INTO sanben_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","অনন্তরং প্রেরিতাঃ প্রত্যাগত্য যানি যানি কর্ম্মাণি চক্রুস্তানি যীশৱে কথযামাসুঃ ততঃ স তান্ বৈৎসৈদানামকনগরস্য ৱিজনং স্থানং নীৎৱা গুপ্তং জগাম| ");
INSERT INTO sanben_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","পশ্চাল্ লোকাস্তদ্ ৱিদিৎৱা তস্য পশ্চাদ্ যযুঃ; ততঃ স তান্ নযন্ ঈশ্ৱরীযরাজ্যস্য প্রসঙ্গমুক্তৱান্, যেষাং চিকিৎসযা প্রযোজনম্ আসীৎ তান্ স্ৱস্থান্ চকার চ| ");
INSERT INTO sanben_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","অপরঞ্চ দিৱাৱসন্নে সতি দ্ৱাদশশিষ্যা যীশোরন্তিকম্ এত্য কথযামাসুঃ, ৱযমত্র প্রান্তরস্থানে তিষ্ঠামঃ, ততো নগরাণি গ্রামাণি গৎৱা ৱাসস্থানানি প্রাপ্য ভক্ষ্যদ্রৱ্যাণি ক্রেতুং জননিৱহং ভৱান্ ৱিসৃজতু| ");
INSERT INTO sanben_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","তদা স উৱাচ, যূযমেৱ তান্ ভেজযধ্ৱং; ততস্তে প্রোচুরস্মাকং নিকটে কেৱলং পঞ্চ পূপা দ্ৱৌ মৎস্যৌ চ ৱিদ্যন্তে, অতএৱ স্থানান্তরম্ ইৎৱা নিমিত্তমেতেষাং ভক্ষ্যদ্রৱ্যেষু ন ক্রীতেষু ন ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","তত্র প্রাযেণ পঞ্চসহস্রাণি পুরুষা আসন্| ");
INSERT INTO sanben_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","তদা স শিষ্যান্ জগাদ পঞ্চাশৎ পঞ্চাশজ্জনৈঃ পংক্তীকৃত্য তানুপৱেশযত, তস্মাৎ তে তদনুসারেণ সর্ৱ্ৱলোকানুপৱেশযাপাসুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ততঃ স তান্ পঞ্চ পূপান্ মীনদ্ৱযঞ্চ গৃহীৎৱা স্ৱর্গং ৱিলোক্যেশ্ৱরগুণান্ কীর্ত্তযাঞ্চক্রে ভঙ্ক্তা চ লোকেভ্যঃ পরিৱেষণার্থং শিষ্যেষু সমর্পযাম্বভূৱ| ");
INSERT INTO sanben_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ততঃ সর্ৱ্ৱে ভুক্ত্ৱা তৃপ্তিং গতা অৱশিষ্টানাঞ্চ দ্ৱাদশ ডল্লকান্ সংজগৃহুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","অথৈকদা নির্জনে শিষ্যৈঃ সহ প্রার্থনাকালে তান্ পপ্রচ্ছ, লোকা মাং কং ৱদন্তি? ");
INSERT INTO sanben_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","ততস্তে প্রাচুঃ, ৎৱাং যোহন্মজ্জকং ৱদন্তি; কেচিৎ ৎৱাম্ এলিযং ৱদন্তি, পূর্ৱ্ৱকালিকঃ কশ্চিদ্ ভৱিষ্যদ্ৱাদী শ্মশানাদ্ উদতিষ্ঠদ্ ইত্যপি কেচিদ্ ৱদন্তি| ");
INSERT INTO sanben_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","তদা স উৱাচ, যূযং মাং কং ৱদথ? ততঃ পিতর উক্তৱান্ ৎৱম্ ঈশ্ৱরাভিষিক্তঃ পুরুষঃ| ");
INSERT INTO sanben_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","তদা স তান্ দৃঢমাদিদেশ, কথামেতাং কস্মৈচিদপি মা কথযত| ");
INSERT INTO sanben_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","স পুনরুৱাচ, মনুষ্যপুত্রেণ ৱহুযাতনা ভোক্তৱ্যাঃ প্রাচীনলোকৈঃ প্রধানযাজকৈরধ্যাপকৈশ্চ সোৱজ্ঞায হন্তৱ্যঃ কিন্তু তৃতীযদিৱসে শ্মশানাৎ তেনোত্থাতৱ্যম্| ");
INSERT INTO sanben_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","অপরং স সর্ৱ্ৱানুৱাচ, কশ্চিদ্ যদি মম পশ্চাদ্ গন্তুং ৱাঞ্ছতি তর্হি স স্ৱং দাম্যতু, দিনে দিনে ক্রুশং গৃহীৎৱা চ মম পশ্চাদাগচ্ছতু| ");
INSERT INTO sanben_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","যতো যঃ কশ্চিৎ স্ৱপ্রাণান্ রিরক্ষিষতি স তান্ হারযিষ্যতি, যঃ কশ্চিন্ মদর্থং প্রাণান্ হারযিষ্যতি স তান্ রক্ষিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","কশ্চিদ্ যদি সর্ৱ্ৱং জগৎ প্রাপ্নোতি কিন্তু স্ৱপ্রাণান্ হারযতি স্ৱযং ৱিনশ্যতি চ তর্হি তস্য কো লাভঃ? ");
INSERT INTO sanben_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","পুন র্যঃ কশ্চিন্ মাং মম ৱাক্যং ৱা লজ্জাস্পদং জানাতি মনুষ্যপুত্রো যদা স্ৱস্য পিতুশ্চ পৱিত্রাণাং দূতানাঞ্চ তেজোভিঃ পরিৱেষ্টিত আগমিষ্যতি তদা সোপি তং লজ্জাস্পদং জ্ঞাস্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","কিন্তু যুষ্মানহং যথার্থং ৱদামি, ঈশ্ৱরীযরাজৎৱং ন দৃষ্টৱা মৃত্যুং নাস্ৱাদিষ্যন্তে, এতাদৃশাঃ কিযন্তো লোকা অত্র স্থনেঽপি দণ্ডাযমানাঃ সন্তি| ");
INSERT INTO sanben_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","এতদাখ্যানকথনাৎ পরং প্রাযেণাষ্টসু দিনেষু গতেষু স পিতরং যোহনং যাকূবঞ্চ গৃহীৎৱা প্রার্থযিতুং পর্ৱ্ৱতমেকং সমারুরোহ| ");
INSERT INTO sanben_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","অথ তস্য প্রার্থনকালে তস্য মুখাকৃতিরন্যরূপা জাতা, তদীযং ৱস্ত্রমুজ্জ্ৱলশুক্লং জাতং| ");
INSERT INTO sanben_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","অপরঞ্চ মূসা এলিযশ্চোভৌ তেজস্ৱিনৌ দৃষ্টৌ ");
INSERT INTO sanben_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","তৌ তেন যিরূশালম্পুরে যো মৃত্যুঃ সাধিষ্যতে তদীযাং কথাং তেন সার্দ্ধং কথযিতুম্ আরেভাতে| ");
INSERT INTO sanben_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","তদা পিতরাদযঃ স্ৱস্য সঙ্গিনো নিদ্রযাকৃষ্টা আসন্ কিন্তু জাগরিৎৱা তস্য তেজস্তেন সার্দ্ধম্ উত্তিষ্ঠন্তৌ জনৌ চ দদৃশুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","অথ তযোরুভযো র্গমনকালে পিতরো যীশুং বভাষে, হে গুরোঽস্মাকং স্থানেঽস্মিন্ স্থিতিঃ শুভা, তত একা ৎৱদর্থা, একা মূসার্থা, একা এলিযার্থা, ইতি তিস্রঃ কুট্যোস্মাভি র্নির্ম্মীযন্তাং, ইমাং কথাং স ন ৱিৱিচ্য কথযামাস| ");
INSERT INTO sanben_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","অপরঞ্চ তদ্ৱাক্যৱদনকালে পযোদ এক আগত্য তেষামুপরি ছাযাং চকার, ততস্তন্মধ্যে তযোঃ প্রৱেশাৎ তে শশঙ্কিরে| ");
INSERT INTO sanben_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","তদা তস্মাৎ পযোদাদ্ ইযমাকাশীযা ৱাণী নির্জগাম, মমাযং প্রিযঃ পুত্র এতস্য কথাযাং মনো নিধত্ত| ");
INSERT INTO sanben_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ইতি শব্দে জাতে তে যীশুমেকাকিনং দদৃশুঃ কিন্তু তে তদানীং তস্য দর্শনস্য ৱাচমেকামপি নোক্ত্ৱা মনঃসু স্থাপযামাসুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","পরেঽহনি তেষু তস্মাচ্ছৈলাদ্ অৱরূঢেষু তং সাক্ষাৎ কর্ত্তুং বহৱো লোকা আজগ্মুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","তেষাং মধ্যাদ্ একো জন উচ্চৈরুৱাচ, হে গুরো অহং ৱিনযং করোমি মম পুত্রং প্রতি কৃপাদৃষ্টিং করোতু, মম স এৱৈকঃ পুত্রঃ| ");
INSERT INTO sanben_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ভূতেন ধৃতঃ সন্ সং প্রসভং চীচ্ছব্দং করোতি তন্মুখাৎ ফেণা নির্গচ্ছন্তি চ, ভূত ইত্থং ৱিদার্য্য ক্লিষ্ট্ৱা প্রাযশস্তং ন ত্যজতি| ");
INSERT INTO sanben_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","তস্মাৎ তং ভূতং ত্যাজযিতুং তৱ শিষ্যসমীপে ন্যৱেদযং কিন্তু তে ন শেকুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","তদা যীশুরৱাদীৎ, রে আৱিশ্ৱাসিন্ ৱিপথগামিন্ ৱংশ কতিকালান্ যুষ্মাভিঃ সহ স্থাস্যাম্যহং যুষ্মাকম্ আচরণানি চ সহিষ্যে? তৱ পুত্রমিহানয| ");
INSERT INTO sanben_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ততস্তস্মিন্নাগতমাত্রে ভূতস্তং ভূমৌ পাতযিৎৱা ৱিদদার; তদা যীশুস্তমমেধ্যং ভূতং তর্জযিৎৱা বালকং স্ৱস্থং কৃৎৱা তস্য পিতরি সমর্পযামাস| ");
INSERT INTO sanben_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ঈশ্ৱরস্য মহাশক্তিম্ ইমাং ৱিলোক্য সর্ৱ্ৱে চমচ্চক্রুঃ; ইত্থং যীশোঃ সর্ৱ্ৱাভিঃ ক্রিযাভিঃ সর্ৱ্ৱৈর্লোকৈরাশ্চর্য্যে মন্যমানে সতি স শিষ্যান্ বভাষে, ");
INSERT INTO sanben_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","কথেযং যুষ্মাকং কর্ণেষু প্রৱিশতু, মনুষ্যপুত্রো মনুষ্যাণাং করেষু সমর্পযিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","কিন্তু তে তাং কথাং ন বুবুধিরে, স্পষ্টৎৱাভাৱাৎ তস্যা অভিপ্রাযস্তেষাং বোধগম্যো ন বভূৱ; তস্যা আশযঃ ক ইত্যপি তে ভযাৎ প্রষ্টুং ন শেকুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","তদনন্তরং তেষাং মধ্যে কঃ শ্রেষ্ঠঃ কথামেতাং গৃহীৎৱা তে মিথো ৱিৱাদং চক্রুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ততো যীশুস্তেষাং মনোভিপ্রাযং ৱিদিৎৱা বালকমেকং গৃহীৎৱা স্ৱস্য নিকটে স্থাপযিৎৱা তান্ জগাদ, ");
INSERT INTO sanben_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","যো জনো মম নাম্নাস্য বালাস্যাতিথ্যং ৱিদধাতি স মমাতিথ্যং ৱিদধাতি, যশ্চ মমাতিথ্যং ৱিদধাতি স মম প্রেরকস্যাতিথ্যং ৱিদধাতি, যুষ্মাকং মধ্যেযঃ স্ৱং সর্ৱ্ৱস্মাৎ ক্ষুদ্রং জানীতে স এৱ শ্রেষ্ঠো ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","অপরঞ্চ যোহন্ ৱ্যাজহার হে প্রভেा তৱ নাম্না ভূতান্ ত্যাজযন্তং মানুষম্ একং দৃষ্টৱন্তো ৱযং, কিন্ত্ৱস্মাকম্ অপশ্চাদ্ গামিৎৱাৎ তং ন্যষেধাম্| তদানীং যীশুরুৱাচ, ");
INSERT INTO sanben_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","তং মা নিষেধত, যতো যো জনোস্মাকং ন ৱিপক্ষঃ স এৱাস্মাকং সপক্ষো ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","অনন্তরং তস্যারোহণসময উপস্থিতে স স্থিরচেতা যিরূশালমং প্রতি যাত্রাং কর্ত্তুং নিশ্চিত্যাগ্রে দূতান্ প্রেষযামাস| ");
INSERT INTO sanben_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","তস্মাৎ তে গৎৱা তস্য প্রযোজনীযদ্রৱ্যাণি সংগ্রহীতুং শোমিরোণীযানাং গ্রামং প্রৱিৱিশুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","কিন্তু স যিরূশালমং নগরং যাতি ততো হেতো র্লোকাস্তস্যাতিথ্যং ন চক্রুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","অতএৱ যাকূব্যোহনৌ তস্য শিষ্যৌ তদ্ দৃষ্ট্ৱা জগদতুঃ, হে প্রভো এলিযো যথা চকার তথা ৱযমপি কিং গগণাদ্ আগন্তুম্ এতান্ ভস্মীকর্ত্তুঞ্চ ৱহ্নিমাজ্ঞাপযামঃ? ভৱান্ কিমিচ্ছতি? ");
INSERT INTO sanben_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","কিন্তু স মুখং পরাৱর্ত্য তান্ তর্জযিৎৱা গদিতৱান্ যুষ্মাকং মনোভাৱঃ কঃ, ইতি যূযং ন জানীথ| ");
INSERT INTO sanben_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","মনুজসুতো মনুজানাং প্রাণান্ নাশযিতুং নাগচ্ছৎ, কিন্তু রক্ষিতুম্ আগচ্ছৎ| পশ্চাদ্ ইতরগ্রামং তে যযুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","তদনন্তরং পথি গমনকালে জন একস্তং বভাষে, হে প্রভো ভৱান্ যত্র যাতি ভৱতা সহাহমপি তত্র যাস্যামি| ");
INSERT INTO sanben_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","তদানীং যীশুস্তমুৱাচ, গোমাযূনাং গর্ত্তা আসতে, ৱিহাযসীযৱিহগাाনাং নীডানি চ সন্তি, কিন্তু মানৱতনযস্য শিরঃ স্থাপযিতুং স্থানং নাস্তি| ");
INSERT INTO sanben_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ততঃ পরং স ইতরজনং জগাদ, ৎৱং মম পশ্চাদ্ এহি; ততঃ স উৱাচ, হে প্রভো পূর্ৱ্ৱং পিতরং শ্মশানে স্থাপযিতুং মামাদিশতু| ");
INSERT INTO sanben_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","তদা যীশুরুৱাচ, মৃতা মৃতান্ শ্মশানে স্থাপযন্তু কিন্তু ৎৱং গৎৱেশ্ৱরীযরাজ্যস্য কথাং প্রচারয| ");
INSERT INTO sanben_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ততোন্যঃ কথযামাস, হে প্রভো মযাপি ভৱতঃ পশ্চাদ্ গংস্যতে, কিন্তু পূর্ৱ্ৱং মম নিৱেশনস্য পরিজনানাম্ অনুমতিং গ্রহীতুম্ অহমাদিশ্যৈ ভৱতা| ");
INSERT INTO sanben_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","তদানীং যীশুস্তং প্রোক্তৱান্, যো জনো লাঙ্গলে করমর্পযিৎৱা পশ্চাৎ পশ্যতি স ঈশ্ৱরীযরাজ্যং নার্হতি| ");
INSERT INTO sanben_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ততঃ পরং প্রভুরপরান্ সপ্ততিশিষ্যান্ নিযুজ্য স্ৱযং যানি নগরাণি যানি স্থানানি চ গমিষ্যতি তানি নগরাণি তানি স্থানানি চ প্রতি দ্ৱৌ দ্ৱৌ জনৌ প্রহিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","তেভ্যঃ কথযামাস চ শস্যানি বহূনীতি সত্যং কিন্তু ছেদকা অল্পে; তস্মাদ্ধেতোঃ শস্যক্ষেত্রে ছেদকান্ অপরানপি প্রেষযিতুং ক্ষেত্রস্ৱামিনং প্রার্থযধ্ৱং| ");
INSERT INTO sanben_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","যূযং যাত, পশ্যত, ৱৃকাণাং মধ্যে মেষশাৱকানিৱ যুষ্মান্ প্রহিণোমি| ");
INSERT INTO sanben_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","যূযং ক্ষুদ্রং মহদ্ ৱা ৱসনসম্পুটকং পাদুকাশ্চ মা গৃহ্লীত, মার্গমধ্যে কমপি মা নমত চ| ");
INSERT INTO sanben_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","অপরঞ্চ যূযং যদ্ যৎ নিৱেশনং প্রৱিশথ তত্র নিৱেশনস্যাস্য মঙ্গলং ভূযাদিতি ৱাক্যং প্রথমং ৱদত| ");
INSERT INTO sanben_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","তস্মাৎ তস্মিন্ নিৱেশনে যদি মঙ্গলপাত্রং স্থাস্যতি তর্হি তন্মঙ্গলং তস্য ভৱিষ্যতি, নোচেৎ যুষ্মান্ প্রতি পরাৱর্ত্তিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","অপরঞ্চ তে যৎকিঞ্চিদ্ দাস্যন্তি তদেৱ ভুক্ত্ৱা পীৎৱা তস্মিন্নিৱেশনে স্থাস্যথ; যতঃ কর্ম্মকারী জনো ভৃতিম্ অর্হতি; গৃহাদ্ গৃহং মা যাস্যথ| ");
INSERT INTO sanben_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","অন্যচ্চ যুষ্মাসু কিমপি নগরং প্রৱিষ্টেষু লোকা যদি যুষ্মাকম্ আতিথ্যং করিষ্যন্তি, তর্হি যৎ খাদ্যম্ উপস্থাস্যন্তি তদেৱ খাদিষ্যথ| ");
INSERT INTO sanben_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","তন্নগরস্থান্ রোগিণঃ স্ৱস্থান্ করিষ্যথ, ঈশ্ৱরীযং রাজ্যং যুষ্মাকম্ অন্তিকম্ আগমৎ কথামেতাঞ্চ প্রচারযিষ্যথ| ");
INSERT INTO sanben_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","কিন্তু কিমপি পুরং যুষ্মাসু প্রৱিষ্টেষু লোকা যদি যুষ্মাকম্ আতিথ্যং ন করিষ্যন্তি, তর্হি তস্য নগরস্য পন্থানং গৎৱা কথামেতাং ৱদিষ্যথ, ");
INSERT INTO sanben_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","যুষ্মাকং নগরীযা যা ধূল্যোঽস্মাসু সমলগন্ তা অপি যুষ্মাকং প্রাতিকূল্যেন সাক্ষ্যার্থং সম্পাতযামঃ; তথাপীশ্ৱররাজ্যং যুষ্মাকং সমীপম্ আগতম্ ইতি নিশ্চিতং জানীত| ");
INSERT INTO sanben_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","অহং যুষ্মভ্যং যথার্থং কথযামি, ৱিচারদিনে তস্য নগরস্য দশাতঃ সিদোমো দশা সহ্যা ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","হা হা কোরাসীন্ নগর, হা হা বৈৎসৈদানগর যুৱযোর্মধ্যে যাদৃশানি আশ্চর্য্যাণি কর্ম্মাণ্যক্রিযন্ত, তানি কর্ম্মাণি যদি সোরসীদোনো র্নগরযোরকারিষ্যন্ত, তদা ইতো বহুদিনপূর্ৱ্ৱং তন্নিৱাসিনঃ শণৱস্ত্রাণি পরিধায গাত্রেষু ভস্ম ৱিলিপ্য সমুপৱিশ্য সমখেৎস্যন্ত| ");
INSERT INTO sanben_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","অতো ৱিচারদিৱসে যুষ্মাকং দশাতঃ সোরসীদোন্নিৱাসিনাং দশা সহ্যা ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","হে কফর্নাহূম্, ৎৱং স্ৱর্গং যাৱদ্ উন্নতা কিন্তু নরকং যাৱৎ ন্যগ্ভৱিষ্যসি| ");
INSERT INTO sanben_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","যো জনো যুষ্মাকং ৱাক্যং গৃহ্লাতি স মমৈৱ ৱাক্যং গৃহ্লাতি; কিঞ্চ যো জনো যুষ্মাকম্ অৱজ্ঞাং করোতি স মমৈৱাৱজ্ঞাং করোতি; যো জনো মমাৱজ্ঞাং করোতি চ স মৎপ্রেরকস্যৈৱাৱজ্ঞাং করোতি| ");
INSERT INTO sanben_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","অথ তে সপ্ততিশিষ্যা আনন্দেন প্রত্যাগত্য কথযামাসুঃ, হে প্রভো ভৱতো নাম্না ভূতা অপ্যস্মাকং ৱশীভৱন্তি| ");
INSERT INTO sanben_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","তদানীং স তান্ জগাদ, ৱিদ্যুতমিৱ স্ৱর্গাৎ পতন্তং শৈতানম্ অদর্শম্| ");
INSERT INTO sanben_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","পশ্যত সর্পান্ ৱৃশ্চিকান্ রিপোঃ সর্ৱ্ৱপরাক্রমাংশ্চ পদতলৈ র্দলযিতুং যুষ্মভ্যং শক্তিং দদামি তস্মাদ্ যুষ্মাকং কাপি হানি র্ন ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","ভূতা যুষ্মাকং ৱশীভৱন্তি, এতন্নিমিত্তৎ মা সমুল্লসত, স্ৱর্গে যুষ্মাকং নামানি লিখিতানি সন্তীতি নিমিত্তং সমুল্লসত| ");
INSERT INTO sanben_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","তদ্ঘটিকাযাং যীশু র্মনসি জাতাহ্লাদঃ কথযামাস হে স্ৱর্গপৃথিৱ্যোরেকাধিপতে পিতস্ত্ৱং জ্ঞানৱতাং ৱিদুষাঞ্চ লোকানাং পুরস্তাৎ সর্ৱ্ৱমেতদ্ অপ্রকাশ্য বালকানাং পুরস্তাৎ প্রাকাশয এতস্মাদ্ধেতোস্ত্ৱাং ধন্যং ৱদামি, হে পিতরিত্থং ভৱতু যদ্ এতদেৱ তৱ গোচর উত্তমম্| ");
INSERT INTO sanben_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","পিত্রা সর্ৱ্ৱাণি মযি সমর্পিতানি পিতরং ৱিনা কোপি পুত্রং ন জানাতি কিঞ্চ পুত্রং ৱিনা যস্মৈ জনায পুত্রস্তং প্রকাশিতৱান্ তঞ্চ ৱিনা কোপি পিতরং ন জানাতি| ");
INSERT INTO sanben_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","তপঃ পরং স শিষ্যান্ প্রতি পরাৱৃত্য গুপ্তং জগাদ, যূযমেতানি সর্ৱ্ৱাণি পশ্যথ ততো যুষ্মাকং চক্ষূংষি ধন্যানি| ");
INSERT INTO sanben_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","যুষ্মানহং ৱদামি, যূযং যানি সর্ৱ্ৱাণি পশ্যথ তানি বহৱো ভৱিষ্যদ্ৱাদিনো ভূপতযশ্চ দ্রষ্টুমিচ্ছন্তোপি দ্রষ্টুং ন প্রাপ্নুৱন্, যুষ্মাভি র্যা যাঃ কথাশ্চ শ্রূযন্তে তাঃ শ্রোতুমিচ্ছন্তোপি শ্রোতুং নালভন্ত| ");
INSERT INTO sanben_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","অনন্তরম্ একো ৱ্যৱস্থাপক উত্থায তং পরীক্ষিতুং পপ্রচ্ছ, হে উপদেশক অনন্তাযুষঃ প্রাপ্তযে মযা কিং করণীযং? ");
INSERT INTO sanben_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","যীশুঃ প্রত্যুৱাচ, অত্রার্থে ৱ্যৱস্থাযাং কিং লিখিতমস্তি? ৎৱং কীদৃক্ পঠসি? ");
INSERT INTO sanben_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ততঃ সোৱদৎ, ৎৱং সর্ৱ্ৱান্তঃকরণৈঃ সর্ৱ্ৱপ্রাণৈঃ সর্ৱ্ৱশক্তিভিঃ সর্ৱ্ৱচিত্তৈশ্চ প্রভৌ পরমেশ্ৱরে প্রেম কুরু, সমীপৱাসিনি স্ৱৱৎ প্রেম কুরু চ| ");
INSERT INTO sanben_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","তদা স কথযামাস, ৎৱং যথার্থং প্রত্যৱোচঃ, ইত্থম্ আচর তেনৈৱ জীৱিষ্যসি| ");
INSERT INTO sanben_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","কিন্তু স জনঃ স্ৱং নির্দ্দোষং জ্ঞাপযিতুং যীশুং পপ্রচ্ছ, মম সমীপৱাসী কঃ? ততো যীশুঃ প্রত্যুৱাচ, ");
INSERT INTO sanben_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","একো জনো যিরূশালম্পুরাদ্ যিরীহোপুরং যাতি, এতর্হি দস্যূনাং করেষু পতিতে তে তস্য ৱস্ত্রাদিকং হৃতৱন্তঃ তমাহত্য মৃতপ্রাযং কৃৎৱা ত্যক্ত্ৱা যযুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","অকস্মাদ্ একো যাজকস্তেন মার্গেণ গচ্ছন্ তং দৃষ্ট্ৱা মার্গান্যপার্শ্ৱেন জগাম| ");
INSERT INTO sanben_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ইত্থম্ একো লেৱীযস্তৎস্থানং প্রাপ্য তস্যান্তিকং গৎৱা তং ৱিলোক্যান্যেন পার্শ্ৱেন জগাম| ");
INSERT INTO sanben_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","কিন্ত্ৱেকঃ শোমিরোণীযো গচ্ছন্ তৎস্থানং প্রাপ্য তং দৃষ্ট্ৱাদযত| ");
INSERT INTO sanben_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","তস্যান্তিকং গৎৱা তস্য ক্ষতেষু তৈলং দ্রাক্ষারসঞ্চ প্রক্ষিপ্য ক্ষতানি বদ্ধ্ৱা নিজৱাহনোপরি তমুপৱেশ্য প্রৱাসীযগৃহম্ আনীয তং সিষেৱে| ");
INSERT INTO sanben_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","পরস্মিন্ দিৱসে নিজগমনকালে দ্ৱৌ মুদ্রাপাদৌ তদ্গৃহস্ৱামিনে দত্ত্ৱাৱদৎ জনমেনং সেৱস্ৱ তত্র যোঽধিকো ৱ্যযো ভৱিষ্যতি তমহং পুনরাগমনকালে পরিশোৎস্যামি| ");
INSERT INTO sanben_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","এষাং ত্রযাণাং মধ্যে তস্য দস্যুহস্তপতিতস্য জনস্য সমীপৱাসী কঃ? ৎৱযা কিং বুধ্যতে? ");
INSERT INTO sanben_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ততঃ স ৱ্যৱস্থাপকঃ কথযামাস যস্তস্মিন্ দযাং চকার| তদা যীশুঃ কথযামাস ৎৱমপি গৎৱা তথাচর| ");
INSERT INTO sanben_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","ততঃ পরং তে গচ্ছন্ত একং গ্রামং প্রৱিৱিশুঃ; তদা মর্থানামা স্ত্রী স্ৱগৃহে তস্যাতিথ্যং চকার| ");
INSERT INTO sanben_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","তস্মাৎ মরিযম্ নামধেযা তস্যা ভগিনী যীশোঃ পদসমীপ উৱৱিশ্য তস্যোপদেশকথাং শ্রোতুমারেভে| ");
INSERT INTO sanben_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","কিন্তু মর্থা নানাপরিচর্য্যাযাং ৱ্যগ্রা বভূৱ তস্মাদ্ধেতোস্তস্য সমীপমাগত্য বভাষে; হে প্রভো মম ভগিনী কেৱলং মমোপরি সর্ৱ্ৱকর্ম্মণাং ভারম্ অর্পিতৱতী তত্র ভৱতা কিঞ্চিদপি ন মনো নিধীযতে কিম্? মম সাহায্যং কর্ত্তুং ভৱান্ তামাদিশতু| ");
INSERT INTO sanben_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ততো যীশুঃ প্রত্যুৱাচ হে মর্থে হে মর্থে, ৎৱং নানাকার্য্যেষু চিন্তিতৱতী ৱ্যগ্রা চাসি, ");
INSERT INTO sanben_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","কিন্তু প্রযোজনীযম্ একমাত্রম্ আস্তে| অপরঞ্চ যমুত্তমং ভাগং কোপি হর্ত্তুং ন শক্নোতি সএৱ মরিযমা ৱৃতঃ| ");
INSERT INTO sanben_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","অনন্তরং স কস্মিংশ্চিৎ স্থানে প্রার্থযত তৎসমাপ্তৌ সত্যাং তস্যৈকঃ শিষ্যস্তং জগাদ হে প্রভো যোহন্ যথা স্ৱশিষ্যান্ প্রার্থযিতুম্ উপদিষ্টৱান্ তথা ভৱানপ্যস্মান্ উপদিশতু| ");
INSERT INTO sanben_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","তস্মাৎ স কথযামাস, প্রার্থনকালে যূযম্ ইত্থং কথযধ্ৱং, হে অস্মাকং স্ৱর্গস্থপিতস্তৱ নাম পূজ্যং ভৱতু; তৱ রাজৎৱং ভৱতু; স্ৱর্গে যথা তথা পৃথিৱ্যামপি তৱেচ্ছযা সর্ৱ্ৱং ভৱতু| ");
INSERT INTO sanben_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","প্রত্যহম্ অস্মাকং প্রযোজনীযং ভোজ্যং দেহি| ");
INSERT INTO sanben_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","যথা ৱযং সর্ৱ্ৱান্ অপরাধিনঃ ক্ষমামহে তথা ৎৱমপি পাপান্যস্মাকং ক্ষমস্ৱ| অস্মান্ পরীক্ষাং মানয কিন্তু পাপাত্মনো রক্ষ| ");
INSERT INTO sanben_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","পশ্চাৎ সোপরমপি কথিতৱান্ যদি যুষ্মাকং কস্যচিদ্ বন্ধুস্তিষ্ঠতি নিশীথে চ তস্য সমীপং স গৎৱা ৱদতি, ");
INSERT INTO sanben_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","হে বন্ধো পথিক একো বন্ধু র্মম নিৱেশনম্ আযাতঃ কিন্তু তস্যাতিথ্যং কর্ত্তুং মমান্তিকে কিমপি নাস্তি, অতএৱ পূপত্রযং মহ্যম্ ঋণং দেহি; ");
INSERT INTO sanben_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","তদা স যদি গৃহমধ্যাৎ প্রতিৱদতি মাং মা ক্লিশান, ইদানীং দ্ৱারং রুদ্ধং শযনে মযা সহ বালকাশ্চ তিষ্ঠন্তি তুভ্যং দাতুম্ উত্থাতুং ন শক্নোমি, ");
INSERT INTO sanben_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","তর্হি যুষ্মানহং ৱদামি, স যদি মিত্রতযা তস্মৈ কিমপি দাতুং নোত্তিষ্ঠতি তথাপি ৱারং ৱারং প্রার্থনাত উত্থাপিতঃ সন্ যস্মিন্ তস্য প্রযোজনং তদেৱ দাস্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","অতঃ কারণাৎ কথযামি, যাচধ্ৱং ততো যুষ্মভ্যং দাস্যতে, মৃগযধ্ৱং তত উদ্দেশং প্রাপ্স্যথ, দ্ৱারম্ আহত ততো যুষ্মভ্যং দ্ৱারং মোক্ষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","যো যাচতে স প্রাপ্নোতি, যো মৃগযতে স এৱোদ্দেশং প্রাপ্নোতি, যো দ্ৱারম্ আহন্তি তদর্থং দ্ৱারং মোচ্যতে| ");
INSERT INTO sanben_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","পুত্রেণ পূপে যাচিতে তস্মৈ পাষাণং দদাতি ৱা মৎস্যে যাচিতে তস্মৈ সর্পং দদাতি ");
INSERT INTO sanben_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ৱা অণ্ডে যাচিতে তস্মৈ ৱৃশ্চিকং দদাতি যুষ্মাকং মধ্যে ক এতাদৃশঃ পিতাস্তে? ");
INSERT INTO sanben_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","তস্মাদেৱ যূযমভদ্রা অপি যদি স্ৱস্ৱবালকেভ্য উত্তমানি দ্রৱ্যাণি দাতুং জানীথ তর্হ্যস্মাকং স্ৱর্গস্থঃ পিতা নিজযাচকেভ্যঃ কিং পৱিত্রম্ আত্মানং ন দাস্যতি? ");
INSERT INTO sanben_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","অনন্তরং যীশুনা কস্মাচ্চিদ্ একস্মিন্ মূকভূতে ত্যাজিতে সতি স ভূতত্যক্তো মানুষো ৱাক্যং ৱক্তুম্ আরেভে; ততো লোকাঃ সকলা আশ্চর্য্যং মেনিরে| ");
INSERT INTO sanben_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","কিন্তু তেষাং কেচিদূচু র্জনোযং বালসিবূবা অর্থাদ্ ভূতরাজেন ভূতান্ ত্যাজযতি| ");
INSERT INTO sanben_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","তং পরীক্ষিতুং কেচিদ্ আকাশীযম্ একং চিহ্নং দর্শযিতুং তং প্রার্থযাঞ্চক্রিরে| ");
INSERT INTO sanben_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","তদা স তেষাং মনঃকল্পনাং জ্ঞাৎৱা কথযামাস, কস্যচিদ্ রাজ্যস্য লোকা যদি পরস্পরং ৱিরুন্ধন্তি তর্হি তদ্ রাজ্যম্ নশ্যতি; কেচিদ্ গৃহস্থা যদি পরস্পরং ৱিরুন্ধন্তি তর্হি তেপি নশ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","তথৈৱ শৈতানপি স্ৱলোকান্ যদি ৱিরুণদ্ধি তদা তস্য রাজ্যং কথং স্থাস্যতি? বালসিবূবাহং ভূতান্ ত্যাজযামি যূযমিতি ৱদথ| ");
INSERT INTO sanben_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","যদ্যহং বালসিবূবা ভূতান্ ত্যাজযামি তর্হি যুষ্মাকং সন্তানাঃ কেন ত্যাজযন্তি? তস্মাৎ তএৱ কথাযা এতস্যা ৱিচারযিতারো ভৱিষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","কিন্তু যদ্যহম্ ঈশ্ৱরস্য পরাক্রমেণ ভূতান্ ত্যাজযামি তর্হি যুষ্মাকং নিকটম্ ঈশ্ৱরস্য রাজ্যমৱশ্যম্ উপতিষ্ঠতি| ");
INSERT INTO sanben_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","বলৱান্ পুমান্ সুসজ্জমানো যতিকালং নিজাট্টালিকাং রক্ষতি ততিকালং তস্য দ্রৱ্যং নিরুপদ্রৱং তিষ্ঠতি| ");
INSERT INTO sanben_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","কিন্তু তস্মাদ্ অধিকবলঃ কশ্চিদাগত্য যদি তং জযতি তর্হি যেষু শস্ত্রাস্ত্রেষু তস্য ৱিশ্ৱাস আসীৎ তানি সর্ৱ্ৱাণি হৃৎৱা তস্য দ্রৱ্যাণি গৃহ্লাতি| ");
INSERT INTO sanben_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","অতঃ কারণাদ্ যো মম সপক্ষো ন স ৱিপক্ষঃ, যো মযা সহ ন সংগৃহ্লাতি স ৱিকিরতি| ");
INSERT INTO sanben_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","অপরঞ্চ অমেধ্যভূতো মানুষস্যান্তর্নির্গত্য শুষ্কস্থানে ভ্রান্ত্ৱা ৱিশ্রামং মৃগযতে কিন্তু ন প্রাপ্য ৱদতি মম যস্মাদ্ গৃহাদ্ আগতোহং পুনস্তদ্ গৃহং পরাৱৃত্য যামি| ");
INSERT INTO sanben_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ততো গৎৱা তদ্ গৃহং মার্জিতং শোভিতঞ্চ দৃষ্ট্ৱা ");
INSERT INTO sanben_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","তৎক্ষণম্ অপগত্য স্ৱস্মাদপি দুর্ম্মতীন্ অপরান্ সপ্তভূতান্ সহানযতি তে চ তদ্গৃহং পৱিশ্য নিৱসন্তি| তস্মাৎ তস্য মনুষ্যস্য প্রথমদশাতঃ শেষদশা দুঃখতরা ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","অস্যাঃ কথাযাঃ কথনকালে জনতামধ্যস্থা কাচিন্নারী তমুচ্চৈঃস্ৱরং প্রোৱাচ, যা যোষিৎ ৎৱাং গর্ব্ভেঽধারযৎ স্তন্যমপাযযচ্চ সৈৱ ধন্যা| ");
INSERT INTO sanben_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","কিন্তু সোকথযৎ যে পরমেশ্ৱরস্য কথাং শ্রুৎৱা তদনুরূপম্ আচরন্তি তএৱ ধন্যাঃ| ");
INSERT INTO sanben_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","ততঃ পরং তস্যান্তিকে বহুলোকানাং সমাগমে জাতে স ৱক্তুমারেভে, আধুনিকা দুষ্টলোকাশ্চিহ্নং দ্রষ্টুমিচ্ছন্তি কিন্তু যূনস্ভৱিষ্যদ্ৱাদিনশ্চিহ্নং ৱিনান্যৎ কিঞ্চিচ্চিহ্নং তান্ ন দর্শযিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","যূনস্ তু যথা নীনিৱীযলোকানাং সমীপে চিহ্নরূপোভৱৎ তথা ৱিদ্যমানলোকানাম্ এষাং সমীপে মনুষ্যপুত্রোপি চিহ্নরূপো ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ৱিচারসমযে ইদানীন্তনলোকানাং প্রাতিকূল্যেন দক্ষিণদেশীযা রাজ্ঞী প্রোত্থায তান্ দোষিণঃ করিষ্যতি, যতঃ সা রাজ্ঞী সুলেমান উপদেশকথাং শ্রোতুং পৃথিৱ্যাঃ সীমাত আগচ্ছৎ কিন্তু পশ্যত সুলেমানোপি গুরুতর একো জনোঽস্মিন্ স্থানে ৱিদ্যতে| ");
INSERT INTO sanben_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","অপরঞ্চ ৱিচারসমযে নীনিৱীযলোকা অপি ৱর্ত্তমানকালিকানাং লোকানাং ৱৈপরীত্যেন প্রোত্থায তান্ দোষিণঃ করিষ্যন্তি, যতো হেতোস্তে যূনসো ৱাক্যাৎ চিত্তানি পরিৱর্ত্তযামাসুঃ কিন্তু পশ্যত যূনসোতিগুরুতর একো জনোঽস্মিন্ স্থানে ৱিদ্যতে| ");
INSERT INTO sanben_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","প্রদীপং প্রজ্ৱাল্য দ্রোণস্যাধঃ কুত্রাপি গুপ্তস্থানে ৱা কোপি ন স্থাপযতি কিন্তু গৃহপ্রৱেশিভ্যো দীপ্তিং দাতং দীপাধারোপর্য্যেৱ স্থাপযতি| ");
INSERT INTO sanben_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","দেহস্য প্রদীপশ্চক্ষুস্তস্মাদেৱ চক্ষু র্যদি প্রসন্নং ভৱতি তর্হি তৱ সর্ৱ্ৱশরীরং দীপ্তিমদ্ ভৱিষ্যতি কিন্তু চক্ষু র্যদি মলীমসং তিষ্ঠতি তর্হি সর্ৱ্ৱশরীরং সান্ধকারং স্থাস্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","অস্মাৎ কারণাৎ তৱান্তঃস্থং জ্যোতি র্যথান্ধকারমযং ন ভৱতি তদর্থে সাৱধানো ভৱ| ");
INSERT INTO sanben_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","যতঃ শরীরস্য কুত্রাপ্যংশে সান্ধকারে ন জাতে সর্ৱ্ৱং যদি দীপ্তিমৎ তিষ্ঠতি তর্হি তুভ্যং দীপ্তিদাযিপ্রোজ্জ্ৱলন্ প্রদীপ ইৱ তৱ সৱর্ৱশরীরং দীপ্তিমদ্ ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","এতৎকথাযাঃ কথনকালে ফিরুশ্যেকো ভেজনায তং নিমন্ত্রযামাস, ততঃ স গৎৱা ভোক্তুম্ উপৱিৱেশ| ");
INSERT INTO sanben_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","কিন্তু ভোজনাৎ পূর্ৱ্ৱং নামাঙ্ক্ষীৎ এতদ্ দৃষ্ট্ৱা স ফিরুশ্যাশ্চর্য্যং মেনে| ");
INSERT INTO sanben_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","তদা প্রভুস্তং প্রোৱাচ যূযং ফিরূশিলোকাঃ পানপাত্রাণাং ভোজনপাত্রাণাঞ্চ বহিঃ পরিষ্কুরুথ কিন্তু যুষ্মাকমন্ত র্দৌরাত্ম্যৈ র্দুষ্ক্রিযাভিশ্চ পরিপূর্ণং তিষ্ঠতি| ");
INSERT INTO sanben_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","হে সর্ৱ্ৱে নির্বোধা যো বহিঃ সসর্জ স এৱ কিমন্ত র্ন সসর্জ? ");
INSERT INTO sanben_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","তত এৱ যুষ্মাভিরন্তঃকরণং (ঈশ্ৱরায) নিৱেদ্যতাং তস্মিন্ কৃতে যুষ্মাকং সর্ৱ্ৱাণি শুচিতাং যাস্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","কিন্তু হন্ত ফিরূশিগণা যূযং ন্যাযম্ ঈশ্ৱরে প্রেম চ পরিত্যজ্য পোদিনাযা অরুদাদীনাং সর্ৱ্ৱেষাং শাকানাঞ্চ দশমাংশান্ দত্থ কিন্তু প্রথমং পালযিৎৱা শেষস্যালঙ্ঘনং যুষ্মাকম্ উচিতমাসীৎ| ");
INSERT INTO sanben_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","হা হা ফিরূশিনো যূযং ভজনগেহে প্রোচ্চাসনে আপণেষু চ নমস্কারেষু প্রীযধ্ৱে| ");
INSERT INTO sanben_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","ৱত কপটিনোঽধ্যাপকাঃ ফিরূশিনশ্চ লোকাযৎ শ্মশানম্ অনুপলভ্য তদুপরি গচ্ছন্তি যূযম্ তাদৃগপ্রকাশিতশ্মশানৱাদ্ ভৱথ| ");
INSERT INTO sanben_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","তদানীং ৱ্যৱস্থাপকানাম্ একা যীশুমৱদৎ, হে উপদেশক ৱাক্যেনেদৃশেনাস্মাস্ৱপি দোষম্ আরোপযসি| ");
INSERT INTO sanben_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ততঃ স উৱাচ, হা হা ৱ্যৱস্থাপকা যূযম্ মানুষাণাম্ উপরি দুঃসহ্যান্ ভারান্ ন্যস্যথ কিন্তু স্ৱযম্ একাঙ্গুुল্যাপি তান্ ভারান্ ন স্পৃশথ| ");
INSERT INTO sanben_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","হন্ত যুষ্মাকং পূর্ৱ্ৱপুরুষা যান্ ভৱিষ্যদ্ৱাদিনোঽৱধিষুস্তেষাং শ্মশানানি যূযং নির্ম্মাথ| ");
INSERT INTO sanben_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","তেনৈৱ যূযং স্ৱপূর্ৱ্ৱপুরুষাণাং কর্ম্মাণি সংমন্যধ্ৱে তদেৱ সপ্রমাণং কুরুথ চ, যতস্তে তানৱধিষুঃ যূযং তেষাং শ্মশানানি নির্ম্মাথ| ");
INSERT INTO sanben_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","অতএৱ ঈশ্ৱরস্য শাস্ত্রে প্রোক্তমস্তি তেষামন্তিকে ভৱিষ্যদ্ৱাদিনঃ প্রেরিতাংশ্চ প্রেষযিষ্যামি ততস্তে তেষাং কাংশ্চন হনিষ্যন্তি কাংশ্চন তাডশ্ষ্যিন্তি| ");
INSERT INTO sanben_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","এতস্মাৎ কারণাৎ হাবিলঃ শোণিতপাতমারভ্য মন্দিরযজ্ঞৱেদ্যো র্মধ্যে হতস্য সিখরিযস্য রক্তপাতপর্য্যন্তং ");
INSERT INTO sanben_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","জগতঃ সৃষ্টিমারভ্য পৃথিৱ্যাং ভৱিষ্যদ্ৱাদিনাং যতিরক্তপাতা জাতাস্ততীনাম্ অপরাধদণ্ডা এষাং ৱর্ত্তমানলোকানাং ভৱিষ্যন্তি, যুষ্মানহং নিশ্চিতং ৱদামি সর্ৱ্ৱে দণ্ডা ৱংশস্যাস্য ভৱিষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","হা হা ৱ্যৱস্থপকা যূযং জ্ঞানস্য কুঞ্চিকাং হৃৎৱা স্ৱযং ন প্রৱিষ্টা যে প্রৱেষ্টুঞ্চ প্রযাসিনস্তানপি প্রৱেষ্টুং ৱারিতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","ইত্থং কথাকথনাদ্ অধ্যাপকাঃ ফিরূশিনশ্চ সতর্কাঃ ");
INSERT INTO sanben_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","সন্তস্তমপৱদিতুং তস্য কথাযা দোষং ধর্ত্তমিচ্ছন্তো নানাখ্যানকথনায তং প্রৱর্ত্তযিতুং কোপযিতুঞ্চ প্রারেভিরে| ");
INSERT INTO sanben_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","তদানীং লোকাঃ সহস্রং সহস্রম্ আগত্য সমুপস্থিতাস্তত একৈকো ঽন্যেষামুপরি পতিতুম্ উপচক্রমে; তদা যীশুঃ শিষ্যান্ বভাষে, যূযং ফিরূশিনাং কিণ্ৱরূপকাপট্যে ৱিশেষেণ সাৱধানাস্তিষ্ঠত| ");
INSERT INTO sanben_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","যতো যন্ন প্রকাশযিষ্যতে তদাচ্ছন্নং ৱস্তু কিমপি নাস্তি; তথা যন্ন জ্ঞাস্যতে তদ্ গুপ্তং ৱস্তু কিমপি নাস্তি| ");
INSERT INTO sanben_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","অন্ধকারে তিষ্ঠনতো যাঃ কথা অকথযত তাঃ সর্ৱ্ৱাঃ কথা দীপ্তৌ শ্রোষ্যন্তে নির্জনে কর্ণে চ যদকথযত গৃহপৃষ্ঠাৎ তৎ প্রচারযিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","হে বন্ধৱো যুষ্মানহং ৱদামি, যে শরীরস্য নাশং ৱিনা কিমপ্যপরং কর্ত্তুং ন শক্রুৱন্তি তেভ্যো মা ভৈষ্ট| ");
INSERT INTO sanben_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","তর্হি কস্মাদ্ ভেতৱ্যম্ ইত্যহং ৱদামি, যঃ শরীরং নাশযিৎৱা নরকং নিক্ষেপ্তুং শক্নোতি তস্মাদেৱ ভযং কুরুত, পুনরপি ৱদামি তস্মাদেৱ ভযং কুরুত| ");
INSERT INTO sanben_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","পঞ্চ চটকপক্ষিণঃ কিং দ্ৱাভ্যাং তাম্রখণ্ডাভ্যাং ন ৱিক্রীযন্তে? তথাপীশ্ৱরস্তেষাম্ একমপি ন ৱিস্মরতি| ");
INSERT INTO sanben_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","যুষ্মাকং শিরঃকেশা অপি গণিতাঃ সন্তি তস্মাৎ মা ৱিভীত বহুচটকপক্ষিভ্যোপি যূযং বহুমূল্যাঃ| ");
INSERT INTO sanben_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","অপরং যুষ্মভ্যং কথযামি যঃ কশ্চিন্ মানুষাণাং সাক্ষান্ মাং স্ৱীকরোতি মনুষ্যপুত্র ঈশ্ৱরদূতানাং সাক্ষাৎ তং স্ৱীকরিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","কিন্তু যঃ কশ্চিন্মানুষাণাং সাক্ষান্মাম্ অস্ৱীকরোতি তম্ ঈশ্ৱরস্য দূতানাং সাক্ষাদ্ অহম্ অস্ৱীকরিষ্যামি| ");
INSERT INTO sanben_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","অন্যচ্চ যঃ কশ্চিন্ মনুজসুতস্য নিন্দাভাৱেন কাঞ্চিৎ কথাং কথযতি তস্য তৎপাপস্য মোচনং ভৱিষ্যতি কিন্তু যদি কশ্চিৎ পৱিত্রম্ আত্মানং নিন্দতি তর্হি তস্য তৎপাপস্য মোচনং ন ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","যদা লোকা যুষ্মান্ ভজনগেহং ৱিচারকর্তৃরাজ্যকর্তৃণাং সম্মুখঞ্চ নেষ্যন্তি তদা কেন প্রকারেণ কিমুত্তরং ৱদিষ্যথ কিং কথযিষ্যথ চেত্যত্র মা চিন্তযত; ");
INSERT INTO sanben_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","যতো যুষ্মাভির্যদ্ যদ্ ৱক্তৱ্যং তৎ তস্মিন্ সমযএৱ পৱিত্র আত্মা যুষ্মান্ শিক্ষযিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ততঃ পরং জনতামধ্যস্থঃ কশ্চিজ্জনস্তং জগাদ হে গুরো মযা সহ পৈতৃকং ধনং ৱিভক্তুং মম ভ্রাতরমাজ্ঞাপযতু ভৱান্| ");
INSERT INTO sanben_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","কিন্তু স তমৱদৎ হে মনুষ্য যুৱযো র্ৱিচারং ৱিভাগঞ্চ কর্ত্তুং মাং কো নিযুক্তৱান্? ");
INSERT INTO sanben_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","অনন্তরং স লোকানৱদৎ লোভে সাৱধানাঃ সতর্কাশ্চ তিষ্ঠত, যতো বহুসম্পত্তিপ্রাপ্ত্যা মনুষ্যস্যাযু র্ন ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","পশ্চাদ্ দৃষ্টান্তকথামুত্থাপ্য কথযামাস, একস্য ধনিনো ভূমৌ বহূনি শস্যানি জাতানি| ");
INSERT INTO sanben_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ততঃ স মনসা চিন্তযিৎৱা কথযাম্বভূৱ মমৈতানি সমুৎপন্নানি দ্রৱ্যাণি স্থাপযিতুং স্থানং নাস্তি কিং করিষ্যামি? ");
INSERT INTO sanben_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ততোৱদদ্ ইত্থং করিষ্যামি, মম সর্ৱ্ৱভাণ্ডাগারাণি ভঙ্ক্ত্ৱা বৃহদ্ভাণ্ডাগারাণি নির্ম্মায তন্মধ্যে সর্ৱ্ৱফলানি দ্রৱ্যাণি চ স্থাপযিষ্যামি| ");
INSERT INTO sanben_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","অপরং নিজমনো ৱদিষ্যামি, হে মনো বহুৱৎসরার্থং নানাদ্রৱ্যাণি সঞ্চিতানি সন্তি ৱিশ্রামং কুরু ভুক্ত্ৱা পীৎৱা কৌতুকঞ্চ কুরু| কিন্ত্ৱীশ্ৱরস্তম্ অৱদৎ, ");
INSERT INTO sanben_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","রে নির্বোধ অদ্য রাত্রৌ তৱ প্রাণাস্ত্ৱত্তো নেষ্যন্তে তত এতানি যানি দ্রৱ্যাণি ৎৱযাসাদিতানি তানি কস্য ভৱিষ্যন্তি? ");
INSERT INTO sanben_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","অতএৱ যঃ কশ্চিদ্ ঈশ্ৱরস্য সমীপে ধনসঞ্চযমকৃৎৱা কেৱলং স্ৱনিকটে সঞ্চযং করোতি সোপি তাদৃশঃ| ");
INSERT INTO sanben_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","অথ স শিষ্যেভ্যঃ কথযামাস, যুষ্মানহং ৱদামি, কিং খাদিষ্যামঃ? কিং পরিধাস্যামঃ? ইত্যুক্ত্ৱা জীৱনস্য শরীরস্য চার্থং চিন্তাং মা কার্ষ্ট| ");
INSERT INTO sanben_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ভক্ষ্যাজ্জীৱনং ভূষণাচ্ছরীরঞ্চ শ্রেষ্ঠং ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","কাকপক্ষিণাং কার্য্যং ৱিচারযত, তে ন ৱপন্তি শস্যানি চ ন ছিন্দন্তি, তেষাং ভাণ্ডাগারাণি ন সন্তি কোষাশ্চ ন সন্তি, তথাপীশ্ৱরস্তেভ্যো ভক্ষ্যাণি দদাতি, যূযং পক্ষিভ্যঃ শ্রেষ্ঠতরা ন কিং? ");
INSERT INTO sanben_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","অপরঞ্চ ভাৱযিৎৱা নিজাযুষঃ ক্ষণমাত্রং ৱর্দ্ধযিতুং শক্নোতি, এতাদৃশো লাকো যুষ্মাকং মধ্যে কোস্তি? ");
INSERT INTO sanben_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","অতএৱ ক্ষুদ্রং কার্য্যং সাধযিতুম্ অসমর্থা যূযম্ অন্যস্মিন্ কার্য্যে কুতো ভাৱযথ? ");
INSERT INTO sanben_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","অন্যচ্চ কাম্পিলপুষ্পং কথং ৱর্দ্ধতে তদাপি ৱিচারযত, তৎ কঞ্চন শ্রমং ন করোতি তন্তূংশ্চ ন জনযতি কিন্তু যুষ্মভ্যং যথার্থং কথযামি সুলেমান্ বহ্ৱৈশ্ৱর্য্যান্ৱিতোপি পুষ্পস্যাস্য সদৃশো ৱিভূষিতো নাসীৎ| ");
INSERT INTO sanben_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","অদ্য ক্ষেত্রে ৱর্ত্তমানং শ্ৱশ্চূল্ল্যাং ক্ষেপ্স্যমানং যৎ তৃণং, তস্মৈ যদীশ্ৱর ইত্থং ভূষযতি তর্হি হে অল্পপ্রত্যযিনো যুষ্মান কিং ন পরিধাপযিষ্যতি? ");
INSERT INTO sanben_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","অতএৱ কিং খাদিষ্যামঃ? কিং পরিধাস্যামঃ? এতদর্থং মা চেষ্টধ্ৱং মা সংদিগ্ধ্ৱঞ্চ| ");
INSERT INTO sanben_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","জগতো দেৱার্চ্চকা এতানি সর্ৱ্ৱাণি চেষ্টনতে; এষু ৱস্তুষু যুষ্মাকং প্রযোজনমাস্তে ইতি যুষ্মাকং পিতা জানাতি| ");
INSERT INTO sanben_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","অতএৱেশ্ৱরস্য রাজ্যার্থং সচেষ্টা ভৱত তথা কৃতে সর্ৱ্ৱাণ্যেতানি দ্রৱ্যাণি যুষ্মভ্যং প্রদাযিষ্যন্তে| ");
INSERT INTO sanben_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","হে ক্ষুদ্রমেষৱ্রজ যূযং মা ভৈষ্ট যুষ্মভ্যং রাজ্যং দাতুং যুষ্মাকং পিতুঃ সম্মতিরস্তি| ");
INSERT INTO sanben_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","অতএৱ যুষ্মাকং যা যা সম্পত্তিরস্তি তাং তাং ৱিক্রীয ৱিতরত, যৎ স্থানং চৌরা নাগচ্ছন্তি, কীটাশ্চ ন ক্ষাযযন্তি তাদৃশে স্ৱর্গে নিজার্থম্ অজরে সম্পুটকে ঽক্ষযং ধনং সঞ্চিনুত চ; ");
INSERT INTO sanben_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","যতো যত্র যুষ্মাকং ধনং ৱর্ত্ততে তত্রেৱ যুষ্মাকং মনঃ| ");
INSERT INTO sanben_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","অপরঞ্চ যূযং প্রদীপং জ্ৱালযিৎৱা বদ্ধকটযস্তিষ্ঠত; ");
INSERT INTO sanben_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","প্রভু র্ৱিৱাহাদাগত্য যদৈৱ দ্ৱারমাহন্তি তদৈৱ দ্ৱারং মোচযিতুং যথা ভৃত্যা অপেক্ষ্য তিষ্ঠন্তি তথা যূযমপি তিষ্ঠত| ");
INSERT INTO sanben_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","যতঃ প্রভুরাগত্য যান্ দাসান্ সচেতনান্ তিষ্ঠতো দ্রক্ষ্যতি তএৱ ধন্যাঃ; অহং যুষ্মান্ যথার্থং ৱদামি প্রভুস্তান্ ভোজনার্থম্ উপৱেশ্য স্ৱযং বদ্ধকটিঃ সমীপমেত্য পরিৱেষযিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","যদি দ্ৱিতীযে তৃতীযে ৱা প্রহরে সমাগত্য তথৈৱ পশ্যতি, তর্হি তএৱ দাসা ধন্যাঃ| ");
INSERT INTO sanben_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","অপরঞ্চ কস্মিন্ ক্ষণে চৌরা আগমিষ্যন্তি ইতি যদি গৃহপতি র্জ্ঞাতুং শক্নোতি তদাৱশ্যং জাগ্রন্ নিজগৃহে সন্ধিং কর্ত্তযিতুং ৱারযতি যূযমেতদ্ ৱিত্ত| ");
INSERT INTO sanben_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","অতএৱ যূযমপি সজ্জমানাস্তিষ্ঠত যতো যস্মিন্ ক্ষণে তং নাপ্রেক্ষধ্ৱে তস্মিন্নেৱ ক্ষণে মনুষ্যপুত্র আগমিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","তদা পিতরঃ পপ্রচ্ছ, হে প্রভো ভৱান্ কিমস্মান্ উদ্দিশ্য কিং সর্ৱ্ৱান্ উদ্দিশ্য দৃষ্টান্তকথামিমাং ৱদতি? ");
INSERT INTO sanben_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ততঃ প্রভুঃ প্রোৱাচ, প্রভুঃ সমুচিতকালে নিজপরিৱারার্থং ভোজ্যপরিৱেষণায যং তৎপদে নিযোক্ষ্যতি তাদৃশো ৱিশ্ৱাস্যো বোদ্ধা কর্ম্মাধীশঃ কোস্তি? ");
INSERT INTO sanben_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","প্রভুরাগত্য যম্ এতাদৃশে কর্ম্মণি প্রৱৃত্তং দ্রক্ষ্যতি সএৱ দাসো ধন্যঃ| ");
INSERT INTO sanben_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","অহং যুষ্মান্ যথার্থং ৱদামি স তং নিজসর্ৱ্ৱস্ৱস্যাধিপতিং করিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","কিন্তু প্রভুর্ৱিলম্বেনাগমিষ্যতি, ইতি ৱিচিন্ত্য স দাসো যদি তদন্যদাসীদাসান্ প্রহর্ত্তুম্ ভোক্তুং পাতুং মদিতুঞ্চ প্রারভতে, ");
INSERT INTO sanben_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","তর্হি যদা প্রভুং নাপেক্ষিষ্যতে যস্মিন্ ক্ষণে সোঽচেতনশ্চ স্থাস্যতি তস্মিন্নেৱ ক্ষণে তস্য প্রভুরাগত্য তং পদভ্রষ্টং কৃৎৱা ৱিশ্ৱাসহীনৈঃ সহ তস্য অংশং নিরূপযিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","যো দাসঃ প্রভেाরাজ্ঞাং জ্ঞাৎৱাপি সজ্জিতো ন তিষ্ঠতি তদাজ্ঞানুসারেণ চ কার্য্যং ন করোতি সোনেকান্ প্রহারান্ প্রাপ্স্যতি; ");
INSERT INTO sanben_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","কিন্তু যো জনোঽজ্ঞাৎৱা প্রহারার্হং কর্ম্ম করোতি সোল্পপ্রহারান্ প্রাপ্স্যতি| যতো যস্মৈ বাহুল্যেন দত্তং তস্মাদেৱ বাহুল্যেন গ্রহীষ্যতে, মানুষা যস্য নিকটে বহু সমর্পযন্তি তস্মাদ্ বহু যাচন্তে| ");
INSERT INTO sanben_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","অহং পৃথিৱ্যাম্ অনৈক্যরূপং ৱহ্নি নিক্ষেপ্তুম্ আগতোস্মি, স চেদ্ ইদানীমেৱ প্রজ্ৱলতি তত্র মম কা চিন্তা? ");
INSERT INTO sanben_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","কিন্তু যেন মজ্জনেনাহং মগ্নো ভৱিষ্যামি যাৱৎকালং তস্য সিদ্ধি র্ন ভৱিষ্যতি তাৱদহং কতিকষ্টং প্রাপ্স্যামি| ");
INSERT INTO sanben_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","মেলনং কর্ত্তুং জগদ্ আগতোস্মি যূযং কিমিত্থং বোধধ্ৱে? যুষ্মান্ ৱদামি ন তথা, কিন্ত্ৱহং মেলনাভাৱং কর্ত্তুংম্ আগতোস্মি| ");
INSERT INTO sanben_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","যস্মাদেতৎকালমারভ্য একত্রস্থপরিজনানাং মধ্যে পঞ্চজনাঃ পৃথগ্ ভূৎৱা ত্রযো জনা দ্ৱযোর্জনযোঃ প্রতিকূলা দ্ৱৌ জনৌ চ ত্রযাণাং জনানাং প্রতিকূলৌ ভৱিষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","পিতা পুত্রস্য ৱিপক্ষঃ পুত্রশ্চ পিতু র্ৱিপক্ষো ভৱিষ্যতি মাতা কন্যাযা ৱিপক্ষা কন্যা চ মাতু র্ৱিপক্ষা ভৱিষ্যতি, তথা শ্ৱশ্রূর্বধ্ৱা ৱিপক্ষা বধূশ্চ শ্ৱশ্র্ৱা ৱিপক্ষা ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","স লোকেভ্যোপরমপি কথযামাস, পশ্চিমদিশি মেঘোদ্গমং দৃষ্ট্ৱা যূযং হঠাদ্ ৱদথ ৱৃষ্টি র্ভৱিষ্যতি ততস্তথৈৱ জাযতে| ");
INSERT INTO sanben_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","অপরং দক্ষিণতো ৱাযৌ ৱাতি সতি ৱদথ নিদাঘো ভৱিষ্যতি ততঃ সোপি জাযতে| ");
INSERT INTO sanben_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","রে রে কপটিন আকাশস্য ভূম্যাশ্চ লক্ষণং বোদ্ধুং শক্নুথ, ");
INSERT INTO sanben_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","কিন্তু কালস্যাস্য লক্ষণং কুতো বোদ্ধুং ন শক্নুথ? যূযঞ্চ স্ৱযং কুতো ন ন্যাষ্যং ৱিচারযথ? ");
INSERT INTO sanben_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","অপরঞ্চ ৱিৱাদিনা সার্দ্ধং ৱিচারযিতুঃ সমীপং গচ্ছন্ পথি তস্মাদুদ্ধারং প্রাপ্তুং যতস্ৱ নোচেৎ স ৎৱাং ধৃৎৱা ৱিচারযিতুঃ সমীপং নযতি| ৱিচারযিতা যদি ৎৱাং প্রহর্ত্তুঃ সমীপং সমর্পযতি প্রহর্ত্তা ৎৱাং কারাযাং বধ্নাতি ");
INSERT INTO sanben_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","তর্হি ৎৱামহং ৱদামি ৎৱযা নিঃশেষং কপর্দকেষু ন পরিশোধিতেষু ৎৱং ততো মুক্তিং প্রাপ্তুং ন শক্ষ্যসি| ");
INSERT INTO sanben_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","অপরঞ্চ পীলাতো যেষাং গালীলীযানাং রক্তানি বলীনাং রক্তৈঃ সহামিশ্রযৎ তেষাং গালীলীযানাং ৱৃত্তান্তং কতিপযজনা উপস্থাপ্য যীশৱে কথযামাসুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ততঃ স প্রত্যুৱাচ তেষাং লোকানাম্ এতাদৃশী দুর্গতি র্ঘটিতা তৎকারণাদ্ যূযং কিমন্যেভ্যো গালীলীযেভ্যোপ্যধিকপাপিনস্তান্ বোধধ্ৱে? ");
INSERT INTO sanben_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","যুষ্মানহং ৱদামি তথা ন কিন্তু মনঃসু ন পরাৱর্ত্তিতেষু যূযমপি তথা নংক্ষ্যথ| ");
INSERT INTO sanben_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","অপরঞ্চ শীলোহনাম্ন উচ্চগৃহস্য পতনাদ্ যেঽষ্টাদশজনা মৃতাস্তে যিরূশালমি নিৱাসিসর্ৱ্ৱলোকেভ্যোঽধিকাপরাধিনঃ কিং যূযমিত্যং বোধধ্ৱে? ");
INSERT INTO sanben_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","যুষ্মানহং ৱদামি তথা ন কিন্তু মনঃসু ন পরিৱর্ত্তিতেষু যূযমপি তথা নংক্ষ্যথ| ");
INSERT INTO sanben_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","অনন্তরং স ইমাং দৃষ্টান্তকথামকথযদ্ একো জনো দ্রাক্ষাক্ষেত্রমধ্য একমুডুম্বরৱৃক্ষং রোপিতৱান্| পশ্চাৎ স আগত্য তস্মিন্ ফলানি গৱেষযামাস, ");
INSERT INTO sanben_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","কিন্তু ফলাপ্রাপ্তেঃ কারণাদ্ উদ্যানকারং ভৃত্যং জগাদ, পশ্য ৱৎসরত্রযং যাৱদাগত্য এতস্মিন্নুডুম্বরতরৌ ক্ষলান্যন্ৱিচ্ছামি, কিন্তু নৈকমপি প্রপ্নোমি তরুরযং কুতো ৱৃথা স্থানং ৱ্যাপ্য তিষ্ঠতি? এনং ছিন্ধি| ");
INSERT INTO sanben_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ততো ভৃত্যঃ প্রত্যুৱাচ, হে প্রভো পুনর্ৱর্ষমেকং স্থাতুম্ আদিশ; এতস্য মূলস্য চতুর্দিক্ষু খনিৎৱাহম্ আলৱালং স্থাপযামি| ");
INSERT INTO sanben_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ততঃ ফলিতুং শক্নোতি যদি ন ফলতি তর্হি পশ্চাৎ ছেৎস্যসি| ");
INSERT INTO sanben_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","অথ ৱিশ্রামৱারে ভজনগেহে যীশুরুপদিশতি ");
INSERT INTO sanben_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","তস্মিৎ সমযে ভূতগ্রস্তৎৱাৎ কুব্জীভূযাষ্টাদশৱর্ষাণি যাৱৎ কেনাপ্যুপাযেন ঋজু র্ভৱিতুং ন শক্নোতি যা দুর্ব্বলা স্ত্রী, ");
INSERT INTO sanben_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","তাং তত্রোপস্থিতাং ৱিলোক্য যীশুস্তামাহূয কথিতৱান্ হে নারি তৱ দৌর্ব্বল্যাৎ ৎৱং মুক্তা ভৱ| ");
INSERT INTO sanben_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ততঃ পরং তস্যা গাত্রে হস্তার্পণমাত্রাৎ সা ঋজুর্ভূৎৱেশ্ৱরস্য ধন্যৱাদং কর্ত্তুমারেভে| ");
INSERT INTO sanben_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","কিন্তু ৱিশ্রামৱারে যীশুনা তস্যাঃ স্ৱাস্থ্যকরণাদ্ ভজনগেহস্যাধিপতিঃ প্রকুপ্য লোকান্ উৱাচ, ষট্সু দিনেষু লোকৈঃ কর্ম্ম কর্ত্তৱ্যং তস্মাদ্ধেতোঃ স্ৱাস্থ্যার্থং তেষু দিনেষু আগচ্ছত, ৱিশ্রামৱারে মাগচ্ছত| ");
INSERT INTO sanben_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","তদা পভুঃ প্রত্যুৱাচ রে কপটিনো যুষ্মাকম্ একৈকো জনো ৱিশ্রামৱারে স্ৱীযং স্ৱীযং ৱৃষভং গর্দভং ৱা বন্ধনান্মোচযিৎৱা জলং পাযযিতুং কিং ন নযতি? ");
INSERT INTO sanben_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","তর্হ্যাষ্টাদশৱৎসরান্ যাৱৎ শৈতানা বদ্ধা ইব্রাহীমঃ সন্ততিরিযং নারী কিং ৱিশ্রামৱারে ন মোচযিতৱ্যা? ");
INSERT INTO sanben_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","এষু ৱাক্যেষু কথিতেষু তস্য ৱিপক্ষাঃ সলজ্জা জাতাঃ কিন্তু তেন কৃতসর্ৱ্ৱমহাকর্ম্মকারণাৎ লোকনিৱহঃ সানন্দোঽভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","অনন্তরং সোৱদদ্ ঈশ্ৱরস্য রাজ্যং কস্য সদৃশং? কেন তদুপমাস্যামি? ");
INSERT INTO sanben_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","যৎ সর্ষপবীজং গৃহীৎৱা কশ্চিজ্জন উদ্যান উপ্তৱান্ তদ্ বীজমঙ্কুরিতং সৎ মহাৱৃক্ষোঽজাযত, ততস্তস্য শাখাসু ৱিহাযসীযৱিহগা আগত্য ন্যূষুঃ, তদ্রাজ্যং তাদৃশেন সর্ষপবীজেন তুল্যং| ");
INSERT INTO sanben_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","পুনঃ কথযামাস, ঈশ্ৱরস্য রাজ্যং কস্য সদৃশং ৱদিষ্যামি? যৎ কিণ্ৱং কাচিৎ স্ত্রী গৃহীৎৱা দ্রোণত্রযপরিমিতগোধূমচূর্ণেষু স্থাপযামাস, ");
INSERT INTO sanben_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ততঃ ক্রমেণ তৎ সর্ৱ্ৱগোধূমচূর্ণং ৱ্যাপ্নোতি, তস্য কিণ্ৱস্য তুল্যম্ ঈশ্ৱরস্য রাজ্যং| ");
INSERT INTO sanben_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ততঃ স যিরূশালম্নগরং প্রতি যাত্রাং কৃৎৱা নগরে নগরে গ্রামে গ্রামে সমুপদিশন্ জগাম| ");
INSERT INTO sanben_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","তদা কশ্চিজ্জনস্তং পপ্রচ্ছ, হে প্রভো কিং কেৱলম্ অল্পে লোকাঃ পরিত্রাস্যন্তে? ");
INSERT INTO sanben_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","ততঃ স লোকান্ উৱাচ, সংকীর্ণদ্ৱারেণ প্রৱেষ্টুং যতঘ্ৱং, যতোহং যুষ্মান্ ৱদামি, বহৱঃ প্রৱেষ্টুং চেষ্টিষ্যন্তে কিন্তু ন শক্ষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","গৃহপতিনোত্থায দ্ৱারে রুদ্ধে সতি যদি যূযং বহিঃ স্থিৎৱা দ্ৱারমাহত্য ৱদথ, হে প্রভো হে প্রভো অস্মৎকারণাদ্ দ্ৱারং মোচযতু, ততঃ স ইতি প্রতিৱক্ষ্যতি, যূযং কুত্রত্যা লোকা ইত্যহং ন জানামি| ");
INSERT INTO sanben_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","তদা যূযং ৱদিষ্যথ, তৱ সাক্ষাদ্ ৱযং ভেाজনং পানঞ্চ কৃতৱন্তঃ, ৎৱঞ্চাস্মাকং নগরস্য পথি সমুপদিষ্টৱান্| ");
INSERT INTO sanben_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","কিন্তু স ৱক্ষ্যতি, যুষ্মানহং ৱদামি, যূযং কুত্রত্যা লোকা ইত্যহং ন জানামি; হে দুরাচারিণো যূযং মত্তো দূরীভৱত| ");
INSERT INTO sanben_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","তদা ইব্রাহীমং ইস্হাকং যাকূবঞ্চ সর্ৱ্ৱভৱিষ্যদ্ৱাদিনশ্চ ঈশ্ৱরস্য রাজ্যং প্রাপ্তান্ স্ৱাংশ্চ বহিষ্কৃতান্ দৃষ্ট্ৱা যূযং রোদনং দন্তৈর্দন্তঘর্ষণঞ্চ করিষ্যথ| ");
INSERT INTO sanben_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","অপরঞ্চ পূর্ৱ্ৱপশ্চিমদক্ষিণোত্তরদিগ্ভ্যো লোকা আগত্য ঈশ্ৱরস্য রাজ্যে নিৱৎস্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","পশ্যতেত্থং শেষীযা লোকা অগ্রা ভৱিষ্যন্তি, অগ্রীযা লোকাশ্চ শেষা ভৱিষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","অপরঞ্চ তস্মিন্ দিনে কিযন্তঃ ফিরূশিন আগত্য যীশুং প্রোচুঃ, বহির্গচ্ছ, স্থানাদস্মাৎ প্রস্থানং কুরু, হেরোদ্ ৎৱাং জিঘাংসতি| ");
INSERT INTO sanben_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ততঃ স প্রত্যৱোচৎ পশ্যতাদ্য শ্ৱশ্চ ভূতান্ ৱিহাপ্য রোগিণোঽরোগিণঃ কৃৎৱা তৃতীযেহ্নি সেৎস্যামি, কথামেতাং যূযমিৎৱা তং ভূরিমাযং ৱদত| ");
INSERT INTO sanben_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","তত্রাপ্যদ্য শ্ৱঃ পরশ্ৱশ্চ মযা গমনাগমনে কর্ত্তৱ্যে, যতো হেতো র্যিরূশালমো বহিঃ কুত্রাপি কোপি ভৱিষ্যদ্ৱাদী ন ঘানিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","হে যিরূশালম্ হে যিরূশালম্ ৎৱং ভৱিষ্যদ্ৱাদিনো হংসি তৱান্তিকে প্রেরিতান্ প্রস্তরৈর্মারযসি চ, যথা কুক্কুটী নিজপক্ষাধঃ স্ৱশাৱকান্ সংগৃহ্লাতি, তথাহমপি তৱ শিশূন্ সংগ্রহীতুং কতিৱারান্ ঐচ্ছং কিন্তু ৎৱং নৈচ্ছঃ| ");
INSERT INTO sanben_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","পশ্যত যুষ্মাকং ৱাসস্থানানি প্রোচ্ছিদ্যমানানি পরিত্যক্তানি চ ভৱিষ্যন্তি; যুষ্মানহং যথার্থং ৱদামি, যঃ প্রভো র্নাম্নাগচ্ছতি স ধন্য ইতি ৱাচং যাৱৎকালং ন ৱদিষ্যথ, তাৱৎকালং যূযং মাং ন দ্রক্ষ্যথ| ");
INSERT INTO sanben_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","অনন্তরং ৱিশ্রামৱারে যীশৌ প্রধানস্য ফিরূশিনো গৃহে ভোক্তুং গতৱতি তে তং ৱীক্ষিতুম্ আরেভিরে| ");
INSERT INTO sanben_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","তদা জলোদরী তস্য সম্মুখে স্থিতঃ| ");
INSERT INTO sanben_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ততঃ স ৱ্যৱস্থাপকান্ ফিরূশিনশ্চ পপ্রচ্ছ, ৱিশ্রামৱারে স্ৱাস্থ্যং কর্ত্তৱ্যং ন ৱা? ততস্তে কিমপি ন প্রত্যূচুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","তদা স তং রোগিণং স্ৱস্থং কৃৎৱা ৱিসসর্জ; ");
INSERT INTO sanben_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","তানুৱাচ চ যুষ্মাকং কস্যচিদ্ গর্দ্দভো ৱৃষভো ৱা চেদ্ গর্ত্তে পততি তর্হি ৱিশ্রামৱারে তৎক্ষণং স কিং তং নোত্থাপযিষ্যতি? ");
INSERT INTO sanben_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ততস্তে কথাযা এতস্যাঃ কিমপি প্রতিৱক্তুং ন শেকুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","অপরঞ্চ প্রধানস্থানমনোনীতৎৱকরণং ৱিলোক্য স নিমন্ত্রিতান্ এতদুপদেশকথাং জগাদ, ");
INSERT INTO sanben_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","ৎৱং ৱিৱাহাদিভোজ্যেষু নিমন্ত্রিতঃ সন্ প্রধানস্থানে মোপাৱেক্ষীঃ| ৎৱত্তো গৌরৱান্ৱিতনিমন্ত্রিতজন আযাতে ");
INSERT INTO sanben_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","নিমন্ত্রযিতাগত্য মনুষ্যাযৈতস্মৈ স্থানং দেহীতি ৱাক্যং চেদ্ ৱক্ষ্যতি তর্হি ৎৱং সঙ্কুচিতো ভূৎৱা স্থান ইতরস্মিন্ উপৱেষ্টুম্ উদ্যংস্যসি| ");
INSERT INTO sanben_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","অস্মাৎ কারণাদেৱ ৎৱং নিমন্ত্রিতো গৎৱাঽপ্রধানস্থান উপৱিশ, ততো নিমন্ত্রযিতাগত্য ৱদিষ্যতি, হে বন্ধো প্রোচ্চস্থানং গৎৱোপৱিশ, তথা সতি ভোজনোপৱিষ্টানাং সকলানাং সাক্ষাৎ ৎৱং মান্যো ভৱিষ্যসি| ");
INSERT INTO sanben_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","যঃ কশ্চিৎ স্ৱমুন্নমযতি স নমযিষ্যতে, কিন্তু যঃ কশ্চিৎ স্ৱং নমযতি স উন্নমযিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","তদা স নিমন্ত্রযিতারং জনমপি জগাদ, মধ্যাহ্নে রাত্রৌ ৱা ভোজ্যে কৃতে নিজবন্ধুগণো ৱা ভ্রাতৃृগণো ৱা জ্ঞাতিগণো ৱা ধনিগণো ৱা সমীপৱাসিগণো ৱা এতান্ ন নিমন্ত্রয, তথা কৃতে চেৎ তে ৎৱাং নিমন্ত্রযিষ্যন্তি, তর্হি পরিশোধো ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","কিন্তু যদা ভেজ্যং করোষি তদা দরিদ্রশুষ্ককরখঞ্জান্ধান্ নিমন্ত্রয, ");
INSERT INTO sanben_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","তত আশিষং লপ্স্যসে, তেষু পরিশোধং কর্ত্তুমশক্নুৱৎসু শ্মশানাদ্ধার্ম্মিকানামুত্থানকালে ৎৱং ফলাং লপ্স্যসে| ");
INSERT INTO sanben_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","অনন্তরং তাং কথাং নিশম্য ভোজনোপৱিষ্টঃ কশ্চিৎ কথযামাস, যো জন ঈশ্ৱরস্য রাজ্যে ভোক্তুং লপ্স্যতে সএৱ ধন্যঃ| ");
INSERT INTO sanben_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ততঃ স উৱাচ, কশ্চিৎ জনো রাত্রৌ ভেाজ্যং কৃৎৱা বহূন্ নিমন্ত্রযামাস| ");
INSERT INTO sanben_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ততো ভোজনসমযে নিমন্ত্রিতলোকান্ আহ্ৱাতুং দাসদ্ৱারা কথযামাস, খদ্যদ্রৱ্যাণি সর্ৱ্ৱাণি সমাসাদিতানি সন্তি, যূযমাগচ্ছত| ");
INSERT INTO sanben_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","কিন্তু তে সর্ৱ্ৱ একৈকং ছলং কৃৎৱা ক্ষমাং প্রার্থযাঞ্চক্রিরে| প্রথমো জনঃ কথযামাস, ক্ষেত্রমেকং ক্রীতৱানহং তদেৱ দ্রষ্টুং মযা গন্তৱ্যম্, অতএৱ মাং ক্ষন্তুং তং নিৱেদয| ");
INSERT INTO sanben_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","অন্যো জনঃ কথযামাস, দশৱৃষানহং ক্রীতৱান্ তান্ পরীক্ষিতুং যামি তস্মাদেৱ মাং ক্ষন্তুং তং নিৱেদয| ");
INSERT INTO sanben_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","অপরঃ কথযামাস, ৱ্যূঢৱানহং তস্মাৎ কারণাদ্ যাতুং ন শক্নোমি| ");
INSERT INTO sanben_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","পশ্চাৎ স দাসো গৎৱা নিজপ্রভোঃ সাক্ষাৎ সর্ৱ্ৱৱৃত্তান্তং নিৱেদযামাস, ততোসৌ গৃহপতিঃ কুপিৎৱা স্ৱদাসং ৱ্যাজহার, ৎৱং সৎৱরং নগরস্য সন্নিৱেশান্ মার্গাংশ্চ গৎৱা দরিদ্রশুষ্ককরখঞ্জান্ধান্ অত্রানয| ");
INSERT INTO sanben_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","ততো দাসোঽৱদৎ, হে প্রভো ভৱত আজ্ঞানুসারেণাক্রিযত তথাপি স্থানমস্তি| ");
INSERT INTO sanben_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","তদা প্রভুঃ পুন র্দাসাযাকথযৎ, রাজপথান্ ৱৃক্ষমূলানি চ যাৎৱা মদীযগৃহপূরণার্থং লোকানাগন্তুং প্রৱর্ত্তয| ");
INSERT INTO sanben_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","অহং যুষ্মভ্যং কথযামি, পূর্ৱ্ৱনিমন্ত্রিতানমেকোপি মমাস্য রাত্রিভোজ্যস্যাস্ৱাদং ন প্রাপ্স্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","অনন্তরং বহুষু লোকেষু যীশোঃ পশ্চাদ্ ৱ্রজিতেষু সৎসু স ৱ্যাঘুট্য তেভ্যঃ কথযামাস, ");
INSERT INTO sanben_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","যঃ কশ্চিন্ মম সমীপম্ আগত্য স্ৱস্য মাতা পিতা পত্নী সন্তানা ভ্রাতরো ভগিম্যো নিজপ্রাণাশ্চ, এতেভ্যঃ সর্ৱ্ৱেভ্যো ময্যধিকং প্রেম ন করোতি, স মম শিষ্যো ভৱিতুং ন শক্ষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","যঃ কশ্চিৎ স্ৱীযং ক্রুশং ৱহন্ মম পশ্চান্ন গচ্ছতি, সোপি মম শিষ্যো ভৱিতুং ন শক্ষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","দুর্গনির্ম্মাণে কতিৱ্যযো ভৱিষ্যতি, তথা তস্য সমাপ্তিকরণার্থং সম্পত্তিরস্তি ন ৱা, প্রথমমুপৱিশ্য এতন্ন গণযতি, যুষ্মাকং মধ্য এতাদৃশঃ কোস্তি? ");
INSERT INTO sanben_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","নোচেদ্ ভিত্তিং কৃৎৱা শেষে যদি সমাপযিতুং ন শক্ষ্যতি, ");
INSERT INTO sanben_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","তর্হি মানুষোযং নিচেতুম্ আরভত সমাপযিতুং নাশক্নোৎ, ইতি ৱ্যাহৃত্য সর্ৱ্ৱে তমুপহসিষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","অপরঞ্চ ভিন্নভূপতিনা সহ যুদ্ধং কর্ত্তুম্ উদ্যম্য দশসহস্রাণি সৈন্যানি গৃহীৎৱা ৱিংশতিসহস্রেঃ সৈন্যৈঃ সহিতস্য সমীপৱাসিনঃ সম্মুখং যাতুং শক্ষ্যামি ন ৱেতি প্রথমং উপৱিশ্য ন ৱিচারযতি এতাদৃশো ভূমিপতিঃ কঃ? ");
INSERT INTO sanben_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","যদি ন শক্নোতি তর্হি রিপাৱতিদূরে তিষ্ঠতি সতি নিজদূতং প্রেষ্য সন্ধিং কর্ত্তুং প্রার্থযেত| ");
INSERT INTO sanben_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","তদ্ৱদ্ যুষ্মাকং মধ্যে যঃ কশ্চিন্ মদর্থং সর্ৱ্ৱস্ৱং হাতুং ন শক্নোতি স মম শিষ্যো ভৱিতুং ন শক্ষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","লৱণম্ উত্তমম্ ইতি সত্যং, কিন্তু যদি লৱণস্য লৱণৎৱম্ অপগচ্ছতি তর্হি তৎ কথং স্ৱাদুযুক্তং ভৱিষ্যতি? ");
INSERT INTO sanben_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","তদ ভূম্যর্থম্ আলৱালরাশ্যর্থমপি ভদ্রং ন ভৱতি; লোকাস্তদ্ বহিঃ ক্ষিপন্তি| যস্য শ্রোতুং শ্রোত্রে স্তঃ স শৃণোতু| ");
INSERT INTO sanben_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","তদা করসঞ্চাযিনঃ পাপিনশ্চ লোকা উপদেশ্কথাং শ্রোতুং যীশোঃ সমীপম্ আগচ্ছন্| ");
INSERT INTO sanben_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ততঃ ফিরূশিন উপাধ্যাযাশ্চ ৱিৱদমানাঃ কথযামাসুঃ এষ মানুষঃ পাপিভিঃ সহ প্রণযং কৃৎৱা তৈঃ সার্দ্ধং ভুংক্তে| ");
INSERT INTO sanben_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","তদা স তেভ্য ইমাং দৃষ্টান্তকথাং কথিতৱান্, ");
INSERT INTO sanben_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","কস্যচিৎ শতমেষেষু তিষ্ঠত্মু তেষামেকং স যদি হারযতি তর্হি মধ্যেপ্রান্তরম্ একোনশতমেষান্ ৱিহায হারিতমেষস্য উদ্দেশপ্রাপ্তিপর্য্যনতং ন গৱেষযতি, এতাদৃশো লোকো যুষ্মাকং মধ্যে ক আস্তে? ");
INSERT INTO sanben_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","তস্যোদ্দেশং প্রাপ্য হৃষ্টমনাস্তং স্কন্ধে নিধায স্ৱস্থানম্ আনীয বন্ধুবান্ধৱসমীপৱাসিন আহূয ৱক্তি, ");
INSERT INTO sanben_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","হারিতং মেষং প্রাপ্তোহম্ অতো হেতো র্মযা সার্দ্ধম্ আনন্দত| ");
INSERT INTO sanben_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","তদ্ৱদহং যুষ্মান্ ৱদামি, যেষাং মনঃপরাৱর্ত্তনস্য প্রযোজনং নাস্তি, তাদৃশৈকোনশতধার্ম্মিককারণাদ্ য আনন্দস্তস্মাদ্ একস্য মনঃপরিৱর্ত্তিনঃ পাপিনঃ কারণাৎ স্ৱর্গে ঽধিকানন্দো জাযতে| ");
INSERT INTO sanben_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","অপরঞ্চ দশানাং রূপ্যখণ্ডানাম্ একখণ্ডে হারিতে প্রদীপং প্রজ্ৱাল্য গৃহং সম্মার্জ্য তস্য প্রাপ্তিং যাৱদ্ যত্নেন ন গৱেষযতি, এতাদৃশী যোষিৎ কাস্তে? ");
INSERT INTO sanben_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","প্রাপ্তে সতি বন্ধুবান্ধৱসমীপৱাসিনীরাহূয কথযতি, হারিতং রূপ্যখণ্ডং প্রাপ্তাহং তস্মাদেৱ মযা সার্দ্ধম্ আনন্দত| ");
INSERT INTO sanben_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","তদ্ৱদহং যুষ্মান্ ৱ্যাহরামি, একেন পাপিনা মনসি পরিৱর্ত্তিতে, ঈশ্ৱরস্য দূতানাং মধ্যেপ্যানন্দো জাযতে| ");
INSERT INTO sanben_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","অপরঞ্চ স কথযামাস, কস্যচিদ্ দ্ৱৌ পুত্রাৱাস্তাং, ");
INSERT INTO sanben_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","তযোঃ কনিষ্ঠঃ পুত্রঃ পিত্রে কথযামাস, হে পিতস্তৱ সম্পত্ত্যা যমংশং প্রাপ্স্যাম্যহং ৱিভজ্য তং দেহি, ততঃ পিতা নিজাং সম্পত্তিং ৱিভজ্য তাভ্যাং দদৌ| ");
INSERT INTO sanben_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","কতিপযাৎ কালাৎ পরং স কনিষ্ঠপুত্রঃ সমস্তং ধনং সংগৃহ্য দূরদেশং গৎৱা দুষ্টাচরণেন সর্ৱ্ৱাং সম্পত্তিং নাশযামাস| ");
INSERT INTO sanben_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","তস্য সর্ৱ্ৱধনে ৱ্যযং গতে তদ্দেশে মহাদুর্ভিক্ষং বভূৱ, ততস্তস্য দৈন্যদশা ভৱিতুম্ আরেভে| ");
INSERT INTO sanben_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ততঃ পরং স গৎৱা তদ্দেশীযং গৃহস্থমেকম্ আশ্রযত; ততঃ সতং শূকরৱ্রজং চারযিতুং প্রান্তরং প্রেষযামাস| ");
INSERT INTO sanben_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","কেনাপি তস্মৈ ভক্ষ্যাদানাৎ স শূকরফলৱল্কলেন পিচিণ্ডপূরণাং ৱৱাঞ্ছ| ");
INSERT INTO sanben_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","শেষে স মনসি চেতনাং প্রাপ্য কথযামাস, হা মম পিতুঃ সমীপে কতি কতি ৱেতনভুজো দাসা যথেষ্টং ততোধিকঞ্চ ভক্ষ্যং প্রাপ্নুৱন্তি কিন্ত্ৱহং ক্ষুধা মুমূর্ষুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","অহমুত্থায পিতুঃ সমীপং গৎৱা কথামেতাং ৱদিষ্যামি, হে পিতর্ ঈশ্ৱরস্য তৱ চ ৱিরুদ্ধং পাপমকরৱম্ ");
INSERT INTO sanben_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","তৱ পুত্রইতি ৱিখ্যাতো ভৱিতুং ন যোগ্যোস্মি চ, মাং তৱ ৱৈতনিকং দাসং কৃৎৱা স্থাপয| ");
INSERT INTO sanben_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","পশ্চাৎ স উত্থায পিতুঃ সমীপং জগাম; ততস্তস্য পিতাতিদূরে তং নিরীক্ষ্য দযাঞ্চক্রে, ধাৱিৎৱা তস্য কণ্ঠং গৃহীৎৱা তং চুচুম্ব চ| ");
INSERT INTO sanben_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","তদা পুত্র উৱাচ, হে পিতর্ ঈশ্ৱরস্য তৱ চ ৱিরুদ্ধং পাপমকরৱং, তৱ পুত্রইতি ৱিখ্যাতো ভৱিতুং ন যোগ্যোস্মি চ| ");
INSERT INTO sanben_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","কিন্তু তস্য পিতা নিজদাসান্ আদিদেশ, সর্ৱ্ৱোত্তমৱস্ত্রাণ্যানীয পরিধাপযতৈনং হস্তে চাঙ্গুরীযকম্ অর্পযত পাদযোশ্চোপানহৌ সমর্পযত; ");
INSERT INTO sanben_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","পুষ্টং গোৱৎসম্ আনীয মারযত চ তং ভুক্ত্ৱা ৱযম্ আনন্দাম| ");
INSERT INTO sanben_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","যতো মম পুত্রোযম্ অম্রিযত পুনরজীৱীদ্ হারিতশ্চ লব্ধোভূৎ ততস্ত আনন্দিতুম্ আরেভিরে| ");
INSERT INTO sanben_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","তৎকালে তস্য জ্যেষ্ঠঃ পুত্রঃ ক্ষেত্র আসীৎ| অথ স নিৱেশনস্য নিকটং আগচ্ছন্ নৃত্যানাং ৱাদ্যানাঞ্চ শব্দং শ্রুৎৱা ");
INSERT INTO sanben_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","দাসানাম্ একম্ আহূয পপ্রচ্ছ, কিং কারণমস্য? ");
INSERT INTO sanben_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","ততঃ সোৱাদীৎ, তৱ ভ্রাতাগমৎ, তৱ তাতশ্চ তং সুশরীরং প্রাপ্য পুষ্টং গোৱৎসং মারিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","ততঃ স প্রকুপ্য নিৱেশনান্তঃ প্রৱেষ্টুং ন সম্মেনে; ততস্তস্য পিতা বহিরাগত্য তং সাধযামাস| ");
INSERT INTO sanben_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ততঃ স পিতরং প্রত্যুৱাচ, পশ্য তৱ কাঞ্চিদপ্যাজ্ঞাং ন ৱিলংঘ্য বহূন্ ৱৎসরান্ অহং ৎৱাং সেৱে তথাপি মিত্রৈঃ সার্দ্ধম্ উৎসৱং কর্ত্তুং কদাপি ছাগমেকমপি মহ্যং নাদদাঃ; ");
INSERT INTO sanben_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","কিন্তু তৱ যঃ পুত্রো ৱেশ্যাগমনাদিভিস্তৱ সম্পত্তিম্ অপৱ্যযিতৱান্ তস্মিন্নাগতমাত্রে তস্যৈৱ নিমিত্তং পুষ্টং গোৱৎসং মারিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","তদা তস্য পিতাৱোচৎ, হে পুত্র ৎৱং সর্ৱ্ৱদা মযা সহাসি তস্মান্ মম যদ্যদাস্তে তৎসর্ৱ্ৱং তৱ| ");
INSERT INTO sanben_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","কিন্তু তৱাযং ভ্রাতা মৃতঃ পুনরজীৱীদ্ হারিতশ্চ ভূৎৱা প্রাপ্তোভূৎ, এতস্মাৎ কারণাদ্ উৎসৱানন্দৌ কর্ত্তুম্ উচিতমস্মাকম্| ");
INSERT INTO sanben_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","অপরঞ্চ যীশুঃ শিষ্যেভ্যোন্যামেকাং কথাং কথযামাস কস্যচিদ্ ধনৱতো মনুষ্যস্য গৃহকার্য্যাধীশে সম্পত্তেরপৱ্যযেঽপৱাদিতে সতি ");
INSERT INTO sanben_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","তস্য প্রভুস্তম্ আহূয জগাদ, ৎৱযি যামিমাং কথাং শৃণোমি সা কীদৃশী? ৎৱং গৃহকার্য্যাধীশকর্ম্মণো গণনাং দর্শয গৃহকার্য্যাধীশপদে ৎৱং ন স্থাস্যসি| ");
INSERT INTO sanben_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","তদা স গৃহকার্য্যাধীশো মনসা চিন্তযামাস, প্রভু র্যদি মাং গৃহকার্য্যাধীশপদাদ্ ভ্রংশযতি তর্হি কিং করিষ্যেঽহং? মৃদং খনিতুং মম শক্তি র্নাস্তি ভিক্ষিতুঞ্চ লজ্জিষ্যেঽহং| ");
INSERT INTO sanben_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","অতএৱ মযি গৃহকার্য্যাধীশপদাৎ চ্যুতে সতি যথা লোকা মহ্যম্ আশ্রযং দাস্যন্তি তদর্থং যৎকর্ম্ম মযা করণীযং তন্ নির্ণীযতে| ");
INSERT INTO sanben_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","পশ্চাৎ স স্ৱপ্রভোরেকৈকম্ অধমর্ণম্ আহূয প্রথমং পপ্রচ্ছ, ৎৱত্তো মে প্রভুণা কতি প্রাপ্যম্? ");
INSERT INTO sanben_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ততঃ স উৱাচ, একশতাঢকতৈলানি; তদা গৃহকার্য্যাধীশঃ প্রোৱাচ, তৱ পত্রমানীয শীঘ্রমুপৱিশ্য তত্র পঞ্চাশতং লিখ| ");
INSERT INTO sanben_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","পশ্চাদন্যমেকং পপ্রচ্ছ, ৎৱত্তো মে প্রভুণা কতি প্রাপ্যম্? ততঃ সোৱাদীদ্ একশতাঢকগোধূমাঃ; তদা স কথযামাস, তৱ পত্রমানীয অশীতিং লিখ| ");
INSERT INTO sanben_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","তেনৈৱ প্রভুস্তমযথার্থকৃতম্ অধীশং তদ্বুদ্ধিনৈপুণ্যাৎ প্রশশংস; ইত্থং দীপ্তিরূপসন্তানেভ্য এতৎসংসারস্য সন্তানা ৱর্ত্তমানকালেঽধিকবুদ্ধিমন্তো ভৱন্তি| ");
INSERT INTO sanben_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","অতো ৱদামি যূযমপ্যযথার্থেন ধনেন মিত্রাণি লভধ্ৱং ততো যুষ্মাসু পদভ্রষ্টেষ্ৱপি তানি চিরকালম্ আশ্রযং দাস্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","যঃ কশ্চিৎ ক্ষুদ্রে কার্য্যে ৱিশ্ৱাস্যো ভৱতি স মহতি কার্য্যেপি ৱিশ্ৱাস্যো ভৱতি, কিন্তু যঃ কশ্চিৎ ক্ষুদ্রে কার্য্যেঽৱিশ্ৱাস্যো ভৱতি স মহতি কার্য্যেপ্যৱিশ্ৱাস্যো ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","অতএৱ অযথার্থেন ধনেন যদি যূযমৱিশ্ৱাস্যা জাতাস্তর্হি সত্যং ধনং যুষ্মাকং করেষু কঃ সমর্পযিষ্যতি? ");
INSERT INTO sanben_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","যদি চ পরধনেন যূযম্ অৱিশ্ৱাস্যা ভৱথ তর্হি যুষ্মাকং স্ৱকীযধনং যুষ্মভ্যং কো দাস্যতি? ");
INSERT INTO sanben_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","কোপি দাস উভৌ প্রভূ সেৱিতুং ন শক্নোতি, যত একস্মিন্ প্রীযমাণোঽন্যস্মিন্নপ্রীযতে যদ্ৱা একং জনং সমাদৃত্য তদন্যং তুচ্ছীকরোতি তদ্ৱদ্ যূযমপি ধনেশ্ৱরৌ সেৱিতুং ন শক্নুথ| ");
INSERT INTO sanben_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","তদৈতাঃ সর্ৱ্ৱাঃ কথাঃ শ্রুৎৱা লোভিফিরূশিনস্তমুপজহসুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ততঃ স উৱাচ, যূযং মনুষ্যাণাং নিকটে স্ৱান্ নির্দোষান্ দর্শযথ কিন্তু যুষ্মাকম্ অন্তঃকরণানীশ্ৱরো জানাতি, যৎ মনুষ্যাণাম্ অতি প্রশংস্যং তদ্ ঈশ্ৱরস্য ঘৃণ্যং| ");
INSERT INTO sanben_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","যোহন আগমনপর্য্যনতং যুষ্মাকং সমীপে ৱ্যৱস্থাভৱিষ্যদ্ৱাদিনাং লেখনানি চাসন্ ততঃ প্রভৃতি ঈশ্ৱররাজ্যস্য সুসংৱাদঃ প্রচরতি, একৈকো লোকস্তন্মধ্যং যত্নেন প্রৱিশতি চ| ");
INSERT INTO sanben_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ৱরং নভসঃ পৃথিৱ্যাশ্চ লোপো ভৱিষ্যতি তথাপি ৱ্যৱস্থাযা একবিন্দোরপি লোপো ন ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","যঃ কশ্চিৎ স্ৱীযাং ভার্য্যাং ৱিহায স্ত্রিযমন্যাং ৱিৱহতি স পরদারান্ গচ্ছতি, যশ্চ তা ত্যক্তাং নারীং ৱিৱহতি সোপি পরদারান গচ্ছতি| ");
INSERT INTO sanben_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","একো ধনী মনুষ্যঃ শুক্লানি সূক্ষ্মাণি ৱস্ত্রাণি পর্য্যদধাৎ প্রতিদিনং পরিতোষরূপেণাভুংক্তাপিৱচ্চ| ");
INSERT INTO sanben_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","সর্ৱ্ৱাঙ্গে ক্ষতযুক্ত ইলিযাসরনামা কশ্চিদ্ দরিদ্রস্তস্য ধনৱতো ভোজনপাত্রাৎ পতিতম্ উচ্ছিষ্টং ভোক্তুং ৱাঞ্ছন্ তস্য দ্ৱারে পতিৎৱাতিষ্ঠৎ; ");
INSERT INTO sanben_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","অথ শ্ৱান আগত্য তস্য ক্ষতান্যলিহন্| ");
INSERT INTO sanben_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","কিযৎকালাৎপরং স দরিদ্রঃ প্রাণান্ জহৌ; ততঃ স্ৱর্গীযদূতাস্তং নীৎৱা ইব্রাহীমঃ ক্রোড উপৱেশযামাসুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","পশ্চাৎ স ধনৱানপি মমার, তং শ্মশানে স্থাপযামাসুশ্চ; কিন্তু পরলোকে স ৱেদনাকুলঃ সন্ ঊর্দ্ধ্ৱাং নিরীক্ষ্য বহুদূরাদ্ ইব্রাহীমং তৎক্রোড ইলিযাসরঞ্চ ৱিলোক্য রুৱন্নুৱাচ; ");
INSERT INTO sanben_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","হে পিতর্ ইব্রাহীম্ অনুগৃহ্য অঙ্গুল্যগ্রভাগং জলে মজ্জযিৎৱা মম জিহ্ৱাং শীতলাং কর্ত্তুম্ ইলিযাসরং প্রেরয, যতো ৱহ্নিশিখাতোহং ৱ্যথিতোস্মি| ");
INSERT INTO sanben_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","তদা ইব্রাহীম্ বভাষে, হে পুত্র ৎৱং জীৱন্ সম্পদং প্রাপ্তৱান্ ইলিযাসরস্তু ৱিপদং প্রাপ্তৱান্ এতৎ স্মর, কিন্তু সম্প্রতি তস্য সুখং তৱ চ দুঃখং ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","অপরমপি যুষ্মাকম্ অস্মাকঞ্চ স্থানযো র্মধ্যে মহদ্ৱিচ্ছেদোঽস্তি তত এতৎস্থানস্য লোকাস্তৎ স্থানং যাতুং যদ্ৱা তৎস্থানস্য লোকা এতৎ স্থানমাযাতুং ন শক্নুৱন্তি| ");
INSERT INTO sanben_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","তদা স উক্তৱান্, হে পিতস্তর্হি ৎৱাং নিৱেদযামি মম পিতু র্গেহে যে মম পঞ্চ ভ্রাতরঃ সন্তি ");
INSERT INTO sanben_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","তে যথৈতদ্ যাতনাস্থানং নাযাস্যন্তি তথা মন্ত্রণাং দাতুং তেষাং সমীপম্ ইলিযাসরং প্রেরয| ");
INSERT INTO sanben_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","তত ইব্রাহীম্ উৱাচ, মূসাভৱিষ্যদ্ৱাদিনাঞ্চ পুস্তকানি তেষাং নিকটে সন্তি তে তদ্ৱচনানি মন্যন্তাং| ");
INSERT INTO sanben_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","তদা স নিৱেদযামাস, হে পিতর্ ইব্রাহীম্ ন তথা, কিন্তু যদি মৃতলোকানাং কশ্চিৎ তেষাং সমীপং যাতি তর্হি তে মনাংসি ৱ্যাঘোটযিষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","তত ইব্রাহীম্ জগাদ, তে যদি মূসাভৱিষ্যদ্ৱাদিনাঞ্চ ৱচনানি ন মন্যন্তে তর্হি মৃতলোকানাং কস্মিংশ্চিদ্ উত্থিতেপি তে তস্য মন্ত্রণাং ন মংস্যন্তে| ");
INSERT INTO sanben_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ইতঃ পরং যীশুঃ শিষ্যান্ উৱাচ, ৱিঘ্নৈরৱশ্যম্ আগন্তৱ্যং কিন্তু ৱিঘ্না যেন ঘটিষ্যন্তে তস্য দুর্গতি র্ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","এতেষাং ক্ষুদ্রপ্রাণিনাম্ একস্যাপি ৱিঘ্নজননাৎ কণ্ঠবদ্ধপেষণীকস্য তস্য সাগরাগাধজলে মজ্জনং ভদ্রং| ");
INSERT INTO sanben_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","যূযং স্ৱেষু সাৱধানাস্তিষ্ঠত; তৱ ভ্রাতা যদি তৱ কিঞ্চিদ্ অপরাধ্যতি তর্হি তং তর্জয, তেন যদি মনঃ পরিৱর্ত্তযতি তর্হি তং ক্ষমস্ৱ| ");
INSERT INTO sanben_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","পুনরেকদিনমধ্যে যদি স তৱ সপ্তকৃৎৱোঽপরাধ্যতি কিন্তু সপ্তকৃৎৱ আগত্য মনঃ পরিৱর্ত্য মযাপরাদ্ধম্ ইতি ৱদতি তর্হি তং ক্ষমস্ৱ| ");
INSERT INTO sanben_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","তদা প্রেরিতাঃ প্রভুম্ অৱদন্ অস্মাকং ৱিশ্ৱাসং ৱর্দ্ধয| ");
INSERT INTO sanben_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","প্রভুরুৱাচ, যদি যুষ্মাকং সর্ষপৈকপ্রমাণো ৱিশ্ৱাসোস্তি তর্হি ৎৱং সমূলমুৎপাটিতো ভূৎৱা সমুদ্রে রোপিতো ভৱ কথাযাম্ এতস্যাম্ এতদুডুম্বরায কথিতাযাং স যুষ্মাকমাজ্ঞাৱহো ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","অপরং স্ৱদাসে হলং ৱাহযিৎৱা ৱা পশূন্ চারযিৎৱা ক্ষেত্রাদ্ আগতে সতি তং ৱদতি, এহি ভোক্তুমুপৱিশ, যুষ্মাকম্ এতাদৃশঃ কোস্তি? ");
INSERT INTO sanben_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ৱরঞ্চ পূর্ৱ্ৱং মম খাদ্যমাসাদ্য যাৱদ্ ভুঞ্জে পিৱামি চ তাৱদ্ বদ্ধকটিঃ পরিচর পশ্চাৎ ৎৱমপি ভোক্ষ্যসে পাস্যসি চ কথামীদৃশীং কিং ন ৱক্ষ্যতি? ");
INSERT INTO sanben_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","তেন দাসেন প্রভোরাজ্ঞানুরূপে কর্ম্মণি কৃতে প্রভুঃ কিং তস্মিন্ বাধিতো জাতঃ? নেত্থং বুধ্যতে মযা| ");
INSERT INTO sanben_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ইত্থং নিরূপিতেষু সর্ৱ্ৱকর্ম্মসু কৃতেষু সত্মু যূযমপীদং ৱাক্যং ৱদথ, ৱযম্ অনুপকারিণো দাসা অস্মাভির্যদ্যৎকর্ত্তৱ্যং তন্মাত্রমেৱ কৃতং| ");
INSERT INTO sanben_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","স যিরূশালমি যাত্রাং কুর্ৱ্ৱন্ শোমিরোণ্গালীল্প্রদেশমধ্যেন গচ্ছতি, ");
INSERT INTO sanben_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","এতর্হি কুত্রচিদ্ গ্রামে প্রৱেশমাত্রে দশকুষ্ঠিনস্তং সাক্ষাৎ কৃৎৱা ");
INSERT INTO sanben_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","দূরে তিষ্ঠনত উচ্চৈ র্ৱক্তুমারেভিরে, হে প্রভো যীশো দযস্ৱাস্মান্| ");
INSERT INTO sanben_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ততঃ স তান্ দৃষ্ট্ৱা জগাদ, যূযং যাজকানাং সমীপে স্ৱান্ দর্শযত, ততস্তে গচ্ছন্তো রোগাৎ পরিষ্কৃতাঃ| ");
INSERT INTO sanben_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","তদা তেষামেকঃ স্ৱং স্ৱস্থং দৃষ্ট্ৱা প্রোচ্চৈরীশ্ৱরং ধন্যং ৱদন্ ৱ্যাঘুট্যাযাতো যীশো র্গুণাননুৱদন্ তচ্চরণাধোভূমৌ পপাত; ");
INSERT INTO sanben_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","স চাসীৎ শোমিরোণী| ");
INSERT INTO sanben_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","তদা যীশুরৱদৎ, দশজনাঃ কিং ন পরিষ্কৃতাঃ? তহ্যন্যে নৱজনাঃ কুত্র? ");
INSERT INTO sanben_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ঈশ্ৱরং ধন্যং ৱদন্তম্ এনং ৱিদেশিনং ৱিনা কোপ্যন্যো ন প্রাপ্যত| ");
INSERT INTO sanben_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","তদা স তমুৱাচ, ৎৱমুত্থায যাহি ৱিশ্ৱাসস্তে ৎৱাং স্ৱস্থং কৃতৱান্| ");
INSERT INTO sanben_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","অথ কদেশ্ৱরস্য রাজৎৱং ভৱিষ্যতীতি ফিরূশিভিঃ পৃষ্টে স প্রত্যুৱাচ, ঈশ্ৱরস্য রাজৎৱম্ ঐশ্ৱর্য্যদর্শনেন ন ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","অত এতস্মিন্ পশ্য তস্মিন্ ৱা পশ্য, ইতি ৱাক্যং লোকা ৱক্তুং ন শক্ষ্যন্তি, ঈশ্ৱরস্য রাজৎৱং যুষ্মাকম্ অন্তরেৱাস্তে| ");
INSERT INTO sanben_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ততঃ স শিষ্যান্ জগাদ, যদা যুষ্মাভি র্মনুজসুতস্য দিনমেকং দ্রষ্টুম্ ৱাঞ্ছিষ্যতে কিন্তু ন দর্শিষ্যতে, ঈদৃক্কাল আযাতি| ");
INSERT INTO sanben_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","তদাত্র পশ্য ৱা তত্র পশ্যেতি ৱাক্যং লোকা ৱক্ষ্যন্তি, কিন্তু তেষাং পশ্চাৎ মা যাত, মানুগচ্ছত চ| ");
INSERT INTO sanben_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","যতস্তডিদ্ যথাকাশৈকদিশ্যুদিয তদন্যামপি দিশং ৱ্যাপ্য প্রকাশতে তদ্ৱৎ নিজদিনে মনুজসূনুঃ প্রকাশিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","কিন্তু তৎপূর্ৱ্ৱং তেনানেকানি দুঃখানি ভোক্তৱ্যান্যেতদ্ৱর্ত্তমানলোকৈশ্চ সোঽৱজ্ঞাতৱ্যঃ| ");
INSERT INTO sanben_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","নোহস্য ৱিদ্যমানকালে যথাভৱৎ মনুষ্যসূনোঃ কালেপি তথা ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","যাৱৎকালং নোহো মহাপোতং নারোহদ্ আপ্লাৱিৱার্য্যেত্য সর্ৱ্ৱং নানাশযচ্চ তাৱৎকালং যথা লোকা অভুঞ্জতাপিৱন্ ৱ্যৱহন্ ৱ্যৱাহযংশ্চ; ");
INSERT INTO sanben_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ইত্থং লোটো ৱর্ত্তমানকালেপি যথা লোকা ভোজনপানক্রযৱিক্রযরোপণগৃহনির্ম্মাণকর্ম্মসু প্রাৱর্ত্তন্ত, ");
INSERT INTO sanben_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","কিন্তু যদা লোট্ সিদোমো নির্জগাম তদা নভসঃ সগন্ধকাগ্নিৱৃষ্টি র্ভূৎৱা সর্ৱ্ৱং ৱ্যনাশযৎ ");
INSERT INTO sanben_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","তদ্ৱন্ মানৱপুত্রপ্রকাশদিনেপি ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","তদা যদি কশ্চিদ্ গৃহোপরি তিষ্ঠতি তর্হি স গৃহমধ্যাৎ কিমপি দ্রৱ্যমানেতুম্ অৱরুহ্য নৈতু; যশ্চ ক্ষেত্রে তিষ্ঠতি সোপি ৱ্যাঘুট্য নাযাতু| ");
INSERT INTO sanben_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","লোটঃ পত্নীং স্মরত| ");
INSERT INTO sanben_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","যঃ প্রাণান্ রক্ষিতুং চেষ্টিষ্যতে স প্রাণান্ হারযিষ্যতি যস্তু প্রাণান্ হারযিষ্যতি সএৱ প্রাণান্ রক্ষিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","যুষ্মানহং ৱচ্মি তস্যাং রাত্রৌ শয্যৈকগতযো র্লোকযোরেকো ধারিষ্যতে পরস্ত্যক্ষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","স্ত্রিযৌ যুগপৎ পেষণীং ৱ্যাৱর্ত্তযিষ্যতস্তযোরেকা ধারিষ্যতে পরাত্যক্ষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","পুরুষৌ ক্ষেত্রে স্থাস্যতস্তযোরেকো ধারিষ্যতে পরস্ত্যক্ষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","তদা তে পপ্রচ্ছুঃ, হে প্রভো কুত্রেত্থং ভৱিষ্যতি? ততঃ স উৱাচ, যত্র শৱস্তিষ্ঠতি তত্র গৃধ্রা মিলন্তি| ");
INSERT INTO sanben_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","অপরঞ্চ লোকৈরক্লান্তৈ র্নিরন্তরং প্রার্থযিতৱ্যম্ ইত্যাশযেন যীশুনা দৃষ্টান্ত একঃ কথিতঃ| ");
INSERT INTO sanben_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","কুত্রচিন্নগরে কশ্চিৎ প্রাড্ৱিৱাক আসীৎ স ঈশ্ৱরান্নাবিভেৎ মানুষাংশ্চ নামন্যত| ");
INSERT INTO sanben_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","অথ তৎপুরৱাসিনী কাচিদ্ৱিধৱা তৎসমীপমেত্য ৱিৱাদিনা সহ মম ৱিৱাদং পরিষ্কুর্ৱ্ৱিতি নিৱেদযামাস| ");
INSERT INTO sanben_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ততঃ স প্রাড্ৱিৱাকঃ কিযদ্দিনানি ন তদঙ্গীকৃতৱান্ পশ্চাচ্চিত্তে চিন্তযামাস, যদ্যপীশ্ৱরান্ন বিভেমি মনুষ্যানপি ন মন্যে ");
INSERT INTO sanben_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","তথাপ্যেষা ৱিধৱা মাং ক্লিশ্নাতি তস্মাদস্যা ৱিৱাদং পরিষ্করিষ্যামি নোচেৎ সা সদাগত্য মাং ৱ্যগ্রং করিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","পশ্চাৎ প্রভুরৱদদ্ অসাৱন্যাযপ্রাড্ৱিৱাকো যদাহ তত্র মনো নিধধ্ৱং| ");
INSERT INTO sanben_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ঈশ্ৱরস্য যে ঽভিরুচিতলোকা দিৱানিশং প্রার্থযন্তে স বহুদিনানি ৱিলম্ব্যাপি তেষাং ৱিৱাদান্ কিং ন পরিষ্করিষ্যতি? ");
INSERT INTO sanben_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","যুষ্মানহং ৱদামি ৎৱরযা পরিষ্করিষ্যতি, কিন্তু যদা মনুষ্যপুত্র আগমিষ্যতি তদা পৃথিৱ্যাং কিমীদৃশং ৱিশ্ৱাসং প্রাপ্স্যতি? ");
INSERT INTO sanben_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","যে স্ৱান্ ধার্ম্মিকান্ জ্ঞাৎৱা পরান্ তুচ্ছীকুর্ৱ্ৱন্তি এতাদৃগ্ভ্যঃ, কিযদ্ভ্য ইমং দৃষ্টান্তং কথযামাস| ");
INSERT INTO sanben_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","একঃ ফিরূশ্যপরঃ করসঞ্চাযী দ্ৱাৱিমৌ প্রার্থযিতুং মন্দিরং গতৌ| ");
INSERT INTO sanben_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ততোঽসৌ ফিরূশ্যেকপার্শ্ৱে তিষ্ঠন্ হে ঈশ্ৱর অহমন্যলোকৱৎ লোঠযিতান্যাযী পারদারিকশ্চ ন ভৱামি অস্য করসঞ্চাযিনস্তুল্যশ্চ ন, তস্মাত্ত্ৱাং ধন্যং ৱদামি| ");
INSERT INTO sanben_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","সপ্তসু দিনেষু দিনদ্ৱযমুপৱসামি সর্ৱ্ৱসম্পত্তে র্দশমাংশং দদামি চ, এতৎকথাং কথযন্ প্রার্থযামাস| ");
INSERT INTO sanben_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","কিন্তু স করসঞ্চাযি দূরে তিষ্ঠন্ স্ৱর্গং দ্রষ্টুং নেচ্ছন্ ৱক্ষসি করাঘাতং কুর্ৱ্ৱন্ হে ঈশ্ৱর পাপিষ্ঠং মাং দযস্ৱ, ইত্থং প্রার্থযামাস| ");
INSERT INTO sanben_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","যুষ্মানহং ৱদামি, তযোর্দ্ৱযো র্মধ্যে কেৱলঃ করসঞ্চাযী পুণ্যৱত্ত্ৱেন গণিতো নিজগৃহং জগাম, যতো যঃ কশ্চিৎ স্ৱমুন্নমযতি স নামযিষ্যতে কিন্তু যঃ কশ্চিৎ স্ৱং নমযতি স উন্নমযিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","অথ শিশূনাং গাত্রস্পর্শার্থং লোকাস্তান্ তস্য সমীপমানিন্যুঃ শিষ্যাস্তদ্ দৃষ্ট্ৱানেতৃন্ তর্জযামাসুঃ, ");
INSERT INTO sanben_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","কিন্তু যীশুস্তানাহূয জগাদ, মন্নিকটম্ আগন্তুং শিশূন্ অনুজানীধ্ৱং তাংশ্চ মা ৱারযত; যত ঈশ্ৱররাজ্যাধিকারিণ এষাং সদৃশাঃ| ");
INSERT INTO sanben_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","অহং যুষ্মান্ যথার্থং ৱদামি, যো জনঃ শিশোঃ সদৃশো ভূৎৱা ঈশ্ৱররাজ্যং ন গৃহ্লাতি স কেনাপি প্রকারেণ তৎ প্রৱেষ্টুং ন শক্নোতি| ");
INSERT INTO sanben_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","অপরম্ একোধিপতিস্তং পপ্রচ্ছ, হে পরমগুরো, অনন্তাযুষঃ প্রাপ্তযে মযা কিং কর্ত্তৱ্যং? ");
INSERT INTO sanben_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","যীশুরুৱাচ, মাং কুতঃ পরমং ৱদসি? ঈশ্ৱরং ৱিনা কোপি পরমো ন ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","পরদারান্ মা গচ্ছ, নরং মা জহি, মা চোরয, মিথ্যাসাক্ষ্যং মা দেহি, মাতরং পিতরঞ্চ সংমন্যস্ৱ, এতা যা আজ্ঞাঃ সন্তি তাস্ত্ৱং জানাসি| ");
INSERT INTO sanben_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","তদা স উৱাচ, বাল্যকালাৎ সর্ৱ্ৱা এতা আচরামি| ");
INSERT INTO sanben_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ইতি কথাং শ্রুৎৱা যীশুস্তমৱদৎ, তথাপি তৱৈকং কর্ম্ম ন্যূনমাস্তে, নিজং সর্ৱ্ৱস্ৱং ৱিক্রীয দরিদ্রেভ্যো ৱিতর, তস্মাৎ স্ৱর্গে ধনং প্রাপ্স্যসি; তত আগত্য মমানুগামী ভৱ| ");
INSERT INTO sanben_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","কিন্ত্ৱেতাং কথাং শ্রুৎৱা সোধিপতিঃ শুশোচ, যতস্তস্য বহুধনমাসীৎ| ");
INSERT INTO sanben_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","তদা যীশুস্তমতিশোকান্ৱিতং দৃষ্ট্ৱা জগাদ, ধনৱতাম্ ঈশ্ৱররাজ্যপ্রৱেশঃ কীদৃগ্ দুষ্করঃ| ");
INSERT INTO sanben_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ঈশ্ৱররাজ্যে ধনিনঃ প্রৱেশাৎ সূচেশ্ছিদ্রেণ মহাঙ্গস্য গমনাগমনে সুকরে| ");
INSERT INTO sanben_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","শ্রোতারঃ পপ্রচ্ছুস্তর্হি কেন পরিত্রাণং প্রাপ্স্যতে? ");
INSERT INTO sanben_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","স উক্তৱান্, যন্ মানুষেণাশক্যং তদ্ ঈশ্ৱরেণ শক্যং| ");
INSERT INTO sanben_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","তদা পিতর উৱাচ, পশ্য ৱযং সর্ৱ্ৱস্ৱং পরিত্যজ্য তৱ পশ্চাদ্গামিনোঽভৱাম| ");
INSERT INTO sanben_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ততঃ স উৱাচ, যুষ্মানহং যথার্থং ৱদামি, ঈশ্ৱররাজ্যার্থং গৃহং পিতরৌ ভ্রাতৃগণং জাযাং সন্তানাংশ্চ ত্যক্তৱা ");
INSERT INTO sanben_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ইহ কালে ততোঽধিকং পরকালে ঽনন্তাযুশ্চ ন প্রাপ্স্যতি লোক ঈদৃশঃ কোপি নাস্তি| ");
INSERT INTO sanben_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","অনন্তরং স দ্ৱাদশশিষ্যানাহূয বভাষে, পশ্যত ৱযং যিরূশালম্নগরং যামঃ, তস্মাৎ মনুষ্যপুত্রে ভৱিষ্যদ্ৱাদিভিরুক্তং যদস্তি তদনুরূপং তং প্রতি ঘটিষ্যতে; ");
INSERT INTO sanben_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","ৱস্তুতস্তু সোঽন্যদেশীযানাং হস্তেষু সমর্পযিষ্যতে, তে তমুপহসিষ্যন্তি, অন্যাযমাচরিষ্যন্তি তদ্ৱপুষি নিষ্ঠীৱং নিক্ষেপ্স্যন্তি, কশাভিঃ প্রহৃত্য তং হনিষ্যন্তি চ, ");
INSERT INTO sanben_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","কিন্তু তৃতীযদিনে স শ্মশানাদ্ উত্থাস্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","এতস্যাঃ কথাযা অভিপ্রাযং কিঞ্চিদপি তে বোদ্ধুং ন শেকুঃ তেষাং নিকটেঽস্পষ্টতৱাৎ তস্যৈতাসাং কথানাম্ আশযং তে জ্ঞাতুং ন শেকুশ্চ| ");
INSERT INTO sanben_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","অথ তস্মিন্ যিরীহোঃ পুরস্যান্তিকং প্রাপ্তে কশ্চিদন্ধঃ পথঃ পার্শ্ৱ উপৱিশ্য ভিক্ষাম্ অকরোৎ ");
INSERT INTO sanben_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","স লোকসমূহস্য গমনশব্দং শ্রুৎৱা তৎকারণং পৃষ্টৱান্| ");
INSERT INTO sanben_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","নাসরতীযযীশুর্যাতীতি লোকৈরুক্তে স উচ্চৈর্ৱক্তুমারেভে, ");
INSERT INTO sanben_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","হে দাযূদঃ সন্তান যীশো মাং দযস্ৱ| ");
INSERT INTO sanben_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ততোগ্রগামিনস্তং মৌনী তিষ্ঠেতি তর্জযামাসুঃ কিন্তু স পুনারুৱন্ উৱাচ, হে দাযূদঃ সন্তান মাং দযস্ৱ| ");
INSERT INTO sanben_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","তদা যীশুঃ স্থগিতো ভূৎৱা স্ৱান্তিকে তমানেতুম্ আদিদেশ| ");
INSERT INTO sanben_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","ততঃ স তস্যান্তিকম্ আগমৎ, তদা স তং পপ্রচ্ছ, ৎৱং কিমিচ্ছসি? ৎৱদর্থমহং কিং করিষ্যামি? স উক্তৱান্, হে প্রভোঽহং দ্রষ্টুং লভৈ| ");
INSERT INTO sanben_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","তদা যীশুরুৱাচ, দৃষ্টিশক্তিং গৃহাণ তৱ প্রত্যযস্ত্ৱাং স্ৱস্থং কৃতৱান্| ");
INSERT INTO sanben_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ততস্তৎক্ষণাৎ তস্য চক্ষুষী প্রসন্নে; তস্মাৎ স ঈশ্ৱরং ধন্যং ৱদন্ তৎপশ্চাদ্ যযৌ, তদালোক্য সর্ৱ্ৱে লোকা ঈশ্ৱরং প্রশংসিতুম্ আরেভিরে| ");
INSERT INTO sanben_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","যদা যীশু র্যিরীহোপুরং প্রৱিশ্য তন্মধ্যেন গচ্ছংস্তদা ");
INSERT INTO sanben_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","সক্কেযনামা করসঞ্চাযিনাং প্রধানো ধনৱানেকো ");
INSERT INTO sanben_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","যীশুঃ কীদৃগিতি দ্রষ্টুং চেষ্টিতৱান্ কিন্তু খর্ৱ্ৱৎৱাল্লোকসংঘমধ্যে তদ্দর্শনমপ্রাপ্য ");
INSERT INTO sanben_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","যেন পথা স যাস্যতি তৎপথেঽগ্রে ধাৱিৎৱা তং দ্রষ্টুম্ উডুম্বরতরুমারুরোহ| ");
INSERT INTO sanben_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","পশ্চাদ্ যীশুস্তৎস্থানম্ ইৎৱা ঊর্দ্ধ্ৱং ৱিলোক্য তং দৃষ্ট্ৱাৱাদীৎ, হে সক্কেয ৎৱং শীঘ্রমৱরোহ মযাদ্য ৎৱদ্গেহে ৱস্তৱ্যং| ");
INSERT INTO sanben_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ততঃ স শীঘ্রমৱরুহ্য সাহ্লাদং তং জগ্রাহ| ");
INSERT INTO sanben_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","তদ্ দৃষ্ট্ৱা সর্ৱ্ৱে ৱিৱদমানা ৱক্তুমারেভিরে, সোতিথিৎৱেন দুষ্টলোকগৃহং গচ্ছতি| ");
INSERT INTO sanben_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","কিন্তু সক্কেযো দণ্ডাযমানো ৱক্তুমারেভে, হে প্রভো পশ্য মম যা সম্পত্তিরস্তি তদর্দ্ধং দরিদ্রেভ্যো দদে, অপরম্ অন্যাযং কৃৎৱা কস্মাদপি যদি কদাপি কিঞ্চিৎ মযা গৃহীতং তর্হি তচ্চতুর্গুণং দদামি| ");
INSERT INTO sanben_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","তদা যীশুস্তমুক্তৱান্ অযমপি ইব্রাহীমঃ সন্তানোঽতঃ কারণাদ্ অদ্যাস্য গৃহে ত্রাণমুপস্থিতং| ");
INSERT INTO sanben_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","যদ্ হারিতং তৎ মৃগযিতুং রক্ষিতুঞ্চ মনুষ্যপুত্র আগতৱান্| ");
INSERT INTO sanben_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","অথ স যিরূশালমঃ সমীপ উপাতিষ্ঠদ্ ঈশ্ৱররাজৎৱস্যানুষ্ঠানং তদৈৱ ভৱিষ্যতীতি লোকৈরন্ৱভূযত, তস্মাৎ স শ্রোতৃভ্যঃ পুনর্দৃষ্টান্তকথাম্ উত্থাপ্য কথযামাস| ");
INSERT INTO sanben_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","কোপি মহাল্লোকো নিজার্থং রাজৎৱপদং গৃহীৎৱা পুনরাগন্তুং দূরদেশং জগাম| ");
INSERT INTO sanben_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","যাত্রাকালে নিজান্ দশদাসান্ আহূয দশস্ৱর্ণমুদ্রা দত্ত্ৱা মমাগমনপর্য্যন্তং ৱাণিজ্যং কুরুতেত্যাদিদেশ| ");
INSERT INTO sanben_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","কিন্তু তস্য প্রজাস্তমৱজ্ঞায মনুষ্যমেনম্ অস্মাকমুপরি রাজৎৱং ন কারযিৱ্যাম ইমাং ৱার্ত্তাং তন্নিকটে প্রেরযামাসুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","অথ স রাজৎৱপদং প্রাপ্যাগতৱান্ একৈকো জনো বাণিজ্যেন কিং লব্ধৱান্ ইতি জ্ঞাতুং যেষু দাসেষু মুদ্রা অর্পযৎ তান্ আহূযানেতুম্ আদিদেশ| ");
INSERT INTO sanben_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","তদা প্রথম আগত্য কথিতৱান্, হে প্রভো তৱ তযৈকযা মুদ্রযা দশমুদ্রা লব্ধাঃ| ");
INSERT INTO sanben_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","ততঃ স উৱাচ ৎৱমুত্তমো দাসঃ স্ৱল্পেন ৱিশ্ৱাস্যো জাত ইতঃ কারণাৎ ৎৱং দশনগরাণাম্ অধিপো ভৱ| ");
INSERT INTO sanben_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","দ্ৱিতীয আগত্য কথিতৱান্, হে প্রভো তৱৈকযা মুদ্রযা পঞ্চমুদ্রা লব্ধাঃ| ");
INSERT INTO sanben_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ততঃ স উৱাচ, ৎৱং পঞ্চানাং নগরাণামধিপতি র্ভৱ| ");
INSERT INTO sanben_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","ততোন্য আগত্য কথযামাস, হে প্রভো পশ্য তৱ যা মুদ্রা অহং ৱস্ত্রে বদ্ধ্ৱাস্থাপযং সেযং| ");
INSERT INTO sanben_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ৎৱং কৃপণো যন্নাস্থাপযস্তদপি গৃহ্লাসি, যন্নাৱপস্তদেৱ চ ছিনৎসি ততোহং ৎৱত্তো ভীতঃ| ");
INSERT INTO sanben_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","তদা স জগাদ, রে দুষ্টদাস তৱ ৱাক্যেন ৎৱাং দোষিণং করিষ্যামি, যদহং নাস্থাপযং তদেৱ গৃহ্লামি, যদহং নাৱপঞ্চ তদেৱ ছিনদ্মি, এতাদৃশঃ কৃপণোহমিতি যদি ৎৱং জানাসি, ");
INSERT INTO sanben_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","তর্হি মম মুদ্রা বণিজাং নিকটে কুতো নাস্থাপযঃ? তযা কৃতেঽহম্ আগত্য কুসীদেন সার্দ্ধং নিজমুদ্রা অপ্রাপ্স্যম্| ");
INSERT INTO sanben_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","পশ্চাৎ স সমীপস্থান্ জনান্ আজ্ঞাপযৎ অস্মাৎ মুদ্রা আনীয যস্য দশমুদ্রাঃ সন্তি তস্মৈ দত্ত| ");
INSERT INTO sanben_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","তে প্রোচুঃ প্রভোঽস্য দশমুদ্রাঃ সন্তি| ");
INSERT INTO sanben_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","যুষ্মানহং ৱদামি যস্যাশ্রযে ৱদ্ধতে ঽধিকং তস্মৈ দাযিষ্যতে, কিন্তু যস্যাশ্রযে ন ৱর্দ্ধতে তস্য যদ্যদস্তি তদপি তস্মান্ নাযিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","কিন্তু মমাধিপতিৎৱস্য ৱশৎৱে স্থাতুম্ অসম্মন্যমানা যে মম রিপৱস্তানানীয মম সমক্ষং সংহরত| ");
INSERT INTO sanben_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ইত্যুপদেশকথাং কথযিৎৱা সোগ্রগঃ সন্ যিরূশালমপুরং যযৌ| ");
INSERT INTO sanben_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ততো বৈৎফগীবৈথনীযাগ্রামযোঃ সমীপে জৈতুনাদ্রেরন্তিকম্ ইৎৱা শিষ্যদ্ৱযম্ ইত্যুক্ত্ৱা প্রেষযামাস, ");
INSERT INTO sanben_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","যুৱামমুং সম্মুখস্থগ্রামং প্রৱিশ্যৈৱ যং কোপি মানুষঃ কদাপি নারোহৎ তং গর্দ্দভশাৱকং বদ্ধং দ্রক্ষ্যথস্তং মোচযিৎৱানযতং| ");
INSERT INTO sanben_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","তত্র কুতো মোচযথঃ? ইতি চেৎ কোপি ৱক্ষ্যতি তর্হি ৱক্ষ্যথঃ প্রভেाরত্র প্রযোজনম্ আস্তে| ");
INSERT INTO sanben_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","তদা তৌ প্ররিতৌ গৎৱা তৎকথাाনুসারেণ সর্ৱ্ৱং প্রাপ্তৌ| ");
INSERT INTO sanben_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","গর্দভশাৱকমোচনকালে তৎৱামিন ঊচুঃ, গর্দভশাৱকং কুতো মোচযথঃ? ");
INSERT INTO sanben_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","তাৱূচতুঃ প্রভোরত্র প্রযোজনম্ আস্তে| ");
INSERT INTO sanben_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","পশ্চাৎ তৌ তং গর্দভশাৱকং যীশোরন্তিকমানীয তৎপৃষ্ঠে নিজৱসনানি পাতযিৎৱা তদুপরি যীশুমারোহযামাসতুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","অথ যাত্রাকালে লোকাঃ পথি স্ৱৱস্ত্রাণি পাতযিতুম্ আরেভিরে| ");
INSERT INTO sanben_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","অপরং জৈতুনাদ্রেরুপত্যকাম্ ইৎৱা শিষ্যসংঘঃ পূর্ৱ্ৱদৃষ্টানি মহাকর্ম্মাণি স্মৃৎৱা, ");
INSERT INTO sanben_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","যো রাজা প্রভো র্নাম্নাযাতি স ধন্যঃ স্ৱর্গে কুশলং সর্ৱ্ৱোচ্চে জযধ্ৱনি র্ভৱতু, কথামেতাং কথযিৎৱা সানন্দম্ উচৈরীশ্ৱরং ধন্যং ৱক্তুমারেভে| ");
INSERT INTO sanben_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","তদা লোকারণ্যমধ্যস্থাঃ কিযন্তঃ ফিরূশিনস্তৎ শ্রুৎৱা যীশুং প্রোচুঃ, হে উপদেশক স্ৱশিষ্যান্ তর্জয| ");
INSERT INTO sanben_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","স উৱাচ, যুষ্মানহং ৱদামি যদ্যমী নীরৱাস্তিষ্ঠন্তি তর্হি পাষাণা উচৈঃ কথাঃ কথযিষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","পশ্চাৎ তৎপুরান্তিকমেত্য তদৱলোক্য সাশ্রুপাতং জগাদ, ");
INSERT INTO sanben_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","হা হা চেৎ ৎৱমগ্রেঽজ্ঞাস্যথাঃ, তৱাস্মিন্নেৱ দিনে ৱা যদি স্ৱমঙ্গলম্ উপালপ্স্যথাঃ, তর্হ্যুত্তমম্ অভৱিষ্যৎ, কিন্তু ক্ষণেস্মিন্ তত্তৱ দৃষ্টেরগোচরম্ ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ৎৱং স্ৱত্রাণকালে ন মনো ন্যধত্থা ইতি হেতো র্যৎকালে তৱ রিপৱস্ত্ৱাং চতুর্দিক্ষু প্রাচীরেণ ৱেষ্টযিৎৱা রোৎস্যন্তি ");
INSERT INTO sanben_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","বালকৈঃ সার্দ্ধং ভূমিসাৎ করিষ্যন্তি চ ৎৱন্মধ্যে পাষাণৈকোপি পাষাণোপরি ন স্থাস্যতি চ, কাল ঈদৃশ উপস্থাস্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","অথ মধ্যেমন্দিরং প্রৱিশ্য তত্রত্যান্ ক্রযিৱিক্রযিণো বহিষ্কুর্ৱ্ৱন্ ");
INSERT INTO sanben_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","অৱদৎ মদ্গৃহং প্রার্থনাগৃহমিতি লিপিরাস্তে কিন্তু যূযং তদেৱ চৈরাণাং গহ্ৱরং কুরুথ| ");
INSERT INTO sanben_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","পশ্চাৎ স প্রত্যহং মধ্যেমন্দিরম্ উপদিদেশ; ততঃ প্রধানযাজকা অধ্যাপকাঃ প্রাচীনাশ্চ তং নাশযিতুং চিচেষ্টিরে; ");
INSERT INTO sanben_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","কিন্তু তদুপদেশে সর্ৱ্ৱে লোকা নিৱিষ্টচিত্তাঃ স্থিতাস্তস্মাৎ তে তৎকর্ত্তুং নাৱকাশং প্রাপুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","অথৈকদা যীশু র্মনিদরে সুসংৱাদং প্রচারযন্ লোকানুপদিশতি, এতর্হি প্রধানযাজকা অধ্যাপকাঃ প্রাঞ্চশ্চ তন্নিকটমাগত্য পপ্রচ্ছুঃ ");
INSERT INTO sanben_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","কযাজ্ঞযা ৎৱং কর্ম্মাণ্যেতানি করোষি? কো ৱা ৎৱামাজ্ঞাপযৎ? তদস্মান্ ৱদ| ");
INSERT INTO sanben_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","স প্রত্যুৱাচ, তর্হি যুষ্মানপি কথামেকাং পৃচ্ছামি তস্যোত্তরং ৱদত| ");
INSERT INTO sanben_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","যোহনো মজ্জনম্ ঈশ্ৱরস্য মানুষাণাং ৱাজ্ঞাতো জাতং? ");
INSERT INTO sanben_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ততস্তে মিথো ৱিৱিচ্য জগদুঃ, যদীশ্ৱরস্য ৱদামস্তর্হি তং কুতো ন প্রত্যৈত স ইতি ৱক্ষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","যদি মনুষ্যস্যেতি ৱদামস্তর্হি সর্ৱ্ৱে লোকা অস্মান্ পাষাণৈ র্হনিষ্যন্তি যতো যোহন্ ভৱিষ্যদ্ৱাদীতি সর্ৱ্ৱে দৃঢং জানন্তি| ");
INSERT INTO sanben_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","অতএৱ তে প্রত্যূচুঃ কস্যাজ্ঞযা জাতম্ ইতি ৱক্তুং ন শক্নুমঃ| ");
INSERT INTO sanben_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","তদা যীশুরৱদৎ তর্হি কযাজ্ঞযা কর্ম্মাণ্যেতাতি করোমীতি চ যুষ্মান্ ন ৱক্ষ্যামি| ");
INSERT INTO sanben_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","অথ লোকানাং সাক্ষাৎ স ইমাং দৃষ্টান্তকথাং ৱক্তুমারেভে, কশ্চিদ্ দ্রাক্ষাক্ষেত্রং কৃৎৱা তৎ ক্ষেত্রং কৃষীৱলানাং হস্তেষু সমর্প্য বহুকালার্থং দূরদেশং জগাম| ");
INSERT INTO sanben_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","অথ ফলকালে ফলানি গ্রহীতু কৃষীৱলানাং সমীপে দাসং প্রাহিণোৎ কিন্তু কৃষীৱলাস্তং প্রহৃত্য রিক্তহস্তং ৱিসসর্জুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","ততঃ সোধিপতিঃ পুনরন্যং দাসং প্রেষযামাস, তে তমপি প্রহৃত্য কুৱ্যৱহৃত্য রিক্তহস্তং ৱিসসৃজুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ততঃ স তৃতীযৱারম্ অন্যং প্রাহিণোৎ তে তমপি ক্ষতাঙ্গং কৃৎৱা বহি র্নিচিক্ষিপুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","তদা ক্ষেত্রপতি র্ৱিচারযামাস, মমেদানীং কিং কর্ত্তৱ্যং? মম প্রিযে পুত্রে প্রহিতে তে তমৱশ্যং দৃষ্ট্ৱা সমাদরিষ্যন্তে| ");
INSERT INTO sanben_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","কিন্তু কৃষীৱলাস্তং নিরীক্ষ্য পরস্পরং ৱিৱিচ্য প্রোচুঃ, অযমুত্তরাধিকারী আগচ্ছতৈনং হন্মস্ততোধিকারোস্মাকং ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ততস্তে তং ক্ষেত্রাদ্ বহি র্নিপাত্য জঘ্নুস্তস্মাৎ স ক্ষেত্রপতিস্তান্ প্রতি কিং করিষ্যতি? ");
INSERT INTO sanben_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","স আগত্য তান্ কৃষীৱলান্ হৎৱা পরেষাং হস্তেষু তৎক্ষেত্রং সমর্পযিষ্যতি; ইতি কথাং শ্রুৎৱা তে ঽৱদন্ এতাদৃশী ঘটনা ন ভৱতু| ");
INSERT INTO sanben_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","কিন্তু যীশুস্তানৱলোক্য জগাদ, তর্হি, স্থপতযঃ করিষ্যন্তি গ্রাৱাণং যন্তু তুচ্ছকং| প্রধানপ্রস্তরঃ কোণে স এৱ হি ভৱিষ্যতি| এতস্য শাস্ত্রীযৱচনস্য কিং তাৎপর্য্যং? ");
INSERT INTO sanben_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","অপরং তৎপাষাণোপরি যঃ পতিষ্যতি স ভংক্ষ্যতে কিন্তু যস্যোপরি স পাষাণঃ পতিষ্যতি স তেন ধূলিৱচ্ চূর্ণীভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","সোস্মাকং ৱিরুদ্ধং দৃষ্টান্তমিমং কথিতৱান্ ইতি জ্ঞাৎৱা প্রধানযাজকা অধ্যাপকাশ্চ তদৈৱ তং ধর্তুং ৱৱাঞ্ছুঃ কিন্তু লোকেভ্যো বিভ্যুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","অতএৱ তং প্রতি সতর্কাঃ সন্তঃ কথং তদ্ৱাক্যদোষং ধৃৎৱা তং দেশাধিপস্য সাধুৱেশধারিণশ্চরান্ তস্য সমীপে প্রেষযামাসুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","তদা তে তং পপ্রচ্ছুঃ, হে উপদেশক ভৱান্ যথার্থং কথযন্ উপদিশতি, কমপ্যনপেক্ষ্য সত্যৎৱেনৈশ্ৱরং মার্গমুপদিশতি, ৱযমেতজ্জানীমঃ| ");
INSERT INTO sanben_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","কৈসররাজায করোস্মাভি র্দেযো ন ৱা? ");
INSERT INTO sanben_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","স তেষাং ৱঞ্চনং জ্ঞাৎৱাৱদৎ কুতো মাং পরীক্ষধ্ৱে? মাং মুদ্রামেকং দর্শযত| ");
INSERT INTO sanben_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","ইহ লিখিতা মূর্তিরিযং নাম চ কস্য? তেঽৱদন্ কৈসরস্য| ");
INSERT INTO sanben_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","তদা স উৱাচ, তর্হি কৈসরস্য দ্রৱ্যং কৈসরায দত্ত; ঈশ্ৱরস্য তু দ্রৱ্যমীশ্ৱরায দত্ত| ");
INSERT INTO sanben_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","তস্মাল্লোকানাং সাক্ষাৎ তৎকথাযাঃ কমপি দোষং ধর্তুমপ্রাপ্য তে তস্যোত্তরাদ্ আশ্চর্য্যং মন্যমানা মৌনিনস্তস্থুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","অপরঞ্চ শ্মশানাদুত্থানানঙ্গীকারিণাং সিদূকিনাং কিযন্তো জনা আগত্য তং পপ্রচ্ছুঃ, ");
INSERT INTO sanben_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","হে উপদেশক শাস্ত্রে মূসা অস্মান্ প্রতীতি লিলেখ যস্য ভ্রাতা ভার্য্যাযাং সত্যাং নিঃসন্তানো ম্রিযতে স তজ্জাযাং ৱিৱহ্য তদ্ৱংশম্ উৎপাদযিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","তথাচ কেচিৎ সপ্ত ভ্রাতর আসন্ তেষাং জ্যেষ্ঠো ভ্রাতা ৱিৱহ্য নিরপত্যঃ প্রাণান্ জহৌ| ");
INSERT INTO sanben_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","অথ দ্ৱিতীযস্তস্য জাযাং ৱিৱহ্য নিরপত্যঃ সন্ মমার| তৃতীযশ্চ তামেৱ ৱ্যুৱাহ; ");
INSERT INTO sanben_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ইত্থং সপ্ত ভ্রাতরস্তামেৱ ৱিৱহ্য নিরপত্যাঃ সন্তো মম্রুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","শেষে সা স্ত্রী চ মমার| ");
INSERT INTO sanben_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","অতএৱ শ্মশানাদুত্থানকালে তেষাং সপ্তজনানাং কস্য সা ভার্য্যা ভৱিষ্যতি? যতঃ সা তেষাং সপ্তানামেৱ ভার্য্যাসীৎ| ");
INSERT INTO sanben_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","তদা যীশুঃ প্রত্যুৱাচ, এতস্য জগতো লোকা ৱিৱহন্তি ৱাগ্দত্তাশ্চ ভৱন্তি ");
INSERT INTO sanben_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","কিন্তু যে তজ্জগৎপ্রাপ্তিযোগ্যৎৱেন গণিতাং ভৱিষ্যন্তি শ্মশানাচ্চোত্থাস্যন্তি তে ন ৱিৱহন্তি ৱাগ্দত্তাশ্চ ন ভৱন্তি, ");
INSERT INTO sanben_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","তে পুন র্ন ম্রিযন্তে কিন্তু শ্মশানাদুত্থাপিতাঃ সন্ত ঈশ্ৱরস্য সন্তানাঃ স্ৱর্গীযদূতানাং সদৃশাশ্চ ভৱন্তি| ");
INSERT INTO sanben_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","অধিকন্তু মূসাঃ স্তম্বোপাখ্যানে পরমেশ্ৱর ঈব্রাহীম ঈশ্ৱর ইস্হাক ঈশ্ৱরো যাকূবশ্চেশ্ৱর ইত্যুক্ত্ৱা মৃতানাং শ্মশানাদ্ উত্থানস্য প্রমাণং লিলেখ| ");
INSERT INTO sanben_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","অতএৱ য ঈশ্ৱরঃ স মৃতানাং প্রভু র্ন কিন্তু জীৱতামেৱ প্রভুঃ, তন্নিকটে সর্ৱ্ৱে জীৱন্তঃ সন্তি| ");
INSERT INTO sanben_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ইতি শ্রুৎৱা কিযন্তোধ্যাপকা ঊচুঃ, হে উপদেশক ভৱান্ ভদ্রং প্রত্যুক্তৱান্| ");
INSERT INTO sanben_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ইতঃ পরং তং কিমপি প্রষ্টং তেষাং প্রগল্ভতা নাভূৎ| ");
INSERT INTO sanben_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","পশ্চাৎ স তান্ উৱাচ, যঃ খ্রীষ্টঃ স দাযূদঃ সন্তান এতাং কথাং লোকাঃ কথং কথযন্তি? ");
INSERT INTO sanben_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","যতঃ মম প্রভুমিদং ৱাক্যমৱদৎ পরমেশ্ৱরঃ| তৱ শত্রূনহং যাৱৎ পাদপীঠং করোমি ন| তাৱৎ কালং মদীযে ৎৱং দক্ষপার্শ্ৱ উপাৱিশ| ");
INSERT INTO sanben_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ইতি কথাং দাযূদ্ স্ৱযং গীতগ্রন্থেঽৱদৎ| ");
INSERT INTO sanben_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","অতএৱ যদি দাযূদ্ তং প্রভুং ৱদতি, তর্হি স কথং তস্য সন্তানো ভৱতি? ");
INSERT INTO sanben_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","পশ্চাদ্ যীশুঃ সর্ৱ্ৱজনানাং কর্ণগোচরে শিষ্যানুৱাচ, ");
INSERT INTO sanben_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","যেঽধ্যাপকা দীর্ঘপরিচ্ছদং পরিধায ভ্রমন্তি, হট্টাপণযো র্নমস্কারে ভজনগেহস্য প্রোচ্চাসনে ভোজনগৃহস্য প্রধানস্থানে চ প্রীযন্তে ");
INSERT INTO sanben_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ৱিধৱানাং সর্ৱ্ৱস্ৱং গ্রসিৎৱা ছলেন দীর্ঘকালং প্রার্থযন্তে চ তেষু সাৱধানা ভৱত, তেষামুগ্রদণ্ডো ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","অথ ধনিলোকা ভাণ্ডাগারে ধনং নিক্ষিপন্তি স তদেৱ পশ্যতি, ");
INSERT INTO sanben_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","এতর্হি কাচিদ্দীনা ৱিধৱা পণদ্ৱযং নিক্ষিপতি তদ্ দদর্শ| ");
INSERT INTO sanben_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ততো যীশুরুৱাচ যুষ্মানহং যথার্থং ৱদামি, দরিদ্রেযং ৱিধৱা সর্ৱ্ৱেভ্যোধিকং ন্যক্ষেপ্সীৎ, ");
INSERT INTO sanben_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","যতোন্যে স্ৱপ্রাজ্যধনেভ্য ঈশ্ৱরায কিঞ্চিৎ ন্যক্ষেপ্সুঃ, কিন্তু দরিদ্রেযং ৱিধৱা দিনযাপনার্থং স্ৱস্য যৎ কিঞ্চিৎ স্থিতং তৎ সর্ৱ্ৱং ন্যক্ষেপ্সীৎ| ");
INSERT INTO sanben_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","অপরঞ্চ উত্তমপ্রস্তরৈরুৎসৃষ্টৱ্যৈশ্চ মন্দিরং সুশোভতেতরাং কৈশ্চিদিত্যুক্তে স প্রত্যুৱাচ ");
INSERT INTO sanben_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","যূযং যদিদং নিচযনং পশ্যথ, অস্য পাষাণৈকোপ্যন্যপাষাণোপরি ন স্থাস্যতি, সর্ৱ্ৱে ভূসাদ্ভৱিষ্যন্তি কালোযমাযাতি| ");
INSERT INTO sanben_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","তদা তে পপ্রচ্ছুঃ, হে গুরো ঘটনেদৃশী কদা ভৱিষ্যতি? ঘটনাযা এতস্যসশ্চিহ্নং ৱা কিং ভৱিষ্যতি? ");
INSERT INTO sanben_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","তদা স জগাদ, সাৱধানা ভৱত যথা যুষ্মাকং ভ্রমং কোপি ন জনযতি, খীষ্টোহমিত্যুক্ত্ৱা মম নাম্রা বহৱ উপস্থাস্যন্তি স কালঃ প্রাযেণোপস্থিতঃ, তেষাং পশ্চান্মা গচ্ছত| ");
INSERT INTO sanben_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","যুদ্ধস্যোপপ্লৱস্য চ ৱার্ত্তাং শ্রুৎৱা মা শঙ্কধ্ৱং, যতঃ প্রথমম্ এতা ঘটনা অৱশ্যং ভৱিষ্যন্তি কিন্তু নাপাতে যুগান্তো ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","অপরঞ্চ কথযামাস, তদা দেশস্য ৱিপক্ষৎৱেন দেশো রাজ্যস্য ৱিপক্ষৎৱেন রাজ্যম্ উত্থাস্যতি, ");
INSERT INTO sanben_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","নানাস্থানেষু মহাভূকম্পো দুর্ভিক্ষং মারী চ ভৱিষ্যন্তি, তথা ৱ্যোমমণ্ডলস্য ভযঙ্করদর্শনান্যশ্চর্য্যলক্ষণানি চ প্রকাশযিষ্যন্তে| ");
INSERT INTO sanben_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","কিন্তু সর্ৱ্ৱাসামেতাসাং ঘটনানাং পূর্ৱ্ৱং লোকা যুষ্মান্ ধৃৎৱা তাডযিষ্যন্তি, ভজনালযে কারাযাঞ্চ সমর্পযিষ্যন্তি মম নামকারণাদ্ যুষ্মান্ ভূপানাং শাসকানাঞ্চ সম্মুখং নেষ্যন্তি চ| ");
INSERT INTO sanben_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","সাক্ষ্যার্থম্ এতানি যুষ্মান্ প্রতি ঘটিষ্যন্তে| ");
INSERT INTO sanben_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","তদা কিমুত্তরং ৱক্তৱ্যম্ এতৎ ন চিন্তযিষ্যাম ইতি মনঃসু নিশ্চিতনুত| ");
INSERT INTO sanben_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ৱিপক্ষা যস্মাৎ কিমপ্যুত্তরম্ আপত্তিঞ্চ কর্ত্তুং ন শক্ষ্যন্তি তাদৃশং ৱাক্পটুৎৱং জ্ঞানঞ্চ যুষ্মভ্যং দাস্যামি| ");
INSERT INTO sanben_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","কিঞ্চ যূযং পিত্রা মাত্রা ভ্রাত্রা বন্ধুনা জ্ঞাত্যা কুটুম্বেন চ পরকরেষু সমর্পযিষ্যধ্ৱে; ততস্তে যুষ্মাকং কঞ্চন কঞ্চন ঘাতযিষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","মম নাম্নঃ কারণাৎ সর্ৱ্ৱৈ র্মনুষ্যৈ র্যূযম্ ঋতীযিষ্যধ্ৱে| ");
INSERT INTO sanben_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","কিন্তু যুষ্মাকং শিরঃকেশৈকোপি ন ৱিনংক্ষ্যতি, ");
INSERT INTO sanben_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","তস্মাদেৱ ধৈর্য্যমৱলম্ব্য স্ৱস্ৱপ্রাণান্ রক্ষত| ");
INSERT INTO sanben_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","অপরঞ্চ যিরূশালম্পুরং সৈন্যৱেষ্টিতং ৱিলোক্য তস্যোচ্ছিন্নতাযাঃ সমযঃ সমীপ ইত্যৱগমিষ্যথ| ");
INSERT INTO sanben_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","তদা যিহূদাদেশস্থা লোকাঃ পর্ৱ্ৱতং পলাযন্তাং, যে চ নগরে তিষ্ঠন্তি তে দেশান্তরং পলাযন্তা, যে চ গ্রামে তিষ্ঠন্তি তে নগরং ন প্রৱিশন্তু, ");
INSERT INTO sanben_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","যতস্তদা সমুচিতদণ্ডনায ধর্ম্মপুস্তকে যানি সর্ৱ্ৱাণি লিখিতানি তানি সফলানি ভৱিষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","কিন্তু যা যাস্তদা গর্ভৱত্যঃ স্তন্যদাৱ্যশ্চ তামাং দুর্গতি র্ভৱিষ্যতি, যত এতাল্লোকান্ প্রতি কোপো দেশে চ ৱিষমদুর্গতি র্ঘটিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","ৱস্তুতস্তু তে খঙ্গধারপরিৱ্ৱঙ্গং লপ্স্যন্তে বদ্ধাঃ সন্তঃ সর্ৱ্ৱদেশেষু নাযিষ্যন্তে চ কিঞ্চান্যদেশীযানাং সমযোপস্থিতিপর্য্যন্তং যিরূশালম্পুরং তৈঃ পদতলৈ র্দলযিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","সূর্য্যচন্দ্রনক্ষত্রেষু লক্ষণাদি ভৱিষ্যন্তি, ভুৱি সর্ৱ্ৱদেশীযানাং দুঃখং চিন্তা চ সিন্ধৌ ৱীচীনাং তর্জনং গর্জনঞ্চ ভৱিষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ভূভৌ ভাৱিঘটনাং চিন্তযিৎৱা মনুজা ভিযামৃতকল্পা ভৱিষ্যন্তি, যতো ৱ্যোমমণ্ডলে তেজস্ৱিনো দোলাযমানা ভৱিষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","তদা পরাক্রমেণা মহাতেজসা চ মেঘারূঢং মনুষ্যপুত্রম্ আযান্তং দ্রক্ষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","কিন্ত্ৱেতাসাং ঘটনানামারম্ভে সতি যূযং মস্তকান্যুত্তোল্য ঊর্দধ্ৱং দ্রক্ষ্যথ, যতো যুষ্মাকং মুক্তেঃ কালঃ সৱিধো ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ততস্তেনৈতদৃষ্টান্তকথা কথিতা, পশ্যত উডুম্বরাদিৱৃক্ষাণাং ");
INSERT INTO sanben_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","নৱীনপত্রাণি জাতানীতি দৃষ্ট্ৱা নিদাৱকাল উপস্থিত ইতি যথা যূযং জ্ঞাতুং শক্নুথ, ");
INSERT INTO sanben_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","তথা সর্ৱ্ৱাসামাসাং ঘটনানাম্ আরম্ভে দৃষ্টে সতীশ্ৱরস্য রাজৎৱং নিকটম্ ইত্যপি জ্ঞাস্যথ| ");
INSERT INTO sanben_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","যুষ্মানহং যথার্থং ৱদামি, ৱিদ্যমানলোকানামেষাং গমনাৎ পূর্ৱ্ৱম্ এতানি ঘটিষ্যন্তে| ");
INSERT INTO sanben_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","নভোভুৱোর্লোপো ভৱিষ্যতি মম ৱাক্ তু কদাপি লুপ্তা ন ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","অতএৱ ৱিষমাশনেন পানেন চ সাংমারিকচিন্তাভিশ্চ যুষ্মাকং চিত্তেষু মত্তেষু তদ্দিনম্ অকস্মাদ্ যুষ্মান্ প্রতি যথা নোপতিষ্ঠতি তদর্থং স্ৱেষু সাৱধানাস্তিষ্ঠত| ");
INSERT INTO sanben_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","পৃথিৱীস্থসর্ৱ্ৱলোকান্ প্রতি তদ্দিনম্ উন্মাথ ইৱ উপস্থাস্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","যথা যূযম্ এতদ্ভাৱিঘটনা উত্তর্ত্তুং মনুজসুতস্য সম্মুখে সংস্থাতুঞ্চ যোগ্যা ভৱথ কারণাদস্মাৎ সাৱধানাঃ সন্তো নিরন্তরং প্রার্থযধ্ৱং| ");
INSERT INTO sanben_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","অপরঞ্চ স দিৱা মন্দির উপদিশ্য রাচৈ জৈতুনাদ্রিং গৎৱাতিষ্ঠৎ| ");
INSERT INTO sanben_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ততঃ প্রত্যূষে লাকাস্তৎকথাং শ্রোতুং মন্দিরে তদন্তিকম্ আগচ্ছন্| ");
INSERT INTO sanben_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","অপরঞ্চ কিণ্ৱশূন্যপূপোৎসৱস্য কাল উপস্থিতে ");
INSERT INTO sanben_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","প্রধানযাজকা অধ্যাযকাশ্চ যথা তং হন্তুং শক্নুৱন্তি তথোপাযাম্ অচেষ্টন্ত কিন্তু লোকেভ্যো বিভ্যুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","এতস্তিন্ সমযে দ্ৱাদশশিষ্যেষু গণিত ঈষ্করিযোতীযরূঢিমান্ যো যিহূদাস্তস্যান্তঃকরণং শৈতানাশ্রিতৎৱাৎ ");
INSERT INTO sanben_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","স গৎৱা যথা যীশুং তেষাং করেষু সমর্পযিতুং শক্নোতি তথা মন্ত্রণাং প্রধানযাজকৈঃ সেনাপতিভিশ্চ সহ চকার| ");
INSERT INTO sanben_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","তেন তে তুষ্টাস্তস্মৈ মুদ্রাং দাতুং পণং চক্রুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ততঃ সোঙ্গীকৃত্য যথা লোকানামগোচরে তং পরকরেষু সমর্পযিতুং শক্নোতি তথাৱকাশং চেষ্টিতুমারেভে| ");
INSERT INTO sanben_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","অথ কিণ্ৱশূন্যপূপোত্মৱদিনে, অর্থাৎ যস্মিন্ দিনে নিস্তারোৎসৱস্য মেষো হন্তৱ্যস্তস্মিন্ দিনে ");
INSERT INTO sanben_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","যীশুঃ পিতরং যোহনঞ্চাহূয জগাদ, যুৱাং গৎৱাস্মাকং ভোজনার্থং নিস্তারোৎসৱস্য দ্রৱ্যাণ্যাসাদযতং| ");
INSERT INTO sanben_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","তদা তৌ পপ্রচ্ছতুঃ কুচাসাদযাৱো ভৱতঃ কেচ্ছা? ");
INSERT INTO sanben_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","তদা সোৱাদীৎ, নগরে প্রৱিষ্টে কশ্চিজ্জলকুম্ভমাদায যুৱাং সাক্ষাৎ করিষ্যতি স যন্নিৱেশনং প্রৱিশতি যুৱামপি তন্নিৱেশনং তৎপশ্চাদিৎৱা নিৱেশনপতিম্ ইতি ৱাক্যং ৱদতং, ");
INSERT INTO sanben_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","যত্রাহং নিস্তারোৎসৱস্য ভোজ্যং শিষ্যৈঃ সার্দ্ধং ভোক্তুং শক্নোমি সাতিথিশালাा কুত্র? কথামিমাং প্রভুস্ত্ৱাং পৃচ্ছতি| ");
INSERT INTO sanben_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ততঃ স জনো দ্ৱিতীযপ্রকোষ্ঠীযম্ একং শস্তং কোষ্ঠং দর্শযিষ্যতি তত্র ভোজ্যমাসাদযতং| ");
INSERT INTO sanben_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ততস্তৌ গৎৱা তদ্ৱাক্যানুসারেণ সর্ৱ্ৱং দৃষ্দ্ৱা তত্র নিস্তারোৎসৱীযং ভোজ্যমাসাদযামাসতুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","অথ কাল উপস্থিতে যীশু র্দ্ৱাদশভিঃ প্রেরিতৈঃ সহ ভোক্তুমুপৱিশ্য কথিতৱান্ ");
INSERT INTO sanben_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","মম দুঃখভোগাৎ পূর্ৱ্ৱং যুভাভিঃ সহ নিস্তারোৎসৱস্যৈতস্য ভোজ্যং ভোক্তুং মযাতিৱাঞ্ছা কৃতা| ");
INSERT INTO sanben_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","যুষ্মান্ ৱদামি, যাৱৎকালম্ ঈশ্ৱররাজ্যে ভোজনং ন করিষ্যে তাৱৎকালম্ ইদং ন ভোক্ষ্যে| ");
INSERT INTO sanben_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","তদা স পানপাত্রমাদায ঈশ্ৱরস্য গুণান্ কীর্ত্তযিৎৱা তেভ্যো দৎৱাৱদৎ, ইদং গৃহ্লীত যূযং ৱিভজ্য পিৱত| ");
INSERT INTO sanben_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","যুষ্মান্ ৱদামি যাৱৎকালম্ ঈশ্ৱররাজৎৱস্য সংস্থাপনং ন ভৱতি তাৱদ্ দ্রাক্ষাফলরসং ন পাস্যামি| ");
INSERT INTO sanben_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ততঃ পূপং গৃহীৎৱা ঈশ্ৱরগুণান্ কীর্ত্তযিৎৱা ভঙ্ক্তা তেভ্যো দৎৱাৱদৎ, যুষ্মদর্থং সমর্পিতং যন্মম ৱপুস্তদিদং, এতৎ কর্ম্ম মম স্মরণার্থং কুরুধ্ৱং| ");
INSERT INTO sanben_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","অথ ভোজনান্তে তাদৃশং পাত্রং গৃহীৎৱাৱদৎ, যুষ্মৎকৃতে পাতিতং যন্মম রক্তং তেন নির্ণীতনৱনিযমরূপং পানপাত্রমিদং| ");
INSERT INTO sanben_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","পশ্যত যো মাং পরকরেষু সমর্পযিষ্যতি স মযা সহ ভোজনাসন উপৱিশতি| ");
INSERT INTO sanben_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","যথা নিরূপিতমাস্তে তদনুসারেণা মনুষ্যপুुত্রস্য গতি র্ভৱিষ্যতি কিন্তু যস্তং পরকরেষু সমর্পযিষ্যতি তস্য সন্তাপো ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","তদা তেষাং কো জন এতৎ কর্ম্ম করিষ্যতি তৎ তে পরস্পরং প্রষ্টুমারেভিরে| ");
INSERT INTO sanben_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","অপরং তেষাং কো জনঃ শ্রেষ্ঠৎৱেন গণযিষ্যতে, অত্রার্থে তেষাং ৱিৱাদোভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","অস্মাৎ কারণাৎ সোৱদৎ, অন্যদেশীযানাং রাজানঃ প্রজানামুপরি প্রভুৎৱং কুর্ৱ্ৱন্তি দারুণশাসনং কৃৎৱাপি তে ভূপতিৎৱেন ৱিখ্যাতা ভৱন্তি চ| ");
INSERT INTO sanben_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","কিন্তু যুষ্মাকং তথা ন ভৱিষ্যতি, যো যুষ্মাকং শ্রেষ্ঠো ভৱিষ্যতি স কনিষ্ঠৱদ্ ভৱতু, যশ্চ মুখ্যো ভৱিষ্যতি স সেৱকৱদ্ভৱতু| ");
INSERT INTO sanben_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","ভোজনোপৱিষ্টপরিচারকযোঃ কঃ শ্রেষ্ঠঃ? যো ভোজনাযোপৱিশতি স কিং শ্রেষ্ঠো ন ভৱতি? কিন্তু যুষ্মাকং মধ্যেঽহং পরিচারকইৱাস্মি| ");
INSERT INTO sanben_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","অপরঞ্চ যুযং মম পরীক্ষাকালে প্রথমমারভ্য মযা সহ স্থিতা ");
INSERT INTO sanben_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","এতৎকারণাৎ পিত্রা যথা মদর্থং রাজ্যমেকং নিরূপিতং তথাহমপি যুষ্মদর্থং রাজ্যং নিরূপযামি| ");
INSERT INTO sanben_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","তস্মান্ মম রাজ্যে ভোজনাসনে চ ভোজনপানে করিষ্যধ্ৱে সিংহাসনেষূপৱিশ্য চেস্রাযেলীযানাং দ্ৱাদশৱংশানাং ৱিচারং করিষ্যধ্ৱে| ");
INSERT INTO sanben_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","অপরং প্রভুরুৱাচ, হে শিমোন্ পশ্য তিতউনা ধান্যানীৱ যুষ্মান্ শৈতান্ চালযিতুম্ ঐচ্ছৎ, ");
INSERT INTO sanben_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","কিন্তু তৱ ৱিশ্ৱাসস্য লোপো যথা ন ভৱতি এতৎ ৎৱদর্থং প্রার্থিতং মযা, ৎৱন্মনসি পরিৱর্ত্তিতে চ ভ্রাতৃণাং মনাংসি স্থিরীকুরু| ");
INSERT INTO sanben_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","তদা সোৱদৎ, হে প্রভোহং ৎৱযা সার্দ্ধং কারাং মৃতিঞ্চ যাতুং মজ্জিতোস্মি| ");
INSERT INTO sanben_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ততঃ স উৱাচ, হে পিতর ৎৱাং ৱদামি, অদ্য কুক্কুটরৱাৎ পূর্ৱ্ৱং ৎৱং মৎপরিচযং ৱারত্রযম্ অপহ্ৱোষ্যসে| ");
INSERT INTO sanben_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","অপরং স পপ্রচ্ছ, যদা মুদ্রাসম্পুটং খাদ্যপাত্রং পাদুকাঞ্চ ৱিনা যুষ্মান্ প্রাহিণৱং তদা যুষ্মাকং কস্যাপি ন্যূনতাসীৎ? তে প্রোচুঃ কস্যাপি ন| ");
INSERT INTO sanben_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","তদা সোৱদৎ কিন্ত্ৱিদানীং মুদ্রাসম্পুটং খাদ্যপাত্রং ৱা যস্যাস্তি তেন তদ্গ্রহীতৱ্যং, যস্য চ কৃপাণোे নাস্তি তেন স্ৱৱস্ত্রং ৱিক্রীয স ক্রেতৱ্যঃ| ");
INSERT INTO sanben_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","যতো যুষ্মানহং ৱদামি, অপরাধিজনৈঃ সার্দ্ধং গণিতঃ স ভৱিষ্যতি| ইদং যচ্ছাস্ত্রীযং ৱচনং লিখিতমস্তি তন্মযি ফলিষ্যতি যতো মম সম্বন্ধীযং সর্ৱ্ৱং সেৎস্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","তদা তে প্রোচুঃ প্রভো পশ্য ইমৌ কৃপাণৌ| ততঃ সোৱদদ্ এতৌ যথেষ্টৌ| ");
INSERT INTO sanben_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","অথ স তস্মাদ্ৱহি র্গৎৱা স্ৱাচারানুসারেণ জৈতুননামাদ্রিং জগাম শিষ্যাশ্চ তৎপশ্চাদ্ যযুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","তত্রোপস্থায স তানুৱাচ, যথা পরীক্ষাযাং ন পতথ তদর্থং প্রার্থযধ্ৱং| ");
INSERT INTO sanben_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","পশ্চাৎ স তস্মাদ্ একশরক্ষেপাদ্ বহি র্গৎৱা জানুনী পাতযিৎৱা এতৎ প্রার্থযাঞ্চক্রে, ");
INSERT INTO sanben_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","হে পিত র্যদি ভৱান্ সম্মন্যতে তর্হি কংসমেনং মমান্তিকাদ্ দূরয কিন্তু মদিচ্ছানুরূপং ন ৎৱদিচ্ছানুরূপং ভৱতু| ");
INSERT INTO sanben_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","তদা তস্মৈ শক্তিং দাতুং স্ৱর্গীযদূতো দর্শনং দদৌ| ");
INSERT INTO sanben_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","পশ্চাৎ সোত্যন্তং যাতনযা ৱ্যাকুলো ভূৎৱা পুনর্দৃঢং প্রার্থযাঞ্চক্রে, তস্মাদ্ বৃহচ্ছোণিতবিন্দৱ ইৱ তস্য স্ৱেদবিন্দৱঃ পৃথিৱ্যাং পতিতুমারেভিরে| ");
INSERT INTO sanben_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","অথ প্রার্থনাত উত্থায শিষ্যাণাং সমীপমেত্য তান্ মনোদুঃখিনো নিদ্রিতান্ দৃষ্ট্ৱাৱদৎ ");
INSERT INTO sanben_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","কুতো নিদ্রাথ? পরীক্ষাযাম্ অপতনার্থং প্রর্থযধ্ৱং| ");
INSERT INTO sanben_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","এতৎকথাযাঃ কথনকালে দ্ৱাদশশিষ্যাণাং মধ্যে গণিতো যিহূদানামা জনতাসহিতস্তেষাম্ অগ্রে চলিৎৱা যীশোশ্চুম্বনার্থং তদন্তিকম্ আযযৌ| ");
INSERT INTO sanben_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","তদা যীশুরুৱাচ, হে যিহূদা কিং চুম্বনেন মনুষ্যপুত্রং পরকরেষু সমর্পযসি? ");
INSERT INTO sanben_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","তদা যদ্যদ্ ঘটিষ্যতে তদনুমায সঙ্গিভিরুক্তং, হে প্রভো ৱযং কি খঙ্গেন ঘাতযিষ্যামঃ? ");
INSERT INTO sanben_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","তত একঃ করৱালেনাহত্য প্রধানযাজকস্য দাসস্য দক্ষিণং কর্ণং চিচ্ছেদ| ");
INSERT INTO sanben_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","অধূনা নিৱর্ত্তস্ৱ ইত্যুক্ত্ৱা যীশুস্তস্য শ্রুতিং স্পৃষ্ট্ৱা স্ৱস্যং চকার| ");
INSERT INTO sanben_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","পশ্চাদ্ যীশুঃ সমীপস্থান্ প্রধানযাজকান্ মন্দিরস্য সেনাপতীন্ প্রাচীনাংশ্চ জগাদ, যূযং কৃপাণান্ যষ্টীংশ্চ গৃহীৎৱা মাং কিং চোরং ধর্ত্তুমাযাতাঃ? ");
INSERT INTO sanben_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","যদাহং যুষ্মাভিঃ সহ প্রতিদিনং মন্দিরেঽতিষ্ঠং তদা মাং ধর্ত্তং ন প্রৱৃত্তাঃ, কিন্ত্ৱিদানীং যুষ্মাকং সমযোন্ধকারস্য চাধিপত্যমস্তি| ");
INSERT INTO sanben_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","অথ তে তং ধৃৎৱা মহাযাজকস্য নিৱেশনং নিন্যুঃ| ততঃ পিতরো দূরে দূরে পশ্চাদিৎৱা ");
INSERT INTO sanben_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","বৃহৎকোষ্ঠস্য মধ্যে যত্রাগ্নিং জ্ৱালযিৎৱা লোকাঃ সমেত্যোপৱিষ্টাস্তত্র তৈঃ সার্দ্ধম্ উপৱিৱেশ| ");
INSERT INTO sanben_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","অথ ৱহ্নিসন্নিধৌ সমুপৱেশকালে কাচিদ্দাসী মনো নিৱিশ্য তং নিরীক্ষ্যাৱদৎ পুমানযং তস্য সঙ্গেঽস্থাৎ| ");
INSERT INTO sanben_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","কিন্তু স তদ্ অপহ্নুত্যাৱাদীৎ হে নারি তমহং ন পরিচিনোমি| ");
INSERT INTO sanben_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","ক্ষণান্তরেঽন্যজনস্তং দৃষ্ট্ৱাব্রৱীৎ ৎৱমপি তেষাং নিকরস্যৈকজনোসি| পিতরঃ প্রত্যুৱাচ হে নর নাহমস্মি| ");
INSERT INTO sanben_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ততঃ সার্দ্ধদণ্ডদ্ৱযাৎ পরং পুনরন্যো জনো নিশ্চিত্য বভাষে, এষ তস্য সঙ্গীতি সত্যং যতোযং গালীলীযো লোকঃ| ");
INSERT INTO sanben_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","তদা পিতর উৱাচ হে নর ৎৱং যদ্ ৱদমি তদহং বোদ্ধুং ন শক্নোমি, ইতি ৱাক্যে কথিতমাত্রে কুক্কুটো রুরাৱ| ");
INSERT INTO sanben_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","তদা প্রভুণা ৱ্যাধুট্য পিতরে নিরীক্ষিতে কৃকৱাকুরৱাৎ পূর্ৱ্ৱং মাং ত্রিরপহ্নোষ্যসে ইতি পূর্ৱ্ৱোক্তং তস্য ৱাক্যং পিতরঃ স্মৃৎৱা ");
INSERT INTO sanben_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","বহির্গৎৱা মহাখেদেন চক্রন্দ| ");
INSERT INTO sanben_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","তদা যৈ র্যীশুর্ধৃতস্তে তমুপহস্য প্রহর্ত্তুমারেভিরে| ");
INSERT INTO sanben_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ৱস্ত্রেণ তস্য দৃশৌ বদ্ধ্ৱা কপোলে চপেটাঘাতং কৃৎৱা পপ্রচ্ছুঃ, কস্তে কপোলে চপেটাঘাতং কৃতৱান? গণযিৎৱা তদ্ ৱদ| ");
INSERT INTO sanben_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","তদন্যৎ তদ্ৱিরুদ্ধং বহুনিন্দাৱাক্যং ৱক্তুমারেভিরে| ");
INSERT INTO sanben_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","অথ প্রভাতে সতি লোকপ্রাঞ্চঃ প্রধানযাজকা অধ্যাপকাশ্চ সভাং কৃৎৱা মধ্যেসভং যীশুমানীয পপ্রচ্ছুঃ, ৎৱম্ অভিষিকতোসি ন ৱাস্মান্ ৱদ| ");
INSERT INTO sanben_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","স প্রত্যুৱাচ, মযা তস্মিন্নুক্তেঽপি যূযং ন ৱিশ্ৱসিষ্যথ| ");
INSERT INTO sanben_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","কস্মিংশ্চিদ্ৱাক্যে যুষ্মান্ পৃষ্টেঽপি মাং ন তদুত্তরং ৱক্ষ্যথ ন মাং ত্যক্ষ্যথ চ| ");
INSERT INTO sanben_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","কিন্ত্ৱিতঃ পরং মনুজসুতঃ সর্ৱ্ৱশক্তিমত ঈশ্ৱরস্য দক্ষিণে পার্শ্ৱে সমুপৱেক্ষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ততস্তে পপ্রচ্ছুঃ, র্তিহ ৎৱমীশ্ৱরস্য পুত্রঃ? স কথযামাস, যূযং যথার্থং ৱদথ স এৱাহং| ");
INSERT INTO sanben_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","তদা তে সর্ৱ্ৱে কথযামাসুঃ, র্তিহ সাক্ষ্যেঽন্সস্মিন্ অস্মাকং কিং প্রযোজনং? অস্য স্ৱমুখাদেৱ সাক্ষ্যং প্রাপ্তম্| ");
INSERT INTO sanben_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ততঃ সভাস্থাঃ সর্ৱ্ৱলোকা উত্থায তং পীলাতসম্মুখং নীৎৱাপ্রোদ্য ৱক্তুমারেভিরে, ");
INSERT INTO sanben_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","স্ৱমভিষিক্তং রাজানং ৱদন্তং কৈমররাজায করদানং নিষেধন্তং রাজ্যৱিপর্য্যযং কুর্ত্তুং প্রৱর্ত্তমানম্ এন প্রাপ্তা ৱযং| ");
INSERT INTO sanben_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","তদা পীলাতস্তং পৃষ্টৱান্ ৎৱং কিং যিহূদীযানাং রাজা? স প্রত্যুৱাচ ৎৱং সত্যমুক্তৱান্| ");
INSERT INTO sanben_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","তদা পীলাতঃ প্রধানযাজকাদিলোকান্ জগাদ্, অহমেতস্য কমপ্যপরাধং নাপ্তৱান্| ");
INSERT INTO sanben_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","ততস্তে পুনঃ সাহমিনো ভূৎৱাৱদন্, এষ গালীল এতৎস্থানপর্য্যন্তে সর্ৱ্ৱস্মিন্ যিহূদাদেশে সর্ৱ্ৱাল্লোকানুপদিশ্য কুপ্রৱৃত্তিং গ্রাহীতৱান্| ");
INSERT INTO sanben_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","তদা পীলাতো গালীলপ্রদেশস্য নাম শ্রুৎৱা পপ্রচ্ছ, কিমযং গালীলীযো লোকঃ? ");
INSERT INTO sanben_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ততঃ স গালীল্প্রদেশীযহেরোদ্রাজস্য তদা স্থিতেস্তস্য সমীপে যীশুং প্রেষযামাস| ");
INSERT INTO sanben_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","তদা হেরোদ্ যীশুং ৱিলোক্য সন্তুতোষ, যতঃ স তস্য বহুৱৃত্তান্তশ্রৱণাৎ তস্য কিঞি्চদাশ্চর্য্যকর্ম্ম পশ্যতি ইত্যাশাং কৃৎৱা বহুকালমারভ্য তং দ্রষ্টুং প্রযাসং কৃতৱান্| ");
INSERT INTO sanben_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","তস্মাৎ তং বহুকথাঃ পপ্রচ্ছ কিন্তু স তস্য কস্যাপি ৱাক্যস্য প্রত্যুত্তরং নোৱাচ| ");
INSERT INTO sanben_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","অথ প্রধানযাজকা অধ্যাপকাশ্চ প্রোত্তিষ্ঠন্তঃ সাহসেন তমপৱদিতুং প্রারেভিরে| ");
INSERT INTO sanben_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","হেরোদ্ তস্য সেনাগণশ্চ তমৱজ্ঞায উপহাসৎৱেন রাজৱস্ত্রং পরিধাপ্য পুনঃ পীলাতং প্রতি তং প্রাহিণোৎ| ");
INSERT INTO sanben_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","পূর্ৱ্ৱং হেরোদ্পীলাতযোঃ পরস্পরং ৱৈরভাৱ আসীৎ কিন্তু তদ্দিনে দ্ৱযো র্মেলনং জাতম্| ");
INSERT INTO sanben_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","পশ্চাৎ পীলাতঃ প্রধানযাজকান্ শাসকান্ লোকাংশ্চ যুগপদাহূয বভাষে, ");
INSERT INTO sanben_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","রাজ্যৱিপর্য্যযকারকোযম্ ইত্যুক্ত্ৱা মনুষ্যমেনং মম নিকটমানৈষ্ট কিন্তু পশ্যত যুষ্মাকং সমক্ষম্ অস্য ৱিচারং কৃৎৱাপি প্রোক্তাপৱাদানুরূপেণাস্য কোপ্যপরাধঃ সপ্রমাণো ন জাতঃ, ");
INSERT INTO sanben_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","যূযঞ্চ হেরোদঃ সন্নিধৌ প্রেষিতা মযা তত্রাস্য কোপ্যপরাধস্তেনাপি ন প্রাপ্তঃ| পশ্যতানেন ৱধহেेতুকং কিমপি নাপরাদ্ধং| ");
INSERT INTO sanben_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","তস্মাদেনং তাডযিৎৱা ৱিহাস্যামি| ");
INSERT INTO sanben_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","তত্রোৎসৱে তেষামেকো মোচযিতৱ্যঃ| ");
INSERT INTO sanben_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ইতি হেতোস্তে প্রোচ্চৈরেকদা প্রোচুঃ, এনং দূরীকৃত্য বরব্বানামানং মোচয| ");
INSERT INTO sanben_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","স বরব্বা নগর উপপ্লৱৱধাপরাধাভ্যাং কারাযাং বদ্ধ আসীৎ| ");
INSERT INTO sanben_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","কিন্তু পীলাতো যীশুং মোচযিতুং ৱাঞ্ছন্ পুনস্তানুৱাচ| ");
INSERT INTO sanben_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","তথাপ্যেনং ক্রুশে ৱ্যধ ক্রুশে ৱ্যধেতি ৱদন্তস্তে রুরুৱুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ততঃ স তৃতীযৱারং জগাদ কুতঃ? স কিং কর্ম্ম কৃতৱান্? নাহমস্য কমপি ৱধাপরাধং প্রাপ্তঃ কেৱলং তাডযিৎৱামুং ত্যজামি| ");
INSERT INTO sanben_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","তথাপি তে পুনরেনং ক্রুশে ৱ্যধ ইত্যুক্ত্ৱা প্রোচ্চৈর্দৃঢং প্রার্থযাঞ্চক্রিরে; ");
INSERT INTO sanben_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ততঃ প্রধানযাজকাদীনাং কলরৱে প্রবলে সতি তেষাং প্রার্থনারূপং কর্ত্তুং পীলাত আদিদেশ| ");
INSERT INTO sanben_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","রাজদ্রোহৱধযোরপরাধেন কারাস্থং যং জনং তে যযাচিরে তং মোচযিৎৱা যীশুং তেষামিচ্ছাযাং সমার্পযৎ| ");
INSERT INTO sanben_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","অথ তে যীশুং গৃহীৎৱা যান্তি, এতর্হি গ্রামাদাগতং শিমোননামানং কুরীণীযং জনং ধৃৎৱা যীশোঃ পশ্চান্নেতুং তস্য স্কন্ধে ক্রুশমর্পযামাসুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ততো লোाকারণ্যমধ্যে বহুস্ত্রিযো রুদত্যো ৱিলপন্ত্যশ্চ যীশোঃ পশ্চাদ্ যযুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","কিন্তু স ৱ্যাঘুট্য তা উৱাচ, হে যিরূশালমো নার্য্যো যুযং মদর্থং ন রুদিৎৱা স্ৱার্থং স্ৱাপত্যার্থঞ্চ রুদিতি; ");
INSERT INTO sanben_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","পশ্যত যঃ কদাপি গর্ভৱত্যো নাভৱন্ স্তন্যঞ্চ নাপাযযন্ তাদৃশী র্ৱন্ধ্যা যদা ধন্যা ৱক্ষ্যন্তি স কাল আযাতি| ");
INSERT INTO sanben_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","তদা হে শৈলা অস্মাকমুপরি পতত, হে উপশৈলা অস্মানাচ্ছাদযত কথামীদৃশীং লোকা ৱক্ষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","যতঃ সতেজসি শাখিনি চেদেতদ্ ঘটতে তর্হি শুষ্কশাখিনি কিং ন ঘটিষ্যতে? ");
INSERT INTO sanben_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","তদা তে হন্তুং দ্ৱাৱপরাধিনৌ তেন সার্দ্ধং নিন্যুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","অপরং শিরঃকপালনামকস্থানং প্রাপ্য তং ক্রুশে ৱিৱিধুঃ; তদ্দ্ৱযোরপরাধিনোরেকং তস্য দক্ষিণো তদন্যং ৱামে ক্রুশে ৱিৱিধুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","তদা যীশুরকথযৎ, হে পিতরেতান্ ক্ষমস্ৱ যত এতে যৎ কর্ম্ম কুর্ৱ্ৱন্তি তন্ ন ৱিদুঃ; পশ্চাত্তে গুটিকাপাতং কৃৎৱা তস্য ৱস্ত্রাণি ৱিভজ্য জগৃহুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","তত্র লোকসংঘস্তিষ্ঠন্ দদর্শ; তে তেষাং শাসকাশ্চ তমুপহস্য জগদুঃ, এষ ইতরান্ রক্ষিতৱান্ যদীশ্ৱরেণাভিরুচিতো ঽভিষিক্তস্ত্রাতা ভৱতি তর্হি স্ৱমধুনা রক্ষতু| ");
INSERT INTO sanben_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","তদন্যঃ সেনাগণা এত্য তস্মৈ অম্লরসং দৎৱা পরিহস্য প্রোৱাচ, ");
INSERT INTO sanben_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","চেত্ত্ৱং যিহূদীযানাং রাজাসি তর্হি স্ৱং রক্ষ| ");
INSERT INTO sanben_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","যিহূদীযানাং রাজেতি ৱাক্যং যূনানীযরোমীযেব্রীযাক্ষরৈ র্লিখিতং তচ্ছিরস ঊর্দ্ধ্ৱেঽস্থাপ্যত| ");
INSERT INTO sanben_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","তদোভযপার্শ্ৱযো র্ৱিদ্ধৌ যাৱপরাধিনৌ তযোরেকস্তং ৱিনিন্দ্য বভাষে, চেত্ত্ৱম্ অভিষিক্তোসি তর্হি স্ৱমাৱাঞ্চ রক্ষ| ");
INSERT INTO sanben_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","কিন্ত্ৱন্যস্তং তর্জযিৎৱাৱদৎ, ঈশ্ৱরাত্তৱ কিঞ্চিদপি ভযং নাস্তি কিং? ৎৱমপি সমানদণ্ডোসি, ");
INSERT INTO sanben_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","যোগ্যপাত্রে আৱাং স্ৱস্ৱকর্ম্মণাং সমুচিতফলং প্রাপ্নুৱঃ কিন্ত্ৱনেন কিমপি নাপরাদ্ধং| ");
INSERT INTO sanben_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","অথ স যীশুং জগাদ হে প্রভে ভৱান্ স্ৱরাজ্যপ্রৱেশকালে মাং স্মরতু| ");
INSERT INTO sanben_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","তদা যীশুঃ কথিতৱান্ ৎৱাং যথার্থং ৱদামি ৎৱমদ্যৈৱ মযা সার্দ্ধং পরলোকস্য সুখস্থানং প্রাপ্স্যসি| ");
INSERT INTO sanben_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","অপরঞ্চ দ্ৱিতীযযামাৎ তৃতীযযামপর্য্যন্তং রৱেস্তেজসোন্তর্হিতৎৱাৎ সর্ৱ্ৱদেশোঽন্ধকারেণাৱৃতো ");
INSERT INTO sanben_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","মন্দিরস্য যৱনিকা চ ছিদ্যমানা দ্ৱিধা বভূৱ| ");
INSERT INTO sanben_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ততো যীশুরুচ্চৈরুৱাচ, হে পিত র্মমাত্মানং তৱ করে সমর্পযে, ইত্যুক্ত্ৱা স প্রাণান্ জহৌ| ");
INSERT INTO sanben_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","তদৈতা ঘটনা দৃষ্ট্ৱা শতসেনাপতিরীশ্ৱরং ধন্যমুক্ত্ৱা কথিতৱান্ অযং নিতান্তং সাধুমনুষ্য আসীৎ| ");
INSERT INTO sanben_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","অথ যাৱন্তো লোকা দ্রষ্টুম্ আগতাস্তে তা ঘটনা দৃষ্ট্ৱা ৱক্ষঃসু করাঘাতং কৃৎৱা ৱ্যাচুট্য গতাঃ| ");
INSERT INTO sanben_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","যীশো র্জ্ঞাতযো যা যা যোষিতশ্চ গালীলস্তেন সার্দ্ধমাযাতাস্তা অপি দূরে স্থিৎৱা তৎ সর্ৱ্ৱং দদৃশুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","তদা যিহূদীযানাং মন্ত্রণাং ক্রিযাঞ্চাসম্মন্যমান ঈশ্ৱরস্য রাজৎৱম্ অপেক্ষমাণো ");
INSERT INTO sanben_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","যিহূদিদেশীযো ঽরিমথীযনগরীযো যূষফ্নামা মন্ত্রী ভদ্রো ধার্ম্মিকশ্চ পুমান্ ");
INSERT INTO sanben_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","পীলাতান্তিকং গৎৱা যীশো র্দেহং যযাচে| ");
INSERT INTO sanben_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","পশ্চাদ্ ৱপুরৱরোহ্য ৱাসসা সংৱেষ্ট্য যত্র কোপি মানুষো নাস্থাপ্যত তস্মিন্ শৈলে স্ৱাতে শ্মশানে তদস্থাপযৎ| ");
INSERT INTO sanben_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","তদ্দিনমাযোজনীযং দিনং ৱিশ্রামৱারশ্চ সমীপঃ| ");
INSERT INTO sanben_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","অপরং যীশুনা সার্দ্ধং গালীল আগতা যোষিতঃ পশ্চাদিৎৱা শ্মশানে তত্র যথা ৱপুঃ স্থাপিতং তচ্চ দৃষ্ট্ৱা ");
INSERT INTO sanben_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ৱ্যাঘুট্য সুগন্ধিদ্রৱ্যতৈলানি কৃৎৱা ৱিধিৱদ্ ৱিশ্রামৱারে ৱিশ্রামং চক্রুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","অথ সপ্তাহপ্রথমদিনেঽতিপ্রত্যূষে তা যোষিতঃ সম্পাদিতং সুগন্ধিদ্রৱ্যং গৃহীৎৱা তদন্যাভিঃ কিযতীভিঃ স্ত্রীভিঃ সহ শ্মশানং যযুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","কিন্তু শ্মশানদ্ৱারাৎ পাষাণমপসারিতং দৃষ্ট্ৱা ");
INSERT INTO sanben_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","তাঃ প্রৱিশ্য প্রভো র্দেহমপ্রাপ্য ");
INSERT INTO sanben_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ৱ্যাকুলা ভৱন্তি এতর্হি তেজোমযৱস্ত্রান্ৱিতৌ দ্ৱৌ পুরুষৌ তাসাং সমীপে সমুপস্থিতৌ ");
INSERT INTO sanben_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","তস্মাত্তাঃ শঙ্কাযুক্তা ভূমাৱধোমুখ্যস্যস্থুঃ| তদা তৌ তা ঊচতু র্মৃতানাং মধ্যে জীৱন্তং কুতো মৃগযথ? ");
INSERT INTO sanben_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","সোত্র নাস্তি স উদস্থাৎ| ");
INSERT INTO sanben_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","পাপিনাং করেষু সমর্পিতেন ক্রুশে হতেন চ মনুষ্যপুত্রেণ তৃতীযদিৱসে শ্মশানাদুত্থাতৱ্যম্ ইতি কথাং স গলীলি তিষ্ঠন্ যুষ্মভ্যং কথিতৱান্ তাং স্মরত| ");
INSERT INTO sanben_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","তদা তস্য সা কথা তাসাং মনঃসু জাতা| ");
INSERT INTO sanben_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","অনন্তরং শ্মশানাদ্ গৎৱা তা একাদশশিষ্যাদিভ্যঃ সর্ৱ্ৱেভ্যস্তাং ৱার্ত্তাং কথযামাসুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","মগ্দলীনীমরিযম্, যোহনা, যাকূবো মাতা মরিযম্ তদন্যাঃ সঙ্গিন্যো যোষিতশ্চ প্রেরিতেভ্য এতাঃ সর্ৱ্ৱা ৱার্ত্তাঃ কথযামাসুঃ ");
INSERT INTO sanben_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","কিন্তু তাসাং কথাম্ অনর্থকাখ্যানমাত্রং বুদ্ধ্ৱা কোপি ন প্রত্যৈৎ| ");
INSERT INTO sanben_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","তদা পিতর উত্থায শ্মশানান্তিকং দধাৱ, তত্র চ প্রহ্ৱো ভূৎৱা পার্শ্ৱৈকস্থাপিতং কেৱলং ৱস্ত্রং দদর্শ; তস্মাদাশ্চর্য্যং মন্যমানো যদঘটত তন্মনসি ৱিচারযন্ প্রতস্থে| ");
INSERT INTO sanben_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","তস্মিন্নেৱ দিনে দ্ৱৌ শিয্যৌ যিরূশালমশ্চতুষ্ক্রোশান্তরিতম্ ইম্মাযুগ্রামং গচ্ছন্তৌ ");
INSERT INTO sanben_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","তাসাং ঘটনানাং কথামকথযতাং ");
INSERT INTO sanben_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","তযোরালাপৱিচারযোঃ কালে যীশুরাগত্য তাভ্যাং সহ জগাম ");
INSERT INTO sanben_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","কিন্তু যথা তৌ তং ন পরিচিনুতস্তদর্থং তযো র্দৃষ্টিঃ সংরুদ্ধা| ");
INSERT INTO sanben_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","স তৌ পৃষ্টৱান্ যুৱাং ৱিষণ্ণৌ কিং ৱিচারযন্তৌ গচ্ছথঃ? ");
INSERT INTO sanben_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ততস্তযোঃ ক্লিযপানামা প্রত্যুৱাচ যিরূশালমপুরেঽধুনা যান্যঘটন্ত ৎৱং কেৱলৱিদেশী কিং তদ্ৱৃত্তান্তং ন জানাসি? ");
INSERT INTO sanben_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","স পপ্রচ্ছ কা ঘটনাঃ? তদা তৌ ৱক্তুমারেভাতে যীশুনামা যো নাসরতীযো ভৱিষ্যদ্ৱাদী ঈশ্ৱরস্য মানুষাণাঞ্চ সাক্ষাৎ ৱাক্যে কর্ম্মণি চ শক্তিমানাসীৎ ");
INSERT INTO sanben_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","তম্ অস্মাকং প্রধানযাজকা ৱিচারকাশ্চ কেনাপি প্রকারেণ ক্রুশে ৱিদ্ধ্ৱা তস্য প্রাণাননাশযন্ তদীযা ঘটনাঃ; ");
INSERT INTO sanben_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","কিন্তু য ইস্রাযেলীযলোকান্ উদ্ধারযিষ্যতি স এৱাযম্ ইত্যাশাস্মাভিঃ কৃতা| তদ্যথা তথাস্তু তস্যা ঘটনাযা অদ্য দিনত্রযং গতং| ");
INSERT INTO sanben_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","অধিকন্ত্ৱস্মাকং সঙ্গিনীনাং কিযৎস্ত্রীণাং মুখেভ্যোঽসম্ভৱৱাক্যমিদং শ্রুতং; ");
INSERT INTO sanben_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","তাঃ প্রত্যূষে শ্মশানং গৎৱা তত্র তস্য দেহম্ অপ্রাপ্য ৱ্যাঘুট্যেৎৱা প্রোক্তৱত্যঃ স্ৱর্গীসদূতৌ দৃষ্টাৱস্মাভিস্তৌ চাৱাদিষ্টাং স জীৱিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ততোস্মাকং কৈশ্চিৎ শ্মশানমগম্যত তেঽপি স্ত্রীণাং ৱাক্যানুরূপং দৃষ্টৱন্তঃ কিন্তু তং নাপশ্যন্| ");
INSERT INTO sanben_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","তদা স তাৱুৱাচ, হে অবোধৌ হে ভৱিষ্যদ্ৱাদিভিরুক্তৱাক্যং প্রত্যেতুং ৱিলম্বমানৌ; ");
INSERT INTO sanben_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","এতৎসর্ৱ্ৱদুঃখং ভুক্ত্ৱা স্ৱভূতিপ্রাপ্তিঃ কিং খ্রীষ্টস্য ন ন্যায্যা? ");
INSERT INTO sanben_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ততঃ স মূসাগ্রন্থমারভ্য সর্ৱ্ৱভৱিষ্যদ্ৱাদিনাং সর্ৱ্ৱশাস্ত্রে স্ৱস্মিন্ লিখিতাখ্যানাভিপ্রাযং বোধযামাস| ");
INSERT INTO sanben_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","অথ গম্যগ্রামাভ্যর্ণং প্রাপ্য তেনাগ্রে গমনলক্ষণে দর্শিতে ");
INSERT INTO sanben_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","তৌ সাধযিৎৱাৱদতাং সহাৱাভ্যাং তিষ্ঠ দিনে গতে সতি রাত্রিরভূৎ; ততঃ স তাভ্যাং সার্দ্ধং স্থাতুং গৃহং যযৌ| ");
INSERT INTO sanben_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","পশ্চাদ্ভোজনোপৱেশকালে স পূপং গৃহীৎৱা ঈশ্ৱরগুণান্ জগাদ তঞ্চ ভংক্ত্ৱা তাভ্যাং দদৌ| ");
INSERT INTO sanben_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","তদা তযো র্দৃষ্টৌ প্রসন্নাযাং তং প্রত্যভিজ্ঞতুঃ কিন্তু স তযোঃ সাক্ষাদন্তর্দধে| ");
INSERT INTO sanben_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ততস্তৌ মিথোভিধাতুম্ আরব্ধৱন্তৌ গমনকালে যদা কথামকথযৎ শাস্ত্রার্থঞ্চবোধযৎ তদাৱযো র্বুদ্ধিঃ কিং ন প্রাজ্ৱলৎ? ");
INSERT INTO sanben_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","তৌ তৎক্ষণাদুত্থায যিরূশালমপুরং প্রত্যাযযতুঃ, তৎস্থানে শিষ্যাণাম্ একাদশানাং সঙ্গিনাঞ্চ দর্শনং জাতং| ");
INSERT INTO sanben_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","তে প্রোচুঃ প্রভুরুদতিষ্ঠদ্ ইতি সত্যং শিমোনে দর্শনমদাচ্চ| ");
INSERT INTO sanben_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","ততঃ পথঃ সর্ৱ্ৱঘটনাযাঃ পূপভঞ্জনেন তৎপরিচযস্য চ সর্ৱ্ৱৱৃত্তান্তং তৌ ৱক্তুমারেভাতে| ");
INSERT INTO sanben_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ইত্থং তে পরস্পরং ৱদন্তি তৎকালে যীশুঃ স্ৱযং তেষাং মধ্য প্রোত্থয যুষ্মাকং কল্যাণং ভূযাদ্ ইত্যুৱাচ, ");
INSERT INTO sanben_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","কিন্তু ভূতং পশ্যাম ইত্যনুমায তে সমুদ্ৱিৱিজিরে ত্রেষুশ্চ| ");
INSERT INTO sanben_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","স উৱাচ, কুতো দুঃখিতা ভৱথ? যুষ্মাকং মনঃসু সন্দেহ উদেতি চ কুতঃ? ");
INSERT INTO sanben_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","এষোহং, মম করৌ পশ্যত ৱরং স্পৃষ্ট্ৱা পশ্যত, মম যাদৃশানি পশ্যথ তাদৃশানি ভূতস্য মাংসাস্থীনি ন সন্তি| ");
INSERT INTO sanben_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ইত্যুক্ত্ৱা স হস্তপাদান্ দর্শযামাস| ");
INSERT INTO sanben_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","তেঽসম্ভৱং জ্ঞাৎৱা সানন্দা ন প্রত্যযন্| ততঃ স তান্ পপ্রচ্ছ, অত্র যুষ্মাকং সমীপে খাদ্যং কিঞ্চিদস্তি? ");
INSERT INTO sanben_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ততস্তে কিযদ্দগ্ধমৎস্যং মধু চ দদুঃ ");
INSERT INTO sanben_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","স তদাদায তেষাং সাক্ষাদ্ বুভুজে ");
INSERT INTO sanben_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","কথযামাস চ মূসাৱ্যৱস্থাযাং ভৱিষ্যদ্ৱাদিনাং গ্রন্থেষু গীতপুস্তকে চ মযি যানি সর্ৱ্ৱাণি ৱচনানি লিখিতানি তদনুরূপাণি ঘটিষ্যন্তে যুষ্মাভিঃ সার্দ্ধং স্থিৎৱাহং যদেতদ্ৱাক্যম্ অৱদং তদিদানীং প্রত্যক্ষমভূৎ| ");
INSERT INTO sanben_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","অথ তেভ্যঃ শাস্ত্রবোধাধিকারং দৎৱাৱদৎ, ");
INSERT INTO sanben_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","খ্রীষ্টেনেত্থং মৃতিযাতনা ভোক্তৱ্যা তৃতীযদিনে চ শ্মশানাদুত্থাতৱ্যঞ্চেতি লিপিরস্তি; ");
INSERT INTO sanben_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","তন্নাম্না যিরূশালমমারভ্য সর্ৱ্ৱদেশে মনঃপরাৱর্ত্তনস্য পাপমোচনস্য চ সুসংৱাদঃ প্রচারযিতৱ্যঃ, ");
INSERT INTO sanben_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","এষু সর্ৱ্ৱেষু যূযং সাক্ষিণঃ| ");
INSERT INTO sanben_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","অপরঞ্চ পশ্যত পিত্রা যৎ প্রতিজ্ঞাতং তৎ প্রেষযিষ্যামি, অতএৱ যাৱৎকালং যূযং স্ৱর্গীযাং শক্তিং ন প্রাপ্স্যথ তাৱৎকালং যিরূশালম্নগরে তিষ্ঠত| ");
INSERT INTO sanben_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","অথ স তান্ বৈথনীযাপর্য্যন্তং নীৎৱা হস্তাৱুত্তোল্য আশিষ ৱক্তুমারেভে ");
INSERT INTO sanben_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","আশিষং ৱদন্নেৱ চ তেভ্যঃ পৃথগ্ ভূৎৱা স্ৱর্গায নীতোঽভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","তদা তে তং ভজমানা মহানন্দেন যিরূশালমং প্রত্যাজগ্মুঃ| ");
INSERT INTO sanben_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ততো নিরন্তরং মন্দিরে তিষ্ঠন্ত ঈশ্ৱরস্য প্রশংসাং ধন্যৱাদঞ্চ কর্ত্তম্ আরেভিরে| ইতি||");
INSERT INTO sanben_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","আদৌ ৱাদ আসীৎ স চ ৱাদ ঈশ্ৱরেণ সার্ধমাসীৎ স ৱাদঃ স্ৱযমীশ্ৱর এৱ| ");
INSERT INTO sanben_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","স আদাৱীশ্ৱরেণ সহাসীৎ| ");
INSERT INTO sanben_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","তেন সর্ৱ্ৱং ৱস্তু সসৃজে সর্ৱ্ৱেষু সৃষ্টৱস্তুষু কিমপি ৱস্তু তেনাসৃষ্টং নাস্তি| ");
INSERT INTO sanben_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","স জীৱনস্যাকারঃ, তচ্চ জীৱনং মনুষ্যাণাং জ্যোতিঃ ");
INSERT INTO sanben_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","তজ্জ্যোতিরন্ধকারে প্রচকাশে কিন্ত্ৱন্ধকারস্তন্ন জগ্রাহ| ");
INSERT INTO sanben_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","যোহন্ নামক একো মনুজ ঈশ্ৱরেণ প্রেষযাঞ্চক্রে| ");
INSERT INTO sanben_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","তদ্ৱারা যথা সর্ৱ্ৱে ৱিশ্ৱসন্তি তদর্থং স তজ্জ্যোতিষি প্রমাণং দাতুং সাক্ষিস্ৱরূপো ভূৎৱাগমৎ, ");
INSERT INTO sanben_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","স স্ৱযং তজ্জ্যোতি র্ন কিন্তু তজ্জ্যোতিষি প্রমাণং দাতুমাগমৎ| ");
INSERT INTO sanben_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","জগত্যাগত্য যঃ সর্ৱ্ৱমনুজেভ্যো দীপ্তিং দদাতি তদেৱ সত্যজ্যোতিঃ| ");
INSERT INTO sanben_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","স যজ্জগদসৃজৎ তন্মদ্য এৱ স আসীৎ কিন্তু জগতো লোকাস্তং নাজানন্| ");
INSERT INTO sanben_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","নিজাধিকারং স আগচ্ছৎ কিন্তু প্রজাস্তং নাগৃহ্লন্| ");
INSERT INTO sanben_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","তথাপি যে যে তমগৃহ্লন্ অর্থাৎ তস্য নাম্নি ৱ্যশ্ৱসন্ তেভ্য ঈশ্ৱরস্য পুত্রা ভৱিতুম্ অধিকারম্ অদদাৎ| ");
INSERT INTO sanben_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","তেষাং জনিঃ শোণিতান্ন শারীরিকাভিলাষান্ন মানৱানামিচ্ছাতো ন কিন্ত্ৱীশ্ৱরাদভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","স ৱাদো মনুষ্যরূপেণাৱতীর্য্য সত্যতানুগ্রহাভ্যাং পরিপূর্ণঃ সন্ সার্ধম্ অস্মাভি র্ন্যৱসৎ ততঃ পিতুরদ্ৱিতীযপুত্রস্য যোগ্যো যো মহিমা তং মহিমানং তস্যাপশ্যাম| ");
INSERT INTO sanben_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ততো যোহনপি প্রচার্য্য সাক্ষ্যমিদং দত্তৱান্ যো মম পশ্চাদ্ আগমিষ্যতি স মত্তো গুরুতরঃ; যতো মৎপূর্ৱ্ৱং স ৱিদ্যমান আসীৎ; যদর্থম্ অহং সাক্ষ্যমিদম্ অদাং স এষঃ| ");
INSERT INTO sanben_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","অপরঞ্চ তস্য পূর্ণতাযা ৱযং সর্ৱ্ৱে ক্রমশঃ ক্রমশোনুগ্রহং প্রাপ্তাঃ| ");
INSERT INTO sanben_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","মূসাদ্ৱারা ৱ্যৱস্থা দত্তা কিন্ত্ৱনুগ্রহঃ সত্যৎৱঞ্চ যীশুখ্রীষ্টদ্ৱারা সমুপাতিষ্ঠতাং| ");
INSERT INTO sanben_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","কোপি মনুজ ঈশ্ৱরং কদাপি নাপশ্যৎ কিন্তু পিতুঃ ক্রোডস্থোঽদ্ৱিতীযঃ পুত্রস্তং প্রকাশযৎ| ");
INSERT INTO sanben_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","ৎৱং কঃ? ইতি ৱাক্যং প্রেষ্টুং যদা যিহূদীযলোকা যাজকান্ লেৱিলোকাংশ্চ যিরূশালমো যোহনঃ সমীপে প্রেষযামাসুঃ, ");
INSERT INTO sanben_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","তদা স স্ৱীকৃতৱান্ নাপহ্নূতৱান্ নাহম্ অভিষিক্ত ইত্যঙ্গীকৃতৱান্| ");
INSERT INTO sanben_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","তদা তেঽপৃচ্ছন্ তর্হি কো ভৱান্? কিং এলিযঃ? সোৱদৎ ন; ততস্তেঽপৃচ্ছন্ তর্হি ভৱান্ স ভৱিষ্যদ্ৱাদী? সোৱদৎ নাহং সঃ| ");
INSERT INTO sanben_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","তদা তেঽপৃচ্ছন্ তর্হি ভৱান্ কঃ? ৱযং গৎৱা প্রেরকান্ ৎৱযি কিং ৱক্ষ্যামঃ? স্ৱস্মিন্ কিং ৱদসি? ");
INSERT INTO sanben_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","তদা সোৱদৎ| পরমেশস্য পন্থানং পরিষ্কুরুত সর্ৱ্ৱতঃ| ইতীদং প্রান্তরে ৱাক্যং ৱদতঃ কস্যচিদ্রৱঃ| কথামিমাং যস্মিন্ যিশযিযো ভৱিষ্যদ্ৱাদী লিখিতৱান্ সোহম্| ");
INSERT INTO sanben_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","যে প্রেষিতাস্তে ফিরূশিলোকাঃ| ");
INSERT INTO sanben_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","তদা তেঽপৃচ্ছন্ যদি নাভিষিক্তোসি এলিযোসি ন স ভৱিষ্যদ্ৱাদ্যপি নাসি চ, তর্হি লোকান্ মজ্জযসি কুতঃ? ");
INSERT INTO sanben_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ততো যোহন্ প্রত্যৱোচৎ, তোযেঽহং মজ্জযামীতি সত্যং কিন্তু যং যূযং ন জানীথ তাদৃশ একো জনো যুষ্মাকং মধ্য উপতিষ্ঠতি| ");
INSERT INTO sanben_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","স মৎপশ্চাদ্ আগতোপি মৎপূর্ৱ্ৱং ৱর্ত্তমান আসীৎ তস্য পাদুকাবন্ধনং মোচযিতুমপি নাহং যোগ্যোস্মি| ");
INSERT INTO sanben_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","যর্দ্দননদ্যাঃ পারস্থবৈথবারাযাং যস্মিন্স্থানে যোহনমজ্জযৎ তস্মিন স্থানে সর্ৱ্ৱমেতদ্ অঘটত| ");
INSERT INTO sanben_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","পরেঽহনি যোহন্ স্ৱনিকটমাগচ্ছন্তং যিশুং ৱিলোক্য প্রাৱোচৎ জগতঃ পাপমোচকম্ ঈশ্ৱরস্য মেষশাৱকং পশ্যত| ");
INSERT INTO sanben_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","যো মম পশ্চাদাগমিষ্যতি স মত্তো গুরুতরঃ, যতো হেতোর্মৎপূর্ৱ্ৱং সোঽৱর্ত্তত যস্মিন্নহং কথামিমাং কথিতৱান্ স এৱাযং| ");
INSERT INTO sanben_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","অপরং নাহমেনং প্রত্যভিজ্ঞাতৱান্ কিন্তু ইস্রাযেল্লোকা এনং যথা পরিচিন্ৱন্তি তদভিপ্রাযেণাহং জলে মজ্জযিতুমাগচ্ছম্| ");
INSERT INTO sanben_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","পুনশ্চ যোহনপরমেকং প্রমাণং দৎৱা কথিতৱান্ ৱিহাযসঃ কপোতৱদ্ অৱতরন্তমাত্মানম্ অস্যোপর্য্যৱতিষ্ঠন্তং চ দৃষ্টৱানহম্| ");
INSERT INTO sanben_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","নাহমেনং প্রত্যভিজ্ঞাতৱান্ ইতি সত্যং কিন্তু যো জলে মজ্জযিতুং মাং প্রৈরযৎ স এৱেমাং কথামকথযৎ যস্যোপর্য্যাত্মানম্ অৱতরন্তম্ অৱতিষ্ঠন্তঞ্চ দ্রক্ষযসি সএৱ পৱিত্রে আত্মনি মজ্জযিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","অৱস্তন্নিরীক্ষ্যাযম্ ঈশ্ৱরস্য তনয ইতি প্রমাণং দদামি| ");
INSERT INTO sanben_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","পরেঽহনি যোহন্ দ্ৱাভ্যাং শিষ্যাভ্যাং সার্দ্ধেং তিষ্ঠন্ ");
INSERT INTO sanben_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","যিশুং গচ্ছন্তং ৱিলোক্য গদিতৱান্, ঈশ্ৱরস্য মেষশাৱকং পশ্যতং| ");
INSERT INTO sanben_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ইমাং কথাং শ্রুৎৱা দ্ৱৌ শিষ্যৌ যীশোঃ পশ্চাদ্ ঈযতুঃ| ");
INSERT INTO sanben_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ততো যীশুঃ পরাৱৃত্য তৌ পশ্চাদ্ আগচ্ছন্তৌ দৃষ্ট্ৱা পৃষ্টৱান্ যুৱাং কিং গৱেশযথঃ? তাৱপৃচ্ছতাং হে রব্বি অর্থাৎ হে গুরো ভৱান্ কুত্র তিষ্ঠতি? ");
INSERT INTO sanben_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ততঃ সোৱাদিৎ এত্য পশ্যতং| ততো দিৱসস্য তৃতীযপ্রহরস্য গতৎৱাৎ তৌ তদ্দিনং তস্য সঙ্গেঽস্থাতাং| ");
INSERT INTO sanben_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","যৌ দ্ৱৌ যোহনো ৱাক্যং শ্রুৎৱা যিশোঃ পশ্চাদ্ আগমতাং তযোঃ শিমোন্পিতরস্য ভ্রাতা আন্দ্রিযঃ ");
INSERT INTO sanben_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","স ইৎৱা প্রথমং নিজসোদরং শিমোনং সাক্ষাৎপ্রাপ্য কথিতৱান্ ৱযং খ্রীষ্টম্ অর্থাৎ অভিষিক্তপুরুষং সাক্ষাৎকৃতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","পশ্চাৎ স তং যিশোঃ সমীপম্ আনযৎ| তদা যীশুস্তং দৃষ্ট্ৱাৱদৎ ৎৱং যূনসঃ পুত্রঃ শিমোন্ কিন্তু ৎৱন্নামধেযং কৈফাঃ ৱা পিতরঃ অর্থাৎ প্রস্তরো ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","পরেঽহনি যীশৌ গালীলং গন্তুং নিশ্চিতচেতসি সতি ফিলিপনামানং জনং সাক্ষাৎপ্রাপ্যাৱোচৎ মম পশ্চাদ্ আগচ্ছ| ");
INSERT INTO sanben_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","বৈৎসৈদানাম্নি যস্মিন্ গ্রামে পিতরান্দ্রিযযোর্ৱাস আসীৎ তস্মিন্ গ্রামে তস্য ফিলিপস্য ৱসতিরাসীৎ| ");
INSERT INTO sanben_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","পশ্চাৎ ফিলিপো নিথনেলং সাক্ষাৎপ্রাপ্যাৱদৎ মূসা ৱ্যৱস্থা গ্রন্থে ভৱিষ্যদ্ৱাদিনাং গ্রন্থেষু চ যস্যাখ্যানং লিখিতমাস্তে তং যূষফঃ পুত্রং নাসরতীযং যীশুং সাক্ষাদ্ অকার্ষ্ম ৱযং| ");
INSERT INTO sanben_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","তদা নিথনেল্ কথিতৱান্ নাসরন্নগরাত কিং কশ্চিদুত্তম উৎপন্তুং শক্নোতি? ততঃ ফিলিপো ঽৱোচৎ এত্য পশ্য| ");
INSERT INTO sanben_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","অপরঞ্চ যীশুঃ স্ৱস্য সমীপং তম্ আগচ্ছন্তং দৃষ্ট্ৱা ৱ্যাহৃতৱান্, পশ্যাযং নিষ্কপটঃ সত্য ইস্রাযেল্লোকঃ| ");
INSERT INTO sanben_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","ততঃ সোৱদদ্, ভৱান্ মাং কথং প্রত্যভিজানাতি? যীশুরৱাদীৎ ফিলিপস্য আহ্ৱানাৎ পূর্ৱ্ৱং যদা ৎৱমুডুম্বরস্য তরোর্মূলেঽস্থাস্তদা ৎৱামদর্শম্| ");
INSERT INTO sanben_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","নিথনেল্ অচকথৎ, হে গুরো ভৱান্ নিতান্তম্ ঈশ্ৱরস্য পুত্রোসি, ভৱান্ ইস্রাযেল্ৱংশস্য রাজা| ");
INSERT INTO sanben_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ততো যীশু র্ৱ্যাহরৎ, ৎৱামুডুম্বরস্য পাদপস্য মূলে দৃষ্টৱানাহং মমৈতস্মাদ্ৱাক্যাৎ কিং ৎৱং ৱ্যশ্ৱসীঃ? এতস্মাদপ্যাশ্চর্য্যাণি কার্য্যাণি দ্রক্ষ্যসি| ");
INSERT INTO sanben_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","অন্যচ্চাৱাদীদ্ যুষ্মানহং যথার্থং ৱদামি, ইতঃ পরং মোচিতে মেঘদ্ৱারে তস্মান্মনুজসূনুনা ঈশ্ৱরস্য দূতগণম্ অৱরোহন্তমারোহন্তঞ্চ দ্রক্ষ্যথ| ");
INSERT INTO sanben_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","অনন্তরং ত্রুতীযদিৱসে গালীল্ প্রদেশিযে কান্নানাম্নি নগরে ৱিৱাহ আসীৎ তত্র চ যীশোর্মাতা তিষ্ঠৎ| ");
INSERT INTO sanben_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","তস্মৈ ৱিৱাহায যীশুস্তস্য শিষ্যাশ্চ নিমন্ত্রিতা আসন্| ");
INSERT INTO sanben_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","তদনন্তরং দ্রাক্ষারসস্য ন্যূনৎৱাদ্ যীশোর্মাতা তমৱদৎ এতেষাং দ্রাক্ষারসো নাস্তি| ");
INSERT INTO sanben_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","তদা স তামৱোচৎ হে নারি মযা সহ তৱ কিং কার্য্যং? মম সময ইদানীং নোপতিষ্ঠতি| ");
INSERT INTO sanben_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","ততস্তস্য মাতা দাসানৱোচদ্ অযং যদ্ ৱদতি তদেৱ কুরুত| ");
INSERT INTO sanben_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","তস্মিন্ স্থানে যিহূদীযানাং শুচিৎৱকরণৱ্যৱহারানুসারেণাঢকৈকজলধরাণি পাষাণমযানি ষড্ৱৃহৎপাত্রাণিআসন্| ");
INSERT INTO sanben_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","তদা যীশুস্তান্ সর্ৱ্ৱকলশান্ জলৈঃ পূরযিতুং তানাজ্ঞাপযৎ, ততস্তে সর্ৱ্ৱান্ কুম্ভানাকর্ণং জলৈঃ পর্য্যপূরযন্| ");
INSERT INTO sanben_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","অথ তেভ্যঃ কিঞ্চিদুত্তার্য্য ভোজ্যাধিপাতেঃসমীপং নেতুং স তানাদিশৎ, তে তদনযন্| ");
INSERT INTO sanben_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","অপরঞ্চ তজ্জলং কথং দ্রাক্ষারসোঽভৱৎ তজ্জলৱাহকাদাসা জ্ঞাতুং শক্তাঃ কিন্তু তদ্ভোজ্যাধিপো জ্ঞাতুং নাশক্নোৎ তদৱলিহ্য ৱরং সংম্বোদ্যাৱদত, ");
INSERT INTO sanben_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","লোকাঃ প্রথমং উত্তমদ্রাক্ষারসং দদতি তষু যথেষ্টং পিতৱৎসু তস্মা কিঞ্চিদনুত্তমঞ্চ দদতি কিন্তু ৎৱমিদানীং যাৱৎ উত্তমদ্রাক্ষারসং স্থাপযসি| ");
INSERT INTO sanben_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ইত্থং যীশুর্গালীলপ্রদেশে আশ্চর্য্যকার্ম্ম প্রারম্ভ নিজমহিমানং প্রাকাশযৎ ততঃ শিষ্যাস্তস্মিন্ ৱ্যশ্ৱসন্| ");
INSERT INTO sanben_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ততঃ পরম্ স নিজমাত্রুভ্রাত্রুস্শিষ্যৈঃ সার্দ্ধ্ং কফর্নাহূমম্ আগমৎ কিন্তু তত্র বহূদিনানি আতিষ্ঠৎ| ");
INSERT INTO sanben_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","তদনন্তরং যিহূদিযানাং নিস্তারোৎসৱে নিকটমাগতে যীশু র্যিরূশালম্ নগরম্ আগচ্ছৎ| ");
INSERT INTO sanben_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ততো মন্দিরস্য মধ্যে গোমেষপারাৱতৱিক্রযিণো ৱাণিজক্ষ্চোপৱিষ্টান্ ৱিলোক্য ");
INSERT INTO sanben_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","রজ্জুভিঃ কশাং নির্ম্মায সর্ৱ্ৱগোমেষাদিভিঃ সার্দ্ধং তান্ মন্দিরাদ্ দূরীকৃতৱান্| ");
INSERT INTO sanben_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ৱণিজাং মুদ্রাদি ৱিকীর্য্য আসনানি ন্যূব্জীকৃত্য পারাৱতৱিক্রযিভ্যোঽকথযদ্ অস্মাৎ স্থানাৎ সর্ৱাণ্যেতানি নযত, মম পিতুগৃহং ৱাণিজ্যগৃহং মা কার্ষ্ট| ");
INSERT INTO sanben_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","তস্মাৎ তন্মন্দিরার্থ উদ্যোগো যস্তু স গ্রসতীৱ মাম্| ইমাং শাস্ত্রীযলিপিং শিষ্যাঃসমস্মরন্| ");
INSERT INTO sanben_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ততঃ পরম্ যিহূদীযলোকা যীষিমৱদন্ তৱমিদৃশকর্ম্মকরণাৎ কিং চিহ্নমস্মান্ দর্শযসি? ");
INSERT INTO sanben_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ততো যীশুস্তানৱোচদ্ যুষ্মাভিরে তস্মিন্ মন্দিরে নাশিতে দিনত্রযমধ্যেঽহং তদ্ উত্থাপযিষ্যামি| ");
INSERT INTO sanben_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","তদা যিহূদিযা ৱ্যাহার্ষুঃ, এতস্য মন্দিরস নির্ম্মাণেন ষট্চৎৱারিংশদ্ ৱৎসরা গতাঃ, ৎৱং কিং দিনত্রযমধ্যে তদ্ উত্থাপযিষ্যসি? ");
INSERT INTO sanben_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","কিন্তু স নিজদেহরূপমন্দিরে কথামিমাং কথিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","স যদেতাদৃশং গদিতৱান্ তচ্ছিষ্যাঃ শ্মশানাৎ তদীযোত্থানে সতি স্মৃৎৱা ধর্ম্মগ্রন্থে যীশুনোক্তকথাযাং চ ৱ্যশ্ৱসিষুঃ| ");
INSERT INTO sanben_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","অনন্তরং নিস্তারোৎসৱস্য ভোজ্যসমযে যিরূশালম্ নগরে তৎক্রুতাশ্চর্য্যকর্ম্মাণি ৱিলোক্য বহুভিস্তস্য নামনি ৱিশ্ৱসিতং| ");
INSERT INTO sanben_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","কিন্তু স তেষাং করেষু স্ৱং ন সমর্পযৎ, যতঃ স সর্ৱ্ৱানৱৈৎ| ");
INSERT INTO sanben_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","স মানৱেষু কস্যচিৎ প্রমাণং নাপেক্ষত যতো মনুজানাং মধ্যে যদ্যদস্তি তত্তৎ সোজানাৎ| ");
INSERT INTO sanben_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","নিকদিমনামা যিহূদীযানাম্ অধিপতিঃ ফিরূশী ক্ষণদাযাং ");
INSERT INTO sanben_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","যীশৌরভ্যর্ণম্ আৱ্রজ্য ৱ্যাহার্ষীৎ, হে গুরো ভৱান্ ঈশ্ৱরাদ্ আগৎ এক উপদেষ্টা, এতদ্ অস্মাভির্জ্ঞাযতে; যতো ভৱতা যান্যাশ্চর্য্যকর্ম্মাণি ক্রিযন্তে পরমেশ্ৱরস্য সাহায্যং ৱিনা কেনাপি তত্তৎকর্ম্মাণি কর্ত্তুং ন শক্যন্তে| ");
INSERT INTO sanben_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","তদা যীশুরুত্তরং দত্তৱান্ তৱাহং যথার্থতরং ৱ্যাহরামি পুনর্জন্মনি ন সতি কোপি মানৱ ঈশ্ৱরস্য রাজ্যং দ্রষ্টুং ন শক্নোতি| ");
INSERT INTO sanben_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ততো নিকদীমঃ প্রত্যৱোচৎ মনুজো ৱৃদ্ধো ভূৎৱা কথং জনিষ্যতে? স কিং পুন র্মাতৃর্জঠরং প্রৱিশ্য জনিতুং শক্নোতি? ");
INSERT INTO sanben_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","যীশুরৱাদীদ্ যথার্থতরম্ অহং কথযামি মনুজে তোযাত্মভ্যাং পুন র্ন জাতে স ঈশ্ৱরস্য রাজ্যং প্রৱেষ্টুং ন শক্নোতি| ");
INSERT INTO sanben_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","মাংসাদ্ যৎ জাযতে তন্ মাংসমেৱ তথাত্মনো যো জাযতে স আত্মৈৱ| ");
INSERT INTO sanben_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","যুষ্মাভিঃ পুন র্জনিতৱ্যং মমৈতস্যাং কথাযাম্ আশ্চর্যং মা মংস্থাঃ| ");
INSERT INTO sanben_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","সদাগতির্যাং দিশমিচ্ছতি তস্যামেৱ দিশি ৱাতি, ৎৱং তস্য স্ৱনং শুণোষি কিন্তু স কুত আযাতি কুত্র যাতি ৱা কিমপি ন জানাসি তদ্ৱাদ্ আত্মনঃ সকাশাৎ সর্ৱ্ৱেষাং মনুজানাং জন্ম ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","তদা নিকদীমঃ পৃষ্টৱান্ এতৎ কথং ভৱিতুং শক্নোতি? ");
INSERT INTO sanben_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","যীশুঃ প্রত্যক্তৱান্ ৎৱমিস্রাযেলো গুরুর্ভূৎৱাপি কিমেতাং কথাং ন ৱেৎসি? ");
INSERT INTO sanben_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","তুভ্যং যথার্থং কথযামি, ৱযং যদ্ ৱিদ্মস্তদ্ ৱচ্মঃ যংচ্চ পশ্যামস্তস্যৈৱ সাক্ষ্যং দদ্মঃ কিন্তু যুষ্মাভিরস্মাকং সাক্ষিৎৱং ন গৃহ্যতে| ");
INSERT INTO sanben_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","এতস্য সংসারস্য কথাযাং কথিতাযাং যদি যূযং ন ৱিশ্ৱসিথ তর্হি স্ৱর্গীযাযাং কথাযাং কথং ৱিশ্ৱসিষ্যথ? ");
INSERT INTO sanben_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","যঃ স্ৱর্গেঽস্তি যং চ স্ৱর্গাদ্ অৱারোহৎ তং মানৱতনযং ৱিনা কোপি স্ৱর্গং নারোহৎ| ");
INSERT INTO sanben_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","অপরঞ্চ মূসা যথা প্রান্তরে সর্পং প্রোত্থাপিতৱান্ মনুষ্যপুত্রোঽপি তথৈৱোত্থাপিতৱ্যঃ; ");
INSERT INTO sanben_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","তস্মাদ্ যঃ কশ্চিৎ তস্মিন্ ৱিশ্ৱসিষ্যতি সোঽৱিনাশ্যঃ সন্ অনন্তাযুঃ প্রাপ্স্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ঈশ্ৱর ইত্থং জগদদযত যৎ স্ৱমদ্ৱিতীযং তনযং প্রাদদাৎ ততো যঃ কশ্চিৎ তস্মিন্ ৱিশ্ৱসিষ্যতি সোঽৱিনাশ্যঃ সন্ অনন্তাযুঃ প্রাপ্স্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ঈশ্ৱরো জগতো লোকান্ দণ্ডযিতুং স্ৱপুত্রং ন প্রেষ্য তান্ পরিত্রাতুং প্রেষিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","অতএৱ যঃ কশ্চিৎ তস্মিন্ ৱিশ্ৱসিতি স দণ্ডার্হো ন ভৱতি কিন্তু যঃ কশ্চিৎ তস্মিন্ ন ৱিশ্ৱসিতি স ইদানীমেৱ দণ্ডার্হো ভৱতি,যতঃ স ঈশ্ৱরস্যাদ্ৱিতীযপুত্রস্য নামনি প্রত্যযং ন করোতি| ");
INSERT INTO sanben_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","জগতো মধ্যে জ্যোতিঃ প্রাকাশত কিন্তু মনুষ্যাণাং কর্ম্মণাং দৃষ্টৎৱাৎ তে জ্যোতিষোপি তিমিরে প্রীযন্তে এতদেৱ দণ্ডস্য কারণাং ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","যঃ কুকর্ম্ম করোতি তস্যাচারস্য দৃষ্টৎৱাৎ স জ্যোতিরৄতীযিৎৱা তন্নিকটং নাযাতি; ");
INSERT INTO sanben_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","কিন্তু যঃ সৎকর্ম্ম করোতি তস্য সর্ৱ্ৱাণি কর্ম্মাণীশ্ৱরেণ কৃতানীতি সথা প্রকাশতে তদভিপ্রাযেণ স জ্যোতিষঃ সন্নিধিম্ আযাতি| ");
INSERT INTO sanben_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ততঃ পরম্ যীশুঃ শিষ্যৈঃ সার্দ্ধং যিহূদীযদেশং গৎৱা তত্র স্থিৎৱা মজ্জযিতুম্ আরভত| ");
INSERT INTO sanben_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","তদা শালম্ নগরস্য সমীপস্থাযিনি ঐনন্ গ্রামে বহুতরতোযস্থিতেস্তত্র যোহন্ অমজ্জযৎ তথা চ লোকা আগত্য তেন মজ্জিতা অভৱন্| ");
INSERT INTO sanben_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","তদা যোহন্ কারাযাং ন বদ্ধঃ| ");
INSERT INTO sanben_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","অপরঞ্চ শাচকর্ম্মণি যোহানঃ শিষ্যৈঃ সহ যিহূদীযলোকানাং ৱিৱাদে জাতে, তে যোহনঃ সংন্নিধিং গৎৱাকথযন্, ");
INSERT INTO sanben_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","হে গুরো যর্দ্দননদ্যাঃ পারে ভৱতা সার্দ্ধং য আসীৎ যস্মিংশ্চ ভৱান্ সাক্ষ্যং প্রদদাৎ পশ্যতু সোপি মজ্জযতি সর্ৱ্ৱে তস্য সমীপং যান্তি চ| ");
INSERT INTO sanben_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","তদা যোহন্ প্রত্যৱোচদ্ ঈশ্ৱরেণ ন দত্তে কোপি মনুজঃ কিমপি প্রাপ্তুং ন শক্নোতি| ");
INSERT INTO sanben_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","অহং অভিষিক্তো ন ভৱামি কিন্তু তদগ্রে প্রেষিতোস্মি যামিমাং কথাং কথিতৱানাহং তত্র যূযং সর্ৱ্ৱে সাক্ষিণঃ স্থ| ");
INSERT INTO sanben_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","যো জনঃ কন্যাং লভতে স এৱ ৱরঃ কিন্তু ৱরস্য সন্নিধৌ দণ্ডাযমানং তস্য যন্মিত্রং তেন ৱরস্য শব্দে শ্রুতেঽতীৱাহ্লাদ্যতে মমাপি তদ্ৱদ্ আনন্দসিদ্ধির্জাতা| ");
INSERT INTO sanben_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","তেন ক্রমশো ৱর্দ্ধিতৱ্যং কিন্তু মযা হ্সিতৱ্যং| ");
INSERT INTO sanben_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","য ঊর্ধ্ৱাদাগচ্ছৎ স সর্ৱ্ৱেষাং মুখ্যো যশ্চ সংসারাদ্ উদপদ্যত স সাংসারিকঃ সংসারীযাং কথাঞ্চ কথযতি যস্তু স্ৱর্গাদাগচ্ছৎ স সর্ৱ্ৱেষাং মুখ্যঃ| ");
INSERT INTO sanben_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","স যদপশ্যদশৃণোচ্চ তস্মিন্নেৱ সাক্ষ্যং দদাতি তথাপি প্রাযশঃ কশ্চিৎ তস্য সাক্ষ্যং ন গৃহ্লাতি; ");
INSERT INTO sanben_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","কিন্তু যো গৃহ্লাতি স ঈশ্ৱরস্য সত্যৱাদিৎৱং মুদ্রাঙ্গিতং করোতি| ");
INSERT INTO sanben_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ঈশ্ৱরেণ যঃ প্রেরিতঃ সএৱ ঈশ্ৱরীযকথাং কথযতি যত ঈশ্ৱর আত্মানং তস্মৈ অপরিমিতম্ অদদাৎ| ");
INSERT INTO sanben_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","পিতা পুত্রে স্নেহং কৃৎৱা তস্য হস্তে সর্ৱ্ৱাণি সমর্পিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","যঃ কশ্চিৎ পুত্রে ৱিশ্ৱসিতি স এৱানন্তম্ পরমাযুঃ প্রাপ্নোতি কিন্তু যঃ কশ্চিৎ পুত্রে ন ৱিশ্ৱসিতি স পরমাযুষো দর্শনং ন প্রাপ্নোতি কিন্ত্ৱীশ্ৱরস্য কোপভাজনং ভূৎৱা তিষ্ঠতি| ");
INSERT INTO sanben_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","যীশুঃ স্ৱযং নামজ্জযৎ কেৱলং তস্য শিষ্যা অমজ্জযৎ কিন্তু যোহনোঽধিকশিষ্যান্ স করোতি মজ্জযতি চ, ");
INSERT INTO sanben_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ফিরূশিন ইমাং ৱার্ত্তামশৃণ্ৱন্ ইতি প্রভুরৱগত্য ");
INSERT INTO sanben_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","যিহূদীযদেশং ৱিহায পুন র্গালীলম্ আগৎ| ");
INSERT INTO sanben_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ততঃ শোমিরোণপ্রদেশস্য মদ্যেন তেন গন্তৱ্যে সতি ");
INSERT INTO sanben_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","যাকূব্ নিজপুত্রায যূষফে যাং ভূমিম্ অদদাৎ তৎসমীপস্থাযি শোমিরোণপ্রদেশস্য সুখার্ নাম্না ৱিখ্যাতস্য নগরস্য সন্নিধাৱুপাস্থাৎ| ");
INSERT INTO sanben_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","তত্র যাকূবঃ প্রহিরাসীৎ; তদা দ্ৱিতীযযামৱেলাযাং জাতাযাং স মার্গে শ্রমাপন্নস্তস্য প্রহেঃ পার্শ্ৱে উপাৱিশৎ| ");
INSERT INTO sanben_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","এতর্হি কাচিৎ শোমিরোণীযা যোষিৎ তোযোত্তোলনার্থম্ তত্রাগমৎ ");
INSERT INTO sanben_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","তদা শিষ্যাঃ খাদ্যদ্রৱ্যাণি ক্রেতুং নগরম্ অগচ্ছন্| ");
INSERT INTO sanben_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","যীশুঃ শোমিরোণীযাং তাং যোষিতম্ ৱ্যাহার্ষীৎ মহ্যং কিঞ্চিৎ পানীযং পাতুং দেহি| কিন্তু শোমিরোণীযৈঃ সাকং যিহূদীযলোকা ন ৱ্যৱাহরন্ তস্মাদ্ধেতোঃ সাকথযৎ শোমিরোণীযা যোষিতদহং ৎৱং যিহূদীযোসি কথং মত্তঃ পানীযং পাতুম্ ইচ্ছসি? ");
INSERT INTO sanben_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ততো যীশুরৱদদ্ ঈশ্ৱরস্য যদ্দানং তৎকীদৃক্ পানীযং পাতুং মহ্যং দেহি য ইত্থং ৎৱাং যাচতে স ৱা ক ইতি চেদজ্ঞাস্যথাস্তর্হি তমযাচিষ্যথাঃ স চ তুভ্যমমৃতং তোযমদাস্যৎ| ");
INSERT INTO sanben_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","তদা সা সীমন্তিনী ভাষিতৱতি, হে মহেচ্ছ প্রহির্গম্ভীরো ভৱতো নীরোত্তোলনপাত্রং নাস্তী চ তস্মাৎ তদমৃতং কীলালং কুতঃ প্রাপ্স্যসি? ");
INSERT INTO sanben_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","যোস্মভ্যম্ ইমমন্ধূং দদৌ, যস্য চ পরিজনা গোমেষাদযশ্চ সর্ৱ্ৱেঽস্য প্রহেঃ পানীযং পপুরেতাদৃশো যোস্মাকং পূর্ৱ্ৱপুরুষো যাকূব্ তস্মাদপি ভৱান্ মহান্ কিং? ");
INSERT INTO sanben_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ততো যীশুরকথযদ্ ইদং পানীযং সঃ পিৱতি স পুনস্তৃষার্ত্তো ভৱিষ্যতি, ");
INSERT INTO sanben_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","কিন্তু মযা দত্তং পানীযং যঃ পিৱতি স পুনঃ কদাপি তৃষার্ত্তো ন ভৱিষ্যতি| মযা দত্তম্ ইদং তোযং তস্যান্তঃ প্রস্রৱণরূপং ভূৎৱা অনন্তাযুর্যাৱৎ স্রোষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","তদা সা ৱনিতাকথযৎ হে মহেচ্ছ তর্হি মম পুনঃ পীপাসা যথা ন জাযতে তোযোত্তোলনায যথাত্রাগমনং ন ভৱতি চ তদর্থং মহ্যং তত্তোযং দেহী| ");
INSERT INTO sanben_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","ততো যীশূরৱদদ্যাহি তৱ পতিমাহূয স্থানেঽত্রাগচ্ছ| ");
INSERT INTO sanben_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","সা ৱামাৱদৎ মম পতির্নাস্তি| যীশুরৱদৎ মম পতির্নাস্তীতি ৱাক্যং ভদ্রমৱোচঃ| ");
INSERT INTO sanben_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","যতস্তৱ পঞ্চ পতযোভৱন্ অধুনা তু ৎৱযা সার্দ্ধং যস্তিষ্ঠতি স তৱ ভর্ত্তা ন ৱাক্যমিদং সত্যমৱাদিঃ| ");
INSERT INTO sanben_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","তদা সা মহিলা গদিতৱতি হে মহেচ্ছ ভৱান্ একো ভৱিষ্যদ্ৱাদীতি বুদ্ধং মযা| ");
INSERT INTO sanben_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","অস্মাকং পিতৃলোকা এতস্মিন্ শিলোচ্চযেঽভজন্ত, কিন্তু ভৱদ্ভিরুচ্যতে যিরূশালম্ নগরে ভজনযোগ্যং স্থানমাস্তে| ");
INSERT INTO sanben_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","যীশুরৱোচৎ হে যোষিৎ মম ৱাক্যে ৱিশ্ৱসিহি যদা যূযং কেৱলশৈলেঽস্মিন্ ৱা যিরূশালম্ নগরে পিতুর্ভজনং ন করিষ্যধ্ৱে কাল এতাদৃশ আযাতি| ");
INSERT INTO sanben_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","যূযং যং ভজধ্ৱে তং ন জানীথ, কিন্তু ৱযং যং ভজামহে তং জানীমহে, যতো যিহূদীযলোকানাং মধ্যাৎ পরিত্রাণং জাযতে| ");
INSERT INTO sanben_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","কিন্তু যদা সত্যভক্তা আত্মনা সত্যরূপেণ চ পিতুর্ভজনং করিষ্যন্তে সময এতাদৃশ আযাতি, ৱরম্ ইদানীমপি ৱিদ্যতে ; যত এতাদৃশো ভৎকান্ পিতা চেষ্টতে| ");
INSERT INTO sanben_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ঈশ্ৱর আত্মা; ততস্তস্য যে ভক্তাস্তৈঃ স আত্মনা সত্যরূপেণ চ ভজনীযঃ| ");
INSERT INTO sanben_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","তদা সা মহিলাৱাদীৎ খ্রীষ্টনাম্না ৱিখ্যাতোঽভিষিক্তঃ পুরুষ আগমিষ্যতীতি জানামি স চ সর্ৱ্ৱাঃ কথা অস্মান্ জ্ঞাপযিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","ততো যীশুরৱদৎ ৎৱযা সার্দ্ধং কথনং করোমি যোঽহম্ অহমেৱ স পুরুষঃ| ");
INSERT INTO sanben_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","এতস্মিন্ সমযে শিষ্যা আগত্য তথা স্ত্রিযা সার্দ্ধং তস্য কথোপকথনে মহাশ্চর্য্যম্ অমন্যন্ত তথাপি ভৱান্ কিমিচ্ছতি? যদ্ৱা কিমর্থম্ এতযা সার্দ্ধং কথাং কথযতি? ইতি কোপি নাপৃচ্ছৎ| ");
INSERT INTO sanben_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","ততঃ পরং সা নারী কলশং স্থাপযিৎৱা নগরমধ্যং গৎৱা লোকেভ্যোকথাযদ্ ");
INSERT INTO sanben_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","অহং যদ্যৎ কর্ম্মাকরৱং তৎসর্ৱ্ৱং মহ্যমকথযদ্ এতাদৃশং মানৱমেকম্ আগত্য পশ্যত রু কিম্ অভিষিক্তো ন ভৱতি ? ");
INSERT INTO sanben_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ততস্তে নগরাদ্ বহিরাগত্য তাতস্য সমীপম্ আযন্| ");
INSERT INTO sanben_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","এতর্হি শিষ্যাঃ সাধযিৎৱা তং ৱ্যাহার্ষুঃ হে গুরো ভৱান্ কিঞ্চিদ্ ভূক্তাং| ");
INSERT INTO sanben_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ততঃ সোৱদদ্ যুষ্মাভির্যন্ন জ্ঞাযতে তাদৃশং ভক্ষ্যং মমাস্তে| ");
INSERT INTO sanben_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","তদা শিষ্যাঃ পরস্পরং প্রষ্টুম্ আরম্ভন্ত, কিমস্মৈ কোপি কিমপি ভক্ষ্যমানীয দত্তৱান্? ");
INSERT INTO sanben_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","যীশুরৱোচৎ মৎপ্রেরকস্যাভিমতানুরূপকরণং তস্যৈৱ কর্ম্মসিদ্ধিকারণঞ্চ মম ভক্ষ্যং| ");
INSERT INTO sanben_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","মাসচতুষ্টযে জাতে শস্যকর্ত্তনসমযো ভৱিষ্যতীতি ৱাক্যং যুষ্মাভিঃ কিং নোদ্যতে? কিন্ত্ৱহং ৱদামি, শির উত্তোল্য ক্ষেত্রাণি প্রতি নিরীক্ষ্য পশ্যত, ইদানীং কর্ত্তনযোগ্যানি শুক্লৱর্ণান্যভৱন্| ");
INSERT INTO sanben_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","যশ্ছিনত্তি স ৱেতনং লভতে অনন্তাযুঃস্ৱরূপং শস্যং স গৃহ্লাতি চ, তেনৈৱ ৱপ্তা ছেত্তা চ যুগপদ্ আনন্দতঃ| ");
INSERT INTO sanben_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ইত্থং সতি ৱপত্যেকশ্ছিনত্যন্য ইতি ৱচনং সিদ্ধ্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","যত্র যূযং ন পর্য্যশ্রাম্যত তাদৃশং শস্যং ছেত্তুং যুষ্মান্ প্রৈরযম্ অন্যে জনাঃপর্য্যশ্রাম্যন্ যূযং তেষাং শ্রগস্য ফলম্ অলভধ্ৱম্| ");
INSERT INTO sanben_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","যস্মিন্ কালে যদ্যৎ কর্ম্মাকার্ষং তৎসর্ৱ্ৱং স মহ্যম্ অকথযৎ তস্যা ৱনিতাযা ইদং সাক্ষ্যৱাক্যং শ্রুৎৱা তন্নগরনিৱাসিনো বহৱঃ শোমিরোণীযলোকা ৱ্যশ্ৱসন্| ");
INSERT INTO sanben_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","তথা চ তস্যান্তিকে সমুপস্থায স্ৱেষাং সন্নিধৌ কতিচিদ্ দিনানি স্থাতুং তস্মিন্ ৱিনযম্ অকুর্ৱ্ৱান তস্মাৎ স দিনদ্ৱযং তৎস্থানে ন্যৱষ্টৎ ");
INSERT INTO sanben_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ততস্তস্যোপদেশেন বহৱোঽপরে ৱিশ্ৱস্য ");
INSERT INTO sanben_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","তাং যোষামৱদন্ কেৱলং তৱ ৱাক্যেন প্রতীম ইতি ন, কিন্তু স জগতোঽভিষিক্তস্ত্রাতেতি তস্য কথাং শ্রুৎৱা ৱযং স্ৱযমেৱাজ্ঞাসমহি| ");
INSERT INTO sanben_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","স্ৱদেশে ভৱিষ্যদ্ৱক্তুঃ সৎকারো নাস্তীতি যদ্যপি যীশুঃ প্রমাণং দৎৱাকথযৎ ");
INSERT INTO sanben_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","তথাপি দিৱসদ্ৱযাৎ পরং স তস্মাৎ স্থানাদ্ গালীলং গতৱান্| ");
INSERT INTO sanben_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","অনন্তরং যে গালীলী লিযলোকা উৎসৱে গতা উৎসৱসমযে যিরূশলম্ নগরে তস্য সর্ৱ্ৱাঃ ক্রিযা অপশ্যন্ তে গালীলম্ আগতং তম্ আগৃহ্লন্| ");
INSERT INTO sanben_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","ততঃ পরম্ যীশু র্যস্মিন্ কান্নানগরে জলং দ্রাক্ষারসম্ আকরোৎ তৎ স্থানং পুনরগাৎ| তস্মিন্নেৱ সমযে কস্যচিদ্ রাজসভাস্তারস্য পুত্রঃ কফর্নাহূমপুরী রোগগ্রস্ত আসীৎ| ");
INSERT INTO sanben_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","স যেহূদীযদেশাদ্ যীশো র্গালীলাগমনৱার্ত্তাং নিশম্য তস্য সমীপং গৎৱা প্রার্থ্য ৱ্যাহৃতৱান্ মম পুত্রস্য প্রাযেণ কাল আসন্নঃ ভৱান্ আগত্য তং স্ৱস্থং করোতু| ");
INSERT INTO sanben_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","তদা যীশুরকথযদ্ আশ্চর্য্যং কর্ম্ম চিত্রং চিহ্নং চ ন দৃষ্টা যূযং ন প্রত্যেষ্যথ| ");
INSERT INTO sanben_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ততঃ স সভাসদৱদৎ হে মহেচ্ছ মম পুত্রে ন মৃতে ভৱানাগচ্ছতু| ");
INSERT INTO sanben_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","যীশুস্তমৱদদ্ গচ্ছ তৱ পুত্রোঽজীৱীৎ তদা যীশুনোক্তৱাক্যে স ৱিশ্ৱস্য গতৱান্| ");
INSERT INTO sanben_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","গমনকালে মার্গমধ্যে দাসাস্তং সাক্ষাৎপ্রাপ্যাৱদন্ ভৱতঃ পুত্রোঽজীৱীৎ| ");
INSERT INTO sanben_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ততঃ কং কালমারভ্য রোগপ্রতীকারারম্ভো জাতা ইতি পৃষ্টে তৈরুক্তং হ্যঃ সার্দ্ধদণ্ডদ্ৱযাধিকদ্ৱিতীযযামে তস্য জ্ৱরত্যাগোঽভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","তদা যীশুস্তস্মিন্ ক্ষণে প্রোক্তৱান্ তৱ পুত্রোঽজীৱীৎ পিতা তদ্বুদ্ধ্ৱা সপরিৱারো ৱ্যশ্ৱসীৎ| ");
INSERT INTO sanben_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","যিহূদীযদেশাদ্ আগত্য গালীলি যীশুরেতদ্ দ্ৱিতীযম্ আশ্চর্য্যকর্ম্মাকরোৎ| ");
INSERT INTO sanben_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","ততঃ পরং যিহূদীযানাম্ উৎসৱ উপস্থিতে যীশু র্যিরূশালমং গতৱান্| ");
INSERT INTO sanben_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","তস্মিন্নগরে মেষনাম্নো দ্ৱারস্য সমীপে ইব্রীযভাষযা বৈথেস্দা নাম্না পিষ্করিণী পঞ্চঘট্টযুক্তাসীৎ| ");
INSERT INTO sanben_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","তস্যাস্তেষু ঘট্টেষু কিলালকম্পনম্ অপেক্ষ্য অন্ধখঞ্চশুষ্কাঙ্গাদযো বহৱো রোগিণঃ পতন্তস্তিষ্ঠন্তি স্ম| ");
INSERT INTO sanben_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","যতো ৱিশেষকালে তস্য সরসো ৱারি স্ৱর্গীযদূত এত্যাকম্পযৎ তৎকীলালকম্পনাৎ পরং যঃ কশ্চিদ্ রোগী প্রথমং পানীযমৱারোহৎ স এৱ তৎক্ষণাদ্ রোগমুক্তোঽভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","তদাষ্টাত্রিংশদ্ৱর্ষাণি যাৱদ্ রোগগ্রস্ত একজনস্তস্মিন্ স্থানে স্থিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","যীশুস্তং শযিতং দৃষ্ট্ৱা বহুকালিকরোগীতি জ্ঞাৎৱা ৱ্যাহৃতৱান্ ৎৱং কিং স্ৱস্থো বুভূষসি? ");
INSERT INTO sanben_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ততো রোগী কথিতৱান্ হে মহেচ্ছ যদা কীলালং কম্পতে তদা মাং পুষ্করিণীম্ অৱরোহযিতুং মম কোপি নাস্তি, তস্মান্ মম গমনকালে কশ্চিদন্যোঽগ্রো গৎৱা অৱরোহতি| ");
INSERT INTO sanben_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","তদা যীশুরকথযদ্ উত্তিষ্ঠ, তৱ শয্যামুত্তোল্য গৃহীৎৱা যাহি| ");
INSERT INTO sanben_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","স তৎক্ষণাৎ স্ৱস্থো ভূৎৱা শয্যামুত্তোল্যাদায গতৱান্ কিন্তু তদ্দিনং ৱিশ্রামৱারঃ| ");
INSERT INTO sanben_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","তস্মাদ্ যিহূদীযাঃ স্ৱস্থং নরং ৱ্যাহরন্ অদ্য ৱিশ্রামৱারে শযনীযমাদায ন যাতৱ্যম্| ");
INSERT INTO sanben_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","ততঃ স প্রত্যৱোচদ্ যো মাং স্ৱস্থম্ অকার্ষীৎ শযনীযম্ উত্তোল্যাদায যাতুং মাং স এৱাদিশৎ| ");
INSERT INTO sanben_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","তদা তেঽপৃচ্ছন্ শযনীযম্ উত্তোল্যাদায যাতুং য আজ্ঞাপযৎ স কঃ? ");
INSERT INTO sanben_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","কিন্তু স ক ইতি স্ৱস্থীভূতো নাজানাদ্ যতস্তস্মিন্ স্থানে জনতাসত্ত্ৱাদ্ যীশুঃ স্থানান্তরম্ আগমৎ| ");
INSERT INTO sanben_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","ততঃ পরং যেশু র্মন্দিরে তং নরং সাক্ষাৎপ্রাপ্যাকথযৎ পশ্যেদানীম্ অনামযো জাতোসি যথাধিকা দুর্দশা ন ঘটতে তদ্ধেতোঃ পাপং কর্ম্ম পুনর্মাকার্ষীঃ| ");
INSERT INTO sanben_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ততঃ স গৎৱা যিহূদীযান্ অৱদদ্ যীশু র্মাম্ অরোগিণম্ অকার্ষীৎ| ");
INSERT INTO sanben_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","ততো যীশু র্ৱিশ্রামৱারে কর্ম্মেদৃশং কৃতৱান্ ইতি হেতো র্যিহূদীযাস্তং তাডযিৎৱা হন্তুম্ অচেষ্টন্ত| ");
INSERT INTO sanben_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","যীশুস্তানাখ্যৎ মম পিতা যৎ কার্য্যং করোতি তদনুরূপম্ অহমপি করোতি| ");
INSERT INTO sanben_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","ততো যিহূদীযাস্তং হন্তুং পুনরযতন্ত যতো ৱিশ্রামৱারং নামন্যত তদেৱ কেৱলং ন অধিকন্তু ঈশ্ৱরং স্ৱপিতরং প্রোচ্য স্ৱমপীশ্ৱরতুল্যং কৃতৱান্| ");
INSERT INTO sanben_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","পশ্চাদ্ যীশুরৱদদ্ যুষ্মানহং যথার্থতরং ৱদামি পুত্রঃ পিতরং যদ্যৎ কর্ম্ম কুর্ৱ্ৱন্তং পশ্যতি তদতিরিক্তং স্ৱেচ্ছাতঃ কিমপি কর্ম্ম কর্ত্তুং ন শক্নোতি| পিতা যৎ করোতি পুত্রোপি তদেৱ করোতি| ");
INSERT INTO sanben_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","পিতা পুত্রে স্নেহং করোতি তস্মাৎ স্ৱযং যদ্যৎ কর্ম্ম করোতি তৎসর্ৱ্ৱং পুত্রং দর্শযতি ; যথা চ যুষ্মাকং আশ্চর্য্যজ্ঞানং জনিষ্যতে তদর্থম্ ইতোপি মহাকর্ম্ম তং দর্শযিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","ৱস্তুতস্তু পিতা যথা প্রমিতান্ উত্থাপ্য সজিৱান্ করোতি তদ্ৱৎ পুত্রোপি যং যং ইচ্ছতি তং তং সজীৱং করোতি| ");
INSERT INTO sanben_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","সর্ৱ্ৱে পিতরং যথা সৎকুর্ৱ্ৱন্তি তথা পুত্রমপি সৎকারযিতুং পিতা স্ৱযং কস্যাপি ৱিচারমকৃৎৱা সর্ৱ্ৱৱিচারাণাং ভারং পুত্রে সমর্পিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","যঃ পুত্রং সৎ করোতি স তস্য প্রেরকমপি সৎ করোতি| ");
INSERT INTO sanben_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","যুষ্মানাহং যথার্থতরং ৱদামি যো জনো মম ৱাক্যং শ্রুৎৱা মৎপ্রেরকে ৱিশ্ৱসিতি সোনন্তাযুঃ প্রাপ্নোতি কদাপি দণ্ডবাজনং ন ভৱতি নিধনাদুত্থায পরমাযুঃ প্রাপ্নোতি| ");
INSERT INTO sanben_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","অহং যুষ্মানতিযথার্থং ৱদামি যদা মৃতা ঈশ্ৱরপুত্রস্য নিনাদং শ্রোষ্যন্তি যে চ শ্রোষ্যন্তি তে সজীৱা ভৱিষ্যন্তি সময এতাদৃশ আযাতি ৱরম্ ইদানীমপ্যুপতিষ্ঠতি| ");
INSERT INTO sanben_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","পিতা যথা স্ৱযঞ্জীৱী তথা পুত্রায স্ৱযঞ্জীৱিৎৱাধিকারং দত্তৱান্| ");
INSERT INTO sanben_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","স মনুষ্যপুত্রঃ এতস্মাৎ কারণাৎ পিতা দণ্ডকরণাধিকারমপি তস্মিন্ সমর্পিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","এতদর্থে যূযম্ আশ্চর্য্যং ন মন্যধ্ৱং যতো যস্মিন্ সমযে তস্য নিনাদং শ্রুৎৱা শ্মশানস্থাঃ সর্ৱ্ৱে বহিরাগমিষ্যন্তি সময এতাদৃশ উপস্থাস্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","তস্মাদ্ যে সৎকর্ম্মাণি কৃতৱন্তস্ত উত্থায আযুঃ প্রাপ্স্যন্তি যে চ কুকর্মাণি কৃতৱন্তস্ত উত্থায দণ্ডং প্রাপ্স্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","অহং স্ৱযং কিমপি কর্ত্তুং ন শক্নোমি যথা শুণোমি তথা ৱিচারযামি মম ৱিচারঞ্চ ন্যায্যঃ যতোহং স্ৱীযাভীষ্টং নেহিৎৱা মৎপ্রেরযিতুঃ পিতুরিষ্টম্ ঈহে| ");
INSERT INTO sanben_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","যদি স্ৱস্মিন্ স্ৱযং সাক্ষ্যং দদামি তর্হি তৎসাক্ষ্যম্ আগ্রাহ্যং ভৱতি ; ");
INSERT INTO sanben_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","কিন্তু মদর্থেঽপরো জনঃ সাক্ষ্যং দদাতি মদর্থে তস্য যৎ সাক্ষ্যং তৎ সত্যম্ এতদপ্যহং জানামি| ");
INSERT INTO sanben_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","যুষ্মাভি র্যোহনং প্রতি লোকেষু প্রেরিতেষু স সত্যকথাযাং সাক্ষ্যমদদাৎ| ");
INSERT INTO sanben_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","মানুষাদহং সাক্ষ্যং নোপেক্ষে তথাপি যূযং যথা পরিত্রযধ্ৱে তদর্থম্ ইদং ৱাক্যং ৱদামি| ");
INSERT INTO sanben_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","যোহন্ দেদীপ্যমানো দীপ ইৱ তেজস্ৱী স্থিতৱান্ যূযম্ অল্পকালং তস্য দীপ্ত্যানন্দিতুং সমমন্যধ্ৱং| ");
INSERT INTO sanben_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","কিন্তু তৎপ্রমাণাদপি মম গুরুতরং প্রমাণং ৱিদ্যতে পিতা মাং প্রেষ্য যদ্যৎ কর্ম্ম সমাপযিতুং শক্ত্তিমদদাৎ মযা কৃতং তত্তৎ কর্ম্ম মদর্থে প্রমাণং দদাতি| ");
INSERT INTO sanben_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","যঃ পিতা মাং প্রেরিতৱান্ মোপি মদর্থে প্রমাণং দদাতি| তস্য ৱাক্যং যুষ্মাভিঃ কদাপি ন শ্রুতং তস্য রূপঞ্চ ন দৃষ্টং ");
INSERT INTO sanben_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","তস্য ৱাক্যঞ্চ যুষ্মাকম্ অন্তঃ কদাপি স্থানং নাপ্নোতি যতঃ স যং প্রেষিতৱান্ যূযং তস্মিন্ ন ৱিশ্ৱসিথ| ");
INSERT INTO sanben_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","ধর্ম্মপুস্তকানি যূযম্ আলোচযধ্ৱং তৈ র্ৱাক্যৈরনন্তাযুঃ প্রাপ্স্যাম ইতি যূযং বুধ্যধ্ৱে তদ্ধর্ম্মপুস্তকানি মদর্থে প্রমাণং দদতি| ");
INSERT INTO sanben_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","তথাপি যূযং পরমাযুঃপ্রাপ্তযে মম সংনিধিম্ ন জিগমিষথ| ");
INSERT INTO sanben_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","অহং মানুষেভ্যঃ সৎকারং ন গৃহ্লামি| ");
INSERT INTO sanben_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","অহং যুষ্মান্ জানামি; যুষ্মাকমন্তর ঈশ্ৱরপ্রেম নাস্তি| ");
INSERT INTO sanben_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","অহং নিজপিতু র্নাম্নাগতোস্মি তথাপি মাং ন গৃহ্লীথ কিন্তু কশ্চিদ্ যদি স্ৱনাম্না সমাগমিষ্যতি তর্হি তং গ্রহীষ্যথ| ");
INSERT INTO sanben_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","যূযম্ ঈশ্ৱরাৎ সৎকারং ন চিষ্টৎৱা কেৱলং পরস্পরং সৎকারম্ চেদ্ আদধ্ৱ্ৱে তর্হি কথং ৱিশ্ৱসিতুং শক্নুথ? ");
INSERT INTO sanben_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","পুতুঃ সমীপেঽহং যুষ্মান্ অপৱদিষ্যামীতি মা চিন্তযত যস্মিন্ , যস্মিন্ যুষ্মাকং ৱিশ্ৱসঃ সএৱ মূসা যুষ্মান্ অপৱদতি| ");
INSERT INTO sanben_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","যদি যূযং তস্মিন্ ৱ্যশ্ৱসিষ্যত তর্হি ময্যপি ৱ্যশ্ৱসিষ্যত, যৎ স মযি লিখিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","ততো যদি তেন লিখিতৱানি ন প্রতিথ তর্হি মম ৱাক্যানি কথং প্রত্যেষ্যথ? ");
INSERT INTO sanben_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","ততঃ পরং যীশু র্গালীল্ প্রদেশীযস্য তিৱিরিযানাম্নঃ সিন্ধোঃ পারং গতৱান্| ");
INSERT INTO sanben_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ততো ৱ্যাধিমল্লোকস্ৱাস্থ্যকরণরূপাণি তস্যাশ্চর্য্যাণি কর্ম্মাণি দৃষ্ট্ৱা বহৱো জনাস্তৎপশ্চাদ্ অগচ্ছন্| ");
INSERT INTO sanben_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ততো যীশুঃ পর্ৱ্ৱতমারুহ্য তত্র শিষ্যৈঃ সাকম্| ");
INSERT INTO sanben_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","তস্মিন্ সময নিস্তারোৎসৱনাম্নি যিহূদীযানাম উৎসৱ উপস্থিতে ");
INSERT INTO sanben_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","যীশু র্নেত্রে উত্তোল্য বহুলোকান্ স্ৱসমীপাগতান্ ৱিলোক্য ফিলিপং পৃষ্টৱান্ এতেষাং ভোজনায ভোজদ্রৱ্যাণি ৱযং কুত্র ক্রেতুং শক্রুমঃ? ");
INSERT INTO sanben_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ৱাক্যমিদং তস্য পরীক্ষার্থম্ অৱাদীৎ কিন্তু যৎ করিষ্যতি তৎ স্ৱযম্ অজানাৎ| ");
INSERT INTO sanben_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ফিলিপঃ প্রত্যৱোচৎ এতেষাম্ একৈকো যদ্যল্পম্ অল্পং প্রাপ্নোতি তর্হি মুদ্রাপাদদ্ৱিশতেন ক্রীতপূপা অপি ন্যূনা ভৱিষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","শিমোন্ পিতরস্য ভ্রাতা আন্দ্রিযাখ্যঃ শিষ্যাণামেকো ৱ্যাহৃতৱান্ ");
INSERT INTO sanben_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","অত্র কস্যচিদ্ বালকস্য সমীপে পঞ্চ যাৱপূপাঃ ক্ষুদ্রমৎস্যদ্ৱযঞ্চ সন্তি কিন্তু লোকানাং এতাৱাতাং মধ্যে তৈঃ কিং ভৱিষ্যতি? ");
INSERT INTO sanben_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","পশ্চাদ্ যীশুরৱদৎ লোকানুপৱেশযত তত্র বহুযৱসসত্ত্ৱাৎ পঞ্চসহস্ত্রেভ্যো ন্যূনা অধিকা ৱা পুরুষা ভূম্যাম্ উপাৱিশন্| ");
INSERT INTO sanben_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ততো যীশুস্তান্ পূপানাদায ঈশ্ৱরস্য গুণান্ কীর্ত্তযিৎৱা শিষ্যেষু সমার্পযৎ ততস্তে তেভ্য উপৱিষ্টলোকেভ্যঃ পূপান্ যথেষ্টমৎস্যঞ্চ প্রাদুঃ| ");
INSERT INTO sanben_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","তেষু তৃপ্তেষু স তানৱোচদ্ এতেষাং কিঞ্চিদপি যথা নাপচীযতে তথা সর্ৱ্ৱাণ্যৱশিষ্টানি সংগৃহ্লীত| ");
INSERT INTO sanben_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ততঃ সর্ৱ্ৱেষাং ভোজনাৎ পরং তে তেষাং পঞ্চানাং যাৱপূপানাং অৱশিষ্টান্যখিলানি সংগৃহ্য দ্ৱাদশডল্লকান্ অপূরযন্| ");
INSERT INTO sanben_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","অপরং যীশোরেতাদৃশীম্ আশ্চর্য্যক্রিযাং দৃষ্ট্ৱা লোকা মিথো ৱক্তুমারেভিরে জগতি যস্যাগমনং ভৱিষ্যতি স এৱাযম্ অৱশ্যং ভৱিষ্যদ্ৱক্ত্তা| ");
INSERT INTO sanben_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","অতএৱ লোকা আগত্য তমাক্রম্য রাজানং করিষ্যন্তি যীশুস্তেষাম্ ঈদৃশং মানসং ৱিজ্ঞায পুনশ্চ পর্ৱ্ৱতম্ একাকী গতৱান্| ");
INSERT INTO sanben_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","সাযংকাল উপস্থিতে শিষ্যা জলধিতটং ৱ্রজিৎৱা নাৱমারুহ্য নগরদিশি সিন্ধৌ ৱাহযিৎৱাগমন্| ");
INSERT INTO sanben_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","তস্মিন্ সমযে তিমির উপাতিষ্ঠৎ কিন্তু যীষুস্তেষাং সমীপং নাগচ্ছৎ| ");
INSERT INTO sanben_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","তদা প্রবলপৱনৱহনাৎ সাগরে মহাতরঙ্গো ভৱিতুম্ আরেভে| ");
INSERT INTO sanben_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ততস্তে ৱাহযিৎৱা দ্ৱিত্রান্ ক্রোশান্ গতাঃ পশ্চাদ্ যীশুং জলধেরুপরি পদ্ভ্যাং ৱ্রজন্তং নৌকান্তিকম্ আগচ্ছন্তং ৱিলোক্য ত্রাসযুক্তা অভৱন্ ");
INSERT INTO sanben_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","কিন্তু স তানুক্ত্তৱান্ অযমহং মা ভৈষ্ট| ");
INSERT INTO sanben_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","তদা তে তং স্ৱৈরং নাৱি গৃহীতৱন্তঃ তদা তৎক্ষণাদ্ উদ্দিষ্টস্থানে নৌরুপাস্থাৎ| ");
INSERT INTO sanben_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","যযা নাৱা শিষ্যা অগচ্ছন্ তদন্যা কাপি নৌকা তস্মিন্ স্থানে নাসীৎ ততো যীশুঃ শিষ্যৈঃ সাকং নাগমৎ কেৱলাঃ শিষ্যা অগমন্ এতৎ পারস্থা লোকা জ্ঞাতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","কিন্তু ততঃ পরং প্রভু র্যত্র ঈশ্ৱরস্য গুণান্ অনুকীর্ত্ত্য লোকান্ পূপান্ অভোজযৎ তৎস্থানস্য সমীপস্থতিৱিরিযাযা অপরাস্তরণয আগমন্| ");
INSERT INTO sanben_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","যীশুস্তত্র নাস্তি শিষ্যা অপি তত্র না সন্তি লোকা ইতি ৱিজ্ঞায যীশুং গৱেষযিতুং তরণিভিঃ কফর্নাহূম্ পুরং গতাঃ| ");
INSERT INTO sanben_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","ততস্তে সরিৎপতেঃ পারে তং সাক্ষাৎ প্রাপ্য প্রাৱোচন্ হে গুরো ভৱান্ অত্র স্থানে কদাগমৎ? ");
INSERT INTO sanben_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","তদা যীশুস্তান্ প্রত্যৱাদীদ্ যুষ্মানহং যথার্থতরং ৱদামি আশ্চর্য্যকর্ম্মদর্শনাদ্ধেতো র্ন কিন্তু পূপভোজনাৎ তেন তৃপ্তৎৱাঞ্চ মাং গৱেষযথ| ");
INSERT INTO sanben_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ক্ষযণীযভক্ষ্যার্থং মা শ্রামিষ্ট কিন্ত্ৱন্তাযুর্ভক্ষ্যার্থং শ্রাম্যত, তস্মাৎ তাদৃশং ভক্ষ্যং মনুজপুত্রো যুষ্মাভ্যং দাস্যতি; তস্মিন্ তাত ঈশ্ৱরঃ প্রমাণং প্রাদাৎ| ");
INSERT INTO sanben_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","তদা তেঽপৃচ্ছন্ ঈশ্ৱরাভিমতং কর্ম্ম কর্ত্তুম্ অস্মাভিঃ কিং কর্ত্তৱ্যং? ");
INSERT INTO sanben_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","ততো যীশুরৱদদ্ ঈশ্ৱরো যং প্রৈরযৎ তস্মিন্ ৱিশ্ৱসনম্ ঈশ্ৱরাভিমতং কর্ম্ম| ");
INSERT INTO sanben_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","তদা তে ৱ্যাহরন্ ভৱতা কিং লক্ষণং দর্শিতং যদ্দৃষ্ট্ৱা ভৱতি ৱিশ্ৱসিষ্যামঃ? ৎৱযা কিং কর্ম্ম কৃতং? ");
INSERT INTO sanben_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","অস্মাকং পূর্ৱ্ৱপুরুষা মহাপ্রান্তরে মান্নাং ভোক্ত্তুং প্রাপুঃ যথা লিপিরাস্তে| স্ৱর্গীযাণি তু ভক্ষ্যাণি প্রদদৌ পরমেশ্ৱরঃ| ");
INSERT INTO sanben_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","তদা যীশুরৱদদ্ অহং যুষ্মানতিযথার্থং ৱদামি মূসা যুষ্মাভ্যং স্ৱর্গীযং ভক্ষ্যং নাদাৎ কিন্তু মম পিতা যুষ্মাভ্যং স্ৱর্গীযং পরমং ভক্ষ্যং দদাতি| ");
INSERT INTO sanben_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","যঃ স্ৱর্গাদৱরুহ্য জগতে জীৱনং দদাতি স ঈশ্ৱরদত্তভক্ষ্যরূপঃ| ");
INSERT INTO sanben_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","তদা তে প্রাৱোচন্ হে প্রভো ভক্ষ্যমিদং নিত্যমস্মভ্যং দদাতু| ");
INSERT INTO sanben_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","যীশুরৱদদ্ অহমেৱ জীৱনরূপং ভক্ষ্যং যো জনো মম সন্নিধিম্ আগচ্ছতি স জাতু ক্ষুধার্ত্তো ন ভৱিষ্যতি, তথা যো জনো মাং প্রত্যেতি স জাতু তৃষার্ত্তো ন ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","মাং দৃষ্ট্ৱাপি যূযং ন ৱিশ্ৱসিথ যুষ্মানহম্ ইত্যৱোচং| ");
INSERT INTO sanben_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","পিতা মহ্যং যাৱতো লোকানদদাৎ তে সর্ৱ্ৱ এৱ মমান্তিকম্ আগমিষ্যন্তি যঃ কশ্চিচ্চ মম সন্নিধিম্ আযাস্যতি তং কেনাপি প্রকারেণ ন দূরীকরিষ্যামি| ");
INSERT INTO sanben_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","নিজাভিমতং সাধযিতুং ন হি কিন্তু প্রেরযিতুরভিমতং সাধযিতুং স্ৱর্গাদ্ আগতোস্মি| ");
INSERT INTO sanben_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","স যান্ যান্ লোকান্ মহ্যমদদাৎ তেষামেকমপি ন হারযিৎৱা শেষদিনে সর্ৱ্ৱানহম্ উত্থাপযামি ইদং মৎপ্রেরযিতুঃ পিতুরভিমতং| ");
INSERT INTO sanben_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","যঃ কশ্চিন্ মানৱসুতং ৱিলোক্য ৱিশ্ৱসিতি স শেষদিনে মযোত্থাপিতঃ সন্ অনন্তাযুঃ প্রাপ্স্যতি ইতি মৎপ্রেরকস্যাভিমতং| ");
INSERT INTO sanben_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","তদা স্ৱর্গাদ্ যদ্ ভক্ষ্যম্ অৱারোহৎ তদ্ ভক্ষ্যম্ অহমেৱ যিহূদীযলোকাস্তস্যৈতদ্ ৱাক্যে ৱিৱদমানা ৱক্ত্তুমারেভিরে ");
INSERT INTO sanben_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","যূষফঃ পুত্রো যীশু র্যস্য মাতাপিতরৌ ৱযং জানীম এষ কিং সএৱ ন? তর্হি স্ৱর্গাদ্ অৱারোহম্ ইতি ৱাক্যং কথং ৱক্ত্তি? ");
INSERT INTO sanben_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","তদা যীশুস্তান্ প্রত্যৱদৎ পরস্পরং মা ৱিৱদধ্ৱং ");
INSERT INTO sanben_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","মৎপ্রেরকেণ পিত্রা নাকৃষ্টঃ কোপি জনো মমান্তিকম্ আযাতুং ন শক্নোতি কিন্ত্ৱাগতং জনং চরমেঽহ্নি প্রোত্থাপযিষ্যামি| ");
INSERT INTO sanben_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","তে সর্ৱ্ৱ ঈশ্ৱরেণ শিক্ষিতা ভৱিষ্যন্তি ভৱিষ্যদ্ৱাদিনাং গ্রন্থেষু লিপিরিত্থমাস্তে অতো যঃ কশ্চিৎ পিতুঃ সকাশাৎ শ্রুৎৱা শিক্ষতে স এৱ মম সমীপম্ আগমিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","য ঈশ্ৱরাদ্ অজাযত তং ৱিনা কোপি মনুষ্যো জনকং নাদর্শৎ কেৱলঃ সএৱ তাতম্ অদ্রাক্ষীৎ| ");
INSERT INTO sanben_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","অহং যুষ্মান্ যথার্থতরং ৱদামি যো জনো মযি ৱিশ্ৱাসং করোতি সোনন্তাযুঃ প্রাপ্নোতি| ");
INSERT INTO sanben_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","অহমেৱ তজ্জীৱনভক্ষ্যং| ");
INSERT INTO sanben_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","যুষ্মাকং পূর্ৱ্ৱপুরুষা মহাপ্রান্তরে মন্নাভক্ষ্যং ভূক্ত্তাপি মৃতাঃ ");
INSERT INTO sanben_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","কিন্তু যদ্ভক্ষ্যং স্ৱর্গাদাগচ্ছৎ তদ্ যদি কশ্চিদ্ ভুঙ্ক্ত্তে তর্হি স ন ম্রিযতে| ");
INSERT INTO sanben_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","যজ্জীৱনভক্ষ্যং স্ৱর্গাদাগচ্ছৎ সোহমেৱ ইদং ভক্ষ্যং যো জনো ভুঙ্ক্ত্তে স নিত্যজীৱী ভৱিষ্যতি| পুনশ্চ জগতো জীৱনার্থমহং যৎ স্ৱকীযপিশিতং দাস্যামি তদেৱ মযা ৱিতরিতং ভক্ষ্যম্| ");
INSERT INTO sanben_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","তস্মাদ্ যিহূদীযাঃ পরস্পরং ৱিৱদমানা ৱক্ত্তুমারেভিরে এষ ভোজনার্থং স্ৱীযং পললং কথম্ অস্মভ্যং দাস্যতি? ");
INSERT INTO sanben_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","তদা যীশুস্তান্ আৱোচদ্ যুষ্মানহং যথার্থতরং ৱদামি মনুষ্যপুত্রস্যামিষে যুষ্মাভি র্ন ভুক্ত্তে তস্য রুধিরে চ ন পীতে জীৱনেন সার্দ্ধং যুষ্মাকং সম্বন্ধো নাস্তি| ");
INSERT INTO sanben_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","যো মমামিষং স্ৱাদতি মম সুধিরঞ্চ পিৱতি সোনন্তাযুঃ প্রাপ্নোতি ততঃ শেষেঽহ্নি তমহম্ উত্থাপযিষ্যামি| ");
INSERT INTO sanben_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","যতো মদীযমামিষং পরমং ভক্ষ্যং তথা মদীযং শোণিতং পরমং পেযং| ");
INSERT INTO sanben_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","যো জনো মদীযং পললং স্ৱাদতি মদীযং রুধিরঞ্চ পিৱতি স মযি ৱসতি তস্মিন্নহঞ্চ ৱসামি| ");
INSERT INTO sanben_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","মৎপ্রেরযিত্রা জীৱতা তাতেন যথাহং জীৱামি তদ্ৱদ্ যঃ কশ্চিন্ মামত্তি সোপি মযা জীৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","যদ্ভক্ষ্যং স্ৱর্গাদাগচ্ছৎ তদিদং যন্মান্নাং স্ৱাদিৎৱা যুষ্মাকং পিতরোঽম্রিযন্ত তাদৃশম্ ইদং ভক্ষ্যং ন ভৱতি ইদং ভক্ষ্যং যো ভক্ষতি স নিত্যং জীৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","যদা কফর্নাহূম্ পুর্য্যাং ভজনগেহে উপাদিশৎ তদা কথা এতা অকথযৎ| ");
INSERT INTO sanben_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","তদেত্থং শ্রুৎৱা তস্য শিষ্যাণাম্ অনেকে পরস্পরম্ অকথযন্ ইদং গাঢং ৱাক্যং ৱাক্যমীদৃশং কঃ শ্রোতুং শক্রুযাৎ? ");
INSERT INTO sanben_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","কিন্তু যীশুঃ শিষ্যাণাম্ ইত্থং ৱিৱাদং স্ৱচিত্তে ৱিজ্ঞায কথিতৱান্ ইদং ৱাক্যং কিং যুষ্মাকং ৱিঘ্নং জনযতি? ");
INSERT INTO sanben_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","যদি মনুজসুতং পূর্ৱ্ৱৱাসস্থানম্ ঊর্দ্ৱ্ৱং গচ্ছন্তং পশ্যথ তর্হি কিং ভৱিষ্যতি? ");
INSERT INTO sanben_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","আত্মৈৱ জীৱনদাযকঃ ৱপু র্নিষ্ফলং যুষ্মভ্যমহং যানি ৱচাংসি কথযামি তান্যাত্মা জীৱনঞ্চ| ");
INSERT INTO sanben_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","কিন্তু যুষ্মাকং মধ্যে কেচন অৱিশ্ৱাসিনঃ সন্তি কে কে ন ৱিশ্ৱসন্তি কো ৱা তং পরকরেষু সমর্পযিষ্যতি তান্ যীশুরাপ্রথমাদ্ ৱেত্তি| ");
INSERT INTO sanben_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","অপরমপি কথিতৱান্ অস্মাৎ কারণাদ্ অকথযং পিতুঃ সকাশাৎ শক্ত্তিমপ্রাপ্য কোপি মমান্তিকম্ আগন্তুং ন শক্নোতি| ");
INSERT INTO sanben_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","তৎকালেঽনেকে শিষ্যা ৱ্যাঘুট্য তেন সার্দ্ধং পুন র্নাগচ্ছন্| ");
INSERT INTO sanben_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","তদা যীশু র্দ্ৱাদশশিষ্যান্ উক্ত্তৱান্ যূযমপি কিং যাস্যথ? ");
INSERT INTO sanben_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ততঃ শিমোন্ পিতরঃ প্রত্যৱোচৎ হে প্রভো কস্যাভ্যর্ণং গমিষ্যামঃ? ");
INSERT INTO sanben_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","অনন্তজীৱনদাযিন্যো যাঃ কথাস্তাস্তৱৈৱ| ভৱান্ অমরেশ্ৱরস্যাভিষিক্ত্তপুত্র ইতি ৱিশ্ৱস্য নিশ্চিতং জানীমঃ| ");
INSERT INTO sanben_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","তদা যীশুরৱদৎ কিমহং যুষ্মাকং দ্ৱাদশজনান্ মনোনীতান্ ন কৃতৱান্? কিন্তু যুষ্মাকং মধ্যেপি কশ্চিদেকো ৱিঘ্নকারী ৱিদ্যতে| ");
INSERT INTO sanben_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ইমাং কথং স শিমোনঃ পুত্রম্ ঈষ্করীযোতীযং যিহূদাম্ উদ্দিশ্য কথিতৱান্ যতো দ্ৱাদশানাং মধ্যে গণিতঃ স তং পরকরেষু সমর্পযিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","ততঃ পরং যিহূদীযলোকাস্তং হন্তুং সমৈহন্ত তস্মাদ্ যীশু র্যিহূদাপ্রদেশে পর্য্যটিতুং নেচ্ছন্ গালীল্ প্রদেশে পর্য্যটিতুং প্রারভত| ");
INSERT INTO sanben_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","কিন্তু তস্মিন্ সমযে যিহূদীযানাং দূষ্যৱাসনামোৎসৱ উপস্থিতে ");
INSERT INTO sanben_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","তস্য ভ্রাতরস্তম্ অৱদন্ যানি কর্ম্মাণি ৎৱযা ক্রিযন্তে তানি যথা তৱ শিষ্যাঃ পশ্যন্তি তদর্থং ৎৱমিতঃ স্থানাদ্ যিহূদীযদেশং ৱ্রজ| ");
INSERT INTO sanben_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","যঃ কশ্চিৎ স্ৱযং প্রচিকাশিষতি স কদাপি গুপ্তং কর্ম্ম ন করোতি যদীদৃশং কর্ম্ম করোষি তর্হি জগতি নিজং পরিচাযয| ");
INSERT INTO sanben_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","যতস্তস্য ভ্রাতরোপি তং ন ৱিশ্ৱসন্তি| ");
INSERT INTO sanben_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","তদা যীশুস্তান্ অৱোচৎ মম সময ইদানীং নোপতিষ্ঠতি কিন্তু যুষ্মাকং সমযঃ সততম্ উপতিষ্ঠতি| ");
INSERT INTO sanben_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","জগতো লোকা যুষ্মান্ ঋতীযিতুং ন শক্রুৱন্তি কিন্তু মামেৱ ঋতীযন্তে যতস্তেষাং কর্মাণি দুষ্টানি তত্র সাক্ষ্যমিদম্ অহং দদামি| ");
INSERT INTO sanben_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","অতএৱ যূযম্ উৎসৱেঽস্মিন্ যাত নাহম্ ইদানীম্ অস্মিন্নুৎসৱে যামি যতো মম সময ইদানীং ন সম্পূর্ণঃ| ");
INSERT INTO sanben_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ইতি ৱাক্যম্ উক্ত্ত্ৱা স গালীলি স্থিতৱান্ ");
INSERT INTO sanben_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","কিন্তু তস্য ভ্রাতৃষু তত্র প্রস্থিতেষু সৎসু সোঽপ্রকট উৎসৱম্ অগচ্ছৎ| ");
INSERT INTO sanben_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","অনন্তরম্ উৎসৱম্ উপস্থিতা যিহূদীযাস্তং মৃগযিৎৱাপৃচ্ছন্ স কুত্র? ");
INSERT INTO sanben_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","ততো লোকানাং মধ্যে তস্মিন্ নানাৱিধা ৱিৱাদা ভৱিতুম্ আরব্ধৱন্তঃ| কেচিদ্ অৱোচন্ স উত্তমঃ পুরুষঃ কেচিদ্ অৱোচন্ ন তথা ৱরং লোকানাং ভ্রমং জনযতি| ");
INSERT INTO sanben_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","কিন্তু যিহূদীযানাং ভযাৎ কোপি তস্য পক্ষে স্পষ্টং নাকথযৎ| ");
INSERT INTO sanben_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ততঃ পরম্ উৎসৱস্য মধ্যসমযে যীশু র্মন্দিরং গৎৱা সমুপদিশতি স্ম| ");
INSERT INTO sanben_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ততো যিহূদীযা লোকা আশ্চর্য্যং জ্ঞাৎৱাকথযন্ এষা মানুষো নাধীত্যা কথম্ এতাদৃশো ৱিদ্ৱানভূৎ? ");
INSERT INTO sanben_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","তদা যীশুঃ প্রত্যৱোচদ্ উপদেশোযং ন মম কিন্তু যো মাং প্রেষিতৱান্ তস্য| ");
INSERT INTO sanben_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","যো জনো নিদেশং তস্য গ্রহীষ্যতি মমোপদেশো মত্তো ভৱতি কিম্ ঈশ্ৱরাদ্ ভৱতি স গনস্তজ্জ্ঞাতুং শক্ষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","যো জনঃ স্ৱতঃ কথযতি স স্ৱীযং গৌরৱম্ ঈহতে কিন্তু যঃ প্রেরযিতু র্গৌরৱম্ ঈহতে স সত্যৱাদী তস্মিন্ কোপ্যধর্ম্মো নাস্তি| ");
INSERT INTO sanben_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","মূসা যুষ্মভ্যং ৱ্যৱস্থাগ্রন্থং কিং নাদদাৎ? কিন্তু যুষ্মাকং কোপি তাং ৱ্যৱস্থাং ন সমাচরতি| মাং হন্তুং কুতো যতধ্ৱে? ");
INSERT INTO sanben_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","তদা লোকা অৱদন্ ৎৱং ভূতগ্রস্তস্ত্ৱাং হন্তুং কো যততে? ");
INSERT INTO sanben_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ততো যীশুরৱোচদ্ একং কর্ম্ম মযাকারি তস্মাদ্ যূযং সর্ৱ্ৱ মহাশ্চর্য্যং মন্যধ্ৱে| ");
INSERT INTO sanben_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","মূসা যুষ্মভ্যং ৎৱক্ছেদৱিধিং প্রদদৌ স মূসাতো ন জাতঃ কিন্তু পিতৃপুরুষেভ্যো জাতঃ তেন ৱিশ্রামৱারেঽপি মানুষাণাং ৎৱক্ছেদং কুরুথ| ");
INSERT INTO sanben_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","অতএৱ ৱিশ্রামৱারে মনুষ্যাণাং ৎৱক্ছেদে কৃতে যদি মূসাৱ্যৱস্থামঙ্গনং ন ভৱতি তর্হি মযা ৱিশ্রামৱারে মানুষঃ সম্পূর্ণরূপেণ স্ৱস্থোঽকারি তৎকারণাদ্ যূযং কিং মহ্যং কুপ্যথ? ");
INSERT INTO sanben_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","সপক্ষপাতং ৱিচারমকৃৎৱা ন্যায্যং ৱিচারং কুরুত| ");
INSERT INTO sanben_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","তদা যিরূশালম্ নিৱাসিনঃ কতিপযজনা অকথযন্ ইমে যং হন্তুং চেষ্টন্তে স এৱাযং কিং ন? ");
INSERT INTO sanben_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","কিন্তু পশ্যত নির্ভযঃ সন্ কথাং কথযতি তথাপি কিমপি অ ৱদন্ত্যেতে অযমেৱাভিষিক্ত্তো ভৱতীতি নিশ্চিতং কিমধিপতযো জানন্তি? ");
INSERT INTO sanben_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","মনুজোযং কস্মাদাগমদ্ ইতি ৱযং জানোমঃ কিন্ত্ৱভিষিক্ত্ত আগতে স কস্মাদাগতৱান্ ইতি কোপি জ্ঞাতুং ন শক্ষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","তদা যীশু র্মধ্যেমন্দিরম্ উপদিশন্ উচ্চৈঃকারম্ উক্ত্তৱান্ যূযং কিং মাং জানীথ? কস্মাচ্চাগতোস্মি তদপি কিং জানীথ? নাহং স্ৱত আগতোস্মি কিন্তু যঃ সত্যৱাদী সএৱ মাং প্রেষিতৱান্ যূযং তং ন জানীথ| ");
INSERT INTO sanben_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","তমহং জানে তেনাহং প্রেরিত অগতোস্মি| ");
INSERT INTO sanben_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","তস্মাদ্ যিহূদীযাস্তং ধর্ত্তুম্ উদ্যতাস্তথাপি কোপি তস্য গাত্রে হস্তং নার্পযদ্ যতো হেতোস্তদা তস্য সমযো নোপতিষ্ঠতি| ");
INSERT INTO sanben_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","কিন্তু বহৱো লোকাস্তস্মিন্ ৱিশ্ৱস্য কথিতৱান্তোঽভিষিক্ত্তপুরুষ আগত্য মানুষস্যাস্য ক্রিযাভ্যঃ কিম্ অধিকা আশ্চর্য্যাঃ ক্রিযাঃ করিষ্যতি? ");
INSERT INTO sanben_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","ততঃ পরং লোকাস্তস্মিন্ ইত্থং ৱিৱদন্তে ফিরূশিনঃ প্রধানযাজকাঞ্চেতি শ্রুতৱন্তস্তং ধৃৎৱা নেতুং পদাতিগণং প্রেষযামাসুঃ| ");
INSERT INTO sanben_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ততো যীশুরৱদদ্ অহম্ অল্পদিনানি যুষ্মাভিঃ সার্দ্ধং স্থিৎৱা মৎপ্রেরযিতুঃ সমীপং যাস্যামি| ");
INSERT INTO sanben_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","মাং মৃগযিষ্যধ্ৱে কিন্তূদ্দেশং ন লপ্স্যধ্ৱে রত্র স্থাস্যামি তত্র যূযং গন্তুং ন শক্ষ্যথ| ");
INSERT INTO sanben_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","তদা যিহূদীযাঃ পরস্পরং ৱক্ত্তুমারেভিরে অস্যোদ্দেশং ন প্রাপ্স্যাম এতাদৃশং কিং স্থানং যাস্যতি? ভিন্নদেশে ৱিকীর্ণানাং যিহূদীযানাং সন্নিধিম্ এষ গৎৱা তান্ উপদেক্ষ্যতি কিং? ");
INSERT INTO sanben_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","নো চেৎ মাং গৱেষযিষ্যথ কিন্তূদ্দেশং ন প্রাপ্স্যথ এষ কোদৃশং ৱাক্যমিদং ৱদতি? ");
INSERT INTO sanben_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","অনন্তরম্ উৎসৱস্য চরমেঽহনি অর্থাৎ প্রধানদিনে যীশুরুত্তিষ্ঠন্ উচ্চৈঃকারম্ আহ্ৱযন্ উদিতৱান্ যদি কশ্চিৎ তৃষার্ত্তো ভৱতি তর্হি মমান্তিকম্ আগত্য পিৱতু| ");
INSERT INTO sanben_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","যঃ কশ্চিন্মযি ৱিশ্ৱসিতি ধর্ম্মগ্রন্থস্য ৱচনানুসারেণ তস্যাভ্যন্তরতোঽমৃততোযস্য স্রোতাংসি নির্গমিষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","যে তস্মিন্ ৱিশ্ৱসন্তি ত আত্মানং প্রাপ্স্যন্তীত্যর্থে স ইদং ৱাক্যং ৱ্যাহৃতৱান্ এতৎকালং যাৱদ্ যীশু র্ৱিভৱং ন প্রাপ্তস্তস্মাৎ পৱিত্র আত্মা নাদীযত| ");
INSERT INTO sanben_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","এতাং ৱাণীং শ্রুৎৱা বহৱো লোকা অৱদন্ অযমেৱ নিশ্চিতং স ভৱিষ্যদ্ৱাদী| ");
INSERT INTO sanben_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","কেচিদ্ অকথযন্ এষএৱ সোভিষিক্ত্তঃ কিন্তু কেচিদ্ অৱদন্ সোভিষিক্ত্তঃ কিং গালীল্ প্রদেশে জনিষ্যতে? ");
INSERT INTO sanben_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","সোভিষিক্ত্তো দাযূদো ৱংশে দাযূদো জন্মস্থানে বৈৎলেহমি পত্তনে জনিষ্যতে ধর্ম্মগ্রন্থে কিমিত্থং লিখিতং নাস্তি? ");
INSERT INTO sanben_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ইত্থং তস্মিন্ লোকানাং ভিন্নৱাক্যতা জাতা| ");
INSERT INTO sanben_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","কতিপযলোকাস্তং ধর্ত্তুম্ ঐচ্ছন্ তথাপি তদ্ৱপুষি কোপি হস্তং নার্পযৎ| ");
INSERT INTO sanben_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","অনন্তরং পাদাতিগণে প্রধানযাজকানাং ফিরূশিনাঞ্চ সমীপমাগতৱতি তে তান্ অপৃচ্ছন্ কুতো হেতোস্তং নানযত? ");
INSERT INTO sanben_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","তদা পদাতযঃ প্রত্যৱদন্ স মানৱ ইৱ কোপি কদাপি নোপাদিশৎ| ");
INSERT INTO sanben_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ততঃ ফিরূশিনঃ প্রাৱোচন্ যূযমপি কিমভ্রামিষ্ট? ");
INSERT INTO sanben_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","অধিপতীনাং ফিরূশিনাঞ্চ কোপি কিং তস্মিন্ ৱ্যশ্ৱসীৎ? ");
INSERT INTO sanben_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","যে শাস্ত্রং ন জানন্তি ত ইমেঽধমলোকাএৱ শাপগ্রস্তাঃ| ");
INSERT INTO sanben_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","তদা নিকদীমনামা তেষামেকো যঃ ক্ষণদাযাং যীশোঃ সন্নিধিম্ অগাৎ স উক্ত্তৱান্ ");
INSERT INTO sanben_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","তস্য ৱাক্যে ন শ্রুতে কর্ম্মণি চ ন ৱিদিতে ঽস্মাকং ৱ্যৱস্থা কিং কঞ্চন মনুজং দোষীকরোতি? ");
INSERT INTO sanben_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ততস্তে ৱ্যাহরন্ ৎৱমপি কিং গালীলীযলোকঃ? ৱিৱিচ্য পশ্য গলীলি কোপি ভৱিষ্যদ্ৱাদী নোৎপদ্যতে| ");
INSERT INTO sanben_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","ততঃ পরং সর্ৱ্ৱে স্ৱং স্ৱং গৃহং গতাঃ কিন্তু যীশু র্জৈতুননামানং শিলোচ্চযং গতৱান্| ");
INSERT INTO sanben_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","প্রত্যূষে যীশুঃ পনর্মন্দিরম্ আগচ্ছৎ ");
INSERT INTO sanben_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ততঃ সর্ৱ্ৱেষু লোকেষু তস্য সমীপ আগতেষু স উপৱিশ্য তান্ উপদেষ্টুম্ আরভত| ");
INSERT INTO sanben_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","তদা অধ্যাপকাঃ ফিরূশিনঞ্চ ৱ্যভিচারকর্ম্মণি ধৃতং স্ত্রিযমেকাম্ আনিয সর্ৱ্ৱেষাং মধ্যে স্থাপযিৎৱা ৱ্যাহরন্ ");
INSERT INTO sanben_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","হে গুরো যোষিতম্ ইমাং ৱ্যভিচারকর্ম্ম কুর্ৱ্ৱাণাং লোকা ধৃতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","এতাদৃশলোকাঃ পাষাণাঘাতেন হন্তৱ্যা ইতি ৱিধির্মূসাৱ্যৱস্থাগ্রন্থে লিখিতোস্তি কিন্তু ভৱান্ কিমাদিশতি? ");
INSERT INTO sanben_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","তে তমপৱদিতুং পরীক্ষাভিপ্রাযেণ ৱাক্যমিদম্ অপৃচ্ছন্ কিন্তু স প্রহ্ৱীভূয ভূমাৱঙ্গল্যা লেখিতুম্ আরভত| ");
INSERT INTO sanben_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ততস্তৈঃ পুনঃ পুনঃ পৃষ্ট উত্থায কথিতৱান্ যুষ্মাকং মধ্যে যো জনো নিরপরাধী সএৱ প্রথমম্ এনাং পাষাণেনাহন্তু| ");
INSERT INTO sanben_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","পশ্চাৎ স পুনশ্চ প্রহ্ৱীভূয ভূমৌ লেখিতুম্ আরভত| ");
INSERT INTO sanben_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","তাং কথং শ্রুৎৱা তে স্ৱস্ৱমনসি প্রবোধং প্রাপ্য জ্যেষ্ঠানুক্রমং একৈকশঃ সর্ৱ্ৱে বহিরগচ্ছন্ ততো যীশুরেকাকী তযক্ত্তোভৱৎ মধ্যস্থানে দণ্ডাযমানা সা যোষা চ স্থিতা| ");
INSERT INTO sanben_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","তৎপশ্চাদ্ যীশুরুত্থায তাং ৱনিতাং ৱিনা কমপ্যপরং ন ৱিলোক্য পৃষ্টৱান্ হে ৱামে তৱাপৱাদকাঃ কুত্র? কোপি ৎৱাং কিং ন দণ্ডযতি? ");
INSERT INTO sanben_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","সাৱদৎ হে মহেচ্ছ কোপি ন তদা যীশুরৱোচৎ নাহমপি দণ্ডযামি যাহি পুনঃ পাপং মাকার্ষীঃ| ");
INSERT INTO sanben_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","ততো যীশুঃ পুনরপি লোকেভ্য ইত্থং কথযিতুম্ আরভত জগতোহং জ্যোতিঃস্ৱরূপো যঃ কশ্চিন্ মৎপশ্চাদ গচ্ছতি স তিমিরে ন ভ্রমিৎৱা জীৱনরূপাং দীপ্তিং প্রাপ্স্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ততঃ ফিরূশিনোঽৱাদিষুস্ত্ৱং স্ৱার্থে স্ৱযং সাক্ষ্যং দদাসি তস্মাৎ তৱ সাক্ষ্যং গ্রাহ্যং ন ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","তদা যীশুঃ প্রত্যুদিতৱান্ যদ্যপি স্ৱার্থেঽহং স্ৱযং সাক্ষ্যং দদামি তথাপি মৎ সাক্ষ্যং গ্রাহ্যং যস্মাদ্ অহং কুত আগতোস্মি ক্ৱ যামি চ তদহং জানামি কিন্তু কুত আগতোস্মি কুত্র গচ্ছামি চ তদ্ যূযং ন জানীথ| ");
INSERT INTO sanben_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","যূযং লৌকিকং ৱিচারযথ নাহং কিমপি ৱিচারযামি| ");
INSERT INTO sanben_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","কিন্তু যদি ৱিচারযামি তর্হি মম ৱিচারো গ্রহীতৱ্যো যতোহম্ একাকী নাস্মি প্রেরযিতা পিতা মযা সহ ৱিদ্যতে| ");
INSERT INTO sanben_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","দ্ৱযো র্জনযোঃ সাক্ষ্যং গ্রহণীযং ভৱতীতি যুষ্মাকং ৱ্যৱস্থাগ্রন্থে লিখিতমস্তি| ");
INSERT INTO sanben_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","অহং স্ৱার্থে স্ৱযং সাক্ষিৎৱং দদামি যশ্চ মম তাতো মাং প্রেরিতৱান্ সোপি মদর্থে সাক্ষ্যং দদাতি| ");
INSERT INTO sanben_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","তদা তেঽপৃচ্ছন্ তৱ তাতঃ কুত্র? ততো যীশুঃ প্রত্যৱাদীদ্ যূযং মাং ন জানীথ মৎপিতরঞ্চ ন জানীথ যদি মাম্ অক্ষাস্যত তর্হি মম তাতমপ্যক্ষাস্যত| ");
INSERT INTO sanben_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","যীশু র্মন্দির উপদিশ্য ভণ্ডাগারে কথা এতা অকথযৎ তথাপি তং প্রতি কোপি করং নোদতোলযৎ| ");
INSERT INTO sanben_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ততঃ পরং যীশুঃ পুনরুদিতৱান্ অধুনাহং গচ্ছামি যূযং মাং গৱেষযিষ্যথ কিন্তু নিজৈঃ পাপৈ র্মরিষ্যথ যৎ স্থানম্ অহং যাস্যামি তৎ স্থানম্ যূযং যাতুং ন শক্ষ্যথ| ");
INSERT INTO sanben_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","তদা যিহূদীযাঃ প্রাৱোচন্ কিমযম্ আত্মঘাতং করিষ্যতি? যতো যৎ স্থানম্ অহং যাস্যামি তৎ স্থানম্ যূযং যাতুং ন শক্ষ্যথ ইতি ৱাক্যং ব্রৱীতি| ");
INSERT INTO sanben_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ততো যীশুস্তেভ্যঃ কথিতৱান্ যূযম্ অধঃস্থানীযা লোকা অহম্ ঊর্দ্ৱ্ৱস্থানীযঃ যূযম্ এতজ্জগৎসম্বন্ধীযা অহম্ এতজ্জগৎসম্বন্ধীযো ন| ");
INSERT INTO sanben_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","তস্মাৎ কথিতৱান্ যূযং নিজৈঃ পাপৈ র্মরিষ্যথ যতোহং স পুমান্ ইতি যদি ন ৱিশ্ৱসিথ তর্হি নিজৈঃ পাপৈ র্মরিষ্যথ| ");
INSERT INTO sanben_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","তদা তে ঽপৃচ্ছন্ কস্ত্ৱং? ততো যীশুঃ কথিতৱান্ যুষ্মাকং সন্নিধৌ যস্য প্রস্তাৱম্ আ প্রথমাৎ করোমি সএৱ পুরুষোহং| ");
INSERT INTO sanben_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","যুষ্মাসু মযা বহুৱাক্যং ৱক্ত্তৱ্যং ৱিচারযিতৱ্যঞ্চ কিন্তু মৎপ্রেরযিতা সত্যৱাদী তস্য সমীপে যদহং শ্রুতৱান্ তদেৱ জগতে কথযামি| ");
INSERT INTO sanben_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","কিন্তু স জনকে ৱাক্যমিদং প্রোক্ত্তৱান্ ইতি তে নাবুধ্যন্ত| ");
INSERT INTO sanben_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ততো যীশুরকথযদ্ যদা মনুষ্যপুত্রম্ ঊর্দ্ৱ্ৱ উত্থাপযিষ্যথ তদাহং স পুমান্ কেৱলঃ স্ৱযং কিমপি কর্ম্ম ন করোমি কিন্তু তাতো যথা শিক্ষযতি তদনুসারেণ ৱাক্যমিদং ৱদামীতি চ যূযং জ্ঞাতুং শক্ষ্যথ| ");
INSERT INTO sanben_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","মৎপ্রেরযিতা পিতা মাম্ একাকিনং ন ত্যজতি স মযা সার্দ্ধং তিষ্ঠতি যতোহং তদভিমতং কর্ম্ম সদা করোমি| ");
INSERT INTO sanben_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","তদা তস্যৈতানি ৱাক্যানি শ্রুৎৱা বহুৱস্তাস্মিন্ ৱ্যশ্ৱসন্| ");
INSERT INTO sanben_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","যে যিহূদীযা ৱ্যশ্ৱসন্ যীশুস্তেভ্যোঽকথযৎ ");
INSERT INTO sanben_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","মম ৱাক্যে যদি যূযম্ আস্থাং কুরুথ তর্হি মম শিষ্যা ভূৎৱা সত্যৎৱং জ্ঞাস্যথ ততঃ সত্যতযা যুষ্মাকং মোক্ষো ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","তদা তে প্রত্যৱাদিষুঃ ৱযম্ ইব্রাহীমো ৱংশঃ কদাপি কস্যাপি দাসা ন জাতাস্তর্হি যুষ্মাকং মুক্ত্তি র্ভৱিষ্যতীতি ৱাক্যং কথং ব্রৱীষি? ");
INSERT INTO sanben_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","তদা যীশুঃ প্রত্যৱদদ্ যুষ্মানহং যথার্থতরং ৱদামি যঃ পাপং করোতি স পাপস্য দাসঃ| ");
INSERT INTO sanben_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","দাসশ্চ নিরন্তরং নিৱেশনে ন তিষ্ঠতি কিন্তু পুত্রো নিরন্তরং তিষ্ঠতি| ");
INSERT INTO sanben_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","অতঃ পুত্রো যদি যুষ্মান্ মোচযতি তর্হি নিতান্তমেৱ মুক্ত্তা ভৱিষ্যথ| ");
INSERT INTO sanben_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","যুযম্ ইব্রাহীমো ৱংশ ইত্যহং জানামি কিন্তু মম কথা যুষ্মাকম্ অন্তঃকরণেষু স্থানং ন প্রাপ্নুৱন্তি তস্মাদ্ধেতো র্মাং হন্তুম্ ঈহধ্ৱে| ");
INSERT INTO sanben_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","অহং স্ৱপিতুঃ সমীপে যদপশ্যং তদেৱ কথযামি তথা যূযমপি স্ৱপিতুঃ সমীপে যদপশ্যত তদেৱ কুরুধ্ৱে| ");
INSERT INTO sanben_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","তদা তে প্রত্যৱোচন্ ইব্রাহীম্ অস্মাকং পিতা ততো যীশুরকথযদ্ যদি যূযম্ ইব্রাহীমঃ সন্তানা অভৱিষ্যত তর্হি ইব্রাহীম আচারণৱদ্ আচরিষ্যত| ");
INSERT INTO sanben_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ঈশ্ৱরস্য মুখাৎ সত্যং ৱাক্যং শ্রুৎৱা যুষ্মান্ জ্ঞাপযামি যোহং তং মাং হন্তুং চেষ্টধ্ৱে ইব্রাহীম্ এতাদৃশং কর্ম্ম ন চকার| ");
INSERT INTO sanben_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","যূযং স্ৱস্ৱপিতুঃ কর্ম্মাণি কুরুথ তদা তৈরুক্ত্তং ন ৱযং জারজাতা অস্মাকম্ একএৱ পিতাস্তি স এৱেশ্ৱরঃ ");
INSERT INTO sanben_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ততো যীশুনা কথিতম্ ঈশ্ৱরো যদি যুষ্মাকং তাতোভৱিষ্যৎ তর্হি যূযং মযি প্রেমাকরিষ্যত যতোহম্ ঈশ্ৱরান্নির্গত্যাগতোস্মি স্ৱতো নাগতোহং স মাং প্রাহিণোৎ| ");
INSERT INTO sanben_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","যূযং মম ৱাক্যমিদং ন বুধ্যধ্ৱে কুতঃ? যতো যূযং মমোপদেশং সোঢুং ন শক্নুথ| ");
INSERT INTO sanben_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","যূযং শৈতান্ পিতুঃ সন্তানা এতস্মাদ্ যুষ্মাকং পিতুরভিলাষং পূরযথ স আ প্রথমাৎ নরঘাতী তদন্তঃ সত্যৎৱস্য লেশোপি নাস্তি কারণাদতঃ স সত্যতাযাং নাতিষ্ঠৎ স যদা মৃষা কথযতি তদা নিজস্ৱভাৱানুসারেণৈৱ কথযতি যতো স মৃষাভাষী মৃষোৎপাদকশ্চ| ");
INSERT INTO sanben_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","অহং তথ্যৱাক্যং ৱদামি কারণাদস্মাদ্ যূযং মাং ন প্রতীথ| ");
INSERT INTO sanben_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","মযি পাপমস্তীতি প্রমাণং যুষ্মাকং কো দাতুং শক্নোতি? যদ্যহং তথ্যৱাক্যং ৱদামি তর্হি কুতো মাং ন প্রতিথ? ");
INSERT INTO sanben_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","যঃ কশ্চন ঈশ্ৱরীযো লোকঃ স ঈশ্ৱরীযকথাযাং মনো নিধত্তে যূযম্ ঈশ্ৱরীযলোকা ন ভৱথ তন্নিদানাৎ তত্র ন মনাংসি নিধদ্ৱে| ");
INSERT INTO sanben_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","তদা যিহূদীযাঃ প্রত্যৱাদিষুঃ ৎৱমেকঃ শোমিরোণীযো ভূতগ্রস্তশ্চ ৱযং কিমিদং ভদ্রং নাৱাদিষ্ম? ");
INSERT INTO sanben_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ততো যীশুঃ প্রত্যৱাদীৎ নাহং ভূতগ্রস্তঃ কিন্তু নিজতাতং সম্মন্যে তস্মাদ্ যূযং মাম্ অপমন্যধ্ৱে| ");
INSERT INTO sanben_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","অহং স্ৱসুখ্যাতিং ন চেষ্টে কিন্তু চেষ্টিতা ৱিচারযিতা চাপর এক আস্তে| ");
INSERT INTO sanben_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","অহং যুষ্মভ্যম্ অতীৱ যথার্থং কথযামি যো নরো মদীযং ৱাচং মন্যতে স কদাচন নিধনং ন দ্রক্ষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","যিহূদীযাস্তমৱদন্ ৎৱং ভূতগ্রস্ত ইতীদানীম্ অৱৈষ্ম| ইব্রাহীম্ ভৱিষ্যদ্ৱাদিনঞ্চ সর্ৱ্ৱে মৃতাঃ কিন্তু ৎৱং ভাষসে যো নরো মম ভারতীং গৃহ্লাতি স জাতু নিধানাস্ৱাদং ন লপ্স্যতে| ");
INSERT INTO sanben_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","তর্হি ৎৱং কিম্ অস্মাকং পূর্ৱ্ৱপুরুষাদ্ ইব্রাহীমোপি মহান্? যস্মাৎ সোপি মৃতঃ ভৱিষ্যদ্ৱাদিনোপি মৃতাঃ ৎৱং স্ৱং কং পুমাংসং মনুষে? ");
INSERT INTO sanben_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","যীশুঃ প্রত্যৱোচদ্ যদ্যহং স্ৱং স্ৱযং সম্মন্যে তর্হি মম তৎ সম্মননং কিমপি ন কিন্তু মম তাতো যং যূযং স্ৱীযম্ ঈশ্ৱরং ভাষধ্ৱে সএৱ মাং সম্মনুতে| ");
INSERT INTO sanben_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","যূযং তং নাৱগচ্ছথ কিন্ত্ৱহং তমৱগচ্ছামি তং নাৱগচ্ছামীতি ৱাক্যং যদি ৱদামি তর্হি যূযমিৱ মৃষাভাষী ভৱামি কিন্ত্ৱহং তমৱগচ্ছামি তদাক্ষামপি গৃহ্লামি| ");
INSERT INTO sanben_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","যুষ্মাকং পূর্ৱ্ৱপুরুষ ইব্রাহীম্ মম সমযং দ্রষ্টুম্ অতীৱাৱাঞ্ছৎ তন্নিরীক্ষ্যানন্দচ্চ| ");
INSERT INTO sanben_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","তদা যিহূদীযা অপৃচ্ছন্ তৱ ৱযঃ পঞ্চাশদ্ৱৎসরা ন ৎৱং কিম্ ইব্রাহীমম্ অদ্রাক্ষীঃ? ");
INSERT INTO sanben_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","যীশুঃ প্রত্যৱাদীদ্ যুষ্মানহং যথার্থতরং ৱদামি ইব্রাহীমো জন্মনঃ পূর্ৱ্ৱকালমারভ্যাহং ৱিদ্যে| ");
INSERT INTO sanben_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","তদা তে পাষাণান্ উত্তোল্য তমাহন্তুম্ উদযচ্ছন্ কিন্তু যীশু র্গুপ্তো মন্তিরাদ্ বহির্গত্য তেষাং মধ্যেন প্রস্থিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","ততঃ পরং যীশুর্গচ্ছন্ মার্গমধ্যে জন্মান্ধং নরম্ অপশ্যৎ| ");
INSERT INTO sanben_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ততঃ শিষ্যাস্তম্ অপৃচ্ছন্ হে গুরো নরোযং স্ৱপাপেন ৱা স্ৱপিত্রাঃ পাপেনান্ধোঽজাযত? ");
INSERT INTO sanben_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","ততঃ স প্রত্যুদিতৱান্ এতস্য ৱাস্য পিত্রোঃ পাপাদ্ এতাদৃশোভূদ ইতি নহি কিন্ত্ৱনেন যথেশ্ৱরস্য কর্ম্ম প্রকাশ্যতে তদ্ধেতোরেৱ| ");
INSERT INTO sanben_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","দিনে তিষ্ঠতি মৎপ্রেরযিতুঃ কর্ম্ম মযা কর্ত্তৱ্যং যদা কিমপি কর্ম্ম ন ক্রিযতে তাদৃশী নিশাগচ্ছতি| ");
INSERT INTO sanben_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","অহং যাৱৎকালং জগতি তিষ্ঠামি তাৱৎকালং জগতো জ্যোতিঃস্ৱরূপোস্মি| ");
INSERT INTO sanben_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ইত্যুক্ত্তা ভূমৌ নিষ্ঠীৱং নিক্ষিপ্য তেন পঙ্কং কৃতৱান্ ");
INSERT INTO sanben_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","পশ্চাৎ তৎপঙ্কেন তস্যান্ধস্য নেত্রে প্রলিপ্য তমিত্যাদিশৎ গৎৱা শিলোহে ঽর্থাৎ প্রেরিতনাম্নি সরসি স্নাহি| ততোন্ধো গৎৱা তত্রাস্নাৎ ততঃ প্রন্নচক্ষু র্ভূৎৱা ৱ্যাঘুট্যাগাৎ| ");
INSERT INTO sanben_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","অপরঞ্চ সমীপৱাসিনো লোকা যে চ তং পূর্ৱ্ৱমন্ধম্ অপশ্যন্ তে বক্ত্তুম্ আরভন্ত যোন্ধলোকো ৱর্ত্মন্যুপৱিশ্যাভিক্ষত স এৱাযং জনঃ কিং ন ভৱতি? ");
INSERT INTO sanben_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","কেচিদৱদন্ স এৱ কেচিদৱোচন্ তাদৃশো ভৱতি কিন্তু স স্ৱযমব্রৱীৎ স এৱাহং ভৱামি| ");
INSERT INTO sanben_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","অতএৱ তে ঽপৃচ্ছন্ ৎৱং কথং দৃষ্টিং পাপ্তৱান্? ");
INSERT INTO sanben_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ততঃ সোৱদদ্ যীশনামক একো জনো মম নযনে পঙ্কেন প্রলিপ্য ইত্যাজ্ঞাপযৎ শিলোহকাসারং গৎৱা তত্র স্নাহি| ততস্তত্র গৎৱা মযি স্নাতে দৃষ্টিমহং লব্ধৱান্| ");
INSERT INTO sanben_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","তদা তে ঽৱদন্ স পুমান্ কুত্র? তেনোক্ত্তং নাহং জানামি| ");
INSERT INTO sanben_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","অপরং তস্মিন্ পূর্ৱ্ৱান্ধে জনে ফিরূশিনাং নিকটম্ আনীতে সতি ফিরূশিনোপি তমপৃচ্ছন্ কথং দৃষ্টিং প্রাপ্তোসি? ");
INSERT INTO sanben_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ততঃ স কথিতৱান্ স পঙ্কেন মম নেত্রে ঽলিম্পৎ পশ্চাদ্ স্নাৎৱা দৃষ্টিমলভে| ");
INSERT INTO sanben_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","কিন্তু যীশু র্ৱিশ্রামৱারে কর্দ্দমং কৃৎৱা তস্য নযনে প্রসন্নেঽকরোদ্ ইতিকারণাৎ কতিপযফিরূশিনোঽৱদন্ ");
INSERT INTO sanben_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","স পুমান্ ঈশ্ৱরান্ন যতঃ স ৱিশ্রামৱারং ন মন্যতে| ততোন্যে কেচিৎ প্রত্যৱদন্ পাপী পুমান্ কিম্ এতাদৃশম্ আশ্চর্য্যং কর্ম্ম কর্ত্তুং শক্নোতি? ");
INSERT INTO sanben_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ইত্থং তেষাং পরস্পরং ভিন্নৱাক্যৎৱম্ অভৱৎ| পশ্চাৎ তে পুনরপি তং পূর্ৱ্ৱান্ধং মানুষম্ অপ্রাক্ষুঃ যো জনস্তৱ চক্ষুষী প্রসন্নে কৃতৱান্ তস্মিন্ ৎৱং কিং ৱদসি? স উক্ত্তৱান্ স ভৱিশদ্ৱাদী| ");
INSERT INTO sanben_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","স দৃষ্টিম্ আপ্তৱান্ ইতি যিহূদীযাস্তস্য দৃষ্টিং প্রাপ্তস্য জনস্য পিত্রো র্মুখাদ্ অশ্রুৎৱা ন প্রত্যযন্| ");
INSERT INTO sanben_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","অতএৱ তে তাৱপৃচ্ছন্ যুৱযো র্যং পুত্রং জন্মান্ধং ৱদথঃ স কিমযং? তর্হীদানীং কথং দ্রষ্টুং শক্নোতি? ");
INSERT INTO sanben_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ততস্তস্য পিতরৌ প্রত্যৱোচতাম্ অযম্ আৱযোঃ পুত্র আ জনেরন্ধশ্চ তদপ্যাৱাং জানীৱঃ ");
INSERT INTO sanben_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","কিন্ত্ৱধুনা কথং দৃষ্টিং প্রাপ্তৱান্ তদাৱাং ন্ জানীৱঃ কোস্য চক্ষুষী প্রসন্নে কৃতৱান্ তদপি ন জানীৱ এষ ৱযঃপ্রাপ্ত এনং পৃচ্ছত স্ৱকথাং স্ৱযং ৱক্ষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","যিহূদীযানাং ভযাৎ তস্য পিতরৌ ৱাক্যমিদম্ অৱদতাং যতঃ কোপি মনুষ্যো যদি যীশুম্ অভিষিক্তং ৱদতি তর্হি স ভজনগৃহাদ্ দূরীকারিষ্যতে যিহূদীযা ইতি মন্ত্রণাম্ অকুর্ৱ্ৱন্ ");
INSERT INTO sanben_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","অতস্তস্য পিতরৌ ৱ্যাহরতাম্ এষ ৱযঃপ্রাপ্ত এনং পৃচ্ছত| ");
INSERT INTO sanben_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","তদা তে পুনশ্চ তং পূর্ৱ্ৱান্ধম্ আহূয ৱ্যাহরন্ ঈশ্ৱরস্য গুণান্ ৱদ এষ মনুষ্যঃ পাপীতি ৱযং জানীমঃ| ");
INSERT INTO sanben_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","তদা স উক্ত্তৱান্ স পাপী ন ৱেতি নাহং জানে পূর্ৱামন্ধ আসমহম্ অধুনা পশ্যামীতি মাত্রং জানামি| ");
INSERT INTO sanben_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","তে পুনরপৃচ্ছন্ স ৎৱাং প্রতি কিমকরোৎ? কথং নেত্রে প্রসন্নে ঽকরোৎ? ");
INSERT INTO sanben_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","ততঃ সোৱাদীদ্ এককৃৎৱোকথযং যূযং ন শৃণুথ তর্হি কুতঃ পুনঃ শ্রোতুম্ ইচ্ছথ? যূযমপি কিং তস্য শিষ্যা ভৱিতুম্ ইচ্ছথ? ");
INSERT INTO sanben_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","তদা তে তং তিরস্কৃত্য ৱ্যাহরন্ ৎৱং তস্য শিষ্যো ৱযং মূসাঃ শিষ্যাঃ| ");
INSERT INTO sanben_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","মূসাৱক্ত্রেণেশ্ৱরো জগাদ তজ্জানীমঃ কিন্ত্ৱেষ কুত্রত্যলোক ইতি ন জানীমঃ| ");
INSERT INTO sanben_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","সোৱদদ্ এষ মম লোচনে প্রসন্নে ঽকরোৎ তথাপি কুত্রত্যলোক ইতি যূযং ন জানীথ এতদ্ আশ্চর্য্যং ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ঈশ্ৱরঃ পাপিনাং কথাং ন শৃণোতি কিন্তু যো জনস্তস্মিন্ ভক্তিং কৃৎৱা তদিষ্টক্রিযাং করোতি তস্যৈৱ কথাং শৃণোতি এতদ্ ৱযং জানীমঃ| ");
INSERT INTO sanben_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","কোপি মনুষ্যো জন্মান্ধায চক্ষুষী অদদাৎ জগদারম্ভাদ্ এতাদৃশীং কথাং কোপি কদাপি নাশৃণোৎ| ");
INSERT INTO sanben_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","অস্মাদ্ এষ মনুষ্যো যদীশ্ৱরান্নাজাযত তর্হি কিঞ্চিদপীদৃশং কর্ম্ম কর্ত্তুং নাশক্নোৎ| ");
INSERT INTO sanben_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","তে ৱ্যাহরন্ ৎৱং পাপাদ্ অজাযথাঃ কিমস্মান্ ৎৱং শিক্ষযসি? পশ্চাত্তে তং বহিরকুর্ৱ্ৱন্| ");
INSERT INTO sanben_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","তদনন্তরং যিহূদীযৈঃ স বহিরক্রিযত যীশুরিতি ৱার্ত্তাং শ্রুৎৱা তং সাক্ষাৎ প্রাপ্য পৃষ্টৱান্ ঈশ্ৱরস্য পুত্রে ৎৱং ৱিশ্ৱসিষি? ");
INSERT INTO sanben_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","তদা স প্রত্যৱোচৎ হে প্রভো স কো যৎ তস্মিন্নহং ৱিশ্ৱসিমি? ");
INSERT INTO sanben_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","ততো যীশুঃ কথিতৱান্ ৎৱং তং দৃষ্টৱান্ ৎৱযা সাকং যঃ কথং কথযতি সএৱ সঃ| ");
INSERT INTO sanben_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","তদা হে প্রভো ৱিশ্ৱসিমীত্যুক্ত্ৱা স তং প্রণামৎ| ");
INSERT INTO sanben_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","পশ্চাদ্ যীশুঃ কথিতৱান্ নযনহীনা নযনানি প্রাপ্নুৱন্তি নযনৱন্তশ্চান্ধা ভৱন্তীত্যভিপ্রাযেণ জগদাহম্ আগচ্ছম্| ");
INSERT INTO sanben_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","এতৎ শ্রুৎৱা নিকটস্থাঃ কতিপযাঃ ফিরূশিনো ৱ্যাহরন্ ৱযমপি কিমন্ধাঃ? ");
INSERT INTO sanben_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","তদা যীশুরৱাদীদ্ যদ্যন্ধা অভৱত তর্হি পাপানি নাতিষ্ঠন্ কিন্তু পশ্যামীতি ৱাক্যৱদনাদ্ যুষ্মাকং পাপানি তিষ্ঠন্তি| ");
INSERT INTO sanben_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","অহং যুষ্মানতিযথার্থং ৱদামি, যো জনো দ্ৱারেণ ন প্রৱিশ্য কেনাপ্যন্যেন মেষগৃহং প্রৱিশতি স এৱ স্তেনো দস্যুশ্চ| ");
INSERT INTO sanben_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","যো দ্ৱারেণ প্রৱিশতি স এৱ মেষপালকঃ| ");
INSERT INTO sanben_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","দৌৱারিকস্তস্মৈ দ্ৱারং মোচযতি মেষগণশ্চ তস্য ৱাক্যং শৃণোতি স নিজান্ মেষান্ স্ৱস্ৱনাম্নাহূয বহিঃ কৃৎৱা নযতি| ");
INSERT INTO sanben_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","তথা নিজান্ মেষান্ বহিঃ কৃৎৱা স্ৱযং তেষাম্ অগ্রে গচ্ছতি, ততো মেষাস্তস্য শব্দং বুধ্যন্তে, তস্মাৎ তস্য পশ্চাদ্ ৱ্রজন্তি| ");
INSERT INTO sanben_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","কিন্তু পরস্য শব্দং ন বুধ্যন্তে তস্মাৎ তস্য পশ্চাদ্ ৱ্রজিষ্যন্তি ৱরং তস্য সমীপাৎ পলাযিষ্যন্তে| ");
INSERT INTO sanben_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","যীশুস্তেভ্য ইমাং দৃষ্টান্তকথাম্ অকথযৎ কিন্তু তেন কথিতকথাযাস্তাৎপর্য্যং তে নাবুধ্যন্ত| ");
INSERT INTO sanben_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","অতো যীশুঃ পুনরকথযৎ, যুষ্মানাহং যথার্থতরং ৱ্যাহরামি, মেষগৃহস্য দ্ৱারম্ অহমেৱ| ");
INSERT INTO sanben_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","মযা ন প্রৱিশ্য য আগচ্ছন্ তে স্তেনা দস্যৱশ্চ কিন্তু মেষাস্তেষাং কথা নাশৃণ্ৱন্| ");
INSERT INTO sanben_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","অহমেৱ দ্ৱারস্ৱরূপঃ, মযা যঃ কশ্চিত প্রৱিশতি স রক্ষাং প্রাপ্স্যতি তথা বহিরন্তশ্চ গমনাগমনে কৃৎৱা চরণস্থানং প্রাপ্স্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","যো জনস্তেনঃ স কেৱলং স্তৈন্যবধৱিনাশান্ কর্ত্তুমেৱ সমাযাতি কিন্ত্ৱহম্ আযু র্দাতুম্ অর্থাৎ বাহূল্যেন তদেৱ দাতুম্ আগচ্ছম্| ");
INSERT INTO sanben_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","অহমেৱ সত্যমেষপালকো যস্তু সত্যো মেষপালকঃ স মেষার্থং প্রাণত্যাগং করোতি; ");
INSERT INTO sanben_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","কিন্তু যো জনো মেষপালকো ন, অর্থাদ্ যস্য মেষা নিজা ন ভৱন্তি, য এতাদৃশো ৱৈতনিকঃ স ৱৃকম্ আগচ্ছন্তং দৃষ্ট্ৱা মেজৱ্রজং ৱিহায পলাযতে, তস্মাদ্ ৱৃকস্তং ৱ্রজং ধৃৎৱা ৱিকিরতি| ");
INSERT INTO sanben_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ৱৈতনিকঃ পলাযতে যতঃ স ৱেতনার্থী মেষার্থং ন চিন্তযতি| ");
INSERT INTO sanben_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","অহমেৱ সত্যো মেষপালকঃ, পিতা মাং যথা জানাতি, অহঞ্চ যথা পিতরং জানামি, ");
INSERT INTO sanben_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","তথা নিজান্ মেষানপি জানামি, মেষাশ্চ মাং জানান্তি, অহঞ্চ মেষার্থং প্রাণত্যাগং করোমি| ");
INSERT INTO sanben_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","অপরঞ্চ এতদ্ গৃহীয মেষেভ্যো ভিন্না অপি মেষা মম সন্তি তে সকলা আনযিতৱ্যাঃ; তে মম শব্দং শ্রোষ্যন্তি তত একো ৱ্রজ একো রক্ষকো ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","প্রাণানহং ত্যক্ত্ৱা পুনঃ প্রাণান্ গ্রহীষ্যামি, তস্মাৎ পিতা মযি স্নেহং করোতি| ");
INSERT INTO sanben_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","কশ্চিজ্জনো মম প্রাণান্ হন্তুং ন শক্নোতি কিন্তু স্ৱযং তান্ সমর্পযামি তান্ সমর্পযিতুং পুনর্গ্রহীতুঞ্চ মম শক্তিরাস্তে ভারমিমং স্ৱপিতুঃ সকাশাৎ প্রাপ্তোহম্| ");
INSERT INTO sanben_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","অস্মাদুপদেশাৎ পুনশ্চ যিহূদীযানাং মধ্যে ভিন্নৱাক্যতা জাতা| ");
INSERT INTO sanben_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ততো বহৱো ৱ্যাহরন্ এষ ভূতগ্রস্ত উন্মত্তশ্চ, কুত এতস্য কথাং শৃণুথ? ");
INSERT INTO sanben_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","কেচিদ্ অৱদন্ এতস্য কথা ভূতগ্রস্তস্য কথাৱন্ন ভৱন্তি, ভূতঃ কিম্ অন্ধায চক্ষুষী দাতুং শক্নোতি? ");
INSERT INTO sanben_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","শীতকালে যিরূশালমি মন্দিরোৎসর্গপর্ৱ্ৱণ্যুপস্থিতে ");
INSERT INTO sanben_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","যীশুঃ সুলেমানো নিঃসারেণ গমনাগমনে করোতি, ");
INSERT INTO sanben_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","এতস্মিন্ সমযে যিহূদীযাস্তং ৱেষ্টযিৎৱা ৱ্যাহরন্ কতি কালান্ অস্মাকং ৱিচিকিৎসাং স্থাপযিষ্যামি? যদ্যভিষিক্তো ভৱতি তর্হি তৎ স্পষ্টং ৱদ| ");
INSERT INTO sanben_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","তদা যীশুঃ প্রত্যৱদদ্ অহম্ অচকথং কিন্তু যূযং ন প্রতীথ, নিজপিতু র্নাম্না যাং যাং ক্রিযাং করোমি সা ক্রিযৈৱ মম সাক্ষিস্ৱরূপা| ");
INSERT INTO sanben_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","কিন্ত্ৱহং পূর্ৱ্ৱমকথযং যূযং মম মেষা ন ভৱথ, কারণাদস্মান্ ন ৱিশ্ৱসিথ| ");
INSERT INTO sanben_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","মম মেষা মম শব্দং শৃণ্ৱন্তি তানহং জানামি তে চ মম পশ্চাদ্ গচ্ছন্তি| ");
INSERT INTO sanben_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","অহং তেভ্যোঽনন্তাযু র্দদামি, তে কদাপি ন নংক্ষ্যন্তি কোপি মম করাৎ তান্ হর্ত্তুং ন শক্ষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","যো মম পিতা তান্ মহ্যং দত্তৱান্ স সর্ৱ্ৱস্মাৎ মহান্, কোপি মম পিতুঃ করাৎ তান্ হর্ত্তুং ন শক্ষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","অহং পিতা চ দ্ৱযোরেকৎৱম্| ");
INSERT INTO sanben_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","ততো যিহূদীযাঃ পুনরপি তং হন্তুং পাষাণান্ উদতোলযন্| ");
INSERT INTO sanben_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","যীশুঃ কথিতৱান্ পিতুঃ সকাশাদ্ বহূন্যুত্তমকর্ম্মাণি যুষ্মাকং প্রাকাশযং তেষাং কস্য কর্ম্মণঃ কারণান্ মাং পাষাণৈরাহন্তুম্ উদ্যতাঃ স্থ? ");
INSERT INTO sanben_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","যিহূদীযাঃ প্রত্যৱদন্ প্রশস্তকর্ম্মহেতো র্ন কিন্তু ৎৱং মানুষঃ স্ৱমীশ্ৱরম্ উক্ত্ৱেশ্ৱরং নিন্দসি কারণাদস্মাৎ ৎৱাং পাষাণৈর্হন্মঃ| ");
INSERT INTO sanben_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","তদা যীশুঃ প্রত্যুক্তৱান্ মযা কথিতং যূযম্ ঈশ্ৱরা এতদ্ৱচনং যুষ্মাকং শাস্ত্রে লিখিতং নাস্তি কিং? ");
INSERT INTO sanben_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","তস্মাদ্ যেষাম্ উদ্দেশে ঈশ্ৱরস্য কথা কথিতা তে যদীশ্ৱরগণা উচ্যন্তে ধর্ম্মগ্রন্থস্যাপ্যন্যথা ভৱিতুং ন শক্যং, ");
INSERT INTO sanben_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","তর্হ্যাহম্ ঈশ্ৱরস্য পুত্র ইতি ৱাক্যস্য কথনাৎ যূযং পিত্রাভিষিক্তং জগতি প্রেরিতঞ্চ পুমাংসং কথম্ ঈশ্ৱরনিন্দকং ৱাদয? ");
INSERT INTO sanben_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","যদ্যহং পিতুঃ কর্ম্ম ন করোমি তর্হি মাং ন প্রতীত; ");
INSERT INTO sanben_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","কিন্তু যদি করোমি তর্হি মযি যুষ্মাভিঃ প্রত্যযে ন কৃতেঽপি কার্য্যে প্রত্যযঃ ক্রিযতাং, ততো মযি পিতাস্তীতি পিতর্য্যহম্ অস্মীতি চ ক্ষাৎৱা ৱিশ্ৱসিষ্যথ| ");
INSERT INTO sanben_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","তদা তে পুনরপি তং ধর্ত্তুম্ অচেষ্টন্ত কিন্তু স তেষাং করেভ্যো নিস্তীর্য্য ");
INSERT INTO sanben_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","পুন র্যর্দ্দন্ অদ্যাস্তটে যত্র পুর্ৱ্ৱং যোহন্ অমজ্জযৎ তত্রাগত্য ন্যৱসৎ| ");
INSERT INTO sanben_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ততো বহৱো লোকাস্তৎসমীপম্ আগত্য ৱ্যাহরন্ যোহন্ কিমপ্যাশ্চর্য্যং কর্ম্ম নাকরোৎ কিন্ত্ৱস্মিন্ মনুষ্যে যা যঃ কথা অকথযৎ তাঃ সর্ৱ্ৱাঃ সত্যাঃ; ");
INSERT INTO sanben_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","তত্র চ বহৱো লোকাস্তস্মিন্ ৱ্যশ্ৱসন্| ");
INSERT INTO sanben_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","অনন্তরং মরিযম্ তস্যা ভগিনী মর্থা চ যস্মিন্ ৱৈথনীযাগ্রামে ৱসতস্তস্মিন্ গ্রামে ইলিযাসর্ নামা পীডিত এক আসীৎ| ");
INSERT INTO sanben_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","যা মরিযম্ প্রভুং সুগন্ধিতেলৈন মর্দ্দযিৎৱা স্ৱকেশৈস্তস্য চরণৌ সমমার্জৎ তস্যা ভ্রাতা স ইলিযাসর্ রোগী| ");
INSERT INTO sanben_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","অপরঞ্চ হে প্রভো ভৱান্ যস্মিন্ প্রীযতে স এৱ পীডিতোস্তীতি কথাং কথযিৎৱা তস্য ভগিন্যৌ প্রেষিতৱত্যৌ| ");
INSERT INTO sanben_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","তদা যীশুরিমাং ৱার্ত্তাং শ্রুৎৱাকথযত পীডেযং মরণার্থং ন কিন্ত্ৱীশ্ৱরস্য মহিমার্থম্ ঈশ্ৱরপুত্রস্য মহিমপ্রকাশার্থঞ্চ জাতা| ");
INSERT INTO sanben_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","যীশু র্যদ্যপিমর্থাযাং তদ্ভগিন্যাম্ ইলিযাসরি চাপ্রীযত, ");
INSERT INTO sanben_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","তথাপি ইলিযাসরঃ পীডাযাঃ কথং শ্রুৎৱা যত্র আসীৎ তত্রৈৱ দিনদ্ৱযমতিষ্ঠৎ| ");
INSERT INTO sanben_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ততঃ পরম্ স শিষ্যানকথযদ্ ৱযং পুন র্যিহূদীযপ্রদেশং যামঃ| ");
INSERT INTO sanben_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","ততস্তে প্রত্যৱদন্, হে গুরো স্ৱল্পদিনানি গতানি যিহূদীযাস্ত্ৱাং পাষাণৈ র্হন্তুম্ উদ্যতাস্তথাপি কিং পুনস্তত্র যাস্যসি? ");
INSERT INTO sanben_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","যীশুঃ প্রত্যৱদৎ, একস্মিন্ দিনে কিং দ্ৱাদশঘটিকা ন ভৱন্তি? কোপি দিৱা গচ্ছন্ ন স্খলতি যতঃ স এতজ্জগতো দীপ্তিং প্রাপ্নোতি| ");
INSERT INTO sanben_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","কিন্তু রাত্রৌ গচ্ছন্ স্খলতি যতো হেতোস্তত্র দীপ্তি র্নাস্তি| ");
INSERT INTO sanben_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ইমাং কথাং কথযিৎৱা স তানৱদদ্, অস্মাকং বন্ধুঃ ইলিযাসর্ নিদ্রিতোভূদ্ ইদানীং তং নিদ্রাতো জাগরযিতুং গচ্ছামি| ");
INSERT INTO sanben_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","যীশু র্মৃতৌ কথামিমাং কথিতৱান্ কিন্তু ৱিশ্রামার্থং নিদ্রাযাং কথিতৱান্ ইতি জ্ঞাৎৱা শিষ্যা অকথযন্, ");
INSERT INTO sanben_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","হে গুরো স যদি নিদ্রাতি তর্হি ভদ্রমেৱ| ");
INSERT INTO sanben_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","তদা যীশুঃ স্পষ্টং তান্ ৱ্যাহরৎ, ইলিযাসর্ অম্রিযত; ");
INSERT INTO sanben_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","কিন্তু যূযং যথা প্রতীথ তদর্থমহং তত্র ন স্থিতৱান্ ইত্যস্মাদ্ যুষ্মন্নিমিত্তম্ আহ্লাদিতোহং, তথাপি তস্য সমীপে যাম| ");
INSERT INTO sanben_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","তদা থোমা যং দিদুমং ৱদন্তি স সঙ্গিনঃ শিষ্যান্ অৱদদ্ ৱযমপি গৎৱা তেন সার্দ্ধং ম্রিযামহৈ| ");
INSERT INTO sanben_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","যীশুস্তত্রোপস্থায ইলিযাসরঃ শ্মশানে স্থাপনাৎ চৎৱারি দিনানি গতানীতি ৱার্ত্তাং শ্রুতৱান্| ");
INSERT INTO sanben_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","ৱৈথনীযা যিরূশালমঃ সমীপস্থা ক্রোশৈকমাত্রান্তরিতা; ");
INSERT INTO sanben_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","তস্মাদ্ বহৱো যিহূদীযা মর্থাং মরিযমঞ্চ ভ্যাতৃশোকাপন্নাং সান্ত্ৱযিতুং তযোঃ সমীপম্ আগচ্ছন্| ");
INSERT INTO sanben_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","মর্থা যীশোরাগমনৱার্তাং শ্রুৎৱৈৱ তং সাক্ষাদ্ অকরোৎ কিন্তু মরিযম্ গেহ উপৱিশ্য স্থিতা| ");
INSERT INTO sanben_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","তদা মর্থা যীশুমৱাদৎ, হে প্রভো যদি ভৱান্ অত্রাস্থাস্যৎ তর্হি মম ভ্রাতা নামরিষ্যৎ| ");
INSERT INTO sanben_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","কিন্ত্ৱিদানীমপি যদ্ ঈশ্ৱরে প্রার্থযিষ্যতে ঈশ্ৱরস্তদ্ দাস্যতীতি জানেঽহং| ");
INSERT INTO sanben_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","যীশুরৱাদীৎ তৱ ভ্রাতা সমুত্থাস্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","মর্থা ৱ্যাহরৎ শেষদিৱসে স উত্থানসমযে প্রোত্থাস্যতীতি জানেঽহং| ");
INSERT INTO sanben_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","তদা যীশুঃ কথিতৱান্ অহমেৱ উত্থাপযিতা জীৱযিতা চ যঃ কশ্চন মযি ৱিশ্ৱসিতি স মৃৎৱাপি জীৱিষ্যতি; ");
INSERT INTO sanben_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","যঃ কশ্চন চ জীৱন্ মযি ৱিশ্ৱসিতি স কদাপি ন মরিষ্যতি, অস্যাং কথাযাং কিং ৱিশ্ৱসিষি? ");
INSERT INTO sanben_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","সাৱদৎ প্রভো যস্যাৱতরণাপেক্ষাস্তি ভৱান্ সএৱাভিষিক্ত্ত ঈশ্ৱরপুত্র ইতি ৱিশ্ৱসিমি| ");
INSERT INTO sanben_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ইতি কথাং কথযিৎৱা সা গৎৱা স্ৱাং ভগিনীং মরিযমং গুপ্তমাহূয ৱ্যাহরৎ গুরুরুপতিষ্ঠতি ৎৱামাহূযতি চ| ");
INSERT INTO sanben_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","কথামিমাং শ্রুৎৱা সা তূর্ণম্ উত্থায তস্য সমীপম্ অগচ্ছৎ| ");
INSERT INTO sanben_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","যীশু র্গ্রামমধ্যং ন প্রৱিশ্য যত্র মর্থা তং সাক্ষাদ্ অকরোৎ তত্র স্থিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","যে যিহূদীযা মরিযমা সাকং গৃহে তিষ্ঠন্তস্তাম্ অসান্ত্ৱযন তে তাং ক্ষিপ্রম্ উত্থায গচ্ছন্তিং ৱিলোক্য ৱ্যাহরন্, স শ্মশানে রোদিতুং যাতি, ইত্যুক্ত্ৱা তে তস্যাঃ পশ্চাদ্ অগচ্ছন্| ");
INSERT INTO sanben_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","যত্র যীশুরতিষ্ঠৎ তত্র মরিযম্ উপস্থায তং দৃষ্ট্ৱা তস্য চরণযোঃ পতিৎৱা ৱ্যাহরৎ হে প্রভো যদি ভৱান্ অত্রাস্থাস্যৎ তর্হি মম ভ্রাতা নামরিষ্যৎ| ");
INSERT INTO sanben_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","যীশুস্তাং তস্যাঃ সঙ্গিনো যিহূদীযাংশ্চ রুদতো ৱিলোক্য শোকার্ত্তঃ সন্ দীর্ঘং নিশ্ৱস্য কথিতৱান্ তং কুত্রাস্থাপযত? ");
INSERT INTO sanben_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","তে ৱ্যাহরন্, হে প্রভো ভৱান্ আগত্য পশ্যতু| ");
INSERT INTO sanben_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","যীশুনা ক্রন্দিতং| ");
INSERT INTO sanben_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","অতএৱ যিহূদীযা অৱদন্, পশ্যতাযং তস্মিন্ কিদৃগ্ অপ্রিযত| ");
INSERT INTO sanben_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","তেষাং কেচিদ্ অৱদন্ যোন্ধায চক্ষুষী দত্তৱান্ স কিম্ অস্য মৃত্যুং নিৱারযিতুং নাশক্নোৎ? ");
INSERT INTO sanben_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","ততো যীশুঃ পুনরন্তর্দীর্ঘং নিশ্ৱস্য শ্মশানান্তিকম্ অগচ্ছৎ| তৎ শ্মশানম্ একং গহ্ৱরং তন্মুখে পাষাণ এক আসীৎ| ");
INSERT INTO sanben_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","তদা যীশুরৱদদ্ এনং পাষাণম্ অপসারযত, ততঃ প্রমীতস্য ভগিনী মর্থাৱদৎ প্রভো, অধুনা তত্র দুর্গন্ধো জাতঃ, যতোদ্য চৎৱারি দিনানি শ্মশানে স তিষ্ঠতি| ");
INSERT INTO sanben_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","তদা যীশুরৱাদীৎ, যদি ৱিশ্ৱসিষি তর্হীশ্ৱরস্য মহিমপ্রকাশং দ্রক্ষ্যসি কথামিমাং কিং তুভ্যং নাকথযং? ");
INSERT INTO sanben_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","তদা মৃতস্য শ্মশানাৎ পাষাণোঽপসারিতে যীশুরূর্দ্ৱ্ৱং পশ্যন্ অকথযৎ, হে পিত র্মম নেৱেসনম্ অশৃণোঃ কারণাদস্মাৎ ৎৱাং ধন্যং ৱদামি| ");
INSERT INTO sanben_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ৎৱং সততং শৃণোষি তদপ্যহং জানামি, কিন্তু ৎৱং মাং যৎ প্রৈরযস্তদ্ যথাস্মিন্ স্থানে স্থিতা লোকা ৱিশ্ৱসন্তি তদর্থম্ ইদং ৱাক্যং ৱদামি| ");
INSERT INTO sanben_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ইমাং কথাং কথযিৎৱা স প্রোচ্চৈরাহ্ৱযৎ, হে ইলিযাসর্ বহিরাগচ্ছ| ");
INSERT INTO sanben_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","ততঃ স প্রমীতঃ শ্মশানৱস্ত্রৈ র্বদ্ধহস্তপাদো গাত্রমার্জনৱাসসা বদ্ধমুখশ্চ বহিরাগচ্ছৎ| যীশুরুদিতৱান্ বন্ধনানি মোচযিৎৱা ত্যজতৈনং| ");
INSERT INTO sanben_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","মরিযমঃ সমীপম্ আগতা যে যিহূদীযলোকাস্তদা যীশোরেতৎ কর্ম্মাপশ্যন্ তেষাং বহৱো ৱ্যশ্ৱসন্, ");
INSERT INTO sanben_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","কিন্তু কেচিদন্যে ফিরূশিনাং সমীপং গৎৱা যীশোরেতস্য কর্ম্মণো ৱার্ত্তাম্ অৱদন্| ");
INSERT INTO sanben_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","ততঃ পরং প্রধানযাজকাঃ ফিরূশিনাশ্চ সভাং কৃৎৱা ৱ্যাহরন্ ৱযং কিং কুর্ম্মঃ? এষ মানৱো বহূন্যাশ্চর্য্যকর্ম্মাণি করোতি| ");
INSERT INTO sanben_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","যদীদৃশং কর্ম্ম কর্ত্তুং ন ৱারযামস্তর্হি সর্ৱ্ৱে লোকাস্তস্মিন্ ৱিশ্ৱসিষ্যন্তি রোমিলোকাশ্চাগত্যাস্মাকম্ অনযা রাজধান্যা সার্দ্ধং রাজ্যম্ আছেৎস্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","তদা তেষাং কিযফানামা যস্তস্মিন্ ৱৎসরে মহাযাজকপদে ন্যযুজ্যত স প্রত্যৱদদ্ যূযং কিমপি ন জানীথ; ");
INSERT INTO sanben_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","সমগ্রদেশস্য ৱিনাশতোপি সর্ৱ্ৱলোকার্থম্ একস্য জনস্য মরণম্ অস্মাকং মঙ্গলহেতুকম্ এতস্য ৱিৱেচনামপি ন কুরুথ| ");
INSERT INTO sanben_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","এতাং কথাং স নিজবুদ্ধ্যা ৱ্যাহরদ্ ইতি ন, ");
INSERT INTO sanben_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","কিন্তু যীশূস্তদ্দেশীযানাং কারণাৎ প্রাণান্ ত্যক্ষ্যতি, দিশি দিশি ৱিকীর্ণান্ ঈশ্ৱরস্য সন্তানান্ সংগৃহ্যৈকজাতিং করিষ্যতি চ, তস্মিন্ ৱৎসরে কিযফা মহাযাজকৎৱপদে নিযুক্তঃ সন্ ইদং ভৱিষ্যদ্ৱাক্যং কথিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","তদ্দিনমারভ্য তে কথং তং হন্তুং শক্নুৱন্তীতি মন্ত্রণাং কর্ত্তুং প্রারেভিরে| ");
INSERT INTO sanben_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","অতএৱ যিহূদীযানাং মধ্যে যীশুঃ সপ্রকাশং গমনাগমনে অকৃৎৱা তস্মাদ্ গৎৱা প্রান্তরস্য সমীপস্থাযিপ্রদেশস্যেফ্রাযিম্ নাম্নি নগরে শিষ্যৈঃ সাকং কালং যাপযিতুং প্রারেভে| ");
INSERT INTO sanben_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","অনন্তরং যিহূদীযানাং নিস্তারোৎসৱে নিকটৱর্ত্তিনি সতি তদুৎসৱাৎ পূর্ৱ্ৱং স্ৱান্ শুচীন্ কর্ত্তুং বহৱো জনা গ্রামেভ্যো যিরূশালম্ নগরম্ আগচ্ছন্, ");
INSERT INTO sanben_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","যীশোরন্ৱেষণং কৃৎৱা মন্দিরে দণ্ডাযমানাঃ সন্তঃ পরস্পরং ৱ্যাহরন্, যুষ্মাকং কীদৃশো বোধো জাযতে? স কিম্ উৎসৱেঽস্মিন্ অত্রাগমিষ্যতি? ");
INSERT INTO sanben_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","স চ কুত্রাস্তি যদ্যেতৎ কশ্চিদ্ ৱেত্তি তর্হি দর্শযতু প্রধানযাজকাঃ ফিরূশিনশ্চ তং ধর্ত্তুং পূর্ৱ্ৱম্ ইমাম্ আজ্ঞাং প্রাচারযন্| ");
INSERT INTO sanben_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","নিস্তারোৎসৱাৎ পূর্ৱ্ৱং দিনষট্কে স্থিতে যীশু র্যং প্রমীতম্ ইলিযাসরং শ্মশানাদ্ উদস্থাপরৎ তস্য নিৱাসস্থানং বৈথনিযাগ্রামম্ আগচ্ছৎ| ");
INSERT INTO sanben_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","তত্র তদর্থং রজন্যাং ভোজ্যে কৃতে মর্থা পর্য্যৱেষযদ্ ইলিযাসর্ চ তস্য সঙ্গিভিঃ সার্দ্ধং ভোজনাসন উপাৱিশৎ| ");
INSERT INTO sanben_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","তদা মরিযম্ অর্দ্ধসেটকং বহুমূল্যং জটামাংসীযং তৈলম্ আনীয যীশোশ্চরণযো র্মর্দ্দযিৎৱা নিজকেশ র্মার্ষ্টুম্ আরভত; তদা তৈলস্য পরিমলেন গৃহম্ আমোদিতম্ অভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","যঃ শিমোনঃ পুত্র রিষ্করিযোতীযো যিহূদানামা যীশুং পরকরেষু সমর্পযিষ্যতি স শিষ্যস্তদা কথিতৱান্, ");
INSERT INTO sanben_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","এতত্তৈলং ত্রিভিঃ শতৈ র্মুদ্রাপদৈ র্ৱিক্রীতং সদ্ দরিদ্রেভ্যঃ কুতো নাদীযত? ");
INSERT INTO sanben_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","স দরিদ্রলোকার্থম্ অচিন্তযদ্ ইতি ন, কিন্তু স চৌর এৱং তন্নিকটে মুদ্রাসম্পুটকস্থিত্যা তন্মধ্যে যদতিষ্ঠৎ তদপাহরৎ তস্মাৎ কারণাদ্ ইমাং কথামকথযৎ| ");
INSERT INTO sanben_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","তদা যীশুরকথযদ্ এনাং মা ৱারয সা মম শ্মশানস্থাপনদিনার্থং তদরক্ষযৎ| ");
INSERT INTO sanben_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","দরিদ্রা যুষ্মাকং সন্নিধৌ সর্ৱ্ৱদা তিষ্ঠন্তি কিন্ত্ৱহং সর্ৱ্ৱদা যুষ্মাকং সন্নিধৌ ন তিষ্ঠামি| ");
INSERT INTO sanben_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","ততঃ পরং যীশুস্তত্রাস্তীতি ৱার্ত্তাং শ্রুৎৱা বহৱো যিহূদীযাস্তং শ্মশানাদুত্থাপিতম্ ইলিযাসরঞ্চ দ্রষ্টুং তৎ স্থানম্ আগচ্ছন| ");
INSERT INTO sanben_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","তদা প্রধানযাজকাস্তম্ ইলিযাসরমপি সংহর্ত্তুম্ অমন্ত্রযন্ ; ");
INSERT INTO sanben_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","যতস্তেন বহৱো যিহূদীযা গৎৱা যীশৌ ৱ্যশ্ৱসন্| ");
INSERT INTO sanben_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","অনন্তরং যীশু র্যিরূশালম্ নগরম্ আগচ্ছতীতি ৱার্ত্তাং শ্রুৎৱা পরেঽহনি উৎসৱাগতা বহৱো লোকাঃ ");
INSERT INTO sanben_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","খর্জ্জূরপত্রাদ্যানীয তং সাক্ষাৎ কর্ত্তুং বহিরাগত্য জয জযেতি ৱাচং প্রোচ্চৈ র্ৱক্তুম্ আরভন্ত, ইস্রাযেলো যো রাজা পরমেশ্ৱরস্য নাম্নাগচ্ছতি স ধন্যঃ| ");
INSERT INTO sanben_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","তদা \"হে সিযোনঃ কন্যে মা ভৈষীঃ পশ্যাযং তৱ রাজা গর্দ্দভশাৱকম্ আরুহ্যাগচ্ছতি\" ");
INSERT INTO sanben_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","ইতি শাস্ত্রীযৱচনানুসারেণ যীশুরেকং যুৱগর্দ্দভং প্রাপ্য তদুপর্য্যারোহৎ| ");
INSERT INTO sanben_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","অস্যাঃ ঘটনাযাস্তাৎপর্য্যং শিষ্যাঃ প্রথমং নাবুধ্যন্ত, কিন্তু যীশৌ মহিমানং প্রাপ্তে সতি ৱাক্যমিদং তস্মিন অকথ্যত লোকাশ্চ তম্প্রতীত্থম্ অকুর্ৱ্ৱন্ ইতি তে স্মৃতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","স ইলিযাসরং শ্মশানাদ্ আগন্তুম্ আহ্ৱতৱান্ শ্মশানাঞ্চ উদস্থাপযদ্ যে যে লোকাস্তৎকর্ম্য সাক্ষাদ্ অপশ্যন্ তে প্রমাণং দাতুম্ আরভন্ত| ");
INSERT INTO sanben_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","স এতাদৃশম্ অদ্ভুতং কর্ম্মকরোৎ তস্য জনশ্রুতে র্লোকাস্তং সাক্ষাৎ কর্ত্তুম্ আগচ্ছন্| ");
INSERT INTO sanben_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","ততঃ ফিরূশিনঃ পরস্পরং ৱক্তুম্ আরভন্ত যুষ্মাকং সর্ৱ্ৱাশ্চেষ্টা ৱৃথা জাতাঃ, ইতি কিং যূযং ন বুধ্যধ্ৱে? পশ্যত সর্ৱ্ৱে লোকাস্তস্য পশ্চাদ্ৱর্ত্তিনোভৱন্| ");
INSERT INTO sanben_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ভজনং কর্ত্তুম্ উৎসৱাগতানাং লোকানাং কতিপযা জনা অন্যদেশীযা আসন্ , ");
INSERT INTO sanben_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","তে গালীলীযবৈৎসৈদানিৱাসিনঃ ফিলিপস্য সমীপম্ আগত্য ৱ্যাহরন্ হে মহেচ্ছ ৱযং যীশুং দ্রষ্টুম্ ইচ্ছামঃ| ");
INSERT INTO sanben_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ততঃ ফিলিপো গৎৱা আন্দ্রিযম্ অৱদৎ পশ্চাদ্ আন্দ্রিযফিলিপৌ যীশৱে ৱার্ত্তাম্ অকথযতাং| ");
INSERT INTO sanben_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","তদা যীশুঃ প্রত্যুদিতৱান্ মানৱসুতস্য মহিমপ্রাপ্তিসময উপস্থিতঃ| ");
INSERT INTO sanben_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","অহং যুষ্মানতিযথার্থং ৱদামি, ধান্যবীজং মৃত্তিকাযাং পতিৎৱা যদি ন মৃযতে তর্হ্যেকাকী তিষ্ঠতি কিন্তু যদি মৃযতে তর্হি বহুগুণং ফলং ফলতি| ");
INSERT INTO sanben_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","যো জনেा নিজপ্রাণান্ প্রিযান্ জানাতি স তান্ হারযিষ্যতি কিন্তু যেा জন ইহলোকে নিজপ্রাণান্ অপ্রিযান্ জানাতি সেाনন্তাযুঃ প্রাপ্তুং তান্ রক্ষিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","কশ্চিদ্ যদি মম সেৱকো ভৱিতুং ৱাঞ্ছতি তর্হি স মম পশ্চাদ্গামী ভৱতু, তস্মাদ্ অহং যত্র তিষ্ঠামি মম সেৱকেाপি তত্র স্থাস্যতি; যো জনো মাং সেৱতে মম পিতাপি তং সম্মংস্যতে| ");
INSERT INTO sanben_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","সাম্প্রতং মম প্রাণা ৱ্যাকুলা ভৱন্তি, তস্মাদ্ হে পিতর এতস্মাৎ সমযান্ মাং রক্ষ, ইত্যহং কিং প্রার্থযিষ্যে? কিন্ত্ৱহম্ এতৎসমযার্থম্ অৱতীর্ণৱান্| ");
INSERT INTO sanben_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","হে পিত: স্ৱনাম্নো মহিমানং প্রকাশয; তনৈৱ স্ৱনাম্নো মহিমানম্ অহং প্রাকাশযং পুনরপি প্রকাশযিষ্যামি, এষা গগণীযা ৱাণী তস্মিন্ সমযেঽজাযত| ");
INSERT INTO sanben_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","তচ্শ্রুৎৱা সমীপস্থলোকানাং কেচিদ্ অৱদন্ মেঘোঽগর্জীৎ, কেচিদ্ অৱদন্ স্ৱর্গীযদূতোঽনেন সহ কথামচকথৎ| ");
INSERT INTO sanben_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","তদা যীশুঃ প্রত্যৱাদীৎ, মদর্থং শব্দোযং নাভূৎ যুষ্মদর্থমেৱাভূৎ| ");
INSERT INTO sanben_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","অধুনা জগতোস্য ৱিচার: সম্পৎস্যতে, অধুনাস্য জগত: পতী রাজ্যাৎ চ্যোষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","যদ্যঈ পৃথিৱ্যা ঊর্দ্ৱ্ৱে প্রোত্থাপিতোস্মি তর্হি সর্ৱ্ৱান্ মানৱান্ স্ৱসমীপম্ আকর্ষিষ্যামি| ");
INSERT INTO sanben_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","কথং তস্য মৃতি র্ভৱিষ্যতি, এতদ্ বোধযিতুং স ইমাং কথাম্ অকথযৎ| ");
INSERT INTO sanben_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","তদা লোকা অকথযন্ সোভিষিক্তঃ সর্ৱ্ৱদা তিষ্ঠতীতি ৱ্যৱস্থাগ্রন্থে শ্রুতম্ অস্মাভিঃ, তর্হি মনুষ্যপুত্রঃ প্রোত্থাপিতো ভৱিষ্যতীতি ৱাক্যং কথং ৱদসি? মনুষ্যপুত্রোযং কঃ? ");
INSERT INTO sanben_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","তদা যীশুরকথাযদ্ যুষ্মাভিঃ সার্দ্ধম্ অল্পদিনানি জ্যোতিরাস্তে, যথা যুষ্মান্ অন্ধকারো নাচ্ছাদযতি তদর্থং যাৱৎকালং যুষ্মাভিঃ সার্দ্ধং জ্যোতিস্তিষ্ঠতি তাৱৎকালং গচ্ছত; যো জনোঽন্ধকারে গচ্ছতি স কুত্র যাতীতি ন জানাতি| ");
INSERT INTO sanben_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","অতএৱ যাৱৎকালং যুষ্মাকং নিকটে জ্যোতিরাস্তে তাৱৎকালং জ্যোতীরূপসন্তানা ভৱিতুং জ্যোতিষি ৱিশ্ৱসিত; ইমাং কথাং কথযিৎৱা যীশুঃ প্রস্থায তেভ্যঃ স্ৱং গুপ্তৱান্| ");
INSERT INTO sanben_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","যদ্যপি যীশুস্তেষাং সমক্ষম্ এতাৱদাশ্চর্য্যকর্ম্মাণি কৃতৱান্ তথাপি তে তস্মিন্ ন ৱ্যশ্ৱসন্| ");
INSERT INTO sanben_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","অতএৱ কঃ প্রত্যেতি সুসংৱাদং পরেশাস্মৎ প্রচারিতং? প্রকাশতে পরেশস্য হস্তঃ কস্য চ সন্নিধৌ? যিশযিযভৱিষ্যদ্ৱাদিনা যদেতদ্ ৱাক্যমুক্তং তৎ সফলম্ অভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","তে প্রত্যেতুং নাশন্কুৱন্ তস্মিন্ যিশযিযভৱিষ্যদ্ৱাদি পুনরৱাদীদ্, ");
INSERT INTO sanben_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","যদা, \"তে নযনৈ র্ন পশ্যন্তি বুদ্ধিভিশ্চ ন বুধ্যন্তে তৈ র্মনঃসু পরিৱর্ত্তিতেষু চ তানহং যথা স্ৱস্থান্ ন করোমি তথা স তেষাং লোচনান্যন্ধানি কৃৎৱা তেষামন্তঃকরণানি গাঢানি করিষ্যতি| \" ");
INSERT INTO sanben_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","যিশযিযো যদা যীশো র্মহিমানং ৱিলোক্য তস্মিন্ কথামকথযৎ তদা ভৱিষ্যদ্ৱাক্যম্ ঈদৃশং প্রকাশযৎ| ");
INSERT INTO sanben_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","তথাপ্যধিপতিনাং বহৱস্তস্মিন্ প্রত্যাযন্| কিন্তু ফিরূশিনস্তান্ ভজনগৃহাদ্ দূরীকুর্ৱ্ৱন্তীতি ভযাৎ তে তং ন স্ৱীকৃতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","যত ঈশ্ৱরস্য প্রশংসাতো মানৱানাং প্রশংসাযাং তেঽপ্রিযন্ত| ");
INSERT INTO sanben_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","তদা যীশুরুচ্চৈঃকারম্ অকথযদ্ যো জনো মযি ৱিশ্ৱসিতি স কেৱলে মযি ৱিশ্ৱসিতীতি ন, স মৎপ্রেরকেঽপি ৱিশ্ৱসিতি| ");
INSERT INTO sanben_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","যো জনো মাং পশ্যতি স মৎপ্রেরকমপি পশ্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","যো জনো মাং প্রত্যেতি স যথান্ধকারে ন তিষ্ঠতি তদর্থম্ অহং জ্যোতিঃস্ৱরূপো ভূৎৱা জগত্যস্মিন্ অৱতীর্ণৱান্| ");
INSERT INTO sanben_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","মম কথাং শ্রুৎৱা যদি কশ্চিন্ ন ৱিশ্ৱসিতি তর্হি তমহং দোষিণং ন করোমি, যতো হেতো র্জগতো জনানাং দোষান্ নিশ্চিতান্ কর্ত্তুং নাগত্য তান্ পরিচাতুম্ আগতোস্মি| ");
INSERT INTO sanben_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","যঃ কশ্চিন্ মাং ন শ্রদ্ধায মম কথং ন গৃহ্লাতি, অন্যস্তং দোষিণং করিষ্যতি ৱস্তুতস্তু যাং কথামহম্ অচকথং সা কথা চরমেঽন্হি তং দোষিণং করিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","যতো হেতোরহং স্ৱতঃ কিমপি ন কথযামি, কিং কিং মযা কথযিতৱ্যং কিং সমুপদেষ্টৱ্যঞ্চ ইতি মৎপ্রেরযিতা পিতা মামাজ্ঞাপযৎ| ");
INSERT INTO sanben_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","তস্য সাজ্ঞা অনন্তাযুরিত্যহং জানামি, অতএৱাহং যৎ কথযামি তৎ পিতা যথাজ্ঞাপযৎ তথৈৱ কথযাম্যহম্| ");
INSERT INTO sanben_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","নিস্তারোৎসৱস্য কিঞ্চিৎকালাৎ পূর্ৱ্ৱং পৃথিৱ্যাঃ পিতুঃ সমীপগমনস্য সমযঃ সন্নিকর্ষোভূদ্ ইতি জ্ঞাৎৱা যীশুরাপ্রথমাদ্ যেষু জগৎপ্রৱাসিষ্ৱাত্মীযলোকেষ প্রেম করোতি স্ম তেষু শেষং যাৱৎ প্রেম কৃতৱান্| ");
INSERT INTO sanben_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","পিতা তস্য হস্তে সর্ৱ্ৱং সমর্পিতৱান্ স্ৱযম্ ঈশ্ৱরস্য সমীপাদ্ আগচ্ছদ্ ঈশ্ৱরস্য সমীপং যাস্যতি চ, সর্ৱ্ৱাণ্যেতানি জ্ঞাৎৱা রজন্যাং ভোজনে সম্পূর্ণে সতি, ");
INSERT INTO sanben_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","যদা শৈতান্ তং পরহস্তেষু সমর্পযিতুং শিমোনঃ পুত্রস্য ঈষ্কারিযোতিযস্য যিহূদা অন্তঃকরণে কুপ্রৱৃত্তিং সমার্পযৎ, ");
INSERT INTO sanben_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","তদা যীশু র্ভোজনাসনাদ্ উত্থায গাত্রৱস্ত্রং মোচযিৎৱা গাত্রমার্জনৱস্ত্রং গৃহীৎৱা তেন স্ৱকটিম্ অবধ্নাৎ, ");
INSERT INTO sanben_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","পশ্চাদ্ একপাত্রে জলম্ অভিষিচ্য শিষ্যাণাং পাদান্ প্রক্ষাল্য তেন কটিবদ্ধগাত্রমার্জনৱাসসা মার্ষ্টুং প্রারভত| ");
INSERT INTO sanben_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ততঃ শিমোন্পিতরস্য সমীপমাগতে স উক্তৱান্ হে প্রভো ভৱান্ কিং মম পাদৌ প্রক্ষালযিষ্যতি? ");
INSERT INTO sanben_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","যীশুরুদিতৱান্ অহং যৎ করোমি তৎ সম্প্রতি ন জানাসি কিন্তু পশ্চাজ্ জ্ঞাস্যসি| ");
INSERT INTO sanben_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","ততঃ পিতরঃ কথিতৱান্ ভৱান্ কদাপি মম পাদৌ ন প্রক্ষালযিষ্যতি| যীশুরকথযদ্ যদি ৎৱাং ন প্রক্ষালযে তর্হি মযি তৱ কোপ্যংশো নাস্তি| ");
INSERT INTO sanben_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","তদা শিমোন্পিতরঃ কথিতৱান্ হে প্রভো তর্হি কেৱলপাদৌ ন, মম হস্তৌ শিরশ্চ প্রক্ষালযতু| ");
INSERT INTO sanben_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","ততো যীশুরৱদদ্ যো জনো ধৌতস্তস্য সর্ৱ্ৱাঙ্গপরিষ্কৃতৎৱাৎ পাদৌ ৱিনান্যাঙ্গস্য প্রক্ষালনাপেক্ষা নাস্তি| যূযং পরিষ্কৃতা ইতি সত্যং কিন্তু ন সর্ৱ্ৱে, ");
INSERT INTO sanben_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","যতো যো জনস্তং পরকরেষু সমর্পযিষ্যতি তং স জ্ঞাতৱান; অতএৱ যূযং সর্ৱ্ৱে ন পরিষ্কৃতা ইমাং কথাং কথিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ইত্থং যীশুস্তেষাং পাদান্ প্রক্ষাল্য ৱস্ত্রং পরিধাযাসনে সমুপৱিশ্য কথিতৱান্ অহং যুষ্মান্ প্রতি কিং কর্ম্মাকার্ষং জানীথ? ");
INSERT INTO sanben_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","যূযং মাং গুরুং প্রভুঞ্চ ৱদথ তৎ সত্যমেৱ ৱদথ যতোহং সএৱ ভৱামি| ");
INSERT INTO sanben_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","যদ্যহং প্রভু র্গুরুশ্চ সন্ যুষ্মাকং পাদান্ প্রক্ষালিতৱান্ তর্হি যুষ্মাকমপি পরস্পরং পাদপ্রক্ষালনম্ উচিতম্| ");
INSERT INTO sanben_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","অহং যুষ্মান্ প্রতি যথা ৱ্যৱাহরং যুষ্মান্ তথা ৱ্যৱহর্ত্তুম্ একং পন্থানং দর্শিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","অহং যুষ্মানতিযথার্থং ৱদামি, প্রভো র্দাসো ন মহান্ প্রেরকাচ্চ প্রেরিতো ন মহান্| ");
INSERT INTO sanben_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ইমাং কথাং ৱিদিৎৱা যদি তদনুসারতঃ কর্ম্মাণি কুরুথ তর্হি যূযং ধন্যা ভৱিষ্যথ| ");
INSERT INTO sanben_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","সর্ৱ্ৱেষু যুষ্মাসু কথামিমাং কথযামি ইতি ন, যে মম মনোনীতাস্তানহং জানামি, কিন্তু মম ভক্ষ্যাণি যো ভুঙ্ক্তে মৎপ্রাণপ্রাতিকূল্যতঃ| উত্থাপযতি পাদস্য মূলং স এষ মানৱঃ| যদেতদ্ ধর্ম্মপুস্তকস্য ৱচনং তদনুসারেণাৱশ্যং ঘটিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","অহং স জন ইত্যত্র যথা যুষ্মাকং ৱিশ্ৱাসো জাযতে তদর্থং এতাদৃশঘটনাৎ পূর্ৱ্ৱম্ অহমিদানীং যুষ্মভ্যমকথযম্| ");
INSERT INTO sanben_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","অহং যুষ্মানতীৱ যথার্থং ৱদামি, মযা প্রেরিতং জনং যো গৃহ্লাতি স মামেৱ গৃহ্লাতি যশ্চ মাং গৃহ্লাতি স মৎপ্রেরকং গৃহ্লাতি| ");
INSERT INTO sanben_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","এতাং কথাং কথযিৎৱা যীশু র্দুঃখী সন্ প্রমাণং দত্ত্ৱা কথিতৱান্ অহং যুষ্মানতিযথার্থং ৱদামি যুষ্মাকম্ একো জনো মাং পরকরেষু সমর্পযিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","ততঃ স কমুদ্দিশ্য কথামেতাং কথিতৱান্ ইত্যত্র সন্দিগ্ধাঃ শিষ্যাঃ পরস্পরং মুখমালোকযিতুং প্রারভন্ত| ");
INSERT INTO sanben_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","তস্মিন্ সমযে যীশু র্যস্মিন্ অপ্রীযত স শিষ্যস্তস্য ৱক্ষঃস্থলম্ অৱালম্বত| ");
INSERT INTO sanben_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","শিমোন্পিতরস্তং সঙ্কেতেনাৱদৎ, অযং কমুদ্দিশ্য কথামেতাম্ কথযতীতি পৃচ্ছ| ");
INSERT INTO sanben_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","তদা স যীশো র্ৱক্ষঃস্থলম্ অৱলম্ব্য পৃষ্ঠৱান্, হে প্রভো স জনঃ কঃ? ");
INSERT INTO sanben_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","ততো যীশুঃ প্রত্যৱদদ্ একখণ্ডং পূপং মজ্জযিৎৱা যস্মৈ দাস্যামি সএৱ সঃ; পশ্চাৎ পূপখণ্ডমেকং মজ্জযিৎৱা শিমোনঃ পুত্রায ঈষ্করিযোতীযায যিহূদৈ দত্তৱান্| ");
INSERT INTO sanben_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","তস্মিন্ দত্তে সতি শৈতান্ তমাশ্রযৎ; তদা যীশুস্তম্ অৱদৎ ৎৱং যৎ করিষ্যসি তৎ ক্ষিপ্রং কুরু| ");
INSERT INTO sanben_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","কিন্তু স যেনাশযেন তাং কথামকথাযৎ তম্ উপৱিষ্টলোকানাং কোপি নাবুধ্যত; ");
INSERT INTO sanben_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","কিন্তু যিহূদাঃ সমীপে মুদ্রাসম্পুটকস্থিতেঃ কেচিদ্ ইত্থম্ অবুধ্যন্ত পার্ৱ্ৱণাসাদনার্থং কিমপি দ্রৱ্যং ক্রেতুং ৱা দরিদ্রেভ্যঃ কিঞ্চিদ্ ৱিতরিতুং কথিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","তদা পূপখণ্ডগ্রহণাৎ পরং স তূর্ণং বহিরগচ্ছৎ; রাত্রিশ্চ সমুপস্যিতা| ");
INSERT INTO sanben_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","যিহূদে বহির্গতে যীশুরকথযদ্ ইদানীং মানৱসুতস্য মহিমা প্রকাশতে তেনেশ্ৱরস্যাপি মহিমা প্রকাশতে| ");
INSERT INTO sanben_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","যদি তেনেশ্ৱরস্য মহিমা প্রকাশতে তর্হীশ্ৱরোপি স্ৱেন তস্য মহিমানং প্রকাশযিষ্যতি তূর্ণমেৱ প্রকাশযিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","হে ৱৎসা অহং যুষ্মাভিঃ সার্দ্ধং কিঞ্চিৎকালমাত্রম্ আসে, ততঃ পরং মাং মৃগযিষ্যধ্ৱে কিন্ত্ৱহং যৎস্থানং যামি তৎস্থানং যূযং গন্তুং ন শক্ষ্যথ, যামিমাং কথাং যিহূদীযেভ্যঃ কথিতৱান্ তথাধুনা যুষ্মভ্যমপি কথযামি| ");
INSERT INTO sanben_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","যূযং পরস্পরং প্রীযধ্ৱম্ অহং যুষ্মাসু যথা প্রীযে যূযমপি পরস্পরম্ তথৈৱ প্রীযধ্ৱং, যুষ্মান্ ইমাং নৱীনাম্ আজ্ঞাম্ আদিশামি| ");
INSERT INTO sanben_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","তেনৈৱ যদি পরস্পরং প্রীযধ্ৱে তর্হি লক্ষণেনানেন যূযং মম শিষ্যা ইতি সর্ৱ্ৱে জ্ঞাতুং শক্ষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","শিমোনপিতরঃ পৃষ্ঠৱান্ হে প্রভো ভৱান্ কুত্র যাস্যতি? ততো যীশুঃ প্রত্যৱদৎ, অহং যৎস্থানং যামি তৎস্থানং সাম্প্রতং মম পশ্চাদ্ গন্তুং ন শক্নোষি কিন্তু পশ্চাদ্ গমিষ্যসি| ");
INSERT INTO sanben_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","তদা পিতরঃ প্রত্যুদিতৱান্, হে প্রভো সাম্প্রতং কুতো হেতোস্তৱ পশ্চাদ্ গন্তুং ন শক্নোমি? ৎৱদর্থং প্রাণান্ দাতুং শক্নোমি| ");
INSERT INTO sanben_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ততো যীশুঃ প্রত্যুক্তৱান্ মন্নিমিত্তং কিং প্রাণান্ দাতুং শক্নোষি? ৎৱামহং যথার্থং ৱদামি, কুক্কুটরৱণাৎ পূর্ৱ্ৱং ৎৱং ত্রি র্মাম্ অপহ্নোষ্যসে| ");
INSERT INTO sanben_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","মনোদুঃখিনো মা ভূত; ঈশ্ৱরে ৱিশ্ৱসিত মযি চ ৱিশ্ৱসিত| ");
INSERT INTO sanben_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","মম পিতু গৃহে বহূনি ৱাসস্থানি সন্তি নো চেৎ পূর্ৱ্ৱং যুষ্মান্ অজ্ঞাপযিষ্যং যুষ্মদর্থং স্থানং সজ্জযিতুং গচ্ছামি| ");
INSERT INTO sanben_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","যদি গৎৱাহং যুষ্মন্নিমিত্তং স্থানং সজ্জযামি তর্হি পনরাগত্য যুষ্মান্ স্ৱসমীপং নেষ্যামি, ততো যত্রাহং তিষ্ঠামি তত্র যূযমপি স্থাস্যথ| ");
INSERT INTO sanben_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","অহং যৎস্থানং ব্রজামি তৎস্থানং যূযং জানীথ তস্য পন্থানমপি জানীথ| ");
INSERT INTO sanben_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","তদা থোমা অৱদৎ, হে প্রভো ভৱান্ কুত্র যাতি তদ্ৱযং ন জানীমঃ, তর্হি কথং পন্থানং জ্ঞাতুং শক্নুমঃ? ");
INSERT INTO sanben_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","যীশুরকথযদ্ অহমেৱ সত্যজীৱনরূপপথো মযা ন গন্তা কোপি পিতুঃ সমীপং গন্তুং ন শক্নোতি| ");
INSERT INTO sanben_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","যদি মাম্ অজ্ঞাস্যত তর্হি মম পিতরমপ্যজ্ঞাস্যত কিন্ত্ৱধুনাতস্তং জানীথ পশ্যথ চ| ");
INSERT INTO sanben_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","তদা ফিলিপঃ কথিতৱান্, হে প্রভো পিতরং দর্শয তস্মাদস্মাকং যথেষ্টং ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","ততো যীশুঃ প্রত্যাৱাদীৎ, হে ফিলিপ যুষ্মাভিঃ সার্দ্ধম্ এতাৱদ্দিনানি স্থিতমপি মাং কিং ন প্রত্যভিজানাসি? যো জনো মাম্ অপশ্যৎ স পিতরমপ্যপশ্যৎ তর্হি পিতরম্ অস্মান্ দর্শযেতি কথাং কথং কথযসি? ");
INSERT INTO sanben_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","অহং পিতরি তিষ্ঠামি পিতা মযি তিষ্ঠতীতি কিং ৎৱং ন প্রত্যষি? অহং যদ্ৱাক্যং ৱদামি তৎ স্ৱতো ন ৱদামি কিন্তু যঃ পিতা মযি ৱিরাজতে স এৱ সর্ৱ্ৱকর্ম্মাণি করাতি| ");
INSERT INTO sanben_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","অতএৱ পিতর্য্যহং তিষ্ঠামি পিতা চ মযি তিষ্ঠতি মমাস্যাং কথাযাং প্রত্যযং কুরুত, নো চেৎ কর্ম্মহেতোঃ প্রত্যযং কুরুত| ");
INSERT INTO sanben_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","অহং যুষ্মানতিযথার্থং ৱদামি, যো জনো মযি ৱিশ্ৱসিতি সোহমিৱ কর্ম্মাণি করিষ্যতি ৱরং ততোপি মহাকর্ম্মাণি করিষ্যতি যতো হেতোরহং পিতুঃ সমীপং গচ্ছামি| ");
INSERT INTO sanben_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","যথা পুত্রেণ পিতু র্মহিমা প্রকাশতে তদর্থং মম নাম প্রোচ্য যৎ প্রার্থযিষ্যধ্ৱে তৎ সফলং করিষ্যামি| ");
INSERT INTO sanben_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","যদি মম নাম্না যৎ কিঞ্চিদ্ যাচধ্ৱে তর্হি তদহং সাধযিষ্যামি| ");
INSERT INTO sanben_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","যদি মযি প্রীযধ্ৱে তর্হি মমাজ্ঞাঃ সমাচরত| ");
INSERT INTO sanben_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ততো মযা পিতুঃ সমীপে প্রার্থিতে পিতা নিরন্তরং যুষ্মাভিঃ সার্দ্ধং স্থাতুম্ ইতরমেকং সহাযম্ অর্থাৎ সত্যমযম্ আত্মানং যুষ্মাকং নিকটং প্রেষযিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","এতজ্জগতো লোকাস্তং গ্রহীতুং ন শক্নুৱন্তি যতস্তে তং নাপশ্যন্ নাজনংশ্চ কিন্তু যূযং জানীথ যতো হেতোঃ স যুষ্মাকমন্ত র্নিৱসতি যুষ্মাকং মধ্যে স্থাস্যতি চ| ");
INSERT INTO sanben_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","অহং যুষ্মান্ অনাথান্ কৃৎৱা ন যাস্যামি পুনরপি যুষ্মাকং সমীপম্ আগমিষ্যামি| ");
INSERT INTO sanben_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","কিযৎকালরৎ পরম্ অস্য জগতো লোকা মাং পুন র্ন দ্রক্ষ্যন্তি কিন্তু যূযং দ্রক্ষ্যথ;অহং জীৱিষ্যামি তস্মাৎ কারণাদ্ যূযমপি জীৱিষ্যথ| ");
INSERT INTO sanben_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","পিতর্য্যহমস্মি মযি চ যূযং স্থ, তথাহং যুষ্মাস্ৱস্মি তদপি তদা জ্ঞাস্যথ| ");
INSERT INTO sanben_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","যো জনো মমাজ্ঞা গৃহীৎৱা তা আচরতি সএৱ মযি প্রীযতে; যো জনশ্চ মযি প্রীযতে সএৱ মম পিতুঃ প্রিযপাত্রং ভৱিষ্যতি, তথাহমপি তস্মিন্ প্রীৎৱা তস্মৈ স্ৱং প্রকাশযিষ্যামি| ");
INSERT INTO sanben_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","তদা ঈষ্করিযোতীযাদ্ অন্যো যিহূদাস্তমৱদৎ, হে প্রভো ভৱান্ জগতো লোকানাং সন্নিধৌ প্রকাশিতো ন ভূৎৱাস্মাকং সন্নিধৌ কুতঃ প্রকাশিতো ভৱিষ্যতি? ");
INSERT INTO sanben_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ততো যীশুঃ প্রত্যুদিতৱান্, যো জনো মযি প্রীযতে স মমাজ্ঞা অপি গৃহ্লাতি, তেন মম পিতাপি তস্মিন্ প্রেষ্যতে, আৱাঞ্চ তন্নিকটমাগত্য তেন সহ নিৱৎস্যাৱঃ| ");
INSERT INTO sanben_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","যো জনো মযি ন প্রীযতে স মম কথা অপি ন গৃহ্লাতি পুনশ্চ যামিমাং কথাং যূযং শৃণুথ সা কথা কেৱলস্য মম ন কিন্তু মম প্রেরকো যঃ পিতা তস্যাপি কথা| ");
INSERT INTO sanben_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","ইদানীং যুষ্মাকং নিকটে ৱিদ্যমানোহম্ এতাঃ সকলাঃ কথাঃ কথযামি| ");
INSERT INTO sanben_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","কিন্ত্ৱিতঃ পরং পিত্রা যঃ সহাযোঽর্থাৎ পৱিত্র আত্মা মম নাম্নি প্রেরযিষ্যতি স সর্ৱ্ৱং শিক্ষযিৎৱা মযোক্তাঃ সমস্তাঃ কথা যুষ্মান্ স্মারযিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","অহং যুষ্মাকং নিকটে শান্তিং স্থাপযিৎৱা যামি, নিজাং শান্তিং যুষ্মভ্যং দদামি, জগতো লোকা যথা দদাতি তথাহং ন দদামি; যুষ্মাকম্ অন্তঃকরণানি দুঃখিতানি ভীতানি চ ন ভৱন্তু| ");
INSERT INTO sanben_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","অহং গৎৱা পুনরপি যুষ্মাকং সমীপম্ আগমিষ্যামি মযোক্তং ৱাক্যমিদং যূযম্ অশ্রৌষ্ট; যদি ময্যপ্রেষ্যধ্ৱং তর্হ্যহং পিতুঃ সমীপং গচ্ছামি মমাস্যাং কথাযাং যূযম্ অহ্লাদিষ্যধ্ৱং যতো মম পিতা মত্তোপি মহান্| ");
INSERT INTO sanben_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","তস্যা ঘটনাযাঃ সমযে যথা যুষ্মাকং শ্রদ্ধা জাযতে তদর্থম্ অহং তস্যা ঘটনাযাঃ পূর্ৱ্ৱম্ ইদানীং যুষ্মান্ এতাং ৱার্ত্তাং ৱদামি| ");
INSERT INTO sanben_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ইতঃ পরং যুষ্মাভিঃ সহ মম বহৱ আলাপা ন ভৱিষ্যন্তি যতঃ কারণাদ্ এতস্য জগতঃ পতিরাগচ্ছতি কিন্তু মযা সহ তস্য কোপি সম্বন্ধো নাস্তি| ");
INSERT INTO sanben_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","অহং পিতরি প্রেম করোমি তথা পিতু র্ৱিধিৱৎ কর্ম্মাণি করোমীতি যেন জগতো লোকা জানন্তি তদর্থম্ উত্তিষ্ঠত ৱযং স্থানাদস্মাদ্ গচ্ছাম| ");
INSERT INTO sanben_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","অহং সত্যদ্রাক্ষালতাস্ৱরূপো মম পিতা তূদ্যানপরিচারকস্ৱরূপঞ্চ| ");
INSERT INTO sanben_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","মম যাসু শাখাসু ফলানি ন ভৱন্তি তাঃ স ছিনত্তি তথা ফলৱত্যঃ শাখা যথাধিকফলানি ফলন্তি তদর্থং তাঃ পরিষ্করোতি| ");
INSERT INTO sanben_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ইদানীং মযোক্তোপদেশেন যূযং পরিষ্কৃতাঃ| ");
INSERT INTO sanben_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","অতঃ কারণাৎ মযি তিষ্ঠত তেনাহমপি যুষ্মাসু তিষ্ঠামি, যতো হেতো র্দ্রাক্ষালতাযাম্ অসংলগ্না শাখা যথা ফলৱতী ভৱিতুং ন শক্নোতি তথা যূযমপি ময্যতিষ্ঠন্তঃ ফলৱন্তো ভৱিতুং ন শক্নুথ| ");
INSERT INTO sanben_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","অহং দ্রাক্ষালতাস্ৱরূপো যূযঞ্চ শাখাস্ৱরূপোঃ; যো জনো মযি তিষ্ঠতি যত্র চাহং তিষ্ঠামি, স প্রচূরফলৈঃ ফলৱান্ ভৱতি, কিন্তু মাং ৱিনা যূযং কিমপি কর্ত্তুং ন শক্নুথ| ");
INSERT INTO sanben_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","যঃ কশ্চিন্ মযি ন তিষ্ঠতি স শুষ্কশাখেৱ বহি র্নিক্ষিপ্যতে লোকাশ্চ তা আহৃত্য ৱহ্নৌ নিক্ষিপ্য দাহযন্তি| ");
INSERT INTO sanben_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","যদি যূযং মযি তিষ্ঠথ মম কথা চ যুষ্মাসু তিষ্ঠতি তর্হি যদ্ ৱাঞ্ছিৎৱা যাচিষ্যধ্ৱে যুষ্মাকং তদেৱ সফলং ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","যদি যূযং প্রচূরফলৱন্তো ভৱথ তর্হি তদ্ৱারা মম পিতু র্মহিমা প্রকাশিষ্যতে তথা যূযং মম শিষ্যা ইতি পরিক্ষাযিষ্যধ্ৱে| ");
INSERT INTO sanben_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","পিতা যথা মযি প্রীতৱান্ অহমপি যুষ্মাসু তথা প্রীতৱান্ অতো হেতো র্যূযং নিরন্তরং মম প্রেমপাত্রাণি ভূৎৱা তিষ্ঠত| ");
INSERT INTO sanben_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","অহং যথা পিতুরাজ্ঞা গৃহীৎৱা তস্য প্রেমভাজনং তিষ্ঠামি তথৈৱ যূযমপি যদি মমাজ্ঞা গুহ্লীথ তর্হি মম প্রেমভাজনানি স্থাস্যথ| ");
INSERT INTO sanben_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","যুষ্মন্নিমিত্তং মম য আহ্লাদঃ স যথা চিরং তিষ্ঠতি যুষ্মাকম্ আনন্দশ্চ যথা পূর্য্যতে তদর্থং যুষ্মভ্যম্ এতাঃ কথা অত্রকথম্| ");
INSERT INTO sanben_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","অহং যুষ্মাসু যথা প্রীযে যূযমপি পরস্পরং তথা প্রীযধ্ৱম্ এষা মমাজ্ঞা| ");
INSERT INTO sanben_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","মিত্রাণাং কারণাৎ স্ৱপ্রাণদানপর্য্যন্তং যৎ প্রেম তস্মান্ মহাপ্রেম কস্যাপি নাস্তি| ");
INSERT INTO sanben_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","অহং যদ্যদ্ আদিশামি তত্তদেৱ যদি যূযম্ আচরত তর্হি যূযমেৱ মম মিত্রাণি| ");
INSERT INTO sanben_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","অদ্যারভ্য যুষ্মান্ দাসান্ ন ৱদিষ্যামি যৎ প্রভু র্যৎ করোতি দাসস্তদ্ ন জানাতি; কিন্তু পিতুঃ সমীপে যদ্যদ্ অশৃণৱং তৎ সর্ৱ্ৱং যূষ্মান্ অজ্ঞাপযম্ তৎকারণাদ্ যুষ্মান্ মিত্রাণি প্রোক্তৱান্| ");
INSERT INTO sanben_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","যূযং মাং রোচিতৱন্ত ইতি ন, কিন্ত্ৱহমেৱ যুষ্মান্ রোচিতৱান্ যূযং গৎৱা যথা ফলান্যুৎপাদযথ তানি ফলানি চাক্ষযাণি ভৱন্তি, তদর্থং যুষ্মান্ ন্যজুনজং তস্মান্ মম নাম প্রোচ্য পিতরং যৎ কিঞ্চিদ্ যাচিষ্যধ্ৱে তদেৱ স যুষ্মভ্যং দাস্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","যূযং পরস্পরং প্রীযধ্ৱম্ অহম্ ইত্যাজ্ঞাপযামি| ");
INSERT INTO sanben_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","জগতো লোকৈ র্যুষ্মাসু ঋতীযিতেষু তে পূর্ৱ্ৱং মামেৱার্ত্তীযন্ত ইতি যূযং জানীথ| ");
INSERT INTO sanben_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","যদি যূযং জগতো লোকা অভৱিষ্যত তর্হি জগতো লোকা যুষ্মান্ আত্মীযান্ বুদ্ধ্ৱাপ্রেষ্যন্ত; কিন্তু যূযং জগতো লোকা ন ভৱথ, অহং যুষ্মান্ অস্মাজ্জগতোঽরোচযম্ এতস্মাৎ কারণাজ্জগতো লোকা যুষ্মান্ ঋতীযন্তে| ");
INSERT INTO sanben_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","দাসঃ প্রভো র্মহান্ ন ভৱতি মমৈতৎ পূর্ৱ্ৱীযং ৱাক্যং স্মরত; তে যদি মামেৱাতাডযন্ তর্হি যুষ্মানপি তাডযিষ্যন্তি, যদি মম ৱাক্যং গৃহ্লন্তি তর্হি যুষ্মাকমপি ৱাক্যং গ্রহীষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","কিন্তু তে মম নামকারণাদ্ যুষ্মান্ প্রতি তাদৃশং ৱ্যৱহরিষ্যন্তি যতো যো মাং প্রেরিতৱান্ তং তে ন জানন্তি| ");
INSERT INTO sanben_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","তেষাং সন্নিধিম্ আগত্য যদ্যহং নাকথযিষ্যং তর্হি তেষাং পাপং নাভৱিষ্যৎ কিন্ত্ৱধুনা তেষাং পাপমাচ্ছাদযিতুম্ উপাযো নাস্তি| ");
INSERT INTO sanben_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","যো জনো মাম্ ঋতীযতে স মম পিতরমপি ঋতীযতে| ");
INSERT INTO sanben_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","যাদৃশানি কর্ম্মাণি কেনাপি কদাপি নাক্রিযন্ত তাদৃশানি কর্ম্মাণি যদি তেষাং সাক্ষাদ্ অহং নাকরিষ্যং তর্হি তেষাং পাপং নাভৱিষ্যৎ কিন্ত্ৱধুনা তে দৃষ্ট্ৱাপি মাং মম পিতরঞ্চার্ত্তীযন্ত| ");
INSERT INTO sanben_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","তস্মাৎ তেঽকারণং মাম্ ঋতীযন্তে যদেতদ্ ৱচনং তেষাং শাস্ত্রে লিখিতমাস্তে তৎ সফলম্ অভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","কিন্তু পিতু র্নির্গতং যং সহাযমর্থাৎ সত্যমযম্ আত্মানং পিতুঃ সমীপাদ্ যুষ্মাকং সমীপে প্রেষযিষ্যামি স আগত্য মযি প্রমাণং দাস্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","যূযং প্রথমমারভ্য মযা সার্দ্ধং তিষ্ঠথ তস্মাদ্ধেতো র্যূযমপি প্রমাণং দাস্যথ| ");
INSERT INTO sanben_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","যুষ্মাকং যথা ৱাধা ন জাযতে তদর্থং যুষ্মান্ এতানি সর্ৱ্ৱৱাক্যানি ৱ্যাহরং| ");
INSERT INTO sanben_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","লোকা যুষ্মান্ ভজনগৃহেভ্যো দূরীকরিষ্যন্তি তথা যস্মিন্ সমযে যুষ্মান্ হৎৱা ঈশ্ৱরস্য তুষ্টি জনকং কর্ম্মাকুর্ম্ম ইতি মংস্যন্তে স সময আগচ্ছন্তি| ");
INSERT INTO sanben_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","তে পিতরং মাঞ্চ ন জানন্তি, তস্মাদ্ যুষ্মান্ প্রতীদৃশম্ আচরিষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","অতো হেতাঃ সমযে সমুপস্থিতে যথা মম কথা যুষ্মাকং মনঃসুঃ সমুপতিষ্ঠতি তদর্থং যুষ্মাভ্যম্ এতাং কথাং কথযামি যুষ্মাভিঃ সার্দ্ধম্ অহং তিষ্ঠন্ প্রথমং তাং যুষ্মভ্যং নাকথযং| ");
INSERT INTO sanben_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","সাম্প্রতং স্ৱস্য প্রেরযিতুঃ সমীপং গচ্ছামি তথাপি ৎৱং ক্ক গচ্ছসি কথামেতাং যুষ্মাকং কোপি মাং ন পৃচ্ছতি| ");
INSERT INTO sanben_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","কিন্তু মযোক্তাভিরাভিঃ কথাভি র্যূষ্মাকম্ অন্তঃকরণানি দুঃখেন পূর্ণান্যভৱন্| ");
INSERT INTO sanben_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","তথাপ্যহং যথার্থং কথযামি মম গমনং যুষ্মাকং হিতার্থমেৱ, যতো হেতো র্গমনে ন কৃতে সহাযো যুষ্মাকং সমীপং নাগমিষ্যতি কিন্তু যদি গচ্ছামি তর্হি যুষ্মাকং সমীপে তং প্রেষযিষ্যামি| ");
INSERT INTO sanben_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","ততঃ স আগত্য পাপপুণ্যদণ্ডেষু জগতো লোকানাং প্রবোধং জনযিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","তে মযি ন ৱিশ্ৱসন্তি তস্মাদ্ধেতোঃ পাপপ্রবোধং জনযিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","যুষ্মাকম্ অদৃশ্যঃ সন্নহং পিতুঃ সমীপং গচ্ছামি তস্মাদ্ পুণ্যে প্রবোধং জনযিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","এতজ্জগতোঽধিপতি র্দণ্ডাজ্ঞাং প্রাপ্নোতি তস্মাদ্ দণ্ডে প্রবোধং জনযিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","যুষ্মভ্যং কথযিতুং মমানেকাঃ কথা আসতে, তাঃ কথা ইদানীং যূযং সোঢুং ন শক্নুথ; ");
INSERT INTO sanben_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","কিন্তু সত্যময আত্মা যদা সমাগমিষ্যতি তদা সর্ৱ্ৱং সত্যং যুষ্মান্ নেষ্যতি, স স্ৱতঃ কিমপি ন ৱদিষ্যতি কিন্তু যচ্ছ্রোষ্যতি তদেৱ কথযিৎৱা ভাৱিকার্য্যং যুষ্মান্ জ্ঞাপযিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","মম মহিমানং প্রকাশযিষ্যতি যতো মদীযাং কথাং গৃহীৎৱা যুষ্মান্ বোধযিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","পিতু র্যদ্যদ্ আস্তে তৎ সর্ৱ্ৱং মম তস্মাদ্ কারণাদ্ অৱাদিষং স মদীযাং কথাং গৃহীৎৱা যুষ্মান্ বোধযিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","কিযৎকালাৎ পরং যূযং মাং দ্রষ্টুং ন লপ্স্যধ্ৱে কিন্তু কিযৎকালাৎ পরং পুন র্দ্রষ্টুং লপ্স্যধ্ৱে যতোহং পিতুঃ সমীপং গচ্ছামি| ");
INSERT INTO sanben_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ততঃ শিষ্যাণাং কিযন্তো জনাঃ পরস্পরং ৱদিতুম্ আরভন্ত, কিযৎকালাৎ পরং মাং দ্রষ্টুং ন লপ্স্যধ্ৱে কিন্তু কিযৎকালাৎ পরং পুন র্দ্রষ্টুং লপ্স্যধ্ৱে যতোহং পিতুঃ সমীপং গচ্ছামি, ইতি যদ্ ৱাক্যম্ অযং ৱদতি তৎ কিং? ");
INSERT INTO sanben_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","ততঃ কিযৎকালাৎ পরম্ ইতি তস্য ৱাক্যং কিং? তস্য ৱাক্যস্যাভিপ্রাযং ৱযং বোদ্ধুং ন শক্নুমস্তৈরিতি ");
INSERT INTO sanben_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","নিগদিতে যীশুস্তেষাং প্রশ্নেচ্ছাং জ্ঞাৎৱা তেভ্যোঽকথযৎ কিযৎকালাৎ পরং মাং দ্রষ্টুং ন লপ্স্যধ্ৱে, কিন্তু কিযৎকালাৎ পরং পূন র্দ্রষ্টুং লপ্স্যধ্ৱে, যামিমাং কথামকথযং তস্যা অভিপ্রাযং কিং যূযং পরস্পরং মৃগযধ্ৱে? ");
INSERT INTO sanben_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","যুষ্মানহম্ অতিযথার্থং ৱদামি যূযং ক্রন্দিষ্যথ ৱিলপিষ্যথ চ, কিন্তু জগতো লোকা আনন্দিষ্যন্তি; যূযং শোকাকুলা ভৱিষ্যথ কিন্তু শোকাৎ পরং আনন্দযুক্তা ভৱিষ্যথ| ");
INSERT INTO sanben_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","প্রসৱকাল উপস্থিতে নারী যথা প্রসৱৱেদনযা ৱ্যাকুলা ভৱতি কিন্তু পুত্রে ভূমিষ্ঠে সতি মনুষ্যৈকো জন্মনা নরলোকে প্রৱিষ্ট ইত্যানন্দাৎ তস্যাস্তৎসর্ৱ্ৱং দুঃখং মনসি ন তিষ্ঠতি, ");
INSERT INTO sanben_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","তথা যূযমপি সাম্প্রতং শোকাকুলা ভৱথ কিন্তু পুনরপি যুষ্মভ্যং দর্শনং দাস্যামি তেন যুষ্মাকম্ অন্তঃকরণানি সানন্দানি ভৱিষ্যন্তি, যুষ্মাকং তম্ আনন্দঞ্চ কোপি হর্ত্তুং ন শক্ষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","তস্মিন্ দিৱসে কামপি কথাং মাং ন প্রক্ষ্যথ| যুষ্মানহম্ অতিযথার্থং ৱদামি, মম নাম্না যৎ কিঞ্চিদ্ পিতরং যাচিষ্যধ্ৱে তদেৱ স দাস্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","পূর্ৱ্ৱে মম নাম্না কিমপি নাযাচধ্ৱং, যাচধ্ৱং ততঃ প্রাপ্স্যথ তস্মাদ্ যুষ্মাকং সম্পূর্ণানন্দো জনিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","উপমাকথাভিঃ সর্ৱ্ৱাণ্যেতানি যুষ্মান্ জ্ঞাপিতৱান্ কিন্তু যস্মিন্ সমযে উপমযা নোক্ত্ৱা পিতুঃ কথাং স্পষ্টং জ্ঞাপযিষ্যামি সময এতাদৃশ আগচ্ছতি| ");
INSERT INTO sanben_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","তদা মম নাম্না প্রার্থযিষ্যধ্ৱে ঽহং যুষ্মন্নিমিত্তং পিতরং ৱিনেষ্যে কথামিমাং ন ৱদামি; ");
INSERT INTO sanben_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","যতো যূযং মযি প্রেম কুরুথ, তথাহম্ ঈশ্ৱরস্য সমীপাদ্ আগতৱান্ ইত্যপি প্রতীথ, তস্মাদ্ কারণাৎ কারণাৎ পিতা স্ৱযং যুষ্মাসু প্রীযতে| ");
INSERT INTO sanben_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","পিতুঃ সমীপাজ্জজদ্ আগতোস্মি জগৎ পরিত্যজ্য চ পুনরপি পিতুঃ সমীপং গচ্ছামি| ");
INSERT INTO sanben_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","তদা শিষ্যা অৱদন্, হে প্রভো ভৱান্ উপমযা নোক্ত্ৱাধুনা স্পষ্টং ৱদতি| ");
INSERT INTO sanben_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ভৱান্ সর্ৱ্ৱজ্ঞঃ কেনচিৎ পৃষ্টো ভৱিতুমপি ভৱতঃ প্রযোজনং নাস্তীত্যধুনাস্মাকং স্থিরজ্ঞানং জাতং তস্মাদ্ ভৱান্ ঈশ্ৱরস্য সমীপাদ্ আগতৱান্ ইত্যত্র ৱযং ৱিশ্ৱসিমঃ| ");
INSERT INTO sanben_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ততো যীশুঃ প্রত্যৱাদীদ্ ইদানীং কিং যূযং ৱিশ্ৱসিথ? ");
INSERT INTO sanben_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","পশ্যত সর্ৱ্ৱে যূযং ৱিকীর্ণাঃ সন্তো মাম্ একাকিনং পীরত্যজ্য স্ৱং স্ৱং স্থানং গমিষ্যথ, এতাদৃশঃ সময আগচ্ছতি ৱরং প্রাযেণোপস্থিতৱান্; তথাপ্যহং নৈকাকী ভৱামি যতঃ পিতা মযা সার্দ্ধম্ আস্তে| ");
INSERT INTO sanben_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","যথা মযা যুষ্মাকং শান্তি র্জাযতে তদর্থম্ এতাঃ কথা যুষ্মভ্যম্ অচকথং; অস্মিন্ জগতি যুষ্মাকং ক্লেশো ঘটিষ্যতে কিন্ত্ৱক্ষোভা ভৱত যতো মযা জগজ্জিতং| ");
INSERT INTO sanben_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","ততঃ পরং যীশুরেতাঃ কথাঃ কথযিৎৱা স্ৱর্গং ৱিলোক্যৈতৎ প্রার্থযৎ, হে পিতঃ সময উপস্থিতৱান্; যথা তৱ পুত্রস্তৱ মহিমানং প্রকাশযতি তদর্থং ৎৱং নিজপুত্রস্য মহিমানং প্রকাশয| ");
INSERT INTO sanben_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ৎৱং যোল্লোকান্ তস্য হস্তে সমর্পিতৱান্ স যথা তেভ্যোঽনন্তাযু র্দদাতি তদর্থং ৎৱং প্রাণিমাত্রাণাম্ অধিপতিৎৱভারং তস্মৈ দত্তৱান্| ");
INSERT INTO sanben_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","যস্ত্ৱম্ অদ্ৱিতীযঃ সত্য ঈশ্ৱরস্ত্ৱযা প্রেরিতশ্চ যীশুঃ খ্রীষ্ট এতযোরুভযোঃ পরিচযে প্রাপ্তেঽনন্তাযু র্ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ৎৱং যস্য কর্ম্মণো ভারং মহ্যং দত্তৱান্, তৎ সম্পন্নং কৃৎৱা জগত্যস্মিন্ তৱ মহিমানং প্রাকাশযং| ");
INSERT INTO sanben_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","অতএৱ হে পিত র্জগত্যৱিদ্যমানে ৎৱযা সহ তিষ্ঠতো মম যো মহিমাসীৎ সম্প্রতি তৱ সমীপে মাং তং মহিমানং প্রাপয| ");
INSERT INTO sanben_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","অন্যচ্চ ৎৱম্ এতজ্জগতো যাল্লোকান্ মহ্যম্ অদদা অহং তেভ্যস্তৱ নাম্নস্তত্ত্ৱজ্ঞানম্ অদদাং, তে তৱৈৱাসন্, ৎৱং তান্ মহ্যমদদাঃ, তস্মাত্তে তৱোপদেশম্ অগৃহ্লন্| ");
INSERT INTO sanben_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ৎৱং মহ্যং যৎ কিঞ্চিদ্ অদদাস্তৎসর্ৱ্ৱং ৎৱত্তো জাযতে ইত্যধুনাজানন্| ");
INSERT INTO sanben_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","মহ্যং যমুপদেশম্ অদদা অহমপি তেভ্যস্তমুপদেশম্ অদদাং তেপি তমগৃহ্লন্ ৎৱত্তোহং নির্গত্য ৎৱযা প্রেরিতোভৱম্ অত্র চ ৱ্যশ্ৱসন্| ");
INSERT INTO sanben_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","তেষামেৱ নিমিত্তং প্রার্থযেঽহং জগতো লোকনিমিত্তং ন প্রার্থযে কিন্তু যাল্লোকান্ মহ্যম্ অদদাস্তেষামেৱ নিমিত্তং প্রার্থযেঽহং যতস্তে তৱৈৱাসতে| ");
INSERT INTO sanben_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","যে মম তে তৱ যে চ তৱ তে মম তথা তৈ র্মম মহিমা প্রকাশ্যতে| ");
INSERT INTO sanben_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","সাম্প্রতম্ অস্মিন্ জগতি মমাৱস্থিতেঃ শেষম্ অভৱৎ অহং তৱ সমীপং গচ্ছামি কিন্তু তে জগতি স্থাস্যন্তি; হে পৱিত্র পিতরাৱযো র্যথৈকৎৱমাস্তে তথা তেষামপ্যেকৎৱং ভৱতি তদর্থং যাল্লোকান্ মহ্যম্ অদদাস্তান্ স্ৱনাম্না রক্ষ| ");
INSERT INTO sanben_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","যাৱন্তি দিনানি জগত্যস্মিন্ তৈঃ সহাহমাসং তাৱন্তি দিনানি তান্ তৱ নাম্নাহং রক্ষিতৱান্; যাল্লোকান্ মহ্যম্ অদদাস্তান্ সর্ৱ্ৱান্ অহমরক্ষং, তেষাং মধ্যে কেৱলং ৱিনাশপাত্রং হারিতং তেন ধর্ম্মপুস্তকস্য ৱচনং প্রত্যক্ষং ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","কিন্ত্ৱধুনা তৱ সন্নিধিং গচ্ছামি মযা যথা তেষাং সম্পূর্ণানন্দো ভৱতি তদর্থমহং জগতি তিষ্ঠন্ এতাঃ কথা অকথযম্| ");
INSERT INTO sanben_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","তৱোপদেশং তেভ্যোঽদদাং জগতা সহ যথা মম সম্বন্ধো নাস্তি তথা জজতা সহ তেষামপি সম্বন্ধাভাৱাজ্ জগতো লোকাস্তান্ ঋতীযন্তে| ");
INSERT INTO sanben_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","ৎৱং জগতস্তান্ গৃহাণেতি ন প্রার্থযে কিন্ত্ৱশুভাদ্ রক্ষেতি প্রার্থযেহম্| ");
INSERT INTO sanben_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","অহং যথা জগৎসম্বন্ধীযো ন ভৱামি তথা তেপি জগৎসম্বন্ধীযা ন ভৱন্তি| ");
INSERT INTO sanben_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","তৱ সত্যকথযা তান্ পৱিত্রীকুরু তৱ ৱাক্যমেৱ সত্যং| ");
INSERT INTO sanben_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ৎৱং যথা মাং জগতি প্রৈরযস্তথাহমপি তান্ জগতি প্রৈরযং| ");
INSERT INTO sanben_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","তেষাং হিতার্থং যথাহং স্ৱং পৱিত্রীকরোমি তথা সত্যকথযা তেপি পৱিত্রীভৱন্তু| ");
INSERT INTO sanben_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","কেৱলং এতেষামর্থে প্রার্থযেঽহম্ ইতি ন কিন্ত্ৱেতেষামুপদেশেন যে জনা মযি ৱিশ্ৱসিষ্যন্তি তেষামপ্যর্থে প্রার্থেযেঽহম্| ");
INSERT INTO sanben_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","হে পিতস্তেষাং সর্ৱ্ৱেষাম্ একৎৱং ভৱতু তৱ যথা মযি মম চ যথা ৎৱয্যেকৎৱং তথা তেষামপ্যাৱযোরেকৎৱং ভৱতু তেন ৎৱং মাং প্রেরিতৱান্ ইতি জগতো লোকাঃ প্রতিযন্তু| ");
INSERT INTO sanben_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","যথাৱযোরেকৎৱং তথা তেষামপ্যেকৎৱং ভৱতু তেষ্ৱহং মযি চ ৎৱম্ ইত্থং তেষাং সম্পূর্ণমেকৎৱং ভৱতু, ৎৱং প্রেরিতৱান্ ৎৱং মযি যথা প্রীযসে চ তথা তেষ্ৱপি প্রীতৱান্ এতদ্যথা জগতো লোকা জানন্তি ");
INSERT INTO sanben_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","তদর্থং ৎৱং যং মহিমানং মহ্যম্ অদদাস্তং মহিমানম্ অহমপি তেভ্যো দত্তৱান্| ");
INSERT INTO sanben_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","হে পিত র্জগতো নির্ম্মাণাৎ পূর্ৱ্ৱং মযি স্নেহং কৃৎৱা যং মহিমানং দত্তৱান্ মম তং মহিমানং যথা তে পশ্যন্তি তদর্থং যাল্লোকান্ মহ্যং দত্তৱান্ অহং যত্র তিষ্ঠামি তেপি যথা তত্র তিষ্ঠন্তি মমৈষা ৱাঞ্ছা| ");
INSERT INTO sanben_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","হে যথার্থিক পিত র্জগতো লোকৈস্ত্ৱয্যজ্ঞাতেপি ৎৱামহং জানে ৎৱং মাং প্রেরিতৱান্ ইতীমে শিষ্যা জানন্তি| ");
INSERT INTO sanben_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","যথাহং তেষু তিষ্ঠামি তথা মযি যেন প্রেম্না প্রেমাকরোস্তৎ তেষু তিষ্ঠতি তদর্থং তৱ নামাহং তান্ জ্ঞাপিতৱান্ পুনরপি জ্ঞাপযিষ্যামি| ");
INSERT INTO sanben_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","তাঃ কথাঃ কথযিৎৱা যীশুঃ শিষ্যানাদায কিদ্রোন্নামকং স্রোত উত্তীর্য্য শিষ্যৈঃ সহ তত্রত্যোদ্যানং প্রাৱিশৎ| ");
INSERT INTO sanben_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","কিন্তু ৱিশ্ৱাসঘাতিযিহূদাস্তৎ স্থানং পরিচীযতে যতো যীশুঃ শিষ্যৈঃ সার্দ্ধং কদাচিৎ তৎ স্থানম্ অগচ্ছৎ| ");
INSERT INTO sanben_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","তদা স যিহূদাঃ সৈন্যগণং প্রধানযাজকানাং ফিরূশিনাঞ্চ পদাতিগণঞ্চ গৃহীৎৱা প্রদীপান্ উল্কান্ অস্ত্রাণি চাদায তস্মিন্ স্থান উপস্থিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","স্ৱং প্রতি যদ্ ঘটিষ্যতে তজ্ জ্ঞাৎৱা যীশুরগ্রেসরঃ সন্ তানপৃচ্ছৎ কং গৱেষযথ? ");
INSERT INTO sanben_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","তে প্রত্যৱদন্, নাসরতীযং যীশুং; ততো যীশুরৱাদীদ্ অহমেৱ সঃ; তৈঃ সহ ৱিশ্ৱাসঘাতী যিহূদাশ্চাতিষ্ঠৎ| ");
INSERT INTO sanben_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","তদাহমেৱ স তস্যৈতাং কথাং শ্রুৎৱৈৱ তে পশ্চাদেত্য ভূমৌ পতিতাঃ| ");
INSERT INTO sanben_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","ততো যীশুঃ পুনরপি পৃষ্ঠৱান্ কং গৱেষযথ? ততস্তে প্রত্যৱদন্ নাসরতীযং যীশুং| ");
INSERT INTO sanben_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","তদা যীশুঃ প্রত্যুদিতৱান্ অহমেৱ স ইমাং কথামচকথম্; যদি মামন্ৱিচ্ছথ তর্হীমান্ গন্তুং মা ৱারযত| ");
INSERT INTO sanben_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ইত্থং ভূতে মহ্যং যাল্লোকান্ অদদাস্তেষাম্ একমপি নাহারযম্ ইমাং যাং কথাং স স্ৱযমকথযৎ সা কথা সফলা জাতা| ");
INSERT INTO sanben_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","তদা শিমোন্পিতরস্য নিকটে খঙ্গল্স্থিতেঃ স তং নিষ্কোষং কৃৎৱা মহাযাজকস্য মাল্খনামানং দাসম্ আহত্য তস্য দক্ষিণকর্ণং ছিন্নৱান্| ");
INSERT INTO sanben_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ততো যীশুঃ পিতরম্ অৱদৎ, খঙ্গং কোষে স্থাপয মম পিতা মহ্যং পাতুং যং কংসম্ অদদাৎ তেনাহং কিং ন পাস্যামি? ");
INSERT INTO sanben_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","তদা সৈন্যগণঃ সেনাপতি র্যিহূদীযানাং পদাতযশ্চ যীশুং ঘৃৎৱা বদ্ধ্ৱা হানন্নাম্নঃ কিযফাঃ শ্ৱশুরস্য সমীপং প্রথমম্ অনযন্| ");
INSERT INTO sanben_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","স কিযফাস্তস্মিন্ ৱৎসরে মহাযাজৎৱপদে নিযুক্তঃ ");
INSERT INTO sanben_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","সন্ সাধারণলোকানাং মঙ্গলার্থম্ একজনস্য মরণমুচিতম্ ইতি যিহূদীযৈঃ সার্দ্ধম্ অমন্ত্রযৎ| ");
INSERT INTO sanben_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","তদা শিমোন্পিতরোঽন্যৈকশিষ্যশ্চ যীশোঃ পশ্চাদ্ অগচ্ছতাং তস্যান্যশিষ্যস্য মহাযাজকেন পরিচিতৎৱাৎ স যীশুনা সহ মহাযাজকস্যাট্টালিকাং প্রাৱিশৎ| ");
INSERT INTO sanben_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","কিন্তু পিতরো বহির্দ্ৱারস্য সমীপেঽতিষ্ঠদ্ অতএৱ মহাযাজকেন পরিচিতঃ স শিষ্যঃ পুনর্বহির্গৎৱা দৌৱাযিকাযৈ কথযিৎৱা পিতরম্ অভ্যন্তরম্ আনযৎ| ");
INSERT INTO sanben_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","তদা স দ্ৱাররক্ষিকা পিতরম্ অৱদৎ ৎৱং কিং ন তস্য মানৱস্য শিষ্যঃ? ততঃ সোৱদদ্ অহং ন ভৱামি| ");
INSERT INTO sanben_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ততঃ পরং যৎস্থানে দাসাঃ পদাতযশ্চ শীতহেতোরঙ্গারৈ র্ৱহ্নিং প্রজ্ৱাল্য তাপং সেৱিতৱন্তস্তৎস্থানে পিতরস্তিষ্ঠন্ তৈঃ সহ ৱহ্নিতাপং সেৱিতুম্ আরভত| ");
INSERT INTO sanben_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","তদা শিষ্যেষূপদেশে চ মহাযাজকেন যীশুঃ পৃষ্টঃ ");
INSERT INTO sanben_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","সন্ প্রত্যুক্তৱান্ সর্ৱ্ৱলোকানাং সমক্ষং কথামকথযং গুপ্তং কামপি কথাং ন কথযিৎৱা যৎ স্থানং যিহূদীযাঃ সততং গচ্ছন্তি তত্র ভজনগেহে মন্দিরে চাশিক্ষযং| ");
INSERT INTO sanben_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","মত্তঃ কুতঃ পৃচ্ছসি? যে জনা মদুপদেশম্ অশৃণ্ৱন্ তানেৱ পৃচ্ছ যদ্যদ্ অৱদং তে তৎ জানিন্ত| ");
INSERT INTO sanben_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","তদেত্থং প্রত্যুদিতৎৱাৎ নিকটস্থপদাতি র্যীশুং চপেটেনাহত্য ৱ্যাহরৎ মহাযাজকম্ এৱং প্রতিৱদসি? ");
INSERT INTO sanben_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ততো যীশুঃ প্রতিগদিতৱান্ যদ্যযথার্থম্ অচকথং তর্হি তস্যাযথার্থস্য প্রমাণং দেহি, কিন্তু যদি যথার্থং তর্হি কুতো হেতো র্মাম্ অতাডযঃ? ");
INSERT INTO sanben_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","পূর্ৱ্ৱং হানন্ সবন্ধনং তং কিযফামহাযাজকস্য সমীপং প্রৈষযৎ| ");
INSERT INTO sanben_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","শিমোন্পিতরস্তিষ্ঠন্ ৱহ্নিতাপং সেৱতে, এতস্মিন্ সমযে কিযন্তস্তম্ অপৃচ্ছন্ ৎৱং কিম্ এতস্য জনস্য শিষ্যো ন? ততঃ সোপহ্নুত্যাব্রৱীদ্ অহং ন ভৱামি| ");
INSERT INTO sanben_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","তদা মহাযাজকস্য যস্য দাসস্য পিতরঃ কর্ণমচ্ছিনৎ তস্য কুটুম্বঃ প্রত্যুদিতৱান্ উদ্যানে তেন সহ তিষ্ঠন্তং ৎৱাং কিং নাপশ্যং? ");
INSERT INTO sanben_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","কিন্তু পিতরঃ পুনরপহ্নুত্য কথিতৱান্; তদানীং কুক্কুটোঽরৌৎ| ");
INSERT INTO sanben_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","তদনন্তরং প্রত্যূষে তে কিযফাগৃহাদ্ অধিপতে র্গৃহং যীশুম্ অনযন্ কিন্তু যস্মিন্ অশুচিৎৱে জাতে তৈ র্নিস্তারোৎসৱে ন ভোক্তৱ্যং, তস্য ভযাদ্ যিহূদীযাস্তদ্গৃহং নাৱিশন্| ");
INSERT INTO sanben_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","অপরং পীলাতো বহিরাগত্য তান্ পৃষ্ঠৱান্ এতস্য মনুষ্যস্য কং দোষং ৱদথ? ");
INSERT INTO sanben_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","তদা তে পেত্যৱদন্ দুষ্কর্ম্মকারিণি ন সতি ভৱতঃ সমীপে নৈনং সমার্পযিষ্যামঃ| ");
INSERT INTO sanben_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ততঃ পীলাতোঽৱদদ্ যূযমেনং গৃহীৎৱা স্ৱেষাং ৱ্যৱস্থযা ৱিচারযত| তদা যিহূদীযাঃ প্রত্যৱদন্ কস্যাপি মনুষ্যস্য প্রাণদণ্ডং কর্ত্তুং নাস্মাকম্ অধিকারোঽস্তি| ");
INSERT INTO sanben_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","এৱং সতি যীশুঃ স্ৱস্য মৃত্যৌ যাং কথাং কথিতৱান্ সা সফলাভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","তদনন্তরং পীলাতঃ পুনরপি তদ্ রাজগৃহং গৎৱা যীশুমাহূয পৃষ্টৱান্ ৎৱং কিং যিহূদীযানাং রাজা? ");
INSERT INTO sanben_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","যীশুঃ প্রত্যৱদৎ ৎৱম্ এতাং কথাং স্ৱতঃ কথযসি কিমন্যঃ কশ্চিন্ মযি কথিতৱান্? ");
INSERT INTO sanben_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","পীলাতোঽৱদদ্ অহং কিং যিহূদীযঃ? তৱ স্ৱদেশীযা ৱিশেষতঃ প্রধানযাজকা মম নিকটে ৎৱাং সমার্পযন, ৎৱং কিং কৃতৱান্? ");
INSERT INTO sanben_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","যীশুঃ প্রত্যৱদৎ মম রাজ্যম্ এতজ্জগৎসম্বন্ধীযং ন ভৱতি যদি মম রাজ্যং জগৎসম্বন্ধীযম্ অভৱিষ্যৎ তর্হি যিহূদীযানাং হস্তেষু যথা সমর্পিতো নাভৱং তদর্থং মম সেৱকা অযোৎস্যন্ কিন্তু মম রাজ্যম্ ঐহিকং ন| ");
INSERT INTO sanben_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","তদা পীলাতঃ কথিতৱান্, তর্হি ৎৱং রাজা ভৱসি? যীশুঃ প্রত্যুক্তৱান্ ৎৱং সত্যং কথযসি, রাজাহং ভৱামি; সত্যতাযাং সাক্ষ্যং দাতুং জনিং গৃহীৎৱা জগত্যস্মিন্ অৱতীর্ণৱান্, তস্মাৎ সত্যধর্ম্মপক্ষপাতিনো মম কথাং শৃণ্ৱন্তি| ");
INSERT INTO sanben_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","তদা সত্যং কিং? এতাং কথাং পষ্ট্ৱা পীলাতঃ পুনরপি বহির্গৎৱা যিহূদীযান্ অভাষত, অহং তস্য কমপ্যপরাধং ন প্রাপ্নোমি| ");
INSERT INTO sanben_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","নিস্তারোৎসৱসমযে যুষ্মাভিরভিরুচিত একো জনো মযা মোচযিতৱ্য এষা যুষ্মাকং রীতিরস্তি, অতএৱ যুষ্মাকং নিকটে যিহূদীযানাং রাজানং কিং মোচযামি, যুষ্মাকম্ ইচ্ছা কা? ");
INSERT INTO sanben_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","তদা তে সর্ৱ্ৱে রুৱন্তো ৱ্যাহরন্ এনং মানুষং নহি বরব্বাং মোচয| কিন্তু স বরব্বা দস্যুরাসীৎ| ");
INSERT INTO sanben_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","পীলাতো যীশুম্ আনীয কশযা প্রাহারযৎ| ");
INSERT INTO sanben_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","পশ্চাৎ সেনাগণঃ কণ্টকনির্ম্মিতং মুকুটং তস্য মস্তকে সমর্প্য ৱার্ত্তাকীৱর্ণং রাজপরিচ্ছদং পরিধাপ্য, ");
INSERT INTO sanben_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","হে যিহূদীযানাং রাজন্ নমস্কার ইত্যুক্ত্ৱা তং চপেটেনাহন্তুম্ আরভত| ");
INSERT INTO sanben_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","তদা পীলাতঃ পুনরপি বহির্গৎৱা লোকান্ অৱদৎ, অস্য কমপ্যপরাধং ন লভেঽহং, পশ্যত তদ্ যুষ্মান্ জ্ঞাপযিতুং যুষ্মাকং সন্নিধৌ বহিরেনম্ আনযামি| ");
INSERT INTO sanben_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","ততঃ পরং যীশুঃ কণ্টকমুকুটৱান্ ৱার্ত্তাকীৱর্ণৱসনৱাংশ্চ বহিরাগচ্ছৎ| ততঃ পীলাত উক্তৱান্ এনং মনুষ্যং পশ্যত| ");
INSERT INTO sanben_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","তদা প্রধানযাজকাঃ পদাতযশ্চ তং দৃষ্ট্ৱা, এনং ক্রুশে ৱিধ, এনং ক্রুশে ৱিধ, ইত্যুক্ত্ৱা রৱিতুং আরভন্ত| ততঃ পীলাতঃ কথিতৱান্ যূযং স্ৱযম্ এনং নীৎৱা ক্রুশে ৱিধত, অহম্ এতস্য কমপ্যপরাধং ন প্রাপ্তৱান্| ");
INSERT INTO sanben_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","যিহূদীযাঃ প্রত্যৱদন্ অস্মাকং যা ৱ্যৱস্থাস্তে তদনুসারেণাস্য প্রাণহননম্ উচিতং যতোযং স্ৱম্ ঈশ্ৱরস্য পুত্রমৱদৎ| ");
INSERT INTO sanben_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","পীলাত ইমাং কথাং শ্রুৎৱা মহাত্রাসযুক্তঃ ");
INSERT INTO sanben_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","সন্ পুনরপি রাজগৃহ আগত্য যীশুং পৃষ্টৱান্ ৎৱং কুত্রত্যো লোকঃ? কিন্তু যীশস্তস্য কিমপি প্রত্যুত্তরং নাৱদৎ| ");
INSERT INTO sanben_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","১॰ ততঃ পীলাৎ কথিতৱান ৎৱং কিং মযা সার্দ্ধং ন সংলপিষ্যসি ? ৎৱাং ক্রুশে ৱেধিতুং ৱা মোচযিতুং শক্তি র্মমাস্তে ইতি কিং ৎৱং ন জানাসি ? তদা যীশুঃ প্রত্যৱদদ্ ঈশ্ৱরেণাদŸाং মমোপরি তৱ কিমপ্যধিপতিৎৱং ন ৱিদ্যতে, তথাপি যো জনো মাং তৱ হস্তে সমার্পযৎ তস্য মহাপাতকং জাতম্| ");
INSERT INTO sanben_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","তদা যীশুঃ প্রত্যৱদদ্ ঈশ্ৱরেণাদত্তং মমোপরি তৱ কিমপ্যধিপতিৎৱং ন ৱিদ্যতে, তথাপি যো জনো মাং তৱ হস্তে সমার্পযৎ তস্য মহাপাতকং জাতম্| ");
INSERT INTO sanben_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","তদারভ্য পীলাতস্তং মোচযিতুং চেষ্টিতৱান্ কিন্তু যিহূদীযা রুৱন্তো ৱ্যাহরন্ যদীমং মানৱং ত্যজসি তর্হি ৎৱং কৈসরস্য মিত্রং ন ভৱসি, যো জনঃ স্ৱং রাজানং ৱক্তি সএৱ কৈমরস্য ৱিরুদ্ধাং কথাং কথযতি| ");
INSERT INTO sanben_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","এতাং কথাং শ্রুৎৱা পীলাতো যীশুং বহিরানীয নিস্তারোৎসৱস্য আসাদনদিনস্য দ্ৱিতীযপ্রহরাৎ পূর্ৱ্ৱং প্রস্তরবন্ধননাম্নি স্থানে ঽর্থাৎ ইব্রীযভাষযা যদ্ গব্বিথা কথ্যতে তস্মিন্ স্থানে ৱিচারাসন উপাৱিশৎ| ");
INSERT INTO sanben_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","অনন্তরং পীলাতো যিহূদীযান্ অৱদৎ, যুষ্মাকং রাজানং পশ্যত| ");
INSERT INTO sanben_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","কিন্তু এনং দূরীকুরু, এনং দূরীকুরু, এনং ক্রুশে ৱিধ, ইতি কথাং কথযিৎৱা তে রৱিতুম্ আরভন্ত; তদা পীলাতঃ কথিতৱান্ যুষ্মাকং রাজানং কিং ক্রুশে ৱেধিষ্যামি? প্রধানযাজকা উত্তরম্ অৱদন্ কৈসরং ৱিনা কোপি রাজাস্মাকং নাস্তি| ");
INSERT INTO sanben_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","ততঃ পীলাতো যীশুং ক্রুশে ৱেধিতুং তেষাং হস্তেষু সমার্পযৎ, ততস্তে তং ধৃৎৱা নীতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ততঃ পরং যীশুঃ ক্রুশং ৱহন্ শিরঃকপালম্ অর্থাদ্ যদ্ ইব্রীযভাষযা গুল্গল্তাং ৱদন্তি তস্মিন্ স্থান উপস্থিতঃ| ");
INSERT INTO sanben_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ততস্তে মধ্যস্থানে তং তস্যোভযপার্শ্ৱে দ্ৱাৱপরৌ ক্রুশেঽৱিধন্| ");
INSERT INTO sanben_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","অপরম্ এষ যিহূদীযানাং রাজা নাসরতীযযীশুঃ, ইতি ৱিজ্ঞাপনং লিখিৎৱা পীলাতস্তস্য ক্রুশোপরি সমযোজযৎ| ");
INSERT INTO sanben_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","সা লিপিঃ ইব্রীযযূনানীযরোমীযভাষাভি র্লিখিতা; যীশোঃ ক্রুশৱেধনস্থানং নগরস্য সমীপং, তস্মাদ্ বহৱো যিহূদীযাস্তাং পঠিতুম্ আরভন্ত| ");
INSERT INTO sanben_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","যিহূদীযানাং প্রধানযাজকাঃ পীলাতমিতি ন্যৱেদযন্ যিহূদীযানাং রাজেতি ৱাক্যং ন কিন্তু এষ স্ৱং যিহূদীযানাং রাজানম্ অৱদদ্ ইত্থং লিখতু| ");
INSERT INTO sanben_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","ততঃ পীলাত উত্তরং দত্তৱান্ যল্লেখনীযং তল্লিখিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","ইত্থং সেনাগণো যীশুং ক্রুশে ৱিধিৎৱা তস্য পরিধেযৱস্ত্রং চতুরো ভাগান্ কৃৎৱা একৈকসেনা একৈকভাগম্ অগৃহ্লৎ তস্যোত্তরীযৱস্ত্রঞ্চাগৃহ্লৎ| কিন্তূত্তরীযৱস্ত্রং সূচিসেৱনং ৱিনা সর্ৱ্ৱম্ ঊতং| ");
INSERT INTO sanben_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","তস্মাত্তে ৱ্যাহরন্ এতৎ কঃ প্রাপ্স্যতি? তন্ন খণ্ডযিৎৱা তত্র গুটিকাপাতং করৱাম| ৱিভজন্তেঽধরীযং মে ৱসনং তে পরস্পরং| মমোত্তরীযৱস্ত্রার্থং গুটিকাং পাতযন্তি চ| ইতি যদ্ৱাক্যং ধর্ম্মপুস্তকে লিখিতমাস্তে তৎ সেনাগণেনেত্থং ৱ্যৱহরণাৎ সিদ্ধমভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","তদানীং যীশো র্মাতা মাতু র্ভগিনী চ যা ক্লিযপা ভার্য্যা মরিযম্ মগ্দলীনী মরিযম্ চ এতাস্তস্য ক্রুশস্য সন্নিধৌ সমতিষ্ঠন্| ");
INSERT INTO sanben_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","ততো যীশুঃ স্ৱমাতরং প্রিযতমশিষ্যঞ্চ সমীপে দণ্ডাযমানৌ ৱিলোক্য মাতরম্ অৱদৎ, হে যোষিদ্ এনং তৱ পুত্রং পশ্য, ");
INSERT INTO sanben_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","শিষ্যন্ত্ৱৱদৎ, এনাং তৱ মাতরং পশ্য| ততঃ স শিষ্যস্তদ্ঘটিকাযাং তাং নিজগৃহং নীতৱান্| ");
INSERT INTO sanben_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","অনন্তরং সর্ৱ্ৱং কর্ম্মাধুনা সম্পন্নমভূৎ যীশুরিতি জ্ঞাৎৱা ধর্ম্মপুস্তকস্য ৱচনং যথা সিদ্ধং ভৱতি তদর্থম্ অকথযৎ মম পিপাসা জাতা| ");
INSERT INTO sanben_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ততস্তস্মিন্ স্থানে অম্লরসেন পূর্ণপাত্রস্থিত্যা তে স্পঞ্জমেকং তদম্লরসেনার্দ্রীকৃত্য এসোব্নলে তদ্ যোজযিৎৱা তস্য মুখস্য সন্নিধাৱস্থাপযন্| ");
INSERT INTO sanben_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","তদা যীশুরম্লরসং গৃহীৎৱা সর্ৱ্ৱং সিদ্ধম্ ইতি কথাং কথযিৎৱা মস্তকং নমযন্ প্রাণান্ পর্য্যত্যজৎ| ");
INSERT INTO sanben_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","তদ্ৱিনম্ আসাদনদিনং তস্মাৎ পরেঽহনি ৱিশ্রামৱারে দেহা যথা ক্রুশোপরি ন তিষ্ঠন্তি, যতঃ স ৱিশ্রামৱারো মহাদিনমাসীৎ, তস্মাদ্ যিহূদীযাঃ পীলাতনিকটং গৎৱা তেষাং পাদভঞ্জনস্য স্থানান্তরনযনস্য চানুমতিং প্রার্থযন্ত| ");
INSERT INTO sanben_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","অতঃ সেনা আগত্য যীশুনা সহ ক্রুশে হতযোঃ প্রথমদ্ৱিতীযচোরযোঃ পাদান্ অভঞ্জন্; ");
INSERT INTO sanben_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","কিন্তু যীশোঃ সন্নিধিং গৎৱা স মৃত ইতি দৃষ্ট্ৱা তস্য পাদৌ নাভঞ্জন্| ");
INSERT INTO sanben_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","পশ্চাদ্ একো যোদ্ধা শূলাঘাতেন তস্য কুক্ষিম্ অৱিধৎ তৎক্ষণাৎ তস্মাদ্ রক্তং জলঞ্চ নিরগচ্ছৎ| ");
INSERT INTO sanben_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","যো জনোঽস্য সাক্ষ্যং দদাতি স স্ৱযং দৃষ্টৱান্ তস্যেদং সাক্ষ্যং সত্যং তস্য কথা যুষ্মাকং ৱিশ্ৱাসং জনযিতুং যোগ্যা তৎ স জানাতি| ");
INSERT INTO sanben_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","তস্যৈকম্ অস্ধ্যপি ন ভংক্ষ্যতে, ");
INSERT INTO sanben_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","তদ্ৱদ্ অন্যশাস্ত্রেপি লিখ্যতে, যথা, \"দৃষ্টিপাতং করিষ্যন্তি তেঽৱিধন্ যন্তু তম্প্রতি| \" ");
INSERT INTO sanben_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","অরিমথীযনগরস্য যূষফ্নামা শিষ্য এক আসীৎ কিন্তু যিহূদীযেভ্যো ভযাৎ প্রকাশিতো ন ভৱতি; স যীশো র্দেহং নেতুং পীলাতস্যানুমতিং প্রার্থযত, ততঃ পীলাতেনানুমতে সতি স গৎৱা যীশো র্দেহম্ অনযৎ| ");
INSERT INTO sanben_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","অপরং যো নিকদীমো রাত্রৌ যীশোঃ সমীপম্ অগচ্ছৎ সোপি গন্ধরসেন মিশ্রিতং প্রাযেণ পঞ্চাশৎসেটকমগুরুং গৃহীৎৱাগচ্ছৎ| ");
INSERT INTO sanben_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","ততস্তে যিহূদীযানাং শ্মশানে স্থাপনরীত্যনুসারেণ তৎসুগন্ধিদ্রৱ্যেণ সহিতং তস্য দেহং ৱস্ত্রেণাৱেষ্টযন্| ");
INSERT INTO sanben_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","অপরঞ্চ যত্র স্থানে তং ক্রুশেঽৱিধন্ তস্য নিকটস্থোদ্যানে যত্র কিমপি মৃতদেহং কদাপি নাস্থাপ্যত তাদৃশম্ একং নূতনং শ্মশানম্ আসীৎ| ");
INSERT INTO sanben_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","যিহূদীযানাম্ আসাদনদিনাগমনাৎ তে তস্মিন্ সমীপস্থশ্মশানে যীশুম্ অশাযযন্| ");
INSERT INTO sanben_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","অনন্তরং সপ্তাহস্য প্রথমদিনে ঽতিপ্রত্যূষে ঽন্ধকারে তিষ্ঠতি মগ্দলীনী মরিযম্ তস্য শ্মশানস্য নিকটং গৎৱা শ্মশানস্য মুখাৎ প্রস্তরমপসারিতম্ অপশ্যৎ| ");
INSERT INTO sanben_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","পশ্চাদ্ ধাৱিৎৱা শিমোন্পিতরায যীশোঃ প্রিযতমশিষ্যায চেদম্ অকথযৎ, লোকাঃ শ্মশানাৎ প্রভুং নীৎৱা কুত্রাস্থাপযন্ তদ্ ৱক্তুং ন শক্নোমি| ");
INSERT INTO sanben_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","অতঃ পিতরঃ সোন্যশিষ্যশ্চ বর্হি র্ভুৎৱা শ্মশানস্থানং গন্তুম্ আরভেতাং| ");
INSERT INTO sanben_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","উভযোর্ধাৱতোঃ সোন্যশিষ্যঃ পিতরং পশ্চাৎ ত্যক্ত্ৱা পূর্ৱ্ৱং শ্মশানস্থান উপস্থিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","তদা প্রহ্ৱীভূয স্থাপিতৱস্ত্রাণি দৃষ্টৱান্ কিন্তু ন প্রাৱিশৎ| ");
INSERT INTO sanben_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","অপরং শিমোন্পিতর আগত্য শ্মশানস্থানং প্রৱিশ্য ");
INSERT INTO sanben_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","স্থাপিতৱস্ত্রাণি মস্তকস্য ৱস্ত্রঞ্চ পৃথক্ স্থানান্তরে স্থাপিতং দৃষ্টৱান্| ");
INSERT INTO sanben_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","ততঃ শ্মশানস্থানং পূর্ৱ্ৱম্ আগতো যোন্যশিষ্যঃ সোপি প্রৱিশ্য তাদৃশং দৃষ্টা ৱ্যশ্ৱসীৎ| ");
INSERT INTO sanben_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","যতঃ শ্মশানাৎ স উত্থাপযিতৱ্য এতস্য ধর্ম্মপুস্তকৱচনস্য ভাৱং তে তদা ৱোদ্ধুং নাশন্কুৱন্| ");
INSERT INTO sanben_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","অনন্তরং তৌ দ্ৱৌ শিষ্যৌ স্ৱং স্ৱং গৃহং পরাৱৃত্যাগচ্ছতাম্| ");
INSERT INTO sanben_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","ততঃ পরং মরিযম্ শ্মশানদ্ৱারস্য বহিঃ স্থিৎৱা রোদিতুম্ আরভত ততো রুদতী প্রহ্ৱীভূয শ্মশানং ৱিলোক্য ");
INSERT INTO sanben_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","যীশোঃ শযনস্থানস্য শিরঃস্থানে পদতলে চ দ্ৱযো র্দিশো দ্ৱৌ স্ৱর্গীযদূতাৱুপৱিষ্টৌ সমপশ্যৎ| ");
INSERT INTO sanben_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","তৌ পৃষ্টৱন্তৌ হে নারি কুতো রোদিষি? সাৱদৎ লোকা মম প্রভুং নীৎৱা কুত্রাস্থাপযন্ ইতি ন জানামি| ");
INSERT INTO sanben_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ইত্যুক্ত্ৱা মুখং পরাৱৃত্য যীশুং দণ্ডাযমানম্ অপশ্যৎ কিন্তু স যীশুরিতি সা জ্ঞাতুং নাশক্নোৎ| ");
INSERT INTO sanben_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","তদা যীশুস্তাম্ অপৃচ্ছৎ হে নারি কুতো রোদিষি? কং ৱা মৃগযসে? ততঃ সা তম্ উদ্যানসেৱকং জ্ঞাৎৱা ৱ্যাহরৎ, হে মহেচ্ছ ৎৱং যদীতঃ স্থানাৎ তং নীতৱান্ তর্হি কুত্রাস্থাপযস্তদ্ ৱদ তৎস্থানাৎ তম্ আনযামি| ");
INSERT INTO sanben_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","তদা যীশুস্তাম্ অৱদৎ হে মরিযম্| ততঃ সা পরাৱৃত্য প্রত্যৱদৎ হে রব্বূনী অর্থাৎ হে গুরো| ");
INSERT INTO sanben_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","তদা যীশুরৱদৎ মাং মা ধর, ইদানীং পিতুঃ সমীপে ঊর্দ্ধ্ৱগমনং ন করোমি কিন্তু যো মম যুষ্মাকঞ্চ পিতা মম যুষ্মাকঞ্চেশ্ৱরস্তস্য নিকট ঊর্দ্ধ্ৱগমনং কর্ত্তুম্ উদ্যতোস্মি, ইমাং কথাং ৎৱং গৎৱা মম ভ্রাতৃগণং জ্ঞাপয| ");
INSERT INTO sanben_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","ততো মগ্দলীনীমরিযম্ তৎক্ষণাদ্ গৎৱা প্রভুস্তস্যৈ দর্শনং দত্ত্ৱা কথা এতা অকথযদ্ ইতি ৱার্ত্তাং শিষ্যেভ্যোঽকথযৎ| ");
INSERT INTO sanben_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ততঃ পরং সপ্তাহস্য প্রথমদিনস্য সন্ধ্যাসমযে শিষ্যা একত্র মিলিৎৱা যিহূদীযেভ্যো ভিযা দ্ৱাররুদ্ধম্ অকুর্ৱ্ৱন্, এতস্মিন্ কালে যীশুস্তেষাং মধ্যস্থানে তিষ্ঠন্ অকথযদ্ যুষ্মাকং কল্যাণং ভূযাৎ| ");
INSERT INTO sanben_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ইত্যুক্ত্ৱা নিজহস্তং কুক্ষিঞ্চ দর্শিতৱান্, ততঃ শিষ্যাঃ প্রভুং দৃষ্ট্ৱা হৃষ্টা অভৱন্| ");
INSERT INTO sanben_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","যীশুঃ পুনরৱদদ্ যুষ্মাকং কল্যাণং ভূযাৎ পিতা যথা মাং প্রৈষযৎ তথাহমপি যুষ্মান্ প্রেষযামি| ");
INSERT INTO sanben_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ইত্যুক্ত্ৱা স তেষামুপরি দীর্ঘপ্রশ্ৱাসং দত্ত্ৱা কথিতৱান্ পৱিত্রম্ আত্মানং গৃহ্লীত| ");
INSERT INTO sanben_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","যূযং যেষাং পাপানি মোচযিষ্যথ তে মোচযিষ্যন্তে যেষাঞ্চ পাপাতি ন মোচযিষ্যথ তে ন মোচযিষ্যন্তে| ");
INSERT INTO sanben_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","দ্ৱাদশমধ্যে গণিতো যমজো থোমানামা শিষ্যো যীশোরাগমনকালৈ তৈঃ সার্দ্ধং নাসীৎ| ");
INSERT INTO sanben_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","অতো ৱযং প্রভূম্ অপশ্যামেতি ৱাক্যেঽন্যশিষ্যৈরুক্তে সোৱদৎ, তস্য হস্তযো র্লৌহকীলকানাং চিহ্নং ন ৱিলোক্য তচ্চিহ্নম্ অঙ্গুল্যা ন স্পৃষ্ট্ৱা তস্য কুক্ষৌ হস্তং নারোপ্য চাহং ন ৱিশ্ৱসিষ্যামি| ");
INSERT INTO sanben_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","অপরম্ অষ্টমেঽহ্নি গতে সতি থোমাসহিতঃ শিষ্যগণ একত্র মিলিৎৱা দ্ৱারং রুদ্ধ্ৱাভ্যন্তর আসীৎ, এতর্হি যীশুস্তেষাং মধ্যস্থানে তিষ্ঠন্ অকথযৎ, যুষ্মাকং কুশলং ভূযাৎ| ");
INSERT INTO sanben_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","পশ্চাৎ থামৈ কথিতৱান্ ৎৱম্ অঙ্গুলীম্ অত্রার্পযিৎৱা মম করৌ পশ্য করং প্রসার্য্য মম কুক্ষাৱর্পয নাৱিশ্ৱস্য| ");
INSERT INTO sanben_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","তদা থোমা অৱদৎ, হে মম প্রভো হে মদীশ্ৱর| ");
INSERT INTO sanben_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","যীশুরকথযৎ, হে থোমা মাং নিরীক্ষ্য ৱিশ্ৱসিষি যে ন দৃষ্ট্ৱা ৱিশ্ৱসন্তি তএৱ ধন্যাঃ| ");
INSERT INTO sanben_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","এতদন্যানি পুস্তকেঽস্মিন্ অলিখিতানি বহূন্যাশ্চর্য্যকর্ম্মাণি যীশুঃ শিষ্যাণাং পুরস্তাদ্ অকরোৎ| ");
INSERT INTO sanben_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","কিন্তু যীশুরীশ্ৱরস্যাভিষিক্তঃ সুত এৱেতি যথা যূযং ৱিশ্ৱসিথ ৱিশ্ৱস্য চ তস্য নাম্না পরমাযুঃ প্রাপ্নুথ তদর্থম্ এতানি সর্ৱ্ৱাণ্যলিখ্যন্ত| ");
INSERT INTO sanben_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","ততঃ পরং তিবিরিযাজলধেস্তটে যীশুঃ পুনরপি শিষ্যেভ্যো দর্শনং দত্তৱান্ দর্শনস্যাখ্যানমিদম্| ");
INSERT INTO sanben_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","শিমোন্পিতরঃ যমজথোমা গালীলীযকান্নানগরনিৱাসী নিথনেল্ সিৱদেঃ পুত্রাৱন্যৌ দ্ৱৌ শিষ্যৌ চৈতেষ্ৱেকত্র মিলিতেষু শিমোন্পিতরোঽকথযৎ মৎস্যান্ ধর্তুং যামি| ");
INSERT INTO sanben_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ততস্তে ৱ্যাহরন্ তর্হি ৱযমপি ৎৱযা সার্দ্ধং যামঃ তদা তে বহির্গতাঃ সন্তঃ ক্ষিপ্রং নাৱম্ আরোহন্ কিন্তু তস্যাং রজন্যাম্ একমপি ন প্রাপ্নুৱন্| ");
INSERT INTO sanben_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","প্রভাতে সতি যীশুস্তটে স্থিতৱান্ কিন্তু স যীশুরিতি শিষ্যা জ্ঞাতুং নাশক্নুৱন্| ");
INSERT INTO sanben_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","তদা যীশুরপৃচ্ছৎ, হে ৱৎসা সন্নিধৌ কিঞ্চিৎ খাদ্যদ্রৱ্যম্ আস্তে? তেঽৱদন্ কিমপি নাস্তি| ");
INSERT INTO sanben_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","তদা সোঽৱদৎ নৌকাযা দক্ষিণপার্শ্ৱে জালং নিক্ষিপত ততো লপ্স্যধ্ৱে, তস্মাৎ তৈ র্নিক্ষিপ্তে জালে মৎস্যা এতাৱন্তোঽপতন্ যেন তে জালমাকৃষ্য নোত্তোলযিতুং শক্তাঃ| ");
INSERT INTO sanben_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","তস্মাদ্ যীশোঃ প্রিযতমশিষ্যঃ পিতরাযাকথযৎ এষ প্রভু র্ভৱেৎ, এষ প্রভুরিতি ৱাচং শ্রুৎৱৈৱ শিমোন্ নগ্নতাহেতো র্মৎস্যধারিণ উত্তরীযৱস্ত্রং পরিধায হ্রদং প্রত্যুদলম্ফযৎ| ");
INSERT INTO sanben_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","অপরে শিষ্যা মৎস্যৈঃ সার্দ্ধং জালম্ আকর্ষন্তঃ ক্ষুদ্রনৌকাং ৱাহযিৎৱা কূলমানযন্ তে কূলাদ্ অতিদূরে নাসন্ দ্ৱিশতহস্তেভ্যো দূর আসন্ ইত্যনুমীযতে| ");
INSERT INTO sanben_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","তীরং প্রাপ্তৈস্তৈস্তত্র প্রজ্ৱলিতাগ্নিস্তদুপরি মৎস্যাঃ পূপাশ্চ দৃষ্টাঃ| ");
INSERT INTO sanben_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","ততো যীশুরকথযদ্ যান্ মৎস্যান্ অধরত তেষাং কতিপযান্ আনযত| ");
INSERT INTO sanben_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","অতঃ শিমোন্পিতরঃ পরাৱৃত্য গৎৱা বৃহদ্ভিস্ত্রিপঞ্চাশদধিকশতমৎস্যৈঃ পরিপূর্ণং তজ্জালম্ আকৃষ্যোদতোলযৎ কিন্ত্ৱেতাৱদ্ভি র্মৎস্যৈরপি জালং নাছিদ্যত| ");
INSERT INTO sanben_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","অনন্তরং যীশুস্তান্ অৱাদীৎ যূযমাগত্য ভুংগ্ধ্ৱং; তদা সএৱ প্রভুরিতি জ্ঞাতৎৱাৎ ৎৱং কঃ? ইতি প্রষ্টুং শিষ্যাণাং কস্যাপি প্রগল্ভতা নাভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ততো যীশুরাগত্য পূপান্ মৎস্যাংশ্চ গৃহীৎৱা তেভ্যঃ পর্য্যৱেষযৎ| ");
INSERT INTO sanben_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ইত্থং শ্মশানাদুত্থানাৎ পরং যীশুঃ শিষ্যেভ্যস্তৃতীযৱারং দর্শনং দত্তৱান্| ");
INSERT INTO sanben_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ভোজনে সমাপ্তে সতি যীশুঃ শিমোন্পিতরং পৃষ্টৱান্, হে যূনসঃ পুত্র শিমোন্ ৎৱং কিম্ এতেভ্যোধিকং মযি প্রীযসে? ততঃ স উদিতৱান্ সত্যং প্রভো ৎৱযি প্রীযেঽহং তদ্ ভৱান্ জানাতি; তদা যীশুরকথযৎ তর্হি মম মেষশাৱকগণং পালয| ");
INSERT INTO sanben_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ততঃ স দ্ৱিতীযৱারং পৃষ্টৱান্ হে যূনসঃ পুত্র শিমোন্ ৎৱং কিং মযি প্রীযসে? ততঃ স উক্তৱান্ সত্যং প্রভো ৎৱযি প্রীযেঽহং তদ্ ভৱান্ জানাতি; তদা যীশুরকথযত তর্হি মম মেষগণং পালয| ");
INSERT INTO sanben_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","পশ্চাৎ স তৃতীযৱারং পৃষ্টৱান্, হে যূনসঃ পুত্র শিমোন্ ৎৱং কিং মযি প্রীযসে? এতদ্ৱাক্যং তৃতীযৱারং পৃষ্টৱান্ তস্মাৎ পিতরো দুঃখিতো ভূৎৱাঽকথযৎ হে প্রভো ভৱতঃ কিমপ্যগোচরং নাস্তি ৎৱয্যহং প্রীযে তদ্ ভৱান্ জানাতি; ততো যীশুরৱদৎ তর্হি মম মেষগণং পালয| ");
INSERT INTO sanben_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","অহং তুভ্যং যথার্থং কথযামি যৌৱনকালে স্ৱযং বদ্ধকটি র্যত্রেচ্ছা তত্র যাতৱান্ কিন্ত্ৱিতঃ পরং ৱৃদ্ধে ৱযসি হস্তং ৱিস্তারযিষ্যসি, অন্যজনস্ত্ৱাং বদ্ধ্ৱা যত্র গন্তুং তৱেচ্ছা ন ভৱতি ৎৱাং ধৃৎৱা তত্র নেষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ফলতঃ কীদৃশেন মরণেন স ঈশ্ৱরস্য মহিমানং প্রকাশযিষ্যতি তদ্ বোধযিতুং স ইতি ৱাক্যং প্রোক্তৱান্| ইত্যুক্তে সতি স তমৱোচৎ মম পশ্চাদ্ আগচ্ছ| ");
INSERT INTO sanben_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","যো জনো রাত্রিকালে যীশো র্ৱক্ষোঽৱলম্ব্য, হে প্রভো কো ভৱন্তং পরকরেষু সমর্পযিষ্যতীতি ৱাক্যং পৃষ্টৱান্, তং যীশোঃ প্রিযতমশিষ্যং পশ্চাদ্ আগচ্ছন্তং ");
INSERT INTO sanben_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","পিতরো মুখং পরাৱর্ত্ত্য ৱিলোক্য যীশুং পৃষ্টৱান্, হে প্রভো এতস্য মানৱস্য কীদৃশী গতি র্ভৱিষ্যতি? ");
INSERT INTO sanben_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","স প্রত্যৱদৎ, মম পুনরাগমনপর্য্যন্তং যদি তং স্থাপযিতুম্ ইচ্ছামি তত্র তৱ কিং? ৎৱং মম পশ্চাদ্ আগচ্ছ| ");
INSERT INTO sanben_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","তস্মাৎ স শিষ্যো ন মরিষ্যতীতি ভ্রাতৃগণমধ্যে কিংৱদন্তী জাতা কিন্তু স ন মরিষ্যতীতি ৱাক্যং যীশু র্নাৱদৎ কেৱলং মম পুনরাগমনপর্য্যন্তং যদি তং স্থাপযিতুম্ ইচ্ছামি তত্র তৱ কিং? ইতি ৱাক্যম্ উক্তৱান্| ");
INSERT INTO sanben_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","যো জন এতানি সর্ৱ্ৱাণি লিখিতৱান্ অত্র সাক্ষ্যঞ্চ দত্তৱান্ সএৱ স শিষ্যঃ, তস্য সাক্ষ্যং প্রমাণমিতি ৱযং জানীমঃ| ");
INSERT INTO sanben_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","যীশুরেতেভ্যোঽপরাণ্যপি বহূনি কর্ম্মাণি কৃতৱান্ তানি সর্ৱ্ৱাণি যদ্যেকৈকং কৃৎৱা লিখ্যন্তে তর্হি গ্রন্থা এতাৱন্তো ভৱন্তি তেষাং ধারণে পৃথিৱ্যাং স্থানং ন ভৱতি| ইতি||");
INSERT INTO sanben_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","হে থিযফিল, যীশুঃ স্ৱমনোনীতান্ প্রেরিতান্ পৱিত্রেণাত্মনা সমাদিশ্য যস্মিন্ দিনে স্ৱর্গমারোহৎ যাং যাং ক্রিযামকরোৎ যদ্যদ্ উপাদিশচ্চ তানি সর্ৱ্ৱাণি পূর্ৱ্ৱং মযা লিখিতানি| ");
INSERT INTO sanben_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","স স্ৱনিধনদুঃখভোগাৎ পরম্ অনেকপ্রত্যযক্ষপ্রমাণৌঃ স্ৱং সজীৱং দর্শযিৎৱা ");
INSERT INTO sanben_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","চৎৱারিংশদ্দিনানি যাৱৎ তেভ্যঃ প্রেরিতেভ্যো দর্শনং দত্ত্ৱেশ্ৱরীযরাজ্যস্য ৱর্ণনম অকরোৎ| ");
INSERT INTO sanben_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","অনন্তরং তেষাং সভাং কৃৎৱা ইত্যাজ্ঞাপযৎ, যূযং যিরূশালমোঽন্যত্র গমনমকৃৎৱা যস্তিন্ পিত্রাঙ্গীকৃতে মম ৱদনাৎ কথা অশৃণুত তৎপ্রাপ্তিম্ অপেক্ষ্য তিষ্ঠত| ");
INSERT INTO sanben_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","যোহন্ জলে মজ্জিতাৱান্ কিন্ত্ৱল্পদিনমধ্যে যূযং পৱিত্র আত্মনি মজ্জিতা ভৱিষ্যথ| ");
INSERT INTO sanben_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","পশ্চাৎ তে সর্ৱ্ৱে মিলিৎৱা তম্ অপৃচ্ছন্ হে প্রভো ভৱান্ কিমিদানীং পুনরপি রাজ্যম্ ইস্রাযেলীযলোকানাং করেষু সমর্পযিষ্যতি? ");
INSERT INTO sanben_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ততঃ সোৱদৎ যান্ সর্ৱ্ৱান্ কালান্ সমযাংশ্চ পিতা স্ৱৱশেঽস্থাপযৎ তান্ জ্ঞাতৃং যুষ্মাকম্ অধিকারো ন জাযতে| ");
INSERT INTO sanben_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","কিন্তু যুষ্মাসু পৱিত্রস্যাত্মন আৱির্ভাৱে সতি যূযং শক্তিং প্রাপ্য যিরূশালমি সমস্তযিহূদাশোমিরোণদেশযোঃ পৃথিৱ্যাঃ সীমাং যাৱদ্ যাৱন্তো দেশাস্তেষু যর্ৱ্ৱেষু চ মযি সাক্ষ্যং দাস্যথ| ");
INSERT INTO sanben_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ইতি ৱাক্যমুক্ত্ৱা স তেষাং সমক্ষং স্ৱর্গং নীতোঽভৱৎ, ততো মেঘমারুহ্য তেষাং দৃষ্টেরগোচরোঽভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","যস্মিন্ সমযে তে ৱিহাযসং প্রত্যনন্যদৃষ্ট্যা তস্য তাদৃশম্ ঊর্দ্ৱ্ৱগমনম্ অপশ্যন্ তস্মিন্নেৱ সমযে শুক্লৱস্ত্রৌ দ্ৱৌ জনৌ তেষাং সন্নিধৌ দণ্ডাযমানৌ কথিতৱন্তৌ, ");
INSERT INTO sanben_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","হে গালীলীযলোকা যূযং কিমর্থং গগণং প্রতি নিরীক্ষ্য দণ্ডাযমানাস্তিষ্ঠথ? যুষ্মাকং সমীপাৎ স্ৱর্গং নীতো যো যীশুস্তং যূযং যথা স্ৱর্গম্ আরোহন্তম্ অদর্শম্ তথা স পুনশ্চাগমিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","ততঃ পরং তে জৈতুননাম্নঃ পর্ৱ্ৱতাদ্ ৱিশ্রামৱারস্য পথঃ পরিমাণম্ অর্থাৎ প্রাযেণার্দ্ধক্রোশং দুরস্থং যিরূশালম্নগরং পরাৱৃত্যাগচ্ছন্| ");
INSERT INTO sanben_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","নগরং প্রৱিশ্য পিতরো যাকূব্ যোহন্ আন্দ্রিযঃ ফিলিপঃ থোমা বর্থজমযো মথিরাল্ফীযপুত্রো যাকূব্ উদ্যোগাी শিমোন্ যাকূবো ভ্রাতা যিহূদা এতে সর্ৱ্ৱে যত্র স্থানে প্রৱসন্তি তস্মিন্ উপরিতনপ্রকোষ্ঠে প্রাৱিশন্| ");
INSERT INTO sanben_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","পশ্চাদ্ ইমে কিযত্যঃ স্ত্রিযশ্চ যীশো র্মাতা মরিযম্ তস্য ভ্রাতরশ্চৈতে সর্ৱ্ৱ একচিত্তীভূত সততং ৱিনযেন ৱিনযেন প্রার্থযন্ত| ");
INSERT INTO sanben_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","তস্মিন্ সমযে তত্র স্থানে সাকল্যেন ৱিংশত্যধিকশতং শিষ্যা আসন্| ততঃ পিতরস্তেষাং মধ্যে তিষ্ঠন্ উক্তৱান্ ");
INSERT INTO sanben_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","হে ভ্রাতৃগণ যীশুধারিণাং লোকানাং পথদর্শকো যো যিহূদাস্তস্মিন্ দাযূদা পৱিত্র আত্মা যাং কথাং কথযামাস তস্যাঃ প্রত্যক্ষীভৱনস্যাৱশ্যকৎৱম্ আসীৎ| ");
INSERT INTO sanben_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","স জনোঽস্মাকং মধ্যৱর্ত্তী সন্ অস্যাঃ সেৱাযা অংশম্ অলভত| ");
INSERT INTO sanben_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","তদনন্তরং কুকর্ম্মণা লব্ধং যন্মূল্যং তেন ক্ষেত্রমেকং ক্রীতম্ অপরং তস্মিন্ অধোমুখে ভৃমৌ পতিতে সতি তস্যোদরস্য ৱিদীর্ণৎৱাৎ সর্ৱ্ৱা নাড্যো নিরগচ্ছন্| ");
INSERT INTO sanben_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","এতাং কথাং যিরূশালম্নিৱাসিনঃ সর্ৱ্ৱে লোকা ৱিদান্তি; তেষাং নিজভাষযা তৎক্ষেত্রঞ্চ হকল্দামা, অর্থাৎ রক্তক্ষেত্রমিতি ৱিখ্যাতমাস্তে| ");
INSERT INTO sanben_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","অন্যচ্চ, নিকেতনং তদীযন্তু শুন্যমেৱ ভৱিষ্যতি| তস্য দূষ্যে নিৱাসার্থং কোপি স্থাস্যতি নৈৱ হি| অন্য এৱ জনস্তস্য পদং সংপ্রাপ্স্যতি ধ্রুৱং| ইত্থং গীতপুস্তকে লিখিতমাস্তে| ");
INSERT INTO sanben_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","অতো যোহনো মজ্জনম্ আরভ্যাস্মাকং সমীপাৎ প্রভো র্যীশোঃ স্ৱর্গারোহণদিনং যাৱৎ সোস্মাকং মধ্যে যাৱন্তি দিনানি যাপিতৱান্ ");
INSERT INTO sanben_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","তাৱন্তি দিনানি যে মানৱা অস্মাভিঃ সার্দ্ধং তিষ্ঠন্তি তেষাম্ একেন জনেনাস্মাভিঃ সার্দ্ধং যীশোরুত্থানে সাক্ষিণা ভৱিতৱ্যং| ");
INSERT INTO sanben_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","অতো যস্য রূঢি র্যুষ্টো যং বর্শব্বেত্যুক্ত্ৱাহূযন্তি স যূষফ্ মতথিশ্চ দ্ৱাৱেতৌ পৃথক্ কৃৎৱা ত ঈশ্ৱরস্য সন্নিধৌ প্রার্য্য কথিতৱন্তঃ, ");
INSERT INTO sanben_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","হে সর্ৱ্ৱান্তর্য্যামিন্ পরমেশ্ৱর, যিহূদাঃ সেৱনপ্রেরিতৎৱপদচ্যুতঃ ");
INSERT INTO sanben_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","সন্ নিজস্থানম্ অগচ্ছৎ, তৎপদং লব্ধুম্ এনযো র্জনযো র্মধ্যে ভৱতা কোঽভিরুচিতস্তদস্মান্ দর্শ্যতাং| ");
INSERT INTO sanben_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ততো গুটিকাপাটে কৃতে মতথির্নিরচীযত তস্মাৎ সোন্যেষাম্ একাদশানাং প্ররিতানাং মধ্যে গণিতোভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","অপরঞ্চ নিস্তারোৎসৱাৎ পরং পঞ্চাশত্তমে দিনে সমুপস্থিতে সতি তে সর্ৱ্ৱে একাচিত্তীভূয স্থান একস্মিন্ মিলিতা আসন্| ");
INSERT INTO sanben_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","এতস্মিন্নেৱ সমযেঽকস্মাদ্ আকাশাৎ প্রচণ্ডাত্যুগ্রৱাযোঃ শব্দৱদ্ একঃ শব্দ আগত্য যস্মিন্ গৃহে ত উপাৱিশন্ তদ্ গৃহং সমস্তং ৱ্যাপ্নোৎ| ");
INSERT INTO sanben_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ততঃ পরং ৱহ্নিশিখাস্ৱরূপা জিহ্ৱাঃ প্রত্যক্ষীভূয ৱিভক্তাঃ সত্যঃ প্রতিজনোর্দ্ধ্ৱে স্থগিতা অভূৱন্| ");
INSERT INTO sanben_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","তস্মাৎ সর্ৱ্ৱে পৱিত্রেণাত্মনা পরিপূর্ণাঃ সন্ত আত্মা যথা ৱাচিতৱান্ তদনুসারেণান্যদেশীযানাং ভাষা উক্তৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","তস্মিন্ সমযে পৃথিৱীস্থসর্ৱ্ৱদেশেভ্যো যিহূদীযমতাৱলম্বিনো ভক্তলোকা যিরূশালমি প্রাৱসন্; ");
INSERT INTO sanben_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","তস্যাঃ কথাযাঃ কিংৱদন্ত্যা জাতৎৱাৎ সর্ৱ্ৱে লোকা মিলিৎৱা নিজনিজভাষযা শিষ্যাণাং কথাকথনং শ্রুৎৱা সমুদ্ৱিগ্না অভৱন্| ");
INSERT INTO sanben_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","সর্ৱ্ৱএৱ ৱিস্মযাপন্না আশ্চর্য্যান্ৱিতাশ্চ সন্তঃ পরস্পরং উক্তৱন্তঃ পশ্যত যে কথাং কথযন্তি তে সর্ৱ্ৱে গালীলীযলোকাঃ কিং ন ভৱন্তি? ");
INSERT INTO sanben_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","তর্হি ৱযং প্রত্যেকশঃ স্ৱস্ৱজন্মদেশীযভাষাভিঃ কথা এতেষাং শৃণুমঃ কিমিদং? ");
INSERT INTO sanben_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","পার্থী-মাদী-অরাম্নহরযিম্দেশনিৱাসিমনো যিহূদা-কপ্পদকিযা-পন্ত-আশিযা- ");
INSERT INTO sanben_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ফ্রুগিযা-পম্ফুলিযা-মিসরনিৱাসিনঃ কুরীণীনিকটৱর্ত্তিলূবীযপ্রদেশনিৱাসিনো রোমনগরাদ্ আগতা যিহূদীযলোকা যিহূদীযমতগ্রাহিণঃ ক্রীতীযা অরাবীযাদযো লোকাশ্চ যে ৱযম্ ");
INSERT INTO sanben_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","অস্মাকং নিজনিজভাষাভিরেতেষাম্ ঈশ্ৱরীযমহাকর্ম্মৱ্যাখ্যানং শৃণুমঃ| ");
INSERT INTO sanben_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ইত্থং তে সর্ৱ্ৱএৱ ৱিস্মযাপন্নাঃ সন্দিগ্ধচিত্তাঃ সন্তঃ পরস্পরমূচুঃ, অস্য কো ভাৱঃ? ");
INSERT INTO sanben_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","অপরে কেচিৎ পরিহস্য কথিতৱন্ত এতে নৱীনদ্রাক্ষারসেন মত্তা অভৱন্| ");
INSERT INTO sanben_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","তদা পিতর একাদশভি র্জনৈঃ সাকং তিষ্ঠন্ তাল্লোকান্ উচ্চৈঃকারম্ অৱদৎ, হে যিহূদীযা হে যিরূশালম্নিৱাসিনঃ সর্ৱ্ৱে, অৱধানং কৃৎৱা মদীযৱাক্যং বুধ্যধ্ৱং| ");
INSERT INTO sanben_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ইদানীম্ একযামাদ্ অধিকা ৱেলা নাস্তি তস্মাদ্ যূযং যদ্ অনুমাথ মানৱা ইমে মদ্যপানেন মত্তাস্তন্ন| ");
INSERT INTO sanben_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","কিন্তু যোযেল্ভৱিষ্যদ্ৱক্ত্রৈতদ্ৱাক্যমুক্তং যথা, ");
INSERT INTO sanben_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","ঈশ্ৱরঃ কথযামাস যুগান্তসমযে ৎৱহম্| ৱর্ষিষ্যামি স্ৱমাত্মানং সর্ৱ্ৱপ্রাণ্যুপরি ধ্রুৱম্| ভাৱিৱাক্যং ৱদিষ্যন্তি কন্যাঃ পুত্রাশ্চ ৱস্তুতঃ| প্রত্যাদেশঞ্চ প্রাপ্স্যন্তি যুষ্মাকং যুৱমানৱাঃ| তথা প্রাচীনলোকাস্তু স্ৱপ্নান্ দ্রক্ষ্যন্তি নিশ্চিতং| ");
INSERT INTO sanben_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","ৱর্ষিষ্যামি তদাত্মানং দাসদাসীজনোপিরি| তেনৈৱ ভাৱিৱাক্যং তে ৱদিষ্যন্তি হি সর্ৱ্ৱশঃ| ");
INSERT INTO sanben_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ঊর্দ্ধ্ৱস্থে গগণে চৈৱ নীচস্থে পৃথিৱীতলে| শোণিতানি বৃহদ্ভানূন্ ঘনধূমাদিকানি চ| চিহ্নানি দর্শযিষ্যামি মহাশ্চর্য্যক্রিযাস্তথা| ");
INSERT INTO sanben_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","মহাভযানকস্যৈৱ তদ্দিনস্য পরেশিতুঃ| পুরাগমাদ্ রৱিঃ কৃষ্ণো রক্তশ্চন্দ্রো ভৱিষ্যতঃ| ");
INSERT INTO sanben_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","কিন্তু যঃ পরমেশস্য নাম্নি সম্প্রার্থযিষ্যতে| সএৱ মনুজো নূনং পরিত্রাতো ভৱিষ্যতি|| ");
INSERT INTO sanben_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","অতো হে ইস্রাযেল্ৱংশীযলোকাঃ সর্ৱ্ৱে কথাযামেতস্যাম্ মনো নিধদ্ধ্ৱং নাসরতীযো যীশুরীশ্ৱরস্য মনোনীতঃ পুমান্ এতদ্ ঈশ্ৱরস্তৎকৃতৈরাশ্চর্য্যাদ্ভুতকর্ম্মভি র্লক্ষণৈশ্চ যুষ্মাকং সাক্ষাদেৱ প্রতিপাদিতৱান্ ইতি যূযং জানীথ| ");
INSERT INTO sanben_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","তস্মিন্ যীশৌ ঈশ্ৱরস্য পূর্ৱ্ৱনিশ্চিতমন্ত্রণানিরূপণানুসারেণ মৃত্যৌ সমর্পিতে সতি যূযং তং ধৃৎৱা দুষ্টলোকানাং হস্তৈঃ ক্রুশে ৱিধিৎৱাহত| ");
INSERT INTO sanben_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","কিন্ত্ৱীশ্ৱরস্তং নিধনস্য বন্ধনান্মোচযিৎৱা উদস্থাপযৎ যতঃ স মৃত্যুনা বদ্ধস্তিষ্ঠতীতি ন সম্ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","এতস্তিন্ দাযূদপি কথিতৱান্ যথা, সর্ৱ্ৱদা মম সাক্ষাত্তং স্থাপয পরমেশ্ৱরং| স্থিতে মদ্দক্ষিণে তস্মিন্ স্খলিষ্যামি ৎৱহং নহি| ");
INSERT INTO sanben_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","আনন্দিষ্যতি তদ্ধেতো র্মামকীনং মনস্তু ৱৈ| আহ্লাদিষ্যতি জিহ্ৱাপি মদীযা তু তথৈৱ চ| প্রত্যাশযা শরীরন্তু মদীযং ৱৈশযিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","পরলোকে যতো হেতোস্ত্ৱং মাং নৈৱ হি ত্যক্ষ্যসি| স্ৱকীযং পুণ্যৱন্তং ৎৱং ক্ষযিতুং নৈৱ দাস্যসি| এৱং জীৱনমার্গং ৎৱং মামেৱ দর্শযিষ্যসি| ");
INSERT INTO sanben_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","স্ৱসম্মুখে য আনন্দো দক্ষিণে স্ৱস্য যৎ সুখং| অনন্তং তেন মাং পূর্ণং করিষ্যসি ন সংশযঃ|| ");
INSERT INTO sanben_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","হে ভ্রাতরোঽস্মাকং তস্য পূর্ৱ্ৱপুরুষস্য দাযূদঃ কথাং স্পষ্টং কথযিতুং মাম্ অনুমন্যধ্ৱং, স প্রাণান্ ত্যক্ত্ৱা শ্মশানে স্থাপিতোভৱদ্ অদ্যাপি তৎ শ্মশানম্ অস্মাকং সন্নিধৌ ৱিদ্যতে| ");
INSERT INTO sanben_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","ফলতো লৌকিকভাৱেন দাযূদো ৱংশে খ্রীষ্টং জন্ম গ্রাহযিৎৱা তস্যৈৱ সিংহাসনে সমুৱেষ্টুং তমুত্থাপযিষ্যতি পরমেশ্ৱরঃ শপথং কুৎৱা দাযূদঃ সমীপ ইমম্ অঙ্গীকারং কৃতৱান্, ");
INSERT INTO sanben_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ইতি জ্ঞাৎৱা দাযূদ্ ভৱিষ্যদ্ৱাদী সন্ ভৱিষ্যৎকালীযজ্ঞানেন খ্রীষ্টোত্থানে কথামিমাং কথযামাস যথা তস্যাত্মা পরলোকে ন ত্যক্ষ্যতে তস্য শরীরঞ্চ ন ক্ষেষ্যতি; ");
INSERT INTO sanben_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","অতঃ পরমেশ্ৱর এনং যীশুং শ্মশানাদ্ উদস্থাপযৎ তত্র ৱযং সর্ৱ্ৱে সাক্ষিণ আস্মহে| ");
INSERT INTO sanben_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","স ঈশ্ৱরস্য দক্ষিণকরেণোন্নতিং প্রাপ্য পৱিত্র আত্মিন পিতা যমঙ্গীকারং কৃতৱান্ তস্য ফলং প্রাপ্য যৎ পশ্যথ শৃণুথ চ তদৱর্ষৎ| ");
INSERT INTO sanben_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","যতো দাযূদ্ স্ৱর্গং নারুরোহ কিন্তু স্ৱযম্ ইমাং কথাম্ অকথযদ্ যথা, মম প্রভুমিদং ৱাক্যমৱদৎ পরমেশ্ৱরঃ| ");
INSERT INTO sanben_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","তৱ শত্রূনহং যাৱৎ পাদপীঠং করোমি ন| তাৱৎ কালং মদীযে ৎৱং দক্ষৱার্শ্ৱ উপাৱিশ| ");
INSERT INTO sanben_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","অতো যং যীশুং যূযং ক্রুশেঽহত পরমেশ্ৱরস্তং প্রভুৎৱাভিষিক্তৎৱপদে ন্যযুংক্তেতি ইস্রাযেলীযা লোকা নিশ্চিতং জানন্তু| ");
INSERT INTO sanben_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","এতাদৃশীং কথাং শ্রুৎৱা তেষাং হৃদযানাং ৱিদীর্ণৎৱাৎ তে পিতরায তদন্যপ্রেরিতেভ্যশ্চ কথিতৱন্তঃ, হে ভ্রাতৃগণ ৱযং কিং করিষ্যামঃ? ");
INSERT INTO sanben_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","ততঃ পিতরঃ প্রত্যৱদদ্ যূযং সর্ৱ্ৱে স্ৱং স্ৱং মনঃ পরিৱর্ত্তযধ্ৱং তথা পাপমোচনার্থং যীশুখ্রীষ্টস্য নাম্না মজ্জিতাশ্চ ভৱত, তস্মাদ্ দানরূপং পরিত্রম্ আত্মানং লপ্স্যথ| ");
INSERT INTO sanben_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","যতো যুষ্মাকং যুষ্মৎসন্তানানাঞ্চ দূরস্থসর্ৱ্ৱলোকানাঞ্চ নিমিত্তম্ অর্থাদ্ অস্মাকং প্রভুঃ পরমেশ্ৱরো যাৱতো লাকান্ আহ্ৱাস্যতি তেষাং সর্ৱ্ৱেষাং নিমিত্তম্ অযমঙ্গীকার আস্তে| ");
INSERT INTO sanben_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","এতদন্যাভি র্বহুকথাভিঃ প্রমাণং দৎৱাকথযৎ এতেভ্যো ৱিপথগামিভ্যো ৱর্ত্তমানলোকেভ্যঃ স্ৱান্ রক্ষত| ");
INSERT INTO sanben_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","ততঃ পরং যে সানন্দাস্তাং কথাম্ অগৃহ্লন্ তে মজ্জিতা অভৱন্| তস্মিন্ দিৱসে প্রাযেণ ত্রীণি সহস্রাণি লোকাস্তেষাং সপক্ষাঃ সন্তঃ ");
INSERT INTO sanben_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","প্রেরিতানাম্ উপদেশে সঙ্গতৌ পূপভঞ্জনে প্রার্থনাসু চ মনঃসংযোগং কৃৎৱাতিষ্ঠন্| ");
INSERT INTO sanben_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","প্রেরিতৈ র্নানাপ্রকারলক্ষণেষু মহাশ্চর্য্যকর্মমসু চ দর্শিতেষু সর্ৱ্ৱলোকানাং ভযমুপস্থিতং| ");
INSERT INTO sanben_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","ৱিশ্ৱাসকারিণঃ সর্ৱ্ৱ চ সহ তিষ্ঠনতঃ| স্ৱেষাং সর্ৱ্ৱাঃ সম্পত্তীঃ সাধারণ্যেন স্থাপযিৎৱাভুঞ্জত| ");
INSERT INTO sanben_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ফলতো গৃহাণি দ্রৱ্যাণি চ সর্ৱ্ৱাণি ৱিক্রীয সর্ৱ্ৱেষাং স্ৱস্ৱপ্রযোজনানুসারেণ ৱিভজ্য সর্ৱ্ৱেভ্যোঽদদন্| ");
INSERT INTO sanben_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","সর্ৱ্ৱ একচিত্তীভূয দিনে দিনে মন্দিরে সন্তিষ্ঠমানা গৃহে গৃহে চ পূপানভঞ্জন্ত ঈশ্ৱরস্য ধন্যৱাদং কুর্ৱ্ৱন্তো লোকৈঃ সমাদৃতাঃ পরমানন্দেন সরলান্তঃকরণেন ভোজনং পানঞ্চকুর্ৱ্ৱন্| ");
INSERT INTO sanben_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","পরমেশ্ৱরো দিনে দিনে পরিত্রাণভাজনৈ র্মণ্ডলীম্ অৱর্দ্ধযৎ| ");
INSERT INTO sanben_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","তৃতীযযামৱেলাযাং সত্যাং প্রার্থনাযাঃ সমযে পিতরযোহনৌ সম্ভূয মন্দিরং গচ্ছতঃ| ");
INSERT INTO sanben_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","তস্মিন্নেৱ সমযে মন্দিরপ্রৱেশকানাং সমীপে ভিক্ষারণার্থং যং জন্মখঞ্জমানুষং লোকা মন্দিরস্য সুন্দরনাম্নি দ্ৱারে প্রতিদিনম্ অস্থাপযন্ তং ৱহন্তস্তদ্ৱারং আনযন্| ");
INSERT INTO sanben_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","তদা পিতরযোহনৌ মন্তিরং প্রৱেষ্টুম্ উদ্যতৌ ৱিলোক্য স খঞ্জস্তৌ কিঞ্চিদ্ ভিক্ষিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","তস্মাদ্ যোহনা সহিতঃ পিতরস্তম্ অনন্যদৃষ্ট্যা নিরীক্ষ্য প্রোক্তৱান্ আৱাং প্রতি দৃষ্টিং কুরু| ");
INSERT INTO sanben_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ততঃ স কিঞ্চিৎ প্রাপ্ত্যাশযা তৌ প্রতি দৃষ্টিং কৃতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","তদা পিতরো গদিতৱান্ মম নিকটে স্ৱর্ণরূপ্যাদি কিমপি নাস্তি কিন্তু যদাস্তে তদ্ দদামি নাসরতীযস্য যীশুখ্রীষ্টস্য নাম্না ৎৱমুত্থায গমনাগমনে কুরু| ");
INSERT INTO sanben_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ততঃ পরং স তস্য দক্ষিণকরং ধৃৎৱা তম্ উদতোলযৎ; তেন তৎক্ষণাৎ তস্য জনস্য পাদগুল্ফযোঃ সবলৎৱাৎ স উল্লম্ফ্য প্রোত্থায গমনাগমনে ঽকরোৎ| ");
INSERT INTO sanben_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ততো গমনাগমনে কুর্ৱ্ৱন্ উল্লম্ফন্ ঈশ্ৱরং ধন্যং ৱদন্ তাভ্যাং সার্দ্ধং মন্দিরং প্রাৱিশৎ| ");
INSERT INTO sanben_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ততঃ সর্ৱ্ৱে লোকাস্তং গমনাগমনে কুর্ৱ্ৱন্তম্ ঈশ্ৱরং ধন্যং ৱদন্তঞ্চ ৱিলোক্য ");
INSERT INTO sanben_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","মন্দিরস্য সুন্দরে দ্ৱারে য উপৱিশ্য ভিক্ষিতৱান্ সএৱাযম্ ইতি জ্ঞাৎৱা তং প্রতি তযা ঘটনযা চমৎকৃতা ৱিস্মযাপন্নাশ্চাভৱন্| ");
INSERT INTO sanben_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","যঃ খঞ্জঃ স্ৱস্থোভৱৎ তেন পিতরযোহনোঃ করযোর্ধ্টতযোঃ সতোঃ সর্ৱ্ৱে লোকা সন্নিধিম্ আগচ্ছন্| ");
INSERT INTO sanben_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","তদ্ দৃষ্ট্ৱা পিতরস্তেভ্যোঽকথযৎ, হে ইস্রাযেলীযলোকা যূযং কুতো ঽনেনাশ্চর্য্যং মন্যধ্ৱে? আৱাং নিজশক্ত্যা যদ্ৱা নিজপুণ্যেন খঞ্জমনুষ্যমেনং গমিতৱন্তাৱিতি চিন্তযিৎৱা আৱাং প্রতি কুতোঽনন্যদৃষ্টিং কুরুথ? ");
INSERT INTO sanben_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","যং যীশুং যূযং পরকরেষু সমার্পযত ততো যং পীলাতো মোচযিতুম্ এैচ্ছৎ তথাপি যূযং তস্য সাক্ষান্ নাঙ্গীকৃতৱন্ত ইব্রাহীম ইস্হাকো যাকূবশ্চেশ্ৱরোঽর্থাদ্ অস্মাকং পূর্ৱ্ৱপুরুষাণাম্ ঈশ্ৱরঃ স্ৱপুত্রস্য তস্য যীশো র্মহিমানং প্রাকাশযৎ| ");
INSERT INTO sanben_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","কিন্তু যূযং তং পৱিত্রং ধার্ম্মিকং পুমাংসং নাঙ্গীকৃত্য হত্যাকারিণমেকং স্ৱেভ্যো দাতুম্ অযাচধ্ৱং| ");
INSERT INTO sanben_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","পশ্চাৎ তং জীৱনস্যাধিপতিম্ অহত কিন্ত্ৱীশ্ৱরঃ শ্মশানাৎ তম্ উদস্থাপযত তত্র ৱযং সাক্ষিণ আস্মহে| ");
INSERT INTO sanben_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ইমং যং মানুষং যূযং পশ্যথ পরিচিনুথ চ স তস্য নাম্নি ৱিশ্ৱাসকরণাৎ চলনশক্তিং লব্ধৱান্ তস্মিন্ তস্য যো ৱিশ্ৱাসঃ স তং যুষ্মাকং সর্ৱ্ৱেষাং সাক্ষাৎ সম্পূর্ণরূপেণ স্ৱস্থম্ অকার্ষীৎ| ");
INSERT INTO sanben_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","হে ভ্রাতরো যূযং যুষ্মাকম্ অধিপতযশ্চ অজ্ঞাৎৱা কর্ম্মাণ্যেতানি কৃতৱন্ত ইদানীং মমৈষ বোধো জাযতে| ");
INSERT INTO sanben_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","কিন্ত্ৱীশ্ৱরঃ খ্রীষ্টস্য দুঃখভোগে ভৱিষ্যদ্ৱাদিনাং মুখেভ্যো যাং যাং কথাং পূর্ৱ্ৱমকথযৎ তাঃ কথা ইত্থং সিদ্ধা অকরোৎ| ");
INSERT INTO sanben_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","অতঃ স্ৱেষাং পাপমোচনার্থং খেদং কৃৎৱা মনাংসি পরিৱর্ত্তযধ্ৱং, তস্মাদ্ ঈশ্ৱরাৎ সান্ত্ৱনাপ্রাপ্তেঃ সময উপস্থাস্যতি; ");
INSERT INTO sanben_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","পুনশ্চ পূর্ৱ্ৱকালম্ আরভ্য প্রচারিতো যো যীশুখ্রীষ্টস্তম্ ঈশ্ৱরো যুষ্মান্ প্রতি প্রেষযিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","কিন্তু জগতঃ সৃষ্টিমারভ্য ঈশ্ৱরো নিজপৱিত্রভৱিষ্যদ্ৱাদিগণোন যথা কথিতৱান্ তদনুসারেণ সর্ৱ্ৱেষাং কার্য্যাণাং সিদ্ধিপর্য্যন্তং তেন স্ৱর্গে ৱাসঃ কর্ত্তৱ্যঃ| ");
INSERT INTO sanben_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","যুষ্মাকং প্রভুঃ পরমেশ্ৱরো যুষ্মাকং ভ্রাতৃগণমধ্যাৎ মৎসদৃশং ভৱিষ্যদ্ৱক্তারম্ উৎপাদযিষ্যতি, ততঃ স যৎ কিঞ্চিৎ কথযিষ্যতি তত্র যূযং মনাংসি নিধদ্ধ্ৱং| ");
INSERT INTO sanben_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","কিন্তু যঃ কশ্চিৎ প্রাণী তস্য ভৱিষ্যদ্ৱাদিনঃ কথাং ন গ্রহীষ্যতি স নিজলোকানাং মধ্যাদ্ উচ্ছেৎস্যতে,\" ইমাং কথাম্ অস্মাকং পূর্ৱ্ৱপুরুষেভ্যঃ কেৱলো মূসাঃ কথযামাস ইতি নহি, ");
INSERT INTO sanben_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","শিমূযেল্ভৱিষ্যদ্ৱাদিনম্ আরভ্য যাৱন্তো ভৱিষ্যদ্ৱাক্যম্ অকথযন্ তে সর্ৱ্ৱএৱ সমযস্যৈতস্য কথাম্ অকথযন্| ");
INSERT INTO sanben_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","যূযমপি তেষাং ভৱিষ্যদ্ৱাদিনাং সন্তানাঃ, \"তৱ ৱংশোদ্ভৱপুংসা সর্ৱ্ৱদেশীযা লোকা আশিষং প্রাপ্তা ভৱিষ্যন্তি\", ইব্রাহীমে কথামেতাং কথযিৎৱা ঈশ্ৱরোস্মাকং পূর্ৱ্ৱপুরুষৈঃ সার্দ্ধং যং নিযমং স্থিরীকৃতৱান্ তস্য নিযমস্যাধিকারিণোপি যূযং ভৱথ| ");
INSERT INTO sanben_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","অত ঈশ্ৱরো নিজপুত্রং যীশুম্ উত্থাপ্য যুষ্মাকং সর্ৱ্ৱেষাং স্ৱস্ৱপাপাৎ পরাৱর্ত্ত্য যুষ্মভ্যম্ আশিষং দাতুং প্রথমতস্তং যুষ্মাকং নিকটং প্রেষিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","যস্মিন্ সমযে পিতরযোহনৌ লোকান্ উপদিশতস্তস্মিন্ সমযে যাজকা মন্দিরস্য সেনাপতযঃ সিদূকীগণশ্চ ");
INSERT INTO sanben_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","তযোর্ উপদেশকরণে খ্রীষ্টস্যোত্থানম্ উপলক্ষ্য সর্ৱ্ৱেষাং মৃতানাম্ উত্থানপ্রস্তাৱে চ ৱ্যগ্রাঃ সন্তস্তাৱুপাগমন্| ");
INSERT INTO sanben_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","তৌ ধৃৎৱা দিনাৱসানকারণাৎ পরদিনপর্য্যনন্তং রুদ্ধ্ৱা স্থাপিতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","তথাপি যে লোকাস্তযোরুপদেশম্ অশৃণ্ৱন্ তেষাং প্রাযেণ পঞ্চসহস্রাণি জনা ৱ্যশ্ৱসন্| ");
INSERT INTO sanben_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","পরেঽহনি অধিপতযঃ প্রাচীনা অধ্যাপকাশ্চ হানননামা মহাযাজকঃ ");
INSERT INTO sanben_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","কিযফা যোহন্ সিকন্দর ইত্যাদযো মহাযাজকস্য জ্ঞাতযঃ সর্ৱ্ৱে যিরূশালম্নগরে মিলিতাঃ| ");
INSERT INTO sanben_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","অনন্তরং প্রেরিতৌ মধ্যে স্থাপযিৎৱাপৃচ্ছন্ যুৱাং কযা শক্তযা ৱা কেন নাম্না কর্ম্মাণ্যেতানি কুরুথঃ? ");
INSERT INTO sanben_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","তদা পিতরঃ পৱিত্রেণাত্মনা পরিপূর্ণঃ সন্ প্রত্যৱাদীৎ, হে লোকানাম্ অধিপতিগণ হে ইস্রাযেলীযপ্রাচীনাঃ, ");
INSERT INTO sanben_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","এতস্য দুর্ব্বলমানুষস্য হিতং যৎ কর্ম্মাক্রিযত, অর্থাৎ, স যেন প্রকারেণ স্ৱস্থোভৱৎ তচ্চেদ্ অদ্যাৱাং পৃচ্ছথ, ");
INSERT INTO sanben_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","তর্হি সর্ৱ্ৱ ইস্রাযেेলীযলোকা যূযং জানীত নাসরতীযো যো যীশুখ্রীষ্টঃ ক্রুশে যুষ্মাভিরৱিধ্যত যশ্চেশ্ৱরেণ শ্মশানাদ্ উত্থাপিতঃ, তস্য নাম্না জনোযং স্ৱস্থঃ সন্ যুষ্মাকং সম্মুখে প্রোত্তিষ্ঠতি| ");
INSERT INTO sanben_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","নিচেতৃভি র্যুষ্মাভিরযং যঃ প্রস্তরোঽৱজ্ঞাতোঽভৱৎ স প্রধানকোণস্য প্রস্তরোঽভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","তদ্ভিন্নাদপরাৎ কস্মাদপি পরিত্রাণং ভৱিতুং ন শক্নোতি, যেন ত্রাণং প্রাপ্যেত ভূমণ্ডলস্যলোকানাং মধ্যে তাদৃশং কিমপি নাম নাস্তি| ");
INSERT INTO sanben_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","তদা পিতরযোহনোরেতাদৃশীম্ অক্ষেভতাং দৃষ্ট্ৱা তাৱৱিদ্ৱাংসৌ নীচলোকাৱিতি বুদ্ধ্ৱা আশ্চর্য্যম্ অমন্যন্ত তৌ চ যীশোঃ সঙ্গিনৌ জাতাৱিতি জ্ঞাতুম্ অশক্নুৱন্| ");
INSERT INTO sanben_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","কিন্তু তাভ্যাং সার্দ্ধং তং স্ৱস্থমানুষং তিষ্ঠন্তং দৃষ্ট্ৱা তে কামপ্যপরাম্ আপত্তিং কর্ত্তং নাশক্নুন্| ");
INSERT INTO sanben_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","তদা তে সভাতঃ স্থানান্তরং গন্তুং তান্ আজ্ঞাপ্য স্ৱযং পরস্পরম্ ইতি মন্ত্রণামকুর্ৱ্ৱন্ ");
INSERT INTO sanben_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","তৌ মানৱৌ প্রতি কিং কর্ত্তৱ্যং? তাৱেকং প্রসিদ্ধম্ আশ্চর্য্যং কর্ম্ম কৃতৱন্তৌ তদ্ যিরূশালম্নিৱাসিনাং সর্ৱ্ৱেষাং লোকানাং সমীপে প্রাকাশত তচ্চ ৱযমপহ্নোতুং ন শক্নুমঃ| ");
INSERT INTO sanben_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","কিন্তু লোকানাং মধ্যম্ এতদ্ যথা ন ৱ্যাপ্নোতি তদর্থং তৌ ভযং প্রদর্শ্য তেন নাম্না কমপি মনুষ্যং নোপদিশতম্ ইতি দৃঢং নিষেধামঃ| ");
INSERT INTO sanben_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","ততস্তে প্রেরিতাৱাহূয এতদাজ্ঞাপযন্ ইতঃ পরং যীশো র্নাম্না কদাপি কামপি কথাং মা কথযতং কিমপি নোপদিশঞ্চ| ");
INSERT INTO sanben_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","ততঃ পিতরযোহনৌ প্রত্যৱদতাম্ ঈশ্ৱরস্যাজ্ঞাগ্রহণং ৱা যুষ্মাকম্ আজ্ঞাগ্রহণম্ এতযো র্মধ্যে ঈশ্ৱরস্য গোচরে কিং ৱিহিতং? যূযং তস্য ৱিৱেচনাং কুরুত| ");
INSERT INTO sanben_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","ৱযং যদ্ অপশ্যাম যদশৃণুম চ তন্ন প্রচারযিষ্যাম এতৎ কদাপি ভৱিতুং ন শক্নোতি| ");
INSERT INTO sanben_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","যদঘটত তদ্ দৃষ্টা সর্ৱ্ৱে লোকা ঈশ্ৱরস্য গুণান্ অন্ৱৱদন্ তস্মাৎ লোকভযাৎ তৌ দণ্ডযিতুং কমপ্যুপাযং ন প্রাপ্য তে পুনরপি তর্জযিৎৱা তাৱত্যজন্| ");
INSERT INTO sanben_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","যস্য মানুষস্যৈতৎ স্ৱাস্থ্যকরণম্ আশ্চর্য্যং কর্ম্মাক্রিযত তস্য ৱযশ্চৎৱারিংশদ্ৱৎসরা ৱ্যতীতাঃ| ");
INSERT INTO sanben_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","ততঃ পরং তৌ ৱিসৃষ্টৌ সন্তৌ স্ৱসঙ্গিনাং সন্নিধিং গৎৱা প্রধানযাজকৈঃ প্রাচীনলোকৈশ্চ প্রোক্তাঃ সর্ৱ্ৱাঃ কথা জ্ঞাপিতৱন্তৌ| ");
INSERT INTO sanben_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","তচ্ছ্রুৎৱা সর্ৱ্ৱ একচিত্তীভূয ঈশ্ৱরমুদ্দিশ্য প্রোচ্চৈরেতৎ প্রার্থযন্ত, হে প্রভো গগণপৃথিৱীপযোধীনাং তেষু চ যদ্যদ্ আস্তে তেষাং স্রষ্টেশ্ৱরস্ত্ৱং| ");
INSERT INTO sanben_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ৎৱং নিজসেৱকেন দাযূদা ৱাক্যমিদম্ উৱচিথ, মনুষ্যা অন্যদেশীযাঃ কুর্ৱ্ৱন্তি কলহং কুতঃ| লোকাঃ সর্ৱ্ৱে কিমর্থং ৱা চিন্তাং কুর্ৱ্ৱন্তি নিষ্ফলাং| ");
INSERT INTO sanben_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","পরমেশস্য তেনৈৱাভিষিক্তস্য জনস্য চ| ৱিরুদ্ধমভিতিষ্ঠন্তি পৃথিৱ্যাঃ পতযঃ কুতঃ|| ");
INSERT INTO sanben_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","ফলতস্তৱ হস্তেন মন্ত্রণযা চ পূর্ৱ্ৱ যদ্যৎ স্থিরীকৃতং তদ্ যথা সিদ্ধং ভৱতি তদর্থং ৎৱং যম্ অথিষিক্তৱান্ স এৱ পৱিত্রো যীশুস্তস্য প্রাতিকূল্যেন হেরোদ্ পন্তীযপীলাতো ");
INSERT INTO sanben_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ঽন্যদেশীযলোকা ইস্রাযেল্লোকাশ্চ সর্ৱ্ৱ এতে সভাযাম্ অতিষ্ঠন্| ");
INSERT INTO sanben_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","হে পরমেশ্ৱর অধুনা তেষাং তর্জনং গর্জনঞ্চ শৃণু; ");
INSERT INTO sanben_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","তথা স্ৱাস্থ্যকরণকর্ম্মণা তৱ বাহুবলপ্রকাশপূর্ৱ্ৱকং তৱ সেৱকান্ নির্ভযেন তৱ ৱাক্যং প্রচারযিতুং তৱ পৱিত্রপুত্রস্য যীশো র্নাম্না আশ্চর্য্যাণ্যসম্ভৱানি চ কর্ম্মাণি কর্ত্তুঞ্চাজ্ঞাপয| ");
INSERT INTO sanben_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ইত্থং প্রার্থনযা যত্র স্থানে তে সভাযাম্ আসন্ তৎ স্থানং প্রাকম্পত; ততঃ সর্ৱ্ৱে পৱিত্রেণাত্মনা পরিপূর্ণাঃ সন্ত ঈশ্ৱরস্য কথাম্ অক্ষোভেণ প্রাচারযন্| ");
INSERT INTO sanben_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","অপরঞ্চ প্রত্যযকারিলোকসমূহা একমনস একচিত্তীভূয স্থিতাঃ| তেষাং কেপি নিজসম্পত্তিং স্ৱীযাং নাজানন্ কিন্তু তেষাং সর্ৱ্ৱাঃ সম্পত্ত্যঃ সাধারণ্যেন স্থিতাঃ| ");
INSERT INTO sanben_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","অন্যচ্চ প্রেরিতা মহাশক্তিপ্রকাশপূর্ৱ্ৱকং প্রভো র্যীশোরুত্থানে সাক্ষ্যম্ অদদুঃ, তেষু সর্ৱ্ৱেষু মহানুগ্রহোঽভৱচ্চ| ");
INSERT INTO sanben_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","তেষাং মধ্যে কস্যাপি দ্রৱ্যন্যূনতা নাভৱদ্ যতস্তেষাং গৃহভূম্যাদ্যা যাঃ সম্পত্তয আসন্ তা ৱিক্রীয ");
INSERT INTO sanben_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","তন্মূল্যমানীয প্রেরিতানাং চরণেষু তৈঃ স্থাপিতং; ততঃ প্রত্যেকশঃ প্রযোজনানুসারেণ দত্তমভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","ৱিশেষতঃ কুপ্রোপদ্ৱীপীযো যোসিনামকো লেৱিৱংশজাত একো জনো ভূম্যধিকারী, যং প্রেরিতা বর্ণব্বা অর্থাৎ সান্ত্ৱনাদাযক ইত্যুক্ত্ৱা সমাহূযন্, ");
INSERT INTO sanben_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","স জনো নিজভূমিং ৱিক্রীয তন্মূল্যমানীয প্রেরিতানাং চরণেষু স্থাপিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","তদা অনানিযনামক একো জনো যস্য ভার্য্যাযা নাম সফীরা স স্ৱাধিকারং ৱিক্রীয ");
INSERT INTO sanben_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","স্ৱভার্য্যাং জ্ঞাপযিৎৱা তন্মূল্যস্যৈকাংশং সঙ্গোপ্য স্থাপযিৎৱা তদন্যাংশমাত্রমানীয প্রেরিতানাং চরণেষু সমর্পিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","তস্মাৎ পিতরোকথযৎ হে অনানিয ভূমে র্মূল্যং কিঞ্চিৎ সঙ্গোপ্য স্থাপযিতুং পৱিত্রস্যাত্মনঃ সন্নিধৌ মৃষাৱাক্যং কথযিতুঞ্চ শৈতান্ কুতস্তৱান্তঃকরণে প্রৱৃত্তিমজনযৎ? ");
INSERT INTO sanben_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","সা ভূমি র্যদা তৱ হস্তগতা তদা কিং তৱ স্ৱীযা নাসীৎ? তর্হি স্ৱান্তঃকরণে কুত এতাদৃশী কুকল্পনা ৎৱযা কৃতা? ৎৱং কেৱলমনুষ্যস্য নিকটে মৃষাৱাক্যং নাৱাদীঃ কিন্ত্ৱীশ্ৱরস্য নিকটেঽপি| ");
INSERT INTO sanben_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","এতাং কথাং শ্রুৎৱৈৱ সোঽনানিযো ভূমৌ পতন্ প্রাণান্ অত্যজৎ, তদ্ৱৃত্তান্তং যাৱন্তো লোকা অশৃণ্ৱন্ তেষাং সর্ৱ্ৱেষাং মহাভযম্ অজাযৎ| ");
INSERT INTO sanben_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","তদা যুৱলোকাস্তং ৱস্ত্রেণাচ্ছাদ্য বহি র্নীৎৱা শ্মশানেঽস্থাপযন্| ");
INSERT INTO sanben_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","ততঃ প্রহরৈকানন্তরং কিং ৱৃত্তং তন্নাৱগত্য তস্য ভার্য্যাপি তত্র সমুপস্থিতা| ");
INSERT INTO sanben_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ততঃ পিতরস্তাম্ অপৃচ্ছৎ, যুৱাভ্যাম্ এতাৱন্মুদ্রাভ্যো ভূমি র্ৱিক্রীতা ন ৱা? এতৎৱং ৱদ; তদা সা প্রত্যৱাদীৎ সত্যম্ এতাৱদ্ভ্যো মুদ্রাভ্য এৱ| ");
INSERT INTO sanben_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ততঃ পিতরোকথযৎ যুৱাং কথং পরমেশ্ৱরস্যাত্মানং পরীক্ষিতুম্ একমন্ত্রণাৱভৱতাং? পশ্য যে তৱ পতিং শ্মশানে স্থাপিতৱন্তস্তে দ্ৱারস্য সমীপে সমুপতিষ্ঠন্তি ৎৱামপি বহির্নেষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","ততঃ সাপি তস্য চরণসন্নিধৌ পতিৎৱা প্রাণান্ অত্যাক্ষীৎ| পশ্চাৎ তে যুৱানোঽভ্যন্তরম্ আগত্য তামপি মৃতাং দৃষ্ট্ৱা বহি র্নীৎৱা তস্যাঃ পত্যুঃ পার্শ্ৱে শ্মশানে স্থাপিতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","তস্মাৎ মণ্ডল্যাঃ সর্ৱ্ৱে লোকা অন্যলোকাশ্চ তাং ৱার্ত্তাং শ্রুৎৱা সাধ্ৱসং গতাঃ| ");
INSERT INTO sanben_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","ততঃ পরং প্রেরিতানাং হস্তৈ র্লোকানাং মধ্যে বহ্ৱাশ্চর্য্যাণ্যদ্ভুতানি কর্ম্মাণ্যক্রিযন্ত; তদা শিষ্যাঃ সর্ৱ্ৱ একচিত্তীভূয সুলেমানো ঽলিন্দে সম্ভূযাসন্| ");
INSERT INTO sanben_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","তেষাং সঙ্ঘান্তর্গো ভৱিতুং কোপি প্রগল্ভতাং নাগমৎ কিন্তু লোকাস্তান্ সমাদ্রিযন্ত| ");
INSERT INTO sanben_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","স্ত্রিযঃ পুরুষাশ্চ বহৱো লোকা ৱিশ্ৱাস্য প্রভুং শরণমাপন্নাঃ| ");
INSERT INTO sanben_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","পিতরস্য গমনাগমনাভ্যাং কেনাপি প্রকারেণ তস্য ছাযা কস্মিংশ্চিজ্জনে লগিষ্যতীত্যাশযা লোকা রোগিণঃ শিৱিকযা খট্ৱযা চানীয পথি পথি স্থাপিতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","চতুর্দিক্স্থনগরেভ্যো বহৱো লোকাঃ সম্ভূয রোগিণোঽপৱিত্রভুতগ্রস্তাংশ্চ যিরূশালমম্ আনযন্ ততঃ সর্ৱ্ৱে স্ৱস্থা অক্রিযন্ত| ");
INSERT INTO sanben_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","অনন্তরং মহাযাজকঃ সিদূকিনাং মতগ্রাহিণস্তেষাং সহচরাশ্চ ");
INSERT INTO sanben_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","মহাক্রোধান্ত্ৱিতাঃ সন্তঃ প্রেরিতান্ ধৃৎৱা নীচলোকানাং কারাযাং বদ্ধ্ৱা স্থাপিতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","কিন্তু রাত্রৌ পরমেশ্ৱরস্য দূতঃ কারাযা দ্ৱারং মোচযিৎৱা তান্ বহিরানীযাকথযৎ, ");
INSERT INTO sanben_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","যূযং গৎৱা মন্দিরে দণ্ডাযমানাঃ সন্তো লোকান্ প্রতীমাং জীৱনদাযিকাং সর্ৱ্ৱাং কথাং প্রচারযত| ");
INSERT INTO sanben_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ইতি শ্রুৎৱা তে প্রত্যূষে মন্দির উপস্থায উপদিষ্টৱন্তঃ| তদা সহচরগণেন সহিতো মহাযাজক আগত্য মন্ত্রিগণম্ ইস্রাযেল্ৱংশস্য সর্ৱ্ৱান্ রাজসভাসদঃ সভাস্থান্ কৃৎৱা কারাযাস্তান্ আপযিতুং পদাতিগণং প্রেরিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","ততস্তে গৎৱা কারাযাং তান্ অপ্রাপ্য প্রত্যাগত্য ইতি ৱার্ত্তাম্ অৱাদিষুঃ, ");
INSERT INTO sanben_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ৱযং তত্র গৎৱা নির্ৱ্ৱিঘ্নং কারাযা দ্ৱারং রুদ্ধং রক্ষকাংশ্চ দ্ৱারস্য বহির্দণ্ডাযমানান্ অদর্শাম এৱ কিন্তু দ্ৱারং মোচযিৎৱা তন্মধ্যে কমপি দ্রষ্টুং ন প্রাপ্তাঃ| ");
INSERT INTO sanben_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","এতাং কথাং শ্রুৎৱা মহাযাজকো মন্দিরস্য সেনাপতিঃ প্রধানযাজকাশ্চ, ইত পরং কিমপরং ভৱিষ্যতীতি চিন্তযিৎৱা সন্দিগ্ধচিত্তা অভৱন্| ");
INSERT INTO sanben_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","এতস্মিন্নেৱ সমযে কশ্চিৎ জন আগত্য ৱার্ত্তামেতাম্ অৱদৎ পশ্যত যূযং যান্ মানৱান্ কারাযাম্ অস্থাপযত তে মন্দিরে তিষ্ঠন্তো লোকান্ উপদিশন্তি| ");
INSERT INTO sanben_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","তদা মন্দিরস্য সেনাপতিঃ পদাতযশ্চ তত্র গৎৱা চেল্লোকাঃ পাষাণান্ নিক্ষিপ্যাস্মান্ মারযন্তীতি ভিযা ৱিনত্যাচারং তান্ আনযন্| ");
INSERT INTO sanben_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","তে মহাসভাযা মধ্যে তান্ অস্থাপযন্ ততঃ পরং মহাযাজকস্তান্ অপৃচ্ছৎ, ");
INSERT INTO sanben_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","অনেন নাম্না সমুপদেষ্টুং ৱযং কিং দৃঢং ন ন্যষেধাম? তথাপি পশ্যত যূযং স্ৱেষাং তেনোপদেশেনে যিরূশালমং পরিপূর্ণং কৃৎৱা তস্য জনস্য রক্তপাতজনিতাপরাধম্ অস্মান্ প্রত্যানেতুং চেষ্টধ্ৱে| ");
INSERT INTO sanben_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","ততঃ পিতরোন্যপ্রেরিতাশ্চ প্রত্যৱদন্ মানুষস্যাজ্ঞাগ্রহণাদ্ ঈশ্ৱরস্যাজ্ঞাগ্রহণম্ অস্মাকমুচিতম্| ");
INSERT INTO sanben_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","যং যীশুং যূযং ক্রুশে ৱেধিৎৱাহত তম্ অস্মাকং পৈতৃক ঈশ্ৱর উত্থাপ্য ");
INSERT INTO sanben_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ইস্রাযেল্ৱংশানাং মনঃপরিৱর্ত্তনং পাপক্ষমাঞ্চ কর্ত্তুং রাজানং পরিত্রাতারঞ্চ কৃৎৱা স্ৱদক্ষিণপার্শ্ৱে তস্যান্নতিম্ অকরোৎ| ");
INSERT INTO sanben_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","এতস্মিন্ ৱযমপি সাক্ষিণ আস্মহে, তৎ কেৱলং নহি, ঈশ্ৱর আজ্ঞাগ্রাহিভ্যো যং পৱিত্রম্ আত্মনং দত্তৱান্ সোপি সাক্ষ্যস্তি| ");
INSERT INTO sanben_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","এতদ্ৱাক্যে শ্রুতে তেষাং হৃদযানি ৱিদ্ধান্যভৱন্ ততস্তে তান্ হন্তুং মন্ত্রিতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","এতস্মিন্নেৱ সমযে তৎসভাস্থানাং সর্ৱ্ৱলোকানাং মধ্যে সুখ্যাতো গমিলীযেল্নামক একো জনো ৱ্যৱস্থাপকঃ ফিরূশিলোক উত্থায প্রেরিতান্ ক্ষণার্থং স্থানান্তরং গন্তুম্ আদিশ্য কথিতৱান্, ");
INSERT INTO sanben_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","হে ইস্রাযেল্ৱংশীযাঃ সর্ৱ্ৱে যূযম্ এতান্ মানুষান্ প্রতি যৎ কর্ত্তুম্ উদ্যতাস্তস্মিন্ সাৱধানা ভৱত| ");
INSERT INTO sanben_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","ইতঃ পূর্ৱ্ৱং থূদানামৈকো জন উপস্থায স্ৱং কমপি মহাপুরুষম্ অৱদৎ, ততঃ প্রাযেণ চতুঃশতলোকাস্তস্য মতগ্রাহিণোভৱন্ পশ্চাৎ স হতোভৱৎ তস্যাজ্ঞাগ্রাহিণো যাৱন্তো লোকাস্তে সর্ৱ্ৱে ৱির্কীর্ণাঃ সন্তো ঽকৃতকার্য্যা অভৱন্| ");
INSERT INTO sanben_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","তস্মাজ্জনাৎ পরং নামলেখনসমযে গালীলীযযিহূদানামৈকো জন উপস্থায বহূল্লোকান্ স্ৱমতং গ্রাহীতৱান্ ততঃ সোপি ৱ্যনশ্যৎ তস্যাজ্ঞাগ্রাহিণো যাৱন্তো লোকা আসন্ তে সর্ৱ্ৱে ৱিকীর্ণা অভৱন্| ");
INSERT INTO sanben_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","অধুনা ৱদামি, যূযম্ এতান্ মনুষ্যান্ প্রতি কিমপি ন কৃৎৱা ক্ষান্তা ভৱত, যত এষ সঙ্কল্প এতৎ কর্ম্ম চ যদি মনুষ্যাদভৱৎ তর্হি ৱিফলং ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","যদীশ্ৱরাদভৱৎ তর্হি যূযং তস্যান্যথা কর্ত্তুং ন শক্ষ্যথ, ৱরম্ ঈশ্ৱররোধকা ভৱিষ্যথ| ");
INSERT INTO sanben_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","তদা তস্য মন্ত্রণাং স্ৱীকৃত্য তে প্রেরিতান্ আহূয প্রহৃত্য যীশো র্নাম্না কামপি কথাং কথযিতুং নিষিধ্য ৱ্যসর্জন্| ");
INSERT INTO sanben_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","কিন্তু তস্য নামার্থং ৱযং লজ্জাভোগস্য যোগ্যৎৱেন গণিতা ইত্যত্র তে সানন্দাঃ সন্তঃ সভাস্থানাং সাক্ষাদ্ অগচ্ছন্| ");
INSERT INTO sanben_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ততঃ পরং প্রতিদিনং মন্দিরে গৃহে গৃহে চাৱিশ্রামম্ উপদিশ্য যীশুখ্রীষ্টস্য সুসংৱাদং প্রচারিতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","তস্মিন্ সমযে শিষ্যাণাং বাহুল্যাৎ প্রাত্যহিকদানস্য ৱিশ্রাণনৈ র্ভিন্নদেশীযানাং ৱিধৱাস্ত্রীগণ উপেক্ষিতে সতি ইব্রীযলোকৈঃ সহান্যদেশীযানাং ৱিৱাদ উপাতিষ্ঠৎ| ");
INSERT INTO sanben_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","তদা দ্ৱাদশপ্রেরিতাঃ সর্ৱ্ৱান্ শিষ্যান্ সংগৃহ্যাকথযন্ ঈশ্ৱরস্য কথাপ্রচারং পরিত্যজ্য ভোজনগৱেষণম্ অস্মাকম্ উচিতং নহি| ");
INSERT INTO sanben_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","অতো হে ভ্রাতৃগণ ৱযম্ এতৎকর্ম্মণো ভারং যেভ্যো দাতুং শক্নুম এতাদৃশান্ সুখ্যাত্যাপন্নান্ পৱিত্রেণাত্মনা জ্ঞানেন চ পূর্ণান্ সপ্প্রজনান্ যূযং স্ৱেষাং মধ্যে মনোনীতান্ কুরুত, ");
INSERT INTO sanben_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","কিন্তু ৱযং প্রার্থনাযাং কথাপ্রচারকর্ম্মণি চ নিত্যপ্রৱৃত্তাঃ স্থাস্যামঃ| ");
INSERT INTO sanben_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","এতস্যাং কথাযাং সর্ৱ্ৱে লোকাঃ সন্তুষ্টাঃ সন্তঃ স্ৱেষাং মধ্যাৎ স্তিফানঃ ফিলিপঃ প্রখরো নিকানোর্ তীমন্ পর্ম্মিণা যিহূদিমতগ্রাহী-আন্তিযখিযানগরীযো নিকলা এতান্ পরমভক্তান্ পৱিত্রেণাত্মনা পরিপূর্ণান্ সপ্ত জনান্ ");
INSERT INTO sanben_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","প্রেরিতানাং সমক্ষম্ আনযন্, ততস্তে প্রার্থনাং কৃৎৱা তেষাং শিরঃসু হস্তান্ আর্পযন্| ");
INSERT INTO sanben_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","অপরঞ্চ ঈশ্ৱরস্য কথা দেশং ৱ্যাপ্নোৎ ৱিশেষতো যিরূশালমি নগরে শিষ্যাণাং সংখ্যা প্রভূতরূপেণাৱর্দ্ধত যাজকানাং মধ্যেপি বহৱঃ খ্রীষ্টমতগ্রাহিণোঽভৱন্| ");
INSERT INTO sanben_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","স্তিফানোे ৱিশ্ৱাসেন পরাক্রমেণ চ পরিপূর্ণঃ সন্ লোকানাং মধ্যে বহুৱিধম্ অদ্ভুতম্ আশ্চর্য্যং কর্ম্মাকরোৎ| ");
INSERT INTO sanben_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","তেন লিবর্ত্তিনীযনাম্না ৱিখ্যাতসঙ্ঘস্য কতিপযজনাঃ কুরীণীযসিকন্দরীয-কিলিকীযাশীযাদেশীযাঃ কিযন্তো জনাশ্চোত্থায স্তিফানেন সার্দ্ধং ৱ্যৱদন্ত| ");
INSERT INTO sanben_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","কিন্তু স্তিফানো জ্ঞানেন পৱিত্রেণাত্মনা চ ঈদৃশীং কথাং কথিতৱান্ যস্যাস্তে আপত্তিং কর্ত্তুং নাশক্নুৱন্| ");
INSERT INTO sanben_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","পশ্চাৎ তৈ র্লোভিতাঃ কতিপযজনাঃ কথামেনাম্ অকথযন্, ৱযং তস্য মুখতো মূসা ঈশ্ৱরস্য চ নিন্দাৱাক্যম্ অশ্রৌষ্ম| ");
INSERT INTO sanben_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","তে লোকানাং লোকপ্রাচীনানাম্ অধ্যাপকানাঞ্চ প্রৱৃত্তিং জনযিৎৱা স্তিফানস্য সন্নিধিম্ আগত্য তং ধৃৎৱা মহাসভামধ্যম্ আনযন্| ");
INSERT INTO sanben_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","তদনন্তরং কতিপযজনেষু মিথ্যাসাক্ষিষু সমানীতেষু তেঽকথযন্ এষ জন এতৎপুণ্যস্থানৱ্যৱস্থযো র্নিন্দাতঃ কদাপি ন নিৱর্ত্ততে| ");
INSERT INTO sanben_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ফলতো নাসরতীযযীশুঃ স্থানমেতদ্ উচ্ছিন্নং করিষ্যতি মূসাসমর্পিতম্ অস্মাকং ৱ্যৱহরণম্ অন্যরূপং করিষ্যতি তস্যৈতাদৃশীং কথাং ৱযম্ অশৃণুম| ");
INSERT INTO sanben_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","তদা মহাসভাস্থাঃ সর্ৱ্ৱে তং প্রতি স্থিরাং দৃষ্টিং কৃৎৱা স্ৱর্গদূতমুখসদৃশং তস্য মুখম্ অপশ্যন্| ");
INSERT INTO sanben_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ততঃ পরং মহাযাজকঃ পৃষ্টৱান্, এষা কথাং কিং সত্যা? ");
INSERT INTO sanben_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","ততঃ স প্রত্যৱদৎ, হে পিতরো হে ভ্রাতরঃ সর্ৱ্ৱে লাকা মনাংসি নিধদ্ধ্ৱং| অস্মাকং পূর্ৱ্ৱপুরুষ ইব্রাহীম্ হারণ্নগরে ৱাসকরণাৎ পূর্ৱ্ৱং যদা অরাম্-নহরযিমদেশে আসীৎ তদা তেজোময ঈশ্ৱরো দর্শনং দৎৱা ");
INSERT INTO sanben_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","তমৱদৎ ৎৱং স্ৱদেশজ্ঞাতিমিত্রাণি পরিত্যজ্য যং দেশমহং দর্শযিষ্যামি তং দেশং ৱ্রজ| ");
INSERT INTO sanben_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","অতঃ স কস্দীযদেশং ৱিহায হারণ্নগরে ন্যৱসৎ, তদনন্তরং তস্য পিতরি মৃতে যত্র দেশে যূযং নিৱসথ স এনং দেশমাগচ্ছৎ| ");
INSERT INTO sanben_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","কিন্ত্ৱীশ্ৱরস্তস্মৈ কমপ্যধিকারম্ অর্থাদ্ একপদপরিমিতাং ভূমিমপি নাদদাৎ; তদা তস্য কোপি সন্তানো নাসীৎ তথাপি সন্তানৈঃ সার্দ্ধম্ এতস্য দেশস্যাধিকারী ৎৱং ভৱিষ্যসীতি তম্প্রত্যঙ্গীকৃতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ঈশ্ৱর ইত্থম্ অপরমপি কথিতৱান্ তৱ সন্তানাঃ পরদেশে নিৱৎস্যন্তি ততস্তদ্দেশীযলোকাশ্চতুঃশতৱৎসরান্ যাৱৎ তান্ দাসৎৱে স্থাপযিৎৱা তান্ প্রতি কুৱ্যৱহারং করিষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","অপরম্ ঈশ্ৱর এনাং কথামপি কথিতৱান্, যে লোকাস্তান্ দাসৎৱে স্থাপযিষ্যন্তি তাল্লোকান্ অহং দণ্ডযিষ্যামি, ততঃ পরং তে বহির্গতাঃ সন্তো মাম্ অত্র স্থানে সেৱিষ্যন্তে| ");
INSERT INTO sanben_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","পশ্চাৎ স তস্মৈ ৎৱক্ছেদস্য নিযমং দত্তৱান্, অত ইস্হাকনাম্নি ইব্রাহীম একপুত্রে জাতে, অষ্টমদিনে তস্য ৎৱক্ছেদম্ অকরোৎ| তস্য ইস্হাকঃ পুত্রো যাকূব্, ততস্তস্য যাকূবোঽস্মাকং দ্ৱাদশ পূর্ৱ্ৱপুরুষা অজাযন্ত| ");
INSERT INTO sanben_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","তে পূর্ৱ্ৱপুরুষা ঈর্ষ্যযা পরিপূর্ণা মিসরদেশং প্রেষযিতুং যূষফং ৱ্যক্রীণন্| ");
INSERT INTO sanben_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","কিন্ত্ৱীশ্ৱরস্তস্য সহাযো ভূৎৱা সর্ৱ্ৱস্যা দুর্গতে রক্ষিৎৱা তস্মৈ বুদ্ধিং দত্ত্ৱা মিসরদেশস্য রাজ্ঞঃ ফিরৌণঃ প্রিযপাত্রং কৃতৱান্ ততো রাজা মিসরদেশস্য স্ৱীযসর্ৱ্ৱপরিৱারস্য চ শাসনপদং তস্মৈ দত্তৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","তস্মিন্ সমযে মিসর-কিনানদেশযো র্দুর্ভিক্ষহেতোরতিক্লিষ্টৎৱাৎ নঃ পূর্ৱ্ৱপুরুষা ভক্ষ্যদ্রৱ্যং নালভন্ত| ");
INSERT INTO sanben_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","কিন্তু মিসরদেশে শস্যানি সন্তি, যাকূব্ ইমাং ৱার্ত্তাং শ্রুৎৱা প্রথমম্ অস্মাকং পূর্ৱ্ৱপুরুষান্ মিসরং প্রেষিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ততো দ্ৱিতীযৱারগমনে যূষফ্ স্ৱভ্রাতৃভিঃ পরিচিতোঽভৱৎ; যূষফো ভ্রাতরঃ ফিরৌণ্ রাজেন পরিচিতা অভৱন্| ");
INSERT INTO sanben_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","অনন্তরং যূষফ্ ভ্রাতৃগণং প্রেষ্য নিজপিতরং যাকূবং নিজান্ পঞ্চাধিকসপ্ততিসংখ্যকান্ জ্ঞাতিজনাংশ্চ সমাহূতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","তস্মাদ্ যাকূব্ মিসরদেশং গৎৱা স্ৱযম্ অস্মাকং পূর্ৱ্ৱপুরুষাশ্চ তস্মিন্ স্থানেঽম্রিযন্ত| ");
INSERT INTO sanben_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ততস্তে শিখিমং নীতা যৎ শ্মশানম্ ইব্রাহীম্ মুদ্রাদৎৱা শিখিমঃ পিতু র্হমোরঃ পুত্রেভ্যঃ ক্রীতৱান্ তৎশ্মশানে স্থাপযাঞ্চক্রিরে| ");
INSERT INTO sanben_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","ততঃ পরম্ ঈশ্ৱর ইব্রাহীমঃ সন্নিধৌ শপথং কৃৎৱা যাং প্রতিজ্ঞাং কৃতৱান্ তস্যাঃ প্রতিজ্ঞাযাঃ ফলনসমযে নিকটে সতি ইস্রাযেল্লোকা সিমরদেশে ৱর্দ্ধমানা বহুসংখ্যা অভৱন্| ");
INSERT INTO sanben_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","শেষে যূষফং যো ন পরিচিনোতি তাদৃশ একো নরপতিরুপস্থায ");
INSERT INTO sanben_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","অস্মাকং জ্ঞাতিভিঃ সার্দ্ধং ধূর্ত্ততাং ৱিধায পূর্ৱ্ৱপুরুষান্ প্রতি কুৱ্যৱহরণপূর্ৱ্ৱকং তেষাং ৱংশনাশনায তেষাং নৱজাতান্ শিশূন্ বহি র্নিরক্ষেপযৎ| ");
INSERT INTO sanben_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","এতস্মিন্ সমযে মূসা জজ্ঞে, স তু পরমসুন্দরোঽভৱৎ তথা পিতৃগৃহে মাসত্রযপর্য্যন্তং পালিতোঽভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","কিন্তু তস্মিন্ বহির্নিক্ষিপ্তে সতি ফিরৌণরাজস্য কন্যা তম্ উত্তোল্য নীৎৱা দত্তকপুত্রং কৃৎৱা পালিতৱতী| ");
INSERT INTO sanben_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","তস্মাৎ স মূসা মিসরদেশীযাযাঃ সর্ৱ্ৱৱিদ্যাযাঃ পারদৃষ্ৱা সন্ ৱাক্যে ক্রিযাযাঞ্চ শক্তিমান্ অভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","স সম্পূর্ণচৎৱারিংশদ্ৱৎসরৱযস্কো ভূৎৱা ইস্রাযেলীযৱংশনিজভ্রাতৃন্ সাক্ষাৎ কর্তুং মতিং চক্রে| ");
INSERT INTO sanben_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","তেষাং জনমেকং হিংসিতং দৃষ্ট্ৱা তস্য সপক্ষঃ সন্ হিংসিতজনম্ উপকৃত্য মিসরীযজনং জঘান| ");
INSERT INTO sanben_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","তস্য হস্তেনেশ্ৱরস্তান্ উদ্ধরিষ্যতি তস্য ভ্রাতৃগণ ইতি জ্ঞাস্যতি স ইত্যনুমানং চকার, কিন্তু তে ন বুবুধিরে| ");
INSERT INTO sanben_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","তৎপরে ঽহনি তেষাম্ উভযো র্জনযো র্ৱাক্কলহ উপস্থিতে সতি মূসাঃ সমীপং গৎৱা তযো র্মেলনং কর্ত্তুং মতিং কৃৎৱা কথযামাস, হে মহাশযৌ যুৱাং ভ্রাতরৌ পরস্পরম্ অন্যাযং কুতঃ কুরুথঃ? ");
INSERT INTO sanben_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","ততঃ সমীপৱাসিনং প্রতি যো জনোঽন্যাযং চকার স তং দূরীকৃত্য কথযামাস, অস্মাকমুপরি শাস্তৃৎৱৱিচারযিতৃৎৱপদযোঃ কস্ত্ৱাং নিযুক্তৱান্? ");
INSERT INTO sanben_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","হ্যো যথা মিসরীযং হতৱান্ তথা কিং মামপি হনিষ্যসি? ");
INSERT INTO sanben_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","তদা মূসা এতাদৃশীং কথাং শ্রুৎৱা পলাযনং চক্রে, ততো মিদিযনদেশং গৎৱা প্রৱাসী সন্ তস্থৌ, ততস্তত্র দ্ৱৌ পুত্রৌ জজ্ঞাতে| ");
INSERT INTO sanben_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","অনন্তরং চৎৱারিংশদ্ৱৎসরেষু গতেষু সীনযপর্ৱ্ৱতস্য প্রান্তরে প্রজ্ৱলিতস্তম্বস্য ৱহ্নিশিখাযাং পরমেশ্ৱরদূতস্তস্মৈ দর্শনং দদৌ| ");
INSERT INTO sanben_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","মূসাস্তস্মিন্ দর্শনে ৱিস্মযং মৎৱা ৱিশেষং জ্ঞাতুং নিকটং গচ্ছতি, ");
INSERT INTO sanben_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","এতস্মিন্ সমযে, অহং তৱ পূর্ৱ্ৱপুরুষাণাম্ ঈশ্ৱরোঽর্থাদ্ ইব্রাহীম ঈশ্ৱর ইস্হাক ঈশ্ৱরো যাকূব ঈশ্ৱরশ্চ, মূসামুদ্দিশ্য পরমেশ্ৱরস্যৈতাদৃশী ৱিহাযসীযা ৱাণী বভূৱ, ততঃ স কম্পান্ৱিতঃ সন্ পুন র্নিরীক্ষিতুং প্রগল্ভো ন বভূৱ| ");
INSERT INTO sanben_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","পরমেশ্ৱরস্তং জগাদ, তৱ পাদযোঃ পাদুকে মোচয যত্র তিষ্ঠসি সা পৱিত্রভূমিঃ| ");
INSERT INTO sanben_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","অহং মিসরদেশস্থানাং নিজলোকানাং দুর্দ্দশাং নিতান্তম্ অপশ্যং, তেষাং কাতর্য্যোক্তিঞ্চ শ্রুতৱান্ তস্মাৎ তান্ উদ্ধর্ত্তুম্ অৱরুহ্যাগমম্; ইদানীম্ আগচ্ছ মিসরদেশং ৎৱাং প্রেষযামি| ");
INSERT INTO sanben_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","কস্ত্ৱাং শাস্তৃৎৱৱিচারযিতৃৎৱপদযো র্নিযুক্তৱান্, ইতি ৱাক্যমুক্ত্ৱা তৈ র্যো মূসা অৱজ্ঞাতস্তমেৱ ঈশ্ৱরঃ স্তম্বমধ্যে দর্শনদাত্রা তেন দূতেন শাস্তারং মুক্তিদাতারঞ্চ কৃৎৱা প্রেষযামাস| ");
INSERT INTO sanben_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","স চ মিসরদেশে সূফ্নাম্নি সমুদ্রে চ পশ্চাৎ চৎৱারিংশদ্ৱৎসরান্ যাৱৎ মহাপ্রান্তরে নানাপ্রকারাণ্যদ্ভুতানি কর্ম্মাণি লক্ষণানি চ দর্শযিৎৱা তান্ বহিঃ কৃৎৱা সমানিনায| ");
INSERT INTO sanben_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","প্রভুঃ পরমেশ্ৱরো যুষ্মাকং ভ্রাতৃগণস্য মধ্যে মাদৃশম্ একং ভৱিষ্যদ্ৱক্তারম্ উৎপাদযিষ্যতি তস্য কথাযাং যূযং মনো নিধাস্যথ, যো জন ইস্রাযেলঃ সন্তানেভ্য এনাং কথাং কথযামাস স এষ মূসাঃ| ");
INSERT INTO sanben_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","মহাপ্রান্তরস্থমণ্ডলীমধ্যেঽপি স এৱ সীনযপর্ৱ্ৱতোপরি তেন সার্দ্ধং সংলাপিনো দূতস্য চাস্মৎপিতৃগণস্য মধ্যস্থঃ সন্ অস্মভ্যং দাতৱ্যনি জীৱনদাযকানি ৱাক্যানি লেভে| ");
INSERT INTO sanben_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","অস্মাকং পূর্ৱ্ৱপুরুষাস্তম্ অমান্যং কৎৱা স্ৱেভ্যো দূরীকৃত্য মিসরদেশং পরাৱৃত্য গন্তুং মনোভিরভিলষ্য হারোণং জগদুঃ, ");
INSERT INTO sanben_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","অস্মাকম্ অগ্রেঽগ্রে গন্তুुম্ অস্মদর্থং দেৱগণং নির্ম্মাহি যতো যো মূসা অস্মান্ মিসরদেশাদ্ বহিঃ কৃৎৱানীতৱান্ তস্য কিং জাতং তদস্মাভি র্ন জ্ঞাযতে| ");
INSERT INTO sanben_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","তস্মিন্ সমযে তে গোৱৎসাকৃতিং প্রতিমাং নির্ম্মায তামুদ্দিশ্য নৈৱেদ্যমুত্মৃজ্য স্ৱহস্তকৃতৱস্তুনা আনন্দিতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","তস্মাদ্ ঈশ্ৱরস্তেষাং প্রতি ৱিমুখঃ সন্ আকাশস্থং জ্যোতির্গণং পূজযিতুং তেভ্যোঽনুমতিং দদৌ, যাদৃশং ভৱিষ্যদ্ৱাদিনাং গ্রন্থেষু লিখিতমাস্তে, যথা, ইস্রাযেলীযৱংশা রে চৎৱারিংশৎসমান্ পুরা| মহতি প্রান্তরে সংস্থা যূযন্তু যানি চ| বলিহোমাদিকর্ম্মাণি কৃতৱন্তস্তু তানি কিং| মাং সমুদ্দিশ্য যুষ্মাভিঃ প্রকৃতানীতি নৈৱ চ| ");
INSERT INTO sanben_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","কিন্তু ৱো মোলকাখ্যস্য দেৱস্য দূষ্যমেৱ চ| যুষ্মাকং রিম্ফনাখ্যাযা দেৱতাযাশ্চ তারকা| এতযোরুভযো র্মূর্তী যুষ্মাভিঃ পরিপূজিতে| অতো যুষ্মাংস্তু বাবেলঃ পারং নেষ্যামি নিশ্চিতং| ");
INSERT INTO sanben_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","অপরঞ্চ যন্নিদর্শনম্ অপশ্যস্তদনুসারেণ দূষ্যং নির্ম্মাহি যস্মিন্ ঈশ্ৱরো মূসাম্ এতদ্ৱাক্যং বভাষে তৎ তস্য নিরূপিতং সাক্ষ্যস্ৱরূপং দূষ্যম্ অস্মাকং পূর্ৱ্ৱপুরুষৈঃ সহ প্রান্তরে তস্থৌ| ");
INSERT INTO sanben_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","পশ্চাৎ যিহোশূযেন সহিতৈস্তেষাং ৱংশজাতৈরস্মৎপূর্ৱ্ৱপুরুষৈঃ স্ৱেষাং সম্মুখাদ্ ঈশ্ৱরেণ দূরীকৃতানাম্ অন্যদেশীযানাং দেশাধিকৃতিকালে সমানীতং তদ্ দূষ্যং দাযূদোধিকারং যাৱৎ তত্র স্থান আসীৎ| ");
INSERT INTO sanben_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","স দাযূদ্ পরমেশ্ৱরস্যানুগ্রহং প্রাপ্য যাকূব্ ঈশ্ৱরার্থম্ একং দূষ্যং নির্ম্মাতুং ৱৱাঞ্ছ; ");
INSERT INTO sanben_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","কিন্তু সুলেমান্ তদর্থং মন্দিরম্ একং নির্ম্মিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","তথাপি যঃ সর্ৱ্ৱোপরিস্থঃ স কস্মিংশ্চিদ্ হস্তকৃতে মন্দিরে নিৱসতীতি নহি, ভৱিষ্যদ্ৱাদী কথামেতাং কথযতি, যথা, ");
INSERT INTO sanben_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","পরেশো ৱদতি স্ৱর্গো রাজসিংহাসনং মম| মদীযং পাদপীঠঞ্চ পৃথিৱী ভৱতি ধ্রুৱং| তর্হি যূযং কৃতে মে কিং প্রনির্ম্মাস্যথ মন্দিরং| ৱিশ্রামায মদীযং ৱা স্থানং কিং ৱিদ্যতে ৎৱিহ| ");
INSERT INTO sanben_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","সর্ৱ্ৱাণ্যেতানি ৱস্তূনি কিং মে হস্তকৃতানি ন|| ");
INSERT INTO sanben_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","হে অনাজ্ঞাগ্রাহকা অন্তঃকরণে শ্রৱণে চাপৱিত্রলোকাঃ যূযম্ অনৱরতং পৱিত্রস্যাত্মনঃ প্রাতিকূল্যম্ আচরথ, যুষ্মাকং পূর্ৱ্ৱপুরুষা যাদৃশা যূযমপি তাদৃশাঃ| ");
INSERT INTO sanben_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","যুষ্মাকং পূর্ৱ্ৱপুরুষাঃ কং ভৱিষ্যদ্ৱাদিনং নাতাডযন্? যে তস্য ধার্ম্মিকস্য জনস্যাগমনকথাং কথিতৱন্তস্তান্ অঘ্নন্ যূযম্ অধূনা ৱিশ্ৱাসঘাতিনো ভূৎৱা তং ধার্ম্মিকং জনম্ অহত| ");
INSERT INTO sanben_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","যূযং স্ৱর্গীযদূতগণেন ৱ্যৱস্থাং প্রাপ্যাপি তাং নাচরথ| ");
INSERT INTO sanben_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ইমাং কথাং শ্রুৎৱা তে মনঃসু বিদ্ধাঃ সন্তস্তং প্রতি দন্তঘর্ষণম্ অকুর্ৱ্ৱন্| ");
INSERT INTO sanben_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","কিন্তু স্তিফানঃ পৱিত্রেণাত্মনা পূর্ণো ভূৎৱা গগণং প্রতি স্থিরদৃষ্টিং কৃৎৱা ঈশ্ৱরস্য দক্ষিণে দণ্ডাযমানং যীশুঞ্চ ৱিলোক্য কথিতৱান্; ");
INSERT INTO sanben_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","পশ্য,মেঘদ্ৱারং মুক্তম্ ঈশ্ৱরস্য দক্ষিণে স্থিতং মানৱসুতঞ্চ পশ্যামি| ");
INSERT INTO sanben_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","তদা তে প্রোচ্চৈঃ শব্দং কৃৎৱা কর্ণেষ্ৱঙ্গুলী র্নিধায একচিত্তীভূয তম্ আক্রমন্| ");
INSERT INTO sanben_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","পশ্চাৎ তং নগরাদ্ বহিঃ কৃৎৱা প্রস্তরৈরাঘ্নন্ সাক্ষিণো লাকাঃ শৌলনাম্নো যূনশ্চরণসন্নিধৌ নিজৱস্ত্রাণি স্থাপিতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","অনন্তরং হে প্রভো যীশে মদীযমাত্মানং গৃহাণ স্তিফানস্যেতি প্রার্থনৱাক্যৱদনসমযে তে তং প্রস্তরৈরাঘ্নন্| ");
INSERT INTO sanben_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","তস্মাৎ স জানুনী পাতযিৎৱা প্রোচ্চৈঃ শব্দং কৃৎৱা, হে প্রভে পাপমেতদ্ এতেষু মা স্থাপয, ইত্যুক্ত্ৱা মহানিদ্রাং প্রাপ্নোৎ| ");
INSERT INTO sanben_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","তস্য হত্যাকরণং শৌলোপি সমমন্যত| তস্মিন্ সমযে যিরূশালম্নগরস্থাং মণ্ডলীং প্রতি মহাতাডনাযাং জাতাযাং প্রেরিতলোকান্ হিৎৱা সর্ৱ্ৱেঽপরে যিহূদাশোমিরোণদেশযো র্নানাস্থানে ৱিকীর্ণাঃ সন্তো গতাঃ| ");
INSERT INTO sanben_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","অন্যচ্চ ভক্তলোকাস্তং স্তিফানং শ্মশানে স্থাপযিৎৱা বহু ৱ্যলপন্| ");
INSERT INTO sanben_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","কিন্তু শৌলো গৃহে গৃহে ভ্রমিৎৱা স্ত্রিযঃ পুরুষাংশ্চ ধৃৎৱা কারাযাং বদ্ধ্ৱা মণ্ডল্যা মহোৎপাতং কৃতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","অন্যচ্চ যে ৱিকীর্ণা অভৱন্ তে সর্ৱ্ৱত্র ভ্রমিৎৱা সুসংৱাদং প্রাচারযন্| ");
INSERT INTO sanben_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","তদা ফিলিপঃ শোমিরোণ্নগরং গৎৱা খ্রীষ্টাখ্যানং প্রাচারযৎ; ");
INSERT INTO sanben_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","ততোঽশুচি-ভৃতগ্রস্তলোকেভ্যো ভূতাশ্চীৎকৃত্যাগচ্ছন্ তথা বহৱঃ পক্ষাঘাতিনঃ খঞ্জা লোকাশ্চ স্ৱস্থা অভৱন্| ");
INSERT INTO sanben_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","তস্মাৎ লাকা ঈদৃশং তস্যাশ্চর্য্যং কর্ম্ম ৱিলোক্য নিশম্য চ সর্ৱ্ৱ একচিত্তীভূয তেনোক্তাখ্যানে মনাংসি ন্যদধুঃ| ");
INSERT INTO sanben_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","তস্মিন্নগরে মহানন্দশ্চাভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ততঃ পূর্ৱ্ৱং তস্মিন্নগরে শিমোন্নামা কশ্চিজ্জনো বহ্ৱী র্মাযাক্রিযাঃ কৃৎৱা স্ৱং কঞ্চন মহাপুরুষং প্রোচ্য শোমিরোণীযানাং মোহং জনযামাস| ");
INSERT INTO sanben_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","তস্মাৎ স মানুষ ঈশ্ৱরস্য মহাশক্তিস্ৱরূপ ইত্যুক্ত্ৱা বালৱৃদ্ধৱনিতাঃ সর্ৱ্ৱে লাকাস্তস্মিন্ মনাংসি ন্যদধুঃ| ");
INSERT INTO sanben_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","স বহুকালান্ মাযাৱিক্রিযযা সর্ৱ্ৱান্ অতীৱ মোহযাঞ্চকার, তস্মাৎ তে তং মেনিরে| ");
INSERT INTO sanben_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","কিন্ত্ৱীশ্ৱরস্য রাজ্যস্য যীশুখ্রীষ্টস্য নাম্নশ্চাখ্যানপ্রচারিণঃ ফিলিপস্য কথাযাং ৱিশ্ৱস্য তেষাং স্ত্রীপুরুষোভযলোকা মজ্জিতা অভৱন্| ");
INSERT INTO sanben_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","শেষে স শিমোনপি স্ৱযং প্রত্যৈৎ ততো মজ্জিতঃ সন্ ফিলিপেন কৃতাম্ আশ্চর্য্যক্রিযাং লক্ষণঞ্চ ৱিলোক্যাসম্ভৱং মন্যমানস্তেন সহ স্থিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","ইত্থং শোমিরোণ্দেশীযলোকা ঈশ্ৱরস্য কথাম্ অগৃহ্লন্ ইতি ৱার্ত্তাং যিরূশালম্নগরস্থপ্রেরিতাঃ প্রাপ্য পিতরং যোহনঞ্চ তেষাং নিকটে প্রেষিতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ততস্তৌ তৎ স্থানম্ উপস্থায লোকা যথা পৱিত্রম্ আত্মানং প্রাপ্নুৱন্তি তদর্থং প্রার্থযেতাং| ");
INSERT INTO sanben_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","যতস্তে পুরা কেৱলপ্রভুযীশো র্নাম্না মজ্জিতমাত্রা অভৱন্, ন তু তেষাং মধ্যে কমপি প্রতি পৱিত্রস্যাত্মন আৱির্ভাৱো জাতঃ| ");
INSERT INTO sanben_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","কিন্তু প্রেরিতাভ্যাং তেষাং গাত্রেষু করেষ্ৱর্পিতেষু সৎসু তে পৱিত্রম্ আত্মানম্ প্রাপ্নুৱন্| ");
INSERT INTO sanben_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","ইত্থং লোকানাং গাত্রেষু প্রেরিতযোঃ করার্পণেন তান্ পৱিত্রম্ আত্মানং প্রাপ্তান্ দৃষ্ট্ৱা স শিমোন্ তযোঃ সমীপে মুদ্রা আনীয কথিতৱান্; ");
INSERT INTO sanben_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","অহং যস্য গাত্রে হস্তম্ অর্পযিষ্যামি তস্যাপি যথেত্থং পৱিত্রাত্মপ্রাপ্তি র্ভৱতি তাদৃশীং শক্তিং মহ্যং দত্তং| ");
INSERT INTO sanben_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","কিন্তু পিতরস্তং প্রত্যৱদৎ তৱ মুদ্রাস্ত্ৱযা ৱিনশ্যন্তু যত ঈশ্ৱরস্য দানং মুদ্রাভিঃ ক্রীযতে ৎৱমিত্থং বুদ্ধৱান্; ");
INSERT INTO sanben_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ঈশ্ৱরায তাৱন্তঃকরণং সরলং নহি, তস্মাদ্ অত্র তৱাংশোঽধিকারশ্চ কোপি নাস্তি| ");
INSERT INTO sanben_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","অত এতৎপাপহেতোঃ খেদান্ৱিতঃ সন্ কেনাপি প্রকারেণ তৱ মনস এতস্যাঃ কুকল্পনাযাঃ ক্ষমা ভৱতি, এতদর্থম্ ঈশ্ৱরে প্রার্থনাং কুরু; ");
INSERT INTO sanben_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","যতস্ত্ৱং তিক্তপিত্তে পাপস্য বন্ধনে চ যদসি তন্মযা বুদ্ধম্| ");
INSERT INTO sanben_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","তদা শিমোন্ অকথযৎ তর্হি যুৱাভ্যামুদিতা কথা মযি যথা ন ফলতি তদর্থং যুৱাং মন্নিমিত্তং প্রভৌ প্রার্থনাং কুরুতং| ");
INSERT INTO sanben_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","অনেন প্রকারেণ তৌ সাক্ষ্যং দত্ত্ৱা প্রভোঃ কথাং প্রচারযন্তৌ শোমিরোণীযানাম্ অনেকগ্রামেষু সুসংৱাদঞ্চ প্রচারযন্তৌ যিরূশালম্নগরং পরাৱৃত্য গতৌ| ");
INSERT INTO sanben_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ততঃ পরম্ ঈশ্ৱরস্য দূতঃ ফিলিপম্ ইত্যাদিশৎ, ৎৱমুত্থায দক্ষিণস্যাং দিশি যো মার্গো প্রান্তরস্য মধ্যেন যিরূশালমো ঽসানগরং যাতি তং মার্গং গচ্ছ| ");
INSERT INTO sanben_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ততঃ স উত্থায গতৱান্; তদা কন্দাকীনাম্নঃ কূশ্লোকানাং রাজ্ঞ্যাঃ সর্ৱ্ৱসম্পত্তেরধীশঃ কূশদেশীয একঃ ষণ্ডো ভজনার্থং যিরূশালম্নগরম্ আগত্য ");
INSERT INTO sanben_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","পুনরপি রথমারুহ্য যিশযিযনাম্নো ভৱিষ্যদ্ৱাদিনো গ্রন্থং পঠন্ প্রত্যাগচ্ছতি| ");
INSERT INTO sanben_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","এতস্মিন্ সমযে আত্মা ফিলিপম্ অৱদৎ, ৎৱম্ রথস্য সমীপং গৎৱা তেন সার্দ্ধং মিল| ");
INSERT INTO sanben_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","তস্মাৎ স ধাৱন্ তস্য সন্নিধাৱুপস্থায তেন পঠ্যমানং যিশযিযথৱিষ্যদ্ৱাদিনো ৱাক্যং শ্রুৎৱা পৃষ্টৱান্ যৎ পঠসি তৎ কিং বুধ্যসে? ");
INSERT INTO sanben_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","ততঃ স কথিতৱান্ কেনচিন্ন বোধিতোহং কথং বুধ্যেয? ততঃ স ফিলিপং রথমারোঢুং স্ৱেন সার্দ্ধম্ উপৱেষ্টুঞ্চ ন্যৱেদযৎ| ");
INSERT INTO sanben_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","স শাস্ত্রস্যেতদ্ৱাক্যং পঠিতৱান্ যথা, সমানীযত ঘাতায স যথা মেষশাৱকঃ| লোমচ্ছেদকসাক্ষাচ্চ মেষশ্চ নীরৱো যথা| আবধ্য ৱদনং স্ৱীযং তথা স সমতিষ্ঠত| ");
INSERT INTO sanben_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","অন্যাযেন ৱিচারেণ স উচ্ছিন্নো ঽভৱৎ তদা| তৎকালীনমনুষ্যান্ কো জনো ৱর্ণযিতুং ক্ষমঃ| যতো জীৱন্নৃণাং দেশাৎ স উচ্ছিন্নো ঽভৱৎ ধ্রুৱং| ");
INSERT INTO sanben_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","অনন্তরং স ফিলিপম্ অৱদৎ নিৱেদযামি, ভৱিষ্যদ্ৱাদী যামিমাং কথাং কথযামাস স কিং স্ৱস্মিন্ ৱা কস্মিংশ্চিদ্ অন্যস্মিন্? ");
INSERT INTO sanben_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ততঃ ফিলিপস্তৎপ্রকরণম্ আরভ্য যীশোরুপাখ্যানং তস্যাগ্রে প্রাস্তৌৎ| ");
INSERT INTO sanben_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ইত্থং মার্গেণ গচ্ছন্তৌ জলাশযস্য সমীপ উপস্থিতৌ; তদা ক্লীবোঽৱাদীৎ পশ্যাত্র স্থানে জলমাস্তে মম মজ্জনে কা বাধা? ");
INSERT INTO sanben_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","ততঃ ফিলিপ উত্তরং ৱ্যাহরৎ স্ৱান্তঃকরণেন সাকং যদি প্রত্যেষি তর্হি বাধা নাস্তি| ততঃ স কথিতৱান্ যীশুখ্রীষ্ট ঈশ্ৱরস্য পুত্র ইত্যহং প্রত্যেমি| ");
INSERT INTO sanben_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","তদা রথং স্থগিতং কর্ত্তুম্ আদিষ্টে ফিলিপক্লীবৌ দ্ৱৌ জলম্ অৱারুহতাং; তদা ফিলিপস্তম্ মজ্জযামাস| ");
INSERT INTO sanben_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","তৎপশ্চাৎ জলমধ্যাদ্ উত্থিতযোঃ সতোঃ পরমেশ্ৱরস্যাত্মা ফিলিপং হৃৎৱা নীতৱান্, তস্মাৎ ক্লীবঃ পুনস্তং ন দৃষ্টৱান্ তথাপি হৃষ্টচিত্তঃ সন্ স্ৱমার্গেণ গতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ফিলিপশ্চাস্দোদ্নগরম্ উপস্থায তস্মাৎ কৈসরিযানগর উপস্থিতিকালপর্য্যনতং সর্ৱ্ৱস্মিন্নগরে সুসংৱাদং প্রচারযন্ গতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","তৎকালপর্য্যনতং শৌলঃ প্রভোঃ শিষ্যাণাং প্রাতিকূল্যেন তাডনাবধযোঃ কথাং নিঃসারযন্ মহাযাজকস্য সন্নিধিং গৎৱা ");
INSERT INTO sanben_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","স্ত্রিযং পুরুষঞ্চ তন্মতগ্রাহিণং যং কঞ্চিৎ পশ্যতি তান্ ধৃৎৱা বদ্ধ্ৱা যিরূশালমম্ আনযতীত্যাশযেন দম্মেষক্নগরীযং ধর্ম্মসমাজান্ প্রতি পত্রং যাচিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","গচ্ছন্ তু দম্মেষক্নগরনিকট উপস্থিতৱান্; ততোঽকস্মাদ্ আকাশাৎ তস্য চতুর্দিক্ষু তেজসঃ প্রকাশনাৎ স ভূমাৱপতৎ| ");
INSERT INTO sanben_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","পশ্চাৎ হে শৌল হে শৌল কুতো মাং তাডযসি? স্ৱং প্রতি প্রোক্তম্ এতং শব্দং শ্রুৎৱা ");
INSERT INTO sanben_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","স পৃষ্টৱান্, হে প্রভো ভৱান্ কঃ? তদা প্রভুরকথযৎ যং যীশুং ৎৱং তাডযসি স এৱাহং; কণ্টকস্য মুখে পদাঘাতকরণং তৱ কষ্টম্| ");
INSERT INTO sanben_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","তদা কম্পমানো ৱিস্মযাপন্নশ্চ সোৱদৎ হে প্রভো মযা কিং কর্ত্তৱ্যং? ভৱত ইচ্ছা কা? ততঃ প্রভুরাজ্ঞাপযদ্ উত্থায নগরং গচ্ছ তত্র ৎৱযা যৎ কর্ত্তৱ্যং তদ্ ৱদিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","তস্য সঙ্গিনো লোকা অপি তং শব্দং শ্রুতৱন্তঃ কিন্তু কমপি ন দৃষ্ট্ৱা স্তব্ধাঃ সন্তঃ স্থিতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","অনন্তরং শৌলো ভূমিত উত্থায চক্ষুষী উন্মীল্য কমপি ন দৃষ্টৱান্| তদা লোকাস্তস্য হস্তৌ ধৃৎৱা দম্মেষক্নগরম্ আনযন্| ");
INSERT INTO sanben_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ততঃ স দিনত্রযং যাৱদ্ অন্ধো ভূৎৱা ন ভুক্তৱান্ পীতৱাংশ্চ| ");
INSERT INTO sanben_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","তদনন্তরং প্রভুস্তদ্দম্মেষক্নগরৱাসিন একস্মৈ শিষ্যায দর্শনং দৎৱা আহূতৱান্ হে অননিয| ততঃ স প্রত্যৱাদীৎ, হে প্রভো পশ্য শৃণোমি| ");
INSERT INTO sanben_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","তদা প্রভুস্তমাজ্ঞাপযৎ ৎৱমুত্থায সরলনামানং মার্গং গৎৱা যিহূদানিৱেশনে তার্ষনগরীযং শৌলনামানং জনং গৱেষযন্ পৃচ্ছ; ");
INSERT INTO sanben_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","পশ্য স প্রার্থযতে, তথা অননিযনামক একো জনস্তস্য সমীপম্ আগত্য তস্য গাত্রে হস্তার্পণং কৃৎৱা দৃষ্টিং দদাতীত্থং স্ৱপ্নে দৃষ্টৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","তস্মাদ্ অননিযঃ প্রত্যৱদৎ হে প্রভো যিরূশালমি পৱিত্রলোকান্ প্রতি সোঽনেকহিংসাং কৃতৱান্; ");
INSERT INTO sanben_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","অত্র স্থানে চ যে লোকাস্তৱ নাম্নি প্রার্থযন্তি তানপি বদ্ধুং স প্রধানযাজকেভ্যঃ শক্তিং প্রাপ্তৱান্, ইমাং কথাম্ অহম্ অনেকেষাং মুখেভ্যঃ শ্রুতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","কিন্তু প্রভুরকথযৎ, যাহি ভিন্নদেশীযলোকানাং ভূপতীনাম্ ইস্রাযেল্লোকানাঞ্চ নিকটে মম নাম প্রচারযিতুং স জনো মম মনোনীতপাত্রমাস্তে| ");
INSERT INTO sanben_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","মম নামনিমিত্তঞ্চ তেন কিযান্ মহান্ ক্লেশো ভোক্তৱ্য এতৎ তং দর্শযিষ্যামি| ");
INSERT INTO sanben_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ততো ঽননিযো গৎৱা গৃহং প্রৱিশ্য তস্য গাত্রে হস্তার্প্রণং কৃৎৱা কথিতৱান্, হে ভ্রাতঃ শৌল ৎৱং যথা দৃষ্টিং প্রাপ্নোষি পৱিত্রেণাত্মনা পরিপূর্ণো ভৱসি চ, তদর্থং তৱাগমনকালে যঃ প্রভুযীশুস্তুভ্যং দর্শনম্ অদদাৎ স মাং প্রেষিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ইত্যুক্তমাত্রে তস্য চক্ষুর্ভ্যাম্ মীনশল্কৱদ্ ৱস্তুনি নির্গতে তৎক্ষণাৎ স প্রসন্নচক্ষু র্ভূৎৱা প্রোত্থায মজ্জিতোঽভৱৎ ভুক্ত্ৱা পীৎৱা সবলোভৱচ্চ| ");
INSERT INTO sanben_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ততঃ পরং শৌলঃ শিষ্যৈঃ সহ কতিপযদিৱসান্ তস্মিন্ দম্মেষকনগরে স্থিৎৱাঽৱিলম্বং ");
INSERT INTO sanben_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","সর্ৱ্ৱভজনভৱনানি গৎৱা যীশুরীশ্ৱরস্য পুত্র ইমাং কথাং প্রাচারযৎ| ");
INSERT INTO sanben_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","তস্মাৎ সর্ৱ্ৱে শ্রোতারশ্চমৎকৃত্য কথিতৱন্তো যো যিরূশালম্নগর এতন্নাম্না প্রার্থযিতৃলোকান্ ৱিনাশিতৱান্ এৱম্ এতাদৃশলোকান্ বদ্ধ্ৱা প্রধানযাজকনিকটং নযতীত্যাশযা এতৎস্থানমপ্যাগচ্ছৎ সএৱ কিমযং ন ভৱতি? ");
INSERT INTO sanben_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","কিন্তু শৌলঃ ক্রমশ উৎসাহৱান্ ভূৎৱা যীশুরীশ্ৱরেণাভিষিক্তো জন এতস্মিন্ প্রমাণং দৎৱা দম্মেষক্-নিৱাসিযিহূদীযলোকান্ নিরুত্তরান্ অকরোৎ| ");
INSERT INTO sanben_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ইত্থং বহুতিথে কালে গতে যিহূদীযলোকাস্তং হন্তুং মন্ত্রযামাসুঃ ");
INSERT INTO sanben_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","কিন্তু শৌলস্তেষামেতস্যা মন্ত্রণাযা ৱার্ত্তাং প্রাপ্তৱান্| তে তং হন্তুং তু দিৱানিশং গুপ্তাঃ সন্তো নগরস্য দ্ৱারেঽতিষ্ঠন্; ");
INSERT INTO sanben_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","তস্মাৎ শিষ্যাস্তং নীৎৱা রাত্রৌ পিটকে নিধায প্রাচীরেণাৱারোহযন্| ");
INSERT INTO sanben_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","ততঃ পরং শৌলো যিরূশালমং গৎৱা শিষ্যগণেন সার্দ্ধং স্থাতুম্ ঐহৎ, কিন্তু সর্ৱ্ৱে তস্মাদবিভযুঃ স শিষ্য ইতি চ ন প্রত্যযন্| ");
INSERT INTO sanben_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","এতস্মাদ্ বর্ণব্বাস্তং গৃহীৎৱা প্রেরিতানাং সমীপমানীয মার্গমধ্যে প্রভুঃ কথং তস্মৈ দর্শনং দত্তৱান্ যাঃ কথাশ্চ কথিতৱান্ স চ যথাক্ষোভঃ সন্ দম্মেষক্নগরে যীশো র্নাম প্রাচারযৎ এতান্ সর্ৱ্ৱৱৃত্তান্তান্ তান্ জ্ঞাপিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","ততঃ শৌলস্তৈঃ সহ যিরূশালমি কালং যাপযন্ নির্ভযং প্রভো র্যীশো র্নাম প্রাচারযৎ| ");
INSERT INTO sanben_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","তস্মাদ্ অন্যদেশীযলোকৈঃ সার্দ্ধং ৱিৱাদস্যোপস্থিতৎৱাৎ তে তং হন্তুম্ অচেষ্টন্ত| ");
INSERT INTO sanben_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","কিন্তু ভ্রাতৃগণস্তজ্জ্ঞাৎৱা তং কৈসরিযানগরং নীৎৱা তার্ষনগরং প্রেষিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ইত্থং সতি যিহূদিযাগালীল্শোমিরোণদেশীযাঃ সর্ৱ্ৱা মণ্ডল্যো ৱিশ্রামং প্রাপ্তাস্ততস্তাসাং নিষ্ঠাভৱৎ প্রভো র্ভিযা পৱিত্রস্যাত্মনঃ সান্ত্ৱনযা চ কালং ক্ষেপযিৎৱা বহুসংখ্যা অভৱন্| ");
INSERT INTO sanben_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","ততঃ পরং পিতরঃ স্থানে স্থানে ভ্রমিৎৱা শেষে লোদ্নগরনিৱাসিপৱিত্রলোকানাং সমীপে স্থিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","তদা তত্র পক্ষাঘাতৱ্যাধিনাষ্টৌ ৱৎসরান্ শয্যাগতম্ ঐনেযনামানং মনুষ্যং সাক্ষৎ প্রাপ্য তমৱদৎ, ");
INSERT INTO sanben_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","হে ঐনেয যীশুখ্রীষ্টস্ত্ৱাং স্ৱস্থম্ অকার্ষীৎ, ৎৱমুত্থায স্ৱশয্যাং নিক্ষিপ, ইত্যুক্তমাত্রে স উদতিষ্ঠৎ| ");
INSERT INTO sanben_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","এতাদৃশং দৃষ্ট্ৱা লোদ্শারোণনিৱাসিনো লোকাঃ প্রভুং প্রতি পরাৱর্ত্তন্ত| ");
INSERT INTO sanben_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","অপরঞ্চ ভিক্ষাদানাদিষু নানক্রিযাসু নিত্যং প্রৱৃত্তা যা যাফোনগরনিৱাসিনী টাবিথানামা শিষ্যা যাং দর্ক্কাং অর্থাদ্ হরিণীমযুক্ত্ৱা আহ্ৱযন্ সা নারী ");
INSERT INTO sanben_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","তস্মিন্ সমযে রুগ্না সতী প্রাণান্ অত্যজৎ, ততো লোকাস্তাং প্রক্ষাল্যোপরিস্থপ্রকোষ্ঠে শাযযিৎৱাস্থাপযন্| ");
INSERT INTO sanben_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","লোদ্নগরং যাফোনগরস্য সমীপস্থং তস্মাত্তত্র পিতর আস্তে, ইতি ৱার্ত্তাং শ্রুৎৱা তূর্ণং তস্যাগমনার্থং তস্মিন্ ৱিনযমুক্ত্ৱা শিষ্যগণো দ্ৱৌ মনুজৌ প্রেষিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","তস্মাৎ পিতর উত্থায তাভ্যাং সার্দ্ধম্ আগচ্ছৎ, তত্র তস্মিন্ উপস্থিত উপরিস্থপ্রকোষ্ঠং সমানীতে চ ৱিধৱাঃ স্ৱাভিঃ সহ স্থিতিকালে দর্ক্কযা কৃতানি যান্যুত্তরীযাণি পরিধেযানি চ তানি সর্ৱ্ৱাণি তং দর্শযিৎৱা রুদত্যশ্চতসৃষু দিক্ষ্ৱতিষ্ঠন্| ");
INSERT INTO sanben_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","কিন্তু পিতরস্তাঃ সর্ৱ্ৱা বহিঃ কৃৎৱা জানুনী পাতযিৎৱা প্রার্থিতৱান্; পশ্চাৎ শৱং প্রতি দৃষ্টিং কৃৎৱা কথিতৱান্, হে টাবীথে ৎৱমুত্তিষ্ঠ, ইতি ৱাক্য উক্তে সা স্ত্রী চক্ষুষী প্রোন্মীল্য পিতরম্ অৱলোক্যোত্থাযোপাৱিশৎ| ");
INSERT INTO sanben_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","ততঃ পিতরস্তস্যাঃ করৌ ধৃৎৱা উত্তোল্য পৱিত্রলোকান্ ৱিধৱাশ্চাহূয তেষাং নিকটে সজীৱাং তাং সমার্পযৎ| ");
INSERT INTO sanben_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","এষা কথা সমস্তযাফোনগরং ৱ্যাপ্তা তস্মাদ্ অনেকে লোকাঃ প্রভৌ ৱ্যশ্ৱসন্| ");
INSERT INTO sanben_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","অপরঞ্চ পিতরস্তদ্যাফোনগরীযস্য কস্যচিৎ শিমোন্নাম্নশ্চর্ম্মকারস্য গৃহে বহুদিনানি ন্যৱসৎ| ");
INSERT INTO sanben_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","কৈসরিযানগর ইতালিযাখ্যসৈন্যান্তর্গতঃ কর্ণীলিযনামা সেনাপতিরাসীৎ ");
INSERT INTO sanben_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","স সপরিৱারো ভক্ত ঈশ্ৱরপরাযণশ্চাসীৎ; লোকেভ্যো বহূনি দানাদীনি দৎৱা নিরন্তরম্ ঈশ্ৱরে প্রার্থযাঞ্চক্রে| ");
INSERT INTO sanben_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","একদা তৃতীযপ্রহরৱেলাযাং স দৃষ্টৱান্ ঈশ্ৱরস্যৈকো দূতঃ সপ্রকাশং তৎসমীপম্ আগত্য কথিতৱান্, হে কর্ণীলিয| ");
INSERT INTO sanben_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","কিন্তু স তং দৃষ্ট্ৱা ভীতোঽকথযৎ, হে প্রভো কিং? তদা তমৱদৎ তৱ প্রার্থনা দানাদি চ সাক্ষিস্ৱরূপং ভূৎৱেশ্ৱরস্য গোচরমভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ইদানীং যাফোনগরং প্রতি লোকান্ প্রেষ্য সমুদ্রতীরে শিমোন্নাম্নশ্চর্ম্মকারস্য গৃহে প্রৱাসকারী পিতরনাম্না ৱিখ্যাতো যঃ শিমোন্ তম্ আহ্ৱাযয; ");
INSERT INTO sanben_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","তস্মাৎ ৎৱযা যদ্যৎ কর্ত্তৱ্যং তত্তৎ স ৱদিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ইত্যুপদিশ্য দূতে প্রস্থিতে সতি কর্ণীলিযঃ স্ৱগৃহস্থানাং দাসানাং দ্ৱৌ জনৌ নিত্যং স্ৱসঙ্গিনাং সৈন্যানাম্ একাং ভক্তসেনাঞ্চাহূয ");
INSERT INTO sanben_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","সকলমেতং ৱৃত্তান্তং ৱিজ্ঞাপ্য যাফোনগরং তান্ প্রাহিণোৎ| ");
INSERT INTO sanben_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","পরস্মিন্ দিনে তে যাত্রাং কৃৎৱা যদা নগরস্য সমীপ উপাতিষ্ঠন্, তদা পিতরো দ্ৱিতীযপ্রহরৱেলাযাং প্রার্থযিতুং গৃহপৃষ্ঠম্ আরোহৎ| ");
INSERT INTO sanben_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","এতস্মিন্ সমযে ক্ষুধার্ত্তঃ সন্ কিঞ্চিদ্ ভোক্তুম্ ঐচ্ছৎ কিন্তু তেষাম্ অন্নাসাদনসমযে স মূর্চ্ছিতঃ সন্নপতৎ| ");
INSERT INTO sanben_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ততো মেঘদ্ৱারং মুক্তং চতুর্ভিঃ কোণৈ র্লম্বিতং বৃহদ্ৱস্ত্রমিৱ কিঞ্চন ভাজনম্ আকাশাৎ পৃথিৱীম্ অৱারোহতীতি দৃষ্টৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","তন্মধ্যে নানপ্রকারা গ্রাম্যৱন্যপশৱঃ খেচরোরোগামিপ্রভৃতযো জন্তৱশ্চাসন্| ");
INSERT INTO sanben_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","অনন্তরং হে পিতর উত্থায হৎৱা ভুংক্ষ্ৱ তম্প্রতীযং গগণীযা ৱাণী জাতা| ");
INSERT INTO sanben_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","তদা পিতরঃ প্রত্যৱদৎ, হে প্রভো ঈদৃশং মা ভৱতু, অহম্ এতৎ কালং যাৱৎ নিষিদ্ধম্ অশুচি ৱা দ্রৱ্যং কিঞ্চিদপি ন ভুক্তৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ততঃ পুনরপি তাদৃশী ৱিহযসীযা ৱাণী জাতা যদ্ ঈশ্ৱরঃ শুচি কৃতৱান্ তৎ ৎৱং নিষিদ্ধং ন জানীহি| ");
INSERT INTO sanben_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ইত্থং ত্রিঃ সতি তৎ পাত্রং পুনরাকৃষ্টং আকাশম্ অগচ্ছৎ| ");
INSERT INTO sanben_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ততঃ পরং যদ্ দর্শনং প্রাপ্তৱান্ তস্য কো ভাৱ ইত্যত্র পিতরো মনসা সন্দেগ্ধি, এতস্মিন্ সমযে কর্ণীলিযস্য তে প্রেষিতা মনুষ্যা দ্ৱারস্য সন্নিধাৱুপস্থায, ");
INSERT INTO sanben_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","শিমোনো গৃহমন্ৱিচ্ছন্তঃ সম্পৃছ্যাহূয কথিতৱন্তঃ পিতরনাম্না ৱিখ্যাতো যঃ শিমোন্ স কিমত্র প্রৱসতি? ");
INSERT INTO sanben_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","যদা পিতরস্তদ্দর্শনস্য ভাৱং মনসান্দোলযতি তদাত্মা তমৱদৎ, পশ্য ত্রযো জনাস্ত্ৱাং মৃগযন্তে| ");
INSERT INTO sanben_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ৎৱম্ উত্থাযাৱরুহ্য নিঃসন্দেহং তৈঃ সহ গচ্ছ মযৈৱ তে প্রেষিতাঃ| ");
INSERT INTO sanben_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","তস্মাৎ পিতরোঽৱরুহ্য কর্ণীলিযপ্রেরিতলোকানাং নিকটমাগত্য কথিতৱান্ পশ্যত যূযং যং মৃগযধ্ৱে স জনোহং, যূযং কিন্নিমিত্তম্ আগতাঃ? ");
INSERT INTO sanben_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ততস্তে প্রত্যৱদন্ কর্ণীলিযনামা শুদ্ধসত্ত্ৱ ঈশ্ৱরপরাযণো যিহূদীযদেশস্থানাং সর্ৱ্ৱেষাং সন্নিধৌ সুখ্যাত্যাপন্ন একঃ সেনাপতি র্নিজগৃহং ৎৱামাহূয নেতুং ৎৱত্তঃ কথা শ্রোতুঞ্চ পৱিত্রদূতেন সমাদিষ্টঃ| ");
INSERT INTO sanben_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","তদা পিতরস্তানভ্যন্তরং নীৎৱা তেষামাতিথ্যং কৃতৱান্, পরেঽহনি তৈঃ সার্দ্ধং যাত্রামকরোৎ, যাফোনিৱাসিনাং ভ্রাতৃণাং কিযন্তো জনাশ্চ তেন সহ গতাঃ| ");
INSERT INTO sanben_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","পরস্মিন্ দিৱসে কৈসরিযানগরমধ্যপ্রৱেশসমযে কর্ণীলিযো জ্ঞাতিবন্ধূন্ আহূযানীয তান্ অপেক্ষ্য স্থিতঃ| ");
INSERT INTO sanben_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","পিতরে গৃহ উপস্থিতে কর্ণীলিযস্তং সাক্ষাৎকৃত্য চরণযোঃ পতিৎৱা প্রাণমৎ| ");
INSERT INTO sanben_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","পিতরস্তমুত্থাপ্য কথিতৱান্, উত্তিষ্ঠাহমপি মানুষঃ| ");
INSERT INTO sanben_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","তদা কর্ণীলিযেন সাকম্ আলপন্ গৃহং প্রাৱিশৎ তন্মধ্যে চ বহুলোকানাং সমাগমং দৃষ্ট্ৱা তান্ অৱদৎ, ");
INSERT INTO sanben_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","অন্যজাতীযলোকৈঃ মহালপনং ৱা তেষাং গৃহমধ্যে প্রৱেশনং যিহূদীযানাং নিষিদ্ধম্ অস্তীতি যূযম্ অৱগচ্ছথ; কিন্তু কমপি মানুষম্ অৱ্যৱহার্য্যম্ অশুচিং ৱা জ্ঞাতুং মম নোচিতম্ ইতি পরমেশ্ৱরো মাং জ্ঞাপিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ইতি হেতোরাহ্ৱানশ্রৱণমাত্রাৎ কাঞ্চনাপত্তিম্ অকৃৎৱা যুষ্মাকং সমীপম্ আগতোস্মি; পৃচ্ছামি যূযং কিন্নিমিত্তং মাম্ আহূযত? ");
INSERT INTO sanben_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","তদা কর্ণীলিযঃ কথিতৱান্, অদ্য চৎৱারি দিনানি জাতানি এতাৱদ্ৱেলাং যাৱদ্ অহম্ অনাহার আসন্ ততস্তৃতীযপ্রহরে সতি গৃহে প্রার্থনসমযে তেজোমযৱস্ত্রভৃদ্ একো জনো মম সমক্ষং তিষ্ঠন্ এতাং কথাম্ অকথযৎ, ");
INSERT INTO sanben_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","হে কর্ণীলিয ৎৱদীযা প্রার্থনা ঈশ্ৱরস্য কর্ণগোচরীভূতা তৱ দানাদি চ সাক্ষিস্ৱরূপং ভূৎৱা তস্য দৃষ্টিগোচরমভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","অতো যাফোনগরং প্রতি লোকান্ প্রহিত্য তত্র সমুদ্রতীরে শিমোন্নাম্নঃ কস্যচিচ্চর্ম্মকারস্য গৃহে প্রৱাসকারী পিতরনাম্না ৱিখ্যাতো যঃ শিমোন্ তমাহূाযয; ততঃ স আগত্য ৎৱাম্ উপদেক্ষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ইতি কারণাৎ তৎক্ষণাৎ তৱ নিকটে লোকান্ প্রেষিতৱান্, ৎৱমাগতৱান্ ইতি ভদ্রং কৃতৱান্| ঈশ্ৱরো যান্যাখ্যানানি কথযিতুম্ আদিশৎ তানি শ্রোতুং ৱযং সর্ৱ্ৱে সাম্প্রতম্ ঈশ্ৱরস্য সাক্ষাদ্ উপস্থিতাঃ স্মঃ| ");
INSERT INTO sanben_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","তদা পিতর ইমাং কথাং কথযিতুম্ আরব্ধৱান্, ঈশ্ৱরো মনুষ্যাণাম্ অপক্ষপাতী সন্ ");
INSERT INTO sanben_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","যস্য কস্যচিদ্ দেশস্য যো লোকাস্তস্মাদ্ভীৎৱা সৎকর্ম্ম করোতি স তস্য গ্রাহ্যো ভৱতি, এতস্য নিশ্চযম্ উপলব্ধৱানহম্| ");
INSERT INTO sanben_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","সর্ৱ্ৱেষাং প্রভু র্যো যীশুখ্রীষ্টস্তেন ঈশ্ৱর ইস্রাযেল্ৱংশানাং নিকটে সুসংৱাদং প্রেষ্য সম্মেলনস্য যং সংৱাদং প্রাচারযৎ তং সংৱাদং যূযং শ্রুতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","যতো যোহনা মজ্জনে প্রচারিতে সতি স গালীলদেশমারভ্য সমস্তযিহূদীযদেশং ৱ্যাপ্নোৎ; ");
INSERT INTO sanben_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ফলত ঈশ্ৱরেণ পৱিত্রেণাত্মনা শক্ত্যা চাভিষিক্তো নাসরতীযযীশুঃ স্থানে স্থানে ভ্রমন্ সুক্রিযাং কুর্ৱ্ৱন্ শৈতানা ক্লিষ্টান্ সর্ৱ্ৱলোকান্ স্ৱস্থান্ অকরোৎ, যত ঈশ্ৱরস্তস্য সহায আসীৎ; ");
INSERT INTO sanben_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","ৱযঞ্চ যিহূদীযদেশে যিরূশালম্নগরে চ তেন কৃতানাং সর্ৱ্ৱেষাং কর্ম্মণাং সাক্ষিণো ভৱামঃ| লোকাস্তং ক্রুশে ৱিদ্ধ্ৱা হতৱন্তঃ, ");
INSERT INTO sanben_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","কিন্তু তৃতীযদিৱসে ঈশ্ৱরস্তমুত্থাপ্য সপ্রকাশম্ অদর্শযৎ| ");
INSERT INTO sanben_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","সর্ৱ্ৱলোকানাং নিকট ইতি ন হি, কিন্তু তস্মিন্ শ্মশানাদুত্থিতে সতি তেন সার্দ্ধং ভোজনং পানঞ্চ কৃতৱন্ত এতাদৃশা ঈশ্ৱরস্য মনোনীতাঃ সাক্ষিণো যে ৱযম্ অস্মাকং নিকটে তমদর্শযৎ| ");
INSERT INTO sanben_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","জীৱিতমৃতোভযলোকানাং ৱিচারং কর্ত্তুম্ ঈশ্ৱরো যং নিযুক্তৱান্ স এৱ স জনঃ, ইমাং কথাং প্রচারযিতুং তস্মিন্ প্রমাণং দাতুঞ্চ সোঽস্মান্ আজ্ঞাপযৎ| ");
INSERT INTO sanben_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","যস্তস্মিন্ ৱিশ্ৱসিতি স তস্য নাম্না পাপান্মুক্তো ভৱিষ্যতি তস্মিন্ সর্ৱ্ৱে ভৱিষ্যদ্ৱাদিনোপি এতাদৃশং সাক্ষ্যং দদতি| ");
INSERT INTO sanben_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","পিতরস্যৈতৎকথাকথনকালে সর্ৱ্ৱেষাং শ্রোতৃণামুপরি পৱিত্র আত্মাৱারোহৎ| ");
INSERT INTO sanben_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ততঃ পিতরেণ সার্দ্ধম্ আগতাস্ত্ৱক্ছেদিনো ৱিশ্ৱাসিনো লোকা অন্যদেশীযেভ্যঃ পৱিত্র আত্মনি দত্তে সতি ");
INSERT INTO sanben_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","তে নানাজাতীযভাষাভিঃ কথাং কথযন্ত ঈশ্ৱরং প্রশংসন্তি, ইতি দৃষ্ট্ৱা শ্রুৎৱা চ ৱিস্মযম্ আপদ্যন্ত| ");
INSERT INTO sanben_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","তদা পিতরঃ কথিতৱান্, ৱযমিৱ যে পৱিত্রম্ আত্মানং প্রাপ্তাস্তেষাং জলমজ্জনং কিং কোপি নিষেদ্ধুং শক্নোতি? ");
INSERT INTO sanben_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","ততঃ প্রভো র্নাম্না মজ্জিতা ভৱতেতি তানাজ্ঞাপযৎ| অনন্তরং তে স্ৱৈঃ সার্দ্ধং কতিপযদিনানি স্থাতুং প্রার্থযন্ত| ");
INSERT INTO sanben_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","ইত্থং ভিন্নদেশীযলোকা অপীশ্ৱরস্য ৱাক্যম্ অগৃহ্লন্ ইমাং ৱার্ত্তাং যিহূদীযদেশস্থপ্রেরিতা ভ্রাতৃগণশ্চ শ্রুতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ততঃ পিতরে যিরূশালম্নগরং গতৱতি ৎৱক্ছেদিনো লোকাস্তেন সহ ৱিৱদমানা অৱদন্, ");
INSERT INTO sanben_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ৎৱম্ অৎৱক্ছেদিলোকানাং গৃহং গৎৱা তৈঃ সার্দ্ধং ভুক্তৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","ততঃ পিতর আদিতঃ ক্রমশস্তৎকার্য্যস্য সর্ৱ্ৱৱৃত্তান্তমাখ্যাতুম্ আরব্ধৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","যাফোনগর একদাহং প্রার্থযমানো মূর্চ্ছিতঃ সন্ দর্শনেন চতুর্ষু কোণেষু লম্বনমানং ৱৃহদ্ৱস্ত্রমিৱ পাত্রমেকম্ আকাশদৱরুহ্য মন্নিকটম্ আগচ্ছদ্ অপশ্যম্| ");
INSERT INTO sanben_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","পশ্চাৎ তদ্ অনন্যদৃষ্ট্যা দৃষ্ট্ৱা ৱিৱিচ্য তস্য মধ্যে নানাপ্রকারান্ গ্রাম্যৱন্যপশূন্ উরোগামিখেচরাংশ্চ দৃষ্টৱান্; ");
INSERT INTO sanben_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","হে পিতর ৎৱমুত্থায গৎৱা ভুংক্ষ্ৱ মাং সম্বোধ্য কথযন্তং শব্দমেকং শ্রুতৱাংশ্চ| ");
INSERT INTO sanben_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","ততোহং প্রত্যৱদং, হে প্রভো নেত্থং ভৱতু, যতঃ কিঞ্চন নিষিদ্ধম্ অশুচি দ্রৱ্যং ৱা মম মুখমধ্যং কদাপি ন প্রাৱিশৎ| ");
INSERT INTO sanben_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","অপরম্ ঈশ্ৱরো যৎ শুচি কৃতৱান্ তন্নিষিদ্ধং ন জানীহি দ্ৱি র্মাম্প্রতীদৃশী ৱিহাযসীযা ৱাণী জাতা| ");
INSERT INTO sanben_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","ত্রিরিত্থং সতি তৎ সর্ৱ্ৱং পুনরাকাশম্ আকৃষ্টং| ");
INSERT INTO sanben_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","পশ্চাৎ কৈসরিযানগরাৎ ত্রযো জনা মন্নিকটং প্রেষিতা যত্র নিৱেশনে স্থিতোহং তস্মিন্ সমযে তত্রোপাতিষ্ঠন্| ");
INSERT INTO sanben_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","তদা নিঃসন্দেহং তৈঃ সার্দ্ধং যাতুম্ আত্মা মামাদিষ্টৱান্; ততঃ পরং মযা সহৈতেষু ষড্ভ্রাতৃষু গতেষু ৱযং তস্য মনুজস্য গৃহং প্রাৱিশাম| ");
INSERT INTO sanben_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","সোস্মাকং নিকটে কথামেতাম্ অকথযৎ একদা দূত একঃ প্রত্যক্ষীভূয মম গৃহমধ্যে তিষ্টন্ মামিত্যাজ্ঞাপিতৱান্, যাফোনগরং প্রতি লোকান্ প্রহিত্য পিতরনাম্না ৱিখ্যাতং শিমোনম্ আহূযয; ");
INSERT INTO sanben_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ততস্তৱ ৎৱদীযপরিৱারাণাঞ্চ যেন পরিত্রাণং ভৱিষ্যতি তৎ স উপদেক্ষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","অহং তাং কথামুত্থাপ্য কথিতৱান্ তেন প্রথমম্ অস্মাকম্ উপরি যথা পৱিত্র আত্মাৱরূঢৱান্ তথা তেষামপ্যুপরি সমৱরূঢৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","তেন যোহন্ জলে মজ্জিতৱান্ ইতি সত্যং কিন্তু যূযং পৱিত্র আত্মনি মজ্জিতা ভৱিষ্যথ, ইতি যদ্ৱাক্যং প্রভুরুদিতৱান্ তৎ তদা মযা স্মৃতম্| ");
INSERT INTO sanben_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","অতঃ প্রভা যীশুখ্রীষ্টে প্রত্যযকারিণো যে ৱযম্ অস্মভ্যম্ ঈশ্ৱরো যদ্ দত্তৱান্ তৎ তেভ্যো লোকেভ্যোপি দত্তৱান্ ততঃ কোহং? কিমহম্ ঈশ্ৱরং ৱারযিতুং শক্নোমি? ");
INSERT INTO sanben_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","কথামেতাং শ্রুৱা তে ক্ষান্তা ঈশ্ৱরস্য গুণান্ অনুকীর্ত্ত্য কথিতৱন্তঃ, তর্হি পরমাযুঃপ্রাপ্তিনিমিত্তম্ ঈশ্ৱরোন্যদেশীযলোকেভ্যোপি মনঃপরিৱর্ত্তনরূপং দানম্ অদাৎ| ");
INSERT INTO sanben_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","স্তিফানং প্রতি উপদ্রৱে ঘটিতে যে ৱিকীর্ণা অভৱন্ তৈ ফৈনীকীকুপ্রান্তিযখিযাসু ভ্রমিৎৱা কেৱলযিহূদীযলোকান্ ৱিনা কস্যাপ্যন্যস্য সমীপ ঈশ্ৱরস্য কথাং ন প্রাচারযন্| ");
INSERT INTO sanben_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","অপরং তেষাং কুপ্রীযাঃ কুরীনীযাশ্চ কিযন্তো জনা আন্তিযখিযানগরং গৎৱা যূনানীযলোকানাং সমীপেপি প্রভোর্যীশোঃ কথাং প্রাচারযন্| ");
INSERT INTO sanben_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","প্রভোঃ করস্তেষাং সহায আসীৎ তস্মাদ্ অনেকে লোকা ৱিশ্ৱস্য প্রভুং প্রতি পরাৱর্ত্তন্ত| ");
INSERT INTO sanben_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ইতি ৱার্ত্তাযাং যিরূশালমস্থমণ্ডলীযলোকানাং কর্ণগোচরীভূতাযাম্ আন্তিযখিযানগরং গন্তু তে বর্ণব্বাং প্রৈরযন্| ");
INSERT INTO sanben_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ততো বর্ণব্বাস্তত্র উপস্থিতঃ সন্ ঈশ্ৱরস্যানুগ্রহস্য ফলং দৃষ্ট্ৱা সানন্দো জাতঃ, ");
INSERT INTO sanben_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","স স্ৱযং সাধু র্ৱিশ্ৱাসেন পৱিত্রেণাত্মনা চ পরিপূর্ণঃ সন্ গনোনিষ্টযা প্রভাৱাস্থাং কর্ত্তুং সর্ৱ্ৱান্ উপদিষ্টৱান্ তেন প্রভোঃ শিষ্যা অনেকে বভূৱুঃ| ");
INSERT INTO sanben_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","শেষে শৌলং মৃগযিতুং বর্ণব্বাস্তার্ষনগরং প্রস্থিতৱান্| তত্র তস্যোদ্দেশং প্রাপ্য তম্ আন্তিযখিযানগরম্ আনযৎ; ");
INSERT INTO sanben_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ততস্তৌ মণ্ডলীস্থলোকৈঃ সভাং কৃৎৱা সংৱৎসরমেকং যাৱদ্ বহুলোকান্ উপাদিশতাং; তস্মিন্ আন্তিযখিযানগরে শিষ্যাঃ প্রথমং খ্রীষ্টীযনাম্না ৱিখ্যাতা অভৱন্| ");
INSERT INTO sanben_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","ততঃ পরং ভৱিষ্যদ্ৱাদিগণে যিরূশালম আন্তিযখিযানগরম্ আগতে সতি ");
INSERT INTO sanben_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","আগাবনামা তেষামেক উত্থায আত্মনঃ শিক্ষযা সর্ৱ্ৱদেশে দুর্ভিক্ষং ভৱিষ্যতীতি জ্ঞাপিতৱান্; ততঃ ক্লৌদিযকৈসরস্যাধিকারে সতি তৎ প্রত্যক্ষম্ অভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","তস্মাৎ শিষ্যা একৈকশঃ স্ৱস্ৱশক্ত্যনুসারতো যিহূদীযদেশনিৱাসিনাং ভ্রতৃণাং দিনযাপনার্থং ধনং প্রেষযিতুং নিশ্চিত্য ");
INSERT INTO sanben_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","বর্ণব্বাশৌলযো র্দ্ৱারা প্রাচীনলোকানাং সমীপং তৎ প্রেষিতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","তস্মিন্ সমযে হেরোদ্‌রাজো মণ্ডল্যাঃ কিযজ্জনেভ্যো দুঃখং দাতুং প্রারভৎ| ");
INSERT INTO sanben_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ৱিশেষতো যোহনঃ সোদরং যাকূবং করৱালাঘাতেন্ হতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","তস্মাদ্ যিহূদীযাঃ সন্তুষ্টা অভৱন্ ইতি ৱিজ্ঞায স পিতরমপি ধর্ত্তুং গতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","তদা কিণ্ৱশূন্যপূপোৎসৱসময উপাতিষ্টৎ; অত উৎসৱে গতে সতি লোকানাং সমক্ষং তং বহিরানেয্যামীতি মনসি স্থিরীকৃত্য স তং ধারযিৎৱা রক্ষ্ণার্থম্ যেষাম্ একৈকসংঘে চৎৱারো জনাঃ সন্তি তেষাং চতুর্ণাং রক্ষকসংঘানাং সমীপে তং সমর্প্য কারাযাং স্থাপিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","কিন্তুং পিতরস্য কারাস্থিতিকারণাৎ মণ্ডল্যা লোকা অৱিশ্রামম্ ঈশ্ৱরস্য সমীপে প্রার্থযন্ত| ");
INSERT INTO sanben_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","অনন্তরং হেরোদি তং বহিরানাযিতুং উদ্যতে সতি তস্যাং রাত্রৌ পিতরো রক্ষকদ্ৱযমধ্যস্থানে শৃঙ্খলদ্ৱযেন বদ্ধ্ৱঃ সন্ নিদ্রিত আসীৎ, দৌৱারিকাশ্চ কারাযাঃ সম্মুখে তিষ্ঠনতো দ্ৱারম্ অরক্ষিষুঃ| ");
INSERT INTO sanben_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","এতস্মিন্ সমযে পরমেশ্ৱরস্য দূতে সমুপস্থিতে কারা দীপ্তিমতী জাতা; ততঃ স দূতঃ পিতরস্য কুক্ষাৱাৱাতং কৃৎৱা তং জাগরযিৎৱা ভাষিতৱান্ তূর্ণমুত্তিষ্ঠ; ততস্তস্য হস্তস্থশৃঙ্খলদ্ৱযং গলৎ পতিতং| ");
INSERT INTO sanben_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","স দূতস্তমৱদৎ, বদ্ধকটিঃ সন্ পাদযোঃ পাদুকে অর্পয; তেন তথা কৃতে সতি দূতস্তম্ উক্তৱান্ গাত্রীযৱস্ত্রং গাত্রে নিধায মম পশ্চাদ্ এহি| ");
INSERT INTO sanben_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ততঃ পিতরস্তস্য পশ্চাদ্ ৱ্রজন বহিরগচ্ছৎ, কিন্তু দূতেন কর্ম্মৈতৎ কৃতমিতি সত্যমজ্ঞাৎৱা স্ৱপ্নদর্শনং জ্ঞাতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ইত্থং তৌ প্রথমাং দ্ৱিতীযাঞ্চ কারাং লঙ্ঘিৎৱা যেন লৌহনির্ম্মিতদ্ৱারেণ নগরং গম্যতে তৎসমীপং প্রাপ্নুতাং; ততস্তস্য কৱাটং স্ৱযং মুক্তমভৱৎ ততস্তৌ তৎস্থানাদ্ বহি র্ভূৎৱা মার্গৈকস্য সীমাং যাৱদ্ গতৌ; ততোঽকস্মাৎ স দূতঃ পিতরং ত্যক্তৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","তদা স চেতনাং প্রাপ্য কথিতৱান্ নিজদূতং প্রহিত্য পরমেশ্ৱরো হেরোদো হস্তাদ্ যিহূদীযলোকানাং সর্ৱ্ৱাশাযাশ্চ মাং সমুদ্ধৃতৱান্ ইত্যহং নিশ্চযং জ্ঞাতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","স ৱিৱিচ্য মার্কনাম্রা ৱিখ্যাতস্য যোহনো মাতু র্মরিযমো যস্মিন্ গৃহে বহৱঃ সম্ভূয প্রার্থযন্ত তন্নিৱেশনং গতঃ| ");
INSERT INTO sanben_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","পিতরেণ বহির্দ্ৱার আহতে সতি রোদানামা বালিকা দ্রষ্টুং গতা| ");
INSERT INTO sanben_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","ততঃ পিতরস্য স্ৱরং শ্রুৱা সা হর্ষযুক্তা সতী দ্ৱারং ন মোচযিৎৱা পিতরো দ্ৱারে তিষ্ঠতীতি ৱার্ত্তাং ৱক্তুম্ অভ্যন্তরং ধাৱিৎৱা গতৱতী| ");
INSERT INTO sanben_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","তে প্রাৱোচন্ ৎৱমুন্মত্তা জাতাসি কিন্তু সা মুহুর্মুহুরুক্তৱতী সত্যমেৱৈতৎ| ");
INSERT INTO sanben_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","তদা তে কথিতৱন্তস্তর্হি তস্য দূতো ভৱেৎ| ");
INSERT INTO sanben_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","পিতরো দ্ৱারমাহতৱান্ এতস্মিন্নন্তরে দ্ৱারং মোচযিৎৱা পিতরং দৃষ্ট্ৱা ৱিস্মযং প্রাপ্তাঃ| ");
INSERT INTO sanben_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","ততঃ পিতরো নিঃশব্দং স্থাতুং তান্ প্রতি হস্তেন সঙ্কেতং কৃৎৱা পরমেশ্ৱরো যেন প্রকারেণ তং কারাযা উদ্ধৃত্যানীতৱান্ তস্য ৱৃত্তান্তং তানজ্ঞাপযৎ, যূযং গৎৱা যাকুবং ভ্রাতৃগণঞ্চ ৱার্ত্তামেতাং ৱদতেত্যুক্তা স্থানান্তরং প্রস্থিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","প্রভাতে সতি পিতরঃ ক্ৱ গত ইত্যত্র রক্ষকাণাং মধ্যে মহান্ কলহো জাতঃ| ");
INSERT INTO sanben_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","হেরোদ্ বহু মৃগযিৎৱা তস্যোদ্দেশে ন প্রাপ্তে সতি রক্ষকান্ সংপৃচ্ছ্য তেষাং প্রাণান্ হন্তুম্ আদিষ্টৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","পশ্চাৎ স যিহূদীযপ্রদেশাৎ কৈসরিযানগরং গৎৱা তত্রাৱাতিষ্ঠৎ| ");
INSERT INTO sanben_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","সোরসীদোনদেশযো র্লোকেভ্যো হেরোদি যুযুৎসৌ সতি তে সর্ৱ্ৱ একমন্ত্রণাঃ সন্তস্তস্য সমীপ উপস্থায ল্ৱাস্তনামানং তস্য ৱস্ত্রগৃহাধীশং সহাযং কৃৎৱা হেরোদা সার্দ্ধং সন্ধিং প্রার্থযন্ত যতস্তস্য রাজ্ঞো দেশেন তেষাং দেশীযানাং ভরণম্ অভৱৎং ");
INSERT INTO sanben_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","অতঃ কুত্রচিন্ নিরুপিতদিনে হেরোদ্ রাজকীযং পরিচ্ছদং পরিধায সিংহাসনে সমুপৱিশ্য তান্ প্রতি কথাম্ উক্তৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","ততো লোকা উচ্চৈঃকারং প্রত্যৱদন্, এষ মনুজরৱো ন হি, ঈশ্ৱরীযরৱঃ| ");
INSERT INTO sanben_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","তদা হেরোদ্ ঈশ্ৱরস্য সম্মানং নাকরোৎ; তস্মাদ্ধেতোঃ পরমেশ্ৱরস্য দূতো হঠাৎ তং প্রাহরৎ তেনৈৱ স কীটৈঃ ক্ষীণঃ সন্ প্রাণান্ অজহাৎ| কিন্ত্ৱীশ্ৱরস্য কথা দেশং ৱ্যাপ্য প্রবলাভৱৎ| ততঃ পরং বর্ণব্বাশৌলৌ যস্য কর্ম্মণো ভারং প্রাপ্নুতাং তাভ্যাং তস্মিন্ সম্পাদিতে সতি মার্কনাম্না ৱিখ্যাতো যো যোহন্ তং সঙ্গিনং কৃৎৱা যিরূশালম্নগরাৎ প্রত্যাগতৌ| ");
INSERT INTO sanben_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","অপরঞ্চ বর্ণব্বাঃ, শিমোন্ যং নিগ্রং ৱদন্তি, কুরীনীযলূকিযো হেরোদা রাজ্ঞা সহ কৃতৱিদ্যাाভ্যাসো মিনহেম্, শৌলশ্চৈতে যে কিযন্তো জনা ভৱিষ্যদ্ৱাদিন উপদেষ্টারশ্চান্তিযখিযানগরস্থমণ্ডল্যাম্ আসন্, ");
INSERT INTO sanben_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","তে যদোপৱাসং কৃৎৱেশ্ৱরম্ অসেৱন্ত তস্মিন্ সমযে পৱিত্র আত্মা কথিতৱান্ অহং যস্মিন্ কর্ম্মণি বর্ণব্বাশৈলৌ নিযুক্তৱান্ তৎকর্ম্ম কর্ত্তুং তৌ পৃথক্ কুরুত| ");
INSERT INTO sanben_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","ততস্তৈরুপৱাসপ্রার্থনযোঃ কৃতযোঃ সতোস্তে তযো র্গাত্রযো র্হস্তার্পণং কৃৎৱা তৌ ৱ্যসৃজন্| ");
INSERT INTO sanben_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","ততঃ পরং তৌ পৱিত্রেণাত্মনা প্রেরিতৌ সন্তৌ সিলূকিযানগরম্ উপস্থায সমুদ্রপথেন কুপ্রোপদ্ৱীপম্ অগচ্ছতাং| ");
INSERT INTO sanben_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ততঃ সালামীনগরম্ উপস্থায তত্র যিহূদীযানাং ভজনভৱনানি গৎৱেশ্ৱরস্য কথাং প্রাচারযতাং; যোহনপি তৎসহচরোঽভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ইত্থং তে তস্যোপদ্ৱীপস্য সর্ৱ্ৱত্র ভ্রমন্তঃ পাফনগরম্ উপস্থিতাঃ; তত্র সুৱিৱেচকেন সর্জিযপৌলনাম্না তদ্দেশাধিপতিনা সহ ভৱিষ্যদ্ৱাদিনো ৱেশধারী বর্যীশুনামা যো মাযাৱী যিহূদী আসীৎ তং সাক্ষাৎ প্রাপ্তৱতঃ| ");
INSERT INTO sanben_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","তদ্দেশাধিপ ঈশ্ৱরস্য কথাং শ্রোতুং ৱাঞ্ছন্ পৌলবর্ণব্বৌ ন্যমন্ত্রযৎ| ");
INSERT INTO sanben_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","কিন্ত্ৱিলুমা যং মাযাৱিনং ৱদন্তি স দেশাধিপতিং ধর্ম্মমার্গাদ্ বহির্ভূতং কর্ত্তুম্ অযতত| ");
INSERT INTO sanben_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","তস্মাৎ শোলোঽর্থাৎ পৌলঃ পৱিত্রেণাত্মনা পরিপূর্ণঃ সন্ তং মাযাৱিনং প্রত্যনন্যদৃষ্টিং কৃৎৱাকথযৎ, ");
INSERT INTO sanben_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","হে নরকিন্ ধর্ম্মদ্ৱেষিন্ কৌটিল্যদুষ্কর্ম্মপরিপূর্ণ, ৎৱং কিং প্রভোঃ সত্যপথস্য ৱিপর্য্যযকরণাৎ কদাপি ন নিৱর্ত্তিষ্যসে? ");
INSERT INTO sanben_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","অধুনা পরমেশ্ৱরস্তৱ সমুচিতং করিষ্যতি তেন কতিপযদিনানি ৎৱম্ অন্ধঃ সন্ সূর্য্যমপি ন দ্রক্ষ্যসি| তৎক্ষণাদ্ রাত্রিৱদ্ অন্ধকারস্তস্য দৃষ্টিম্ আচ্ছাদিতৱান্; তস্মাৎ তস্য হস্তং ধর্ত্তুং স লোকমন্ৱিচ্ছন্ ইতস্ততো ভ্রমণং কৃতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","এনাং ঘটনাং দৃষ্ট্ৱা স দেশাধিপতিঃ প্রভূপদেশাদ্ ৱিস্মিত্য ৱিশ্ৱাসং কৃতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","তদনন্তরং পৌলস্তৎসঙ্গিনৌ চ পাফনগরাৎ প্রোতং চালযিৎৱা পম্ফুলিযাদেশস্য পর্গীনগরম্ অগচ্ছন্ কিন্তু যোহন্ তযোঃ সমীপাদ্ এত্য যিরূশালমং প্রত্যাগচ্ছৎ| ");
INSERT INTO sanben_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","পশ্চাৎ তৌ পর্গীতো যাত্রাং কৃৎৱা পিসিদিযাদেশস্য আন্তিযখিযানগরম্ উপস্থায ৱিশ্রামৱারে ভজনভৱনং প্রৱিশ্য সমুপাৱিশতাং| ");
INSERT INTO sanben_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ৱ্যৱস্থাভৱিষ্যদ্ৱাক্যযোঃ পঠিতযোঃ সতো র্হে ভ্রাতরৌ লোকান্ প্রতি যুৱযোঃ কাচিদ্ উপদেশকথা যদ্যস্তি তর্হি তাং ৱদতং তৌ প্রতি তস্য ভজনভৱনস্যাধিপতযঃ কথাম্ এতাং কথযিৎৱা প্রৈষযন্| ");
INSERT INTO sanben_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","অতঃ পৌল উত্তিষ্ঠন্ হস্তেন সঙ্কেতং কুর্ৱ্ৱন্ কথিতৱান্ হে ইস্রাযেলীযমনুষ্যা ঈশ্ৱরপরাযণাঃ সর্ৱ্ৱে লোকা যূযম্ অৱধদ্ধং| ");
INSERT INTO sanben_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","এতেষামিস্রাযেল্লোকানাম্ ঈশ্ৱরোঽস্মাকং পূর্ৱ্ৱপরুষান্ মনোনীতান্ কৎৱা গৃহীতৱান্ ততো মিসরি দেশে প্রৱসনকালে তেষামুন্নতিং কৃৎৱা তস্মাৎ স্ৱীযবাহুবলেন তান্ বহিঃ কৃৎৱা সমানযৎ| ");
INSERT INTO sanben_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","চৎৱারিংশদ্ৱৎসরান্ যাৱচ্চ মহাপ্রান্তরে তেষাং ভরণং কৃৎৱা ");
INSERT INTO sanben_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","কিনান্দেশান্তর্ৱ্ৱর্ত্তীণি সপ্তরাজ্যানি নাশযিৎৱা গুটিকাপাতেন তেষু সর্ৱ্ৱদেশেষু তেভ্যোঽধিকারং দত্তৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","পঞ্চাশদধিকচতুঃশতেষু ৱৎসরেষু গতেষু চ শিমূযেল্ভৱিষ্যদ্ৱাদিপর্য্যন্তং তেষামুপরি ৱিচারযিতৃন্ নিযুক্তৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","তৈশ্চ রাজ্ঞি প্রার্থিতে, ঈশ্ৱরো বিন্যামীনো ৱংশজাতস্য কীশঃ পুত্রং শৌলং চৎৱারিংশদ্ৱর্ষপর্য্যন্তং তেষামুপরি রাজানং কৃতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","পশ্চাৎ তং পদচ্যুতং কৃৎৱা যো মদিষ্টক্রিযাঃ সর্ৱ্ৱাঃ করিষ্যতি তাদৃশং মম মনোভিমতম্ একং জনং যিশযঃ পুত্রং দাযূদং প্রাপ্তৱান্ ইদং প্রমাণং যস্মিন্ দাযূদি স দত্তৱান্ তং দাযূদং তেষামুপরি রাজৎৱং কর্ত্তুম্ উৎপাদিতৱান| ");
INSERT INTO sanben_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","তস্য স্ৱপ্রতিশ্রুতস্য ৱাক্যস্যানুসারেণ ইস্রাযেল্লোকানাং নিমিত্তং তেষাং মনুষ্যাণাং ৱংশাদ্ ঈশ্ৱর একং যীশুং (ত্রাতারম্) উদপাদযৎ| ");
INSERT INTO sanben_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","তস্য প্রকাশনাৎ পূর্ৱ্ৱং যোহন্ ইস্রাযেল্লোকানাং সন্নিধৌ মনঃপরাৱর্ত্তনরূপং মজ্জনং প্রাচারযৎ| ");
INSERT INTO sanben_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","যস্য চ কর্ম্মণোे ভারং প্রপ্তৱান্ যোহন্ তন্ নিষ্পাদযন্ এতাং কথাং কথিতৱান্, যূযং মাং কং জনং জানীথ? অহম্ অভিষিক্তত্রাতা নহি, কিন্তু পশ্যত যস্য পাদযোঃ পাদুকযো র্বন্ধনে মোচযিতুমপি যোগ্যো ন ভৱামি তাদৃশ একো জনো মম পশ্চাদ্ উপতিষ্ঠতি| ");
INSERT INTO sanben_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","হে ইব্রাহীমো ৱংশজাতা ভ্রাতরো হে ঈশ্ৱরভীতাঃ সর্ৱ্ৱলোকা যুষ্মান্ প্রতি পরিত্রাণস্য কথৈষা প্রেরিতা| ");
INSERT INTO sanben_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","যিরূশালম্নিৱাসিনস্তেষাম্ অধিপতযশ্চ তস্য যীশোঃ পরিচযং ন প্রাপ্য প্রতিৱিশ্রামৱারং পঠ্যমানানাং ভৱিষ্যদ্ৱাদিকথানাম্ অভিপ্রাযম্ অবুদ্ধ্ৱা চ তস্য ৱধেন তাঃ কথাঃ সফলা অকুর্ৱ্ৱন্| ");
INSERT INTO sanben_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","প্রাণহননস্য কমপি হেতুম্ অপ্রাপ্যাপি পীলাতস্য নিকটে তস্য ৱধং প্রার্থযন্ত| ");
INSERT INTO sanben_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","তস্মিন্ যাঃ কথা লিখিতাঃ সন্তি তদনুসারেণ কর্ম্ম সম্পাদ্য তং ক্রুশাদ্ অৱতার্য্য শ্মশানে শাযিতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","কিন্ত্ৱীশ্ৱরঃ শ্মশানাৎ তমুদস্থাপযৎ, ");
INSERT INTO sanben_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","পুনশ্চ গালীলপ্রদেশাদ্ যিরূশালমনগরং তেন সার্দ্ধং যে লোকা আগচ্ছন্ স বহুদিনানি তেভ্যো দর্শনং দত্তৱান্, অতস্ত ইদানীং লোকান্ প্রতি তস্য সাক্ষিণঃ সন্তি| ");
INSERT INTO sanben_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","অস্মাকং পূর্ৱ্ৱপুরুষাণাং সমক্ষম্ ঈশ্ৱরো যস্মিন্ প্রতিজ্ঞাতৱান্ যথা, ৎৱং মে পুত্রোসি চাদ্য ৎৱাং সমুত্থাপিতৱানহম্| ");
INSERT INTO sanben_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ইদং যদ্ৱচনং দ্ৱিতীযগীতে লিখিতমাস্তে তদ্ যীশোরুত্থানেন তেষাং সন্তানা যে ৱযম্ অস্মাকং সন্নিধৌ তেন প্রত্যক্ষী কৃতং, যুষ্মান্ ইমং সুসংৱাদং জ্ঞাপযামি| ");
INSERT INTO sanben_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","পরমেশ্ৱরেণ শ্মশানাদ্ উত্থাপিতং তদীযং শরীরং কদাপি ন ক্ষেষ্যতে, এতস্মিন্ স স্ৱযং কথিতৱান্ যথা দাযূদং প্রতি প্রতিজ্ঞাতো যো ৱরস্তমহং তুভ্যং দাস্যামি| ");
INSERT INTO sanben_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","এতদন্যস্মিন্ গীতেঽপি কথিতৱান্| স্ৱকীযং পুণ্যৱন্তং ৎৱং ক্ষযিতুং ন চ দাস্যসি| ");
INSERT INTO sanben_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","দাযূদা ঈশ্ৱরাভিমতসেৱাযৈ নিজাযুষি ৱ্যযিতে সতি স মহানিদ্রাং প্রাপ্য নিজৈঃ পূর্ৱ্ৱপুরুষৈঃ সহ মিলিতঃ সন্ অক্ষীযত; ");
INSERT INTO sanben_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","কিন্তু যমীশ্ৱরঃ শ্মশানাদ্ উদস্থাপযৎ স নাক্ষীযত| ");
INSERT INTO sanben_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","অতো হে ভ্রাতরঃ, অনেন জনেন পাপমোচনং ভৱতীতি যুষ্মান্ প্রতি প্রচারিতম্ আস্তে| ");
INSERT INTO sanben_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ফলতো মূসাৱ্যৱস্থযা যূযং যেভ্যো দোষেভ্যো মুক্তা ভৱিতুং ন শক্ষ্যথ তেভ্যঃ সর্ৱ্ৱদোষেভ্য এতস্মিন্ জনে ৱিশ্ৱাসিনঃ সর্ৱ্ৱে মুক্তা ভৱিষ্যন্তীতি যুষ্মাভি র্জ্ঞাযতাং| ");
INSERT INTO sanben_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","অপরঞ্চ| অৱজ্ঞাকারিণো লোকাশ্চক্ষুরুন্মীল্য পশ্যত| তথৈৱাসম্ভৱং জ্ঞাৎৱা স্যাত যূযং ৱিলজ্জিতাঃ| যতো যুষ্মাসু তিষ্ঠৎসু করিষ্যে কর্ম্ম তাদৃশং| যেনৈৱ তস্য ৱৃত্তান্তে যুষ্মভ্যং কথিতেঽপি হি| যূযং ন তন্তু ৱৃত্তান্তং প্রত্যেষ্যথ কদাচন|| ");
INSERT INTO sanben_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","যেযং কথা ভৱিষ্যদ্ৱাদিনাং গ্রন্থেষু লিখিতাস্তে সাৱধানা ভৱত স কথা যথা যুষ্মান্ প্রতি ন ঘটতে| ");
INSERT INTO sanben_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","যিহূদীযভজনভৱনান্ নির্গতযোস্তযো র্ভিন্নদেশীযৈ র্ৱক্ষ্যমাণা প্রার্থনা কৃতা, আগামিনি ৱিশ্রামৱারেঽপি কথেযম্ অস্মান্ প্রতি প্রচারিতা ভৱৎৱিতি| ");
INSERT INTO sanben_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","সভাযা ভঙ্গে সতি বহৱো যিহূদীযলোকা যিহূদীযমতগ্রাহিণো ভক্তলোকাশ্চ বর্ণব্বাপৌলযোঃ পশ্চাদ্ আগচ্ছন্, তেন তৌ তৈঃ সহ নানাকথাঃ কথযিৎৱেশ্ৱরানুগ্রহাশ্রযে স্থাতুং তান্ প্রাৱর্ত্তযতাং| ");
INSERT INTO sanben_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","পরৱিশ্রামৱারে নগরস্য প্রাযেণ সর্ৱ্ৱে লাকা ঈশ্ৱরীযাং কথাং শ্রোতুং মিলিতাঃ, ");
INSERT INTO sanben_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","কিন্তু যিহূদীযলোকা জননিৱহং ৱিলোক্য ঈর্ষ্যযা পরিপূর্ণাঃ সন্তো ৱিপরীতকথাকথনেনেশ্ৱরনিন্দযা চ পৌলেনোক্তাং কথাং খণ্ডযিতুং চেষ্টিতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","ততঃ পৌैলবর্ণব্বাৱক্ষোভৌ কথিতৱন্তৌ প্রথমং যুষ্মাকং সন্নিধাৱীশ্ৱরীযকথাযাঃ প্রচারণম্ উচিতমাসীৎ কিন্তুং তদগ্রাহ্যৎৱকরণেন যূযং স্ৱান্ অনন্তাযুষোঽযোগ্যান্ দর্শযথ, এতৎকারণাদ্ ৱযম্ অন্যদেশীযলোকানাং সমীপং গচ্ছামঃ| ");
INSERT INTO sanben_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","প্রভুরস্মান্ ইত্থম্ আদিষ্টৱান্ যথা, যাৱচ্চ জগতঃ সীমাং লোকানাং ত্রাণকারণাৎ| মযান্যদেশমধ্যে ৎৱং স্থাপিতো ভূঃ প্রদীপৱৎ|| ");
INSERT INTO sanben_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","তদা কথামীদৃশীং শ্রুৎৱা ভিন্নদেশীযা আহ্লাদিতাঃ সন্তঃ প্রভোঃ কথাং ধন্যাং ধন্যাম্ অৱদন্, যাৱন্তো লোকাশ্চ পরমাযুঃ প্রাপ্তিনিমিত্তং নিরূপিতা আসন্ তেे ৱ্যশ্ৱসন্| ");
INSERT INTO sanben_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ইত্থং প্রভোঃ কথা সর্ৱ্ৱেদেশং ৱ্যাপ্নোৎ| ");
INSERT INTO sanben_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","কিন্তু যিহূদীযা নগরস্য প্রধানপুরুষান্ সম্মান্যাঃ কথিপযা ভক্তা যোষিতশ্চ কুপ্রৱৃত্তিং গ্রাহযিৎৱা পৌলবর্ণব্বৌ তাডযিৎৱা তস্মাৎ প্রদেশাদ্ দূরীকৃতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","অতঃ কারণাৎ তৌ নিজপদধূলীস্তেষাং প্রাতিকূল্যেন পাতযিৎৱেेকনিযং নগরং গতৌ| ");
INSERT INTO sanben_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","ততঃ শিষ্যগণ আনন্দেন পৱিত্রেণাত্মনা চ পরিপূর্ণোভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","তৌ দ্ৱৌ জনৌ যুগপদ্ ইকনিযনগরস্থযিহূদীযানাং ভজনভৱনং গৎৱা যথা বহৱো যিহূদীযা অন্যদেेশীযলোকাশ্চ ৱ্যশ্ৱসন্ তাদৃশীং কথাং কথিতৱন্তৌ| ");
INSERT INTO sanben_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","কিন্তু ৱিশ্ৱাসহীনা যিহূদীযা অন্যদেশীযলোকান্ কুপ্রৱৃত্তিং গ্রাহযিৎৱা ভ্রাতৃগণং প্রতি তেষাং ৱৈরং জনিতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","অতঃ স্ৱানুগ্রহকথাযাঃ প্রমাণং দৎৱা তযো র্হস্তৈ র্বহুলক্ষণম্ অদ্ভুতকর্ম্ম চ প্রাকাশযদ্ যঃ প্রভুস্তস্য কথা অক্ষোভেন প্রচার্য্য তৌ তত্র বহুদিনানি সমৱাতিষ্ঠেতাং| ");
INSERT INTO sanben_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","কিন্তু কিযন্তো লোকা যিহূদীযানাং সপক্ষাঃ কিযন্তো লোকাঃ প্রেরিতানাং সপক্ষা জাতাঃ, অতো নাগরিকজননিৱহমধ্যে ভিন্নৱাক্যৎৱম্ অভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","অন্যদেশীযা যিহূদীযাস্তেষাম্ অধিপতযশ্চ দৌরাত্ম্যং কুৎৱা তৌ প্রস্তরৈরাহন্তুম্ উদ্যতাঃ| ");
INSERT INTO sanben_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","তৌ তদ্ৱার্ত্তাং প্রাপ্য পলাযিৎৱা লুকাযনিযাদেশস্যান্তর্ৱ্ৱর্ত্তিলুস্ত্রাদর্ব্বো ");
INSERT INTO sanben_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","তৎসমীপস্থদেশঞ্চ গৎৱা তত্র সুসংৱাদং প্রচারযতাং| ");
INSERT INTO sanben_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","তত্রোভযপাদযোশ্চলনশক্তিহীনো জন্মারভ্য খঞ্জঃ কদাপি গমনং নাকরোৎ এতাদৃশ একো মানুষো লুস্ত্রানগর উপৱিশ্য পৌলস্য কথাং শ্রুতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","এতস্মিন্ সমযে পৌলস্তম্প্রতি দৃষ্টিং কৃৎৱা তস্য স্ৱাস্থ্যে ৱিশ্ৱাসং ৱিদিৎৱা প্রোচ্চৈঃ কথিতৱান্ ");
INSERT INTO sanben_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","পদ্ভ্যামুত্তিষ্ঠন্ ঋজু র্ভৱ| ততঃ স উল্লম্ফং কৃৎৱা গমনাগমনে কুতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","তদা লোকাঃ পৌলস্য তৎ কার্য্যং ৱিলোক্য লুকাযনীযভাষযা প্রোচ্চৈঃ কথামেতাং কথিতৱন্তঃ, দেৱা মনুষ্যরূপং ধৃৎৱাস্মাকং সমীপম্ অৱারোহন্| ");
INSERT INTO sanben_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","তে বর্ণব্বাং যূপিতরম্ অৱদন্ পৌলশ্চ মুখ্যো ৱক্তা তস্মাৎ তং মর্কুরিযম্ অৱদন্| ");
INSERT INTO sanben_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","তস্য নগরস্য সম্মুখে স্থাপিতস্য যূপিতরৱিগ্রহস্য যাজকো ৱৃষান্ পুষ্পমালাশ্চ দ্ৱারসমীপম্ আনীয লোকৈঃ সর্দ্ধং তাৱুদ্দিশ্য সমুৎসৃজ্য দাতুম্ উদ্যতঃ| ");
INSERT INTO sanben_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","তদ্ৱার্ত্তাং শ্রুৎৱা বর্ণব্বাপৌলৌ স্ৱীযৱস্ত্রাণি ছিৎৱা লোকানাং মধ্যং ৱেগেন প্রৱিশ্য প্রোচ্চৈঃ কথিতৱন্তৌ, ");
INSERT INTO sanben_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","হে মহেচ্ছাঃ কুত এতাদৃশং কর্ম্ম কুরুথ? আৱামপি যুষ্মাদৃশৌ সুখদুঃখভোগিনৌ মনুষ্যৌ, যুযম্ এতাঃ সর্ৱ্ৱা ৱৃথাকল্পনাঃ পরিত্যজ্য যথা গগণৱসুন্ধরাজলনিধীনাং তন্মধ্যস্থানাং সর্ৱ্ৱেষাঞ্চ স্রষ্টারমমরম্ ঈশ্ৱরং প্রতি পরাৱর্ত্তধ্ৱে তদর্থম্ আৱাং যুষ্মাকং সন্নিধৌ সুসংৱাদং প্রচারযাৱঃ| ");
INSERT INTO sanben_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","স ঈশ্ৱরঃ পূর্ৱ্ৱকালে সর্ৱ্ৱদেশীযলোকান্ স্ৱস্ৱমার্গে চলিতুমনুমতিং দত্তৱান্, ");
INSERT INTO sanben_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","তথাপি আকাশাৎ তোযৱর্ষণেন নানাপ্রকারশস্যোৎপত্যা চ যুষ্মাকং হিতৈষী সন্ ভক্ষ্যৈরাননদেন চ যুষ্মাকম্ অন্তঃকরণানি তর্পযন্ তানি দানানি নিজসাক্ষিস্ৱরূপাণি স্থপিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","কিন্তু তাদৃশাযাং কথাযাং কথিতাযামপি তযোঃ সমীপ উৎসর্জনাৎ লোকনিৱহং প্রাযেণ নিৱর্ত্তযিতুং নাশক্নুতাম্| ");
INSERT INTO sanben_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","আন্তিযখিযা-ইকনিযনগরাভ্যাং কতিপযযিহূদীযলোকা আগত্য লোকান্ প্রাৱর্ত্তযন্ত তস্মাৎ তৈ পৌলং প্রস্তরৈরাঘ্নন্ তেন স মৃত ইতি ৱিজ্ঞায নগরস্য বহিস্তম্ আকৃষ্য নীতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","কিন্তু শিষ্যগণে তস্য চতুর্দিশি তিষ্ঠতি সতি স স্ৱযম্ উত্থায পুনরপি নগরমধ্যং প্রাৱিশৎ তৎপরেঽহনি বর্ণব্বাসহিতো দর্ব্বীনগরং গতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","তত্র সুসংৱাদং প্রচার্য্য বহুলোকান্ শিষ্যান্ কৃৎৱা তৌ লুস্ত্রাম্ ইকনিযম্ আন্তিযখিযাঞ্চ পরাৱৃত্য গতৌ| ");
INSERT INTO sanben_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","বহুদুঃখানি ভুক্ত্ৱাপীশ্ৱররাজ্যং প্রৱেষ্টৱ্যম্ ইতি কারণাদ্ ধর্ম্মমার্গে স্থাতুং ৱিনযং কৃৎৱা শিষ্যগণস্য মনঃস্থৈর্য্যম্ অকুরুতাং| ");
INSERT INTO sanben_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","মণ্ডলীনাং প্রাচীনৱর্গান্ নিযুজ্য প্রার্থনোপৱাসৌ কৃৎৱা যৎপ্রভৌ তে ৱ্যশ্ৱসন্ তস্য হস্তে তান্ সমর্প্য ");
INSERT INTO sanben_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","পিসিদিযামধ্যেন পাম্ফুলিযাদেশং গতৱন্তৌ| ");
INSERT INTO sanben_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","পশ্চাৎ পর্গানগরং গৎৱা সুসংৱাদং প্রচার্য্য অত্তালিযানগরং প্রস্থিতৱন্তৌ| ");
INSERT INTO sanben_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","তস্মাৎ সমুদ্রপথেন গৎৱা তাভ্যাং যৎ কর্ম্ম সম্পন্নং তৎকর্ম্ম সাধযিতুং যন্নগরে দযালোরীশ্ৱরস্য হস্তে সমর্পিতৌ জাতৌ তদ্ আন্তিযখিযানগরং গতৱন্তা| ");
INSERT INTO sanben_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","তত্রোপস্থায তন্নগরস্থমণ্ডলীং সংগৃহ্য স্ৱাভ্যাম ঈশ্ৱরো যদ্যৎ কর্ম্মকরোৎ তথা যেন প্রকারেণ ভিন্নদেশীযলোকান্ প্রতি ৱিশ্ৱাসরূপদ্ৱারম্ অমোচযদ্ এতান্ সর্ৱ্ৱৱৃত্তান্তান্ তান্ জ্ঞাপিতৱন্তৌ| ");
INSERT INTO sanben_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ততস্তৌ শির্য্যৈঃ সার্দ্ধং তত্র বহুদিনানি ন্যৱসতাম্| ");
INSERT INTO sanben_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","যিহূদাদেশাৎ কিযন্তো জনা আগত্য ভ্রাতৃগণমিত্থং শিক্ষিতৱন্তো মূসাৱ্যৱস্থযা যদি যুষ্মাকং ৎৱক্ছেদো ন ভৱতি তর্হি যূযং পরিত্রাণং প্রাপ্তুং ন শক্ষ্যথ| ");
INSERT INTO sanben_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","পৌলবর্ণব্বৌ তৈঃ সহ বহূন্ ৱিচারান্ ৱিৱাদাংশ্চ কৃতৱন্তৌ, ততো মণ্ডলীযনোকা এতস্যাঃ কথাযাস্তত্ত্ৱং জ্ঞাতুং যিরূশালম্নগরস্থান্ প্রেরিতান্ প্রাচীনাংশ্চ প্রতি পৌলবর্ণব্বাপ্রভৃতীন্ কতিপযজনান্ প্রেষযিতুং নিশ্চযং কৃতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","তে মণ্ডল্যা প্রেরিতাঃ সন্তঃ ফৈণীকীশোমিরোন্দেশাভ্যাং গৎৱা ভিন্নদেশীযানাং মনঃপরিৱর্ত্তনস্য ৱার্ত্তযা ভ্রাতৃণাং পরমাহ্লাদম্ অজনযন্| ");
INSERT INTO sanben_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","যিরূশালম্যুপস্থায প্রেরিতগণেন লোকপ্রাচীনগণেন সমাজেন চ সমুপগৃহীতাঃ সন্তঃ স্ৱৈরীশ্ৱরো যানি কর্ম্মাণি কৃতৱান্ তেষাং সর্ৱ্ৱৱৃত্তান্তান্ তেষাং সমক্ষম্ অকথযন্| ");
INSERT INTO sanben_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","কিন্তু ৱিশ্ৱাসিনঃ কিযন্তঃ ফিরূশিমতগ্রাহিণো লোকা উত্থায কথামেতাং কথিতৱন্তো ভিন্নদেশীযানাং ৎৱক্ছেদং কর্ত্তুং মূসাৱ্যৱস্থাং পালযিতুঞ্চ সমাদেষ্টৱ্যম্| ");
INSERT INTO sanben_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","ততঃ প্রেরিতা লোকপ্রাচীনাশ্চ তস্য ৱিৱেচনাং কর্ত্তুং সভাযাং স্থিতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","বহুৱিচারেষু জাতষু পিতর উত্থায কথিতৱান্, হে ভ্রাতরো যথা ভিন্নদেশীযলোকা মম মুখাৎ সুসংৱাদং শ্রুৎৱা ৱিশ্ৱসন্তি তদর্থং বহুদিনাৎ পূর্ৱ্ৱম্ ঈশ্ৱরোস্মাকং মধ্যে মাং ৱৃৎৱা নিযুক্তৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","অন্তর্য্যামীশ্ৱরো যথাস্মভ্যং তথা ভিন্নদেশীযেভ্যঃ পৱিত্রমাত্মানং প্রদায ৱিশ্ৱাসেন তেষাম্ অন্তঃকরণানি পৱিত্রাণি কৃৎৱা ");
INSERT INTO sanben_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","তেষাম্ অস্মাকঞ্চ মধ্যে কিমপি ৱিশেষং ন স্থাপযিৎৱা তানধি স্ৱযং প্রমাণং দত্তৱান্ ইতি যূযং জানীথ| ");
INSERT INTO sanben_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","অতএৱাস্মাকং পূর্ৱ্ৱপুরুষা ৱযঞ্চ স্ৱযং যদ্যুগস্য ভারং সোঢুং ন শক্তাঃ সম্প্রতি তং শিষ্যগণস্য স্কন্ধেষু ন্যসিতুং কুত ঈশ্ৱরস্য পরীক্ষাং করিষ্যথ? ");
INSERT INTO sanben_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","প্রভো র্যীশুখ্রীষ্টস্যানুগ্রহেণ তে যথা ৱযমপি তথা পরিত্রাণং প্রাপ্তুম্ আশাং কুর্ম্মঃ| ");
INSERT INTO sanben_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","অনন্তরং বর্ণব্বাপৌলাভ্যাম্ ঈশ্ৱরো ভিন্নদেশীযানাং মধ্যে যদ্যদ্ আশ্চর্য্যম্ অদ্ভুতঞ্চ কর্ম্ম কৃতৱান্ তদ্ৱৃত্তান্তং তৌ স্ৱমুখাভ্যাম্ অৱর্ণযতাং সভাস্থাঃ সর্ৱ্ৱে নীরৱাঃ সন্তঃ শ্রুতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","তযোঃ কথাযাং সমাপ্তাযাং সত্যাং যাকূব্ কথযিতুম্ আরব্ধৱান্ ");
INSERT INTO sanben_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","হে ভ্রাতরো মম কথাযাম্ মনো নিধত্ত| ঈশ্ৱরঃ স্ৱনামার্থং ভিন্নদেশীযলোকানাম্ মধ্যাদ্ একং লোকসংঘং গ্রহীতুং মতিং কৃৎৱা যেন প্রকারেণ প্রথমং তান্ প্রতি কৃপাৱলেকনং কৃতৱান্ তং শিমোন্ ৱর্ণিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ভৱিষ্যদ্ৱাদিভিরুক্তানি যানি ৱাক্যানি তৈঃ সার্দ্ধম্ এতস্যৈক্যং ভৱতি যথা লিখিতমাস্তে| ");
INSERT INTO sanben_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","সর্ৱ্ৱেষাং কর্ম্মণাং যস্তু সাধকঃ পরমেশ্ৱরঃ| স এৱেদং ৱদেদ্ৱাক্যং শেষাঃ সকলমানৱাঃ| ভিন্নদেশীযলোকাশ্চ যাৱন্তো মম নামতঃ| ভৱন্তি হি সুৱিখ্যাতাস্তে যথা পরমেশিতুঃ| ");
INSERT INTO sanben_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","তৎৱং সম্যক্ সমীহন্তে তন্নিমিত্তমহং কিল| পরাৱৃত্য সমাগত্য দাযূদঃ পতিতং পুনঃ| দূষ্যমুত্থাপযিষ্যামি তদীযং সর্ৱ্ৱৱস্তু চ| পতিতং পুনরুথাপ্য সজ্জযিষ্যামি সর্ৱ্ৱথা|| ");
INSERT INTO sanben_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","আ প্রথমাদ্ ঈশ্ৱরঃ স্ৱীযানি সর্ৱ্ৱকর্ম্মাণি জানাতি| ");
INSERT INTO sanben_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","অতএৱ মম নিৱেদনমিদং ভিন্নদেশীযলোকানাং মধ্যে যে জনা ঈশ্ৱরং প্রতি পরাৱর্ত্তন্ত তেষামুপরি অন্যং কমপি ভারং ন ন্যস্য ");
INSERT INTO sanben_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","দেৱতাপ্রসাদাশুচিভক্ষ্যং ৱ্যভিচারকর্ম্ম কণ্ঠসম্পীডনমারিতপ্রাণিভক্ষ্যং রক্তভক্ষ্যঞ্চ এতানি পরিত্যক্তুং লিখামঃ| ");
INSERT INTO sanben_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","যতঃ পূর্ৱ্ৱকালতো মূসাৱ্যৱস্থাপ্রচারিণো লোকা নগরে নগরে সন্তি প্রতিৱিশ্রামৱারঞ্চ ভজনভৱনে তস্যাঃ পাঠো ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","ততঃ পরং প্রেরিতগণো লোকপ্রাচীনগণঃ সর্ৱ্ৱা মণ্ডলী চ স্ৱেষাং মধ্যে বর্শব্বা নাম্না ৱিখ্যাতো মনোনীতৌ কৃৎৱা পৌলবর্ণব্বাভ্যাং সার্দ্ধম্ আন্তিযখিযানগরং প্রতি প্রেষণম্ উচিতং বুদ্ধ্ৱা তাভ্যাং পত্রং প্রৈষযন্| ");
INSERT INTO sanben_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","তস্মিন্ পত্রে লিখিতমিংদ, আন্তিযখিযা-সুরিযা-কিলিকিযাদেশস্থভিন্নদেশীযভ্রাতৃগণায প্রেরিতগণস্য লোকপ্রাচীনগণস্য ভ্রাতৃগণস্য চ নমস্কারঃ| ");
INSERT INTO sanben_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","ৱিশেষতোঽস্মাকম্ আজ্ঞাম্ অপ্রাপ্যাপি কিযন্তো জনা অস্মাকং মধ্যাদ্ গৎৱা ৎৱক্ছেদো মূসাৱ্যৱস্থা চ পালযিতৱ্যাৱিতি যুষ্মান্ শিক্ষযিৎৱা যুষ্মাকং মনসামস্থৈর্য্যং কৃৎৱা যুষ্মান্ সসন্দেহান্ অকুর্ৱ্ৱন্ এতাং কথাং ৱযম্ অশৃন্ম| ");
INSERT INTO sanben_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","তৎকারণাদ্ ৱযম্ একমন্ত্রণাঃ সন্তঃ সভাযাং স্থিৎৱা প্রভো র্যীশুখ্রীষ্টস্য নামনিমিত্তং মৃত্যুমুখগতাভ্যামস্মাকং ");
INSERT INTO sanben_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","প্রিযবর্ণব্বাপৌলাভ্যাং সার্দ্ধং মনোনীতলোকানাং কেষাঞ্চিদ্ যুষ্মাকং সন্নিধৌ প্রেষণম্ উচিতং বুদ্ধৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","অতো যিহূদাসীলৌ যুষ্মান্ প্রতি প্রেষিতৱন্তঃ, এতযো র্মুখাভ্যাং সর্ৱ্ৱাং কথাং জ্ঞাস্যথ| ");
INSERT INTO sanben_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","দেৱতাপ্রসাদভক্ষ্যং রক্তভক্ষ্যং গলপীডনমারিতপ্রাণিভক্ষ্যং ৱ্যভিচারকর্ম্ম চেমানি সর্ৱ্ৱাণি যুষ্মাভিস্ত্যাজ্যানি; এতৎপ্রযোজনীযাজ্ঞাৱ্যতিরেকেন যুষ্মাকম্ উপরি ভারমন্যং ন ন্যসিতুং পৱিত্রস্যাত্মনোঽস্মাকঞ্চ উচিতজ্ঞানম্ অভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","অতএৱ তেভ্যঃ সর্ৱ্ৱেভ্যঃ স্ৱেষু রক্ষিতেষু যূযং ভদ্রং কর্ম্ম করিষ্যথ| যুষ্মাকং মঙ্গলং ভূযাৎ| ");
INSERT INTO sanben_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","তেे ৱিসৃষ্টাঃ সন্ত আন্তিযখিযানগর উপস্থায লোকনিৱহং সংগৃহ্য পত্রম্ অদদন্| ");
INSERT INTO sanben_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ততস্তে তৎপত্রং পঠিৎৱা সান্ত্ৱনাং প্রাপ্য সানন্দা অভৱন্| ");
INSERT INTO sanben_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","যিহূদাসীলৌ চ স্ৱযং প্রচারকৌ ভূৎৱা ভ্রাতৃগণং নানোপদিশ্য তান্ সুস্থিরান্ অকুরুতাম্| ");
INSERT INTO sanben_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ইত্থং তৌ তত্র তৈঃ সাকং কতিপযদিনানি যাপযিৎৱা পশ্চাৎ প্রেরিতানাং সমীপে প্রত্যাগমনার্থং তেষাং সন্নিধেঃ কল্যাণেন ৱিসৃষ্টাৱভৱতাং| ");
INSERT INTO sanben_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","কিন্তু সীলস্তত্র স্থাতুং ৱাঞ্ছিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","অপরং পৌলবর্ণব্বৌ বহৱঃ শিষ্যাশ্চ লোকান্ উপদিশ্য প্রভোঃ সুসংৱাদং প্রচারযন্ত আন্তিযখিযাযাং কালং যাপিতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","কতিপযদিনেষু গতেষু পৌলো বর্ণব্বাম্ অৱদৎ আগচ্ছাৱাং যেষু নগরেষ্ৱীশ্ৱরস্য সুসংৱাদং প্রচারিতৱন্তৌ তানি সর্ৱ্ৱনগরাণি পুনর্গৎৱা ভ্রাতরঃ কীদৃশাঃ সন্তীতি দ্রষ্টুং তান্ সাক্ষাৎ কুর্ৱ্ৱঃ| ");
INSERT INTO sanben_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","তেন মার্কনাম্না ৱিখ্যাতং যোহনং সঙ্গিনং কর্ত্তুং বর্ণব্বা মতিমকরোৎ, ");
INSERT INTO sanben_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","কিন্তু স পূর্ৱ্ৱং তাভ্যাং সহ কার্য্যার্থং ন গৎৱা পাম্ফূলিযাদেশে তৌ ত্যক্তৱান্ তৎকারণাৎ পৌলস্তং সঙ্গিনং কর্ত্তুম্ অনুচিতং জ্ঞাতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ইত্থং তযোরতিশযৱিরোধস্যোপস্থিতৎৱাৎ তৌ পরস্পরং পৃথগভৱতাং ততো বর্ণব্বা মার্কং গৃহীৎৱা পোতেন কুপ্রোপদ্ৱীপং গতৱান্; ");
INSERT INTO sanben_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","কিন্তু পৌলঃ সীলং মনোনীতং কৃৎৱা ভ্রাতৃভিরীশ্ৱরানুগ্রহে সমর্পিতঃ সন্ প্রস্থায ");
INSERT INTO sanben_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","সুরিযাকিলিকিযাদেশাভ্যাং মণ্ডলীঃ স্থিরীকুর্ৱ্ৱন্ অগচ্ছৎ| ");
INSERT INTO sanben_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","পৌলো দর্ব্বীলুস্ত্রানগরযোরুপস্থিতোভৱৎ তত্র তীমথিযনামা শিষ্য এক আসীৎ; স ৱিশ্ৱাসিন্যা যিহূদীযাযা যোষিতো গর্ব্ভজাতঃ কিন্তু তস্য পিতান্যদেশীযলোকঃ| ");
INSERT INTO sanben_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","স জনো লুস্ত্রা-ইকনিযনগরস্থানাং ভ্রাতৃণাং সমীপেপি সুখ্যাতিমান্ আসীৎ| ");
INSERT INTO sanben_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","পৌলস্তং স্ৱসঙ্গিনং কর্ত্তুং মতিং কৃৎৱা তং গৃহীৎৱা তদ্দেশনিৱাসিনাং যিহূদীযানাম্ অনুরোধাৎ তস্য ৎৱক্ছেদং কৃতৱান্ যতস্তস্য পিতা ভিন্নদেশীযলোক ইতি সর্ৱ্ৱৈরজ্ঞাযত| ");
INSERT INTO sanben_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","ততঃ পরং তে নগরে নগরে ভ্রমিৎৱা যিরূশালমস্থৈঃ প্রেরিতৈ র্লোকপ্রাচীনৈশ্চ নিরূপিতং যদ্ ৱ্যৱস্থাপত্রং তদনুসারেণাচরিতুং লোকেভ্যস্তদ্ দত্তৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","তেনৈৱ সর্ৱ্ৱে ধর্ম্মসমাজাঃ খ্রীষ্টধর্ম্মে সুস্থিরাঃ সন্তঃ প্রতিদিনং ৱর্দ্ধিতা অভৱন্| ");
INSERT INTO sanben_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","তেষু ফ্রুগিযাগালাতিযাদেশমধ্যেন গতেষু সৎসু পৱিত্র আত্মা তান্ আশিযাদেশে কথাং প্রকাশযিতুং প্রতিষিদ্ধৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","তথা মুসিযাদেশ উপস্থায বিথুনিযাং গন্তুং তৈরুদ্যোগে কৃতে আত্মা তান্ নান্ৱমন্যত| ");
INSERT INTO sanben_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","তস্মাৎ তে মুসিযাদেশং পরিত্যজ্য ত্রোযানগরং গৎৱা সমুপস্থিতাঃ| ");
INSERT INTO sanben_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","রাত্রৌ পৌলঃ স্ৱপ্নে দৃষ্টৱান্ একো মাকিদনিযলোকস্তিষ্ঠন্ ৱিনযং কৃৎৱা তস্মৈ কথযতি, মাকিদনিযাদেশম্ আগত্যাস্মান্ উপকুর্ৱ্ৱিতি| ");
INSERT INTO sanben_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","তস্যেত্থং স্ৱপ্নদর্শনাৎ প্রভুস্তদ্দেশীযলোকান্ প্রতি সুসংৱাদং প্রচারযিতুম্ অস্মান্ আহূযতীতি নিশ্চিতং বুদ্ধ্ৱা ৱযং তূর্ণং মাকিদনিযাদেশং গন্তুম্ উদ্যোগম্ অকুর্ম্ম| ");
INSERT INTO sanben_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","ততঃ পরং ৱযং ত্রোযানগরাদ্ প্রস্থায ঋজুমার্গেণ সামথ্রাকিযোপদ্ৱীপেন গৎৱা পরেঽহনি নিযাপলিনগর উপস্থিতাঃ| ");
INSERT INTO sanben_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","তস্মাদ্ গৎৱা মাকিদনিযান্তর্ৱ্ৱর্ত্তি রোমীযৱসতিস্থানং যৎ ফিলিপীনামপ্রধাননগরং তত্রোপস্থায কতিপযদিনানি তত্র স্থিতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","ৱিশ্রামৱারে নগরাদ্ বহি র্গৎৱা নদীতটে যত্র প্রার্থনাচার আসীৎ তত্রোপৱিশ্য সমাগতা নারীঃ প্রতি কথাং প্রাচারযাম| ");
INSERT INTO sanben_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","ততঃ থুযাতীরানগরীযা ধূষরাম্বরৱিক্রাযিণী লুদিযানামিকা যা ঈশ্ৱরসেৱিকা যোষিৎ শ্রোত্রীণাং মধ্য আসীৎ তযা পৌলোক্তৱাক্যানি যদ্ গৃহ্যন্তে তদর্থং প্রভুস্তস্যা মনোদ্ৱারং মুক্তৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","অতঃ সা যোষিৎ সপরিৱারা মজ্জিতা সতী ৱিনযং কৃৎৱা কথিতৱতী, যুষ্মাকং ৱিচারাদ্ যদি প্রভৌ ৱিশ্ৱাসিনী জাতাহং তর্হি মম গৃহম্ আগত্য তিষ্ঠত| ইত্থং সা যত্নেনাস্মান্ অস্থাপযৎ| ");
INSERT INTO sanben_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","যস্যা গণনযা তদধিপতীনাং বহুধনোপার্জনং জাতং তাদৃশী গণকভূতগ্রস্তা কাচন দাসী প্রার্থনাস্থানগমনকাল আগত্যাস্মান্ সাক্ষাৎ কৃতৱতী| ");
INSERT INTO sanben_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","সাস্মাকং পৌলস্য চ পশ্চাদ্ এত্য প্রোচ্চৈঃ কথামিমাং কথিতৱতী, মনুষ্যা এতে সর্ৱ্ৱোপরিস্থস্যেশ্ৱরস্য সেৱকাঃ সন্তোঽস্মান্ প্রতি পরিত্রাণস্য মার্গং প্রকাশযন্তি| ");
INSERT INTO sanben_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","সা কন্যা বহুদিনানি তাদৃশম্ অকরোৎ তস্মাৎ পৌলো দুঃখিতঃ সন্ মুখং পরাৱর্ত্য তং ভূতমৱদদ্, অহং যীশুখ্রীষ্টস্য নাম্না ৎৱামাজ্ঞাপযামি ৎৱমস্যা বহির্গচ্ছ; তেনৈৱ তৎক্ষণাৎ স ভূতস্তস্যা বহির্গতঃ| ");
INSERT INTO sanben_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","ততঃ স্ৱেষাং লাভস্য প্রত্যাশা ৱিফলা জাতেতি ৱিলোক্য তস্যাঃ প্রভৱঃ পৌলং সীলঞ্চ ধৃৎৱাকৃষ্য ৱিচারস্থানেঽধিপতীনাং সমীপম্ আনযন্| ");
INSERT INTO sanben_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ততঃ শাসকানাং নিকটং নীৎৱা রোমিলোকা ৱযম্ অস্মাকং যদ্ ৱ্যৱহরণং গ্রহীতুম্ আচরিতুঞ্চ নিষিদ্ধং, ");
INSERT INTO sanben_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ইমে যিহূদীযলোকাঃ সন্তোপি তদেৱ শিক্ষযিৎৱা নগরেঽস্মাকম্ অতীৱ কলহং কুর্ৱ্ৱন্তি, ");
INSERT INTO sanben_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","ইতি কথিতে সতি লোকনিৱহস্তযোঃ প্রাতিকূল্যেনোদতিষ্ঠৎ তথা শাসকাস্তযো র্ৱস্ত্রাণি ছিৎৱা ৱেত্রাঘাতং কর্ত্তুম্ আজ্ঞাপযন্| ");
INSERT INTO sanben_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","অপরং তে তৌ বহু প্রহার্য্য ৎৱমেতৌ কারাং নীৎৱা সাৱধানং রক্ষযেতি কারারক্ষকম্ আদিশন্| ");
INSERT INTO sanben_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ইত্থম্ আজ্ঞাং প্রাপ্য স তাৱভ্যন্তরস্থকারাং নীৎৱা পাদেষু পাদপাশীভি র্বদ্ধ্ৱা স্থাপিতাৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","অথ নিশীথসমযে পৌলসীলাৱীশ্ৱরমুদ্দিশ্য প্রাথনাং গানঞ্চ কৃতৱন্তৌ, কারাস্থিতা লোকাশ্চ তদশৃণ্ৱন্ ");
INSERT INTO sanben_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","তদাকস্মাৎ মহান্ ভূমিকম্পোঽভৱৎ তেন ভিত্তিমূলেন সহ কারা কম্পিতাভূৎ তৎক্ষণাৎ সর্ৱ্ৱাণি দ্ৱারাণি মুক্তানি জাতানি সর্ৱ্ৱেষাং বন্ধনানি চ মুক্তানি| ");
INSERT INTO sanben_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","অতএৱ কারারক্ষকো নিদ্রাতো জাগরিৎৱা কারাযা দ্ৱারাণি মুক্তানি দৃষ্ট্ৱা বন্দিলোকাঃ পলাযিতা ইত্যনুমায কোষাৎ খঙ্গং বহিঃ কৃৎৱাত্মঘাতং কর্ত্তুম্ উদ্যতঃ| ");
INSERT INTO sanben_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","কিন্তু পৌলঃ প্রোচ্চৈস্তমাহূয কথিতৱান্ পশ্য ৱযং সর্ৱ্ৱেঽত্রাস্মহে, ৎৱং নিজপ্রাণহিংসাং মাকার্ষীঃ| ");
INSERT INTO sanben_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","তদা প্রদীপম্ আনেতুম্ উক্ত্ৱা স কম্পমানঃ সন্ উল্লম্প্যাভ্যন্তরম্ আগত্য পৌলসীলযোঃ পাদেষু পতিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","পশ্চাৎ স তৌ বহিরানীয পৃষ্টৱান্ হে মহেচ্ছৌ পরিত্রাণং প্রাপ্তুং মযা কিং কর্ত্তৱ্যং? ");
INSERT INTO sanben_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","পশ্চাৎ তৌ স্ৱগৃহমানীয তযোঃ সম্মুখে খাদ্যদ্রৱ্যাণি স্থাপিতৱান্ তথা স স্ৱযং তদীযাঃ সর্ৱ্ৱে পরিৱারাশ্চেশ্ৱরে ৱিশ্ৱসন্তঃ সানন্দিতা অভৱন্| ");
INSERT INTO sanben_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","তস্মৈ তস্য গৃহস্থিতসর্ৱ্ৱলোকেভ্যশ্চ প্রভোঃ কথাং কথিতৱন্তৌ| ");
INSERT INTO sanben_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","তথা রাত্রেস্তস্মিন্নেৱ দণ্ডে স তৌ গৃহীৎৱা তযোঃ প্রহারাণাং ক্ষতানি প্রক্ষালিতৱান্ ততঃ স স্ৱযং তস্য সর্ৱ্ৱে পরিজনাশ্চ মজ্জিতা অভৱন্| ");
INSERT INTO sanben_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","পশ্চাৎ তৌ স্ৱগৃহমানীয তযোঃ সম্মুখে খাদ্যদ্রৱ্যাণি স্থাপিতৱান্ তথা স স্ৱযং তদীযাঃ সর্ৱ্ৱে পরিৱারাশ্চেশ্ৱরে ৱিশ্ৱসন্তঃ সানন্দিতা অভৱন্| ");
INSERT INTO sanben_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","দিন উপস্থিতে তৌ লোকৌ মোচযেতি কথাং কথযিতুং শাসকাঃ পদাতিগণং প্রেষিতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","ততঃ কারারক্ষকঃ পৌলায তাং ৱার্ত্তাং কথিতৱান্ যুৱাং ত্যাজযিতুং শাসকা লোকান প্রেষিতৱন্ত ইদানীং যুৱাং বহি র্ভূৎৱা কুশলেন প্রতিষ্ঠেতাং| ");
INSERT INTO sanben_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","কিন্তু পৌলস্তান্ অৱদৎ রোমিলোকযোরাৱযোঃ কমপি দোষম্ ন নিশ্চিত্য সর্ৱ্ৱেষাং সমক্ষম্ আৱাং কশযা তাডযিৎৱা কারাযাং বদ্ধৱন্ত ইদানীং কিমাৱাং গুপ্তং ৱিস্ত্রক্ষ্যন্তি? তন্ন ভৱিষ্যতি, স্ৱযমাগত্যাৱাং বহিঃ কৃৎৱা নযন্তু| ");
INSERT INTO sanben_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","তদা পদাতিভিঃ শাসকেভ্য এতদ্ৱার্ত্তাযাং কথিতাযাং তৌ রোমিলোকাৱিতি কথাং শ্রুৎৱা তে ভীতাঃ ");
INSERT INTO sanben_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","সন্তস্তযোঃ সন্নিধিমাগত্য ৱিনযম্ অকুর্ৱ্ৱন্ অপরং বহিঃ কৃৎৱা নগরাৎ প্রস্থাতুং প্রার্থিতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ততস্তৌ কারাযা নির্গত্য লুদিযাযা গৃহং গতৱন্তৌ তত্র ভ্রাতৃগণং সাক্ষাৎকৃত্য তান্ সান্ত্ৱযিৎৱা তস্মাৎ স্থানাৎ প্রস্থিতৌ| ");
INSERT INTO sanben_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","পৌলসীলৌ আম্ফিপল্যাপল্লোনিযানগরাভ্যাং গৎৱা যত্র যিহূদীযানাং ভজনভৱনমেকম্ আস্তে তত্র থিষলনীকীনগর উপস্থিতৌ| ");
INSERT INTO sanben_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","তদা পৌলঃ স্ৱাচারানুসারেণ তেষাং সমীপং গৎৱা ৱিশ্রামৱারত্রযে তৈঃ সার্দ্ধং ধর্ম্মপুস্তকীযকথাযা ৱিচারং কৃতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ফলতঃ খ্রীষ্টেন দুঃখভোগঃ কর্ত্তৱ্যঃ শ্মশানদুত্থানঞ্চ কর্ত্তৱ্যং যুষ্মাকং সন্নিধৌ যস্য যীশোঃ প্রস্তাৱং করোমি স ঈশ্ৱরেণাভিষিক্তঃ স এতাঃ কথাঃ প্রকাশ্য প্রমাণং দৎৱা স্থিরীকৃতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","তস্মাৎ তেষাং কতিপযজনা অন্যদেশীযা বহৱো ভক্তলোকা বহ্যঃ প্রধাননার্য্যশ্চ ৱিশ্ৱস্য পৌলসীলযোঃ পশ্চাদ্গামিনো জাতাঃ| ");
INSERT INTO sanben_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","কিন্তু ৱিশ্ৱাসহীনা যিহূদীযলোকা ঈর্ষ্যযা পরিপূর্ণাঃ সন্তো হটট্স্য কতিনযলম্পটলোকান্ সঙ্গিনঃ কৃৎৱা জনতযা নগরমধ্যে মহাকলহং কৃৎৱা যাসোনো গৃহম্ আক্রম্য প্রেরিতান্ ধৃৎৱা লোকনিৱহস্য সমীপম্ আনেতুং চেষ্টিতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","তেষামুদ্দেশম্ অপ্রাপ্য চ যাসোনং কতিপযান্ ভ্রাতৃংশ্চ ধৃৎৱা নগরাধিপতীনাং নিকটমানীয প্রোচ্চৈঃ কথিতৱন্তো যে মনুষ্যা জগদুদ্ৱাটিতৱন্তস্তে ঽত্রাপ্যুপস্থিতাঃ সন্তি, ");
INSERT INTO sanben_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","এষ যাসোন্ আতিথ্যং কৃৎৱা তান্ গৃহীতৱান্| যীশুনামক একো রাজস্তীতি কথযন্তস্তে কৈসরস্যাজ্ঞাৱিরুদ্ধং কর্ম্ম কুর্ৱ্ৱতি| ");
INSERT INTO sanben_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","তেষাং কথামিমাং শ্রুৎৱা লোকনিৱহো নগরাধিপতযশ্চ সমুদ্ৱিগ্না অভৱন্| ");
INSERT INTO sanben_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","তদা যাসোনস্তদন্যেষাঞ্চ ধনদণ্ডং গৃহীৎৱা তান্ পরিত্যক্তৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","ততঃ পরং ভ্রাতৃগণো রজন্যাং পৌলসীলৌ শীঘ্রং বিরযানগরং প্রেষিতৱান্ তৌ তত্রোপস্থায যিহূদীযানাং ভজনভৱনং গতৱন্তৌ| ");
INSERT INTO sanben_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","তত্রস্থা লোকাঃ থিষলনীকীস্থলোকেভ্যো মহাত্মান আসন্ যত ইত্থং ভৱতি ন ৱেতি জ্ঞাতুং দিনে দিনে ধর্ম্মগ্রন্থস্যালোচনাং কৃৎৱা স্ৱৈরং কথাম্ অগৃহ্লন্| ");
INSERT INTO sanben_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","তস্মাদ্ অনেকে যিহূদীযা অন্যদেশীযানাং মান্যা স্ত্রিযঃ পুরুষাশ্চানেকে ৱ্যশ্ৱসন্| ");
INSERT INTO sanben_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","কিন্তু বিরযানগরে পৌলেনেশ্ৱরীযা কথা প্রচার্য্যত ইতি থিষলনীকীস্থা যিহূদীযা জ্ঞাৎৱা তৎস্থানমপ্যাগত্য লোকানাং কুপ্রৱৃত্তিম্ অজনযন্| ");
INSERT INTO sanben_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","অতএৱ তস্মাৎ স্থানাৎ সমুদ্রেণ যান্তীতি দর্শযিৎৱা ভ্রাতরঃ ক্ষিপ্রং পৌলং প্রাহিণ্ৱন্ কিন্তু সীলতীমথিযৌ তত্র স্থিতৱন্তৌ| ");
INSERT INTO sanben_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","ততঃ পরং পৌলস্য মার্গদর্শকাস্তম্ আথীনীনগর উপস্থাপযন্ পশ্চাদ্ যুৱাং তূর্ণম্ এতৎ স্থানং আগমিষ্যথঃ সীলতীমথিযৌ প্রতীমাম্ আজ্ঞাং প্রাপ্য তে প্রত্যাগতাঃ| ");
INSERT INTO sanben_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","পৌল আথীনীনগরে তাৱপেক্ষ্য তিষ্ঠন্ তন্নগরং প্রতিমাভিঃ পরিপূর্ণং দৃষ্ট্ৱা সন্তপ্তহৃদযো ঽভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","ততঃ স ভজনভৱনে যান্ যিহূদীযান্ ভক্তলোকাংশ্চ হট্টে চ যান্ অপশ্যৎ তৈঃ সহ প্রতিদিনং ৱিচারিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","কিন্ত্ৱিপিকূরীযমতগ্রহিণঃ স্তোযিকীযমতগ্রাহিণশ্চ কিযন্তো জনাস্তেন সার্দ্ধং ৱ্যৱদন্ত| তত্র কেচিদ্ অকথযন্ এষ ৱাচালঃ কিং ৱক্তুম্ ইচ্ছতি? অপরে কেচিদ্ এষ জনঃ কেষাঞ্চিদ্ ৱিদেশীযদেৱানাং প্রচারক ইত্যনুমীযতে যতঃ স যীশুম্ উত্থিতিঞ্চ প্রচারযৎ| ");
INSERT INTO sanben_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","তে তম্ অরেযপাগনাম ৱিচারস্থানম্ আনীয প্রাৱোচন্ ইদং যন্নৱীনং মতং ৎৱং প্রাচীকশ ইদং কীদৃশং এতদ্ অস্মান্ শ্রাৱয; ");
INSERT INTO sanben_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","যামিমাম্ অসম্ভৱকথাম্ অস্মাকং কর্ণগোচরীকৃতৱান্ অস্যা ভাৱার্থঃ ক ইতি ৱযং জ্ঞাতুম্ ইচ্ছামঃ| ");
INSERT INTO sanben_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","তদাথীনীনিৱাসিনস্তন্নগরপ্রৱাসিনশ্চ কেৱলং কস্যাশ্চন নৱীনকথাযাঃ শ্রৱণেন প্রচারণেন চ কালম্ অযাপযন্| ");
INSERT INTO sanben_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","পৌলোঽরেযপাগস্য মধ্যে তিষ্ঠন্ এতাং কথাং প্রচারিতৱান্, হে আথীনীযলোকা যূযং সর্ৱ্ৱথা দেৱপূজাযাম্ আসক্তা ইত্যহ প্রত্যক্ষং পশ্যামি| ");
INSERT INTO sanben_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","যতঃ পর্য্যটনকালে যুষ্মাকং পূজনীযানি পশ্যন্ ‘অৱিজ্ঞাতেশ্ৱরায’ এতল্লিপিযুক্তাং যজ্ঞৱেদীমেকাং দৃষ্টৱান্; অতো ন ৱিদিৎৱা যং পূজযধ্ৱে তস্যৈৱ তৎৱং যুষ্মান্ প্রতি প্রচারযামি| ");
INSERT INTO sanben_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","জগতো জগৎস্থানাং সর্ৱ্ৱৱস্তূনাঞ্চ স্রষ্টা য ঈশ্ৱরঃ স স্ৱর্গপৃথিৱ্যোরেকাধিপতিঃ সন্ করনির্ম্মিতমন্দিরেষু ন নিৱসতি; ");
INSERT INTO sanben_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","স এৱ সর্ৱ্ৱেভ্যো জীৱনং প্রাণান্ সর্ৱ্ৱসামগ্রীশ্চ প্রদদাতি; অতএৱ স কস্যাশ্চিৎ সামগ্য্রা অভাৱহেতো র্মনুষ্যাণাং হস্তৈঃ সেৱিতো ভৱতীতি ন| ");
INSERT INTO sanben_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","স ভূমণ্ডলে নিৱাসার্থম্ একস্মাৎ শোণিতাৎ সর্ৱ্ৱান্ মনুষ্যান্ সৃষ্ট্ৱা তেষাং পূর্ৱ্ৱনিরূপিতসমযং ৱসতিসীমাঞ্চ নিরচিনোৎ; ");
INSERT INTO sanben_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","তস্মাৎ লোকৈঃ কেনাপি প্রকারেণ মৃগযিৎৱা পরমেশ্ৱরস্য তৎৱং প্রাপ্তুং তস্য গৱেষণং করণীযম্| ");
INSERT INTO sanben_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","কিন্তু সোঽস্মাকং কস্মাচ্চিদপি দূরে তিষ্ঠতীতি নহি, ৱযং তেন নিশ্ৱসনপ্রশ্ৱসনগমনাগমনপ্রাণধারণানি কুর্ম্মঃ, পুुনশ্চ যুষ্মাকমেৱ কতিপযাঃ কৱযঃ কথযন্তি ‘তস্য ৱংশা ৱযং স্মো হি’ ইতি| ");
INSERT INTO sanben_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","অতএৱ যদি ৱযম্ ঈশ্ৱরস্য ৱংশা ভৱামস্তর্হি মনুষ্যৈ র্ৱিদ্যযা কৌশলেন চ তক্ষিতং স্ৱর্ণং রূপ্যং দৃষদ্ ৱৈতেষামীশ্ৱরৎৱম্ অস্মাভি র্ন জ্ঞাতৱ্যং| ");
INSERT INTO sanben_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","তেষাং পূর্ৱ্ৱীযলোকানাম্ অজ্ঞানতাং প্রতীশ্ৱরো যদ্যপি নাৱাধত্ত তথাপীদানীং সর্ৱ্ৱত্র সর্ৱ্ৱান্ মনঃ পরিৱর্ত্তযিতুম্ আজ্ঞাপযতি, ");
INSERT INTO sanben_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","যতঃ স্ৱনিযুক্তেন পুরুষেণ যদা স পৃথিৱীস্থানাং সর্ৱ্ৱলোকানাং ৱিচারং করিষ্যতি তদ্দিনং ন্যরূপযৎ; তস্য শ্মশানোত্থাপনেন তস্মিন্ সর্ৱ্ৱেভ্যঃ প্রমাণং প্রাদাৎ| ");
INSERT INTO sanben_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","তদা শ্মশানাদ্ উত্থানস্য কথাং শ্রুৎৱা কেচিদ্ উপাহমন্, কেচিদৱদন্ এনাং কথাং পুনরপি ৎৱত্তঃ শ্রোষ্যামঃ| ");
INSERT INTO sanben_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","ততঃ পৌলস্তেষাং সমীপাৎ প্রস্থিाতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","তথাপি কেচিল্লোকাস্তেন সার্দ্ধং মিলিৎৱা ৱ্যশ্ৱসন্ তেষাং মধ্যে ঽরেযপাগীযদিযনুসিযো দামারীনামা কাচিন্নারী কিযন্তো নরাশ্চাসন্| ");
INSERT INTO sanben_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","তদ্ঘটনাতঃ পরং পৌল আথীনীনগরাদ্ যাত্রাং কৃৎৱা করিন্থনগরম্ আগচ্ছৎ| ");
INSERT INTO sanben_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","তস্মিন্ সমযে ক্লৌদিযঃ সর্ৱ্ৱান্ যিহূদীযান্ রোমানগরং ৱিহায গন্তুম্ আজ্ঞাপযৎ, তস্মাৎ প্রিস্কিল্লানাম্না জাযযা সার্দ্ধম্ ইতালিযাদেশাৎ কিঞ্চিৎপূর্ৱ্ৱম্ আগমৎ যঃ পন্তদেশে জাত আক্কিলনামা যিহূদীযলোকঃ পৌলস্তং সাক্ষাৎ প্রাপ্য তযোঃ সমীপমিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","তৌ দূষ্যনির্ম্মাণজীৱিনৌ, তস্মাৎ পরস্পরম্ একৱৃত্তিকৎৱাৎ স তাভ্যাং সহ উষিৎৱা তৎ কর্ম্মাকরোৎ| ");
INSERT INTO sanben_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","পৌলঃ প্রতিৱিশ্রামৱারং ভজনভৱনং গৎৱা ৱিচারং কৃৎৱা যিহূদীযান্ অন্যদেশীযাংশ্চ প্রৱৃত্তিং গ্রাহিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","সীলতীমথিযযো র্মাকিদনিযাদেশাৎ সমেতযোঃ সতোঃ পৌল উত্তপ্তমনা ভূৎৱা যীশুরীশ্ৱরেণাভিষিক্তো ভৱতীতি প্রমাণং যিহূদীযানাং সমীপে প্রাদাৎ| ");
INSERT INTO sanben_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","কিন্তু তে ঽতীৱ ৱিরোধং ৱিধায পাষণ্ডীযকথাং কথিতৱন্তস্ততঃ পৌলো ৱস্ত্রং ধুন্ৱন্ এতাং কথাং কথিতৱান্, যুষ্মাকং শোণিতপাতাপরাধো যুষ্মান্ প্রত্যেৱ ভৱতু, তেনাহং নিরপরাধো ঽদ্যারভ্য ভিন্নদেশীযানাং সমীপং যামি| ");
INSERT INTO sanben_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","স তস্মাৎ প্রস্থায ভজনভৱনসমীপস্থস্য যুস্তনাম্ন ঈশ্ৱরভক্তস্য ভিন্নদেশীযস্য নিৱেশনং প্রাৱিশৎ| ");
INSERT INTO sanben_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","ততঃ ক্রীষ্পনামা ভজনভৱনাধিপতিঃ সপরিৱারঃ প্রভৌ ৱ্যশ্ৱসীৎ, করিন্থনগরীযা বহৱো লোকাশ্চ সমাকর্ণ্য ৱিশ্ৱস্য মজ্জিতা অভৱন্| ");
INSERT INTO sanben_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","ক্ষণদাযাং প্রভুঃ পৌলং দর্শনং দৎৱা ভাষিতৱান্, মা ভৈষীঃ, মা নিরসীঃ কথাং প্রচারয| ");
INSERT INTO sanben_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","অহং ৎৱযা সার্দ্ধম্ আস হিংসার্থং কোপি ৎৱাং স্প্রষ্টুং ন শক্ষ্যতি নগরেঽস্মিন্ মদীযা লোকা বহৱ আসতে| ");
INSERT INTO sanben_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","তস্মাৎ পৌলস্তন্নগরে প্রাযেণ সার্দ্ধৱৎসরপর্য্যন্তং সংস্থাযেশ্ৱরস্য কথাম্ উপাদিশৎ| ");
INSERT INTO sanben_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","গাল্লিযনামা কশ্চিদ্ আখাযাদেশস্য প্রাড্ৱিৱাকঃ সমভৱৎ, ততো যিহূদীযা একৱাক্যাঃ সন্তঃ পৌলম্ আক্রম্য ৱিচারস্থানং নীৎৱা ");
INSERT INTO sanben_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","মানুষ এষ ৱ্যৱস্থায ৱিরুদ্ধম্ ঈশ্ৱরভজনং কর্ত্তুং লোকান্ কুপ্রৱৃত্তিং গ্রাহযতীতি নিৱেদিতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","ততঃ পৌলে প্রত্যুত্তরং দাতুম্ উদ্যতে সতি গাল্লিযা যিহূদীযান্ ৱ্যাহরৎ, যদি কস্যচিদ্ অন্যাযস্য ৱাতিশযদুষ্টতাচরণস্য ৱিচারোঽভৱিষ্যৎ তর্হি যুষ্মাকং কথা মযা সহনীযাভৱিষ্যৎ| ");
INSERT INTO sanben_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","কিন্তু যদি কেৱলং কথাযা ৱা নাম্নো ৱা যুষ্মাকং ৱ্যৱস্থাযা ৱিৱাদো ভৱতি তর্হি তস্য ৱিচারমহং ন করিষ্যামি, যূযং তস্য মীমাংসাং কুরুত| ");
INSERT INTO sanben_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","ততঃ স তান্ ৱিচারস্থানাদ্ দূরীকৃতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","তদা ভিন্নদেশীযাঃ সোস্থিনিনামানং ভজনভৱনস্য প্রধানাধিপতিং ধৃৎৱা ৱিচারস্থানস্য সম্মুখে প্রাহরন্ তথাপি গাল্লিযা তেষু সর্ৱ্ৱকর্ম্মসু ন মনো ন্যদধাৎ| ");
INSERT INTO sanben_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","পৌলস্তত্র পুনর্বহুদিনানি ন্যৱসৎ, ততো ভ্রাতৃগণাদ্ ৱিসর্জনং প্রাপ্য কিঞ্চনৱ্রতনিমিত্তং কিংক্রিযানগরে শিরো মুণ্ডযিৎৱা প্রিস্কিল্লাক্কিলাভ্যাং সহিতো জলপথেন সুরিযাদেশং গতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","তত ইফিষনগর উপস্থায তত্র তৌ ৱিসৃজ্য স্ৱযং ভজনভ্ৱনং প্রৱিশ্য যিহূদীযৈঃ সহ ৱিচারিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","তে স্ৱৈঃ সার্দ্ধং পুনঃ কতিপযদিনানি স্থাতুং তং ৱ্যনযন্, স তদনুররীকৃত্য কথামেতাং কথিতৱান্, ");
INSERT INTO sanben_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","যিরূশালমি আগাম্যুৎসৱপালনার্থং মযা গমনীযং; পশ্চাদ্ ঈশ্ৱরেচ্ছাযাং জাতাযাং যুষ্মাকং সমীপং প্রত্যাগমিষ্যামি| ততঃ পরং স তৈ র্ৱিসৃষ্টঃ সন্ জলপথেন ইফিষনগরাৎ প্রস্থিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","ততঃ কৈসরিযাম্ উপস্থিতঃ সন্ নগরং গৎৱা সমাজং নমস্কৃত্য তস্মাদ্ আন্তিযখিযানগরং প্রস্থিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","তত্র কিযৎকালং যাপযিৎৱা তস্মাৎ প্রস্থায সর্ৱ্ৱেষাং শিষ্যাণাং মনাংসি সুস্থিরাণি কৃৎৱা ক্রমশো গলাতিযাফ্রুগিযাদেশযো র্ভ্রমিৎৱা গতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","তস্মিন্নেৱ সমযে সিকন্দরিযানগরে জাত আপল্লোনামা শাস্ত্রৱিৎ সুৱক্তা যিহূদীয একো জন ইফিষনগরম্ আগতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","স শিক্ষিতপ্রভুমার্গো মনসোদ্যোগী চ সন্ যোহনো মজ্জনমাত্রং জ্ঞাৎৱা যথার্থতযা প্রভোঃ কথাং কথযন্ সমুপাদিশৎ| ");
INSERT INTO sanben_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","এষ জনো নির্ভযৎৱেন ভজনভৱনে কথযিতুম্ আরব্ধৱান্, ততঃ প্রিস্কিল্লাক্কিলৌ তস্যোপদেশকথাং নিশম্য তং স্ৱযোঃ সমীপম্ আনীয শুদ্ধরূপেণেশ্ৱরস্য কথাম্ অবোধযতাম্| ");
INSERT INTO sanben_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","পশ্চাৎ স আখাযাদেশং গন্তুং মতিং কৃতৱান্, তদা তত্রত্যঃ শিষ্যগণো যথা তং গৃহ্লাতি তদর্থং ভ্রাতৃগণেন সমাশ্ৱস্য পত্রে লিখিতে সতি, আপল্লাস্তত্রোপস্থিতঃ সন্ অনুগ্রহেণ প্রত্যযিনাং বহূপকারান্ অকরোৎ, ");
INSERT INTO sanben_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ফলতো যীশুরভিষিক্তস্ত্রাতেতি শাস্ত্রপ্রমাণং দৎৱা প্রকাশরূপেণ প্রতিপন্নং কৃৎৱা যিহূদীযান্ নিরুত্তরান্ কৃতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","করিন্থনগর আপল্লসঃ স্থিতিকালে পৌল উত্তরপ্রদেশৈরাগচ্ছন্ ইফিষনগরম্ উপস্থিতৱান্| তত্র কতিপযশিষ্যান্ সাক্ষৎ প্রাপ্য তান্ অপৃচ্ছৎ, ");
INSERT INTO sanben_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","যূযং ৱিশ্ৱস্য পৱিত্রমাত্মানং প্রাপ্তা ন ৱা? ততস্তে প্রত্যৱদন্ পৱিত্র আত্মা দীযতে ইত্যস্মাভিঃ শ্রুতমপি নহি| ");
INSERT INTO sanben_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","তদা সাঽৱদৎ তর্হি যূযং কেন মজ্জিতা অভৱত? তেঽকথযন্ যোহনো মজ্জনেন| ");
INSERT INTO sanben_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","তদা পৌল উক্তৱান্ ইতঃ পরং য উপস্থাস্যতি তস্মিন্ অর্থত যীশুখ্রীষ্টে ৱিশ্ৱসিতৱ্যমিত্যুক্ত্ৱা যোহন্ মনঃপরিৱর্ত্তনসূচকেন মজ্জনেন জলে লোকান্ অমজ্জযৎ| ");
INSERT INTO sanben_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","তাদৃশীং কথাং শ্রুৎৱা তে প্রভো র্যীশুখ্রীষ্টস্য নাম্না মজ্জিতা অভৱন্| ");
INSERT INTO sanben_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ততঃ পৌলেন তেষাং গাত্রেষু করেঽর্পিতে তেষামুপরি পৱিত্র আত্মাৱরূঢৱান্, তস্মাৎ তে নানাদেশীযা ভাষা ভৱিষ্যৎকথাশ্চ কথিতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","তে প্রাযেণ দ্ৱাদশজনা আসন্| ");
INSERT INTO sanben_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","পৌলো ভজনভৱনং গৎৱা প্রাযেণ মাসত্রযম্ ঈশ্ৱরস্য রাজ্যস্য ৱিচারং কৃৎৱা লোকান্ প্রৱর্ত্য সাহসেন কথামকথযৎ| ");
INSERT INTO sanben_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","কিন্তু কঠিনান্তঃকরণৎৱাৎ কিযন্তো জনা ন ৱিশ্ৱস্য সর্ৱ্ৱেষাং সমক্ষম্ এতৎপথস্য নিন্দাং কর্ত্তুং প্রৱৃত্তাঃ, অতঃ পৌলস্তেষাং সমীপাৎ প্রস্থায শিষ্যগণং পৃথক্কৃৎৱা প্রত্যহং তুরান্ননাম্নঃ কস্যচিৎ জনস্য পাঠশালাযাং ৱিচারং কৃতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ইত্থং ৱৎসরদ্ৱযং গতং তস্মাদ্ আশিযাদেশনিৱাসিনঃ সর্ৱ্ৱে যিহূদীযা অন্যদেশীযলোকাশ্চ প্রভো র্যীশোঃ কথাম্ অশ্রৌষন্| ");
INSERT INTO sanben_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","পৌলেন চ ঈশ্ৱর এতাদৃশান্যদ্ভুতানি কর্ম্মাণি কৃতৱান্ ");
INSERT INTO sanben_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","যৎ পরিধেযে গাত্রমার্জনৱস্ত্রে ৱা তস্য দেহাৎ পীডিতলোকানাম্ সমীপম্ আনীতে তে নিরামযা জাতা অপৱিত্রা ভূতাশ্চ তেভ্যো বহির্গতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","তদা দেশাটনকারিণঃ কিযন্তো যিহূদীযা ভূতাপসারিণো ভূতগ্রস্তনোকানাং সন্নিধৌ প্রভে র্যীশো র্নাম জপ্ত্ৱা ৱাক্যমিদম্ অৱদন্, যস্য কথাং পৌলঃ প্রচারযতি তস্য যীশো র্নাম্না যুষ্মান্ আজ্ঞাপযামঃ| ");
INSERT INTO sanben_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","স্কিৱনাম্নো যিহূদীযানাং প্রধানযাজকস্য সপ্তভিঃ পুত্তৈস্তথা কৃতে সতি ");
INSERT INTO sanben_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","কশ্চিদ্ অপৱিত্রো ভূতঃ প্রত্যুদিতৱান্, যীশুং জানামি পৌলঞ্চ পরিচিনোমি কিন্তু কে যূযং? ");
INSERT INTO sanben_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ইত্যুক্ত্ৱা সোপৱিত্রভূতগ্রস্তো মনুষ্যো লম্ফং কৃৎৱা তেষামুপরি পতিৎৱা বলেন তান্ জিতৱান্, তস্মাত্তে নগ্নাঃ ক্ষতাঙ্গাশ্চ সন্তস্তস্মাদ্ গেহাৎ পলাযন্ত| ");
INSERT INTO sanben_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","সা ৱাগ্ ইফিষনগরনিৱাসিনসং সর্ৱ্ৱেষাং যিহূদীযানাং ভিন্নদেশীযানাং লোকানাঞ্চ শ্রৱোগোচরীভূতা; ততঃ সর্ৱ্ৱে ভযং গতাঃ প্রভো র্যীশো র্নাম্নো যশো ঽৱর্দ্ধত| ");
INSERT INTO sanben_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","যেষামনেকেষাং লোকানাং প্রতীতিরজাযত ত আগত্য স্ৱৈঃ কৃতাঃ ক্রিযাঃ প্রকাশরূপেণাঙ্গীকৃতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","বহৱো মাযাকর্ম্মকারিণঃ স্ৱস্ৱগ্রন্থান্ আনীয রাশীকৃত্য সর্ৱ্ৱেষাং সমক্ষম্ অদাহযন্, ততো গণনাং কৃৎৱাবুধ্যন্ত পঞ্চাযুতরূপ্যমুদ্রামূল্যপুস্তকানি দগ্ধানি| ");
INSERT INTO sanben_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ইত্থং প্রভোঃ কথা সর্ৱ্ৱদেশং ৱ্যাপ্য প্রবলা জাতা| ");
INSERT INTO sanben_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","সর্ৱ্ৱেষ্ৱেতেষু কর্ম্মসু সম্পন্নেষু সৎসু পৌলো মাকিদনিযাখাযাদেশাভ্যাং যিরূশালমং গন্তুং মতিং কৃৎৱা কথিতৱান্ তৎস্থানং যাত্রাযাং কৃতাযাং সত্যাং মযা রোমানগরং দ্রষ্টৱ্যং| ");
INSERT INTO sanben_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","স্ৱানুগতলোকানাং তীমথিযেরাস্তৌ দ্ৱৌ জনৌ মাকিদনিযাদেশং প্রতি প্রহিত্য স্ৱযম্ আশিযাদেশে কতিপযদিনানি স্থিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","কিন্তু তস্মিন্ সমযে মতেঽস্মিন্ কলহো জাতঃ| ");
INSERT INTO sanben_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","তৎকারণমিদং, অর্ত্তিমীদেৱ্যা রূপ্যমন্দিরনির্ম্মাণেন সর্ৱ্ৱেষাং শিল্পিনাং যথেষ্টলাভম্ অজনযৎ যো দীমীত্রিযনামা নাডীন্ধমঃ ");
INSERT INTO sanben_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","স তান্ তৎকর্ম্মজীৱিনঃ সর্ৱ্ৱলোকাংশ্চ সমাহূয ভাষিতৱান্ হে মহেচ্ছা এতেন মন্দিরনির্ম্মাণেনাস্মাকং জীৱিকা ভৱতি, এতদ্ যূযং ৱিত্থ; ");
INSERT INTO sanben_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","কিন্তু হস্তনির্ম্মিতেশ্ৱরা ঈশ্ৱরা নহি পৌলনাম্না কেনচিজ্জনেন কথামিমাং ৱ্যাহৃত্য কেৱলেফিষনগরে নহি প্রাযেণ সর্ৱ্ৱস্মিন্ আশিযাদেশে প্রৱৃত্তিং গ্রাহযিৎৱা বহুলোকানাং শেমুষী পরাৱর্ত্তিতা, এতদ্ যুষ্মাভি র্দৃশ্যতে শ্রূযতে চ| ");
INSERT INTO sanben_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","তেনাস্মাকং ৱাণিজ্যস্য সর্ৱ্ৱথা হানেঃ সম্ভৱনং কেৱলমিতি নহি, আশিযাদেশস্থৈ র্ৱা সর্ৱ্ৱজগৎস্থৈ র্লোকৈঃ পূজ্যা যার্তিমী মহাদেৱী তস্যা মন্দিরস্যাৱজ্ঞানস্য তস্যা ঐশ্ৱর্য্যস্য নাশস্য চ সম্ভাৱনা ৱিদ্যতেे| ");
INSERT INTO sanben_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","এতাদৃশীং কথাং শ্রুৎৱা তে মহাক্রোধান্ৱিতাঃ সন্ত উচ্চৈঃকারং কথিতৱন্ত ইফিষীযানাম্ অর্ত্তিমী দেৱী মহতী ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","ততঃ সর্ৱ্ৱনগরং কলহেন পরিপূর্ণমভৱৎ, ততঃ পরং তে মাকিদনীযগাযারিস্তার্খনামানৌ পৌলস্য দ্ৱৌ সহচরৌ ধৃৎৱৈকচিত্তা রঙ্গভূমিং জৱেন ধাৱিতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","ততঃ পৌলো লোকানাং সন্নিধিং যাতুম্ উদ্যতৱান্ কিন্তু শিষ্যগণস্তং ৱারিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","পৌলস্যত্মীযা আশিযাদেশস্থাঃ কতিপযাঃ প্রধানলোকাস্তস্য সমীপং নরমেকং প্রেষ্য ৎৱং রঙ্গভূমিং মাগা ইতি ন্যৱেদযন্| ");
INSERT INTO sanben_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","ততো নানালোকানাং নানাকথাকথনাৎ সভা ৱ্যাকুলা জাতা কিং কারণাদ্ এতাৱতী জনতাভৱৎ এতদ্ অধিকৈ র্লোকৈ র্নাজ্ঞাযি| ");
INSERT INTO sanben_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","ততঃ পরং জনতামধ্যাদ্ যিহূদীযৈর্বহিষ্কৃতঃ সিকন্দরো হস্তেন সঙ্কেতং কৃৎৱা লোকেভ্য উত্তরং দাতুমুদ্যতৱান্, ");
INSERT INTO sanben_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","কিন্তু স যিহূদীযলোক ইতি নিশ্চিতে সতি ইফিষীযানাম্ অর্ত্তিমী দেৱী মহতীতি ৱাক্যং প্রাযেণ পঞ্চ দণ্ডান্ যাৱদ্ একস্ৱরেণ লোকনিৱহৈঃ প্রোক্তং| ");
INSERT INTO sanben_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","ততো নগরাধিপতিস্তান্ স্থিরান্ কৃৎৱা কথিতৱান্ হে ইফিষাযাঃ সর্ৱ্ৱে লোকা আকর্ণযত, অর্তিমীমহাদেৱ্যা মহাদেৱাৎ পতিতাযাস্তৎপ্রতিমাযাশ্চ পূজনম ইফিষনগরস্থাঃ সর্ৱ্ৱে লোকাঃ কুর্ৱ্ৱন্তি, এতৎ কে ন জানন্তি? ");
INSERT INTO sanben_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","তস্মাদ্ এতৎপ্রতিকূলং কেপি কথযিতুং ন শক্নুৱন্তি, ইতি জ্ঞাৎৱা যুষ্মাভিঃ সুস্থিরৎৱেন স্থাতৱ্যম্ অৱিৱিচ্য কিমপি কর্ম্ম ন কর্ত্তৱ্যঞ্চ| ");
INSERT INTO sanben_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","যান্ এতান্ মনুষ্যান্ যূযমত্র সমানযত তে মন্দিরদ্রৱ্যাপহারকা যুষ্মাকং দেৱ্যা নিন্দকাশ্চ ন ভৱন্তি| ");
INSERT INTO sanben_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","যদি কঞ্চন প্রতি দীমীত্রিযস্য তস্য সহাযানাঞ্চ কাচিদ্ আপত্তি র্ৱিদ্যতে তর্হি প্রতিনিধিলোকা ৱিচারস্থানঞ্চ সন্তি, তে তৎ স্থানং গৎৱা উত্তরপ্রত্যুত্তরে কুর্ৱ্ৱন্তু| ");
INSERT INTO sanben_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","কিন্তু যুষ্মাকং কাচিদপরা কথা যদি তিষ্ঠতি তর্হি নিযমিতাযাং সভাযাং তস্যা নিষ্পত্তি র্ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","কিন্ত্ৱেতস্য ৱিরোধস্যোত্তরং যেন দাতুং শক্নুম্ এতাদৃশস্য কস্যচিৎ কারণস্যাভাৱাদ্ অদ্যতনঘটনাহেতো রাজদ্রোহিণামিৱাস্মাকম্ অভিযোগো ভৱিষ্যতীতি শঙ্কা ৱিদ্যতে| ");
INSERT INTO sanben_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","ইতি কথযিৎৱা স সভাস্থলোকান্ ৱিসৃষ্টৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ইত্থং কলহে নিৱৃত্তে সতি পৌলঃ শিষ্যগণম্ আহূয ৱিসর্জনং প্রাপ্য মাকিদনিযাদেশং প্রস্থিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","তেন স্থানেন গচ্ছন্ তদ্দেশীযান্ শিষ্যান্ বহূপদিশ্য যূনানীযদেশম্ উপস্থিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","তত্র মাসত্রযং স্থিৎৱা তস্মাৎ সুরিযাদেশং যাতুম্ উদ্যতঃ, কিন্তু যিহূদীযাস্তং হন্তুং গুপ্তা অতিষ্ঠন্ তস্মাৎ স পুনরপি মাকিদনিযামার্গেণ প্রত্যাগন্তুং মতিং কৃতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","বিরযানগরীযসোপাত্রঃ থিষলনীকীযারিস্তার্খসিকুন্দৌ দর্ব্বোনগরীযগাযতীমথিযৌ আশিযাদেশীযতুখিকত্রফিমৌ চ তেন সার্দ্ধং আশিযাদেশং যাৱদ্ গতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","এতে সর্ৱ্ৱে ঽগ্রসরাঃ সন্তো ঽস্মান্ অপেক্ষ্য ত্রোযানগরে স্থিতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","কিণ্ৱশূন্যপূপোৎসৱদিনে চ গতে সতি ৱযং ফিলিপীনগরাৎ তোযপথেন গৎৱা পঞ্চভি র্দিনৈস্ত্রোযানগরম্ উপস্থায তত্র সপ্তদিনান্যৱাতিষ্ঠাম| ");
INSERT INTO sanben_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","সপ্তাহস্য প্রথমদিনে পূপান্ ভংক্তু শিষ্যেষু মিলিতেষু পৌলঃ পরদিনে তস্মাৎ প্রস্থাতুম্ উদ্যতঃ সন্ তদহ্নি প্রাযেণ ক্ষপাযা যামদ্ৱযং যাৱৎ শিষ্যেভ্যো ধর্ম্মকথাম্ অকথযৎ| ");
INSERT INTO sanben_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","উপরিস্থে যস্মিন্ প্রকোষ্ঠে সভাং কৃৎৱাসন্ তত্র বহৱঃ প্রদীপাঃ প্রাজ্ৱলন্| ");
INSERT INTO sanben_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","উতুখনামা কশ্চন যুৱা চ ৱাতাযন উপৱিশন্ ঘোরতরনিদ্রাগ্রস্তো ঽভূৎ তদা পৌলেন বহুক্ষণং কথাযাং প্রচারিতাযাং নিদ্রামগ্নঃ স তস্মাদ্ উপরিস্থতৃতীযপ্রকোষ্ঠাদ্ অপতৎ, ততো লোকাস্তং মৃতকল্পং ধৃৎৱোদতোলযন্| ");
INSERT INTO sanben_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","ততঃ পৌলোঽৱরুহ্য তস্য গাত্রে পতিৎৱা তং ক্রোডে নিধায কথিতৱান্, যূযং ৱ্যাকুলা মা ভূত নাযং প্রাণৈ র্ৱিযুক্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","পশ্চাৎ স পুনশ্চোপরি গৎৱা পূপান্ ভংক্ত্ৱা প্রভাতং যাৱৎ কথোপকথনে কৃৎৱা প্রস্থিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","তে চ তং জীৱন্তং যুৱানং গৃহীৎৱা গৎৱা পরমাপ্যাযিতা জাতাঃ| ");
INSERT INTO sanben_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","অনন্তরং ৱযং পোতেনাগ্রসরা ভূৎৱাস্মনগরম্ উত্তীর্য্য পৌলং গ্রহীতুং মতিম্ অকুর্ম্ম যতঃ স তত্র পদ্ভ্যাং ৱ্রজিতুং মতিং কৃৎৱেতি নিরূপিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","তস্মাৎ তত্রাস্মাভিঃ সার্দ্ধং তস্মিন্ মিলিতে সতি ৱযং তং নীৎৱা মিতুলীন্যুপদ্ৱীপং প্রাপ্তৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","তস্মাৎ পোতং মোচযিৎৱা পরেঽহনি খীযোপদ্ৱীপস্য সম্মুখং লব্ধৱন্তস্তস্মাদ্ একেনাহ্না সামোপদ্ৱীপং গৎৱা পোতং লাগযিৎৱা ত্রোগুল্লিযে স্থিৎৱা পরস্মিন্ দিৱসেे মিলীতনগরম্ উপাতিষ্ঠাম| ");
INSERT INTO sanben_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","যতঃ পৌল আশিযাদেশে কালং যাপযিতুম্ নাভিলষন্ ইফিষনগরং ত্যক্ত্ৱা যাতুং মন্ত্রণাং স্থিরীকৃতৱান্; যস্মাদ্ যদি সাধ্যং ভৱতি তর্হি নিস্তারোৎসৱস্য পঞ্চাশত্তমদিনে স যিরূশালম্যুপস্থাতুং মতিং কৃতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","পৌলো মিলীতাদ্ ইফিষং প্রতি লোকং প্রহিত্য সমাজস্য প্রাচীনান্ আহূযানীতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","তেষু তস্য সমীপম্ উপস্থিতেষু স তেভ্য ইমাং কথাং কথিতৱান্, অহম্ আশিযাদেশে প্রথমাগমনম্ আরভ্যাদ্য যাৱদ্ যুষ্মাকং সন্নিধৌ স্থিৎৱা সর্ৱ্ৱসমযে যথাচরিতৱান্ তদ্ যূযং জানীথ; ");
INSERT INTO sanben_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ফলতঃ সর্ৱ্ৱথা নম্রমনাঃ সন্ বহুশ্রুপাতেন যিহুদীযানাম্ কুমন্ত্রণাজাতনানাপরীক্ষাভিঃ প্রভোঃ সেৱামকরৱং| ");
INSERT INTO sanben_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","কামপি হিতকথাाং ন গোপাযিতৱান্ তাং প্রচার্য্য সপ্রকাশং গৃহে গৃহে সমুপদিশ্যেশ্ৱরং প্রতি মনঃ পরাৱর্ত্তনীযং প্রভৌ যীশুখ্রীষ্টে ৱিশ্ৱসনীযং ");
INSERT INTO sanben_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","যিহূদীযানাম্ অন্যদেশীযলোকানাঞ্চ সমীপ এতাদৃশং সাক্ষ্যং দদামি| ");
INSERT INTO sanben_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","পশ্যত সাম্প্রতম্ আত্মনাকৃষ্টঃ সন্ যিরূশালম্নগরে যাত্রাং করোমি, তত্র মাম্প্রতি যদ্যদ্ ঘটিষ্যতে তান্যহং ন জানামি; ");
INSERT INTO sanben_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","কিন্তু মযা বন্ধনং ক্লেশশ্চ ভোক্তৱ্য ইতি পৱিত্র আত্মা নগরে নগরে প্রমাণং দদাতি| ");
INSERT INTO sanben_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","তথাপি তং ক্লেশমহং তৃণায ন মন্যে; ঈশ্ৱরস্যানুগ্রহৱিষযকস্য সুসংৱাদস্য প্রমাণং দাতুং, প্রভো র্যীশোঃ সকাশাদ যস্যাঃ সেৱাযাঃ ভারং প্রাপ্নৱং তাং সেৱাং সাধযিতুং সানন্দং স্ৱমার্গং সমাপযিতুुঞ্চ নিজপ্রাণানপি প্রিযান্ ন মন্যে| ");
INSERT INTO sanben_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","অধুনা পশ্যত যেষাং সমীপেঽহম্ ঈশ্ৱরীযরাজ্যস্য সুসংৱাদং প্রচার্য্য ভ্রমণং কৃতৱান্ এতাদৃশা যূযং মম ৱদনং পুন র্দ্রষ্টুং ন প্রাপ্স্যথ এতদপ্যহং জানামি| ");
INSERT INTO sanben_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","যুষ্মভ্যম্ অহম্ ঈশ্ৱরস্য সর্ৱ্ৱান্ আদেশান্ প্রকাশযিতুং ন ন্যৱর্ত্তে| ");
INSERT INTO sanben_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","অহং সর্ৱ্ৱেষাং লোকানাং রক্তপাতদোষাদ্ যন্নির্দোষ আসে তস্যাদ্য যুষ্মান্ সাক্ষিণঃ করোমি| ");
INSERT INTO sanben_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","যূযং স্ৱেষু তথা যস্য ৱ্রজস্যাধ্যক্ষন্ আত্মা যুষ্মান্ ৱিধায ন্যযুঙ্ক্ত তৎসর্ৱ্ৱস্মিন্ সাৱধানা ভৱত, য সমাজঞ্চ প্রভু র্নিজরক্তমূল্যেন ক্রীতৱান তম্ অৱত, ");
INSERT INTO sanben_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","যতো মযা গমনে কৃতএৱ দুর্জযা ৱৃকা যুষ্মাকং মধ্যং প্রৱিশ্য ৱ্রজং প্রতি নির্দযতাম্ আচরিষ্যন্তি, ");
INSERT INTO sanben_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","যুষ্মাকমেৱ মধ্যাদপি লোকা উত্থায শিষ্যগণম্ অপহন্তুং ৱিপরীতম্ উপদেক্ষ্যন্তীত্যহং জানামি| ");
INSERT INTO sanben_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","ইতি হেতো র্যূযং সচৈতন্যাঃ সন্তস্তিষ্টত, অহঞ্চ সাশ্রুপাতঃ সন্ ৱৎসরত্রযং যাৱদ্ দিৱানিশং প্রতিজনং বোধযিতুং ন ন্যৱর্ত্তে তদপি স্মরত| ");
INSERT INTO sanben_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","ইদানীং হে ভ্রাতরো যুষ্মাকং নিষ্ঠাং জনযিতুং পৱিত্রীকৃতলোকানাং মধ্যেঽধিকারঞ্চ দাতুং সমর্থো য ঈশ্ৱরস্তস্যানুগ্রহস্য যো ৱাদশ্চ তযোরুভযো র্যুষ্মান্ সমার্পযম্| ");
INSERT INTO sanben_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","কস্যাপি স্ৱর্ণং রূপ্যং ৱস্ত্রং ৱা প্রতি মযা লোভো ন কৃতঃ| ");
INSERT INTO sanben_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","কিন্তু মম মৎসহচরলোকানাঞ্চাৱশ্যকৱ্যযায মদীযমিদং করদ্ৱযম্ অশ্রাম্যদ্ এতদ্ যূযং জানীথ| ");
INSERT INTO sanben_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","অনেন প্রকারেণ গ্রহণদ্ দানং ভদ্রমিতি যদ্ৱাক্যং প্রভু র্যীশুঃ কথিতৱান্ তৎ স্মর্ত্তুং দরিদ্রলোকানামুপকারার্থং শ্রমং কর্ত্তুঞ্চ যুষ্মাকম্ উচিতম্ এতৎসর্ৱ্ৱং যুষ্মানহম্ উপদিষ্টৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","এতাং কথাং কথযিৎৱা স জানুনী পাতযিৎৱা সর্ৱৈঃ সহ প্রার্থযত| ");
INSERT INTO sanben_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","তেন তে ক্রন্দ্রন্তঃ ");
INSERT INTO sanben_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","পুন র্মম মুখং ন দ্রক্ষ্যথ ৱিশেষত এষা যা কথা তেনাকথি তৎকারণাৎ শোকং ৱিলাপঞ্চ কৃৎৱা কণ্ঠং ধৃৎৱা চুম্বিতৱন্তঃ| পশ্চাৎ তে তং পোতং নীতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","তৈ র্ৱিসৃষ্টাঃ সন্তো ৱযং পোতং বাহযিৎৱা ঋজুমার্গেণ কোষম্ উপদ্ৱীপম্ আগত্য পরেঽহনি রোদিযোপদ্ৱীপম্ আগচ্ছাম ততস্তস্মাৎ পাতারাযাম্ উপাতিষ্ঠাম| ");
INSERT INTO sanben_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","তত্র ফৈনীকিযাদেশগামিনম্ পোতমেকং প্রাপ্য তমারুহ্য গতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","কুপ্রোপদ্ৱীপং দৃষ্ট্ৱা তং সৱ্যদিশি স্থাপযিৎৱা সুরিযাদেশং গৎৱা পোতস্থদ্রৱ্যাণ্যৱরোহযিতুং সোরনগরে লাগিতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","তত্র শিষ্যগণস্য সাক্ষাৎকরণায ৱযং তত্র সপ্তদিনানি স্থিতৱন্তঃ পশ্চাত্তে পৱিত্রেণাত্মনা পৌলং ৱ্যাহরন্ ৎৱং যিরূশালম্নগরং মা গমঃ| ");
INSERT INTO sanben_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","ততস্তেষু সপ্তসু দিনেষু যাপিতেষু সৎসু ৱযং তস্মাৎ স্থানাৎ নিজৱর্ত্মনা গতৱন্তঃ, তস্মাৎ তে সবালৱৃদ্ধৱনিতা অস্মাভিঃ সহ নগরস্য পরিসরপর্য্যন্তম্ আগতাঃ পশ্চাদ্ৱযং জলধিতটে জানুপাতং প্রার্থযামহি| ");
INSERT INTO sanben_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ততঃ পরস্পরং ৱিসৃষ্টাঃ সন্তো ৱযং পোতং গতাস্তে তু স্ৱস্ৱগৃহং প্রত্যাগতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","ৱযং সোরনগরাৎ নাৱা প্রস্থায তলিমাযিনগরম্ উপাতিষ্ঠাম তত্রাস্মাকং সমুদ্রীযমার্গস্যান্তোঽভৱৎ তত্র ভ্রাতৃগণং নমস্কৃত্য দিনমেকং তৈঃ সার্দ্ধম্ উষতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","পরে ঽহনি পৌলস্তস্য সঙ্গিনো ৱযঞ্চ প্রতিষ্ঠমানাঃ কৈসরিযানগরম্ আগত্য সুসংৱাদপ্রচারকানাং সপ্তজনানাং ফিলিপনাম্ন একস্য গৃহং প্রৱিশ্যাৱতিষ্ঠাম| ");
INSERT INTO sanben_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","তস্য চতস্রো দুহিতরোঽনূঢা ভৱিষ্যদ্ৱাদিন্য আসন্| ");
INSERT INTO sanben_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","তত্রাস্মাসু বহুদিনানি প্রোষিতেষু যিহূদীযদেশাদ্ আগত্যাগাবনামা ভৱিষ্যদ্ৱাদী সমুপস্থিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","সোস্মাকং সমীপমেত্য পৌলস্য কটিবন্ধনং গৃহীৎৱা নিজহস্তাপাদান্ বদ্ধ্ৱা ভাষিতৱান্ যস্যেদং কটিবন্ধনং তং যিহূদীযলোকা যিরূশালমনগর ইত্থং বদ্ধ্ৱা ভিন্নদেশীযানাং করেষু সমর্পযিষ্যন্তীতি ৱাক্যং পৱিত্র আত্মা কথযতি| ");
INSERT INTO sanben_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","এতাদৃশীং কথাং শ্রুৎৱা ৱযং তন্নগরৱাসিনো ভ্রাতরশ্চ যিরূশালমং ন যাতুং পৌলং ৱ্যনযামহি; ");
INSERT INTO sanben_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","কিন্তু স প্রত্যাৱাদীৎ, যূযং কিং কুরুথ? কিং ক্রন্দনেন মমান্তঃকরণং ৱিদীর্ণং করিষ্যথ? প্রভো র্যীশো র্নাম্নো নিমিত্তং যিরূশালমি বদ্ধো ভৱিতুং কেৱল তন্ন প্রাণান্ দাতুমপি সসজ্জোস্মি| ");
INSERT INTO sanben_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","তেনাস্মাকং কথাযাম্ অগৃহীতাযাম্ ঈশ্ৱরস্য যথেচ্ছা তথৈৱ ভৱৎৱিত্যুক্ত্ৱা ৱযং নিরস্যাম| ");
INSERT INTO sanben_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","পরেঽহনি পাথেযদ্রৱ্যাণি গৃহীৎৱা যিরূশালমং প্রতি যাত্রাম্ অকুর্ম্ম| ");
INSERT INTO sanben_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","ততঃ কৈসরিযানগরনিৱাসিনঃ কতিপযাঃ শিষ্যা অস্মাভিঃ সার্দ্ধম্ ইৎৱা কৃপ্রীযেন ম্নাসন্নাম্না যেন প্রাচীনশিষ্যেন সার্দ্ধম্ অস্মাভি র্ৱস্তৱ্যং তস্য সমীপম্ অস্মান্ নীতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","অস্মাসু যিরূশালম্যুপস্থিতেষু তত্রস্থভ্রাতৃগণোঽস্মান্ আহ্লাদেন গৃহীতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","পরস্মিন্ দিৱসে পৌলেঽস্মাভিঃ সহ যাকূবো গৃহং প্রৱিষ্টে লোকপ্রাচীনাঃ সর্ৱ্ৱে তত্র পরিষদি সংস্থিতাঃ| ");
INSERT INTO sanben_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","অনন্তরং স তান্ নৎৱা স্ৱীযপ্রচারণেন ভিন্নদেশীযান্ প্রতীশ্ৱরো যানি কর্ম্মাণি সাধিতৱান্ তদীযাং কথাম্ অনুক্রমাৎ কথিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ইতি শ্রুৎৱা তে প্রভুং ধন্যং প্রোচ্য ৱাক্যমিদম্ অভাষন্ত, হে ভ্রাত র্যিহূদীযানাং মধ্যে বহুসহস্রাণি লোকা ৱিশ্ৱাসিন আসতে কিন্তু তে সর্ৱ্ৱে ৱ্যৱস্থামতাচারিণ এতৎ প্রত্যক্ষং পশ্যসি| ");
INSERT INTO sanben_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","শিশূনাং ৎৱক্ছেদনাদ্যাচরণং প্রতিষিধ্য ৎৱং ভিন্নদেশনিৱাসিনো যিহূদীযলোকান্ মূসাৱাক্যম্ অশ্রদ্ধাতুম্ উপদিশসীতি তৈঃ শ্রুতমস্তি| ");
INSERT INTO sanben_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","ৎৱমত্রাগতোসীতি ৱার্ত্তাং সমাকর্ণ্য জননিৱহো মিলিৎৱাৱশ্যমেৱাগমিষ্যতি; অতএৱ কিং করণীযম্? অত্র ৱযং মন্ত্রযিৎৱা সমুপাযং ৎৱাং ৱদামস্তং ৎৱমাচর| ");
INSERT INTO sanben_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","ৱ্রতং কর্ত্তুং কৃতসঙ্কল্পা যেঽস্মাংক চৎৱারো মানৱাঃ সন্তি ");
INSERT INTO sanben_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","তান্ গৃহীৎৱা তৈঃ সহিতঃ স্ৱং শুচিং কুরু তথা তেষাং শিরোমুণ্ডনে যো ৱ্যযো ভৱতি তং ৎৱং দেহি| তথা কৃতে ৎৱদীযাচারে যা জনশ্রুতি র্জাযতে সালীকা কিন্তু ৎৱং ৱিধিং পালযন্ ৱ্যৱস্থানুসারেণেৱাচরসীতি তে ভোৎসন্তে| ");
INSERT INTO sanben_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","ভিন্নদেশীযানাং ৱিশ্ৱাসিলোকানাং নিকটে ৱযং পত্রং লিখিৎৱেত্থং স্থিরীকৃতৱন্তঃ, দেৱপ্রসাদভোজনং রক্তং গলপীডনমারিতপ্রাণিভোজনং ৱ্যভিচারশ্চৈতেভ্যঃ স্ৱরক্ষণৱ্যতিরেকেণ তেষামন্যৱিধিপালনং করণীযং ন| ");
INSERT INTO sanben_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","ততঃ পৌলস্তান্ মানুষানাদায পরস্মিন্ দিৱসে তৈঃ সহ শুচি র্ভূৎৱা মন্দিরং গৎৱা শৌচকর্ম্মণো দিনেষু সম্পূর্ণেষু তেষাম্ একৈকার্থং নৈৱেদ্যাদ্যুৎসর্গো ভৱিষ্যতীতি জ্ঞাপিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","তেষু সপ্তসু দিনেষু সমাপ্তকল্পেষু আশিযাদেশনিৱাসিনো যিহূদীযাস্তং মধ্যেমন্দিরং ৱিলোক্য জননিৱহস্য মনঃসু কুপ্রৱৃত্তিং জনযিৎৱা তং ধৃৎৱা ");
INSERT INTO sanben_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","প্রোচ্চৈঃ প্রাৱোচন্, হে ইস্রাযেল্লোকাঃ সর্ৱ্ৱে সাহায্যং কুরুত| যো মনুজ এতেষাং লোকানাং মূসাৱ্যৱস্থাযা এতস্য স্থানস্যাপি ৱিপরীতং সর্ৱ্ৱত্র সর্ৱ্ৱান্ শিক্ষযতি স এষঃ; ৱিশেষতঃ স ভিন্নদেশীযলোকান্ মন্দিরম্ আনীয পৱিত্রস্থানমেতদ্ অপৱিত্রমকরোৎ| ");
INSERT INTO sanben_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","পূর্ৱ্ৱং তে মধ্যেনগরম্ ইফিষনগরীযং ত্রফিমং পৌলেন সহিতং দৃষ্টৱন্ত এতস্মাৎ পৌলস্তং মন্দিরমধ্যম্ আনযদ্ ইত্যন্ৱমিমত| ");
INSERT INTO sanben_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","অতএৱ সর্ৱ্ৱস্মিন্ নগরে কলহোৎপন্নৎৱাৎ ধাৱন্তো লোকা আগত্য পৌলং ধৃৎৱা মন্দিরস্য বহিরাকৃষ্যানযন্ তৎক্ষণাদ্ দ্ৱারাণি সর্ৱ্ৱাণি চ রুদ্ধানি| ");
INSERT INTO sanben_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","তেষু তং হন্তুমুদ্যতেेষু যিরূশালম্নগরে মহানুপদ্রৱো জাত ইতি ৱার্ত্তাযাং সহস্রসেনাপতেঃ কর্ণগোচরীভূতাযাং সত্যাং স তৎক্ষণাৎ সৈন্যানি সেনাপতিগণঞ্চ গৃহীৎৱা জৱেনাগতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","ততো লোকাঃ সেনাগণেন সহ সহস্রসেনাপতিম্ আগচ্ছন্তং দৃষ্ট্ৱা পৌলতাডনাতো ন্যৱর্ত্তন্ত| ");
INSERT INTO sanben_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","স সহস্রসেনাপতিঃ সন্নিধাৱাগম্য পৌলং ধৃৎৱা শৃঙ্খলদ্ৱযেন বদ্ধম্ আদিশ্য তান্ পৃষ্টৱান্ এষ কঃ? কিং কর্ম্ম চাযং কৃতৱান্? ");
INSERT INTO sanben_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","ততো জনসমূহস্য কশ্চিদ্ একপ্রকারং কশ্চিদ্ অন্যপ্রকারং ৱাক্যম্ অরৌৎ স তত্র সত্যং জ্ঞাতুম্ কলহকারণাদ্ অশক্তঃ সন্ তং দুর্গং নেতুম্ আজ্ঞাপযৎ| ");
INSERT INTO sanben_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","তেষু সোপানস্যোপরি প্রাপ্তেষু লোকানাং সাহসকারণাৎ সেনাগণঃ পৌলমুত্তোল্য নীতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ততঃ সর্ৱ্ৱে লোকাঃ পশ্চাদ্গামিনঃ সন্ত এনং দুরীকুরুতেতি ৱাক্যম্ উচ্চৈরৱদন্| ");
INSERT INTO sanben_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","পৌলস্য দুর্গানযনসমযে স তস্মৈ সহস্রসেনাপতযে কথিতৱান্, ভৱতঃ পুরস্তাৎ কথাং কথযিতুং কিম্ অনুমন্যতে? স তমপৃচ্ছৎ ৎৱং কিং যূনানীযাং ভাষাং জানাসি? ");
INSERT INTO sanben_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","যো মিসরীযো জনঃ পূর্ৱ্ৱং ৱিরোধং কৃৎৱা চৎৱারি সহস্রাণি ঘাতকান্ সঙ্গিনঃ কৃৎৱা ৱিপিনং গতৱান্ ৎৱং কিং সএৱ ন ভৱসি? ");
INSERT INTO sanben_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","তদা পৌলোঽকথযৎ অহং কিলিকিযাদেশস্য তার্ষনগরীযো যিহূদীযো, নাহং সামান্যনগরীযো মানৱঃ; অতএৱ ৱিনযেঽহং লাকানাং সমক্ষং কথাং কথযিতুং মামনুজানীষ্ৱ| ");
INSERT INTO sanben_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","তেনানুজ্ঞাতঃ পৌলঃ সোপানোপরি তিষ্ঠন্ হস্তেনেঙ্গিতং কৃতৱান্, তস্মাৎ সর্ৱ্ৱে সুস্থিরা অভৱন্| তদা পৌল ইব্রীযভাষযা কথযিতুম্ আরভত, ");
INSERT INTO sanben_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","হে পিতৃগণা হে ভ্রাতৃগণাঃ, ইদানীং মম নিৱেদনে সমৱধত্ত| ");
INSERT INTO sanben_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","তদা স ইব্রীযভাষযা কথাং কথযতীতি শ্রুৎৱা সর্ৱ্ৱে লোকা অতীৱ নিঃশব্দা সন্তোঽতিষ্ঠন্| ");
INSERT INTO sanben_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","পশ্চাৎ সোঽকথযদ্ অহং যিহূদীয ইতি নিশ্চযঃ কিলিকিযাদেশস্য তার্ষনগরং মম জন্মভূমিঃ,এতন্নগরীযস্য গমিলীযেলনাম্নোঽধ্যাপকস্য শিষ্যো ভূৎৱা পূর্ৱ্ৱপুরুষাণাং ৱিধিৱ্যৱস্থানুসারেণ সম্পূর্ণরূপেণ শিক্ষিতোঽভৱম্ ইদানীন্তনা যূযং যাদৃশা ভৱথ তাদৃশোঽহমপীশ্ৱরসেৱাযাম্ উদ্যোগী জাতঃ| ");
INSERT INTO sanben_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","মতমেতদ্ দ্ৱিষ্ট্ৱা তদ্গ্রাহিনারীপুরুষান্ কারাযাং বদ্ধ্ৱা তেষাং প্রাণনাশপর্য্যন্তাং ৱিপক্ষতাম্ অকরৱম্| ");
INSERT INTO sanben_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","মহাযাজকঃ সভাসদঃ প্রাচীনলোকাশ্চ মমৈতস্যাঃ কথাযাঃ প্রমাণং দাতুং শক্নুৱন্তি, যস্মাৎ তেষাং সমীপাদ্ দম্মেষকনগরনিৱাসিভ্রাতৃগণার্থম্ আজ্ঞাপত্রাণি গৃহীৎৱা যে তত্র স্থিতাস্তান্ দণ্ডযিতুং যিরূশালমম্ আনযনার্থং দম্মেষকনগরং গতোস্মি| ");
INSERT INTO sanben_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","কিন্তু গচ্ছন্ তন্নগরস্য সমীপং প্রাপ্তৱান্ তদা দ্ৱিতীযপ্রহরৱেলাযাং সত্যাম্ অকস্মাদ্ গগণান্নির্গত্য মহতী দীপ্তি র্মম চতুর্দিশি প্রকাশিতৱতী| ");
INSERT INTO sanben_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ততো মযি ভূমৌै পতিতে সতি, হে শৌল হে শৌল কুতো মাং তাডযসি? মাম্প্রতি ভাষিত এতাদৃশ একো রৱোপি মযা শ্রুতঃ| ");
INSERT INTO sanben_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","তদাহং প্রত্যৱদং, হে প্রভে কো ভৱান্? ততঃ সোঽৱাদীৎ যং ৎৱং তাডযসি স নাসরতীযো যীশুরহং| ");
INSERT INTO sanben_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","মম সঙ্গিনো লোকাস্তাং দীপ্তিং দৃষ্ট্ৱা ভিযং প্রাপ্তাঃ, কিন্তু মাম্প্রত্যুদিতং তদ্ৱাক্যং তেे নাবুধ্যন্ত| ");
INSERT INTO sanben_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","ততঃ পরং পৃষ্টৱানহং, হে প্রভো মযা কিং কর্ত্তৱ্যং? ততঃ প্রভুরকথযৎ, উত্থায দম্মেষকনগরং যাহি ৎৱযা যদ্যৎ কর্ত্তৱ্যং নিরূপিতমাস্তে তৎ তত্র ৎৱং জ্ঞাপযিষ্যসে| ");
INSERT INTO sanben_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","অনন্তরং তস্যাঃ খরতরদীপ্তেঃ কারণাৎ কিমপি ন দৃষ্ট্ৱা সঙ্গিগণেন ধৃতহস্তঃ সন্ দম্মেষকনগরং ৱ্রজিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","তন্নগরনিৱাসিনাং সর্ৱ্ৱেষাং যিহূদীযানাং মান্যো ৱ্যৱস্থানুসারেণ ভক্তশ্চ হনানীযনামা মানৱ একো ");
INSERT INTO sanben_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","মম সন্নিধিম্ এত্য তিষ্ঠন্ অকথযৎ, হে ভ্রাতঃ শৌল সুদৃষ্টি র্ভৱ তস্মিন্ দণ্ডেঽহং সম্যক্ তং দৃষ্টৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","ততঃ স মহ্যং কথিতৱান্ যথা ৎৱম্ ঈশ্ৱরস্যাভিপ্রাযং ৱেৎসি তস্য শুদ্ধসত্ত্ৱজনস্য দর্শনং প্রাপ্য তস্য শ্রীমুখস্য ৱাক্যং শৃণোষি তন্নিমিত্তম্ অস্মাকং পূর্ৱ্ৱপুরুষাণাম্ ঈশ্ৱরস্ত্ৱাং মনোনীতং কৃতৱানং| ");
INSERT INTO sanben_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","যতো যদ্যদ্ অদ্রাক্ষীরশ্রৌষীশ্চ সর্ৱ্ৱেষাং মানৱানাং সমীপে ৎৱং তেষাং সাক্ষী ভৱিষ্যসি| ");
INSERT INTO sanben_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","অতএৱ কুতো ৱিলম্বসে? প্রভো র্নাম্না প্রার্থ্য নিজপাপপ্রক্ষালনার্থং মজ্জনায সমুত্তিষ্ঠ| ");
INSERT INTO sanben_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","ততঃ পরং যিরূশালম্নগরং প্রত্যাগত্য মন্দিরেঽহম্ একদা প্রার্থযে, তস্মিন্ সমযেঽহম্ অভিভূতঃ সন্ প্রভূং সাক্ষাৎ পশ্যন্, ");
INSERT INTO sanben_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ৎৱং ৎৱরযা যিরূশালমঃ প্রতিষ্ঠস্ৱ যতো লোকামযি তৱ সাক্ষ্যং ন গ্রহীষ্যন্তি, মাম্প্রত্যুদিতং তস্যেদং ৱাক্যম্ অশ্রৌষম্| ");
INSERT INTO sanben_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","ততোহং প্রত্যৱাদিষম্ হে প্রভো প্রতিভজনভৱনং ৎৱযি ৱিশ্ৱাসিনো লোকান্ বদ্ধ্ৱা প্রহৃতৱান্, ");
INSERT INTO sanben_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","তথা তৱ সাক্ষিণঃ স্তিফানস্য রক্তপাতনসমযে তস্য ৱিনাশং সম্মন্য সন্নিধৌ তিষ্ঠন্ হন্তৃলোকানাং ৱাসাংসি রক্ষিতৱান্, এতৎ তে ৱিদুঃ| ");
INSERT INTO sanben_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","ততঃ সোঽকথযৎ প্রতিষ্ঠস্ৱ ৎৱাং দূরস্থভিন্নদেশীযানাং সমীপং প্রেষযিষ্যে| ");
INSERT INTO sanben_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","তদা লোকা এতাৱৎপর্য্যন্তাং তদীযাং কথাং শ্রুৎৱা প্রোচ্চৈরকথযন্, এনং ভূমণ্ডলাদ্ দূরীকুরুত, এতাদৃশজনস্য জীৱনং নোচিতম্| ");
INSERT INTO sanben_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ইত্যুচ্চৈঃ কথযিৎৱা ৱসনানি পরিত্যজ্য গগণং প্রতি ধূলীরক্ষিপন্ ");
INSERT INTO sanben_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ততঃ সহস্রসেনাপতিঃ পৌলং দুর্গাভ্যন্তর নেতুং সমাদিশৎ| এতস্য প্রতিকূলাঃ সন্তো লোকাঃ কিন্নিমিত্তম্ এতাৱদুচ্চৈঃস্ৱরম্ অকুর্ৱ্ৱন্, এতদ্ ৱেত্তুং তং কশযা প্রহৃত্য তস্য পরীক্ষাং কর্ত্তুমাদিশৎ| ");
INSERT INTO sanben_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","পদাতযশ্চর্ম্মনির্ম্মিতরজ্জুভিস্তস্য বন্ধনং কর্ত্তুমুদ্যতাস্তাস্তদানীং পৌলঃ সম্মুখস্থিতং শতসেনাপতিম্ উক্তৱান্ দণ্ডাজ্ঞাযাম্ অপ্রাপ্তাযাং কিং রোমিলোকং প্রহর্ত্তুং যুষ্মাকম্ অধিকারোস্তি? ");
INSERT INTO sanben_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","এনাং কথাং শ্রুৎৱা স সহস্রসেনাপতেঃ সন্নিধিং গৎৱা তাং ৱার্ত্তামৱদৎ স রোমিলোক এতস্মাৎ সাৱধানঃ সন্ কর্ম্ম কুরু| ");
INSERT INTO sanben_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","তস্মাৎ সহস্রসেনাপতি র্গৎৱা তমপ্রাক্ষীৎ ৎৱং কিং রোমিলোকঃ? ইতি মাং ব্রূহি| সোঽকথযৎ সত্যম্| ");
INSERT INTO sanben_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","ততঃ সহস্রসেনাপতিঃ কথিতৱান্ বহুদ্রৱিণং দত্ত্ৱাহং তৎ পৌরসখ্যং প্রাপ্তৱান্; কিন্তু পৌলঃ কথিতৱান্ অহং জনুনা তৎ প্রাপ্তোঽস্মি| ");
INSERT INTO sanben_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","ইত্থং সতি যে প্রহারেণ তং পরীক্ষিতুং সমুদ্যতা আসন্ তে তস্য সমীপাৎ প্রাতিষ্ঠন্ত; সহস্রসেনাপতিস্তং রোমিলোকং ৱিজ্ঞায স্ৱযং যৎ তস্য বন্ধনম্ অকার্ষীৎ তৎকারণাদ্ অবিভেৎ| ");
INSERT INTO sanben_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","যিহূদীযলোকাঃ পৌলং কুতোঽপৱদন্তে তস্য ৱৃত্তান্তং জ্ঞাতুং ৱাঞ্ছন্ সহস্রসেনাপতিঃ পরেঽহনি পৌলং বন্ধনাৎ মোচযিৎৱা প্রধানযাজকান্ মহাসভাযাঃ সর্ৱ্ৱলোকাশ্চ সমুপস্থাতুম্ আদিশ্য তেষাং সন্নিধৌ পৌলম্ অৱরোহ্য স্থাপিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","সভাসদ্লোকান্ প্রতি পৌলোঽনন্যদৃষ্ট্যা পশ্যন্ অকথযৎ, হে ভ্রাতৃগণা অদ্য যাৱৎ সরলেন সর্ৱ্ৱান্তঃকরণেনেশ্ৱরস্য সাক্ষাদ্ আচরামি| ");
INSERT INTO sanben_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","অনেন হনানীযনামা মহাযাজকস্তং কপোলে চপেটেনাহন্তুং সমীপস্থলোকান্ আদিষ্টৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","তদা পৌলস্তমৱদৎ, হে বহিষ্পরিষ্কৃত, ঈশ্ৱরস্ত্ৱাং প্রহর্ত্তুম্ উদ্যতোস্তি, যতো ৱ্যৱস্থানুসারেণ ৱিচারযিতুম্ উপৱিশ্য ৱ্যৱস্থাং লঙ্ঘিৎৱা মাং প্রহর্ত্তুম্ আজ্ঞাপযসি| ");
INSERT INTO sanben_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","ততো নিকটস্থা লোকা অকথযন্, ৎৱং কিম্ ঈশ্ৱরস্য মহাযাজকং নিন্দসি? ");
INSERT INTO sanben_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","ততঃ পৌলঃ প্রতিভাষিতৱান্ হে ভ্রাতৃগণ মহাযাজক এষ ইতি ন বুদ্ধং মযা তদন্যচ্চ স্ৱলোকানাম্ অধিপতিং প্রতি দুর্ৱ্ৱাক্যং মা কথয, এতাদৃশী লিপিরস্তি| ");
INSERT INTO sanben_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","অনন্তরং পৌলস্তেষাম্ অর্দ্ধং সিদূকিলোকা অর্দ্ধং ফিরূশিলোকা ইতি দৃষ্ট্ৱা প্রোচ্চৈঃ সভাস্থলোকান্ অৱদৎ হে ভ্রাতৃগণ অহং ফিরূশিমতাৱলম্বী ফিরূশিনঃ সত্নানশ্চ, মৃতলোকানাম্ উত্থানে প্রত্যাশাকরণাদ্ অহমপৱাদিতোস্মি| ");
INSERT INTO sanben_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","ইতি কথাযাং কথিতাযাং ফিরূশিসিদূকিনোঃ পরস্পরং ভিন্নৱাক্যৎৱাৎ সভাযা মধ্যে দ্ৱৌ সংঘৌ জাতৌ| ");
INSERT INTO sanben_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","যতঃ সিদূকিলোকা উত্থানং স্ৱর্গীযদূতা আত্মানশ্চ সর্ৱ্ৱেষাম্ এতেষাং কমপি ন মন্যন্তে, কিন্তু ফিরূশিনঃ সর্ৱ্ৱম্ অঙ্গীকুর্ৱ্ৱন্তি| ");
INSERT INTO sanben_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","ততঃ পরস্পরম্ অতিশযকোলাহলে সমুপস্থিতে ফিরূশিনাং পক্ষীযাঃ সভাস্থা অধ্যাপকাঃ প্রতিপক্ষা উত্তিষ্ঠন্তো ঽকথযন্, এতস্য মানৱস্য কমপি দোষং ন পশ্যামঃ; যদি কশ্চিদ্ আত্মা ৱা কশ্চিদ্ দূত এনং প্রত্যাদিশৎ তর্হি ৱযম্ ঈশ্ৱরস্য প্রাতিকূল্যেন ন যোৎস্যামঃ| ");
INSERT INTO sanben_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","তস্মাদ্ অতীৱ ভিন্নৱাক্যৎৱে সতি তে পৌলং খণ্ডং খণ্ডং করিষ্যন্তীত্যাশঙ্কযা সহস্রসেনাপতিঃ সেনাগণং তৎস্থানং যাতুং সভাতো বলাৎ পৌলং ধৃৎৱা দুর্গং নেতঞ্চাজ্ঞাপযৎ| ");
INSERT INTO sanben_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","রাত্রো প্রভুস্তস্য সমীপে তিষ্ঠন্ কথিতৱান্ হে পৌল নির্ভযো ভৱ যথা যিরূশালম্নগরে মযি সাক্ষ্যং দত্তৱান্ তথা রোমানগরেপি ৎৱযা দাতৱ্যম্| ");
INSERT INTO sanben_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","দিনে সমুপস্থিতে সতি কিযন্তো যিহূদীযলোকা একমন্ত্রণাঃ সন্তঃ পৌলং ন হৎৱা ভোজনপানে করিষ্যাম ইতি শপথেন স্ৱান্ অবধ্নন্| ");
INSERT INTO sanben_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","চৎৱারিংশজ্জনেভ্যোঽধিকা লোকা ইতি পণম্ অকুর্ৱ্ৱন্| ");
INSERT INTO sanben_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","তে মহাযাজকানাং প্রাচীনলোকানাঞ্চ সমীপং গৎৱা কথযন্, ৱযং পৌলং ন হৎৱা কিমপি ন ভোক্ষ্যামহে দৃঢেনানেন শপথেন বদ্ধ্ৱা অভৱাম| ");
INSERT INTO sanben_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","অতএৱ সাম্প্রতং সভাসদ্লোকৈঃ সহ ৱযং তস্মিন্ কঞ্চিদ্ ৱিশেষৱিচারং করিষ্যামস্তদর্থং ভৱান্ শ্ৱো ঽস্মাকং সমীপং তম্ আনযৎৱিতি সহস্রসেনাপতযে নিৱেদনং কুরুত তেন যুষ্মাকং সমীপং উপস্থিতেঃ পূর্ৱ্ৱং ৱযং তং হন্তু সজ্জিষ্যাম| ");
INSERT INTO sanben_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","তদা পৌলস্য ভাগিনেযস্তেষামিতি মন্ত্রণাং ৱিজ্ঞায দুর্গং গৎৱা তাং ৱার্ত্তাং পৌলম্ উক্তৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","তস্মাৎ পৌল একং শতসেনাপতিম্ আহূয ৱাক্যমিদম্ ভাষিতৱান্ সহস্রসেনাপতেঃ সমীপেঽস্য যুৱমনুষ্যস্য কিঞ্চিন্নিৱেদনম্ আস্তে, তস্মাৎ তৎসৱিধম্ এনং নয| ");
INSERT INTO sanben_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","ততঃ স তমাদায সহস্রসেনাপতেঃ সমীপম্ উপস্থায কথিতৱান্, ভৱতঃ সমীপেঽস্য কিমপি নিৱেদনমাস্তে তস্মাৎ বন্দিঃ পৌলো মামাহূয ভৱতঃ সমীপম্ এনম্ আনেতুং প্রার্থিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","তদা সহস্রসেনাপতিস্তস্য হস্তং ধৃৎৱা নির্জনস্থানং নীৎৱা পৃষ্ঠৱান্ তৱ কিং নিৱেদনং? তৎ কথয| ");
INSERT INTO sanben_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","ততঃ সোকথযৎ, যিহূদীযলাকাঃ পৌলে কমপি ৱিশেষৱিচারং ছলং কৃৎৱা তং সভাং নেতুং ভৱতঃ সমীপে নিৱেদযিতুং অমন্ত্রযন্| ");
INSERT INTO sanben_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","কিন্তু মৱতা তন্ন স্ৱীকর্ত্তৱ্যং যতস্তেষাং মধ্যেৱর্ত্তিনশ্চৎৱারিংশজ্জনেভ্যো ঽধিকলোকা একমন্ত্রণা ভূৎৱা পৌলং ন হৎৱা ভোজনং পানঞ্চ ন করিষ্যাম ইতি শপথেন বদ্ধাঃ সন্তো ঘাতকা ইৱ সজ্জিতা ইদানীং কেৱলং ভৱতো ঽনুমতিম্ অপেক্ষন্তে| ");
INSERT INTO sanben_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","যামিমাং কথাং ৎৱং নিৱেদিতৱান্ তাং কস্মৈচিদপি মা কথযেত্যুক্ত্ৱা সহস্রসেনাপতিস্তং যুৱানং ৱিসৃষ্টৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","অনন্তরং সহস্রসেনাপতি র্দ্ৱৌ শতসেনাপতী আহূযেদম্ আদিশৎ, যুৱাং রাত্রৌ প্রহরৈকাৱশিষ্টাযাং সত্যাং কৈসরিযানগরং যাতুং পদাতিসৈন্যানাং দ্ৱে শতে ঘোটকারোহিসৈন্যানাং সপ্ততিং শক্তিধারিসৈন্যানাং দ্ৱে শতে চ জনান্ সজ্জিতান্ কুরুতং| ");
INSERT INTO sanben_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","পৌলম্ আরোহযিতুং ফীলিক্ষাধিপতেঃ সমীপং নির্ৱ্ৱিঘ্নং নেতুঞ্চ ৱাহনানি সমুপস্থাপযতং| ");
INSERT INTO sanben_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","অপরং স পত্রং লিখিৎৱা দত্তৱান্ তল্লিখিতমেতৎ, ");
INSERT INTO sanben_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","মহামহিমশ্রীযুক্তফীলিক্ষাধিপতযে ক্লৌদিযলুষিযস্য নমস্কারঃ| ");
INSERT INTO sanben_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","যিহূদীযলোকাঃ পূর্ৱ্ৱম্ এনং মানৱং ধৃৎৱা স্ৱহস্তৈ র্হন্তুম্ উদ্যতা এতস্মিন্নন্তরে সসৈন্যোহং তত্রোপস্থায এষ জনো রোমীয ইতি ৱিজ্ঞায তং রক্ষিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","কিন্নিমিত্তং তে তমপৱদন্তে তজ্জ্ঞাতুং তেষা সভাং তমানাযিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","ততস্তেষাং ৱ্যৱস্থাযা ৱিরুদ্ধযা কযাচন কথযা সোঽপৱাদিতোঽভৱৎ, কিন্তু স শৃঙ্খলবন্ধনার্হো ৱা প্রাণনাশার্হো ভৱতীদৃশঃ কোপ্যপরাধো মযাস্য ন দৃষ্টঃ| ");
INSERT INTO sanben_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","তথাপি মনুষ্যস্যাস্য ৱধার্থং যিহূদীযা ঘাতকাইৱ সজ্জিতা এতাং ৱার্ত্তাং শ্রুৎৱা তৎক্ষণাৎ তৱ সমীপমেনং প্রেষিতৱান্ অস্যাপৱাদকাংশ্চ তৱ সমীপং গৎৱাপৱদিতুম্ আজ্ঞাপযম্| ভৱতঃ কুশলং ভূযাৎ| ");
INSERT INTO sanben_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","সৈন্যগণ আজ্ঞানুসারেণ পৌলং গৃহীৎৱা তস্যাং রজন্যাম্ আন্তিপাত্রিনগরম্ আনযৎ| ");
INSERT INTO sanben_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","পরেঽহনি তেন সহ যাতুং ঘোটকারূঢসৈন্যগণং স্থাপযিৎৱা পরাৱৃত্য দুর্গং গতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","ততঃ পরে ঘোটকারোহিসৈন্যগণঃ কৈসরিযানগরম্ উপস্থায তৎপত্রম্ অধিপতেঃ করে সমর্প্য তস্য সমীপে পৌলম্ উপস্থাপিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","তদাধিপতিস্তৎপত্রং পঠিৎৱা পৃষ্ঠৱান্ এষ কিম্প্রদেশীযো জনঃ? স কিলিকিযাপ্রদেশীয একো জন ইতি জ্ঞাৎৱা কথিতৱান্, ");
INSERT INTO sanben_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","তৱাপৱাদকগণ আগতে তৱ কথাং শ্রোষ্যামি| হেরোদ্রাজগৃহে তং স্থাপযিতুম্ আদিষ্টৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","পঞ্চভ্যো দিনেভ্যঃ পরং হনানীযনামা মহাযাজকোঽধিপতেঃ সমক্ষং পৌলস্য প্রাতিকূল্যেন নিৱেদযিতুং তর্তুল্লনামানং কঞ্চন ৱক্তারং প্রাচীনজনাংশ্চ সঙ্গিনঃ কৃৎৱা কৈসরিযানগরম্ আগচ্ছৎ| ");
INSERT INTO sanben_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","ততঃ পৌলে সমানীতে সতি তর্তুল্লস্তস্যাপৱাদকথাং কথযিতুম্ আরভত হে মহামহিমফীলিক্ষ ভৱতো ৱযম্ অতিনির্ৱ্ৱিঘ্নং কালং যাপযামো ভৱতঃ পরিণামদর্শিতযা এতদ্দেশীযানাং বহূনি মঙ্গলানি ঘটিতানি, ");
INSERT INTO sanben_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","ইতি হেতো র্ৱযমতিকৃতজ্ঞাঃ সন্তঃ সর্ৱ্ৱত্র সর্ৱ্ৱদা ভৱতো গুণান্ গাযমঃ| ");
INSERT INTO sanben_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","কিন্তু বহুভিঃ কথাভি র্ভৱন্তং যেন ন ৱিরঞ্জযামি তস্মাদ্ ৱিনযে ভৱান্ বনুকম্প্য মদল্পকথাং শৃণোতু| ");
INSERT INTO sanben_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","এষ মহামারীস্ৱরূপো নাসরতীযমতগ্রাহিসংঘাতস্য মুখ্যো ভূৎৱা সর্ৱ্ৱদেশেষু সর্ৱ্ৱেষাং যিহূদীযানাং রাজদ্রোহাচরণপ্রৱৃত্তিং জনযতীত্যস্মাভি র্নিশ্চিতং| ");
INSERT INTO sanben_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","স মন্দিরমপি অশুচি কর্ত্তুং চেষ্টিতৱান্; ইতি কারণাদ্ ৱযম্ এনং ধৃৎৱা স্ৱৱ্যৱস্থানুসারেণ ৱিচারযিতুং প্রাৱর্ত্তামহি; ");
INSERT INTO sanben_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","কিন্তু লুষিযঃ সহস্রসেনাপতিরাগত্য বলাদ্ অস্মাকং করেভ্য এনং গৃহীৎৱা ");
INSERT INTO sanben_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","এতস্যাপৱাদকান্ ভৱতঃ সমীপম্ আগন্তুম্ আজ্ঞাপযৎ| ৱযং যস্মিন্ তমপৱাদামো ভৱতা পদপৱাদকথাযাং ৱিচারিতাযাং সত্যাং সর্ৱ্ৱং ৱৃত্তান্তং ৱেদিতুং শক্ষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","ততো যিহূদীযা অপি স্ৱীকৃত্য কথিতৱন্ত এষা কথা প্রমাণম্| ");
INSERT INTO sanben_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","অধিপতৌ কথাং কথযিতুং পৌলং প্রতীঙ্গিতং কৃতৱতি স কথিতৱান্ ভৱান্ বহূন্ ৱৎসরান্ যাৱদ্ এতদ্দেশস্য শাসনং করোতীতি ৱিজ্ঞায প্রত্যুত্তরং দাতুম্ অক্ষোভোঽভৱম্| ");
INSERT INTO sanben_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","অদ্য কেৱলং দ্ৱাদশ দিনানি যাতানি, অহম্ আরাধনাং কর্ত্তুং যিরূশালমনগরং গতৱান্ এষা কথা ভৱতা জ্ঞাতুং শক্যতে; ");
INSERT INTO sanben_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","কিন্ত্ৱিভে মাং মধ্যেমন্দিরং কেনাপি সহ ৱিতণ্ডাং কুর্ৱ্ৱন্তং কুত্রাপি ভজনভৱনে নগরে ৱা লোকান্ কুপ্রৱৃত্তিং জনযন্তুং ন দৃষ্টৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","ইদানীং যস্মিন্ যস্মিন্ মাম্ অপৱদন্তে তস্য কিমপি প্রমাণং দাতুং ন শক্নুৱন্তি| ");
INSERT INTO sanben_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","কিন্তু ভৱিষ্যদ্ৱাক্যগ্রন্থে ৱ্যৱস্থাগ্রন্থে চ যা যা কথা লিখিতাস্তে তাসু সর্ৱ্ৱাসু ৱিশ্ৱস্য যন্মতম্ ইমে ৱিধর্ম্মং জানন্তি তন্মতানুসারেণাহং নিজপিতৃপুরুষাণাম্ ঈশ্ৱরম্ আরাধযামীত্যহং ভৱতঃ সমক্ষম্ অঙ্গীকরোমি| ");
INSERT INTO sanben_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","ধার্ম্মিকাণাম্ অধার্ম্মিকাণাঞ্চ প্রমীতলোকানামেৱোত্থানং ভৱিষ্যতীতি কথামিমে স্ৱীকুর্ৱ্ৱন্তি তথাহমপি তস্মিন্ ঈশ্ৱরে প্রত্যাশাং করোমি; ");
INSERT INTO sanben_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","ঈশ্ৱরস্য মানৱানাঞ্চ সমীপে যথা নির্দোষো ভৱামি তদর্থং সততং যত্নৱান্ অস্মি| ");
INSERT INTO sanben_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","বহুষু ৱৎসরেষু গতেষু স্ৱদেশীযলোকানাং নিমিত্তং দানীযদ্রৱ্যাণি নৈৱেদ্যানি চ সমাদায পুনরাগমনং কৃতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","ততোহং শুচি র্ভূৎৱা লোকানাং সমাগমং কলহং ৱা ন কারিতৱান্ তথাপ্যাশিযাদেশীযাঃ কিযন্তো যিহুদীযলোকা মধ্যেমন্দিরং মাং ধৃতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","মমোপরি যদি কাচিদপৱাদকথাস্তি তর্হি ভৱতঃ সমীপম্ উপস্থায তেষামেৱ সাক্ষ্যদানম্ উচিতম্| ");
INSERT INTO sanben_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","নোচেৎ পূর্ৱ্ৱে মহাসভাস্থানাং লোকানাং সন্নিধৌ মম দণ্ডাযমানৎৱসমযে, অহমদ্য মৃতানামুত্থানে যুষ্মাভি র্ৱিচারিতোস্মি, ");
INSERT INTO sanben_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","তেষাং মধ্যে তিষ্ঠন্নহং যামিমাং কথামুচ্চৈঃ স্ৱরেণ কথিতৱান্ তদন্যো মম কোপি দোষোঽলভ্যত ন ৱেতি ৱরম্ এতে সমুপস্থিতলোকা ৱদন্তু| ");
INSERT INTO sanben_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","তদা ফীলিক্ষ এতাং কথাং শ্রুৎৱা তন্মতস্য ৱিশেষৱৃত্তান্তং ৱিজ্ঞাতুং ৱিচারং স্থগিতং কৃৎৱা কথিতৱান্ লুষিযে সহস্রসেনাপতৌ সমাযাতে সতি যুষ্মাকং ৱিচারম্ অহং নিষ্পাদযিষ্যামি| ");
INSERT INTO sanben_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","অনন্তরং বন্ধনং ৱিনা পৌলং রক্ষিতুং তস্য সেৱনায সাক্ষাৎকরণায ৱা তদীযাত্মীযবন্ধুজনান্ ন ৱারযিতুঞ্চ শমসেনাপতিম্ আদিষ্টৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","অল্পদিনাৎ পরং ফীলিক্ষোঽধিপতি র্দ্রুষিল্লানাম্না যিহূদীযযা স্ৱভার্য্যযা সহাগত্য পৌলমাহূয তস্য মুখাৎ খ্রীষ্টধর্ম্মস্য ৱৃত্তান্তম্ অশ্রৌষীৎ| ");
INSERT INTO sanben_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","পৌলেন ন্যাযস্য পরিমিতভোগস্য চরমৱিচারস্য চ কথাযাং কথিতাযাং সত্যাং ফীলিক্ষঃ কম্পমানঃ সন্ ৱ্যাহরদ্ ইদানীং যাহি, অহম্ অৱকাশং প্রাপ্য ৎৱাম্ আহূস্যামি| ");
INSERT INTO sanben_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","মুক্তিপ্রপ্ত্যর্থং পৌলেন মহ্যং মুদ্রাদাস্যন্তে ইতি পত্যাশাং কৃৎৱা স পুনঃ পুনস্তমাহূয তেন সাকং কথোপকথনং কৃতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","কিন্তু ৱৎসরদ্ৱযাৎ পরং পর্কিযফীষ্ট ফালিক্ষস্য পদং প্রাপ্তে সতি ফীলিক্ষো যিহূদীযান্ সন্তুষ্টান্ চিকীর্ষন্ পৌলং বদ্ধং সংস্থাপ্য গতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","অনন্তরং ফীষ্টো নিজরাজ্যম্ আগত্য দিনত্রযাৎ পরং কৈসরিযাতো যিরূশালম্নগরম্ আগমৎ| ");
INSERT INTO sanben_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","তদা মহাযাজকো যিহূদীযানাং প্রধানলোকাশ্চ তস্য সমক্ষং পৌলম্ অপাৱদন্ত| ");
INSERT INTO sanben_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ভৱান্ তং যিরূশালমম্ আনেতুম্ আজ্ঞাপযৎৱিতি ৱিনীয তে তস্মাদ্ অনুগ্রহং ৱাঞ্ছিতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","যতঃ পথিমধ্যে গোপনেন পৌলং হন্তুং তৈ র্ঘাতকা নিযুক্তাঃ| ফীষ্ট উত্তরং দত্তৱান্ পৌলঃ কৈসরিযাযাং স্থাস্যতি পুনরল্পদিনাৎ পরম্ অহং তত্র যাস্যামি| ");
INSERT INTO sanben_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","ততস্তস্য মানুষস্য যদি কশ্চিদ্ অপরাধস্তিষ্ঠতি তর্হি যুষ্মাকং যে শক্নুৱন্তি তে মযা সহ তত্র গৎৱা তমপৱদন্তু স এতাং কথাং কথিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","দশদিৱসেভ্যোঽধিকং ৱিলম্ব্য ফীষ্টস্তস্মাৎ কৈসরিযানগরং গৎৱা পরস্মিন্ দিৱসে ৱিচারাসন উপদিশ্য পৌলম্ আনেতুম্ আজ্ঞাপযৎ| ");
INSERT INTO sanben_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","পৌলে সমুপস্থিতে সতি যিরূশালম্নগরাদ্ আগতা যিহূদীযলোকাস্তং চতুর্দিশি সংৱেষ্ট্য তস্য ৱিরুদ্ধং বহূন্ মহাদোষান্ উত্থাপিতৱন্তঃ কিন্তু তেষাং কিমপি প্রমাণং দাতুং ন শক্নুৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","ততঃ পৌলঃ স্ৱস্মিন্ উত্তরমিদম্ উদিতৱান্, যিহূদীযানাং ৱ্যৱস্থাযা মন্দিরস্য কৈসরস্য ৱা প্রতিকূলং কিমপি কর্ম্ম নাহং কৃতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","কিন্তু ফীষ্টো যিহূদীযান্ সন্তুষ্টান্ কর্ত্তুম্ অভিলষন্ পৌলম্ অভাষত ৎৱং কিং যিরূশালমং গৎৱাস্মিন্ অভিযোগে মম সাক্ষাদ্ ৱিচারিতো ভৱিষ্যসি? ");
INSERT INTO sanben_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","ততঃ পৌল উত্তরং প্রোক্তৱান্, যত্র মম ৱিচারো ভৱিতুং যোগ্যঃ কৈসরস্য তত্র ৱিচারাসন এৱ সমুপস্থিতোস্মি; অহং যিহূদীযানাং কামপি হানিং নাকার্ষম্ ইতি ভৱান্ যথার্থতো ৱিজানাতি| ");
INSERT INTO sanben_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","কঞ্চিদপরাধং কিঞ্চন ৱধার্হং কর্ম্ম ৱা যদ্যহম্ অকরিষ্যং তর্হি প্রাণহননদণ্ডমপি ভোক্তুম্ উদ্যতোঽভৱিষ্যং, কিন্তু তে মম সমপৱাদং কুর্ৱ্ৱন্তি স যদি কল্পিতমাত্রো ভৱতি তর্হি তেষাং করেষু মাং সমর্পযিতুং কস্যাপ্যধিকারো নাস্তি, কৈসরস্য নিকটে মম ৱিচারো ভৱতু| ");
INSERT INTO sanben_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","তদা ফীষ্টো মন্ত্রিভিঃ সার্দ্ধং সংমন্ত্র্য পৌলায কথিতৱান্, কৈসরস্য নিকটে কিং তৱ ৱিচারো ভৱিষ্যতি? কৈসরস্য সমীপং গমিষ্যসি| ");
INSERT INTO sanben_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","কিযদ্দিনেভ্যঃ পরম্ আগ্রিপ্পরাজা বর্ণীকী চ ফীষ্টং সাক্ষাৎ কর্ত্তুং কৈসরিযানগরম্ আগতৱন্তৌ| ");
INSERT INTO sanben_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","তদা তৌ বহুদিনানি তত্র স্থিতৌ ততঃ ফীষ্টস্তং রাজানং পৌলস্য কথাং ৱিজ্ঞাপ্য কথযিতুম্ আরভত পৌলনামানম্ একং বন্দি ফীলিক্ষো বদ্ধং সংস্থাপ্য গতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","যিরূশালমি মম স্থিতিকালে মহাযাজকো যিহূদীযানাং প্রাচীনলোকাশ্চ তম্ অপোদ্য তম্প্রতি দণ্ডাজ্ঞাং প্রার্থযন্ত| ");
INSERT INTO sanben_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","ততোহম্ ইত্যুত্তরম্ অৱদং যাৱদ্ অপোদিতো জনঃ স্ৱাপৱাদকান্ সাক্ষাৎ কৃৎৱা স্ৱস্মিন্ যোঽপরাধ আরোপিতস্তস্য প্রত্যুত্তরং দাতুং সুযোগং ন প্রাপ্নোতি, তাৱৎকালং কস্যাপি মানুষস্য প্রাণনাশাজ্ঞাপনং রোমিলোকানাং রীতি র্নহি| ");
INSERT INTO sanben_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","ততস্তেষ্ৱত্রাগতেষু পরস্মিন্ দিৱসেঽহম্ অৱিলম্বং ৱিচারাসন উপৱিশ্য তং মানুষম্ আনেতুম্ আজ্ঞাপযম্| ");
INSERT INTO sanben_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","তদনন্তরং তস্যাপৱাদকা উপস্থায যাদৃশম্ অহং চিন্তিতৱান্ তাদৃশং কঞ্চন মহাপৱাদং নোত্থাপ্য ");
INSERT INTO sanben_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","স্ৱেষাং মতে তথা পৌলো যং সজীৱং ৱদতি তস্মিন্ যীশুনামনি মৃতজনে চ তস্য ৱিরুদ্ধং কথিতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","ততোহং তাদৃগ্ৱিচারে সংশযানঃ সন্ কথিতৱান্ ৎৱং যিরূশালমং গৎৱা কিং তত্র ৱিচারিতো ভৱিতুম্ ইচ্ছসি? ");
INSERT INTO sanben_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","তদা পৌলো মহারাজস্য নিকটে ৱিচারিতো ভৱিতুং প্রার্থযত, তস্মাদ্ যাৱৎকালং তং কৈসরস্য সমীপং প্রেষযিতুং ন শক্নোমি তাৱৎকালং তমত্র স্থাপযিতুম্ আদিষ্টৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","তত আগ্রিপ্পঃ ফীষ্টম্ উক্তৱান্, অহমপি তস্য মানুষস্য কথাং শ্রোতুম্ অভিলষামি| তদা ফীষ্টো ৱ্যাহরৎ শ্ৱস্তদীযাং কথাং ৎৱং শ্রোষ্যসি| ");
INSERT INTO sanben_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","পরস্মিন্ দিৱসে আগ্রিপ্পো বর্ণীকী চ মহাসমাগমং কৃৎৱা প্রধানৱাহিনীপতিভি র্নগরস্থপ্রধানলোকৈশ্চ সহ মিলিৎৱা রাজগৃহমাগত্য সমুপস্থিতৌ তদা ফীষ্টস্যাজ্ঞযা পৌল আনীতোঽভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","তদা ফীষ্টঃ কথিতৱান্ হে রাজন্ আগ্রিপ্প হে উপস্থিতাঃ সর্ৱ্ৱে লোকা যিরূশালম্নগরে যিহূদীযলোকসমূহো যস্মিন্ মানুষে মম সমীপে নিৱেদনং কৃৎৱা প্রোচ্চৈঃ কথামিমাং কথিতৱান্ পুনরল্পকালমপি তস্য জীৱনং নোচিতং তমেতং মানুষং পশ্যত| ");
INSERT INTO sanben_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","কিন্ত্ৱেষ জনঃ প্রাণনাশর্হং কিমপি কর্ম্ম ন কৃতৱান্ ইত্যজানাং তথাপি স মহারাজস্য সন্নিধৌ ৱিচারিতো ভৱিতুং প্রার্থযত তস্মাৎ তস্য সমীপং তং প্রেষযিতুং মতিমকরৱম্| ");
INSERT INTO sanben_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","কিন্তু শ্রীযুক্তস্য সমীপম্ এতস্মিন্ কিং লেখনীযম্ ইত্যস্য কস্যচিন্ নির্ণযস্য ন জাতৎৱাদ্ এতস্য ৱিচারে সতি যথাহং লেখিতুং কিঞ্চন নিশ্চিতং প্রাপ্নোমি তদর্থং যুষ্মাকং সমক্ষং ৱিশেষতো হে আগ্রিপ্পরাজ ভৱতঃ সমক্ষম্ এতম্ আনযে| ");
INSERT INTO sanben_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","যতো বন্দিপ্রেষণসমযে তস্যাভিযোগস্য কিঞ্চিদলেখনম্ অহম্ অযুক্তং জানামি| ");
INSERT INTO sanben_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","তত আগ্রিপ্পঃ পৌলম্ অৱাদীৎ, নিজাং কথাং কথযিতুং তুভ্যম্ অনুমতি র্দীযতে| তস্মাৎ পৌলঃ করং প্রসার্য্য স্ৱস্মিন্ উত্তরম্ অৱাদীৎ| ");
INSERT INTO sanben_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","হে আগ্রিপ্পরাজ যৎকারণাদহং যিহূদীযৈরপৱাদিতো ঽভৱং তস্য ৱৃত্তান্তম্ অদ্য ভৱতঃ সাক্ষান্ নিৱেদযিতুমনুমতোহম্ ইদং স্ৱীযং পরমং ভাগ্যং মন্যে; ");
INSERT INTO sanben_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","যতো যিহূদীযলোকানাং মধ্যে যা যা রীতিঃ সূক্ষ্মৱিচারাশ্চ সন্তি তেষু ভৱান্ ৱিজ্ঞতমঃ; অতএৱ প্রার্থযে ধৈর্য্যমৱলম্ব্য মম নিৱেদনং শৃণোতু| ");
INSERT INTO sanben_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","অহং যিরূশালম্নগরে স্ৱদেশীযলোকানাং মধ্যে তিষ্ঠন্ আ যৌৱনকালাদ্ যদ্রূপম্ আচরিতৱান্ তদ্ যিহূদীযলোকাঃ সর্ৱ্ৱে ৱিদন্তি| ");
INSERT INTO sanben_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","অস্মাকং সর্ৱ্ৱেভ্যঃ শুদ্ধতমং যৎ ফিরূশীযমতং তদৱলম্বী ভূৎৱাহং কালং যাপিতৱান্ যে জনা আ বাল্যকালান্ মাং জানান্তি তে এতাদৃশং সাক্ষ্যং যদি দদাতি তর্হি দাতুং শক্নুৱন্তি| ");
INSERT INTO sanben_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","কিন্তু হে আগ্রিপ্পরাজ ঈশ্ৱরোঽস্মাকং পূর্ৱ্ৱপুরুষাণাং নিকটে যদ্ অঙ্গীকৃতৱান্ তস্য প্রত্যাশাহেতোরহম্ ইদানীং ৱিচারস্থানে দণ্ডাযমানোস্মি| ");
INSERT INTO sanben_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","তস্যাঙ্গীকারস্য ফলং প্রাপ্তুম্ অস্মাকং দ্ৱাদশৱংশা দিৱানিশং মহাযত্নাদ্ ঈশ্ৱরসেৱনং কৃৎৱা যাং প্রত্যাশাং কুর্ৱ্ৱন্তি তস্যাঃ প্রত্যাশাযা হেতোরহং যিহূদীযৈরপৱাদিতোঽভৱম্| ");
INSERT INTO sanben_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","ঈশ্ৱরো মৃতান্ উত্থাপযিষ্যতীতি ৱাক্যং যুষ্মাকং নিকটেঽসম্ভৱং কুতো ভৱেৎ? ");
INSERT INTO sanben_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","নাসরতীযযীশো র্নাম্নো ৱিরুদ্ধং নানাপ্রকারপ্রতিকূলাচরণম্ উচিতম্ ইত্যহং মনসি যথার্থং ৱিজ্ঞায ");
INSERT INTO sanben_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","যিরূশালমনগরে তদকরৱং ফলতঃ প্রধানযাজকস্য নিকটাৎ ক্ষমতাং প্রাপ্য বহূন্ পৱিত্রলোকান্ কারাযাং বদ্ধৱান্ ৱিশেষতস্তেষাং হননসমযে তেষাং ৱিরুদ্ধাং নিজাং সম্মতিং প্রকাশিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","ৱারং ৱারং ভজনভৱনেষু তেভ্যো দণ্ডং প্রদত্তৱান্ বলাৎ তং ধর্ম্মং নিন্দযিতৱাংশ্চ পুনশ্চ তান্ প্রতি মহাক্রোধাদ্ উন্মত্তঃ সন্ ৱিদেশীযনগরাণি যাৱৎ তান্ তাডিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","ইত্থং প্রধানযাজকস্য সমীপাৎ শক্তিম্ আজ্ঞাপত্রঞ্চ লব্ধ্ৱা দম্মেষক্নগরং গতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","তদাহং হে রাজন্ মার্গমধ্যে মধ্যাহ্নকালে মম মদীযসঙ্গিনাং লোকানাঞ্চ চতসৃষু দিক্ষু গগণাৎ প্রকাশমানাং ভাস্করতোপি তেজস্ৱতীং দীপ্তিং দৃষ্টৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","তস্মাদ্ অস্মাসু সর্ৱ্ৱেষু ভূমৌ পতিতেষু সৎসু হে শৌল হৈ শৌল কুতো মাং তাডযসি? কণ্টকানাং মুখে পাদাহননং তৱ দুঃসাধ্যম্ ইব্রীযভাষযা গদিত এতাদৃশ একঃ শব্দো মযা শ্রুতঃ| ");
INSERT INTO sanben_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","তদাহং পৃষ্টৱান্ হে প্রভো কো ভৱান্? ততঃ স কথিতৱান্ যং যীশুং ৎৱং তাডযসি সোহং, ");
INSERT INTO sanben_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","কিন্তু সমুত্তিষ্ঠ ৎৱং যদ্ দৃষ্টৱান্ ইতঃ পুনঞ্চ যদ্যৎ ৎৱাং দর্শযিষ্যামি তেষাং সর্ৱ্ৱেষাং কার্য্যাণাং ৎৱাং সাক্ষিণং মম সেৱকঞ্চ কর্ত্তুম্ দর্শনম্ অদাম্| ");
INSERT INTO sanben_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","ৱিশেষতো যিহূদীযলোকেভ্যো ভিন্নজাতীযেভ্যশ্চ ৎৱাং মনোনীতং কৃৎৱা তেষাং যথা পাপমোচনং ভৱতি ");
INSERT INTO sanben_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","যথা তে মযি ৱিশ্ৱস্য পৱিত্রীকৃতানাং মধ্যে ভাগং প্রাপ্নুৱন্তি তদভিপ্রাযেণ তেষাং জ্ঞানচক্ষূংষি প্রসন্নানি কর্ত্তুং তথান্ধকারাদ্ দীপ্তিং প্রতি শৈতানাধিকারাচ্চ ঈশ্ৱরং প্রতি মতীঃ পরাৱর্ত্তযিতুং তেষাং সমীপং ৎৱাং প্রেষ্যামি| ");
INSERT INTO sanben_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","হে আগ্রিপ্পরাজ এতাদৃশং স্ৱর্গীযপ্রত্যাদেশং অগ্রাহ্যম্ অকৃৎৱাহং ");
INSERT INTO sanben_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","প্রথমতো দম্মেষক্নগরে ততো যিরূশালমি সর্ৱ্ৱস্মিন্ যিহূদীযদেশে অন্যেষু দেশেষু চ যেेন লোকা মতিং পরাৱর্ত্ত্য ঈশ্ৱরং প্রতি পরাৱর্ত্তযন্তে, মনঃপরাৱর্ত্তনযোগ্যানি কর্ম্মাণি চ কুর্ৱ্ৱন্তি তাদৃশম্ উপদেশং প্রচারিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","এতৎকারণাদ্ যিহূদীযা মধ্যেমন্দিরং মাং ধৃৎৱা হন্তুম্ উদ্যতাঃ| ");
INSERT INTO sanben_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","তথাপি খ্রীষ্টো দুঃখং ভুক্ত্ৱা সর্ৱ্ৱেষাং পূর্ৱ্ৱং শ্মশানাদ্ উত্থায নিজদেশীযানাং ভিন্নদেশীযানাঞ্চ সমীপে দীপ্তিং প্রকাশযিষ্যতি ");
INSERT INTO sanben_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","ভৱিষ্যদ্ৱাদিগণো মূসাশ্চ ভাৱিকার্য্যস্য যদিদং প্রমাণম্ অদদুরেতদ্ ৱিনান্যাং কথাং ন কথযিৎৱা ঈশ্ৱরাদ্ অনুগ্রহং লব্ধ্ৱা মহতাং ক্ষুদ্রাণাঞ্চ সর্ৱ্ৱেষাং সমীপে প্রমাণং দত্ত্ৱাদ্য যাৱৎ তিষ্ঠামি| ");
INSERT INTO sanben_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","তস্যমাং কথাং নিশম্য ফীষ্ট উচ্চৈঃ স্ৱরেণ কথিতৱান্ হে পৌল ৎৱম্ উন্মত্তোসি বহুৱিদ্যাভ্যাসেন ৎৱং হতজ্ঞানো জাতঃ| ");
INSERT INTO sanben_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","স উক্তৱান্ হে মহামহিম ফীষ্ট নাহম্ উন্মত্তঃ কিন্তু সত্যং ৱিৱেচনীযঞ্চ ৱাক্যং প্রস্তৌমি| ");
INSERT INTO sanben_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","যস্য সাক্ষাদ্ অক্ষোভঃ সন্ কথাং কথযামি স রাজা তদ্ৱৃত্তান্তং জানাতি তস্য সমীপে কিমপি গুপ্তং নেতি মযা নিশ্চিতং বুধ্যতে যতস্তদ্ ৱিজনে ন কৃতং| ");
INSERT INTO sanben_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","হে আগ্রিপ্পরাজ ভৱান্ কিং ভৱিষ্যদ্ৱাদিগণোক্তানি ৱাক্যানি প্রত্যেতি? ভৱান্ প্রত্যেতি তদহং জানামি| ");
INSERT INTO sanben_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","তত আগ্রিপ্পঃ পৌলম্ অভিহিতৱান্ ৎৱং প্রৱৃত্তিং জনযিৎৱা প্রাযেণ মামপি খ্রীষ্টীযং করোষি| ");
INSERT INTO sanben_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","ততঃ সোঽৱাদীৎ ভৱান্ যে যে লোকাশ্চ মম কথাম্ অদ্য শৃণ্ৱন্তি প্রাযেণ ইতি নহি কিন্ত্ৱেতৎ শৃঙ্খলবন্ধনং ৱিনা সর্ৱ্ৱথা তে সর্ৱ্ৱে মাদৃশা ভৱন্ত্ৱিতীশ্ৱস্য সমীপে প্রার্থযেঽহম্| ");
INSERT INTO sanben_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","এতস্যাং কথাযাং কথিতাযাং স রাজা সোঽধিপতি র্বর্ণীকী সভাস্থা লোকাশ্চ তস্মাদ্ উত্থায ");
INSERT INTO sanben_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","গোপনে পরস্পরং ৱিৱিচ্য কথিতৱন্ত এষ জনো বন্ধনার্হং প্রাণহননার্হং ৱা কিমপি কর্ম্ম নাকরোৎ| ");
INSERT INTO sanben_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","তত আগ্রিপ্পঃ ফীষ্টম্ অৱদৎ, যদ্যেষ মানুষঃ কৈসরস্য নিকটে ৱিচারিতো ভৱিতুং ন প্রার্থযিষ্যৎ তর্হি মুক্তো ভৱিতুম্ অশক্ষ্যৎ| ");
INSERT INTO sanben_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","জলপথেনাস্মাকম্ ইতোলিযাদেশং প্রতি যাত্রাযাং নিশ্চিতাযাং সত্যাং তে যূলিযনাম্নো মহারাজস্য সংঘাতান্তর্গতস্য সেনাপতেঃ সমীপে পৌলং তদন্যান্ কতিনযজনাংশ্চ সমার্পযন্| ");
INSERT INTO sanben_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","ৱযম্ আদ্রামুত্তীযং পোতমেকম্ আরুহ্য আশিযাদেশস্য তটসমীপেন যাতুং মতিং কৃৎৱা লঙ্গরম্ উত্থাপ্য পোতম্ অমোচযাম; মাকিদনিযাদেশস্থথিষলনীকীনিৱাস্যারিস্তার্খনামা কশ্চিদ্ জনোঽস্মাভিঃ সার্দ্ধম্ আসীৎ| ");
INSERT INTO sanben_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","পরস্মিন্ দিৱসে ঽস্মাভিঃ সীদোন্নগরে পোতে লাগিতে তত্র যূলিযঃ সেনাপতিঃ পৌলং প্রতি সৌজন্যং প্রদর্থ্য সান্ত্ৱনার্থং বন্ধুবান্ধৱান্ উপযাতুম্ অনুজজ্ঞৌ| ");
INSERT INTO sanben_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","তস্মাৎ পোতে মোচিতে সতি সম্মুখৱাযোঃ সম্ভৱাদ্ ৱযং কুপ্রোপদ্ৱীপস্য তীরসমীপেন গতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","কিলিকিযাযাঃ পাম্ফূলিযাযাশ্চ সমুদ্রস্য পারং গৎৱা লূকিযাদেশান্তর্গতং মুরানগরম্ উপাতিষ্ঠাম| ");
INSERT INTO sanben_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","তৎস্থানাদ্ ইতালিযাদেশং গচ্ছতি যঃ সিকন্দরিযানগরস্য পোতস্তং তত্র প্রাপ্য শতসেনাপতিস্তং পোতম্ অস্মান্ আরোহযৎ| ");
INSERT INTO sanben_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","ততঃ পরং বহূনি দিনানি শনৈঃ শনৈঃ র্গৎৱা ক্নীদপার্শ্ৱোপস্থ্তিेঃ পূর্ৱ্ৱং প্রতিকূলেন পৱনেন ৱযং সল্মোন্যাঃ সম্মুখম্ উপস্থায ক্রীত্যুপদ্ৱীপস্য তীরসমীপেন গতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","কষ্টেন তমুত্তীর্য্য লাসেযানগরস্যাধঃ সুন্দরনামকং খাতম্ উপাতিষ্ঠাম| ");
INSERT INTO sanben_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","ইত্থং বহুতিথঃ কালো যাপিত উপৱাসদিনঞ্চাতীতং, তৎকারণাৎ নৌৱর্ত্মনি ভযঙ্করে সতি পৌলো ৱিনযেন কথিতৱান্, ");
INSERT INTO sanben_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","হে মহেচ্ছা অহং নিশ্চযং জানামি যাত্রাযামস্যাম্ অস্মাকং ক্লেশা বহূনামপচযাশ্চ ভৱিষ্যন্তি, তে কেৱলং পোতসামগ্র্যোরিতি নহি, কিন্ত্ৱস্মাকং প্রাণানামপি| ");
INSERT INTO sanben_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","তদা শতসেনাপতিঃ পৌैेলোক্তৱাক্যতোপি কর্ণধারস্য পোতৱণিজশ্চ ৱাক্যং বহুমংস্ত| ");
INSERT INTO sanben_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","তৎ খাতং শীতকালে ৱাসার্হস্থানং ন তস্মাদ্ অৱাচীপ্রতীচোর্দিশোঃ ক্রীত্যাঃ ফৈনীকিযখাতং যাতুং যদি শক্নুৱন্তস্তর্হি তত্র শীতকালং যাপযিতুং প্রাযেণ সর্ৱ্ৱে মন্ত্রযামাসুঃ| ");
INSERT INTO sanben_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","ততঃ পরং দক্ষিণৱাযু র্মন্দং ৱহতীতি ৱিলোক্য নিজাভিপ্রাযস্য সিদ্ধেঃ সুযোগো ভৱতীতি বুদ্ধ্ৱা পোতং মোচযিৎৱা ক্রীত্যুপদ্ৱীপস্য তীরসমীপেন চলিতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","কিন্ত্ৱল্পক্ষণাৎ পরমেৱ উরক্লুদোন্নামা প্রতিকূলঃ প্রচণ্ডো ৱাযু র্ৱহন্ পোতেঽলগীৎ ");
INSERT INTO sanben_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","তস্যাভিমুখং গন্তুম্ পোতস্যাশক্তৎৱাদ্ ৱযং ৱাযুনা স্ৱযং নীতাঃ| ");
INSERT INTO sanben_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","অনন্তরং ক্লৌদীনাম্ন উপদ্ৱীপস্য কূলসমীপেন পোতং গমযিৎৱা বহুনা কষ্টেন ক্ষুদ্রনাৱম্ অরক্ষাম| ");
INSERT INTO sanben_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","তে তামারুহ্য রজ্জ্চা পোতস্যাধোভাগম্ অবধ্নন্ তদনন্তরং চেৎ পোতো সৈকতে লগতীতি ভযাদ্ ৱাতৱসনান্যমোচযন্ ততঃ পোতো ৱাযুনা চালিতঃ| ");
INSERT INTO sanben_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","কিন্তু ক্রমশো ৱাযোঃ প্রবলৎৱাৎ পোতো দোলাযমানোঽভৱৎ পরস্মিন্ দিৱসে পোতস্থানি কতিপযানি দ্রৱ্যাণি তোযে নিক্ষিপ্তানি| ");
INSERT INTO sanben_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","তৃতীযদিৱসে ৱযং স্ৱহস্তৈঃ পোতসজ্জনদ্রৱ্যাণি নিক্ষিপ্তৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","ততো বহুদিনানি যাৱৎ সূর্য্যনক্ষত্রাদীনি সমাচ্ছন্নানি ততো ঽতীৱ ৱাত্যাগমাদ্ অস্মাকং প্রাণরক্ষাযাঃ কাপি প্রত্যাশা নাতিষ্ঠৎ| ");
INSERT INTO sanben_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","বহুদিনেষু লোকৈরনাহারেণ যাপিতেষু সর্ৱ্ৱেষাং সাক্ষৎ পৌলস্তিষ্ঠন্ অকথযৎ, হে মহেচ্ছাঃ ক্রীত্যুপদ্ৱীপাৎ পোতং ন মোচযিতুম্ অহং পূর্ৱ্ৱং যদ্ অৱদং তদ্গ্রহণং যুষ্মাকম্ উচিতম্ আসীৎ তথা কৃতে যুষ্মাকম্ এষা ৱিপদ্ এষোঽপচযশ্চ নাঘটিষ্যেতাম্| ");
INSERT INTO sanben_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","কিন্তু সাম্প্রতং যুষ্মান্ ৱিনীয ব্রৱীম্যহং, যূযং ন ক্ষুভ্যত যুষ্মাকম্ একস্যাপি প্রাণিনো হানি র্ন ভৱিষ্যতি, কেৱলস্য পোতস্য হানি র্ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","যতো যস্যেশ্ৱরস্য লোকোঽহং যঞ্চাহং পরিচরামি তদীয একো দূতো হ্যো রাত্রৌ মমান্তিকে তিষ্ঠন্ কথিতৱান্, ");
INSERT INTO sanben_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","হে পৌল মা ভৈষীঃ কৈসরস্য সম্মুখে ৎৱযোপস্থাতৱ্যং; তৱৈতান্ সঙ্গিনো লোকান্ ঈশ্ৱরস্তুভ্যং দত্তৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","অতএৱ হে মহেচ্ছা যূযং স্থিরমনসো ভৱত মহ্যং যা কথাকথি সাৱশ্যং ঘটিষ্যতে মমৈতাদৃশী ৱিশ্ৱাস ঈশ্ৱরে ৱিদ্যতে, ");
INSERT INTO sanben_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","কিন্তু কস্যচিদ্ উপদ্ৱীপস্যোপরি পতিতৱ্যম্ অস্মাভিঃ| ");
INSERT INTO sanben_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","ততঃ পরম্ আদ্রিযাসমুদ্রে পোতস্তথৈৱ দোলাযমানঃ সন্ ইতস্ততো গচ্ছন্ চতুর্দশদিৱসস্য রাত্রে র্দ্ৱিতীযপ্রহরসমযে কস্যচিৎ স্থলস্য সমীপমুপতিষ্ঠতীতি পোতীযলোকা অন্ৱমন্যন্ত| ");
INSERT INTO sanben_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","ততস্তে জলং পরিমায তত্র ৱিংশতি র্ৱ্যামা জলানীতি জ্ঞাতৱন্তঃ| কিঞ্চিদ্দূরং গৎৱা পুনরপি জলং পরিমিতৱন্তঃ| তত্র পঞ্চদশ ৱ্যামা জলানি দৃষ্ট্ৱা ");
INSERT INTO sanben_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","চেৎ পাষাণে লগতীতি ভযাৎ পোতস্য পশ্চাদ্ভাগতশ্চতুরো লঙ্গরান্ নিক্ষিপ্য দিৱাকরম্ অপেক্ষ্য সর্ৱ্ৱে স্থিতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","কিন্তু পোতীযলোকাঃ পোতাগ্রভাগে লঙ্গরনিক্ষেপং ছলং কৃৎৱা জলধৌ ক্ষুদ্রনাৱম্ অৱরোহ্য পলাযিতুম্ অচেষ্টন্ত| ");
INSERT INTO sanben_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","ততঃ পৌলঃ সেনাপতযে সৈন্যগণায চ কথিতৱান্, এতে যদি পোতমধ্যে ন তিষ্ঠন্তি তর্হি যুষ্মাকং রক্ষণং ন শক্যং| ");
INSERT INTO sanben_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","তদা সেনাগণো রজ্জূন্ ছিৎৱা নাৱং জলে পতিতুম্ অদদাৎ| ");
INSERT INTO sanben_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","প্রভাতসমযে পৌলঃ সর্ৱ্ৱান্ জনান্ ভোজনার্থং প্রার্থ্য ৱ্যাহরৎ, অদ্য চতুর্দশদিনানি যাৱদ্ যূযম্ অপেক্ষমানা অনাহারাঃ কালম্ অযাপযত কিমপি নাভুংগ্ধং| ");
INSERT INTO sanben_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","অতো ৱিনযেेঽহং ভক্ষ্যং ভুজ্যতাং ততো যুষ্মাকং মঙ্গলং ভৱিষ্যতি, যুষ্মাকং কস্যচিজ্জনস্য শিরসঃ কেশৈকোপি ন নংক্ষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","ইতি ৱ্যাহৃত্য পৌলং পূপং গৃহীৎৱেশ্ৱরং ধন্যং ভাষমাণস্তং ভংক্ত্ৱা ভোক্তুম্ আরব্ধৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","অনন্তরং সর্ৱ্ৱে চ সুস্থিরাঃ সন্তঃ খাদ্যানি পর্প্যগৃহ্লন্| ");
INSERT INTO sanben_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","অস্মাকং পোতে ষট্সপ্তত্যধিকশতদ্ৱযলোকা আসন্| ");
INSERT INTO sanben_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","সর্ৱ্ৱেষু লোকেষু যথেষ্টং ভুক্তৱৎসু পোতস্থন্ গোধূমান্ জলধৌ নিক্ষিপ্য তৈঃ পোতস্য ভারো লঘূকৃতঃ| ");
INSERT INTO sanben_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","দিনে জাতেঽপি স কো দেশ ইতি তদা ন পর্য্যচীযত; কিন্তু তত্র সমতটম্ একং খাতং দৃষ্ট্ৱা যদি শক্নুমস্তর্হি ৱযং তস্যাভ্যন্তরং পোতং গমযাম ইতি মতিং কৃৎৱা তে লঙ্গরান্ ছিত্ত্ৱা জলধৌ ত্যক্তৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","তথা কর্ণবন্ধনং মোচযিৎৱা প্রধানং ৱাতৱসনম্ উত্তোল্য তীরসমীপং গতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","কিন্তু দ্ৱযোঃ সমুদ্রযোঃ সঙ্গমস্থানে সৈকতোপরি পোতে নিক্ষিপ্তে ঽগ্রভাগে বাধিতে পশ্চাদ্ভাগে প্রবলতরঙ্গোঽলগৎ তেন পোতো ভগ্নঃ| ");
INSERT INTO sanben_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","তস্মাদ্ বন্দযশ্চেদ্ বাহুভিস্তরন্তঃ পলাযন্তে ইত্যাশঙ্কযা সেনাগণস্তান্ হন্তুম্ অমন্ত্রযৎ; ");
INSERT INTO sanben_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","কিন্তু শতসেনাপতিঃ পৌলং রক্ষিতুং প্রযত্নং কৃৎৱা তান্ তচ্চেষ্টাযা নিৱর্ত্য ইত্যাদিষ্টৱান্, যে বাহুতরণং জানন্তি তেঽগ্রে প্রোল্লম্প্য সমুদ্রে পতিৎৱা বাহুভিস্তীর্ত্ত্ৱা কূলং যান্তু| ");
INSERT INTO sanben_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","অপরম্ অৱশিষ্টা জনাঃ কাষ্ঠং পোতীযং দ্রৱ্যং ৱা যেন যৎ প্রাপ্যতে তদৱলম্ব্য যান্তু; ইত্থং সর্ৱ্ৱে ভূমিং প্রাপ্য প্রাণৈ র্জীৱিতাঃ| ");
INSERT INTO sanben_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","ইত্থং সর্ৱ্ৱেষু রক্ষাং প্রাপ্তেষু তত্রত্যোপদ্ৱীপস্য নাম মিলীতেতি তে জ্ঞাতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","অসভ্যলোকা যথেষ্টম্ অনুকম্পাং কৃৎৱা ৱর্ত্তমানৱৃষ্টেঃ শীতাচ্চ ৱহ্নিং প্রজ্জ্ৱাল্যাস্মাকম্ আতিথ্যম্ অকুর্ৱ্ৱন্| ");
INSERT INTO sanben_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","কিন্তু পৌল ইন্ধনানি সংগৃহ্য যদা তস্মিন্ অগ্রৌ নিরক্ষিপৎ, তদা ৱহ্নেঃ প্রতাপাৎ একঃ কৃষ্ণসর্পো নির্গত্য তস্য হস্তে দ্রষ্টৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","তেঽসভ্যলোকাস্তস্য হস্তে সর্পম্ অৱলম্বমানং দৃষ্ট্ৱা পরস্পরম্ উক্তৱন্ত এষ জনোঽৱশ্যং নরহা ভৱিষ্যতি, যতো যদ্যপি জলধে রক্ষাং প্রাপ্তৱান্ তথাপি প্রতিফলদাযক এনং জীৱিতুং ন দদাতি| ");
INSERT INTO sanben_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","কিন্তু স হস্তং ৱিধুন্ৱন্ তং সর্পম্ অগ্নিমধ্যে নিক্ষিপ্য কামপি পীডাং নাপ্তৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","ততো ৱিষজ্ৱালযা এতস্য শরীরং স্ফীতং ভৱিষ্যতি যদ্ৱা হঠাদযং প্রাণান্ ত্যক্ষ্যতীতি নিশ্চিত্য লোকা বহুক্ষণানি যাৱৎ তদ্ দ্রষ্টুং স্থিতৱন্তঃ কিন্তু তস্য কস্যাশ্চিদ্ ৱিপদোঽঘটনাৎ তে তদ্ৱিপরীতং ৱিজ্ঞায ভাষিতৱন্ত এষ কশ্চিদ্ দেৱো ভৱেৎ| ");
INSERT INTO sanben_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","পুব্লিযনামা জন একস্তস্যোপদ্ৱীপস্যাধিপতিরাসীৎ তত্র তস্য ভূম্যাদি চ স্থিতং| স জনোঽস্মান্ নিজগৃহং নীৎৱা সৌজন্যং প্রকাশ্য দিনত্রযং যাৱদ্ অস্মাকং আতিথ্যম্ অকরোৎ| ");
INSERT INTO sanben_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","তদা তস্য পুব্লিযস্য পিতা জ্ৱরাতিসারেণ পীড্যমানঃ সন্ শয্যাযাম্ আসীৎ; ততঃ পৌলস্তস্য সমীপং গৎৱা প্রার্থনাং কৃৎৱা তস্য গাত্রে হস্তং সমর্প্য তং স্ৱস্থং কৃতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","ইত্থং ভূতে তদ্ৱীপনিৱাসিন ইতরেপি রোগিলোকা আগত্য নিরামযা অভৱন্| ");
INSERT INTO sanben_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","তস্মাত্তেঽস্মাকম্ অতীৱ সৎকারং কৃতৱন্তঃ, ৱিশেষতঃ প্রস্থানসমযে প্রযোজনীযানি নানদ্রৱ্যাণি দত্তৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","ইত্থং তত্র ত্রিষু মাসেষু গতেষু যস্য চিহ্নং দিযস্কূরী তাদৃশ একঃ সিকন্দরীযনগরস্য পোতঃ শীতকালং যাপযন্ তস্মিন্ উপদ্ৱীপে ঽতিষ্ঠৎ তমেৱ পোতং ৱযম্ আরুহ্য যাত্রাম্ অকুর্ম্ম| ");
INSERT INTO sanben_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","ততঃ প্রথমতঃ সুরাকূসনগরম্ উপস্থায তত্র ত্রীণি দিনানি স্থিতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","তস্মাদ্ আৱৃত্য রীগিযনগরম্ উপস্থিতাঃ দিনৈকস্মাৎ পরং দক্ষিণৱযৌ সানুকূল্যে সতি পরস্মিন্ দিৱসে পতিযলীনগরম্ উপাতিষ্ঠাম| ");
INSERT INTO sanben_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","ততোঽস্মাসু তত্রত্যং ভ্রাতৃগণং প্রাপ্তেষু তে স্ৱৈঃ সার্দ্ধম্ অস্মান্ সপ্ত দিনানি স্থাপযিতুম্ অযতন্ত, ইত্থং ৱযং রোমানগরম্ প্রত্যগচ্ছাম| ");
INSERT INTO sanben_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","তস্মাৎ তত্রত্যাঃ ভ্রাতরোঽস্মাকম্ আগমনৱার্ত্তাং শ্রুৎৱা আপ্পিযফরং ত্রিষ্টাৱর্ণীঞ্চ যাৱদ্ অগ্রেসরাঃ সন্তোস্মান্ সাক্ষাৎ কর্ত্তুম্ আগমন্; তেষাং দর্শনাৎ পৌল ঈশ্ৱরং ধন্যং ৱদন্ আশ্ৱাসম্ আপ্তৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","অস্মাসু রোমানগরং গতেষু শতসেনাপতিঃ সর্ৱ্ৱান্ বন্দীন্ প্রধানসেনাপতেঃ সমীপে সমার্পযৎ কিন্তু পৌলায স্ৱরক্ষকপদাতিনা সহ পৃথগ্ ৱস্তুম্ অনুমতিং দত্তৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","দিনত্রযাৎ পরং পৌলস্তদ্দেশস্থান্ প্রধানযিহূদিন আহূতৱান্ ততস্তেষু সমুপস্থিতেষু স কথিতৱান্, হে ভ্রাতৃগণ নিজলোকানাং পূর্ৱ্ৱপুরুষাণাং ৱা রীতে র্ৱিপরীতং কিঞ্চন কর্ম্মাহং নাকরৱং তথাপি যিরূশালমনিৱাসিনো লোকা মাং বন্দিং কৃৎৱা রোমিলোকানাং হস্তেষু সমর্পিতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","রোমিলোকা ৱিচার্য্য মম প্রাণহননার্হং কিমপি কারণং ন প্রাপ্য মাং মোচযিতুম্ ঐচ্ছন্; ");
INSERT INTO sanben_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","কিন্তু যিহূদিলোকানাম্ আপত্ত্যা মযা কৈসররাজস্য সমীপে ৱিচারস্য প্রার্থনা কর্ত্তৱ্যা জাতা নোচেৎ নিজদেশীযলোকান্ প্রতি মম কোপ্যভিযোগো নাস্তি| ");
INSERT INTO sanben_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","এতৎকারণাদ্ অহং যুষ্মান্ দ্রষ্টুং সংলপিতুঞ্চাহূযম্ ইস্রাযেল্ৱশীযানাং প্রত্যাশাহেতোহম্ এতেন শুঙ্খলেন বদ্ধোঽভৱম্| ");
INSERT INTO sanben_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","তদা তে তম্ অৱাদিষুঃ, যিহূদীযদেশাদ্ ৱযং ৎৱামধি কিমপি পত্রং ন প্রাপ্তা যে ভ্রাতরঃ সমাযাতাস্তেষাং কোপি তৱ কামপি ৱার্ত্তাং নাৱদৎ অভদ্রমপি নাকথযচ্চ| ");
INSERT INTO sanben_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","তৱ মতং কিমিতি ৱযং ৎৱত্তঃ শ্রোতুমিচ্ছামঃ| যদ্ ইদং নৱীনং মতমুত্থিতং তৎ সর্ৱ্ৱত্র সর্ৱ্ৱেষাং নিকটে নিন্দিতং জাতম ইতি ৱযং জানীমঃ| ");
INSERT INTO sanben_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","তৈস্তদর্থম্ একস্মিন্ দিনে নিরূপিতে তস্মিন্ দিনে বহৱ একত্র মিলিৎৱা পৌলস্য ৱাসগৃহম্ আগচ্ছন্ তস্মাৎ পৌল আ প্রাতঃকালাৎ সন্ধ্যাকালং যাৱন্ মূসাৱ্যৱস্থাগ্রন্থাদ্ ভৱিষ্যদ্ৱাদিনাং গ্রন্থেভ্যশ্চ যীশোঃ কথাম্ উত্থাপ্য ঈশ্ৱরস্য রাজ্যে প্রমাণং দৎৱা তেষাং প্রৱৃত্তিং জনযিতুং চেষ্টিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","কেচিত্তু তস্য কথাং প্রত্যাযন্ কেচিত্তু ন প্রত্যাযন্; ");
INSERT INTO sanben_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","এতৎকারণাৎ তেষাং পরস্পরম্ অনৈক্যাৎ সর্ৱ্ৱে চলিতৱন্তঃ; তথাপি পৌল এতাং কথামেকাং কথিতৱান্ পৱিত্র আত্মা যিশযিযস্য ভৱিষ্যদ্ৱক্তু র্ৱদনাদ্ অস্মাকং পিতৃপুরুষেভ্য এতাং কথাং ভদ্রং কথযামাস, যথা, ");
INSERT INTO sanben_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","\"উপগত্য জনানেতান্ ৎৱং ভাষস্ৱ ৱচস্ত্ৱিদং| কর্ণৈঃ শ্রোষ্যথ যূযং হি কিন্তু যূযং ন ভোৎস্যথ| নেত্রৈ র্দ্রক্ষ্যথ যূযঞ্চ জ্ঞাতুং যূযং ন শক্ষ্যথ| ");
INSERT INTO sanben_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","তে মানুষা যথা নেত্রৈঃ পরিপশ্যন্তি নৈৱ হি| কর্ণৈঃ র্যথা ন শৃণ্ৱন্তি বুধ্যন্তে ন চ মানসৈঃ| ৱ্যাৱর্ত্তযৎসু চিত্তানি কালে কুত্রাপি তেষু ৱৈ| মত্তস্তে মনুজাঃ স্ৱস্থা যথা নৈৱ ভৱন্তি চ| তথা তেষাং মনুষ্যাণাং সন্তি স্থূলা হি বুদ্ধযঃ| বধিরীভূতকর্ণাশ্চ জাতাশ্চ মুদ্রিতা দৃশঃ|| ");
INSERT INTO sanben_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","অত ঈশ্ৱরাদ্ যৎ পরিত্রাণং তস্য ৱার্ত্তা ভিন্নদেশীযানাং সমীপং প্রেষিতা তএৱ তাং গ্রহীষ্যন্তীতি যূযং জানীত| ");
INSERT INTO sanben_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","এতাদৃশ্যাং কথাযাং কথিতাযাং সত্যাং যিহূদিনঃ পরস্পরং বহুৱিচারং কুর্ৱ্ৱন্তো গতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","ইত্থং পৌলঃ সম্পূর্ণং ৱৎসরদ্ৱযং যাৱদ্ ভাটকীযে ৱাসগৃহে ৱসন্ যে লোকাস্তস্য সন্নিধিম্ আগচ্ছন্তি তান্ সর্ৱ্ৱানেৱ পরিগৃহ্লন্, ");
INSERT INTO sanben_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","নির্ৱিঘ্নম্ অতিশযনিঃক্ষোভম্ ঈশ্ৱরীযরাজৎৱস্য কথাং প্রচারযন্ প্রভৌ যীশৌ খ্রীষ্টে কথাঃ সমুপাদিশৎ| ইতি||");
INSERT INTO sanben_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","ঈশ্ৱরো নিজপুত্রমধি যং সুসংৱাদং ভৱিষ্যদ্ৱাদিভি র্ধর্ম্মগ্রন্থে প্রতিশ্রুতৱান্ তং সুসংৱাদং প্রচারযিতুং পৃথক্কৃত আহূতঃ প্রেরিতশ্চ প্রভো র্যীশুখ্রীষ্টস্য সেৱকো যঃ পৌলঃ ");
INSERT INTO sanben_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","স রোমানগরস্থান্ ঈশ্ৱরপ্রিযান্ আহূতাংশ্চ পৱিত্রলোকান্ প্রতি পত্রং লিখতি| ");
INSERT INTO sanben_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","অস্মাকং স প্রভু র্যীশুঃ খ্রীষ্টঃ শারীরিকসম্বন্ধেন দাযূদো ৱংশোদ্ভৱঃ ");
INSERT INTO sanben_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","পৱিত্রস্যাত্মনঃ সম্বন্ধেন চেশ্ৱরস্য প্রভাৱৱান্ পুত্র ইতি শ্মশানাৎ তস্যোত্থানেন প্রতিপন্নং| ");
INSERT INTO sanben_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","অপরং যেষাং মধ্যে যীশুনা খ্রীষ্টেন যূযমপ্যাহূতাস্তে ঽন্যদেশীযলোকাস্তস্য নাম্নি ৱিশ্ৱস্য নিদেশগ্রাহিণো যথা ভৱন্তি ");
INSERT INTO sanben_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","তদভিপ্রাযেণ ৱযং তস্মাদ্ অনুগ্রহং প্রেরিতৎৱপদঞ্চ প্রাপ্তাঃ| ");
INSERT INTO sanben_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","তাতেনাস্মাকম্ ঈশ্ৱরেণ প্রভুণা যীশুখ্রীষ্টেন চ যুষ্মভ্যম্ অনুগ্রহঃ শান্তিশ্চ প্রদীযেতাং| ");
INSERT INTO sanben_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","প্রথমতঃ সর্ৱ্ৱস্মিন্ জগতি যুষ্মাকং ৱিশ্ৱাসস্য প্রকাশিতৎৱাদ্ অহং যুষ্মাকং সর্ৱ্ৱেষাং নিমিত্তং যীশুখ্রীষ্টস্য নাম গৃহ্লন্ ঈশ্ৱরস্য ধন্যৱাদং করোমি| ");
INSERT INTO sanben_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","অপরম্ ঈশ্ৱরস্য প্রসাদাদ্ বহুকালাৎ পরং সাম্প্রতং যুষ্মাকং সমীপং যাতুং কথমপি যৎ সুযোগং প্রাপ্নোমি, এতদর্থং নিরন্তরং নামান্যুচ্চারযন্ নিজাসু সর্ৱ্ৱপ্রার্থনাসু সর্ৱ্ৱদা নিৱেদযামি, ");
INSERT INTO sanben_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","এতস্মিন্ যমহং তৎপুত্রীযসুসংৱাদপ্রচারণেন মনসা পরিচরামি স ঈশ্ৱরো মম সাক্ষী ৱিদ্যতে| ");
INSERT INTO sanben_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","যতো যুষ্মাকং মম চ ৱিশ্ৱাসেন ৱযম্ উভযে যথা শান্তিযুক্তা ভৱাম ইতি কারণাদ্ ");
INSERT INTO sanben_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","যুষ্মাকং স্থৈর্য্যকরণার্থং যুষ্মভ্যং কিঞ্চিৎপরমার্থদানদানায যুষ্মান্ সাক্ষাৎ কর্ত্তুং মদীযা ৱাঞ্ছা| ");
INSERT INTO sanben_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","হে ভ্রাতৃগণ ভিন্নদেশীযলোকানাং মধ্যে যদ্ৱৎ তদ্ৱদ্ যুষ্মাকং মধ্যেপি যথা ফলং ভুঞ্জে তদভিপ্রাযেণ মুহুর্মুহু র্যুষ্মাকং সমীপং গন্তুম্ উদ্যতোঽহং কিন্তু যাৱদ্ অদ্য তস্মিন্ গমনে মম ৱিঘ্নো জাত ইতি যূযং যদ্ অজ্ঞাতাস্তিষ্ঠথ তদহম্ উচিতং ন বুধ্যে| ");
INSERT INTO sanben_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","অহং সভ্যাসভ্যানাং ৱিদ্ৱদৱিদ্ৱতাঞ্চ সর্ৱ্ৱেষাম্ ঋণী ৱিদ্যে| ");
INSERT INTO sanben_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","অতএৱ রোমানিৱাসিনাং যুষ্মাকং সমীপেঽপি যথাশক্তি সুসংৱাদং প্রচারযিতুম্ অহম্ উদ্যতোস্মি| ");
INSERT INTO sanben_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","যতঃ খ্রীষ্টস্য সুসংৱাদো মম লজ্জাস্পদং নহি স ঈশ্ৱরস্য শক্তিস্ৱরূপঃ সন্ আ যিহূদীযেভ্যো ঽন্যজাতীযান্ যাৱৎ সর্ৱ্ৱজাতীযানাং মধ্যে যঃ কশ্চিদ্ তত্র ৱিশ্ৱসিতি তস্যৈৱ ত্রাণং জনযতি| ");
INSERT INTO sanben_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","যতঃ প্রত্যযস্য সমপরিমাণম্ ঈশ্ৱরদত্তং পুণ্যং তৎসুসংৱাদে প্রকাশতে| তদধি ধর্ম্মপুস্তকেপি লিখিতমিদং \"পুণ্যৱান্ জনো ৱিশ্ৱাসেন জীৱিষ্যতি\"| ");
INSERT INTO sanben_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","অতএৱ যে মানৱাঃ পাপকর্ম্মণা সত্যতাং রুন্ধন্তি তেষাং সর্ৱ্ৱস্য দুরাচরণস্যাধর্ম্মস্য চ ৱিরুদ্ধং স্ৱর্গাদ্ ঈশ্ৱরস্য কোপঃ প্রকাশতে| ");
INSERT INTO sanben_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","যত ঈশ্ৱরমধি যদ্যদ্ জ্ঞেযং তদ্ ঈশ্ৱরঃ স্ৱযং তান্ প্রতি প্রকাশিতৱান্ তস্মাৎ তেষাম্ অগোচরং নহি| ");
INSERT INTO sanben_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","ফলতস্তস্যানন্তশক্তীশ্ৱরৎৱাদীন্যদৃশ্যান্যপি সৃষ্টিকালম্ আরভ্য কর্ম্মসু প্রকাশমানানি দৃশ্যন্তে তস্মাৎ তেষাং দোষপ্রক্ষালনস্য পন্থা নাস্তি| ");
INSERT INTO sanben_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","অপরম্ ঈশ্ৱরং জ্ঞাৎৱাপি তে তম্ ঈশ্ৱরজ্ঞানেন নাদ্রিযন্ত কৃতজ্ঞা ৱা ন জাতাঃ; তস্মাৎ তেষাং সর্ৱ্ৱে তর্কা ৱিফলীভূতাঃ, অপরঞ্চ তেষাং ৱিৱেকশূন্যানি মনাংসি তিমিরে মগ্নানি| ");
INSERT INTO sanben_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","তে স্ৱান্ জ্ঞানিনো জ্ঞাৎৱা জ্ঞানহীনা অভৱন্ ");
INSERT INTO sanben_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","অনশ্ৱরস্যেশ্ৱরস্য গৌরৱং ৱিহায নশ্ৱরমনুষ্যপশুপক্ষ্যুরোগামিপ্রভৃতেরাকৃতিৱিশিষ্টপ্রতিমাস্তৈরাশ্রিতাঃ| ");
INSERT INTO sanben_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","ইত্থং ত ঈশ্ৱরস্য সত্যতাং ৱিহায মৃষামতম্ আশ্রিতৱন্তঃ সচ্চিদানন্দং সৃষ্টিকর্ত্তারং ত্যক্ত্ৱা সৃষ্টৱস্তুনঃ পূজাং সেৱাঞ্চ কৃতৱন্তঃ; ");
INSERT INTO sanben_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","ইতি হেতোরীশ্ৱরস্তান্ কুক্রিযাযাং সমর্প্য নিজনিজকুচিন্তাভিলাষাভ্যাং স্ৱং স্ৱং শরীরং পরস্পরম্ অপমানিতং কর্ত্তুম্ অদদাৎ| ");
INSERT INTO sanben_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","ঈশ্ৱরেণ তেষু ক্ৱভিলাষে সমর্পিতেষু তেষাং যোষিতঃ স্ৱাভাৱিকাচরণম্ অপহায ৱিপরীতকৃত্যে প্রাৱর্ত্তন্ত; ");
INSERT INTO sanben_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","তথা পুরুষা অপি স্ৱাভাৱিকযোষিৎসঙ্গমং ৱিহায পরস্পরং কামকৃশানুনা দগ্ধাঃ সন্তঃ পুমাংসঃ পুংভিঃ সাকং কুকৃত্যে সমাসজ্য নিজনিজভ্রান্তেঃ সমুচিতং ফলম্ অলভন্ত| ");
INSERT INTO sanben_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","তে স্ৱেষাং মনঃস্ৱীশ্ৱরায স্থানং দাতুম্ অনিচ্ছুকাস্ততো হেতোরীশ্ৱরস্তান্ প্রতি দুষ্টমনস্কৎৱম্ অৱিহিতক্রিযৎৱঞ্চ দত্তৱান্| ");
INSERT INTO sanben_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","অতএৱ তে সর্ৱ্ৱে ঽন্যাযো ৱ্যভিচারো দুষ্টৎৱং লোভো জিঘাংসা ঈর্ষ্যা ৱধো ৱিৱাদশ্চাতুরী কুমতিরিত্যাদিভি র্দুষ্কর্ম্মভিঃ পরিপূর্ণাঃ সন্তঃ ");
INSERT INTO sanben_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","কর্ণেজপা অপৱাদিন ঈশ্ৱরদ্ৱেষকা হিংসকা অহঙ্কারিণ আত্মশ্লাঘিনঃ কুকর্ম্মোৎপাদকাঃ পিত্রোরাজ্ঞালঙ্ঘকা ");
INSERT INTO sanben_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","অৱিচারকা নিযমলঙ্ঘিনঃ স্নেহরহিতা অতিদ্ৱেষিণো নির্দযাশ্চ জাতাঃ| ");
INSERT INTO sanben_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","যে জনা এতাদৃশং কর্ম্ম কুর্ৱ্ৱন্তি তএৱ মৃতিযোগ্যা ঈশ্ৱরস্য ৱিচারমীদৃশং জ্ঞাৎৱাপি ত এতাদৃশং কর্ম্ম স্ৱযং কুর্ৱ্ৱন্তি কেৱলমিতি নহি কিন্তু তাদৃশকর্ম্মকারিষু লোকেষ্ৱপি প্রীযন্তে| ");
INSERT INTO sanben_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","হে পরদূষক মনুষ্য যঃ কশ্চন ৎৱং ভৱসি তৱোত্তরদানায পন্থা নাস্তি যতো যস্মাৎ কর্ম্মণঃ পরস্ত্ৱযা দূষ্যতে তস্মাৎ ৎৱমপি দূষ্যসে, যতস্তং দূষযন্নপি ৎৱং তদ্ৱদ্ আচরসি| ");
INSERT INTO sanben_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","কিন্ত্ৱেতাদৃগাচারিভ্যো যং দণ্ডম্ ঈশ্ৱরো নিশ্চিনোতি স যথার্থ ইতি ৱযং জানীমঃ| ");
INSERT INTO sanben_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","অতএৱ হে মানুষ ৎৱং যাদৃগাচারিণো দূষযসি স্ৱযং যদি তাদৃগাচরসি তর্হি ৎৱম্ ঈশ্ৱরদণ্ডাৎ পলাযিতুং শক্ষ্যসীতি কিং বুধ্যসে? ");
INSERT INTO sanben_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","অপরং তৱ মনসঃ পরিৱর্ত্তনং কর্ত্তুম্ ইশ্ৱরস্যানুগ্রহো ভৱতি তন্ন বুদ্ধ্ৱা ৎৱং কিং তদীযানুগ্রহক্ষমাচিরসহিষ্ণুৎৱনিধিং তুচ্ছীকরোষি? ");
INSERT INTO sanben_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","তথা স্ৱান্তঃকরণস্য কঠোরৎৱাৎ খেদরাহিত্যাচ্চেশ্ৱরস্য ন্যায্যৱিচারপ্রকাশনস্য ক্রোধস্য চ দিনং যাৱৎ কিং স্ৱার্থং কোপং সঞ্চিনোষি? ");
INSERT INTO sanben_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","কিন্তু স একৈকমনুজায তৎকর্ম্মানুসারেণ প্রতিফলং দাস্যতি; ");
INSERT INTO sanben_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","ৱস্তুতস্তু যে জনা ধৈর্য্যং ধৃৎৱা সৎকর্ম্ম কুর্ৱ্ৱন্তো মহিমা সৎকারোঽমরৎৱঞ্চৈতানি মৃগযন্তে তেভ্যোঽনন্তাযু র্দাস্যতি| ");
INSERT INTO sanben_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","অপরং যে জনাঃ সত্যধর্ম্মম্ অগৃহীৎৱা ৱিপরীতধর্ম্মম্ গৃহ্লন্তি তাদৃশা ৱিরোধিজনাঃ কোপং ক্রোধঞ্চ ভোক্ষ্যন্তে| ");
INSERT INTO sanben_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","আ যিহূদিনোঽন্যদেশিনঃ পর্য্যন্তং যাৱন্তঃ কুকর্ম্মকারিণঃ প্রাণিনঃ সন্তি তে সর্ৱ্ৱে দুঃখং যাতনাঞ্চ গমিষ্যন্তি; ");
INSERT INTO sanben_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","কিন্তু আ যিহূদিনো ভিন্নদেশিপর্য্যন্তা যাৱন্তঃ সৎকর্ম্মকারিণো লোকাঃ সন্তি তান্ প্রতি মহিমা সৎকারঃ শান্তিশ্চ ভৱিষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","ঈশ্ৱরস্য ৱিচারে পক্ষপাতো নাস্তি| ");
INSERT INTO sanben_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","অলব্ধৱ্যৱস্থাশাস্ত্রৈ র্যৈঃ পাপানি কৃতানি ৱ্যৱস্থাশাস্ত্রালব্ধৎৱানুরূপস্তেষাং ৱিনাশো ভৱিষ্যতি; কিন্তু লব্ধৱ্যৱস্থাশাস্ত্রা যে পাপান্যকুর্ৱ্ৱন্ ৱ্যৱস্থানুসারাদেৱ তেষাং ৱিচারো ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","ৱ্যৱস্থাশ্রোতার ঈশ্ৱরস্য সমীপে নিষ্পাপা ভৱিষ্যন্তীতি নহি কিন্তু ৱ্যৱস্থাচারিণ এৱ সপুণ্যা ভৱিষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","যতো ঽলব্ধৱ্যৱস্থাশাস্ত্রা ভিন্নদেশীযলোকা যদি স্ৱভাৱতো ৱ্যৱস্থানুরূপান্ আচারান্ কুর্ৱ্ৱন্তি তর্হ্যলব্ধশাস্ত্রাঃ সন্তোঽপি তে স্ৱেষাং ৱ্যৱস্থাশাস্ত্রমিৱ স্ৱযমেৱ ভৱন্তি| ");
INSERT INTO sanben_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","তেষাং মনসি সাক্ষিস্ৱরূপে সতি তেষাং ৱিতর্কেষু চ কদা তান্ দোষিণঃ কদা ৱা নির্দোষান্ কৃতৱৎসু তে স্ৱান্তর্লিখিতস্য ৱ্যৱস্থাশাস্ত্রস্য প্রমাণং স্ৱযমেৱ দদতি| ");
INSERT INTO sanben_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","যস্মিন্ দিনে মযা প্রকাশিতস্য সুসংৱাদস্যানুসারাদ্ ঈশ্ৱরো যীশুখ্রীষ্টেন মানুষাণাম্ অন্তঃকরণানাং গূঢাভিপ্রাযান্ ধৃৎৱা ৱিচারযিষ্যতি তস্মিন্ ৱিচারদিনে তৎ প্রকাশিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","পশ্য ৎৱং স্ৱযং যিহূদীতি ৱিখ্যাতো ৱ্যৱস্থোপরি ৱিশ্ৱাসং করোষি, ");
INSERT INTO sanben_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ঈশ্ৱরমুদ্দিশ্য স্ৱং শ্লাঘসে, তথা ৱ্যৱস্থযা শিক্ষিতো ভূৎৱা তস্যাভিমতং জানাসি, সর্ৱ্ৱাসাং কথানাং সারং ৱিৱিংক্ষে, ");
INSERT INTO sanben_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","অপরং জ্ঞানস্য সত্যতাযাশ্চাকরস্ৱরূপং শাস্ত্রং মম সমীপে ৱিদ্যত অতো ঽন্ধলোকানাং মার্গদর্শযিতা ");
INSERT INTO sanben_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","তিমিরস্থিতলোকানাং মধ্যে দীপ্তিস্ৱরূপোঽজ্ঞানলোকেভ্যো জ্ঞানদাতা শিশূনাং শিক্ষযিতাহমেৱেতি মন্যসে| ");
INSERT INTO sanben_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","পরান্ শিক্ষযন্ স্ৱযং স্ৱং কিং ন শিক্ষযসি? ৱস্তুতশ্চৌর্য্যনিষেধৱ্যৱস্থাং প্রচারযন্ ৎৱং কিং স্ৱযমেৱ চোরযসি? ");
INSERT INTO sanben_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","তথা পরদারগমনং প্রতিষেধন্ স্ৱযং কিং পরদারান্ গচ্ছসি? তথা ৎৱং স্ৱযং প্রতিমাদ্ৱেষী সন্ কিং মন্দিরস্য দ্রৱ্যাণি হরসি? ");
INSERT INTO sanben_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","যস্ত্ৱং ৱ্যৱস্থাং শ্লাঘসে স ৎৱং কিং ৱ্যৱস্থাম্ অৱমত্য নেশ্ৱরং সম্মন্যসে? ");
INSERT INTO sanben_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","শাস্ত্রে যথা লিখতি \"ভিন্নদেশিনাং সমীপে যুষ্মাকং দোষাদ্ ঈশ্ৱরস্য নাম্নো নিন্দা ভৱতি| \" ");
INSERT INTO sanben_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","যদি ৱ্যৱস্থাং পালযসি তর্হি তৱ ৎৱক্ছেদক্রিযা সফলা ভৱতি; যতি ৱ্যৱস্থাং লঙ্ঘসে তর্হি তৱ ৎৱক্ছেদোঽৎৱক্ছেদো ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","যতো ৱ্যৱস্থাশাস্ত্রাদিষ্টধর্ম্মকর্ম্মাচারী পুমান্ অৎৱক্ছেদী সন্নপি কিং ৎৱক্ছেদিনাং মধ্যে ন গণযিষ্যতে? ");
INSERT INTO sanben_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","কিন্তু লব্ধশাস্ত্রশ্ছিন্নৎৱক্ চ ৎৱং যদি ৱ্যৱস্থালঙ্ঘনং করোষি তর্হি ৱ্যৱস্থাপালকাঃ স্ৱাভাৱিকাচ্ছিন্নৎৱচো লোকাস্ত্ৱাং কিং ন দূষযিষ্যন্তি? ");
INSERT INTO sanben_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","তস্মাদ্ যো বাহ্যে যিহূদী স যিহূদী নহি তথাঙ্গস্য যস্ত্ৱক্ছেদঃ স ৎৱক্ছেদো নহি; ");
INSERT INTO sanben_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","কিন্তু যো জন আন্তরিকো যিহূদী স এৱ যিহূদী অপরঞ্চ কেৱললিখিতযা ৱ্যৱস্থযা ন কিন্তু মানসিকো যস্ত্ৱক্ছেদো যস্য চ প্রশংসা মনুষ্যেভ্যো ন ভূৎৱা ঈশ্ৱরাদ্ ভৱতি স এৱ ৎৱক্ছেদঃ| ");
INSERT INTO sanben_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","অপরঞ্চ যিহূদিনঃ কিং শ্রেষ্ঠৎৱং? তথা ৎৱক্ছেদস্য ৱা কিং ফলং? ");
INSERT INTO sanben_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","সর্ৱ্ৱথা বহূনি ফলানি সন্তি, ৱিশেষত ঈশ্ৱরস্য শাস্ত্রং তেভ্যোঽদীযত| ");
INSERT INTO sanben_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","কৈশ্চিদ্ অৱিশ্ৱসনে কৃতে তেষাম্ অৱিশ্ৱসনাৎ কিম্ ঈশ্ৱরস্য ৱিশ্ৱাস্যতাযা হানিরুৎপৎস্যতে? ");
INSERT INTO sanben_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","কেনাপি প্রকারেণ নহি| যদ্যপি সর্ৱ্ৱে মনুষ্যা মিথ্যাৱাদিনস্তথাপীশ্ৱরঃ সত্যৱাদী| শাস্ত্রে যথা লিখিতমাস্তে, অতস্ত্ৱন্তু স্ৱৱাক্যেন নির্দ্দোষো হি ভৱিষ্যসি| ৱিচারে চৈৱ নিষ্পাপো ভৱিষ্যসি ন সংশযঃ| ");
INSERT INTO sanben_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","অস্মাকম্ অন্যাযেন যদীশ্ৱরস্য ন্যাযঃ প্রকাশতে তর্হি কিং ৱদিষ্যামঃ? অহং মানুষাণাং কথামিৱ কথাং কথযামি, ঈশ্ৱরঃ সমুচিতং দণ্ডং দত্ত্ৱা কিম্ অন্যাযী ভৱিষ্যতি? ");
INSERT INTO sanben_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","ইত্থং ন ভৱতু, তথা সতীশ্ৱরঃ কথং জগতো ৱিচারযিতা ভৱিষ্যতি? ");
INSERT INTO sanben_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","মম মিথ্যাৱাক্যৱদনাদ্ যদীশ্ৱরস্য সত্যৎৱেন তস্য মহিমা ৱর্দ্ধতে তর্হি কস্মাদহং ৱিচারেঽপরাধিৎৱেন গণ্যো ভৱামি? ");
INSERT INTO sanben_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","মঙ্গলার্থং পাপমপি করণীযমিতি ৱাক্যং ৎৱযা কুতো নোচ্যতে? কিন্তু যৈরুচ্যতে তে নিতান্তং দণ্ডস্য পাত্রাণি ভৱন্তি; তথাপি তদ্ৱাক্যম্ অস্মাভিরপ্যুচ্যত ইত্যস্মাকং গ্লানিং কুর্ৱ্ৱন্তঃ কিযন্তো লোকা ৱদন্তি| ");
INSERT INTO sanben_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","অন্যলোকেভ্যো ৱযং কিং শ্রেষ্ঠাঃ? কদাচন নহি যতো যিহূদিনো ঽন্যদেশিনশ্চ সর্ৱ্ৱএৱ পাপস্যাযত্তা ইত্যস্য প্রমাণং ৱযং পূর্ৱ্ৱম্ অদদাম| ");
INSERT INTO sanben_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","লিপি র্যথাস্তে, নৈকোপি ধার্ম্মিকো জনঃ| ");
INSERT INTO sanben_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","তথা জ্ঞানীশ্ৱরজ্ঞানী মানৱঃ কোপি নাস্তি হি| ");
INSERT INTO sanben_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","ৱিমার্গগামিনঃ সর্ৱ্ৱে সর্ৱ্ৱে দুষ্কর্ম্মকারিণঃ| একো জনোপি নো তেষাং সাধুকর্ম্ম করোতি চ| ");
INSERT INTO sanben_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","তথা তেষান্তু ৱৈ কণ্ঠা অনাৱৃতশ্মশানৱৎ| স্তুতিৱাদং প্রকুর্ৱ্ৱন্তি জিহ্ৱাভিস্তে তু কেৱলং| তেষামোষ্ঠস্য নিম্নে তু ৱিষং তিষ্ঠতি সর্প্পৱৎ| ");
INSERT INTO sanben_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","মুখং তেষাং হি শাপেন কপটেন চ পূর্য্যতে| ");
INSERT INTO sanben_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","রক্তপাতায তেষাং তু পদানি ক্ষিপ্রগানি চ| ");
INSERT INTO sanben_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","পথি তেষাং মনুষ্যাণাং নাশঃ ক্লেশশ্চ কেৱলঃ| ");
INSERT INTO sanben_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","তে জনা নহি জানন্তি পন্থানং সুখদাযিনং| ");
INSERT INTO sanben_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","পরমেশাদ্ ভযং যত্তৎ তচ্চক্ষুষোরগোচরং| ");
INSERT INTO sanben_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","ৱ্যৱস্থাযাং যদ্যল্লিখতি তদ্ ৱ্যৱস্থাধীনান্ লোকান্ উদ্দিশ্য লিখতীতি ৱযং জানীমঃ| ততো মনুষ্যমাত্রো নিরুত্তরঃ সন্ ঈশ্ৱরস্য সাক্ষাদ্ অপরাধী ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","অতএৱ ৱ্যৱস্থানুরূপৈঃ কর্ম্মভিঃ কশ্চিদপি প্রাণীশ্ৱরস্য সাক্ষাৎ সপুণ্যীকৃতো ভৱিতুং ন শক্ষ্যতি যতো ৱ্যৱস্থযা পাপজ্ঞানমাত্রং জাযতে| ");
INSERT INTO sanben_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","কিন্তু ৱ্যৱস্থাযাঃ পৃথগ্ ঈশ্ৱরেণ দেযং যৎ পুণ্যং তদ্ ৱ্যৱস্থাযা ভৱিষ্যদ্ৱাদিগণস্য চ ৱচনৈঃ প্রমাণীকৃতং সদ্ ইদানীং প্রকাশতে| ");
INSERT INTO sanben_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","যীশুখ্রীষ্টে ৱিশ্ৱাসকরণাদ্ ঈশ্ৱরেণ দত্তং তৎ পুণ্যং সকলেষু প্রকাশিতং সৎ সর্ৱ্ৱান্ ৱিশ্ৱাসিনঃ প্রতি ৱর্ত্ততে| ");
INSERT INTO sanben_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","তেষাং কোপি প্রভেদো নাস্তি, যতঃ সর্ৱ্ৱএৱ পাপিন ঈশ্ৱরীযতেজোহীনাশ্চ জাতাঃ| ");
INSERT INTO sanben_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","ত ঈশ্ৱরস্যানুগ্রহাদ্ মূল্যং ৱিনা খ্রীষ্টকৃতেন পরিত্রাণেন সপুণ্যীকৃতা ভৱন্তি| ");
INSERT INTO sanben_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","যস্মাৎ স্ৱশোণিতেন ৱিশ্ৱাসাৎ পাপনাশকো বলী ভৱিতুং স এৱ পূর্ৱ্ৱম্ ঈশ্ৱরেণ নিশ্চিতঃ, ইত্থম্ ঈশ্ৱরীযসহিষ্ণুৎৱাৎ পুরাকৃতপাপানাং মার্জ্জনকরণে স্ৱীযযাথার্থ্যং তেন প্রকাশ্যতে, ");
INSERT INTO sanben_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","ৱর্ত্তমানকালীযমপি স্ৱযাথার্থ্যং তেন প্রকাশ্যতে, অপরং যীশৌ ৱিশ্ৱাসিনং সপুণ্যীকুর্ৱ্ৱন্নপি স যাথার্থিকস্তিষ্ঠতি| ");
INSERT INTO sanben_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","তর্হি কুত্রাত্মশ্লাঘা? সা দূরীকৃতা; কযা ৱ্যৱস্থযা? কিং ক্রিযারূপৱ্যৱস্থযা? ইত্থং নহি কিন্তু তৎ কেৱলৱিশ্ৱাসরূপযা ৱ্যৱস্থযৈৱ ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","অতএৱ ৱ্যৱস্থানুরূপাঃ ক্রিযা ৱিনা কেৱলেন ৱিশ্ৱাসেন মানৱঃ সপুণ্যীকৃতো ভৱিতুং শক্নোতীত্যস্য রাদ্ধান্তং দর্শযামঃ| ");
INSERT INTO sanben_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","স কিং কেৱলযিহূদিনাম্ ঈশ্ৱরো ভৱতি? ভিন্নদেশিনাম্ ঈশ্ৱরো ন ভৱতি? ভিন্নদেশিনামপি ভৱতি; ");
INSERT INTO sanben_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","যস্মাদ্ এক ঈশ্ৱরো ৱিশ্ৱাসাৎ ৎৱক্ছেদিনো ৱিশ্ৱাসেনাৎৱক্ছেদিনশ্চ সপুণ্যীকরিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","তর্হি ৱিশ্ৱাসেন ৱযং কিং ৱ্যৱস্থাং লুম্পাম? ইত্থং ন ভৱতু ৱযং ৱ্যৱস্থাং সংস্থাপযাম এৱ| ");
INSERT INTO sanben_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","অস্মাকং পূর্ৱ্ৱপুরুষ ইব্রাহীম্ কাযিকক্রিযযা কিং লব্ধৱান্ এতদধি কিং ৱদিষ্যামঃ? ");
INSERT INTO sanben_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","স যদি নিজক্রিযাভ্যঃ সপুণ্যো ভৱেৎ তর্হি তস্যাত্মশ্লাঘাং কর্ত্তুং পন্থা ভৱেদিতি সত্যং, কিন্ত্ৱীশ্ৱরস্য সমীপে নহি| ");
INSERT INTO sanben_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","শাস্ত্রে কিং লিখতি? ইব্রাহীম্ ঈশ্ৱরে ৱিশ্ৱসনাৎ স ৱিশ্ৱাসস্তস্মৈ পুণ্যার্থং গণিতো বভূৱ| ");
INSERT INTO sanben_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","কর্ম্মকারিণো যদ্ ৱেতনং তদ্ অনুগ্রহস্য ফলং নহি কিন্তু তেনোপার্জিতং মন্তৱ্যম্| ");
INSERT INTO sanben_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","কিন্তু যঃ পাপিনং সপুণ্যীকরোতি তস্মিন্ ৱিশ্ৱাসিনঃ কর্ম্মহীনস্য জনস্য যো ৱিশ্ৱাসঃ স পুণ্যার্থং গণ্যো ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","অপরং যং ক্রিযাহীনম্ ঈশ্ৱরঃ সপুণ্যীকরোতি তস্য ধন্যৱাদং দাযূদ্ ৱর্ণযামাস, যথা, ");
INSERT INTO sanben_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","স ধন্যোঽঘানি মৃষ্টানি যস্যাগাংস্যাৱৃতানি চ| ");
INSERT INTO sanben_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","স চ ধন্যঃ পরেশেন পাপং যস্য ন গণ্যতে| ");
INSERT INTO sanben_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","এষ ধন্যৱাদস্ত্ৱক্ছেদিনম্ অৎৱক্ছেদিনং ৱা কং প্রতি ভৱতি? ইব্রাহীমো ৱিশ্ৱাসঃ পুণ্যার্থং গণিত ইতি ৱযং ৱদামঃ| ");
INSERT INTO sanben_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","স ৱিশ্ৱাসস্তস্য ৎৱক্ছেদিৎৱাৱস্থাযাং কিম্ অৎৱক্ছেদিৎৱাৱস্থাযাং কস্মিন্ সমযে পুণ্যমিৱ গণিতঃ? ৎৱক্ছেদিৎৱাৱস্থাযাং নহি কিন্ত্ৱৎৱক্ছেদিৎৱাৱস্থাযাং| ");
INSERT INTO sanben_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","অপরঞ্চ স যৎ সর্ৱ্ৱেষাম্ অৎৱক্ছেদিনাং ৱিশ্ৱাসিনাম্ আদিপুরুষো ভৱেৎ, তে চ পুণ্যৱত্ত্ৱেন গণ্যেরন্; ");
INSERT INTO sanben_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","যে চ লোকাঃ কেৱলং ছিন্নৎৱচো ন সন্তো ঽস্মৎপূর্ৱ্ৱপুরুষ ইব্রাহীম্ অছিন্নৎৱক্ সন্ যেন ৱিশ্ৱাসমার্গেণ গতৱান্ তেনৈৱ তস্য পাদচিহ্নেন গচ্ছন্তি তেষাং ৎৱক্ছেদিনামপ্যাদিপুরুষো ভৱেৎ তদর্থম্ অৎৱক্ছেদিনো মানৱস্য ৱিশ্ৱাসাৎ পুণ্যম্ উৎপদ্যত ইতি প্রমাণস্ৱরূপং ৎৱক্ছেদচিহ্নং স প্রাপ্নোৎ| ");
INSERT INTO sanben_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","ইব্রাহীম্ জগতোঽধিকারী ভৱিষ্যতি যৈষা প্রতিজ্ঞা তং তস্য ৱংশঞ্চ প্রতি পূর্ৱ্ৱম্ অক্রিযত সা ৱ্যৱস্থামূলিকা নহি কিন্তু ৱিশ্ৱাসজন্যপুণ্যমূলিকা| ");
INSERT INTO sanben_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","যতো ৱ্যৱস্থাৱলম্বিনো যদ্যধিকারিণো ভৱন্তি তর্হি ৱিশ্ৱাসো ৱিফলো জাযতে সা প্রতিজ্ঞাপি লুপ্তৈৱ| ");
INSERT INTO sanben_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","অধিকন্তু ৱ্যৱস্থা কোপং জনযতি যতো ঽৱিদ্যমানাযাং ৱ্যৱস্থাযাম্ আজ্ঞালঙ্ঘনং ন সম্ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","অতএৱ সা প্রতিজ্ঞা যদ্ অনুগ্রহস্য ফলং ভৱেৎ তদর্থং ৱিশ্ৱাসমূলিকা যতস্তথাৎৱে তদ্ৱংশসমুদাযং প্রতি অর্থতো যে ৱ্যৱস্থযা তদ্ৱংশসম্ভৱাঃ কেৱলং তান্ প্রতি নহি কিন্তু য ইব্রাহীমীযৱিশ্ৱাসেন তৎসম্ভৱাস্তানপি প্রতি সা প্রতিজ্ঞা স্থাস্নুর্ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","যো নির্জীৱান্ সজীৱান্ অৱিদ্যমানানি ৱস্তূনি চ ৱিদ্যমানানি করোতি ইব্রাহীমো ৱিশ্ৱাসভূমেস্তস্যেশ্ৱরস্য সাক্ষাৎ সোঽস্মাকং সর্ৱ্ৱেষাম্ আদিপুরুষ আস্তে, যথা লিখিতং ৱিদ্যতে, অহং ৎৱাং বহুজাতীনাম্ আদিপুরুষং কৃৎৱা নিযুক্তৱান্| ");
INSERT INTO sanben_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","ৎৱদীযস্তাদৃশো ৱংশো জনিষ্যতে যদিদং ৱাক্যং প্রতিশ্রুতং তদনুসারাদ্ ইব্রাহীম্ বহুদেশীযলোকানাম্ আদিপুরুষো যদ্ ভৱতি তদর্থং সোঽনপেক্ষিতৱ্যমপ্যপেক্ষমাণো ৱিশ্ৱাসং কৃতৱান্| ");
INSERT INTO sanben_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","অপরঞ্চ ক্ষীণৱিশ্ৱাসো ন ভূৎৱা শতৱৎসরৱযস্কৎৱাৎ স্ৱশরীরস্য জরাং সারানাম্নঃ স্ৱভার্য্যাযা রজোনিৱৃত্তিঞ্চ তৃণায ন মেনে| ");
INSERT INTO sanben_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","অপরম্ অৱিশ্ৱাসাদ্ ঈশ্ৱরস্য প্রতিজ্ঞাৱচনে কমপি সংশযং ন চকার; ");
INSERT INTO sanben_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","কিন্ত্ৱীশ্ৱরেণ যৎ প্রতিশ্রুতং তৎ সাধযিতুং শক্যত ইতি নিশ্চিতং ৱিজ্ঞায দৃঢৱিশ্ৱাসঃ সন্ ঈশ্ৱরস্য মহিমানং প্রকাশযাঞ্চকার| ");
INSERT INTO sanben_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","ইতি হেতোস্তস্য স ৱিশ্ৱাসস্তদীযপুণ্যমিৱ গণযাঞ্চক্রে| ");
INSERT INTO sanben_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","পুণ্যমিৱাগণ্যত তৎ কেৱলস্য তস্য নিমিত্তং লিখিতং নহি, অস্মাকং নিমিত্তমপি, ");
INSERT INTO sanben_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","যতোঽস্মাকং পাপনাশার্থং সমর্পিতোঽস্মাকং পুণ্যপ্রাপ্ত্যর্থঞ্চোত্থাপিতোঽভৱৎ যোঽস্মাকং প্রভু র্যীশুস্তস্যোত্থাপযিতরীশ্ৱরে ");
INSERT INTO sanben_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","যদি ৱযং ৱিশ্ৱসামস্তর্হ্যস্মাকমপি সএৱ ৱিশ্ৱাসঃ পুণ্যমিৱ গণযিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","ৱিশ্ৱাসেন সপুণ্যীকৃতা ৱযম্ ঈশ্ৱরেণ সার্দ্ধং প্রভুণাস্মাকং যীশুখ্রীষ্টেন মেলনং প্রাপ্তাঃ| ");
INSERT INTO sanben_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","অপরং ৱযং যস্মিন্ অনুগ্রহাশ্রযে তিষ্ঠামস্তন্মধ্যং ৱিশ্ৱাসমার্গেণ তেনৈৱানীতা ৱযম্ ঈশ্ৱরীযৱিভৱপ্রাপ্তিপ্রত্যাশযা সমানন্দামঃ| ");
INSERT INTO sanben_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","তৎ কেৱলং নহি কিন্তু ক্লেশভোগেঽপ্যানন্দামো যতঃ ক্লেশাाদ্ ধৈর্য্যং জাযত ইতি ৱযং জানীমঃ, ");
INSERT INTO sanben_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ধৈর্য্যাচ্চ পরীক্ষিতৎৱং জাযতে, পরীক্ষিতৎৱাৎ প্রত্যাশা জাযতে, ");
INSERT INTO sanben_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","প্রত্যাশাতো ৱ্রীডিতৎৱং ন জাযতে, যস্মাদ্ অস্মভ্যং দত্তেন পৱিত্রেণাত্মনাস্মাকম্ অন্তঃকরণানীশ্ৱরস্য প্রেমৱারিণা সিক্তানি| ");
INSERT INTO sanben_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","অস্মাসু নিরুপাযেষু সৎসু খ্রীষ্ট উপযুক্তে সমযে পাপিনাং নিমিত্তং স্ৱীযান্ প্রণান্ অত্যজৎ| ");
INSERT INTO sanben_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","হিতকারিণো জনস্য কৃতে কোপি প্রণান্ ত্যক্তুং সাহসং কর্ত্তুং শক্নোতি, কিন্তু ধার্ম্মিকস্য কৃতে প্রাযেণ কোপি প্রাণান্ ন ত্যজতি| ");
INSERT INTO sanben_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","কিন্ত্ৱস্মাসু পাপিষু সৎস্ৱপি নিমিত্তমস্মাকং খ্রীষ্টঃ স্ৱপ্রাণান্ ত্যক্তৱান্, তত ঈশ্ৱরোস্মান্ প্রতি নিজং পরমপ্রেমাণং দর্শিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","অতএৱ তস্য রক্তপাতেন সপুণ্যীকৃতা ৱযং নিতান্তং তেন কোপাদ্ উদ্ধারিষ্যামহে| ");
INSERT INTO sanben_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","ফলতো ৱযং যদা রিপৱ আস্ম তদেশ্ৱরস্য পুত্রস্য মরণেন তেন সার্দ্ধং যদ্যস্মাকং মেলনং জাতং তর্হি মেলনপ্রাপ্তাঃ সন্তোঽৱশ্যং তস্য জীৱনেন রক্ষাং লপ্স্যামহে| ");
INSERT INTO sanben_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","তৎ কেৱলং নহি কিন্তু যেন মেলনম্ অলভামহি তেনাস্মাকং প্রভুণা যীশুখ্রীষ্টেন সাম্প্রতম্ ঈশ্ৱরে সমানন্দামশ্চ| ");
INSERT INTO sanben_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","তথা সতি, একেন মানুষেণ পাপং পাপেন চ মরণং জগতীং প্রাৱিশৎ অপরং সর্ৱ্ৱেষাং পাপিৎৱাৎ সর্ৱ্ৱে মানুষা মৃতে র্নিঘ্না অভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","যতো ৱ্যৱস্থাদানসমযং যাৱৎ জগতি পাপম্ আসীৎ কিন্তু যত্র ৱ্যৱস্থা ন ৱিদ্যতে তত্র পাপস্যাপি গণনা ন ৱিদ্যতে| ");
INSERT INTO sanben_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","তথাপ্যাদমা যাদৃশং পাপং কৃতং তাদৃশং পাপং যৈ র্নাকারি আদমম্ আরভ্য মূসাং যাৱৎ তেষামপ্যুপরি মৃত্যূ রাজৎৱম্ অকরোৎ স আদম্ ভাৱ্যাদমো নিদর্শনমেৱাস্তে| ");
INSERT INTO sanben_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","কিন্তু পাপকর্ম্মণো যাদৃশো ভাৱস্তাদৃগ্ দানকর্ম্মণো ভাৱো ন ভৱতি যত একস্য জনস্যাপরাধেন যদি বহূনাং মরণম্ অঘটত তথাপীশ্ৱরানুগ্রহস্তদনুগ্রহমূলকং দানঞ্চৈকেন জনেনার্থাদ্ যীশুনা খ্রীষ্টেন বহুষু বাহুল্যাতিবাহুল্যেন ফলতি| ");
INSERT INTO sanben_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","অপরম্ একস্য জনস্য পাপকর্ম্ম যাদৃক্ ফলযুক্তং দানকর্ম্ম তাদৃক্ ন ভৱতি যতো ৱিচারকর্ম্মৈকং পাপম্ আরভ্য দণ্ডজনকং বভূৱ, কিন্তু দানকর্ম্ম বহুপাপান্যারভ্য পুণ্যজনকং বভূৱ| ");
INSERT INTO sanben_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","যত একস্য জনস্য পাপকর্ম্মতস্তেনৈকেন যদি মরণস্য রাজৎৱং জাতং তর্হি যে জনা অনুগ্রহস্য বাহুল্যং পুণ্যদানঞ্চ প্রাপ্নুৱন্তি ত একেন জনেন, অর্থাৎ যীশুখ্রীষ্টেন, জীৱনে রাজৎৱম্ অৱশ্যং করিষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","একোঽপরাধো যদ্ৱৎ সর্ৱ্ৱমানৱানাং দণ্ডগামী মার্গো ঽভৱৎ তদ্ৱদ্ একং পুণ্যদানং সর্ৱ্ৱমানৱানাং জীৱনযুক্তপুণ্যগামী মার্গ এৱ| ");
INSERT INTO sanben_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","অপরম্ একস্য জনস্যাজ্ঞালঙ্ঘনাদ্ যথা বহৱো ঽপরাধিনো জাতাস্তদ্ৱদ্ একস্যাজ্ঞাচরণাদ্ বহৱঃ সপুণ্যীকৃতা ভৱন্তি| ");
INSERT INTO sanben_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","অধিকন্তু ৱ্যৱস্থাগমনাদ্ অপরাধস্য বাহুল্যং জাতং কিন্তু যত্র পাপস্য বাহুল্যং তত্রৈৱ তস্মাদ্ অনুগ্রহস্য বাহুল্যম্ অভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","তেন মৃত্যুনা যদ্ৱৎ পাপস্য রাজৎৱম্ অভৱৎ তদ্ৱদ্ অস্মাকং প্রভুযীশুখ্রীষ্টদ্ৱারানন্তজীৱনদাযিপুণ্যেনানুগ্রহস্য রাজৎৱং ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","প্রভূতরূপেণ যদ্ অনুগ্রহঃ প্রকাশতে তদর্থং পাপে তিষ্ঠাম ইতি ৱাক্যং কিং ৱযং ৱদিষ্যামঃ? তন্ন ভৱতু| ");
INSERT INTO sanben_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","পাপং প্রতি মৃতা ৱযং পুনস্তস্মিন্ কথম্ জীৱিষ্যামঃ? ");
INSERT INTO sanben_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","ৱযং যাৱন্তো লোকা যীশুখ্রীষ্টে মজ্জিতা অভৱাম তাৱন্ত এৱ তস্য মরণে মজ্জিতা ইতি কিং যূযং ন জানীথ? ");
INSERT INTO sanben_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","ততো যথা পিতুঃ পরাক্রমেণ শ্মশানাৎ খ্রীষ্ট উত্থাপিতস্তথা ৱযমপি যৎ নূতনজীৱিন ইৱাচরামস্তদর্থং মজ্জনেন তেন সার্দ্ধং মৃত্যুরূপে শ্মশানে সংস্থাপিতাঃ| ");
INSERT INTO sanben_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","অপরং ৱযং যদি তেন সংযুক্তাঃ সন্তঃ স ইৱ মরণভাগিনো জাতাস্তর্হি স ইৱোত্থানভাগিনোঽপি ভৱিষ্যামঃ| ");
INSERT INTO sanben_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","ৱযং যৎ পাপস্য দাসাঃ পুন র্ন ভৱামস্তদর্থম্ অস্মাকং পাপরূপশরীরস্য ৱিনাশার্থম্ অস্মাকং পুরাতনপুরুষস্তেন সাকং ক্রুশেঽহন্যতেতি ৱযং জানীমঃ| ");
INSERT INTO sanben_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","যো হতঃ স পাপাৎ মুক্ত এৱ| ");
INSERT INTO sanben_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","অতএৱ যদি ৱযং খ্রীষ্টেন সার্দ্ধম্ অহন্যামহি তর্হি পুনরপি তেন সহিতা জীৱিষ্যাম ইত্যত্রাস্মাকং ৱিশ্ৱাসো ৱিদ্যতে| ");
INSERT INTO sanben_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","যতঃ শ্মশানাদ্ উত্থাপিতঃ খ্রীষ্টো পুন র্ন ম্রিযত ইতি ৱযং জানীমঃ| তস্মিন্ কোপ্যধিকারো মৃত্যো র্নাস্তি| ");
INSERT INTO sanben_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","অপরঞ্চ স যদ্ অম্রিযত তেনৈকদা পাপম্ উদ্দিশ্যাম্রিযত, যচ্চ জীৱতি তেনেশ্ৱরম্ উদ্দিশ্য জীৱতি; ");
INSERT INTO sanben_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","তদ্ৱদ্ যূযমপি স্ৱান্ পাপম্ উদ্দিশ্য মৃতান্ অস্মাকং প্রভুণা যীশুখ্রীষ্টেনেশ্ৱরম্ উদ্দিশ্য জীৱন্তো জানীত| ");
INSERT INTO sanben_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","অপরঞ্চ কুৎসিতাভিলাষাाন্ পূরযিতুং যুষ্মাকং মর্ত্যদেহেষু পাপম্ আধিপত্যং ন করোতু| ");
INSERT INTO sanben_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","অপরং স্ৱং স্ৱম্ অঙ্গম্ অধর্ম্মস্যাস্ত্রং কৃৎৱা পাপসেৱাযাং ন সমর্পযত, কিন্তু শ্মশানাদ্ উত্থিতানিৱ স্ৱান্ ঈশ্ৱরে সমর্পযত স্ৱান্যঙ্গানি চ ধর্ম্মাস্ত্রস্ৱরূপাণীশ্ৱরম্ উদ্দিশ্য সমর্পযত| ");
INSERT INTO sanben_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","যুষ্মাকম্ উপরি পাপস্যাধিপত্যং পুন র্ন ভৱিষ্যতি, যস্মাদ্ যূযং ৱ্যৱস্থাযা অনাযত্তা অনুগ্রহস্য চাযত্তা অভৱত| ");
INSERT INTO sanben_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","কিন্তু ৱযং ৱ্যৱস্থাযা অনাযত্তা অনুগ্রহস্য চাযত্তা অভৱাম, ইতি কারণাৎ কিং পাপং করিষ্যামঃ? তন্ন ভৱতু| ");
INSERT INTO sanben_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","যতো মৃতিজনকং পাপং পুণ্যজনকং নিদেশাচরণঞ্চৈতযোর্দ্ৱযো র্যস্মিন্ আজ্ঞাপালনার্থং ভৃত্যানিৱ স্ৱান্ সমর্পযথ, তস্যৈৱ ভৃত্যা ভৱথ, এতৎ কিং যূযং ন জানীথ? ");
INSERT INTO sanben_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","অপরঞ্চ পূর্ৱ্ৱং যূযং পাপস্য ভৃত্যা আস্তেতি সত্যং কিন্তু যস্যাং শিক্ষারূপাযাং মূষাযাং নিক্ষিপ্তা অভৱত তস্যা আকৃতিং মনোভি র্লব্ধৱন্ত ইতি কারণাদ্ ঈশ্ৱরস্য ধন্যৱাদো ভৱতু| ");
INSERT INTO sanben_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","ইত্থং যূযং পাপসেৱাতো মুক্তাঃ সন্তো ধর্ম্মস্য ভৃত্যা জাতাঃ| ");
INSERT INTO sanben_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","যুষ্মাকং শারীরিক্যা দুর্ব্বলতাযা হেতো র্মানৱৱদ্ অহম্ এতদ্ ব্রৱীমি; পুনঃ পুনরধর্ম্মকরণার্থং যদ্ৱৎ পূর্ৱ্ৱং পাপামেধ্যযো র্ভৃত্যৎৱে নিজাঙ্গানি সমার্পযত তদ্ৱদ্ ইদানীং সাধুকর্ম্মকরণার্থং ধর্ম্মস্য ভৃত্যৎৱে নিজাঙ্গানি সমর্পযত| ");
INSERT INTO sanben_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","যদা যূযং পাপস্য ভৃত্যা আস্ত তদা ধর্ম্মস্য নাযত্তা আস্ত| ");
INSERT INTO sanben_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","তর্হি যানি কর্ম্মাণি যূযম্ ইদানীং লজ্জাজনকানি বুধ্যধ্ৱে পূর্ৱ্ৱং তৈ র্যুষ্মাকং কো লাভ আসীৎ? তেষাং কর্ম্মণাং ফলং মরণমেৱ| ");
INSERT INTO sanben_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","কিন্তু সাম্প্রতং যূযং পাপসেৱাতো মুক্তাঃ সন্ত ঈশ্ৱরস্য ভৃত্যাঽভৱত তস্মাদ্ যুষ্মাকং পৱিত্রৎৱরূপং লভ্যম্ অনন্তজীৱনরূপঞ্চ ফলম্ আস্তে| ");
INSERT INTO sanben_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","যতঃ পাপস্য ৱেতনং মরণং কিন্ত্ৱস্মাকং প্রভুণা যীশুখ্রীষ্টেনানন্তজীৱনম্ ঈশ্ৱরদত্তং পারিতোষিকম্ আস্তে| ");
INSERT INTO sanben_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","হে ভ্রাতৃগণ ৱ্যৱস্থাৱিদঃ প্রতি মমেদং নিৱেদনং| ৱিধিঃ কেৱলং যাৱজ্জীৱং মানৱোপর্য্যধিপতিৎৱং করোতীতি যূযং কিং ন জানীথ? ");
INSERT INTO sanben_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","যাৱৎকালং পতি র্জীৱতি তাৱৎকালম্ ঊঢা ভার্য্যা ৱ্যৱস্থযা তস্মিন্ বদ্ধা তিষ্ঠতি কিন্তু যদি পতি র্ম্রিযতে তর্হি সা নারী পত্যু র্ৱ্যৱস্থাতো মুচ্যতে| ");
INSERT INTO sanben_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","এতৎকারণাৎ পত্যুর্জীৱনকালে নারী যদ্যন্যং পুরুষং ৱিৱহতি তর্হি সা ৱ্যভিচারিণী ভৱতি কিন্তু যদি স পতি র্ম্রিযতে তর্হি সা তস্যা ৱ্যৱস্থাযা মুক্তা সতী পুরুষান্তরেণ ৱ্যূঢাপি ৱ্যভিচারিণী ন ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","হে মম ভ্রাতৃগণ, ঈশ্ৱরনিমিত্তং যদস্মাকং ফলং জাযতে তদর্থং শ্মশানাদ্ উত্থাপিতেন পুরুষেণ সহ যুষ্মাকং ৱিৱাহো যদ্ ভৱেৎ তদর্থং খ্রীষ্টস্য শরীরেণ যূযং ৱ্যৱস্থাং প্রতি মৃতৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","যতোঽস্মাকং শারীরিকাচরণসমযে মরণনিমিত্তং ফলম্ উৎপাদযিতুং ৱ্যৱস্থযা দূষিতঃ পাপাভিলাষোঽস্মাকম্ অঙ্গেষু জীৱন্ আসীৎ| ");
INSERT INTO sanben_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","কিন্তু তদা যস্যা ৱ্যৱস্থাযা ৱশে আস্মহি সাম্প্রতং তাং প্রতি মৃতৎৱাদ্ ৱযং তস্যা অধীনৎৱাৎ মুক্তা ইতি হেতোরীশ্ৱরোঽস্মাভিঃ পুরাতনলিখিতানুসারাৎ ন সেৱিতৱ্যঃ কিন্তু নৱীনস্ৱভাৱেনৈৱ সেৱিতৱ্যঃ ");
INSERT INTO sanben_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","তর্হি ৱযং কিং ব্রূমঃ? ৱ্যৱস্থা কিং পাপজনিকা ভৱতি? নেত্থং ভৱতু| ৱ্যৱস্থাম্ অৱিদ্যমানাযাং পাপং কিম্ ইত্যহং নাৱেদং; কিঞ্চ লোভং মা কার্ষীরিতি চেদ্ ৱ্যৱস্থাগ্রন্থে লিখিতং নাভৱিষ্যৎ তর্হি লোভঃ কিম্ভূতস্তদহং নাজ্ঞাস্যং| ");
INSERT INTO sanben_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","কিন্তু ৱ্যৱস্থযা পাপং ছিদ্রং প্রাপ্যাস্মাকম্ অন্তঃ সর্ৱ্ৱৱিধং কুৎসিতাভিলাষম্ অজনযৎ; যতো ৱ্যৱস্থাযাম্ অৱিদ্যমানাযাং পাপং মৃতং| ");
INSERT INTO sanben_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","অপরং পূর্ৱ্ৱং ৱ্যৱস্থাযাম্ অৱিদ্যমানাযাম্ অহম্ অজীৱং ততঃ পরম্ আজ্ঞাযাম্ উপস্থিতাযাম্ পাপম্ অজীৱৎ তদাহম্ অম্রিযে| ");
INSERT INTO sanben_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","ইত্থং সতি জীৱননিমিত্তা যাজ্ঞা সা মম মৃত্যুজনিকাভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","যতঃ পাপং ছিদ্রং প্রাপ্য ৱ্যৱস্থিতাদেশেন মাং ৱঞ্চযিৎৱা তেন মাম্ অহন্| ");
INSERT INTO sanben_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","অতএৱ ৱ্যৱস্থা পৱিত্রা, আদেশশ্চ পৱিত্রো ন্যায্যো হিতকারী চ ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","তর্হি যৎ স্ৱযং হিতকৃৎ তৎ কিং মম মৃত্যুজনকম্ অভৱৎ? নেত্থং ভৱতু; কিন্তু পাপং যৎ পাতকমিৱ প্রকাশতে তথা নিদেশেন পাপং যদতীৱ পাতকমিৱ প্রকাশতে তদর্থং হিতোপাযেন মম মরণম্ অজনযৎ| ");
INSERT INTO sanben_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","ৱ্যৱস্থাত্মবোধিকেতি ৱযং জানীমঃ কিন্ত্ৱহং শারীরতাচারী পাপস্য ক্রীতকিঙ্করো ৱিদ্যে| ");
INSERT INTO sanben_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","যতো যৎ কর্ম্ম করোমি তৎ মম মনোঽভিমতং নহি; অপরং যন্ মম মনোঽভিমতং তন্ন করোমি কিন্তু যদ্ ঋতীযে তৎ করোমি| ");
INSERT INTO sanben_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","তথাৎৱে যন্ মমানভিমতং তদ্ যদি করোমি তর্হি ৱ্যৱস্থা সূত্তমেতি স্ৱীকরোমি| ");
INSERT INTO sanben_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","অতএৱ সম্প্রতি তৎ কর্ম্ম মযা ক্রিযত ইতি নহি কিন্তু মম শরীরস্থেন পাপেনৈৱ ক্রিযতে| ");
INSERT INTO sanben_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","যতো মযি, অর্থতো মম শরীরে, কিমপ্যুত্তমং ন ৱসতি, এতদ্ অহং জানামি; মমেচ্ছুকতাযাং তিষ্ঠন্ত্যামপ্যহম্ উত্তমকর্ম্মসাধনে সমর্থো ন ভৱামি| ");
INSERT INTO sanben_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","যতো যামুত্তমাং ক্রিযাং কর্ত্তুমহং ৱাঞ্ছামি তাং ন করোমি কিন্তু যৎ কুৎসিতং কর্ম্ম কর্ত্তুম্ অনিচ্ছুকোঽস্মি তদেৱ করোমি| ");
INSERT INTO sanben_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","অতএৱ যদ্যৎ কর্ম্ম কর্ত্তুং মমেচ্ছা ন ভৱতি তদ্ যদি করোমি তর্হি তৎ মযা ন ক্রিযতে, মমান্তর্ৱর্ত্তিনা পাপেনৈৱ ক্রিযতে| ");
INSERT INTO sanben_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","ভদ্রং কর্ত্তুম্ ইচ্ছুকং মাং যো ঽভদ্রং কর্ত্তুং প্রৱর্ত্তযতি তাদৃশং স্ৱভাৱমেকং মযি পশ্যামি| ");
INSERT INTO sanben_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","অহম্ আন্তরিকপুরুষেণেশ্ৱরৱ্যৱস্থাযাং সন্তুষ্ট আসে; ");
INSERT INTO sanben_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","কিন্তু তদ্ৱিপরীতং যুধ্যন্তং তদন্যমেকং স্ৱভাৱং মদীযাঙ্গস্থিতং প্রপশ্যামি, স মদীযাঙ্গস্থিতপাপস্ৱভাৱস্যাযত্তং মাং কর্ত্তুং চেষ্টতে| ");
INSERT INTO sanben_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","হা হা যোঽহং দুর্ভাগ্যো মনুজস্তং মাম্ এতস্মান্ মৃতাচ্ছরীরাৎ কো নিস্তারযিষ্যতি? ");
INSERT INTO sanben_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","অস্মাকং প্রভুণা যীশুখ্রীষ্টেন নিস্তারযিতারম্ ঈশ্ৱরং ধন্যং ৱদামি| অতএৱ শরীরেণ পাপৱ্যৱস্থাযা মনসা তু ঈশ্ৱরৱ্যৱস্থাযাঃ সেৱনং করোমি| ");
INSERT INTO sanben_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","যে জনাঃ খ্রীষ্টং যীশুম্ আশ্রিত্য শারীরিকং নাচরন্ত আত্মিকমাচরন্তি তেঽধুনা দণ্ডার্হা ন ভৱন্তি| ");
INSERT INTO sanben_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","জীৱনদাযকস্যাত্মনো ৱ্যৱস্থা খ্রীষ্টযীশুনা পাপমরণযো র্ৱ্যৱস্থাতো মামমোচযৎ| ");
INSERT INTO sanben_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","যস্মাচ্ছারীরস্য দুর্ব্বলৎৱাদ্ ৱ্যৱস্থযা যৎ কর্ম্মাসাধ্যম্ ঈশ্ৱরো নিজপুত্রং পাপিশরীররূপং পাপনাশকবলিরূপঞ্চ প্রেষ্য তস্য শরীরে পাপস্য দণ্ডং কুর্ৱ্ৱন্ তৎকর্ম্ম সাধিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","ততঃ শারীরিকং নাচরিৎৱাস্মাভিরাত্মিকম্ আচরদ্ভির্ৱ্যৱস্থাগ্রন্থে নির্দ্দিষ্টানি পুণ্যকর্ম্মাণি সর্ৱ্ৱাণি সাধ্যন্তে| ");
INSERT INTO sanben_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","যে শারীরিকাচারিণস্তে শারীরিকান্ ৱিষযান্ ভাৱযন্তি যে চাত্মিকাচারিণস্তে আত্মনো ৱিষযান্ ভাৱযন্তি| ");
INSERT INTO sanben_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","শারীরিকভাৱস্য ফলং মৃত্যুঃ কিঞ্চাত্মিকভাৱস্য ফলে জীৱনং শান্তিশ্চ| ");
INSERT INTO sanben_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","যতঃ শারীরিকভাৱ ঈশ্ৱরস্য ৱিরুদ্ধঃ শত্রুতাভাৱ এৱ স ঈশ্ৱরস্য ৱ্যৱস্থাযা অধীনো ন ভৱতি ভৱিতুঞ্চ ন শক্নোতি| ");
INSERT INTO sanben_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","এতস্মাৎ শারীরিকাচারিষু তোষ্টুম্ ঈশ্ৱরেণ ন শক্যং| ");
INSERT INTO sanben_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","কিন্ত্ৱীশ্ৱরস্যাত্মা যদি যুষ্মাকং মধ্যে ৱসতি তর্হি যূযং শারীরিকাচারিণো ন সন্ত আত্মিকাচারিণো ভৱথঃ| যস্মিন্ তু খ্রীষ্টস্যাত্মা ন ৱিদ্যতে স তৎসম্ভৱো নহি| ");
INSERT INTO sanben_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","যদি খ্রীষ্টো যুষ্মান্ অধিতিষ্ঠতি তর্হি পাপম্ উদ্দিশ্য শরীরং মৃতং কিন্তু পুণ্যমুদ্দিশ্যাত্মা জীৱতি| ");
INSERT INTO sanben_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","মৃতগণাদ্ যীশু র্যেনোত্থাপিতস্তস্যাত্মা যদি যুষ্মন্মধ্যে ৱসতি তর্হি মৃতগণাৎ খ্রীষ্টস্য স উত্থাপযিতা যুষ্মন্মধ্যৱাসিনা স্ৱকীযাত্মনা যুষ্মাকং মৃতদেহানপি পুন র্জীৱযিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","হে ভ্রাতৃগণ শরীরস্য ৱযমধমর্ণা ন ভৱামোঽতঃ শারীরিকাচারোঽস্মাভি র্ন কর্ত্তৱ্যঃ| ");
INSERT INTO sanben_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","যদি যূযং শরীরিকাচারিণো ভৱেত তর্হি যুষ্মাভি র্মর্ত্তৱ্যমেৱ কিন্ত্ৱাত্মনা যদি শরীরকর্ম্মাণি ঘাতযেত তর্হি জীৱিষ্যথ| ");
INSERT INTO sanben_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","যতো যাৱন্তো লোকা ঈশ্ৱরস্যাত্মনাকৃষ্যন্তে তে সর্ৱ্ৱ ঈশ্ৱরস্য সন্তানা ভৱন্তি| ");
INSERT INTO sanben_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","যূযং পুনরপি ভযজনকং দাস্যভাৱং ন প্রাপ্তাঃ কিন্তু যেন ভাৱেনেশ্ৱরং পিতঃ পিতরিতি প্রোচ্য সম্বোধযথ তাদৃশং দত্তকপুত্রৎৱভাৱম্ প্রাপ্নুত| ");
INSERT INTO sanben_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","অপরঞ্চ ৱযম্ ঈশ্ৱরস্য সন্তানা এতস্মিন্ পৱিত্র আত্মা স্ৱযম্ অস্মাকম্ আত্মাভিঃ সার্দ্ধং প্রমাণং দদাতি| ");
INSERT INTO sanben_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","অতএৱ ৱযং যদি সন্তানাস্তর্হ্যধিকারিণঃ, অর্থাদ্ ঈশ্ৱরস্য স্ৱত্ত্ৱাধিকারিণঃ খ্রীষ্টেন সহাধিকারিণশ্চ ভৱামঃ; অপরং তেন সার্দ্ধং যদি দুঃখভাগিনো ভৱামস্তর্হি তস্য ৱিভৱস্যাপি ভাগিনো ভৱিষ্যামঃ| ");
INSERT INTO sanben_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","কিন্ত্ৱস্মাসু যো ভাৱীৱিভৱঃ প্রকাশিষ্যতে তস্য সমীপে ৱর্ত্তমানকালীনং দুঃখমহং তৃণায মন্যে| ");
INSERT INTO sanben_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","যতঃ প্রাণিগণ ঈশ্ৱরস্য সন্তানানাং ৱিভৱপ্রাপ্তিম্ আকাঙ্ক্ষন্ নিতান্তম্ অপেক্ষতে| ");
INSERT INTO sanben_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","অপরঞ্চ প্রাণিগণঃ স্ৱৈরম্ অলীকতাযা ৱশীকৃতো নাভৱৎ ");
INSERT INTO sanben_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","কিন্তু প্রাণিগণোঽপি নশ্ৱরতাধীনৎৱাৎ মুক্তঃ সন্ ঈশ্ৱরস্য সন্তানানাং পরমমুক্তিং প্রাপ্স্যতীত্যভিপ্রাযেণ ৱশীকর্ত্রা ৱশীচক্রে| ");
INSERT INTO sanben_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","অপরঞ্চ প্রসূযমানাৱদ্ ৱ্যথিতঃ সন্ ইদানীং যাৱৎ কৃৎস্নঃ প্রাণিগণ আর্ত্তস্ৱরং করোতীতি ৱযং জানীমঃ| ");
INSERT INTO sanben_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","কেৱলঃ স ইতি নহি কিন্তু প্রথমজাতফলস্ৱরূপম্ আত্মানং প্রাপ্তা ৱযমপি দত্তকপুত্রৎৱপদপ্রাপ্তিম্ অর্থাৎ শরীরস্য মুক্তিং প্রতীক্ষমাণাস্তদ্ৱদ্ অন্তরার্ত্তরাৱং কুর্ম্মঃ| ");
INSERT INTO sanben_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","ৱযং প্রত্যাশযা ত্রাণম্ অলভামহি কিন্তু প্রত্যক্ষৱস্তুনো যা প্রত্যাশা সা প্রত্যাশা নহি, যতো মনুষ্যো যৎ সমীক্ষতে তস্য প্রত্যাশাং কুতঃ করিষ্যতি? ");
INSERT INTO sanben_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","যদ্ অপ্রত্যক্ষং তস্য প্রত্যাশাং যদি ৱযং কুর্ৱ্ৱীমহি তর্হি ধৈর্য্যম্ অৱলম্ব্য প্রতীক্ষামহে| ");
INSERT INTO sanben_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","তত আত্মাপি স্ৱযম্ অস্মাকং দুর্ব্বলতাযাঃ সহাযৎৱং করোতি; যতঃ কিং প্রার্থিতৱ্যং তদ্ বোদ্ধুং ৱযং ন শক্নুমঃ, কিন্ত্ৱস্পষ্টৈরার্ত্তরাৱৈরাত্মা স্ৱযম্ অস্মন্নিমিত্তং নিৱেদযতি| ");
INSERT INTO sanben_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","অপরম্ ঈশ্ৱরাভিমতরূপেণ পৱিত্রলোকানাং কৃতে নিৱেদযতি য আত্মা তস্যাভিপ্রাযোঽন্তর্য্যামিনা জ্ঞাযতে| ");
INSERT INTO sanben_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","অপরম্ ঈশ্ৱরীযনিরূপণানুসারেণাহূতাঃ সন্তো যে তস্মিন্ প্রীযন্তে সর্ৱ্ৱাণি মিলিৎৱা তেষাং মঙ্গলং সাধযন্তি, এতদ্ ৱযং জানীমঃ| ");
INSERT INTO sanben_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","যত ঈশ্ৱরো বহুভ্রাতৃণাং মধ্যে স্ৱপুত্রং জ্যেষ্ঠং কর্ত্তুম্ ইচ্ছন্ যান্ পূর্ৱ্ৱং লক্ষ্যীকৃতৱান্ তান্ তস্য প্রতিমূর্ত্যাঃ সাদৃশ্যপ্রাপ্ত্যর্থং ন্যযুংক্ত| ");
INSERT INTO sanben_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","অপরঞ্চ তেন যে নিযুক্তাস্ত আহূতা অপি যে চ তেনাহূতাস্তে সপুণ্যীকৃতাঃ, যে চ তেন সপুণ্যীকৃতাস্তে ৱিভৱযুক্তাঃ| ");
INSERT INTO sanben_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","ইত্যত্র ৱযং কিং ব্রূমঃ? ঈশ্ৱরো যদ্যস্মাকং সপক্ষো ভৱতি তর্হি কো ৱিপক্ষোঽস্মাকং? ");
INSERT INTO sanben_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","আত্মপুত্রং ন রক্ষিৎৱা যোঽস্মাকং সর্ৱ্ৱেষাং কৃতে তং প্রদত্তৱান্ স কিং তেন সহাস্মভ্যম্ অন্যানি সর্ৱ্ৱাণি ন দাস্যতি? ");
INSERT INTO sanben_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","ঈশ্ৱরস্যাভিরুচিতেষু কেন দোষ আরোপযিষ্যতে? য ঈশ্ৱরস্তান্ পুণ্যৱত ইৱ গণযতি কিং তেন? ");
INSERT INTO sanben_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","অপরং তেভ্যো দণ্ডদানাজ্ঞা ৱা কেন করিষ্যতে? যোঽস্মন্নিমিত্তং প্রাণান্ ত্যক্তৱান্ কেৱলং তন্ন কিন্তু মৃতগণমধ্যাদ্ উত্থিতৱান্, অপি চেশ্ৱরস্য দক্ষিণে পার্শ্ৱে তিষ্ঠন্ অদ্যাপ্যস্মাকং নিমিত্তং প্রার্থত এৱম্ভূতো যঃ খ্রীষ্টঃ কিং তেন? ");
INSERT INTO sanben_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","অস্মাভিঃ সহ খ্রীষ্টস্য প্রেমৱিচ্ছেদং জনযিতুং কঃ শক্নোতি? ক্লেশো ৱ্যসনং ৱা তাডনা ৱা দুর্ভিক্ষং ৱা ৱস্ত্রহীনৎৱং ৱা প্রাণসংশযো ৱা খঙ্গো ৱা কিমেতানি শক্নুৱন্তি? ");
INSERT INTO sanben_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","কিন্তু লিখিতম্ আস্তে, যথা, ৱযং তৱ নিমিত্তং স্মো মৃত্যুৱক্ত্রেঽখিলং দিনং| বলির্দেযো যথা মেষো ৱযং গণ্যামহে তথা| ");
INSERT INTO sanben_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","অপরং যোঽস্মাসু প্রীযতে তেনৈতাসু ৱিপৎসু ৱযং সম্যগ্ ৱিজযামহে| ");
INSERT INTO sanben_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","যতোঽস্মাকং প্রভুনা যীশুখ্রীষ্টেনেশ্ৱরস্য যৎ প্রেম তস্মাদ্ অস্মাকং ৱিচ্ছেদং জনযিতুং মৃত্যু র্জীৱনং ৱা দিৱ্যদূতা ৱা বলৱন্তো মুখ্যদূতা ৱা ৱর্ত্তমানো ৱা ভৱিষ্যন্ কালো ৱা উচ্চপদং ৱা নীচপদং ৱাপরং কিমপি সৃষ্টৱস্তু ");
INSERT INTO sanben_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ৱৈতেষাং কেনাপি ন শক্যমিত্যস্মিন্ দৃঢৱিশ্ৱাসো মমাস্তে| ");
INSERT INTO sanben_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","অহং কাঞ্চিদ্ কল্পিতাং কথাং ন কথযামি, খ্রীষ্টস্য সাক্ষাৎ সত্যমেৱ ব্রৱীমি পৱিত্রস্যাত্মনঃ সাক্ষান্ মদীযং মন এতৎ সাক্ষ্যং দদাতি| ");
INSERT INTO sanben_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","মমান্তরতিশযদুঃখং নিরন্তরং খেদশ্চ ");
INSERT INTO sanben_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","তস্মাদ্ অহং স্ৱজাতীযভ্রাতৃণাং নিমিত্তাৎ স্ৱযং খ্রীষ্টাচ্ছাপাক্রান্তো ভৱিতুম্ ঐচ্ছম্| ");
INSERT INTO sanben_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","যতস্ত ইস্রাযেলস্য ৱংশা অপি চ দত্তকপুত্রৎৱং তেজো নিযমো ৱ্যৱস্থাদানং মন্দিরে ভজনং প্রতিজ্ঞাঃ পিতৃপুরুষগণশ্চৈতেষু সর্ৱ্ৱেষু তেষাম্ অধিকারোঽস্তি| ");
INSERT INTO sanben_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","তৎ কেৱলং নহি কিন্তু সর্ৱ্ৱাধ্যক্ষঃ সর্ৱ্ৱদা সচ্চিদানন্দ ঈশ্ৱরো যঃ খ্রীষ্টঃ সোঽপি শারীরিকসম্বন্ধেন তেষাং ৱংশসম্ভৱঃ| ");
INSERT INTO sanben_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","ঈশ্ৱরস্য ৱাক্যং ৱিফলং জাতম্ ইতি নহি যৎকারণাদ্ ইস্রাযেলো ৱংশে যে জাতাস্তে সর্ৱ্ৱে ৱস্তুত ইস্রাযেলীযা ন ভৱন্তি| ");
INSERT INTO sanben_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","অপরম্ ইব্রাহীমো ৱংশে জাতা অপি সর্ৱ্ৱে তস্যৈৱ সন্তানা ন ভৱন্তি কিন্তু ইস্হাকো নাম্না তৱ ৱংশো ৱিখ্যাতো ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","অর্থাৎ শারীরিকসংসর্গাৎ জাতাঃ সন্তানা যাৱন্তস্তাৱন্ত এৱেশ্ৱরস্য সন্তানা ন ভৱন্তি কিন্তু প্রতিশ্রৱণাদ্ যে জাযন্তে তএৱেশ্ৱরৱংশো গণ্যতে| ");
INSERT INTO sanben_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","যতস্তৎপ্রতিশ্রুতে র্ৱাক্যমেতৎ, এতাদৃশে সমযে ঽহং পুনরাগমিষ্যামি তৎপূর্ৱ্ৱং সারাযাঃ পুত্র একো জনিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","অপরমপি ৱদামি স্ৱমনোঽভিলাষত ঈশ্ৱরেণ যন্নিরূপিতং তৎ কর্ম্মতো নহি কিন্ত্ৱাহ্ৱযিতু র্জাতমেতদ্ যথা সিদ্ধ্যতি ");
INSERT INTO sanben_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","তদর্থং রিব্কানামিকযা যোষিতা জনৈকস্মাদ্ অর্থাদ্ অস্মাকম্ ইস্হাকঃ পূর্ৱ্ৱপুরুষাদ্ গর্ভে ধৃতে তস্যাঃ সন্তানযোঃ প্রসৱাৎ পূর্ৱ্ৱং কিঞ্চ তযোঃ শুভাশুভকর্ম্মণঃ করণাৎ পূর্ৱ্ৱং ");
INSERT INTO sanben_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","তাং প্রতীদং ৱাক্যম্ উক্তং, জ্যেষ্ঠঃ কনিষ্ঠং সেৱিষ্যতে, ");
INSERT INTO sanben_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","যথা লিখিতম্ আস্তে, তথাপ্যেষাৱি ন প্রীৎৱা যাকূবি প্রীতৱান্ অহং| ");
INSERT INTO sanben_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","তর্হি ৱযং কিং ব্রূমঃ? ঈশ্ৱরঃ কিম্ অন্যাযকারী? তথা ন ভৱতু| ");
INSERT INTO sanben_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","যতঃ স স্ৱযং মূসাম্ অৱদৎ; অহং যস্মিন্ অনুগ্রহং চিকীর্ষামি তমেৱানুগৃহ্লামি, যঞ্চ দযিতুম্ ইচ্ছামি তমেৱ দযে| ");
INSERT INTO sanben_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","অতএৱেচ্ছতা যতমানেন ৱা মানৱেন তন্ন সাধ্যতে দযাকারিণেশ্ৱরেণৈৱ সাধ্যতে| ");
INSERT INTO sanben_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","ফিরৌণি শাস্ত্রে লিখতি, অহং ৎৱদ্দ্ৱারা মৎপরাক্রমং দর্শযিতুং সর্ৱ্ৱপৃথিৱ্যাং নিজনাম প্রকাশযিতুঞ্চ ৎৱাং স্থাপিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","অতঃ স যম্ অনুগ্রহীতুম্ ইচ্ছতি তমেৱানুগৃহ্লাতি, যঞ্চ নিগ্রহীতুম্ ইচ্ছতি তং নিগৃহ্লাতি| ");
INSERT INTO sanben_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","যদি ৱদসি তর্হি স দোষং কুতো গৃহ্লাতি? তদীযেচ্ছাযাঃ প্রতিবন্ধকৎৱং কর্ত্তং কস্য সামর্থ্যং ৱিদ্যতে? ");
INSERT INTO sanben_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","হে ঈশ্ৱরস্য প্রতিপক্ষ মর্ত্য ৎৱং কঃ? এতাদৃশং মাং কুতঃ সৃষ্টৱান্? ইতি কথাং সৃষ্টৱস্তু স্রষ্ট্রে কিং কথযিষ্যতি? ");
INSERT INTO sanben_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","একস্মান্ মৃৎপিণ্ডাদ্ উৎকৃষ্টাপকৃষ্টৌ দ্ৱিৱিধৌ কলশৌ কর্ত্তুং কিং কুলালস্য সামর্থ্যং নাস্তি? ");
INSERT INTO sanben_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","ঈশ্ৱরঃ কোপং প্রকাশযিতুং নিজশক্তিং জ্ঞাপযিতুঞ্চেচ্ছন্ যদি ৱিনাশস্য যোগ্যানি ক্রোধভাজনানি প্রতি বহুকালং দীর্ঘসহিষ্ণুতাম্ আশ্রযতি; ");
INSERT INTO sanben_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","অপরঞ্চ ৱিভৱপ্রাপ্ত্যর্থং পূর্ৱ্ৱং নিযুক্তান্যনুগ্রহপাত্রাণি প্রতি নিজৱিভৱস্য বাহুল্যং প্রকাশযিতুং কেৱলযিহূদিনাং নহি ভিন্নদেশিনামপি মধ্যাদ্ ");
INSERT INTO sanben_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","অস্মানিৱ তান্যাহ্ৱযতি তত্র তৱ কিং? ");
INSERT INTO sanben_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","হোশেযগ্রন্থে যথা লিখিতম্ আস্তে, যো লোকো মম নাসীৎ তং ৱদিষ্যামি মদীযকং| যা জাতি র্মেঽপ্রিযা চাসীৎ তাং ৱদিষ্যাম্যহং প্রিযাং| ");
INSERT INTO sanben_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","যূযং মদীযলোকা ন যত্রেতি ৱাক্যমৌচ্যত| অমরেশস্য সন্তানা ইতি খ্যাস্যন্তি তত্র তে| ");
INSERT INTO sanben_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","ইস্রাযেলীযলোকেষু যিশাযিযোঽপি ৱাচমেতাং প্রাচারযৎ, ইস্রাযেলীযৱংশানাং যা সংখ্যা সা তু নিশ্চিতং| সমুদ্রসিকতাসংখ্যাসমানা যদি জাযতে| তথাপি কেৱলং লোকৈরল্পৈস্ত্রাণং ৱ্রজিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","যতো ন্যাযেন স্ৱং কর্ম্ম পরেশঃ সাধযিষ্যতি| দেশে সএৱ সংক্ষেপান্নিজং কর্ম্ম করিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","যিশাযিযোঽপরমপি কথযামাস, সৈন্যাধ্যক্ষপরেশেন চেৎ কিঞ্চিন্নোদশিষ্যত| তদা ৱযং সিদোমেৱাভৱিষ্যাম ৱিনিশ্চিতং| যদ্ৱা ৱযম্ অমোরাযা অগমিষ্যাম তুল্যতাং| ");
INSERT INTO sanben_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","তর্হি ৱযং কিং ৱক্ষ্যামঃ? ইতরদেশীযা লোকা অপি পুণ্যার্থম্ অযতমানা ৱিশ্ৱাসেন পুণ্যম্ অলভন্ত; ");
INSERT INTO sanben_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","কিন্ত্ৱিস্রাযেল্লোকা ৱ্যৱস্থাপালনেন পুণ্যার্থং যতমানাস্তন্ নালভন্ত| ");
INSERT INTO sanben_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","তস্য কিং কারণং? তে ৱিশ্ৱাসেন নহি কিন্তু ৱ্যৱস্থাযাঃ ক্রিযযা চেষ্টিৎৱা তস্মিন্ স্খলনজনকে পাষাণে পাদস্খলনং প্রাপ্তাঃ| ");
INSERT INTO sanben_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","লিখিতং যাদৃশম্ আস্তে, পশ্য পাদস্খলার্থং হি সীযোনি প্রস্তরন্তথা| বাধাকারঞ্চ পাষাণং পরিস্থাপিতৱানহম্| ৱিশ্ৱসিষ্যতি যস্তত্র স জনো ন ত্রপিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","হে ভ্রাতর ইস্রাযেলীযলোকা যৎ পরিত্রাণং প্রাপ্নুৱন্তি তদহং মনসাভিলষন্ ঈশ্ৱরস্য সমীপে প্রার্থযে| ");
INSERT INTO sanben_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","যত ঈশ্ৱরে তেষাং চেষ্টা ৱিদ্যত ইত্যত্রাহং সাক্ষ্যস্মি; কিন্তু তেষাং সা চেষ্টা সজ্ঞানা নহি, ");
INSERT INTO sanben_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","যতস্ত ঈশ্ৱরদত্তং পুণ্যম্ অৱিজ্ঞায স্ৱকৃতপুণ্যং স্থাপযিতুম্ চেষ্টমানা ঈশ্ৱরদত্তস্য পুণ্যস্য নিঘ্নৎৱং ন স্ৱীকুর্ৱ্ৱন্তি| ");
INSERT INTO sanben_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","খ্রীষ্ট একৈকৱিশ্ৱাসিজনায পুণ্যং দাতুং ৱ্যৱস্থাযাঃ ফলস্ৱরূপো ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","ৱ্যৱস্থাপালনেন যৎ পুণ্যং তৎ মূসা ৱর্ণযামাস, যথা, যো জনস্তাং পালযিষ্যতি স তদ্দ্ৱারা জীৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","কিন্তু প্রত্যযেন যৎ পুণ্যং তদ্ এতাদৃশং ৱাক্যং ৱদতি, কঃ স্ৱর্গম্ আরুহ্য খ্রীষ্টম্ অৱরোহযিষ্যতি? ");
INSERT INTO sanben_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","কো ৱা প্রেতলোকম্ অৱরুহ্য খ্রীষ্টং মৃতগণমধ্যাদ্ আনেষ্যতীতি ৱাক্ মনসি ৎৱযা ন গদিতৱ্যা| ");
INSERT INTO sanben_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","তর্হি কিং ব্রৱীতি? তদ্ ৱাক্যং তৱ সমীপস্থম্ অর্থাৎ তৱ ৱদনে মনসি চাস্তে, তচ্চ ৱাক্যম্ অস্মাভিঃ প্রচার্য্যমাণং ৱিশ্ৱাসস্য ৱাক্যমেৱ| ");
INSERT INTO sanben_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","ৱস্তুতঃ প্রভুং যীশুং যদি ৱদনেন স্ৱীকরোষি, তথেশ্ৱরস্তং শ্মশানাদ্ উদস্থাপযদ্ ইতি যদ্যন্তঃকরণেন ৱিশ্ৱসিষি তর্হি পরিত্রাণং লপ্স্যসে| ");
INSERT INTO sanben_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","যস্মাৎ পুণ্যপ্রাপ্ত্যর্থম্ অন্তঃকরণেন ৱিশ্ৱসিতৱ্যং পরিত্রাণার্থঞ্চ ৱদনেন স্ৱীকর্ত্তৱ্যং| ");
INSERT INTO sanben_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","শাস্ত্রে যাদৃশং লিখতি ৱিশ্ৱসিষ্যতি যস্তত্র স জনো ন ত্রপিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","ইত্যত্র যিহূদিনি তদন্যলোকে চ কোপি ৱিশেষো নাস্তি যস্মাদ্ যঃ সর্ৱ্ৱেষাম্ অদ্ৱিতীযঃ প্রভুঃ স নিজযাচকান সর্ৱ্ৱান্ প্রতি ৱদান্যো ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","যতঃ, যঃ কশ্চিৎ পরমেশস্য নাম্না হি প্রার্থযিষ্যতে| স এৱ মনুজো নূনং পরিত্রাতো ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","যং যে জনা ন প্রত্যাযন্ তে তমুদ্দিশ্য কথং প্রার্থযিষ্যন্তে? যে ৱা যস্যাখ্যানং কদাপি ন শ্রুতৱন্তস্তে তং কথং প্রত্যেষ্যন্তি? অপরং যদি প্রচারযিতারো ন তিষ্ঠন্তি তদা কথং তে শ্রোষ্যন্তি? ");
INSERT INTO sanben_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","যদি ৱা প্রেরিতা ন ভৱন্তি তদা কথং প্রচারযিষ্যন্তি? যাদৃশং লিখিতম্ আস্তে, যথা, মাঙ্গলিকং সুসংৱাদং দদত্যানীয যে নরাঃ| প্রচারযন্তি শান্তেশ্চ সুসংৱাদং জনাস্তু যে| তেষাং চরণপদ্মানি কীদৃক্ শোভান্ৱিতানি হি| ");
INSERT INTO sanben_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","কিন্তু তে সর্ৱ্ৱে তং সুসংৱাদং ন গৃহীতৱন্তঃ| যিশাযিযো যথা লিখিতৱান্| অস্মৎপ্রচারিতে ৱাক্যে ৱিশ্ৱাসমকরোদ্ধি কঃ| ");
INSERT INTO sanben_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","অতএৱ শ্রৱণাদ্ ৱিশ্ৱাস ঐশ্ৱরৱাক্যপ্রচারাৎ শ্রৱণঞ্চ ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","তর্হ্যহং ব্রৱীমি তৈঃ কিং নাশ্রাৱি? অৱশ্যম্ অশ্রাৱি, যস্মাৎ তেষাং শব্দো মহীং ৱ্যাপ্নোদ্ ৱাক্যঞ্চ নিখিলং জগৎ| ");
INSERT INTO sanben_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","অপরমপি ৱদামি, ইস্রাযেলীযলোকাঃ কিম্ এতাং কথাং ন বুধ্যন্তে? প্রথমতো মূসা ইদং ৱাক্যং প্রোৱাচ, অহমুত্তাপযিষ্যে তান্ অগণ্যমানৱৈরপি| ক্লেক্ষ্যামি জাতিম্ এতাঞ্চ প্রোন্মত্তভিন্নজাতিভিঃ| ");
INSERT INTO sanben_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","অপরঞ্চ যিশাযিযোঽতিশযাক্ষোভেণ কথযামাস, যথা, অধি মাং যৈস্তু নাচেষ্টি সম্প্রাপ্তস্তৈ র্জনৈরহং| অধি মাং যৈ র্ন সম্পৃষ্টং ৱিজ্ঞাতস্তৈ র্জনৈরহং|| ");
INSERT INTO sanben_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","কিন্ত্ৱিস্রাযেলীযলোকান্ অধি কথযাঞ্চকার, যৈরাজ্ঞালঙ্ঘিভি র্লোকৈ র্ৱিরুদ্ধং ৱাক্যমুচ্যতে| তান্ প্রত্যেৱ দিনং কৃৎস্নং হস্তৌ ৱিস্তারযাম্যহং|| ");
INSERT INTO sanben_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","ঈশ্ৱরেণ স্ৱীকীযলোকা অপসারিতা অহং কিম্ ঈদৃশং ৱাক্যং ব্রৱীমি? তন্ন ভৱতু যতোঽহমপি বিন্যামীনগোত্রীয ইব্রাহীমৱংশীয ইস্রাযেলীযলোকোঽস্মি| ");
INSERT INTO sanben_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","ঈশ্ৱরেণ পূর্ৱ্ৱং যে প্রদৃষ্টাস্তে স্ৱকীযলোকা অপসারিতা ইতি নহি| অপরম্ এলিযোপাখ্যানে শাস্ত্রে যল্লিখিতম্ আস্তে তদ্ যূযং কিং ন জানীথ? ");
INSERT INTO sanben_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","হে পরমেশ্ৱর লোকাস্ত্ৱদীযাঃ সর্ৱ্ৱা যজ্ঞৱেদীরভঞ্জন্ তথা তৱ ভৱিষ্যদ্ৱাদিনঃ সর্ৱ্ৱান্ অঘ্নন্ কেৱল একোঽহম্ অৱশিষ্ট আসে তে মমাপি প্রাণান্ নাশযিতুং চেষ্টনতে, এতাং কথাম্ ইস্রাযেলীযলোকানাং ৱিরুদ্ধম্ এলিয ঈশ্ৱরায নিৱেদযামাস| ");
INSERT INTO sanben_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","ততস্তং প্রতীশ্ৱরস্যোত্তরং কিং জাতং? বাল্নাম্নো দেৱস্য সাক্ষাৎ যৈ র্জানূনি ন পাতিতানি তাদৃশাঃ সপ্ত সহস্রাণি লোকা অৱশেষিতা মযা| ");
INSERT INTO sanben_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","তদ্ৱদ্ এতস্মিন্ ৱর্ত্তমানকালেঽপি অনুগ্রহেণাভিরুচিতাস্তেষাম্ অৱশিষ্টাঃ কতিপযা লোকাঃ সন্তি| ");
INSERT INTO sanben_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","অতএৱ তদ্ যদ্যনুগ্রহেণ ভৱতি তর্হি ক্রিযযা ন ভৱতি নো চেদ্ অনুগ্রহোঽননুগ্রহ এৱ, যদি ৱা ক্রিযযা ভৱতি তর্হ্যনুগ্রহেণ ন ভৱতি নো চেৎ ক্রিযা ক্রিযৈৱ ন ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","তর্হি কিং? ইস্রাযেলীযলোকা যদ্ অমৃগযন্ত তন্ন প্রাপুঃ| কিন্ত্ৱভিরুচিতলোকাস্তৎ প্রাপুস্তদন্যে সর্ৱ্ৱ অন্ধীভূতাঃ| ");
INSERT INTO sanben_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","যথা লিখিতম্ আস্তে, ঘোরনিদ্রালুতাভাৱং দৃষ্টিহীনে চ লোচনে| কর্ণৌ শ্রুতিৱিহীনৌ চ প্রদদৌ তেভ্য ঈশ্ৱরঃ|| ");
INSERT INTO sanben_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","এতেস্মিন্ দাযূদপি লিখিতৱান্ যথা, অতো ভুক্ত্যাসনং তেষাম্ উন্মাথৱদ্ ভৱিষ্যতি| ৱা ৱংশযন্ত্রৱদ্ বাধা দণ্ডৱদ্ ৱা ভৱিষ্যতি|| ");
INSERT INTO sanben_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","ভৱিষ্যন্তি তথান্ধাস্তে নেত্রৈঃ পশ্যন্তি নো যথা| ৱেপথুঃ কটিদেশস্য তেষাং নিত্যং ভৱিষ্যতি|| ");
INSERT INTO sanben_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","পতনার্থং তে স্খলিতৱন্ত ইতি ৱাচং কিমহং ৱদামি? তন্ন ভৱতু কিন্তু তান্ উদ্যোগিনঃ কর্ত্তুং তেষাং পতনাদ্ ইতরদেশীযলোকৈঃ পরিত্রাণং প্রাপ্তং| ");
INSERT INTO sanben_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","তেষাং পতনং যদি জগতো লোকানাং লাভজনকম্ অভৱৎ তেষাং হ্রাসোঽপি যদি ভিন্নদেশিনাং লাভজনকোঽভৱৎ তর্হি তেষাং ৱৃদ্ধিঃ কতি লাভজনিকা ভৱিষ্যতি? ");
INSERT INTO sanben_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","অতো হে অন্যদেশিনো যুষ্মান্ সম্বোধ্য কথযামি নিজানাং জ্ঞাতিবন্ধূনাং মনঃসূদ্যোগং জনযন্ তেষাং মধ্যে কিযতাং লোকানাং যথা পরিত্রাণং সাধযামি ");
INSERT INTO sanben_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","তন্নিমিত্তম্ অন্যদেশিনাং নিকটে প্রেরিতঃ সন্ অহং স্ৱপদস্য মহিমানং প্রকাশযামি| ");
INSERT INTO sanben_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","তেষাং নিগ্রহেণ যদীশ্ৱরেণ সহ জগতো জনানাং মেলনং জাতং তর্হি তেষাম্ অনুগৃহীতৎৱং মৃতদেহে যথা জীৱনলাভস্তদ্ৱৎ কিং ন ভৱিষ্যতি? ");
INSERT INTO sanben_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","অপরং প্রথমজাতং ফলং যদি পৱিত্রং ভৱতি তর্হি সর্ৱ্ৱমেৱ ফলং পৱিত্রং ভৱিষ্যতি; তথা মূলং যদি পৱিত্রং ভৱতি তর্হি শাখা অপি তথৈৱ ভৱিষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","কিযতীনাং শাখানাং ছেদনে কৃতে ৎৱং ৱন্যজিতৱৃক্ষস্য শাখা ভূৎৱা যদি তচ্ছাখানাং স্থানে রোপিতা সতি জিতৱৃক্ষীযমূলস্য রসং ভুংক্ষে, ");
INSERT INTO sanben_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","তর্হি তাসাং ভিন্নশাখানাং ৱিরুদ্ধং মাং গর্ৱ্ৱীঃ; যদি গর্ৱ্ৱসি তর্হি ৎৱং মূলং যন্ন ধারযসি কিন্তু মূলং ৎৱাং ধারযতীতি সংস্মর| ");
INSERT INTO sanben_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","অপরঞ্চ যদি ৱদসি মাং রোপযিতুং তাঃ শাখা ৱিভন্না অভৱন্; ");
INSERT INTO sanben_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","ভদ্রম্, অপ্রত্যযকারণাৎ তে ৱিভিন্না জাতাস্তথা ৱিশ্ৱাসকারণাৎ ৎৱং রোপিতো জাতস্তস্মাদ্ অহঙ্কারম্ অকৃৎৱা সসাধ্ৱসো ভৱ| ");
INSERT INTO sanben_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","যত ঈশ্ৱরো যদি স্ৱাভাৱিকীঃ শাখা ন রক্ষতি তর্হি সাৱধানো ভৱ চেৎ ৎৱামপি ন স্থাপযতি| ");
INSERT INTO sanben_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","ইত্যত্রেশ্ৱরস্য যাদৃশী কৃপা তাদৃশং ভযানকৎৱমপি ৎৱযা দৃশ্যতাং; যে পতিতাস্তান্ প্রতি তস্য ভযানকৎৱং দৃশ্যতাং, ৎৱঞ্চ যদি তৎকৃপাশ্রিতস্তিষ্ঠসি তর্হি ৎৱাং প্রতি কৃপা দ্রক্ষ্যতে; নো চেৎ ৎৱমপি তদ্ৱৎ ছিন্নো ভৱিষ্যসি| ");
INSERT INTO sanben_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","অপরঞ্চ তে যদ্যপ্রত্যযে ন তিষ্ঠন্তি তর্হি পুনরপি রোপযিষ্যন্তে যস্মাৎ তান্ পুনরপি রোপযিতুম্ ইশ্ৱরস্য শক্তিরাস্তে| ");
INSERT INTO sanben_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","ৱন্যজিতৱৃক্ষস্য শাখা সন্ ৎৱং যদি ততশ্ছিন্নো রীতিৱ্যত্যযেনোত্তমজিতৱৃক্ষে রোेेপিতোঽভৱস্তর্হি তস্য ৱৃক্ষস্য স্ৱীযা যাঃ শাখাস্তাঃ কিং পুনঃ স্ৱৱৃক্ষে সংলগিতুং ন শক্নুৱন্তি? ");
INSERT INTO sanben_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","হে ভ্রাতরো যুষ্মাকম্ আত্মাভিমানো যন্ন জাযতে তদর্থং মমেদৃশী ৱাঞ্ছা ভৱতি যূযং এতন্নিগূঢতত্ত্ৱম্ অজানন্তো যন্ন তিষ্ঠথ; ৱস্তুতো যাৱৎকালং সম্পূর্ণরূপেণ ভিন্নদেশিনাং সংগ্রহো ন ভৱিষ্যতি তাৱৎকালম্ অংশৎৱেন ইস্রাযেলীযলোকানাম্ অন্ধতা স্থাস্যতি; ");
INSERT INTO sanben_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","পশ্চাৎ তে সর্ৱ্ৱে পরিত্রাস্যন্তে; এতাদৃশং লিখিতমপ্যাস্তে, আগমিষ্যতি সীযোনাদ্ একো যস্ত্রাণদাযকঃ| অধর্ম্মং যাকুবো ৱংশাৎ স তু দূরীকরিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","তথা দূরীকরিষ্যামি তেষাং পাপান্যহং যদা| তদা তৈরেৱ সার্দ্ধং মে নিযমোঽযং ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","সুসংৱাদাৎ তে যুষ্মাকং ৱিপক্ষা অভৱন্ কিন্ত্ৱভিরুচিতৎৱাৎ তে পিতৃলোকানাং কৃতে প্রিযপাত্রাণি ভৱন্তি| ");
INSERT INTO sanben_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","যত ঈশ্ৱরস্য দানাদ্ আহ্ৱানাঞ্চ পশ্চাত্তাপো ন ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","অতএৱ পূর্ৱ্ৱম্ ঈশ্ৱরেঽৱিশ্ৱাসিনঃ সন্তোঽপি যূযং যদ্ৱৎ সম্প্রতি তেষাম্ অৱিশ্ৱাসকারণাদ্ ঈশ্ৱরস্য কৃপাপাত্রাণি জাতাস্তদ্ৱদ্ ");
INSERT INTO sanben_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","ইদানীং তেঽৱিশ্ৱাসিনঃ সন্তি কিন্তু যুষ্মাভি র্লব্ধকৃপাকারণাৎ তৈরপি কৃপা লপ্স্যতে| ");
INSERT INTO sanben_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","ঈশ্ৱরঃ সর্ৱ্ৱান্ প্রতি কৃপাং প্রকাশযিতুং সর্ৱ্ৱান্ অৱিশ্ৱাসিৎৱেন গণযতি| ");
INSERT INTO sanben_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","অহো ঈশ্ৱরস্য জ্ঞানবুদ্ধিরূপযো র্ধনযোঃ কীদৃক্ প্রাচুর্য্যং| তস্য রাজশাসনস্য তত্ত্ৱং কীদৃগ্ অপ্রাপ্যং| তস্য মার্গাশ্চ কীদৃগ্ অনুপলক্ষ্যাঃ| ");
INSERT INTO sanben_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","পরমেশ্ৱরস্য সঙ্কল্পং কো জ্ঞাতৱান্? তস্য মন্ত্রী ৱা কোঽভৱৎ? ");
INSERT INTO sanben_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","কো ৱা তস্যোপকারী ভৃৎৱা তৎকৃতে তেন প্রত্যুপকর্ত্তৱ্যঃ? ");
INSERT INTO sanben_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","যতো ৱস্তুমাত্রমেৱ তস্মাৎ তেন তস্মৈ চাভৱৎ তদীযো মহিমা সর্ৱ্ৱদা প্রকাশিতো ভৱতু| ইতি| ");
INSERT INTO sanben_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","হে ভ্রাতর ঈশ্ৱরস্য কৃপযাহং যুষ্মান্ ৱিনযে যূযং স্ৱং স্ৱং শরীরং সজীৱং পৱিত্রং গ্রাহ্যং বলিম্ ঈশ্ৱরমুদ্দিশ্য সমুৎসৃজত, এষা সেৱা যুষ্মাকং যোগ্যা| ");
INSERT INTO sanben_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","অপরং যূযং সাংসারিকা ইৱ মাচরত, কিন্তু স্ৱং স্ৱং স্ৱভাৱং পরাৱর্ত্য নূতনাচারিণো ভৱত, তত ঈশ্ৱরস্য নিদেশঃ কীদৃগ্ উত্তমো গ্রহণীযঃ সম্পূর্ণশ্চেতি যুষ্মাভিরনুভাৱিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","কশ্চিদপি জনো যোগ্যৎৱাদধিকং স্ৱং ন মন্যতাং কিন্তু ঈশ্ৱরো যস্মৈ প্রত্যযস্য যৎপরিমাণম্ অদদাৎ স তদনুসারতো যোগ্যরূপং স্ৱং মনুতাম্, ঈশ্ৱরাদ্ অনুগ্রহং প্রাপ্তঃ সন্ যুষ্মাকম্ একৈকং জনম্ ইত্যাজ্ঞাপযামি| ");
INSERT INTO sanben_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","যতো যদ্ৱদস্মাকম্ একস্মিন্ শরীরে বহূন্যঙ্গানি সন্তি কিন্তু সর্ৱ্ৱেষামঙ্গানাং কার্য্যং সমানং নহি; ");
INSERT INTO sanben_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","তদ্ৱদস্মাকং বহুৎৱেঽপি সর্ৱ্ৱে ৱযং খ্রীষ্টে একশরীরাঃ পরস্পরম্ অঙ্গপ্রত্যঙ্গৎৱেন ভৱামঃ| ");
INSERT INTO sanben_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","অস্মাদ্ ঈশ্ৱরানুগ্রহেণ ৱিশেষং ৱিশেষং দানম্ অস্মাসু প্রাপ্তেষু সৎসু কোপি যদি ভৱিষ্যদ্ৱাক্যং ৱদতি তর্হি প্রত্যযস্য পরিমাণানুসারতঃ স তদ্ ৱদতু; ");
INSERT INTO sanben_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","যদ্ৱা যদি কশ্চিৎ সেৱনকারী ভৱতি তর্হি স তৎসেৱনং করোতু; অথৱা যদি কশ্চিদ্ অধ্যাপযিতা ভৱতি তর্হি সোঽধ্যাপযতু; ");
INSERT INTO sanben_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","তথা য উপদেষ্টা ভৱতি স উপদিশতু যশ্চ দাতা স সরলতযা দদাতু যস্ত্ৱধিপতিঃ স যত্নেনাধিপতিৎৱং করোতু যশ্চ দযালুঃ স হৃষ্টমনসা দযতাম্| ");
INSERT INTO sanben_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","অপরঞ্চ যুষ্মাকং প্রেম কাপট্যৱর্জিতং ভৱতু যদ্ অভদ্রং তদ্ ঋতীযধ্ৱং যচ্চ ভদ্রং তস্মিন্ অনুরজ্যধ্ৱম্| ");
INSERT INTO sanben_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","অপরং ভ্রাতৃৎৱপ্রেম্না পরস্পরং প্রীযধ্ৱং সমাদরাদ্ একোঽপরজনং শ্রেষ্ঠং জানীধ্ৱম্| ");
INSERT INTO sanben_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","তথা কার্য্যে নিরালস্যা মনসি চ সোদ্যোগাঃ সন্তঃ প্রভুং সেৱধ্ৱম্| ");
INSERT INTO sanben_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","অপরং প্রত্যাশাযাম্ আনন্দিতা দুঃখসমযে চ ধৈর্য্যযুক্তা ভৱত; প্রার্থনাযাং সততং প্রৱর্ত্তধ্ৱং| ");
INSERT INTO sanben_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","পৱিত্রাণাং দীনতাং দূরীকুরুধ্ৱম্ অতিথিসেৱাযাম্ অনুরজ্যধ্ৱম্| ");
INSERT INTO sanben_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","যে জনা যুষ্মান্ তাডযন্তি তান্ আশিষং ৱদত শাপম্ অদত্ত্ৱা দদ্ধ্ৱমাশিষম্| ");
INSERT INTO sanben_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","যে জনা আনন্দন্তি তৈঃ সার্দ্ধম্ আনন্দত যে চ রুদন্তি তৈঃ সহ রুদিত| ");
INSERT INTO sanben_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","অপরঞ্চ যুষ্মাকং মনসাং পরস্পরম্ একোভাৱো ভৱতু; অপরম্ উচ্চপদম্ অনাকাঙ্ক্ষ্য নীচলোকৈঃ সহাপি মার্দৱম্ আচরত; স্ৱান্ জ্ঞানিনো ন মন্যধ্ৱং| ");
INSERT INTO sanben_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","পরস্মাদ্ অপকারং প্রাপ্যাপি পরং নাপকুরুত| সর্ৱ্ৱেষাং দৃষ্টিতো যৎ কর্ম্মোত্তমং তদেৱ কুরুত| ");
INSERT INTO sanben_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","যদি ভৱিতুং শক্যতে তর্হি যথাশক্তি সর্ৱ্ৱলোকৈঃ সহ নির্ৱ্ৱিরোধেন কালং যাপযত| ");
INSERT INTO sanben_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","হে প্রিযবন্ধৱঃ, কস্মৈচিদ্ অপকারস্য সমুচিতং দণ্ডং স্ৱযং ন দদ্ধ্ৱং, কিন্ত্ৱীশ্ৱরীযক্রোধায স্থানং দত্ত যতো লিখিতমাস্তে পরমেশ্ৱরঃ কথযতি, দানং ফলস্য মৎকর্ম্ম সূচিতং প্রদদাম্যহং| ");
INSERT INTO sanben_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","ইতিকারণাদ্ রিপু র্যদি ক্ষুধার্ত্তস্তে তর্হি তং ৎৱং প্রভোজয| তথা যদি তৃষার্ত্তঃ স্যাৎ তর্হি তং পরিপাযয| তেন ৎৱং মস্তকে তস্য জ্ৱলদগ্নিং নিধাস্যসি| ");
INSERT INTO sanben_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","কুক্রিযযা পরাজিতা ন সন্ত উত্তমক্রিযযা কুক্রিযাং পরাজযত| ");
INSERT INTO sanben_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","যুষ্মাকম্ একৈকজনঃ শাসনপদস্য নিঘ্নো ভৱতু যতো যানি শাসনপদানি সন্তি তানি সর্ৱ্ৱাণীশ্ৱরেণ স্থাপিতানি; ঈশ্ৱরং ৱিনা পদস্থাপনং ন ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","ইতি হেতোঃ শাসনপদস্য যৎ প্রাতিকূল্যং তদ্ ঈশ্ৱরীযনিরূপণস্য প্রাতিকূল্যমেৱ; অপরং যে প্রাতিকূল্যম্ আচরন্তি তে স্ৱেষাং সমুচিতং দণ্ডং স্ৱযমেৱ ঘটযন্তে| ");
INSERT INTO sanben_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","শাস্তা সদাচারিণাং ভযপ্রদো নহি দুরাচারিণামেৱ ভযপ্রদো ভৱতি; ৎৱং কিং তস্মান্ নির্ভযো ভৱিতুম্ ইচ্ছসি? তর্হি সৎকর্ম্মাচর, তস্মাদ্ যশো লপ্স্যসে, ");
INSERT INTO sanben_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","যতস্তৱ সদাচরণায স ঈশ্ৱরস্য ভৃত্যোঽস্তি| কিন্তু যদি কুকর্ম্মাচরসি তর্হি ৎৱং শঙ্কস্ৱ যতঃ স নিরর্থকং খঙ্গং ন ধারযতি; কুকর্ম্মাচারিণং সমুচিতং দণ্ডযিতুম্ স ঈশ্ৱরস্য দণ্ডদভৃত্য এৱ| ");
INSERT INTO sanben_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","অতএৱ কেৱলদণ্ডভযান্নহি কিন্তু সদসদ্বোধাদপি তস্য ৱশ্যেন ভৱিতৱ্যং| ");
INSERT INTO sanben_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","এতস্মাদ্ যুষ্মাকং রাজকরদানমপ্যুচিতং যস্মাদ্ যে করং গৃহ্লন্তি ত ঈশ্ৱরস্য কিঙ্করা ভূৎৱা সততম্ এতস্মিন্ কর্ম্মণি নিৱিষ্টাস্তিষ্ঠন্তি| ");
INSERT INTO sanben_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","অস্মাৎ করগ্রাহিণে করং দত্ত, তথা শুল্কগ্রাহিণে শুল্কং দত্ত, অপরং যস্মাদ্ ভেতৱ্যং তস্মাদ্ বিভীত, যশ্চ সমাদরণীযস্তং সমাদ্রিযধ্ৱম্; ইত্থং যস্য যৎ প্রাপ্যং তৎ তস্মৈ দত্ত| ");
INSERT INTO sanben_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","যুষ্মাকং পরস্পরং প্রেম ৱিনা ঽন্যৎ কিমপি দেযম্ ঋণং ন ভৱতু, যতো যঃ পরস্মিন্ প্রেম করোতি তেন ৱ্যৱস্থা সিধ্যতি| ");
INSERT INTO sanben_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","ৱস্তুতঃ পরদারান্ মা গচ্ছ, নরহত্যাং মা কার্ষীঃ, চৈর্য্যং মা কার্ষীঃ, মিথ্যাসাক্ষ্যং মা দেহি, লোভং মা কার্ষীঃ, এতাঃ সর্ৱ্ৱা আজ্ঞা এতাভ্যো ভিন্না যা কাচিদ্ আজ্ঞাস্তি সাপি স্ৱসমীপৱাসিনি স্ৱৱৎ প্রেম কুর্ৱ্ৱিত্যনেন ৱচনেন ৱেদিতা| ");
INSERT INTO sanben_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","যতঃ প্রেম সমীপৱাসিনোঽশুভং ন জনযতি তস্মাৎ প্রেম্না সর্ৱ্ৱা ৱ্যৱস্থা পাল্যতে| ");
INSERT INTO sanben_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","প্রত্যযীভৱনকালেঽস্মাকং পরিত্রাণস্য সামীপ্যাদ্ ইদানীং তস্য সামীপ্যম্ অৱ্যৱহিতং; অতঃ সমযং ৱিৱিচ্যাস্মাভিঃ সাম্প্রতম্ অৱশ্যমেৱ নিদ্রাতো জাগর্ত্তৱ্যং| ");
INSERT INTO sanben_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","বহুতরা যামিনী গতা প্রভাতং সন্নিধিং প্রাপ্তং তস্মাৎ তামসীযাঃ ক্রিযাঃ পরিত্যজ্যাস্মাভি র্ৱাসরীযা সজ্জা পরিধাতৱ্যা| ");
INSERT INTO sanben_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","অতো হেতো র্ৱযং দিৱা ৱিহিতং সদাচরণম্ আচরিষ্যামঃ| রঙ্গরসো মত্তৎৱং লম্পটৎৱং কামুকৎৱং ৱিৱাদ ঈর্ষ্যা চৈতানি পরিত্যক্ষ্যামঃ| ");
INSERT INTO sanben_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","যূযং প্রভুযীশুখ্রীষ্টরূপং পরিচ্ছদং পরিধদ্ধ্ৱং সুখাভিলাষপূরণায শারীরিকাচরণং মাচরত| ");
INSERT INTO sanben_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","যো জনোঽদৃঢৱিশ্ৱাসস্তং যুষ্মাকং সঙ্গিনং কুরুত কিন্তু সন্দেহৱিচারার্থং নহি| ");
INSERT INTO sanben_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","যতো নিষিদ্ধং কিমপি খাদ্যদ্রৱ্যং নাস্তি, কস্যচিজ্জনস্য প্রত্যয এতাদৃশো ৱিদ্যতে কিন্ত্ৱদৃঢৱিশ্ৱাসঃ কশ্চিদপরো জনঃ কেৱলং শাকং ভুঙ্ক্তং| ");
INSERT INTO sanben_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","তর্হি যো জনঃ সাধারণং দ্রৱ্যং ভুঙ্ক্তে স ৱিশেষদ্রৱ্যভোক্তারং নাৱজানীযাৎ তথা ৱিশেষদ্রৱ্যভোক্তাপি সাধারণদ্রৱ্যভোক্তারং দোষিণং ন কুর্য্যাৎ, যস্মাদ্ ঈশ্ৱরস্তম্ অগৃহ্লাৎ| ");
INSERT INTO sanben_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","হে পরদাসস্য দূষযিতস্ত্ৱং কঃ? নিজপ্রভোঃ সমীপে তেন পদস্থেন পদচ্যুতেন ৱা ভৱিতৱ্যং স চ পদস্থ এৱ ভৱিষ্যতি যত ঈশ্ৱরস্তং পদস্থং কর্ত্তুং শক্নোতি| ");
INSERT INTO sanben_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","অপরঞ্চ কশ্চিজ্জনো দিনাদ্ দিনং ৱিশেষং মন্যতে কশ্চিত্তুु সর্ৱ্ৱাণি দিনানি সমানানি মন্যতে, একৈকো জনঃ স্ৱীযমনসি ৱিৱিচ্য নিশ্চিনোতু| ");
INSERT INTO sanben_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","যো জনঃ কিঞ্চন দিনং ৱিশেষং মন্যতে স প্রভুভক্ত্যা তন্ মন্যতে, যশ্চ জনঃ কিমপি দিনং ৱিশেষং ন মন্যতে সোঽপি প্রভুভক্ত্যা তন্ন মন্যতে; অপরঞ্চ যঃ সর্ৱ্ৱাণি ভক্ষ্যদ্রৱ্যাণি ভুঙ্ক্তে স প্রভুভক্তযা তানি ভুঙ্ক্তে যতঃ স ঈশ্ৱরং ধন্যং ৱক্তি, যশ্চ ন ভুঙ্ক্তে সোঽপি প্রভুভক্ত্যৈৱ ন ভুঞ্জান ঈশ্ৱরং ধন্যং ব্রূতে| ");
INSERT INTO sanben_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","অপরম্ অস্মাকং কশ্চিৎ নিজনিমিত্তং প্রাণান্ ধারযতি নিজনিমিত্তং ম্রিযতে ৱা তন্ন; ");
INSERT INTO sanben_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","কিন্তু যদি ৱযং প্রাণান্ ধারযামস্তর্হি প্রভুনিমিত্তং ধারযামঃ, যদি চ প্রাণান্ ত্যজামস্তর্হ্যপি প্রভুনিমিত্তং ত্যজামঃ, অতএৱ জীৱনে মরণে ৱা ৱযং প্রভোরেৱাস্মহে| ");
INSERT INTO sanben_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","যতো জীৱন্তো মৃতাশ্চেত্যুভযেষাং লোকানাং প্রভুৎৱপ্রাপ্ত্যর্থং খ্রীষ্টো মৃত উত্থিতঃ পুনর্জীৱিতশ্চ| ");
INSERT INTO sanben_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","কিন্তু ৎৱং নিজং ভ্রাতরং কুতো দূষযসি? তথা ৎৱং নিজং ভ্রাতরং কুতস্তুচ্ছং জানাসি? খ্রীষ্টস্য ৱিচারসিংহাসনস্য সম্মুখে সর্ৱ্ৱৈরস্মাভিরুপস্থাতৱ্যং; ");
INSERT INTO sanben_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","যাদৃশং লিখিতম্ আস্তে, পরেশঃ শপথং কুর্ৱ্ৱন্ ৱাক্যমেতৎ পুরাৱদৎ| সর্ৱ্ৱো জনঃ সমীপে মে জানুপাতং করিষ্যতি| জিহ্ৱৈকৈকা তথেশস্য নিঘ্নৎৱং স্ৱীকরিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","অতএৱ ঈশ্ৱরসমীপেঽস্মাকম্ একৈকজনেন নিজা কথা কথযিতৱ্যা| ");
INSERT INTO sanben_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","ইত্থং সতি ৱযম্ অদ্যারভ্য পরস্পরং ন দূষযন্তঃ স্ৱভ্রাতু র্ৱিঘ্নো ৱ্যাঘাতো ৱা যন্ন জাযেত তাদৃশীমীহাং কুর্ম্মহে| ");
INSERT INTO sanben_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","কিমপি ৱস্তু স্ৱভাৱতো নাশুচি ভৱতীত্যহং জানে তথা প্রভুনা যীশুখ্রীষ্টেনাপি নিশ্চিতং জানে, কিন্তু যো জনো যদ্ দ্রৱ্যম্ অপৱিত্রং জানীতে তস্য কৃতে তদ্ অপৱিত্রম্ আস্তে| ");
INSERT INTO sanben_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","অতএৱ তৱ ভক্ষ্যদ্রৱ্যেণ তৱ ভ্রাতা শোকান্ৱিতো ভৱতি তর্হি ৎৱং ভ্রাতরং প্রতি প্রেম্না নাচরসি| খ্রীষ্টো যস্য কৃতে স্ৱপ্রাণান্ ৱ্যযিতৱান্ ৎৱং নিজেন ভক্ষ্যদ্রৱ্যেণ তং ন নাশয| ");
INSERT INTO sanben_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","অপরং যুষ্মাকম্ উত্তমং কর্ম্ম নিন্দিতং ন ভৱতু| ");
INSERT INTO sanben_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","ভক্ষ্যং পেযঞ্চেশ্ৱররাজ্যস্য সারো নহি, কিন্তু পুণ্যং শান্তিশ্চ পৱিত্রেণাত্মনা জাত আনন্দশ্চ| ");
INSERT INTO sanben_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","এতৈ র্যো জনঃ খ্রীষ্টং সেৱতে, স এৱেশ্ৱরস্য তুষ্টিকরো মনুষ্যৈশ্চ সুখ্যাতঃ| ");
INSERT INTO sanben_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","অতএৱ যেনাস্মাকং সর্ৱ্ৱেষাং পরস্পরম্ ঐক্যং নিষ্ঠা চ জাযতে তদেৱাস্মাভি র্যতিতৱ্যং| ");
INSERT INTO sanben_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","ভক্ষ্যার্থম্ ঈশ্ৱরস্য কর্ম্মণো হানিং মা জনযত; সর্ৱ্ৱং ৱস্তু পৱিত্রমিতি সত্যং তথাপি যো জনো যদ্ ভুক্ত্ৱা ৱিঘ্নং লভতে তদর্থং তদ্ ভদ্রং নহি| ");
INSERT INTO sanben_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","তৱ মাংসভক্ষণসুরাপানাদিভিঃ ক্রিযাভি র্যদি তৱ ভ্রাতুঃ পাদস্খলনং ৱিঘ্নো ৱা চাঞ্চল্যং ৱা জাযতে তর্হি তদ্ভোজনপানযোস্ত্যাগো ভদ্রঃ| ");
INSERT INTO sanben_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","যদি তৱ প্রত্যযস্তিষ্ঠতি তর্হীশ্ৱরস্য গোচরে স্ৱান্তরে তং গোপয; যো জনঃ স্ৱমতেন স্ৱং দোষিণং ন করোতি স এৱ ধন্যঃ| ");
INSERT INTO sanben_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","কিন্তু যঃ কশ্চিৎ সংশয্য ভুঙ্ক্তেঽর্থাৎ ন প্রতীত্য ভুঙ্ক্তে, স এৱাৱশ্যং দণ্ডার্হো ভৱিষ্যতি, যতো যৎ প্রত্যযজং নহি তদেৱ পাপমযং ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","বলৱদ্ভিরস্মাভি র্দুর্ব্বলানাং দৌর্ব্বল্যং সোঢৱ্যং ন চ স্ৱেষাম্ ইষ্টাচার আচরিতৱ্যঃ| ");
INSERT INTO sanben_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","অস্মাকম্ একৈকো জনঃ স্ৱসমীপৱাসিনো হিতার্থং নিষ্ঠার্থঞ্চ তস্যৈৱেষ্টাচারম্ আচরতু| ");
INSERT INTO sanben_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","যতঃ খ্রীষ্টোঽপি নিজেষ্টাচারং নাচরিতৱান্, যথা লিখিতম্ আস্তে, ৎৱন্নিন্দকগণস্যৈৱ নিন্দাভি র্নিন্দিতোঽস্ম্যহং| ");
INSERT INTO sanben_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","অপরঞ্চ ৱযং যৎ সহিষ্ণুতাসান্ত্ৱনযো র্জনকেন শাস্ত্রেণ প্রত্যাশাং লভেমহি তন্নিমিত্তং পূর্ৱ্ৱকালে লিখিতানি সর্ৱ্ৱৱচনান্যস্মাকম্ উপদেশার্থমেৱ লিলিখিরে| ");
INSERT INTO sanben_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","সহিষ্ণুতাসান্ত্ৱনযোরাকরো য ঈশ্ৱরঃ স এৱং করোতু যৎ প্রভু র্যীশুখ্রীষ্ট ইৱ যুষ্মাকম্ একজনোঽন্যজনেন সার্দ্ধং মনস ঐক্যম্ আচরেৎ; ");
INSERT INTO sanben_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","যূযঞ্চ সর্ৱ্ৱ একচিত্তা ভূৎৱা মুখৈকেনেৱাস্মৎপ্রভুযীশুখ্রীষ্টস্য পিতুরীশ্ৱরস্য গুণান্ কীর্ত্তযেত| ");
INSERT INTO sanben_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","অপরম্ ঈশ্ৱরস্য মহিম্নঃ প্রকাশার্থং খ্রীষ্টো যথা যুষ্মান্ প্রত্যগৃহ্লাৎ তথা যুষ্মাকমপ্যেকো জনোঽন্যজনং প্রতিগৃহ্লাতু| ");
INSERT INTO sanben_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","যথা লিখিতম্ আস্তে, অতোঽহং সম্মুখে তিষ্ঠন্ ভিন্নদেশনিৱাসিনাং| স্তুৱংস্ত্ৱাং পরিগাস্যামি তৱ নাম্নি পরেশ্ৱর|| ");
INSERT INTO sanben_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","তস্য দযালুৎৱাচ্চ ভিন্নজাতীযা যদ্ ঈশ্ৱরস্য গুণান্ কীর্ত্তযেযুস্তদর্থং যীশুঃ খ্রীষ্টস্ত্ৱক্ছেদনিযমস্য নিঘ্নোঽভৱদ্ ইত্যহং ৱদামি| যথা লিখিতম্ আস্তে, অতোঽহং সম্মুখে তিষ্ঠন্ ভিন্নদেশনিৱাসিনাং| স্তুৱংস্ত্ৱাং পরিগাস্যামি তৱ নাম্নি পরেশ্ৱর|| ");
INSERT INTO sanben_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","অপরমপি লিখিতম্ আস্তে, হে অন্যজাতযো যূযং সমং নন্দত তজ্জনৈঃ| ");
INSERT INTO sanben_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","পুনশ্চ লিখিতম্ আস্তে, হে সর্ৱ্ৱদেশিনো যূযং ধন্যং ব্রূত পরেশ্ৱরং| হে তদীযনরা যূযং কুরুধ্ৱং তৎপ্রশংসনং|| ");
INSERT INTO sanben_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","অপর যীশাযিযোঽপি লিলেখ, যীশযস্য তু যৎ মূলং তৎ প্রকাশিষ্যতে তদা| সর্ৱ্ৱজাতীযনৃণাঞ্চ শাসকঃ সমুদেষ্যতি| তত্রান্যদেশিলোকৈশ্চ প্রত্যাশা প্রকরিষ্যতে|| ");
INSERT INTO sanben_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","অতএৱ যূযং পৱিত্রস্যাত্মনঃ প্রভাৱাদ্ যৎ সম্পূর্ণাং প্রত্যাশাং লপ্স্যধ্ৱে তদর্থং তৎপ্রত্যাশাজনক ঈশ্ৱরঃ প্রত্যযেন যুষ্মান্ শান্ত্যানন্দাভ্যাং সম্পূর্ণান্ করোতু| ");
INSERT INTO sanben_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","হে ভ্রাতরো যূযং সদ্ভাৱযুক্তাঃ সর্ৱ্ৱপ্রকারেণ জ্ঞানেন চ সম্পূর্ণাঃ পরস্পরোপদেশে চ তৎপরা ইত্যহং নিশ্চিতং জানামি, ");
INSERT INTO sanben_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","তথাপ্যহং যৎ প্রগল্ভতরো ভৱন্ যুষ্মান্ প্রবোধযামি তস্যৈকং কারণমিদং| ");
INSERT INTO sanben_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","ভিন্নজাতীযাঃ পৱিত্রেণাত্মনা পাৱিতনৈৱেদ্যরূপা ভূৎৱা যদ্ গ্রাহ্যা ভৱেযুস্তন্নিমিত্তমহম্ ঈশ্ৱরস্য সুসংৱাদং প্রচারযিতুং ভিন্নজাতীযানাং মধ্যে যীশুখ্রীষ্টস্য সেৱকৎৱং দানং ঈশ্ৱরাৎ লব্ধৱানস্মি| ");
INSERT INTO sanben_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","ঈশ্ৱরং প্রতি যীশুখ্রীষ্টেন মম শ্লাঘাকরণস্য কারণম্ আস্তে| ");
INSERT INTO sanben_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","ভিন্নদেশিন আজ্ঞাগ্রাহিণঃ কর্ত্তুং খ্রীষ্টো ৱাক্যেন ক্রিযযা চ, আশ্চর্য্যলক্ষণৈশ্চিত্রক্রিযাভিঃ পৱিত্রস্যাত্মনঃ প্রভাৱেন চ যানি কর্ম্মাণি মযা সাধিতৱান্, ");
INSERT INTO sanben_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","কেৱলং তান্যেৱ ৱিনান্যস্য কস্যচিৎ কর্ম্মণো ৱর্ণনাং কর্ত্তুং প্রগল্ভো ন ভৱামি| তস্মাৎ আ যিরূশালম ইল্লূরিকং যাৱৎ সর্ৱ্ৱত্র খ্রীষ্টস্য সুসংৱাদং প্রাচারযং| ");
INSERT INTO sanben_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","অন্যেন নিচিতাযাং ভিত্তাৱহং যন্ন নিচিনোমি তন্নিমিত্তং যত্র যত্র স্থানে খ্রীষ্টস্য নাম কদাপি কেনাপি ন জ্ঞাপিতং তত্র তত্র সুসংৱাদং প্রচারযিতুম্ অহং যতে| ");
INSERT INTO sanben_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","যাদৃশং লিখিতম্ আস্তে, যৈ র্ৱার্ত্তা তস্য ন প্রাপ্তা দর্শনং তৈস্তু লপ্স্যতে| যৈশ্চ নৈৱ শ্রুতং কিঞ্চিৎ বোদ্ধুং শক্ষ্যন্তি তে জনাঃ|| ");
INSERT INTO sanben_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","তস্মাদ্ যুষ্মৎসমীপগমনাদ্ অহং মুহুর্মুহু র্নিৱারিতোঽভৱং| ");
INSERT INTO sanben_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","কিন্ত্ৱিদানীম্ অত্র প্রদেশেষু মযা ন গতং স্থানং কিমপি নাৱশিষ্যতে যুষ্মৎসমীপং গন্তুং বহুৱৎসরানারভ্য মামকীনাকাঙ্ক্ষা চ ৱিদ্যত ইতি হেতোঃ ");
INSERT INTO sanben_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","স্পানিযাদেশগমনকালেঽহং যুষ্মন্মধ্যেন গচ্ছন্ যুষ্মান্ আলোকিষ্যে, ততঃ পরং যুষ্মৎসম্ভাষণেন তৃপ্তিং পরিলভ্য তদ্দেশগমনার্থং যুষ্মাভি র্ৱিসর্জযিষ্যে, ঈদৃশী মদীযা প্রত্যাশা ৱিদ্যতে| ");
INSERT INTO sanben_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","কিন্তু সাম্প্রতং পৱিত্রলোকানাং সেৱনায যিরূশালম্নগরং ৱ্রজামি| ");
INSERT INTO sanben_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","যতো যিরূশালমস্থপৱিত্রলোকানাং মধ্যে যে দরিদ্রা অর্থৱিশ্রাণনেন তানুপকর্ত্তুং মাকিদনিযাদেশীযা আখাযাদেশীযাশ্চ লোকা ঐচ্ছন্| ");
INSERT INTO sanben_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","এষা তেষাং সদিচ্ছা যতস্তে তেষাম্ ঋণিনঃ সন্তি যতো হেতো র্ভিন্নজাতীযা যেষাং পরমার্থস্যাংশিনো জাতা ঐহিকৱিষযে তেষামুপকারস্তৈঃ কর্ত্তৱ্যঃ| ");
INSERT INTO sanben_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","অতো মযা তৎ কর্ম্ম সাধযিৎৱা তস্মিন্ ফলে তেভ্যঃ সমর্পিতে যুষ্মন্মধ্যেন স্পানিযাদেশো গমিষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","যুষ্মৎসমীপে মমাগমনসমযে খ্রীষ্টস্য সুসংৱাদস্য পূর্ণৱরেণ সম্বলিতঃ সন্ অহম্ আগমিষ্যামি ইতি মযা জ্ঞাযতে| ");
INSERT INTO sanben_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","হে ভ্রাতৃগণ প্রভো র্যীশুখ্রীষ্টস্য নাম্না পৱিত্রস্যাত্মানঃ প্রেম্না চ ৱিনযেঽহং ");
INSERT INTO sanben_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","যিহূদাদেশস্থানাম্ অৱিশ্ৱাসিলোকানাং করেভ্যো যদহং রক্ষাং লভেয মদীযৈতেন সেৱনকর্ম্মণা চ যদ্ যিরূশালমস্থাঃ পৱিত্রলোকাস্তুষ্যেযুঃ, ");
INSERT INTO sanben_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","তদর্থং যূযং মৎকৃত ঈশ্ৱরায প্রার্থযমাণা যতধ্ৱং তেনাহম্ ঈশ্ৱরেচ্ছযা সানন্দং যুষ্মৎসমীপং গৎৱা যুষ্মাভিঃ সহিতঃ প্রাণান্ আপ্যাযিতুং পারযিষ্যামি| ");
INSERT INTO sanben_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","শান্তিদাযক ঈশ্ৱরো যুষ্মাকং সর্ৱ্ৱেষাং সঙ্গী ভূযাৎ| ইতি| ");
INSERT INTO sanben_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","কিংক্রীযানগরীযধর্ম্মসমাজস্য পরিচারিকা যা ফৈবীনামিকাস্মাকং ধর্ম্মভগিনী তস্যাঃ কৃতেঽহং যুষ্মান্ নিৱেদযামি, ");
INSERT INTO sanben_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","যূযং তাং প্রভুমাশ্রিতাং ৱিজ্ঞায তস্যা আতিথ্যং পৱিত্রলোকার্হং কুরুধ্ৱং, যুষ্মত্তস্তস্যা য উপকারো ভৱিতুং শক্নোতি তং কুরুধ্ৱং, যস্মাৎ তযা বহূনাং মম চোপকারঃ কৃতঃ| ");
INSERT INTO sanben_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","অপরঞ্চ খ্রীষ্টস্য যীশোঃ কর্ম্মণি মম সহকারিণৌ মম প্রাণরক্ষার্থঞ্চ স্ৱপ্রাণান্ পণীকৃতৱন্তৌ যৌ প্রিষ্কিল্লাক্কিলৌ তৌ মম নমস্কারং জ্ঞাপযধ্ৱং| ");
INSERT INTO sanben_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","তাভ্যাম্ উপকারাপ্তিঃ কেৱলং মযা স্ৱীকর্ত্তৱ্যেতি নহি ভিন্নদেশীযৈঃ সর্ৱ্ৱধর্ম্মসমাজৈরপি| ");
INSERT INTO sanben_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","অপরঞ্চ তযো র্গৃহে স্থিতান্ ধর্ম্মসমাজলোকান্ মম নমস্কারং জ্ঞাপযধ্ৱং| তদ্ৱৎ আশিযাদেশে খ্রীষ্টস্য পক্ষে প্রথমজাতফলস্ৱরূপো য ইপেনিতনামা মম প্রিযবন্ধুস্তমপি মম নমস্কারং জ্ঞাপযধ্ৱং| ");
INSERT INTO sanben_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","অপরং বহুশ্রমেণাস্মান্ অসেৱত যা মরিযম্ তামপি নমস্কারং জ্ঞাপযধ্ৱং| ");
INSERT INTO sanben_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","অপরঞ্চ প্রেরিতেষু খ্যাতকীর্ত্তী মদগ্রে খ্রীষ্টাশ্রিতৌ মম স্ৱজাতীযৌ সহবন্দিনৌ চ যাৱান্দ্রনীকযূনিযৌ তৌ মম নমস্কারং জ্ঞাপযধ্ৱং| ");
INSERT INTO sanben_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","তথা প্রভৌ মৎপ্রিযতমম্ আম্প্লিযমপি মম নমস্কারং জ্ঞাপযধ্ৱং| ");
INSERT INTO sanben_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","অপরং খ্রীষ্টসেৱাযাং মম সহকারিণম্ ঊর্ব্বাণং মম প্রিযতমং স্তাখুঞ্চ মম নমস্কারং জ্ঞাপযধ্ৱং| ");
INSERT INTO sanben_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","অপরং খ্রীষ্টেন পরীক্ষিতম্ আপিল্লিং মম নমস্কারং ৱদত, আরিষ্টবূলস্য পরিজনাংশ্চ মম নমস্কারং জ্ঞাপযধ্ৱং| ");
INSERT INTO sanben_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","অপরং মম জ্ঞাতিং হেরোদিযোনং মম নমস্কারং ৱদত, তথা নার্কিসস্য পরিৱারাণাং মধ্যে যে প্রভুমাশ্রিতাস্তান্ মম নমস্কারং ৱদত| ");
INSERT INTO sanben_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","অপরং প্রভোঃ সেৱাযাং পরিশ্রমকারিণ্যৌ ত্রুফেনাত্রুফোষে মম নমস্কারং ৱদত, তথা প্রভোঃ সেৱাযাম্ অত্যন্তং পরিশ্রমকারিণী যা প্রিযা পর্ষিস্তাং নমস্কারং জ্ঞাপযধ্ৱং| ");
INSERT INTO sanben_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","অপরং প্রভোরভিরুচিতং রূফং মম ধর্ম্মমাতা যা তস্য মাতা তামপি নমস্কারং ৱদত| ");
INSERT INTO sanben_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","অপরম্ অসুংকৃতং ফ্লিগোনং হর্ম্মং পাত্রবং হর্ম্মিম্ এতেষাং সঙ্গিভ্রাতৃগণঞ্চ নমস্কারং জ্ঞাপযধ্ৱং| ");
INSERT INTO sanben_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","অপরং ফিললগো যূলিযা নীরিযস্তস্য ভগিন্যলুম্পা চৈতান্ এতৈঃ সার্দ্ধং যাৱন্তঃ পৱিত্রলোকা আসতে তানপি নমস্কারং জ্ঞাপযধ্ৱং| ");
INSERT INTO sanben_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","যূযং পরস্পরং পৱিত্রচুম্বনেন নমস্কুরুধ্ৱং| খ্রীষ্টস্য ধর্ম্মসমাজগণো যুষ্মান্ নমস্কুরুতে| ");
INSERT INTO sanben_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","হে ভ্রাতরো যুষ্মান্ ৱিনযেঽহং যুষ্মাভি র্যা শিক্ষা লব্ধা তাম্ অতিক্রম্য যে ৱিচ্ছেদান্ ৱিঘ্নাংশ্চ কুর্ৱ্ৱন্তি তান্ নিশ্চিনুত তেষাং সঙ্গং ৱর্জযত চ| ");
INSERT INTO sanben_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","যতস্তাদৃশা লোকা অস্মাকং প্রভো র্যীশুখ্রীষ্টস্য দাসা ইতি নহি কিন্তু স্ৱোদরস্যৈৱ দাসাঃ; অপরং প্রণযৱচনৈ র্মধুরৱাক্যৈশ্চ সরললোকানাং মনাংসি মোহযন্তি| ");
INSERT INTO sanben_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","যুষ্মাকম্ আজ্ঞাগ্রাহিৎৱং সর্ৱ্ৱত্র সর্ৱ্ৱৈ র্জ্ঞাতং ততোঽহং যুষ্মাসু সানন্দোঽভৱং তথাপি যূযং যৎ সৎজ্ঞানেন জ্ঞানিনঃ কুজ্ঞানেे চাতৎপরা ভৱেতেতি মমাভিলাষঃ| ");
INSERT INTO sanben_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","অধিকন্তু শান্তিদাযক ঈশ্ৱরঃ শৈতানম্ অৱিলম্বং যুষ্মাকং পদানাম্ অধো মর্দ্দিষ্যতি| অস্মাকং প্রভু র্যীশুখ্রীষ্টো যুষ্মাসু প্রসাদং ক্রিযাৎ| ইতি| ");
INSERT INTO sanben_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","মম সহকারী তীমথিযো মম জ্ঞাতযো লূকিযো যাসোন্ সোসিপাত্রশ্চেমে যুষ্মান্ নমস্কুর্ৱ্ৱন্তে| ");
INSERT INTO sanben_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","অপরম্ এতৎপত্রলেখকস্তর্ত্তিযনামাহমপি প্রভো র্নাম্না যুষ্মান্ নমস্করোমি| ");
INSERT INTO sanben_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","তথা কৃৎস্নধর্ম্মসমাজস্য মম চাতিথ্যকারী গাযো যুষ্মান্ নমস্করোতি| অপরম্ এতন্নগরস্য ধনরক্ষক ইরাস্তঃ ক্কার্ত্তনামকশ্চৈকো ভ্রাতা তাৱপি যুষ্মান্ নমস্কুরুতঃ| ");
INSERT INTO sanben_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","অস্মাকং প্রভু র্যীশুখ্রীষ্টা যুষ্মাসু সর্ৱ্ৱেষু প্রসাদং ক্রিযাৎ| ইতি| ");
INSERT INTO sanben_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","পূর্ৱ্ৱকালিকযুগেষু প্রচ্ছন্না যা মন্ত্রণাধুনা প্রকাশিতা ভূৎৱা ভৱিষ্যদ্ৱাদিলিখিতগ্রন্থগণস্য প্রমাণাদ্ ৱিশ্ৱাসেন গ্রহণার্থং সদাতনস্যেশ্ৱরস্যাজ্ঞযা সর্ৱ্ৱদেশীযলোকান্ জ্ঞাপ্যতে, ");
INSERT INTO sanben_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","তস্যা মন্ত্রণাযা জ্ঞানং লব্ধ্ৱা মযা যঃ সুসংৱাদো যীশুখ্রীষ্টমধি প্রচার্য্যতে, তদনুসারাদ্ যুষ্মান্ ধর্ম্মে সুস্থিরান্ কর্ত্তুং সমর্থো যোঽদ্ৱিতীযঃ ");
INSERT INTO sanben_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","সর্ৱ্ৱজ্ঞ ঈশ্ৱরস্তস্য ধন্যৱাদো যীশুখ্রীষ্টেন সন্ততং ভূযাৎ| ইতি|");
INSERT INTO sanben_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","যাৱন্তঃ পৱিত্রা লোকাঃ স্ৱেষাম্ অস্মাকঞ্চ ৱসতিস্থানেষ্ৱস্মাকং প্রভো র্যীশোঃ খ্রীষ্টস্য নাম্না প্রার্থযন্তে তৈঃ সহাহূতানাং খ্রীষ্টেন যীশুনা পৱিত্রীকৃতানাং লোকানাং য ঈশ্ৱরীযধর্ম্মসমাজঃ করিন্থনগরে ৱিদ্যতে ");
INSERT INTO sanben_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","তং প্রতীশ্ৱরস্যেচ্ছযাহূতো যীশুখ্রীষ্টস্য প্রেরিতঃ পৌলঃ সোস্থিনিনামা ভ্রাতা চ পত্রং লিখতি| ");
INSERT INTO sanben_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","অস্মাকং পিত্রেশ্ৱরেণ প্রভুনা যীশুখ্রীষ্টেন চ প্রসাদঃ শান্তিশ্চ যুষ্মভ্যং দীযতাং| ");
INSERT INTO sanben_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","ঈশ্ৱরো যীশুখ্রীষ্টেন যুষ্মান্ প্রতি প্রসাদং প্রকাশিতৱান্, তস্মাদহং যুষ্মন্নিমিত্তং সর্ৱ্ৱদা মদীযেশ্ৱরং ধন্যং ৱদামি| ");
INSERT INTO sanben_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","খ্রীষ্টসম্বন্ধীযং সাক্ষ্যং যুষ্মাকং মধ্যে যেন প্রকারেণ সপ্রমাণম্ অভৱৎ ");
INSERT INTO sanben_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","তেন যূযং খ্রীষ্টাৎ সর্ৱ্ৱৱিধৱক্তৃতাজ্ঞানাদীনি সর্ৱ্ৱধনানি লব্ধৱন্তঃ| ");
INSERT INTO sanben_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","ততোঽস্মৎপ্রভো র্যীশুখ্রীষ্টস্য পুনরাগমনং প্রতীক্ষমাণানাং যুষ্মাকং কস্যাপি ৱরস্যাভাৱো ন ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","অপরম্ অস্মাকং প্রভো র্যীশুখ্রীষ্টস্য দিৱসে যূযং যন্নির্দ্দোষা ভৱেত তদর্থং সএৱ যাৱদন্তং যুষ্মান্ সুস্থিরান্ করিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","য ঈশ্ৱরঃ স্ৱপুত্রস্যাস্মৎপ্রভো র্যীশুখ্রীষ্টস্যাংশিনঃ কর্ত্তুং যুষ্মান্ আহূতৱান্ স ৱিশ্ৱসনীযঃ| ");
INSERT INTO sanben_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","হে ভ্রাতরঃ, অস্মাকং প্রভুযীশুখ্রীষ্টস্য নাম্না যুষ্মান্ ৱিনযেঽহং সর্ৱ্ৱৈ র্যুষ্মাভিরেকরূপাণি ৱাক্যানি কথ্যন্তাং যুষ্মন্মধ্যে ভিন্নসঙ্ঘাতা ন ভৱন্তু মনোৱিচারযোরৈক্যেন যুষ্মাকং সিদ্ধৎৱং ভৱতু| ");
INSERT INTO sanben_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","হে মম ভ্রাতরো যুষ্মন্মধ্যে ৱিৱাদা জাতা ইতি ৱার্ত্তামহং ক্লোয্যাঃ পরিজনৈ র্জ্ঞাপিতঃ| ");
INSERT INTO sanben_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","মমাভিপ্রেতমিদং যুষ্মাকং কশ্চিৎ কশ্চিদ্ ৱদতি পৌলস্য শিষ্যোঽহম্ আপল্লোঃ শিষ্যোঽহং কৈফাঃ শিষ্যোঽহং খ্রীষ্টস্য শিষ্যোঽহমিতি চ| ");
INSERT INTO sanben_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","খ্রীষ্টস্য কিং ৱিভেদঃ কৃতঃ? পৌলঃ কিং যুষ্মৎকৃতে ক্রুশে হতঃ? পৌলস্য নাম্না ৱা যূযং কিং মজ্জিতাঃ? ");
INSERT INTO sanben_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","ক্রিষ্পগাযৌ ৱিনা যুষ্মাকং মধ্যেঽন্যঃ কোঽপি মযা ন মজ্জিত ইতি হেতোরহম্ ঈশ্ৱরং ধন্যং ৱদামি| ");
INSERT INTO sanben_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","এতেন মম নাম্না মানৱা মযা মজ্জিতা ইতি ৱক্তুং কেনাপি ন শক্যতে| ");
INSERT INTO sanben_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","অপরং স্তিফানস্য পরিজনা মযা মজ্জিতাস্তদন্যঃ কশ্চিদ্ যন্মযা মজ্জিতস্তদহং ন ৱেদ্মি| ");
INSERT INTO sanben_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","খ্রীষ্টেনাহং মজ্জনার্থং ন প্রেরিতঃ কিন্তু সুসংৱাদস্য প্রচারার্থমেৱ; সোঽপি ৱাক্পটুতযা মযা ন প্রচারিতৱ্যঃ, যতস্তথা প্রচারিতে খ্রীষ্টস্য ক্রুশে মৃত্যুঃ ফলহীনো ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","যতো হেতো র্যে ৱিনশ্যন্তি তে তাং ক্রুশস্য ৱার্ত্তাং প্রলাপমিৱ মন্যন্তে কিঞ্চ পরিত্রাণং লভমানেষ্ৱস্মাসু সা ঈশ্ৱরীযশক্তিস্ৱরূপা| ");
INSERT INTO sanben_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","তস্মাদিত্থং লিখিতমাস্তে, জ্ঞানৱতান্তু যৎ জ্ঞানং তন্মযা নাশযিষ্যতে| ৱিলোপযিষ্যতে তদ্ৱদ্ বুদ্ধি র্বদ্ধিমতাং মযা|| ");
INSERT INTO sanben_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","জ্ঞানী কুত্র? শাস্ত্রী ৱা কুত্র? ইহলোকস্য ৱিচারতৎপরো ৱা কুত্র? ইহলোকস্য জ্ঞানং কিমীশ্ৱরেণ মোহীকৃতং নহি? ");
INSERT INTO sanben_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","ঈশ্ৱরস্য জ্ঞানাদ্ ইহলোকস্য মানৱাঃ স্ৱজ্ঞানেনেশ্ৱরস্য তত্ত্ৱবোধং ন প্রাপ্তৱন্তস্তস্মাদ্ ঈশ্ৱরঃ প্রচাররূপিণা প্রলাপেন ৱিশ্ৱাসিনঃ পরিত্রাতুং রোচিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","যিহূদীযলোকা লক্ষণানি দিদৃক্ষন্তি ভিন্নদেশীযলোকাস্তু ৱিদ্যাং মৃগযন্তে, ");
INSERT INTO sanben_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","ৱযঞ্চ ক্রুশে হতং খ্রীষ্টং প্রচারযামঃ| তস্য প্রচারো যিহূদীযৈ র্ৱিঘ্ন ইৱ ভিন্নদেশীযৈশ্চ প্রলাপ ইৱ মন্যতে, ");
INSERT INTO sanben_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","কিন্তু যিহূদীযানাং ভিন্নদেশীযানাঞ্চ মধ্যে যে আহূতাস্তেষু স খ্রীষ্ট ঈশ্ৱরীযশক্তিরিৱেশ্ৱরীযজ্ঞানমিৱ চ প্রকাশতে| ");
INSERT INTO sanben_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","যত ঈশ্ৱরে যঃ প্রলাপ আরোপ্যতে স মানৱাতিরিক্তং জ্ঞানমেৱ যচ্চ দৌর্ব্বল্যম্ ঈশ্ৱর আরোপ্যতে তৎ মানৱাতিরিক্তং বলমেৱ| ");
INSERT INTO sanben_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","হে ভ্রাতরঃ, আহূতযুষ্মদ্গণো যষ্মাভিরালোক্যতাং তন্মধ্যে সাংসারিকজ্ঞানেন জ্ঞানৱন্তঃ পরাক্রমিণো ৱা কুলীনা ৱা বহৱো ন ৱিদ্যন্তে| ");
INSERT INTO sanben_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","যত ঈশ্ৱরো জ্ঞানৱতস্ত্রপযিতুং মূর্খলোকান্ রোচিতৱান্ বলানি চ ত্রপযিতুম্ ঈশ্ৱরো দুর্ব্বলান্ রোচিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","তথা ৱর্ত্তমানলোকান্ সংস্থিতিভ্রষ্টান্ কর্ত্তুম্ ঈশ্ৱরো জগতোঽপকৃষ্টান্ হেযান্ অৱর্ত্তমানাংশ্চাভিরোচিতৱান্| ");
INSERT INTO sanben_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","তত ঈশ্ৱরস্য সাক্ষাৎ কেনাপ্যাত্মশ্লাঘা ন কর্ত্তৱ্যা| ");
INSERT INTO sanben_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","যূযঞ্চ তস্মাৎ খ্রীষ্টে যীশৌ সংস্থিতিং প্রাপ্তৱন্তঃ স ঈশ্ৱরাদ্ যুষ্মাকং জ্ঞানং পুণ্যং পৱিত্রৎৱং মুক্তিশ্চ জাতা| ");
INSERT INTO sanben_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","অতএৱ যদ্ৱদ্ লিখিতমাস্তে তদ্ৱৎ, যঃ কশ্চিৎ শ্লাঘমানঃ স্যাৎ শ্লাঘতাং প্রভুনা স হি| ");
INSERT INTO sanben_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","হে ভ্রাতরো যুষ্মৎসমীপে মমাগমনকালেঽহং ৱক্তৃতাযা ৱিদ্যাযা ৱা নৈপুণ্যেনেশ্ৱরস্য সাক্ষ্যং প্রচারিতৱান্ তন্নহি; ");
INSERT INTO sanben_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","যতো যীশুখ্রীষ্টং তস্য ক্রুশে হতৎৱঞ্চ ৱিনা নান্যৎ কিমপি যুষ্মন্মধ্যে জ্ঞাপযিতুং ৱিহিতং বুদ্ধৱান্| ");
INSERT INTO sanben_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","অপরঞ্চাতীৱ দৌর্ব্বল্যভীতিকম্পযুক্তো যুষ্মাভিঃ সার্দ্ধমাসং| ");
INSERT INTO sanben_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","অপরং যুষ্মাকং ৱিশ্ৱাসো যৎ মানুষিকজ্ঞানস্য ফলং ন ভৱেৎ কিন্ত্ৱীশ্ৱরীযশক্তেঃ ফলং ভৱেৎ, ");
INSERT INTO sanben_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","তদর্থং মম ৱক্তৃতা মদীযপ্রচারশ্চ মানুষিকজ্ঞানস্য মধুরৱাক্যসম্বলিতৌ নাস্তাং কিন্ত্ৱাত্মনঃ শক্তেশ্চ প্রমাণযুক্তাৱাস্তাং| ");
INSERT INTO sanben_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","ৱযং জ্ঞানং ভাষামহে তচ্চ সিদ্ধলোকৈ র্জ্ঞানমিৱ মন্যতে, তদিহলোকস্য জ্ঞানং নহি, ইহলোকস্য নশ্ৱরাণাম্ অধিপতীনাং ৱা জ্ঞানং নহি; ");
INSERT INTO sanben_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","কিন্তু কালাৱস্থাযাঃ পূর্ৱ্ৱস্মাদ্ যৎ জ্ঞানম্ অস্মাকং ৱিভৱার্থম্ ঈশ্ৱরেণ নিশ্চিত্য প্রচ্ছন্নং তন্নিগূঢম্ ঈশ্ৱরীযজ্ঞানং প্রভাষামহে| ");
INSERT INTO sanben_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","ইহলোকস্যাধিপতীনাং কেনাপি তৎ জ্ঞানং ন লব্ধং, লব্ধে সতি তে প্রভাৱৱিশিষ্টং প্রভুং ক্রুশে নাহনিষ্যন্| ");
INSERT INTO sanben_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","তদ্ৱল্লিখিতমাস্তে, নেত্রেণ ক্কাপি নো দৃষ্টং কর্ণেনাপি চ ন শ্রুতং| মনোমধ্যে তু কস্যাপি ন প্রৱিষ্টং কদাপি যৎ| ঈশ্ৱরে প্রীযমাণানাং কৃতে তৎ তেন সঞ্চিতং| ");
INSERT INTO sanben_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","অপরমীশ্ৱরঃ স্ৱাত্মনা তদস্মাকং সাক্ষাৎ প্রাকাশযৎ; যত আত্মা সর্ৱ্ৱমেৱানুসন্ধত্তে তেন চেশ্ৱরস্য মর্ম্মতত্ত্ৱমপি বুধ্যতে| ");
INSERT INTO sanben_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","মনুজস্যান্তঃস্থমাত্মানং ৱিনা কেন মনুজেন তস্য মনুজস্য তত্ত্ৱং বুধ্যতে? তদ্ৱদীশ্ৱরস্যাত্মানং ৱিনা কেনাপীশ্ৱরস্য তত্ত্ৱং ন বুধ্যতে| ");
INSERT INTO sanben_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","ৱযঞ্চেহলোকস্যাত্মানং লব্ধৱন্তস্তন্নহি কিন্ত্ৱীশ্ৱরস্যৈৱাত্মানং লব্ধৱন্তঃ, ততো হেতোরীশ্ৱরেণ স্ৱপ্রসাদাদ্ অস্মভ্যং যদ্ যদ্ দত্তং তৎসর্ৱ্ৱম্ অস্মাভি র্জ্ঞাতুং শক্যতে| ");
INSERT INTO sanben_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","তচ্চাস্মাভি র্মানুষিকজ্ঞানস্য ৱাক্যানি শিক্ষিৎৱা কথ্যত ইতি নহি কিন্ত্ৱাত্মতো ৱাক্যানি শিক্ষিৎৱাত্মিকৈ র্ৱাক্যৈরাত্মিকং ভাৱং প্রকাশযদ্ভিঃ কথ্যতে| ");
INSERT INTO sanben_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","প্রাণী মনুষ্য ঈশ্ৱরীযাত্মনঃ শিক্ষাং ন গৃহ্লাতি যত আত্মিকৱিচারেণ সা ৱিচার্য্যেতি হেতোঃ স তাং প্রলাপমিৱ মন্যতে বোদ্ধুঞ্চ ন শক্নোতি| ");
INSERT INTO sanben_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","আত্মিকো মানৱঃ সর্ৱ্ৱাণি ৱিচারযতি কিন্তু স্ৱযং কেনাপি ন ৱিচার্য্যতে| ");
INSERT INTO sanben_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","যত ঈশ্ৱরস্য মনো জ্ঞাৎৱা তমুপদেষ্টুং কঃ শক্নোতি? কিন্তু খ্রীষ্টস্য মনোঽস্মাভি র্লব্ধং| ");
INSERT INTO sanben_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","হে ভ্রাতরঃ, অহমাত্মিকৈরিৱ যুষ্মাভিঃ সমং সম্ভাষিতুং নাশক্নৱং কিন্তু শারীরিকাচারিভিঃ খ্রীষ্টধর্ম্মে শিশুতুল্যৈশ্চ জনৈরিৱ যুষ্মাভিঃ সহ সমভাষে| ");
INSERT INTO sanben_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","যুষ্মান্ কঠিনভক্ষ্যং ন ভোজযন্ দুগ্ধম্ অপাযযং যতো যূযং ভক্ষ্যং গ্রহীতুং তদা নাশক্নুত ইদানীমপি ন শক্নুথ, যতো হেতোরধুনাপি শারীরিকাচারিণ আধ্ৱে| ");
INSERT INTO sanben_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","যুষ্মন্মধ্যে মাৎসর্য্যৱিৱাদভেদা ভৱন্তি ততঃ কিং শারীরিকাচারিণো নাধ্ৱে মানুষিকমার্গেণ চ ন চরথ? ");
INSERT INTO sanben_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","পৌলস্যাহমিত্যাপল্লোরহমিতি ৱা যদ্ৱাক্যং যুষ্মাকং কৈশ্চিৎ কৈশ্চিৎ কথ্যতে তস্মাদ্ যূযং শারীরিকাচারিণ ন ভৱথ? ");
INSERT INTO sanben_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","পৌলঃ কঃ? আপল্লো র্ৱা কঃ? তৌ পরিচারকমাত্রৌ তযোরেকৈকস্মৈ চ প্রভু র্যাদৃক্ ফলমদদাৎ তদ্ৱৎ তযোর্দ্ৱারা যূযং ৱিশ্ৱাসিনো জাতাঃ| ");
INSERT INTO sanben_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","অহং রোপিতৱান্ আপল্লোশ্চ নিষিক্তৱান্ ঈশ্ৱরশ্চাৱর্দ্ধযৎ| ");
INSERT INTO sanben_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","অতো রোপযিতৃসেক্তারাৱসারৌ ৱর্দ্ধযিতেশ্ৱর এৱ সারঃ| ");
INSERT INTO sanben_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","রোপযিতৃসেক্তারৌ চ সমৌ তযোরেকৈকশ্চ স্ৱশ্রমযোগ্যং স্ৱৱেতনং লপ্স্যতে| ");
INSERT INTO sanben_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","আৱামীশ্ৱরেণ সহ কর্ম্মকারিণৌ, ঈশ্ৱরস্য যৎ ক্ষেত্রম্ ঈশ্ৱরস্য যা নির্ম্মিতিঃ সা যূযমেৱ| ");
INSERT INTO sanben_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","ঈশ্ৱরস্য প্রসাদাৎ মযা যৎ পদং লব্ধং তস্মাৎ জ্ঞানিনা গৃহকারিণেৱ মযা ভিত্তিমূলং স্থাপিতং তদুপরি চান্যেন নিচীযতে| কিন্তু যেন যন্নিচীযতে তৎ তেন ৱিৱিচ্যতাং| ");
INSERT INTO sanben_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","যতো যীশুখ্রীষ্টরূপং যদ্ ভিত্তিমূলং স্থাপিতং তদন্যৎ কিমপি ভিত্তিমূলং স্থাপযিতুং কেনাপি ন শক্যতে| ");
INSERT INTO sanben_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","এতদ্ভিত্তিমূলস্যোপরি যদি কেচিৎ স্ৱর্ণরূপ্যমণিকাষ্ঠতৃণনলান্ নিচিন্ৱন্তি, ");
INSERT INTO sanben_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","তর্হ্যেকৈকস্য কর্ম্ম প্রকাশিষ্যতে যতঃ স দিৱসস্তৎ প্রকাশযিষ্যতি| যতো হতোস্তন দিৱসেন ৱহ্নিমযেনোদেতৱ্যং তত একৈকস্য কর্ম্ম কীদৃশমেতস্য পরীক্ষা বহ্নিনা ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","যস্য নিচযনরূপং কর্ম্ম স্থাস্নু ভৱিষ্যতি স ৱেতনং লপ্স্যতে| ");
INSERT INTO sanben_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","যস্য চ কর্ম্ম ধক্ষ্যতে তস্য ক্ষতি র্ভৱিষ্যতি কিন্তু ৱহ্নে র্নির্গতজন ইৱ স স্ৱযং পরিত্রাণং প্রাপ্স্যতি| ");
INSERT INTO sanben_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","যূযম্ ঈশ্ৱরস্য মন্দিরং যুষ্মন্মধ্যে চেশ্ৱরস্যাত্মা নিৱসতীতি কিং ন জানীথ? ");
INSERT INTO sanben_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","ঈশ্ৱরস্য মন্দিরং যেন ৱিনাশ্যতে সোঽপীশ্ৱরেণ ৱিনাশযিষ্যতে যত ঈশ্ৱরস্য মন্দিরং পৱিত্রমেৱ যূযং তু তন্মন্দিরম্ আধ্ৱে| ");
INSERT INTO sanben_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","কোপি স্ৱং ন ৱঞ্চযতাং| যুষ্মাকং কশ্চন চেদিহলোকস্য জ্ঞানেন জ্ঞানৱানহমিতি বুধ্যতে তর্হি স যৎ জ্ঞানী ভৱেৎ তদর্থং মূঢো ভৱতু| ");
INSERT INTO sanben_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","যস্মাদিহলোকস্য জ্ঞানম্ ঈশ্ৱরস্য সাক্ষাৎ মূঢৎৱমেৱ| এতস্মিন্ লিখিতমপ্যাস্তে, তীক্ষ্ণা যা জ্ঞানিনাং বুদ্ধিস্তযা তান্ ধরতীশ্ৱরঃ| ");
INSERT INTO sanben_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","পুনশ্চ| জ্ঞানিনাং কল্পনা ৱেত্তি পরমেশো নিরর্থকাঃ| ");
INSERT INTO sanben_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","অতএৱ কোঽপি মনুজৈরাত্মানং ন শ্লাঘতাং যতঃ সর্ৱ্ৱাণি যুষ্মাকমেৱ, ");
INSERT INTO sanben_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","পৌল ৱা আপল্লো র্ৱা কৈফা ৱা জগদ্ ৱা জীৱনং ৱা মরণং ৱা ৱর্ত্তমানং ৱা ভৱিষ্যদ্ৱা সর্ৱ্ৱাণ্যেৱ যুষ্মাকং, ");
INSERT INTO sanben_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","যূযঞ্চ খ্রীষ্টস্য, খ্রীষ্টশ্চেশ্ৱরস্য| ");
INSERT INTO sanben_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","লোকা অস্মান্ খ্রীষ্টস্য পরিচারকান্ ঈশ্ৱরস্য নিগূঠৱাক্যধনস্যাধ্যক্ষাংশ্চ মন্যন্তাং| ");
INSERT INTO sanben_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","কিঞ্চ ধনাধ্যক্ষেণ ৱিশ্ৱসনীযেন ভৱিতৱ্যমেতদেৱ লোকৈ র্যাচ্যতে| ");
INSERT INTO sanben_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","অতো ৱিচারযদ্ভি র্যুষ্মাভিরন্যৈঃ কৈশ্চিন্ মনুজৈ র্ৱা মম পরীক্ষণং মযাতীৱ লঘু মন্যতে ঽহমপ্যাত্মানং ন ৱিচারযামি| ");
INSERT INTO sanben_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","মযা কিমপ্যপরাদ্ধমিত্যহং ন ৱেদ্মি কিন্ত্ৱেতেন মম নিরপরাধৎৱং ন নিশ্চীযতে প্রভুরেৱ মম ৱিচারযিতাস্তি| ");
INSERT INTO sanben_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","অত উপযুক্তসমযাৎ পূর্ৱ্ৱম্ অর্থতঃ প্রভোরাগমনাৎ পূর্ৱ্ৱং যুষ্মাভি র্ৱিচারো ন ক্রিযতাং| প্রভুরাগত্য তিমিরেণ প্রচ্ছন্নানি সর্ৱ্ৱাণি দীপযিষ্যতি মনসাং মন্ত্রণাশ্চ প্রকাশযিষ্যতি তস্মিন্ সময ঈশ্ৱরাদ্ একৈকস্য প্রশংসা ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","হে ভ্রাতরঃ সর্ৱ্ৱাণ্যেতানি মযাত্মানম্ আপল্লৱঞ্চোদ্দিশ্য কথিতানি তস্যৈতৎ কারণং যুযং যথা শাস্ত্রীযৱিধিমতিক্রম্য মানৱম্ অতীৱ নাদরিষ্যধ্ব ঈত্থঞ্চৈকেন ৱৈপরীত্যাদ্ অপরেণ ন শ্লাঘিষ্যধ্ব এতাদৃশীং শিক্ষামাৱযোর্দৃষ্টান্তাৎ লপ্স্যধ্ৱে| ");
INSERT INTO sanben_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","অপরাৎ কস্ত্ৱাং ৱিশেষযতি? তুভ্যং যন্ন দত্ত তাদৃশং কিং ধারযসি? অদত্তেনেৱ দত্তেন ৱস্তুনা কুতঃ শ্লাঘসে? ");
INSERT INTO sanben_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","ইদানীমেৱ যূযং কিং তৃপ্তা লব্ধধনা ৱা? অস্মাস্ৱৱিদ্যমানেষু যূযং কিং রাজৎৱপদং প্রাপ্তাঃ? যুষ্মাকং রাজৎৱং মযাভিলষিতং যতস্তেন যুষ্মাভিঃ সহ ৱযমপি রাজ্যাংশিনো ভৱিষ্যামঃ| ");
INSERT INTO sanben_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","প্রেরিতা ৱযং শেষা হন্তৱ্যাশ্চেৱেশ্ৱরেণ নিদর্শিতাঃ| যতো ৱযং সর্ৱ্ৱলোকানাম্ অর্থতঃ স্ৱর্গীযদূতানাং মানৱানাঞ্চ কৌতুকাস্পদানি জাতাঃ| ");
INSERT INTO sanben_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","খ্রীষ্টস্য কৃতে ৱযং মূঢাঃ কিন্তু যূযং খ্রীষ্টেন জ্ঞানিনঃ, ৱযং দুর্ব্বলা যূযঞ্চ সবলাঃ, যূযং সম্মানিতা ৱযঞ্চাপমানিতাঃ| ");
INSERT INTO sanben_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","ৱযমদ্যাপি ক্ষুধার্ত্তাস্তৃষ্ণার্ত্তা ৱস্ত্রহীনাস্তাডিতা আশ্রমরহিতাশ্চ সন্তঃ ");
INSERT INTO sanben_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","কর্ম্মণি স্ৱকরান্ ৱ্যাপারযন্তশ্চ দুঃখৈঃ কালং যাপযামঃ| গর্হিতৈরস্মাভিরাশীঃ কথ্যতে দূরীকৃতৈঃ সহ্যতে নিন্দিতৈঃ প্রসাদ্যতে| ");
INSERT INTO sanben_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","ৱযমদ্যাপি জগতঃ সম্মার্জনীযোগ্যা অৱকরা ইৱ সর্ৱ্ৱৈ র্মন্যামহে| ");
INSERT INTO sanben_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","যুষ্মান্ ত্রপযিতুমহমেতানি লিখামীতি নহি কিন্তু প্রিযাত্মজানিৱ যুষ্মান্ প্রবোধযামি| ");
INSERT INTO sanben_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","যতঃ খ্রীষ্টধর্ম্মে যদ্যপি যুষ্মাকং দশসহস্রাণি ৱিনেতারো ভৱন্তি তথাপি বহৱো জনকা ন ভৱন্তি যতোঽহমেৱ সুসংৱাদেন যীশুখ্রীষ্টে যুষ্মান্ অজনযং| ");
INSERT INTO sanben_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","অতো যুষ্মান্ ৱিনযেঽহং যূযং মদনুগামিনো ভৱত| ");
INSERT INTO sanben_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","ইত্যর্থং সর্ৱ্ৱেষু ধর্ম্মসমাজেষু সর্ৱ্ৱত্র খ্রীষ্টধর্ম্মযোগ্যা যে ৱিধযো মযোপদিশ্যন্তে তান্ যো যুষ্মান্ স্মারযিষ্যত্যেৱম্ভূতং প্রভোঃ কৃতে প্রিযং ৱিশ্ৱাসিনঞ্চ মদীযতনযং তীমথিযং যুষ্মাকং সমীপং প্রেষিতৱানহং| ");
INSERT INTO sanben_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","অপরমহং যুষ্মাকং সমীপং ন গমিষ্যামীতি বুদ্ধ্ৱা যুষ্মাকং কিযন্তো লোকা গর্ৱ্ৱন্তি| ");
INSERT INTO sanben_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","কিন্তু যদি প্রভেরিচ্ছা ভৱতি তর্হ্যহমৱিলম্বং যুষ্মৎসমীপমুপস্থায তেষাং দর্পধ্মাতানাং লোকানাং ৱাচং জ্ঞাস্যামীতি নহি সামর্থ্যমেৱ জ্ঞাস্যামি| ");
INSERT INTO sanben_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","যস্মাদীশ্ৱরস্য রাজৎৱং ৱাগ্যুক্তং নহি কিন্তু সামর্থ্যযুক্তং| ");
INSERT INTO sanben_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","যুষ্মাকং কা ৱাঞ্ছা? যুষ্মৎসমীপে মযা কিং দণ্ডপাণিনা গন্তৱ্যমুত প্রেমনম্রতাত্মযুক্তেন ৱা? ");
INSERT INTO sanben_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","অপরং যুষ্মাকং মধ্যে ৱ্যভিচারো ৱিদ্যতে স চ ৱ্যভিচারস্তাদৃশো যদ্ দেৱপূজকানাং মধ্যেঽপি তত্তুল্যো ন ৱিদ্যতে ফলতো যুষ্মাকমেকো জনো ৱিমাতৃগমনং কৃরুত ইতি ৱার্ত্তা সর্ৱ্ৱত্র ৱ্যাপ্তা| ");
INSERT INTO sanben_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","তথাচ যূযং দর্পধ্মাতা আধ্বে, তৎ কর্ম্ম যেন কৃতং স যথা যুষ্মন্মধ্যাদ্ দূরীক্রিযতে তথা শোকো যুষ্মাভি র্ন ক্রিযতে কিম্ এতৎ? ");
INSERT INTO sanben_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","অৱিদ্যমানে মদীযশরীরে মমাত্মা যুষ্মন্মধ্যে ৱিদ্যতে অতোঽহং ৱিদ্যমান ইৱ তৎকর্ম্মকারিণো ৱিচারং নিশ্চিতৱান্, ");
INSERT INTO sanben_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","অস্মৎপ্রভো র্যীশুখ্রীষ্টস্য নাম্না যুষ্মাকং মদীযাত্মনশ্চ মিলনে জাতে ঽস্মৎপ্রভো র্যীশুখ্রীষ্টস্য শক্তেঃ সাহায্যেন ");
INSERT INTO sanben_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","স নরঃ শরীরনাশার্থমস্মাভিঃ শযতানো হস্তে সমর্পযিতৱ্যস্ততোঽস্মাকং প্রভো র্যীশো র্দিৱসে তস্যাত্মা রক্ষাং গন্তুং শক্ষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","যুষ্মাকং দর্পো ন ভদ্রায যূযং কিমেতন্ন জানীথ, যথা, ৱিকারঃ কৃৎস্নশক্তূনাং স্ৱল্পকিণ্ৱেন জাযতে| ");
INSERT INTO sanben_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","যূযং যৎ নৱীনশক্তুস্ৱরূপা ভৱেত তদর্থং পুরাতনং কিণ্ৱম্ অৱমার্জ্জত যতো যুষ্মাভিঃ কিণ্ৱশূন্যৈ র্ভৱিতৱ্যং| অপরম্ অস্মাকং নিস্তারোৎসৱীযমেষশাৱকো যঃ খ্রীষ্টঃ সোঽস্মদর্থং বলীকৃতো ঽভৱৎ| ");
INSERT INTO sanben_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","অতঃ পুরাতনকিণ্ৱেনার্থতো দুষ্টতাজিঘাংসারূপেণ কিণ্ৱেন তন্নহি কিন্তু সারল্যসত্যৎৱরূপযা কিণ্ৱশূন্যতযাস্মাভিরুৎসৱঃ কর্ত্তৱ্যঃ| ");
INSERT INTO sanben_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","ৱ্যাভিচারিণাং সংসর্গো যুষ্মাভি র্ৱিহাতৱ্য ইতি মযা পত্রে লিখিতং| ");
INSERT INTO sanben_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","কিন্ত্ৱৈহিকলোকানাং মধ্যে যে ৱ্যভিচারিণো লোভিন উপদ্রাৱিণো দেৱপূজকা ৱা তেষাং সংসর্গঃ সর্ৱ্ৱথা ৱিহাতৱ্য ইতি নহি, ৱিহাতৱ্যে সতি যুষ্মাভি র্জগতো নির্গন্তৱ্যমেৱ| ");
INSERT INTO sanben_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","কিন্তু ভ্রাতৃৎৱেন ৱিখ্যাতঃ কশ্চিজ্জনো যদি ৱ্যভিচারী লোভী দেৱপূজকো নিন্দকো মদ্যপ উপদ্রাৱী ৱা ভৱেৎ তর্হি তাদৃশেন মানৱেন সহ ভোজনপানেঽপি যুষ্মাভি র্ন কর্ত্তৱ্যে ইত্যধুনা মযা লিখিতং| ");
INSERT INTO sanben_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","সমাজবহিঃস্থিতানাং লোকানাং ৱিচারকরণে মম কোঽধিকারঃ? কিন্তু তদন্তর্গতানাং ৱিচারণং যুষ্মাভিঃ কিং ন কর্ত্তৱ্যং ভৱেৎ? ");
INSERT INTO sanben_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","বহিঃস্থানাং তু ৱিচার ঈশ্ৱরেণ কারিষ্যতে| অতো যুষ্মাভিঃ স পাতকী স্ৱমধ্যাদ্ বহিষ্ক্রিযতাং| ");
INSERT INTO sanben_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","যুষ্মাকমেকস্য জনস্যাপরেণ সহ ৱিৱাদে জাতে স পৱিত্রলোকৈ র্ৱিচারমকারযন্ কিম্ অধার্ম্মিকলোকৈ র্ৱিচারযিতুং প্রোৎসহতে? ");
INSERT INTO sanben_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","জগতোঽপি ৱিচারণং পৱিত্রলোকৈঃ কারিষ্যত এতদ্ যূযং কিং ন জানীথ? অতো জগদ্ যদি যুষ্মাভি র্ৱিচারযিতৱ্যং তর্হি ক্ষুদ্রতমৱিচারেষু যূযং কিমসমর্থাঃ? ");
INSERT INTO sanben_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","দূতা অপ্যস্মাভি র্ৱিচারযিষ্যন্ত ইতি কিং ন জানীথ? অত ঐহিকৱিষযাঃ কিম্ অস্মাভি র্ন ৱিচারযিতৱ্যা ভৱেযুঃ? ");
INSERT INTO sanben_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","ঐহিকৱিষযস্য ৱিচারে যুষ্মাভিঃ কর্ত্তৱ্যে যে লোকাঃ সমিতৌ ক্ষুদ্রতমাস্ত এৱ নিযুজ্যন্তাং| ");
INSERT INTO sanben_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","অহং যুষ্মান্ ত্রপযিতুমিচ্ছন্ ৱদামি যৃষ্মন্মধ্যে কিমেকোঽপি মনুষ্যস্তাদৃগ্ বুদ্ধিমান্নহি যো ভ্রাতৃৱিৱাদৱিচারণে সমর্থঃ স্যাৎ? ");
INSERT INTO sanben_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","কিঞ্চৈকো ভ্রাতা ভ্রাত্রান্যেন কিমৱিশ্ৱাসিনাং ৱিচারকাণাং সাক্ষাদ্ ৱিৱদতে? যষ্মন্মধ্যে ৱিৱাদা ৱিদ্যন্ত এতদপি যুষ্মাকং দোষঃ| ");
INSERT INTO sanben_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","যূযং কুতোঽন্যাযসহনং ক্ষতিসহনং ৱা শ্রেযো ন মন্যধ্ৱে? ");
INSERT INTO sanben_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","কিন্তু যূযমপি ভ্রাতৃনেৱ প্রত্যন্যাযং ক্ষতিঞ্চ কুরুথ কিমেতৎ? ");
INSERT INTO sanben_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","ঈশ্ৱরস্য রাজ্যেঽন্যাযকারিণাং লোকানামধিকারো নাস্ত্যেতদ্ যূযং কিং ন জানীথ? মা ৱঞ্চ্যধ্ৱং, যে ৱ্যভিচারিণো দেৱার্চ্চিনঃ পারদারিকাঃ স্ত্রীৱদাচারিণঃ পুংমৈথুনকারিণস্তস্করা ");
INSERT INTO sanben_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","লোভিনো মদ্যপা নিন্দকা উপদ্রাৱিণো ৱা ত ঈশ্ৱরস্য রাজ্যভাগিনো ন ভৱিষ্যন্তি| ");
INSERT INTO sanben_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","যূযঞ্চৈৱংৱিধা লোকা আস্ত কিন্তু প্রভো র্যীশো র্নাম্নাস্মদীশ্ৱরস্যাত্মনা চ যূযং প্রক্ষালিতাঃ পাৱিতাঃ সপুণ্যীকৃতাশ্চ| ");
INSERT INTO sanben_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","মদর্থং সর্ৱ্ৱং দ্রৱ্যম্ অপ্রতিষিদ্ধং কিন্তু ন সর্ৱ্ৱং হিতজনকং| মদর্থং সর্ৱ্ৱমপ্রতিষিদ্ধং তথাপ্যহং কস্যাপি দ্রৱ্যস্য ৱশীকৃতো ন ভৱিষ্যামি| ");
INSERT INTO sanben_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","উদরায ভক্ষ্যাণি ভক্ষ্যেভ্যশ্চোদরং, কিন্তু ভক্ষ্যোদরে ঈশ্ৱরেণ নাশযিষ্যেতে; অপরং দেহো ন ৱ্যভিচারায কিন্তু প্রভৱে প্রভুশ্চ দেহায| ");
INSERT INTO sanben_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","যশ্চেশ্ৱরঃ প্রভুমুত্থাপিতৱান্ স স্ৱশক্ত্যাস্মানপ্যুত্থাপযিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","যুষ্মাকং যানি শরীরাণি তানি খ্রীষ্টস্যাঙ্গানীতি কিং যূযং ন জানীথ? অতঃ খ্রীষ্টস্য যান্যঙ্গানি তানি মযাপহৃত্য ৱেশ্যাযা অঙ্গানি কিং কারিষ্যন্তে? তন্ন ভৱতু| ");
INSERT INTO sanben_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","যঃ কশ্চিদ্ ৱেশ্যাযাম্ আসজ্যতে স তযা সহৈকদেহো ভৱতি কিং যূযমেতন্ন জানীথ? যতো লিখিতমাস্তে, যথা, তৌ দ্ৱৌ জনাৱেকাঙ্গৌ ভৱিষ্যতঃ| ");
INSERT INTO sanben_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","মানৱা যান্যন্যানি কলুষাণি কুর্ৱ্ৱতে তানি ৱপু র্ন সমাৱিশন্তি কিন্তু ৱ্যভিচারিণা স্ৱৱিগ্রহস্য ৱিরুদ্ধং কল্মষং ক্রিযতে| ");
INSERT INTO sanben_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","মানৱা যান্যন্যানি কলুষাণি কুর্ৱ্ৱতে তানি ৱপু র্ন সমাৱিশন্তি কিন্তু ৱ্যভিচারিণা স্ৱৱিগ্রহস্য ৱিরুদ্ধং কল্মষং ক্রিযতে| ");
INSERT INTO sanben_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","যুষ্মাকং যানি ৱপূংসি তানি যুষ্মদন্তঃস্থিতস্যেশ্ৱরাল্লব্ধস্য পৱিত্রস্যাত্মনো মন্দিরাণি যূযঞ্চ স্ৱেষাং স্ৱামিনো নাধ্ৱে কিমেতদ্ যুষ্মাভি র্ন জ্ঞাযতে? ");
INSERT INTO sanben_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","যূযং মূল্যেন ক্রীতা অতো ৱপুর্মনোভ্যাম্ ঈশ্ৱরো যুষ্মাভিঃ পূজ্যতাং যত ঈশ্ৱর এৱ তযোঃ স্ৱামী| ");
INSERT INTO sanben_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","অপরঞ্চ যুষ্মাভি র্মাং প্রতি যৎ পত্রমলেখি তস্যোত্তরমেতৎ, যোষিতোঽস্পর্শনং মনুজস্য ৱরং; ");
INSERT INTO sanben_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","কিন্তু ৱ্যভিচারভযাদ্ একৈকস্য পুংসঃ স্ৱকীযভার্য্যা ভৱতু তদ্ৱদ্ একৈকস্যা যোষিতো ঽপি স্ৱকীযভর্ত্তা ভৱতু| ");
INSERT INTO sanben_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","ভার্য্যাযৈ ভর্ত্রা যদ্যদ্ ৱিতরণীযং তদ্ ৱিতীর্য্যতাং তদ্ৱদ্ ভর্ত্রেঽপি ভার্য্যযা ৱিতরণীযং ৱিতীর্য্যতাং| ");
INSERT INTO sanben_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","ভার্য্যাযাঃ স্ৱদেহে স্ৱৎৱং নাস্তি ভর্ত্তুরেৱ, তদ্ৱদ্ ভর্ত্তুরপি স্ৱদেহে স্ৱৎৱং নাস্তি ভার্য্যাযা এৱ| ");
INSERT INTO sanben_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","উপোষণপ্রার্থনযোঃ সেৱনার্থম্ একমন্ত্রণানাং যুষ্মাকং কিযৎকালং যাৱদ্ যা পৃথক্স্থিতি র্ভৱতি তদন্যো ৱিচ্ছেদো যুষ্মন্মধ্যে ন ভৱতু, ততঃ পরম্ ইন্দ্রিযাণাম্ অধৈর্য্যাৎ শযতান্ যদ্ যুষ্মান্ পরীক্ষাং ন নযেৎ তদর্থং পুনরেকত্র মিলত| ");
INSERT INTO sanben_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","এতদ্ আদেশতো নহি কিন্ত্ৱনুজ্ঞাত এৱ মযা কথ্যতে, ");
INSERT INTO sanben_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","যতো মমাৱস্থেৱ সর্ৱ্ৱমানৱানামৱস্থা ভৱৎৱিতি মম ৱাঞ্ছা কিন্ত্ৱীশ্ৱরাদ্ একেনৈকো ৱরোঽন্যেন চান্যো ৱর ইত্থমেকৈকেন স্ৱকীযৱরো লব্ধঃ| ");
INSERT INTO sanben_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","অপরম্ অকৃতৱিৱাহান্ ৱিধৱাশ্চ প্রতি মমৈতন্নিৱেদনং মমেৱ তেষামৱস্থিতি র্ভদ্রা; ");
INSERT INTO sanben_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","কিঞ্চ যদি তৈরিন্দ্রিযাণি নিযন্তুং ন শক্যন্তে তর্হি ৱিৱাহঃ ক্রিযতাং যতঃ কামদহনাদ্ ৱ্যূঢৎৱং ভদ্রং| ");
INSERT INTO sanben_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","যে চ কৃতৱিৱাহাস্তে মযা নহি প্রভুনৈৱৈতদ্ আজ্ঞাপ্যন্তে| ");
INSERT INTO sanben_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","ভার্য্যা ভর্ত্তৃতঃ পৃথক্ ন ভৱতু| যদি ৱা পৃথগ্ভূতা স্যাৎ তর্হি নির্ৱিৱাহা তিষ্ঠতু স্ৱীযপতিনা ৱা সন্দধাতু ভর্ত্তাপি ভার্য্যাং ন ত্যজতু| ");
INSERT INTO sanben_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","ইতরান্ জনান্ প্রতি প্রভু র্ন ব্রৱীতি কিন্ত্ৱহং ব্রৱীমি; কস্যচিদ্ ভ্রাতুর্যোষিদ্ অৱিশ্ৱাসিনী সত্যপি যদি তেন সহৱাসে তুষ্যতি তর্হি সা তেন ন ত্যজ্যতাং| ");
INSERT INTO sanben_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","তদ্ৱৎ কস্যাশ্চিদ্ যোষিতঃ পতিরৱিশ্ৱাসী সন্নপি যদি তযা সহৱাসে তুষ্যতি তর্হি স তযা ন ত্যজ্যতাং| ");
INSERT INTO sanben_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","যতোঽৱিশ্ৱাসী ভর্ত্তা ভার্য্যযা পৱিত্রীভূতঃ, তদ্ৱদৱিশ্ৱাসিনী ভার্য্যা ভর্ত্রা পৱিত্রীভূতা; নোচেদ্ যুষ্মাকমপত্যান্যশুচীন্যভৱিষ্যন্ কিন্ত্ৱধুনা তানি পৱিত্রাণি সন্তি| ");
INSERT INTO sanben_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","অৱিশ্ৱাসী জনো যদি ৱা পৃথগ্ ভৱতি তর্হি পৃথগ্ ভৱতু; এতেন ভ্রাতা ভগিনী ৱা ন নিবধ্যতে তথাপি ৱযমীশ্ৱরেণ শান্তযে সমাহূতাঃ| ");
INSERT INTO sanben_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","হে নারি তৱ ভর্ত্তুঃ পরিত্রাণং ৎৱত্তো ভৱিষ্যতি ন ৱেতি ৎৱযা কিং জ্ঞাযতে? হে নর তৱ জাযাযাঃ পরিত্রাণং ৎৱত্তেा ভৱিষ্যতি ন ৱেতি ৎৱযা কিং জ্ঞাযতে? ");
INSERT INTO sanben_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","একৈকো জনঃ পরমেশ্ৱরাল্লব্ধং যদ্ ভজতে যস্যাঞ্চাৱস্থাযাম্ ঈশ্ৱরেণাহ্ৱাযি তদনুসারেণৈৱাচরতু তদহং সর্ৱ্ৱসমাজস্থান্ আদিশামি| ");
INSERT INTO sanben_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","ছিন্নৎৱগ্ ভৃৎৱা য আহূতঃ স প্রকৃষ্টৎৱক্ ন ভৱতু, তদ্ৱদ্ অছিন্নৎৱগ্ ভূৎৱা য আহূতঃ স ছিন্নৎৱক্ ন ভৱতু| ");
INSERT INTO sanben_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","ৎৱক্ছেদঃ সারো নহি তদ্ৱদৎৱক্ছেদোঽপি সারো নহি কিন্ত্ৱীশ্ৱরস্যাজ্ঞানাং পালনমেৱ| ");
INSERT INTO sanben_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","যো জনো যস্যামৱস্থাযামাহ্ৱাযি স তস্যামেৱাৱতিষ্ঠতাং| ");
INSERT INTO sanben_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","দাসঃ সন্ ৎৱং কিমাহূতোঽসি? তন্মা চিন্তয, তথাচ যদি স্ৱতন্ত্রো ভৱিতুং শক্নুযাস্তর্হি তদেৱ ৱৃণু| ");
INSERT INTO sanben_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","যতঃ প্রভুনাহূতো যো দাসঃ স প্রভো র্মোচিতজনঃ| তদ্ৱদ্ তেনাহূতঃ স্ৱতন্ত্রো জনোঽপি খ্রীষ্টস্য দাস এৱ| ");
INSERT INTO sanben_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","যূযং মূল্যেন ক্রীতা অতো হেতো র্মানৱানাং দাসা মা ভৱত| ");
INSERT INTO sanben_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","হে ভ্রাতরো যস্যামৱস্থাযাং যস্যাহ্ৱানমভৱৎ তযা স ঈশ্ৱরস্য সাক্ষাৎ তিষ্ঠতু| ");
INSERT INTO sanben_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","অপরম্ অকৃতৱিৱাহান্ জনান্ প্রতি প্রভোঃ কোঽপ্যাদেশো মযা ন লব্ধঃ কিন্তু প্রভোরনুকম্পযা ৱিশ্ৱাস্যো ভূতোঽহং যদ্ ভদ্রং মন্যে তদ্ ৱদামি| ");
INSERT INTO sanben_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","ৱর্ত্তমানাৎ ক্লেশসমযাৎ মনুষ্যস্যানূঢৎৱং ভদ্রমিতি মযা বুধ্যতে| ");
INSERT INTO sanben_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","ৎৱং কিং যোষিতি নিবদ্ধোঽসি তর্হি মোচনং প্রাপ্তুং মা যতস্ৱ| কিং ৱা যোষিতো মুক্তোঽসি? তর্হি জাযাং মা গৱেষয| ");
INSERT INTO sanben_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","ৱিৱাহং কুর্ৱ্ৱতা ৎৱযা কিমপি নাপারাধ্যতে তদ্ৱদ্ ৱ্যূহ্যমানযা যুৱত্যাপি কিমপি নাপরাধ্যতে তথাচ তাদৃশৌ দ্ৱৌ জনৌ শারীরিকং ক্লেশং লপ্স্যেতে কিন্তু যুষ্মান্ প্রতি মম করুণা ৱিদ্যতে| ");
INSERT INTO sanben_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","হে ভ্রাতরোঽহমিদং ব্রৱীমি, ইতঃ পরং সমযোঽতীৱ সংক্ষিপ্তঃ, ");
INSERT INTO sanben_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","অতঃ কৃতদারৈরকৃতদারৈরিৱ রুদদ্ভিশ্চারুদদ্ভিরিৱ সানন্দৈশ্চ নিরানন্দৈরিৱ ক্রেতৃভিশ্চাভাগিভিরিৱাচরিতৱ্যং ");
INSERT INTO sanben_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","যে চ সংসারে চরন্তি তৈ র্নাতিচরিতৱ্যং যত ইহলেाকস্য কৌতুকো ৱিচলতি| ");
INSERT INTO sanben_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","কিন্তু যূযং যন্নিশ্চিন্তা ভৱেতেতি মম ৱাঞ্ছা| অকৃতৱিৱাহো জনো যথা প্রভুং পরিতোষযেৎ তথা প্রভুং চিন্তযতি, ");
INSERT INTO sanben_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","কিন্তু কৃতৱিৱাহো জনো যথা ভার্য্যাং পরিতোষযেৎ তথা সংসারং চিন্তযতি| ");
INSERT INTO sanben_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","তদ্ৱদ্ ঊঢযোষিতো ঽনূঢা ৱিশিষ্যতে| যানূঢা সা যথা কাযমনসোঃ পৱিত্রা ভৱেৎ তথা প্রভুং চিন্তযতি যা চোঢা সা যথা ভর্ত্তারং পরিতোষযেৎ তথা সংসারং চিন্তযতি| ");
INSERT INTO sanben_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","অহং যদ্ যুষ্মান্ মৃগবন্ধিন্যা পরিক্ষিপেযং তদর্থং নহি কিন্তু যূযং যদনিন্দিতা ভূৎৱা প্রভোঃ সেৱনেঽবাধম্ আসক্তা ভৱেত তদর্থমেতানি সর্ৱ্ৱাণি যুষ্মাকং হিতায মযা কথ্যন্তে| ");
INSERT INTO sanben_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","কস্যচিৎ কন্যাযাং যৌৱনপ্রাপ্তাযাং যদি স তস্যা অনূঢৎৱং নিন্দনীযং ৱিৱাহশ্চ সাধযিতৱ্য ইতি মন্যতে তর্হি যথাভিলাষং করোতু, এতেন কিমপি নাপরাৎস্যতি ৱিৱাহঃ ক্রিযতাং| ");
INSERT INTO sanben_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","কিন্তু দুঃখেনাক্লিষ্টঃ কশ্চিৎ পিতা যদি স্থিরমনোগতঃ স্ৱমনোঽভিলাষসাধনে সমর্থশ্চ স্যাৎ মম কন্যা মযা রক্ষিতৱ্যেতি মনসি নিশ্চিনোতি চ তর্হি স ভদ্রং কর্ম্ম করোতি| ");
INSERT INTO sanben_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","অতো যো ৱিৱাহং করোতি স ভদ্রং কর্ম্ম করোতি যশ্চ ৱিৱাহং ন করোতি স ভদ্রতরং কর্ম্ম করোতি| ");
INSERT INTO sanben_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","যাৱৎকালং পতি র্জীৱতি তাৱদ্ ভার্য্যা ৱ্যৱস্থযা নিবদ্ধা তিষ্ঠতি কিন্তু পত্যৌ মহানিদ্রাং গতে সা মুক্তীভূয যমভিলষতি তেন সহ তস্যা ৱিৱাহো ভৱিতুং শক্নোতি, কিন্ত্ৱেতৎ কেৱলং প্রভুভক্তানাং মধ্যে| ");
INSERT INTO sanben_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","তথাচ সা যদি নিষ্পতিকা তিষ্ঠতি তর্হি তস্যাঃ ক্ষেমং ভৱিষ্যতীতি মম ভাৱঃ| অপরম্ ঈশ্ৱরস্যাত্মা মমাপ্যন্ত র্ৱিদ্যত ইতি মযা বুধ্যতে| ");
INSERT INTO sanben_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","দেৱপ্রসাদে সর্ৱ্ৱেষাম্ অস্মাকং জ্ঞানমাস্তে তদ্ৱযং ৱিদ্মঃ| তথাপি জ্ঞানং গর্ৱ্ৱং জনযতি কিন্তু প্রেমতো নিষ্ঠা জাযতে| ");
INSERT INTO sanben_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","অতঃ কশ্চন যদি মন্যতে মম জ্ঞানমাস্ত ইতি তর্হি তেন যাদৃশং জ্ঞানং চেষ্টিতৱ্যং তাদৃশং কিমপি জ্ঞানমদ্যাপি ন লব্ধং| ");
INSERT INTO sanben_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","কিন্তু য ঈশ্ৱরে প্রীযতে স ঈশ্ৱরেণাপি জ্ঞাযতে| ");
INSERT INTO sanben_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","দেৱতাবলিপ্রসাদভক্ষণে ৱযমিদং ৱিদ্মো যৎ জগন্মধ্যে কোঽপি দেৱো ন ৱিদ্যতে, একশ্চেশ্ৱরো দ্ৱিতীযো নাস্তীতি| ");
INSERT INTO sanben_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","স্ৱর্গে পৃথিৱ্যাং ৱা যদ্যপি কেষুচিদ্ ঈশ্ৱর ইতি নামারোপ্যতে তাদৃশাশ্চ বহৱ ঈশ্ৱরা বহৱশ্চ প্রভৱো ৱিদ্যন্তে ");
INSERT INTO sanben_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","তথাপ্যস্মাকমদ্ৱিতীয ঈশ্ৱরঃ স পিতা যস্মাৎ সর্ৱ্ৱেষাং যদর্থঞ্চাস্মাকং সৃষ্টি র্জাতা, অস্মাকঞ্চাদ্ৱিতীযঃ প্রভুঃ স যীশুঃ খ্রীষ্টো যেন সর্ৱ্ৱৱস্তূনাং যেনাস্মাকমপি সৃষ্টিঃ কৃতা| ");
INSERT INTO sanben_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","অধিকন্তু জ্ঞানং সর্ৱ্ৱেষাং নাস্তি যতঃ কেচিদদ্যাপি দেৱতাং সম্মন্য দেৱপ্রসাদমিৱ তদ্ ভক্ষ্যং ভুঞ্জতে তেন দুর্ব্বলতযা তেষাং স্ৱান্তানি মলীমসানি ভৱন্তি| ");
INSERT INTO sanben_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","কিন্তু ভক্ষ্যদ্রৱ্যাদ্ ৱযম্ ঈশ্ৱরেণ গ্রাহ্যা ভৱামস্তন্নহি যতো ভুঙ্ক্ত্ৱা ৱযমুৎকৃষ্টা ন ভৱামস্তদ্ৱদভুঙ্ক্ত্ৱাপ্যপকৃষ্টা ন ভৱামঃ| ");
INSERT INTO sanben_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","অতো যুষ্মাকং যা ক্ষমতা সা দুর্ব্বলানাম্ উন্মাথস্ৱরূপা যন্ন ভৱেৎ তদর্থং সাৱধানা ভৱত| ");
INSERT INTO sanben_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","যতো জ্ঞানৱিশিষ্টস্ত্ৱং যদি দেৱালযে উপৱিষ্টঃ কেনাপি দৃশ্যসে তর্হি তস্য দুর্ব্বলস্য মনসি কিং প্রসাদভক্ষণ উৎসাহো ন জনিষ্যতে? ");
INSERT INTO sanben_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","তথা সতি যস্য কৃতে খ্রীষ্টো মমার তৱ স দুর্ব্বলো ভ্রাতা তৱ জ্ঞানাৎ কিং ন ৱিনংক্ষ্যতি? ");
INSERT INTO sanben_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","ইত্যনেন প্রকারেণ ভ্রাতৃণাং ৱিরুদ্ধম্ অপরাধ্যদ্ভিস্তেষাং দুর্ব্বলানি মনাংসি ৱ্যাঘাতযদ্ভিশ্চ যুষ্মাভিঃ খ্রীষ্টস্য ৱৈপরীত্যেনাপরাধ্যতে| ");
INSERT INTO sanben_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","অতো হেতোঃ পিশিতাশনং যদি মম ভ্রাতু র্ৱিঘ্নস্ৱরূপং ভৱেৎ তর্হ্যহং যৎ স্ৱভ্রাতু র্ৱিঘ্নজনকো ন ভৱেযং তদর্থং যাৱজ্জীৱনং পিশিতং ন ভোক্ষ্যে| ");
INSERT INTO sanben_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","অহং কিম্ একঃ প্রেরিতো নাস্মি? কিমহং স্ৱতন্ত্রো নাস্মি? অস্মাকং প্রভু র্যীশুঃ খ্রীষ্টঃ কিং মযা নাদর্শি? যূযমপি কিং প্রভুনা মদীযশ্রমফলস্ৱরূপা ন ভৱথ? ");
INSERT INTO sanben_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","অন্যলোকানাং কৃতে যদ্যপ্যহং প্রেরিতো ন ভৱেযং তথাচ যুষ্মৎকৃতে প্রেরিতোঽস্মি যতঃ প্রভুনা মম প্রেরিতৎৱপদস্য মুদ্রাস্ৱরূপা যূযমেৱাধ্ৱে| ");
INSERT INTO sanben_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","যে লোকা মযি দোষমারোপযন্তি তান্ প্রতি মম প্রত্যুত্তরমেতৎ| ");
INSERT INTO sanben_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","ভোজনপানযোঃ কিমস্মাকং ক্ষমতা নাস্তি? ");
INSERT INTO sanben_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","অন্যে প্রেরিতাঃ প্রভো র্ভ্রাতরৌ কৈফাশ্চ যৎ কুর্ৱ্ৱন্তি তদ্ৱৎ কাঞ্চিৎ ধর্ম্মভগিনীং ৱ্যূহ্য তযা সার্দ্ধং পর্য্যটিতুং ৱযং কিং ন শক্নুমঃ? ");
INSERT INTO sanben_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","সাংসারিকশ্রমস্য পরিত্যাগাৎ কিং কেৱলমহং বর্ণব্বাশ্চ নিৱারিতৌ? ");
INSERT INTO sanben_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","নিজধনৱ্যযেন কঃ সংগ্রামং করোতি? কো ৱা দ্রাক্ষাক্ষেত্রং কৃৎৱা তৎফলানি ন ভুঙ্ক্তে? কো ৱা পশুৱ্রজং পালযন্ তৎপযো ন পিৱতি? ");
INSERT INTO sanben_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","কিমহং কেৱলাং মানুষিকাং ৱাচং ৱদামি? ৱ্যৱস্থাযাং কিমেতাদৃশং ৱচনং ন ৱিদ্যতে? ");
INSERT INTO sanben_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","মূসাৱ্যৱস্থাগ্রন্থে লিখিতমাস্তে, ৎৱং শস্যমর্দ্দকৱৃষস্যাস্যং ন ভংৎস্যসীতি| ঈশ্ৱরেণ বলীৱর্দ্দানামেৱ চিন্তা কিং ক্রিযতে? ");
INSERT INTO sanben_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","কিং ৱা সর্ৱ্ৱথাস্মাকং কৃতে তদ্ৱচনং তেনোক্তং? অস্মাকমেৱ কৃতে তল্লিখিতং| যঃ ক্ষেত্রং কর্ষতি তেন প্রত্যাশাযুক্তেন কর্ষ্টৱ্যং, যশ্চ শস্যানি মর্দ্দযতি তেন লাভপ্রত্যাশাযুক্তেন মর্দ্দিতৱ্যং| ");
INSERT INTO sanben_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","যুষ্মৎকৃতেঽস্মাভিঃ পারত্রিকাণি বীজানি রোপিতানি, অতো যুষ্মাকমৈহিকফলানাং ৱযম্ অংশিনো ভৱিষ্যামঃ কিমেতৎ মহৎ কর্ম্ম? ");
INSERT INTO sanben_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","যুষ্মাসু যোঽধিকারস্তস্য ভাগিনো যদ্যন্যে ভৱেযুস্তর্হ্যস্মাভিস্ততোঽধিকং কিং তস্য ভাগিভি র্ন ভৱিতৱ্যং? অধিকন্তু ৱযং তেনাধিকারেণ ন ৱ্যৱহৃতৱন্তঃ কিন্তু খ্রীষ্টীযসুসংৱাদস্য কোঽপি ৱ্যাঘাতোঽস্মাভির্যন্ন জাযেত তদর্থং সর্ৱ্ৱং সহামহে| ");
INSERT INTO sanben_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","অপরং যে পৱিত্রৱস্তূনাং পরিচর্য্যাং কুর্ৱ্ৱন্তি তে পৱিত্রৱস্তুতো ভক্ষ্যাণি লভন্তে, যে চ ৱেদ্যাঃ পরিচর্য্যাং কুর্ৱ্ৱন্তি তে ৱেদিস্থৱস্তূনাম্ অংশিনো ভৱন্ত্যেতদ্ যূযং কিং ন ৱিদ? ");
INSERT INTO sanben_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","তদ্ৱদ্ যে সুসংৱাদং ঘোষযন্তি তৈঃ সুসংৱাদেন জীৱিতৱ্যমিতি প্রভুনাদিষ্টং| ");
INSERT INTO sanben_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","অহমেতেষাং সর্ৱ্ৱেষাং কিমপি নাশ্রিতৱান্ মাং প্রতি তদনুসারাৎ আচরিতৱ্যমিত্যাশযেনাপি পত্রমিদং মযা ন লিখ্যতে যতঃ কেনাপি জনেন মম যশসো মুধাকরণাৎ মম মরণং ৱরং| ");
INSERT INTO sanben_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","সুসংৱাদঘেষণাৎ মম যশো ন জাযতে যতস্তদ্ঘোষণং মমাৱশ্যকং যদ্যহং সুসংৱাদং ন ঘোষযেযং তর্হি মাং ধিক্| ");
INSERT INTO sanben_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","ইচ্ছুকেন তৎ কুর্ৱ্ৱতা মযা ফলং লপ্স্যতে কিন্ত্ৱনিচ্ছুকেঽপি মযি তৎকর্ম্মণো ভারোঽর্পিতোঽস্তি| ");
INSERT INTO sanben_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","এতেন মযা লভ্যং ফলং কিং? সুসংৱাদেন মম যোঽধিকার আস্তে তং যদভদ্রভাৱেন নাচরেযং তদর্থং সুসংৱাদঘোষণসমযে তস্য খ্রীষ্টীযসুসংৱাদস্য নির্ৱ্যযীকরণমেৱ মম ফলং| ");
INSERT INTO sanben_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","সর্ৱ্ৱেষাম্ অনাযত্তোঽহং যদ্ ভূরিশো লোকান্ প্রতিপদ্যে তদর্থং সর্ৱ্ৱেষাং দাসৎৱমঙ্গীকৃতৱান্| ");
INSERT INTO sanben_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","যিহূদীযান্ যৎ প্রতিপদ্যে তদর্থং যিহূদীযানাং কৃতে যিহূদীযইৱাভৱং| যে চ ৱ্যৱস্থাযত্তাস্তান্ যৎ প্রতিপদ্যে তদর্থং ৱ্যৱস্থানাযত্তো যোঽহং সোঽহং ৱ্যৱস্থাযত্তানাং কৃতে ৱ্যৱস্থাযত্তইৱাভৱং| ");
INSERT INTO sanben_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","যে চালব্ধৱ্যৱস্থাস্তান্ যৎ প্রতিপদ্যে তদর্থম্ ঈশ্ৱরস্য সাক্ষাদ্ অলব্ধৱ্যৱস্থো ন ভূৎৱা খ্রীষ্টেন লব্ধৱ্যৱস্থো যোঽহং সোঽহম্ অলব্ধৱ্যৱস্থানাং কৃতেঽলব্ধৱ্যৱস্থ ইৱাভৱং| ");
INSERT INTO sanben_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","দুর্ব্বলান্ যৎ প্রতিপদ্যে তদর্থমহং দুর্ব্বলানাং কৃতে দুর্ব্বলইৱাভৱং| ইত্থং কেনাপি প্রকারেণ কতিপযা লোকা যন্মযা পরিত্রাণং প্রাপ্নুযুস্তদর্থং যো যাদৃশ আসীৎ তস্য কৃতে ঽহং তাদৃশইৱাভৱং| ");
INSERT INTO sanben_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","ইদৃশ আচারঃ সুসংৱাদার্থং মযা ক্রিযতে যতোঽহং তস্য ফলানাং সহভাগী ভৱিতুমিচ্ছামি| ");
INSERT INTO sanben_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","পণ্যলাভার্থং যে ধাৱন্তি ধাৱতাং তেষাং সর্ৱ্ৱেষাং কেৱল একঃ পণ্যং লভতে যুষ্মাভিঃ কিমেতন্ন জ্ঞাযতে? অতো যূযং যথা পণ্যং লপ্স্যধ্ৱে তথৈৱ ধাৱত| ");
INSERT INTO sanben_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","মল্লা অপি সর্ৱ্ৱভোগে পরিমিতভোগিনো ভৱন্তি তে তু ম্লানাং স্রজং লিপ্সন্তে কিন্তু ৱযম্ অম্লানাং লিপ্সামহে| ");
INSERT INTO sanben_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","তস্মাদ্ অহমপি ধাৱামি কিন্তু লক্ষ্যমনুদ্দিশ্য ধাৱামি তন্নহি| অহং মল্লইৱ যুধ্যামি চ কিন্তু ছাযামাঘাতযন্নিৱ যুধ্যামি তন্নহি| ");
INSERT INTO sanben_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","ইতরান্ প্রতি সুসংৱাদং ঘোষযিৎৱাহং যৎ স্ৱযমগ্রাহ্যো ন ভৱামি তদর্থং দেহম্ আহন্মি ৱশীকুর্ৱ্ৱে চ| ");
INSERT INTO sanben_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","হে ভ্রাতরঃ, অস্মৎপিতৃপুরুষানধি যূযং যদজ্ঞাতা ন তিষ্ঠতেতি মম ৱাঞ্ছা, তে সর্ৱ্ৱে মেঘাধঃস্থিতা বভূৱুঃ সর্ৱ্ৱে সমুদ্রমধ্যেন ৱৱ্রজুঃ, ");
INSERT INTO sanben_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","সর্ৱ্ৱে মূসামুদ্দিশ্য মেঘসমুদ্রযো র্মজ্জিতা বভূৱুঃ ");
INSERT INTO sanben_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","সর্ৱ্ৱ একম্ আত্মিকং ভক্ষ্যং বুভুজির একম্ আত্মিকং পেযং পপুশ্চ ");
INSERT INTO sanben_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","যতস্তেঽনুচরত আত্মিকাদ্ অচলাৎ লব্ধং তোযং পপুঃ সোঽচলঃ খ্রীষ্টএৱ| ");
INSERT INTO sanben_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","তথা সত্যপি তেষাং মধ্যেঽধিকেষু লোকেষ্ৱীশ্ৱরো ন সন্তুতোষেতি হেতোস্তে প্রন্তরে নিপাতিতাঃ| ");
INSERT INTO sanben_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","এতস্মিন্ তে ঽস্মাকং নিদর্শনস্ৱরূপা বভূৱুঃ; অতস্তে যথা কুৎসিতাভিলাষিণো বভূৱুরস্মাভিস্তথা কুৎসিতাভিলাষিভি র্ন ভৱিতৱ্যং| ");
INSERT INTO sanben_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","লিখিতমাস্তে, লোকা ভোক্তুং পাতুঞ্চোপৱিৱিশুস্ততঃ ক্রীডিতুমুত্থিতা ইতযনেন প্রকারেণ তেষাং কৈশ্চিদ্ যদ্ৱদ্ দেৱপূজা কৃতা যুষ্মাভিস্তদ্ৱৎ ন ক্রিযতাং| ");
INSERT INTO sanben_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","অপরং তেষাং কৈশ্চিদ্ যদ্ৱদ্ ৱ্যভিচারঃ কৃতস্তেন চৈকস্মিন্ দিনে ত্রযোৱিংশতিসহস্রাণি লোকা নিপাতিতাস্তদ্ৱদ্ অস্মাভি র্ৱ্যভিচারো ন কর্ত্তৱ্যঃ| ");
INSERT INTO sanben_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","তেষাং কেচিদ্ যদ্ৱৎ খ্রীষ্টং পরীক্ষিতৱন্তস্তস্মাদ্ ভুজঙ্গৈ র্নষ্টাশ্চ তদ্ৱদ্ অস্মাভিঃ খ্রীষ্টো ন পরীক্ষিতৱ্যঃ| ");
INSERT INTO sanben_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","তেষাং কেচিদ্ যথা ৱাক্কলহং কৃতৱন্তস্তৎকারণাৎ হন্ত্রা ৱিনাশিতাশ্চ যুষ্মাভিস্তদ্ৱদ্ ৱাক্কলহো ন ক্রিযতাং| ");
INSERT INTO sanben_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","তান্ প্রতি যান্যেতানি জঘটিরে তান্যস্মাকং নিদর্শনানি জগতঃ শেষযুগে ৱর্ত্তমানানাম্ অস্মাকং শিক্ষার্থং লিখিতানি চ বভূৱুঃ| ");
INSERT INTO sanben_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","অতএৱ যঃ কশ্চিদ্ সুস্থিরংমন্যঃ স যন্ন পতেৎ তত্র সাৱধানো ভৱতু| ");
INSERT INTO sanben_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","মানুষিকপরীক্ষাতিরিক্তা কাপি পরীক্ষা যুষ্মান্ নাক্রামৎ, ঈশ্ৱরশ্চ ৱিশ্ৱাস্যঃ সোঽতিশক্ত্যাং পরীক্ষাযাং পতনাৎ যুষ্মান্ রক্ষিষ্যতি, পরীক্ষা চ যদ্ যুষ্মাভিঃ সোঢুং শক্যতে তদর্থং তযা সহ নিস্তারস্য পন্থানং নিরূপযিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","হে প্রিযভ্রাতরঃ, দেৱপূজাতো দূরম্ অপসরত| ");
INSERT INTO sanben_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","অহং যুষ্মান্ ৱিজ্ঞান্ মৎৱা প্রভাষে মযা যৎ কথ্যতে তদ্ যুষ্মাভি র্ৱিৱিচ্যতাং| ");
INSERT INTO sanben_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","যদ্ ধন্যৱাদপাত্রম্ অস্মাভি র্ধন্যং গদ্যতে তৎ কিং খ্রীষ্টস্য শোণিতস্য সহভাগিৎৱং নহি? যশ্চ পূপোঽস্মাভি র্ভজ্যতে স কিং খ্রীষ্টস্য ৱপুষঃ সহভাগিৎৱং নহি? ");
INSERT INTO sanben_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","ৱযং বহৱঃ সন্তোঽপ্যেকপূপস্ৱরূপা একৱপুঃস্ৱরূপাশ্চ ভৱামঃ, যতো ৱযং সর্ৱ্ৱ একপূপস্য সহভাগিনঃ| ");
INSERT INTO sanben_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","যূযং শারীরিকম্ ইস্রাযেলীযৱংশং নিরীক্ষধ্ৱং| যে বলীনাং মাংসানি ভুঞ্জতে তে কিং যজ্ঞৱেদ্যাঃ সহভাগিনো ন ভৱন্তি? ");
INSERT INTO sanben_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","ইত্যনেন মযা কিং কথ্যতে? দেৱতা ৱাস্তৱিকী দেৱতাযৈ বলিদানং ৱা ৱাস্তৱিকং কিং ভৱেৎ? ");
INSERT INTO sanben_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","তন্নহি কিন্তু ভিন্নজাতিভি র্যে বলযো দীযন্তে ত ঈশ্ৱরায তন্নহি ভূতেভ্যএৱ দীযন্তে তস্মাদ্ যূযং যদ্ ভূতানাং সহভাগিনো ভৱথেত্যহং নাভিলষামি| ");
INSERT INTO sanben_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","প্রভোঃ কংসেন ভূতানামপি কংসেন পানং যুষ্মাভিরসাধ্যং; যূযং প্রভো র্ভোজ্যস্য ভূতানামপি ভোজ্যস্য সহভাগিনো ভৱিতুং ন শক্নুথ| ");
INSERT INTO sanben_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","ৱযং কিং প্রভুং স্পর্দ্ধিষ্যামহে? ৱযং কিং তস্মাদ্ বলৱন্তঃ? ");
INSERT INTO sanben_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","মাং প্রতি সর্ৱ্ৱং কর্ম্মাপ্রতিষিদ্ধং কিন্তু ন সর্ৱ্ৱং হিতজনকং সর্ৱ্ৱম্ অপ্রতিষিদ্ধং কিন্তু ন সর্ৱ্ৱং নিষ্ঠাজনকং| ");
INSERT INTO sanben_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","আত্মহিতঃ কেনাপি ন চেষ্টিতৱ্যঃ কিন্তু সর্ৱ্ৱৈঃ পরহিতশ্চেষ্টিতৱ্যঃ| ");
INSERT INTO sanben_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","আপণে যৎ ক্রয্যং তদ্ যুষ্মাভিঃ সংৱেদস্যার্থং কিমপি ন পৃষ্ট্ৱা ভুজ্যতাং ");
INSERT INTO sanben_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","যতঃ পৃথিৱী তন্মধ্যস্থঞ্চ সর্ৱ্ৱং পরমেশ্ৱরস্য| ");
INSERT INTO sanben_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","অপরম্ অৱিশ্ৱাসিলোকানাং কেনচিৎ নিমন্ত্রিতা যূযং যদি তত্র জিগমিষথ তর্হি তেন যদ্ যদ্ উপস্থাপ্যতে তদ্ যুষ্মাভিঃ সংৱেদস্যার্থং কিমপি ন পৃষ্ট্ৱা ভুজ্যতাং| ");
INSERT INTO sanben_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","কিন্তু তত্র যদি কশ্চিদ্ যুষ্মান্ ৱদেৎ ভক্ষ্যমেতদ্ দেৱতাযাঃ প্রসাদ ইতি তর্হি তস্য জ্ঞাপযিতুরনুরোধাৎ সংৱেদস্যার্থঞ্চ তদ্ যুষ্মাভি র্ন ভোক্তৱ্যং| পৃথিৱী তন্মধ্যস্থঞ্চ সর্ৱ্ৱং পরমেশ্ৱরস্য, ");
INSERT INTO sanben_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","সত্যমেতৎ, কিন্তু মযা যঃ সংৱেদো নির্দ্দিশ্যতে স তৱ নহি পরস্যৈৱ| ");
INSERT INTO sanben_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","অনুগ্রহপাত্রেণ মযা ধন্যৱাদং কৃৎৱা যদ্ ভুজ্যতে তৎকারণাদ্ অহং কুতো নিন্দিষ্যে? ");
INSERT INTO sanben_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","তস্মাদ্ ভোজনং পানম্ অন্যদ্ৱা কর্ম্ম কুর্ৱ্ৱদ্ভি র্যুষ্মাভিঃ সর্ৱ্ৱমেৱেশ্ৱরস্য মহিম্নঃ প্রকাশার্থং ক্রিযতাং| ");
INSERT INTO sanben_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","যিহূদীযানাং ভিন্নজাতীযানাম্ ঈশ্ৱরস্য সমাজস্য ৱা ৱিঘ্নজনকৈ র্যুষ্মাভি র্ন ভৱিতৱ্যং| ");
INSERT INTO sanben_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","অহমপ্যাত্মহিতম্ অচেষ্টমানো বহূনাং পরিত্রাণার্থং তেষাং হিতং চেষ্টমানঃ সর্ৱ্ৱৱিষযে সর্ৱ্ৱেষাং তুষ্টিকরো ভৱামীত্যনেনাহং যদ্ৱৎ খ্রীষ্টস্যানুগামী তদ্ৱদ্ যূযং মমানুগামিনো ভৱত| ");
INSERT INTO sanben_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","হে ভ্রাতরঃ, যূযং সর্ৱ্ৱস্মিন্ কার্য্যে মাং স্মরথ মযা চ যাদৃগুপদিষ্টাস্তাদৃগাচরথৈতৎকারণাৎ মযা প্রশংসনীযা আধ্বে| ");
INSERT INTO sanben_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","তথাপি মমৈষা ৱাঞ্ছা যদ্ যূযমিদম্ অৱগতা ভৱথ, ");
INSERT INTO sanben_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","একৈকস্য পুরুষস্যোত্তমাঙ্গস্ৱরূপঃ খ্রীষ্টঃ, যোষিতশ্চোত্তমাঙ্গস্ৱরূপঃ পুমান্, খ্রীষ্টস্য চোত্তমাঙ্গস্ৱরূপ ঈশ্ৱরঃ| ");
INSERT INTO sanben_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","অপরম্ আচ্ছাদিতোত্তমাঙ্গেন যেন পুংসা প্রার্থনা ক্রিযত ঈশ্ৱরীযৱাণী কথ্যতে ৱা তেন স্ৱীযোত্তমাঙ্গম্ অৱজ্ঞাযতে| ");
INSERT INTO sanben_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","অনাচ্ছাদিতোত্তমাঙ্গযা যযা যোষিতা চ প্রার্থনা ক্রিযত ঈশ্ৱরীযৱাণী কথ্যতে ৱা তযাপি স্ৱীযোত্তমাঙ্গম্ অৱজ্ঞাযতে যতঃ সা মুণ্ডিতশিরঃসদৃশা| ");
INSERT INTO sanben_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","অনাচ্ছাদিতমস্তকা যা যোষিৎ তস্যাঃ শিরঃ মুণ্ডনীযমেৱ কিন্তু যোষিতঃ কেশচ্ছেদনং শিরোমুণ্ডনং ৱা যদি লজ্জাজনকং ভৱেৎ তর্হি তযা স্ৱশির আচ্ছাদ্যতাং| ");
INSERT INTO sanben_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","পুমান্ ঈশ্ৱরস্য প্রতিমূর্ত্তিঃ প্রতিতেজঃস্ৱরূপশ্চ তস্মাৎ তেন শিরো নাচ্ছাদনীযং কিন্তু সীমন্তিনী পুংসঃ প্রতিবিম্বস্ৱরূপা| ");
INSERT INTO sanben_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","যতো যোষাতঃ পুমান্ নোদপাদি কিন্তু পুংসো যোষিদ্ উদপাদি| ");
INSERT INTO sanben_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","অধিকন্তু যোষিতঃ কৃতে পুংসঃ সৃষ্টি র্ন বভূৱ কিন্তু পুংসঃ কৃতে যোষিতঃ সৃষ্টি র্বভূৱ| ");
INSERT INTO sanben_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","ইতি হেতো র্দূতানাম্ আদরাদ্ যোষিতা শিরস্যধীনতাসূচকম্ আৱরণং ধর্ত্তৱ্যং| ");
INSERT INTO sanben_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","তথাপি প্রভো র্ৱিধিনা পুমাংসং ৱিনা যোষিন্ন জাযতে যোষিতঞ্চ ৱিনা পুমান্ ন জাযতে| ");
INSERT INTO sanben_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","যতো যথা পুংসো যোষিদ্ উদপাদি তথা যোষিতঃ পুমান্ জাযতে, সর্ৱ্ৱৱস্তূনি চেশ্ৱরাদ্ উৎপদ্যন্তে| ");
INSERT INTO sanben_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","যুষ্মাভিরেৱৈতদ্ ৱিৱিচ্যতাং, অনাৱৃতযা যোষিতা প্রার্থনং কিং সুদৃশ্যং ভৱেৎ? ");
INSERT INTO sanben_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","পুরুষস্য দীর্ঘকেশৎৱং তস্য লজ্জাজনকং, কিন্তু যোষিতো দীর্ঘকেশৎৱং তস্যা গৌরৱজনকং ");
INSERT INTO sanben_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","যত আচ্ছাদনায তস্যৈ কেশা দত্তা ইতি কিং যুষ্মাভিঃ স্ৱভাৱতো ন শিক্ষ্যতে? ");
INSERT INTO sanben_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","অত্র যদি কশ্চিদ্ ৱিৱদিতুম্ ইচ্ছেৎ তর্হ্যস্মাকম্ ঈশ্ৱরীযসমিতীনাঞ্চ তাদৃশী রীতি র্ন ৱিদ্যতে| ");
INSERT INTO sanben_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","যুষ্মাভি র্ন ভদ্রায কিন্তু কুৎসিতায সমাগম্যতে তস্মাদ্ এতানি ভাষমাণেন মযা যূযং ন প্রশংসনীযাঃ| ");
INSERT INTO sanben_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","প্রথমতঃ সমিতৌ সমাগতানাং যুষ্মাকং মধ্যে ভেদাঃ সন্তীতি ৱার্ত্তা মযা শ্রূযতে তন্মধ্যে কিঞ্চিৎ সত্যং মন্যতে চ| ");
INSERT INTO sanben_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","যতো হেতো র্যুষ্মন্মধ্যে যে পরীক্ষিতাস্তে যৎ প্রকাশ্যন্তে তদর্থং ভেদৈ র্ভৱিতৱ্যমেৱ| ");
INSERT INTO sanben_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","একত্র সমাগতৈ র্যুষ্মাভিঃ প্রভাৱং ভেाজ্যং ভুজ্যত ইতি নহি; ");
INSERT INTO sanben_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","যতো ভোজনকালে যুষ্মাকমেকৈকেন স্ৱকীযং ভক্ষ্যং তূর্ণং গ্রস্যতে তস্মাদ্ একো জনো বুভুক্ষিতস্তিষ্ঠতি, অন্যশ্চ পরিতৃপ্তো ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","ভোজনপানার্থং যুষ্মাকং কিং ৱেশ্মানি ন সন্তি? যুষ্মাভি র্ৱা কিম্ ঈশ্ৱরস্য সমিতিং তুচ্ছীকৃত্য দীনা লোকা অৱজ্ঞাযন্তে? ইত্যনেন মযা কিং ৱক্তৱ্যং? যূযং কিং মযা প্রশংসনীযাঃ? এতস্মিন্ যূযং ন প্রশংসনীযাঃ| ");
INSERT INTO sanben_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","প্রভুতো য উপদেশো মযা লব্ধো যুষ্মাসু সমর্পিতশ্চ স এষঃ| ");
INSERT INTO sanben_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","পরকরসমর্পণক্ষপাযাং প্রভু র্যীশুঃ পূপমাদাযেশ্ৱরং ধন্যং ৱ্যাহৃত্য তং ভঙ্ক্ত্ৱা ভাষিতৱান্ যুষ্মাভিরেতদ্ গৃহ্যতাং ভুজ্যতাঞ্চ তদ্ যুষ্মৎকৃতে ভগ্নং মম শরীরং; মম স্মরণার্থং যুষ্মাভিরেতৎ ক্রিযতাং| ");
INSERT INTO sanben_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","পুনশ্চ ভেজনাৎ পরং তথৈৱ কংসম্ আদায তেনোক্তং কংসোঽযং মম শোণিতেন স্থাপিতো নূতননিযমঃ; যতিৱারং যুষ্মাভিরেতৎ পীযতে ততিৱারং মম স্মরণার্থং পীযতাং| ");
INSERT INTO sanben_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","যতিৱারং যুষ্মাভিরেষ পূপো ভুজ্যতে ভাজনেনানেন পীযতে চ ততিৱারং প্রভোরাগমনং যাৱৎ তস্য মৃত্যুঃ প্রকাশ্যতে| ");
INSERT INTO sanben_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","অপরঞ্চ যঃ কশ্চিদ্ অযোগ্যৎৱেন প্রভোরিমং পূপম্ অশ্নাতি তস্যানেন ভাজনেন পিৱতি চ স প্রভোঃ কাযরুধিরযো র্দণ্ডদাযী ভৱিষ্যতি| ");
INSERT INTO sanben_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","তস্মাৎ মানৱেনাগ্র আত্মান পরীক্ষ্য পশ্চাদ্ এষ পূপো ভুজ্যতাং কংসেনানেন চ পীযতাং| ");
INSERT INTO sanben_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","যেন চানর্হৎৱেন ভুজ্যতে পীযতে চ প্রভোঃ কাযম্ অৱিমৃশতা তেন দণ্ডপ্রাপ্তযে ভুজ্যতে পীযতে চ| ");
INSERT INTO sanben_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","এতৎকারণাদ্ যুষ্মাকং ভূরিশো লোকা দুর্ব্বলা রোগিণশ্চ সন্তি বহৱশ্চ মহানিদ্রাং গতাঃ| ");
INSERT INTO sanben_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","অস্মাভি র্যদ্যাত্মৱিচারোঽকারিষ্যত তর্হি দণ্ডো নালপ্স্যত; ");
INSERT INTO sanben_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","কিন্তু যদাস্মাকং ৱিচারো ভৱতি তদা ৱযং জগতো জনৈঃ সমং যদ্ দণ্ডং ন লভামহে তদর্থং প্রভুনা শাস্তিং ভুংজ্মহে| ");
INSERT INTO sanben_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","হে মম ভ্রাতরঃ, ভোজনার্থং মিলিতানাং যুষ্মাকম্ একেনেতরোঽনুগৃহ্যতাং| ");
INSERT INTO sanben_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","যশ্চ বুভুক্ষিতঃ স স্ৱগৃহে ভুঙ্ক্তাং| দণ্ডপ্রাপ্তযে যুষ্মাভি র্ন সমাগম্যতাং| এতদ্ভিন্নং যদ্ আদেষ্টৱ্যং তদ্ যুষ্মৎসমীপাগমনকালে মযাদেক্ষ্যতে| ");
INSERT INTO sanben_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","হে ভ্রাতরঃ, যূযং যদ্ আত্মিকান্ দাযান্ অনৱগতাস্তিষ্ঠথ তদহং নাভিলষামি| ");
INSERT INTO sanben_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","পূর্ৱ্ৱং ভিন্নজাতীযা যূযং যদ্ৱদ্ ৱিনীতাস্তদ্ৱদ্ অৱাক্প্রতিমানাম্ অনুগামিন আধ্বম্ ইতি জানীথ| ");
INSERT INTO sanben_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","ইতি হেতোরহং যুষ্মভ্যং নিৱেদযামি, ঈশ্ৱরস্যাত্মনা ভাষমাণঃ কোঽপি যীশুং শপ্ত ইতি ন ৱ্যাহরতি, পুনশ্চ পৱিত্রেণাত্মনা ৱিনীতং ৱিনান্যঃ কোঽপি যীশুং প্রভুরিতি ৱ্যাহর্ত্তুং ন শক্নোতি| ");
INSERT INTO sanben_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","দাযা বহুৱিধাঃ কিন্ত্ৱেক আত্মা ");
INSERT INTO sanben_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","পরিচর্য্যাশ্চ বহুৱিধাঃ কিন্ত্ৱেকঃ প্রভুঃ| ");
INSERT INTO sanben_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","সাধনানি বহুৱিধানি কিন্তু সর্ৱ্ৱেষু সর্ৱ্ৱসাধক ঈশ্ৱর একঃ| ");
INSERT INTO sanben_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","একৈকস্মৈ তস্যাত্মনো দর্শনং পরহিতার্থং দীযতে| ");
INSERT INTO sanben_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","একস্মৈ তেনাত্মনা জ্ঞানৱাক্যং দীযতে, অন্যস্মৈ তেনৈৱাত্মনাদিষ্টং ৱিদ্যাৱাক্যম্, ");
INSERT INTO sanben_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","অন্যস্মৈ তেনৈৱাত্মনা ৱিশ্ৱাসঃ, অন্যস্মৈ তেনৈৱাত্মনা স্ৱাস্থ্যদানশক্তিঃ, ");
INSERT INTO sanben_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","অন্যস্মৈ দুঃসাধ্যসাধনশক্তিরন্যস্মৈ চেশ্ৱরীযাদেশঃ, অন্যস্মৈ চাতিমানুষিকস্যাদেশস্য ৱিচারসামর্থ্যম্, অন্যস্মৈ পরভাষাভাষণশক্তিরন্যস্মৈ চ ভাষার্থভাষণসামর্যং দীযতে| ");
INSERT INTO sanben_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","একেনাদ্ৱিতীযেনাত্মনা যথাভিলাষম্ একৈকস্মৈ জনাযৈকৈকং দানং ৱিতরতা তানি সর্ৱ্ৱাণি সাধ্যন্তে| ");
INSERT INTO sanben_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","দেহ একঃ সন্নপি যদ্ৱদ্ বহ্ৱঙ্গযুক্তো ভৱতি, তস্যৈকস্য ৱপুষো ঽঙ্গানাং বহুৎৱেন যদ্ৱদ্ একং ৱপু র্ভৱতি, তদ্ৱৎ খ্রীষ্টঃ| ");
INSERT INTO sanben_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","যতো হেতো র্যিহূদিভিন্নজাতীযদাসস্ৱতন্ত্রা ৱযং সর্ৱ্ৱে মজ্জনেনৈকেনাত্মনৈকদেহীকৃতাঃ সর্ৱ্ৱে চৈকাত্মভুক্তা অভৱাম| ");
INSERT INTO sanben_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","একেনাঙ্গেন ৱপু র্ন ভৱতি কিন্তু বহুভিঃ| ");
INSERT INTO sanben_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","তত্র চরণং যদি ৱদেৎ নাহং হস্তস্তস্মাৎ শরীরস্য ভাগো নাস্মীতি তর্হ্যনেন শরীরাৎ তস্য ৱিযোগো ন ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","শ্রোত্রং ৱা যদি ৱদেৎ নাহং নযনং তস্মাৎ শরীরস্যাংশো নাস্মীতি তর্হ্যনেন শরীরাৎ তস্য ৱিযোগো ন ভৱতি| ");
INSERT INTO sanben_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","কৃৎস্নং শরীরং যদি দর্শনেন্দ্রিযং ভৱেৎ তর্হি শ্রৱণেন্দ্রিযং কুত্র স্থাস্যতি? তৎ কৃৎস্নং যদি ৱা শ্রৱণেন্দ্রিযং ভৱেৎ তর্হি ঘ্রণেন্দ্রিযং কুত্র স্থাস্যতি? ");
INSERT INTO sanben_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","কিন্ত্ৱিদানীম্ ঈশ্ৱরেণ যথাভিলষিতং তথৈৱাঙ্গপ্রত্যঙ্গানাম্ একৈকং শরীরে স্থাপিতং| ");
INSERT INTO sanben_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","তৎ কৃৎস্নং যদ্যেকাঙ্গরূপি ভৱেৎ তর্হি শরীরে কুত্র স্থাস্যতি? ");
INSERT INTO sanben_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","তস্মাদ্ অঙ্গানি বহূনি সন্তি শরীরং ৎৱেকমেৱ| ");
INSERT INTO sanben_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","অতএৱ 