﻿USE sofia;
DROP TABLE IF EXISTS sofia.sanasm_vpl;
CREATE TABLE sanasm_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sanasm_vpl WRITE;
INSERT INTO sanasm_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ইব্ৰাহীমঃ সন্তানো দাযূদ্ তস্য সন্তানো যীশুখ্ৰীষ্টস্তস্য পূৰ্ৱ্ৱপুৰুষৱংশশ্ৰেণী| ");
INSERT INTO sanasm_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","ইব্ৰাহীমঃ পুত্ৰ ইস্হাক্ তস্য পুত্ৰো যাকূব্ তস্য পুত্ৰো যিহূদাস্তস্য ভ্ৰাতৰশ্চ| ");
INSERT INTO sanasm_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","তস্মাদ্ যিহূদাতস্তামৰো গৰ্ভে পেৰস্সেৰহৌ জজ্ঞাতে, তস্য পেৰসঃ পুত্ৰো হিষ্ৰোণ্ তস্য পুত্ৰো ঽৰাম্| ");
INSERT INTO sanasm_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","তস্য পুত্ৰো ঽম্মীনাদব্ তস্য পুত্ৰো নহশোন্ তস্য পুত্ৰঃ সল্মোন্| ");
INSERT INTO sanasm_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","তস্মাদ্ ৰাহবো গৰ্ভে বোযম্ জজ্ঞে, তস্মাদ্ ৰূতো গৰ্ভে ওবেদ্ জজ্ঞে, তস্য পুত্ৰো যিশযঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","তস্য পুত্ৰো দাযূদ্ ৰাজঃ তস্মাদ্ মৃতোৰিযস্য জাযাযাং সুলেমান্ জজ্ঞে| ");
INSERT INTO sanasm_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","তস্য পুত্ৰো ৰিহবিযাম্, তস্য পুত্ৰোঽবিযঃ, তস্য পুত্ৰ আসা:| ");
INSERT INTO sanasm_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","তস্য সুতো যিহোশাফট্ তস্য সুতো যিহোৰাম তস্য সুত উষিযঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","তস্য সুতো যোথম্ তস্য সুত আহম্ তস্য সুতো হিষ্কিযঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","তস্য সুতো মিনশিঃ, তস্য সুত আমোন্ তস্য সুতো যোশিযঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","বাবিল্নগৰে প্ৰৱসনাৎ পূৰ্ৱ্ৱং স যোশিযো যিখনিযং তস্য ভ্ৰাতৃংশ্চ জনযামাস| ");
INSERT INTO sanasm_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ততো বাবিলি প্ৰৱসনকালে যিখনিযঃ শল্তীযেলং জনযামাস, তস্য সুতঃ সিৰুব্বাৱিল্| ");
INSERT INTO sanasm_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","তস্য সুতো ঽবোহুদ্ তস্য সুত ইলীযাকীম্ তস্য সুতোঽসোৰ্| ");
INSERT INTO sanasm_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","অসোৰঃ সুতঃ সাদোক্ তস্য সুত আখীম্ তস্য সুত ইলীহূদ্| ");
INSERT INTO sanasm_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","তস্য সুত ইলিযাসৰ্ তস্য সুতো মত্তন্| ");
INSERT INTO sanasm_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","তস্য সুতো যাকূব্ তস্য সুতো যূষফ্ তস্য জাযা মৰিযম্; তস্য গৰ্ভে যীশুৰজনি, তমেৱ খ্ৰীষ্টম্ (অৰ্থাদ্ অভিষিক্তং) ৱদন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ইত্থম্ ইব্ৰাহীমো দাযূদং যাৱৎ সাকল্যেন চতুৰ্দশপুৰুষাঃ; আ দাযূদঃ কালাদ্ বাবিলি প্ৰৱসনকালং যাৱৎ চতুৰ্দশপুৰুষা ভৱন্তি| বাবিলি প্ৰৱাসনকালাৎ খ্ৰীষ্টস্য কালং যাৱৎ চতুৰ্দশপুৰুষা ভৱন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","যীশুখ্ৰীষ্টস্য জন্ম কথ্থতে| মৰিযম্ নামিকা কন্যা যূষফে ৱাগ্দত্তাসীৎ, তদা তযোঃ সঙ্গমাৎ প্ৰাক্ সা কন্যা  পৱিত্ৰেণাত্মনা গৰ্ভৱতী বভূৱ| ");
INSERT INTO sanasm_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","তত্ৰ তস্যাঃ পতি ৰ্যূষফ্ সৌজন্যাৎ তস্যাঃ কলঙ্গং প্ৰকাশযিতুম্ অনিচ্ছন্ গোপনেনে তাং পাৰিত্যক্তুং মনশ্চক্ৰে| ");
INSERT INTO sanasm_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","স তথৈৱ ভাৱযতি, তদানীং পৰমেশ্ৱৰস্য দূতঃ স্ৱপ্নে তং দৰ্শনং দত্ত্ৱা ৱ্যাজহাৰ, হে দাযূদঃ সন্তান যূষফ্ ৎৱং নিজাং জাযাং মৰিযমম্ আদাতুং মা ভৈষীঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","যতস্তস্যা গৰ্ভঃ পৱিত্ৰাদাত্মনোঽভৱৎ, সা চ পুত্ৰং প্ৰসৱিষ্যতে, তদা ৎৱং তস্য নাম যীশুম্ (অৰ্থাৎ ত্ৰাতাৰং) কৰীষ্যসে, যস্মাৎ স নিজমনুজান্ তেষাং কলুষেভ্য উদ্ধৰিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ইত্থং সতি, পশ্য গৰ্ভৱতী কন্যা তনযং প্ৰসৱিষ্যতে| ইম্মানূযেল্ তদীযঞ্চ নামধেযং ভৱিষ্যতি|| ইম্মানূযেল্ অস্মাকং সঙ্গীশ্ৱৰইত্যৰ্থঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","ইতি যদ্ ৱচনং পুৰ্ৱ্ৱং ভৱিষ্যদ্ৱক্ত্ৰা ঈশ্ৱৰঃ কথাযামাস, তৎ তদানীং সিদ্ধমভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","অনন্তৰং যূষফ্ নিদ্ৰাতো জাগৰিত উত্থায পৰমেশ্ৱৰীযদূতস্য নিদেশানুসাৰেণ নিজাং জাযাং জগ্ৰাহ, ");
INSERT INTO sanasm_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","কিন্তু যাৱৎ সা নিজং প্ৰথমসুতং অ সুষুৱে, তাৱৎ তাং নোপাগচ্ছৎ, ততঃ সুতস্য নাম যীশুং চক্ৰে| ");
INSERT INTO sanasm_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","অনন্তৰং হেৰোদ্ সংজ্ঞকে ৰাজ্ঞি ৰাজ্যং শাসতি যিহূদীযদেশস্য বৈৎলেহমি নগৰে যীশৌ জাতৱতি চ, কতিপযা জ্যোতিৰ্ৱ্ৱুদঃ পূৰ্ৱ্ৱস্যা দিশো যিৰূশালম্নগৰং সমেত্য কথযমাসুঃ, ");
INSERT INTO sanasm_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","যো যিহূদীযানাং ৰাজা জাতৱান্, স কুত্ৰাস্তে? ৱযং পূৰ্ৱ্ৱস্যাং দিশি তিষ্ঠন্তস্তদীযাং তাৰকাম্ অপশ্যাম তস্মাৎ তং প্ৰণন্তুম্ অाগমাম| ");
INSERT INTO sanasm_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","তদা হেৰোদ্ ৰাজা কথামেতাং নিশম্য যিৰূশালম্নগৰস্থিতৈঃ সৰ্ৱ্ৱমানৱৈঃ সাৰ্দ্ধম্ উদ্ৱিজ্য ");
INSERT INTO sanasm_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","সৰ্ৱ্ৱান্ প্ৰধানযাজকান্ অধ্যাপকাংশ্চ সমাহূযানীয পপ্ৰচ্ছ, খ্ৰীষ্টঃ কুত্ৰ জনিষ্যতে? ");
INSERT INTO sanasm_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","তদা তে কথযামাসুঃ, যিহূদীযদেশস্য বৈৎলেহমি নগৰে, যতো ভৱিষ্যদ্ৱাদিনা ইত্থং লিখিতমাস্তে, ");
INSERT INTO sanasm_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","সৰ্ৱ্ৱাভ্যো ৰাজধানীভ্যো যিহূদীযস্য নীৱৃতঃ| হে যীহূদীযদেশস্যে বৈৎলেহম্ ৎৱং ন চাৱৰা| ইস্ৰাযেলীযলোকান্ মে যতো যঃ পালযিষ্যতি| তাদৃগেকো মহাৰাজস্ত্ৱন্মধ্য উদ্ভৱিষ্যতী|| ");
INSERT INTO sanasm_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","তদানীং হেৰোদ্ ৰাজা তান্ জ্যোতিৰ্ৱ্ৱিদো গোপনম্ আহূয সা তাৰকা কদা দৃষ্টাভৱৎ , তদ্ ৱিনিশ্চযামাস| ");
INSERT INTO sanasm_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","অপৰং তান্ বৈৎলেহমং প্ৰহীত্য গদিতৱান্, যূযং যাত, যত্নাৎ তং শিশুম্ অন্ৱিষ্য তদুদ্দেশে প্ৰাপ্তে মহ্যং ৱাৰ্ত্তাং দাস্যথ, ততো মযাপি গৎৱা স প্ৰণংস্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","তদানীং ৰাজ্ঞ এতাদৃশীম্ আজ্ঞাং প্ৰাপ্য তে প্ৰতস্থিৰে, ততঃ পূৰ্ৱ্ৱৰ্স্যাং দিশি স্থিতৈস্তৈ ৰ্যা তাৰকা দৃষ্টা সা তাৰকা তেষামগ্ৰে গৎৱা যত্ৰ স্থানে শিশূৰাস্তে, তস্য স্থানস্যোপৰি স্থগিতা তস্যৌ| ");
INSERT INTO sanasm_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","তদ্ দৃষ্ট্ৱা তে মহানন্দিতা বভূৱুঃ, ");
INSERT INTO sanasm_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ততো গেহমধ্য প্ৰৱিশ্য তস্য মাত্ৰা মৰিযমা সাদ্ধং তং শিশুং নিৰীক্ষয দণ্ডৱদ্ ভূৎৱা প্ৰণেমুঃ, অপৰং স্ৱেষাং ঘনসম্পত্তিং মোচযিৎৱা সুৱৰ্ণং কুন্দুৰুং গন্ধৰমঞ্চ তস্মৈ দৰ্শনীযং দত্তৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","পশ্চাদ্ হেৰোদ্ ৰাজস্য সমীপং পুনৰপি গন্তুং স্ৱপ্ন ঈশ্ৱৰেণ নিষিদ্ধাঃ সন্তো ঽন্যেন পথা তে নিজদেশং প্ৰতি প্ৰতস্থিৰে| ");
INSERT INTO sanasm_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","অনন্তৰং তেষু গতৱত্মু পৰমেশ্ৱৰস্য দূতো যূষফে স্ৱপ্নে দৰ্শনং দৎৱা জগাদ, ৎৱম্ উত্থায শিশুং তন্মাতৰঞ্চ গৃহীৎৱা মিসৰ্দেশং পলাযস্ৱ, অপৰং যাৱদহং তুভ্যং ৱাৰ্ত্তাং ন কথযিষ্যামি, তাৱৎ তত্ৰৈৱ নিৱস, যতো ৰাজা হেৰোদ্ শিশুং নাশযিতুং মৃগযিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","তদানীং যূষফ্ উত্থায ৰজন্যাং শিশুং তন্মাতৰঞ্চ গৃহীৎৱা মিসৰ্দেশং প্ৰতি প্ৰতস্থে, ");
INSERT INTO sanasm_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","গৎৱা চ হেৰোদো নৃপতে ৰ্মৰণপৰ্য্যন্তং তত্ৰ দেশে ন্যুৱাস, তেন মিসৰ্দেশাদহং পুত্ৰং স্ৱকীযং সমুপাহূযম্| যদেতদ্ৱচনম্ ঈশ্ৱৰেণ ভৱিষ্যদ্ৱাদিনা কথিতং তৎ সফলমভূৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","অনন্তৰং হেৰোদ্ জ্যোতিৰ্ৱিদ্ভিৰাত্মানং প্ৰৱঞ্চিতং ৱিজ্ঞায ভৃশং চুকোপ; অপৰং জ্যোতিৰ্ৱ্ৱিদ্ভ্যস্তেন ৱিনিশ্চিতং যদ্ দিনং তদ্দিনাদ্ গণযিৎৱা দ্ৱিতীযৱৎসৰং প্ৰৱিষ্টা যাৱন্তো বালকা অস্মিন্ বৈৎলেহম্নগৰে তৎসীমমধ্যে চাসন্, লোকান্ প্ৰহিত্য তান্ সৰ্ৱ্ৱান্ ঘাতযামাস| ");
INSERT INTO sanasm_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","অতঃ অনেকস্য ৱিলাপস্য নিনাদ: ক্ৰন্দনস্য চ| শোকেন কৃতশব্দশ্চ ৰামাযাং সংনিশম্যতে| স্ৱবালগণহেতোৰ্ৱৈ ৰাহেল্ নাৰী তু ৰোদিনী| ন মন্যতে প্ৰবোধন্তু যতস্তে নৈৱ মন্তি হি|| ");
INSERT INTO sanasm_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","যদেতদ্ ৱচনং যিৰীমিযনামকভৱিষ্যদ্ৱাদিনা কথিতং তৎ তদানীং সফলম্ অভূৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","তদনন্তৰং হেৰেদি ৰাজনি মৃতে পৰমেশ্ৱৰস্য দূতো মিসৰ্দেশে স্ৱপ্নে দৰ্শনং দত্ত্ৱা যূষফে কথিতৱান্ ");
INSERT INTO sanasm_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ৎৱম্ উত্থায শিশুং তন্মাতৰঞ্চ গৃহীৎৱা পুনৰপীস্ৰাযেলো দেশং যাহী, যে জনাঃ শিশুং নাশযিতুম্ অমৃগযন্ত, তে মৃতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","তদানীং স উত্থায শিশুং তন্মাতৰঞ্চ গৃহ্লন্ ইস্ৰাযেল্দেশম্ আজগাম| ");
INSERT INTO sanasm_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","কিন্তু যিহূদীযদেশে অৰ্খিলাযনাম ৰাজকুমাৰো নিজপিতু ৰ্হেৰোদঃ পদং প্ৰাপ্য ৰাজৎৱং কৰোতীতি নিশম্য তৎ স্থানং যাতুং শঙ্কিতৱান্, পশ্চাৎ স্ৱপ্ন ঈশ্ৱৰাৎ প্ৰবোধং প্ৰাপ্য গালীল্দেশস্য প্ৰদেশৈকং প্ৰস্থায নাসৰন্নাম নগৰং গৎৱা তত্ৰ ন্যুষিতৱান্, ");
INSERT INTO sanasm_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","তেন তং নাসৰতীযং কথযিষ্যন্তি, যদেতদ্ৱাক্যং ভৱিষ্যদ্ৱাদিভিৰুক্ত্তং তৎ সফলমভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","তদানোং যোহ্ন্নামা মজ্জযিতা যিহূদীযদেশস্য প্ৰান্তৰম্ উপস্থায প্ৰচাৰযন্ কথযামাস, ");
INSERT INTO sanasm_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","মনাংসি পৰাৱৰ্ত্তযত, স্ৱৰ্গীযৰাজৎৱং সমীপমাগতম্| ");
INSERT INTO sanasm_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","পৰমেশস্য পন্থানং পৰিষ্কুৰুত সৰ্ৱ্ৱতঃ| তস্য ৰাজপথাংশ্চৈৱ সমীকুৰুত সৰ্ৱ্ৱথা| ইত্যেতৎ প্ৰান্তৰে ৱাক্যং ৱদতঃ কস্যচিদ্ ৰৱঃ|| ");
INSERT INTO sanasm_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","এতদ্ৱচনং যিশযিযভৱিষ্যদ্ৱাদিনা যোহনমুদ্দিশ্য ভাষিতম্| যোহনো ৱসনং মহাঙ্গৰোমজং তস্য কটৌ চৰ্ম্মকটিবন্ধনং; স চ শূককীটান্ মধু চ ভুক্তৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","তদানীং যিৰূশালম্নগৰনিৱাসিনঃ সৰ্ৱ্ৱে যিহূদিদেশীযা যৰ্দ্দন্তটিন্যা উভযতটস্থাশ্চ মানৱা বহিৰাগত্য তস্য সমীপে ");
INSERT INTO sanasm_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","স্ৱীযং স্ৱীযং দুৰিতম্ অঙ্গীকৃত্য তস্যাং যৰ্দ্দনি তেন মজ্জিতা বভূৱুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","অপৰং বহূন্ ফিৰূশিনঃ সিদূকিনশ্চ মনুজান্ মংক্তুং স্ৱসমীপম্ আগচ্ছ্তো ৱিলোক্য স তান্ অভিদধৌ, ৰে ৰে ভুজগৱংশা আগামীনঃ কোপাৎ পলাযিতুং যুষ্মান্ কশ্চেতিতৱান্? ");
INSERT INTO sanasm_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","মনঃপৰাৱৰ্ত্তনস্য সমুচিতং ফলং ফলত| ");
INSERT INTO sanasm_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","কিন্ত্ৱস্মাকং তাত ইব্ৰাহীম্ অস্তীতি স্ৱেষু মনঃসু চীন্তযন্তো মা ৱ্যাহৰত| যতো যুষ্মান্ অহং ৱদামি, ঈশ্ৱৰ এতেভ্যঃ পাষাণেভ্য ইব্ৰাহীমঃ সন্তানান্ উৎপাদযিতুং শক্নোতি| ");
INSERT INTO sanasm_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","অপৰং পাদপানাং মূলে কুঠাৰ ইদানীমপি লগন্ আস্তে, তস্মাদ্ যস্মিন্ পাদপে উত্তমং ফলং ন ভৱতি, স কৃত্তো মধ্যেঽগ্নিং নিক্ষেপ্স্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","অপৰম্ অহং মনঃপৰাৱৰ্ত্তনসূচকেন মজ্জনেন যুষ্মান্ মজ্জযামীতি সত্যং, কিন্তু মম পশ্চাদ্ য আগচ্ছতি, স মত্তোপি মহান্, অহং তদীযোপানহৌ ৱোঢুমপি নহি যোগ্যোস্মি, স যুষ্মান্ ৱহ্নিৰূপে পৱিত্ৰ আত্মনি সংমজ্জযিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","তস্য কাৰে সূৰ্প আস্তে, স স্ৱীযশস্যানি সম্যক্ প্ৰস্ফোট্য নিজান্ সকলগোধূমান্ সংগৃহ্য ভাণ্ডাগাৰে স্থাপযিষ্যতি, কিংন্তু সৰ্ৱ্ৱাণি ৱুষাণ্যনিৰ্ৱ্ৱাণৱহ্নিনা দাহযিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","অনন্তৰং যীশু ৰ্যোহনা মজ্জিতো ভৱিতুং গালীল্প্ৰদেশাদ্ যৰ্দ্দনি তস্য সমীপম্ আজগাম| ");
INSERT INTO sanasm_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","কিন্তু যোহন্ তং নিষিধ্য বভাষে, ৎৱং কিং মম সমীপম্ আগচ্ছসি? ৱৰং ৎৱযা মজ্জনং মম প্ৰযোজনম্ আস্তে| ");
INSERT INTO sanasm_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","তদানীং যীশুঃ প্ৰত্যৱোচৎ; ঈদানীম্ অনুমন্যস্ৱ, যত ইত্থং সৰ্ৱ্ৱধৰ্ম্মসাধনম্ অস্মাকং কৰ্ত্তৱ্যং, ততঃ সোঽন্ৱমন্যত| ");
INSERT INTO sanasm_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","অনন্তৰং যীশুৰম্মসি মজ্জিতুঃ সন্ তৎক্ষণাৎ তোযমধ্যাদ্ উত্থায জগাম, তদা জীমূতদ্ৱাৰে মুক্তে জাতে, স ঈশ্ৱৰস্যাত্মানং কপোতৱদ্ অৱৰুহ্য স্ৱোপৰ্য্যাগচ্ছন্তং ৱীক্ষাঞ্চক্ৰে| ");
INSERT INTO sanasm_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","অপৰম্ এষ মম প্ৰিযঃ পুত্ৰ এতস্মিন্নেৱ মম মহাসন্তোষ এতাদৃশী ৱ্যোমজা ৱাগ্ বভূৱ| ");
INSERT INTO sanasm_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","ততঃ পৰং যীশুঃ প্ৰতাৰকেণ পৰীক্ষিতো ভৱিতুম্ আত্মনা প্ৰান্তৰম্ আকৃষ্টঃ ");
INSERT INTO sanasm_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","সন্ চৎৱাৰিংশদহোৰাত্ৰান্ অনাহাৰস্তিষ্ঠন্ ক্ষুধিতো বভূৱ| ");
INSERT INTO sanasm_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","তদানীং পৰীক্ষিতা তৎসমীপম্ আগত্য ৱ্যাহৃতৱান্, যদি ৎৱমীশ্ৱৰাত্মজো ভৱেস্তৰ্হ্যাজ্ঞযা পাষাণানেতান্ পূপান্ ৱিধেহি| ");
INSERT INTO sanasm_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","ততঃ স প্ৰত্যব্ৰৱীৎ, ইত্থং লিখিতমাস্তে, \"মনুজঃ কেৱলপূপেন ন জীৱিষ্যতি, কিন্ত্ৱীশ্ৱৰস্য ৱদনাদ্ যানি যানি ৱচাংসি নিঃসৰন্তি তৈৰেৱ জীৱিষ্যতি| \" ");
INSERT INTO sanasm_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","তদা প্ৰতাৰকস্তং পুণ্যনগৰং নীৎৱা মন্দিৰস্য চূডোপৰি নিধায গদিতৱান্, ");
INSERT INTO sanasm_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ৎৱং যদিশ্ৱৰস্য তনযো ভৱেস্তৰ্হীতোঽধঃ পত, যত ইত্থং লিখিতমাস্তে, আদেক্ষ্যতি নিজান্ দূতান্ ৰক্ষিতুং ৎৱাং পৰমেশ্ৱৰঃ| যথা সৰ্ৱ্ৱেষু মাৰ্গেষু ৎৱদীযচৰণদ্ৱযে| ন লগেৎ প্ৰস্তৰাঘাতস্ত্ৱাং ঘৰিষ্যন্তি তে কৰৈঃ|| ");
INSERT INTO sanasm_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","তদানীং যীশুস্তস্মৈ কথিতৱান্ এতদপি লিখিতমাস্তে, \"ৎৱং নিজপ্ৰভুং পৰমেশ্ৱৰং মা পৰীক্ষস্ৱ| \" ");
INSERT INTO sanasm_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","অনন্তৰং প্ৰতাৰকঃ পুনৰপি তম্ অত্যুঞ্চধৰাধৰোপৰি নীৎৱা জগতঃ সকলৰাজ্যানি তদৈশ্ৱৰ্য্যাণি চ দৰ্শযাশ্চকাৰ কথযাঞ্চকাৰ চ, ");
INSERT INTO sanasm_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","যদি ৎৱং দণ্ডৱদ্ ভৱন্ মাং প্ৰণমেস্তৰ্হ্যহম্ এতানি তুভ্যং প্ৰদাস্যামি| ");
INSERT INTO sanasm_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","তদানীং যীশুস্তমৱোচৎ, দূৰীভৱ প্ৰতাৰক, লিখিতমিদম্ আস্তে, \"ৎৱযা নিজঃ প্ৰভুঃ পৰমেশ্ৱৰঃ প্ৰণম্যঃ কেৱলঃ স সেৱ্যশ্চ| \" ");
INSERT INTO sanasm_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","ততঃ প্ৰতাৰকেণ স পৰ্য্যত্যাজি, তদা স্ৱৰ্গীযদূতৈৰাগত্য স সিষেৱে| ");
INSERT INTO sanasm_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","তদনন্তৰং যোহন্ কাৰাযাং ববন্ধে, তদ্ৱাৰ্ত্তাং নিশম্য যীশুনা গালীল্ প্ৰাস্থীযত| ");
INSERT INTO sanasm_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ততঃ পৰং স নাসৰন্নগৰং ৱিহায জলঘেস্তটে সিবূলূন্নপ্তালী এতযোৰুৱভযোঃ প্ৰদেশযোঃ সীম্নোৰ্মধ্যৱৰ্ত্তী য: কফৰ্নাহূম্ তন্নগৰম্ ইৎৱা ন্যৱসৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","তস্মাৎ, অন্যাদেশীযগালীলি যৰ্দ্দন্পাৰেঽব্ধিৰোধসি| নপ্তালিসিবূলূন্দেশৌ যত্ৰ স্থানে স্থিতৌ পুৰা| ");
INSERT INTO sanasm_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","তত্ৰত্যা মনুজা যে যে পৰ্য্যভ্ৰাম্যন্ তমিস্ৰকে| তৈৰ্জনৈৰ্বৃহদালোকঃ পৰিদৰ্শিষ্যতে তদা| অৱসন্ যে জনা দেশে মৃত্যুচ্ছাযাস্ৱৰূপকে| তেষামুপৰি লোকানামালোকঃ সংপ্ৰকাশিতঃ|| ");
INSERT INTO sanasm_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","যদেতদ্ৱচনং যিশযিযভৱিষ্যদ্ৱাদিনা প্ৰোক্তং, তৎ তদা সফলম্ অভূৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","অনন্তৰং যীশুঃ সুসংৱাদং প্ৰচাৰযন্ এতাং কথাং কথযিতুম্ আৰেভে, মনাংসি পৰাৱৰ্ত্তযত, স্ৱৰ্গীযৰাজৎৱং সৱিধমভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ততঃ পৰং যীশু ৰ্গালীলো জলধেস্তটেন গচ্ছন্ গচ্ছন্ আন্দ্ৰিযস্তস্য ভ্ৰাতা শিমোন্ অৰ্থতো যং পিতৰং ৱদন্তি এতাৱুভৌ জলঘৌ জালং ক্ষিপন্তৌ দদৰ্শ, যতস্তৌ মীনধাৰিণাৱাস্তাম্| ");
INSERT INTO sanasm_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","তদা স তাৱাহূয ৱ্যাজহাৰ, যুৱাং মম পশ্চাদ্ আগচ্ছতং, যুৱামহং মনুজধাৰিণৌ কৰিষ্যামি| ");
INSERT INTO sanasm_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","তেনৈৱ তৌ জালং ৱিহায তস্য পশ্চাৎ আগচ্ছতাম্| ");
INSERT INTO sanasm_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","অনন্তৰং তস্মাৎ স্থানাৎ ৱ্ৰজন্ ৱ্ৰজন্ সিৱদিযস্য সুতৌ যাকূব্ যোহন্নামানৌ দ্ৱৌ সহজৌ তাতেন সাৰ্দ্ধং নৌকোপৰি জালস্য জীৰ্ণোদ্ধাৰং কুৰ্ৱ্ৱন্তৌ ৱীক্ষ্য তাৱাহূতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","তৎক্ষণাৎ তৌ নাৱং স্ৱতাতঞ্চ ৱিহায তস্য পশ্চাদ্গামিনৌ বভূৱতুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","অনন্তৰং ভজনভৱনে সমুপদিশন্ ৰাজ্যস্য সুসংৱাদং প্ৰচাৰযন্ মনুজানাং সৰ্ৱ্ৱপ্ৰকাৰান্ ৰোগান্ সৰ্ৱ্ৱপ্ৰকাৰপীডাশ্চ শমযন্ যীশুঃ কৃৎস্নং গালীল্দেশং ভ্ৰমিতুম্ আৰভত| ");
INSERT INTO sanasm_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","তেন কৃৎস্নসুৰিযাদেশস্য মধ্যং তস্য যশো ৱ্যাপ্নোৎ, অপৰং ভূতগ্ৰস্তা অপস্মাৰৰ্গীণঃ পক্ষাধাতিপ্ৰভৃতযশ্চ যাৱন্তো মনুজা নানাৱিধৱ্যাধিভিঃ ক্লিষ্টা আসন্, তেষু সৰ্ৱ্ৱেষু তস্য সমীপম্ আনীতেষু স তান্ স্ৱস্থান্ চকাৰ| ");
INSERT INTO sanasm_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","এতেন গালীল্-দিকাপনি-যিৰূশালম্-যিহূদীযদেশেভ্যো যৰ্দ্দনঃ পাৰাঞ্চ বহৱো মনুজাস্তস্য পশ্চাদ্ আগচ্ছন্| ");
INSERT INTO sanasm_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","অনন্তৰং স জননিৱহং নিৰীক্ষ্য ভূধৰোপৰি ৱ্ৰজিৎৱা সমুপৱিৱেশ| ");
INSERT INTO sanasm_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","তদানীং শিষ্যেষু তস্য সমীপমাগতেষু তেন তেভ্য এষা কথা কথ্যাঞ্চক্ৰে| ");
INSERT INTO sanasm_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","অভিমানহীনা জনা ধন্যাঃ, যতস্তে স্ৱৰ্গীযৰাজ্যম্ অধিকৰিষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","খিদ্যমানা মনুজা ধন্যাঃ, যস্মাৎ তে সান্ত্ৱনাং প্ৰাপ্সন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","নম্ৰা মানৱাশ্চ ধন্যাঃ, যস্মাৎ তে মেদিনীম্ অধিকৰিষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ধৰ্ম্মায বুভুক্ষিতাঃ তৃষাৰ্ত্তাশ্চ মনুজা ধন্যাঃ, যস্মাৎ তে পৰিতৰ্প্স্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","কৃপালৱো মানৱা ধন্যাঃ, যস্মাৎ তে কৃপাং প্ৰাপ্স্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","নিৰ্ম্মলহৃদযা মনুজাশ্চ ধন্যাঃ, যস্মাৎ ত ঈশ্চৰং দ্ৰক্ষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","মেলযিতাৰো মানৱা ধন্যাঃ, যস্মাৎ ত ঈশ্চৰস্য সন্তানৎৱেন ৱিখ্যাস্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ধৰ্ম্মকাৰণাৎ তাডিতা মনুজা ধন্যা, যস্মাৎ স্ৱৰ্গীযৰাজ্যে তেষামধিকৰো ৱিদ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","যদা মনুজা মম নামকৃতে যুষ্মান্ নিন্দন্তি তাডযন্তি মৃষা নানাদুৰ্ৱ্ৱাক্যানি ৱদন্তি চ, তদা যুযং ধন্যাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","তদা আনন্দত, তথা ভৃশং হ্লাদধ্ৱঞ্চ, যতঃ স্ৱৰ্গে ভূযাংসি ফলানি লপ্স্যধ্ৱে; তে যুষ্মাকং পুৰাতনান্ ভৱিষ্যদ্ৱাদিনোঽপি তাদৃগ্ অতাডযন্| ");
INSERT INTO sanasm_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","যুযং মেদিন্যাং লৱণৰূপাঃ, কিন্তু যদি লৱণস্য লৱণৎৱম্ অপযাতি, তৰ্হি তৎ কেন প্ৰকাৰেণ স্ৱাদুযুক্তং ভৱিষ্যতি? তৎ কস্যাপি কাৰ্য্যস্যাযোগ্যৎৱাৎ কেৱলং বহিঃ প্ৰক্ষেপ্তুং নৰাণাং পদতলেন দলযিতুঞ্চ যোগ্যং ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","যূযং জগতি দীপ্তিৰূপাঃ, ভূধৰোপৰি স্থিতং নগৰং গুপ্তং ভৱিতুং নহি শক্ষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","অপৰং মনুজাঃ প্ৰদীপান্ প্ৰজ্ৱাল্য দ্ৰোণাধো ন স্থাপযন্তি, কিন্তু দীপাধাৰোপৰ্য্যেৱ স্থাপযন্তি, তেন তে দীপা গেহস্থিতান্ সকলান্ প্ৰকাশযন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","যেন মানৱা যুষ্মাকং সৎকৰ্ম্মাণি ৱিলোক্য যুষ্মাকং স্ৱৰ্গস্থং পিতৰং ধন্যং ৱদন্তি, তেষাং সমক্ষং যুষ্মাকং দীপ্তিস্তাদৃক্ প্ৰকাশতাম্| ");
INSERT INTO sanasm_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","অহং ৱ্যৱস্থাং ভৱিষ্যদ্ৱাক্যঞ্চ লোপ্তুম্ আগতৱান্, ইত্থং মানুভৱত, তে দ্ৱে লোপ্তুং নাগতৱান্, কিন্তু সফলে কৰ্ত্তুম্ আগতোস্মি| ");
INSERT INTO sanasm_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","অপৰং যুষ্মান্ অহং তথ্যং ৱদামি যাৱৎ ৱ্যোমমেদিন্যো ৰ্ধ্ৱংসো ন ভৱিষ্যতি, তাৱৎ সৰ্ৱ্ৱস্মিন্ সফলে ন জাতে ৱ্যৱস্থাযা একা মাত্ৰা বিন্দুৰেকোপি ৱা ন লোপ্স্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","তস্মাৎ যো জন এতাসাম্ আজ্ঞানাম্ অতিক্ষুদ্ৰাম্ একাজ্ঞামপী লংঘতে মনুজাংঞ্চ তথৈৱ শিক্ষযতি, স স্ৱৰ্গীযৰাজ্যে সৰ্ৱ্ৱেভ্যঃ ক্ষুদ্ৰৎৱেন ৱিখ্যাস্যতে, কিন্তু যো জনস্তাং পালযতি, তথৈৱ শিক্ষযতি চ, স স্ৱৰ্গীযৰাজ্যে প্ৰধানৎৱেন ৱিখ্যাস্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","অপৰং যুষ্মান্ অহং ৱদামি, অধ্যাপকফিৰূশিমানৱানাং ধৰ্ম্মানুষ্ঠানাৎ যুষ্মাকং ধৰ্ম্মানুষ্ঠানে নোত্তমে জাতে যূযম্ ঈশ্ৱৰীযৰাজ্যং প্ৰৱেষ্টুং ন শক্ষ্যথ| ");
INSERT INTO sanasm_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","অপৰঞ্চ ৎৱং নৰং মা ৱধীঃ, যস্মাৎ যো নৰং হন্তি, স ৱিচাৰসভাযাং দণ্ডাৰ্হো ভৱিষ্যতি, পূৰ্ৱ্ৱকালীনজনেভ্য ইতি কথিতমাসীৎ, যুষ্মাভিৰশ্ৰাৱি| ");
INSERT INTO sanasm_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","কিন্ত্ৱহং যুষ্মান্ ৱদামি, যঃ কশ্চিৎ কাৰণং ৱিনা নিজভ্ৰাত্ৰে কুপ্যতি, স ৱিচাৰসভাযাং দণ্ডাৰ্হো ভৱিষ্যতি; যঃ কশ্চিচ্চ স্ৱীযসহজং নিৰ্ব্বোধং ৱদতি, স মহাসভাযাং দণ্ডাৰ্হো ভৱিষ্যতি; পুনশ্চ ৎৱং মূঢ ইতি ৱাক্যং যদি কশ্চিৎ স্ৱীযভ্ৰাতৰং ৱক্তি, তৰ্হি নৰকাগ্নৌ স দণ্ডাৰ্হো ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","অতো ৱেদ্যাঃ সমীপং নিজনৈৱেদ্যে সমানীতেঽপি নিজভ্ৰাতৰং প্ৰতি কস্মাচ্চিৎ কাৰণাৎ ৎৱং যদি দোষী ৱিদ্যসে, তদানীং তৱ তস্য স্মৃতি ৰ্জাযতে চ, ");
INSERT INTO sanasm_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","তৰ্হি তস্যা ৱেদ্যাঃ সমীপে নিজনৈৱৈদ্যং নিধায তদৈৱ গৎৱা পূৰ্ৱ্ৱং তেন সাৰ্দ্ধং মিল, পশ্চাৎ আগত্য নিজনৈৱেদ্যং নিৱেদয| ");
INSERT INTO sanasm_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","অন্যঞ্চ যাৱৎ ৱিৱাদিনা সাৰ্দ্ধং ৱৰ্ত্মনি তিষ্ঠসি, তাৱৎ তেন সাৰ্দ্ধং মেলনং কুৰু; নো চেৎ ৱিৱাদী ৱিচাৰযিতুঃ সমীপে ৎৱাং সমৰ্পযতি ৱিচাৰযিতা চ ৰক্ষিণঃ সন্নিধৌ সমৰ্পযতি তদা ৎৱং কাৰাযাং বধ্যেথাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","তৰ্হি ৎৱামহং তথ্থং ব্ৰৱীমি, শেষকপৰ্দকেঽপি ন পৰিশোধিতে তস্মাৎ স্থানাৎ কদাপি বহিৰাগন্তুং ন শক্ষ্যসি| ");
INSERT INTO sanasm_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","অপৰং ৎৱং মা ৱ্যভিচৰ, যদেতদ্ ৱচনং পূৰ্ৱ্ৱকালীনলোকেভ্যঃ কথিতমাসীৎ, তদ্ যূযং শ্ৰুতৱন্তঃ; ");
INSERT INTO sanasm_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","কিন্ত্ৱহং যুষ্মান্ ৱদামি, যদি কশ্চিৎ কামতঃ কাঞ্চন যোষিতং পশ্যতি, তৰ্হি স মনসা তদৈৱ ৱ্যভিচৰিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","তস্মাৎ তৱ দক্ষিণং নেত্ৰং যদি ৎৱাং বাধতে, তৰ্হি তন্নেত্ৰম্ উৎপাট্য দূৰে নিক্ষিপ, যস্মাৎ তৱ সৰ্ৱ্ৱৱপুষো নৰকে নিক্ষেপাৎ তৱৈকাঙ্গস্য নাশো ৱৰং| ");
INSERT INTO sanasm_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","যদ্ৱা তৱ দক্ষিণঃ কৰো যদি ৎৱাং বাধতে, তৰ্হি তং কৰং ছিত্ত্ৱা দূৰে নিক্ষিপ, যতঃ সৰ্ৱ্ৱৱপুষো নৰকে নিক্ষেপাৎ একাঙ্গস্য নাশো ৱৰং| ");
INSERT INTO sanasm_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","উক্তমাস্তে, যদি কশ্চিন্ নিজজাযাং পৰিত্যক্ত্তুম্ ইচ্ছতি, তৰ্হি স তস্যৈ ত্যাগপত্ৰং দদাতু| ");
INSERT INTO sanasm_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","কিন্ত্ৱহং যুষ্মান্ ৱ্যাহৰামি, ৱ্যভিচাৰদোষে ন জাতে যদি কশ্চিন্ নিজজাযাং পৰিত্যজতি, তৰ্হি স তাং ৱ্যভিচাৰযতি; যশ্চ তাং ত্যক্তাং স্ত্ৰিযং ৱিৱহতি, সোপি ৱ্যভিচৰতি| ");
INSERT INTO sanasm_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","পুনশ্চ ৎৱং মৃষা শপথম্ ন কুৰ্ৱ্ৱন্ ঈশ্চৰায নিজশপথং পালয, পূৰ্ৱ্ৱকালীনলোকেভ্যো যৈষা কথা কথিতা, তামপি যূযং শ্ৰুতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","কিন্ত্ৱহং যুষ্মান্ ৱদামি, কমপি শপথং মা কাৰ্ষ্ট, অৰ্থতঃ স্ৱৰ্গনাম্না ন, যতঃ স ঈশ্ৱৰস্য সিংহাসনং; ");
INSERT INTO sanasm_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","পৃথিৱ্যা নাম্নাপি ন, যতঃ সা তস্য পাদপীঠং; যিৰূশালমো নাম্নাপি ন, যতঃ সা মহাৰাজস্য পুৰী; ");
INSERT INTO sanasm_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","নিজশিৰোনাম্নাপি ন, যস্মাৎ তস্যৈকং কচমপি সিতম্ অসিতং ৱা কৰ্ত্তুং ৎৱযা ন শক্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","অপৰং যূযং সংলাপসমযে কেৱলং ভৱতীতি ন ভৱতীতি চ ৱদত যত ইতোঽধিকং যৎ তৎ পাপাত্মনো জাযতে| ");
INSERT INTO sanasm_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","অপৰং লোচনস্য ৱিনিমযেন লোচনং দন্তস্য ৱিনিমযেন দন্তঃ পূৰ্ৱ্ৱক্তমিদং ৱচনঞ্চ যুষ্মাভিৰশ্ৰূযত| ");
INSERT INTO sanasm_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","কিন্ত্ৱহং যুষ্মান্ ৱদামি যূযং হিংসকং নৰং মা ৱ্যাঘাতযত| কিন্তু কেনচিৎ তৱ দক্ষিণকপোলে চপেটাঘাতে কৃতে তং প্ৰতি ৱামং কপোলঞ্চ ৱ্যাঘোটয| ");
INSERT INTO sanasm_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","অপৰং কেনচিৎ ৎৱযা সাৰ্ধ্দং ৱিৱাদং কৃৎৱা তৱ পৰিধেযৱসনে জিঘৃতিতে তস্মাযুত্তৰীযৱসনমপি দেহি| ");
INSERT INTO sanasm_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","যদি কশ্চিৎ ৎৱাং ক্ৰোশমেকং নযনাৰ্থং অন্যাযতো ধৰতি, তদা তেন সাৰ্ধ্দং ক্ৰোশদ্ৱযং যাহি| ");
INSERT INTO sanasm_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","যশ্চ মানৱস্ত্ৱাং যাচতে, তস্মৈ দেহি, যদি কশ্চিৎ তুভ্যং ধাৰযিতুম্ ইচ্ছতি, তৰ্হি তং প্ৰতি পৰাংমুখো মা ভূঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","নিজসমীপৱসিনি প্ৰেম কুৰু, কিন্তু শত্ৰুং প্ৰতি দ্ৱেষং কুৰু, যদেতৎ পুৰোক্তং ৱচনং এতদপি যূযং শ্ৰুতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","কিন্ত্ৱহং যুষ্মান্ ৱদামি, যূযং ৰিপুৱ্ৱপি প্ৰেম কুৰুত, যে চ যুষ্মান্ শপন্তে, তান, আশিষং ৱদত, যে চ যুষ্মান্ ঋृতীযন্তে, তেষাং মঙ্গলং কুৰুত, যে চ যুষ্মান্ নিন্দন্তি, তাডযন্তি চ, তেষাং কৃতে প্ৰাৰ্থযধ্ৱং| ");
INSERT INTO sanasm_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","তত্ৰ যঃ সতামসতাঞ্চোপৰি প্ৰভাকৰম্ উদাযযতি, তথা ধাৰ্ম্মিকানামধাৰ্ম্মিকানাঞ্চোপৰি নীৰং ৱৰ্ষযতি তাদৃশো যো যুষ্মাকং স্ৱৰ্গস্থঃ পিতা, যূযং তস্যৈৱ সন্তানা ভৱিষ্যথ| ");
INSERT INTO sanasm_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","যে যুষ্মাসু প্ৰেম কুৰ্ৱ্ৱন্তি, যূযং যদি কেৱলং তেৱ্ৱেৱ প্ৰেম কুৰুথ, তৰ্হি যুষ্মাকং কিং ফলং ভৱিষ্যতি? চণ্ডালা অপি তাদৃশং কিং ন কুৰ্ৱ্ৱন্তি? ");
INSERT INTO sanasm_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","অপৰং যূযং যদি কেৱলং স্ৱীযভ্ৰাতৃৎৱেন নমত, তৰ্হি কিং মহৎ কৰ্ম্ম কুৰুথ? চণ্ডালা অপি তাদৃশং কিং ন কুৰ্ৱ্ৱন্তি? ");
INSERT INTO sanasm_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","তস্মাৎ যুষ্মাকং স্ৱৰ্গস্থঃ পিতা যথা পূৰ্ণো ভৱতি, যূযমপি তাদৃশা ভৱত| ");
INSERT INTO sanasm_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","সাৱধানা ভৱত, মনুজান্ দৰ্শযিতুং তেষাং গোচৰে ধৰ্ম্মকৰ্ম্ম মা কুৰুত, তথা কৃতে যুষ্মাকং স্ৱৰ্গস্থপিতুঃ সকাশাৎ কিঞ্চন ফলং ন প্ৰাপ্স্যথ| ");
INSERT INTO sanasm_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","ৎৱং যদা দদাসি তদা কপটিনো জনা যথা মনুজেভ্যঃ প্ৰশংসাং প্ৰাপ্তুং ভজনভৱনে ৰাজমাৰ্গে চ তূৰীং ৱাদযন্তি, তথা মা কুৰিु, অহং তুভ্যং যথাৰ্থং কথযামি, তে স্ৱকাযং ফলম্ অলভন্ত| ");
INSERT INTO sanasm_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","কিন্তু ৎৱং যদা দদাসি, তদা নিজদক্ষিণকৰো যৎ কৰোতি, তদ্ ৱামকৰং মা জ্ঞাপয| ");
INSERT INTO sanasm_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","তেন তৱ দানং গুপ্তং ভৱিষ্যতি যস্তু তৱ পিতা গুপ্তদৰ্শী, স প্ৰকাশ্য তুভ্যং ফলং দাস্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","অপৰং যদা প্ৰাৰ্থযসে, তদা কপটিনইৱ মা কুৰু, যস্মাৎ তে ভজনভৱনে ৰাজমাৰ্গস্য কোণে তিষ্ঠন্তো লোকান্ দৰ্শযন্তঃ প্ৰাৰ্থযিতুং প্ৰীযন্তে; অহং যুষ্মান্ তথ্যং ৱদামি, তে স্ৱকীযফলং প্ৰাপ্নুৱন্| ");
INSERT INTO sanasm_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","তস্মাৎ প্ৰাৰ্থনাকালে অন্তৰাগাৰং প্ৰৱিশ্য দ্ৱাৰং ৰুদ্ৱ্ৱা গুপ্তং পশ্যতস্তৱ পিতুঃ সমীপে প্ৰাৰ্থযস্ৱ; তেন তৱ যঃ পিতা গুপ্তদৰ্শী, স প্ৰকাশ্য তুভ্যং ফলং দাস্যতিl ");
INSERT INTO sanasm_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","অপৰং প্ৰাৰ্থনাকালে দেৱপূজকাইৱ মুধা পুনৰুক্তিং মা কুৰু, যস্মাৎ তে বোধন্তে, বহুৱাৰং কথাযাং কথিতাযাং তেষাং প্ৰাৰ্থনা গ্ৰাহিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","যূযং তেষামিৱ মা কুৰুত, যস্মাৎ যুষ্মাকং যদ্ যৎ প্ৰযোজনং যাচনাতঃ প্ৰাগেৱ যুষ্মাকং পিতা তৎ জানাতি| ");
INSERT INTO sanasm_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","অতএৱ যূযম ঈদৃক্ প্ৰাৰ্থযধ্ৱং, হে অস্মাকং স্ৱৰ্গস্থপিতঃ, তৱ নাম পূজ্যং ভৱতু| ");
INSERT INTO sanasm_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","তৱ ৰাজৎৱং ভৱতু; তৱেচ্ছা স্ৱৰ্গে যথা তথৈৱ মেদিন্যামপি সফলা ভৱতু| ");
INSERT INTO sanasm_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","অস্মাকং প্ৰযোজনীযম্ আহাৰম্ অদ্য দেহি| ");
INSERT INTO sanasm_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ৱযং যথা নিজাপৰাধিনঃ ক্ষমামহে, তথৈৱাস্মাকম্ অপৰাধান্ ক্ষমস্ৱ| ");
INSERT INTO sanasm_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","অস্মান্ পৰীক্ষাং মানয, কিন্তু পাপাত্মনো ৰক্ষ; ৰাজৎৱং গৌৰৱং পৰাক্ৰমঃ এতে সৰ্ৱ্ৱে সৰ্ৱ্ৱদা তৱ; তথাস্তু| ");
INSERT INTO sanasm_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","যদি যূযম্ অন্যেষাম্ অপৰাধান্ ক্ষমধ্ৱে তৰ্হি যুষ্মাকং স্ৱৰ্গস্থপিতাপি যুষ্মান্ ক্ষমিষ্যতে; ");
INSERT INTO sanasm_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","কিন্তু যদি যূযম্ অন্যেষাম্ অপৰাধান্ ন ক্ষমধ্ৱে, তৰ্হি যুষ্মাকং জনকোপি যুষ্মাকম্ অপৰাধান্ ন ক্ষমিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","অপৰম্ উপৱাসকালে কপটিনো জনা মানুষান্ উপৱাসং জ্ঞাপযিতুং স্ৱেষাং ৱদনানি ম্লানানি কুৰ্ৱ্ৱন্তি, যূযং তইৱ ৱিষণৱদনা মা ভৱত; অহং যুষ্মান্ তথ্যং ৱদামি তে স্ৱকীযফলম্ অলভন্ত| ");
INSERT INTO sanasm_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","যদা ৎৱম্ উপৱসসি, তদা যথা লোকৈস্ত্ৱং উপৱাসীৱ ন দৃশ্যসে, কিন্তু তৱ যোঽগোচৰঃ পিতা তেনৈৱ দৃশ্যসে, তৎকৃতে নিজশিৰসি তৈলং মৰ্দ্দয ৱদনঞ্চ প্ৰক্ষালয; ");
INSERT INTO sanasm_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","তেন তৱ যঃ পিতা গুপ্তদৰ্শী স প্ৰকাশ্য তুভ্যং ফলং দাস্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","অপৰং যত্ৰ স্থানে কীটাঃ কলঙ্কাশ্চ ক্ষযং নযন্তি, চৌৰাশ্চ সন্ধিং কৰ্ত্তযিৎৱা চোৰযিতুং শক্নুৱন্তি, তাদৃশ্যাং মেদিন্যাং স্ৱাৰ্থং ধনং মা সংচিনুত| ");
INSERT INTO sanasm_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","কিন্তু যত্ৰ স্থানে কীটাঃ কলঙ্কাশ্চ ক্ষযং ন নযন্তি, চৌৰাশ্চ সন্ধিং কৰ্ত্তযিৎৱা চোৰযিতুং ন শক্নুৱন্তি, তাদৃশে স্ৱৰ্গে ধনং সঞ্চিনুত| ");
INSERT INTO sanasm_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","যস্মাৎ যত্ৰ স্থানে যুষ্মাংক ধনং তত্ৰৈৱ খানে যুষ্মাকং মনাংসি| ");
INSERT INTO sanasm_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","লোচনং দেহস্য প্ৰদীপকং, তস্মাৎ যদি তৱ লোচনং প্ৰসন্নং ভৱতি, তৰ্হি তৱ কৃৎস্নং ৱপু ৰ্দীপ্তিযুক্তং ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","কিন্তু লোচনেঽপ্ৰসন্নে তৱ কৃৎস্নং ৱপুঃ তমিস্ৰযুক্তং ভৱিষ্যতি| অতএৱ যা দীপ্তিস্ত্ৱযি ৱিদ্যতে, সা যদি তমিস্ৰযুক্তা ভৱতি, তৰ্হি তৎ তমিস্ৰং কিযন্ মহৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","কোপি মনুজো দ্ৱৌ প্ৰভূ সেৱিতুং ন শক্নোতি, যস্মাদ্ একং সংমন্য তদন্যং ন সম্মন্যতে, যদ্ৱা একত্ৰ মনো নিধায তদন্যম্ অৱমন্যতে; তথা যূযমপীশ্ৱৰং লক্ষ্মীঞ্চেত্যুভে সেৱিতুং ন শক্নুথ| ");
INSERT INTO sanasm_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","অপৰম্ অহং যুষ্মভ্যং তথ্যং কথযামি, কিং ভক্ষিষ্যামঃ? কিং পাস্যামঃ? ইতি প্ৰাণধাৰণায মা চিন্তযত; কিং পৰিধাস্যামঃ? ইতি কাযৰক্ষণায ন চিন্তযত; ভক্ষ্যাৎ প্ৰাণা ৱসনাঞ্চ ৱপূংষি কিং শ্ৰেষ্ঠাণি ন হি? ");
INSERT INTO sanasm_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ৱিহাযসো ৱিহঙ্গমান্ ৱিলোকযত; তৈ ৰ্নোপ্যতে ন কৃত্যতে ভাণ্ডাগাৰে ন সঞ্চীযতেঽপি; তথাপি যুষ্মাকং স্ৱৰ্গস্থঃ পিতা তেভ্য আহাৰং ৱিতৰতি| ");
INSERT INTO sanasm_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","যূযং তেভ্যঃ কিং শ্ৰেষ্ঠা ন ভৱথ? যুষ্মাকং কশ্চিৎ মনুজঃ চিন্তযন্ নিজাযুষঃ ক্ষণমপি ৱৰ্দ্ধযিতুং শক্নোতি? ");
INSERT INTO sanasm_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","অপৰং ৱসনায কুতশ্চিন্তযত? ক্ষেত্ৰোৎপন্নানি পুষ্পাণি কথং ৱৰ্দ্ধন্তে তদালোচযত| তানি তন্তূন্ নোৎপাদযন্তি কিমপি কাৰ্য্যং ন কুৰ্ৱ্ৱন্তি; ");
INSERT INTO sanasm_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","তথাপ্যহং যুষ্মান্ ৱদামি, সুলেমান্ তাদৃগ্ ঐশ্ৱৰ্য্যৱানপি তৎপুষ্পমিৱ ৱিভূষিতো নাসীৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","তস্মাৎ ক্ষদ্য ৱিদ্যমানং শ্চঃ চুল্ল্যাং নিক্ষেপ্স্যতে তাদৃশং যৎ ক্ষেত্ৰস্থিতং কুসুমং তৎ যদীশ্চৰ ইত্থং বিভূষযতি, তৰ্হি হে স্তোকপ্ৰত্যযিনো যুষ্মান্ কিং ন পৰিধাপযিষ্যতি? ");
INSERT INTO sanasm_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","তস্মাৎ অস্মাভিঃ কিমৎস্যতে? কিঞ্চ পাযিষ্যতে? কিং ৱা পৰিধাযিষ্যতে, ইতি ন চিন্তযত| ");
INSERT INTO sanasm_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","যস্মাৎ দেৱাৰ্চ্চকা অপীতি চেষ্টন্তে; এতেষু দ্ৰৱ্যেষু প্ৰযোজনমস্তীতি যুষ্মাকং স্ৱৰ্গস্থঃ পিতা জানাতি| ");
INSERT INTO sanasm_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","অতএৱ প্ৰথমত ঈশ্ৱৰীযৰাজ্যং ধৰ্ম্মঞ্চ চেষ্টধ্ৱং, তত এতানি ৱস্তূনি যুষ্মভ্যং প্ৰদাযিষ্যন্তে| ");
INSERT INTO sanasm_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","শ্ৱঃ কৃতে মা চিন্তযত, শ্ৱএৱ স্ৱযং স্ৱমুদ্দিশ্য চিন্তযিষ্যতি; অদ্যতনী যা চিন্তা সাদ্যকৃতে প্ৰচুৰতৰা| ");
INSERT INTO sanasm_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","যথা যূযং দোষীকৃতা ন ভৱথ, তৎকৃতেঽন্যং দোষিণং মা কুৰুত| ");
INSERT INTO sanasm_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","যতো যাদৃশেন দোষেণ যূযং পৰান্ দোষিণঃ কুৰুথ, তাদৃশেন দোষেণ যূযমপি দোষীকৃতা ভৱিষ্যথ, অন্যঞ্চ যেন পৰিমাণেন যুষ্মাভিঃ পৰিমীযতে, তেনৈৱ পৰিমাণেন যুষ্মৎকৃতে পৰিমাযিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","অপৰঞ্চ নিজনযনে যা নাসা ৱিদ্যতে, তাম্ অনালোচ্য তৱ সহজস্য লোচনে যৎ তৃণম্ আস্তে, তদেৱ কুতো ৱীক্ষসে? ");
INSERT INTO sanasm_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","তৱ নিজলোচনে নাসাযাং ৱিদ্যমানাযাং, হে ভ্ৰাতঃ, তৱ নযনাৎ তৃণং বহিষ্যৰ্তুং অনুজানীহি, কথামেতাং নিজসহজায কথং কথযিতুং শক্নোষি? ");
INSERT INTO sanasm_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","হে কপটিন্, আদৌ নিজনযনাৎ নাসাং বহিষ্কুৰু ততো নিজদৃষ্টৌ সুপ্ৰসন্নাযাং তৱ ভ্ৰাতৃ ৰ্লোচনাৎ তৃণং বহিষ্কৰ্তুং শক্ষ্যসি| ");
INSERT INTO sanasm_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","অন্যঞ্চ সাৰমেযেভ্যঃ পৱিত্ৰৱস্তূনি মা ৱিতৰত, ৱৰাহাণাং সমক্ষঞ্চ মুক্তা মা নিক্ষিপত; নিক্ষেপণাৎ তে তাঃ সৰ্ৱ্ৱাঃ পদৈ ৰ্দলযিষ্যন্তি, পৰাৱৃত্য যুষ্মানপি ৱিদাৰযিষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","যাচধ্ৱং ততো যুষ্মভ্যং দাযিষ্যতে; মৃগযধ্ৱং তত উদ্দেশং লপ্স্যধ্ৱে; দ্ৱাৰম্ আহত, ততো যুষ্মৎকৃতে মুক্তং ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","যস্মাদ্ যেন যাচ্যতে, তেন লভ্যতে; যেন মৃগ্যতে তেনোদ্দেশঃ প্ৰাপ্যতে; যেন চ দ্ৱাৰম্ আহন্যতে, তৎকৃতে দ্ৱাৰং মোচ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","আত্মজেন পূপে প্ৰাৰ্থিতে তস্মৈ পাষাণং ৱিশ্ৰাণযতি, ");
INSERT INTO sanasm_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","মীনে যাচিতে চ তস্মৈ ভুজগং ৱিতৰতি, এতাদৃশঃ পিতা যুষ্মাকং মধ্যে ক আস্তে? ");
INSERT INTO sanasm_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","তস্মাদ্ যূযম্ অভদ্ৰাঃ সন্তোঽপি যদি নিজবালকেভ্য উত্তমং দ্ৰৱ্যং দাতুং জানীথ, তৰ্হি যুষ্মাকং স্ৱৰ্গস্থঃ পিতা স্ৱীযযাচকেভ্যঃ কিমুত্তমানি ৱস্তূনি ন দাস্যতি? ");
INSERT INTO sanasm_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","যূষ্মান্ প্ৰতীতৰেষাং যাদৃশো ৱ্যৱহাৰো যুষ্মাকং প্ৰিযঃ, যূযং তান্ প্ৰতি তাদৃশানেৱ ৱ্যৱহাৰান্ ৱিধত্ত; যস্মাদ্ ৱ্যৱস্থাভৱিষ্যদ্ৱাদিনাং ৱচনানাম্ ইতি সাৰম্| ");
INSERT INTO sanasm_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","সঙ্কীৰ্ণদ্ৱাৰেণ প্ৰৱিশত; যতো নৰকগমনায যদ্ দ্ৱাৰং তদ্ ৱিস্তীৰ্ণং যচ্চ ৱৰ্ত্ম তদ্ বৃহৎ তেন বহৱঃ প্ৰৱিশন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","অপৰং স্ৱৰ্গগমনায যদ্ দ্ৱাৰং তৎ কীদৃক্ সংকীৰ্ণং| যচ্চ ৱৰ্ত্ম তৎ কীদৃগ্ দুৰ্গমম্| তদুদ্দেষ্টাৰঃ কিযন্তোঽল্পাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","অপৰঞ্চ যে জনা মেষৱেশেন যুষ্মাকং সমীপম্ আগচ্ছন্তি, কিন্ত্ৱন্তৰ্দুৰন্তা ৱৃকা এতাদৃশেভ্যো ভৱিষ্যদ্ৱাদিভ্যঃ সাৱধানা ভৱত, যূযং ফলেন তান্ পৰিচেতুং শক্নুথ| ");
INSERT INTO sanasm_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","মনুজাঃ কিং কণ্টকিনো ৱৃক্ষাদ্ দ্ৰাক্ষাফলানি শৃগালকোলিতশ্চ উডুম্বৰফলানি শাতযন্তি? ");
INSERT INTO sanasm_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","তদ্ৱদ্ উত্তম এৱ পাদপ উত্তমফলানি জনযতি, অধমপাদপএৱাধমফলানি জনযতি| ");
INSERT INTO sanasm_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","কিন্তূত্তমপাদপঃ কদাপ্যধমফলানি জনযিতুং ন শক্নোতি, তথাধমোপি পাদপ উত্তমফলানি জনযিতুং ন শক্নোতি| ");
INSERT INTO sanasm_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","অপৰং যে যে পাদপা অধমফলানি জনযন্তি, তে কৃত্তা ৱহ্নৌ ক্ষিপ্যন্তে| ");
INSERT INTO sanasm_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","অতএৱ যূযং ফলেন তান্ পৰিচেষ্যথ| ");
INSERT INTO sanasm_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","যে জনা মাং প্ৰভুং ৱদন্তি, তে সৰ্ৱ্ৱে স্ৱৰ্গৰাজ্যং প্ৰৱেক্ষ্যন্তি তন্ন, কিন্তু যো মানৱো মম স্ৱৰ্গস্থস্য পিতুৰিষ্টং কৰ্ম্ম কৰোতি স এৱ প্ৰৱেক্ষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","তদ্ দিনে বহৱো মাং ৱদিষ্যন্তি, হে প্ৰভো হে প্ৰভো, তৱ নাম্না কিমস্মামি ৰ্ভৱিষ্যদ্ৱাক্যং ন ৱ্যাহৃতং? তৱ নাম্না ভূতাঃ কিং ন ত্যাজিতাঃ? তৱ নাম্না কিং নানাদ্ভুতানি কৰ্ম্মাণি ন কৃতানি? ");
INSERT INTO sanasm_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","তদাহং ৱদিষ্যামি, হে কুকৰ্ম্মকাৰিণো যুষ্মান্ অহং ন ৱেদ্মি, যূযং মৎসমীপাদ্ দূৰীভৱত| ");
INSERT INTO sanasm_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","যঃ কশ্চিৎ মমৈতাঃ কথাঃ শ্ৰুৎৱা পালযতি, স পাষাণোপৰি গৃহনিৰ্ম্মাত্ৰা জ্ঞানিনা সহ মযোপমীযতে| ");
INSERT INTO sanasm_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","যতো ৱৃষ্টৌ সত্যাম্ আপ্লাৱ আগতে ৱাযৌ ৱাতে চ তেষু তদ্গেহং লগ্নেষু পাষাণোপৰি তস্য ভিত্তেস্তন্ন পততিl ");
INSERT INTO sanasm_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","কিন্তু যঃ কশ্চিৎ মমৈতাঃ কথাঃ শ্ৰুৎৱা ন পালযতি স সৈকতে গেহনিৰ্ম্মাত্ৰা ঽজ্ঞানিনা উপমীযতে| ");
INSERT INTO sanasm_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","যতো জলৱৃষ্টৌ সত্যাম্ আপ্লাৱ আগতে পৱনে ৱাতে চ তৈ ৰ্গৃহে সমাঘাতে তৎ পততি তৎপতনং মহদ্ ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","যীশুনৈতেষু ৱাক্যেষু সমাপিতেষু মানৱাস্তদীযোপদেশম্ আশ্চৰ্য্যং মেনিৰে| ");
INSERT INTO sanasm_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","যস্মাৎ স উপাধ্যাযা ইৱ তান্ নোপদিদেশ কিন্তু সমৰ্থপুৰুষইৱ সমুপদিদেশ| ");
INSERT INTO sanasm_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","যদা স পৰ্ৱ্ৱতাদ্ অৱাৰোহৎ তদা বহৱো মানৱাস্তৎপশ্চাদ্ ৱৱ্ৰজুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","একঃ কুষ্ঠৱান্ আগত্য তং প্ৰণম্য বভাষে, হে প্ৰভো, যদি ভৱান্ সংমন্যতে, তৰ্হি মাং নিৰামযং কৰ্ত্তুং শক্নোতি| ");
INSERT INTO sanasm_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ততো যীশুঃ কৰং প্ৰসাৰ্য্য তস্যাঙ্গং স্পৃশন্ ৱ্যাজহাৰ, সম্মন্যেঽহং ৎৱং নিৰামযো ভৱ; তেন স তৎক্ষণাৎ কুষ্ঠেনামোচি| ");
INSERT INTO sanasm_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ততো যীশুস্তং জগাদ, অৱধেহি কথামেতাং কশ্চিদপি মা ব্ৰূহি, কিন্তু যাজকস্য সন্নিধিং গৎৱা স্ৱাত্মানং দৰ্শয মনুজেভ্যো নিজনিৰামযৎৱং প্ৰমাণযিতুং মূসানিৰূপিতং দ্ৰৱ্যম্ উৎসৃজ চ| ");
INSERT INTO sanasm_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","তদনন্তৰং যীশুনা কফৰ্নাহূম্নামনি নগৰে প্ৰৱিষ্টে কশ্চিৎ শতসেনাপতিস্তৎসমীপম্ আগত্য ৱিনীয বভাষে, ");
INSERT INTO sanasm_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","হে প্ৰভো, মদীয একো দাসঃ পক্ষাঘাতৱ্যাধিনা ভৃশং ৱ্যথিতঃ, সতু শযনীয আস্তে| ");
INSERT INTO sanasm_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","তদানীং যীশুস্তস্মৈ কথিতৱান্, অহং গৎৱা তং নিৰামযং কৰিষ্যামি| ");
INSERT INTO sanasm_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ততঃ স শতসেনাপতিঃ প্ৰত্যৱদৎ, হে প্ৰভো, ভৱান্ যৎ মম গেহমধ্যং যাতি তদ্যোগ্যভাজনং নাহমস্মি; ৱাঙ্মাত্ৰম্ আদিশতু, তেনৈৱ মম দাসো নিৰামযো ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","যতো মযি পৰনিধ্নেঽপি মম নিদেশৱশ্যাঃ কতি কতি সেনাঃ সন্তি, তত একস্মিন্ যাহীত্যুক্তে স যাতি, তদন্যস্মিন্ এহীত্যুক্তে স আযাতি, তথা মম নিজদাসে কৰ্ম্মৈতৎ কুৰ্ৱ্ৱিত্যুক্তে স তৎ কৰোতি| ");
INSERT INTO sanasm_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","তদানীং যীশুস্তস্যৈতৎ ৱচো নিশম্য ৱিস্মযাপন্নোঽভূৎ; নিজপশ্চাদ্গামিনো মানৱান্ অৱোচ্চ, যুষ্মান্ তথ্যং ৱচ্মি, ইস্ৰাযেলীযলোকানাং মধ্যেঽপি নৈতাদৃশো ৱিশ্ৱাসো মযা প্ৰাপ্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","অন্যচ্চাহং যুষ্মান্ ৱদামি, বহৱঃ পূৰ্ৱ্ৱস্যাঃ পশ্চিমাযাশ্চ দিশ আগত্য ইব্ৰাহীমা ইস্হাকা যাকূবা চ সাকম্ মিলিৎৱা সমুপৱেক্ষ্যন্তি; ");
INSERT INTO sanasm_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","কিন্তু যত্ৰ স্থানে ৰোদনদন্তঘৰ্ষণে ভৱতস্তস্মিন্ বহিৰ্ভূততমিস্ৰে ৰাজ্যস্য সন্তানা নিক্ষেস্যন্তে| ");
INSERT INTO sanasm_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","ততঃ পৰং যীশুস্তং শতসেনাপতিং জগাদ, যাহি, তৱ প্ৰতীত্যনুসাৰতো মঙ্গলং ভূযাৎ; তদা তস্মিন্নেৱ দণ্ডে তদীযদাসো নিৰামযো বভূৱ| ");
INSERT INTO sanasm_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","অনন্তৰং যীশুঃ পিতৰস্য গেহমুপস্থায জ্ৱৰেণ পীডিতাং শযনীযস্থিতাং তস্য শ্ৱশ্ৰূং ৱীক্ষাঞ্চক্ৰে| ");
INSERT INTO sanasm_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ততস্তেন তস্যাঃ কৰস্য স্পৃষ্টতৱাৎ জ্ৱৰস্তাং তত্যাজ, তদা সা সমুত্থায তান্ সিষেৱে| ");
INSERT INTO sanasm_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","অনন্তৰং সন্ধ্যাযাং সত্যাং বহুশো ভূতগ্ৰস্তমনুজান্ তস্য সমীপম্ আনিন্যুঃ স চ ৱাক্যেন ভূতান্ ত্যাজযামাস, সৰ্ৱ্ৱপ্ৰকাৰপীডিতজনাংশ্চ নিৰামযান্ চকাৰ; ");
INSERT INTO sanasm_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","তস্মাৎ, সৰ্ৱ্ৱা দুৰ্ব্বলতাস্মাকং তেনৈৱ পৰিধাৰিতা| অস্মাকং সকলং ৱ্যাধিং সএৱ সংগৃহীতৱান্| যদেতদ্ৱচনং যিশযিযভৱিষ্যদ্ৱাদিনোক্তমাসীৎ, তত্তদা সফলমভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","অনন্তৰং যীশুশ্চতুৰ্দিক্ষু জননিৱহং ৱিলোক্য তটিন্যাঃ পাৰং যাতুং শিষ্যান্ আদিদেশ| ");
INSERT INTO sanasm_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","তদানীম্ এক উপাধ্যায আগত্য কথিতৱান্, হে গুৰো, ভৱান্ যত্ৰ যাস্যতি তত্ৰাহমপি ভৱতঃ পশ্চাদ্ যাস্যামি| ");
INSERT INTO sanasm_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ততো যীশু ৰ্জগাদ, ক্ৰোষ্টুঃ স্থাতুং স্থানং ৱিদ্যতে, ৱিহাযসো ৱিহঙ্গমানাং নীডানি চ সন্তি; কিন্তু মনুষ্যপুত্ৰস্য শিৰঃ স্থাপযিতুং স্থানং ন ৱিদ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","অনন্তৰম্ অপৰ একঃ শিষ্যস্তং বভাষে, হে প্ৰভো, প্ৰথমতো মম পিতৰং শ্মশানে নিধাতুং গমনাৰ্থং মাম্ অনুমন্যস্ৱ| ");
INSERT INTO sanasm_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ততো যীশুৰুক্তৱান্ মৃতা মৃতান্ শ্মশানে নিদধতু, ৎৱং মম পশ্চাদ্ আগচ্ছ| ");
INSERT INTO sanasm_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","অনন্তৰং তস্মিন্ নাৱমাৰূঢে তস্য শিষ্যাস্তৎপশ্চাৎ জগ্মুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","পশ্চাৎ সাগৰস্য মধ্যং তেষু গতেষু তাদৃশঃ প্ৰবলো ঝঞ্ভ্শনিল উদতিষ্ঠৎ, যেন মহাতৰঙ্গ উত্থায তৰণিং ছাদিতৱান্, কিন্তু স নিদ্ৰিত আসীৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","তদা শিষ্যা আগত্য তস্য নিদ্ৰাভঙ্গং কৃৎৱা কথযামাসুঃ, হে প্ৰভো, ৱযং ম্ৰিযামহে, ভৱান্ অস্মাকং প্ৰাণান্ ৰক্ষতু| ");
INSERT INTO sanasm_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","তদা স তান্ উক্তৱান্, হে অল্পৱিশ্ৱাসিনো যূযং কুতো ৱিভীথ? ততঃ স উত্থায ৱাতং সাগৰঞ্চ তৰ্জযামাস, ততো নিৰ্ৱ্ৱাতমভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","অপৰং মনুজা ৱিস্মযং ৱিলোক্য কথযামাসুঃ, অহো ৱাতসৰিৎপতী অস্য কিমাজ্ঞাগ্ৰাহিণৌ? কীদৃশোঽযং মানৱঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","অনন্তৰং স পাৰং গৎৱা গিদেৰীযদেশম্ উপস্থিতৱান্; তদা দ্ৱৌ ভূতগ্ৰস্তমনুজৌ শ্মশানস্থানাদ্ বহি ৰ্ভূৎৱা তং সাক্ষাৎ কৃতৱন্তৌ, তাৱেতাদৃশৌ প্ৰচণ্ডাৱাস্তাং যৎ তেন স্থানেন কোপি যাতুং নাশক্নোৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","তাৱুচৈঃ কথযামাসতুঃ, হে ঈশ্ৱৰস্য সূনো যীশো, ৎৱযা সাকম্ আৱযোঃ কঃ সম্বন্ধঃ? নিৰূপিতকালাৎ প্ৰাগেৱ কিমাৱাভ্যাং যাতনাং দাতুম্ অত্ৰাগতোসি? ");
INSERT INTO sanasm_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","তদানীং তাভ্যাং কিঞ্চিদ্ দূৰে ৱৰাহাণাম্ একো মহাৱ্ৰজোঽচৰৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ততো ভূতৌ তৌ তস্যান্তিকে ৱিনীয কথযামাসতুঃ, যদ্যাৱাং ত্যাজযসি, তৰ্হি ৱৰাহাণাং মধ্যেৱ্ৰজম্ আৱাং প্ৰেৰয| ");
INSERT INTO sanasm_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","তদা যীশুৰৱদৎ যাতং, অনন্তৰং তৌ যদা মনুজৌ ৱিহায ৱৰাহান্ আশ্ৰিতৱন্তৌ, তদা তে সৰ্ৱ্ৱে ৱৰাহা উচ্চস্থানাৎ মহাজৱেন ধাৱন্তঃ সাগৰীযতোযে মজ্জন্তো মম্ৰুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ততো ৱৰাহৰক্ষকাঃ পলাযমানা মধ্যেনগৰং তৌ ভূতগ্ৰস্তৌ প্ৰতি যদ্যদ্ অঘটত, তাঃ সৰ্ৱ্ৱৱাৰ্ত্তা অৱদন্| ");
INSERT INTO sanasm_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ততো নাগৰিকাঃ সৰ্ৱ্ৱে মনুজা যীশুং সাক্ষাৎ কৰ্ত্তুং বহিৰাযাতাঃ তঞ্চ ৱিলোক্য প্ৰাৰ্থযাঞ্চক্ৰিৰে ভৱান্ অস্মাকং সীমাতো যাতু| ");
INSERT INTO sanasm_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","অনন্তৰং যীশু ৰ্নৌকামাৰুহ্য পুনঃ পাৰমাগত্য নিজগ্ৰামম্ আযযৌ| ");
INSERT INTO sanasm_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ততঃ কতিপযা জনা একং পক্ষাঘাতিনং স্ৱট্টোপৰি শাযযিৎৱা তৎসমীপম্ আনযন্; ততো যীশুস্তেষাং প্ৰতীতিং ৱিজ্ঞায তং পক্ষাঘাতিনং জগাদ, হে পুত্ৰ, সুস্থিৰো ভৱ, তৱ কলুষস্য মৰ্ষণং জাতম্| ");
INSERT INTO sanasm_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","তাং কথাং নিশম্য কিযন্ত উপাধ্যাযা মনঃসু চিন্তিতৱন্ত এষ মনুজ ঈশ্ৱৰং নিন্দতি| ");
INSERT INTO sanasm_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ততঃ স তেষাম্ এতাদৃশীং চিন্তাং ৱিজ্ঞায কথিতৱান্, যূযং মনঃসু কৃত এতাদৃশীং কুচিন্তাং কুৰুথ? ");
INSERT INTO sanasm_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","তৱ পাপমৰ্ষণং জাতং, যদ্ৱা ৎৱমুত্থায গচ্ছ, দ্ৱযোৰনযো ৰ্ৱাক্যযোঃ কিং ৱাক্যং ৱক্তুং সুগমং? ");
INSERT INTO sanasm_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","কিন্তু মেদিন্যাং কলুষং ক্ষমিতুং মনুজসুতস্য সামৰ্থ্যমস্তীতি যূযং যথা জানীথ, তদৰ্থং স তং পক্ষাঘাতিনং গদিতৱান্, উত্তিষ্ঠ, নিজশযনীযং আদায গেহং গচ্ছ| ");
INSERT INTO sanasm_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ততঃ স তৎক্ষণাদ্ উত্থায নিজগেহং প্ৰস্থিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","মানৱা ইত্থং ৱিলোক্য ৱিস্মযং মেনিৰে, ঈশ্ৱৰেণ মানৱায সামৰ্থ্যম্ ঈদৃশং দত্তং ইতি কাৰণাৎ তং ধন্যং বভাষিৰে চ| ");
INSERT INTO sanasm_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","অনন্তৰং যীশুস্তৎস্থানাদ্ গচ্ছন্ গচ্ছন্ কৰসংগ্ৰহস্থানে সমুপৱিষ্টং মথিনামানম্ একং মনুজং ৱিলোক্য তং বভাষে, মম পশ্চাদ্ আগচ্ছ, ততঃ স উত্থায তস্য পশ্চাদ্ ৱৱ্ৰাজ| ");
INSERT INTO sanasm_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ততঃ পৰং যীশৌ গৃহে ভোক্তুম্ উপৱিষ্টে বহৱঃ কৰসংগ্ৰাহিণঃ কলুষিণশ্চ মানৱা আগত্য তেন সাকং তস্য শিষ্যৈশ্চ সাকম্ উপৱিৱিশুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ফিৰূশিনস্তদ্ দৃষ্ট্ৱা তস্য শিষ্যান্ বভাষিৰে, যুষ্মাকং গুৰুঃ কিং নিমিত্তং কৰসংগ্ৰাহিভিঃ কলুষিভিশ্চ সাকং ভুংক্তে? ");
INSERT INTO sanasm_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","যীশুস্তৎ শ্ৰুৎৱা তান্ প্ৰত্যৱদৎ, নিৰামযলোকানাং চিকিৎসকেন প্ৰযোজনং নাস্তি, কিন্তু সামযলোকানাং প্ৰযোজনমাস্তে| ");
INSERT INTO sanasm_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","অতো যূযং যাৎৱা ৱচনস্যাস্যাৰ্থং শিক্ষধ্ৱম্, দযাযাং মে যথা প্ৰীতি ৰ্ন তথা যজ্ঞকৰ্ম্মণি| যতোঽহং ধাৰ্ম্মিকান্ আহ্ৱাতুং নাগতোঽস্মি কিন্তু মনঃ পৰিৱৰ্ত্তযিতুং পাপিন আহ্ৱাতুম্ আগতোঽস্মি| ");
INSERT INTO sanasm_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","অনন্তৰং যোহনঃ শিষ্যাস্তস্য সমীপম্ আগত্য কথযামাসুঃ, ফিৰূশিনো ৱযঞ্চ পুনঃ পুনৰুপৱসামঃ, কিন্তু তৱ শিষ্যা নোপৱসন্তি, কুতঃ? ");
INSERT INTO sanasm_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","তদা যীশুস্তান্ অৱোচৎ যাৱৎ সখীনাং সংঙ্গে কন্যাযা ৱৰস্তিষ্ঠতি, তাৱৎ কিং তে ৱিলাপং কৰ্ত্তুং শক্লুৱন্তি? কিন্তু যদা তেষাং সংঙ্গাদ্ ৱৰং নযন্তি, তাদৃশঃ সময আগমিষ্যতি, তদা তে উপৱৎস্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","পুৰাতনৱসনে কোপি নৱীনৱস্ত্ৰং ন যোজযতি, যস্মাৎ তেন যোজিতেন পুৰাতনৱসনং ছিনত্তি তচ্ছিদ্ৰঞ্চ বহুকুৎসিতং দৃশ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","অন্যঞ্চ পুৰাতনকুৎৱাং কোপি নৱানগোস্তনীৰসং ন নিদধাতি, যস্মাৎ তথা কৃতে কুতূ ৰ্ৱিদীৰ্য্যতে তেন গোস্তনীৰসঃ পততি কুতূশ্চ নশ্যতি; তস্মাৎ নৱীনাযাং কুৎৱাং নৱীনো গোস্তনীৰসঃ স্থাপ্যতে, তেন দ্ৱযোৰৱনং ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","অপৰং তেনৈতৎকথাকথনকালে একোঽধিপতিস্তং প্ৰণম্য বভাষে, মম দুহিতা প্ৰাযেণৈতাৱৎকালে মৃতা, তস্মাদ্ ভৱানাগত্য তস্যা গাত্ৰে হস্তমৰ্পযতু, তেন সা জীৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","তদানীং যীশুঃ শিষ্যৈঃ সাকম্ উত্থায তস্য পশ্চাদ্ ৱৱ্ৰাজ| ");
INSERT INTO sanasm_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ইত্যনন্তৰে দ্ৱাদশৱৎসৰান্ যাৱৎ প্ৰদৰামযেন শীৰ্ণৈকা নাৰী তস্য পশ্চাদ্ আগত্য তস্য ৱসনস্য গ্ৰন্থিং পস্পৰ্শ; ");
INSERT INTO sanasm_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","যস্মাৎ মযা কেৱলং তস্য ৱসনং স্পৃষ্ট্ৱা স্ৱাস্থ্যং প্ৰাপ্স্যতে, সা নাৰীতি মনসি নিশ্চিতৱতী| ");
INSERT INTO sanasm_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ততো যীশুৰ্ৱদনং পৰাৱৰ্ত্ত্য তাং জগাদ, হে কন্যে, ৎৱং সুস্থিৰা ভৱ, তৱ ৱিশ্ৱাসস্ত্ৱাং স্ৱস্থামকাৰ্ষীৎ| এতদ্ৱাক্যে গদিতএৱ সা যোষিৎ স্ৱস্থাভূৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","অপৰং যীশুস্তস্যাধ্যক্ষস্য গেহং গৎৱা ৱাদকপ্ৰভৃতীন্ বহূন্ লোকান্ শব্দাযমানান্ ৱিলোক্য তান্ অৱদৎ, ");
INSERT INTO sanasm_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","পন্থানং ত্যজ, কন্যেযং নাম্ৰিযত নিদ্ৰিতাস্তে; কথামেতাং শ্ৰুৎৱা তে তমুপজহসুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","কিন্তু সৰ্ৱ্ৱেষু বহিষ্কৃতেষু সোঽভ্যন্তৰং গৎৱা কন্যাযাঃ কৰং ধৃতৱান্, তেন সোদতিষ্ঠৎ; ");
INSERT INTO sanasm_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ততস্তৎকৰ্ম্মণো যশঃ কৃৎস্নং তং দেশং ৱ্যাপ্তৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","ততঃ পৰং যীশুস্তস্মাৎ স্থানাদ্ যাত্ৰাং চকাৰ; তদা হে দাযূদঃ সন্তান, অস্মান্ দযস্ৱ, ইতি ৱদন্তৌ দ্ৱৌ জনাৱন্ধৌ প্ৰোচৈৰাহূযন্তৌ তৎপশ্চাদ্ ৱৱ্ৰজতুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ততো যীশৌ গেহমধ্যং প্ৰৱিষ্টং তাৱপি তস্য সমীপম্ উপস্থিতৱন্তৌ, তদানীং স তৌ পৃষ্টৱান্ কৰ্ম্মৈতৎ কৰ্ত্তুং মম সামৰ্থ্যম্ আস্তে, যুৱাং কিমিতি প্ৰতীথঃ? তদা তৌ প্ৰত্যূচতুঃ, সত্যং প্ৰভো| ");
INSERT INTO sanasm_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","তদানীং স তযো ৰ্লোচনানি স্পৃশন্ বভাষে, যুৱযোঃ প্ৰতীত্যনুসাৰাদ্ যুৱযো ৰ্মঙ্গলং ভূযাৎ| তেন তৎক্ষণাৎ তযো ৰ্নেত্ৰাণি প্ৰসন্নান্যভৱন্, ");
INSERT INTO sanasm_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","পশ্চাদ্ যীশুস্তৌ দৃঢমাজ্ঞাপ্য জগাদ, অৱধত্তম্ এতাং কথাং কোপি মনুজো ম জানীযাৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","কিন্তু তৌ প্ৰস্থায তস্মিন্ কৃৎস্নে দেশে তস্য কীৰ্ত্তিং প্ৰকাশযামাসতুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","অপৰং তৌ বহিৰ্যাত এতস্মিন্নন্তৰে মনুজা একং ভূতগ্ৰস্তমূকং তস্য সমীপম্ আনীতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","তেন ভূতে ত্যাজিতে স মূকঃ কথাং কথযিতুং প্ৰাৰভত, তেন জনা ৱিস্মযং ৱিজ্ঞায কথযামাসুঃ, ইস্ৰাযেলো ৱংশে কদাপি নেদৃগদৃশ্যত; ");
INSERT INTO sanasm_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","কিন্তু ফিৰূশিনঃ কথযাঞ্চক্ৰুঃ ভূতাধিপতিনা স ভূতান্ ত্যাজযতি| ");
INSERT INTO sanasm_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ততঃ পৰং যীশুস্তেষাং ভজনভৱন উপদিশন্ ৰাজ্যস্য সুসংৱাদং প্ৰচাৰযন্ লোকানাং যস্য য আমযো যা চ পীডাসীৎ, তান্ শমযন্ শমযংশ্চ সৰ্ৱ্ৱাণি নগৰাণি গ্ৰামাংশ্চ বভ্ৰাম| ");
INSERT INTO sanasm_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","অন্যঞ্চ মনুজান্ ৱ্যাকুলান্ অৰক্ষকমেষানিৱ চ ত্যক্তান্ নিৰীক্ষ্য তেষু কাৰুণিকঃ সন্ শিষ্যান্ অৱদৎ, ");
INSERT INTO sanasm_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","শস্যানি প্ৰচুৰাণি সন্তি, কিন্তু ছেত্তাৰঃ স্তোকাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ক্ষেত্ৰং প্ৰত্যপৰান্ ছেদকান্ প্ৰহেতুং শস্যস্ৱামিনং প্ৰাৰ্থযধ্ৱম্| ");
INSERT INTO sanasm_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","অনন্তৰং যীশু ৰ্দ্ৱাদশশিষ্যান্ আহূযামেধ্যভূতান্ ত্যাজযিতুং সৰ্ৱ্ৱপ্ৰকাৰৰোগান্ পীডাশ্চ শমযিতুং তেভ্যঃ সামৰ্থ্যমদাৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","তেষাং দ্ৱাদশপ্ৰেষ্যাণাং নামান্যেতানি| প্ৰথমং শিমোন্ যং পিতৰং ৱদন্তি, ততঃ পৰং তস্য সহজ আন্দ্ৰিযঃ, সিৱদিযস্য পুত্ৰো যাকূব্ ");
INSERT INTO sanasm_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","তস্য সহজো যোহন্; ফিলিপ্ বৰ্থলময্ থোমাঃ কৰসংগ্ৰাহী মথিঃ, আল্ফেযপুত্ৰো যাকূব্, ");
INSERT INTO sanasm_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","কিনানীযঃ শিমোন্, য ঈষ্কৰিযোতীযযিহূদাঃ খ্ৰীষ্টং পৰকৰেঽৰ্পযৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","এতান্ দ্ৱাদশশিষ্যান্ যীশুঃ প্ৰেষযন্ ইত্যাজ্ঞাপযৎ, যূযম্ অন্যদেশীযানাং পদৱীং শেমিৰোণীযানাং কিমপি নগৰঞ্চ ন প্ৰৱিশ্যে ");
INSERT INTO sanasm_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ইস্ৰাযেল্গোত্ৰস্য হাৰিতা যে যে মেষাস্তেষামেৱ সমীপং যাত| ");
INSERT INTO sanasm_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","গৎৱা গৎৱা স্ৱৰ্গস্য ৰাজৎৱং সৱিধমভৱৎ, এতাং কথাং প্ৰচাৰযত| ");
INSERT INTO sanasm_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","আমযগ্ৰস্তান্ স্ৱস্থান্ কুৰুত, কুষ্ঠিনঃ পৰিষ্কুৰুত, মৃতলোকান্ জীৱযত, ভূতান্ ত্যাজযত, ৱিনা মূল্যং যূযম্ অলভধ্ৱং ৱিনৈৱ মূল্যং ৱিশ্ৰাণযত| ");
INSERT INTO sanasm_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","কিন্তু স্ৱেষাং কটিবন্ধেষু স্ৱৰ্ণৰূপ্যতাম্ৰাণাং কিমপি ন গৃহ্লীত| ");
INSERT INTO sanasm_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","অন্যচ্চ যাত্ৰাযৈ চেলসম্পুটং ৱা দ্ৱিতীযৱসনং ৱা পাদুকে ৱা যষ্টিঃ, এতান্ মা গৃহ্লীত, যতঃ কাৰ্য্যকৃৎ ভৰ্ত্তুং যোগ্যো ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","অপৰং যূযং যৎ পুৰং যঞ্চ গ্ৰামং প্ৰৱিশথ, তত্ৰ যো জনো যোগ্যপাত্ৰং তমৱগত্য যানকালং যাৱৎ তত্ৰ তিষ্ঠত| ");
INSERT INTO sanasm_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","যদা যূযং তদ্গেহং প্ৰৱিশথ, তদা তমাশিষং ৱদত| ");
INSERT INTO sanasm_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","যদি স যোগ্যপাত্ৰং ভৱতি, তৰ্হি তৎকল্যাণং তস্মৈ ভৱিষ্যতি, নোচেৎ সাশীৰ্যুষ্মভ্যমেৱ ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","কিন্তু যে জনা যুষ্মাকমাতিথ্যং ন ৱিদধতি যুষ্মাকং কথাঞ্চ ন শৃণ্ৱন্তি তেষাং গেহাৎ পুৰাদ্ৱা প্ৰস্থানকালে স্ৱপদূলীঃ পাতযত| ");
INSERT INTO sanasm_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","যুষ্মানহং তথ্যং ৱচ্মি ৱিচাৰদিনে তৎপুৰস্য দশাতঃ সিদোমমোৰাপুৰযোৰ্দশা সহ্যতৰা ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","পশ্যত, ৱৃকযূথমধ্যে মেষঃ যথাৱিস্তথা যুষ্মান প্ৰহিণোমি, তস্মাদ্ যূযম্ অহিৰিৱ সতৰ্কাঃ কপোতাইৱাহিংসকা ভৱত| ");
INSERT INTO sanasm_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","নৃভ্যঃ সাৱধানা ভৱত; যতস্তৈ ৰ্যূযং ৰাজসংসদি সমৰ্পিষ্যধ্ৱে তেষাং ভজনগেহে প্ৰহাৰিষ্যধ্ৱে| ");
INSERT INTO sanasm_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","যূযং মন্নামহেতোঃ শাস্তৃণাং ৰাজ্ঞাঞ্চ সমক্ষং তানন্যদেশিনশ্চাধি সাক্ষিৎৱাৰ্থমানেষ্যধ্ৱে| ");
INSERT INTO sanasm_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","কিন্ত্ৱিত্থং সমৰ্পিতা যূযং কথং কিমুত্তৰং ৱক্ষ্যথ তত্ৰ মা চিন্তযত, যতস্তদা যুষ্মাভি ৰ্যদ্ ৱক্তৱ্যং তৎ তদ্দণ্ডে যুষ্মন্মনঃ সু সমুপস্থাস্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","যস্মাৎ তদা যো ৱক্ষ্যতি স ন যূযং কিন্তু যুষ্মাকমন্তৰস্থঃ পিত্ৰাত্মা| ");
INSERT INTO sanasm_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","সহজঃ সহজং তাতঃ সুতঞ্চ মৃতৌ সমৰ্পযিষ্যতি, অপত্যাগি স্ৱস্ৱপিত্ৰোे ৰ্ৱিপক্ষীভূয তৌ ঘাতযিষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","মন্নমহেতোঃ সৰ্ৱ্ৱে জনা যুষ্মান্ ঋृতীযিষ্যন্তে, কিন্তু যঃ শেষং যাৱদ্ ধৈৰ্য্যং ঘৃৎৱা স্থাস্যতি, স ত্ৰাযিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","তৈ ৰ্যদা যূযমেকপুৰে তাডিষ্যধ্ৱে, তদা যূযমন্যপুৰং পলাযধ্ৱং যুষ্মানহং তথ্যং ৱচ্মি যাৱন্মনুজসুতো নৈতি তাৱদ্ ইস্ৰাযেল্দেশীযসৰ্ৱ্ৱনগৰভ্ৰমণং সমাপযিতুং ন শক্ষ্যথ| ");
INSERT INTO sanasm_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","গুৰোঃ শিষ্যো ন মহান্, প্ৰভোৰ্দাসো ন মহান্| ");
INSERT INTO sanasm_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","যদি শিষ্যো নিজগুৰো ৰ্দাসশ্চ স্ৱপ্ৰভোঃ সমানো ভৱতি তৰ্হি তদ্ যথেষ্টং| চেত্তৈৰ্গৃহপতিৰ্ভূতৰাজ উচ্যতে, তৰ্হি পৰিৱাৰাঃ কিং তথা ন ৱক্ষ্যন্তে? ");
INSERT INTO sanasm_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","কিন্তু তেভ্যো যূযং মা বিভীত, যতো যন্ন প্ৰকাশিষ্যতে, তাদৃক্ ছাদিতং কিমপি নাস্তি, যচ্চ ন ৱ্যঞ্চিষ্যতে, তাদৃগ্ গুপ্তং কিমপি নাস্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","যদহং যুষ্মান্ তমসি ৱচ্মি তদ্ যুষ্মাভিৰ্দীপ্তৌ কথ্যতাং; কৰ্ণাভ্যাং যৎ শ্ৰূযতে তদ্ গেহোপৰি প্ৰচাৰ্য্যতাং| ");
INSERT INTO sanasm_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","যে কাযং হন্তুং শক্নুৱন্তি নাত্মানং, তেভ্যো মা ভৈষ্ট; যঃ কাযাত্মানৌ নিৰযে নাশযিতুং, শক্নোতি, ততো বিভীত| ");
INSERT INTO sanasm_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","দ্ৱৌ চটকৌ কিমেকতাম্ৰমুদ্ৰযা ন ৱিক্ৰীযেতে? তথাপি যুষ্মত্তাতানুমতিং ৱিনা তেষামেকোপি ভুৱি ন পততি| ");
INSERT INTO sanasm_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","যুষ্মচ্ছিৰসাং সৰ্ৱ্ৱকচা গণিতাংঃ সন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","অতো মা বিভীত, যূযং বহুচটকেভ্যো বহুমূল্যাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","যো মনুজসাক্ষান্মামঙ্গীকুৰুতে তমহং স্ৱৰ্গস্থতাতসাক্ষাদঙ্গীকৰিষ্যে| ");
INSERT INTO sanasm_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","পৃথ্ৱ্যামহং শান্তিং দাতুমাগতইতি মানুভৱত, শান্তিং দাতুং ন কিন্ত্ৱসিং| ");
INSERT INTO sanasm_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","পিতৃমাতৃশ্চশ্ৰূভিঃ সাকং সুতসুতাবধূ ৰ্ৱিৰোধযিতুঞ্চাগতেाস্মি| ");
INSERT INTO sanasm_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","ততঃ স্ৱস্ৱপৰিৱাৰএৱ নৃশত্ৰু ৰ্ভৱিতা| ");
INSERT INTO sanasm_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","যঃ পিতৰি মাতৰি ৱা মত্তোধিকং প্ৰীযতে, স ন মদৰ্হঃ; ");
INSERT INTO sanasm_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","যশ্চ সুতে সুতাযাং ৱা মত্তোধিকং প্ৰীযতে, সেाপি ন মদৰ্হঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","যঃ স্ৱক্ৰুশং গৃহ্লন্ মৎপশ্চান্নৈতি, সেाপি ন মদৰ্হঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","যঃ স্ৱপ্ৰাণানৱতি, স তান্ হাৰযিষ্যতে, যস্তু মৎকৃতে স্ৱপ্ৰাণান্ হাৰযতি, স তানৱতি| ");
INSERT INTO sanasm_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","যো যুষ্মাকমাতিথ্যং ৱিদধাতি, স মমাতিথ্যং ৱিদধাতি, যশ্চ মমাতিথ্যং ৱিদধাতি, স মৎপ্ৰেৰকস্যাতিথ্যং ৱিদধাতি| ");
INSERT INTO sanasm_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","যো ভৱিষ্যদ্ৱাদীতি জ্ঞাৎৱা তস্যাতিথ্যং ৱিধত্তে, স ভৱিষ্যদ্ৱাদিনঃ ফলং লপ্স্যতে, যশ্চ ধাৰ্ম্মিক ইতি ৱিদিৎৱা তস্যাতিথ্যং ৱিধত্তে স ধাৰ্ম্মিকমানৱস্য ফলং প্ৰাপ্স্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","যশ্চ কশ্চিৎ এতেষাং ক্ষুদ্ৰনৰাণাম্ যং কঞ্চনৈকং শিষ্য ইতি ৱিদিৎৱা কংসৈকং শীতলসলিলং তস্মৈ দত্তে, যুষ্মানহং তথ্যং ৱদামি, স কেনাপি প্ৰকাৰেণ ফলেন ন ৱঞ্চিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ইত্থং যীশুঃ স্ৱদ্ৱাদশশিষ্যাণামাজ্ঞাপনং সমাপ্য পুৰে পুৰ উপদেষ্টুং সুসংৱাদং প্ৰচাৰযিতুং তৎস্থানাৎ প্ৰতস্থে| ");
INSERT INTO sanasm_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","অনন্তৰং যোহন্ কাৰাযাং তিষ্ঠন্ খ্ৰিষ্টস্য কৰ্ম্মণাং ৱাৰ্ত্তং প্ৰাপ্য যস্যাগমনৱাৰ্ত্তাসীৎ সএৱ কিং ৎৱং? ৱা ৱযমন্যম্ অপেক্ষিষ্যামহে? ");
INSERT INTO sanasm_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","এতৎ প্ৰষ্টুং নিজৌ দ্ৱৌ শিষ্যৌ প্ৰাহিণোৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","যীশুঃ প্ৰত্যৱোচৎ, অন্ধা নেত্ৰাণি লভন্তে, খঞ্চা গচ্ছন্তি, কুষ্ঠিনঃ স্ৱস্থা ভৱন্তি, বধিৰাঃ শৃণ্ৱন্তি, মৃতা জীৱন্ত উত্তিষ্ঠন্তি, দৰিদ্ৰাণাং সমীপে সুসংৱাদঃ প্ৰচাৰ্য্যত, ");
INSERT INTO sanasm_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","এতানি যদ্যদ্ যুৱাং শৃণুথঃ পশ্যথশ্চ গৎৱা তদ্ৱাৰ্ত্তাং যোহনং গদতং| ");
INSERT INTO sanasm_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","যস্যাহং ন ৱিঘ্নীভৱামি, সএৱ ধন্যঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","অনন্তৰং তযোঃ প্ৰস্থিতযো ৰ্যীশু ৰ্যোহনম্ উদ্দিশ্য জনান্ জগাদ, যূযং কিং দ্ৰষ্টুং ৱহিৰ্মধ্যেপ্ৰান্তৰম্ অগচ্ছত? কিং ৱাতেন কম্পিতং নলং? ");
INSERT INTO sanasm_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","ৱা কিং ৱীক্ষিতুং ৱহিৰ্গতৱন্তঃ? কিং পৰিহিতসূক্ষ্মৱসনং মনুজমেকং? পশ্যত, যে সূক্ষ্মৱসনানি পৰিদধতি, তে ৰাজধান্যাং তিষ্ঠন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","তৰ্হি যূযং কিং দ্ৰষ্টুং বহিৰগমত, কিমেকং ভৱিষ্যদ্ৱাদিনং? তদেৱ সত্যং| যুষ্মানহং ৱদামি, স ভৱিষ্যদ্ৱাদিনোপি মহান্; ");
INSERT INTO sanasm_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","যতঃ, পশ্য স্ৱকীযদূতোযং ৎৱদগ্ৰে প্ৰেষ্যতে মযা| স গৎৱা তৱ পন্থানং স্মযক্ পৰিষ্কৰিষ্যতি|| এতদ্ৱচনং যমধি লিখিতমাস্তে সোঽযং যোহন্| ");
INSERT INTO sanasm_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","অপৰং যুষ্মানহং তথ্যং ব্ৰৱীমি, মজ্জযিতু ৰ্যোহনঃ শ্ৰেষ্ঠঃ কোপি নাৰীতো নাজাযত; তথাপি স্ৱৰ্গৰাজ্যমধ্যে সৰ্ৱ্ৱেভ্যো যঃ ক্ষুদ্ৰঃ স যোহনঃ শ্ৰেষ্ঠঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","অপৰঞ্চ আ যোহনোঽদ্য যাৱৎ স্ৱৰ্গৰাজ্যং বলাদাক্ৰান্তং ভৱতি আক্ৰমিনশ্চ জনা বলেন তদধিকুৰ্ৱ্ৱন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","যতো যোহনং যাৱৎ সৰ্ৱ্ৱভৱিষ্যদ্ৱাদিভি ৰ্ৱ্যৱস্থযা চ উপদেশঃ প্ৰাকাশ্যত| ");
INSERT INTO sanasm_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","যদি যূযমিদং ৱাক্যং গ্ৰহীতুং শক্নুথ, তৰ্হি শ্ৰেযঃ, যস্যাগমনস্য ৱচনমাস্তে সোঽযম্ এলিযঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","যস্য শ্ৰোতুং কৰ্ণৌ স্তঃ স শৃণোতু| ");
INSERT INTO sanasm_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","এতে ৱিদ্যমানজনাঃ কৈ ৰ্মযোপমীযন্তে? যে বালকা হট্ট উপৱিশ্য স্ৱং স্ৱং বন্ধুমাহূয ৱদন্তি, ");
INSERT INTO sanasm_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","ৱযং যুষ্মাকং সমীপে ৱংশীৰৱাদযাম, কিন্তু যূযং নানৃত্যত; যুষ্মাকং সমীপে চ ৱযমৰোদিম, কিন্তু যূযং ন ৱ্যলপত, তাদৃশৈ ৰ্বালকৈস্ত উপমাযিষ্যন্তে| ");
INSERT INTO sanasm_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","যতো যোহন্ আগত্য ন ভুক্তৱান্ ন পীতৱাংশ্চ, তেন লোকা ৱদন্তি, স ভূতগ্ৰস্ত ইতি| ");
INSERT INTO sanasm_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","মনুজসুত আগত্য ভুক্তৱান্ পীতৱাংশ্চ, তেন লোকা ৱদন্তি, পশ্যত এষ ভোক্তা মদ্যপাতা চণ্ডালপাপিনাং বন্ধশ্চ, কিন্তু জ্ঞানিনো জ্ঞানৱ্যৱহাৰং নিৰ্দোষং জানন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","স যত্ৰ যত্ৰ পুৰে বহ্ৱাশ্চৰ্য্যং কৰ্ম্ম কৃতৱান্, তন্নিৱাসিনাং মনঃপৰাৱৃত্ত্যভাৱাৎ তানি নগৰাণি প্ৰতি হন্তেত্যুক্তা কথিতৱান্, ");
INSERT INTO sanasm_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","হা কোৰাসীন্, হা বৈৎসৈদে, যুষ্মন্মধ্যে যদ্যদাশ্চৰ্য্যং কৰ্ম্ম কৃতং যদি তৎ সোৰসীদোন্নগৰ অকাৰিষ্যত, তৰ্হি পূৰ্ৱ্ৱমেৱ তন্নিৱাসিনঃ শাণৱসনে ভস্মনি চোপৱিশন্তো মনাংসি পৰাৱৰ্ত্তিষ্যন্ত| ");
INSERT INTO sanasm_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","তস্মাদহং যুষ্মান্ ৱদামি, ৱিচাৰদিনে যুষ্মাকং দশাতঃ সোৰসীদোনো ৰ্দশা সহ্যতৰা ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","অপৰঞ্চ বত কফৰ্নাহূম্, ৎৱং স্ৱৰ্গং যাৱদুন্নতোসি, কিন্তু নৰকে নিক্ষেপ্স্যসে, যস্মাৎ ৎৱযি যান্যাশ্চৰ্য্যাণি কৰ্ম্মণ্যকাৰিষত, যদি তানি সিদোম্নগৰ অকাৰিষ্যন্ত, তৰ্হি তদদ্য যাৱদস্থাস্যৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","কিন্ত্ৱহং যুষ্মান্ ৱদামি, ৱিচাৰদিনে তৱ দণ্ডতঃ সিদোমো দণ্ডো সহ্যতৰো ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","এতস্মিন্নেৱ সমযে যীশুঃ পুনৰুৱাচ, হে স্ৱৰ্গপৃথিৱ্যোৰেকাধিপতে পিতস্ত্ৱং জ্ঞানৱতো ৱিদুষশ্চ লোকান্ প্ৰত্যেতানি ন প্ৰকাশ্য বালকান্ প্ৰতি প্ৰকাশিতৱান্, ইতি হেতোস্ত্ৱাং ধন্যং ৱদামি| ");
INSERT INTO sanasm_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","হে পিতঃ, ইত্থং ভৱেৎ যত ইদং ৎৱদৃষ্টাৱুত্তমং| ");
INSERT INTO sanasm_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","পিত্ৰা মযি সৰ্ৱ্ৱাণি সমৰ্পিতানি, পিতৰং ৱিনা কোপি পুত্ৰং ন জানাতি, যান্ প্ৰতি পুত্ৰেণ পিতা প্ৰকাশ্যতে তান্ ৱিনা পুত্ৰাদ্ অন্যঃ কোপি পিতৰং ন জানাতি| ");
INSERT INTO sanasm_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","হে পৰিশ্ৰান্তা ভাৰাক্ৰান্তাশ্চ লোকা যূযং মৎসন্নিধিম্ আগচ্ছত, অহং যুষ্মান্ ৱিশ্ৰমযিষ্যামি| ");
INSERT INTO sanasm_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","অহং ক্ষমণশীলো নম্ৰমনাশ্চ, তস্মাৎ মম যুগং স্ৱেষামুপৰি ধাৰযত মত্তঃ শিক্ষধ্ৱঞ্চ, তেন যূযং স্ৱে স্ৱে মনসি ৱিশ্ৰামং লপ্স্যধ্বে| ");
INSERT INTO sanasm_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","যতো মম যুগম্ অনাযাসং মম ভাৰশ্চ লঘুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","অনন্তৰং যীশু ৰ্ৱিশ্ৰামৱাৰে শ্স্যমধ্যেন গচ্ছতি, তদা তচ্ছিষ্যা বুভুক্ষিতাঃ সন্তঃ শ্স্যমঞ্জৰীশ্ছৎৱা ছিৎৱা খাদিতুমাৰভন্ত| ");
INSERT INTO sanasm_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","তদ্ ৱিলোক্য ফিৰূশিনো যীশুং জগদুঃ, পশ্য ৱিশ্ৰামৱাৰে যৎ কৰ্ম্মাকৰ্ত্তৱ্যং তদেৱ তৱ শিষ্যাঃ কুৰ্ৱ্ৱন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","স তান্ প্ৰত্যাৱদত, দাযূদ্ তৎসঙ্গিনশ্চ বুভুক্ষিতাঃ সন্তো যৎ কৰ্ম্মাকুৰ্ৱ্ৱন্ তৎ কিং যুষ্মাভি ৰ্নাপাঠি? ");
INSERT INTO sanasm_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","যে দৰ্শনীযাঃ পূপাঃ যাজকান্ ৱিনা তস্য তৎসঙ্গিমনুজানাঞ্চাভোজনীযাস্ত ঈশ্ৱৰাৱাসং প্ৰৱিষ্টেন তেন ভুক্তাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","অন্যচ্চ ৱিশ্ৰামৱাৰে মধ্যেমন্দিৰং ৱিশ্ৰামৱাৰীযং নিযমং লঙ্ৱন্তোপি যাজকা নিৰ্দোষা ভৱন্তি, শাস্ত্ৰমধ্যে কিমিদমপি যুষ্মাভি ৰ্ন পঠিতং? ");
INSERT INTO sanasm_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","যুষ্মানহং ৱদামি, অত্ৰ স্থানে মন্দিৰাদপি গৰীযান্ এক আস্তে| ");
INSERT INTO sanasm_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","কিন্তু দযাযাং মে যথা প্ৰীতি ৰ্ন তথা যজ্ঞকৰ্ম্মণি| এতদ্ৱচনস্যাৰ্থং যদি যুযম্ অজ্ঞাসিষ্ট তৰ্হি নিৰ্দোষান্ দোষিণো নাকাৰ্ষ্ট| ");
INSERT INTO sanasm_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","অন্যচ্চ মনুজসুতো ৱিশ্ৰামৱাৰস্যাপি পতিৰাস্তে| ");
INSERT INTO sanasm_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","অনন্তৰং স তৎস্থানাৎ প্ৰস্থায তেষাং ভজনভৱনং প্ৰৱিষ্টৱান্, তদানীম্ একঃ শুষ্ককৰামযৱান্ উপস্থিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ততো যীশুম্ অপৱদিতুং মানুষাঃ পপ্ৰচ্ছুঃ, ৱিশ্ৰামৱাৰে নিৰামযৎৱং কৰণীযং ন ৱা? ");
INSERT INTO sanasm_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","তেন স প্ৰত্যুৱাচ, ৱিশ্ৰামৱাৰে যদি কস্যচিদ্ অৱি ৰ্গৰ্ত্তে পততি, তৰ্হি যস্তং ঘৃৎৱা ন তোলযতি, এতাদৃশো মনুজো যুষ্মাকং মধ্যে ক আস্তে? ");
INSERT INTO sanasm_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","অৱে ৰ্মানৱঃ কিং নহি শ্ৰেযান্? অতো ৱিশ্ৰামৱাৰে হিতকৰ্ম্ম কৰ্ত্তৱ্যং| ");
INSERT INTO sanasm_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","অনন্তৰং স তং মানৱং গদিতৱান্, কৰং প্ৰসাৰয; তেন কৰে প্ৰসাৰিতে সোন্যকৰৱৎ স্ৱস্থোঽভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","তদা ফিৰূশিনো বহিৰ্ভূয কথং তং হনিষ্যাম ইতি কুমন্ত্ৰণাং তৎপ্ৰাতিকূল্যেন চক্ৰুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ততো যীশুস্তদ্ ৱিদিৎৱা স্থনান্তৰং গতৱান্; অন্যেষু বহুনৰেষু তৎপশ্চাদ্ গতেষু তান্ স নিৰামযান্ কৃৎৱা ইত্যাজ্ঞাপযৎ, ");
INSERT INTO sanasm_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","যূযং মাং ন পৰিচাযযত| ");
INSERT INTO sanasm_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","তস্মাৎ মম প্ৰীযো মনোনীতো মনসস্তুষ্টিকাৰকঃ| মদীযঃ সেৱকো যস্তু ৱিদ্যতে তং সমীক্ষতাং| তস্যোপৰি স্ৱকীযাত্মা মযা সংস্থাপযিষ্যতে| তেনান্যদেশজাতেষু ৱ্যৱস্থা সংপ্ৰকাশ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","কেনাপি ন ৱিৰোধং স ৱিৱাদঞ্চ কৰিষ্যতি| ন চ ৰাজপথে তেন ৱচনং শ্ৰাৱযিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ৱ্যৱস্থা চলিতা যাৱৎ নহি তেন কৰিষ্যতে| তাৱৎ নলো ৱিদীৰ্ণোঽপি ভংক্ষ্যতে নহি তেন চ| তথা সধূমৱৰ্ত্তিঞ্চ ন স নিৰ্ৱ্ৱাপযিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","প্ৰত্যাশাঞ্চ কৰিষ্যন্তি তন্নাম্নি ভিন্নদেশজাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","যান্যেতানি ৱচনানি যিশযিযভৱিষ্যদ্ৱাদিনা প্ৰোক্তান্যাসন্, তানি সফলান্যভৱন্| ");
INSERT INTO sanasm_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","অনন্তৰং লোকৈ স্তৎসমীপম্ আনীতো ভূতগ্ৰস্তান্ধমূকৈকমনুজস্তেন স্ৱস্থীকৃতঃ, ততঃ সোঽন্ধো মূকো দ্ৰষ্টুং ৱক্তুঞ্চাৰব্ধৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","অনেন সৰ্ৱ্ৱে ৱিস্মিতাঃ কথযাঞ্চক্ৰুঃ, এষঃ কিং দাযূদঃ সন্তানো নহি? ");
INSERT INTO sanasm_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","কিন্তু ফিৰূশিনস্তৎ শ্ৰুৎৱা গদিতৱন্তঃ, বাল্সিবূব্নাম্নো ভূতৰাজস্য সাহায্যং ৱিনা নাযং ভূতান্ ত্যাজযতি| ");
INSERT INTO sanasm_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","তদানীং যীশুস্তেষাম্ ইতি মানসং ৱিজ্ঞায তান্ অৱদৎ কিঞ্চন ৰাজ্যং যদি স্ৱৱিপক্ষাদ্ ভিদ্যতে, তৰ্হি তৎ উচ্ছিদ্যতে; যচ্চ কিঞ্চন নগৰং ৱা গৃহং স্ৱৱিপক্ষাদ্ ৱিভিদ্যতে, তৎ স্থাতুং ন শক্নোতি| ");
INSERT INTO sanasm_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","তদ্ৱৎ শযতানো যদি শযতানং বহিঃ কৃৎৱা স্ৱৱিপক্ষাৎ পৃথক্ পৃথক্ ভৱতি, তৰ্হি তস্য ৰাজ্যং কেন প্ৰকাৰেণ স্থাস্যতি? ");
INSERT INTO sanasm_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","অহঞ্চ যদি বাল্সিবূবা ভূতান্ ত্যাজযামি, তৰ্হি যুষ্মাকং সন্তানাঃ কেন ভূতান্ ত্যাজযন্তি? তস্মাদ্ যুষ্মাকম্ এতদ্ৱিচাৰযিতাৰস্ত এৱ ভৱিষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","কিন্তৱহং যদীশ্ৱৰাত্মনা ভূতান্ ত্যাজযামি, তৰ্হীশ্ৱৰস্য ৰাজ্যং যুষ্মাকং সন্নিধিমাগতৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","অন্যঞ্চ কোপি বলৱন্ত জনং প্ৰথমতো ন বদ্ৱ্ৱা কেন প্ৰকাৰেণ তস্য গৃহং প্ৰৱিশ্য তদ্দ্ৰৱ্যাদি লোঠযিতুং শক্নোতি? কিন্তু তৎ কৃৎৱা তদীযগৃস্য দ্ৰৱ্যাদি লোঠযিতুং শক্নোতি| ");
INSERT INTO sanasm_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","যঃ কশ্চিৎ মম স্ৱপক্ষীযো নহি স ৱিপক্ষীয আস্তে, যশ্চ মযা সাকং ন সংগৃহ্লাতি, স ৱিকিৰতি| ");
INSERT INTO sanasm_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","অতএৱ যুষ্মানহং ৱদামি, মনুজানাং সৰ্ৱ্ৱপ্ৰকাৰপাপানাং নিন্দাযাশ্চ মৰ্ষণং ভৱিতুং শক্নোতি, কিন্তু পৱিত্ৰস্যাত্মনো ৱিৰুদ্ধনিন্দাযা মৰ্ষণং ভৱিতুং ন শক্নোতি| ");
INSERT INTO sanasm_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","যো মনুজসুতস্য ৱিৰুদ্ধাং কথাং কথযতি, তস্যাপৰাধস্য ক্ষমা ভৱিতুং শক্নোতি, কিন্তু যঃ কশ্চিৎ পৱিত্ৰস্যাত্মনো ৱিৰুদ্ধাং কথাং কথযতি নেহলোকে ন প্ৰেত্য তস্যাপৰাধস্য ক্ষমা ভৱিতুং শক্নোতি| ");
INSERT INTO sanasm_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","পাদপং যদি ভদ্ৰং ৱদথ, তৰ্হি তস্য ফলমপি সাধু ৱক্তৱ্যং, যদি চ পাদপং অসাধুং ৱদথ, তৰ্হি তস্য ফলমপ্যসাধু ৱক্তৱ্যং; যতঃ স্ৱীযস্ৱীযফলেন পাদপঃ পৰিচীযতে| ");
INSERT INTO sanasm_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","ৰে ভুজগৱংশা যূযমসাধৱঃ সন্তঃ কথং সাধু ৱাক্যং ৱক্তুং শক্ষ্যথ? যস্মাদ্ অন্তঃকৰণস্য পূৰ্ণভাৱানুসাৰাদ্ ৱদনাদ্ ৱচো নিৰ্গচ্ছতি| ");
INSERT INTO sanasm_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","তেন সাধুৰ্মানৱোঽন্তঃকৰণৰূপাৎ সাধুভাণ্ডাগাৰাৎ সাধু দ্ৰৱ্যং নিৰ্গমযতি, অসাধুৰ্মানুষস্ত্ৱসাধুভাণ্ডাগাৰাদ্ অসাধুৱস্তূনি নিৰ্গমযতি| ");
INSERT INTO sanasm_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","কিন্ত্ৱহং যুষ্মান্ ৱদামি, মনুজা যাৱন্ত্যালস্যৱচাংসি ৱদন্তি, ৱিচাৰদিনে তদুত্তৰমৱশ্যং দাতৱ্যং, ");
INSERT INTO sanasm_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","যতস্ত্ৱং স্ৱীযৱচোভি ৰ্নিৰপৰাধঃ স্ৱীযৱচোভিশ্চ সাপৰাধো গণিষ্যসে| ");
INSERT INTO sanasm_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","তদানীং কতিপযা উপাধ্যাযাঃ ফিৰূশিনশ্চ জগদুঃ, হে গুৰো ৱযং ভৱত্তঃ কিঞ্চন লক্ষ্ম দিদৃক্ষামঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","তদা স প্ৰত্যুক্তৱান্, দুষ্টো ৱ্যভিচাৰী চ ৱংশো লক্ষ্ম মৃগযতে, কিন্তু ভৱিষ্যদ্ৱাদিনো যূনসো লক্ষ্ম ৱিহাযান্যৎ কিমপি লক্ষ্ম তে ন প্ৰদৰ্শযিষ্যন্তে| ");
INSERT INTO sanasm_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","যতো যূনম্ যথা ত্ৰ্যহোৰাত্ৰং বৃহন্মীনস্য কুক্ষাৱাসীৎ, তথা মনুজপুত্ৰোপি ত্ৰ্যহোৰাত্ৰং মেদিন্যা মধ্যে স্থাস্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","অপৰং নীনিৱীযা মানৱা ৱিচাৰদিন এতদ্ৱংশীযানাং প্ৰতিকূলম্ উত্থায তান্ দোষিণঃ কৰিষ্যন্তি, যস্মাত্তে যূনস উপদেশাৎ মনাংসি পৰাৱৰ্ত্তযাঞ্চক্ৰিৰে, কিন্ত্ৱত্ৰ যূনসোপি গুৰুতৰ এক আস্তে| ");
INSERT INTO sanasm_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","পুনশ্চ দক্ষিণদেশীযা ৰাজ্ঞী ৱিচাৰদিন এতদ্ৱংশীযানাং প্ৰতিকূলমুত্থায তান্ দোষিণঃ কৰিষ্যতি যতঃ সা ৰাজ্ঞী সুলেমনো ৱিদ্যাযাঃ কথাং শ্ৰোতুং মেদিন্যাঃ সীম্ন আগচ্ছৎ, কিন্তু সুলেমনোপি গুৰুতৰ একো জনোঽত্ৰ আস্তে| ");
INSERT INTO sanasm_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","অপৰং মনুজাদ্ বহিৰ্গতো ঽপৱিত্ৰভূতঃ শুষ্কস্থানেন গৎৱা ৱিশ্ৰামং গৱেষযতি, কিন্তু তদলভমানঃ স ৱক্তি, যস্মা; নিকেতনাদ্ আগমং, তদেৱ ৱেশ্ম পকাৱৃত্য যামি| ");
INSERT INTO sanasm_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","পশ্চাৎ স তৎ স্থানম্ উপস্থায তৎ শূন্যং মাৰ্জ্জিতং শোভিতঞ্চ ৱিলোক্য ৱ্ৰজন্ স্ৱতোপি দুষ্টতৰান্ অন্যসপ্তভূতান্ সঙ্গিনঃ কৰোতি| ");
INSERT INTO sanasm_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ততস্তে তৎ স্থানং প্ৰৱিশ্য নিৱসন্তি, তেন তস্য মনুজস্য শেষদশা পূৰ্ৱ্ৱদশাতোতীৱাশুভা ভৱতি, এতেষাং দুষ্টৱংশ্যানামপি তথৈৱ ঘটিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","মানৱেভ্য এতাসাং কথনাং কথনকালে তস্য মাতা সহজাশ্চ তেন সাকং কাঞ্চিৎ কথাং কথযিতুং ৱাঞ্ছন্তো বহিৰেৱ স্থিতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ততঃ কশ্চিৎ তস্মৈ কথিতৱান্, পশ্য তৱ জননী সহজাশ্চ ৎৱযা সাকং কাঞ্চন কথাং কথযিতুং কামযমানা বহিস্তিষ্ঠন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","কিন্তু স তং প্ৰত্যৱদৎ, মম কা জননী? কে ৱা মম সহজাঃ? ");
INSERT INTO sanasm_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","পশ্চাৎ শিষ্যান্ প্ৰতি কৰং প্ৰসাৰ্য্য কথিতৱান্, পশ্য মম জননী মম সহজাশ্চৈতে; ");
INSERT INTO sanasm_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","যঃ কশ্চিৎ মম স্ৱৰ্গস্থস্য পিতুৰিষ্টং কৰ্ম্ম কুৰুতে, সএৱ মম ভ্ৰাতা ভগিনী জননী চ| ");
INSERT INTO sanasm_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","অপৰঞ্চ তস্মিন্ দিনে যীশুঃ সদ্মনো গৎৱা সৰিৎপতে ৰোধসি সমুপৱিৱেশ| ");
INSERT INTO sanasm_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","তত্ৰ তৎসন্নিধৌ বহুজনানাং নিৱহোপস্থিতেঃ স তৰণিমাৰুহ্য সমুপাৱিশৎ, তেন মানৱা ৰোধসি স্থিতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","তদানীং স দৃষ্টান্তৈস্তান্ ইত্থং বহুশ উপদিষ্টৱান্| পশ্যত, কশ্চিৎ কৃষীৱলো বীজানি ৱপ্তুং বহিৰ্জগাম, ");
INSERT INTO sanasm_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","তস্য ৱপনকালে কতিপযবীজেষু মাৰ্গপাৰ্শ্ৱে পতিতেষু ৱিহগাস্তানি ভক্ষিতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","অপৰং কতিপযবীজেষু স্তোকমৃদ্যুক্তপাষাণে পতিতেষু মৃদল্পৎৱাৎ তৎক্ষণাৎ তান্যঙ্কুৰিতানি, ");
INSERT INTO sanasm_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","কিন্তু ৰৱাৱুদিতে দগ্ধানি তেষাং মূলাপ্ৰৱিষ্টৎৱাৎ শুষ্কতাং গতানি চ| ");
INSERT INTO sanasm_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","অপৰং কতিপযবীজেষু কণ্টকানাং মধ্যে পতিতেষু কণ্টকান্যেধিৎৱা তানি জগ্ৰসুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","অপৰঞ্চ কতিপযবীজানি উৰ্ৱ্ৱৰাযাং পতিতানি; তেষাং মধ্যে কানিচিৎ শতগুণানি কানিচিৎ ষষ্টিগুণানি কানিচিৎ ত্ৰিংশগুংণানি ফলানি ফলিতৱন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","শ্ৰোতুং যস্য শ্ৰুতী আসাতে স শৃণুযাৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","অনন্তৰং শিষ্যৈৰাগত্য সোঽপৃচ্ছ্যত, ভৱতা তেভ্যঃ কুতো দৃষ্টান্তকথা কথ্যতে? ");
INSERT INTO sanasm_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ততঃ স প্ৰত্যৱদৎ, স্ৱৰ্গৰাজ্যস্য নিগূঢাং কথাং ৱেদিতুং যুষ্মভ্যং সামৰ্থ্যমদাযি, কিন্তু তেভ্যো নাদাযি| ");
INSERT INTO sanasm_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","যস্মাদ্ যস্যান্তিকে ৱৰ্দ্ধতে, তস্মাযেৱ দাযিষ্যতে, তস্মাৎ তস্য বাহুল্যং ভৱিষ্যতি, কিন্তু যস্যান্তিকে ন ৱৰ্দ্ধতে, তস্য যৎ কিঞ্চনাস্তে, তদপি তস্মাদ্ আদাযিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","তে পশ্যন্তোপি ন পশ্যন্তি, শৃণ্ৱন্তোপি ন শৃণ্ৱন্তি, বুধ্যমানা অপি ন বুধ্যন্তে চ, তস্মাৎ তেভ্যো দৃষ্টান্তকথা কথ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","যথা কৰ্ণৈঃ শ্ৰোষ্যথ যূযং ৱৈ কিন্তু যূযং ন ভোৎস্যথ| নেত্ৰৈৰ্দ্ৰক্ষ্যথ যূযঞ্চ পৰিজ্ঞাতুং ন শক্ষ্যথ| তে মানুষা যথা নৈৱ পৰিপশ্যন্তি লোচনৈঃ| কৰ্ণৈ ৰ্যথা ন শৃণ্ৱন্তি ন বুধ্যন্তে চ মানসৈঃ| ৱ্যাৱৰ্ত্তিতেষু চিত্তেষু কালে কুত্ৰাপি তৈৰ্জনৈঃ| মত্তস্তে মনুজাঃ স্ৱস্থা যথা নৈৱ ভৱন্তি চ| তথা তেষাং মনুষ্যাণাং ক্ৰিযন্তে স্থূলবুদ্ধযঃ| বধিৰীভূতকৰ্ণাশ্চ জাতাশ্চ মুদ্ৰিতা দৃশঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","যদেতানি ৱচনানি যিশযিযভৱিষ্যদ্ৱাদিনা প্ৰোক্তানি তেষু তানি ফলন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","কিন্তু যুষ্মাকং নযনানি ধন্যানি, যস্মাৎ তানি ৱীক্ষন্তে; ধন্যাশ্চ যুষ্মাকং শব্দগ্ৰহাঃ, যস্মাৎ তৈৰাকৰ্ণ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","মযা যূযং তথ্যং ৱচামি যুষ্মাভি ৰ্যদ্যদ্ ৱীক্ষ্যতে, তদ্ বহৱো ভৱিষ্যদ্ৱাদিনো ধাৰ্ম্মিকাশ্চ মানৱা দিদৃক্ষন্তোপি দ্ৰষ্টুং নালভন্ত, পুনশ্চ যূযং যদ্যৎ শৃণুথ, তৎ তে শুশ্ৰূষমাণা অপি শ্ৰোতুং নালভন্ত| ");
INSERT INTO sanasm_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","কৃষীৱলীযদৃষ্টান্তস্যাৰ্থং শৃণুত| ");
INSERT INTO sanasm_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","মাৰ্গপাৰ্শ্ৱে বীজান্যুপ্তানি তস্যাৰ্থ এষঃ, যদা কশ্চিৎ ৰাজ্যস্য কথাং নিশম্য ন বুধ্যতে, তদা পাপাত্মাগত্য তদীযমনস উপ্তাং কথাং হৰন্ নযতি| ");
INSERT INTO sanasm_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","অপৰং পাষাণস্থলে বীজান্যুপ্তানি তস্যাৰ্থ এষঃ; কশ্চিৎ কথাং শ্ৰুৎৱৈৱ হৰ্ষচিত্তেন গৃহ্লাতি, ");
INSERT INTO sanasm_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","কিন্তু তস্য মনসি মূলাপ্ৰৱিষ্টৎৱাৎ স কিঞ্চিৎকালমাত্ৰং স্থিৰস্তিষ্ঠতি; পশ্চাত তৎকথাকাৰণাৎ কোপি ক্লেস্তাডনা ৱা চেৎ জাযতে, তৰ্হি স তৎক্ষণাদ্ ৱিঘ্নমেতি| ");
INSERT INTO sanasm_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","অপৰং কণ্টকানাং মধ্যে বীজান্যুপ্তানি তদৰ্থ এষঃ; কেনচিৎ কথাযাং শ্ৰুতাযাং সাংসাৰিকচিন্তাভি ৰ্ভ্ৰান্তিভিশ্চ সা গ্ৰস্যতে, তেন সা মা ৱিফলা ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","অপৰম্ উৰ্ৱ্ৱৰাযাং বীজান্যুপ্তানি তদৰ্থ এষঃ; যে তাং কথাং শ্ৰুৎৱা ৱুধ্যন্তে, তে ফলিতাঃ সন্তঃ কেচিৎ শতগুণানি কেচিত ষষ্টিগুণানি কেচিচ্চ ত্ৰিংশদ্গুণানি ফলানি জনযন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","অনন্তৰং সোপৰামেকাং দৃষ্টান্তকথামুপস্থাপ্য তেভ্যঃ কথযামাস; স্ৱৰ্গীযৰাজ্যং তাদৃশেন কেনচিদ্ গৃহস্থেনোপমীযতে, যেন স্ৱীযক্ষেত্ৰে প্ৰশস্তবীজান্যৌপ্যন্ত| ");
INSERT INTO sanasm_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","কিন্তু ক্ষণদাযাং সকললোকেষু সুপ্তেষু তস্য ৰিপুৰাগত্য তেষাং গোধূমবীজানাং মধ্যে ৱন্যযৱমবীজান্যুপ্ত্ৱা ৱৱ্ৰাজ| ");
INSERT INTO sanasm_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ততো যদা বীজেভ্যোঽঙ্কৰা জাযমানাঃ কণিশানি ঘৃতৱন্তঃ; তদা ৱন্যযৱসান্যপি দৃশ্যমানান্যভৱন্| ");
INSERT INTO sanasm_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ততো গৃহস্থস্য দাসেযা আগম্য তস্মৈ কথযাঞ্চক্ৰুঃ, হে মহেচ্ছ, ভৱতা কিং ক্ষেত্ৰে ভদ্ৰবীজানি নৌপ্যন্ত? তথাৎৱে ৱন্যযৱসানি কৃত আযন্? ");
INSERT INTO sanasm_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","তদানীং তেন তে প্ৰতিগদিতাঃ, কেনচিৎ ৰিপুণা কৰ্ম্মদমকাৰি| দাসেযাঃ কথযামাসুঃ, ৱযং গৎৱা তান্যুৎপায্য ক্ষিপামো ভৱতঃ কীদৃশীচ্ছা জাযতে? ");
INSERT INTO sanasm_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","তেনাৱাদি, নহি, শঙ্কেঽহং ৱন্যযৱসোৎপাটনকালে যুষ্মাভিস্তৈঃ সাকং গোধূমা অপ্যুৎপাটিষ্যন্তে| ");
INSERT INTO sanasm_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","অতঃ শ্স্যকৰ্ত্তনকালং যাৱদ্ উভযান্যপি সহ ৱৰ্দ্ধন্তাং, পশ্চাৎ কৰ্ত্তনকালে কৰ্ত্তকান্ ৱক্ষ্যামি, যূযমাদৌ ৱন্যযৱসানি সংগৃহ্য দাহযিতুং ৱীটিকা বদ্ৱ্ৱা স্থাপযত; কিন্তু সৰ্ৱ্ৱে গোধূমা যুষ্মাভি ৰ্ভাণ্ডাগাৰং নীৎৱা স্থাপ্যন্তাম্| ");
INSERT INTO sanasm_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","অনন্তৰং সোপৰামেকাং দৃষ্টান্তকথামুত্থাপ্য তেভ্যঃ কথিতৱান্ কশ্চিন্মনুজঃ সৰ্ষপবীজমেকং নীৎৱা স্ৱক্ষেত্ৰ উৱাপ| ");
INSERT INTO sanasm_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","সৰ্ষপবীজং সৰ্ৱ্ৱস্মাদ্ বীজাৎ ক্ষুদ্ৰমপি সদঙ্কুৰিতং সৰ্ৱ্ৱস্মাৎ শাকাৎ বৃহদ্ ভৱতি; স তাদৃশস্তৰু ৰ্ভৱতি, যস্য শাখাসু নভসঃ খগা আগত্য নিৱসন্তি; স্ৱৰ্গীযৰাজ্যং তাদৃশস্য সৰ্ষপৈকস্য সমম্| ");
INSERT INTO sanasm_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","পুনৰপি স উপমাকথামেকাং তেভ্যঃ কথযাঞ্চকাৰ; কাচন যোষিৎ যৎ কিণ্ৱমাদায দ্ৰোণত্ৰযমিতগোধূমচূৰ্ণানাং মধ্যে সৰ্ৱ্ৱেষাং মিশ্ৰীভৱনপৰ্য্যন্তং সমাচ্ছাদ্য নিধত্তৱতী, তৎকিণ্ৱমিৱ স্ৱৰ্গৰাজ্যং| ");
INSERT INTO sanasm_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ইত্থং যীশু ৰ্মনুজনিৱহানাং সন্নিধাৱুপমাকথাভিৰেতান্যাখ্যানানি কথিতৱান্ উপমাং ৱিনা তেভ্যঃ কিমপি কথাং নাকথযৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","এতেন দৃষ্টান্তীযেন ৱাক্যেন ৱ্যাদায ৱদনং নিজং| অহং প্ৰকাশযিষ্যামি গুপ্তৱাক্যং পুৰাভৱং| যদেতদ্ৱচনং ভৱিষ্যদ্ৱাদিনা প্ৰোক্তমাসীৎ, তৎ সিদ্ধমভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","সৰ্ৱ্ৱান্ মনুজান্ ৱিসৃজ্য যীশৌ গৃহং প্ৰৱিষ্টে তচ্ছিষ্যা আগত্য যীশৱে কথিতৱন্তঃ, ক্ষেত্ৰস্য ৱন্যযৱসীযদৃষ্টান্তকথাম্ ভৱান অস্মান্ স্পষ্টীকৃত্য ৱদতু| ");
INSERT INTO sanasm_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ততঃ স প্ৰত্যুৱাচ, যেন ভদ্ৰবীজান্যুপ্যন্তে স মনুজপুত্ৰঃ, ");
INSERT INTO sanasm_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ক্ষেত্ৰং জগৎ, ভদ্ৰবীজানী ৰাজ্যস্য সন্তানাঃ, ");
INSERT INTO sanasm_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ৱন্যযৱসানি পাপাত্মনঃ সন্তানাঃ| যেন ৰিপুণা তান্যুপ্তানি স শযতানঃ, কৰ্ত্তনসমযশ্চ জগতঃ শেষঃ, কৰ্ত্তকাঃ স্ৱৰ্গীযদূতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","যথা ৱন্যযৱসানি সংগৃহ্য দাহ্যন্তে, তথা জগতঃ শেষে ভৱিষ্যতি; ");
INSERT INTO sanasm_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","অৰ্থাৎ মনুজসুতঃ স্ৱাংযদূতান্ প্ৰেষযিষ্যতি, তেন তে চ তস্য ৰাজ্যাৎ সৰ্ৱ্ৱান্ ৱিঘ্নকাৰিণোঽধাৰ্ম্মিকলোকাংশ্চ সংগৃহ্য ");
INSERT INTO sanasm_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","যত্ৰ ৰোদনং দন্তঘৰ্ষণঞ্চ ভৱতি, তত্ৰাগ্নিকুণ্ডে নিক্ষেপ্স্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","তদানীং ধাৰ্ম্মিকলোকাঃ স্ৱেষাং পিতূ ৰাজ্যে ভাস্কৰইৱ তেজস্ৱিনো ভৱিষ্যন্তি| শ্ৰোতুং যস্য শ্ৰুতী আসাতে, ম শৃণুযাৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","অপৰঞ্চ ক্ষেত্ৰমধ্যে নিধিং পশ্যন্ যো গোপযতি, ততঃ পৰং সানন্দো গৎৱা স্ৱীযসৰ্ৱ্ৱস্ৱং ৱিক্ৰীয ত্তক্ষেত্ৰং ক্ৰীণাতি, স ইৱ স্ৱৰ্গৰাজ্যং| ");
INSERT INTO sanasm_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","অন্যঞ্চ যো ৱণিক্ উত্তমাং মুক্তাং গৱেষযন্ ");
INSERT INTO sanasm_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","মহাৰ্ঘাং মুক্তাং ৱিলোক্য নিজসৰ্ৱ্ৱস্ৱং ৱিক্ৰীয তাং ক্ৰীণাতি, স ইৱ স্ৱৰ্গৰাজ্যং| ");
INSERT INTO sanasm_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","পুনশ্চ সমুদ্ৰো নিক্ষিপ্তঃ সৰ্ৱ্ৱপ্ৰকাৰমীনসংগ্ৰাহ্যানাযইৱ স্ৱৰ্গৰাজ্যং| ");
INSERT INTO sanasm_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","তস্মিন্ আনাযে পূৰ্ণে জনা যথা ৰোধস্যুত্তোল্য সমুপৱিশ্য প্ৰশস্তমীনান্ সংগ্ৰহ্য ভাজনেষু নিদধতে, কুৎসিতান্ নিক্ষিপন্তি; ");
INSERT INTO sanasm_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","তথৈৱ জগতঃ শেষে ভৱিষ্যতি, ফলতঃ স্ৱৰ্গীযদূতা আগত্য পুণ্যৱজ্জনানাং মধ্যাৎ পাপিনঃ পৃথক্ কৃৎৱা ৱহ্নিকুণ্ডে নিক্ষেপ্স্যন্তি, ");
INSERT INTO sanasm_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","তত্ৰ ৰোদনং দন্তৈ ৰ্দন্তঘৰ্ষণঞ্চ ভৱিষ্যতঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","যীশুনা তে পৃষ্টা যুষ্মাভিঃ কিমেতান্যাখ্যানান্যবুধ্যন্ত? তদা তে প্ৰত্যৱদন্, সত্যং প্ৰভো| ");
INSERT INTO sanasm_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","তদানীং স কথিতৱান্, নিজভাণ্ডাগাৰাৎ নৱীনপুৰাতনানি ৱস্তূনি নিৰ্গমযতি যো গৃহস্থঃ স ইৱ স্ৱৰ্গৰাজ্যমধি শিক্ষিতাঃ স্ৱৰ্ৱ উপদেষ্টাৰঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","অনন্তৰং যীশুৰেতাঃ সৰ্ৱ্ৱা দৃষ্টান্তকথাঃ সমাপ্য তস্মাৎ স্থানাৎ প্ৰতস্থে| অপৰং স্ৱদেশমাগত্য জনান্ ভজনভৱন উপদিষ্টৱান্; ");
INSERT INTO sanasm_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","তে ৱিস্মযং গৎৱা কথিতৱন্ত এতস্যৈতাদৃশং জ্ঞানম্ আশ্চৰ্য্যং কৰ্ম্ম চ কস্মাদ্ অজাযত? ");
INSERT INTO sanasm_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","কিমযং সূত্ৰধাৰস্য পুত্ৰো নহি? এতস্য মাতু ৰ্নাম চ কিং মৰিযম্ নহি? যাকুব্-যূষফ্-শিমোন্-যিহূদাশ্চ কিমেতস্য ভ্ৰাতৰো নহি? ");
INSERT INTO sanasm_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","এতস্য ভগিন্যশ্চ কিমস্মাকং মধ্যে ন সন্তি? তৰ্হি কস্মাদযমেতানি লব্ধৱান্? ইত্থং স তেষাং ৱিঘ্নৰূপো বভূৱ; ");
INSERT INTO sanasm_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ততো যীশুনা নিগদিতং স্ৱদেশীযজনানাং মধ্যং ৱিনা ভৱিষ্যদ্ৱাদী কুত্ৰাপ্যন্যত্ৰ নাসম্মান্যো ভৱতী| ");
INSERT INTO sanasm_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","তেষামৱিশ্ৱাসহেতোঃ স তত্ৰ স্থানে বহ্ৱাশ্চৰ্য্যকৰ্ম্মাণি ন কৃতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","তদানীং ৰাজা হেৰোদ্ যীশো ৰ্যশঃ শ্ৰুৎৱা নিজদাসেযান্ জগাদ্, ");
INSERT INTO sanasm_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","এষ মজ্জযিতা যোহন্, প্ৰমিতেভযস্তস্যোত্থানাৎ তেনেত্থমদ্ভুতং কৰ্ম্ম প্ৰকাশ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","পুৰা হেৰোদ্ নিজভ্ৰাতু: ফিলিপো জাযাযা হেৰোদীযাযা অনুৰোধাদ্ যোহনং ধাৰযিৎৱা বদ্ধা কাৰাযাং স্থাপিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","যতো যোহন্ উক্তৱান্, এৎসযাঃ সংগ্ৰহো ভৱতো নোচিতঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","তস্মাৎ নৃপতিস্তং হন্তুমিচ্ছন্নপি লোকেভ্যো ৱিভযাঞ্চকাৰ; যতঃ সৰ্ৱ্ৱে যোহনং ভৱিষ্যদ্ৱাদিনং মেনিৰে| ");
INSERT INTO sanasm_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","কিন্তু হেৰোদো জন্মাহীযমহ উপস্থিতে হেৰোদীযাযা দুহিতা তেষাং সমক্ষং নৃতিৎৱা হেৰোদমপ্ৰীণ্যৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","তস্মাৎ ভূপতিঃ শপথং কুৰ্ৱ্ৱন্ ইতি প্ৰত্যজ্ঞাসীৎ, ৎৱযা যদ্ যাচ্যতে, তদেৱাহং দাস্যামি| ");
INSERT INTO sanasm_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","সা কুমাৰী স্ৱীযমাতুঃ শিক্ষাং লব্ধা বভাষে, মজ্জযিতুৰ্যোহন উত্তমাঙ্গং ভাজনে সমানীয মহ্যং ৱিশ্ৰাণয| ");
INSERT INTO sanasm_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ততো ৰাজা শুশোচ, কিন্তু ভোজনাযোপৱিশতাং সঙ্গিনাং স্ৱকৃতশপথস্য চানুৰোধাৎ তৎ প্ৰদাতুম আদিদেশ| ");
INSERT INTO sanasm_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","পশ্চাৎ কাৰাং প্ৰতি নৰং প্ৰহিত্য যোহন উত্তমাঙ্গং ছিত্ত্ৱা ");
INSERT INTO sanasm_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","তৎ ভাজন আনায্য তস্যৈ কুমাৰ্য্যৈ ৱ্যশ্ৰাণযৎ, ততঃ সা স্ৱজনন্যাঃ সমীপং তন্নিনায| ");
INSERT INTO sanasm_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","পশ্চাৎ যোহনঃ শিষ্যা আগত্য কাযং নীৎৱা শ্মশানে স্থাপযামাসুস্ততো যীশোঃ সন্নিধিং ৱ্ৰজিৎৱা তদ্ৱাৰ্ত্তাং বভাষিৰে| ");
INSERT INTO sanasm_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","অনন্তৰং যীশুৰিতি নিশভ্য নাৱা নিৰ্জনস্থানম্ একাকী গতৱান্, পশ্চাৎ মানৱাস্তৎ শ্ৰুৎৱা নানানগৰেভ্য আগত্য পদৈস্তৎপশ্চাদ্ ঈযুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","তদানীং যীশু ৰ্বহিৰাগত্য মহান্তং জননিৱহং নিৰীক্ষ্য তেষু কাৰুণিকঃ মন্ তেষাং পীডিতজনান্ নিৰামযান্ চকাৰ| ");
INSERT INTO sanasm_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ততঃ পৰং সন্ধ্যাযাং শিষ্যাস্তদন্তিকমাগত্য কথযাঞ্চক্ৰুঃ, ইদং নিৰ্জনস্থানং ৱেলাপ্যৱসন্না; তস্মাৎ মনুজান্ স্ৱস্ৱগ্ৰামং গন্তুং স্ৱাৰ্থং ভক্ষ্যাণি ক্ৰেতুঞ্চ ভৱান্ তান্ ৱিসৃজতু| ");
INSERT INTO sanasm_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","কিন্তু যীশুস্তানৱাদীৎ, তেষাং গমনে প্ৰযোজনং নাস্তি, যূযমেৱ তান্ ভোজযত| ");
INSERT INTO sanasm_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","তদা তে প্ৰত্যৱদন্, অস্মাকমত্ৰ পূপপঞ্চকং মীনদ্ৱযঞ্চাস্তে| ");
INSERT INTO sanasm_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","তদানীং তেনোক্তং তানি মদন্তিকমানযত| ");
INSERT INTO sanasm_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","অনন্তৰং স মনুজান্ যৱসোপৰ্য্যুপৱেষ্টুম্ আজ্ঞাপযামাস; অপৰ তৎ পূপপঞ্চকং মীনদ্ৱযঞ্চ গৃহ্লন্ স্ৱৰ্গং প্ৰতি নিৰীক্ষ্যেশ্ৱৰীযগুণান্ অনূদ্য ভংক্ত্ৱা শিষ্যেভ্যো দত্তৱান্, শিষ্যাশ্চ লোকেভ্যো দদুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ততঃ সৰ্ৱ্ৱে ভুক্ত্ৱা পৰিতৃপ্তৱন্তঃ, ততস্তদৱশিষ্টভক্ষ্যৈঃ পূৰ্ণান্ দ্ৱাদশডলকান্ গৃহীতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","তে ভোক্তাৰঃ স্ত্ৰীৰ্বালকাংশ্চ ৱিহায প্ৰাযেণ পঞ্চ সহস্ৰাণি পুমাংস আসন্| ");
INSERT INTO sanasm_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","তদনন্তৰং যীশু ৰ্লোকানাং ৱিসৰ্জনকালে শিষ্যান্ তৰণিমাৰোঢুং স্ৱাগ্ৰে পাৰং যাতুঞ্চ গাঢমাদিষ্টৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ততো লোকেষু ৱিসৃষ্টেষু স ৱিৱিক্তে প্ৰাৰ্থযিতুং গিৰিমেকং গৎৱা সন্ধ্যাং যাৱৎ তত্ৰৈকাকী স্থিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","কিন্তু তদানীং সম্মুখৱাতৎৱাৎ সৰিৎপতে ৰ্মধ্যে তৰঙ্গৈস্তৰণিৰ্দোলাযমানাভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","তদা স যামিন্যাশ্চতুৰ্থপ্ৰহৰে পদ্ভ্যাং ৱ্ৰজন্ তেষামন্তিকং গতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","কিন্তু শিষ্যাস্তং সাগৰোপৰি ৱ্ৰজন্তং ৱিলোক্য সমুদ্ৱিগ্না জগদুঃ, এষ ভূত ইতি শঙ্কমানা উচ্চৈঃ শব্দাযাঞ্চক্ৰিৰে চ| ");
INSERT INTO sanasm_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","তদৈৱ যীশুস্তানৱদৎ, সুস্থিৰা ভৱত, মা ভৈষ্ট, এষোঽহম্| ");
INSERT INTO sanasm_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","ততঃ পিতৰ ইত্যুক্তৱান্, হে প্ৰভো, যদি ভৱানেৱ, তৰ্হি মাং ভৱৎসমীপং যাতুমাজ্ঞাপযতু| ");
INSERT INTO sanasm_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ততঃ তেনাদিষ্টঃ পিতৰস্তৰণিতোঽৱৰুহ্য যীশেाৰন্তিকং প্ৰাপ্তুং তোযোপৰি ৱৱ্ৰাজ| ");
INSERT INTO sanasm_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","কিন্তু প্ৰচণ্ডং পৱনং ৱিলোক্য ভযাৎ তোযে মংক্তুম্ আৰেভে, তস্মাদ্ উচ্চৈঃ শব্দাযমানঃ কথিতৱান্, হে প্ৰভো, মামৱতু| ");
INSERT INTO sanasm_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","যীশুস্তৎক্ষণাৎ কৰং প্ৰসাৰ্য্য তং ধৰন্ উক্তৱান্, হ স্তোকপ্ৰত্যযিন্ ৎৱং কুতঃ সমশেথাঃ? ");
INSERT INTO sanasm_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","অনন্তৰং তযোস্তৰণিমাৰূঢযোঃ পৱনো নিৱৱৃতে| ");
INSERT INTO sanasm_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","তদানীং যে তৰণ্যামাসন্, ত আগত্য তং প্ৰণভ্য কথিতৱন্তঃ, যথাৰ্থস্ত্ৱমেৱেশ্ৱৰসুতঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","অনন্তৰং পাৰং প্ৰাপ্য তে গিনেষৰন্নামকং নগৰমুপতস্থুঃ, ");
INSERT INTO sanasm_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","তদা তত্ৰত্যা জনা যীশুং পৰিচীয তদ্দেশ্স্য চতুৰ্দিশো ৱাৰ্ত্তাং প্ৰহিত্য যত্ৰ যাৱন্তঃ পীডিতা আসন্, তাৱতএৱ তদন্তিকমানযামাসুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","অপৰং তদীযৱসনস্য গ্ৰন্থিমাত্ৰং স্প্ৰষ্টুং ৱিনীয যাৱন্তো জনাস্তৎ স্পৰ্শং চক্ৰিৰে, তে সৰ্ৱ্ৱএৱ নিৰামযা বভূৱুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","অপৰং যিৰূশালম্নগৰীযাঃ কতিপযা অধ্যাপকাঃ ফিৰূশিনশ্চ যীশোঃ সমীপমাগত্য কথযামাসুঃ, ");
INSERT INTO sanasm_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","তৱ শিষ্যাঃ কিমৰ্থম্ অপ্ৰক্ষালিতকৰৈ ৰ্ভক্ষিৎৱা পৰম্পৰাগতং প্ৰাচীনানাং ৱ্যৱহাৰং লঙ্ৱন্তে? ");
INSERT INTO sanasm_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ততো যীশুঃ প্ৰত্যুৱাচ, যূযং পৰম্পৰাগতাচাৰেণ কুত ঈশ্ৱৰাজ্ঞাং লঙ্ৱধ্ৱে| ");
INSERT INTO sanasm_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ঈশ্ৱৰ ইত্যাজ্ঞাপযৎ, ৎৱং নিজপিতৰৌ সংমন্যেথাঃ, যেন চ নিজপিতৰৌ নিন্দ্যেতে, স নিশ্চিতং ম্ৰিযেত; ");
INSERT INTO sanasm_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","কিন্তু যূযং ৱদথ, যঃ স্ৱজনকং স্ৱজননীং ৱা ৱাক্যমিদং ৱদতি, যুৱাং মত্তো যল্লভেথে, তৎ ন্যৱিদ্যত, ");
INSERT INTO sanasm_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","স নিজপিতৰৌ পুন ৰ্ন সংমংস্যতে| ইত্থং যূযং পৰম্পৰাগতেন স্ৱেষামাচাৰেণেশ্ৱৰীযাজ্ঞাং লুম্পথ| ");
INSERT INTO sanasm_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ৰে কপটিনঃ সৰ্ৱ্ৱে যিশযিযো যুষ্মানধি ভৱিষ্যদ্ৱচনান্যেতানি সম্যগ্ উক্তৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","ৱদনৈ ৰ্মনুজা এতে সমাযান্তি মদন্তিকং| তথাধৰৈ ৰ্মদীযঞ্চ মানং কুৰ্ৱ্ৱন্তি তে নৰাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","কিন্তু তেষাং মনো মত্তো ৱিদূৰএৱ তিষ্ঠতি| শিক্ষযন্তো ৱিধীন্ ন্ৰাজ্ঞা ভজন্তে মাং মুধৈৱ তে| ");
INSERT INTO sanasm_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ততো যীশু ৰ্লোকান্ আহূয প্ৰোক্তৱান্, যূযং শ্ৰুৎৱা বুধ্যধ্বং| ");
INSERT INTO sanasm_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","যন্মুখং প্ৰৱিশতি, তৎ মনুজম্ অমেধ্যং ন কৰোতি, কিন্তু যদাস্যাৎ নিৰ্গচ্ছতি, তদেৱ মানুষমমেধ্যী কৰোতী| ");
INSERT INTO sanasm_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","তদানীং শিষ্যা আগত্য তস্মৈ কথযাঞ্চক্ৰুঃ, এতাং কথাং শ্ৰুৎৱা ফিৰূশিনো ৱ্যৰজ্যন্ত, তৎ কিং ভৱতা জ্ঞাযতে? ");
INSERT INTO sanasm_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","স প্ৰত্যৱদৎ, মম স্ৱৰ্গস্থঃ পিতা যং কঞ্চিদঙ্কুৰং নাৰোপযৎ, স উৎপাৱ্দ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","তে তিষ্ঠন্তু, তে অন্ধমনুজানাম্ অন্ধমাৰ্গদৰ্শকা এৱ; যদ্যন্ধোঽন্ধং পন্থানং দৰ্শযতি, তৰ্হ্যুভৌ গৰ্ত্তে পততঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","তদা পিতৰস্তং প্ৰত্যৱদৎ, দৃষ্টান্তমিমমস্মান্ বোধযতু| ");
INSERT INTO sanasm_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","যীশুনা প্ৰোক্তং, যূযমদ্য যাৱৎ কিমবোধাঃ স্থ? ");
INSERT INTO sanasm_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","কথামিমাং কিং ন বুধ্যধ্বে ? যদাস্যং প্ৰেৱিশতি, তদ্ উদৰে পতন্ বহিৰ্নিৰ্যাতি, ");
INSERT INTO sanasm_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","কিন্ত্ৱাস্যাদ্ যন্নিৰ্যাতি, তদ্ অন্তঃকৰণাৎ নিৰ্যাতৎৱাৎ মনুজমমেধ্যং কৰোতি| ");
INSERT INTO sanasm_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","যতোঽন্তঃকৰণাৎ কুচিন্তা বধঃ পাৰদাৰিকতা ৱেশ্যাগমনং চৈৰ্য্যং মিথ্যাসাক্ষ্যম্ ঈশ্ৱৰনিন্দা চৈতানি সৰ্ৱ্ৱাণি নিৰ্য্যান্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","এতানি মনুষ্যমপৱিত্ৰী কুৰ্ৱ্ৱন্তি কিন্ত্ৱপ্ৰক্ষালিতকৰেণ ভোজনং মনুজমমেধ্যং ন কৰোতি| ");
INSERT INTO sanasm_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","অনন্তৰং যীশুস্তস্মাৎ স্থানাৎ প্ৰস্থায সোৰসীদোন্নগৰযোঃ সীমামুপতস্যৌ| ");
INSERT INTO sanasm_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","তদা তৎসীমাতঃ কাচিৎ কিনানীযা যোষিদ্ আগত্য তমুচ্চৈৰুৱাচ, হে প্ৰভো দাযূদঃ সন্তান, মমৈকা দুহিতাস্তে সা ভূতগ্ৰস্তা সতী মহাক্লেশং প্ৰাপ্নোতি মম দযস্ৱ| ");
INSERT INTO sanasm_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","কিন্তু যীশুস্তাং কিমপি নোক্তৱান্, ততঃ শিষ্যা আগত্য তং নিৱেদযামাসুঃ, এষা যোষিদ্ অস্মাকং পশ্চাদ্ উচ্চৈৰাহূযাগচ্ছতি, এনাং ৱিসৃজতু| ");
INSERT INTO sanasm_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","তদা স প্ৰত্যৱদৎ, ইস্ৰাযেল্গোত্ৰস্য হাৰিতমেষান্ ৱিনা কস্যাপ্যন্যস্য সমীপং নাহং প্ৰেষিতোস্মি| ");
INSERT INTO sanasm_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","ততঃ সা নাৰীসমাগত্য তং প্ৰণম্য জগাদ, হে প্ৰভো মামুপকুৰু| ");
INSERT INTO sanasm_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","স উক্তৱান্, বালকানাং ভক্ষ্যমাদায সাৰমেযেভ্যো দানং নোচিতং| ");
INSERT INTO sanasm_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","তদা সা বভাষে, হে প্ৰভো, তৎ সত্যং, তথাপি প্ৰভো ৰ্ভঞ্চাদ্ যদুচ্ছিষ্টং পততি, তৎ সাৰমেযাঃ খাদন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ততো যীশুঃ প্ৰত্যৱদৎ, হে যোষিৎ, তৱ ৱিশ্ৱাসো মহান্ তস্মাৎ তৱ মনোভিলষিতং সিদ্য্যতু, তেন তস্যাঃ কন্যা তস্মিন্নেৱ দণ্ডে নিৰামযাভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","অনন্তৰং যীশস্তস্মাৎ স্থানাৎ প্ৰস্থায গালীল্সাগৰস্য সন্নিধিমাগত্য ধৰাধৰমাৰুহ্য তত্ৰোপৱিৱেশ| ");
INSERT INTO sanasm_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","পশ্চাৎ জননিৱহো বহূন্ খঞ্চান্ধমূকশুষ্ককৰমানুষান্ আদায যীশোঃ সমীপমাগত্য তচ্চৰণান্তিকে স্থাপযামাসুঃ, ততঃ সা তান্ নিৰামযান্ অকৰোৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ইত্থং মূকা ৱাক্যং ৱদন্তি, শুষ্ককৰাঃ স্ৱাস্থ্যমাযান্তি, পঙ্গৱো গচ্ছন্তি, অন্ধা ৱীক্ষন্তে, ইতি ৱিলোক্য লোকা ৱিস্মযং মন্যমানা ইস্ৰাযেল ঈশ্ৱৰং ধন্যং বভাষিৰে| ");
INSERT INTO sanasm_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","তদানীং যীশুঃ স্ৱশিষ্যান্ আহূয গদিতৱান্, এতজ্জননিৱহেষু মম দযা জাযতে, এতে দিনত্ৰযং মযা সাকং সন্তি, এষাং ভক্ষ্যৱস্তু চ কঞ্চিদপি নাস্তি, তস্মাদহমেতানকৃতাহাৰান্ ন ৱিস্ৰক্ষ্যামি, তথাৎৱে ৱৰ্ত্মমধ্যে ক্লাম্যেষুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","তদা শিষ্যা ঊচুঃ, এতস্মিন্ প্ৰান্তৰমধ্য এতাৱতো মৰ্ত্যান্ তৰ্পযিতুং ৱযং কুত্ৰ পূপান্ প্ৰাপ্স্যামঃ? ");
INSERT INTO sanasm_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","যীশুৰপৃচ্ছৎ, যুষ্মাকং নিকটে কতি পূপা আসতে? ত ঊচুঃ, সপ্তপূপা অল্পাঃ ক্ষুদ্ৰমীনাশ্চ সন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","তদানীং স লোকনিৱহং ভূমাৱুপৱেষ্টুম্ আদিশ্য ");
INSERT INTO sanasm_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","তান্ সপ্তপূপান্ মীনাংশ্চ গৃহ্লন্ ঈশ্ৱৰীযগুণান্ অনূদ্য ভংক্ত্ৱা শিষ্যেভ্যো দদৌ, শিষ্যা লোকেভ্যো দদুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ততঃ সৰ্ৱ্ৱে ভুক্ত্ৱা তৃপ্তৱন্তঃ; তদৱশিষ্টভক্ষ্যেণ সপ্তডলকান্ পৰিপূৰ্য্য সংজগৃহুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","তে ভোক্তাৰো যোষিতো বালকাংশ্চ ৱিহায প্ৰাযেণ চতুঃসহস্ৰাণি পুৰুষা আসন্| ");
INSERT INTO sanasm_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","ততঃ পৰং স জননিৱহং ৱিসৃজ্য তৰিমাৰুহ্য মগ্দলাপ্ৰদেশং গতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","তদানীং ফিৰূশিনঃ সিদূকিনশ্চাগত্য তং পৰীক্ষিতুং নভমীযং কিঞ্চন লক্ষ্ম দৰ্শযিতুং তস্মৈ নিৱেদযামাসুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ততঃ স উক্তৱান্, সন্ধ্যাযাং নভসো ৰক্তৎৱাদ্ যূযং ৱদথ, শ্ৱো নিৰ্ম্মলং দিনং ভৱিষ্যতি; ");
INSERT INTO sanasm_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","প্ৰাতঃকালে চ নভসো ৰক্তৎৱাৎ মলিনৎৱাঞ্চ ৱদথ, ঝঞ্ভ্শদ্য ভৱিষ্যতি| হে কপটিনো যদি যূযম্ অন্তৰীক্ষস্য লক্ষ্ম বোদ্ধুং শক্নুথ, তৰ্হি কালস্যৈতস্য লক্ষ্ম কথং বোদ্ধুং ন শক্নুথ? ");
INSERT INTO sanasm_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","এতৎকালস্য দুষ্টো ৱ্যভিচাৰী চ ৱংশো লক্ষ্ম গৱেষযতি, কিন্তু যূনসো ভৱিষ্যদ্ৱাদিনো লক্ষ্ম ৱিনান্যৎ কিমপি লক্ষ্ম তান্ ন দৰ্শযিয্যতে| তদানীং স তান্ ৱিহায প্ৰতস্থে| ");
INSERT INTO sanasm_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","অনন্তৰমন্যপাৰগমনকালে তস্য শিষ্যাঃ পূপমানেতুং ৱিস্মৃতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","যীশুস্তানৱাদীৎ, যূযং ফিৰূশিনাং সিদূকিনাঞ্চ কিণ্ৱং প্ৰতি সাৱধানাঃ সতৰ্কাশ্চ ভৱত| ");
INSERT INTO sanasm_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","তেন তে পৰস্পৰং ৱিৱিচ্য কথযিতুমাৰেভিৰে, ৱযং পূপানানেতুং ৱিস্মৃতৱন্ত এতৎকাৰণাদ্ ইতি কথযতি| ");
INSERT INTO sanasm_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","কিন্তু যীশুস্তদ্ৱিজ্ঞায তানৱোচৎ, হে স্তোকৱিশ্ৱাসিনো যূযং পূপানানযনমধি কুতঃ পৰস্পৰমেতদ্ ৱিৱিংক্য? ");
INSERT INTO sanasm_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","যুষ্মাভিঃ কিমদ্যাপি ন জ্ঞাযতে? পঞ্চভিঃ পূপৈঃ পঞ্চসহস্ৰপুৰুষেষু ভোজিতেষু ভক্ষ্যোচ্ছিষ্টপূৰ্ণান্ কতি ডলকান্ সমগৃহ্লীতং; ");
INSERT INTO sanasm_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","তথা সপ্তভিঃ পূপৈশ্চতুঃসহস্ৰপুৰুষেষু ভেজিতেষু কতি ডলকান্ সমগৃহ্লীত, তৎ কিং যুষ্মাভিৰ্ন স্মৰ্য্যতে? ");
INSERT INTO sanasm_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","তস্মাৎ ফিৰূশিনাং সিদূকিনাঞ্চ কিণ্ৱং প্ৰতি সাৱধানাস্তিষ্ঠত, কথামিমাম্ অহং পূপানধি নাকথযং, এতদ্ যূযং কুতো ন বুধ্যধ্ৱে? ");
INSERT INTO sanasm_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","তদানীং পূপকিণ্ৱং প্ৰতি সাৱধানাস্তিষ্ঠতেতি নোক্ত্ৱা ফিৰূশিনাং সিদূকিনাঞ্চ উপদেশং প্ৰতি সাৱধানাস্তিষ্ঠতেতি কথিতৱান্, ইতি তৈৰবোধি| ");
INSERT INTO sanasm_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","অপৰঞ্চ যীশুঃ কৈসৰিযা-ফিলিপিপ্ৰদেশমাগত্য শিষ্যান্ অপৃচ্ছৎ, যোঽহং মনুজসুতঃ সোঽহং কঃ? লোকৈৰহং কিমুচ্যে? ");
INSERT INTO sanasm_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","তদানীং তে কথিতৱন্তঃ, কেচিদ্ ৱদন্তি ৎৱং মজ্জযিতা যোহন্, কেচিদ্ৱদন্তি, ৎৱম্ এলিযঃ, কেচিচ্চ ৱদন্তি, ৎৱং যিৰিমিযো ৱা কশ্চিদ্ ভৱিষ্যদ্ৱাদীতি| ");
INSERT INTO sanasm_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","পশ্চাৎ স তান্ পপ্ৰচ্ছ, যূযং মাং কং ৱদথ? ততঃ শিমোন্ পিতৰ উৱাচ, ");
INSERT INTO sanasm_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ৎৱমমৰেশ্ৱৰস্যাভিষিক্তপুত্ৰঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ততো যীশুঃ কথিতৱান্, হে যূনসঃ পুত্ৰ শিমোন্ ৎৱং ধন্যঃ; যতঃ কোপি অনুজস্ত্ৱয্যেতজ্জ্ঞানং নোদপাদযৎ, কিন্তু মম স্ৱৰ্গস্যঃ পিতোদপাদযৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","অতোঽহং ৎৱাং ৱদামি, ৎৱং পিতৰঃ (প্ৰস্তৰঃ) অহঞ্চ তস্য প্ৰস্তৰস্যোপৰি স্ৱমণ্ডলীং নিৰ্ম্মাস্যামি, তেন নিৰযো বলাৎ তাং পৰাজেতুং ন শক্ষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","অহং তুভ্যং স্ৱৰ্গীযৰাজ্যস্য কুঞ্জিকাং দাস্যামি, তেন যৎ কিঞ্চন ৎৱং পৃথিৱ্যাং ভংৎস্যসি তৎস্ৱৰ্গে ভংৎস্যতে, যচ্চ কিঞ্চন মহ্যাং মোক্ষ্যসি তৎ স্ৱৰ্গে মোক্ষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","পশ্চাৎ স শিষ্যানাদিশৎ, অহমভিষিক্তো যীশুৰিতি কথাং কস্মৈচিদপি যূযং মা কথযত| ");
INSERT INTO sanasm_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","অন্যঞ্চ যিৰূশালম্নগৰং গৎৱা প্ৰাচীনলোকেভ্যঃ প্ৰধানযাজকেভ্য উপাধ্যাযেভ্যশ্চ বহুদুঃখভোগস্তৈ ৰ্হতৎৱং তৃতীযদিনে পুনৰুত্থানঞ্চ মমাৱশ্যকম্ এতাঃ কথা যীশুস্তৎকালমাৰভ্য শিষ্যান্ জ্ঞাপযিতুম্ আৰব্ধৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","তদানীং পিতৰস্তস্য কৰং ঘৃৎৱা তৰ্জযিৎৱা কথযিতুমাৰব্ধৱান্, হে প্ৰভো, তৎ ৎৱত্তো দূৰং যাতু, ৎৱাং প্ৰতি কদাপি ন ঘটিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","কিন্তু স ৱদনং পৰাৱৰ্ত্য পিতৰং জগাদ, হে ৱিঘ্নকাৰিন্, মৎসম্মুখাদ্ দূৰীভৱ, ৎৱং মাং বাধসে, ঈশ্ৱৰীযকাৰ্য্যাৎ মানুষীযকাৰ্য্যং তুভ্যং ৰোচতে| ");
INSERT INTO sanasm_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","অনন্তৰং যীশুঃ স্ৱীযশিষ্যান্ উক্তৱান্ যঃ কশ্চিৎ মম পশ্চাদ্গামী ভৱিতুম্ ইচ্ছতি, স স্ৱং দাম্যতু, তথা স্ৱক্ৰুশং গৃহ্লন্ মৎপশ্চাদাযাতু| ");
INSERT INTO sanasm_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","যতো যঃ প্ৰাণান্ ৰক্ষিতুমিচ্ছতি, স তান্ হাৰযিষ্যতি, কিন্তু যো মদৰ্থং নিজপ্ৰাণান্ হাৰযতি, স তান্ প্ৰাপ্স্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","মানুষো যদি সৰ্ৱ্ৱং জগৎ লভতে নিজপ্ৰণান্ হাৰযতি, তৰ্হি তস্য কো লাভঃ? মনুজো নিজপ্ৰাণানাং ৱিনিমযেন ৱা কিং দাতুং শক্নোতি? ");
INSERT INTO sanasm_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","মনুজসুতঃ স্ৱদূতৈঃ সাকং পিতুঃ প্ৰভাৱেণাগমিষ্যতি; তদা প্ৰতিমনুজং স্ৱস্ৱকৰ্ম্মানুসাৰাৎ ফলং দাস্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","অহং যুষ্মান্ তথ্যং ৱচ্মি, সৰাজ্যং মনুজসুতম্ আগতং ন পশ্যন্তো মৃত্যুং ন স্ৱাদিষ্যন্তি, এতাদৃশাঃ কতিপযজনা অত্ৰাপি দণ্ডাযমানাঃ সন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","অনন্তৰং ষড্দিনেভ্যঃ পৰং যীশুঃ পিতৰং যাকূবং তৎসহজং যোহনঞ্চ গৃহ্লন্ উচ্চাদ্ৰে ৰ্ৱিৱিক্তস্থানম্ আগত্য তেষাং সমক্ষং ৰূপমন্যৎ দধাৰ| ");
INSERT INTO sanasm_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","তেন তদাস্যং তেজস্ৱি, তদাভৰণম্ আলোকৱৎ পাণ্ডৰমভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","অন্যচ্চ তেন সাকং সংলপন্তৌ মূসা এলিযশ্চ তেভ্যো দৰ্শনং দদতুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","তদানীং পিতৰো যীশুং জগাদ, হে প্ৰভো স্থিতিৰত্ৰাস্মাকং শুভা, যদি ভৱতানুমন্যতে, তৰ্হি ভৱদৰ্থমেকং মূসাৰ্থমেকম্ এলিযাৰ্থঞ্চৈকম্ ইতি ত্ৰীণি দূষ্যাণি নিৰ্ম্মম| ");
INSERT INTO sanasm_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","এতৎকথনকাল এক উজ্জৱলঃ পযোদস্তেষামুপৰি ছাযাং কৃতৱান্, ৱাৰিদাদ্ এষা নভসীযা ৱাগ্ বভূৱ, মমাযং প্ৰিযঃ পুত্ৰঃ, অস্মিন্ মম মহাসন্তোষ এতস্য ৱাক্যং যূযং নিশামযত| ");
INSERT INTO sanasm_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","কিন্তু ৱাচমেতাং শৃণ্ৱন্তএৱ শিষ্যা মৃশং শঙ্কমানা ন্যুব্জা ন্যপতন্| ");
INSERT INTO sanasm_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","তদা যীশুৰাগত্য তেষাং গাত্ৰাণি স্পৃশন্ উৱাচ, উত্তিষ্ঠত, মা ভৈষ্ট| ");
INSERT INTO sanasm_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","তদানীং নেত্ৰাণ্যুন্মীল্য যীশুং ৱিনা কমপি ন দদৃশুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ততঃ পৰম্ অদ্ৰেৰৱৰোহণকালে যীশুস্তান্ ইত্যাদিদেশ, মনুজসুতস্য মৃতানাং মধ্যাদুত্থানং যাৱন্ন জাযতে, তাৱৎ যুষ্মাভিৰেতদ্দৰ্শনং কস্মৈচিদপি ন কথযিতৱ্যং| ");
INSERT INTO sanasm_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","তদা শিষ্যাস্তং পপ্ৰচ্ছুঃ, প্ৰথমম্ এলিয আযাস্যতীতি কুত উপাধ্যাযৈৰুচ্যতে? ");
INSERT INTO sanasm_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ততো যীশুঃ প্ৰত্যৱাদীৎ, এলিযঃ প্ৰাগেত্য সৰ্ৱ্ৱাণি সাধযিষ্যতীতি সত্যং, ");
INSERT INTO sanasm_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","কিন্ত্ৱহং যুষ্মান্ ৱচ্মি, এলিয এত্য গতঃ, তে তমপৰিচিত্য তস্মিন্ যথেচ্ছং ৱ্যৱজহুঃ; মনুজসুতেনাপি তেষামন্তিকে তাদৃগ্ দুঃখং ভোক্তৱ্যং| ");
INSERT INTO sanasm_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","তদানীং স মজ্জযিতাৰং যোহনমধি কথামেতাং ৱ্যাহৃতৱান্, ইত্থং তচ্ছিষ্যা বুবুধিৰে| ");
INSERT INTO sanasm_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","পশ্চাৎ তেষু জননিৱহস্যান্তিকমাগতেষু কশ্চিৎ মনুজস্তদন্তিকমেত্য জানূনী পাতযিৎৱা কথিতৱান্, ");
INSERT INTO sanasm_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","হে প্ৰভো, মৎপুত্ৰং প্ৰতি কৃপাং ৱিদধাতু, সোপস্মাৰামযেন ভৃশং ৱ্যথিতঃ সন্ পুনঃ পুন ৰ্ৱহ্নৌ মুহু ৰ্জলমধ্যে পততি| ");
INSERT INTO sanasm_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","তস্মাদ্ ভৱতঃ শিষ্যাণাং সমীপে তমানযং কিন্তু তে তং স্ৱাস্থং কৰ্ত্তুং ন শক্তাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","তদা যীশুঃ কথিতৱান্ ৰে অৱিশ্ৱাসিনঃ, ৰে ৱিপথগামিনঃ, পুনঃ কতিকালান্ অহং যুষ্মাকং সন্নিধৌ স্থাস্যামি? কতিকালান্ ৱা যুষ্মান্ সহিষ্যে? তমত্ৰ মমান্তিকমানযত| ");
INSERT INTO sanasm_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","পশ্চাদ্ যীশুনা তৰ্জতএৱ স ভূতস্তং ৱিহায গতৱান্, তদ্দণ্ডএৱ স বালকো নিৰামযোঽভূৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ততঃ শিষ্যা গুপ্তং যীশুমুপাগত্য বভাষিৰে, কুতো ৱযং তং ভূতং ত্যাজযিতুং ন শক্তাঃ? ");
INSERT INTO sanasm_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","যীশুনা তে প্ৰোক্তাঃ, যুষ্মাকমপ্ৰত্যযাৎ; ");
INSERT INTO sanasm_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","যুষ্মানহং তথ্যং ৱচ্মি যদি যুষ্মাকং সৰ্ষপৈকমাত্ৰোপি ৱিশ্ৱাসো জাযতে, তৰ্হি যুষ্মাভিৰস্মিন্ শৈলে ৎৱমিতঃ স্থানাৎ তৎ স্থানং যাহীতি ব্ৰূতে স তদৈৱ চলিষ্যতি, যুষ্মাকং কিমপ্যসাধ্যঞ্চ কৰ্ম্ম ন স্থাস্যাতি| কিন্তু প্ৰাৰ্থনোপৱাসৌ ৱিনৈতাদৃশো ভূতো ন ত্যাজ্যেত| ");
INSERT INTO sanasm_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","অপৰং তেষাং গালীল্প্ৰদেশে ভ্ৰমণকালে যীশুনা তে গদিতাঃ, মনুজসুতো জনানাং কৰেষু সমৰ্পযিষ্যতে তৈ ৰ্হনিষ্যতে চ, ");
INSERT INTO sanasm_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","কিন্তু তৃতীযেঽহি्ন ম উত্থাপিষ্যতে, তেন তে ভৃশং দুঃখিতা বভূৱঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","তদনন্তৰং তেষু কফৰ্নাহূম্নগৰমাগতেষু কৰসংগ্ৰাহিণঃ পিতৰান্তিকমাগত্য পপ্ৰচ্ছুঃ, যুষ্মাকং গুৰুঃ কিং মন্দিৰাৰ্থং কৰং ন দদাতি? ততঃ পিতৰঃ কথিতৱান্ দদাতি| ");
INSERT INTO sanasm_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ততস্তস্মিন্ গৃহমধ্যমাগতে তস্য কথাকথনাৎ পূৰ্ৱ্ৱমেৱ যীশুৰুৱাচ, হে শিমোন্, মেদিন্যা ৰাজানঃ স্ৱস্ৱাপত্যেভ্যঃ কিং ৱিদেশিভ্যঃ কেভ্যঃ কৰং গৃহ্লন্তি? অত্ৰ ৎৱং কিং বুধ্যসে? ততঃ পিতৰ উক্তৱান্, ৱিদেশিভ্যঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","তদা যীশুৰুক্তৱান্, তৰ্হি সন্তানা মুক্তাঃ সন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","তথাপি যথাস্মাভিস্তেষামন্তৰাযো ন জন্যতে, তৎকৃতে জলধেস্তীৰং গৎৱা ৱডিশং ক্ষিপ, তেনাদৌ যো মীন উত্থাস্যতি, তং ঘৃৎৱা তন্মুখে মোচিতে তোলকৈকং ৰূপ্যং প্ৰাপ্স্যসি, তদ্ গৃহীৎৱা তৱ মম চ কৃতে তেভ্যো দেহি| ");
INSERT INTO sanasm_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","তদানীং শিষ্যা যীশোঃ সমীপমাগত্য পৃষ্টৱন্তঃ স্ৱৰ্গৰাজ্যে কঃ শ্ৰেষ্ঠঃ? ");
INSERT INTO sanasm_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","ততো যীশুঃ ক্ষুদ্ৰমেকং বালকং স্ৱসমীপমানীয তেষাং মধ্যে নিধায জগাদ, ");
INSERT INTO sanasm_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","যুষ্মানহং সত্যং ব্ৰৱীমি, যূযং মনোৱিনিমযেন ক্ষুদ্ৰবালৱৎ ন সন্তঃ স্ৱৰ্গৰাজ্যং প্ৰৱেষ্টুং ন শক্নুথ| ");
INSERT INTO sanasm_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","যঃ কশ্চিদ্ এতস্য ক্ষুদ্ৰবালকস্য সমমাত্মানং নম্ৰীকৰোতি, সএৱ স্ৱৰ্গৰাজযে শ্ৰেষ্ঠঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","যঃ কশ্চিদ্ এতাদৃশং ক্ষুদ্ৰবালকমেকং মম নাম্নি গৃহ্লাতি, স মামেৱ গৃহ্লাতি| ");
INSERT INTO sanasm_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","কিন্তু যো জনো মযি কৃতৱিশ্ৱাসানামেতেষাং ক্ষুদ্ৰপ্ৰাণিনাম্ একস্যাপি ৱিধ্নিং জনযতি, কণ্ঠবদ্ধপেষণীকস্য তস্য সাগৰাগাধজলে মজ্জনং শ্ৰেযঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","ৱিঘ্নাৎ জগতঃ সন্তাপো ভৱিষ্যতি, ৱিঘ্নোঽৱশ্যং জনযিষ্যতে, কিন্তু যেন মনুজেন ৱিঘ্নো জনিষ্যতে তস্যৈৱ সন্তাপো ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","তস্মাৎ তৱ কৰশ্চৰণো ৱা যদি ৎৱাং বাধতে, তৰ্হি তং ছিত্ত্ৱা নিক্ষিপ, দ্ৱিকৰস্য দ্ৱিপদস্য ৱা তৱানপ্তৱহ্নৌ নিক্ষেপাৎ, খঞ্জস্য ৱা ছিন্নহস্তস্য তৱ জীৱনে প্ৰৱেশো ৱৰং| ");
INSERT INTO sanasm_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","অপৰং তৱ নেত্ৰং যদি ৎৱাং বাধতে, তৰ্হি তদপ্যুৎপাৱ্য নিক্ষিপ, দ্ৱিনেত্ৰস্য নৰকাগ্নৌ নিক্ষেপাৎ কাণস্য তৱ জীৱনে প্ৰৱেশো ৱৰং| ");
INSERT INTO sanasm_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","তস্মাদৱধদ্ধং, এতেষাং ক্ষুদ্ৰপ্ৰাণিনাম্ একমপি মা তুচ্ছীকুৰুত, ");
INSERT INTO sanasm_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","যতো যুষ্মানহং তথ্যং ব্ৰৱীমি, স্ৱৰ্গে তেষাং দূতা মম স্ৱৰ্গস্থস্য পিতুৰাস্যং নিত্যং পশ্যন্তি| এৱং যে যে হাৰিতাস্তান্ ৰক্ষিতুং মনুজপুত্ৰ আগচ্ছৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","যূযমত্ৰ কিং ৱিৱিংগ্ঘ্ৱে? কস্যচিদ্ যদি শতং মেষাঃ সন্তি, তেষামেকো হাৰ্য্যতে চ, তৰ্হি স একোনশতং মেষান্ ৱিহায পৰ্ৱ্ৱতং গৎৱা তং হাৰিতমেকং কিং ন মৃগযতে? ");
INSERT INTO sanasm_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","যদি চ কদাচিৎ তন্মেষোদ্দেশং লমতে, তৰ্হি যুষ্মানহং সত্যং কথযামি, সোঽৱিপথগামিভ্য একোনশতমেষেভ্যোপি তদেকহেতোৰধিকম্ আহ্লাদতে| ");
INSERT INTO sanasm_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","তদ্ৱদ্ এতেষাং ক্ষুদ্ৰপ্ৰাএिনাম্ একোপি নশ্যতীতি যুষ্মাকং স্ৱৰ্গস্থপিতু ৰ্নাভিমতম্| ");
INSERT INTO sanasm_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","যদ্যপি তৱ ভ্ৰাতা ৎৱযি কিমপ্যপৰাধ্যতি, তৰ্হি গৎৱা যুৱযোৰ্দ্ৱযোঃ স্থিতযোস্তস্যাপৰাধং তং জ্ঞাপয| তত্ৰ স যদি তৱ ৱাক্যং শৃণোতি, তৰ্হি ৎৱং স্ৱভ্ৰাতৰং প্ৰাপ্তৱান্, ");
INSERT INTO sanasm_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","কিন্তু যদি ন শৃণোতি, তৰ্হি দ্ৱাভ্যাং ত্ৰিভি ৰ্ৱা সাক্ষীভিঃ সৰ্ৱ্ৱং ৱাক্যং যথা নিশ্চিতং জাযতে, তদৰ্থম্ একং দ্ৱৌ ৱা সাক্ষিণৌ গৃহীৎৱা যাহি| ");
INSERT INTO sanasm_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","তেন স যদি তযো ৰ্ৱাক্যং ন মান্যতে, তৰ্হি সমাজং তজ্জ্ঞাপয, কিন্তু যদি সমাজস্যাপি ৱাক্যং ন মান্যতে,তৰ্হি স তৱ সমীপে দেৱপূজকইৱ চণ্ডালইৱ চ ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","অহং যুষ্মান্ সত্যং ৱদামি, যুষ্মাভিঃ পৃথিৱ্যাং যদ্ বধ্যতে তৎ স্ৱৰ্গে ভংৎস্যতে; মেদিন্যাং যৎ ভোচ্যতে, স্ৱৰ্গেঽপি তৎ মোক্ষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","পুনৰহং যুষ্মান্ ৱদামি, মেদিন্যাং যুষ্মাকং যদি দ্ৱাৱেকৱাক্যীভূয কিঞ্চিৎ প্ৰাৰ্থযেতে, তৰ্হি মম স্ৱৰ্গস্থপিত্ৰা তৎ তযোঃ কৃতে সম্পন্নং ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","যতো যত্ৰ দ্ৱৌ ত্ৰযো ৱা মম নান্নি মিলন্তি, তত্ৰৈৱাহং তেষাং মধ্যেঽস্মি| ");
INSERT INTO sanasm_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","তদানীং পিতৰস্তৎসমীপমাগত্য কথিতৱান্ হে প্ৰভো, মম ভ্ৰাতা মম যদ্যপৰাধ্যতি, তৰ্হি তং কতিকৃৎৱঃ ক্ষমিষ্যে? ");
INSERT INTO sanasm_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","কিং সপ্তকৃৎৱঃ? যীশুস্তং জগাদ, ৎৱাং কেৱলং সপ্তকৃৎৱো যাৱৎ ন ৱদামি, কিন্তু সপ্তত্যা গুণিতং সপ্তকৃৎৱো যাৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","অপৰং নিজদাসৈঃ সহ জিগণযিষুঃ কশ্চিদ্ ৰাজেৱ স্ৱৰ্গৰাজযং| ");
INSERT INTO sanasm_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","আৰব্ধে তস্মিন্ গণনে সাৰ্দ্ধসহস্ৰমুদ্ৰাপূৰিতানাং দশসহস্ৰপুটকানাম্ একোঽঘমৰ্ণস্তৎসমক্ষমানাযি| ");
INSERT INTO sanasm_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","তস্য পৰিশোধনায দ্ৰৱ্যাভাৱাৎ পৰিশোধনাৰ্থং স তদীযভাৰ্য্যাপুত্ৰাদিসৰ্ৱ্ৱস্ৱঞ্চ ৱিক্ৰীযতামিতি তৎপ্ৰভুৰাদিদেশ| ");
INSERT INTO sanasm_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","তেন স দাসস্তস্য পাদযোঃ পতন্ প্ৰণম্য কথিতৱান্ , হে প্ৰভো ভৱতা ঘৈৰ্য্যে কৃতে মযা সৰ্ৱ্ৱং পৰিশোধিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","তদানীং দাসস্য প্ৰভুঃ সকৰুণঃ সন্ সকলৰ্ণং ক্ষমিৎৱা তং তত্যাজ| ");
INSERT INTO sanasm_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","কিন্তু তস্মিন্ দাসে বহি ৰ্যাতে, তস্য শতং মুদ্ৰাচতুৰ্থাংশান্ যো ধাৰযতি, তং সহদাসং দৃষ্দ্ৱা তস্য কণ্ঠং নিষ্পীড্য গদিতৱান্, মম যৎ প্ৰাপ্যং তৎ পৰিশোধয| ");
INSERT INTO sanasm_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","তদা তস্য সহদাসস্তৎপাদযোঃ পতিৎৱা ৱিনীয বভাষে, ৎৱযা ধৈৰ্য্যে কৃতে মযা সৰ্ৱ্ৱং পৰিশোধিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","তথাপি স তৎ নাঙগীকৃত্য যাৱৎ সৰ্ৱ্ৱমৃণং ন পৰিশোধিতৱান্ তাৱৎ তং কাৰাযাং স্থাপযামাস| ");
INSERT INTO sanasm_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","তদা তস্য সহদাসাস্তস্যৈতাদৃগ্ আচৰণং ৱিলোক্য প্ৰভোঃ সমীপং গৎৱা সৰ্ৱ্ৱং ৱৃত্তান্তং নিৱেদযামাসুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","তদা তস্য প্ৰভুস্তমাহূয জগাদ, ৰে দুষ্ট দাস, ৎৱযা মৎসন্নিধৌ প্ৰাৰ্থিতে মযা তৱ সৰ্ৱ্ৱমৃণং ত্যক্তং; ");
INSERT INTO sanasm_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","যথা চাহং ৎৱযি কৰুণাং কৃতৱান্, তথৈৱ ৎৱৎসহদাসে কৰুণাকৰণং কিং তৱ নোচিতং? ");
INSERT INTO sanasm_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ইতি কথযিৎৱা তস্য প্ৰভুঃ ক্ৰুদ্ধ্যন্ নিজপ্ৰাপ্যং যাৱৎ স ন পৰিশোধিতৱান্, তাৱৎ প্ৰহাৰকানাং কৰেষু তং সমৰ্পিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","যদি যূযং স্ৱান্তঃকৰণৈঃ স্ৱস্ৱসহজানাম্ অপৰাধান্ ন ক্ষমধ্ৱে, তৰ্হি মম স্ৱৰ্গস্যঃ পিতাপি যুষ্মান্ প্ৰতীত্থং কৰিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","অনন্তৰম্ এতাসু কথাসু সমাপ্তাসু যীশু ৰ্গালীলপ্ৰদেশাৎ প্ৰস্থায যৰ্দন্তীৰস্থং যিহূদাপ্ৰদেশং প্ৰাপ্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","তদা তৎপশ্চাৎ জননিৱহে গতে স তত্ৰ তান্ নিৰামযান্ অকৰোৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","তদনন্তৰং ফিৰূশিনস্তৎসমীপমাগত্য পাৰীক্ষিতুং তং পপ্ৰচ্ছুঃ, কস্মাদপি কাৰণাৎ নৰেণ স্ৱজাযা পৰিত্যাজ্যা ন ৱা? ");
INSERT INTO sanasm_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","স প্ৰত্যুৱাচ, প্ৰথমম্ ঈশ্ৱৰো নৰৎৱেন নাৰীৎৱেন চ মনুজান্ সসৰ্জ, তস্মাৎ কথিতৱান্, ");
INSERT INTO sanasm_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","মানুষঃ স্ৱপিতৰৌ পৰিত্যজ্য স্ৱপত্ন্যাম্ আসক্ষ্যতে, তৌ দ্ৱৌ জনাৱেকাঙ্গৌ ভৱিষ্যতঃ, কিমেতদ্ যুষ্মাভি ৰ্ন পঠিতম্? ");
INSERT INTO sanasm_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","অতস্তৌ পুন ৰ্ন দ্ৱৌ তযোৰেকাঙ্গৎৱং জাতং, ঈশ্ৱৰেণ যচ্চ সমযুজ্যত, মনুজো ন তদ্ ভিন্দ্যাৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","তদানীং তে তং প্ৰত্যৱদন্, তথাৎৱে ত্যাজ্যপত্ৰং দত্ত্ৱা স্ৱাং স্ৱাং জাযাং ত্যক্তুং ৱ্যৱস্থাং মূসাঃ কথং লিলেখ? ");
INSERT INTO sanasm_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ততঃ স কথিতৱান্, যুষ্মাকং মনসাং কাঠিন্যাদ্ যুষ্মান্ স্ৱাং স্ৱাং জাযাং ত্যক্তুম্ অন্ৱমন্যত কিন্তু প্ৰথমাদ্ এষো ৱিধিৰ্নাসীৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","অতো যুষ্মানহং ৱদামি, ৱ্যভিচাৰং ৱিনা যো নিজজাযাং ত্যজেৎ অন্যাঞ্চ ৱিৱহেৎ, স পৰদাৰান্ গচ্ছতি; যশ্চ ত্যক্তাং নাৰীং ৱিৱহতি সোপি পৰদাৰেষু ৰমতে| ");
INSERT INTO sanasm_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","তদা তস্য শিষ্যাস্তং বভাষিৰে, যদি স্ৱজাযযা সাকং পুংস এতাদৃক্ সম্বন্ধো জাযতে, তৰ্হি ৱিৱহনমেৱ ন ভদ্ৰং| ");
INSERT INTO sanasm_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ততঃ স উক্তৱান্, যেভ্যস্তৎসামৰ্থ্যং আদাযি, তান্ ৱিনান্যঃ কোপি মনুজ এতন্মতং গ্ৰহীতুং ন শক্নোতি| ");
INSERT INTO sanasm_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","কতিপযা জননক্লীবঃ কতিপযা নৰকৃতক্লীবঃ স্ৱৰ্গৰাজ্যায কতিপযাঃ স্ৱকৃতক্লীবাশ্চ সন্তি, যে গ্ৰহীতুং শক্নুৱন্তি তে গৃহ্লন্তু| ");
INSERT INTO sanasm_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","অপৰম্ যথা স শিশূনাং গাত্ৰেষু হস্তং দৎৱা প্ৰাৰ্থযতে, তদৰ্থং তৎসমীংপং শিশৱ আনীযন্ত, তত আনযিতৃন্ শিষ্যাস্তিৰস্কৃতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","কিন্তু যীশুৰুৱাচ, শিশৱো মদন্তিকম্ আগচ্ছন্তু, তান্ মা ৱাৰযত, এতাদৃশাং শিশূনামেৱ স্ৱৰ্গৰাজ্যং| ");
INSERT INTO sanasm_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ততঃ স তেষাং গাত্ৰেষু হস্তং দৎৱা তস্মাৎ স্থানাৎ প্ৰতস্থে| ");
INSERT INTO sanasm_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","অপৰম্ এক আগত্য তং পপ্ৰচ্ছ, হে পৰমগুৰো, অনন্তাযুঃ প্ৰাপ্তুং মযা কিং কিং সৎকৰ্ম্ম কৰ্ত্তৱ্যং? ");
INSERT INTO sanasm_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ততঃ স উৱাচ, মাং পৰমং কুতো ৱদসি? ৱিনেশ্চৰং ন কোপি পৰমঃ, কিন্তু যদ্যনন্তাযুঃ প্ৰাপ্তুং ৱাঞ্ছসি, তৰ্হ্যাজ্ঞাঃ পালয| ");
INSERT INTO sanasm_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","তদা স পৃষ্টৱান্, কাঃ কা আজ্ঞাঃ? ততো যীশুঃ কথিতৱান্, নৰং মা হন্যাঃ, পৰদাৰান্ মা গচ্ছেঃ, মা চোৰযেঃ, মৃষাসাক্ষ্যং মা দদ্যাঃ, ");
INSERT INTO sanasm_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","নিজপিতৰৌ সংমন্যস্ৱ, স্ৱসমীপৱাসিনি স্ৱৱৎ প্ৰেম কুৰু| ");
INSERT INTO sanasm_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","স যুৱা কথিতৱান্, আ বাল্যাদ্ এতাঃ পালযামি, ইদানীং কিং ন্যূনমাস্তে? ");
INSERT INTO sanasm_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ততো যীশুৰৱদৎ, যদি সিদ্ধো ভৱিতুং ৱাঞ্ছসি, তৰ্হি গৎৱা নিজসৰ্ৱ্ৱস্ৱং ৱিক্ৰীয দৰিদ্ৰেভ্যো ৱিতৰ, ততঃ স্ৱৰ্গে ৱিত্তং লপ্স্যসে; আগচ্ছ, মৎপশ্চাদ্ৱৰ্ত্তী চ ভৱ| ");
INSERT INTO sanasm_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","এতাং ৱাচং শ্ৰুৎৱা স যুৱা স্ৱীযবহুসম্পত্তে ৰ্ৱিষণঃ সন্ চলিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","তদা যীশুঃ স্ৱশিষ্যান্ অৱদৎ, ধনিনাং স্ৱৰ্গৰাজ্যপ্ৰৱেশো মহাদুষ্কৰ ইতি যুষ্মানহং তথ্যং ৱদামি| ");
INSERT INTO sanasm_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","পুনৰপি যুষ্মানহং ৱদামি, ধনিনাং স্ৱৰ্গৰাজ্যপ্ৰৱেশাৎ সূচীছিদ্ৰেণ মহাঙ্গগমনং সুকৰং| ");
INSERT INTO sanasm_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ইতি ৱাক্যং নিশম্য শিষ্যা অতিচমৎকৃত্য কথযামাসুঃ; তৰ্হি কস্য পৰিত্ৰাণং ভৱিতুং শক্নোতি? ");
INSERT INTO sanasm_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","তদা স তান্ দৃষ্দ্ৱা কথযামাস, তৎ মানুষাণামশক্যং ভৱতি, কিন্ত্ৱীশ্ৱৰস্য সৰ্ৱ্ৱং শক্যম্| ");
INSERT INTO sanasm_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","তদা পিতৰস্তং গদিতৱান্, পশ্য, ৱযং সৰ্ৱ্ৱং পৰিত্যজ্য ভৱতঃ পশ্চাদ্ৱৰ্ত্তিনো ঽভৱাম; ৱযং কিং প্ৰাপ্স্যামঃ? ");
INSERT INTO sanasm_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ততো যীশুঃ কথিতৱান্, যুষ্মানহং তথ্যং ৱদামি, যূযং মম পশ্চাদ্ৱৰ্ত্তিনো জাতা ইতি কাৰণাৎ নৱীনসৃষ্টিকালে যদা মনুজসুতঃ স্ৱীযৈশ্চৰ্য্যসিংহাসন উপৱেক্ষ্যতি, তদা যূযমপি দ্ৱাদশসিংহাসনেষূপৱিশ্য ইস্ৰাযেলীযদ্ৱাদশৱংশানাং ৱিচাৰং কৰিষ্যথ| ");
INSERT INTO sanasm_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","অন্যচ্চ যঃ কশ্চিৎ মম নামকাৰণাৎ গৃহং ৱা ভ্ৰাতৰং ৱা ভগিনীং ৱা পিতৰং ৱা মাতৰং ৱা জাযাং ৱা বালকং ৱা ভূমিং পৰিত্যজতি, স তেষাং শতগুণং লপ্স্যতে, অনন্তাযুমোঽধিকাৰিৎৱঞ্চ প্ৰাপ্স্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","কিন্তু অগ্ৰীযা অনেকে জনাঃ পশ্চাৎ, পশ্চাতীযাশ্চানেকে লোকা অগ্ৰে ভৱিষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","স্ৱৰ্গৰাজ্যম্ এতাদৃশা কেনচিদ্ গৃহস্যেন সমং, যোঽতিপ্ৰভাতে নিজদ্ৰাক্ষাক্ষেত্ৰে কৃষকান্ নিযোক্তুং গতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","পশ্চাৎ তৈঃ সাকং দিনৈকভৃতিং মুদ্ৰাচতুৰ্থাংশং নিৰূপ্য তান্ দ্ৰাক্ষাক্ষেত্ৰং প্ৰেৰযামাস| ");
INSERT INTO sanasm_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","অনন্তৰং প্ৰহৰৈকৱেলাযাং গৎৱা হট্টে কতিপযান্ নিষ্কৰ্ম্মকান্ ৱিলোক্য তানৱদৎ, ");
INSERT INTO sanasm_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","যূযমপি মম দ্ৰাক্ষাক্ষেত্ৰং যাত, যুষ্মভ্যমহং যোগ্যভৃতিং দাস্যামি, ততস্তে ৱৱ্ৰজুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","পুনশ্চ স দ্ৱিতীযতৃতীযযোঃ প্ৰহৰযো ৰ্বহি ৰ্গৎৱা তথৈৱ কৃতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","ততো দণ্ডদ্ৱযাৱশিষ্টাযাং ৱেলাযাং বহি ৰ্গৎৱাপৰান্ কতিপযজনান্ নিষ্কৰ্ম্মকান্ ৱিলোক্য পৃষ্টৱান্, যূযং কিমৰ্থম্ অত্ৰ সৰ্ৱ্ৱং দিনং নিষ্কৰ্ম্মাণস্তিষ্ঠথ? ");
INSERT INTO sanasm_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","তে প্ৰত্যৱদন্, অস্মান্ ন কোপি কৰ্মমণি নিযুংক্তে| তদানীং স কথিতৱান্, যূযমপি মম দ্ৰাক্ষাক্ষেত্ৰং যাত, তেন যোগ্যাং ভৃতিং লপ্স্যথ| ");
INSERT INTO sanasm_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","তদনন্তৰং সন্ধ্যাযাং সত্যাং সএৱ দ্ৰাক্ষাক্ষেত্ৰপতিৰধ্যক্ষং গদিৱান্, কৃষকান্ আহূয শেষজনমাৰভ্য প্ৰথমং যাৱৎ তেভ্যো ভৃতিং দেহি| ");
INSERT INTO sanasm_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","তেন যে দণ্ডদ্ৱযাৱস্থিতে সমাযাতাস্তেষাম্ একৈকো জনো মুদ্ৰাচতুৰ্থাংশং প্ৰাপ্নোৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","তদানীং প্ৰথমনিযুক্তা জনা আগত্যানুমিতৱন্তো ৱযমধিকং প্ৰপ্স্যামঃ, কিন্তু তৈৰপি মুদ্ৰাচতুৰ্থাংশোঽলাভি| ");
INSERT INTO sanasm_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ততস্তে তং গৃহীৎৱা তেন ক্ষেত্ৰপতিনা সাকং ৱাগ্যুদ্ধং কুৰ্ৱ্ৱন্তঃ কথযামাসুঃ, ");
INSERT INTO sanasm_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ৱযং কৃৎস্নং দিনং তাপক্লেশৌ সোঢৱন্তঃ, কিন্তু পশ্চাতাযা সে জনা দণ্ডদ্ৱযমাত্ৰং পৰিশ্ৰান্তৱন্তস্তেঽস্মাভিঃ সমানাংশাঃ কৃতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","ততঃ স তেষামেকং প্ৰত্যুৱাচ, হে ৱৎস, মযা ৎৱাং প্ৰতি কোপ্যন্যাযো ন কৃতঃ কিং ৎৱযা মৎসমক্ষং মুদ্ৰাচতুৰ্থাংশো নাঙ্গীকৃতঃ? ");
INSERT INTO sanasm_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","তস্মাৎ তৱ যৎ প্ৰাপ্যং তদাদায যাহি, তুভ্যং যতি, পশ্চাতীযনিযুক্তলোকাযাপি ততি দাতুমিচ্ছামি| ");
INSERT INTO sanasm_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","স্ৱেচ্ছযা নিজদ্ৰৱ্যৱ্যৱহৰণং কিং মযা ন কৰ্ত্তৱ্যং? মম দাতৃৎৱাৎ ৎৱযা কিম্ ঈৰ্ষ্যাদৃষ্টিঃ ক্ৰিযতে? ");
INSERT INTO sanasm_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","ইত্থম্ অগ্ৰীযলোকাঃ পশ্চতীযা ভৱিষ্যন্তি, পশ্চাতীযজনাশ্চগ্ৰীযা ভৱিষ্যন্তি, অহূতা বহৱঃ কিন্ত্ৱল্পে মনোভিলষিতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","তদনন্তৰং যীশু ৰ্যিৰূশালম্নগৰং গচ্ছন্ মাৰ্গমধ্যে শিষ্যান্ একান্তে ৱভাষে, ");
INSERT INTO sanasm_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","পশ্য ৱযং যিৰূশালম্নগৰং যামঃ, তত্ৰ প্ৰধানযাজকাধ্যাপকানাং কৰেষু মনুষ্যপুত্ৰঃ সমৰ্পিষ্যতে; ");
INSERT INTO sanasm_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","তে চ তং হন্তুমাজ্ঞাপ্য তিৰস্কৃত্য ৱেত্ৰেণ প্ৰহৰ্ত্তুং ক্ৰুশে ধাতযিতুঞ্চান্যদেশীযানাং কৰেষু সমৰ্পযিষ্যন্তি, কিন্তু স তৃতীযদিৱসে শ্মশানাদ্ উত্থাপিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","তদানীং সিৱদীযস্য নাৰী স্ৱপুত্ৰাৱাদায যীশোঃ সমীপম্ এত্য প্ৰণম্য কঞ্চনানুগ্ৰহং তং যযাচে| ");
INSERT INTO sanasm_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","তদা যীশুস্তাং প্ৰোক্তৱান্, ৎৱং কিং যাচসে? ততঃ সা বভাষে, ভৱতো ৰাজৎৱে মমানযোঃ সুতযোৰেকং ভৱদ্দক্ষিণপাৰ্শ্ৱে দ্ৱিতীযং ৱামপাৰ্শ্ৱ উপৱেষ্টুম্ আজ্ঞাপযতু| ");
INSERT INTO sanasm_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","যীশুঃ প্ৰত্যুৱাচ, যুৱাভ্যাং যদ্ যাচ্যতে, তন্ন বুধ্যতে, অহং যেন কংসেন পাস্যামি যুৱাভ্যাং কিং তেন পাতুং শক্যতে? অহঞ্চ যেন মজ্জেনেন মজ্জিষ্যে, যুৱাভ্যাং কিং তেন মজ্জযিতুং শক্যতে? তে জগদুঃ শক্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","তদা স উক্তৱান্, যুৱাং মম কংসেনাৱশ্যং পাস্যথঃ, মম মজ্জনেন চ যুৱামপি মজ্জিষ্যেথে, কিন্তু যেষাং কৃতে মত্তাতেন নিৰূপিতম্ ইদং তান্ ৱিহাযান্যং কমপি মদ্দক্ষিণপাৰ্শ্ৱে ৱামপাৰ্শ্ৱে চ সমুপৱেশযিতুং মমাধিকাৰো নাস্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","এতাং কথাং শ্ৰুৎৱান্যে দশশিষ্যাস্তৌ ভ্ৰাতৰৌ প্ৰতি চুকুপুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","কিন্তু যীশুঃ স্ৱসমীপং তানাহূয জগাদ, অন্যদেশীযলোকানাং নৰপতযস্তান্ অধিকুৰ্ৱ্ৱন্তি, যে তু মহান্তস্তে তান্ শাসতি, ইতি যূযং জানীথ| ");
INSERT INTO sanasm_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","কিন্তু যুষ্মাকং মধ্যে ন তথা ভৱেৎ, যুষ্মাকং যঃ কশ্চিৎ মহান্ বুভূষতি, স যুষ্মান্ সেৱেত; ");
INSERT INTO sanasm_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","যশ্চ যুষ্মাকং মধ্যে মুখ্যো বুভূষতি, স যুষ্মাকং দাসো ভৱেৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ইত্থং মনুজপুত্ৰঃ সেৱ্যো ভৱিতুং নহি, কিন্তু সেৱিতুং বহূনাং পৰিত্ৰাণমূল্যাৰ্থং স্ৱপ্ৰাণান্ দাতুঞ্চাগতঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","অনন্তৰং যিৰীহোনগৰাৎ তেষাং বহিৰ্গমনসমযে তস্য পশ্চাদ্ বহৱো লোকা ৱৱ্ৰজুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","অপৰং ৱৰ্ত্মপাৰ্শ্ৱ উপৱিশন্তৌ দ্ৱাৱন্ধৌ তেন মাৰ্গেণ যীশো ৰ্গমনং নিশম্য প্ৰোচ্চৈঃ কথযামাসতুঃ, হে প্ৰভো দাযূদঃ সন্তান, আৱযো ৰ্দযাং ৱিধেহি| ");
INSERT INTO sanasm_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ততো লোকাঃ সৰ্ৱ্ৱে তুষ্ণীম্ভৱতমিত্যুক্ত্ৱা তৌ তৰ্জযামাসুঃ; তথাপি তৌ পুনৰুচ্চৈঃ কথযামাসতুঃ হে প্ৰভো দাযূদঃ সন্তান, আৱাং দযস্ৱ| ");
INSERT INTO sanasm_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","তদানীং যীশুঃ স্থগিতঃ সন্ তাৱাহূয ভাষিতৱান্, যুৱযোঃ কৃতে মযা কিং কৰ্ত্তৰ্ৱ্যং? যুৱাং কিং কামযেথে? ");
INSERT INTO sanasm_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","তদা তাৱুক্তৱন্তৌ, প্ৰভো নেত্ৰাণি নৌ প্ৰসন্নানি ভৱেযুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","তদানীং যীশুস্তৌ প্ৰতি প্ৰমন্নঃ সন্ তযো ৰ্নেত্ৰাণি পস্পৰ্শ, তেনৈৱ তৌ সুৱীক্ষাঞ্চক্ৰাতে তৎপশ্চাৎ জগ্মুতুশ্চ| ");
INSERT INTO sanasm_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","অনন্তৰং তেষু যিৰূশালম্নগৰস্য সমীপৱেৰ্ত্তিনো জৈতুননামকধৰাধৰস্য সমীপস্থ্তিং বৈৎফগিগ্ৰামম্ আগতেষু, যীশুঃ শিষ্যদ্ৱযং প্ৰেষযন্ জগাদ, ");
INSERT INTO sanasm_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","যুৱাং সম্মুখস্থগ্ৰামং গৎৱা বদ্ধাং যাং সৱৎসাং গৰ্দ্দভীং হঠাৎ প্ৰাপ্স্যথঃ, তাং মোচযিৎৱা মদন্তিকম্ আনযতং| ");
INSERT INTO sanasm_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","তত্ৰ যদি কশ্চিৎ কিঞ্চিদ্ ৱক্ষ্যতি, তৰ্হি ৱদিষ্যথঃ, এতস্যাং প্ৰভোঃ প্ৰযোজনমাস্তে, তেন স তৎক্ষণাৎ প্ৰহেষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","সীযোনঃ কন্যকাং যূযং ভাষধ্ৱমিতি ভাৰতীং| পশ্য তে নম্ৰশীলঃ সন্ নৃপ আৰুহ্য গৰ্দভীং| অৰ্থাদাৰুহ্য তদ্ৱৎসমাযাস্যতি ৎৱদন্তিকং| ");
INSERT INTO sanasm_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","ভৱিষ্যদ্ৱাদিনোক্তং ৱচনমিদং তদা সফলমভূৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","অনন্তৰং তৌ শ্ষ্যিौ যীশো ৰ্যথানিদেশং তং গ্ৰামং গৎৱা ");
INSERT INTO sanasm_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","গৰ্দভীং তদ্ৱৎসঞ্চ সমানীতৱন্তৌ, পশ্চাৎ তদুপৰি স্ৱীযৱসনানী পাতযিৎৱা তমাৰোহযামাসতুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ততো বহৱো লোকা নিজৱসনানি পথি প্ৰসাৰযিতুমাৰেভিৰে, কতিপযা জনাশ্চ পাদপপৰ্ণাদিকং ছিৎৱা পথি ৱিস্তাৰযামাসুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","অগ্ৰগামিনঃ পশ্চাদ্গামিনশ্চ মনুজা উচ্চৈৰ্জয জয দাযূদঃ সন্তানেতি জগদুঃ পৰমেশ্ৱৰস্য নাম্না য আযাতি স ধন্যঃ, সৰ্ৱ্ৱোপৰিস্থস্ৱৰ্গেপি জযতি| ");
INSERT INTO sanasm_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ইত্থং তস্মিন্ যিৰূশালমং প্ৰৱিষ্টে কোঽযমিতি কথনাৎ কৃৎস্নং নগৰং চঞ্চলমভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","তত্ৰ লোকোঃ কথযামাসুঃ, এষ গালীল্প্ৰদেশীয-নাসৰতীয-ভৱিষ্যদ্ৱাদী যীশুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","অনন্তৰং যীশুৰীশ্ৱৰস্য মন্দিৰং প্ৰৱিশ্য তন্মধ্যাৎ ক্ৰযৱিক্ৰযিণো ৱহিশ্চকাৰ; ৱণিজাং মুদ্ৰাসনানী কপোতৱিক্ৰযিণাঞ্চসনানী চ ন্যুৱ্জযামাস| ");
INSERT INTO sanasm_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","অপৰং তানুৱাচ, এষা লিপিৰাস্তে, \"মম গৃহং প্ৰাৰ্থনাগৃহমিতি ৱিখ্যাস্যতি\", কিন্তু যূযং তদ্ দস্যূনাং গহ্ৱৰং কৃতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","তদনন্তৰম্ অন্ধখঞ্চলোকাস্তস্য সমীপমাগতাঃ, স তান্ নিৰামযান্ কৃতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","যদা প্ৰধানযাজকা অধ্যাপকাশ্চ তেন কৃতান্যেতানি চিত্ৰকৰ্ম্মাণি দদৃশুঃ, জয জয দাযূদঃ সন্তান, মন্দিৰে বালকানাম্ এতাদৃশম্ উচ্চধ্ৱনিং শুশ্ৰুৱুশ্চ, তদা মহাক্ৰুদ্ধা বভূৱঃ, ");
INSERT INTO sanasm_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","তং পপ্ৰচ্ছুশ্চ, ইমে যদ্ ৱদন্তি, তৎ কিং ৎৱং শৃণোষি? ততো যীশুস্তান্ অৱোচৎ, সত্যম্; স্তন্যপাযিশিশূনাঞ্চ বালকানাঞ্চ ৱক্ত্ৰতঃ| স্ৱকীযং মহিমানং ৎৱং সংপ্ৰকাশযসি স্ৱযং| এতদ্ৱাক্যং যূযং কিং নাপঠত? ");
INSERT INTO sanasm_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ততস্তান্ ৱিহায স নগৰাদ্ বৈথনিযাগ্ৰামং গৎৱা তত্ৰ ৰজনীং যাপযামাস| ");
INSERT INTO sanasm_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","অনন্তৰং প্ৰভাতে সতি যীশুঃ পুনৰপি নগৰমাগচ্ছন্ ক্ষুধাৰ্ত্তো বভূৱ| ");
INSERT INTO sanasm_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ততো মাৰ্গপাৰ্শ্ৱ উডুম্বৰৱৃক্ষমেকং ৱিলোক্য তৎসমীপং গৎৱা পত্ৰাণি ৱিনা কিমপি ন প্ৰাপ্য তং পাদপং প্ৰোৱাচ, অদ্যাৰভ্য কদাপি ৎৱযি ফলং ন ভৱতু; তেন তৎক্ষণাৎ স উডুম্বৰমাহীৰুহঃ শুষ্কতাং গতঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","তদ্ দৃষ্ট্ৱা শিষ্যা আশ্চৰ্য্যং ৱিজ্ঞায কথযামাসুঃ, আঃ, উডুম্ৱৰপাদপোঽতিতূৰ্ণং শুষ্কোঽভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ততো যীশুস্তানুৱাচ, যুষ্মানহং সত্যং ৱদামি, যদি যূযমসন্দিগ্ধাঃ প্ৰতীথ, তৰ্হি যূযমপি কেৱলোডুম্ৱৰপাদপং প্ৰতীত্থং কৰ্ত্তুং শক্ষ্যথ, তন্ন, ৎৱং চলিৎৱা সাগৰে পতেতি ৱাক্যং যুষ্মাভিৰস্মিন শৈলে প্ৰোক্তেপি তদৈৱ তদ্ ঘটিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","তথা ৱিশ্ৱস্য প্ৰাৰ্থ্য যুষ্মাভি ৰ্যদ্ যাচিষ্যতে, তদেৱ প্ৰাপ্স্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","অনন্তৰং মন্দিৰং প্ৰৱিশ্যোপদেশনসমযে তৎসমীপং প্ৰধানযাজকাঃ প্ৰাচীনলোকাশ্চাগত্য পপ্ৰচ্ছুঃ, ৎৱযা কেন সামৰ্থ্যনৈতানি কৰ্ম্মাণি ক্ৰিযন্তে? কেন ৱা তুভ্যমেতানি সামৰ্থ্যানি দত্তানি? ");
INSERT INTO sanasm_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ততো যীশুঃ প্ৰত্যৱদৎ, অহমপি যুষ্মান্ ৱাচমেকাং পৃচ্ছামি, যদি যূযং তদুত্তৰং দাতুং শক্ষ্যথ, তদা কেন সামৰ্থ্যেন কৰ্ম্মাণ্যেতানি কৰোমি, তদহং যুষ্মান্ ৱক্ষ্যামি| ");
INSERT INTO sanasm_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","যোহনো মজ্জনং কস্যাজ্ঞযাভৱৎ? কিমীশ্ৱৰস্য মনুষ্যস্য ৱা? ততস্তে পৰস্পৰং ৱিৱিচ্য কথযামাসুঃ, যদীশ্ৱৰস্যেতি ৱদামস্তৰ্হি যূযং তং কুতো ন প্ৰত্যৈত? ৱাচমেতাং ৱক্ষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","মনুষ্যস্যেতি ৱক্তুমপি লোকেভ্যো বিভীমঃ, যতঃ সৰ্ৱ্ৱৈৰপি যোহন্ ভৱিষ্যদ্ৱাদীতি জ্ঞাযতে| ");
INSERT INTO sanasm_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","তস্মাৎ তে যীশুং প্ৰত্যৱদন্, তদ্ ৱযং ন ৱিদ্মঃ| তদা স তানুক্তৱান্, তৰ্হি কেন সামৰথ্যেন কৰ্ম্মাণ্যেতান্যহং কৰোমি, তদপ্যহং যুষ্মান্ ন ৱক্ষ্যামি| ");
INSERT INTO sanasm_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","কস্যচিজ্জনস্য দ্ৱৌ সুতাৱাস্তাং স একস্য সুতস্য সমীপং গৎৱা জগাদ, হে সুত, ৎৱমদ্য মম দ্ৰাক্ষাক্ষেত্ৰে কৰ্ম্ম কৰ্তুং ৱ্ৰজ| ");
INSERT INTO sanasm_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ততঃ স উক্তৱান্, ন যাস্যামি, কিন্তু শেষেঽনুতপ্য জগাম| ");
INSERT INTO sanasm_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","অনন্তৰং সোন্যসুতস্য সমীপং গৎৱা তথৈৱ কথ্তিৱান্; ততঃ স প্ৰত্যুৱাচ, মহেচ্ছ যামি, কিন্তু ন গতঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","এতযোঃ পুত্ৰযো ৰ্মধ্যে পিতুৰভিমতং কেন পালিতং? যুষ্মাভিঃ কিং বুধ্যতে? ততস্তে প্ৰত্যূচুঃ, প্ৰথমেন পুुত্ৰেণ| তদানীং যীশুস্তানুৱাচ, অহং যুষ্মান্ তথ্যং ৱদামি, চণ্ডালা গণিকাশ্চ যুষ্মাকমগ্ৰত ঈশ্ৱৰস্য ৰাজ্যং প্ৰৱিশন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","যতো যুষ্মাকং সমীপং যোহনি ধৰ্ম্মপথেনাগতে যূযং তং ন প্ৰতীথ, কিন্তু চণ্ডালা গণিকাশ্চ তং প্ৰত্যাযন্, তদ্ ৱিলোক্যাপি যূযং প্ৰত্যেতুং নাখিদ্যধ্ৱং| ");
INSERT INTO sanasm_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","অপৰমেকং দৃষ্টান্তং শৃণুত, কশ্চিদ্ গৃহস্থঃ ক্ষেত্ৰে দ্ৰাক্ষালতা ৰোপযিৎৱা তচ্চতুৰ্দিক্ষু ৱাৰণীং ৱিধায তন্মধ্যে দ্ৰাক্ষাযন্ত্ৰং স্থাপিতৱান্, মাঞ্চঞ্চ নিৰ্ম্মিতৱান্, ততঃ কৃষকেষু তৎ ক্ষেত্ৰং সমৰ্প্য স্ৱযং দূৰদেশং জগাম| ");
INSERT INTO sanasm_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","তদনন্তৰং ফলসময উপস্থিতে স ফলানি প্ৰাপ্তুং কৃষীৱলানাং সমীপং নিজদাসান্ প্ৰেষযামাস| ");
INSERT INTO sanasm_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","কিন্তু কৃষীৱলাস্তস্য তান্ দাসেযান্ ধৃৎৱা কঞ্চন প্ৰহৃতৱন্তঃ, কঞ্চন পাষাণৈৰাহতৱন্তঃ, কঞ্চন চ হতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","পুনৰপি স প্ৰভুঃ প্ৰথমতোঽধিকদাসেযান্ প্ৰেষযামাস, কিন্তু তে তান্ প্ৰত্যপি তথৈৱ চক্ৰুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","অনন্তৰং মম সুতে গতে তং সমাদৰিষ্যন্তে, ইত্যুক্ত্ৱা শেষে স নিজসুতং তেষাং সন্নিধিং প্ৰেষযামাস| ");
INSERT INTO sanasm_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","কিন্তু তে কৃষীৱলাঃ সুতং ৱীক্ষ্য পৰস্পৰম্ ইতি মন্ত্ৰযিতুম্ আৰেভিৰে, অযমুত্তৰাধিকাৰী ৱযমেনং নিহত্যাস্যাধিকাৰং স্ৱৱশীকৰিষ্যামঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","পশ্চাৎ তে তং ধৃৎৱা দ্ৰাক্ষাক্ষেত্ৰাদ্ বহিঃ পাতযিৎৱাবধিষুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","যদা স দ্ৰাক্ষাক্ষেত্ৰপতিৰাগমিষ্যতি, তদা তান্ কৃষীৱলান্ কিং কৰিষ্যতি? ");
INSERT INTO sanasm_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ততস্তে প্ৰত্যৱদন্, তান্ কলুষিণো দাৰুণযাতনাভিৰাহনিষ্যতি, যে চ সমযানুক্ৰমাৎ ফলানি দাস্যন্তি, তাদৃশেষু কৃষীৱলেষু ক্ষেত্ৰং সমৰ্পযিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","তদা যীশুনা তে গদিতাঃ, গ্ৰহণং ন কৃতং যস্য পাষাণস্য নিচাযকৈঃ| প্ৰধানপ্ৰস্তৰঃ কোণে সএৱ সংভৱিষ্যতি| এতৎ পৰেশিতুঃ কৰ্ম্মাস্মদৃষ্টাৱদ্ভুতং ভৱেৎ| ধৰ্ম্মগ্ৰন্থে লিখিতমেতদ্ৱচনং যুষ্মাভিঃ কিং নাপাঠি? ");
INSERT INTO sanasm_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","তস্মাদহং যুষ্মান্ ৱদামি, যুষ্মত্ত ঈশ্ৱৰীযৰাজ্যমপনীয ফলোৎপাদযিত্ৰন্যজাতযে দাযিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","যো জন এতৎপাষাণোপৰি পতিষ্যতি, তং স ভংক্ষ্যতে, কিন্ত্ৱযং পাষাণো যস্যোপৰি পতিষ্যতি, তং স ধূলিৱৎ চূৰ্ণীকৰিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","তদানীং প্ৰাধনযাজকাঃ ফিৰূশিনশ্চ তস্যেমাং দৃষ্টান্তকথাং শ্ৰুৎৱা সোঽস্মানুদ্দিশ্য কথিতৱান্, ইতি ৱিজ্ঞায তং ধৰ্ত্তুং চেষ্টিতৱন্তঃ; ");
INSERT INTO sanasm_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","কিন্তু লোকেভ্যো বিভ্যুঃ, যতো লোকৈঃ স ভৱিষ্যদ্ৱাদীত্যজ্ঞাযি| ");
INSERT INTO sanasm_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","অনন্তৰং যীশুঃ পুনৰপি দৃষ্টান্তেন তান্ অৱাদীৎ, ");
INSERT INTO sanasm_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","স্ৱৰ্গীযৰাজ্যম্ এতাদৃশস্য নৃপতেঃ সমং, যো নিজ পুত্ৰং ৱিৱাহযন্ সৰ্ৱ্ৱান্ নিমন্ত্ৰিতান্ আনেতুং দাসেযান্ প্ৰহিতৱান্, ");
INSERT INTO sanasm_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","কিন্তু তে সমাগন্তুং নেষ্টৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","ততো ৰাজা পুনৰপি দাসানন্যান্ ইত্যুক্ত্ৱা প্ৰেষযামাস, নিমন্ত্ৰিতান্ ৱদত, পশ্যত, মম ভেজ্যমাসাদিতমাস্তে, নিজৱ্টষাদিপুষ্টজন্তূন্ মাৰযিৎৱা সৰ্ৱ্ৱং খাদ্যদ্ৰৱ্যমাসাদিতৱান্, যূযং ৱিৱাহমাগচ্ছত| ");
INSERT INTO sanasm_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","তথপি তে তুচ্ছীকৃত্য কেচিৎ নিজক্ষেত্ৰং কেচিদ্ ৱাণিজ্যং প্ৰতি স্ৱস্ৱমাৰ্গেণ চলিতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","অন্যে লোকাস্তস্য দাসেযান্ ধৃৎৱা দৌৰাত্ম্যং ৱ্যৱহৃত্য তানৱধিষুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","অনন্তৰং স নৃপতিস্তাং ৱাৰ্ত্তাং শ্ৰুৎৱা ক্ৰুধ্যন্ সৈন্যানি প্ৰহিত্য তান্ ঘাতকান্ হৎৱা তেষাং নগৰং দাহযামাস| ");
INSERT INTO sanasm_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","ততঃ স নিজদাসেযান্ বভাষে, ৱিৱাহীযং ভোজ্যমাসাদিতমাস্তে, কিন্তু নিমন্ত্ৰিতা জনা অযোগ্যাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","তস্মাদ্ যূযং ৰাজমাৰ্গং গৎৱা যাৱতো মনুজান্ পশ্যত, তাৱতএৱ ৱিৱাহীযভোজ্যায নিমন্ত্ৰযত| ");
INSERT INTO sanasm_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","তদা তে দাসেযা ৰাজমাৰ্গং গৎৱা ভদ্ৰান্ অভদ্ৰান্ ৱা যাৱতো জনান্ দদৃশুঃ, তাৱতএৱ সংগৃহ্যানযন্; ততোঽভ্যাগতমনুজৈ ৰ্ৱিৱাহগৃহম্ অপূৰ্য্যত| ");
INSERT INTO sanasm_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","তদানীং স ৰাজা সৰ্ৱ্ৱানভ্যাগতান্ দ্ৰষ্টুম্ অভ্যন্তৰমাগতৱান্; তদা তত্ৰ ৱিৱাহীযৱসনহীনমেকং জনং ৱীক্ষ্য তং জগাদ্, ");
INSERT INTO sanasm_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","হে মিত্ৰ,ৎৱং ৱিৱাহীযৱসনং ৱিনা কথমত্ৰ প্ৰৱিষ্টৱান্? তেন স নিৰুত্তৰো বভূৱ| ");
INSERT INTO sanasm_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","তদা ৰাজা নিজানুচৰান্ অৱদৎ, এতস্য কৰচৰণান্ বদ্ধা যত্ৰ ৰোদনং দন্তৈৰ্দন্তঘৰ্ষণঞ্চ ভৱতি, তত্ৰ ৱহিৰ্ভূততমিস্ৰে তং নিক্ষিপত| ");
INSERT INTO sanasm_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","ইত্থং বহৱ আহূতা অল্পে মনোভিমতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","অনন্তৰং ফিৰূশিনঃ প্ৰগত্য যথা সংলাপেন তম্ উন্মাথে পাতযেযুস্তথা মন্ত্ৰযিৎৱা ");
INSERT INTO sanasm_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","হেৰোদীযমনুজৈঃ সাকং নিজশিষ্যগণেন তং প্ৰতি কথযামাসুঃ, হে গুৰো, ভৱান্ সত্যঃ সত্যমীশ্ৱৰীযমাৰ্গমুপদিশতি, কমপি মানুষং নানুৰুধ্যতে, কমপি নাপেক্ষতে চ, তদ্ ৱযং জানীমঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","অতঃ কৈসৰভূপায কৰোঽস্মাকং দাতৱ্যো ন ৱা? অত্ৰ ভৱতা কিং বুধ্যতে? তদ্ অস্মান্ ৱদতু| ");
INSERT INTO sanasm_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","ততো যীশুস্তেষাং খলতাং ৱিজ্ঞায কথিতৱান্, ৰে কপটিনঃ যুযং কুতো মাং পৰিক্ষধ্ৱে? ");
INSERT INTO sanasm_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","তৎকৰদানস্য মুদ্ৰাং মাং দৰ্শযত| তদানীং তৈস্তস্য সমীপং মুদ্ৰাচতুৰ্থভাগ আনীতে ");
INSERT INTO sanasm_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","স তান্ পপ্ৰচ্ছ, অত্ৰ কস্যেযং মূৰ্ত্তি ৰ্নাম চাস্তে? তে জগদুঃ, কৈসৰভূপস্য| ");
INSERT INTO sanasm_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ততঃ স উক্তৱান, কৈসৰস্য যৎ তৎ কৈসৰায দত্ত, ঈশ্ৱৰস্য যৎ তদ্ ঈশ্ৱৰায দত্ত| ");
INSERT INTO sanasm_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ইতি ৱাক্যং নিশম্য তে ৱিস্মযং ৱিজ্ঞায তং ৱিহায চলিতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","তস্মিন্নহনি সিদূকিনোঽৰ্থাৎ শ্মশানাৎ নোত্থাস্যন্তীতি ৱাক্যং যে ৱদন্তি, তে যীশেाৰন্তিকম্ আগত্য পপ্ৰচ্ছুঃ, ");
INSERT INTO sanasm_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","হে গুৰো, কশ্চিন্মনুজশ্চেৎ নিঃসন্তানঃ সন্ প্ৰাণান্ ত্যজতি, তৰ্হি তস্য ভ্ৰাতা তস্য জাযাং ৱ্যুহ্য ভ্ৰাতুঃ সন্তানম্ উৎপাদযিষ্যতীতি মূসা আদিষ্টৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","কিন্ত্ৱস্মাকমত্ৰ কেঽপি জনাঃ সপ্তসহোদৰা আসন্, তেষাং জ্যেষ্ঠ একাং কন্যাং ৱ্যৱহাৎ, অপৰং প্ৰাণত্যাগকালে স্ৱযং নিঃসন্তানঃ সন্ তাং স্ত্ৰিযং স্ৱভ্ৰাতৰি সমৰ্পিতৱান্, ");
INSERT INTO sanasm_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ততো দ্ৱিতীযাদিসপ্তমান্তাশ্চ তথৈৱ চক্ৰুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","শেষে সাপী নাৰী মমাৰ| ");
INSERT INTO sanasm_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","মৃতানাম্ উত্থানসমযে তেষাং সপ্তানাং মধ্যে সা নাৰী কস্য ভাৰ্য্যা ভৱিষ্যতি? যস্মাৎ সৰ্ৱ্ৱএৱ তাং ৱ্যৱহন্| ");
INSERT INTO sanasm_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ততো যীশুঃ প্ৰত্যৱাদীৎ, যূযং ধৰ্ম্মপুস্তকম্ ঈশ্ৱৰীযাং শক্তিঞ্চ ন ৱিজ্ঞায ভ্ৰান্তিমন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","উত্থানপ্ৰাপ্তা লোকা ন ৱিৱহন্তি, ন চ ৱাচা দীযন্তে, কিন্ত্ৱীশ্ৱৰস্য স্ৱৰ্গস্থদূতানাং সদৃশা ভৱন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","অপৰং মৃতানামুত্থানমধি যুষ্মান্ প্ৰতীযমীশ্ৱৰোক্তিঃ, ");
INSERT INTO sanasm_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","\"অহমিব্ৰাহীম ঈশ্ৱৰ ইস্হাক ঈশ্ৱৰো যাকূব ঈশ্ৱৰ\" ইতি কিং যুষ্মাভি ৰ্নাপাঠি? কিন্ত্ৱীশ্ৱৰো জীৱতাম্ ঈশ্ৱৰ:, স মৃতানামীশ্ৱৰো নহি| ");
INSERT INTO sanasm_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ইতি শ্ৰুৎৱা সৰ্ৱ্ৱে লোকাস্তস্যোপদেশাদ্ ৱিস্মযং গতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","অনন্তৰং সিদূকিনাম্ নিৰুত্তৰৎৱৱাৰ্তাং নিশম্য ফিৰূশিন একত্ৰ মিলিতৱন্তঃ, ");
INSERT INTO sanasm_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","তেষামেকো ৱ্যৱস্থাপকো যীশুং পৰীক্ষিতুং পপচ্ছ, ");
INSERT INTO sanasm_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","হে গুৰো ৱ্যৱস্থাশাস্ত্ৰমধ্যে কাজ্ঞা শ্ৰেষ্ঠা? ");
INSERT INTO sanasm_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ততো যীশুৰুৱাচ, ৎৱং সৰ্ৱ্ৱান্তঃকৰণৈঃ সৰ্ৱ্ৱপ্ৰাণৈঃ সৰ্ৱ্ৱচিত্তৈশ্চ সাকং প্ৰভৌ পৰমেশ্ৱৰে প্ৰীযস্ৱ, ");
INSERT INTO sanasm_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","এষা প্ৰথমমহাজ্ঞা| তস্যাঃ সদৃশী দ্ৱিতীযাজ্ঞৈষা, ");
INSERT INTO sanasm_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","তৱ সমীপৱাসিনি স্ৱাত্মনীৱ প্ৰেম কুৰু| ");
INSERT INTO sanasm_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","অনযো ৰ্দ্ৱযোৰাজ্ঞযোঃ কৃৎস্নৱ্যৱস্থাযা ভৱিষ্যদ্ৱক্তৃগ্ৰন্থস্য চ ভাৰস্তিষ্ঠতি| ");
INSERT INTO sanasm_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","অনন্তৰং ফিৰূশিনাম্ একত্ৰ স্থিতিকালে যীশুস্তান্ পপ্ৰচ্ছ, ");
INSERT INTO sanasm_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","খ্ৰীষ্টমধি যুষ্মাকং কীদৃগ্বোধো জাযতে? স কস্য সন্তানঃ? ততস্তে প্ৰত্যৱদন্, দাযূদঃ সন্তানঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","তদা স উক্তৱান্, তৰ্হি দাযূদ্ কথম্ আত্মাধিষ্ঠানেন তং প্ৰভুং ৱদতি ? ");
INSERT INTO sanasm_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","যথা মম প্ৰভুমিদং ৱাক্যমৱদৎ পৰমেশ্ৱৰঃ| তৱাৰীন্ পাদপীঠং তে যাৱন্নহি কৰোম্যহং| তাৱৎ কালং মদীযে ৎৱং দক্ষপাৰ্শ্ৱ উপাৱিশ| অতো যদি দাযূদ্ তং প্ৰভুং ৱদতি, ৰ্তিহ স কথং তস্য সন্তানো ভৱতি? ");
INSERT INTO sanasm_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","তদানীং তেষাং কোপি তদ্ৱাক্যস্য কিমপ্যুত্তৰং দাতুং নাশক্নোৎ; ");
INSERT INTO sanasm_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","তদ্দিনমাৰভ্য তং কিমপি ৱাক্যং প্ৰষ্টুং কস্যাপি সাহসো নাভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","অনন্তৰং যীশু ৰ্জননিৱহং শিষ্যাংশ্চাৱদৎ, ");
INSERT INTO sanasm_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","অধ্যাপকাঃ ফিৰূশিনশ্চ মূসাসনে উপৱিশন্তি, ");
INSERT INTO sanasm_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","অতস্তে যুষ্মান্ যদ্যৎ মন্তুম্ আজ্ঞাপযন্তি, তৎ মন্যধ্ৱং পালযধ্ৱঞ্চ, কিন্তু তেষাং কৰ্ম্মানুৰূপং কৰ্ম্ম ন কুৰুধ্ৱং; যতস্তেষাং ৱাক্যমাত্ৰং সাৰং কাৰ্য্যে কিমপি নাস্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","তে দুৰ্ৱ্ৱহান্ গুৰুতৰান্ ভাৰান্ বদ্ৱ্ৱা মনুষ্যাণাং স্কন্ধেপৰি সমৰ্পযন্তি, কিন্তু স্ৱযমঙ্গুল্যৈকযাপি ন চালযন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","কেৱলং লোকদৰ্শনায সৰ্ৱ্ৱকৰ্ম্মাণি কুৰ্ৱ্ৱন্তি; ফলতঃ পট্টবন্ধান্ প্ৰসাৰ্য্য ধাৰযন্তি, স্ৱৱস্ত্ৰেষু চ দীৰ্ঘগ্ৰন্থীন্ ধাৰযন্তি; ");
INSERT INTO sanasm_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ভোজনভৱন উচ্চস্থানং, ভজনভৱনে প্ৰধানমাসনং, ");
INSERT INTO sanasm_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","হট্ঠে নমস্কাৰং গুৰুৰিতি সম্বোধনঞ্চৈতানি সৰ্ৱ্ৱাণি ৱাঞ্ছন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","কিন্তু যূযং গুৰৱ ইতি সম্বোধনীযা মা ভৱত, যতো যুষ্মাকম্ একঃ খ্ৰীষ্টএৱ গুৰু ");
INSERT INTO sanasm_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ৰ্যূযং সৰ্ৱ্ৱে মিথো ভ্ৰাতৰশ্চ| পুনঃ পৃথিৱ্যাং কমপি পিতেতি মা সম্বুধ্যধ্ৱং, যতো যুষ্মাকমেকঃ স্ৱৰ্গস্থএৱ পিতা| ");
INSERT INTO sanasm_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","যূযং নাযকেতি সম্ভাষিতা মা ভৱত, যতো যুষ্মাকমেকঃ খ্ৰীষ্টএৱ নাযকঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","অপৰং যুষ্মাকং মধ্যে যঃ পুমান্ শ্ৰেষ্ঠঃ স যুষ্মান্ সেৱিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","যতো যঃ স্ৱমুন্নমতি, স নতঃ কৰিষ্যতে; কিন্তু যঃ কশ্চিৎ স্ৱমৱনতং কৰোতি, স উন্নতঃ কৰিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","হন্ত কপটিন উপাধ্যাযাঃ ফিৰূশিনশ্চ, যূযং মনুজানাং সমক্ষং স্ৱৰ্গদ্ৱাৰং ৰুন্ধ, যূযং স্ৱযং তেন ন প্ৰৱিশথ, প্ৰৱিৱিক্ষূনপি ৱাৰযথ| ৱত কপটিন উপাধ্যাযাঃ ফিৰূশিনশ্চ যূযং ছলাদ্ দীৰ্ঘং প্ৰাৰ্থ্য ৱিধৱানাং সৰ্ৱ্ৱস্ৱং গ্ৰসথ, যুষ্মাকং ঘোৰতৰদণ্ডো ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","হন্ত কপটিন উপাধ্যাযাঃ ফিৰূশিনশ্চ, যূযমেকং স্ৱধৰ্ম্মাৱলম্বিনং কৰ্ত্তুং সাগৰং ভূমণ্ডলঞ্চ প্ৰদক্ষিণীকুৰুথ, ");
INSERT INTO sanasm_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","কঞ্চন প্ৰাপ্য স্ৱতো দ্ৱিগুণনৰকভাজনং তং কুৰুথ| ");
INSERT INTO sanasm_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","ৱত অন্ধপথদৰ্শকাঃ সৰ্ৱ্ৱে, যূযং ৱদথ, মন্দিৰস্য শপথকৰণাৎ কিমপি ন দেযং; কিন্তু মন্দিৰস্থসুৱৰ্ণস্য শপথকৰণাদ্ দেযং| ");
INSERT INTO sanasm_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","হে মূঢা হে অন্ধাঃ সুৱৰ্ণং তৎসুৱৰ্ণপাৱকমন্দিৰম্ এতযোৰুভযো ৰ্মধ্যে কিং শ্ৰেযঃ? ");
INSERT INTO sanasm_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","অন্যচ্চ ৱদথ, যজ্ঞৱেদ্যাঃ শপথকৰণাৎ কিমপি ন দেযং, কিন্তু তদুপৰিস্থিতস্য নৈৱেদ্যস্য শপথকৰণাদ্ দেযং| ");
INSERT INTO sanasm_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","হে মূঢা হে অন্ধাঃ, নৈৱেদ্যং তন্নৈৱেদ্যপাৱকৱেদিৰেতযোৰুভযো ৰ্মধ্যে কিং শ্ৰেযঃ? ");
INSERT INTO sanasm_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","অতঃ কেনচিদ্ যজ্ঞৱেদ্যাঃ শপথে কৃতে তদুপৰিস্থস্য সৰ্ৱ্ৱস্য শপথঃ ক্ৰিযতে| ");
INSERT INTO sanasm_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","কেনচিৎ মন্দিৰস্য শপথে কৃতে মন্দিৰতন্নিৱাসিনোঃ শপথঃ ক্ৰিযতে| ");
INSERT INTO sanasm_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","কেনচিৎ স্ৱৰ্গস্য শপথে কৃতে ঈশ্ৱৰীযসিংহাসনতদুপৰ্য্যুপৱিষ্টযোঃ শপথঃ ক্ৰিযতে| ");
INSERT INTO sanasm_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","হন্ত কপটিন উপাধ্যাযাঃ ফিৰূশিনশ্চ, যূযং পোদিনাযাঃ সিতচ্ছত্ৰাযা জীৰকস্য চ দশমাংশান্ দত্থ, কিন্তু ৱ্যৱস্থাযা গুৰুতৰান্ ন্যাযদযাৱিশ্ৱাসান্ পৰিত্যজথ; ইমে যুষ্মাভিৰাচৰণীযা অমী চ ন লংঘনীযাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","হে অন্ধপথদৰ্শকা যূযং মশকান্ অপসাৰযথ, কিন্তু মহাঙ্গান্ গ্ৰসথ| ");
INSERT INTO sanasm_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","হন্ত কপটিন উপাধ্যাযাঃ ফিৰূশিনশ্চ, যূযং পানপাত্ৰাণাং ভোজনপাত্ৰাণাঞ্চ বহিঃ পৰিষ্কুৰুথ; কিন্তু তদভ্যন্তৰং দুৰাত্মতযা কলুষেণ চ পৰিপূৰ্ণমাস্তে| ");
INSERT INTO sanasm_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","হে অন্ধাঃ ফিৰূশিলোকা আদৌ পানপাত্ৰাণাং ভোজনপাত্ৰাণাঞ্চাভ্যন্তৰং পৰিষ্কুৰুত, তেন তেষাং বহিৰপি পৰিষ্কাৰিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","হন্ত কপটিন উপাধ্যাযাঃ ফিৰূশিনশ্চ, যূযং শুক্লীকৃতশ্মশানস্ৱৰূপা ভৱথ, যথা শ্মশানভৱনস্য বহিশ্চাৰু, কিন্ত্ৱভ্যন্তৰং মৃতলোকানাং কীকশৈঃ সৰ্ৱ্ৱপ্ৰকাৰমলেন চ পৰিপূৰ্ণম্; ");
INSERT INTO sanasm_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","তথৈৱ যূযমপি লোকানাং সমক্ষং বহিৰ্ধাৰ্ম্মিকাঃ কিন্ত্ৱন্তঃকৰণেষু কেৱলকাপট্যাধৰ্ম্মাভ্যাং পৰিপূৰ্ণাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","হা হা কপটিন উপাধ্যাযাঃ ফিৰূশিনশ্চ, যূযং ভৱিষ্যদ্ৱাদিনাং শ্মশানগেহং নিৰ্ম্মাথ, সাধূনাং শ্মশাননিকেতনং শোভযথ ");
INSERT INTO sanasm_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ৱদথ চ যদি ৱযং স্ৱেষাং পূৰ্ৱ্ৱপুৰুষাণাং কাল অস্থাস্যাম, তৰ্হি ভৱিষ্যদ্ৱাদিনাং শোণিতপাতনে তেষাং সহভাগিনো নাভৱিষ্যাম| ");
INSERT INTO sanasm_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","অতো যূযং ভৱিষ্যদ্ৱাদিঘাতকানাং সন্তানা ইতি স্ৱযমেৱ স্ৱেষাং সাক্ষ্যং দত্থ| ");
INSERT INTO sanasm_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","অতো যূযং নিজপূৰ্ৱ্ৱপুৰুষাণাং পৰিমাণপাত্ৰং পৰিপূৰযত| ");
INSERT INTO sanasm_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","ৰে ভুজগাঃ কৃষ্ণভুজগৱংশাঃ, যূযং কথং নৰকদণ্ডাদ্ ৰক্ষিষ্যধ্ৱে| ");
INSERT INTO sanasm_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","পশ্যত, যুষ্মাকমন্তিকম্ অহং ভৱিষ্যদ্ৱাদিনো বুদ্ধিমত উপাধ্যাযাংশ্চ প্ৰেষযিষ্যামি, কিন্তু তেষাং কতিপযা যুষ্মাভি ৰ্ঘানিষ্যন্তে, ক্ৰুশে চ ঘানিষ্যন্তে, কেচিদ্ ভজনভৱনে কষাভিৰাঘানিষ্যন্তে, নগৰে নগৰে তাডিষ্যন্তে চ; ");
INSERT INTO sanasm_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","তেন সৎপুৰুষস্য হাবিলো ৰক্তপাতমাৰভ্য বেৰিখিযঃ পুত্ৰং যং সিখৰিযং যূযং মন্দিৰযজ্ঞৱেদ্যো ৰ্মধ্যে হতৱন্তঃ, তদীযশোণিতপাতং যাৱদ্ অস্মিন্ দেশে যাৱতাং সাধুপুৰুষাণাং শোণিতপাতো ঽভৱৎ তৎ সৰ্ৱ্ৱেষামাগসাং দণ্ডা যুষ্মাসু ৱৰ্ত্তিষ্যন্তে| ");
INSERT INTO sanasm_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","অহং যুষ্মান্ত তথ্যং ৱদামি, ৱিদ্যমানেঽস্মিন্ পুৰুষে সৰ্ৱ্ৱে ৱৰ্ত্তিষ্যন্তে| ");
INSERT INTO sanasm_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","হে যিৰূশালম্ হে যিৰূশালম্ নগৰি ৎৱং ভৱিষ্যদ্ৱাদিনো হতৱতী, তৱ সমীপং প্ৰেৰিতাংশ্চ পাষাণৈৰাহতৱতী, যথা কুক্কুটী শাৱকান্ পক্ষাধঃ সংগৃহ্লাতি, তথা তৱ সন্তানান্ সংগ্ৰহীতুং অহং বহুৱাৰম্ ঐচ্ছং; কিন্তু ৎৱং ন সমমন্যথাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","পশ্যত যষ্মাকং ৱাসস্থানম্ উচ্ছিন্নং ত্যক্ষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","অহং যুষ্মান্ তথ্যং ৱদামি, যঃ পৰমেশ্ৱৰস্য নাম্নাগচ্ছতি, স ধন্য ইতি ৱাণীং যাৱন্ন ৱদিষ্যথ, তাৱৎ মাং পুন ৰ্ন দ্ৰক্ষ্যথ| ");
INSERT INTO sanasm_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","অনন্তৰং যীশু ৰ্যদা মন্দিৰাদ্ বহি ৰ্গচ্ছতি, তদানীং শিষ্যাস্তং মন্দিৰনিৰ্ম্মাণং দৰ্শযিতুমাগতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ততো যীশুস্তানুৱাচ, যূযং কিমেতানি ন পশ্যথ? যুষ্মানহং সত্যং ৱদামি, এতন্নিচযনস্য পাষাণৈকমপ্যন্যপাষাণেाপৰি ন স্থাস্যতি সৰ্ৱ্ৱাণি ভূমিসাৎ কাৰিষ্যন্তে| ");
INSERT INTO sanasm_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","অনন্তৰং তস্মিন্ জৈতুনপৰ্ৱ্ৱতোপৰি সমুপৱিষ্টে শিষ্যাস্তস্য সমীপমাগত্য গুপ্তং পপ্ৰচ্ছুঃ, এতা ঘটনাঃ কদা ভৱিষ্যন্তি? ভৱত আগমনস্য যুগান্তস্য চ কিং লক্ষ্ম? তদস্মান্ ৱদতু| ");
INSERT INTO sanasm_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","তদানীং যীশুস্তানৱোচৎ, অৱধদ্ৱ্ৱং, কোপি যুষ্মান্ ন ভ্ৰমযেৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","বহৱো মম নাম গৃহ্লন্ত আগমিষ্যন্তি, খ্ৰীষ্টোঽহমেৱেতি ৱাচং ৱদন্তো বহূন্ ভ্ৰমযিষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","যূযঞ্চ সংগ্ৰামস্য ৰণস্য চাডম্বৰং শ্ৰোষ্যথ, অৱধদ্ৱ্ৱং তেন চঞ্চলা মা ভৱত, এতান্যৱশ্যং ঘটিষ্যন্তে, কিন্তু তদা যুগান্তো নহি| ");
INSERT INTO sanasm_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","অপৰং দেশস্য ৱিপক্ষো দেশো ৰাজ্যস্য ৱিপক্ষো ৰাজ্যং ভৱিষ্যতি, স্থানে স্থানে চ দুৰ্ভিক্ষং মহামাৰী ভূকম্পশ্চ ভৱিষ্যন্তি, ");
INSERT INTO sanasm_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","এতানি দুঃখোপক্ৰমাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","তদানীং লোকা দুঃখং ভোজযিতুং যুষ্মান্ পৰকৰেষু সমৰ্পযিষ্যন্তি হনিষ্যন্তি চ, তথা মম নামকাৰণাদ্ যূযং সৰ্ৱ্ৱদেশীযমনুজানাং সমীপে ঘৃণাৰ্হা ভৱিষ্যথ| ");
INSERT INTO sanasm_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","বহুষু ৱিঘ্নং প্ৰাপ্তৱৎসু পৰস্পৰম্ ঋृতীযাং কৃতৱৎসু চ একোঽপৰং পৰকৰেষু সমৰ্পযিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","তথা বহৱো মৃষাভৱিষ্যদ্ৱাদিন উপস্থায বহূন্ ভ্ৰমযিষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","দুষ্কৰ্ম্মণাং বাহুল্যাঞ্চ বহূনাং প্ৰেম শীতলং ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","কিন্তু যঃ কশ্চিৎ শেষং যাৱদ্ ধৈৰ্য্যমাশ্ৰযতে, সএৱ পৰিত্ৰাযিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","অপৰং সৰ্ৱ্ৱদেশীযলোকান্ প্ৰতিমাক্ষী ভৱিতুং ৰাজস্য শুভসমাচাৰঃ সৰ্ৱ্ৱজগতি প্ৰচাৰিষ্যতে, এতাদৃশি সতি যুগান্ত উপস্থাস্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","অতো যৎ সৰ্ৱ্ৱনাশকৃদ্ঘৃণাৰ্হং ৱস্তু দানিযেল্ভৱিষ্যদ্ৱদিনা প্ৰোক্তং তদ্ যদা পুণ্যস্থানে স্থাপিতং দ্ৰক্ষ্যথ, (যঃ পঠতি, স বুধ্যতাং) ");
INSERT INTO sanasm_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","তদানীং যে যিহূদীযদেশে তিষ্ঠন্তি, তে পৰ্ৱ্ৱতেষু পলাযন্তাং| ");
INSERT INTO sanasm_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","যঃ কশ্চিদ্ গৃহপৃষ্ঠে তিষ্ঠতি, স গৃহাৎ কিমপি ৱস্ত্ৱানেতুম্ অধেा নাৱৰোহেৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","যশ্চ ক্ষেত্ৰে তিষ্ঠতি, সোপি ৱস্ত্ৰমানেতুং পৰাৱৃত্য ন যাযাৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","তদানীং গৰ্ভিণীস্তন্যপাযযিত্ৰীণাং দুৰ্গতি ৰ্ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","অতো যষ্মাকং পলাযনং শীতকালে ৱিশ্ৰামৱাৰে ৱা যন্ন ভৱেৎ, তদৰ্থং প্ৰাৰ্থযধ্ৱম্| ");
INSERT INTO sanasm_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","আ জগদাৰম্ভাদ্ এতৎকালপৰ্য্যনন্তং যাদৃশঃ কদাপি নাভৱৎ ন চ ভৱিষ্যতি তাদৃশো মহাক্লেশস্তদানীম্ উপস্থাস্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","তস্য ক্লেশস্য সমযো যদি হ্স্ৱো ন ক্ৰিযেত, তৰ্হি কস্যাপি প্ৰাণিনো ৰক্ষণং ভৱিতুং ন শক্নুযাৎ, কিন্তু মনোনীতমনুজানাং কৃতে স কালো হ্স্ৱীকৰিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","অপৰঞ্চ পশ্যত, খ্ৰীষ্টোঽত্ৰ ৱিদ্যতে, ৱা তত্ৰ ৱিদ্যতে, তদানীং যদী কশ্চিদ্ যুষ্মান ইতি ৱাক্যং ৱদতি, তথাপি তৎ ন প্ৰতীৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","যতো ভাক্তখ্ৰীষ্টা ভাক্তভৱিষ্যদ্ৱাদিনশ্চ উপস্থায যানি মহন্তি লক্ষ্মাণি চিত্ৰকৰ্ম্মাণি চ প্ৰকাশযিষ্যন্তি, তৈ ৰ্যদি সম্ভৱেৎ তৰ্হি মনোনীতমানৱা অপি ভ্ৰামিষ্যন্তে| ");
INSERT INTO sanasm_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","পশ্যত, ঘটনাতঃ পূৰ্ৱ্ৱং যুষ্মান্ ৱাৰ্ত্তাম্ অৱাদিষম্| ");
INSERT INTO sanasm_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","অতঃ পশ্যত, স প্ৰান্তৰে ৱিদ্যত ইতি ৱাক্যে কেনচিৎ কথিতেপি বহি ৰ্মা গচ্ছত, ৱা পশ্যত, সোন্তঃপুৰে ৱিদ্যতে, এতদ্ৱাক্য উক্তেপি মা প্ৰতীত| ");
INSERT INTO sanasm_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","যতো যথা ৱিদ্যুৎ পূৰ্ৱ্ৱদিশো নিৰ্গত্য পশ্চিমদিশং যাৱৎ প্ৰকাশতে, তথা মানুষপুত্ৰস্যাপ্যাগমনং ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","যত্ৰ শৱস্তিষ্ঠতি, তত্ৰেৱ গৃধ্ৰা মিলন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","অপৰং তস্য ক্লেশসমযস্যাৱ্যৱহিতপৰত্ৰ সূৰ্য্যস্য তেজো লোপ্স্যতে, চন্দ্ৰমা জ্যোস্নাং ন কৰিষ্যতি, নভসো নক্ষত্ৰাণি পতিষ্যন্তি, গগণীযা গ্ৰহাশ্চ ৱিচলিষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","তদানীম্ আকাশমধ্যে মনুজসুতস্য লক্ষ্ম দৰ্শিষ্যতে, ততো নিজপৰাক্ৰমেণ মহাতেজসা চ মেঘাৰূঢং মনুজসুতং নভসাগচ্ছন্তং ৱিলোক্য পৃথিৱ্যাঃ সৰ্ৱ্ৱৱংশীযা ৱিলপিষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","তদানীং স মহাশব্দাযমানতূৰ্য্যা ৱাদকান্ নিজদূতান্ প্ৰহেষ্যতি, তে ৱ্যোম্ন একসীমাতোঽপৰসীমাং যাৱৎ চতুৰ্দিশস্তস্য মনোনীতজনান্ আনীয মেলযিষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","উডুম্বৰপাদপস্য দৃষ্টান্তং শিক্ষধ্ৱং; যদা তস্য নৱীনাঃ শাখা জাযন্তে, পল্লৱাদিশ্চ নিৰ্গচ্ছতি, তদা নিদাঘকালঃ সৱিধো ভৱতীতি যূযং জানীথ; ");
INSERT INTO sanasm_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","তদ্ৱদ্ এতা ঘটনা দৃষ্ট্ৱা স সমযো দ্ৱাৰ উপাস্থাদ্ ইতি জানীত| ");
INSERT INTO sanasm_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","যুষ্মানহং তথ্যং ৱদামি, ইদানীন্তনজনানাং গমনাৎ পূৰ্ৱ্ৱমেৱ তানি সৰ্ৱ্ৱাণি ঘটিষ্যন্তে| ");
INSERT INTO sanasm_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","নভোমেদিন্যো ৰ্লুপ্তযোৰপি মম ৱাক্ কদাপি ন লোপ্স্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","অপৰং মম তাতং ৱিনা মানুষঃ স্ৱৰ্গস্থো দূতো ৱা কোপি তদ্দিনং তদ্দণ্ডঞ্চ ন জ্ঞাপযতি| ");
INSERT INTO sanasm_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","অপৰং নোহে ৱিদ্যমানে যাদৃশমভৱৎ তাদৃশং মনুজসুতস্যাগমনকালেপি ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","ফলতো জলাপ্লাৱনাৎ পূৰ্ৱ্ৱং যদ্দিনং যাৱৎ নোহঃ পোতং নাৰোহৎ, তাৱৎকালং যথা মনুষ্যা ভোজনে পানে ৱিৱহনে ৱিৱাহনে চ প্ৰৱৃত্তা আসন্; ");
INSERT INTO sanasm_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","অপৰম্ আপ্লাৱিতোযমাগত্য যাৱৎ সকলমনুজান্ প্লাৱযিৎৱা নানযৎ, তাৱৎ তে যথা ন ৱিদামাসুঃ, তথা মনুজসুতাগমনেপি ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","তদা ক্ষেত্ৰস্থিতযোৰ্দ্ৱযোৰেকো ধাৰিষ্যতে, অপৰস্ত্যাজিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","তথা পেষণ্যা পিংষত্যোৰুভযো ৰ্যোষিতোৰেকা ধাৰিষ্যতেঽপৰা ত্যাজিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","যুষ্মাকং প্ৰভুঃ কস্মিন্ দণ্ড আগমিষ্যতি, তদ্ যুষ্মাভি ৰ্নাৱগম্যতে, তস্মাৎ জাগ্ৰতঃ সন্তস্তিষ্ঠত| ");
INSERT INTO sanasm_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","কুত্ৰ যামে স্তেন আগমিষ্যতীতি চেদ্ গৃহস্থো জ্ঞাতুম্ অশক্ষ্যৎ, তৰ্হি জাগৰিৎৱা তং সন্ধিং কৰ্ত্তিতুম্ অৱাৰযিষ্যৎ তদ্ জানীত| ");
INSERT INTO sanasm_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","যুষ্মাভিৰৱধীযতাং, যতো যুষ্মাভি ৰ্যত্ৰ ন বুধ্যতে, তত্ৰৈৱ দণ্ডে মনুজসুত আযাস্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","প্ৰভু ৰ্নিজপৰিৱাৰান্ যথাকালং ভোজযিতুং যং দাসম্ অধ্যক্ষীকৃত্য স্থাপযতি, তাদৃশো ৱিশ্ৱাস্যো ধীমান্ দাসঃ কঃ? ");
INSERT INTO sanasm_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","প্ৰভুৰাগত্য যং দাসং তথাচৰন্তং ৱীক্ষতে, সএৱ ধন্যঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","যুষ্মানহং সত্যং ৱদামি, স তং নিজসৰ্ৱ্ৱস্ৱস্যাধিপং কৰিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","কিন্তু প্ৰভুৰাগন্তুং ৱিলম্বত ইতি মনসি চিন্তযিৎৱা যো দুষ্টো দাসো ");
INSERT INTO sanasm_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ঽপৰদাসান্ প্ৰহৰ্ত্তুং মত্তানাং সঙ্গে ভোক্তুং পাতুঞ্চ প্ৰৱৰ্ত্ততে, ");
INSERT INTO sanasm_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","স দাসো যদা নাপেক্ষতে, যঞ্চ দণ্ডং ন জানাতি, তৎকালএৱ তৎপ্ৰভুৰুপস্থাস্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","তদা তং দণ্ডযিৎৱা যত্ৰ স্থানে ৰোদনং দন্তঘৰ্ষণঞ্চাসাতে, তত্ৰ কপটিভিঃ সাকং তদ্দশাং নিৰূপযিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","যা দশ কন্যাঃ প্ৰদীপান্ গৃহ্লত্যো ৱৰং সাক্ষাৎ কৰ্ত্তুং বহিৰিতাঃ, তাভিস্তদা স্ৱৰ্গীযৰাজ্যস্য সাদৃশ্যং ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","তাসাং কন্যানাং মধ্যে পঞ্চ সুধিযঃ পঞ্চ দুৰ্ধিয আসন্| ");
INSERT INTO sanasm_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","যা দুৰ্ধিযস্তাঃ প্ৰদীপান্ সঙ্গে গৃহীৎৱা তৈলং ন জগৃহুঃ, ");
INSERT INTO sanasm_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","কিন্তু সুধিযঃ প্ৰদীপান্ পাত্ৰেণ তৈলঞ্চ জগৃহুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","অনন্তৰং ৱৰে ৱিলম্বিতে তাঃ সৰ্ৱ্ৱা নিদ্ৰাৱিষ্টা নিদ্ৰাং জগ্মুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","অনন্তৰম্ অৰ্দ্ধৰাত্ৰে পশ্যত ৱৰ আগচ্ছতি, তং সাক্ষাৎ কৰ্ত্তুং বহিৰ্যাতেতি জনৰৱাৎ ");
INSERT INTO sanasm_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","তাঃ সৰ্ৱ্ৱাঃ কন্যা উত্থায প্ৰদীপান্ আসাদযিতুং আৰভন্ত| ");
INSERT INTO sanasm_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ততো দুৰ্ধিযঃ সুধিয ঊচুঃ, কিঞ্চিৎ তৈলং দত্ত, প্ৰদীপা অস্মাকং নিৰ্ৱ্ৱাণাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","কিন্তু সুধিযঃ প্ৰত্যৱদন্, দত্তে যুষ্মানস্মাংশ্চ প্ৰতি তৈলং ন্যূনীভৱেৎ, তস্মাদ্ ৱিক্ৰেতৃণাং সমীপং গৎৱা স্ৱাৰ্থং তৈলং ক্ৰীণীত| ");
INSERT INTO sanasm_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","তদা তাসু ক্ৰেতুং গতাসু ৱৰ আজগাম, ততো যাঃ সজ্জিতা আসন্, তাস্তেন সাকং ৱিৱাহীযং ৱেশ্ম প্ৰৱিৱিশুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","অনন্তৰং দ্ৱাৰে ৰুদ্ধে অপৰাঃ কন্যা আগত্য জগদুঃ, হে প্ৰভো, হে প্ৰভো, অস্মান্ প্ৰতি দ্ৱাৰং মোচয| ");
INSERT INTO sanasm_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","কিন্তু স উক্তৱান্, তথ্যং ৱদামি, যুষ্মানহং ন ৱেদ্মি| ");
INSERT INTO sanasm_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","অতো জাগ্ৰতঃ সন্তস্তিষ্ঠত, মনুজসুতঃ কস্মিন্ দিনে কস্মিন্ দণ্ডে ৱাগমিষ্যতি, তদ্ যুষ্মাভি ৰ্ন জ্ঞাযতে| ");
INSERT INTO sanasm_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","অপৰং স এতাদৃশঃ কস্যচিৎ পুংসস্তুল্যঃ, যো দূৰদেশং প্ৰতি যাত্ৰাকালে নিজদাসান্ আহূয তেষাং স্ৱস্ৱসামৰ্থ্যানুৰূপম্ ");
INSERT INTO sanasm_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","একস্মিন্ মুদ্ৰাণাং পঞ্চ পোটলিকাঃ অন্যস্মিংশ্চ দ্ৱে পোটলিকে অপৰস্মিংশ্চ পোটলিকৈকাম্ ইত্থং প্ৰতিজনং সমৰ্প্য স্ৱযং প্ৰৱাসং গতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","অনন্তৰং যো দাসঃ পঞ্চ পোটলিকাঃ লব্ধৱান্, স গৎৱা ৱাণিজ্যং ৱিধায তা দ্ৱিগুণীচকাৰ| ");
INSERT INTO sanasm_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","যশ্চ দাসো দ্ৱে পোটলিকে অলভত, সোপি তা মুদ্ৰা দ্ৱিগুণীচকাৰ| ");
INSERT INTO sanasm_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","কিন্তু যো দাস একাং পোটলিকাং লব্ধৱান্, স গৎৱা ভূমিং খনিৎৱা তন্মধ্যে নিজপ্ৰভোস্তা মুদ্ৰা গোপযাঞ্চকাৰ| ");
INSERT INTO sanasm_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","তদনন্তৰং বহুতিথে কালে গতে তেষাং দাসানাং প্ৰভুৰাগত্য তৈৰ্দাসৈঃ সমং গণযাঞ্চকাৰ| ");
INSERT INTO sanasm_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","তদানীং যঃ পঞ্চ পোটলিকাঃ প্ৰাপ্তৱান্ স তা দ্ৱিগুণীকৃতমুদ্ৰা আনীয জগাদ; হে প্ৰভো, ভৱতা মযি পঞ্চ পোটলিকাঃ সমৰ্পিতাঃ, পশ্যতু, তা মযা দ্ৱিগুণীকৃতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","তদানীং তস্য প্ৰভুস্তমুৱাচ, হে উত্তম ৱিশ্ৱাস্য দাস, ৎৱং ধন্যোসি, স্তোকেন ৱিশ্ৱাস্যো জাতঃ, তস্মাৎ ৎৱাং বহুৱিত্তাধিপং কৰোমি, ৎৱং স্ৱপ্ৰভোঃ সুখস্য ভাগী ভৱ| ");
INSERT INTO sanasm_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","ততো যেন দ্ৱে পোটলিকে লব্ধে সোপ্যাগত্য জগাদ, হে প্ৰভো, ভৱতা মযি দ্ৱে পোটলিকে সমৰ্পিতে, পশ্যতু তে মযা দ্ৱিগুণীকৃতে| ");
INSERT INTO sanasm_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","তেন তস্য প্ৰভুস্তমৱোচৎ, হে উত্তম ৱিশ্ৱাস্য দাস, ৎৱং ধন্যোসি, স্তোকেন ৱিশ্ৱাস্যো জাতঃ, তস্মাৎ ৎৱাং বহুদ্ৰৱিণাধিপং কৰোমি, ৎৱং নিজপ্ৰভোঃ সুখস্য ভাগী ভৱ| ");
INSERT INTO sanasm_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","অনন্তৰং য একাং পোটলিকাং লব্ধৱান্, স এত্য কথিতৱান্, হে প্ৰভো, ৎৱাং কঠিননৰং জ্ঞাতৱান্, ৎৱযা যত্ৰ নোপ্তং, তত্ৰৈৱ কৃত্যতে, যত্ৰ চ ন কীৰ্ণং, তত্ৰৈৱ সংগৃহ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","অতোহং সশঙ্কঃ সন্ গৎৱা তৱ মুদ্ৰা ভূমধ্যে সংগোপ্য স্থাপিতৱান্, পশ্য, তৱ যৎ তদেৱ গৃহাণ| ");
INSERT INTO sanasm_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","তদা তস্য প্ৰভুঃ প্ৰত্যৱদৎ ৰে দুষ্টালস দাস, যত্ৰাহং ন ৱপামি, তত্ৰ ছিনদ্মি, যত্ৰ চ ন কিৰামি, তত্ৰেৱ সংগৃহ্লামীতি চেদজানাস্তৰ্হি ");
INSERT INTO sanasm_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ৱণিক্ষু মম ৱিত্তাৰ্পণং তৱোচিতমাসীৎ, যেনাহমাগত্য ৱৃদ্ৱ্যা সাকং মূলমুদ্ৰাঃ প্ৰাপ্স্যম্| ");
INSERT INTO sanasm_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","অতোস্মাৎ তাং পোটলিকাম্ আদায যস্য দশ পোটলিকাঃ সন্তি তস্মিন্নৰ্পযত| ");
INSERT INTO sanasm_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","যেন ৱৰ্দ্ৱ্যতে তস্মিন্নৈৱাৰ্পিষ্যতে, তস্যৈৱ চ বাহুল্যং ভৱিষ্যতি, কিন্তু যেন ন ৱৰ্দ্ৱ্যতে, তস্যান্তিকে যৎ কিঞ্চন তিষ্ঠতি, তদপি পুনৰ্নেষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","অপৰং যূযং তমকৰ্ম্মণ্যং দাসং নীৎৱা যত্ৰ স্থানে ক্ৰন্দনং দন্তঘৰ্ষণঞ্চ ৱিদ্যেতে, তস্মিন্ বহিৰ্ভূততমসি নিক্ষিপত| ");
INSERT INTO sanasm_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","যদা মনুজসুতঃ পৱিত্ৰদূতান্ সঙ্গিনঃ কৃৎৱা নিজপ্ৰভাৱেনাগত্য নিজতেজোমযে সিংহাসনে নিৱেক্ষ্যতি, ");
INSERT INTO sanasm_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","তদা তৎসম্মুখে সৰ্ৱ্ৱজাতীযা জনা সংমেলিষ্যন্তি| ততো মেষপালকো যথা ছাগেভ্যোঽৱীন্ পৃথক্ কৰোতি তথা সোপ্যেকস্মাদন্যম্ ইত্থং তান্ পৃথক কৃৎৱাৱীন্ ");
INSERT INTO sanasm_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","দক্ষিণে ছাগাংশ্চ ৱামে স্থাপযিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","ততঃ পৰং ৰাজা দক্ষিণস্থিতান্ মানৱান্ ৱদিষ্যতি, আগচ্ছত মত্তাতস্যানুগ্ৰহভাজনানি, যুষ্মৎকৃত আ জগদাৰম্ভৎ যদ্ ৰাজ্যম্ আসাদিতং তদধিকুৰুত| ");
INSERT INTO sanasm_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","যতো বুভুক্ষিতায মহ্যং ভোজ্যম্ অদত্ত, পিপাসিতায পেযমদত্ত, ৱিদেশিনং মাং স্ৱস্থানমনযত, ");
INSERT INTO sanasm_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ৱস্ত্ৰহীনং মাং ৱসনং পৰ্য্যধাপযত, পীডীতং মাং দ্ৰষ্টুমাগচ্ছত, কাৰাস্থঞ্চ মাং ৱীক্ষিতুম আগচ্ছত| ");
INSERT INTO sanasm_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","তদা ধাৰ্ম্মিকাঃ প্ৰতিৱদিষ্যন্তি, হে প্ৰভো, কদা ৎৱাং ক্ষুধিতং ৱীক্ষ্য ৱযমভোজযাম? ৱা পিপাসিতং ৱীক্ষ্য অপাযযাম? ");
INSERT INTO sanasm_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","কদা ৱা ৎৱাং ৱিদেশিনং ৱিলোক্য স্ৱস্থানমনযাম? কদা ৱা ৎৱাং নগ্নং ৱীক্ষ্য ৱসনং পৰ্য্যধাপযাম? ");
INSERT INTO sanasm_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","কদা ৱা ৎৱাং পীডিতং কাৰাস্থঞ্চ ৱীক্ষ্য ৎৱদন্তিকমগচ্ছাম? ");
INSERT INTO sanasm_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","তদানীং ৰাজা তান্ প্ৰতিৱদিষ্যতি, যুষ্মানহং সত্যং ৱদামি, মমৈতেষাং ভ্ৰাতৃণাং মধ্যে কঞ্চনৈকং ক্ষুদ্ৰতমং প্ৰতি যদ্ অকুৰুত, তন্মাং প্ৰত্যকুৰুত| ");
INSERT INTO sanasm_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","পশ্চাৎ স ৱামস্থিতান্ জনান্ ৱদিষ্যতি, ৰে শাপগ্ৰস্তাঃ সৰ্ৱ্ৱে, শৈতানে তস্য দূতেভ্যশ্চ যোঽনন্তৱহ্নিৰাসাদিত আস্তে, যূযং মদন্তিকাৎ তমগ্নিং গচ্ছত| ");
INSERT INTO sanasm_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","যতো ক্ষুধিতায মহ্যমাহাৰং নাদত্ত, পিপাসিতায মহ্যং পেযং নাদত্ত, ");
INSERT INTO sanasm_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ৱিদেশিনং মাং স্ৱস্থানং নানযত, ৱসনহীনং মাং ৱসনং ন পৰ্য্যধাপযত, পীডিতং কাৰাস্থঞ্চ মাং ৱীক্ষিতুং নাগচ্ছত| ");
INSERT INTO sanasm_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","তদা তে প্ৰতিৱদিষ্যন্তি, হে প্ৰভো, কদা ৎৱাং ক্ষুধিতং ৱা পিপাসিতং ৱা ৱিদেশিনং ৱা নগ্নং ৱা পীডিতং ৱা কাৰাস্থং ৱীক্ষ্য ৎৱাং নাসেৱামহি? ");
INSERT INTO sanasm_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","তদা স তান্ ৱদিষ্যতি, তথ্যমহং যুষ্মান্ ব্ৰৱীমি, যুষ্মাভিৰেষাং কঞ্চন ক্ষোদিষ্ঠং প্ৰতি যন্নাকাৰি, তন্মাং প্ৰত্যেৱ নাকাৰি| ");
INSERT INTO sanasm_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","পশ্চাদম্যনন্তশাস্তিং কিন্তু ধাৰ্ম্মিকা অনন্তাযুষং ভোক্তুং যাস্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","যীশুৰেতান্ প্ৰস্তাৱান্ সমাপ্য শিষ্যানূচে, ");
INSERT INTO sanasm_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","যুষ্মাভি ৰ্জ্ঞাতং দিনদ্ৱযাৎ পৰং নিস্তাৰমহ উপস্থাস্যতি, তত্ৰ মনুজসুতঃ ক্ৰুশেন হন্তুং পৰকৰেষু সমৰ্পিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","ততঃ পৰং প্ৰধানযাজকাধ্যাপকপ্ৰাঞ্চঃ কিযফানাম্নো মহাযাজকস্যাট্টালিকাযাং মিলিৎৱা ");
INSERT INTO sanasm_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","কেনোপাযেন যীশুং ধৃৎৱা হন্তুং শক্নুযুৰিতি মন্ত্ৰযাঞ্চক্ৰুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","কিন্তু তৈৰুক্তং মহকালে ন ধৰ্ত্তৱ্যঃ, ধৃতে প্ৰজানাং কলহেন ভৱিতুং শক্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","ততো বৈথনিযাপুৰে শিমোনাখ্যস্য কুষ্ঠিনো ৱেশ্মনি যীশৌ তিষ্ঠতি ");
INSERT INTO sanasm_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","কাচন যোষা শ্ৱেতোপলভাজনেন মহাৰ্ঘ্যং সুগন্ধি তৈলমানীয ভোজনাযোপৱিশতস্তস্য শিৰোভ্যষেচৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","কিন্তু তদালোক্য তচ্ছিষ্যৈঃ কুপিতৈৰুক্তং, কুত ইত্থমপৱ্যযতে? ");
INSERT INTO sanasm_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","চেদিদং ৱ্যক্ৰেষ্যত, তৰ্হি ভূৰিমূল্যং প্ৰাপ্য দৰিদ্ৰেভ্যো ৱ্যতাৰিষ্যত| ");
INSERT INTO sanasm_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","যীশুনা তদৱগত্য তে সমুদিতাঃ, যোষামেনাং কুতো দুঃখিনীং কুৰুথ, সা মাং প্ৰতি সাধু কৰ্ম্মাকাৰ্ষীৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","যুষ্মাকমং সমীপে দৰিদ্ৰাঃ সততমেৱাসতে, কিন্তু যুষ্মাকমন্তিকেহং নাসে সততং| ");
INSERT INTO sanasm_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","সা মম কাযোপৰি সুগন্ধিতৈলং সিক্ত্ৱা মম শ্মশানদানকৰ্ম্মাকাৰ্ষীৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","অতোহং যুষ্মান্ তথ্যং ৱদামি সৰ্ৱ্ৱস্মিন্ জগতি যত্ৰ যত্ৰৈষ সুসমাচাৰঃ প্ৰচাৰিষ্যতে, তত্ৰ তত্ৰৈতস্যা নাৰ্য্যাঃ স্মৰণাৰ্থম্ কৰ্ম্মেদং প্ৰচাৰিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","ততো দ্ৱাদশশিষ্যাণাম্ ঈষ্কৰিযোতীযযিহূদানামক একঃ শিষ্যঃ প্ৰধানযাজকানামন্তিকং গৎৱা কথিতৱান্, ");
INSERT INTO sanasm_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","যদি যুষ্মাকং কৰেষু যীশুং সমৰ্পযামি, তৰ্হি কিং দাস্যথ? তদানীং তে তস্মৈ ত্ৰিংশন্মুদ্ৰা দাতুং স্থিৰীকৃতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","স তদাৰভ্য তং পৰকৰেষু সমৰ্পযিতুং সুযোগং চেষ্টিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","অনন্তৰং কিণ্ৱশূন্যপূপপৰ্ৱ্ৱণঃ প্ৰথমেহ্নি শিষ্যা যীশুম্ উপগত্য পপ্ৰচ্ছুঃ ভৱৎকৃতে কুত্ৰ ৱযং নিস্তাৰমহভোজ্যম্ আযোজযিষ্যামঃ? ভৱতঃ কেচ্ছা? ");
INSERT INTO sanasm_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","তদা স গদিতৱান্, মধ্যেনগৰমমুকপুংসঃ সমীপং ৱ্ৰজিৎৱা ৱদত, গুৰু ৰ্গদিতৱান্, মৎকালঃ সৱিধঃ, সহ শিষ্যৈস্ত্ৱদালযে নিস্তাৰমহভোজ্যং ভোক্ষ্যে| ");
INSERT INTO sanasm_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","তদা শিষ্যা যীশোস্তাদৃশনিদেশানুৰূপকৰ্ম্ম ৱিধায তত্ৰ নিস্তাৰমহভোজ্যমাসাদযামাসুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ততঃ সন্ধ্যাযাং সত্যাং দ্ৱাদশভিঃ শিষ্যৈঃ সাকং স ন্যৱিশৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","অপৰং ভুঞ্জান উক্তৱান্ যুষ্মান্ তথ্যং ৱদামি, যুষ্মাকমেকো মাং পৰকৰেষু সমৰ্পযিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","তদা তেঽতীৱ দুঃখিতা একৈকশো ৱক্তুমাৰেভিৰে, হে প্ৰভো, স কিমহং? ");
INSERT INTO sanasm_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ততঃ স জগাদ, মযা সাকং যো জনো ভোজনপাত্ৰে কৰং সংক্ষিপতি, স এৱ মাং পৰকৰেষু সমৰ্পযিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","মনুজসুতমধি যাদৃশং লিখিতমাস্তে, তদনুৰূপা তদ্গতি ৰ্ভৱিষ্যতি; কিন্তু যেন পুংসা স পৰকৰেষু সমৰ্পযিষ্যতে, হা হা চেৎ স নাজনিষ্যত, তদা তস্য ক্ষেমমভৱিষ্যৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","তদা যিহূদানামা যো জনস্তং পৰকৰেষু সমৰ্পযিষ্যতি, স উক্তৱান্, হে গুৰো, স কিমহং? ততঃ স প্ৰত্যুক্তৱান্, ৎৱযা সত্যং গদিতম্| ");
INSERT INTO sanasm_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","অনন্তৰং তেষামশনকালে যীশুঃ পূপমাদাযেশ্ৱৰীযগুণাননূদ্য ভংক্ত্ৱা শিষ্যেভ্যঃ প্ৰদায জগাদ, মদ্ৱপুঃস্ৱৰূপমিমং গৃহীৎৱা খাদত| ");
INSERT INTO sanasm_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","পশ্চাৎ স কংসং গৃহ্লন্ ঈশ্ৱৰীযগুণাননূদ্য তেভ্যঃ প্ৰদায কথিতৱান্, সৰ্ৱ্ৱৈ ৰ্যুষ্মাভিৰনেন পাতৱ্যং, ");
INSERT INTO sanasm_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","যস্মাদনেকেষাং পাপমৰ্ষণায পাতিতং যন্মন্নূত্ননিযমৰূপশোণিতং তদেতৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","অপৰমহং নূত্নগোস্তনীৰসং ন পাস্যামি, তাৱৎ গোস্তনীফলৰসং পুনঃ কদাপি ন পাস্যামি| ");
INSERT INTO sanasm_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","পশ্চাৎ তে গীতমেকং সংগীয জৈতুনাখ্যগিৰিং গতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","তদানীং যীশুস্তানৱোচৎ, অস্যাং ৰজন্যামহং যুষ্মাকং সৰ্ৱ্ৱেষাং ৱিঘ্নৰূপো ভৱিষ্যামি, যতো লিখিতমাস্তে, \"মেষাণাং ৰক্ষকো যস্তং প্ৰহৰিষ্যাম্যহং ততঃ| মেষাণাং নিৱহো নূনং প্ৰৱিকীৰ্ণো ভৱিষ্যতি\"|| ");
INSERT INTO sanasm_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","কিন্তু শ্মশানাৎ সমুত্থায যুষ্মাকমগ্ৰেঽহং গালীলং গমিষ্যামি| ");
INSERT INTO sanasm_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","পিতৰস্তং প্ৰোৱাচ, ভৱাংশ্চেৎ সৰ্ৱ্ৱেষাং ৱিঘ্নৰূপো ভৱতি, তথাপি মম ন ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ততো যীশুনা স উক্তঃ, তুভ্যমহং তথ্যং কথযামি, যামিন্যামস্যাং চৰণাযুধস্য ৰৱাৎ পূৰ্ৱ্ৱং ৎৱং মাং ত্ৰি ৰ্নাঙ্গীকৰিষ্যসি| ");
INSERT INTO sanasm_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ততঃ পিতৰ উদিতৱান্, যদ্যপি ৎৱযা সমং মৰ্ত্তৱ্যং, তথাপি কদাপি ৎৱাং ন নাঙ্গীকৰিষ্যামি; তথৈৱ সৰ্ৱ্ৱে শিষ্যাশ্চোচুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","অনন্তৰং যীশুঃ শিষ্যৈঃ সাকং গেৎশিমানীনামকং স্থানং প্ৰস্থায তেভ্যঃ কথিতৱান্, অদঃ স্থানং গৎৱা যাৱদহং প্ৰাৰ্থযিষ্যে তাৱদ্ যূযমত্ৰোপৱিশত| ");
INSERT INTO sanasm_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","পশ্চাৎ স পিতৰং সিৱদিযসুতৌ চ সঙ্গিনঃ কৃৎৱা গতৱান্, শোকাকুলোঽতীৱ ৱ্যথিতশ্চ বভূৱ| ");
INSERT INTO sanasm_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","তানৱাদীচ্চ মৃতিযাতনেৱ মৎপ্ৰাণানাং যাতনা জাযতে, যূযমত্ৰ মযা সাৰ্দ্ধং জাগৃত| ");
INSERT INTO sanasm_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ততঃ স কিঞ্চিদ্দূৰং গৎৱাধোমুখঃ পতন্ প্ৰাৰ্থযাঞ্চক্ৰে, হে মৎপিতৰ্যদি ভৱিতুং শক্নোতি, তৰ্হি কংসোঽযং মত্তো দূৰং যাতু; কিন্তু মদিচ্ছাৱৎ ন ভৱতু, ৎৱদিচ্ছাৱদ্ ভৱতু| ");
INSERT INTO sanasm_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ততঃ স শিষ্যানুপেত্য তান্ নিদ্ৰতো নিৰীক্ষ্য পিতৰায কথযামাস, যূযং মযা সাকং দণ্ডমেকমপি জাগৰিতুং নাশন্কুত? ");
INSERT INTO sanasm_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","পৰীক্ষাযাং ন পতিতুং জাগৃত প্ৰাৰ্থযধ্ৱঞ্চ; আত্মা সমুদ্যতোস্তি, কিন্তু ৱপু ৰ্দুৰ্ব্বলং| ");
INSERT INTO sanasm_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","স দ্ৱিতীযৱাৰং প্ৰাৰ্থযাঞ্চক্ৰে, হে মত্তাত, ন পীতে যদি কংসমিদং মত্তো দূৰং যাতুং ন শক্নোতি, তৰ্হি ৎৱদিচ্ছাৱদ্ ভৱতু| ");
INSERT INTO sanasm_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","স পুনৰেত্য তান্ নিদ্ৰতো দদৰ্শ, যতস্তেষাং নেত্ৰাণি নিদ্ৰযা পূৰ্ণান্যাসন্| ");
INSERT INTO sanasm_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","পশ্চাৎ স তান্ ৱিহায ৱ্ৰজিৎৱা তৃতীযৱাৰং পূৰ্ৱ্ৱৱৎ কথযন্ প্ৰাৰ্থিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ততঃ শিষ্যানুপাগত্য গদিতৱান্, সাম্প্ৰতং শযানাঃ কিং ৱিশ্ৰাম্যথ? পশ্যত, সময উপাস্থাৎ, মনুজসুতঃ পাপিনাং কৰেষু সমৰ্প্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","উত্তিষ্ঠত, ৱযং যামঃ, যো মাং পৰকৰেষু মসৰ্পযিষ্যতি, পশ্যত, স সমীপমাযাতি| ");
INSERT INTO sanasm_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","এতৎকথাকথনকালে দ্ৱাদশশিষ্যাণামেকো যিহূদানামকো মুখ্যযাজকলোকপ্ৰাচীনৈঃ প্ৰহিতান্ অসিধাৰিযষ্টিধাৰিণো মনুজান্ গৃহীৎৱা তৎসমীপমুপতস্থৌ| ");
INSERT INTO sanasm_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","অসৌ পৰকৰেষ্ৱৰ্পযিতা পূৰ্ৱ্ৱং তান্ ইত্থং সঙ্কেতযামাস, যমহং চুম্বিষ্যে, সোঽসৌ মনুজঃ,সএৱ যুষ্মাভি ৰ্ধাৰ্য্যতাং| ");
INSERT INTO sanasm_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","তদা স সপদি যীশুমুপাগত্য হে গুৰো, প্ৰণমামীত্যুক্ত্ৱা তং চুচুম্বে| ");
INSERT INTO sanasm_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","তদা যীশুস্তমুৱাচ, হে মিত্ৰং কিমৰ্থমাগতোসি? তদা তৈৰাগত্য যীশুৰাক্ৰম্য দঘ্ৰে| ");
INSERT INTO sanasm_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ততো যীশোঃ সঙ্গিনামেকঃ কৰং প্ৰসাৰ্য্য কোষাদসিং বহিষ্কৃত্য মহাযাজকস্য দাসমেকমাহত্য তস্য কৰ্ণং চিচ্ছেদ| ");
INSERT INTO sanasm_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","ততো যীশুস্তং জগাদ, খড্গং স্ৱস্থানেे নিধেহি যতো যে যে জনা অসিং ধাৰযন্তি, তএৱাসিনা ৱিনশ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","অপৰং পিতা যথা মদন্তিকং স্ৱৰ্গীযদূতানাং দ্ৱাদশৱাহিনীতোঽধিকং প্ৰহিণুযাৎ মযা তমুদ্দিশ্যেদানীমেৱ তথা প্ৰাৰ্থযিতুং ন শক্যতে, ৎৱযা কিমিত্থং জ্ঞাযতে? ");
INSERT INTO sanasm_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","তথা সতীত্থং ঘটিষ্যতে ধৰ্ম্মপুস্তকস্য যদিদং ৱাক্যং তৎ কথং সিধ্যেৎ? ");
INSERT INTO sanasm_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","তদানীং যীশু ৰ্জননিৱহং জগাদ, যূযং খড্গযষ্টীন্ আদায মাং কিং চৌৰং ধৰ্ত্তুমাযাতাঃ? অহং প্ৰত্যহং যুষ্মাভিঃ সাকমুপৱিশ্য সমুপাদিশং, তদা মাং নাধৰত; ");
INSERT INTO sanasm_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","কিন্তু ভৱিষ্যদ্ৱাদিনাং ৱাক্যানাং সংসিদ্ধযে সৰ্ৱ্ৱমেতদভূৎ| তদা সৰ্ৱ্ৱে শিষ্যাস্তং ৱিহায পলাযন্ত| ");
INSERT INTO sanasm_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","অনন্তৰং তে মনুজা যীশুং ধৃৎৱা যত্ৰাধ্যাপকপ্ৰাঞ্চঃ পৰিষদং কুৰ্ৱ্ৱন্ত উপাৱিশন্ তত্ৰ কিযফানাाমকমহাযাজকস্যান্তিকং নিন্যুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","কিন্তু শেষে কিং ভৱিষ্যতীতি ৱেত্তুং পিতৰো দূৰে তৎপশ্চাদ্ ৱ্ৰজিৎৱা মহাযাজকস্যাট্টালিকাং প্ৰৱিশ্য দাসৈঃ সহিত উপাৱিশৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","তদানীং প্ৰধানযাজকপ্ৰাচীনমন্ত্ৰিণঃ সৰ্ৱ্ৱে যীশুং হন্তুং মৃষাসাক্ষ্যম্ অলিপ্সন্ত, ");
INSERT INTO sanasm_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","কিন্তু ন লেভিৰে| অনেকেষু মৃষাসাক্ষিষ্ৱাগতেষ্ৱপি তন্ন প্ৰাপুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","শেষে দ্ৱৌ মৃষাসাক্ষিণাৱাগত্য জগদতুঃ, পুমানযমকথযৎ, অহমীশ্ৱৰমন্দিৰং ভংক্ত্ৱা দিনত্ৰযমধ্যে তন্নিৰ্ম্মাতুং শক্নোমি| ");
INSERT INTO sanasm_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","তদা মহাযাজক উত্থায যীশুম্ অৱাদীৎ| ৎৱং কিমপি ন প্ৰতিৱদসি? ৎৱামধি কিমেতে সাক্ষ্যং ৱদন্তি? ");
INSERT INTO sanasm_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","কিন্তু যীশু ৰ্মৌনীভূয তস্যৌ| ততো মহাযাজক উক্তৱান্, ৎৱাম্ অমৰেশ্ৱৰনাম্না শপযামি, ৎৱমীশ্ৱৰস্য পুত্ৰোঽভিষিক্তো ভৱসি নৱেতি ৱদ| ");
INSERT INTO sanasm_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","যীশুঃ প্ৰত্যৱদৎ, ৎৱং সত্যমুক্তৱান্; অহং যুষ্মান্ তথ্যং ৱদামি, ইতঃপৰং মনুজসুতং সৰ্ৱ্ৱশক্তিমতো দক্ষিণপাৰ্শ্ৱে স্থাতুং গগণস্থং জলধৰানাৰুহ্যাযান্তং ৱীক্ষধ্ৱে| ");
INSERT INTO sanasm_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","তদা মহাযাজকো নিজৱসনং ছিত্ত্ৱা জগাদ, এষ ঈশ্ৱৰং নিন্দিতৱান্, অস্মাকমপৰসাক্ষ্যেণ কিং প্ৰযোজনং? পশ্যত, যূযমেৱাস্যাস্যাদ্ ঈশ্ৱৰনিন্দাং শ্ৰুতৱন্তঃ, ");
INSERT INTO sanasm_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","যুষ্মাভিঃ কিং ৱিৱিচ্যতে? তে প্ৰত্যূচুঃ, ৱধাৰ্হোঽযং| ");
INSERT INTO sanasm_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ততো লোকৈস্তদাস্যে নিষ্ঠীৱিতং কেচিৎ প্ৰতলমাহত্য কেচিচ্চ চপেটমাহত্য বভাষিৰে, ");
INSERT INTO sanasm_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","হে খ্ৰীষ্ট ৎৱাং কশ্চপেটমাহতৱান্? ইতি গণযিৎৱা ৱদাস্মান্| ");
INSERT INTO sanasm_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","পিতৰো বহিৰঙ্গন উপৱিশতি, তদানীমেকা দাসী তমুপাগত্য বভাষে, ৎৱং গালীলীযযীশোঃ সহচৰএকঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","কিন্তু স সৰ্ৱ্ৱেষাং সমক্ষম্ অনঙ্গীকৃত্যাৱাদীৎ, ৎৱযা যদুচ্যতে, তদৰ্থমহং ন ৱেদ্মি| ");
INSERT INTO sanasm_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","তদা তস্মিন্ বহিৰ্দ্ৱাৰং গতে ঽন্যা দাসী তং নিৰীক্ষ্য তত্ৰত্যজনানৱদৎ, অযমপি নাসৰতীযযীশুনা সাৰ্দ্ধম্ আসীৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","ততঃ স শপথেন পুনৰনঙ্গীকৃত্য কথিতৱান্, তং নৰং ন পৰিচিনোমি| ");
INSERT INTO sanasm_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ক্ষণাৎ পৰং তিষ্ঠন্তো জনা এত্য পিতৰম্ অৱদন্, ৎৱমৱশ্যং তেষামেক ইতি ৎৱদুচ্চাৰণমেৱ দ্যোতযতি| ");
INSERT INTO sanasm_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","কিন্তু সোঽভিশপ্য কথিতৱান্, তং জনং নাহং পৰিচিনোমি, তদা সপদি কুক্কুটো ৰুৰাৱ| ");
INSERT INTO sanasm_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","কুক্কুটৰৱাৎ প্ৰাক্ ৎৱং মাং ত্ৰিৰপাহ্নোষ্যসে, যৈষা ৱাগ্ যীশুনাৱাদি তাং পিতৰঃ সংস্মৃত্য বহিৰিৎৱা খেদাদ্ ভৃশং চক্ৰন্দ| ");
INSERT INTO sanasm_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","প্ৰভাতে জাতে প্ৰধানযাজকলোকপ্ৰাচীনা যীশুং হন্তুং তৎপ্ৰতিকূলং মন্ত্ৰযিৎৱা ");
INSERT INTO sanasm_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","তং বদ্ৱ্ৱা নীৎৱা পন্তীযপীলাতাখ্যাধিপে সমৰ্পযামাসুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","ততো যীশোঃ পৰকৰেৱ্ৱৰ্পযিতা যিহূদাস্তৎপ্ৰাণাদণ্ডাজ্ঞাং ৱিদিৎৱা সন্তপ্তমনাঃ প্ৰধানযাজকলোকপ্ৰাচীনানাং সমক্ষং তাস্ত্ৰীংশন্মুদ্ৰাঃ প্ৰতিদাযাৱাদীৎ, ");
INSERT INTO sanasm_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","এতন্নিৰাগোনৰপ্ৰাণপৰকৰাৰ্পণাৎ কলুষং কৃতৱানহং| তদা ত উদিতৱন্তঃ, তেনাস্মাকং কিং? ৎৱযা তদ্ বুধ্যতাম্| ");
INSERT INTO sanasm_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ততো যিহূদা মন্দিৰমধ্যে তা মুদ্ৰা নিক্ষিপ্য প্ৰস্থিতৱান্ ইৎৱা চ স্ৱযমাত্মানমুদ্ববন্ধ| ");
INSERT INTO sanasm_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","পশ্চাৎ প্ৰধানযাজকাস্তা মুদ্ৰা আদায কথিতৱন্তঃ, এতা মুদ্ৰাঃ শোণিতমূল্যং তস্মাদ্ ভাণ্ডাগাৰে ন নিধাতৱ্যাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","অনন্তৰং তে মন্ত্ৰযিৎৱা ৱিদেশিনাং শ্মশানস্থানায তাভিঃ কুলালস্য ক্ষেত্ৰমক্ৰীণন্| ");
INSERT INTO sanasm_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","অতোঽদ্যাপি তৎস্থানং ৰক্তক্ষেত্ৰং ৱদন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ইত্থং সতি ইস্ৰাযেলীযসন্তানৈ ৰ্যস্য মূল্যং নিৰুপিতং, তস্য ত্ৰিংশন্মুদ্ৰামানং মূল্যং ");
INSERT INTO sanasm_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","মাং প্ৰতি পৰমেশ্ৱৰস্যাদেশাৎ তেভ্য আদীযত, তেন চ কুলালস্য ক্ষেত্ৰং ক্ৰীতমিতি যদ্ৱচনং যিৰিমিযভৱিষ্যদ্ৱাদিনা প্ৰোক্তং তৎ তদাসিধ্যৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","অনন্তৰং যীশৌ তদধিপতেঃ সম্মুখ উপতিষ্ঠতি স তং পপ্ৰচ্ছ, ৎৱং কিং যিহূদীযানাং ৰাজা? তদা যীশুস্তমৱদৎ, ৎৱং সত্যমুক্তৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","কিন্তু প্ৰধানযাজকপ্ৰাচীনৈৰভিযুক্তেন তেন কিমপি ন প্ৰত্যৱাদি| ");
INSERT INTO sanasm_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","ততঃ পীলাতেন স উদিতঃ, ইমে ৎৱৎপ্ৰতিকূলতঃ কতি কতি সাক্ষ্যং দদতি, তৎ ৎৱং ন শৃণোষি? ");
INSERT INTO sanasm_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","তথাপি স তেষামেকস্যাপি ৱচস উত্তৰং নোদিতৱান্; তেন সোঽধিপতি ৰ্মহাচিত্ৰং ৱিদামাস| ");
INSERT INTO sanasm_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","অন্যচ্চ তন্মহকালেঽধিপতেৰেতাদৃশী ৰাতিৰাসীৎ, প্ৰজা যং কঞ্চন বন্ধিনং যাচন্তে, তমেৱ স মোচযতীতি| ");
INSERT INTO sanasm_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","তদানীং বৰব্বানামা কশ্চিৎ খ্যাতবন্ধ্যাসীৎ| ");
INSERT INTO sanasm_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ততঃ পীলাতস্তত্ৰ মিলিতান্ লোকান্ অপৃচ্ছৎ, এষ বৰব্বা বন্ধী খ্ৰীষ্টৱিখ্যাতো যীশুশ্চৈতযোঃ কং মোচযিষ্যামি? যুষ্মাকং কিমীপ্সিতং? ");
INSERT INTO sanasm_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","তৈৰীৰ্ষ্যযা স সমৰ্পিত ইতি স জ্ঞাতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","অপৰং ৱিচাৰাসনোপৱেশনকালে পীলাতস্য পত্নী ভৃত্যং প্ৰহিত্য তস্মৈ কথযামাস, তং ধাৰ্ম্মিকমনুজং প্ৰতি ৎৱযা কিমপি ন কৰ্ত্তৱ্যং; যস্মাৎ তৎকৃতেঽদ্যাহং স্ৱপ্নে প্ৰভূতকষ্টমলভে| ");
INSERT INTO sanasm_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","অনন্তৰং প্ৰধানযাজকপ্ৰাচীনা বৰব্বাং যাচিৎৱাদাতুং যীশুঞ্চ হন্তুং সকললোকান্ প্ৰাৱৰ্ত্তযন্| ");
INSERT INTO sanasm_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ততোঽধিপতিস্তান্ পৃষ্টৱান্, এতযোঃ কমহং মোচযিষ্যামি? যুষ্মাকং কেচ্ছা? তে প্ৰোচু ৰ্বৰব্বাং| ");
INSERT INTO sanasm_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","তদা পীলাতঃ পপ্ৰচ্ছ, তৰ্হি যং খ্ৰীষ্টং ৱদন্তি, তং যীশুং কিং কৰিষ্যামি? সৰ্ৱ্ৱে কথযামাসুঃ, স ক্ৰুশেন ৱিধ্যতাং| ");
INSERT INTO sanasm_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ততোঽধিপতিৰৱাদীৎ, কুতঃ? কিং তেনাপৰাদ্ধং? কিন্তু তে পুনৰুচৈ ৰ্জগদুঃ, স ক্ৰুশেন ৱিধ্যতাং| ");
INSERT INTO sanasm_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","তদা নিজৱাক্যমগ্ৰাহ্যমভূৎ, কলহশ্চাপ্যভূৎ, পীলাত ইতি ৱিলোক্য লোকানাং সমক্ষং তোযমাদায কৰৌ প্ৰক্ষাল্যাৱোচৎ, এতস্য ধাৰ্ম্মিকমনুষ্যস্য শোণিতপাতে নিৰ্দোষোঽহং, যুষ্মাভিৰেৱ তদ্ বুধ্যতাং| ");
INSERT INTO sanasm_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","তদা সৰ্ৱ্ৱাঃ প্ৰজাঃ প্ৰত্যৱোচন্, তস্য শোণিতপাতাপৰাধোঽস্মাকম্ অস্মৎসন্তানানাঞ্চোপৰি ভৱতু| ");
INSERT INTO sanasm_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","ততঃ স তেষাং সমীপে বৰব্বাং মোচযামাস যীশুন্তু কষাভিৰাহত্য ক্ৰুশেন ৱেধিতুং সমৰ্পযামাস| ");
INSERT INTO sanasm_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","অনন্তৰম্ অধিপতেঃ সেনা অধিপতে ৰ্গৃহং যীশুমানীয তস্য সমীপে সেনাসমূহং সংজগৃহুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ততস্তে তস্য ৱসনং মোচযিৎৱা কৃষ্ণলোহিতৱৰ্ণৱসনং পৰিধাপযামাসুঃ ");
INSERT INTO sanasm_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","কণ্টকানাং মুকুটং নিৰ্ম্মায তচ্ছিৰসি দদুঃ, তস্য দক্ষিণকৰে ৱেত্ৰমেকং দত্ত্ৱা তস্য সম্মুখে জানূনি পাতযিৎৱা, হে যিহূদীযানাং ৰাজন্, তুভ্যং নম ইত্যুক্ত্ৱা তং তিৰশ্চক্ৰুঃ, ");
INSERT INTO sanasm_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ততস্তস্য গাত্ৰে নিষ্ঠীৱং দৎৱা তেন ৱেত্ৰেণ শিৰ আজঘ্নুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ইত্থং তং তিৰস্কৃত্য তদ্ ৱসনং মোচযিৎৱা পুনৰ্নিজৱসনং পৰিধাপযাঞ্চক্ৰুঃ, তং ক্ৰুশেন ৱেধিতুং নীতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","পশ্চাত্তে বহিৰ্ভূয কুৰীণীযং শিমোন্নামকমেকং ৱিলোক্য ক্ৰুশং ৱোঢুং তমাদদিৰে| ");
INSERT INTO sanasm_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","অনন্তৰং গুল্গল্তাম্ অৰ্থাৎ শিৰস্কপালনামকস্থানমু পস্থায তে যীশৱে পিত্তমিশ্ৰিতাম্লৰসং পাতুং দদুঃ, ");
INSERT INTO sanasm_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","কিন্তু স তমাস্ৱাদ্য ন পপৌ| ");
INSERT INTO sanasm_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","তদানীং তে তং ক্ৰুশেন সংৱিধ্য তস্য ৱসনানি গুটিকাপাতেন ৱিভজ্য জগৃহুঃ, তস্মাৎ, ৱিভজন্তেঽধৰীযং মে তে মনুষ্যাঃ পৰস্পৰং| মদুত্তৰীযৱস্ত্ৰাৰ্থং গুটিকাং পাতযন্তি চ|| যদেতদ্ৱচনং ভৱিষ্যদ্ৱাদিভিৰুক্তমাসীৎ, তদা তদ্ অসিধ্যৎ, ");
INSERT INTO sanasm_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","পশ্চাৎ তে তত্ৰোপৱিশ্য তদ্ৰক্ষণকৰ্ৱ্ৱণি নিযুক্তাস্তস্থুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","অপৰম্ এষ যিহূদীযানাং ৰাজা যীশুৰিত্যপৱাদলিপিপত্ৰং তচ্ছিৰস ঊৰ্দ্ৱ্ৱে যোজযামাসুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ততস্তস্য ৱামে দক্ষিণে চ দ্ৱৌ চৈৰৌ তেন সাকং ক্ৰুশেন ৱিৱিধুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","তদা পান্থা নিজশিৰো লাডযিৎৱা তং নিন্দন্তো জগদুঃ, ");
INSERT INTO sanasm_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","হে ঈশ্ৱৰমন্দিৰভঞ্জক দিনত্ৰযে তন্নিৰ্ম্মাতঃ স্ৱং ৰক্ষ, চেত্ত্ৱমীশ্ৱৰসুতস্তৰ্হি ক্ৰুশাদৱৰোহ| ");
INSERT INTO sanasm_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","প্ৰধানযাজকাধ্যাপকপ্ৰাচীনাশ্চ তথা তিৰস্কৃত্য জগদুঃ, ");
INSERT INTO sanasm_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","সোঽন্যজনানাৱৎ, কিন্তু স্ৱমৱিতুং ন শক্নোতি| যদীস্ৰাযেলো ৰাজা ভৱেৎ, তৰ্হীদানীমেৱ ক্ৰুশাদৱৰোহতু, তেন তং ৱযং প্ৰত্যেষ্যামঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","স ঈশ্ৱৰে প্ৰত্যাশামকৰোৎ, যদীশ্ৱৰস্তস্মিন্ সন্তুষ্টস্তৰ্হীদানীমেৱ তমৱেৎ, যতঃ স উক্তৱান্ অহমীশ্ৱৰসুতঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","যৌ স্তেনৌ সাকং তেন ক্ৰুশেন ৱিদ্ধৌ তৌ তদ্ৱদেৱ তং নিনিন্দতুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","তদা দ্ৱিতীযযামাৎ তৃতীযযামং যাৱৎ সৰ্ৱ্ৱদেশে তমিৰং বভূৱ, ");
INSERT INTO sanasm_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","তৃতীযযামে \"এলী এলী লামা শিৱক্তনী\", অৰ্থাৎ মদীশ্ৱৰ মদীশ্ৱৰ কুতো মামত্যাক্ষীঃ? যীশুৰুচ্চৈৰিতি জগাদ| ");
INSERT INTO sanasm_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","তদা তত্ৰ স্থিতাঃ কেচিৎ তৎ শ্ৰুৎৱা বভাষিৰে, অযম্ এলিযমাহূযতি| ");
INSERT INTO sanasm_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","তেষাং মধ্যাদ্ একঃ শীঘ্ৰং গৎৱা স্পঞ্জং গৃহীৎৱা তত্ৰাম্লৰসং দত্ত্ৱা নলেন পাতুং তস্মৈ দদৌ| ");
INSERT INTO sanasm_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ইতৰেঽকথযন্ তিষ্ঠত, তং ৰক্ষিতুম্ এলিয আযাতি নৱেতি পশ্যামঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","যীশুঃ পুনৰুচৈৰাহূয প্ৰাণান্ জহৌ| ");
INSERT INTO sanasm_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","ততো মন্দিৰস্য ৱিচ্ছেদৱসনম্ ঊৰ্দ্ৱ্ৱাদধো যাৱৎ ছিদ্যমানং দ্ৱিধাভৱৎ, ");
INSERT INTO sanasm_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ভূমিশ্চকম্পে ভূধৰোৱ্যদীৰ্য্যত চ| শ্মশানে মুক্তে ভূৰিপুণ্যৱতাং সুপ্তদেহা উদতিষ্ঠন্, ");
INSERT INTO sanasm_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","শ্মশানাদ্ ৱহিৰ্ভূয তদুত্থানাৎ পৰং পুণ্যপুৰং গৎৱা বহুজনান্ দৰ্শযামাসুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","যীশুৰক্ষণায নিযুক্তঃ শতসেনাপতিস্তৎসঙ্গিনশ্চ তাদৃশীং ভূকম্পাদিঘটনাং দৃষ্ট্ৱা ভীতা অৱদন্, এষ ঈশ্ৱৰপুত্ৰো ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","যা বহুযোষিতো যীশুং সেৱমানা গালীলস্তৎপশ্চাদাগতাস্তাসাং মধ্যে ");
INSERT INTO sanasm_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","মগ্দলীনী মৰিযম্ যাকূব্যোশ্যো ৰ্মাতা যা মৰিযম্ সিবদিযপুত্ৰযো ৰ্মাতা চ যোষিত এতা দূৰে তিষ্ঠন্ত্যো দদৃশুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","সন্ধ্যাযাং সত্যম্ অৰিমথিযানগৰস্য যূষফ্নামা ধনী মনুজো যীশোঃ শিষ্যৎৱাৎ ");
INSERT INTO sanasm_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","পীলাতস্য সমীপং গৎৱা যীশোঃ কাযং যযাচে, তেন পীলাতঃ কাযং দাতুম্ আদিদেশ| ");
INSERT INTO sanasm_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","যূষফ্ তৎকাযং নীৎৱা শুচিৱস্ত্ৰেণাচ্ছাদ্য ");
INSERT INTO sanasm_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","স্ৱাৰ্থং শৈলে যৎ শ্মশানং চখান, তন্মধ্যে তৎকাযং নিধায তস্য দ্ৱাৰি ৱৃহৎপাষাণং দদৌ| ");
INSERT INTO sanasm_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","কিন্তু মগ্দলীনী মৰিযম্ অন্যমৰিযম্ এতে স্ত্ৰিযৌ তত্ৰ শ্মশানসম্মুখ উপৱিৱিশতুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","তদনন্তৰং নিস্তাৰোৎসৱস্যাযোজনদিনাৎ পৰেঽহনি প্ৰধানযাজকাঃ ফিৰূশিনশ্চ মিলিৎৱা পীলাতমুপাগত্যাকথযন্, ");
INSERT INTO sanasm_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","হে মহেচ্ছ স প্ৰতাৰকো জীৱন অকথযৎ, দিনত্ৰযাৎ পৰং শ্মশানাদুত্থাস্যামি তদ্ৱাক্যং স্মৰামো ৱযং; ");
INSERT INTO sanasm_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","তস্মাৎ তৃতীযদিনং যাৱৎ তৎ শ্মশানং ৰক্ষিতুমাদিশতু, নোচেৎ তচ্ছিষ্যা যামিন্যামাগত্য তং হৃৎৱা লোকান্ ৱদিষ্যন্তি, স শ্মশানাদুদতিষ্ঠৎ, তথা সতি প্ৰথমভ্ৰান্তেঃ শেষীযভ্ৰান্তি ৰ্মহতী ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","তদা পীলাত অৱাদীৎ, যুষ্মাকং সমীপে ৰক্ষিগণ আস্তে, যূযং গৎৱা যথা সাধ্যং ৰক্ষযত| ");
INSERT INTO sanasm_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ততস্তে গৎৱা তদ্দূाৰপাষাণং মুদ্ৰাঙ্কিতং কৃৎৱা ৰক্ষিগণং নিযোজ্য শ্মশানং ৰক্ষযামাসুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ততঃ পৰং ৱিশ্ৰামৱাৰস্য শেষে সপ্তাহপ্ৰথমদিনস্য প্ৰভোতে জাতে মগ্দলীনী মৰিযম্ অন্যমৰিযম্ চ শ্মশানং দ্ৰষ্টুমাগতা| ");
INSERT INTO sanasm_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","তদা মহান্ ভূকম্পোঽভৱৎ; পৰমেশ্ৱৰীযদূতঃ স্ৱৰ্গাদৱৰুহ্য শ্মশানদ্ৱাৰাৎ পাষাণমপসাৰ্য্য তদুপৰ্য্যুপৱিৱেশ| ");
INSERT INTO sanasm_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","তদ্ৱদনং ৱিদ্যুদ্ৱৎ তেজোমযং ৱসনং হিমশুভ্ৰঞ্চ| ");
INSERT INTO sanasm_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","তদানীং ৰক্ষিণস্তদ্ভযাৎ কম্পিতা মৃতৱদ্ বভূৱঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","স দূতো যোষিতো জগাদ, যূযং মা ভৈষ্ট, ক্ৰুশহতযীশুং মৃগযধ্ৱে তদহং ৱেদ্মি| ");
INSERT INTO sanasm_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","সোঽত্ৰ নাস্তি, যথাৱদৎ তথোত্থিতৱান্; এতৎ প্ৰভোঃ শযনস্থানং পশ্যত| ");
INSERT INTO sanasm_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","তূৰ্ণং গৎৱা তচ্ছিষ্যান্ ইতি ৱদত, স শ্মশানাদ্ উদতিষ্ঠৎ, যুষ্মাকমগ্ৰে গালীলং যাস্যতি যূযং তত্ৰ তং ৱীক্ষিষ্যধ্ৱে, পশ্যতাহং ৱাৰ্ত্তামিমাং যুষ্মানৱাদিষং| ");
INSERT INTO sanasm_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ততস্তা ভযাৎ মহানন্দাঞ্চ শ্মশানাৎ তূৰ্ণং বহিৰ্ভূয তচ্ছিষ্যান্ ৱাৰ্ত্তাং ৱক্তুং ধাৱিতৱত্যঃ| কিন্তু শিষ্যান্ ৱাৰ্ত্তাং ৱক্তুং যান্তি, তদা যীশু ৰ্দৰ্শনং দত্ত্ৱা তা জগাদ, ");
INSERT INTO sanasm_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","যুষ্মাকং কল্যাণং ভূযাৎ, ততস্তা আগত্য তৎপাদযোঃ পতিৎৱা প্ৰণেমুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","যীশুস্তা অৱাদীৎ, মা বিভীত, যূযং গৎৱা মম ভ্ৰাতৃন্ গালীলং যাতুং ৱদত, তত্ৰ তে মাং দ্ৰক্ষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","স্ত্ৰিযো গচ্ছন্তি, তদা ৰক্ষিণাং কেচিৎ পুৰং গৎৱা যদ্যদ্ ঘটিতং তৎসৰ্ৱ্ৱং প্ৰধানযাজকান্ জ্ঞাপিতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","তে প্ৰাচীনৈঃ সমং সংসদং কৃৎৱা মন্ত্ৰযন্তো বহুমুদ্ৰাঃ সেনাভ্যো দত্ত্ৱাৱদন্, ");
INSERT INTO sanasm_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","অস্মাসু নিদ্ৰিতেষু তচ্ছিষ্যা যামিন্যামাগত্য তং হৃৎৱানযন্, ইতি যূযং প্ৰচাৰযত| ");
INSERT INTO sanasm_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","যদ্যেতদধিপতেঃ শ্ৰোত্ৰগোচৰীভৱেৎ, তৰ্হি তং বোধযিৎৱা যুষ্মানৱিষ্যামঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","ততস্তে মুদ্ৰা গৃহীৎৱা শিক্ষানুৰূপং কৰ্ম্ম চক্ৰুঃ, যিহূদীযানাং মধ্যে তস্যাদ্যাপি কিংৱদন্তী ৱিদ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","একাদশ শিষ্যা যীশুনিৰূপিতাগালীলস্যাদ্ৰিং গৎৱা ");
INSERT INTO sanasm_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","তত্ৰ তং সংৱীক্ষ্য প্ৰণেমুঃ, কিন্তু কেচিৎ সন্দিগ্ধৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","যীশুস্তেষাং সমীপমাগত্য ৱ্যাহৃতৱান্, স্ৱৰ্গমেদিন্যোঃ সৰ্ৱ্ৱাধিপতিৎৱভাৰো ময্যৰ্পিত আস্তে| ");
INSERT INTO sanasm_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","অতো যূযং প্ৰযায সৰ্ৱ্ৱদেশীযান্ শিষ্যান্ কৃৎৱা পিতুঃ পুত্ৰস্য পৱিত্ৰস্যাত্মনশ্চ নাম্না তানৱগাহযত; অহং যুষ্মান্ যদ্যদাদিশং তদপি পালযিতুং তানুপাদিশত| ");
INSERT INTO sanasm_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","পশ্যত, জগদন্তং যাৱৎ সদাহং যুষ্মাভিঃ সাকং তিষ্ঠামি| ইতি|");
INSERT INTO sanasm_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ঈশ্ৱৰপুত্ৰস্য যীশুখ্ৰীষ্টস্য সুসংৱাদাৰম্ভঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ভৱিষ্যদ্ৱাদিনাং গ্ৰন্থেষু লিপিৰিত্থমাস্তে, পশ্য স্ৱকীযদূতন্তু তৱাগ্ৰে প্ৰেষযাম্যহম্| গৎৱা ৎৱদীযপন্থানং স হি পৰিষ্কৰিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","\"পৰমেশস্য পন্থানং পৰিষ্কুৰুত সৰ্ৱ্ৱতঃ| তস্য ৰাজপথঞ্চৈৱ সমানং কুৰুতাধুনা| \" ইত্যেতৎ প্ৰান্তৰে ৱাক্যং ৱদতঃ কস্যচিদ্ৰৱঃ|| ");
INSERT INTO sanasm_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","সএৱ যোহন্ প্ৰান্তৰে মজ্জিতৱান্ তথা পাপমাৰ্জননিমিত্তং মনোৱ্যাৱৰ্ত্তকমজ্জনস্য কথাঞ্চ প্ৰচাৰিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ততো যিহূদাদেশযিৰূশালম্নগৰনিৱাসিনঃ সৰ্ৱ্ৱে লোকা বহি ৰ্ভূৎৱা তস্য সমীপমাগত্য স্ৱানি স্ৱানি পাপান্যঙ্গীকৃত্য যৰ্দ্দননদ্যাং তেন মজ্জিতা বভূৱুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","অস্য যোহনঃ পৰিধেযানি ক্ৰমেলকলোমজানি, তস্য কটিবন্ধনং চৰ্ম্মজাতম্, তস্য ভক্ষ্যাণি চ শূককীটা ৱন্যমধূনি চাসন্| ");
INSERT INTO sanasm_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","স প্ৰচাৰযন্ কথযাঞ্চক্ৰে, অহং নম্ৰীভূয যস্য পাদুকাবন্ধনং মোচযিতুমপি ন যোগ্যোস্মি, তাদৃশো মত্তো গুৰুতৰ একঃ পুৰুষো মৎপশ্চাদাগচ্ছতি| ");
INSERT INTO sanasm_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","অহং যুষ্মান্ জলে মজ্জিতৱান্ কিন্তু স পৱিত্ৰ আত্মানি সংমজ্জযিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","অপৰঞ্চ তস্মিন্নেৱ কালে গালীল্প্ৰদেশস্য নাসৰদ্গ্ৰামাদ্ যীশুৰাগত্য যোহনা যৰ্দ্দননদ্যাং মজ্জিতোঽভূৎ| ");
INSERT INTO sanasm_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","স জলাদুত্থিতমাত্ৰো মেঘদ্ৱাৰং মুক্তং কপোতৱৎ স্ৱস্যোপৰি অৱৰোহন্তমাত্মানঞ্চ দৃষ্টৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ৎৱং মম প্ৰিযঃ পুত্ৰস্ত্ৱয্যেৱ মমমহাসন্তোষ ইযমাকাশীযা ৱাণী বভূৱ| ");
INSERT INTO sanasm_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","তস্মিন্ কালে আত্মা তং প্ৰান্তৰমধ্যং নিনায| ");
INSERT INTO sanasm_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","অথ স চৎৱাৰিংশদ্দিনানি তস্মিন্ স্থানে ৱন্যপশুভিঃ সহ তিষ্ঠন্ শৈতানা পৰীক্ষিতঃ; পশ্চাৎ স্ৱৰ্গীযদূতাস্তং সিষেৱিৰে| ");
INSERT INTO sanasm_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","অনন্তৰং যোহনি বন্ধনালযে বদ্ধে সতি যীশু ৰ্গালীল্প্ৰদেশমাগত্য ঈশ্ৱৰৰাজ্যস্য সুসংৱাদং প্ৰচাৰযন্ কথযামাস, ");
INSERT INTO sanasm_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","কালঃ সম্পূৰ্ণ ঈশ্ৱৰৰাজ্যঞ্চ সমীপমাগতং; অতোহেতো ৰ্যূযং মনাংসি ৱ্যাৱৰ্ত্তযধ্ৱং সুসংৱাদে চ ৱিশ্ৱাসিত| ");
INSERT INTO sanasm_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","তদনন্তৰং স গালীলীযসমুদ্ৰস্য তীৰে গচ্ছন্ শিমোন্ তস্য ভ্ৰাতা অন্দ্ৰিযনামা চ ইমৌ দ্ৱৌ জনৌ মৎস্যধাৰিণৌ সাগৰমধ্যে জালং প্ৰক্ষিপন্তৌ দৃষ্ট্ৱা তাৱৱদৎ, ");
INSERT INTO sanasm_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","যুৱাং মম পশ্চাদাগচ্ছতং, যুৱামহং মনুষ্যধাৰিণৌ কৰিষ্যামি| ");
INSERT INTO sanasm_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ততস্তৌ তৎক্ষণমেৱ জালানি পৰিত্যজ্য তস্য পশ্চাৎ জগ্মতুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ততঃ পৰং তৎস্থানাৎ কিঞ্চিদ্ দূৰং গৎৱা স সিৱদীপুত্ৰযাকূব্ তদ্ভ্ৰাতৃযোহন্ চ ইমৌ নৌকাযাং জালানাং জীৰ্ণমুদ্ধাৰযন্তৌ দৃষ্ট্ৱা তাৱাহূযৎ| ");
INSERT INTO sanasm_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ততস্তৌ নৌকাযাং ৱেতনভুগ্ভিঃ সহিতং স্ৱপিতৰং ৱিহায তৎপশ্চাদীযতুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ততঃ পৰং কফৰ্নাহূম্নামকং নগৰমুপস্থায স ৱিশ্ৰামদিৱসে ভজনগ্ৰহং প্ৰৱিশ্য সমুপদিদেশ| ");
INSERT INTO sanasm_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","তস্যোপদেশাল্লোকা আশ্চৰ্য্যং মেনিৰে যতঃ সোধ্যাপকাইৱ নোপদিশন্ প্ৰভাৱৱানিৱ প্ৰোপদিদেশ| ");
INSERT INTO sanasm_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","অপৰঞ্চ তস্মিন্ ভজনগৃহে অপৱিত্ৰভূতেন গ্ৰস্ত একো মানুষ আসীৎ| স চীৎশব্দং কৃৎৱা কথযাঞ্চকে ");
INSERT INTO sanasm_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ভো নাসৰতীয যীশো ৎৱমস্মান্ ত্যজ, ৎৱযা সহাস্মাকং কঃ সম্বন্ধঃ? ৎৱং কিমস্মান্ নাশযিতুং সমাগতঃ? ৎৱমীশ্ৱৰস্য পৱিত্ৰলোক ইত্যহং জানামি| ");
INSERT INTO sanasm_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","তদা যীশুস্তং তৰ্জযিৎৱা জগাদ তূষ্ণীং ভৱ ইতো বহিৰ্ভৱ চ| ");
INSERT INTO sanasm_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ততঃ সোঽপৱিত্ৰভূতস্তং সম্পীড্য অত্যুচৈশ্চীৎকৃত্য নিৰ্জগাম| ");
INSERT INTO sanasm_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","তেনৈৱ সৰ্ৱ্ৱে চমৎকৃত্য পৰস্পৰং কথযাঞ্চক্ৰিৰে, অহো কিমিদং? কীদৃশোঽযং নৱ্য উপদেশঃ? অনেন প্ৰভাৱেনাপৱিত্ৰভূতেষ্ৱাজ্ঞাপিতেষু তে তদাজ্ঞানুৱৰ্ত্তিনো ভৱন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","তদা তস্য যশো গালীলশ্চতুৰ্দিক্স্থসৰ্ৱ্ৱদেশান্ ৱ্যাপ্নোৎ| ");
INSERT INTO sanasm_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","অপৰঞ্চ তে ভজনগৃহাদ্ বহি ৰ্ভূৎৱা যাকূব্যোহন্ভ্যাং সহ শিমোন আন্দ্ৰিযস্য চ নিৱেশনং প্ৰৱিৱিশুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","তদা পিতৰস্য শ্ৱশ্ৰূৰ্জ্ৱৰপীডিতা শয্যাযামাস্ত ইতি তে তং ঝটিতি ৱিজ্ঞাপযাঞ্চক্ৰুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ততঃ স আগত্য তস্যা হস্তং ধৃৎৱা তামুদস্থাপযৎ; তদৈৱ তাং জ্ৱৰোঽত্যাক্ষীৎ ততঃ পৰং সা তান্ সিষেৱে| ");
INSERT INTO sanasm_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","অথাস্তং গতে ৰৱৌ সন্ধ্যাকালে সতি লোকাস্তৎসমীপং সৰ্ৱ্ৱান্ ৰোগিণো ভূতধৃতাংশ্চ সমানিন্যুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","সৰ্ৱ্ৱে নাগৰিকা লোকা দ্ৱাৰি সংমিলিতাশ্চ| ");
INSERT INTO sanasm_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ততঃ স নানাৱিধৰোগিণো বহূন্ মনুজানৰোগিণশ্চকাৰ তথা বহূন্ ভূতান্ ত্যাজযাঞ্চকাৰ তান্ ভূতান্ কিমপি ৱাক্যং ৱক্তুং নিষিষেধ চ যতোহেতোস্তে তমজানন্| ");
INSERT INTO sanasm_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","অপৰঞ্চ সোঽতিপ্ৰত্যূষে ৱস্তুতস্তু ৰাত্ৰিশেষে সমুত্থায বহিৰ্ভূয নিৰ্জনং স্থানং গৎৱা তত্ৰ প্ৰাৰ্থযাঞ্চক্ৰে| ");
INSERT INTO sanasm_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","অনন্তৰং শিমোন্ তৎসঙ্গিনশ্চ তস্য পশ্চাদ্ গতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","তদুদ্দেশং প্ৰাপ্য তমৱদন্ সৰ্ৱ্ৱে লোকাস্ত্ৱাং মৃগযন্তে| ");
INSERT INTO sanasm_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","তদা সোঽকথযৎ আগচ্ছত ৱযং সমীপস্থানি নগৰাণি যামঃ, যতোঽহং তত্ৰ কথাং প্ৰচাৰযিতুং বহিৰাগমম্| ");
INSERT INTO sanasm_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","অথ স তেষাং গালীল্প্ৰদেশস্য সৰ্ৱ্ৱেষু ভজনগৃহেষু কথাঃ প্ৰচাৰযাঞ্চক্ৰে ভূতানত্যাজযঞ্চ| ");
INSERT INTO sanasm_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","অনন্তৰমেকঃ কুষ্ঠী সমাগত্য তৎসম্মুখে জানুপাতং ৱিনযঞ্চ কৃৎৱা কথিতৱান্ যদি ভৱান্ ইচ্ছতি তৰ্হি মাং পৰিষ্কৰ্ত্তুং শক্নোতি| ");
INSERT INTO sanasm_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ততঃ কৃপালু ৰ্যীশুঃ কৰৌ প্ৰসাৰ্য্য তং স্পষ্ট্ৱা কথযামাস ");
INSERT INTO sanasm_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","মমেচ্ছা ৱিদ্যতে ৎৱং পৰিষ্কৃতো ভৱ| এতৎকথাযাঃ কথনমাত্ৰাৎ স কুষ্ঠী ৰোগান্মুক্তঃ পৰিষ্কৃতোঽভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","তদা স তং ৱিসৃজন্ গাঢমাদিশ্য জগাদ ");
INSERT INTO sanasm_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","সাৱধানো ভৱ কথামিমাং কমপি মা ৱদ; স্ৱাত্মানং যাজকং দৰ্শয, লোকেভ্যঃ স্ৱপৰিষ্কৃতেঃ প্ৰমাণদানায মূসানিৰ্ণীতং যদ্দানং তদুৎসৃজস্ৱ চ| ");
INSERT INTO sanasm_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","কিন্তু স গৎৱা তৎ কৰ্ম্ম ইত্থং ৱিস্তাৰ্য্য প্ৰচাৰযিতুং প্ৰাৰেভে তেনৈৱ যীশুঃ পুনঃ সপ্ৰকাশং নগৰং প্ৰৱেষ্টুং নাশক্নোৎ ততোহেতোৰ্বহিঃ কাননস্থানে তস্যৌ; তথাপি চতুৰ্দ্দিগ্ভ্যো লোকাস্তস্য সমীপমাযযুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","তদনন্তৰং যীশৈ কতিপযদিনানি ৱিলম্ব্য পুনঃ কফৰ্নাহূম্নগৰং প্ৰৱিষ্টে স গৃহ আস্ত ইতি কিংৱদন্ত্যা তৎক্ষণং তৎসমীপং বহৱো লোকা আগত্য সমুপতস্থুঃ, ");
INSERT INTO sanasm_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","তস্মাদ্ গৃহমধ্যে সৰ্ৱ্ৱেষাং কৃতে স্থানং নাভৱদ্ দ্ৱাৰস্য চতুৰ্দিক্ষ্ৱপি নাভৱৎ, তৎকালে স তান্ প্ৰতি কথাং প্ৰচাৰযাঞ্চক্ৰে| ");
INSERT INTO sanasm_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ততঃ পৰং লোকাশ্চতুৰ্ভি ৰ্মানৱৈৰেকং পক্ষাঘাতিনং ৱাহযিৎৱা তৎসমীপম্ আনিন্যুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","কিন্তু জনানাং বহুৎৱাৎ তং যীশোঃ সম্মুখমানেতুং ন শক্নুৱন্তো যস্মিন্ স্থানে স আস্তে তদুপৰিগৃহপৃষ্ঠং খনিৎৱা ছিদ্ৰং কৃৎৱা তেন মাৰ্গেণ সশয্যং পক্ষাঘাতিনম্ অৱৰোহযামাসুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ততো যীশুস্তেষাং ৱিশ্ৱাসং দৃষ্ট্ৱা তং পক্ষাঘাতিনং বভাষে হে ৱৎস তৱ পাপানাং মাৰ্জনং ভৱতু| ");
INSERT INTO sanasm_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","তদা কিযন্তোঽধ্যাপকাস্তত্ৰোপৱিশন্তো মনোভি ৰ্ৱিতৰ্কযাঞ্চক্ৰুঃ, এষ মনুষ্য এতাদৃশীমীশ্ৱৰনিন্দাং কথাং কুতঃ কথযতি? ");
INSERT INTO sanasm_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","ঈশ্ৱৰং ৱিনা পাপানি মাৰ্ষ্টুং কস্য সামৰ্থ্যম্ আস্তে? ");
INSERT INTO sanasm_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ইত্থং তে ৱিতৰ্কযন্তি যীশুস্তৎক্ষণং মনসা তদ্ বুদ্ৱ্ৱা তানৱদদ্ যূযমন্তঃকৰণৈঃ কুত এতানি ৱিতৰ্কযথ? ");
INSERT INTO sanasm_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","তদনন্তৰং যীশুস্তৎস্থানাৎ পুনঃ সমুদ্ৰতটং যযৌ; লোকনিৱহে তৎসমীপমাগতে স তান্ সমুপদিদেশ| ");
INSERT INTO sanasm_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","কিন্তু পৃথিৱ্যাং পাপানি মাৰ্ষ্টুং মনুষ্যপুত্ৰস্য সামৰ্থ্যমস্তি, এতদ্ যুষ্মান্ জ্ঞাপযিতুং (স তস্মৈ পক্ষাঘাতিনে কথযামাস) ");
INSERT INTO sanasm_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","উত্তিষ্ঠ তৱ শয্যাং গৃহীৎৱা স্ৱগৃহং যাহি, অহং ৎৱামিদম্ আজ্ঞাপযামি| ");
INSERT INTO sanasm_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ততঃ স তৎক্ষণম্ উত্থায শয্যাং গৃহীৎৱা সৰ্ৱ্ৱেষাং সাক্ষাৎ জগাম; সৰ্ৱ্ৱে ৱিস্মিতা এতাদৃশং কৰ্ম্ম ৱযম্ কদাপি নাপশ্যাম, ইমাং কথাং কথযিৎৱেশ্ৱৰং ধন্যমব্ৰুৱন্| ");
INSERT INTO sanasm_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","তদনন্তৰং যীশুস্তৎস্থানাৎ পুনঃ সমুদ্ৰতটং যযৌ; লোকনিৱহে তৎসমীপমাগতে স তান্ সমুপদিদেশ| ");
INSERT INTO sanasm_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","অথ গচ্ছন্ কৰসঞ্চযগৃহ উপৱিষ্টম্ আল্ফীযপুত্ৰং লেৱিং দৃষ্ট্ৱা তমাহূয কথিতৱান্ মৎপশ্চাৎ ৎৱামামচ্ছ ততঃ স উত্থায তৎপশ্চাদ্ যযৌ| ");
INSERT INTO sanasm_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","অনন্তৰং যীশৌ তস্য গৃহে ভোক্তুম্ উপৱিষ্টে বহৱঃ কৰমঞ্চাযিনঃ পাপিনশ্চ তেন তচ্ছিষ্যৈশ্চ সহোপৱিৱিশুঃ, যতো বহৱস্তৎপশ্চাদাজগ্মুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","তদা স কৰমঞ্চাযিভিঃ পাপিভিশ্চ সহ খাদতি, তদ্ দৃষ্ট্ৱাধ্যাপকাঃ ফিৰূশিনশ্চ তস্য শিষ্যানূচুঃ কৰমঞ্চাযিভিঃ পাপিভিশ্চ সহাযং কুতো ভুংক্তে পিৱতি চ? ");
INSERT INTO sanasm_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","তদ্ৱাক্যং শ্ৰুৎৱা যীশুঃ প্ৰত্যুৱাচ,অৰোগিলোকানাং চিকিৎসকেন প্ৰযোজনং নাস্তি, কিন্তু ৰোগিণামেৱ; অহং ধাৰ্ম্মিকানাহ্ৱাতুং নাগতঃ কিন্তু মনো ৱ্যাৱৰ্ত্তযিতুং পাপিন এৱ| ");
INSERT INTO sanasm_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ততঃ পৰং যোহনঃ ফিৰূশিনাঞ্চোপৱাসাচাৰিশিষ্যা যীশোঃ সমীপম্ আগত্য কথযামাসুঃ, যোহনঃ ফিৰূশিনাঞ্চ শিষ্যা উপৱসন্তি কিন্তু ভৱতঃ শিষ্যা নোপৱসন্তি কিং কাৰণমস্য? ");
INSERT INTO sanasm_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","তদা যীশুস্তান্ বভাষে যাৱৎ কালং সখিভিঃ সহ কন্যাযা ৱৰস্তিষ্ঠতি তাৱৎকালং তে কিমুপৱস্তুং শক্নুৱন্তি? যাৱৎকালং ৱৰস্তৈঃ সহ তিষ্ঠতি তাৱৎকালং ত উপৱস্তুং ন শক্নুৱন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","যস্মিন্ কালে তেভ্যঃ সকাশাদ্ ৱৰো নেষ্যতে স কাল আগচ্ছতি, তস্মিন্ কালে তে জনা উপৱৎস্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","কোপি জনঃ পুৰাতনৱস্ত্ৰে নূতনৱস্ত্ৰং ন সীৱ্যতি, যতো নূতনৱস্ত্ৰেণ সহ সেৱনে কৃতে জীৰ্ণং ৱস্ত্ৰং ছিদ্যতে তস্মাৎ পুন ৰ্মহৎ ছিদ্ৰং জাযতে| ");
INSERT INTO sanasm_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","কোপি জনঃ পুৰাতনকুতূষু নূতনং দ্ৰাক্ষাৰসং ন স্থাপযতি, যতো নূতনদ্ৰাক্ষাৰসস্য তেজসা তাঃ কুৎৱো ৱিদীৰ্য্যন্তে ততো দ্ৰাক্ষাৰসশ্চ পততি কুৎৱশ্চ নশ্যন্তি, অতএৱ নূতনদ্ৰাক্ষাৰসো নূতনকুতূষু স্থাপনীযঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","তদনন্তৰং যীশু ৰ্যদা ৱিশ্ৰামৱাৰে শস্যক্ষেত্ৰেণ গচ্ছতি তদা তস্য শিষ্যা গচ্ছন্তঃ শস্যমঞ্জৰীশ্ছেত্তুং প্ৰৱৃত্তাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","অতঃ ফিৰূশিনো যীশৱে কথযামাসুঃ পশ্যতু ৱিশ্ৰামৱাসৰে যৎ কৰ্ম্ম ন কৰ্ত্তৱ্যং তদ্ ইমে কুতঃ কুৰ্ৱ্ৱন্তি? ");
INSERT INTO sanasm_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","তদা স তেভ্যোঽকথযৎ দাযূদ্ তৎসংঙ্গিনশ্চ ভক্ষ্যাভাৱাৎ ক্ষুধিতাঃ সন্তো যৎ কৰ্ম্ম কৃতৱন্তস্তৎ কিং যুষ্মাভি ৰ্ন পঠিতম্? ");
INSERT INTO sanasm_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","অবিযাথৰ্নামকে মহাযাজকতাং কুৰ্ৱ্ৱতি স কথমীশ্ৱৰস্যাৱাসং প্ৰৱিশ্য যে দৰ্শনীযপূপা যাজকান্ ৱিনান্যস্য কস্যাপি ন ভক্ষ্যাস্তানেৱ বুভুজে সঙ্গিলোকেভ্যোঽপি দদৌ| ");
INSERT INTO sanasm_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","সোঽপৰমপি জগাদ, ৱিশ্ৰামৱাৰো মনুষ্যাৰ্থমেৱ নিৰূপিতোঽস্তি কিন্তু মনুষ্যো ৱিশ্ৰামৱাৰাৰ্থং নৈৱ| ");
INSERT INTO sanasm_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","মনুষ্যপুত্ৰো ৱিশ্ৰামৱাৰস্যাপি প্ৰভুৰাস্তে| ");
INSERT INTO sanasm_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","অনন্তৰং যীশুঃ পুন ৰ্ভজনগৃহং প্ৰৱিষ্টস্তস্মিন্ স্থানে শুষ্কহস্ত একো মানৱ আসীৎ| ");
INSERT INTO sanasm_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","স ৱিশ্ৰামৱাৰে তমৰোগিণং কৰিষ্যতি নৱেত্যত্ৰ বহৱস্তম্ অপৱদিতুং ছিদ্ৰমপেক্ষিতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","তদা স তং শুষ্কহস্তং মনুষ্যং জগাদ মধ্যস্থানে ৎৱমুত্তিষ্ঠ| ");
INSERT INTO sanasm_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ততঃ পৰং স তান্ পপ্ৰচ্ছ ৱিশ্ৰামৱাৰে হিতমহিতং তথা হি প্ৰাণৰক্ষা ৱা প্ৰাণনাশ এষাং মধ্যে কিং কৰণীযং ? কিন্তু তে নিঃশব্দাস্তস্থুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","তদা স তেষামন্তঃকৰণানাং কাঠিন্যাদ্ধেতো ৰ্দুঃখিতঃ ক্ৰোধাৎ চৰ্তুिদশো দৃষ্টৱান্ তং মানুষং গদিতৱান্ তং হস্তং ৱিস্তাৰয, ততস্তেন হস্তে ৱিস্তৃতে তদ্ধস্তোঽন্যহস্তৱদ্ অৰোগো জাতঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","অথ ফিৰূশিনঃ প্ৰস্থায তং নাশযিতুং হেৰোদীযৈঃ সহ মন্ত্ৰযিতুমাৰেভিৰে| ");
INSERT INTO sanasm_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","অতএৱ যীশুস্তৎস্থানং পৰিত্যজ্য শিষ্যৈঃ সহ পুনঃ সাগৰসমীপং গতঃ; ");
INSERT INTO sanasm_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ততো গালীল্যিহূদা-যিৰূশালম্-ইদোম্-যৰ্দন্নদীপাৰস্থানেভ্যো লোকসমূহস্তস্য পশ্চাদ্ গতঃ; তদন্যঃ সোৰসীদনোঃ সমীপৱাসিলোকসমূহশ্চ তস্য মহাকৰ্ম্মণাং ৱাৰ্ত্তং শ্ৰুৎৱা তস্য সন্নিধিমাগতঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","তদা লোকসমূহশ্চেৎ তস্যোপৰি পততি ইত্যাশঙ্ক্য স নাৱমেকাং নিকটে স্থাপযিতুং শিষ্যানাদিষ্টৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","যতোঽনেকমনুষ্যাণামাৰোগ্যকৰণাদ্ ৱ্যাধিগ্ৰস্তাঃ সৰ্ৱ্ৱে তং স্প্ৰষ্টুং পৰস্পৰং বলেন যত্নৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","অপৰঞ্চ অপৱিত্ৰভূতাস্তং দৃষ্ট্ৱা তচ্চৰণযোঃ পতিৎৱা প্ৰোচৈঃ প্ৰোচুঃ, ৎৱমীশ্ৱৰস্য পুত্ৰঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","কিন্তু স তান্ দৃঢম্ আজ্ঞাপ্য স্ৱং পৰিচাযিতুং নিষিদ্ধৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","অনন্তৰং স পৰ্ৱ্ৱতমাৰুহ্য যং যং প্ৰতিচ্ছা তং তমাহূতৱান্ ততস্তে তৎসমীপমাগতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","তদা স দ্ৱাদশজনান্ স্ৱেন সহ স্থাতুং সুসংৱাদপ্ৰচাৰায প্ৰেৰিতা ভৱিতুং ");
INSERT INTO sanasm_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","সৰ্ৱ্ৱপ্ৰকাৰৱ্যাধীনাং শমনকৰণায প্ৰভাৱং প্ৰাপ্তুং ভূতান্ ত্যাজযিতুঞ্চ নিযুক্তৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","তেষাং নামানীমানি, শিমোন্ সিৱদিপুত্ৰো ");
INSERT INTO sanasm_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","যাকূব্ তস্য ভ্ৰাতা যোহন্ চ আন্দ্ৰিযঃ ফিলিপো বৰ্থলমযঃ, ");
INSERT INTO sanasm_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","মথী থোমা চ আল্ফীযপুত্ৰো যাকূব্ থদ্দীযঃ কিনানীযঃ শিমোন্ যস্তং পৰহস্তেষ্ৱৰ্পযিষ্যতি স ঈষ্কৰিযোতীযযিহূদাশ্চ| ");
INSERT INTO sanasm_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","স শিমোনে পিতৰ ইত্যুপনাম দদৌ যাকূব্যোহন্ভ্যাং চ বিনেৰিগিশ্ অৰ্থতো মেঘনাদপুত্ৰাৱিত্যুপনাম দদৌ| ");
INSERT INTO sanasm_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","অনন্তৰং তে নিৱেশনং গতাঃ, কিন্তু তত্ৰাপি পুনৰ্মহান্ জনসমাগমো ঽভৱৎ তস্মাত্তে ভোক্তুমপ্যৱকাশং ন প্ৰাপ্তাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ততস্তস্য সুহৃল্লোকা ইমাং ৱাৰ্ত্তাং প্ৰাপ্য স হতজ্ঞানোভূদ্ ইতি কথাং কথযিৎৱা তং ধৃৎৱানেতুং গতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","অপৰঞ্চ যিৰূশালম আগতা যে যেঽধ্যাপকাস্তে জগদুৰযং পুৰুষো ভূতপত্যাবিষ্টস্তেন ভূতপতিনা ভূতান্ ত্যাজযতি| ");
INSERT INTO sanasm_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","ততস্তানাহূয যীশু ৰ্দৃষ্টান্তৈঃ কথাং কথিতৱান্ শৈতান্ কথং শৈতানং ত্যাজযিতুং শক্নোতি? ");
INSERT INTO sanasm_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","কিঞ্চন ৰাজ্যং যদি স্ৱৱিৰোধেন পৃথগ্ ভৱতি তৰ্হি তদ্ ৰাজ্যং স্থিৰং স্থাতুং ন শক্নোতি| ");
INSERT INTO sanasm_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","তথা কস্যাপি পৰিৱাৰো যদি পৰস্পৰং ৱিৰোধী ভৱতি তৰ্হি সোপি পৰিৱাৰঃ স্থিৰং স্থাতুং ন শক্নোতি| ");
INSERT INTO sanasm_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","তদ্ৱৎ শৈতান্ যদি স্ৱৱিপক্ষতযা উত্তিষ্ঠন্ ভিন্নো ভৱতি তৰ্হি সোপি স্থিৰং স্থাতুং ন শক্নোতি কিন্তূচ্ছিন্নো ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","অপৰঞ্চ প্ৰবলং জনং প্ৰথমং ন বদ্ধা কোপি তস্য গৃহং প্ৰৱিশ্য দ্ৰৱ্যাণি লুণ্ঠযিতুং ন শক্নোতি, তং বদ্ৱ্ৱৈৱ তস্য গৃহস্য দ্ৰৱ্যাণি লুণ্ঠযিতুং শক্নোতি| ");
INSERT INTO sanasm_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","অতোহেতো ৰ্যুষ্মভ্যমহং সত্যং কথযামি মনুষ্যাণাং সন্তানা যানি যানি পাপানীশ্ৱৰনিন্দাঞ্চ কুৰ্ৱ্ৱন্তি তেষাং তৎসৰ্ৱ্ৱেষামপৰাধানাং ক্ষমা ভৱিতুং শক্নোতি, ");
INSERT INTO sanasm_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","কিন্তু যঃ কশ্চিৎ পৱিত্ৰমাত্মানং নিন্দতি তস্যাপৰাধস্য ক্ষমা কদাপি ন ভৱিষ্যতি সোনন্তদণ্ডস্যাৰ্হো ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","তস্যাপৱিত্ৰভূতোঽস্তি তেষামেতৎকথাহেতোঃ স ইত্থং কথিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","অথ তস্য মাতা ভ্ৰাতৃগণশ্চাগত্য বহিস্তিষ্ঠনতো লোকান্ প্ৰেষ্য তমাহূতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ততস্তৎসন্নিধৌ সমুপৱিষ্টা লোকাস্তং বভাষিৰে পশ্য বহিস্তৱ মাতা ভ্ৰাতৰশ্চ ৎৱাম্ অন্ৱিচ্ছন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","তদা স তান্ প্ৰত্যুৱাচ মম মাতা কা ভ্ৰাতৰো ৱা কে? ততঃ পৰং স স্ৱমীপোপৱিষ্টান্ শিষ্যান্ প্ৰতি অৱলোকনং কৃৎৱা কথযামাস ");
INSERT INTO sanasm_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","পশ্যতৈতে মম মাতা ভ্ৰাতৰশ্চ| ");
INSERT INTO sanasm_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","যঃ কশ্চিদ্ ঈশ্ৱৰস্যেষ্টাং ক্ৰিযাং কৰোতি স এৱ মম ভ্ৰাতা ভগিনী মাতা চ| ");
INSERT INTO sanasm_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","অনন্তৰং স সমুদ্ৰতটে পুনৰুপদেষ্টুং প্ৰাৰেভে, ততস্তত্ৰ বহুজনানাং সমাগমাৎ স সাগৰোপৰি নৌকামাৰুহ্য সমুপৱিষ্টঃ; সৰ্ৱ্ৱে লোকাঃ সমুদ্ৰকূলে তস্থুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","তদা স দৃষ্টান্তকথাভি ৰ্বহূপদিষ্টৱান্ উপদিশংশ্চ কথিতৱান্, ");
INSERT INTO sanasm_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","অৱধানং কুৰুত, একো বীজৱপ্তা বীজানি ৱপ্তুং গতঃ; ");
INSERT INTO sanasm_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ৱপনকালে কিযন্তি বীজানি মাৰ্গপাশ্ৱে পতিতানি, তত আকাশীযপক্ষিণ এত্য তানি চখাদুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","কিযন্তি বীজানি স্ৱল্পমৃত্তিকাৱৎপাষাণভূমৌ পতিতানি তানি মৃদোল্পৎৱাৎ শীঘ্ৰমঙ্কুৰিতানি; ");
INSERT INTO sanasm_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","কিন্তূদিতে সূৰ্য্যে দগ্ধানি তথা মূলানো নাধোগতৎৱাৎ শুষ্কাণি চ| ");
INSERT INTO sanasm_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","কিযন্তি বীজানি কণ্টকিৱনমধ্যে পতিতানি ততঃ কণ্টকানি সংৱৃদ্ৱ্য তানি জগ্ৰসুস্তানি ন চ ফলিতানি| ");
INSERT INTO sanasm_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","তথা কিযন্তি বীজান্যুত্তমভূমৌ পতিতানি তানি সংৱৃদ্ৱ্য ফলান্যুৎপাদিতানি কিযন্তি বীজানি ত্ৰিংশদ্গুণানি কিযন্তি ষষ্টিগুণানি কিযন্তি শতগুণানি ফলানি ফলিতৱন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","অথ স তানৱদৎ যস্য শ্ৰোতুং কৰ্ণৌ স্তঃ স শৃণোতু| ");
INSERT INTO sanasm_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","তদনন্তৰং নিৰ্জনসমযে তৎসঙ্গিনো দ্ৱাদশশিষ্যাশ্চ তং তদ্দৃষ্টান্তৱাক্যস্যাৰ্থং পপ্ৰচ্ছুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","তদা স তানুদিতৱান্ ঈশ্ৱৰৰাজ্যস্য নিগূঢৱাক্যং বোদ্ধুং যুষ্মাকমধিকাৰোঽস্তি; ");
INSERT INTO sanasm_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","কিন্তু যে ৱহিৰ্ভূতাঃ \"তে পশ্যন্তঃ পশ্যন্তি কিন্তু ন জানন্তি, শৃণ্ৱন্তঃ শৃণ্ৱন্তি কিন্তু ন বুধ্যন্তে, চেত্তৈ ৰ্মনঃসু কদাপি পৰিৱৰ্ত্তিতেষু তেষাং পাপান্যমোচযিষ্যন্ত,\" অতোহেতোস্তান্ প্ৰতি দৃষ্টান্তৈৰেৱ তানি মযা কথিতানি| ");
INSERT INTO sanasm_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","অথ স কথিতৱান্ যূযং কিমেতদ্ দৃষ্টান্তৱাক্যং ন বুধ্যধ্ৱে? তৰ্হি কথং সৰ্ৱ্ৱান্ দৃষ্টান্তান ভোৎস্যধ্ৱে? ");
INSERT INTO sanasm_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","বীজৱপ্তা ৱাক্যৰূপাণি বীজানি ৱপতি; ");
INSERT INTO sanasm_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","তত্ৰ যে যে লোকা ৱাক্যং শৃণ্ৱন্তি, কিন্তু শ্ৰুতমাত্ৰাৎ শৈতান্ শীঘ্ৰমাগত্য তেষাং মনঃসূপ্তানি তানি ৱাক্যৰূপাণি বীজান্যপনযতি তএৱ উপ্তবীজমাৰ্গপাৰ্শ্ৱেস্ৱৰূপাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","যে জনা ৱাক্যং শ্ৰুৎৱা সহসা পৰমানন্দেন গৃহ্লন্তি, কিন্তু হৃদি স্থৈৰ্য্যাভাৱাৎ কিঞ্চিৎ কালমাত্ৰং তিষ্ঠন্তি তৎপশ্চাৎ তদ্ৱাক্যহেতোঃ ");
INSERT INTO sanasm_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","কুত্ৰচিৎ ক্লেশে উপদ্ৰৱে ৱা সমুপস্থিতে তদৈৱ ৱিঘ্নং প্ৰাপ্নুৱন্তি তএৱ উপ্তবীজপাষাণভূমিস্ৱৰূপাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","যে জনাঃ কথাং শৃণ্ৱন্তি কিন্তু সাংসাৰিকী চিন্তা ধনভ্ৰান্তি ৰ্ৱিষযলোভশ্চ এতে সৰ্ৱ্ৱে উপস্থায তাং কথাং গ্ৰসন্তি ততঃ মা ৱিফলা ভৱতি ");
INSERT INTO sanasm_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","তএৱ উপ্তবীজসকণ্টকভূমিস্ৱৰূপাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","যে জনা ৱাক্যং শ্ৰুৎৱা গৃহ্লন্তি তেষাং কস্য ৱা ত্ৰিংশদ্গুণানি কস্য ৱা ষষ্টিগুণানি কস্য ৱা শতগুণানি ফলানি ভৱন্তি তএৱ উপ্তবীজোৰ্ৱ্ৱৰভূমিস্ৱৰূপাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","তদা সোঽপৰমপি কথিতৱান্ কোপি জনো দীপাধাৰং পৰিত্যজ্য দ্ৰোণস্যাধঃ খট্ৱাযা অধে ৱা স্থাপযিতুং দীপমানযতি কিং? ");
INSERT INTO sanasm_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","অতোহেতো ৰ্যন্ন প্ৰকাশযিষ্যতে তাদৃগ্ লুক্কাযিতং কিমপি ৱস্তু নাস্তি; যদ্ ৱ্যক্তং ন ভৱিষ্যতি তাদৃশং গুপ্তং কিমপি ৱস্তু নাস্তি| ");
INSERT INTO sanasm_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","যস্য শ্ৰোতুং কৰ্ণৌ স্তঃ স শৃণোতু| ");
INSERT INTO sanasm_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","অপৰমপি কথিতৱান্ যূযং যদ্ যদ্ ৱাক্যং শৃণুথ তত্ৰ সাৱধানা ভৱত, যতো যূযং যেন পৰিমাণেন পৰিমাথ তেনৈৱ পৰিমাণেন যুষ্মদৰ্থমপি পৰিমাস্যতে; শ্ৰোতাৰো যূযং যুষ্মভ্যমধিকং দাস্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","যস্যাশ্ৰযে ৱৰ্দ্ধতে তস্মৈ অপৰমপি দাস্যতে, কিন্তু যস্যাশ্ৰযে ন ৱৰ্দ্ধতে তস্য যৎ কিঞ্চিদস্তি তদপি তস্মান্ নেষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","অনন্তৰং স কথিতৱান্ একো লোকঃ ক্ষেত্ৰে বীজান্যুপ্ত্ৱা ");
INSERT INTO sanasm_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","জাগৰণনিদ্ৰাভ্যাং দিৱানিশং গমযতি, পৰন্তু তদ্ৱীজং তস্যাজ্ঞাতৰূপেণাঙ্কুৰযতি ৱৰ্দ্ধতে চ; ");
INSERT INTO sanasm_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","যতোহেতোঃ প্ৰথমতঃ পত্ৰাণি ততঃ পৰং কণিশানি তৎপশ্চাৎ কণিশপূৰ্ণানি শস্যানি ভূমিঃ স্ৱযমুৎপাদযতি; ");
INSERT INTO sanasm_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","কিন্তু ফলেষু পক্কেষু শস্যচ্ছেদনকালং জ্ঞাৎৱা স তৎক্ষণং শস্যানি ছিনত্তি, অনেন তুল্যমীশ্ৱৰৰাজ্যং| ");
INSERT INTO sanasm_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","পুনঃ সোঽকথযদ্ ঈশ্ৱৰৰাজ্যং কেন সমং? কেন ৱস্তুনা সহ ৱা তদুপমাস্যামি? ");
INSERT INTO sanasm_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","তৎ সৰ্ষপৈকেন তুল্যং যতো মৃদি ৱপনকালে সৰ্ষপবীজং সৰ্ৱ্ৱপৃথিৱীস্থবীজাৎ ক্ষুদ্ৰং ");
INSERT INTO sanasm_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","কিন্তু ৱপনাৎ পৰম্ অঙ্কুৰযিৎৱা সৰ্ৱ্ৱশাকাদ্ বৃহদ্ ভৱতি, তস্য বৃহত্যঃ শাখাশ্চ জাযন্তে ততস্তচ্ছাযাং পক্ষিণ আশ্ৰযন্তে| ");
INSERT INTO sanasm_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ইত্থং তেষাং বোধানুৰূপং সোঽনেকদৃষ্টান্তৈস্তানুপদিষ্টৱান্, ");
INSERT INTO sanasm_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","দৃষ্টান্তং ৱিনা কামপি কথাং তেভ্যো ন কথিতৱান্ পশ্চান্ নিৰ্জনে স শিষ্যান্ সৰ্ৱ্ৱদৃষ্টান্তাৰ্থং বোধিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","তদ্দিনস্য সন্ধ্যাযাং স তেভ্যোঽকথযদ্ আগচ্ছত ৱযং পাৰং যাম| ");
INSERT INTO sanasm_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","তদা তে লোকান্ ৱিসৃজ্য তমৱিলম্বং গৃহীৎৱা নৌকযা প্ৰতস্থিৰে; অপৰা অপি নাৱস্তযা সহ স্থিতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ততঃ পৰং মহাঝঞ্ভ্শগমাৎ নৌ ৰ্দোলাযমানা তৰঙ্গেণ জলৈঃ পূৰ্ণাভৱচ্চ| ");
INSERT INTO sanasm_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","তদা স নৌকাচশ্চাদ্ভাগে উপধানে শিৰো নিধায নিদ্ৰিত আসীৎ ততস্তে তং জাগৰযিৎৱা জগদুঃ, হে প্ৰভো, অস্মাকং প্ৰাণা যান্তি কিমত্ৰ ভৱতশ্চিন্তা নাস্তি? ");
INSERT INTO sanasm_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","তদা স উত্থায ৱাযুং তৰ্জিতৱান্ সমুদ্ৰঞ্চোক্তৱান্ শান্তঃ সুস্থিৰশ্চ ভৱ; ততো ৱাযৌ নিৱৃত্তেঽব্ধিৰ্নিস্তৰঙ্গোভূৎ| ");
INSERT INTO sanasm_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","তদা স তানুৱাচ যূযং কুত এতাদৃক্শঙ্কাকুলা ভৱত? কিং ৱো ৱিশ্ৱাসো নাস্তি? ");
INSERT INTO sanasm_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","তস্মাত্তেঽতীৱভীতাঃ পৰস্পৰং ৱক্তুমাৰেভিৰে, অহো ৱাযুঃ সিন্ধুশ্চাস্য নিদেশগ্ৰাহিণৌ কীদৃগযং মনুজঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","অথ তূ সিন্ধুপাৰং গৎৱা গিদেৰীযপ্ৰদেশ উপতস্থুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","নৌকাতো নিৰ্গতমাত্ৰাদ্ অপৱিত্ৰভূতগ্ৰস্ত একঃ শ্মশানাদেত্য তং সাক্ষাচ্ চকাৰ| ");
INSERT INTO sanasm_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","স শ্মশানেঽৱাৎসীৎ কোপি তং শৃঙ্খলেন বদ্ৱ্ৱা স্থাপযিতুং নাশক্নোৎ| ");
INSERT INTO sanasm_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","জনৈৰ্ৱাৰং নিগডৈঃ শৃঙ্খলৈশ্চ স বদ্ধোপি শৃঙ্খলান্যাকৃষ্য মোচিতৱান্ নিগডানি চ ভংক্ত্ৱা খণ্ডং খণ্ডং কৃতৱান্ কোপি তং ৱশীকৰ্ত্তুং ন শশক| ");
INSERT INTO sanasm_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","দিৱানিশং সদা পৰ্ৱ্ৱতং শ্মশানঞ্চ ভ্ৰমিৎৱা চীৎশব্দং কৃতৱান্ গ্ৰাৱভিশ্চ স্ৱযং স্ৱং কৃতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","স যীশুং দূৰাৎ পশ্যন্নেৱ ধাৱন্ তং প্ৰণনাম উচৈৰুৱংশ্চোৱাচ, ");
INSERT INTO sanasm_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","হে সৰ্ৱ্ৱোপৰিস্থেশ্ৱৰপুত্ৰ যীশো ভৱতা সহ মে কঃ সম্বন্ধঃ? অহং ৎৱামীশ্ৱৰেণ শাপযে মাং মা যাতয| ");
INSERT INTO sanasm_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","যতো যীশুস্তং কথিতৱান্ ৰে অপৱিত্ৰভূত, অস্মান্নৰাদ্ বহিৰ্নিৰ্গচ্ছ| ");
INSERT INTO sanasm_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","অথ স তং পৃষ্টৱান্ কিন্তে নাম? তেন প্ৰত্যুক্তং ৱযমনেকে ঽস্মস্ততোঽস্মন্নাম বাহিনী| ");
INSERT INTO sanasm_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ততোস্মান্ দেশান্ন প্ৰেষযেতি তে তং প্ৰাৰ্থযন্ত| ");
INSERT INTO sanasm_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","তদানীং পৰ্ৱ্ৱতং নিকষা বৃহন্ ৱৰাহৱ্ৰজশ্চৰন্নাসীৎ| ");
INSERT INTO sanasm_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","তস্মাদ্ ভূতা ৱিনযেন জগদুঃ, অমুং ৱৰাহৱ্ৰজম্ আশ্ৰযিতুম্ অস্মান্ প্ৰহিণু| ");
INSERT INTO sanasm_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","যীশুনানুজ্ঞাতাস্তেঽপৱিত্ৰভূতা বহিৰ্নিৰ্যায ৱৰাহৱ্ৰজং প্ৰাৱিশন্ ততঃ সৰ্ৱ্ৱে ৱৰাহা ৱস্তুতস্তু প্ৰাযোদ্ৱিসহস্ৰসংঙ্খ্যকাঃ কটকেন মহাজৱাদ্ ধাৱন্তঃ সিন্ধৌ প্ৰাণান্ জহুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","তস্মাদ্ ৱৰাহপালকাঃ পলাযমানাঃ পুৰে গ্ৰামে চ তদ্ৱাৰ্ত্তং কথযাঞ্চক্ৰুঃ| তদা লোকা ঘটিতং তৎকাৰ্য্যং দ্ৰষ্টুং বহিৰ্জগ্মুঃ ");
INSERT INTO sanasm_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","যীশোঃ সন্নিধিং গৎৱা তং ভূতগ্ৰস্তম্ অৰ্থাদ্ বাহিনীভূতগ্ৰস্তং নৰং সৱস্ত্ৰং সচেতনং সমুপৱিষ্টঞ্চ দৃृষ্ট্ৱা বিভ্যুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ততো দৃষ্টতৎকাৰ্য্যলোকাস্তস্য ভূতগ্ৰস্তনৰস্য ৱৰাহৱ্ৰজস্যাপি তাং ধটনাং ৱৰ্ণযামাসুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ততস্তে স্ৱসীমাতো বহিৰ্গন্তুং যীশুং ৱিনেতুমাৰেভিৰে| ");
INSERT INTO sanasm_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","অথ তস্য নৌকাৰোহণকালে স ভূতমুক্তো না যীশুনা সহ স্থাতুং প্ৰাৰ্থযতে; ");
INSERT INTO sanasm_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","কিন্তু স তমননুমত্য কথিতৱান্ ৎৱং নিজাত্মীযানাং সমীপং গৃহঞ্চ গচ্ছ প্ৰভুস্ত্ৱযি কৃপাং কৃৎৱা যানি কৰ্ম্মাণি কৃতৱান্ তানি তান্ জ্ঞাপয| ");
INSERT INTO sanasm_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","অতঃ স প্ৰস্থায যীশুনা কৃতং তৎসৰ্ৱ্ৱাশ্চৰ্য্যং কৰ্ম্ম দিকাপলিদেশে প্ৰচাৰযিতুং প্ৰাৰব্ধৱান্ ততঃ সৰ্ৱ্ৱে লোকা আশ্চৰ্য্যং মেনিৰে| ");
INSERT INTO sanasm_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","অনন্তৰং যীশৌ নাৱা পুনৰন্যপাৰ উত্তীৰ্ণে সিন্ধুতটে চ তিষ্ঠতি সতি তৎসমীপে বহুলোকানাং সমাগমোঽভূৎ| ");
INSERT INTO sanasm_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","অপৰং যাযীৰ্ নাম্না কশ্চিদ্ ভজনগৃহস্যাধিপ আগত্য তং দৃষ্ট্ৱৈৱ চৰণযোঃ পতিৎৱা বহু নিৱেদ্য কথিতৱান্; ");
INSERT INTO sanasm_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","মম কন্যা মৃতপ্ৰাযাভূদ্ অতো ভৱানেত্য তদাৰোগ্যায তস্যা গাত্ৰে হস্তম্ অৰ্পযতু তেনৈৱ সা জীৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","তদা যীশুস্তেন সহ চলিতঃ কিন্তু তৎপশ্চাদ্ বহুলোকাশ্চলিৎৱা তাদ্গাত্ৰে পতিতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","অথ দ্ৱাদশৱৰ্ষাণি প্ৰদৰৰোগেণ ");
INSERT INTO sanasm_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","শীৰ্ণা চিকিৎসকানাং নানাচিকিৎসাভিশ্চ দুঃখং ভুক্তৱতী চ সৰ্ৱ্ৱস্ৱং ৱ্যযিৎৱাপি নাৰোগ্যং প্ৰাপ্তা চ পুনৰপি পীডিতাসীচ্চ ");
INSERT INTO sanasm_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","যা স্ত্ৰী সা যীশো ৰ্ৱাৰ্ত্তাং প্ৰাপ্য মনসাকথযৎ যদ্যহং তস্য ৱস্ত্ৰমাত্ৰ স্প্ৰষ্টুং লভেযং তদা ৰোগহীনা ভৱিষ্যামি| ");
INSERT INTO sanasm_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","অতোহেতোঃ সা লোকাৰণ্যমধ্যে তৎপশ্চাদাগত্য তস্য ৱস্ত্ৰং পস্পৰ্শ| ");
INSERT INTO sanasm_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","তেনৈৱ তৎক্ষণং তস্যা ৰক্তস্ৰোতঃ শুষ্কং স্ৱযং তস্মাদ্ ৰোগান্মুক্তা ইত্যপি দেহেঽনুভূতা| ");
INSERT INTO sanasm_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","অথ স্ৱস্মাৎ শক্তি ৰ্নিৰ্গতা যীশুৰেতন্মনসা জ্ঞাৎৱা লোকনিৱহং প্ৰতি মুখং ৱ্যাৱৃত্য পৃষ্টৱান্ কেন মদ্ৱস্ত্ৰং স্পৃষ্টং? ");
INSERT INTO sanasm_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ততস্তস্য শিষ্যা ঊচুঃ ভৱতো ৱপুষি লোকাঃ সংঘৰ্ষন্তি তদ্ দৃষ্ট্ৱা কেন মদ্ৱস্ত্ৰং স্পৃষ্টমিতি কুতঃ কথযতি? ");
INSERT INTO sanasm_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","কিন্তু কেন তৎ কৰ্ম্ম কৃতং তদ্ দ্ৰষ্টুং যীশুশ্চতুৰ্দিশো দৃষ্টৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ততঃ সা স্ত্ৰী ভীতা কম্পিতা চ সতী স্ৱস্যা ৰুক্প্ৰতিক্ৰিযা জাতেতি জ্ঞাৎৱাগত্য তৎসম্মুখে পতিৎৱা সৰ্ৱ্ৱৱৃত্তান্তং সত্যং তস্মৈ কথযামাস| ");
INSERT INTO sanasm_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","তদানীং যীশুস্তাং গদিতৱান্, হে কন্যে তৱ প্ৰতীতিস্ত্ৱাম্ অৰোগামকৰোৎ ৎৱং ক্ষেমেণ ৱ্ৰজ স্ৱৰোগান্মুক্তা চ তিষ্ঠ| ");
INSERT INTO sanasm_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ইতিৱাক্যৱদনকালে ভজনগৃহাধিপস্য নিৱেশনাল্ লোকা এত্যাধিপং বভাষিৰে তৱ কন্যা মৃতা তস্মাদ্ গুৰুং পুনঃ কুতঃ ক্লিশ্নাসি? ");
INSERT INTO sanasm_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","কিন্তু যীশুস্তদ্ ৱাক্যং শ্ৰুৎৱৈৱ ভজনগৃহাধিপং গদিতৱান্ মা ভৈষীঃ কেৱলং ৱিশ্ৱাসিহি| ");
INSERT INTO sanasm_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","অথ পিতৰো যাকূব্ তদ্ভ্ৰাতা যোহন্ চ এতান্ ৱিনা কমপি স্ৱপশ্চাদ্ যাতুং নান্ৱমন্যত| ");
INSERT INTO sanasm_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","তস্য ভজনগৃহাধিপস্য নিৱেশনসমীপম্ আগত্য কলহং বহুৰোদনং ৱিলাপঞ্চ কুৰ্ৱ্ৱতো লোকান্ দদৰ্শ| ");
INSERT INTO sanasm_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","তস্মান্ নিৱেশনং প্ৰৱিশ্য প্ৰোক্তৱান্ যূযং কুত ইত্থং কলহং ৰোদনঞ্চ কুৰুথ? কন্যা ন মৃতা নিদ্ৰাতি| ");
INSERT INTO sanasm_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","তস্মাত্তে তমুপজহসুঃ কিন্তু যীশুঃ সৰ্ৱ্ৱান বহিষ্কৃত্য কন্যাযাঃ পিতৰৌ স্ৱসঙ্গিনশ্চ গৃহীৎৱা যত্ৰ কন্যাসীৎ তৎ স্থানং প্ৰৱিষ্টৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","অথ স তস্যাঃ কন্যাযা হস্তৌ ধৃৎৱা তাং বভাষে টালীথা কূমী, অৰ্থতো হে কন্যে ৎৱমুত্তিষ্ঠ ইত্যাজ্ঞাপযামি| ");
INSERT INTO sanasm_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","তুনৈৱ তৎক্ষণং সা দ্ৱাদশৱৰ্ষৱযস্কা কন্যা পোত্থায চলিতুমাৰেভে, ইতঃ সৰ্ৱ্ৱে মহাৱিস্মযং গতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","তত এতস্যৈ কিঞ্চিৎ খাদ্যং দত্তেতি কথযিৎৱা এতৎকৰ্ম্ম কমপি ন জ্ঞাপযতেতি দৃঢমাদিষ্টৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","অনন্তৰং স তৎস্থানাৎ প্ৰস্থায স্ৱপ্ৰদেশমাগতঃ শিষ্যাশ্চ তৎপশ্চাদ্ গতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","অথ ৱিশ্ৰামৱাৰে সতি স ভজনগৃহে উপদেষ্টুমাৰব্ধৱান্ ততোঽনেকে লোকাস্তৎকথাং শ্ৰুৎৱা ৱিস্মিত্য জগদুঃ, অস্য মনুজস্য ঈদৃশী আশ্চৰ্য্যক্ৰিযা কস্মাজ্ জাতা? তথা স্ৱকৰাভ্যাম্ ইত্থমদ্ভুতং কৰ্ম্ম কৰ্ত্তাुম্ এতস্মৈ কথং জ্ঞানং দত্তম্? ");
INSERT INTO sanasm_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","কিমযং মৰিযমঃ পুত্ৰস্তজ্ঞা নো? কিমযং যাকূব্-যোসি-যিহুদা-শিমোনাং ভ্ৰাতা নো? অস্য ভগিন্যঃ কিমিহাস্মাভিঃ সহ নো? ইত্থং তে তদৰ্থে প্ৰত্যূহং গতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","তদা যীশুস্তেভ্যোঽকথযৎ স্ৱদেশং স্ৱকুটুম্বান্ স্ৱপৰিজনাংশ্চ ৱিনা কুত্ৰাপি ভৱিষ্যদ্ৱাদী অসৎকৃতো ন ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","অপৰঞ্চ তেষামপ্ৰত্যযাৎ স ৱিস্মিতঃ কিযতাং ৰোগিণাং ৱপুঃষু হস্তম্ অৰ্পযিৎৱা কেৱলং তেষামাৰোগ্যকৰণাদ্ অন্যৎ কিমপি চিত্ৰকাৰ্য্যং কৰ্ত্তাং ন শক্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","অথ স চতুৰ্দিক্স্থ গ্ৰামান্ ভ্ৰমিৎৱা উপদিষ্টৱান্ ");
INSERT INTO sanasm_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","দ্ৱাদশশিষ্যান্ আহূয অমেধ্যভূতান্ ৱশীকৰ্ত্তাং শক্তিং দত্ত্ৱা তেষাং দ্ৱৌ দ্ৱৌ জনো প্ৰেষিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","পুনৰিত্যাদিশদ্ যূযম্ একৈকাং যষ্টিং ৱিনা ৱস্ত্ৰসংপুটঃ পূপঃ কটিবন্ধে তাম্ৰখণ্ডঞ্চ এষাং কিমপি মা গ্ৰহ্লীত, ");
INSERT INTO sanasm_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","মাৰ্গযাত্ৰাযৈ পাদেষূপানহৌ দত্ত্ৱা দ্ৱে উত্তৰীযে মা পৰিধদ্ৱ্ৱং| ");
INSERT INTO sanasm_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","অপৰমপ্যুক্তং তেন যূযং যস্যাং পুৰ্য্যাং যস্য নিৱেশনং প্ৰৱেক্ষ্যথ তাং পুৰীং যাৱন্ন ত্যক্ষ্যথ তাৱৎ তন্নিৱেশনে স্থাস্যথ| ");
INSERT INTO sanasm_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","তত্ৰ যদি কেপি যুষ্মাকমাতিথ্যং ন ৱিদধতি যুষ্মাকং কথাশ্চ ন শৃণ্ৱন্তি তৰ্হি তৎস্থানাৎ প্ৰস্থানসমযে তেষাং ৱিৰুদ্ধং সাক্ষ্যং দাতুং স্ৱপাদানাস্ফাল্য ৰজঃ সম্পাতযত; অহং যুষ্মান্ যথাৰ্থং ৱচ্মি ৱিচাৰদিনে তন্নগৰস্যাৱস্থাতঃ সিদোমামোৰযো ৰ্নগৰযোৰৱস্থা সহ্যতৰা ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","অথ তে গৎৱা লোকানাং মনঃপৰাৱৰ্ত্তনীঃ কথা প্ৰচাৰিতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","এৱমনেকান্ ভূতাংশ্চ ত্যাজিতৱন্তস্তথা তৈলেন মৰ্দ্দযিৎৱা বহূন্ জনানৰোগানকাৰ্ষুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ইত্থং তস্য সুখ্যাতিশ্চতুৰ্দিশো ৱ্যাপ্তা তদা হেৰোদ্ ৰাজা তন্নিশম্য কথিতৱান্, যোহন্ মজ্জকঃ শ্মশানাদ্ উত্থিত অতোহেতোস্তেন সৰ্ৱ্ৱা এতা অদ্ভুতক্ৰিযাঃ প্ৰকাশন্তে| ");
INSERT INTO sanasm_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","অন্যেঽকথযন্ অযম্ এলিযঃ, কেপি কথিতৱন্ত এষ ভৱিষ্যদ্ৱাদী যদ্ৱা ভৱিষ্যদ্ৱাদিনাং সদৃশ একোযম্| ");
INSERT INTO sanasm_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","কিন্তু হেৰোদ্ ইত্যাকৰ্ণ্য ভাষিতৱান্ যস্যাহং শিৰশ্ছিন্নৱান্ স এৱ যোহনযং স শ্মশানাদুদতিষ্ঠৎ| ");
INSERT INTO sanasm_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","পূৰ্ৱ্ৱং স্ৱভ্ৰাতুঃ ফিলিপস্য পত্ন্যা উদ্ৱাহং কৃতৱন্তং হেৰোদং যোহনৱাদীৎ স্ৱভাতৃৱধূ ৰ্ন ৱিৱাহ্যা| ");
INSERT INTO sanasm_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","অতঃ কাৰণাৎ হেৰোদ্ লোকং প্ৰহিত্য যোহনং ধৃৎৱা বন্ধনালযে বদ্ধৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","হেৰোদিযা তস্মৈ যোহনে প্ৰকুপ্য তং হন্তুম্ ঐচ্ছৎ কিন্তু ন শক্তা, ");
INSERT INTO sanasm_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","যস্মাদ্ হেৰোদ্ তং ধাৰ্ম্মিকং সৎপুৰুষঞ্চ জ্ঞাৎৱা সম্মন্য ৰক্ষিতৱান্; তৎকথাং শ্ৰুৎৱা তদনুসাৰেণ বহূনি কৰ্ম্মাণি কৃতৱান্ হৃষ্টমনাস্তদুপদেশং শ্ৰুতৱাংশ্চ| ");
INSERT INTO sanasm_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","কিন্তু হেৰোদ্ যদা স্ৱজন্মদিনে প্ৰধানলোকেভ্যঃ সেনানীভ্যশ্চ গালীল্প্ৰদেশীযশ্ৰেষ্ঠলোকেভ্যশ্চ ৰাত্ৰৌ ভোজ্যমেকং কৃতৱান্ ");
INSERT INTO sanasm_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","তস্মিন্ শুভদিনে হেৰোদিযাযাঃ কন্যা সমেত্য তেষাং সমক্ষং সংনৃত্য হেৰোদস্তেন সহোপৱিষ্টানাঞ্চ তোষমজীজনৎ ততা নৃপঃ কন্যামাহ স্ম মত্তো যদ্ যাচসে তদেৱ তুভ্যং দাস্যে| ");
INSERT INTO sanasm_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","শপথং কৃৎৱাকথযৎ চেদ্ ৰাজ্যাৰ্দ্ধমপি যাচসে তদপি তুভ্যং দাস্যে| ");
INSERT INTO sanasm_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ততঃ সা বহি ৰ্গৎৱা স্ৱমাতৰং পপ্ৰচ্ছ কিমহং যাচিষ্যে? তদা সাকথযৎ যোহনো মজ্জকস্য শিৰঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","অথ তূৰ্ণং ভূপসমীপম্ এত্য যাচমানাৱদৎ ক্ষণেস্মিন্ যোহনো মজ্জকস্য শিৰঃ পাত্ৰে নিধায দেহি, এতদ্ যাচেঽহং| ");
INSERT INTO sanasm_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","তস্মাৎ ভূপোঽতিদুঃখিতঃ, তথাপি স্ৱশপথস্য সহভোজিনাঞ্চানুৰোধাৎ তদনঙ্গীকৰ্ত্তুং ন শক্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","তৎক্ষণং ৰাজা ঘাতকং প্ৰেষ্য তস্য শিৰ আনেতুমাদিষ্টৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ততঃ স কাৰাগাৰং গৎৱা তচ্ছিৰশ্ছিৎৱা পাত্ৰে নিধাযানীয তস্যৈ কন্যাযৈ দত্তৱান্ কন্যা চ স্ৱমাত্ৰে দদৌ| ");
INSERT INTO sanasm_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","অননতৰং যোহনঃ শিষ্যাস্তদ্ৱাৰ্ত্তাং প্ৰাপ্যাগত্য তস্য কুণপং শ্মশানেঽস্থাপযন্| ");
INSERT INTO sanasm_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","অথ প্ৰেষিতা যীশোঃ সন্নিধৌ মিলিতা যদ্ যচ্ চক্ৰুঃ শিক্ষযামাসুশ্চ তৎসৰ্ৱ্ৱৱাৰ্ত্তাস্তস্মৈ কথিতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","স তানুৱাচ যূযং ৱিজনস্থানং গৎৱা ৱিশ্ৰাম্যত যতস্তৎসন্নিধৌ বহুলোকানাং সমাগমাৎ তে ভোক্তুং নাৱকাশং প্ৰাপ্তাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ততস্তে নাৱা ৱিজনস্থানং গুপ্তং গগ্মুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ততো লোকনিৱহস্তেষাং স্থানান্তৰযানং দদৰ্শ, অনেকে তং পৰিচিত্য নানাপুৰেভ্যঃ পদৈৰ্ৱ্ৰজিৎৱা জৱেন তৈষামগ্ৰে যীশোঃ সমীপ উপতস্থুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","তদা যীশু ৰ্নাৱো বহিৰ্গত্য লোকাৰণ্যানীং দৃষ্ট্ৱা তেষু কৰুণাং কৃতৱান্ যতস্তেঽৰক্ষকমেষা ইৱাসন্ তদা স তান নানাপ্ৰসঙ্গান্ উপদিষ্টৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","অথ দিৱান্তে সতি শিষ্যা এত্য যীশুমূচিৰে, ইদং ৱিজনস্থানং দিনঞ্চাৱসন্নং| ");
INSERT INTO sanasm_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","লোকানাং কিমপি খাদ্যং নাস্তি, অতশ্চতুৰ্দিক্ষু গ্ৰামান্ গন্তুং ভোজ্যদ্ৰৱ্যাণি ক্ৰেতুঞ্চ ভৱান্ তান্ ৱিসৃজতু| ");
INSERT INTO sanasm_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","তদা স তানুৱাচ যূযমেৱ তান্ ভোজযত; ততস্তে জগদু ৰ্ৱযং গৎৱা দ্ৱিশতসংখ্যকৈ ৰ্মুদ্ৰাপাদৈঃ পূপান্ ক্ৰীৎৱা কিং তান্ ভোজযিষ্যামঃ? ");
INSERT INTO sanasm_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","তদা স তান্ পৃষ্ঠৱান্ যুষ্মাকং সন্নিধৌ কতি পূপা আসতে? গৎৱা পশ্যত; ততস্তে দৃষ্ট্ৱা তমৱদন্ পঞ্চ পূপা দ্ৱৌ মৎস্যৌ চ সন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","তদা স লোকান্ শস্পোপৰি পংক্তিভিৰুপৱেশযিতুম্ আদিষ্টৱান্, ");
INSERT INTO sanasm_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ততস্তে শতং শতং জনাঃ পঞ্চাশৎ পঞ্চাশজ্জনাশ্চ পংক্তিভি ৰ্ভুৱি সমুপৱিৱিশুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","অথ স তান্ পঞ্চপূপান্ মৎস্যদ্ৱযঞ্চ ধৃৎৱা স্ৱৰ্গং পশ্যন্ ঈশ্ৱৰগুণান্ অন্ৱকীৰ্ত্তযৎ তান্ পূপান্ ভংক্ত্ৱা লোকেভ্যঃ পৰিৱেষযিতুং শিষ্যেভ্যো দত্তৱান্ দ্ৱা মৎস্যৌ চ ৱিভজ্য সৰ্ৱ্ৱেভ্যো দত্তৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ততঃ সৰ্ৱ্ৱে ভুক্ত্ৱাতৃপ্যন্| ");
INSERT INTO sanasm_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","অনন্তৰং শিষ্যা অৱশিষ্টৈঃ পূপৈ ৰ্মৎস্যৈশ্চ পূৰ্ণান্ দ্ৱদশ ডল্লকান্ জগৃহুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","তে ভোক্তাৰঃ প্ৰাযঃ পঞ্চ সহস্ৰাণি পুৰুষা আসন্| ");
INSERT INTO sanasm_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","অথ স লোকান্ ৱিসৃজন্নেৱ নাৱমাৰোঢুং স্ৱস্মাদগ্ৰে পাৰে বৈৎসৈদাপুৰং যাতুঞ্চ শ্ষ্যিाন্ ৱাঢমাদিষ্টৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","তদা স সৰ্ৱ্ৱান্ ৱিসৃজ্য প্ৰাৰ্থযিতুং পৰ্ৱ্ৱতং গতঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ততঃ সন্ধ্যাযাং সত্যাং নৌঃ সিন্ধুমধ্য উপস্থিতা কিন্তু স একাকী স্থলে স্থিতঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","অথ সম্মুখৱাতৱহনাৎ শিষ্যা নাৱং ৱাহযিৎৱা পৰিশ্ৰান্তা ইতি জ্ঞাৎৱা স নিশাচতুৰ্থযামে সিন্ধূপৰি পদ্ভ্যাং ৱ্ৰজন্ তেষাং সমীপমেত্য তেষামগ্ৰে যাতুম্ উদ্যতঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","কিন্তু শিষ্যাঃ সিন্ধূপৰি তং ৱ্ৰজন্তং দৃষ্ট্ৱা ভূতমনুমায ৰুৰুৱুঃ, ");
INSERT INTO sanasm_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","যতঃ সৰ্ৱ্ৱে তং দৃষ্ট্ৱা ৱ্যাকুলিতাঃ| অতএৱ যীশুস্তৎক্ষণং তৈঃ সহালপ্য কথিতৱান্, সুস্থিৰা ভূত, অযমহং মা ভৈষ্ট| ");
INSERT INTO sanasm_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","অথ নৌকামাৰুহ্য তস্মিন্ তেষাং সন্নিধিং গতে ৱাতো নিৱৃত্তঃ; তস্মাত্তে মনঃসু ৱিস্মিতা আশ্চৰ্য্যং মেনিৰে| ");
INSERT INTO sanasm_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","যতস্তে মনসাং কাঠিন্যাৎ তৎ পূপীযম্ আশ্চৰ্য্যং কৰ্ম্ম ন ৱিৱিক্তৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","অথ তে পাৰং গৎৱা গিনেষৰৎপ্ৰদেশমেত্য তট উপস্থিতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","তেষু নৌকাতো বহিৰ্গতেষু তৎপ্ৰদেশীযা লোকাস্তং পৰিচিত্য ");
INSERT INTO sanasm_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","চতুৰ্দিক্ষু ধাৱন্তো যত্ৰ যত্ৰ ৰোগিণো নৰা আসন্ তান্ সৰ্ৱ্ৱান খট্ৱোপৰি নিধায যত্ৰ কুত্ৰচিৎ তদ্ৱাৰ্ত্তাং প্ৰাপুঃ তৎ স্থানম্ আনেতুম্ আৰেভিৰে| ");
INSERT INTO sanasm_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","তথা যত্ৰ যত্ৰ গ্ৰামে যত্ৰ যত্ৰ পুৰে যত্ৰ যত্ৰ পল্ল্যাঞ্চ তেন প্ৰৱেশঃ কৃতস্তদ্ৱৰ্ত্মমধ্যে লোকাঃ পীডিতান্ স্থাপযিৎৱা তস্য চেলগ্ৰন্থিমাত্ৰং স্প্ৰষ্টুম্ তেষামৰ্থে তদনুজ্ঞাং প্ৰাৰ্থযন্তঃ যাৱন্তো লোকাঃ পস্পৃশুস্তাৱন্ত এৱ গদান্মুক্তাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","অনন্তৰং যিৰূশালম আগতাঃ ফিৰূশিনোঽধ্যাপকাশ্চ যীশোঃ সমীপম্ আগতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","তে তস্য কিযতঃ শিষ্যান্ অশুচিকৰৈৰৰ্থাদ অপ্ৰক্ষালিতহস্তৈ ৰ্ভুঞ্জতো দৃষ্ট্ৱা তানদূষযন্| ");
INSERT INTO sanasm_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","যতঃ ফিৰূশিনঃ সৰ্ৱ্ৱযিহূদীযাশ্চ প্ৰাচাং পৰম্পৰাগতৱাক্যং সম্মন্য প্ৰতলেন হস্তান্ অপ্ৰক্ষাল্য ন ভুঞ্জতে| ");
INSERT INTO sanasm_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","আপনাদাগত্য মজ্জনং ৱিনা ন খাদন্তি; তথা পানপাত্ৰাণাং জলপাত্ৰাণাং পিত্তলপাত্ৰাণাম্ আসনানাঞ্চ জলে মজ্জনম্ ইত্যাদযোন্যেপি বহৱস্তেষামাচাৰাঃ সন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","তে ফিৰূশিনোঽধ্যাপকাশ্চ যীশুং পপ্ৰচ্ছুঃ, তৱ শিষ্যাঃ প্ৰাচাং পৰম্পৰাগতৱাক্যানুসাৰেণ নাচৰন্তোঽপ্ৰক্ষালিতকৰৈঃ কুতো ভুজংতে? ");
INSERT INTO sanasm_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ততঃ স প্ৰত্যুৱাচ কপটিনো যুষ্মান্ উদ্দিশ্য যিশযিযভৱিষ্যদ্ৱাদী যুক্তমৱাদীৎ| যথা স্ৱকীযৈৰধৰৈৰেতে সম্মন্যনতে সদৈৱ মাং| কিন্তু মত্তো ৱিপ্ৰকৰ্ষে সন্তি তেষাং মনাংসি চ| ");
INSERT INTO sanasm_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","শিক্ষযন্তো বিধীন্ ন্নাজ্ঞা ভজন্তে মাং মুধৈৱ তে| ");
INSERT INTO sanasm_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","যূযং জলপাত্ৰপানপাত্ৰাদীনি মজ্জযন্তো মনুজপৰম্পৰাগতৱাক্যং ৰক্ষথ কিন্তু ঈশ্ৱৰাজ্ঞাং লংঘধ্ৱে; অপৰা ঈদৃশ্যোনেকাঃ ক্ৰিযা অপি কুৰুধ্ৱে| ");
INSERT INTO sanasm_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","অন্যঞ্চাকথযৎ যূযং স্ৱপৰম্পৰাগতৱাক্যস্য ৰক্ষাৰ্থং স্পষ্টৰূপেণ ঈশ্ৱৰাজ্ঞাং লোপযথ| ");
INSERT INTO sanasm_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","যতো মূসাদ্ৱাৰা প্ৰোক্তমস্তি স্ৱপিতৰৌ সম্মন্যধ্ৱং যস্তু মাতৰং পিতৰং ৱা দুৰ্ৱ্ৱাক্যং ৱক্তি স নিতান্তং হন্যতাং| ");
INSERT INTO sanasm_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","কিন্তু মদীযেন যেন দ্ৰৱ্যেণ তৱোপকাৰোভৱৎ তৎ কৰ্ব্বাণমৰ্থাদ্ ঈশ্ৱৰায নিৱেদিতম্ ইদং ৱাক্যং যদি কোপি পিতৰং মাতৰং ৱা ৱক্তি ");
INSERT INTO sanasm_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","তৰ্হি যূযং মাতুঃ পিতু ৰ্ৱোপকাৰং কৰ্ত্তাং তং ৱাৰযথ| ");
INSERT INTO sanasm_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ইত্থং স্ৱপ্ৰচাৰিতপৰম্পৰাগতৱাক্যেন যূযম্ ঈশ্ৱৰাজ্ঞাং মুধা ৱিধদ্ৱ্ৱে, ঈদৃশান্যন্যান্যনেকানি কৰ্ম্মাণি কুৰুধ্ৱে| ");
INSERT INTO sanasm_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","অথ স লোকানাহূয বভাষে যূযং সৰ্ৱ্ৱে মদ্ৱাক্যং শৃণুত বুধ্যধ্ৱঞ্চ| ");
INSERT INTO sanasm_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","বাহ্যাদন্তৰং প্ৰৱিশ্য নৰমমেধ্যং কৰ্ত্তাং শক্নোতি ঈদৃশং কিমপি ৱস্তু নাস্তি, ৱৰম্ অন্তৰাদ্ বহিৰ্গতং যদ্ৱস্তু তন্মনুজম্ অমেধ্যং কৰোতি| ");
INSERT INTO sanasm_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","যস্য শ্ৰোতুং শ্ৰোত্ৰে স্তঃ স শৃণোতু| ");
INSERT INTO sanasm_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","ততঃ স লোকান্ হিৎৱা গৃহমধ্যং প্ৰৱিষ্টস্তদা শিষ্যাস্তদৃষ্টান্তৱাক্যাৰ্থং পপ্ৰচ্ছুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","তস্মাৎ স তান্ জগাদ যূযমপি কিমেতাদৃগবোধাঃ? কিমপি দ্ৰৱ্যং বাহ্যাদন্তৰং প্ৰৱিশ্য নৰমমেধ্যং কৰ্ত্তাং ন শক্নোতি কথামিমাং কিং ন বুধ্যধ্ৱে? ");
INSERT INTO sanasm_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","তৎ তদন্তৰ্ন প্ৰৱিশতি কিন্তু কুক্ষিমধ্যং প্ৰৱিশতি শেষে সৰ্ৱ্ৱভুক্তৱস্তুগ্ৰাহিণি বহিৰ্দেশে নিৰ্যাতি| ");
INSERT INTO sanasm_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","অপৰমপ্যৱাদীদ্ যন্নৰান্নিৰেতি তদেৱ নৰমমেধ্যং কৰোতি| ");
INSERT INTO sanasm_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","যতোঽন্তৰাদ্ অৰ্থান্ মানৱানাং মনোভ্যঃ কুচিন্তা পৰস্ত্ৰীৱেশ্যাগমনং ");
INSERT INTO sanasm_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","নৰৱধশ্চৌৰ্য্যং লোভো দুষ্টতা প্ৰৱঞ্চনা কামুকতা কুদৃষ্টিৰীশ্ৱৰনিন্দা গৰ্ৱ্ৱস্তম ইত্যাদীনি নিৰ্গচ্ছন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","এতানি সৰ্ৱ্ৱাণি দুৰিতান্যন্তৰাদেত্য নৰমমেধ্যং কুৰ্ৱ্ৱন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","অথ স উত্থায তৎস্থানাৎ সোৰসীদোন্পুৰপ্ৰদেশং জগাম তত্ৰ কিমপি নিৱেশনং প্ৰৱিশ্য সৰ্ৱ্ৱৈৰজ্ঞাতঃ স্থাতুং মতিঞ্চক্ৰে কিন্তু গুপ্তঃ স্থাতুং ন শশাক| ");
INSERT INTO sanasm_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","যতঃ সুৰফৈনিকীদেশীযযূনানীৱংশোদ্ভৱস্ত্ৰিযাঃ কন্যা ভূতগ্ৰস্তাসীৎ| সা স্ত্ৰী তদ্ৱাৰ্ত্তাং প্ৰাপ্য তৎসমীপমাগত্য তচ্চৰণযোঃ পতিৎৱা ");
INSERT INTO sanasm_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","স্ৱকন্যাতো ভূতং নিৰাকৰ্ত্তাং তস্মিন্ ৱিনযং কৃতৱতী| ");
INSERT INTO sanasm_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","কিন্তু যীশুস্তামৱদৎ প্ৰথমং বালকাস্তৃপ্যন্তু যতো বালকানাং খাদ্যং গৃহীৎৱা কুক্কুৰেভ্যো নিক্ষেপোঽনুচিতঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","তদা সা স্ত্ৰী তমৱাদীৎ ভোঃ প্ৰভো তৎ সত্যং তথাপি মঞ্চাধঃস্থাঃ কুক্কুৰা বালানাং কৰপতিতানি খাদ্যখণ্ডানি খাদন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ততঃ সোঽকথযদ্ এতৎকথাহেতোঃ সকুশলা যাহি তৱ কন্যাং ত্যক্ত্ৱা ভূতো গতঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","অথ সা স্ত্ৰী গৃহং গৎৱা কন্যাং ভূতত্যক্তাং শয্যাস্থিতাং দদৰ্শ| ");
INSERT INTO sanasm_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","পুনশ্চ স সোৰসীদোন্পুৰপ্ৰদেশাৎ প্ৰস্থায দিকাপলিদেশস্য প্ৰান্তৰভাগেন গালীল্জলধেঃ সমীপং গতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","তদা লোকৈৰেকং বধিৰং কদ্ৱদঞ্চ নৰং তন্নিকটমানীয তস্য গাত্ৰে হস্তমৰ্পযিতুং ৱিনযঃ কৃতঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ততো যীশু ৰ্লোকাৰণ্যাৎ তং নিৰ্জনমানীয তস্য কৰ্ণযোঙ্গুলী ৰ্দদৌ নিষ্ঠীৱং দত্ত্ৱা চ তজ্জিহ্ৱাং পস্পৰ্শ| ");
INSERT INTO sanasm_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","অনন্তৰং স্ৱৰ্গং নিৰীক্ষ্য দীৰ্ঘং নিশ্ৱস্য তমৱদৎ ইতফতঃ অৰ্থান্ মুক্তো ভূযাৎ| ");
INSERT INTO sanasm_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ততস্তৎক্ষণং তস্য কৰ্ণৌ মুক্তৌ জিহ্ৱাযাশ্চ জাড্যাপগমাৎ স সুস্পষ্টৱাক্যমকথযৎ| ");
INSERT INTO sanasm_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","অথ স তান্ ৱাঢমিত্যাদিদেশ যূযমিমাং কথাং কস্মৈচিদপি মা কথযত, কিন্তু স যতি ন্যষেধৎ তে ততি বাহুল্যেন প্ৰাচাৰযন্; ");
INSERT INTO sanasm_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","তেঽতিচমৎকৃত্য পৰস্পৰং কথযামাসুঃ স বধিৰায শ্ৰৱণশক্তিং মূকায চ কথনশক্তিং দত্ত্ৱা সৰ্ৱ্ৱং কৰ্ম্মোত্তমৰূপেণ চকাৰ| ");
INSERT INTO sanasm_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","তদা তৎসমীপং বহৱো লোকা আযাতা অতস্তেষাং ভোজ্যদ্ৰৱ্যাভাৱাদ্ যীশুঃ শিষ্যানাহূয জগাদ,| ");
INSERT INTO sanasm_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","লোকনিৱহে মম কৃপা জাযতে তে দিনত্ৰযং মযা সাৰ্দ্ধং সন্তি তেষাং ভোজ্যং কিমপি নাস্তি| ");
INSERT INTO sanasm_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","তেষাং মধ্যেঽনেকে দূৰাদ্ আগতাঃ, অভুক্তেষু তেষু মযা স্ৱগৃহমভিপ্ৰহিতেষু তে পথি ক্লমিষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","শিষ্যা অৱাদিষুঃ, এতাৱতো লোকান্ তৰ্পযিতুম্ অত্ৰ প্ৰন্তৰে পূপান্ প্ৰাপ্তুং কেন শক্যতে? ");
INSERT INTO sanasm_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ততঃ স তান্ পপ্ৰচ্ছ যুষ্মাকং কতি পূপাঃ সন্তি? তেঽকথযন্ সপ্ত| ");
INSERT INTO sanasm_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","ততঃ স তাল্লোকান্ ভুৱি সমুপৱেষ্টুম্ আদিশ্য তান্ সপ্ত পূপান্ ধৃৎৱা ঈশ্ৱৰগুণান্ অনুকীৰ্ত্তযামাস, ভংক্ত্ৱা পৰিৱেষযিতুং শিষ্যান্ প্ৰতি দদৌ, ততস্তে লোকেভ্যঃ পৰিৱেষযামাসুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","তথা তেষাং সমীপে যে ক্ষুদ্ৰমৎস্যা আসন্ তানপ্যাদায ঈশ্ৱৰগুণান্ সংকীৰ্ত্য পৰিৱেষযিতুম্ আদিষ্টৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ততো লোকা ভুক্ত্ৱা তৃপ্তিং গতা অৱশিষ্টখাদ্যৈঃ পূৰ্ণাঃ সপ্তডল্লকা গৃহীতাশ্চ| ");
INSERT INTO sanasm_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","এতে ভোক্তাৰঃ প্ৰাযশ্চতুঃ সহস্ৰপুৰুষা আসন্ ততঃ স তান্ ৱিসসৰ্জ| ");
INSERT INTO sanasm_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","অথ স শিষ্যঃ সহ নাৱমাৰুহ্য দল্মানূথাসীমামাগতঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ততঃ পৰং ফিৰূশিন আগত্য তেন সহ ৱিৱদমানাস্তস্য পৰীক্ষাৰ্থম্ আকাশীযচিহ্নং দ্ৰষ্টুং যাচিতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","তদা সোঽন্তৰ্দীৰ্ঘং নিশ্ৱস্যাকথযৎ, এতে ৱিদ্যমাননৰাঃ কুতশ্চিন্হং মৃগযন্তে? যুষ্মানহং যথাৰ্থং ব্ৰৱীমি লোকানেতান্ কিমপি চিহ্নং ন দৰ্শযিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","অথ তান্ হিৎৱা পুন ৰ্নাৱম্ আৰুহ্য পাৰমগাৎ| ");
INSERT INTO sanasm_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","এতৰ্হি শিষ্যৈঃ পূপেষু ৱিস্মৃতেষু নাৱি তেষাং সন্নিধৌ পূপ একএৱ স্থিতঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","তদানীং যীশুস্তান্ আদিষ্টৱান্ ফিৰূশিনাং হেৰোদশ্চ কিণ্ৱং প্ৰতি সতৰ্কাঃ সাৱধানাশ্চ ভৱত| ");
INSERT INTO sanasm_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ততস্তেঽন্যোন্যং ৱিৱেচনং কৰ্তুম্ আৰেভিৰে, অস্মাকং সন্নিধৌ পূপো নাস্তীতি হেতোৰিদং কথযতি| ");
INSERT INTO sanasm_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","তদ্ বুদ্ৱ্ৱা যীশুস্তেভ্যোঽকথযৎ যুষ্মাকং স্থানে পূপাভাৱাৎ কুত ইত্থং ৱিতৰ্কযথ? যূযং কিমদ্যাপি কিমপি ন জানীথ? বোদ্ধুঞ্চ ন শক্নুথ? যাৱদদ্য কিং যুষ্মাকং মনাংসি কঠিনানি সন্তি? ");
INSERT INTO sanasm_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","সৎসু নেত্ৰেষু কিং ন পশ্যথ? সৎসু কৰ্ণেষু কিং ন শৃণুথ? ন স্মৰথ চ? ");
INSERT INTO sanasm_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","যদাহং পঞ্চপূপান্ পঞ্চসহস্ৰাণাং পুৰুষাণাং মধ্যে ভংক্ত্ৱা দত্তৱান্ তদানীং যূযম্ অৱশিষ্টপূপৈঃ পূৰ্ণান্ কতি ডল্লকান্ গৃহীতৱন্তঃ? তেঽকথযন্ দ্ৱাদশডল্লকান্| ");
INSERT INTO sanasm_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","অপৰঞ্চ যদা চতুঃসহস্ৰাণাং পুৰুষাণাং মধ্যে পূপান্ ভংক্ত্ৱাদদাং তদা যূযম্ অতিৰিক্তপূপানাং কতি ডল্লকান্ গৃহীতৱন্তঃ? তে কথযামাসুঃ সপ্তডল্লকান্| ");
INSERT INTO sanasm_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","তদা স কথিতৱান্ তৰ্হি যূযম্ অধুনাপি কুতো বোদ্ৱ্ৱুং ন শক্নুথ? ");
INSERT INTO sanasm_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","অনন্তৰং তস্মিন্ বৈৎসৈদানগৰে প্ৰাপ্তে লোকা অন্ধমেকং নৰং তৎসমীপমানীয তং স্প্ৰষ্টুং তং প্ৰাৰ্থযাঞ্চক্ৰিৰে| ");
INSERT INTO sanasm_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","তদা তস্যান্ধস্য কৰৌ গৃহীৎৱা নগৰাদ্ বহিৰ্দেশং তং নীতৱান্; তন্নেত্ৰে নিষ্ঠীৱং দত্ত্ৱা তদ্গাত্ৰে হস্তাৱৰ্পযিৎৱা তং পপ্ৰচ্ছ, কিমপি পশ্যসি? ");
INSERT INTO sanasm_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","স নেত্ৰে উন্মীল্য জগাদ, ৱৃক্ষৱৎ মনুজান্ গচ্ছতো নিৰীক্ষে| ");
INSERT INTO sanasm_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ততো যীশুঃ পুনস্তস্য নযনযো ৰ্হস্তাৱৰ্পযিৎৱা তস্য নেত্ৰে উন্মীলযামাস; তস্মাৎ স স্ৱস্থো ভূৎৱা স্পষ্টৰূপং সৰ্ৱ্ৱলোকান্ দদৰ্শ| ");
INSERT INTO sanasm_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ততঃ পৰং ৎৱং গ্ৰামং মা গচ্ছ গ্ৰামস্থং কমপি চ কিমপ্যনুক্ত্ৱা নিজগৃহং যাহীত্যাদিশ্য যীশুস্তং নিজগৃহং প্ৰহিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","অনন্তৰং শিষ্যৈঃ সহিতো যীশুঃ কৈসৰীযাফিলিপিপুৰং জগাম, পথি গচ্ছন্ তানপৃচ্ছৎ কোঽহম্ অত্ৰ লোকাঃ কিং ৱদন্তি? ");
INSERT INTO sanasm_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","তে প্ৰত্যূচুঃ ৎৱাং যোহনং মজ্জকং ৱদন্তি কিন্তু কেপি কেপি এলিযং ৱদন্তি; অপৰে কেপি কেপি ভৱিষ্যদ্ৱাদিনাম্ একো জন ইতি ৱদন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","অথ স তানপৃচ্ছৎ কিন্তু কোহম্? ইত্যত্ৰ যূযং কিং ৱদথ? তদা পিতৰঃ প্ৰত্যৱদৎ ভৱান্ অভিষিক্তস্ত্ৰাতা| ");
INSERT INTO sanasm_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","ততঃ স তান্ গাঢমাদিশদ্ যূযং মম কথা কস্মৈচিদপি মা কথযত| ");
INSERT INTO sanasm_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","মনুষ্যপুত্ৰেণাৱশ্যং বহৱো যাতনা ভোক্তৱ্যাঃ প্ৰাচীনলোকৈঃ প্ৰধানযাজকৈৰধ্যাপকৈশ্চ স নিন্দিতঃ সন্ ঘাতযিষ্যতে তৃতীযদিনে উত্থাস্যতি চ, যীশুঃ শিষ্যানুপদেষ্টুমাৰভ্য কথামিমাং স্পষ্টমাচষ্ট| ");
INSERT INTO sanasm_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","তস্মাৎ পিতৰস্তস্য হস্তৌ ধৃৎৱা তং তৰ্জ্জিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","কিন্তু স মুখং পৰাৱৰ্ত্য শিষ্যগণং নিৰীক্ষ্য পিতৰং তৰ্জযিৎৱাৱাদীদ্ দূৰীভৱ ৱিঘ্নকাৰিন্ ঈশ্ৱৰীযকাৰ্য্যাদপি মনুষ্যকাৰ্য্যং তুভ্যং ৰোচততৰাং| ");
INSERT INTO sanasm_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","অথ স লোকান্ শিষ্যাংশ্চাহূয জগাদ যঃ কশ্চিন্ মামনুগন্তুম্ ইচ্ছতি স আত্মানং দাম্যতু, স্ৱক্ৰুশং গৃহীৎৱা মৎপশ্চাদ্ আযাতু| ");
INSERT INTO sanasm_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","যতো যঃ কশ্চিৎ স্ৱপ্ৰাণং ৰক্ষিতুমিচ্ছতি স তং হাৰযিষ্যতি, কিন্তু যঃ কশ্চিন্ মদৰ্থং সুসংৱাদাৰ্থঞ্চ প্ৰাণং হাৰযতি স তং ৰক্ষিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","অপৰঞ্চ মনুজঃ সৰ্ৱ্ৱং জগৎ প্ৰাপ্য যদি স্ৱপ্ৰাণং হাৰযতি তৰ্হি তস্য কো লাভঃ? ");
INSERT INTO sanasm_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","নৰঃ স্ৱপ্ৰাণৱিনিমযেন কিং দাতুং শক্নোতি? ");
INSERT INTO sanasm_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","এতেষাং ৱ্যভিচাৰিণাং পাপিনাঞ্চ লোকানাং সাক্ষাদ্ যদি কোপি মাং মৎকথাঞ্চ লজ্জাস্পদং জানাতি তৰ্হি মনুজপুত্ৰো যদা ধৰ্ম্মদূতৈঃ সহ পিতুঃ প্ৰভাৱেণাগমিষ্যতি তদা সোপি তং লজ্জাস্পদং জ্ঞাস্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","অথ স তানৱাদীৎ যুষ্মভ্যমহং যথাৰ্থং কথযামি, ঈশ্ৱৰৰাজ্যং পৰাক্ৰমেণোপস্থিতং ন দৃষ্ট্ৱা মৃত্যুং নাস্ৱাদিষ্যন্তে, অত্ৰ দণ্ডাযমানানাং মধ্যেপি তাদৃশা লোকাঃ সন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","অথ ষড্দিনেভ্যঃ পৰং যীশুঃ পিতৰং যাকূবং যোহনঞ্চ গৃহীৎৱা গিৰেৰুচ্চস্য নিৰ্জনস্থানং গৎৱা তেষাং প্ৰত্যক্ষে মূৰ্ত্যন্তৰং দধাৰ| ");
INSERT INTO sanasm_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ততস্তস্য পৰিধেযম্ ঈদৃশম্ উজ্জ্ৱলহিমপাণডৰং জাতং যদ্ জগতি কোপি ৰজকো ন তাদৃক্ পাণডৰং কৰ্ত্তাং শক্নোতি| ");
INSERT INTO sanasm_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","অপৰঞ্চ এলিযো মূসাশ্চ তেভ্যো দৰ্শনং দত্ত্ৱা যীশুনা সহ কথনং কৰ্ত্তুমাৰেভাতে| ");
INSERT INTO sanasm_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","তদা পিতৰো যীশুমৱাদীৎ হে গুৰোঽস্মাকমত্ৰ স্থিতিৰুত্তমা, ততএৱ ৱযং ৎৱৎকৃতে একাং মূসাকৃতে একাম্ এলিযকৃতে চৈকাং, এতাস্তিস্ৰঃ কুটী ৰ্নিৰ্ম্মাম| ");
INSERT INTO sanasm_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","কিন্তু স যদুক্তৱান্ তৎ স্ৱযং ন বুবুধে ততঃ সৰ্ৱ্ৱে বিভযাঞ্চক্ৰুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","এতৰ্হি পযোদস্তান্ ছাদযামাস, মমযাং প্ৰিযঃ পুত্ৰঃ কথাসু তস্য মনাংসি নিৱেশযতেতি নভোৱাণী তন্মেদ্যান্নিৰ্যযৌ| ");
INSERT INTO sanasm_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","অথ হঠাত্তে চতুৰ্দিশো দৃষ্ট্ৱা যীশুং ৱিনা স্ৱৈঃ সহিতং কমপি ন দদৃশুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ততঃ পৰং গিৰেৰৱৰোহণকালে স তান্ গাঢম্ দূত্যাদিদেশ যাৱন্নৰসূনোঃ শ্মশানাদুত্থানং ন ভৱতি, তাৱৎ দৰ্শনস্যাস্য ৱাৰ্ত্তা যুষ্মাভিঃ কস্মৈচিদপি ন ৱক্তৱ্যা| ");
INSERT INTO sanasm_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","তদা শ্মশানাদুত্থানস্য কোভিপ্ৰায ইতি ৱিচাৰ্য্য তে তদ্ৱাক্যং স্ৱেষু গোপাযাঞ্চক্ৰিৰে| ");
INSERT INTO sanasm_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","অথ তে যীশুং পপ্ৰচ্ছুঃ প্ৰথমত এলিযেনাগন্তৱ্যম্ ইতি ৱাক্যং কুত উপাধ্যাযা আহুঃ? ");
INSERT INTO sanasm_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","তদা স প্ৰত্যুৱাচ , এলিযঃ প্ৰথমমেত্য সৰ্ৱ্ৱকাৰ্য্যাণি সাধযিষ্যতি; নৰপুত্ৰে চ লিপি ৰ্যথাস্তে তথৈৱ সোপি বহুদুঃখং প্ৰাপ্যাৱজ্ঞাস্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","কিন্ত্ৱহং যুষ্মান্ ৱদামি , এলিযাৰ্থে লিপি ৰ্যথাস্তে তথৈৱ স এত্য যযৌ, লোকা: স্ৱেচ্ছানুৰূপং তমভিৱ্যৱহৰন্তি স্ম| ");
INSERT INTO sanasm_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","অনন্তৰং স শিষ্যসমীপমেত্য তেষাং চতুঃপাৰ্শ্ৱে তৈঃ সহ বহুজনান্ ৱিৱদমানান্ অধ্যাপকাংশ্চ দৃষ্টৱান্; ");
INSERT INTO sanasm_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","কিন্তু সৰ্ৱ্ৱলোকাস্তং দৃষ্ট্ৱৈৱ চমৎকৃত্য তদাসন্নং ধাৱন্তস্তং প্ৰণেমুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","তদা যীশুৰধ্যাপকানপ্ৰাক্ষীদ্ এতৈঃ সহ যূযং কিং ৱিৱদধ্ৱে? ");
INSERT INTO sanasm_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ততো লোকানাং কশ্চিদেকঃ প্ৰত্যৱাদীৎ হে গুৰো মম সূনুং মূকং ভূতধৃতঞ্চ ভৱদাসন্নম্ আনযং| ");
INSERT INTO sanasm_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","যদাসৌ ভূতস্তমাক্ৰমতে তদৈৱ পাতসতি তথা স ফেণাযতে, দন্তৈৰ্দন্তান্ ঘৰ্ষতি ক্ষীণো ভৱতি চ; ততো হেতোস্তং ভূতং ত্যাজযিতুং ভৱচ্ছিষ্যান্ নিৱেদিতৱান্ কিন্তু তে ন শেকুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","তদা স তমৱাদীৎ, ৰে অৱিশ্ৱাসিনঃ সন্তানা যুষ্মাভিঃ সহ কতি কালানহং স্থাস্যামি? অপৰান্ কতি কালান্ ৱা ৱ আচাৰান্ সহিষ্যে? তং মদাসন্নমানযত| ");
INSERT INTO sanasm_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ততস্তৎসন্নিধিং স আনীযত কিন্তু তং দৃষ্ট্ৱৈৱ ভূতো বালকং ধৃতৱান্; স চ ভূমৌ পতিৎৱা ফেণাযমানো লুলোঠ| ");
INSERT INTO sanasm_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","তদা স তৎপিতৰং পপ্ৰচ্ছ, অস্যেদৃশী দশা কতি দিনানি ভূতা? ততঃ সোৱাদীৎ বাল্যকালাৎ| ");
INSERT INTO sanasm_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","ভূতোযং তং নাশযিতুং বহুৱাৰান্ ৱহ্নৌ জলে চ ন্যক্ষিপৎ কিন্তু যদি ভৱান কিমপি কৰ্ত্তাং শক্নোতি তৰ্হি দযাং কৃৎৱাস্মান্ উপকৰোতু| ");
INSERT INTO sanasm_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","তদা যীশুস্তমৱদৎ যদি প্ৰত্যেতুং শক্নোষি তৰ্হি প্ৰত্যযিনে জনায সৰ্ৱ্ৱং সাধ্যম্| ");
INSERT INTO sanasm_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ততস্তৎক্ষণং তদ্বালকস্য পিতা প্ৰোচ্চৈ ৰূৱন্ সাশ্ৰুনেত্ৰঃ প্ৰোৱাচ, প্ৰভো প্ৰত্যেমি মমাপ্ৰত্যযং প্ৰতিকুৰু| ");
INSERT INTO sanasm_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","অথ যীশু ৰ্লোকসঙ্ঘং ধাৱিৎৱাযান্তং দৃষ্ট্ৱা তমপূতভূতং তৰ্জযিৎৱা জগাদ, ৰে বধিৰ মূক ভূত ৎৱমেতস্মাদ্ বহিৰ্ভৱ পুনঃ কদাপি মাশ্ৰযৈনং ৎৱামহম্ ইত্যাদিশামি| ");
INSERT INTO sanasm_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","তদা স ভূতশ্চীৎশব্দং কৃৎৱা তমাপীড্য বহিৰ্জজাম, ততো বালকো মৃতকল্পো বভূৱ তস্মাদযং মৃতইত্যনেকে কথযামাসুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","কিন্তু কৰং ধৃৎৱা যীশুনোত্থাপিতঃ স উত্তস্থৌ| ");
INSERT INTO sanasm_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","অথ যীশৌ গৃহং প্ৰৱিষ্টে শিষ্যা গুপ্তং তং পপ্ৰচ্ছুঃ, ৱযমেনং ভূতং ত্যাজযিতুং কুতো ন শক্তাঃ? ");
INSERT INTO sanasm_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","স উৱাচ, প্ৰাৰ্থনোপৱাসৌ ৱিনা কেনাপ্যন্যেন কৰ্ম্মণা ভূতমীদৃশং ত্যাজযিতুং ন শক্যং| ");
INSERT INTO sanasm_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","অনন্তৰং স তৎস্থানাদিৎৱা গালীল্মধ্যেন যযৌ, কিন্তু তৎ কোপি জানীযাদিতি স নৈচ্ছৎ| ");
INSERT INTO sanasm_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","অপৰঞ্চ স শিষ্যানুপদিশন্ বভাষে, নৰপুত্ৰো নৰহস্তেষু সমৰ্পযিষ্যতে তে চ তং হনিষ্যন্তি তৈস্তস্মিন্ হতে তৃতীযদিনে স উত্থাস্যতীতি| ");
INSERT INTO sanasm_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","কিন্তু তৎকথাং তে নাবুধ্যন্ত প্ৰষ্টুঞ্চ বিভ্যঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","অথ যীশুঃ কফৰ্নাহূম্পুৰমাগত্য মধ্যেগৃহঞ্চেত্য তানপৃচ্ছদ্ ৱৰ্ত্মমধ্যে যূযমন্যোন্যং কিং ৱিৱদধ্ৱে স্ম? ");
INSERT INTO sanasm_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","কিন্তু তে নিৰুত্তৰাস্তস্থু ৰ্যস্মাত্তেষাং কো মুখ্য ইতি ৱৰ্ত্মানি তেঽন্যোন্যং ৱ্যৱদন্ত| ");
INSERT INTO sanasm_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ততঃ স উপৱিশ্য দ্ৱাদশশিষ্যান্ আহূয বভাষে যঃ কশ্চিৎ মুখ্যো ভৱিতুমিচ্ছতি স সৰ্ৱ্ৱেভ্যো গৌণঃ সৰ্ৱ্ৱেষাং সেৱকশ্চ ভৱতু| ");
INSERT INTO sanasm_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","তদা স বালকমেকং গৃহীৎৱা মধ্যে সমুপাৱেশযৎ ততস্তং ক্ৰোডে কৃৎৱা তানৱাদাৎ ");
INSERT INTO sanasm_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","যঃ কশ্চিদীদৃশস্য কস্যাপি বালস্যাতিথ্যং কৰোতি স মমাতিথ্যং কৰোতি; যঃ কশ্চিন্মমাতিথ্যং কৰোতি স কেৱলম্ মমাতিথ্যং কৰোতি তন্ন মৎপ্ৰেৰকস্যাপ্যাতিথ্যং কৰোতি| ");
INSERT INTO sanasm_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","অথ যোহন্ তমব্ৰৱীৎ হে গুৰো, অস্মাকমননুগামিনম্ একং ৎৱান্নাম্না ভূতান্ ত্যাজযন্তং ৱযং দৃষ্টৱন্তঃ, অস্মাকমপশ্চাদ্গামিৎৱাচ্চ তং ন্যষেধাম| ");
INSERT INTO sanasm_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","কিন্তু যীশুৰৱদৎ তং মা নিষেধৎ, যতো যঃ কশ্চিন্ মন্নাম্না চিত্ৰং কৰ্ম্ম কৰোতি স সহসা মাং নিন্দিতুং ন শক্নোতি| ");
INSERT INTO sanasm_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","তথা যঃ কশ্চিদ্ যুষ্মাকং ৱিপক্ষতাং ন কৰোতি স যুষ্মাকমেৱ সপক্ষঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","যঃ কশ্চিদ্ যুষ্মান্ খ্ৰীষ্টশিষ্যান্ জ্ঞাৎৱা মন্নাম্না কংসৈকেন পানীযং পাতুং দদাতি, যুষ্মানহং যথাৰ্থং ৱচ্মি, স ফলেন ৱঞ্চিতো ন ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","কিন্তু যদি কশ্চিন্ মযি ৱিশ্ৱাসিনামেষাং ক্ষুদ্ৰপ্ৰাণিনাম্ একস্যাপি ৱিঘ্নং জনযতি, তৰ্হি তস্যৈতৎকৰ্ম্ম কৰণাৎ কণ্ঠবদ্ধপেষণীকস্য তস্য সাগৰাগাধজল মজ্জনং ভদ্ৰং| ");
INSERT INTO sanasm_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","অতঃ স্ৱকৰো যদি ৎৱাং বাধতে তৰ্হি তং ছিন্ধি; ");
INSERT INTO sanasm_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","যস্মাৎ যত্ৰ কীটা ন ম্ৰিযন্তে ৱহ্নিশ্চ ন নিৰ্ৱ্ৱাতি, তস্মিন্ অনিৰ্ৱ্ৱাণানলনৰকে কৰদ্ৱযৱস্তৱ গমনাৎ কৰহীনস্য স্ৱৰ্গপ্ৰৱেশস্তৱ ক্ষেমং| ");
INSERT INTO sanasm_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","যদি তৱ পাদো ৱিঘ্নং জনযতি তৰ্হি তং ছিন্ধি, ");
INSERT INTO sanasm_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","যতো যত্ৰ কীটা ন ম্ৰিযন্তে ৱহ্নিশ্চ ন নিৰ্ৱ্ৱাতি, তস্মিন্ ঽনিৰ্ৱ্ৱাণৱহ্নৌ নৰকে দ্ৱিপাদৱতস্তৱ নিক্ষেপাৎ পাদহীনস্য স্ৱৰ্গপ্ৰৱেশস্তৱ ক্ষেমং| ");
INSERT INTO sanasm_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","স্ৱনেত্ৰং যদি ৎৱাং বাধতে তৰ্হি তদপ্যুৎপাটয, যতো যত্ৰ কীটা ন ম্ৰিযন্তে ৱহ্নিশ্চ ন নিৰ্ৱ্ৱাতি, ");
INSERT INTO sanasm_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","তস্মিন ঽনিৰ্ৱ্ৱাণৱহ্নৌ নৰকে দ্ৱিনেত্ৰস্য তৱ নিক্ষেপাদ্ একনেত্ৰৱত ঈশ্ৱৰৰাজ্যে প্ৰৱেশস্তৱ ক্ষেমং| ");
INSERT INTO sanasm_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","যথা সৰ্ৱ্ৱো বলি ৰ্লৱণাক্তঃ ক্ৰিযতে তথা সৰ্ৱ্ৱো জনো ৱহ্নিৰূপেণ লৱণাক্তঃ কাৰিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","লৱণং ভদ্ৰং কিন্তু যদি লৱণে স্ৱাদুতা ন তিষ্ঠতি, তৰ্হি কথম্ আস্ৱাদ্যুক্তং কৰিষ্যথ? যূযং লৱণযুক্তা ভৱত পৰস্পৰং প্ৰেম কুৰুত| ");
INSERT INTO sanasm_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","অনন্তৰং স তৎস্থানাৎ প্ৰস্থায যৰ্দ্দননদ্যাঃ পাৰে যিহূদাপ্ৰদেশ উপস্থিতৱান্, তত্ৰ তদন্তিকে লোকানাং সমাগমে জাতে স নিজৰীত্যনুসাৰেণ পুনস্তান্ উপদিদেশ| ");
INSERT INTO sanasm_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","তদা ফিৰূশিনস্তৎসমীপম্ এত্য তং পৰীক্ষিতুং পপ্ৰচ্ছঃ স্ৱজাযা মনুজানাং ত্যজ্যা ন ৱেতি? ");
INSERT INTO sanasm_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ততঃ স প্ৰত্যৱাদীৎ, অত্ৰ কাৰ্য্যে মূসা যুষ্মান্ প্ৰতি কিমাজ্ঞাপযৎ? ");
INSERT INTO sanasm_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ত ঊচুঃ ত্যাগপত্ৰং লেখিতুং স্ৱপত্নীং ত্যক্তুঞ্চ মূসাঽনুমন্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","তদা যীশুঃ প্ৰত্যুৱাচ, যুষ্মাকং মনসাং কাঠিন্যাদ্ধেতো ৰ্মূসা নিদেশমিমম্ অলিখৎ| ");
INSERT INTO sanasm_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","কিন্তু সৃষ্টেৰাদৌ ঈশ্ৱৰো নৰান্ পুংৰূপেণ স্ত্ৰীৰূপেণ চ সসৰ্জ| ");
INSERT INTO sanasm_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","\"ততঃ কাৰণাৎ পুমান্ পিতৰং মাতৰঞ্চ ত্যক্ত্ৱা স্ৱজাযাযাম্ আসক্তো ভৱিষ্যতি, ");
INSERT INTO sanasm_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","তৌ দ্ৱাৱ্ একাঙ্গৌ ভৱিষ্যতঃ| \" তস্মাৎ তৎকালমাৰভ্য তৌ ন দ্ৱাৱ্ একাঙ্গৌ| ");
INSERT INTO sanasm_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","অতঃ কাৰণাদ্ ঈশ্ৱৰো যদযোজযৎ কোপি নৰস্তন্ন ৱিযেজযেৎ| ");
INSERT INTO sanasm_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","অথ যীশু ৰ্গৃহং প্ৰৱিষ্টস্তদা শিষ্যাঃ পুনস্তৎকথাং তং পপ্ৰচ্ছুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ততঃ সোৱদৎ কশ্চিদ্ যদি স্ৱভাৰ্য্যাং ত্যক্তৱান্যাম্ উদ্ৱহতি তৰ্হি স স্ৱভাৰ্য্যাযাঃ প্ৰাতিকূল্যেন ৱ্যভিচাৰী ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","কাচিন্নাৰী যদি স্ৱপতিং হিৎৱান্যপুংসা ৱিৱাহিতা ভৱতি তৰ্হি সাপি ৱ্যভিচাৰিণী ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","অথ স যথা শিশূন্ স্পৃশেৎ, তদৰ্থং লোকৈস্তদন্তিকং শিশৱ আনীযন্ত, কিন্তু শিষ্যাস্তানানীতৱতস্তৰ্জযামাসুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","যীশুস্তদ্ দৃষ্ট্ৱা ক্ৰুধ্যন্ জগাদ, মন্নিকটম্ আগন্তুং শিশূন্ মা ৱাৰযত, যত এতাদৃশা ঈশ্ৱৰৰাজ্যাধিকাৰিণঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","যুষ্মানহং যথাৰ্থং ৱচ্মি, যঃ কশ্চিৎ শিশুৱদ্ ভূৎৱা ৰাজ্যমীশ্ৱৰস্য ন গৃহ্লীযাৎ স কদাপি তদ্ৰাজ্যং প্ৰৱেষ্টুং ন শক্নোতি| ");
INSERT INTO sanasm_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","অননতৰং স শিশূনঙ্কে নিধায তেষাং গাত্ৰেষু হস্তৌ দত্ত্ৱাশিষং বভাষে| ");
INSERT INTO sanasm_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","অথ স ৱৰ্ত্মনা যাতি, এতৰ্হি জন একো ধাৱন্ আগত্য তৎসম্মুখে জানুনী পাতযিৎৱা পৃষ্টৱান্, ভোঃ পৰমগুৰো, অনন্তাযুঃ প্ৰাপ্তযে মযা কিং কৰ্ত্তৱ্যং? ");
INSERT INTO sanasm_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","তদা যীশুৰুৱাচ, মাং পৰমং কুতো ৱদসি? ৱিনেশ্ৱৰং কোপি পৰমো ন ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","পৰস্ত্ৰীং নাভিগচ্ছ; নৰং মা ঘাতয; স্তেযং মা কুৰু; মৃষাসাক্ষ্যং মা দেহি; হিংসাঞ্চ মা কুৰু; পিতৰৌ সম্মন্যস্ৱ; নিদেশা এতে ৎৱযা জ্ঞাতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ততস্তন প্ৰত্যুক্তং, হে গুৰো বাল্যকালাদহং সৰ্ৱ্ৱানেতান্ আচৰামি| ");
INSERT INTO sanasm_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","তদা যীশুস্তং ৱিলোক্য স্নেহেন বভাষে, তৱৈকস্যাভাৱ আস্তে; ৎৱং গৎৱা সৰ্ৱ্ৱস্ৱং ৱিক্ৰীয দৰিদ্ৰেভ্যো ৱিশ্ৰাণয, ততঃ স্ৱৰ্গে ধনং প্ৰাপ্স্যসি; ততঃ পৰম্ এত্য ক্ৰুশং ৱহন্ মদনুৱৰ্ত্তী ভৱ| ");
INSERT INTO sanasm_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","কিন্তু তস্য বহুসম্পদ্ৱিদ্যমানৎৱাৎ স ইমাং কথামাকৰ্ণ্য ৱিষণো দুঃখিতশ্চ সন্ জগাম| ");
INSERT INTO sanasm_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","অথ যীশুশ্চতুৰ্দিশো নিৰীক্ষ্য শিষ্যান্ অৱাদীৎ, ধনিলোকানাম্ ঈশ্ৱৰৰাজ্যপ্ৰৱেশঃ কীদৃগ্ দুষ্কৰঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","তস্য কথাতঃ শিষ্যাশ্চমচ্চক্ৰুঃ, কিন্তু স পুনৰৱদৎ, হে বালকা যে ধনে ৱিশ্ৱসন্তি তেষাম্ ঈশ্ৱৰৰাজ্যপ্ৰৱেশঃ কীদৃগ্ দুষ্কৰঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ঈশ্ৱৰৰাজ্যে ধনিনাং প্ৰৱেশাৎ সূচিৰন্ধ্ৰেণ মহাঙ্গস্য গমনাগমনং সুকৰং| ");
INSERT INTO sanasm_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","তদা শিষ্যা অতীৱ ৱিস্মিতাঃ পৰস্পৰং প্ৰোচুঃ, তৰ্হি কঃ পৰিত্ৰাণং প্ৰাপ্তুং শক্নোতি? ");
INSERT INTO sanasm_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ততো যীশুস্তান্ ৱিলোক্য বভাষে, তন্ নৰস্যাসাধ্যং কিন্তু নেশ্ৱৰস্য, যতো হেতোৰীশ্ৱৰস্য সৰ্ৱ্ৱং সাধ্যম্| ");
INSERT INTO sanasm_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","তদা পিতৰ উৱাচ, পশ্য ৱযং সৰ্ৱ্ৱং পৰিত্যজ্য ভৱতোনুগামিনো জাতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","ততো যীশুঃ প্ৰত্যৱদৎ, যুষ্মানহং যথাৰ্থং ৱদামি, মদৰ্থং সুসংৱাদাৰ্থং ৱা যো জনঃ সদনং ভ্ৰাতৰং ভগিনীং পিতৰং মাতৰং জাযাং সন্তানান্ ভূমি ৱা ত্যক্ত্ৱা ");
INSERT INTO sanasm_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","গৃহভ্ৰাতৃভগিনীপিতৃমাতৃপত্নীসন্তানভূমীনামিহ শতগুণান্ প্ৰেত্যানন্তাযুশ্চ ন প্ৰাপ্নোতি তাদৃশঃ কোপি নাস্তি| ");
INSERT INTO sanasm_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","কিন্ত্ৱগ্ৰীযা অনেকে লোকাঃ শেষাঃ, শেষীযা অনেকে লোকাশ্চাগ্ৰা ভৱিষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","অথ যিৰূশালম্যানকালে যীশুস্তেষাম্ অগ্ৰগামী বভূৱ, তস্মাত্তে চিত্ৰং জ্ঞাৎৱা পশ্চাদ্গামিনো ভূৎৱা বিভ্যুঃ| তদা স পুন ৰ্দ্ৱাদশশিষ্যান্ গৃহীৎৱা স্ৱীযং যদ্যদ্ ঘটিষ্যতে তত্তৎ তেভ্যঃ কথযিতুং প্ৰাৰেভে; ");
INSERT INTO sanasm_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","পশ্যত ৱযং যিৰূশালম্পুৰং যামঃ, তত্ৰ মনুষ্যপুত্ৰঃ প্ৰধানযাজকানাম্ উপাধ্যাযানাঞ্চ কৰেষু সমৰ্পযিষ্যতে; তে চ ৱধদণ্ডাজ্ঞাং দাপযিৎৱা পৰদেশীযানাং কৰেষু তং সমৰ্পযিষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","তে তমুপহস্য কশযা প্ৰহৃত্য তদ্ৱপুষি নিষ্ঠীৱং নিক্ষিপ্য তং হনিষ্যন্তি, ততঃ স তৃতীযদিনে প্ৰোত্থাস্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ততঃ সিৱদেঃ পুত্ৰৌ যাকূব্যোহনৌ তদন্তিকম্ এত্য প্ৰোচতুঃ, হে গুৰো যদ্ আৱাভ্যাং যাচিষ্যতে তদস্মদৰ্থং ভৱান্ কৰোতু নিৱেদনমিদমাৱযোঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ততঃ স কথিতৱান্, যুৱাং কিমিচ্ছথঃ? কিং মযা যুষ্মদৰ্থং কৰণীযং? ");
INSERT INTO sanasm_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","তদা তৌ প্ৰোচতুঃ, আৱযোৰেকং দক্ষিণপাৰ্শ্ৱে ৱামপাৰ্শ্ৱে চৈকং তৱৈশ্ৱৰ্য্যপদে সমুপৱেষ্টুম্ আজ্ঞাপয| ");
INSERT INTO sanasm_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","কিন্তু যীশুঃ প্ৰত্যুৱাচ যুৱামজ্ঞাৎৱেদং প্ৰাৰ্থযেথে, যেন কংসেনাহং পাস্যামি তেন যুৱাভ্যাং কিং পাতুং শক্ষ্যতে? যস্মিন্ মজ্জনেনাহং মজ্জিষ্যে তন্মজ্জনে মজ্জযিতুং কিং যুৱাভ্যাং শক্ষ্যতে? তৌ প্ৰত্যূচতুঃ শক্ষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","তদা যীশুৰৱদৎ যেন কংসেনাহং পাস্যামি তেনাৱশ্যং যুৱামপি পাস্যথঃ, যেন মজ্জনেন চাহং মজ্জিয্যে তত্ৰ যুৱামপি মজ্জিষ্যেথে| ");
INSERT INTO sanasm_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","কিন্তু যেষামৰ্থম্ ইদং নিৰূপিতং, তান্ ৱিহাযান্যং কমপি মম দক্ষিণপাৰ্শ্ৱে ৱামপাৰ্শ্ৱে ৱা সমুপৱেশযিতুং মমাধিকাৰো নাস্তি| ");
INSERT INTO sanasm_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","অথান্যদশশিষ্যা ইমাং কথাং শ্ৰুৎৱা যাকূব্যোহন্ভ্যাং চুকুপুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","কিন্তু যীশুস্তান্ সমাহূয বভাষে, অন্যদেশীযানাং ৰাজৎৱং যে কুৰ্ৱ্ৱন্তি তে তেষামেৱ প্ৰভুৎৱং কুৰ্ৱ্ৱন্তি, তথা যে মহালোকাস্তে তেষাম্ অধিপতিৎৱং কুৰ্ৱ্ৱন্তীতি যূযং জানীথ| ");
INSERT INTO sanasm_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","কিন্তু যুষ্মাকং মধ্যে ন তথা ভৱিষ্যতি, যুষ্মাকং মধ্যে যঃ প্ৰাধান্যং ৱাঞ্ছতি স যুষ্মাকং সেৱকো ভৱিষ্যতি, ");
INSERT INTO sanasm_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","যুষ্মাকং যো মহান্ ভৱিতুমিচ্ছতি স সৰ্ৱ্ৱেষাং কিঙ্কৰো ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","যতো মনুষ্যপুত্ৰঃ সেৱ্যো ভৱিতুং নাগতঃ সেৱাং কৰ্ত্তাং তথানেকেষাং পৰিত্ৰাণস্য মূল্যৰূপস্ৱপ্ৰাণং দাতুঞ্চাগতঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","অথ তে যিৰীহোনগৰং প্ৰাপ্তাস্তস্মাৎ শিষ্যৈ ৰ্লোকৈশ্চ সহ যীশো ৰ্গমনকালে টীমযস্য পুত্ৰো বৰ্টীমযনামা অন্ধস্তন্মাৰ্গপাৰ্শ্ৱে ভিক্ষাৰ্থম্ উপৱিষ্টঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","স নাসৰতীযস্য যীশোৰাগমনৱাৰ্ত্তাং প্ৰাপ্য প্ৰোচৈ ৰ্ৱক্তুমাৰেভে, হে যীশো দাযূদঃ সন্তান মাং দযস্ৱ| ");
INSERT INTO sanasm_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ততোনেকে লোকা মৌনীভৱেতি তং তৰ্জযামাসুঃ, কিন্তু স পুনৰধিকমুচ্চৈ ৰ্জগাদ, হে যীশো দাযূদঃ সন্তান মাং দযস্ৱ| ");
INSERT INTO sanasm_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","তদা যীশুঃ স্থিৎৱা তমাহ্ৱাতুং সমাদিদেশ, ততো লোকাস্তমন্ধমাহূয বভাষিৰে, হে নৰ, স্থিৰো ভৱ, উত্তিষ্ঠ, স ৎৱামাহ্ৱযতি| ");
INSERT INTO sanasm_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","তদা স উত্তৰীযৱস্ত্ৰং নিক্ষিপ্য প্ৰোত্থায যীশোঃ সমীপং গতঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ততো যীশুস্তমৱদৎ ৎৱযা কিং প্ৰাৰ্থ্যতে? তুভ্যমহং কিং কৰিষ্যামী? তদা সোন্ধস্তমুৱাচ, হে গুৰো মদীযা দৃষ্টিৰ্ভৱেৎ| ");
INSERT INTO sanasm_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ততো যীশুস্তমুৱাচ যাহি তৱ ৱিশ্ৱাসস্ত্ৱাং স্ৱস্থমকাৰ্ষীৎ, তস্মাৎ তৎক্ষণং স দৃষ্টিং প্ৰাপ্য পথা যীশোঃ পশ্চাদ্ যযৌ| ");
INSERT INTO sanasm_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","অনন্তৰং তেষু যিৰূশালমঃ সমীপস্থযো ৰ্বৈৎফগীবৈথনীযপুৰযোৰন্তিকস্থং জৈতুননামাদ্ৰিমাগতেষু যীশুঃ প্ৰেষণকালে দ্ৱৌ শিষ্যাৱিদং ৱাক্যং জগাদ, ");
INSERT INTO sanasm_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","যুৱামমুং সম্মুখস্থং গ্ৰামং যাতং, তত্ৰ প্ৰৱিশ্য যো নৰং নাৱহৎ তং গৰ্দ্দভশাৱকং দ্ৰক্ষ্যথস্তং মোচযিৎৱানযতং| ");
INSERT INTO sanasm_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","কিন্তু যুৱাং কৰ্ম্মেদং কুতঃ কুৰুথঃ? কথামিমাং যদি কোপি পৃচ্ছতি তৰ্হি প্ৰভোৰত্ৰ প্ৰযোজনমস্তীতি কথিতে স শীঘ্ৰং তমত্ৰ প্ৰেষযিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ততস্তৌ গৎৱা দ্ৱিমাৰ্গমেলনে কস্যচিদ্ দ্ৱাৰস্য পাৰ্শ্ৱে তং গৰ্দ্দভশাৱকং প্ৰাপ্য মোচযতঃ, ");
INSERT INTO sanasm_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","এতৰ্হি তত্ৰোপস্থিতলোকানাং কশ্চিদ্ অপৃচ্ছৎ, গৰ্দ্দভশিশুং কুতো মোচযথঃ? ");
INSERT INTO sanasm_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","তদা যীশোৰাজ্ঞানুসাৰেণ তেভ্যঃ প্ৰত্যুদিতে তৎক্ষণং তমাদাতুং তেঽনুজজ্ঞুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","অথ তৌ যীশোঃ সন্নিধিং গৰ্দ্দভশিশুম্ আনীয তদুপৰি স্ৱৱস্ত্ৰাণি পাতযামাসতুঃ; ততঃ স তদুপৰি সমুপৱিষ্টঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","তদানেকে পথি স্ৱৱাসাংসি পাতযামাসুঃ, পৰৈশ্চ তৰুশাখাশ্ছিতৱা মাৰ্গে ৱিকীৰ্ণাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","অপৰঞ্চ পশ্চাদ্গামিনোঽগ্ৰগামিনশ্চ সৰ্ৱ্ৱে জনা উচৈঃস্ৱৰেণ ৱক্তুমাৰেভিৰে, জয জয যঃ পৰমেশ্ৱৰস্য নাম্নাগচ্ছতি স ধন্য ইতি| ");
INSERT INTO sanasm_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","তথাস্মাকমং পূৰ্ৱ্ৱপুৰুষস্য দাযূদো যদ্ৰাজ্যং পৰমেশ্ৱৰনাম্নাযাতি তদপি ধন্যং, সৰ্ৱ্ৱস্মাদুচ্ছ্ৰাযে স্ৱৰ্গে ঈশ্ৱৰস্য জযো ভৱেৎ| ");
INSERT INTO sanasm_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ইত্থং যীশু ৰ্যিৰূশালমি মন্দিৰং প্ৰৱিশ্য চতুৰ্দিক্স্থানি সৰ্ৱ্ৱাণি ৱস্তূনি দৃষ্টৱান্; অথ সাযংকাল উপস্থিতে দ্ৱাদশশিষ্যসহিতো বৈথনিযং জগাম| ");
INSERT INTO sanasm_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","অপৰেহনি বৈথনিযাদ্ আগমনসমযে ক্ষুধাৰ্ত্তো বভূৱ| ");
INSERT INTO sanasm_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ততো দূৰে সপত্ৰমুডুম্বৰপাদপং ৱিলোক্য তত্ৰ কিঞ্চিৎ ফলং প্ৰাপ্তুং তস্য সন্নিকৃষ্টং যযৌ, তদানীং ফলপাতনস্য সমযো নাগচ্ছতি| ততস্তত্ৰোপস্থিতঃ পত্ৰাণি ৱিনা কিমপ্যপৰং ন প্ৰাপ্য স কথিতৱান্, ");
INSERT INTO sanasm_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","অদ্যাৰভ্য কোপি মানৱস্ত্ৱত্তঃ ফলং ন ভুঞ্জীত; ইমাং কথাং তস্য শিষ্যাঃ শুশ্ৰুৱুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","তদনন্তৰং তেষু যিৰূশালমমাযাতেষু যীশু ৰ্মন্দিৰং গৎৱা তত্ৰস্থানাং বণিজাং মুদ্ৰাসনানি পাৰাৱতৱিক্ৰেতৃণাম্ আসনানি চ ন্যুব্জযাঞ্চকাৰ সৰ্ৱ্ৱান্ ক্ৰেতৃন্ ৱিক্ৰেতৃংশ্চ বহিশ্চকাৰ| ");
INSERT INTO sanasm_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","অপৰং মন্দিৰমধ্যেন কিমপি পাত্ৰং ৱোঢুং সৰ্ৱ্ৱজনং নিৱাৰযামাস| ");
INSERT INTO sanasm_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","লোকানুপদিশন্ জগাদ, মম গৃহং সৰ্ৱ্ৱজাতীযানাং প্ৰাৰ্থনাগৃহম্ ইতি নাম্না প্ৰথিতং ভৱিষ্যতি এতৎ কিং শাস্ত্ৰে লিখিতং নাস্তি? কিন্তু যূযং তদেৱ চোৰাণাং গহ্ৱৰং কুৰুথ| ");
INSERT INTO sanasm_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ইমাং ৱাণীং শ্ৰুৎৱাধ্যাপকাঃ প্ৰধানযাজকাশ্চ তং যথা নাশযিতুং শক্নুৱন্তি তথোेপাযং মৃগযামাসুঃ, কিন্তু তস্যোপদেশাৎ সৰ্ৱ্ৱে লোকা ৱিস্মযং গতা অতস্তে তস্মাদ্ বিভ্যুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","অথ সাযংসময উপস্থিতে যীশুৰ্নগৰাদ্ বহিৰ্ৱৱ্ৰাজ| ");
INSERT INTO sanasm_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","অনন্তৰং প্ৰাতঃকালে তে তেন মাৰ্গেণ গচ্ছন্তস্তমুডুম্বৰমহীৰুহং সমূলং শুষ্কং দদৃশুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ততঃ পিতৰঃ পূৰ্ৱ্ৱৱাক্যং স্মৰন্ যীশুং বভাষং, হে গুৰো পশ্যতু য উডুম্বৰৱিটপী ভৱতা শপ্তঃ স শুষ্কো বভূৱ| ");
INSERT INTO sanasm_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ততো যীশুঃ প্ৰত্যৱাদীৎ, যূযমীশ্ৱৰে ৱিশ্ৱসিত| ");
INSERT INTO sanasm_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","যুষ্মানহং যথাৰ্থং ৱদামি কোপি যদ্যেতদ্গিৰিং ৱদতি, ৎৱমুত্থায গৎৱা জলধৌ পত, প্ৰোক্তমিদং ৱাক্যমৱশ্যং ঘটিষ্যতে, মনসা কিমপি ন সন্দিহ্য চেদিদং ৱিশ্ৱসেৎ তৰ্হি তস্য ৱাক্যানুসাৰেণ তদ্ ঘটিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","অতো হেতোৰহং যুষ্মান্ ৱচ্মি, প্ৰাৰ্থনাকালে যদ্যদাকাংক্ষিষ্যধ্ৱে তত্তদৱশ্যং প্ৰাপ্স্যথ, ইত্থং ৱিশ্ৱসিত, ততঃ প্ৰাপ্স্যথ| ");
INSERT INTO sanasm_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","অপৰঞ্চ যুষ্মাসু প্ৰাৰ্থযিতুং সমুত্থিতেষু যদি কোপি যুষ্মাকম্ অপৰাধী তিষ্ঠতি, তৰ্হি তং ক্ষমধ্ৱং, তথা কৃতে যুষ্মাকং স্ৱৰ্গস্থঃ পিতাপি যুষ্মাকমাগাংমি ক্ষমিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","কিন্তু যদি ন ক্ষমধ্ৱে তৰ্হি ৱঃ স্ৱৰ্গস্থঃ পিতাপি যুষ্মাকমাগাংসি ন ক্ষমিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","অনন্তৰং তে পুন ৰ্যিৰূশালমং প্ৰৱিৱিশুঃ, যীশু ৰ্যদা মধ্যেমন্দিৰম্ ইতস্ততো গচ্ছতি, তদানীং প্ৰধানযাজকা উপাধ্যাযাঃ প্ৰাঞ্চশ্চ তদন্তিকমেত্য কথামিমাং পপ্ৰচ্ছুঃ, ");
INSERT INTO sanasm_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ৎৱং কেনাদেশেন কৰ্ম্মাণ্যেতানি কৰোষি? তথৈতানি কৰ্ম্মাণি কৰ্ত্তাং কেনাদিষ্টোসি? ");
INSERT INTO sanasm_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ততো যীশুঃ প্ৰতিগদিতৱান্ অহমপি যুষ্মান্ এককথাং পৃচ্ছামি, যদি যূযং তস্যা উত্তৰং কুৰুথ, তৰ্হি কযাজ্ঞযাহং কৰ্ম্মাণ্যেতানি কৰোমি তদ্ যুষ্মভ্যং কথযিষ্যামি| ");
INSERT INTO sanasm_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","যোহনো মজ্জনম্ ঈশ্ৱৰাৎ জাতং কিং মানৱাৎ? তন্মহ্যং কথযত| ");
INSERT INTO sanasm_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","তে পৰস্পৰং ৱিৱেক্তুং প্ৰাৰেভিৰে, তদ্ ঈশ্ৱৰাদ্ বভূৱেতি চেদ্ ৱদামস্তৰ্হি কুতস্তং ন প্ৰত্যৈত? কথমেতাং কথযিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","মানৱাদ্ অভৱদিতি চেদ্ ৱদামস্তৰ্হি লোকেভ্যো ভযমস্তি যতো হেতোঃ সৰ্ৱ্ৱে যোহনং সত্যং ভৱিষ্যদ্ৱাদিনং মন্যন্তে| ");
INSERT INTO sanasm_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","অতএৱ তে যীশুং প্ৰত্যৱাদিষু ৰ্ৱযং তদ্ ৱক্তুং ন শক্নুমঃ| যীশুৰুৱাচ, তৰ্হি যেনাদেশেন কৰ্ম্মাণ্যেতানি কৰোমি, অহমপি যুষ্মভ্যং তন্ন কথযিষ্যামি| ");
INSERT INTO sanasm_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","অনন্তৰং যীশু ৰ্দৃষ্টান্তেন তেভ্যঃ কথযিতুমাৰেভে, কশ্চিদেকো দ্ৰাক্ষাক্ষেত্ৰং ৱিধায তচ্চতুৰ্দিক্ষু ৱাৰণীং কৃৎৱা তন্মধ্যে দ্ৰাক্ষাপেষণকুণ্ডম্ অখনৎ, তথা তস্য গডমপি নিৰ্ম্মিতৱান্ ততস্তৎক্ষেত্ৰং কৃষীৱলেষু সমৰ্প্য দূৰদেশং জগাম| ");
INSERT INTO sanasm_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","তদনন্তৰং ফলকালে কৃষীৱলেভ্যো দ্ৰাক্ষাক্ষেত্ৰফলানি প্ৰাপ্তুং তেষাং সৱিধে ভৃত্যম্ একং প্ৰাহিণোৎ| ");
INSERT INTO sanasm_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","কিন্তু কৃষীৱলাস্তং ধৃৎৱা প্ৰহৃত্য ৰিক্তহস্তং ৱিসসৃজুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ততঃ স পুনৰন্যমেকং ভৃত্যং প্ৰষযামাস, কিন্তু তে কৃষীৱলাঃ পাষাণাঘাতৈস্তস্য শিৰো ভঙ্ক্ত্ৱা সাপমানং তং ৱ্যসৰ্জন্| ");
INSERT INTO sanasm_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ততঃ পৰং সোপৰং দাসং প্ৰাহিণোৎ তদা তে তং জঘ্নুঃ, এৱম্ অনেকেষাং কস্যচিৎ প্ৰহাৰঃ কস্যচিদ্ ৱধশ্চ তৈঃ কৃতঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ততঃ পৰং মযা স্ৱপুত্ৰে প্ৰহিতে তে তমৱশ্যং সম্মংস্যন্তে, ইত্যুক্ত্ৱাৱশেষে তেষাং সন্নিধৌ নিজপ্ৰিযম্ অদ্ৱিতীযং পুত্ৰং প্ৰেষযামাস| ");
INSERT INTO sanasm_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","কিন্তু কৃষীৱলাঃ পৰস্পৰং জগদুঃ, এষ উত্তৰাধিকাৰী, আগচ্ছত ৱযমেনং হন্মস্তথা কৃতে ঽধিকাৰোযম্ অস্মাকং ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ততস্তং ধৃৎৱা হৎৱা দ্ৰাক্ষাক্ষেত্ৰাদ্ বহিঃ প্ৰাক্ষিপন্| ");
INSERT INTO sanasm_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","অনেনাসৌ দ্ৰাক্ষাক্ষেত্ৰপতিঃ কিং কৰিষ্যতি? স এত্য তান্ কৃষীৱলান্ সংহত্য তৎক্ষেত্ৰম্ অন্যেষু কৃষীৱলেষু সমৰ্পযিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","অপৰঞ্চ, \"স্থপতযঃ কৰিষ্যন্তি গ্ৰাৱাণং যন্তু তুচ্ছকং| প্ৰাধানপ্ৰস্তৰঃ কোণে স এৱ সংভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","এতৎ কৰ্ম্ম পৰেশস্যাংদ্ভুতং নো দৃষ্টিতো ভৱেৎ|| \" ইমাং শাস্ত্ৰীযাং লিপিং যূযং কিং নাপাঠিষ্ট? ");
INSERT INTO sanasm_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","তদানীং স তানুদ্দিশ্য তাং দৃষ্টান্তকথাং কথিতৱান্, ত ইত্থং বুদ্ৱ্ৱা তং ধৰ্ত্তামুদ্যতাঃ, কিন্তু লোকেভ্যো বিভ্যুঃ, তদনন্তৰং তে তং ৱিহায ৱৱ্ৰজুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","অপৰঞ্চ তে তস্য ৱাক্যদোষং ধৰ্ত্তাং কতিপযান্ ফিৰূশিনো হেৰোদীযাংশ্চ লোকান্ তদন্তিকং প্ৰেষযামাসুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ত আগত্য তমৱদন্, হে গুৰো ভৱান্ তথ্যভাষী কস্যাপ্যনুৰোধং ন মন্যতে, পক্ষপাতঞ্চ ন কৰোতি, যথাৰ্থত ঈশ্ৱৰীযং মাৰ্গং দৰ্শযতি ৱযমেতৎ প্ৰজানীমঃ, কৈসৰায কৰো দেযো ন ৱাং? ৱযং দাস্যামো ন ৱা? ");
INSERT INTO sanasm_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","কিন্তু স তেষাং কপটং জ্ঞাৎৱা জগাদ, কুতো মাং পৰীক্ষধ্ৱে? একং মুদ্ৰাপাদং সমানীয মাং দৰ্শযত| ");
INSERT INTO sanasm_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","তদা তৈৰেকস্মিন্ মুদ্ৰাপাদে সমানীতে স তান্ পপ্ৰচ্ছ, অত্ৰ লিখিতং নাম মূৰ্ত্তি ৰ্ৱা কস্য? তে প্ৰত্যূচুঃ, কৈসৰস্য| ");
INSERT INTO sanasm_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","তদা যীশুৰৱদৎ তৰ্হি কৈসৰস্য দ্ৰৱ্যাণি কৈসৰায দত্ত, ঈশ্ৱৰস্য দ্ৰৱ্যাণি তু ঈশ্ৱৰায দত্ত; ততস্তে ৱিস্মযং মেনিৰে| ");
INSERT INTO sanasm_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","অথ মৃতানামুত্থানং যে ন মন্যন্তে তে সিদূকিনো যীশোঃ সমীপমাগত্য তং পপ্ৰচ্ছুঃ; ");
INSERT INTO sanasm_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","হে গুৰো কশ্চিজ্জনো যদি নিঃসন্ততিঃ সন্ ভাৰ্য্যাযাং সত্যাং ম্ৰিযতে তৰ্হি তস্য ভ্ৰাতা তস্য ভাৰ্য্যাং গৃহীৎৱা ভ্ৰাতু ৰ্ৱংশোৎপত্তিং কৰিষ্যতি, ৱ্যৱস্থামিমাং মূসা অস্মান্ প্ৰতি ৱ্যলিখৎ| ");
INSERT INTO sanasm_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","কিন্তু কেচিৎ সপ্ত ভ্ৰাতৰ আসন্, ততস্তেষাং জ্যেষ্ঠভ্ৰাতা ৱিৱহ্য নিঃসন্ততিঃ সন্ অম্ৰিযত| ");
INSERT INTO sanasm_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ততো দ্ৱিতীযো ভ্ৰাতা তাং স্ত্ৰিযমগৃহণৎ কিন্তু সোপি নিঃসন্ততিঃ সন্ অম্ৰিযত; অথ তৃতীযোপি ভ্ৰাতা তাদৃশোভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ইত্থং সপ্তৈৱ ভ্ৰাতৰস্তাং স্ত্ৰিযং গৃহীৎৱা নিঃসন্তানাঃ সন্তোঽম্ৰিযন্ত, সৰ্ৱ্ৱশেষে সাপি স্ত্ৰী ম্ৰিযতে স্ম| ");
INSERT INTO sanasm_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","অথ মৃতানামুত্থানকালে যদা ত উত্থাস্যন্তি তদা তেষাং কস্য ভাৰ্য্যা সা ভৱিষ্যতি? যতস্তে সপ্তৈৱ তাং ৱ্যৱহন্| ");
INSERT INTO sanasm_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ততো যীশুঃ প্ৰত্যুৱাচ শাস্ত্ৰম্ ঈশ্ৱৰশক্তিঞ্চ যূযমজ্ঞাৎৱা কিমভ্ৰাম্যত ন? ");
INSERT INTO sanasm_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","মৃতলোকানামুত্থানং সতি তে ন ৱিৱহন্তি ৱাগ্দত্তা অপি ন ভৱন্তি, কিন্তু স্ৱৰ্গীযদূতানাং সদৃশা ভৱন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","পুনশ্চ \"অহম্ ইব্ৰাহীম ঈশ্ৱৰ ইস্হাক ঈশ্ৱৰো যাকূবশ্চেশ্ৱৰঃ\" যামিমাং কথাং স্তম্বমধ্যে তিষ্ঠন্ ঈশ্ৱৰো মূসামৱাদীৎ মৃতানামুত্থানাৰ্থে সা কথা মূসালিখিতে পুস্তকে কিং যুষ্মাভি ৰ্নাপাঠি? ");
INSERT INTO sanasm_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ঈশ্ৱৰো জীৱতাং প্ৰভুঃ কিন্তু মৃতানাং প্ৰভু ৰ্ন ভৱতি, তস্মাদ্ধেতো ৰ্যূযং মহাভ্ৰমেণ তিষ্ঠথ| ");
INSERT INTO sanasm_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","এতৰ্হি একোধ্যাপক এত্য তেষামিত্থং ৱিচাৰং শুশ্ৰাৱ; যীশুস্তেষাং ৱাক্যস্য সদুত্তৰং দত্তৱান্ ইতি বুদ্ৱ্ৱা তং পৃষ্টৱান্ সৰ্ৱ্ৱাসাম্ আজ্ঞানাং কা শ্ৰেষ্ঠা? ততো যীশুঃ প্ৰত্যুৱাচ, ");
INSERT INTO sanasm_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","\"হে ইস্ৰাযেল্লোকা অৱধত্ত, অস্মাকং প্ৰভুঃ পৰমেশ্ৱৰ এক এৱ, ");
INSERT INTO sanasm_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","যূযং সৰ্ৱ্ৱন্তঃকৰণৈঃ সৰ্ৱ্ৱপ্ৰাণৈঃ সৰ্ৱ্ৱচিত্তৈঃ সৰ্ৱ্ৱশক্তিভিশ্চ তস্মিন্ প্ৰভৌ পৰমেশ্ৱৰে প্ৰীযধ্ৱং,\" ইত্যাজ্ঞা শ্ৰেষ্ঠা| ");
INSERT INTO sanasm_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","তথা \"স্ৱপ্ৰতিৱাসিনি স্ৱৱৎ প্ৰেম কুৰুধ্ৱং,\" এষা যা দ্ৱিতীযাজ্ঞা সা তাদৃশী; এতাভ্যাং দ্ৱাভ্যাম্ আজ্ঞাভ্যাম্ অন্যা কাপ্যাজ্ঞা শ্ৰেষ্ঠা নাস্তি| ");
INSERT INTO sanasm_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","তদা সোধ্যাপকস্তমৱদৎ, হে গুৰো সত্যং ভৱান্ যথাৰ্থং প্ৰোক্তৱান্ যত একস্মাদ্ ঈশ্ৱৰাদ্ অন্যো দ্ৱিতীয ঈশ্ৱৰো নাস্তি; ");
INSERT INTO sanasm_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","অপৰং সৰ্ৱ্ৱান্তঃকৰণৈঃ সৰ্ৱ্ৱপ্ৰাণৈঃ সৰ্ৱ্ৱচিত্তৈঃ সৰ্ৱ্ৱশক্তিভিশ্চ ঈশ্ৱৰে প্ৰেমকৰণং তথা স্ৱমীপৱাসিনি স্ৱৱৎ প্ৰেমকৰণঞ্চ সৰ্ৱ্ৱেভ্যো হোমবলিদানাদিভ্যঃ শ্ৰষ্ঠং ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","ততো যীশুঃ সুবুদ্ধেৰিৱ তস্যেদম্ উত্তৰং শ্ৰুৎৱা তং ভাষিতৱান্ ৎৱমীশ্ৱৰস্য ৰাজ্যান্ন দূৰোসি| ইতঃ পৰং তেন সহ কস্যাপি ৱাক্যস্য ৱিচাৰং কৰ্ত্তাং কস্যাপি প্ৰগল্ভতা ন জাতা| ");
INSERT INTO sanasm_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","অনন্তৰং মধ্যেমন্দিৰম্ উপদিশন্ যীশুৰিমং প্ৰশ্নং চকাৰ, অধ্যাপকা অভিষিক্তং (তাৰকং) কুতো দাযূদঃ সন্তানং ৱদন্তি? ");
INSERT INTO sanasm_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","স্ৱযং দাযূদ্ পৱিত্ৰস্যাত্মন আৱেশেনেদং কথযামাস| যথা| \"মম প্ৰভুমিদং ৱাক্যৱদৎ পৰমেশ্ৱৰঃ| তৱ শত্ৰূনহং যাৱৎ পাদপীঠং কৰোমি ন| তাৱৎ কালং মদীযে ৎৱং দক্ষপাৰ্শ্ৱ্ উপাৱিশ| \" ");
INSERT INTO sanasm_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","যদি দাযূদ্ তং প্ৰভূং ৱদতি তৰ্হি কথং স তস্য সন্তানো ভৱিতুমৰ্হতি? ইতৰে লোকাস্তৎকথাং শ্ৰুৎৱাননন্দুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","তদানীং স তানুপদিশ্য কথিতৱান্ যে নৰা দীৰ্ঘপৰিধেযানি হট্টে ৱিপনৌ চ ");
INSERT INTO sanasm_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","লোককৃতনমস্কাৰান্ ভজনগৃহে প্ৰধানাসনানি ভোজনকালে প্ৰধানস্থানানি চ কাঙ্ক্ষন্তে; ");
INSERT INTO sanasm_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ৱিধৱানাং সৰ্ৱ্ৱস্ৱং গ্ৰসিৎৱা ছলাদ্ দীৰ্ঘকালং প্ৰাৰ্থযন্তে তেভ্য উপাধ্যাযেভ্যঃ সাৱধানা ভৱত; তেঽধিকতৰান্ দণ্ডান্ প্ৰাপ্স্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","তদনন্তৰং লোকা ভাণ্ডাগাৰে মুদ্ৰা যথা নিক্ষিপন্তি ভাণ্ডাগাৰস্য সম্মুখে সমুপৱিশ্য যীশুস্তদৱলুলোক; তদানীং বহৱো ধনিনস্তস্য মধ্যে বহূনি ধনানি নিৰক্ষিপন্| ");
INSERT INTO sanasm_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","পশ্চাদ্ একা দৰিদ্ৰা ৱিধৱা সমাগত্য দ্ৱিপণমূল্যাং মুদ্ৰৈকাং তত্ৰ নিৰক্ষিপৎ| ");
INSERT INTO sanasm_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","তদা যীশুঃ শিষ্যান্ আহূয কথিতৱান্ যুষ্মানহং যথাৰ্থং ৱদামি যে যে ভাণ্ডাগাৰেঽস্মিন ধনানি নিঃক্ষিপন্তি স্ম তেভ্যঃ সৰ্ৱ্ৱেভ্য ইযং ৱিধৱা দৰিদ্ৰাধিকম্ নিঃক্ষিপতি স্ম| ");
INSERT INTO sanasm_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","যতস্তে প্ৰভূতধনস্য কিঞ্চিৎ নিৰক্ষিপন্ কিন্তু দীনেযং স্ৱদিনযাপনযোগ্যং কিঞ্চিদপি ন স্থাপযিৎৱা সৰ্ৱ্ৱস্ৱং নিৰক্ষিপৎ| ");
INSERT INTO sanasm_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","অনন্তৰং মন্দিৰাদ্ বহিৰ্গমনকালে তস্য শিষ্যাণামেকস্তং ৱ্যাহৃতৱান্ হে গুৰো পশ্যতু কীদৃশাঃ পাষাণাঃ কীদৃক্ চ নিচযনং| ");
INSERT INTO sanasm_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","তদা যীশুস্তম্ অৱদৎ ৎৱং কিমেতদ্ বৃহন্নিচযনং পশ্যসি? অস্যৈকপাষাণোপি দ্ৱিতীযপাষাণোপৰি ন স্থাস্যতি সৰ্ৱ্ৱে ঽধঃক্ষেপ্স্যন্তে| ");
INSERT INTO sanasm_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","অথ যস্মিন্ কালে জৈতুন্গিৰৌ মন্দিৰস্য সম্মুখে স সমুপৱিষ্টস্তস্মিন্ কালে পিতৰো যাকূব্ যোহন্ আন্দ্ৰিযশ্চৈতে তং ৰহসি পপ্ৰচ্ছুঃ, ");
INSERT INTO sanasm_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","এতা ঘটনাঃ কদা ভৱিষ্যন্তি? তথৈতৎসৰ্ৱ্ৱাসাং সিদ্ধ্যুপক্ৰমস্য ৱা কিং চিহ্নং? তদস্মভ্যং কথযতু ভৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ততো যাশুস্তান্ ৱক্তুমাৰেভে, কোপি যথা যুষ্মান্ ন ভ্ৰামযতি তথাত্ৰ যূযং সাৱধানা ভৱত| ");
INSERT INTO sanasm_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","যতঃ খ্ৰীষ্টোহমিতি কথযিৎৱা মম নাম্নানেকে সমাগত্য লোকানাং ভ্ৰমং জনযিষ্যন্তি; ");
INSERT INTO sanasm_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","কিন্তু যূযং ৰণস্য ৱাৰ্ত্তাং ৰণাডম্বৰঞ্চ শ্ৰুৎৱা মা ৱ্যাকুলা ভৱত, ঘটনা এতা অৱশ্যম্মাৱিন্যঃ; কিন্ত্ৱাপাততো ন যুগান্তো ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","দেশস্য ৱিপক্ষতযা দেশো ৰাজ্যস্য ৱিপক্ষতযা চ ৰাজ্যমুত্থাস্যতি, তথা স্থানে স্থানে ভূমিকম্পো দুৰ্ভিক্ষং মহাক্লেশাশ্চ সমুপস্থাস্যন্তি, সৰ্ৱ্ৱ এতে দুঃখস্যাৰম্ভাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","কিন্তু যূযম্ আত্মাৰ্থে সাৱধানাস্তিষ্ঠত, যতো লোকা ৰাজসভাযাং যুষ্মান্ সমৰ্পযিষ্যন্তি, তথা ভজনগৃহে প্ৰহৰিষ্যন্তি; যূযং মদৰ্থে দেশাধিপান্ ভূপাংশ্চ প্ৰতি সাক্ষ্যদানায তেষাং সম্মুখে উপস্থাপযিষ্যধ্ৱে| ");
INSERT INTO sanasm_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","শেষীভৱনাৎ পূৰ্ৱ্ৱং সৰ্ৱ্ৱান্ দেশীযান্ প্ৰতি সুসংৱাদঃ প্ৰচাৰযিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","কিন্তু যদা তে যুষ্মান্ ধৃৎৱা সমৰ্পযিষ্যন্তি তদা যূযং যদ্যদ্ উত্তৰং দাস্যথ, তদগ্ৰ তস্য ৱিৱেচনং মা কুৰুত তদৰ্থং কিঞ্চিদপি মা চিন্তযত চ, তদানীং যুষ্মাকং মনঃসু যদ্যদ্ ৱাক্যম্ উপস্থাপযিষ্যতে তদেৱ ৱদিষ্যথ, যতো যূযং ন তদ্ৱক্তাৰঃ কিন্তু পৱিত্ৰ আত্মা তস্য ৱক্তা| ");
INSERT INTO sanasm_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","তদা ভ্ৰাতা ভ্ৰাতৰং পিতা পুত্ৰং ঘাতনাৰ্থং পৰহস্তেষু সমৰ্পযিষ্যতে, তথা পত্যানি মাতাপিত্ৰো ৰ্ৱিপক্ষতযা তৌ ঘাতযিষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","মম নামহেতোঃ সৰ্ৱ্ৱেষাং সৱিধে যূযং জুগুপ্সিতা ভৱিষ্যথ, কিন্তু যঃ কশ্চিৎ শেষপৰ্য্যন্তং ধৈৰ্য্যম্ আলম্বিষ্যতে সএৱ পৰিত্ৰাস্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","দানিযেল্ভৱিষ্যদ্ৱাদিনা প্ৰোক্তং সৰ্ৱ্ৱনাশি জুগুপ্সিতঞ্চ ৱস্তু যদা ৎৱযোগ্যস্থানে ৱিদ্যমানং দ্ৰক্ষথ (যো জনঃ পঠতি স বুধ্যতাং) তদা যে যিহূদীযদেশে তিষ্ঠন্তি তে মহীধ্ৰং প্ৰতি পলাযন্তাং; ");
INSERT INTO sanasm_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","তথা যো নৰো গৃহোপৰি তিষ্ঠতি স গৃহমধ্যং নাৱৰোহতু, তথা কিমপি ৱস্তু গ্ৰহীতুং মধ্যেগৃহং ন প্ৰৱিশতু; ");
INSERT INTO sanasm_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","তথা চ যো নৰঃ ক্ষেত্ৰে তিষ্ঠতি সোপি স্ৱৱস্ত্ৰং গ্ৰহীতুং পৰাৱৃত্য ন ৱ্ৰজতু| ");
INSERT INTO sanasm_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","তদানীং গৰ্ব্ভৱতীনাং স্তন্যদাত্ৰীণাঞ্চ যোষিতাং দুৰ্গতি ৰ্ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","যুষ্মাকং পলাযনং শীতকালে যথা ন ভৱতি তদৰ্থং প্ৰাৰ্থযধ্ৱং| ");
INSERT INTO sanasm_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","যতস্তদা যাদৃশী দুৰ্ঘটনা ঘটিষ্যতে তাদৃশী দুৰ্ঘটনা ঈশ্ৱৰসৃষ্টেঃ প্ৰথমমাৰভ্যাদ্য যাৱৎ কদাপি ন জাতা ন জনিষ্যতে চ| ");
INSERT INTO sanasm_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","অপৰঞ্চ পৰমেশ্ৱৰো যদি তস্য সমযস্য সংক্ষেপং ন কৰোতি তৰ্হি কস্যাপি প্ৰাণভৃতো ৰক্ষা ভৱিতুং ন শক্ষ্যতি, কিন্তু যান্ জনান্ মনোনীতান্ অকৰোৎ তেষাং স্ৱমনোনীতানাং হেতোঃ স তদনেহসং সংক্ষেপ্স্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","অন্যচ্চ পশ্যত খ্ৰীষ্টোত্ৰ স্থানে ৱা তত্ৰ স্থানে ৱিদ্যতে, তস্মিন্কালে যদি কশ্চিদ্ যুষ্মান্ এতাদৃশং ৱাক্যং ৱ্যাহৰতি, তৰ্হি তস্মিন্ ৱাক্যে ভৈৱ ৱিশ্ৱসিত| ");
INSERT INTO sanasm_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","যতোনেকে মিথ্যাখ্ৰীষ্টা মিথ্যাভৱিষ্যদ্ৱাদিনশ্চ সমুপস্থায বহূনি চিহ্নান্যদ্ভুতানি কৰ্ম্মাণি চ দৰ্শযিষ্যন্তি; তথা যদি সম্ভৱতি তৰ্হি মনোনীতলোকানামপি মিথ্যামতিং জনযিষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","পশ্যত ঘটনাতঃ পূৰ্ৱ্ৱং সৰ্ৱ্ৱকাৰ্য্যস্য ৱাৰ্ত্তাং যুষ্মভ্যমদাম্, যূযং সাৱধানাস্তিষ্ঠত| ");
INSERT INTO sanasm_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","অপৰঞ্চ তস্য ক্লেশকালস্যাৱ্যৱহিতে পৰকালে ভাস্কৰঃ সান্ধকাৰো ভৱিষ্যতি তথৈৱ চন্দ্ৰশ্চন্দ্ৰিকাং ন দাস্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","নভঃস্থানি নক্ষত্ৰাণি পতিষ্যন্তি, ৱ্যোমমণ্ডলস্থা গ্ৰহাশ্চ ৱিচলিষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","তদানীং মহাপৰাক্ৰমেণ মহৈশ্ৱৰ্য্যেণ চ মেঘমাৰুহ্য সমাযান্তং মানৱসুতং মানৱাঃ সমীক্ষিষ্যন্তে| ");
INSERT INTO sanasm_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","অন্যচ্চ স নিজদূতান্ প্ৰহিত্য নভোভূম্যোঃ সীমাং যাৱদ্ জগতশ্চতুৰ্দিগ্ভ্যঃ স্ৱমনোনীতলোকান্ সংগ্ৰহীষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","উডুম্বৰতৰো ৰ্দৃষ্টান্তং শিক্ষধ্ৱং যদোডুম্বৰস্য তৰো ৰ্নৱীনাঃ শাখা জাযন্তে পল্লৱাদীনি চ ৰ্নিগচ্ছন্তি, তদা নিদাঘকালঃ সৱিধো ভৱতীতি যূযং জ্ঞাতুং শক্নুথ| ");
INSERT INTO sanasm_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","তদ্ৱদ্ এতা ঘটনা দৃষ্ট্ৱা স কালো দ্ৱাৰ্য্যুপস্থিত ইতি জানীত| ");
INSERT INTO sanasm_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","যুষ্মানহং যথাৰ্থং ৱদামি, আধুনিকলোকানাং গমনাৎ পূৰ্ৱ্ৱং তানি সৰ্ৱ্ৱাণি ঘটিষ্যন্তে| ");
INSERT INTO sanasm_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","দ্যাৱাপৃথিৱ্যো ৰ্ৱিচলিতযোঃ সত্যো ৰ্মদীযা ৱাণী ন ৱিচলিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","অপৰঞ্চ স্ৱৰ্গস্থদূতগণো ৱা পুত্ৰো ৱা তাতাদন্যঃ কোপি তং দিৱসং তং দণ্ডং ৱা ন জ্ঞাপযতি| ");
INSERT INTO sanasm_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","অতঃ স সমযঃ কদা ভৱিষ্যতি, এতজ্জ্ঞানাভাৱাদ্ যূযং সাৱধানাস্তিষ্ঠত, সতৰ্কাশ্চ ভূৎৱা প্ৰাৰ্থযধ্ৱং; ");
INSERT INTO sanasm_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","যদ্ৱৎ কশ্চিৎ পুমান্ স্ৱনিৱেশনাদ্ দূৰদেশং প্ৰতি যাত্ৰাকৰণকালে দাসেষু স্ৱকাৰ্য্যস্য ভাৰমৰ্পযিৎৱা সৰ্ৱ্ৱান্ স্ৱে স্ৱে কৰ্ম্মণি নিযোজযতি; অপৰং দৌৱাৰিকং জাগৰিতুং সমাদিশ্য যাতি, তদ্ৱন্ নৰপুত্ৰঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","গৃহপতিঃ সাযংকালে নিশীথে ৱা তৃতীযযামে ৱা প্ৰাতঃকালে ৱা কদাগমিষ্যতি তদ্ যূযং ন জানীথ; ");
INSERT INTO sanasm_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","স হঠাদাগত্য যথা যুষ্মান্ নিদ্ৰিতান্ ন পশ্যতি, তদৰ্থং জাগৰিতাস্তিষ্ঠত| ");
INSERT INTO sanasm_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","যুষ্মানহং যদ্ ৱদামি তদেৱ সৰ্ৱ্ৱান্ ৱদামি, জাগৰিতাস্তিষ্ঠতেতি| ");
INSERT INTO sanasm_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","তদা নিস্তাৰোৎসৱকিণ্ৱহীনপূপোৎসৱযোৰাৰম্ভস্য দিনদ্ৱযে ঽৱশিষ্টে প্ৰধানযাজকা অধ্যাপকাশ্চ কেনাপি ছলেন যীশুং ধৰ্ত্তাং হন্তুঞ্চ মৃগযাঞ্চক্ৰিৰে; ");
INSERT INTO sanasm_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","কিন্তু লোকানাং কলহভযাদূচিৰে, নচোৎসৱকাল উচিতমেতদিতি| ");
INSERT INTO sanasm_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","অনন্তৰং বৈথনিযাপুुৰে শিমোনকুষ্ঠিনো গৃহে যোশৌ ভোৎকুমুপৱিষ্টে সতি কাচিদ্ যোষিৎ পাণ্ডৰপাষাণস্য সম্পুটকেন মহাৰ্ঘ্যোত্তমতৈলম্ আনীয সম্পুটকং ভংক্ত্ৱা তস্যোত্তমাঙ্গে তৈলধাৰাং পাতযাঞ্চক্ৰে| ");
INSERT INTO sanasm_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","তস্মাৎ কেচিৎ স্ৱান্তে কুপ্যন্তঃ কথিতৱংন্তঃ কুতোযং তৈলাপৱ্যযঃ? ");
INSERT INTO sanasm_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","যদ্যেতৎ তৈল ৱ্যক্ৰেষ্যত তৰ্হি মুদ্ৰাপাদশতত্ৰযাদপ্যধিকং তস্য প্ৰাপ্তমূল্যং দৰিদ্ৰলোকেভ্যো দাতুমশক্ষ্যত, কথামেতাং কথযিৎৱা তযা যোষিতা সাকং ৱাচাযুহ্যন্| ");
INSERT INTO sanasm_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","কিন্তু যীশুৰুৱাচ, কুত এতস্যৈ কৃচ্ছ্ৰং দদাসি? মহ্যমিযং কৰ্ম্মোত্তমং কৃতৱতী| ");
INSERT INTO sanasm_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","দৰিদ্ৰাঃ সৰ্ৱ্ৱদা যুষ্মাভিঃ সহ তিষ্ঠন্তি, তস্মাদ্ যূযং যদেচ্ছথ তদৈৱ তানুপকৰ্ত্তাং শক্নুথ, কিন্ত্ৱহং যুভাভিঃ সহ নিৰন্তৰং ন তিষ্ঠামি| ");
INSERT INTO sanasm_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","অস্যা যথাসাধ্যং তথৈৱাকৰোদিযং, শ্মশানযাপনাৎ পূৰ্ৱ্ৱং সমেত্য মদ্ৱপুষি তৈলম্ অমৰ্দ্দযৎ| ");
INSERT INTO sanasm_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","অহং যুষ্মভ্যং যথাৰ্থং কথযামি, জগতাং মধ্যে যত্ৰ যত্ৰ সুসংৱাদোযং প্ৰচাৰযিষ্যতে তত্ৰ তত্ৰ যোষিত এতস্যাঃ স্মৰণাৰ্থং তৎকৃতকৰ্ম্মৈতৎ প্ৰচাৰযিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ততঃ পৰং দ্ৱাদশানাং শিষ্যাণামেক ঈষ্কৰিযোতীযযিহূদাখ্যো যীশুং পৰকৰেষু সমৰ্পযিতুং প্ৰধানযাজকানাং সমীপমিযায| ");
INSERT INTO sanasm_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","তে তস্য ৱাক্যং সমাকৰ্ণ্য সন্তুষ্টাঃ সন্তস্তস্মৈ মুদ্ৰা দাতুং প্ৰত্যজানত; তস্মাৎ স তং তেষাং কৰেষু সমৰ্পণাযোপাযং মৃগযামাস| ");
INSERT INTO sanasm_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","অনন্তৰং কিণ্ৱশূন্যপূপোৎসৱস্য প্ৰথমেঽহনি নিস্তাৰোত্মৱাৰ্থং মেষমাৰণাসমযে শিষ্যাস্তং পপ্ৰচ্ছঃ কুত্ৰ গৎৱা ৱযং নিস্তাৰোৎসৱস্য ভোজ্যমাসাদযিষ্যামঃ? কিমিচ্ছতি ভৱান্? ");
INSERT INTO sanasm_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","তদানীং স তেষাং দ্ৱযং প্ৰেৰযন্ বভাষে যুৱযোঃ পুৰমধ্যং গতযোঃ সতো ৰ্যো জনঃ সজলকুম্ভং ৱহন্ যুৱাং সাক্ষাৎ কৰিষ্যতি তস্যৈৱ পশ্চাদ্ যাতং; ");
INSERT INTO sanasm_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","স যৎ সদনং প্ৰৱেক্ষ্যতি তদ্ভৱনপতিং ৱদতং, গুৰুৰাহ যত্ৰ সশিষ্যোহং নিস্তাৰোৎসৱীযং ভোজনং কৰিষ্যামি, সা ভোজনশালা কুত্ৰাস্তি? ");
INSERT INTO sanasm_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ততঃ স পৰিষ্কৃতাং সুসজ্জিতাং বৃহতীচঞ্চ যাং শালাং দৰ্শযিষ্যতি তস্যামস্মদৰ্থং ভোজ্যদ্ৰৱ্যাণ্যাসাদযতং| ");
INSERT INTO sanasm_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ততঃ শিষ্যৌ প্ৰস্থায পুৰং প্ৰৱিশ্য স যথোক্তৱান্ তথৈৱ প্ৰাপ্য নিস্তাৰোৎসৱস্য ভোজ্যদ্ৰৱ্যাণি সমাসাদযেতাম্| ");
INSERT INTO sanasm_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","অনন্তৰং যীশুঃ সাযংকালে দ্ৱাদশভিঃ শিষ্যৈঃ সাৰ্দ্ধং জগাম; ");
INSERT INTO sanasm_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","সৰ্ৱ্ৱেষু ভোজনায প্ৰোপৱিষ্টেষু স তানুদিতৱান্ যুষ্মানহং যথাৰ্থং ৱ্যাহৰামি, অত্ৰ যুষ্মাকমেকো জনো যো মযা সহ ভুংক্তে মাং পৰকেৰেষু সমৰ্পযিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","তদানীং তে দুঃখিতাঃ সন্ত একৈকশস্তং প্ৰষ্টুমাৰব্ধৱন্তঃ স কিমহং? পশ্চাদ্ অন্য একোভিদধে স কিমহং? ");
INSERT INTO sanasm_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ততঃ স প্ৰত্যৱদদ্ এতেষাং দ্ৱাদশানাং যো জনো মযা সমং ভোজনাপাত্ৰে পাণিং মজ্জযিষ্যতি স এৱ| ");
INSERT INTO sanasm_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","মনুজতনযমধি যাদৃশং লিখিতমাস্তে তদনুৰূপা গতিস্তস্য ভৱিষ্যতি, কিন্তু যো জনো মানৱসুতং সমৰ্পযিষ্যতে হন্ত তস্য জন্মাভাৱে সতি ভদ্ৰমভৱিষ্যৎ| ");
INSERT INTO sanasm_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","অপৰঞ্চ তেষাং ভোজনসমযে যীশুঃ পূপং গৃহীৎৱেশ্ৱৰগুণান্ অনুকীৰ্ত্য ভঙ্ক্ত্ৱা তেভ্যো দত্ত্ৱা বভাষে, এতদ্ গৃহীৎৱা ভুঞ্জীধ্ৱম্ এতন্মম ৱিগ্ৰহৰূপং| ");
INSERT INTO sanasm_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","অনন্তৰং স কংসং গৃহীৎৱেশ্ৱৰস্য গুণান্ কীৰ্ত্তযিৎৱা তেভ্যো দদৌ, ততস্তে সৰ্ৱ্ৱে পপুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","অপৰং স তানৱাদীদ্ বহূনাং নিমিত্তং পাতিতং মম নৱীননিযমৰূপং শোণিতমেতৎ| ");
INSERT INTO sanasm_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","যুষ্মানহং যথাৰ্থং ৱদামি, ঈশ্ৱৰস্য ৰাজ্যে যাৱৎ সদ্যোজাতং দ্ৰাক্ষাৰসং ন পাস্যামি,তাৱদহং দ্ৰাক্ষাফলৰসং পুন ৰ্ন পাস্যামি| ");
INSERT INTO sanasm_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","তদনন্তৰং তে গীতমেকং সংগীয বহি ৰ্জৈতুনং শিখৰিণং যযুঃ ");
INSERT INTO sanasm_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","অথ যীশুস্তানুৱাচ নিশাযামস্যাং মযি যুষ্মাকং সৰ্ৱ্ৱেষাং প্ৰত্যূহো ভৱিষ্যতি যতো লিখিতমাস্তে যথা, মেষাণাং ৰক্ষকঞ্চাহং প্ৰহৰিষ্যামি ৱৈ ততঃ| মেষাণাং নিৱহো নূনং প্ৰৱিকীৰ্ণো ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","কন্তু মদুত্থানে জাতে যুষ্মাকমগ্ৰেঽহং গালীলং ৱ্ৰজিষ্যামি| ");
INSERT INTO sanasm_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","তদা পিতৰঃ প্ৰতিবভাষে, যদ্যপি সৰ্ৱ্ৱেষাং প্ৰত্যূহো ভৱতি তথাপি মম নৈৱ ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ততো যীশুৰুক্তাৱান্ অহং তুভ্যং তথ্যং কথযামি, ক্ষণাদাযামদ্য কুক্কুটস্য দ্ৱিতীযৱাৰৰৱণাৎ পূৰ্ৱ্ৱং ৎৱং ৱাৰত্ৰযং মামপহ্নোষ্যসে| ");
INSERT INTO sanasm_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","কিন্তু স গাঢং ৱ্যাহৰদ্ যদ্যপি ৎৱযা সাৰ্দ্ধং মম প্ৰাণো যাতি তথাপি কথমপি ৎৱাং নাপহ্নোষ্যে; সৰ্ৱ্ৱেঽপীতৰে তথৈৱ বভাষিৰে| ");
INSERT INTO sanasm_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","অপৰঞ্চ তেষু গেৎশিমানীনামকং স্থান গতেষু স শিষ্যান্ জগাদ, যাৱদহং প্ৰাৰ্থযে তাৱদত্ৰ স্থানে যূযং সমুপৱিশত| ");
INSERT INTO sanasm_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","অথ স পিতৰং যাকূবং যোহনঞ্চ গৃহীৎৱা ৱৱ্ৰাজ; অত্যন্তং ত্ৰাসিতো ৱ্যাকুলিতশ্চ তেভ্যঃ কথযামাস, ");
INSERT INTO sanasm_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","নিধনকালৱৎ প্ৰাণো মেঽতীৱ দঃখমেতি, যূযং জাগ্ৰতোত্ৰ স্থানে তিষ্ঠত| ");
INSERT INTO sanasm_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ততঃ স কিঞ্চিদ্দূৰং গৎৱা ভূমাৱধোমুখঃ পতিৎৱা প্ৰাৰ্থিতৱানেতৎ, যদি ভৱিতুং শক্যং তৰ্হি দুঃখসমযোযং মত্তো দূৰীভৱতু| ");
INSERT INTO sanasm_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","অপৰমুদিতৱান্ হে পিত ৰ্হে পিতঃ সৰ্ৱ্ৱেং ৎৱযা সাধ্যং, ততো হেতোৰিমং কংসং মত্তো দূৰীকুৰু, কিন্তু তন্ মমেচ্ছাতো ন তৱেচ্ছাতো ভৱতু| ");
INSERT INTO sanasm_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","ততঃ পৰং স এত্য তান্ নিদ্ৰিতান্ নিৰীক্ষ্য পিতৰং প্ৰোৱাচ, শিমোন্ ৎৱং কিং নিদ্ৰাসি? ঘটিকামেকাম্ অপি জাগৰিতুং ন শক্নোষি? ");
INSERT INTO sanasm_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","পৰীক্ষাযাং যথা ন পতথ তদৰ্থং সচেতনাঃ সন্তঃ প্ৰাৰ্থযধ্ৱং; মন উদ্যুক্তমিতি সত্যং কিন্তু ৱপুৰশক্তিকং| ");
INSERT INTO sanasm_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","অথ স পুনৰ্ৱ্ৰজিৎৱা পূৰ্ৱ্ৱৱৎ প্ৰাৰ্থযাঞ্চক্ৰে| ");
INSERT INTO sanasm_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","পৰাৱৃত্যাগত্য পুনৰপি তান্ নিদ্ৰিতান্ দদৰ্শ তদা তেষাং লোচনানি নিদ্ৰযা পূৰ্ণানি, তস্মাত্তস্মৈ কা কথা কথযিতৱ্যা ত এতদ্ বোদ্ধুং ন শেকুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ততঃপৰং তৃতীযৱাৰং আগত্য তেভ্যো ঽকথযদ্ ইদানীমপি শযিৎৱা ৱিশ্ৰাম্যথ? যথেষ্টং জাতং, সমযশ্চোপস্থিতঃ পশ্যত মানৱতনযঃ পাপিলোকানাং পাণিষু সমৰ্প্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","উত্তিষ্ঠত, ৱযং ৱ্ৰজামো যো জনো মাং পৰপাণিষু সমৰ্পযিষ্যতে পশ্যত স সমীপমাযাতঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ইমাং কথাং কথযতি স, এতৰ্হিদ্ৱাদশানামেকো যিহূদা নামা শিষ্যঃ প্ৰধানযাজকানাম্ উপাধ্যাযানাং প্ৰাচীনলোকানাঞ্চ সন্নিধেঃ খঙ্গলগুডধাৰিণো বহুলোকান্ গৃহীৎৱা তস্য সমীপ উপস্থিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","অপৰঞ্চাসৌ পৰপাণিষু সমৰ্পযিতা পূৰ্ৱ্ৱমিতি সঙ্কেতং কৃতৱান্ যমহং চুম্বিষ্যামি স এৱাসৌ তমেৱ ধৃৎৱা সাৱধানং নযত| ");
INSERT INTO sanasm_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","অতো হেতোঃ স আগত্যৈৱ যোশোঃ সৱিধং গৎৱা হে গুৰো হে গুৰো, ইত্যুক্ত্ৱা তং চুচুম্ব| ");
INSERT INTO sanasm_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","তদা তে তদুপৰি পাণীনৰ্পযিৎৱা তং দধ্নুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ততস্তস্য পাৰ্শ্ৱস্থানাং লোকানামেকঃ খঙ্গং নিষ্কোষযন্ মহাযাজকস্য দাসমেকং প্ৰহৃত্য তস্য কৰ্ণং চিচ্ছেদ| ");
INSERT INTO sanasm_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","পশ্চাদ্ যীশুস্তান্ ৱ্যাজহাৰ খঙ্গান্ লগুডাংশ্চ গৃহীৎৱা মাং কিং চৌৰং ধৰ্ত্তাং সমাযাতাঃ? ");
INSERT INTO sanasm_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","মধ্যেমন্দিৰং সমুপদিশন্ প্ৰত্যহং যুষ্মাভিঃ সহ স্থিতৱানতহং, তস্মিন্ কালে যূযং মাং নাদীধৰত, কিন্ত্ৱনেন শাস্ত্ৰীযং ৱচনং সেধনীযং| ");
INSERT INTO sanasm_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","তদা সৰ্ৱ্ৱে শিষ্যাস্তং পৰিত্যজ্য পলাযাঞ্চক্ৰিৰে| ");
INSERT INTO sanasm_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","অথৈকো যুৱা মানৱো নগ্নকাযে ৱস্ত্ৰমেকং নিধায তস্য পশ্চাদ্ ৱ্ৰজন্ যুৱলোকৈ ৰ্ধৃতো ");
INSERT INTO sanasm_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ৱস্ত্ৰং ৱিহায নগ্নঃ পলাযাঞ্চক্ৰে| ");
INSERT INTO sanasm_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","অপৰঞ্চ যস্মিন্ স্থানে প্ৰধানযাজকা উপাধ্যাযাঃ প্ৰাচীনলোকাশ্চ মহাযাজকেন সহ সদসি স্থিতাস্তস্মিন্ স্থানে মহাযাজকস্য সমীপং যীশুং নিন্যুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","পিতৰো দূৰে তৎপশ্চাদ্ ইৎৱা মহাযাজকস্যাট্টালিকাং প্ৰৱিশ্য কিঙ্কৰৈঃ সহোপৱিশ্য ৱহ্নিতাপং জগ্ৰাহ| ");
INSERT INTO sanasm_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","তদানীং প্ৰধানযাজকা মন্ত্ৰিণশ্চ যীশুং ঘাতযিতুং তৎপ্ৰাতিকূল্যেন সাক্ষিণো মৃগযাঞ্চক্ৰিৰে, কিন্তু ন প্ৰাপ্তাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","অনেকৈস্তদ্ৱিৰুদ্ধং মৃষাসাক্ষ্যে দত্তেপি তেষাং ৱাক্যানি ন সমগচ্ছন্ত| ");
INSERT INTO sanasm_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","সৰ্ৱ্ৱশেষে কিযন্ত উত্থায তস্য প্ৰাতিকূল্যেন মৃষাসাক্ষ্যং দত্ত্ৱা কথযামাসুঃ, ");
INSERT INTO sanasm_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","ইদং কৰকৃতমন্দিৰং ৱিনাশ্য দিনত্ৰযমধ্যে পুনৰপৰম্ অকৰকৃতং মন্দিৰং নিৰ্ম্মাস্যামি, ইতি ৱাক্যম্ অস্য মুখাৎ শ্ৰুতমস্মাভিৰিতি| ");
INSERT INTO sanasm_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","কিন্তু তত্ৰাপি তেষাং সাক্ষ্যকথা ন সঙ্গাতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","অথ মহাযাজকো মধ্যেসভম্ উত্থায যীশুং ৱ্যাজহাৰ, এতে জনাস্ত্ৱযি যৎ সাক্ষ্যমদুঃ ৎৱমেতস্য কিমপ্যুত্তৰং কিং ন দাস্যসি? ");
INSERT INTO sanasm_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","কিন্তু স কিমপ্যুত্তৰং ন দৎৱা মৌনীভূয তস্যৌ; ততো মহাযাজকঃ পুনৰপি তং পৃষ্টাৱান্ ৎৱং সচ্চিদানন্দস্য তনযো ঽভিষিক্তস্ত্ৰতা? ");
INSERT INTO sanasm_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","তদা যীশুস্তং প্ৰোৱাচ ভৱাম্যহম্ যূযঞ্চ সৰ্ৱ্ৱশক্তিমতো দক্ষীণপাৰ্শ্ৱে সমুপৱিশন্তং মেঘ মাৰুহ্য সমাযান্তঞ্চ মনুষ্যপুত্ৰং সন্দ্ৰক্ষ্যথ| ");
INSERT INTO sanasm_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","তদা মহাযাজকঃ স্ৱং ৱমনং ছিৎৱা ৱ্যাৱহৰৎ ");
INSERT INTO sanasm_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","কিমস্মাকং সাক্ষিভিঃ প্ৰযোজনম্? ঈশ্ৱৰনিন্দাৱাক্যং যুষ্মাভিৰশ্ৰাৱি কিং ৱিচাৰযথ? তদানীং সৰ্ৱ্ৱে জগদুৰযং নিধনদণ্ডমৰ্হতি| ");
INSERT INTO sanasm_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","ততঃ কশ্চিৎ কশ্চিৎ তদ্ৱপুষি নিষ্ঠীৱং নিচিক্ষেপ তথা তন্মুখমাচ্ছাদ্য চপেটেন হৎৱা গদিতৱান্ গণযিৎৱা ৱদ, অনুচৰাশ্চ চপেটৈস্তমাজঘ্নুঃ ");
INSERT INTO sanasm_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ততঃ পৰং পিতৰেঽট্টালিকাধঃকোষ্ঠে তিষ্ঠতি মহাযাজকস্যৈকা দাসী সমেত্য ");
INSERT INTO sanasm_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","তং ৱিহ্নিতাপং গৃহ্লন্তং ৱিলোক্য তং সুনিৰীক্ষ্য বভাষে ৎৱমপি নাসৰতীযযীশোঃ সঙ্গিনাম্ একো জন আসীঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","কিন্তু সোপহ্নুত্য জগাদ তমহং ন ৱদ্মি ৎৱং যৎ কথযমি তদপ্যহং ন বুদ্ধ্যে| তদানীং পিতৰে চৎৱৰং গতৱতি কুेক্কুটো ৰুৰাৱ| ");
INSERT INTO sanasm_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","অথান্যা দাসী পিতৰং দৃষ্ট্ৱা সমীপস্থান্ জনান্ জগাদ অযং তেষামেকো জনঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","ততঃ স দ্ৱিতীযৱাৰম্ অপহ্নুতৱান্ পশ্চাৎ তত্ৰস্থা লোকাঃ পিতৰং প্ৰোচুস্ত্ৱমৱশ্যং তেষামেকো জনঃ যতস্ত্ৱং গালীলীযো নৰ ইতি তৱোচ্চাৰণং প্ৰকাশযতি| ");
INSERT INTO sanasm_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","তদা স শপথাভিশাপৌ কৃৎৱা প্ৰোৱাচ যূযং কথাং কথযথ তং নৰং ন জানেঽহং| ");
INSERT INTO sanasm_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","তদানীং দ্ৱিতীযৱাৰং কুক্কুটো ঽৰাৱীৎ| কুক্কুটস্য দ্ৱিতীযৰৱাৎ পূৰ্ৱ্ৱং ৎৱং মাং ৱাৰত্ৰযম্ অপহ্নোষ্যসি, ইতি যদ্ৱাক্যং যীশুনা সমুদিতং তৎ তদা সংস্মৃত্য পিতৰো ৰোদিতুম্ আৰভত| ");
INSERT INTO sanasm_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","অথ প্ৰভাতে সতি প্ৰধানযাজকাঃ প্ৰাঞ্চ উপাধ্যাযাঃ সৰ্ৱ্ৱে মন্ত্ৰিণশ্চ সভাং কৃৎৱা যীশুृং বন্ধযিৎৱ পীলাতাখ্যস্য দেশাধিপতেঃ সৱিধং নীৎৱা সমৰ্পযামাসুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","তদা পীলাতস্তং পৃষ্টৱান্ ৎৱং কিং যিহূদীযলোকানাং ৰাজা? ততঃ স প্ৰত্যুক্তৱান্ সত্যং ৱদসি| ");
INSERT INTO sanasm_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","অপৰং প্ৰধানযাজকাস্তস্য বহুষু ৱাক্যেষু দোষমাৰোপযাঞ্চক্ৰুঃ কিন্তু স কিমপি ন প্ৰত্যুৱাচ| ");
INSERT INTO sanasm_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","তদানীং পীলাতস্তং পুনঃ পপ্ৰচ্ছ ৎৱং কিং নোত্তৰযসি? পশ্যৈতে ৎৱদ্ৱিৰুদ্ধং কতিষু সাধ্যেষু সাক্ষং দদতি| ");
INSERT INTO sanasm_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","কন্তু যীশুস্তদাপি নোত্তৰং দদৌ ততঃ পীলাত আশ্চৰ্য্যং জগাম| ");
INSERT INTO sanasm_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","অপৰঞ্চ কাৰাবদ্ধে কস্তিংশ্চিৎ জনে তন্মহোৎসৱকালে লোকৈ ৰ্যাচিতে দেশাধিপতিস্তং মোচযতি| ");
INSERT INTO sanasm_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","যে চ পূৰ্ৱ্ৱমুপপ্লৱমকাৰ্ষুৰুপপ্লৱে ৱধমপি কৃতৱন্তস্তেষাং মধ্যে তদানোং বৰব্বানামক একো বদ্ধ আসীৎ| ");
INSERT INTO sanasm_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","অতো হেতোঃ পূৰ্ৱ্ৱাপৰীযাং ৰীতিকথাং কথযিৎৱা লোকা উচ্চৈৰুৱন্তঃ পীলাতস্য সমক্ষং নিৱেদযামাসুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","তদা পীলাতস্তানাচখ্যৌ তৰ্হি কিং যিহূদীযানাং ৰাজানং মোচযিষ্যামি? যুষ্মাভিঃ কিমিষ্যতে? ");
INSERT INTO sanasm_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","যতঃ প্ৰধানযাজকা ঈৰ্ষ্যাত এৱ যীশুং সমাৰ্পযন্নিতি স ৱিৱেদ| ");
INSERT INTO sanasm_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","কিন্তু যথা বৰব্বাং মোচযতি তথা প্ৰাৰ্থযিতুং প্ৰধানযাজকা লোকান্ প্ৰৱৰ্ত্তযামাসুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","অথ পীলাতঃ পুনঃ পৃষ্টৱান্ তৰ্হি যং যিহূদীযানাং ৰাজেতি ৱদথ তস্য কিং কৰিষ্যামি যুষ্মাভিঃ কিমিষ্যতে? ");
INSERT INTO sanasm_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","তদা তে পুনৰপি প্ৰোচ্চৈঃ প্ৰোচুস্তং ক্ৰুশে ৱেধয| ");
INSERT INTO sanasm_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","তস্মাৎ পীলাতঃ কথিতৱান্ কুতঃ? স কিং কুকৰ্ম্ম কৃতৱান্? কিন্তু তে পুনশ্চ ৰুৱন্তো ৱ্যাজহ্ৰুস্তং ক্ৰুশে ৱেধয| ");
INSERT INTO sanasm_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","তদা পীলাতঃ সৰ্ৱ্ৱাল্লোকান্ তোষযিতুমিচ্ছন্ বৰব্বাং মোচযিৎৱা যীশুং কশাভিঃ প্ৰহৃত্য ক্ৰুশে ৱেদ্ধুং তং সমৰ্পযাম্বভূৱ| ");
INSERT INTO sanasm_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","অনন্তৰং সৈন্যগণোঽট্টালিকাম্ অৰ্থাদ্ অধিপতে ৰ্গৃহং যীশুং নীৎৱা সেনানিৱহং সমাহুযৎ| ");
INSERT INTO sanasm_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","পশ্চাৎ তে তং ধূমলৱৰ্ণৱস্ত্ৰং পৰিধাপ্য কণ্টকমুকুটং ৰচযিৎৱা শিৰসি সমাৰোপ্য ");
INSERT INTO sanasm_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","হে যিহূদীযানাং ৰাজন্ নমস্কাৰ ইত্যুক্ত্ৱা তং নমস্কৰ্ত্তামাৰেভিৰে| ");
INSERT INTO sanasm_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","তস্যোত্তমাঙ্গে ৱেত্ৰাঘাতং চক্ৰুস্তদ্গাত্ৰে নিষ্ঠীৱঞ্চ নিচিক্ষিপুঃ, তথা তস্য সম্মুখে জানুপাতং প্ৰণোমুঃ ");
INSERT INTO sanasm_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ইত্থমুপহস্য ধূম্ৰৱৰ্ণৱস্ত্ৰম্ উত্তাৰ্য্য তস্য ৱস্ত্ৰং তং পৰ্য্যধাপযন্ ক্ৰুশে ৱেদ্ধুং বহিৰ্নিন্যুশ্চ| ");
INSERT INTO sanasm_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","ততঃ পৰং সেকন্দৰস্য ৰুফস্য চ পিতা শিমোন্নামা কুৰীণীযলোক একঃ কুতশ্চিদ্ গ্ৰামাদেত্য পথি যাতি তং তে যীশোঃ ক্ৰুশং ৱোঢুং বলাদ্ দধ্নুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","অথ গুল্গল্তা অৰ্থাৎ শিৰঃকপালনামকং স্থানং যীশুমানীয ");
INSERT INTO sanasm_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","তে গন্ধৰসমিশ্ৰিতং দ্ৰাক্ষাৰসং পাতুং তস্মৈ দদুঃ কিন্তু স ন জগ্ৰাহ| ");
INSERT INTO sanasm_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","তস্মিন্ ক্ৰুশে ৱিদ্ধে সতি তেষামেকৈকশঃ কিং প্ৰাপ্স্যতীতি নিৰ্ণযায ");
INSERT INTO sanasm_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","তস্য পৰিধেযানাং ৱিভাগাৰ্থং গুটিকাপাতং চক্ৰুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","অপৰম্ এষ যিহূদীযানাং ৰাজেতি লিখিতং দোষপত্ৰং তস্য শিৰঊৰ্দ্ৱ্ৱম্ আৰোপযাঞ্চক্ৰুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","তস্য ৱামদক্ষিণযো ৰ্দ্ৱৌ চৌৰৌ ক্ৰুশযো ৰ্ৱিৱিধাতে| ");
INSERT INTO sanasm_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","তেনৈৱ \"অপৰাধিজনৈঃ সাৰ্দ্ধং স গণিতো ভৱিষ্যতি,\" ইতি শাস্ত্ৰোক্তং ৱচনং সিদ্ধমভূত| ");
INSERT INTO sanasm_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","অনন্তৰং মাৰ্গে যে যে লোকা গমনাগমনে চক্ৰুস্তে সৰ্ৱ্ৱ এৱ শিৰাংস্যান্দোল্য নিন্দন্তো জগদুঃ, ৰে মন্দিৰনাশক ৰে দিনত্ৰযমধ্যে তন্নিৰ্ম্মাযক, ");
INSERT INTO sanasm_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","অধুনাত্মানম্ অৱিৎৱা ক্ৰুশাদৱৰোহ| ");
INSERT INTO sanasm_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","কিঞ্চ প্ৰধানযাজকা অধ্যাপকাশ্চ তদ্ৱৎ তিৰস্কৃত্য পৰস্পৰং চচক্ষিৰে এষ পৰানাৱৎ কিন্তু স্ৱমৱিতুং ন শক্নোতি| ");
INSERT INTO sanasm_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","যদীস্ৰাযেলো ৰাজাভিষিক্তস্ত্ৰাতা ভৱতি তৰ্হ্যধুনৈন ক্ৰুশাদৱৰোহতু ৱযং তদ্ দৃষ্ট্ৱা ৱিশ্ৱসিষ্যামঃ; কিঞ্চ যৌ লোকৌ তেন সাৰ্দ্ধং ক্ৰুশে ঽৱিধ্যেতাং তাৱপি তং নিৰ্ভৰ্ত্সযামাসতুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","অথ দ্ৱিতীযযামাৎ তৃতীযযামং যাৱৎ সৰ্ৱ্ৱো দেশঃ সান্ধকাৰোভূৎ| ");
INSERT INTO sanasm_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ততস্তৃতীযপ্ৰহৰে যীশুৰুচ্চৈৰৱদৎ এলী এলী লামা শিৱক্তনী অৰ্থাদ্ \"হে মদীশ মদীশ ৎৱং পৰ্য্যত্যাক্ষীঃ কুতো হি মাং?\" ");
INSERT INTO sanasm_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","তদা সমীপস্থলোকানাং কেচিৎ তদ্ৱাক্যং নিশম্যাচখ্যুঃ পশ্যৈষ এলিযম্ আহূযতি| ");
INSERT INTO sanasm_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","তত একো জনো ধাৱিৎৱাগত্য স্পঞ্জে ঽম্লৰসং পূৰযিৎৱা তং নডাগ্ৰে নিধায পাতুং তস্মৈ দত্ত্ৱাৱদৎ তিষ্ঠ এলিয এনমৱৰোহযিতুম্ এতি ন ৱেতি পশ্যামি| ");
INSERT INTO sanasm_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","অথ যীশুৰুচ্চৈঃ সমাহূয প্ৰাণান্ জহৌ| ");
INSERT INTO sanasm_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","তদা মন্দিৰস্য জৱনিকোৰ্দ্ৱ্ৱাদধঃৰ্য্যন্তা ৱিদীৰ্ণা দ্ৱিখণ্ডাভূৎ| ");
INSERT INTO sanasm_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","কিঞ্চ ইত্থমুচ্চৈৰাহূয প্ৰাণান্ ত্যজন্তং তং দৃষ্দ্ৱা তদ্ৰক্ষণায নিযুক্তো যঃ সেনাপতিৰাসীৎ সোৱদৎ নৰোযম্ ঈশ্ৱৰপুত্ৰ ইতি সত্যম্| ");
INSERT INTO sanasm_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","তদানীং মগ্দলীনী মৰিসম্ কনিষ্ঠযাকূবো যোসেশ্চ মাতান্যমৰিযম্ শালোমী চ যাঃ স্ত্ৰিযো ");
INSERT INTO sanasm_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","গালীল্প্ৰদেশে যীশুং সেৱিৎৱা তদনুগামিন্যো জাতা ইমাস্তদন্যাশ্চ যা অনেকা নাৰ্যো যীশুনা সাৰ্দ্ধং যিৰূশালমমাযাতাস্তাশ্চ দূৰাৎ তানি দদৃশুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","অথাসাদনদিনস্যাৰ্থাদ্ ৱিশ্ৰামৱাৰাৎ পূৰ্ৱ্ৱদিনস্য সাযংকাল আগত ");
INSERT INTO sanasm_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ঈশ্ৱৰৰাজ্যাপেক্ষ্যৰিমথীযযূষফনামা মান্যমন্ত্ৰী সমেত্য পীলাতসৱিধং নিৰ্ভযো গৎৱা যীশোৰ্দেহং যযাচে| ");
INSERT INTO sanasm_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","কিন্তু স ইদানীং মৃতঃ পীলাত ইত্যসম্ভৱং মৎৱা শতসেনাপতিমাহূয স কদা মৃত ইতি পপ্ৰচ্ছ| ");
INSERT INTO sanasm_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","শতসেমনাপতিমুখাৎ তজ্জ্ঞাৎৱা যূষফে যীশোৰ্দেহং দদৌ| ");
INSERT INTO sanasm_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","পশ্চাৎ স সূক্ষ্মং ৱাসঃ ক্ৰীৎৱা যীশোঃ কাযমৱৰোহ্য তেন ৱাসসা ৱেষ্টাযিৎৱা গিৰৌ খাতশ্মশানে স্থাপিতৱান্ পাষাণং লোঠযিৎৱা দ্ৱাৰি নিদধে| ");
INSERT INTO sanasm_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","কিন্তু যত্ৰ সোস্থাপ্যত তত মগ্দলীনী মৰিযম্ যোসিমাতৃমৰিযম্ চ দদৃশতৃঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","অথ ৱিশ্ৰামৱাৰে গতে মগ্দলীনী মৰিযম্ যাকূবমাতা মৰিযম্ শালোমী চেমাস্তং মৰ্দ্দযিতুং সুগন্ধিদ্ৰৱ্যাণি ক্ৰীৎৱা ");
INSERT INTO sanasm_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","সপ্তাহপ্ৰথমদিনেঽতিপ্ৰত্যূষে সূৰ্য্যোদযকালে শ্মশানমুপগতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","কিন্তু শ্মশানদ্ৱাৰপাষাণোঽতিবৃহন্ তং কোঽপসাৰযিষ্যতীতি তাঃ পৰস্পৰং গদন্তি! ");
INSERT INTO sanasm_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","এতৰ্হি নিৰীক্ষ্য পাষাণো দ্ৱাৰো ঽপসাৰিত ইতি দদৃশুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","পশ্চাত্তাঃ শ্মশানং প্ৰৱিশ্য শুক্লৱৰ্ণদীৰ্ঘপৰিচ্ছদাৱৃতমেকং যুৱানং শ্মশানদক্ষিণপাৰ্শ্ৱ উপৱিষ্টং দৃষ্ট্ৱা চমচ্চক্ৰুঃ| ");
INSERT INTO sanasm_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","সোঽৱদৎ, মাভৈষ্ট যূযং ক্ৰুশে হতং নাসৰতীযযীশুং গৱেষযথ সোত্ৰ নাস্তি শ্মশানাদুদস্থাৎ; তৈ ৰ্যত্ৰ স স্থাপিতঃ স্থানং তদিদং পশ্যত| ");
INSERT INTO sanasm_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","কিন্তু তেন যথোক্তং তথা যুষ্মাকমগ্ৰে গালীলং যাস্যতে তত্ৰ স যুষ্মান্ সাক্ষাৎ কৰিষ্যতে যূযং গৎৱা তস্য শিষ্যেভ্যঃ পিতৰায চ ৱাৰ্ত্তামিমাং কথযত| ");
INSERT INTO sanasm_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","তাঃ কম্পিতা ৱিস্তিতাশ্চ তূৰ্ণং শ্মশানাদ্ বহিৰ্গৎৱা পলাযন্ত ভযাৎ কমপি কিমপি নাৱদংশ্চ| ");
INSERT INTO sanasm_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","অপৰং যীশুঃ সপ্তাহপ্ৰথমদিনে প্ৰত্যূষে শ্মশানাদুত্থায যস্যাঃ সপ্তভূতাস্ত্যাজিতাস্তস্যৈ মগ্দলীনীমৰিযমে প্ৰথমং দৰ্শনং দদৌ| ");
INSERT INTO sanasm_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ততঃ সা গৎৱা শোকৰোদনকৃদ্ভ্যোঽনুগতলোকেভ্যস্তাং ৱাৰ্ত্তাং কথযামাস| ");
INSERT INTO sanasm_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","কিন্তু যীশুঃ পুনৰ্জীৱন্ তস্যৈ দৰ্শনং দত্তৱানিতি শ্ৰুৎৱা তে ন প্ৰত্যযন্| ");
INSERT INTO sanasm_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","পশ্চাৎ তেষাং দ্ৱাযো ৰ্গ্ৰামযানকালে যীশুৰন্যৱেশং ধৃৎৱা তাভ্যাং দৰ্শন দদৌ! ");
INSERT INTO sanasm_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","তাৱপি গৎৱান্যশিষ্যেভ্যস্তাং কথাং কথযাঞ্চক্ৰতুঃ কিন্তু তযোঃ কথামপি তে ন প্ৰত্যযন্| ");
INSERT INTO sanasm_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","শেষত একাদশশিষ্যেষু ভোজনোপৱিষ্টেষু যীশুস্তেভ্যো দৰ্শনং দদৌ তথোত্থানাৎ পৰং তদ্দৰ্শনপ্ৰাপ্তলোকানাং কথাযামৱিশ্ৱাসকৰণাৎ তেষামৱিশ্ৱাসমনঃকাঠিন্যাভ্যাং হেতুভ্যাং স তাংস্তৰ্জিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","অথ তানাচখ্যৌ যূযং সৰ্ৱ্ৱজগদ্ গৎৱা সৰ্ৱ্ৱজনান্ প্ৰতি সুসংৱাদং প্ৰচাৰযত| ");
INSERT INTO sanasm_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","তত্ৰ যঃ কশ্চিদ্ ৱিশ্ৱস্য মজ্জিতো ভৱেৎ স পৰিত্ৰাস্যতে কিন্তু যো ন ৱিশ্ৱসিষ্যতি স দণ্ডযিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","কিঞ্চ যে প্ৰত্যেষ্যন্তি তৈৰীদৃগ্ আশ্চৰ্য্যং কৰ্ম্ম প্ৰকাশযিষ্যতে তে মন্নাম্না ভূতান্ ত্যাজযিষ্যন্তি ভাষা অন্যাশ্চ ৱদিষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","অপৰং তৈঃ সৰ্পেষু ধৃতেষু প্ৰাণনাশকৱস্তুনি পীতে চ তেষাং কাপি ক্ষতি ৰ্ন ভৱিষ্যতি; ৰোগিণাং গাত্ৰেষু কৰাৰ্পিতে তেঽৰোগা ভৱিষ্যন্তি চ| ");
INSERT INTO sanasm_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","অথ প্ৰভুস্তানিত্যাদিশ্য স্ৱৰ্গং নীতঃ সন্ পৰমেশ্ৱৰস্য দক্ষিণ উপৱিৱেশ| ");
INSERT INTO sanasm_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ততস্তে প্ৰস্থায সৰ্ৱ্ৱত্ৰ সুসংৱাদীযকথাং প্ৰচাৰযিতুমাৰেভিৰে প্ৰভুস্তু তেষাং সহাযঃ সন্ প্ৰকাশিতাশ্চৰ্য্যক্ৰিযাভিস্তাং কথাং প্ৰমাণৱতীং চকাৰ| ইতি|");
INSERT INTO sanasm_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","প্ৰথমতো যে সাক্ষিণো ৱাক্যপ্ৰচাৰকাশ্চাসন্ তেঽস্মাকং মধ্যে যদ্যৎ সপ্ৰমাণং ৱাক্যমৰ্পযন্তি স্ম ");
INSERT INTO sanasm_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","তদনুসাৰতোঽন্যেপি বহৱস্তদ্ৱৃত্তান্তং ৰচযিতুং প্ৰৱৃত্তাঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","অতএৱ হে মহামহিমথিযফিল্ ৎৱং যা যাঃ কথা অশিক্ষ্যথাস্তাসাং দৃঢপ্ৰমাণানি যথা প্ৰাপ্নোষি ");
INSERT INTO sanasm_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","তদৰ্থং প্ৰথমমাৰভ্য তানি সৰ্ৱ্ৱাণি জ্ঞাৎৱাহমপি অনুক্ৰমাৎ সৰ্ৱ্ৱৱৃত্তান্তান্ তুভ্যং লেখিতুং মতিমকাৰ্ষম্| ");
INSERT INTO sanasm_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","যিহূদাদেশীযহেৰোদ্নামকে ৰাজৎৱং কুৰ্ৱ্ৱতি অবীযযাজকস্য পৰ্য্যাযাধিকাৰী সিখৰিযনামক একো যাজকো হাৰোণৱংশোদ্ভৱা ইলীশেৱাখ্যা ");
INSERT INTO sanasm_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","তস্য জাযা দ্ৱাৱিমৌ নিৰ্দোষৌ প্ৰভোঃ সৰ্ৱ্ৱাজ্ঞা ৱ্যৱস্থাশ্চ সংমন্য ঈশ্ৱৰদৃষ্টৌ ধাৰ্ম্মিকাৱাস্তাম্| ");
INSERT INTO sanasm_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","তযোঃ সন্তান একোপি নাসীৎ, যত ইলীশেৱা বন্ধ্যা তৌ দ্ৱাৱেৱ ৱৃদ্ধাৱভৱতাম্| ");
INSERT INTO sanasm_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","যদা স্ৱপৰ্য্যানুক্ৰমেণ সিখৰিয ঈশ্ৱাস্য সমক্ষং যাজকীযং কৰ্ম্ম কৰোতি ");
INSERT INTO sanasm_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","তদা যজ্ঞস্য দিনপৰিপায্যা পৰমেশ্ৱৰস্য মন্দিৰে প্ৰৱেশকালে ধূপজ্ৱালনং কৰ্ম্ম তস্য কৰণীযমাসীৎ| ");
INSERT INTO sanasm_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","তদ্ধূপজ্ৱালনকালে লোকনিৱহে প্ৰাৰ্থনাং কৰ্তুং বহিস্তিষ্ঠতি ");
INSERT INTO sanasm_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","সতি সিখৰিযো যস্যাং ৱেদ্যাং ধূপং জ্ৱালযতি তদ্দক্ষিণপাৰ্শ্ৱে পৰমেশ্ৱৰস্য দূত এক উপস্থিতো দৰ্শনং দদৌ| ");
INSERT INTO sanasm_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","তং দৃষ্ট্ৱা সিখৰিয উদ্ৱিৱিজে শশঙ্কে চ| ");
INSERT INTO sanasm_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","তদা স দূতস্তং বভাষে হে সিখৰিয মা ভৈস্তৱ প্ৰাৰ্থনা গ্ৰাহ্যা জাতা তৱ ভাৰ্য্যা ইলীশেৱা পুত্ৰং প্ৰসোষ্যতে তস্য নাম যোेহন্ ইতি কৰিষ্যসি| ");
INSERT INTO sanasm_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","কিঞ্চ ৎৱং সানন্দঃ সহৰ্ষশ্চ ভৱিষ্যসি তস্য জন্মনি বহৱ আনন্দিষ্যন্তি চ| ");
INSERT INTO sanasm_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","যতো হেতোঃ স পৰমেশ্ৱৰস্য গোচৰে মহান্ ভৱিষ্যতি তথা দ্ৰাক্ষাৰসং সুৰাং ৱা কিমপি ন পাস্যতি, অপৰং জন্মাৰভ্য পৱিত্ৰেণাত্মনা পৰিপূৰ্ণঃ ");
INSERT INTO sanasm_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","সন্ ইস্ৰাযেল্ৱংশীযান্ অনেকান্ প্ৰভোঃ পৰমেশ্ৱৰস্য মাৰ্গমানেষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","সন্তানান্ প্ৰতি পিতৃণাং মনাংসি ধৰ্ম্মজ্ঞানং প্ৰত্যনাজ্ঞাগ্ৰাহিণশ্চ পৰাৱৰ্ত্তযিতুং, প্ৰভোঃ পৰমেশ্ৱৰস্য সেৱাৰ্থম্ একাং সজ্জিতজাতিং ৱিধাতুঞ্চ স এলিযৰূপাত্মশক্তিপ্ৰাপ্তস্তস্যাগ্ৰে গমিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","তদা সিখৰিযো দূতমৱাদীৎ কথমেতদ্ ৱেৎস্যামি? যতোহং ৱৃদ্ধো মম ভাৰ্য্যা চ ৱৃদ্ধা| ");
INSERT INTO sanasm_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ততো দূতঃ প্ৰত্যুৱাচ পশ্যেশ্ৱৰস্য সাক্ষাদ্ৱৰ্ত্তী জিব্ৰাযেল্নামা দূতোহং ৎৱযা সহ কথাং গদিতুং তুভ্যমিমাং শুভৱাৰ্ত্তাং দাতুঞ্চ প্ৰেষিতঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","কিন্তু মদীযং ৱাক্যং কালে ফলিষ্যতি তৎ ৎৱযা ন প্ৰতীতম্ অতঃ কাৰণাদ্ যাৱদেৱ তানি ন সেৎস্যন্তি তাৱৎ ৎৱং ৱক্তুংমশক্তো মূকো ভৱ| ");
INSERT INTO sanasm_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","তদানীং যে যে লোকাঃ সিখৰিযমপৈক্ষন্ত তে মধ্যেমন্দিৰং তস্য বহুৱিলম্বাদ্ আশ্চৰ্য্যং মেনিৰে| ");
INSERT INTO sanasm_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","স বহিৰাগতো যদা কিমপি ৱাক্যং ৱক্তুমশক্তঃ সঙ্কেতং কৃৎৱা নিঃশব্দস্তস্যৌ তদা মধ্যেমন্দিৰং কস্যচিদ্ দৰ্শনং তেন প্ৰাপ্তম্ ইতি সৰ্ৱ্ৱে বুবুধিৰে| ");
INSERT INTO sanasm_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","অনন্তৰং তস্য সেৱনপৰ্য্যাযে সম্পূৰ্ণে সতি স নিজগেহং জগাম| ");
INSERT INTO sanasm_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","কতিপযদিনেষু গতেষু তস্য ভাৰ্য্যা ইলীশেৱা গৰ্ব্ভৱতী বভূৱ ");
INSERT INTO sanasm_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","পশ্চাৎ সা পঞ্চমাসান্ সংগোপ্যাকথযৎ লোকানাং সমক্ষং মমাপমানং খণ্ডযিতুং পৰমেশ্ৱৰো মযি দৃষ্টিং পাতযিৎৱা কৰ্ম্মেদৃশং কৃতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","অপৰঞ্চ তস্যা গৰ্ব্ভস্য ষষ্ঠে মাসে জাতে গালীল্প্ৰদেশীযনাসৰৎপুৰে ");
INSERT INTO sanasm_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","দাযূদো ৱংশীযায যূষফ্নাম্নে পুৰুষায যা মৰিযম্নামকুমাৰী ৱাগ্দত্তাসীৎ তস্যাঃ সমীপং জিব্ৰাযেল্ দূত ঈশ্ৱৰেণ প্ৰহিতঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","স গৎৱা জগাদ হে ঈশ্ৱৰানুগৃহীতকন্যে তৱ শুভং ভূযাৎ প্ৰভুঃ পৰমেশ্ৱৰস্তৱ সহাযোস্তি নাৰীণাং মধ্যে ৎৱমেৱ ধন্যা| ");
INSERT INTO sanasm_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","তদানীং সা তং দৃষ্ট্ৱা তস্য ৱাক্যত উদ্ৱিজ্য কীদৃশং ভাষণমিদম্ ইতি মনসা চিন্তযামাস| ");
INSERT INTO sanasm_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ততো দূতোঽৱদৎ হে মৰিযম্ ভযং মাকাৰ্ষীঃ, ৎৱযি পৰমেশ্ৱৰস্যানুগ্ৰহোস্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","পশ্য ৎৱং গৰ্ব্ভং ধৃৎৱা পুত্ৰং প্ৰসোষ্যসে তস্য নাম যীশুৰিতি কৰিষ্যসি| ");
INSERT INTO sanasm_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","স মহান্ ভৱিষ্যতি তথা সৰ্ৱ্ৱেভ্যঃ শ্ৰেষ্ঠস্য পুত্ৰ ইতি খ্যাস্যতি; অপৰং প্ৰভুঃ পৰমেশ্ৱৰস্তস্য পিতুৰ্দাযূদঃ সিংহাসনং তস্মৈ দাস্যতি; ");
INSERT INTO sanasm_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","তথা স যাকূবো ৱংশোপৰি সৰ্ৱ্ৱদা ৰাজৎৱং কৰিষ্যতি, তস্য ৰাজৎৱস্যান্তো ন ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","তদা মৰিযম্ তং দূতং বভাষে নাহং পুৰুষসঙ্গং কৰোমি তৰ্হি কথমেতৎ সম্ভৱিষ্যতি? ");
INSERT INTO sanasm_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ততো দূতোঽকথযৎ পৱিত্ৰ আত্মা ৎৱামাশ্ৰাযিষ্যতি তথা সৰ্ৱ্ৱশ্ৰেষ্ঠস্য শক্তিস্তৱোপৰি ছাযাং কৰিষ্যতি ততো হেতোস্তৱ গৰ্ব্ভাদ্ যঃ পৱিত্ৰবালকো জনিষ্যতে স ঈশ্ৱৰপুত্ৰ ইতি খ্যাতিং প্ৰাপ্স্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","অপৰঞ্চ পশ্য তৱ জ্ঞাতিৰিলীশেৱা যাং সৰ্ৱ্ৱে বন্ধ্যামৱদন্ ইদানীং সা ৱাৰ্দ্ধক্যে সন্তানমেকং গৰ্ব্ভেঽধাৰযৎ তস্য ষষ্ঠমাসোভূৎ| ");
INSERT INTO sanasm_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","কিমপি কৰ্ম্ম নাসাধ্যম্ ঈশ্ৱৰস্য| ");
INSERT INTO sanasm_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","তদা মৰিযম্ জগাদ, পশ্য প্ৰভেৰহং দাসী মহ্যং তৱ ৱাক্যানুসাৰেণ সৰ্ৱ্ৱমেতদ্ ঘটতাম্; অননতৰং দূতস্তস্যাঃ সমীপাৎ প্ৰতস্থে| ");
INSERT INTO sanasm_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","অথ কতিপযদিনাৎ পৰং মৰিযম্ তস্মাৎ পৰ্ৱ্ৱতমযপ্ৰদেশীযযিহূদাযা নগৰমেকং শীঘ্ৰং গৎৱা ");
INSERT INTO sanasm_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","সিখৰিযযাজকস্য গৃহং প্ৰৱিশ্য তস্য জাযাম্ ইলীশেৱাং সম্বোধ্যাৱদৎ| ");
INSERT INTO sanasm_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ততো মৰিযমঃ সম্বোধনৱাক্যে ইলীশেৱাযাঃ কৰ্ণযোঃ প্ৰৱিষ্টমাত্ৰে সতি তস্যা গৰ্ব্ভস্থবালকো ননৰ্ত্ত| তত ইলীশেৱা পৱিত্ৰেণাত্মনা পৰিপূৰ্ণা সতী ");
INSERT INTO sanasm_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","প্ৰোচ্চৈৰ্গদিতুমাৰেভে, যোষিতাং মধ্যে ৎৱমেৱ ধন্যা, তৱ গৰ্ব্ভস্থঃ শিশুশ্চ ধন্যঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ৎৱং প্ৰভোৰ্মাতা, মম নিৱেশনে ৎৱযা চৰণাৱৰ্পিতৌ, মমাদ্য সৌভাগ্যমেতৎ| ");
INSERT INTO sanasm_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","পশ্য তৱ ৱাক্যে মম কৰ্ণযোঃ প্ৰৱিষ্টমাত্ৰে সতি মমোদৰস্থঃ শিশুৰানন্দান্ ননৰ্ত্ত| ");
INSERT INTO sanasm_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","যা স্ত্ৰী ৱ্যশ্ৱসীৎ সা ধন্যা, যতো হেতোস্তাং প্ৰতি পৰমেশ্ৱৰোক্তং ৱাক্যং সৰ্ৱ্ৱং সিদ্ধং ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","তদানীং মৰিযম্ জগাদ| ধন্যৱাদং পৰেশস্য কৰোতি মামকং মনঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","মমাত্মা তাৰকেশে চ সমুল্লাসং প্ৰগচ্ছতি| ");
INSERT INTO sanasm_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","অকৰোৎ স প্ৰভু ৰ্দুষ্টিং স্ৱদাস্যা দুৰ্গতিং প্ৰতি| পশ্যাদ্যাৰভ্য মাং ধন্যাং ৱক্ষ্যন্তি পুৰুষাঃ সদা| ");
INSERT INTO sanasm_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","যঃ সৰ্ৱ্ৱশক্তিমান্ যস্য নামাপি চ পৱিত্ৰকং| স এৱ সুমহৎকৰ্ম্ম কৃতৱান্ মন্নিমিত্তকং| ");
INSERT INTO sanasm_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","যে বিভ্যতি জনাস্তস্মাৎ তেষাং সন্তানপংক্তিষু| অনুকম্পা তদীযা চ সৰ্ৱ্ৱদৈৱ সুতিষ্ঠতি| ");
INSERT INTO sanasm_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","স্ৱবাহুবলতস্তেন প্ৰাকাশ্যত পৰাক্ৰমঃ| মনঃকুমন্ত্ৰণাসাৰ্দ্ধং ৱিকীৰ্য্যন্তেঽভিমানিনঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","সিংহাসনগতাল্লোকান্ বলিনশ্চাৱৰোহ্য সঃ| পদেষূচ্চেষু লোকাংস্তু ক্ষুদ্ৰান্ সংস্থাপযত্যপি| ");
INSERT INTO sanasm_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ক্ষুধিতান্ মানৱান্ দ্ৰৱ্যৈৰুত্তমৈঃ পৰিতৰ্প্য সঃ| সকলান্ ধনিনো লোকান্ ৱিসৃজেদ্ ৰিক্তহস্তকান্| ");
INSERT INTO sanasm_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ইব্ৰাহীমি চ তদ্ৱংশে যা দযাস্তি সদৈৱ তাং| স্মৃৎৱা পুৰা পিতৃণাং নো যথা সাক্ষাৎ প্ৰতিশ্ৰুতং| ");
INSERT INTO sanasm_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ইস্ৰাযেল্সেৱকস্তেন তথোপক্ৰিযতে স্ৱযং|| ");
INSERT INTO sanasm_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","অনন্তৰং মৰিযম্ প্ৰাযেণ মাসত্ৰযম্ ইলীশেৱযা সহোষিৎৱা ৱ্যাঘুয্য নিজনিৱেশনং যযৌ| ");
INSERT INTO sanasm_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","তদনন্তৰম্ ইলীশেৱাযাঃ প্ৰসৱকাল উপস্থিতে সতি সা পুত্ৰং প্ৰাসোষ্ট| ");
INSERT INTO sanasm_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ততঃ পৰমেশ্ৱৰস্তস্যাং মহানুগ্ৰহং কৃতৱান্ এতৎ শ্ৰুৎৱা সমীপৱাসিনঃ কুটুম্বাশ্চাগত্য তযা সহ মুমুদিৰে| ");
INSERT INTO sanasm_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","তথাষ্টমে দিনে তে বালকস্য ৎৱচং ছেত্তুম্ এত্য তস্য পিতৃনামানুৰূপং তন্নাম সিখৰিয ইতি কৰ্ত্তুমীষুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","কিন্তু তস্য মাতাকথযৎ তন্ন, নামাস্য যোহন্ ইতি কৰ্ত্তৱ্যম্| ");
INSERT INTO sanasm_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","তদা তে ৱ্যাহৰন্ তৱ ৱংশমধ্যে নামেদৃশং কস্যাপি নাস্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ততঃ পৰং তস্য পিতৰং সিখৰিযং প্ৰতি সঙ্কেত্য পপ্ৰচ্ছুঃ শিশোঃ কিং নাম কাৰিষ্যতে? ");
INSERT INTO sanasm_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ততঃ স ফলকমেকং যাচিৎৱা লিলেখ তস্য নাম যোহন্ ভৱিষ্যতি| তস্মাৎ সৰ্ৱ্ৱে আশ্চৰ্য্যং মেনিৰে| ");
INSERT INTO sanasm_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","তৎক্ষণং সিখৰিযস্য জিহ্ৱাজাড্যেঽপগতে স মুখং ৱ্যাদায স্পষ্টৱৰ্ণমুচ্চাৰ্য্য ঈশ্ৱৰস্য গুণানুৱাদং চকাৰ| ");
INSERT INTO sanasm_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","তস্মাচ্চতুৰ্দিক্স্থাঃ সমীপৱাসিলোকা ভীতা এৱমেতাঃ সৰ্ৱ্ৱাঃ কথা যিহূদাযাঃ পৰ্ৱ্ৱতমযপ্ৰদেশস্য সৰ্ৱ্ৱত্ৰ প্ৰচাৰিতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","তস্মাৎ শ্ৰোতাৰো মনঃসু স্থাপযিৎৱা কথযাম্বভূৱুঃ কীদৃশোযং বালো ভৱিষ্যতি? অথ পৰমেশ্ৱৰস্তস্য সহাযোভূৎ| ");
INSERT INTO sanasm_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","তদা যোহনঃ পিতা সিখৰিযঃ পৱিত্ৰেণাত্মনা পৰিপূৰ্ণঃ সন্ এতাদৃশং ভৱিষ্যদ্ৱাক্যং কথযামাস| ");
INSERT INTO sanasm_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","ইস্ৰাযেলঃ প্ৰভু ৰ্যস্তু স ধন্যঃ পৰমেশ্ৱৰঃ| অনুগৃহ্য নিজাল্লোকান্ স এৱ পৰিমোচযেৎ| ");
INSERT INTO sanasm_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ৱিপক্ষজনহস্তেভ্যো যথা মোচ্যামহে ৱযং| যাৱজ্জীৱঞ্চ ধৰ্ম্মেণ সাৰল্যেন চ নিৰ্ভযাঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","সেৱামহৈ তমেৱৈকম্ এতৎকাৰণমেৱ চ| স্ৱকীযং সুপৱিত্ৰঞ্চ সংস্মৃত্য নিযমং সদা| ");
INSERT INTO sanasm_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","কৃপযা পুৰুষান্ পূৰ্ৱ্ৱান্ নিকষাৰ্থাত্তু নঃ পিতুঃ| ইব্ৰাহীমঃ সমীপে যং শপথং কৃতৱান্ পুৰা| ");
INSERT INTO sanasm_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","তমেৱ সফলং কৰ্ত্তং তথা শত্ৰুগণস্য চ| ঋृতীযাকাৰিণশ্চৈৱ কৰেভ্যো ৰক্ষণায নঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","সৃষ্টেঃ প্ৰথমতঃ স্ৱীযৈঃ পৱিত্ৰৈ ৰ্ভাৱিৱাদিভিঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","যথোক্তৱান্ তথা স্ৱস্য দাযূদঃ সেৱকস্য তু| ");
INSERT INTO sanasm_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ৱংশে ত্ৰাতাৰমেকং স সমুৎপাদিতৱান্ স্ৱযম্| ");
INSERT INTO sanasm_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","অতো হে বালক ৎৱন্তু সৰ্ৱ্ৱেভ্যঃ শ্ৰেষ্ঠ এৱ যঃ| তস্যৈৱ ভাৱিৱাদীতি প্ৰৱিখ্যাতো ভৱিষ্যসি| অস্মাকং চৰণান্ ক্ষেমে মাৰ্গে চালযিতুং সদা| এৱং ধ্ৱান্তেঽৰ্থতো মৃত্যোশ্ছাযাযাং যে তু মানৱাঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","উপৱিষ্টাস্তু তানেৱ প্ৰকাশযিতুমেৱ হি| কৃৎৱা মহানুকম্পাং হি যামেৱ পৰমেশ্ৱৰঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ঊৰ্দ্ৱ্ৱাৎ সূৰ্য্যমুদায্যৈৱাস্মভ্যং প্ৰাদাত্তু দৰ্শনং| তযানুকম্পযা স্ৱস্য লোকানাং পাপমোচনে| ");
INSERT INTO sanasm_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","পৰিত্ৰাণস্য তেভ্যো হি জ্ঞানৱিশ্ৰাণনায চ| প্ৰভো ৰ্মাৰ্গং পৰিষ্কৰ্ত্তুং তস্যাগ্ৰাযী ভৱিষ্যসি|| ");
INSERT INTO sanasm_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","অথ বালকঃ শৰীৰেণ বুদ্ধ্যা চ ৱৰ্দ্ধিতুমাৰেভে; অপৰঞ্চ স ইস্ৰাযেলো ৱংশীযলোকানাং সমীপে যাৱন্ন প্ৰকটীভূতস্তাস্তাৱৎ প্ৰান্তৰে ন্যৱসৎ| ");
INSERT INTO sanasm_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","অপৰঞ্চ তস্মিন্ কালে ৰাজ্যস্য সৰ্ৱ্ৱেষাং লোকানাং নামানি লেখযিতুম্ অগস্তকৈসৰ আজ্ঞাপযামাস| ");
INSERT INTO sanasm_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","তদনুসাৰেণ কুৰীণিযনামনি সুৰিযাদেশস্য শাসকে সতি নামলেখনং প্ৰাৰেভে| ");
INSERT INTO sanasm_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","অতো হেতো ৰ্নাম লেখিতুং সৰ্ৱ্ৱে জনাঃ স্ৱীযং স্ৱীযং নগৰং জগ্মুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","তদানীং যূষফ্ নাম লেখিতুং ৱাগ্দত্তযা স্ৱভাৰ্য্যযা গৰ্ব্ভৱত্যা মৰিযমা সহ স্ৱযং দাযূদঃ সজাতিৱংশ ইতি কাৰণাদ্ গালীল্প্ৰদেশস্য নাসৰত্নগৰাদ্ ");
INSERT INTO sanasm_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","যিহূদাপ্ৰদেশস্য বৈৎলেহমাখ্যং দাযূদ্নগৰং জগাম| ");
INSERT INTO sanasm_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","অন্যচ্চ তত্ৰ স্থানে তযোস্তিষ্ঠতোঃ সতো ৰ্মৰিযমঃ প্ৰসূতিকাল উপস্থিতে ");
INSERT INTO sanasm_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","সা তং প্ৰথমসুতং প্ৰাসোষ্ট কিন্তু তস্মিন্ ৱাসগৃহে স্থানাভাৱাদ্ বালকং ৱস্ত্ৰেণ ৱেষ্টযিৎৱা গোশালাযাং স্থাপযামাস| ");
INSERT INTO sanasm_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","অনন্তৰং যে কিযন্তো মেষপালকাঃ স্ৱমেষৱ্ৰজৰক্ষাযৈ তৎপ্ৰদেশে স্থিৎৱা ৰজন্যাং প্ৰান্তৰে প্ৰহৰিণঃ কৰ্ম্ম কুৰ্ৱ্ৱন্তি, ");
INSERT INTO sanasm_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","তেষাং সমীপং পৰমেশ্ৱৰস্য দূত আগত্যোপতস্থৌ; তদা চতুষ্পাৰ্শ্ৱে পৰমেশ্ৱৰস্য তেজসঃ প্ৰকাশিতৎৱাৎ তেঽতিশশঙ্কিৰে| ");
INSERT INTO sanasm_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","তদা স দূত উৱাচ মা ভৈষ্ট পশ্যতাদ্য দাযূদঃ পুৰে যুষ্মন্নিমিত্তং ত্ৰাতা প্ৰভুঃ খ্ৰীষ্টোঽজনিষ্ট, ");
INSERT INTO sanasm_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","সৰ্ৱ্ৱেষাং লোকানাং মহানন্দজনকম্ ইমং মঙ্গলৱৃত্তান্তং যুষ্মান্ জ্ঞাপযামি| ");
INSERT INTO sanasm_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","যূযং (তৎস্থানং গৎৱা) ৱস্ত্ৰৱেষ্টিতং তং বালকং গোশালাযাং শযনং দ্ৰক্ষ্যথ যুষ্মান্ প্ৰতীদং চিহ্নং ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","দূত ইমাং কথাং কথিতৱতি তত্ৰাকস্মাৎ স্ৱৰ্গীযাঃ পৃতনা আগত্য কথাম্ ইমাং কথযিৎৱেশ্ৱৰস্য গুণানন্ৱৱাদিষুঃ, যথা, ");
INSERT INTO sanasm_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","সৰ্ৱ্ৱোৰ্দ্ৱ্ৱস্থৈৰীশ্ৱৰস্য মহিমা সম্প্ৰকাশ্যতাং| শান্তিৰ্ভূযাৎ পৃথিৱ্যাস্তু সন্তোষশ্চ নৰান্ প্ৰতি|| ");
INSERT INTO sanasm_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ততঃ পৰং তেষাং সন্নিধে ৰ্দূতগণে স্ৱৰ্গং গতে মেষপালকাঃ পৰস্পৰম্ অৱেচন্ আগচ্ছত প্ৰভুঃ পৰমেশ্ৱৰো যাং ঘটনাং জ্ঞাপিতৱান্ তস্যা যাথৰ্যং জ্ঞাতুং ৱযমধুনা বৈৎলেহম্পুৰং যামঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","পশ্চাৎ তে তূৰ্ণং ৱ্ৰজিৎৱা মৰিযমং যূষফং গোশালাযাং শযনং বালকঞ্চ দদৃশুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ইত্থং দৃষ্ট্ৱা বালকস্যাৰ্থে প্ৰোক্তাং সৰ্ৱ্ৱকথাং তে প্ৰাচাৰযাঞ্চক্ৰুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ততো যে লোকা মেষৰক্ষকাণাং ৱদনেভ্যস্তাং ৱাৰ্ত্তাং শুশ্ৰুৱুস্তে মহাশ্চৰ্য্যং মেনিৰে| ");
INSERT INTO sanasm_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","কিন্তু মৰিযম্ এতৎসৰ্ৱ্ৱঘটনানাং তাৎপৰ্য্যং ৱিৱিচ্য মনসি স্থাপযামাস| ");
INSERT INTO sanasm_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","তৎপশ্চাদ্ দূতৱিজ্ঞপ্তানুৰূপং শ্ৰুৎৱা দৃষ্ট্ৱা চ মেষপালকা ঈশ্ৱৰস্য গুণানুৱাদং ধন্যৱাদঞ্চ কুৰ্ৱ্ৱাণাঃ পৰাৱৃত্য যযুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","অথ বালকস্য ৎৱক্ছেদনকালেঽষ্টমদিৱসে সমুপস্থিতে তস্য গৰ্ব্ভস্থিতেঃ পুৰ্ৱ্ৱং স্ৱৰ্গীযদূতো যথাজ্ঞাপযৎ তদনুৰূপং তে তন্নামধেযং যীশুৰিতি চক্ৰিৰে| ");
INSERT INTO sanasm_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","ততঃ পৰং মূসালিখিতৱ্যৱস্থাযা অনুসাৰেণ মৰিযমঃ শুচিৎৱকাল উপস্থিতে, ");
INSERT INTO sanasm_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","\"প্ৰথমজঃ সৰ্ৱ্ৱঃ পুৰুষসন্তানঃ পৰমেশ্ৱৰে সমৰ্প্যতাং,\" ইতি পৰমেশ্ৱৰস্য ৱ্যৱস্থযা ");
INSERT INTO sanasm_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","যীশুং পৰমেশ্ৱৰে সমৰ্পযিতুম্ শাস্ত্ৰীযৱিধ্যুক্তং কপোতদ্ৱযং পাৰাৱতশাৱকদ্ৱযং ৱা বলিং দাতুং তে তং গৃহীৎৱা যিৰূশালমম্ আযযুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","যিৰূশালম্পুৰনিৱাসী শিমিযোন্নামা ধাৰ্ম্মিক এক আসীৎ স ইস্ৰাযেলঃ সান্ত্ৱনামপেক্ষ্য তস্থৌ কিঞ্চ পৱিত্ৰ আত্মা তস্মিন্নাৱিৰ্ভূতঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","অপৰং প্ৰভুণা পৰমেশ্ৱৰেণাভিষিক্তে ত্ৰাতৰি ৎৱযা ন দৃষ্টে ৎৱং ন মৰিষ্যসীতি ৱাক্যং পৱিত্ৰেণ আত্মনা তস্ম প্ৰাকথ্যত| ");
INSERT INTO sanasm_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","অপৰঞ্চ যদা যীশোঃ পিতা মাতা চ তদৰ্থং ৱ্যৱস্থানুৰূপং কৰ্ম্ম কৰ্ত্তুং তং মন্দিৰম্ আনিন্যতুস্তদা ");
INSERT INTO sanasm_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","শিমিযোন্ আত্মন আকৰ্ষণেন মন্দিৰমাগত্য তং ক্ৰোডে নিধায ঈশ্ৱৰস্য ধন্যৱাদং কৃৎৱা কথযামাস, যথা, ");
INSERT INTO sanasm_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","হে প্ৰভো তৱ দাসোযং নিজৱাক্যানুসাৰতঃ| ইদানীন্তু সকল্যাণো ভৱতা সংৱিসৃজ্যতাম্| ");
INSERT INTO sanasm_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","যতঃ সকলদেশস্য দীপ্তযে দীপ্তিৰূপকং| ");
INSERT INTO sanasm_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ইস্ৰাযেলীযলোকস্য মহাগৌৰৱৰূপকং| ");
INSERT INTO sanasm_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","যং ত্ৰাযকং জনানান্তু সম্মুখে ৎৱমজীজনঃ| সএৱ ৱিদ্যতেঽস্মাকং ধ্ৰৱং নযননগোচৰে|| ");
INSERT INTO sanasm_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","তদানীং তেনোক্তা এতাঃ সকলাঃ কথাঃ শ্ৰুৎৱা তস্য মাতা যূষফ্ চ ৱিস্মযং মেনাতে| ");
INSERT INTO sanasm_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ততঃ পৰং শিমিযোন্ তেভ্য আশিষং দত্ত্ৱা তন্মাতৰং মৰিযমম্ উৱাচ, পশ্য ইস্ৰাযেলো ৱংশমধ্যে বহূনাং পাতনাযোত্থাপনায চ তথা ৱিৰোধপাত্ৰং ভৱিতুং, বহূনাং গুপ্তমনোগতানাং প্ৰকটীকৰণায বালকোযং নিযুক্তোস্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","তস্মাৎ তৱাপি প্ৰাণাঃ শূলেন ৱ্যৎস্যন্তে| ");
INSERT INTO sanasm_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","অপৰঞ্চ আশেৰস্য ৱংশীযফিনূযেলো দুহিতা হন্নাখ্যা অতিজৰতী ভৱিষ্যদ্ৱাদিন্যেকা যা ৱিৱাহাৎ পৰং সপ্ত ৱৎসৰান্ পত্যা সহ ন্যৱসৎ ততো ৱিধৱা ভূৎৱা চতুৰশীতিৱৰ্ষৱযঃপৰ্য্যনতং ");
INSERT INTO sanasm_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","মন্দিৰে স্থিৎৱা প্ৰাৰ্থনোপৱাসৈৰ্দিৱানিশম্ ঈশ্ৱৰম্ অসেৱত সাপি স্ত্ৰী তস্মিন্ সমযে মন্দিৰমাগত্য ");
INSERT INTO sanasm_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","পৰমেশ্ৱৰস্য ধন্যৱাদং চকাৰ, যিৰূশালম্পুৰৱাসিনো যাৱন্তো লোকা মুক্তিমপেক্ষ্য স্থিতাস্তান্ যীশোৰ্ৱৃত্তান্তং জ্ঞাপযামাস| ");
INSERT INTO sanasm_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ইত্থং পৰমেশ্ৱৰস্য ৱ্যৱস্থানুসাৰেণ সৰ্ৱ্ৱেষু কৰ্ম্মসু কৃতেষু তৌ পুনশ্চ গালীলো নাসৰত্নামকং নিজনগৰং প্ৰতস্থাতে| ");
INSERT INTO sanasm_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","তৎপশ্চাদ্ বালকঃ শৰীৰেণ ৱৃদ্ধিমেত্য জ্ঞানেন পৰিপূৰ্ণ আত্মনা শক্তিমাংশ্চ ভৱিতুমাৰেভে তথা তস্মিন্ ঈশ্ৱৰানুগ্ৰহো বভূৱ| ");
INSERT INTO sanasm_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","তস্য পিতা মাতা চ প্ৰতিৱৰ্ষং নিস্তাৰোৎসৱসমযে যিৰূশালমম্ অগচ্ছতাম্| ");
INSERT INTO sanasm_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","অপৰঞ্চ যীশৌ দ্ৱাদশৱৰ্ষৱযস্কে সতি তৌ পৰ্ৱ্ৱসমযস্য ৰীত্যনুসাৰেণ যিৰূশালমং গৎৱা ");
INSERT INTO sanasm_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","পাৰ্ৱ্ৱণং সম্পাদ্য পুনৰপি ৱ্যাঘুয্য যাতঃ কিন্তু যীশুৰ্বালকো যিৰূশালমি তিষ্ঠতি| যূষফ্ তন্মাতা চ তদ্ অৱিদিৎৱা ");
INSERT INTO sanasm_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","স সঙ্গিভিঃ সহ ৱিদ্যত এতচ্চ বুদ্ৱ্ৱা দিনৈকগম্যমাৰ্গং জগ্মতুঃ| কিন্তু শেষে জ্ঞাতিবন্ধূনাং সমীপে মৃগযিৎৱা তদুদ্দেेশমপ্ৰাপ্য ");
INSERT INTO sanasm_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","তৌ পুনৰপি যিৰূশালমম্ পৰাৱৃত্যাগত্য তং মৃগযাঞ্চক্ৰতুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","অথ দিনত্ৰযাৎ পৰং পণ্ডিতানাং মধ্যে তেষাং কথাঃ শৃণ্ৱন্ তত্ত্ৱং পৃচ্ছংশ্চ মন্দিৰে সমুপৱিষ্টঃ স তাভ্যাং দৃষ্টঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","তদা তস্য বুদ্ধ্যা প্ৰত্যুত্তৰৈশ্চ সৰ্ৱ্ৱে শ্ৰোতাৰো ৱিস্মযমাপদ্যন্তে| ");
INSERT INTO sanasm_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","তাদৃশং দৃষ্ট্ৱা তস্য জনকো জননী চ চমচ্চক্ৰতুঃ কিঞ্চ তস্য মাতা তমৱদৎ, হে পুত্ৰ, কথমাৱাং প্ৰতীত্থং সমাচৰস্ত্ৱম্? পশ্য তৱ পিতাহঞ্চ শোকাকুলৌ সন্তৌ ৎৱামন্ৱিচ্ছাৱঃ স্ম| ");
INSERT INTO sanasm_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","ততঃ সোৱদৎ কুতো মাম্ অন্ৱৈচ্ছতং? পিতুৰ্গৃহে মযা স্থাতৱ্যম্ এতৎ কিং যুৱাভ্যাং ন জ্ঞাযতে? ");
INSERT INTO sanasm_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","কিন্তু তৌ তস্যৈতদ্ৱাক্যস্য তাৎপৰ্য্যং বোদ্ধুং নাশক্নুতাং| ");
INSERT INTO sanasm_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ততঃ পৰং স তাভ্যাং সহ নাসৰতং গৎৱা তযোৰ্ৱশীভূতস্তস্থৌ কিন্তু সৰ্ৱ্ৱা এতাঃ কথাস্তস্য মাতা মনসি স্থাপযামাস| ");
INSERT INTO sanasm_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","অথ যীশো ৰ্বুদ্ধিঃ শৰীৰঞ্চ তথা তস্মিন্ ঈশ্ৱৰস্য মানৱানাঞ্চানুগ্ৰহো ৱৰ্দ্ধিতুম্ আৰেভে| ");
INSERT INTO sanasm_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","অনন্তৰং তিবিৰিযকৈসৰস্য ৰাজৎৱস্য পঞ্চদশে ৱৎসৰে সতি যদা পন্তীযপীলাতো যিহূদাদেশাধিপতি ৰ্হেৰোদ্ তু গালীল্প্ৰদেশস্য ৰাজা ফিলিপনামা তস্য ভ্ৰাতা তু যিতূৰিযাযাস্ত্ৰাখোনীতিযাপ্ৰদেশস্য চ ৰাজাসীৎ লুষানীযনামা অৱিলীনীদেশস্য ৰাজাসীৎ ");
INSERT INTO sanasm_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","হানন্ কিযফাশ্চেমৌ প্ৰধানযাজাকাৱাস্তাং তদানীং সিখৰিযস্য পুত্ৰায যোহনে মধ্যেপ্ৰান্তৰম্ ঈশ্ৱৰস্য ৱাক্যে প্ৰকাশিতে সতি ");
INSERT INTO sanasm_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","স যৰ্দ্দন উভযতটপ্ৰদেশান্ সমেত্য পাপমোচনাৰ্থং মনঃপৰাৱৰ্ত্তনস্য চিহ্নৰূপং যন্মজ্জনং তদীযাঃ কথাঃ সৰ্ৱ্ৱত্ৰ প্ৰচাৰযিতুমাৰেভে| ");
INSERT INTO sanasm_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","যিশযিযভৱিষ্যদ্ৱক্তৃগ্ৰন্থে যাদৃশী লিপিৰাস্তে যথা, পৰমেশস্য পন্থানং পৰিষ্কুৰুত সৰ্ৱ্ৱতঃ| তস্য ৰাজপথঞ্চৈৱ সমানং কুৰুতাধুনা| ");
INSERT INTO sanasm_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","কাৰিষ্যন্তে সমুচ্ছ্ৰাযাঃ সকলা নিম্নভূমযঃ| কাৰিষ্যন্তে নতাঃ সৰ্ৱ্ৱে পৰ্ৱ্ৱতাশ্চোপপৰ্ৱ্ৱতাঃ| কাৰিষ্যন্তে চ যা ৱক্ৰাস্তাঃ সৰ্ৱ্ৱাঃ সৰলা ভুৱঃ| কাৰিষ্যন্তে সমানাস্তা যা উচ্চনীচভূমযঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ঈশ্ৱৰেণ কৃতং ত্ৰাণং দ্ৰক্ষ্যন্তি সৰ্ৱ্ৱমানৱাঃ| ইত্যেতৎ প্ৰান্তৰে ৱাক্যং ৱদতঃ কস্যচিদ্ ৰৱঃ|| ");
INSERT INTO sanasm_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","যে যে লোকা মজ্জনাৰ্থং বহিৰাযযুস্তান্ সোৱদৎ ৰে ৰে সৰ্পৱংশা আগামিনঃ কোপাৎ পলাযিতুং যুষ্মান্ কশ্চেতযামাস? ");
INSERT INTO sanasm_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","তস্মাদ্ ইব্ৰাহীম্ অস্মাকং পিতা কথামীদৃশীং মনোভি ৰ্ন কথযিৎৱা যূযং মনঃপৰিৱৰ্ত্তনযোগ্যং ফলং ফলত; যুষ্মানহং যথাৰ্থং ৱদামি পাষাণেভ্য এতেভ্য ঈশ্ৱৰ ইব্ৰাহীমঃ সন্তানোৎপাদনে সমৰ্থঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","অপৰঞ্চ তৰুমূলেঽধুনাপি পৰশুঃ সংলগ্নোস্তি যস্তৰুৰুত্তমং ফলং ন ফলতি স ছিদ্যতেঽগ্নৌ নিক্ষিপ্যতে চ| ");
INSERT INTO sanasm_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","তদানীং লোকাস্তং পপ্ৰচ্ছুস্তৰ্হি কিং কৰ্ত্তৱ্যমস্মাভিঃ? ");
INSERT INTO sanasm_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ততঃ সোৱাদীৎ যস্য দ্ৱে ৱসনে ৱিদ্যেতে স ৱস্ত্ৰহীনাযৈকং ৱিতৰতু কিংঞ্চ যস্য খাদ্যদ্ৰৱ্যং ৱিদ্যতে সোপি তথৈৱ কৰোতু| ");
INSERT INTO sanasm_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ততঃ পৰং কৰসঞ্চাযিনো মজ্জনাৰ্থম্ আগত্য পপ্ৰচ্ছুঃ হে গুৰো কিং কৰ্ত্তৱ্যমস্মাভিঃ? ");
INSERT INTO sanasm_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ততঃ সোকথযৎ নিৰূপিতাদধিকং ন গৃহ্লিত| ");
INSERT INTO sanasm_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","অনন্তৰং সেনাগণ এত্য পপ্ৰচ্ছ কিমস্মাভি ৰ্ৱা কৰ্ত্তৱ্যম্? ততঃ সোভিদধে কস্য কামপি হানিং মা কাৰ্ষ্ট তথা মৃষাপৱাদং মা কুৰুত নিজৱেতনেন চ সন্তুষ্য তিষ্ঠত| ");
INSERT INTO sanasm_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","অপৰঞ্চ লোকা অপেক্ষযা স্থিৎৱা সৰ্ৱ্ৱেপীতি মনোভি ৰ্ৱিতৰ্কযাঞ্চক্ৰুঃ, যোহনযম্ অভিষিক্তস্ত্ৰাতা ন ৱেতি? ");
INSERT INTO sanasm_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","তদা যোহন্ সৰ্ৱ্ৱান্ ৱ্যাজহাৰ, জলেঽহং যুষ্মান্ মজ্জযামি সত্যং কিন্তু যস্য পাদুকাবন্ধনং মোচযিতুমপি ন যোগ্যোস্মি তাদৃশ একো মত্তো গুৰুতৰঃ পুমান্ এতি, স যুষ্মান্ ৱহ্নিৰূপে পৱিত্ৰ আত্মনি মজ্জযিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","অপৰঞ্চ তস্য হস্তে শূৰ্প আস্তে স স্ৱশস্যানি শুদ্ধৰূপং প্ৰস্ফোট্য গোধূমান্ সৰ্ৱ্ৱান্ ভাণ্ডাগাৰে সংগ্ৰহীষ্যতি কিন্তু বূষাণি সৰ্ৱ্ৱাণ্যনিৰ্ৱ্ৱাণৱহ্নিনা দাহযিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","যোহন্ উপদেশেনেত্থং নানাকথা লোকানাং সমক্ষং প্ৰচাৰযামাস| ");
INSERT INTO sanasm_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","অপৰঞ্চ হেৰোদ্ ৰাজা ফিলিপ্নাম্নঃ সহোদৰস্য ভাৰ্য্যাং হেৰোদিযামধি তথান্যানি যানি যানি কুকৰ্ম্মাণি কৃতৱান্ তদধি চ ");
INSERT INTO sanasm_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","যোহনা তিৰস্কৃতো ভূৎৱা কাৰাগাৰে তস্য বন্ধনাদ্ অপৰমপি কুকৰ্ম্ম চকাৰ| ");
INSERT INTO sanasm_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ইতঃ পূৰ্ৱ্ৱং যস্মিন্ সমযে সৰ্ৱ্ৱে যোহনা মজ্জিতাস্তদানীং যীশুৰপ্যাগত্য মজ্জিতঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","তদনন্তৰং তেন প্ৰাৰ্থিতে মেঘদ্ৱাৰং মুক্তং তস্মাচ্চ পৱিত্ৰ আত্মা মূৰ্ত্তিমান্ ভূৎৱা কপোতৱৎ তদুপৰ্য্যৱৰুৰোহ; তদা ৎৱং মম প্ৰিযঃ পুত্ৰস্ত্ৱযি মম পৰমঃ সন্তোষ ইত্যাকাশৱাণী বভূৱ| ");
INSERT INTO sanasm_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","তদানীং যীশুঃ প্ৰাযেণ ত্ৰিংশদ্ৱৰ্ষৱযস্ক আসীৎ| লৌকিকজ্ঞানে তু স যূষফঃ পুত্ৰঃ, ");
INSERT INTO sanasm_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","যূষফ্ এলেঃ পুত্ৰঃ, এলিৰ্মত্ততঃ পুত্ৰঃ, মত্তৎ লেৱেঃ পুত্ৰঃ, লেৱি ৰ্মল্কেঃ পুত্ৰঃ, মল্কিৰ্যান্নস্য পুত্ৰঃ; যান্নো যূষফঃ পুত্ৰঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","যূষফ্ মত্তথিযস্য পুত্ৰঃ, মত্তথিয আমোসঃ পুত্ৰঃ, আমোস্ নহূমঃ পুত্ৰঃ, নহূম্ ইষ্লেঃ পুত্ৰঃ ইষ্লিৰ্নগেঃ পুত্ৰঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","নগিৰ্মাটঃ পুত্ৰঃ, মাট্ মত্তথিযস্য পুত্ৰঃ, মত্তথিযঃ শিমিযেঃ পুত্ৰঃ, শিমিযিৰ্যূষফঃ পুত্ৰঃ, যূষফ্ যিহূদাঃ পুত্ৰঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","যিহূদা যোহানাঃ পুত্ৰঃ, যোহানা ৰীষাঃ পুত্ৰঃ, ৰীষাঃ সিৰুব্বাবিলঃ পুত্ৰঃ, সিৰুব্বাবিল্ শল্তীযেলঃ পুত্ৰঃ, শল্তীযেল্ নেৰেঃ পুত্ৰঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","নেৰিৰ্মল্কেঃ পুত্ৰঃ, মল্কিঃ অদ্যঃ পুত্ৰঃ, অদ্দী কোষমঃ পুত্ৰঃ, কোষম্ ইল্মোদদঃ পুত্ৰঃ, ইল্মোদদ্ এৰঃ পুত্ৰঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","এৰ্ যোশেঃ পুত্ৰঃ, যোশিঃ ইলীযেষৰঃ পুত্ৰঃ, ইলীযেষৰ্ যোৰীমঃ পুত্ৰঃ, যোৰীম্ মত্ততঃ পুত্ৰঃ, মত্তত লেৱেঃ পুত্ৰঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","লেৱিঃ শিমিযোনঃ পুত্ৰঃ, শিমিযোন্ যিহূদাঃ পুত্ৰঃ, যিহূদা যূষুফঃ পুত্ৰঃ, যূষুফ্ যোননঃ পুত্ৰঃ, যানন্ ইলীযাকীমঃ পুত্ৰঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ইলিযাকীম্ঃ মিলেযাঃ পুত্ৰঃ, মিলেযা মৈননঃ পুত্ৰঃ, মৈনন্ মত্তত্তস্য পুত্ৰঃ, মত্তত্তো নাথনঃ পুত্ৰঃ, নাথন্ দাযূদঃ পুত্ৰঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","দাযূদ্ যিশযঃ পুত্ৰঃ, যিশয ওবেদঃ পুত্ৰ, ওবেদ্ বোযসঃ পুত্ৰঃ, বোযস্ সল্মোনঃ পুত্ৰঃ, সল্মোন্ নহশোনঃ পুত্ৰঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","নহশোন্ অম্মীনাদবঃ পুত্ৰঃ, অম্মীনাদব্ অৰামঃ পুত্ৰঃ, অৰাম্ হিষ্ৰোণঃ পুত্ৰঃ, হিষ্ৰোণ্ পেৰসঃ পুত্ৰঃ, পেৰস্ যিহূদাঃ পুত্ৰঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","যিহূদা যাকূবঃ পুত্ৰঃ, যাকূব্ ইস্হাকঃ পুত্ৰঃ, ইস্হাক্ ইব্ৰাহীমঃ পুত্ৰঃ, ইব্ৰাহীম্ তেৰহঃ পুত্ৰঃ, তেৰহ্ নাহোৰঃ পুত্ৰঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","নাহোৰ্ সিৰুগঃ পুত্ৰঃ, সিৰুগ্ ৰিয্ৱঃ পুত্ৰঃ, ৰিযূঃ পেলগঃ পুত্ৰঃ, পেলগ্ এৱৰঃ পুত্ৰঃ, এৱৰ্ শেলহঃ পুত্ৰঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","শেলহ্ কৈননঃ পুত্ৰঃ, কৈনন্ অৰ্ফক্ষদঃ পুত্ৰঃ, অৰ্ফক্ষদ্ শামঃ পুত্ৰঃ, শাম্ নোহঃ পুত্ৰঃ, নোহো লেমকঃ পুত্ৰঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","লেমক্ মিথূশেলহঃ পুত্ৰঃ, মিথূশেলহ্ হনোকঃ পুত্ৰঃ, হনোক্ যেৰদঃ পুত্ৰঃ, যেৰদ্ মহললেলঃ পুত্ৰঃ, মহললেল্ কৈননঃ পুত্ৰঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","কৈনন্ ইনোশঃ পুত্ৰঃ, ইনোশ্ শেতঃ পুত্ৰঃ, শেৎ আদমঃ পুত্ৰ, আদম্ ঈশ্ৱৰস্য পুত্ৰঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ততঃ পৰং যীশুঃ পৱিত্ৰেণাত্মনা পূৰ্ণঃ সন্ যৰ্দ্দননদ্যাঃ পৰাৱৃত্যাত্মনা প্ৰান্তৰং নীতঃ সন্ চৎৱাৰিংশদ্দিনানি যাৱৎ শৈতানা পৰীক্ষিতোঽভূৎ, ");
INSERT INTO sanasm_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","কিঞ্চ তানি সৰ্ৱ্ৱদিনানি ভোজনং ৱিনা স্থিতৎৱাৎ কালে পূৰ্ণে স ক্ষুধিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ততঃ শৈতানাগত্য তমৱদৎ ৎৱং চেদীশ্ৱৰস্য পুত্ৰস্তৰ্হি প্ৰস্তৰানেতান্ আজ্ঞযা পূপান্ কুৰু| ");
INSERT INTO sanasm_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","তদা যীশুৰুৱাচ, লিপিৰীদৃশী ৱিদ্যতে মনুজঃ কেৱলেন পূপেন ন জীৱতি কিন্ত্ৱীশ্ৱৰস্য সৰ্ৱ্ৱাভিৰাজ্ঞাভি ৰ্জীৱতি| ");
INSERT INTO sanasm_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","তদা শৈতান্ তমুচ্চং পৰ্ৱ্ৱতং নীৎৱা নিমিষৈকমধ্যে জগতঃ সৰ্ৱ্ৱৰাজ্যানি দৰ্শিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","পশ্চাৎ তমৱাদীৎ সৰ্ৱ্ৱম্ এতদ্ ৱিভৱং প্ৰতাপঞ্চ তুভ্যং দাস্যামি তন্ মযি সমৰ্পিতমাস্তে যং প্ৰতি মমেচ্ছা জাযতে তস্মৈ দাতুং শক্নোমি, ");
INSERT INTO sanasm_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ৎৱং চেন্মাং ভজসে তৰ্হি সৰ্ৱ্ৱমেতৎ তৱৈৱ ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","তদা যীশুস্তং প্ৰত্যুক্তৱান্ দূৰী ভৱ শৈতান্ লিপিৰাস্তে, নিজং প্ৰভুং পৰমেশ্ৱৰং ভজস্ৱ কেৱলং তমেৱ সেৱস্ৱ চ| ");
INSERT INTO sanasm_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","অথ শৈতান্ তং যিৰূশালমং নীৎৱা মন্দিৰস্য চূডাযা উপৰি সমুপৱেশ্য জগাদ ৎৱং চেদীশ্ৱৰস্য পুত্ৰস্তৰ্হি স্থানাদিতো লম্ফিৎৱাধঃ ");
INSERT INTO sanasm_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","পত যতো লিপিৰাস্তে, আজ্ঞাপযিষ্যতি স্ৱীযান্ দূতান্ স পৰমেশ্ৱৰঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ৰক্ষিতুং সৰ্ৱ্ৱমাৰ্গে ৎৱাং তেন ৎৱচ্চৰণে যথা| ন লগেৎ প্ৰস্তৰাঘাতস্ত্ৱাং ধৰিষ্যন্তি তে তথা| ");
INSERT INTO sanasm_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","তদা যীশুনা প্ৰত্যুক্তম্ ইদমপ্যুক্তমস্তি ৎৱং স্ৱপ্ৰভুং পৰেশং মা পৰীক্ষস্ৱ| ");
INSERT INTO sanasm_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","পশ্চাৎ শৈতান্ সৰ্ৱ্ৱপৰীক্ষাং সমাপ্য ক্ষণাত্তং ত্যক্ত্ৱা যযৌ| ");
INSERT INTO sanasm_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","তদা যীশুৰাত্মপ্ৰভাৱাৎ পুনৰ্গালীল্প্ৰদেশং গতস্তদা তৎসুখ্যাতিশ্চতুৰ্দিশং ৱ্যানশে| ");
INSERT INTO sanasm_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","স তেষাং ভজনগৃহেষু উপদিশ্য সৰ্ৱ্ৱৈঃ প্ৰশংসিতো বভূৱ| ");
INSERT INTO sanasm_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","অথ স স্ৱপালনস্থানং নাসৰৎপুৰমেত্য ৱিশ্ৰামৱাৰে স্ৱাচাৰাদ্ ভজনগেহং প্ৰৱিশ্য পঠিতুমুত্তস্থৌ| ");
INSERT INTO sanasm_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ততো যিশযিযভৱিষ্যদ্ৱাদিনঃ পুস্তকে তস্য কৰদত্তে সতি স তৎ পুস্তকং ৱিস্তাৰ্য্য যত্ৰ ৱক্ষ্যমাণানি ৱচনানি সন্তি তৎ স্থানং প্ৰাপ্য পপাঠ| ");
INSERT INTO sanasm_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","আত্মা তু পৰমেশস্য মদীযোপৰি ৱিদ্যতে| দৰিদ্ৰেষু সুসংৱাদং ৱক্তুং মাং সোভিষিক্তৱান্| ভগ্নান্তঃ কৰণাল্লোকান্ সুস্ৱস্থান্ কৰ্ত্তুমেৱ চ| বন্দীকৃতেষু লোকেষু মুক্তে ৰ্ঘোষযিতুং ৱচঃ| নেত্ৰাণি দাতুমন্ধেভ্যস্ত্ৰাতুং বদ্ধজনানপি| ");
INSERT INTO sanasm_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","পৰেশানুগ্ৰহে কালং প্ৰচাৰযিতুমেৱ চ| সৰ্ৱ্ৱৈতৎকৰণাৰ্থায মামেৱ প্ৰহিণোতি সঃ|| ");
INSERT INTO sanasm_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ততঃ পুস্তকং বদ্ৱ্ৱা পৰিচাৰকস্য হস্তে সমৰ্প্য চাসনে সমুপৱিষ্টঃ, ততো ভজনগৃহে যাৱন্তো লোকা আসন্ তে সৰ্ৱ্ৱেঽনন্যদৃষ্ট্যা তং ৱিলুলোকিৰে| ");
INSERT INTO sanasm_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","অনন্তৰম্ অদ্যৈতানি সৰ্ৱ্ৱাণি লিখিতৱচনানি যুষ্মাকং মধ্যে সিদ্ধানি স ইমাং কথাং তেভ্যঃ কথযিতুমাৰেভে| ");
INSERT INTO sanasm_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","ততঃ সৰ্ৱ্ৱে তস্মিন্ অন্ৱৰজ্যন্ত, কিঞ্চ তস্য মুখান্নিৰ্গতাভিৰনুগ্ৰহস্য কথাভিশ্চমৎকৃত্য কথযামাসুঃ কিমযং যূষফঃ পুত্ৰো ন? ");
INSERT INTO sanasm_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","তদা সোঽৱাদীদ্ হে চিকিৎসক স্ৱমেৱ স্ৱস্থং কুৰু কফৰ্নাহূমি যদ্যৎ কৃতৱান্ তদশ্ৰৌষ্ম তাঃ সৰ্ৱাঃ ক্ৰিযা অত্ৰ স্ৱদেশে কুৰু কথামেতাং যূযমেৱাৱশ্যং মাং ৱদিষ্যথ| ");
INSERT INTO sanasm_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","পুনঃ সোৱাদীদ্ যুষ্মানহং যথাৰ্থং ৱদামি, কোপি ভৱিষ্যদ্ৱাদী স্ৱদেশে সৎকাৰং ন প্ৰাপ্নোতি| ");
INSERT INTO sanasm_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","অপৰঞ্চ যথাৰ্থং ৱচ্মি, এলিযস্য জীৱনকালে যদা সাৰ্দ্ধত্ৰিতযৱৰ্ষাণি যাৱৎ জলদপ্ৰতিবন্ধাৎ সৰ্ৱ্ৱস্মিন্ দেশে মহাদুৰ্ভিক্ষম্ অজনিষ্ট তদানীম্ ইস্ৰাযেলো দেশস্য মধ্যে বহ্ৱ্যো ৱিধৱা আসন্, ");
INSERT INTO sanasm_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","কিন্তু সীদোন্প্ৰদেশীযসাৰিফৎপুৰনিৱাসিনীম্ একাং ৱিধৱাং ৱিনা কস্যাশ্চিদপি সমীপে এলিযঃ প্ৰেৰিতো নাভূৎ| ");
INSERT INTO sanasm_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","অপৰঞ্চ ইলীশাযভৱিষ্যদ্ৱাদিৱিদ্যমানতাকালে ইস্ৰাযেল্দেশে বহৱঃ কুষ্ঠিন আসন্ কিন্তু সুৰীযদেশীযং নামান্কুষ্ঠিনং ৱিনা কোপ্যন্যঃ পৰিষ্কৃতো নাভূৎ| ");
INSERT INTO sanasm_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ইমাং কথাং শ্ৰুৎৱা ভজনগেহস্থিতা লোকাঃ সক্ৰোধম্ উত্থায ");
INSERT INTO sanasm_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","নগৰাত্তং বহিষ্কৃত্য যস্য শিখৰিণ উপৰি তেষাং নগৰং স্থাপিতমাস্তে তস্মান্নিক্ষেপ্তুং তস্য শিখৰং তং নিন্যুঃ ");
INSERT INTO sanasm_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","কিন্তু স তেষাং মধ্যাদপসৃত্য স্থানান্তৰং জগাম| ");
INSERT INTO sanasm_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ততঃ পৰং যীশুৰ্গালীল্প্ৰদেশীযকফৰ্নাহূম্নগৰ উপস্থায ৱিশ্ৰামৱাৰে লোকানুপদেষ্টুম্ আৰব্ধৱান্| ");
INSERT INTO sanasm_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","তদুপদেশাৎ সৰ্ৱ্ৱে চমচ্চক্ৰু ৰ্যতস্তস্য কথা গুৰুতৰা আসন্| ");
INSERT INTO sanasm_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","তদানীং তদ্ভজনগেহস্থিতোঽমেধ্যভূতগ্ৰস্ত একো জন উচ্চৈঃ কথযামাস, ");
INSERT INTO sanasm_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","হে নাসৰতীযযীশোঽস্মান্ ত্যজ, ৎৱযা সহাস্মাকং কঃ সম্বন্ধঃ? কিমস্মান্ ৱিনাশযিতুমাযাসি? ৎৱমীশ্ৱৰস্য পৱিত্ৰো জন এতদহং জানামি| ");
INSERT INTO sanasm_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","তদা যীশুস্তং তৰ্জযিৎৱাৱদৎ মৌনী ভৱ ইতো বহিৰ্ভৱ; ততঃ সোমেধ্যভূতস্তং মধ্যস্থানে পাতযিৎৱা কিঞ্চিদপ্যহিংসিৎৱা তস্মাদ্ বহিৰ্গতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","ততঃ সৰ্ৱ্ৱে লোকাশ্চমৎকৃত্য পৰস্পৰং ৱক্তুমাৰেভিৰে কোযং চমৎকাৰঃ| এষ প্ৰভাৱেণ পৰাক্ৰমেণ চামেধ্যভূতান্ আজ্ঞাপযতি তেনৈৱ তে বহিৰ্গচ্ছন্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","অনন্তৰং চতুৰ্দিক্স্থদেশান্ তস্য সুখ্যাতিৰ্ৱ্যাপ্নোৎ| ");
INSERT INTO sanasm_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","তদনন্তৰং স ভজনগেহাদ্ বহিৰাগত্য শিমোনো নিৱেশনং প্ৰৱিৱেশ তদা তস্য শ্ৱশ্ৰূৰ্জ্ৱৰেণাত্যন্তং পীডিতাসীৎ শিষ্যাস্তদৰ্থং তস্মিন্ ৱিনযং চক্ৰুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ততঃ স তস্যাঃ সমীপে স্থিৎৱা জ্ৱৰং তৰ্জযামাস তেনৈৱ তাং জ্ৱৰোঽত্যাক্ষীৎ ততঃ সা তৎক্ষণম্ উত্থায তান্ সিষেৱে| ");
INSERT INTO sanasm_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","অথ সূৰ্য্যাস্তকালে স্ৱেষাং যে যে জনা নানাৰোগৈঃ পীডিতা আসন্ লোকাস্তান্ যীশোঃ সমীপম্ আনিন্যুঃ, তদা স একৈকস্য গাত্ৰে কৰমৰ্পযিৎৱা তানৰোগান্ চকাৰ| ");
INSERT INTO sanasm_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ততো ভূতা বহুভ্যো নিৰ্গত্য চীৎশব্দং কৃৎৱা চ বভাষিৰে ৎৱমীশ্ৱৰস্য পুত্ৰোঽভিষিক্তত্ৰাতা; কিন্তু সোভিষিক্তত্ৰাতেতি তে ৱিৱিদুৰেতস্মাৎ কাৰণাৎ তান্ তৰ্জযিৎৱা তদ্ৱক্তুং নিষিষেধ| ");
INSERT INTO sanasm_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","অপৰঞ্চ প্ৰভাতে সতি স ৱিজনস্থানং প্ৰতস্থে পশ্চাৎ জনাস্তমন্ৱিচ্ছন্তস্তন্নিকটং গৎৱা স্থানান্তৰগমনাৰ্থং তমন্ৱৰুন্ধন্| ");
INSERT INTO sanasm_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","কিন্তু স তান্ জগাদ, ঈশ্ৱৰীযৰাজ্যস্য সুসংৱাদং প্ৰচাৰযিতুম্ অন্যানি পুৰাণ্যপি মযা যাতৱ্যানি যতস্তদৰ্থমেৱ প্ৰেৰিতোহং| ");
INSERT INTO sanasm_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","অথ গালীলো ভজনগেহেষু স উপদিদেশ| ");
INSERT INTO sanasm_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","অনন্তৰং যীশুৰেকদা গিনেষৰথ্দস্য তীৰ উত্তিষ্ঠতি, তদা লোকা ঈশ্ৱৰীযকথাং শ্ৰোতুং তদুপৰি প্ৰপতিতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","তদানীং স হ্দস্য তীৰসমীপে নৌদ্ৱযং দদৰ্শ কিঞ্চ মৎস্যোপজীৱিনো নাৱং ৱিহায জালং প্ৰক্ষালযন্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ততস্তযোৰ্দ্ৱযো ৰ্মধ্যে শিমোনো নাৱমাৰুহ্য তীৰাৎ কিঞ্চিদ্দূৰং যাতুং তস্মিন্ ৱিনযং কৃৎৱা নৌকাযামুপৱিশ্য লোকান্ প্ৰোপদিষ্টৱান্| ");
INSERT INTO sanasm_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","পশ্চাৎ তং প্ৰস্তাৱং সমাপ্য স শিমোনং ৱ্যাজহাৰ, গভীৰং জলং গৎৱা মৎস্যান্ ধৰ্ত্তুং জালং নিক্ষিপ| ");
INSERT INTO sanasm_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ততঃ শিমোন বভাষে, হে গুৰো যদ্যপি ৱযং কৃৎস্নাং যামিনীং পৰিশ্ৰম্য মৎস্যৈকমপি ন প্ৰাপ্তাস্তথাপি ভৱতো নিদেশতো জালং ক্ষিপামঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","অথ জালে ক্ষিপ্তে বহুমৎস্যপতনাদ্ আনাযঃ প্ৰচ্ছিন্নঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","তস্মাদ্ উপকৰ্ত্তুম্ অন্যনৌস্থান্ সঙ্গিন আযাতুম্ ইঙ্গিতেন সমাহ্ৱযন্ ততস্ত আগত্য মৎস্যৈ ৰ্নৌদ্ৱযং প্ৰপূৰযামাসু ৰ্যৈ ৰ্নৌদ্ৱযং প্ৰমগ্নম্| ");
INSERT INTO sanasm_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","তদা শিমোন্পিতৰস্তদ্ ৱিলোক্য যীশোশ্চৰণযোঃ পতিৎৱা, হে প্ৰভোহং পাপী নৰো মম নিকটাদ্ ভৱান্ যাতু, ইতি কথিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","যতো জালে পতিতানাং মৎস্যানাং যূথাৎ শিমোন্ তৎসঙ্গিনশ্চ চমৎকৃতৱন্তঃ; শিমোনঃ সহকাৰিণৌ সিৱদেঃ পুত্ৰৌ যাকূব্ যোহন্ চেমৌ তাদৃশৌ বভূৱতুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","তদা যীশুঃ শিমোনং জগাদ মা ভৈষীৰদ্যাৰভ্য ৎৱং মনুষ্যধৰো ভৱিষ্যসি| ");
INSERT INTO sanasm_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","অনন্তৰং সৰ্ৱ্ৱাসু নৌসু তীৰম্ আনীতাসু তে সৰ্ৱ্ৱান্ পৰিত্যজ্য তস্য পশ্চাদ্গামিনো বভূৱুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","ততঃ পৰং যীশৌ কস্মিংশ্চিৎ পুৰে তিষ্ঠতি জন একঃ সৰ্ৱ্ৱাঙ্গকুষ্ঠস্তং ৱিলোক্য তস্য সমীপে ন্যুব্জঃ পতিৎৱা সৱিনযং ৱক্তুমাৰেভে, হে প্ৰভো যদি ভৱানিচ্ছতি তৰ্হি মাং পৰিষ্কৰ্ত্তুং শক্নোতি| ");
INSERT INTO sanasm_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","তদানীং স পাণিং প্ৰসাৰ্য্য তদঙ্গং স্পৃশন্ বভাষে ৎৱং পৰিষ্ক্ৰিযস্ৱেতি মমেচ্ছাস্তি ততস্তৎক্ষণং স কুষ্ঠাৎ মুক্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","পশ্চাৎ স তমাজ্ঞাপযামাস কথামিমাং কস্মৈচিদ্ অকথযিৎৱা যাজকস্য সমীপঞ্চ গৎৱা স্ৱং দৰ্শয, লোকেভ্যো নিজপৰিষ্কৃতৎৱস্য প্ৰমাণদানায মূসাজ্ঞানুসাৰেণ দ্ৰৱ্যমুত্মৃজস্ৱ চ| ");
INSERT INTO sanasm_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","তথাপি যীশোঃ সুখ্যাতি ৰ্বহু ৱ্যাপ্তুমাৰেভে কিঞ্চ তস্য কথাং শ্ৰোতুং স্ৱীযৰোগেভ্যো মোক্তুঞ্চ লোকা আজগ্মুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","অথ স প্ৰান্তৰং গৎৱা প্ৰাৰ্থযাঞ্চক্ৰে| ");
INSERT INTO sanasm_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","অপৰঞ্চ একদা যীশুৰুপদিশতি, এতৰ্হি গালীল্যিহূদাপ্ৰদেশযোঃ সৰ্ৱ্ৱনগৰেভ্যো যিৰূশালমশ্চ কিযন্তঃ ফিৰূশিলোকা ৱ্যৱস্থাপকাশ্চ সমাগত্য তদন্তিকে সমুপৱিৱিশুঃ, তস্মিন্ কালে লোকানামাৰোগ্যকাৰণাৎ প্ৰভোঃ প্ৰভাৱঃ প্ৰচকাশে| ");
INSERT INTO sanasm_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","পশ্চাৎ কিযন্তো লোকা একং পক্ষাঘাতিনং খট্ৱাযাং নিধায যীশোঃ সমীপমানেতুং সম্মুখে স্থাপযিতুঞ্চ ৱ্যাপ্ৰিযন্ত| ");
INSERT INTO sanasm_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","কিন্তু বহুজননিৱহসম্ৱাধাৎ ন শক্নুৱন্তো গৃহোপৰি গৎৱা গৃহপৃষ্ঠং খনিৎৱা তং পক্ষাঘাতিনং সখট্ৱং গৃহমধ্যে যীশোঃ সম্মুখে ঽৱৰোহযামাসুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","তদা যীশুস্তেষাম্ ঈদৃশং ৱিশ্ৱাসং ৱিলোক্য তং পক্ষাঘাতিনং ৱ্যাজহাৰ, হে মানৱ তৱ পাপমক্ষম্যত| ");
INSERT INTO sanasm_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","তস্মাদ্ অধ্যাপকাঃ ফিৰূশিনশ্চ চিত্তৈৰিত্থং প্ৰচিন্তিতৱন্তঃ, এষ জন ঈশ্ৱৰং নিন্দতি কোযং? কেৱলমীশ্ৱৰং ৱিনা পাপং ক্ষন্তুং কঃ শক্নোতি? ");
INSERT INTO sanasm_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","তদা যীশুস্তেষাম্ ইত্থং চিন্তনং ৱিদিৎৱা তেভ্যোকথযদ্ যূযং মনোভিঃ কুতো ৱিতৰ্কযথ? ");
INSERT INTO sanasm_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","তৱ পাপক্ষমা জাতা যদ্ৱা ৎৱমুত্থায ৱ্ৰজ এতযো ৰ্মধ্যে কা কথা সুকথ্যা? ");
INSERT INTO sanasm_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","কিন্তু পৃথিৱ্যাং পাপং ক্ষন্তুং মানৱসুতস্য সামৰ্থ্যমস্তীতি যথা যূযং জ্ঞাতুং শক্নুথ তদৰ্থং (স তং পক্ষাঘাতিনং জগাদ) উত্তিষ্ঠ স্ৱশয্যাং গৃহীৎৱা গৃহং যাহীতি ৎৱামাদিশামি| ");
INSERT INTO sanasm_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","তস্মাৎ স তৎক্ষণম্ উত্থায সৰ্ৱ্ৱেষাং সাক্ষাৎ নিজশযনীযং গৃহীৎৱা ঈশ্ৱৰং ধন্যং ৱদন্ নিজনিৱেশনং যযৌ| ");
INSERT INTO sanasm_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","তস্মাৎ সৰ্ৱ্ৱে ৱিস্ময প্ৰাপ্তা মনঃসু ভীতাশ্চ ৱযমদ্যাসম্ভৱকাৰ্য্যাণ্যদৰ্শাম ইত্যুক্ত্ৱা পৰমেশ্ৱৰং ধন্যং প্ৰোদিতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","ততঃ পৰং বহিৰ্গচ্ছন্ কৰসঞ্চযস্থানে লেৱিনামানং কৰসঞ্চাযকং দৃষ্ট্ৱা যীশুস্তমভিদধে মম পশ্চাদেহি| ");
INSERT INTO sanasm_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","তস্মাৎ স তৎক্ষণাৎ সৰ্ৱ্ৱং পৰিত্যজ্য তস্য পশ্চাদিযায| ");
INSERT INTO sanasm_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","অনন্তৰং লেৱি ৰ্নিজগৃহে তদৰ্থং মহাভোজ্যং চকাৰ, তদা তৈঃ সহানেকে কৰসঞ্চাযিনস্তদন্যলোকাশ্চ ভোক্তুমুপৱিৱিশুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","তস্মাৎ কাৰণাৎ চণ্ডালানাং পাপিলোকানাঞ্চ সঙ্গে যূযং কুতো ভংগ্ধ্ৱে পিৱথ চেতি কথাং কথযিৎৱা ফিৰূশিনোঽধ্যাপকাশ্চ তস্য শিষ্যৈঃ সহ ৱাগ্যুদ্ধং কৰ্ত্তুমাৰেভিৰে| ");
INSERT INTO sanasm_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","তস্মাদ্ যীশুস্তান্ প্ৰত্যৱোচদ্ অৰোগলোকানাং চিকিৎসকেন প্ৰযোজনং নাস্তি কিন্তু সৰোগাণামেৱ| ");
INSERT INTO sanasm_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","অহং ধাৰ্ম্মিকান্ আহ্ৱাতুং নাগতোস্মি কিন্তু মনঃ পৰাৱৰ্ত্তযিতুং পাপিন এৱ| ");
INSERT INTO sanasm_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","ততস্তে প্ৰোচুঃ, যোহনঃ ফিৰূশিনাঞ্চ শিষ্যা ৱাৰংৱাৰম্ উপৱসন্তি প্ৰাৰ্থযন্তে চ কিন্তু তৱ শিষ্যাঃ কুতো ভুঞ্জতে পিৱন্তি চ? ");
INSERT INTO sanasm_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","তদা স তানাচখ্যৌ ৱৰে সঙ্গে তিষ্ঠতি ৱৰস্য সখিগণং কিমুপৱাসযিতুং শক্নুথ? ");
INSERT INTO sanasm_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","কিন্তু যদা তেষাং নিকটাদ্ ৱৰো নেষ্যতে তদা তে সমুপৱৎস্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","সোপৰমপি দৃষ্টান্তং কথযাম্বভূৱ পুৰাতনৱস্ত্ৰে কোপি নুতনৱস্ত্ৰং ন সীৱ্যতি যতস্তেন সেৱনেন জীৰ্ণৱস্ত্ৰং ছিদ্যতে, নূতনপুৰাতনৱস্ত্ৰযো ৰ্মেলঞ্চ ন ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","পুৰাতন্যাং কুৎৱাং কোপি নুতনং দ্ৰাক্ষাৰসং ন নিদধাতি, যতো নৱীনদ্ৰাক্ষাৰসস্য তেজসা পুৰাতনী কুতূ ৰ্ৱিদীৰ্য্যতে ততো দ্ৰাক্ষাৰসঃ পততি কুতূশ্চ নশ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","ততো হেতো ৰ্নূতন্যাং কুৎৱাং নৱীনদ্ৰাক্ষাৰসঃ নিধাতৱ্যস্তেনোভযস্য ৰক্ষা ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","অপৰঞ্চ পুৰাতনং দ্ৰাক্ষাৰসং পীৎৱা কোপি নূতনং ন ৱাঞ্ছতি, যতঃ স ৱক্তি নূতনাৎ পুৰাতনম্ প্ৰশস্তম্| ");
INSERT INTO sanasm_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","অচৰঞ্চ পৰ্ৱ্ৱণো দ্ৱিতীযদিনাৎ পৰং প্ৰথমৱিশ্ৰামৱাৰে শস্যক্ষেত্ৰেণ যীশোৰ্গমনকালে তস্য শিষ্যাঃ কণিশং ছিত্ত্ৱা কৰেষু মৰ্দ্দযিৎৱা খাদিতুমাৰেভিৰে| ");
INSERT INTO sanasm_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","তস্মাৎ কিযন্তঃ ফিৰূশিনস্তানৱদন্ ৱিশ্ৰামৱাৰে যৎ কৰ্ম্ম ন কৰ্ত্তৱ্যং তৎ কুতঃ কুৰুথ? ");
INSERT INTO sanasm_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","যীশুঃ প্ৰত্যুৱাচ দাযূদ্ তস্য সঙ্গিনশ্চ ক্ষুধাৰ্ত্তাঃ কিং চক্ৰুঃ স কথম্ ঈশ্ৱৰস্য মন্দিৰং প্ৰৱিশ্য ");
INSERT INTO sanasm_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","যে দৰ্শনীযাঃ পূপা যাজকান্ ৱিনান্যস্য কস্যাপ্যভোজনীযাস্তানানীয স্ৱযং বুভজে সঙ্গিভ্যোপি দদৌ তৎ কিং যুষ্মাভিঃ কদাপি নাপাঠি? ");
INSERT INTO sanasm_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","পশ্চাৎ স তানৱদৎ মনুজসুতো ৱিশ্ৰামৱাৰস্যাপি প্ৰভু ৰ্ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","অনন্তৰম্ অন্যৱিশ্ৰামৱাৰে স ভজনগেহং প্ৰৱিশ্য সমুপদিশতি| তদা তৎস্থানে শুষ্কদক্ষিণকৰ একঃ পুমান্ উপতস্থিৱান্| ");
INSERT INTO sanasm_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","তস্মাদ্ অধ্যাপকাঃ ফিৰূশিনশ্চ তস্মিন্ দোষমাৰোপযিতুং স ৱিশ্ৰামৱাৰে তস্য স্ৱাস্থ্যং কৰোতি নৱেতি প্ৰতীক্ষিতুমাৰেভিৰে| ");
INSERT INTO sanasm_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","তদা যীশুস্তেষাং চিন্তাং ৱিদিৎৱা তং শুষ্ককৰং পুমাংসং প্ৰোৱাচ, ৎৱমুত্থায মধ্যস্থানে তিষ্ঠ| ");
INSERT INTO sanasm_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","তস্মাৎ তস্মিন্ উত্থিতৱতি যীশুস্তান্ ৱ্যাজহাৰ, যুষ্মান্ ইমাং কথাং পৃচ্ছামি, ৱিশ্ৰামৱাৰে হিতম্ অহিতং ৱা, প্ৰাণৰক্ষণং প্ৰাণনাশনং ৱা, এতেষাং কিং কৰ্ম্মকৰণীযম্? ");
INSERT INTO sanasm_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","পশ্চাৎ চতুৰ্দিক্ষু সৰ্ৱ্ৱান্ ৱিলোক্য তং মানৱং বভাষে, নিজকৰং প্ৰসাৰয; ততস্তেন তথা কৃত ইতৰকৰৱৎ তস্য হস্তঃ স্ৱস্থোভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","তস্মাৎ তে প্ৰচণ্ডকোপান্ৱিতা যীশুং কিং কৰিষ্যন্তীতি পৰস্পৰং প্ৰমন্ত্ৰিতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ততঃ পৰং স পৰ্ৱ্ৱতমাৰুহ্যেশ্ৱৰমুদ্দিশ্য প্ৰাৰ্থযমানঃ কৃৎস্নাং ৰাত্ৰিং যাপিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","অথ দিনে সতি স সৰ্ৱ্ৱান্ শিষ্যান্ আহূতৱান্ তেষাং মধ্যে ");
INSERT INTO sanasm_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","পিতৰনাম্না খ্যাতঃ শিমোন্ তস্য ভ্ৰাতা আন্দ্ৰিযশ্চ যাকূব্ যোহন্ চ ফিলিপ্ বৰ্থলমযশ্চ ");
INSERT INTO sanasm_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","মথিঃ থোমা আল্ফীযস্য পুত্ৰো যাকূব্ জ্ৱলন্তনাম্না খ্যাতঃ শিমোন্ ");
INSERT INTO sanasm_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","চ যাকূবো ভ্ৰাতা যিহূদাশ্চ তং যঃ পৰকৰেষু সমৰ্পযিষ্যতি স ঈষ্কৰীযোতীযযিহূদাশ্চৈতান্ দ্ৱাদশ জনান্ মনোনীতান্ কৃৎৱা স জগ্ৰাহ তথা প্ৰেৰিত ইতি তেষাং নাম চকাৰ| ");
INSERT INTO sanasm_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","ততঃ পৰং স তৈঃ সহ পৰ্ৱ্ৱতাদৱৰুহ্য উপত্যকাযাং তস্থৌ ততস্তস্য শিষ্যসঙ্ঘো যিহূদাদেশাদ্ যিৰূশালমশ্চ সোৰঃ সীদোনশ্চ জলধে ৰোধসো জননিহাশ্চ এত্য তস্য কথাশ্ৰৱণাৰ্থং ৰোগমুক্ত্যৰ্থঞ্চ তস্য সমীপে তস্থুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","অমেধ্যভূতগ্ৰস্তাশ্চ তন্নিকটমাগত্য স্ৱাস্থ্যং প্ৰাপুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","সৰ্ৱ্ৱেষাং স্ৱাস্থ্যকৰণপ্ৰভাৱস্য প্ৰকাশিতৎৱাৎ সৰ্ৱ্ৱে লোকা এত্য তং স্প্ৰষ্টুং যেতিৰে| ");
INSERT INTO sanasm_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","পশ্চাৎ স শিষ্যান্ প্ৰতি দৃষ্টিং কুৎৱা জগাদ, হে দৰিদ্ৰা যূযং ধন্যা যত ঈশ্ৱৰীযে ৰাজ্যে ৱোঽধিকাৰোস্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","হে অধুনা ক্ষুধিতলোকা যূযং ধন্যা যতো যূযং তৰ্প্স্যথ; হে ইহ ৰোদিনো জনা যূযং ধন্যা যতো যূযং হসিষ্যথ| ");
INSERT INTO sanasm_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","যদা লোকা মনুষ্যসূনো ৰ্নামহেতো ৰ্যুষ্মান্ ঋृতীযিষ্যন্তে পৃথক্ কৃৎৱা নিন্দিষ্যন্তি, অধমানিৱ যুষ্মান্ স্ৱসমীপাদ্ দূৰীকৰিষ্যন্তি চ তদা যূযং ধন্যাঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","স্ৱৰ্গে যুষ্মাকং যথেষ্টং ফলং ভৱিষ্যতি, এতদৰ্থং তস্মিন্ দিনে প্ৰোল্লসত আনন্দেন নৃত্যত চ, তেষাং পূৰ্ৱ্ৱপুৰুষাশ্চ ভৱিষ্যদ্ৱাদিনঃ প্ৰতি তথৈৱ ৱ্যৱাহৰন্| ");
INSERT INTO sanasm_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","কিন্তু হা হা ধনৱন্তো যূযং সুখং প্ৰাপ্নুত| হন্ত পৰিতৃপ্তা যূযং ক্ষুধিতা ভৱিষ্যথ; ");
INSERT INTO sanasm_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ইহ হসন্তো যূযং ৱত যুষ্মাভিঃ শোচিতৱ্যং ৰোদিতৱ্যঞ্চ| ");
INSERT INTO sanasm_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","সৰ্ৱ্ৱৈলাকৈ ৰ্যুষ্মাকং সুখ্যাতৌ কৃতাযাং যুষ্মাকং দুৰ্গতি ৰ্ভৱিষ্যতি যুষ্মাকং পূৰ্ৱ্ৱপুৰুষা মৃষাভৱিষ্যদ্ৱাদিনঃ প্ৰতি তদ্ৱৎ কৃতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","হে শ্ৰোতাৰো যুষ্মভ্যমহং কথযামি, যূযং শত্ৰুষু প্ৰীযধ্ৱং যে চ যুষ্মান্ দ্ৱিষন্তি তেষামপি হিতং কুৰুত| ");
INSERT INTO sanasm_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","যে চ যুষ্মান্ শপন্তি তেভ্য আশিষং দত্ত যে চ যুষ্মান্ অৱমন্যন্তে তেষাং মঙ্গলং প্ৰাৰ্থযধ্ৱং| ");
INSERT INTO sanasm_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","যদি কশ্চিৎ তৱ কপোলে চপেটাঘাতং কৰোতি তৰ্হি তং প্ৰতি কপোলম্ অন্যং পৰাৱৰ্ত্ত্য সম্মুখীকুৰু পুনশ্চ যদি কশ্চিৎ তৱ গাত্ৰীযৱস্ত্ৰং হৰতি তৰ্হি তং পৰিধেযৱস্ত্ৰম্ অপি গ্ৰহীতুং মা ৱাৰয| ");
INSERT INTO sanasm_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","যস্ত্ৱাং যাচতে তস্মৈ দেহি, যশ্চ তৱ সম্পত্তিং হৰতি তং মা যাচস্ৱ| ");
INSERT INTO sanasm_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","পৰেভ্যঃ স্ৱান্ প্ৰতি যথাচৰণম্ অপেক্ষধ্ৱে পৰান্ প্ৰতি যূযমপি তথাচৰত| ");
INSERT INTO sanasm_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","যে জনা যুষ্মাসু প্ৰীযন্তে কেৱলং তেষু প্ৰীযমাণেষু যুষ্মাকং কিং ফলং? পাপিলোকা অপি স্ৱেষু প্ৰীযমাণেষু প্ৰীযন্তে| ");
INSERT INTO sanasm_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","যদি হিতকাৰিণ এৱ হিতং কুৰুথ তৰ্হি যুষ্মাকং কিং ফলং? পাপিলোকা অপি তথা কুৰ্ৱ্ৱন্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","যেভ্য ঋণপৰিশোধস্য প্ৰাপ্তিপ্ৰত্যাশাস্তে কেৱলং তেষু ঋণে সমৰ্পিতে যুষ্মাকং কিং ফলং? পুনঃ প্ৰাপ্ত্যাশযা পাপীলোকা অপি পাপিজনেষু ঋণম্ অৰ্পযন্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","অতো যূযং ৰিপুষ্ৱপি প্ৰীযধ্ৱং, পৰহিতং কুৰুত চ; পুনঃ প্ৰাপ্ত্যাশাং ত্যক্ত্ৱা ঋণমৰ্পযত, তথা কৃতে যুষ্মাকং মহাফলং ভৱিষ্যতি, যূযঞ্চ সৰ্ৱ্ৱপ্ৰধানস্য সন্তানা ইতি খ্যাতিং প্ৰাপ্স্যথ, যতো যুষ্মাকং পিতা কৃতঘ্নানাং দুৰ্ৱ্টত্তানাঞ্চ হিতমাচৰতি| ");
INSERT INTO sanasm_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","অত এৱ স যথা দযালু ৰ্যূযমপি তাদৃশা দযালৱো ভৱত| ");
INSERT INTO sanasm_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","অপৰঞ্চ পৰান্ দোষিণো মা কুৰুত তস্মাদ্ যূযং দোষীকৃতা ন ভৱিষ্যথ; অদণ্ড্যান্ মা দণ্ডযত তস্মাদ্ যূযমপি দণ্ডং ন প্ৰাপ্স্যথ; পৰেষাং দোষান্ ক্ষমধ্ৱং তস্মাদ্ যুষ্মাকমপি দোষাঃ ক্ষমিষ্যন্তে| ");
INSERT INTO sanasm_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","দানানিদত্ত তস্মাদ্ যূযং দানানি প্ৰাপ্স্যথ, ৱৰঞ্চ লোকাঃ পৰিমাণপাত্ৰং প্ৰদলয্য সঞ্চাল্য প্ৰোঞ্চাল্য পৰিপূৰ্য্য যুষ্মাকং ক্ৰোডেষু সমৰ্পযিষ্যন্তি; যূযং যেন পৰিমাণেন পৰিমাথ তেনৈৱ পৰিমাণেন যুষ্মৎকৃতে পৰিমাস্যতে| ");
INSERT INTO sanasm_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","অথ স তেভ্যো দৃষ্টান্তকথামকথযৎ, অন্ধো জনঃ কিমন্ধং পন্থানং দৰ্শযিতুং শক্নোতি? তস্মাদ্ উভাৱপি কিং গৰ্ত্তে ন পতিষ্যতঃ? ");
INSERT INTO sanasm_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","গুৰোঃ শিষ্যো ন শ্ৰেষ্ঠঃ কিন্তু শিষ্যে সিদ্ধে সতি স গুৰুতুল্যো ভৱিতুং শক্নোতি| ");
INSERT INTO sanasm_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","অপৰঞ্চ ৎৱং স্ৱচক্ষুुষি নাসাম্ অদৃষ্ট্ৱা তৱ ভ্ৰাতুশ্চক্ষুষি যত্তৃণমস্তি তদেৱ কুতঃ পশ্যমি? ");
INSERT INTO sanasm_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","স্ৱচক্ষুষি যা নাসা ৱিদ্যতে তাম্ অজ্ঞাৎৱা, ভ্ৰাতস্তৱ নেত্ৰাৎ তৃণং বহিঃ কৰোমীতি ৱাক্যং ভ্ৰাতৰং কথং ৱক্তুং শক্নোষি? হে কপটিন্ পূৰ্ৱ্ৱং স্ৱনযনাৎ নাসাং বহিঃ কুৰু ততো ভ্ৰাতুশ্চক্ষুষস্তৃণং বহিঃ কৰ্ত্তুং সুদৃষ্টিং প্ৰাপ্স্যসি| ");
INSERT INTO sanasm_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","অন্যঞ্চ উত্তমস্তৰুঃ কদাপি ফলমনুত্তমং ন ফলতি, অনুত্তমতৰুশ্চ ফলমুত্তমং ন ফলতি কাৰণাদতঃ ফলৈস্তৰৱো জ্ঞাযন্তে| ");
INSERT INTO sanasm_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","কণ্টকিপাদপাৎ কোপি উডুম্বৰফলানি ন পাতযতি তথা শৃগালকোলিৱৃক্ষাদপি কোপি দ্ৰাক্ষাফলং ন পাতযতি| ");
INSERT INTO sanasm_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","তদ্ৱৎ সাধুলোকোঽন্তঃকৰণৰূপাৎ সুভাণ্ডাগাৰাদ্ উত্তমানি দ্ৰৱ্যাণি বহিঃ কৰোতি, দুষ্টো লোকশ্চান্তঃকৰণৰূপাৎ কুভাণ্ডাগাৰাৎ কুৎসিতানি দ্ৰৱ্যাণি নিৰ্গমযতি যতোঽন্তঃকৰণানাং পূৰ্ণভাৱানুৰূপাণি ৱচাংসি মুখান্নিৰ্গচ্ছন্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","অপৰঞ্চ মমাজ্ঞানুৰূপং নাচৰিৎৱা কুতো মাং প্ৰভো প্ৰভো ইতি ৱদথ? ");
INSERT INTO sanasm_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","যঃ কশ্চিন্ মম নিকটম্ আগত্য মম কথা নিশম্য তদনুৰূপং কৰ্ম্ম কৰোতি স কস্য সদৃশো ভৱতি তদহং যুষ্মান্ জ্ঞাाপযামি| ");
INSERT INTO sanasm_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","যো জনো গভীৰং খনিৎৱা পাষাণস্থলে ভিত্তিং নিৰ্ম্মায স্ৱগৃহং ৰচযতি তেন সহ তস্যোপমা ভৱতি; যত আপ্লাৱিজলমেত্য তস্য মূলে ৱেগেন ৱহদপি তদ্গেহং লাডযিতুং ন শক্নোতি যতস্তস্য ভিত্তিঃ পাষাণোপৰি তিষ্ঠতি| ");
INSERT INTO sanasm_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","কিন্তু যঃ কশ্চিন্ মম কথাঃ শ্ৰুৎৱা তদনুৰূপং নাচৰতি স ভিত্তিং ৱিনা মৃृদুপৰি গৃহনিৰ্ম্মাত্ৰা সমানো ভৱতি; যত আপ্লাৱিজলমাগত্য ৱেগেন যদা ৱহতি তদা তদ্গৃহং পততি তস্য মহৎ পতনং জাযতে| ");
INSERT INTO sanasm_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","ততঃ পৰং স লোকানাং কৰ্ণগোচৰে তান্ সৰ্ৱ্ৱান্ উপদেশান্ সমাপ্য যদা কফৰ্নাহূম্পুৰং প্ৰৱিশতি ");
INSERT INTO sanasm_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","তদা শতসেনাপতেঃ প্ৰিযদাস একো মৃতকল্পঃ পীডিত আসীৎ| ");
INSERT INTO sanasm_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","অতঃ সেনাপতি ৰ্যীশো ৰ্ৱাৰ্ত্তাং নিশম্য দাসস্যাৰোগ্যকৰণায তস্যাগমনাৰ্থং ৱিনযকৰণায যিহূদীযান্ কিযতঃ প্ৰাচঃ প্ৰেষযামাস| ");
INSERT INTO sanasm_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","তে যীশোৰন্তিকং গৎৱা ৱিনযাতিশযং ৱক্তুমাৰেভিৰে, স সেনাপতি ৰ্ভৱতোনুগ্ৰহং প্ৰাপ্তুম্ অৰ্হতি| ");
INSERT INTO sanasm_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","যতঃ সোস্মজ্জাতীযেষু লোকেষু প্ৰীযতে তথাস্মৎকৃতে ভজনগেহং নিৰ্ম্মিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","তস্মাদ্ যীশুস্তৈঃ সহ গৎৱা নিৱেশনস্য সমীপং প্ৰাপ, তদা স শতসেনাপতি ৰ্ৱক্ষ্যমাণৱাক্যং তং ৱক্তুং বন্ধূন্ প্ৰাহিণোৎ| হে প্ৰভো স্ৱযং শ্ৰমো ন কৰ্ত্তৱ্যো যদ্ ভৱতা মদ্গেহমধ্যে পাদাৰ্পণং ক্ৰিযেত তদপ্যহং নাৰ্হামি, ");
INSERT INTO sanasm_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","কিঞ্চাহং ভৱৎসমীপং যাতুমপি নাত্মানং যোগ্যং বুদ্ধৱান্, ততো ভৱান্ ৱাক্যমাত্ৰং ৱদতু তেনৈৱ মম দাসঃ স্ৱস্থো ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","যস্মাদ্ অহং পৰাধীনোপি মমাধীনা যাঃ সেনাঃ সন্তি তাসাম্ একজনং প্ৰতি যাহীতি মযা প্ৰোক্তে স যাতি; তদন্যং প্ৰতি আযাহীতি প্ৰোক্তে স আযাতি; তথা নিজদাসং প্ৰতি এতৎ কুৰ্ৱ্ৱিতি প্ৰোক্তে স তদেৱ কৰোতি| ");
INSERT INTO sanasm_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","যীশুৰিদং ৱাক্যং শ্ৰুৎৱা ৱিস্মযং যযৌ, মুখং পৰাৱৰ্ত্য পশ্চাদ্ৱৰ্ত্তিনো লোকান্ বভাষে চ, যুষ্মানহং ৱদামি ইস্ৰাযেলো ৱংশমধ্যেপি ৱিশ্ৱাসমীদৃশং ন প্ৰাপ্নৱং| ");
INSERT INTO sanasm_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ততস্তে প্ৰেষিতা গৃহং গৎৱা তং পীডিতং দাসং স্ৱস্থং দদৃশুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","পৰেঽহনি স নাযীনাখ্যং নগৰং জগাম তস্যানেকে শিষ্যা অন্যে চ লোকাস্তেন সাৰ্দ্ধং যযুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","তেষু তন্নগৰস্য দ্ৱাৰসন্নিধিং প্ৰাপ্তেষু কিযন্তো লোকা একং মৃতমনুজং ৱহন্তো নগৰস্য বহিৰ্যান্তি, স তন্মাতুৰেকপুত্ৰস্তন্মাতা চ ৱিধৱা; তযা সাৰ্দ্ধং তন্নগৰীযা বহৱো লোকা আসন্| ");
INSERT INTO sanasm_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","প্ৰভুস্তাং ৱিলোক্য সানুকম্পঃ কথযামাস, মা ৰোদীঃ| স সমীপমিৎৱা খট্ৱাং পস্পৰ্শ তস্মাদ্ ৱাহকাঃ স্থগিতাস্তম্যুঃ; ");
INSERT INTO sanasm_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","তদা স উৱাচ হে যুৱমনুষ্য ৎৱমুত্তিষ্ঠ, ৎৱামহম্ আজ্ঞাপযামি| ");
INSERT INTO sanasm_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","তস্মাৎ স মৃতো জনস্তৎক্ষণমুত্থায কথাং প্ৰকথিতঃ; ততো যীশুস্তস্য মাতৰি তং সমৰ্পযামাস| ");
INSERT INTO sanasm_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","তস্মাৎ সৰ্ৱ্ৱে লোকাঃ শশঙ্কিৰে; একো মহাভৱিষ্যদ্ৱাদী মধ্যেঽস্মাকম্ সমুদৈৎ, ঈশ্ৱৰশ্চ স্ৱলোকানন্ৱগৃহ্লাৎ কথামিমাং কথযিৎৱা ঈশ্ৱৰং ধন্যং জগদুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ততঃ পৰং সমস্তং যিহূদাদেশং তস্য চতুৰ্দিক্স্থদেশঞ্চ তস্যৈতৎকীৰ্ত্তি ৰ্ৱ্যানশে| ");
INSERT INTO sanasm_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ততঃ পৰং যোহনঃ শিষ্যেষু তং তদ্ৱৃত্তান্তং জ্ঞাপিতৱৎসু ");
INSERT INTO sanasm_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","স স্ৱশিষ্যাণাং দ্ৱৌ জনাৱাহূয যীশুং প্ৰতি ৱক্ষ্যমাণং ৱাক্যং ৱক্তুং প্ৰেষযামাস, যস্যাগমনম্ অপেক্ষ্য তিষ্ঠামো ৱযং কিং স এৱ জনস্ত্ৱং? কিং ৱযমন্যমপেক্ষ্য স্থাস্যামঃ? ");
INSERT INTO sanasm_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","পশ্চাত্তৌ মানৱৌ গৎৱা কথযামাসতুঃ, যস্যাগমনম্ অপেক্ষ্য তিষ্ঠামো ৱযং, কিং সএৱ জনস্ত্ৱং? কিং ৱযমন্যমপেক্ষ্য স্থাস্যামঃ? কথামিমাং তুভ্যং কথযিতুং যোহন্ মজ্জক আৱাং প্ৰেষিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","তস্মিন্ দণ্ডে যীশূৰোগিণো মহাৱ্যাধিমতো দুষ্টভূতগ্ৰস্তাংশ্চ বহূন্ স্ৱস্থান্ কৃৎৱা, অনেকান্ধেভ্যশ্চক্ষুংষি দত্ত্ৱা প্ৰত্যুৱাচ, ");
INSERT INTO sanasm_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","যুৱাং ৱ্ৰজতম্ অন্ধা নেত্ৰাণি খঞ্জাশ্চৰণানি চ প্ৰাপ্নুৱন্তি, কুষ্ঠিনঃ পৰিষ্ক্ৰিযন্তে, বধিৰাঃ শ্ৰৱণানি মৃতাশ্চ জীৱনানি প্ৰাপ্নুৱন্তি, দৰিদ্ৰাণাং সমীপেষু সুসংৱাদঃ প্ৰচাৰ্য্যতে, যং প্ৰতি ৱিঘ্নস্ৱৰূপোহং ন ভৱামি স ধন্যঃ, ");
INSERT INTO sanasm_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","এতানি যানি পশ্যথঃ শৃণুথশ্চ তানি যোহনং জ্ঞাপযতম্| ");
INSERT INTO sanasm_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","তযো ৰ্দূতযো ৰ্গতযোঃ সতো ৰ্যোহনি স লোকান্ ৱক্তুমুপচক্ৰমে, যূযং মধ্যেপ্ৰান্তৰং কিং দ্ৰষ্টুং নিৰগমত? কিং ৱাযুনা কম্পিতং নডং? ");
INSERT INTO sanasm_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","যূযং কিং দ্ৰষ্টুং নিৰগমত? কিং সূক্ষ্মৱস্ত্ৰপৰিধাযিনং কমপি নৰং? কিন্তু যে সূক্ষ্মমৃদুৱস্ত্ৰাণি পৰিদধতি সূত্তমানি দ্ৰৱ্যাণি ভুঞ্জতে চ তে ৰাজধানীষু তিষ্ঠন্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","তৰ্হি যূযং কিং দ্ৰষ্টুং নিৰগমত? কিমেকং ভৱিষ্যদ্ৱাদিনং? তদেৱ সত্যং কিন্তু স পুমান্ ভৱিষ্যদ্ৱাদিনোপি শ্ৰেষ্ঠ ইত্যহং যুষ্মান্ ৱদামি; ");
INSERT INTO sanasm_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","পশ্য স্ৱকীযদূতন্তু তৱাগ্ৰ প্ৰেষযাম্যহং| গৎৱা ৎৱদীযমাৰ্গন্তু স হি পৰিষ্কৰিষ্যতি| যদৰ্থে লিপিৰিযম্ আস্তে স এৱ যোহন্| ");
INSERT INTO sanasm_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","অতো যুষ্মানহং ৱদামি স্ত্ৰিযা গৰ্ব্ভজাতানাং ভৱিষ্যদ্ৱাদিনাং মধ্যে যোহনো মজ্জকাৎ শ্ৰেষ্ঠঃ কোপি নাস্তি, তত্ৰাপি ঈশ্ৱৰস্য ৰাজ্যে যঃ সৰ্ৱ্ৱস্মাৎ ক্ষুদ্ৰঃ স যোহনোপি শ্ৰেষ্ঠঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","অপৰঞ্চ সৰ্ৱ্ৱে লোকাঃ কৰমঞ্চাযিনশ্চ তস্য ৱাক্যানি শ্ৰুৎৱা যোহনা মজ্জনেন মজ্জিতাঃ পৰমেশ্ৱৰং নিৰ্দোষং মেনিৰে| ");
INSERT INTO sanasm_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","কিন্তু ফিৰূশিনো ৱ্যৱস্থাপকাশ্চ তেন ন মজ্জিতাঃ স্ৱান্ প্ৰতীশ্ৱৰস্যোপদেশং নিষ্ফলম্ অকুৰ্ৱ্ৱন্| ");
INSERT INTO sanasm_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","অথ প্ৰভুঃ কথযামাস, ইদানীন্তনজনান্ কেনোপমামি? তে কস্য সদৃশাঃ? ");
INSERT INTO sanasm_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","যে বালকা ৱিপণ্যাম্ উপৱিশ্য পৰস্পৰম্ আহূয ৱাক্যমিদং ৱদন্তি, ৱযং যুষ্মাকং নিকটে ৱংশীৰৱাদিষ্ম, কিন্তু যূযং নানৰ্ত্তিষ্ট, ৱযং যুষ্মাকং নিকট অৰোদিষ্ম, কিন্তু যুযং ন ৱ্যলপিষ্ট, বালকৈৰেতাদৃশৈস্তেষাম্ উপমা ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","যতো যোহন্ মজ্জক আগত্য পূপং নাখাদৎ দ্ৰাক্ষাৰসঞ্চ নাপিৱৎ তস্মাদ্ যূযং ৱদথ, ভূতগ্ৰস্তোযম্| ");
INSERT INTO sanasm_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","ততঃ পৰং মানৱসুত আগত্যাখাদদপিৱঞ্চ তস্মাদ্ যূযং ৱদথ, খাদকঃ সুৰাপশ্চাণ্ডালপাপিনাং বন্ধুৰেকো জনো দৃশ্যতাম্| ");
INSERT INTO sanasm_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","কিন্তু জ্ঞানিনো জ্ঞানং নিৰ্দোষং ৱিদুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","পশ্চাদেকঃ ফিৰূশী যীশুং ভোজনায ন্যমন্ত্ৰযৎ ততঃ স তস্য গৃহং গৎৱা ভোক্তুমুপৱিষ্টঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","এতৰ্হি তৎফিৰূশিনো গৃহে যীশু ৰ্ভেক্তুম্ উপাৱেক্ষীৎ তচ্ছ্ৰুৎৱা তন্নগৰৱাসিনী কাপি দুষ্টা নাৰী পাণ্ডৰপ্ৰস্তৰস্য সম্পুটকে সুগন্ধিতৈলম্ আনীয ");
INSERT INTO sanasm_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","তস্য পশ্চাৎ পাদযোঃ সন্নিধৌ তস্যৌ ৰুদতী চ নেত্ৰাম্বুভিস্তস্য চৰণৌ প্ৰক্ষাল্য নিজকচৈৰমাৰ্ক্ষীৎ, ততস্তস্য চৰণৌ চুম্বিৎৱা তেন সুগন্ধিতৈলেন মমৰ্দ| ");
INSERT INTO sanasm_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","তস্মাৎ স নিমন্ত্ৰযিতা ফিৰূশী মনসা চিন্তযামাস, যদ্যযং ভৱিষ্যদ্ৱাদী ভৱেৎ তৰ্হি এনং স্পৃশতি যা স্ত্ৰী সা কা কীদৃশী চেতি জ্ঞাতুং শক্নুযাৎ যতঃ সা দুষ্টা| ");
INSERT INTO sanasm_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","তদা যাশুস্তং জগাদ, হে শিমোন্ ৎৱাং প্ৰতি মম কিঞ্চিদ্ ৱক্তৱ্যমস্তি; তস্মাৎ স বভাষে, হে গুৰো তদ্ ৱদতু| ");
INSERT INTO sanasm_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","একোত্তমৰ্ণস্য দ্ৱাৱধমৰ্ণাৱাস্তাং, তযোৰেকঃ পঞ্চশতানি মুদ্ৰাপাদান্ অপৰশ্চ পঞ্চাশৎ মুদ্ৰাপাদান্ ধাৰযামাস| ");
INSERT INTO sanasm_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","তদনন্তৰং তযোঃ শোধ্যাভাৱাৎ স উত্তমৰ্ণস্তযো ৰৃণে চক্ষমে; তস্মাৎ তযোৰ্দ্ৱযোঃ কস্তস্মিন্ প্ৰেষ্যতে বহু? তদ্ ব্ৰূহি| ");
INSERT INTO sanasm_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","শিমোন্ প্ৰত্যুৱাচ, মযা বুধ্যতে যস্যাধিকম্ ঋণং চক্ষমে স ইতি; ততো যীশুস্তং ৱ্যাজহাৰ, ৎৱং যথাৰ্থং ৱ্যচাৰযঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","অথ তাং নাৰীং প্ৰতি ৱ্যাঘুঠ্য শিমোনমৱোচৎ, স্ত্ৰীমিমাং পশ্যসি? তৱ গৃহে ময্যাগতে ৎৱং পাদপ্ৰক্ষালনাৰ্থং জলং নাদাঃ কিন্তু যোষিদেষা নযনজলৈ ৰ্মম পাদৌ প্ৰক্ষাল্য কেশৈৰমাৰ্ক্ষীৎ| ");
INSERT INTO sanasm_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ৎৱং মাং নাচুম্বীঃ কিন্তু যোষিদেষা স্ৱীযাগমনাদাৰভ্য মদীযপাদৌ চুম্বিতুং ন ৱ্যৰংস্ত| ");
INSERT INTO sanasm_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ৎৱঞ্চ মদীযোত্তমাঙ্গে কিঞ্চিদপি তৈলং নামৰ্দীঃ কিন্তু যোষিদেষা মম চৰণৌ সুগন্ধিতৈলেনামৰ্দ্দীৎ| ");
INSERT INTO sanasm_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","অতস্ত্ৱাং ৱ্যাহৰামি, এতস্যা বহু পাপমক্ষম্যত ততো বহু প্ৰীযতে কিন্তু যস্যাল্পপাপং ক্ষম্যতে সোল্পং প্ৰীযতে| ");
INSERT INTO sanasm_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ততঃ পৰং স তাং বভাষে, ৎৱদীযং পাপমক্ষম্যত| ");
INSERT INTO sanasm_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","তদা তেন সাৰ্দ্ধং যে ভোক্তুম্ উপৱিৱিশুস্তে পৰস্পৰং ৱক্তুমাৰেভিৰে, অযং পাপং ক্ষমতে ক এষঃ? ");
INSERT INTO sanasm_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","কিন্তু স তাং নাৰীং জগাদ, তৱ ৱিশ্ৱাসস্ত্ৱাং পৰ্য্যত্ৰাস্ত ৎৱং ক্ষেমেণ ৱ্ৰজ| ");
INSERT INTO sanasm_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","অপৰঞ্চ যীশু ৰ্দ্ৱাদশভিঃ শিষ্যৈঃ সাৰ্দ্ধং নানানগৰেষু নানাগ্ৰামেষু চ গচ্ছন্ ইশ্ৱৰীযৰাজৎৱস্য সুসংৱাদং প্ৰচাৰযিতুং প্ৰাৰেভে| ");
INSERT INTO sanasm_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","তদা যস্যাঃ সপ্ত ভূতা নিৰগচ্ছন্ সা মগ্দলীনীতি ৱিখ্যাতা মৰিযম্ হেৰোদ্ৰাজস্য গৃহাধিপতেঃ হোষে ৰ্ভাৰ্য্যা যোহনা শূশানা ");
INSERT INTO sanasm_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","প্ৰভৃতযো যা বহ্ৱ্যঃ স্ত্ৰিযঃ দুষ্টভূতেভ্যো ৰোগেভ্যশ্চ মুক্তাঃ সত্যো নিজৱিভূতী ৰ্ৱ্যযিৎৱা তমসেৱন্ত, তাঃ সৰ্ৱ্ৱাস্তেন সাৰ্দ্ধম্ আসন্| ");
INSERT INTO sanasm_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","অনন্তৰং নানানগৰেভ্যো বহৱো লোকা আগত্য তস্য সমীপেঽমিলন্, তদা স তেভ্য একাং দৃষ্টান্তকথাং কথযামাস| একঃ কৃষীবলো বীজানি ৱপ্তুং বহিৰ্জগাম, ");
INSERT INTO sanasm_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","ততো ৱপনকালে কতিপযানি বীজানি মাৰ্গপাৰ্শ্ৱে পেতুঃ, ততস্তানি পদতলৈ ৰ্দলিতানি পক্ষিভি ৰ্ভক্ষিতানি চ| ");
INSERT INTO sanasm_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","কতিপযানি বীজানি পাষাণস্থলে পতিতানি যদ্যপি তান্যঙ্কুৰিতানি তথাপি ৰসাভাৱাৎ শুশুষুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","কতিপযানি বীজানি কণ্টকিৱনমধ্যে পতিতানি ততঃ কণ্টকিৱনানি সংৱৃদ্ধ্য তানি জগ্ৰসুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","তদন্যানি কতিপযবীজানি চ ভূম্যামুত্তমাযাং পেতুস্ততস্তান্যঙ্কুৰযিৎৱা শতগুণানি ফলানি ফেলুঃ| স ইমা কথাং কথযিৎৱা প্ৰোচ্চৈঃ প্ৰোৱাচ, যস্য শ্ৰোতুং শ্ৰোত্ৰে স্তঃ স শৃণোতু| ");
INSERT INTO sanasm_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ততঃ পৰং শিষ্যাস্তং পপ্ৰচ্ছুৰস্য দৃষ্টান্তস্য কিং তাৎপৰ্য্যং? ");
INSERT INTO sanasm_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ততঃ স ৱ্যাজহাৰ, ঈশ্ৱৰীযৰাজ্যস্য গুহ্যানি জ্ঞাতুং যুষ্মভ্যমধিকাৰো দীযতে কিন্ত্ৱন্যে যথা দৃষ্ট্ৱাপি ন পশ্যন্তি শ্ৰুৎৱাপি ম বুধ্যন্তে চ তদৰ্থং তেষাং পুৰস্তাৎ তাঃ সৰ্ৱ্ৱাঃ কথা দৃষ্টান্তেন কথ্যন্তে| ");
INSERT INTO sanasm_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","দৃষ্টান্তস্যাস্যাভিপ্ৰাযঃ, ঈশ্ৱৰীযকথা বীজস্ৱৰূপা| ");
INSERT INTO sanasm_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","যে কথামাত্ৰং শৃণ্ৱন্তি কিন্তু পশ্চাদ্ ৱিশ্ৱস্য যথা পৰিত্ৰাণং ন প্ৰাপ্নুৱন্তি তদাশযেন শৈতানেত্য হৃদযাতৃ তাং কথাম্ অপহৰতি ত এৱ মাৰ্গপাৰ্শ্ৱস্থভূমিস্ৱৰূপাঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","যে কথং শ্ৰুৎৱা সানন্দং গৃহ্লন্তি কিন্ত্ৱবদ্ধমূলৎৱাৎ স্ৱল্পকালমাত্ৰং প্ৰতীত্য পৰীক্ষাকালে ভ্ৰশ্যন্তি তএৱ পাষাণভূমিস্ৱৰূপাঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","যে কথাং শ্ৰুৎৱা যান্তি ৱিষযচিন্তাযাং ধনলোভেন এेহিকসুখে চ মজ্জন্ত উপযুক্তফলানি ন ফলন্তি ত এৱোপ্তবীজকণ্টকিভূস্ৱৰূপাঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","কিন্তু যে শ্ৰুৎৱা সৰলৈঃ শুদ্ধৈশ্চান্তঃকৰণৈঃ কথাং গৃহ্লন্তি ধৈৰ্য্যম্ অৱলম্ব্য ফলান্যুৎপাদযন্তি চ ত এৱোত্তমমৃৎস্ৱৰূপাঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","অপৰঞ্চ প্ৰদীপং প্ৰজ্ৱাল্য কোপি পাত্ৰেণ নাচ্ছাদযতি তথা খট্ৱাধোপি ন স্থাপযতি, কিন্তু দীপাধাৰোপৰ্য্যেৱ স্থাপযতি, তস্মাৎ প্ৰৱেশকা দীপ্তিং পশ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","যন্ন প্ৰকাশযিষ্যতে তাদৃগ্ অপ্ৰকাশিতং ৱস্তু কিমপি নাস্তি যচ্চ ন সুৱ্যক্তং প্ৰচাৰযিষ্যতে তাদৃগ্ গৃপ্তং ৱস্তু কিমপি নাস্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","অতো যূযং কেন প্ৰকাৰেণ শৃণুথ তত্ৰ সাৱধানা ভৱত, যস্য সমীপে বৰ্দ্ধতে তস্মৈ পুনৰ্দাস্যতে কিন্তু যস্যাশ্ৰযে ন বৰ্দ্ধতে তস্য যদ্যদস্তি তদপি তস্মাৎ নেষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","অপৰঞ্চ যীশো ৰ্মাতা ভ্ৰাতৰশ্চ তস্য সমীপং জিগমিষৱঃ ");
INSERT INTO sanasm_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","কিন্তু জনতাসম্বাধাৎ তৎসন্নিধিং প্ৰাপ্তুং ন শেকুঃ| তৎপশ্চাৎ তৱ মাতা ভ্ৰাতৰশ্চ ৎৱাং সাক্ষাৎ চিকীৰ্ষন্তো বহিস্তিষ্ঠনতীতি ৱাৰ্ত্তাযাং তস্মৈ কথিতাযাং ");
INSERT INTO sanasm_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","স প্ৰত্যুৱাচ; যে জনা ঈশ্ৱৰস্য কথাং শ্ৰুৎৱা তদনুৰূপমাচৰন্তি তএৱ মম মাতা ভ্ৰাতৰশ্চ| ");
INSERT INTO sanasm_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","অনন্তৰং একদা যীশুঃ শিষ্যৈঃ সাৰ্দ্ধং নাৱমাৰুহ্য জগাদ, আযাত ৱযং হ্ৰদস্য পাৰং যামঃ, ততস্তে জগ্মুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","তেষু নৌকাং ৱাহযৎসু স নিদদ্ৰৌ; ");
INSERT INTO sanasm_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","অথাকস্মাৎ প্ৰবলঝঞ্ভ্শগমাদ্ হ্ৰদে নৌকাযাং তৰঙ্গৈৰাচ্ছন্নাযাং ৱিপৎ তান্ জগ্ৰাস| তস্মাদ্ যীশোৰন্তিকং গৎৱা হে গুৰো হে গুৰো প্ৰাণা নো যান্তীতি গদিৎৱা তং জাগৰযাম্বভূৱুঃ| তদা স উত্থায ৱাযুং তৰঙ্গাংশ্চ তৰ্জযামাস তস্মাদুভৌ নিৱৃত্য স্থিৰৌ বভূৱতুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","স তান্ বভাষে যুষ্মাকং ৱিশ্ৱাসঃ ক? তস্মাত্তে ভীতা ৱিস্মিতাশ্চ পৰস্পৰং জগদুঃ, অহো কীদৃগযং মনুজঃ পৱনং পানীযঞ্চাদিশতি তদুভযং তদাদেশং ৱহতি| ");
INSERT INTO sanasm_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ততঃ পৰং গালীল্প্ৰদেশস্য সম্মুখস্থগিদেৰীযপ্ৰদেশে নৌকাযাং লগন্ত্যাং তটেঽৱৰোহমাৱাদ্ ");
INSERT INTO sanasm_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","বহুতিথকালং ভূতগ্ৰস্ত একো মানুষঃ পুৰাদাগত্য তং সাক্ষাচ্চকাৰ| স মনুষো ৱাসো ন পৰিদধৎ গৃহে চ ন ৱসন্ কেৱলং শ্মশানম্ অধ্যুৱাস| ");
INSERT INTO sanasm_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","স যীশুং দৃষ্ট্ৱৈৱ চীচ্ছব্দং চকাৰ তস্য সম্মুখে পতিৎৱা প্ৰোচ্চৈৰ্জগাদ চ, হে সৰ্ৱ্ৱপ্ৰধানেশ্ৱৰস্য পুত্ৰ, মযা সহ তৱ কঃ সম্বন্ধঃ? ৎৱযি ৱিনযং কৰোমি মাং মা যাতয| ");
INSERT INTO sanasm_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","যতঃ স তং মানুষং ত্যক্ত্ৱা যাতুম্ অমেধ্যভূতম্ আদিদেশ; স ভূতস্তং মানুষম্ অসকৃদ্ দধাৰ তস্মাল্লোকাঃ শৃঙ্খলেন নিগডেন চ ববন্ধুঃ; স তদ্ ভংক্ত্ৱা ভূতৱশৎৱাৎ মধ্যেপ্ৰান্তৰং যযৌ| ");
INSERT INTO sanasm_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","অনন্তৰং যীশুস্তং পপ্ৰচ্ছ তৱ কিন্নাম? স উৱাচ, মম নাম বাহিনো যতো বহৱো ভূতাস্তমাশিশ্ৰিযুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","অথ ভূতা ৱিনযেন জগদুঃ, গভীৰং গৰ্ত্তং গন্তুং মাজ্ঞাপযাস্মান্| ");
INSERT INTO sanasm_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","তদা পৰ্ৱ্ৱতোপৰি ৱৰাহৱ্ৰজশ্চৰতি তস্মাদ্ ভূতা ৱিনযেন প্ৰোচুঃ, অমুং ৱৰাহৱ্ৰজম্ আশ্ৰযিতুম্ অস্মান্ অনুজানীহি; ততঃ সোনুজজ্ঞৌ| ");
INSERT INTO sanasm_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ততঃ পৰং ভূতাস্তং মানুষং ৱিহায ৱৰাহৱ্ৰজম্ আশিশ্ৰিযুঃ ৱৰাহৱ্ৰজাশ্চ তৎক্ষণাৎ কটকেন ধাৱন্তো হ্ৰদে প্ৰাণান্ ৱিজৃহুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","তদ্ দৃষ্ট্ৱা শূকৰৰক্ষকাঃ পলাযমানা নগৰং গ্ৰামঞ্চ গৎৱা তৎসৰ্ৱ্ৱৱৃত্তান্তং কথযামাসুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","ততঃ কিং ৱৃত্তম্ এতদ্দৰ্শনাৰ্থং লোকা নিৰ্গত্য যীশোঃ সমীপং যযুঃ, তং মানুষং ত্যক্তভূতং পৰিহিতৱস্ত্ৰং স্ৱস্থমানুষৱদ্ যীশোশ্চৰণসন্নিধৌ সূপৱিশন্তং ৱিলোক্য বিভ্যুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","যে লোকাস্তস্য ভূতগ্ৰস্তস্য স্ৱাস্থ্যকৰণং দদৃশুস্তে তেভ্যঃ সৰ্ৱ্ৱৱৃত্তান্তং কথযামাসুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","তদনন্তৰং তস্য গিদেৰীযপ্ৰদেশস্য চতুৰ্দিক্স্থা বহৱো জনা অতিত্ৰস্তা ৱিনযেন তং জগদুঃ, ভৱান্ অস্মাকং নিকটাদ্ ৱ্ৰজতু তস্মাৎ স নাৱমাৰুহ্য ততো ৱ্যাঘুট্য জগাম| ");
INSERT INTO sanasm_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","তদানীং ত্যক্তভূতমনুজস্তেন সহ স্থাতুং প্ৰাৰ্থযাঞ্চক্ৰে ");
INSERT INTO sanasm_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","কিন্তু তদৰ্থম্ ঈশ্ৱৰঃ কীদৃঙ্মহাকৰ্ম্ম কৃতৱান্ ইতি নিৱেশনং গৎৱা ৱিজ্ঞাপয, যীশুঃ কথামেতাং কথযিৎৱা তং ৱিসসৰ্জ| ততঃ স ৱ্ৰজিৎৱা যীশুস্তদৰ্থং যন্মহাকৰ্ম্ম চকাৰ তৎ পুৰস্য সৰ্ৱ্ৱত্ৰ প্ৰকাশযিতুং প্ৰাৰেভে| ");
INSERT INTO sanasm_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","অথ যীশৌ পৰাৱৃত্যাগতে লোকাস্তং আদৰেণ জগৃহু ৰ্যস্মাত্তে সৰ্ৱ্ৱে তমপেক্ষাঞ্চক্ৰিৰে| ");
INSERT INTO sanasm_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","তদনন্তৰং যাযীৰ্নাম্নো ভজনগেহস্যৈকোধিপ আগত্য যীশোশ্চৰণযোঃ পতিৎৱা স্ৱনিৱেশনাগমনাৰ্থং তস্মিন্ ৱিনযং চকাৰ, ");
INSERT INTO sanasm_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","যতস্তস্য দ্ৱাদশৱৰ্ষৱযস্কা কন্যৈকাসীৎ সা মৃতকল্পাভৱৎ| ততস্তস্য গমনকালে মাৰ্গে লোকানাং মহান্ সমাগমো বভূৱ| ");
INSERT INTO sanasm_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","দ্ৱাদশৱৰ্ষাণি প্ৰদৰৰোগগ্ৰস্তা নানা ৱৈদ্যৈশ্চিকিৎসিতা সৰ্ৱ্ৱস্ৱং ৱ্যযিৎৱাপি স্ৱাস্থ্যং ন প্ৰাপ্তা যা যোষিৎ সা যীশোঃ পশ্চাদাগত্য তস্য ৱস্ত্ৰগ্ৰন্থিং পস্পৰ্শ| ");
INSERT INTO sanasm_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","তস্মাৎ তৎক্ষণাৎ তস্যা ৰক্তস্ৰাৱো ৰুদ্ধঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","তদানীং যীশুৰৱদৎ কেনাহং স্পৃষ্টঃ? ততোঽনেকৈৰনঙ্গীকৃতে পিতৰস্তস্য সঙ্গিনশ্চাৱদন্, হে গুৰো লোকা নিকটস্থাঃ সন্তস্তৱ দেহে ঘৰ্ষযন্তি, তথাপি কেনাহং স্পৃষ্টইতি ভৱান্ কুতঃ পৃচ্ছতি? ");
INSERT INTO sanasm_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","যীশুঃ কথযামাস, কেনাপ্যহং স্পৃষ্টো, যতো মত্তঃ শক্তি ৰ্নিৰ্গতেতি মযা নিশ্চিতমজ্ঞাযি| ");
INSERT INTO sanasm_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","তদা সা নাৰী স্ৱযং ন গুপ্তেতি ৱিদিৎৱা কম্পমানা সতী তস্য সম্মুখে পপাত; যেন নিমিত্তেন তং পস্পৰ্শ স্পৰ্শমাত্ৰাচ্চ যেন প্ৰকাৰেণ স্ৱস্থাভৱৎ তৎ সৰ্ৱ্ৱং তস্য সাক্ষাদাচখ্যৌ| ");
INSERT INTO sanasm_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ততঃ স তাং জগাদ হে কন্যে সুস্থিৰা ভৱ, তৱ ৱিশ্ৱাসস্ত্ৱাং স্ৱস্থাম্ অকাৰ্ষীৎ ৎৱং ক্ষেমেণ যাহি| ");
INSERT INTO sanasm_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","যীশোৰেতদ্ৱাক্যৱদনকালে তস্যাধিপতে ৰ্নিৱেশনাৎ কশ্চিল্লোক আগত্য তং বভাষে, তৱ কন্যা মৃতা গুৰুং মা ক্লিশান| ");
INSERT INTO sanasm_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","কিন্তু যীশুস্তদাকৰ্ণ্যাধিপতিং ৱ্যাজহাৰ, মা ভৈষীঃ কেৱলং ৱিশ্ৱসিহি তস্মাৎ সা জীৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","অথ তস্য নিৱেশনে প্ৰাপ্তে স পিতৰং যোহনং যাকূবঞ্চ কন্যাযা মাতৰং পিতৰঞ্চ ৱিনা, অন্যং কঞ্চন প্ৰৱেষ্টুং ৱাৰযামাস| ");
INSERT INTO sanasm_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","অপৰঞ্চ যে ৰুদন্তি ৱিলপন্তি চ তান্ সৰ্ৱ্ৱান্ জনান্ উৱাচ, যূযং মা ৰোদিষ্ট কন্যা ন মৃতা নিদ্ৰাতি| ");
INSERT INTO sanasm_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","কিন্তু সা নিশ্চিতং মৃতেতি জ্ঞাৎৱা তে তমুপজহসুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","পশ্চাৎ স সৰ্ৱ্ৱান্ বহিঃ কৃৎৱা কন্যাযাঃ কৰৌ ধৃৎৱাজুহুৱে, হে কন্যে ৎৱমুত্তিষ্ঠ, ");
INSERT INTO sanasm_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","তস্মাৎ তস্যাঃ প্ৰাণেষু পুনৰাগতেষু সা তৎক্ষণাদ্ উত্তস্যৌ| তদানীং তস্যৈ কিঞ্চিদ্ ভক্ষ্যং দাতুম্ আদিদেশ| ");
INSERT INTO sanasm_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ততস্তস্যাঃ পিতৰৌ ৱিস্মযং গতৌ কিন্তু স তাৱাদিদেশ ঘটনাযা এতস্যাঃ কথাং কস্মৈচিদপি মা কথযতং| ");
INSERT INTO sanasm_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","ততঃ পৰং স দ্ৱাদশশিষ্যানাহূয ভূতান্ ত্যাজযিতুং ৰোগান্ প্ৰতিকৰ্ত্তুঞ্চ তেভ্যঃ শক্তিমাধিপত্যঞ্চ দদৌ| ");
INSERT INTO sanasm_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","অপৰঞ্চ ঈশ্ৱৰীযৰাজ্যস্য সুসংৱাদং প্ৰকাশযিতুম্ ৰোগিণামাৰোগ্যং কৰ্ত্তুঞ্চ প্ৰেৰণকালে তান্ জগাদ| ");
INSERT INTO sanasm_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","যাত্ৰাৰ্থং যষ্টি ৰ্ৱস্ত্ৰপুটকং ভক্ষ্যং মুদ্ৰা দ্ৱিতীযৱস্ত্ৰম্, এষাং কিমপি মা গৃহ্লীত| ");
INSERT INTO sanasm_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","যূযঞ্চ যন্নিৱেশনং প্ৰৱিশথ নগৰত্যাগপৰ্য্যনতং তন্নিৱেশনে তিষ্ঠত| ");
INSERT INTO sanasm_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","তত্ৰ যদি কস্যচিৎ পুৰস্য লোকা যুষ্মাকমাতিথ্যং ন কুৰ্ৱ্ৱন্তি তৰ্হি তস্মান্নগৰাদ্ গমনকালে তেষাং ৱিৰুদ্ধং সাক্ষ্যাৰ্থং যুষ্মাকং পদধূলীঃ সম্পাতযত| ");
INSERT INTO sanasm_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","অথ তে প্ৰস্থায সৰ্ৱ্ৱত্ৰ সুসংৱাদং প্ৰচাৰযিতুং পীডিতান্ স্ৱস্থান্ কৰ্ত্তুঞ্চ গ্ৰামেষু ভ্ৰমিতুং প্ৰাৰেভিৰে| ");
INSERT INTO sanasm_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","এতৰ্হি হেৰোদ্ ৰাজা যীশোঃ সৰ্ৱ্ৱকৰ্ম্মণাং ৱাৰ্ত্তাং শ্ৰুৎৱা ভৃশমুদ্ৱিৱিজে ");
INSERT INTO sanasm_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","যতঃ কেচিদূচুৰ্যোহন্ শ্মশানাদুদতিষ্ঠৎ| কেচিদূচুঃ, এলিযো দৰ্শনং দত্তৱান্; এৱমন্যলোকা ঊচুঃ পূৰ্ৱ্ৱীযঃ কশ্চিদ্ ভৱিষ্যদ্ৱাদী সমুত্থিতঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","কিন্তু হেৰোদুৱাচ যোহনঃ শিৰোঽহমছিনদম্ ইদানীং যস্যেদৃক্কৰ্ম্মণাং ৱাৰ্ত্তাং প্ৰাপ্নোমি স কঃ? অথ স তং দ্ৰষ্টুম্ ঐচ্ছৎ| ");
INSERT INTO sanasm_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","অনন্তৰং প্ৰেৰিতাঃ প্ৰত্যাগত্য যানি যানি কৰ্ম্মাণি চক্ৰুস্তানি যীশৱে কথযামাসুঃ ততঃ স তান্ বৈৎসৈদানামকনগৰস্য ৱিজনং স্থানং নীৎৱা গুপ্তং জগাম| ");
INSERT INTO sanasm_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","পশ্চাল্ লোকাস্তদ্ ৱিদিৎৱা তস্য পশ্চাদ্ যযুঃ; ততঃ স তান্ নযন্ ঈশ্ৱৰীযৰাজ্যস্য প্ৰসঙ্গমুক্তৱান্, যেষাং চিকিৎসযা প্ৰযোজনম্ আসীৎ তান্ স্ৱস্থান্ চকাৰ চ| ");
INSERT INTO sanasm_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","অপৰঞ্চ দিৱাৱসন্নে সতি দ্ৱাদশশিষ্যা যীশোৰন্তিকম্ এত্য কথযামাসুঃ, ৱযমত্ৰ প্ৰান্তৰস্থানে তিষ্ঠামঃ, ততো নগৰাণি গ্ৰামাণি গৎৱা ৱাসস্থানানি প্ৰাপ্য ভক্ষ্যদ্ৰৱ্যাণি ক্ৰেতুং জননিৱহং ভৱান্ ৱিসৃজতু| ");
INSERT INTO sanasm_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","তদা স উৱাচ, যূযমেৱ তান্ ভেজযধ্ৱং; ততস্তে প্ৰোচুৰস্মাকং নিকটে কেৱলং পঞ্চ পূপা দ্ৱৌ মৎস্যৌ চ ৱিদ্যন্তে, অতএৱ স্থানান্তৰম্ ইৎৱা নিমিত্তমেতেষাং ভক্ষ্যদ্ৰৱ্যেষু ন ক্ৰীতেষু ন ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","তত্ৰ প্ৰাযেণ পঞ্চসহস্ৰাণি পুৰুষা আসন্| ");
INSERT INTO sanasm_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","তদা স শিষ্যান্ জগাদ পঞ্চাশৎ পঞ্চাশজ্জনৈঃ পংক্তীকৃত্য তানুপৱেশযত, তস্মাৎ তে তদনুসাৰেণ সৰ্ৱ্ৱলোকানুপৱেশযাপাসুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ততঃ স তান্ পঞ্চ পূপান্ মীনদ্ৱযঞ্চ গৃহীৎৱা স্ৱৰ্গং ৱিলোক্যেশ্ৱৰগুণান্ কীৰ্ত্তযাঞ্চক্ৰে ভঙ্ক্তা চ লোকেভ্যঃ পৰিৱেষণাৰ্থং শিষ্যেষু সমৰ্পযাম্বভূৱ| ");
INSERT INTO sanasm_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ততঃ সৰ্ৱ্ৱে ভুক্ত্ৱা তৃপ্তিং গতা অৱশিষ্টানাঞ্চ দ্ৱাদশ ডল্লকান্ সংজগৃহুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","অথৈকদা নিৰ্জনে শিষ্যৈঃ সহ প্ৰাৰ্থনাকালে তান্ পপ্ৰচ্ছ, লোকা মাং কং ৱদন্তি? ");
INSERT INTO sanasm_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","ততস্তে প্ৰাচুঃ, ৎৱাং যোহন্মজ্জকং ৱদন্তি; কেচিৎ ৎৱাম্ এলিযং ৱদন্তি, পূৰ্ৱ্ৱকালিকঃ কশ্চিদ্ ভৱিষ্যদ্ৱাদী শ্মশানাদ্ উদতিষ্ঠদ্ ইত্যপি কেচিদ্ ৱদন্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","তদা স উৱাচ, যূযং মাং কং ৱদথ? ততঃ পিতৰ উক্তৱান্ ৎৱম্ ঈশ্ৱৰাভিষিক্তঃ পুৰুষঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","তদা স তান্ দৃঢমাদিদেশ, কথামেতাং কস্মৈচিদপি মা কথযত| ");
INSERT INTO sanasm_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","স পুনৰুৱাচ, মনুষ্যপুত্ৰেণ ৱহুযাতনা ভোক্তৱ্যাঃ প্ৰাচীনলোকৈঃ প্ৰধানযাজকৈৰধ্যাপকৈশ্চ সোৱজ্ঞায হন্তৱ্যঃ কিন্তু তৃতীযদিৱসে শ্মশানাৎ তেনোত্থাতৱ্যম্| ");
INSERT INTO sanasm_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","অপৰং স সৰ্ৱ্ৱানুৱাচ, কশ্চিদ্ যদি মম পশ্চাদ্ গন্তুং ৱাঞ্ছতি তৰ্হি স স্ৱং দাম্যতু, দিনে দিনে ক্ৰুশং গৃহীৎৱা চ মম পশ্চাদাগচ্ছতু| ");
INSERT INTO sanasm_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","যতো যঃ কশ্চিৎ স্ৱপ্ৰাণান্ ৰিৰক্ষিষতি স তান্ হাৰযিষ্যতি, যঃ কশ্চিন্ মদৰ্থং প্ৰাণান্ হাৰযিষ্যতি স তান্ ৰক্ষিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","কশ্চিদ্ যদি সৰ্ৱ্ৱং জগৎ প্ৰাপ্নোতি কিন্তু স্ৱপ্ৰাণান্ হাৰযতি স্ৱযং ৱিনশ্যতি চ তৰ্হি তস্য কো লাভঃ? ");
INSERT INTO sanasm_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","পুন ৰ্যঃ কশ্চিন্ মাং মম ৱাক্যং ৱা লজ্জাস্পদং জানাতি মনুষ্যপুত্ৰো যদা স্ৱস্য পিতুশ্চ পৱিত্ৰাণাং দূতানাঞ্চ তেজোভিঃ পৰিৱেষ্টিত আগমিষ্যতি তদা সোপি তং লজ্জাস্পদং জ্ঞাস্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","কিন্তু যুষ্মানহং যথাৰ্থং ৱদামি, ঈশ্ৱৰীযৰাজৎৱং ন দৃষ্টৱা মৃত্যুং নাস্ৱাদিষ্যন্তে, এতাদৃশাঃ কিযন্তো লোকা অত্ৰ স্থনেঽপি দণ্ডাযমানাঃ সন্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","এতদাখ্যানকথনাৎ পৰং প্ৰাযেণাষ্টসু দিনেষু গতেষু স পিতৰং যোহনং যাকূবঞ্চ গৃহীৎৱা প্ৰাৰ্থযিতুং পৰ্ৱ্ৱতমেকং সমাৰুৰোহ| ");
INSERT INTO sanasm_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","অথ তস্য প্ৰাৰ্থনকালে তস্য মুখাকৃতিৰন্যৰূপা জাতা, তদীযং ৱস্ত্ৰমুজ্জ্ৱলশুক্লং জাতং| ");
INSERT INTO sanasm_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","অপৰঞ্চ মূসা এলিযশ্চোভৌ তেজস্ৱিনৌ দৃষ্টৌ ");
INSERT INTO sanasm_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","তৌ তেন যিৰূশালম্পুৰে যো মৃত্যুঃ সাধিষ্যতে তদীযাং কথাং তেন সাৰ্দ্ধং কথযিতুম্ আৰেভাতে| ");
INSERT INTO sanasm_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","তদা পিতৰাদযঃ স্ৱস্য সঙ্গিনো নিদ্ৰযাকৃষ্টা আসন্ কিন্তু জাগৰিৎৱা তস্য তেজস্তেন সাৰ্দ্ধম্ উত্তিষ্ঠন্তৌ জনৌ চ দদৃশুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","অথ তযোৰুভযো ৰ্গমনকালে পিতৰো যীশুং বভাষে, হে গুৰোঽস্মাকং স্থানেঽস্মিন্ স্থিতিঃ শুভা, তত একা ৎৱদৰ্থা, একা মূসাৰ্থা, একা এলিযাৰ্থা, ইতি তিস্ৰঃ কুট্যোস্মাভি ৰ্নিৰ্ম্মীযন্তাং, ইমাং কথাং স ন ৱিৱিচ্য কথযামাস| ");
INSERT INTO sanasm_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","অপৰঞ্চ তদ্ৱাক্যৱদনকালে পযোদ এক আগত্য তেষামুপৰি ছাযাং চকাৰ, ততস্তন্মধ্যে তযোঃ প্ৰৱেশাৎ তে শশঙ্কিৰে| ");
INSERT INTO sanasm_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","তদা তস্মাৎ পযোদাদ্ ইযমাকাশীযা ৱাণী নিৰ্জগাম, মমাযং প্ৰিযঃ পুত্ৰ এতস্য কথাযাং মনো নিধত্ত| ");
INSERT INTO sanasm_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ইতি শব্দে জাতে তে যীশুমেকাকিনং দদৃশুঃ কিন্তু তে তদানীং তস্য দৰ্শনস্য ৱাচমেকামপি নোক্ত্ৱা মনঃসু স্থাপযামাসুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","পৰেঽহনি তেষু তস্মাচ্ছৈলাদ্ অৱৰূঢেষু তং সাক্ষাৎ কৰ্ত্তুং বহৱো লোকা আজগ্মুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","তেষাং মধ্যাদ্ একো জন উচ্চৈৰুৱাচ, হে গুৰো অহং ৱিনযং কৰোমি মম পুত্ৰং প্ৰতি কৃপাদৃষ্টিং কৰোতু, মম স এৱৈকঃ পুত্ৰঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ভূতেন ধৃতঃ সন্ সং প্ৰসভং চীচ্ছব্দং কৰোতি তন্মুখাৎ ফেণা নিৰ্গচ্ছন্তি চ, ভূত ইত্থং ৱিদাৰ্য্য ক্লিষ্ট্ৱা প্ৰাযশস্তং ন ত্যজতি| ");
INSERT INTO sanasm_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","তস্মাৎ তং ভূতং ত্যাজযিতুং তৱ শিষ্যসমীপে ন্যৱেদযং কিন্তু তে ন শেকুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","তদা যীশুৰৱাদীৎ, ৰে আৱিশ্ৱাসিন্ ৱিপথগামিন্ ৱংশ কতিকালান্ যুষ্মাভিঃ সহ স্থাস্যাম্যহং যুষ্মাকম্ আচৰণানি চ সহিষ্যে? তৱ পুত্ৰমিহানয| ");
INSERT INTO sanasm_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ততস্তস্মিন্নাগতমাত্ৰে ভূতস্তং ভূমৌ পাতযিৎৱা ৱিদদাৰ; তদা যীশুস্তমমেধ্যং ভূতং তৰ্জযিৎৱা বালকং স্ৱস্থং কৃৎৱা তস্য পিতৰি সমৰ্পযামাস| ");
INSERT INTO sanasm_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ঈশ্ৱৰস্য মহাশক্তিম্ ইমাং ৱিলোক্য সৰ্ৱ্ৱে চমচ্চক্ৰুঃ; ইত্থং যীশোঃ সৰ্ৱ্ৱাভিঃ ক্ৰিযাভিঃ সৰ্ৱ্ৱৈৰ্লোকৈৰাশ্চৰ্য্যে মন্যমানে সতি স শিষ্যান্ বভাষে, ");
INSERT INTO sanasm_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","কথেযং যুষ্মাকং কৰ্ণেষু প্ৰৱিশতু, মনুষ্যপুত্ৰো মনুষ্যাণাং কৰেষু সমৰ্পযিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","কিন্তু তে তাং কথাং ন বুবুধিৰে, স্পষ্টৎৱাভাৱাৎ তস্যা অভিপ্ৰাযস্তেষাং বোধগম্যো ন বভূৱ; তস্যা আশযঃ ক ইত্যপি তে ভযাৎ প্ৰষ্টুং ন শেকুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","তদনন্তৰং তেষাং মধ্যে কঃ শ্ৰেষ্ঠঃ কথামেতাং গৃহীৎৱা তে মিথো ৱিৱাদং চক্ৰুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ততো যীশুস্তেষাং মনোভিপ্ৰাযং ৱিদিৎৱা বালকমেকং গৃহীৎৱা স্ৱস্য নিকটে স্থাপযিৎৱা তান্ জগাদ, ");
INSERT INTO sanasm_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","যো জনো মম নাম্নাস্য বালাস্যাতিথ্যং ৱিদধাতি স মমাতিথ্যং ৱিদধাতি, যশ্চ মমাতিথ্যং ৱিদধাতি স মম প্ৰেৰকস্যাতিথ্যং ৱিদধাতি, যুষ্মাকং মধ্যেযঃ স্ৱং সৰ্ৱ্ৱস্মাৎ ক্ষুদ্ৰং জানীতে স এৱ শ্ৰেষ্ঠো ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","অপৰঞ্চ যোহন্ ৱ্যাজহাৰ হে প্ৰভেा তৱ নাম্না ভূতান্ ত্যাজযন্তং মানুষম্ একং দৃষ্টৱন্তো ৱযং, কিন্ত্ৱস্মাকম্ অপশ্চাদ্ গামিৎৱাৎ তং ন্যষেধাম্| তদানীং যীশুৰুৱাচ, ");
INSERT INTO sanasm_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","তং মা নিষেধত, যতো যো জনোস্মাকং ন ৱিপক্ষঃ স এৱাস্মাকং সপক্ষো ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","অনন্তৰং তস্যাৰোহণসময উপস্থিতে স স্থিৰচেতা যিৰূশালমং প্ৰতি যাত্ৰাং কৰ্ত্তুং নিশ্চিত্যাগ্ৰে দূতান্ প্ৰেষযামাস| ");
INSERT INTO sanasm_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","তস্মাৎ তে গৎৱা তস্য প্ৰযোজনীযদ্ৰৱ্যাণি সংগ্ৰহীতুং শোমিৰোণীযানাং গ্ৰামং প্ৰৱিৱিশুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","কিন্তু স যিৰূশালমং নগৰং যাতি ততো হেতো ৰ্লোকাস্তস্যাতিথ্যং ন চক্ৰুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","অতএৱ যাকূব্যোহনৌ তস্য শিষ্যৌ তদ্ দৃষ্ট্ৱা জগদতুঃ, হে প্ৰভো এলিযো যথা চকাৰ তথা ৱযমপি কিং গগণাদ্ আগন্তুম্ এতান্ ভস্মীকৰ্ত্তুঞ্চ ৱহ্নিমাজ্ঞাপযামঃ? ভৱান্ কিমিচ্ছতি? ");
INSERT INTO sanasm_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","কিন্তু স মুখং পৰাৱৰ্ত্য তান্ তৰ্জযিৎৱা গদিতৱান্ যুষ্মাকং মনোভাৱঃ কঃ, ইতি যূযং ন জানীথ| ");
INSERT INTO sanasm_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","মনুজসুতো মনুজানাং প্ৰাণান্ নাশযিতুং নাগচ্ছৎ, কিন্তু ৰক্ষিতুম্ আগচ্ছৎ| পশ্চাদ্ ইতৰগ্ৰামং তে যযুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","তদনন্তৰং পথি গমনকালে জন একস্তং বভাষে, হে প্ৰভো ভৱান্ যত্ৰ যাতি ভৱতা সহাহমপি তত্ৰ যাস্যামি| ");
INSERT INTO sanasm_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","তদানীং যীশুস্তমুৱাচ, গোমাযূনাং গৰ্ত্তা আসতে, ৱিহাযসীযৱিহগাाনাং নীডানি চ সন্তি, কিন্তু মানৱতনযস্য শিৰঃ স্থাপযিতুং স্থানং নাস্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ততঃ পৰং স ইতৰজনং জগাদ, ৎৱং মম পশ্চাদ্ এহি; ততঃ স উৱাচ, হে প্ৰভো পূৰ্ৱ্ৱং পিতৰং শ্মশানে স্থাপযিতুং মামাদিশতু| ");
INSERT INTO sanasm_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","তদা যীশুৰুৱাচ, মৃতা মৃতান্ শ্মশানে স্থাপযন্তু কিন্তু ৎৱং গৎৱেশ্ৱৰীযৰাজ্যস্য কথাং প্ৰচাৰয| ");
INSERT INTO sanasm_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ততোন্যঃ কথযামাস, হে প্ৰভো মযাপি ভৱতঃ পশ্চাদ্ গংস্যতে, কিন্তু পূৰ্ৱ্ৱং মম নিৱেশনস্য পৰিজনানাম্ অনুমতিং গ্ৰহীতুম্ অহমাদিশ্যৈ ভৱতা| ");
INSERT INTO sanasm_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","তদানীং যীশুস্তং প্ৰোক্তৱান্, যো জনো লাঙ্গলে কৰমৰ্পযিৎৱা পশ্চাৎ পশ্যতি স ঈশ্ৱৰীযৰাজ্যং নাৰ্হতি| ");
INSERT INTO sanasm_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ততঃ পৰং প্ৰভুৰপৰান্ সপ্ততিশিষ্যান্ নিযুজ্য স্ৱযং যানি নগৰাণি যানি স্থানানি চ গমিষ্যতি তানি নগৰাণি তানি স্থানানি চ প্ৰতি দ্ৱৌ দ্ৱৌ জনৌ প্ৰহিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","তেভ্যঃ কথযামাস চ শস্যানি বহূনীতি সত্যং কিন্তু ছেদকা অল্পে; তস্মাদ্ধেতোঃ শস্যক্ষেত্ৰে ছেদকান্ অপৰানপি প্ৰেষযিতুং ক্ষেত্ৰস্ৱামিনং প্ৰাৰ্থযধ্ৱং| ");
INSERT INTO sanasm_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","যূযং যাত, পশ্যত, ৱৃকাণাং মধ্যে মেষশাৱকানিৱ যুষ্মান্ প্ৰহিণোমি| ");
INSERT INTO sanasm_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","যূযং ক্ষুদ্ৰং মহদ্ ৱা ৱসনসম্পুটকং পাদুকাশ্চ মা গৃহ্লীত, মাৰ্গমধ্যে কমপি মা নমত চ| ");
INSERT INTO sanasm_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","অপৰঞ্চ যূযং যদ্ যৎ নিৱেশনং প্ৰৱিশথ তত্ৰ নিৱেশনস্যাস্য মঙ্গলং ভূযাদিতি ৱাক্যং প্ৰথমং ৱদত| ");
INSERT INTO sanasm_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","তস্মাৎ তস্মিন্ নিৱেশনে যদি মঙ্গলপাত্ৰং স্থাস্যতি তৰ্হি তন্মঙ্গলং তস্য ভৱিষ্যতি, নোচেৎ যুষ্মান্ প্ৰতি পৰাৱৰ্ত্তিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","অপৰঞ্চ তে যৎকিঞ্চিদ্ দাস্যন্তি তদেৱ ভুক্ত্ৱা পীৎৱা তস্মিন্নিৱেশনে স্থাস্যথ; যতঃ কৰ্ম্মকাৰী জনো ভৃতিম্ অৰ্হতি; গৃহাদ্ গৃহং মা যাস্যথ| ");
INSERT INTO sanasm_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","অন্যচ্চ যুষ্মাসু কিমপি নগৰং প্ৰৱিষ্টেষু লোকা যদি যুষ্মাকম্ আতিথ্যং কৰিষ্যন্তি, তৰ্হি যৎ খাদ্যম্ উপস্থাস্যন্তি তদেৱ খাদিষ্যথ| ");
INSERT INTO sanasm_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","তন্নগৰস্থান্ ৰোগিণঃ স্ৱস্থান্ কৰিষ্যথ, ঈশ্ৱৰীযং ৰাজ্যং যুষ্মাকম্ অন্তিকম্ আগমৎ কথামেতাঞ্চ প্ৰচাৰযিষ্যথ| ");
INSERT INTO sanasm_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","কিন্তু কিমপি পুৰং যুষ্মাসু প্ৰৱিষ্টেষু লোকা যদি যুষ্মাকম্ আতিথ্যং ন কৰিষ্যন্তি, তৰ্হি তস্য নগৰস্য পন্থানং গৎৱা কথামেতাং ৱদিষ্যথ, ");
INSERT INTO sanasm_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","যুষ্মাকং নগৰীযা যা ধূল্যোঽস্মাসু সমলগন্ তা অপি যুষ্মাকং প্ৰাতিকূল্যেন সাক্ষ্যাৰ্থং সম্পাতযামঃ; তথাপীশ্ৱৰৰাজ্যং যুষ্মাকং সমীপম্ আগতম্ ইতি নিশ্চিতং জানীত| ");
INSERT INTO sanasm_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","অহং যুষ্মভ্যং যথাৰ্থং কথযামি, ৱিচাৰদিনে তস্য নগৰস্য দশাতঃ সিদোমো দশা সহ্যা ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","হা হা কোৰাসীন্ নগৰ, হা হা বৈৎসৈদানগৰ যুৱযোৰ্মধ্যে যাদৃশানি আশ্চৰ্য্যাণি কৰ্ম্মাণ্যক্ৰিযন্ত, তানি কৰ্ম্মাণি যদি সোৰসীদোনো ৰ্নগৰযোৰকাৰিষ্যন্ত, তদা ইতো বহুদিনপূৰ্ৱ্ৱং তন্নিৱাসিনঃ শণৱস্ত্ৰাণি পৰিধায গাত্ৰেষু ভস্ম ৱিলিপ্য সমুপৱিশ্য সমখেৎস্যন্ত| ");
INSERT INTO sanasm_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","অতো ৱিচাৰদিৱসে যুষ্মাকং দশাতঃ সোৰসীদোন্নিৱাসিনাং দশা সহ্যা ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","হে কফৰ্নাহূম্, ৎৱং স্ৱৰ্গং যাৱদ্ উন্নতা কিন্তু নৰকং যাৱৎ ন্যগ্ভৱিষ্যসি| ");
INSERT INTO sanasm_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","যো জনো যুষ্মাকং ৱাক্যং গৃহ্লাতি স মমৈৱ ৱাক্যং গৃহ্লাতি; কিঞ্চ যো জনো যুষ্মাকম্ অৱজ্ঞাং কৰোতি স মমৈৱাৱজ্ঞাং কৰোতি; যো জনো মমাৱজ্ঞাং কৰোতি চ স মৎপ্ৰেৰকস্যৈৱাৱজ্ঞাং কৰোতি| ");
INSERT INTO sanasm_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","অথ তে সপ্ততিশিষ্যা আনন্দেন প্ৰত্যাগত্য কথযামাসুঃ, হে প্ৰভো ভৱতো নাম্না ভূতা অপ্যস্মাকং ৱশীভৱন্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","তদানীং স তান্ জগাদ, ৱিদ্যুতমিৱ স্ৱৰ্গাৎ পতন্তং শৈতানম্ অদৰ্শম্| ");
INSERT INTO sanasm_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","পশ্যত সৰ্পান্ ৱৃশ্চিকান্ ৰিপোঃ সৰ্ৱ্ৱপৰাক্ৰমাংশ্চ পদতলৈ ৰ্দলযিতুং যুষ্মভ্যং শক্তিং দদামি তস্মাদ্ যুষ্মাকং কাপি হানি ৰ্ন ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","ভূতা যুষ্মাকং ৱশীভৱন্তি, এতন্নিমিত্তৎ মা সমুল্লসত, স্ৱৰ্গে যুষ্মাকং নামানি লিখিতানি সন্তীতি নিমিত্তং সমুল্লসত| ");
INSERT INTO sanasm_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","তদ্ঘটিকাযাং যীশু ৰ্মনসি জাতাহ্লাদঃ কথযামাস হে স্ৱৰ্গপৃথিৱ্যোৰেকাধিপতে পিতস্ত্ৱং জ্ঞানৱতাং ৱিদুষাঞ্চ লোকানাং পুৰস্তাৎ সৰ্ৱ্ৱমেতদ্ অপ্ৰকাশ্য বালকানাং পুৰস্তাৎ প্ৰাকাশয এতস্মাদ্ধেতোস্ত্ৱাং ধন্যং ৱদামি, হে পিতৰিত্থং ভৱতু যদ্ এতদেৱ তৱ গোচৰ উত্তমম্| ");
INSERT INTO sanasm_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","পিত্ৰা সৰ্ৱ্ৱাণি মযি সমৰ্পিতানি পিতৰং ৱিনা কোপি পুত্ৰং ন জানাতি কিঞ্চ পুত্ৰং ৱিনা যস্মৈ জনায পুত্ৰস্তং প্ৰকাশিতৱান্ তঞ্চ ৱিনা কোপি পিতৰং ন জানাতি| ");
INSERT INTO sanasm_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","তপঃ পৰং স শিষ্যান্ প্ৰতি পৰাৱৃত্য গুপ্তং জগাদ, যূযমেতানি সৰ্ৱ্ৱাণি পশ্যথ ততো যুষ্মাকং চক্ষূংষি ধন্যানি| ");
INSERT INTO sanasm_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","যুষ্মানহং ৱদামি, যূযং যানি সৰ্ৱ্ৱাণি পশ্যথ তানি বহৱো ভৱিষ্যদ্ৱাদিনো ভূপতযশ্চ দ্ৰষ্টুমিচ্ছন্তোপি দ্ৰষ্টুং ন প্ৰাপ্নুৱন্, যুষ্মাভি ৰ্যা যাঃ কথাশ্চ শ্ৰূযন্তে তাঃ শ্ৰোতুমিচ্ছন্তোপি শ্ৰোতুং নালভন্ত| ");
INSERT INTO sanasm_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","অনন্তৰম্ একো ৱ্যৱস্থাপক উত্থায তং পৰীক্ষিতুং পপ্ৰচ্ছ, হে উপদেশক অনন্তাযুষঃ প্ৰাপ্তযে মযা কিং কৰণীযং? ");
INSERT INTO sanasm_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","যীশুঃ প্ৰত্যুৱাচ, অত্ৰাৰ্থে ৱ্যৱস্থাযাং কিং লিখিতমস্তি? ৎৱং কীদৃক্ পঠসি? ");
INSERT INTO sanasm_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ততঃ সোৱদৎ, ৎৱং সৰ্ৱ্ৱান্তঃকৰণৈঃ সৰ্ৱ্ৱপ্ৰাণৈঃ সৰ্ৱ্ৱশক্তিভিঃ সৰ্ৱ্ৱচিত্তৈশ্চ প্ৰভৌ পৰমেশ্ৱৰে প্ৰেম কুৰু, সমীপৱাসিনি স্ৱৱৎ প্ৰেম কুৰু চ| ");
INSERT INTO sanasm_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","তদা স কথযামাস, ৎৱং যথাৰ্থং প্ৰত্যৱোচঃ, ইত্থম্ আচৰ তেনৈৱ জীৱিষ্যসি| ");
INSERT INTO sanasm_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","কিন্তু স জনঃ স্ৱং নিৰ্দ্দোষং জ্ঞাপযিতুং যীশুং পপ্ৰচ্ছ, মম সমীপৱাসী কঃ? ততো যীশুঃ প্ৰত্যুৱাচ, ");
INSERT INTO sanasm_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","একো জনো যিৰূশালম্পুৰাদ্ যিৰীহোপুৰং যাতি, এতৰ্হি দস্যূনাং কৰেষু পতিতে তে তস্য ৱস্ত্ৰাদিকং হৃতৱন্তঃ তমাহত্য মৃতপ্ৰাযং কৃৎৱা ত্যক্ত্ৱা যযুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","অকস্মাদ্ একো যাজকস্তেন মাৰ্গেণ গচ্ছন্ তং দৃষ্ট্ৱা মাৰ্গান্যপাৰ্শ্ৱেন জগাম| ");
INSERT INTO sanasm_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ইত্থম্ একো লেৱীযস্তৎস্থানং প্ৰাপ্য তস্যান্তিকং গৎৱা তং ৱিলোক্যান্যেন পাৰ্শ্ৱেন জগাম| ");
INSERT INTO sanasm_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","কিন্ত্ৱেকঃ শোমিৰোণীযো গচ্ছন্ তৎস্থানং প্ৰাপ্য তং দৃষ্ট্ৱাদযত| ");
INSERT INTO sanasm_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","তস্যান্তিকং গৎৱা তস্য ক্ষতেষু তৈলং দ্ৰাক্ষাৰসঞ্চ প্ৰক্ষিপ্য ক্ষতানি বদ্ধ্ৱা নিজৱাহনোপৰি তমুপৱেশ্য প্ৰৱাসীযগৃহম্ আনীয তং সিষেৱে| ");
INSERT INTO sanasm_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","পৰস্মিন্ দিৱসে নিজগমনকালে দ্ৱৌ মুদ্ৰাপাদৌ তদ্গৃহস্ৱামিনে দত্ত্ৱাৱদৎ জনমেনং সেৱস্ৱ তত্ৰ যোঽধিকো ৱ্যযো ভৱিষ্যতি তমহং পুনৰাগমনকালে পৰিশোৎস্যামি| ");
INSERT INTO sanasm_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","এষাং ত্ৰযাণাং মধ্যে তস্য দস্যুহস্তপতিতস্য জনস্য সমীপৱাসী কঃ? ৎৱযা কিং বুধ্যতে? ");
INSERT INTO sanasm_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ততঃ স ৱ্যৱস্থাপকঃ কথযামাস যস্তস্মিন্ দযাং চকাৰ| তদা যীশুঃ কথযামাস ৎৱমপি গৎৱা তথাচৰ| ");
INSERT INTO sanasm_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","ততঃ পৰং তে গচ্ছন্ত একং গ্ৰামং প্ৰৱিৱিশুঃ; তদা মৰ্থানামা স্ত্ৰী স্ৱগৃহে তস্যাতিথ্যং চকাৰ| ");
INSERT INTO sanasm_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","তস্মাৎ মৰিযম্ নামধেযা তস্যা ভগিনী যীশোঃ পদসমীপ উৱৱিশ্য তস্যোপদেশকথাং শ্ৰোতুমাৰেভে| ");
INSERT INTO sanasm_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","কিন্তু মৰ্থা নানাপৰিচৰ্য্যাযাং ৱ্যগ্ৰা বভূৱ তস্মাদ্ধেতোস্তস্য সমীপমাগত্য বভাষে; হে প্ৰভো মম ভগিনী কেৱলং মমোপৰি সৰ্ৱ্ৱকৰ্ম্মণাং ভাৰম্ অৰ্পিতৱতী তত্ৰ ভৱতা কিঞ্চিদপি ন মনো নিধীযতে কিম্? মম সাহায্যং কৰ্ত্তুং ভৱান্ তামাদিশতু| ");
INSERT INTO sanasm_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ততো যীশুঃ প্ৰত্যুৱাচ হে মৰ্থে হে মৰ্থে, ৎৱং নানাকাৰ্য্যেষু চিন্তিতৱতী ৱ্যগ্ৰা চাসি, ");
INSERT INTO sanasm_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","কিন্তু প্ৰযোজনীযম্ একমাত্ৰম্ আস্তে| অপৰঞ্চ যমুত্তমং ভাগং কোপি হৰ্ত্তুং ন শক্নোতি সএৱ মৰিযমা ৱৃতঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","অনন্তৰং স কস্মিংশ্চিৎ স্থানে প্ৰাৰ্থযত তৎসমাপ্তৌ সত্যাং তস্যৈকঃ শিষ্যস্তং জগাদ হে প্ৰভো যোহন্ যথা স্ৱশিষ্যান্ প্ৰাৰ্থযিতুম্ উপদিষ্টৱান্ তথা ভৱানপ্যস্মান্ উপদিশতু| ");
INSERT INTO sanasm_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","তস্মাৎ স কথযামাস, প্ৰাৰ্থনকালে যূযম্ ইত্থং কথযধ্ৱং, হে অস্মাকং স্ৱৰ্গস্থপিতস্তৱ নাম পূজ্যং ভৱতু; তৱ ৰাজৎৱং ভৱতু; স্ৱৰ্গে যথা তথা পৃথিৱ্যামপি তৱেচ্ছযা সৰ্ৱ্ৱং ভৱতু| ");
INSERT INTO sanasm_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","প্ৰত্যহম্ অস্মাকং প্ৰযোজনীযং ভোজ্যং দেহি| ");
INSERT INTO sanasm_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","যথা ৱযং সৰ্ৱ্ৱান্ অপৰাধিনঃ ক্ষমামহে তথা ৎৱমপি পাপান্যস্মাকং ক্ষমস্ৱ| অস্মান্ পৰীক্ষাং মানয কিন্তু পাপাত্মনো ৰক্ষ| ");
INSERT INTO sanasm_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","পশ্চাৎ সোপৰমপি কথিতৱান্ যদি যুষ্মাকং কস্যচিদ্ বন্ধুস্তিষ্ঠতি নিশীথে চ তস্য সমীপং স গৎৱা ৱদতি, ");
INSERT INTO sanasm_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","হে বন্ধো পথিক একো বন্ধু ৰ্মম নিৱেশনম্ আযাতঃ কিন্তু তস্যাতিথ্যং কৰ্ত্তুং মমান্তিকে কিমপি নাস্তি, অতএৱ পূপত্ৰযং মহ্যম্ ঋণং দেহি; ");
INSERT INTO sanasm_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","তদা স যদি গৃহমধ্যাৎ প্ৰতিৱদতি মাং মা ক্লিশান, ইদানীং দ্ৱাৰং ৰুদ্ধং শযনে মযা সহ বালকাশ্চ তিষ্ঠন্তি তুভ্যং দাতুম্ উত্থাতুং ন শক্নোমি, ");
INSERT INTO sanasm_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","তৰ্হি যুষ্মানহং ৱদামি, স যদি মিত্ৰতযা তস্মৈ কিমপি দাতুং নোত্তিষ্ঠতি তথাপি ৱাৰং ৱাৰং প্ৰাৰ্থনাত উত্থাপিতঃ সন্ যস্মিন্ তস্য প্ৰযোজনং তদেৱ দাস্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","অতঃ কাৰণাৎ কথযামি, যাচধ্ৱং ততো যুষ্মভ্যং দাস্যতে, মৃগযধ্ৱং তত উদ্দেশং প্ৰাপ্স্যথ, দ্ৱাৰম্ আহত ততো যুষ্মভ্যং দ্ৱাৰং মোক্ষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","যো যাচতে স প্ৰাপ্নোতি, যো মৃগযতে স এৱোদ্দেশং প্ৰাপ্নোতি, যো দ্ৱাৰম্ আহন্তি তদৰ্থং দ্ৱাৰং মোচ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","পুত্ৰেণ পূপে যাচিতে তস্মৈ পাষাণং দদাতি ৱা মৎস্যে যাচিতে তস্মৈ সৰ্পং দদাতি ");
INSERT INTO sanasm_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ৱা অণ্ডে যাচিতে তস্মৈ ৱৃশ্চিকং দদাতি যুষ্মাকং মধ্যে ক এতাদৃশঃ পিতাস্তে? ");
INSERT INTO sanasm_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","তস্মাদেৱ যূযমভদ্ৰা অপি যদি স্ৱস্ৱবালকেভ্য উত্তমানি দ্ৰৱ্যাণি দাতুং জানীথ তৰ্হ্যস্মাকং স্ৱৰ্গস্থঃ পিতা নিজযাচকেভ্যঃ কিং পৱিত্ৰম্ আত্মানং ন দাস্যতি? ");
INSERT INTO sanasm_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","অনন্তৰং যীশুনা কস্মাচ্চিদ্ একস্মিন্ মূকভূতে ত্যাজিতে সতি স ভূতত্যক্তো মানুষো ৱাক্যং ৱক্তুম্ আৰেভে; ততো লোকাঃ সকলা আশ্চৰ্য্যং মেনিৰে| ");
INSERT INTO sanasm_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","কিন্তু তেষাং কেচিদূচু ৰ্জনোযং বালসিবূবা অৰ্থাদ্ ভূতৰাজেন ভূতান্ ত্যাজযতি| ");
INSERT INTO sanasm_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","তং পৰীক্ষিতুং কেচিদ্ আকাশীযম্ একং চিহ্নং দৰ্শযিতুং তং প্ৰাৰ্থযাঞ্চক্ৰিৰে| ");
INSERT INTO sanasm_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","তদা স তেষাং মনঃকল্পনাং জ্ঞাৎৱা কথযামাস, কস্যচিদ্ ৰাজ্যস্য লোকা যদি পৰস্পৰং ৱিৰুন্ধন্তি তৰ্হি তদ্ ৰাজ্যম্ নশ্যতি; কেচিদ্ গৃহস্থা যদি পৰস্পৰং ৱিৰুন্ধন্তি তৰ্হি তেপি নশ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","তথৈৱ শৈতানপি স্ৱলোকান্ যদি ৱিৰুণদ্ধি তদা তস্য ৰাজ্যং কথং স্থাস্যতি? বালসিবূবাহং ভূতান্ ত্যাজযামি যূযমিতি ৱদথ| ");
INSERT INTO sanasm_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","যদ্যহং বালসিবূবা ভূতান্ ত্যাজযামি তৰ্হি যুষ্মাকং সন্তানাঃ কেন ত্যাজযন্তি? তস্মাৎ তএৱ কথাযা এতস্যা ৱিচাৰযিতাৰো ভৱিষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","কিন্তু যদ্যহম্ ঈশ্ৱৰস্য পৰাক্ৰমেণ ভূতান্ ত্যাজযামি তৰ্হি যুষ্মাকং নিকটম্ ঈশ্ৱৰস্য ৰাজ্যমৱশ্যম্ উপতিষ্ঠতি| ");
INSERT INTO sanasm_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","বলৱান্ পুমান্ সুসজ্জমানো যতিকালং নিজাট্টালিকাং ৰক্ষতি ততিকালং তস্য দ্ৰৱ্যং নিৰুপদ্ৰৱং তিষ্ঠতি| ");
INSERT INTO sanasm_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","কিন্তু তস্মাদ্ অধিকবলঃ কশ্চিদাগত্য যদি তং জযতি তৰ্হি যেষু শস্ত্ৰাস্ত্ৰেষু তস্য ৱিশ্ৱাস আসীৎ তানি সৰ্ৱ্ৱাণি হৃৎৱা তস্য দ্ৰৱ্যাণি গৃহ্লাতি| ");
INSERT INTO sanasm_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","অতঃ কাৰণাদ্ যো মম সপক্ষো ন স ৱিপক্ষঃ, যো মযা সহ ন সংগৃহ্লাতি স ৱিকিৰতি| ");
INSERT INTO sanasm_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","অপৰঞ্চ অমেধ্যভূতো মানুষস্যান্তৰ্নিৰ্গত্য শুষ্কস্থানে ভ্ৰান্ত্ৱা ৱিশ্ৰামং মৃগযতে কিন্তু ন প্ৰাপ্য ৱদতি মম যস্মাদ্ গৃহাদ্ আগতোহং পুনস্তদ্ গৃহং পৰাৱৃত্য যামি| ");
INSERT INTO sanasm_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ততো গৎৱা তদ্ গৃহং মাৰ্জিতং শোভিতঞ্চ দৃষ্ট্ৱা ");
INSERT INTO sanasm_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","তৎক্ষণম্ অপগত্য স্ৱস্মাদপি দুৰ্ম্মতীন্ অপৰান্ সপ্তভূতান্ সহানযতি তে চ তদ্গৃহং পৱিশ্য নিৱসন্তি| তস্মাৎ তস্য মনুষ্যস্য প্ৰথমদশাতঃ শেষদশা দুঃখতৰা ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","অস্যাঃ কথাযাঃ কথনকালে জনতামধ্যস্থা কাচিন্নাৰী তমুচ্চৈঃস্ৱৰং প্ৰোৱাচ, যা যোষিৎ ৎৱাং গৰ্ব্ভেঽধাৰযৎ স্তন্যমপাযযচ্চ সৈৱ ধন্যা| ");
INSERT INTO sanasm_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","কিন্তু সোকথযৎ যে পৰমেশ্ৱৰস্য কথাং শ্ৰুৎৱা তদনুৰূপম্ আচৰন্তি তএৱ ধন্যাঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","ততঃ পৰং তস্যান্তিকে বহুলোকানাং সমাগমে জাতে স ৱক্তুমাৰেভে, আধুনিকা দুষ্টলোকাশ্চিহ্নং দ্ৰষ্টুমিচ্ছন্তি কিন্তু যূনস্ভৱিষ্যদ্ৱাদিনশ্চিহ্নং ৱিনান্যৎ কিঞ্চিচ্চিহ্নং তান্ ন দৰ্শযিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","যূনস্ তু যথা নীনিৱীযলোকানাং সমীপে চিহ্নৰূপোভৱৎ তথা ৱিদ্যমানলোকানাম্ এষাং সমীপে মনুষ্যপুত্ৰোপি চিহ্নৰূপো ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ৱিচাৰসমযে ইদানীন্তনলোকানাং প্ৰাতিকূল্যেন দক্ষিণদেশীযা ৰাজ্ঞী প্ৰোত্থায তান্ দোষিণঃ কৰিষ্যতি, যতঃ সা ৰাজ্ঞী সুলেমান উপদেশকথাং শ্ৰোতুং পৃথিৱ্যাঃ সীমাত আগচ্ছৎ কিন্তু পশ্যত সুলেমানোপি গুৰুতৰ একো জনোঽস্মিন্ স্থানে ৱিদ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","অপৰঞ্চ ৱিচাৰসমযে নীনিৱীযলোকা অপি ৱৰ্ত্তমানকালিকানাং লোকানাং ৱৈপৰীত্যেন প্ৰোত্থায তান্ দোষিণঃ কৰিষ্যন্তি, যতো হেতোস্তে যূনসো ৱাক্যাৎ চিত্তানি পৰিৱৰ্ত্তযামাসুঃ কিন্তু পশ্যত যূনসোতিগুৰুতৰ একো জনোঽস্মিন্ স্থানে ৱিদ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","প্ৰদীপং প্ৰজ্ৱাল্য দ্ৰোণস্যাধঃ কুত্ৰাপি গুপ্তস্থানে ৱা কোপি ন স্থাপযতি কিন্তু গৃহপ্ৰৱেশিভ্যো দীপ্তিং দাতং দীপাধাৰোপৰ্য্যেৱ স্থাপযতি| ");
INSERT INTO sanasm_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","দেহস্য প্ৰদীপশ্চক্ষুস্তস্মাদেৱ চক্ষু ৰ্যদি প্ৰসন্নং ভৱতি তৰ্হি তৱ সৰ্ৱ্ৱশৰীৰং দীপ্তিমদ্ ভৱিষ্যতি কিন্তু চক্ষু ৰ্যদি মলীমসং তিষ্ঠতি তৰ্হি সৰ্ৱ্ৱশৰীৰং সান্ধকাৰং স্থাস্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","অস্মাৎ কাৰণাৎ তৱান্তঃস্থং জ্যোতি ৰ্যথান্ধকাৰমযং ন ভৱতি তদৰ্থে সাৱধানো ভৱ| ");
INSERT INTO sanasm_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","যতঃ শৰীৰস্য কুত্ৰাপ্যংশে সান্ধকাৰে ন জাতে সৰ্ৱ্ৱং যদি দীপ্তিমৎ তিষ্ঠতি তৰ্হি তুভ্যং দীপ্তিদাযিপ্ৰোজ্জ্ৱলন্ প্ৰদীপ ইৱ তৱ সৱৰ্ৱশৰীৰং দীপ্তিমদ্ ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","এতৎকথাযাঃ কথনকালে ফিৰুশ্যেকো ভেজনায তং নিমন্ত্ৰযামাস, ততঃ স গৎৱা ভোক্তুম্ উপৱিৱেশ| ");
INSERT INTO sanasm_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","কিন্তু ভোজনাৎ পূৰ্ৱ্ৱং নামাঙ্ক্ষীৎ এতদ্ দৃষ্ট্ৱা স ফিৰুশ্যাশ্চৰ্য্যং মেনে| ");
INSERT INTO sanasm_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","তদা প্ৰভুস্তং প্ৰোৱাচ যূযং ফিৰূশিলোকাঃ পানপাত্ৰাণাং ভোজনপাত্ৰাণাঞ্চ বহিঃ পৰিষ্কুৰুথ কিন্তু যুষ্মাকমন্ত ৰ্দৌৰাত্ম্যৈ ৰ্দুষ্ক্ৰিযাভিশ্চ পৰিপূৰ্ণং তিষ্ঠতি| ");
INSERT INTO sanasm_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","হে সৰ্ৱ্ৱে নিৰ্বোধা যো বহিঃ সসৰ্জ স এৱ কিমন্ত ৰ্ন সসৰ্জ? ");
INSERT INTO sanasm_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","তত এৱ যুষ্মাভিৰন্তঃকৰণং (ঈশ্ৱৰায) নিৱেদ্যতাং তস্মিন্ কৃতে যুষ্মাকং সৰ্ৱ্ৱাণি শুচিতাং যাস্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","কিন্তু হন্ত ফিৰূশিগণা যূযং ন্যাযম্ ঈশ্ৱৰে প্ৰেম চ পৰিত্যজ্য পোদিনাযা অৰুদাদীনাং সৰ্ৱ্ৱেষাং শাকানাঞ্চ দশমাংশান্ দত্থ কিন্তু প্ৰথমং পালযিৎৱা শেষস্যালঙ্ঘনং যুষ্মাকম্ উচিতমাসীৎ| ");
INSERT INTO sanasm_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","হা হা ফিৰূশিনো যূযং ভজনগেহে প্ৰোচ্চাসনে আপণেষু চ নমস্কাৰেষু প্ৰীযধ্ৱে| ");
INSERT INTO sanasm_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","ৱত কপটিনোঽধ্যাপকাঃ ফিৰূশিনশ্চ লোকাযৎ শ্মশানম্ অনুপলভ্য তদুপৰি গচ্ছন্তি যূযম্ তাদৃগপ্ৰকাশিতশ্মশানৱাদ্ ভৱথ| ");
INSERT INTO sanasm_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","তদানীং ৱ্যৱস্থাপকানাম্ একা যীশুমৱদৎ, হে উপদেশক ৱাক্যেনেদৃশেনাস্মাস্ৱপি দোষম্ আৰোপযসি| ");
INSERT INTO sanasm_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ততঃ স উৱাচ, হা হা ৱ্যৱস্থাপকা যূযম্ মানুষাণাম্ উপৰি দুঃসহ্যান্ ভাৰান্ ন্যস্যথ কিন্তু স্ৱযম্ একাঙ্গুुল্যাপি তান্ ভাৰান্ ন স্পৃশথ| ");
INSERT INTO sanasm_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","হন্ত যুষ্মাকং পূৰ্ৱ্ৱপুৰুষা যান্ ভৱিষ্যদ্ৱাদিনোঽৱধিষুস্তেষাং শ্মশানানি যূযং নিৰ্ম্মাথ| ");
INSERT INTO sanasm_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","তেনৈৱ যূযং স্ৱপূৰ্ৱ্ৱপুৰুষাণাং কৰ্ম্মাণি সংমন্যধ্ৱে তদেৱ সপ্ৰমাণং কুৰুথ চ, যতস্তে তানৱধিষুঃ যূযং তেষাং শ্মশানানি নিৰ্ম্মাথ| ");
INSERT INTO sanasm_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","অতএৱ ঈশ্ৱৰস্য শাস্ত্ৰে প্ৰোক্তমস্তি তেষামন্তিকে ভৱিষ্যদ্ৱাদিনঃ প্ৰেৰিতাংশ্চ প্ৰেষযিষ্যামি ততস্তে তেষাং কাংশ্চন হনিষ্যন্তি কাংশ্চন তাডশ্ষ্যিন্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","এতস্মাৎ কাৰণাৎ হাবিলঃ শোণিতপাতমাৰভ্য মন্দিৰযজ্ঞৱেদ্যো ৰ্মধ্যে হতস্য সিখৰিযস্য ৰক্তপাতপৰ্য্যন্তং ");
INSERT INTO sanasm_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","জগতঃ সৃষ্টিমাৰভ্য পৃথিৱ্যাং ভৱিষ্যদ্ৱাদিনাং যতিৰক্তপাতা জাতাস্ততীনাম্ অপৰাধদণ্ডা এষাং ৱৰ্ত্তমানলোকানাং ভৱিষ্যন্তি, যুষ্মানহং নিশ্চিতং ৱদামি সৰ্ৱ্ৱে দণ্ডা ৱংশস্যাস্য ভৱিষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","হা হা ৱ্যৱস্থপকা যূযং জ্ঞানস্য কুঞ্চিকাং হৃৎৱা স্ৱযং ন প্ৰৱিষ্টা যে প্ৰৱেষ্টুঞ্চ প্ৰযাসিনস্তানপি প্ৰৱেষ্টুং ৱাৰিতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","ইত্থং কথাকথনাদ্ অধ্যাপকাঃ ফিৰূশিনশ্চ সতৰ্কাঃ ");
INSERT INTO sanasm_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","সন্তস্তমপৱদিতুং তস্য কথাযা দোষং ধৰ্ত্তমিচ্ছন্তো নানাখ্যানকথনায তং প্ৰৱৰ্ত্তযিতুং কোপযিতুঞ্চ প্ৰাৰেভিৰে| ");
INSERT INTO sanasm_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","তদানীং লোকাঃ সহস্ৰং সহস্ৰম্ আগত্য সমুপস্থিতাস্তত একৈকো ঽন্যেষামুপৰি পতিতুম্ উপচক্ৰমে; তদা যীশুঃ শিষ্যান্ বভাষে, যূযং ফিৰূশিনাং কিণ্ৱৰূপকাপট্যে ৱিশেষেণ সাৱধানাস্তিষ্ঠত| ");
INSERT INTO sanasm_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","যতো যন্ন প্ৰকাশযিষ্যতে তদাচ্ছন্নং ৱস্তু কিমপি নাস্তি; তথা যন্ন জ্ঞাস্যতে তদ্ গুপ্তং ৱস্তু কিমপি নাস্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","অন্ধকাৰে তিষ্ঠনতো যাঃ কথা অকথযত তাঃ সৰ্ৱ্ৱাঃ কথা দীপ্তৌ শ্ৰোষ্যন্তে নিৰ্জনে কৰ্ণে চ যদকথযত গৃহপৃষ্ঠাৎ তৎ প্ৰচাৰযিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","হে বন্ধৱো যুষ্মানহং ৱদামি, যে শৰীৰস্য নাশং ৱিনা কিমপ্যপৰং কৰ্ত্তুং ন শক্ৰুৱন্তি তেভ্যো মা ভৈষ্ট| ");
INSERT INTO sanasm_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","তৰ্হি কস্মাদ্ ভেতৱ্যম্ ইত্যহং ৱদামি, যঃ শৰীৰং নাশযিৎৱা নৰকং নিক্ষেপ্তুং শক্নোতি তস্মাদেৱ ভযং কুৰুত, পুনৰপি ৱদামি তস্মাদেৱ ভযং কুৰুত| ");
INSERT INTO sanasm_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","পঞ্চ চটকপক্ষিণঃ কিং দ্ৱাভ্যাং তাম্ৰখণ্ডাভ্যাং ন ৱিক্ৰীযন্তে? তথাপীশ্ৱৰস্তেষাম্ একমপি ন ৱিস্মৰতি| ");
INSERT INTO sanasm_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","যুষ্মাকং শিৰঃকেশা অপি গণিতাঃ সন্তি তস্মাৎ মা ৱিভীত বহুচটকপক্ষিভ্যোপি যূযং বহুমূল্যাঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","অপৰং যুষ্মভ্যং কথযামি যঃ কশ্চিন্ মানুষাণাং সাক্ষান্ মাং স্ৱীকৰোতি মনুষ্যপুত্ৰ ঈশ্ৱৰদূতানাং সাক্ষাৎ তং স্ৱীকৰিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","কিন্তু যঃ কশ্চিন্মানুষাণাং সাক্ষান্মাম্ অস্ৱীকৰোতি তম্ ঈশ্ৱৰস্য দূতানাং সাক্ষাদ্ অহম্ অস্ৱীকৰিষ্যামি| ");
INSERT INTO sanasm_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","অন্যচ্চ যঃ কশ্চিন্ মনুজসুতস্য নিন্দাভাৱেন কাঞ্চিৎ কথাং কথযতি তস্য তৎপাপস্য মোচনং ভৱিষ্যতি কিন্তু যদি কশ্চিৎ পৱিত্ৰম্ আত্মানং নিন্দতি তৰ্হি তস্য তৎপাপস্য মোচনং ন ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","যদা লোকা যুষ্মান্ ভজনগেহং ৱিচাৰকৰ্তৃৰাজ্যকৰ্তৃণাং সম্মুখঞ্চ নেষ্যন্তি তদা কেন প্ৰকাৰেণ কিমুত্তৰং ৱদিষ্যথ কিং কথযিষ্যথ চেত্যত্ৰ মা চিন্তযত; ");
INSERT INTO sanasm_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","যতো যুষ্মাভিৰ্যদ্ যদ্ ৱক্তৱ্যং তৎ তস্মিন্ সমযএৱ পৱিত্ৰ আত্মা যুষ্মান্ শিক্ষযিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ততঃ পৰং জনতামধ্যস্থঃ কশ্চিজ্জনস্তং জগাদ হে গুৰো মযা সহ পৈতৃকং ধনং ৱিভক্তুং মম ভ্ৰাতৰমাজ্ঞাপযতু ভৱান্| ");
INSERT INTO sanasm_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","কিন্তু স তমৱদৎ হে মনুষ্য যুৱযো ৰ্ৱিচাৰং ৱিভাগঞ্চ কৰ্ত্তুং মাং কো নিযুক্তৱান্? ");
INSERT INTO sanasm_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","অনন্তৰং স লোকানৱদৎ লোভে সাৱধানাঃ সতৰ্কাশ্চ তিষ্ঠত, যতো বহুসম্পত্তিপ্ৰাপ্ত্যা মনুষ্যস্যাযু ৰ্ন ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","পশ্চাদ্ দৃষ্টান্তকথামুত্থাপ্য কথযামাস, একস্য ধনিনো ভূমৌ বহূনি শস্যানি জাতানি| ");
INSERT INTO sanasm_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ততঃ স মনসা চিন্তযিৎৱা কথযাম্বভূৱ মমৈতানি সমুৎপন্নানি দ্ৰৱ্যাণি স্থাপযিতুং স্থানং নাস্তি কিং কৰিষ্যামি? ");
INSERT INTO sanasm_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ততোৱদদ্ ইত্থং কৰিষ্যামি, মম সৰ্ৱ্ৱভাণ্ডাগাৰাণি ভঙ্ক্ত্ৱা বৃহদ্ভাণ্ডাগাৰাণি নিৰ্ম্মায তন্মধ্যে সৰ্ৱ্ৱফলানি দ্ৰৱ্যাণি চ স্থাপযিষ্যামি| ");
INSERT INTO sanasm_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","অপৰং নিজমনো ৱদিষ্যামি, হে মনো বহুৱৎসৰাৰ্থং নানাদ্ৰৱ্যাণি সঞ্চিতানি সন্তি ৱিশ্ৰামং কুৰু ভুক্ত্ৱা পীৎৱা কৌতুকঞ্চ কুৰু| কিন্ত্ৱীশ্ৱৰস্তম্ অৱদৎ, ");
INSERT INTO sanasm_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","ৰে নিৰ্বোধ অদ্য ৰাত্ৰৌ তৱ প্ৰাণাস্ত্ৱত্তো নেষ্যন্তে তত এতানি যানি দ্ৰৱ্যাণি ৎৱযাসাদিতানি তানি কস্য ভৱিষ্যন্তি? ");
INSERT INTO sanasm_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","অতএৱ যঃ কশ্চিদ্ ঈশ্ৱৰস্য সমীপে ধনসঞ্চযমকৃৎৱা কেৱলং স্ৱনিকটে সঞ্চযং কৰোতি সোপি তাদৃশঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","অথ স শিষ্যেভ্যঃ কথযামাস, যুষ্মানহং ৱদামি, কিং খাদিষ্যামঃ? কিং পৰিধাস্যামঃ? ইত্যুক্ত্ৱা জীৱনস্য শৰীৰস্য চাৰ্থং চিন্তাং মা কাৰ্ষ্ট| ");
INSERT INTO sanasm_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ভক্ষ্যাজ্জীৱনং ভূষণাচ্ছৰীৰঞ্চ শ্ৰেষ্ঠং ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","কাকপক্ষিণাং কাৰ্য্যং ৱিচাৰযত, তে ন ৱপন্তি শস্যানি চ ন ছিন্দন্তি, তেষাং ভাণ্ডাগাৰাণি ন সন্তি কোষাশ্চ ন সন্তি, তথাপীশ্ৱৰস্তেভ্যো ভক্ষ্যাণি দদাতি, যূযং পক্ষিভ্যঃ শ্ৰেষ্ঠতৰা ন কিং? ");
INSERT INTO sanasm_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","অপৰঞ্চ ভাৱযিৎৱা নিজাযুষঃ ক্ষণমাত্ৰং ৱৰ্দ্ধযিতুং শক্নোতি, এতাদৃশো লাকো যুষ্মাকং মধ্যে কোস্তি? ");
INSERT INTO sanasm_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","অতএৱ ক্ষুদ্ৰং কাৰ্য্যং সাধযিতুম্ অসমৰ্থা যূযম্ অন্যস্মিন্ কাৰ্য্যে কুতো ভাৱযথ? ");
INSERT INTO sanasm_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","অন্যচ্চ কাম্পিলপুষ্পং কথং ৱৰ্দ্ধতে তদাপি ৱিচাৰযত, তৎ কঞ্চন শ্ৰমং ন কৰোতি তন্তূংশ্চ ন জনযতি কিন্তু যুষ্মভ্যং যথাৰ্থং কথযামি সুলেমান্ বহ্ৱৈশ্ৱৰ্য্যান্ৱিতোপি পুষ্পস্যাস্য সদৃশো ৱিভূষিতো নাসীৎ| ");
INSERT INTO sanasm_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","অদ্য ক্ষেত্ৰে ৱৰ্ত্তমানং শ্ৱশ্চূল্ল্যাং ক্ষেপ্স্যমানং যৎ তৃণং, তস্মৈ যদীশ্ৱৰ ইত্থং ভূষযতি তৰ্হি হে অল্পপ্ৰত্যযিনো যুষ্মান কিং ন পৰিধাপযিষ্যতি? ");
INSERT INTO sanasm_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","অতএৱ কিং খাদিষ্যামঃ? কিং পৰিধাস্যামঃ? এতদৰ্থং মা চেষ্টধ্ৱং মা সংদিগ্ধ্ৱঞ্চ| ");
INSERT INTO sanasm_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","জগতো দেৱাৰ্চ্চকা এতানি সৰ্ৱ্ৱাণি চেষ্টনতে; এষু ৱস্তুষু যুষ্মাকং প্ৰযোজনমাস্তে ইতি যুষ্মাকং পিতা জানাতি| ");
INSERT INTO sanasm_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","অতএৱেশ্ৱৰস্য ৰাজ্যাৰ্থং সচেষ্টা ভৱত তথা কৃতে সৰ্ৱ্ৱাণ্যেতানি দ্ৰৱ্যাণি যুষ্মভ্যং প্ৰদাযিষ্যন্তে| ");
INSERT INTO sanasm_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","হে ক্ষুদ্ৰমেষৱ্ৰজ যূযং মা ভৈষ্ট যুষ্মভ্যং ৰাজ্যং দাতুং যুষ্মাকং পিতুঃ সম্মতিৰস্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","অতএৱ যুষ্মাকং যা যা সম্পত্তিৰস্তি তাং তাং ৱিক্ৰীয ৱিতৰত, যৎ স্থানং চৌৰা নাগচ্ছন্তি, কীটাশ্চ ন ক্ষাযযন্তি তাদৃশে স্ৱৰ্গে নিজাৰ্থম্ অজৰে সম্পুটকে ঽক্ষযং ধনং সঞ্চিনুত চ; ");
INSERT INTO sanasm_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","যতো যত্ৰ যুষ্মাকং ধনং ৱৰ্ত্ততে তত্ৰেৱ যুষ্মাকং মনঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","অপৰঞ্চ যূযং প্ৰদীপং জ্ৱালযিৎৱা বদ্ধকটযস্তিষ্ঠত; ");
INSERT INTO sanasm_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","প্ৰভু ৰ্ৱিৱাহাদাগত্য যদৈৱ দ্ৱাৰমাহন্তি তদৈৱ দ্ৱাৰং মোচযিতুং যথা ভৃত্যা অপেক্ষ্য তিষ্ঠন্তি তথা যূযমপি তিষ্ঠত| ");
INSERT INTO sanasm_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","যতঃ প্ৰভুৰাগত্য যান্ দাসান্ সচেতনান্ তিষ্ঠতো দ্ৰক্ষ্যতি তএৱ ধন্যাঃ; অহং যুষ্মান্ যথাৰ্থং ৱদামি প্ৰভুস্তান্ ভোজনাৰ্থম্ উপৱেশ্য স্ৱযং বদ্ধকটিঃ সমীপমেত্য পৰিৱেষযিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","যদি দ্ৱিতীযে তৃতীযে ৱা প্ৰহৰে সমাগত্য তথৈৱ পশ্যতি, তৰ্হি তএৱ দাসা ধন্যাঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","অপৰঞ্চ কস্মিন্ ক্ষণে চৌৰা আগমিষ্যন্তি ইতি যদি গৃহপতি ৰ্জ্ঞাতুং শক্নোতি তদাৱশ্যং জাগ্ৰন্ নিজগৃহে সন্ধিং কৰ্ত্তযিতুং ৱাৰযতি যূযমেতদ্ ৱিত্ত| ");
INSERT INTO sanasm_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","অতএৱ যূযমপি সজ্জমানাস্তিষ্ঠত যতো যস্মিন্ ক্ষণে তং নাপ্ৰেক্ষধ্ৱে তস্মিন্নেৱ ক্ষণে মনুষ্যপুত্ৰ আগমিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","তদা পিতৰঃ পপ্ৰচ্ছ, হে প্ৰভো ভৱান্ কিমস্মান্ উদ্দিশ্য কিং সৰ্ৱ্ৱান্ উদ্দিশ্য দৃষ্টান্তকথামিমাং ৱদতি? ");
INSERT INTO sanasm_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ততঃ প্ৰভুঃ প্ৰোৱাচ, প্ৰভুঃ সমুচিতকালে নিজপৰিৱাৰাৰ্থং ভোজ্যপৰিৱেষণায যং তৎপদে নিযোক্ষ্যতি তাদৃশো ৱিশ্ৱাস্যো বোদ্ধা কৰ্ম্মাধীশঃ কোস্তি? ");
INSERT INTO sanasm_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","প্ৰভুৰাগত্য যম্ এতাদৃশে কৰ্ম্মণি প্ৰৱৃত্তং দ্ৰক্ষ্যতি সএৱ দাসো ধন্যঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","অহং যুষ্মান্ যথাৰ্থং ৱদামি স তং নিজসৰ্ৱ্ৱস্ৱস্যাধিপতিং কৰিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","কিন্তু প্ৰভুৰ্ৱিলম্বেনাগমিষ্যতি, ইতি ৱিচিন্ত্য স দাসো যদি তদন্যদাসীদাসান্ প্ৰহৰ্ত্তুম্ ভোক্তুং পাতুং মদিতুঞ্চ প্ৰাৰভতে, ");
INSERT INTO sanasm_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","তৰ্হি যদা প্ৰভুং নাপেক্ষিষ্যতে যস্মিন্ ক্ষণে সোঽচেতনশ্চ স্থাস্যতি তস্মিন্নেৱ ক্ষণে তস্য প্ৰভুৰাগত্য তং পদভ্ৰষ্টং কৃৎৱা ৱিশ্ৱাসহীনৈঃ সহ তস্য অংশং নিৰূপযিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","যো দাসঃ প্ৰভেाৰাজ্ঞাং জ্ঞাৎৱাপি সজ্জিতো ন তিষ্ঠতি তদাজ্ঞানুসাৰেণ চ কাৰ্য্যং ন কৰোতি সোনেকান্ প্ৰহাৰান্ প্ৰাপ্স্যতি; ");
INSERT INTO sanasm_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","কিন্তু যো জনোঽজ্ঞাৎৱা প্ৰহাৰাৰ্হং কৰ্ম্ম কৰোতি সোল্পপ্ৰহাৰান্ প্ৰাপ্স্যতি| যতো যস্মৈ বাহুল্যেন দত্তং তস্মাদেৱ বাহুল্যেন গ্ৰহীষ্যতে, মানুষা যস্য নিকটে বহু সমৰ্পযন্তি তস্মাদ্ বহু যাচন্তে| ");
INSERT INTO sanasm_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","অহং পৃথিৱ্যাম্ অনৈক্যৰূপং ৱহ্নি নিক্ষেপ্তুম্ আগতোস্মি, স চেদ্ ইদানীমেৱ প্ৰজ্ৱলতি তত্ৰ মম কা চিন্তা? ");
INSERT INTO sanasm_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","কিন্তু যেন মজ্জনেনাহং মগ্নো ভৱিষ্যামি যাৱৎকালং তস্য সিদ্ধি ৰ্ন ভৱিষ্যতি তাৱদহং কতিকষ্টং প্ৰাপ্স্যামি| ");
INSERT INTO sanasm_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","মেলনং কৰ্ত্তুং জগদ্ আগতোস্মি যূযং কিমিত্থং বোধধ্ৱে? যুষ্মান্ ৱদামি ন তথা, কিন্ত্ৱহং মেলনাভাৱং কৰ্ত্তুংম্ আগতোস্মি| ");
INSERT INTO sanasm_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","যস্মাদেতৎকালমাৰভ্য একত্ৰস্থপৰিজনানাং মধ্যে পঞ্চজনাঃ পৃথগ্ ভূৎৱা ত্ৰযো জনা দ্ৱযোৰ্জনযোঃ প্ৰতিকূলা দ্ৱৌ জনৌ চ ত্ৰযাণাং জনানাং প্ৰতিকূলৌ ভৱিষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","পিতা পুত্ৰস্য ৱিপক্ষঃ পুত্ৰশ্চ পিতু ৰ্ৱিপক্ষো ভৱিষ্যতি মাতা কন্যাযা ৱিপক্ষা কন্যা চ মাতু ৰ্ৱিপক্ষা ভৱিষ্যতি, তথা শ্ৱশ্ৰূৰ্বধ্ৱা ৱিপক্ষা বধূশ্চ শ্ৱশ্ৰ্ৱা ৱিপক্ষা ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","স লোকেভ্যোপৰমপি কথযামাস, পশ্চিমদিশি মেঘোদ্গমং দৃষ্ট্ৱা যূযং হঠাদ্ ৱদথ ৱৃষ্টি ৰ্ভৱিষ্যতি ততস্তথৈৱ জাযতে| ");
INSERT INTO sanasm_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","অপৰং দক্ষিণতো ৱাযৌ ৱাতি সতি ৱদথ নিদাঘো ভৱিষ্যতি ততঃ সোপি জাযতে| ");
INSERT INTO sanasm_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","ৰে ৰে কপটিন আকাশস্য ভূম্যাশ্চ লক্ষণং বোদ্ধুং শক্নুথ, ");
INSERT INTO sanasm_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","কিন্তু কালস্যাস্য লক্ষণং কুতো বোদ্ধুং ন শক্নুথ? যূযঞ্চ স্ৱযং কুতো ন ন্যাষ্যং ৱিচাৰযথ? ");
INSERT INTO sanasm_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","অপৰঞ্চ ৱিৱাদিনা সাৰ্দ্ধং ৱিচাৰযিতুঃ সমীপং গচ্ছন্ পথি তস্মাদুদ্ধাৰং প্ৰাপ্তুং যতস্ৱ নোচেৎ স ৎৱাং ধৃৎৱা ৱিচাৰযিতুঃ সমীপং নযতি| ৱিচাৰযিতা যদি ৎৱাং প্ৰহৰ্ত্তুঃ সমীপং সমৰ্পযতি প্ৰহৰ্ত্তা ৎৱাং কাৰাযাং বধ্নাতি ");
INSERT INTO sanasm_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","তৰ্হি ৎৱামহং ৱদামি ৎৱযা নিঃশেষং কপৰ্দকেষু ন পৰিশোধিতেষু ৎৱং ততো মুক্তিং প্ৰাপ্তুং ন শক্ষ্যসি| ");
INSERT INTO sanasm_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","অপৰঞ্চ পীলাতো যেষাং গালীলীযানাং ৰক্তানি বলীনাং ৰক্তৈঃ সহামিশ্ৰযৎ তেষাং গালীলীযানাং ৱৃত্তান্তং কতিপযজনা উপস্থাপ্য যীশৱে কথযামাসুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ততঃ স প্ৰত্যুৱাচ তেষাং লোকানাম্ এতাদৃশী দুৰ্গতি ৰ্ঘটিতা তৎকাৰণাদ্ যূযং কিমন্যেভ্যো গালীলীযেভ্যোপ্যধিকপাপিনস্তান্ বোধধ্ৱে? ");
INSERT INTO sanasm_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","যুষ্মানহং ৱদামি তথা ন কিন্তু মনঃসু ন পৰাৱৰ্ত্তিতেষু যূযমপি তথা নংক্ষ্যথ| ");
INSERT INTO sanasm_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","অপৰঞ্চ শীলোহনাম্ন উচ্চগৃহস্য পতনাদ্ যেঽষ্টাদশজনা মৃতাস্তে যিৰূশালমি নিৱাসিসৰ্ৱ্ৱলোকেভ্যোঽধিকাপৰাধিনঃ কিং যূযমিত্যং বোধধ্ৱে? ");
INSERT INTO sanasm_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","যুষ্মানহং ৱদামি তথা ন কিন্তু মনঃসু ন পৰিৱৰ্ত্তিতেষু যূযমপি তথা নংক্ষ্যথ| ");
INSERT INTO sanasm_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","অনন্তৰং স ইমাং দৃষ্টান্তকথামকথযদ্ একো জনো দ্ৰাক্ষাক্ষেত্ৰমধ্য একমুডুম্বৰৱৃক্ষং ৰোপিতৱান্| পশ্চাৎ স আগত্য তস্মিন্ ফলানি গৱেষযামাস, ");
INSERT INTO sanasm_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","কিন্তু ফলাপ্ৰাপ্তেঃ কাৰণাদ্ উদ্যানকাৰং ভৃত্যং জগাদ, পশ্য ৱৎসৰত্ৰযং যাৱদাগত্য এতস্মিন্নুডুম্বৰতৰৌ ক্ষলান্যন্ৱিচ্ছামি, কিন্তু নৈকমপি প্ৰপ্নোমি তৰুৰযং কুতো ৱৃথা স্থানং ৱ্যাপ্য তিষ্ঠতি? এনং ছিন্ধি| ");
INSERT INTO sanasm_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ততো ভৃত্যঃ প্ৰত্যুৱাচ, হে প্ৰভো পুনৰ্ৱৰ্ষমেকং স্থাতুম্ আদিশ; এতস্য মূলস্য চতুৰ্দিক্ষু খনিৎৱাহম্ আলৱালং স্থাপযামি| ");
INSERT INTO sanasm_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ততঃ ফলিতুং শক্নোতি যদি ন ফলতি তৰ্হি পশ্চাৎ ছেৎস্যসি| ");
INSERT INTO sanasm_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","অথ ৱিশ্ৰামৱাৰে ভজনগেহে যীশুৰুপদিশতি ");
INSERT INTO sanasm_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","তস্মিৎ সমযে ভূতগ্ৰস্তৎৱাৎ কুব্জীভূযাষ্টাদশৱৰ্ষাণি যাৱৎ কেনাপ্যুপাযেন ঋজু ৰ্ভৱিতুং ন শক্নোতি যা দুৰ্ব্বলা স্ত্ৰী, ");
INSERT INTO sanasm_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","তাং তত্ৰোপস্থিতাং ৱিলোক্য যীশুস্তামাহূয কথিতৱান্ হে নাৰি তৱ দৌৰ্ব্বল্যাৎ ৎৱং মুক্তা ভৱ| ");
INSERT INTO sanasm_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ততঃ পৰং তস্যা গাত্ৰে হস্তাৰ্পণমাত্ৰাৎ সা ঋজুৰ্ভূৎৱেশ্ৱৰস্য ধন্যৱাদং কৰ্ত্তুমাৰেভে| ");
INSERT INTO sanasm_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","কিন্তু ৱিশ্ৰামৱাৰে যীশুনা তস্যাঃ স্ৱাস্থ্যকৰণাদ্ ভজনগেহস্যাধিপতিঃ প্ৰকুপ্য লোকান্ উৱাচ, ষট্সু দিনেষু লোকৈঃ কৰ্ম্ম কৰ্ত্তৱ্যং তস্মাদ্ধেতোঃ স্ৱাস্থ্যাৰ্থং তেষু দিনেষু আগচ্ছত, ৱিশ্ৰামৱাৰে মাগচ্ছত| ");
INSERT INTO sanasm_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","তদা পভুঃ প্ৰত্যুৱাচ ৰে কপটিনো যুষ্মাকম্ একৈকো জনো ৱিশ্ৰামৱাৰে স্ৱীযং স্ৱীযং ৱৃষভং গৰ্দভং ৱা বন্ধনান্মোচযিৎৱা জলং পাযযিতুং কিং ন নযতি? ");
INSERT INTO sanasm_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","তৰ্হ্যাষ্টাদশৱৎসৰান্ যাৱৎ শৈতানা বদ্ধা ইব্ৰাহীমঃ সন্ততিৰিযং নাৰী কিং ৱিশ্ৰামৱাৰে ন মোচযিতৱ্যা? ");
INSERT INTO sanasm_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","এষু ৱাক্যেষু কথিতেষু তস্য ৱিপক্ষাঃ সলজ্জা জাতাঃ কিন্তু তেন কৃতসৰ্ৱ্ৱমহাকৰ্ম্মকাৰণাৎ লোকনিৱহঃ সানন্দোঽভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","অনন্তৰং সোৱদদ্ ঈশ্ৱৰস্য ৰাজ্যং কস্য সদৃশং? কেন তদুপমাস্যামি? ");
INSERT INTO sanasm_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","যৎ সৰ্ষপবীজং গৃহীৎৱা কশ্চিজ্জন উদ্যান উপ্তৱান্ তদ্ বীজমঙ্কুৰিতং সৎ মহাৱৃক্ষোঽজাযত, ততস্তস্য শাখাসু ৱিহাযসীযৱিহগা আগত্য ন্যূষুঃ, তদ্ৰাজ্যং তাদৃশেন সৰ্ষপবীজেন তুল্যং| ");
INSERT INTO sanasm_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","পুনঃ কথযামাস, ঈশ্ৱৰস্য ৰাজ্যং কস্য সদৃশং ৱদিষ্যামি? যৎ কিণ্ৱং কাচিৎ স্ত্ৰী গৃহীৎৱা দ্ৰোণত্ৰযপৰিমিতগোধূমচূৰ্ণেষু স্থাপযামাস, ");
INSERT INTO sanasm_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ততঃ ক্ৰমেণ তৎ সৰ্ৱ্ৱগোধূমচূৰ্ণং ৱ্যাপ্নোতি, তস্য কিণ্ৱস্য তুল্যম্ ঈশ্ৱৰস্য ৰাজ্যং| ");
INSERT INTO sanasm_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ততঃ স যিৰূশালম্নগৰং প্ৰতি যাত্ৰাং কৃৎৱা নগৰে নগৰে গ্ৰামে গ্ৰামে সমুপদিশন্ জগাম| ");
INSERT INTO sanasm_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","তদা কশ্চিজ্জনস্তং পপ্ৰচ্ছ, হে প্ৰভো কিং কেৱলম্ অল্পে লোকাঃ পৰিত্ৰাস্যন্তে? ");
INSERT INTO sanasm_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","ততঃ স লোকান্ উৱাচ, সংকীৰ্ণদ্ৱাৰেণ প্ৰৱেষ্টুং যতঘ্ৱং, যতোহং যুষ্মান্ ৱদামি, বহৱঃ প্ৰৱেষ্টুং চেষ্টিষ্যন্তে কিন্তু ন শক্ষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","গৃহপতিনোত্থায দ্ৱাৰে ৰুদ্ধে সতি যদি যূযং বহিঃ স্থিৎৱা দ্ৱাৰমাহত্য ৱদথ, হে প্ৰভো হে প্ৰভো অস্মৎকাৰণাদ্ দ্ৱাৰং মোচযতু, ততঃ স ইতি প্ৰতিৱক্ষ্যতি, যূযং কুত্ৰত্যা লোকা ইত্যহং ন জানামি| ");
INSERT INTO sanasm_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","তদা যূযং ৱদিষ্যথ, তৱ সাক্ষাদ্ ৱযং ভেाজনং পানঞ্চ কৃতৱন্তঃ, ৎৱঞ্চাস্মাকং নগৰস্য পথি সমুপদিষ্টৱান্| ");
INSERT INTO sanasm_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","কিন্তু স ৱক্ষ্যতি, যুষ্মানহং ৱদামি, যূযং কুত্ৰত্যা লোকা ইত্যহং ন জানামি; হে দুৰাচাৰিণো যূযং মত্তো দূৰীভৱত| ");
INSERT INTO sanasm_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","তদা ইব্ৰাহীমং ইস্হাকং যাকূবঞ্চ সৰ্ৱ্ৱভৱিষ্যদ্ৱাদিনশ্চ ঈশ্ৱৰস্য ৰাজ্যং প্ৰাপ্তান্ স্ৱাংশ্চ বহিষ্কৃতান্ দৃষ্ট্ৱা যূযং ৰোদনং দন্তৈৰ্দন্তঘৰ্ষণঞ্চ কৰিষ্যথ| ");
INSERT INTO sanasm_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","অপৰঞ্চ পূৰ্ৱ্ৱপশ্চিমদক্ষিণোত্তৰদিগ্ভ্যো লোকা আগত্য ঈশ্ৱৰস্য ৰাজ্যে নিৱৎস্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","পশ্যতেত্থং শেষীযা লোকা অগ্ৰা ভৱিষ্যন্তি, অগ্ৰীযা লোকাশ্চ শেষা ভৱিষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","অপৰঞ্চ তস্মিন্ দিনে কিযন্তঃ ফিৰূশিন আগত্য যীশুং প্ৰোচুঃ, বহিৰ্গচ্ছ, স্থানাদস্মাৎ প্ৰস্থানং কুৰু, হেৰোদ্ ৎৱাং জিঘাংসতি| ");
INSERT INTO sanasm_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ততঃ স প্ৰত্যৱোচৎ পশ্যতাদ্য শ্ৱশ্চ ভূতান্ ৱিহাপ্য ৰোগিণোঽৰোগিণঃ কৃৎৱা তৃতীযেহ্নি সেৎস্যামি, কথামেতাং যূযমিৎৱা তং ভূৰিমাযং ৱদত| ");
INSERT INTO sanasm_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","তত্ৰাপ্যদ্য শ্ৱঃ পৰশ্ৱশ্চ মযা গমনাগমনে কৰ্ত্তৱ্যে, যতো হেতো ৰ্যিৰূশালমো বহিঃ কুত্ৰাপি কোপি ভৱিষ্যদ্ৱাদী ন ঘানিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","হে যিৰূশালম্ হে যিৰূশালম্ ৎৱং ভৱিষ্যদ্ৱাদিনো হংসি তৱান্তিকে প্ৰেৰিতান্ প্ৰস্তৰৈৰ্মাৰযসি চ, যথা কুক্কুটী নিজপক্ষাধঃ স্ৱশাৱকান্ সংগৃহ্লাতি, তথাহমপি তৱ শিশূন্ সংগ্ৰহীতুং কতিৱাৰান্ ঐচ্ছং কিন্তু ৎৱং নৈচ্ছঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","পশ্যত যুষ্মাকং ৱাসস্থানানি প্ৰোচ্ছিদ্যমানানি পৰিত্যক্তানি চ ভৱিষ্যন্তি; যুষ্মানহং যথাৰ্থং ৱদামি, যঃ প্ৰভো ৰ্নাম্নাগচ্ছতি স ধন্য ইতি ৱাচং যাৱৎকালং ন ৱদিষ্যথ, তাৱৎকালং যূযং মাং ন দ্ৰক্ষ্যথ| ");
INSERT INTO sanasm_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","অনন্তৰং ৱিশ্ৰামৱাৰে যীশৌ প্ৰধানস্য ফিৰূশিনো গৃহে ভোক্তুং গতৱতি তে তং ৱীক্ষিতুম্ আৰেভিৰে| ");
INSERT INTO sanasm_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","তদা জলোদৰী তস্য সম্মুখে স্থিতঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ততঃ স ৱ্যৱস্থাপকান্ ফিৰূশিনশ্চ পপ্ৰচ্ছ, ৱিশ্ৰামৱাৰে স্ৱাস্থ্যং কৰ্ত্তৱ্যং ন ৱা? ততস্তে কিমপি ন প্ৰত্যূচুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","তদা স তং ৰোগিণং স্ৱস্থং কৃৎৱা ৱিসসৰ্জ; ");
INSERT INTO sanasm_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","তানুৱাচ চ যুষ্মাকং কস্যচিদ্ গৰ্দ্দভো ৱৃষভো ৱা চেদ্ গৰ্ত্তে পততি তৰ্হি ৱিশ্ৰামৱাৰে তৎক্ষণং স কিং তং নোত্থাপযিষ্যতি? ");
INSERT INTO sanasm_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ততস্তে কথাযা এতস্যাঃ কিমপি প্ৰতিৱক্তুং ন শেকুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","অপৰঞ্চ প্ৰধানস্থানমনোনীতৎৱকৰণং ৱিলোক্য স নিমন্ত্ৰিতান্ এতদুপদেশকথাং জগাদ, ");
INSERT INTO sanasm_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","ৎৱং ৱিৱাহাদিভোজ্যেষু নিমন্ত্ৰিতঃ সন্ প্ৰধানস্থানে মোপাৱেক্ষীঃ| ৎৱত্তো গৌৰৱান্ৱিতনিমন্ত্ৰিতজন আযাতে ");
INSERT INTO sanasm_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","নিমন্ত্ৰযিতাগত্য মনুষ্যাযৈতস্মৈ স্থানং দেহীতি ৱাক্যং চেদ্ ৱক্ষ্যতি তৰ্হি ৎৱং সঙ্কুচিতো ভূৎৱা স্থান ইতৰস্মিন্ উপৱেষ্টুম্ উদ্যংস্যসি| ");
INSERT INTO sanasm_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","অস্মাৎ কাৰণাদেৱ ৎৱং নিমন্ত্ৰিতো গৎৱাঽপ্ৰধানস্থান উপৱিশ, ততো নিমন্ত্ৰযিতাগত্য ৱদিষ্যতি, হে বন্ধো প্ৰোচ্চস্থানং গৎৱোপৱিশ, তথা সতি ভোজনোপৱিষ্টানাং সকলানাং সাক্ষাৎ ৎৱং মান্যো ভৱিষ্যসি| ");
INSERT INTO sanasm_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","যঃ কশ্চিৎ স্ৱমুন্নমযতি স নমযিষ্যতে, কিন্তু যঃ কশ্চিৎ স্ৱং নমযতি স উন্নমযিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","তদা স নিমন্ত্ৰযিতাৰং জনমপি জগাদ, মধ্যাহ্নে ৰাত্ৰৌ ৱা ভোজ্যে কৃতে নিজবন্ধুগণো ৱা ভ্ৰাতৃृগণো ৱা জ্ঞাতিগণো ৱা ধনিগণো ৱা সমীপৱাসিগণো ৱা এতান্ ন নিমন্ত্ৰয, তথা কৃতে চেৎ তে ৎৱাং নিমন্ত্ৰযিষ্যন্তি, তৰ্হি পৰিশোধো ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","কিন্তু যদা ভেজ্যং কৰোষি তদা দৰিদ্ৰশুষ্ককৰখঞ্জান্ধান্ নিমন্ত্ৰয, ");
INSERT INTO sanasm_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","তত আশিষং লপ্স্যসে, তেষু পৰিশোধং কৰ্ত্তুমশক্নুৱৎসু শ্মশানাদ্ধাৰ্ম্মিকানামুত্থানকালে ৎৱং ফলাং লপ্স্যসে| ");
INSERT INTO sanasm_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","অনন্তৰং তাং কথাং নিশম্য ভোজনোপৱিষ্টঃ কশ্চিৎ কথযামাস, যো জন ঈশ্ৱৰস্য ৰাজ্যে ভোক্তুং লপ্স্যতে সএৱ ধন্যঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ততঃ স উৱাচ, কশ্চিৎ জনো ৰাত্ৰৌ ভেाজ্যং কৃৎৱা বহূন্ নিমন্ত্ৰযামাস| ");
INSERT INTO sanasm_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ততো ভোজনসমযে নিমন্ত্ৰিতলোকান্ আহ্ৱাতুং দাসদ্ৱাৰা কথযামাস, খদ্যদ্ৰৱ্যাণি সৰ্ৱ্ৱাণি সমাসাদিতানি সন্তি, যূযমাগচ্ছত| ");
INSERT INTO sanasm_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","কিন্তু তে সৰ্ৱ্ৱ একৈকং ছলং কৃৎৱা ক্ষমাং প্ৰাৰ্থযাঞ্চক্ৰিৰে| প্ৰথমো জনঃ কথযামাস, ক্ষেত্ৰমেকং ক্ৰীতৱানহং তদেৱ দ্ৰষ্টুং মযা গন্তৱ্যম্, অতএৱ মাং ক্ষন্তুং তং নিৱেদয| ");
INSERT INTO sanasm_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","অন্যো জনঃ কথযামাস, দশৱৃষানহং ক্ৰীতৱান্ তান্ পৰীক্ষিতুং যামি তস্মাদেৱ মাং ক্ষন্তুং তং নিৱেদয| ");
INSERT INTO sanasm_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","অপৰঃ কথযামাস, ৱ্যূঢৱানহং তস্মাৎ কাৰণাদ্ যাতুং ন শক্নোমি| ");
INSERT INTO sanasm_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","পশ্চাৎ স দাসো গৎৱা নিজপ্ৰভোঃ সাক্ষাৎ সৰ্ৱ্ৱৱৃত্তান্তং নিৱেদযামাস, ততোসৌ গৃহপতিঃ কুপিৎৱা স্ৱদাসং ৱ্যাজহাৰ, ৎৱং সৎৱৰং নগৰস্য সন্নিৱেশান্ মাৰ্গাংশ্চ গৎৱা দৰিদ্ৰশুষ্ককৰখঞ্জান্ধান্ অত্ৰানয| ");
INSERT INTO sanasm_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","ততো দাসোঽৱদৎ, হে প্ৰভো ভৱত আজ্ঞানুসাৰেণাক্ৰিযত তথাপি স্থানমস্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","তদা প্ৰভুঃ পুন ৰ্দাসাযাকথযৎ, ৰাজপথান্ ৱৃক্ষমূলানি চ যাৎৱা মদীযগৃহপূৰণাৰ্থং লোকানাগন্তুং প্ৰৱৰ্ত্তয| ");
INSERT INTO sanasm_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","অহং যুষ্মভ্যং কথযামি, পূৰ্ৱ্ৱনিমন্ত্ৰিতানমেকোপি মমাস্য ৰাত্ৰিভোজ্যস্যাস্ৱাদং ন প্ৰাপ্স্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","অনন্তৰং বহুষু লোকেষু যীশোঃ পশ্চাদ্ ৱ্ৰজিতেষু সৎসু স ৱ্যাঘুট্য তেভ্যঃ কথযামাস, ");
INSERT INTO sanasm_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","যঃ কশ্চিন্ মম সমীপম্ আগত্য স্ৱস্য মাতা পিতা পত্নী সন্তানা ভ্ৰাতৰো ভগিম্যো নিজপ্ৰাণাশ্চ, এতেভ্যঃ সৰ্ৱ্ৱেভ্যো ময্যধিকং প্ৰেম ন কৰোতি, স মম শিষ্যো ভৱিতুং ন শক্ষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","যঃ কশ্চিৎ স্ৱীযং ক্ৰুশং ৱহন্ মম পশ্চান্ন গচ্ছতি, সোপি মম শিষ্যো ভৱিতুং ন শক্ষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","দুৰ্গনিৰ্ম্মাণে কতিৱ্যযো ভৱিষ্যতি, তথা তস্য সমাপ্তিকৰণাৰ্থং সম্পত্তিৰস্তি ন ৱা, প্ৰথমমুপৱিশ্য এতন্ন গণযতি, যুষ্মাকং মধ্য এতাদৃশঃ কোস্তি? ");
INSERT INTO sanasm_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","নোচেদ্ ভিত্তিং কৃৎৱা শেষে যদি সমাপযিতুং ন শক্ষ্যতি, ");
INSERT INTO sanasm_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","তৰ্হি মানুষোযং নিচেতুম্ আৰভত সমাপযিতুং নাশক্নোৎ, ইতি ৱ্যাহৃত্য সৰ্ৱ্ৱে তমুপহসিষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","অপৰঞ্চ ভিন্নভূপতিনা সহ যুদ্ধং কৰ্ত্তুম্ উদ্যম্য দশসহস্ৰাণি সৈন্যানি গৃহীৎৱা ৱিংশতিসহস্ৰেঃ সৈন্যৈঃ সহিতস্য সমীপৱাসিনঃ সম্মুখং যাতুং শক্ষ্যামি ন ৱেতি প্ৰথমং উপৱিশ্য ন ৱিচাৰযতি এতাদৃশো ভূমিপতিঃ কঃ? ");
INSERT INTO sanasm_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","যদি ন শক্নোতি তৰ্হি ৰিপাৱতিদূৰে তিষ্ঠতি সতি নিজদূতং প্ৰেষ্য সন্ধিং কৰ্ত্তুং প্ৰাৰ্থযেত| ");
INSERT INTO sanasm_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","তদ্ৱদ্ যুষ্মাকং মধ্যে যঃ কশ্চিন্ মদৰ্থং সৰ্ৱ্ৱস্ৱং হাতুং ন শক্নোতি স মম শিষ্যো ভৱিতুং ন শক্ষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","লৱণম্ উত্তমম্ ইতি সত্যং, কিন্তু যদি লৱণস্য লৱণৎৱম্ অপগচ্ছতি তৰ্হি তৎ কথং স্ৱাদুযুক্তং ভৱিষ্যতি? ");
INSERT INTO sanasm_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","তদ ভূম্যৰ্থম্ আলৱালৰাশ্যৰ্থমপি ভদ্ৰং ন ভৱতি; লোকাস্তদ্ বহিঃ ক্ষিপন্তি| যস্য শ্ৰোতুং শ্ৰোত্ৰে স্তঃ স শৃণোতু| ");
INSERT INTO sanasm_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","তদা কৰসঞ্চাযিনঃ পাপিনশ্চ লোকা উপদেশ্কথাং শ্ৰোতুং যীশোঃ সমীপম্ আগচ্ছন্| ");
INSERT INTO sanasm_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ততঃ ফিৰূশিন উপাধ্যাযাশ্চ ৱিৱদমানাঃ কথযামাসুঃ এষ মানুষঃ পাপিভিঃ সহ প্ৰণযং কৃৎৱা তৈঃ সাৰ্দ্ধং ভুংক্তে| ");
INSERT INTO sanasm_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","তদা স তেভ্য ইমাং দৃষ্টান্তকথাং কথিতৱান্, ");
INSERT INTO sanasm_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","কস্যচিৎ শতমেষেষু তিষ্ঠত্মু তেষামেকং স যদি হাৰযতি তৰ্হি মধ্যেপ্ৰান্তৰম্ একোনশতমেষান্ ৱিহায হাৰিতমেষস্য উদ্দেশপ্ৰাপ্তিপৰ্য্যনতং ন গৱেষযতি, এতাদৃশো লোকো যুষ্মাকং মধ্যে ক আস্তে? ");
INSERT INTO sanasm_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","তস্যোদ্দেশং প্ৰাপ্য হৃষ্টমনাস্তং স্কন্ধে নিধায স্ৱস্থানম্ আনীয বন্ধুবান্ধৱসমীপৱাসিন আহূয ৱক্তি, ");
INSERT INTO sanasm_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","হাৰিতং মেষং প্ৰাপ্তোহম্ অতো হেতো ৰ্মযা সাৰ্দ্ধম্ আনন্দত| ");
INSERT INTO sanasm_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","তদ্ৱদহং যুষ্মান্ ৱদামি, যেষাং মনঃপৰাৱৰ্ত্তনস্য প্ৰযোজনং নাস্তি, তাদৃশৈকোনশতধাৰ্ম্মিককাৰণাদ্ য আনন্দস্তস্মাদ্ একস্য মনঃপৰিৱৰ্ত্তিনঃ পাপিনঃ কাৰণাৎ স্ৱৰ্গে ঽধিকানন্দো জাযতে| ");
INSERT INTO sanasm_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","অপৰঞ্চ দশানাং ৰূপ্যখণ্ডানাম্ একখণ্ডে হাৰিতে প্ৰদীপং প্ৰজ্ৱাল্য গৃহং সম্মাৰ্জ্য তস্য প্ৰাপ্তিং যাৱদ্ যত্নেন ন গৱেষযতি, এতাদৃশী যোষিৎ কাস্তে? ");
INSERT INTO sanasm_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","প্ৰাপ্তে সতি বন্ধুবান্ধৱসমীপৱাসিনীৰাহূয কথযতি, হাৰিতং ৰূপ্যখণ্ডং প্ৰাপ্তাহং তস্মাদেৱ মযা সাৰ্দ্ধম্ আনন্দত| ");
INSERT INTO sanasm_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","তদ্ৱদহং যুষ্মান্ ৱ্যাহৰামি, একেন পাপিনা মনসি পৰিৱৰ্ত্তিতে, ঈশ্ৱৰস্য দূতানাং মধ্যেপ্যানন্দো জাযতে| ");
INSERT INTO sanasm_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","অপৰঞ্চ স কথযামাস, কস্যচিদ্ দ্ৱৌ পুত্ৰাৱাস্তাং, ");
INSERT INTO sanasm_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","তযোঃ কনিষ্ঠঃ পুত্ৰঃ পিত্ৰে কথযামাস, হে পিতস্তৱ সম্পত্ত্যা যমংশং প্ৰাপ্স্যাম্যহং ৱিভজ্য তং দেহি, ততঃ পিতা নিজাং সম্পত্তিং ৱিভজ্য তাভ্যাং দদৌ| ");
INSERT INTO sanasm_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","কতিপযাৎ কালাৎ পৰং স কনিষ্ঠপুত্ৰঃ সমস্তং ধনং সংগৃহ্য দূৰদেশং গৎৱা দুষ্টাচৰণেন সৰ্ৱ্ৱাং সম্পত্তিং নাশযামাস| ");
INSERT INTO sanasm_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","তস্য সৰ্ৱ্ৱধনে ৱ্যযং গতে তদ্দেশে মহাদুৰ্ভিক্ষং বভূৱ, ততস্তস্য দৈন্যদশা ভৱিতুম্ আৰেভে| ");
INSERT INTO sanasm_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ততঃ পৰং স গৎৱা তদ্দেশীযং গৃহস্থমেকম্ আশ্ৰযত; ততঃ সতং শূকৰৱ্ৰজং চাৰযিতুং প্ৰান্তৰং প্ৰেষযামাস| ");
INSERT INTO sanasm_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","কেনাপি তস্মৈ ভক্ষ্যাদানাৎ স শূকৰফলৱল্কলেন পিচিণ্ডপূৰণাং ৱৱাঞ্ছ| ");
INSERT INTO sanasm_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","শেষে স মনসি চেতনাং প্ৰাপ্য কথযামাস, হা মম পিতুঃ সমীপে কতি কতি ৱেতনভুজো দাসা যথেষ্টং ততোধিকঞ্চ ভক্ষ্যং প্ৰাপ্নুৱন্তি কিন্ত্ৱহং ক্ষুধা মুমূৰ্ষুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","অহমুত্থায পিতুঃ সমীপং গৎৱা কথামেতাং ৱদিষ্যামি, হে পিতৰ্ ঈশ্ৱৰস্য তৱ চ ৱিৰুদ্ধং পাপমকৰৱম্ ");
INSERT INTO sanasm_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","তৱ পুত্ৰইতি ৱিখ্যাতো ভৱিতুং ন যোগ্যোস্মি চ, মাং তৱ ৱৈতনিকং দাসং কৃৎৱা স্থাপয| ");
INSERT INTO sanasm_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","পশ্চাৎ স উত্থায পিতুঃ সমীপং জগাম; ততস্তস্য পিতাতিদূৰে তং নিৰীক্ষ্য দযাঞ্চক্ৰে, ধাৱিৎৱা তস্য কণ্ঠং গৃহীৎৱা তং চুচুম্ব চ| ");
INSERT INTO sanasm_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","তদা পুত্ৰ উৱাচ, হে পিতৰ্ ঈশ্ৱৰস্য তৱ চ ৱিৰুদ্ধং পাপমকৰৱং, তৱ পুত্ৰইতি ৱিখ্যাতো ভৱিতুং ন যোগ্যোস্মি চ| ");
INSERT INTO sanasm_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","কিন্তু তস্য পিতা নিজদাসান্ আদিদেশ, সৰ্ৱ্ৱোত্তমৱস্ত্ৰাণ্যানীয পৰিধাপযতৈনং হস্তে চাঙ্গুৰীযকম্ অৰ্পযত পাদযোশ্চোপানহৌ সমৰ্পযত; ");
INSERT INTO sanasm_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","পুষ্টং গোৱৎসম্ আনীয মাৰযত চ তং ভুক্ত্ৱা ৱযম্ আনন্দাম| ");
INSERT INTO sanasm_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","যতো মম পুত্ৰোযম্ অম্ৰিযত পুনৰজীৱীদ্ হাৰিতশ্চ লব্ধোভূৎ ততস্ত আনন্দিতুম্ আৰেভিৰে| ");
INSERT INTO sanasm_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","তৎকালে তস্য জ্যেষ্ঠঃ পুত্ৰঃ ক্ষেত্ৰ আসীৎ| অথ স নিৱেশনস্য নিকটং আগচ্ছন্ নৃত্যানাং ৱাদ্যানাঞ্চ শব্দং শ্ৰুৎৱা ");
INSERT INTO sanasm_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","দাসানাম্ একম্ আহূয পপ্ৰচ্ছ, কিং কাৰণমস্য? ");
INSERT INTO sanasm_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","ততঃ সোৱাদীৎ, তৱ ভ্ৰাতাগমৎ, তৱ তাতশ্চ তং সুশৰীৰং প্ৰাপ্য পুষ্টং গোৱৎসং মাৰিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","ততঃ স প্ৰকুপ্য নিৱেশনান্তঃ প্ৰৱেষ্টুং ন সম্মেনে; ততস্তস্য পিতা বহিৰাগত্য তং সাধযামাস| ");
INSERT INTO sanasm_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ততঃ স পিতৰং প্ৰত্যুৱাচ, পশ্য তৱ কাঞ্চিদপ্যাজ্ঞাং ন ৱিলংঘ্য বহূন্ ৱৎসৰান্ অহং ৎৱাং সেৱে তথাপি মিত্ৰৈঃ সাৰ্দ্ধম্ উৎসৱং কৰ্ত্তুং কদাপি ছাগমেকমপি মহ্যং নাদদাঃ; ");
INSERT INTO sanasm_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","কিন্তু তৱ যঃ পুত্ৰো ৱেশ্যাগমনাদিভিস্তৱ সম্পত্তিম্ অপৱ্যযিতৱান্ তস্মিন্নাগতমাত্ৰে তস্যৈৱ নিমিত্তং পুষ্টং গোৱৎসং মাৰিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","তদা তস্য পিতাৱোচৎ, হে পুত্ৰ ৎৱং সৰ্ৱ্ৱদা মযা সহাসি তস্মান্ মম যদ্যদাস্তে তৎসৰ্ৱ্ৱং তৱ| ");
INSERT INTO sanasm_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","কিন্তু তৱাযং ভ্ৰাতা মৃতঃ পুনৰজীৱীদ্ হাৰিতশ্চ ভূৎৱা প্ৰাপ্তোভূৎ, এতস্মাৎ কাৰণাদ্ উৎসৱানন্দৌ কৰ্ত্তুম্ উচিতমস্মাকম্| ");
INSERT INTO sanasm_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","অপৰঞ্চ যীশুঃ শিষ্যেভ্যোন্যামেকাং কথাং কথযামাস কস্যচিদ্ ধনৱতো মনুষ্যস্য গৃহকাৰ্য্যাধীশে সম্পত্তেৰপৱ্যযেঽপৱাদিতে সতি ");
INSERT INTO sanasm_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","তস্য প্ৰভুস্তম্ আহূয জগাদ, ৎৱযি যামিমাং কথাং শৃণোমি সা কীদৃশী? ৎৱং গৃহকাৰ্য্যাধীশকৰ্ম্মণো গণনাং দৰ্শয গৃহকাৰ্য্যাধীশপদে ৎৱং ন স্থাস্যসি| ");
INSERT INTO sanasm_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","তদা স গৃহকাৰ্য্যাধীশো মনসা চিন্তযামাস, প্ৰভু ৰ্যদি মাং গৃহকাৰ্য্যাধীশপদাদ্ ভ্ৰংশযতি তৰ্হি কিং কৰিষ্যেঽহং? মৃদং খনিতুং মম শক্তি ৰ্নাস্তি ভিক্ষিতুঞ্চ লজ্জিষ্যেঽহং| ");
INSERT INTO sanasm_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","অতএৱ মযি গৃহকাৰ্য্যাধীশপদাৎ চ্যুতে সতি যথা লোকা মহ্যম্ আশ্ৰযং দাস্যন্তি তদৰ্থং যৎকৰ্ম্ম মযা কৰণীযং তন্ নিৰ্ণীযতে| ");
INSERT INTO sanasm_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","পশ্চাৎ স স্ৱপ্ৰভোৰেকৈকম্ অধমৰ্ণম্ আহূয প্ৰথমং পপ্ৰচ্ছ, ৎৱত্তো মে প্ৰভুণা কতি প্ৰাপ্যম্? ");
INSERT INTO sanasm_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ততঃ স উৱাচ, একশতাঢকতৈলানি; তদা গৃহকাৰ্য্যাধীশঃ প্ৰোৱাচ, তৱ পত্ৰমানীয শীঘ্ৰমুপৱিশ্য তত্ৰ পঞ্চাশতং লিখ| ");
INSERT INTO sanasm_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","পশ্চাদন্যমেকং পপ্ৰচ্ছ, ৎৱত্তো মে প্ৰভুণা কতি প্ৰাপ্যম্? ততঃ সোৱাদীদ্ একশতাঢকগোধূমাঃ; তদা স কথযামাস, তৱ পত্ৰমানীয অশীতিং লিখ| ");
INSERT INTO sanasm_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","তেনৈৱ প্ৰভুস্তমযথাৰ্থকৃতম্ অধীশং তদ্বুদ্ধিনৈপুণ্যাৎ প্ৰশশংস; ইত্থং দীপ্তিৰূপসন্তানেভ্য এতৎসংসাৰস্য সন্তানা ৱৰ্ত্তমানকালেঽধিকবুদ্ধিমন্তো ভৱন্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","অতো ৱদামি যূযমপ্যযথাৰ্থেন ধনেন মিত্ৰাণি লভধ্ৱং ততো যুষ্মাসু পদভ্ৰষ্টেষ্ৱপি তানি চিৰকালম্ আশ্ৰযং দাস্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","যঃ কশ্চিৎ ক্ষুদ্ৰে কাৰ্য্যে ৱিশ্ৱাস্যো ভৱতি স মহতি কাৰ্য্যেপি ৱিশ্ৱাস্যো ভৱতি, কিন্তু যঃ কশ্চিৎ ক্ষুদ্ৰে কাৰ্য্যেঽৱিশ্ৱাস্যো ভৱতি স মহতি কাৰ্য্যেপ্যৱিশ্ৱাস্যো ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","অতএৱ অযথাৰ্থেন ধনেন যদি যূযমৱিশ্ৱাস্যা জাতাস্তৰ্হি সত্যং ধনং যুষ্মাকং কৰেষু কঃ সমৰ্পযিষ্যতি? ");
INSERT INTO sanasm_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","যদি চ পৰধনেন যূযম্ অৱিশ্ৱাস্যা ভৱথ তৰ্হি যুষ্মাকং স্ৱকীযধনং যুষ্মভ্যং কো দাস্যতি? ");
INSERT INTO sanasm_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","কোপি দাস উভৌ প্ৰভূ সেৱিতুং ন শক্নোতি, যত একস্মিন্ প্ৰীযমাণোঽন্যস্মিন্নপ্ৰীযতে যদ্ৱা একং জনং সমাদৃত্য তদন্যং তুচ্ছীকৰোতি তদ্ৱদ্ যূযমপি ধনেশ্ৱৰৌ সেৱিতুং ন শক্নুথ| ");
INSERT INTO sanasm_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","তদৈতাঃ সৰ্ৱ্ৱাঃ কথাঃ শ্ৰুৎৱা লোভিফিৰূশিনস্তমুপজহসুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ততঃ স উৱাচ, যূযং মনুষ্যাণাং নিকটে স্ৱান্ নিৰ্দোষান্ দৰ্শযথ কিন্তু যুষ্মাকম্ অন্তঃকৰণানীশ্ৱৰো জানাতি, যৎ মনুষ্যাণাম্ অতি প্ৰশংস্যং তদ্ ঈশ্ৱৰস্য ঘৃণ্যং| ");
INSERT INTO sanasm_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","যোহন আগমনপৰ্য্যনতং যুষ্মাকং সমীপে ৱ্যৱস্থাভৱিষ্যদ্ৱাদিনাং লেখনানি চাসন্ ততঃ প্ৰভৃতি ঈশ্ৱৰৰাজ্যস্য সুসংৱাদঃ প্ৰচৰতি, একৈকো লোকস্তন্মধ্যং যত্নেন প্ৰৱিশতি চ| ");
INSERT INTO sanasm_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ৱৰং নভসঃ পৃথিৱ্যাশ্চ লোপো ভৱিষ্যতি তথাপি ৱ্যৱস্থাযা একবিন্দোৰপি লোপো ন ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","যঃ কশ্চিৎ স্ৱীযাং ভাৰ্য্যাং ৱিহায স্ত্ৰিযমন্যাং ৱিৱহতি স পৰদাৰান্ গচ্ছতি, যশ্চ তা ত্যক্তাং নাৰীং ৱিৱহতি সোপি পৰদাৰান গচ্ছতি| ");
INSERT INTO sanasm_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","একো ধনী মনুষ্যঃ শুক্লানি সূক্ষ্মাণি ৱস্ত্ৰাণি পৰ্য্যদধাৎ প্ৰতিদিনং পৰিতোষৰূপেণাভুংক্তাপিৱচ্চ| ");
INSERT INTO sanasm_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","সৰ্ৱ্ৱাঙ্গে ক্ষতযুক্ত ইলিযাসৰনামা কশ্চিদ্ দৰিদ্ৰস্তস্য ধনৱতো ভোজনপাত্ৰাৎ পতিতম্ উচ্ছিষ্টং ভোক্তুং ৱাঞ্ছন্ তস্য দ্ৱাৰে পতিৎৱাতিষ্ঠৎ; ");
INSERT INTO sanasm_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","অথ শ্ৱান আগত্য তস্য ক্ষতান্যলিহন্| ");
INSERT INTO sanasm_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","কিযৎকালাৎপৰং স দৰিদ্ৰঃ প্ৰাণান্ জহৌ; ততঃ স্ৱৰ্গীযদূতাস্তং নীৎৱা ইব্ৰাহীমঃ ক্ৰোড উপৱেশযামাসুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","পশ্চাৎ স ধনৱানপি মমাৰ, তং শ্মশানে স্থাপযামাসুশ্চ; কিন্তু পৰলোকে স ৱেদনাকুলঃ সন্ ঊৰ্দ্ধ্ৱাং নিৰীক্ষ্য বহুদূৰাদ্ ইব্ৰাহীমং তৎক্ৰোড ইলিযাসৰঞ্চ ৱিলোক্য ৰুৱন্নুৱাচ; ");
INSERT INTO sanasm_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","হে পিতৰ্ ইব্ৰাহীম্ অনুগৃহ্য অঙ্গুল্যগ্ৰভাগং জলে মজ্জযিৎৱা মম জিহ্ৱাং শীতলাং কৰ্ত্তুম্ ইলিযাসৰং প্ৰেৰয, যতো ৱহ্নিশিখাতোহং ৱ্যথিতোস্মি| ");
INSERT INTO sanasm_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","তদা ইব্ৰাহীম্ বভাষে, হে পুত্ৰ ৎৱং জীৱন্ সম্পদং প্ৰাপ্তৱান্ ইলিযাসৰস্তু ৱিপদং প্ৰাপ্তৱান্ এতৎ স্মৰ, কিন্তু সম্প্ৰতি তস্য সুখং তৱ চ দুঃখং ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","অপৰমপি যুষ্মাকম্ অস্মাকঞ্চ স্থানযো ৰ্মধ্যে মহদ্ৱিচ্ছেদোঽস্তি তত এতৎস্থানস্য লোকাস্তৎ স্থানং যাতুং যদ্ৱা তৎস্থানস্য লোকা এতৎ স্থানমাযাতুং ন শক্নুৱন্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","তদা স উক্তৱান্, হে পিতস্তৰ্হি ৎৱাং নিৱেদযামি মম পিতু ৰ্গেহে যে মম পঞ্চ ভ্ৰাতৰঃ সন্তি ");
INSERT INTO sanasm_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","তে যথৈতদ্ যাতনাস্থানং নাযাস্যন্তি তথা মন্ত্ৰণাং দাতুং তেষাং সমীপম্ ইলিযাসৰং প্ৰেৰয| ");
INSERT INTO sanasm_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","তত ইব্ৰাহীম্ উৱাচ, মূসাভৱিষ্যদ্ৱাদিনাঞ্চ পুস্তকানি তেষাং নিকটে সন্তি তে তদ্ৱচনানি মন্যন্তাং| ");
INSERT INTO sanasm_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","তদা স নিৱেদযামাস, হে পিতৰ্ ইব্ৰাহীম্ ন তথা, কিন্তু যদি মৃতলোকানাং কশ্চিৎ তেষাং সমীপং যাতি তৰ্হি তে মনাংসি ৱ্যাঘোটযিষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","তত ইব্ৰাহীম্ জগাদ, তে যদি মূসাভৱিষ্যদ্ৱাদিনাঞ্চ ৱচনানি ন মন্যন্তে তৰ্হি মৃতলোকানাং কস্মিংশ্চিদ্ উত্থিতেপি তে তস্য মন্ত্ৰণাং ন মংস্যন্তে| ");
INSERT INTO sanasm_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ইতঃ পৰং যীশুঃ শিষ্যান্ উৱাচ, ৱিঘ্নৈৰৱশ্যম্ আগন্তৱ্যং কিন্তু ৱিঘ্না যেন ঘটিষ্যন্তে তস্য দুৰ্গতি ৰ্ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","এতেষাং ক্ষুদ্ৰপ্ৰাণিনাম্ একস্যাপি ৱিঘ্নজননাৎ কণ্ঠবদ্ধপেষণীকস্য তস্য সাগৰাগাধজলে মজ্জনং ভদ্ৰং| ");
INSERT INTO sanasm_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","যূযং স্ৱেষু সাৱধানাস্তিষ্ঠত; তৱ ভ্ৰাতা যদি তৱ কিঞ্চিদ্ অপৰাধ্যতি তৰ্হি তং তৰ্জয, তেন যদি মনঃ পৰিৱৰ্ত্তযতি তৰ্হি তং ক্ষমস্ৱ| ");
INSERT INTO sanasm_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","পুনৰেকদিনমধ্যে যদি স তৱ সপ্তকৃৎৱোঽপৰাধ্যতি কিন্তু সপ্তকৃৎৱ আগত্য মনঃ পৰিৱৰ্ত্য মযাপৰাদ্ধম্ ইতি ৱদতি তৰ্হি তং ক্ষমস্ৱ| ");
INSERT INTO sanasm_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","তদা প্ৰেৰিতাঃ প্ৰভুম্ অৱদন্ অস্মাকং ৱিশ্ৱাসং ৱৰ্দ্ধয| ");
INSERT INTO sanasm_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","প্ৰভুৰুৱাচ, যদি যুষ্মাকং সৰ্ষপৈকপ্ৰমাণো ৱিশ্ৱাসোস্তি তৰ্হি ৎৱং সমূলমুৎপাটিতো ভূৎৱা সমুদ্ৰে ৰোপিতো ভৱ কথাযাম্ এতস্যাম্ এতদুডুম্বৰায কথিতাযাং স যুষ্মাকমাজ্ঞাৱহো ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","অপৰং স্ৱদাসে হলং ৱাহযিৎৱা ৱা পশূন্ চাৰযিৎৱা ক্ষেত্ৰাদ্ আগতে সতি তং ৱদতি, এহি ভোক্তুমুপৱিশ, যুষ্মাকম্ এতাদৃশঃ কোস্তি? ");
INSERT INTO sanasm_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ৱৰঞ্চ পূৰ্ৱ্ৱং মম খাদ্যমাসাদ্য যাৱদ্ ভুঞ্জে পিৱামি চ তাৱদ্ বদ্ধকটিঃ পৰিচৰ পশ্চাৎ ৎৱমপি ভোক্ষ্যসে পাস্যসি চ কথামীদৃশীং কিং ন ৱক্ষ্যতি? ");
INSERT INTO sanasm_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","তেন দাসেন প্ৰভোৰাজ্ঞানুৰূপে কৰ্ম্মণি কৃতে প্ৰভুঃ কিং তস্মিন্ বাধিতো জাতঃ? নেত্থং বুধ্যতে মযা| ");
INSERT INTO sanasm_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ইত্থং নিৰূপিতেষু সৰ্ৱ্ৱকৰ্ম্মসু কৃতেষু সত্মু যূযমপীদং ৱাক্যং ৱদথ, ৱযম্ অনুপকাৰিণো দাসা অস্মাভিৰ্যদ্যৎকৰ্ত্তৱ্যং তন্মাত্ৰমেৱ কৃতং| ");
INSERT INTO sanasm_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","স যিৰূশালমি যাত্ৰাং কুৰ্ৱ্ৱন্ শোমিৰোণ্গালীল্প্ৰদেশমধ্যেন গচ্ছতি, ");
INSERT INTO sanasm_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","এতৰ্হি কুত্ৰচিদ্ গ্ৰামে প্ৰৱেশমাত্ৰে দশকুষ্ঠিনস্তং সাক্ষাৎ কৃৎৱা ");
INSERT INTO sanasm_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","দূৰে তিষ্ঠনত উচ্চৈ ৰ্ৱক্তুমাৰেভিৰে, হে প্ৰভো যীশো দযস্ৱাস্মান্| ");
INSERT INTO sanasm_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ততঃ স তান্ দৃষ্ট্ৱা জগাদ, যূযং যাজকানাং সমীপে স্ৱান্ দৰ্শযত, ততস্তে গচ্ছন্তো ৰোগাৎ পৰিষ্কৃতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","তদা তেষামেকঃ স্ৱং স্ৱস্থং দৃষ্ট্ৱা প্ৰোচ্চৈৰীশ্ৱৰং ধন্যং ৱদন্ ৱ্যাঘুট্যাযাতো যীশো ৰ্গুণাননুৱদন্ তচ্চৰণাধোভূমৌ পপাত; ");
INSERT INTO sanasm_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","স চাসীৎ শোমিৰোণী| ");
INSERT INTO sanasm_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","তদা যীশুৰৱদৎ, দশজনাঃ কিং ন পৰিষ্কৃতাঃ? তহ্যন্যে নৱজনাঃ কুত্ৰ? ");
INSERT INTO sanasm_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ঈশ্ৱৰং ধন্যং ৱদন্তম্ এনং ৱিদেশিনং ৱিনা কোপ্যন্যো ন প্ৰাপ্যত| ");
INSERT INTO sanasm_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","তদা স তমুৱাচ, ৎৱমুত্থায যাহি ৱিশ্ৱাসস্তে ৎৱাং স্ৱস্থং কৃতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","অথ কদেশ্ৱৰস্য ৰাজৎৱং ভৱিষ্যতীতি ফিৰূশিভিঃ পৃষ্টে স প্ৰত্যুৱাচ, ঈশ্ৱৰস্য ৰাজৎৱম্ ঐশ্ৱৰ্য্যদৰ্শনেন ন ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","অত এতস্মিন্ পশ্য তস্মিন্ ৱা পশ্য, ইতি ৱাক্যং লোকা ৱক্তুং ন শক্ষ্যন্তি, ঈশ্ৱৰস্য ৰাজৎৱং যুষ্মাকম্ অন্তৰেৱাস্তে| ");
INSERT INTO sanasm_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ততঃ স শিষ্যান্ জগাদ, যদা যুষ্মাভি ৰ্মনুজসুতস্য দিনমেকং দ্ৰষ্টুম্ ৱাঞ্ছিষ্যতে কিন্তু ন দৰ্শিষ্যতে, ঈদৃক্কাল আযাতি| ");
INSERT INTO sanasm_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","তদাত্ৰ পশ্য ৱা তত্ৰ পশ্যেতি ৱাক্যং লোকা ৱক্ষ্যন্তি, কিন্তু তেষাং পশ্চাৎ মা যাত, মানুগচ্ছত চ| ");
INSERT INTO sanasm_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","যতস্তডিদ্ যথাকাশৈকদিশ্যুদিয তদন্যামপি দিশং ৱ্যাপ্য প্ৰকাশতে তদ্ৱৎ নিজদিনে মনুজসূনুঃ প্ৰকাশিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","কিন্তু তৎপূৰ্ৱ্ৱং তেনানেকানি দুঃখানি ভোক্তৱ্যান্যেতদ্ৱৰ্ত্তমানলোকৈশ্চ সোঽৱজ্ঞাতৱ্যঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","নোহস্য ৱিদ্যমানকালে যথাভৱৎ মনুষ্যসূনোঃ কালেপি তথা ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","যাৱৎকালং নোহো মহাপোতং নাৰোহদ্ আপ্লাৱিৱাৰ্য্যেত্য সৰ্ৱ্ৱং নানাশযচ্চ তাৱৎকালং যথা লোকা অভুঞ্জতাপিৱন্ ৱ্যৱহন্ ৱ্যৱাহযংশ্চ; ");
INSERT INTO sanasm_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ইত্থং লোটো ৱৰ্ত্তমানকালেপি যথা লোকা ভোজনপানক্ৰযৱিক্ৰযৰোপণগৃহনিৰ্ম্মাণকৰ্ম্মসু প্ৰাৱৰ্ত্তন্ত, ");
INSERT INTO sanasm_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","কিন্তু যদা লোট্ সিদোমো নিৰ্জগাম তদা নভসঃ সগন্ধকাগ্নিৱৃষ্টি ৰ্ভূৎৱা সৰ্ৱ্ৱং ৱ্যনাশযৎ ");
INSERT INTO sanasm_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","তদ্ৱন্ মানৱপুত্ৰপ্ৰকাশদিনেপি ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","তদা যদি কশ্চিদ্ গৃহোপৰি তিষ্ঠতি তৰ্হি স গৃহমধ্যাৎ কিমপি দ্ৰৱ্যমানেতুম্ অৱৰুহ্য নৈতু; যশ্চ ক্ষেত্ৰে তিষ্ঠতি সোপি ৱ্যাঘুট্য নাযাতু| ");
INSERT INTO sanasm_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","লোটঃ পত্নীং স্মৰত| ");
INSERT INTO sanasm_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","যঃ প্ৰাণান্ ৰক্ষিতুং চেষ্টিষ্যতে স প্ৰাণান্ হাৰযিষ্যতি যস্তু প্ৰাণান্ হাৰযিষ্যতি সএৱ প্ৰাণান্ ৰক্ষিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","যুষ্মানহং ৱচ্মি তস্যাং ৰাত্ৰৌ শয্যৈকগতযো ৰ্লোকযোৰেকো ধাৰিষ্যতে পৰস্ত্যক্ষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","স্ত্ৰিযৌ যুগপৎ পেষণীং ৱ্যাৱৰ্ত্তযিষ্যতস্তযোৰেকা ধাৰিষ্যতে পৰাত্যক্ষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","পুৰুষৌ ক্ষেত্ৰে স্থাস্যতস্তযোৰেকো ধাৰিষ্যতে পৰস্ত্যক্ষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","তদা তে পপ্ৰচ্ছুঃ, হে প্ৰভো কুত্ৰেত্থং ভৱিষ্যতি? ততঃ স উৱাচ, যত্ৰ শৱস্তিষ্ঠতি তত্ৰ গৃধ্ৰা মিলন্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","অপৰঞ্চ লোকৈৰক্লান্তৈ ৰ্নিৰন্তৰং প্ৰাৰ্থযিতৱ্যম্ ইত্যাশযেন যীশুনা দৃষ্টান্ত একঃ কথিতঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","কুত্ৰচিন্নগৰে কশ্চিৎ প্ৰাড্ৱিৱাক আসীৎ স ঈশ্ৱৰান্নাবিভেৎ মানুষাংশ্চ নামন্যত| ");
INSERT INTO sanasm_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","অথ তৎপুৰৱাসিনী কাচিদ্ৱিধৱা তৎসমীপমেত্য ৱিৱাদিনা সহ মম ৱিৱাদং পৰিষ্কুৰ্ৱ্ৱিতি নিৱেদযামাস| ");
INSERT INTO sanasm_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ততঃ স প্ৰাড্ৱিৱাকঃ কিযদ্দিনানি ন তদঙ্গীকৃতৱান্ পশ্চাচ্চিত্তে চিন্তযামাস, যদ্যপীশ্ৱৰান্ন বিভেমি মনুষ্যানপি ন মন্যে ");
INSERT INTO sanasm_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","তথাপ্যেষা ৱিধৱা মাং ক্লিশ্নাতি তস্মাদস্যা ৱিৱাদং পৰিষ্কৰিষ্যামি নোচেৎ সা সদাগত্য মাং ৱ্যগ্ৰং কৰিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","পশ্চাৎ প্ৰভুৰৱদদ্ অসাৱন্যাযপ্ৰাড্ৱিৱাকো যদাহ তত্ৰ মনো নিধধ্ৱং| ");
INSERT INTO sanasm_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ঈশ্ৱৰস্য যে ঽভিৰুচিতলোকা দিৱানিশং প্ৰাৰ্থযন্তে স বহুদিনানি ৱিলম্ব্যাপি তেষাং ৱিৱাদান্ কিং ন পৰিষ্কৰিষ্যতি? ");
INSERT INTO sanasm_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","যুষ্মানহং ৱদামি ৎৱৰযা পৰিষ্কৰিষ্যতি, কিন্তু যদা মনুষ্যপুত্ৰ আগমিষ্যতি তদা পৃথিৱ্যাং কিমীদৃশং ৱিশ্ৱাসং প্ৰাপ্স্যতি? ");
INSERT INTO sanasm_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","যে স্ৱান্ ধাৰ্ম্মিকান্ জ্ঞাৎৱা পৰান্ তুচ্ছীকুৰ্ৱ্ৱন্তি এতাদৃগ্ভ্যঃ, কিযদ্ভ্য ইমং দৃষ্টান্তং কথযামাস| ");
INSERT INTO sanasm_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","একঃ ফিৰূশ্যপৰঃ কৰসঞ্চাযী দ্ৱাৱিমৌ প্ৰাৰ্থযিতুং মন্দিৰং গতৌ| ");
INSERT INTO sanasm_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ততোঽসৌ ফিৰূশ্যেকপাৰ্শ্ৱে তিষ্ঠন্ হে ঈশ্ৱৰ অহমন্যলোকৱৎ লোঠযিতান্যাযী পাৰদাৰিকশ্চ ন ভৱামি অস্য কৰসঞ্চাযিনস্তুল্যশ্চ ন, তস্মাত্ত্ৱাং ধন্যং ৱদামি| ");
INSERT INTO sanasm_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","সপ্তসু দিনেষু দিনদ্ৱযমুপৱসামি সৰ্ৱ্ৱসম্পত্তে ৰ্দশমাংশং দদামি চ, এতৎকথাং কথযন্ প্ৰাৰ্থযামাস| ");
INSERT INTO sanasm_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","কিন্তু স কৰসঞ্চাযি দূৰে তিষ্ঠন্ স্ৱৰ্গং দ্ৰষ্টুং নেচ্ছন্ ৱক্ষসি কৰাঘাতং কুৰ্ৱ্ৱন্ হে ঈশ্ৱৰ পাপিষ্ঠং মাং দযস্ৱ, ইত্থং প্ৰাৰ্থযামাস| ");
INSERT INTO sanasm_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","যুষ্মানহং ৱদামি, তযোৰ্দ্ৱযো ৰ্মধ্যে কেৱলঃ কৰসঞ্চাযী পুণ্যৱত্ত্ৱেন গণিতো নিজগৃহং জগাম, যতো যঃ কশ্চিৎ স্ৱমুন্নমযতি স নামযিষ্যতে কিন্তু যঃ কশ্চিৎ স্ৱং নমযতি স উন্নমযিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","অথ শিশূনাং গাত্ৰস্পৰ্শাৰ্থং লোকাস্তান্ তস্য সমীপমানিন্যুঃ শিষ্যাস্তদ্ দৃষ্ট্ৱানেতৃন্ তৰ্জযামাসুঃ, ");
INSERT INTO sanasm_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","কিন্তু যীশুস্তানাহূয জগাদ, মন্নিকটম্ আগন্তুং শিশূন্ অনুজানীধ্ৱং তাংশ্চ মা ৱাৰযত; যত ঈশ্ৱৰৰাজ্যাধিকাৰিণ এষাং সদৃশাঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","অহং যুষ্মান্ যথাৰ্থং ৱদামি, যো জনঃ শিশোঃ সদৃশো ভূৎৱা ঈশ্ৱৰৰাজ্যং ন গৃহ্লাতি স কেনাপি প্ৰকাৰেণ তৎ প্ৰৱেষ্টুং ন শক্নোতি| ");
INSERT INTO sanasm_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","অপৰম্ একোধিপতিস্তং পপ্ৰচ্ছ, হে পৰমগুৰো, অনন্তাযুষঃ প্ৰাপ্তযে মযা কিং কৰ্ত্তৱ্যং? ");
INSERT INTO sanasm_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","যীশুৰুৱাচ, মাং কুতঃ পৰমং ৱদসি? ঈশ্ৱৰং ৱিনা কোপি পৰমো ন ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","পৰদাৰান্ মা গচ্ছ, নৰং মা জহি, মা চোৰয, মিথ্যাসাক্ষ্যং মা দেহি, মাতৰং পিতৰঞ্চ সংমন্যস্ৱ, এতা যা আজ্ঞাঃ সন্তি তাস্ত্ৱং জানাসি| ");
INSERT INTO sanasm_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","তদা স উৱাচ, বাল্যকালাৎ সৰ্ৱ্ৱা এতা আচৰামি| ");
INSERT INTO sanasm_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ইতি কথাং শ্ৰুৎৱা যীশুস্তমৱদৎ, তথাপি তৱৈকং কৰ্ম্ম ন্যূনমাস্তে, নিজং সৰ্ৱ্ৱস্ৱং ৱিক্ৰীয দৰিদ্ৰেভ্যো ৱিতৰ, তস্মাৎ স্ৱৰ্গে ধনং প্ৰাপ্স্যসি; তত আগত্য মমানুগামী ভৱ| ");
INSERT INTO sanasm_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","কিন্ত্ৱেতাং কথাং শ্ৰুৎৱা সোধিপতিঃ শুশোচ, যতস্তস্য বহুধনমাসীৎ| ");
INSERT INTO sanasm_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","তদা যীশুস্তমতিশোকান্ৱিতং দৃষ্ট্ৱা জগাদ, ধনৱতাম্ ঈশ্ৱৰৰাজ্যপ্ৰৱেশঃ কীদৃগ্ দুষ্কৰঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ঈশ্ৱৰৰাজ্যে ধনিনঃ প্ৰৱেশাৎ সূচেশ্ছিদ্ৰেণ মহাঙ্গস্য গমনাগমনে সুকৰে| ");
INSERT INTO sanasm_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","শ্ৰোতাৰঃ পপ্ৰচ্ছুস্তৰ্হি কেন পৰিত্ৰাণং প্ৰাপ্স্যতে? ");
INSERT INTO sanasm_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","স উক্তৱান্, যন্ মানুষেণাশক্যং তদ্ ঈশ্ৱৰেণ শক্যং| ");
INSERT INTO sanasm_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","তদা পিতৰ উৱাচ, পশ্য ৱযং সৰ্ৱ্ৱস্ৱং পৰিত্যজ্য তৱ পশ্চাদ্গামিনোঽভৱাম| ");
INSERT INTO sanasm_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ততঃ স উৱাচ, যুষ্মানহং যথাৰ্থং ৱদামি, ঈশ্ৱৰৰাজ্যাৰ্থং গৃহং পিতৰৌ ভ্ৰাতৃগণং জাযাং সন্তানাংশ্চ ত্যক্তৱা ");
INSERT INTO sanasm_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ইহ কালে ততোঽধিকং পৰকালে ঽনন্তাযুশ্চ ন প্ৰাপ্স্যতি লোক ঈদৃশঃ কোপি নাস্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","অনন্তৰং স দ্ৱাদশশিষ্যানাহূয বভাষে, পশ্যত ৱযং যিৰূশালম্নগৰং যামঃ, তস্মাৎ মনুষ্যপুত্ৰে ভৱিষ্যদ্ৱাদিভিৰুক্তং যদস্তি তদনুৰূপং তং প্ৰতি ঘটিষ্যতে; ");
INSERT INTO sanasm_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","ৱস্তুতস্তু সোঽন্যদেশীযানাং হস্তেষু সমৰ্পযিষ্যতে, তে তমুপহসিষ্যন্তি, অন্যাযমাচৰিষ্যন্তি তদ্ৱপুষি নিষ্ঠীৱং নিক্ষেপ্স্যন্তি, কশাভিঃ প্ৰহৃত্য তং হনিষ্যন্তি চ, ");
INSERT INTO sanasm_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","কিন্তু তৃতীযদিনে স শ্মশানাদ্ উত্থাস্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","এতস্যাঃ কথাযা অভিপ্ৰাযং কিঞ্চিদপি তে বোদ্ধুং ন শেকুঃ তেষাং নিকটেঽস্পষ্টতৱাৎ তস্যৈতাসাং কথানাম্ আশযং তে জ্ঞাতুং ন শেকুশ্চ| ");
INSERT INTO sanasm_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","অথ তস্মিন্ যিৰীহোঃ পুৰস্যান্তিকং প্ৰাপ্তে কশ্চিদন্ধঃ পথঃ পাৰ্শ্ৱ উপৱিশ্য ভিক্ষাম্ অকৰোৎ ");
INSERT INTO sanasm_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","স লোকসমূহস্য গমনশব্দং শ্ৰুৎৱা তৎকাৰণং পৃষ্টৱান্| ");
INSERT INTO sanasm_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","নাসৰতীযযীশুৰ্যাতীতি লোকৈৰুক্তে স উচ্চৈৰ্ৱক্তুমাৰেভে, ");
INSERT INTO sanasm_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","হে দাযূদঃ সন্তান যীশো মাং দযস্ৱ| ");
INSERT INTO sanasm_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ততোগ্ৰগামিনস্তং মৌনী তিষ্ঠেতি তৰ্জযামাসুঃ কিন্তু স পুনাৰুৱন্ উৱাচ, হে দাযূদঃ সন্তান মাং দযস্ৱ| ");
INSERT INTO sanasm_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","তদা যীশুঃ স্থগিতো ভূৎৱা স্ৱান্তিকে তমানেতুম্ আদিদেশ| ");
INSERT INTO sanasm_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","ততঃ স তস্যান্তিকম্ আগমৎ, তদা স তং পপ্ৰচ্ছ, ৎৱং কিমিচ্ছসি? ৎৱদৰ্থমহং কিং কৰিষ্যামি? স উক্তৱান্, হে প্ৰভোঽহং দ্ৰষ্টুং লভৈ| ");
INSERT INTO sanasm_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","তদা যীশুৰুৱাচ, দৃষ্টিশক্তিং গৃহাণ তৱ প্ৰত্যযস্ত্ৱাং স্ৱস্থং কৃতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ততস্তৎক্ষণাৎ তস্য চক্ষুষী প্ৰসন্নে; তস্মাৎ স ঈশ্ৱৰং ধন্যং ৱদন্ তৎপশ্চাদ্ যযৌ, তদালোক্য সৰ্ৱ্ৱে লোকা ঈশ্ৱৰং প্ৰশংসিতুম্ আৰেভিৰে| ");
INSERT INTO sanasm_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","যদা যীশু ৰ্যিৰীহোপুৰং প্ৰৱিশ্য তন্মধ্যেন গচ্ছংস্তদা ");
INSERT INTO sanasm_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","সক্কেযনামা কৰসঞ্চাযিনাং প্ৰধানো ধনৱানেকো ");
INSERT INTO sanasm_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","যীশুঃ কীদৃগিতি দ্ৰষ্টুং চেষ্টিতৱান্ কিন্তু খৰ্ৱ্ৱৎৱাল্লোকসংঘমধ্যে তদ্দৰ্শনমপ্ৰাপ্য ");
INSERT INTO sanasm_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","যেন পথা স যাস্যতি তৎপথেঽগ্ৰে ধাৱিৎৱা তং দ্ৰষ্টুম্ উডুম্বৰতৰুমাৰুৰোহ| ");
INSERT INTO sanasm_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","পশ্চাদ্ যীশুস্তৎস্থানম্ ইৎৱা ঊৰ্দ্ধ্ৱং ৱিলোক্য তং দৃষ্ট্ৱাৱাদীৎ, হে সক্কেয ৎৱং শীঘ্ৰমৱৰোহ মযাদ্য ৎৱদ্গেহে ৱস্তৱ্যং| ");
INSERT INTO sanasm_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ততঃ স শীঘ্ৰমৱৰুহ্য সাহ্লাদং তং জগ্ৰাহ| ");
INSERT INTO sanasm_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","তদ্ দৃষ্ট্ৱা সৰ্ৱ্ৱে ৱিৱদমানা ৱক্তুমাৰেভিৰে, সোতিথিৎৱেন দুষ্টলোকগৃহং গচ্ছতি| ");
INSERT INTO sanasm_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","কিন্তু সক্কেযো দণ্ডাযমানো ৱক্তুমাৰেভে, হে প্ৰভো পশ্য মম যা সম্পত্তিৰস্তি তদৰ্দ্ধং দৰিদ্ৰেভ্যো দদে, অপৰম্ অন্যাযং কৃৎৱা কস্মাদপি যদি কদাপি কিঞ্চিৎ মযা গৃহীতং তৰ্হি তচ্চতুৰ্গুণং দদামি| ");
INSERT INTO sanasm_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","তদা যীশুস্তমুক্তৱান্ অযমপি ইব্ৰাহীমঃ সন্তানোঽতঃ কাৰণাদ্ অদ্যাস্য গৃহে ত্ৰাণমুপস্থিতং| ");
INSERT INTO sanasm_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","যদ্ হাৰিতং তৎ মৃগযিতুং ৰক্ষিতুঞ্চ মনুষ্যপুত্ৰ আগতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","অথ স যিৰূশালমঃ সমীপ উপাতিষ্ঠদ্ ঈশ্ৱৰৰাজৎৱস্যানুষ্ঠানং তদৈৱ ভৱিষ্যতীতি লোকৈৰন্ৱভূযত, তস্মাৎ স শ্ৰোতৃভ্যঃ পুনৰ্দৃষ্টান্তকথাম্ উত্থাপ্য কথযামাস| ");
INSERT INTO sanasm_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","কোপি মহাল্লোকো নিজাৰ্থং ৰাজৎৱপদং গৃহীৎৱা পুনৰাগন্তুং দূৰদেশং জগাম| ");
INSERT INTO sanasm_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","যাত্ৰাকালে নিজান্ দশদাসান্ আহূয দশস্ৱৰ্ণমুদ্ৰা দত্ত্ৱা মমাগমনপৰ্য্যন্তং ৱাণিজ্যং কুৰুতেত্যাদিদেশ| ");
INSERT INTO sanasm_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","কিন্তু তস্য প্ৰজাস্তমৱজ্ঞায মনুষ্যমেনম্ অস্মাকমুপৰি ৰাজৎৱং ন কাৰযিৱ্যাম ইমাং ৱাৰ্ত্তাং তন্নিকটে প্ৰেৰযামাসুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","অথ স ৰাজৎৱপদং প্ৰাপ্যাগতৱান্ একৈকো জনো বাণিজ্যেন কিং লব্ধৱান্ ইতি জ্ঞাতুং যেষু দাসেষু মুদ্ৰা অৰ্পযৎ তান্ আহূযানেতুম্ আদিদেশ| ");
INSERT INTO sanasm_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","তদা প্ৰথম আগত্য কথিতৱান্, হে প্ৰভো তৱ তযৈকযা মুদ্ৰযা দশমুদ্ৰা লব্ধাঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","ততঃ স উৱাচ ৎৱমুত্তমো দাসঃ স্ৱল্পেন ৱিশ্ৱাস্যো জাত ইতঃ কাৰণাৎ ৎৱং দশনগৰাণাম্ অধিপো ভৱ| ");
INSERT INTO sanasm_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","দ্ৱিতীয আগত্য কথিতৱান্, হে প্ৰভো তৱৈকযা মুদ্ৰযা পঞ্চমুদ্ৰা লব্ধাঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ততঃ স উৱাচ, ৎৱং পঞ্চানাং নগৰাণামধিপতি ৰ্ভৱ| ");
INSERT INTO sanasm_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","ততোন্য আগত্য কথযামাস, হে প্ৰভো পশ্য তৱ যা মুদ্ৰা অহং ৱস্ত্ৰে বদ্ধ্ৱাস্থাপযং সেযং| ");
INSERT INTO sanasm_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ৎৱং কৃপণো যন্নাস্থাপযস্তদপি গৃহ্লাসি, যন্নাৱপস্তদেৱ চ ছিনৎসি ততোহং ৎৱত্তো ভীতঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","তদা স জগাদ, ৰে দুষ্টদাস তৱ ৱাক্যেন ৎৱাং দোষিণং কৰিষ্যামি, যদহং নাস্থাপযং তদেৱ গৃহ্লামি, যদহং নাৱপঞ্চ তদেৱ ছিনদ্মি, এতাদৃশঃ কৃপণোহমিতি যদি ৎৱং জানাসি, ");
INSERT INTO sanasm_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","তৰ্হি মম মুদ্ৰা বণিজাং নিকটে কুতো নাস্থাপযঃ? তযা কৃতেঽহম্ আগত্য কুসীদেন সাৰ্দ্ধং নিজমুদ্ৰা অপ্ৰাপ্স্যম্| ");
INSERT INTO sanasm_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","পশ্চাৎ স সমীপস্থান্ জনান্ আজ্ঞাপযৎ অস্মাৎ মুদ্ৰা আনীয যস্য দশমুদ্ৰাঃ সন্তি তস্মৈ দত্ত| ");
INSERT INTO sanasm_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","তে প্ৰোচুঃ প্ৰভোঽস্য দশমুদ্ৰাঃ সন্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","যুষ্মানহং ৱদামি যস্যাশ্ৰযে ৱদ্ধতে ঽধিকং তস্মৈ দাযিষ্যতে, কিন্তু যস্যাশ্ৰযে ন ৱৰ্দ্ধতে তস্য যদ্যদস্তি তদপি তস্মান্ নাযিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","কিন্তু মমাধিপতিৎৱস্য ৱশৎৱে স্থাতুম্ অসম্মন্যমানা যে মম ৰিপৱস্তানানীয মম সমক্ষং সংহৰত| ");
INSERT INTO sanasm_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ইত্যুপদেশকথাং কথযিৎৱা সোগ্ৰগঃ সন্ যিৰূশালমপুৰং যযৌ| ");
INSERT INTO sanasm_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ততো বৈৎফগীবৈথনীযাগ্ৰামযোঃ সমীপে জৈতুনাদ্ৰেৰন্তিকম্ ইৎৱা শিষ্যদ্ৱযম্ ইত্যুক্ত্ৱা প্ৰেষযামাস, ");
INSERT INTO sanasm_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","যুৱামমুং সম্মুখস্থগ্ৰামং প্ৰৱিশ্যৈৱ যং কোপি মানুষঃ কদাপি নাৰোহৎ তং গৰ্দ্দভশাৱকং বদ্ধং দ্ৰক্ষ্যথস্তং মোচযিৎৱানযতং| ");
INSERT INTO sanasm_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","তত্ৰ কুতো মোচযথঃ? ইতি চেৎ কোপি ৱক্ষ্যতি তৰ্হি ৱক্ষ্যথঃ প্ৰভেाৰত্ৰ প্ৰযোজনম্ আস্তে| ");
INSERT INTO sanasm_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","তদা তৌ প্ৰৰিতৌ গৎৱা তৎকথাाনুসাৰেণ সৰ্ৱ্ৱং প্ৰাপ্তৌ| ");
INSERT INTO sanasm_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","গৰ্দভশাৱকমোচনকালে তৎৱামিন ঊচুঃ, গৰ্দভশাৱকং কুতো মোচযথঃ? ");
INSERT INTO sanasm_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","তাৱূচতুঃ প্ৰভোৰত্ৰ প্ৰযোজনম্ আস্তে| ");
INSERT INTO sanasm_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","পশ্চাৎ তৌ তং গৰ্দভশাৱকং যীশোৰন্তিকমানীয তৎপৃষ্ঠে নিজৱসনানি পাতযিৎৱা তদুপৰি যীশুমাৰোহযামাসতুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","অথ যাত্ৰাকালে লোকাঃ পথি স্ৱৱস্ত্ৰাণি পাতযিতুম্ আৰেভিৰে| ");
INSERT INTO sanasm_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","অপৰং জৈতুনাদ্ৰেৰুপত্যকাম্ ইৎৱা শিষ্যসংঘঃ পূৰ্ৱ্ৱদৃষ্টানি মহাকৰ্ম্মাণি স্মৃৎৱা, ");
INSERT INTO sanasm_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","যো ৰাজা প্ৰভো ৰ্নাম্নাযাতি স ধন্যঃ স্ৱৰ্গে কুশলং সৰ্ৱ্ৱোচ্চে জযধ্ৱনি ৰ্ভৱতু, কথামেতাং কথযিৎৱা সানন্দম্ উচৈৰীশ্ৱৰং ধন্যং ৱক্তুমাৰেভে| ");
INSERT INTO sanasm_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","তদা লোকাৰণ্যমধ্যস্থাঃ কিযন্তঃ ফিৰূশিনস্তৎ শ্ৰুৎৱা যীশুং প্ৰোচুঃ, হে উপদেশক স্ৱশিষ্যান্ তৰ্জয| ");
INSERT INTO sanasm_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","স উৱাচ, যুষ্মানহং ৱদামি যদ্যমী নীৰৱাস্তিষ্ঠন্তি তৰ্হি পাষাণা উচৈঃ কথাঃ কথযিষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","পশ্চাৎ তৎপুৰান্তিকমেত্য তদৱলোক্য সাশ্ৰুপাতং জগাদ, ");
INSERT INTO sanasm_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","হা হা চেৎ ৎৱমগ্ৰেঽজ্ঞাস্যথাঃ, তৱাস্মিন্নেৱ দিনে ৱা যদি স্ৱমঙ্গলম্ উপালপ্স্যথাঃ, তৰ্হ্যুত্তমম্ অভৱিষ্যৎ, কিন্তু ক্ষণেস্মিন্ তত্তৱ দৃষ্টেৰগোচৰম্ ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ৎৱং স্ৱত্ৰাণকালে ন মনো ন্যধত্থা ইতি হেতো ৰ্যৎকালে তৱ ৰিপৱস্ত্ৱাং চতুৰ্দিক্ষু প্ৰাচীৰেণ ৱেষ্টযিৎৱা ৰোৎস্যন্তি ");
INSERT INTO sanasm_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","বালকৈঃ সাৰ্দ্ধং ভূমিসাৎ কৰিষ্যন্তি চ ৎৱন্মধ্যে পাষাণৈকোপি পাষাণোপৰি ন স্থাস্যতি চ, কাল ঈদৃশ উপস্থাস্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","অথ মধ্যেমন্দিৰং প্ৰৱিশ্য তত্ৰত্যান্ ক্ৰযিৱিক্ৰযিণো বহিষ্কুৰ্ৱ্ৱন্ ");
INSERT INTO sanasm_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","অৱদৎ মদ্গৃহং প্ৰাৰ্থনাগৃহমিতি লিপিৰাস্তে কিন্তু যূযং তদেৱ চৈৰাণাং গহ্ৱৰং কুৰুথ| ");
INSERT INTO sanasm_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","পশ্চাৎ স প্ৰত্যহং মধ্যেমন্দিৰম্ উপদিদেশ; ততঃ প্ৰধানযাজকা অধ্যাপকাঃ প্ৰাচীনাশ্চ তং নাশযিতুং চিচেষ্টিৰে; ");
INSERT INTO sanasm_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","কিন্তু তদুপদেশে সৰ্ৱ্ৱে লোকা নিৱিষ্টচিত্তাঃ স্থিতাস্তস্মাৎ তে তৎকৰ্ত্তুং নাৱকাশং প্ৰাপুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","অথৈকদা যীশু ৰ্মনিদৰে সুসংৱাদং প্ৰচাৰযন্ লোকানুপদিশতি, এতৰ্হি প্ৰধানযাজকা অধ্যাপকাঃ প্ৰাঞ্চশ্চ তন্নিকটমাগত্য পপ্ৰচ্ছুঃ ");
INSERT INTO sanasm_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","কযাজ্ঞযা ৎৱং কৰ্ম্মাণ্যেতানি কৰোষি? কো ৱা ৎৱামাজ্ঞাপযৎ? তদস্মান্ ৱদ| ");
INSERT INTO sanasm_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","স প্ৰত্যুৱাচ, তৰ্হি যুষ্মানপি কথামেকাং পৃচ্ছামি তস্যোত্তৰং ৱদত| ");
INSERT INTO sanasm_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","যোহনো মজ্জনম্ ঈশ্ৱৰস্য মানুষাণাং ৱাজ্ঞাতো জাতং? ");
INSERT INTO sanasm_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ততস্তে মিথো ৱিৱিচ্য জগদুঃ, যদীশ্ৱৰস্য ৱদামস্তৰ্হি তং কুতো ন প্ৰত্যৈত স ইতি ৱক্ষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","যদি মনুষ্যস্যেতি ৱদামস্তৰ্হি সৰ্ৱ্ৱে লোকা অস্মান্ পাষাণৈ ৰ্হনিষ্যন্তি যতো যোহন্ ভৱিষ্যদ্ৱাদীতি সৰ্ৱ্ৱে দৃঢং জানন্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","অতএৱ তে প্ৰত্যূচুঃ কস্যাজ্ঞযা জাতম্ ইতি ৱক্তুং ন শক্নুমঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","তদা যীশুৰৱদৎ তৰ্হি কযাজ্ঞযা কৰ্ম্মাণ্যেতাতি কৰোমীতি চ যুষ্মান্ ন ৱক্ষ্যামি| ");
INSERT INTO sanasm_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","অথ লোকানাং সাক্ষাৎ স ইমাং দৃষ্টান্তকথাং ৱক্তুমাৰেভে, কশ্চিদ্ দ্ৰাক্ষাক্ষেত্ৰং কৃৎৱা তৎ ক্ষেত্ৰং কৃষীৱলানাং হস্তেষু সমৰ্প্য বহুকালাৰ্থং দূৰদেশং জগাম| ");
INSERT INTO sanasm_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","অথ ফলকালে ফলানি গ্ৰহীতু কৃষীৱলানাং সমীপে দাসং প্ৰাহিণোৎ কিন্তু কৃষীৱলাস্তং প্ৰহৃত্য ৰিক্তহস্তং ৱিসসৰ্জুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","ততঃ সোধিপতিঃ পুনৰন্যং দাসং প্ৰেষযামাস, তে তমপি প্ৰহৃত্য কুৱ্যৱহৃত্য ৰিক্তহস্তং ৱিসসৃজুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ততঃ স তৃতীযৱাৰম্ অন্যং প্ৰাহিণোৎ তে তমপি ক্ষতাঙ্গং কৃৎৱা বহি ৰ্নিচিক্ষিপুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","তদা ক্ষেত্ৰপতি ৰ্ৱিচাৰযামাস, মমেদানীং কিং কৰ্ত্তৱ্যং? মম প্ৰিযে পুত্ৰে প্ৰহিতে তে তমৱশ্যং দৃষ্ট্ৱা সমাদৰিষ্যন্তে| ");
INSERT INTO sanasm_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","কিন্তু কৃষীৱলাস্তং নিৰীক্ষ্য পৰস্পৰং ৱিৱিচ্য প্ৰোচুঃ, অযমুত্তৰাধিকাৰী আগচ্ছতৈনং হন্মস্ততোধিকাৰোস্মাকং ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ততস্তে তং ক্ষেত্ৰাদ্ বহি ৰ্নিপাত্য জঘ্নুস্তস্মাৎ স ক্ষেত্ৰপতিস্তান্ প্ৰতি কিং কৰিষ্যতি? ");
INSERT INTO sanasm_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","স আগত্য তান্ কৃষীৱলান্ হৎৱা পৰেষাং হস্তেষু তৎক্ষেত্ৰং সমৰ্পযিষ্যতি; ইতি কথাং শ্ৰুৎৱা তে ঽৱদন্ এতাদৃশী ঘটনা ন ভৱতু| ");
INSERT INTO sanasm_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","কিন্তু যীশুস্তানৱলোক্য জগাদ, তৰ্হি, স্থপতযঃ কৰিষ্যন্তি গ্ৰাৱাণং যন্তু তুচ্ছকং| প্ৰধানপ্ৰস্তৰঃ কোণে স এৱ হি ভৱিষ্যতি| এতস্য শাস্ত্ৰীযৱচনস্য কিং তাৎপৰ্য্যং? ");
INSERT INTO sanasm_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","অপৰং তৎপাষাণোপৰি যঃ পতিষ্যতি স ভংক্ষ্যতে কিন্তু যস্যোপৰি স পাষাণঃ পতিষ্যতি স তেন ধূলিৱচ্ চূৰ্ণীভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","সোস্মাকং ৱিৰুদ্ধং দৃষ্টান্তমিমং কথিতৱান্ ইতি জ্ঞাৎৱা প্ৰধানযাজকা অধ্যাপকাশ্চ তদৈৱ তং ধৰ্তুং ৱৱাঞ্ছুঃ কিন্তু লোকেভ্যো বিভ্যুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","অতএৱ তং প্ৰতি সতৰ্কাঃ সন্তঃ কথং তদ্ৱাক্যদোষং ধৃৎৱা তং দেশাধিপস্য সাধুৱেশধাৰিণশ্চৰান্ তস্য সমীপে প্ৰেষযামাসুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","তদা তে তং পপ্ৰচ্ছুঃ, হে উপদেশক ভৱান্ যথাৰ্থং কথযন্ উপদিশতি, কমপ্যনপেক্ষ্য সত্যৎৱেনৈশ্ৱৰং মাৰ্গমুপদিশতি, ৱযমেতজ্জানীমঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","কৈসৰৰাজায কৰোস্মাভি ৰ্দেযো ন ৱা? ");
INSERT INTO sanasm_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","স তেষাং ৱঞ্চনং জ্ঞাৎৱাৱদৎ কুতো মাং পৰীক্ষধ্ৱে? মাং মুদ্ৰামেকং দৰ্শযত| ");
INSERT INTO sanasm_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","ইহ লিখিতা মূৰ্তিৰিযং নাম চ কস্য? তেঽৱদন্ কৈসৰস্য| ");
INSERT INTO sanasm_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","তদা স উৱাচ, তৰ্হি কৈসৰস্য দ্ৰৱ্যং কৈসৰায দত্ত; ঈশ্ৱৰস্য তু দ্ৰৱ্যমীশ্ৱৰায দত্ত| ");
INSERT INTO sanasm_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","তস্মাল্লোকানাং সাক্ষাৎ তৎকথাযাঃ কমপি দোষং ধৰ্তুমপ্ৰাপ্য তে তস্যোত্তৰাদ্ আশ্চৰ্য্যং মন্যমানা মৌনিনস্তস্থুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","অপৰঞ্চ শ্মশানাদুত্থানানঙ্গীকাৰিণাং সিদূকিনাং কিযন্তো জনা আগত্য তং পপ্ৰচ্ছুঃ, ");
INSERT INTO sanasm_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","হে উপদেশক শাস্ত্ৰে মূসা অস্মান্ প্ৰতীতি লিলেখ যস্য ভ্ৰাতা ভাৰ্য্যাযাং সত্যাং নিঃসন্তানো ম্ৰিযতে স তজ্জাযাং ৱিৱহ্য তদ্ৱংশম্ উৎপাদযিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","তথাচ কেচিৎ সপ্ত ভ্ৰাতৰ আসন্ তেষাং জ্যেষ্ঠো ভ্ৰাতা ৱিৱহ্য নিৰপত্যঃ প্ৰাণান্ জহৌ| ");
INSERT INTO sanasm_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","অথ দ্ৱিতীযস্তস্য জাযাং ৱিৱহ্য নিৰপত্যঃ সন্ মমাৰ| তৃতীযশ্চ তামেৱ ৱ্যুৱাহ; ");
INSERT INTO sanasm_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ইত্থং সপ্ত ভ্ৰাতৰস্তামেৱ ৱিৱহ্য নিৰপত্যাঃ সন্তো মম্ৰুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","শেষে সা স্ত্ৰী চ মমাৰ| ");
INSERT INTO sanasm_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","অতএৱ শ্মশানাদুত্থানকালে তেষাং সপ্তজনানাং কস্য সা ভাৰ্য্যা ভৱিষ্যতি? যতঃ সা তেষাং সপ্তানামেৱ ভাৰ্য্যাসীৎ| ");
INSERT INTO sanasm_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","তদা যীশুঃ প্ৰত্যুৱাচ, এতস্য জগতো লোকা ৱিৱহন্তি ৱাগ্দত্তাশ্চ ভৱন্তি ");
INSERT INTO sanasm_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","কিন্তু যে তজ্জগৎপ্ৰাপ্তিযোগ্যৎৱেন গণিতাং ভৱিষ্যন্তি শ্মশানাচ্চোত্থাস্যন্তি তে ন ৱিৱহন্তি ৱাগ্দত্তাশ্চ ন ভৱন্তি, ");
INSERT INTO sanasm_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","তে পুন ৰ্ন ম্ৰিযন্তে কিন্তু শ্মশানাদুত্থাপিতাঃ সন্ত ঈশ্ৱৰস্য সন্তানাঃ স্ৱৰ্গীযদূতানাং সদৃশাশ্চ ভৱন্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","অধিকন্তু মূসাঃ স্তম্বোপাখ্যানে পৰমেশ্ৱৰ ঈব্ৰাহীম ঈশ্ৱৰ ইস্হাক ঈশ্ৱৰো যাকূবশ্চেশ্ৱৰ ইত্যুক্ত্ৱা মৃতানাং শ্মশানাদ্ উত্থানস্য প্ৰমাণং লিলেখ| ");
INSERT INTO sanasm_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","অতএৱ য ঈশ্ৱৰঃ স মৃতানাং প্ৰভু ৰ্ন কিন্তু জীৱতামেৱ প্ৰভুঃ, তন্নিকটে সৰ্ৱ্ৱে জীৱন্তঃ সন্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ইতি শ্ৰুৎৱা কিযন্তোধ্যাপকা ঊচুঃ, হে উপদেশক ভৱান্ ভদ্ৰং প্ৰত্যুক্তৱান্| ");
INSERT INTO sanasm_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ইতঃ পৰং তং কিমপি প্ৰষ্টং তেষাং প্ৰগল্ভতা নাভূৎ| ");
INSERT INTO sanasm_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","পশ্চাৎ স তান্ উৱাচ, যঃ খ্ৰীষ্টঃ স দাযূদঃ সন্তান এতাং কথাং লোকাঃ কথং কথযন্তি? ");
INSERT INTO sanasm_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","যতঃ মম প্ৰভুমিদং ৱাক্যমৱদৎ পৰমেশ্ৱৰঃ| তৱ শত্ৰূনহং যাৱৎ পাদপীঠং কৰোমি ন| তাৱৎ কালং মদীযে ৎৱং দক্ষপাৰ্শ্ৱ উপাৱিশ| ");
INSERT INTO sanasm_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ইতি কথাং দাযূদ্ স্ৱযং গীতগ্ৰন্থেঽৱদৎ| ");
INSERT INTO sanasm_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","অতএৱ যদি দাযূদ্ তং প্ৰভুং ৱদতি, তৰ্হি স কথং তস্য সন্তানো ভৱতি? ");
INSERT INTO sanasm_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","পশ্চাদ্ যীশুঃ সৰ্ৱ্ৱজনানাং কৰ্ণগোচৰে শিষ্যানুৱাচ, ");
INSERT INTO sanasm_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","যেঽধ্যাপকা দীৰ্ঘপৰিচ্ছদং পৰিধায ভ্ৰমন্তি, হট্টাপণযো ৰ্নমস্কাৰে ভজনগেহস্য প্ৰোচ্চাসনে ভোজনগৃহস্য প্ৰধানস্থানে চ প্ৰীযন্তে ");
INSERT INTO sanasm_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ৱিধৱানাং সৰ্ৱ্ৱস্ৱং গ্ৰসিৎৱা ছলেন দীৰ্ঘকালং প্ৰাৰ্থযন্তে চ তেষু সাৱধানা ভৱত, তেষামুগ্ৰদণ্ডো ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","অথ ধনিলোকা ভাণ্ডাগাৰে ধনং নিক্ষিপন্তি স তদেৱ পশ্যতি, ");
INSERT INTO sanasm_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","এতৰ্হি কাচিদ্দীনা ৱিধৱা পণদ্ৱযং নিক্ষিপতি তদ্ দদৰ্শ| ");
INSERT INTO sanasm_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ততো যীশুৰুৱাচ যুষ্মানহং যথাৰ্থং ৱদামি, দৰিদ্ৰেযং ৱিধৱা সৰ্ৱ্ৱেভ্যোধিকং ন্যক্ষেপ্সীৎ, ");
INSERT INTO sanasm_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","যতোন্যে স্ৱপ্ৰাজ্যধনেভ্য ঈশ্ৱৰায কিঞ্চিৎ ন্যক্ষেপ্সুঃ, কিন্তু দৰিদ্ৰেযং ৱিধৱা দিনযাপনাৰ্থং স্ৱস্য যৎ কিঞ্চিৎ স্থিতং তৎ সৰ্ৱ্ৱং ন্যক্ষেপ্সীৎ| ");
INSERT INTO sanasm_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","অপৰঞ্চ উত্তমপ্ৰস্তৰৈৰুৎসৃষ্টৱ্যৈশ্চ মন্দিৰং সুশোভতেতৰাং কৈশ্চিদিত্যুক্তে স প্ৰত্যুৱাচ ");
INSERT INTO sanasm_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","যূযং যদিদং নিচযনং পশ্যথ, অস্য পাষাণৈকোপ্যন্যপাষাণোপৰি ন স্থাস্যতি, সৰ্ৱ্ৱে ভূসাদ্ভৱিষ্যন্তি কালোযমাযাতি| ");
INSERT INTO sanasm_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","তদা তে পপ্ৰচ্ছুঃ, হে গুৰো ঘটনেদৃশী কদা ভৱিষ্যতি? ঘটনাযা এতস্যসশ্চিহ্নং ৱা কিং ভৱিষ্যতি? ");
INSERT INTO sanasm_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","তদা স জগাদ, সাৱধানা ভৱত যথা যুষ্মাকং ভ্ৰমং কোপি ন জনযতি, খীষ্টোহমিত্যুক্ত্ৱা মম নাম্ৰা বহৱ উপস্থাস্যন্তি স কালঃ প্ৰাযেণোপস্থিতঃ, তেষাং পশ্চান্মা গচ্ছত| ");
INSERT INTO sanasm_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","যুদ্ধস্যোপপ্লৱস্য চ ৱাৰ্ত্তাং শ্ৰুৎৱা মা শঙ্কধ্ৱং, যতঃ প্ৰথমম্ এতা ঘটনা অৱশ্যং ভৱিষ্যন্তি কিন্তু নাপাতে যুগান্তো ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","অপৰঞ্চ কথযামাস, তদা দেশস্য ৱিপক্ষৎৱেন দেশো ৰাজ্যস্য ৱিপক্ষৎৱেন ৰাজ্যম্ উত্থাস্যতি, ");
INSERT INTO sanasm_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","নানাস্থানেষু মহাভূকম্পো দুৰ্ভিক্ষং মাৰী চ ভৱিষ্যন্তি, তথা ৱ্যোমমণ্ডলস্য ভযঙ্কৰদৰ্শনান্যশ্চৰ্য্যলক্ষণানি চ প্ৰকাশযিষ্যন্তে| ");
INSERT INTO sanasm_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","কিন্তু সৰ্ৱ্ৱাসামেতাসাং ঘটনানাং পূৰ্ৱ্ৱং লোকা যুষ্মান্ ধৃৎৱা তাডযিষ্যন্তি, ভজনালযে কাৰাযাঞ্চ সমৰ্পযিষ্যন্তি মম নামকাৰণাদ্ যুষ্মান্ ভূপানাং শাসকানাঞ্চ সম্মুখং নেষ্যন্তি চ| ");
INSERT INTO sanasm_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","সাক্ষ্যাৰ্থম্ এতানি যুষ্মান্ প্ৰতি ঘটিষ্যন্তে| ");
INSERT INTO sanasm_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","তদা কিমুত্তৰং ৱক্তৱ্যম্ এতৎ ন চিন্তযিষ্যাম ইতি মনঃসু নিশ্চিতনুত| ");
INSERT INTO sanasm_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ৱিপক্ষা যস্মাৎ কিমপ্যুত্তৰম্ আপত্তিঞ্চ কৰ্ত্তুং ন শক্ষ্যন্তি তাদৃশং ৱাক্পটুৎৱং জ্ঞানঞ্চ যুষ্মভ্যং দাস্যামি| ");
INSERT INTO sanasm_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","কিঞ্চ যূযং পিত্ৰা মাত্ৰা ভ্ৰাত্ৰা বন্ধুনা জ্ঞাত্যা কুটুম্বেন চ পৰকৰেষু সমৰ্পযিষ্যধ্ৱে; ততস্তে যুষ্মাকং কঞ্চন কঞ্চন ঘাতযিষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","মম নাম্নঃ কাৰণাৎ সৰ্ৱ্ৱৈ ৰ্মনুষ্যৈ ৰ্যূযম্ ঋতীযিষ্যধ্ৱে| ");
INSERT INTO sanasm_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","কিন্তু যুষ্মাকং শিৰঃকেশৈকোপি ন ৱিনংক্ষ্যতি, ");
INSERT INTO sanasm_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","তস্মাদেৱ ধৈৰ্য্যমৱলম্ব্য স্ৱস্ৱপ্ৰাণান্ ৰক্ষত| ");
INSERT INTO sanasm_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","অপৰঞ্চ যিৰূশালম্পুৰং সৈন্যৱেষ্টিতং ৱিলোক্য তস্যোচ্ছিন্নতাযাঃ সমযঃ সমীপ ইত্যৱগমিষ্যথ| ");
INSERT INTO sanasm_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","তদা যিহূদাদেশস্থা লোকাঃ পৰ্ৱ্ৱতং পলাযন্তাং, যে চ নগৰে তিষ্ঠন্তি তে দেশান্তৰং পলাযন্তা, যে চ গ্ৰামে তিষ্ঠন্তি তে নগৰং ন প্ৰৱিশন্তু, ");
INSERT INTO sanasm_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","যতস্তদা সমুচিতদণ্ডনায ধৰ্ম্মপুস্তকে যানি সৰ্ৱ্ৱাণি লিখিতানি তানি সফলানি ভৱিষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","কিন্তু যা যাস্তদা গৰ্ভৱত্যঃ স্তন্যদাৱ্যশ্চ তামাং দুৰ্গতি ৰ্ভৱিষ্যতি, যত এতাল্লোকান্ প্ৰতি কোপো দেশে চ ৱিষমদুৰ্গতি ৰ্ঘটিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","ৱস্তুতস্তু তে খঙ্গধাৰপৰিৱ্ৱঙ্গং লপ্স্যন্তে বদ্ধাঃ সন্তঃ সৰ্ৱ্ৱদেশেষু নাযিষ্যন্তে চ কিঞ্চান্যদেশীযানাং সমযোপস্থিতিপৰ্য্যন্তং যিৰূশালম্পুৰং তৈঃ পদতলৈ ৰ্দলযিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","সূৰ্য্যচন্দ্ৰনক্ষত্ৰেষু লক্ষণাদি ভৱিষ্যন্তি, ভুৱি সৰ্ৱ্ৱদেশীযানাং দুঃখং চিন্তা চ সিন্ধৌ ৱীচীনাং তৰ্জনং গৰ্জনঞ্চ ভৱিষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ভূভৌ ভাৱিঘটনাং চিন্তযিৎৱা মনুজা ভিযামৃতকল্পা ভৱিষ্যন্তি, যতো ৱ্যোমমণ্ডলে তেজস্ৱিনো দোলাযমানা ভৱিষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","তদা পৰাক্ৰমেণা মহাতেজসা চ মেঘাৰূঢং মনুষ্যপুত্ৰম্ আযান্তং দ্ৰক্ষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","কিন্ত্ৱেতাসাং ঘটনানামাৰম্ভে সতি যূযং মস্তকান্যুত্তোল্য ঊৰ্দধ্ৱং দ্ৰক্ষ্যথ, যতো যুষ্মাকং মুক্তেঃ কালঃ সৱিধো ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ততস্তেনৈতদৃষ্টান্তকথা কথিতা, পশ্যত উডুম্বৰাদিৱৃক্ষাণাং ");
INSERT INTO sanasm_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","নৱীনপত্ৰাণি জাতানীতি দৃষ্ট্ৱা নিদাৱকাল উপস্থিত ইতি যথা যূযং জ্ঞাতুং শক্নুথ, ");
INSERT INTO sanasm_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","তথা সৰ্ৱ্ৱাসামাসাং ঘটনানাম্ আৰম্ভে দৃষ্টে সতীশ্ৱৰস্য ৰাজৎৱং নিকটম্ ইত্যপি জ্ঞাস্যথ| ");
INSERT INTO sanasm_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","যুষ্মানহং যথাৰ্থং ৱদামি, ৱিদ্যমানলোকানামেষাং গমনাৎ পূৰ্ৱ্ৱম্ এতানি ঘটিষ্যন্তে| ");
INSERT INTO sanasm_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","নভোভুৱোৰ্লোপো ভৱিষ্যতি মম ৱাক্ তু কদাপি লুপ্তা ন ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","অতএৱ ৱিষমাশনেন পানেন চ সাংমাৰিকচিন্তাভিশ্চ যুষ্মাকং চিত্তেষু মত্তেষু তদ্দিনম্ অকস্মাদ্ যুষ্মান্ প্ৰতি যথা নোপতিষ্ঠতি তদৰ্থং স্ৱেষু সাৱধানাস্তিষ্ঠত| ");
INSERT INTO sanasm_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","পৃথিৱীস্থসৰ্ৱ্ৱলোকান্ প্ৰতি তদ্দিনম্ উন্মাথ ইৱ উপস্থাস্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","যথা যূযম্ এতদ্ভাৱিঘটনা উত্তৰ্ত্তুং মনুজসুতস্য সম্মুখে সংস্থাতুঞ্চ যোগ্যা ভৱথ কাৰণাদস্মাৎ সাৱধানাঃ সন্তো নিৰন্তৰং প্ৰাৰ্থযধ্ৱং| ");
INSERT INTO sanasm_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","অপৰঞ্চ স দিৱা মন্দিৰ উপদিশ্য ৰাচৈ জৈতুনাদ্ৰিং গৎৱাতিষ্ঠৎ| ");
INSERT INTO sanasm_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ততঃ প্ৰত্যূষে লাকাস্তৎকথাং শ্ৰোতুং মন্দিৰে তদন্তিকম্ আগচ্ছন্| ");
INSERT INTO sanasm_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","অপৰঞ্চ কিণ্ৱশূন্যপূপোৎসৱস্য কাল উপস্থিতে ");
INSERT INTO sanasm_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","প্ৰধানযাজকা অধ্যাযকাশ্চ যথা তং হন্তুং শক্নুৱন্তি তথোপাযাম্ অচেষ্টন্ত কিন্তু লোকেভ্যো বিভ্যুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","এতস্তিন্ সমযে দ্ৱাদশশিষ্যেষু গণিত ঈষ্কৰিযোতীযৰূঢিমান্ যো যিহূদাস্তস্যান্তঃকৰণং শৈতানাশ্ৰিতৎৱাৎ ");
INSERT INTO sanasm_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","স গৎৱা যথা যীশুং তেষাং কৰেষু সমৰ্পযিতুং শক্নোতি তথা মন্ত্ৰণাং প্ৰধানযাজকৈঃ সেনাপতিভিশ্চ সহ চকাৰ| ");
INSERT INTO sanasm_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","তেন তে তুষ্টাস্তস্মৈ মুদ্ৰাং দাতুং পণং চক্ৰুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ততঃ সোঙ্গীকৃত্য যথা লোকানামগোচৰে তং পৰকৰেষু সমৰ্পযিতুং শক্নোতি তথাৱকাশং চেষ্টিতুমাৰেভে| ");
INSERT INTO sanasm_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","অথ কিণ্ৱশূন্যপূপোত্মৱদিনে, অৰ্থাৎ যস্মিন্ দিনে নিস্তাৰোৎসৱস্য মেষো হন্তৱ্যস্তস্মিন্ দিনে ");
INSERT INTO sanasm_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","যীশুঃ পিতৰং যোহনঞ্চাহূয জগাদ, যুৱাং গৎৱাস্মাকং ভোজনাৰ্থং নিস্তাৰোৎসৱস্য দ্ৰৱ্যাণ্যাসাদযতং| ");
INSERT INTO sanasm_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","তদা তৌ পপ্ৰচ্ছতুঃ কুচাসাদযাৱো ভৱতঃ কেচ্ছা? ");
INSERT INTO sanasm_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","তদা সোৱাদীৎ, নগৰে প্ৰৱিষ্টে কশ্চিজ্জলকুম্ভমাদায যুৱাং সাক্ষাৎ কৰিষ্যতি স যন্নিৱেশনং প্ৰৱিশতি যুৱামপি তন্নিৱেশনং তৎপশ্চাদিৎৱা নিৱেশনপতিম্ ইতি ৱাক্যং ৱদতং, ");
INSERT INTO sanasm_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","যত্ৰাহং নিস্তাৰোৎসৱস্য ভোজ্যং শিষ্যৈঃ সাৰ্দ্ধং ভোক্তুং শক্নোমি সাতিথিশালাा কুত্ৰ? কথামিমাং প্ৰভুস্ত্ৱাং পৃচ্ছতি| ");
INSERT INTO sanasm_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ততঃ স জনো দ্ৱিতীযপ্ৰকোষ্ঠীযম্ একং শস্তং কোষ্ঠং দৰ্শযিষ্যতি তত্ৰ ভোজ্যমাসাদযতং| ");
INSERT INTO sanasm_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ততস্তৌ গৎৱা তদ্ৱাক্যানুসাৰেণ সৰ্ৱ্ৱং দৃষ্দ্ৱা তত্ৰ নিস্তাৰোৎসৱীযং ভোজ্যমাসাদযামাসতুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","অথ কাল উপস্থিতে যীশু ৰ্দ্ৱাদশভিঃ প্ৰেৰিতৈঃ সহ ভোক্তুমুপৱিশ্য কথিতৱান্ ");
INSERT INTO sanasm_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","মম দুঃখভোগাৎ পূৰ্ৱ্ৱং যুভাভিঃ সহ নিস্তাৰোৎসৱস্যৈতস্য ভোজ্যং ভোক্তুং মযাতিৱাঞ্ছা কৃতা| ");
INSERT INTO sanasm_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","যুষ্মান্ ৱদামি, যাৱৎকালম্ ঈশ্ৱৰৰাজ্যে ভোজনং ন কৰিষ্যে তাৱৎকালম্ ইদং ন ভোক্ষ্যে| ");
INSERT INTO sanasm_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","তদা স পানপাত্ৰমাদায ঈশ্ৱৰস্য গুণান্ কীৰ্ত্তযিৎৱা তেভ্যো দৎৱাৱদৎ, ইদং গৃহ্লীত যূযং ৱিভজ্য পিৱত| ");
INSERT INTO sanasm_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","যুষ্মান্ ৱদামি যাৱৎকালম্ ঈশ্ৱৰৰাজৎৱস্য সংস্থাপনং ন ভৱতি তাৱদ্ দ্ৰাক্ষাফলৰসং ন পাস্যামি| ");
INSERT INTO sanasm_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ততঃ পূপং গৃহীৎৱা ঈশ্ৱৰগুণান্ কীৰ্ত্তযিৎৱা ভঙ্ক্তা তেভ্যো দৎৱাৱদৎ, যুষ্মদৰ্থং সমৰ্পিতং যন্মম ৱপুস্তদিদং, এতৎ কৰ্ম্ম মম স্মৰণাৰ্থং কুৰুধ্ৱং| ");
INSERT INTO sanasm_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","অথ ভোজনান্তে তাদৃশং পাত্ৰং গৃহীৎৱাৱদৎ, যুষ্মৎকৃতে পাতিতং যন্মম ৰক্তং তেন নিৰ্ণীতনৱনিযমৰূপং পানপাত্ৰমিদং| ");
INSERT INTO sanasm_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","পশ্যত যো মাং পৰকৰেষু সমৰ্পযিষ্যতি স মযা সহ ভোজনাসন উপৱিশতি| ");
INSERT INTO sanasm_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","যথা নিৰূপিতমাস্তে তদনুসাৰেণা মনুষ্যপুुত্ৰস্য গতি ৰ্ভৱিষ্যতি কিন্তু যস্তং পৰকৰেষু সমৰ্পযিষ্যতি তস্য সন্তাপো ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","তদা তেষাং কো জন এতৎ কৰ্ম্ম কৰিষ্যতি তৎ তে পৰস্পৰং প্ৰষ্টুমাৰেভিৰে| ");
INSERT INTO sanasm_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","অপৰং তেষাং কো জনঃ শ্ৰেষ্ঠৎৱেন গণযিষ্যতে, অত্ৰাৰ্থে তেষাং ৱিৱাদোভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","অস্মাৎ কাৰণাৎ সোৱদৎ, অন্যদেশীযানাং ৰাজানঃ প্ৰজানামুপৰি প্ৰভুৎৱং কুৰ্ৱ্ৱন্তি দাৰুণশাসনং কৃৎৱাপি তে ভূপতিৎৱেন ৱিখ্যাতা ভৱন্তি চ| ");
INSERT INTO sanasm_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","কিন্তু যুষ্মাকং তথা ন ভৱিষ্যতি, যো যুষ্মাকং শ্ৰেষ্ঠো ভৱিষ্যতি স কনিষ্ঠৱদ্ ভৱতু, যশ্চ মুখ্যো ভৱিষ্যতি স সেৱকৱদ্ভৱতু| ");
INSERT INTO sanasm_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","ভোজনোপৱিষ্টপৰিচাৰকযোঃ কঃ শ্ৰেষ্ঠঃ? যো ভোজনাযোপৱিশতি স কিং শ্ৰেষ্ঠো ন ভৱতি? কিন্তু যুষ্মাকং মধ্যেঽহং পৰিচাৰকইৱাস্মি| ");
INSERT INTO sanasm_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","অপৰঞ্চ যুযং মম পৰীক্ষাকালে প্ৰথমমাৰভ্য মযা সহ স্থিতা ");
INSERT INTO sanasm_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","এতৎকাৰণাৎ পিত্ৰা যথা মদৰ্থং ৰাজ্যমেকং নিৰূপিতং তথাহমপি যুষ্মদৰ্থং ৰাজ্যং নিৰূপযামি| ");
INSERT INTO sanasm_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","তস্মান্ মম ৰাজ্যে ভোজনাসনে চ ভোজনপানে কৰিষ্যধ্ৱে সিংহাসনেষূপৱিশ্য চেস্ৰাযেলীযানাং দ্ৱাদশৱংশানাং ৱিচাৰং কৰিষ্যধ্ৱে| ");
INSERT INTO sanasm_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","অপৰং প্ৰভুৰুৱাচ, হে শিমোন্ পশ্য তিতউনা ধান্যানীৱ যুষ্মান্ শৈতান্ চালযিতুম্ ঐচ্ছৎ, ");
INSERT INTO sanasm_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","কিন্তু তৱ ৱিশ্ৱাসস্য লোপো যথা ন ভৱতি এতৎ ৎৱদৰ্থং প্ৰাৰ্থিতং মযা, ৎৱন্মনসি পৰিৱৰ্ত্তিতে চ ভ্ৰাতৃণাং মনাংসি স্থিৰীকুৰু| ");
INSERT INTO sanasm_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","তদা সোৱদৎ, হে প্ৰভোহং ৎৱযা সাৰ্দ্ধং কাৰাং মৃতিঞ্চ যাতুং মজ্জিতোস্মি| ");
INSERT INTO sanasm_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ততঃ স উৱাচ, হে পিতৰ ৎৱাং ৱদামি, অদ্য কুক্কুটৰৱাৎ পূৰ্ৱ্ৱং ৎৱং মৎপৰিচযং ৱাৰত্ৰযম্ অপহ্ৱোষ্যসে| ");
INSERT INTO sanasm_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","অপৰং স পপ্ৰচ্ছ, যদা মুদ্ৰাসম্পুটং খাদ্যপাত্ৰং পাদুকাঞ্চ ৱিনা যুষ্মান্ প্ৰাহিণৱং তদা যুষ্মাকং কস্যাপি ন্যূনতাসীৎ? তে প্ৰোচুঃ কস্যাপি ন| ");
INSERT INTO sanasm_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","তদা সোৱদৎ কিন্ত্ৱিদানীং মুদ্ৰাসম্পুটং খাদ্যপাত্ৰং ৱা যস্যাস্তি তেন তদ্গ্ৰহীতৱ্যং, যস্য চ কৃপাণোे নাস্তি তেন স্ৱৱস্ত্ৰং ৱিক্ৰীয স ক্ৰেতৱ্যঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","যতো যুষ্মানহং ৱদামি, অপৰাধিজনৈঃ সাৰ্দ্ধং গণিতঃ স ভৱিষ্যতি| ইদং যচ্ছাস্ত্ৰীযং ৱচনং লিখিতমস্তি তন্মযি ফলিষ্যতি যতো মম সম্বন্ধীযং সৰ্ৱ্ৱং সেৎস্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","তদা তে প্ৰোচুঃ প্ৰভো পশ্য ইমৌ কৃপাণৌ| ততঃ সোৱদদ্ এতৌ যথেষ্টৌ| ");
INSERT INTO sanasm_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","অথ স তস্মাদ্ৱহি ৰ্গৎৱা স্ৱাচাৰানুসাৰেণ জৈতুননামাদ্ৰিং জগাম শিষ্যাশ্চ তৎপশ্চাদ্ যযুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","তত্ৰোপস্থায স তানুৱাচ, যথা পৰীক্ষাযাং ন পতথ তদৰ্থং প্ৰাৰ্থযধ্ৱং| ");
INSERT INTO sanasm_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","পশ্চাৎ স তস্মাদ্ একশৰক্ষেপাদ্ বহি ৰ্গৎৱা জানুনী পাতযিৎৱা এতৎ প্ৰাৰ্থযাঞ্চক্ৰে, ");
INSERT INTO sanasm_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","হে পিত ৰ্যদি ভৱান্ সম্মন্যতে তৰ্হি কংসমেনং মমান্তিকাদ্ দূৰয কিন্তু মদিচ্ছানুৰূপং ন ৎৱদিচ্ছানুৰূপং ভৱতু| ");
INSERT INTO sanasm_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","তদা তস্মৈ শক্তিং দাতুং স্ৱৰ্গীযদূতো দৰ্শনং দদৌ| ");
INSERT INTO sanasm_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","পশ্চাৎ সোত্যন্তং যাতনযা ৱ্যাকুলো ভূৎৱা পুনৰ্দৃঢং প্ৰাৰ্থযাঞ্চক্ৰে, তস্মাদ্ বৃহচ্ছোণিতবিন্দৱ ইৱ তস্য স্ৱেদবিন্দৱঃ পৃথিৱ্যাং পতিতুমাৰেভিৰে| ");
INSERT INTO sanasm_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","অথ প্ৰাৰ্থনাত উত্থায শিষ্যাণাং সমীপমেত্য তান্ মনোদুঃখিনো নিদ্ৰিতান্ দৃষ্ট্ৱাৱদৎ ");
INSERT INTO sanasm_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","কুতো নিদ্ৰাথ? পৰীক্ষাযাম্ অপতনাৰ্থং প্ৰৰ্থযধ্ৱং| ");
INSERT INTO sanasm_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","এতৎকথাযাঃ কথনকালে দ্ৱাদশশিষ্যাণাং মধ্যে গণিতো যিহূদানামা জনতাসহিতস্তেষাম্ অগ্ৰে চলিৎৱা যীশোশ্চুম্বনাৰ্থং তদন্তিকম্ আযযৌ| ");
INSERT INTO sanasm_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","তদা যীশুৰুৱাচ, হে যিহূদা কিং চুম্বনেন মনুষ্যপুত্ৰং পৰকৰেষু সমৰ্পযসি? ");
INSERT INTO sanasm_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","তদা যদ্যদ্ ঘটিষ্যতে তদনুমায সঙ্গিভিৰুক্তং, হে প্ৰভো ৱযং কি খঙ্গেন ঘাতযিষ্যামঃ? ");
INSERT INTO sanasm_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","তত একঃ কৰৱালেনাহত্য প্ৰধানযাজকস্য দাসস্য দক্ষিণং কৰ্ণং চিচ্ছেদ| ");
INSERT INTO sanasm_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","অধূনা নিৱৰ্ত্তস্ৱ ইত্যুক্ত্ৱা যীশুস্তস্য শ্ৰুতিং স্পৃষ্ট্ৱা স্ৱস্যং চকাৰ| ");
INSERT INTO sanasm_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","পশ্চাদ্ যীশুঃ সমীপস্থান্ প্ৰধানযাজকান্ মন্দিৰস্য সেনাপতীন্ প্ৰাচীনাংশ্চ জগাদ, যূযং কৃপাণান্ যষ্টীংশ্চ গৃহীৎৱা মাং কিং চোৰং ধৰ্ত্তুমাযাতাঃ? ");
INSERT INTO sanasm_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","যদাহং যুষ্মাভিঃ সহ প্ৰতিদিনং মন্দিৰেঽতিষ্ঠং তদা মাং ধৰ্ত্তং ন প্ৰৱৃত্তাঃ, কিন্ত্ৱিদানীং যুষ্মাকং সমযোন্ধকাৰস্য চাধিপত্যমস্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","অথ তে তং ধৃৎৱা মহাযাজকস্য নিৱেশনং নিন্যুঃ| ততঃ পিতৰো দূৰে দূৰে পশ্চাদিৎৱা ");
INSERT INTO sanasm_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","বৃহৎকোষ্ঠস্য মধ্যে যত্ৰাগ্নিং জ্ৱালযিৎৱা লোকাঃ সমেত্যোপৱিষ্টাস্তত্ৰ তৈঃ সাৰ্দ্ধম্ উপৱিৱেশ| ");
INSERT INTO sanasm_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","অথ ৱহ্নিসন্নিধৌ সমুপৱেশকালে কাচিদ্দাসী মনো নিৱিশ্য তং নিৰীক্ষ্যাৱদৎ পুমানযং তস্য সঙ্গেঽস্থাৎ| ");
INSERT INTO sanasm_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","কিন্তু স তদ্ অপহ্নুত্যাৱাদীৎ হে নাৰি তমহং ন পৰিচিনোমি| ");
INSERT INTO sanasm_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","ক্ষণান্তৰেঽন্যজনস্তং দৃষ্ট্ৱাব্ৰৱীৎ ৎৱমপি তেষাং নিকৰস্যৈকজনোসি| পিতৰঃ প্ৰত্যুৱাচ হে নৰ নাহমস্মি| ");
INSERT INTO sanasm_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ততঃ সাৰ্দ্ধদণ্ডদ্ৱযাৎ পৰং পুনৰন্যো জনো নিশ্চিত্য বভাষে, এষ তস্য সঙ্গীতি সত্যং যতোযং গালীলীযো লোকঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","তদা পিতৰ উৱাচ হে নৰ ৎৱং যদ্ ৱদমি তদহং বোদ্ধুং ন শক্নোমি, ইতি ৱাক্যে কথিতমাত্ৰে কুক্কুটো ৰুৰাৱ| ");
INSERT INTO sanasm_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","তদা প্ৰভুণা ৱ্যাধুট্য পিতৰে নিৰীক্ষিতে কৃকৱাকুৰৱাৎ পূৰ্ৱ্ৱং মাং ত্ৰিৰপহ্নোষ্যসে ইতি পূৰ্ৱ্ৱোক্তং তস্য ৱাক্যং পিতৰঃ স্মৃৎৱা ");
INSERT INTO sanasm_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","বহিৰ্গৎৱা মহাখেদেন চক্ৰন্দ| ");
INSERT INTO sanasm_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","তদা যৈ ৰ্যীশুৰ্ধৃতস্তে তমুপহস্য প্ৰহৰ্ত্তুমাৰেভিৰে| ");
INSERT INTO sanasm_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ৱস্ত্ৰেণ তস্য দৃশৌ বদ্ধ্ৱা কপোলে চপেটাঘাতং কৃৎৱা পপ্ৰচ্ছুঃ, কস্তে কপোলে চপেটাঘাতং কৃতৱান? গণযিৎৱা তদ্ ৱদ| ");
INSERT INTO sanasm_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","তদন্যৎ তদ্ৱিৰুদ্ধং বহুনিন্দাৱাক্যং ৱক্তুমাৰেভিৰে| ");
INSERT INTO sanasm_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","অথ প্ৰভাতে সতি লোকপ্ৰাঞ্চঃ প্ৰধানযাজকা অধ্যাপকাশ্চ সভাং কৃৎৱা মধ্যেসভং যীশুমানীয পপ্ৰচ্ছুঃ, ৎৱম্ অভিষিকতোসি ন ৱাস্মান্ ৱদ| ");
INSERT INTO sanasm_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","স প্ৰত্যুৱাচ, মযা তস্মিন্নুক্তেঽপি যূযং ন ৱিশ্ৱসিষ্যথ| ");
INSERT INTO sanasm_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","কস্মিংশ্চিদ্ৱাক্যে যুষ্মান্ পৃষ্টেঽপি মাং ন তদুত্তৰং ৱক্ষ্যথ ন মাং ত্যক্ষ্যথ চ| ");
INSERT INTO sanasm_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","কিন্ত্ৱিতঃ পৰং মনুজসুতঃ সৰ্ৱ্ৱশক্তিমত ঈশ্ৱৰস্য দক্ষিণে পাৰ্শ্ৱে সমুপৱেক্ষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ততস্তে পপ্ৰচ্ছুঃ, ৰ্তিহ ৎৱমীশ্ৱৰস্য পুত্ৰঃ? স কথযামাস, যূযং যথাৰ্থং ৱদথ স এৱাহং| ");
INSERT INTO sanasm_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","তদা তে সৰ্ৱ্ৱে কথযামাসুঃ, ৰ্তিহ সাক্ষ্যেঽন্সস্মিন্ অস্মাকং কিং প্ৰযোজনং? অস্য স্ৱমুখাদেৱ সাক্ষ্যং প্ৰাপ্তম্| ");
INSERT INTO sanasm_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ততঃ সভাস্থাঃ সৰ্ৱ্ৱলোকা উত্থায তং পীলাতসম্মুখং নীৎৱাপ্ৰোদ্য ৱক্তুমাৰেভিৰে, ");
INSERT INTO sanasm_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","স্ৱমভিষিক্তং ৰাজানং ৱদন্তং কৈমৰৰাজায কৰদানং নিষেধন্তং ৰাজ্যৱিপৰ্য্যযং কুৰ্ত্তুং প্ৰৱৰ্ত্তমানম্ এন প্ৰাপ্তা ৱযং| ");
INSERT INTO sanasm_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","তদা পীলাতস্তং পৃষ্টৱান্ ৎৱং কিং যিহূদীযানাং ৰাজা? স প্ৰত্যুৱাচ ৎৱং সত্যমুক্তৱান্| ");
INSERT INTO sanasm_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","তদা পীলাতঃ প্ৰধানযাজকাদিলোকান্ জগাদ্, অহমেতস্য কমপ্যপৰাধং নাপ্তৱান্| ");
INSERT INTO sanasm_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","ততস্তে পুনঃ সাহমিনো ভূৎৱাৱদন্, এষ গালীল এতৎস্থানপৰ্য্যন্তে সৰ্ৱ্ৱস্মিন্ যিহূদাদেশে সৰ্ৱ্ৱাল্লোকানুপদিশ্য কুপ্ৰৱৃত্তিং গ্ৰাহীতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","তদা পীলাতো গালীলপ্ৰদেশস্য নাম শ্ৰুৎৱা পপ্ৰচ্ছ, কিমযং গালীলীযো লোকঃ? ");
INSERT INTO sanasm_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ততঃ স গালীল্প্ৰদেশীযহেৰোদ্ৰাজস্য তদা স্থিতেস্তস্য সমীপে যীশুং প্ৰেষযামাস| ");
INSERT INTO sanasm_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","তদা হেৰোদ্ যীশুং ৱিলোক্য সন্তুতোষ, যতঃ স তস্য বহুৱৃত্তান্তশ্ৰৱণাৎ তস্য কিঞি्চদাশ্চৰ্য্যকৰ্ম্ম পশ্যতি ইত্যাশাং কৃৎৱা বহুকালমাৰভ্য তং দ্ৰষ্টুং প্ৰযাসং কৃতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","তস্মাৎ তং বহুকথাঃ পপ্ৰচ্ছ কিন্তু স তস্য কস্যাপি ৱাক্যস্য প্ৰত্যুত্তৰং নোৱাচ| ");
INSERT INTO sanasm_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","অথ প্ৰধানযাজকা অধ্যাপকাশ্চ প্ৰোত্তিষ্ঠন্তঃ সাহসেন তমপৱদিতুং প্ৰাৰেভিৰে| ");
INSERT INTO sanasm_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","হেৰোদ্ তস্য সেনাগণশ্চ তমৱজ্ঞায উপহাসৎৱেন ৰাজৱস্ত্ৰং পৰিধাপ্য পুনঃ পীলাতং প্ৰতি তং প্ৰাহিণোৎ| ");
INSERT INTO sanasm_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","পূৰ্ৱ্ৱং হেৰোদ্পীলাতযোঃ পৰস্পৰং ৱৈৰভাৱ আসীৎ কিন্তু তদ্দিনে দ্ৱযো ৰ্মেলনং জাতম্| ");
INSERT INTO sanasm_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","পশ্চাৎ পীলাতঃ প্ৰধানযাজকান্ শাসকান্ লোকাংশ্চ যুগপদাহূয বভাষে, ");
INSERT INTO sanasm_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ৰাজ্যৱিপৰ্য্যযকাৰকোযম্ ইত্যুক্ত্ৱা মনুষ্যমেনং মম নিকটমানৈষ্ট কিন্তু পশ্যত যুষ্মাকং সমক্ষম্ অস্য ৱিচাৰং কৃৎৱাপি প্ৰোক্তাপৱাদানুৰূপেণাস্য কোপ্যপৰাধঃ সপ্ৰমাণো ন জাতঃ, ");
INSERT INTO sanasm_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","যূযঞ্চ হেৰোদঃ সন্নিধৌ প্ৰেষিতা মযা তত্ৰাস্য কোপ্যপৰাধস্তেনাপি ন প্ৰাপ্তঃ| পশ্যতানেন ৱধহেेতুকং কিমপি নাপৰাদ্ধং| ");
INSERT INTO sanasm_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","তস্মাদেনং তাডযিৎৱা ৱিহাস্যামি| ");
INSERT INTO sanasm_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","তত্ৰোৎসৱে তেষামেকো মোচযিতৱ্যঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ইতি হেতোস্তে প্ৰোচ্চৈৰেকদা প্ৰোচুঃ, এনং দূৰীকৃত্য বৰব্বানামানং মোচয| ");
INSERT INTO sanasm_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","স বৰব্বা নগৰ উপপ্লৱৱধাপৰাধাভ্যাং কাৰাযাং বদ্ধ আসীৎ| ");
INSERT INTO sanasm_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","কিন্তু পীলাতো যীশুং মোচযিতুং ৱাঞ্ছন্ পুনস্তানুৱাচ| ");
INSERT INTO sanasm_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","তথাপ্যেনং ক্ৰুশে ৱ্যধ ক্ৰুশে ৱ্যধেতি ৱদন্তস্তে ৰুৰুৱুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ততঃ স তৃতীযৱাৰং জগাদ কুতঃ? স কিং কৰ্ম্ম কৃতৱান্? নাহমস্য কমপি ৱধাপৰাধং প্ৰাপ্তঃ কেৱলং তাডযিৎৱামুং ত্যজামি| ");
INSERT INTO sanasm_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","তথাপি তে পুনৰেনং ক্ৰুশে ৱ্যধ ইত্যুক্ত্ৱা প্ৰোচ্চৈৰ্দৃঢং প্ৰাৰ্থযাঞ্চক্ৰিৰে; ");
INSERT INTO sanasm_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ততঃ প্ৰধানযাজকাদীনাং কলৰৱে প্ৰবলে সতি তেষাং প্ৰাৰ্থনাৰূপং কৰ্ত্তুং পীলাত আদিদেশ| ");
INSERT INTO sanasm_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ৰাজদ্ৰোহৱধযোৰপৰাধেন কাৰাস্থং যং জনং তে যযাচিৰে তং মোচযিৎৱা যীশুং তেষামিচ্ছাযাং সমাৰ্পযৎ| ");
INSERT INTO sanasm_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","অথ তে যীশুং গৃহীৎৱা যান্তি, এতৰ্হি গ্ৰামাদাগতং শিমোননামানং কুৰীণীযং জনং ধৃৎৱা যীশোঃ পশ্চান্নেতুং তস্য স্কন্ধে ক্ৰুশমৰ্পযামাসুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ততো লোाকাৰণ্যমধ্যে বহুস্ত্ৰিযো ৰুদত্যো ৱিলপন্ত্যশ্চ যীশোঃ পশ্চাদ্ যযুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","কিন্তু স ৱ্যাঘুট্য তা উৱাচ, হে যিৰূশালমো নাৰ্য্যো যুযং মদৰ্থং ন ৰুদিৎৱা স্ৱাৰ্থং স্ৱাপত্যাৰ্থঞ্চ ৰুদিতি; ");
INSERT INTO sanasm_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","পশ্যত যঃ কদাপি গৰ্ভৱত্যো নাভৱন্ স্তন্যঞ্চ নাপাযযন্ তাদৃশী ৰ্ৱন্ধ্যা যদা ধন্যা ৱক্ষ্যন্তি স কাল আযাতি| ");
INSERT INTO sanasm_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","তদা হে শৈলা অস্মাকমুপৰি পতত, হে উপশৈলা অস্মানাচ্ছাদযত কথামীদৃশীং লোকা ৱক্ষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","যতঃ সতেজসি শাখিনি চেদেতদ্ ঘটতে তৰ্হি শুষ্কশাখিনি কিং ন ঘটিষ্যতে? ");
INSERT INTO sanasm_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","তদা তে হন্তুং দ্ৱাৱপৰাধিনৌ তেন সাৰ্দ্ধং নিন্যুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","অপৰং শিৰঃকপালনামকস্থানং প্ৰাপ্য তং ক্ৰুশে ৱিৱিধুঃ; তদ্দ্ৱযোৰপৰাধিনোৰেকং তস্য দক্ষিণো তদন্যং ৱামে ক্ৰুশে ৱিৱিধুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","তদা যীশুৰকথযৎ, হে পিতৰেতান্ ক্ষমস্ৱ যত এতে যৎ কৰ্ম্ম কুৰ্ৱ্ৱন্তি তন্ ন ৱিদুঃ; পশ্চাত্তে গুটিকাপাতং কৃৎৱা তস্য ৱস্ত্ৰাণি ৱিভজ্য জগৃহুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","তত্ৰ লোকসংঘস্তিষ্ঠন্ দদৰ্শ; তে তেষাং শাসকাশ্চ তমুপহস্য জগদুঃ, এষ ইতৰান্ ৰক্ষিতৱান্ যদীশ্ৱৰেণাভিৰুচিতো ঽভিষিক্তস্ত্ৰাতা ভৱতি তৰ্হি স্ৱমধুনা ৰক্ষতু| ");
INSERT INTO sanasm_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","তদন্যঃ সেনাগণা এত্য তস্মৈ অম্লৰসং দৎৱা পৰিহস্য প্ৰোৱাচ, ");
INSERT INTO sanasm_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","চেত্ত্ৱং যিহূদীযানাং ৰাজাসি তৰ্হি স্ৱং ৰক্ষ| ");
INSERT INTO sanasm_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","যিহূদীযানাং ৰাজেতি ৱাক্যং যূনানীযৰোমীযেব্ৰীযাক্ষৰৈ ৰ্লিখিতং তচ্ছিৰস ঊৰ্দ্ধ্ৱেঽস্থাপ্যত| ");
INSERT INTO sanasm_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","তদোভযপাৰ্শ্ৱযো ৰ্ৱিদ্ধৌ যাৱপৰাধিনৌ তযোৰেকস্তং ৱিনিন্দ্য বভাষে, চেত্ত্ৱম্ অভিষিক্তোসি তৰ্হি স্ৱমাৱাঞ্চ ৰক্ষ| ");
INSERT INTO sanasm_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","কিন্ত্ৱন্যস্তং তৰ্জযিৎৱাৱদৎ, ঈশ্ৱৰাত্তৱ কিঞ্চিদপি ভযং নাস্তি কিং? ৎৱমপি সমানদণ্ডোসি, ");
INSERT INTO sanasm_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","যোগ্যপাত্ৰে আৱাং স্ৱস্ৱকৰ্ম্মণাং সমুচিতফলং প্ৰাপ্নুৱঃ কিন্ত্ৱনেন কিমপি নাপৰাদ্ধং| ");
INSERT INTO sanasm_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","অথ স যীশুং জগাদ হে প্ৰভে ভৱান্ স্ৱৰাজ্যপ্ৰৱেশকালে মাং স্মৰতু| ");
INSERT INTO sanasm_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","তদা যীশুঃ কথিতৱান্ ৎৱাং যথাৰ্থং ৱদামি ৎৱমদ্যৈৱ মযা সাৰ্দ্ধং পৰলোকস্য সুখস্থানং প্ৰাপ্স্যসি| ");
INSERT INTO sanasm_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","অপৰঞ্চ দ্ৱিতীযযামাৎ তৃতীযযামপৰ্য্যন্তং ৰৱেস্তেজসোন্তৰ্হিতৎৱাৎ সৰ্ৱ্ৱদেশোঽন্ধকাৰেণাৱৃতো ");
INSERT INTO sanasm_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","মন্দিৰস্য যৱনিকা চ ছিদ্যমানা দ্ৱিধা বভূৱ| ");
INSERT INTO sanasm_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ততো যীশুৰুচ্চৈৰুৱাচ, হে পিত ৰ্মমাত্মানং তৱ কৰে সমৰ্পযে, ইত্যুক্ত্ৱা স প্ৰাণান্ জহৌ| ");
INSERT INTO sanasm_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","তদৈতা ঘটনা দৃষ্ট্ৱা শতসেনাপতিৰীশ্ৱৰং ধন্যমুক্ত্ৱা কথিতৱান্ অযং নিতান্তং সাধুমনুষ্য আসীৎ| ");
INSERT INTO sanasm_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","অথ যাৱন্তো লোকা দ্ৰষ্টুম্ আগতাস্তে তা ঘটনা দৃষ্ট্ৱা ৱক্ষঃসু কৰাঘাতং কৃৎৱা ৱ্যাচুট্য গতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","যীশো ৰ্জ্ঞাতযো যা যা যোষিতশ্চ গালীলস্তেন সাৰ্দ্ধমাযাতাস্তা অপি দূৰে স্থিৎৱা তৎ সৰ্ৱ্ৱং দদৃশুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","তদা যিহূদীযানাং মন্ত্ৰণাং ক্ৰিযাঞ্চাসম্মন্যমান ঈশ্ৱৰস্য ৰাজৎৱম্ অপেক্ষমাণো ");
INSERT INTO sanasm_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","যিহূদিদেশীযো ঽৰিমথীযনগৰীযো যূষফ্নামা মন্ত্ৰী ভদ্ৰো ধাৰ্ম্মিকশ্চ পুমান্ ");
INSERT INTO sanasm_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","পীলাতান্তিকং গৎৱা যীশো ৰ্দেহং যযাচে| ");
INSERT INTO sanasm_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","পশ্চাদ্ ৱপুৰৱৰোহ্য ৱাসসা সংৱেষ্ট্য যত্ৰ কোপি মানুষো নাস্থাপ্যত তস্মিন্ শৈলে স্ৱাতে শ্মশানে তদস্থাপযৎ| ");
INSERT INTO sanasm_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","তদ্দিনমাযোজনীযং দিনং ৱিশ্ৰামৱাৰশ্চ সমীপঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","অপৰং যীশুনা সাৰ্দ্ধং গালীল আগতা যোষিতঃ পশ্চাদিৎৱা শ্মশানে তত্ৰ যথা ৱপুঃ স্থাপিতং তচ্চ দৃষ্ট্ৱা ");
INSERT INTO sanasm_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ৱ্যাঘুট্য সুগন্ধিদ্ৰৱ্যতৈলানি কৃৎৱা ৱিধিৱদ্ ৱিশ্ৰামৱাৰে ৱিশ্ৰামং চক্ৰুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","অথ সপ্তাহপ্ৰথমদিনেঽতিপ্ৰত্যূষে তা যোষিতঃ সম্পাদিতং সুগন্ধিদ্ৰৱ্যং গৃহীৎৱা তদন্যাভিঃ কিযতীভিঃ স্ত্ৰীভিঃ সহ শ্মশানং যযুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","কিন্তু শ্মশানদ্ৱাৰাৎ পাষাণমপসাৰিতং দৃষ্ট্ৱা ");
INSERT INTO sanasm_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","তাঃ প্ৰৱিশ্য প্ৰভো ৰ্দেহমপ্ৰাপ্য ");
INSERT INTO sanasm_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ৱ্যাকুলা ভৱন্তি এতৰ্হি তেজোমযৱস্ত্ৰান্ৱিতৌ দ্ৱৌ পুৰুষৌ তাসাং সমীপে সমুপস্থিতৌ ");
INSERT INTO sanasm_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","তস্মাত্তাঃ শঙ্কাযুক্তা ভূমাৱধোমুখ্যস্যস্থুঃ| তদা তৌ তা ঊচতু ৰ্মৃতানাং মধ্যে জীৱন্তং কুতো মৃগযথ? ");
INSERT INTO sanasm_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","সোত্ৰ নাস্তি স উদস্থাৎ| ");
INSERT INTO sanasm_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","পাপিনাং কৰেষু সমৰ্পিতেন ক্ৰুশে হতেন চ মনুষ্যপুত্ৰেণ তৃতীযদিৱসে শ্মশানাদুত্থাতৱ্যম্ ইতি কথাং স গলীলি তিষ্ঠন্ যুষ্মভ্যং কথিতৱান্ তাং স্মৰত| ");
INSERT INTO sanasm_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","তদা তস্য সা কথা তাসাং মনঃসু জাতা| ");
INSERT INTO sanasm_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","অনন্তৰং শ্মশানাদ্ গৎৱা তা একাদশশিষ্যাদিভ্যঃ সৰ্ৱ্ৱেভ্যস্তাং ৱাৰ্ত্তাং কথযামাসুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","মগ্দলীনীমৰিযম্, যোহনা, যাকূবো মাতা মৰিযম্ তদন্যাঃ সঙ্গিন্যো যোষিতশ্চ প্ৰেৰিতেভ্য এতাঃ সৰ্ৱ্ৱা ৱাৰ্ত্তাঃ কথযামাসুঃ ");
INSERT INTO sanasm_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","কিন্তু তাসাং কথাম্ অনৰ্থকাখ্যানমাত্ৰং বুদ্ধ্ৱা কোপি ন প্ৰত্যৈৎ| ");
INSERT INTO sanasm_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","তদা পিতৰ উত্থায শ্মশানান্তিকং দধাৱ, তত্ৰ চ প্ৰহ্ৱো ভূৎৱা পাৰ্শ্ৱৈকস্থাপিতং কেৱলং ৱস্ত্ৰং দদৰ্শ; তস্মাদাশ্চৰ্য্যং মন্যমানো যদঘটত তন্মনসি ৱিচাৰযন্ প্ৰতস্থে| ");
INSERT INTO sanasm_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","তস্মিন্নেৱ দিনে দ্ৱৌ শিয্যৌ যিৰূশালমশ্চতুষ্ক্ৰোশান্তৰিতম্ ইম্মাযুগ্ৰামং গচ্ছন্তৌ ");
INSERT INTO sanasm_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","তাসাং ঘটনানাং কথামকথযতাং ");
INSERT INTO sanasm_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","তযোৰালাপৱিচাৰযোঃ কালে যীশুৰাগত্য তাভ্যাং সহ জগাম ");
INSERT INTO sanasm_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","কিন্তু যথা তৌ তং ন পৰিচিনুতস্তদৰ্থং তযো ৰ্দৃষ্টিঃ সংৰুদ্ধা| ");
INSERT INTO sanasm_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","স তৌ পৃষ্টৱান্ যুৱাং ৱিষণ্ণৌ কিং ৱিচাৰযন্তৌ গচ্ছথঃ? ");
INSERT INTO sanasm_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ততস্তযোঃ ক্লিযপানামা প্ৰত্যুৱাচ যিৰূশালমপুৰেঽধুনা যান্যঘটন্ত ৎৱং কেৱলৱিদেশী কিং তদ্ৱৃত্তান্তং ন জানাসি? ");
INSERT INTO sanasm_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","স পপ্ৰচ্ছ কা ঘটনাঃ? তদা তৌ ৱক্তুমাৰেভাতে যীশুনামা যো নাসৰতীযো ভৱিষ্যদ্ৱাদী ঈশ্ৱৰস্য মানুষাণাঞ্চ সাক্ষাৎ ৱাক্যে কৰ্ম্মণি চ শক্তিমানাসীৎ ");
INSERT INTO sanasm_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","তম্ অস্মাকং প্ৰধানযাজকা ৱিচাৰকাশ্চ কেনাপি প্ৰকাৰেণ ক্ৰুশে ৱিদ্ধ্ৱা তস্য প্ৰাণাননাশযন্ তদীযা ঘটনাঃ; ");
INSERT INTO sanasm_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","কিন্তু য ইস্ৰাযেলীযলোকান্ উদ্ধাৰযিষ্যতি স এৱাযম্ ইত্যাশাস্মাভিঃ কৃতা| তদ্যথা তথাস্তু তস্যা ঘটনাযা অদ্য দিনত্ৰযং গতং| ");
INSERT INTO sanasm_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","অধিকন্ত্ৱস্মাকং সঙ্গিনীনাং কিযৎস্ত্ৰীণাং মুখেভ্যোঽসম্ভৱৱাক্যমিদং শ্ৰুতং; ");
INSERT INTO sanasm_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","তাঃ প্ৰত্যূষে শ্মশানং গৎৱা তত্ৰ তস্য দেহম্ অপ্ৰাপ্য ৱ্যাঘুট্যেৎৱা প্ৰোক্তৱত্যঃ স্ৱৰ্গীসদূতৌ দৃষ্টাৱস্মাভিস্তৌ চাৱাদিষ্টাং স জীৱিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ততোস্মাকং কৈশ্চিৎ শ্মশানমগম্যত তেঽপি স্ত্ৰীণাং ৱাক্যানুৰূপং দৃষ্টৱন্তঃ কিন্তু তং নাপশ্যন্| ");
INSERT INTO sanasm_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","তদা স তাৱুৱাচ, হে অবোধৌ হে ভৱিষ্যদ্ৱাদিভিৰুক্তৱাক্যং প্ৰত্যেতুং ৱিলম্বমানৌ; ");
INSERT INTO sanasm_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","এতৎসৰ্ৱ্ৱদুঃখং ভুক্ত্ৱা স্ৱভূতিপ্ৰাপ্তিঃ কিং খ্ৰীষ্টস্য ন ন্যায্যা? ");
INSERT INTO sanasm_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ততঃ স মূসাগ্ৰন্থমাৰভ্য সৰ্ৱ্ৱভৱিষ্যদ্ৱাদিনাং সৰ্ৱ্ৱশাস্ত্ৰে স্ৱস্মিন্ লিখিতাখ্যানাভিপ্ৰাযং বোধযামাস| ");
INSERT INTO sanasm_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","অথ গম্যগ্ৰামাভ্যৰ্ণং প্ৰাপ্য তেনাগ্ৰে গমনলক্ষণে দৰ্শিতে ");
INSERT INTO sanasm_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","তৌ সাধযিৎৱাৱদতাং সহাৱাভ্যাং তিষ্ঠ দিনে গতে সতি ৰাত্ৰিৰভূৎ; ততঃ স তাভ্যাং সাৰ্দ্ধং স্থাতুং গৃহং যযৌ| ");
INSERT INTO sanasm_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","পশ্চাদ্ভোজনোপৱেশকালে স পূপং গৃহীৎৱা ঈশ্ৱৰগুণান্ জগাদ তঞ্চ ভংক্ত্ৱা তাভ্যাং দদৌ| ");
INSERT INTO sanasm_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","তদা তযো ৰ্দৃষ্টৌ প্ৰসন্নাযাং তং প্ৰত্যভিজ্ঞতুঃ কিন্তু স তযোঃ সাক্ষাদন্তৰ্দধে| ");
INSERT INTO sanasm_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ততস্তৌ মিথোভিধাতুম্ আৰব্ধৱন্তৌ গমনকালে যদা কথামকথযৎ শাস্ত্ৰাৰ্থঞ্চবোধযৎ তদাৱযো ৰ্বুদ্ধিঃ কিং ন প্ৰাজ্ৱলৎ? ");
INSERT INTO sanasm_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","তৌ তৎক্ষণাদুত্থায যিৰূশালমপুৰং প্ৰত্যাযযতুঃ, তৎস্থানে শিষ্যাণাম্ একাদশানাং সঙ্গিনাঞ্চ দৰ্শনং জাতং| ");
INSERT INTO sanasm_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","তে প্ৰোচুঃ প্ৰভুৰুদতিষ্ঠদ্ ইতি সত্যং শিমোনে দৰ্শনমদাচ্চ| ");
INSERT INTO sanasm_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","ততঃ পথঃ সৰ্ৱ্ৱঘটনাযাঃ পূপভঞ্জনেন তৎপৰিচযস্য চ সৰ্ৱ্ৱৱৃত্তান্তং তৌ ৱক্তুমাৰেভাতে| ");
INSERT INTO sanasm_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ইত্থং তে পৰস্পৰং ৱদন্তি তৎকালে যীশুঃ স্ৱযং তেষাং মধ্য প্ৰোত্থয যুষ্মাকং কল্যাণং ভূযাদ্ ইত্যুৱাচ, ");
INSERT INTO sanasm_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","কিন্তু ভূতং পশ্যাম ইত্যনুমায তে সমুদ্ৱিৱিজিৰে ত্ৰেষুশ্চ| ");
INSERT INTO sanasm_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","স উৱাচ, কুতো দুঃখিতা ভৱথ? যুষ্মাকং মনঃসু সন্দেহ উদেতি চ কুতঃ? ");
INSERT INTO sanasm_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","এষোহং, মম কৰৌ পশ্যত ৱৰং স্পৃষ্ট্ৱা পশ্যত, মম যাদৃশানি পশ্যথ তাদৃশানি ভূতস্য মাংসাস্থীনি ন সন্তি| ");
INSERT INTO sanasm_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ইত্যুক্ত্ৱা স হস্তপাদান্ দৰ্শযামাস| ");
INSERT INTO sanasm_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","তেঽসম্ভৱং জ্ঞাৎৱা সানন্দা ন প্ৰত্যযন্| ততঃ স তান্ পপ্ৰচ্ছ, অত্ৰ যুষ্মাকং সমীপে খাদ্যং কিঞ্চিদস্তি? ");
INSERT INTO sanasm_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ততস্তে কিযদ্দগ্ধমৎস্যং মধু চ দদুঃ ");
INSERT INTO sanasm_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","স তদাদায তেষাং সাক্ষাদ্ বুভুজে ");
INSERT INTO sanasm_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","কথযামাস চ মূসাৱ্যৱস্থাযাং ভৱিষ্যদ্ৱাদিনাং গ্ৰন্থেষু গীতপুস্তকে চ মযি যানি সৰ্ৱ্ৱাণি ৱচনানি লিখিতানি তদনুৰূপাণি ঘটিষ্যন্তে যুষ্মাভিঃ সাৰ্দ্ধং স্থিৎৱাহং যদেতদ্ৱাক্যম্ অৱদং তদিদানীং প্ৰত্যক্ষমভূৎ| ");
INSERT INTO sanasm_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","অথ তেভ্যঃ শাস্ত্ৰবোধাধিকাৰং দৎৱাৱদৎ, ");
INSERT INTO sanasm_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","খ্ৰীষ্টেনেত্থং মৃতিযাতনা ভোক্তৱ্যা তৃতীযদিনে চ শ্মশানাদুত্থাতৱ্যঞ্চেতি লিপিৰস্তি; ");
INSERT INTO sanasm_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","তন্নাম্না যিৰূশালমমাৰভ্য সৰ্ৱ্ৱদেশে মনঃপৰাৱৰ্ত্তনস্য পাপমোচনস্য চ সুসংৱাদঃ প্ৰচাৰযিতৱ্যঃ, ");
INSERT INTO sanasm_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","এষু সৰ্ৱ্ৱেষু যূযং সাক্ষিণঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","অপৰঞ্চ পশ্যত পিত্ৰা যৎ প্ৰতিজ্ঞাতং তৎ প্ৰেষযিষ্যামি, অতএৱ যাৱৎকালং যূযং স্ৱৰ্গীযাং শক্তিং ন প্ৰাপ্স্যথ তাৱৎকালং যিৰূশালম্নগৰে তিষ্ঠত| ");
INSERT INTO sanasm_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","অথ স তান্ বৈথনীযাপৰ্য্যন্তং নীৎৱা হস্তাৱুত্তোল্য আশিষ ৱক্তুমাৰেভে ");
INSERT INTO sanasm_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","আশিষং ৱদন্নেৱ চ তেভ্যঃ পৃথগ্ ভূৎৱা স্ৱৰ্গায নীতোঽভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","তদা তে তং ভজমানা মহানন্দেন যিৰূশালমং প্ৰত্যাজগ্মুঃ| ");
INSERT INTO sanasm_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ততো নিৰন্তৰং মন্দিৰে তিষ্ঠন্ত ঈশ্ৱৰস্য প্ৰশংসাং ধন্যৱাদঞ্চ কৰ্ত্তম্ আৰেভিৰে| ইতি||");
INSERT INTO sanasm_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","আদৌ ৱাদ আসীৎ স চ ৱাদ ঈশ্ৱৰেণ সাৰ্ধমাসীৎ স ৱাদঃ স্ৱযমীশ্ৱৰ এৱ| ");
INSERT INTO sanasm_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","স আদাৱীশ্ৱৰেণ সহাসীৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","তেন সৰ্ৱ্ৱং ৱস্তু সসৃজে সৰ্ৱ্ৱেষু সৃষ্টৱস্তুষু কিমপি ৱস্তু তেনাসৃষ্টং নাস্তি| ");
INSERT INTO sanasm_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","স জীৱনস্যাকাৰঃ, তচ্চ জীৱনং মনুষ্যাণাং জ্যোতিঃ ");
INSERT INTO sanasm_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","তজ্জ্যোতিৰন্ধকাৰে প্ৰচকাশে কিন্ত্ৱন্ধকাৰস্তন্ন জগ্ৰাহ| ");
INSERT INTO sanasm_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","যোহন্ নামক একো মনুজ ঈশ্ৱৰেণ প্ৰেষযাঞ্চক্ৰে| ");
INSERT INTO sanasm_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","তদ্ৱাৰা যথা সৰ্ৱ্ৱে ৱিশ্ৱসন্তি তদৰ্থং স তজ্জ্যোতিষি প্ৰমাণং দাতুং সাক্ষিস্ৱৰূপো ভূৎৱাগমৎ, ");
INSERT INTO sanasm_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","স স্ৱযং তজ্জ্যোতি ৰ্ন কিন্তু তজ্জ্যোতিষি প্ৰমাণং দাতুমাগমৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","জগত্যাগত্য যঃ সৰ্ৱ্ৱমনুজেভ্যো দীপ্তিং দদাতি তদেৱ সত্যজ্যোতিঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","স যজ্জগদসৃজৎ তন্মদ্য এৱ স আসীৎ কিন্তু জগতো লোকাস্তং নাজানন্| ");
INSERT INTO sanasm_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","নিজাধিকাৰং স আগচ্ছৎ কিন্তু প্ৰজাস্তং নাগৃহ্লন্| ");
INSERT INTO sanasm_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","তথাপি যে যে তমগৃহ্লন্ অৰ্থাৎ তস্য নাম্নি ৱ্যশ্ৱসন্ তেভ্য ঈশ্ৱৰস্য পুত্ৰা ভৱিতুম্ অধিকাৰম্ অদদাৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","তেষাং জনিঃ শোণিতান্ন শাৰীৰিকাভিলাষান্ন মানৱানামিচ্ছাতো ন কিন্ত্ৱীশ্ৱৰাদভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","স ৱাদো মনুষ্যৰূপেণাৱতীৰ্য্য সত্যতানুগ্ৰহাভ্যাং পৰিপূৰ্ণঃ সন্ সাৰ্ধম্ অস্মাভি ৰ্ন্যৱসৎ ততঃ পিতুৰদ্ৱিতীযপুত্ৰস্য যোগ্যো যো মহিমা তং মহিমানং তস্যাপশ্যাম| ");
INSERT INTO sanasm_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ততো যোহনপি প্ৰচাৰ্য্য সাক্ষ্যমিদং দত্তৱান্ যো মম পশ্চাদ্ আগমিষ্যতি স মত্তো গুৰুতৰঃ; যতো মৎপূৰ্ৱ্ৱং স ৱিদ্যমান আসীৎ; যদৰ্থম্ অহং সাক্ষ্যমিদম্ অদাং স এষঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","অপৰঞ্চ তস্য পূৰ্ণতাযা ৱযং সৰ্ৱ্ৱে ক্ৰমশঃ ক্ৰমশোনুগ্ৰহং প্ৰাপ্তাঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","মূসাদ্ৱাৰা ৱ্যৱস্থা দত্তা কিন্ত্ৱনুগ্ৰহঃ সত্যৎৱঞ্চ যীশুখ্ৰীষ্টদ্ৱাৰা সমুপাতিষ্ঠতাং| ");
INSERT INTO sanasm_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","কোপি মনুজ ঈশ্ৱৰং কদাপি নাপশ্যৎ কিন্তু পিতুঃ ক্ৰোডস্থোঽদ্ৱিতীযঃ পুত্ৰস্তং প্ৰকাশযৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","ৎৱং কঃ? ইতি ৱাক্যং প্ৰেষ্টুং যদা যিহূদীযলোকা যাজকান্ লেৱিলোকাংশ্চ যিৰূশালমো যোহনঃ সমীপে প্ৰেষযামাসুঃ, ");
INSERT INTO sanasm_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","তদা স স্ৱীকৃতৱান্ নাপহ্নূতৱান্ নাহম্ অভিষিক্ত ইত্যঙ্গীকৃতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","তদা তেঽপৃচ্ছন্ তৰ্হি কো ভৱান্? কিং এলিযঃ? সোৱদৎ ন; ততস্তেঽপৃচ্ছন্ তৰ্হি ভৱান্ স ভৱিষ্যদ্ৱাদী? সোৱদৎ নাহং সঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","তদা তেঽপৃচ্ছন্ তৰ্হি ভৱান্ কঃ? ৱযং গৎৱা প্ৰেৰকান্ ৎৱযি কিং ৱক্ষ্যামঃ? স্ৱস্মিন্ কিং ৱদসি? ");
INSERT INTO sanasm_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","তদা সোৱদৎ| পৰমেশস্য পন্থানং পৰিষ্কুৰুত সৰ্ৱ্ৱতঃ| ইতীদং প্ৰান্তৰে ৱাক্যং ৱদতঃ কস্যচিদ্ৰৱঃ| কথামিমাং যস্মিন্ যিশযিযো ভৱিষ্যদ্ৱাদী লিখিতৱান্ সোহম্| ");
INSERT INTO sanasm_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","যে প্ৰেষিতাস্তে ফিৰূশিলোকাঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","তদা তেঽপৃচ্ছন্ যদি নাভিষিক্তোসি এলিযোসি ন স ভৱিষ্যদ্ৱাদ্যপি নাসি চ, তৰ্হি লোকান্ মজ্জযসি কুতঃ? ");
INSERT INTO sanasm_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ততো যোহন্ প্ৰত্যৱোচৎ, তোযেঽহং মজ্জযামীতি সত্যং কিন্তু যং যূযং ন জানীথ তাদৃশ একো জনো যুষ্মাকং মধ্য উপতিষ্ঠতি| ");
INSERT INTO sanasm_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","স মৎপশ্চাদ্ আগতোপি মৎপূৰ্ৱ্ৱং ৱৰ্ত্তমান আসীৎ তস্য পাদুকাবন্ধনং মোচযিতুমপি নাহং যোগ্যোস্মি| ");
INSERT INTO sanasm_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","যৰ্দ্দননদ্যাঃ পাৰস্থবৈথবাৰাযাং যস্মিন্স্থানে যোহনমজ্জযৎ তস্মিন স্থানে সৰ্ৱ্ৱমেতদ্ অঘটত| ");
INSERT INTO sanasm_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","পৰেঽহনি যোহন্ স্ৱনিকটমাগচ্ছন্তং যিশুং ৱিলোক্য প্ৰাৱোচৎ জগতঃ পাপমোচকম্ ঈশ্ৱৰস্য মেষশাৱকং পশ্যত| ");
INSERT INTO sanasm_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","যো মম পশ্চাদাগমিষ্যতি স মত্তো গুৰুতৰঃ, যতো হেতোৰ্মৎপূৰ্ৱ্ৱং সোঽৱৰ্ত্তত যস্মিন্নহং কথামিমাং কথিতৱান্ স এৱাযং| ");
INSERT INTO sanasm_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","অপৰং নাহমেনং প্ৰত্যভিজ্ঞাতৱান্ কিন্তু ইস্ৰাযেল্লোকা এনং যথা পৰিচিন্ৱন্তি তদভিপ্ৰাযেণাহং জলে মজ্জযিতুমাগচ্ছম্| ");
INSERT INTO sanasm_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","পুনশ্চ যোহনপৰমেকং প্ৰমাণং দৎৱা কথিতৱান্ ৱিহাযসঃ কপোতৱদ্ অৱতৰন্তমাত্মানম্ অস্যোপৰ্য্যৱতিষ্ঠন্তং চ দৃষ্টৱানহম্| ");
INSERT INTO sanasm_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","নাহমেনং প্ৰত্যভিজ্ঞাতৱান্ ইতি সত্যং কিন্তু যো জলে মজ্জযিতুং মাং প্ৰৈৰযৎ স এৱেমাং কথামকথযৎ যস্যোপৰ্য্যাত্মানম্ অৱতৰন্তম্ অৱতিষ্ঠন্তঞ্চ দ্ৰক্ষযসি সএৱ পৱিত্ৰে আত্মনি মজ্জযিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","অৱস্তন্নিৰীক্ষ্যাযম্ ঈশ্ৱৰস্য তনয ইতি প্ৰমাণং দদামি| ");
INSERT INTO sanasm_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","পৰেঽহনি যোহন্ দ্ৱাভ্যাং শিষ্যাভ্যাং সাৰ্দ্ধেং তিষ্ঠন্ ");
INSERT INTO sanasm_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","যিশুং গচ্ছন্তং ৱিলোক্য গদিতৱান্, ঈশ্ৱৰস্য মেষশাৱকং পশ্যতং| ");
INSERT INTO sanasm_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ইমাং কথাং শ্ৰুৎৱা দ্ৱৌ শিষ্যৌ যীশোঃ পশ্চাদ্ ঈযতুঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ততো যীশুঃ পৰাৱৃত্য তৌ পশ্চাদ্ আগচ্ছন্তৌ দৃষ্ট্ৱা পৃষ্টৱান্ যুৱাং কিং গৱেশযথঃ? তাৱপৃচ্ছতাং হে ৰব্বি অৰ্থাৎ হে গুৰো ভৱান্ কুত্ৰ তিষ্ঠতি? ");
INSERT INTO sanasm_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ততঃ সোৱাদিৎ এত্য পশ্যতং| ততো দিৱসস্য তৃতীযপ্ৰহৰস্য গতৎৱাৎ তৌ তদ্দিনং তস্য সঙ্গেঽস্থাতাং| ");
INSERT INTO sanasm_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","যৌ দ্ৱৌ যোহনো ৱাক্যং শ্ৰুৎৱা যিশোঃ পশ্চাদ্ আগমতাং তযোঃ শিমোন্পিতৰস্য ভ্ৰাতা আন্দ্ৰিযঃ ");
INSERT INTO sanasm_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","স ইৎৱা প্ৰথমং নিজসোদৰং শিমোনং সাক্ষাৎপ্ৰাপ্য কথিতৱান্ ৱযং খ্ৰীষ্টম্ অৰ্থাৎ অভিষিক্তপুৰুষং সাক্ষাৎকৃতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","পশ্চাৎ স তং যিশোঃ সমীপম্ আনযৎ| তদা যীশুস্তং দৃষ্ট্ৱাৱদৎ ৎৱং যূনসঃ পুত্ৰঃ শিমোন্ কিন্তু ৎৱন্নামধেযং কৈফাঃ ৱা পিতৰঃ অৰ্থাৎ প্ৰস্তৰো ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","পৰেঽহনি যীশৌ গালীলং গন্তুং নিশ্চিতচেতসি সতি ফিলিপনামানং জনং সাক্ষাৎপ্ৰাপ্যাৱোচৎ মম পশ্চাদ্ আগচ্ছ| ");
INSERT INTO sanasm_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","বৈৎসৈদানাম্নি যস্মিন্ গ্ৰামে পিতৰান্দ্ৰিযযোৰ্ৱাস আসীৎ তস্মিন্ গ্ৰামে তস্য ফিলিপস্য ৱসতিৰাসীৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","পশ্চাৎ ফিলিপো নিথনেলং সাক্ষাৎপ্ৰাপ্যাৱদৎ মূসা ৱ্যৱস্থা গ্ৰন্থে ভৱিষ্যদ্ৱাদিনাং গ্ৰন্থেষু চ যস্যাখ্যানং লিখিতমাস্তে তং যূষফঃ পুত্ৰং নাসৰতীযং যীশুং সাক্ষাদ্ অকাৰ্ষ্ম ৱযং| ");
INSERT INTO sanasm_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","তদা নিথনেল্ কথিতৱান্ নাসৰন্নগৰাত কিং কশ্চিদুত্তম উৎপন্তুং শক্নোতি? ততঃ ফিলিপো ঽৱোচৎ এত্য পশ্য| ");
INSERT INTO sanasm_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","অপৰঞ্চ যীশুঃ স্ৱস্য সমীপং তম্ আগচ্ছন্তং দৃষ্ট্ৱা ৱ্যাহৃতৱান্, পশ্যাযং নিষ্কপটঃ সত্য ইস্ৰাযেল্লোকঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","ততঃ সোৱদদ্, ভৱান্ মাং কথং প্ৰত্যভিজানাতি? যীশুৰৱাদীৎ ফিলিপস্য আহ্ৱানাৎ পূৰ্ৱ্ৱং যদা ৎৱমুডুম্বৰস্য তৰোৰ্মূলেঽস্থাস্তদা ৎৱামদৰ্শম্| ");
INSERT INTO sanasm_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","নিথনেল্ অচকথৎ, হে গুৰো ভৱান্ নিতান্তম্ ঈশ্ৱৰস্য পুত্ৰোসি, ভৱান্ ইস্ৰাযেল্ৱংশস্য ৰাজা| ");
INSERT INTO sanasm_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ততো যীশু ৰ্ৱ্যাহৰৎ, ৎৱামুডুম্বৰস্য পাদপস্য মূলে দৃষ্টৱানাহং মমৈতস্মাদ্ৱাক্যাৎ কিং ৎৱং ৱ্যশ্ৱসীঃ? এতস্মাদপ্যাশ্চৰ্য্যাণি কাৰ্য্যাণি দ্ৰক্ষ্যসি| ");
INSERT INTO sanasm_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","অন্যচ্চাৱাদীদ্ যুষ্মানহং যথাৰ্থং ৱদামি, ইতঃ পৰং মোচিতে মেঘদ্ৱাৰে তস্মান্মনুজসূনুনা ঈশ্ৱৰস্য দূতগণম্ অৱৰোহন্তমাৰোহন্তঞ্চ দ্ৰক্ষ্যথ| ");
INSERT INTO sanasm_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","অনন্তৰং ত্ৰুতীযদিৱসে গালীল্ প্ৰদেশিযে কান্নানাম্নি নগৰে ৱিৱাহ আসীৎ তত্ৰ চ যীশোৰ্মাতা তিষ্ঠৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","তস্মৈ ৱিৱাহায যীশুস্তস্য শিষ্যাশ্চ নিমন্ত্ৰিতা আসন্| ");
INSERT INTO sanasm_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","তদনন্তৰং দ্ৰাক্ষাৰসস্য ন্যূনৎৱাদ্ যীশোৰ্মাতা তমৱদৎ এতেষাং দ্ৰাক্ষাৰসো নাস্তি| ");
INSERT INTO sanasm_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","তদা স তামৱোচৎ হে নাৰি মযা সহ তৱ কিং কাৰ্য্যং? মম সময ইদানীং নোপতিষ্ঠতি| ");
INSERT INTO sanasm_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","ততস্তস্য মাতা দাসানৱোচদ্ অযং যদ্ ৱদতি তদেৱ কুৰুত| ");
INSERT INTO sanasm_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","তস্মিন্ স্থানে যিহূদীযানাং শুচিৎৱকৰণৱ্যৱহাৰানুসাৰেণাঢকৈকজলধৰাণি পাষাণমযানি ষড্ৱৃহৎপাত্ৰাণিআসন্| ");
INSERT INTO sanasm_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","তদা যীশুস্তান্ সৰ্ৱ্ৱকলশান্ জলৈঃ পূৰযিতুং তানাজ্ঞাপযৎ, ততস্তে সৰ্ৱ্ৱান্ কুম্ভানাকৰ্ণং জলৈঃ পৰ্য্যপূৰযন্| ");
INSERT INTO sanasm_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","অথ তেভ্যঃ কিঞ্চিদুত্তাৰ্য্য ভোজ্যাধিপাতেঃসমীপং নেতুং স তানাদিশৎ, তে তদনযন্| ");
INSERT INTO sanasm_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","অপৰঞ্চ তজ্জলং কথং দ্ৰাক্ষাৰসোঽভৱৎ তজ্জলৱাহকাদাসা জ্ঞাতুং শক্তাঃ কিন্তু তদ্ভোজ্যাধিপো জ্ঞাতুং নাশক্নোৎ তদৱলিহ্য ৱৰং সংম্বোদ্যাৱদত, ");
INSERT INTO sanasm_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","লোকাঃ প্ৰথমং উত্তমদ্ৰাক্ষাৰসং দদতি তষু যথেষ্টং পিতৱৎসু তস্মা কিঞ্চিদনুত্তমঞ্চ দদতি কিন্তু ৎৱমিদানীং যাৱৎ উত্তমদ্ৰাক্ষাৰসং স্থাপযসি| ");
INSERT INTO sanasm_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ইত্থং যীশুৰ্গালীলপ্ৰদেশে আশ্চৰ্য্যকাৰ্ম্ম প্ৰাৰম্ভ নিজমহিমানং প্ৰাকাশযৎ ততঃ শিষ্যাস্তস্মিন্ ৱ্যশ্ৱসন্| ");
INSERT INTO sanasm_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ততঃ পৰম্ স নিজমাত্ৰুভ্ৰাত্ৰুস্শিষ্যৈঃ সাৰ্দ্ধ্ং কফৰ্নাহূমম্ আগমৎ কিন্তু তত্ৰ বহূদিনানি আতিষ্ঠৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","তদনন্তৰং যিহূদিযানাং নিস্তাৰোৎসৱে নিকটমাগতে যীশু ৰ্যিৰূশালম্ নগৰম্ আগচ্ছৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ততো মন্দিৰস্য মধ্যে গোমেষপাৰাৱতৱিক্ৰযিণো ৱাণিজক্ষ্চোপৱিষ্টান্ ৱিলোক্য ");
INSERT INTO sanasm_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ৰজ্জুভিঃ কশাং নিৰ্ম্মায সৰ্ৱ্ৱগোমেষাদিভিঃ সাৰ্দ্ধং তান্ মন্দিৰাদ্ দূৰীকৃতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ৱণিজাং মুদ্ৰাদি ৱিকীৰ্য্য আসনানি ন্যূব্জীকৃত্য পাৰাৱতৱিক্ৰযিভ্যোঽকথযদ্ অস্মাৎ স্থানাৎ সৰ্ৱাণ্যেতানি নযত, মম পিতুগৃহং ৱাণিজ্যগৃহং মা কাৰ্ষ্ট| ");
INSERT INTO sanasm_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","তস্মাৎ তন্মন্দিৰাৰ্থ উদ্যোগো যস্তু স গ্ৰসতীৱ মাম্| ইমাং শাস্ত্ৰীযলিপিং শিষ্যাঃসমস্মৰন্| ");
INSERT INTO sanasm_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ততঃ পৰম্ যিহূদীযলোকা যীষিমৱদন্ তৱমিদৃশকৰ্ম্মকৰণাৎ কিং চিহ্নমস্মান্ দৰ্শযসি? ");
INSERT INTO sanasm_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ততো যীশুস্তানৱোচদ্ যুষ্মাভিৰে তস্মিন্ মন্দিৰে নাশিতে দিনত্ৰযমধ্যেঽহং তদ্ উত্থাপযিষ্যামি| ");
INSERT INTO sanasm_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","তদা যিহূদিযা ৱ্যাহাৰ্ষুঃ, এতস্য মন্দিৰস নিৰ্ম্মাণেন ষট্চৎৱাৰিংশদ্ ৱৎসৰা গতাঃ, ৎৱং কিং দিনত্ৰযমধ্যে তদ্ উত্থাপযিষ্যসি? ");
INSERT INTO sanasm_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","কিন্তু স নিজদেহৰূপমন্দিৰে কথামিমাং কথিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","স যদেতাদৃশং গদিতৱান্ তচ্ছিষ্যাঃ শ্মশানাৎ তদীযোত্থানে সতি স্মৃৎৱা ধৰ্ম্মগ্ৰন্থে যীশুনোক্তকথাযাং চ ৱ্যশ্ৱসিষুঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","অনন্তৰং নিস্তাৰোৎসৱস্য ভোজ্যসমযে যিৰূশালম্ নগৰে তৎক্ৰুতাশ্চৰ্য্যকৰ্ম্মাণি ৱিলোক্য বহুভিস্তস্য নামনি ৱিশ্ৱসিতং| ");
INSERT INTO sanasm_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","কিন্তু স তেষাং কৰেষু স্ৱং ন সমৰ্পযৎ, যতঃ স সৰ্ৱ্ৱানৱৈৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","স মানৱেষু কস্যচিৎ প্ৰমাণং নাপেক্ষত যতো মনুজানাং মধ্যে যদ্যদস্তি তত্তৎ সোজানাৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","নিকদিমনামা যিহূদীযানাম্ অধিপতিঃ ফিৰূশী ক্ষণদাযাং ");
INSERT INTO sanasm_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","যীশৌৰভ্যৰ্ণম্ আৱ্ৰজ্য ৱ্যাহাৰ্ষীৎ, হে গুৰো ভৱান্ ঈশ্ৱৰাদ্ আগৎ এক উপদেষ্টা, এতদ্ অস্মাভিৰ্জ্ঞাযতে; যতো ভৱতা যান্যাশ্চৰ্য্যকৰ্ম্মাণি ক্ৰিযন্তে পৰমেশ্ৱৰস্য সাহায্যং ৱিনা কেনাপি তত্তৎকৰ্ম্মাণি কৰ্ত্তুং ন শক্যন্তে| ");
INSERT INTO sanasm_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","তদা যীশুৰুত্তৰং দত্তৱান্ তৱাহং যথাৰ্থতৰং ৱ্যাহৰামি পুনৰ্জন্মনি ন সতি কোপি মানৱ ঈশ্ৱৰস্য ৰাজ্যং দ্ৰষ্টুং ন শক্নোতি| ");
INSERT INTO sanasm_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ততো নিকদীমঃ প্ৰত্যৱোচৎ মনুজো ৱৃদ্ধো ভূৎৱা কথং জনিষ্যতে? স কিং পুন ৰ্মাতৃৰ্জঠৰং প্ৰৱিশ্য জনিতুং শক্নোতি? ");
INSERT INTO sanasm_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","যীশুৰৱাদীদ্ যথাৰ্থতৰম্ অহং কথযামি মনুজে তোযাত্মভ্যাং পুন ৰ্ন জাতে স ঈশ্ৱৰস্য ৰাজ্যং প্ৰৱেষ্টুং ন শক্নোতি| ");
INSERT INTO sanasm_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","মাংসাদ্ যৎ জাযতে তন্ মাংসমেৱ তথাত্মনো যো জাযতে স আত্মৈৱ| ");
INSERT INTO sanasm_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","যুষ্মাভিঃ পুন ৰ্জনিতৱ্যং মমৈতস্যাং কথাযাম্ আশ্চৰ্যং মা মংস্থাঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","সদাগতিৰ্যাং দিশমিচ্ছতি তস্যামেৱ দিশি ৱাতি, ৎৱং তস্য স্ৱনং শুণোষি কিন্তু স কুত আযাতি কুত্ৰ যাতি ৱা কিমপি ন জানাসি তদ্ৱাদ্ আত্মনঃ সকাশাৎ সৰ্ৱ্ৱেষাং মনুজানাং জন্ম ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","তদা নিকদীমঃ পৃষ্টৱান্ এতৎ কথং ভৱিতুং শক্নোতি? ");
INSERT INTO sanasm_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","যীশুঃ প্ৰত্যক্তৱান্ ৎৱমিস্ৰাযেলো গুৰুৰ্ভূৎৱাপি কিমেতাং কথাং ন ৱেৎসি? ");
INSERT INTO sanasm_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","তুভ্যং যথাৰ্থং কথযামি, ৱযং যদ্ ৱিদ্মস্তদ্ ৱচ্মঃ যংচ্চ পশ্যামস্তস্যৈৱ সাক্ষ্যং দদ্মঃ কিন্তু যুষ্মাভিৰস্মাকং সাক্ষিৎৱং ন গৃহ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","এতস্য সংসাৰস্য কথাযাং কথিতাযাং যদি যূযং ন ৱিশ্ৱসিথ তৰ্হি স্ৱৰ্গীযাযাং কথাযাং কথং ৱিশ্ৱসিষ্যথ? ");
INSERT INTO sanasm_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","যঃ স্ৱৰ্গেঽস্তি যং চ স্ৱৰ্গাদ্ অৱাৰোহৎ তং মানৱতনযং ৱিনা কোপি স্ৱৰ্গং নাৰোহৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","অপৰঞ্চ মূসা যথা প্ৰান্তৰে সৰ্পং প্ৰোত্থাপিতৱান্ মনুষ্যপুত্ৰোঽপি তথৈৱোত্থাপিতৱ্যঃ; ");
INSERT INTO sanasm_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","তস্মাদ্ যঃ কশ্চিৎ তস্মিন্ ৱিশ্ৱসিষ্যতি সোঽৱিনাশ্যঃ সন্ অনন্তাযুঃ প্ৰাপ্স্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ঈশ্ৱৰ ইত্থং জগদদযত যৎ স্ৱমদ্ৱিতীযং তনযং প্ৰাদদাৎ ততো যঃ কশ্চিৎ তস্মিন্ ৱিশ্ৱসিষ্যতি সোঽৱিনাশ্যঃ সন্ অনন্তাযুঃ প্ৰাপ্স্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ঈশ্ৱৰো জগতো লোকান্ দণ্ডযিতুং স্ৱপুত্ৰং ন প্ৰেষ্য তান্ পৰিত্ৰাতুং প্ৰেষিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","অতএৱ যঃ কশ্চিৎ তস্মিন্ ৱিশ্ৱসিতি স দণ্ডাৰ্হো ন ভৱতি কিন্তু যঃ কশ্চিৎ তস্মিন্ ন ৱিশ্ৱসিতি স ইদানীমেৱ দণ্ডাৰ্হো ভৱতি,যতঃ স ঈশ্ৱৰস্যাদ্ৱিতীযপুত্ৰস্য নামনি প্ৰত্যযং ন কৰোতি| ");
INSERT INTO sanasm_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","জগতো মধ্যে জ্যোতিঃ প্ৰাকাশত কিন্তু মনুষ্যাণাং কৰ্ম্মণাং দৃষ্টৎৱাৎ তে জ্যোতিষোপি তিমিৰে প্ৰীযন্তে এতদেৱ দণ্ডস্য কাৰণাং ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","যঃ কুকৰ্ম্ম কৰোতি তস্যাচাৰস্য দৃষ্টৎৱাৎ স জ্যোতিৰৄতীযিৎৱা তন্নিকটং নাযাতি; ");
INSERT INTO sanasm_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","কিন্তু যঃ সৎকৰ্ম্ম কৰোতি তস্য সৰ্ৱ্ৱাণি কৰ্ম্মাণীশ্ৱৰেণ কৃতানীতি সথা প্ৰকাশতে তদভিপ্ৰাযেণ স জ্যোতিষঃ সন্নিধিম্ আযাতি| ");
INSERT INTO sanasm_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ততঃ পৰম্ যীশুঃ শিষ্যৈঃ সাৰ্দ্ধং যিহূদীযদেশং গৎৱা তত্ৰ স্থিৎৱা মজ্জযিতুম্ আৰভত| ");
INSERT INTO sanasm_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","তদা শালম্ নগৰস্য সমীপস্থাযিনি ঐনন্ গ্ৰামে বহুতৰতোযস্থিতেস্তত্ৰ যোহন্ অমজ্জযৎ তথা চ লোকা আগত্য তেন মজ্জিতা অভৱন্| ");
INSERT INTO sanasm_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","তদা যোহন্ কাৰাযাং ন বদ্ধঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","অপৰঞ্চ শাচকৰ্ম্মণি যোহানঃ শিষ্যৈঃ সহ যিহূদীযলোকানাং ৱিৱাদে জাতে, তে যোহনঃ সংন্নিধিং গৎৱাকথযন্, ");
INSERT INTO sanasm_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","হে গুৰো যৰ্দ্দননদ্যাঃ পাৰে ভৱতা সাৰ্দ্ধং য আসীৎ যস্মিংশ্চ ভৱান্ সাক্ষ্যং প্ৰদদাৎ পশ্যতু সোপি মজ্জযতি সৰ্ৱ্ৱে তস্য সমীপং যান্তি চ| ");
INSERT INTO sanasm_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","তদা যোহন্ প্ৰত্যৱোচদ্ ঈশ্ৱৰেণ ন দত্তে কোপি মনুজঃ কিমপি প্ৰাপ্তুং ন শক্নোতি| ");
INSERT INTO sanasm_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","অহং অভিষিক্তো ন ভৱামি কিন্তু তদগ্ৰে প্ৰেষিতোস্মি যামিমাং কথাং কথিতৱানাহং তত্ৰ যূযং সৰ্ৱ্ৱে সাক্ষিণঃ স্থ| ");
INSERT INTO sanasm_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","যো জনঃ কন্যাং লভতে স এৱ ৱৰঃ কিন্তু ৱৰস্য সন্নিধৌ দণ্ডাযমানং তস্য যন্মিত্ৰং তেন ৱৰস্য শব্দে শ্ৰুতেঽতীৱাহ্লাদ্যতে মমাপি তদ্ৱদ্ আনন্দসিদ্ধিৰ্জাতা| ");
INSERT INTO sanasm_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","তেন ক্ৰমশো ৱৰ্দ্ধিতৱ্যং কিন্তু মযা হ্সিতৱ্যং| ");
INSERT INTO sanasm_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","য ঊৰ্ধ্ৱাদাগচ্ছৎ স সৰ্ৱ্ৱেষাং মুখ্যো যশ্চ সংসাৰাদ্ উদপদ্যত স সাংসাৰিকঃ সংসাৰীযাং কথাঞ্চ কথযতি যস্তু স্ৱৰ্গাদাগচ্ছৎ স সৰ্ৱ্ৱেষাং মুখ্যঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","স যদপশ্যদশৃণোচ্চ তস্মিন্নেৱ সাক্ষ্যং দদাতি তথাপি প্ৰাযশঃ কশ্চিৎ তস্য সাক্ষ্যং ন গৃহ্লাতি; ");
INSERT INTO sanasm_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","কিন্তু যো গৃহ্লাতি স ঈশ্ৱৰস্য সত্যৱাদিৎৱং মুদ্ৰাঙ্গিতং কৰোতি| ");
INSERT INTO sanasm_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ঈশ্ৱৰেণ যঃ প্ৰেৰিতঃ সএৱ ঈশ্ৱৰীযকথাং কথযতি যত ঈশ্ৱৰ আত্মানং তস্মৈ অপৰিমিতম্ অদদাৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","পিতা পুত্ৰে স্নেহং কৃৎৱা তস্য হস্তে সৰ্ৱ্ৱাণি সমৰ্পিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","যঃ কশ্চিৎ পুত্ৰে ৱিশ্ৱসিতি স এৱানন্তম্ পৰমাযুঃ প্ৰাপ্নোতি কিন্তু যঃ কশ্চিৎ পুত্ৰে ন ৱিশ্ৱসিতি স পৰমাযুষো দৰ্শনং ন প্ৰাপ্নোতি কিন্ত্ৱীশ্ৱৰস্য কোপভাজনং ভূৎৱা তিষ্ঠতি| ");
INSERT INTO sanasm_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","যীশুঃ স্ৱযং নামজ্জযৎ কেৱলং তস্য শিষ্যা অমজ্জযৎ কিন্তু যোহনোঽধিকশিষ্যান্ স কৰোতি মজ্জযতি চ, ");
INSERT INTO sanasm_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ফিৰূশিন ইমাং ৱাৰ্ত্তামশৃণ্ৱন্ ইতি প্ৰভুৰৱগত্য ");
INSERT INTO sanasm_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","যিহূদীযদেশং ৱিহায পুন ৰ্গালীলম্ আগৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ততঃ শোমিৰোণপ্ৰদেশস্য মদ্যেন তেন গন্তৱ্যে সতি ");
INSERT INTO sanasm_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","যাকূব্ নিজপুত্ৰায যূষফে যাং ভূমিম্ অদদাৎ তৎসমীপস্থাযি শোমিৰোণপ্ৰদেশস্য সুখাৰ্ নাম্না ৱিখ্যাতস্য নগৰস্য সন্নিধাৱুপাস্থাৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","তত্ৰ যাকূবঃ প্ৰহিৰাসীৎ; তদা দ্ৱিতীযযামৱেলাযাং জাতাযাং স মাৰ্গে শ্ৰমাপন্নস্তস্য প্ৰহেঃ পাৰ্শ্ৱে উপাৱিশৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","এতৰ্হি কাচিৎ শোমিৰোণীযা যোষিৎ তোযোত্তোলনাৰ্থম্ তত্ৰাগমৎ ");
INSERT INTO sanasm_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","তদা শিষ্যাঃ খাদ্যদ্ৰৱ্যাণি ক্ৰেতুং নগৰম্ অগচ্ছন্| ");
INSERT INTO sanasm_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","যীশুঃ শোমিৰোণীযাং তাং যোষিতম্ ৱ্যাহাৰ্ষীৎ মহ্যং কিঞ্চিৎ পানীযং পাতুং দেহি| কিন্তু শোমিৰোণীযৈঃ সাকং যিহূদীযলোকা ন ৱ্যৱাহৰন্ তস্মাদ্ধেতোঃ সাকথযৎ শোমিৰোণীযা যোষিতদহং ৎৱং যিহূদীযোসি কথং মত্তঃ পানীযং পাতুম্ ইচ্ছসি? ");
INSERT INTO sanasm_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ততো যীশুৰৱদদ্ ঈশ্ৱৰস্য যদ্দানং তৎকীদৃক্ পানীযং পাতুং মহ্যং দেহি য ইত্থং ৎৱাং যাচতে স ৱা ক ইতি চেদজ্ঞাস্যথাস্তৰ্হি তমযাচিষ্যথাঃ স চ তুভ্যমমৃতং তোযমদাস্যৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","তদা সা সীমন্তিনী ভাষিতৱতি, হে মহেচ্ছ প্ৰহিৰ্গম্ভীৰো ভৱতো নীৰোত্তোলনপাত্ৰং নাস্তী চ তস্মাৎ তদমৃতং কীলালং কুতঃ প্ৰাপ্স্যসি? ");
INSERT INTO sanasm_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","যোস্মভ্যম্ ইমমন্ধূং দদৌ, যস্য চ পৰিজনা গোমেষাদযশ্চ সৰ্ৱ্ৱেঽস্য প্ৰহেঃ পানীযং পপুৰেতাদৃশো যোস্মাকং পূৰ্ৱ্ৱপুৰুষো যাকূব্ তস্মাদপি ভৱান্ মহান্ কিং? ");
INSERT INTO sanasm_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ততো যীশুৰকথযদ্ ইদং পানীযং সঃ পিৱতি স পুনস্তৃষাৰ্ত্তো ভৱিষ্যতি, ");
INSERT INTO sanasm_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","কিন্তু মযা দত্তং পানীযং যঃ পিৱতি স পুনঃ কদাপি তৃষাৰ্ত্তো ন ভৱিষ্যতি| মযা দত্তম্ ইদং তোযং তস্যান্তঃ প্ৰস্ৰৱণৰূপং ভূৎৱা অনন্তাযুৰ্যাৱৎ স্ৰোষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","তদা সা ৱনিতাকথযৎ হে মহেচ্ছ তৰ্হি মম পুনঃ পীপাসা যথা ন জাযতে তোযোত্তোলনায যথাত্ৰাগমনং ন ভৱতি চ তদৰ্থং মহ্যং তত্তোযং দেহী| ");
INSERT INTO sanasm_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","ততো যীশূৰৱদদ্যাহি তৱ পতিমাহূয স্থানেঽত্ৰাগচ্ছ| ");
INSERT INTO sanasm_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","সা ৱামাৱদৎ মম পতিৰ্নাস্তি| যীশুৰৱদৎ মম পতিৰ্নাস্তীতি ৱাক্যং ভদ্ৰমৱোচঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","যতস্তৱ পঞ্চ পতযোভৱন্ অধুনা তু ৎৱযা সাৰ্দ্ধং যস্তিষ্ঠতি স তৱ ভৰ্ত্তা ন ৱাক্যমিদং সত্যমৱাদিঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","তদা সা মহিলা গদিতৱতি হে মহেচ্ছ ভৱান্ একো ভৱিষ্যদ্ৱাদীতি বুদ্ধং মযা| ");
INSERT INTO sanasm_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","অস্মাকং পিতৃলোকা এতস্মিন্ শিলোচ্চযেঽভজন্ত, কিন্তু ভৱদ্ভিৰুচ্যতে যিৰূশালম্ নগৰে ভজনযোগ্যং স্থানমাস্তে| ");
INSERT INTO sanasm_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","যীশুৰৱোচৎ হে যোষিৎ মম ৱাক্যে ৱিশ্ৱসিহি যদা যূযং কেৱলশৈলেঽস্মিন্ ৱা যিৰূশালম্ নগৰে পিতুৰ্ভজনং ন কৰিষ্যধ্ৱে কাল এতাদৃশ আযাতি| ");
INSERT INTO sanasm_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","যূযং যং ভজধ্ৱে তং ন জানীথ, কিন্তু ৱযং যং ভজামহে তং জানীমহে, যতো যিহূদীযলোকানাং মধ্যাৎ পৰিত্ৰাণং জাযতে| ");
INSERT INTO sanasm_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","কিন্তু যদা সত্যভক্তা আত্মনা সত্যৰূপেণ চ পিতুৰ্ভজনং কৰিষ্যন্তে সময এতাদৃশ আযাতি, ৱৰম্ ইদানীমপি ৱিদ্যতে ; যত এতাদৃশো ভৎকান্ পিতা চেষ্টতে| ");
INSERT INTO sanasm_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ঈশ্ৱৰ আত্মা; ততস্তস্য যে ভক্তাস্তৈঃ স আত্মনা সত্যৰূপেণ চ ভজনীযঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","তদা সা মহিলাৱাদীৎ খ্ৰীষ্টনাম্না ৱিখ্যাতোঽভিষিক্তঃ পুৰুষ আগমিষ্যতীতি জানামি স চ সৰ্ৱ্ৱাঃ কথা অস্মান্ জ্ঞাপযিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","ততো যীশুৰৱদৎ ৎৱযা সাৰ্দ্ধং কথনং কৰোমি যোঽহম্ অহমেৱ স পুৰুষঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","এতস্মিন্ সমযে শিষ্যা আগত্য তথা স্ত্ৰিযা সাৰ্দ্ধং তস্য কথোপকথনে মহাশ্চৰ্য্যম্ অমন্যন্ত তথাপি ভৱান্ কিমিচ্ছতি? যদ্ৱা কিমৰ্থম্ এতযা সাৰ্দ্ধং কথাং কথযতি? ইতি কোপি নাপৃচ্ছৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","ততঃ পৰং সা নাৰী কলশং স্থাপযিৎৱা নগৰমধ্যং গৎৱা লোকেভ্যোকথাযদ্ ");
INSERT INTO sanasm_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","অহং যদ্যৎ কৰ্ম্মাকৰৱং তৎসৰ্ৱ্ৱং মহ্যমকথযদ্ এতাদৃশং মানৱমেকম্ আগত্য পশ্যত ৰু কিম্ অভিষিক্তো ন ভৱতি ? ");
INSERT INTO sanasm_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ততস্তে নগৰাদ্ বহিৰাগত্য তাতস্য সমীপম্ আযন্| ");
INSERT INTO sanasm_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","এতৰ্হি শিষ্যাঃ সাধযিৎৱা তং ৱ্যাহাৰ্ষুঃ হে গুৰো ভৱান্ কিঞ্চিদ্ ভূক্তাং| ");
INSERT INTO sanasm_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ততঃ সোৱদদ্ যুষ্মাভিৰ্যন্ন জ্ঞাযতে তাদৃশং ভক্ষ্যং মমাস্তে| ");
INSERT INTO sanasm_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","তদা শিষ্যাঃ পৰস্পৰং প্ৰষ্টুম্ আৰম্ভন্ত, কিমস্মৈ কোপি কিমপি ভক্ষ্যমানীয দত্তৱান্? ");
INSERT INTO sanasm_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","যীশুৰৱোচৎ মৎপ্ৰেৰকস্যাভিমতানুৰূপকৰণং তস্যৈৱ কৰ্ম্মসিদ্ধিকাৰণঞ্চ মম ভক্ষ্যং| ");
INSERT INTO sanasm_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","মাসচতুষ্টযে জাতে শস্যকৰ্ত্তনসমযো ভৱিষ্যতীতি ৱাক্যং যুষ্মাভিঃ কিং নোদ্যতে? কিন্ত্ৱহং ৱদামি, শিৰ উত্তোল্য ক্ষেত্ৰাণি প্ৰতি নিৰীক্ষ্য পশ্যত, ইদানীং কৰ্ত্তনযোগ্যানি শুক্লৱৰ্ণান্যভৱন্| ");
INSERT INTO sanasm_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","যশ্ছিনত্তি স ৱেতনং লভতে অনন্তাযুঃস্ৱৰূপং শস্যং স গৃহ্লাতি চ, তেনৈৱ ৱপ্তা ছেত্তা চ যুগপদ্ আনন্দতঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ইত্থং সতি ৱপত্যেকশ্ছিনত্যন্য ইতি ৱচনং সিদ্ধ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","যত্ৰ যূযং ন পৰ্য্যশ্ৰাম্যত তাদৃশং শস্যং ছেত্তুং যুষ্মান্ প্ৰৈৰযম্ অন্যে জনাঃপৰ্য্যশ্ৰাম্যন্ যূযং তেষাং শ্ৰগস্য ফলম্ অলভধ্ৱম্| ");
INSERT INTO sanasm_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","যস্মিন্ কালে যদ্যৎ কৰ্ম্মাকাৰ্ষং তৎসৰ্ৱ্ৱং স মহ্যম্ অকথযৎ তস্যা ৱনিতাযা ইদং সাক্ষ্যৱাক্যং শ্ৰুৎৱা তন্নগৰনিৱাসিনো বহৱঃ শোমিৰোণীযলোকা ৱ্যশ্ৱসন্| ");
INSERT INTO sanasm_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","তথা চ তস্যান্তিকে সমুপস্থায স্ৱেষাং সন্নিধৌ কতিচিদ্ দিনানি স্থাতুং তস্মিন্ ৱিনযম্ অকুৰ্ৱ্ৱান তস্মাৎ স দিনদ্ৱযং তৎস্থানে ন্যৱষ্টৎ ");
INSERT INTO sanasm_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ততস্তস্যোপদেশেন বহৱোঽপৰে ৱিশ্ৱস্য ");
INSERT INTO sanasm_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","তাং যোষামৱদন্ কেৱলং তৱ ৱাক্যেন প্ৰতীম ইতি ন, কিন্তু স জগতোঽভিষিক্তস্ত্ৰাতেতি তস্য কথাং শ্ৰুৎৱা ৱযং স্ৱযমেৱাজ্ঞাসমহি| ");
INSERT INTO sanasm_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","স্ৱদেশে ভৱিষ্যদ্ৱক্তুঃ সৎকাৰো নাস্তীতি যদ্যপি যীশুঃ প্ৰমাণং দৎৱাকথযৎ ");
INSERT INTO sanasm_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","তথাপি দিৱসদ্ৱযাৎ পৰং স তস্মাৎ স্থানাদ্ গালীলং গতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","অনন্তৰং যে গালীলী লিযলোকা উৎসৱে গতা উৎসৱসমযে যিৰূশলম্ নগৰে তস্য সৰ্ৱ্ৱাঃ ক্ৰিযা অপশ্যন্ তে গালীলম্ আগতং তম্ আগৃহ্লন্| ");
INSERT INTO sanasm_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","ততঃ পৰম্ যীশু ৰ্যস্মিন্ কান্নানগৰে জলং দ্ৰাক্ষাৰসম্ আকৰোৎ তৎ স্থানং পুনৰগাৎ| তস্মিন্নেৱ সমযে কস্যচিদ্ ৰাজসভাস্তাৰস্য পুত্ৰঃ কফৰ্নাহূমপুৰী ৰোগগ্ৰস্ত আসীৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","স যেহূদীযদেশাদ্ যীশো ৰ্গালীলাগমনৱাৰ্ত্তাং নিশম্য তস্য সমীপং গৎৱা প্ৰাৰ্থ্য ৱ্যাহৃতৱান্ মম পুত্ৰস্য প্ৰাযেণ কাল আসন্নঃ ভৱান্ আগত্য তং স্ৱস্থং কৰোতু| ");
INSERT INTO sanasm_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","তদা যীশুৰকথযদ্ আশ্চৰ্য্যং কৰ্ম্ম চিত্ৰং চিহ্নং চ ন দৃষ্টা যূযং ন প্ৰত্যেষ্যথ| ");
INSERT INTO sanasm_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ততঃ স সভাসদৱদৎ হে মহেচ্ছ মম পুত্ৰে ন মৃতে ভৱানাগচ্ছতু| ");
INSERT INTO sanasm_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","যীশুস্তমৱদদ্ গচ্ছ তৱ পুত্ৰোঽজীৱীৎ তদা যীশুনোক্তৱাক্যে স ৱিশ্ৱস্য গতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","গমনকালে মাৰ্গমধ্যে দাসাস্তং সাক্ষাৎপ্ৰাপ্যাৱদন্ ভৱতঃ পুত্ৰোঽজীৱীৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ততঃ কং কালমাৰভ্য ৰোগপ্ৰতীকাৰাৰম্ভো জাতা ইতি পৃষ্টে তৈৰুক্তং হ্যঃ সাৰ্দ্ধদণ্ডদ্ৱযাধিকদ্ৱিতীযযামে তস্য জ্ৱৰত্যাগোঽভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","তদা যীশুস্তস্মিন্ ক্ষণে প্ৰোক্তৱান্ তৱ পুত্ৰোঽজীৱীৎ পিতা তদ্বুদ্ধ্ৱা সপৰিৱাৰো ৱ্যশ্ৱসীৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","যিহূদীযদেশাদ্ আগত্য গালীলি যীশুৰেতদ্ দ্ৱিতীযম্ আশ্চৰ্য্যকৰ্ম্মাকৰোৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","ততঃ পৰং যিহূদীযানাম্ উৎসৱ উপস্থিতে যীশু ৰ্যিৰূশালমং গতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","তস্মিন্নগৰে মেষনাম্নো দ্ৱাৰস্য সমীপে ইব্ৰীযভাষযা বৈথেস্দা নাম্না পিষ্কৰিণী পঞ্চঘট্টযুক্তাসীৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","তস্যাস্তেষু ঘট্টেষু কিলালকম্পনম্ অপেক্ষ্য অন্ধখঞ্চশুষ্কাঙ্গাদযো বহৱো ৰোগিণঃ পতন্তস্তিষ্ঠন্তি স্ম| ");
INSERT INTO sanasm_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","যতো ৱিশেষকালে তস্য সৰসো ৱাৰি স্ৱৰ্গীযদূত এত্যাকম্পযৎ তৎকীলালকম্পনাৎ পৰং যঃ কশ্চিদ্ ৰোগী প্ৰথমং পানীযমৱাৰোহৎ স এৱ তৎক্ষণাদ্ ৰোগমুক্তোঽভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","তদাষ্টাত্ৰিংশদ্ৱৰ্ষাণি যাৱদ্ ৰোগগ্ৰস্ত একজনস্তস্মিন্ স্থানে স্থিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","যীশুস্তং শযিতং দৃষ্ট্ৱা বহুকালিকৰোগীতি জ্ঞাৎৱা ৱ্যাহৃতৱান্ ৎৱং কিং স্ৱস্থো বুভূষসি? ");
INSERT INTO sanasm_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ততো ৰোগী কথিতৱান্ হে মহেচ্ছ যদা কীলালং কম্পতে তদা মাং পুষ্কৰিণীম্ অৱৰোহযিতুং মম কোপি নাস্তি, তস্মান্ মম গমনকালে কশ্চিদন্যোঽগ্ৰো গৎৱা অৱৰোহতি| ");
INSERT INTO sanasm_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","তদা যীশুৰকথযদ্ উত্তিষ্ঠ, তৱ শয্যামুত্তোল্য গৃহীৎৱা যাহি| ");
INSERT INTO sanasm_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","স তৎক্ষণাৎ স্ৱস্থো ভূৎৱা শয্যামুত্তোল্যাদায গতৱান্ কিন্তু তদ্দিনং ৱিশ্ৰামৱাৰঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","তস্মাদ্ যিহূদীযাঃ স্ৱস্থং নৰং ৱ্যাহৰন্ অদ্য ৱিশ্ৰামৱাৰে শযনীযমাদায ন যাতৱ্যম্| ");
INSERT INTO sanasm_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","ততঃ স প্ৰত্যৱোচদ্ যো মাং স্ৱস্থম্ অকাৰ্ষীৎ শযনীযম্ উত্তোল্যাদায যাতুং মাং স এৱাদিশৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","তদা তেঽপৃচ্ছন্ শযনীযম্ উত্তোল্যাদায যাতুং য আজ্ঞাপযৎ স কঃ? ");
INSERT INTO sanasm_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","কিন্তু স ক ইতি স্ৱস্থীভূতো নাজানাদ্ যতস্তস্মিন্ স্থানে জনতাসত্ত্ৱাদ্ যীশুঃ স্থানান্তৰম্ আগমৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","ততঃ পৰং যেশু ৰ্মন্দিৰে তং নৰং সাক্ষাৎপ্ৰাপ্যাকথযৎ পশ্যেদানীম্ অনামযো জাতোসি যথাধিকা দুৰ্দশা ন ঘটতে তদ্ধেতোঃ পাপং কৰ্ম্ম পুনৰ্মাকাৰ্ষীঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ততঃ স গৎৱা যিহূদীযান্ অৱদদ্ যীশু ৰ্মাম্ অৰোগিণম্ অকাৰ্ষীৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","ততো যীশু ৰ্ৱিশ্ৰামৱাৰে কৰ্ম্মেদৃশং কৃতৱান্ ইতি হেতো ৰ্যিহূদীযাস্তং তাডযিৎৱা হন্তুম্ অচেষ্টন্ত| ");
INSERT INTO sanasm_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","যীশুস্তানাখ্যৎ মম পিতা যৎ কাৰ্য্যং কৰোতি তদনুৰূপম্ অহমপি কৰোতি| ");
INSERT INTO sanasm_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","ততো যিহূদীযাস্তং হন্তুং পুনৰযতন্ত যতো ৱিশ্ৰামৱাৰং নামন্যত তদেৱ কেৱলং ন অধিকন্তু ঈশ্ৱৰং স্ৱপিতৰং প্ৰোচ্য স্ৱমপীশ্ৱৰতুল্যং কৃতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","পশ্চাদ্ যীশুৰৱদদ্ যুষ্মানহং যথাৰ্থতৰং ৱদামি পুত্ৰঃ পিতৰং যদ্যৎ কৰ্ম্ম কুৰ্ৱ্ৱন্তং পশ্যতি তদতিৰিক্তং স্ৱেচ্ছাতঃ কিমপি কৰ্ম্ম কৰ্ত্তুং ন শক্নোতি| পিতা যৎ কৰোতি পুত্ৰোপি তদেৱ কৰোতি| ");
INSERT INTO sanasm_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","পিতা পুত্ৰে স্নেহং কৰোতি তস্মাৎ স্ৱযং যদ্যৎ কৰ্ম্ম কৰোতি তৎসৰ্ৱ্ৱং পুত্ৰং দৰ্শযতি ; যথা চ যুষ্মাকং আশ্চৰ্য্যজ্ঞানং জনিষ্যতে তদৰ্থম্ ইতোপি মহাকৰ্ম্ম তং দৰ্শযিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","ৱস্তুতস্তু পিতা যথা প্ৰমিতান্ উত্থাপ্য সজিৱান্ কৰোতি তদ্ৱৎ পুত্ৰোপি যং যং ইচ্ছতি তং তং সজীৱং কৰোতি| ");
INSERT INTO sanasm_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","সৰ্ৱ্ৱে পিতৰং যথা সৎকুৰ্ৱ্ৱন্তি তথা পুত্ৰমপি সৎকাৰযিতুং পিতা স্ৱযং কস্যাপি ৱিচাৰমকৃৎৱা সৰ্ৱ্ৱৱিচাৰাণাং ভাৰং পুত্ৰে সমৰ্পিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","যঃ পুত্ৰং সৎ কৰোতি স তস্য প্ৰেৰকমপি সৎ কৰোতি| ");
INSERT INTO sanasm_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","যুষ্মানাহং যথাৰ্থতৰং ৱদামি যো জনো মম ৱাক্যং শ্ৰুৎৱা মৎপ্ৰেৰকে ৱিশ্ৱসিতি সোনন্তাযুঃ প্ৰাপ্নোতি কদাপি দণ্ডবাজনং ন ভৱতি নিধনাদুত্থায পৰমাযুঃ প্ৰাপ্নোতি| ");
INSERT INTO sanasm_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","অহং যুষ্মানতিযথাৰ্থং ৱদামি যদা মৃতা ঈশ্ৱৰপুত্ৰস্য নিনাদং শ্ৰোষ্যন্তি যে চ শ্ৰোষ্যন্তি তে সজীৱা ভৱিষ্যন্তি সময এতাদৃশ আযাতি ৱৰম্ ইদানীমপ্যুপতিষ্ঠতি| ");
INSERT INTO sanasm_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","পিতা যথা স্ৱযঞ্জীৱী তথা পুত্ৰায স্ৱযঞ্জীৱিৎৱাধিকাৰং দত্তৱান্| ");
INSERT INTO sanasm_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","স মনুষ্যপুত্ৰঃ এতস্মাৎ কাৰণাৎ পিতা দণ্ডকৰণাধিকাৰমপি তস্মিন্ সমৰ্পিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","এতদৰ্থে যূযম্ আশ্চৰ্য্যং ন মন্যধ্ৱং যতো যস্মিন্ সমযে তস্য নিনাদং শ্ৰুৎৱা শ্মশানস্থাঃ সৰ্ৱ্ৱে বহিৰাগমিষ্যন্তি সময এতাদৃশ উপস্থাস্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","তস্মাদ্ যে সৎকৰ্ম্মাণি কৃতৱন্তস্ত উত্থায আযুঃ প্ৰাপ্স্যন্তি যে চ কুকৰ্মাণি কৃতৱন্তস্ত উত্থায দণ্ডং প্ৰাপ্স্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","অহং স্ৱযং কিমপি কৰ্ত্তুং ন শক্নোমি যথা শুণোমি তথা ৱিচাৰযামি মম ৱিচাৰঞ্চ ন্যায্যঃ যতোহং স্ৱীযাভীষ্টং নেহিৎৱা মৎপ্ৰেৰযিতুঃ পিতুৰিষ্টম্ ঈহে| ");
INSERT INTO sanasm_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","যদি স্ৱস্মিন্ স্ৱযং সাক্ষ্যং দদামি তৰ্হি তৎসাক্ষ্যম্ আগ্ৰাহ্যং ভৱতি ; ");
INSERT INTO sanasm_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","কিন্তু মদৰ্থেঽপৰো জনঃ সাক্ষ্যং দদাতি মদৰ্থে তস্য যৎ সাক্ষ্যং তৎ সত্যম্ এতদপ্যহং জানামি| ");
INSERT INTO sanasm_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","যুষ্মাভি ৰ্যোহনং প্ৰতি লোকেষু প্ৰেৰিতেষু স সত্যকথাযাং সাক্ষ্যমদদাৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","মানুষাদহং সাক্ষ্যং নোপেক্ষে তথাপি যূযং যথা পৰিত্ৰযধ্ৱে তদৰ্থম্ ইদং ৱাক্যং ৱদামি| ");
INSERT INTO sanasm_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","যোহন্ দেদীপ্যমানো দীপ ইৱ তেজস্ৱী স্থিতৱান্ যূযম্ অল্পকালং তস্য দীপ্ত্যানন্দিতুং সমমন্যধ্ৱং| ");
INSERT INTO sanasm_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","কিন্তু তৎপ্ৰমাণাদপি মম গুৰুতৰং প্ৰমাণং ৱিদ্যতে পিতা মাং প্ৰেষ্য যদ্যৎ কৰ্ম্ম সমাপযিতুং শক্ত্তিমদদাৎ মযা কৃতং তত্তৎ কৰ্ম্ম মদৰ্থে প্ৰমাণং দদাতি| ");
INSERT INTO sanasm_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","যঃ পিতা মাং প্ৰেৰিতৱান্ মোপি মদৰ্থে প্ৰমাণং দদাতি| তস্য ৱাক্যং যুষ্মাভিঃ কদাপি ন শ্ৰুতং তস্য ৰূপঞ্চ ন দৃষ্টং ");
INSERT INTO sanasm_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","তস্য ৱাক্যঞ্চ যুষ্মাকম্ অন্তঃ কদাপি স্থানং নাপ্নোতি যতঃ স যং প্ৰেষিতৱান্ যূযং তস্মিন্ ন ৱিশ্ৱসিথ| ");
INSERT INTO sanasm_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","ধৰ্ম্মপুস্তকানি যূযম্ আলোচযধ্ৱং তৈ ৰ্ৱাক্যৈৰনন্তাযুঃ প্ৰাপ্স্যাম ইতি যূযং বুধ্যধ্ৱে তদ্ধৰ্ম্মপুস্তকানি মদৰ্থে প্ৰমাণং দদতি| ");
INSERT INTO sanasm_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","তথাপি যূযং পৰমাযুঃপ্ৰাপ্তযে মম সংনিধিম্ ন জিগমিষথ| ");
INSERT INTO sanasm_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","অহং মানুষেভ্যঃ সৎকাৰং ন গৃহ্লামি| ");
INSERT INTO sanasm_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","অহং যুষ্মান্ জানামি; যুষ্মাকমন্তৰ ঈশ্ৱৰপ্ৰেম নাস্তি| ");
INSERT INTO sanasm_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","অহং নিজপিতু ৰ্নাম্নাগতোস্মি তথাপি মাং ন গৃহ্লীথ কিন্তু কশ্চিদ্ যদি স্ৱনাম্না সমাগমিষ্যতি তৰ্হি তং গ্ৰহীষ্যথ| ");
INSERT INTO sanasm_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","যূযম্ ঈশ্ৱৰাৎ সৎকাৰং ন চিষ্টৎৱা কেৱলং পৰস্পৰং সৎকাৰম্ চেদ্ আদধ্ৱ্ৱে তৰ্হি কথং ৱিশ্ৱসিতুং শক্নুথ? ");
INSERT INTO sanasm_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","পুতুঃ সমীপেঽহং যুষ্মান্ অপৱদিষ্যামীতি মা চিন্তযত যস্মিন্ , যস্মিন্ যুষ্মাকং ৱিশ্ৱসঃ সএৱ মূসা যুষ্মান্ অপৱদতি| ");
INSERT INTO sanasm_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","যদি যূযং তস্মিন্ ৱ্যশ্ৱসিষ্যত তৰ্হি ময্যপি ৱ্যশ্ৱসিষ্যত, যৎ স মযি লিখিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","ততো যদি তেন লিখিতৱানি ন প্ৰতিথ তৰ্হি মম ৱাক্যানি কথং প্ৰত্যেষ্যথ? ");
INSERT INTO sanasm_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","ততঃ পৰং যীশু ৰ্গালীল্ প্ৰদেশীযস্য তিৱিৰিযানাম্নঃ সিন্ধোঃ পাৰং গতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ততো ৱ্যাধিমল্লোকস্ৱাস্থ্যকৰণৰূপাণি তস্যাশ্চৰ্য্যাণি কৰ্ম্মাণি দৃষ্ট্ৱা বহৱো জনাস্তৎপশ্চাদ্ অগচ্ছন্| ");
INSERT INTO sanasm_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ততো যীশুঃ পৰ্ৱ্ৱতমাৰুহ্য তত্ৰ শিষ্যৈঃ সাকম্| ");
INSERT INTO sanasm_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","তস্মিন্ সময নিস্তাৰোৎসৱনাম্নি যিহূদীযানাম উৎসৱ উপস্থিতে ");
INSERT INTO sanasm_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","যীশু ৰ্নেত্ৰে উত্তোল্য বহুলোকান্ স্ৱসমীপাগতান্ ৱিলোক্য ফিলিপং পৃষ্টৱান্ এতেষাং ভোজনায ভোজদ্ৰৱ্যাণি ৱযং কুত্ৰ ক্ৰেতুং শক্ৰুমঃ? ");
INSERT INTO sanasm_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ৱাক্যমিদং তস্য পৰীক্ষাৰ্থম্ অৱাদীৎ কিন্তু যৎ কৰিষ্যতি তৎ স্ৱযম্ অজানাৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ফিলিপঃ প্ৰত্যৱোচৎ এতেষাম্ একৈকো যদ্যল্পম্ অল্পং প্ৰাপ্নোতি তৰ্হি মুদ্ৰাপাদদ্ৱিশতেন ক্ৰীতপূপা অপি ন্যূনা ভৱিষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","শিমোন্ পিতৰস্য ভ্ৰাতা আন্দ্ৰিযাখ্যঃ শিষ্যাণামেকো ৱ্যাহৃতৱান্ ");
INSERT INTO sanasm_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","অত্ৰ কস্যচিদ্ বালকস্য সমীপে পঞ্চ যাৱপূপাঃ ক্ষুদ্ৰমৎস্যদ্ৱযঞ্চ সন্তি কিন্তু লোকানাং এতাৱাতাং মধ্যে তৈঃ কিং ভৱিষ্যতি? ");
INSERT INTO sanasm_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","পশ্চাদ্ যীশুৰৱদৎ লোকানুপৱেশযত তত্ৰ বহুযৱসসত্ত্ৱাৎ পঞ্চসহস্ত্ৰেভ্যো ন্যূনা অধিকা ৱা পুৰুষা ভূম্যাম্ উপাৱিশন্| ");
INSERT INTO sanasm_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ততো যীশুস্তান্ পূপানাদায ঈশ্ৱৰস্য গুণান্ কীৰ্ত্তযিৎৱা শিষ্যেষু সমাৰ্পযৎ ততস্তে তেভ্য উপৱিষ্টলোকেভ্যঃ পূপান্ যথেষ্টমৎস্যঞ্চ প্ৰাদুঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","তেষু তৃপ্তেষু স তানৱোচদ্ এতেষাং কিঞ্চিদপি যথা নাপচীযতে তথা সৰ্ৱ্ৱাণ্যৱশিষ্টানি সংগৃহ্লীত| ");
INSERT INTO sanasm_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ততঃ সৰ্ৱ্ৱেষাং ভোজনাৎ পৰং তে তেষাং পঞ্চানাং যাৱপূপানাং অৱশিষ্টান্যখিলানি সংগৃহ্য দ্ৱাদশডল্লকান্ অপূৰযন্| ");
INSERT INTO sanasm_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","অপৰং যীশোৰেতাদৃশীম্ আশ্চৰ্য্যক্ৰিযাং দৃষ্ট্ৱা লোকা মিথো ৱক্তুমাৰেভিৰে জগতি যস্যাগমনং ভৱিষ্যতি স এৱাযম্ অৱশ্যং ভৱিষ্যদ্ৱক্ত্তা| ");
INSERT INTO sanasm_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","অতএৱ লোকা আগত্য তমাক্ৰম্য ৰাজানং কৰিষ্যন্তি যীশুস্তেষাম্ ঈদৃশং মানসং ৱিজ্ঞায পুনশ্চ পৰ্ৱ্ৱতম্ একাকী গতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","সাযংকাল উপস্থিতে শিষ্যা জলধিতটং ৱ্ৰজিৎৱা নাৱমাৰুহ্য নগৰদিশি সিন্ধৌ ৱাহযিৎৱাগমন্| ");
INSERT INTO sanasm_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","তস্মিন্ সমযে তিমিৰ উপাতিষ্ঠৎ কিন্তু যীষুস্তেষাং সমীপং নাগচ্ছৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","তদা প্ৰবলপৱনৱহনাৎ সাগৰে মহাতৰঙ্গো ভৱিতুম্ আৰেভে| ");
INSERT INTO sanasm_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ততস্তে ৱাহযিৎৱা দ্ৱিত্ৰান্ ক্ৰোশান্ গতাঃ পশ্চাদ্ যীশুং জলধেৰুপৰি পদ্ভ্যাং ৱ্ৰজন্তং নৌকান্তিকম্ আগচ্ছন্তং ৱিলোক্য ত্ৰাসযুক্তা অভৱন্ ");
INSERT INTO sanasm_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","কিন্তু স তানুক্ত্তৱান্ অযমহং মা ভৈষ্ট| ");
INSERT INTO sanasm_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","তদা তে তং স্ৱৈৰং নাৱি গৃহীতৱন্তঃ তদা তৎক্ষণাদ্ উদ্দিষ্টস্থানে নৌৰুপাস্থাৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","যযা নাৱা শিষ্যা অগচ্ছন্ তদন্যা কাপি নৌকা তস্মিন্ স্থানে নাসীৎ ততো যীশুঃ শিষ্যৈঃ সাকং নাগমৎ কেৱলাঃ শিষ্যা অগমন্ এতৎ পাৰস্থা লোকা জ্ঞাতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","কিন্তু ততঃ পৰং প্ৰভু ৰ্যত্ৰ ঈশ্ৱৰস্য গুণান্ অনুকীৰ্ত্ত্য লোকান্ পূপান্ অভোজযৎ তৎস্থানস্য সমীপস্থতিৱিৰিযাযা অপৰাস্তৰণয আগমন্| ");
INSERT INTO sanasm_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","যীশুস্তত্ৰ নাস্তি শিষ্যা অপি তত্ৰ না সন্তি লোকা ইতি ৱিজ্ঞায যীশুং গৱেষযিতুং তৰণিভিঃ কফৰ্নাহূম্ পুৰং গতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","ততস্তে সৰিৎপতেঃ পাৰে তং সাক্ষাৎ প্ৰাপ্য প্ৰাৱোচন্ হে গুৰো ভৱান্ অত্ৰ স্থানে কদাগমৎ? ");
INSERT INTO sanasm_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","তদা যীশুস্তান্ প্ৰত্যৱাদীদ্ যুষ্মানহং যথাৰ্থতৰং ৱদামি আশ্চৰ্য্যকৰ্ম্মদৰ্শনাদ্ধেতো ৰ্ন কিন্তু পূপভোজনাৎ তেন তৃপ্তৎৱাঞ্চ মাং গৱেষযথ| ");
INSERT INTO sanasm_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ক্ষযণীযভক্ষ্যাৰ্থং মা শ্ৰামিষ্ট কিন্ত্ৱন্তাযুৰ্ভক্ষ্যাৰ্থং শ্ৰাম্যত, তস্মাৎ তাদৃশং ভক্ষ্যং মনুজপুত্ৰো যুষ্মাভ্যং দাস্যতি; তস্মিন্ তাত ঈশ্ৱৰঃ প্ৰমাণং প্ৰাদাৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","তদা তেঽপৃচ্ছন্ ঈশ্ৱৰাভিমতং কৰ্ম্ম কৰ্ত্তুম্ অস্মাভিঃ কিং কৰ্ত্তৱ্যং? ");
INSERT INTO sanasm_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","ততো যীশুৰৱদদ্ ঈশ্ৱৰো যং প্ৰৈৰযৎ তস্মিন্ ৱিশ্ৱসনম্ ঈশ্ৱৰাভিমতং কৰ্ম্ম| ");
INSERT INTO sanasm_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","তদা তে ৱ্যাহৰন্ ভৱতা কিং লক্ষণং দৰ্শিতং যদ্দৃষ্ট্ৱা ভৱতি ৱিশ্ৱসিষ্যামঃ? ৎৱযা কিং কৰ্ম্ম কৃতং? ");
INSERT INTO sanasm_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","অস্মাকং পূৰ্ৱ্ৱপুৰুষা মহাপ্ৰান্তৰে মান্নাং ভোক্ত্তুং প্ৰাপুঃ যথা লিপিৰাস্তে| স্ৱৰ্গীযাণি তু ভক্ষ্যাণি প্ৰদদৌ পৰমেশ্ৱৰঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","তদা যীশুৰৱদদ্ অহং যুষ্মানতিযথাৰ্থং ৱদামি মূসা যুষ্মাভ্যং স্ৱৰ্গীযং ভক্ষ্যং নাদাৎ কিন্তু মম পিতা যুষ্মাভ্যং স্ৱৰ্গীযং পৰমং ভক্ষ্যং দদাতি| ");
INSERT INTO sanasm_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","যঃ স্ৱৰ্গাদৱৰুহ্য জগতে জীৱনং দদাতি স ঈশ্ৱৰদত্তভক্ষ্যৰূপঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","তদা তে প্ৰাৱোচন্ হে প্ৰভো ভক্ষ্যমিদং নিত্যমস্মভ্যং দদাতু| ");
INSERT INTO sanasm_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","যীশুৰৱদদ্ অহমেৱ জীৱনৰূপং ভক্ষ্যং যো জনো মম সন্নিধিম্ আগচ্ছতি স জাতু ক্ষুধাৰ্ত্তো ন ভৱিষ্যতি, তথা যো জনো মাং প্ৰত্যেতি স জাতু তৃষাৰ্ত্তো ন ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","মাং দৃষ্ট্ৱাপি যূযং ন ৱিশ্ৱসিথ যুষ্মানহম্ ইত্যৱোচং| ");
INSERT INTO sanasm_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","পিতা মহ্যং যাৱতো লোকানদদাৎ তে সৰ্ৱ্ৱ এৱ মমান্তিকম্ আগমিষ্যন্তি যঃ কশ্চিচ্চ মম সন্নিধিম্ আযাস্যতি তং কেনাপি প্ৰকাৰেণ ন দূৰীকৰিষ্যামি| ");
INSERT INTO sanasm_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","নিজাভিমতং সাধযিতুং ন হি কিন্তু প্ৰেৰযিতুৰভিমতং সাধযিতুং স্ৱৰ্গাদ্ আগতোস্মি| ");
INSERT INTO sanasm_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","স যান্ যান্ লোকান্ মহ্যমদদাৎ তেষামেকমপি ন হাৰযিৎৱা শেষদিনে সৰ্ৱ্ৱানহম্ উত্থাপযামি ইদং মৎপ্ৰেৰযিতুঃ পিতুৰভিমতং| ");
INSERT INTO sanasm_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","যঃ কশ্চিন্ মানৱসুতং ৱিলোক্য ৱিশ্ৱসিতি স শেষদিনে মযোত্থাপিতঃ সন্ অনন্তাযুঃ প্ৰাপ্স্যতি ইতি মৎপ্ৰেৰকস্যাভিমতং| ");
INSERT INTO sanasm_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","তদা স্ৱৰ্গাদ্ যদ্ ভক্ষ্যম্ অৱাৰোহৎ তদ্ ভক্ষ্যম্ অহমেৱ যিহূদীযলোকাস্তস্যৈতদ্ ৱাক্যে ৱিৱদমানা ৱক্ত্তুমাৰেভিৰে ");
INSERT INTO sanasm_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","যূষফঃ পুত্ৰো যীশু ৰ্যস্য মাতাপিতৰৌ ৱযং জানীম এষ কিং সএৱ ন? তৰ্হি স্ৱৰ্গাদ্ অৱাৰোহম্ ইতি ৱাক্যং কথং ৱক্ত্তি? ");
INSERT INTO sanasm_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","তদা যীশুস্তান্ প্ৰত্যৱদৎ পৰস্পৰং মা ৱিৱদধ্ৱং ");
INSERT INTO sanasm_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","মৎপ্ৰেৰকেণ পিত্ৰা নাকৃষ্টঃ কোপি জনো মমান্তিকম্ আযাতুং ন শক্নোতি কিন্ত্ৱাগতং জনং চৰমেঽহ্নি প্ৰোত্থাপযিষ্যামি| ");
INSERT INTO sanasm_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","তে সৰ্ৱ্ৱ ঈশ্ৱৰেণ শিক্ষিতা ভৱিষ্যন্তি ভৱিষ্যদ্ৱাদিনাং গ্ৰন্থেষু লিপিৰিত্থমাস্তে অতো যঃ কশ্চিৎ পিতুঃ সকাশাৎ শ্ৰুৎৱা শিক্ষতে স এৱ মম সমীপম্ আগমিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","য ঈশ্ৱৰাদ্ অজাযত তং ৱিনা কোপি মনুষ্যো জনকং নাদৰ্শৎ কেৱলঃ সএৱ তাতম্ অদ্ৰাক্ষীৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","অহং যুষ্মান্ যথাৰ্থতৰং ৱদামি যো জনো মযি ৱিশ্ৱাসং কৰোতি সোনন্তাযুঃ প্ৰাপ্নোতি| ");
INSERT INTO sanasm_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","অহমেৱ তজ্জীৱনভক্ষ্যং| ");
INSERT INTO sanasm_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","যুষ্মাকং পূৰ্ৱ্ৱপুৰুষা মহাপ্ৰান্তৰে মন্নাভক্ষ্যং ভূক্ত্তাপি মৃতাঃ ");
INSERT INTO sanasm_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","কিন্তু যদ্ভক্ষ্যং স্ৱৰ্গাদাগচ্ছৎ তদ্ যদি কশ্চিদ্ ভুঙ্ক্ত্তে তৰ্হি স ন ম্ৰিযতে| ");
INSERT INTO sanasm_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","যজ্জীৱনভক্ষ্যং স্ৱৰ্গাদাগচ্ছৎ সোহমেৱ ইদং ভক্ষ্যং যো জনো ভুঙ্ক্ত্তে স নিত্যজীৱী ভৱিষ্যতি| পুনশ্চ জগতো জীৱনাৰ্থমহং যৎ স্ৱকীযপিশিতং দাস্যামি তদেৱ মযা ৱিতৰিতং ভক্ষ্যম্| ");
INSERT INTO sanasm_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","তস্মাদ্ যিহূদীযাঃ পৰস্পৰং ৱিৱদমানা ৱক্ত্তুমাৰেভিৰে এষ ভোজনাৰ্থং স্ৱীযং পললং কথম্ অস্মভ্যং দাস্যতি? ");
INSERT INTO sanasm_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","তদা যীশুস্তান্ আৱোচদ্ যুষ্মানহং যথাৰ্থতৰং ৱদামি মনুষ্যপুত্ৰস্যামিষে যুষ্মাভি ৰ্ন ভুক্ত্তে তস্য ৰুধিৰে চ ন পীতে জীৱনেন সাৰ্দ্ধং যুষ্মাকং সম্বন্ধো নাস্তি| ");
INSERT INTO sanasm_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","যো মমামিষং স্ৱাদতি মম সুধিৰঞ্চ পিৱতি সোনন্তাযুঃ প্ৰাপ্নোতি ততঃ শেষেঽহ্নি তমহম্ উত্থাপযিষ্যামি| ");
INSERT INTO sanasm_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","যতো মদীযমামিষং পৰমং ভক্ষ্যং তথা মদীযং শোণিতং পৰমং পেযং| ");
INSERT INTO sanasm_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","যো জনো মদীযং পললং স্ৱাদতি মদীযং ৰুধিৰঞ্চ পিৱতি স মযি ৱসতি তস্মিন্নহঞ্চ ৱসামি| ");
INSERT INTO sanasm_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","মৎপ্ৰেৰযিত্ৰা জীৱতা তাতেন যথাহং জীৱামি তদ্ৱদ্ যঃ কশ্চিন্ মামত্তি সোপি মযা জীৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","যদ্ভক্ষ্যং স্ৱৰ্গাদাগচ্ছৎ তদিদং যন্মান্নাং স্ৱাদিৎৱা যুষ্মাকং পিতৰোঽম্ৰিযন্ত তাদৃশম্ ইদং ভক্ষ্যং ন ভৱতি ইদং ভক্ষ্যং যো ভক্ষতি স নিত্যং জীৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","যদা কফৰ্নাহূম্ পুৰ্য্যাং ভজনগেহে উপাদিশৎ তদা কথা এতা অকথযৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","তদেত্থং শ্ৰুৎৱা তস্য শিষ্যাণাম্ অনেকে পৰস্পৰম্ অকথযন্ ইদং গাঢং ৱাক্যং ৱাক্যমীদৃশং কঃ শ্ৰোতুং শক্ৰুযাৎ? ");
INSERT INTO sanasm_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","কিন্তু যীশুঃ শিষ্যাণাম্ ইত্থং ৱিৱাদং স্ৱচিত্তে ৱিজ্ঞায কথিতৱান্ ইদং ৱাক্যং কিং যুষ্মাকং ৱিঘ্নং জনযতি? ");
INSERT INTO sanasm_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","যদি মনুজসুতং পূৰ্ৱ্ৱৱাসস্থানম্ ঊৰ্দ্ৱ্ৱং গচ্ছন্তং পশ্যথ তৰ্হি কিং ভৱিষ্যতি? ");
INSERT INTO sanasm_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","আত্মৈৱ জীৱনদাযকঃ ৱপু ৰ্নিষ্ফলং যুষ্মভ্যমহং যানি ৱচাংসি কথযামি তান্যাত্মা জীৱনঞ্চ| ");
INSERT INTO sanasm_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","কিন্তু যুষ্মাকং মধ্যে কেচন অৱিশ্ৱাসিনঃ সন্তি কে কে ন ৱিশ্ৱসন্তি কো ৱা তং পৰকৰেষু সমৰ্পযিষ্যতি তান্ যীশুৰাপ্ৰথমাদ্ ৱেত্তি| ");
INSERT INTO sanasm_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","অপৰমপি কথিতৱান্ অস্মাৎ কাৰণাদ্ অকথযং পিতুঃ সকাশাৎ শক্ত্তিমপ্ৰাপ্য কোপি মমান্তিকম্ আগন্তুং ন শক্নোতি| ");
INSERT INTO sanasm_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","তৎকালেঽনেকে শিষ্যা ৱ্যাঘুট্য তেন সাৰ্দ্ধং পুন ৰ্নাগচ্ছন্| ");
INSERT INTO sanasm_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","তদা যীশু ৰ্দ্ৱাদশশিষ্যান্ উক্ত্তৱান্ যূযমপি কিং যাস্যথ? ");
INSERT INTO sanasm_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ততঃ শিমোন্ পিতৰঃ প্ৰত্যৱোচৎ হে প্ৰভো কস্যাভ্যৰ্ণং গমিষ্যামঃ? ");
INSERT INTO sanasm_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","অনন্তজীৱনদাযিন্যো যাঃ কথাস্তাস্তৱৈৱ| ভৱান্ অমৰেশ্ৱৰস্যাভিষিক্ত্তপুত্ৰ ইতি ৱিশ্ৱস্য নিশ্চিতং জানীমঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","তদা যীশুৰৱদৎ কিমহং যুষ্মাকং দ্ৱাদশজনান্ মনোনীতান্ ন কৃতৱান্? কিন্তু যুষ্মাকং মধ্যেপি কশ্চিদেকো ৱিঘ্নকাৰী ৱিদ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ইমাং কথং স শিমোনঃ পুত্ৰম্ ঈষ্কৰীযোতীযং যিহূদাম্ উদ্দিশ্য কথিতৱান্ যতো দ্ৱাদশানাং মধ্যে গণিতঃ স তং পৰকৰেষু সমৰ্পযিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","ততঃ পৰং যিহূদীযলোকাস্তং হন্তুং সমৈহন্ত তস্মাদ্ যীশু ৰ্যিহূদাপ্ৰদেশে পৰ্য্যটিতুং নেচ্ছন্ গালীল্ প্ৰদেশে পৰ্য্যটিতুং প্ৰাৰভত| ");
INSERT INTO sanasm_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","কিন্তু তস্মিন্ সমযে যিহূদীযানাং দূষ্যৱাসনামোৎসৱ উপস্থিতে ");
INSERT INTO sanasm_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","তস্য ভ্ৰাতৰস্তম্ অৱদন্ যানি কৰ্ম্মাণি ৎৱযা ক্ৰিযন্তে তানি যথা তৱ শিষ্যাঃ পশ্যন্তি তদৰ্থং ৎৱমিতঃ স্থানাদ্ যিহূদীযদেশং ৱ্ৰজ| ");
INSERT INTO sanasm_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","যঃ কশ্চিৎ স্ৱযং প্ৰচিকাশিষতি স কদাপি গুপ্তং কৰ্ম্ম ন কৰোতি যদীদৃশং কৰ্ম্ম কৰোষি তৰ্হি জগতি নিজং পৰিচাযয| ");
INSERT INTO sanasm_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","যতস্তস্য ভ্ৰাতৰোপি তং ন ৱিশ্ৱসন্তি| ");
INSERT INTO sanasm_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","তদা যীশুস্তান্ অৱোচৎ মম সময ইদানীং নোপতিষ্ঠতি কিন্তু যুষ্মাকং সমযঃ সততম্ উপতিষ্ঠতি| ");
INSERT INTO sanasm_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","জগতো লোকা যুষ্মান্ ঋতীযিতুং ন শক্ৰুৱন্তি কিন্তু মামেৱ ঋতীযন্তে যতস্তেষাং কৰ্মাণি দুষ্টানি তত্ৰ সাক্ষ্যমিদম্ অহং দদামি| ");
INSERT INTO sanasm_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","অতএৱ যূযম্ উৎসৱেঽস্মিন্ যাত নাহম্ ইদানীম্ অস্মিন্নুৎসৱে যামি যতো মম সময ইদানীং ন সম্পূৰ্ণঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ইতি ৱাক্যম্ উক্ত্ত্ৱা স গালীলি স্থিতৱান্ ");
INSERT INTO sanasm_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","কিন্তু তস্য ভ্ৰাতৃষু তত্ৰ প্ৰস্থিতেষু সৎসু সোঽপ্ৰকট উৎসৱম্ অগচ্ছৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","অনন্তৰম্ উৎসৱম্ উপস্থিতা যিহূদীযাস্তং মৃগযিৎৱাপৃচ্ছন্ স কুত্ৰ? ");
INSERT INTO sanasm_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","ততো লোকানাং মধ্যে তস্মিন্ নানাৱিধা ৱিৱাদা ভৱিতুম্ আৰব্ধৱন্তঃ| কেচিদ্ অৱোচন্ স উত্তমঃ পুৰুষঃ কেচিদ্ অৱোচন্ ন তথা ৱৰং লোকানাং ভ্ৰমং জনযতি| ");
INSERT INTO sanasm_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","কিন্তু যিহূদীযানাং ভযাৎ কোপি তস্য পক্ষে স্পষ্টং নাকথযৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ততঃ পৰম্ উৎসৱস্য মধ্যসমযে যীশু ৰ্মন্দিৰং গৎৱা সমুপদিশতি স্ম| ");
INSERT INTO sanasm_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ততো যিহূদীযা লোকা আশ্চৰ্য্যং জ্ঞাৎৱাকথযন্ এষা মানুষো নাধীত্যা কথম্ এতাদৃশো ৱিদ্ৱানভূৎ? ");
INSERT INTO sanasm_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","তদা যীশুঃ প্ৰত্যৱোচদ্ উপদেশোযং ন মম কিন্তু যো মাং প্ৰেষিতৱান্ তস্য| ");
INSERT INTO sanasm_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","যো জনো নিদেশং তস্য গ্ৰহীষ্যতি মমোপদেশো মত্তো ভৱতি কিম্ ঈশ্ৱৰাদ্ ভৱতি স গনস্তজ্জ্ঞাতুং শক্ষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","যো জনঃ স্ৱতঃ কথযতি স স্ৱীযং গৌৰৱম্ ঈহতে কিন্তু যঃ প্ৰেৰযিতু ৰ্গৌৰৱম্ ঈহতে স সত্যৱাদী তস্মিন্ কোপ্যধৰ্ম্মো নাস্তি| ");
INSERT INTO sanasm_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","মূসা যুষ্মভ্যং ৱ্যৱস্থাগ্ৰন্থং কিং নাদদাৎ? কিন্তু যুষ্মাকং কোপি তাং ৱ্যৱস্থাং ন সমাচৰতি| মাং হন্তুং কুতো যতধ্ৱে? ");
INSERT INTO sanasm_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","তদা লোকা অৱদন্ ৎৱং ভূতগ্ৰস্তস্ত্ৱাং হন্তুং কো যততে? ");
INSERT INTO sanasm_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ততো যীশুৰৱোচদ্ একং কৰ্ম্ম মযাকাৰি তস্মাদ্ যূযং সৰ্ৱ্ৱ মহাশ্চৰ্য্যং মন্যধ্ৱে| ");
INSERT INTO sanasm_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","মূসা যুষ্মভ্যং ৎৱক্ছেদৱিধিং প্ৰদদৌ স মূসাতো ন জাতঃ কিন্তু পিতৃপুৰুষেভ্যো জাতঃ তেন ৱিশ্ৰামৱাৰেঽপি মানুষাণাং ৎৱক্ছেদং কুৰুথ| ");
INSERT INTO sanasm_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","অতএৱ ৱিশ্ৰামৱাৰে মনুষ্যাণাং ৎৱক্ছেদে কৃতে যদি মূসাৱ্যৱস্থামঙ্গনং ন ভৱতি তৰ্হি মযা ৱিশ্ৰামৱাৰে মানুষঃ সম্পূৰ্ণৰূপেণ স্ৱস্থোঽকাৰি তৎকাৰণাদ্ যূযং কিং মহ্যং কুপ্যথ? ");
INSERT INTO sanasm_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","সপক্ষপাতং ৱিচাৰমকৃৎৱা ন্যায্যং ৱিচাৰং কুৰুত| ");
INSERT INTO sanasm_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","তদা যিৰূশালম্ নিৱাসিনঃ কতিপযজনা অকথযন্ ইমে যং হন্তুং চেষ্টন্তে স এৱাযং কিং ন? ");
INSERT INTO sanasm_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","কিন্তু পশ্যত নিৰ্ভযঃ সন্ কথাং কথযতি তথাপি কিমপি অ ৱদন্ত্যেতে অযমেৱাভিষিক্ত্তো ভৱতীতি নিশ্চিতং কিমধিপতযো জানন্তি? ");
INSERT INTO sanasm_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","মনুজোযং কস্মাদাগমদ্ ইতি ৱযং জানোমঃ কিন্ত্ৱভিষিক্ত্ত আগতে স কস্মাদাগতৱান্ ইতি কোপি জ্ঞাতুং ন শক্ষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","তদা যীশু ৰ্মধ্যেমন্দিৰম্ উপদিশন্ উচ্চৈঃকাৰম্ উক্ত্তৱান্ যূযং কিং মাং জানীথ? কস্মাচ্চাগতোস্মি তদপি কিং জানীথ? নাহং স্ৱত আগতোস্মি কিন্তু যঃ সত্যৱাদী সএৱ মাং প্ৰেষিতৱান্ যূযং তং ন জানীথ| ");
INSERT INTO sanasm_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","তমহং জানে তেনাহং প্ৰেৰিত অগতোস্মি| ");
INSERT INTO sanasm_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","তস্মাদ্ যিহূদীযাস্তং ধৰ্ত্তুম্ উদ্যতাস্তথাপি কোপি তস্য গাত্ৰে হস্তং নাৰ্পযদ্ যতো হেতোস্তদা তস্য সমযো নোপতিষ্ঠতি| ");
INSERT INTO sanasm_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","কিন্তু বহৱো লোকাস্তস্মিন্ ৱিশ্ৱস্য কথিতৱান্তোঽভিষিক্ত্তপুৰুষ আগত্য মানুষস্যাস্য ক্ৰিযাভ্যঃ কিম্ অধিকা আশ্চৰ্য্যাঃ ক্ৰিযাঃ কৰিষ্যতি? ");
INSERT INTO sanasm_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","ততঃ পৰং লোকাস্তস্মিন্ ইত্থং ৱিৱদন্তে ফিৰূশিনঃ প্ৰধানযাজকাঞ্চেতি শ্ৰুতৱন্তস্তং ধৃৎৱা নেতুং পদাতিগণং প্ৰেষযামাসুঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ততো যীশুৰৱদদ্ অহম্ অল্পদিনানি যুষ্মাভিঃ সাৰ্দ্ধং স্থিৎৱা মৎপ্ৰেৰযিতুঃ সমীপং যাস্যামি| ");
INSERT INTO sanasm_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","মাং মৃগযিষ্যধ্ৱে কিন্তূদ্দেশং ন লপ্স্যধ্ৱে ৰত্ৰ স্থাস্যামি তত্ৰ যূযং গন্তুং ন শক্ষ্যথ| ");
INSERT INTO sanasm_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","তদা যিহূদীযাঃ পৰস্পৰং ৱক্ত্তুমাৰেভিৰে অস্যোদ্দেশং ন প্ৰাপ্স্যাম এতাদৃশং কিং স্থানং যাস্যতি? ভিন্নদেশে ৱিকীৰ্ণানাং যিহূদীযানাং সন্নিধিম্ এষ গৎৱা তান্ উপদেক্ষ্যতি কিং? ");
INSERT INTO sanasm_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","নো চেৎ মাং গৱেষযিষ্যথ কিন্তূদ্দেশং ন প্ৰাপ্স্যথ এষ কোদৃশং ৱাক্যমিদং ৱদতি? ");
INSERT INTO sanasm_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","অনন্তৰম্ উৎসৱস্য চৰমেঽহনি অৰ্থাৎ প্ৰধানদিনে যীশুৰুত্তিষ্ঠন্ উচ্চৈঃকাৰম্ আহ্ৱযন্ উদিতৱান্ যদি কশ্চিৎ তৃষাৰ্ত্তো ভৱতি তৰ্হি মমান্তিকম্ আগত্য পিৱতু| ");
INSERT INTO sanasm_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","যঃ কশ্চিন্মযি ৱিশ্ৱসিতি ধৰ্ম্মগ্ৰন্থস্য ৱচনানুসাৰেণ তস্যাভ্যন্তৰতোঽমৃততোযস্য স্ৰোতাংসি নিৰ্গমিষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","যে তস্মিন্ ৱিশ্ৱসন্তি ত আত্মানং প্ৰাপ্স্যন্তীত্যৰ্থে স ইদং ৱাক্যং ৱ্যাহৃতৱান্ এতৎকালং যাৱদ্ যীশু ৰ্ৱিভৱং ন প্ৰাপ্তস্তস্মাৎ পৱিত্ৰ আত্মা নাদীযত| ");
INSERT INTO sanasm_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","এতাং ৱাণীং শ্ৰুৎৱা বহৱো লোকা অৱদন্ অযমেৱ নিশ্চিতং স ভৱিষ্যদ্ৱাদী| ");
INSERT INTO sanasm_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","কেচিদ্ অকথযন্ এষএৱ সোভিষিক্ত্তঃ কিন্তু কেচিদ্ অৱদন্ সোভিষিক্ত্তঃ কিং গালীল্ প্ৰদেশে জনিষ্যতে? ");
INSERT INTO sanasm_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","সোভিষিক্ত্তো দাযূদো ৱংশে দাযূদো জন্মস্থানে বৈৎলেহমি পত্তনে জনিষ্যতে ধৰ্ম্মগ্ৰন্থে কিমিত্থং লিখিতং নাস্তি? ");
INSERT INTO sanasm_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ইত্থং তস্মিন্ লোকানাং ভিন্নৱাক্যতা জাতা| ");
INSERT INTO sanasm_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","কতিপযলোকাস্তং ধৰ্ত্তুম্ ঐচ্ছন্ তথাপি তদ্ৱপুষি কোপি হস্তং নাৰ্পযৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","অনন্তৰং পাদাতিগণে প্ৰধানযাজকানাং ফিৰূশিনাঞ্চ সমীপমাগতৱতি তে তান্ অপৃচ্ছন্ কুতো হেতোস্তং নানযত? ");
INSERT INTO sanasm_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","তদা পদাতযঃ প্ৰত্যৱদন্ স মানৱ ইৱ কোপি কদাপি নোপাদিশৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ততঃ ফিৰূশিনঃ প্ৰাৱোচন্ যূযমপি কিমভ্ৰামিষ্ট? ");
INSERT INTO sanasm_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","অধিপতীনাং ফিৰূশিনাঞ্চ কোপি কিং তস্মিন্ ৱ্যশ্ৱসীৎ? ");
INSERT INTO sanasm_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","যে শাস্ত্ৰং ন জানন্তি ত ইমেঽধমলোকাএৱ শাপগ্ৰস্তাঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","তদা নিকদীমনামা তেষামেকো যঃ ক্ষণদাযাং যীশোঃ সন্নিধিম্ অগাৎ স উক্ত্তৱান্ ");
INSERT INTO sanasm_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","তস্য ৱাক্যে ন শ্ৰুতে কৰ্ম্মণি চ ন ৱিদিতে ঽস্মাকং ৱ্যৱস্থা কিং কঞ্চন মনুজং দোষীকৰোতি? ");
INSERT INTO sanasm_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ততস্তে ৱ্যাহৰন্ ৎৱমপি কিং গালীলীযলোকঃ? ৱিৱিচ্য পশ্য গলীলি কোপি ভৱিষ্যদ্ৱাদী নোৎপদ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","ততঃ পৰং সৰ্ৱ্ৱে স্ৱং স্ৱং গৃহং গতাঃ কিন্তু যীশু ৰ্জৈতুননামানং শিলোচ্চযং গতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","প্ৰত্যূষে যীশুঃ পনৰ্মন্দিৰম্ আগচ্ছৎ ");
INSERT INTO sanasm_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ততঃ সৰ্ৱ্ৱেষু লোকেষু তস্য সমীপ আগতেষু স উপৱিশ্য তান্ উপদেষ্টুম্ আৰভত| ");
INSERT INTO sanasm_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","তদা অধ্যাপকাঃ ফিৰূশিনঞ্চ ৱ্যভিচাৰকৰ্ম্মণি ধৃতং স্ত্ৰিযমেকাম্ আনিয সৰ্ৱ্ৱেষাং মধ্যে স্থাপযিৎৱা ৱ্যাহৰন্ ");
INSERT INTO sanasm_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","হে গুৰো যোষিতম্ ইমাং ৱ্যভিচাৰকৰ্ম্ম কুৰ্ৱ্ৱাণাং লোকা ধৃতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","এতাদৃশলোকাঃ পাষাণাঘাতেন হন্তৱ্যা ইতি ৱিধিৰ্মূসাৱ্যৱস্থাগ্ৰন্থে লিখিতোস্তি কিন্তু ভৱান্ কিমাদিশতি? ");
INSERT INTO sanasm_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","তে তমপৱদিতুং পৰীক্ষাভিপ্ৰাযেণ ৱাক্যমিদম্ অপৃচ্ছন্ কিন্তু স প্ৰহ্ৱীভূয ভূমাৱঙ্গল্যা লেখিতুম্ আৰভত| ");
INSERT INTO sanasm_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ততস্তৈঃ পুনঃ পুনঃ পৃষ্ট উত্থায কথিতৱান্ যুষ্মাকং মধ্যে যো জনো নিৰপৰাধী সএৱ প্ৰথমম্ এনাং পাষাণেনাহন্তু| ");
INSERT INTO sanasm_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","পশ্চাৎ স পুনশ্চ প্ৰহ্ৱীভূয ভূমৌ লেখিতুম্ আৰভত| ");
INSERT INTO sanasm_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","তাং কথং শ্ৰুৎৱা তে স্ৱস্ৱমনসি প্ৰবোধং প্ৰাপ্য জ্যেষ্ঠানুক্ৰমং একৈকশঃ সৰ্ৱ্ৱে বহিৰগচ্ছন্ ততো যীশুৰেকাকী তযক্ত্তোভৱৎ মধ্যস্থানে দণ্ডাযমানা সা যোষা চ স্থিতা| ");
INSERT INTO sanasm_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","তৎপশ্চাদ্ যীশুৰুত্থায তাং ৱনিতাং ৱিনা কমপ্যপৰং ন ৱিলোক্য পৃষ্টৱান্ হে ৱামে তৱাপৱাদকাঃ কুত্ৰ? কোপি ৎৱাং কিং ন দণ্ডযতি? ");
INSERT INTO sanasm_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","সাৱদৎ হে মহেচ্ছ কোপি ন তদা যীশুৰৱোচৎ নাহমপি দণ্ডযামি যাহি পুনঃ পাপং মাকাৰ্ষীঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","ততো যীশুঃ পুনৰপি লোকেভ্য ইত্থং কথযিতুম্ আৰভত জগতোহং জ্যোতিঃস্ৱৰূপো যঃ কশ্চিন্ মৎপশ্চাদ গচ্ছতি স তিমিৰে ন ভ্ৰমিৎৱা জীৱনৰূপাং দীপ্তিং প্ৰাপ্স্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ততঃ ফিৰূশিনোঽৱাদিষুস্ত্ৱং স্ৱাৰ্থে স্ৱযং সাক্ষ্যং দদাসি তস্মাৎ তৱ সাক্ষ্যং গ্ৰাহ্যং ন ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","তদা যীশুঃ প্ৰত্যুদিতৱান্ যদ্যপি স্ৱাৰ্থেঽহং স্ৱযং সাক্ষ্যং দদামি তথাপি মৎ সাক্ষ্যং গ্ৰাহ্যং যস্মাদ্ অহং কুত আগতোস্মি ক্ৱ যামি চ তদহং জানামি কিন্তু কুত আগতোস্মি কুত্ৰ গচ্ছামি চ তদ্ যূযং ন জানীথ| ");
INSERT INTO sanasm_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","যূযং লৌকিকং ৱিচাৰযথ নাহং কিমপি ৱিচাৰযামি| ");
INSERT INTO sanasm_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","কিন্তু যদি ৱিচাৰযামি তৰ্হি মম ৱিচাৰো গ্ৰহীতৱ্যো যতোহম্ একাকী নাস্মি প্ৰেৰযিতা পিতা মযা সহ ৱিদ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","দ্ৱযো ৰ্জনযোঃ সাক্ষ্যং গ্ৰহণীযং ভৱতীতি যুষ্মাকং ৱ্যৱস্থাগ্ৰন্থে লিখিতমস্তি| ");
INSERT INTO sanasm_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","অহং স্ৱাৰ্থে স্ৱযং সাক্ষিৎৱং দদামি যশ্চ মম তাতো মাং প্ৰেৰিতৱান্ সোপি মদৰ্থে সাক্ষ্যং দদাতি| ");
INSERT INTO sanasm_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","তদা তেঽপৃচ্ছন্ তৱ তাতঃ কুত্ৰ? ততো যীশুঃ প্ৰত্যৱাদীদ্ যূযং মাং ন জানীথ মৎপিতৰঞ্চ ন জানীথ যদি মাম্ অক্ষাস্যত তৰ্হি মম তাতমপ্যক্ষাস্যত| ");
INSERT INTO sanasm_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","যীশু ৰ্মন্দিৰ উপদিশ্য ভণ্ডাগাৰে কথা এতা অকথযৎ তথাপি তং প্ৰতি কোপি কৰং নোদতোলযৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ততঃ পৰং যীশুঃ পুনৰুদিতৱান্ অধুনাহং গচ্ছামি যূযং মাং গৱেষযিষ্যথ কিন্তু নিজৈঃ পাপৈ ৰ্মৰিষ্যথ যৎ স্থানম্ অহং যাস্যামি তৎ স্থানম্ যূযং যাতুং ন শক্ষ্যথ| ");
INSERT INTO sanasm_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","তদা যিহূদীযাঃ প্ৰাৱোচন্ কিমযম্ আত্মঘাতং কৰিষ্যতি? যতো যৎ স্থানম্ অহং যাস্যামি তৎ স্থানম্ যূযং যাতুং ন শক্ষ্যথ ইতি ৱাক্যং ব্ৰৱীতি| ");
INSERT INTO sanasm_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ততো যীশুস্তেভ্যঃ কথিতৱান্ যূযম্ অধঃস্থানীযা লোকা অহম্ ঊৰ্দ্ৱ্ৱস্থানীযঃ যূযম্ এতজ্জগৎসম্বন্ধীযা অহম্ এতজ্জগৎসম্বন্ধীযো ন| ");
INSERT INTO sanasm_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","তস্মাৎ কথিতৱান্ যূযং নিজৈঃ পাপৈ ৰ্মৰিষ্যথ যতোহং স পুমান্ ইতি যদি ন ৱিশ্ৱসিথ তৰ্হি নিজৈঃ পাপৈ ৰ্মৰিষ্যথ| ");
INSERT INTO sanasm_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","তদা তে ঽপৃচ্ছন্ কস্ত্ৱং? ততো যীশুঃ কথিতৱান্ যুষ্মাকং সন্নিধৌ যস্য প্ৰস্তাৱম্ আ প্ৰথমাৎ কৰোমি সএৱ পুৰুষোহং| ");
INSERT INTO sanasm_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","যুষ্মাসু মযা বহুৱাক্যং ৱক্ত্তৱ্যং ৱিচাৰযিতৱ্যঞ্চ কিন্তু মৎপ্ৰেৰযিতা সত্যৱাদী তস্য সমীপে যদহং শ্ৰুতৱান্ তদেৱ জগতে কথযামি| ");
INSERT INTO sanasm_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","কিন্তু স জনকে ৱাক্যমিদং প্ৰোক্ত্তৱান্ ইতি তে নাবুধ্যন্ত| ");
INSERT INTO sanasm_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ততো যীশুৰকথযদ্ যদা মনুষ্যপুত্ৰম্ ঊৰ্দ্ৱ্ৱ উত্থাপযিষ্যথ তদাহং স পুমান্ কেৱলঃ স্ৱযং কিমপি কৰ্ম্ম ন কৰোমি কিন্তু তাতো যথা শিক্ষযতি তদনুসাৰেণ ৱাক্যমিদং ৱদামীতি চ যূযং জ্ঞাতুং শক্ষ্যথ| ");
INSERT INTO sanasm_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","মৎপ্ৰেৰযিতা পিতা মাম্ একাকিনং ন ত্যজতি স মযা সাৰ্দ্ধং তিষ্ঠতি যতোহং তদভিমতং কৰ্ম্ম সদা কৰোমি| ");
INSERT INTO sanasm_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","তদা তস্যৈতানি ৱাক্যানি শ্ৰুৎৱা বহুৱস্তাস্মিন্ ৱ্যশ্ৱসন্| ");
INSERT INTO sanasm_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","যে যিহূদীযা ৱ্যশ্ৱসন্ যীশুস্তেভ্যোঽকথযৎ ");
INSERT INTO sanasm_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","মম ৱাক্যে যদি যূযম্ আস্থাং কুৰুথ তৰ্হি মম শিষ্যা ভূৎৱা সত্যৎৱং জ্ঞাস্যথ ততঃ সত্যতযা যুষ্মাকং মোক্ষো ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","তদা তে প্ৰত্যৱাদিষুঃ ৱযম্ ইব্ৰাহীমো ৱংশঃ কদাপি কস্যাপি দাসা ন জাতাস্তৰ্হি যুষ্মাকং মুক্ত্তি ৰ্ভৱিষ্যতীতি ৱাক্যং কথং ব্ৰৱীষি? ");
INSERT INTO sanasm_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","তদা যীশুঃ প্ৰত্যৱদদ্ যুষ্মানহং যথাৰ্থতৰং ৱদামি যঃ পাপং কৰোতি স পাপস্য দাসঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","দাসশ্চ নিৰন্তৰং নিৱেশনে ন তিষ্ঠতি কিন্তু পুত্ৰো নিৰন্তৰং তিষ্ঠতি| ");
INSERT INTO sanasm_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","অতঃ পুত্ৰো যদি যুষ্মান্ মোচযতি তৰ্হি নিতান্তমেৱ মুক্ত্তা ভৱিষ্যথ| ");
INSERT INTO sanasm_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","যুযম্ ইব্ৰাহীমো ৱংশ ইত্যহং জানামি কিন্তু মম কথা যুষ্মাকম্ অন্তঃকৰণেষু স্থানং ন প্ৰাপ্নুৱন্তি তস্মাদ্ধেতো ৰ্মাং হন্তুম্ ঈহধ্ৱে| ");
INSERT INTO sanasm_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","অহং স্ৱপিতুঃ সমীপে যদপশ্যং তদেৱ কথযামি তথা যূযমপি স্ৱপিতুঃ সমীপে যদপশ্যত তদেৱ কুৰুধ্ৱে| ");
INSERT INTO sanasm_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","তদা তে প্ৰত্যৱোচন্ ইব্ৰাহীম্ অস্মাকং পিতা ততো যীশুৰকথযদ্ যদি যূযম্ ইব্ৰাহীমঃ সন্তানা অভৱিষ্যত তৰ্হি ইব্ৰাহীম আচাৰণৱদ্ আচৰিষ্যত| ");
INSERT INTO sanasm_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ঈশ্ৱৰস্য মুখাৎ সত্যং ৱাক্যং শ্ৰুৎৱা যুষ্মান্ জ্ঞাপযামি যোহং তং মাং হন্তুং চেষ্টধ্ৱে ইব্ৰাহীম্ এতাদৃশং কৰ্ম্ম ন চকাৰ| ");
INSERT INTO sanasm_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","যূযং স্ৱস্ৱপিতুঃ কৰ্ম্মাণি কুৰুথ তদা তৈৰুক্ত্তং ন ৱযং জাৰজাতা অস্মাকম্ একএৱ পিতাস্তি স এৱেশ্ৱৰঃ ");
INSERT INTO sanasm_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ততো যীশুনা কথিতম্ ঈশ্ৱৰো যদি যুষ্মাকং তাতোভৱিষ্যৎ তৰ্হি যূযং মযি প্ৰেমাকৰিষ্যত যতোহম্ ঈশ্ৱৰান্নিৰ্গত্যাগতোস্মি স্ৱতো নাগতোহং স মাং প্ৰাহিণোৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","যূযং মম ৱাক্যমিদং ন বুধ্যধ্ৱে কুতঃ? যতো যূযং মমোপদেশং সোঢুং ন শক্নুথ| ");
INSERT INTO sanasm_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","যূযং শৈতান্ পিতুঃ সন্তানা এতস্মাদ্ যুষ্মাকং পিতুৰভিলাষং পূৰযথ স আ প্ৰথমাৎ নৰঘাতী তদন্তঃ সত্যৎৱস্য লেশোপি নাস্তি কাৰণাদতঃ স সত্যতাযাং নাতিষ্ঠৎ স যদা মৃষা কথযতি তদা নিজস্ৱভাৱানুসাৰেণৈৱ কথযতি যতো স মৃষাভাষী মৃষোৎপাদকশ্চ| ");
INSERT INTO sanasm_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","অহং তথ্যৱাক্যং ৱদামি কাৰণাদস্মাদ্ যূযং মাং ন প্ৰতীথ| ");
INSERT INTO sanasm_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","মযি পাপমস্তীতি প্ৰমাণং যুষ্মাকং কো দাতুং শক্নোতি? যদ্যহং তথ্যৱাক্যং ৱদামি তৰ্হি কুতো মাং ন প্ৰতিথ? ");
INSERT INTO sanasm_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","যঃ কশ্চন ঈশ্ৱৰীযো লোকঃ স ঈশ্ৱৰীযকথাযাং মনো নিধত্তে যূযম্ ঈশ্ৱৰীযলোকা ন ভৱথ তন্নিদানাৎ তত্ৰ ন মনাংসি নিধদ্ৱে| ");
INSERT INTO sanasm_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","তদা যিহূদীযাঃ প্ৰত্যৱাদিষুঃ ৎৱমেকঃ শোমিৰোণীযো ভূতগ্ৰস্তশ্চ ৱযং কিমিদং ভদ্ৰং নাৱাদিষ্ম? ");
INSERT INTO sanasm_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ততো যীশুঃ প্ৰত্যৱাদীৎ নাহং ভূতগ্ৰস্তঃ কিন্তু নিজতাতং সম্মন্যে তস্মাদ্ যূযং মাম্ অপমন্যধ্ৱে| ");
INSERT INTO sanasm_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","অহং স্ৱসুখ্যাতিং ন চেষ্টে কিন্তু চেষ্টিতা ৱিচাৰযিতা চাপৰ এক আস্তে| ");
INSERT INTO sanasm_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","অহং যুষ্মভ্যম্ অতীৱ যথাৰ্থং কথযামি যো নৰো মদীযং ৱাচং মন্যতে স কদাচন নিধনং ন দ্ৰক্ষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","যিহূদীযাস্তমৱদন্ ৎৱং ভূতগ্ৰস্ত ইতীদানীম্ অৱৈষ্ম| ইব্ৰাহীম্ ভৱিষ্যদ্ৱাদিনঞ্চ সৰ্ৱ্ৱে মৃতাঃ কিন্তু ৎৱং ভাষসে যো নৰো মম ভাৰতীং গৃহ্লাতি স জাতু নিধানাস্ৱাদং ন লপ্স্যতে| ");
INSERT INTO sanasm_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","তৰ্হি ৎৱং কিম্ অস্মাকং পূৰ্ৱ্ৱপুৰুষাদ্ ইব্ৰাহীমোপি মহান্? যস্মাৎ সোপি মৃতঃ ভৱিষ্যদ্ৱাদিনোপি মৃতাঃ ৎৱং স্ৱং কং পুমাংসং মনুষে? ");
INSERT INTO sanasm_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","যীশুঃ প্ৰত্যৱোচদ্ যদ্যহং স্ৱং স্ৱযং সম্মন্যে তৰ্হি মম তৎ সম্মননং কিমপি ন কিন্তু মম তাতো যং যূযং স্ৱীযম্ ঈশ্ৱৰং ভাষধ্ৱে সএৱ মাং সম্মনুতে| ");
INSERT INTO sanasm_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","যূযং তং নাৱগচ্ছথ কিন্ত্ৱহং তমৱগচ্ছামি তং নাৱগচ্ছামীতি ৱাক্যং যদি ৱদামি তৰ্হি যূযমিৱ মৃষাভাষী ভৱামি কিন্ত্ৱহং তমৱগচ্ছামি তদাক্ষামপি গৃহ্লামি| ");
INSERT INTO sanasm_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","যুষ্মাকং পূৰ্ৱ্ৱপুৰুষ ইব্ৰাহীম্ মম সমযং দ্ৰষ্টুম্ অতীৱাৱাঞ্ছৎ তন্নিৰীক্ষ্যানন্দচ্চ| ");
INSERT INTO sanasm_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","তদা যিহূদীযা অপৃচ্ছন্ তৱ ৱযঃ পঞ্চাশদ্ৱৎসৰা ন ৎৱং কিম্ ইব্ৰাহীমম্ অদ্ৰাক্ষীঃ? ");
INSERT INTO sanasm_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","যীশুঃ প্ৰত্যৱাদীদ্ যুষ্মানহং যথাৰ্থতৰং ৱদামি ইব্ৰাহীমো জন্মনঃ পূৰ্ৱ্ৱকালমাৰভ্যাহং ৱিদ্যে| ");
INSERT INTO sanasm_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","তদা তে পাষাণান্ উত্তোল্য তমাহন্তুম্ উদযচ্ছন্ কিন্তু যীশু ৰ্গুপ্তো মন্তিৰাদ্ বহিৰ্গত্য তেষাং মধ্যেন প্ৰস্থিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","ততঃ পৰং যীশুৰ্গচ্ছন্ মাৰ্গমধ্যে জন্মান্ধং নৰম্ অপশ্যৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ততঃ শিষ্যাস্তম্ অপৃচ্ছন্ হে গুৰো নৰোযং স্ৱপাপেন ৱা স্ৱপিত্ৰাঃ পাপেনান্ধোঽজাযত? ");
INSERT INTO sanasm_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","ততঃ স প্ৰত্যুদিতৱান্ এতস্য ৱাস্য পিত্ৰোঃ পাপাদ্ এতাদৃশোভূদ ইতি নহি কিন্ত্ৱনেন যথেশ্ৱৰস্য কৰ্ম্ম প্ৰকাশ্যতে তদ্ধেতোৰেৱ| ");
INSERT INTO sanasm_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","দিনে তিষ্ঠতি মৎপ্ৰেৰযিতুঃ কৰ্ম্ম মযা কৰ্ত্তৱ্যং যদা কিমপি কৰ্ম্ম ন ক্ৰিযতে তাদৃশী নিশাগচ্ছতি| ");
INSERT INTO sanasm_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","অহং যাৱৎকালং জগতি তিষ্ঠামি তাৱৎকালং জগতো জ্যোতিঃস্ৱৰূপোস্মি| ");
INSERT INTO sanasm_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ইত্যুক্ত্তা ভূমৌ নিষ্ঠীৱং নিক্ষিপ্য তেন পঙ্কং কৃতৱান্ ");
INSERT INTO sanasm_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","পশ্চাৎ তৎপঙ্কেন তস্যান্ধস্য নেত্ৰে প্ৰলিপ্য তমিত্যাদিশৎ গৎৱা শিলোহে ঽৰ্থাৎ প্ৰেৰিতনাম্নি সৰসি স্নাহি| ততোন্ধো গৎৱা তত্ৰাস্নাৎ ততঃ প্ৰন্নচক্ষু ৰ্ভূৎৱা ৱ্যাঘুট্যাগাৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","অপৰঞ্চ সমীপৱাসিনো লোকা যে চ তং পূৰ্ৱ্ৱমন্ধম্ অপশ্যন্ তে বক্ত্তুম্ আৰভন্ত যোন্ধলোকো ৱৰ্ত্মন্যুপৱিশ্যাভিক্ষত স এৱাযং জনঃ কিং ন ভৱতি? ");
INSERT INTO sanasm_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","কেচিদৱদন্ স এৱ কেচিদৱোচন্ তাদৃশো ভৱতি কিন্তু স স্ৱযমব্ৰৱীৎ স এৱাহং ভৱামি| ");
INSERT INTO sanasm_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","অতএৱ তে ঽপৃচ্ছন্ ৎৱং কথং দৃষ্টিং পাপ্তৱান্? ");
INSERT INTO sanasm_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ততঃ সোৱদদ্ যীশনামক একো জনো মম নযনে পঙ্কেন প্ৰলিপ্য ইত্যাজ্ঞাপযৎ শিলোহকাসাৰং গৎৱা তত্ৰ স্নাহি| ততস্তত্ৰ গৎৱা মযি স্নাতে দৃষ্টিমহং লব্ধৱান্| ");
INSERT INTO sanasm_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","তদা তে ঽৱদন্ স পুমান্ কুত্ৰ? তেনোক্ত্তং নাহং জানামি| ");
INSERT INTO sanasm_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","অপৰং তস্মিন্ পূৰ্ৱ্ৱান্ধে জনে ফিৰূশিনাং নিকটম্ আনীতে সতি ফিৰূশিনোপি তমপৃচ্ছন্ কথং দৃষ্টিং প্ৰাপ্তোসি? ");
INSERT INTO sanasm_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ততঃ স কথিতৱান্ স পঙ্কেন মম নেত্ৰে ঽলিম্পৎ পশ্চাদ্ স্নাৎৱা দৃষ্টিমলভে| ");
INSERT INTO sanasm_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","কিন্তু যীশু ৰ্ৱিশ্ৰামৱাৰে কৰ্দ্দমং কৃৎৱা তস্য নযনে প্ৰসন্নেঽকৰোদ্ ইতিকাৰণাৎ কতিপযফিৰূশিনোঽৱদন্ ");
INSERT INTO sanasm_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","স পুমান্ ঈশ্ৱৰান্ন যতঃ স ৱিশ্ৰামৱাৰং ন মন্যতে| ততোন্যে কেচিৎ প্ৰত্যৱদন্ পাপী পুমান্ কিম্ এতাদৃশম্ আশ্চৰ্য্যং কৰ্ম্ম কৰ্ত্তুং শক্নোতি? ");
INSERT INTO sanasm_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ইত্থং তেষাং পৰস্পৰং ভিন্নৱাক্যৎৱম্ অভৱৎ| পশ্চাৎ তে পুনৰপি তং পূৰ্ৱ্ৱান্ধং মানুষম্ অপ্ৰাক্ষুঃ যো জনস্তৱ চক্ষুষী প্ৰসন্নে কৃতৱান্ তস্মিন্ ৎৱং কিং ৱদসি? স উক্ত্তৱান্ স ভৱিশদ্ৱাদী| ");
INSERT INTO sanasm_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","স দৃষ্টিম্ আপ্তৱান্ ইতি যিহূদীযাস্তস্য দৃষ্টিং প্ৰাপ্তস্য জনস্য পিত্ৰো ৰ্মুখাদ্ অশ্ৰুৎৱা ন প্ৰত্যযন্| ");
INSERT INTO sanasm_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","অতএৱ তে তাৱপৃচ্ছন্ যুৱযো ৰ্যং পুত্ৰং জন্মান্ধং ৱদথঃ স কিমযং? তৰ্হীদানীং কথং দ্ৰষ্টুং শক্নোতি? ");
INSERT INTO sanasm_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ততস্তস্য পিতৰৌ প্ৰত্যৱোচতাম্ অযম্ আৱযোঃ পুত্ৰ আ জনেৰন্ধশ্চ তদপ্যাৱাং জানীৱঃ ");
INSERT INTO sanasm_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","কিন্ত্ৱধুনা কথং দৃষ্টিং প্ৰাপ্তৱান্ তদাৱাং ন্ জানীৱঃ কোস্য চক্ষুষী প্ৰসন্নে কৃতৱান্ তদপি ন জানীৱ এষ ৱযঃপ্ৰাপ্ত এনং পৃচ্ছত স্ৱকথাং স্ৱযং ৱক্ষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","যিহূদীযানাং ভযাৎ তস্য পিতৰৌ ৱাক্যমিদম্ অৱদতাং যতঃ কোপি মনুষ্যো যদি যীশুম্ অভিষিক্তং ৱদতি তৰ্হি স ভজনগৃহাদ্ দূৰীকাৰিষ্যতে যিহূদীযা ইতি মন্ত্ৰণাম্ অকুৰ্ৱ্ৱন্ ");
INSERT INTO sanasm_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","অতস্তস্য পিতৰৌ ৱ্যাহৰতাম্ এষ ৱযঃপ্ৰাপ্ত এনং পৃচ্ছত| ");
INSERT INTO sanasm_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","তদা তে পুনশ্চ তং পূৰ্ৱ্ৱান্ধম্ আহূয ৱ্যাহৰন্ ঈশ্ৱৰস্য গুণান্ ৱদ এষ মনুষ্যঃ পাপীতি ৱযং জানীমঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","তদা স উক্ত্তৱান্ স পাপী ন ৱেতি নাহং জানে পূৰ্ৱামন্ধ আসমহম্ অধুনা পশ্যামীতি মাত্ৰং জানামি| ");
INSERT INTO sanasm_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","তে পুনৰপৃচ্ছন্ স ৎৱাং প্ৰতি কিমকৰোৎ? কথং নেত্ৰে প্ৰসন্নে ঽকৰোৎ? ");
INSERT INTO sanasm_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","ততঃ সোৱাদীদ্ এককৃৎৱোকথযং যূযং ন শৃণুথ তৰ্হি কুতঃ পুনঃ শ্ৰোতুম্ ইচ্ছথ? যূযমপি কিং তস্য শিষ্যা ভৱিতুম্ ইচ্ছথ? ");
INSERT INTO sanasm_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","তদা তে তং তিৰস্কৃত্য ৱ্যাহৰন্ ৎৱং তস্য শিষ্যো ৱযং মূসাঃ শিষ্যাঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","মূসাৱক্ত্ৰেণেশ্ৱৰো জগাদ তজ্জানীমঃ কিন্ত্ৱেষ কুত্ৰত্যলোক ইতি ন জানীমঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","সোৱদদ্ এষ মম লোচনে প্ৰসন্নে ঽকৰোৎ তথাপি কুত্ৰত্যলোক ইতি যূযং ন জানীথ এতদ্ আশ্চৰ্য্যং ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ঈশ্ৱৰঃ পাপিনাং কথাং ন শৃণোতি কিন্তু যো জনস্তস্মিন্ ভক্তিং কৃৎৱা তদিষ্টক্ৰিযাং কৰোতি তস্যৈৱ কথাং শৃণোতি এতদ্ ৱযং জানীমঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","কোপি মনুষ্যো জন্মান্ধায চক্ষুষী অদদাৎ জগদাৰম্ভাদ্ এতাদৃশীং কথাং কোপি কদাপি নাশৃণোৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","অস্মাদ্ এষ মনুষ্যো যদীশ্ৱৰান্নাজাযত তৰ্হি কিঞ্চিদপীদৃশং কৰ্ম্ম কৰ্ত্তুং নাশক্নোৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","তে ৱ্যাহৰন্ ৎৱং পাপাদ্ অজাযথাঃ কিমস্মান্ ৎৱং শিক্ষযসি? পশ্চাত্তে তং বহিৰকুৰ্ৱ্ৱন্| ");
INSERT INTO sanasm_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","তদনন্তৰং যিহূদীযৈঃ স বহিৰক্ৰিযত যীশুৰিতি ৱাৰ্ত্তাং শ্ৰুৎৱা তং সাক্ষাৎ প্ৰাপ্য পৃষ্টৱান্ ঈশ্ৱৰস্য পুত্ৰে ৎৱং ৱিশ্ৱসিষি? ");
INSERT INTO sanasm_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","তদা স প্ৰত্যৱোচৎ হে প্ৰভো স কো যৎ তস্মিন্নহং ৱিশ্ৱসিমি? ");
INSERT INTO sanasm_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","ততো যীশুঃ কথিতৱান্ ৎৱং তং দৃষ্টৱান্ ৎৱযা সাকং যঃ কথং কথযতি সএৱ সঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","তদা হে প্ৰভো ৱিশ্ৱসিমীত্যুক্ত্ৱা স তং প্ৰণামৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","পশ্চাদ্ যীশুঃ কথিতৱান্ নযনহীনা নযনানি প্ৰাপ্নুৱন্তি নযনৱন্তশ্চান্ধা ভৱন্তীত্যভিপ্ৰাযেণ জগদাহম্ আগচ্ছম্| ");
INSERT INTO sanasm_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","এতৎ শ্ৰুৎৱা নিকটস্থাঃ কতিপযাঃ ফিৰূশিনো ৱ্যাহৰন্ ৱযমপি কিমন্ধাঃ? ");
INSERT INTO sanasm_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","তদা যীশুৰৱাদীদ্ যদ্যন্ধা অভৱত তৰ্হি পাপানি নাতিষ্ঠন্ কিন্তু পশ্যামীতি ৱাক্যৱদনাদ্ যুষ্মাকং পাপানি তিষ্ঠন্তি| ");
INSERT INTO sanasm_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","অহং যুষ্মানতিযথাৰ্থং ৱদামি, যো জনো দ্ৱাৰেণ ন প্ৰৱিশ্য কেনাপ্যন্যেন মেষগৃহং প্ৰৱিশতি স এৱ স্তেনো দস্যুশ্চ| ");
INSERT INTO sanasm_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","যো দ্ৱাৰেণ প্ৰৱিশতি স এৱ মেষপালকঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","দৌৱাৰিকস্তস্মৈ দ্ৱাৰং মোচযতি মেষগণশ্চ তস্য ৱাক্যং শৃণোতি স নিজান্ মেষান্ স্ৱস্ৱনাম্নাহূয বহিঃ কৃৎৱা নযতি| ");
INSERT INTO sanasm_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","তথা নিজান্ মেষান্ বহিঃ কৃৎৱা স্ৱযং তেষাম্ অগ্ৰে গচ্ছতি, ততো মেষাস্তস্য শব্দং বুধ্যন্তে, তস্মাৎ তস্য পশ্চাদ্ ৱ্ৰজন্তি| ");
INSERT INTO sanasm_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","কিন্তু পৰস্য শব্দং ন বুধ্যন্তে তস্মাৎ তস্য পশ্চাদ্ ৱ্ৰজিষ্যন্তি ৱৰং তস্য সমীপাৎ পলাযিষ্যন্তে| ");
INSERT INTO sanasm_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","যীশুস্তেভ্য ইমাং দৃষ্টান্তকথাম্ অকথযৎ কিন্তু তেন কথিতকথাযাস্তাৎপৰ্য্যং তে নাবুধ্যন্ত| ");
INSERT INTO sanasm_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","অতো যীশুঃ পুনৰকথযৎ, যুষ্মানাহং যথাৰ্থতৰং ৱ্যাহৰামি, মেষগৃহস্য দ্ৱাৰম্ অহমেৱ| ");
INSERT INTO sanasm_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","মযা ন প্ৰৱিশ্য য আগচ্ছন্ তে স্তেনা দস্যৱশ্চ কিন্তু মেষাস্তেষাং কথা নাশৃণ্ৱন্| ");
INSERT INTO sanasm_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","অহমেৱ দ্ৱাৰস্ৱৰূপঃ, মযা যঃ কশ্চিত প্ৰৱিশতি স ৰক্ষাং প্ৰাপ্স্যতি তথা বহিৰন্তশ্চ গমনাগমনে কৃৎৱা চৰণস্থানং প্ৰাপ্স্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","যো জনস্তেনঃ স কেৱলং স্তৈন্যবধৱিনাশান্ কৰ্ত্তুমেৱ সমাযাতি কিন্ত্ৱহম্ আযু ৰ্দাতুম্ অৰ্থাৎ বাহূল্যেন তদেৱ দাতুম্ আগচ্ছম্| ");
INSERT INTO sanasm_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","অহমেৱ সত্যমেষপালকো যস্তু সত্যো মেষপালকঃ স মেষাৰ্থং প্ৰাণত্যাগং কৰোতি; ");
INSERT INTO sanasm_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","কিন্তু যো জনো মেষপালকো ন, অৰ্থাদ্ যস্য মেষা নিজা ন ভৱন্তি, য এতাদৃশো ৱৈতনিকঃ স ৱৃকম্ আগচ্ছন্তং দৃষ্ট্ৱা মেজৱ্ৰজং ৱিহায পলাযতে, তস্মাদ্ ৱৃকস্তং ৱ্ৰজং ধৃৎৱা ৱিকিৰতি| ");
INSERT INTO sanasm_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ৱৈতনিকঃ পলাযতে যতঃ স ৱেতনাৰ্থী মেষাৰ্থং ন চিন্তযতি| ");
INSERT INTO sanasm_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","অহমেৱ সত্যো মেষপালকঃ, পিতা মাং যথা জানাতি, অহঞ্চ যথা পিতৰং জানামি, ");
INSERT INTO sanasm_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","তথা নিজান্ মেষানপি জানামি, মেষাশ্চ মাং জানান্তি, অহঞ্চ মেষাৰ্থং প্ৰাণত্যাগং কৰোমি| ");
INSERT INTO sanasm_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","অপৰঞ্চ এতদ্ গৃহীয মেষেভ্যো ভিন্না অপি মেষা মম সন্তি তে সকলা আনযিতৱ্যাঃ; তে মম শব্দং শ্ৰোষ্যন্তি তত একো ৱ্ৰজ একো ৰক্ষকো ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","প্ৰাণানহং ত্যক্ত্ৱা পুনঃ প্ৰাণান্ গ্ৰহীষ্যামি, তস্মাৎ পিতা মযি স্নেহং কৰোতি| ");
INSERT INTO sanasm_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","কশ্চিজ্জনো মম প্ৰাণান্ হন্তুং ন শক্নোতি কিন্তু স্ৱযং তান্ সমৰ্পযামি তান্ সমৰ্পযিতুং পুনৰ্গ্ৰহীতুঞ্চ মম শক্তিৰাস্তে ভাৰমিমং স্ৱপিতুঃ সকাশাৎ প্ৰাপ্তোহম্| ");
INSERT INTO sanasm_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","অস্মাদুপদেশাৎ পুনশ্চ যিহূদীযানাং মধ্যে ভিন্নৱাক্যতা জাতা| ");
INSERT INTO sanasm_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ততো বহৱো ৱ্যাহৰন্ এষ ভূতগ্ৰস্ত উন্মত্তশ্চ, কুত এতস্য কথাং শৃণুথ? ");
INSERT INTO sanasm_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","কেচিদ্ অৱদন্ এতস্য কথা ভূতগ্ৰস্তস্য কথাৱন্ন ভৱন্তি, ভূতঃ কিম্ অন্ধায চক্ষুষী দাতুং শক্নোতি? ");
INSERT INTO sanasm_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","শীতকালে যিৰূশালমি মন্দিৰোৎসৰ্গপৰ্ৱ্ৱণ্যুপস্থিতে ");
INSERT INTO sanasm_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","যীশুঃ সুলেমানো নিঃসাৰেণ গমনাগমনে কৰোতি, ");
INSERT INTO sanasm_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","এতস্মিন্ সমযে যিহূদীযাস্তং ৱেষ্টযিৎৱা ৱ্যাহৰন্ কতি কালান্ অস্মাকং ৱিচিকিৎসাং স্থাপযিষ্যামি? যদ্যভিষিক্তো ভৱতি তৰ্হি তৎ স্পষ্টং ৱদ| ");
INSERT INTO sanasm_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","তদা যীশুঃ প্ৰত্যৱদদ্ অহম্ অচকথং কিন্তু যূযং ন প্ৰতীথ, নিজপিতু ৰ্নাম্না যাং যাং ক্ৰিযাং কৰোমি সা ক্ৰিযৈৱ মম সাক্ষিস্ৱৰূপা| ");
INSERT INTO sanasm_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","কিন্ত্ৱহং পূৰ্ৱ্ৱমকথযং যূযং মম মেষা ন ভৱথ, কাৰণাদস্মান্ ন ৱিশ্ৱসিথ| ");
INSERT INTO sanasm_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","মম মেষা মম শব্দং শৃণ্ৱন্তি তানহং জানামি তে চ মম পশ্চাদ্ গচ্ছন্তি| ");
INSERT INTO sanasm_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","অহং তেভ্যোঽনন্তাযু ৰ্দদামি, তে কদাপি ন নংক্ষ্যন্তি কোপি মম কৰাৎ তান্ হৰ্ত্তুং ন শক্ষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","যো মম পিতা তান্ মহ্যং দত্তৱান্ স সৰ্ৱ্ৱস্মাৎ মহান্, কোপি মম পিতুঃ কৰাৎ তান্ হৰ্ত্তুং ন শক্ষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","অহং পিতা চ দ্ৱযোৰেকৎৱম্| ");
INSERT INTO sanasm_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","ততো যিহূদীযাঃ পুনৰপি তং হন্তুং পাষাণান্ উদতোলযন্| ");
INSERT INTO sanasm_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","যীশুঃ কথিতৱান্ পিতুঃ সকাশাদ্ বহূন্যুত্তমকৰ্ম্মাণি যুষ্মাকং প্ৰাকাশযং তেষাং কস্য কৰ্ম্মণঃ কাৰণান্ মাং পাষাণৈৰাহন্তুম্ উদ্যতাঃ স্থ? ");
INSERT INTO sanasm_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","যিহূদীযাঃ প্ৰত্যৱদন্ প্ৰশস্তকৰ্ম্মহেতো ৰ্ন কিন্তু ৎৱং মানুষঃ স্ৱমীশ্ৱৰম্ উক্ত্ৱেশ্ৱৰং নিন্দসি কাৰণাদস্মাৎ ৎৱাং পাষাণৈৰ্হন্মঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","তদা যীশুঃ প্ৰত্যুক্তৱান্ মযা কথিতং যূযম্ ঈশ্ৱৰা এতদ্ৱচনং যুষ্মাকং শাস্ত্ৰে লিখিতং নাস্তি কিং? ");
INSERT INTO sanasm_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","তস্মাদ্ যেষাম্ উদ্দেশে ঈশ্ৱৰস্য কথা কথিতা তে যদীশ্ৱৰগণা উচ্যন্তে ধৰ্ম্মগ্ৰন্থস্যাপ্যন্যথা ভৱিতুং ন শক্যং, ");
INSERT INTO sanasm_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","তৰ্হ্যাহম্ ঈশ্ৱৰস্য পুত্ৰ ইতি ৱাক্যস্য কথনাৎ যূযং পিত্ৰাভিষিক্তং জগতি প্ৰেৰিতঞ্চ পুমাংসং কথম্ ঈশ্ৱৰনিন্দকং ৱাদয? ");
INSERT INTO sanasm_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","যদ্যহং পিতুঃ কৰ্ম্ম ন কৰোমি তৰ্হি মাং ন প্ৰতীত; ");
INSERT INTO sanasm_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","কিন্তু যদি কৰোমি তৰ্হি মযি যুষ্মাভিঃ প্ৰত্যযে ন কৃতেঽপি কাৰ্য্যে প্ৰত্যযঃ ক্ৰিযতাং, ততো মযি পিতাস্তীতি পিতৰ্য্যহম্ অস্মীতি চ ক্ষাৎৱা ৱিশ্ৱসিষ্যথ| ");
INSERT INTO sanasm_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","তদা তে পুনৰপি তং ধৰ্ত্তুম্ অচেষ্টন্ত কিন্তু স তেষাং কৰেভ্যো নিস্তীৰ্য্য ");
INSERT INTO sanasm_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","পুন ৰ্যৰ্দ্দন্ অদ্যাস্তটে যত্ৰ পুৰ্ৱ্ৱং যোহন্ অমজ্জযৎ তত্ৰাগত্য ন্যৱসৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ততো বহৱো লোকাস্তৎসমীপম্ আগত্য ৱ্যাহৰন্ যোহন্ কিমপ্যাশ্চৰ্য্যং কৰ্ম্ম নাকৰোৎ কিন্ত্ৱস্মিন্ মনুষ্যে যা যঃ কথা অকথযৎ তাঃ সৰ্ৱ্ৱাঃ সত্যাঃ; ");
INSERT INTO sanasm_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","তত্ৰ চ বহৱো লোকাস্তস্মিন্ ৱ্যশ্ৱসন্| ");
INSERT INTO sanasm_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","অনন্তৰং মৰিযম্ তস্যা ভগিনী মৰ্থা চ যস্মিন্ ৱৈথনীযাগ্ৰামে ৱসতস্তস্মিন্ গ্ৰামে ইলিযাসৰ্ নামা পীডিত এক আসীৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","যা মৰিযম্ প্ৰভুং সুগন্ধিতেলৈন মৰ্দ্দযিৎৱা স্ৱকেশৈস্তস্য চৰণৌ সমমাৰ্জৎ তস্যা ভ্ৰাতা স ইলিযাসৰ্ ৰোগী| ");
INSERT INTO sanasm_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","অপৰঞ্চ হে প্ৰভো ভৱান্ যস্মিন্ প্ৰীযতে স এৱ পীডিতোস্তীতি কথাং কথযিৎৱা তস্য ভগিন্যৌ প্ৰেষিতৱত্যৌ| ");
INSERT INTO sanasm_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","তদা যীশুৰিমাং ৱাৰ্ত্তাং শ্ৰুৎৱাকথযত পীডেযং মৰণাৰ্থং ন কিন্ত্ৱীশ্ৱৰস্য মহিমাৰ্থম্ ঈশ্ৱৰপুত্ৰস্য মহিমপ্ৰকাশাৰ্থঞ্চ জাতা| ");
INSERT INTO sanasm_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","যীশু ৰ্যদ্যপিমৰ্থাযাং তদ্ভগিন্যাম্ ইলিযাসৰি চাপ্ৰীযত, ");
INSERT INTO sanasm_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","তথাপি ইলিযাসৰঃ পীডাযাঃ কথং শ্ৰুৎৱা যত্ৰ আসীৎ তত্ৰৈৱ দিনদ্ৱযমতিষ্ঠৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ততঃ পৰম্ স শিষ্যানকথযদ্ ৱযং পুন ৰ্যিহূদীযপ্ৰদেশং যামঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","ততস্তে প্ৰত্যৱদন্, হে গুৰো স্ৱল্পদিনানি গতানি যিহূদীযাস্ত্ৱাং পাষাণৈ ৰ্হন্তুম্ উদ্যতাস্তথাপি কিং পুনস্তত্ৰ যাস্যসি? ");
INSERT INTO sanasm_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","যীশুঃ প্ৰত্যৱদৎ, একস্মিন্ দিনে কিং দ্ৱাদশঘটিকা ন ভৱন্তি? কোপি দিৱা গচ্ছন্ ন স্খলতি যতঃ স এতজ্জগতো দীপ্তিং প্ৰাপ্নোতি| ");
INSERT INTO sanasm_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","কিন্তু ৰাত্ৰৌ গচ্ছন্ স্খলতি যতো হেতোস্তত্ৰ দীপ্তি ৰ্নাস্তি| ");
INSERT INTO sanasm_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ইমাং কথাং কথযিৎৱা স তানৱদদ্, অস্মাকং বন্ধুঃ ইলিযাসৰ্ নিদ্ৰিতোভূদ্ ইদানীং তং নিদ্ৰাতো জাগৰযিতুং গচ্ছামি| ");
INSERT INTO sanasm_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","যীশু ৰ্মৃতৌ কথামিমাং কথিতৱান্ কিন্তু ৱিশ্ৰামাৰ্থং নিদ্ৰাযাং কথিতৱান্ ইতি জ্ঞাৎৱা শিষ্যা অকথযন্, ");
INSERT INTO sanasm_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","হে গুৰো স যদি নিদ্ৰাতি তৰ্হি ভদ্ৰমেৱ| ");
INSERT INTO sanasm_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","তদা যীশুঃ স্পষ্টং তান্ ৱ্যাহৰৎ, ইলিযাসৰ্ অম্ৰিযত; ");
INSERT INTO sanasm_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","কিন্তু যূযং যথা প্ৰতীথ তদৰ্থমহং তত্ৰ ন স্থিতৱান্ ইত্যস্মাদ্ যুষ্মন্নিমিত্তম্ আহ্লাদিতোহং, তথাপি তস্য সমীপে যাম| ");
INSERT INTO sanasm_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","তদা থোমা যং দিদুমং ৱদন্তি স সঙ্গিনঃ শিষ্যান্ অৱদদ্ ৱযমপি গৎৱা তেন সাৰ্দ্ধং ম্ৰিযামহৈ| ");
INSERT INTO sanasm_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","যীশুস্তত্ৰোপস্থায ইলিযাসৰঃ শ্মশানে স্থাপনাৎ চৎৱাৰি দিনানি গতানীতি ৱাৰ্ত্তাং শ্ৰুতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","ৱৈথনীযা যিৰূশালমঃ সমীপস্থা ক্ৰোশৈকমাত্ৰান্তৰিতা; ");
INSERT INTO sanasm_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","তস্মাদ্ বহৱো যিহূদীযা মৰ্থাং মৰিযমঞ্চ ভ্যাতৃশোকাপন্নাং সান্ত্ৱযিতুং তযোঃ সমীপম্ আগচ্ছন্| ");
INSERT INTO sanasm_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","মৰ্থা যীশোৰাগমনৱাৰ্তাং শ্ৰুৎৱৈৱ তং সাক্ষাদ্ অকৰোৎ কিন্তু মৰিযম্ গেহ উপৱিশ্য স্থিতা| ");
INSERT INTO sanasm_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","তদা মৰ্থা যীশুমৱাদৎ, হে প্ৰভো যদি ভৱান্ অত্ৰাস্থাস্যৎ তৰ্হি মম ভ্ৰাতা নামৰিষ্যৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","কিন্ত্ৱিদানীমপি যদ্ ঈশ্ৱৰে প্ৰাৰ্থযিষ্যতে ঈশ্ৱৰস্তদ্ দাস্যতীতি জানেঽহং| ");
INSERT INTO sanasm_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","যীশুৰৱাদীৎ তৱ ভ্ৰাতা সমুত্থাস্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","মৰ্থা ৱ্যাহৰৎ শেষদিৱসে স উত্থানসমযে প্ৰোত্থাস্যতীতি জানেঽহং| ");
INSERT INTO sanasm_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","তদা যীশুঃ কথিতৱান্ অহমেৱ উত্থাপযিতা জীৱযিতা চ যঃ কশ্চন মযি ৱিশ্ৱসিতি স মৃৎৱাপি জীৱিষ্যতি; ");
INSERT INTO sanasm_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","যঃ কশ্চন চ জীৱন্ মযি ৱিশ্ৱসিতি স কদাপি ন মৰিষ্যতি, অস্যাং কথাযাং কিং ৱিশ্ৱসিষি? ");
INSERT INTO sanasm_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","সাৱদৎ প্ৰভো যস্যাৱতৰণাপেক্ষাস্তি ভৱান্ সএৱাভিষিক্ত্ত ঈশ্ৱৰপুত্ৰ ইতি ৱিশ্ৱসিমি| ");
INSERT INTO sanasm_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ইতি কথাং কথযিৎৱা সা গৎৱা স্ৱাং ভগিনীং মৰিযমং গুপ্তমাহূয ৱ্যাহৰৎ গুৰুৰুপতিষ্ঠতি ৎৱামাহূযতি চ| ");
INSERT INTO sanasm_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","কথামিমাং শ্ৰুৎৱা সা তূৰ্ণম্ উত্থায তস্য সমীপম্ অগচ্ছৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","যীশু ৰ্গ্ৰামমধ্যং ন প্ৰৱিশ্য যত্ৰ মৰ্থা তং সাক্ষাদ্ অকৰোৎ তত্ৰ স্থিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","যে যিহূদীযা মৰিযমা সাকং গৃহে তিষ্ঠন্তস্তাম্ অসান্ত্ৱযন তে তাং ক্ষিপ্ৰম্ উত্থায গচ্ছন্তিং ৱিলোক্য ৱ্যাহৰন্, স শ্মশানে ৰোদিতুং যাতি, ইত্যুক্ত্ৱা তে তস্যাঃ পশ্চাদ্ অগচ্ছন্| ");
INSERT INTO sanasm_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","যত্ৰ যীশুৰতিষ্ঠৎ তত্ৰ মৰিযম্ উপস্থায তং দৃষ্ট্ৱা তস্য চৰণযোঃ পতিৎৱা ৱ্যাহৰৎ হে প্ৰভো যদি ভৱান্ অত্ৰাস্থাস্যৎ তৰ্হি মম ভ্ৰাতা নামৰিষ্যৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","যীশুস্তাং তস্যাঃ সঙ্গিনো যিহূদীযাংশ্চ ৰুদতো ৱিলোক্য শোকাৰ্ত্তঃ সন্ দীৰ্ঘং নিশ্ৱস্য কথিতৱান্ তং কুত্ৰাস্থাপযত? ");
INSERT INTO sanasm_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","তে ৱ্যাহৰন্, হে প্ৰভো ভৱান্ আগত্য পশ্যতু| ");
INSERT INTO sanasm_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","যীশুনা ক্ৰন্দিতং| ");
INSERT INTO sanasm_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","অতএৱ যিহূদীযা অৱদন্, পশ্যতাযং তস্মিন্ কিদৃগ্ অপ্ৰিযত| ");
INSERT INTO sanasm_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","তেষাং কেচিদ্ অৱদন্ যোন্ধায চক্ষুষী দত্তৱান্ স কিম্ অস্য মৃত্যুং নিৱাৰযিতুং নাশক্নোৎ? ");
INSERT INTO sanasm_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","ততো যীশুঃ পুনৰন্তৰ্দীৰ্ঘং নিশ্ৱস্য শ্মশানান্তিকম্ অগচ্ছৎ| তৎ শ্মশানম্ একং গহ্ৱৰং তন্মুখে পাষাণ এক আসীৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","তদা যীশুৰৱদদ্ এনং পাষাণম্ অপসাৰযত, ততঃ প্ৰমীতস্য ভগিনী মৰ্থাৱদৎ প্ৰভো, অধুনা তত্ৰ দুৰ্গন্ধো জাতঃ, যতোদ্য চৎৱাৰি দিনানি শ্মশানে স তিষ্ঠতি| ");
INSERT INTO sanasm_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","তদা যীশুৰৱাদীৎ, যদি ৱিশ্ৱসিষি তৰ্হীশ্ৱৰস্য মহিমপ্ৰকাশং দ্ৰক্ষ্যসি কথামিমাং কিং তুভ্যং নাকথযং? ");
INSERT INTO sanasm_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","তদা মৃতস্য শ্মশানাৎ পাষাণোঽপসাৰিতে যীশুৰূৰ্দ্ৱ্ৱং পশ্যন্ অকথযৎ, হে পিত ৰ্মম নেৱেসনম্ অশৃণোঃ কাৰণাদস্মাৎ ৎৱাং ধন্যং ৱদামি| ");
INSERT INTO sanasm_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ৎৱং সততং শৃণোষি তদপ্যহং জানামি, কিন্তু ৎৱং মাং যৎ প্ৰৈৰযস্তদ্ যথাস্মিন্ স্থানে স্থিতা লোকা ৱিশ্ৱসন্তি তদৰ্থম্ ইদং ৱাক্যং ৱদামি| ");
INSERT INTO sanasm_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ইমাং কথাং কথযিৎৱা স প্ৰোচ্চৈৰাহ্ৱযৎ, হে ইলিযাসৰ্ বহিৰাগচ্ছ| ");
INSERT INTO sanasm_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","ততঃ স প্ৰমীতঃ শ্মশানৱস্ত্ৰৈ ৰ্বদ্ধহস্তপাদো গাত্ৰমাৰ্জনৱাসসা বদ্ধমুখশ্চ বহিৰাগচ্ছৎ| যীশুৰুদিতৱান্ বন্ধনানি মোচযিৎৱা ত্যজতৈনং| ");
INSERT INTO sanasm_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","মৰিযমঃ সমীপম্ আগতা যে যিহূদীযলোকাস্তদা যীশোৰেতৎ কৰ্ম্মাপশ্যন্ তেষাং বহৱো ৱ্যশ্ৱসন্, ");
INSERT INTO sanasm_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","কিন্তু কেচিদন্যে ফিৰূশিনাং সমীপং গৎৱা যীশোৰেতস্য কৰ্ম্মণো ৱাৰ্ত্তাম্ অৱদন্| ");
INSERT INTO sanasm_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","ততঃ পৰং প্ৰধানযাজকাঃ ফিৰূশিনাশ্চ সভাং কৃৎৱা ৱ্যাহৰন্ ৱযং কিং কুৰ্ম্মঃ? এষ মানৱো বহূন্যাশ্চৰ্য্যকৰ্ম্মাণি কৰোতি| ");
INSERT INTO sanasm_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","যদীদৃশং কৰ্ম্ম কৰ্ত্তুং ন ৱাৰযামস্তৰ্হি সৰ্ৱ্ৱে লোকাস্তস্মিন্ ৱিশ্ৱসিষ্যন্তি ৰোমিলোকাশ্চাগত্যাস্মাকম্ অনযা ৰাজধান্যা সাৰ্দ্ধং ৰাজ্যম্ আছেৎস্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","তদা তেষাং কিযফানামা যস্তস্মিন্ ৱৎসৰে মহাযাজকপদে ন্যযুজ্যত স প্ৰত্যৱদদ্ যূযং কিমপি ন জানীথ; ");
INSERT INTO sanasm_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","সমগ্ৰদেশস্য ৱিনাশতোপি সৰ্ৱ্ৱলোকাৰ্থম্ একস্য জনস্য মৰণম্ অস্মাকং মঙ্গলহেতুকম্ এতস্য ৱিৱেচনামপি ন কুৰুথ| ");
INSERT INTO sanasm_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","এতাং কথাং স নিজবুদ্ধ্যা ৱ্যাহৰদ্ ইতি ন, ");
INSERT INTO sanasm_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","কিন্তু যীশূস্তদ্দেশীযানাং কাৰণাৎ প্ৰাণান্ ত্যক্ষ্যতি, দিশি দিশি ৱিকীৰ্ণান্ ঈশ্ৱৰস্য সন্তানান্ সংগৃহ্যৈকজাতিং কৰিষ্যতি চ, তস্মিন্ ৱৎসৰে কিযফা মহাযাজকৎৱপদে নিযুক্তঃ সন্ ইদং ভৱিষ্যদ্ৱাক্যং কথিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","তদ্দিনমাৰভ্য তে কথং তং হন্তুং শক্নুৱন্তীতি মন্ত্ৰণাং কৰ্ত্তুং প্ৰাৰেভিৰে| ");
INSERT INTO sanasm_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","অতএৱ যিহূদীযানাং মধ্যে যীশুঃ সপ্ৰকাশং গমনাগমনে অকৃৎৱা তস্মাদ্ গৎৱা প্ৰান্তৰস্য সমীপস্থাযিপ্ৰদেশস্যেফ্ৰাযিম্ নাম্নি নগৰে শিষ্যৈঃ সাকং কালং যাপযিতুং প্ৰাৰেভে| ");
INSERT INTO sanasm_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","অনন্তৰং যিহূদীযানাং নিস্তাৰোৎসৱে নিকটৱৰ্ত্তিনি সতি তদুৎসৱাৎ পূৰ্ৱ্ৱং স্ৱান্ শুচীন্ কৰ্ত্তুং বহৱো জনা গ্ৰামেভ্যো যিৰূশালম্ নগৰম্ আগচ্ছন্, ");
INSERT INTO sanasm_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","যীশোৰন্ৱেষণং কৃৎৱা মন্দিৰে দণ্ডাযমানাঃ সন্তঃ পৰস্পৰং ৱ্যাহৰন্, যুষ্মাকং কীদৃশো বোধো জাযতে? স কিম্ উৎসৱেঽস্মিন্ অত্ৰাগমিষ্যতি? ");
INSERT INTO sanasm_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","স চ কুত্ৰাস্তি যদ্যেতৎ কশ্চিদ্ ৱেত্তি তৰ্হি দৰ্শযতু প্ৰধানযাজকাঃ ফিৰূশিনশ্চ তং ধৰ্ত্তুং পূৰ্ৱ্ৱম্ ইমাম্ আজ্ঞাং প্ৰাচাৰযন্| ");
INSERT INTO sanasm_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","নিস্তাৰোৎসৱাৎ পূৰ্ৱ্ৱং দিনষট্কে স্থিতে যীশু ৰ্যং প্ৰমীতম্ ইলিযাসৰং শ্মশানাদ্ উদস্থাপৰৎ তস্য নিৱাসস্থানং বৈথনিযাগ্ৰামম্ আগচ্ছৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","তত্ৰ তদৰ্থং ৰজন্যাং ভোজ্যে কৃতে মৰ্থা পৰ্য্যৱেষযদ্ ইলিযাসৰ্ চ তস্য সঙ্গিভিঃ সাৰ্দ্ধং ভোজনাসন উপাৱিশৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","তদা মৰিযম্ অৰ্দ্ধসেটকং বহুমূল্যং জটামাংসীযং তৈলম্ আনীয যীশোশ্চৰণযো ৰ্মৰ্দ্দযিৎৱা নিজকেশ ৰ্মাৰ্ষ্টুম্ আৰভত; তদা তৈলস্য পৰিমলেন গৃহম্ আমোদিতম্ অভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","যঃ শিমোনঃ পুত্ৰ ৰিষ্কৰিযোতীযো যিহূদানামা যীশুং পৰকৰেষু সমৰ্পযিষ্যতি স শিষ্যস্তদা কথিতৱান্, ");
INSERT INTO sanasm_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","এতত্তৈলং ত্ৰিভিঃ শতৈ ৰ্মুদ্ৰাপদৈ ৰ্ৱিক্ৰীতং সদ্ দৰিদ্ৰেভ্যঃ কুতো নাদীযত? ");
INSERT INTO sanasm_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","স দৰিদ্ৰলোকাৰ্থম্ অচিন্তযদ্ ইতি ন, কিন্তু স চৌৰ এৱং তন্নিকটে মুদ্ৰাসম্পুটকস্থিত্যা তন্মধ্যে যদতিষ্ঠৎ তদপাহৰৎ তস্মাৎ কাৰণাদ্ ইমাং কথামকথযৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","তদা যীশুৰকথযদ্ এনাং মা ৱাৰয সা মম শ্মশানস্থাপনদিনাৰ্থং তদৰক্ষযৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","দৰিদ্ৰা যুষ্মাকং সন্নিধৌ সৰ্ৱ্ৱদা তিষ্ঠন্তি কিন্ত্ৱহং সৰ্ৱ্ৱদা যুষ্মাকং সন্নিধৌ ন তিষ্ঠামি| ");
INSERT INTO sanasm_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","ততঃ পৰং যীশুস্তত্ৰাস্তীতি ৱাৰ্ত্তাং শ্ৰুৎৱা বহৱো যিহূদীযাস্তং শ্মশানাদুত্থাপিতম্ ইলিযাসৰঞ্চ দ্ৰষ্টুং তৎ স্থানম্ আগচ্ছন| ");
INSERT INTO sanasm_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","তদা প্ৰধানযাজকাস্তম্ ইলিযাসৰমপি সংহৰ্ত্তুম্ অমন্ত্ৰযন্ ; ");
INSERT INTO sanasm_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","যতস্তেন বহৱো যিহূদীযা গৎৱা যীশৌ ৱ্যশ্ৱসন্| ");
INSERT INTO sanasm_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","অনন্তৰং যীশু ৰ্যিৰূশালম্ নগৰম্ আগচ্ছতীতি ৱাৰ্ত্তাং শ্ৰুৎৱা পৰেঽহনি উৎসৱাগতা বহৱো লোকাঃ ");
INSERT INTO sanasm_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","খৰ্জ্জূৰপত্ৰাদ্যানীয তং সাক্ষাৎ কৰ্ত্তুং বহিৰাগত্য জয জযেতি ৱাচং প্ৰোচ্চৈ ৰ্ৱক্তুম্ আৰভন্ত, ইস্ৰাযেলো যো ৰাজা পৰমেশ্ৱৰস্য নাম্নাগচ্ছতি স ধন্যঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","তদা \"হে সিযোনঃ কন্যে মা ভৈষীঃ পশ্যাযং তৱ ৰাজা গৰ্দ্দভশাৱকম্ আৰুহ্যাগচ্ছতি\" ");
INSERT INTO sanasm_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","ইতি শাস্ত্ৰীযৱচনানুসাৰেণ যীশুৰেকং যুৱগৰ্দ্দভং প্ৰাপ্য তদুপৰ্য্যাৰোহৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","অস্যাঃ ঘটনাযাস্তাৎপৰ্য্যং শিষ্যাঃ প্ৰথমং নাবুধ্যন্ত, কিন্তু যীশৌ মহিমানং প্ৰাপ্তে সতি ৱাক্যমিদং তস্মিন অকথ্যত লোকাশ্চ তম্প্ৰতীত্থম্ অকুৰ্ৱ্ৱন্ ইতি তে স্মৃতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","স ইলিযাসৰং শ্মশানাদ্ আগন্তুম্ আহ্ৱতৱান্ শ্মশানাঞ্চ উদস্থাপযদ্ যে যে লোকাস্তৎকৰ্ম্য সাক্ষাদ্ অপশ্যন্ তে প্ৰমাণং দাতুম্ আৰভন্ত| ");
INSERT INTO sanasm_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","স এতাদৃশম্ অদ্ভুতং কৰ্ম্মকৰোৎ তস্য জনশ্ৰুতে ৰ্লোকাস্তং সাক্ষাৎ কৰ্ত্তুম্ আগচ্ছন্| ");
INSERT INTO sanasm_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","ততঃ ফিৰূশিনঃ পৰস্পৰং ৱক্তুম্ আৰভন্ত যুষ্মাকং সৰ্ৱ্ৱাশ্চেষ্টা ৱৃথা জাতাঃ, ইতি কিং যূযং ন বুধ্যধ্ৱে? পশ্যত সৰ্ৱ্ৱে লোকাস্তস্য পশ্চাদ্ৱৰ্ত্তিনোভৱন্| ");
INSERT INTO sanasm_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ভজনং কৰ্ত্তুম্ উৎসৱাগতানাং লোকানাং কতিপযা জনা অন্যদেশীযা আসন্ , ");
INSERT INTO sanasm_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","তে গালীলীযবৈৎসৈদানিৱাসিনঃ ফিলিপস্য সমীপম্ আগত্য ৱ্যাহৰন্ হে মহেচ্ছ ৱযং যীশুং দ্ৰষ্টুম্ ইচ্ছামঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ততঃ ফিলিপো গৎৱা আন্দ্ৰিযম্ অৱদৎ পশ্চাদ্ আন্দ্ৰিযফিলিপৌ যীশৱে ৱাৰ্ত্তাম্ অকথযতাং| ");
INSERT INTO sanasm_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","তদা যীশুঃ প্ৰত্যুদিতৱান্ মানৱসুতস্য মহিমপ্ৰাপ্তিসময উপস্থিতঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","অহং যুষ্মানতিযথাৰ্থং ৱদামি, ধান্যবীজং মৃত্তিকাযাং পতিৎৱা যদি ন মৃযতে তৰ্হ্যেকাকী তিষ্ঠতি কিন্তু যদি মৃযতে তৰ্হি বহুগুণং ফলং ফলতি| ");
INSERT INTO sanasm_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","যো জনেा নিজপ্ৰাণান্ প্ৰিযান্ জানাতি স তান্ হাৰযিষ্যতি কিন্তু যেा জন ইহলোকে নিজপ্ৰাণান্ অপ্ৰিযান্ জানাতি সেाনন্তাযুঃ প্ৰাপ্তুং তান্ ৰক্ষিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","কশ্চিদ্ যদি মম সেৱকো ভৱিতুং ৱাঞ্ছতি তৰ্হি স মম পশ্চাদ্গামী ভৱতু, তস্মাদ্ অহং যত্ৰ তিষ্ঠামি মম সেৱকেाপি তত্ৰ স্থাস্যতি; যো জনো মাং সেৱতে মম পিতাপি তং সম্মংস্যতে| ");
INSERT INTO sanasm_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","সাম্প্ৰতং মম প্ৰাণা ৱ্যাকুলা ভৱন্তি, তস্মাদ্ হে পিতৰ এতস্মাৎ সমযান্ মাং ৰক্ষ, ইত্যহং কিং প্ৰাৰ্থযিষ্যে? কিন্ত্ৱহম্ এতৎসমযাৰ্থম্ অৱতীৰ্ণৱান্| ");
INSERT INTO sanasm_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","হে পিত: স্ৱনাম্নো মহিমানং প্ৰকাশয; তনৈৱ স্ৱনাম্নো মহিমানম্ অহং প্ৰাকাশযং পুনৰপি প্ৰকাশযিষ্যামি, এষা গগণীযা ৱাণী তস্মিন্ সমযেঽজাযত| ");
INSERT INTO sanasm_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","তচ্শ্ৰুৎৱা সমীপস্থলোকানাং কেচিদ্ অৱদন্ মেঘোঽগৰ্জীৎ, কেচিদ্ অৱদন্ স্ৱৰ্গীযদূতোঽনেন সহ কথামচকথৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","তদা যীশুঃ প্ৰত্যৱাদীৎ, মদৰ্থং শব্দোযং নাভূৎ যুষ্মদৰ্থমেৱাভূৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","অধুনা জগতোস্য ৱিচাৰ: সম্পৎস্যতে, অধুনাস্য জগত: পতী ৰাজ্যাৎ চ্যোষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","যদ্যঈ পৃথিৱ্যা ঊৰ্দ্ৱ্ৱে প্ৰোত্থাপিতোস্মি তৰ্হি সৰ্ৱ্ৱান্ মানৱান্ স্ৱসমীপম্ আকৰ্ষিষ্যামি| ");
INSERT INTO sanasm_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","কথং তস্য মৃতি ৰ্ভৱিষ্যতি, এতদ্ বোধযিতুং স ইমাং কথাম্ অকথযৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","তদা লোকা অকথযন্ সোভিষিক্তঃ সৰ্ৱ্ৱদা তিষ্ঠতীতি ৱ্যৱস্থাগ্ৰন্থে শ্ৰুতম্ অস্মাভিঃ, তৰ্হি মনুষ্যপুত্ৰঃ প্ৰোত্থাপিতো ভৱিষ্যতীতি ৱাক্যং কথং ৱদসি? মনুষ্যপুত্ৰোযং কঃ? ");
INSERT INTO sanasm_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","তদা যীশুৰকথাযদ্ যুষ্মাভিঃ সাৰ্দ্ধম্ অল্পদিনানি জ্যোতিৰাস্তে, যথা যুষ্মান্ অন্ধকাৰো নাচ্ছাদযতি তদৰ্থং যাৱৎকালং যুষ্মাভিঃ সাৰ্দ্ধং জ্যোতিস্তিষ্ঠতি তাৱৎকালং গচ্ছত; যো জনোঽন্ধকাৰে গচ্ছতি স কুত্ৰ যাতীতি ন জানাতি| ");
INSERT INTO sanasm_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","অতএৱ যাৱৎকালং যুষ্মাকং নিকটে জ্যোতিৰাস্তে তাৱৎকালং জ্যোতীৰূপসন্তানা ভৱিতুং জ্যোতিষি ৱিশ্ৱসিত; ইমাং কথাং কথযিৎৱা যীশুঃ প্ৰস্থায তেভ্যঃ স্ৱং গুপ্তৱান্| ");
INSERT INTO sanasm_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","যদ্যপি যীশুস্তেষাং সমক্ষম্ এতাৱদাশ্চৰ্য্যকৰ্ম্মাণি কৃতৱান্ তথাপি তে তস্মিন্ ন ৱ্যশ্ৱসন্| ");
INSERT INTO sanasm_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","অতএৱ কঃ প্ৰত্যেতি সুসংৱাদং পৰেশাস্মৎ প্ৰচাৰিতং? প্ৰকাশতে পৰেশস্য হস্তঃ কস্য চ সন্নিধৌ? যিশযিযভৱিষ্যদ্ৱাদিনা যদেতদ্ ৱাক্যমুক্তং তৎ সফলম্ অভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","তে প্ৰত্যেতুং নাশন্কুৱন্ তস্মিন্ যিশযিযভৱিষ্যদ্ৱাদি পুনৰৱাদীদ্, ");
INSERT INTO sanasm_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","যদা, \"তে নযনৈ ৰ্ন পশ্যন্তি বুদ্ধিভিশ্চ ন বুধ্যন্তে তৈ ৰ্মনঃসু পৰিৱৰ্ত্তিতেষু চ তানহং যথা স্ৱস্থান্ ন কৰোমি তথা স তেষাং লোচনান্যন্ধানি কৃৎৱা তেষামন্তঃকৰণানি গাঢানি কৰিষ্যতি| \" ");
INSERT INTO sanasm_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","যিশযিযো যদা যীশো ৰ্মহিমানং ৱিলোক্য তস্মিন্ কথামকথযৎ তদা ভৱিষ্যদ্ৱাক্যম্ ঈদৃশং প্ৰকাশযৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","তথাপ্যধিপতিনাং বহৱস্তস্মিন্ প্ৰত্যাযন্| কিন্তু ফিৰূশিনস্তান্ ভজনগৃহাদ্ দূৰীকুৰ্ৱ্ৱন্তীতি ভযাৎ তে তং ন স্ৱীকৃতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","যত ঈশ্ৱৰস্য প্ৰশংসাতো মানৱানাং প্ৰশংসাযাং তেঽপ্ৰিযন্ত| ");
INSERT INTO sanasm_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","তদা যীশুৰুচ্চৈঃকাৰম্ অকথযদ্ যো জনো মযি ৱিশ্ৱসিতি স কেৱলে মযি ৱিশ্ৱসিতীতি ন, স মৎপ্ৰেৰকেঽপি ৱিশ্ৱসিতি| ");
INSERT INTO sanasm_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","যো জনো মাং পশ্যতি স মৎপ্ৰেৰকমপি পশ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","যো জনো মাং প্ৰত্যেতি স যথান্ধকাৰে ন তিষ্ঠতি তদৰ্থম্ অহং জ্যোতিঃস্ৱৰূপো ভূৎৱা জগত্যস্মিন্ অৱতীৰ্ণৱান্| ");
INSERT INTO sanasm_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","মম কথাং শ্ৰুৎৱা যদি কশ্চিন্ ন ৱিশ্ৱসিতি তৰ্হি তমহং দোষিণং ন কৰোমি, যতো হেতো ৰ্জগতো জনানাং দোষান্ নিশ্চিতান্ কৰ্ত্তুং নাগত্য তান্ পৰিচাতুম্ আগতোস্মি| ");
INSERT INTO sanasm_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","যঃ কশ্চিন্ মাং ন শ্ৰদ্ধায মম কথং ন গৃহ্লাতি, অন্যস্তং দোষিণং কৰিষ্যতি ৱস্তুতস্তু যাং কথামহম্ অচকথং সা কথা চৰমেঽন্হি তং দোষিণং কৰিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","যতো হেতোৰহং স্ৱতঃ কিমপি ন কথযামি, কিং কিং মযা কথযিতৱ্যং কিং সমুপদেষ্টৱ্যঞ্চ ইতি মৎপ্ৰেৰযিতা পিতা মামাজ্ঞাপযৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","তস্য সাজ্ঞা অনন্তাযুৰিত্যহং জানামি, অতএৱাহং যৎ কথযামি তৎ পিতা যথাজ্ঞাপযৎ তথৈৱ কথযাম্যহম্| ");
INSERT INTO sanasm_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","নিস্তাৰোৎসৱস্য কিঞ্চিৎকালাৎ পূৰ্ৱ্ৱং পৃথিৱ্যাঃ পিতুঃ সমীপগমনস্য সমযঃ সন্নিকৰ্ষোভূদ্ ইতি জ্ঞাৎৱা যীশুৰাপ্ৰথমাদ্ যেষু জগৎপ্ৰৱাসিষ্ৱাত্মীযলোকেষ প্ৰেম কৰোতি স্ম তেষু শেষং যাৱৎ প্ৰেম কৃতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","পিতা তস্য হস্তে সৰ্ৱ্ৱং সমৰ্পিতৱান্ স্ৱযম্ ঈশ্ৱৰস্য সমীপাদ্ আগচ্ছদ্ ঈশ্ৱৰস্য সমীপং যাস্যতি চ, সৰ্ৱ্ৱাণ্যেতানি জ্ঞাৎৱা ৰজন্যাং ভোজনে সম্পূৰ্ণে সতি, ");
INSERT INTO sanasm_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","যদা শৈতান্ তং পৰহস্তেষু সমৰ্পযিতুং শিমোনঃ পুত্ৰস্য ঈষ্কাৰিযোতিযস্য যিহূদা অন্তঃকৰণে কুপ্ৰৱৃত্তিং সমাৰ্পযৎ, ");
INSERT INTO sanasm_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","তদা যীশু ৰ্ভোজনাসনাদ্ উত্থায গাত্ৰৱস্ত্ৰং মোচযিৎৱা গাত্ৰমাৰ্জনৱস্ত্ৰং গৃহীৎৱা তেন স্ৱকটিম্ অবধ্নাৎ, ");
INSERT INTO sanasm_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","পশ্চাদ্ একপাত্ৰে জলম্ অভিষিচ্য শিষ্যাণাং পাদান্ প্ৰক্ষাল্য তেন কটিবদ্ধগাত্ৰমাৰ্জনৱাসসা মাৰ্ষ্টুং প্ৰাৰভত| ");
INSERT INTO sanasm_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ততঃ শিমোন্পিতৰস্য সমীপমাগতে স উক্তৱান্ হে প্ৰভো ভৱান্ কিং মম পাদৌ প্ৰক্ষালযিষ্যতি? ");
INSERT INTO sanasm_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","যীশুৰুদিতৱান্ অহং যৎ কৰোমি তৎ সম্প্ৰতি ন জানাসি কিন্তু পশ্চাজ্ জ্ঞাস্যসি| ");
INSERT INTO sanasm_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","ততঃ পিতৰঃ কথিতৱান্ ভৱান্ কদাপি মম পাদৌ ন প্ৰক্ষালযিষ্যতি| যীশুৰকথযদ্ যদি ৎৱাং ন প্ৰক্ষালযে তৰ্হি মযি তৱ কোপ্যংশো নাস্তি| ");
INSERT INTO sanasm_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","তদা শিমোন্পিতৰঃ কথিতৱান্ হে প্ৰভো তৰ্হি কেৱলপাদৌ ন, মম হস্তৌ শিৰশ্চ প্ৰক্ষালযতু| ");
INSERT INTO sanasm_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","ততো যীশুৰৱদদ্ যো জনো ধৌতস্তস্য সৰ্ৱ্ৱাঙ্গপৰিষ্কৃতৎৱাৎ পাদৌ ৱিনান্যাঙ্গস্য প্ৰক্ষালনাপেক্ষা নাস্তি| যূযং পৰিষ্কৃতা ইতি সত্যং কিন্তু ন সৰ্ৱ্ৱে, ");
INSERT INTO sanasm_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","যতো যো জনস্তং পৰকৰেষু সমৰ্পযিষ্যতি তং স জ্ঞাতৱান; অতএৱ যূযং সৰ্ৱ্ৱে ন পৰিষ্কৃতা ইমাং কথাং কথিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ইত্থং যীশুস্তেষাং পাদান্ প্ৰক্ষাল্য ৱস্ত্ৰং পৰিধাযাসনে সমুপৱিশ্য কথিতৱান্ অহং যুষ্মান্ প্ৰতি কিং কৰ্ম্মাকাৰ্ষং জানীথ? ");
INSERT INTO sanasm_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","যূযং মাং গুৰুং প্ৰভুঞ্চ ৱদথ তৎ সত্যমেৱ ৱদথ যতোহং সএৱ ভৱামি| ");
INSERT INTO sanasm_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","যদ্যহং প্ৰভু ৰ্গুৰুশ্চ সন্ যুষ্মাকং পাদান্ প্ৰক্ষালিতৱান্ তৰ্হি যুষ্মাকমপি পৰস্পৰং পাদপ্ৰক্ষালনম্ উচিতম্| ");
INSERT INTO sanasm_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","অহং যুষ্মান্ প্ৰতি যথা ৱ্যৱাহৰং যুষ্মান্ তথা ৱ্যৱহৰ্ত্তুম্ একং পন্থানং দৰ্শিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","অহং যুষ্মানতিযথাৰ্থং ৱদামি, প্ৰভো ৰ্দাসো ন মহান্ প্ৰেৰকাচ্চ প্ৰেৰিতো ন মহান্| ");
INSERT INTO sanasm_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ইমাং কথাং ৱিদিৎৱা যদি তদনুসাৰতঃ কৰ্ম্মাণি কুৰুথ তৰ্হি যূযং ধন্যা ভৱিষ্যথ| ");
INSERT INTO sanasm_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","সৰ্ৱ্ৱেষু যুষ্মাসু কথামিমাং কথযামি ইতি ন, যে মম মনোনীতাস্তানহং জানামি, কিন্তু মম ভক্ষ্যাণি যো ভুঙ্ক্তে মৎপ্ৰাণপ্ৰাতিকূল্যতঃ| উত্থাপযতি পাদস্য মূলং স এষ মানৱঃ| যদেতদ্ ধৰ্ম্মপুস্তকস্য ৱচনং তদনুসাৰেণাৱশ্যং ঘটিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","অহং স জন ইত্যত্ৰ যথা যুষ্মাকং ৱিশ্ৱাসো জাযতে তদৰ্থং এতাদৃশঘটনাৎ পূৰ্ৱ্ৱম্ অহমিদানীং যুষ্মভ্যমকথযম্| ");
INSERT INTO sanasm_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","অহং যুষ্মানতীৱ যথাৰ্থং ৱদামি, মযা প্ৰেৰিতং জনং যো গৃহ্লাতি স মামেৱ গৃহ্লাতি যশ্চ মাং গৃহ্লাতি স মৎপ্ৰেৰকং গৃহ্লাতি| ");
INSERT INTO sanasm_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","এতাং কথাং কথযিৎৱা যীশু ৰ্দুঃখী সন্ প্ৰমাণং দত্ত্ৱা কথিতৱান্ অহং যুষ্মানতিযথাৰ্থং ৱদামি যুষ্মাকম্ একো জনো মাং পৰকৰেষু সমৰ্পযিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","ততঃ স কমুদ্দিশ্য কথামেতাং কথিতৱান্ ইত্যত্ৰ সন্দিগ্ধাঃ শিষ্যাঃ পৰস্পৰং মুখমালোকযিতুং প্ৰাৰভন্ত| ");
INSERT INTO sanasm_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","তস্মিন্ সমযে যীশু ৰ্যস্মিন্ অপ্ৰীযত স শিষ্যস্তস্য ৱক্ষঃস্থলম্ অৱালম্বত| ");
INSERT INTO sanasm_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","শিমোন্পিতৰস্তং সঙ্কেতেনাৱদৎ, অযং কমুদ্দিশ্য কথামেতাম্ কথযতীতি পৃচ্ছ| ");
INSERT INTO sanasm_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","তদা স যীশো ৰ্ৱক্ষঃস্থলম্ অৱলম্ব্য পৃষ্ঠৱান্, হে প্ৰভো স জনঃ কঃ? ");
INSERT INTO sanasm_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","ততো যীশুঃ প্ৰত্যৱদদ্ একখণ্ডং পূপং মজ্জযিৎৱা যস্মৈ দাস্যামি সএৱ সঃ; পশ্চাৎ পূপখণ্ডমেকং মজ্জযিৎৱা শিমোনঃ পুত্ৰায ঈষ্কৰিযোতীযায যিহূদৈ দত্তৱান্| ");
INSERT INTO sanasm_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","তস্মিন্ দত্তে সতি শৈতান্ তমাশ্ৰযৎ; তদা যীশুস্তম্ অৱদৎ ৎৱং যৎ কৰিষ্যসি তৎ ক্ষিপ্ৰং কুৰু| ");
INSERT INTO sanasm_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","কিন্তু স যেনাশযেন তাং কথামকথাযৎ তম্ উপৱিষ্টলোকানাং কোপি নাবুধ্যত; ");
INSERT INTO sanasm_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","কিন্তু যিহূদাঃ সমীপে মুদ্ৰাসম্পুটকস্থিতেঃ কেচিদ্ ইত্থম্ অবুধ্যন্ত পাৰ্ৱ্ৱণাসাদনাৰ্থং কিমপি দ্ৰৱ্যং ক্ৰেতুং ৱা দৰিদ্ৰেভ্যঃ কিঞ্চিদ্ ৱিতৰিতুং কথিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","তদা পূপখণ্ডগ্ৰহণাৎ পৰং স তূৰ্ণং বহিৰগচ্ছৎ; ৰাত্ৰিশ্চ সমুপস্যিতা| ");
INSERT INTO sanasm_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","যিহূদে বহিৰ্গতে যীশুৰকথযদ্ ইদানীং মানৱসুতস্য মহিমা প্ৰকাশতে তেনেশ্ৱৰস্যাপি মহিমা প্ৰকাশতে| ");
INSERT INTO sanasm_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","যদি তেনেশ্ৱৰস্য মহিমা প্ৰকাশতে তৰ্হীশ্ৱৰোপি স্ৱেন তস্য মহিমানং প্ৰকাশযিষ্যতি তূৰ্ণমেৱ প্ৰকাশযিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","হে ৱৎসা অহং যুষ্মাভিঃ সাৰ্দ্ধং কিঞ্চিৎকালমাত্ৰম্ আসে, ততঃ পৰং মাং মৃগযিষ্যধ্ৱে কিন্ত্ৱহং যৎস্থানং যামি তৎস্থানং যূযং গন্তুং ন শক্ষ্যথ, যামিমাং কথাং যিহূদীযেভ্যঃ কথিতৱান্ তথাধুনা যুষ্মভ্যমপি কথযামি| ");
INSERT INTO sanasm_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","যূযং পৰস্পৰং প্ৰীযধ্ৱম্ অহং যুষ্মাসু যথা প্ৰীযে যূযমপি পৰস্পৰম্ তথৈৱ প্ৰীযধ্ৱং, যুষ্মান্ ইমাং নৱীনাম্ আজ্ঞাম্ আদিশামি| ");
INSERT INTO sanasm_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","তেনৈৱ যদি পৰস্পৰং প্ৰীযধ্ৱে তৰ্হি লক্ষণেনানেন যূযং মম শিষ্যা ইতি সৰ্ৱ্ৱে জ্ঞাতুং শক্ষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","শিমোনপিতৰঃ পৃষ্ঠৱান্ হে প্ৰভো ভৱান্ কুত্ৰ যাস্যতি? ততো যীশুঃ প্ৰত্যৱদৎ, অহং যৎস্থানং যামি তৎস্থানং সাম্প্ৰতং মম পশ্চাদ্ গন্তুং ন শক্নোষি কিন্তু পশ্চাদ্ গমিষ্যসি| ");
INSERT INTO sanasm_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","তদা পিতৰঃ প্ৰত্যুদিতৱান্, হে প্ৰভো সাম্প্ৰতং কুতো হেতোস্তৱ পশ্চাদ্ গন্তুং ন শক্নোমি? ৎৱদৰ্থং প্ৰাণান্ দাতুং শক্নোমি| ");
INSERT INTO sanasm_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ততো যীশুঃ প্ৰত্যুক্তৱান্ মন্নিমিত্তং কিং প্ৰাণান্ দাতুং শক্নোষি? ৎৱামহং যথাৰ্থং ৱদামি, কুক্কুটৰৱণাৎ পূৰ্ৱ্ৱং ৎৱং ত্ৰি ৰ্মাম্ অপহ্নোষ্যসে| ");
INSERT INTO sanasm_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","মনোদুঃখিনো মা ভূত; ঈশ্ৱৰে ৱিশ্ৱসিত মযি চ ৱিশ্ৱসিত| ");
INSERT INTO sanasm_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","মম পিতু গৃহে বহূনি ৱাসস্থানি সন্তি নো চেৎ পূৰ্ৱ্ৱং যুষ্মান্ অজ্ঞাপযিষ্যং যুষ্মদৰ্থং স্থানং সজ্জযিতুং গচ্ছামি| ");
INSERT INTO sanasm_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","যদি গৎৱাহং যুষ্মন্নিমিত্তং স্থানং সজ্জযামি তৰ্হি পনৰাগত্য যুষ্মান্ স্ৱসমীপং নেষ্যামি, ততো যত্ৰাহং তিষ্ঠামি তত্ৰ যূযমপি স্থাস্যথ| ");
INSERT INTO sanasm_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","অহং যৎস্থানং ব্ৰজামি তৎস্থানং যূযং জানীথ তস্য পন্থানমপি জানীথ| ");
INSERT INTO sanasm_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","তদা থোমা অৱদৎ, হে প্ৰভো ভৱান্ কুত্ৰ যাতি তদ্ৱযং ন জানীমঃ, তৰ্হি কথং পন্থানং জ্ঞাতুং শক্নুমঃ? ");
INSERT INTO sanasm_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","যীশুৰকথযদ্ অহমেৱ সত্যজীৱনৰূপপথো মযা ন গন্তা কোপি পিতুঃ সমীপং গন্তুং ন শক্নোতি| ");
INSERT INTO sanasm_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","যদি মাম্ অজ্ঞাস্যত তৰ্হি মম পিতৰমপ্যজ্ঞাস্যত কিন্ত্ৱধুনাতস্তং জানীথ পশ্যথ চ| ");
INSERT INTO sanasm_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","তদা ফিলিপঃ কথিতৱান্, হে প্ৰভো পিতৰং দৰ্শয তস্মাদস্মাকং যথেষ্টং ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","ততো যীশুঃ প্ৰত্যাৱাদীৎ, হে ফিলিপ যুষ্মাভিঃ সাৰ্দ্ধম্ এতাৱদ্দিনানি স্থিতমপি মাং কিং ন প্ৰত্যভিজানাসি? যো জনো মাম্ অপশ্যৎ স পিতৰমপ্যপশ্যৎ তৰ্হি পিতৰম্ অস্মান্ দৰ্শযেতি কথাং কথং কথযসি? ");
INSERT INTO sanasm_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","অহং পিতৰি তিষ্ঠামি পিতা মযি তিষ্ঠতীতি কিং ৎৱং ন প্ৰত্যষি? অহং যদ্ৱাক্যং ৱদামি তৎ স্ৱতো ন ৱদামি কিন্তু যঃ পিতা মযি ৱিৰাজতে স এৱ সৰ্ৱ্ৱকৰ্ম্মাণি কৰাতি| ");
INSERT INTO sanasm_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","অতএৱ পিতৰ্য্যহং তিষ্ঠামি পিতা চ মযি তিষ্ঠতি মমাস্যাং কথাযাং প্ৰত্যযং কুৰুত, নো চেৎ কৰ্ম্মহেতোঃ প্ৰত্যযং কুৰুত| ");
INSERT INTO sanasm_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","অহং যুষ্মানতিযথাৰ্থং ৱদামি, যো জনো মযি ৱিশ্ৱসিতি সোহমিৱ কৰ্ম্মাণি কৰিষ্যতি ৱৰং ততোপি মহাকৰ্ম্মাণি কৰিষ্যতি যতো হেতোৰহং পিতুঃ সমীপং গচ্ছামি| ");
INSERT INTO sanasm_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","যথা পুত্ৰেণ পিতু ৰ্মহিমা প্ৰকাশতে তদৰ্থং মম নাম প্ৰোচ্য যৎ প্ৰাৰ্থযিষ্যধ্ৱে তৎ সফলং কৰিষ্যামি| ");
INSERT INTO sanasm_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","যদি মম নাম্না যৎ কিঞ্চিদ্ যাচধ্ৱে তৰ্হি তদহং সাধযিষ্যামি| ");
INSERT INTO sanasm_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","যদি মযি প্ৰীযধ্ৱে তৰ্হি মমাজ্ঞাঃ সমাচৰত| ");
INSERT INTO sanasm_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ততো মযা পিতুঃ সমীপে প্ৰাৰ্থিতে পিতা নিৰন্তৰং যুষ্মাভিঃ সাৰ্দ্ধং স্থাতুম্ ইতৰমেকং সহাযম্ অৰ্থাৎ সত্যমযম্ আত্মানং যুষ্মাকং নিকটং প্ৰেষযিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","এতজ্জগতো লোকাস্তং গ্ৰহীতুং ন শক্নুৱন্তি যতস্তে তং নাপশ্যন্ নাজনংশ্চ কিন্তু যূযং জানীথ যতো হেতোঃ স যুষ্মাকমন্ত ৰ্নিৱসতি যুষ্মাকং মধ্যে স্থাস্যতি চ| ");
INSERT INTO sanasm_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","অহং যুষ্মান্ অনাথান্ কৃৎৱা ন যাস্যামি পুনৰপি যুষ্মাকং সমীপম্ আগমিষ্যামি| ");
INSERT INTO sanasm_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","কিযৎকালৰৎ পৰম্ অস্য জগতো লোকা মাং পুন ৰ্ন দ্ৰক্ষ্যন্তি কিন্তু যূযং দ্ৰক্ষ্যথ;অহং জীৱিষ্যামি তস্মাৎ কাৰণাদ্ যূযমপি জীৱিষ্যথ| ");
INSERT INTO sanasm_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","পিতৰ্য্যহমস্মি মযি চ যূযং স্থ, তথাহং যুষ্মাস্ৱস্মি তদপি তদা জ্ঞাস্যথ| ");
INSERT INTO sanasm_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","যো জনো মমাজ্ঞা গৃহীৎৱা তা আচৰতি সএৱ মযি প্ৰীযতে; যো জনশ্চ মযি প্ৰীযতে সএৱ মম পিতুঃ প্ৰিযপাত্ৰং ভৱিষ্যতি, তথাহমপি তস্মিন্ প্ৰীৎৱা তস্মৈ স্ৱং প্ৰকাশযিষ্যামি| ");
INSERT INTO sanasm_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","তদা ঈষ্কৰিযোতীযাদ্ অন্যো যিহূদাস্তমৱদৎ, হে প্ৰভো ভৱান্ জগতো লোকানাং সন্নিধৌ প্ৰকাশিতো ন ভূৎৱাস্মাকং সন্নিধৌ কুতঃ প্ৰকাশিতো ভৱিষ্যতি? ");
INSERT INTO sanasm_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ততো যীশুঃ প্ৰত্যুদিতৱান্, যো জনো মযি প্ৰীযতে স মমাজ্ঞা অপি গৃহ্লাতি, তেন মম পিতাপি তস্মিন্ প্ৰেষ্যতে, আৱাঞ্চ তন্নিকটমাগত্য তেন সহ নিৱৎস্যাৱঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","যো জনো মযি ন প্ৰীযতে স মম কথা অপি ন গৃহ্লাতি পুনশ্চ যামিমাং কথাং যূযং শৃণুথ সা কথা কেৱলস্য মম ন কিন্তু মম প্ৰেৰকো যঃ পিতা তস্যাপি কথা| ");
INSERT INTO sanasm_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","ইদানীং যুষ্মাকং নিকটে ৱিদ্যমানোহম্ এতাঃ সকলাঃ কথাঃ কথযামি| ");
INSERT INTO sanasm_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","কিন্ত্ৱিতঃ পৰং পিত্ৰা যঃ সহাযোঽৰ্থাৎ পৱিত্ৰ আত্মা মম নাম্নি প্ৰেৰযিষ্যতি স সৰ্ৱ্ৱং শিক্ষযিৎৱা মযোক্তাঃ সমস্তাঃ কথা যুষ্মান্ স্মাৰযিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","অহং যুষ্মাকং নিকটে শান্তিং স্থাপযিৎৱা যামি, নিজাং শান্তিং যুষ্মভ্যং দদামি, জগতো লোকা যথা দদাতি তথাহং ন দদামি; যুষ্মাকম্ অন্তঃকৰণানি দুঃখিতানি ভীতানি চ ন ভৱন্তু| ");
INSERT INTO sanasm_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","অহং গৎৱা পুনৰপি যুষ্মাকং সমীপম্ আগমিষ্যামি মযোক্তং ৱাক্যমিদং যূযম্ অশ্ৰৌষ্ট; যদি ময্যপ্ৰেষ্যধ্ৱং তৰ্হ্যহং পিতুঃ সমীপং গচ্ছামি মমাস্যাং কথাযাং যূযম্ অহ্লাদিষ্যধ্ৱং যতো মম পিতা মত্তোপি মহান্| ");
INSERT INTO sanasm_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","তস্যা ঘটনাযাঃ সমযে যথা যুষ্মাকং শ্ৰদ্ধা জাযতে তদৰ্থম্ অহং তস্যা ঘটনাযাঃ পূৰ্ৱ্ৱম্ ইদানীং যুষ্মান্ এতাং ৱাৰ্ত্তাং ৱদামি| ");
INSERT INTO sanasm_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ইতঃ পৰং যুষ্মাভিঃ সহ মম বহৱ আলাপা ন ভৱিষ্যন্তি যতঃ কাৰণাদ্ এতস্য জগতঃ পতিৰাগচ্ছতি কিন্তু মযা সহ তস্য কোপি সম্বন্ধো নাস্তি| ");
INSERT INTO sanasm_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","অহং পিতৰি প্ৰেম কৰোমি তথা পিতু ৰ্ৱিধিৱৎ কৰ্ম্মাণি কৰোমীতি যেন জগতো লোকা জানন্তি তদৰ্থম্ উত্তিষ্ঠত ৱযং স্থানাদস্মাদ্ গচ্ছাম| ");
INSERT INTO sanasm_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","অহং সত্যদ্ৰাক্ষালতাস্ৱৰূপো মম পিতা তূদ্যানপৰিচাৰকস্ৱৰূপঞ্চ| ");
INSERT INTO sanasm_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","মম যাসু শাখাসু ফলানি ন ভৱন্তি তাঃ স ছিনত্তি তথা ফলৱত্যঃ শাখা যথাধিকফলানি ফলন্তি তদৰ্থং তাঃ পৰিষ্কৰোতি| ");
INSERT INTO sanasm_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ইদানীং মযোক্তোপদেশেন যূযং পৰিষ্কৃতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","অতঃ কাৰণাৎ মযি তিষ্ঠত তেনাহমপি যুষ্মাসু তিষ্ঠামি, যতো হেতো ৰ্দ্ৰাক্ষালতাযাম্ অসংলগ্না শাখা যথা ফলৱতী ভৱিতুং ন শক্নোতি তথা যূযমপি ময্যতিষ্ঠন্তঃ ফলৱন্তো ভৱিতুং ন শক্নুথ| ");
INSERT INTO sanasm_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","অহং দ্ৰাক্ষালতাস্ৱৰূপো যূযঞ্চ শাখাস্ৱৰূপোঃ; যো জনো মযি তিষ্ঠতি যত্ৰ চাহং তিষ্ঠামি, স প্ৰচূৰফলৈঃ ফলৱান্ ভৱতি, কিন্তু মাং ৱিনা যূযং কিমপি কৰ্ত্তুং ন শক্নুথ| ");
INSERT INTO sanasm_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","যঃ কশ্চিন্ মযি ন তিষ্ঠতি স শুষ্কশাখেৱ বহি ৰ্নিক্ষিপ্যতে লোকাশ্চ তা আহৃত্য ৱহ্নৌ নিক্ষিপ্য দাহযন্তি| ");
INSERT INTO sanasm_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","যদি যূযং মযি তিষ্ঠথ মম কথা চ যুষ্মাসু তিষ্ঠতি তৰ্হি যদ্ ৱাঞ্ছিৎৱা যাচিষ্যধ্ৱে যুষ্মাকং তদেৱ সফলং ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","যদি যূযং প্ৰচূৰফলৱন্তো ভৱথ তৰ্হি তদ্ৱাৰা মম পিতু ৰ্মহিমা প্ৰকাশিষ্যতে তথা যূযং মম শিষ্যা ইতি পৰিক্ষাযিষ্যধ্ৱে| ");
INSERT INTO sanasm_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","পিতা যথা মযি প্ৰীতৱান্ অহমপি যুষ্মাসু তথা প্ৰীতৱান্ অতো হেতো ৰ্যূযং নিৰন্তৰং মম প্ৰেমপাত্ৰাণি ভূৎৱা তিষ্ঠত| ");
INSERT INTO sanasm_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","অহং যথা পিতুৰাজ্ঞা গৃহীৎৱা তস্য প্ৰেমভাজনং তিষ্ঠামি তথৈৱ যূযমপি যদি মমাজ্ঞা গুহ্লীথ তৰ্হি মম প্ৰেমভাজনানি স্থাস্যথ| ");
INSERT INTO sanasm_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","যুষ্মন্নিমিত্তং মম য আহ্লাদঃ স যথা চিৰং তিষ্ঠতি যুষ্মাকম্ আনন্দশ্চ যথা পূৰ্য্যতে তদৰ্থং যুষ্মভ্যম্ এতাঃ কথা অত্ৰকথম্| ");
INSERT INTO sanasm_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","অহং যুষ্মাসু যথা প্ৰীযে যূযমপি পৰস্পৰং তথা প্ৰীযধ্ৱম্ এষা মমাজ্ঞা| ");
INSERT INTO sanasm_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","মিত্ৰাণাং কাৰণাৎ স্ৱপ্ৰাণদানপৰ্য্যন্তং যৎ প্ৰেম তস্মান্ মহাপ্ৰেম কস্যাপি নাস্তি| ");
INSERT INTO sanasm_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","অহং যদ্যদ্ আদিশামি তত্তদেৱ যদি যূযম্ আচৰত তৰ্হি যূযমেৱ মম মিত্ৰাণি| ");
INSERT INTO sanasm_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","অদ্যাৰভ্য যুষ্মান্ দাসান্ ন ৱদিষ্যামি যৎ প্ৰভু ৰ্যৎ কৰোতি দাসস্তদ্ ন জানাতি; কিন্তু পিতুঃ সমীপে যদ্যদ্ অশৃণৱং তৎ সৰ্ৱ্ৱং যূষ্মান্ অজ্ঞাপযম্ তৎকাৰণাদ্ যুষ্মান্ মিত্ৰাণি প্ৰোক্তৱান্| ");
INSERT INTO sanasm_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","যূযং মাং ৰোচিতৱন্ত ইতি ন, কিন্ত্ৱহমেৱ যুষ্মান্ ৰোচিতৱান্ যূযং গৎৱা যথা ফলান্যুৎপাদযথ তানি ফলানি চাক্ষযাণি ভৱন্তি, তদৰ্থং যুষ্মান্ ন্যজুনজং তস্মান্ মম নাম প্ৰোচ্য পিতৰং যৎ কিঞ্চিদ্ যাচিষ্যধ্ৱে তদেৱ স যুষ্মভ্যং দাস্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","যূযং পৰস্পৰং প্ৰীযধ্ৱম্ অহম্ ইত্যাজ্ঞাপযামি| ");
INSERT INTO sanasm_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","জগতো লোকৈ ৰ্যুষ্মাসু ঋতীযিতেষু তে পূৰ্ৱ্ৱং মামেৱাৰ্ত্তীযন্ত ইতি যূযং জানীথ| ");
INSERT INTO sanasm_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","যদি যূযং জগতো লোকা অভৱিষ্যত তৰ্হি জগতো লোকা যুষ্মান্ আত্মীযান্ বুদ্ধ্ৱাপ্ৰেষ্যন্ত; কিন্তু যূযং জগতো লোকা ন ভৱথ, অহং যুষ্মান্ অস্মাজ্জগতোঽৰোচযম্ এতস্মাৎ কাৰণাজ্জগতো লোকা যুষ্মান্ ঋতীযন্তে| ");
INSERT INTO sanasm_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","দাসঃ প্ৰভো ৰ্মহান্ ন ভৱতি মমৈতৎ পূৰ্ৱ্ৱীযং ৱাক্যং স্মৰত; তে যদি মামেৱাতাডযন্ তৰ্হি যুষ্মানপি তাডযিষ্যন্তি, যদি মম ৱাক্যং গৃহ্লন্তি তৰ্হি যুষ্মাকমপি ৱাক্যং গ্ৰহীষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","কিন্তু তে মম নামকাৰণাদ্ যুষ্মান্ প্ৰতি তাদৃশং ৱ্যৱহৰিষ্যন্তি যতো যো মাং প্ৰেৰিতৱান্ তং তে ন জানন্তি| ");
INSERT INTO sanasm_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","তেষাং সন্নিধিম্ আগত্য যদ্যহং নাকথযিষ্যং তৰ্হি তেষাং পাপং নাভৱিষ্যৎ কিন্ত্ৱধুনা তেষাং পাপমাচ্ছাদযিতুম্ উপাযো নাস্তি| ");
INSERT INTO sanasm_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","যো জনো মাম্ ঋতীযতে স মম পিতৰমপি ঋতীযতে| ");
INSERT INTO sanasm_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","যাদৃশানি কৰ্ম্মাণি কেনাপি কদাপি নাক্ৰিযন্ত তাদৃশানি কৰ্ম্মাণি যদি তেষাং সাক্ষাদ্ অহং নাকৰিষ্যং তৰ্হি তেষাং পাপং নাভৱিষ্যৎ কিন্ত্ৱধুনা তে দৃষ্ট্ৱাপি মাং মম পিতৰঞ্চাৰ্ত্তীযন্ত| ");
INSERT INTO sanasm_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","তস্মাৎ তেঽকাৰণং মাম্ ঋতীযন্তে যদেতদ্ ৱচনং তেষাং শাস্ত্ৰে লিখিতমাস্তে তৎ সফলম্ অভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","কিন্তু পিতু ৰ্নিৰ্গতং যং সহাযমৰ্থাৎ সত্যমযম্ আত্মানং পিতুঃ সমীপাদ্ যুষ্মাকং সমীপে প্ৰেষযিষ্যামি স আগত্য মযি প্ৰমাণং দাস্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","যূযং প্ৰথমমাৰভ্য মযা সাৰ্দ্ধং তিষ্ঠথ তস্মাদ্ধেতো ৰ্যূযমপি প্ৰমাণং দাস্যথ| ");
INSERT INTO sanasm_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","যুষ্মাকং যথা ৱাধা ন জাযতে তদৰ্থং যুষ্মান্ এতানি সৰ্ৱ্ৱৱাক্যানি ৱ্যাহৰং| ");
INSERT INTO sanasm_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","লোকা যুষ্মান্ ভজনগৃহেভ্যো দূৰীকৰিষ্যন্তি তথা যস্মিন্ সমযে যুষ্মান্ হৎৱা ঈশ্ৱৰস্য তুষ্টি জনকং কৰ্ম্মাকুৰ্ম্ম ইতি মংস্যন্তে স সময আগচ্ছন্তি| ");
INSERT INTO sanasm_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","তে পিতৰং মাঞ্চ ন জানন্তি, তস্মাদ্ যুষ্মান্ প্ৰতীদৃশম্ আচৰিষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","অতো হেতাঃ সমযে সমুপস্থিতে যথা মম কথা যুষ্মাকং মনঃসুঃ সমুপতিষ্ঠতি তদৰ্থং যুষ্মাভ্যম্ এতাং কথাং কথযামি যুষ্মাভিঃ সাৰ্দ্ধম্ অহং তিষ্ঠন্ প্ৰথমং তাং যুষ্মভ্যং নাকথযং| ");
INSERT INTO sanasm_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","সাম্প্ৰতং স্ৱস্য প্ৰেৰযিতুঃ সমীপং গচ্ছামি তথাপি ৎৱং ক্ক গচ্ছসি কথামেতাং যুষ্মাকং কোপি মাং ন পৃচ্ছতি| ");
INSERT INTO sanasm_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","কিন্তু মযোক্তাভিৰাভিঃ কথাভি ৰ্যূষ্মাকম্ অন্তঃকৰণানি দুঃখেন পূৰ্ণান্যভৱন্| ");
INSERT INTO sanasm_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","তথাপ্যহং যথাৰ্থং কথযামি মম গমনং যুষ্মাকং হিতাৰ্থমেৱ, যতো হেতো ৰ্গমনে ন কৃতে সহাযো যুষ্মাকং সমীপং নাগমিষ্যতি কিন্তু যদি গচ্ছামি তৰ্হি যুষ্মাকং সমীপে তং প্ৰেষযিষ্যামি| ");
INSERT INTO sanasm_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","ততঃ স আগত্য পাপপুণ্যদণ্ডেষু জগতো লোকানাং প্ৰবোধং জনযিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","তে মযি ন ৱিশ্ৱসন্তি তস্মাদ্ধেতোঃ পাপপ্ৰবোধং জনযিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","যুষ্মাকম্ অদৃশ্যঃ সন্নহং পিতুঃ সমীপং গচ্ছামি তস্মাদ্ পুণ্যে প্ৰবোধং জনযিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","এতজ্জগতোঽধিপতি ৰ্দণ্ডাজ্ঞাং প্ৰাপ্নোতি তস্মাদ্ দণ্ডে প্ৰবোধং জনযিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","যুষ্মভ্যং কথযিতুং মমানেকাঃ কথা আসতে, তাঃ কথা ইদানীং যূযং সোঢুং ন শক্নুথ; ");
INSERT INTO sanasm_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","কিন্তু সত্যময আত্মা যদা সমাগমিষ্যতি তদা সৰ্ৱ্ৱং সত্যং যুষ্মান্ নেষ্যতি, স স্ৱতঃ কিমপি ন ৱদিষ্যতি কিন্তু যচ্ছ্ৰোষ্যতি তদেৱ কথযিৎৱা ভাৱিকাৰ্য্যং যুষ্মান্ জ্ঞাপযিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","মম মহিমানং প্ৰকাশযিষ্যতি যতো মদীযাং কথাং গৃহীৎৱা যুষ্মান্ বোধযিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","পিতু ৰ্যদ্যদ্ আস্তে তৎ সৰ্ৱ্ৱং মম তস্মাদ্ কাৰণাদ্ অৱাদিষং স মদীযাং কথাং গৃহীৎৱা যুষ্মান্ বোধযিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","কিযৎকালাৎ পৰং যূযং মাং দ্ৰষ্টুং ন লপ্স্যধ্ৱে কিন্তু কিযৎকালাৎ পৰং পুন ৰ্দ্ৰষ্টুং লপ্স্যধ্ৱে যতোহং পিতুঃ সমীপং গচ্ছামি| ");
INSERT INTO sanasm_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ততঃ শিষ্যাণাং কিযন্তো জনাঃ পৰস্পৰং ৱদিতুম্ আৰভন্ত, কিযৎকালাৎ পৰং মাং দ্ৰষ্টুং ন লপ্স্যধ্ৱে কিন্তু কিযৎকালাৎ পৰং পুন ৰ্দ্ৰষ্টুং লপ্স্যধ্ৱে যতোহং পিতুঃ সমীপং গচ্ছামি, ইতি যদ্ ৱাক্যম্ অযং ৱদতি তৎ কিং? ");
INSERT INTO sanasm_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","ততঃ কিযৎকালাৎ পৰম্ ইতি তস্য ৱাক্যং কিং? তস্য ৱাক্যস্যাভিপ্ৰাযং ৱযং বোদ্ধুং ন শক্নুমস্তৈৰিতি ");
INSERT INTO sanasm_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","নিগদিতে যীশুস্তেষাং প্ৰশ্নেচ্ছাং জ্ঞাৎৱা তেভ্যোঽকথযৎ কিযৎকালাৎ পৰং মাং দ্ৰষ্টুং ন লপ্স্যধ্ৱে, কিন্তু কিযৎকালাৎ পৰং পূন ৰ্দ্ৰষ্টুং লপ্স্যধ্ৱে, যামিমাং কথামকথযং তস্যা অভিপ্ৰাযং কিং যূযং পৰস্পৰং মৃগযধ্ৱে? ");
INSERT INTO sanasm_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","যুষ্মানহম্ অতিযথাৰ্থং ৱদামি যূযং ক্ৰন্দিষ্যথ ৱিলপিষ্যথ চ, কিন্তু জগতো লোকা আনন্দিষ্যন্তি; যূযং শোকাকুলা ভৱিষ্যথ কিন্তু শোকাৎ পৰং আনন্দযুক্তা ভৱিষ্যথ| ");
INSERT INTO sanasm_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","প্ৰসৱকাল উপস্থিতে নাৰী যথা প্ৰসৱৱেদনযা ৱ্যাকুলা ভৱতি কিন্তু পুত্ৰে ভূমিষ্ঠে সতি মনুষ্যৈকো জন্মনা নৰলোকে প্ৰৱিষ্ট ইত্যানন্দাৎ তস্যাস্তৎসৰ্ৱ্ৱং দুঃখং মনসি ন তিষ্ঠতি, ");
INSERT INTO sanasm_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","তথা যূযমপি সাম্প্ৰতং শোকাকুলা ভৱথ কিন্তু পুনৰপি যুষ্মভ্যং দৰ্শনং দাস্যামি তেন যুষ্মাকম্ অন্তঃকৰণানি সানন্দানি ভৱিষ্যন্তি, যুষ্মাকং তম্ আনন্দঞ্চ কোপি হৰ্ত্তুং ন শক্ষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","তস্মিন্ দিৱসে কামপি কথাং মাং ন প্ৰক্ষ্যথ| যুষ্মানহম্ অতিযথাৰ্থং ৱদামি, মম নাম্না যৎ কিঞ্চিদ্ পিতৰং যাচিষ্যধ্ৱে তদেৱ স দাস্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","পূৰ্ৱ্ৱে মম নাম্না কিমপি নাযাচধ্ৱং, যাচধ্ৱং ততঃ প্ৰাপ্স্যথ তস্মাদ্ যুষ্মাকং সম্পূৰ্ণানন্দো জনিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","উপমাকথাভিঃ সৰ্ৱ্ৱাণ্যেতানি যুষ্মান্ জ্ঞাপিতৱান্ কিন্তু যস্মিন্ সমযে উপমযা নোক্ত্ৱা পিতুঃ কথাং স্পষ্টং জ্ঞাপযিষ্যামি সময এতাদৃশ আগচ্ছতি| ");
INSERT INTO sanasm_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","তদা মম নাম্না প্ৰাৰ্থযিষ্যধ্ৱে ঽহং যুষ্মন্নিমিত্তং পিতৰং ৱিনেষ্যে কথামিমাং ন ৱদামি; ");
INSERT INTO sanasm_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","যতো যূযং মযি প্ৰেম কুৰুথ, তথাহম্ ঈশ্ৱৰস্য সমীপাদ্ আগতৱান্ ইত্যপি প্ৰতীথ, তস্মাদ্ কাৰণাৎ কাৰণাৎ পিতা স্ৱযং যুষ্মাসু প্ৰীযতে| ");
INSERT INTO sanasm_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","পিতুঃ সমীপাজ্জজদ্ আগতোস্মি জগৎ পৰিত্যজ্য চ পুনৰপি পিতুঃ সমীপং গচ্ছামি| ");
INSERT INTO sanasm_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","তদা শিষ্যা অৱদন্, হে প্ৰভো ভৱান্ উপমযা নোক্ত্ৱাধুনা স্পষ্টং ৱদতি| ");
INSERT INTO sanasm_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ভৱান্ সৰ্ৱ্ৱজ্ঞঃ কেনচিৎ পৃষ্টো ভৱিতুমপি ভৱতঃ প্ৰযোজনং নাস্তীত্যধুনাস্মাকং স্থিৰজ্ঞানং জাতং তস্মাদ্ ভৱান্ ঈশ্ৱৰস্য সমীপাদ্ আগতৱান্ ইত্যত্ৰ ৱযং ৱিশ্ৱসিমঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ততো যীশুঃ প্ৰত্যৱাদীদ্ ইদানীং কিং যূযং ৱিশ্ৱসিথ? ");
INSERT INTO sanasm_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","পশ্যত সৰ্ৱ্ৱে যূযং ৱিকীৰ্ণাঃ সন্তো মাম্ একাকিনং পীৰত্যজ্য স্ৱং স্ৱং স্থানং গমিষ্যথ, এতাদৃশঃ সময আগচ্ছতি ৱৰং প্ৰাযেণোপস্থিতৱান্; তথাপ্যহং নৈকাকী ভৱামি যতঃ পিতা মযা সাৰ্দ্ধম্ আস্তে| ");
INSERT INTO sanasm_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","যথা মযা যুষ্মাকং শান্তি ৰ্জাযতে তদৰ্থম্ এতাঃ কথা যুষ্মভ্যম্ অচকথং; অস্মিন্ জগতি যুষ্মাকং ক্লেশো ঘটিষ্যতে কিন্ত্ৱক্ষোভা ভৱত যতো মযা জগজ্জিতং| ");
INSERT INTO sanasm_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","ততঃ পৰং যীশুৰেতাঃ কথাঃ কথযিৎৱা স্ৱৰ্গং ৱিলোক্যৈতৎ প্ৰাৰ্থযৎ, হে পিতঃ সময উপস্থিতৱান্; যথা তৱ পুত্ৰস্তৱ মহিমানং প্ৰকাশযতি তদৰ্থং ৎৱং নিজপুত্ৰস্য মহিমানং প্ৰকাশয| ");
INSERT INTO sanasm_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ৎৱং যোল্লোকান্ তস্য হস্তে সমৰ্পিতৱান্ স যথা তেভ্যোঽনন্তাযু ৰ্দদাতি তদৰ্থং ৎৱং প্ৰাণিমাত্ৰাণাম্ অধিপতিৎৱভাৰং তস্মৈ দত্তৱান্| ");
INSERT INTO sanasm_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","যস্ত্ৱম্ অদ্ৱিতীযঃ সত্য ঈশ্ৱৰস্ত্ৱযা প্ৰেৰিতশ্চ যীশুঃ খ্ৰীষ্ট এতযোৰুভযোঃ পৰিচযে প্ৰাপ্তেঽনন্তাযু ৰ্ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ৎৱং যস্য কৰ্ম্মণো ভাৰং মহ্যং দত্তৱান্, তৎ সম্পন্নং কৃৎৱা জগত্যস্মিন্ তৱ মহিমানং প্ৰাকাশযং| ");
INSERT INTO sanasm_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","অতএৱ হে পিত ৰ্জগত্যৱিদ্যমানে ৎৱযা সহ তিষ্ঠতো মম যো মহিমাসীৎ সম্প্ৰতি তৱ সমীপে মাং তং মহিমানং প্ৰাপয| ");
INSERT INTO sanasm_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","অন্যচ্চ ৎৱম্ এতজ্জগতো যাল্লোকান্ মহ্যম্ অদদা অহং তেভ্যস্তৱ নাম্নস্তত্ত্ৱজ্ঞানম্ অদদাং, তে তৱৈৱাসন্, ৎৱং তান্ মহ্যমদদাঃ, তস্মাত্তে তৱোপদেশম্ অগৃহ্লন্| ");
INSERT INTO sanasm_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ৎৱং মহ্যং যৎ কিঞ্চিদ্ অদদাস্তৎসৰ্ৱ্ৱং ৎৱত্তো জাযতে ইত্যধুনাজানন্| ");
INSERT INTO sanasm_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","মহ্যং যমুপদেশম্ অদদা অহমপি তেভ্যস্তমুপদেশম্ অদদাং তেপি তমগৃহ্লন্ ৎৱত্তোহং নিৰ্গত্য ৎৱযা প্ৰেৰিতোভৱম্ অত্ৰ চ ৱ্যশ্ৱসন্| ");
INSERT INTO sanasm_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","তেষামেৱ নিমিত্তং প্ৰাৰ্থযেঽহং জগতো লোকনিমিত্তং ন প্ৰাৰ্থযে কিন্তু যাল্লোকান্ মহ্যম্ অদদাস্তেষামেৱ নিমিত্তং প্ৰাৰ্থযেঽহং যতস্তে তৱৈৱাসতে| ");
INSERT INTO sanasm_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","যে মম তে তৱ যে চ তৱ তে মম তথা তৈ ৰ্মম মহিমা প্ৰকাশ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","সাম্প্ৰতম্ অস্মিন্ জগতি মমাৱস্থিতেঃ শেষম্ অভৱৎ অহং তৱ সমীপং গচ্ছামি কিন্তু তে জগতি স্থাস্যন্তি; হে পৱিত্ৰ পিতৰাৱযো ৰ্যথৈকৎৱমাস্তে তথা তেষামপ্যেকৎৱং ভৱতি তদৰ্থং যাল্লোকান্ মহ্যম্ অদদাস্তান্ স্ৱনাম্না ৰক্ষ| ");
INSERT INTO sanasm_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","যাৱন্তি দিনানি জগত্যস্মিন্ তৈঃ সহাহমাসং তাৱন্তি দিনানি তান্ তৱ নাম্নাহং ৰক্ষিতৱান্; যাল্লোকান্ মহ্যম্ অদদাস্তান্ সৰ্ৱ্ৱান্ অহমৰক্ষং, তেষাং মধ্যে কেৱলং ৱিনাশপাত্ৰং হাৰিতং তেন ধৰ্ম্মপুস্তকস্য ৱচনং প্ৰত্যক্ষং ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","কিন্ত্ৱধুনা তৱ সন্নিধিং গচ্ছামি মযা যথা তেষাং সম্পূৰ্ণানন্দো ভৱতি তদৰ্থমহং জগতি তিষ্ঠন্ এতাঃ কথা অকথযম্| ");
INSERT INTO sanasm_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","তৱোপদেশং তেভ্যোঽদদাং জগতা সহ যথা মম সম্বন্ধো নাস্তি তথা জজতা সহ তেষামপি সম্বন্ধাভাৱাজ্ জগতো লোকাস্তান্ ঋতীযন্তে| ");
INSERT INTO sanasm_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","ৎৱং জগতস্তান্ গৃহাণেতি ন প্ৰাৰ্থযে কিন্ত্ৱশুভাদ্ ৰক্ষেতি প্ৰাৰ্থযেহম্| ");
INSERT INTO sanasm_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","অহং যথা জগৎসম্বন্ধীযো ন ভৱামি তথা তেপি জগৎসম্বন্ধীযা ন ভৱন্তি| ");
INSERT INTO sanasm_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","তৱ সত্যকথযা তান্ পৱিত্ৰীকুৰু তৱ ৱাক্যমেৱ সত্যং| ");
INSERT INTO sanasm_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ৎৱং যথা মাং জগতি প্ৰৈৰযস্তথাহমপি তান্ জগতি প্ৰৈৰযং| ");
INSERT INTO sanasm_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","তেষাং হিতাৰ্থং যথাহং স্ৱং পৱিত্ৰীকৰোমি তথা সত্যকথযা তেপি পৱিত্ৰীভৱন্তু| ");
INSERT INTO sanasm_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","কেৱলং এতেষামৰ্থে প্ৰাৰ্থযেঽহম্ ইতি ন কিন্ত্ৱেতেষামুপদেশেন যে জনা মযি ৱিশ্ৱসিষ্যন্তি তেষামপ্যৰ্থে প্ৰাৰ্থেযেঽহম্| ");
INSERT INTO sanasm_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","হে পিতস্তেষাং সৰ্ৱ্ৱেষাম্ একৎৱং ভৱতু তৱ যথা মযি মম চ যথা ৎৱয্যেকৎৱং তথা তেষামপ্যাৱযোৰেকৎৱং ভৱতু তেন ৎৱং মাং প্ৰেৰিতৱান্ ইতি জগতো লোকাঃ প্ৰতিযন্তু| ");
INSERT INTO sanasm_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","যথাৱযোৰেকৎৱং তথা তেষামপ্যেকৎৱং ভৱতু তেষ্ৱহং মযি চ ৎৱম্ ইত্থং তেষাং সম্পূৰ্ণমেকৎৱং ভৱতু, ৎৱং প্ৰেৰিতৱান্ ৎৱং মযি যথা প্ৰীযসে চ তথা তেষ্ৱপি প্ৰীতৱান্ এতদ্যথা জগতো লোকা জানন্তি ");
INSERT INTO sanasm_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","তদৰ্থং ৎৱং যং মহিমানং মহ্যম্ অদদাস্তং মহিমানম্ অহমপি তেভ্যো দত্তৱান্| ");
INSERT INTO sanasm_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","হে পিত ৰ্জগতো নিৰ্ম্মাণাৎ পূৰ্ৱ্ৱং মযি স্নেহং কৃৎৱা যং মহিমানং দত্তৱান্ মম তং মহিমানং যথা তে পশ্যন্তি তদৰ্থং যাল্লোকান্ মহ্যং দত্তৱান্ অহং যত্ৰ তিষ্ঠামি তেপি যথা তত্ৰ তিষ্ঠন্তি মমৈষা ৱাঞ্ছা| ");
INSERT INTO sanasm_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","হে যথাৰ্থিক পিত ৰ্জগতো লোকৈস্ত্ৱয্যজ্ঞাতেপি ৎৱামহং জানে ৎৱং মাং প্ৰেৰিতৱান্ ইতীমে শিষ্যা জানন্তি| ");
INSERT INTO sanasm_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","যথাহং তেষু তিষ্ঠামি তথা মযি যেন প্ৰেম্না প্ৰেমাকৰোস্তৎ তেষু তিষ্ঠতি তদৰ্থং তৱ নামাহং তান্ জ্ঞাপিতৱান্ পুনৰপি জ্ঞাপযিষ্যামি| ");
INSERT INTO sanasm_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","তাঃ কথাঃ কথযিৎৱা যীশুঃ শিষ্যানাদায কিদ্ৰোন্নামকং স্ৰোত উত্তীৰ্য্য শিষ্যৈঃ সহ তত্ৰত্যোদ্যানং প্ৰাৱিশৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","কিন্তু ৱিশ্ৱাসঘাতিযিহূদাস্তৎ স্থানং পৰিচীযতে যতো যীশুঃ শিষ্যৈঃ সাৰ্দ্ধং কদাচিৎ তৎ স্থানম্ অগচ্ছৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","তদা স যিহূদাঃ সৈন্যগণং প্ৰধানযাজকানাং ফিৰূশিনাঞ্চ পদাতিগণঞ্চ গৃহীৎৱা প্ৰদীপান্ উল্কান্ অস্ত্ৰাণি চাদায তস্মিন্ স্থান উপস্থিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","স্ৱং প্ৰতি যদ্ ঘটিষ্যতে তজ্ জ্ঞাৎৱা যীশুৰগ্ৰেসৰঃ সন্ তানপৃচ্ছৎ কং গৱেষযথ? ");
INSERT INTO sanasm_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","তে প্ৰত্যৱদন্, নাসৰতীযং যীশুং; ততো যীশুৰৱাদীদ্ অহমেৱ সঃ; তৈঃ সহ ৱিশ্ৱাসঘাতী যিহূদাশ্চাতিষ্ঠৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","তদাহমেৱ স তস্যৈতাং কথাং শ্ৰুৎৱৈৱ তে পশ্চাদেত্য ভূমৌ পতিতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","ততো যীশুঃ পুনৰপি পৃষ্ঠৱান্ কং গৱেষযথ? ততস্তে প্ৰত্যৱদন্ নাসৰতীযং যীশুং| ");
INSERT INTO sanasm_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","তদা যীশুঃ প্ৰত্যুদিতৱান্ অহমেৱ স ইমাং কথামচকথম্; যদি মামন্ৱিচ্ছথ তৰ্হীমান্ গন্তুং মা ৱাৰযত| ");
INSERT INTO sanasm_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ইত্থং ভূতে মহ্যং যাল্লোকান্ অদদাস্তেষাম্ একমপি নাহাৰযম্ ইমাং যাং কথাং স স্ৱযমকথযৎ সা কথা সফলা জাতা| ");
INSERT INTO sanasm_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","তদা শিমোন্পিতৰস্য নিকটে খঙ্গল্স্থিতেঃ স তং নিষ্কোষং কৃৎৱা মহাযাজকস্য মাল্খনামানং দাসম্ আহত্য তস্য দক্ষিণকৰ্ণং ছিন্নৱান্| ");
INSERT INTO sanasm_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ততো যীশুঃ পিতৰম্ অৱদৎ, খঙ্গং কোষে স্থাপয মম পিতা মহ্যং পাতুং যং কংসম্ অদদাৎ তেনাহং কিং ন পাস্যামি? ");
INSERT INTO sanasm_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","তদা সৈন্যগণঃ সেনাপতি ৰ্যিহূদীযানাং পদাতযশ্চ যীশুং ঘৃৎৱা বদ্ধ্ৱা হানন্নাম্নঃ কিযফাঃ শ্ৱশুৰস্য সমীপং প্ৰথমম্ অনযন্| ");
INSERT INTO sanasm_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","স কিযফাস্তস্মিন্ ৱৎসৰে মহাযাজৎৱপদে নিযুক্তঃ ");
INSERT INTO sanasm_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","সন্ সাধাৰণলোকানাং মঙ্গলাৰ্থম্ একজনস্য মৰণমুচিতম্ ইতি যিহূদীযৈঃ সাৰ্দ্ধম্ অমন্ত্ৰযৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","তদা শিমোন্পিতৰোঽন্যৈকশিষ্যশ্চ যীশোঃ পশ্চাদ্ অগচ্ছতাং তস্যান্যশিষ্যস্য মহাযাজকেন পৰিচিতৎৱাৎ স যীশুনা সহ মহাযাজকস্যাট্টালিকাং প্ৰাৱিশৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","কিন্তু পিতৰো বহিৰ্দ্ৱাৰস্য সমীপেঽতিষ্ঠদ্ অতএৱ মহাযাজকেন পৰিচিতঃ স শিষ্যঃ পুনৰ্বহিৰ্গৎৱা দৌৱাযিকাযৈ কথযিৎৱা পিতৰম্ অভ্যন্তৰম্ আনযৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","তদা স দ্ৱাৰৰক্ষিকা পিতৰম্ অৱদৎ ৎৱং কিং ন তস্য মানৱস্য শিষ্যঃ? ততঃ সোৱদদ্ অহং ন ভৱামি| ");
INSERT INTO sanasm_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ততঃ পৰং যৎস্থানে দাসাঃ পদাতযশ্চ শীতহেতোৰঙ্গাৰৈ ৰ্ৱহ্নিং প্ৰজ্ৱাল্য তাপং সেৱিতৱন্তস্তৎস্থানে পিতৰস্তিষ্ঠন্ তৈঃ সহ ৱহ্নিতাপং সেৱিতুম্ আৰভত| ");
INSERT INTO sanasm_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","তদা শিষ্যেষূপদেশে চ মহাযাজকেন যীশুঃ পৃষ্টঃ ");
INSERT INTO sanasm_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","সন্ প্ৰত্যুক্তৱান্ সৰ্ৱ্ৱলোকানাং সমক্ষং কথামকথযং গুপ্তং কামপি কথাং ন কথযিৎৱা যৎ স্থানং যিহূদীযাঃ সততং গচ্ছন্তি তত্ৰ ভজনগেহে মন্দিৰে চাশিক্ষযং| ");
INSERT INTO sanasm_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","মত্তঃ কুতঃ পৃচ্ছসি? যে জনা মদুপদেশম্ অশৃণ্ৱন্ তানেৱ পৃচ্ছ যদ্যদ্ অৱদং তে তৎ জানিন্ত| ");
INSERT INTO sanasm_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","তদেত্থং প্ৰত্যুদিতৎৱাৎ নিকটস্থপদাতি ৰ্যীশুং চপেটেনাহত্য ৱ্যাহৰৎ মহাযাজকম্ এৱং প্ৰতিৱদসি? ");
INSERT INTO sanasm_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ততো যীশুঃ প্ৰতিগদিতৱান্ যদ্যযথাৰ্থম্ অচকথং তৰ্হি তস্যাযথাৰ্থস্য প্ৰমাণং দেহি, কিন্তু যদি যথাৰ্থং তৰ্হি কুতো হেতো ৰ্মাম্ অতাডযঃ? ");
INSERT INTO sanasm_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","পূৰ্ৱ্ৱং হানন্ সবন্ধনং তং কিযফামহাযাজকস্য সমীপং প্ৰৈষযৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","শিমোন্পিতৰস্তিষ্ঠন্ ৱহ্নিতাপং সেৱতে, এতস্মিন্ সমযে কিযন্তস্তম্ অপৃচ্ছন্ ৎৱং কিম্ এতস্য জনস্য শিষ্যো ন? ততঃ সোপহ্নুত্যাব্ৰৱীদ্ অহং ন ভৱামি| ");
INSERT INTO sanasm_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","তদা মহাযাজকস্য যস্য দাসস্য পিতৰঃ কৰ্ণমচ্ছিনৎ তস্য কুটুম্বঃ প্ৰত্যুদিতৱান্ উদ্যানে তেন সহ তিষ্ঠন্তং ৎৱাং কিং নাপশ্যং? ");
INSERT INTO sanasm_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","কিন্তু পিতৰঃ পুনৰপহ্নুত্য কথিতৱান্; তদানীং কুক্কুটোঽৰৌৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","তদনন্তৰং প্ৰত্যূষে তে কিযফাগৃহাদ্ অধিপতে ৰ্গৃহং যীশুম্ অনযন্ কিন্তু যস্মিন্ অশুচিৎৱে জাতে তৈ ৰ্নিস্তাৰোৎসৱে ন ভোক্তৱ্যং, তস্য ভযাদ্ যিহূদীযাস্তদ্গৃহং নাৱিশন্| ");
INSERT INTO sanasm_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","অপৰং পীলাতো বহিৰাগত্য তান্ পৃষ্ঠৱান্ এতস্য মনুষ্যস্য কং দোষং ৱদথ? ");
INSERT INTO sanasm_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","তদা তে পেত্যৱদন্ দুষ্কৰ্ম্মকাৰিণি ন সতি ভৱতঃ সমীপে নৈনং সমাৰ্পযিষ্যামঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ততঃ পীলাতোঽৱদদ্ যূযমেনং গৃহীৎৱা স্ৱেষাং ৱ্যৱস্থযা ৱিচাৰযত| তদা যিহূদীযাঃ প্ৰত্যৱদন্ কস্যাপি মনুষ্যস্য প্ৰাণদণ্ডং কৰ্ত্তুং নাস্মাকম্ অধিকাৰোঽস্তি| ");
INSERT INTO sanasm_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","এৱং সতি যীশুঃ স্ৱস্য মৃত্যৌ যাং কথাং কথিতৱান্ সা সফলাভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","তদনন্তৰং পীলাতঃ পুনৰপি তদ্ ৰাজগৃহং গৎৱা যীশুমাহূয পৃষ্টৱান্ ৎৱং কিং যিহূদীযানাং ৰাজা? ");
INSERT INTO sanasm_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","যীশুঃ প্ৰত্যৱদৎ ৎৱম্ এতাং কথাং স্ৱতঃ কথযসি কিমন্যঃ কশ্চিন্ মযি কথিতৱান্? ");
INSERT INTO sanasm_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","পীলাতোঽৱদদ্ অহং কিং যিহূদীযঃ? তৱ স্ৱদেশীযা ৱিশেষতঃ প্ৰধানযাজকা মম নিকটে ৎৱাং সমাৰ্পযন, ৎৱং কিং কৃতৱান্? ");
INSERT INTO sanasm_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","যীশুঃ প্ৰত্যৱদৎ মম ৰাজ্যম্ এতজ্জগৎসম্বন্ধীযং ন ভৱতি যদি মম ৰাজ্যং জগৎসম্বন্ধীযম্ অভৱিষ্যৎ তৰ্হি যিহূদীযানাং হস্তেষু যথা সমৰ্পিতো নাভৱং তদৰ্থং মম সেৱকা অযোৎস্যন্ কিন্তু মম ৰাজ্যম্ ঐহিকং ন| ");
INSERT INTO sanasm_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","তদা পীলাতঃ কথিতৱান্, তৰ্হি ৎৱং ৰাজা ভৱসি? যীশুঃ প্ৰত্যুক্তৱান্ ৎৱং সত্যং কথযসি, ৰাজাহং ভৱামি; সত্যতাযাং সাক্ষ্যং দাতুং জনিং গৃহীৎৱা জগত্যস্মিন্ অৱতীৰ্ণৱান্, তস্মাৎ সত্যধৰ্ম্মপক্ষপাতিনো মম কথাং শৃণ্ৱন্তি| ");
INSERT INTO sanasm_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","তদা সত্যং কিং? এতাং কথাং পষ্ট্ৱা পীলাতঃ পুনৰপি বহিৰ্গৎৱা যিহূদীযান্ অভাষত, অহং তস্য কমপ্যপৰাধং ন প্ৰাপ্নোমি| ");
INSERT INTO sanasm_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","নিস্তাৰোৎসৱসমযে যুষ্মাভিৰভিৰুচিত একো জনো মযা মোচযিতৱ্য এষা যুষ্মাকং ৰীতিৰস্তি, অতএৱ যুষ্মাকং নিকটে যিহূদীযানাং ৰাজানং কিং মোচযামি, যুষ্মাকম্ ইচ্ছা কা? ");
INSERT INTO sanasm_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","তদা তে সৰ্ৱ্ৱে ৰুৱন্তো ৱ্যাহৰন্ এনং মানুষং নহি বৰব্বাং মোচয| কিন্তু স বৰব্বা দস্যুৰাসীৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","পীলাতো যীশুম্ আনীয কশযা প্ৰাহাৰযৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","পশ্চাৎ সেনাগণঃ কণ্টকনিৰ্ম্মিতং মুকুটং তস্য মস্তকে সমৰ্প্য ৱাৰ্ত্তাকীৱৰ্ণং ৰাজপৰিচ্ছদং পৰিধাপ্য, ");
INSERT INTO sanasm_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","হে যিহূদীযানাং ৰাজন্ নমস্কাৰ ইত্যুক্ত্ৱা তং চপেটেনাহন্তুম্ আৰভত| ");
INSERT INTO sanasm_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","তদা পীলাতঃ পুনৰপি বহিৰ্গৎৱা লোকান্ অৱদৎ, অস্য কমপ্যপৰাধং ন লভেঽহং, পশ্যত তদ্ যুষ্মান্ জ্ঞাপযিতুং যুষ্মাকং সন্নিধৌ বহিৰেনম্ আনযামি| ");
INSERT INTO sanasm_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","ততঃ পৰং যীশুঃ কণ্টকমুকুটৱান্ ৱাৰ্ত্তাকীৱৰ্ণৱসনৱাংশ্চ বহিৰাগচ্ছৎ| ততঃ পীলাত উক্তৱান্ এনং মনুষ্যং পশ্যত| ");
INSERT INTO sanasm_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","তদা প্ৰধানযাজকাঃ পদাতযশ্চ তং দৃষ্ট্ৱা, এনং ক্ৰুশে ৱিধ, এনং ক্ৰুশে ৱিধ, ইত্যুক্ত্ৱা ৰৱিতুং আৰভন্ত| ততঃ পীলাতঃ কথিতৱান্ যূযং স্ৱযম্ এনং নীৎৱা ক্ৰুশে ৱিধত, অহম্ এতস্য কমপ্যপৰাধং ন প্ৰাপ্তৱান্| ");
INSERT INTO sanasm_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","যিহূদীযাঃ প্ৰত্যৱদন্ অস্মাকং যা ৱ্যৱস্থাস্তে তদনুসাৰেণাস্য প্ৰাণহননম্ উচিতং যতোযং স্ৱম্ ঈশ্ৱৰস্য পুত্ৰমৱদৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","পীলাত ইমাং কথাং শ্ৰুৎৱা মহাত্ৰাসযুক্তঃ ");
INSERT INTO sanasm_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","সন্ পুনৰপি ৰাজগৃহ আগত্য যীশুং পৃষ্টৱান্ ৎৱং কুত্ৰত্যো লোকঃ? কিন্তু যীশস্তস্য কিমপি প্ৰত্যুত্তৰং নাৱদৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","১॰ ততঃ পীলাৎ কথিতৱান ৎৱং কিং মযা সাৰ্দ্ধং ন সংলপিষ্যসি ? ৎৱাং ক্ৰুশে ৱেধিতুং ৱা মোচযিতুং শক্তি ৰ্মমাস্তে ইতি কিং ৎৱং ন জানাসি ? তদা যীশুঃ প্ৰত্যৱদদ্ ঈশ্ৱৰেণাদŸाং মমোপৰি তৱ কিমপ্যধিপতিৎৱং ন ৱিদ্যতে, তথাপি যো জনো মাং তৱ হস্তে সমাৰ্পযৎ তস্য মহাপাতকং জাতম্| ");
INSERT INTO sanasm_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","তদা যীশুঃ প্ৰত্যৱদদ্ ঈশ্ৱৰেণাদত্তং মমোপৰি তৱ কিমপ্যধিপতিৎৱং ন ৱিদ্যতে, তথাপি যো জনো মাং তৱ হস্তে সমাৰ্পযৎ তস্য মহাপাতকং জাতম্| ");
INSERT INTO sanasm_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","তদাৰভ্য পীলাতস্তং মোচযিতুং চেষ্টিতৱান্ কিন্তু যিহূদীযা ৰুৱন্তো ৱ্যাহৰন্ যদীমং মানৱং ত্যজসি তৰ্হি ৎৱং কৈসৰস্য মিত্ৰং ন ভৱসি, যো জনঃ স্ৱং ৰাজানং ৱক্তি সএৱ কৈমৰস্য ৱিৰুদ্ধাং কথাং কথযতি| ");
INSERT INTO sanasm_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","এতাং কথাং শ্ৰুৎৱা পীলাতো যীশুং বহিৰানীয নিস্তাৰোৎসৱস্য আসাদনদিনস্য দ্ৱিতীযপ্ৰহৰাৎ পূৰ্ৱ্ৱং প্ৰস্তৰবন্ধননাম্নি স্থানে ঽৰ্থাৎ ইব্ৰীযভাষযা যদ্ গব্বিথা কথ্যতে তস্মিন্ স্থানে ৱিচাৰাসন উপাৱিশৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","অনন্তৰং পীলাতো যিহূদীযান্ অৱদৎ, যুষ্মাকং ৰাজানং পশ্যত| ");
INSERT INTO sanasm_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","কিন্তু এনং দূৰীকুৰু, এনং দূৰীকুৰু, এনং ক্ৰুশে ৱিধ, ইতি কথাং কথযিৎৱা তে ৰৱিতুম্ আৰভন্ত; তদা পীলাতঃ কথিতৱান্ যুষ্মাকং ৰাজানং কিং ক্ৰুশে ৱেধিষ্যামি? প্ৰধানযাজকা উত্তৰম্ অৱদন্ কৈসৰং ৱিনা কোপি ৰাজাস্মাকং নাস্তি| ");
INSERT INTO sanasm_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","ততঃ পীলাতো যীশুং ক্ৰুশে ৱেধিতুং তেষাং হস্তেষু সমাৰ্পযৎ, ততস্তে তং ধৃৎৱা নীতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ততঃ পৰং যীশুঃ ক্ৰুশং ৱহন্ শিৰঃকপালম্ অৰ্থাদ্ যদ্ ইব্ৰীযভাষযা গুল্গল্তাং ৱদন্তি তস্মিন্ স্থান উপস্থিতঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ততস্তে মধ্যস্থানে তং তস্যোভযপাৰ্শ্ৱে দ্ৱাৱপৰৌ ক্ৰুশেঽৱিধন্| ");
INSERT INTO sanasm_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","অপৰম্ এষ যিহূদীযানাং ৰাজা নাসৰতীযযীশুঃ, ইতি ৱিজ্ঞাপনং লিখিৎৱা পীলাতস্তস্য ক্ৰুশোপৰি সমযোজযৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","সা লিপিঃ ইব্ৰীযযূনানীযৰোমীযভাষাভি ৰ্লিখিতা; যীশোঃ ক্ৰুশৱেধনস্থানং নগৰস্য সমীপং, তস্মাদ্ বহৱো যিহূদীযাস্তাং পঠিতুম্ আৰভন্ত| ");
INSERT INTO sanasm_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","যিহূদীযানাং প্ৰধানযাজকাঃ পীলাতমিতি ন্যৱেদযন্ যিহূদীযানাং ৰাজেতি ৱাক্যং ন কিন্তু এষ স্ৱং যিহূদীযানাং ৰাজানম্ অৱদদ্ ইত্থং লিখতু| ");
INSERT INTO sanasm_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","ততঃ পীলাত উত্তৰং দত্তৱান্ যল্লেখনীযং তল্লিখিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","ইত্থং সেনাগণো যীশুং ক্ৰুশে ৱিধিৎৱা তস্য পৰিধেযৱস্ত্ৰং চতুৰো ভাগান্ কৃৎৱা একৈকসেনা একৈকভাগম্ অগৃহ্লৎ তস্যোত্তৰীযৱস্ত্ৰঞ্চাগৃহ্লৎ| কিন্তূত্তৰীযৱস্ত্ৰং সূচিসেৱনং ৱিনা সৰ্ৱ্ৱম্ ঊতং| ");
INSERT INTO sanasm_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","তস্মাত্তে ৱ্যাহৰন্ এতৎ কঃ প্ৰাপ্স্যতি? তন্ন খণ্ডযিৎৱা তত্ৰ গুটিকাপাতং কৰৱাম| ৱিভজন্তেঽধৰীযং মে ৱসনং তে পৰস্পৰং| মমোত্তৰীযৱস্ত্ৰাৰ্থং গুটিকাং পাতযন্তি চ| ইতি যদ্ৱাক্যং ধৰ্ম্মপুস্তকে লিখিতমাস্তে তৎ সেনাগণেনেত্থং ৱ্যৱহৰণাৎ সিদ্ধমভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","তদানীং যীশো ৰ্মাতা মাতু ৰ্ভগিনী চ যা ক্লিযপা ভাৰ্য্যা মৰিযম্ মগ্দলীনী মৰিযম্ চ এতাস্তস্য ক্ৰুশস্য সন্নিধৌ সমতিষ্ঠন্| ");
INSERT INTO sanasm_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","ততো যীশুঃ স্ৱমাতৰং প্ৰিযতমশিষ্যঞ্চ সমীপে দণ্ডাযমানৌ ৱিলোক্য মাতৰম্ অৱদৎ, হে যোষিদ্ এনং তৱ পুত্ৰং পশ্য, ");
INSERT INTO sanasm_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","শিষ্যন্ত্ৱৱদৎ, এনাং তৱ মাতৰং পশ্য| ততঃ স শিষ্যস্তদ্ঘটিকাযাং তাং নিজগৃহং নীতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","অনন্তৰং সৰ্ৱ্ৱং কৰ্ম্মাধুনা সম্পন্নমভূৎ যীশুৰিতি জ্ঞাৎৱা ধৰ্ম্মপুস্তকস্য ৱচনং যথা সিদ্ধং ভৱতি তদৰ্থম্ অকথযৎ মম পিপাসা জাতা| ");
INSERT INTO sanasm_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ততস্তস্মিন্ স্থানে অম্লৰসেন পূৰ্ণপাত্ৰস্থিত্যা তে স্পঞ্জমেকং তদম্লৰসেনাৰ্দ্ৰীকৃত্য এসোব্নলে তদ্ যোজযিৎৱা তস্য মুখস্য সন্নিধাৱস্থাপযন্| ");
INSERT INTO sanasm_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","তদা যীশুৰম্লৰসং গৃহীৎৱা সৰ্ৱ্ৱং সিদ্ধম্ ইতি কথাং কথযিৎৱা মস্তকং নমযন্ প্ৰাণান্ পৰ্য্যত্যজৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","তদ্ৱিনম্ আসাদনদিনং তস্মাৎ পৰেঽহনি ৱিশ্ৰামৱাৰে দেহা যথা ক্ৰুশোপৰি ন তিষ্ঠন্তি, যতঃ স ৱিশ্ৰামৱাৰো মহাদিনমাসীৎ, তস্মাদ্ যিহূদীযাঃ পীলাতনিকটং গৎৱা তেষাং পাদভঞ্জনস্য স্থানান্তৰনযনস্য চানুমতিং প্ৰাৰ্থযন্ত| ");
INSERT INTO sanasm_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","অতঃ সেনা আগত্য যীশুনা সহ ক্ৰুশে হতযোঃ প্ৰথমদ্ৱিতীযচোৰযোঃ পাদান্ অভঞ্জন্; ");
INSERT INTO sanasm_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","কিন্তু যীশোঃ সন্নিধিং গৎৱা স মৃত ইতি দৃষ্ট্ৱা তস্য পাদৌ নাভঞ্জন্| ");
INSERT INTO sanasm_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","পশ্চাদ্ একো যোদ্ধা শূলাঘাতেন তস্য কুক্ষিম্ অৱিধৎ তৎক্ষণাৎ তস্মাদ্ ৰক্তং জলঞ্চ নিৰগচ্ছৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","যো জনোঽস্য সাক্ষ্যং দদাতি স স্ৱযং দৃষ্টৱান্ তস্যেদং সাক্ষ্যং সত্যং তস্য কথা যুষ্মাকং ৱিশ্ৱাসং জনযিতুং যোগ্যা তৎ স জানাতি| ");
INSERT INTO sanasm_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","তস্যৈকম্ অস্ধ্যপি ন ভংক্ষ্যতে, ");
INSERT INTO sanasm_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","তদ্ৱদ্ অন্যশাস্ত্ৰেপি লিখ্যতে, যথা, \"দৃষ্টিপাতং কৰিষ্যন্তি তেঽৱিধন্ যন্তু তম্প্ৰতি| \" ");
INSERT INTO sanasm_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","অৰিমথীযনগৰস্য যূষফ্নামা শিষ্য এক আসীৎ কিন্তু যিহূদীযেভ্যো ভযাৎ প্ৰকাশিতো ন ভৱতি; স যীশো ৰ্দেহং নেতুং পীলাতস্যানুমতিং প্ৰাৰ্থযত, ততঃ পীলাতেনানুমতে সতি স গৎৱা যীশো ৰ্দেহম্ অনযৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","অপৰং যো নিকদীমো ৰাত্ৰৌ যীশোঃ সমীপম্ অগচ্ছৎ সোপি গন্ধৰসেন মিশ্ৰিতং প্ৰাযেণ পঞ্চাশৎসেটকমগুৰুং গৃহীৎৱাগচ্ছৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","ততস্তে যিহূদীযানাং শ্মশানে স্থাপনৰীত্যনুসাৰেণ তৎসুগন্ধিদ্ৰৱ্যেণ সহিতং তস্য দেহং ৱস্ত্ৰেণাৱেষ্টযন্| ");
INSERT INTO sanasm_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","অপৰঞ্চ যত্ৰ স্থানে তং ক্ৰুশেঽৱিধন্ তস্য নিকটস্থোদ্যানে যত্ৰ কিমপি মৃতদেহং কদাপি নাস্থাপ্যত তাদৃশম্ একং নূতনং শ্মশানম্ আসীৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","যিহূদীযানাম্ আসাদনদিনাগমনাৎ তে তস্মিন্ সমীপস্থশ্মশানে যীশুম্ অশাযযন্| ");
INSERT INTO sanasm_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","অনন্তৰং সপ্তাহস্য প্ৰথমদিনে ঽতিপ্ৰত্যূষে ঽন্ধকাৰে তিষ্ঠতি মগ্দলীনী মৰিযম্ তস্য শ্মশানস্য নিকটং গৎৱা শ্মশানস্য মুখাৎ প্ৰস্তৰমপসাৰিতম্ অপশ্যৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","পশ্চাদ্ ধাৱিৎৱা শিমোন্পিতৰায যীশোঃ প্ৰিযতমশিষ্যায চেদম্ অকথযৎ, লোকাঃ শ্মশানাৎ প্ৰভুং নীৎৱা কুত্ৰাস্থাপযন্ তদ্ ৱক্তুং ন শক্নোমি| ");
INSERT INTO sanasm_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","অতঃ পিতৰঃ সোন্যশিষ্যশ্চ বৰ্হি ৰ্ভুৎৱা শ্মশানস্থানং গন্তুম্ আৰভেতাং| ");
INSERT INTO sanasm_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","উভযোৰ্ধাৱতোঃ সোন্যশিষ্যঃ পিতৰং পশ্চাৎ ত্যক্ত্ৱা পূৰ্ৱ্ৱং শ্মশানস্থান উপস্থিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","তদা প্ৰহ্ৱীভূয স্থাপিতৱস্ত্ৰাণি দৃষ্টৱান্ কিন্তু ন প্ৰাৱিশৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","অপৰং শিমোন্পিতৰ আগত্য শ্মশানস্থানং প্ৰৱিশ্য ");
INSERT INTO sanasm_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","স্থাপিতৱস্ত্ৰাণি মস্তকস্য ৱস্ত্ৰঞ্চ পৃথক্ স্থানান্তৰে স্থাপিতং দৃষ্টৱান্| ");
INSERT INTO sanasm_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","ততঃ শ্মশানস্থানং পূৰ্ৱ্ৱম্ আগতো যোন্যশিষ্যঃ সোপি প্ৰৱিশ্য তাদৃশং দৃষ্টা ৱ্যশ্ৱসীৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","যতঃ শ্মশানাৎ স উত্থাপযিতৱ্য এতস্য ধৰ্ম্মপুস্তকৱচনস্য ভাৱং তে তদা ৱোদ্ধুং নাশন্কুৱন্| ");
INSERT INTO sanasm_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","অনন্তৰং তৌ দ্ৱৌ শিষ্যৌ স্ৱং স্ৱং গৃহং পৰাৱৃত্যাগচ্ছতাম্| ");
INSERT INTO sanasm_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","ততঃ পৰং মৰিযম্ শ্মশানদ্ৱাৰস্য বহিঃ স্থিৎৱা ৰোদিতুম্ আৰভত ততো ৰুদতী প্ৰহ্ৱীভূয শ্মশানং ৱিলোক্য ");
INSERT INTO sanasm_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","যীশোঃ শযনস্থানস্য শিৰঃস্থানে পদতলে চ দ্ৱযো ৰ্দিশো দ্ৱৌ স্ৱৰ্গীযদূতাৱুপৱিষ্টৌ সমপশ্যৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","তৌ পৃষ্টৱন্তৌ হে নাৰি কুতো ৰোদিষি? সাৱদৎ লোকা মম প্ৰভুং নীৎৱা কুত্ৰাস্থাপযন্ ইতি ন জানামি| ");
INSERT INTO sanasm_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ইত্যুক্ত্ৱা মুখং পৰাৱৃত্য যীশুং দণ্ডাযমানম্ অপশ্যৎ কিন্তু স যীশুৰিতি সা জ্ঞাতুং নাশক্নোৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","তদা যীশুস্তাম্ অপৃচ্ছৎ হে নাৰি কুতো ৰোদিষি? কং ৱা মৃগযসে? ততঃ সা তম্ উদ্যানসেৱকং জ্ঞাৎৱা ৱ্যাহৰৎ, হে মহেচ্ছ ৎৱং যদীতঃ স্থানাৎ তং নীতৱান্ তৰ্হি কুত্ৰাস্থাপযস্তদ্ ৱদ তৎস্থানাৎ তম্ আনযামি| ");
INSERT INTO sanasm_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","তদা যীশুস্তাম্ অৱদৎ হে মৰিযম্| ততঃ সা পৰাৱৃত্য প্ৰত্যৱদৎ হে ৰব্বূনী অৰ্থাৎ হে গুৰো| ");
INSERT INTO sanasm_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","তদা যীশুৰৱদৎ মাং মা ধৰ, ইদানীং পিতুঃ সমীপে ঊৰ্দ্ধ্ৱগমনং ন কৰোমি কিন্তু যো মম যুষ্মাকঞ্চ পিতা মম যুষ্মাকঞ্চেশ্ৱৰস্তস্য নিকট ঊৰ্দ্ধ্ৱগমনং কৰ্ত্তুম্ উদ্যতোস্মি, ইমাং কথাং ৎৱং গৎৱা মম ভ্ৰাতৃগণং জ্ঞাপয| ");
INSERT INTO sanasm_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","ততো মগ্দলীনীমৰিযম্ তৎক্ষণাদ্ গৎৱা প্ৰভুস্তস্যৈ দৰ্শনং দত্ত্ৱা কথা এতা অকথযদ্ ইতি ৱাৰ্ত্তাং শিষ্যেভ্যোঽকথযৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ততঃ পৰং সপ্তাহস্য প্ৰথমদিনস্য সন্ধ্যাসমযে শিষ্যা একত্ৰ মিলিৎৱা যিহূদীযেভ্যো ভিযা দ্ৱাৰৰুদ্ধম্ অকুৰ্ৱ্ৱন্, এতস্মিন্ কালে যীশুস্তেষাং মধ্যস্থানে তিষ্ঠন্ অকথযদ্ যুষ্মাকং কল্যাণং ভূযাৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ইত্যুক্ত্ৱা নিজহস্তং কুক্ষিঞ্চ দৰ্শিতৱান্, ততঃ শিষ্যাঃ প্ৰভুং দৃষ্ট্ৱা হৃষ্টা অভৱন্| ");
INSERT INTO sanasm_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","যীশুঃ পুনৰৱদদ্ যুষ্মাকং কল্যাণং ভূযাৎ পিতা যথা মাং প্ৰৈষযৎ তথাহমপি যুষ্মান্ প্ৰেষযামি| ");
INSERT INTO sanasm_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ইত্যুক্ত্ৱা স তেষামুপৰি দীৰ্ঘপ্ৰশ্ৱাসং দত্ত্ৱা কথিতৱান্ পৱিত্ৰম্ আত্মানং গৃহ্লীত| ");
INSERT INTO sanasm_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","যূযং যেষাং পাপানি মোচযিষ্যথ তে মোচযিষ্যন্তে যেষাঞ্চ পাপাতি ন মোচযিষ্যথ তে ন মোচযিষ্যন্তে| ");
INSERT INTO sanasm_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","দ্ৱাদশমধ্যে গণিতো যমজো থোমানামা শিষ্যো যীশোৰাগমনকালৈ তৈঃ সাৰ্দ্ধং নাসীৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","অতো ৱযং প্ৰভূম্ অপশ্যামেতি ৱাক্যেঽন্যশিষ্যৈৰুক্তে সোৱদৎ, তস্য হস্তযো ৰ্লৌহকীলকানাং চিহ্নং ন ৱিলোক্য তচ্চিহ্নম্ অঙ্গুল্যা ন স্পৃষ্ট্ৱা তস্য কুক্ষৌ হস্তং নাৰোপ্য চাহং ন ৱিশ্ৱসিষ্যামি| ");
INSERT INTO sanasm_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","অপৰম্ অষ্টমেঽহ্নি গতে সতি থোমাসহিতঃ শিষ্যগণ একত্ৰ মিলিৎৱা দ্ৱাৰং ৰুদ্ধ্ৱাভ্যন্তৰ আসীৎ, এতৰ্হি যীশুস্তেষাং মধ্যস্থানে তিষ্ঠন্ অকথযৎ, যুষ্মাকং কুশলং ভূযাৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","পশ্চাৎ থামৈ কথিতৱান্ ৎৱম্ অঙ্গুলীম্ অত্ৰাৰ্পযিৎৱা মম কৰৌ পশ্য কৰং প্ৰসাৰ্য্য মম কুক্ষাৱৰ্পয নাৱিশ্ৱস্য| ");
INSERT INTO sanasm_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","তদা থোমা অৱদৎ, হে মম প্ৰভো হে মদীশ্ৱৰ| ");
INSERT INTO sanasm_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","যীশুৰকথযৎ, হে থোমা মাং নিৰীক্ষ্য ৱিশ্ৱসিষি যে ন দৃষ্ট্ৱা ৱিশ্ৱসন্তি তএৱ ধন্যাঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","এতদন্যানি পুস্তকেঽস্মিন্ অলিখিতানি বহূন্যাশ্চৰ্য্যকৰ্ম্মাণি যীশুঃ শিষ্যাণাং পুৰস্তাদ্ অকৰোৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","কিন্তু যীশুৰীশ্ৱৰস্যাভিষিক্তঃ সুত এৱেতি যথা যূযং ৱিশ্ৱসিথ ৱিশ্ৱস্য চ তস্য নাম্না পৰমাযুঃ প্ৰাপ্নুথ তদৰ্থম্ এতানি সৰ্ৱ্ৱাণ্যলিখ্যন্ত| ");
INSERT INTO sanasm_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","ততঃ পৰং তিবিৰিযাজলধেস্তটে যীশুঃ পুনৰপি শিষ্যেভ্যো দৰ্শনং দত্তৱান্ দৰ্শনস্যাখ্যানমিদম্| ");
INSERT INTO sanasm_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","শিমোন্পিতৰঃ যমজথোমা গালীলীযকান্নানগৰনিৱাসী নিথনেল্ সিৱদেঃ পুত্ৰাৱন্যৌ দ্ৱৌ শিষ্যৌ চৈতেষ্ৱেকত্ৰ মিলিতেষু শিমোন্পিতৰোঽকথযৎ মৎস্যান্ ধৰ্তুং যামি| ");
INSERT INTO sanasm_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ততস্তে ৱ্যাহৰন্ তৰ্হি ৱযমপি ৎৱযা সাৰ্দ্ধং যামঃ তদা তে বহিৰ্গতাঃ সন্তঃ ক্ষিপ্ৰং নাৱম্ আৰোহন্ কিন্তু তস্যাং ৰজন্যাম্ একমপি ন প্ৰাপ্নুৱন্| ");
INSERT INTO sanasm_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","প্ৰভাতে সতি যীশুস্তটে স্থিতৱান্ কিন্তু স যীশুৰিতি শিষ্যা জ্ঞাতুং নাশক্নুৱন্| ");
INSERT INTO sanasm_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","তদা যীশুৰপৃচ্ছৎ, হে ৱৎসা সন্নিধৌ কিঞ্চিৎ খাদ্যদ্ৰৱ্যম্ আস্তে? তেঽৱদন্ কিমপি নাস্তি| ");
INSERT INTO sanasm_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","তদা সোঽৱদৎ নৌকাযা দক্ষিণপাৰ্শ্ৱে জালং নিক্ষিপত ততো লপ্স্যধ্ৱে, তস্মাৎ তৈ ৰ্নিক্ষিপ্তে জালে মৎস্যা এতাৱন্তোঽপতন্ যেন তে জালমাকৃষ্য নোত্তোলযিতুং শক্তাঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","তস্মাদ্ যীশোঃ প্ৰিযতমশিষ্যঃ পিতৰাযাকথযৎ এষ প্ৰভু ৰ্ভৱেৎ, এষ প্ৰভুৰিতি ৱাচং শ্ৰুৎৱৈৱ শিমোন্ নগ্নতাহেতো ৰ্মৎস্যধাৰিণ উত্তৰীযৱস্ত্ৰং পৰিধায হ্ৰদং প্ৰত্যুদলম্ফযৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","অপৰে শিষ্যা মৎস্যৈঃ সাৰ্দ্ধং জালম্ আকৰ্ষন্তঃ ক্ষুদ্ৰনৌকাং ৱাহযিৎৱা কূলমানযন্ তে কূলাদ্ অতিদূৰে নাসন্ দ্ৱিশতহস্তেভ্যো দূৰ আসন্ ইত্যনুমীযতে| ");
INSERT INTO sanasm_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","তীৰং প্ৰাপ্তৈস্তৈস্তত্ৰ প্ৰজ্ৱলিতাগ্নিস্তদুপৰি মৎস্যাঃ পূপাশ্চ দৃষ্টাঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","ততো যীশুৰকথযদ্ যান্ মৎস্যান্ অধৰত তেষাং কতিপযান্ আনযত| ");
INSERT INTO sanasm_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","অতঃ শিমোন্পিতৰঃ পৰাৱৃত্য গৎৱা বৃহদ্ভিস্ত্ৰিপঞ্চাশদধিকশতমৎস্যৈঃ পৰিপূৰ্ণং তজ্জালম্ আকৃষ্যোদতোলযৎ কিন্ত্ৱেতাৱদ্ভি ৰ্মৎস্যৈৰপি জালং নাছিদ্যত| ");
INSERT INTO sanasm_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","অনন্তৰং যীশুস্তান্ অৱাদীৎ যূযমাগত্য ভুংগ্ধ্ৱং; তদা সএৱ প্ৰভুৰিতি জ্ঞাতৎৱাৎ ৎৱং কঃ? ইতি প্ৰষ্টুং শিষ্যাণাং কস্যাপি প্ৰগল্ভতা নাভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ততো যীশুৰাগত্য পূপান্ মৎস্যাংশ্চ গৃহীৎৱা তেভ্যঃ পৰ্য্যৱেষযৎ| ");
INSERT INTO sanasm_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ইত্থং শ্মশানাদুত্থানাৎ পৰং যীশুঃ শিষ্যেভ্যস্তৃতীযৱাৰং দৰ্শনং দত্তৱান্| ");
INSERT INTO sanasm_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ভোজনে সমাপ্তে সতি যীশুঃ শিমোন্পিতৰং পৃষ্টৱান্, হে যূনসঃ পুত্ৰ শিমোন্ ৎৱং কিম্ এতেভ্যোধিকং মযি প্ৰীযসে? ততঃ স উদিতৱান্ সত্যং প্ৰভো ৎৱযি প্ৰীযেঽহং তদ্ ভৱান্ জানাতি; তদা যীশুৰকথযৎ তৰ্হি মম মেষশাৱকগণং পালয| ");
INSERT INTO sanasm_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ততঃ স দ্ৱিতীযৱাৰং পৃষ্টৱান্ হে যূনসঃ পুত্ৰ শিমোন্ ৎৱং কিং মযি প্ৰীযসে? ততঃ স উক্তৱান্ সত্যং প্ৰভো ৎৱযি প্ৰীযেঽহং তদ্ ভৱান্ জানাতি; তদা যীশুৰকথযত তৰ্হি মম মেষগণং পালয| ");
INSERT INTO sanasm_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","পশ্চাৎ স তৃতীযৱাৰং পৃষ্টৱান্, হে যূনসঃ পুত্ৰ শিমোন্ ৎৱং কিং মযি প্ৰীযসে? এতদ্ৱাক্যং তৃতীযৱাৰং পৃষ্টৱান্ তস্মাৎ পিতৰো দুঃখিতো ভূৎৱাঽকথযৎ হে প্ৰভো ভৱতঃ কিমপ্যগোচৰং নাস্তি ৎৱয্যহং প্ৰীযে তদ্ ভৱান্ জানাতি; ততো যীশুৰৱদৎ তৰ্হি মম মেষগণং পালয| ");
INSERT INTO sanasm_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","অহং তুভ্যং যথাৰ্থং কথযামি যৌৱনকালে স্ৱযং বদ্ধকটি ৰ্যত্ৰেচ্ছা তত্ৰ যাতৱান্ কিন্ত্ৱিতঃ পৰং ৱৃদ্ধে ৱযসি হস্তং ৱিস্তাৰযিষ্যসি, অন্যজনস্ত্ৱাং বদ্ধ্ৱা যত্ৰ গন্তুং তৱেচ্ছা ন ভৱতি ৎৱাং ধৃৎৱা তত্ৰ নেষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ফলতঃ কীদৃশেন মৰণেন স ঈশ্ৱৰস্য মহিমানং প্ৰকাশযিষ্যতি তদ্ বোধযিতুং স ইতি ৱাক্যং প্ৰোক্তৱান্| ইত্যুক্তে সতি স তমৱোচৎ মম পশ্চাদ্ আগচ্ছ| ");
INSERT INTO sanasm_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","যো জনো ৰাত্ৰিকালে যীশো ৰ্ৱক্ষোঽৱলম্ব্য, হে প্ৰভো কো ভৱন্তং পৰকৰেষু সমৰ্পযিষ্যতীতি ৱাক্যং পৃষ্টৱান্, তং যীশোঃ প্ৰিযতমশিষ্যং পশ্চাদ্ আগচ্ছন্তং ");
INSERT INTO sanasm_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","পিতৰো মুখং পৰাৱৰ্ত্ত্য ৱিলোক্য যীশুং পৃষ্টৱান্, হে প্ৰভো এতস্য মানৱস্য কীদৃশী গতি ৰ্ভৱিষ্যতি? ");
INSERT INTO sanasm_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","স প্ৰত্যৱদৎ, মম পুনৰাগমনপৰ্য্যন্তং যদি তং স্থাপযিতুম্ ইচ্ছামি তত্ৰ তৱ কিং? ৎৱং মম পশ্চাদ্ আগচ্ছ| ");
INSERT INTO sanasm_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","তস্মাৎ স শিষ্যো ন মৰিষ্যতীতি ভ্ৰাতৃগণমধ্যে কিংৱদন্তী জাতা কিন্তু স ন মৰিষ্যতীতি ৱাক্যং যীশু ৰ্নাৱদৎ কেৱলং মম পুনৰাগমনপৰ্য্যন্তং যদি তং স্থাপযিতুম্ ইচ্ছামি তত্ৰ তৱ কিং? ইতি ৱাক্যম্ উক্তৱান্| ");
INSERT INTO sanasm_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","যো জন এতানি সৰ্ৱ্ৱাণি লিখিতৱান্ অত্ৰ সাক্ষ্যঞ্চ দত্তৱান্ সএৱ স শিষ্যঃ, তস্য সাক্ষ্যং প্ৰমাণমিতি ৱযং জানীমঃ| ");
INSERT INTO sanasm_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","যীশুৰেতেভ্যোঽপৰাণ্যপি বহূনি কৰ্ম্মাণি কৃতৱান্ তানি সৰ্ৱ্ৱাণি যদ্যেকৈকং কৃৎৱা লিখ্যন্তে তৰ্হি গ্ৰন্থা এতাৱন্তো ভৱন্তি তেষাং ধাৰণে পৃথিৱ্যাং স্থানং ন ভৱতি| ইতি||");
INSERT INTO sanasm_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","হে থিযফিল, যীশুঃ স্ৱমনোনীতান্ প্ৰেৰিতান্ পৱিত্ৰেণাত্মনা সমাদিশ্য যস্মিন্ দিনে স্ৱৰ্গমাৰোহৎ যাং যাং ক্ৰিযামকৰোৎ যদ্যদ্ উপাদিশচ্চ তানি সৰ্ৱ্ৱাণি পূৰ্ৱ্ৱং মযা লিখিতানি| ");
INSERT INTO sanasm_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","স স্ৱনিধনদুঃখভোগাৎ পৰম্ অনেকপ্ৰত্যযক্ষপ্ৰমাণৌঃ স্ৱং সজীৱং দৰ্শযিৎৱা ");
INSERT INTO sanasm_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","চৎৱাৰিংশদ্দিনানি যাৱৎ তেভ্যঃ প্ৰেৰিতেভ্যো দৰ্শনং দত্ত্ৱেশ্ৱৰীযৰাজ্যস্য ৱৰ্ণনম অকৰোৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","অনন্তৰং তেষাং সভাং কৃৎৱা ইত্যাজ্ঞাপযৎ, যূযং যিৰূশালমোঽন্যত্ৰ গমনমকৃৎৱা যস্তিন্ পিত্ৰাঙ্গীকৃতে মম ৱদনাৎ কথা অশৃণুত তৎপ্ৰাপ্তিম্ অপেক্ষ্য তিষ্ঠত| ");
INSERT INTO sanasm_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","যোহন্ জলে মজ্জিতাৱান্ কিন্ত্ৱল্পদিনমধ্যে যূযং পৱিত্ৰ আত্মনি মজ্জিতা ভৱিষ্যথ| ");
INSERT INTO sanasm_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","পশ্চাৎ তে সৰ্ৱ্ৱে মিলিৎৱা তম্ অপৃচ্ছন্ হে প্ৰভো ভৱান্ কিমিদানীং পুনৰপি ৰাজ্যম্ ইস্ৰাযেলীযলোকানাং কৰেষু সমৰ্পযিষ্যতি? ");
INSERT INTO sanasm_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ততঃ সোৱদৎ যান্ সৰ্ৱ্ৱান্ কালান্ সমযাংশ্চ পিতা স্ৱৱশেঽস্থাপযৎ তান্ জ্ঞাতৃং যুষ্মাকম্ অধিকাৰো ন জাযতে| ");
INSERT INTO sanasm_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","কিন্তু যুষ্মাসু পৱিত্ৰস্যাত্মন আৱিৰ্ভাৱে সতি যূযং শক্তিং প্ৰাপ্য যিৰূশালমি সমস্তযিহূদাশোমিৰোণদেশযোঃ পৃথিৱ্যাঃ সীমাং যাৱদ্ যাৱন্তো দেশাস্তেষু যৰ্ৱ্ৱেষু চ মযি সাক্ষ্যং দাস্যথ| ");
INSERT INTO sanasm_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ইতি ৱাক্যমুক্ত্ৱা স তেষাং সমক্ষং স্ৱৰ্গং নীতোঽভৱৎ, ততো মেঘমাৰুহ্য তেষাং দৃষ্টেৰগোচৰোঽভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","যস্মিন্ সমযে তে ৱিহাযসং প্ৰত্যনন্যদৃষ্ট্যা তস্য তাদৃশম্ ঊৰ্দ্ৱ্ৱগমনম্ অপশ্যন্ তস্মিন্নেৱ সমযে শুক্লৱস্ত্ৰৌ দ্ৱৌ জনৌ তেষাং সন্নিধৌ দণ্ডাযমানৌ কথিতৱন্তৌ, ");
INSERT INTO sanasm_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","হে গালীলীযলোকা যূযং কিমৰ্থং গগণং প্ৰতি নিৰীক্ষ্য দণ্ডাযমানাস্তিষ্ঠথ? যুষ্মাকং সমীপাৎ স্ৱৰ্গং নীতো যো যীশুস্তং যূযং যথা স্ৱৰ্গম্ আৰোহন্তম্ অদৰ্শম্ তথা স পুনশ্চাগমিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","ততঃ পৰং তে জৈতুননাম্নঃ পৰ্ৱ্ৱতাদ্ ৱিশ্ৰামৱাৰস্য পথঃ পৰিমাণম্ অৰ্থাৎ প্ৰাযেণাৰ্দ্ধক্ৰোশং দুৰস্থং যিৰূশালম্নগৰং পৰাৱৃত্যাগচ্ছন্| ");
INSERT INTO sanasm_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","নগৰং প্ৰৱিশ্য পিতৰো যাকূব্ যোহন্ আন্দ্ৰিযঃ ফিলিপঃ থোমা বৰ্থজমযো মথিৰাল্ফীযপুত্ৰো যাকূব্ উদ্যোগাी শিমোন্ যাকূবো ভ্ৰাতা যিহূদা এতে সৰ্ৱ্ৱে যত্ৰ স্থানে প্ৰৱসন্তি তস্মিন্ উপৰিতনপ্ৰকোষ্ঠে প্ৰাৱিশন্| ");
INSERT INTO sanasm_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","পশ্চাদ্ ইমে কিযত্যঃ স্ত্ৰিযশ্চ যীশো ৰ্মাতা মৰিযম্ তস্য ভ্ৰাতৰশ্চৈতে সৰ্ৱ্ৱ একচিত্তীভূত সততং ৱিনযেন ৱিনযেন প্ৰাৰ্থযন্ত| ");
INSERT INTO sanasm_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","তস্মিন্ সমযে তত্ৰ স্থানে সাকল্যেন ৱিংশত্যধিকশতং শিষ্যা আসন্| ততঃ পিতৰস্তেষাং মধ্যে তিষ্ঠন্ উক্তৱান্ ");
INSERT INTO sanasm_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","হে ভ্ৰাতৃগণ যীশুধাৰিণাং লোকানাং পথদৰ্শকো যো যিহূদাস্তস্মিন্ দাযূদা পৱিত্ৰ আত্মা যাং কথাং কথযামাস তস্যাঃ প্ৰত্যক্ষীভৱনস্যাৱশ্যকৎৱম্ আসীৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","স জনোঽস্মাকং মধ্যৱৰ্ত্তী সন্ অস্যাঃ সেৱাযা অংশম্ অলভত| ");
INSERT INTO sanasm_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","তদনন্তৰং কুকৰ্ম্মণা লব্ধং যন্মূল্যং তেন ক্ষেত্ৰমেকং ক্ৰীতম্ অপৰং তস্মিন্ অধোমুখে ভৃমৌ পতিতে সতি তস্যোদৰস্য ৱিদীৰ্ণৎৱাৎ সৰ্ৱ্ৱা নাড্যো নিৰগচ্ছন্| ");
INSERT INTO sanasm_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","এতাং কথাং যিৰূশালম্নিৱাসিনঃ সৰ্ৱ্ৱে লোকা ৱিদান্তি; তেষাং নিজভাষযা তৎক্ষেত্ৰঞ্চ হকল্দামা, অৰ্থাৎ ৰক্তক্ষেত্ৰমিতি ৱিখ্যাতমাস্তে| ");
INSERT INTO sanasm_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","অন্যচ্চ, নিকেতনং তদীযন্তু শুন্যমেৱ ভৱিষ্যতি| তস্য দূষ্যে নিৱাসাৰ্থং কোপি স্থাস্যতি নৈৱ হি| অন্য এৱ জনস্তস্য পদং সংপ্ৰাপ্স্যতি ধ্ৰুৱং| ইত্থং গীতপুস্তকে লিখিতমাস্তে| ");
INSERT INTO sanasm_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","অতো যোহনো মজ্জনম্ আৰভ্যাস্মাকং সমীপাৎ প্ৰভো ৰ্যীশোঃ স্ৱৰ্গাৰোহণদিনং যাৱৎ সোস্মাকং মধ্যে যাৱন্তি দিনানি যাপিতৱান্ ");
INSERT INTO sanasm_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","তাৱন্তি দিনানি যে মানৱা অস্মাভিঃ সাৰ্দ্ধং তিষ্ঠন্তি তেষাম্ একেন জনেনাস্মাভিঃ সাৰ্দ্ধং যীশোৰুত্থানে সাক্ষিণা ভৱিতৱ্যং| ");
INSERT INTO sanasm_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","অতো যস্য ৰূঢি ৰ্যুষ্টো যং বৰ্শব্বেত্যুক্ত্ৱাহূযন্তি স যূষফ্ মতথিশ্চ দ্ৱাৱেতৌ পৃথক্ কৃৎৱা ত ঈশ্ৱৰস্য সন্নিধৌ প্ৰাৰ্য্য কথিতৱন্তঃ, ");
INSERT INTO sanasm_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","হে সৰ্ৱ্ৱান্তৰ্য্যামিন্ পৰমেশ্ৱৰ, যিহূদাঃ সেৱনপ্ৰেৰিতৎৱপদচ্যুতঃ ");
INSERT INTO sanasm_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","সন্ নিজস্থানম্ অগচ্ছৎ, তৎপদং লব্ধুম্ এনযো ৰ্জনযো ৰ্মধ্যে ভৱতা কোঽভিৰুচিতস্তদস্মান্ দৰ্শ্যতাং| ");
INSERT INTO sanasm_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ততো গুটিকাপাটে কৃতে মতথিৰ্নিৰচীযত তস্মাৎ সোন্যেষাম্ একাদশানাং প্ৰৰিতানাং মধ্যে গণিতোভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","অপৰঞ্চ নিস্তাৰোৎসৱাৎ পৰং পঞ্চাশত্তমে দিনে সমুপস্থিতে সতি তে সৰ্ৱ্ৱে একাচিত্তীভূয স্থান একস্মিন্ মিলিতা আসন্| ");
INSERT INTO sanasm_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","এতস্মিন্নেৱ সমযেঽকস্মাদ্ আকাশাৎ প্ৰচণ্ডাত্যুগ্ৰৱাযোঃ শব্দৱদ্ একঃ শব্দ আগত্য যস্মিন্ গৃহে ত উপাৱিশন্ তদ্ গৃহং সমস্তং ৱ্যাপ্নোৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ততঃ পৰং ৱহ্নিশিখাস্ৱৰূপা জিহ্ৱাঃ প্ৰত্যক্ষীভূয ৱিভক্তাঃ সত্যঃ প্ৰতিজনোৰ্দ্ধ্ৱে স্থগিতা অভূৱন্| ");
INSERT INTO sanasm_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","তস্মাৎ সৰ্ৱ্ৱে পৱিত্ৰেণাত্মনা পৰিপূৰ্ণাঃ সন্ত আত্মা যথা ৱাচিতৱান্ তদনুসাৰেণান্যদেশীযানাং ভাষা উক্তৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","তস্মিন্ সমযে পৃথিৱীস্থসৰ্ৱ্ৱদেশেভ্যো যিহূদীযমতাৱলম্বিনো ভক্তলোকা যিৰূশালমি প্ৰাৱসন্; ");
INSERT INTO sanasm_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","তস্যাঃ কথাযাঃ কিংৱদন্ত্যা জাতৎৱাৎ সৰ্ৱ্ৱে লোকা মিলিৎৱা নিজনিজভাষযা শিষ্যাণাং কথাকথনং শ্ৰুৎৱা সমুদ্ৱিগ্না অভৱন্| ");
INSERT INTO sanasm_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","সৰ্ৱ্ৱএৱ ৱিস্মযাপন্না আশ্চৰ্য্যান্ৱিতাশ্চ সন্তঃ পৰস্পৰং উক্তৱন্তঃ পশ্যত যে কথাং কথযন্তি তে সৰ্ৱ্ৱে গালীলীযলোকাঃ কিং ন ভৱন্তি? ");
INSERT INTO sanasm_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","তৰ্হি ৱযং প্ৰত্যেকশঃ স্ৱস্ৱজন্মদেশীযভাষাভিঃ কথা এতেষাং শৃণুমঃ কিমিদং? ");
INSERT INTO sanasm_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","পাৰ্থী-মাদী-অৰাম্নহৰযিম্দেশনিৱাসিমনো যিহূদা-কপ্পদকিযা-পন্ত-আশিযা- ");
INSERT INTO sanasm_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ফ্ৰুগিযা-পম্ফুলিযা-মিসৰনিৱাসিনঃ কুৰীণীনিকটৱৰ্ত্তিলূবীযপ্ৰদেশনিৱাসিনো ৰোমনগৰাদ্ আগতা যিহূদীযলোকা যিহূদীযমতগ্ৰাহিণঃ ক্ৰীতীযা অৰাবীযাদযো লোকাশ্চ যে ৱযম্ ");
INSERT INTO sanasm_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","অস্মাকং নিজনিজভাষাভিৰেতেষাম্ ঈশ্ৱৰীযমহাকৰ্ম্মৱ্যাখ্যানং শৃণুমঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ইত্থং তে সৰ্ৱ্ৱএৱ ৱিস্মযাপন্নাঃ সন্দিগ্ধচিত্তাঃ সন্তঃ পৰস্পৰমূচুঃ, অস্য কো ভাৱঃ? ");
INSERT INTO sanasm_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","অপৰে কেচিৎ পৰিহস্য কথিতৱন্ত এতে নৱীনদ্ৰাক্ষাৰসেন মত্তা অভৱন্| ");
INSERT INTO sanasm_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","তদা পিতৰ একাদশভি ৰ্জনৈঃ সাকং তিষ্ঠন্ তাল্লোকান্ উচ্চৈঃকাৰম্ অৱদৎ, হে যিহূদীযা হে যিৰূশালম্নিৱাসিনঃ সৰ্ৱ্ৱে, অৱধানং কৃৎৱা মদীযৱাক্যং বুধ্যধ্ৱং| ");
INSERT INTO sanasm_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ইদানীম্ একযামাদ্ অধিকা ৱেলা নাস্তি তস্মাদ্ যূযং যদ্ অনুমাথ মানৱা ইমে মদ্যপানেন মত্তাস্তন্ন| ");
INSERT INTO sanasm_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","কিন্তু যোযেল্ভৱিষ্যদ্ৱক্ত্ৰৈতদ্ৱাক্যমুক্তং যথা, ");
INSERT INTO sanasm_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","ঈশ্ৱৰঃ কথযামাস যুগান্তসমযে ৎৱহম্| ৱৰ্ষিষ্যামি স্ৱমাত্মানং সৰ্ৱ্ৱপ্ৰাণ্যুপৰি ধ্ৰুৱম্| ভাৱিৱাক্যং ৱদিষ্যন্তি কন্যাঃ পুত্ৰাশ্চ ৱস্তুতঃ| প্ৰত্যাদেশঞ্চ প্ৰাপ্স্যন্তি যুষ্মাকং যুৱমানৱাঃ| তথা প্ৰাচীনলোকাস্তু স্ৱপ্নান্ দ্ৰক্ষ্যন্তি নিশ্চিতং| ");
INSERT INTO sanasm_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","ৱৰ্ষিষ্যামি তদাত্মানং দাসদাসীজনোপিৰি| তেনৈৱ ভাৱিৱাক্যং তে ৱদিষ্যন্তি হি সৰ্ৱ্ৱশঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ঊৰ্দ্ধ্ৱস্থে গগণে চৈৱ নীচস্থে পৃথিৱীতলে| শোণিতানি বৃহদ্ভানূন্ ঘনধূমাদিকানি চ| চিহ্নানি দৰ্শযিষ্যামি মহাশ্চৰ্য্যক্ৰিযাস্তথা| ");
INSERT INTO sanasm_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","মহাভযানকস্যৈৱ তদ্দিনস্য পৰেশিতুঃ| পুৰাগমাদ্ ৰৱিঃ কৃষ্ণো ৰক্তশ্চন্দ্ৰো ভৱিষ্যতঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","কিন্তু যঃ পৰমেশস্য নাম্নি সম্প্ৰাৰ্থযিষ্যতে| সএৱ মনুজো নূনং পৰিত্ৰাতো ভৱিষ্যতি|| ");
INSERT INTO sanasm_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","অতো হে ইস্ৰাযেল্ৱংশীযলোকাঃ সৰ্ৱ্ৱে কথাযামেতস্যাম্ মনো নিধদ্ধ্ৱং নাসৰতীযো যীশুৰীশ্ৱৰস্য মনোনীতঃ পুমান্ এতদ্ ঈশ্ৱৰস্তৎকৃতৈৰাশ্চৰ্য্যাদ্ভুতকৰ্ম্মভি ৰ্লক্ষণৈশ্চ যুষ্মাকং সাক্ষাদেৱ প্ৰতিপাদিতৱান্ ইতি যূযং জানীথ| ");
INSERT INTO sanasm_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","তস্মিন্ যীশৌ ঈশ্ৱৰস্য পূৰ্ৱ্ৱনিশ্চিতমন্ত্ৰণানিৰূপণানুসাৰেণ মৃত্যৌ সমৰ্পিতে সতি যূযং তং ধৃৎৱা দুষ্টলোকানাং হস্তৈঃ ক্ৰুশে ৱিধিৎৱাহত| ");
INSERT INTO sanasm_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","কিন্ত্ৱীশ্ৱৰস্তং নিধনস্য বন্ধনান্মোচযিৎৱা উদস্থাপযৎ যতঃ স মৃত্যুনা বদ্ধস্তিষ্ঠতীতি ন সম্ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","এতস্তিন্ দাযূদপি কথিতৱান্ যথা, সৰ্ৱ্ৱদা মম সাক্ষাত্তং স্থাপয পৰমেশ্ৱৰং| স্থিতে মদ্দক্ষিণে তস্মিন্ স্খলিষ্যামি ৎৱহং নহি| ");
INSERT INTO sanasm_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","আনন্দিষ্যতি তদ্ধেতো ৰ্মামকীনং মনস্তু ৱৈ| আহ্লাদিষ্যতি জিহ্ৱাপি মদীযা তু তথৈৱ চ| প্ৰত্যাশযা শৰীৰন্তু মদীযং ৱৈশযিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","পৰলোকে যতো হেতোস্ত্ৱং মাং নৈৱ হি ত্যক্ষ্যসি| স্ৱকীযং পুণ্যৱন্তং ৎৱং ক্ষযিতুং নৈৱ দাস্যসি| এৱং জীৱনমাৰ্গং ৎৱং মামেৱ দৰ্শযিষ্যসি| ");
INSERT INTO sanasm_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","স্ৱসম্মুখে য আনন্দো দক্ষিণে স্ৱস্য যৎ সুখং| অনন্তং তেন মাং পূৰ্ণং কৰিষ্যসি ন সংশযঃ|| ");
INSERT INTO sanasm_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","হে ভ্ৰাতৰোঽস্মাকং তস্য পূৰ্ৱ্ৱপুৰুষস্য দাযূদঃ কথাং স্পষ্টং কথযিতুং মাম্ অনুমন্যধ্ৱং, স প্ৰাণান্ ত্যক্ত্ৱা শ্মশানে স্থাপিতোভৱদ্ অদ্যাপি তৎ শ্মশানম্ অস্মাকং সন্নিধৌ ৱিদ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","ফলতো লৌকিকভাৱেন দাযূদো ৱংশে খ্ৰীষ্টং জন্ম গ্ৰাহযিৎৱা তস্যৈৱ সিংহাসনে সমুৱেষ্টুং তমুত্থাপযিষ্যতি পৰমেশ্ৱৰঃ শপথং কুৎৱা দাযূদঃ সমীপ ইমম্ অঙ্গীকাৰং কৃতৱান্, ");
INSERT INTO sanasm_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ইতি জ্ঞাৎৱা দাযূদ্ ভৱিষ্যদ্ৱাদী সন্ ভৱিষ্যৎকালীযজ্ঞানেন খ্ৰীষ্টোত্থানে কথামিমাং কথযামাস যথা তস্যাত্মা পৰলোকে ন ত্যক্ষ্যতে তস্য শৰীৰঞ্চ ন ক্ষেষ্যতি; ");
INSERT INTO sanasm_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","অতঃ পৰমেশ্ৱৰ এনং যীশুং শ্মশানাদ্ উদস্থাপযৎ তত্ৰ ৱযং সৰ্ৱ্ৱে সাক্ষিণ আস্মহে| ");
INSERT INTO sanasm_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","স ঈশ্ৱৰস্য দক্ষিণকৰেণোন্নতিং প্ৰাপ্য পৱিত্ৰ আত্মিন পিতা যমঙ্গীকাৰং কৃতৱান্ তস্য ফলং প্ৰাপ্য যৎ পশ্যথ শৃণুথ চ তদৱৰ্ষৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","যতো দাযূদ্ স্ৱৰ্গং নাৰুৰোহ কিন্তু স্ৱযম্ ইমাং কথাম্ অকথযদ্ যথা, মম প্ৰভুমিদং ৱাক্যমৱদৎ পৰমেশ্ৱৰঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","তৱ শত্ৰূনহং যাৱৎ পাদপীঠং কৰোমি ন| তাৱৎ কালং মদীযে ৎৱং দক্ষৱাৰ্শ্ৱ উপাৱিশ| ");
INSERT INTO sanasm_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","অতো যং যীশুং যূযং ক্ৰুশেঽহত পৰমেশ্ৱৰস্তং প্ৰভুৎৱাভিষিক্তৎৱপদে ন্যযুংক্তেতি ইস্ৰাযেলীযা লোকা নিশ্চিতং জানন্তু| ");
INSERT INTO sanasm_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","এতাদৃশীং কথাং শ্ৰুৎৱা তেষাং হৃদযানাং ৱিদীৰ্ণৎৱাৎ তে পিতৰায তদন্যপ্ৰেৰিতেভ্যশ্চ কথিতৱন্তঃ, হে ভ্ৰাতৃগণ ৱযং কিং কৰিষ্যামঃ? ");
INSERT INTO sanasm_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","ততঃ পিতৰঃ প্ৰত্যৱদদ্ যূযং সৰ্ৱ্ৱে স্ৱং স্ৱং মনঃ পৰিৱৰ্ত্তযধ্ৱং তথা পাপমোচনাৰ্থং যীশুখ্ৰীষ্টস্য নাম্না মজ্জিতাশ্চ ভৱত, তস্মাদ্ দানৰূপং পৰিত্ৰম্ আত্মানং লপ্স্যথ| ");
INSERT INTO sanasm_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","যতো যুষ্মাকং যুষ্মৎসন্তানানাঞ্চ দূৰস্থসৰ্ৱ্ৱলোকানাঞ্চ নিমিত্তম্ অৰ্থাদ্ অস্মাকং প্ৰভুঃ পৰমেশ্ৱৰো যাৱতো লাকান্ আহ্ৱাস্যতি তেষাং সৰ্ৱ্ৱেষাং নিমিত্তম্ অযমঙ্গীকাৰ আস্তে| ");
INSERT INTO sanasm_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","এতদন্যাভি ৰ্বহুকথাভিঃ প্ৰমাণং দৎৱাকথযৎ এতেভ্যো ৱিপথগামিভ্যো ৱৰ্ত্তমানলোকেভ্যঃ স্ৱান্ ৰক্ষত| ");
INSERT INTO sanasm_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","ততঃ পৰং যে সানন্দাস্তাং কথাম্ অগৃহ্লন্ তে মজ্জিতা অভৱন্| তস্মিন্ দিৱসে প্ৰাযেণ ত্ৰীণি সহস্ৰাণি লোকাস্তেষাং সপক্ষাঃ সন্তঃ ");
INSERT INTO sanasm_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","প্ৰেৰিতানাম্ উপদেশে সঙ্গতৌ পূপভঞ্জনে প্ৰাৰ্থনাসু চ মনঃসংযোগং কৃৎৱাতিষ্ঠন্| ");
INSERT INTO sanasm_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","প্ৰেৰিতৈ ৰ্নানাপ্ৰকাৰলক্ষণেষু মহাশ্চৰ্য্যকৰ্মমসু চ দৰ্শিতেষু সৰ্ৱ্ৱলোকানাং ভযমুপস্থিতং| ");
INSERT INTO sanasm_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","ৱিশ্ৱাসকাৰিণঃ সৰ্ৱ্ৱ চ সহ তিষ্ঠনতঃ| স্ৱেষাং সৰ্ৱ্ৱাঃ সম্পত্তীঃ সাধাৰণ্যেন স্থাপযিৎৱাভুঞ্জত| ");
INSERT INTO sanasm_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ফলতো গৃহাণি দ্ৰৱ্যাণি চ সৰ্ৱ্ৱাণি ৱিক্ৰীয সৰ্ৱ্ৱেষাং স্ৱস্ৱপ্ৰযোজনানুসাৰেণ ৱিভজ্য সৰ্ৱ্ৱেভ্যোঽদদন্| ");
INSERT INTO sanasm_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","সৰ্ৱ্ৱ একচিত্তীভূয দিনে দিনে মন্দিৰে সন্তিষ্ঠমানা গৃহে গৃহে চ পূপানভঞ্জন্ত ঈশ্ৱৰস্য ধন্যৱাদং কুৰ্ৱ্ৱন্তো লোকৈঃ সমাদৃতাঃ পৰমানন্দেন সৰলান্তঃকৰণেন ভোজনং পানঞ্চকুৰ্ৱ্ৱন্| ");
INSERT INTO sanasm_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","পৰমেশ্ৱৰো দিনে দিনে পৰিত্ৰাণভাজনৈ ৰ্মণ্ডলীম্ অৱৰ্দ্ধযৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","তৃতীযযামৱেলাযাং সত্যাং প্ৰাৰ্থনাযাঃ সমযে পিতৰযোহনৌ সম্ভূয মন্দিৰং গচ্ছতঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","তস্মিন্নেৱ সমযে মন্দিৰপ্ৰৱেশকানাং সমীপে ভিক্ষাৰণাৰ্থং যং জন্মখঞ্জমানুষং লোকা মন্দিৰস্য সুন্দৰনাম্নি দ্ৱাৰে প্ৰতিদিনম্ অস্থাপযন্ তং ৱহন্তস্তদ্ৱাৰং আনযন্| ");
INSERT INTO sanasm_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","তদা পিতৰযোহনৌ মন্তিৰং প্ৰৱেষ্টুম্ উদ্যতৌ ৱিলোক্য স খঞ্জস্তৌ কিঞ্চিদ্ ভিক্ষিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","তস্মাদ্ যোহনা সহিতঃ পিতৰস্তম্ অনন্যদৃষ্ট্যা নিৰীক্ষ্য প্ৰোক্তৱান্ আৱাং প্ৰতি দৃষ্টিং কুৰু| ");
INSERT INTO sanasm_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ততঃ স কিঞ্চিৎ প্ৰাপ্ত্যাশযা তৌ প্ৰতি দৃষ্টিং কৃতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","তদা পিতৰো গদিতৱান্ মম নিকটে স্ৱৰ্ণৰূপ্যাদি কিমপি নাস্তি কিন্তু যদাস্তে তদ্ দদামি নাসৰতীযস্য যীশুখ্ৰীষ্টস্য নাম্না ৎৱমুত্থায গমনাগমনে কুৰু| ");
INSERT INTO sanasm_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ততঃ পৰং স তস্য দক্ষিণকৰং ধৃৎৱা তম্ উদতোলযৎ; তেন তৎক্ষণাৎ তস্য জনস্য পাদগুল্ফযোঃ সবলৎৱাৎ স উল্লম্ফ্য প্ৰোত্থায গমনাগমনে ঽকৰোৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ততো গমনাগমনে কুৰ্ৱ্ৱন্ উল্লম্ফন্ ঈশ্ৱৰং ধন্যং ৱদন্ তাভ্যাং সাৰ্দ্ধং মন্দিৰং প্ৰাৱিশৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ততঃ সৰ্ৱ্ৱে লোকাস্তং গমনাগমনে কুৰ্ৱ্ৱন্তম্ ঈশ্ৱৰং ধন্যং ৱদন্তঞ্চ ৱিলোক্য ");
INSERT INTO sanasm_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","মন্দিৰস্য সুন্দৰে দ্ৱাৰে য উপৱিশ্য ভিক্ষিতৱান্ সএৱাযম্ ইতি জ্ঞাৎৱা তং প্ৰতি তযা ঘটনযা চমৎকৃতা ৱিস্মযাপন্নাশ্চাভৱন্| ");
INSERT INTO sanasm_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","যঃ খঞ্জঃ স্ৱস্থোভৱৎ তেন পিতৰযোহনোঃ কৰযোৰ্ধ্টতযোঃ সতোঃ সৰ্ৱ্ৱে লোকা সন্নিধিম্ আগচ্ছন্| ");
INSERT INTO sanasm_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","তদ্ দৃষ্ট্ৱা পিতৰস্তেভ্যোঽকথযৎ, হে ইস্ৰাযেলীযলোকা যূযং কুতো ঽনেনাশ্চৰ্য্যং মন্যধ্ৱে? আৱাং নিজশক্ত্যা যদ্ৱা নিজপুণ্যেন খঞ্জমনুষ্যমেনং গমিতৱন্তাৱিতি চিন্তযিৎৱা আৱাং প্ৰতি কুতোঽনন্যদৃষ্টিং কুৰুথ? ");
INSERT INTO sanasm_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","যং যীশুং যূযং পৰকৰেষু সমাৰ্পযত ততো যং পীলাতো মোচযিতুম্ এैচ্ছৎ তথাপি যূযং তস্য সাক্ষান্ নাঙ্গীকৃতৱন্ত ইব্ৰাহীম ইস্হাকো যাকূবশ্চেশ্ৱৰোঽৰ্থাদ্ অস্মাকং পূৰ্ৱ্ৱপুৰুষাণাম্ ঈশ্ৱৰঃ স্ৱপুত্ৰস্য তস্য যীশো ৰ্মহিমানং প্ৰাকাশযৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","কিন্তু যূযং তং পৱিত্ৰং ধাৰ্ম্মিকং পুমাংসং নাঙ্গীকৃত্য হত্যাকাৰিণমেকং স্ৱেভ্যো দাতুম্ অযাচধ্ৱং| ");
INSERT INTO sanasm_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","পশ্চাৎ তং জীৱনস্যাধিপতিম্ অহত কিন্ত্ৱীশ্ৱৰঃ শ্মশানাৎ তম্ উদস্থাপযত তত্ৰ ৱযং সাক্ষিণ আস্মহে| ");
INSERT INTO sanasm_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ইমং যং মানুষং যূযং পশ্যথ পৰিচিনুথ চ স তস্য নাম্নি ৱিশ্ৱাসকৰণাৎ চলনশক্তিং লব্ধৱান্ তস্মিন্ তস্য যো ৱিশ্ৱাসঃ স তং যুষ্মাকং সৰ্ৱ্ৱেষাং সাক্ষাৎ সম্পূৰ্ণৰূপেণ স্ৱস্থম্ অকাৰ্ষীৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","হে ভ্ৰাতৰো যূযং যুষ্মাকম্ অধিপতযশ্চ অজ্ঞাৎৱা কৰ্ম্মাণ্যেতানি কৃতৱন্ত ইদানীং মমৈষ বোধো জাযতে| ");
INSERT INTO sanasm_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","কিন্ত্ৱীশ্ৱৰঃ খ্ৰীষ্টস্য দুঃখভোগে ভৱিষ্যদ্ৱাদিনাং মুখেভ্যো যাং যাং কথাং পূৰ্ৱ্ৱমকথযৎ তাঃ কথা ইত্থং সিদ্ধা অকৰোৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","অতঃ স্ৱেষাং পাপমোচনাৰ্থং খেদং কৃৎৱা মনাংসি পৰিৱৰ্ত্তযধ্ৱং, তস্মাদ্ ঈশ্ৱৰাৎ সান্ত্ৱনাপ্ৰাপ্তেঃ সময উপস্থাস্যতি; ");
INSERT INTO sanasm_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","পুনশ্চ পূৰ্ৱ্ৱকালম্ আৰভ্য প্ৰচাৰিতো যো যীশুখ্ৰীষ্টস্তম্ ঈশ্ৱৰো যুষ্মান্ প্ৰতি প্ৰেষযিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","কিন্তু জগতঃ সৃষ্টিমাৰভ্য ঈশ্ৱৰো নিজপৱিত্ৰভৱিষ্যদ্ৱাদিগণোন যথা কথিতৱান্ তদনুসাৰেণ সৰ্ৱ্ৱেষাং কাৰ্য্যাণাং সিদ্ধিপৰ্য্যন্তং তেন স্ৱৰ্গে ৱাসঃ কৰ্ত্তৱ্যঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","যুষ্মাকং প্ৰভুঃ পৰমেশ্ৱৰো যুষ্মাকং ভ্ৰাতৃগণমধ্যাৎ মৎসদৃশং ভৱিষ্যদ্ৱক্তাৰম্ উৎপাদযিষ্যতি, ততঃ স যৎ কিঞ্চিৎ কথযিষ্যতি তত্ৰ যূযং মনাংসি নিধদ্ধ্ৱং| ");
INSERT INTO sanasm_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","কিন্তু যঃ কশ্চিৎ প্ৰাণী তস্য ভৱিষ্যদ্ৱাদিনঃ কথাং ন গ্ৰহীষ্যতি স নিজলোকানাং মধ্যাদ্ উচ্ছেৎস্যতে,\" ইমাং কথাম্ অস্মাকং পূৰ্ৱ্ৱপুৰুষেভ্যঃ কেৱলো মূসাঃ কথযামাস ইতি নহি, ");
INSERT INTO sanasm_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","শিমূযেল্ভৱিষ্যদ্ৱাদিনম্ আৰভ্য যাৱন্তো ভৱিষ্যদ্ৱাক্যম্ অকথযন্ তে সৰ্ৱ্ৱএৱ সমযস্যৈতস্য কথাম্ অকথযন্| ");
INSERT INTO sanasm_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","যূযমপি তেষাং ভৱিষ্যদ্ৱাদিনাং সন্তানাঃ, \"তৱ ৱংশোদ্ভৱপুংসা সৰ্ৱ্ৱদেশীযা লোকা আশিষং প্ৰাপ্তা ভৱিষ্যন্তি\", ইব্ৰাহীমে কথামেতাং কথযিৎৱা ঈশ্ৱৰোস্মাকং পূৰ্ৱ্ৱপুৰুষৈঃ সাৰ্দ্ধং যং নিযমং স্থিৰীকৃতৱান্ তস্য নিযমস্যাধিকাৰিণোপি যূযং ভৱথ| ");
INSERT INTO sanasm_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","অত ঈশ্ৱৰো নিজপুত্ৰং যীশুম্ উত্থাপ্য যুষ্মাকং সৰ্ৱ্ৱেষাং স্ৱস্ৱপাপাৎ পৰাৱৰ্ত্ত্য যুষ্মভ্যম্ আশিষং দাতুং প্ৰথমতস্তং যুষ্মাকং নিকটং প্ৰেষিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","যস্মিন্ সমযে পিতৰযোহনৌ লোকান্ উপদিশতস্তস্মিন্ সমযে যাজকা মন্দিৰস্য সেনাপতযঃ সিদূকীগণশ্চ ");
INSERT INTO sanasm_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","তযোৰ্ উপদেশকৰণে খ্ৰীষ্টস্যোত্থানম্ উপলক্ষ্য সৰ্ৱ্ৱেষাং মৃতানাম্ উত্থানপ্ৰস্তাৱে চ ৱ্যগ্ৰাঃ সন্তস্তাৱুপাগমন্| ");
INSERT INTO sanasm_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","তৌ ধৃৎৱা দিনাৱসানকাৰণাৎ পৰদিনপৰ্য্যনন্তং ৰুদ্ধ্ৱা স্থাপিতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","তথাপি যে লোকাস্তযোৰুপদেশম্ অশৃণ্ৱন্ তেষাং প্ৰাযেণ পঞ্চসহস্ৰাণি জনা ৱ্যশ্ৱসন্| ");
INSERT INTO sanasm_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","পৰেঽহনি অধিপতযঃ প্ৰাচীনা অধ্যাপকাশ্চ হানননামা মহাযাজকঃ ");
INSERT INTO sanasm_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","কিযফা যোহন্ সিকন্দৰ ইত্যাদযো মহাযাজকস্য জ্ঞাতযঃ সৰ্ৱ্ৱে যিৰূশালম্নগৰে মিলিতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","অনন্তৰং প্ৰেৰিতৌ মধ্যে স্থাপযিৎৱাপৃচ্ছন্ যুৱাং কযা শক্তযা ৱা কেন নাম্না কৰ্ম্মাণ্যেতানি কুৰুথঃ? ");
INSERT INTO sanasm_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","তদা পিতৰঃ পৱিত্ৰেণাত্মনা পৰিপূৰ্ণঃ সন্ প্ৰত্যৱাদীৎ, হে লোকানাম্ অধিপতিগণ হে ইস্ৰাযেলীযপ্ৰাচীনাঃ, ");
INSERT INTO sanasm_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","এতস্য দুৰ্ব্বলমানুষস্য হিতং যৎ কৰ্ম্মাক্ৰিযত, অৰ্থাৎ, স যেন প্ৰকাৰেণ স্ৱস্থোভৱৎ তচ্চেদ্ অদ্যাৱাং পৃচ্ছথ, ");
INSERT INTO sanasm_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","তৰ্হি সৰ্ৱ্ৱ ইস্ৰাযেेলীযলোকা যূযং জানীত নাসৰতীযো যো যীশুখ্ৰীষ্টঃ ক্ৰুশে যুষ্মাভিৰৱিধ্যত যশ্চেশ্ৱৰেণ শ্মশানাদ্ উত্থাপিতঃ, তস্য নাম্না জনোযং স্ৱস্থঃ সন্ যুষ্মাকং সম্মুখে প্ৰোত্তিষ্ঠতি| ");
INSERT INTO sanasm_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","নিচেতৃভি ৰ্যুষ্মাভিৰযং যঃ প্ৰস্তৰোঽৱজ্ঞাতোঽভৱৎ স প্ৰধানকোণস্য প্ৰস্তৰোঽভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","তদ্ভিন্নাদপৰাৎ কস্মাদপি পৰিত্ৰাণং ভৱিতুং ন শক্নোতি, যেন ত্ৰাণং প্ৰাপ্যেত ভূমণ্ডলস্যলোকানাং মধ্যে তাদৃশং কিমপি নাম নাস্তি| ");
INSERT INTO sanasm_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","তদা পিতৰযোহনোৰেতাদৃশীম্ অক্ষেভতাং দৃষ্ট্ৱা তাৱৱিদ্ৱাংসৌ নীচলোকাৱিতি বুদ্ধ্ৱা আশ্চৰ্য্যম্ অমন্যন্ত তৌ চ যীশোঃ সঙ্গিনৌ জাতাৱিতি জ্ঞাতুম্ অশক্নুৱন্| ");
INSERT INTO sanasm_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","কিন্তু তাভ্যাং সাৰ্দ্ধং তং স্ৱস্থমানুষং তিষ্ঠন্তং দৃষ্ট্ৱা তে কামপ্যপৰাম্ আপত্তিং কৰ্ত্তং নাশক্নুন্| ");
INSERT INTO sanasm_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","তদা তে সভাতঃ স্থানান্তৰং গন্তুং তান্ আজ্ঞাপ্য স্ৱযং পৰস্পৰম্ ইতি মন্ত্ৰণামকুৰ্ৱ্ৱন্ ");
INSERT INTO sanasm_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","তৌ মানৱৌ প্ৰতি কিং কৰ্ত্তৱ্যং? তাৱেকং প্ৰসিদ্ধম্ আশ্চৰ্য্যং কৰ্ম্ম কৃতৱন্তৌ তদ্ যিৰূশালম্নিৱাসিনাং সৰ্ৱ্ৱেষাং লোকানাং সমীপে প্ৰাকাশত তচ্চ ৱযমপহ্নোতুং ন শক্নুমঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","কিন্তু লোকানাং মধ্যম্ এতদ্ যথা ন ৱ্যাপ্নোতি তদৰ্থং তৌ ভযং প্ৰদৰ্শ্য তেন নাম্না কমপি মনুষ্যং নোপদিশতম্ ইতি দৃঢং নিষেধামঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","ততস্তে প্ৰেৰিতাৱাহূয এতদাজ্ঞাপযন্ ইতঃ পৰং যীশো ৰ্নাম্না কদাপি কামপি কথাং মা কথযতং কিমপি নোপদিশঞ্চ| ");
INSERT INTO sanasm_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","ততঃ পিতৰযোহনৌ প্ৰত্যৱদতাম্ ঈশ্ৱৰস্যাজ্ঞাগ্ৰহণং ৱা যুষ্মাকম্ আজ্ঞাগ্ৰহণম্ এতযো ৰ্মধ্যে ঈশ্ৱৰস্য গোচৰে কিং ৱিহিতং? যূযং তস্য ৱিৱেচনাং কুৰুত| ");
INSERT INTO sanasm_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","ৱযং যদ্ অপশ্যাম যদশৃণুম চ তন্ন প্ৰচাৰযিষ্যাম এতৎ কদাপি ভৱিতুং ন শক্নোতি| ");
INSERT INTO sanasm_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","যদঘটত তদ্ দৃষ্টা সৰ্ৱ্ৱে লোকা ঈশ্ৱৰস্য গুণান্ অন্ৱৱদন্ তস্মাৎ লোকভযাৎ তৌ দণ্ডযিতুং কমপ্যুপাযং ন প্ৰাপ্য তে পুনৰপি তৰ্জযিৎৱা তাৱত্যজন্| ");
INSERT INTO sanasm_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","যস্য মানুষস্যৈতৎ স্ৱাস্থ্যকৰণম্ আশ্চৰ্য্যং কৰ্ম্মাক্ৰিযত তস্য ৱযশ্চৎৱাৰিংশদ্ৱৎসৰা ৱ্যতীতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","ততঃ পৰং তৌ ৱিসৃষ্টৌ সন্তৌ স্ৱসঙ্গিনাং সন্নিধিং গৎৱা প্ৰধানযাজকৈঃ প্ৰাচীনলোকৈশ্চ প্ৰোক্তাঃ সৰ্ৱ্ৱাঃ কথা জ্ঞাপিতৱন্তৌ| ");
INSERT INTO sanasm_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","তচ্ছ্ৰুৎৱা সৰ্ৱ্ৱ একচিত্তীভূয ঈশ্ৱৰমুদ্দিশ্য প্ৰোচ্চৈৰেতৎ প্ৰাৰ্থযন্ত, হে প্ৰভো গগণপৃথিৱীপযোধীনাং তেষু চ যদ্যদ্ আস্তে তেষাং স্ৰষ্টেশ্ৱৰস্ত্ৱং| ");
INSERT INTO sanasm_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ৎৱং নিজসেৱকেন দাযূদা ৱাক্যমিদম্ উৱচিথ, মনুষ্যা অন্যদেশীযাঃ কুৰ্ৱ্ৱন্তি কলহং কুতঃ| লোকাঃ সৰ্ৱ্ৱে কিমৰ্থং ৱা চিন্তাং কুৰ্ৱ্ৱন্তি নিষ্ফলাং| ");
INSERT INTO sanasm_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","পৰমেশস্য তেনৈৱাভিষিক্তস্য জনস্য চ| ৱিৰুদ্ধমভিতিষ্ঠন্তি পৃথিৱ্যাঃ পতযঃ কুতঃ|| ");
INSERT INTO sanasm_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","ফলতস্তৱ হস্তেন মন্ত্ৰণযা চ পূৰ্ৱ্ৱ যদ্যৎ স্থিৰীকৃতং তদ্ যথা সিদ্ধং ভৱতি তদৰ্থং ৎৱং যম্ অথিষিক্তৱান্ স এৱ পৱিত্ৰো যীশুস্তস্য প্ৰাতিকূল্যেন হেৰোদ্ পন্তীযপীলাতো ");
INSERT INTO sanasm_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ঽন্যদেশীযলোকা ইস্ৰাযেল্লোকাশ্চ সৰ্ৱ্ৱ এতে সভাযাম্ অতিষ্ঠন্| ");
INSERT INTO sanasm_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","হে পৰমেশ্ৱৰ অধুনা তেষাং তৰ্জনং গৰ্জনঞ্চ শৃণু; ");
INSERT INTO sanasm_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","তথা স্ৱাস্থ্যকৰণকৰ্ম্মণা তৱ বাহুবলপ্ৰকাশপূৰ্ৱ্ৱকং তৱ সেৱকান্ নিৰ্ভযেন তৱ ৱাক্যং প্ৰচাৰযিতুং তৱ পৱিত্ৰপুত্ৰস্য যীশো ৰ্নাম্না আশ্চৰ্য্যাণ্যসম্ভৱানি চ কৰ্ম্মাণি কৰ্ত্তুঞ্চাজ্ঞাপয| ");
INSERT INTO sanasm_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ইত্থং প্ৰাৰ্থনযা যত্ৰ স্থানে তে সভাযাম্ আসন্ তৎ স্থানং প্ৰাকম্পত; ততঃ সৰ্ৱ্ৱে পৱিত্ৰেণাত্মনা পৰিপূৰ্ণাঃ সন্ত ঈশ্ৱৰস্য কথাম্ অক্ষোভেণ প্ৰাচাৰযন্| ");
INSERT INTO sanasm_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","অপৰঞ্চ প্ৰত্যযকাৰিলোকসমূহা একমনস একচিত্তীভূয স্থিতাঃ| তেষাং কেপি নিজসম্পত্তিং স্ৱীযাং নাজানন্ কিন্তু তেষাং সৰ্ৱ্ৱাঃ সম্পত্ত্যঃ সাধাৰণ্যেন স্থিতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","অন্যচ্চ প্ৰেৰিতা মহাশক্তিপ্ৰকাশপূৰ্ৱ্ৱকং প্ৰভো ৰ্যীশোৰুত্থানে সাক্ষ্যম্ অদদুঃ, তেষু সৰ্ৱ্ৱেষু মহানুগ্ৰহোঽভৱচ্চ| ");
INSERT INTO sanasm_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","তেষাং মধ্যে কস্যাপি দ্ৰৱ্যন্যূনতা নাভৱদ্ যতস্তেষাং গৃহভূম্যাদ্যা যাঃ সম্পত্তয আসন্ তা ৱিক্ৰীয ");
INSERT INTO sanasm_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","তন্মূল্যমানীয প্ৰেৰিতানাং চৰণেষু তৈঃ স্থাপিতং; ততঃ প্ৰত্যেকশঃ প্ৰযোজনানুসাৰেণ দত্তমভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","ৱিশেষতঃ কুপ্ৰোপদ্ৱীপীযো যোসিনামকো লেৱিৱংশজাত একো জনো ভূম্যধিকাৰী, যং প্ৰেৰিতা বৰ্ণব্বা অৰ্থাৎ সান্ত্ৱনাদাযক ইত্যুক্ত্ৱা সমাহূযন্, ");
INSERT INTO sanasm_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","স জনো নিজভূমিং ৱিক্ৰীয তন্মূল্যমানীয প্ৰেৰিতানাং চৰণেষু স্থাপিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","তদা অনানিযনামক একো জনো যস্য ভাৰ্য্যাযা নাম সফীৰা স স্ৱাধিকাৰং ৱিক্ৰীয ");
INSERT INTO sanasm_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","স্ৱভাৰ্য্যাং জ্ঞাপযিৎৱা তন্মূল্যস্যৈকাংশং সঙ্গোপ্য স্থাপযিৎৱা তদন্যাংশমাত্ৰমানীয প্ৰেৰিতানাং চৰণেষু সমৰ্পিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","তস্মাৎ পিতৰোকথযৎ হে অনানিয ভূমে ৰ্মূল্যং কিঞ্চিৎ সঙ্গোপ্য স্থাপযিতুং পৱিত্ৰস্যাত্মনঃ সন্নিধৌ মৃষাৱাক্যং কথযিতুঞ্চ শৈতান্ কুতস্তৱান্তঃকৰণে প্ৰৱৃত্তিমজনযৎ? ");
INSERT INTO sanasm_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","সা ভূমি ৰ্যদা তৱ হস্তগতা তদা কিং তৱ স্ৱীযা নাসীৎ? তৰ্হি স্ৱান্তঃকৰণে কুত এতাদৃশী কুকল্পনা ৎৱযা কৃতা? ৎৱং কেৱলমনুষ্যস্য নিকটে মৃষাৱাক্যং নাৱাদীঃ কিন্ত্ৱীশ্ৱৰস্য নিকটেঽপি| ");
INSERT INTO sanasm_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","এতাং কথাং শ্ৰুৎৱৈৱ সোঽনানিযো ভূমৌ পতন্ প্ৰাণান্ অত্যজৎ, তদ্ৱৃত্তান্তং যাৱন্তো লোকা অশৃণ্ৱন্ তেষাং সৰ্ৱ্ৱেষাং মহাভযম্ অজাযৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","তদা যুৱলোকাস্তং ৱস্ত্ৰেণাচ্ছাদ্য বহি ৰ্নীৎৱা শ্মশানেঽস্থাপযন্| ");
INSERT INTO sanasm_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","ততঃ প্ৰহৰৈকানন্তৰং কিং ৱৃত্তং তন্নাৱগত্য তস্য ভাৰ্য্যাপি তত্ৰ সমুপস্থিতা| ");
INSERT INTO sanasm_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ততঃ পিতৰস্তাম্ অপৃচ্ছৎ, যুৱাভ্যাম্ এতাৱন্মুদ্ৰাভ্যো ভূমি ৰ্ৱিক্ৰীতা ন ৱা? এতৎৱং ৱদ; তদা সা প্ৰত্যৱাদীৎ সত্যম্ এতাৱদ্ভ্যো মুদ্ৰাভ্য এৱ| ");
INSERT INTO sanasm_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ততঃ পিতৰোকথযৎ যুৱাং কথং পৰমেশ্ৱৰস্যাত্মানং পৰীক্ষিতুম্ একমন্ত্ৰণাৱভৱতাং? পশ্য যে তৱ পতিং শ্মশানে স্থাপিতৱন্তস্তে দ্ৱাৰস্য সমীপে সমুপতিষ্ঠন্তি ৎৱামপি বহিৰ্নেষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","ততঃ সাপি তস্য চৰণসন্নিধৌ পতিৎৱা প্ৰাণান্ অত্যাক্ষীৎ| পশ্চাৎ তে যুৱানোঽভ্যন্তৰম্ আগত্য তামপি মৃতাং দৃষ্ট্ৱা বহি ৰ্নীৎৱা তস্যাঃ পত্যুঃ পাৰ্শ্ৱে শ্মশানে স্থাপিতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","তস্মাৎ মণ্ডল্যাঃ সৰ্ৱ্ৱে লোকা অন্যলোকাশ্চ তাং ৱাৰ্ত্তাং শ্ৰুৎৱা সাধ্ৱসং গতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","ততঃ পৰং প্ৰেৰিতানাং হস্তৈ ৰ্লোকানাং মধ্যে বহ্ৱাশ্চৰ্য্যাণ্যদ্ভুতানি কৰ্ম্মাণ্যক্ৰিযন্ত; তদা শিষ্যাঃ সৰ্ৱ্ৱ একচিত্তীভূয সুলেমানো ঽলিন্দে সম্ভূযাসন্| ");
INSERT INTO sanasm_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","তেষাং সঙ্ঘান্তৰ্গো ভৱিতুং কোপি প্ৰগল্ভতাং নাগমৎ কিন্তু লোকাস্তান্ সমাদ্ৰিযন্ত| ");
INSERT INTO sanasm_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","স্ত্ৰিযঃ পুৰুষাশ্চ বহৱো লোকা ৱিশ্ৱাস্য প্ৰভুং শৰণমাপন্নাঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","পিতৰস্য গমনাগমনাভ্যাং কেনাপি প্ৰকাৰেণ তস্য ছাযা কস্মিংশ্চিজ্জনে লগিষ্যতীত্যাশযা লোকা ৰোগিণঃ শিৱিকযা খট্ৱযা চানীয পথি পথি স্থাপিতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","চতুৰ্দিক্স্থনগৰেভ্যো বহৱো লোকাঃ সম্ভূয ৰোগিণোঽপৱিত্ৰভুতগ্ৰস্তাংশ্চ যিৰূশালমম্ আনযন্ ততঃ সৰ্ৱ্ৱে স্ৱস্থা অক্ৰিযন্ত| ");
INSERT INTO sanasm_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","অনন্তৰং মহাযাজকঃ সিদূকিনাং মতগ্ৰাহিণস্তেষাং সহচৰাশ্চ ");
INSERT INTO sanasm_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","মহাক্ৰোধান্ত্ৱিতাঃ সন্তঃ প্ৰেৰিতান্ ধৃৎৱা নীচলোকানাং কাৰাযাং বদ্ধ্ৱা স্থাপিতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","কিন্তু ৰাত্ৰৌ পৰমেশ্ৱৰস্য দূতঃ কাৰাযা দ্ৱাৰং মোচযিৎৱা তান্ বহিৰানীযাকথযৎ, ");
INSERT INTO sanasm_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","যূযং গৎৱা মন্দিৰে দণ্ডাযমানাঃ সন্তো লোকান্ প্ৰতীমাং জীৱনদাযিকাং সৰ্ৱ্ৱাং কথাং প্ৰচাৰযত| ");
INSERT INTO sanasm_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ইতি শ্ৰুৎৱা তে প্ৰত্যূষে মন্দিৰ উপস্থায উপদিষ্টৱন্তঃ| তদা সহচৰগণেন সহিতো মহাযাজক আগত্য মন্ত্ৰিগণম্ ইস্ৰাযেল্ৱংশস্য সৰ্ৱ্ৱান্ ৰাজসভাসদঃ সভাস্থান্ কৃৎৱা কাৰাযাস্তান্ আপযিতুং পদাতিগণং প্ৰেৰিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","ততস্তে গৎৱা কাৰাযাং তান্ অপ্ৰাপ্য প্ৰত্যাগত্য ইতি ৱাৰ্ত্তাম্ অৱাদিষুঃ, ");
INSERT INTO sanasm_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ৱযং তত্ৰ গৎৱা নিৰ্ৱ্ৱিঘ্নং কাৰাযা দ্ৱাৰং ৰুদ্ধং ৰক্ষকাংশ্চ দ্ৱাৰস্য বহিৰ্দণ্ডাযমানান্ অদৰ্শাম এৱ কিন্তু দ্ৱাৰং মোচযিৎৱা তন্মধ্যে কমপি দ্ৰষ্টুং ন প্ৰাপ্তাঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","এতাং কথাং শ্ৰুৎৱা মহাযাজকো মন্দিৰস্য সেনাপতিঃ প্ৰধানযাজকাশ্চ, ইত পৰং কিমপৰং ভৱিষ্যতীতি চিন্তযিৎৱা সন্দিগ্ধচিত্তা অভৱন্| ");
INSERT INTO sanasm_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","এতস্মিন্নেৱ সমযে কশ্চিৎ জন আগত্য ৱাৰ্ত্তামেতাম্ অৱদৎ পশ্যত যূযং যান্ মানৱান্ কাৰাযাম্ অস্থাপযত তে মন্দিৰে তিষ্ঠন্তো লোকান্ উপদিশন্তি| ");
INSERT INTO sanasm_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","তদা মন্দিৰস্য সেনাপতিঃ পদাতযশ্চ তত্ৰ গৎৱা চেল্লোকাঃ পাষাণান্ নিক্ষিপ্যাস্মান্ মাৰযন্তীতি ভিযা ৱিনত্যাচাৰং তান্ আনযন্| ");
INSERT INTO sanasm_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","তে মহাসভাযা মধ্যে তান্ অস্থাপযন্ ততঃ পৰং মহাযাজকস্তান্ অপৃচ্ছৎ, ");
INSERT INTO sanasm_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","অনেন নাম্না সমুপদেষ্টুং ৱযং কিং দৃঢং ন ন্যষেধাম? তথাপি পশ্যত যূযং স্ৱেষাং তেনোপদেশেনে যিৰূশালমং পৰিপূৰ্ণং কৃৎৱা তস্য জনস্য ৰক্তপাতজনিতাপৰাধম্ অস্মান্ প্ৰত্যানেতুং চেষ্টধ্ৱে| ");
INSERT INTO sanasm_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","ততঃ পিতৰোন্যপ্ৰেৰিতাশ্চ প্ৰত্যৱদন্ মানুষস্যাজ্ঞাগ্ৰহণাদ্ ঈশ্ৱৰস্যাজ্ঞাগ্ৰহণম্ অস্মাকমুচিতম্| ");
INSERT INTO sanasm_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","যং যীশুং যূযং ক্ৰুশে ৱেধিৎৱাহত তম্ অস্মাকং পৈতৃক ঈশ্ৱৰ উত্থাপ্য ");
INSERT INTO sanasm_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ইস্ৰাযেল্ৱংশানাং মনঃপৰিৱৰ্ত্তনং পাপক্ষমাঞ্চ কৰ্ত্তুং ৰাজানং পৰিত্ৰাতাৰঞ্চ কৃৎৱা স্ৱদক্ষিণপাৰ্শ্ৱে তস্যান্নতিম্ অকৰোৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","এতস্মিন্ ৱযমপি সাক্ষিণ আস্মহে, তৎ কেৱলং নহি, ঈশ্ৱৰ আজ্ঞাগ্ৰাহিভ্যো যং পৱিত্ৰম্ আত্মনং দত্তৱান্ সোপি সাক্ষ্যস্তি| ");
INSERT INTO sanasm_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","এতদ্ৱাক্যে শ্ৰুতে তেষাং হৃদযানি ৱিদ্ধান্যভৱন্ ততস্তে তান্ হন্তুং মন্ত্ৰিতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","এতস্মিন্নেৱ সমযে তৎসভাস্থানাং সৰ্ৱ্ৱলোকানাং মধ্যে সুখ্যাতো গমিলীযেল্নামক একো জনো ৱ্যৱস্থাপকঃ ফিৰূশিলোক উত্থায প্ৰেৰিতান্ ক্ষণাৰ্থং স্থানান্তৰং গন্তুম্ আদিশ্য কথিতৱান্, ");
INSERT INTO sanasm_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","হে ইস্ৰাযেল্ৱংশীযাঃ সৰ্ৱ্ৱে যূযম্ এতান্ মানুষান্ প্ৰতি যৎ কৰ্ত্তুম্ উদ্যতাস্তস্মিন্ সাৱধানা ভৱত| ");
INSERT INTO sanasm_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","ইতঃ পূৰ্ৱ্ৱং থূদানামৈকো জন উপস্থায স্ৱং কমপি মহাপুৰুষম্ অৱদৎ, ততঃ প্ৰাযেণ চতুঃশতলোকাস্তস্য মতগ্ৰাহিণোভৱন্ পশ্চাৎ স হতোভৱৎ তস্যাজ্ঞাগ্ৰাহিণো যাৱন্তো লোকাস্তে সৰ্ৱ্ৱে ৱিৰ্কীৰ্ণাঃ সন্তো ঽকৃতকাৰ্য্যা অভৱন্| ");
INSERT INTO sanasm_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","তস্মাজ্জনাৎ পৰং নামলেখনসমযে গালীলীযযিহূদানামৈকো জন উপস্থায বহূল্লোকান্ স্ৱমতং গ্ৰাহীতৱান্ ততঃ সোপি ৱ্যনশ্যৎ তস্যাজ্ঞাগ্ৰাহিণো যাৱন্তো লোকা আসন্ তে সৰ্ৱ্ৱে ৱিকীৰ্ণা অভৱন্| ");
INSERT INTO sanasm_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","অধুনা ৱদামি, যূযম্ এতান্ মনুষ্যান্ প্ৰতি কিমপি ন কৃৎৱা ক্ষান্তা ভৱত, যত এষ সঙ্কল্প এতৎ কৰ্ম্ম চ যদি মনুষ্যাদভৱৎ তৰ্হি ৱিফলং ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","যদীশ্ৱৰাদভৱৎ তৰ্হি যূযং তস্যান্যথা কৰ্ত্তুং ন শক্ষ্যথ, ৱৰম্ ঈশ্ৱৰৰোধকা ভৱিষ্যথ| ");
INSERT INTO sanasm_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","তদা তস্য মন্ত্ৰণাং স্ৱীকৃত্য তে প্ৰেৰিতান্ আহূয প্ৰহৃত্য যীশো ৰ্নাম্না কামপি কথাং কথযিতুং নিষিধ্য ৱ্যসৰ্জন্| ");
INSERT INTO sanasm_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","কিন্তু তস্য নামাৰ্থং ৱযং লজ্জাভোগস্য যোগ্যৎৱেন গণিতা ইত্যত্ৰ তে সানন্দাঃ সন্তঃ সভাস্থানাং সাক্ষাদ্ অগচ্ছন্| ");
INSERT INTO sanasm_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ততঃ পৰং প্ৰতিদিনং মন্দিৰে গৃহে গৃহে চাৱিশ্ৰামম্ উপদিশ্য যীশুখ্ৰীষ্টস্য সুসংৱাদং প্ৰচাৰিতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","তস্মিন্ সমযে শিষ্যাণাং বাহুল্যাৎ প্ৰাত্যহিকদানস্য ৱিশ্ৰাণনৈ ৰ্ভিন্নদেশীযানাং ৱিধৱাস্ত্ৰীগণ উপেক্ষিতে সতি ইব্ৰীযলোকৈঃ সহান্যদেশীযানাং ৱিৱাদ উপাতিষ্ঠৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","তদা দ্ৱাদশপ্ৰেৰিতাঃ সৰ্ৱ্ৱান্ শিষ্যান্ সংগৃহ্যাকথযন্ ঈশ্ৱৰস্য কথাপ্ৰচাৰং পৰিত্যজ্য ভোজনগৱেষণম্ অস্মাকম্ উচিতং নহি| ");
INSERT INTO sanasm_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","অতো হে ভ্ৰাতৃগণ ৱযম্ এতৎকৰ্ম্মণো ভাৰং যেভ্যো দাতুং শক্নুম এতাদৃশান্ সুখ্যাত্যাপন্নান্ পৱিত্ৰেণাত্মনা জ্ঞানেন চ পূৰ্ণান্ সপ্প্ৰজনান্ যূযং স্ৱেষাং মধ্যে মনোনীতান্ কুৰুত, ");
INSERT INTO sanasm_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","কিন্তু ৱযং প্ৰাৰ্থনাযাং কথাপ্ৰচাৰকৰ্ম্মণি চ নিত্যপ্ৰৱৃত্তাঃ স্থাস্যামঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","এতস্যাং কথাযাং সৰ্ৱ্ৱে লোকাঃ সন্তুষ্টাঃ সন্তঃ স্ৱেষাং মধ্যাৎ স্তিফানঃ ফিলিপঃ প্ৰখৰো নিকানোৰ্ তীমন্ পৰ্ম্মিণা যিহূদিমতগ্ৰাহী-আন্তিযখিযানগৰীযো নিকলা এতান্ পৰমভক্তান্ পৱিত্ৰেণাত্মনা পৰিপূৰ্ণান্ সপ্ত জনান্ ");
INSERT INTO sanasm_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","প্ৰেৰিতানাং সমক্ষম্ আনযন্, ততস্তে প্ৰাৰ্থনাং কৃৎৱা তেষাং শিৰঃসু হস্তান্ আৰ্পযন্| ");
INSERT INTO sanasm_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","অপৰঞ্চ ঈশ্ৱৰস্য কথা দেশং ৱ্যাপ্নোৎ ৱিশেষতো যিৰূশালমি নগৰে শিষ্যাণাং সংখ্যা প্ৰভূতৰূপেণাৱৰ্দ্ধত যাজকানাং মধ্যেপি বহৱঃ খ্ৰীষ্টমতগ্ৰাহিণোঽভৱন্| ");
INSERT INTO sanasm_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","স্তিফানোे ৱিশ্ৱাসেন পৰাক্ৰমেণ চ পৰিপূৰ্ণঃ সন্ লোকানাং মধ্যে বহুৱিধম্ অদ্ভুতম্ আশ্চৰ্য্যং কৰ্ম্মাকৰোৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","তেন লিবৰ্ত্তিনীযনাম্না ৱিখ্যাতসঙ্ঘস্য কতিপযজনাঃ কুৰীণীযসিকন্দৰীয-কিলিকীযাশীযাদেশীযাঃ কিযন্তো জনাশ্চোত্থায স্তিফানেন সাৰ্দ্ধং ৱ্যৱদন্ত| ");
INSERT INTO sanasm_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","কিন্তু স্তিফানো জ্ঞানেন পৱিত্ৰেণাত্মনা চ ঈদৃশীং কথাং কথিতৱান্ যস্যাস্তে আপত্তিং কৰ্ত্তুং নাশক্নুৱন্| ");
INSERT INTO sanasm_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","পশ্চাৎ তৈ ৰ্লোভিতাঃ কতিপযজনাঃ কথামেনাম্ অকথযন্, ৱযং তস্য মুখতো মূসা ঈশ্ৱৰস্য চ নিন্দাৱাক্যম্ অশ্ৰৌষ্ম| ");
INSERT INTO sanasm_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","তে লোকানাং লোকপ্ৰাচীনানাম্ অধ্যাপকানাঞ্চ প্ৰৱৃত্তিং জনযিৎৱা স্তিফানস্য সন্নিধিম্ আগত্য তং ধৃৎৱা মহাসভামধ্যম্ আনযন্| ");
INSERT INTO sanasm_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","তদনন্তৰং কতিপযজনেষু মিথ্যাসাক্ষিষু সমানীতেষু তেঽকথযন্ এষ জন এতৎপুণ্যস্থানৱ্যৱস্থযো ৰ্নিন্দাতঃ কদাপি ন নিৱৰ্ত্ততে| ");
INSERT INTO sanasm_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ফলতো নাসৰতীযযীশুঃ স্থানমেতদ্ উচ্ছিন্নং কৰিষ্যতি মূসাসমৰ্পিতম্ অস্মাকং ৱ্যৱহৰণম্ অন্যৰূপং কৰিষ্যতি তস্যৈতাদৃশীং কথাং ৱযম্ অশৃণুম| ");
INSERT INTO sanasm_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","তদা মহাসভাস্থাঃ সৰ্ৱ্ৱে তং প্ৰতি স্থিৰাং দৃষ্টিং কৃৎৱা স্ৱৰ্গদূতমুখসদৃশং তস্য মুখম্ অপশ্যন্| ");
INSERT INTO sanasm_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ততঃ পৰং মহাযাজকঃ পৃষ্টৱান্, এষা কথাং কিং সত্যা? ");
INSERT INTO sanasm_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","ততঃ স প্ৰত্যৱদৎ, হে পিতৰো হে ভ্ৰাতৰঃ সৰ্ৱ্ৱে লাকা মনাংসি নিধদ্ধ্ৱং| অস্মাকং পূৰ্ৱ্ৱপুৰুষ ইব্ৰাহীম্ হাৰণ্নগৰে ৱাসকৰণাৎ পূৰ্ৱ্ৱং যদা অৰাম্-নহৰযিমদেশে আসীৎ তদা তেজোময ঈশ্ৱৰো দৰ্শনং দৎৱা ");
INSERT INTO sanasm_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","তমৱদৎ ৎৱং স্ৱদেশজ্ঞাতিমিত্ৰাণি পৰিত্যজ্য যং দেশমহং দৰ্শযিষ্যামি তং দেশং ৱ্ৰজ| ");
INSERT INTO sanasm_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","অতঃ স কস্দীযদেশং ৱিহায হাৰণ্নগৰে ন্যৱসৎ, তদনন্তৰং তস্য পিতৰি মৃতে যত্ৰ দেশে যূযং নিৱসথ স এনং দেশমাগচ্ছৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","কিন্ত্ৱীশ্ৱৰস্তস্মৈ কমপ্যধিকাৰম্ অৰ্থাদ্ একপদপৰিমিতাং ভূমিমপি নাদদাৎ; তদা তস্য কোপি সন্তানো নাসীৎ তথাপি সন্তানৈঃ সাৰ্দ্ধম্ এতস্য দেশস্যাধিকাৰী ৎৱং ভৱিষ্যসীতি তম্প্ৰত্যঙ্গীকৃতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ঈশ্ৱৰ ইত্থম্ অপৰমপি কথিতৱান্ তৱ সন্তানাঃ পৰদেশে নিৱৎস্যন্তি ততস্তদ্দেশীযলোকাশ্চতুঃশতৱৎসৰান্ যাৱৎ তান্ দাসৎৱে স্থাপযিৎৱা তান্ প্ৰতি কুৱ্যৱহাৰং কৰিষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","অপৰম্ ঈশ্ৱৰ এনাং কথামপি কথিতৱান্, যে লোকাস্তান্ দাসৎৱে স্থাপযিষ্যন্তি তাল্লোকান্ অহং দণ্ডযিষ্যামি, ততঃ পৰং তে বহিৰ্গতাঃ সন্তো মাম্ অত্ৰ স্থানে সেৱিষ্যন্তে| ");
INSERT INTO sanasm_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","পশ্চাৎ স তস্মৈ ৎৱক্ছেদস্য নিযমং দত্তৱান্, অত ইস্হাকনাম্নি ইব্ৰাহীম একপুত্ৰে জাতে, অষ্টমদিনে তস্য ৎৱক্ছেদম্ অকৰোৎ| তস্য ইস্হাকঃ পুত্ৰো যাকূব্, ততস্তস্য যাকূবোঽস্মাকং দ্ৱাদশ পূৰ্ৱ্ৱপুৰুষা অজাযন্ত| ");
INSERT INTO sanasm_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","তে পূৰ্ৱ্ৱপুৰুষা ঈৰ্ষ্যযা পৰিপূৰ্ণা মিসৰদেশং প্ৰেষযিতুং যূষফং ৱ্যক্ৰীণন্| ");
INSERT INTO sanasm_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","কিন্ত্ৱীশ্ৱৰস্তস্য সহাযো ভূৎৱা সৰ্ৱ্ৱস্যা দুৰ্গতে ৰক্ষিৎৱা তস্মৈ বুদ্ধিং দত্ত্ৱা মিসৰদেশস্য ৰাজ্ঞঃ ফিৰৌণঃ প্ৰিযপাত্ৰং কৃতৱান্ ততো ৰাজা মিসৰদেশস্য স্ৱীযসৰ্ৱ্ৱপৰিৱাৰস্য চ শাসনপদং তস্মৈ দত্তৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","তস্মিন্ সমযে মিসৰ-কিনানদেশযো ৰ্দুৰ্ভিক্ষহেতোৰতিক্লিষ্টৎৱাৎ নঃ পূৰ্ৱ্ৱপুৰুষা ভক্ষ্যদ্ৰৱ্যং নালভন্ত| ");
INSERT INTO sanasm_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","কিন্তু মিসৰদেশে শস্যানি সন্তি, যাকূব্ ইমাং ৱাৰ্ত্তাং শ্ৰুৎৱা প্ৰথমম্ অস্মাকং পূৰ্ৱ্ৱপুৰুষান্ মিসৰং প্ৰেষিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ততো দ্ৱিতীযৱাৰগমনে যূষফ্ স্ৱভ্ৰাতৃভিঃ পৰিচিতোঽভৱৎ; যূষফো ভ্ৰাতৰঃ ফিৰৌণ্ ৰাজেন পৰিচিতা অভৱন্| ");
INSERT INTO sanasm_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","অনন্তৰং যূষফ্ ভ্ৰাতৃগণং প্ৰেষ্য নিজপিতৰং যাকূবং নিজান্ পঞ্চাধিকসপ্ততিসংখ্যকান্ জ্ঞাতিজনাংশ্চ সমাহূতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","তস্মাদ্ যাকূব্ মিসৰদেশং গৎৱা স্ৱযম্ অস্মাকং পূৰ্ৱ্ৱপুৰুষাশ্চ তস্মিন্ স্থানেঽম্ৰিযন্ত| ");
INSERT INTO sanasm_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ততস্তে শিখিমং নীতা যৎ শ্মশানম্ ইব্ৰাহীম্ মুদ্ৰাদৎৱা শিখিমঃ পিতু ৰ্হমোৰঃ পুত্ৰেভ্যঃ ক্ৰীতৱান্ তৎশ্মশানে স্থাপযাঞ্চক্ৰিৰে| ");
INSERT INTO sanasm_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","ততঃ পৰম্ ঈশ্ৱৰ ইব্ৰাহীমঃ সন্নিধৌ শপথং কৃৎৱা যাং প্ৰতিজ্ঞাং কৃতৱান্ তস্যাঃ প্ৰতিজ্ঞাযাঃ ফলনসমযে নিকটে সতি ইস্ৰাযেল্লোকা সিমৰদেশে ৱৰ্দ্ধমানা বহুসংখ্যা অভৱন্| ");
INSERT INTO sanasm_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","শেষে যূষফং যো ন পৰিচিনোতি তাদৃশ একো নৰপতিৰুপস্থায ");
INSERT INTO sanasm_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","অস্মাকং জ্ঞাতিভিঃ সাৰ্দ্ধং ধূৰ্ত্ততাং ৱিধায পূৰ্ৱ্ৱপুৰুষান্ প্ৰতি কুৱ্যৱহৰণপূৰ্ৱ্ৱকং তেষাং ৱংশনাশনায তেষাং নৱজাতান্ শিশূন্ বহি ৰ্নিৰক্ষেপযৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","এতস্মিন্ সমযে মূসা জজ্ঞে, স তু পৰমসুন্দৰোঽভৱৎ তথা পিতৃগৃহে মাসত্ৰযপৰ্য্যন্তং পালিতোঽভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","কিন্তু তস্মিন্ বহিৰ্নিক্ষিপ্তে সতি ফিৰৌণৰাজস্য কন্যা তম্ উত্তোল্য নীৎৱা দত্তকপুত্ৰং কৃৎৱা পালিতৱতী| ");
INSERT INTO sanasm_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","তস্মাৎ স মূসা মিসৰদেশীযাযাঃ সৰ্ৱ্ৱৱিদ্যাযাঃ পাৰদৃষ্ৱা সন্ ৱাক্যে ক্ৰিযাযাঞ্চ শক্তিমান্ অভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","স সম্পূৰ্ণচৎৱাৰিংশদ্ৱৎসৰৱযস্কো ভূৎৱা ইস্ৰাযেলীযৱংশনিজভ্ৰাতৃন্ সাক্ষাৎ কৰ্তুং মতিং চক্ৰে| ");
INSERT INTO sanasm_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","তেষাং জনমেকং হিংসিতং দৃষ্ট্ৱা তস্য সপক্ষঃ সন্ হিংসিতজনম্ উপকৃত্য মিসৰীযজনং জঘান| ");
INSERT INTO sanasm_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","তস্য হস্তেনেশ্ৱৰস্তান্ উদ্ধৰিষ্যতি তস্য ভ্ৰাতৃগণ ইতি জ্ঞাস্যতি স ইত্যনুমানং চকাৰ, কিন্তু তে ন বুবুধিৰে| ");
INSERT INTO sanasm_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","তৎপৰে ঽহনি তেষাম্ উভযো ৰ্জনযো ৰ্ৱাক্কলহ উপস্থিতে সতি মূসাঃ সমীপং গৎৱা তযো ৰ্মেলনং কৰ্ত্তুং মতিং কৃৎৱা কথযামাস, হে মহাশযৌ যুৱাং ভ্ৰাতৰৌ পৰস্পৰম্ অন্যাযং কুতঃ কুৰুথঃ? ");
INSERT INTO sanasm_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","ততঃ সমীপৱাসিনং প্ৰতি যো জনোঽন্যাযং চকাৰ স তং দূৰীকৃত্য কথযামাস, অস্মাকমুপৰি শাস্তৃৎৱৱিচাৰযিতৃৎৱপদযোঃ কস্ত্ৱাং নিযুক্তৱান্? ");
INSERT INTO sanasm_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","হ্যো যথা মিসৰীযং হতৱান্ তথা কিং মামপি হনিষ্যসি? ");
INSERT INTO sanasm_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","তদা মূসা এতাদৃশীং কথাং শ্ৰুৎৱা পলাযনং চক্ৰে, ততো মিদিযনদেশং গৎৱা প্ৰৱাসী সন্ তস্থৌ, ততস্তত্ৰ দ্ৱৌ পুত্ৰৌ জজ্ঞাতে| ");
INSERT INTO sanasm_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","অনন্তৰং চৎৱাৰিংশদ্ৱৎসৰেষু গতেষু সীনযপৰ্ৱ্ৱতস্য প্ৰান্তৰে প্ৰজ্ৱলিতস্তম্বস্য ৱহ্নিশিখাযাং পৰমেশ্ৱৰদূতস্তস্মৈ দৰ্শনং দদৌ| ");
INSERT INTO sanasm_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","মূসাস্তস্মিন্ দৰ্শনে ৱিস্মযং মৎৱা ৱিশেষং জ্ঞাতুং নিকটং গচ্ছতি, ");
INSERT INTO sanasm_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","এতস্মিন্ সমযে, অহং তৱ পূৰ্ৱ্ৱপুৰুষাণাম্ ঈশ্ৱৰোঽৰ্থাদ্ ইব্ৰাহীম ঈশ্ৱৰ ইস্হাক ঈশ্ৱৰো যাকূব ঈশ্ৱৰশ্চ, মূসামুদ্দিশ্য পৰমেশ্ৱৰস্যৈতাদৃশী ৱিহাযসীযা ৱাণী বভূৱ, ততঃ স কম্পান্ৱিতঃ সন্ পুন ৰ্নিৰীক্ষিতুং প্ৰগল্ভো ন বভূৱ| ");
INSERT INTO sanasm_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","পৰমেশ্ৱৰস্তং জগাদ, তৱ পাদযোঃ পাদুকে মোচয যত্ৰ তিষ্ঠসি সা পৱিত্ৰভূমিঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","অহং মিসৰদেশস্থানাং নিজলোকানাং দুৰ্দ্দশাং নিতান্তম্ অপশ্যং, তেষাং কাতৰ্য্যোক্তিঞ্চ শ্ৰুতৱান্ তস্মাৎ তান্ উদ্ধৰ্ত্তুম্ অৱৰুহ্যাগমম্; ইদানীম্ আগচ্ছ মিসৰদেশং ৎৱাং প্ৰেষযামি| ");
INSERT INTO sanasm_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","কস্ত্ৱাং শাস্তৃৎৱৱিচাৰযিতৃৎৱপদযো ৰ্নিযুক্তৱান্, ইতি ৱাক্যমুক্ত্ৱা তৈ ৰ্যো মূসা অৱজ্ঞাতস্তমেৱ ঈশ্ৱৰঃ স্তম্বমধ্যে দৰ্শনদাত্ৰা তেন দূতেন শাস্তাৰং মুক্তিদাতাৰঞ্চ কৃৎৱা প্ৰেষযামাস| ");
INSERT INTO sanasm_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","স চ মিসৰদেশে সূফ্নাম্নি সমুদ্ৰে চ পশ্চাৎ চৎৱাৰিংশদ্ৱৎসৰান্ যাৱৎ মহাপ্ৰান্তৰে নানাপ্ৰকাৰাণ্যদ্ভুতানি কৰ্ম্মাণি লক্ষণানি চ দৰ্শযিৎৱা তান্ বহিঃ কৃৎৱা সমানিনায| ");
INSERT INTO sanasm_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","প্ৰভুঃ পৰমেশ্ৱৰো যুষ্মাকং ভ্ৰাতৃগণস্য মধ্যে মাদৃশম্ একং ভৱিষ্যদ্ৱক্তাৰম্ উৎপাদযিষ্যতি তস্য কথাযাং যূযং মনো নিধাস্যথ, যো জন ইস্ৰাযেলঃ সন্তানেভ্য এনাং কথাং কথযামাস স এষ মূসাঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","মহাপ্ৰান্তৰস্থমণ্ডলীমধ্যেঽপি স এৱ সীনযপৰ্ৱ্ৱতোপৰি তেন সাৰ্দ্ধং সংলাপিনো দূতস্য চাস্মৎপিতৃগণস্য মধ্যস্থঃ সন্ অস্মভ্যং দাতৱ্যনি জীৱনদাযকানি ৱাক্যানি লেভে| ");
INSERT INTO sanasm_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","অস্মাকং পূৰ্ৱ্ৱপুৰুষাস্তম্ অমান্যং কৎৱা স্ৱেভ্যো দূৰীকৃত্য মিসৰদেশং পৰাৱৃত্য গন্তুং মনোভিৰভিলষ্য হাৰোণং জগদুঃ, ");
INSERT INTO sanasm_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","অস্মাকম্ অগ্ৰেঽগ্ৰে গন্তুुম্ অস্মদৰ্থং দেৱগণং নিৰ্ম্মাহি যতো যো মূসা অস্মান্ মিসৰদেশাদ্ বহিঃ কৃৎৱানীতৱান্ তস্য কিং জাতং তদস্মাভি ৰ্ন জ্ঞাযতে| ");
INSERT INTO sanasm_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","তস্মিন্ সমযে তে গোৱৎসাকৃতিং প্ৰতিমাং নিৰ্ম্মায তামুদ্দিশ্য নৈৱেদ্যমুত্মৃজ্য স্ৱহস্তকৃতৱস্তুনা আনন্দিতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","তস্মাদ্ ঈশ্ৱৰস্তেষাং প্ৰতি ৱিমুখঃ সন্ আকাশস্থং জ্যোতিৰ্গণং পূজযিতুং তেভ্যোঽনুমতিং দদৌ, যাদৃশং ভৱিষ্যদ্ৱাদিনাং গ্ৰন্থেষু লিখিতমাস্তে, যথা, ইস্ৰাযেলীযৱংশা ৰে চৎৱাৰিংশৎসমান্ পুৰা| মহতি প্ৰান্তৰে সংস্থা যূযন্তু যানি চ| বলিহোমাদিকৰ্ম্মাণি কৃতৱন্তস্তু তানি কিং| মাং সমুদ্দিশ্য যুষ্মাভিঃ প্ৰকৃতানীতি নৈৱ চ| ");
INSERT INTO sanasm_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","কিন্তু ৱো মোলকাখ্যস্য দেৱস্য দূষ্যমেৱ চ| যুষ্মাকং ৰিম্ফনাখ্যাযা দেৱতাযাশ্চ তাৰকা| এতযোৰুভযো ৰ্মূৰ্তী যুষ্মাভিঃ পৰিপূজিতে| অতো যুষ্মাংস্তু বাবেলঃ পাৰং নেষ্যামি নিশ্চিতং| ");
INSERT INTO sanasm_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","অপৰঞ্চ যন্নিদৰ্শনম্ অপশ্যস্তদনুসাৰেণ দূষ্যং নিৰ্ম্মাহি যস্মিন্ ঈশ্ৱৰো মূসাম্ এতদ্ৱাক্যং বভাষে তৎ তস্য নিৰূপিতং সাক্ষ্যস্ৱৰূপং দূষ্যম্ অস্মাকং পূৰ্ৱ্ৱপুৰুষৈঃ সহ প্ৰান্তৰে তস্থৌ| ");
INSERT INTO sanasm_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","পশ্চাৎ যিহোশূযেন সহিতৈস্তেষাং ৱংশজাতৈৰস্মৎপূৰ্ৱ্ৱপুৰুষৈঃ স্ৱেষাং সম্মুখাদ্ ঈশ্ৱৰেণ দূৰীকৃতানাম্ অন্যদেশীযানাং দেশাধিকৃতিকালে সমানীতং তদ্ দূষ্যং দাযূদোধিকাৰং যাৱৎ তত্ৰ স্থান আসীৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","স দাযূদ্ পৰমেশ্ৱৰস্যানুগ্ৰহং প্ৰাপ্য যাকূব্ ঈশ্ৱৰাৰ্থম্ একং দূষ্যং নিৰ্ম্মাতুং ৱৱাঞ্ছ; ");
INSERT INTO sanasm_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","কিন্তু সুলেমান্ তদৰ্থং মন্দিৰম্ একং নিৰ্ম্মিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","তথাপি যঃ সৰ্ৱ্ৱোপৰিস্থঃ স কস্মিংশ্চিদ্ হস্তকৃতে মন্দিৰে নিৱসতীতি নহি, ভৱিষ্যদ্ৱাদী কথামেতাং কথযতি, যথা, ");
INSERT INTO sanasm_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","পৰেশো ৱদতি স্ৱৰ্গো ৰাজসিংহাসনং মম| মদীযং পাদপীঠঞ্চ পৃথিৱী ভৱতি ধ্ৰুৱং| তৰ্হি যূযং কৃতে মে কিং প্ৰনিৰ্ম্মাস্যথ মন্দিৰং| ৱিশ্ৰামায মদীযং ৱা স্থানং কিং ৱিদ্যতে ৎৱিহ| ");
INSERT INTO sanasm_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","সৰ্ৱ্ৱাণ্যেতানি ৱস্তূনি কিং মে হস্তকৃতানি ন|| ");
INSERT INTO sanasm_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","হে অনাজ্ঞাগ্ৰাহকা অন্তঃকৰণে শ্ৰৱণে চাপৱিত্ৰলোকাঃ যূযম্ অনৱৰতং পৱিত্ৰস্যাত্মনঃ প্ৰাতিকূল্যম্ আচৰথ, যুষ্মাকং পূৰ্ৱ্ৱপুৰুষা যাদৃশা যূযমপি তাদৃশাঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","যুষ্মাকং পূৰ্ৱ্ৱপুৰুষাঃ কং ভৱিষ্যদ্ৱাদিনং নাতাডযন্? যে তস্য ধাৰ্ম্মিকস্য জনস্যাগমনকথাং কথিতৱন্তস্তান্ অঘ্নন্ যূযম্ অধূনা ৱিশ্ৱাসঘাতিনো ভূৎৱা তং ধাৰ্ম্মিকং জনম্ অহত| ");
INSERT INTO sanasm_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","যূযং স্ৱৰ্গীযদূতগণেন ৱ্যৱস্থাং প্ৰাপ্যাপি তাং নাচৰথ| ");
INSERT INTO sanasm_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ইমাং কথাং শ্ৰুৎৱা তে মনঃসু বিদ্ধাঃ সন্তস্তং প্ৰতি দন্তঘৰ্ষণম্ অকুৰ্ৱ্ৱন্| ");
INSERT INTO sanasm_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","কিন্তু স্তিফানঃ পৱিত্ৰেণাত্মনা পূৰ্ণো ভূৎৱা গগণং প্ৰতি স্থিৰদৃষ্টিং কৃৎৱা ঈশ্ৱৰস্য দক্ষিণে দণ্ডাযমানং যীশুঞ্চ ৱিলোক্য কথিতৱান্; ");
INSERT INTO sanasm_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","পশ্য,মেঘদ্ৱাৰং মুক্তম্ ঈশ্ৱৰস্য দক্ষিণে স্থিতং মানৱসুতঞ্চ পশ্যামি| ");
INSERT INTO sanasm_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","তদা তে প্ৰোচ্চৈঃ শব্দং কৃৎৱা কৰ্ণেষ্ৱঙ্গুলী ৰ্নিধায একচিত্তীভূয তম্ আক্ৰমন্| ");
INSERT INTO sanasm_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","পশ্চাৎ তং নগৰাদ্ বহিঃ কৃৎৱা প্ৰস্তৰৈৰাঘ্নন্ সাক্ষিণো লাকাঃ শৌলনাম্নো যূনশ্চৰণসন্নিধৌ নিজৱস্ত্ৰাণি স্থাপিতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","অনন্তৰং হে প্ৰভো যীশে মদীযমাত্মানং গৃহাণ স্তিফানস্যেতি প্ৰাৰ্থনৱাক্যৱদনসমযে তে তং প্ৰস্তৰৈৰাঘ্নন্| ");
INSERT INTO sanasm_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","তস্মাৎ স জানুনী পাতযিৎৱা প্ৰোচ্চৈঃ শব্দং কৃৎৱা, হে প্ৰভে পাপমেতদ্ এতেষু মা স্থাপয, ইত্যুক্ত্ৱা মহানিদ্ৰাং প্ৰাপ্নোৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","তস্য হত্যাকৰণং শৌলোপি সমমন্যত| তস্মিন্ সমযে যিৰূশালম্নগৰস্থাং মণ্ডলীং প্ৰতি মহাতাডনাযাং জাতাযাং প্ৰেৰিতলোকান্ হিৎৱা সৰ্ৱ্ৱেঽপৰে যিহূদাশোমিৰোণদেশযো ৰ্নানাস্থানে ৱিকীৰ্ণাঃ সন্তো গতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","অন্যচ্চ ভক্তলোকাস্তং স্তিফানং শ্মশানে স্থাপযিৎৱা বহু ৱ্যলপন্| ");
INSERT INTO sanasm_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","কিন্তু শৌলো গৃহে গৃহে ভ্ৰমিৎৱা স্ত্ৰিযঃ পুৰুষাংশ্চ ধৃৎৱা কাৰাযাং বদ্ধ্ৱা মণ্ডল্যা মহোৎপাতং কৃতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","অন্যচ্চ যে ৱিকীৰ্ণা অভৱন্ তে সৰ্ৱ্ৱত্ৰ ভ্ৰমিৎৱা সুসংৱাদং প্ৰাচাৰযন্| ");
INSERT INTO sanasm_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","তদা ফিলিপঃ শোমিৰোণ্নগৰং গৎৱা খ্ৰীষ্টাখ্যানং প্ৰাচাৰযৎ; ");
INSERT INTO sanasm_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","ততোঽশুচি-ভৃতগ্ৰস্তলোকেভ্যো ভূতাশ্চীৎকৃত্যাগচ্ছন্ তথা বহৱঃ পক্ষাঘাতিনঃ খঞ্জা লোকাশ্চ স্ৱস্থা অভৱন্| ");
INSERT INTO sanasm_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","তস্মাৎ লাকা ঈদৃশং তস্যাশ্চৰ্য্যং কৰ্ম্ম ৱিলোক্য নিশম্য চ সৰ্ৱ্ৱ একচিত্তীভূয তেনোক্তাখ্যানে মনাংসি ন্যদধুঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","তস্মিন্নগৰে মহানন্দশ্চাভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ততঃ পূৰ্ৱ্ৱং তস্মিন্নগৰে শিমোন্নামা কশ্চিজ্জনো বহ্ৱী ৰ্মাযাক্ৰিযাঃ কৃৎৱা স্ৱং কঞ্চন মহাপুৰুষং প্ৰোচ্য শোমিৰোণীযানাং মোহং জনযামাস| ");
INSERT INTO sanasm_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","তস্মাৎ স মানুষ ঈশ্ৱৰস্য মহাশক্তিস্ৱৰূপ ইত্যুক্ত্ৱা বালৱৃদ্ধৱনিতাঃ সৰ্ৱ্ৱে লাকাস্তস্মিন্ মনাংসি ন্যদধুঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","স বহুকালান্ মাযাৱিক্ৰিযযা সৰ্ৱ্ৱান্ অতীৱ মোহযাঞ্চকাৰ, তস্মাৎ তে তং মেনিৰে| ");
INSERT INTO sanasm_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","কিন্ত্ৱীশ্ৱৰস্য ৰাজ্যস্য যীশুখ্ৰীষ্টস্য নাম্নশ্চাখ্যানপ্ৰচাৰিণঃ ফিলিপস্য কথাযাং ৱিশ্ৱস্য তেষাং স্ত্ৰীপুৰুষোভযলোকা মজ্জিতা অভৱন্| ");
INSERT INTO sanasm_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","শেষে স শিমোনপি স্ৱযং প্ৰত্যৈৎ ততো মজ্জিতঃ সন্ ফিলিপেন কৃতাম্ আশ্চৰ্য্যক্ৰিযাং লক্ষণঞ্চ ৱিলোক্যাসম্ভৱং মন্যমানস্তেন সহ স্থিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","ইত্থং শোমিৰোণ্দেশীযলোকা ঈশ্ৱৰস্য কথাম্ অগৃহ্লন্ ইতি ৱাৰ্ত্তাং যিৰূশালম্নগৰস্থপ্ৰেৰিতাঃ প্ৰাপ্য পিতৰং যোহনঞ্চ তেষাং নিকটে প্ৰেষিতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ততস্তৌ তৎ স্থানম্ উপস্থায লোকা যথা পৱিত্ৰম্ আত্মানং প্ৰাপ্নুৱন্তি তদৰ্থং প্ৰাৰ্থযেতাং| ");
INSERT INTO sanasm_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","যতস্তে পুৰা কেৱলপ্ৰভুযীশো ৰ্নাম্না মজ্জিতমাত্ৰা অভৱন্, ন তু তেষাং মধ্যে কমপি প্ৰতি পৱিত্ৰস্যাত্মন আৱিৰ্ভাৱো জাতঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","কিন্তু প্ৰেৰিতাভ্যাং তেষাং গাত্ৰেষু কৰেষ্ৱৰ্পিতেষু সৎসু তে পৱিত্ৰম্ আত্মানম্ প্ৰাপ্নুৱন্| ");
INSERT INTO sanasm_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","ইত্থং লোকানাং গাত্ৰেষু প্ৰেৰিতযোঃ কৰাৰ্পণেন তান্ পৱিত্ৰম্ আত্মানং প্ৰাপ্তান্ দৃষ্ট্ৱা স শিমোন্ তযোঃ সমীপে মুদ্ৰা আনীয কথিতৱান্; ");
INSERT INTO sanasm_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","অহং যস্য গাত্ৰে হস্তম্ অৰ্পযিষ্যামি তস্যাপি যথেত্থং পৱিত্ৰাত্মপ্ৰাপ্তি ৰ্ভৱতি তাদৃশীং শক্তিং মহ্যং দত্তং| ");
INSERT INTO sanasm_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","কিন্তু পিতৰস্তং প্ৰত্যৱদৎ তৱ মুদ্ৰাস্ত্ৱযা ৱিনশ্যন্তু যত ঈশ্ৱৰস্য দানং মুদ্ৰাভিঃ ক্ৰীযতে ৎৱমিত্থং বুদ্ধৱান্; ");
INSERT INTO sanasm_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ঈশ্ৱৰায তাৱন্তঃকৰণং সৰলং নহি, তস্মাদ্ অত্ৰ তৱাংশোঽধিকাৰশ্চ কোপি নাস্তি| ");
INSERT INTO sanasm_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","অত এতৎপাপহেতোঃ খেদান্ৱিতঃ সন্ কেনাপি প্ৰকাৰেণ তৱ মনস এতস্যাঃ কুকল্পনাযাঃ ক্ষমা ভৱতি, এতদৰ্থম্ ঈশ্ৱৰে প্ৰাৰ্থনাং কুৰু; ");
INSERT INTO sanasm_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","যতস্ত্ৱং তিক্তপিত্তে পাপস্য বন্ধনে চ যদসি তন্মযা বুদ্ধম্| ");
INSERT INTO sanasm_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","তদা শিমোন্ অকথযৎ তৰ্হি যুৱাভ্যামুদিতা কথা মযি যথা ন ফলতি তদৰ্থং যুৱাং মন্নিমিত্তং প্ৰভৌ প্ৰাৰ্থনাং কুৰুতং| ");
INSERT INTO sanasm_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","অনেন প্ৰকাৰেণ তৌ সাক্ষ্যং দত্ত্ৱা প্ৰভোঃ কথাং প্ৰচাৰযন্তৌ শোমিৰোণীযানাম্ অনেকগ্ৰামেষু সুসংৱাদঞ্চ প্ৰচাৰযন্তৌ যিৰূশালম্নগৰং পৰাৱৃত্য গতৌ| ");
INSERT INTO sanasm_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ততঃ পৰম্ ঈশ্ৱৰস্য দূতঃ ফিলিপম্ ইত্যাদিশৎ, ৎৱমুত্থায দক্ষিণস্যাং দিশি যো মাৰ্গো প্ৰান্তৰস্য মধ্যেন যিৰূশালমো ঽসানগৰং যাতি তং মাৰ্গং গচ্ছ| ");
INSERT INTO sanasm_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ততঃ স উত্থায গতৱান্; তদা কন্দাকীনাম্নঃ কূশ্লোকানাং ৰাজ্ঞ্যাঃ সৰ্ৱ্ৱসম্পত্তেৰধীশঃ কূশদেশীয একঃ ষণ্ডো ভজনাৰ্থং যিৰূশালম্নগৰম্ আগত্য ");
INSERT INTO sanasm_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","পুনৰপি ৰথমাৰুহ্য যিশযিযনাম্নো ভৱিষ্যদ্ৱাদিনো গ্ৰন্থং পঠন্ প্ৰত্যাগচ্ছতি| ");
INSERT INTO sanasm_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","এতস্মিন্ সমযে আত্মা ফিলিপম্ অৱদৎ, ৎৱম্ ৰথস্য সমীপং গৎৱা তেন সাৰ্দ্ধং মিল| ");
INSERT INTO sanasm_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","তস্মাৎ স ধাৱন্ তস্য সন্নিধাৱুপস্থায তেন পঠ্যমানং যিশযিযথৱিষ্যদ্ৱাদিনো ৱাক্যং শ্ৰুৎৱা পৃষ্টৱান্ যৎ পঠসি তৎ কিং বুধ্যসে? ");
INSERT INTO sanasm_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","ততঃ স কথিতৱান্ কেনচিন্ন বোধিতোহং কথং বুধ্যেয? ততঃ স ফিলিপং ৰথমাৰোঢুং স্ৱেন সাৰ্দ্ধম্ উপৱেষ্টুঞ্চ ন্যৱেদযৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","স শাস্ত্ৰস্যেতদ্ৱাক্যং পঠিতৱান্ যথা, সমানীযত ঘাতায স যথা মেষশাৱকঃ| লোমচ্ছেদকসাক্ষাচ্চ মেষশ্চ নীৰৱো যথা| আবধ্য ৱদনং স্ৱীযং তথা স সমতিষ্ঠত| ");
INSERT INTO sanasm_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","অন্যাযেন ৱিচাৰেণ স উচ্ছিন্নো ঽভৱৎ তদা| তৎকালীনমনুষ্যান্ কো জনো ৱৰ্ণযিতুং ক্ষমঃ| যতো জীৱন্নৃণাং দেশাৎ স উচ্ছিন্নো ঽভৱৎ ধ্ৰুৱং| ");
INSERT INTO sanasm_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","অনন্তৰং স ফিলিপম্ অৱদৎ নিৱেদযামি, ভৱিষ্যদ্ৱাদী যামিমাং কথাং কথযামাস স কিং স্ৱস্মিন্ ৱা কস্মিংশ্চিদ্ অন্যস্মিন্? ");
INSERT INTO sanasm_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ততঃ ফিলিপস্তৎপ্ৰকৰণম্ আৰভ্য যীশোৰুপাখ্যানং তস্যাগ্ৰে প্ৰাস্তৌৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ইত্থং মাৰ্গেণ গচ্ছন্তৌ জলাশযস্য সমীপ উপস্থিতৌ; তদা ক্লীবোঽৱাদীৎ পশ্যাত্ৰ স্থানে জলমাস্তে মম মজ্জনে কা বাধা? ");
INSERT INTO sanasm_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","ততঃ ফিলিপ উত্তৰং ৱ্যাহৰৎ স্ৱান্তঃকৰণেন সাকং যদি প্ৰত্যেষি তৰ্হি বাধা নাস্তি| ততঃ স কথিতৱান্ যীশুখ্ৰীষ্ট ঈশ্ৱৰস্য পুত্ৰ ইত্যহং প্ৰত্যেমি| ");
INSERT INTO sanasm_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","তদা ৰথং স্থগিতং কৰ্ত্তুম্ আদিষ্টে ফিলিপক্লীবৌ দ্ৱৌ জলম্ অৱাৰুহতাং; তদা ফিলিপস্তম্ মজ্জযামাস| ");
INSERT INTO sanasm_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","তৎপশ্চাৎ জলমধ্যাদ্ উত্থিতযোঃ সতোঃ পৰমেশ্ৱৰস্যাত্মা ফিলিপং হৃৎৱা নীতৱান্, তস্মাৎ ক্লীবঃ পুনস্তং ন দৃষ্টৱান্ তথাপি হৃষ্টচিত্তঃ সন্ স্ৱমাৰ্গেণ গতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ফিলিপশ্চাস্দোদ্নগৰম্ উপস্থায তস্মাৎ কৈসৰিযানগৰ উপস্থিতিকালপৰ্য্যনতং সৰ্ৱ্ৱস্মিন্নগৰে সুসংৱাদং প্ৰচাৰযন্ গতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","তৎকালপৰ্য্যনতং শৌলঃ প্ৰভোঃ শিষ্যাণাং প্ৰাতিকূল্যেন তাডনাবধযোঃ কথাং নিঃসাৰযন্ মহাযাজকস্য সন্নিধিং গৎৱা ");
INSERT INTO sanasm_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","স্ত্ৰিযং পুৰুষঞ্চ তন্মতগ্ৰাহিণং যং কঞ্চিৎ পশ্যতি তান্ ধৃৎৱা বদ্ধ্ৱা যিৰূশালমম্ আনযতীত্যাশযেন দম্মেষক্নগৰীযং ধৰ্ম্মসমাজান্ প্ৰতি পত্ৰং যাচিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","গচ্ছন্ তু দম্মেষক্নগৰনিকট উপস্থিতৱান্; ততোঽকস্মাদ্ আকাশাৎ তস্য চতুৰ্দিক্ষু তেজসঃ প্ৰকাশনাৎ স ভূমাৱপতৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","পশ্চাৎ হে শৌল হে শৌল কুতো মাং তাডযসি? স্ৱং প্ৰতি প্ৰোক্তম্ এতং শব্দং শ্ৰুৎৱা ");
INSERT INTO sanasm_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","স পৃষ্টৱান্, হে প্ৰভো ভৱান্ কঃ? তদা প্ৰভুৰকথযৎ যং যীশুং ৎৱং তাডযসি স এৱাহং; কণ্টকস্য মুখে পদাঘাতকৰণং তৱ কষ্টম্| ");
INSERT INTO sanasm_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","তদা কম্পমানো ৱিস্মযাপন্নশ্চ সোৱদৎ হে প্ৰভো মযা কিং কৰ্ত্তৱ্যং? ভৱত ইচ্ছা কা? ততঃ প্ৰভুৰাজ্ঞাপযদ্ উত্থায নগৰং গচ্ছ তত্ৰ ৎৱযা যৎ কৰ্ত্তৱ্যং তদ্ ৱদিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","তস্য সঙ্গিনো লোকা অপি তং শব্দং শ্ৰুতৱন্তঃ কিন্তু কমপি ন দৃষ্ট্ৱা স্তব্ধাঃ সন্তঃ স্থিতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","অনন্তৰং শৌলো ভূমিত উত্থায চক্ষুষী উন্মীল্য কমপি ন দৃষ্টৱান্| তদা লোকাস্তস্য হস্তৌ ধৃৎৱা দম্মেষক্নগৰম্ আনযন্| ");
INSERT INTO sanasm_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ততঃ স দিনত্ৰযং যাৱদ্ অন্ধো ভূৎৱা ন ভুক্তৱান্ পীতৱাংশ্চ| ");
INSERT INTO sanasm_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","তদনন্তৰং প্ৰভুস্তদ্দম্মেষক্নগৰৱাসিন একস্মৈ শিষ্যায দৰ্শনং দৎৱা আহূতৱান্ হে অননিয| ততঃ স প্ৰত্যৱাদীৎ, হে প্ৰভো পশ্য শৃণোমি| ");
INSERT INTO sanasm_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","তদা প্ৰভুস্তমাজ্ঞাপযৎ ৎৱমুত্থায সৰলনামানং মাৰ্গং গৎৱা যিহূদানিৱেশনে তাৰ্ষনগৰীযং শৌলনামানং জনং গৱেষযন্ পৃচ্ছ; ");
INSERT INTO sanasm_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","পশ্য স প্ৰাৰ্থযতে, তথা অননিযনামক একো জনস্তস্য সমীপম্ আগত্য তস্য গাত্ৰে হস্তাৰ্পণং কৃৎৱা দৃষ্টিং দদাতীত্থং স্ৱপ্নে দৃষ্টৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","তস্মাদ্ অননিযঃ প্ৰত্যৱদৎ হে প্ৰভো যিৰূশালমি পৱিত্ৰলোকান্ প্ৰতি সোঽনেকহিংসাং কৃতৱান্; ");
INSERT INTO sanasm_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","অত্ৰ স্থানে চ যে লোকাস্তৱ নাম্নি প্ৰাৰ্থযন্তি তানপি বদ্ধুং স প্ৰধানযাজকেভ্যঃ শক্তিং প্ৰাপ্তৱান্, ইমাং কথাম্ অহম্ অনেকেষাং মুখেভ্যঃ শ্ৰুতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","কিন্তু প্ৰভুৰকথযৎ, যাহি ভিন্নদেশীযলোকানাং ভূপতীনাম্ ইস্ৰাযেল্লোকানাঞ্চ নিকটে মম নাম প্ৰচাৰযিতুং স জনো মম মনোনীতপাত্ৰমাস্তে| ");
INSERT INTO sanasm_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","মম নামনিমিত্তঞ্চ তেন কিযান্ মহান্ ক্লেশো ভোক্তৱ্য এতৎ তং দৰ্শযিষ্যামি| ");
INSERT INTO sanasm_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ততো ঽননিযো গৎৱা গৃহং প্ৰৱিশ্য তস্য গাত্ৰে হস্তাৰ্প্ৰণং কৃৎৱা কথিতৱান্, হে ভ্ৰাতঃ শৌল ৎৱং যথা দৃষ্টিং প্ৰাপ্নোষি পৱিত্ৰেণাত্মনা পৰিপূৰ্ণো ভৱসি চ, তদৰ্থং তৱাগমনকালে যঃ প্ৰভুযীশুস্তুভ্যং দৰ্শনম্ অদদাৎ স মাং প্ৰেষিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ইত্যুক্তমাত্ৰে তস্য চক্ষুৰ্ভ্যাম্ মীনশল্কৱদ্ ৱস্তুনি নিৰ্গতে তৎক্ষণাৎ স প্ৰসন্নচক্ষু ৰ্ভূৎৱা প্ৰোত্থায মজ্জিতোঽভৱৎ ভুক্ত্ৱা পীৎৱা সবলোভৱচ্চ| ");
INSERT INTO sanasm_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ততঃ পৰং শৌলঃ শিষ্যৈঃ সহ কতিপযদিৱসান্ তস্মিন্ দম্মেষকনগৰে স্থিৎৱাঽৱিলম্বং ");
INSERT INTO sanasm_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","সৰ্ৱ্ৱভজনভৱনানি গৎৱা যীশুৰীশ্ৱৰস্য পুত্ৰ ইমাং কথাং প্ৰাচাৰযৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","তস্মাৎ সৰ্ৱ্ৱে শ্ৰোতাৰশ্চমৎকৃত্য কথিতৱন্তো যো যিৰূশালম্নগৰ এতন্নাম্না প্ৰাৰ্থযিতৃলোকান্ ৱিনাশিতৱান্ এৱম্ এতাদৃশলোকান্ বদ্ধ্ৱা প্ৰধানযাজকনিকটং নযতীত্যাশযা এতৎস্থানমপ্যাগচ্ছৎ সএৱ কিমযং ন ভৱতি? ");
INSERT INTO sanasm_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","কিন্তু শৌলঃ ক্ৰমশ উৎসাহৱান্ ভূৎৱা যীশুৰীশ্ৱৰেণাভিষিক্তো জন এতস্মিন্ প্ৰমাণং দৎৱা দম্মেষক্-নিৱাসিযিহূদীযলোকান্ নিৰুত্তৰান্ অকৰোৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ইত্থং বহুতিথে কালে গতে যিহূদীযলোকাস্তং হন্তুং মন্ত্ৰযামাসুঃ ");
INSERT INTO sanasm_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","কিন্তু শৌলস্তেষামেতস্যা মন্ত্ৰণাযা ৱাৰ্ত্তাং প্ৰাপ্তৱান্| তে তং হন্তুং তু দিৱানিশং গুপ্তাঃ সন্তো নগৰস্য দ্ৱাৰেঽতিষ্ঠন্; ");
INSERT INTO sanasm_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","তস্মাৎ শিষ্যাস্তং নীৎৱা ৰাত্ৰৌ পিটকে নিধায প্ৰাচীৰেণাৱাৰোহযন্| ");
INSERT INTO sanasm_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","ততঃ পৰং শৌলো যিৰূশালমং গৎৱা শিষ্যগণেন সাৰ্দ্ধং স্থাতুম্ ঐহৎ, কিন্তু সৰ্ৱ্ৱে তস্মাদবিভযুঃ স শিষ্য ইতি চ ন প্ৰত্যযন্| ");
INSERT INTO sanasm_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","এতস্মাদ্ বৰ্ণব্বাস্তং গৃহীৎৱা প্ৰেৰিতানাং সমীপমানীয মাৰ্গমধ্যে প্ৰভুঃ কথং তস্মৈ দৰ্শনং দত্তৱান্ যাঃ কথাশ্চ কথিতৱান্ স চ যথাক্ষোভঃ সন্ দম্মেষক্নগৰে যীশো ৰ্নাম প্ৰাচাৰযৎ এতান্ সৰ্ৱ্ৱৱৃত্তান্তান্ তান্ জ্ঞাপিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","ততঃ শৌলস্তৈঃ সহ যিৰূশালমি কালং যাপযন্ নিৰ্ভযং প্ৰভো ৰ্যীশো ৰ্নাম প্ৰাচাৰযৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","তস্মাদ্ অন্যদেশীযলোকৈঃ সাৰ্দ্ধং ৱিৱাদস্যোপস্থিতৎৱাৎ তে তং হন্তুম্ অচেষ্টন্ত| ");
INSERT INTO sanasm_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","কিন্তু ভ্ৰাতৃগণস্তজ্জ্ঞাৎৱা তং কৈসৰিযানগৰং নীৎৱা তাৰ্ষনগৰং প্ৰেষিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ইত্থং সতি যিহূদিযাগালীল্শোমিৰোণদেশীযাঃ সৰ্ৱ্ৱা মণ্ডল্যো ৱিশ্ৰামং প্ৰাপ্তাস্ততস্তাসাং নিষ্ঠাভৱৎ প্ৰভো ৰ্ভিযা পৱিত্ৰস্যাত্মনঃ সান্ত্ৱনযা চ কালং ক্ষেপযিৎৱা বহুসংখ্যা অভৱন্| ");
INSERT INTO sanasm_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","ততঃ পৰং পিতৰঃ স্থানে স্থানে ভ্ৰমিৎৱা শেষে লোদ্নগৰনিৱাসিপৱিত্ৰলোকানাং সমীপে স্থিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","তদা তত্ৰ পক্ষাঘাতৱ্যাধিনাষ্টৌ ৱৎসৰান্ শয্যাগতম্ ঐনেযনামানং মনুষ্যং সাক্ষৎ প্ৰাপ্য তমৱদৎ, ");
INSERT INTO sanasm_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","হে ঐনেয যীশুখ্ৰীষ্টস্ত্ৱাং স্ৱস্থম্ অকাৰ্ষীৎ, ৎৱমুত্থায স্ৱশয্যাং নিক্ষিপ, ইত্যুক্তমাত্ৰে স উদতিষ্ঠৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","এতাদৃশং দৃষ্ট্ৱা লোদ্শাৰোণনিৱাসিনো লোকাঃ প্ৰভুং প্ৰতি পৰাৱৰ্ত্তন্ত| ");
INSERT INTO sanasm_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","অপৰঞ্চ ভিক্ষাদানাদিষু নানক্ৰিযাসু নিত্যং প্ৰৱৃত্তা যা যাফোনগৰনিৱাসিনী টাবিথানামা শিষ্যা যাং দৰ্ক্কাং অৰ্থাদ্ হৰিণীমযুক্ত্ৱা আহ্ৱযন্ সা নাৰী ");
INSERT INTO sanasm_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","তস্মিন্ সমযে ৰুগ্না সতী প্ৰাণান্ অত্যজৎ, ততো লোকাস্তাং প্ৰক্ষাল্যোপৰিস্থপ্ৰকোষ্ঠে শাযযিৎৱাস্থাপযন্| ");
INSERT INTO sanasm_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","লোদ্নগৰং যাফোনগৰস্য সমীপস্থং তস্মাত্তত্ৰ পিতৰ আস্তে, ইতি ৱাৰ্ত্তাং শ্ৰুৎৱা তূৰ্ণং তস্যাগমনাৰ্থং তস্মিন্ ৱিনযমুক্ত্ৱা শিষ্যগণো দ্ৱৌ মনুজৌ প্ৰেষিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","তস্মাৎ পিতৰ উত্থায তাভ্যাং সাৰ্দ্ধম্ আগচ্ছৎ, তত্ৰ তস্মিন্ উপস্থিত উপৰিস্থপ্ৰকোষ্ঠং সমানীতে চ ৱিধৱাঃ স্ৱাভিঃ সহ স্থিতিকালে দৰ্ক্কযা কৃতানি যান্যুত্তৰীযাণি পৰিধেযানি চ তানি সৰ্ৱ্ৱাণি তং দৰ্শযিৎৱা ৰুদত্যশ্চতসৃষু দিক্ষ্ৱতিষ্ঠন্| ");
INSERT INTO sanasm_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","কিন্তু পিতৰস্তাঃ সৰ্ৱ্ৱা বহিঃ কৃৎৱা জানুনী পাতযিৎৱা প্ৰাৰ্থিতৱান্; পশ্চাৎ শৱং প্ৰতি দৃষ্টিং কৃৎৱা কথিতৱান্, হে টাবীথে ৎৱমুত্তিষ্ঠ, ইতি ৱাক্য উক্তে সা স্ত্ৰী চক্ষুষী প্ৰোন্মীল্য পিতৰম্ অৱলোক্যোত্থাযোপাৱিশৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","ততঃ পিতৰস্তস্যাঃ কৰৌ ধৃৎৱা উত্তোল্য পৱিত্ৰলোকান্ ৱিধৱাশ্চাহূয তেষাং নিকটে সজীৱাং তাং সমাৰ্পযৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","এষা কথা সমস্তযাফোনগৰং ৱ্যাপ্তা তস্মাদ্ অনেকে লোকাঃ প্ৰভৌ ৱ্যশ্ৱসন্| ");
INSERT INTO sanasm_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","অপৰঞ্চ পিতৰস্তদ্যাফোনগৰীযস্য কস্যচিৎ শিমোন্নাম্নশ্চৰ্ম্মকাৰস্য গৃহে বহুদিনানি ন্যৱসৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","কৈসৰিযানগৰ ইতালিযাখ্যসৈন্যান্তৰ্গতঃ কৰ্ণীলিযনামা সেনাপতিৰাসীৎ ");
INSERT INTO sanasm_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","স সপৰিৱাৰো ভক্ত ঈশ্ৱৰপৰাযণশ্চাসীৎ; লোকেভ্যো বহূনি দানাদীনি দৎৱা নিৰন্তৰম্ ঈশ্ৱৰে প্ৰাৰ্থযাঞ্চক্ৰে| ");
INSERT INTO sanasm_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","একদা তৃতীযপ্ৰহৰৱেলাযাং স দৃষ্টৱান্ ঈশ্ৱৰস্যৈকো দূতঃ সপ্ৰকাশং তৎসমীপম্ আগত্য কথিতৱান্, হে কৰ্ণীলিয| ");
INSERT INTO sanasm_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","কিন্তু স তং দৃষ্ট্ৱা ভীতোঽকথযৎ, হে প্ৰভো কিং? তদা তমৱদৎ তৱ প্ৰাৰ্থনা দানাদি চ সাক্ষিস্ৱৰূপং ভূৎৱেশ্ৱৰস্য গোচৰমভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ইদানীং যাফোনগৰং প্ৰতি লোকান্ প্ৰেষ্য সমুদ্ৰতীৰে শিমোন্নাম্নশ্চৰ্ম্মকাৰস্য গৃহে প্ৰৱাসকাৰী পিতৰনাম্না ৱিখ্যাতো যঃ শিমোন্ তম্ আহ্ৱাযয; ");
INSERT INTO sanasm_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","তস্মাৎ ৎৱযা যদ্যৎ কৰ্ত্তৱ্যং তত্তৎ স ৱদিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ইত্যুপদিশ্য দূতে প্ৰস্থিতে সতি কৰ্ণীলিযঃ স্ৱগৃহস্থানাং দাসানাং দ্ৱৌ জনৌ নিত্যং স্ৱসঙ্গিনাং সৈন্যানাম্ একাং ভক্তসেনাঞ্চাহূয ");
INSERT INTO sanasm_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","সকলমেতং ৱৃত্তান্তং ৱিজ্ঞাপ্য যাফোনগৰং তান্ প্ৰাহিণোৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","পৰস্মিন্ দিনে তে যাত্ৰাং কৃৎৱা যদা নগৰস্য সমীপ উপাতিষ্ঠন্, তদা পিতৰো দ্ৱিতীযপ্ৰহৰৱেলাযাং প্ৰাৰ্থযিতুং গৃহপৃষ্ঠম্ আৰোহৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","এতস্মিন্ সমযে ক্ষুধাৰ্ত্তঃ সন্ কিঞ্চিদ্ ভোক্তুম্ ঐচ্ছৎ কিন্তু তেষাম্ অন্নাসাদনসমযে স মূৰ্চ্ছিতঃ সন্নপতৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ততো মেঘদ্ৱাৰং মুক্তং চতুৰ্ভিঃ কোণৈ ৰ্লম্বিতং বৃহদ্ৱস্ত্ৰমিৱ কিঞ্চন ভাজনম্ আকাশাৎ পৃথিৱীম্ অৱাৰোহতীতি দৃষ্টৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","তন্মধ্যে নানপ্ৰকাৰা গ্ৰাম্যৱন্যপশৱঃ খেচৰোৰোগামিপ্ৰভৃতযো জন্তৱশ্চাসন্| ");
INSERT INTO sanasm_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","অনন্তৰং হে পিতৰ উত্থায হৎৱা ভুংক্ষ্ৱ তম্প্ৰতীযং গগণীযা ৱাণী জাতা| ");
INSERT INTO sanasm_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","তদা পিতৰঃ প্ৰত্যৱদৎ, হে প্ৰভো ঈদৃশং মা ভৱতু, অহম্ এতৎ কালং যাৱৎ নিষিদ্ধম্ অশুচি ৱা দ্ৰৱ্যং কিঞ্চিদপি ন ভুক্তৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ততঃ পুনৰপি তাদৃশী ৱিহযসীযা ৱাণী জাতা যদ্ ঈশ্ৱৰঃ শুচি কৃতৱান্ তৎ ৎৱং নিষিদ্ধং ন জানীহি| ");
INSERT INTO sanasm_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ইত্থং ত্ৰিঃ সতি তৎ পাত্ৰং পুনৰাকৃষ্টং আকাশম্ অগচ্ছৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ততঃ পৰং যদ্ দৰ্শনং প্ৰাপ্তৱান্ তস্য কো ভাৱ ইত্যত্ৰ পিতৰো মনসা সন্দেগ্ধি, এতস্মিন্ সমযে কৰ্ণীলিযস্য তে প্ৰেষিতা মনুষ্যা দ্ৱাৰস্য সন্নিধাৱুপস্থায, ");
INSERT INTO sanasm_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","শিমোনো গৃহমন্ৱিচ্ছন্তঃ সম্পৃছ্যাহূয কথিতৱন্তঃ পিতৰনাম্না ৱিখ্যাতো যঃ শিমোন্ স কিমত্ৰ প্ৰৱসতি? ");
INSERT INTO sanasm_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","যদা পিতৰস্তদ্দৰ্শনস্য ভাৱং মনসান্দোলযতি তদাত্মা তমৱদৎ, পশ্য ত্ৰযো জনাস্ত্ৱাং মৃগযন্তে| ");
INSERT INTO sanasm_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ৎৱম্ উত্থাযাৱৰুহ্য নিঃসন্দেহং তৈঃ সহ গচ্ছ মযৈৱ তে প্ৰেষিতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","তস্মাৎ পিতৰোঽৱৰুহ্য কৰ্ণীলিযপ্ৰেৰিতলোকানাং নিকটমাগত্য কথিতৱান্ পশ্যত যূযং যং মৃগযধ্ৱে স জনোহং, যূযং কিন্নিমিত্তম্ আগতাঃ? ");
INSERT INTO sanasm_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ততস্তে প্ৰত্যৱদন্ কৰ্ণীলিযনামা শুদ্ধসত্ত্ৱ ঈশ্ৱৰপৰাযণো যিহূদীযদেশস্থানাং সৰ্ৱ্ৱেষাং সন্নিধৌ সুখ্যাত্যাপন্ন একঃ সেনাপতি ৰ্নিজগৃহং ৎৱামাহূয নেতুং ৎৱত্তঃ কথা শ্ৰোতুঞ্চ পৱিত্ৰদূতেন সমাদিষ্টঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","তদা পিতৰস্তানভ্যন্তৰং নীৎৱা তেষামাতিথ্যং কৃতৱান্, পৰেঽহনি তৈঃ সাৰ্দ্ধং যাত্ৰামকৰোৎ, যাফোনিৱাসিনাং ভ্ৰাতৃণাং কিযন্তো জনাশ্চ তেন সহ গতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","পৰস্মিন্ দিৱসে কৈসৰিযানগৰমধ্যপ্ৰৱেশসমযে কৰ্ণীলিযো জ্ঞাতিবন্ধূন্ আহূযানীয তান্ অপেক্ষ্য স্থিতঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","পিতৰে গৃহ উপস্থিতে কৰ্ণীলিযস্তং সাক্ষাৎকৃত্য চৰণযোঃ পতিৎৱা প্ৰাণমৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","পিতৰস্তমুত্থাপ্য কথিতৱান্, উত্তিষ্ঠাহমপি মানুষঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","তদা কৰ্ণীলিযেন সাকম্ আলপন্ গৃহং প্ৰাৱিশৎ তন্মধ্যে চ বহুলোকানাং সমাগমং দৃষ্ট্ৱা তান্ অৱদৎ, ");
INSERT INTO sanasm_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","অন্যজাতীযলোকৈঃ মহালপনং ৱা তেষাং গৃহমধ্যে প্ৰৱেশনং যিহূদীযানাং নিষিদ্ধম্ অস্তীতি যূযম্ অৱগচ্ছথ; কিন্তু কমপি মানুষম্ অৱ্যৱহাৰ্য্যম্ অশুচিং ৱা জ্ঞাতুং মম নোচিতম্ ইতি পৰমেশ্ৱৰো মাং জ্ঞাপিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ইতি হেতোৰাহ্ৱানশ্ৰৱণমাত্ৰাৎ কাঞ্চনাপত্তিম্ অকৃৎৱা যুষ্মাকং সমীপম্ আগতোস্মি; পৃচ্ছামি যূযং কিন্নিমিত্তং মাম্ আহূযত? ");
INSERT INTO sanasm_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","তদা কৰ্ণীলিযঃ কথিতৱান্, অদ্য চৎৱাৰি দিনানি জাতানি এতাৱদ্ৱেলাং যাৱদ্ অহম্ অনাহাৰ আসন্ ততস্তৃতীযপ্ৰহৰে সতি গৃহে প্ৰাৰ্থনসমযে তেজোমযৱস্ত্ৰভৃদ্ একো জনো মম সমক্ষং তিষ্ঠন্ এতাং কথাম্ অকথযৎ, ");
INSERT INTO sanasm_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","হে কৰ্ণীলিয ৎৱদীযা প্ৰাৰ্থনা ঈশ্ৱৰস্য কৰ্ণগোচৰীভূতা তৱ দানাদি চ সাক্ষিস্ৱৰূপং ভূৎৱা তস্য দৃষ্টিগোচৰমভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","অতো যাফোনগৰং প্ৰতি লোকান্ প্ৰহিত্য তত্ৰ সমুদ্ৰতীৰে শিমোন্নাম্নঃ কস্যচিচ্চৰ্ম্মকাৰস্য গৃহে প্ৰৱাসকাৰী পিতৰনাম্না ৱিখ্যাতো যঃ শিমোন্ তমাহূाযয; ততঃ স আগত্য ৎৱাম্ উপদেক্ষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ইতি কাৰণাৎ তৎক্ষণাৎ তৱ নিকটে লোকান্ প্ৰেষিতৱান্, ৎৱমাগতৱান্ ইতি ভদ্ৰং কৃতৱান্| ঈশ্ৱৰো যান্যাখ্যানানি কথযিতুম্ আদিশৎ তানি শ্ৰোতুং ৱযং সৰ্ৱ্ৱে সাম্প্ৰতম্ ঈশ্ৱৰস্য সাক্ষাদ্ উপস্থিতাঃ স্মঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","তদা পিতৰ ইমাং কথাং কথযিতুম্ আৰব্ধৱান্, ঈশ্ৱৰো মনুষ্যাণাম্ অপক্ষপাতী সন্ ");
INSERT INTO sanasm_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","যস্য কস্যচিদ্ দেশস্য যো লোকাস্তস্মাদ্ভীৎৱা সৎকৰ্ম্ম কৰোতি স তস্য গ্ৰাহ্যো ভৱতি, এতস্য নিশ্চযম্ উপলব্ধৱানহম্| ");
INSERT INTO sanasm_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","সৰ্ৱ্ৱেষাং প্ৰভু ৰ্যো যীশুখ্ৰীষ্টস্তেন ঈশ্ৱৰ ইস্ৰাযেল্ৱংশানাং নিকটে সুসংৱাদং প্ৰেষ্য সম্মেলনস্য যং সংৱাদং প্ৰাচাৰযৎ তং সংৱাদং যূযং শ্ৰুতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","যতো যোহনা মজ্জনে প্ৰচাৰিতে সতি স গালীলদেশমাৰভ্য সমস্তযিহূদীযদেশং ৱ্যাপ্নোৎ; ");
INSERT INTO sanasm_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ফলত ঈশ্ৱৰেণ পৱিত্ৰেণাত্মনা শক্ত্যা চাভিষিক্তো নাসৰতীযযীশুঃ স্থানে স্থানে ভ্ৰমন্ সুক্ৰিযাং কুৰ্ৱ্ৱন্ শৈতানা ক্লিষ্টান্ সৰ্ৱ্ৱলোকান্ স্ৱস্থান্ অকৰোৎ, যত ঈশ্ৱৰস্তস্য সহায আসীৎ; ");
INSERT INTO sanasm_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","ৱযঞ্চ যিহূদীযদেশে যিৰূশালম্নগৰে চ তেন কৃতানাং সৰ্ৱ্ৱেষাং কৰ্ম্মণাং সাক্ষিণো ভৱামঃ| লোকাস্তং ক্ৰুশে ৱিদ্ধ্ৱা হতৱন্তঃ, ");
INSERT INTO sanasm_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","কিন্তু তৃতীযদিৱসে ঈশ্ৱৰস্তমুত্থাপ্য সপ্ৰকাশম্ অদৰ্শযৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","সৰ্ৱ্ৱলোকানাং নিকট ইতি ন হি, কিন্তু তস্মিন্ শ্মশানাদুত্থিতে সতি তেন সাৰ্দ্ধং ভোজনং পানঞ্চ কৃতৱন্ত এতাদৃশা ঈশ্ৱৰস্য মনোনীতাঃ সাক্ষিণো যে ৱযম্ অস্মাকং নিকটে তমদৰ্শযৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","জীৱিতমৃতোভযলোকানাং ৱিচাৰং কৰ্ত্তুম্ ঈশ্ৱৰো যং নিযুক্তৱান্ স এৱ স জনঃ, ইমাং কথাং প্ৰচাৰযিতুং তস্মিন্ প্ৰমাণং দাতুঞ্চ সোঽস্মান্ আজ্ঞাপযৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","যস্তস্মিন্ ৱিশ্ৱসিতি স তস্য নাম্না পাপান্মুক্তো ভৱিষ্যতি তস্মিন্ সৰ্ৱ্ৱে ভৱিষ্যদ্ৱাদিনোপি এতাদৃশং সাক্ষ্যং দদতি| ");
INSERT INTO sanasm_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","পিতৰস্যৈতৎকথাকথনকালে সৰ্ৱ্ৱেষাং শ্ৰোতৃণামুপৰি পৱিত্ৰ আত্মাৱাৰোহৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ততঃ পিতৰেণ সাৰ্দ্ধম্ আগতাস্ত্ৱক্ছেদিনো ৱিশ্ৱাসিনো লোকা অন্যদেশীযেভ্যঃ পৱিত্ৰ আত্মনি দত্তে সতি ");
INSERT INTO sanasm_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","তে নানাজাতীযভাষাভিঃ কথাং কথযন্ত ঈশ্ৱৰং প্ৰশংসন্তি, ইতি দৃষ্ট্ৱা শ্ৰুৎৱা চ ৱিস্মযম্ আপদ্যন্ত| ");
INSERT INTO sanasm_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","তদা পিতৰঃ কথিতৱান্, ৱযমিৱ যে পৱিত্ৰম্ আত্মানং প্ৰাপ্তাস্তেষাং জলমজ্জনং কিং কোপি নিষেদ্ধুং শক্নোতি? ");
INSERT INTO sanasm_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","ততঃ প্ৰভো ৰ্নাম্না মজ্জিতা ভৱতেতি তানাজ্ঞাপযৎ| অনন্তৰং তে স্ৱৈঃ সাৰ্দ্ধং কতিপযদিনানি স্থাতুং প্ৰাৰ্থযন্ত| ");
INSERT INTO sanasm_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","ইত্থং ভিন্নদেশীযলোকা অপীশ্ৱৰস্য ৱাক্যম্ অগৃহ্লন্ ইমাং ৱাৰ্ত্তাং যিহূদীযদেশস্থপ্ৰেৰিতা ভ্ৰাতৃগণশ্চ শ্ৰুতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ততঃ পিতৰে যিৰূশালম্নগৰং গতৱতি ৎৱক্ছেদিনো লোকাস্তেন সহ ৱিৱদমানা অৱদন্, ");
INSERT INTO sanasm_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ৎৱম্ অৎৱক্ছেদিলোকানাং গৃহং গৎৱা তৈঃ সাৰ্দ্ধং ভুক্তৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","ততঃ পিতৰ আদিতঃ ক্ৰমশস্তৎকাৰ্য্যস্য সৰ্ৱ্ৱৱৃত্তান্তমাখ্যাতুম্ আৰব্ধৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","যাফোনগৰ একদাহং প্ৰাৰ্থযমানো মূৰ্চ্ছিতঃ সন্ দৰ্শনেন চতুৰ্ষু কোণেষু লম্বনমানং ৱৃহদ্ৱস্ত্ৰমিৱ পাত্ৰমেকম্ আকাশদৱৰুহ্য মন্নিকটম্ আগচ্ছদ্ অপশ্যম্| ");
INSERT INTO sanasm_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","পশ্চাৎ তদ্ অনন্যদৃষ্ট্যা দৃষ্ট্ৱা ৱিৱিচ্য তস্য মধ্যে নানাপ্ৰকাৰান্ গ্ৰাম্যৱন্যপশূন্ উৰোগামিখেচৰাংশ্চ দৃষ্টৱান্; ");
INSERT INTO sanasm_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","হে পিতৰ ৎৱমুত্থায গৎৱা ভুংক্ষ্ৱ মাং সম্বোধ্য কথযন্তং শব্দমেকং শ্ৰুতৱাংশ্চ| ");
INSERT INTO sanasm_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","ততোহং প্ৰত্যৱদং, হে প্ৰভো নেত্থং ভৱতু, যতঃ কিঞ্চন নিষিদ্ধম্ অশুচি দ্ৰৱ্যং ৱা মম মুখমধ্যং কদাপি ন প্ৰাৱিশৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","অপৰম্ ঈশ্ৱৰো যৎ শুচি কৃতৱান্ তন্নিষিদ্ধং ন জানীহি দ্ৱি ৰ্মাম্প্ৰতীদৃশী ৱিহাযসীযা ৱাণী জাতা| ");
INSERT INTO sanasm_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","ত্ৰিৰিত্থং সতি তৎ সৰ্ৱ্ৱং পুনৰাকাশম্ আকৃষ্টং| ");
INSERT INTO sanasm_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","পশ্চাৎ কৈসৰিযানগৰাৎ ত্ৰযো জনা মন্নিকটং প্ৰেষিতা যত্ৰ নিৱেশনে স্থিতোহং তস্মিন্ সমযে তত্ৰোপাতিষ্ঠন্| ");
INSERT INTO sanasm_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","তদা নিঃসন্দেহং তৈঃ সাৰ্দ্ধং যাতুম্ আত্মা মামাদিষ্টৱান্; ততঃ পৰং মযা সহৈতেষু ষড্ভ্ৰাতৃষু গতেষু ৱযং তস্য মনুজস্য গৃহং প্ৰাৱিশাম| ");
INSERT INTO sanasm_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","সোস্মাকং নিকটে কথামেতাম্ অকথযৎ একদা দূত একঃ প্ৰত্যক্ষীভূয মম গৃহমধ্যে তিষ্টন্ মামিত্যাজ্ঞাপিতৱান্, যাফোনগৰং প্ৰতি লোকান্ প্ৰহিত্য পিতৰনাম্না ৱিখ্যাতং শিমোনম্ আহূযয; ");
INSERT INTO sanasm_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ততস্তৱ ৎৱদীযপৰিৱাৰাণাঞ্চ যেন পৰিত্ৰাণং ভৱিষ্যতি তৎ স উপদেক্ষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","অহং তাং কথামুত্থাপ্য কথিতৱান্ তেন প্ৰথমম্ অস্মাকম্ উপৰি যথা পৱিত্ৰ আত্মাৱৰূঢৱান্ তথা তেষামপ্যুপৰি সমৱৰূঢৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","তেন যোহন্ জলে মজ্জিতৱান্ ইতি সত্যং কিন্তু যূযং পৱিত্ৰ আত্মনি মজ্জিতা ভৱিষ্যথ, ইতি যদ্ৱাক্যং প্ৰভুৰুদিতৱান্ তৎ তদা মযা স্মৃতম্| ");
INSERT INTO sanasm_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","অতঃ প্ৰভা যীশুখ্ৰীষ্টে প্ৰত্যযকাৰিণো যে ৱযম্ অস্মভ্যম্ ঈশ্ৱৰো যদ্ দত্তৱান্ তৎ তেভ্যো লোকেভ্যোপি দত্তৱান্ ততঃ কোহং? কিমহম্ ঈশ্ৱৰং ৱাৰযিতুং শক্নোমি? ");
INSERT INTO sanasm_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","কথামেতাং শ্ৰুৱা তে ক্ষান্তা ঈশ্ৱৰস্য গুণান্ অনুকীৰ্ত্ত্য কথিতৱন্তঃ, তৰ্হি পৰমাযুঃপ্ৰাপ্তিনিমিত্তম্ ঈশ্ৱৰোন্যদেশীযলোকেভ্যোপি মনঃপৰিৱৰ্ত্তনৰূপং দানম্ অদাৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","স্তিফানং প্ৰতি উপদ্ৰৱে ঘটিতে যে ৱিকীৰ্ণা অভৱন্ তৈ ফৈনীকীকুপ্ৰান্তিযখিযাসু ভ্ৰমিৎৱা কেৱলযিহূদীযলোকান্ ৱিনা কস্যাপ্যন্যস্য সমীপ ঈশ্ৱৰস্য কথাং ন প্ৰাচাৰযন্| ");
INSERT INTO sanasm_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","অপৰং তেষাং কুপ্ৰীযাঃ কুৰীনীযাশ্চ কিযন্তো জনা আন্তিযখিযানগৰং গৎৱা যূনানীযলোকানাং সমীপেপি প্ৰভোৰ্যীশোঃ কথাং প্ৰাচাৰযন্| ");
INSERT INTO sanasm_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","প্ৰভোঃ কৰস্তেষাং সহায আসীৎ তস্মাদ্ অনেকে লোকা ৱিশ্ৱস্য প্ৰভুং প্ৰতি পৰাৱৰ্ত্তন্ত| ");
INSERT INTO sanasm_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ইতি ৱাৰ্ত্তাযাং যিৰূশালমস্থমণ্ডলীযলোকানাং কৰ্ণগোচৰীভূতাযাম্ আন্তিযখিযানগৰং গন্তু তে বৰ্ণব্বাং প্ৰৈৰযন্| ");
INSERT INTO sanasm_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ততো বৰ্ণব্বাস্তত্ৰ উপস্থিতঃ সন্ ঈশ্ৱৰস্যানুগ্ৰহস্য ফলং দৃষ্ট্ৱা সানন্দো জাতঃ, ");
INSERT INTO sanasm_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","স স্ৱযং সাধু ৰ্ৱিশ্ৱাসেন পৱিত্ৰেণাত্মনা চ পৰিপূৰ্ণঃ সন্ গনোনিষ্টযা প্ৰভাৱাস্থাং কৰ্ত্তুং সৰ্ৱ্ৱান্ উপদিষ্টৱান্ তেন প্ৰভোঃ শিষ্যা অনেকে বভূৱুঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","শেষে শৌলং মৃগযিতুং বৰ্ণব্বাস্তাৰ্ষনগৰং প্ৰস্থিতৱান্| তত্ৰ তস্যোদ্দেশং প্ৰাপ্য তম্ আন্তিযখিযানগৰম্ আনযৎ; ");
INSERT INTO sanasm_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ততস্তৌ মণ্ডলীস্থলোকৈঃ সভাং কৃৎৱা সংৱৎসৰমেকং যাৱদ্ বহুলোকান্ উপাদিশতাং; তস্মিন্ আন্তিযখিযানগৰে শিষ্যাঃ প্ৰথমং খ্ৰীষ্টীযনাম্না ৱিখ্যাতা অভৱন্| ");
INSERT INTO sanasm_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","ততঃ পৰং ভৱিষ্যদ্ৱাদিগণে যিৰূশালম আন্তিযখিযানগৰম্ আগতে সতি ");
INSERT INTO sanasm_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","আগাবনামা তেষামেক উত্থায আত্মনঃ শিক্ষযা সৰ্ৱ্ৱদেশে দুৰ্ভিক্ষং ভৱিষ্যতীতি জ্ঞাপিতৱান্; ততঃ ক্লৌদিযকৈসৰস্যাধিকাৰে সতি তৎ প্ৰত্যক্ষম্ অভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","তস্মাৎ শিষ্যা একৈকশঃ স্ৱস্ৱশক্ত্যনুসাৰতো যিহূদীযদেশনিৱাসিনাং ভ্ৰতৃণাং দিনযাপনাৰ্থং ধনং প্ৰেষযিতুং নিশ্চিত্য ");
INSERT INTO sanasm_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","বৰ্ণব্বাশৌলযো ৰ্দ্ৱাৰা প্ৰাচীনলোকানাং সমীপং তৎ প্ৰেষিতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","তস্মিন্ সমযে হেৰোদ্‌ৰাজো মণ্ডল্যাঃ কিযজ্জনেভ্যো দুঃখং দাতুং প্ৰাৰভৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ৱিশেষতো যোহনঃ সোদৰং যাকূবং কৰৱালাঘাতেন্ হতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","তস্মাদ্ যিহূদীযাঃ সন্তুষ্টা অভৱন্ ইতি ৱিজ্ঞায স পিতৰমপি ধৰ্ত্তুং গতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","তদা কিণ্ৱশূন্যপূপোৎসৱসময উপাতিষ্টৎ; অত উৎসৱে গতে সতি লোকানাং সমক্ষং তং বহিৰানেয্যামীতি মনসি স্থিৰীকৃত্য স তং ধাৰযিৎৱা ৰক্ষ্ণাৰ্থম্ যেষাম্ একৈকসংঘে চৎৱাৰো জনাঃ সন্তি তেষাং চতুৰ্ণাং ৰক্ষকসংঘানাং সমীপে তং সমৰ্প্য কাৰাযাং স্থাপিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","কিন্তুং পিতৰস্য কাৰাস্থিতিকাৰণাৎ মণ্ডল্যা লোকা অৱিশ্ৰামম্ ঈশ্ৱৰস্য সমীপে প্ৰাৰ্থযন্ত| ");
INSERT INTO sanasm_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","অনন্তৰং হেৰোদি তং বহিৰানাযিতুং উদ্যতে সতি তস্যাং ৰাত্ৰৌ পিতৰো ৰক্ষকদ্ৱযমধ্যস্থানে শৃঙ্খলদ্ৱযেন বদ্ধ্ৱঃ সন্ নিদ্ৰিত আসীৎ, দৌৱাৰিকাশ্চ কাৰাযাঃ সম্মুখে তিষ্ঠনতো দ্ৱাৰম্ অৰক্ষিষুঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","এতস্মিন্ সমযে পৰমেশ্ৱৰস্য দূতে সমুপস্থিতে কাৰা দীপ্তিমতী জাতা; ততঃ স দূতঃ পিতৰস্য কুক্ষাৱাৱাতং কৃৎৱা তং জাগৰযিৎৱা ভাষিতৱান্ তূৰ্ণমুত্তিষ্ঠ; ততস্তস্য হস্তস্থশৃঙ্খলদ্ৱযং গলৎ পতিতং| ");
INSERT INTO sanasm_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","স দূতস্তমৱদৎ, বদ্ধকটিঃ সন্ পাদযোঃ পাদুকে অৰ্পয; তেন তথা কৃতে সতি দূতস্তম্ উক্তৱান্ গাত্ৰীযৱস্ত্ৰং গাত্ৰে নিধায মম পশ্চাদ্ এহি| ");
INSERT INTO sanasm_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ততঃ পিতৰস্তস্য পশ্চাদ্ ৱ্ৰজন বহিৰগচ্ছৎ, কিন্তু দূতেন কৰ্ম্মৈতৎ কৃতমিতি সত্যমজ্ঞাৎৱা স্ৱপ্নদৰ্শনং জ্ঞাতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ইত্থং তৌ প্ৰথমাং দ্ৱিতীযাঞ্চ কাৰাং লঙ্ঘিৎৱা যেন লৌহনিৰ্ম্মিতদ্ৱাৰেণ নগৰং গম্যতে তৎসমীপং প্ৰাপ্নুতাং; ততস্তস্য কৱাটং স্ৱযং মুক্তমভৱৎ ততস্তৌ তৎস্থানাদ্ বহি ৰ্ভূৎৱা মাৰ্গৈকস্য সীমাং যাৱদ্ গতৌ; ততোঽকস্মাৎ স দূতঃ পিতৰং ত্যক্তৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","তদা স চেতনাং প্ৰাপ্য কথিতৱান্ নিজদূতং প্ৰহিত্য পৰমেশ্ৱৰো হেৰোদো হস্তাদ্ যিহূদীযলোকানাং সৰ্ৱ্ৱাশাযাশ্চ মাং সমুদ্ধৃতৱান্ ইত্যহং নিশ্চযং জ্ঞাতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","স ৱিৱিচ্য মাৰ্কনাম্ৰা ৱিখ্যাতস্য যোহনো মাতু ৰ্মৰিযমো যস্মিন্ গৃহে বহৱঃ সম্ভূয প্ৰাৰ্থযন্ত তন্নিৱেশনং গতঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","পিতৰেণ বহিৰ্দ্ৱাৰ আহতে সতি ৰোদানামা বালিকা দ্ৰষ্টুং গতা| ");
INSERT INTO sanasm_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","ততঃ পিতৰস্য স্ৱৰং শ্ৰুৱা সা হৰ্ষযুক্তা সতী দ্ৱাৰং ন মোচযিৎৱা পিতৰো দ্ৱাৰে তিষ্ঠতীতি ৱাৰ্ত্তাং ৱক্তুম্ অভ্যন্তৰং ধাৱিৎৱা গতৱতী| ");
INSERT INTO sanasm_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","তে প্ৰাৱোচন্ ৎৱমুন্মত্তা জাতাসি কিন্তু সা মুহুৰ্মুহুৰুক্তৱতী সত্যমেৱৈতৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","তদা তে কথিতৱন্তস্তৰ্হি তস্য দূতো ভৱেৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","পিতৰো দ্ৱাৰমাহতৱান্ এতস্মিন্নন্তৰে দ্ৱাৰং মোচযিৎৱা পিতৰং দৃষ্ট্ৱা ৱিস্মযং প্ৰাপ্তাঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","ততঃ পিতৰো নিঃশব্দং স্থাতুং তান্ প্ৰতি হস্তেন সঙ্কেতং কৃৎৱা পৰমেশ্ৱৰো যেন প্ৰকাৰেণ তং কাৰাযা উদ্ধৃত্যানীতৱান্ তস্য ৱৃত্তান্তং তানজ্ঞাপযৎ, যূযং গৎৱা যাকুবং ভ্ৰাতৃগণঞ্চ ৱাৰ্ত্তামেতাং ৱদতেত্যুক্তা স্থানান্তৰং প্ৰস্থিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","প্ৰভাতে সতি পিতৰঃ ক্ৱ গত ইত্যত্ৰ ৰক্ষকাণাং মধ্যে মহান্ কলহো জাতঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","হেৰোদ্ বহু মৃগযিৎৱা তস্যোদ্দেশে ন প্ৰাপ্তে সতি ৰক্ষকান্ সংপৃচ্ছ্য তেষাং প্ৰাণান্ হন্তুম্ আদিষ্টৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","পশ্চাৎ স যিহূদীযপ্ৰদেশাৎ কৈসৰিযানগৰং গৎৱা তত্ৰাৱাতিষ্ঠৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","সোৰসীদোনদেশযো ৰ্লোকেভ্যো হেৰোদি যুযুৎসৌ সতি তে সৰ্ৱ্ৱ একমন্ত্ৰণাঃ সন্তস্তস্য সমীপ উপস্থায ল্ৱাস্তনামানং তস্য ৱস্ত্ৰগৃহাধীশং সহাযং কৃৎৱা হেৰোদা সাৰ্দ্ধং সন্ধিং প্ৰাৰ্থযন্ত যতস্তস্য ৰাজ্ঞো দেশেন তেষাং দেশীযানাং ভৰণম্ অভৱৎং ");
INSERT INTO sanasm_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","অতঃ কুত্ৰচিন্ নিৰুপিতদিনে হেৰোদ্ ৰাজকীযং পৰিচ্ছদং পৰিধায সিংহাসনে সমুপৱিশ্য তান্ প্ৰতি কথাম্ উক্তৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","ততো লোকা উচ্চৈঃকাৰং প্ৰত্যৱদন্, এষ মনুজৰৱো ন হি, ঈশ্ৱৰীযৰৱঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","তদা হেৰোদ্ ঈশ্ৱৰস্য সম্মানং নাকৰোৎ; তস্মাদ্ধেতোঃ পৰমেশ্ৱৰস্য দূতো হঠাৎ তং প্ৰাহৰৎ তেনৈৱ স কীটৈঃ ক্ষীণঃ সন্ প্ৰাণান্ অজহাৎ| কিন্ত্ৱীশ্ৱৰস্য কথা দেশং ৱ্যাপ্য প্ৰবলাভৱৎ| ততঃ পৰং বৰ্ণব্বাশৌলৌ যস্য কৰ্ম্মণো ভাৰং প্ৰাপ্নুতাং তাভ্যাং তস্মিন্ সম্পাদিতে সতি মাৰ্কনাম্না ৱিখ্যাতো যো যোহন্ তং সঙ্গিনং কৃৎৱা যিৰূশালম্নগৰাৎ প্ৰত্যাগতৌ| ");
INSERT INTO sanasm_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","অপৰঞ্চ বৰ্ণব্বাঃ, শিমোন্ যং নিগ্ৰং ৱদন্তি, কুৰীনীযলূকিযো হেৰোদা ৰাজ্ঞা সহ কৃতৱিদ্যাाভ্যাসো মিনহেম্, শৌলশ্চৈতে যে কিযন্তো জনা ভৱিষ্যদ্ৱাদিন উপদেষ্টাৰশ্চান্তিযখিযানগৰস্থমণ্ডল্যাম্ আসন্, ");
INSERT INTO sanasm_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","তে যদোপৱাসং কৃৎৱেশ্ৱৰম্ অসেৱন্ত তস্মিন্ সমযে পৱিত্ৰ আত্মা কথিতৱান্ অহং যস্মিন্ কৰ্ম্মণি বৰ্ণব্বাশৈলৌ নিযুক্তৱান্ তৎকৰ্ম্ম কৰ্ত্তুং তৌ পৃথক্ কুৰুত| ");
INSERT INTO sanasm_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","ততস্তৈৰুপৱাসপ্ৰাৰ্থনযোঃ কৃতযোঃ সতোস্তে তযো ৰ্গাত্ৰযো ৰ্হস্তাৰ্পণং কৃৎৱা তৌ ৱ্যসৃজন্| ");
INSERT INTO sanasm_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","ততঃ পৰং তৌ পৱিত্ৰেণাত্মনা প্ৰেৰিতৌ সন্তৌ সিলূকিযানগৰম্ উপস্থায সমুদ্ৰপথেন কুপ্ৰোপদ্ৱীপম্ অগচ্ছতাং| ");
INSERT INTO sanasm_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ততঃ সালামীনগৰম্ উপস্থায তত্ৰ যিহূদীযানাং ভজনভৱনানি গৎৱেশ্ৱৰস্য কথাং প্ৰাচাৰযতাং; যোহনপি তৎসহচৰোঽভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ইত্থং তে তস্যোপদ্ৱীপস্য সৰ্ৱ্ৱত্ৰ ভ্ৰমন্তঃ পাফনগৰম্ উপস্থিতাঃ; তত্ৰ সুৱিৱেচকেন সৰ্জিযপৌলনাম্না তদ্দেশাধিপতিনা সহ ভৱিষ্যদ্ৱাদিনো ৱেশধাৰী বৰ্যীশুনামা যো মাযাৱী যিহূদী আসীৎ তং সাক্ষাৎ প্ৰাপ্তৱতঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","তদ্দেশাধিপ ঈশ্ৱৰস্য কথাং শ্ৰোতুং ৱাঞ্ছন্ পৌলবৰ্ণব্বৌ ন্যমন্ত্ৰযৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","কিন্ত্ৱিলুমা যং মাযাৱিনং ৱদন্তি স দেশাধিপতিং ধৰ্ম্মমাৰ্গাদ্ বহিৰ্ভূতং কৰ্ত্তুম্ অযতত| ");
INSERT INTO sanasm_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","তস্মাৎ শোলোঽৰ্থাৎ পৌলঃ পৱিত্ৰেণাত্মনা পৰিপূৰ্ণঃ সন্ তং মাযাৱিনং প্ৰত্যনন্যদৃষ্টিং কৃৎৱাকথযৎ, ");
INSERT INTO sanasm_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","হে নৰকিন্ ধৰ্ম্মদ্ৱেষিন্ কৌটিল্যদুষ্কৰ্ম্মপৰিপূৰ্ণ, ৎৱং কিং প্ৰভোঃ সত্যপথস্য ৱিপৰ্য্যযকৰণাৎ কদাপি ন নিৱৰ্ত্তিষ্যসে? ");
INSERT INTO sanasm_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","অধুনা পৰমেশ্ৱৰস্তৱ সমুচিতং কৰিষ্যতি তেন কতিপযদিনানি ৎৱম্ অন্ধঃ সন্ সূৰ্য্যমপি ন দ্ৰক্ষ্যসি| তৎক্ষণাদ্ ৰাত্ৰিৱদ্ অন্ধকাৰস্তস্য দৃষ্টিম্ আচ্ছাদিতৱান্; তস্মাৎ তস্য হস্তং ধৰ্ত্তুং স লোকমন্ৱিচ্ছন্ ইতস্ততো ভ্ৰমণং কৃতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","এনাং ঘটনাং দৃষ্ট্ৱা স দেশাধিপতিঃ প্ৰভূপদেশাদ্ ৱিস্মিত্য ৱিশ্ৱাসং কৃতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","তদনন্তৰং পৌলস্তৎসঙ্গিনৌ চ পাফনগৰাৎ প্ৰোতং চালযিৎৱা পম্ফুলিযাদেশস্য পৰ্গীনগৰম্ অগচ্ছন্ কিন্তু যোহন্ তযোঃ সমীপাদ্ এত্য যিৰূশালমং প্ৰত্যাগচ্ছৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","পশ্চাৎ তৌ পৰ্গীতো যাত্ৰাং কৃৎৱা পিসিদিযাদেশস্য আন্তিযখিযানগৰম্ উপস্থায ৱিশ্ৰামৱাৰে ভজনভৱনং প্ৰৱিশ্য সমুপাৱিশতাং| ");
INSERT INTO sanasm_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ৱ্যৱস্থাভৱিষ্যদ্ৱাক্যযোঃ পঠিতযোঃ সতো ৰ্হে ভ্ৰাতৰৌ লোকান্ প্ৰতি যুৱযোঃ কাচিদ্ উপদেশকথা যদ্যস্তি তৰ্হি তাং ৱদতং তৌ প্ৰতি তস্য ভজনভৱনস্যাধিপতযঃ কথাম্ এতাং কথযিৎৱা প্ৰৈষযন্| ");
INSERT INTO sanasm_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","অতঃ পৌল উত্তিষ্ঠন্ হস্তেন সঙ্কেতং কুৰ্ৱ্ৱন্ কথিতৱান্ হে ইস্ৰাযেলীযমনুষ্যা ঈশ্ৱৰপৰাযণাঃ সৰ্ৱ্ৱে লোকা যূযম্ অৱধদ্ধং| ");
INSERT INTO sanasm_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","এতেষামিস্ৰাযেল্লোকানাম্ ঈশ্ৱৰোঽস্মাকং পূৰ্ৱ্ৱপৰুষান্ মনোনীতান্ কৎৱা গৃহীতৱান্ ততো মিসৰি দেশে প্ৰৱসনকালে তেষামুন্নতিং কৃৎৱা তস্মাৎ স্ৱীযবাহুবলেন তান্ বহিঃ কৃৎৱা সমানযৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","চৎৱাৰিংশদ্ৱৎসৰান্ যাৱচ্চ মহাপ্ৰান্তৰে তেষাং ভৰণং কৃৎৱা ");
INSERT INTO sanasm_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","কিনান্দেশান্তৰ্ৱ্ৱৰ্ত্তীণি সপ্তৰাজ্যানি নাশযিৎৱা গুটিকাপাতেন তেষু সৰ্ৱ্ৱদেশেষু তেভ্যোঽধিকাৰং দত্তৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","পঞ্চাশদধিকচতুঃশতেষু ৱৎসৰেষু গতেষু চ শিমূযেল্ভৱিষ্যদ্ৱাদিপৰ্য্যন্তং তেষামুপৰি ৱিচাৰযিতৃন্ নিযুক্তৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","তৈশ্চ ৰাজ্ঞি প্ৰাৰ্থিতে, ঈশ্ৱৰো বিন্যামীনো ৱংশজাতস্য কীশঃ পুত্ৰং শৌলং চৎৱাৰিংশদ্ৱৰ্ষপৰ্য্যন্তং তেষামুপৰি ৰাজানং কৃতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","পশ্চাৎ তং পদচ্যুতং কৃৎৱা যো মদিষ্টক্ৰিযাঃ সৰ্ৱ্ৱাঃ কৰিষ্যতি তাদৃশং মম মনোভিমতম্ একং জনং যিশযঃ পুত্ৰং দাযূদং প্ৰাপ্তৱান্ ইদং প্ৰমাণং যস্মিন্ দাযূদি স দত্তৱান্ তং দাযূদং তেষামুপৰি ৰাজৎৱং কৰ্ত্তুম্ উৎপাদিতৱান| ");
INSERT INTO sanasm_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","তস্য স্ৱপ্ৰতিশ্ৰুতস্য ৱাক্যস্যানুসাৰেণ ইস্ৰাযেল্লোকানাং নিমিত্তং তেষাং মনুষ্যাণাং ৱংশাদ্ ঈশ্ৱৰ একং যীশুং (ত্ৰাতাৰম্) উদপাদযৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","তস্য প্ৰকাশনাৎ পূৰ্ৱ্ৱং যোহন্ ইস্ৰাযেল্লোকানাং সন্নিধৌ মনঃপৰাৱৰ্ত্তনৰূপং মজ্জনং প্ৰাচাৰযৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","যস্য চ কৰ্ম্মণোे ভাৰং প্ৰপ্তৱান্ যোহন্ তন্ নিষ্পাদযন্ এতাং কথাং কথিতৱান্, যূযং মাং কং জনং জানীথ? অহম্ অভিষিক্তত্ৰাতা নহি, কিন্তু পশ্যত যস্য পাদযোঃ পাদুকযো ৰ্বন্ধনে মোচযিতুমপি যোগ্যো ন ভৱামি তাদৃশ একো জনো মম পশ্চাদ্ উপতিষ্ঠতি| ");
INSERT INTO sanasm_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","হে ইব্ৰাহীমো ৱংশজাতা ভ্ৰাতৰো হে ঈশ্ৱৰভীতাঃ সৰ্ৱ্ৱলোকা যুষ্মান্ প্ৰতি পৰিত্ৰাণস্য কথৈষা প্ৰেৰিতা| ");
INSERT INTO sanasm_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","যিৰূশালম্নিৱাসিনস্তেষাম্ অধিপতযশ্চ তস্য যীশোঃ পৰিচযং ন প্ৰাপ্য প্ৰতিৱিশ্ৰামৱাৰং পঠ্যমানানাং ভৱিষ্যদ্ৱাদিকথানাম্ অভিপ্ৰাযম্ অবুদ্ধ্ৱা চ তস্য ৱধেন তাঃ কথাঃ সফলা অকুৰ্ৱ্ৱন্| ");
INSERT INTO sanasm_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","প্ৰাণহননস্য কমপি হেতুম্ অপ্ৰাপ্যাপি পীলাতস্য নিকটে তস্য ৱধং প্ৰাৰ্থযন্ত| ");
INSERT INTO sanasm_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","তস্মিন্ যাঃ কথা লিখিতাঃ সন্তি তদনুসাৰেণ কৰ্ম্ম সম্পাদ্য তং ক্ৰুশাদ্ অৱতাৰ্য্য শ্মশানে শাযিতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","কিন্ত্ৱীশ্ৱৰঃ শ্মশানাৎ তমুদস্থাপযৎ, ");
INSERT INTO sanasm_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","পুনশ্চ গালীলপ্ৰদেশাদ্ যিৰূশালমনগৰং তেন সাৰ্দ্ধং যে লোকা আগচ্ছন্ স বহুদিনানি তেভ্যো দৰ্শনং দত্তৱান্, অতস্ত ইদানীং লোকান্ প্ৰতি তস্য সাক্ষিণঃ সন্তি| ");
INSERT INTO sanasm_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","অস্মাকং পূৰ্ৱ্ৱপুৰুষাণাং সমক্ষম্ ঈশ্ৱৰো যস্মিন্ প্ৰতিজ্ঞাতৱান্ যথা, ৎৱং মে পুত্ৰোসি চাদ্য ৎৱাং সমুত্থাপিতৱানহম্| ");
INSERT INTO sanasm_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ইদং যদ্ৱচনং দ্ৱিতীযগীতে লিখিতমাস্তে তদ্ যীশোৰুত্থানেন তেষাং সন্তানা যে ৱযম্ অস্মাকং সন্নিধৌ তেন প্ৰত্যক্ষী কৃতং, যুষ্মান্ ইমং সুসংৱাদং জ্ঞাপযামি| ");
INSERT INTO sanasm_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","পৰমেশ্ৱৰেণ শ্মশানাদ্ উত্থাপিতং তদীযং শৰীৰং কদাপি ন ক্ষেষ্যতে, এতস্মিন্ স স্ৱযং কথিতৱান্ যথা দাযূদং প্ৰতি প্ৰতিজ্ঞাতো যো ৱৰস্তমহং তুভ্যং দাস্যামি| ");
INSERT INTO sanasm_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","এতদন্যস্মিন্ গীতেঽপি কথিতৱান্| স্ৱকীযং পুণ্যৱন্তং ৎৱং ক্ষযিতুং ন চ দাস্যসি| ");
INSERT INTO sanasm_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","দাযূদা ঈশ্ৱৰাভিমতসেৱাযৈ নিজাযুষি ৱ্যযিতে সতি স মহানিদ্ৰাং প্ৰাপ্য নিজৈঃ পূৰ্ৱ্ৱপুৰুষৈঃ সহ মিলিতঃ সন্ অক্ষীযত; ");
INSERT INTO sanasm_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","কিন্তু যমীশ্ৱৰঃ শ্মশানাদ্ উদস্থাপযৎ স নাক্ষীযত| ");
INSERT INTO sanasm_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","অতো হে ভ্ৰাতৰঃ, অনেন জনেন পাপমোচনং ভৱতীতি যুষ্মান্ প্ৰতি প্ৰচাৰিতম্ আস্তে| ");
INSERT INTO sanasm_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ফলতো মূসাৱ্যৱস্থযা যূযং যেভ্যো দোষেভ্যো মুক্তা ভৱিতুং ন শক্ষ্যথ তেভ্যঃ সৰ্ৱ্ৱদোষেভ্য এতস্মিন্ জনে ৱিশ্ৱাসিনঃ সৰ্ৱ্ৱে মুক্তা ভৱিষ্যন্তীতি যুষ্মাভি ৰ্জ্ঞাযতাং| ");
INSERT INTO sanasm_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","অপৰঞ্চ| অৱজ্ঞাকাৰিণো লোকাশ্চক্ষুৰুন্মীল্য পশ্যত| তথৈৱাসম্ভৱং জ্ঞাৎৱা স্যাত যূযং ৱিলজ্জিতাঃ| যতো যুষ্মাসু তিষ্ঠৎসু কৰিষ্যে কৰ্ম্ম তাদৃশং| যেনৈৱ তস্য ৱৃত্তান্তে যুষ্মভ্যং কথিতেঽপি হি| যূযং ন তন্তু ৱৃত্তান্তং প্ৰত্যেষ্যথ কদাচন|| ");
INSERT INTO sanasm_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","যেযং কথা ভৱিষ্যদ্ৱাদিনাং গ্ৰন্থেষু লিখিতাস্তে সাৱধানা ভৱত স কথা যথা যুষ্মান্ প্ৰতি ন ঘটতে| ");
INSERT INTO sanasm_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","যিহূদীযভজনভৱনান্ নিৰ্গতযোস্তযো ৰ্ভিন্নদেশীযৈ ৰ্ৱক্ষ্যমাণা প্ৰাৰ্থনা কৃতা, আগামিনি ৱিশ্ৰামৱাৰেঽপি কথেযম্ অস্মান্ প্ৰতি প্ৰচাৰিতা ভৱৎৱিতি| ");
INSERT INTO sanasm_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","সভাযা ভঙ্গে সতি বহৱো যিহূদীযলোকা যিহূদীযমতগ্ৰাহিণো ভক্তলোকাশ্চ বৰ্ণব্বাপৌলযোঃ পশ্চাদ্ আগচ্ছন্, তেন তৌ তৈঃ সহ নানাকথাঃ কথযিৎৱেশ্ৱৰানুগ্ৰহাশ্ৰযে স্থাতুং তান্ প্ৰাৱৰ্ত্তযতাং| ");
INSERT INTO sanasm_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","পৰৱিশ্ৰামৱাৰে নগৰস্য প্ৰাযেণ সৰ্ৱ্ৱে লাকা ঈশ্ৱৰীযাং কথাং শ্ৰোতুং মিলিতাঃ, ");
INSERT INTO sanasm_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","কিন্তু যিহূদীযলোকা জননিৱহং ৱিলোক্য ঈৰ্ষ্যযা পৰিপূৰ্ণাঃ সন্তো ৱিপৰীতকথাকথনেনেশ্ৱৰনিন্দযা চ পৌলেনোক্তাং কথাং খণ্ডযিতুং চেষ্টিতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","ততঃ পৌैলবৰ্ণব্বাৱক্ষোভৌ কথিতৱন্তৌ প্ৰথমং যুষ্মাকং সন্নিধাৱীশ্ৱৰীযকথাযাঃ প্ৰচাৰণম্ উচিতমাসীৎ কিন্তুং তদগ্ৰাহ্যৎৱকৰণেন যূযং স্ৱান্ অনন্তাযুষোঽযোগ্যান্ দৰ্শযথ, এতৎকাৰণাদ্ ৱযম্ অন্যদেশীযলোকানাং সমীপং গচ্ছামঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","প্ৰভুৰস্মান্ ইত্থম্ আদিষ্টৱান্ যথা, যাৱচ্চ জগতঃ সীমাং লোকানাং ত্ৰাণকাৰণাৎ| মযান্যদেশমধ্যে ৎৱং স্থাপিতো ভূঃ প্ৰদীপৱৎ|| ");
INSERT INTO sanasm_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","তদা কথামীদৃশীং শ্ৰুৎৱা ভিন্নদেশীযা আহ্লাদিতাঃ সন্তঃ প্ৰভোঃ কথাং ধন্যাং ধন্যাম্ অৱদন্, যাৱন্তো লোকাশ্চ পৰমাযুঃ প্ৰাপ্তিনিমিত্তং নিৰূপিতা আসন্ তেे ৱ্যশ্ৱসন্| ");
INSERT INTO sanasm_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ইত্থং প্ৰভোঃ কথা সৰ্ৱ্ৱেদেশং ৱ্যাপ্নোৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","কিন্তু যিহূদীযা নগৰস্য প্ৰধানপুৰুষান্ সম্মান্যাঃ কথিপযা ভক্তা যোষিতশ্চ কুপ্ৰৱৃত্তিং গ্ৰাহযিৎৱা পৌলবৰ্ণব্বৌ তাডযিৎৱা তস্মাৎ প্ৰদেশাদ্ দূৰীকৃতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","অতঃ কাৰণাৎ তৌ নিজপদধূলীস্তেষাং প্ৰাতিকূল্যেন পাতযিৎৱেेকনিযং নগৰং গতৌ| ");
INSERT INTO sanasm_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","ততঃ শিষ্যগণ আনন্দেন পৱিত্ৰেণাত্মনা চ পৰিপূৰ্ণোভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","তৌ দ্ৱৌ জনৌ যুগপদ্ ইকনিযনগৰস্থযিহূদীযানাং ভজনভৱনং গৎৱা যথা বহৱো যিহূদীযা অন্যদেेশীযলোকাশ্চ ৱ্যশ্ৱসন্ তাদৃশীং কথাং কথিতৱন্তৌ| ");
INSERT INTO sanasm_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","কিন্তু ৱিশ্ৱাসহীনা যিহূদীযা অন্যদেশীযলোকান্ কুপ্ৰৱৃত্তিং গ্ৰাহযিৎৱা ভ্ৰাতৃগণং প্ৰতি তেষাং ৱৈৰং জনিতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","অতঃ স্ৱানুগ্ৰহকথাযাঃ প্ৰমাণং দৎৱা তযো ৰ্হস্তৈ ৰ্বহুলক্ষণম্ অদ্ভুতকৰ্ম্ম চ প্ৰাকাশযদ্ যঃ প্ৰভুস্তস্য কথা অক্ষোভেন প্ৰচাৰ্য্য তৌ তত্ৰ বহুদিনানি সমৱাতিষ্ঠেতাং| ");
INSERT INTO sanasm_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","কিন্তু কিযন্তো লোকা যিহূদীযানাং সপক্ষাঃ কিযন্তো লোকাঃ প্ৰেৰিতানাং সপক্ষা জাতাঃ, অতো নাগৰিকজননিৱহমধ্যে ভিন্নৱাক্যৎৱম্ অভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","অন্যদেশীযা যিহূদীযাস্তেষাম্ অধিপতযশ্চ দৌৰাত্ম্যং কুৎৱা তৌ প্ৰস্তৰৈৰাহন্তুম্ উদ্যতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","তৌ তদ্ৱাৰ্ত্তাং প্ৰাপ্য পলাযিৎৱা লুকাযনিযাদেশস্যান্তৰ্ৱ্ৱৰ্ত্তিলুস্ত্ৰাদৰ্ব্বো ");
INSERT INTO sanasm_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","তৎসমীপস্থদেশঞ্চ গৎৱা তত্ৰ সুসংৱাদং প্ৰচাৰযতাং| ");
INSERT INTO sanasm_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","তত্ৰোভযপাদযোশ্চলনশক্তিহীনো জন্মাৰভ্য খঞ্জঃ কদাপি গমনং নাকৰোৎ এতাদৃশ একো মানুষো লুস্ত্ৰানগৰ উপৱিশ্য পৌলস্য কথাং শ্ৰুতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","এতস্মিন্ সমযে পৌলস্তম্প্ৰতি দৃষ্টিং কৃৎৱা তস্য স্ৱাস্থ্যে ৱিশ্ৱাসং ৱিদিৎৱা প্ৰোচ্চৈঃ কথিতৱান্ ");
INSERT INTO sanasm_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","পদ্ভ্যামুত্তিষ্ঠন্ ঋজু ৰ্ভৱ| ততঃ স উল্লম্ফং কৃৎৱা গমনাগমনে কুতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","তদা লোকাঃ পৌলস্য তৎ কাৰ্য্যং ৱিলোক্য লুকাযনীযভাষযা প্ৰোচ্চৈঃ কথামেতাং কথিতৱন্তঃ, দেৱা মনুষ্যৰূপং ধৃৎৱাস্মাকং সমীপম্ অৱাৰোহন্| ");
INSERT INTO sanasm_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","তে বৰ্ণব্বাং যূপিতৰম্ অৱদন্ পৌলশ্চ মুখ্যো ৱক্তা তস্মাৎ তং মৰ্কুৰিযম্ অৱদন্| ");
INSERT INTO sanasm_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","তস্য নগৰস্য সম্মুখে স্থাপিতস্য যূপিতৰৱিগ্ৰহস্য যাজকো ৱৃষান্ পুষ্পমালাশ্চ দ্ৱাৰসমীপম্ আনীয লোকৈঃ সৰ্দ্ধং তাৱুদ্দিশ্য সমুৎসৃজ্য দাতুম্ উদ্যতঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","তদ্ৱাৰ্ত্তাং শ্ৰুৎৱা বৰ্ণব্বাপৌলৌ স্ৱীযৱস্ত্ৰাণি ছিৎৱা লোকানাং মধ্যং ৱেগেন প্ৰৱিশ্য প্ৰোচ্চৈঃ কথিতৱন্তৌ, ");
INSERT INTO sanasm_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","হে মহেচ্ছাঃ কুত এতাদৃশং কৰ্ম্ম কুৰুথ? আৱামপি যুষ্মাদৃশৌ সুখদুঃখভোগিনৌ মনুষ্যৌ, যুযম্ এতাঃ সৰ্ৱ্ৱা ৱৃথাকল্পনাঃ পৰিত্যজ্য যথা গগণৱসুন্ধৰাজলনিধীনাং তন্মধ্যস্থানাং সৰ্ৱ্ৱেষাঞ্চ স্ৰষ্টাৰমমৰম্ ঈশ্ৱৰং প্ৰতি পৰাৱৰ্ত্তধ্ৱে তদৰ্থম্ আৱাং যুষ্মাকং সন্নিধৌ সুসংৱাদং প্ৰচাৰযাৱঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","স ঈশ্ৱৰঃ পূৰ্ৱ্ৱকালে সৰ্ৱ্ৱদেশীযলোকান্ স্ৱস্ৱমাৰ্গে চলিতুমনুমতিং দত্তৱান্, ");
INSERT INTO sanasm_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","তথাপি আকাশাৎ তোযৱৰ্ষণেন নানাপ্ৰকাৰশস্যোৎপত্যা চ যুষ্মাকং হিতৈষী সন্ ভক্ষ্যৈৰাননদেন চ যুষ্মাকম্ অন্তঃকৰণানি তৰ্পযন্ তানি দানানি নিজসাক্ষিস্ৱৰূপাণি স্থপিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","কিন্তু তাদৃশাযাং কথাযাং কথিতাযামপি তযোঃ সমীপ উৎসৰ্জনাৎ লোকনিৱহং প্ৰাযেণ নিৱৰ্ত্তযিতুং নাশক্নুতাম্| ");
INSERT INTO sanasm_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","আন্তিযখিযা-ইকনিযনগৰাভ্যাং কতিপযযিহূদীযলোকা আগত্য লোকান্ প্ৰাৱৰ্ত্তযন্ত তস্মাৎ তৈ পৌলং প্ৰস্তৰৈৰাঘ্নন্ তেন স মৃত ইতি ৱিজ্ঞায নগৰস্য বহিস্তম্ আকৃষ্য নীতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","কিন্তু শিষ্যগণে তস্য চতুৰ্দিশি তিষ্ঠতি সতি স স্ৱযম্ উত্থায পুনৰপি নগৰমধ্যং প্ৰাৱিশৎ তৎপৰেঽহনি বৰ্ণব্বাসহিতো দৰ্ব্বীনগৰং গতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","তত্ৰ সুসংৱাদং প্ৰচাৰ্য্য বহুলোকান্ শিষ্যান্ কৃৎৱা তৌ লুস্ত্ৰাম্ ইকনিযম্ আন্তিযখিযাঞ্চ পৰাৱৃত্য গতৌ| ");
INSERT INTO sanasm_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","বহুদুঃখানি ভুক্ত্ৱাপীশ্ৱৰৰাজ্যং প্ৰৱেষ্টৱ্যম্ ইতি কাৰণাদ্ ধৰ্ম্মমাৰ্গে স্থাতুং ৱিনযং কৃৎৱা শিষ্যগণস্য মনঃস্থৈৰ্য্যম্ অকুৰুতাং| ");
INSERT INTO sanasm_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","মণ্ডলীনাং প্ৰাচীনৱৰ্গান্ নিযুজ্য প্ৰাৰ্থনোপৱাসৌ কৃৎৱা যৎপ্ৰভৌ তে ৱ্যশ্ৱসন্ তস্য হস্তে তান্ সমৰ্প্য ");
INSERT INTO sanasm_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","পিসিদিযামধ্যেন পাম্ফুলিযাদেশং গতৱন্তৌ| ");
INSERT INTO sanasm_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","পশ্চাৎ পৰ্গানগৰং গৎৱা সুসংৱাদং প্ৰচাৰ্য্য অত্তালিযানগৰং প্ৰস্থিতৱন্তৌ| ");
INSERT INTO sanasm_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","তস্মাৎ সমুদ্ৰপথেন গৎৱা তাভ্যাং যৎ কৰ্ম্ম সম্পন্নং তৎকৰ্ম্ম সাধযিতুং যন্নগৰে দযালোৰীশ্ৱৰস্য হস্তে সমৰ্পিতৌ জাতৌ তদ্ আন্তিযখিযানগৰং গতৱন্তা| ");
INSERT INTO sanasm_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","তত্ৰোপস্থায তন্নগৰস্থমণ্ডলীং সংগৃহ্য স্ৱাভ্যাম ঈশ্ৱৰো যদ্যৎ কৰ্ম্মকৰোৎ তথা যেন প্ৰকাৰেণ ভিন্নদেশীযলোকান্ প্ৰতি ৱিশ্ৱাসৰূপদ্ৱাৰম্ অমোচযদ্ এতান্ সৰ্ৱ্ৱৱৃত্তান্তান্ তান্ জ্ঞাপিতৱন্তৌ| ");
INSERT INTO sanasm_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ততস্তৌ শিৰ্য্যৈঃ সাৰ্দ্ধং তত্ৰ বহুদিনানি ন্যৱসতাম্| ");
INSERT INTO sanasm_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","যিহূদাদেশাৎ কিযন্তো জনা আগত্য ভ্ৰাতৃগণমিত্থং শিক্ষিতৱন্তো মূসাৱ্যৱস্থযা যদি যুষ্মাকং ৎৱক্ছেদো ন ভৱতি তৰ্হি যূযং পৰিত্ৰাণং প্ৰাপ্তুং ন শক্ষ্যথ| ");
INSERT INTO sanasm_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","পৌলবৰ্ণব্বৌ তৈঃ সহ বহূন্ ৱিচাৰান্ ৱিৱাদাংশ্চ কৃতৱন্তৌ, ততো মণ্ডলীযনোকা এতস্যাঃ কথাযাস্তত্ত্ৱং জ্ঞাতুং যিৰূশালম্নগৰস্থান্ প্ৰেৰিতান্ প্ৰাচীনাংশ্চ প্ৰতি পৌলবৰ্ণব্বাপ্ৰভৃতীন্ কতিপযজনান্ প্ৰেষযিতুং নিশ্চযং কৃতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","তে মণ্ডল্যা প্ৰেৰিতাঃ সন্তঃ ফৈণীকীশোমিৰোন্দেশাভ্যাং গৎৱা ভিন্নদেশীযানাং মনঃপৰিৱৰ্ত্তনস্য ৱাৰ্ত্তযা ভ্ৰাতৃণাং পৰমাহ্লাদম্ অজনযন্| ");
INSERT INTO sanasm_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","যিৰূশালম্যুপস্থায প্ৰেৰিতগণেন লোকপ্ৰাচীনগণেন সমাজেন চ সমুপগৃহীতাঃ সন্তঃ স্ৱৈৰীশ্ৱৰো যানি কৰ্ম্মাণি কৃতৱান্ তেষাং সৰ্ৱ্ৱৱৃত্তান্তান্ তেষাং সমক্ষম্ অকথযন্| ");
INSERT INTO sanasm_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","কিন্তু ৱিশ্ৱাসিনঃ কিযন্তঃ ফিৰূশিমতগ্ৰাহিণো লোকা উত্থায কথামেতাং কথিতৱন্তো ভিন্নদেশীযানাং ৎৱক্ছেদং কৰ্ত্তুং মূসাৱ্যৱস্থাং পালযিতুঞ্চ সমাদেষ্টৱ্যম্| ");
INSERT INTO sanasm_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","ততঃ প্ৰেৰিতা লোকপ্ৰাচীনাশ্চ তস্য ৱিৱেচনাং কৰ্ত্তুং সভাযাং স্থিতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","বহুৱিচাৰেষু জাতষু পিতৰ উত্থায কথিতৱান্, হে ভ্ৰাতৰো যথা ভিন্নদেশীযলোকা মম মুখাৎ সুসংৱাদং শ্ৰুৎৱা ৱিশ্ৱসন্তি তদৰ্থং বহুদিনাৎ পূৰ্ৱ্ৱম্ ঈশ্ৱৰোস্মাকং মধ্যে মাং ৱৃৎৱা নিযুক্তৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","অন্তৰ্য্যামীশ্ৱৰো যথাস্মভ্যং তথা ভিন্নদেশীযেভ্যঃ পৱিত্ৰমাত্মানং প্ৰদায ৱিশ্ৱাসেন তেষাম্ অন্তঃকৰণানি পৱিত্ৰাণি কৃৎৱা ");
INSERT INTO sanasm_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","তেষাম্ অস্মাকঞ্চ মধ্যে কিমপি ৱিশেষং ন স্থাপযিৎৱা তানধি স্ৱযং প্ৰমাণং দত্তৱান্ ইতি যূযং জানীথ| ");
INSERT INTO sanasm_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","অতএৱাস্মাকং পূৰ্ৱ্ৱপুৰুষা ৱযঞ্চ স্ৱযং যদ্যুগস্য ভাৰং সোঢুং ন শক্তাঃ সম্প্ৰতি তং শিষ্যগণস্য স্কন্ধেষু ন্যসিতুং কুত ঈশ্ৱৰস্য পৰীক্ষাং কৰিষ্যথ? ");
INSERT INTO sanasm_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","প্ৰভো ৰ্যীশুখ্ৰীষ্টস্যানুগ্ৰহেণ তে যথা ৱযমপি তথা পৰিত্ৰাণং প্ৰাপ্তুম্ আশাং কুৰ্ম্মঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","অনন্তৰং বৰ্ণব্বাপৌলাভ্যাম্ ঈশ্ৱৰো ভিন্নদেশীযানাং মধ্যে যদ্যদ্ আশ্চৰ্য্যম্ অদ্ভুতঞ্চ কৰ্ম্ম কৃতৱান্ তদ্ৱৃত্তান্তং তৌ স্ৱমুখাভ্যাম্ অৱৰ্ণযতাং সভাস্থাঃ সৰ্ৱ্ৱে নীৰৱাঃ সন্তঃ শ্ৰুতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","তযোঃ কথাযাং সমাপ্তাযাং সত্যাং যাকূব্ কথযিতুম্ আৰব্ধৱান্ ");
INSERT INTO sanasm_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","হে ভ্ৰাতৰো মম কথাযাম্ মনো নিধত্ত| ঈশ্ৱৰঃ স্ৱনামাৰ্থং ভিন্নদেশীযলোকানাম্ মধ্যাদ্ একং লোকসংঘং গ্ৰহীতুং মতিং কৃৎৱা যেন প্ৰকাৰেণ প্ৰথমং তান্ প্ৰতি কৃপাৱলেকনং কৃতৱান্ তং শিমোন্ ৱৰ্ণিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ভৱিষ্যদ্ৱাদিভিৰুক্তানি যানি ৱাক্যানি তৈঃ সাৰ্দ্ধম্ এতস্যৈক্যং ভৱতি যথা লিখিতমাস্তে| ");
INSERT INTO sanasm_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","সৰ্ৱ্ৱেষাং কৰ্ম্মণাং যস্তু সাধকঃ পৰমেশ্ৱৰঃ| স এৱেদং ৱদেদ্ৱাক্যং শেষাঃ সকলমানৱাঃ| ভিন্নদেশীযলোকাশ্চ যাৱন্তো মম নামতঃ| ভৱন্তি হি সুৱিখ্যাতাস্তে যথা পৰমেশিতুঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","তৎৱং সম্যক্ সমীহন্তে তন্নিমিত্তমহং কিল| পৰাৱৃত্য সমাগত্য দাযূদঃ পতিতং পুনঃ| দূষ্যমুত্থাপযিষ্যামি তদীযং সৰ্ৱ্ৱৱস্তু চ| পতিতং পুনৰুথাপ্য সজ্জযিষ্যামি সৰ্ৱ্ৱথা|| ");
INSERT INTO sanasm_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","আ প্ৰথমাদ্ ঈশ্ৱৰঃ স্ৱীযানি সৰ্ৱ্ৱকৰ্ম্মাণি জানাতি| ");
INSERT INTO sanasm_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","অতএৱ মম নিৱেদনমিদং ভিন্নদেশীযলোকানাং মধ্যে যে জনা ঈশ্ৱৰং প্ৰতি পৰাৱৰ্ত্তন্ত তেষামুপৰি অন্যং কমপি ভাৰং ন ন্যস্য ");
INSERT INTO sanasm_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","দেৱতাপ্ৰসাদাশুচিভক্ষ্যং ৱ্যভিচাৰকৰ্ম্ম কণ্ঠসম্পীডনমাৰিতপ্ৰাণিভক্ষ্যং ৰক্তভক্ষ্যঞ্চ এতানি পৰিত্যক্তুং লিখামঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","যতঃ পূৰ্ৱ্ৱকালতো মূসাৱ্যৱস্থাপ্ৰচাৰিণো লোকা নগৰে নগৰে সন্তি প্ৰতিৱিশ্ৰামৱাৰঞ্চ ভজনভৱনে তস্যাঃ পাঠো ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","ততঃ পৰং প্ৰেৰিতগণো লোকপ্ৰাচীনগণঃ সৰ্ৱ্ৱা মণ্ডলী চ স্ৱেষাং মধ্যে বৰ্শব্বা নাম্না ৱিখ্যাতো মনোনীতৌ কৃৎৱা পৌলবৰ্ণব্বাভ্যাং সাৰ্দ্ধম্ আন্তিযখিযানগৰং প্ৰতি প্ৰেষণম্ উচিতং বুদ্ধ্ৱা তাভ্যাং পত্ৰং প্ৰৈষযন্| ");
INSERT INTO sanasm_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","তস্মিন্ পত্ৰে লিখিতমিংদ, আন্তিযখিযা-সুৰিযা-কিলিকিযাদেশস্থভিন্নদেশীযভ্ৰাতৃগণায প্ৰেৰিতগণস্য লোকপ্ৰাচীনগণস্য ভ্ৰাতৃগণস্য চ নমস্কাৰঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","ৱিশেষতোঽস্মাকম্ আজ্ঞাম্ অপ্ৰাপ্যাপি কিযন্তো জনা অস্মাকং মধ্যাদ্ গৎৱা ৎৱক্ছেদো মূসাৱ্যৱস্থা চ পালযিতৱ্যাৱিতি যুষ্মান্ শিক্ষযিৎৱা যুষ্মাকং মনসামস্থৈৰ্য্যং কৃৎৱা যুষ্মান্ সসন্দেহান্ অকুৰ্ৱ্ৱন্ এতাং কথাং ৱযম্ অশৃন্ম| ");
INSERT INTO sanasm_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","তৎকাৰণাদ্ ৱযম্ একমন্ত্ৰণাঃ সন্তঃ সভাযাং স্থিৎৱা প্ৰভো ৰ্যীশুখ্ৰীষ্টস্য নামনিমিত্তং মৃত্যুমুখগতাভ্যামস্মাকং ");
INSERT INTO sanasm_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","প্ৰিযবৰ্ণব্বাপৌলাভ্যাং সাৰ্দ্ধং মনোনীতলোকানাং কেষাঞ্চিদ্ যুষ্মাকং সন্নিধৌ প্ৰেষণম্ উচিতং বুদ্ধৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","অতো যিহূদাসীলৌ যুষ্মান্ প্ৰতি প্ৰেষিতৱন্তঃ, এতযো ৰ্মুখাভ্যাং সৰ্ৱ্ৱাং কথাং জ্ঞাস্যথ| ");
INSERT INTO sanasm_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","দেৱতাপ্ৰসাদভক্ষ্যং ৰক্তভক্ষ্যং গলপীডনমাৰিতপ্ৰাণিভক্ষ্যং ৱ্যভিচাৰকৰ্ম্ম চেমানি সৰ্ৱ্ৱাণি যুষ্মাভিস্ত্যাজ্যানি; এতৎপ্ৰযোজনীযাজ্ঞাৱ্যতিৰেকেন যুষ্মাকম্ উপৰি ভাৰমন্যং ন ন্যসিতুং পৱিত্ৰস্যাত্মনোঽস্মাকঞ্চ উচিতজ্ঞানম্ অভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","অতএৱ তেভ্যঃ সৰ্ৱ্ৱেভ্যঃ স্ৱেষু ৰক্ষিতেষু যূযং ভদ্ৰং কৰ্ম্ম কৰিষ্যথ| যুষ্মাকং মঙ্গলং ভূযাৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","তেे ৱিসৃষ্টাঃ সন্ত আন্তিযখিযানগৰ উপস্থায লোকনিৱহং সংগৃহ্য পত্ৰম্ অদদন্| ");
INSERT INTO sanasm_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ততস্তে তৎপত্ৰং পঠিৎৱা সান্ত্ৱনাং প্ৰাপ্য সানন্দা অভৱন্| ");
INSERT INTO sanasm_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","যিহূদাসীলৌ চ স্ৱযং প্ৰচাৰকৌ ভূৎৱা ভ্ৰাতৃগণং নানোপদিশ্য তান্ সুস্থিৰান্ অকুৰুতাম্| ");
INSERT INTO sanasm_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ইত্থং তৌ তত্ৰ তৈঃ সাকং কতিপযদিনানি যাপযিৎৱা পশ্চাৎ প্ৰেৰিতানাং সমীপে প্ৰত্যাগমনাৰ্থং তেষাং সন্নিধেঃ কল্যাণেন ৱিসৃষ্টাৱভৱতাং| ");
INSERT INTO sanasm_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","কিন্তু সীলস্তত্ৰ স্থাতুং ৱাঞ্ছিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","অপৰং পৌলবৰ্ণব্বৌ বহৱঃ শিষ্যাশ্চ লোকান্ উপদিশ্য প্ৰভোঃ সুসংৱাদং প্ৰচাৰযন্ত আন্তিযখিযাযাং কালং যাপিতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","কতিপযদিনেষু গতেষু পৌলো বৰ্ণব্বাম্ অৱদৎ আগচ্ছাৱাং যেষু নগৰেষ্ৱীশ্ৱৰস্য সুসংৱাদং প্ৰচাৰিতৱন্তৌ তানি সৰ্ৱ্ৱনগৰাণি পুনৰ্গৎৱা ভ্ৰাতৰঃ কীদৃশাঃ সন্তীতি দ্ৰষ্টুং তান্ সাক্ষাৎ কুৰ্ৱ্ৱঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","তেন মাৰ্কনাম্না ৱিখ্যাতং যোহনং সঙ্গিনং কৰ্ত্তুং বৰ্ণব্বা মতিমকৰোৎ, ");
INSERT INTO sanasm_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","কিন্তু স পূৰ্ৱ্ৱং তাভ্যাং সহ কাৰ্য্যাৰ্থং ন গৎৱা পাম্ফূলিযাদেশে তৌ ত্যক্তৱান্ তৎকাৰণাৎ পৌলস্তং সঙ্গিনং কৰ্ত্তুম্ অনুচিতং জ্ঞাতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ইত্থং তযোৰতিশযৱিৰোধস্যোপস্থিতৎৱাৎ তৌ পৰস্পৰং পৃথগভৱতাং ততো বৰ্ণব্বা মাৰ্কং গৃহীৎৱা পোতেন কুপ্ৰোপদ্ৱীপং গতৱান্; ");
INSERT INTO sanasm_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","কিন্তু পৌলঃ সীলং মনোনীতং কৃৎৱা ভ্ৰাতৃভিৰীশ্ৱৰানুগ্ৰহে সমৰ্পিতঃ সন্ প্ৰস্থায ");
INSERT INTO sanasm_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","সুৰিযাকিলিকিযাদেশাভ্যাং মণ্ডলীঃ স্থিৰীকুৰ্ৱ্ৱন্ অগচ্ছৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","পৌলো দৰ্ব্বীলুস্ত্ৰানগৰযোৰুপস্থিতোভৱৎ তত্ৰ তীমথিযনামা শিষ্য এক আসীৎ; স ৱিশ্ৱাসিন্যা যিহূদীযাযা যোষিতো গৰ্ব্ভজাতঃ কিন্তু তস্য পিতান্যদেশীযলোকঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","স জনো লুস্ত্ৰা-ইকনিযনগৰস্থানাং ভ্ৰাতৃণাং সমীপেপি সুখ্যাতিমান্ আসীৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","পৌলস্তং স্ৱসঙ্গিনং কৰ্ত্তুং মতিং কৃৎৱা তং গৃহীৎৱা তদ্দেশনিৱাসিনাং যিহূদীযানাম্ অনুৰোধাৎ তস্য ৎৱক্ছেদং কৃতৱান্ যতস্তস্য পিতা ভিন্নদেশীযলোক ইতি সৰ্ৱ্ৱৈৰজ্ঞাযত| ");
INSERT INTO sanasm_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","ততঃ পৰং তে নগৰে নগৰে ভ্ৰমিৎৱা যিৰূশালমস্থৈঃ প্ৰেৰিতৈ ৰ্লোকপ্ৰাচীনৈশ্চ নিৰূপিতং যদ্ ৱ্যৱস্থাপত্ৰং তদনুসাৰেণাচৰিতুং লোকেভ্যস্তদ্ দত্তৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","তেনৈৱ সৰ্ৱ্ৱে ধৰ্ম্মসমাজাঃ খ্ৰীষ্টধৰ্ম্মে সুস্থিৰাঃ সন্তঃ প্ৰতিদিনং ৱৰ্দ্ধিতা অভৱন্| ");
INSERT INTO sanasm_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","তেষু ফ্ৰুগিযাগালাতিযাদেশমধ্যেন গতেষু সৎসু পৱিত্ৰ আত্মা তান্ আশিযাদেশে কথাং প্ৰকাশযিতুং প্ৰতিষিদ্ধৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","তথা মুসিযাদেশ উপস্থায বিথুনিযাং গন্তুং তৈৰুদ্যোগে কৃতে আত্মা তান্ নান্ৱমন্যত| ");
INSERT INTO sanasm_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","তস্মাৎ তে মুসিযাদেশং পৰিত্যজ্য ত্ৰোযানগৰং গৎৱা সমুপস্থিতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ৰাত্ৰৌ পৌলঃ স্ৱপ্নে দৃষ্টৱান্ একো মাকিদনিযলোকস্তিষ্ঠন্ ৱিনযং কৃৎৱা তস্মৈ কথযতি, মাকিদনিযাদেশম্ আগত্যাস্মান্ উপকুৰ্ৱ্ৱিতি| ");
INSERT INTO sanasm_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","তস্যেত্থং স্ৱপ্নদৰ্শনাৎ প্ৰভুস্তদ্দেশীযলোকান্ প্ৰতি সুসংৱাদং প্ৰচাৰযিতুম্ অস্মান্ আহূযতীতি নিশ্চিতং বুদ্ধ্ৱা ৱযং তূৰ্ণং মাকিদনিযাদেশং গন্তুম্ উদ্যোগম্ অকুৰ্ম্ম| ");
INSERT INTO sanasm_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","ততঃ পৰং ৱযং ত্ৰোযানগৰাদ্ প্ৰস্থায ঋজুমাৰ্গেণ সামথ্ৰাকিযোপদ্ৱীপেন গৎৱা পৰেঽহনি নিযাপলিনগৰ উপস্থিতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","তস্মাদ্ গৎৱা মাকিদনিযান্তৰ্ৱ্ৱৰ্ত্তি ৰোমীযৱসতিস্থানং যৎ ফিলিপীনামপ্ৰধাননগৰং তত্ৰোপস্থায কতিপযদিনানি তত্ৰ স্থিতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","ৱিশ্ৰামৱাৰে নগৰাদ্ বহি ৰ্গৎৱা নদীতটে যত্ৰ প্ৰাৰ্থনাচাৰ আসীৎ তত্ৰোপৱিশ্য সমাগতা নাৰীঃ প্ৰতি কথাং প্ৰাচাৰযাম| ");
INSERT INTO sanasm_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","ততঃ থুযাতীৰানগৰীযা ধূষৰাম্বৰৱিক্ৰাযিণী লুদিযানামিকা যা ঈশ্ৱৰসেৱিকা যোষিৎ শ্ৰোত্ৰীণাং মধ্য আসীৎ তযা পৌলোক্তৱাক্যানি যদ্ গৃহ্যন্তে তদৰ্থং প্ৰভুস্তস্যা মনোদ্ৱাৰং মুক্তৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","অতঃ সা যোষিৎ সপৰিৱাৰা মজ্জিতা সতী ৱিনযং কৃৎৱা কথিতৱতী, যুষ্মাকং ৱিচাৰাদ্ যদি প্ৰভৌ ৱিশ্ৱাসিনী জাতাহং তৰ্হি মম গৃহম্ আগত্য তিষ্ঠত| ইত্থং সা যত্নেনাস্মান্ অস্থাপযৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","যস্যা গণনযা তদধিপতীনাং বহুধনোপাৰ্জনং জাতং তাদৃশী গণকভূতগ্ৰস্তা কাচন দাসী প্ৰাৰ্থনাস্থানগমনকাল আগত্যাস্মান্ সাক্ষাৎ কৃতৱতী| ");
INSERT INTO sanasm_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","সাস্মাকং পৌলস্য চ পশ্চাদ্ এত্য প্ৰোচ্চৈঃ কথামিমাং কথিতৱতী, মনুষ্যা এতে সৰ্ৱ্ৱোপৰিস্থস্যেশ্ৱৰস্য সেৱকাঃ সন্তোঽস্মান্ প্ৰতি পৰিত্ৰাণস্য মাৰ্গং প্ৰকাশযন্তি| ");
INSERT INTO sanasm_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","সা কন্যা বহুদিনানি তাদৃশম্ অকৰোৎ তস্মাৎ পৌলো দুঃখিতঃ সন্ মুখং পৰাৱৰ্ত্য তং ভূতমৱদদ্, অহং যীশুখ্ৰীষ্টস্য নাম্না ৎৱামাজ্ঞাপযামি ৎৱমস্যা বহিৰ্গচ্ছ; তেনৈৱ তৎক্ষণাৎ স ভূতস্তস্যা বহিৰ্গতঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","ততঃ স্ৱেষাং লাভস্য প্ৰত্যাশা ৱিফলা জাতেতি ৱিলোক্য তস্যাঃ প্ৰভৱঃ পৌলং সীলঞ্চ ধৃৎৱাকৃষ্য ৱিচাৰস্থানেঽধিপতীনাং সমীপম্ আনযন্| ");
INSERT INTO sanasm_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ততঃ শাসকানাং নিকটং নীৎৱা ৰোমিলোকা ৱযম্ অস্মাকং যদ্ ৱ্যৱহৰণং গ্ৰহীতুম্ আচৰিতুঞ্চ নিষিদ্ধং, ");
INSERT INTO sanasm_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ইমে যিহূদীযলোকাঃ সন্তোপি তদেৱ শিক্ষযিৎৱা নগৰেঽস্মাকম্ অতীৱ কলহং কুৰ্ৱ্ৱন্তি, ");
INSERT INTO sanasm_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","ইতি কথিতে সতি লোকনিৱহস্তযোঃ প্ৰাতিকূল্যেনোদতিষ্ঠৎ তথা শাসকাস্তযো ৰ্ৱস্ত্ৰাণি ছিৎৱা ৱেত্ৰাঘাতং কৰ্ত্তুম্ আজ্ঞাপযন্| ");
INSERT INTO sanasm_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","অপৰং তে তৌ বহু প্ৰহাৰ্য্য ৎৱমেতৌ কাৰাং নীৎৱা সাৱধানং ৰক্ষযেতি কাৰাৰক্ষকম্ আদিশন্| ");
INSERT INTO sanasm_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ইত্থম্ আজ্ঞাং প্ৰাপ্য স তাৱভ্যন্তৰস্থকাৰাং নীৎৱা পাদেষু পাদপাশীভি ৰ্বদ্ধ্ৱা স্থাপিতাৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","অথ নিশীথসমযে পৌলসীলাৱীশ্ৱৰমুদ্দিশ্য প্ৰাথনাং গানঞ্চ কৃতৱন্তৌ, কাৰাস্থিতা লোকাশ্চ তদশৃণ্ৱন্ ");
INSERT INTO sanasm_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","তদাকস্মাৎ মহান্ ভূমিকম্পোঽভৱৎ তেন ভিত্তিমূলেন সহ কাৰা কম্পিতাভূৎ তৎক্ষণাৎ সৰ্ৱ্ৱাণি দ্ৱাৰাণি মুক্তানি জাতানি সৰ্ৱ্ৱেষাং বন্ধনানি চ মুক্তানি| ");
INSERT INTO sanasm_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","অতএৱ কাৰাৰক্ষকো নিদ্ৰাতো জাগৰিৎৱা কাৰাযা দ্ৱাৰাণি মুক্তানি দৃষ্ট্ৱা বন্দিলোকাঃ পলাযিতা ইত্যনুমায কোষাৎ খঙ্গং বহিঃ কৃৎৱাত্মঘাতং কৰ্ত্তুম্ উদ্যতঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","কিন্তু পৌলঃ প্ৰোচ্চৈস্তমাহূয কথিতৱান্ পশ্য ৱযং সৰ্ৱ্ৱেঽত্ৰাস্মহে, ৎৱং নিজপ্ৰাণহিংসাং মাকাৰ্ষীঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","তদা প্ৰদীপম্ আনেতুম্ উক্ত্ৱা স কম্পমানঃ সন্ উল্লম্প্যাভ্যন্তৰম্ আগত্য পৌলসীলযোঃ পাদেষু পতিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","পশ্চাৎ স তৌ বহিৰানীয পৃষ্টৱান্ হে মহেচ্ছৌ পৰিত্ৰাণং প্ৰাপ্তুং মযা কিং কৰ্ত্তৱ্যং? ");
INSERT INTO sanasm_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","পশ্চাৎ তৌ স্ৱগৃহমানীয তযোঃ সম্মুখে খাদ্যদ্ৰৱ্যাণি স্থাপিতৱান্ তথা স স্ৱযং তদীযাঃ সৰ্ৱ্ৱে পৰিৱাৰাশ্চেশ্ৱৰে ৱিশ্ৱসন্তঃ সানন্দিতা অভৱন্| ");
INSERT INTO sanasm_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","তস্মৈ তস্য গৃহস্থিতসৰ্ৱ্ৱলোকেভ্যশ্চ প্ৰভোঃ কথাং কথিতৱন্তৌ| ");
INSERT INTO sanasm_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","তথা ৰাত্ৰেস্তস্মিন্নেৱ দণ্ডে স তৌ গৃহীৎৱা তযোঃ প্ৰহাৰাণাং ক্ষতানি প্ৰক্ষালিতৱান্ ততঃ স স্ৱযং তস্য সৰ্ৱ্ৱে পৰিজনাশ্চ মজ্জিতা অভৱন্| ");
INSERT INTO sanasm_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","পশ্চাৎ তৌ স্ৱগৃহমানীয তযোঃ সম্মুখে খাদ্যদ্ৰৱ্যাণি স্থাপিতৱান্ তথা স স্ৱযং তদীযাঃ সৰ্ৱ্ৱে পৰিৱাৰাশ্চেশ্ৱৰে ৱিশ্ৱসন্তঃ সানন্দিতা অভৱন্| ");
INSERT INTO sanasm_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","দিন উপস্থিতে তৌ লোকৌ মোচযেতি কথাং কথযিতুং শাসকাঃ পদাতিগণং প্ৰেষিতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","ততঃ কাৰাৰক্ষকঃ পৌলায তাং ৱাৰ্ত্তাং কথিতৱান্ যুৱাং ত্যাজযিতুং শাসকা লোকান প্ৰেষিতৱন্ত ইদানীং যুৱাং বহি ৰ্ভূৎৱা কুশলেন প্ৰতিষ্ঠেতাং| ");
INSERT INTO sanasm_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","কিন্তু পৌলস্তান্ অৱদৎ ৰোমিলোকযোৰাৱযোঃ কমপি দোষম্ ন নিশ্চিত্য সৰ্ৱ্ৱেষাং সমক্ষম্ আৱাং কশযা তাডযিৎৱা কাৰাযাং বদ্ধৱন্ত ইদানীং কিমাৱাং গুপ্তং ৱিস্ত্ৰক্ষ্যন্তি? তন্ন ভৱিষ্যতি, স্ৱযমাগত্যাৱাং বহিঃ কৃৎৱা নযন্তু| ");
INSERT INTO sanasm_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","তদা পদাতিভিঃ শাসকেভ্য এতদ্ৱাৰ্ত্তাযাং কথিতাযাং তৌ ৰোমিলোকাৱিতি কথাং শ্ৰুৎৱা তে ভীতাঃ ");
INSERT INTO sanasm_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","সন্তস্তযোঃ সন্নিধিমাগত্য ৱিনযম্ অকুৰ্ৱ্ৱন্ অপৰং বহিঃ কৃৎৱা নগৰাৎ প্ৰস্থাতুং প্ৰাৰ্থিতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ততস্তৌ কাৰাযা নিৰ্গত্য লুদিযাযা গৃহং গতৱন্তৌ তত্ৰ ভ্ৰাতৃগণং সাক্ষাৎকৃত্য তান্ সান্ত্ৱযিৎৱা তস্মাৎ স্থানাৎ প্ৰস্থিতৌ| ");
INSERT INTO sanasm_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","পৌলসীলৌ আম্ফিপল্যাপল্লোনিযানগৰাভ্যাং গৎৱা যত্ৰ যিহূদীযানাং ভজনভৱনমেকম্ আস্তে তত্ৰ থিষলনীকীনগৰ উপস্থিতৌ| ");
INSERT INTO sanasm_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","তদা পৌলঃ স্ৱাচাৰানুসাৰেণ তেষাং সমীপং গৎৱা ৱিশ্ৰামৱাৰত্ৰযে তৈঃ সাৰ্দ্ধং ধৰ্ম্মপুস্তকীযকথাযা ৱিচাৰং কৃতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ফলতঃ খ্ৰীষ্টেন দুঃখভোগঃ কৰ্ত্তৱ্যঃ শ্মশানদুত্থানঞ্চ কৰ্ত্তৱ্যং যুষ্মাকং সন্নিধৌ যস্য যীশোঃ প্ৰস্তাৱং কৰোমি স ঈশ্ৱৰেণাভিষিক্তঃ স এতাঃ কথাঃ প্ৰকাশ্য প্ৰমাণং দৎৱা স্থিৰীকৃতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","তস্মাৎ তেষাং কতিপযজনা অন্যদেশীযা বহৱো ভক্তলোকা বহ্যঃ প্ৰধাননাৰ্য্যশ্চ ৱিশ্ৱস্য পৌলসীলযোঃ পশ্চাদ্গামিনো জাতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","কিন্তু ৱিশ্ৱাসহীনা যিহূদীযলোকা ঈৰ্ষ্যযা পৰিপূৰ্ণাঃ সন্তো হটট্স্য কতিনযলম্পটলোকান্ সঙ্গিনঃ কৃৎৱা জনতযা নগৰমধ্যে মহাকলহং কৃৎৱা যাসোনো গৃহম্ আক্ৰম্য প্ৰেৰিতান্ ধৃৎৱা লোকনিৱহস্য সমীপম্ আনেতুং চেষ্টিতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","তেষামুদ্দেশম্ অপ্ৰাপ্য চ যাসোনং কতিপযান্ ভ্ৰাতৃংশ্চ ধৃৎৱা নগৰাধিপতীনাং নিকটমানীয প্ৰোচ্চৈঃ কথিতৱন্তো যে মনুষ্যা জগদুদ্ৱাটিতৱন্তস্তে ঽত্ৰাপ্যুপস্থিতাঃ সন্তি, ");
INSERT INTO sanasm_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","এষ যাসোন্ আতিথ্যং কৃৎৱা তান্ গৃহীতৱান্| যীশুনামক একো ৰাজস্তীতি কথযন্তস্তে কৈসৰস্যাজ্ঞাৱিৰুদ্ধং কৰ্ম্ম কুৰ্ৱ্ৱতি| ");
INSERT INTO sanasm_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","তেষাং কথামিমাং শ্ৰুৎৱা লোকনিৱহো নগৰাধিপতযশ্চ সমুদ্ৱিগ্না অভৱন্| ");
INSERT INTO sanasm_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","তদা যাসোনস্তদন্যেষাঞ্চ ধনদণ্ডং গৃহীৎৱা তান্ পৰিত্যক্তৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","ততঃ পৰং ভ্ৰাতৃগণো ৰজন্যাং পৌলসীলৌ শীঘ্ৰং বিৰযানগৰং প্ৰেষিতৱান্ তৌ তত্ৰোপস্থায যিহূদীযানাং ভজনভৱনং গতৱন্তৌ| ");
INSERT INTO sanasm_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","তত্ৰস্থা লোকাঃ থিষলনীকীস্থলোকেভ্যো মহাত্মান আসন্ যত ইত্থং ভৱতি ন ৱেতি জ্ঞাতুং দিনে দিনে ধৰ্ম্মগ্ৰন্থস্যালোচনাং কৃৎৱা স্ৱৈৰং কথাম্ অগৃহ্লন্| ");
INSERT INTO sanasm_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","তস্মাদ্ অনেকে যিহূদীযা অন্যদেশীযানাং মান্যা স্ত্ৰিযঃ পুৰুষাশ্চানেকে ৱ্যশ্ৱসন্| ");
INSERT INTO sanasm_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","কিন্তু বিৰযানগৰে পৌলেনেশ্ৱৰীযা কথা প্ৰচাৰ্য্যত ইতি থিষলনীকীস্থা যিহূদীযা জ্ঞাৎৱা তৎস্থানমপ্যাগত্য লোকানাং কুপ্ৰৱৃত্তিম্ অজনযন্| ");
INSERT INTO sanasm_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","অতএৱ তস্মাৎ স্থানাৎ সমুদ্ৰেণ যান্তীতি দৰ্শযিৎৱা ভ্ৰাতৰঃ ক্ষিপ্ৰং পৌলং প্ৰাহিণ্ৱন্ কিন্তু সীলতীমথিযৌ তত্ৰ স্থিতৱন্তৌ| ");
INSERT INTO sanasm_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","ততঃ পৰং পৌলস্য মাৰ্গদৰ্শকাস্তম্ আথীনীনগৰ উপস্থাপযন্ পশ্চাদ্ যুৱাং তূৰ্ণম্ এতৎ স্থানং আগমিষ্যথঃ সীলতীমথিযৌ প্ৰতীমাম্ আজ্ঞাং প্ৰাপ্য তে প্ৰত্যাগতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","পৌল আথীনীনগৰে তাৱপেক্ষ্য তিষ্ঠন্ তন্নগৰং প্ৰতিমাভিঃ পৰিপূৰ্ণং দৃষ্ট্ৱা সন্তপ্তহৃদযো ঽভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","ততঃ স ভজনভৱনে যান্ যিহূদীযান্ ভক্তলোকাংশ্চ হট্টে চ যান্ অপশ্যৎ তৈঃ সহ প্ৰতিদিনং ৱিচাৰিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","কিন্ত্ৱিপিকূৰীযমতগ্ৰহিণঃ স্তোযিকীযমতগ্ৰাহিণশ্চ কিযন্তো জনাস্তেন সাৰ্দ্ধং ৱ্যৱদন্ত| তত্ৰ কেচিদ্ অকথযন্ এষ ৱাচালঃ কিং ৱক্তুম্ ইচ্ছতি? অপৰে কেচিদ্ এষ জনঃ কেষাঞ্চিদ্ ৱিদেশীযদেৱানাং প্ৰচাৰক ইত্যনুমীযতে যতঃ স যীশুম্ উত্থিতিঞ্চ প্ৰচাৰযৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","তে তম্ অৰেযপাগনাম ৱিচাৰস্থানম্ আনীয প্ৰাৱোচন্ ইদং যন্নৱীনং মতং ৎৱং প্ৰাচীকশ ইদং কীদৃশং এতদ্ অস্মান্ শ্ৰাৱয; ");
INSERT INTO sanasm_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","যামিমাম্ অসম্ভৱকথাম্ অস্মাকং কৰ্ণগোচৰীকৃতৱান্ অস্যা ভাৱাৰ্থঃ ক ইতি ৱযং জ্ঞাতুম্ ইচ্ছামঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","তদাথীনীনিৱাসিনস্তন্নগৰপ্ৰৱাসিনশ্চ কেৱলং কস্যাশ্চন নৱীনকথাযাঃ শ্ৰৱণেন প্ৰচাৰণেন চ কালম্ অযাপযন্| ");
INSERT INTO sanasm_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","পৌলোঽৰেযপাগস্য মধ্যে তিষ্ঠন্ এতাং কথাং প্ৰচাৰিতৱান্, হে আথীনীযলোকা যূযং সৰ্ৱ্ৱথা দেৱপূজাযাম্ আসক্তা ইত্যহ প্ৰত্যক্ষং পশ্যামি| ");
INSERT INTO sanasm_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","যতঃ পৰ্য্যটনকালে যুষ্মাকং পূজনীযানি পশ্যন্ ‘অৱিজ্ঞাতেশ্ৱৰায’ এতল্লিপিযুক্তাং যজ্ঞৱেদীমেকাং দৃষ্টৱান্; অতো ন ৱিদিৎৱা যং পূজযধ্ৱে তস্যৈৱ তৎৱং যুষ্মান্ প্ৰতি প্ৰচাৰযামি| ");
INSERT INTO sanasm_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","জগতো জগৎস্থানাং সৰ্ৱ্ৱৱস্তূনাঞ্চ স্ৰষ্টা য ঈশ্ৱৰঃ স স্ৱৰ্গপৃথিৱ্যোৰেকাধিপতিঃ সন্ কৰনিৰ্ম্মিতমন্দিৰেষু ন নিৱসতি; ");
INSERT INTO sanasm_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","স এৱ সৰ্ৱ্ৱেভ্যো জীৱনং প্ৰাণান্ সৰ্ৱ্ৱসামগ্ৰীশ্চ প্ৰদদাতি; অতএৱ স কস্যাশ্চিৎ সামগ্য্ৰা অভাৱহেতো ৰ্মনুষ্যাণাং হস্তৈঃ সেৱিতো ভৱতীতি ন| ");
INSERT INTO sanasm_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","স ভূমণ্ডলে নিৱাসাৰ্থম্ একস্মাৎ শোণিতাৎ সৰ্ৱ্ৱান্ মনুষ্যান্ সৃষ্ট্ৱা তেষাং পূৰ্ৱ্ৱনিৰূপিতসমযং ৱসতিসীমাঞ্চ নিৰচিনোৎ; ");
INSERT INTO sanasm_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","তস্মাৎ লোকৈঃ কেনাপি প্ৰকাৰেণ মৃগযিৎৱা পৰমেশ্ৱৰস্য তৎৱং প্ৰাপ্তুং তস্য গৱেষণং কৰণীযম্| ");
INSERT INTO sanasm_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","কিন্তু সোঽস্মাকং কস্মাচ্চিদপি দূৰে তিষ্ঠতীতি নহি, ৱযং তেন নিশ্ৱসনপ্ৰশ্ৱসনগমনাগমনপ্ৰাণধাৰণানি কুৰ্ম্মঃ, পুुনশ্চ যুষ্মাকমেৱ কতিপযাঃ কৱযঃ কথযন্তি ‘তস্য ৱংশা ৱযং স্মো হি’ ইতি| ");
INSERT INTO sanasm_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","অতএৱ যদি ৱযম্ ঈশ্ৱৰস্য ৱংশা ভৱামস্তৰ্হি মনুষ্যৈ ৰ্ৱিদ্যযা কৌশলেন চ তক্ষিতং স্ৱৰ্ণং ৰূপ্যং দৃষদ্ ৱৈতেষামীশ্ৱৰৎৱম্ অস্মাভি ৰ্ন জ্ঞাতৱ্যং| ");
INSERT INTO sanasm_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","তেষাং পূৰ্ৱ্ৱীযলোকানাম্ অজ্ঞানতাং প্ৰতীশ্ৱৰো যদ্যপি নাৱাধত্ত তথাপীদানীং সৰ্ৱ্ৱত্ৰ সৰ্ৱ্ৱান্ মনঃ পৰিৱৰ্ত্তযিতুম্ আজ্ঞাপযতি, ");
INSERT INTO sanasm_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","যতঃ স্ৱনিযুক্তেন পুৰুষেণ যদা স পৃথিৱীস্থানাং সৰ্ৱ্ৱলোকানাং ৱিচাৰং কৰিষ্যতি তদ্দিনং ন্যৰূপযৎ; তস্য শ্মশানোত্থাপনেন তস্মিন্ সৰ্ৱ্ৱেভ্যঃ প্ৰমাণং প্ৰাদাৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","তদা শ্মশানাদ্ উত্থানস্য কথাং শ্ৰুৎৱা কেচিদ্ উপাহমন্, কেচিদৱদন্ এনাং কথাং পুনৰপি ৎৱত্তঃ শ্ৰোষ্যামঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","ততঃ পৌলস্তেষাং সমীপাৎ প্ৰস্থিाতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","তথাপি কেচিল্লোকাস্তেন সাৰ্দ্ধং মিলিৎৱা ৱ্যশ্ৱসন্ তেষাং মধ্যে ঽৰেযপাগীযদিযনুসিযো দামাৰীনামা কাচিন্নাৰী কিযন্তো নৰাশ্চাসন্| ");
INSERT INTO sanasm_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","তদ্ঘটনাতঃ পৰং পৌল আথীনীনগৰাদ্ যাত্ৰাং কৃৎৱা কৰিন্থনগৰম্ আগচ্ছৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","তস্মিন্ সমযে ক্লৌদিযঃ সৰ্ৱ্ৱান্ যিহূদীযান্ ৰোমানগৰং ৱিহায গন্তুম্ আজ্ঞাপযৎ, তস্মাৎ প্ৰিস্কিল্লানাম্না জাযযা সাৰ্দ্ধম্ ইতালিযাদেশাৎ কিঞ্চিৎপূৰ্ৱ্ৱম্ আগমৎ যঃ পন্তদেশে জাত আক্কিলনামা যিহূদীযলোকঃ পৌলস্তং সাক্ষাৎ প্ৰাপ্য তযোঃ সমীপমিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","তৌ দূষ্যনিৰ্ম্মাণজীৱিনৌ, তস্মাৎ পৰস্পৰম্ একৱৃত্তিকৎৱাৎ স তাভ্যাং সহ উষিৎৱা তৎ কৰ্ম্মাকৰোৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","পৌলঃ প্ৰতিৱিশ্ৰামৱাৰং ভজনভৱনং গৎৱা ৱিচাৰং কৃৎৱা যিহূদীযান্ অন্যদেশীযাংশ্চ প্ৰৱৃত্তিং গ্ৰাহিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","সীলতীমথিযযো ৰ্মাকিদনিযাদেশাৎ সমেতযোঃ সতোঃ পৌল উত্তপ্তমনা ভূৎৱা যীশুৰীশ্ৱৰেণাভিষিক্তো ভৱতীতি প্ৰমাণং যিহূদীযানাং সমীপে প্ৰাদাৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","কিন্তু তে ঽতীৱ ৱিৰোধং ৱিধায পাষণ্ডীযকথাং কথিতৱন্তস্ততঃ পৌলো ৱস্ত্ৰং ধুন্ৱন্ এতাং কথাং কথিতৱান্, যুষ্মাকং শোণিতপাতাপৰাধো যুষ্মান্ প্ৰত্যেৱ ভৱতু, তেনাহং নিৰপৰাধো ঽদ্যাৰভ্য ভিন্নদেশীযানাং সমীপং যামি| ");
INSERT INTO sanasm_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","স তস্মাৎ প্ৰস্থায ভজনভৱনসমীপস্থস্য যুস্তনাম্ন ঈশ্ৱৰভক্তস্য ভিন্নদেশীযস্য নিৱেশনং প্ৰাৱিশৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","ততঃ ক্ৰীষ্পনামা ভজনভৱনাধিপতিঃ সপৰিৱাৰঃ প্ৰভৌ ৱ্যশ্ৱসীৎ, কৰিন্থনগৰীযা বহৱো লোকাশ্চ সমাকৰ্ণ্য ৱিশ্ৱস্য মজ্জিতা অভৱন্| ");
INSERT INTO sanasm_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","ক্ষণদাযাং প্ৰভুঃ পৌলং দৰ্শনং দৎৱা ভাষিতৱান্, মা ভৈষীঃ, মা নিৰসীঃ কথাং প্ৰচাৰয| ");
INSERT INTO sanasm_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","অহং ৎৱযা সাৰ্দ্ধম্ আস হিংসাৰ্থং কোপি ৎৱাং স্প্ৰষ্টুং ন শক্ষ্যতি নগৰেঽস্মিন্ মদীযা লোকা বহৱ আসতে| ");
INSERT INTO sanasm_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","তস্মাৎ পৌলস্তন্নগৰে প্ৰাযেণ সাৰ্দ্ধৱৎসৰপৰ্য্যন্তং সংস্থাযেশ্ৱৰস্য কথাম্ উপাদিশৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","গাল্লিযনামা কশ্চিদ্ আখাযাদেশস্য প্ৰাড্ৱিৱাকঃ সমভৱৎ, ততো যিহূদীযা একৱাক্যাঃ সন্তঃ পৌলম্ আক্ৰম্য ৱিচাৰস্থানং নীৎৱা ");
INSERT INTO sanasm_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","মানুষ এষ ৱ্যৱস্থায ৱিৰুদ্ধম্ ঈশ্ৱৰভজনং কৰ্ত্তুং লোকান্ কুপ্ৰৱৃত্তিং গ্ৰাহযতীতি নিৱেদিতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","ততঃ পৌলে প্ৰত্যুত্তৰং দাতুম্ উদ্যতে সতি গাল্লিযা যিহূদীযান্ ৱ্যাহৰৎ, যদি কস্যচিদ্ অন্যাযস্য ৱাতিশযদুষ্টতাচৰণস্য ৱিচাৰোঽভৱিষ্যৎ তৰ্হি যুষ্মাকং কথা মযা সহনীযাভৱিষ্যৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","কিন্তু যদি কেৱলং কথাযা ৱা নাম্নো ৱা যুষ্মাকং ৱ্যৱস্থাযা ৱিৱাদো ভৱতি তৰ্হি তস্য ৱিচাৰমহং ন কৰিষ্যামি, যূযং তস্য মীমাংসাং কুৰুত| ");
INSERT INTO sanasm_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","ততঃ স তান্ ৱিচাৰস্থানাদ্ দূৰীকৃতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","তদা ভিন্নদেশীযাঃ সোস্থিনিনামানং ভজনভৱনস্য প্ৰধানাধিপতিং ধৃৎৱা ৱিচাৰস্থানস্য সম্মুখে প্ৰাহৰন্ তথাপি গাল্লিযা তেষু সৰ্ৱ্ৱকৰ্ম্মসু ন মনো ন্যদধাৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","পৌলস্তত্ৰ পুনৰ্বহুদিনানি ন্যৱসৎ, ততো ভ্ৰাতৃগণাদ্ ৱিসৰ্জনং প্ৰাপ্য কিঞ্চনৱ্ৰতনিমিত্তং কিংক্ৰিযানগৰে শিৰো মুণ্ডযিৎৱা প্ৰিস্কিল্লাক্কিলাভ্যাং সহিতো জলপথেন সুৰিযাদেশং গতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","তত ইফিষনগৰ উপস্থায তত্ৰ তৌ ৱিসৃজ্য স্ৱযং ভজনভ্ৱনং প্ৰৱিশ্য যিহূদীযৈঃ সহ ৱিচাৰিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","তে স্ৱৈঃ সাৰ্দ্ধং পুনঃ কতিপযদিনানি স্থাতুং তং ৱ্যনযন্, স তদনুৰৰীকৃত্য কথামেতাং কথিতৱান্, ");
INSERT INTO sanasm_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","যিৰূশালমি আগাম্যুৎসৱপালনাৰ্থং মযা গমনীযং; পশ্চাদ্ ঈশ্ৱৰেচ্ছাযাং জাতাযাং যুষ্মাকং সমীপং প্ৰত্যাগমিষ্যামি| ততঃ পৰং স তৈ ৰ্ৱিসৃষ্টঃ সন্ জলপথেন ইফিষনগৰাৎ প্ৰস্থিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","ততঃ কৈসৰিযাম্ উপস্থিতঃ সন্ নগৰং গৎৱা সমাজং নমস্কৃত্য তস্মাদ্ আন্তিযখিযানগৰং প্ৰস্থিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","তত্ৰ কিযৎকালং যাপযিৎৱা তস্মাৎ প্ৰস্থায সৰ্ৱ্ৱেষাং শিষ্যাণাং মনাংসি সুস্থিৰাণি কৃৎৱা ক্ৰমশো গলাতিযাফ্ৰুগিযাদেশযো ৰ্ভ্ৰমিৎৱা গতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","তস্মিন্নেৱ সমযে সিকন্দৰিযানগৰে জাত আপল্লোনামা শাস্ত্ৰৱিৎ সুৱক্তা যিহূদীয একো জন ইফিষনগৰম্ আগতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","স শিক্ষিতপ্ৰভুমাৰ্গো মনসোদ্যোগী চ সন্ যোহনো মজ্জনমাত্ৰং জ্ঞাৎৱা যথাৰ্থতযা প্ৰভোঃ কথাং কথযন্ সমুপাদিশৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","এষ জনো নিৰ্ভযৎৱেন ভজনভৱনে কথযিতুম্ আৰব্ধৱান্, ততঃ প্ৰিস্কিল্লাক্কিলৌ তস্যোপদেশকথাং নিশম্য তং স্ৱযোঃ সমীপম্ আনীয শুদ্ধৰূপেণেশ্ৱৰস্য কথাম্ অবোধযতাম্| ");
INSERT INTO sanasm_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","পশ্চাৎ স আখাযাদেশং গন্তুং মতিং কৃতৱান্, তদা তত্ৰত্যঃ শিষ্যগণো যথা তং গৃহ্লাতি তদৰ্থং ভ্ৰাতৃগণেন সমাশ্ৱস্য পত্ৰে লিখিতে সতি, আপল্লাস্তত্ৰোপস্থিতঃ সন্ অনুগ্ৰহেণ প্ৰত্যযিনাং বহূপকাৰান্ অকৰোৎ, ");
INSERT INTO sanasm_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ফলতো যীশুৰভিষিক্তস্ত্ৰাতেতি শাস্ত্ৰপ্ৰমাণং দৎৱা প্ৰকাশৰূপেণ প্ৰতিপন্নং কৃৎৱা যিহূদীযান্ নিৰুত্তৰান্ কৃতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","কৰিন্থনগৰ আপল্লসঃ স্থিতিকালে পৌল উত্তৰপ্ৰদেশৈৰাগচ্ছন্ ইফিষনগৰম্ উপস্থিতৱান্| তত্ৰ কতিপযশিষ্যান্ সাক্ষৎ প্ৰাপ্য তান্ অপৃচ্ছৎ, ");
INSERT INTO sanasm_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","যূযং ৱিশ্ৱস্য পৱিত্ৰমাত্মানং প্ৰাপ্তা ন ৱা? ততস্তে প্ৰত্যৱদন্ পৱিত্ৰ আত্মা দীযতে ইত্যস্মাভিঃ শ্ৰুতমপি নহি| ");
INSERT INTO sanasm_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","তদা সাঽৱদৎ তৰ্হি যূযং কেন মজ্জিতা অভৱত? তেঽকথযন্ যোহনো মজ্জনেন| ");
INSERT INTO sanasm_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","তদা পৌল উক্তৱান্ ইতঃ পৰং য উপস্থাস্যতি তস্মিন্ অৰ্থত যীশুখ্ৰীষ্টে ৱিশ্ৱসিতৱ্যমিত্যুক্ত্ৱা যোহন্ মনঃপৰিৱৰ্ত্তনসূচকেন মজ্জনেন জলে লোকান্ অমজ্জযৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","তাদৃশীং কথাং শ্ৰুৎৱা তে প্ৰভো ৰ্যীশুখ্ৰীষ্টস্য নাম্না মজ্জিতা অভৱন্| ");
INSERT INTO sanasm_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ততঃ পৌলেন তেষাং গাত্ৰেষু কৰেঽৰ্পিতে তেষামুপৰি পৱিত্ৰ আত্মাৱৰূঢৱান্, তস্মাৎ তে নানাদেশীযা ভাষা ভৱিষ্যৎকথাশ্চ কথিতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","তে প্ৰাযেণ দ্ৱাদশজনা আসন্| ");
INSERT INTO sanasm_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","পৌলো ভজনভৱনং গৎৱা প্ৰাযেণ মাসত্ৰযম্ ঈশ্ৱৰস্য ৰাজ্যস্য ৱিচাৰং কৃৎৱা লোকান্ প্ৰৱৰ্ত্য সাহসেন কথামকথযৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","কিন্তু কঠিনান্তঃকৰণৎৱাৎ কিযন্তো জনা ন ৱিশ্ৱস্য সৰ্ৱ্ৱেষাং সমক্ষম্ এতৎপথস্য নিন্দাং কৰ্ত্তুং প্ৰৱৃত্তাঃ, অতঃ পৌলস্তেষাং সমীপাৎ প্ৰস্থায শিষ্যগণং পৃথক্কৃৎৱা প্ৰত্যহং তুৰান্ননাম্নঃ কস্যচিৎ জনস্য পাঠশালাযাং ৱিচাৰং কৃতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ইত্থং ৱৎসৰদ্ৱযং গতং তস্মাদ্ আশিযাদেশনিৱাসিনঃ সৰ্ৱ্ৱে যিহূদীযা অন্যদেশীযলোকাশ্চ প্ৰভো ৰ্যীশোঃ কথাম্ অশ্ৰৌষন্| ");
INSERT INTO sanasm_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","পৌলেন চ ঈশ্ৱৰ এতাদৃশান্যদ্ভুতানি কৰ্ম্মাণি কৃতৱান্ ");
INSERT INTO sanasm_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","যৎ পৰিধেযে গাত্ৰমাৰ্জনৱস্ত্ৰে ৱা তস্য দেহাৎ পীডিতলোকানাম্ সমীপম্ আনীতে তে নিৰামযা জাতা অপৱিত্ৰা ভূতাশ্চ তেভ্যো বহিৰ্গতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","তদা দেশাটনকাৰিণঃ কিযন্তো যিহূদীযা ভূতাপসাৰিণো ভূতগ্ৰস্তনোকানাং সন্নিধৌ প্ৰভে ৰ্যীশো ৰ্নাম জপ্ত্ৱা ৱাক্যমিদম্ অৱদন্, যস্য কথাং পৌলঃ প্ৰচাৰযতি তস্য যীশো ৰ্নাম্না যুষ্মান্ আজ্ঞাপযামঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","স্কিৱনাম্নো যিহূদীযানাং প্ৰধানযাজকস্য সপ্তভিঃ পুত্তৈস্তথা কৃতে সতি ");
INSERT INTO sanasm_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","কশ্চিদ্ অপৱিত্ৰো ভূতঃ প্ৰত্যুদিতৱান্, যীশুং জানামি পৌলঞ্চ পৰিচিনোমি কিন্তু কে যূযং? ");
INSERT INTO sanasm_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ইত্যুক্ত্ৱা সোপৱিত্ৰভূতগ্ৰস্তো মনুষ্যো লম্ফং কৃৎৱা তেষামুপৰি পতিৎৱা বলেন তান্ জিতৱান্, তস্মাত্তে নগ্নাঃ ক্ষতাঙ্গাশ্চ সন্তস্তস্মাদ্ গেহাৎ পলাযন্ত| ");
INSERT INTO sanasm_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","সা ৱাগ্ ইফিষনগৰনিৱাসিনসং সৰ্ৱ্ৱেষাং যিহূদীযানাং ভিন্নদেশীযানাং লোকানাঞ্চ শ্ৰৱোগোচৰীভূতা; ততঃ সৰ্ৱ্ৱে ভযং গতাঃ প্ৰভো ৰ্যীশো ৰ্নাম্নো যশো ঽৱৰ্দ্ধত| ");
INSERT INTO sanasm_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","যেষামনেকেষাং লোকানাং প্ৰতীতিৰজাযত ত আগত্য স্ৱৈঃ কৃতাঃ ক্ৰিযাঃ প্ৰকাশৰূপেণাঙ্গীকৃতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","বহৱো মাযাকৰ্ম্মকাৰিণঃ স্ৱস্ৱগ্ৰন্থান্ আনীয ৰাশীকৃত্য সৰ্ৱ্ৱেষাং সমক্ষম্ অদাহযন্, ততো গণনাং কৃৎৱাবুধ্যন্ত পঞ্চাযুতৰূপ্যমুদ্ৰামূল্যপুস্তকানি দগ্ধানি| ");
INSERT INTO sanasm_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ইত্থং প্ৰভোঃ কথা সৰ্ৱ্ৱদেশং ৱ্যাপ্য প্ৰবলা জাতা| ");
INSERT INTO sanasm_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","সৰ্ৱ্ৱেষ্ৱেতেষু কৰ্ম্মসু সম্পন্নেষু সৎসু পৌলো মাকিদনিযাখাযাদেশাভ্যাং যিৰূশালমং গন্তুং মতিং কৃৎৱা কথিতৱান্ তৎস্থানং যাত্ৰাযাং কৃতাযাং সত্যাং মযা ৰোমানগৰং দ্ৰষ্টৱ্যং| ");
INSERT INTO sanasm_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","স্ৱানুগতলোকানাং তীমথিযেৰাস্তৌ দ্ৱৌ জনৌ মাকিদনিযাদেশং প্ৰতি প্ৰহিত্য স্ৱযম্ আশিযাদেশে কতিপযদিনানি স্থিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","কিন্তু তস্মিন্ সমযে মতেঽস্মিন্ কলহো জাতঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","তৎকাৰণমিদং, অৰ্ত্তিমীদেৱ্যা ৰূপ্যমন্দিৰনিৰ্ম্মাণেন সৰ্ৱ্ৱেষাং শিল্পিনাং যথেষ্টলাভম্ অজনযৎ যো দীমীত্ৰিযনামা নাডীন্ধমঃ ");
INSERT INTO sanasm_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","স তান্ তৎকৰ্ম্মজীৱিনঃ সৰ্ৱ্ৱলোকাংশ্চ সমাহূয ভাষিতৱান্ হে মহেচ্ছা এতেন মন্দিৰনিৰ্ম্মাণেনাস্মাকং জীৱিকা ভৱতি, এতদ্ যূযং ৱিত্থ; ");
INSERT INTO sanasm_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","কিন্তু হস্তনিৰ্ম্মিতেশ্ৱৰা ঈশ্ৱৰা নহি পৌলনাম্না কেনচিজ্জনেন কথামিমাং ৱ্যাহৃত্য কেৱলেফিষনগৰে নহি প্ৰাযেণ সৰ্ৱ্ৱস্মিন্ আশিযাদেশে প্ৰৱৃত্তিং গ্ৰাহযিৎৱা বহুলোকানাং শেমুষী পৰাৱৰ্ত্তিতা, এতদ্ যুষ্মাভি ৰ্দৃশ্যতে শ্ৰূযতে চ| ");
INSERT INTO sanasm_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","তেনাস্মাকং ৱাণিজ্যস্য সৰ্ৱ্ৱথা হানেঃ সম্ভৱনং কেৱলমিতি নহি, আশিযাদেশস্থৈ ৰ্ৱা সৰ্ৱ্ৱজগৎস্থৈ ৰ্লোকৈঃ পূজ্যা যাৰ্তিমী মহাদেৱী তস্যা মন্দিৰস্যাৱজ্ঞানস্য তস্যা ঐশ্ৱৰ্য্যস্য নাশস্য চ সম্ভাৱনা ৱিদ্যতেे| ");
INSERT INTO sanasm_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","এতাদৃশীং কথাং শ্ৰুৎৱা তে মহাক্ৰোধান্ৱিতাঃ সন্ত উচ্চৈঃকাৰং কথিতৱন্ত ইফিষীযানাম্ অৰ্ত্তিমী দেৱী মহতী ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","ততঃ সৰ্ৱ্ৱনগৰং কলহেন পৰিপূৰ্ণমভৱৎ, ততঃ পৰং তে মাকিদনীযগাযাৰিস্তাৰ্খনামানৌ পৌলস্য দ্ৱৌ সহচৰৌ ধৃৎৱৈকচিত্তা ৰঙ্গভূমিং জৱেন ধাৱিতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","ততঃ পৌলো লোকানাং সন্নিধিং যাতুম্ উদ্যতৱান্ কিন্তু শিষ্যগণস্তং ৱাৰিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","পৌলস্যত্মীযা আশিযাদেশস্থাঃ কতিপযাঃ প্ৰধানলোকাস্তস্য সমীপং নৰমেকং প্ৰেষ্য ৎৱং ৰঙ্গভূমিং মাগা ইতি ন্যৱেদযন্| ");
INSERT INTO sanasm_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","ততো নানালোকানাং নানাকথাকথনাৎ সভা ৱ্যাকুলা জাতা কিং কাৰণাদ্ এতাৱতী জনতাভৱৎ এতদ্ অধিকৈ ৰ্লোকৈ ৰ্নাজ্ঞাযি| ");
INSERT INTO sanasm_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","ততঃ পৰং জনতামধ্যাদ্ যিহূদীযৈৰ্বহিষ্কৃতঃ সিকন্দৰো হস্তেন সঙ্কেতং কৃৎৱা লোকেভ্য উত্তৰং দাতুমুদ্যতৱান্, ");
INSERT INTO sanasm_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","কিন্তু স যিহূদীযলোক ইতি নিশ্চিতে সতি ইফিষীযানাম্ অৰ্ত্তিমী দেৱী মহতীতি ৱাক্যং প্ৰাযেণ পঞ্চ দণ্ডান্ যাৱদ্ একস্ৱৰেণ লোকনিৱহৈঃ প্ৰোক্তং| ");
INSERT INTO sanasm_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","ততো নগৰাধিপতিস্তান্ স্থিৰান্ কৃৎৱা কথিতৱান্ হে ইফিষাযাঃ সৰ্ৱ্ৱে লোকা আকৰ্ণযত, অৰ্তিমীমহাদেৱ্যা মহাদেৱাৎ পতিতাযাস্তৎপ্ৰতিমাযাশ্চ পূজনম ইফিষনগৰস্থাঃ সৰ্ৱ্ৱে লোকাঃ কুৰ্ৱ্ৱন্তি, এতৎ কে ন জানন্তি? ");
INSERT INTO sanasm_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","তস্মাদ্ এতৎপ্ৰতিকূলং কেপি কথযিতুং ন শক্নুৱন্তি, ইতি জ্ঞাৎৱা যুষ্মাভিঃ সুস্থিৰৎৱেন স্থাতৱ্যম্ অৱিৱিচ্য কিমপি কৰ্ম্ম ন কৰ্ত্তৱ্যঞ্চ| ");
INSERT INTO sanasm_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","যান্ এতান্ মনুষ্যান্ যূযমত্ৰ সমানযত তে মন্দিৰদ্ৰৱ্যাপহাৰকা যুষ্মাকং দেৱ্যা নিন্দকাশ্চ ন ভৱন্তি| ");
INSERT INTO sanasm_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","যদি কঞ্চন প্ৰতি দীমীত্ৰিযস্য তস্য সহাযানাঞ্চ কাচিদ্ আপত্তি ৰ্ৱিদ্যতে তৰ্হি প্ৰতিনিধিলোকা ৱিচাৰস্থানঞ্চ সন্তি, তে তৎ স্থানং গৎৱা উত্তৰপ্ৰত্যুত্তৰে কুৰ্ৱ্ৱন্তু| ");
INSERT INTO sanasm_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","কিন্তু যুষ্মাকং কাচিদপৰা কথা যদি তিষ্ঠতি তৰ্হি নিযমিতাযাং সভাযাং তস্যা নিষ্পত্তি ৰ্ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","কিন্ত্ৱেতস্য ৱিৰোধস্যোত্তৰং যেন দাতুং শক্নুম্ এতাদৃশস্য কস্যচিৎ কাৰণস্যাভাৱাদ্ অদ্যতনঘটনাহেতো ৰাজদ্ৰোহিণামিৱাস্মাকম্ অভিযোগো ভৱিষ্যতীতি শঙ্কা ৱিদ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","ইতি কথযিৎৱা স সভাস্থলোকান্ ৱিসৃষ্টৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ইত্থং কলহে নিৱৃত্তে সতি পৌলঃ শিষ্যগণম্ আহূয ৱিসৰ্জনং প্ৰাপ্য মাকিদনিযাদেশং প্ৰস্থিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","তেন স্থানেন গচ্ছন্ তদ্দেশীযান্ শিষ্যান্ বহূপদিশ্য যূনানীযদেশম্ উপস্থিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","তত্ৰ মাসত্ৰযং স্থিৎৱা তস্মাৎ সুৰিযাদেশং যাতুম্ উদ্যতঃ, কিন্তু যিহূদীযাস্তং হন্তুং গুপ্তা অতিষ্ঠন্ তস্মাৎ স পুনৰপি মাকিদনিযামাৰ্গেণ প্ৰত্যাগন্তুং মতিং কৃতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","বিৰযানগৰীযসোপাত্ৰঃ থিষলনীকীযাৰিস্তাৰ্খসিকুন্দৌ দৰ্ব্বোনগৰীযগাযতীমথিযৌ আশিযাদেশীযতুখিকত্ৰফিমৌ চ তেন সাৰ্দ্ধং আশিযাদেশং যাৱদ্ গতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","এতে সৰ্ৱ্ৱে ঽগ্ৰসৰাঃ সন্তো ঽস্মান্ অপেক্ষ্য ত্ৰোযানগৰে স্থিতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","কিণ্ৱশূন্যপূপোৎসৱদিনে চ গতে সতি ৱযং ফিলিপীনগৰাৎ তোযপথেন গৎৱা পঞ্চভি ৰ্দিনৈস্ত্ৰোযানগৰম্ উপস্থায তত্ৰ সপ্তদিনান্যৱাতিষ্ঠাম| ");
INSERT INTO sanasm_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","সপ্তাহস্য প্ৰথমদিনে পূপান্ ভংক্তু শিষ্যেষু মিলিতেষু পৌলঃ পৰদিনে তস্মাৎ প্ৰস্থাতুম্ উদ্যতঃ সন্ তদহ্নি প্ৰাযেণ ক্ষপাযা যামদ্ৱযং যাৱৎ শিষ্যেভ্যো ধৰ্ম্মকথাম্ অকথযৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","উপৰিস্থে যস্মিন্ প্ৰকোষ্ঠে সভাং কৃৎৱাসন্ তত্ৰ বহৱঃ প্ৰদীপাঃ প্ৰাজ্ৱলন্| ");
INSERT INTO sanasm_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","উতুখনামা কশ্চন যুৱা চ ৱাতাযন উপৱিশন্ ঘোৰতৰনিদ্ৰাগ্ৰস্তো ঽভূৎ তদা পৌলেন বহুক্ষণং কথাযাং প্ৰচাৰিতাযাং নিদ্ৰামগ্নঃ স তস্মাদ্ উপৰিস্থতৃতীযপ্ৰকোষ্ঠাদ্ অপতৎ, ততো লোকাস্তং মৃতকল্পং ধৃৎৱোদতোলযন্| ");
INSERT INTO sanasm_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","ততঃ পৌলোঽৱৰুহ্য তস্য গাত্ৰে পতিৎৱা তং ক্ৰোডে নিধায কথিতৱান্, যূযং ৱ্যাকুলা মা ভূত নাযং প্ৰাণৈ ৰ্ৱিযুক্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","পশ্চাৎ স পুনশ্চোপৰি গৎৱা পূপান্ ভংক্ত্ৱা প্ৰভাতং যাৱৎ কথোপকথনে কৃৎৱা প্ৰস্থিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","তে চ তং জীৱন্তং যুৱানং গৃহীৎৱা গৎৱা পৰমাপ্যাযিতা জাতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","অনন্তৰং ৱযং পোতেনাগ্ৰসৰা ভূৎৱাস্মনগৰম্ উত্তীৰ্য্য পৌলং গ্ৰহীতুং মতিম্ অকুৰ্ম্ম যতঃ স তত্ৰ পদ্ভ্যাং ৱ্ৰজিতুং মতিং কৃৎৱেতি নিৰূপিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","তস্মাৎ তত্ৰাস্মাভিঃ সাৰ্দ্ধং তস্মিন্ মিলিতে সতি ৱযং তং নীৎৱা মিতুলীন্যুপদ্ৱীপং প্ৰাপ্তৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","তস্মাৎ পোতং মোচযিৎৱা পৰেঽহনি খীযোপদ্ৱীপস্য সম্মুখং লব্ধৱন্তস্তস্মাদ্ একেনাহ্না সামোপদ্ৱীপং গৎৱা পোতং লাগযিৎৱা ত্ৰোগুল্লিযে স্থিৎৱা পৰস্মিন্ দিৱসেे মিলীতনগৰম্ উপাতিষ্ঠাম| ");
INSERT INTO sanasm_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","যতঃ পৌল আশিযাদেশে কালং যাপযিতুম্ নাভিলষন্ ইফিষনগৰং ত্যক্ত্ৱা যাতুং মন্ত্ৰণাং স্থিৰীকৃতৱান্; যস্মাদ্ যদি সাধ্যং ভৱতি তৰ্হি নিস্তাৰোৎসৱস্য পঞ্চাশত্তমদিনে স যিৰূশালম্যুপস্থাতুং মতিং কৃতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","পৌলো মিলীতাদ্ ইফিষং প্ৰতি লোকং প্ৰহিত্য সমাজস্য প্ৰাচীনান্ আহূযানীতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","তেষু তস্য সমীপম্ উপস্থিতেষু স তেভ্য ইমাং কথাং কথিতৱান্, অহম্ আশিযাদেশে প্ৰথমাগমনম্ আৰভ্যাদ্য যাৱদ্ যুষ্মাকং সন্নিধৌ স্থিৎৱা সৰ্ৱ্ৱসমযে যথাচৰিতৱান্ তদ্ যূযং জানীথ; ");
INSERT INTO sanasm_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ফলতঃ সৰ্ৱ্ৱথা নম্ৰমনাঃ সন্ বহুশ্ৰুপাতেন যিহুদীযানাম্ কুমন্ত্ৰণাজাতনানাপৰীক্ষাভিঃ প্ৰভোঃ সেৱামকৰৱং| ");
INSERT INTO sanasm_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","কামপি হিতকথাाং ন গোপাযিতৱান্ তাং প্ৰচাৰ্য্য সপ্ৰকাশং গৃহে গৃহে সমুপদিশ্যেশ্ৱৰং প্ৰতি মনঃ পৰাৱৰ্ত্তনীযং প্ৰভৌ যীশুখ্ৰীষ্টে ৱিশ্ৱসনীযং ");
INSERT INTO sanasm_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","যিহূদীযানাম্ অন্যদেশীযলোকানাঞ্চ সমীপ এতাদৃশং সাক্ষ্যং দদামি| ");
INSERT INTO sanasm_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","পশ্যত সাম্প্ৰতম্ আত্মনাকৃষ্টঃ সন্ যিৰূশালম্নগৰে যাত্ৰাং কৰোমি, তত্ৰ মাম্প্ৰতি যদ্যদ্ ঘটিষ্যতে তান্যহং ন জানামি; ");
INSERT INTO sanasm_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","কিন্তু মযা বন্ধনং ক্লেশশ্চ ভোক্তৱ্য ইতি পৱিত্ৰ আত্মা নগৰে নগৰে প্ৰমাণং দদাতি| ");
INSERT INTO sanasm_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","তথাপি তং ক্লেশমহং তৃণায ন মন্যে; ঈশ্ৱৰস্যানুগ্ৰহৱিষযকস্য সুসংৱাদস্য প্ৰমাণং দাতুং, প্ৰভো ৰ্যীশোঃ সকাশাদ যস্যাঃ সেৱাযাঃ ভাৰং প্ৰাপ্নৱং তাং সেৱাং সাধযিতুং সানন্দং স্ৱমাৰ্গং সমাপযিতুुঞ্চ নিজপ্ৰাণানপি প্ৰিযান্ ন মন্যে| ");
INSERT INTO sanasm_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","অধুনা পশ্যত যেষাং সমীপেঽহম্ ঈশ্ৱৰীযৰাজ্যস্য সুসংৱাদং প্ৰচাৰ্য্য ভ্ৰমণং কৃতৱান্ এতাদৃশা যূযং মম ৱদনং পুন ৰ্দ্ৰষ্টুং ন প্ৰাপ্স্যথ এতদপ্যহং জানামি| ");
INSERT INTO sanasm_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","যুষ্মভ্যম্ অহম্ ঈশ্ৱৰস্য সৰ্ৱ্ৱান্ আদেশান্ প্ৰকাশযিতুং ন ন্যৱৰ্ত্তে| ");
INSERT INTO sanasm_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","অহং সৰ্ৱ্ৱেষাং লোকানাং ৰক্তপাতদোষাদ্ যন্নিৰ্দোষ আসে তস্যাদ্য যুষ্মান্ সাক্ষিণঃ কৰোমি| ");
INSERT INTO sanasm_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","যূযং স্ৱেষু তথা যস্য ৱ্ৰজস্যাধ্যক্ষন্ আত্মা যুষ্মান্ ৱিধায ন্যযুঙ্ক্ত তৎসৰ্ৱ্ৱস্মিন্ সাৱধানা ভৱত, য সমাজঞ্চ প্ৰভু ৰ্নিজৰক্তমূল্যেন ক্ৰীতৱান তম্ অৱত, ");
INSERT INTO sanasm_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","যতো মযা গমনে কৃতএৱ দুৰ্জযা ৱৃকা যুষ্মাকং মধ্যং প্ৰৱিশ্য ৱ্ৰজং প্ৰতি নিৰ্দযতাম্ আচৰিষ্যন্তি, ");
INSERT INTO sanasm_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","যুষ্মাকমেৱ মধ্যাদপি লোকা উত্থায শিষ্যগণম্ অপহন্তুং ৱিপৰীতম্ উপদেক্ষ্যন্তীত্যহং জানামি| ");
INSERT INTO sanasm_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","ইতি হেতো ৰ্যূযং সচৈতন্যাঃ সন্তস্তিষ্টত, অহঞ্চ সাশ্ৰুপাতঃ সন্ ৱৎসৰত্ৰযং যাৱদ্ দিৱানিশং প্ৰতিজনং বোধযিতুং ন ন্যৱৰ্ত্তে তদপি স্মৰত| ");
INSERT INTO sanasm_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","ইদানীং হে ভ্ৰাতৰো যুষ্মাকং নিষ্ঠাং জনযিতুং পৱিত্ৰীকৃতলোকানাং মধ্যেঽধিকাৰঞ্চ দাতুং সমৰ্থো য ঈশ্ৱৰস্তস্যানুগ্ৰহস্য যো ৱাদশ্চ তযোৰুভযো ৰ্যুষ্মান্ সমাৰ্পযম্| ");
INSERT INTO sanasm_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","কস্যাপি স্ৱৰ্ণং ৰূপ্যং ৱস্ত্ৰং ৱা প্ৰতি মযা লোভো ন কৃতঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","কিন্তু মম মৎসহচৰলোকানাঞ্চাৱশ্যকৱ্যযায মদীযমিদং কৰদ্ৱযম্ অশ্ৰাম্যদ্ এতদ্ যূযং জানীথ| ");
INSERT INTO sanasm_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","অনেন প্ৰকাৰেণ গ্ৰহণদ্ দানং ভদ্ৰমিতি যদ্ৱাক্যং প্ৰভু ৰ্যীশুঃ কথিতৱান্ তৎ স্মৰ্ত্তুং দৰিদ্ৰলোকানামুপকাৰাৰ্থং শ্ৰমং কৰ্ত্তুঞ্চ যুষ্মাকম্ উচিতম্ এতৎসৰ্ৱ্ৱং যুষ্মানহম্ উপদিষ্টৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","এতাং কথাং কথযিৎৱা স জানুনী পাতযিৎৱা সৰ্ৱৈঃ সহ প্ৰাৰ্থযত| ");
INSERT INTO sanasm_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","তেন তে ক্ৰন্দ্ৰন্তঃ ");
INSERT INTO sanasm_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","পুন ৰ্মম মুখং ন দ্ৰক্ষ্যথ ৱিশেষত এষা যা কথা তেনাকথি তৎকাৰণাৎ শোকং ৱিলাপঞ্চ কৃৎৱা কণ্ঠং ধৃৎৱা চুম্বিতৱন্তঃ| পশ্চাৎ তে তং পোতং নীতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","তৈ ৰ্ৱিসৃষ্টাঃ সন্তো ৱযং পোতং বাহযিৎৱা ঋজুমাৰ্গেণ কোষম্ উপদ্ৱীপম্ আগত্য পৰেঽহনি ৰোদিযোপদ্ৱীপম্ আগচ্ছাম ততস্তস্মাৎ পাতাৰাযাম্ উপাতিষ্ঠাম| ");
INSERT INTO sanasm_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","তত্ৰ ফৈনীকিযাদেশগামিনম্ পোতমেকং প্ৰাপ্য তমাৰুহ্য গতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","কুপ্ৰোপদ্ৱীপং দৃষ্ট্ৱা তং সৱ্যদিশি স্থাপযিৎৱা সুৰিযাদেশং গৎৱা পোতস্থদ্ৰৱ্যাণ্যৱৰোহযিতুং সোৰনগৰে লাগিতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","তত্ৰ শিষ্যগণস্য সাক্ষাৎকৰণায ৱযং তত্ৰ সপ্তদিনানি স্থিতৱন্তঃ পশ্চাত্তে পৱিত্ৰেণাত্মনা পৌলং ৱ্যাহৰন্ ৎৱং যিৰূশালম্নগৰং মা গমঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","ততস্তেষু সপ্তসু দিনেষু যাপিতেষু সৎসু ৱযং তস্মাৎ স্থানাৎ নিজৱৰ্ত্মনা গতৱন্তঃ, তস্মাৎ তে সবালৱৃদ্ধৱনিতা অস্মাভিঃ সহ নগৰস্য পৰিসৰপৰ্য্যন্তম্ আগতাঃ পশ্চাদ্ৱযং জলধিতটে জানুপাতং প্ৰাৰ্থযামহি| ");
INSERT INTO sanasm_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ততঃ পৰস্পৰং ৱিসৃষ্টাঃ সন্তো ৱযং পোতং গতাস্তে তু স্ৱস্ৱগৃহং প্ৰত্যাগতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","ৱযং সোৰনগৰাৎ নাৱা প্ৰস্থায তলিমাযিনগৰম্ উপাতিষ্ঠাম তত্ৰাস্মাকং সমুদ্ৰীযমাৰ্গস্যান্তোঽভৱৎ তত্ৰ ভ্ৰাতৃগণং নমস্কৃত্য দিনমেকং তৈঃ সাৰ্দ্ধম্ উষতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","পৰে ঽহনি পৌলস্তস্য সঙ্গিনো ৱযঞ্চ প্ৰতিষ্ঠমানাঃ কৈসৰিযানগৰম্ আগত্য সুসংৱাদপ্ৰচাৰকানাং সপ্তজনানাং ফিলিপনাম্ন একস্য গৃহং প্ৰৱিশ্যাৱতিষ্ঠাম| ");
INSERT INTO sanasm_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","তস্য চতস্ৰো দুহিতৰোঽনূঢা ভৱিষ্যদ্ৱাদিন্য আসন্| ");
INSERT INTO sanasm_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","তত্ৰাস্মাসু বহুদিনানি প্ৰোষিতেষু যিহূদীযদেশাদ্ আগত্যাগাবনামা ভৱিষ্যদ্ৱাদী সমুপস্থিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","সোস্মাকং সমীপমেত্য পৌলস্য কটিবন্ধনং গৃহীৎৱা নিজহস্তাপাদান্ বদ্ধ্ৱা ভাষিতৱান্ যস্যেদং কটিবন্ধনং তং যিহূদীযলোকা যিৰূশালমনগৰ ইত্থং বদ্ধ্ৱা ভিন্নদেশীযানাং কৰেষু সমৰ্পযিষ্যন্তীতি ৱাক্যং পৱিত্ৰ আত্মা কথযতি| ");
INSERT INTO sanasm_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","এতাদৃশীং কথাং শ্ৰুৎৱা ৱযং তন্নগৰৱাসিনো ভ্ৰাতৰশ্চ যিৰূশালমং ন যাতুং পৌলং ৱ্যনযামহি; ");
INSERT INTO sanasm_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","কিন্তু স প্ৰত্যাৱাদীৎ, যূযং কিং কুৰুথ? কিং ক্ৰন্দনেন মমান্তঃকৰণং ৱিদীৰ্ণং কৰিষ্যথ? প্ৰভো ৰ্যীশো ৰ্নাম্নো নিমিত্তং যিৰূশালমি বদ্ধো ভৱিতুং কেৱল তন্ন প্ৰাণান্ দাতুমপি সসজ্জোস্মি| ");
INSERT INTO sanasm_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","তেনাস্মাকং কথাযাম্ অগৃহীতাযাম্ ঈশ্ৱৰস্য যথেচ্ছা তথৈৱ ভৱৎৱিত্যুক্ত্ৱা ৱযং নিৰস্যাম| ");
INSERT INTO sanasm_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","পৰেঽহনি পাথেযদ্ৰৱ্যাণি গৃহীৎৱা যিৰূশালমং প্ৰতি যাত্ৰাম্ অকুৰ্ম্ম| ");
INSERT INTO sanasm_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","ততঃ কৈসৰিযানগৰনিৱাসিনঃ কতিপযাঃ শিষ্যা অস্মাভিঃ সাৰ্দ্ধম্ ইৎৱা কৃপ্ৰীযেন ম্নাসন্নাম্না যেন প্ৰাচীনশিষ্যেন সাৰ্দ্ধম্ অস্মাভি ৰ্ৱস্তৱ্যং তস্য সমীপম্ অস্মান্ নীতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","অস্মাসু যিৰূশালম্যুপস্থিতেষু তত্ৰস্থভ্ৰাতৃগণোঽস্মান্ আহ্লাদেন গৃহীতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","পৰস্মিন্ দিৱসে পৌলেঽস্মাভিঃ সহ যাকূবো গৃহং প্ৰৱিষ্টে লোকপ্ৰাচীনাঃ সৰ্ৱ্ৱে তত্ৰ পৰিষদি সংস্থিতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","অনন্তৰং স তান্ নৎৱা স্ৱীযপ্ৰচাৰণেন ভিন্নদেশীযান্ প্ৰতীশ্ৱৰো যানি কৰ্ম্মাণি সাধিতৱান্ তদীযাং কথাম্ অনুক্ৰমাৎ কথিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ইতি শ্ৰুৎৱা তে প্ৰভুং ধন্যং প্ৰোচ্য ৱাক্যমিদম্ অভাষন্ত, হে ভ্ৰাত ৰ্যিহূদীযানাং মধ্যে বহুসহস্ৰাণি লোকা ৱিশ্ৱাসিন আসতে কিন্তু তে সৰ্ৱ্ৱে ৱ্যৱস্থামতাচাৰিণ এতৎ প্ৰত্যক্ষং পশ্যসি| ");
INSERT INTO sanasm_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","শিশূনাং ৎৱক্ছেদনাদ্যাচৰণং প্ৰতিষিধ্য ৎৱং ভিন্নদেশনিৱাসিনো যিহূদীযলোকান্ মূসাৱাক্যম্ অশ্ৰদ্ধাতুম্ উপদিশসীতি তৈঃ শ্ৰুতমস্তি| ");
INSERT INTO sanasm_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","ৎৱমত্ৰাগতোসীতি ৱাৰ্ত্তাং সমাকৰ্ণ্য জননিৱহো মিলিৎৱাৱশ্যমেৱাগমিষ্যতি; অতএৱ কিং কৰণীযম্? অত্ৰ ৱযং মন্ত্ৰযিৎৱা সমুপাযং ৎৱাং ৱদামস্তং ৎৱমাচৰ| ");
INSERT INTO sanasm_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","ৱ্ৰতং কৰ্ত্তুং কৃতসঙ্কল্পা যেঽস্মাংক চৎৱাৰো মানৱাঃ সন্তি ");
INSERT INTO sanasm_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","তান্ গৃহীৎৱা তৈঃ সহিতঃ স্ৱং শুচিং কুৰু তথা তেষাং শিৰোমুণ্ডনে যো ৱ্যযো ভৱতি তং ৎৱং দেহি| তথা কৃতে ৎৱদীযাচাৰে যা জনশ্ৰুতি ৰ্জাযতে সালীকা কিন্তু ৎৱং ৱিধিং পালযন্ ৱ্যৱস্থানুসাৰেণেৱাচৰসীতি তে ভোৎসন্তে| ");
INSERT INTO sanasm_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","ভিন্নদেশীযানাং ৱিশ্ৱাসিলোকানাং নিকটে ৱযং পত্ৰং লিখিৎৱেত্থং স্থিৰীকৃতৱন্তঃ, দেৱপ্ৰসাদভোজনং ৰক্তং গলপীডনমাৰিতপ্ৰাণিভোজনং ৱ্যভিচাৰশ্চৈতেভ্যঃ স্ৱৰক্ষণৱ্যতিৰেকেণ তেষামন্যৱিধিপালনং কৰণীযং ন| ");
INSERT INTO sanasm_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","ততঃ পৌলস্তান্ মানুষানাদায পৰস্মিন্ দিৱসে তৈঃ সহ শুচি ৰ্ভূৎৱা মন্দিৰং গৎৱা শৌচকৰ্ম্মণো দিনেষু সম্পূৰ্ণেষু তেষাম্ একৈকাৰ্থং নৈৱেদ্যাদ্যুৎসৰ্গো ভৱিষ্যতীতি জ্ঞাপিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","তেষু সপ্তসু দিনেষু সমাপ্তকল্পেষু আশিযাদেশনিৱাসিনো যিহূদীযাস্তং মধ্যেমন্দিৰং ৱিলোক্য জননিৱহস্য মনঃসু কুপ্ৰৱৃত্তিং জনযিৎৱা তং ধৃৎৱা ");
INSERT INTO sanasm_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","প্ৰোচ্চৈঃ প্ৰাৱোচন্, হে ইস্ৰাযেল্লোকাঃ সৰ্ৱ্ৱে সাহায্যং কুৰুত| যো মনুজ এতেষাং লোকানাং মূসাৱ্যৱস্থাযা এতস্য স্থানস্যাপি ৱিপৰীতং সৰ্ৱ্ৱত্ৰ সৰ্ৱ্ৱান্ শিক্ষযতি স এষঃ; ৱিশেষতঃ স ভিন্নদেশীযলোকান্ মন্দিৰম্ আনীয পৱিত্ৰস্থানমেতদ্ অপৱিত্ৰমকৰোৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","পূৰ্ৱ্ৱং তে মধ্যেনগৰম্ ইফিষনগৰীযং ত্ৰফিমং পৌলেন সহিতং দৃষ্টৱন্ত এতস্মাৎ পৌলস্তং মন্দিৰমধ্যম্ আনযদ্ ইত্যন্ৱমিমত| ");
INSERT INTO sanasm_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","অতএৱ সৰ্ৱ্ৱস্মিন্ নগৰে কলহোৎপন্নৎৱাৎ ধাৱন্তো লোকা আগত্য পৌলং ধৃৎৱা মন্দিৰস্য বহিৰাকৃষ্যানযন্ তৎক্ষণাদ্ দ্ৱাৰাণি সৰ্ৱ্ৱাণি চ ৰুদ্ধানি| ");
INSERT INTO sanasm_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","তেষু তং হন্তুমুদ্যতেेষু যিৰূশালম্নগৰে মহানুপদ্ৰৱো জাত ইতি ৱাৰ্ত্তাযাং সহস্ৰসেনাপতেঃ কৰ্ণগোচৰীভূতাযাং সত্যাং স তৎক্ষণাৎ সৈন্যানি সেনাপতিগণঞ্চ গৃহীৎৱা জৱেনাগতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","ততো লোকাঃ সেনাগণেন সহ সহস্ৰসেনাপতিম্ আগচ্ছন্তং দৃষ্ট্ৱা পৌলতাডনাতো ন্যৱৰ্ত্তন্ত| ");
INSERT INTO sanasm_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","স সহস্ৰসেনাপতিঃ সন্নিধাৱাগম্য পৌলং ধৃৎৱা শৃঙ্খলদ্ৱযেন বদ্ধম্ আদিশ্য তান্ পৃষ্টৱান্ এষ কঃ? কিং কৰ্ম্ম চাযং কৃতৱান্? ");
INSERT INTO sanasm_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","ততো জনসমূহস্য কশ্চিদ্ একপ্ৰকাৰং কশ্চিদ্ অন্যপ্ৰকাৰং ৱাক্যম্ অৰৌৎ স তত্ৰ সত্যং জ্ঞাতুম্ কলহকাৰণাদ্ অশক্তঃ সন্ তং দুৰ্গং নেতুম্ আজ্ঞাপযৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","তেষু সোপানস্যোপৰি প্ৰাপ্তেষু লোকানাং সাহসকাৰণাৎ সেনাগণঃ পৌলমুত্তোল্য নীতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ততঃ সৰ্ৱ্ৱে লোকাঃ পশ্চাদ্গামিনঃ সন্ত এনং দুৰীকুৰুতেতি ৱাক্যম্ উচ্চৈৰৱদন্| ");
INSERT INTO sanasm_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","পৌলস্য দুৰ্গানযনসমযে স তস্মৈ সহস্ৰসেনাপতযে কথিতৱান্, ভৱতঃ পুৰস্তাৎ কথাং কথযিতুং কিম্ অনুমন্যতে? স তমপৃচ্ছৎ ৎৱং কিং যূনানীযাং ভাষাং জানাসি? ");
INSERT INTO sanasm_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","যো মিসৰীযো জনঃ পূৰ্ৱ্ৱং ৱিৰোধং কৃৎৱা চৎৱাৰি সহস্ৰাণি ঘাতকান্ সঙ্গিনঃ কৃৎৱা ৱিপিনং গতৱান্ ৎৱং কিং সএৱ ন ভৱসি? ");
INSERT INTO sanasm_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","তদা পৌলোঽকথযৎ অহং কিলিকিযাদেশস্য তাৰ্ষনগৰীযো যিহূদীযো, নাহং সামান্যনগৰীযো মানৱঃ; অতএৱ ৱিনযেঽহং লাকানাং সমক্ষং কথাং কথযিতুং মামনুজানীষ্ৱ| ");
INSERT INTO sanasm_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","তেনানুজ্ঞাতঃ পৌলঃ সোপানোপৰি তিষ্ঠন্ হস্তেনেঙ্গিতং কৃতৱান্, তস্মাৎ সৰ্ৱ্ৱে সুস্থিৰা অভৱন্| তদা পৌল ইব্ৰীযভাষযা কথযিতুম্ আৰভত, ");
INSERT INTO sanasm_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","হে পিতৃগণা হে ভ্ৰাতৃগণাঃ, ইদানীং মম নিৱেদনে সমৱধত্ত| ");
INSERT INTO sanasm_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","তদা স ইব্ৰীযভাষযা কথাং কথযতীতি শ্ৰুৎৱা সৰ্ৱ্ৱে লোকা অতীৱ নিঃশব্দা সন্তোঽতিষ্ঠন্| ");
INSERT INTO sanasm_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","পশ্চাৎ সোঽকথযদ্ অহং যিহূদীয ইতি নিশ্চযঃ কিলিকিযাদেশস্য তাৰ্ষনগৰং মম জন্মভূমিঃ,এতন্নগৰীযস্য গমিলীযেলনাম্নোঽধ্যাপকস্য শিষ্যো ভূৎৱা পূৰ্ৱ্ৱপুৰুষাণাং ৱিধিৱ্যৱস্থানুসাৰেণ সম্পূৰ্ণৰূপেণ শিক্ষিতোঽভৱম্ ইদানীন্তনা যূযং যাদৃশা ভৱথ তাদৃশোঽহমপীশ্ৱৰসেৱাযাম্ উদ্যোগী জাতঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","মতমেতদ্ দ্ৱিষ্ট্ৱা তদ্গ্ৰাহিনাৰীপুৰুষান্ কাৰাযাং বদ্ধ্ৱা তেষাং প্ৰাণনাশপৰ্য্যন্তাং ৱিপক্ষতাম্ অকৰৱম্| ");
INSERT INTO sanasm_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","মহাযাজকঃ সভাসদঃ প্ৰাচীনলোকাশ্চ মমৈতস্যাঃ কথাযাঃ প্ৰমাণং দাতুং শক্নুৱন্তি, যস্মাৎ তেষাং সমীপাদ্ দম্মেষকনগৰনিৱাসিভ্ৰাতৃগণাৰ্থম্ আজ্ঞাপত্ৰাণি গৃহীৎৱা যে তত্ৰ স্থিতাস্তান্ দণ্ডযিতুং যিৰূশালমম্ আনযনাৰ্থং দম্মেষকনগৰং গতোস্মি| ");
INSERT INTO sanasm_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","কিন্তু গচ্ছন্ তন্নগৰস্য সমীপং প্ৰাপ্তৱান্ তদা দ্ৱিতীযপ্ৰহৰৱেলাযাং সত্যাম্ অকস্মাদ্ গগণান্নিৰ্গত্য মহতী দীপ্তি ৰ্মম চতুৰ্দিশি প্ৰকাশিতৱতী| ");
INSERT INTO sanasm_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ততো মযি ভূমৌै পতিতে সতি, হে শৌল হে শৌল কুতো মাং তাডযসি? মাম্প্ৰতি ভাষিত এতাদৃশ একো ৰৱোপি মযা শ্ৰুতঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","তদাহং প্ৰত্যৱদং, হে প্ৰভে কো ভৱান্? ততঃ সোঽৱাদীৎ যং ৎৱং তাডযসি স নাসৰতীযো যীশুৰহং| ");
INSERT INTO sanasm_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","মম সঙ্গিনো লোকাস্তাং দীপ্তিং দৃষ্ট্ৱা ভিযং প্ৰাপ্তাঃ, কিন্তু মাম্প্ৰত্যুদিতং তদ্ৱাক্যং তেे নাবুধ্যন্ত| ");
INSERT INTO sanasm_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","ততঃ পৰং পৃষ্টৱানহং, হে প্ৰভো মযা কিং কৰ্ত্তৱ্যং? ততঃ প্ৰভুৰকথযৎ, উত্থায দম্মেষকনগৰং যাহি ৎৱযা যদ্যৎ কৰ্ত্তৱ্যং নিৰূপিতমাস্তে তৎ তত্ৰ ৎৱং জ্ঞাপযিষ্যসে| ");
INSERT INTO sanasm_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","অনন্তৰং তস্যাঃ খৰতৰদীপ্তেঃ কাৰণাৎ কিমপি ন দৃষ্ট্ৱা সঙ্গিগণেন ধৃতহস্তঃ সন্ দম্মেষকনগৰং ৱ্ৰজিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","তন্নগৰনিৱাসিনাং সৰ্ৱ্ৱেষাং যিহূদীযানাং মান্যো ৱ্যৱস্থানুসাৰেণ ভক্তশ্চ হনানীযনামা মানৱ একো ");
INSERT INTO sanasm_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","মম সন্নিধিম্ এত্য তিষ্ঠন্ অকথযৎ, হে ভ্ৰাতঃ শৌল সুদৃষ্টি ৰ্ভৱ তস্মিন্ দণ্ডেঽহং সম্যক্ তং দৃষ্টৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","ততঃ স মহ্যং কথিতৱান্ যথা ৎৱম্ ঈশ্ৱৰস্যাভিপ্ৰাযং ৱেৎসি তস্য শুদ্ধসত্ত্ৱজনস্য দৰ্শনং প্ৰাপ্য তস্য শ্ৰীমুখস্য ৱাক্যং শৃণোষি তন্নিমিত্তম্ অস্মাকং পূৰ্ৱ্ৱপুৰুষাণাম্ ঈশ্ৱৰস্ত্ৱাং মনোনীতং কৃতৱানং| ");
INSERT INTO sanasm_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","যতো যদ্যদ্ অদ্ৰাক্ষীৰশ্ৰৌষীশ্চ সৰ্ৱ্ৱেষাং মানৱানাং সমীপে ৎৱং তেষাং সাক্ষী ভৱিষ্যসি| ");
INSERT INTO sanasm_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","অতএৱ কুতো ৱিলম্বসে? প্ৰভো ৰ্নাম্না প্ৰাৰ্থ্য নিজপাপপ্ৰক্ষালনাৰ্থং মজ্জনায সমুত্তিষ্ঠ| ");
INSERT INTO sanasm_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","ততঃ পৰং যিৰূশালম্নগৰং প্ৰত্যাগত্য মন্দিৰেঽহম্ একদা প্ৰাৰ্থযে, তস্মিন্ সমযেঽহম্ অভিভূতঃ সন্ প্ৰভূং সাক্ষাৎ পশ্যন্, ");
INSERT INTO sanasm_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ৎৱং ৎৱৰযা যিৰূশালমঃ প্ৰতিষ্ঠস্ৱ যতো লোকামযি তৱ সাক্ষ্যং ন গ্ৰহীষ্যন্তি, মাম্প্ৰত্যুদিতং তস্যেদং ৱাক্যম্ অশ্ৰৌষম্| ");
INSERT INTO sanasm_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","ততোহং প্ৰত্যৱাদিষম্ হে প্ৰভো প্ৰতিভজনভৱনং ৎৱযি ৱিশ্ৱাসিনো লোকান্ বদ্ধ্ৱা প্ৰহৃতৱান্, ");
INSERT INTO sanasm_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","তথা তৱ সাক্ষিণঃ স্তিফানস্য ৰক্তপাতনসমযে তস্য ৱিনাশং সম্মন্য সন্নিধৌ তিষ্ঠন্ হন্তৃলোকানাং ৱাসাংসি ৰক্ষিতৱান্, এতৎ তে ৱিদুঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","ততঃ সোঽকথযৎ প্ৰতিষ্ঠস্ৱ ৎৱাং দূৰস্থভিন্নদেশীযানাং সমীপং প্ৰেষযিষ্যে| ");
INSERT INTO sanasm_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","তদা লোকা এতাৱৎপৰ্য্যন্তাং তদীযাং কথাং শ্ৰুৎৱা প্ৰোচ্চৈৰকথযন্, এনং ভূমণ্ডলাদ্ দূৰীকুৰুত, এতাদৃশজনস্য জীৱনং নোচিতম্| ");
INSERT INTO sanasm_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ইত্যুচ্চৈঃ কথযিৎৱা ৱসনানি পৰিত্যজ্য গগণং প্ৰতি ধূলীৰক্ষিপন্ ");
INSERT INTO sanasm_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ততঃ সহস্ৰসেনাপতিঃ পৌলং দুৰ্গাভ্যন্তৰ নেতুং সমাদিশৎ| এতস্য প্ৰতিকূলাঃ সন্তো লোকাঃ কিন্নিমিত্তম্ এতাৱদুচ্চৈঃস্ৱৰম্ অকুৰ্ৱ্ৱন্, এতদ্ ৱেত্তুং তং কশযা প্ৰহৃত্য তস্য পৰীক্ষাং কৰ্ত্তুমাদিশৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","পদাতযশ্চৰ্ম্মনিৰ্ম্মিতৰজ্জুভিস্তস্য বন্ধনং কৰ্ত্তুমুদ্যতাস্তাস্তদানীং পৌলঃ সম্মুখস্থিতং শতসেনাপতিম্ উক্তৱান্ দণ্ডাজ্ঞাযাম্ অপ্ৰাপ্তাযাং কিং ৰোমিলোকং প্ৰহৰ্ত্তুং যুষ্মাকম্ অধিকাৰোস্তি? ");
INSERT INTO sanasm_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","এনাং কথাং শ্ৰুৎৱা স সহস্ৰসেনাপতেঃ সন্নিধিং গৎৱা তাং ৱাৰ্ত্তামৱদৎ স ৰোমিলোক এতস্মাৎ সাৱধানঃ সন্ কৰ্ম্ম কুৰু| ");
INSERT INTO sanasm_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","তস্মাৎ সহস্ৰসেনাপতি ৰ্গৎৱা তমপ্ৰাক্ষীৎ ৎৱং কিং ৰোমিলোকঃ? ইতি মাং ব্ৰূহি| সোঽকথযৎ সত্যম্| ");
INSERT INTO sanasm_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","ততঃ সহস্ৰসেনাপতিঃ কথিতৱান্ বহুদ্ৰৱিণং দত্ত্ৱাহং তৎ পৌৰসখ্যং প্ৰাপ্তৱান্; কিন্তু পৌলঃ কথিতৱান্ অহং জনুনা তৎ প্ৰাপ্তোঽস্মি| ");
INSERT INTO sanasm_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","ইত্থং সতি যে প্ৰহাৰেণ তং পৰীক্ষিতুং সমুদ্যতা আসন্ তে তস্য সমীপাৎ প্ৰাতিষ্ঠন্ত; সহস্ৰসেনাপতিস্তং ৰোমিলোকং ৱিজ্ঞায স্ৱযং যৎ তস্য বন্ধনম্ অকাৰ্ষীৎ তৎকাৰণাদ্ অবিভেৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","যিহূদীযলোকাঃ পৌলং কুতোঽপৱদন্তে তস্য ৱৃত্তান্তং জ্ঞাতুং ৱাঞ্ছন্ সহস্ৰসেনাপতিঃ পৰেঽহনি পৌলং বন্ধনাৎ মোচযিৎৱা প্ৰধানযাজকান্ মহাসভাযাঃ সৰ্ৱ্ৱলোকাশ্চ সমুপস্থাতুম্ আদিশ্য তেষাং সন্নিধৌ পৌলম্ অৱৰোহ্য স্থাপিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","সভাসদ্লোকান্ প্ৰতি পৌলোঽনন্যদৃষ্ট্যা পশ্যন্ অকথযৎ, হে ভ্ৰাতৃগণা অদ্য যাৱৎ সৰলেন সৰ্ৱ্ৱান্তঃকৰণেনেশ্ৱৰস্য সাক্ষাদ্ আচৰামি| ");
INSERT INTO sanasm_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","অনেন হনানীযনামা মহাযাজকস্তং কপোলে চপেটেনাহন্তুং সমীপস্থলোকান্ আদিষ্টৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","তদা পৌলস্তমৱদৎ, হে বহিষ্পৰিষ্কৃত, ঈশ্ৱৰস্ত্ৱাং প্ৰহৰ্ত্তুম্ উদ্যতোস্তি, যতো ৱ্যৱস্থানুসাৰেণ ৱিচাৰযিতুম্ উপৱিশ্য ৱ্যৱস্থাং লঙ্ঘিৎৱা মাং প্ৰহৰ্ত্তুম্ আজ্ঞাপযসি| ");
INSERT INTO sanasm_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","ততো নিকটস্থা লোকা অকথযন্, ৎৱং কিম্ ঈশ্ৱৰস্য মহাযাজকং নিন্দসি? ");
INSERT INTO sanasm_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","ততঃ পৌলঃ প্ৰতিভাষিতৱান্ হে ভ্ৰাতৃগণ মহাযাজক এষ ইতি ন বুদ্ধং মযা তদন্যচ্চ স্ৱলোকানাম্ অধিপতিং প্ৰতি দুৰ্ৱ্ৱাক্যং মা কথয, এতাদৃশী লিপিৰস্তি| ");
INSERT INTO sanasm_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","অনন্তৰং পৌলস্তেষাম্ অৰ্দ্ধং সিদূকিলোকা অৰ্দ্ধং ফিৰূশিলোকা ইতি দৃষ্ট্ৱা প্ৰোচ্চৈঃ সভাস্থলোকান্ অৱদৎ হে ভ্ৰাতৃগণ অহং ফিৰূশিমতাৱলম্বী ফিৰূশিনঃ সত্নানশ্চ, মৃতলোকানাম্ উত্থানে প্ৰত্যাশাকৰণাদ্ অহমপৱাদিতোস্মি| ");
INSERT INTO sanasm_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","ইতি কথাযাং কথিতাযাং ফিৰূশিসিদূকিনোঃ পৰস্পৰং ভিন্নৱাক্যৎৱাৎ সভাযা মধ্যে দ্ৱৌ সংঘৌ জাতৌ| ");
INSERT INTO sanasm_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","যতঃ সিদূকিলোকা উত্থানং স্ৱৰ্গীযদূতা আত্মানশ্চ সৰ্ৱ্ৱেষাম্ এতেষাং কমপি ন মন্যন্তে, কিন্তু ফিৰূশিনঃ সৰ্ৱ্ৱম্ অঙ্গীকুৰ্ৱ্ৱন্তি| ");
INSERT INTO sanasm_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","ততঃ পৰস্পৰম্ অতিশযকোলাহলে সমুপস্থিতে ফিৰূশিনাং পক্ষীযাঃ সভাস্থা অধ্যাপকাঃ প্ৰতিপক্ষা উত্তিষ্ঠন্তো ঽকথযন্, এতস্য মানৱস্য কমপি দোষং ন পশ্যামঃ; যদি কশ্চিদ্ আত্মা ৱা কশ্চিদ্ দূত এনং প্ৰত্যাদিশৎ তৰ্হি ৱযম্ ঈশ্ৱৰস্য প্ৰাতিকূল্যেন ন যোৎস্যামঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","তস্মাদ্ অতীৱ ভিন্নৱাক্যৎৱে সতি তে পৌলং খণ্ডং খণ্ডং কৰিষ্যন্তীত্যাশঙ্কযা সহস্ৰসেনাপতিঃ সেনাগণং তৎস্থানং যাতুং সভাতো বলাৎ পৌলং ধৃৎৱা দুৰ্গং নেতঞ্চাজ্ঞাপযৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","ৰাত্ৰো প্ৰভুস্তস্য সমীপে তিষ্ঠন্ কথিতৱান্ হে পৌল নিৰ্ভযো ভৱ যথা যিৰূশালম্নগৰে মযি সাক্ষ্যং দত্তৱান্ তথা ৰোমানগৰেপি ৎৱযা দাতৱ্যম্| ");
INSERT INTO sanasm_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","দিনে সমুপস্থিতে সতি কিযন্তো যিহূদীযলোকা একমন্ত্ৰণাঃ সন্তঃ পৌলং ন হৎৱা ভোজনপানে কৰিষ্যাম ইতি শপথেন স্ৱান্ অবধ্নন্| ");
INSERT INTO sanasm_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","চৎৱাৰিংশজ্জনেভ্যোঽধিকা লোকা ইতি পণম্ অকুৰ্ৱ্ৱন্| ");
INSERT INTO sanasm_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","তে মহাযাজকানাং প্ৰাচীনলোকানাঞ্চ সমীপং গৎৱা কথযন্, ৱযং পৌলং ন হৎৱা কিমপি ন ভোক্ষ্যামহে দৃঢেনানেন শপথেন বদ্ধ্ৱা অভৱাম| ");
INSERT INTO sanasm_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","অতএৱ সাম্প্ৰতং সভাসদ্লোকৈঃ সহ ৱযং তস্মিন্ কঞ্চিদ্ ৱিশেষৱিচাৰং কৰিষ্যামস্তদৰ্থং ভৱান্ শ্ৱো ঽস্মাকং সমীপং তম্ আনযৎৱিতি সহস্ৰসেনাপতযে নিৱেদনং কুৰুত তেন যুষ্মাকং সমীপং উপস্থিতেঃ পূৰ্ৱ্ৱং ৱযং তং হন্তু সজ্জিষ্যাম| ");
INSERT INTO sanasm_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","তদা পৌলস্য ভাগিনেযস্তেষামিতি মন্ত্ৰণাং ৱিজ্ঞায দুৰ্গং গৎৱা তাং ৱাৰ্ত্তাং পৌলম্ উক্তৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","তস্মাৎ পৌল একং শতসেনাপতিম্ আহূয ৱাক্যমিদম্ ভাষিতৱান্ সহস্ৰসেনাপতেঃ সমীপেঽস্য যুৱমনুষ্যস্য কিঞ্চিন্নিৱেদনম্ আস্তে, তস্মাৎ তৎসৱিধম্ এনং নয| ");
INSERT INTO sanasm_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","ততঃ স তমাদায সহস্ৰসেনাপতেঃ সমীপম্ উপস্থায কথিতৱান্, ভৱতঃ সমীপেঽস্য কিমপি নিৱেদনমাস্তে তস্মাৎ বন্দিঃ পৌলো মামাহূয ভৱতঃ সমীপম্ এনম্ আনেতুং প্ৰাৰ্থিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","তদা সহস্ৰসেনাপতিস্তস্য হস্তং ধৃৎৱা নিৰ্জনস্থানং নীৎৱা পৃষ্ঠৱান্ তৱ কিং নিৱেদনং? তৎ কথয| ");
INSERT INTO sanasm_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","ততঃ সোকথযৎ, যিহূদীযলাকাঃ পৌলে কমপি ৱিশেষৱিচাৰং ছলং কৃৎৱা তং সভাং নেতুং ভৱতঃ সমীপে নিৱেদযিতুং অমন্ত্ৰযন্| ");
INSERT INTO sanasm_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","কিন্তু মৱতা তন্ন স্ৱীকৰ্ত্তৱ্যং যতস্তেষাং মধ্যেৱৰ্ত্তিনশ্চৎৱাৰিংশজ্জনেভ্যো ঽধিকলোকা একমন্ত্ৰণা ভূৎৱা পৌলং ন হৎৱা ভোজনং পানঞ্চ ন কৰিষ্যাম ইতি শপথেন বদ্ধাঃ সন্তো ঘাতকা ইৱ সজ্জিতা ইদানীং কেৱলং ভৱতো ঽনুমতিম্ অপেক্ষন্তে| ");
INSERT INTO sanasm_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","যামিমাং কথাং ৎৱং নিৱেদিতৱান্ তাং কস্মৈচিদপি মা কথযেত্যুক্ত্ৱা সহস্ৰসেনাপতিস্তং যুৱানং ৱিসৃষ্টৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","অনন্তৰং সহস্ৰসেনাপতি ৰ্দ্ৱৌ শতসেনাপতী আহূযেদম্ আদিশৎ, যুৱাং ৰাত্ৰৌ প্ৰহৰৈকাৱশিষ্টাযাং সত্যাং কৈসৰিযানগৰং যাতুং পদাতিসৈন্যানাং দ্ৱে শতে ঘোটকাৰোহিসৈন্যানাং সপ্ততিং শক্তিধাৰিসৈন্যানাং দ্ৱে শতে চ জনান্ সজ্জিতান্ কুৰুতং| ");
INSERT INTO sanasm_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","পৌলম্ আৰোহযিতুং ফীলিক্ষাধিপতেঃ সমীপং নিৰ্ৱ্ৱিঘ্নং নেতুঞ্চ ৱাহনানি সমুপস্থাপযতং| ");
INSERT INTO sanasm_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","অপৰং স পত্ৰং লিখিৎৱা দত্তৱান্ তল্লিখিতমেতৎ, ");
INSERT INTO sanasm_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","মহামহিমশ্ৰীযুক্তফীলিক্ষাধিপতযে ক্লৌদিযলুষিযস্য নমস্কাৰঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","যিহূদীযলোকাঃ পূৰ্ৱ্ৱম্ এনং মানৱং ধৃৎৱা স্ৱহস্তৈ ৰ্হন্তুম্ উদ্যতা এতস্মিন্নন্তৰে সসৈন্যোহং তত্ৰোপস্থায এষ জনো ৰোমীয ইতি ৱিজ্ঞায তং ৰক্ষিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","কিন্নিমিত্তং তে তমপৱদন্তে তজ্জ্ঞাতুং তেষা সভাং তমানাযিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","ততস্তেষাং ৱ্যৱস্থাযা ৱিৰুদ্ধযা কযাচন কথযা সোঽপৱাদিতোঽভৱৎ, কিন্তু স শৃঙ্খলবন্ধনাৰ্হো ৱা প্ৰাণনাশাৰ্হো ভৱতীদৃশঃ কোপ্যপৰাধো মযাস্য ন দৃষ্টঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","তথাপি মনুষ্যস্যাস্য ৱধাৰ্থং যিহূদীযা ঘাতকাইৱ সজ্জিতা এতাং ৱাৰ্ত্তাং শ্ৰুৎৱা তৎক্ষণাৎ তৱ সমীপমেনং প্ৰেষিতৱান্ অস্যাপৱাদকাংশ্চ তৱ সমীপং গৎৱাপৱদিতুম্ আজ্ঞাপযম্| ভৱতঃ কুশলং ভূযাৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","সৈন্যগণ আজ্ঞানুসাৰেণ পৌলং গৃহীৎৱা তস্যাং ৰজন্যাম্ আন্তিপাত্ৰিনগৰম্ আনযৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","পৰেঽহনি তেন সহ যাতুং ঘোটকাৰূঢসৈন্যগণং স্থাপযিৎৱা পৰাৱৃত্য দুৰ্গং গতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","ততঃ পৰে ঘোটকাৰোহিসৈন্যগণঃ কৈসৰিযানগৰম্ উপস্থায তৎপত্ৰম্ অধিপতেঃ কৰে সমৰ্প্য তস্য সমীপে পৌলম্ উপস্থাপিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","তদাধিপতিস্তৎপত্ৰং পঠিৎৱা পৃষ্ঠৱান্ এষ কিম্প্ৰদেশীযো জনঃ? স কিলিকিযাপ্ৰদেশীয একো জন ইতি জ্ঞাৎৱা কথিতৱান্, ");
INSERT INTO sanasm_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","তৱাপৱাদকগণ আগতে তৱ কথাং শ্ৰোষ্যামি| হেৰোদ্ৰাজগৃহে তং স্থাপযিতুম্ আদিষ্টৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","পঞ্চভ্যো দিনেভ্যঃ পৰং হনানীযনামা মহাযাজকোঽধিপতেঃ সমক্ষং পৌলস্য প্ৰাতিকূল্যেন নিৱেদযিতুং তৰ্তুল্লনামানং কঞ্চন ৱক্তাৰং প্ৰাচীনজনাংশ্চ সঙ্গিনঃ কৃৎৱা কৈসৰিযানগৰম্ আগচ্ছৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","ততঃ পৌলে সমানীতে সতি তৰ্তুল্লস্তস্যাপৱাদকথাং কথযিতুম্ আৰভত হে মহামহিমফীলিক্ষ ভৱতো ৱযম্ অতিনিৰ্ৱ্ৱিঘ্নং কালং যাপযামো ভৱতঃ পৰিণামদৰ্শিতযা এতদ্দেশীযানাং বহূনি মঙ্গলানি ঘটিতানি, ");
INSERT INTO sanasm_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","ইতি হেতো ৰ্ৱযমতিকৃতজ্ঞাঃ সন্তঃ সৰ্ৱ্ৱত্ৰ সৰ্ৱ্ৱদা ভৱতো গুণান্ গাযমঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","কিন্তু বহুভিঃ কথাভি ৰ্ভৱন্তং যেন ন ৱিৰঞ্জযামি তস্মাদ্ ৱিনযে ভৱান্ বনুকম্প্য মদল্পকথাং শৃণোতু| ");
INSERT INTO sanasm_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","এষ মহামাৰীস্ৱৰূপো নাসৰতীযমতগ্ৰাহিসংঘাতস্য মুখ্যো ভূৎৱা সৰ্ৱ্ৱদেশেষু সৰ্ৱ্ৱেষাং যিহূদীযানাং ৰাজদ্ৰোহাচৰণপ্ৰৱৃত্তিং জনযতীত্যস্মাভি ৰ্নিশ্চিতং| ");
INSERT INTO sanasm_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","স মন্দিৰমপি অশুচি কৰ্ত্তুং চেষ্টিতৱান্; ইতি কাৰণাদ্ ৱযম্ এনং ধৃৎৱা স্ৱৱ্যৱস্থানুসাৰেণ ৱিচাৰযিতুং প্ৰাৱৰ্ত্তামহি; ");
INSERT INTO sanasm_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","কিন্তু লুষিযঃ সহস্ৰসেনাপতিৰাগত্য বলাদ্ অস্মাকং কৰেভ্য এনং গৃহীৎৱা ");
INSERT INTO sanasm_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","এতস্যাপৱাদকান্ ভৱতঃ সমীপম্ আগন্তুম্ আজ্ঞাপযৎ| ৱযং যস্মিন্ তমপৱাদামো ভৱতা পদপৱাদকথাযাং ৱিচাৰিতাযাং সত্যাং সৰ্ৱ্ৱং ৱৃত্তান্তং ৱেদিতুং শক্ষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","ততো যিহূদীযা অপি স্ৱীকৃত্য কথিতৱন্ত এষা কথা প্ৰমাণম্| ");
INSERT INTO sanasm_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","অধিপতৌ কথাং কথযিতুং পৌলং প্ৰতীঙ্গিতং কৃতৱতি স কথিতৱান্ ভৱান্ বহূন্ ৱৎসৰান্ যাৱদ্ এতদ্দেশস্য শাসনং কৰোতীতি ৱিজ্ঞায প্ৰত্যুত্তৰং দাতুম্ অক্ষোভোঽভৱম্| ");
INSERT INTO sanasm_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","অদ্য কেৱলং দ্ৱাদশ দিনানি যাতানি, অহম্ আৰাধনাং কৰ্ত্তুং যিৰূশালমনগৰং গতৱান্ এষা কথা ভৱতা জ্ঞাতুং শক্যতে; ");
INSERT INTO sanasm_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","কিন্ত্ৱিভে মাং মধ্যেমন্দিৰং কেনাপি সহ ৱিতণ্ডাং কুৰ্ৱ্ৱন্তং কুত্ৰাপি ভজনভৱনে নগৰে ৱা লোকান্ কুপ্ৰৱৃত্তিং জনযন্তুং ন দৃষ্টৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","ইদানীং যস্মিন্ যস্মিন্ মাম্ অপৱদন্তে তস্য কিমপি প্ৰমাণং দাতুং ন শক্নুৱন্তি| ");
INSERT INTO sanasm_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","কিন্তু ভৱিষ্যদ্ৱাক্যগ্ৰন্থে ৱ্যৱস্থাগ্ৰন্থে চ যা যা কথা লিখিতাস্তে তাসু সৰ্ৱ্ৱাসু ৱিশ্ৱস্য যন্মতম্ ইমে ৱিধৰ্ম্মং জানন্তি তন্মতানুসাৰেণাহং নিজপিতৃপুৰুষাণাম্ ঈশ্ৱৰম্ আৰাধযামীত্যহং ভৱতঃ সমক্ষম্ অঙ্গীকৰোমি| ");
INSERT INTO sanasm_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","ধাৰ্ম্মিকাণাম্ অধাৰ্ম্মিকাণাঞ্চ প্ৰমীতলোকানামেৱোত্থানং ভৱিষ্যতীতি কথামিমে স্ৱীকুৰ্ৱ্ৱন্তি তথাহমপি তস্মিন্ ঈশ্ৱৰে প্ৰত্যাশাং কৰোমি; ");
INSERT INTO sanasm_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","ঈশ্ৱৰস্য মানৱানাঞ্চ সমীপে যথা নিৰ্দোষো ভৱামি তদৰ্থং সততং যত্নৱান্ অস্মি| ");
INSERT INTO sanasm_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","বহুষু ৱৎসৰেষু গতেষু স্ৱদেশীযলোকানাং নিমিত্তং দানীযদ্ৰৱ্যাণি নৈৱেদ্যানি চ সমাদায পুনৰাগমনং কৃতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","ততোহং শুচি ৰ্ভূৎৱা লোকানাং সমাগমং কলহং ৱা ন কাৰিতৱান্ তথাপ্যাশিযাদেশীযাঃ কিযন্তো যিহুদীযলোকা মধ্যেমন্দিৰং মাং ধৃতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","মমোপৰি যদি কাচিদপৱাদকথাস্তি তৰ্হি ভৱতঃ সমীপম্ উপস্থায তেষামেৱ সাক্ষ্যদানম্ উচিতম্| ");
INSERT INTO sanasm_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","নোচেৎ পূৰ্ৱ্ৱে মহাসভাস্থানাং লোকানাং সন্নিধৌ মম দণ্ডাযমানৎৱসমযে, অহমদ্য মৃতানামুত্থানে যুষ্মাভি ৰ্ৱিচাৰিতোস্মি, ");
INSERT INTO sanasm_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","তেষাং মধ্যে তিষ্ঠন্নহং যামিমাং কথামুচ্চৈঃ স্ৱৰেণ কথিতৱান্ তদন্যো মম কোপি দোষোঽলভ্যত ন ৱেতি ৱৰম্ এতে সমুপস্থিতলোকা ৱদন্তু| ");
INSERT INTO sanasm_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","তদা ফীলিক্ষ এতাং কথাং শ্ৰুৎৱা তন্মতস্য ৱিশেষৱৃত্তান্তং ৱিজ্ঞাতুং ৱিচাৰং স্থগিতং কৃৎৱা কথিতৱান্ লুষিযে সহস্ৰসেনাপতৌ সমাযাতে সতি যুষ্মাকং ৱিচাৰম্ অহং নিষ্পাদযিষ্যামি| ");
INSERT INTO sanasm_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","অনন্তৰং বন্ধনং ৱিনা পৌলং ৰক্ষিতুং তস্য সেৱনায সাক্ষাৎকৰণায ৱা তদীযাত্মীযবন্ধুজনান্ ন ৱাৰযিতুঞ্চ শমসেনাপতিম্ আদিষ্টৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","অল্পদিনাৎ পৰং ফীলিক্ষোঽধিপতি ৰ্দ্ৰুষিল্লানাম্না যিহূদীযযা স্ৱভাৰ্য্যযা সহাগত্য পৌলমাহূয তস্য মুখাৎ খ্ৰীষ্টধৰ্ম্মস্য ৱৃত্তান্তম্ অশ্ৰৌষীৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","পৌলেন ন্যাযস্য পৰিমিতভোগস্য চৰমৱিচাৰস্য চ কথাযাং কথিতাযাং সত্যাং ফীলিক্ষঃ কম্পমানঃ সন্ ৱ্যাহৰদ্ ইদানীং যাহি, অহম্ অৱকাশং প্ৰাপ্য ৎৱাম্ আহূস্যামি| ");
INSERT INTO sanasm_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","মুক্তিপ্ৰপ্ত্যৰ্থং পৌলেন মহ্যং মুদ্ৰাদাস্যন্তে ইতি পত্যাশাং কৃৎৱা স পুনঃ পুনস্তমাহূয তেন সাকং কথোপকথনং কৃতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","কিন্তু ৱৎসৰদ্ৱযাৎ পৰং পৰ্কিযফীষ্ট ফালিক্ষস্য পদং প্ৰাপ্তে সতি ফীলিক্ষো যিহূদীযান্ সন্তুষ্টান্ চিকীৰ্ষন্ পৌলং বদ্ধং সংস্থাপ্য গতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","অনন্তৰং ফীষ্টো নিজৰাজ্যম্ আগত্য দিনত্ৰযাৎ পৰং কৈসৰিযাতো যিৰূশালম্নগৰম্ আগমৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","তদা মহাযাজকো যিহূদীযানাং প্ৰধানলোকাশ্চ তস্য সমক্ষং পৌলম্ অপাৱদন্ত| ");
INSERT INTO sanasm_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ভৱান্ তং যিৰূশালমম্ আনেতুম্ আজ্ঞাপযৎৱিতি ৱিনীয তে তস্মাদ্ অনুগ্ৰহং ৱাঞ্ছিতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","যতঃ পথিমধ্যে গোপনেন পৌলং হন্তুং তৈ ৰ্ঘাতকা নিযুক্তাঃ| ফীষ্ট উত্তৰং দত্তৱান্ পৌলঃ কৈসৰিযাযাং স্থাস্যতি পুনৰল্পদিনাৎ পৰম্ অহং তত্ৰ যাস্যামি| ");
INSERT INTO sanasm_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","ততস্তস্য মানুষস্য যদি কশ্চিদ্ অপৰাধস্তিষ্ঠতি তৰ্হি যুষ্মাকং যে শক্নুৱন্তি তে মযা সহ তত্ৰ গৎৱা তমপৱদন্তু স এতাং কথাং কথিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","দশদিৱসেভ্যোঽধিকং ৱিলম্ব্য ফীষ্টস্তস্মাৎ কৈসৰিযানগৰং গৎৱা পৰস্মিন্ দিৱসে ৱিচাৰাসন উপদিশ্য পৌলম্ আনেতুম্ আজ্ঞাপযৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","পৌলে সমুপস্থিতে সতি যিৰূশালম্নগৰাদ্ আগতা যিহূদীযলোকাস্তং চতুৰ্দিশি সংৱেষ্ট্য তস্য ৱিৰুদ্ধং বহূন্ মহাদোষান্ উত্থাপিতৱন্তঃ কিন্তু তেষাং কিমপি প্ৰমাণং দাতুং ন শক্নুৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","ততঃ পৌলঃ স্ৱস্মিন্ উত্তৰমিদম্ উদিতৱান্, যিহূদীযানাং ৱ্যৱস্থাযা মন্দিৰস্য কৈসৰস্য ৱা প্ৰতিকূলং কিমপি কৰ্ম্ম নাহং কৃতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","কিন্তু ফীষ্টো যিহূদীযান্ সন্তুষ্টান্ কৰ্ত্তুম্ অভিলষন্ পৌলম্ অভাষত ৎৱং কিং যিৰূশালমং গৎৱাস্মিন্ অভিযোগে মম সাক্ষাদ্ ৱিচাৰিতো ভৱিষ্যসি? ");
INSERT INTO sanasm_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","ততঃ পৌল উত্তৰং প্ৰোক্তৱান্, যত্ৰ মম ৱিচাৰো ভৱিতুং যোগ্যঃ কৈসৰস্য তত্ৰ ৱিচাৰাসন এৱ সমুপস্থিতোস্মি; অহং যিহূদীযানাং কামপি হানিং নাকাৰ্ষম্ ইতি ভৱান্ যথাৰ্থতো ৱিজানাতি| ");
INSERT INTO sanasm_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","কঞ্চিদপৰাধং কিঞ্চন ৱধাৰ্হং কৰ্ম্ম ৱা যদ্যহম্ অকৰিষ্যং তৰ্হি প্ৰাণহননদণ্ডমপি ভোক্তুম্ উদ্যতোঽভৱিষ্যং, কিন্তু তে মম সমপৱাদং কুৰ্ৱ্ৱন্তি স যদি কল্পিতমাত্ৰো ভৱতি তৰ্হি তেষাং কৰেষু মাং সমৰ্পযিতুং কস্যাপ্যধিকাৰো নাস্তি, কৈসৰস্য নিকটে মম ৱিচাৰো ভৱতু| ");
INSERT INTO sanasm_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","তদা ফীষ্টো মন্ত্ৰিভিঃ সাৰ্দ্ধং সংমন্ত্ৰ্য পৌলায কথিতৱান্, কৈসৰস্য নিকটে কিং তৱ ৱিচাৰো ভৱিষ্যতি? কৈসৰস্য সমীপং গমিষ্যসি| ");
INSERT INTO sanasm_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","কিযদ্দিনেভ্যঃ পৰম্ আগ্ৰিপ্পৰাজা বৰ্ণীকী চ ফীষ্টং সাক্ষাৎ কৰ্ত্তুং কৈসৰিযানগৰম্ আগতৱন্তৌ| ");
INSERT INTO sanasm_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","তদা তৌ বহুদিনানি তত্ৰ স্থিতৌ ততঃ ফীষ্টস্তং ৰাজানং পৌলস্য কথাং ৱিজ্ঞাপ্য কথযিতুম্ আৰভত পৌলনামানম্ একং বন্দি ফীলিক্ষো বদ্ধং সংস্থাপ্য গতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","যিৰূশালমি মম স্থিতিকালে মহাযাজকো যিহূদীযানাং প্ৰাচীনলোকাশ্চ তম্ অপোদ্য তম্প্ৰতি দণ্ডাজ্ঞাং প্ৰাৰ্থযন্ত| ");
INSERT INTO sanasm_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","ততোহম্ ইত্যুত্তৰম্ অৱদং যাৱদ্ অপোদিতো জনঃ স্ৱাপৱাদকান্ সাক্ষাৎ কৃৎৱা স্ৱস্মিন্ যোঽপৰাধ আৰোপিতস্তস্য প্ৰত্যুত্তৰং দাতুং সুযোগং ন প্ৰাপ্নোতি, তাৱৎকালং কস্যাপি মানুষস্য প্ৰাণনাশাজ্ঞাপনং ৰোমিলোকানাং ৰীতি ৰ্নহি| ");
INSERT INTO sanasm_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","ততস্তেষ্ৱত্ৰাগতেষু পৰস্মিন্ দিৱসেঽহম্ অৱিলম্বং ৱিচাৰাসন উপৱিশ্য তং মানুষম্ আনেতুম্ আজ্ঞাপযম্| ");
INSERT INTO sanasm_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","তদনন্তৰং তস্যাপৱাদকা উপস্থায যাদৃশম্ অহং চিন্তিতৱান্ তাদৃশং কঞ্চন মহাপৱাদং নোত্থাপ্য ");
INSERT INTO sanasm_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","স্ৱেষাং মতে তথা পৌলো যং সজীৱং ৱদতি তস্মিন্ যীশুনামনি মৃতজনে চ তস্য ৱিৰুদ্ধং কথিতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","ততোহং তাদৃগ্ৱিচাৰে সংশযানঃ সন্ কথিতৱান্ ৎৱং যিৰূশালমং গৎৱা কিং তত্ৰ ৱিচাৰিতো ভৱিতুম্ ইচ্ছসি? ");
INSERT INTO sanasm_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","তদা পৌলো মহাৰাজস্য নিকটে ৱিচাৰিতো ভৱিতুং প্ৰাৰ্থযত, তস্মাদ্ যাৱৎকালং তং কৈসৰস্য সমীপং প্ৰেষযিতুং ন শক্নোমি তাৱৎকালং তমত্ৰ স্থাপযিতুম্ আদিষ্টৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","তত আগ্ৰিপ্পঃ ফীষ্টম্ উক্তৱান্, অহমপি তস্য মানুষস্য কথাং শ্ৰোতুম্ অভিলষামি| তদা ফীষ্টো ৱ্যাহৰৎ শ্ৱস্তদীযাং কথাং ৎৱং শ্ৰোষ্যসি| ");
INSERT INTO sanasm_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","পৰস্মিন্ দিৱসে আগ্ৰিপ্পো বৰ্ণীকী চ মহাসমাগমং কৃৎৱা প্ৰধানৱাহিনীপতিভি ৰ্নগৰস্থপ্ৰধানলোকৈশ্চ সহ মিলিৎৱা ৰাজগৃহমাগত্য সমুপস্থিতৌ তদা ফীষ্টস্যাজ্ঞযা পৌল আনীতোঽভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","তদা ফীষ্টঃ কথিতৱান্ হে ৰাজন্ আগ্ৰিপ্প হে উপস্থিতাঃ সৰ্ৱ্ৱে লোকা যিৰূশালম্নগৰে যিহূদীযলোকসমূহো যস্মিন্ মানুষে মম সমীপে নিৱেদনং কৃৎৱা প্ৰোচ্চৈঃ কথামিমাং কথিতৱান্ পুনৰল্পকালমপি তস্য জীৱনং নোচিতং তমেতং মানুষং পশ্যত| ");
INSERT INTO sanasm_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","কিন্ত্ৱেষ জনঃ প্ৰাণনাশৰ্হং কিমপি কৰ্ম্ম ন কৃতৱান্ ইত্যজানাং তথাপি স মহাৰাজস্য সন্নিধৌ ৱিচাৰিতো ভৱিতুং প্ৰাৰ্থযত তস্মাৎ তস্য সমীপং তং প্ৰেষযিতুং মতিমকৰৱম্| ");
INSERT INTO sanasm_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","কিন্তু শ্ৰীযুক্তস্য সমীপম্ এতস্মিন্ কিং লেখনীযম্ ইত্যস্য কস্যচিন্ নিৰ্ণযস্য ন জাতৎৱাদ্ এতস্য ৱিচাৰে সতি যথাহং লেখিতুং কিঞ্চন নিশ্চিতং প্ৰাপ্নোমি তদৰ্থং যুষ্মাকং সমক্ষং ৱিশেষতো হে আগ্ৰিপ্পৰাজ ভৱতঃ সমক্ষম্ এতম্ আনযে| ");
INSERT INTO sanasm_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","যতো বন্দিপ্ৰেষণসমযে তস্যাভিযোগস্য কিঞ্চিদলেখনম্ অহম্ অযুক্তং জানামি| ");
INSERT INTO sanasm_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","তত আগ্ৰিপ্পঃ পৌলম্ অৱাদীৎ, নিজাং কথাং কথযিতুং তুভ্যম্ অনুমতি ৰ্দীযতে| তস্মাৎ পৌলঃ কৰং প্ৰসাৰ্য্য স্ৱস্মিন্ উত্তৰম্ অৱাদীৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","হে আগ্ৰিপ্পৰাজ যৎকাৰণাদহং যিহূদীযৈৰপৱাদিতো ঽভৱং তস্য ৱৃত্তান্তম্ অদ্য ভৱতঃ সাক্ষান্ নিৱেদযিতুমনুমতোহম্ ইদং স্ৱীযং পৰমং ভাগ্যং মন্যে; ");
INSERT INTO sanasm_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","যতো যিহূদীযলোকানাং মধ্যে যা যা ৰীতিঃ সূক্ষ্মৱিচাৰাশ্চ সন্তি তেষু ভৱান্ ৱিজ্ঞতমঃ; অতএৱ প্ৰাৰ্থযে ধৈৰ্য্যমৱলম্ব্য মম নিৱেদনং শৃণোতু| ");
INSERT INTO sanasm_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","অহং যিৰূশালম্নগৰে স্ৱদেশীযলোকানাং মধ্যে তিষ্ঠন্ আ যৌৱনকালাদ্ যদ্ৰূপম্ আচৰিতৱান্ তদ্ যিহূদীযলোকাঃ সৰ্ৱ্ৱে ৱিদন্তি| ");
INSERT INTO sanasm_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","অস্মাকং সৰ্ৱ্ৱেভ্যঃ শুদ্ধতমং যৎ ফিৰূশীযমতং তদৱলম্বী ভূৎৱাহং কালং যাপিতৱান্ যে জনা আ বাল্যকালান্ মাং জানান্তি তে এতাদৃশং সাক্ষ্যং যদি দদাতি তৰ্হি দাতুং শক্নুৱন্তি| ");
INSERT INTO sanasm_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","কিন্তু হে আগ্ৰিপ্পৰাজ ঈশ্ৱৰোঽস্মাকং পূৰ্ৱ্ৱপুৰুষাণাং নিকটে যদ্ অঙ্গীকৃতৱান্ তস্য প্ৰত্যাশাহেতোৰহম্ ইদানীং ৱিচাৰস্থানে দণ্ডাযমানোস্মি| ");
INSERT INTO sanasm_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","তস্যাঙ্গীকাৰস্য ফলং প্ৰাপ্তুম্ অস্মাকং দ্ৱাদশৱংশা দিৱানিশং মহাযত্নাদ্ ঈশ্ৱৰসেৱনং কৃৎৱা যাং প্ৰত্যাশাং কুৰ্ৱ্ৱন্তি তস্যাঃ প্ৰত্যাশাযা হেতোৰহং যিহূদীযৈৰপৱাদিতোঽভৱম্| ");
INSERT INTO sanasm_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","ঈশ্ৱৰো মৃতান্ উত্থাপযিষ্যতীতি ৱাক্যং যুষ্মাকং নিকটেঽসম্ভৱং কুতো ভৱেৎ? ");
INSERT INTO sanasm_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","নাসৰতীযযীশো ৰ্নাম্নো ৱিৰুদ্ধং নানাপ্ৰকাৰপ্ৰতিকূলাচৰণম্ উচিতম্ ইত্যহং মনসি যথাৰ্থং ৱিজ্ঞায ");
INSERT INTO sanasm_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","যিৰূশালমনগৰে তদকৰৱং ফলতঃ প্ৰধানযাজকস্য নিকটাৎ ক্ষমতাং প্ৰাপ্য বহূন্ পৱিত্ৰলোকান্ কাৰাযাং বদ্ধৱান্ ৱিশেষতস্তেষাং হননসমযে তেষাং ৱিৰুদ্ধাং নিজাং সম্মতিং প্ৰকাশিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","ৱাৰং ৱাৰং ভজনভৱনেষু তেভ্যো দণ্ডং প্ৰদত্তৱান্ বলাৎ তং ধৰ্ম্মং নিন্দযিতৱাংশ্চ পুনশ্চ তান্ প্ৰতি মহাক্ৰোধাদ্ উন্মত্তঃ সন্ ৱিদেশীযনগৰাণি যাৱৎ তান্ তাডিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","ইত্থং প্ৰধানযাজকস্য সমীপাৎ শক্তিম্ আজ্ঞাপত্ৰঞ্চ লব্ধ্ৱা দম্মেষক্নগৰং গতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","তদাহং হে ৰাজন্ মাৰ্গমধ্যে মধ্যাহ্নকালে মম মদীযসঙ্গিনাং লোকানাঞ্চ চতসৃষু দিক্ষু গগণাৎ প্ৰকাশমানাং ভাস্কৰতোপি তেজস্ৱতীং দীপ্তিং দৃষ্টৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","তস্মাদ্ অস্মাসু সৰ্ৱ্ৱেষু ভূমৌ পতিতেষু সৎসু হে শৌল হৈ শৌল কুতো মাং তাডযসি? কণ্টকানাং মুখে পাদাহননং তৱ দুঃসাধ্যম্ ইব্ৰীযভাষযা গদিত এতাদৃশ একঃ শব্দো মযা শ্ৰুতঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","তদাহং পৃষ্টৱান্ হে প্ৰভো কো ভৱান্? ততঃ স কথিতৱান্ যং যীশুং ৎৱং তাডযসি সোহং, ");
INSERT INTO sanasm_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","কিন্তু সমুত্তিষ্ঠ ৎৱং যদ্ দৃষ্টৱান্ ইতঃ পুনঞ্চ যদ্যৎ ৎৱাং দৰ্শযিষ্যামি তেষাং সৰ্ৱ্ৱেষাং কাৰ্য্যাণাং ৎৱাং সাক্ষিণং মম সেৱকঞ্চ কৰ্ত্তুম্ দৰ্শনম্ অদাম্| ");
INSERT INTO sanasm_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","ৱিশেষতো যিহূদীযলোকেভ্যো ভিন্নজাতীযেভ্যশ্চ ৎৱাং মনোনীতং কৃৎৱা তেষাং যথা পাপমোচনং ভৱতি ");
INSERT INTO sanasm_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","যথা তে মযি ৱিশ্ৱস্য পৱিত্ৰীকৃতানাং মধ্যে ভাগং প্ৰাপ্নুৱন্তি তদভিপ্ৰাযেণ তেষাং জ্ঞানচক্ষূংষি প্ৰসন্নানি কৰ্ত্তুং তথান্ধকাৰাদ্ দীপ্তিং প্ৰতি শৈতানাধিকাৰাচ্চ ঈশ্ৱৰং প্ৰতি মতীঃ পৰাৱৰ্ত্তযিতুং তেষাং সমীপং ৎৱাং প্ৰেষ্যামি| ");
INSERT INTO sanasm_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","হে আগ্ৰিপ্পৰাজ এতাদৃশং স্ৱৰ্গীযপ্ৰত্যাদেশং অগ্ৰাহ্যম্ অকৃৎৱাহং ");
INSERT INTO sanasm_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","প্ৰথমতো দম্মেষক্নগৰে ততো যিৰূশালমি সৰ্ৱ্ৱস্মিন্ যিহূদীযদেশে অন্যেষু দেশেষু চ যেेন লোকা মতিং পৰাৱৰ্ত্ত্য ঈশ্ৱৰং প্ৰতি পৰাৱৰ্ত্তযন্তে, মনঃপৰাৱৰ্ত্তনযোগ্যানি কৰ্ম্মাণি চ কুৰ্ৱ্ৱন্তি তাদৃশম্ উপদেশং প্ৰচাৰিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","এতৎকাৰণাদ্ যিহূদীযা মধ্যেমন্দিৰং মাং ধৃৎৱা হন্তুম্ উদ্যতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","তথাপি খ্ৰীষ্টো দুঃখং ভুক্ত্ৱা সৰ্ৱ্ৱেষাং পূৰ্ৱ্ৱং শ্মশানাদ্ উত্থায নিজদেশীযানাং ভিন্নদেশীযানাঞ্চ সমীপে দীপ্তিং প্ৰকাশযিষ্যতি ");
INSERT INTO sanasm_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","ভৱিষ্যদ্ৱাদিগণো মূসাশ্চ ভাৱিকাৰ্য্যস্য যদিদং প্ৰমাণম্ অদদুৰেতদ্ ৱিনান্যাং কথাং ন কথযিৎৱা ঈশ্ৱৰাদ্ অনুগ্ৰহং লব্ধ্ৱা মহতাং ক্ষুদ্ৰাণাঞ্চ সৰ্ৱ্ৱেষাং সমীপে প্ৰমাণং দত্ত্ৱাদ্য যাৱৎ তিষ্ঠামি| ");
INSERT INTO sanasm_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","তস্যমাং কথাং নিশম্য ফীষ্ট উচ্চৈঃ স্ৱৰেণ কথিতৱান্ হে পৌল ৎৱম্ উন্মত্তোসি বহুৱিদ্যাভ্যাসেন ৎৱং হতজ্ঞানো জাতঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","স উক্তৱান্ হে মহামহিম ফীষ্ট নাহম্ উন্মত্তঃ কিন্তু সত্যং ৱিৱেচনীযঞ্চ ৱাক্যং প্ৰস্তৌমি| ");
INSERT INTO sanasm_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","যস্য সাক্ষাদ্ অক্ষোভঃ সন্ কথাং কথযামি স ৰাজা তদ্ৱৃত্তান্তং জানাতি তস্য সমীপে কিমপি গুপ্তং নেতি মযা নিশ্চিতং বুধ্যতে যতস্তদ্ ৱিজনে ন কৃতং| ");
INSERT INTO sanasm_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","হে আগ্ৰিপ্পৰাজ ভৱান্ কিং ভৱিষ্যদ্ৱাদিগণোক্তানি ৱাক্যানি প্ৰত্যেতি? ভৱান্ প্ৰত্যেতি তদহং জানামি| ");
INSERT INTO sanasm_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","তত আগ্ৰিপ্পঃ পৌলম্ অভিহিতৱান্ ৎৱং প্ৰৱৃত্তিং জনযিৎৱা প্ৰাযেণ মামপি খ্ৰীষ্টীযং কৰোষি| ");
INSERT INTO sanasm_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","ততঃ সোঽৱাদীৎ ভৱান্ যে যে লোকাশ্চ মম কথাম্ অদ্য শৃণ্ৱন্তি প্ৰাযেণ ইতি নহি কিন্ত্ৱেতৎ শৃঙ্খলবন্ধনং ৱিনা সৰ্ৱ্ৱথা তে সৰ্ৱ্ৱে মাদৃশা ভৱন্ত্ৱিতীশ্ৱস্য সমীপে প্ৰাৰ্থযেঽহম্| ");
INSERT INTO sanasm_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","এতস্যাং কথাযাং কথিতাযাং স ৰাজা সোঽধিপতি ৰ্বৰ্ণীকী সভাস্থা লোকাশ্চ তস্মাদ্ উত্থায ");
INSERT INTO sanasm_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","গোপনে পৰস্পৰং ৱিৱিচ্য কথিতৱন্ত এষ জনো বন্ধনাৰ্হং প্ৰাণহননাৰ্হং ৱা কিমপি কৰ্ম্ম নাকৰোৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","তত আগ্ৰিপ্পঃ ফীষ্টম্ অৱদৎ, যদ্যেষ মানুষঃ কৈসৰস্য নিকটে ৱিচাৰিতো ভৱিতুং ন প্ৰাৰ্থযিষ্যৎ তৰ্হি মুক্তো ভৱিতুম্ অশক্ষ্যৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","জলপথেনাস্মাকম্ ইতোলিযাদেশং প্ৰতি যাত্ৰাযাং নিশ্চিতাযাং সত্যাং তে যূলিযনাম্নো মহাৰাজস্য সংঘাতান্তৰ্গতস্য সেনাপতেঃ সমীপে পৌলং তদন্যান্ কতিনযজনাংশ্চ সমাৰ্পযন্| ");
INSERT INTO sanasm_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","ৱযম্ আদ্ৰামুত্তীযং পোতমেকম্ আৰুহ্য আশিযাদেশস্য তটসমীপেন যাতুং মতিং কৃৎৱা লঙ্গৰম্ উত্থাপ্য পোতম্ অমোচযাম; মাকিদনিযাদেশস্থথিষলনীকীনিৱাস্যাৰিস্তাৰ্খনামা কশ্চিদ্ জনোঽস্মাভিঃ সাৰ্দ্ধম্ আসীৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","পৰস্মিন্ দিৱসে ঽস্মাভিঃ সীদোন্নগৰে পোতে লাগিতে তত্ৰ যূলিযঃ সেনাপতিঃ পৌলং প্ৰতি সৌজন্যং প্ৰদৰ্থ্য সান্ত্ৱনাৰ্থং বন্ধুবান্ধৱান্ উপযাতুম্ অনুজজ্ঞৌ| ");
INSERT INTO sanasm_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","তস্মাৎ পোতে মোচিতে সতি সম্মুখৱাযোঃ সম্ভৱাদ্ ৱযং কুপ্ৰোপদ্ৱীপস্য তীৰসমীপেন গতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","কিলিকিযাযাঃ পাম্ফূলিযাযাশ্চ সমুদ্ৰস্য পাৰং গৎৱা লূকিযাদেশান্তৰ্গতং মুৰানগৰম্ উপাতিষ্ঠাম| ");
INSERT INTO sanasm_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","তৎস্থানাদ্ ইতালিযাদেশং গচ্ছতি যঃ সিকন্দৰিযানগৰস্য পোতস্তং তত্ৰ প্ৰাপ্য শতসেনাপতিস্তং পোতম্ অস্মান্ আৰোহযৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","ততঃ পৰং বহূনি দিনানি শনৈঃ শনৈঃ ৰ্গৎৱা ক্নীদপাৰ্শ্ৱোপস্থ্তিेঃ পূৰ্ৱ্ৱং প্ৰতিকূলেন পৱনেন ৱযং সল্মোন্যাঃ সম্মুখম্ উপস্থায ক্ৰীত্যুপদ্ৱীপস্য তীৰসমীপেন গতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","কষ্টেন তমুত্তীৰ্য্য লাসেযানগৰস্যাধঃ সুন্দৰনামকং খাতম্ উপাতিষ্ঠাম| ");
INSERT INTO sanasm_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","ইত্থং বহুতিথঃ কালো যাপিত উপৱাসদিনঞ্চাতীতং, তৎকাৰণাৎ নৌৱৰ্ত্মনি ভযঙ্কৰে সতি পৌলো ৱিনযেন কথিতৱান্, ");
INSERT INTO sanasm_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","হে মহেচ্ছা অহং নিশ্চযং জানামি যাত্ৰাযামস্যাম্ অস্মাকং ক্লেশা বহূনামপচযাশ্চ ভৱিষ্যন্তি, তে কেৱলং পোতসামগ্ৰ্যোৰিতি নহি, কিন্ত্ৱস্মাকং প্ৰাণানামপি| ");
INSERT INTO sanasm_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","তদা শতসেনাপতিঃ পৌैेলোক্তৱাক্যতোপি কৰ্ণধাৰস্য পোতৱণিজশ্চ ৱাক্যং বহুমংস্ত| ");
INSERT INTO sanasm_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","তৎ খাতং শীতকালে ৱাসাৰ্হস্থানং ন তস্মাদ্ অৱাচীপ্ৰতীচোৰ্দিশোঃ ক্ৰীত্যাঃ ফৈনীকিযখাতং যাতুং যদি শক্নুৱন্তস্তৰ্হি তত্ৰ শীতকালং যাপযিতুং প্ৰাযেণ সৰ্ৱ্ৱে মন্ত্ৰযামাসুঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","ততঃ পৰং দক্ষিণৱাযু ৰ্মন্দং ৱহতীতি ৱিলোক্য নিজাভিপ্ৰাযস্য সিদ্ধেঃ সুযোগো ভৱতীতি বুদ্ধ্ৱা পোতং মোচযিৎৱা ক্ৰীত্যুপদ্ৱীপস্য তীৰসমীপেন চলিতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","কিন্ত্ৱল্পক্ষণাৎ পৰমেৱ উৰক্লুদোন্নামা প্ৰতিকূলঃ প্ৰচণ্ডো ৱাযু ৰ্ৱহন্ পোতেঽলগীৎ ");
INSERT INTO sanasm_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","তস্যাভিমুখং গন্তুম্ পোতস্যাশক্তৎৱাদ্ ৱযং ৱাযুনা স্ৱযং নীতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","অনন্তৰং ক্লৌদীনাম্ন উপদ্ৱীপস্য কূলসমীপেন পোতং গমযিৎৱা বহুনা কষ্টেন ক্ষুদ্ৰনাৱম্ অৰক্ষাম| ");
INSERT INTO sanasm_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","তে তামাৰুহ্য ৰজ্জ্চা পোতস্যাধোভাগম্ অবধ্নন্ তদনন্তৰং চেৎ পোতো সৈকতে লগতীতি ভযাদ্ ৱাতৱসনান্যমোচযন্ ততঃ পোতো ৱাযুনা চালিতঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","কিন্তু ক্ৰমশো ৱাযোঃ প্ৰবলৎৱাৎ পোতো দোলাযমানোঽভৱৎ পৰস্মিন্ দিৱসে পোতস্থানি কতিপযানি দ্ৰৱ্যাণি তোযে নিক্ষিপ্তানি| ");
INSERT INTO sanasm_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","তৃতীযদিৱসে ৱযং স্ৱহস্তৈঃ পোতসজ্জনদ্ৰৱ্যাণি নিক্ষিপ্তৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","ততো বহুদিনানি যাৱৎ সূৰ্য্যনক্ষত্ৰাদীনি সমাচ্ছন্নানি ততো ঽতীৱ ৱাত্যাগমাদ্ অস্মাকং প্ৰাণৰক্ষাযাঃ কাপি প্ৰত্যাশা নাতিষ্ঠৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","বহুদিনেষু লোকৈৰনাহাৰেণ যাপিতেষু সৰ্ৱ্ৱেষাং সাক্ষৎ পৌলস্তিষ্ঠন্ অকথযৎ, হে মহেচ্ছাঃ ক্ৰীত্যুপদ্ৱীপাৎ পোতং ন মোচযিতুম্ অহং পূৰ্ৱ্ৱং যদ্ অৱদং তদ্গ্ৰহণং যুষ্মাকম্ উচিতম্ আসীৎ তথা কৃতে যুষ্মাকম্ এষা ৱিপদ্ এষোঽপচযশ্চ নাঘটিষ্যেতাম্| ");
INSERT INTO sanasm_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","কিন্তু সাম্প্ৰতং যুষ্মান্ ৱিনীয ব্ৰৱীম্যহং, যূযং ন ক্ষুভ্যত যুষ্মাকম্ একস্যাপি প্ৰাণিনো হানি ৰ্ন ভৱিষ্যতি, কেৱলস্য পোতস্য হানি ৰ্ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","যতো যস্যেশ্ৱৰস্য লোকোঽহং যঞ্চাহং পৰিচৰামি তদীয একো দূতো হ্যো ৰাত্ৰৌ মমান্তিকে তিষ্ঠন্ কথিতৱান্, ");
INSERT INTO sanasm_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","হে পৌল মা ভৈষীঃ কৈসৰস্য সম্মুখে ৎৱযোপস্থাতৱ্যং; তৱৈতান্ সঙ্গিনো লোকান্ ঈশ্ৱৰস্তুভ্যং দত্তৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","অতএৱ হে মহেচ্ছা যূযং স্থিৰমনসো ভৱত মহ্যং যা কথাকথি সাৱশ্যং ঘটিষ্যতে মমৈতাদৃশী ৱিশ্ৱাস ঈশ্ৱৰে ৱিদ্যতে, ");
INSERT INTO sanasm_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","কিন্তু কস্যচিদ্ উপদ্ৱীপস্যোপৰি পতিতৱ্যম্ অস্মাভিঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","ততঃ পৰম্ আদ্ৰিযাসমুদ্ৰে পোতস্তথৈৱ দোলাযমানঃ সন্ ইতস্ততো গচ্ছন্ চতুৰ্দশদিৱসস্য ৰাত্ৰে ৰ্দ্ৱিতীযপ্ৰহৰসমযে কস্যচিৎ স্থলস্য সমীপমুপতিষ্ঠতীতি পোতীযলোকা অন্ৱমন্যন্ত| ");
INSERT INTO sanasm_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","ততস্তে জলং পৰিমায তত্ৰ ৱিংশতি ৰ্ৱ্যামা জলানীতি জ্ঞাতৱন্তঃ| কিঞ্চিদ্দূৰং গৎৱা পুনৰপি জলং পৰিমিতৱন্তঃ| তত্ৰ পঞ্চদশ ৱ্যামা জলানি দৃষ্ট্ৱা ");
INSERT INTO sanasm_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","চেৎ পাষাণে লগতীতি ভযাৎ পোতস্য পশ্চাদ্ভাগতশ্চতুৰো লঙ্গৰান্ নিক্ষিপ্য দিৱাকৰম্ অপেক্ষ্য সৰ্ৱ্ৱে স্থিতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","কিন্তু পোতীযলোকাঃ পোতাগ্ৰভাগে লঙ্গৰনিক্ষেপং ছলং কৃৎৱা জলধৌ ক্ষুদ্ৰনাৱম্ অৱৰোহ্য পলাযিতুম্ অচেষ্টন্ত| ");
INSERT INTO sanasm_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","ততঃ পৌলঃ সেনাপতযে সৈন্যগণায চ কথিতৱান্, এতে যদি পোতমধ্যে ন তিষ্ঠন্তি তৰ্হি যুষ্মাকং ৰক্ষণং ন শক্যং| ");
INSERT INTO sanasm_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","তদা সেনাগণো ৰজ্জূন্ ছিৎৱা নাৱং জলে পতিতুম্ অদদাৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","প্ৰভাতসমযে পৌলঃ সৰ্ৱ্ৱান্ জনান্ ভোজনাৰ্থং প্ৰাৰ্থ্য ৱ্যাহৰৎ, অদ্য চতুৰ্দশদিনানি যাৱদ্ যূযম্ অপেক্ষমানা অনাহাৰাঃ কালম্ অযাপযত কিমপি নাভুংগ্ধং| ");
INSERT INTO sanasm_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","অতো ৱিনযেेঽহং ভক্ষ্যং ভুজ্যতাং ততো যুষ্মাকং মঙ্গলং ভৱিষ্যতি, যুষ্মাকং কস্যচিজ্জনস্য শিৰসঃ কেশৈকোপি ন নংক্ষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","ইতি ৱ্যাহৃত্য পৌলং পূপং গৃহীৎৱেশ্ৱৰং ধন্যং ভাষমাণস্তং ভংক্ত্ৱা ভোক্তুম্ আৰব্ধৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","অনন্তৰং সৰ্ৱ্ৱে চ সুস্থিৰাঃ সন্তঃ খাদ্যানি পৰ্প্যগৃহ্লন্| ");
INSERT INTO sanasm_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","অস্মাকং পোতে ষট্সপ্তত্যধিকশতদ্ৱযলোকা আসন্| ");
INSERT INTO sanasm_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","সৰ্ৱ্ৱেষু লোকেষু যথেষ্টং ভুক্তৱৎসু পোতস্থন্ গোধূমান্ জলধৌ নিক্ষিপ্য তৈঃ পোতস্য ভাৰো লঘূকৃতঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","দিনে জাতেঽপি স কো দেশ ইতি তদা ন পৰ্য্যচীযত; কিন্তু তত্ৰ সমতটম্ একং খাতং দৃষ্ট্ৱা যদি শক্নুমস্তৰ্হি ৱযং তস্যাভ্যন্তৰং পোতং গমযাম ইতি মতিং কৃৎৱা তে লঙ্গৰান্ ছিত্ত্ৱা জলধৌ ত্যক্তৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","তথা কৰ্ণবন্ধনং মোচযিৎৱা প্ৰধানং ৱাতৱসনম্ উত্তোল্য তীৰসমীপং গতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","কিন্তু দ্ৱযোঃ সমুদ্ৰযোঃ সঙ্গমস্থানে সৈকতোপৰি পোতে নিক্ষিপ্তে ঽগ্ৰভাগে বাধিতে পশ্চাদ্ভাগে প্ৰবলতৰঙ্গোঽলগৎ তেন পোতো ভগ্নঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","তস্মাদ্ বন্দযশ্চেদ্ বাহুভিস্তৰন্তঃ পলাযন্তে ইত্যাশঙ্কযা সেনাগণস্তান্ হন্তুম্ অমন্ত্ৰযৎ; ");
INSERT INTO sanasm_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","কিন্তু শতসেনাপতিঃ পৌলং ৰক্ষিতুং প্ৰযত্নং কৃৎৱা তান্ তচ্চেষ্টাযা নিৱৰ্ত্য ইত্যাদিষ্টৱান্, যে বাহুতৰণং জানন্তি তেঽগ্ৰে প্ৰোল্লম্প্য সমুদ্ৰে পতিৎৱা বাহুভিস্তীৰ্ত্ত্ৱা কূলং যান্তু| ");
INSERT INTO sanasm_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","অপৰম্ অৱশিষ্টা জনাঃ কাষ্ঠং পোতীযং দ্ৰৱ্যং ৱা যেন যৎ প্ৰাপ্যতে তদৱলম্ব্য যান্তু; ইত্থং সৰ্ৱ্ৱে ভূমিং প্ৰাপ্য প্ৰাণৈ ৰ্জীৱিতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","ইত্থং সৰ্ৱ্ৱেষু ৰক্ষাং প্ৰাপ্তেষু তত্ৰত্যোপদ্ৱীপস্য নাম মিলীতেতি তে জ্ঞাতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","অসভ্যলোকা যথেষ্টম্ অনুকম্পাং কৃৎৱা ৱৰ্ত্তমানৱৃষ্টেঃ শীতাচ্চ ৱহ্নিং প্ৰজ্জ্ৱাল্যাস্মাকম্ আতিথ্যম্ অকুৰ্ৱ্ৱন্| ");
INSERT INTO sanasm_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","কিন্তু পৌল ইন্ধনানি সংগৃহ্য যদা তস্মিন্ অগ্ৰৌ নিৰক্ষিপৎ, তদা ৱহ্নেঃ প্ৰতাপাৎ একঃ কৃষ্ণসৰ্পো নিৰ্গত্য তস্য হস্তে দ্ৰষ্টৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","তেঽসভ্যলোকাস্তস্য হস্তে সৰ্পম্ অৱলম্বমানং দৃষ্ট্ৱা পৰস্পৰম্ উক্তৱন্ত এষ জনোঽৱশ্যং নৰহা ভৱিষ্যতি, যতো যদ্যপি জলধে ৰক্ষাং প্ৰাপ্তৱান্ তথাপি প্ৰতিফলদাযক এনং জীৱিতুং ন দদাতি| ");
INSERT INTO sanasm_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","কিন্তু স হস্তং ৱিধুন্ৱন্ তং সৰ্পম্ অগ্নিমধ্যে নিক্ষিপ্য কামপি পীডাং নাপ্তৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","ততো ৱিষজ্ৱালযা এতস্য শৰীৰং স্ফীতং ভৱিষ্যতি যদ্ৱা হঠাদযং প্ৰাণান্ ত্যক্ষ্যতীতি নিশ্চিত্য লোকা বহুক্ষণানি যাৱৎ তদ্ দ্ৰষ্টুং স্থিতৱন্তঃ কিন্তু তস্য কস্যাশ্চিদ্ ৱিপদোঽঘটনাৎ তে তদ্ৱিপৰীতং ৱিজ্ঞায ভাষিতৱন্ত এষ কশ্চিদ্ দেৱো ভৱেৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","পুব্লিযনামা জন একস্তস্যোপদ্ৱীপস্যাধিপতিৰাসীৎ তত্ৰ তস্য ভূম্যাদি চ স্থিতং| স জনোঽস্মান্ নিজগৃহং নীৎৱা সৌজন্যং প্ৰকাশ্য দিনত্ৰযং যাৱদ্ অস্মাকং আতিথ্যম্ অকৰোৎ| ");
INSERT INTO sanasm_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","তদা তস্য পুব্লিযস্য পিতা জ্ৱৰাতিসাৰেণ পীড্যমানঃ সন্ শয্যাযাম্ আসীৎ; ততঃ পৌলস্তস্য সমীপং গৎৱা প্ৰাৰ্থনাং কৃৎৱা তস্য গাত্ৰে হস্তং সমৰ্প্য তং স্ৱস্থং কৃতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","ইত্থং ভূতে তদ্ৱীপনিৱাসিন ইতৰেপি ৰোগিলোকা আগত্য নিৰামযা অভৱন্| ");
INSERT INTO sanasm_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","তস্মাত্তেঽস্মাকম্ অতীৱ সৎকাৰং কৃতৱন্তঃ, ৱিশেষতঃ প্ৰস্থানসমযে প্ৰযোজনীযানি নানদ্ৰৱ্যাণি দত্তৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","ইত্থং তত্ৰ ত্ৰিষু মাসেষু গতেষু যস্য চিহ্নং দিযস্কূৰী তাদৃশ একঃ সিকন্দৰীযনগৰস্য পোতঃ শীতকালং যাপযন্ তস্মিন্ উপদ্ৱীপে ঽতিষ্ঠৎ তমেৱ পোতং ৱযম্ আৰুহ্য যাত্ৰাম্ অকুৰ্ম্ম| ");
INSERT INTO sanasm_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","ততঃ প্ৰথমতঃ সুৰাকূসনগৰম্ উপস্থায তত্ৰ ত্ৰীণি দিনানি স্থিতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","তস্মাদ্ আৱৃত্য ৰীগিযনগৰম্ উপস্থিতাঃ দিনৈকস্মাৎ পৰং দক্ষিণৱযৌ সানুকূল্যে সতি পৰস্মিন্ দিৱসে পতিযলীনগৰম্ উপাতিষ্ঠাম| ");
INSERT INTO sanasm_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","ততোঽস্মাসু তত্ৰত্যং ভ্ৰাতৃগণং প্ৰাপ্তেষু তে স্ৱৈঃ সাৰ্দ্ধম্ অস্মান্ সপ্ত দিনানি স্থাপযিতুম্ অযতন্ত, ইত্থং ৱযং ৰোমানগৰম্ প্ৰত্যগচ্ছাম| ");
INSERT INTO sanasm_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","তস্মাৎ তত্ৰত্যাঃ ভ্ৰাতৰোঽস্মাকম্ আগমনৱাৰ্ত্তাং শ্ৰুৎৱা আপ্পিযফৰং ত্ৰিষ্টাৱৰ্ণীঞ্চ যাৱদ্ অগ্ৰেসৰাঃ সন্তোস্মান্ সাক্ষাৎ কৰ্ত্তুম্ আগমন্; তেষাং দৰ্শনাৎ পৌল ঈশ্ৱৰং ধন্যং ৱদন্ আশ্ৱাসম্ আপ্তৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","অস্মাসু ৰোমানগৰং গতেষু শতসেনাপতিঃ সৰ্ৱ্ৱান্ বন্দীন্ প্ৰধানসেনাপতেঃ সমীপে সমাৰ্পযৎ কিন্তু পৌলায স্ৱৰক্ষকপদাতিনা সহ পৃথগ্ ৱস্তুম্ অনুমতিং দত্তৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","দিনত্ৰযাৎ পৰং পৌলস্তদ্দেশস্থান্ প্ৰধানযিহূদিন আহূতৱান্ ততস্তেষু সমুপস্থিতেষু স কথিতৱান্, হে ভ্ৰাতৃগণ নিজলোকানাং পূৰ্ৱ্ৱপুৰুষাণাং ৱা ৰীতে ৰ্ৱিপৰীতং কিঞ্চন কৰ্ম্মাহং নাকৰৱং তথাপি যিৰূশালমনিৱাসিনো লোকা মাং বন্দিং কৃৎৱা ৰোমিলোকানাং হস্তেষু সমৰ্পিতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","ৰোমিলোকা ৱিচাৰ্য্য মম প্ৰাণহননাৰ্হং কিমপি কাৰণং ন প্ৰাপ্য মাং মোচযিতুম্ ঐচ্ছন্; ");
INSERT INTO sanasm_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","কিন্তু যিহূদিলোকানাম্ আপত্ত্যা মযা কৈসৰৰাজস্য সমীপে ৱিচাৰস্য প্ৰাৰ্থনা কৰ্ত্তৱ্যা জাতা নোচেৎ নিজদেশীযলোকান্ প্ৰতি মম কোপ্যভিযোগো নাস্তি| ");
INSERT INTO sanasm_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","এতৎকাৰণাদ্ অহং যুষ্মান্ দ্ৰষ্টুং সংলপিতুঞ্চাহূযম্ ইস্ৰাযেল্ৱশীযানাং প্ৰত্যাশাহেতোহম্ এতেন শুঙ্খলেন বদ্ধোঽভৱম্| ");
INSERT INTO sanasm_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","তদা তে তম্ অৱাদিষুঃ, যিহূদীযদেশাদ্ ৱযং ৎৱামধি কিমপি পত্ৰং ন প্ৰাপ্তা যে ভ্ৰাতৰঃ সমাযাতাস্তেষাং কোপি তৱ কামপি ৱাৰ্ত্তাং নাৱদৎ অভদ্ৰমপি নাকথযচ্চ| ");
INSERT INTO sanasm_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","তৱ মতং কিমিতি ৱযং ৎৱত্তঃ শ্ৰোতুমিচ্ছামঃ| যদ্ ইদং নৱীনং মতমুত্থিতং তৎ সৰ্ৱ্ৱত্ৰ সৰ্ৱ্ৱেষাং নিকটে নিন্দিতং জাতম ইতি ৱযং জানীমঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","তৈস্তদৰ্থম্ একস্মিন্ দিনে নিৰূপিতে তস্মিন্ দিনে বহৱ একত্ৰ মিলিৎৱা পৌলস্য ৱাসগৃহম্ আগচ্ছন্ তস্মাৎ পৌল আ প্ৰাতঃকালাৎ সন্ধ্যাকালং যাৱন্ মূসাৱ্যৱস্থাগ্ৰন্থাদ্ ভৱিষ্যদ্ৱাদিনাং গ্ৰন্থেভ্যশ্চ যীশোঃ কথাম্ উত্থাপ্য ঈশ্ৱৰস্য ৰাজ্যে প্ৰমাণং দৎৱা তেষাং প্ৰৱৃত্তিং জনযিতুং চেষ্টিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","কেচিত্তু তস্য কথাং প্ৰত্যাযন্ কেচিত্তু ন প্ৰত্যাযন্; ");
INSERT INTO sanasm_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","এতৎকাৰণাৎ তেষাং পৰস্পৰম্ অনৈক্যাৎ সৰ্ৱ্ৱে চলিতৱন্তঃ; তথাপি পৌল এতাং কথামেকাং কথিতৱান্ পৱিত্ৰ আত্মা যিশযিযস্য ভৱিষ্যদ্ৱক্তু ৰ্ৱদনাদ্ অস্মাকং পিতৃপুৰুষেভ্য এতাং কথাং ভদ্ৰং কথযামাস, যথা, ");
INSERT INTO sanasm_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","\"উপগত্য জনানেতান্ ৎৱং ভাষস্ৱ ৱচস্ত্ৱিদং| কৰ্ণৈঃ শ্ৰোষ্যথ যূযং হি কিন্তু যূযং ন ভোৎস্যথ| নেত্ৰৈ ৰ্দ্ৰক্ষ্যথ যূযঞ্চ জ্ঞাতুং যূযং ন শক্ষ্যথ| ");
INSERT INTO sanasm_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","তে মানুষা যথা নেত্ৰৈঃ পৰিপশ্যন্তি নৈৱ হি| কৰ্ণৈঃ ৰ্যথা ন শৃণ্ৱন্তি বুধ্যন্তে ন চ মানসৈঃ| ৱ্যাৱৰ্ত্তযৎসু চিত্তানি কালে কুত্ৰাপি তেষু ৱৈ| মত্তস্তে মনুজাঃ স্ৱস্থা যথা নৈৱ ভৱন্তি চ| তথা তেষাং মনুষ্যাণাং সন্তি স্থূলা হি বুদ্ধযঃ| বধিৰীভূতকৰ্ণাশ্চ জাতাশ্চ মুদ্ৰিতা দৃশঃ|| ");
INSERT INTO sanasm_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","অত ঈশ্ৱৰাদ্ যৎ পৰিত্ৰাণং তস্য ৱাৰ্ত্তা ভিন্নদেশীযানাং সমীপং প্ৰেষিতা তএৱ তাং গ্ৰহীষ্যন্তীতি যূযং জানীত| ");
INSERT INTO sanasm_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","এতাদৃশ্যাং কথাযাং কথিতাযাং সত্যাং যিহূদিনঃ পৰস্পৰং বহুৱিচাৰং কুৰ্ৱ্ৱন্তো গতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","ইত্থং পৌলঃ সম্পূৰ্ণং ৱৎসৰদ্ৱযং যাৱদ্ ভাটকীযে ৱাসগৃহে ৱসন্ যে লোকাস্তস্য সন্নিধিম্ আগচ্ছন্তি তান্ সৰ্ৱ্ৱানেৱ পৰিগৃহ্লন্, ");
INSERT INTO sanasm_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","নিৰ্ৱিঘ্নম্ অতিশযনিঃক্ষোভম্ ঈশ্ৱৰীযৰাজৎৱস্য কথাং প্ৰচাৰযন্ প্ৰভৌ যীশৌ খ্ৰীষ্টে কথাঃ সমুপাদিশৎ| ইতি||");
INSERT INTO sanasm_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","ঈশ্ৱৰো নিজপুত্ৰমধি যং সুসংৱাদং ভৱিষ্যদ্ৱাদিভি ৰ্ধৰ্ম্মগ্ৰন্থে প্ৰতিশ্ৰুতৱান্ তং সুসংৱাদং প্ৰচাৰযিতুং পৃথক্কৃত আহূতঃ প্ৰেৰিতশ্চ প্ৰভো ৰ্যীশুখ্ৰীষ্টস্য সেৱকো যঃ পৌলঃ ");
INSERT INTO sanasm_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","স ৰোমানগৰস্থান্ ঈশ্ৱৰপ্ৰিযান্ আহূতাংশ্চ পৱিত্ৰলোকান্ প্ৰতি পত্ৰং লিখতি| ");
INSERT INTO sanasm_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","অস্মাকং স প্ৰভু ৰ্যীশুঃ খ্ৰীষ্টঃ শাৰীৰিকসম্বন্ধেন দাযূদো ৱংশোদ্ভৱঃ ");
INSERT INTO sanasm_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","পৱিত্ৰস্যাত্মনঃ সম্বন্ধেন চেশ্ৱৰস্য প্ৰভাৱৱান্ পুত্ৰ ইতি শ্মশানাৎ তস্যোত্থানেন প্ৰতিপন্নং| ");
INSERT INTO sanasm_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","অপৰং যেষাং মধ্যে যীশুনা খ্ৰীষ্টেন যূযমপ্যাহূতাস্তে ঽন্যদেশীযলোকাস্তস্য নাম্নি ৱিশ্ৱস্য নিদেশগ্ৰাহিণো যথা ভৱন্তি ");
INSERT INTO sanasm_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","তদভিপ্ৰাযেণ ৱযং তস্মাদ্ অনুগ্ৰহং প্ৰেৰিতৎৱপদঞ্চ প্ৰাপ্তাঃ| ");
INSERT INTO sanasm_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","তাতেনাস্মাকম্ ঈশ্ৱৰেণ প্ৰভুণা যীশুখ্ৰীষ্টেন চ যুষ্মভ্যম্ অনুগ্ৰহঃ শান্তিশ্চ প্ৰদীযেতাং| ");
INSERT INTO sanasm_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","প্ৰথমতঃ সৰ্ৱ্ৱস্মিন্ জগতি যুষ্মাকং ৱিশ্ৱাসস্য প্ৰকাশিতৎৱাদ্ অহং যুষ্মাকং সৰ্ৱ্ৱেষাং নিমিত্তং যীশুখ্ৰীষ্টস্য নাম গৃহ্লন্ ঈশ্ৱৰস্য ধন্যৱাদং কৰোমি| ");
INSERT INTO sanasm_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","অপৰম্ ঈশ্ৱৰস্য প্ৰসাদাদ্ বহুকালাৎ পৰং সাম্প্ৰতং যুষ্মাকং সমীপং যাতুং কথমপি যৎ সুযোগং প্ৰাপ্নোমি, এতদৰ্থং নিৰন্তৰং নামান্যুচ্চাৰযন্ নিজাসু সৰ্ৱ্ৱপ্ৰাৰ্থনাসু সৰ্ৱ্ৱদা নিৱেদযামি, ");
INSERT INTO sanasm_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","এতস্মিন্ যমহং তৎপুত্ৰীযসুসংৱাদপ্ৰচাৰণেন মনসা পৰিচৰামি স ঈশ্ৱৰো মম সাক্ষী ৱিদ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","যতো যুষ্মাকং মম চ ৱিশ্ৱাসেন ৱযম্ উভযে যথা শান্তিযুক্তা ভৱাম ইতি কাৰণাদ্ ");
INSERT INTO sanasm_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","যুষ্মাকং স্থৈৰ্য্যকৰণাৰ্থং যুষ্মভ্যং কিঞ্চিৎপৰমাৰ্থদানদানায যুষ্মান্ সাক্ষাৎ কৰ্ত্তুং মদীযা ৱাঞ্ছা| ");
INSERT INTO sanasm_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","হে ভ্ৰাতৃগণ ভিন্নদেশীযলোকানাং মধ্যে যদ্ৱৎ তদ্ৱদ্ যুষ্মাকং মধ্যেপি যথা ফলং ভুঞ্জে তদভিপ্ৰাযেণ মুহুৰ্মুহু ৰ্যুষ্মাকং সমীপং গন্তুম্ উদ্যতোঽহং কিন্তু যাৱদ্ অদ্য তস্মিন্ গমনে মম ৱিঘ্নো জাত ইতি যূযং যদ্ অজ্ঞাতাস্তিষ্ঠথ তদহম্ উচিতং ন বুধ্যে| ");
INSERT INTO sanasm_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","অহং সভ্যাসভ্যানাং ৱিদ্ৱদৱিদ্ৱতাঞ্চ সৰ্ৱ্ৱেষাম্ ঋণী ৱিদ্যে| ");
INSERT INTO sanasm_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","অতএৱ ৰোমানিৱাসিনাং যুষ্মাকং সমীপেঽপি যথাশক্তি সুসংৱাদং প্ৰচাৰযিতুম্ অহম্ উদ্যতোস্মি| ");
INSERT INTO sanasm_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","যতঃ খ্ৰীষ্টস্য সুসংৱাদো মম লজ্জাস্পদং নহি স ঈশ্ৱৰস্য শক্তিস্ৱৰূপঃ সন্ আ যিহূদীযেভ্যো ঽন্যজাতীযান্ যাৱৎ সৰ্ৱ্ৱজাতীযানাং মধ্যে যঃ কশ্চিদ্ তত্ৰ ৱিশ্ৱসিতি তস্যৈৱ ত্ৰাণং জনযতি| ");
INSERT INTO sanasm_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","যতঃ প্ৰত্যযস্য সমপৰিমাণম্ ঈশ্ৱৰদত্তং পুণ্যং তৎসুসংৱাদে প্ৰকাশতে| তদধি ধৰ্ম্মপুস্তকেপি লিখিতমিদং \"পুণ্যৱান্ জনো ৱিশ্ৱাসেন জীৱিষ্যতি\"| ");
INSERT INTO sanasm_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","অতএৱ যে মানৱাঃ পাপকৰ্ম্মণা সত্যতাং ৰুন্ধন্তি তেষাং সৰ্ৱ্ৱস্য দুৰাচৰণস্যাধৰ্ম্মস্য চ ৱিৰুদ্ধং স্ৱৰ্গাদ্ ঈশ্ৱৰস্য কোপঃ প্ৰকাশতে| ");
INSERT INTO sanasm_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","যত ঈশ্ৱৰমধি যদ্যদ্ জ্ঞেযং তদ্ ঈশ্ৱৰঃ স্ৱযং তান্ প্ৰতি প্ৰকাশিতৱান্ তস্মাৎ তেষাম্ অগোচৰং নহি| ");
INSERT INTO sanasm_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","ফলতস্তস্যানন্তশক্তীশ্ৱৰৎৱাদীন্যদৃশ্যান্যপি সৃষ্টিকালম্ আৰভ্য কৰ্ম্মসু প্ৰকাশমানানি দৃশ্যন্তে তস্মাৎ তেষাং দোষপ্ৰক্ষালনস্য পন্থা নাস্তি| ");
INSERT INTO sanasm_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","অপৰম্ ঈশ্ৱৰং জ্ঞাৎৱাপি তে তম্ ঈশ্ৱৰজ্ঞানেন নাদ্ৰিযন্ত কৃতজ্ঞা ৱা ন জাতাঃ; তস্মাৎ তেষাং সৰ্ৱ্ৱে তৰ্কা ৱিফলীভূতাঃ, অপৰঞ্চ তেষাং ৱিৱেকশূন্যানি মনাংসি তিমিৰে মগ্নানি| ");
INSERT INTO sanasm_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","তে স্ৱান্ জ্ঞানিনো জ্ঞাৎৱা জ্ঞানহীনা অভৱন্ ");
INSERT INTO sanasm_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","অনশ্ৱৰস্যেশ্ৱৰস্য গৌৰৱং ৱিহায নশ্ৱৰমনুষ্যপশুপক্ষ্যুৰোগামিপ্ৰভৃতেৰাকৃতিৱিশিষ্টপ্ৰতিমাস্তৈৰাশ্ৰিতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","ইত্থং ত ঈশ্ৱৰস্য সত্যতাং ৱিহায মৃষামতম্ আশ্ৰিতৱন্তঃ সচ্চিদানন্দং সৃষ্টিকৰ্ত্তাৰং ত্যক্ত্ৱা সৃষ্টৱস্তুনঃ পূজাং সেৱাঞ্চ কৃতৱন্তঃ; ");
INSERT INTO sanasm_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","ইতি হেতোৰীশ্ৱৰস্তান্ কুক্ৰিযাযাং সমৰ্প্য নিজনিজকুচিন্তাভিলাষাভ্যাং স্ৱং স্ৱং শৰীৰং পৰস্পৰম্ অপমানিতং কৰ্ত্তুম্ অদদাৎ| ");
INSERT INTO sanasm_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","ঈশ্ৱৰেণ তেষু ক্ৱভিলাষে সমৰ্পিতেষু তেষাং যোষিতঃ স্ৱাভাৱিকাচৰণম্ অপহায ৱিপৰীতকৃত্যে প্ৰাৱৰ্ত্তন্ত; ");
INSERT INTO sanasm_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","তথা পুৰুষা অপি স্ৱাভাৱিকযোষিৎসঙ্গমং ৱিহায পৰস্পৰং কামকৃশানুনা দগ্ধাঃ সন্তঃ পুমাংসঃ পুংভিঃ সাকং কুকৃত্যে সমাসজ্য নিজনিজভ্ৰান্তেঃ সমুচিতং ফলম্ অলভন্ত| ");
INSERT INTO sanasm_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","তে স্ৱেষাং মনঃস্ৱীশ্ৱৰায স্থানং দাতুম্ অনিচ্ছুকাস্ততো হেতোৰীশ্ৱৰস্তান্ প্ৰতি দুষ্টমনস্কৎৱম্ অৱিহিতক্ৰিযৎৱঞ্চ দত্তৱান্| ");
INSERT INTO sanasm_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","অতএৱ তে সৰ্ৱ্ৱে ঽন্যাযো ৱ্যভিচাৰো দুষ্টৎৱং লোভো জিঘাংসা ঈৰ্ষ্যা ৱধো ৱিৱাদশ্চাতুৰী কুমতিৰিত্যাদিভি ৰ্দুষ্কৰ্ম্মভিঃ পৰিপূৰ্ণাঃ সন্তঃ ");
INSERT INTO sanasm_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","কৰ্ণেজপা অপৱাদিন ঈশ্ৱৰদ্ৱেষকা হিংসকা অহঙ্কাৰিণ আত্মশ্লাঘিনঃ কুকৰ্ম্মোৎপাদকাঃ পিত্ৰোৰাজ্ঞালঙ্ঘকা ");
INSERT INTO sanasm_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","অৱিচাৰকা নিযমলঙ্ঘিনঃ স্নেহৰহিতা অতিদ্ৱেষিণো নিৰ্দযাশ্চ জাতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","যে জনা এতাদৃশং কৰ্ম্ম কুৰ্ৱ্ৱন্তি তএৱ মৃতিযোগ্যা ঈশ্ৱৰস্য ৱিচাৰমীদৃশং জ্ঞাৎৱাপি ত এতাদৃশং কৰ্ম্ম স্ৱযং কুৰ্ৱ্ৱন্তি কেৱলমিতি নহি কিন্তু তাদৃশকৰ্ম্মকাৰিষু লোকেষ্ৱপি প্ৰীযন্তে| ");
INSERT INTO sanasm_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","হে পৰদূষক মনুষ্য যঃ কশ্চন ৎৱং ভৱসি তৱোত্তৰদানায পন্থা নাস্তি যতো যস্মাৎ কৰ্ম্মণঃ পৰস্ত্ৱযা দূষ্যতে তস্মাৎ ৎৱমপি দূষ্যসে, যতস্তং দূষযন্নপি ৎৱং তদ্ৱদ্ আচৰসি| ");
INSERT INTO sanasm_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","কিন্ত্ৱেতাদৃগাচাৰিভ্যো যং দণ্ডম্ ঈশ্ৱৰো নিশ্চিনোতি স যথাৰ্থ ইতি ৱযং জানীমঃ| ");
INSERT INTO sanasm_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","অতএৱ হে মানুষ ৎৱং যাদৃগাচাৰিণো দূষযসি স্ৱযং যদি তাদৃগাচৰসি তৰ্হি ৎৱম্ ঈশ্ৱৰদণ্ডাৎ পলাযিতুং শক্ষ্যসীতি কিং বুধ্যসে? ");
INSERT INTO sanasm_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","অপৰং তৱ মনসঃ পৰিৱৰ্ত্তনং কৰ্ত্তুম্ ইশ্ৱৰস্যানুগ্ৰহো ভৱতি তন্ন বুদ্ধ্ৱা ৎৱং কিং তদীযানুগ্ৰহক্ষমাচিৰসহিষ্ণুৎৱনিধিং তুচ্ছীকৰোষি? ");
INSERT INTO sanasm_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","তথা স্ৱান্তঃকৰণস্য কঠোৰৎৱাৎ খেদৰাহিত্যাচ্চেশ্ৱৰস্য ন্যায্যৱিচাৰপ্ৰকাশনস্য ক্ৰোধস্য চ দিনং যাৱৎ কিং স্ৱাৰ্থং কোপং সঞ্চিনোষি? ");
INSERT INTO sanasm_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","কিন্তু স একৈকমনুজায তৎকৰ্ম্মানুসাৰেণ প্ৰতিফলং দাস্যতি; ");
INSERT INTO sanasm_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","ৱস্তুতস্তু যে জনা ধৈৰ্য্যং ধৃৎৱা সৎকৰ্ম্ম কুৰ্ৱ্ৱন্তো মহিমা সৎকাৰোঽমৰৎৱঞ্চৈতানি মৃগযন্তে তেভ্যোঽনন্তাযু ৰ্দাস্যতি| ");
INSERT INTO sanasm_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","অপৰং যে জনাঃ সত্যধৰ্ম্মম্ অগৃহীৎৱা ৱিপৰীতধৰ্ম্মম্ গৃহ্লন্তি তাদৃশা ৱিৰোধিজনাঃ কোপং ক্ৰোধঞ্চ ভোক্ষ্যন্তে| ");
INSERT INTO sanasm_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","আ যিহূদিনোঽন্যদেশিনঃ পৰ্য্যন্তং যাৱন্তঃ কুকৰ্ম্মকাৰিণঃ প্ৰাণিনঃ সন্তি তে সৰ্ৱ্ৱে দুঃখং যাতনাঞ্চ গমিষ্যন্তি; ");
INSERT INTO sanasm_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","কিন্তু আ যিহূদিনো ভিন্নদেশিপৰ্য্যন্তা যাৱন্তঃ সৎকৰ্ম্মকাৰিণো লোকাঃ সন্তি তান্ প্ৰতি মহিমা সৎকাৰঃ শান্তিশ্চ ভৱিষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","ঈশ্ৱৰস্য ৱিচাৰে পক্ষপাতো নাস্তি| ");
INSERT INTO sanasm_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","অলব্ধৱ্যৱস্থাশাস্ত্ৰৈ ৰ্যৈঃ পাপানি কৃতানি ৱ্যৱস্থাশাস্ত্ৰালব্ধৎৱানুৰূপস্তেষাং ৱিনাশো ভৱিষ্যতি; কিন্তু লব্ধৱ্যৱস্থাশাস্ত্ৰা যে পাপান্যকুৰ্ৱ্ৱন্ ৱ্যৱস্থানুসাৰাদেৱ তেষাং ৱিচাৰো ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","ৱ্যৱস্থাশ্ৰোতাৰ ঈশ্ৱৰস্য সমীপে নিষ্পাপা ভৱিষ্যন্তীতি নহি কিন্তু ৱ্যৱস্থাচাৰিণ এৱ সপুণ্যা ভৱিষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","যতো ঽলব্ধৱ্যৱস্থাশাস্ত্ৰা ভিন্নদেশীযলোকা যদি স্ৱভাৱতো ৱ্যৱস্থানুৰূপান্ আচাৰান্ কুৰ্ৱ্ৱন্তি তৰ্হ্যলব্ধশাস্ত্ৰাঃ সন্তোঽপি তে স্ৱেষাং ৱ্যৱস্থাশাস্ত্ৰমিৱ স্ৱযমেৱ ভৱন্তি| ");
INSERT INTO sanasm_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","তেষাং মনসি সাক্ষিস্ৱৰূপে সতি তেষাং ৱিতৰ্কেষু চ কদা তান্ দোষিণঃ কদা ৱা নিৰ্দোষান্ কৃতৱৎসু তে স্ৱান্তৰ্লিখিতস্য ৱ্যৱস্থাশাস্ত্ৰস্য প্ৰমাণং স্ৱযমেৱ দদতি| ");
INSERT INTO sanasm_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","যস্মিন্ দিনে মযা প্ৰকাশিতস্য সুসংৱাদস্যানুসাৰাদ্ ঈশ্ৱৰো যীশুখ্ৰীষ্টেন মানুষাণাম্ অন্তঃকৰণানাং গূঢাভিপ্ৰাযান্ ধৃৎৱা ৱিচাৰযিষ্যতি তস্মিন্ ৱিচাৰদিনে তৎ প্ৰকাশিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","পশ্য ৎৱং স্ৱযং যিহূদীতি ৱিখ্যাতো ৱ্যৱস্থোপৰি ৱিশ্ৱাসং কৰোষি, ");
INSERT INTO sanasm_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ঈশ্ৱৰমুদ্দিশ্য স্ৱং শ্লাঘসে, তথা ৱ্যৱস্থযা শিক্ষিতো ভূৎৱা তস্যাভিমতং জানাসি, সৰ্ৱ্ৱাসাং কথানাং সাৰং ৱিৱিংক্ষে, ");
INSERT INTO sanasm_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","অপৰং জ্ঞানস্য সত্যতাযাশ্চাকৰস্ৱৰূপং শাস্ত্ৰং মম সমীপে ৱিদ্যত অতো ঽন্ধলোকানাং মাৰ্গদৰ্শযিতা ");
INSERT INTO sanasm_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","তিমিৰস্থিতলোকানাং মধ্যে দীপ্তিস্ৱৰূপোঽজ্ঞানলোকেভ্যো জ্ঞানদাতা শিশূনাং শিক্ষযিতাহমেৱেতি মন্যসে| ");
INSERT INTO sanasm_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","পৰান্ শিক্ষযন্ স্ৱযং স্ৱং কিং ন শিক্ষযসি? ৱস্তুতশ্চৌৰ্য্যনিষেধৱ্যৱস্থাং প্ৰচাৰযন্ ৎৱং কিং স্ৱযমেৱ চোৰযসি? ");
INSERT INTO sanasm_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","তথা পৰদাৰগমনং প্ৰতিষেধন্ স্ৱযং কিং পৰদাৰান্ গচ্ছসি? তথা ৎৱং স্ৱযং প্ৰতিমাদ্ৱেষী সন্ কিং মন্দিৰস্য দ্ৰৱ্যাণি হৰসি? ");
INSERT INTO sanasm_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","যস্ত্ৱং ৱ্যৱস্থাং শ্লাঘসে স ৎৱং কিং ৱ্যৱস্থাম্ অৱমত্য নেশ্ৱৰং সম্মন্যসে? ");
INSERT INTO sanasm_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","শাস্ত্ৰে যথা লিখতি \"ভিন্নদেশিনাং সমীপে যুষ্মাকং দোষাদ্ ঈশ্ৱৰস্য নাম্নো নিন্দা ভৱতি| \" ");
INSERT INTO sanasm_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","যদি ৱ্যৱস্থাং পালযসি তৰ্হি তৱ ৎৱক্ছেদক্ৰিযা সফলা ভৱতি; যতি ৱ্যৱস্থাং লঙ্ঘসে তৰ্হি তৱ ৎৱক্ছেদোঽৎৱক্ছেদো ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","যতো ৱ্যৱস্থাশাস্ত্ৰাদিষ্টধৰ্ম্মকৰ্ম্মাচাৰী পুমান্ অৎৱক্ছেদী সন্নপি কিং ৎৱক্ছেদিনাং মধ্যে ন গণযিষ্যতে? ");
INSERT INTO sanasm_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","কিন্তু লব্ধশাস্ত্ৰশ্ছিন্নৎৱক্ চ ৎৱং যদি ৱ্যৱস্থালঙ্ঘনং কৰোষি তৰ্হি ৱ্যৱস্থাপালকাঃ স্ৱাভাৱিকাচ্ছিন্নৎৱচো লোকাস্ত্ৱাং কিং ন দূষযিষ্যন্তি? ");
INSERT INTO sanasm_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","তস্মাদ্ যো বাহ্যে যিহূদী স যিহূদী নহি তথাঙ্গস্য যস্ত্ৱক্ছেদঃ স ৎৱক্ছেদো নহি; ");
INSERT INTO sanasm_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","কিন্তু যো জন আন্তৰিকো যিহূদী স এৱ যিহূদী অপৰঞ্চ কেৱললিখিতযা ৱ্যৱস্থযা ন কিন্তু মানসিকো যস্ত্ৱক্ছেদো যস্য চ প্ৰশংসা মনুষ্যেভ্যো ন ভূৎৱা ঈশ্ৱৰাদ্ ভৱতি স এৱ ৎৱক্ছেদঃ| ");
INSERT INTO sanasm_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","অপৰঞ্চ যিহূদিনঃ কিং শ্ৰেষ্ঠৎৱং? তথা ৎৱক্ছেদস্য ৱা কিং ফলং? ");
INSERT INTO sanasm_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","সৰ্ৱ্ৱথা বহূনি ফলানি সন্তি, ৱিশেষত ঈশ্ৱৰস্য শাস্ত্ৰং তেভ্যোঽদীযত| ");
INSERT INTO sanasm_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","কৈশ্চিদ্ অৱিশ্ৱসনে কৃতে তেষাম্ অৱিশ্ৱসনাৎ কিম্ ঈশ্ৱৰস্য ৱিশ্ৱাস্যতাযা হানিৰুৎপৎস্যতে? ");
INSERT INTO sanasm_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","কেনাপি প্ৰকাৰেণ নহি| যদ্যপি সৰ্ৱ্ৱে মনুষ্যা মিথ্যাৱাদিনস্তথাপীশ্ৱৰঃ সত্যৱাদী| শাস্ত্ৰে যথা লিখিতমাস্তে, অতস্ত্ৱন্তু স্ৱৱাক্যেন নিৰ্দ্দোষো হি ভৱিষ্যসি| ৱিচাৰে চৈৱ নিষ্পাপো ভৱিষ্যসি ন সংশযঃ| ");
INSERT INTO sanasm_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","অস্মাকম্ অন্যাযেন যদীশ্ৱৰস্য ন্যাযঃ প্ৰকাশতে তৰ্হি কিং ৱদিষ্যামঃ? অহং মানুষাণাং কথামিৱ কথাং কথযামি, ঈশ্ৱৰঃ সমুচিতং দণ্ডং দত্ত্ৱা কিম্ অন্যাযী ভৱিষ্যতি? ");
INSERT INTO sanasm_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","ইত্থং ন ভৱতু, তথা সতীশ্ৱৰঃ কথং জগতো ৱিচাৰযিতা ভৱিষ্যতি? ");
INSERT INTO sanasm_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","মম মিথ্যাৱাক্যৱদনাদ্ যদীশ্ৱৰস্য সত্যৎৱেন তস্য মহিমা ৱৰ্দ্ধতে তৰ্হি কস্মাদহং ৱিচাৰেঽপৰাধিৎৱেন গণ্যো ভৱামি? ");
INSERT INTO sanasm_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","মঙ্গলাৰ্থং পাপমপি কৰণীযমিতি ৱাক্যং ৎৱযা কুতো নোচ্যতে? কিন্তু যৈৰুচ্যতে তে নিতান্তং দণ্ডস্য পাত্ৰাণি ভৱন্তি; তথাপি তদ্ৱাক্যম্ অস্মাভিৰপ্যুচ্যত ইত্যস্মাকং গ্লানিং কুৰ্ৱ্ৱন্তঃ কিযন্তো লোকা ৱদন্তি| ");
INSERT INTO sanasm_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","অন্যলোকেভ্যো ৱযং কিং শ্ৰেষ্ঠাঃ? কদাচন নহি যতো যিহূদিনো ঽন্যদেশিনশ্চ সৰ্ৱ্ৱএৱ পাপস্যাযত্তা ইত্যস্য প্ৰমাণং ৱযং পূৰ্ৱ্ৱম্ অদদাম| ");
INSERT INTO sanasm_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","লিপি ৰ্যথাস্তে, নৈকোপি ধাৰ্ম্মিকো জনঃ| ");
INSERT INTO sanasm_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","তথা জ্ঞানীশ্ৱৰজ্ঞানী মানৱঃ কোপি নাস্তি হি| ");
INSERT INTO sanasm_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","ৱিমাৰ্গগামিনঃ সৰ্ৱ্ৱে সৰ্ৱ্ৱে দুষ্কৰ্ম্মকাৰিণঃ| একো জনোপি নো তেষাং সাধুকৰ্ম্ম কৰোতি চ| ");
INSERT INTO sanasm_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","তথা তেষান্তু ৱৈ কণ্ঠা অনাৱৃতশ্মশানৱৎ| স্তুতিৱাদং প্ৰকুৰ্ৱ্ৱন্তি জিহ্ৱাভিস্তে তু কেৱলং| তেষামোষ্ঠস্য নিম্নে তু ৱিষং তিষ্ঠতি সৰ্প্পৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","মুখং তেষাং হি শাপেন কপটেন চ পূৰ্য্যতে| ");
INSERT INTO sanasm_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","ৰক্তপাতায তেষাং তু পদানি ক্ষিপ্ৰগানি চ| ");
INSERT INTO sanasm_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","পথি তেষাং মনুষ্যাণাং নাশঃ ক্লেশশ্চ কেৱলঃ| ");
INSERT INTO sanasm_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","তে জনা নহি জানন্তি পন্থানং সুখদাযিনং| ");
INSERT INTO sanasm_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","পৰমেশাদ্ ভযং যত্তৎ তচ্চক্ষুষোৰগোচৰং| ");
INSERT INTO sanasm_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","ৱ্যৱস্থাযাং যদ্যল্লিখতি তদ্ ৱ্যৱস্থাধীনান্ লোকান্ উদ্দিশ্য লিখতীতি ৱযং জানীমঃ| ততো মনুষ্যমাত্ৰো নিৰুত্তৰঃ সন্ ঈশ্ৱৰস্য সাক্ষাদ্ অপৰাধী ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","অতএৱ ৱ্যৱস্থানুৰূপৈঃ কৰ্ম্মভিঃ কশ্চিদপি প্ৰাণীশ্ৱৰস্য সাক্ষাৎ সপুণ্যীকৃতো ভৱিতুং ন শক্ষ্যতি যতো ৱ্যৱস্থযা পাপজ্ঞানমাত্ৰং জাযতে| ");
INSERT INTO sanasm_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","কিন্তু ৱ্যৱস্থাযাঃ পৃথগ্ ঈশ্ৱৰেণ দেযং যৎ পুণ্যং তদ্ ৱ্যৱস্থাযা ভৱিষ্যদ্ৱাদিগণস্য চ ৱচনৈঃ প্ৰমাণীকৃতং সদ্ ইদানীং প্ৰকাশতে| ");
INSERT INTO sanasm_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","যীশুখ্ৰীষ্টে ৱিশ্ৱাসকৰণাদ্ ঈশ্ৱৰেণ দত্তং তৎ পুণ্যং সকলেষু প্ৰকাশিতং সৎ সৰ্ৱ্ৱান্ ৱিশ্ৱাসিনঃ প্ৰতি ৱৰ্ত্ততে| ");
INSERT INTO sanasm_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","তেষাং কোপি প্ৰভেদো নাস্তি, যতঃ সৰ্ৱ্ৱএৱ পাপিন ঈশ্ৱৰীযতেজোহীনাশ্চ জাতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","ত ঈশ্ৱৰস্যানুগ্ৰহাদ্ মূল্যং ৱিনা খ্ৰীষ্টকৃতেন পৰিত্ৰাণেন সপুণ্যীকৃতা ভৱন্তি| ");
INSERT INTO sanasm_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","যস্মাৎ স্ৱশোণিতেন ৱিশ্ৱাসাৎ পাপনাশকো বলী ভৱিতুং স এৱ পূৰ্ৱ্ৱম্ ঈশ্ৱৰেণ নিশ্চিতঃ, ইত্থম্ ঈশ্ৱৰীযসহিষ্ণুৎৱাৎ পুৰাকৃতপাপানাং মাৰ্জ্জনকৰণে স্ৱীযযাথাৰ্থ্যং তেন প্ৰকাশ্যতে, ");
INSERT INTO sanasm_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","ৱৰ্ত্তমানকালীযমপি স্ৱযাথাৰ্থ্যং তেন প্ৰকাশ্যতে, অপৰং যীশৌ ৱিশ্ৱাসিনং সপুণ্যীকুৰ্ৱ্ৱন্নপি স যাথাৰ্থিকস্তিষ্ঠতি| ");
INSERT INTO sanasm_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","তৰ্হি কুত্ৰাত্মশ্লাঘা? সা দূৰীকৃতা; কযা ৱ্যৱস্থযা? কিং ক্ৰিযাৰূপৱ্যৱস্থযা? ইত্থং নহি কিন্তু তৎ কেৱলৱিশ্ৱাসৰূপযা ৱ্যৱস্থযৈৱ ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","অতএৱ ৱ্যৱস্থানুৰূপাঃ ক্ৰিযা ৱিনা কেৱলেন ৱিশ্ৱাসেন মানৱঃ সপুণ্যীকৃতো ভৱিতুং শক্নোতীত্যস্য ৰাদ্ধান্তং দৰ্শযামঃ| ");
INSERT INTO sanasm_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","স কিং কেৱলযিহূদিনাম্ ঈশ্ৱৰো ভৱতি? ভিন্নদেশিনাম্ ঈশ্ৱৰো ন ভৱতি? ভিন্নদেশিনামপি ভৱতি; ");
INSERT INTO sanasm_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","যস্মাদ্ এক ঈশ্ৱৰো ৱিশ্ৱাসাৎ ৎৱক্ছেদিনো ৱিশ্ৱাসেনাৎৱক্ছেদিনশ্চ সপুণ্যীকৰিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","তৰ্হি ৱিশ্ৱাসেন ৱযং কিং ৱ্যৱস্থাং লুম্পাম? ইত্থং ন ভৱতু ৱযং ৱ্যৱস্থাং সংস্থাপযাম এৱ| ");
INSERT INTO sanasm_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","অস্মাকং পূৰ্ৱ্ৱপুৰুষ ইব্ৰাহীম্ কাযিকক্ৰিযযা কিং লব্ধৱান্ এতদধি কিং ৱদিষ্যামঃ? ");
INSERT INTO sanasm_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","স যদি নিজক্ৰিযাভ্যঃ সপুণ্যো ভৱেৎ তৰ্হি তস্যাত্মশ্লাঘাং কৰ্ত্তুং পন্থা ভৱেদিতি সত্যং, কিন্ত্ৱীশ্ৱৰস্য সমীপে নহি| ");
INSERT INTO sanasm_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","শাস্ত্ৰে কিং লিখতি? ইব্ৰাহীম্ ঈশ্ৱৰে ৱিশ্ৱসনাৎ স ৱিশ্ৱাসস্তস্মৈ পুণ্যাৰ্থং গণিতো বভূৱ| ");
INSERT INTO sanasm_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","কৰ্ম্মকাৰিণো যদ্ ৱেতনং তদ্ অনুগ্ৰহস্য ফলং নহি কিন্তু তেনোপাৰ্জিতং মন্তৱ্যম্| ");
INSERT INTO sanasm_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","কিন্তু যঃ পাপিনং সপুণ্যীকৰোতি তস্মিন্ ৱিশ্ৱাসিনঃ কৰ্ম্মহীনস্য জনস্য যো ৱিশ্ৱাসঃ স পুণ্যাৰ্থং গণ্যো ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","অপৰং যং ক্ৰিযাহীনম্ ঈশ্ৱৰঃ সপুণ্যীকৰোতি তস্য ধন্যৱাদং দাযূদ্ ৱৰ্ণযামাস, যথা, ");
INSERT INTO sanasm_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","স ধন্যোঽঘানি মৃষ্টানি যস্যাগাংস্যাৱৃতানি চ| ");
INSERT INTO sanasm_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","স চ ধন্যঃ পৰেশেন পাপং যস্য ন গণ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","এষ ধন্যৱাদস্ত্ৱক্ছেদিনম্ অৎৱক্ছেদিনং ৱা কং প্ৰতি ভৱতি? ইব্ৰাহীমো ৱিশ্ৱাসঃ পুণ্যাৰ্থং গণিত ইতি ৱযং ৱদামঃ| ");
INSERT INTO sanasm_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","স ৱিশ্ৱাসস্তস্য ৎৱক্ছেদিৎৱাৱস্থাযাং কিম্ অৎৱক্ছেদিৎৱাৱস্থাযাং কস্মিন্ সমযে পুণ্যমিৱ গণিতঃ? ৎৱক্ছেদিৎৱাৱস্থাযাং নহি কিন্ত্ৱৎৱক্ছেদিৎৱাৱস্থাযাং| ");
INSERT INTO sanasm_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","অপৰঞ্চ স যৎ সৰ্ৱ্ৱেষাম্ অৎৱক্ছেদিনাং ৱিশ্ৱাসিনাম্ আদিপুৰুষো ভৱেৎ, তে চ পুণ্যৱত্ত্ৱেন গণ্যেৰন্; ");
INSERT INTO sanasm_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","যে চ লোকাঃ কেৱলং ছিন্নৎৱচো ন সন্তো ঽস্মৎপূৰ্ৱ্ৱপুৰুষ ইব্ৰাহীম্ অছিন্নৎৱক্ সন্ যেন ৱিশ্ৱাসমাৰ্গেণ গতৱান্ তেনৈৱ তস্য পাদচিহ্নেন গচ্ছন্তি তেষাং ৎৱক্ছেদিনামপ্যাদিপুৰুষো ভৱেৎ তদৰ্থম্ অৎৱক্ছেদিনো মানৱস্য ৱিশ্ৱাসাৎ পুণ্যম্ উৎপদ্যত ইতি প্ৰমাণস্ৱৰূপং ৎৱক্ছেদচিহ্নং স প্ৰাপ্নোৎ| ");
INSERT INTO sanasm_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","ইব্ৰাহীম্ জগতোঽধিকাৰী ভৱিষ্যতি যৈষা প্ৰতিজ্ঞা তং তস্য ৱংশঞ্চ প্ৰতি পূৰ্ৱ্ৱম্ অক্ৰিযত সা ৱ্যৱস্থামূলিকা নহি কিন্তু ৱিশ্ৱাসজন্যপুণ্যমূলিকা| ");
INSERT INTO sanasm_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","যতো ৱ্যৱস্থাৱলম্বিনো যদ্যধিকাৰিণো ভৱন্তি তৰ্হি ৱিশ্ৱাসো ৱিফলো জাযতে সা প্ৰতিজ্ঞাপি লুপ্তৈৱ| ");
INSERT INTO sanasm_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","অধিকন্তু ৱ্যৱস্থা কোপং জনযতি যতো ঽৱিদ্যমানাযাং ৱ্যৱস্থাযাম্ আজ্ঞালঙ্ঘনং ন সম্ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","অতএৱ সা প্ৰতিজ্ঞা যদ্ অনুগ্ৰহস্য ফলং ভৱেৎ তদৰ্থং ৱিশ্ৱাসমূলিকা যতস্তথাৎৱে তদ্ৱংশসমুদাযং প্ৰতি অৰ্থতো যে ৱ্যৱস্থযা তদ্ৱংশসম্ভৱাঃ কেৱলং তান্ প্ৰতি নহি কিন্তু য ইব্ৰাহীমীযৱিশ্ৱাসেন তৎসম্ভৱাস্তানপি প্ৰতি সা প্ৰতিজ্ঞা স্থাস্নুৰ্ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","যো নিৰ্জীৱান্ সজীৱান্ অৱিদ্যমানানি ৱস্তূনি চ ৱিদ্যমানানি কৰোতি ইব্ৰাহীমো ৱিশ্ৱাসভূমেস্তস্যেশ্ৱৰস্য সাক্ষাৎ সোঽস্মাকং সৰ্ৱ্ৱেষাম্ আদিপুৰুষ আস্তে, যথা লিখিতং ৱিদ্যতে, অহং ৎৱাং বহুজাতীনাম্ আদিপুৰুষং কৃৎৱা নিযুক্তৱান্| ");
INSERT INTO sanasm_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","ৎৱদীযস্তাদৃশো ৱংশো জনিষ্যতে যদিদং ৱাক্যং প্ৰতিশ্ৰুতং তদনুসাৰাদ্ ইব্ৰাহীম্ বহুদেশীযলোকানাম্ আদিপুৰুষো যদ্ ভৱতি তদৰ্থং সোঽনপেক্ষিতৱ্যমপ্যপেক্ষমাণো ৱিশ্ৱাসং কৃতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","অপৰঞ্চ ক্ষীণৱিশ্ৱাসো ন ভূৎৱা শতৱৎসৰৱযস্কৎৱাৎ স্ৱশৰীৰস্য জৰাং সাৰানাম্নঃ স্ৱভাৰ্য্যাযা ৰজোনিৱৃত্তিঞ্চ তৃণায ন মেনে| ");
INSERT INTO sanasm_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","অপৰম্ অৱিশ্ৱাসাদ্ ঈশ্ৱৰস্য প্ৰতিজ্ঞাৱচনে কমপি সংশযং ন চকাৰ; ");
INSERT INTO sanasm_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","কিন্ত্ৱীশ্ৱৰেণ যৎ প্ৰতিশ্ৰুতং তৎ সাধযিতুং শক্যত ইতি নিশ্চিতং ৱিজ্ঞায দৃঢৱিশ্ৱাসঃ সন্ ঈশ্ৱৰস্য মহিমানং প্ৰকাশযাঞ্চকাৰ| ");
INSERT INTO sanasm_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","ইতি হেতোস্তস্য স ৱিশ্ৱাসস্তদীযপুণ্যমিৱ গণযাঞ্চক্ৰে| ");
INSERT INTO sanasm_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","পুণ্যমিৱাগণ্যত তৎ কেৱলস্য তস্য নিমিত্তং লিখিতং নহি, অস্মাকং নিমিত্তমপি, ");
INSERT INTO sanasm_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","যতোঽস্মাকং পাপনাশাৰ্থং সমৰ্পিতোঽস্মাকং পুণ্যপ্ৰাপ্ত্যৰ্থঞ্চোত্থাপিতোঽভৱৎ যোঽস্মাকং প্ৰভু ৰ্যীশুস্তস্যোত্থাপযিতৰীশ্ৱৰে ");
INSERT INTO sanasm_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","যদি ৱযং ৱিশ্ৱসামস্তৰ্হ্যস্মাকমপি সএৱ ৱিশ্ৱাসঃ পুণ্যমিৱ গণযিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","ৱিশ্ৱাসেন সপুণ্যীকৃতা ৱযম্ ঈশ্ৱৰেণ সাৰ্দ্ধং প্ৰভুণাস্মাকং যীশুখ্ৰীষ্টেন মেলনং প্ৰাপ্তাঃ| ");
INSERT INTO sanasm_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","অপৰং ৱযং যস্মিন্ অনুগ্ৰহাশ্ৰযে তিষ্ঠামস্তন্মধ্যং ৱিশ্ৱাসমাৰ্গেণ তেনৈৱানীতা ৱযম্ ঈশ্ৱৰীযৱিভৱপ্ৰাপ্তিপ্ৰত্যাশযা সমানন্দামঃ| ");
INSERT INTO sanasm_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","তৎ কেৱলং নহি কিন্তু ক্লেশভোগেঽপ্যানন্দামো যতঃ ক্লেশাाদ্ ধৈৰ্য্যং জাযত ইতি ৱযং জানীমঃ, ");
INSERT INTO sanasm_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ধৈৰ্য্যাচ্চ পৰীক্ষিতৎৱং জাযতে, পৰীক্ষিতৎৱাৎ প্ৰত্যাশা জাযতে, ");
INSERT INTO sanasm_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","প্ৰত্যাশাতো ৱ্ৰীডিতৎৱং ন জাযতে, যস্মাদ্ অস্মভ্যং দত্তেন পৱিত্ৰেণাত্মনাস্মাকম্ অন্তঃকৰণানীশ্ৱৰস্য প্ৰেমৱাৰিণা সিক্তানি| ");
INSERT INTO sanasm_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","অস্মাসু নিৰুপাযেষু সৎসু খ্ৰীষ্ট উপযুক্তে সমযে পাপিনাং নিমিত্তং স্ৱীযান্ প্ৰণান্ অত্যজৎ| ");
INSERT INTO sanasm_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","হিতকাৰিণো জনস্য কৃতে কোপি প্ৰণান্ ত্যক্তুং সাহসং কৰ্ত্তুং শক্নোতি, কিন্তু ধাৰ্ম্মিকস্য কৃতে প্ৰাযেণ কোপি প্ৰাণান্ ন ত্যজতি| ");
INSERT INTO sanasm_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","কিন্ত্ৱস্মাসু পাপিষু সৎস্ৱপি নিমিত্তমস্মাকং খ্ৰীষ্টঃ স্ৱপ্ৰাণান্ ত্যক্তৱান্, তত ঈশ্ৱৰোস্মান্ প্ৰতি নিজং পৰমপ্ৰেমাণং দৰ্শিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","অতএৱ তস্য ৰক্তপাতেন সপুণ্যীকৃতা ৱযং নিতান্তং তেন কোপাদ্ উদ্ধাৰিষ্যামহে| ");
INSERT INTO sanasm_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","ফলতো ৱযং যদা ৰিপৱ আস্ম তদেশ্ৱৰস্য পুত্ৰস্য মৰণেন তেন সাৰ্দ্ধং যদ্যস্মাকং মেলনং জাতং তৰ্হি মেলনপ্ৰাপ্তাঃ সন্তোঽৱশ্যং তস্য জীৱনেন ৰক্ষাং লপ্স্যামহে| ");
INSERT INTO sanasm_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","তৎ কেৱলং নহি কিন্তু যেন মেলনম্ অলভামহি তেনাস্মাকং প্ৰভুণা যীশুখ্ৰীষ্টেন সাম্প্ৰতম্ ঈশ্ৱৰে সমানন্দামশ্চ| ");
INSERT INTO sanasm_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","তথা সতি, একেন মানুষেণ পাপং পাপেন চ মৰণং জগতীং প্ৰাৱিশৎ অপৰং সৰ্ৱ্ৱেষাং পাপিৎৱাৎ সৰ্ৱ্ৱে মানুষা মৃতে ৰ্নিঘ্না অভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","যতো ৱ্যৱস্থাদানসমযং যাৱৎ জগতি পাপম্ আসীৎ কিন্তু যত্ৰ ৱ্যৱস্থা ন ৱিদ্যতে তত্ৰ পাপস্যাপি গণনা ন ৱিদ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","তথাপ্যাদমা যাদৃশং পাপং কৃতং তাদৃশং পাপং যৈ ৰ্নাকাৰি আদমম্ আৰভ্য মূসাং যাৱৎ তেষামপ্যুপৰি মৃত্যূ ৰাজৎৱম্ অকৰোৎ স আদম্ ভাৱ্যাদমো নিদৰ্শনমেৱাস্তে| ");
INSERT INTO sanasm_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","কিন্তু পাপকৰ্ম্মণো যাদৃশো ভাৱস্তাদৃগ্ দানকৰ্ম্মণো ভাৱো ন ভৱতি যত একস্য জনস্যাপৰাধেন যদি বহূনাং মৰণম্ অঘটত তথাপীশ্ৱৰানুগ্ৰহস্তদনুগ্ৰহমূলকং দানঞ্চৈকেন জনেনাৰ্থাদ্ যীশুনা খ্ৰীষ্টেন বহুষু বাহুল্যাতিবাহুল্যেন ফলতি| ");
INSERT INTO sanasm_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","অপৰম্ একস্য জনস্য পাপকৰ্ম্ম যাদৃক্ ফলযুক্তং দানকৰ্ম্ম তাদৃক্ ন ভৱতি যতো ৱিচাৰকৰ্ম্মৈকং পাপম্ আৰভ্য দণ্ডজনকং বভূৱ, কিন্তু দানকৰ্ম্ম বহুপাপান্যাৰভ্য পুণ্যজনকং বভূৱ| ");
INSERT INTO sanasm_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","যত একস্য জনস্য পাপকৰ্ম্মতস্তেনৈকেন যদি মৰণস্য ৰাজৎৱং জাতং তৰ্হি যে জনা অনুগ্ৰহস্য বাহুল্যং পুণ্যদানঞ্চ প্ৰাপ্নুৱন্তি ত একেন জনেন, অৰ্থাৎ যীশুখ্ৰীষ্টেন, জীৱনে ৰাজৎৱম্ অৱশ্যং কৰিষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","একোঽপৰাধো যদ্ৱৎ সৰ্ৱ্ৱমানৱানাং দণ্ডগামী মাৰ্গো ঽভৱৎ তদ্ৱদ্ একং পুণ্যদানং সৰ্ৱ্ৱমানৱানাং জীৱনযুক্তপুণ্যগামী মাৰ্গ এৱ| ");
INSERT INTO sanasm_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","অপৰম্ একস্য জনস্যাজ্ঞালঙ্ঘনাদ্ যথা বহৱো ঽপৰাধিনো জাতাস্তদ্ৱদ্ একস্যাজ্ঞাচৰণাদ্ বহৱঃ সপুণ্যীকৃতা ভৱন্তি| ");
INSERT INTO sanasm_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","অধিকন্তু ৱ্যৱস্থাগমনাদ্ অপৰাধস্য বাহুল্যং জাতং কিন্তু যত্ৰ পাপস্য বাহুল্যং তত্ৰৈৱ তস্মাদ্ অনুগ্ৰহস্য বাহুল্যম্ অভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","তেন মৃত্যুনা যদ্ৱৎ পাপস্য ৰাজৎৱম্ অভৱৎ তদ্ৱদ্ অস্মাকং প্ৰভুযীশুখ্ৰীষ্টদ্ৱাৰানন্তজীৱনদাযিপুণ্যেনানুগ্ৰহস্য ৰাজৎৱং ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","প্ৰভূতৰূপেণ যদ্ অনুগ্ৰহঃ প্ৰকাশতে তদৰ্থং পাপে তিষ্ঠাম ইতি ৱাক্যং কিং ৱযং ৱদিষ্যামঃ? তন্ন ভৱতু| ");
INSERT INTO sanasm_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","পাপং প্ৰতি মৃতা ৱযং পুনস্তস্মিন্ কথম্ জীৱিষ্যামঃ? ");
INSERT INTO sanasm_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","ৱযং যাৱন্তো লোকা যীশুখ্ৰীষ্টে মজ্জিতা অভৱাম তাৱন্ত এৱ তস্য মৰণে মজ্জিতা ইতি কিং যূযং ন জানীথ? ");
INSERT INTO sanasm_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","ততো যথা পিতুঃ পৰাক্ৰমেণ শ্মশানাৎ খ্ৰীষ্ট উত্থাপিতস্তথা ৱযমপি যৎ নূতনজীৱিন ইৱাচৰামস্তদৰ্থং মজ্জনেন তেন সাৰ্দ্ধং মৃত্যুৰূপে শ্মশানে সংস্থাপিতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","অপৰং ৱযং যদি তেন সংযুক্তাঃ সন্তঃ স ইৱ মৰণভাগিনো জাতাস্তৰ্হি স ইৱোত্থানভাগিনোঽপি ভৱিষ্যামঃ| ");
INSERT INTO sanasm_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","ৱযং যৎ পাপস্য দাসাঃ পুন ৰ্ন ভৱামস্তদৰ্থম্ অস্মাকং পাপৰূপশৰীৰস্য ৱিনাশাৰ্থম্ অস্মাকং পুৰাতনপুৰুষস্তেন সাকং ক্ৰুশেঽহন্যতেতি ৱযং জানীমঃ| ");
INSERT INTO sanasm_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","যো হতঃ স পাপাৎ মুক্ত এৱ| ");
INSERT INTO sanasm_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","অতএৱ যদি ৱযং খ্ৰীষ্টেন সাৰ্দ্ধম্ অহন্যামহি তৰ্হি পুনৰপি তেন সহিতা জীৱিষ্যাম ইত্যত্ৰাস্মাকং ৱিশ্ৱাসো ৱিদ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","যতঃ শ্মশানাদ্ উত্থাপিতঃ খ্ৰীষ্টো পুন ৰ্ন ম্ৰিযত ইতি ৱযং জানীমঃ| তস্মিন্ কোপ্যধিকাৰো মৃত্যো ৰ্নাস্তি| ");
INSERT INTO sanasm_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","অপৰঞ্চ স যদ্ অম্ৰিযত তেনৈকদা পাপম্ উদ্দিশ্যাম্ৰিযত, যচ্চ জীৱতি তেনেশ্ৱৰম্ উদ্দিশ্য জীৱতি; ");
INSERT INTO sanasm_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","তদ্ৱদ্ যূযমপি স্ৱান্ পাপম্ উদ্দিশ্য মৃতান্ অস্মাকং প্ৰভুণা যীশুখ্ৰীষ্টেনেশ্ৱৰম্ উদ্দিশ্য জীৱন্তো জানীত| ");
INSERT INTO sanasm_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","অপৰঞ্চ কুৎসিতাভিলাষাाন্ পূৰযিতুং যুষ্মাকং মৰ্ত্যদেহেষু পাপম্ আধিপত্যং ন কৰোতু| ");
INSERT INTO sanasm_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","অপৰং স্ৱং স্ৱম্ অঙ্গম্ অধৰ্ম্মস্যাস্ত্ৰং কৃৎৱা পাপসেৱাযাং ন সমৰ্পযত, কিন্তু শ্মশানাদ্ উত্থিতানিৱ স্ৱান্ ঈশ্ৱৰে সমৰ্পযত স্ৱান্যঙ্গানি চ ধৰ্ম্মাস্ত্ৰস্ৱৰূপাণীশ্ৱৰম্ উদ্দিশ্য সমৰ্পযত| ");
INSERT INTO sanasm_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","যুষ্মাকম্ উপৰি পাপস্যাধিপত্যং পুন ৰ্ন ভৱিষ্যতি, যস্মাদ্ যূযং ৱ্যৱস্থাযা অনাযত্তা অনুগ্ৰহস্য চাযত্তা অভৱত| ");
INSERT INTO sanasm_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","কিন্তু ৱযং ৱ্যৱস্থাযা অনাযত্তা অনুগ্ৰহস্য চাযত্তা অভৱাম, ইতি কাৰণাৎ কিং পাপং কৰিষ্যামঃ? তন্ন ভৱতু| ");
INSERT INTO sanasm_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","যতো মৃতিজনকং পাপং পুণ্যজনকং নিদেশাচৰণঞ্চৈতযোৰ্দ্ৱযো ৰ্যস্মিন্ আজ্ঞাপালনাৰ্থং ভৃত্যানিৱ স্ৱান্ সমৰ্পযথ, তস্যৈৱ ভৃত্যা ভৱথ, এতৎ কিং যূযং ন জানীথ? ");
INSERT INTO sanasm_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","অপৰঞ্চ পূৰ্ৱ্ৱং যূযং পাপস্য ভৃত্যা আস্তেতি সত্যং কিন্তু যস্যাং শিক্ষাৰূপাযাং মূষাযাং নিক্ষিপ্তা অভৱত তস্যা আকৃতিং মনোভি ৰ্লব্ধৱন্ত ইতি কাৰণাদ্ ঈশ্ৱৰস্য ধন্যৱাদো ভৱতু| ");
INSERT INTO sanasm_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","ইত্থং যূযং পাপসেৱাতো মুক্তাঃ সন্তো ধৰ্ম্মস্য ভৃত্যা জাতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","যুষ্মাকং শাৰীৰিক্যা দুৰ্ব্বলতাযা হেতো ৰ্মানৱৱদ্ অহম্ এতদ্ ব্ৰৱীমি; পুনঃ পুনৰধৰ্ম্মকৰণাৰ্থং যদ্ৱৎ পূৰ্ৱ্ৱং পাপামেধ্যযো ৰ্ভৃত্যৎৱে নিজাঙ্গানি সমাৰ্পযত তদ্ৱদ্ ইদানীং সাধুকৰ্ম্মকৰণাৰ্থং ধৰ্ম্মস্য ভৃত্যৎৱে নিজাঙ্গানি সমৰ্পযত| ");
INSERT INTO sanasm_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","যদা যূযং পাপস্য ভৃত্যা আস্ত তদা ধৰ্ম্মস্য নাযত্তা আস্ত| ");
INSERT INTO sanasm_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","তৰ্হি যানি কৰ্ম্মাণি যূযম্ ইদানীং লজ্জাজনকানি বুধ্যধ্ৱে পূৰ্ৱ্ৱং তৈ ৰ্যুষ্মাকং কো লাভ আসীৎ? তেষাং কৰ্ম্মণাং ফলং মৰণমেৱ| ");
INSERT INTO sanasm_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","কিন্তু সাম্প্ৰতং যূযং পাপসেৱাতো মুক্তাঃ সন্ত ঈশ্ৱৰস্য ভৃত্যাঽভৱত তস্মাদ্ যুষ্মাকং পৱিত্ৰৎৱৰূপং লভ্যম্ অনন্তজীৱনৰূপঞ্চ ফলম্ আস্তে| ");
INSERT INTO sanasm_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","যতঃ পাপস্য ৱেতনং মৰণং কিন্ত্ৱস্মাকং প্ৰভুণা যীশুখ্ৰীষ্টেনানন্তজীৱনম্ ঈশ্ৱৰদত্তং পাৰিতোষিকম্ আস্তে| ");
INSERT INTO sanasm_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","হে ভ্ৰাতৃগণ ৱ্যৱস্থাৱিদঃ প্ৰতি মমেদং নিৱেদনং| ৱিধিঃ কেৱলং যাৱজ্জীৱং মানৱোপৰ্য্যধিপতিৎৱং কৰোতীতি যূযং কিং ন জানীথ? ");
INSERT INTO sanasm_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","যাৱৎকালং পতি ৰ্জীৱতি তাৱৎকালম্ ঊঢা ভাৰ্য্যা ৱ্যৱস্থযা তস্মিন্ বদ্ধা তিষ্ঠতি কিন্তু যদি পতি ৰ্ম্ৰিযতে তৰ্হি সা নাৰী পত্যু ৰ্ৱ্যৱস্থাতো মুচ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","এতৎকাৰণাৎ পত্যুৰ্জীৱনকালে নাৰী যদ্যন্যং পুৰুষং ৱিৱহতি তৰ্হি সা ৱ্যভিচাৰিণী ভৱতি কিন্তু যদি স পতি ৰ্ম্ৰিযতে তৰ্হি সা তস্যা ৱ্যৱস্থাযা মুক্তা সতী পুৰুষান্তৰেণ ৱ্যূঢাপি ৱ্যভিচাৰিণী ন ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","হে মম ভ্ৰাতৃগণ, ঈশ্ৱৰনিমিত্তং যদস্মাকং ফলং জাযতে তদৰ্থং শ্মশানাদ্ উত্থাপিতেন পুৰুষেণ সহ যুষ্মাকং ৱিৱাহো যদ্ ভৱেৎ তদৰ্থং খ্ৰীষ্টস্য শৰীৰেণ যূযং ৱ্যৱস্থাং প্ৰতি মৃতৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","যতোঽস্মাকং শাৰীৰিকাচৰণসমযে মৰণনিমিত্তং ফলম্ উৎপাদযিতুং ৱ্যৱস্থযা দূষিতঃ পাপাভিলাষোঽস্মাকম্ অঙ্গেষু জীৱন্ আসীৎ| ");
INSERT INTO sanasm_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","কিন্তু তদা যস্যা ৱ্যৱস্থাযা ৱশে আস্মহি সাম্প্ৰতং তাং প্ৰতি মৃতৎৱাদ্ ৱযং তস্যা অধীনৎৱাৎ মুক্তা ইতি হেতোৰীশ্ৱৰোঽস্মাভিঃ পুৰাতনলিখিতানুসাৰাৎ ন সেৱিতৱ্যঃ কিন্তু নৱীনস্ৱভাৱেনৈৱ সেৱিতৱ্যঃ ");
INSERT INTO sanasm_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","তৰ্হি ৱযং কিং ব্ৰূমঃ? ৱ্যৱস্থা কিং পাপজনিকা ভৱতি? নেত্থং ভৱতু| ৱ্যৱস্থাম্ অৱিদ্যমানাযাং পাপং কিম্ ইত্যহং নাৱেদং; কিঞ্চ লোভং মা কাৰ্ষীৰিতি চেদ্ ৱ্যৱস্থাগ্ৰন্থে লিখিতং নাভৱিষ্যৎ তৰ্হি লোভঃ কিম্ভূতস্তদহং নাজ্ঞাস্যং| ");
INSERT INTO sanasm_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","কিন্তু ৱ্যৱস্থযা পাপং ছিদ্ৰং প্ৰাপ্যাস্মাকম্ অন্তঃ সৰ্ৱ্ৱৱিধং কুৎসিতাভিলাষম্ অজনযৎ; যতো ৱ্যৱস্থাযাম্ অৱিদ্যমানাযাং পাপং মৃতং| ");
INSERT INTO sanasm_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","অপৰং পূৰ্ৱ্ৱং ৱ্যৱস্থাযাম্ অৱিদ্যমানাযাম্ অহম্ অজীৱং ততঃ পৰম্ আজ্ঞাযাম্ উপস্থিতাযাম্ পাপম্ অজীৱৎ তদাহম্ অম্ৰিযে| ");
INSERT INTO sanasm_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","ইত্থং সতি জীৱননিমিত্তা যাজ্ঞা সা মম মৃত্যুজনিকাভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","যতঃ পাপং ছিদ্ৰং প্ৰাপ্য ৱ্যৱস্থিতাদেশেন মাং ৱঞ্চযিৎৱা তেন মাম্ অহন্| ");
INSERT INTO sanasm_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","অতএৱ ৱ্যৱস্থা পৱিত্ৰা, আদেশশ্চ পৱিত্ৰো ন্যায্যো হিতকাৰী চ ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","তৰ্হি যৎ স্ৱযং হিতকৃৎ তৎ কিং মম মৃত্যুজনকম্ অভৱৎ? নেত্থং ভৱতু; কিন্তু পাপং যৎ পাতকমিৱ প্ৰকাশতে তথা নিদেশেন পাপং যদতীৱ পাতকমিৱ প্ৰকাশতে তদৰ্থং হিতোপাযেন মম মৰণম্ অজনযৎ| ");
INSERT INTO sanasm_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","ৱ্যৱস্থাত্মবোধিকেতি ৱযং জানীমঃ কিন্ত্ৱহং শাৰীৰতাচাৰী পাপস্য ক্ৰীতকিঙ্কৰো ৱিদ্যে| ");
INSERT INTO sanasm_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","যতো যৎ কৰ্ম্ম কৰোমি তৎ মম মনোঽভিমতং নহি; অপৰং যন্ মম মনোঽভিমতং তন্ন কৰোমি কিন্তু যদ্ ঋতীযে তৎ কৰোমি| ");
INSERT INTO sanasm_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","তথাৎৱে যন্ মমানভিমতং তদ্ যদি কৰোমি তৰ্হি ৱ্যৱস্থা সূত্তমেতি স্ৱীকৰোমি| ");
INSERT INTO sanasm_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","অতএৱ সম্প্ৰতি তৎ কৰ্ম্ম মযা ক্ৰিযত ইতি নহি কিন্তু মম শৰীৰস্থেন পাপেনৈৱ ক্ৰিযতে| ");
INSERT INTO sanasm_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","যতো মযি, অৰ্থতো মম শৰীৰে, কিমপ্যুত্তমং ন ৱসতি, এতদ্ অহং জানামি; মমেচ্ছুকতাযাং তিষ্ঠন্ত্যামপ্যহম্ উত্তমকৰ্ম্মসাধনে সমৰ্থো ন ভৱামি| ");
INSERT INTO sanasm_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","যতো যামুত্তমাং ক্ৰিযাং কৰ্ত্তুমহং ৱাঞ্ছামি তাং ন কৰোমি কিন্তু যৎ কুৎসিতং কৰ্ম্ম কৰ্ত্তুম্ অনিচ্ছুকোঽস্মি তদেৱ কৰোমি| ");
INSERT INTO sanasm_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","অতএৱ যদ্যৎ কৰ্ম্ম কৰ্ত্তুং মমেচ্ছা ন ভৱতি তদ্ যদি কৰোমি তৰ্হি তৎ মযা ন ক্ৰিযতে, মমান্তৰ্ৱৰ্ত্তিনা পাপেনৈৱ ক্ৰিযতে| ");
INSERT INTO sanasm_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","ভদ্ৰং কৰ্ত্তুম্ ইচ্ছুকং মাং যো ঽভদ্ৰং কৰ্ত্তুং প্ৰৱৰ্ত্তযতি তাদৃশং স্ৱভাৱমেকং মযি পশ্যামি| ");
INSERT INTO sanasm_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","অহম্ আন্তৰিকপুৰুষেণেশ্ৱৰৱ্যৱস্থাযাং সন্তুষ্ট আসে; ");
INSERT INTO sanasm_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","কিন্তু তদ্ৱিপৰীতং যুধ্যন্তং তদন্যমেকং স্ৱভাৱং মদীযাঙ্গস্থিতং প্ৰপশ্যামি, স মদীযাঙ্গস্থিতপাপস্ৱভাৱস্যাযত্তং মাং কৰ্ত্তুং চেষ্টতে| ");
INSERT INTO sanasm_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","হা হা যোঽহং দুৰ্ভাগ্যো মনুজস্তং মাম্ এতস্মান্ মৃতাচ্ছৰীৰাৎ কো নিস্তাৰযিষ্যতি? ");
INSERT INTO sanasm_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","অস্মাকং প্ৰভুণা যীশুখ্ৰীষ্টেন নিস্তাৰযিতাৰম্ ঈশ্ৱৰং ধন্যং ৱদামি| অতএৱ শৰীৰেণ পাপৱ্যৱস্থাযা মনসা তু ঈশ্ৱৰৱ্যৱস্থাযাঃ সেৱনং কৰোমি| ");
INSERT INTO sanasm_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","যে জনাঃ খ্ৰীষ্টং যীশুম্ আশ্ৰিত্য শাৰীৰিকং নাচৰন্ত আত্মিকমাচৰন্তি তেঽধুনা দণ্ডাৰ্হা ন ভৱন্তি| ");
INSERT INTO sanasm_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","জীৱনদাযকস্যাত্মনো ৱ্যৱস্থা খ্ৰীষ্টযীশুনা পাপমৰণযো ৰ্ৱ্যৱস্থাতো মামমোচযৎ| ");
INSERT INTO sanasm_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","যস্মাচ্ছাৰীৰস্য দুৰ্ব্বলৎৱাদ্ ৱ্যৱস্থযা যৎ কৰ্ম্মাসাধ্যম্ ঈশ্ৱৰো নিজপুত্ৰং পাপিশৰীৰৰূপং পাপনাশকবলিৰূপঞ্চ প্ৰেষ্য তস্য শৰীৰে পাপস্য দণ্ডং কুৰ্ৱ্ৱন্ তৎকৰ্ম্ম সাধিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","ততঃ শাৰীৰিকং নাচৰিৎৱাস্মাভিৰাত্মিকম্ আচৰদ্ভিৰ্ৱ্যৱস্থাগ্ৰন্থে নিৰ্দ্দিষ্টানি পুণ্যকৰ্ম্মাণি সৰ্ৱ্ৱাণি সাধ্যন্তে| ");
INSERT INTO sanasm_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","যে শাৰীৰিকাচাৰিণস্তে শাৰীৰিকান্ ৱিষযান্ ভাৱযন্তি যে চাত্মিকাচাৰিণস্তে আত্মনো ৱিষযান্ ভাৱযন্তি| ");
INSERT INTO sanasm_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","শাৰীৰিকভাৱস্য ফলং মৃত্যুঃ কিঞ্চাত্মিকভাৱস্য ফলে জীৱনং শান্তিশ্চ| ");
INSERT INTO sanasm_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","যতঃ শাৰীৰিকভাৱ ঈশ্ৱৰস্য ৱিৰুদ্ধঃ শত্ৰুতাভাৱ এৱ স ঈশ্ৱৰস্য ৱ্যৱস্থাযা অধীনো ন ভৱতি ভৱিতুঞ্চ ন শক্নোতি| ");
INSERT INTO sanasm_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","এতস্মাৎ শাৰীৰিকাচাৰিষু তোষ্টুম্ ঈশ্ৱৰেণ ন শক্যং| ");
INSERT INTO sanasm_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","কিন্ত্ৱীশ্ৱৰস্যাত্মা যদি যুষ্মাকং মধ্যে ৱসতি তৰ্হি যূযং শাৰীৰিকাচাৰিণো ন সন্ত আত্মিকাচাৰিণো ভৱথঃ| যস্মিন্ তু খ্ৰীষ্টস্যাত্মা ন ৱিদ্যতে স তৎসম্ভৱো নহি| ");
INSERT INTO sanasm_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","যদি খ্ৰীষ্টো যুষ্মান্ অধিতিষ্ঠতি তৰ্হি পাপম্ উদ্দিশ্য শৰীৰং মৃতং কিন্তু পুণ্যমুদ্দিশ্যাত্মা জীৱতি| ");
INSERT INTO sanasm_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","মৃতগণাদ্ যীশু ৰ্যেনোত্থাপিতস্তস্যাত্মা যদি যুষ্মন্মধ্যে ৱসতি তৰ্হি মৃতগণাৎ খ্ৰীষ্টস্য স উত্থাপযিতা যুষ্মন্মধ্যৱাসিনা স্ৱকীযাত্মনা যুষ্মাকং মৃতদেহানপি পুন ৰ্জীৱযিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","হে ভ্ৰাতৃগণ শৰীৰস্য ৱযমধমৰ্ণা ন ভৱামোঽতঃ শাৰীৰিকাচাৰোঽস্মাভি ৰ্ন কৰ্ত্তৱ্যঃ| ");
INSERT INTO sanasm_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","যদি যূযং শৰীৰিকাচাৰিণো ভৱেত তৰ্হি যুষ্মাভি ৰ্মৰ্ত্তৱ্যমেৱ কিন্ত্ৱাত্মনা যদি শৰীৰকৰ্ম্মাণি ঘাতযেত তৰ্হি জীৱিষ্যথ| ");
INSERT INTO sanasm_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","যতো যাৱন্তো লোকা ঈশ্ৱৰস্যাত্মনাকৃষ্যন্তে তে সৰ্ৱ্ৱ ঈশ্ৱৰস্য সন্তানা ভৱন্তি| ");
INSERT INTO sanasm_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","যূযং পুনৰপি ভযজনকং দাস্যভাৱং ন প্ৰাপ্তাঃ কিন্তু যেন ভাৱেনেশ্ৱৰং পিতঃ পিতৰিতি প্ৰোচ্য সম্বোধযথ তাদৃশং দত্তকপুত্ৰৎৱভাৱম্ প্ৰাপ্নুত| ");
INSERT INTO sanasm_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","অপৰঞ্চ ৱযম্ ঈশ্ৱৰস্য সন্তানা এতস্মিন্ পৱিত্ৰ আত্মা স্ৱযম্ অস্মাকম্ আত্মাভিঃ সাৰ্দ্ধং প্ৰমাণং দদাতি| ");
INSERT INTO sanasm_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","অতএৱ ৱযং যদি সন্তানাস্তৰ্হ্যধিকাৰিণঃ, অৰ্থাদ্ ঈশ্ৱৰস্য স্ৱত্ত্ৱাধিকাৰিণঃ খ্ৰীষ্টেন সহাধিকাৰিণশ্চ ভৱামঃ; অপৰং তেন সাৰ্দ্ধং যদি দুঃখভাগিনো ভৱামস্তৰ্হি তস্য ৱিভৱস্যাপি ভাগিনো ভৱিষ্যামঃ| ");
INSERT INTO sanasm_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","কিন্ত্ৱস্মাসু যো ভাৱীৱিভৱঃ প্ৰকাশিষ্যতে তস্য সমীপে ৱৰ্ত্তমানকালীনং দুঃখমহং তৃণায মন্যে| ");
INSERT INTO sanasm_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","যতঃ প্ৰাণিগণ ঈশ্ৱৰস্য সন্তানানাং ৱিভৱপ্ৰাপ্তিম্ আকাঙ্ক্ষন্ নিতান্তম্ অপেক্ষতে| ");
INSERT INTO sanasm_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","অপৰঞ্চ প্ৰাণিগণঃ স্ৱৈৰম্ অলীকতাযা ৱশীকৃতো নাভৱৎ ");
INSERT INTO sanasm_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","কিন্তু প্ৰাণিগণোঽপি নশ্ৱৰতাধীনৎৱাৎ মুক্তঃ সন্ ঈশ্ৱৰস্য সন্তানানাং পৰমমুক্তিং প্ৰাপ্স্যতীত্যভিপ্ৰাযেণ ৱশীকৰ্ত্ৰা ৱশীচক্ৰে| ");
INSERT INTO sanasm_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","অপৰঞ্চ প্ৰসূযমানাৱদ্ ৱ্যথিতঃ সন্ ইদানীং যাৱৎ কৃৎস্নঃ প্ৰাণিগণ আৰ্ত্তস্ৱৰং কৰোতীতি ৱযং জানীমঃ| ");
INSERT INTO sanasm_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","কেৱলঃ স ইতি নহি কিন্তু প্ৰথমজাতফলস্ৱৰূপম্ আত্মানং প্ৰাপ্তা ৱযমপি দত্তকপুত্ৰৎৱপদপ্ৰাপ্তিম্ অৰ্থাৎ শৰীৰস্য মুক্তিং প্ৰতীক্ষমাণাস্তদ্ৱদ্ অন্তৰাৰ্ত্তৰাৱং কুৰ্ম্মঃ| ");
INSERT INTO sanasm_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","ৱযং প্ৰত্যাশযা ত্ৰাণম্ অলভামহি কিন্তু প্ৰত্যক্ষৱস্তুনো যা প্ৰত্যাশা সা প্ৰত্যাশা নহি, যতো মনুষ্যো যৎ সমীক্ষতে তস্য প্ৰত্যাশাং কুতঃ কৰিষ্যতি? ");
INSERT INTO sanasm_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","যদ্ অপ্ৰত্যক্ষং তস্য প্ৰত্যাশাং যদি ৱযং কুৰ্ৱ্ৱীমহি তৰ্হি ধৈৰ্য্যম্ অৱলম্ব্য প্ৰতীক্ষামহে| ");
INSERT INTO sanasm_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","তত আত্মাপি স্ৱযম্ অস্মাকং দুৰ্ব্বলতাযাঃ সহাযৎৱং কৰোতি; যতঃ কিং প্ৰাৰ্থিতৱ্যং তদ্ বোদ্ধুং ৱযং ন শক্নুমঃ, কিন্ত্ৱস্পষ্টৈৰাৰ্ত্তৰাৱৈৰাত্মা স্ৱযম্ অস্মন্নিমিত্তং নিৱেদযতি| ");
INSERT INTO sanasm_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","অপৰম্ ঈশ্ৱৰাভিমতৰূপেণ পৱিত্ৰলোকানাং কৃতে নিৱেদযতি য আত্মা তস্যাভিপ্ৰাযোঽন্তৰ্য্যামিনা জ্ঞাযতে| ");
INSERT INTO sanasm_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","অপৰম্ ঈশ্ৱৰীযনিৰূপণানুসাৰেণাহূতাঃ সন্তো যে তস্মিন্ প্ৰীযন্তে সৰ্ৱ্ৱাণি মিলিৎৱা তেষাং মঙ্গলং সাধযন্তি, এতদ্ ৱযং জানীমঃ| ");
INSERT INTO sanasm_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","যত ঈশ্ৱৰো বহুভ্ৰাতৃণাং মধ্যে স্ৱপুত্ৰং জ্যেষ্ঠং কৰ্ত্তুম্ ইচ্ছন্ যান্ পূৰ্ৱ্ৱং লক্ষ্যীকৃতৱান্ তান্ তস্য প্ৰতিমূৰ্ত্যাঃ সাদৃশ্যপ্ৰাপ্ত্যৰ্থং ন্যযুংক্ত| ");
INSERT INTO sanasm_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","অপৰঞ্চ তেন যে নিযুক্তাস্ত আহূতা অপি যে চ তেনাহূতাস্তে সপুণ্যীকৃতাঃ, যে চ তেন সপুণ্যীকৃতাস্তে ৱিভৱযুক্তাঃ| ");
INSERT INTO sanasm_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","ইত্যত্ৰ ৱযং কিং ব্ৰূমঃ? ঈশ্ৱৰো যদ্যস্মাকং সপক্ষো ভৱতি তৰ্হি কো ৱিপক্ষোঽস্মাকং? ");
INSERT INTO sanasm_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","আত্মপুত্ৰং ন ৰক্ষিৎৱা যোঽস্মাকং সৰ্ৱ্ৱেষাং কৃতে তং প্ৰদত্তৱান্ স কিং তেন সহাস্মভ্যম্ অন্যানি সৰ্ৱ্ৱাণি ন দাস্যতি? ");
INSERT INTO sanasm_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","ঈশ্ৱৰস্যাভিৰুচিতেষু কেন দোষ আৰোপযিষ্যতে? য ঈশ্ৱৰস্তান্ পুণ্যৱত ইৱ গণযতি কিং তেন? ");
INSERT INTO sanasm_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","অপৰং তেভ্যো দণ্ডদানাজ্ঞা ৱা কেন কৰিষ্যতে? যোঽস্মন্নিমিত্তং প্ৰাণান্ ত্যক্তৱান্ কেৱলং তন্ন কিন্তু মৃতগণমধ্যাদ্ উত্থিতৱান্, অপি চেশ্ৱৰস্য দক্ষিণে পাৰ্শ্ৱে তিষ্ঠন্ অদ্যাপ্যস্মাকং নিমিত্তং প্ৰাৰ্থত এৱম্ভূতো যঃ খ্ৰীষ্টঃ কিং তেন? ");
INSERT INTO sanasm_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","অস্মাভিঃ সহ খ্ৰীষ্টস্য প্ৰেমৱিচ্ছেদং জনযিতুং কঃ শক্নোতি? ক্লেশো ৱ্যসনং ৱা তাডনা ৱা দুৰ্ভিক্ষং ৱা ৱস্ত্ৰহীনৎৱং ৱা প্ৰাণসংশযো ৱা খঙ্গো ৱা কিমেতানি শক্নুৱন্তি? ");
INSERT INTO sanasm_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","কিন্তু লিখিতম্ আস্তে, যথা, ৱযং তৱ নিমিত্তং স্মো মৃত্যুৱক্ত্ৰেঽখিলং দিনং| বলিৰ্দেযো যথা মেষো ৱযং গণ্যামহে তথা| ");
INSERT INTO sanasm_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","অপৰং যোঽস্মাসু প্ৰীযতে তেনৈতাসু ৱিপৎসু ৱযং সম্যগ্ ৱিজযামহে| ");
INSERT INTO sanasm_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","যতোঽস্মাকং প্ৰভুনা যীশুখ্ৰীষ্টেনেশ্ৱৰস্য যৎ প্ৰেম তস্মাদ্ অস্মাকং ৱিচ্ছেদং জনযিতুং মৃত্যু ৰ্জীৱনং ৱা দিৱ্যদূতা ৱা বলৱন্তো মুখ্যদূতা ৱা ৱৰ্ত্তমানো ৱা ভৱিষ্যন্ কালো ৱা উচ্চপদং ৱা নীচপদং ৱাপৰং কিমপি সৃষ্টৱস্তু ");
INSERT INTO sanasm_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ৱৈতেষাং কেনাপি ন শক্যমিত্যস্মিন্ দৃঢৱিশ্ৱাসো মমাস্তে| ");
INSERT INTO sanasm_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","অহং কাঞ্চিদ্ কল্পিতাং কথাং ন কথযামি, খ্ৰীষ্টস্য সাক্ষাৎ সত্যমেৱ ব্ৰৱীমি পৱিত্ৰস্যাত্মনঃ সাক্ষান্ মদীযং মন এতৎ সাক্ষ্যং দদাতি| ");
INSERT INTO sanasm_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","মমান্তৰতিশযদুঃখং নিৰন্তৰং খেদশ্চ ");
INSERT INTO sanasm_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","তস্মাদ্ অহং স্ৱজাতীযভ্ৰাতৃণাং নিমিত্তাৎ স্ৱযং খ্ৰীষ্টাচ্ছাপাক্ৰান্তো ভৱিতুম্ ঐচ্ছম্| ");
INSERT INTO sanasm_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","যতস্ত ইস্ৰাযেলস্য ৱংশা অপি চ দত্তকপুত্ৰৎৱং তেজো নিযমো ৱ্যৱস্থাদানং মন্দিৰে ভজনং প্ৰতিজ্ঞাঃ পিতৃপুৰুষগণশ্চৈতেষু সৰ্ৱ্ৱেষু তেষাম্ অধিকাৰোঽস্তি| ");
INSERT INTO sanasm_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","তৎ কেৱলং নহি কিন্তু সৰ্ৱ্ৱাধ্যক্ষঃ সৰ্ৱ্ৱদা সচ্চিদানন্দ ঈশ্ৱৰো যঃ খ্ৰীষ্টঃ সোঽপি শাৰীৰিকসম্বন্ধেন তেষাং ৱংশসম্ভৱঃ| ");
INSERT INTO sanasm_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","ঈশ্ৱৰস্য ৱাক্যং ৱিফলং জাতম্ ইতি নহি যৎকাৰণাদ্ ইস্ৰাযেলো ৱংশে যে জাতাস্তে সৰ্ৱ্ৱে ৱস্তুত ইস্ৰাযেলীযা ন ভৱন্তি| ");
INSERT INTO sanasm_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","অপৰম্ ইব্ৰাহীমো ৱংশে জাতা অপি সৰ্ৱ্ৱে তস্যৈৱ সন্তানা ন ভৱন্তি কিন্তু ইস্হাকো নাম্না তৱ ৱংশো ৱিখ্যাতো ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","অৰ্থাৎ শাৰীৰিকসংসৰ্গাৎ জাতাঃ সন্তানা যাৱন্তস্তাৱন্ত এৱেশ্ৱৰস্য সন্তানা ন ভৱন্তি কিন্তু প্ৰতিশ্ৰৱণাদ্ যে জাযন্তে তএৱেশ্ৱৰৱংশো গণ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","যতস্তৎপ্ৰতিশ্ৰুতে ৰ্ৱাক্যমেতৎ, এতাদৃশে সমযে ঽহং পুনৰাগমিষ্যামি তৎপূৰ্ৱ্ৱং সাৰাযাঃ পুত্ৰ একো জনিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","অপৰমপি ৱদামি স্ৱমনোঽভিলাষত ঈশ্ৱৰেণ যন্নিৰূপিতং তৎ কৰ্ম্মতো নহি কিন্ত্ৱাহ্ৱযিতু ৰ্জাতমেতদ্ যথা সিদ্ধ্যতি ");
INSERT INTO sanasm_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","তদৰ্থং ৰিব্কানামিকযা যোষিতা জনৈকস্মাদ্ অৰ্থাদ্ অস্মাকম্ ইস্হাকঃ পূৰ্ৱ্ৱপুৰুষাদ্ গৰ্ভে ধৃতে তস্যাঃ সন্তানযোঃ প্ৰসৱাৎ পূৰ্ৱ্ৱং কিঞ্চ তযোঃ শুভাশুভকৰ্ম্মণঃ কৰণাৎ পূৰ্ৱ্ৱং ");
INSERT INTO sanasm_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","তাং প্ৰতীদং ৱাক্যম্ উক্তং, জ্যেষ্ঠঃ কনিষ্ঠং সেৱিষ্যতে, ");
INSERT INTO sanasm_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","যথা লিখিতম্ আস্তে, তথাপ্যেষাৱি ন প্ৰীৎৱা যাকূবি প্ৰীতৱান্ অহং| ");
INSERT INTO sanasm_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","তৰ্হি ৱযং কিং ব্ৰূমঃ? ঈশ্ৱৰঃ কিম্ অন্যাযকাৰী? তথা ন ভৱতু| ");
INSERT INTO sanasm_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","যতঃ স স্ৱযং মূসাম্ অৱদৎ; অহং যস্মিন্ অনুগ্ৰহং চিকীৰ্ষামি তমেৱানুগৃহ্লামি, যঞ্চ দযিতুম্ ইচ্ছামি তমেৱ দযে| ");
INSERT INTO sanasm_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","অতএৱেচ্ছতা যতমানেন ৱা মানৱেন তন্ন সাধ্যতে দযাকাৰিণেশ্ৱৰেণৈৱ সাধ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","ফিৰৌণি শাস্ত্ৰে লিখতি, অহং ৎৱদ্দ্ৱাৰা মৎপৰাক্ৰমং দৰ্শযিতুং সৰ্ৱ্ৱপৃথিৱ্যাং নিজনাম প্ৰকাশযিতুঞ্চ ৎৱাং স্থাপিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","অতঃ স যম্ অনুগ্ৰহীতুম্ ইচ্ছতি তমেৱানুগৃহ্লাতি, যঞ্চ নিগ্ৰহীতুম্ ইচ্ছতি তং নিগৃহ্লাতি| ");
INSERT INTO sanasm_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","যদি ৱদসি তৰ্হি স দোষং কুতো গৃহ্লাতি? তদীযেচ্ছাযাঃ প্ৰতিবন্ধকৎৱং কৰ্ত্তং কস্য সামৰ্থ্যং ৱিদ্যতে? ");
INSERT INTO sanasm_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","হে ঈশ্ৱৰস্য প্ৰতিপক্ষ মৰ্ত্য ৎৱং কঃ? এতাদৃশং মাং কুতঃ সৃষ্টৱান্? ইতি কথাং সৃষ্টৱস্তু স্ৰষ্ট্ৰে কিং কথযিষ্যতি? ");
INSERT INTO sanasm_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","একস্মান্ মৃৎপিণ্ডাদ্ উৎকৃষ্টাপকৃষ্টৌ দ্ৱিৱিধৌ কলশৌ কৰ্ত্তুং কিং কুলালস্য সামৰ্থ্যং নাস্তি? ");
INSERT INTO sanasm_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","ঈশ্ৱৰঃ কোপং প্ৰকাশযিতুং নিজশক্তিং জ্ঞাপযিতুঞ্চেচ্ছন্ যদি ৱিনাশস্য যোগ্যানি ক্ৰোধভাজনানি প্ৰতি বহুকালং দীৰ্ঘসহিষ্ণুতাম্ আশ্ৰযতি; ");
INSERT INTO sanasm_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","অপৰঞ্চ ৱিভৱপ্ৰাপ্ত্যৰ্থং পূৰ্ৱ্ৱং নিযুক্তান্যনুগ্ৰহপাত্ৰাণি প্ৰতি নিজৱিভৱস্য বাহুল্যং প্ৰকাশযিতুং কেৱলযিহূদিনাং নহি ভিন্নদেশিনামপি মধ্যাদ্ ");
INSERT INTO sanasm_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","অস্মানিৱ তান্যাহ্ৱযতি তত্ৰ তৱ কিং? ");
INSERT INTO sanasm_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","হোশেযগ্ৰন্থে যথা লিখিতম্ আস্তে, যো লোকো মম নাসীৎ তং ৱদিষ্যামি মদীযকং| যা জাতি ৰ্মেঽপ্ৰিযা চাসীৎ তাং ৱদিষ্যাম্যহং প্ৰিযাং| ");
INSERT INTO sanasm_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","যূযং মদীযলোকা ন যত্ৰেতি ৱাক্যমৌচ্যত| অমৰেশস্য সন্তানা ইতি খ্যাস্যন্তি তত্ৰ তে| ");
INSERT INTO sanasm_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","ইস্ৰাযেলীযলোকেষু যিশাযিযোঽপি ৱাচমেতাং প্ৰাচাৰযৎ, ইস্ৰাযেলীযৱংশানাং যা সংখ্যা সা তু নিশ্চিতং| সমুদ্ৰসিকতাসংখ্যাসমানা যদি জাযতে| তথাপি কেৱলং লোকৈৰল্পৈস্ত্ৰাণং ৱ্ৰজিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","যতো ন্যাযেন স্ৱং কৰ্ম্ম পৰেশঃ সাধযিষ্যতি| দেশে সএৱ সংক্ষেপান্নিজং কৰ্ম্ম কৰিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","যিশাযিযোঽপৰমপি কথযামাস, সৈন্যাধ্যক্ষপৰেশেন চেৎ কিঞ্চিন্নোদশিষ্যত| তদা ৱযং সিদোমেৱাভৱিষ্যাম ৱিনিশ্চিতং| যদ্ৱা ৱযম্ অমোৰাযা অগমিষ্যাম তুল্যতাং| ");
INSERT INTO sanasm_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","তৰ্হি ৱযং কিং ৱক্ষ্যামঃ? ইতৰদেশীযা লোকা অপি পুণ্যাৰ্থম্ অযতমানা ৱিশ্ৱাসেন পুণ্যম্ অলভন্ত; ");
INSERT INTO sanasm_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","কিন্ত্ৱিস্ৰাযেল্লোকা ৱ্যৱস্থাপালনেন পুণ্যাৰ্থং যতমানাস্তন্ নালভন্ত| ");
INSERT INTO sanasm_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","তস্য কিং কাৰণং? তে ৱিশ্ৱাসেন নহি কিন্তু ৱ্যৱস্থাযাঃ ক্ৰিযযা চেষ্টিৎৱা তস্মিন্ স্খলনজনকে পাষাণে পাদস্খলনং প্ৰাপ্তাঃ| ");
INSERT INTO sanasm_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","লিখিতং যাদৃশম্ আস্তে, পশ্য পাদস্খলাৰ্থং হি সীযোনি প্ৰস্তৰন্তথা| বাধাকাৰঞ্চ পাষাণং পৰিস্থাপিতৱানহম্| ৱিশ্ৱসিষ্যতি যস্তত্ৰ স জনো ন ত্ৰপিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","হে ভ্ৰাতৰ ইস্ৰাযেলীযলোকা যৎ পৰিত্ৰাণং প্ৰাপ্নুৱন্তি তদহং মনসাভিলষন্ ঈশ্ৱৰস্য সমীপে প্ৰাৰ্থযে| ");
INSERT INTO sanasm_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","যত ঈশ্ৱৰে তেষাং চেষ্টা ৱিদ্যত ইত্যত্ৰাহং সাক্ষ্যস্মি; কিন্তু তেষাং সা চেষ্টা সজ্ঞানা নহি, ");
INSERT INTO sanasm_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","যতস্ত ঈশ্ৱৰদত্তং পুণ্যম্ অৱিজ্ঞায স্ৱকৃতপুণ্যং স্থাপযিতুম্ চেষ্টমানা ঈশ্ৱৰদত্তস্য পুণ্যস্য নিঘ্নৎৱং ন স্ৱীকুৰ্ৱ্ৱন্তি| ");
INSERT INTO sanasm_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","খ্ৰীষ্ট একৈকৱিশ্ৱাসিজনায পুণ্যং দাতুং ৱ্যৱস্থাযাঃ ফলস্ৱৰূপো ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","ৱ্যৱস্থাপালনেন যৎ পুণ্যং তৎ মূসা ৱৰ্ণযামাস, যথা, যো জনস্তাং পালযিষ্যতি স তদ্দ্ৱাৰা জীৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","কিন্তু প্ৰত্যযেন যৎ পুণ্যং তদ্ এতাদৃশং ৱাক্যং ৱদতি, কঃ স্ৱৰ্গম্ আৰুহ্য খ্ৰীষ্টম্ অৱৰোহযিষ্যতি? ");
INSERT INTO sanasm_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","কো ৱা প্ৰেতলোকম্ অৱৰুহ্য খ্ৰীষ্টং মৃতগণমধ্যাদ্ আনেষ্যতীতি ৱাক্ মনসি ৎৱযা ন গদিতৱ্যা| ");
INSERT INTO sanasm_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","তৰ্হি কিং ব্ৰৱীতি? তদ্ ৱাক্যং তৱ সমীপস্থম্ অৰ্থাৎ তৱ ৱদনে মনসি চাস্তে, তচ্চ ৱাক্যম্ অস্মাভিঃ প্ৰচাৰ্য্যমাণং ৱিশ্ৱাসস্য ৱাক্যমেৱ| ");
INSERT INTO sanasm_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","ৱস্তুতঃ প্ৰভুং যীশুং যদি ৱদনেন স্ৱীকৰোষি, তথেশ্ৱৰস্তং শ্মশানাদ্ উদস্থাপযদ্ ইতি যদ্যন্তঃকৰণেন ৱিশ্ৱসিষি তৰ্হি পৰিত্ৰাণং লপ্স্যসে| ");
INSERT INTO sanasm_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","যস্মাৎ পুণ্যপ্ৰাপ্ত্যৰ্থম্ অন্তঃকৰণেন ৱিশ্ৱসিতৱ্যং পৰিত্ৰাণাৰ্থঞ্চ ৱদনেন স্ৱীকৰ্ত্তৱ্যং| ");
INSERT INTO sanasm_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","শাস্ত্ৰে যাদৃশং লিখতি ৱিশ্ৱসিষ্যতি যস্তত্ৰ স জনো ন ত্ৰপিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","ইত্যত্ৰ যিহূদিনি তদন্যলোকে চ কোপি ৱিশেষো নাস্তি যস্মাদ্ যঃ সৰ্ৱ্ৱেষাম্ অদ্ৱিতীযঃ প্ৰভুঃ স নিজযাচকান সৰ্ৱ্ৱান্ প্ৰতি ৱদান্যো ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","যতঃ, যঃ কশ্চিৎ পৰমেশস্য নাম্না হি প্ৰাৰ্থযিষ্যতে| স এৱ মনুজো নূনং পৰিত্ৰাতো ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","যং যে জনা ন প্ৰত্যাযন্ তে তমুদ্দিশ্য কথং প্ৰাৰ্থযিষ্যন্তে? যে ৱা যস্যাখ্যানং কদাপি ন শ্ৰুতৱন্তস্তে তং কথং প্ৰত্যেষ্যন্তি? অপৰং যদি প্ৰচাৰযিতাৰো ন তিষ্ঠন্তি তদা কথং তে শ্ৰোষ্যন্তি? ");
INSERT INTO sanasm_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","যদি ৱা প্ৰেৰিতা ন ভৱন্তি তদা কথং প্ৰচাৰযিষ্যন্তি? যাদৃশং লিখিতম্ আস্তে, যথা, মাঙ্গলিকং সুসংৱাদং দদত্যানীয যে নৰাঃ| প্ৰচাৰযন্তি শান্তেশ্চ সুসংৱাদং জনাস্তু যে| তেষাং চৰণপদ্মানি কীদৃক্ শোভান্ৱিতানি হি| ");
INSERT INTO sanasm_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","কিন্তু তে সৰ্ৱ্ৱে তং সুসংৱাদং ন গৃহীতৱন্তঃ| যিশাযিযো যথা লিখিতৱান্| অস্মৎপ্ৰচাৰিতে ৱাক্যে ৱিশ্ৱাসমকৰোদ্ধি কঃ| ");
INSERT INTO sanasm_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","অতএৱ শ্ৰৱণাদ্ ৱিশ্ৱাস ঐশ্ৱৰৱাক্যপ্ৰচাৰাৎ শ্ৰৱণঞ্চ ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","তৰ্হ্যহং ব্ৰৱীমি তৈঃ কিং নাশ্ৰাৱি? অৱশ্যম্ অশ্ৰাৱি, যস্মাৎ তেষাং শব্দো মহীং ৱ্যাপ্নোদ্ ৱাক্যঞ্চ নিখিলং জগৎ| ");
INSERT INTO sanasm_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","অপৰমপি ৱদামি, ইস্ৰাযেলীযলোকাঃ কিম্ এতাং কথাং ন বুধ্যন্তে? প্ৰথমতো মূসা ইদং ৱাক্যং প্ৰোৱাচ, অহমুত্তাপযিষ্যে তান্ অগণ্যমানৱৈৰপি| ক্লেক্ষ্যামি জাতিম্ এতাঞ্চ প্ৰোন্মত্তভিন্নজাতিভিঃ| ");
INSERT INTO sanasm_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","অপৰঞ্চ যিশাযিযোঽতিশযাক্ষোভেণ কথযামাস, যথা, অধি মাং যৈস্তু নাচেষ্টি সম্প্ৰাপ্তস্তৈ ৰ্জনৈৰহং| অধি মাং যৈ ৰ্ন সম্পৃষ্টং ৱিজ্ঞাতস্তৈ ৰ্জনৈৰহং|| ");
INSERT INTO sanasm_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","কিন্ত্ৱিস্ৰাযেলীযলোকান্ অধি কথযাঞ্চকাৰ, যৈৰাজ্ঞালঙ্ঘিভি ৰ্লোকৈ ৰ্ৱিৰুদ্ধং ৱাক্যমুচ্যতে| তান্ প্ৰত্যেৱ দিনং কৃৎস্নং হস্তৌ ৱিস্তাৰযাম্যহং|| ");
INSERT INTO sanasm_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","ঈশ্ৱৰেণ স্ৱীকীযলোকা অপসাৰিতা অহং কিম্ ঈদৃশং ৱাক্যং ব্ৰৱীমি? তন্ন ভৱতু যতোঽহমপি বিন্যামীনগোত্ৰীয ইব্ৰাহীমৱংশীয ইস্ৰাযেলীযলোকোঽস্মি| ");
INSERT INTO sanasm_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","ঈশ্ৱৰেণ পূৰ্ৱ্ৱং যে প্ৰদৃষ্টাস্তে স্ৱকীযলোকা অপসাৰিতা ইতি নহি| অপৰম্ এলিযোপাখ্যানে শাস্ত্ৰে যল্লিখিতম্ আস্তে তদ্ যূযং কিং ন জানীথ? ");
INSERT INTO sanasm_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","হে পৰমেশ্ৱৰ লোকাস্ত্ৱদীযাঃ সৰ্ৱ্ৱা যজ্ঞৱেদীৰভঞ্জন্ তথা তৱ ভৱিষ্যদ্ৱাদিনঃ সৰ্ৱ্ৱান্ অঘ্নন্ কেৱল একোঽহম্ অৱশিষ্ট আসে তে মমাপি প্ৰাণান্ নাশযিতুং চেষ্টনতে, এতাং কথাম্ ইস্ৰাযেলীযলোকানাং ৱিৰুদ্ধম্ এলিয ঈশ্ৱৰায নিৱেদযামাস| ");
INSERT INTO sanasm_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","ততস্তং প্ৰতীশ্ৱৰস্যোত্তৰং কিং জাতং? বাল্নাম্নো দেৱস্য সাক্ষাৎ যৈ ৰ্জানূনি ন পাতিতানি তাদৃশাঃ সপ্ত সহস্ৰাণি লোকা অৱশেষিতা মযা| ");
INSERT INTO sanasm_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","তদ্ৱদ্ এতস্মিন্ ৱৰ্ত্তমানকালেঽপি অনুগ্ৰহেণাভিৰুচিতাস্তেষাম্ অৱশিষ্টাঃ কতিপযা লোকাঃ সন্তি| ");
INSERT INTO sanasm_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","অতএৱ তদ্ যদ্যনুগ্ৰহেণ ভৱতি তৰ্হি ক্ৰিযযা ন ভৱতি নো চেদ্ অনুগ্ৰহোঽননুগ্ৰহ এৱ, যদি ৱা ক্ৰিযযা ভৱতি তৰ্হ্যনুগ্ৰহেণ ন ভৱতি নো চেৎ ক্ৰিযা ক্ৰিযৈৱ ন ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","তৰ্হি কিং? ইস্ৰাযেলীযলোকা যদ্ অমৃগযন্ত তন্ন প্ৰাপুঃ| কিন্ত্ৱভিৰুচিতলোকাস্তৎ প্ৰাপুস্তদন্যে সৰ্ৱ্ৱ অন্ধীভূতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","যথা লিখিতম্ আস্তে, ঘোৰনিদ্ৰালুতাভাৱং দৃষ্টিহীনে চ লোচনে| কৰ্ণৌ শ্ৰুতিৱিহীনৌ চ প্ৰদদৌ তেভ্য ঈশ্ৱৰঃ|| ");
INSERT INTO sanasm_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","এতেস্মিন্ দাযূদপি লিখিতৱান্ যথা, অতো ভুক্ত্যাসনং তেষাম্ উন্মাথৱদ্ ভৱিষ্যতি| ৱা ৱংশযন্ত্ৰৱদ্ বাধা দণ্ডৱদ্ ৱা ভৱিষ্যতি|| ");
INSERT INTO sanasm_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","ভৱিষ্যন্তি তথান্ধাস্তে নেত্ৰৈঃ পশ্যন্তি নো যথা| ৱেপথুঃ কটিদেশস্য তেষাং নিত্যং ভৱিষ্যতি|| ");
INSERT INTO sanasm_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","পতনাৰ্থং তে স্খলিতৱন্ত ইতি ৱাচং কিমহং ৱদামি? তন্ন ভৱতু কিন্তু তান্ উদ্যোগিনঃ কৰ্ত্তুং তেষাং পতনাদ্ ইতৰদেশীযলোকৈঃ পৰিত্ৰাণং প্ৰাপ্তং| ");
INSERT INTO sanasm_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","তেষাং পতনং যদি জগতো লোকানাং লাভজনকম্ অভৱৎ তেষাং হ্ৰাসোঽপি যদি ভিন্নদেশিনাং লাভজনকোঽভৱৎ তৰ্হি তেষাং ৱৃদ্ধিঃ কতি লাভজনিকা ভৱিষ্যতি? ");
INSERT INTO sanasm_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","অতো হে অন্যদেশিনো যুষ্মান্ সম্বোধ্য কথযামি নিজানাং জ্ঞাতিবন্ধূনাং মনঃসূদ্যোগং জনযন্ তেষাং মধ্যে কিযতাং লোকানাং যথা পৰিত্ৰাণং সাধযামি ");
INSERT INTO sanasm_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","তন্নিমিত্তম্ অন্যদেশিনাং নিকটে প্ৰেৰিতঃ সন্ অহং স্ৱপদস্য মহিমানং প্ৰকাশযামি| ");
INSERT INTO sanasm_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","তেষাং নিগ্ৰহেণ যদীশ্ৱৰেণ সহ জগতো জনানাং মেলনং জাতং তৰ্হি তেষাম্ অনুগৃহীতৎৱং মৃতদেহে যথা জীৱনলাভস্তদ্ৱৎ কিং ন ভৱিষ্যতি? ");
INSERT INTO sanasm_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","অপৰং প্ৰথমজাতং ফলং যদি পৱিত্ৰং ভৱতি তৰ্হি সৰ্ৱ্ৱমেৱ ফলং পৱিত্ৰং ভৱিষ্যতি; তথা মূলং যদি পৱিত্ৰং ভৱতি তৰ্হি শাখা অপি তথৈৱ ভৱিষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","কিযতীনাং শাখানাং ছেদনে কৃতে ৎৱং ৱন্যজিতৱৃক্ষস্য শাখা ভূৎৱা যদি তচ্ছাখানাং স্থানে ৰোপিতা সতি জিতৱৃক্ষীযমূলস্য ৰসং ভুংক্ষে, ");
INSERT INTO sanasm_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","তৰ্হি তাসাং ভিন্নশাখানাং ৱিৰুদ্ধং মাং গৰ্ৱ্ৱীঃ; যদি গৰ্ৱ্ৱসি তৰ্হি ৎৱং মূলং যন্ন ধাৰযসি কিন্তু মূলং ৎৱাং ধাৰযতীতি সংস্মৰ| ");
INSERT INTO sanasm_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","অপৰঞ্চ যদি ৱদসি মাং ৰোপযিতুং তাঃ শাখা ৱিভন্না অভৱন্; ");
INSERT INTO sanasm_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","ভদ্ৰম্, অপ্ৰত্যযকাৰণাৎ তে ৱিভিন্না জাতাস্তথা ৱিশ্ৱাসকাৰণাৎ ৎৱং ৰোপিতো জাতস্তস্মাদ্ অহঙ্কাৰম্ অকৃৎৱা সসাধ্ৱসো ভৱ| ");
INSERT INTO sanasm_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","যত ঈশ্ৱৰো যদি স্ৱাভাৱিকীঃ শাখা ন ৰক্ষতি তৰ্হি সাৱধানো ভৱ চেৎ ৎৱামপি ন স্থাপযতি| ");
INSERT INTO sanasm_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","ইত্যত্ৰেশ্ৱৰস্য যাদৃশী কৃপা তাদৃশং ভযানকৎৱমপি ৎৱযা দৃশ্যতাং; যে পতিতাস্তান্ প্ৰতি তস্য ভযানকৎৱং দৃশ্যতাং, ৎৱঞ্চ যদি তৎকৃপাশ্ৰিতস্তিষ্ঠসি তৰ্হি ৎৱাং প্ৰতি কৃপা দ্ৰক্ষ্যতে; নো চেৎ ৎৱমপি তদ্ৱৎ ছিন্নো ভৱিষ্যসি| ");
INSERT INTO sanasm_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","অপৰঞ্চ তে যদ্যপ্ৰত্যযে ন তিষ্ঠন্তি তৰ্হি পুনৰপি ৰোপযিষ্যন্তে যস্মাৎ তান্ পুনৰপি ৰোপযিতুম্ ইশ্ৱৰস্য শক্তিৰাস্তে| ");
INSERT INTO sanasm_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","ৱন্যজিতৱৃক্ষস্য শাখা সন্ ৎৱং যদি ততশ্ছিন্নো ৰীতিৱ্যত্যযেনোত্তমজিতৱৃক্ষে ৰোेेপিতোঽভৱস্তৰ্হি তস্য ৱৃক্ষস্য স্ৱীযা যাঃ শাখাস্তাঃ কিং পুনঃ স্ৱৱৃক্ষে সংলগিতুং ন শক্নুৱন্তি? ");
INSERT INTO sanasm_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","হে ভ্ৰাতৰো যুষ্মাকম্ আত্মাভিমানো যন্ন জাযতে তদৰ্থং মমেদৃশী ৱাঞ্ছা ভৱতি যূযং এতন্নিগূঢতত্ত্ৱম্ অজানন্তো যন্ন তিষ্ঠথ; ৱস্তুতো যাৱৎকালং সম্পূৰ্ণৰূপেণ ভিন্নদেশিনাং সংগ্ৰহো ন ভৱিষ্যতি তাৱৎকালম্ অংশৎৱেন ইস্ৰাযেলীযলোকানাম্ অন্ধতা স্থাস্যতি; ");
INSERT INTO sanasm_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","পশ্চাৎ তে সৰ্ৱ্ৱে পৰিত্ৰাস্যন্তে; এতাদৃশং লিখিতমপ্যাস্তে, আগমিষ্যতি সীযোনাদ্ একো যস্ত্ৰাণদাযকঃ| অধৰ্ম্মং যাকুবো ৱংশাৎ স তু দূৰীকৰিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","তথা দূৰীকৰিষ্যামি তেষাং পাপান্যহং যদা| তদা তৈৰেৱ সাৰ্দ্ধং মে নিযমোঽযং ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","সুসংৱাদাৎ তে যুষ্মাকং ৱিপক্ষা অভৱন্ কিন্ত্ৱভিৰুচিতৎৱাৎ তে পিতৃলোকানাং কৃতে প্ৰিযপাত্ৰাণি ভৱন্তি| ");
INSERT INTO sanasm_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","যত ঈশ্ৱৰস্য দানাদ্ আহ্ৱানাঞ্চ পশ্চাত্তাপো ন ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","অতএৱ পূৰ্ৱ্ৱম্ ঈশ্ৱৰেঽৱিশ্ৱাসিনঃ সন্তোঽপি যূযং যদ্ৱৎ সম্প্ৰতি তেষাম্ অৱিশ্ৱাসকাৰণাদ্ ঈশ্ৱৰস্য কৃপাপাত্ৰাণি জাতাস্তদ্ৱদ্ ");
INSERT INTO sanasm_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","ইদানীং তেঽৱিশ্ৱাসিনঃ সন্তি কিন্তু যুষ্মাভি ৰ্লব্ধকৃপাকাৰণাৎ তৈৰপি কৃপা লপ্স্যতে| ");
INSERT INTO sanasm_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","ঈশ্ৱৰঃ সৰ্ৱ্ৱান্ প্ৰতি কৃপাং প্ৰকাশযিতুং সৰ্ৱ্ৱান্ অৱিশ্ৱাসিৎৱেন গণযতি| ");
INSERT INTO sanasm_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","অহো ঈশ্ৱৰস্য জ্ঞানবুদ্ধিৰূপযো ৰ্ধনযোঃ কীদৃক্ প্ৰাচুৰ্য্যং| তস্য ৰাজশাসনস্য তত্ত্ৱং কীদৃগ্ অপ্ৰাপ্যং| তস্য মাৰ্গাশ্চ কীদৃগ্ অনুপলক্ষ্যাঃ| ");
INSERT INTO sanasm_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","পৰমেশ্ৱৰস্য সঙ্কল্পং কো জ্ঞাতৱান্? তস্য মন্ত্ৰী ৱা কোঽভৱৎ? ");
INSERT INTO sanasm_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","কো ৱা তস্যোপকাৰী ভৃৎৱা তৎকৃতে তেন প্ৰত্যুপকৰ্ত্তৱ্যঃ? ");
INSERT INTO sanasm_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","যতো ৱস্তুমাত্ৰমেৱ তস্মাৎ তেন তস্মৈ চাভৱৎ তদীযো মহিমা সৰ্ৱ্ৱদা প্ৰকাশিতো ভৱতু| ইতি| ");
INSERT INTO sanasm_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","হে ভ্ৰাতৰ ঈশ্ৱৰস্য কৃপযাহং যুষ্মান্ ৱিনযে যূযং স্ৱং স্ৱং শৰীৰং সজীৱং পৱিত্ৰং গ্ৰাহ্যং বলিম্ ঈশ্ৱৰমুদ্দিশ্য সমুৎসৃজত, এষা সেৱা যুষ্মাকং যোগ্যা| ");
INSERT INTO sanasm_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","অপৰং যূযং সাংসাৰিকা ইৱ মাচৰত, কিন্তু স্ৱং স্ৱং স্ৱভাৱং পৰাৱৰ্ত্য নূতনাচাৰিণো ভৱত, তত ঈশ্ৱৰস্য নিদেশঃ কীদৃগ্ উত্তমো গ্ৰহণীযঃ সম্পূৰ্ণশ্চেতি যুষ্মাভিৰনুভাৱিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","কশ্চিদপি জনো যোগ্যৎৱাদধিকং স্ৱং ন মন্যতাং কিন্তু ঈশ্ৱৰো যস্মৈ প্ৰত্যযস্য যৎপৰিমাণম্ অদদাৎ স তদনুসাৰতো যোগ্যৰূপং স্ৱং মনুতাম্, ঈশ্ৱৰাদ্ অনুগ্ৰহং প্ৰাপ্তঃ সন্ যুষ্মাকম্ একৈকং জনম্ ইত্যাজ্ঞাপযামি| ");
INSERT INTO sanasm_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","যতো যদ্ৱদস্মাকম্ একস্মিন্ শৰীৰে বহূন্যঙ্গানি সন্তি কিন্তু সৰ্ৱ্ৱেষামঙ্গানাং কাৰ্য্যং সমানং নহি; ");
INSERT INTO sanasm_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","তদ্ৱদস্মাকং বহুৎৱেঽপি সৰ্ৱ্ৱে ৱযং খ্ৰীষ্টে একশৰীৰাঃ পৰস্পৰম্ অঙ্গপ্ৰত্যঙ্গৎৱেন ভৱামঃ| ");
INSERT INTO sanasm_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","অস্মাদ্ ঈশ্ৱৰানুগ্ৰহেণ ৱিশেষং ৱিশেষং দানম্ অস্মাসু প্ৰাপ্তেষু সৎসু কোপি যদি ভৱিষ্যদ্ৱাক্যং ৱদতি তৰ্হি প্ৰত্যযস্য পৰিমাণানুসাৰতঃ স তদ্ ৱদতু; ");
INSERT INTO sanasm_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","যদ্ৱা যদি কশ্চিৎ সেৱনকাৰী ভৱতি তৰ্হি স তৎসেৱনং কৰোতু; অথৱা যদি কশ্চিদ্ অধ্যাপযিতা ভৱতি তৰ্হি সোঽধ্যাপযতু; ");
INSERT INTO sanasm_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","তথা য উপদেষ্টা ভৱতি স উপদিশতু যশ্চ দাতা স সৰলতযা দদাতু যস্ত্ৱধিপতিঃ স যত্নেনাধিপতিৎৱং কৰোতু যশ্চ দযালুঃ স হৃষ্টমনসা দযতাম্| ");
INSERT INTO sanasm_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","অপৰঞ্চ যুষ্মাকং প্ৰেম কাপট্যৱৰ্জিতং ভৱতু যদ্ অভদ্ৰং তদ্ ঋতীযধ্ৱং যচ্চ ভদ্ৰং তস্মিন্ অনুৰজ্যধ্ৱম্| ");
INSERT INTO sanasm_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","অপৰং ভ্ৰাতৃৎৱপ্ৰেম্না পৰস্পৰং প্ৰীযধ্ৱং সমাদৰাদ্ একোঽপৰজনং শ্ৰেষ্ঠং জানীধ্ৱম্| ");
INSERT INTO sanasm_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","তথা কাৰ্য্যে নিৰালস্যা মনসি চ সোদ্যোগাঃ সন্তঃ প্ৰভুং সেৱধ্ৱম্| ");
INSERT INTO sanasm_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","অপৰং প্ৰত্যাশাযাম্ আনন্দিতা দুঃখসমযে চ ধৈৰ্য্যযুক্তা ভৱত; প্ৰাৰ্থনাযাং সততং প্ৰৱৰ্ত্তধ্ৱং| ");
INSERT INTO sanasm_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","পৱিত্ৰাণাং দীনতাং দূৰীকুৰুধ্ৱম্ অতিথিসেৱাযাম্ অনুৰজ্যধ্ৱম্| ");
INSERT INTO sanasm_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","যে জনা যুষ্মান্ তাডযন্তি তান্ আশিষং ৱদত শাপম্ অদত্ত্ৱা দদ্ধ্ৱমাশিষম্| ");
INSERT INTO sanasm_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","যে জনা আনন্দন্তি তৈঃ সাৰ্দ্ধম্ আনন্দত যে চ ৰুদন্তি তৈঃ সহ ৰুদিত| ");
INSERT INTO sanasm_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","অপৰঞ্চ যুষ্মাকং মনসাং পৰস্পৰম্ একোভাৱো ভৱতু; অপৰম্ উচ্চপদম্ অনাকাঙ্ক্ষ্য নীচলোকৈঃ সহাপি মাৰ্দৱম্ আচৰত; স্ৱান্ জ্ঞানিনো ন মন্যধ্ৱং| ");
INSERT INTO sanasm_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","পৰস্মাদ্ অপকাৰং প্ৰাপ্যাপি পৰং নাপকুৰুত| সৰ্ৱ্ৱেষাং দৃষ্টিতো যৎ কৰ্ম্মোত্তমং তদেৱ কুৰুত| ");
INSERT INTO sanasm_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","যদি ভৱিতুং শক্যতে তৰ্হি যথাশক্তি সৰ্ৱ্ৱলোকৈঃ সহ নিৰ্ৱ্ৱিৰোধেন কালং যাপযত| ");
INSERT INTO sanasm_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","হে প্ৰিযবন্ধৱঃ, কস্মৈচিদ্ অপকাৰস্য সমুচিতং দণ্ডং স্ৱযং ন দদ্ধ্ৱং, কিন্ত্ৱীশ্ৱৰীযক্ৰোধায স্থানং দত্ত যতো লিখিতমাস্তে পৰমেশ্ৱৰঃ কথযতি, দানং ফলস্য মৎকৰ্ম্ম সূচিতং প্ৰদদাম্যহং| ");
INSERT INTO sanasm_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","ইতিকাৰণাদ্ ৰিপু ৰ্যদি ক্ষুধাৰ্ত্তস্তে তৰ্হি তং ৎৱং প্ৰভোজয| তথা যদি তৃষাৰ্ত্তঃ স্যাৎ তৰ্হি তং পৰিপাযয| তেন ৎৱং মস্তকে তস্য জ্ৱলদগ্নিং নিধাস্যসি| ");
INSERT INTO sanasm_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","কুক্ৰিযযা পৰাজিতা ন সন্ত উত্তমক্ৰিযযা কুক্ৰিযাং পৰাজযত| ");
INSERT INTO sanasm_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","যুষ্মাকম্ একৈকজনঃ শাসনপদস্য নিঘ্নো ভৱতু যতো যানি শাসনপদানি সন্তি তানি সৰ্ৱ্ৱাণীশ্ৱৰেণ স্থাপিতানি; ঈশ্ৱৰং ৱিনা পদস্থাপনং ন ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","ইতি হেতোঃ শাসনপদস্য যৎ প্ৰাতিকূল্যং তদ্ ঈশ্ৱৰীযনিৰূপণস্য প্ৰাতিকূল্যমেৱ; অপৰং যে প্ৰাতিকূল্যম্ আচৰন্তি তে স্ৱেষাং সমুচিতং দণ্ডং স্ৱযমেৱ ঘটযন্তে| ");
INSERT INTO sanasm_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","শাস্তা সদাচাৰিণাং ভযপ্ৰদো নহি দুৰাচাৰিণামেৱ ভযপ্ৰদো ভৱতি; ৎৱং কিং তস্মান্ নিৰ্ভযো ভৱিতুম্ ইচ্ছসি? তৰ্হি সৎকৰ্ম্মাচৰ, তস্মাদ্ যশো লপ্স্যসে, ");
INSERT INTO sanasm_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","যতস্তৱ সদাচৰণায স ঈশ্ৱৰস্য ভৃত্যোঽস্তি| কিন্তু যদি কুকৰ্ম্মাচৰসি তৰ্হি ৎৱং শঙ্কস্ৱ যতঃ স নিৰৰ্থকং খঙ্গং ন ধাৰযতি; কুকৰ্ম্মাচাৰিণং সমুচিতং দণ্ডযিতুম্ স ঈশ্ৱৰস্য দণ্ডদভৃত্য এৱ| ");
INSERT INTO sanasm_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","অতএৱ কেৱলদণ্ডভযান্নহি কিন্তু সদসদ্বোধাদপি তস্য ৱশ্যেন ভৱিতৱ্যং| ");
INSERT INTO sanasm_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","এতস্মাদ্ যুষ্মাকং ৰাজকৰদানমপ্যুচিতং যস্মাদ্ যে কৰং গৃহ্লন্তি ত ঈশ্ৱৰস্য কিঙ্কৰা ভূৎৱা সততম্ এতস্মিন্ কৰ্ম্মণি নিৱিষ্টাস্তিষ্ঠন্তি| ");
INSERT INTO sanasm_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","অস্মাৎ কৰগ্ৰাহিণে কৰং দত্ত, তথা শুল্কগ্ৰাহিণে শুল্কং দত্ত, অপৰং যস্মাদ্ ভেতৱ্যং তস্মাদ্ বিভীত, যশ্চ সমাদৰণীযস্তং সমাদ্ৰিযধ্ৱম্; ইত্থং যস্য যৎ প্ৰাপ্যং তৎ তস্মৈ দত্ত| ");
INSERT INTO sanasm_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","যুষ্মাকং পৰস্পৰং প্ৰেম ৱিনা ঽন্যৎ কিমপি দেযম্ ঋণং ন ভৱতু, যতো যঃ পৰস্মিন্ প্ৰেম কৰোতি তেন ৱ্যৱস্থা সিধ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","ৱস্তুতঃ পৰদাৰান্ মা গচ্ছ, নৰহত্যাং মা কাৰ্ষীঃ, চৈৰ্য্যং মা কাৰ্ষীঃ, মিথ্যাসাক্ষ্যং মা দেহি, লোভং মা কাৰ্ষীঃ, এতাঃ সৰ্ৱ্ৱা আজ্ঞা এতাভ্যো ভিন্না যা কাচিদ্ আজ্ঞাস্তি সাপি স্ৱসমীপৱাসিনি স্ৱৱৎ প্ৰেম কুৰ্ৱ্ৱিত্যনেন ৱচনেন ৱেদিতা| ");
INSERT INTO sanasm_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","যতঃ প্ৰেম সমীপৱাসিনোঽশুভং ন জনযতি তস্মাৎ প্ৰেম্না সৰ্ৱ্ৱা ৱ্যৱস্থা পাল্যতে| ");
INSERT INTO sanasm_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","প্ৰত্যযীভৱনকালেঽস্মাকং পৰিত্ৰাণস্য সামীপ্যাদ্ ইদানীং তস্য সামীপ্যম্ অৱ্যৱহিতং; অতঃ সমযং ৱিৱিচ্যাস্মাভিঃ সাম্প্ৰতম্ অৱশ্যমেৱ নিদ্ৰাতো জাগৰ্ত্তৱ্যং| ");
INSERT INTO sanasm_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","বহুতৰা যামিনী গতা প্ৰভাতং সন্নিধিং প্ৰাপ্তং তস্মাৎ তামসীযাঃ ক্ৰিযাঃ পৰিত্যজ্যাস্মাভি ৰ্ৱাসৰীযা সজ্জা পৰিধাতৱ্যা| ");
INSERT INTO sanasm_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","অতো হেতো ৰ্ৱযং দিৱা ৱিহিতং সদাচৰণম্ আচৰিষ্যামঃ| ৰঙ্গৰসো মত্তৎৱং লম্পটৎৱং কামুকৎৱং ৱিৱাদ ঈৰ্ষ্যা চৈতানি পৰিত্যক্ষ্যামঃ| ");
INSERT INTO sanasm_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","যূযং প্ৰভুযীশুখ্ৰীষ্টৰূপং পৰিচ্ছদং পৰিধদ্ধ্ৱং সুখাভিলাষপূৰণায শাৰীৰিকাচৰণং মাচৰত| ");
INSERT INTO sanasm_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","যো জনোঽদৃঢৱিশ্ৱাসস্তং যুষ্মাকং সঙ্গিনং কুৰুত কিন্তু সন্দেহৱিচাৰাৰ্থং নহি| ");
INSERT INTO sanasm_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","যতো নিষিদ্ধং কিমপি খাদ্যদ্ৰৱ্যং নাস্তি, কস্যচিজ্জনস্য প্ৰত্যয এতাদৃশো ৱিদ্যতে কিন্ত্ৱদৃঢৱিশ্ৱাসঃ কশ্চিদপৰো জনঃ কেৱলং শাকং ভুঙ্ক্তং| ");
INSERT INTO sanasm_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","তৰ্হি যো জনঃ সাধাৰণং দ্ৰৱ্যং ভুঙ্ক্তে স ৱিশেষদ্ৰৱ্যভোক্তাৰং নাৱজানীযাৎ তথা ৱিশেষদ্ৰৱ্যভোক্তাপি সাধাৰণদ্ৰৱ্যভোক্তাৰং দোষিণং ন কুৰ্য্যাৎ, যস্মাদ্ ঈশ্ৱৰস্তম্ অগৃহ্লাৎ| ");
INSERT INTO sanasm_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","হে পৰদাসস্য দূষযিতস্ত্ৱং কঃ? নিজপ্ৰভোঃ সমীপে তেন পদস্থেন পদচ্যুতেন ৱা ভৱিতৱ্যং স চ পদস্থ এৱ ভৱিষ্যতি যত ঈশ্ৱৰস্তং পদস্থং কৰ্ত্তুং শক্নোতি| ");
INSERT INTO sanasm_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","অপৰঞ্চ কশ্চিজ্জনো দিনাদ্ দিনং ৱিশেষং মন্যতে কশ্চিত্তুु সৰ্ৱ্ৱাণি দিনানি সমানানি মন্যতে, একৈকো জনঃ স্ৱীযমনসি ৱিৱিচ্য নিশ্চিনোতু| ");
INSERT INTO sanasm_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","যো জনঃ কিঞ্চন দিনং ৱিশেষং মন্যতে স প্ৰভুভক্ত্যা তন্ মন্যতে, যশ্চ জনঃ কিমপি দিনং ৱিশেষং ন মন্যতে সোঽপি প্ৰভুভক্ত্যা তন্ন মন্যতে; অপৰঞ্চ যঃ সৰ্ৱ্ৱাণি ভক্ষ্যদ্ৰৱ্যাণি ভুঙ্ক্তে স প্ৰভুভক্তযা তানি ভুঙ্ক্তে যতঃ স ঈশ্ৱৰং ধন্যং ৱক্তি, যশ্চ ন ভুঙ্ক্তে সোঽপি প্ৰভুভক্ত্যৈৱ ন ভুঞ্জান ঈশ্ৱৰং ধন্যং ব্ৰূতে| ");
INSERT INTO sanasm_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","অপৰম্ অস্মাকং কশ্চিৎ নিজনিমিত্তং প্ৰাণান্ ধাৰযতি নিজনিমিত্তং ম্ৰিযতে ৱা তন্ন; ");
INSERT INTO sanasm_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","কিন্তু যদি ৱযং প্ৰাণান্ ধাৰযামস্তৰ্হি প্ৰভুনিমিত্তং ধাৰযামঃ, যদি চ প্ৰাণান্ ত্যজামস্তৰ্হ্যপি প্ৰভুনিমিত্তং ত্যজামঃ, অতএৱ জীৱনে মৰণে ৱা ৱযং প্ৰভোৰেৱাস্মহে| ");
INSERT INTO sanasm_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","যতো জীৱন্তো মৃতাশ্চেত্যুভযেষাং লোকানাং প্ৰভুৎৱপ্ৰাপ্ত্যৰ্থং খ্ৰীষ্টো মৃত উত্থিতঃ পুনৰ্জীৱিতশ্চ| ");
INSERT INTO sanasm_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","কিন্তু ৎৱং নিজং ভ্ৰাতৰং কুতো দূষযসি? তথা ৎৱং নিজং ভ্ৰাতৰং কুতস্তুচ্ছং জানাসি? খ্ৰীষ্টস্য ৱিচাৰসিংহাসনস্য সম্মুখে সৰ্ৱ্ৱৈৰস্মাভিৰুপস্থাতৱ্যং; ");
INSERT INTO sanasm_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","যাদৃশং লিখিতম্ আস্তে, পৰেশঃ শপথং কুৰ্ৱ্ৱন্ ৱাক্যমেতৎ পুৰাৱদৎ| সৰ্ৱ্ৱো জনঃ সমীপে মে জানুপাতং কৰিষ্যতি| জিহ্ৱৈকৈকা তথেশস্য নিঘ্নৎৱং স্ৱীকৰিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","অতএৱ ঈশ্ৱৰসমীপেঽস্মাকম্ একৈকজনেন নিজা কথা কথযিতৱ্যা| ");
INSERT INTO sanasm_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","ইত্থং সতি ৱযম্ অদ্যাৰভ্য পৰস্পৰং ন দূষযন্তঃ স্ৱভ্ৰাতু ৰ্ৱিঘ্নো ৱ্যাঘাতো ৱা যন্ন জাযেত তাদৃশীমীহাং কুৰ্ম্মহে| ");
INSERT INTO sanasm_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","কিমপি ৱস্তু স্ৱভাৱতো নাশুচি ভৱতীত্যহং জানে তথা প্ৰভুনা যীশুখ্ৰীষ্টেনাপি নিশ্চিতং জানে, কিন্তু যো জনো যদ্ দ্ৰৱ্যম্ অপৱিত্ৰং জানীতে তস্য কৃতে তদ্ অপৱিত্ৰম্ আস্তে| ");
INSERT INTO sanasm_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","অতএৱ তৱ ভক্ষ্যদ্ৰৱ্যেণ তৱ ভ্ৰাতা শোকান্ৱিতো ভৱতি তৰ্হি ৎৱং ভ্ৰাতৰং প্ৰতি প্ৰেম্না নাচৰসি| খ্ৰীষ্টো যস্য কৃতে স্ৱপ্ৰাণান্ ৱ্যযিতৱান্ ৎৱং নিজেন ভক্ষ্যদ্ৰৱ্যেণ তং ন নাশয| ");
INSERT INTO sanasm_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","অপৰং যুষ্মাকম্ উত্তমং কৰ্ম্ম নিন্দিতং ন ভৱতু| ");
INSERT INTO sanasm_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","ভক্ষ্যং পেযঞ্চেশ্ৱৰৰাজ্যস্য সাৰো নহি, কিন্তু পুণ্যং শান্তিশ্চ পৱিত্ৰেণাত্মনা জাত আনন্দশ্চ| ");
INSERT INTO sanasm_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","এতৈ ৰ্যো জনঃ খ্ৰীষ্টং সেৱতে, স এৱেশ্ৱৰস্য তুষ্টিকৰো মনুষ্যৈশ্চ সুখ্যাতঃ| ");
INSERT INTO sanasm_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","অতএৱ যেনাস্মাকং সৰ্ৱ্ৱেষাং পৰস্পৰম্ ঐক্যং নিষ্ঠা চ জাযতে তদেৱাস্মাভি ৰ্যতিতৱ্যং| ");
INSERT INTO sanasm_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","ভক্ষ্যাৰ্থম্ ঈশ্ৱৰস্য কৰ্ম্মণো হানিং মা জনযত; সৰ্ৱ্ৱং ৱস্তু পৱিত্ৰমিতি সত্যং তথাপি যো জনো যদ্ ভুক্ত্ৱা ৱিঘ্নং লভতে তদৰ্থং তদ্ ভদ্ৰং নহি| ");
INSERT INTO sanasm_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","তৱ মাংসভক্ষণসুৰাপানাদিভিঃ ক্ৰিযাভি ৰ্যদি তৱ ভ্ৰাতুঃ পাদস্খলনং ৱিঘ্নো ৱা চাঞ্চল্যং ৱা জাযতে তৰ্হি তদ্ভোজনপানযোস্ত্যাগো ভদ্ৰঃ| ");
INSERT INTO sanasm_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","যদি তৱ প্ৰত্যযস্তিষ্ঠতি তৰ্হীশ্ৱৰস্য গোচৰে স্ৱান্তৰে তং গোপয; যো জনঃ স্ৱমতেন স্ৱং দোষিণং ন কৰোতি স এৱ ধন্যঃ| ");
INSERT INTO sanasm_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","কিন্তু যঃ কশ্চিৎ সংশয্য ভুঙ্ক্তেঽৰ্থাৎ ন প্ৰতীত্য ভুঙ্ক্তে, স এৱাৱশ্যং দণ্ডাৰ্হো ভৱিষ্যতি, যতো যৎ প্ৰত্যযজং নহি তদেৱ পাপমযং ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","বলৱদ্ভিৰস্মাভি ৰ্দুৰ্ব্বলানাং দৌৰ্ব্বল্যং সোঢৱ্যং ন চ স্ৱেষাম্ ইষ্টাচাৰ আচৰিতৱ্যঃ| ");
INSERT INTO sanasm_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","অস্মাকম্ একৈকো জনঃ স্ৱসমীপৱাসিনো হিতাৰ্থং নিষ্ঠাৰ্থঞ্চ তস্যৈৱেষ্টাচাৰম্ আচৰতু| ");
INSERT INTO sanasm_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","যতঃ খ্ৰীষ্টোঽপি নিজেষ্টাচাৰং নাচৰিতৱান্, যথা লিখিতম্ আস্তে, ৎৱন্নিন্দকগণস্যৈৱ নিন্দাভি ৰ্নিন্দিতোঽস্ম্যহং| ");
INSERT INTO sanasm_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","অপৰঞ্চ ৱযং যৎ সহিষ্ণুতাসান্ত্ৱনযো ৰ্জনকেন শাস্ত্ৰেণ প্ৰত্যাশাং লভেমহি তন্নিমিত্তং পূৰ্ৱ্ৱকালে লিখিতানি সৰ্ৱ্ৱৱচনান্যস্মাকম্ উপদেশাৰ্থমেৱ লিলিখিৰে| ");
INSERT INTO sanasm_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","সহিষ্ণুতাসান্ত্ৱনযোৰাকৰো য ঈশ্ৱৰঃ স এৱং কৰোতু যৎ প্ৰভু ৰ্যীশুখ্ৰীষ্ট ইৱ যুষ্মাকম্ একজনোঽন্যজনেন সাৰ্দ্ধং মনস ঐক্যম্ আচৰেৎ; ");
INSERT INTO sanasm_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","যূযঞ্চ সৰ্ৱ্ৱ একচিত্তা ভূৎৱা মুখৈকেনেৱাস্মৎপ্ৰভুযীশুখ্ৰীষ্টস্য পিতুৰীশ্ৱৰস্য গুণান্ কীৰ্ত্তযেত| ");
INSERT INTO sanasm_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","অপৰম্ ঈশ্ৱৰস্য মহিম্নঃ প্ৰকাশাৰ্থং খ্ৰীষ্টো যথা যুষ্মান্ প্ৰত্যগৃহ্লাৎ তথা যুষ্মাকমপ্যেকো জনোঽন্যজনং প্ৰতিগৃহ্লাতু| ");
INSERT INTO sanasm_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","যথা লিখিতম্ আস্তে, অতোঽহং সম্মুখে তিষ্ঠন্ ভিন্নদেশনিৱাসিনাং| স্তুৱংস্ত্ৱাং পৰিগাস্যামি তৱ নাম্নি পৰেশ্ৱৰ|| ");
INSERT INTO sanasm_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","তস্য দযালুৎৱাচ্চ ভিন্নজাতীযা যদ্ ঈশ্ৱৰস্য গুণান্ কীৰ্ত্তযেযুস্তদৰ্থং যীশুঃ খ্ৰীষ্টস্ত্ৱক্ছেদনিযমস্য নিঘ্নোঽভৱদ্ ইত্যহং ৱদামি| যথা লিখিতম্ আস্তে, অতোঽহং সম্মুখে তিষ্ঠন্ ভিন্নদেশনিৱাসিনাং| স্তুৱংস্ত্ৱাং পৰিগাস্যামি তৱ নাম্নি পৰেশ্ৱৰ|| ");
INSERT INTO sanasm_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","অপৰমপি লিখিতম্ আস্তে, হে অন্যজাতযো যূযং সমং নন্দত তজ্জনৈঃ| ");
INSERT INTO sanasm_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","পুনশ্চ লিখিতম্ আস্তে, হে সৰ্ৱ্ৱদেশিনো যূযং ধন্যং ব্ৰূত পৰেশ্ৱৰং| হে তদীযনৰা যূযং কুৰুধ্ৱং তৎপ্ৰশংসনং|| ");
INSERT INTO sanasm_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","অপৰ যীশাযিযোঽপি লিলেখ, যীশযস্য তু যৎ মূলং তৎ প্ৰকাশিষ্যতে তদা| সৰ্ৱ্ৱজাতীযনৃণাঞ্চ শাসকঃ সমুদেষ্যতি| তত্ৰান্যদেশিলোকৈশ্চ প্ৰত্যাশা প্ৰকৰিষ্যতে|| ");
INSERT INTO sanasm_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","অতএৱ যূযং পৱিত্ৰস্যাত্মনঃ প্ৰভাৱাদ্ যৎ সম্পূৰ্ণাং প্ৰত্যাশাং লপ্স্যধ্ৱে তদৰ্থং তৎপ্ৰত্যাশাজনক ঈশ্ৱৰঃ প্ৰত্যযেন যুষ্মান্ শান্ত্যানন্দাভ্যাং সম্পূৰ্ণান্ কৰোতু| ");
INSERT INTO sanasm_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","হে ভ্ৰাতৰো যূযং সদ্ভাৱযুক্তাঃ সৰ্ৱ্ৱপ্ৰকাৰেণ জ্ঞানেন চ সম্পূৰ্ণাঃ পৰস্পৰোপদেশে চ তৎপৰা ইত্যহং নিশ্চিতং জানামি, ");
INSERT INTO sanasm_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","তথাপ্যহং যৎ প্ৰগল্ভতৰো ভৱন্ যুষ্মান্ প্ৰবোধযামি তস্যৈকং কাৰণমিদং| ");
INSERT INTO sanasm_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","ভিন্নজাতীযাঃ পৱিত্ৰেণাত্মনা পাৱিতনৈৱেদ্যৰূপা ভূৎৱা যদ্ গ্ৰাহ্যা ভৱেযুস্তন্নিমিত্তমহম্ ঈশ্ৱৰস্য সুসংৱাদং প্ৰচাৰযিতুং ভিন্নজাতীযানাং মধ্যে যীশুখ্ৰীষ্টস্য সেৱকৎৱং দানং ঈশ্ৱৰাৎ লব্ধৱানস্মি| ");
INSERT INTO sanasm_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","ঈশ্ৱৰং প্ৰতি যীশুখ্ৰীষ্টেন মম শ্লাঘাকৰণস্য কাৰণম্ আস্তে| ");
INSERT INTO sanasm_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","ভিন্নদেশিন আজ্ঞাগ্ৰাহিণঃ কৰ্ত্তুং খ্ৰীষ্টো ৱাক্যেন ক্ৰিযযা চ, আশ্চৰ্য্যলক্ষণৈশ্চিত্ৰক্ৰিযাভিঃ পৱিত্ৰস্যাত্মনঃ প্ৰভাৱেন চ যানি কৰ্ম্মাণি মযা সাধিতৱান্, ");
INSERT INTO sanasm_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","কেৱলং তান্যেৱ ৱিনান্যস্য কস্যচিৎ কৰ্ম্মণো ৱৰ্ণনাং কৰ্ত্তুং প্ৰগল্ভো ন ভৱামি| তস্মাৎ আ যিৰূশালম ইল্লূৰিকং যাৱৎ সৰ্ৱ্ৱত্ৰ খ্ৰীষ্টস্য সুসংৱাদং প্ৰাচাৰযং| ");
INSERT INTO sanasm_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","অন্যেন নিচিতাযাং ভিত্তাৱহং যন্ন নিচিনোমি তন্নিমিত্তং যত্ৰ যত্ৰ স্থানে খ্ৰীষ্টস্য নাম কদাপি কেনাপি ন জ্ঞাপিতং তত্ৰ তত্ৰ সুসংৱাদং প্ৰচাৰযিতুম্ অহং যতে| ");
INSERT INTO sanasm_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","যাদৃশং লিখিতম্ আস্তে, যৈ ৰ্ৱাৰ্ত্তা তস্য ন প্ৰাপ্তা দৰ্শনং তৈস্তু লপ্স্যতে| যৈশ্চ নৈৱ শ্ৰুতং কিঞ্চিৎ বোদ্ধুং শক্ষ্যন্তি তে জনাঃ|| ");
INSERT INTO sanasm_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","তস্মাদ্ যুষ্মৎসমীপগমনাদ্ অহং মুহুৰ্মুহু ৰ্নিৱাৰিতোঽভৱং| ");
INSERT INTO sanasm_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","কিন্ত্ৱিদানীম্ অত্ৰ প্ৰদেশেষু মযা ন গতং স্থানং কিমপি নাৱশিষ্যতে যুষ্মৎসমীপং গন্তুং বহুৱৎসৰানাৰভ্য মামকীনাকাঙ্ক্ষা চ ৱিদ্যত ইতি হেতোঃ ");
INSERT INTO sanasm_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","স্পানিযাদেশগমনকালেঽহং যুষ্মন্মধ্যেন গচ্ছন্ যুষ্মান্ আলোকিষ্যে, ততঃ পৰং যুষ্মৎসম্ভাষণেন তৃপ্তিং পৰিলভ্য তদ্দেশগমনাৰ্থং যুষ্মাভি ৰ্ৱিসৰ্জযিষ্যে, ঈদৃশী মদীযা প্ৰত্যাশা ৱিদ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","কিন্তু সাম্প্ৰতং পৱিত্ৰলোকানাং সেৱনায যিৰূশালম্নগৰং ৱ্ৰজামি| ");
INSERT INTO sanasm_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","যতো যিৰূশালমস্থপৱিত্ৰলোকানাং মধ্যে যে দৰিদ্ৰা অৰ্থৱিশ্ৰাণনেন তানুপকৰ্ত্তুং মাকিদনিযাদেশীযা আখাযাদেশীযাশ্চ লোকা ঐচ্ছন্| ");
INSERT INTO sanasm_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","এষা তেষাং সদিচ্ছা যতস্তে তেষাম্ ঋণিনঃ সন্তি যতো হেতো ৰ্ভিন্নজাতীযা যেষাং পৰমাৰ্থস্যাংশিনো জাতা ঐহিকৱিষযে তেষামুপকাৰস্তৈঃ কৰ্ত্তৱ্যঃ| ");
INSERT INTO sanasm_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","অতো মযা তৎ কৰ্ম্ম সাধযিৎৱা তস্মিন্ ফলে তেভ্যঃ সমৰ্পিতে যুষ্মন্মধ্যেন স্পানিযাদেশো গমিষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","যুষ্মৎসমীপে মমাগমনসমযে খ্ৰীষ্টস্য সুসংৱাদস্য পূৰ্ণৱৰেণ সম্বলিতঃ সন্ অহম্ আগমিষ্যামি ইতি মযা জ্ঞাযতে| ");
INSERT INTO sanasm_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","হে ভ্ৰাতৃগণ প্ৰভো ৰ্যীশুখ্ৰীষ্টস্য নাম্না পৱিত্ৰস্যাত্মানঃ প্ৰেম্না চ ৱিনযেঽহং ");
INSERT INTO sanasm_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","যিহূদাদেশস্থানাম্ অৱিশ্ৱাসিলোকানাং কৰেভ্যো যদহং ৰক্ষাং লভেয মদীযৈতেন সেৱনকৰ্ম্মণা চ যদ্ যিৰূশালমস্থাঃ পৱিত্ৰলোকাস্তুষ্যেযুঃ, ");
INSERT INTO sanasm_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","তদৰ্থং যূযং মৎকৃত ঈশ্ৱৰায প্ৰাৰ্থযমাণা যতধ্ৱং তেনাহম্ ঈশ্ৱৰেচ্ছযা সানন্দং যুষ্মৎসমীপং গৎৱা যুষ্মাভিঃ সহিতঃ প্ৰাণান্ আপ্যাযিতুং পাৰযিষ্যামি| ");
INSERT INTO sanasm_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","শান্তিদাযক ঈশ্ৱৰো যুষ্মাকং সৰ্ৱ্ৱেষাং সঙ্গী ভূযাৎ| ইতি| ");
INSERT INTO sanasm_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","কিংক্ৰীযানগৰীযধৰ্ম্মসমাজস্য পৰিচাৰিকা যা ফৈবীনামিকাস্মাকং ধৰ্ম্মভগিনী তস্যাঃ কৃতেঽহং যুষ্মান্ নিৱেদযামি, ");
INSERT INTO sanasm_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","যূযং তাং প্ৰভুমাশ্ৰিতাং ৱিজ্ঞায তস্যা আতিথ্যং পৱিত্ৰলোকাৰ্হং কুৰুধ্ৱং, যুষ্মত্তস্তস্যা য উপকাৰো ভৱিতুং শক্নোতি তং কুৰুধ্ৱং, যস্মাৎ তযা বহূনাং মম চোপকাৰঃ কৃতঃ| ");
INSERT INTO sanasm_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","অপৰঞ্চ খ্ৰীষ্টস্য যীশোঃ কৰ্ম্মণি মম সহকাৰিণৌ মম প্ৰাণৰক্ষাৰ্থঞ্চ স্ৱপ্ৰাণান্ পণীকৃতৱন্তৌ যৌ প্ৰিষ্কিল্লাক্কিলৌ তৌ মম নমস্কাৰং জ্ঞাপযধ্ৱং| ");
INSERT INTO sanasm_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","তাভ্যাম্ উপকাৰাপ্তিঃ কেৱলং মযা স্ৱীকৰ্ত্তৱ্যেতি নহি ভিন্নদেশীযৈঃ সৰ্ৱ্ৱধৰ্ম্মসমাজৈৰপি| ");
INSERT INTO sanasm_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","অপৰঞ্চ তযো ৰ্গৃহে স্থিতান্ ধৰ্ম্মসমাজলোকান্ মম নমস্কাৰং জ্ঞাপযধ্ৱং| তদ্ৱৎ আশিযাদেশে খ্ৰীষ্টস্য পক্ষে প্ৰথমজাতফলস্ৱৰূপো য ইপেনিতনামা মম প্ৰিযবন্ধুস্তমপি মম নমস্কাৰং জ্ঞাপযধ্ৱং| ");
INSERT INTO sanasm_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","অপৰং বহুশ্ৰমেণাস্মান্ অসেৱত যা মৰিযম্ তামপি নমস্কাৰং জ্ঞাপযধ্ৱং| ");
INSERT INTO sanasm_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","অপৰঞ্চ প্ৰেৰিতেষু খ্যাতকীৰ্ত্তী মদগ্ৰে খ্ৰীষ্টাশ্ৰিতৌ মম স্ৱজাতীযৌ সহবন্দিনৌ চ যাৱান্দ্ৰনীকযূনিযৌ তৌ মম নমস্কাৰং জ্ঞাপযধ্ৱং| ");
INSERT INTO sanasm_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","তথা প্ৰভৌ মৎপ্ৰিযতমম্ আম্প্লিযমপি মম নমস্কাৰং জ্ঞাপযধ্ৱং| ");
INSERT INTO sanasm_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","অপৰং খ্ৰীষ্টসেৱাযাং মম সহকাৰিণম্ ঊৰ্ব্বাণং মম প্ৰিযতমং স্তাখুঞ্চ মম নমস্কাৰং জ্ঞাপযধ্ৱং| ");
INSERT INTO sanasm_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","অপৰং খ্ৰীষ্টেন পৰীক্ষিতম্ আপিল্লিং মম নমস্কাৰং ৱদত, আৰিষ্টবূলস্য পৰিজনাংশ্চ মম নমস্কাৰং জ্ঞাপযধ্ৱং| ");
INSERT INTO sanasm_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","অপৰং মম জ্ঞাতিং হেৰোদিযোনং মম নমস্কাৰং ৱদত, তথা নাৰ্কিসস্য পৰিৱাৰাণাং মধ্যে যে প্ৰভুমাশ্ৰিতাস্তান্ মম নমস্কাৰং ৱদত| ");
INSERT INTO sanasm_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","অপৰং প্ৰভোঃ সেৱাযাং পৰিশ্ৰমকাৰিণ্যৌ ত্ৰুফেনাত্ৰুফোষে মম নমস্কাৰং ৱদত, তথা প্ৰভোঃ সেৱাযাম্ অত্যন্তং পৰিশ্ৰমকাৰিণী যা প্ৰিযা পৰ্ষিস্তাং নমস্কাৰং জ্ঞাপযধ্ৱং| ");
INSERT INTO sanasm_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","অপৰং প্ৰভোৰভিৰুচিতং ৰূফং মম ধৰ্ম্মমাতা যা তস্য মাতা তামপি নমস্কাৰং ৱদত| ");
INSERT INTO sanasm_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","অপৰম্ অসুংকৃতং ফ্লিগোনং হৰ্ম্মং পাত্ৰবং হৰ্ম্মিম্ এতেষাং সঙ্গিভ্ৰাতৃগণঞ্চ নমস্কাৰং জ্ঞাপযধ্ৱং| ");
INSERT INTO sanasm_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","অপৰং ফিললগো যূলিযা নীৰিযস্তস্য ভগিন্যলুম্পা চৈতান্ এতৈঃ সাৰ্দ্ধং যাৱন্তঃ পৱিত্ৰলোকা আসতে তানপি নমস্কাৰং জ্ঞাপযধ্ৱং| ");
INSERT INTO sanasm_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","যূযং পৰস্পৰং পৱিত্ৰচুম্বনেন নমস্কুৰুধ্ৱং| খ্ৰীষ্টস্য ধৰ্ম্মসমাজগণো যুষ্মান্ নমস্কুৰুতে| ");
INSERT INTO sanasm_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","হে ভ্ৰাতৰো যুষ্মান্ ৱিনযেঽহং যুষ্মাভি ৰ্যা শিক্ষা লব্ধা তাম্ অতিক্ৰম্য যে ৱিচ্ছেদান্ ৱিঘ্নাংশ্চ কুৰ্ৱ্ৱন্তি তান্ নিশ্চিনুত তেষাং সঙ্গং ৱৰ্জযত চ| ");
INSERT INTO sanasm_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","যতস্তাদৃশা লোকা অস্মাকং প্ৰভো ৰ্যীশুখ্ৰীষ্টস্য দাসা ইতি নহি কিন্তু স্ৱোদৰস্যৈৱ দাসাঃ; অপৰং প্ৰণযৱচনৈ ৰ্মধুৰৱাক্যৈশ্চ সৰললোকানাং মনাংসি মোহযন্তি| ");
INSERT INTO sanasm_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","যুষ্মাকম্ আজ্ঞাগ্ৰাহিৎৱং সৰ্ৱ্ৱত্ৰ সৰ্ৱ্ৱৈ ৰ্জ্ঞাতং ততোঽহং যুষ্মাসু সানন্দোঽভৱং তথাপি যূযং যৎ সৎজ্ঞানেন জ্ঞানিনঃ কুজ্ঞানেे চাতৎপৰা ভৱেতেতি মমাভিলাষঃ| ");
INSERT INTO sanasm_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","অধিকন্তু শান্তিদাযক ঈশ্ৱৰঃ শৈতানম্ অৱিলম্বং যুষ্মাকং পদানাম্ অধো মৰ্দ্দিষ্যতি| অস্মাকং প্ৰভু ৰ্যীশুখ্ৰীষ্টো যুষ্মাসু প্ৰসাদং ক্ৰিযাৎ| ইতি| ");
INSERT INTO sanasm_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","মম সহকাৰী তীমথিযো মম জ্ঞাতযো লূকিযো যাসোন্ সোসিপাত্ৰশ্চেমে যুষ্মান্ নমস্কুৰ্ৱ্ৱন্তে| ");
INSERT INTO sanasm_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","অপৰম্ এতৎপত্ৰলেখকস্তৰ্ত্তিযনামাহমপি প্ৰভো ৰ্নাম্না যুষ্মান্ নমস্কৰোমি| ");
INSERT INTO sanasm_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","তথা কৃৎস্নধৰ্ম্মসমাজস্য মম চাতিথ্যকাৰী গাযো যুষ্মান্ নমস্কৰোতি| অপৰম্ এতন্নগৰস্য ধনৰক্ষক ইৰাস্তঃ ক্কাৰ্ত্তনামকশ্চৈকো ভ্ৰাতা তাৱপি যুষ্মান্ নমস্কুৰুতঃ| ");
INSERT INTO sanasm_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","অস্মাকং প্ৰভু ৰ্যীশুখ্ৰীষ্টা যুষ্মাসু সৰ্ৱ্ৱেষু প্ৰসাদং ক্ৰিযাৎ| ইতি| ");
INSERT INTO sanasm_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","পূৰ্ৱ্ৱকালিকযুগেষু প্ৰচ্ছন্না যা মন্ত্ৰণাধুনা প্ৰকাশিতা ভূৎৱা ভৱিষ্যদ্ৱাদিলিখিতগ্ৰন্থগণস্য প্ৰমাণাদ্ ৱিশ্ৱাসেন গ্ৰহণাৰ্থং সদাতনস্যেশ্ৱৰস্যাজ্ঞযা সৰ্ৱ্ৱদেশীযলোকান্ জ্ঞাপ্যতে, ");
INSERT INTO sanasm_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","তস্যা মন্ত্ৰণাযা জ্ঞানং লব্ধ্ৱা মযা যঃ সুসংৱাদো যীশুখ্ৰীষ্টমধি প্ৰচাৰ্য্যতে, তদনুসাৰাদ্ যুষ্মান্ ধৰ্ম্মে সুস্থিৰান্ কৰ্ত্তুং সমৰ্থো যোঽদ্ৱিতীযঃ ");
INSERT INTO sanasm_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","সৰ্ৱ্ৱজ্ঞ ঈশ্ৱৰস্তস্য ধন্যৱাদো যীশুখ্ৰীষ্টেন সন্ততং ভূযাৎ| ইতি|");
INSERT INTO sanasm_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","যাৱন্তঃ পৱিত্ৰা লোকাঃ স্ৱেষাম্ অস্মাকঞ্চ ৱসতিস্থানেষ্ৱস্মাকং প্ৰভো ৰ্যীশোঃ খ্ৰীষ্টস্য নাম্না প্ৰাৰ্থযন্তে তৈঃ সহাহূতানাং খ্ৰীষ্টেন যীশুনা পৱিত্ৰীকৃতানাং লোকানাং য ঈশ্ৱৰীযধৰ্ম্মসমাজঃ কৰিন্থনগৰে ৱিদ্যতে ");
INSERT INTO sanasm_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","তং প্ৰতীশ্ৱৰস্যেচ্ছযাহূতো যীশুখ্ৰীষ্টস্য প্ৰেৰিতঃ পৌলঃ সোস্থিনিনামা ভ্ৰাতা চ পত্ৰং লিখতি| ");
INSERT INTO sanasm_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","অস্মাকং পিত্ৰেশ্ৱৰেণ প্ৰভুনা যীশুখ্ৰীষ্টেন চ প্ৰসাদঃ শান্তিশ্চ যুষ্মভ্যং দীযতাং| ");
INSERT INTO sanasm_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","ঈশ্ৱৰো যীশুখ্ৰীষ্টেন যুষ্মান্ প্ৰতি প্ৰসাদং প্ৰকাশিতৱান্, তস্মাদহং যুষ্মন্নিমিত্তং সৰ্ৱ্ৱদা মদীযেশ্ৱৰং ধন্যং ৱদামি| ");
INSERT INTO sanasm_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","খ্ৰীষ্টসম্বন্ধীযং সাক্ষ্যং যুষ্মাকং মধ্যে যেন প্ৰকাৰেণ সপ্ৰমাণম্ অভৱৎ ");
INSERT INTO sanasm_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","তেন যূযং খ্ৰীষ্টাৎ সৰ্ৱ্ৱৱিধৱক্তৃতাজ্ঞানাদীনি সৰ্ৱ্ৱধনানি লব্ধৱন্তঃ| ");
INSERT INTO sanasm_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","ততোঽস্মৎপ্ৰভো ৰ্যীশুখ্ৰীষ্টস্য পুনৰাগমনং প্ৰতীক্ষমাণানাং যুষ্মাকং কস্যাপি ৱৰস্যাভাৱো ন ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","অপৰম্ অস্মাকং প্ৰভো ৰ্যীশুখ্ৰীষ্টস্য দিৱসে যূযং যন্নিৰ্দ্দোষা ভৱেত তদৰ্থং সএৱ যাৱদন্তং যুষ্মান্ সুস্থিৰান্ কৰিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","য ঈশ্ৱৰঃ স্ৱপুত্ৰস্যাস্মৎপ্ৰভো ৰ্যীশুখ্ৰীষ্টস্যাংশিনঃ কৰ্ত্তুং যুষ্মান্ আহূতৱান্ স ৱিশ্ৱসনীযঃ| ");
INSERT INTO sanasm_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","হে ভ্ৰাতৰঃ, অস্মাকং প্ৰভুযীশুখ্ৰীষ্টস্য নাম্না যুষ্মান্ ৱিনযেঽহং সৰ্ৱ্ৱৈ ৰ্যুষ্মাভিৰেকৰূপাণি ৱাক্যানি কথ্যন্তাং যুষ্মন্মধ্যে ভিন্নসঙ্ঘাতা ন ভৱন্তু মনোৱিচাৰযোৰৈক্যেন যুষ্মাকং সিদ্ধৎৱং ভৱতু| ");
INSERT INTO sanasm_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","হে মম ভ্ৰাতৰো যুষ্মন্মধ্যে ৱিৱাদা জাতা ইতি ৱাৰ্ত্তামহং ক্লোয্যাঃ পৰিজনৈ ৰ্জ্ঞাপিতঃ| ");
INSERT INTO sanasm_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","মমাভিপ্ৰেতমিদং যুষ্মাকং কশ্চিৎ কশ্চিদ্ ৱদতি পৌলস্য শিষ্যোঽহম্ আপল্লোঃ শিষ্যোঽহং কৈফাঃ শিষ্যোঽহং খ্ৰীষ্টস্য শিষ্যোঽহমিতি চ| ");
INSERT INTO sanasm_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","খ্ৰীষ্টস্য কিং ৱিভেদঃ কৃতঃ? পৌলঃ কিং যুষ্মৎকৃতে ক্ৰুশে হতঃ? পৌলস্য নাম্না ৱা যূযং কিং মজ্জিতাঃ? ");
INSERT INTO sanasm_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","ক্ৰিষ্পগাযৌ ৱিনা যুষ্মাকং মধ্যেঽন্যঃ কোঽপি মযা ন মজ্জিত ইতি হেতোৰহম্ ঈশ্ৱৰং ধন্যং ৱদামি| ");
INSERT INTO sanasm_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","এতেন মম নাম্না মানৱা মযা মজ্জিতা ইতি ৱক্তুং কেনাপি ন শক্যতে| ");
INSERT INTO sanasm_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","অপৰং স্তিফানস্য পৰিজনা মযা মজ্জিতাস্তদন্যঃ কশ্চিদ্ যন্মযা মজ্জিতস্তদহং ন ৱেদ্মি| ");
INSERT INTO sanasm_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","খ্ৰীষ্টেনাহং মজ্জনাৰ্থং ন প্ৰেৰিতঃ কিন্তু সুসংৱাদস্য প্ৰচাৰাৰ্থমেৱ; সোঽপি ৱাক্পটুতযা মযা ন প্ৰচাৰিতৱ্যঃ, যতস্তথা প্ৰচাৰিতে খ্ৰীষ্টস্য ক্ৰুশে মৃত্যুঃ ফলহীনো ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","যতো হেতো ৰ্যে ৱিনশ্যন্তি তে তাং ক্ৰুশস্য ৱাৰ্ত্তাং প্ৰলাপমিৱ মন্যন্তে কিঞ্চ পৰিত্ৰাণং লভমানেষ্ৱস্মাসু সা ঈশ্ৱৰীযশক্তিস্ৱৰূপা| ");
INSERT INTO sanasm_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","তস্মাদিত্থং লিখিতমাস্তে, জ্ঞানৱতান্তু যৎ জ্ঞানং তন্মযা নাশযিষ্যতে| ৱিলোপযিষ্যতে তদ্ৱদ্ বুদ্ধি ৰ্বদ্ধিমতাং মযা|| ");
INSERT INTO sanasm_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","জ্ঞানী কুত্ৰ? শাস্ত্ৰী ৱা কুত্ৰ? ইহলোকস্য ৱিচাৰতৎপৰো ৱা কুত্ৰ? ইহলোকস্য জ্ঞানং কিমীশ্ৱৰেণ মোহীকৃতং নহি? ");
INSERT INTO sanasm_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","ঈশ্ৱৰস্য জ্ঞানাদ্ ইহলোকস্য মানৱাঃ স্ৱজ্ঞানেনেশ্ৱৰস্য তত্ত্ৱবোধং ন প্ৰাপ্তৱন্তস্তস্মাদ্ ঈশ্ৱৰঃ প্ৰচাৰৰূপিণা প্ৰলাপেন ৱিশ্ৱাসিনঃ পৰিত্ৰাতুং ৰোচিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","যিহূদীযলোকা লক্ষণানি দিদৃক্ষন্তি ভিন্নদেশীযলোকাস্তু ৱিদ্যাং মৃগযন্তে, ");
INSERT INTO sanasm_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","ৱযঞ্চ ক্ৰুশে হতং খ্ৰীষ্টং প্ৰচাৰযামঃ| তস্য প্ৰচাৰো যিহূদীযৈ ৰ্ৱিঘ্ন ইৱ ভিন্নদেশীযৈশ্চ প্ৰলাপ ইৱ মন্যতে, ");
INSERT INTO sanasm_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","কিন্তু যিহূদীযানাং ভিন্নদেশীযানাঞ্চ মধ্যে যে আহূতাস্তেষু স খ্ৰীষ্ট ঈশ্ৱৰীযশক্তিৰিৱেশ্ৱৰীযজ্ঞানমিৱ চ প্ৰকাশতে| ");
INSERT INTO sanasm_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","যত ঈশ্ৱৰে যঃ প্ৰলাপ আৰোপ্যতে স মানৱাতিৰিক্তং জ্ঞানমেৱ যচ্চ দৌৰ্ব্বল্যম্ ঈশ্ৱৰ আৰোপ্যতে তৎ মানৱাতিৰিক্তং বলমেৱ| ");
INSERT INTO sanasm_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","হে ভ্ৰাতৰঃ, আহূতযুষ্মদ্গণো যষ্মাভিৰালোক্যতাং তন্মধ্যে সাংসাৰিকজ্ঞানেন জ্ঞানৱন্তঃ পৰাক্ৰমিণো ৱা কুলীনা ৱা বহৱো ন ৱিদ্যন্তে| ");
INSERT INTO sanasm_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","যত ঈশ্ৱৰো জ্ঞানৱতস্ত্ৰপযিতুং মূৰ্খলোকান্ ৰোচিতৱান্ বলানি চ ত্ৰপযিতুম্ ঈশ্ৱৰো দুৰ্ব্বলান্ ৰোচিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","তথা ৱৰ্ত্তমানলোকান্ সংস্থিতিভ্ৰষ্টান্ কৰ্ত্তুম্ ঈশ্ৱৰো জগতোঽপকৃষ্টান্ হেযান্ অৱৰ্ত্তমানাংশ্চাভিৰোচিতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","তত ঈশ্ৱৰস্য সাক্ষাৎ কেনাপ্যাত্মশ্লাঘা ন কৰ্ত্তৱ্যা| ");
INSERT INTO sanasm_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","যূযঞ্চ তস্মাৎ খ্ৰীষ্টে যীশৌ সংস্থিতিং প্ৰাপ্তৱন্তঃ স ঈশ্ৱৰাদ্ যুষ্মাকং জ্ঞানং পুণ্যং পৱিত্ৰৎৱং মুক্তিশ্চ জাতা| ");
INSERT INTO sanasm_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","অতএৱ যদ্ৱদ্ লিখিতমাস্তে তদ্ৱৎ, যঃ কশ্চিৎ শ্লাঘমানঃ স্যাৎ শ্লাঘতাং প্ৰভুনা স হি| ");
INSERT INTO sanasm_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","হে ভ্ৰাতৰো যুষ্মৎসমীপে মমাগমনকালেঽহং ৱক্তৃতাযা ৱিদ্যাযা ৱা নৈপুণ্যেনেশ্ৱৰস্য সাক্ষ্যং প্ৰচাৰিতৱান্ তন্নহি; ");
INSERT INTO sanasm_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","যতো যীশুখ্ৰীষ্টং তস্য ক্ৰুশে হতৎৱঞ্চ ৱিনা নান্যৎ কিমপি যুষ্মন্মধ্যে জ্ঞাপযিতুং ৱিহিতং বুদ্ধৱান্| ");
INSERT INTO sanasm_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","অপৰঞ্চাতীৱ দৌৰ্ব্বল্যভীতিকম্পযুক্তো যুষ্মাভিঃ সাৰ্দ্ধমাসং| ");
INSERT INTO sanasm_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","অপৰং যুষ্মাকং ৱিশ্ৱাসো যৎ মানুষিকজ্ঞানস্য ফলং ন ভৱেৎ কিন্ত্ৱীশ্ৱৰীযশক্তেঃ ফলং ভৱেৎ, ");
INSERT INTO sanasm_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","তদৰ্থং মম ৱক্তৃতা মদীযপ্ৰচাৰশ্চ মানুষিকজ্ঞানস্য মধুৰৱাক্যসম্বলিতৌ নাস্তাং কিন্ত্ৱাত্মনঃ শক্তেশ্চ প্ৰমাণযুক্তাৱাস্তাং| ");
INSERT INTO sanasm_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","ৱযং জ্ঞানং ভাষামহে তচ্চ সিদ্ধলোকৈ ৰ্জ্ঞানমিৱ মন্যতে, তদিহলোকস্য জ্ঞানং নহি, ইহলোকস্য নশ্ৱৰাণাম্ অধিপতীনাং ৱা জ্ঞানং নহি; ");
INSERT INTO sanasm_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","কিন্তু কালাৱস্থাযাঃ পূৰ্ৱ্ৱস্মাদ্ যৎ জ্ঞানম্ অস্মাকং ৱিভৱাৰ্থম্ ঈশ্ৱৰেণ নিশ্চিত্য প্ৰচ্ছন্নং তন্নিগূঢম্ ঈশ্ৱৰীযজ্ঞানং প্ৰভাষামহে| ");
INSERT INTO sanasm_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","ইহলোকস্যাধিপতীনাং কেনাপি তৎ জ্ঞানং ন লব্ধং, লব্ধে সতি তে প্ৰভাৱৱিশিষ্টং প্ৰভুং ক্ৰুশে নাহনিষ্যন্| ");
INSERT INTO sanasm_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","তদ্ৱল্লিখিতমাস্তে, নেত্ৰেণ ক্কাপি নো দৃষ্টং কৰ্ণেনাপি চ ন শ্ৰুতং| মনোমধ্যে তু কস্যাপি ন প্ৰৱিষ্টং কদাপি যৎ| ঈশ্ৱৰে প্ৰীযমাণানাং কৃতে তৎ তেন সঞ্চিতং| ");
INSERT INTO sanasm_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","অপৰমীশ্ৱৰঃ স্ৱাত্মনা তদস্মাকং সাক্ষাৎ প্ৰাকাশযৎ; যত আত্মা সৰ্ৱ্ৱমেৱানুসন্ধত্তে তেন চেশ্ৱৰস্য মৰ্ম্মতত্ত্ৱমপি বুধ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","মনুজস্যান্তঃস্থমাত্মানং ৱিনা কেন মনুজেন তস্য মনুজস্য তত্ত্ৱং বুধ্যতে? তদ্ৱদীশ্ৱৰস্যাত্মানং ৱিনা কেনাপীশ্ৱৰস্য তত্ত্ৱং ন বুধ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","ৱযঞ্চেহলোকস্যাত্মানং লব্ধৱন্তস্তন্নহি কিন্ত্ৱীশ্ৱৰস্যৈৱাত্মানং লব্ধৱন্তঃ, ততো হেতোৰীশ্ৱৰেণ স্ৱপ্ৰসাদাদ্ অস্মভ্যং যদ্ যদ্ দত্তং তৎসৰ্ৱ্ৱম্ অস্মাভি ৰ্জ্ঞাতুং শক্যতে| ");
INSERT INTO sanasm_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","তচ্চাস্মাভি ৰ্মানুষিকজ্ঞানস্য ৱাক্যানি শিক্ষিৎৱা কথ্যত ইতি নহি কিন্ত্ৱাত্মতো ৱাক্যানি শিক্ষিৎৱাত্মিকৈ ৰ্ৱাক্যৈৰাত্মিকং ভাৱং প্ৰকাশযদ্ভিঃ কথ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","প্ৰাণী মনুষ্য ঈশ্ৱৰীযাত্মনঃ শিক্ষাং ন গৃহ্লাতি যত আত্মিকৱিচাৰেণ সা ৱিচাৰ্য্যেতি হেতোঃ স তাং প্ৰলাপমিৱ মন্যতে বোদ্ধুঞ্চ ন শক্নোতি| ");
INSERT INTO sanasm_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","আত্মিকো মানৱঃ সৰ্ৱ্ৱাণি ৱিচাৰযতি কিন্তু স্ৱযং কেনাপি ন ৱিচাৰ্য্যতে| ");
INSERT INTO sanasm_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","যত ঈশ্ৱৰস্য মনো জ্ঞাৎৱা তমুপদেষ্টুং কঃ শক্নোতি? কিন্তু খ্ৰীষ্টস্য মনোঽস্মাভি ৰ্লব্ধং| ");
INSERT INTO sanasm_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","হে ভ্ৰাতৰঃ, অহমাত্মিকৈৰিৱ যুষ্মাভিঃ সমং সম্ভাষিতুং নাশক্নৱং কিন্তু শাৰীৰিকাচাৰিভিঃ খ্ৰীষ্টধৰ্ম্মে শিশুতুল্যৈশ্চ জনৈৰিৱ যুষ্মাভিঃ সহ সমভাষে| ");
INSERT INTO sanasm_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","যুষ্মান্ কঠিনভক্ষ্যং ন ভোজযন্ দুগ্ধম্ অপাযযং যতো যূযং ভক্ষ্যং গ্ৰহীতুং তদা নাশক্নুত ইদানীমপি ন শক্নুথ, যতো হেতোৰধুনাপি শাৰীৰিকাচাৰিণ আধ্ৱে| ");
INSERT INTO sanasm_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","যুষ্মন্মধ্যে মাৎসৰ্য্যৱিৱাদভেদা ভৱন্তি ততঃ কিং শাৰীৰিকাচাৰিণো নাধ্ৱে মানুষিকমাৰ্গেণ চ ন চৰথ? ");
INSERT INTO sanasm_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","পৌলস্যাহমিত্যাপল্লোৰহমিতি ৱা যদ্ৱাক্যং যুষ্মাকং কৈশ্চিৎ কৈশ্চিৎ কথ্যতে তস্মাদ্ যূযং শাৰীৰিকাচাৰিণ ন ভৱথ? ");
INSERT INTO sanasm_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","পৌলঃ কঃ? আপল্লো ৰ্ৱা কঃ? তৌ পৰিচাৰকমাত্ৰৌ তযোৰেকৈকস্মৈ চ প্ৰভু ৰ্যাদৃক্ ফলমদদাৎ তদ্ৱৎ তযোৰ্দ্ৱাৰা যূযং ৱিশ্ৱাসিনো জাতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","অহং ৰোপিতৱান্ আপল্লোশ্চ নিষিক্তৱান্ ঈশ্ৱৰশ্চাৱৰ্দ্ধযৎ| ");
INSERT INTO sanasm_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","অতো ৰোপযিতৃসেক্তাৰাৱসাৰৌ ৱৰ্দ্ধযিতেশ্ৱৰ এৱ সাৰঃ| ");
INSERT INTO sanasm_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","ৰোপযিতৃসেক্তাৰৌ চ সমৌ তযোৰেকৈকশ্চ স্ৱশ্ৰমযোগ্যং স্ৱৱেতনং লপ্স্যতে| ");
INSERT INTO sanasm_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","আৱামীশ্ৱৰেণ সহ কৰ্ম্মকাৰিণৌ, ঈশ্ৱৰস্য যৎ ক্ষেত্ৰম্ ঈশ্ৱৰস্য যা নিৰ্ম্মিতিঃ সা যূযমেৱ| ");
INSERT INTO sanasm_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","ঈশ্ৱৰস্য প্ৰসাদাৎ মযা যৎ পদং লব্ধং তস্মাৎ জ্ঞানিনা গৃহকাৰিণেৱ মযা ভিত্তিমূলং স্থাপিতং তদুপৰি চান্যেন নিচীযতে| কিন্তু যেন যন্নিচীযতে তৎ তেন ৱিৱিচ্যতাং| ");
INSERT INTO sanasm_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","যতো যীশুখ্ৰীষ্টৰূপং যদ্ ভিত্তিমূলং স্থাপিতং তদন্যৎ কিমপি ভিত্তিমূলং স্থাপযিতুং কেনাপি ন শক্যতে| ");
INSERT INTO sanasm_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","এতদ্ভিত্তিমূলস্যোপৰি যদি কেচিৎ স্ৱৰ্ণৰূপ্যমণিকাষ্ঠতৃণনলান্ নিচিন্ৱন্তি, ");
INSERT INTO sanasm_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","তৰ্হ্যেকৈকস্য কৰ্ম্ম প্ৰকাশিষ্যতে যতঃ স দিৱসস্তৎ প্ৰকাশযিষ্যতি| যতো হতোস্তন দিৱসেন ৱহ্নিমযেনোদেতৱ্যং তত একৈকস্য কৰ্ম্ম কীদৃশমেতস্য পৰীক্ষা বহ্নিনা ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","যস্য নিচযনৰূপং কৰ্ম্ম স্থাস্নু ভৱিষ্যতি স ৱেতনং লপ্স্যতে| ");
INSERT INTO sanasm_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","যস্য চ কৰ্ম্ম ধক্ষ্যতে তস্য ক্ষতি ৰ্ভৱিষ্যতি কিন্তু ৱহ্নে ৰ্নিৰ্গতজন ইৱ স স্ৱযং পৰিত্ৰাণং প্ৰাপ্স্যতি| ");
INSERT INTO sanasm_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","যূযম্ ঈশ্ৱৰস্য মন্দিৰং যুষ্মন্মধ্যে চেশ্ৱৰস্যাত্মা নিৱসতীতি কিং ন জানীথ? ");
INSERT INTO sanasm_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","ঈশ্ৱৰস্য মন্দিৰং যেন ৱিনাশ্যতে সোঽপীশ্ৱৰেণ ৱিনাশযিষ্যতে যত ঈশ্ৱৰস্য মন্দিৰং পৱিত্ৰমেৱ যূযং তু তন্মন্দিৰম্ আধ্ৱে| ");
INSERT INTO sanasm_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","কোপি স্ৱং ন ৱঞ্চযতাং| যুষ্মাকং কশ্চন চেদিহলোকস্য জ্ঞানেন জ্ঞানৱানহমিতি বুধ্যতে তৰ্হি স যৎ জ্ঞানী ভৱেৎ তদৰ্থং মূঢো ভৱতু| ");
INSERT INTO sanasm_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","যস্মাদিহলোকস্য জ্ঞানম্ ঈশ্ৱৰস্য সাক্ষাৎ মূঢৎৱমেৱ| এতস্মিন্ লিখিতমপ্যাস্তে, তীক্ষ্ণা যা জ্ঞানিনাং বুদ্ধিস্তযা তান্ ধৰতীশ্ৱৰঃ| ");
INSERT INTO sanasm_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","পুনশ্চ| জ্ঞানিনাং কল্পনা ৱেত্তি পৰমেশো নিৰৰ্থকাঃ| ");
INSERT INTO sanasm_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","অতএৱ কোঽপি মনুজৈৰাত্মানং ন শ্লাঘতাং যতঃ সৰ্ৱ্ৱাণি যুষ্মাকমেৱ, ");
INSERT INTO sanasm_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","পৌল ৱা আপল্লো ৰ্ৱা কৈফা ৱা জগদ্ ৱা জীৱনং ৱা মৰণং ৱা ৱৰ্ত্তমানং ৱা ভৱিষ্যদ্ৱা সৰ্ৱ্ৱাণ্যেৱ যুষ্মাকং, ");
INSERT INTO sanasm_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","যূযঞ্চ খ্ৰীষ্টস্য, খ্ৰীষ্টশ্চেশ্ৱৰস্য| ");
INSERT INTO sanasm_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","লোকা অস্মান্ খ্ৰীষ্টস্য পৰিচাৰকান্ ঈশ্ৱৰস্য নিগূঠৱাক্যধনস্যাধ্যক্ষাংশ্চ মন্যন্তাং| ");
INSERT INTO sanasm_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","কিঞ্চ ধনাধ্যক্ষেণ ৱিশ্ৱসনীযেন ভৱিতৱ্যমেতদেৱ লোকৈ ৰ্যাচ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","অতো ৱিচাৰযদ্ভি ৰ্যুষ্মাভিৰন্যৈঃ কৈশ্চিন্ মনুজৈ ৰ্ৱা মম পৰীক্ষণং মযাতীৱ লঘু মন্যতে ঽহমপ্যাত্মানং ন ৱিচাৰযামি| ");
INSERT INTO sanasm_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","মযা কিমপ্যপৰাদ্ধমিত্যহং ন ৱেদ্মি কিন্ত্ৱেতেন মম নিৰপৰাধৎৱং ন নিশ্চীযতে প্ৰভুৰেৱ মম ৱিচাৰযিতাস্তি| ");
INSERT INTO sanasm_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","অত উপযুক্তসমযাৎ পূৰ্ৱ্ৱম্ অৰ্থতঃ প্ৰভোৰাগমনাৎ পূৰ্ৱ্ৱং যুষ্মাভি ৰ্ৱিচাৰো ন ক্ৰিযতাং| প্ৰভুৰাগত্য তিমিৰেণ প্ৰচ্ছন্নানি সৰ্ৱ্ৱাণি দীপযিষ্যতি মনসাং মন্ত্ৰণাশ্চ প্ৰকাশযিষ্যতি তস্মিন্ সময ঈশ্ৱৰাদ্ একৈকস্য প্ৰশংসা ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","হে ভ্ৰাতৰঃ সৰ্ৱ্ৱাণ্যেতানি মযাত্মানম্ আপল্লৱঞ্চোদ্দিশ্য কথিতানি তস্যৈতৎ কাৰণং যুযং যথা শাস্ত্ৰীযৱিধিমতিক্ৰম্য মানৱম্ অতীৱ নাদৰিষ্যধ্ব ঈত্থঞ্চৈকেন ৱৈপৰীত্যাদ্ অপৰেণ ন শ্লাঘিষ্যধ্ব এতাদৃশীং শিক্ষামাৱযোৰ্দৃষ্টান্তাৎ লপ্স্যধ্ৱে| ");
INSERT INTO sanasm_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","অপৰাৎ কস্ত্ৱাং ৱিশেষযতি? তুভ্যং যন্ন দত্ত তাদৃশং কিং ধাৰযসি? অদত্তেনেৱ দত্তেন ৱস্তুনা কুতঃ শ্লাঘসে? ");
INSERT INTO sanasm_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","ইদানীমেৱ যূযং কিং তৃপ্তা লব্ধধনা ৱা? অস্মাস্ৱৱিদ্যমানেষু যূযং কিং ৰাজৎৱপদং প্ৰাপ্তাঃ? যুষ্মাকং ৰাজৎৱং মযাভিলষিতং যতস্তেন যুষ্মাভিঃ সহ ৱযমপি ৰাজ্যাংশিনো ভৱিষ্যামঃ| ");
INSERT INTO sanasm_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","প্ৰেৰিতা ৱযং শেষা হন্তৱ্যাশ্চেৱেশ্ৱৰেণ নিদৰ্শিতাঃ| যতো ৱযং সৰ্ৱ্ৱলোকানাম্ অৰ্থতঃ স্ৱৰ্গীযদূতানাং মানৱানাঞ্চ কৌতুকাস্পদানি জাতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","খ্ৰীষ্টস্য কৃতে ৱযং মূঢাঃ কিন্তু যূযং খ্ৰীষ্টেন জ্ঞানিনঃ, ৱযং দুৰ্ব্বলা যূযঞ্চ সবলাঃ, যূযং সম্মানিতা ৱযঞ্চাপমানিতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","ৱযমদ্যাপি ক্ষুধাৰ্ত্তাস্তৃষ্ণাৰ্ত্তা ৱস্ত্ৰহীনাস্তাডিতা আশ্ৰমৰহিতাশ্চ সন্তঃ ");
INSERT INTO sanasm_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","কৰ্ম্মণি স্ৱকৰান্ ৱ্যাপাৰযন্তশ্চ দুঃখৈঃ কালং যাপযামঃ| গৰ্হিতৈৰস্মাভিৰাশীঃ কথ্যতে দূৰীকৃতৈঃ সহ্যতে নিন্দিতৈঃ প্ৰসাদ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","ৱযমদ্যাপি জগতঃ সম্মাৰ্জনীযোগ্যা অৱকৰা ইৱ সৰ্ৱ্ৱৈ ৰ্মন্যামহে| ");
INSERT INTO sanasm_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","যুষ্মান্ ত্ৰপযিতুমহমেতানি লিখামীতি নহি কিন্তু প্ৰিযাত্মজানিৱ যুষ্মান্ প্ৰবোধযামি| ");
INSERT INTO sanasm_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","যতঃ খ্ৰীষ্টধৰ্ম্মে যদ্যপি যুষ্মাকং দশসহস্ৰাণি ৱিনেতাৰো ভৱন্তি তথাপি বহৱো জনকা ন ভৱন্তি যতোঽহমেৱ সুসংৱাদেন যীশুখ্ৰীষ্টে যুষ্মান্ অজনযং| ");
INSERT INTO sanasm_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","অতো যুষ্মান্ ৱিনযেঽহং যূযং মদনুগামিনো ভৱত| ");
INSERT INTO sanasm_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","ইত্যৰ্থং সৰ্ৱ্ৱেষু ধৰ্ম্মসমাজেষু সৰ্ৱ্ৱত্ৰ খ্ৰীষ্টধৰ্ম্মযোগ্যা যে ৱিধযো মযোপদিশ্যন্তে তান্ যো যুষ্মান্ স্মাৰযিষ্যত্যেৱম্ভূতং প্ৰভোঃ কৃতে প্ৰিযং ৱিশ্ৱাসিনঞ্চ মদীযতনযং তীমথিযং যুষ্মাকং সমীপং প্ৰেষিতৱানহং| ");
INSERT INTO sanasm_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","অপৰমহং যুষ্মাকং সমীপং ন গমিষ্যামীতি বুদ্ধ্ৱা যুষ্মাকং কিযন্তো লোকা গৰ্ৱ্ৱন্তি| ");
INSERT INTO sanasm_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","কিন্তু যদি প্ৰভেৰিচ্ছা ভৱতি তৰ্হ্যহমৱিলম্বং যুষ্মৎসমীপমুপস্থায তেষাং দৰ্পধ্মাতানাং লোকানাং ৱাচং জ্ঞাস্যামীতি নহি সামৰ্থ্যমেৱ জ্ঞাস্যামি| ");
INSERT INTO sanasm_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","যস্মাদীশ্ৱৰস্য ৰাজৎৱং ৱাগ্যুক্তং নহি কিন্তু সামৰ্থ্যযুক্তং| ");
INSERT INTO sanasm_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","যুষ্মাকং কা ৱাঞ্ছা? যুষ্মৎসমীপে মযা কিং দণ্ডপাণিনা গন্তৱ্যমুত প্ৰেমনম্ৰতাত্মযুক্তেন ৱা? ");
INSERT INTO sanasm_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","অপৰং যুষ্মাকং মধ্যে ৱ্যভিচাৰো ৱিদ্যতে স চ ৱ্যভিচাৰস্তাদৃশো যদ্ দেৱপূজকানাং মধ্যেঽপি তত্তুল্যো ন ৱিদ্যতে ফলতো যুষ্মাকমেকো জনো ৱিমাতৃগমনং কৃৰুত ইতি ৱাৰ্ত্তা সৰ্ৱ্ৱত্ৰ ৱ্যাপ্তা| ");
INSERT INTO sanasm_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","তথাচ যূযং দৰ্পধ্মাতা আধ্বে, তৎ কৰ্ম্ম যেন কৃতং স যথা যুষ্মন্মধ্যাদ্ দূৰীক্ৰিযতে তথা শোকো যুষ্মাভি ৰ্ন ক্ৰিযতে কিম্ এতৎ? ");
INSERT INTO sanasm_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","অৱিদ্যমানে মদীযশৰীৰে মমাত্মা যুষ্মন্মধ্যে ৱিদ্যতে অতোঽহং ৱিদ্যমান ইৱ তৎকৰ্ম্মকাৰিণো ৱিচাৰং নিশ্চিতৱান্, ");
INSERT INTO sanasm_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","অস্মৎপ্ৰভো ৰ্যীশুখ্ৰীষ্টস্য নাম্না যুষ্মাকং মদীযাত্মনশ্চ মিলনে জাতে ঽস্মৎপ্ৰভো ৰ্যীশুখ্ৰীষ্টস্য শক্তেঃ সাহায্যেন ");
INSERT INTO sanasm_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","স নৰঃ শৰীৰনাশাৰ্থমস্মাভিঃ শযতানো হস্তে সমৰ্পযিতৱ্যস্ততোঽস্মাকং প্ৰভো ৰ্যীশো ৰ্দিৱসে তস্যাত্মা ৰক্ষাং গন্তুং শক্ষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","যুষ্মাকং দৰ্পো ন ভদ্ৰায যূযং কিমেতন্ন জানীথ, যথা, ৱিকাৰঃ কৃৎস্নশক্তূনাং স্ৱল্পকিণ্ৱেন জাযতে| ");
INSERT INTO sanasm_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","যূযং যৎ নৱীনশক্তুস্ৱৰূপা ভৱেত তদৰ্থং পুৰাতনং কিণ্ৱম্ অৱমাৰ্জ্জত যতো যুষ্মাভিঃ কিণ্ৱশূন্যৈ ৰ্ভৱিতৱ্যং| অপৰম্ অস্মাকং নিস্তাৰোৎসৱীযমেষশাৱকো যঃ খ্ৰীষ্টঃ সোঽস্মদৰ্থং বলীকৃতো ঽভৱৎ| ");
INSERT INTO sanasm_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","অতঃ পুৰাতনকিণ্ৱেনাৰ্থতো দুষ্টতাজিঘাংসাৰূপেণ কিণ্ৱেন তন্নহি কিন্তু সাৰল্যসত্যৎৱৰূপযা কিণ্ৱশূন্যতযাস্মাভিৰুৎসৱঃ কৰ্ত্তৱ্যঃ| ");
INSERT INTO sanasm_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","ৱ্যাভিচাৰিণাং সংসৰ্গো যুষ্মাভি ৰ্ৱিহাতৱ্য ইতি মযা পত্ৰে লিখিতং| ");
INSERT INTO sanasm_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","কিন্ত্ৱৈহিকলোকানাং মধ্যে যে ৱ্যভিচাৰিণো লোভিন উপদ্ৰাৱিণো দেৱপূজকা ৱা তেষাং সংসৰ্গঃ সৰ্ৱ্ৱথা ৱিহাতৱ্য ইতি নহি, ৱিহাতৱ্যে সতি যুষ্মাভি ৰ্জগতো নিৰ্গন্তৱ্যমেৱ| ");
INSERT INTO sanasm_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","কিন্তু ভ্ৰাতৃৎৱেন ৱিখ্যাতঃ কশ্চিজ্জনো যদি ৱ্যভিচাৰী লোভী দেৱপূজকো নিন্দকো মদ্যপ উপদ্ৰাৱী ৱা ভৱেৎ তৰ্হি তাদৃশেন মানৱেন সহ ভোজনপানেঽপি যুষ্মাভি ৰ্ন কৰ্ত্তৱ্যে ইত্যধুনা মযা লিখিতং| ");
INSERT INTO sanasm_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","সমাজবহিঃস্থিতানাং লোকানাং ৱিচাৰকৰণে মম কোঽধিকাৰঃ? কিন্তু তদন্তৰ্গতানাং ৱিচাৰণং যুষ্মাভিঃ কিং ন কৰ্ত্তৱ্যং ভৱেৎ? ");
INSERT INTO sanasm_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","বহিঃস্থানাং তু ৱিচাৰ ঈশ্ৱৰেণ কাৰিষ্যতে| অতো যুষ্মাভিঃ স পাতকী স্ৱমধ্যাদ্ বহিষ্ক্ৰিযতাং| ");
INSERT INTO sanasm_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","যুষ্মাকমেকস্য জনস্যাপৰেণ সহ ৱিৱাদে জাতে স পৱিত্ৰলোকৈ ৰ্ৱিচাৰমকাৰযন্ কিম্ অধাৰ্ম্মিকলোকৈ ৰ্ৱিচাৰযিতুং প্ৰোৎসহতে? ");
INSERT INTO sanasm_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","জগতোঽপি ৱিচাৰণং পৱিত্ৰলোকৈঃ কাৰিষ্যত এতদ্ যূযং কিং ন জানীথ? অতো জগদ্ যদি যুষ্মাভি ৰ্ৱিচাৰযিতৱ্যং তৰ্হি ক্ষুদ্ৰতমৱিচাৰেষু যূযং কিমসমৰ্থাঃ? ");
INSERT INTO sanasm_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","দূতা অপ্যস্মাভি ৰ্ৱিচাৰযিষ্যন্ত ইতি কিং ন জানীথ? অত ঐহিকৱিষযাঃ কিম্ অস্মাভি ৰ্ন ৱিচাৰযিতৱ্যা ভৱেযুঃ? ");
INSERT INTO sanasm_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","ঐহিকৱিষযস্য ৱিচাৰে যুষ্মাভিঃ কৰ্ত্তৱ্যে যে লোকাঃ সমিতৌ ক্ষুদ্ৰতমাস্ত এৱ নিযুজ্যন্তাং| ");
INSERT INTO sanasm_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","অহং যুষ্মান্ ত্ৰপযিতুমিচ্ছন্ ৱদামি যৃষ্মন্মধ্যে কিমেকোঽপি মনুষ্যস্তাদৃগ্ বুদ্ধিমান্নহি যো ভ্ৰাতৃৱিৱাদৱিচাৰণে সমৰ্থঃ স্যাৎ? ");
INSERT INTO sanasm_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","কিঞ্চৈকো ভ্ৰাতা ভ্ৰাত্ৰান্যেন কিমৱিশ্ৱাসিনাং ৱিচাৰকাণাং সাক্ষাদ্ ৱিৱদতে? যষ্মন্মধ্যে ৱিৱাদা ৱিদ্যন্ত এতদপি যুষ্মাকং দোষঃ| ");
INSERT INTO sanasm_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","যূযং কুতোঽন্যাযসহনং ক্ষতিসহনং ৱা শ্ৰেযো ন মন্যধ্ৱে? ");
INSERT INTO sanasm_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","কিন্তু যূযমপি ভ্ৰাতৃনেৱ প্ৰত্যন্যাযং ক্ষতিঞ্চ কুৰুথ কিমেতৎ? ");
INSERT INTO sanasm_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","ঈশ্ৱৰস্য ৰাজ্যেঽন্যাযকাৰিণাং লোকানামধিকাৰো নাস্ত্যেতদ্ যূযং কিং ন জানীথ? মা ৱঞ্চ্যধ্ৱং, যে ৱ্যভিচাৰিণো দেৱাৰ্চ্চিনঃ পাৰদাৰিকাঃ স্ত্ৰীৱদাচাৰিণঃ পুংমৈথুনকাৰিণস্তস্কৰা ");
INSERT INTO sanasm_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","লোভিনো মদ্যপা নিন্দকা উপদ্ৰাৱিণো ৱা ত ঈশ্ৱৰস্য ৰাজ্যভাগিনো ন ভৱিষ্যন্তি| ");
INSERT INTO sanasm_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","যূযঞ্চৈৱংৱিধা লোকা আস্ত কিন্তু প্ৰভো ৰ্যীশো ৰ্নাম্নাস্মদীশ্ৱৰস্যাত্মনা চ যূযং প্ৰক্ষালিতাঃ পাৱিতাঃ সপুণ্যীকৃতাশ্চ| ");
INSERT INTO sanasm_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","মদৰ্থং সৰ্ৱ্ৱং দ্ৰৱ্যম্ অপ্ৰতিষিদ্ধং কিন্তু ন সৰ্ৱ্ৱং হিতজনকং| মদৰ্থং সৰ্ৱ্ৱমপ্ৰতিষিদ্ধং তথাপ্যহং কস্যাপি দ্ৰৱ্যস্য ৱশীকৃতো ন ভৱিষ্যামি| ");
INSERT INTO sanasm_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","উদৰায ভক্ষ্যাণি ভক্ষ্যেভ্যশ্চোদৰং, কিন্তু ভক্ষ্যোদৰে ঈশ্ৱৰেণ নাশযিষ্যেতে; অপৰং দেহো ন ৱ্যভিচাৰায কিন্তু প্ৰভৱে প্ৰভুশ্চ দেহায| ");
INSERT INTO sanasm_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","যশ্চেশ্ৱৰঃ প্ৰভুমুত্থাপিতৱান্ স স্ৱশক্ত্যাস্মানপ্যুত্থাপযিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","যুষ্মাকং যানি শৰীৰাণি তানি খ্ৰীষ্টস্যাঙ্গানীতি কিং যূযং ন জানীথ? অতঃ খ্ৰীষ্টস্য যান্যঙ্গানি তানি মযাপহৃত্য ৱেশ্যাযা অঙ্গানি কিং কাৰিষ্যন্তে? তন্ন ভৱতু| ");
INSERT INTO sanasm_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","যঃ কশ্চিদ্ ৱেশ্যাযাম্ আসজ্যতে স তযা সহৈকদেহো ভৱতি কিং যূযমেতন্ন জানীথ? যতো লিখিতমাস্তে, যথা, তৌ দ্ৱৌ জনাৱেকাঙ্গৌ ভৱিষ্যতঃ| ");
INSERT INTO sanasm_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","মানৱা যান্যন্যানি কলুষাণি কুৰ্ৱ্ৱতে তানি ৱপু ৰ্ন সমাৱিশন্তি কিন্তু ৱ্যভিচাৰিণা স্ৱৱিগ্ৰহস্য ৱিৰুদ্ধং কল্মষং ক্ৰিযতে| ");
INSERT INTO sanasm_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","মানৱা যান্যন্যানি কলুষাণি কুৰ্ৱ্ৱতে তানি ৱপু ৰ্ন সমাৱিশন্তি কিন্তু ৱ্যভিচাৰিণা স্ৱৱিগ্ৰহস্য ৱিৰুদ্ধং কল্মষং ক্ৰিযতে| ");
INSERT INTO sanasm_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","যুষ্মাকং যানি ৱপূংসি তানি যুষ্মদন্তঃস্থিতস্যেশ্ৱৰাল্লব্ধস্য পৱিত্ৰস্যাত্মনো মন্দিৰাণি যূযঞ্চ স্ৱেষাং স্ৱামিনো নাধ্ৱে কিমেতদ্ যুষ্মাভি ৰ্ন জ্ঞাযতে? ");
INSERT INTO sanasm_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","যূযং মূল্যেন ক্ৰীতা অতো ৱপুৰ্মনোভ্যাম্ ঈশ্ৱৰো যুষ্মাভিঃ পূজ্যতাং যত ঈশ্ৱৰ এৱ তযোঃ স্ৱামী| ");
INSERT INTO sanasm_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","অপৰঞ্চ যুষ্মাভি ৰ্মাং প্ৰতি যৎ পত্ৰমলেখি তস্যোত্তৰমেতৎ, যোষিতোঽস্পৰ্শনং মনুজস্য ৱৰং; ");
INSERT INTO sanasm_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","কিন্তু ৱ্যভিচাৰভযাদ্ একৈকস্য পুংসঃ স্ৱকীযভাৰ্য্যা ভৱতু তদ্ৱদ্ একৈকস্যা যোষিতো ঽপি স্ৱকীযভৰ্ত্তা ভৱতু| ");
INSERT INTO sanasm_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","ভাৰ্য্যাযৈ ভৰ্ত্ৰা যদ্যদ্ ৱিতৰণীযং তদ্ ৱিতীৰ্য্যতাং তদ্ৱদ্ ভৰ্ত্ৰেঽপি ভাৰ্য্যযা ৱিতৰণীযং ৱিতীৰ্য্যতাং| ");
INSERT INTO sanasm_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","ভাৰ্য্যাযাঃ স্ৱদেহে স্ৱৎৱং নাস্তি ভৰ্ত্তুৰেৱ, তদ্ৱদ্ ভৰ্ত্তুৰপি স্ৱদেহে স্ৱৎৱং নাস্তি ভাৰ্য্যাযা এৱ| ");
INSERT INTO sanasm_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","উপোষণপ্ৰাৰ্থনযোঃ সেৱনাৰ্থম্ একমন্ত্ৰণানাং যুষ্মাকং কিযৎকালং যাৱদ্ যা পৃথক্স্থিতি ৰ্ভৱতি তদন্যো ৱিচ্ছেদো যুষ্মন্মধ্যে ন ভৱতু, ততঃ পৰম্ ইন্দ্ৰিযাণাম্ অধৈৰ্য্যাৎ শযতান্ যদ্ যুষ্মান্ পৰীক্ষাং ন নযেৎ তদৰ্থং পুনৰেকত্ৰ মিলত| ");
INSERT INTO sanasm_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","এতদ্ আদেশতো নহি কিন্ত্ৱনুজ্ঞাত এৱ মযা কথ্যতে, ");
INSERT INTO sanasm_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","যতো মমাৱস্থেৱ সৰ্ৱ্ৱমানৱানামৱস্থা ভৱৎৱিতি মম ৱাঞ্ছা কিন্ত্ৱীশ্ৱৰাদ্ একেনৈকো ৱৰোঽন্যেন চান্যো ৱৰ ইত্থমেকৈকেন স্ৱকীযৱৰো লব্ধঃ| ");
INSERT INTO sanasm_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","অপৰম্ অকৃতৱিৱাহান্ ৱিধৱাশ্চ প্ৰতি মমৈতন্নিৱেদনং মমেৱ তেষামৱস্থিতি ৰ্ভদ্ৰা; ");
INSERT INTO sanasm_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","কিঞ্চ যদি তৈৰিন্দ্ৰিযাণি নিযন্তুং ন শক্যন্তে তৰ্হি ৱিৱাহঃ ক্ৰিযতাং যতঃ কামদহনাদ্ ৱ্যূঢৎৱং ভদ্ৰং| ");
INSERT INTO sanasm_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","যে চ কৃতৱিৱাহাস্তে মযা নহি প্ৰভুনৈৱৈতদ্ আজ্ঞাপ্যন্তে| ");
INSERT INTO sanasm_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","ভাৰ্য্যা ভৰ্ত্তৃতঃ পৃথক্ ন ভৱতু| যদি ৱা পৃথগ্ভূতা স্যাৎ তৰ্হি নিৰ্ৱিৱাহা তিষ্ঠতু স্ৱীযপতিনা ৱা সন্দধাতু ভৰ্ত্তাপি ভাৰ্য্যাং ন ত্যজতু| ");
INSERT INTO sanasm_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","ইতৰান্ জনান্ প্ৰতি প্ৰভু ৰ্ন ব্ৰৱীতি কিন্ত্ৱহং ব্ৰৱীমি; কস্যচিদ্ ভ্ৰাতুৰ্যোষিদ্ অৱিশ্ৱাসিনী সত্যপি যদি তেন সহৱাসে তুষ্যতি তৰ্হি সা তেন ন ত্যজ্যতাং| ");
INSERT INTO sanasm_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","তদ্ৱৎ কস্যাশ্চিদ্ যোষিতঃ পতিৰৱিশ্ৱাসী সন্নপি যদি তযা সহৱাসে তুষ্যতি তৰ্হি স তযা ন ত্যজ্যতাং| ");
INSERT INTO sanasm_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","যতোঽৱিশ্ৱাসী ভৰ্ত্তা ভাৰ্য্যযা পৱিত্ৰীভূতঃ, তদ্ৱদৱিশ্ৱাসিনী ভাৰ্য্যা ভৰ্ত্ৰা পৱিত্ৰীভূতা; নোচেদ্ যুষ্মাকমপত্যান্যশুচীন্যভৱিষ্যন্ কিন্ত্ৱধুনা তানি পৱিত্ৰাণি সন্তি| ");
INSERT INTO sanasm_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","অৱিশ্ৱাসী জনো যদি ৱা পৃথগ্ ভৱতি তৰ্হি পৃথগ্ ভৱতু; এতেন ভ্ৰাতা ভগিনী ৱা ন নিবধ্যতে তথাপি ৱযমীশ্ৱৰেণ শান্তযে সমাহূতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","হে নাৰি তৱ ভৰ্ত্তুঃ পৰিত্ৰাণং ৎৱত্তো ভৱিষ্যতি ন ৱেতি ৎৱযা কিং জ্ঞাযতে? হে নৰ তৱ জাযাযাঃ পৰিত্ৰাণং ৎৱত্তেा ভৱিষ্যতি ন ৱেতি ৎৱযা কিং জ্ঞাযতে? ");
INSERT INTO sanasm_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","একৈকো জনঃ পৰমেশ্ৱৰাল্লব্ধং যদ্ ভজতে যস্যাঞ্চাৱস্থাযাম্ ঈশ্ৱৰেণাহ্ৱাযি তদনুসাৰেণৈৱাচৰতু তদহং সৰ্ৱ্ৱসমাজস্থান্ আদিশামি| ");
INSERT INTO sanasm_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","ছিন্নৎৱগ্ ভৃৎৱা য আহূতঃ স প্ৰকৃষ্টৎৱক্ ন ভৱতু, তদ্ৱদ্ অছিন্নৎৱগ্ ভূৎৱা য আহূতঃ স ছিন্নৎৱক্ ন ভৱতু| ");
INSERT INTO sanasm_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","ৎৱক্ছেদঃ সাৰো নহি তদ্ৱদৎৱক্ছেদোঽপি সাৰো নহি কিন্ত্ৱীশ্ৱৰস্যাজ্ঞানাং পালনমেৱ| ");
INSERT INTO sanasm_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","যো জনো যস্যামৱস্থাযামাহ্ৱাযি স তস্যামেৱাৱতিষ্ঠতাং| ");
INSERT INTO sanasm_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","দাসঃ সন্ ৎৱং কিমাহূতোঽসি? তন্মা চিন্তয, তথাচ যদি স্ৱতন্ত্ৰো ভৱিতুং শক্নুযাস্তৰ্হি তদেৱ ৱৃণু| ");
INSERT INTO sanasm_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","যতঃ প্ৰভুনাহূতো যো দাসঃ স প্ৰভো ৰ্মোচিতজনঃ| তদ্ৱদ্ তেনাহূতঃ স্ৱতন্ত্ৰো জনোঽপি খ্ৰীষ্টস্য দাস এৱ| ");
INSERT INTO sanasm_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","যূযং মূল্যেন ক্ৰীতা অতো হেতো ৰ্মানৱানাং দাসা মা ভৱত| ");
INSERT INTO sanasm_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","হে ভ্ৰাতৰো যস্যামৱস্থাযাং যস্যাহ্ৱানমভৱৎ তযা স ঈশ্ৱৰস্য সাক্ষাৎ তিষ্ঠতু| ");
INSERT INTO sanasm_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","অপৰম্ অকৃতৱিৱাহান্ জনান্ প্ৰতি প্ৰভোঃ কোঽপ্যাদেশো মযা ন লব্ধঃ কিন্তু প্ৰভোৰনুকম্পযা ৱিশ্ৱাস্যো ভূতোঽহং যদ্ ভদ্ৰং মন্যে তদ্ ৱদামি| ");
INSERT INTO sanasm_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","ৱৰ্ত্তমানাৎ ক্লেশসমযাৎ মনুষ্যস্যানূঢৎৱং ভদ্ৰমিতি মযা বুধ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","ৎৱং কিং যোষিতি নিবদ্ধোঽসি তৰ্হি মোচনং প্ৰাপ্তুং মা যতস্ৱ| কিং ৱা যোষিতো মুক্তোঽসি? তৰ্হি জাযাং মা গৱেষয| ");
INSERT INTO sanasm_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","ৱিৱাহং কুৰ্ৱ্ৱতা ৎৱযা কিমপি নাপাৰাধ্যতে তদ্ৱদ্ ৱ্যূহ্যমানযা যুৱত্যাপি কিমপি নাপৰাধ্যতে তথাচ তাদৃশৌ দ্ৱৌ জনৌ শাৰীৰিকং ক্লেশং লপ্স্যেতে কিন্তু যুষ্মান্ প্ৰতি মম কৰুণা ৱিদ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","হে ভ্ৰাতৰোঽহমিদং ব্ৰৱীমি, ইতঃ পৰং সমযোঽতীৱ সংক্ষিপ্তঃ, ");
INSERT INTO sanasm_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","অতঃ কৃতদাৰৈৰকৃতদাৰৈৰিৱ ৰুদদ্ভিশ্চাৰুদদ্ভিৰিৱ সানন্দৈশ্চ নিৰানন্দৈৰিৱ ক্ৰেতৃভিশ্চাভাগিভিৰিৱাচৰিতৱ্যং ");
INSERT INTO sanasm_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","যে চ সংসাৰে চৰন্তি তৈ ৰ্নাতিচৰিতৱ্যং যত ইহলেाকস্য কৌতুকো ৱিচলতি| ");
INSERT INTO sanasm_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","কিন্তু যূযং যন্নিশ্চিন্তা ভৱেতেতি মম ৱাঞ্ছা| অকৃতৱিৱাহো জনো যথা প্ৰভুং পৰিতোষযেৎ তথা প্ৰভুং চিন্তযতি, ");
INSERT INTO sanasm_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","কিন্তু কৃতৱিৱাহো জনো যথা ভাৰ্য্যাং পৰিতোষযেৎ তথা সংসাৰং চিন্তযতি| ");
INSERT INTO sanasm_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","তদ্ৱদ্ ঊঢযোষিতো ঽনূঢা ৱিশিষ্যতে| যানূঢা সা যথা কাযমনসোঃ পৱিত্ৰা ভৱেৎ তথা প্ৰভুং চিন্তযতি যা চোঢা সা যথা ভৰ্ত্তাৰং পৰিতোষযেৎ তথা সংসাৰং চিন্তযতি| ");
INSERT INTO sanasm_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","অহং যদ্ যুষ্মান্ মৃগবন্ধিন্যা পৰিক্ষিপেযং তদৰ্থং নহি কিন্তু যূযং যদনিন্দিতা ভূৎৱা প্ৰভোঃ সেৱনেঽবাধম্ আসক্তা ভৱেত তদৰ্থমেতানি সৰ্ৱ্ৱাণি যুষ্মাকং হিতায মযা কথ্যন্তে| ");
INSERT INTO sanasm_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","কস্যচিৎ কন্যাযাং যৌৱনপ্ৰাপ্তাযাং যদি স তস্যা অনূঢৎৱং নিন্দনীযং ৱিৱাহশ্চ সাধযিতৱ্য ইতি মন্যতে তৰ্হি যথাভিলাষং কৰোতু, এতেন কিমপি নাপৰাৎস্যতি ৱিৱাহঃ ক্ৰিযতাং| ");
INSERT INTO sanasm_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","কিন্তু দুঃখেনাক্লিষ্টঃ কশ্চিৎ পিতা যদি স্থিৰমনোগতঃ স্ৱমনোঽভিলাষসাধনে সমৰ্থশ্চ স্যাৎ মম কন্যা মযা ৰক্ষিতৱ্যেতি মনসি নিশ্চিনোতি চ তৰ্হি স ভদ্ৰং কৰ্ম্ম কৰোতি| ");
INSERT INTO sanasm_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","অতো যো ৱিৱাহং কৰোতি স ভদ্ৰং কৰ্ম্ম কৰোতি যশ্চ ৱিৱাহং ন কৰোতি স ভদ্ৰতৰং কৰ্ম্ম কৰোতি| ");
INSERT INTO sanasm_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","যাৱৎকালং পতি ৰ্জীৱতি তাৱদ্ ভাৰ্য্যা ৱ্যৱস্থযা নিবদ্ধা তিষ্ঠতি কিন্তু পত্যৌ মহানিদ্ৰাং গতে সা মুক্তীভূয যমভিলষতি তেন সহ তস্যা ৱিৱাহো ভৱিতুং শক্নোতি, কিন্ত্ৱেতৎ কেৱলং প্ৰভুভক্তানাং মধ্যে| ");
INSERT INTO sanasm_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","তথাচ সা যদি নিষ্পতিকা তিষ্ঠতি তৰ্হি তস্যাঃ ক্ষেমং ভৱিষ্যতীতি মম ভাৱঃ| অপৰম্ ঈশ্ৱৰস্যাত্মা মমাপ্যন্ত ৰ্ৱিদ্যত ইতি মযা বুধ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","দেৱপ্ৰসাদে সৰ্ৱ্ৱেষাম্ অস্মাকং জ্ঞানমাস্তে তদ্ৱযং ৱিদ্মঃ| তথাপি জ্ঞানং গৰ্ৱ্ৱং জনযতি কিন্তু প্ৰেমতো নিষ্ঠা জাযতে| ");
INSERT INTO sanasm_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","অতঃ কশ্চন যদি মন্যতে মম জ্ঞানমাস্ত ইতি তৰ্হি তেন যাদৃশং জ্ঞানং চেষ্টিতৱ্যং তাদৃশং কিমপি জ্ঞানমদ্যাপি ন লব্ধং| ");
INSERT INTO sanasm_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","কিন্তু য ঈশ্ৱৰে প্ৰীযতে স ঈশ্ৱৰেণাপি জ্ঞাযতে| ");
INSERT INTO sanasm_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","দেৱতাবলিপ্ৰসাদভক্ষণে ৱযমিদং ৱিদ্মো যৎ জগন্মধ্যে কোঽপি দেৱো ন ৱিদ্যতে, একশ্চেশ্ৱৰো দ্ৱিতীযো নাস্তীতি| ");
INSERT INTO sanasm_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","স্ৱৰ্গে পৃথিৱ্যাং ৱা যদ্যপি কেষুচিদ্ ঈশ্ৱৰ ইতি নামাৰোপ্যতে তাদৃশাশ্চ বহৱ ঈশ্ৱৰা বহৱশ্চ প্ৰভৱো ৱিদ্যন্তে ");
INSERT INTO sanasm_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","তথাপ্যস্মাকমদ্ৱিতীয ঈশ্ৱৰঃ স পিতা যস্মাৎ সৰ্ৱ্ৱেষাং যদৰ্থঞ্চাস্মাকং সৃষ্টি ৰ্জাতা, অস্মাকঞ্চাদ্ৱিতীযঃ প্ৰভুঃ স যীশুঃ খ্ৰীষ্টো যেন সৰ্ৱ্ৱৱস্তূনাং যেনাস্মাকমপি সৃষ্টিঃ কৃতা| ");
INSERT INTO sanasm_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","অধিকন্তু জ্ঞানং সৰ্ৱ্ৱেষাং নাস্তি যতঃ কেচিদদ্যাপি দেৱতাং সম্মন্য দেৱপ্ৰসাদমিৱ তদ্ ভক্ষ্যং ভুঞ্জতে তেন দুৰ্ব্বলতযা তেষাং স্ৱান্তানি মলীমসানি ভৱন্তি| ");
INSERT INTO sanasm_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","কিন্তু ভক্ষ্যদ্ৰৱ্যাদ্ ৱযম্ ঈশ্ৱৰেণ গ্ৰাহ্যা ভৱামস্তন্নহি যতো ভুঙ্ক্ত্ৱা ৱযমুৎকৃষ্টা ন ভৱামস্তদ্ৱদভুঙ্ক্ত্ৱাপ্যপকৃষ্টা ন ভৱামঃ| ");
INSERT INTO sanasm_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","অতো যুষ্মাকং যা ক্ষমতা সা দুৰ্ব্বলানাম্ উন্মাথস্ৱৰূপা যন্ন ভৱেৎ তদৰ্থং সাৱধানা ভৱত| ");
INSERT INTO sanasm_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","যতো জ্ঞানৱিশিষ্টস্ত্ৱং যদি দেৱালযে উপৱিষ্টঃ কেনাপি দৃশ্যসে তৰ্হি তস্য দুৰ্ব্বলস্য মনসি কিং প্ৰসাদভক্ষণ উৎসাহো ন জনিষ্যতে? ");
INSERT INTO sanasm_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","তথা সতি যস্য কৃতে খ্ৰীষ্টো মমাৰ তৱ স দুৰ্ব্বলো ভ্ৰাতা তৱ জ্ঞানাৎ কিং ন ৱিনংক্ষ্যতি? ");
INSERT INTO sanasm_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","ইত্যনেন প্ৰকাৰেণ ভ্ৰাতৃণাং ৱিৰুদ্ধম্ অপৰাধ্যদ্ভিস্তেষাং দুৰ্ব্বলানি মনাংসি ৱ্যাঘাতযদ্ভিশ্চ যুষ্মাভিঃ খ্ৰীষ্টস্য ৱৈপৰীত্যেনাপৰাধ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","অতো হেতোঃ পিশিতাশনং যদি মম ভ্ৰাতু ৰ্ৱিঘ্নস্ৱৰূপং ভৱেৎ তৰ্হ্যহং যৎ স্ৱভ্ৰাতু ৰ্ৱিঘ্নজনকো ন ভৱেযং তদৰ্থং যাৱজ্জীৱনং পিশিতং ন ভোক্ষ্যে| ");
INSERT INTO sanasm_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","অহং কিম্ একঃ প্ৰেৰিতো নাস্মি? কিমহং স্ৱতন্ত্ৰো নাস্মি? অস্মাকং প্ৰভু ৰ্যীশুঃ খ্ৰীষ্টঃ কিং মযা নাদৰ্শি? যূযমপি কিং প্ৰভুনা মদীযশ্ৰমফলস্ৱৰূপা ন ভৱথ? ");
INSERT INTO sanasm_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","অন্যলোকানাং কৃতে যদ্যপ্যহং প্ৰেৰিতো ন ভৱেযং তথাচ যুষ্মৎকৃতে প্ৰেৰিতোঽস্মি যতঃ প্ৰভুনা মম প্ৰেৰিতৎৱপদস্য মুদ্ৰাস্ৱৰূপা যূযমেৱাধ্ৱে| ");
INSERT INTO sanasm_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","যে লোকা মযি দোষমাৰোপযন্তি তান্ প্ৰতি মম প্ৰত্যুত্তৰমেতৎ| ");
INSERT INTO sanasm_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","ভোজনপানযোঃ কিমস্মাকং ক্ষমতা নাস্তি? ");
INSERT INTO sanasm_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","অন্যে প্ৰেৰিতাঃ প্ৰভো ৰ্ভ্ৰাতৰৌ কৈফাশ্চ যৎ কুৰ্ৱ্ৱন্তি তদ্ৱৎ কাঞ্চিৎ ধৰ্ম্মভগিনীং ৱ্যূহ্য তযা সাৰ্দ্ধং পৰ্য্যটিতুং ৱযং কিং ন শক্নুমঃ? ");
INSERT INTO sanasm_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","সাংসাৰিকশ্ৰমস্য পৰিত্যাগাৎ কিং কেৱলমহং বৰ্ণব্বাশ্চ নিৱাৰিতৌ? ");
INSERT INTO sanasm_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","নিজধনৱ্যযেন কঃ সংগ্ৰামং কৰোতি? কো ৱা দ্ৰাক্ষাক্ষেত্ৰং কৃৎৱা তৎফলানি ন ভুঙ্ক্তে? কো ৱা পশুৱ্ৰজং পালযন্ তৎপযো ন পিৱতি? ");
INSERT INTO sanasm_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","কিমহং কেৱলাং মানুষিকাং ৱাচং ৱদামি? ৱ্যৱস্থাযাং কিমেতাদৃশং ৱচনং ন ৱিদ্যতে? ");
INSERT INTO sanasm_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","মূসাৱ্যৱস্থাগ্ৰন্থে লিখিতমাস্তে, ৎৱং শস্যমৰ্দ্দকৱৃষস্যাস্যং ন ভংৎস্যসীতি| ঈশ্ৱৰেণ বলীৱৰ্দ্দানামেৱ চিন্তা কিং ক্ৰিযতে? ");
INSERT INTO sanasm_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","কিং ৱা সৰ্ৱ্ৱথাস্মাকং কৃতে তদ্ৱচনং তেনোক্তং? অস্মাকমেৱ কৃতে তল্লিখিতং| যঃ ক্ষেত্ৰং কৰ্ষতি তেন প্ৰত্যাশাযুক্তেন কৰ্ষ্টৱ্যং, যশ্চ শস্যানি মৰ্দ্দযতি তেন লাভপ্ৰত্যাশাযুক্তেন মৰ্দ্দিতৱ্যং| ");
INSERT INTO sanasm_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","যুষ্মৎকৃতেঽস্মাভিঃ পাৰত্ৰিকাণি বীজানি ৰোপিতানি, অতো যুষ্মাকমৈহিকফলানাং ৱযম্ অংশিনো ভৱিষ্যামঃ কিমেতৎ মহৎ কৰ্ম্ম? ");
INSERT INTO sanasm_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","যুষ্মাসু যোঽধিকাৰস্তস্য ভাগিনো যদ্যন্যে ভৱেযুস্তৰ্হ্যস্মাভিস্ততোঽধিকং কিং তস্য ভাগিভি ৰ্ন ভৱিতৱ্যং? অধিকন্তু ৱযং তেনাধিকাৰেণ ন ৱ্যৱহৃতৱন্তঃ কিন্তু খ্ৰীষ্টীযসুসংৱাদস্য কোঽপি ৱ্যাঘাতোঽস্মাভিৰ্যন্ন জাযেত তদৰ্থং সৰ্ৱ্ৱং সহামহে| ");
INSERT INTO sanasm_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","অপৰং যে পৱিত্ৰৱস্তূনাং পৰিচৰ্য্যাং কুৰ্ৱ্ৱন্তি তে পৱিত্ৰৱস্তুতো ভক্ষ্যাণি লভন্তে, যে চ ৱেদ্যাঃ পৰিচৰ্য্যাং কুৰ্ৱ্ৱন্তি তে ৱেদিস্থৱস্তূনাম্ অংশিনো ভৱন্ত্যেতদ্ যূযং কিং ন ৱিদ? ");
INSERT INTO sanasm_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","তদ্ৱদ্ যে সুসংৱাদং ঘোষযন্তি তৈঃ সুসংৱাদেন জীৱিতৱ্যমিতি প্ৰভুনাদিষ্টং| ");
INSERT INTO sanasm_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","অহমেতেষাং সৰ্ৱ্ৱেষাং কিমপি নাশ্ৰিতৱান্ মাং প্ৰতি তদনুসাৰাৎ আচৰিতৱ্যমিত্যাশযেনাপি পত্ৰমিদং মযা ন লিখ্যতে যতঃ কেনাপি জনেন মম যশসো মুধাকৰণাৎ মম মৰণং ৱৰং| ");
INSERT INTO sanasm_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","সুসংৱাদঘেষণাৎ মম যশো ন জাযতে যতস্তদ্ঘোষণং মমাৱশ্যকং যদ্যহং সুসংৱাদং ন ঘোষযেযং তৰ্হি মাং ধিক্| ");
INSERT INTO sanasm_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","ইচ্ছুকেন তৎ কুৰ্ৱ্ৱতা মযা ফলং লপ্স্যতে কিন্ত্ৱনিচ্ছুকেঽপি মযি তৎকৰ্ম্মণো ভাৰোঽৰ্পিতোঽস্তি| ");
INSERT INTO sanasm_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","এতেন মযা লভ্যং ফলং কিং? সুসংৱাদেন মম যোঽধিকাৰ আস্তে তং যদভদ্ৰভাৱেন নাচৰেযং তদৰ্থং সুসংৱাদঘোষণসমযে তস্য খ্ৰীষ্টীযসুসংৱাদস্য নিৰ্ৱ্যযীকৰণমেৱ মম ফলং| ");
INSERT INTO sanasm_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","সৰ্ৱ্ৱেষাম্ অনাযত্তোঽহং যদ্ ভূৰিশো লোকান্ প্ৰতিপদ্যে তদৰ্থং সৰ্ৱ্ৱেষাং দাসৎৱমঙ্গীকৃতৱান্| ");
INSERT INTO sanasm_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","যিহূদীযান্ যৎ প্ৰতিপদ্যে তদৰ্থং যিহূদীযানাং কৃতে যিহূদীযইৱাভৱং| যে চ ৱ্যৱস্থাযত্তাস্তান্ যৎ প্ৰতিপদ্যে তদৰ্থং ৱ্যৱস্থানাযত্তো যোঽহং সোঽহং ৱ্যৱস্থাযত্তানাং কৃতে ৱ্যৱস্থাযত্তইৱাভৱং| ");
INSERT INTO sanasm_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","যে চালব্ধৱ্যৱস্থাস্তান্ যৎ প্ৰতিপদ্যে তদৰ্থম্ ঈশ্ৱৰস্য সাক্ষাদ্ অলব্ধৱ্যৱস্থো ন ভূৎৱা খ্ৰীষ্টেন লব্ধৱ্যৱস্থো যোঽহং সোঽহম্ অলব্ধৱ্যৱস্থানাং কৃতেঽলব্ধৱ্যৱস্থ ইৱাভৱং| ");
INSERT INTO sanasm_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","দুৰ্ব্বলান্ যৎ প্ৰতিপদ্যে তদৰ্থমহং দুৰ্ব্বলানাং কৃতে দুৰ্ব্বলইৱাভৱং| ইত্থং কেনাপি প্ৰকাৰেণ কতিপযা লোকা যন্মযা পৰিত্ৰাণং প্ৰাপ্নুযুস্তদৰ্থং যো যাদৃশ আসীৎ তস্য কৃতে ঽহং তাদৃশইৱাভৱং| ");
INSERT INTO sanasm_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","ইদৃশ আচাৰঃ সুসংৱাদাৰ্থং মযা ক্ৰিযতে যতোঽহং তস্য ফলানাং সহভাগী ভৱিতুমিচ্ছামি| ");
INSERT INTO sanasm_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","পণ্যলাভাৰ্থং যে ধাৱন্তি ধাৱতাং তেষাং সৰ্ৱ্ৱেষাং কেৱল একঃ পণ্যং লভতে যুষ্মাভিঃ কিমেতন্ন জ্ঞাযতে? অতো যূযং যথা পণ্যং লপ্স্যধ্ৱে তথৈৱ ধাৱত| ");
INSERT INTO sanasm_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","মল্লা অপি সৰ্ৱ্ৱভোগে পৰিমিতভোগিনো ভৱন্তি তে তু ম্লানাং স্ৰজং লিপ্সন্তে কিন্তু ৱযম্ অম্লানাং লিপ্সামহে| ");
INSERT INTO sanasm_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","তস্মাদ্ অহমপি ধাৱামি কিন্তু লক্ষ্যমনুদ্দিশ্য ধাৱামি তন্নহি| অহং মল্লইৱ যুধ্যামি চ কিন্তু ছাযামাঘাতযন্নিৱ যুধ্যামি তন্নহি| ");
INSERT INTO sanasm_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","ইতৰান্ প্ৰতি সুসংৱাদং ঘোষযিৎৱাহং যৎ স্ৱযমগ্ৰাহ্যো ন ভৱামি তদৰ্থং দেহম্ আহন্মি ৱশীকুৰ্ৱ্ৱে চ| ");
INSERT INTO sanasm_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","হে ভ্ৰাতৰঃ, অস্মৎপিতৃপুৰুষানধি যূযং যদজ্ঞাতা ন তিষ্ঠতেতি মম ৱাঞ্ছা, তে সৰ্ৱ্ৱে মেঘাধঃস্থিতা বভূৱুঃ সৰ্ৱ্ৱে সমুদ্ৰমধ্যেন ৱৱ্ৰজুঃ, ");
INSERT INTO sanasm_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","সৰ্ৱ্ৱে মূসামুদ্দিশ্য মেঘসমুদ্ৰযো ৰ্মজ্জিতা বভূৱুঃ ");
INSERT INTO sanasm_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","সৰ্ৱ্ৱ একম্ আত্মিকং ভক্ষ্যং বুভুজিৰ একম্ আত্মিকং পেযং পপুশ্চ ");
INSERT INTO sanasm_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","যতস্তেঽনুচৰত আত্মিকাদ্ অচলাৎ লব্ধং তোযং পপুঃ সোঽচলঃ খ্ৰীষ্টএৱ| ");
INSERT INTO sanasm_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","তথা সত্যপি তেষাং মধ্যেঽধিকেষু লোকেষ্ৱীশ্ৱৰো ন সন্তুতোষেতি হেতোস্তে প্ৰন্তৰে নিপাতিতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","এতস্মিন্ তে ঽস্মাকং নিদৰ্শনস্ৱৰূপা বভূৱুঃ; অতস্তে যথা কুৎসিতাভিলাষিণো বভূৱুৰস্মাভিস্তথা কুৎসিতাভিলাষিভি ৰ্ন ভৱিতৱ্যং| ");
INSERT INTO sanasm_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","লিখিতমাস্তে, লোকা ভোক্তুং পাতুঞ্চোপৱিৱিশুস্ততঃ ক্ৰীডিতুমুত্থিতা ইতযনেন প্ৰকাৰেণ তেষাং কৈশ্চিদ্ যদ্ৱদ্ দেৱপূজা কৃতা যুষ্মাভিস্তদ্ৱৎ ন ক্ৰিযতাং| ");
INSERT INTO sanasm_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","অপৰং তেষাং কৈশ্চিদ্ যদ্ৱদ্ ৱ্যভিচাৰঃ কৃতস্তেন চৈকস্মিন্ দিনে ত্ৰযোৱিংশতিসহস্ৰাণি লোকা নিপাতিতাস্তদ্ৱদ্ অস্মাভি ৰ্ৱ্যভিচাৰো ন কৰ্ত্তৱ্যঃ| ");
INSERT INTO sanasm_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","তেষাং কেচিদ্ যদ্ৱৎ খ্ৰীষ্টং পৰীক্ষিতৱন্তস্তস্মাদ্ ভুজঙ্গৈ ৰ্নষ্টাশ্চ তদ্ৱদ্ অস্মাভিঃ খ্ৰীষ্টো ন পৰীক্ষিতৱ্যঃ| ");
INSERT INTO sanasm_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","তেষাং কেচিদ্ যথা ৱাক্কলহং কৃতৱন্তস্তৎকাৰণাৎ হন্ত্ৰা ৱিনাশিতাশ্চ যুষ্মাভিস্তদ্ৱদ্ ৱাক্কলহো ন ক্ৰিযতাং| ");
INSERT INTO sanasm_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","তান্ প্ৰতি যান্যেতানি জঘটিৰে তান্যস্মাকং নিদৰ্শনানি জগতঃ শেষযুগে ৱৰ্ত্তমানানাম্ অস্মাকং শিক্ষাৰ্থং লিখিতানি চ বভূৱুঃ| ");
INSERT INTO sanasm_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","অতএৱ যঃ কশ্চিদ্ সুস্থিৰংমন্যঃ স যন্ন পতেৎ তত্ৰ সাৱধানো ভৱতু| ");
INSERT INTO sanasm_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","মানুষিকপৰীক্ষাতিৰিক্তা কাপি পৰীক্ষা যুষ্মান্ নাক্ৰামৎ, ঈশ্ৱৰশ্চ ৱিশ্ৱাস্যঃ সোঽতিশক্ত্যাং পৰীক্ষাযাং পতনাৎ যুষ্মান্ ৰক্ষিষ্যতি, পৰীক্ষা চ যদ্ যুষ্মাভিঃ সোঢুং শক্যতে তদৰ্থং তযা সহ নিস্তাৰস্য পন্থানং নিৰূপযিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","হে প্ৰিযভ্ৰাতৰঃ, দেৱপূজাতো দূৰম্ অপসৰত| ");
INSERT INTO sanasm_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","অহং যুষ্মান্ ৱিজ্ঞান্ মৎৱা প্ৰভাষে মযা যৎ কথ্যতে তদ্ যুষ্মাভি ৰ্ৱিৱিচ্যতাং| ");
INSERT INTO sanasm_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","যদ্ ধন্যৱাদপাত্ৰম্ অস্মাভি ৰ্ধন্যং গদ্যতে তৎ কিং খ্ৰীষ্টস্য শোণিতস্য সহভাগিৎৱং নহি? যশ্চ পূপোঽস্মাভি ৰ্ভজ্যতে স কিং খ্ৰীষ্টস্য ৱপুষঃ সহভাগিৎৱং নহি? ");
INSERT INTO sanasm_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","ৱযং বহৱঃ সন্তোঽপ্যেকপূপস্ৱৰূপা একৱপুঃস্ৱৰূপাশ্চ ভৱামঃ, যতো ৱযং সৰ্ৱ্ৱ একপূপস্য সহভাগিনঃ| ");
INSERT INTO sanasm_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","যূযং শাৰীৰিকম্ ইস্ৰাযেলীযৱংশং নিৰীক্ষধ্ৱং| যে বলীনাং মাংসানি ভুঞ্জতে তে কিং যজ্ঞৱেদ্যাঃ সহভাগিনো ন ভৱন্তি? ");
INSERT INTO sanasm_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","ইত্যনেন মযা কিং কথ্যতে? দেৱতা ৱাস্তৱিকী দেৱতাযৈ বলিদানং ৱা ৱাস্তৱিকং কিং ভৱেৎ? ");
INSERT INTO sanasm_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","তন্নহি কিন্তু ভিন্নজাতিভি ৰ্যে বলযো দীযন্তে ত ঈশ্ৱৰায তন্নহি ভূতেভ্যএৱ দীযন্তে তস্মাদ্ যূযং যদ্ ভূতানাং সহভাগিনো ভৱথেত্যহং নাভিলষামি| ");
INSERT INTO sanasm_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","প্ৰভোঃ কংসেন ভূতানামপি কংসেন পানং যুষ্মাভিৰসাধ্যং; যূযং প্ৰভো ৰ্ভোজ্যস্য ভূতানামপি ভোজ্যস্য সহভাগিনো ভৱিতুং ন শক্নুথ| ");
INSERT INTO sanasm_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","ৱযং কিং প্ৰভুং স্পৰ্দ্ধিষ্যামহে? ৱযং কিং তস্মাদ্ বলৱন্তঃ? ");
INSERT INTO sanasm_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","মাং প্ৰতি সৰ্ৱ্ৱং কৰ্ম্মাপ্ৰতিষিদ্ধং কিন্তু ন সৰ্ৱ্ৱং হিতজনকং সৰ্ৱ্ৱম্ অপ্ৰতিষিদ্ধং কিন্তু ন সৰ্ৱ্ৱং নিষ্ঠাজনকং| ");
INSERT INTO sanasm_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","আত্মহিতঃ কেনাপি ন চেষ্টিতৱ্যঃ কিন্তু সৰ্ৱ্ৱৈঃ পৰহিতশ্চেষ্টিতৱ্যঃ| ");
INSERT INTO sanasm_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","আপণে যৎ ক্ৰয্যং তদ্ যুষ্মাভিঃ সংৱেদস্যাৰ্থং কিমপি ন পৃষ্ট্ৱা ভুজ্যতাং ");
INSERT INTO sanasm_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","যতঃ পৃথিৱী তন্মধ্যস্থঞ্চ সৰ্ৱ্ৱং পৰমেশ্ৱৰস্য| ");
INSERT INTO sanasm_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","অপৰম্ অৱিশ্ৱাসিলোকানাং কেনচিৎ নিমন্ত্ৰিতা যূযং যদি তত্ৰ জিগমিষথ তৰ্হি তেন যদ্ যদ্ উপস্থাপ্যতে তদ্ যুষ্মাভিঃ সংৱেদস্যাৰ্থং কিমপি ন পৃষ্ট্ৱা ভুজ্যতাং| ");
INSERT INTO sanasm_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","কিন্তু তত্ৰ যদি কশ্চিদ্ যুষ্মান্ ৱদেৎ ভক্ষ্যমেতদ্ দেৱতাযাঃ প্ৰসাদ ইতি তৰ্হি তস্য জ্ঞাপযিতুৰনুৰোধাৎ সংৱেদস্যাৰ্থঞ্চ তদ্ যুষ্মাভি ৰ্ন ভোক্তৱ্যং| পৃথিৱী তন্মধ্যস্থঞ্চ সৰ্ৱ্ৱং পৰমেশ্ৱৰস্য, ");
INSERT INTO sanasm_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","সত্যমেতৎ, কিন্তু মযা যঃ সংৱেদো নিৰ্দ্দিশ্যতে স তৱ নহি পৰস্যৈৱ| ");
INSERT INTO sanasm_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","অনুগ্ৰহপাত্ৰেণ মযা ধন্যৱাদং কৃৎৱা যদ্ ভুজ্যতে তৎকাৰণাদ্ অহং কুতো নিন্দিষ্যে? ");
INSERT INTO sanasm_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","তস্মাদ্ ভোজনং পানম্ অন্যদ্ৱা কৰ্ম্ম কুৰ্ৱ্ৱদ্ভি ৰ্যুষ্মাভিঃ সৰ্ৱ্ৱমেৱেশ্ৱৰস্য মহিম্নঃ প্ৰকাশাৰ্থং ক্ৰিযতাং| ");
INSERT INTO sanasm_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","যিহূদীযানাং ভিন্নজাতীযানাম্ ঈশ্ৱৰস্য সমাজস্য ৱা ৱিঘ্নজনকৈ ৰ্যুষ্মাভি ৰ্ন ভৱিতৱ্যং| ");
INSERT INTO sanasm_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","অহমপ্যাত্মহিতম্ অচেষ্টমানো বহূনাং পৰিত্ৰাণাৰ্থং তেষাং হিতং চেষ্টমানঃ সৰ্ৱ্ৱৱিষযে সৰ্ৱ্ৱেষাং তুষ্টিকৰো ভৱামীত্যনেনাহং যদ্ৱৎ খ্ৰীষ্টস্যানুগামী তদ্ৱদ্ যূযং মমানুগামিনো ভৱত| ");
INSERT INTO sanasm_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","হে ভ্ৰাতৰঃ, যূযং সৰ্ৱ্ৱস্মিন্ কাৰ্য্যে মাং স্মৰথ মযা চ যাদৃগুপদিষ্টাস্তাদৃগাচৰথৈতৎকাৰণাৎ মযা প্ৰশংসনীযা আধ্বে| ");
INSERT INTO sanasm_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","তথাপি মমৈষা ৱাঞ্ছা যদ্ যূযমিদম্ অৱগতা ভৱথ, ");
INSERT INTO sanasm_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","একৈকস্য পুৰুষস্যোত্তমাঙ্গস্ৱৰূপঃ খ্ৰীষ্টঃ, যোষিতশ্চোত্তমাঙ্গস্ৱৰূপঃ পুমান্, খ্ৰীষ্টস্য চোত্তমাঙ্গস্ৱৰূপ ঈশ্ৱৰঃ| ");
INSERT INTO sanasm_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","অপৰম্ আচ্ছাদিতোত্তমাঙ্গেন যেন পুংসা প্ৰাৰ্থনা ক্ৰিযত ঈশ্ৱৰীযৱাণী কথ্যতে ৱা তেন স্ৱীযোত্তমাঙ্গম্ অৱজ্ঞাযতে| ");
INSERT INTO sanasm_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","অনাচ্ছাদিতোত্তমাঙ্গযা যযা যোষিতা চ প্ৰাৰ্থনা ক্ৰিযত ঈশ্ৱৰীযৱাণী কথ্যতে ৱা তযাপি স্ৱীযোত্তমাঙ্গম্ অৱজ্ঞাযতে যতঃ সা মুণ্ডিতশিৰঃসদৃশা| ");
INSERT INTO sanasm_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","অনাচ্ছাদিতমস্তকা যা যোষিৎ তস্যাঃ শিৰঃ মুণ্ডনীযমেৱ কিন্তু যোষিতঃ কেশচ্ছেদনং শিৰোমুণ্ডনং ৱা যদি লজ্জাজনকং ভৱেৎ তৰ্হি তযা স্ৱশিৰ আচ্ছাদ্যতাং| ");
INSERT INTO sanasm_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","পুমান্ ঈশ্ৱৰস্য প্ৰতিমূৰ্ত্তিঃ প্ৰতিতেজঃস্ৱৰূপশ্চ তস্মাৎ তেন শিৰো নাচ্ছাদনীযং কিন্তু সীমন্তিনী পুংসঃ প্ৰতিবিম্বস্ৱৰূপা| ");
INSERT INTO sanasm_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","যতো যোষাতঃ পুমান্ নোদপাদি কিন্তু পুংসো যোষিদ্ উদপাদি| ");
INSERT INTO sanasm_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","অধিকন্তু যোষিতঃ কৃতে পুংসঃ সৃষ্টি ৰ্ন বভূৱ কিন্তু পুংসঃ কৃতে যোষিতঃ সৃষ্টি ৰ্বভূৱ| ");
INSERT INTO sanasm_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","ইতি হেতো ৰ্দূতানাম্ আদৰাদ্ যোষিতা শিৰস্যধীনতাসূচকম্ আৱৰণং ধৰ্ত্তৱ্যং| ");
INSERT INTO sanasm_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","তথাপি প্ৰভো ৰ্ৱিধিনা পুমাংসং ৱিনা যোষিন্ন জাযতে যোষিতঞ্চ ৱিনা পুমান্ ন জাযতে| ");
INSERT INTO sanasm_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","যতো যথা পুংসো যোষিদ্ উদপাদি তথা যোষিতঃ পুমান্ জাযতে, সৰ্ৱ্ৱৱস্তূনি চেশ্ৱৰাদ্ উৎপদ্যন্তে| ");
INSERT INTO sanasm_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","যুষ্মাভিৰেৱৈতদ্ ৱিৱিচ্যতাং, অনাৱৃতযা যোষিতা প্ৰাৰ্থনং কিং সুদৃশ্যং ভৱেৎ? ");
INSERT INTO sanasm_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","পুৰুষস্য দীৰ্ঘকেশৎৱং তস্য লজ্জাজনকং, কিন্তু যোষিতো দীৰ্ঘকেশৎৱং তস্যা গৌৰৱজনকং ");
INSERT INTO sanasm_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","যত আচ্ছাদনায তস্যৈ কেশা দত্তা ইতি কিং যুষ্মাভিঃ স্ৱভাৱতো ন শিক্ষ্যতে? ");
INSERT INTO sanasm_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","অত্ৰ যদি কশ্চিদ্ ৱিৱদিতুম্ ইচ্ছেৎ তৰ্হ্যস্মাকম্ ঈশ্ৱৰীযসমিতীনাঞ্চ তাদৃশী ৰীতি ৰ্ন ৱিদ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","যুষ্মাভি ৰ্ন ভদ্ৰায কিন্তু কুৎসিতায সমাগম্যতে তস্মাদ্ এতানি ভাষমাণেন মযা যূযং ন প্ৰশংসনীযাঃ| ");
INSERT INTO sanasm_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","প্ৰথমতঃ সমিতৌ সমাগতানাং যুষ্মাকং মধ্যে ভেদাঃ সন্তীতি ৱাৰ্ত্তা মযা শ্ৰূযতে তন্মধ্যে কিঞ্চিৎ সত্যং মন্যতে চ| ");
INSERT INTO sanasm_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","যতো হেতো ৰ্যুষ্মন্মধ্যে যে পৰীক্ষিতাস্তে যৎ প্ৰকাশ্যন্তে তদৰ্থং ভেদৈ ৰ্ভৱিতৱ্যমেৱ| ");
INSERT INTO sanasm_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","একত্ৰ সমাগতৈ ৰ্যুষ্মাভিঃ প্ৰভাৱং ভেाজ্যং ভুজ্যত ইতি নহি; ");
INSERT INTO sanasm_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","যতো ভোজনকালে যুষ্মাকমেকৈকেন স্ৱকীযং ভক্ষ্যং তূৰ্ণং গ্ৰস্যতে তস্মাদ্ একো জনো বুভুক্ষিতস্তিষ্ঠতি, অন্যশ্চ পৰিতৃপ্তো ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","ভোজনপানাৰ্থং যুষ্মাকং কিং ৱেশ্মানি ন সন্তি? যুষ্মাভি ৰ্ৱা কিম্ ঈশ্ৱৰস্য সমিতিং তুচ্ছীকৃত্য দীনা লোকা অৱজ্ঞাযন্তে? ইত্যনেন মযা কিং ৱক্তৱ্যং? যূযং কিং মযা প্ৰশংসনীযাঃ? এতস্মিন্ যূযং ন প্ৰশংসনীযাঃ| ");
INSERT INTO sanasm_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","প্ৰভুতো য উপদেশো মযা লব্ধো যুষ্মাসু সমৰ্পিতশ্চ স এষঃ| ");
INSERT INTO sanasm_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","পৰকৰসমৰ্পণক্ষপাযাং প্ৰভু ৰ্যীশুঃ পূপমাদাযেশ্ৱৰং ধন্যং ৱ্যাহৃত্য তং ভঙ্ক্ত্ৱা ভাষিতৱান্ যুষ্মাভিৰেতদ্ গৃহ্যতাং ভুজ্যতাঞ্চ তদ্ যুষ্মৎকৃতে ভগ্নং মম শৰীৰং; মম স্মৰণাৰ্থং যুষ্মাভিৰেতৎ ক্ৰিযতাং| ");
INSERT INTO sanasm_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","পুনশ্চ ভেজনাৎ পৰং তথৈৱ কংসম্ আদায তেনোক্তং কংসোঽযং মম শোণিতেন স্থাপিতো নূতননিযমঃ; যতিৱাৰং যুষ্মাভিৰেতৎ পীযতে ততিৱাৰং মম স্মৰণাৰ্থং পীযতাং| ");
INSERT INTO sanasm_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","যতিৱাৰং যুষ্মাভিৰেষ পূপো ভুজ্যতে ভাজনেনানেন পীযতে চ ততিৱাৰং প্ৰভোৰাগমনং যাৱৎ তস্য মৃত্যুঃ প্ৰকাশ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","অপৰঞ্চ যঃ কশ্চিদ্ অযোগ্যৎৱেন প্ৰভোৰিমং পূপম্ অশ্নাতি তস্যানেন ভাজনেন পিৱতি চ স প্ৰভোঃ কাযৰুধিৰযো ৰ্দণ্ডদাযী ভৱিষ্যতি| ");
INSERT INTO sanasm_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","তস্মাৎ মানৱেনাগ্ৰ আত্মান পৰীক্ষ্য পশ্চাদ্ এষ পূপো ভুজ্যতাং কংসেনানেন চ পীযতাং| ");
INSERT INTO sanasm_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","যেন চানৰ্হৎৱেন ভুজ্যতে পীযতে চ প্ৰভোঃ কাযম্ অৱিমৃশতা তেন দণ্ডপ্ৰাপ্তযে ভুজ্যতে পীযতে চ| ");
INSERT INTO sanasm_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","এতৎকাৰণাদ্ যুষ্মাকং ভূৰিশো লোকা দুৰ্ব্বলা ৰোগিণশ্চ সন্তি বহৱশ্চ মহানিদ্ৰাং গতাঃ| ");
INSERT INTO sanasm_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","অস্মাভি ৰ্যদ্যাত্মৱিচাৰোঽকাৰিষ্যত তৰ্হি দণ্ডো নালপ্স্যত; ");
INSERT INTO sanasm_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","কিন্তু যদাস্মাকং ৱিচাৰো ভৱতি তদা ৱযং জগতো জনৈঃ সমং যদ্ দণ্ডং ন লভামহে তদৰ্থং প্ৰভুনা শাস্তিং ভুংজ্মহে| ");
INSERT INTO sanasm_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","হে মম ভ্ৰাতৰঃ, ভোজনাৰ্থং মিলিতানাং যুষ্মাকম্ একেনেতৰোঽনুগৃহ্যতাং| ");
INSERT INTO sanasm_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","যশ্চ বুভুক্ষিতঃ স স্ৱগৃহে ভুঙ্ক্তাং| দণ্ডপ্ৰাপ্তযে যুষ্মাভি ৰ্ন সমাগম্যতাং| এতদ্ভিন্নং যদ্ আদেষ্টৱ্যং তদ্ যুষ্মৎসমীপাগমনকালে মযাদেক্ষ্যতে| ");
INSERT INTO sanasm_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","হে ভ্ৰাতৰঃ, যূযং যদ্ আত্মিকান্ দাযান্ অনৱগতাস্তিষ্ঠথ তদহং নাভিলষামি| ");
INSERT INTO sanasm_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","পূৰ্ৱ্ৱং ভিন্নজাতীযা যূযং যদ্ৱদ্ ৱিনীতাস্তদ্ৱদ্ অৱাক্প্ৰতিমানাম্ অনুগামিন আধ্বম্ ইতি জানীথ| ");
INSERT INTO sanasm_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","ইতি হেতোৰহং যুষ্মভ্যং নিৱেদযামি, ঈশ্ৱৰস্যাত্মনা ভাষমাণঃ কোঽপি যীশুং শপ্ত ইতি ন ৱ্যাহৰতি, পুনশ্চ পৱিত্ৰেণাত্মনা ৱিনীতং ৱিনান্যঃ কোঽপি যীশুং প্ৰভুৰিতি ৱ্যাহৰ্ত্তুং ন শক্নোতি| ");
INSERT INTO sanasm_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","দাযা বহুৱিধাঃ কিন্ত্ৱেক আত্মা ");
INSERT INTO sanasm_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","পৰিচৰ্য্যাশ্চ বহুৱিধাঃ কিন্ত্ৱেকঃ প্ৰভুঃ| ");
INSERT INTO sanasm_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","সাধনানি বহুৱিধানি কিন্তু সৰ্ৱ্ৱেষু সৰ্ৱ্ৱসাধক ঈশ্ৱৰ একঃ| ");
INSERT INTO sanasm_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","একৈকস্মৈ তস্যাত্মনো দৰ্শনং পৰহিতাৰ্থং দীযতে| ");
INSERT INTO sanasm_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","একস্মৈ তেনাত্মনা জ্ঞানৱাক্যং দীযতে, অন্যস্মৈ তেনৈৱাত্মনাদিষ্টং ৱিদ্যাৱাক্যম্, ");
INSERT INTO sanasm_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","অন্যস্মৈ তেনৈৱাত্মনা ৱিশ্ৱাসঃ, অন্যস্মৈ তেনৈৱাত্মনা স্ৱাস্থ্যদানশক্তিঃ, ");
INSERT INTO sanasm_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","অন্যস্মৈ দুঃসাধ্যসাধনশক্তিৰন্যস্মৈ চেশ্ৱৰীযাদেশঃ, অন্যস্মৈ চাতিমানুষিকস্যাদেশস্য ৱিচাৰসামৰ্থ্যম্, অন্যস্মৈ পৰভাষাভাষণশক্তিৰন্যস্মৈ চ ভাষাৰ্থভাষণসামৰ্যং দীযতে| ");
INSERT INTO sanasm_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","একেনাদ্ৱিতীযেনাত্মনা যথাভিলাষম্ একৈকস্মৈ জনাযৈকৈকং দানং ৱিতৰতা তানি সৰ্ৱ্ৱাণি সাধ্যন্তে| ");
INSERT INTO sanasm_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","দেহ একঃ সন্নপি যদ্ৱদ্ বহ্ৱঙ্গযুক্তো ভৱতি, তস্যৈকস্য ৱপুষো ঽঙ্গানাং বহুৎৱেন যদ্ৱদ্ একং ৱপু ৰ্ভৱতি, তদ্ৱৎ খ্ৰীষ্টঃ| ");
INSERT INTO sanasm_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","যতো হেতো ৰ্যিহূদিভিন্নজাতীযদাসস্ৱতন্ত্ৰা ৱযং সৰ্ৱ্ৱে মজ্জনেনৈকেনাত্মনৈকদেহীকৃতাঃ সৰ্ৱ্ৱে চৈকাত্মভুক্তা অভৱাম| ");
INSERT INTO sanasm_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","একেনাঙ্গেন ৱপু ৰ্ন ভৱতি কিন্তু বহুভিঃ| ");
INSERT INTO sanasm_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","তত্ৰ চৰণং যদি ৱদেৎ নাহং হস্তস্তস্মাৎ শৰীৰস্য ভাগো নাস্মীতি তৰ্হ্যনেন শৰীৰাৎ তস্য ৱিযোগো ন ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","শ্ৰোত্ৰং ৱা যদি ৱদেৎ নাহং নযনং তস্মাৎ শৰীৰস্যাংশো নাস্মীতি তৰ্হ্যনেন শৰীৰাৎ তস্য ৱিযোগো ন ভৱতি| ");
INSERT INTO sanasm_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","কৃৎস্নং শৰীৰং যদি দৰ্শনেন্দ্ৰিযং ভৱেৎ তৰ্হি শ্ৰৱণেন্দ্ৰিযং কুত্ৰ স্থাস্যতি? তৎ কৃৎস্নং যদি ৱা শ্ৰৱণেন্দ্ৰিযং ভৱেৎ তৰ্হি ঘ্ৰণেন্দ্ৰিযং কুত্ৰ স্থাস্যতি? ");
INSERT INTO sanasm_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","কিন্ত্ৱিদানীম্ ঈশ্ৱৰেণ যথাভিলষিতং তথৈৱাঙ্গপ্ৰত্যঙ্গানাম্ একৈকং শৰীৰে স্থাপিতং| ");
INSERT INTO sanasm_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","তৎ কৃৎস্নং যদ্যেকাঙ্গৰূপি ভৱেৎ তৰ্হি শৰীৰে কুত্ৰ স্থাস্যতি? ");
INSERT INTO sanasm_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","তস্মাদ্ অঙ্গানি বহূনি সন্তি শৰীৰং ৎৱেকমেৱ| ");
INSERT INTO sanasm_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","অতএৱ 