﻿USE sofia;
DROP TABLE IF EXISTS sofia.sabNT_vpl;
CREATE TABLE sabNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sabNT_vpl WRITE;
INSERT INTO sabNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Cha chada ai dege ulita Jesucristo giti, Jesucristo David oindalla, David kwian israelita enusulian unsuialin oña chugagwalla kweri, kaire Jesucristo kwian israelita enusulian unsuialin oña kada Abraham oindalla. Jesucristo enusulian unsuialin oña ulita kalla kle ai kare: ");
INSERT INTO sabNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham kirolla Isaac, Isaac kirolla Jacob, Jacob kirolla gdataboko giti gdaboke molen, ama gdaite kadakle Judá, ");
INSERT INTO sabNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá kirolla gdaboke Fares kaire Zara, Fares kaire Zara chebia kadakle Tamar, Fares kirolla Esrom, Esrom kirolla Aram, ");
INSERT INTO sabNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram kirolla Aminadab, Aminadab kirolla Naasón, Naasón kirolla Salmón, ");
INSERT INTO sabNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón kirolla Booz, Booz chebia kadakle Rahab, Booz kirolla Obed, Obed chebia kadakle Rut, Obed kirolla Isaí, ");
INSERT INTO sabNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí kirolla kwian chugagwalla kweri David, David kirolla Salomón, Salomón chebia mo jun ngeru Urías ole, gire David muinga e junnga Urías ngeru chagedu ama ole, David kirolla muinga e giti ama Salomón. ");
INSERT INTO sabNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón kirolla Roboam, Roboam kirolla Abías, Abías kirolla Asa, ");
INSERT INTO sabNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa kirolla Josafat, Josafat kirolla Joram, Joram kirolla Uzías, ");
INSERT INTO sabNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías kirolla Jotam, Jotam kirolla Acaz, Acaz kirolla Ezequías, ");
INSERT INTO sabNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías kirolla Manasés, Manasés kirolla Amón, Amón kirolla Josías, ");
INSERT INTO sabNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías kirolla tanre molen, ama gdaite kadakle Jeconías, Jeconías kaire Jeconías daballa ulita toidu suiale kwian israelita tanre dule skage nga Babiloniage. ");
INSERT INTO sabNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Jeconías kaire kwian israelita na tanre dule skage nga Babiloniage tane giti Jeconías kirolla Salatiel manadu, Salatiel kirolla Zorobabel, ");
INSERT INTO sabNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel kirolla Abiud, Abiud kirolla Eliaquim, Eliaquim kirolla Azor, ");
INSERT INTO sabNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor kirolla Sadoc, Sadoc kirolla Aquim, Aquim kirolla Eliud, ");
INSERT INTO sabNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud kirolla Eleazar, Eleazar kirolla Matán, Matán kirolla Jacob, ");
INSERT INTO sabNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob kirolla José, José María ñengulalla, María kirolla Jesu. Jesu amaña kada Cristo, Chube ama kagu kwian Chugagwallale. ");
INSERT INTO sabNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Abraham oindalla bitataboko giti bitabagage tangle gire David, David oindalla bitataboko giti bitabagage tangle gire kwian israelita tanre dule skage nga Babiloniage. Ne suiale kwian israelita tanre dule skage ama ulita oindalla bitataboko giti bitabagage tangle gire Jesucristo chku. ");
INSERT INTO sabNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesucristo bebi menga gire boidu ene: María Jesu chebia ama mo chuia tku mo jwen José ole, María bebi chage ule José ole mo ñengula kare gire María chegu gaba Chube Oña kiralla giti. ");
INSERT INTO sabNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Josége chku uñale María kle chage gaba agwa me José olia, José tañachugu María kle chage gaba onbre na ole malen José mo ta gbu me mo jwen María ole. José kwian no no, diali ama agenga no Chube takalin kare, José kwian ene malen ama me tadu agekalin me no María ole, José tañachugu mo tale gballa: “Cha mi mo jwen María ole agwa cha mi gerule kwian na ole boidu giti María ole, cha mi María gbe jiske kwian na ulita gwa giti, ma no cha chege kamne.” ");
INSERT INTO sabNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","José kledu tañachuge age ene gire lle boanga Chube alin nga ngaña giti gdaite chku gerule José ole José kle gbe gire, gerudu José ole gbire: “José, ba David oindalla, ba me kennga María gai mo muirallale. Chube Oña chku Maríadi malen María be kirogwa molen, Chube mo kiralla giti kirogwa e gbu Maríadige, kirogwa e Chube Kirolla. ");
INSERT INTO sabNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","María be kirogwa onbre molen ama ka be chege Jesu, ama be mo bitalla ulita jwen siere ji chugege age me no gdale, malen ama ka be chege ene Jesu.” Lle boanga Chube alin gerudu ene José ole gbire. ");
INSERT INTO sabNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ai boidu ulita Chube gerudu kare kwian Chube gerua ketanga unsuialin kada Isaías ole, Isaías Chube gerua degu unsuialin, chada e gerule: ");
INSERT INTO sabNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Muinga biale me chageba onbre ole, muinga ene be chege gaba ama be kirogwa molen, kirogwa ka be chege Emanuel.” Unsuialin Isaías Chube gerua degu ene. (Ka Emanuel e gerule: “Chube kle ule che ole.”) ");
INSERT INTO sabNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","José kledu gbe gire José chiu tachke gbeske, ama agedu ulita lle boanga Chube alin nga ngaña giti gerudu kare, José María gau mo muirallale, ");
INSERT INTO sabNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","agwa ama me toidu kwian onbre kle mo jwen kle toi kare ama María manadu sugekare moge ama me gbedu ule gire kirogwa chku María kote, José María kirolla e kimule ka gbu Jesu Chube gerudu kare. ");
INSERT INTO sabNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Herodes kwian chugagwalla rey nga Judeage suiale Jesu medunga chebia kote una Belénge nga Judeage. Gire kwian gweale geru jwannga beu ulita giti kle toi nga chui chie ngwange ngnagu jo kirogwa Jesu jinade nate, ama ulita jo chke una Jerusalénge chugagwalla rey Herodes kle ngwadi. ");
INSERT INTO sabNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Kwian e ulita geru kadu Herodege: —¿Nga bainige kwian israelita chugagwalla rey medunga? Cha ulita tendu beu gbaitedi nga ngaña giti, beu e me beu na ulita kare, beu e giti chku uñale cha ulitage kwian chugagwalla kweri medunga nga gwealege. Cha kle chage ama nate, ¿ama kle baini? Cha ta gwagekalin amadi, cha ama gakalin dage kwian chugagwallale kweri, cha ama olladakalin. ");
INSERT INTO sabNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kwian chugagwalla rey Herodes tañachugu tanre ta me no ole gerudre ama ole giti kwian chugagwalla jagere ñage chege kwian chugagwallale Herodes taneage, kaire kwian una Jerusalénmu ulita chegu tañachuge tanre gerudre giti. ");
INSERT INTO sabNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Herodes kwian gerunga Chube ole daba alin chugagwalla ulita kadu, kaire Herodes kwian daba tkanga tangle Moisés chadalla giti ulita kadu, Herodes kwian ene ulita kadu geru trage ama ole, Herodes geru kadu ama ulitage: —Sbali Chube gerudu ama be kwian jwannga siere kada Cristo kage kwian alin, ¿nga bainige Cristo be menga? ");
INSERT INTO sabNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Gire kwian gerunga Chube ole daba alin chugagwalla kaire kwian daba tkanga tangle Moisés chadalla giti, ama ulita jaindunga: —Cristo be menga una Belénge nga Judeage, kwian Chube gerua ketanga unsuialin kada Miqueas chada degu e giti, chada e gerule: ");
INSERT INTO sabNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Chube gerudu: ‘Una Belén nga Judeage, una e soli agwa me una ngwale. Una ege kwian gdaite be menga, ama be chege kwian israelita ulita Chugagwallale, malen una Belén una no ñanaske.’ Chube gerudu ene una Belén giti.” Miqueas Chube gerua degu ene unsuialin una Belén giti. ");
INSERT INTO sabNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Herodes kwian keruchugu gerule ene, gire Herodes kwian geru jwannga beu giti kadu gerule ama ole sugekare, Herodes geru kadu ama ulitage: —¿Chui minege ba gwagedu beu e gbaitedi? Cha takalin ba gerule trate cha ole beu medu ngaminegire bage. Geru jwannga beu giti gerudu trate Herodes ole beu gbaite giti, ");
INSERT INTO sabNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","gire Herodes ama ulita kagu una Belén ngnagu, Herodes gerudu: —Ba joge una Belénge, ba geru kade no no kwiange kirogwa onbre e giti. Kirogwa onbre be skwen bage, cha takalin ba chieni geru kirogwa giti jigeni chage, ene cha kaire ñage joge ama nate ama gai dage kwian chugagwallale kweri ama ollade mnalin. Herodes gerudu ene agwa ama me gerudu ta no giti, ama sodu, ama me kle tañachuge no ulia kirogwa giti ama kle gerule kare. ");
INSERT INTO sabNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Kwian geru jwannga beu giti ulita Herodes keruchugu gerule ene gire ama ulita jo chage dare beu gbaite nate, beu e ama jonlla du una Belén ngnagu, beu e jo chke jage ngaña kirogwa soli kledu ngwadi, gire nga sugadu noare ama ulitadi, ama ñadu kirogwa soli kledu ngwadi. ");
INSERT INTO sabNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ama ulita jo chke uge gwa gire ama tendu kirogwa onbre solidi, kirogwa kledu chebia María ole. Gire kwian geru jwannga beu giti ulita jongnagwa skutu dba kirogwa soli gai dage. Kwian e ulita nu chieba lle no no dbe gdege ketadale kirogwage, ama lle ñanaske kada oro kaire lle ñachke no kada incienso kaire lle ñachke no kada mirra jun gdege, ama lle e ulita ketu kirogwa solige. ");
INSERT INTO sabNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ngajrege kwian geru jwannga beu giti ulita gbedu gire Chube gbi gbu ama gwage, Chube gerudu ama ole gbire: “Ba me ñage jogeni naskuni Herodedi tangle ba chiu kare, ma no ba jogeni jon na kare.” Chube gerudu ene gbire gire kwian geru jwannga beu giti ulita jon na gau, joni mo jwiageni jon na kare. ");
INSERT INTO sabNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Kwian geru jwannga beu giti ulita joni gire lle boanga Chube alin nga ngaña giti gdaite chku gerule José ole gbire, gerudu: “¡Chkede bduge, kigede kirogwa ole chebia ole llagli, joga kige nga Egiptoge! Herodes be kwian kage kirogwa soli jinade nate aini gwadaleda, malen ba kigedale kirogwa ole Herodes ngeru. Ba chegedale llani nga Egiptoge, cha be geru kete bage gire ba ñage chieni nga aige.” ");
INSERT INTO sabNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Lle boanga Chube alin gerudu ene José ole gire José chiu tachke, blike José kirogwa soli kaire chebia gbu biale, gire ama ulita jo chage ngajrege jon joge nga Egipto ngnaguge. ");
INSERT INTO sabNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ama ulita jo chke nga Egiptoge, eni José chegu toi kirogwa ole kirogwa chebia ole gire chuia jo sbali Herodes jokeda. Ai ulita boidu ene kwian Chube gerua ketanga unsuialin kada Oseas Chube gerua degu kare, chada e gerule: “Chube gerudu: ‘Nga Egiptoge cha mo Kirolla kadu toi naskuni mo jwiage.’ ” Chube Oseas ta gbu chada dege ene unsuialin Jesu giti. ");
INSERT INTO sabNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Jesu kledu toi José ole chebia ole nga Egiptoge Herodes bebi jogeda gire, Herodege chku uñale kwian geru jwannga beu giti me agedu Herodes gerudu kare me chiuni geru jige Herodege kirogwa Jesu giti, gire Herodes skochiu tanre, ta skochie ene ole Herodes kirogwa soli onbre ulita chura gdaboke gwadbiguda gwanguda kirogwa onbre soli kle toi una Belénge kaire kirogwa onbre soli kle toi una Beléndi tangle, Herodes kirogwa onbre soli ene ulita chura gdaboke gwadbiguda gwanguda. Kwian geru jwannga beu giti geruba Herodes ole ama ulita tendu beu gbaitedi ngaminegire, e giti chku uñale Herodege kirogwa chura minege gwangeda, ene chke uñale trate Herodege ama kirogwa Jesu gwanguda kaire. ");
INSERT INTO sabNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Boidu kwian Chube gerua ketanga kada Jeremías Chube gerua degu unsuialin kare, chada e gerule muinga unsuialin kada Raquel giti, Raquel olidu ama kirolla jokeda giti, e kare kwian una Belénmu olidu ama kirolla soli guleda giti. Jeremías chada degu e giti, chada e gerule: ");
INSERT INTO sabNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Una Ramáge kwian gdaite olire tanre kweri, kwian e kerua sugedu kwian una Ramámu ulita ologe, kwian gdaite e muinga kada Raquel ama kledu olire mo kirolla nate. Raquel kirolla ulita jogebakeda malen Raquel kledu olire tanre, ama me kwian na chugu ngwadi ama ta gbe nga suga no ole.” Jeremías chada degu ene unsuialin. ");
INSERT INTO sabNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herodes jokeda gire lle boanga Chube alin nga ngaña giti gdaite chku gerule José ole gbire nga Egiptoge, gerudu: ");
INSERT INTO sabNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Ba chkedale bduge ba kirogwa kaire kirogwa chebia gbe biale, ba jogedaleni naskuni nga Judeage kwian israelita jwiage, kwian tadu kirogwa soli onbre gwakalinda ama jokeda, nege ba ñage jogeni mo jwiage.” ");
INSERT INTO sabNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Lle boanga Chube alin gerudu ene José ole, gire José chku bduge kirogwa soli kaire kirogwa soli chebia du naskuni nga Judeage. ");
INSERT INTO sabNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Chku uñale Josége kwian ka jwankle Arquelao chegu kwian chugagwallale mo ñenua Herodes taneage nga Judeage, malen José kendunga joge naskuni nga Judeage. Chube gbi gbu José gwage José ñage joge toi nga Galileage, ");
INSERT INTO sabNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","José jo toi una soli ka jwankle Nazarege nga Galileage. Ai ulita boidu ene kwian Chube gerua ketanga chada degu unsuialin kare Jesu giti, chada e gerule: “Cristo una Nazaremu.” ");
INSERT INTO sabNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Chura jo tangle sbali Jesu kledu toi una Nazarege, e suiage tangle Juan-Bautista chku Chube gerua trage kwian bai tendu ama ngwange ole nga gballage nga Judeage. ");
INSERT INTO sabNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Juan-Bautista gerudu kwian e ulita ole: “Ba mo ta blitadale Chube ole, ba age me no chuge ngwadi me chage age me no dare, ba Chube gerua gadale ulia. Chube be che Chugagwalla gbe age kwian ulita alin chuia kle kodige, ba mo ta gbadale biale ama gai ngwange no.” Juan-Bautista gerudu ene Jesu giti kwian ole. ");
INSERT INTO sabNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Kwian Chube gerua ketanga kada Isaías chada degu unsuialin Juan-Bautista giti, chada e gerule: “Nga gballage kwian gdaite kerua be suge kwian tanrege, ama be gerule: ‘Che Chugagwalla be chie, ba ulita kledale biale ama ngwange, ba mo ta gbadale biale trate no ama ngwange kwian jon lite trate biale chugagwalla ngwange kare.’ ” Isaías chada degu ene unsuialin. ");
INSERT INTO sabNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juan-Bautista suiage tangle boidu ene ulita Chube Isaías ta gbu chada dege kare. Juan-Bautista toidu nga gballage, bda ka jwankle camello boli dodaba ñometraleske Juan-Bautista mo ngama tku, kaire ama mo ñometralla mo bonga tangle luguda chbi kwara dodabale drega giti. Juan-Bautista sri kweri kweri gutu kaire ama likin jau. ");
INSERT INTO sabNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Juan-Bautista toidu ene kare nga gballage, nga ege kwian tanre diali kledu joge chke Juan-Bautistadi Juan-Bautista keruchuge gerule Chube gerua giti, kwian tanre una Jerusalénmu, kwian tanre nga Judeamu, kaire kwian tanre toinga kodi chi Jordánge, kwian tanre nga e ulitamu mo litu Juan-Bautistadi Juan-Bautista keruchuge gerule Chube gerua giti. ");
INSERT INTO sabNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Kwian e gweale mo ta blitu Chube ole, kwian ene ulita gerudu ai kare Chube ole kwian na ulita gwa giti: “Chube, cha agedu me no tanre ba dollale, cha me ta agekalin me no ene dare, nege cha ba gakalin ulia mo Chugagwallale.” Kwian mo ta gbu no ene Chube ole gire Juan-Bautista ama ñeu chiske gau ngaña chigage chi Jordánge kwian na ulita gwa giti. ");
INSERT INTO sabNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Juan-Bautista kledu kwian ñe chiske ene gire kwian fariseo ngle kaire kwian saduceo ngle chku Juan-Bautista kle ngwadi, ama ulita takalin Juan-Bautista ama ñe chiske, Juan-Bautista gerudu kwian ene ulita ole: —Ba ulita ta me no me no, diali ba ta agekalin me no Chube dollale. ¿Chema geru ketu bage ba mo ñeange chiske alin allabi me mo ta blite Chube ole, ene ba tien gitiru ji chugege ba agedu me no gdale? ");
INSERT INTO sabNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Me ene dale ba kle tañachuge kare, ba ta tienkalin gitiru ji chugege ba agedu me no gdale ba mo ta blitadale Chube ole mo ta gbe chage trate no Chube takalin kare, ene kwian gwage badi ulia ba mo ta blitu Chube ole. ");
INSERT INTO sabNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ba me ñage tañachuge mau giti: “Cha enusulian oña Abraham oindalla, malen Chube me ji gbe cha giti cha agedu me no gdale.” Ba me ñage tañachuge ene. Cha gerule ba ulita ole, ba me mo ta blite Chube ole ba me ña tien gitiru ji chugege ba agedu me no gdale. Ba Abraham oindalla, agwa ba me kle age Chube takalin kare. Chube takalin ama ñage ke blite Abraham oindallale gire ke e joge blitaba kwianle kwian e be age Chube takalin kare. ");
INSERT INTO sabNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ba me mo ta blite ulia, ba salengwli gli me no kare me gbachie no, gli ene alin gli mauña kle biale mochuga ole gli datagda, gli mauña be gli ene date guge ulita, ene kaire Chube kle biale ji gbe kwian me no giti bai kaire me mo ta blitakalin ulia Chube ole. ");
INSERT INTO sabNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ba mo ta blitadale Chube ole gire cha ñage ba ñe chiske Chube kalla giti. Cha ñage age ene ba alin, agwa kwian gdaite be chie cha nate ama ma kira molen chage, ama be ñage age ma no kwian alin chage. Ama be Chube Oña gbe kwian tale, ene diali kwian be chage Chube Oña ole, Chube Oña be kwian ta gbe age no diali Chube takalin kare. Cha ñage kwian ñe chiske alin agwa cha me ñage Chube Oña gbe kwian tale kwian ta blite age Chube takalin kare. Ulia kwian gdaite be chie cha nate ama ma no ma kweri no trate chage, cha me ñanaske ama chudaboangale ni ama zapatolla dbe ama alin. ");
INSERT INTO sabNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Kwian gdaite be chie cha nate kle biale kwian chage no Chube takalin kare jwen sugekare kwian me noge, kwian no be toi no Chube ole diali, agwa kwian me no be toi sugekare diali Chubege ji chuge chui tangle, kwian ni ñage joge siere ji chuge ege. E salengwli kwian kle trigo kwara batenga kare, trigo tagla no alin chege sugekare trigo kwara me noge, trigo tagla ogakle no agwa trigo kwara gugakle jitaske, malen cha gerule ba ulita ole, ba tienkalin gitiru ji chugege ba mo ta blitadale Chube ole —Juan-Bautista gerudu ene ulita kwian ole. ");
INSERT INTO sabNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jesu kle nga Galileage jo chi ka jwankle Jordánge Juan-Bautista kledu ngwadi mo ñeangale chiske Juan-Bautistage. ");
INSERT INTO sabNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Juan-Bautistage sugedu moge ama ma soli Jesuge, malen ama tañachugu ama me ñanaske Jesu ñeale chiske, Juan-Bautista gerudu Jesu ole: —Cha suge moge ma soli bage, ¿mineade ba chku mo ñeangale chiske chage? Cha me ñanaske ba ñe chiske, ma no ba cha ñeadale chiske. ");
INSERT INTO sabNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesu jaindunga: —Ba me tallade e giti, ba mo ta gbadale age cha alin cha ñe chiske, Chube takalin che age ene Chube gwa giti, ene Chubege suge che kle age no ama takalin kare. Jesu gerudu ene gire Juan-Bautista mo ta gbu age Jesu gerudu kare. ");
INSERT INTO sabNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Juan-Bautista Jesu ñeu chiske Jesu gau ngaña chigage, Jesu jo kedagu gire nga ngaña giti nga tigedunga, Jesu gwagedu nga ngaña ngnagu Chube Oñadi beusi kare chie gwadbiguda ama giti. ");
INSERT INTO sabNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Gire Chube gerudu nga ngaña giti Jesu giti, ama kerua sugedu nga dba ai giti, ama gerudu: “Ai cha Kirolla, cha no no ama ole, nga suga noare chadi ama giti.” Chube kerua sugedu ene gerule mo Kirolla Jesu giti. ");
INSERT INTO sabNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Boidu ene Jesu ole chi Jordánge gire Chube Oña Jesu ta gbu joge toi nga gballage, ene che dolla Satanás ñage mo chuge Jesu ole, Satanás tadu Jesu ta blitakalin age me no Chube dollale. ");
INSERT INTO sabNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Nga gballage Jesu toidu chagere chui cuarenta, chui e ulitage ngajudi ngajrege Jesu me blidu dale. Gire bdagli ama bli ole tanre. ");
INSERT INTO sabNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Uñadu Satanáge Jesu bli ole gire Satanás chku Jesudi mo chuge Jesu ole, Satanás gerudu Jesu ole: —Ba Chube Kirolla ulia ba ke ai blite bligdale mo alin ba gute. Ba ke blite bligdale ene be suge chage ulia ba Chube Kirolla. ");
INSERT INTO sabNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesu gerudu: —Cha mi age ba takalin kare, Chube gerua degaba unsuialin gerule: “Me bligda alin allabi giti kwian ñage toi, agwa kaire Chube gerua gai ulia giti kwian ñage toi no.” ");
INSERT INTO sabNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","6","Jesu gerudu ene gire Satanás jo Jesu dbe una no Chubenu kada Jerusalénge, jo chke llani gire ama Jesu du ngaña u jiri bdagli giti u gerungwa Chube ole giti, jo chke ngaña gire Satanás gerudu Jesu ole: —Ba Chube Kirolla ulia ba skwen dbige aini. Chube gerua degaba unsuialin gerule: “Chube be lle boanga mau alin nga ngaña giti kage ba alin, lle boanga Chube alin be ba manade. Lle boanga Chube alin be ba gai ngwange kote, ene ba me lentige, ni ba be sera lentige kege.” Chube gerua degaba unsuialin gerule ene malen ba ñage skwen dbige aini ba mi lentige dale. ");
INSERT INTO sabNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesu jaindunga Satanás kalen: —Cha mi age ba takalin kare, Chube gerua degaba unsuialin gerule: “Chube kwian ulita Chugagwalla, kwian me mo chugadale mo Chugagwalla Chube ole.” ");
INSERT INTO sabNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","9","Jesu gerudu ene Satanás ole gire Satanás Jesu du jwichuga kweri ngaña giti gire Satanás nga ulita nga dba ai giti kaitu Jesuge, Satanás gerudu: —¡Gwagede nga e ulita no nodi! Ba jongnagwa skute dba chadi cha gai dage gerule no cha giti gire cha be nga e no no ulita kete bage, ene ba ñage chege kwian nga ulitamu chugagwallale. ");
INSERT INTO sabNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Satanás gerudu ene ulita gire Jesu jaindunga Satanás kalen: —Cha mi age ba takalin kare, cha mi ba gai dage dale. ¡Joga siere chage Satanás! Chube gerua degaba unsuialin gerule: “Chube kwian ulita Chugagwalla, kwian ulita mo Chugagwalla Chube alin allabi gadale dage gerule no ama alin giti, kaire kwian ulita mo ta gbadale lle boi ama alin allabi.” ");
INSERT INTO sabNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Jesu gerudu ene gire Satanás jo siere Jesuge, lle boanga Chube alin nga ngaña giti tanre chku Jesudi Jesu chudaboi Jesu kira gbe. ");
INSERT INTO sabNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","13","Jesu kledu nga Judeage gire chku uñale amage Juan-Bautista tkere skage gire Jesu jo una Nazarege nga Galileage, agwa Jesu me chegu toi una Nazarege nge kare, ama jo toi una Capernaumge kodi chibita kagda giti, una Capernaum chege kodi nga kada Zabulónge kaire nga kada Neftalíge. ");
INSERT INTO sabNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jesu jo toi una ege, ene Jesu giti kwian ulita nga emu geru no ulia Chube giti keruchugu, boidu ene kwian Chube gerua ketanga dabage kada Isaías Chube gerua degu unsuialin kare, chada e gerule: ");
INSERT INTO sabNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Nga Zabulón kaire nga Neftalí kle chege nga Galileage chi kada Jordán kagda giti kodi chibitage, ne ngwadi kwian tanre me israelita kle toi. ");
INSERT INTO sabNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Kwian ulita kledu toi nga ne ngwadige me Chube uñu ama ulita kledu toi nga jereske kare, kaire ama ulita kledu toi ta kennga jogeda, kwian ene ulita alin kwian jwannga siere ji chugege age me no gdale chiu, kwian jwannga siere e giti kwian nga ege Chube uñu, ene kwian me chage dare nge kare nga jereske kare. Kwian jwannga siere kwian ene ta gbu suge Chube giti salengwli chui chra kle kwian gbe ten kare.” Isaías chada degu ene unsuialin Jesu giti. ");
INSERT INTO sabNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Jesu jo toi una Capernaumge, chui ege gwangerudba Jesu chagedu gerule kwian ulita ole: “Ba mo ta blitadale Chube ole, ba age me no chuge ngwadi me chage age me no dare. Chube cha kagu ba jwen siere ji chugege ba agedu me no gdale, cha kle aini ba ulitaske, ba mo ta gbadale cha gerua gai ulia.” Jesu chagedu geru e kete ene kwian ulitage. ");
INSERT INTO sabNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesu jo chage chibita kada Galilea kagdage, ne ngwadi Jesu gwagedu kwian onbre gdabokedi, gdaite Simón amaña kada Pedro, kaire Simón daballa kada Andrés. Kwian boke e ngwe jwannga ama kledu gdeba tke chiske ngwe gai gdebage, ");
INSERT INTO sabNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","gire Jesucristo gerudu ama ole: —Bai chage cha ole geru jwen chage, nege ba kwian ngwe jwannga, agwa chui negege gwangerugu cha be ba gbe kwian na tke tangle cha gerua giti, ene ba giti kwian ngle be cha gerua gai ulia. ");
INSERT INTO sabNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Jesu gerudu ene Simón ole Andrés ole gire sugeti ama gdabonate gdeba chugu ngwadi, jo chage Jesu ole. ");
INSERT INTO sabNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jesu jo chage gwangerugu ule Simón ole Andrés ole gire Jesu gwagedu kwian onbre na gdabokedi, gdaite ka jwankle Santiago kaire ama daballa Juan, ama ñenua kadakle Zebedeo. Santiago kaire Juan kledu ñenua ole du toli gdeba ugachuge, gire Jesu gerudu ama ole: —Bai chage cha ole geru jwen chage. ");
INSERT INTO sabNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Jesu gerudu ene gire blikare Santiago kaire Juan mo ñenua chugu ngwadi du toli, jo chage Jesu ole. ");
INSERT INTO sabNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesu jo chage una kaire kairege nga ulita Galileage ule geru jwannga amage ulita ole, una gdaite gdaitege Jesu kwian tku tangle u mo litangwa Chube gerua jwanngwage. Jesu chagedu gerule kwian ulita ole kwian ñage Chube uñe, kwian mo ta blitadale Chube ole Chube gai mo Chugagwallale, ene Chube be kwian e jwen siere ji chugege agedu me no gdale. Kaire agwe Jesu kwian jingmere dodadu kaire kwian oga lle na tanre kote Jesu ama ulita dodadu. ");
INSERT INTO sabNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Jesu kledu chage age ene nga ulita Galileage gire geru Jesu giti jo chke nga na kada Siriage, nga ulita Siriage geru Jesu giti chageduda kwian ulitaske Jesu kwian oga dodanga, malen kwian ngle nga Siriage oga jingme tanre kote dbachku Jesudi, kwian e gweale skibachie tanre, kwian na jwligebanga che dolla kote, kwian na gweale oga jingme tirare ole kwian e oga jwligebanga kare, kwian na gweale skliebadba trate jegwale, Jesu kwian oga ene ulita dodadu kwian chegu no trate. ");
INSERT INTO sabNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kwian tanre nga Galileamu, kaire kwian tanre una ulitamu nga Decápolige, kaire kwian tanre una Jerusalénmu, kaire kwian tanre nga Judeamu, kaire kwian tanre kle toi chui chie ngwange chi Jordánge kagda ongoru giti, kwian ene ulita chagedu Jesu nate baini kaire Jesu jo ngwadi. ");
INSERT INTO sabNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jesu gwagedu kwian tanredi chage ama nate gire ama jo jwichuga giti ngaña. Ne ngwadi Jesu toidu dba gire kwian geru jwannga Jesuge ulita mo litu Jesudi. ");
INSERT INTO sabNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Jesu kwian geru jwannga tku tangle tanre kwian Chubenu toidale mine, Jesu gerudu: ");
INSERT INTO sabNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Cha gerule ba ulita ole, ba cha keruchuge no no. Kwian baige kaire suge ama agenga me no Chube gwa giti kaire suge amage Chube alin allabi ñage ama ta blite age no trate Chube takalin kare, kwian enege suge Chube ama Chugagwalla, Chube kle diali ama ole, malen nga suga noare kwian enedi mo tale. ");
INSERT INTO sabNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Kwian bai kaire ta olire tanre, suge amage Chube kle ama chudaboi kle ama kira gbe, malen kwian enedi nga suga noare mo tale. ");
INSERT INTO sabNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Kwian bai kaire me kle mo sobade dabadi dale, me kle tañachuge mau alin giti allabi, kwian ege suge chui be chke gire Chube be chege kwian ulita Chugagwallale, ne suiale nga dba ai giti be chege kwian e kote kwian e be chege toi no, malen kwian enedi nga suga noare mo tale. ");
INSERT INTO sabNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Kwian bai kaire ta agekalin diali no trate ulita Chube takalin kare, kwian ege suge Chube be age no ama alin, Chube be ama chudaboi age no Chube takalin kare, malen kwian enedi nga suga noare mo tale. ");
INSERT INTO sabNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Kwian bai kaire tai dage daba nage, kwian ege suge Chube be tai dage kaire agwe amage, malen kwian enedi nga suga noare mo tale. ");
INSERT INTO sabNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Kwian bai kaire ta no trate kle mo ta gbe tañachuge no Chube takalin kare, kwian ege suge bdagli ama be toi diali Chube ole nga ngaña giti, malen kwian enedi nga suga noare mo tale. ");
INSERT INTO sabNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Kwian bai kaire daba jwen siere kira batege daba ta gbe toi no daba na ole ule, kwian ege suge Chube kle ama gai mo kirogwallale, malen kwian enedi nga suga noare mo tale. ");
INSERT INTO sabNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Kwian bai kaire kle age no Chube takalin kare gire daba na kle ama gbe boi daga ngwale Chube gerua gdale, kwian ege suge ama Chubenu Chube ama Chugagwallale, Chube kle diali ama ole ama chudaboi ama kle boi daga ngwaleske, malen kwian enedi nga suga noare mo tale. ");
INSERT INTO sabNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","12","’Kwian kidere badi, kwian age me no ba ole kwian geru jinade ngle ngwale badi, kwian age me no ene ulita ba ole cha gdale, suge bage chui be chke gire Chube be lle noare kete bage nga ngaña giti Chube ngwadi ba mo ta gbu me joge siere cha geruage boi daga ngwaleske ñanale, suge bage Chube be age ene ba alin bdagli, malen nga suga noare badi mo tale. Kwian age me no ba ole cha gdale ba me tallade, ma no ba mo ta gbadale nga suga no ole diali, kwian kle age me no ba ole nege, ene kaire unsuialin tangle kwian Chube gerua ketanga ulita bole daga ngwale Chube gerua gdale. ");
INSERT INTO sabNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jesu gerudu dare kwian geru jwannga amage ulita ole: —Cho mana noare agwa cho joge skeke gire cho ene me ñage jwliteni naskuni bale gutadale. Cho sketigeda me no, kwian cho ene mlienga goga tangle, kwian chage cho e giti ama me tallade, cho e ngwale. Ene kaire ba me toi no daba gwa giti Chube takalin kare, Chube be ba gbe ji chuge, ene ba be chege salengwli kwian kle cho sketigeda mlienga kare. Ba toidale no kwian ulita gwa giti Chube takalin kare, ene Chube ñage ba gbe lle boi ama alin nga dba ai giti Chube takalin kare. ");
INSERT INTO sabNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Che jichra gwadege nga jereske ene che ñage ten no trate. Ba ulita cha gerua gaba ulia ba jichra gwadegaba kare kwian me Chube uñeske, kwian ene kle chage nga jereske kare. Kwian ene gwage badi ba kle chage no, ene chke uñale amage Chube ba ta blitu toi ene Chube takalin kare. E salengwli una gbaba jwichuga ngaña giti kare, una e kare me kle ogaba skwlenre kwian gwage, kwian ulita ñage gwage no trate una enedi. Ene kaire ba cha gerua gaba me ñage mo ogeda cha gerua ole, ma no ba ulita toidale no kwian me Chube uñeske, ene ama ñage gwage trate badi ñage cha gerua keruchuge ba giti. ");
INSERT INTO sabNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kaire kwian jichra gwadege me kle jichra gbe sugekare baini kwian me tendi, me kle un blite kaboge jichra giti, agwa ama jichra gbe ngaña nga ngwale giti, ene jichra chra tien no gwa tangle. ");
INSERT INTO sabNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ene kaire ba ulita mo ta gbadale toi kwian ulitaske jichra gbaba nga ngwale giti kare, ba agedale no trate Chube takalin kare kwian ulita gwa giti, ene kwian be gwage badi be suge trate kwiange Chube kle ba ta gbe age no trate ene, e giti kwian be gerule Chube nga ngaña giti ole: “Chube, ba no ulia, ba kle age no kwian e alin.” ");
INSERT INTO sabNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Jesu gerudu dare: —Cha me chiu gerule ba ole ba me agedale dare Moisés nu Chube gerua degaba unsuialin kle gerule kare, ni cha chiu gerule ba ole kwian Chube gerua ketanga dabage unsuialin geru amanu ngwale. Cha chiu ba ulita tke tangle no trate geru amaña giti Moisés chada degu kare kaire kwian Chube gerua ketanga chada degu kare, cha chiu geru e ulita trennga bage. ");
INSERT INTO sabNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Cha gerule ulia ba ole, ba cha keruchuge no, Chube gerua ulita Moisés nu degaba unsuialin jo gbaba kwian alin, ulita be boi ulia ulia geru e kle degaba kare nga dba ai giti nga ngaña giti ulita bebi joge tangle gire. ");
INSERT INTO sabNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Moisés nu Chube gerua degaba, geru e ulita no be chege gbaba diali kwian ulita alin malen kwian bai me kle Moisés chadalla ulita gai ulia me kle age chada e gerule kare kaire kle daba na tke tangle Moisés chadalla ulita chada ngwale kwian me agedale chada kle degaba kare, kwian ulita bai kle age ene ama me Chubenu ama mi toi Chube ole nga ngaña giti. Agwa kwian bai kle Moisés chadalla ulita gai ulia kle age chada e gerule kare kaire kle daba na tke tangle geru e giti geru e no daba agedale ulita chada e gerule kare, kwian ulita bai kle age ene ama Chubenu ama be toi Chube ole nga ngaña giti. ");
INSERT INTO sabNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ba kle tañachuge kwian fariseo ulita kaire kwian daba tkanga tangle Moisés chadalla giti ulita kle age no trate ulita Chube gerudu kare Moisés giti, agwa ama me kle age ene dale. Cha gerule ba ole, ba me mo ta gbe toi ama kle toi kare, ba mo ta gbadale age Chube gerua degaba gerule kare ma no trate kwian fariseoge kaire kwian daba tkanga tangle Moisés chadalla gitige, ene ba be ñage toi Chube ole nga ngaña giti. ");
INSERT INTO sabNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Jesu gerudu dare: —Moisés Chube gerua degu unsuialin tangle, ba ulita nege tangle kle geru e keruchuge gerule: “Me mo gweda, kwian bai kaire daba na gweda kwian e ji chugale tanre daba gweda gdale.” Nege ba kle mo ta gbe age daba ole geru e kle degaba kare. ");
INSERT INTO sabNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Agwa cha gerule ulia ba ulita ole, kwian bai kaire skochie alin dabadi, Chube gwa giti e salengwli kwian daba gweda kare, kwian ene ji chugadale tanre daba gdale salengwli kwian daba gwangada ji chugadale kare. Kaire kwian bai kaire ka boi mno daba ole ta skochie ole, kwian ene dbabe ji chugale kwian israelita chugagwalla kweri ulita ngwadi gerube kwian ene ole ama jiske. Kaire kwian bai ka boi obere daba ole ta skochie ole kwian na gwa giti, kwian ene boidale daga ngwale nga dbigu giti jitaske. Kwian ulita bai age me no ene daba na ole ta skochie ole, Chube gwa giti e salengwli ama daba gweda kare malen ama ji chugale e giti. ");
INSERT INTO sabNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","’Ba lle gweale dbe Chube alin u gerungwa Chube olege ba agedu me no ñanale gire ba tachke ba kle ta me no dbe daba gweale ole kaire daba ta me no dbe ba ole, ba kle lle dbe ketadale Chubege ba lle e jige eni gire ba jogedale geru trage trate daba ole ta no giti ba mo ta gbe no daba ole. Ba ta chegeni no daba ole gire ba ñage jogeni naskuni u gerungwa Chube olege, ba ñage lle kete Chube alin ta no giti. ");
INSERT INTO sabNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Kwian na ba gbe jiske ba agedu gweale giti, ama ba dbe chugagwalla ngwadi ba gbale jiske chugagwallage, kwian age ene ba ole ma no jonkare ba mo ta gbadale no kwian ba dbanga ole, ba gerule no ama ole: “Cha me ta jogekalin chugagwalla ngwadi, ma no cha alin cha agedu me no che chege e trage modi ta no giti aini jonkare, gire ene ulita ñage chege no trate ba tale kaire cha tale, ene ba me cha gbe jiske chugagwallage.” Ba gerule ene ba dbanga ole jonkare, gire kwian ba dbanga me ba dbe chugagwalla ngwadi, ene chugagwalla me ba kete guardia dongage tkale skage. ");
INSERT INTO sabNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Cha gerule ulia ba ole, guardia donga ba tke skage ba mi ñage joge siere ne ngwadige blike, ngeru ba igi ulita ba agedu me no ñanalla ketale mo giti gire ene ba ñage skachienga. E kare ene ba me ta chegekalin me no jiske Chube gwa giti, ba me ta dbe skochie daba na ole age me no daba ole. ");
INSERT INTO sabNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Jesu gerudu dare: —Moisés Chube gerua degu unsuialin tangle, ba ulita nege tangle kle geru e keruchuge gerule: “Onbre mo jwanba me mo chugale ke giti muinga na ole, muinga mo jwanba me mo chugale ke giti onbre na ole.” Nege ba kle mo ta gbe age ene geru e kle degaba kare. ");
INSERT INTO sabNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Agwa cha gerule ulia ba ulita ole, kwian onbre bai kaire gwage muingadi gire tañachuge mo tale me no muinga e nate: “Cha takalin muinga ege mo alin”, onbre tañachuge alin ene muinga nate, Chube gwa giti e salengwli onbre kle mo chuge ke giti muinga e ole kare. ");
INSERT INTO sabNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Ba gwage lle gwealedi mo gwagwa giti gire gwage edi giti ba ta agekalin gweale me no, ba me mo chuge ngwadi gwage lle edi dare tañachuge lle e giti dare, ma no ba mo linge siere lle ege. Ba agedale salengwli ba gwagwa gbaite jo jwanba siere mliabanga kare ene ba me ñage gwage dare lle edi ba takalin kare. Ma no toi gwagwa gbaitre alin ole toi gwagwa gbabonate no olege ji chuge tirare ngwadi boi daga ngwale jitaske ba agedu me no Chube dollale ñanale. ");
INSERT INTO sabNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kaire ba ta agekalin gweale me no mo ko taingwli giti ba mo ta gbadale me tañachuge age me no ene kare ko e giti, ba age me no ene talla chuge ngwadi, e salengwli ba mo ko tkenga kare, ene ba me age me no dare mo ko giti kare. Ma no toi ko gdaitre alin ole me toi ko gdabonate no ole gire ji chuge tirare ngwadi boi daga ngwale jitaske ba agedu me no Chube dollale ñanale. Ba mo ta gbadale diali age no Chube takalin kare me tañachuge age me no giti dare, ma no lle ulita kle ba gbe age me no ba joge siere lle ege. ");
INSERT INTO sabNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Jesu gerudu dare: —Moisés Chube gerua degu unsuialin tangle, ba ulita nege tangle kle geru e keruchuge gerule: “Kwian onbre ta mo muiralla chugakalin ngwadi, onbre e chada degadale kete mo muirallage, chada e gerule muinga e me amanu dare, onbre age ene gire onbre ñage mo muiralla chuge ngwadi.” Nege ba kle mo ta gbe age ene geru e kle degaba kare. ");
INSERT INTO sabNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Agwa cha gerule ulia ba ulita ole, muinga kle toi no diali mo ñengulalla ole me kle gbe onbre na ole, muinga e ñengulalla ama chuge ngwadi, gire muinga e mo jwen kwian onbre na ole kwian onbre ngeru kle muinga gbe jiske Chube gwa giti, Chube gwa giti e salengwli muinga e kle mo chuge ke giti onbre na ole kare. Kaire kwian onbre mo jwen muinga onbre na nu chugaba ngwadi ole, onbre e kle age me no Chube gwa giti, Chube gwa giti e salengwli onbre e kle mo chuge ke giti muinga na ole kare. ");
INSERT INTO sabNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Jesu gerudu dare kwian geru jwannga ulita ole: —Moisés Chube gerua degu unsuialin tangle, ba ulita nege tangle kle geru e keruchuge gerule: “Ba gerule Chube gwa giti ba be age gweale ulia ulia, ba me ñage gerule alin allabi, ba agedale ulia ba gerudu kare Chube gwa giti.” Moisés Chube gerua gbu ene unsuialin kwian israelita ulita alin. ");
INSERT INTO sabNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Nege kaire cha gerule e giti ba ulita ole, ba ulita agedale ulia diali ba gerule kare me gerule lle gweale kalla giti ba be age gweale ulia ulia gire me tallade ba age o me age. Me gerule daba na ole nga ngaña kalla giti ba be age gweale ulia ulia, nga ngaña giti Chube kle toi nga ege. ");
INSERT INTO sabNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Kaire me gerule daba na ole nga dba ai kalla giti ba be age gweale ulia ulia, nga dba ai ulita Chubenu kaire, Chube nga dba ai ulita mauña. Kaire me gerule daba na ole una Jerusalén kalla giti ba be age gweale ulia ulia, una Jerusalén Chube che Chugagwalla kwerinu, Chube no una e ole. ");
INSERT INTO sabNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kaire me gerule daba na ole mo chugaga kalla giti ba be age gweale ulia ulia, ba me ñage mo chugaga jere blite chugaga jutredi kaire ba me ñage chugaga jutre blite chugaga jeredi, Chube alin allabi ñage age ene ulita. ");
INSERT INTO sabNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ngwale ba gerule daba na ole lle gweale kalla giti o nga gweale kalla giti ba be age gweale ulia ulia, e me no Chube gwa giti. Ma no ba gerule trate alin daba na ole ba be age gweale ulia ulia gire ba mo ta gbadale age ulia ba gerudu kare. Ba gerule trate alin daba na ole ba mi age gweale ulia ulia gire ba mo ta gbadale me age. Cha gerule ba ole, ba ulita mo ta gbadale age ulia diali ba gerule kare, ba me age ene ba kle sole, che dolla Satanás kle ba ta gbe gerule ngwale daba na ole. ");
INSERT INTO sabNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Jesu gerudu dare: —Moisés Chube gerua degu unsuialin tangle, ba ulita nege tangle kle geru e keruchuge gerule: “Kwian mo bate daba ole daba gwagwa jwennga, kaire agwe gwangoguda mo jia gbadale daba gwagwa jwanlenga. Kaire agwe kwian kira bate daba ole daba dau skutenga, kaire agwe gwangoguda mo jia gbadale daba dau skutalenga. Kwian kle daba gbe boi daga ngwale kaire kwian e boidale daga ngwale salengwli daba kare.” Moisés geru jigu degaba gerule ene, nege ba kle mo ta gbe age ene geru e kle degaba kare, ");
INSERT INTO sabNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","agwa cha gerule ulia ba ulita ole, me kira bate kwian ole kwian bai kaire kle age me no ba ole, ba tañachugadale ama giti ta no ole. Kaire agwe kwian ba bate gwage ba gwa ongoru kaitadale amage batadale, ba me age ama ole ama kle age ba ole kare. ");
INSERT INTO sabNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kaire agwe kwian ta ba dbakalin gbale jiske kwian chugagwalla gwa giti ama ta ba ñometralla gweale badige jwankalinnga dbadale, ba mo ñometralla e chuge ngwadi amage ama jwennga badige, kaire kwian ene ole ba gerudale: “Ba takalin cha llea na gweale dbe kaire ba ñage dbe.” ");
INSERT INTO sabNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kaire kwian ta me no ba ole gerule ba ole: “Ba cha terua dbe sugeti alin allabi.” Kwian gerule ene bage, ba me ama terua dbe sugeti alin allabi, ba ama terua dbale dare ta no giti ma bate ama gerudu bage kare. ");
INSERT INTO sabNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kwian gweale lle banu kade bage mo alin, ba lle e ketadale amage ta no ole, kaire kwian na gweale lle banu kade sugetidale bage mo alin, ba mo ta gbe no ama ole, ba lle ketadale amage ama lle kadu bage kare, ba me mo ta dbe kibale ba lleage kwian ole. ");
INSERT INTO sabNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Kwian daba tkanga tangle Moisés chadalla giti kle ba ulita tke tangle geru giti, ba ulita kle geru e keruchuge gerule ene: “Ba mo ta dbadale no ba skatemanalla ole, agwa ba me mo ta dbadale no kwian ba dolla ole.” Nege ba kle mo ta gbe age daba ole geru e kle degaba kare. ");
INSERT INTO sabNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Agwa cha gerule ba ole, ba mo ta dbadale no ba dolla ole kaire. Kwian kle ba oña boi me no, kwian ene ole ba gerudale: “Cha takalin Chube age no ba alin.” Kwian kle jainchke badi, kwian ene alin ba agedale no. Kwian kle ba ta gbe olire kle gerule me no badi kle kira bate ba ole, kwian ene giti ba gerudale Chube ole. ");
INSERT INTO sabNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ba mo ta dbe ene ba dolla ole, ene ba kle age ba Ñenua Chube takalin kare, ulia ba Chube kirolla Chube jian. Chube kle age no kwian ulita alin, Chube kle chuira gbe kwian ulita alin kwian ta no alin kaire kwian ta me no alin. Chube kle noi kage kwian ulita alin kwian ta no alin kaire kwian ta me no alin, ene chude kle tige no kwian ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ba mo ta dbadale no ba dolla ole kaire ba skatemanalla ole. Ba no kwian ba skatemanalla ole alin allabi, ¿Chube be age mine no ba alin e ñanale? Chube mi age no ba alin dale e ñanale, kwian ulita no mo skatemanalla ole. Kaire kwian igi ganga chugagwalla emperador nga Romamu alin ama no mo skatemanalla ole, ba gwa giti ama kwian me no me no, agwa diali ama no mo skatemanalla ole, kwian bai no ama ole, kwian ene ole alin ama no. Ba me mo ta dbe no kwian ulita ole ba kle age salengwli kwian igi ganga kare. ");
INSERT INTO sabNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kaire agwe ba kle gbi kade mo skatemanallage alin allabi, ba kle age salengwli kwian ulita kle age kare, kwian me Chube uñe kle age ene kaire. ");
INSERT INTO sabNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ba mo ta dbadale no kwian ulita ole kwian bai no ba ole kaire kwian bai me no ba ole, kwian e ulita ole ba mo ta dbadale no diali. Ba agedale no ulita Chube kle age kare, Chube no kwian ulita ole, kaire ba nodale kwian ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jesu gerudu dare kwian ole: —Ba age no kwian gweale alin kwian na gwa giti, ba gerule mau giti: “Cha agedu no daba e alin.” Ba age ene, ba takalin kwian ulita gwage badi gerule no ba giti: “Ama no, ama kle age no daba na alin.” Ba age daba na alin ta ene kare ole, Chube mi age no ba alin ba agedu no daba alin ñanale. ");
INSERT INTO sabNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Malen cha gerule ba ole, ba daba me lle molen chudaboi, ba me ñage gerule kwian na ole: “Cha daba me lle molen chudabo no.” Me no age ene kwian na tanre kle age kare. Kwian bai kle daba me lle molen chudaboi lle gweale giti gire kle gerule e giti kwian na tanre ole u mo litangwa Chube gerua jwanngwage kaire kle gerule kwian na tanre ole bai kaire ten jonkare gire gerule: “Cha daba me lle molen chudabo no, cha lle ketu amage ama chudaboagda.” Kwian e kle lle kete nobi daba me lle molenge agwa me kle kete ta no giti, ama kle age mo sobadagda kwian na gwa giti. Ama kle age ene, gire ene kwian na ñage gerule ama giti ama daba chudaboanga ama kwian no, gire ulia ama ta me no kwiandi. Ba me age ama kle age kare. Ba daba chudaboi kwian ulita gwa giti takalin kwian ulita gerule no ba giti age ene ñanale, ba age daba alin ta ene kare ole Chube mi gerule no ba ole ba agedu giti mi age no ba alin ba agedu no daba alin ñanale. ");
INSERT INTO sabNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ba daba me lle molen chudaboi, ma no ba me gerudale ni kwian gdaite ole ba agedu no daba alin giti. ");
INSERT INTO sabNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ba alin allabi tañachugadale ba agedu giti, noare ba daba chudaboi kwian na ulita gwa skwlenre, ene Chube kle gwage badi ba kle age mine daba alin, ene Chube be gerule ba ole: “Ba agedu no daba alin.” Chube be gerule ene ba ole be age no ba alin ba agedu no daba alin ñanale. ");
INSERT INTO sabNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jesu gerudu dare kwian ole: —Ba gerule Chube ole gire me no age kwian na tanre kle age kare kle mo gbe gerule Chube ole kwian ulita gwa giti agwa ama ta kle bate Chubege. Ba gerule Chube ole gire ba me age ama kle age kare. Ama kle gerule Chube ole jagebanga gdate kwian ngle gwa giti u mo litangwa Chube gerua jwanngwage kaire kle gerule Chube ole jonkare kwian ngleske. Ene ama takalin kwian gwage amadi kaire gerule no ama giti. Ba me age ama kle age kare. Kwian gwage amadi ama takalin kare kwian gerule ama giti: “Kwian e ulia gerunga no Chube ole.” Kwian gerule ene ama giti gire Chube be gerule ama giti: “Kwian e me kle age no, ama kle age ngwale ulita.” Chube be gerule ene ama giti, Chube mi age no ama alin. ");
INSERT INTO sabNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ba gerule Chube ole gire, ba jogedale nga sugekarege kwian me ñage gwage badi ngwadi, ene ba ñage mo ta gbe ulia gerule Chube ole, Chube kle ba ole alin allabi gwakabongwadi. Ene Chube che Ñenua gwage badi, uñale amage ba ta mine ama ole, ama ba keruchuge, ba kle age ama takalin kare ñanale ama be age no ba alin ba kle kade kare amage. ");
INSERT INTO sabNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Ba gerule Chube ole gire ba me geru ngwale alin jwen kate ngle kwian me Chube uñe kle age kare. Kwian e kle tañachuge kwian gerudale tanre tanre Chube ole gire Chube ñage ama keruchuge ñage age kwian takalin kare. ");
INSERT INTO sabNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ba me age kwian e kare. Chubege uñale trate llema llema ba takalinge, ngerutabi amage uñale llema ba ta kadakalin amage. ");
INSERT INTO sabNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ba gerule Chube ole ba gerudale ene: “Cha Ñenua, ba kle nga ngaña giti, ba no trate ulita, cha takalin kwian ulita gerule no ba giti. ");
INSERT INTO sabNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Cha takalin kwian ulita nga ulitage ba gai mo Chugagwallale. Cha takalin ba age mo ta giti ba ta agekalin kare nga dba ai giti salengwli ba kle age nga ngaña giti kare. ");
INSERT INTO sabNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Cha takalin ba bligda kete chage gutadale chui gdale toigda. ");
INSERT INTO sabNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Cha agedu me no cha takalin ba talla mlienga, ene kaire daba age me no cha ole cha talla mlienga. ");
INSERT INTO sabNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ba me cha chuge ngwadi che dollage, ene ama me ñage age me no cha ole. Ba cha jwen siere lle me no ulitage. Uñale chage ba kwian ulita Chugagwalla ma kweri, ba kiraske ba ñage age ulita mo kiralla giti, ba no no, ba ene diali chui tangle. Cha gerule ene ulita ba ole cha Ñenua. Ene nobi.” Ba ulita gerudale ene Chube ole. ");
INSERT INTO sabNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Kaire cha gerule ba ole, kwian agedu me no ba ole ba talla me no mlienga ama agedu me no ba ole giti, ba me tañachuge dare ama agedu me no ba ole giti. Ba age ene talla mlienga daba na agedu me no ba ole giti, ene kaire Chube be talla mlienga ba agedu me no giti, ama mi tañachuge dare ba agedu me no giti. ");
INSERT INTO sabNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Agwa ba me talla me no mlienga kwian agedu ba ole giti ene kaire agwe Chube mi talla mlienga ba agedu me no giti. ");
INSERT INTO sabNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Jesu gerudu dare kwian ole: —Ba chui gbaite gai mo tke bage bligdage gerudale Chube ole alin allabi, ba kle age ene gire ba me mo gwa gbale olire kwian na tanre kle age kare. Kwian ene kle bage bligdage gerudale Chube ole agwa ama me kle mo ta gbe no ulia Chube ole, ama me kle tañachuge Chube giti ama kle tañachuge mau alin giti, ama takalin daba na gwage amadi ama kwian no Chube gwa giti malen ama mo gwa gbale olire daba na gwa giti, ene chke uñale daba nage ama kle bli ole bage bligdage gdale, ene daba na gwage amadi tai dage amage gerule no ama giti: “Kwian e no Chube ole, ama kle mo tke bage bligdage Chube gwa giti malen Chube be age no ama alin.” Kwian na be gerule ene kwian kle bage takalin kare, agwa cha gerule ba ulita ole, kwian bai kle mo tke bage bligdage ene kwian ulita gwa giti takalin kwian ulita gerule no ama giti age ene ñanale, kwian ene giti Chube mi gerule no mi age no ama alin ama mo tku bage bligdage ñanale. ");
INSERT INTO sabNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Ba mo tke bage bligdage Chube gwa giti gerudale ama ole ma no ba age kwian na gwa skwlenre, ba mo dodadale trate diali kare me mo gwa gbe olire, ene kwian na gwage badi me chke uñale amage ba kle mo tke bage bligdage Chube gwa giti, ene kwian na me gerule no ba giti ba kle bage bligdage gire. Agwa Chubege alin allabi be chke uñale, Chube ba Ñenua, diali ama kle gwage ba kle age ulitadi, ba age Chube takalin kare ñanale Chube be gerule no ba giti be age no ba alin. ");
INSERT INTO sabNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Jesu gerudu dare kwian ole: —Ba me mo ta gbe tañachuge lle oge mau alin nga dba ai giti diali chui tangle, chui gweale lle e ulita be jogenga ngwale, chubdu kle lle gute kwian ngeru, lle kle joge me no sugaska, kaire kwian skwe boanga kle skwe boi kle lle dbe kwian ngeru, malen ngwale ba tañachuge lle tanre lite ole mau alin nga dba ai giti. ");
INSERT INTO sabNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ma no ba tañachuge Chube giti, ba age ulita nga dba ai giti Chube takalin kare gire Chube be lle no oge nga ngaña giti ba alin ba age no ñanale. Ba joge toi ama ole nga ngaña giti chuia chke, chui ege Chube be age no no ba alin be lle no e kete bage ba agedu no nga dba ai giti ama takalin kare ñanale. Nga ngaña giti lle ketabe bage mi jogenga ngwale dale, chubdu me lle gute ba ngeru, lle me joge me no sugaska, ni kwian skwe boanga kle nga ngaña giti, lle ulita be chege no trate diali dale alin. ");
INSERT INTO sabNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ba mo ta gbe lle lite ole tanre mau alin nga dba ai giti, ba be kle tañachuge diali lle nga dba ai giti alinge, ba be ta jogenga tañachuge Chube giti. Agwa ba mo ta gbe diali tachke Chube giti age ama takalin kare nga dba ai giti, ba ta be kle ule diali Chube ole nga ngaña giti tañachuge Chube giti alin allabi. ");
INSERT INTO sabNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Jesu gerudu: —Ba gwagwa kle ba gbe ten, ba gwagwa kle no me oga, ene ba ñage ten no trate ulita. Ene kaire kwian bai kle chage no trate Chube takalin kare ama kwian gwagwa no kare chage nga chra no giti. ");
INSERT INTO sabNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Agwa ba gwagwa oga ba me ñage ten no trate, ba kle chage nga jereske. Ene kaire kwian bai me kle chage trate Chube geruadi kle chage age me no diali ama kwian gwagwa me no kare chage nga jereske, ama ñage boi tirare nga jereske, kwian ene kare kle chage sugekare Chubege age tanre me no, ni suge amage Chube takalin ama toi mine no trate Chube gwa giti, ulia kwian ene kle chage nga jereske. ");
INSERT INTO sabNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Jesu gerudu: —Ni kwian gdaite ñage lle boi no chugagwalla gdaboke alin. Kwian mo ta gbe lle boi no chugagwalla gdaite alin, kwian me ñage lle boi no chugagwalla na alin kaire. Kwian lle boi chugagwalla gdaboke alin gire kwian mo ta dbe no chugagwalla gdaitre alin ole, chugagwalla na ole ama me mo ta dbe no dale, ama be jainchke chugagwalla edi. Ene kaire ba mo ta gbadale tañachuge lle boi no Chube alin me tañachuge diali igi gai giti lle lite ole ngle mau alin giti, ma no ba mo ta gbe tañachuge Chube giti alin allabi toi ama takalin kare. Ba mo ta dbe no igi alin ole ba me ñage mo ta dbe no Chube ole, ma no tañachuge Chube alin giti, me tañachuge lle boke giti ule. ");
INSERT INTO sabNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Cha gerule ba ole, ba me mo ta dbe tañachuge tanre diali lle toigda alin giti, ba be llema gute ba be llema jai toigda chui bdugu, llema giti ba be mo ngama tke. Noare ba bligda molen gutadale, noare ba chi molen jadale, noare ba ñometra molen mo ngama tkagda, agwa me no tañachuge tanre diali bligda alin giti chi alin giti ñometra alin giti mo alin toigda. Chube ba dodadu ama ba gbu toi gwade, ene kaire Chube be lle ulita kete bage toigda, malen ma no ba mo ta gbe tañachuge diali Chube giti me lle alin allabi giti toigda no nga dba ai giti. ");
INSERT INTO sabNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ba ulita tachkedale bdada giti, bdada me kle chude ngama gbe, me kle chude tke, me kle bligda lite ole ogadale, me kle lle boi dale agwa kle toi no, ba Ñenua Chube kle ama manade, Chube kle bligda kete bdadage gutadale. Chube alin ba ma ñanaske bdadage, bdada me ñanaske ba kare Chube gwa giti agwa Chube kle ama manade no, ene kaire bage sugedale Chube be ba manade no diali. ");
INSERT INTO sabNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ngwale ba tañachuge tanre lle ulita giti mo alin toigda, tañachuge tanre ene kare giti ba me ñage chui na dare gai mo alin toingwa, chui be chke ba alin jogeda gire ba be jogeda diali. Ngwale ba tañachuge tanre lle toigda giti, Chube kle ba manade. ");
INSERT INTO sabNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿Mineade ba kle mo ta gbe tañachuge tanre ñometra giti mo ngama tkagda? Ba ulita tachkedale glijra giti, che gwage glijradi glijra noare, diali glijra meñe no, e Chube kle gbe ene, glijra me lle boi dale, meñe no alin allabi. ");
INSERT INTO sabNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Cha gerule ba ole, kwian chugagwalla unsuialin kada Salomón, ama kwian kweri, ama mo ngama tku ñometra noareske, agwa glijra ma noare Salomón ñometrallage. ");
INSERT INTO sabNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Chube glijra gbe tige no, nege glijra kle no, suialin gire glijra kwenga. Glijra me ñanaske ba kare Chube gwa giti agwa Chube kle glijra gbe skiennga no, Chube gwa giti ba ñanaske tanre ama be ba manade no diali, lle gweale me ba ole toigda Chube be lle e kete bage. Ba me kle Chube gai ulia Chube ñage ba manade no, ba mo ta gbadale me tañachuge ene dare, ulia Chube be ba manade no diali, ba ama gadale ulia. ");
INSERT INTO sabNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ba Chube uñe malen ba me mo ta dbadale olire lle toigda nate, ba be llema gute, ba be llema jai, llema giti ba be mo ngama tke. ");
INSERT INTO sabNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kwian me Chube uñe ulita diali kle mo ta dbe olire lle toigda nate. Agwa ba Chubenu, Chube ba Ñenua nga ngaña giti, amage uñale ba takalin llemage ene ba toi no nga dba ai giti. ");
INSERT INTO sabNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ba mo ta gbadale Chube gai ma no diali mo Chugagwallale, ba ama gadale dage, ba mo ta gbadale age no trate ama takalin kare diali, ene Chube be ba manade no be lle toigda kete bage lle bai me ba ole ene ba toi no nga dba ai giti. ");
INSERT INTO sabNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Malen ba me tañachugadale tanre ba be toi llema giti suialindale, suialin chui be kle tañachugangwa, ba me tañachuge nege be boi gweale suialin giti, ba me chegedale tañachuge tanre e giti Chube be ba manade be ba chudaboi be boi gweale giti ba ole. ");
INSERT INTO sabNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Jesu gerudu dare kwian ulita ole: —Me no mo ta dbe tañachuge ba alin allabi kle age no Chube gwa giti gerule daba nadi daba me no Chube gwa giti, ba gerule me no dabadi ene, Chube be ba gbe jiske gerule ene dabadi gdale. ");
INSERT INTO sabNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ba gerule daba nadi daba me no Chube gwa giti, Chube be gwage me no badi kaire agwe, gire Chube be age ba ole ba kle age daba na ole kare. Ba gerule me no tanre dabadi, Chube be ji gbe ba giti tanre, kaire ba gerule me no sidri dabadi Chube be ji gbe ba giti sidri. Ba age batre daba na ole Chube be age ene batre kaire ba ole. ");
INSERT INTO sabNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","4","¿Mineade ba kle tañachuge diali daba na kle age me no giti? Diali ba kle gerule me no dabadi daba gbale jiske daba kle age me no giti agwa ni ba kle tañachuge sidri ba agali kle age ma me no dabage giti. E salengwli ba kle gwage ngajwna daba gwagwagedi kare, ba ta ngajwna e jwankalinnga daba gwagwage, agwa ngajwna ma kweri kle mo gwagwage. Bage me suge ngajwna kweri kle ba gwagwage, ngwale ba gerule daba ole: “Daba, cha chugene ngajwna soli jwennga ba gwagwage.” ");
INSERT INTO sabNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ngeru ba ngajwna kweri jwandalenga mo gwagwage mo gwagwa jige trate, ene ba ñage daba chudaboi ngajwna soli jwennga ama gwagwage. E salengwli kwian kle gerule dabadi age me no sidri giti, me suge mau tale ama kle age ma me no dabage. Ama takalin daba na ulita tañachuge ama giti ama no ulita agwa gire ama ulia ta me no. Cha gerule ba ulita ole, ma no ba mo ta gbe tañachuge ba kle age me no giti ngeru me tañachuge daba na kle age me no giti, ba mo ta gbadale trate biale gire ba ñage daba na ta gbe ama kle age giti ba ñage ama chudaboi. ");
INSERT INTO sabNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Kaire cha gerule ba ole Chube gerua kete kwian nage giti. Ba me kle samla bita ma no kete toge. Ba samla e kete toge to be srechie samla nadi gire be ba gute samla gdale. Kaire chunchi, ba me kle lle ñanaske igigwa kare mlienga ngwale dba chunchige, chunchi be skite giti igigwa be jwatenga ulita chunchi me igigwa gai dage dale. E kare ene ba Chube gerua kete kwian me Chube uñege, kwian e me ta geru e keruchugakalin me geru e gai dage gire ba me Chube gerua trage dare ama ole. ");
INSERT INTO sabNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Jesu gerudu dare kwian ole: —Ba lle kade diali Chubege, e salengwli kwian kle lle kade dabage diali kare gire lle ketakle amage, e salengwli kwian kle lle jinade nate diali kare gire lle kle skwen amage, e salengwli kwian kle ugaka dagenga kare ta jogekalin gwa daba ullage gire daba kle ugaka degenga ama alin jogedale gwa. ");
INSERT INTO sabNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kwian ulita bai kaire lle kade diali, kwian enege lle keta. Kwian bai kaire lle jinade nate diali, kwian enege lle skwen. Kwian bai kaire ugaka dagenga diali, kwian ene alin ugaka tigenga. Ene kaire ba lle kade Chubege, Chube be ba keruchuge Chube be age ba alin. ");
INSERT INTO sabNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ba ulita gweale kirogwa molen, kirogwa pan kade bage, ¿gire ba be ke kete amage gutadale? Me dale, ba mi mo ta gbe ke kete kirogwage gutale, diali ba lle no ketakalin kirogwa banuge. ");
INSERT INTO sabNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ba kirogwalla ngwe kade bage gutale, ¿gire ba be jorisi kete amage gutadale? Me dale, ba mi mo ta gbe age ene mo kirogwalla ole. ");
INSERT INTO sabNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ba ulita talla agenga me no, agwa gire ba me lle me no kete ba kirogwallage, ba kle mo ta gbe age no mo kirogwalla alin, ba lle no ketakalin diali ba kirogwallage. Chube ba Ñenua kle nga ngaña giti, ama no trate ulita, ama ñage age ma no ulita ba alin ba kle age ba kirogwalla alinge, ama lle ma no kete bage, ama ta agekalin no no ba alin diali, ba bai lle kade Chubege Chube lle no kete bage. ");
INSERT INTO sabNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Ba takalin kwian na ulita age ba alin, kaire ene ba mo ta gbadale age ene kwian na ulita alin. Moisés nu Chube gerua degaba unsuialin kaire kwian Chube gerua ketanga ulita nu Chube gerua degaba unsuialin, geru e ulita gerule kwian ulita agedale no ene daba alin. ");
INSERT INTO sabNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Jesu gerudu dare: —Ba ulita mo ta gbale joge tangle gereka ugakalla ka ulege chage jon soli jegwale kare. Joge Chube ngwadi salengwli joge tangle gereka ugakalla ka ulege kare. Kwian Chube gerua gai ulia ama ñage joge jon e kare, ene bdagli kwian ene ñage joge toi Chube ole nga ngaña giti diali chui tangle. Agwa mnoare kwian alin Chube gerua gai ulia toi Chube takalin kare nga dba ai giti malen kwian bedre alin Chube gerua gai ulia. Kwian tanre me Chube gerua gai ulia, ama ulita kle toi nga dba ai giti age ulita ama agali ta agekalin kare, e salengwli kwian joge tangle gereka ugakalla kwerige chage jon kweri jegwale kare, kwian ene kle chage sugekare Chubege kle age che dolla takalin kare. Bdagli kwian ene be boi daga ngwale nga dbigu giti che dolla ngwadi agedu me no kbiale, kwian ngle be boi ene. ");
INSERT INTO sabNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Jesu gerudu dare kwian ole: —Ba bai Chube gerua gaba batre, ba ulitaske kwian na geru me ulia dbanga be chke gerule no ba ulita ole Chube giti. Gwangea ama be chage no ba ulita ole, ene ama takalin ba mo ta gbe no ama ole, agwa bigire be chke uñale bage ama ta me no, ama me kle gerule ulia ba ole Chube giti. Ama ta ba anblitakalin geru me uliage malen ba kledale ta giti, ba me kwian ene kerua tallade, ama kle gerule ngwale. ");
INSERT INTO sabNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ama kle chage me no baske giti ñage chke uñale bage ama ta mine ulia, ñage chke uñale bage kwian e kwian me no me kle Chube gerua dbe ulia, ama geru ngwale dbanga, e salengwli gligba giti chke uñale chege gli mine. Uñale trate ba ulitage idongi me gbachie uvale, drinkin me gbachie higole. ");
INSERT INTO sabNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Gli no gbachie no diali, kaire gli me no gbachie me no diali. ");
INSERT INTO sabNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Gli no me ñage gbachie me no, gli me no me ñage gbachie no. ");
INSERT INTO sabNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kaire gli me no me gbachie no, ama datakle gugakle jitaske. ");
INSERT INTO sabNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Gligba giti gli chke uñale nate gli bai no gli bai me no. Ene kaire kwian kle age no o kle age me no ba ulitaske giti ñage chke uñale trate ba ulitage kwian bai no kwian bai me no kwian bai Chube gerua ulia dbanga kwian bai geru ngwale dbanga. ");
INSERT INTO sabNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","23","Jesu gerudu dare kwian ole: —Chui bdagli be chke gire Chube be kwian me no gbe ji chuge boi daga ngwale tanre diali chui tangle. Chui ege kwian tanre be gerule ama kle cha gai mo Chugagwallale agwa ama me mo ta gbaba ulia age cha Ñenua Chube takalin kare, malen ngwale kwian ene gerule ama kle cha gai mo Chugagwallale. Kaire chui bdaglige kwian tanre be gerule cha ole: “Ba cha Chugagwalla, ba kalla giti cha ba gerua ketu kwiange kaire ba kiralla giti cha dolla kagu siere kwian jwligebangage, lle no tanre cha dodadu ba kiralla giti.” Kwian be gerule ene agwa ama me cha gerua gaba ulia gire cha be jainnga ama kalen: “Ba me cha gerua gau ulia, cha me ba uñe, ba me chanu, ba kwian agenga me no. ¡Joga siere chage! Ba me ñage joge toi cha ole cha Ñenua Chube ole nga ngaña giti.” Cha be gerule ene kwian me cha gerua gaba ole chui bdaglige. Cha gerule ba ole, kwian bai kle age Chube takalin kare, ama alin allabi be ñage joge toi Chube ole nga ngaña giti. ");
INSERT INTO sabNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Jesu gerudu dare kwian ole: —Kwian bai kle cha keruchuge gire mo ta gbe age cha gerule kare, kwian e ta no molen tañachuge trate, ama salengwli kwian u gbanga no kare. Ngeru kwian u gbanga no kle dbi bage jere bu tke dbige jere gire kle ke ten budi tangle, ene bu chege kejre me joge chke dba, u kle dodaba no kiraske. ");
INSERT INTO sabNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Noi boi kweri gire chi uda joge kweri, mle kweri tiennga u edi, u me joge chke dba, chi uda me ñage u dbe, u gbanga no bu tku jere dbige malen chi uda me ñage u e dbe. Kwian bai cha gerua keruchuge gire mo ta gbe age cha gerule kare, kwian ene salengwli kwian u gbanga no e kare. ");
INSERT INTO sabNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Agwa kwian bai kle cha keruchuge gire me mo ta gbe age cha gerule kare, ama salengwli kwian u gbanga me no kare ama me tañachuge no, ama kle u gbe dbi giti alin me bu tke dbige jere me ke ten budi tangle. ");
INSERT INTO sabNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Noi boi kweri ene chi uda joge kweri, mle kweri tiennga u edi, u joge chke dba, u joge ulita chi giti —Jesu gerudu ene kwian ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Jesu gerudu ene ulita gire kwian tanre chegu tañachuge tanre Jesu gerudu giti, kwian tañachugu mo tale: “¿Mineade ama ñage che tke tangle ene trate? Ama kle che tke tangle ma no ma kiraske kwian che tkanga tangle Moisés chadalla giti ulitage, ama kle che tke tangle kwian geru mauña kweri kare.” Kwian ulita tañachugu ene mo tale Jesu giti. ");
INSERT INTO sabNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesu jo dbige jwichugage kwian geru jwannga amage ulita ole, kwian tanre chagedu ama nate. ");
INSERT INTO sabNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Kwian onbre gdaite chku Jesudi gerule Jesu ole, onbre e oga jingme kwara gbe tuge kote, onbre ege sugedu Jesu kira molen ngle malen ama jongnagwa skutu dba Jesu gwangnagu gire gerudu Jesu ole: —Ba takalin cha dodade, uñale chage ba ñage jingme ai jwen siere chage ene cha chege trate jingme aige. ");
INSERT INTO sabNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Kwian oga gerudu ene Jesu ole gire Jesu ko chugu amadi, Jesu gerudu: —Cha takalin ba jingmea jwen siere bage, nege nege ba chege no trate. Jesu gerudu ene gire sugeti jingme jo siere onbrege onbre chegu trate. ");
INSERT INTO sabNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesu gerudu oga jo chkeni no ole: —Ba me gerule ni kwian gdaite ole cha ba dodadu giti agwa ba agedale Chube nu geru gbaba unsuialin kwian alin Moisés giti gerule kare, chada e gerule ba agedale ai kare: Joga u gerungwa Chube olege mo kaite kwian gerunga Chube ole daba alinge, ba bdada gbaboke dbadale ule gugadale Chube gwa giti u ege ba chegu no trate ñanale, joga age ene ulita gire be chke uñale kwian ulitage ba jo chkeni no ba jingmeage —Jesu gerudu ene kwian onbre jo chkeni ole. ");
INSERT INTO sabNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jesu jo chage una Capernaum ngnagu, jo chke una ege guardia donga chugagwalla nga Romamu gdaite chku Jesudi gerule Jesu ole, ama gerudu: ");
INSERT INTO sabNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Cha ba gai kweri, cha takalin ba cha chudaboi, kwian lle boanga cha alin gdaite kle gwa ama oga jabale, ama skliebadba trate jegwale, ama skibachie tanre me ña jwlitenga. Noare ba cha chudaboi, noare ba lle boanga chanu oga dodade cha alin, ene ama joge chkeni noni. ");
INSERT INTO sabNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesu jaindunga: —Cha ta ba chudaboakalin, cha be joge ule ba ole oga kle ngwadige jingme jwennga siere amage. ");
INSERT INTO sabNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Guardia donga chugagwalla gerudu Jesu ole: —Cha ba gai kweri, chage suge cha me no, uñale chage trate ba no no, malen ma no ba me joge gwa cha ullage oga kle ngwadi, ba gerule alin allabi aini jonke lle boanga cha alin oga giti, ene uñale chage ama be joge chkeni noni. ");
INSERT INTO sabNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Uñale chage ba kwian chugagwalla kweri ba kira molen ulita, ba gerule alin allabi gire jingme joge siere kwian ogage. Cha chugagwalla ñage cha kage lle boi ene cha age ama gerule kare, kaire cha guardia donga chugagwalla ñage guardia donga ulita kage lle boi ama age cha gerule kare, cha gerule guardia donga gdaite ole: “¡Joga!”, gire ama joge. Cha gerule na ole: “¡Bai aini!”, gire ama chie. Cha kwian lle boanga cha alin kage lle boi gire ama lle boi cha gerule kare. Ba ma kweri kira molen malen uñale chage ba gerule alin allabi jonke ba kle ngwadi jingme kage siere lle boanga chanuge, gire jingme be joge siere amage ama be joge chkeni noni. ");
INSERT INTO sabNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesu guardia donga chugagwalla gerua keruchugu ene gire Jesu chegu tañachuge noare amadi, Jesu gerudu kwian kle chage Jesu ole ulita ole: —Ni kwian gdaite nga Israel ulitage guardia donga chugagwalla ta e kare molen, ama kle mo ta gbe cha gerua gai ulia mo tale ma no kwian israelita ulitage. ");
INSERT INTO sabNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Cha gerule ba ulita ole, cha chuia be chke bdagli gire kwian me israelita tanre nga ulitage be chie chui ollade Chube ngwadi, ama ulita cha gerua gaba malen ama be toi no nga ngaña giti Chube ngwadi ule kwian israelita enusulian unsuialin Abraham ole Isaac ole Jacob ole. ");
INSERT INTO sabNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Kwian israelita ulita kledale Chube ngwadi chui ege agwa ama tanre me cha gerua gau ulia, malen ama gbabe sugekare Chubege ji chuge tirare boi tanre daga ngwale nga jereske, ne ngwadi kwian e ulita be olire tanre ji chuge tirarege. ");
INSERT INTO sabNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jesu gerudu ene kwian ulita ole gire Jesu gerudu bdagli guardia donga chugagwalla ole: —Jogani ba ullage, ba cha gau ulia cha ñage gerule alin aini jonke gire lle boanga ba alin oga be joge chkeni, be boi ene ba cha gau ulia kare, oga e be joge chkeni. Jesu gerudu ene gire sugetibi e suiale kwian lle boanga oga kledu gwa jo chkeni no trate. ");
INSERT INTO sabNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesu jo Pedro kle toi ngwadi gire Pedro ñemaña skwendu oga ankwa giti nganagda ole. ");
INSERT INTO sabNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesu jo chke muinga oga kle ngwadi, ko gau kote gire sugeti nganagda me chegu chkedi dare, nganagda ulita jo siere Pedro ñemañage. Ama cheguni noni chku gdate, gire ama bli jinadu Jesu alin kaire kwian na kle ne ngwadi alin. ");
INSERT INTO sabNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Chui amañage ngabi nga jo jere gire kwian tanre oga dule Jesu ngwadi, kwian jwligebanga ngle che dolla kote kaire kwian ngle oga jingme tanre ole dule Jesu ngwadi dodadale. Jesu gerudu geru gbaitre alin allabi kiraske dolla ulita ole gire dolla jo siere kwiange, kaire Jesu kwian na oga dodadu ulita. ");
INSERT INTO sabNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ai ulita boidu ene kwian Chube gerua ketanga kada Isaías Chube gerua degu unsuialin gerule kare, chada e gerule: “Ama che boi daga ngwale ulita chegu ama kote kaire che oga ama che dodadu.” Isaías chada degu ene unsuialin Jesu giti. ");
INSERT INTO sabNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Kwian tanre kledu Jesudi tangle, malen Jesu tadu joge tangle chi kagda giti ongoru, Jesu gerudu kwian geru jwannga amage ulita ole: —Che jogedale tangle chi kagda giti ongoru, ba mo gbe biale. ");
INSERT INTO sabNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Jesu gerudu ene kwian geru jwannga amage ulita ole gire sugeti kwian daba tkanga tangle Moisés chadalla giti gdaite chku Jesudi gerudu Jesu ole: —Ba kwian tkanga tangle geruge, cha ta jogekalin ba ole ba be joge baini kaire ngwadi, cha be chage ule ba ole geru jwen bage. ");
INSERT INTO sabNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesu gerudu kwian e ole: —¿Ulia ulia ba ñage chage cha ole baini kaire cha be joge chage ngwadige? Bliski ugara molen gbengwa kaire bdada ugara molen gbengwa, agwa cha me dale. Chube nu cha kagaba nga dba ai giti kwian kare, cha me u molen agali gbengwa. ");
INSERT INTO sabNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Jesu gerudu ene kwian daba tkanga tangle Moisés chadalla giti gdaite ole gire kwian na gdaite kle ne ngwadi gerudu Jesu ole: —Cha chagekalin ba ole geru jwen bage kaire, agwa nege nege cha me ñage, cha be manade, cha ñenua be jogeda cha be ama jaba tke dbige gire cha be ñage chage ba ole. ");
INSERT INTO sabNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesu jaindunga kwian e kalen: —Ba ta chagekalin cha ole me ñage manade, bai chage cha ole nege. Ba mo ta gbadale chage cha gerua nate ulia, ba bitalla ulita me Chube gerua gai ulia ba ama jige ba ñenua jaba tke dbige. ");
INSERT INTO sabNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jesu gerudu ene kwian ole gire Jesu jo du toli kwian geru jwannga amage gdataboko giti gdaboke ole, ama ulita jo chage duge chiga giti jo chibita kagda giti ongoru. ");
INSERT INTO sabNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Jesu ule kwian geru jwannga ulita ole kle chage duge ene chiga giti gire Jesu gbedu. Jesu kle gbe gire sugeti ngwale mle chku dba kweri kiraske chi skwendu bdugu chi jo du toli, du biri jwlitenga. ");
INSERT INTO sabNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Gire ta kennga tanre ole kwian geru jwannga Jesuge Jesu gau gdate, ama gerudu Jesu ole: —¡Cha Chugagwalla! ¡Chkede bduge cha chudaboi! ¡Che ulita be joge chiske duge llagli, che be unjoge! ");
INSERT INTO sabNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesu jaindunga: —¿Mineade ba ulita ta kennga tanre? ¿Ba me cha gai ulia cha ñage ba manade nga tirareske? Jesu gerudu ene gire ama chku gdate gerudu mle ole gerudu chi ole: —¡Chegede ngwedige ngeru kare! Gire mle kaire chi chegu ngwedi Jesu gerudu kare. ");
INSERT INTO sabNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Jesu agedu ene mle ole chi ole gire kwian geru jwannga Jesuge ulita chegu tañachuge tanre noare Jesudi, ama ulita geru kadu moge ongoru ongoru: —¿Kwian ai mine, ade mle kaire chi kle ama kerua gai dage ama gerule kare? —kwian geru jwannga geru kadu moge ene Jesu giti. ");
INSERT INTO sabNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jesu jo chage dare duge chiga giti kwian geru jwannga amage ulita ole, Jesu jo chke chi kagda giti ongoru nga ka jwankle Gadarage. Ne ngwadi Jesu jo kedagu gire kwian gdaboke jwligebanga dolla kote chku ten Jesu ngwange, kwian jwligebanga gdaboke e kledu toi kwian jaba ogakle keugage ngwadi. Kwian jwligebanga gdaboke e saingwli tanre, malen kwian na ulita ta kendunga chage ne ngwadi jon e giti. Kwian jwligebanga e chku Jesudi, ");
INSERT INTO sabNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","gire dolla kwian boke e tale kwian gbu ngaute Jesuge: —Uñale chage ba Chube Kirolla. ¿Lledale ba chiu cha nate nga aige? ¿Ba chiu aini cha gbe boi daga ngwale ngerutabi Chube be cha ulita gbe ji chuge chuia bebi chke gire? Cha me takalin ba cha gbe boi dagale tanre nege. ");
INSERT INTO sabNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ne ngwadi gwajangeti chunchi tanre kledu blire, ");
INSERT INTO sabNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","gire dolla kledu kwian tale gerudu Jesu ole: —Ba be cha ulita kage siere kwian aige, cha me takalin ba cha kage ji chuge nege nga tirarege, ma no cha takalin ba cha ulita kage toi chunchi e ulita tale. ");
INSERT INTO sabNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesu gerudu amage: —¡Dolla ulita, joga siere kwian aige! ¡Joga toi chunchi tale! Jesu gerudu ene gire dolla jo siere blike kwian onbre bokege jo chunchi tale, kwian boke chegu trate no. Dolla jo chunchi e ulita tale gire chunchi jo jrite ulita jo kegdege dolla kote, chunchi ulita jo chiske jokeda chi kote dolla kbiale. ");
INSERT INTO sabNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Gire kwian chunchi mananga ulita gwagedu chunchi boidu ene ulitadi gire ama ulita jo jrite kwachieske ama jo geru kete kwian ngleage unaske, ama geru tragu boidu chunchi ole giti kaire geru tragu Jesu kwian jwligebanga boke dodadu giti. ");
INSERT INTO sabNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Chunchi mananga geru e ulita tragu kwian unaske ole, gire kwian ulita kledu toi una ege jo tienda Jesudi. Kwian e ulita jo chke Jesudige gire gerudu Jesuge: —Cha ulita me takalin ba chege dare aini nga aige. ¡Joga siere nga aige me age ene dare aini! ");
INSERT INTO sabNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Kwian nga Gadarage Jesu kagu siere nga ege gire Jesu jo du toli geru jwannga amage ulita ole, ama ulita joni tangle chibita kagda giti ongoru. Gire ama ulita jo chkeni Jesu jwiage Jesu toidu ngwadi. ");
INSERT INTO sabNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ne ngwadi kwian oga skliebada trate jegwale dule ankwa giti Jesudi, Jesu gwagedu kwian ogadi gire uñadu Jesuge kwian oga kaire kwian oga dbanga ulita mo ta gbaba ulia Jesu ole Jesu ñage kwian oga dodade, malen Jesu gerudu kwian oga ole: —Ba mo ta gbe suga no. Cha gerule ba ole, ba ageba me no ulita talla cha mlienga, nege ba chege no trate me jiske Chube gwa giti. ");
INSERT INTO sabNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Kwian daba tkanga tangle Moisés chadalla giti gweale kledu eni Jesu keruchuge gerule ene kwian oga ole gire tañachugu Jesudi mo tale: “Onbre e kle gerule me no, ama kle mo gbe kweri Chube kare. ¿Chema ñage kwian age me no ulita talla mlienga kwian gbe no trate me jiske Chube gwa giti? Chube alin allabi ñage, onbre e me ñage age ene Chube kare.” ");
INSERT INTO sabNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Kwian daba tkanga tangle Moisés chadalla giti ulita kledu tañachuge ene mo tale Jesudi, gire Jesuge uñadu trate kwian e ulita kle tañachuge giti, Jesu geru kadu kwian e ulitage: —¿Mineade ba ulita kle tañachuge me no ene chadi? ");
INSERT INTO sabNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Bai ma mno cha alin: kwian oga ai ageba me no ulita talla mlienga o kwian oga ai dodade jingmege? Cha alin ai me mno ulita gdabonate. ");
INSERT INTO sabNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nege cha be kwian oga ai dodade ba ulita gwa giti ene be chke uñale bage ulia Chube cha kagu nga dba ai giti kwian kare, Chube kiralla giti cha ñage kwian oga dodade jingmege kaire agwe cha ñage kwian age me no ulita talla mlienga kwian gbe no trate me jiske Chube gwa giti. Jesu gerudu ene kwian daba tkanga tangle Moisés chadalla giti ulita ole gire Jesu gerudu kwian oga skliebada trate jegwale ole: —Nege cha gerule ba ole, chkede gdate mo ankwalla blienga dbadale, jogani chage ba kle toi ngwadige. ");
INSERT INTO sabNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Jesu gerudu ene gire kwian oga skliebada chku gdate mo ankwalla gau kote ama joni chage ama kle toi ngwadige. ");
INSERT INTO sabNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kwian ulita kledu ne ngwadi gwagedu ai ulita boidudi gire kwian ulita ta me jo sugano chegu tañachuge tanre, kwian gerudu no Chube giti: —Chube noare, ama kira molen ulita, ulia ama kira ketu Jesuge kwian oga skliebada trate jegwale dodade, ulia Chube no no —kwian ulita gerudu no ene Chube giti. ");
INSERT INTO sabNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesu kwian oga skliebada dodadu ene gire Jesu jo chage dare, Jesu gwagedu kwian onbre ka jwankle Mateodi. Mateo kwian igi ganga chugagwalla emperador nga Romamu alin, ama kledu toiba dba igi ketakle ngwadi igi gai kwiange, gire Jesu chku amadi gerudu ama ole: —Bai chage cha ole geru jwen chage. Jesu gerudu ene gire Mateo chku gdate lle e boi chugu ngwadi ulita, ama jo chage Jesu ole. ");
INSERT INTO sabNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Chui gbaite Jesu jo blire Mateo ullage kwian geru jwannga amage ulita ole, Jesu kle blire eni gire kwian tanre igi ganga chugagwalla emperador nga Romamu alin kaire kwian na tanre agenga me no chku Mateo ngwadi, kwian e ulita toidu dba blire ule Jesu ole kaire kwian geru jwannga Jesuge ole. ");
INSERT INTO sabNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Kwian fariseo mneite kledu eni gwagedu Jesudi blire ule kwian tanre agenga me no ole gire kwian fariseo e geru kadu Jesu giti ta me no ole kwian geru jwannga Jesuge ulitage: —¿Mineade ba tkanga tangle geruge kle blire ule kwian igi ganga chugagwalla emperador nga Romamu alin ole kaire kwian na tanre agenga me no ole? ");
INSERT INTO sabNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Kwian gerudu ene kwian geru jwannga Jesuge ole gire Jesuge geru sugedu kwian kledu geru kade giti, malen Jesu gerudu kwian e ole: —Cha gerule ba ulita ole, kwian kle no trate me oga me joge kwian mo dodanga ngwadi mo dodade, agwa kwian oga ima ama joge kwian mo dodanga ngwadi mo dodade. ");
INSERT INTO sabNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Cha tai dage kwian ai ulita cha kle blire olege, cha ta ama ulita chudaboakalin kwian mo dodanga kwian oga chudaboi kare. Ba geru jwandale Chube gerua degaba unsuialinge ene suge bage chada e giti Chube kle gerule mine, chada e gerule: “Chube gerudu: ‘Cha me takalin ba bda gweda cha gwa giti age no cha ole alin allabi. Agwa kaire cha takalin ba tai dage daba nage diali ba agedale no ama alin.’ ” Chube gerua degaba unsuialin gerule ene. Cha gerule ba ulita ole, cha chiu nga dba ai giti kwian agenga me no ta blite Chube ole joge siere ama kle age me noge, agwa kwian gweale kle tañachuge mo tale ama no trate me jiske Chube gwage, kwian kle tañachuge mo giti ene alin cha me chiu, cha chiu kwian agenga me no alin —Jesu gerudu ene kwian fariseo ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Kwian tanre chagedu Juan-Bautista ole Juan-Bautista gatedi geru jwen Juan-Bautistage ama jo Jesudi geru kade Jesuge, ama gerudu Jesu ole: —Cha ulita geru jwannga Juan-Bautistage kaire kwian fariseo ulita diali kle chui gweale gai mo tkale bage bligdage gerudale Chube ole alin chui ulita me blire. Cha ulita kle age ene tanre, agwa kwian geru jwannga bage ni gdaite kle age ene. ¿Mineade geru jwannga bage me kle mo tke bage bligdage chui gwealege cha ulita kle age kare? Kwian geru jwannga bage ulita kle blire chui ulitage. ");
INSERT INTO sabNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesu jaindunga: —Cha be geru ai ñachuge ba ulita alin, ene be chke uñale bage mineade kwian geru jwannga chage me kle mo tke bage bligdage kwian na kle age kare: Kwian onbre mo jwen chuia gbe, mo jwen chuia chke gire kwian kadaba ulita be joge chui ollade ule kwian onbre mo jwannga ole. Kwian kadaba ulita be chke chui ollade, ¿chema gerule kwian e me ñage blire? Kwian ulita be blire nga suga no ole chui ollade ule kwian onbre mo jwannga ole. Agwa chui e joge tangle gire chui gbaite be chke kwian onbre mo jwannga dbabe sugekare, chui ege kwian mo jwen chuia olladanga ulita be chege ta olire kwian onbre mo jwannga nate gire kwian chui olladanga ulita be mo tke bage bligdage ta olire ole. Ulia cha gerule ba ulita ole, cha kwian onbre mo jwannga e kare, kwian geru jwannga chage ulita kwian mo jwen chuia olladanga kare. Nege cha kle ule geru jwannga chage ulita ole, agwa chui be chke gire cha dbabe sugekare amage, chui ege ama be mo tke bage bligdage ta olire tanre ole. ");
INSERT INTO sabNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Jesu geru ñachugu ene kwian alin gire Jesu geru na ñachugu ama alin kaire: —Cha gerule ba ulita ole, ni kwian gdaite kle mo ñometralla juda ugachuge ñometra jagere me gligabage. Che ñometra jagere gbe ñometra juda giti, gire che ñometra jagere glige ñometra junbate ñometra chege ma soli, ñometra jagere kle ñometra juda gbe dretenga, gire ñometra uga kle chege ma me no kweri, ulita kle chege me no. ");
INSERT INTO sabNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kaire ni kwian gdaite kle lle gage jagere tke bda kwara dodaba lle gage dbangwa judage. Che lle gage tke bda kwara judage lle gage jagere kle lie gire bda kwara juda kle skiennga ulita, gire lle gage ulita kle jogenga ngwale ulita, kaire bda kwara kle chege me no ulita. Malen diali lle gage jagere tkakle bda kwara jagerege, ene lle gage kle lie, bda kwara me skiennga, lle gage me jogenga ngwale. Jesu geru ñachugu ene ulita kwian geru jwannga Juan-Bautistage alin, uñadu Jesuge kwian e me ta Jesu gerua jagere gakalin ulia me ta mo gerua juda gbaba unsuialin chugakalin ngwadi, malen Jesu geru ñachugu ene ama alin geru jagere giti geru juda giti. ");
INSERT INTO sabNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesu kledu gerule kwian geru jwannga Juan-Bautistage ole gire kwian israelita chugagwalla gdaite chku Jesudi, ama jongnagwa skutu dba Jesu gwangnagu mo chudaboi kade Jesuge, ama gerudu Jesu ole: —Cha jian jokeda sugeti, cha takalin ba joge ule cha ole cha ullage cha jian jaba kle ngwadi, ba ko gbe ama jaba giti ene ama be chkeni gwade. ");
INSERT INTO sabNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Gire Jesu chku gdate Jesu jo chage kwian e ole kwian e ulla ngnagu, kaire kwian geru jwannga Jesuge gdataboko giti gdaboke jo ule Jesu gatedi. ");
INSERT INTO sabNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Jesu kledu chage jon jegwale gire muinga oga jo chke kodi Jesudi Jesu nate jonke, muinga e oga daige sbali, chura gdataboko giti gdaboke chui kaire kairege muinga e kledu toi daige diali, muinga e tañachugu mo tale: “Uñale chage cha ko chuge Jesu ñometralladi alin allabi gire ene cha be joge chkeni noni Jesu kiralla giti.” Muinga tañachugu ene mo tale gire ama agedu, ama ko chugu Jesu ñometralladi, ");
INSERT INTO sabNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","gire Jesu jwlituda modi tangle, Jesu tendu muinga ogadi gire Jesu gerudu muinga ole: —Ba mo ta gbe suga no, ba mo ta gbu cha gai ulia malen e giti cha ba dodadu, ba jo chkeni noni. Jesu gerudu ene gire sugeti ngwale muinga chegu no trate muinga jo chkeni ama jingmeage. ");
INSERT INTO sabNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jesu jo chage ngeru gire ama jo chke gwa kwian israelita chugagwalla ullage. Jesu gwagedu kwian tanre kle mo litaba enidi, kwian e ulita kledu olire kweri sui jwennga kirogwa muire jaba nate, kaire kwian gweale kledu ngwane lle ngwanegda kada flautage biale joge oña jaba tke dbige. ");
INSERT INTO sabNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jesu gwagedu kwian ene ulitadi gire Jesu gerudu ama ulita ole: —¡Joga siere aini! Kirogwa muire me jogebakeda dale, agwa ama kle gbe alin allabi. Jesu gerudu ene gire kwian ulita gidedu Jesudi Jesu gerudu giti, kwian ulitage uñadu kirogwa muire e nu jogebakeda ulia. ");
INSERT INTO sabNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Jesu kwian e ulita kagu siere ne ngwadige gire Jesu jo chiga kirogwa muire jaba kle ngwadige, ama kirogwa muire jaba ko gau kote gire kirogwa muire chkuni gwade, ama chku bduge. ");
INSERT INTO sabNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Jesu kirogwa muire jaba gbuni gwade ene, gire geru e jo chage kwian ulitaske nga e ulitage Jesu kirogwa muire jaba gbuni gwade giti. ");
INSERT INTO sabNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesu jo chage ngeru ne ngwadi gire kwian gdaboke gwagwa me chagedu Jesu nate jonkare ngaute Jesuge: —¡Ba che chugagwalla unsuialin David oindalla, ba tai dage chage, ba cha gdaboke gwagwa dodade! ");
INSERT INTO sabNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jesu jo chke gwa gire kwian gdaboke gwagwa me chku gwa Jesu nate, Jesu geru kadu ama bokege: —¿Ba cha gai ulia cha ñage ba gwagwa dodade ene ba ten? Ama boke jaindunga: —Ima, uñale chage ulia ba ñage cha gwagwa dodade cha gbe ten. ");
INSERT INTO sabNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Gire Jesu ko chugu ama gdaboke gwagwadi, Jesu gerudu: —Ba cha gau ulia cha ñage ba gwagwa dodade, malen ba gwagwa be chege no ba takalin kare, ba be ten no trate. ");
INSERT INTO sabNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Jesu gerudu ene gire kwian gdaboke gwagwa chegu no, ama ñadu ten no trate, Jesu gerudu ama ole: —Ba me geru trage ni kwian gdaite ole cha ba gwagwa dodadu giti. ");
INSERT INTO sabNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Kwian gdaboke jo siere ne ngwadi ama me ñadu geru gate mo tale, ama geru tragu kwian ulita nga ege ole Jesu agedu giti no ama alin Jesu ama boke gwagwa dodadu. ");
INSERT INTO sabNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Jesu kwian onbre gdaboke gwagwa gbu ten, kwian e boke kledu joge siere Jesu kledu ngwadige gire kwian na chiu daba keru me dbe Jesuge dodadale, onbre e nu jwligebanga che dolla kote, me ñage gerule che dolla kbiale. ");
INSERT INTO sabNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesu dolla kagu siere onbre ege gire onbre e ñadu gerule. Kwian kle ne ngwadi ulita chegu tañachuge tanre Jesu agedu giti, kwian gerudu: —Ni cha nu gwageba kwian mo dodanga nodi e kare aini nga Israel ulitage. ");
INSERT INTO sabNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Agwa kwian fariseo ulita kle ne ngwadi gerudu Jesudi: —Dolla chugagwalla kle kira kete amage, kira e giti ama kle ñage dolla na kage siere kwiange —kwian fariseo gerudu ene me no Jesudi. ");
INSERT INTO sabNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesu jo chage una kaire kairege kwian tke tangle u mo litangwa Chube gerua jwanngwage. Una ulita baini kaire Jesu jo chke ngwadi ama gerudu kwian ulita ole kwian ñage Chube uñe, kwian mo ta blitadale Chube ole Chube gai mo Chugagwallale, ene Chube be kwian e jwen siere ji chugege agedu me no gdale. Jesu chagedu gerule ene kwian ole, kaire agwe Jesu kwian jingmere dodadu, kaire kwian oga lle na tanre kote Jesu kwian oga ene dodadu ulita. ");
INSERT INTO sabNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Baini kaire Jesu jo ngwadi kwian ngle kledu, diali Jesu gwagedu kwian e ulitadi gire Jesu taidu dage kwian e ulitage, Jesu gwagedu kwian e ulitadi ta olire, kwian e ulita kira me chage no Chube takalin kare, chudaboanga me kwian e alin kwian e tke tangle no trate Chube gerua giti. Jesuge sugedu kwian e ulita bda oveja me mo mananga molen kare, ");
INSERT INTO sabNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","malen Jesu gerudu kwian geru jwannga amage ulita ole kwian ene giti: —Kwian tanre me Chube gerua uñe kle Chube gerua manade ngwange, agwa Chube gerua dbanga bedreare. E salengwli bligda tanre kle biale jwandale kare, bligda e jogeba dabe, agwa kwian bligda jwannga bedreare kagadale bligda e jwen. E kaire ene kle boi Chube gerua giti, ");
INSERT INTO sabNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","malen ba gerudale Chube ole Chube kwian gai kage ama gerua kete kwian me ama gerua uñege. E salengwli bligda mauña kle kwian na kage bligda jwen ama alin kare —Jesu gerudu ene kwian geru jwannga amage ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Chui nage Jesu kwian geru jwannga amage gdataboko giti gdaboke kadu geru trage, chui ege Jesu mo kiralla ketu ama ulitage lle daga ngwale no tanre dodade Jesu kiralla giti, Jesu gerudu ama ole: —Nege gwangerugu cha kiralla giti ba ñage dolla kage siere kwian jwligebanga dolla kotege, kaire ba ñage kwian jingmere dodade ba ñage kwian oga lle na tanre kote dodade. ");
INSERT INTO sabNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Jesu gerudu ene kwian geru jwannga amage ulita ole, kwian e ulita kada ene: Simón (amaña kada Pedro), Andrés (ama Pedro daballa), Santiago (ama Zebedeo kirolla), Juan (ama kaire Zebedeo kirolla, ama Santiago daballa), ");
INSERT INTO sabNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolomé, Tomás, Mateo (ngeru ama igi ganga chugagwalla emperador nga Romamu alin), Santiago (ama Alfeo kirolla), Tadeo, ");
INSERT INTO sabNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón (ama kwian kira batanga mo jwia gdale), Judas-Iscariote (bdagli ama jwlitedu Jesu dollale Jesu ketu gwaleda). Jesu mo kiralla ketu kwian e ulita gdataboko giti gdabokege gire Jesu ama ulita kagu Chube gerua dbe kwian nage. ");
INSERT INTO sabNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesu bebi kwian e ulita kage Chube gerua Jesu giti dbe kwian nage gire Jesu gerudu ama ulita ole: —Ba joge chage Chube gerua dbe gire ba me joge nga kwian me israelita kle toi ngwadige Chube gerua trage ama ole, kaire ba me joge una ulita nga Samariage Chube gerua trage kwian e ole. ");
INSERT INTO sabNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ma no ba jogedale Chube gerua trage kwian israelita ulita ole, ama bda oveja jogebanga kare, ama me Chube gerua cha giti uñe. ");
INSERT INTO sabNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ba joge geru trage kwian ene ole Chube giti, ba gerudale: “Chube be age kwian ulita alin chuia kle kodi, ba mo ta blitadale Chube ole ama gai mo Chugagwallale.” ");
INSERT INTO sabNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ba chagedale geru e trage kwian ulita ole, kaire ba kwian oga dodade, ba kwian jogebakeda gbeni gwade, ba kwian oga kwara tuge jingmea kada lepra ole dodade jige trate, ba dolla kage siere kwian jwligebanga dolla kotege. Cha kira ketu bage, kira e giti ba kwian oga dodade, ba kwian oga dodade ba me igi kade kwiange ba kwian dodadu ñanale, ba me ñage kwian oga dodade mo kiralla giti, cha kira e ketu bage malen ba agedale no kwian na alin me igi kade amage age ene ñanale. ");
INSERT INTO sabNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","Ba joge age ene kwianske ba me teru dbe mo ole llagli, ba jogedale kole. Ba me igi dbe mo alin lle gigagda, ba me gde teru dbangwa dbe, ba jogedale ñometra modi alinske, ba zapato dbe modi alin, ba me zapato na ni ñometra na dbe mo ole llagli. Kaire ba me glita chagegda dbe. Chkedale uñale bage ba be Chube gerua dbe kwian nage, kwian e ba manadale lle ulita giti, malen ba me teru dbadale ni ba tañachugadale lle giti mo alin toigda. ");
INSERT INTO sabNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Una ulitage baini kaire ba joge chke ngwadi ba chagedale u kaire kairege kwian ta no ole jinade, kwian ene kare skwen bage ama ba gai ngwange no mo ullage age no ba alin, kwian e ullage ba chegedale toi ba kle Chube gerua dbe kwian una emuske gire. Ba joge dare una nage ba age ene una kaire kairege baini kaire ba joge chke ngwadi. ");
INSERT INTO sabNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","U bai kairege ba joge chke ba gbi kadadale no kwian ulitage kle toi u ege, ba gerudale ama ulita ole: “Cha takalin Chube age no ba ulita alin, ene ba ulita ta dbe suga no.” ");
INSERT INTO sabNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ba gbi kade no ene kwiange gire kwian jainnga ta no giti ba kalen gwajondoida kwian ba gai ngwange no, kwian ene alin Chube be age no. Agwa ba gbi kade kwiange gire kwian me jainnga ba kalen ta no giti me ba gai ngwange no, kwian ene alin Chube mi age no, Chube be age no ba alin allabi, ngwale ba gbi kade kwian enege, ama mi ba keruchuge gerule Chube giti. ");
INSERT INTO sabNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Baini kaire ba joge chke ngwadige kwian me ba gai ngwange no ni kwian ta ba keruchugakalin gerule Chube gerua giti, ba me tallade, ba jogedale siere u ege una ege, ba dbi mnuña skiennga mo serage kwian ene gwa giti, ene be suge kwian ege ama chege jiske tanre Chube gwa giti me ba gai ngwange no gdale Chube gerua giti. ");
INSERT INTO sabNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Cha gerule ulia ba ulita ole, chui be chke gire Chube be ji gbe kwian una ege alin bai me ba gau ngwange no me tadu Chube gerua keruchugakalin, kwian ene alin Chube be ji gbe ma mno Chube ji gbu kwian agenga me no ulita alin una Sodomamuge una Gomorramuge unsuialin tangle. ");
INSERT INTO sabNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Jesu gerudu dare kwian geru jwannga amage ole: —Cha gerule ba ulita ole, cha kle ba kage cha gerua trage kwian ole, joga ta giti. Cha kle ba kage, kwian ta me no me cha gerua gaba ulia be age ba dollale, ama ta ba gbakalin boi daga ngwale, ba be chage kwian eneske salengwli bda oveja chage gude tirareske kare. Ba chagedale ta giti kwian eneske salengwli jorisi kle mo gbe biale kare, kaire ba chagedale no trate kwian e gwa giti, me mo gbe jiske amage salengwli beusi me mo gbe jiske kwiange kare, ba tachkedale age no diali kwianske. ");
INSERT INTO sabNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ba ulita kledale ta giti, kwian gweale me ta cha gerua keruchugakalin, ta me no ole kwian ene be ba gai be ba kete kwian israelita chugagwallage boadalenga daga ngwale cha gerua gdale, kwian chugagwalla e be ba dbe u mo litangwa Chube gerua jwanngwage be ba batange obere giska giti kwian na ulita gwa giti. ");
INSERT INTO sabNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Kaire agwe ba dbabe kwian chugagwalla tanre ma kweri ngwadi, chugagwalla e ulitage ba gbabe jiske cha gerua gdale, ba kle chugagwalla e ngwadi gire ba be ñage gerule no cha giti chugagwalla e ulita gwa giti kaire kwian me israelita na tanre gwa giti. ");
INSERT INTO sabNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","Ba ulita be geru cha giti kete kwiange, e giti kwian tanre be ba dollale be ba gai be ba dbe gbale jiske kwian chugagwalla kweri ulitage, ba boi ene gire ba me mo tallade ba be gerule mine mo giti kwian chugagwalla kweri e ulita gwa giti. Ba be kle eni kwian e gwa giti gire chui ege ba mi gerule mau tale, ba Ñenua Chube ama Oña be ba ta gbe ba gerudale mine kwian ole, ulia Chube Oña be ba chudaboi be ba ta gbe geru ulita giti. ");
INSERT INTO sabNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Cha gerua gdale kwian be ta jwlite mo daballanu dollale be mo daballa kete kwian chugagwallage gwaleda, kaire ñenua be ta jwlite mo kirogwallanu dollale be mo kirogwalla gwangeda cha gerua gdale, kirogwa be ta jwlite mo ñenua dollale mo chebia dollale be mo chebia mo ñenua gwangeda cha gerua gdale. ");
INSERT INTO sabNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Kaire cha gerua gdale kwian ulita be jainchke badi, agwa ba me mo tallade, ba bai me mo chuge ngwadi joge siere cha geruage boi daga ngwaleske, ba mo ta gbe cha gerua gai ulia mo tale diali gwangerugu mo ta gbe age no diali Chube takalin kare, ba bai mo ta gbe ene, chui bdagli be chke gire ba be toi no diali chui tangle cha ole Chube ngwadi. ");
INSERT INTO sabNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nege gwangerugu ba be kle chage una kaire kaire ulitage geru cha giti trage kwian ulita ole. Una gwealege kwian ba jrite nate ba gbale boi daga ngwale cha gerua giti, ba kigedale kwian una emuge ngeru, ba jogedale cha gerua trage una nage. Cha gerule ba ulita ole, lle tanre kle ba alin boadale cha gerua dbe una ulitage, ba bebi cha gerua trage kwian ulita ole una ulita kwian israelita kle toi ngwadige gire Chube be cha kageni nakwaite nga dba ai giti kwian ulita Chugagwallale. ");
INSERT INTO sabNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","’Cha gerule ba ulita ole, ba geru jwannga chage ba lle boanga cha alin, cha gerua dbe gdale ba ulita be boi daga ngwale cha kle boi daga ngwale kare. Kwian geru jwannga mo ta dbadale mo tkanga tangle talla kare, kwian lle boanga mo ta dbadale mo mauña talla kare. Ni kwian geru jwannga gdaite ma kweri mo tkanga tanglege, ni kwian lle boanga gdaite ma kweri mo mauñage. Kwian daba tkanga tangle boi daga ngwale, ene kaire geru jwannga amage be boi daga ngwale salengwli mo tkanga tangle kare. Kwian gerule me no kwian daba tkanga tangledi, kaire kwian be gerule me no geru jwanngadi. Kwian gerule daba tkanga tangle e che dolla kada Beelzebú bitalla, ene kaire kwian be gerule me no ene geru jwannga ulita amagedi. Sugedale ba ulita cha gerua jwanngage ba be boi salengwli cha kle boi kare. ");
INSERT INTO sabNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Kwian me no cha gerua ole ba gbe boi daga ngwale ba me mo ta dbadale kennga amadi, kwian ene age me no ba ulita ole skwlenre, e mi chege skwlenre diali, chui be chke gire kwian e agedu me no ulita ba ole be chke uñale nate kwian na ulitage. ");
INSERT INTO sabNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Cha kle Chube gerua kete ba alinge sugekare kwian na ulitage, ba geru e tragale kwian ulita gwa giti. Ba kle geru keruchuge chage sugekare kwian na ulitage, ba me ta kennga geru e kete kwian na ulitage una kaire kairege. ");
INSERT INTO sabNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Cha gerule ba ole, ba me mo ta dbadale kennga kwiandi kwian bai ba gwakalinda cha gerua gdale, ama ñage ba gweda alin allabi, ama me ñage age ba oña ole. Ma no ba mo ta dbe kennga Chubedi, Chube ñage kwian gweda, kaire Chube ñage age kwian oña ole ñage kwian oña kage nga dbigu giti ji chuge diali. Chube ñage age ene malen ma no ba mo ta dbadale kennga Chubedi mo ta gbadale Chube gai dage no. ");
INSERT INTO sabNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","31","Chube kle ba ulita manade no malen ba me mo ta dbadale kennga kwian agenga me no ba oledi. Bdada soli gai gbaboke bdada soli chbade, igi gai sidri bdada ñanale, bdada me ñanaske. Ba ulita me ene, ba ñanaske tanre Chube alin. Bdada me ñanaske agwa Chube kle bdada manade no diali, Chube tale ama me bdada talla kagenga gbaite. Kaire ene Chube kle ba manade ma no bdadage, ba chugaga ulita Chubege uñale gdamangire. Ulia Chube kle ba manade no no malen ba me mo tallade kwian kle age me no ba ole giti, ba me ta dbe kennga cha gerua trage kwian ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Cha gerule ba ole, kwian bai kaire gerule no cha giti nga dba ai giti kwian ulita gwa giti, kwian e gerule ama cha gai ulia, ama gerule ene no cha giti, ene kaire bdagli nga ngaña giti cha be gerule no cha Ñenua Chube ole kwian e giti. ");
INSERT INTO sabNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Agwa kwian bai kaire gerule me no cha giti nga dba ai giti kwian ulita gwa giti, kwian e gerule kwian ulita ole ama me cha gai ulia ama me cha uñe, ene kaire bdagli cha be gerule cha Ñenua ole cha me kwian e uñe dale, ama me kwian chanu. ");
INSERT INTO sabNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Jesu gerudu: —Ba me ñage tañachuge cha chiu nga dba ai giti kwian ulita gbe toi no ule ene kwian me kira bate dare. Me ene dale. Cha gerua giti kwian tanre be mo tke dollale daba na ole, kwian gweale be cha gerua gai ulia, gweale na me dale, gire kwian ene me cha gerua gai ulia be kira bate kwian cha gerua gai ulia ole. ");
INSERT INTO sabNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Cha gerua giti kwian tanre be mo tke dollale mo bitallanu ole, kirolla be kira bate ñenua ole, jian be kira bate chebia ole, gwadimea be kira bate ñemaña ole. ");
INSERT INTO sabNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Kwian cha gerua gai ulia, kwian ene bitallanu gwa be chege ama dollale cha gerua giti. ");
INSERT INTO sabNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Kwian bai ta chagekalin ulia cha ole age cha takalin kare diali, kwian ene mo ta dbadale ma no cha ole mo bitallanu ulita olege. Kwian bai kle mo ta dbe ma no mo ñenua ole mo chebia ole, bai kle mo ta dbe ma no mo kirolla ole mo jian ole, kwian ene kle mo ta dbe ma no mo bitallanu ole cha olege, ama kle tañachuge mo bitalla giti ngeru me kle tañachuge cha giti ngeru, malen ama me ñage chage cha ole. ");
INSERT INTO sabNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Kwian bai ta chagekalin ulia cha ole me ñage tañachuge mau giti ngeru chage, kwian ene mo ta gbadale cha alin ole age ulita cha takalin kare, kwian ene boi daga ngwale cha gerua dbe gdale me tallade, kwian ene kle mo ta gbe age cha takalin kare ama ñage chage cha ole. ");
INSERT INTO sabNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kwian bai tañachuge mau giti alin allabi toi no nga dba ai giti mo manade no me tañachuge age Chube takalin kare giti, bdagli kwian ene be jogenga sugekare Chubege be chege boi tanre daga ngwale diali chui tangle. Agwa kwian bai mo ta gbe chage cha ole mo chuge ngwadi boi daga ngwale nga dba ai giti cha gerua gdale, ama me mo tallade, ama tañachuge ma no age Chube takalin kare, bdagli kwian ene be toi no diali chui tangle nga ngaña giti cha ole cha Ñenua Chube ole. ");
INSERT INTO sabNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Cha kle ba kage cha gerua trage kwian na ole, kwian bai ba gai ngwange no ba keruchuge no, kwian ene me kle ba alin allabi gai ngwange, kaire ama kle cha gai ngwange no agali kare ba giti. Chube cha kagu nga dba ai giti ama gerua kete kwiange, kwian bai cha gai ngwange no, kwian ene me kle cha alin allabi gai ngwange, kaire ama kle cha kaganga gai ngwange no agali kare cha giti. ");
INSERT INTO sabNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kwian Chube gerua ketanga Chube kle ama kage Chube gerua kete kwiange gire kwian bai ama gai ngwange no ama gerua gai ulia, kwian enege Chube be lle no kete bdagli salengwli Chube be lle no kete geru ketangage kare. Kwian baige suge daba na gweale ulia agenga no trate Chube takalin kare gire ama daba e gai ngwange no daba kle age no giti, bdagli Chube be lle no kete kwian ege daba gau ngwange no ñanale salengwli Chube be lle no kete daba agenga no trate Chube takalin karege. ");
INSERT INTO sabNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kwian bai gwage cha gerua ganga me sbalidi chage sie ole gire tai dage cha gerua ganga ege kwian bai chi kete amage jadale, kwian enege Chube be lle no kete amage ama chi ketu cha gerua ganga me sbalige ñanale —Jesu gerudu ene ulita kwian geru jwannga gdataboko giti gdaboke ole, gire Jesu kwian e kagu nga ulitage Jesu gerua trage kwian na ole. ");
INSERT INTO sabNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesu gerudu ene kwian geru jwannga amage gdataboko giti gdaboke ole ama ulita ta gbale biale Chube gerua trage kwian na ole, gire Jesu jo dare kwian na tanre tke tangle Chube gerua giti una kaire kairege nga kweri Galileage. ");
INSERT INTO sabNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","E suiale Juan-Bautista kledu skage, amage geru chku uñale Jesu kle age ulita kwianske giti gire Juan-Bautista kwian gweale geru jwannga amage kagu tienda Jesudi. ");
INSERT INTO sabNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Kwian geru jwannga Juan-Bautistage bebi joge tienda Jesudi gire Juan-Bautista geru ñachugu kwian ege geru kadadale mine Jesuge, Juan-Bautista gerudu: —Joga Jesu kle ngwadi ba geru kade amage: “Unsuialin Chube gerudu be kwian jwannga siere kage kwian alin, ¿ba amaña o ama bebi chie, cha chegedale ama manade ngwange dare o me?” Joga geru kade ene Jesuge. Kwian geru jwannga Juan-Bautistage jo chke Jesudi, ama geru kade Jesuge Juan-Bautista gerudu kare. ");
INSERT INTO sabNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesu jaindunga: —Jogani Juan-Bautista kle ngwadi, ba gerule Juan-Bautista ole ba kle gwagedi nege giti, kaire ba kle geru keruchuge nege ba e tragadale Juan-Bautista ole. ");
INSERT INTO sabNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Kwian gwagwa me cha kle gwagwa gbe ten, kwian me ñage chage cha kle ama gbe chage, kwian oga kwara tuge jingmea ole cha kle dodade ene ama chege trate, kwian me olo molen cha kle olo gbe tren, kwian jaba cha kle gbeni gwade, kaire Chube gerua cha giti kle joge chke kwian me lle molenge, ene ama ñage Chube gerua cha giti gai ulia tiendale gitiru ji chugege age me no gdale. Cha kle age no ene ulitadi ba kle gwage nege, jogani Juan-Bautista kle ngwadi e ulita trage ama ole. Kaire ba geru ai kete amage: ");
INSERT INTO sabNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","“Nga suga no kwiandi kwian bai cha gai ulia Chube nu cha kagaba kwian ulita jwanngale siere ji chugege age me no gdale, kwian bai mo ta gbe cha gai ulia ene diali, kwian ene me jogenga cha giti mo tale, ama be chege ta suga no ole.” Ba geru e ulita kete Juan-Bautistage cha alin. ");
INSERT INTO sabNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jesu gerudu ene ulita kwian geru jwannga Juan-Bautistage ole gire kwian e joni Juan-Bautista kledu skage ngwadi. Kwian e jo gire Jesu gerudu kwian ulita kledu eni ole Juan-Bautista giti, Jesu gerudu: —Ba ulita jo tienda Juan-Bautistadi nga gballage, ba gwagedu amadi ama me kledu boi eske kle jwliennga ongoru ongoru mleudage kare, kwian boi eske kare mleuda ole e salengwli gerule kwian me ñage tañachuge mo tale no gwangeru alin trate, diali kle tañachuge gwangeru gwanaskuda, Juan-Bautista me ene, ama mo ta gbu kiraske Chube gerua cha giti gai ulia diali. ");
INSERT INTO sabNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ba jo tienda Juan-Bautistadi nga gballage, ba me jo tienda kwiandi kwian nu mo ngama tkaba ñometra noare gigaba kwangleske. Uñale bage kwian kle mo ngama tke ñometra eneske me kle toi nga gballage, kwian ene kle toi chugagwalla ullage u no kweri tratege, Juan-Bautista me toidu u enege. ");
INSERT INTO sabNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ba me jo tienda kwian kle toi u e karegedi, ba jo tienda kwian Chube gerua ketanga dabagedi. Cha gerule ba ole, ulia Juan-Bautista Chube gerua ketanga, kaire agwe Juan-Bautista ma kweri kwian Chube gerua ketanga na ulitage. ");
INSERT INTO sabNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Chube gerua degaba unsuialin gerule Chube be Juan-Bautista kage cha ngeru, chada e gerule: “Chube gerudu: ‘Cha be kwian gdaite cha gerua ba giti dbanga kage ba ngeru, kwian geru dbanga e be kwian na ta gbe biale ulita ba ngwange.’ ” Chube gerua degaba unsuialin gerule ene Juan-Bautista giti. ");
INSERT INTO sabNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","’Cha gerule ba ole, aini nga dba giti kwian na me Juan-Bautista kare, ni kwian gdaite ma kweri Juan-Bautistage Chube gwa giti. Agwa nege gwangerugu kwian bai mo ta gbe cha gerua gai ulia, kwian e me chege kweri kwian na gwa giti agwa Chube gwa giti kwian ene ulita chege ma kweri Juan-Bautistage Chube gwa giti —Jesu gerudubi ene kwian ole Juan-Bautista giti. ");
INSERT INTO sabNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","14","Gire Jesu gerudu dare kwian ole: —Unsuialin Moisés Chube gerua degu, geru e chegu degaba kwian alin, ene chku uñale ba enusulian oñage ama chagedale mine Chube takalin kare. Kaire kwian Chube gerua ketanga tanre Chube gerua tragu ba enusulian oña ole, kwian Chube gerua ketanga unsuialin gweale gerudu ba enusulian oña ulita ole daba na be chie giti, daba e Chube gerua ketanga dabage salengwli Chube gerua ketanga kada Elías kare, e Juan-Bautista. Ba ulita mo ta gbe kwian Chube gerua ketanga unsuialin gerua gai ulia gire ene be suge trate bage Juan-Bautista chku kle toi ai suiale, Juan-Bautista e amaña kwian Chube gerua ketanga unsuialin gerudu giti. Juan-Bautista chku, ama chuiage gwangerugu Chube gerua tragale kwian ulita ole, Juan-Bautista kwian tanre ta gbu Chube gai ulia mo Chugagwallale, ene kwian chege Chubenu, ene kwian ñage toi Chube ole nga ngaña giti. Kaire nege tangle kwian tanre kle geru e keruchuge kle geru e gai ulia, gire ama ulita kle boi tanre daga ngwale Chube gerua e gai ulia gdale kwian me geru gai ulia kote. Kwian Chube gerua ganga ulia kle gerule kwian na ole Chube chuia be chke gire Chube be gerule nga ulita giti kwian Chugagwallale, kwian me Chube gerua ganga me takalin geru e chage dare kwianske, malen ama kle kwian Chube gerua ganga gbe boi daga ngwale. ");
INSERT INTO sabNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ba ulita me cha gerua ai keruchuge alin allabi mo ologe, agwa kaire ba ulita mo ta gbadale geru ai gbe gdadi. ");
INSERT INTO sabNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Jesu gerudu dare kwian ulita ole: —Nege cha be gerule ba ole kwian kle toi nege tangle giti. ¿Ama kwian mine? ¿Ama llema kare? Kwian tanre nege tangle salengwli kirogwa kare kirogwa kle kolale mo skatemanalla ole goga tangle, me kolale no kle ka boi mo skatemanalla ole, kirogwa gerule daba ole: ");
INSERT INTO sabNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Cha ngwanedu chirege ba alin, ene ba ñage skwen gdate chire keruge, agwa ba me nga talladu, nga me sugadu no badi. Gire cha mo gatu ta olire giti, agwa ba me tadu olire.” Kirogwa kira bate ene ulita modi, kwian tanre nege tangle kle age ene kare. ");
INSERT INTO sabNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Juan-Bautista chku Chube gerua trage kwian ole, kwian tanre gwagedu Juan-Bautistadi Juan-Bautista toidu me blire kwian ulita kle blire kare Juan-Bautista me uva chia jau kwian ulita kle jai kare, Juan-Bautista toidu ene kare gdale kwian tanre me Juan-Bautista gau ngwange no kwian gerudu me no Juan-Bautistadige Juan-Bautista kwian jwligebanga che dolla kote. ");
INSERT INTO sabNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Chube nu cha kagaba kwian kare nga dba ai giti, cha me kle toi Juan-Bautista toidu kare, cha kle blire kwian ulita kle blire kare kaire cha kle uva chia jai kwian ulita kle jai kare, cha kle toi ene kare gdale kwian tanre me kle cha gai ngwange no kle gerule me no chadi cha kwian bligda gutanga ngle cha kle chage kwian llale kare, kaire kwian gerule chadi cha kle kwian igi ganga chugagwalla emperador nga Romamu alin gai mo skatemanallale kaire kwian na agenga me no ulita gai mo skatemanallale. Kwian tanre kle gerule ene me no chadi, kwian gerudu me no kaire Juan-Bautistadi, agwa Chube gwa giti Juan-Bautista kwian no kaire cha kwian no. Juan-Bautista toidu no Chube ama ta gbu toi kare, kaire agwe ene cha kle toi no Chube kle cha ta gbe toi kare kwian gwa giti, malen cha giti kaire Juan-Bautista giti kwian tanre Chube gerua gau ulia —Jesu gerudu ene ulita kwian ole. ");
INSERT INTO sabNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Gire Jesu gerudu mno kwian toinga una gweale giti: —Una tanrege baini kaire cha jo chke ngwadi cha lle daga ngwale no tanre dodadu Chube kiralla giti kwian una e ulitage gwa giti, agwa kwian una e ulitage me tadu cha gerua gakalin ulia, ama me mo ta blitu Chube ole joge siere ama kle age me no Chube dollalege. ");
INSERT INTO sabNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Chube be ji gbe tirare kwian una emu ulita alin kwian me cha gau ulia gdale. Una Corazínge kaire una Betsaidage cha lle daga ngwale no tanre dodadu Chube kiralla giti, kwian tanre toinga una boke ege gwagedu chadi age no ene amaske agwa ama me mo ta blitu Chube ole joge siere ama kle age me no Chube dollalege. E kare ene lle daga ngwale no jo dodabale una Sidónge una Tiroge kwian una boke emu gwa giti, gire ene kwian tanre una emu sbali mo ta blitu Chube ole, ene kwian e ulita ñometra juda me no tku modi ta olire ole kaire mnugda batu mo jegwale, ene ama mo kaite ta olire ole agedu me no ngerule giti. ");
INSERT INTO sabNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Agwa lle daga ngwale no me jo dodabale Chube kiralla giti una Sidónge una Tiroge lle daga ngwale no jo dodabale una Corazínge una Betsaidage kare, malen chui bdaglige Chube be ji gbe kwian agenga me no ulita alin chuia, chui ege Chube be kwian una Corazínmu kwian una Betsaidamu gbe ji chuge ma jabale kwian una Tiromuge una Sidónmuge. ");
INSERT INTO sabNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kaire kwian una Capernaummu jiske tanre, ama kle tañachuge ama ulita ma no kwian una na ulitage, ene bdagli ama be joge toi no Chube ole nga ngaña giti. E me ene dale. Bdagli Chube be ji gbe tirare kwian una Capernaummu alin, kwian e kagabe ji chuge tirare ngwadi nga dbigu giti. Ulia kwian una Capernaummu jiske tanre Chube gwage, Chube kiralla giti cha lle daga ngwale no tanre dodadu kwian una emu ulita gwa giti, agwa kwian e me mo ta blitu Chube ole joge siere ama kle age me no Chube dollalege. E kare ene lle daga ngwale no jo dodabale una Sodomage kwian una emu gwa giti, gire ene kwian tanre una Sodomage mo ta blitu Chube ole. Agwa lle daga ngwale no me jo dodabale Chube kiralla giti una Sodomage lle daga ngwale no jo dodabale una Capernaumge kare, kwian una Sodomage me mo ta blitu Chube ole, ama chegu age me no tanre Chube dollale malen Chube ji gbu tirare kwian ulita una emu alin, Chube kwian e una Sodomamu ulita kagunga, una e chegu kugeba ulita. ");
INSERT INTO sabNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Cha gerule ba ole, chui bdaglige Chube be ji gbe kwian agenga me no ulita alin chuia, chui ege Chube be kwian una Capernaummu gbe ji chuge ma jabale kwian una Sodomamuge —Jesu gerudu ene kwian toinga una tanre giti bai me ama gau ulia. ");
INSERT INTO sabNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Gire ne suialege tangle Jesu gerudu Chube ole: “Cha Ñenua, ba nga ngaña giti nga dba ai giti ulita Chugagwalla, nga suga noare chadi ba giti, ba noare ulita. Kwian me geru molen ama ta ba gerua gakalin ulia blike salengwli kirogwa geru gai blike kare, noare ba kwian ene ta gbu, ene amage ba gerua sugedu. Agwa kwian geru molen geru jun tanre lle ulita giti, kwian enege ba gerua me sugedu, ba gerua chegu ogabada kare amage. ");
INSERT INTO sabNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Chadi nga suga noare ba giti, ba kle kwian ta gbe ba takalinge kare, e no cha Ñenua.” ");
INSERT INTO sabNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Jesu gerudu ene Chube ole gire gerudu kwian kledu ne ngwadi ama keruchuge ole: —Cha Ñenua mo kiralla mo talla ulita ketu chage. Cha Chube Kirolla, ulia ni kwian gdaite cha ta uñe trate, cha Ñenua alin allabi cha ta uñe trate. Kaire agwe ni kwian gdaite cha Ñenua ta uñe trate, cha alin allabi cha Ñenua ta uñe trate. Kwian baige cha takalin chke uñale cha Ñenua mine, cha kwian ene ta gbe, ene cha giti ama ñage cha Ñenua ta uñe trate. ");
INSERT INTO sabNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ba bai kle ta olire tanre sugekare Chubege bai kle skwatige mo ta dbe jiske ba kle age me no Chube dollale gdale, ba ulita bai kaire kle toi ene ba salengwli kwian kle chage teru ngle gaba dbe kare. Cha ta ba chudaboakalin cha ta ba ta gbakalin no Chube ole ba ta gbe suga no diali, ene ba me chege ta olire dare. ");
INSERT INTO sabNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ba takalin cha ba chudaboi ba cha gerua gadale ulia, ba mo ta gbadale age cha gerule kare, kaire ba geru jwandale cháge cha kle toi ta mine kare ole kwian ulita ole. Cha me kle ka boi kwian ole ta skochie ole, kaire cha me mo gbe tangle kwiandi, me ene, cha kle mo ta dbe no kwian ulita ole, cha ta ama ulita chudaboakalin diali. ");
INSERT INTO sabNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ba mo ta gbadale age no cha gerule kare diali gire cha be kira kete bage age ene, ene mi skwen mnoare bage toi no trate cha takalin kare —Jesu gerudu ene ulita kwian ole. ");
INSERT INTO sabNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","E suiale chui gbaite undege chuiage Jesu kledu chage trigoske tangle deage ule kwian geru jwannga amage ulita ole, kwian geru jwannga ulita bli ole, malen ama ulita mo gbu trigo dabe bulu ite gutadale gire ama trigogba gutu. ");
INSERT INTO sabNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Kwian fariseo mneite gwagedu kwian geru jwannga Jesuge ulitadi ama kle lle boi kare deage undege chuiage gire kwian fariseo gerudu Jesuge: —Gwagede kwian geru jwannga bage ulitadi, ama kle age me no Chube gerua Moisés nu degaba unsuialin dollale. Uñale bage Moisés chadalla e giti geru kle gbaba che alin che me ñage lle boi undege chuiage, ¿mineade ba kle geru jwannga bage ulita chuge ngwadi lle boi deage undege chuiage? ");
INSERT INTO sabNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesu jaindunga kwian fariseo kalen: —¿Ba ulita me nu chada batabanga che chugagwalla unsuialin David agedu giti? Chui gbaite David ule ama chagemanalla ulita ole bli ole tanre, gire ¿ama agedu mine? ");
INSERT INTO sabNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Uñale ba ulitage David jo gwa u gerungwa Chube olege ule ama chagemanalla ulita ole, u ege gwa pan gbakle, pan e chegedale Chube gwa giti diali, Chube gerua kle gbaba kwian ulita alin geru e gerule kwian gerunga Chube ole daba alin ama alin allabi ñage pan e gute, ni kwian na gdaite ñage pan e gute. Agwa David bli ole tanre ama pan e gutu kaire ama pan e ketu kwian ulita kledu chage ama olege gutadale. David pan e gutu Chube gwa giti agwa ama me boidu dale, Chube me ama gbu jiske ama pan e gutu gdale. ");
INSERT INTO sabNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Ba me Moisés nu Chube gerua degaba unsuialin batabanga kwian gerunga Chube ole daba alin giti? Uñale ba ulitage chada e gerule kwian gerunga Chube ole me kle undege chuia gai undegangwa agwa ama me chege jiske e gdale. Moisés chadalla gerule kwian gerunga Chube ole daba alin ñage lle boi Chube alin u gerungwa Chube olege undege chuiage, Chube gwa giti ama me jiske dale lle boi undege chuiage gdale. ");
INSERT INTO sabNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","7","Ba ulita kle tañachuge diali Moisés nu Chube gerua degaba alin giti daba gbe jiske geru e giti, agwa cha gerule ba ulita ole, geru ma kweri geru ege kle baske, ba geru e gbadale gdadi, e cha gerua. Cha me kle tañachuge diali kwian gbe jiske kwian me kle age ulita Moisés chadalla gerule kare gdale, cha tai dage kwian ulitage, ene kaire ba ulita mo ta gbadale no daba na ole, Chube gerua kle degaba unsuialin gerule e giti, chada e gerule: “Chube gerudu: ‘Cha me takalin ba bda gweda cha gwa giti age no cha ole alin allabi. Agwa kaire cha takalin ba tai dage daba nage diali, ba agedale no ama alin.’ ” Chube gerua degaba gerule ene, geru e sugedu bage ulia ba me kwian geru jwannga chage gbe jiske ama trigo bulu itu undege chuiage gdale, Chube gwa giti ama me jiske dale. ");
INSERT INTO sabNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Cha gerule ba ulita ole, Chube cha kagu nga dba ai giti kwian kare, ama cha gbu undege chuia mauña, malen cha ñage gerule kwian ole kwian llema boadale undege chuiage llema me boadale undege chuiage —Jesu gerudu ene ulita kwian fariseo mneite ole. ");
INSERT INTO sabNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jesu jo chage dare jo chke u mo litangwa Chube gerua jwanngwage. ");
INSERT INTO sabNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ne ngwadi kwian onbre gdaite oga kledu, ama oga ko ole ko kwebanga. Kwian fariseo mneite kledu eni gwa u ege, ama ulita tadu Jesu gbakalin jiske lle boi undege chuiage gdale, malen ama geru kadu Jesuge: —Geru kle degaba che me ñage lle boi chui undege chuiage. Nege chui undegangwa che alin, ¿che ñage kwian oga dodade chui aige o me? ");
INSERT INTO sabNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesu jaindunga kwian fariseo ulita kalen: —Ale gerule ba bda oveja gdaite molen, bda e joge sklienga blebitaske undege chuiage, ¿ba be bda e jwen keda blike chui e amañage undege chuiage o ba be lle boi chuia manade gire ba be bda jwen keda? Ba mi manade dale, ba be tai dage bda skliebanga blebitaskege gire blike ba be ama jwen siere ama kle skliebanga ngwadige. Ba age ene gire kwian mi gerule badi ba agedu me no. ");
INSERT INTO sabNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Chube gwa giti kwian ma ñanaske ngle lle bdalege, malen cha gerule ba ulita ole, che ñage age no daba na chudaboadale undege chuiage, che age ene undege chuiage che kle age no Chube gwa giti. ");
INSERT INTO sabNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jesu gerudu ene kwian fariseo ulita ole gire gerudu kwian oga ole: —Mo ko kwebanga kwrida trate. Onbre mo ko kwriu Jesu gerudu kare gire onbre ko kwebanga jo chkeni no trate ko gdaite kare. ");
INSERT INTO sabNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Jesu onbre ko kwebanga dodadu undege chuiage kwian fariseo gwa giti, e giti kwian fariseo ulita ta skochiu tanre Jesudi jo siere blike u ege, ama ulita mo teun Jesudi mo ta gbu ule Jesu gweda Jesu agedu gdale. ");
INSERT INTO sabNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Uñadu Jesuge kwian fariseo ulita ta ama gwakalinda, malen ama jo siere ne ngwadige. Kwian tanre chagedu Jesu nate, kwian e ulitaske kwian oga tanre kledu, Jesu kwian oga e ulita dodadu. ");
INSERT INTO sabNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Jesu gerudu kwian e ulitage: —Ba me cha trage ni kwian gdaite ole cha ba dodadu giti. ");
INSERT INTO sabNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ai ulita boidu ene Chube gerua degaba gerule kare, kwian Chube gerua ketanga ka jwankle Isaías Chube gerua degu unsuialin tangle, chada e gerule ene Jesu giti: ");
INSERT INTO sabNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Chube gerudu: ‘Kwian ai gdaite lle boanga cha alin, cha no no ama ole, cha ama gau cha gerua dbe kwian alin, nga suga noare chadi ama giti. Cha be mo Oña gbe diali ama tale, ene cha Oña kirallaske ama be cha gerua trage kwian me cha uñe ole nga ulitage, ama be geru kete kwian ulitage kwian ñage tien gitiru ji chugege agedu me no gdale ñage chege no trate cha gwa giti. ");
INSERT INTO sabNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Kwian ai lle boanga cha alin be gerule ta no giti diali kwian ulita ole, ama mi ngaute kwiandi ta skochie ole, ama mi kira bate ongoru ongoru cha gerua gdale mi ka boi kwian ama dollale ole, ama mi mo kalla itenga, kwian mi ama keruchuge gerule keru kweri ole mo giti mo gbale kweri kwian na gwa giti. ");
INSERT INTO sabNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","21","Kwian ai lle boanga cha alin be age no kwian ulita alin be kwian ulita chudaboi. Kwian gweale kle boi tanre me no kle ta olire tanre, gweale ta chagekalin no trate cha gwa giti cha takalin kare agwa me ñage, kira me. Kwian kle boi ene ama salengwli eske chege bedre chitedalenga kare, kaire ama salengwli jichra chege bedre jogedaleda kare. Kwian ai lle boanga cha alin mi kwian ene gbe boi ma tirare kwian kle boige, me ene, ama be kwian ene ulita chudaboi be ama kira gbe, be kwian ta gbe no cha ole. Kwian ai lle boanga cha alin, ama giti be chke uñale kwian nga ulitage kwian ñage cha uñe ñage tien gitiru ji chugege agedu me no ulita gdale, kwian ai giti kwian tanre be cha gerua gai ulia be mo ta gbe chage no trate cha takalin kare. Chui bdaglige kwian ai lle boanga cha alin be kirachke cha dolla ulitadi be ji gbe kwian ulita alin bai me mo ta blite cha ole.’ ” Isaías Chube gerua degu ene Jesu giti. ");
INSERT INTO sabNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Jesu kledu ngwadige kwian onbre jwligebanga dule, dolla nu onbre e gbaba jwligebanga malen ama gwagwa me keru me. Jesu dolla kagu siere onbre ege gire onbre jo chkeni noni, ama ñadu gerule kaire ñadu ten. ");
INSERT INTO sabNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Kwian ulita gwagedu boi enedi chegu tañachuge Jesudi, ama geru kadu moge ongoru ongoru Jesu giti: —¡Kwian e kira molen tanre kwian oga dodade ene! ¿Ama che chugagwalla unsuialin David oindalla Chube be kage che alin che chugagwallale? ¿Ama e? ");
INSERT INTO sabNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kwian fariseo ulita kle ne ngwadi geru e keruchuge gire ama ulita gerudu Jesudi: —Dolla chugagwalla Satanás kle kira kete amage, kira e giti ama kle dolla na kage siere kwian jwligebangage. ");
INSERT INTO sabNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesuge uñale kwian fariseo kledu mo ten me no ulita amadi gire Jesu gerudu ama ulita ole: —Cha gerule ba ulita ole, kwian chugagwalla nga gdaitemu mo tke dole kwian ulita kle toi nga amañage ole, ama kwian ulita gbe kira bate modi ongoru ongoru, ene bdagli kwian be mo gweda ulita, chugagwalla be chege gballa ama mi chege kiraske. Kaire kwian toinga una gdaitre alinge, kwian e chugagwalla ama ulita gbe kira bate modi ongoru ongoru ene bdagli chugagwalla be chege gballa ama mi chege kiraske. Ene kaire kwian toinga u gbaitre alinge kira bate modi mo bitalla gwa ole ulita, bdagli kwian e ulita be joge toi sugekare gdaite gdaite gire u mauña be chege toi gballa ama mi chege kiraske ama gdaitre alin chudaboanga me. ");
INSERT INTO sabNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","E ene ulia cha kle gerule kare, ¿mineade ba kle tañachuge dolla Satanás ñage mo kiralla kete chage amaña chudaboangalla kage siere kwiange? Kwian agenga Satanás kiralla giti me kle dolla chugagwalla Satanás chudaboangalla kage siere kwiange, Satanás me ta agekalin me no ene mo chudaboangalla ole. Dolla chugagwalla Satanás mo tke dole mo chudaboangalla ole mo gbe kira bate modi daba kage siere kwiange, dolla Satanás age ene mo chudaboangalla ole ama mi chege kiraske kwian gbanga age me no Chube dollale. ");
INSERT INTO sabNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ba ulita tañachuge cha kle dolla kage siere kwiange Satanás kiralla giti, ba geru kade ba bitallage ba bitalla bai kle dolla kage siere kwiange, geru kade amage chema kle kira kete amage dolla kage siere kwiange, gire ama be gerule ba ole ama me kle dolla kage siere kwiange dolla kiralla giti. Ba bitalla be gerule ene ba ole, gire e giti ñage suge trate bage ba me kle gerule ulia cha giti. ");
INSERT INTO sabNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Cha me kle dolla kage siere kwiange Satanás kiralla giti, me ene, Chube Oña kiralla giti cha kle dolla kage siere kwiange, e giti nege chkedale uñale ba ulitage ulia Chube cha kagu ba ulitaske aini age ama kiralla giti. ");
INSERT INTO sabNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Cha gerule ba ulita ole, kwian gdaite ta jogekalin gwa onbre kiraske ullage skwe boi lle ulitage onbre e ngeru, kwian skwe boanga e chegedale ma kiraske onbre lle mauñage ene kwian skwe boanga ñage onbre lle mauña gai ko luge kejre, ene kwian skwe boanga ñage lle ulita dbe lle mauña ngeru ama takalin kare. Agwa skwe boanga me kira molen lle mauña ko luge ama me ñage skwe boi lle mauña ngeru. E kare ene Satanás kiraske tanre agwa cha ma kiraske dolla chugagwalla Satanáge, Chube kiralla giti cha kirachke diali Satanádi, cha Satanás chudaboangalla kage siere kwiange. ");
INSERT INTO sabNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Cha gerule ba ole, kwian bai me kle cha bale ama kle cha dollale, kwian ene me kle cha gerua gai ulia me kle cha gerua kete daba nage, ama kle daba na gbe kige cha geruadi. ");
INSERT INTO sabNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Cha geru ai kete bage kaire, ba ulita cha keruchuge no. Kwian bai age me no kaire gerule me no Chube dollale, kwian e mo ta blite Chube ole gire Chube kwian ene agedu me no kaire gerudu me no Chube dollale talla mlienga ulita. Agwa kwian bai kaire gerule me no Chube Oña dollale, Chube me kwian gerule me no ene talla mlienga dale. ");
INSERT INTO sabNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Cha chiu nga dba ai giti kwian kare, nege cha kle chage aini kwianske, kwian bai gerule me no cha dollale, gire bigwa kwian e mo ta blite cha ole, kwian ene gerudu ulita me no cha dollale Chube talla mlienga. Agwa kwian bai gerule cha kle age dolla Satanás kiralla giti, kwian ene me kle gerule me no cha alin allabi dollale agwa kaire ama kle gerule Chube Oña dollale, Chube me kwian gerudu me no ene talla mlienga dale. Kwian bai gerule me no Chube Oña dollale ama chege jiske tanre Chube gwa giti diali dale alin, chui bdaglige kwian ene be chege ji chuge diali chui tangle ama gerudu me no Chube Oña dollale gdale —Jesu gerudu ene kwian fariseo ole. ");
INSERT INTO sabNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Jesu gerudu dare kwian fariseo ulita ole: —Gli kaire kaire chke uñale nate gba giti, gli no alin ñage gbachie no, gli me no me ñage gbachie no. ");
INSERT INTO sabNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","35","Ba ulita kwian agenga me no me no, diali ba ta agekalin me no Chube dollale, ba ta me no molen, malen ba me ñage gerule no Chube takalin kare, ba ulita salengwli gli gbachie me no kare. Kwian ta no kle gerule no, kwian ta me no kle gerule me no. Kwian kle tañachuge mo tale kaire kle gerule kle tañachuge kare. ");
INSERT INTO sabNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","37","Cha gerule ba ulita ole, chui bdaglige Chube be gerule kwian bai ulita jiske ama gwa giti, chui ege kwian kaire kaire be chke uñale nate kwian gerudu giti nga dba ai giti. Ba bai gerudu sugaska jain jain ba ta me no, chui bdaglige ba be chege jiske Chube gwa giti ba gerua ngwale ulita giti, geru e kbiale ba be boi daga ngwale tanre. Agwa ba bai me gerudu jain jain ba gerudu no Chube takalin kare, ba ta no, chui bdaglige ba be chege no trate Chube gwa giti, Chube mi ba gbe ji chuge, agwa Chubege uñale ama be gerule ba ulita giti ba jiske o ba me jiske ama gwa giti —Jesu gerudu ene kwian fariseo ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kwian fariseo mneite kaire kwian daba tkanga tangle Moisés chadalla giti mneite gerudu Jesu ole: —Kwian tkanga tangle geruge, ba kle gerule Chube ba kagu nga dba ai giti, cha takalin nege ba lle daga ngwale no kweri dodade kwian me ña dodade mo kira giti kare, ba lle ene dodade cha ulita gwa giti, ene be chke uñale trate cha ulitage ulia Chube ba kagu ba kle age Chube kiralla giti. ");
INSERT INTO sabNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesu jaindunga: —Ba ulita kle toi chui aige ba kwian me no me no, ba ulita agenga me no, cha agedu no ba ulita gwa giti, agwa e giti ba me kle cha gai ulia. Ba kle cha kage lle daga ngwale no na dodade ba gwa giti ene ba gerule ba be cha gai ulia Chube cha kagu nga dba ai giti, agwa nege nege cha mi age ba takalin kare. Chui be chke gire cha be boi ba ulita gwa giti salengwli kwian Chube gerua ketanga unsuialin kada Jonás boidu kare, chui ege be chke uñale ba ulitage ulia Chube cha kagu. ");
INSERT INTO sabNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Cha chiu nga dba ai giti kwian kare, Chube cha kagu kwian kle toi chui aige alin salengwli Chube Jonás kagu kwian unsuialin toinga una Nínivege alin kare ama ulita ta gbe agedu me no giti. Jonás toidu chui gbamai ngwe kweri kweri tadi gire ngwe Jonás mliunga kedagu gwade, e giti chku uñale kwian ngle toinga Jonás suialege ulia Chube Jonás kagu Chube gerua trage kwian ole. Ene kaire cha be boi, cha gwabeda, cha be chege dbiske chui gbamai gire Chube be cha jaba gbeni gwade. Cha be boi ene gire be chke uñale trate ba ulitage Chube cha kagu. ");
INSERT INTO sabNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Chui bdaglige Chube be ji gbe kwian agenga me no ulita alin, chui ege kwian unsuialin toinga una Nínivege be meñe kwian ulitage. Unsuialin Jonás jo Chube gerua kete kwian una Nínivemu ulitage, kwian Nínivege Jonás gerua keruchugu no, kwian mo ta blitu Chube ole jo siere ama kledu age me no Chube dollale ulitage. Cha gerua ma kweri Jonás geruage, nege cha agali kle gerule baske aini agwa ba me ta cha gerua gakalin ulia, malen chui bdaglige kwian una Nínivemu be ba ulita kle toi nege tangle gbe jiske Chubege ba me cha gerua gau ulia gdale. ");
INSERT INTO sabNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Chui bdaglige Chube be ji gbe kwian agenga me no ulita alin chuia, chui ege kaire muinga gdaite nga kada Sabámu be meñe kwian ulitage, muinga e kwian nga Sabámu chugagwalla unsuialin. Muinga ege geru chku uñale kwian israelita chugagwalla unsuialin kada Salomón giti Salomón ta molen tanre, malen unsuialin muinga e jo bate bate Salomón jwiage Salomón gerua keruchugale, muinga e jo ene Salomón gerua nate. Cha gerua ma kweri Salomón geruage, nege cha agali kle gerule baske aini agwa ba me ta cha gerua gakalin ulia, malen chui bdaglige muinga e be ba ulita kle toi nege tangle gbe jiske Chubege ba me cha gerua gau ulia gdale. ");
INSERT INTO sabNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jesu gerudu dare kwian fariseo gweale ole kaire kwian daba tkanga tangle Moisés chadalla giti gweale ole: —Nege tangle ba ulita kle boi salengwli kwian jwligebanga dolla kote kare. Dolla joge siere kwiange gire dolla chage nga gballage nga jinade undegangwa, nga me skwen amage, ");
INSERT INTO sabNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","gire ama tañachuge: “Cha be jogeni naskuni cha kwian jigu ngwadi, cha be jogeni toi ama tale nakwaite.” Gire dolla joge chkeni kwian e ngwadi, kwian e tale skwen dollage salengwli u gballa kare, nga kle litaba trate ulita, u e kle biale kwian alin toingwa. ");
INSERT INTO sabNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Kwian ta skwen ene dollage u gballa biale kare, gire dolla e joge dolla na tirare gdaguke jwen toi ule ama ole kwian e tale, bdagli kwian e boi ma dare ngeruguge. Ba ulita agenga me no kle toi nege tangle be boi kaire cha gerudu boidu kwian ai giti ole kare, ba cha gerua keruchuge agwa gire me cha gerua gai ulia malen ba be boi ma daga ngwale kledu toi ngeru karege. ");
INSERT INTO sabNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesu kledu gerule ene kwian ole ne ngwadi gire Jesu chebia ule Jesu daballa ole chku goga chegu manade goga tadu geru tragakalin Jesu ole. ");
INSERT INTO sabNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Kwian gdaite jo gwa gerule Jesu ole ama giti, ama gerudu: —Ba chebia ba daballa ulita kle goga, ama ta geru tragakalin ba ole. ");
INSERT INTO sabNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jesu gerudu kwian geru dbanga ole: —Cha be gerule ba ole chema ulia cha chebia chema ulia cha daballa. ");
INSERT INTO sabNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Gire Jesu ko itu kwian geru jwannga amage ulitadi gerudu: —Ai cha chebia kare kaire cha daballa kare. ");
INSERT INTO sabNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kwian bai age cha Ñenua Chube takalin kare, kwian ene cha daballa kare cha ibotea kare kaire agwe cha chebia kare, ama cha bitallanu ulia, cha no no ama ulita ole —Jesu gerudu ene ulita. ");
INSERT INTO sabNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Jesu kledu gwa kwian tke tangle gire chui e amañagebi Jesu jo siere u ege jo chke chibitage toidu dba chibita kagda giti. ");
INSERT INTO sabNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ne ngwadi kwian litedu tanre Jesudi, nga me chegu Jesu alin toingwa malen Jesu jo chiga du kledu ne ngwadige, Jesu toidu dba du toli, kwian ulita chegu kedagu Jesu keruchuge. ");
INSERT INTO sabNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Gire Jesu geru tanre ñachugu kwiange, ngeru ama geru ñachugu chude giti, ama gerudu kwian ole: —Cha gerule ba ulita ole chude drennga giti, kwian jo chude drennga deage, kwian jo chke deage, ama chude ngle dreunnga kote. ");
INSERT INTO sabNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Kwian e kle chude drennga kote, gire chude e gweale jo chke dba jon jegwale, bdada chiu, bdada chude gutu. ");
INSERT INTO sabNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Chude na gweale jo chke dba dbi arale ke giti ngwadi, chude e numachiu blikeare, agwa me dbi uda alin malen chude e me sera toiduda dbiske no, ke kle, chude me ñadu sera joge dbiske no. ");
INSERT INTO sabNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Chudenuma chku ngaña agwa chui jute kote chudenuma kwedunga junbatu jokeda ama me sera jo dbiske no kbiale. ");
INSERT INTO sabNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Chude na jo chke dba drinkin sera tanre ngwadi, chude gwatigu agwa drinkin tigedu ule chudenuma ole, drinkin chudenuma guda, chude me tigedu chude me gbachiu, drinkin kote chude jokeda ulita. ");
INSERT INTO sabNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Agwa chude na jo chke dba dbi no giti, chude e gwatigu no gbachiu no ngle. Chude skute chuia chku gire chude e nu gbachieba ngle, chude bulu gweale gbachiu ngle ngle chude cien bulu gdaitege, chude bulu gweale na gbachiu ngle chude sesenta, chude bulu gweale na gbachiu no chude treinta. ");
INSERT INTO sabNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Cha kle geru ai ñachuge ba alin, ba me geru ai keruchuge alin allabi mo ologe, agwa kaire ba ulita mo ta gbadale geru ai gbe gdadi, ba tañachugadale lledale cha kle geru ai chude giti ñachuge ba ulita alin. ");
INSERT INTO sabNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jesu geru ñachugu ene kwian ngle ulita alin gire kwian geru jwannga amage Jesuge ulita mo litu Jesudi, geru kadu Jesuge: —Ba gerudu giti kwian ole, ¿geru e mine? Me suge cha ulitage mineade ba geru ñachugu kwiange chude giti. ¿Mineade ba me geru gbu chke uñale nate trate kwiange Chube giti? ");
INSERT INTO sabNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesu jaindunga: —Ba ulita kle cha gerua gai ulia malen Chube kle ba ta gbe chke cha kle gerule giti, ene geru e giti kle suge trate bage kwian bai kaire cha gai ulia mo Chugagwallale kwian ene chege no trate Chube gwa giti. Kwian na me kle cha gerua gai ulia, ama alin cha kle geru ñachuge, kwian geru e keruchuge agwa geru e ulita skwen mnoare amage, geru e me suge amage dale. ");
INSERT INTO sabNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kwian bai kaire cha gerua gai ulia cha gerua manade no mo tale, kwian ene mi ta jogenga Chube geruage, kwian enege cha gerua be suge ma ngle diali, Chube be kwian ene chudaboi be kwian ene ta gbe suge ma ngle cha gerua giti. Agwa kwian bai kaire me mo ta gbe cha gerua gai ulia, kwian ene tale cha gerua gweale kle, agwa ama me kle mo ta gbe tañachuge geru e giti malen ama be ta jogenga cha geruage ulita, ama be chege kwian me cha gerua keruchugaba kare. ");
INSERT INTO sabNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kwian ene me cha gai ulia malen cha kle geru ñachuge ama alin, geru me suge amage. Kwian ene kle gwage chadi cha kle lle tanre no dodade, agwa ama chege kwian gwagwa me kare, me suge amage cha kle lle e tanre no dodade ama gwa giti Chube kiralla giti. Kaire kwian ene kle cha gerua keruchuge tanre agwa ama chege kwian olo me kare, geru me suge trate amage cha kle gerule giti. ");
INSERT INTO sabNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Kwian ene kle boi Chube gerua degaba unsuialin gerule kare, kwian Chube gerua ketanga ka jwankle Isaías Chube gerua degu unsuialin, chada e gerule: “Chube gerudu: ‘Cha gerua tragabe kwian ole, ama be cha gerua keruchuge agwa cha gerua mi suge amage. Lle tanre no dodabe kwian gwa giti, ama be gwagedi agwa mi suge amage chema kiralla giti lle dodakle. ");
INSERT INTO sabNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kwian ene ulita mo ta gbu mnoare, ama me takalin cha gerua gbe gdadi. Ama kle mo olo jege cha gerua ngeru, ene geru me suge amage. Mo gwagwa giti kwian kle ten lle no dodakledi, agwa me gbakalin gdadi mo tale. Ama kle mo ta gbe ene ulita malen ama me ñage mo ta blite cha ole. Cha ta ama chudaboakalin mo ta blite chage cha ole agwa ama me takalin mo ta gbe siere ama kle age me no gitige.’ ” Isaías Chube gerua degu ene kwian me ta cha gerua gakalin ulia giti. ");
INSERT INTO sabNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","17","’Cha gerule ulia ba ulita ole, Chube kle age no no ba ulita alin malen ba ulita nga dbale suga no. Cha kle aini baske age tanre no ba gwa giti Chube kiralla giti, ba ulita mo gwagwa giti kle gwage Chube kle agedi, kaire mo olodi ba ulita kle geru Chubenu keruchuge. Kwian Chube gerua ketanga unsuialin kaire kwian ta no trate Chube gwa giti unsuialin, kwian ene ngle tadu gwagekalin Chube kle agedi ba ulita kle gwagedi nege kare, agwa e suiale kwian e ulita me ñadu gwage ba ulita nege tangle kle gwage Chube kle agedige. Kaire kwian e ulita tadu geru keruchugakalin ba kle geru keruchuge nege kare cha giti, agwa ama me ñadu geru ai kare keruchuge —Jesu gerudu ene kwian geru jwannga amage ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Gire Jesu gerudu dare ama chude drennga gerua ñachugu kwian alin giti, Jesu gerudu kwian geru jwannga ole: —Ba ulita cha keruchugadale no, cha geru ñachugu chude drennga giti, nege cha geru e gbe chke uñale bage cha gerudu kare giti. ");
INSERT INTO sabNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Kwian gweale kle boi Chube gerua ole salengwli chude jo chke dba jon jegwale kare. Kwian e Chube gerua keruchuge, agwa amage geru me suge trate, bigwa che dolla Satanás kwian ta gbe geru e chuge ngwadi, me geru gai jumale, Satanás kle age kwian ole salengwli bdada agedu chude ole kare, ene Chube gerua kle jogenga kwian tale. ");
INSERT INTO sabNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Kwian gweale kle boi Chube gerua ole salengwli chude joge chke dba dbi arale ke giti ngwadi kare. Kwian e Chube gerua keruchuge, ama kle geru e gai blikare nga suga no ole agwa ama me mo ta gbe ulia Chube ole me kle Chube gerua gai jumale ulia, malen ama tale geru me ñage tige no kiraske salengwli chude me ñage sera joge dbiske ke giti me ñage tige no kare. Kwian e Chube gerua gau ulia agwa me kira ole gwangerugudba geru e gai ulia, ama kle boi daga ngwale Chube gerua gdale, gire blikare ama Chube gerua chuge ngwadi, ama jogeni naskuni chage ngeru kare. ");
INSERT INTO sabNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kwian gweale kle boi Chube gerua ole salengwli chude jo chke dba drinkin sera tanre ngwadi kare. Kwian e kle Chube gerua keruchuge kle Chube gerua gai ulia agwa me kle mo ta gbe tañachuge diali Chube gerua giti no, ama kle mo ta gbe tañachuge tanre lle ngwale alin giti, ama ta igi jwankalin ngle mau alin, ama ta agekalin ulita ama takalin kare. Ama kle tañachuge ma ngle lle e kare giti Chube gerua gitige, malen Chube gerua kle jogenga ama tale, gire ene kwian me kira molen toi no Chube takalin kare ni ñage Chube gerua dbe kwian nage. ");
INSERT INTO sabNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Kwian gweale kle boi Chube gerua ole salengwli chude joge chke dba dbi no giti kare. Kwian e kle Chube gerua keruchuge, Chube gerua kle suge trate amage gire ama mo ta gbe ulia Chube ole Chube gerua gai ulia. Ama Chube chuge ngwadi age ama tale Chube takalin kare, ene Chube ama ta gbe chui gbaite gbaite kaire kairege ma ngle Chube gerua giti. Kwian ene mo ta dbe no diali Chube gerua kete daba na ulitage daba chudaboi Chube gerua giti, kwian Chube gerua ketanga ene giti kwian tanre chke Chube gerua gai ulia salengwli chude joge chke dba dbi no giti gbachie no kare, chude gweale gbachie treinta, na gbachie ma ngle sesenta, na gbachie ngle ngle cien. Ene kaire kwian bai mo ta gbe ulia Chube ole Chube gerua gai ulia diali, kwian ene giti kwian na tanre Chube gerua gai ulia mo tale —Jesu gerudu ene kwian geru jwannga amage ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesu geru na ñachugu chude giti kwian ngle kledu mo litaba chi kagda giti alin, Jesu gerudu: —Cha be geru na trage ba ole, ba cha keruchuge no. Chube chuia be chie gire Chube be chege kwian ulita Chugagwallale, chui ege Chube be gerule kwian ulita giti kwian bai jiske kwian bai me jiske Chube gwa giti, Chube be kwian ulita bai jiske gbe ji chuge kwian agedu me no gdale. Cha be geru ñachuge ba ulitage ai kare chui e giti: Kwian chude no tku dbige deage, kwian chude tku ulita, gire chude tkanga joni gudegu. ");
INSERT INTO sabNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ngajrege chude tkanga kle gbe kaire lle boanga ama alin ulita kle gbe, gire kwian na chude tkanga dolla jo skwlenre ngajrege giskagba me no skie chude noske gire kwian e joni kige. ");
INSERT INTO sabNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Chudenuma trendunga tigedu ama gbachiu gire giskanuma me no tigedu kaire ule chudeske. ");
INSERT INTO sabNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Kwian lle boanga chude mauña alin gwagedu giskanuma me no kle tigedi gire ama ulita jo gerule kwian chude mauña ole: “Cha chugagwalla, ba chude no tku deage, ¿mineade giskanuma me no gwatigu, kle tige ule chudeske?” ");
INSERT INTO sabNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Gire kwian chude mauña gerudu kwian lle boanga ole: “Kwian gweale ta me no che ole ama agedu.” Kwian lle boanga geru kadu: “¿Ba takalin cha joge giskanuma me no juge chudege?” ");
INSERT INTO sabNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Chude mauña jaindunga: “Ba me joge giskanuma me no juge, ba giskanuma juge chudege gire chudenuma no ñage chie keda ule kaire agwe. ");
INSERT INTO sabNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ma no che giskanuma e chuge ngwadi tige ule chude ole, che chude skute chuia manade ngwange, chui e chke gire cha be gerule kwian chude skutanga ulita ole ene: ‘Ngeru ba giska me no juge luge buluge gugadale, e ulita kle boaba gire ba chude skute nga tagla giti, ba chude e oge no gwa nga noge.’ ” Chude mauña gerudu ene lle boanga amanu ole —Jesu geru ñachugu ene kwian ulita alin. ");
INSERT INTO sabNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Kaire agwe Jesu geru ñachugu mostaza chudea giti, Jesu gerudu: —Cha geru na ñachuge ba ulita alin, geru ai giti sugedale bage nege kwian bedreare kle mo ta gbe ulia Chube gerua gai jumale cha kle gerule giti, agwa bdagli kwian ngle be Chube gerua gai ulia be Chube gai mo Chugagwallale, e salengwli kle boi mostaza chudea giti kare. Mostaza chudea ma soli jalin chude na ulitage skiadale dbige. Onbre joge deage chude e skie dbige gire chude e kle tige kle chege gli kweri kweri ngaña. Mostaza kle nangachie kweri kweri, gire bdada ngle ñage ugara gbe gli e nanga jegwale ulita toingwa. Ene kaire kwian bai Chube gerua gai ulia, kwian e Chube gerua trage kwian na ole, ene geru e chke uñale kwian na tanrege, gire bdagli kwian tanre be Chube gerua gai ulia be Chube gai mo Chugagwallale salengwli mostaza chudea soli tige joge kweri nanga tanre molen kare. ");
INSERT INTO sabNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesu geru na ñachugu kwian alin, Jesu gerudu: —Cha geru ñachuge bage ai kare: Muinga kle pan dodade levadura ole, ama levadura sidri tugenga harina tanreske gire bedre bedre harina uda be sie kweri dodadale panle. E kare ene kwian me Chube uñe be Chube gerua keruchuge, kwian be geru e gai ulia, geru e be tige ama tale, kaire Chube gerua giti bedre bedre kwian na tanre be Chube gai ulia mo Chugagwallale levadura sidri harina gbe sie kweri kare —Jesu gerudu ene ulita kwian ole Chube gerua giti. ");
INSERT INTO sabNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesu geru ngle ene kare ñachugu kwian tanre alin diali, geru e ulita giti Jesu kledu kwian tke tangle Chube giti. Jesu geru ñachugu ene ulita agwa me sugedu kwiange Jesu kledu gerule llema giti, kwian tanre tañachugu Jesu kledu gerule lle ngwale alin giti. ");
INSERT INTO sabNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Diali Jesu geru ñachugu kwian ulita alin kwian ta gbagda Chube giti, ai ulita boidu ene kwian Chube gerua ketanga kada Isaías Chube gerua degu unsuialin gerule kare Jesu giti, chada e gerule: “Chube nga ulita dodadu unsuialin tangle nge jondege, chui ege gwangerugu Chube gerua tanre chegu ogaba skwlenre kwian ulitage, agwa cha be geru e ulita trage kwian kle toi nege tangle ole geru ñachuge giti.” Isaías Chube gerua degu ene Jesu giti unsuialin tangle. ");
INSERT INTO sabNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jesu gerudubi ene ulita kwian ole gire Jesu joni gudegu ama kle toi ngwadi, Jesu jo chke gwa gire kwian geru jwannga amage ulita chku, mo litu amadige, geru kadu amage: —Ba geru ñachugu kwian ngle alin kwian chude no tku giti, kwian chude no tku gire kwian na jo giskagba me no skie chude eske. Ba geru e ñachugu kwian alin, geru e me sugedu chage, cha ulita takalin ba geru e trennga chage. ");
INSERT INTO sabNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesu jaindunga: —Cha gerule ba ulita ole, cha chiu nga dba ai giti kwian kare Chube gerua no ketale kwiange, cha chiu geru no Chube giti gbale kwian tale chude tkakle dbiske kare. ");
INSERT INTO sabNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nga dba ai ulita nga chude ngamale kare Chube gerua alin. Chude no, e kwian nu mo ta gbaba Chube gai mo Chugagwallale kare, kwian ene Chubenu be toi Chube ole. Giskanuma me no, e kwian me mo ta gbaba Chube gai mo Chugagwallale kare, kwian ene che dolla Satanánu. ");
INSERT INTO sabNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Kwian ta me no giskagba me no skianga ama che dolla Satanás kare. Cha be chieni chui bdaglige, chui ege cha be kwian chanu ulita dbe toi cha ole nga ngaña giti, e salengwli chude kle joge dabe kwian kle chude jwen kare. Lle boanga Chube alin nga ngaña giti tanre kwian litanga ole Chube alin, lle boanga Chube alin nga ngaña giti e ulita salengwli kwian lle boanga kle chude jwen kare. ");
INSERT INTO sabNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Giskanuma me no litakle ole tkakle jitaske gugadale, ene kare be boi kwian agenga me no Chube dollale ulita ole chui bdaglige. ");
INSERT INTO sabNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Chui ege cha be lle boanga Chube alin nga ngaña giti tanre kage ji gbe kwian agenga me no ulita alin, kwian agali kle age me no Chube dollale kaire kwian kle daba na gwabate age me no Chube dollale, lle boanga Chube alin nga ngaña giti be chie kwian ene ulita jwen gbale ji chuge agedu me no ulita giti. ");
INSERT INTO sabNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Lle boanga Chube alin nga ngaña giti be kwian agenga me no ene ulita kage nga dbigu giti jitaske, nga ege kwian e be boi tanre daga ngwale, e kote ama be chege olire tanre kaire be sui jwennga tanre mo giti nga tirare ngeru. ");
INSERT INTO sabNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Agwa kwian bai nu cha gerua gaba ulia bai nu mo ta gbaba age no Chube takalin kare, chui bdaglige kwian ene ulita be joge toi Chube ole be chege no trate ulita. Chui kle gwadenga no kare, ene kwian Chubenu be chege no Chube kle toi ngwadi, ama be toi diali Chube chralla giti. Ba ulita me cha gerua ai keruchuge alin allabi mo ologe, agwa kaire ba ulita mo ta gbadale geru ai gbe gdadi. ");
INSERT INTO sabNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jesu gerudu: —Cha geru na trage ba ulita ole, cha gerua chke uñale kwiange gire kwian bai cha gerua gai ulia kwian e be toi no ule Chube ole diali, Chube be chege ama Chugagwallale, e salengwli lle no no ñanaske tanre skwendu kwiange kare. Lle no ñanaske ogaba dbiske skwendu kwian onbrege agwa dbi e me ama dbia, dbi e kwian nanu. Nga suga noare onbre edi lle ñanaske e giti malen ama mo ta gbu dbi e gige mo alin. Ama lle ñanaske ogoda naskuni skwendu amage ngwadi, ama joni mo llea chbade ulita gire lle e ñana giti ama dbi lle ñanaske kledu ogaba ngwadi gigu, ene lle no no ñanaske tanre chegu amanu. Ene kare kwian Chube gerua keruchuge kwian mo ta gbe Chube gerua gai ulia, nga suga noare amadi Chube gerua giti, malen ama mo ta gbe ulia Chube ole, ene chui bdaglige ama ñage chege toi no Chube ole diali. ");
INSERT INTO sabNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Jesu gerudu dare: —Cha gerule ba ole, ba cha keruchuge no. Kwian bai cha gerua keruchuge cha gerua gai ulia, e salengwli kwian igigwagba kweri ñanaske gai mo alin kare. Kwian chagedu igigwagba no no ñanaske jinade nate gigadale. ");
INSERT INTO sabNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Bigwa gire igigwagba gbaite no no kweri ñanaske tanre ma no igigwagba na ulitage skwendu amage. Igigwagba ene skwendu amage gire ama joni mo ullage ama lle ulita amanu chbadu, lle e ñana giti ama igigwagba e gbaite no no gigu, ene igigwagba no no kweri ñanaske tanre chegu amanu. Ene kare kwian cha gerua keruchuge kwian mo ta gbe cha gerua gai ulia, kwian ene mo ta gbe ulia Chube ole, ene chui bdaglige ama ñage chege toi no Chube ole diali. ");
INSERT INTO sabNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Jesu gerudu: —Cha gerule ba ulita ole, kwian agenga me no me nu cha gerua gaba ulia, kwian ene ulita be ji chuge kweri chui bdaglige, e giti cha geru ai kare ñachuge ba ulitage: Kwian ngwe jwannga gdeba tku chiske gire ngwe tanre jo gdeba toli. ");
INSERT INTO sabNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Gdeba chku ete gire kwian ngwe jwannga gdeba jun keda kodi chi kagda giti, gire ama ngwe litu ole nate. Ngwe no gutadale kwian ngwe jwannga litu ole gbu sugekare, ngwe me no gutadale ama ngwe mliunga naskuni chiske. ");
INSERT INTO sabNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ai kaire be boi ene chui bdaglige, lle boanga Chube alin nga ngaña giti tanre be chie kwian agenga me no ulita jwen siere kwian no ulitage, ");
INSERT INTO sabNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","be kwian agenga me no ulita kage nga dbigu giti jitaske, nga ege kwian e be chege boi tanre daga ngwale, jita kote ama be chege olire tanre kaire be sui jwennga tanre mo giti nga jute tirareske. ");
INSERT INTO sabNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesu geru kadu kwian geru jwannga ulitage: —Cha gerudu ulita lle tanre giti ba ole, ¿geru e ulita sugedu bage cha kle gerule giti ba ole? Kwian geru jwannga jaindunga Jesu kalen: —Ima cha Chugagwalla, geru ulita sugedu chage. ");
INSERT INTO sabNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Gire Jesu gerudu: —Ulia geru ulita suge bage ba kle gerule kare, gire ba ñage kwian na tke tangle Chube gerua ulita giti no, ba ñage kwian tke tangle Moisés Chube gerua degu unsuialin giti kaire agwe ba ñage kwian tke tangle Chube gerua jagere cha kle trage ba ole nege tangle giti. Ba chege salengwli kwian u mauña kare. U mauña lle molen tanre, ama lle gweale juda molen lle gweale jagere molen, u mauña lle e ulita manade no lle e ulita oge no nga gwealege gwa, ene ama kle biale diali daba na chudaboi lle monu giti. Ene kaire ba kle Chube gerua unsuialin kaire Chube gerua jagere manade no ba tale, ene ba be kle biale diali daba na chudaboi geru e giti, ba be ñage kwian tke tangle Chube gerua unsuialin giti kaire Chube gerua nege jagere giti kwian ta gbagda suga no —Jesu gerudu ene ulita kwian geru jwannga amage ole. ");
INSERT INTO sabNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jesu geru ene ulita ñachugu lle tanre giti kwian alin gire jo sugekare nga ege, ");
INSERT INTO sabNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Jesu joni mo jwiage una ama manadre ngwadi, una ege ama kwian tku tangle Chube gerua giti u mo litangwa Chube gerua jwanngwage. Kwian ulita chegu tañachuge tanre Jesu gerua giti gire kwian ulita gerudu modi Jesu giti: —Ama kle gerule no tanre Chube giti, ¿ama geru e ulita jun baini? Ama ta ngle molen, ¿chema ama tku tangle tachke ngle ene? Kaire ama kle kwian oga dodade kle lle na tanre daga ngwale no dodade, ¿chema kirallaske ama kle age? ");
INSERT INTO sabNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Ama me che tigemanalla? ¿Kwian e ñenua me ka jwankle José gli drega dodanga lle tanrere? ¿Kaire ama chebia me ka jwankle María? Che ama daballa ulita uñe, ¿ama daballa me Santiago kaire José kaire Simón kaire Judas? ");
INSERT INTO sabNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Kaire ama ibotea ulita me kle toi cheske kaire agwe? ¿Agwa gire mineade geru ai ulita Chube giti kle chke uñale amage? ");
INSERT INTO sabNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Kwian gerudu ene Jesudige malen kwian me jaindu Jesu gerua gai ulia, sugedu kwiange Jesu kwian ngwale. Jesu gerudu kwian e ulita ole: —Cha gerule ba ole, kwian Chube gerua ketanga kle joge nga baini kairege kwian tke tangle Chube gerua giti, kwian nga emu kle kwian Chube gerua ketanga keruchuge kle ama gerua gai dage. Agwa kwian Chube gerua ketanga jogeni mo bitallaske mo jwiage ama manadre ngwadi, nga ege kwian me ama gai ngwange no, ni ama bitalla kle gwa ama gai kwian Chube gerua ketanga ulia kare, kwian me ama gerua gai dage ni kwian ama keruchugakalin —Jesu gerudu ene kwian ama jwiamu ole. ");
INSERT INTO sabNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kwian Jesu jwiage me Jesu gau ngwange no me Jesu gerua gau ulia, malen Jesu me lle daga ngwale no tanre dodadu kwian eske. ");
INSERT INTO sabNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","E suiale kwian kada Herodes ama kwian nga Galileamu chugagwalla rey, Herodes kwian gweale keruchugu gerule Jesu giti. ");
INSERT INTO sabNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Gire Herodege me chege no chema giti tra no kwian kle gerule, malen Herodes gerudu kwian lle boanga mo alin ole Jesu giti, Herodes gerudu: —Cha kle kwian keruchuge gerule no kwian kadakle Jesu giti. ¿E me Juan-Bautista jogebakeda amaña chkuni gwade? E amaña chkuni gwade malen nege ama kle age tanre no mo kiralla giti kwian ulita gwa giti —Herodes gerudu ene Jesu giti. ");
INSERT INTO sabNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Juan-Bautista kledu gwade suiale gire ama nu ka boaba tanre Herodes ole muinga kada Herodías gdale, muinga e Herodes daballanu kada Felipe muira. Herodes kle toi Herodías e ole mo muira kare, e giti Juan-Bautista nu ka boaba tanre Herodes ole, Juan-Bautista gerudu: “Chube gerua degaba unsuialin gerule ba me ñage toi ba daballanu muira ole mo muira kare, e giti ba jiske tanre Chube gwa giti.” Juan-Bautista gerudu ene Herodes ole gire Herodes skochiu tanre Juan-Bautistadi e gdale, Herodes kwian kagu Juan-Bautista gai Juan-Bautista ko luge tkale skage. ");
INSERT INTO sabNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Juan-Bautista kledu skage gire Herodes tadu Juan-Bautista gwakalinda Juan-Bautista nu geruba Herodías giti gdale, agwa Herodes kwachiu kwian nglea ngeru kwian e ulita kle Juan-Bautista gerua gai dage, kwiange sugedu Juan-Bautista ulia kwian Chube gerua ketanga dabage, Herodes kwachiu kwian ene ulita ngeru malen Herodes me ñadu Juan-Bautista gweda blike. ");
INSERT INTO sabNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Chui jo tangle gire Herodes nu mebanga chuia chku chui e olladre, chui ege Herodías jian jo skwen gdate kwian ngle kadaba chui ollade gwa giti. Herodege skwendu noare Herodías jian skwendu gdate no ene kwian ulita gwa giti, ");
INSERT INTO sabNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","malen ama gerudu Herodías jian ole: —Nga suga no chadi ba skwendu gdate noare cha ulita gwa giti, malen cha mo gerua ulia gbe ba alin nege Chube gwa giti kaire kwian ngle ai gwa giti cha be age no ulita ba alin ba takalin kare, ba takalin lle gwealege ba lle kade chage, cha be lle kete bage ba takalin kare. ");
INSERT INTO sabNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Chku uñale Herodíage Herodes gerudu giti ama jian ole, gire Herodías gerudu mo jian ole: —Ba Juan-Bautista chugabita kade Herodege batekwa giti. Gire Herodías jian mo chebia kerua gau dage ama agedu chebia gerudu kare, ama gerudu Herodes ole: —Cha takalin ba Juan-Bautista chugabita kete chage batekwa giti nege nege. ");
INSERT INTO sabNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","10","Chugagwalla rey Herodedi nga chiu olire tanre e giti, ama me tadu agekalin ene Herodías jian gerudu kare, agwa ama agedale, kwian ulita gwa giti Herodes nu gerubabi Herodías jian ole Herodías jian lle gweale kade ama be ketege. Malen Herodes kwian lle boanga gweale kagu age Juan-Bautista ole, Herodes gerudu lle boanga e ole: —Joga Juan-Bautista kle skage ngwadi, ba ama chuga tkenga gire ba chieni ama chugabita dbe aini batekwa giti, ba e kete Herodías jiange. ");
INSERT INTO sabNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Gire agedre ulita Herodes gerudu kare. Juan-Bautista chuga tkerenga dule Herodías jiange batekwa giti, gire Herodías jian Juan-Bautista chugabita ketu mo chebiage. ");
INSERT INTO sabNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Juan-Bautista guleda ene gire kwian geru jwannga Juan-Bautistage ulita jo Juan-Bautista jaba jwen ogadale keugage. Kwian geru jwannga Juan-Bautistage Juan-Bautista jaba ogo gire ama ulita jo Jesu kle ngwadi, ama geru ketu Jesuge boidu ulita Juan-Bautista ole giti. ");
INSERT INTO sabNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesuge chku uñale Juan-Bautista boidu ene, gire ama jo siere kledu ngwadi jo duge ule kwian geru jwannga amage ulita ole nga gballage sugekare kwian na ulitage. Agwa kwian ngle una tanremuge chku uñale Jesu jo siere nga ege gire ama ulita chagedu seradi Jesu nate. ");
INSERT INTO sabNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jesu jo chke chibita kagda giti ongoru, Jesu jo siere duge gwagedu kwian tanredi chage Jesu nate, Jesu taidu dage kwian e ulitage, kwian gweale oga kledu kwian ngleaske, Jesu kwian oga e ulita dodadu. ");
INSERT INTO sabNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nga jeredu gire kwian geru jwannga Jesuge ulita chku Jesudi gerudu Jesu ole: —Nga jo jere, nga ai che kle ngwadi nga gballa, bligda me nga aige kwian ulita alin gutadale. Noare ba gbi kade bdagli kwian ulitage ba ama ulita kage siere nga aige, ene ama ulita ñage joge una gwealege bligda gige mo alin gutadale. ");
INSERT INTO sabNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesu jaindunga: —Me no ama ulita kage siere me bliba, ba ulita agali bligda kete ama ulitage gutadale. ");
INSERT INTO sabNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Kwian geru jwannga Jesuge jaindunga: —¿Che kwian nglea ulita ulle llemadi? Bligda me ngle che ole kwian tanre alin gutadale, che pan molen gdatigale alin ngwe gdabokle alin allabi, bligda e me ñage kwiange ulita. ");
INSERT INTO sabNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesu gerudu: —Ba pan e kaire ngwe e kete chage. ");
INSERT INTO sabNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Jesu gerudu ene geru jwannga amage ole, gire Jesu kwian nglea ulita gbangu toi dba ngauda giti. Kwian ulita toidu dba gire Jesu pan gdatiga ngwe gdaboke gau kote, Jesu gwagedu nga ngaña giti, Jesu gerudu Chube ole bligda giti: “Cha Ñenua, noare ba pan ai ngwe ai ketu kwian ai ulita alin gutadale.” Jesu gerudu ene Chube ole, Jesu pan skutunga ngwe uda junnga, gire Jesu ngwe uda pan bita ketu kwian geru jwanngage girabatadale kwian ngle ulita ole. Jesu bligda gbu jriennga kwian e ulita alin gutadale. ");
INSERT INTO sabNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","21","Kwian ngle ulita blidu no, kwian onbre ngle cinco mil blidu, kaire muinga ngle kirogwa ngle blidu agwa ama me jo teanba, Jesu kwian e ulita ullu pan gdatigale alindi ngwe gdabokle alindi. Kwian ulita unchku no bligdadi gire bligda bita ngle cheguda, kwian geru jwannga Jesuge bligda bita e ulita litu ole ski kweri gbataboko giti gbaboke, ski e ulita chku ete bligda cheguda ole. ");
INSERT INTO sabNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jesu kwian ngle ullu ene, bigire Jesu gerudu kwian geru jwannga amage ulita ole: —Joga duge chibita tkenga tangle chkagu chi kagda giti. Cha be chege gbi jige bdagli kwian ngleage, gire cha be joge ba nate. ");
INSERT INTO sabNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kwian geru jwannga Jesuge ulita jo chage duge chiga giti, gire Jesu gbi jigu bdagli kwian ulitage, Jesu jo sugekare kwian e ulitage jo gballa jwichuga giti ngaña gerule Chube ole. Jesu kledu eni gballa gerule Chube ole gire nga jeredu. ");
INSERT INTO sabNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Nga jo jere gire kwian geru jwannga Jesuge jo bate duge chi bonga, mleuda kweri kledu tiennga kiraske dudi, chi kledu skwen bdugu tanre mleuda kote gire kwian geru jwannga ulita kledu chi bage blikare. ");
INSERT INTO sabNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Nga chiu kamalin ngwange bdugu Jesu jo chage seradi chiga giti kwian geru jwannga kle duge ngwadi ngnagu chi bonga. ");
INSERT INTO sabNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Kwian geru jwannga Jesuge ulita gwagedu Jesudi chage seradi chiga giti gire ama ulita kendunga tanre, ama ngautu kweri chru ole: —¿E llema? ¿E oñakwa kle chage? ");
INSERT INTO sabNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Gire Jesu gerudu ama ulita ole: —Ba me kennga, ba mo ta gbe kiraske, cha amaña kle chage. ");
INSERT INTO sabNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Jesu gerudu ene gire Pedro gerudu Jesu ole: —Cha Chugagwalla, ulia ba amaña kle chage, ba cha gbe chage seradi kaire chiga giti joge ba ngnagu. ");
INSERT INTO sabNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesu gerudu Pedro ole: —Bai cha gitigu chage seradi chiga giti. Gire Pedro jo siere duge jo chage seradi chiga giti Jesu ngnagu. ");
INSERT INTO sabNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pedro kledu chage no chiga giti Jesu ngnagu, agwa gire Pedro gwagedu chi skwen bdugu tanre mleuda kote gire ama kendunga. Ama kendunga gire ama jo chiske dbigu, ama ngautu Jesuge: —¡Cha Chugagwalla, cha be unjoge, ba cha jwen siere chige! ");
INSERT INTO sabNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Gire blike Jesu ama gau koge, Jesu gerudu ama ole: —¿Mineade ba me kle mo ta gbe cha gai ulia? Cha ñage kira kete bage chage no seradi chiga giti, agwa ba me mo ta gbu cha gai ulia, malen ba me ñadu chage seradi chiga giti cha kare. ");
INSERT INTO sabNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Jesu jo ule Pedro ole du tadi gire mleuda me chegu tiennga dare, chi chegu ngwedi. ");
INSERT INTO sabNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Boidu ene gire kwian geru jwannga Jesuge ulita Jesu gau dage gerudu no no Jesu ole: —Ulia ulia ba Chube Kirolla. ");
INSERT INTO sabNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Jesu jo chage duge gwangerugu kwian geru jwannga amage ulita ole, ama ulita jo chke chi kagda giti ongoru nga kadakle Genesarege. ");
INSERT INTO sabNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Kwian tanre nga emu gwagedu Jesudi gire chku uñale kwian e ulitage Jesu amaña chku ama jwiage, kwian e giti geru jo chage nga ulita Genesarege Jesu kle ngmadi. Kwian tanre geru e keruchugu gire ama chiu kwian oga ulita dbe Jesu kle ngwadi dodale. ");
INSERT INTO sabNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Kwian daba oga dbanga ulita gerudu Jesu ole daba oga giti: —Noare ba oga chuge ngwadi ko chuge sidri ba ñometralladi alin allabi, chage suge trate oga ba chugedi ene daba oga be joge chke noni. Kwian chudaboi kadu ene Jesuge oga alin, gire kwian oga ulita bai kaire ko chugu alin Jesu ñometralladi, kwian ene ulita jo chkeni noni me chegu oga dare. ");
INSERT INTO sabNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Kwian fariseo mneite ule kwian daba tkanga tangle Moisés chadalla giti ngle ole chiu una Jerusalénge chku Jesu kle ngwadi gerule Jesu ole, kwian e ulita geru kadu Jesuge: ");
INSERT INTO sabNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—Che enusulian unsuialin geru gbu che kwian israelita ulita toidale giti, ¿mineade kwian geru jwannga bage me kle age geru e kle gbaba gerule kare? Kwian geru jwannga bage ulita me kle mo ko glige trate tanre ngeru blirege che enusulian unsuialin suia kare, malen cha ulita gwage ama kle age me no. ");
INSERT INTO sabNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesu jaindunga kwian e kalen: —¿Mineade ba ulita kle ba enusulian unsuialin suia gai dage ma no Chube gerua uliage? Ulia ba ulita kle ba enusulian unsuialin suia alin allabi gai mo alin agwa ba me kle Chube gerua ulia gai dage ba me kle age Chube takalin kare. ");
INSERT INTO sabNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Unsuialin Chube geru ketu Moisége degadale kwian ulita alin, chada e gerule: “Ba mo ñenua mo chebia gadale dage no.” Kaire chada na Moisés nu degaba kle gerule: “Kwian gerule me no mo ñenuadi kaire mo chebiadi, kwian na kwian bai gerule ene gwadaleda.” ");
INSERT INTO sabNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Moisés Chube gerua degu ene ulita unsuialin, agwa ba ulita agali me kle geru e gbe gdadi, kaire ba kle daba na tke tangle age nganake me age chada e gerule kare. Ba kle kwian ta gbe me mo ñenua mo chebia gadale dage no me ama chudaboadale me lle ketadale amage ama llea me gire. Ba kle kwian tke tangle gerule mo ñenua ole mo chebia ole: “Mama, tata, cha me ñage ba chudaboi, lle ulita chanu cha ketu Chubege, cha ole lle me ba chudaboagda.” ");
INSERT INTO sabNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ba kle kwian tke tangle age me no ene mo chebia ole mo ñenua ole ba kle age Chube gerua dollale, ba ulita nu Chube gerua mliabanga me mo ñenua mo chebia manade Chube geru gbu kare unsuialin tangle, ba kle ba enusulian unsuialin suia gai dage ma no Chube gerua uliage. ");
INSERT INTO sabNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¿Mineade ba kle gerule kate ba kle Chube gerua gai dage, gire ba me kle age ba kle gerule kare? Ba ulita ta me no. Kwian Chube gerua ketanga kada Isaías Chube gerua degu unsuialin ba ulita giti, chada e gerule: ");
INSERT INTO sabNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Chube gerudu: ‘Kwian ai ulita kle gerule ama kle cha gai dage, kle gerule ene ka giti alin allabi, agwa ulia ama me kle cha gai dage ulia mo tale, ama ta kle bate chage ama kle gerule alin allabi. ");
INSERT INTO sabNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kwian kle gerule ama kle cha gai dage mo Chubeale, agwa ngwale ama kle gerule ene, ama me kle mo ta gbe cha ole ulia age cha takalin kare. Kaire ama me kle daba tke tangle cha gerua ulia giti, agwa ama kle daba tke tangle geru ngwale giti ama agali kle tañachuge kare mo tale.’ ” Isaías chada degu ene Chube gerudu giti. ");
INSERT INTO sabNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jesu gerudu ene kwian fariseo ulita ole kaire kwian daba tkanga tangle Moisés chadalla giti ulita ole, gire Jesu kwian na ulita kadu mo gitigu ama keruchuge, Jesu gerudu kwian e ulita ole: —Ba cha keruchuge no, cha takalin geru ai suge trate ba ulitage: ");
INSERT INTO sabNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ni lle gdaite kwian kle gute kle kwian gbe me no jiske Chube gwa giti, agwa kwian kle tañachuge me no mo tale gire kwian kle gerule me no age me no ama kle tañachuge kare, e ulita kle kwian gbe me no jiske Chube gwa giti. ");
INSERT INTO sabNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Jesu gerudu ene kwian ulita ole gire kwian geru jwannga amage ulita chiu Jesu gitigu sugekare, geru kadu Jesuge: —¿Uñale bage kwian fariseo ulita ta skochiu mo gdale ba gerudu ama ole giti? ");
INSERT INTO sabNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","14","Jesu jaindunga: —Ima, uñale chage ama kle tañachuge me no mo tale chadi, agwa ba me tallade kwian e skochiu chadi giti, ama ulita chugene tañachuge ama takalin kare. Kwian e kle daba na tke tangle geruge, geru e me cha Ñenua Chube gerua ulia, geru e geru ngwale, cha Ñenua me kle geru e gbe ama tale tragadale daba na ole, agwa geru e kle chie kwian e agali tale, malen chui be chke gire Chube be age kwian e ulita ole be kwian gbe jiske ama kle daba tke tangle geru ngwalege gdale. Kwian e ulita kle chage kwian gwagwa me kare, kaire ama kle daba na kle chage kwian gwagwa me kare jonlla dbe, ene ama gdabonate me ten, me uñale amage ama kle chage baini, gire bdagli ama gdabonate joge chke dba dbiugage ama lentige boi daga ngwale tanre. Kwian fariseo ulita kle chage kwian ene kare, ama me kle Chube gerua ulia gai mo alin, kaire ama kle daba na tke tangle geru ngwalege enusulian suia giti, malen bdagli Chube be ama ulita gbe boi daga ngwale age ene ulita gdale. ");
INSERT INTO sabNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Jesu gerudu ene gire Pedro gerudu Jesu ole: —Ba gerudu sbaliga kwian ole bligda che kle gute me che gbe me no jiske Chube gwa giti, geru e me suge chage ba kledu gerule llema giti, cha takalin ba geru e trennga no cha ulitage. ");
INSERT INTO sabNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesu jaindunga Pedro kalen: —¿Ba ulitage kaire agwe geru e me suge? ");
INSERT INTO sabNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Sugedale bage ni lle gdaite che kle gute ñage che ta gbe chege jiske Chube gwa giti. Che blire gire bligda me kle joge chke che tale che ta gbagda age me no Chube dollale, che blire gire bligda joge che kdege, bigire bligda e kle joge tangle ulita, che kle mlienga. ");
INSERT INTO sabNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Agwa kwian kle tañachuge me no mo tale, talla e giti kwian kle age me no kle gerule me no ama kle tañachuge kare, talla e kle kwian gbe chege jiske Chube gwa giti. ");
INSERT INTO sabNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kwian tale bai kaire talla me no kle, kwian ene be mo ta gbe age me no diali ai kare ulita: Kwian daba gweda. Onbre mo jwanba mo chuge ke giti muinga na ole, muinga mo jwanba mo chuge ke giti onbre na ole. Onbre muinga me mo jwanba mo chuge ke giti. Kwian skwe boi daba ngeru. Kwian geru jinade daba ole. Kwian gerule me no daba nadi. ");
INSERT INTO sabNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Lle ai ulita cha kle ka jwen ba ole, e ulita kle chie kwian tale, e kle kwian gbe jiske Chube gwa giti. Agwa blire me ko gligaba tanre bitangle, e me kwian ta gbe jiske Chube gwa giti kwian fariseo kle gerule kare —Jesu gerudu ene ulita kwian geru jwannga ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesu jo chage dare kwian geru jwannga amage ulita ole una Tiro ngnagu una Sidón ngnagu, ");
INSERT INTO sabNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ama jo chke kodi una boke ege gire muinga gdaite toinga nga ege chiu Jesu ngnagu, muinga e me kwian israelita, ama kwian cananea, ama chku Jesudi, ama ngautu: —Ba kwian chugagwalla unsuialin David oindalla, uñale chage Chube ba kagu nga dba ai giti. Ba tai dage chage, cha jian jwligebanga dolla kote, ba cha jian dodade dolla kage siere amage. ");
INSERT INTO sabNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesu me jaindunga muinga kalen agwa kwian geru jwannga Jesuge jo kodi Jesudige, gerudu Jesu ole: —Cha takalin ba gerule muinga e ole muinga e kage siere chege. Muinga e kle che jugeda tanre, ama kle chie ngaute che nate tanre. ");
INSERT INTO sabNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesu gerudu muinga e ole: —Kwian israelita ulita bda oveja jogebanga kare, ama me Chube uñe, kwian ene alin Chube cha kagu nga dba ai giti, Chube cha kagu kwian israelita alin allabi chudaboi tke tangle Chube giti. ");
INSERT INTO sabNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Muinga e kwian me israelita, ama Jesu keruchugu gerule ene agwa ama me ta chugu gerule Jesu ole, ama jongnagwa skutu dba Jesu gwangnagu Jesu gai dage, muinga gerudu Jesu ole: —Ba kweri cha ba gai dage, cha takalin ba cha chudaboi. ");
INSERT INTO sabNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesu jaindunga: —Cha bitalla israelita alin cha lle no tanre boadale, ba muinga me israelita, cha ba chudaboi e chege salengwli bligda no jwennga kirogwa ngeru kare kete toge gutadale. ");
INSERT INTO sabNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Jesu gerudu ene agwa gire muinga jaindunga: —E ulia ba gerudu kare, agwa bligda jwna kle jwatenga to mauña kote, to kle bligda jwna jwen nate kle gute, e kare ene cha takalin ba age cha alin sidri, ba dolla kage siere cha jiange. ");
INSERT INTO sabNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jesu muinga keruchugu gire Jesu gerudu: —Muinga, ulia ba kle mo ta gbe cha gai ulia kweri, malen ba jian alin cha age ba takalin kare, ba jian jo chkeni no. Jesu gerudu ene gire blike muinga e jian jo chkeni no, dolla jo siere amage. ");
INSERT INTO sabNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesu jo siere nga ege, Jesu jo chke chibita kada Galilea kagdage, eni Jesu jo jwichuga giti toidu dba. ");
INSERT INTO sabNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kwian tanre jo Jesu nate daba oga daga ngwale tanre dbe Jesuge dodadale, kwian e ulita mo litu Jesudige, kwian jo oga ai kare dbe Jesuge: kwian me ñage chage trate, kwian gwagwa me, kwian ko kwebanga, kwian keru me, kaire kwian oga jingme na tanre kote ulita dule Jesuge, kwian ngle gwa giti Jesu oga e ulita dodadu. ");
INSERT INTO sabNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kwian ulita gwagedu Jesudi kwian oga dodade ene gire ama ulita chegu tañachuge tanre no Jesu giti. Kwian keru me Jesu ama gbu keru ole, kwian ko kwebanga Jesu ama ko gbu no trate, kwian sera kwebanga Jesu ama gbu chage trate, kwian gwagwa me ten Jesu ama gwagwa gbu ten no trate. Kwian ulita gwagedu Jesudi age no ene kwian alin gire kwian ulita gerudu no nga suga no ole Chube kwian israelitanu giti. ");
INSERT INTO sabNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesu kledu eni jwichuga giti kwian ngle ole gire Jesu kwian geru jwannga amage gdataboko giti gdaboke kadu mo gitigu, Jesu gerudu kwian geru jwannga ulita ole: —Cha tai dage kwian ai ulitage, chui gbamai kwian ai ulita kle cha ole aini, bligda ulita bidegu ama ole gire nege ama ulita me bligda molen gutadale. Cha me ta ama ulita kagakalin bliage gudeguni, ama ulita jogeni bliage, nga ñage jogenga ama ulita gwage bli ole jonkare, bligda kete ama ulitage gutadale. ");
INSERT INTO sabNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Kwian geru jwannga Jesuge gerudu Jesu ole: —¿Che age mine kwian ngle ulita alin bligda giti? Aini nga gballage kwian me kle toi, ¿chema ngwadi che joge bligda jinade kwian ngle alin gutadale? ");
INSERT INTO sabNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesu geru kadu: —¿Pan gdamangire ba kle chage dbe? Kwian geru jwannga jaindunga Jesu kalen: —Cha kle chage pan gdaguke dbe kaire ngwe soli gdamoite dbe agwa me ngle, bligda e me ñage kwian ulitage gutadale. ");
INSERT INTO sabNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jesu kwian ulita gbu toi dba dbi giti, ");
INSERT INTO sabNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","gire Jesu pan gdaguke gau kote kaire ngwe soli gau kote, Jesu gerudu Chube ole: “Cha Ñenua, nga suga noare chadi ba bligda ai ketu chage kwian ai ulita ullagda.” Jesu gerudu ene Chube ole bligda giti gire Jesu pan skutunga kaire ngwe uda junnga ketu geru jwannga ulitage girabatadale kwian ulita ole. Pan kaire ngwe jriendunga ngle kwian ulita alin gutadale. ");
INSERT INTO sabNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","38","Kwian ngle ulita blidu no, kwian onbre ngle cuatro mil blidu, kaire muinga ngle kirogwa ngle blidu agwa ama me jo teanba. Ulita blidu unchku no bligdadi gire pan bita ngle cheguda kaire ngwe bita ngle cheguda litre ole, ski kweri gbaguke chku ete bligda bita cheguda ole. ");
INSERT INTO sabNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jesu kwian ullu ene ulita gire Jesu gbi jigu bdagli kwiange kwian kaguni gudeguni, gire Jesu jo duge chi kagda giti ongoru una ka jwankle Magadán giti. ");
INSERT INTO sabNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Kwian fariseo mneite kaire kwian saduceo mneite jo Jesu kle ngwadi mo chuge Jesu ole, ama ulita gerudu Jesu ole: —Ba kle gerule mo giti Chube ba kagu nga dba ai giti, cha takalin nege ba lle daga ngwale no kweri kwian me ña dodade mo kira giti, ba dodade cha ulita gwa giti, ene be chke uñale trate cha ulitage ulia Chube ba kagu ulia ba kle age Chube kiralla giti. ");
INSERT INTO sabNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jesu jaindunga ama kalen: —Cha mi age ba takalin kare, ba cha keruchuge no. Ba ulita ta kle chke nga gbe gdadi noi be boi noi mi boi, ngabi ba kle gwage bogakwa chratigenga dabe no no nga ngaña gire ba kle gerule: “Nga be boi no”, gire kle boi ene ulia ba gerule kare. ");
INSERT INTO sabNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Kaire ngabebita ba kle gwage bogakwa gwalugenga jere ngaña gire ba kle gerule: “Nege nga be boi tira”, gire kle boi ene ulia ba gerule kare. Ba kle nga ngaña giti gbe gdadige, gire chke uñale bage nga be boi tira nga mi boi tira. E suge trate ba ulitage, gire ¿mineade ba me ñage mo ta gbe tañachuge trate ulita kle boi giti nege tangle baske? ¿Mineade me suge kaire ba ulitage cha kle age Chube kiralla giti cha me kle age Chube kiralla giti aini baske? ");
INSERT INTO sabNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ba ulita kle toi chui aige ba me kle mo ta gbe geru ulia gai ulia, ba ulita agenga me no, geru ulia me suge bage, cha agedu no kwian me dodaba cha e dodadu ba ulita gwa giti agwa e giti ba me kle cha gai ulia. ¿Lledale cha lle daga ngwale no dodade ba gwa giti? Ba me kle cha gai ulia Chube cha kagu nga dba ai giti, agwa nege nege cha mi age ba ulita takalin kare. Agwa chui be chke gire cha be boi ba ulita gwa giti salengwli Jonás boidu unsuialin kare, ene be chke uñale ba ulitage Chube nu cha kagaba. Jonás toidu chui gbamai ngwe kweri kweri tadi gire ngwe Jonás mliunga kedagu gwade, e giti chku uñale kwian ngle toinga Jonás suialege ulia Chube Jonás kagu Chube gerua trage kwian ole. Jesu gerudu ene gire Jesu kwian ulita chugu ngwadi, Jesu jo chage sugekare kwian geru jwannga amage alin ole. ");
INSERT INTO sabNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Kwian geru jwannga Jesuge ulita jo Jesu ole chibita kagda giti ongoru, kwian geru jwannga Jesuge ta jonga pan dbe gutadale duge. ");
INSERT INTO sabNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesu gerudu kwian geru jwannga ulita ole: —Cha gerule ulia ba ole, ba mo ta manadale chage ta giti kwian fariseo kwian saduceo ulitaske ba ulita me mo ta gbale levadura amanu gai mo alin pan dodagda. ");
INSERT INTO sabNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Kwian geru jwannga ulita tañachugu Jesu kle gerule levadura ulia giti pan dodagda gire ama gerudu modi: —Che me chiu pan dbe gutadale malen Jesu kle gerule ene che ole levadura giti. ");
INSERT INTO sabNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesuge chku uñale kwian geru jwanngage me sugedu Jesu tadu gerukalin giti, ama ulita tañachugu levadura ulia giti, me sugedu trate kwian geru jwanngage gire Jesu gerudu ama ulita ole: —¿Mineade ba kle gerule modi ba me chiu pan dbe gutadale? ¿Mineade ba ulita me kle cha gai ulia mo tale? ");
INSERT INTO sabNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Bage me suge cha ñage bligda kete ba ulitage? ¿Ba ta jonga ulita cha kwian ngle ullu bligda sidridi giti? Cha kwian onbre ngle cinco mil ullu pan gdatigale alindige, kwian e ulita unchku, gire ¿ba bligda bita cheguda litu ole ski gbamangirege? ");
INSERT INTO sabNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Kaire ba ta jonga cha kwian ngle cuatro mil ullu pan gdagukedi? Kwian e ulita unchku, gire ¿ba bligda bita cheguda litu ole ski gbamangirege? ");
INSERT INTO sabNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Sbaliga cha gerudu ba ulita ole ba me mo chuge ngwadi kwian fariseo kwian saduceo levaduralla gai pan dodale mo alin, ¿mineade me chke uñale bage cha me kledu gerule pan ulia giti ba ole? Cha kledu gerule kwian fariseo kwian saduceo gerua giti, ama gerua geru ngwale, geru e levadura kare, ba me ama gerua ngwale gai mo alin. ");
INSERT INTO sabNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Jesu gerudu ene batre chku uñale kwian geru jwanngage Jesu me kle gerule pan giti ni levadura giti, Jesu kledu gerule kwian fariseo kaire kwian saduceo kle kwian tke tangle gerua ngwalege giti, e giti Jesu kledu geru jwannga ta gbe chke ama ulita mo ta manadale geru ulia alindi Jesu kle gerule kare, ama ulita mo ta gbadale sugekare ulita kwian fariseo geruage kwian saduceo geruage. ");
INSERT INTO sabNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesu jo chage dare duge kwian geru jwannga ole, ama ulita jo chke nga ka jwankle Cesarea-Filipoge gire Jesu geru kadu kwian geru jwannga ulitage: —¿Kwian ulita kle gerule mine cha giti cha chema? ");
INSERT INTO sabNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Kwian geru jwannga jaindunga: —Kwian gweale kle gerule ba Juan-Bautista jogebakeda chkuni gwadeni. Kwian na kle gerule ba kwian unsuialin kada Elías chkuni. Kwian na kle gerule ba kwian unsuialin kada Jeremías jogebakeda chkuni gwadeni. Kaire gerukle ba kwian gweale Chube gerua ketanga unsuialin jogebakeda chkuni gwadeni. ");
INSERT INTO sabNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Kwian geru jwannga gerudu ene Jesu ole gire Jesu geru kadu dare ama ulitage: —Kwian na kle gerule ene cha giti, ¿agwa ba gerule mine? ¿Cha chema? ");
INSERT INTO sabNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simón-Pedro jaindunga Jesu kalen: —Ba Cristo, ba Chube gwade ulia Kirolla, Chube ba kagu nga dba ai giti kwian kare kwian jwen siere ji chugege agedu me no gdale. ");
INSERT INTO sabNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Gire Jesu gerudu Simón-Pedro ole: —Simón, ba Jonás kirolla, cha Ñenua nga ngaña giti agedu no ba alin, ama ba ta gbu chke suge ulia cha ama Kirolla, malen ba gerudu ene cha giti, ni kwian gdaite ba ta gbu suge ene. ");
INSERT INTO sabNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Cha gerule ba ole Simón, ba kalla na Pedro, ka e kle gerule “kechuga”. Ba kechuga kare, kechuga chege kiraske tanre diali, ene kaire ba be chege kiraske cha geruadi, ene ba giti kwian tanre be cha gerua keruchuge be cha gerua gai ulia, kwian e ulita be chege Chubenu. Ni jogeda ni che dolla Satanás ule mo chudaboangalla ulita ole be ñage kirachke kwian cha gerua gangadi, kwian ene be chege Chubenu diali, bdagli ama be joge toi Chube ole nga ngaña giti diali chui tangle. ");
INSERT INTO sabNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Cha be ba gbe kwian ulita cha gerua ganga chugagwallale nga dba ai giti. Cha kiralla giti ba be Chube gerua cha giti dbe nga dba ai giti kwianske, kaire cha kiralla giti ba be kwian tke tangle toidale mine nga dba ai giti Chube takalin kare. Kwian bai geru gai ba ama tke tangle kare, kwian ene ulita chege Chubenu, agwa kwian bai mi geru cha giti gai ba kle gerule kare, kwian ene me Chubenu. ");
INSERT INTO sabNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jesu gerudubi Pedro ole gire Jesu gerudu kwian geru jwannga gdataboko giti gdaboke ulita ole: —Ba me gerule ni kwian gdaite ole cha Cristo Chube Kirolla Chube cha kagu nga dba ai giti —Jesu gerudu ene kwian geru jwannga ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ne suiage gwangerugu Jesu gerudu kwian geru jwannga ulita ole Jesu be boi giti, Jesu gerudu: —Cha jogedale una Jerusalénge, una ege cha be mo boange tanre daga ngwale kwian nage. Kwian israelita chugagwalla juma ulita kaire kwian gerunga Chube ole daba alin chugagwalla ulita kaire kwian daba tkanga tangle Moisés chadalla giti ulita, kwian e ulita me cha gerua gai ulia, ama ulita be jainchke chadi cha gerua gdale be cha gbe boi daga ngwale, bdagli cha gwabeda agwa mongikege cha jaba be chkeni gwade. ");
INSERT INTO sabNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Jesu gerudu ene mau giti gire Pedro Jesu du sugekare, Pedro gerudu mno Jesu ole: —Cha Chugagwalla, ¡Chube me takalin ba boi ene ba kle tañachuge kare! E me ñage boi ba ole ba kle gerule kare ba gwabeda. ");
INSERT INTO sabNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pedro gerudu ene Jesu ole gire Jesu jwlituda gdate naskuni gerudu Pedroge: —¡Chegede kamne! Ba kle gerule Satanás kiralla giti ba kle gerule ama takalin kare, ba me ñage gerule ene dare. Ba kle gerule kare ba ta cha ta blitakalin me age Chube takalin kare, ba me kle tañachuge Chube takalin kare, ba kle tañachuge kwian onbre ngwale kle tañachuge kare. ");
INSERT INTO sabNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Jesu gerudu ene Pedroge gire Jesu gerudu kwian geru jwannga ulita ole: —Kwian bai ta chagekalin ulia cha ole me tañachugadale dare mau giti alin allabi me agedale dare ama agali ta agekalin kare, ama mo ta gbadale cha gerua gbe gdadi age cha takalin kare, kwian na ama gbe boi daga ngwale cha gerua gdale kaire kwian na ta ama gwakalinda cha gerua gdale, ama me mo talladale. Kwian bai mo ta gbe ene ñage chage cha ole. ");
INSERT INTO sabNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kwian bai tañachuge mau giti alin allabi toi no nga dba ai giti mo manade no me tañachuge age Chube takalin kare giti, bdagli kwian ene be jogenga sugekare Chubege be chege boi daga ngwale tanre diali chui tangle. Agwa kwian bai mo ta gbe chage cha ole mo chuge ngwadi boi daga ngwale nga dba ai giti cha gerua gdale, ama me mo tallade, ama tañachuge ma no age Chube takalin kare, bdagli kwian ene be toi no diali chui tangle nga ngaña giti cha ole cha Ñenua Chube ole. ");
INSERT INTO sabNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Cha gerule ulia ba ole, ngwale kwian tañachuge tanre lle lite ole ngle giti ama kle toi nga dba ai giti gire. Kwian tañachuge lle lite ole alin allabi mau alin agwa ama me mo ta gbe ulia Chube ole, kwian e be jogenga ngwale, ama be chege sugekare Chubege diali chui tangle. Kwian me ñage tañachuge lle no ñanaske gweale kete Chubege gire e giti Chube be ama gbe toi no ule Chube ole nga ngaña giti diali chui tangle, me ene dale. ");
INSERT INTO sabNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Chube cha kagu nga dba ai giti kwian kare, chui bdaglige cha be chieni nakwaite cha Ñenua Chube kirallaske, cha be chieni ule lle boanga Chube alin nga ngaña giti ngle ole. Chui ege cha be gerule kwian bai jiske Chube gwa giti kwian bai me jiske Chube gwa giti. Kwian bai agedu me no Chube dollale, kwian ene jiske Chube gwa giti, cha be kwian ene ulita gbe ji chuge agedu me no kbiale. Kwian bai agedu no Chube takalin kare cha mi kwian ene gbe jiske Chube gwa giti, cha be age no ama ulita alin ama agedu no trate Chube takalin kare ñanale. ");
INSERT INTO sabNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Cha gerule ulia ba ulita ole, Chube cha kagu nga dba ai giti kwian kare, ba gweale kle aini cha ole cha keruchuge ba bebi jogeda gire ba gwa giti Chube be age no no cha ole ama kiralla giti, ba gwage chadi ene gire be suge trate bage cha noare cha kweri cha kwian ulita Chugagwalla —Jesu gerudu ene ulita kwian geru jwannga ole. ");
INSERT INTO sabNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Chui dereke jo tangle gire Jesu jo jwichuga giti bate ngaña, ama kwian geru jwannga amage gdamaire alin allabi du ule, ama Pedro kaire Santiago kaire Santiago daballa Juan du ule ama gatedi. Ama ulita jo chke jwichuga giti kwian na me kle ngwadi, ");
INSERT INTO sabNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","gire Chube Jesu blitu ulita jegwale kwian geru jwannga gdamai e gwa giti. Jesu gwa chratigunga chui chra kare Jesu ñometralla ulita jwlitedu jutre Jesudige jichra chra jutre kare. ");
INSERT INTO sabNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kwian geru jwannga gdamai gwagedu Jesudi ene gire blike kwian unsuialin boke ka jwankle Moisés kaire Elías medu geru trage Jesu ole ama gdamai gwa giti. ");
INSERT INTO sabNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pedro gwagedu ene Moisédi Elíadi geru trage Jesu ole, gire Pedro gerudu Jesu ole: —Cha Chugagwalla, nga suga noare chadi che ulita chku aini. Ba takalin, cha u soli gbe gbamai aini toingwa sugetidale, u gbaite ba alin, u gbaite Moisés alin, u gbaite Elías alin. ");
INSERT INTO sabNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pedro kledu gerule ene Jesu ole, gire bogakwa jutre chra gwadetranga chku blike ama ulita giti, ama ulita chegu bogakwaske gire bogakwaske Chube kerua sugedu ama ologe gerule: “Ai cha Kirolla, cha no no ama ole, nga suga noare chadi ama giti, ba ulita ama keruchugadale no, ba mo ta gbadale ama kerua gbe gdadi no diali.” ");
INSERT INTO sabNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ama gdamai Jesu gerua jwannga geru e keruchugu gerule Jesu giti gire ama kendunga tanre ama ulita mo ñeu kaboge jongnagwa giti ama gwa ñadu dbidi chru ole. ");
INSERT INTO sabNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jesu jo ama gdamai e kle ngwadi Jesu ama ulita chugudi kodi, Jesu gerudu: —Chkede gdate, ba me kwachie. ");
INSERT INTO sabNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ama gdamainate gwa gaunga ngaña tienda mo giti me gwagedu kwian kledu geru trage Jesu oledige, Jesu alin kleduni gballa. ");
INSERT INTO sabNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Boidu ene ulita jwichuga giti gire Jesu joni chage jwichugadi gwajimogu ule kwian geru jwannga gdamai ole, Jesu gerudu ama ole jonkare: —Mo gwagwa giti ba gwagedudi jwichuga giti nege kaire ba geru keruchugu cha giti, ba me e trage ni kwian na gdaite ole. Cha chiu nga dba ai giti kwian kare, cha be jogekeda, cha be chkeni gwade gire ba ñage boidu nege gerua ulita trage kwian na ole. ");
INSERT INTO sabNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Jesu kwian geru jwannga gdamai ta gbu ene kwian gwagedu giti kaire kwian geru keruchugu giti gire geru jwannga geru kadu Jesuge: —¿Mineade kwian daba tkanga tangle Moisés chadalla giti kle gerule Elías chkedale chage kwianske nga dba ai giti ngeru, gire Chube be kwian daba jwannga siere kage kwian ulita alin? Ba klebi nga dba ai giti kwianske, malen me suge chage mineade kwian e kle gerule Elías bebi chke. ");
INSERT INTO sabNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesu jaindunga: —E ulia kwian kle gerule kare, Elías chiedale kwian ulita ta gbe biale ngeru, gire Chube kwian daba jwannga siere kage chuiage kwian ulita ta kle biale kwian daba jwannga siere gai ngwange no, e trate ene ulia. ");
INSERT INTO sabNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Agwa cha gerule ba ole, Elías chkubi kwianske, agwa kwian me ama gau ngwange no jumale, kwian ama gau kwian ngwale kare, kwian agedu dagale ama ole me no kwian tadukalin kare. Ene kaire kwian e amaña be age dagale cha ole me no, cha Chube Kirolla chiu kwian kare nga dba ai giti, agwa kwian e cha gai kwian ngwale kare, ama be cha gbe boi dagale tanre me no salengwli ama Elías gbu boi daga ngwale tanre me no kare. ");
INSERT INTO sabNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jesu gerudu ene kwian geru jwannga gdamai ole Elías giti, gire chku uñale amage Jesu kledu gerule Juan-Bautista giti, Juan-Bautista Elías kare. ");
INSERT INTO sabNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jesu ule kwian geru jwannga gdamai ole jo chke jwichuga gdoge dbani, gire ne ngwadi kwian na geru jwannga Jesuge ulita kaire kwian na tanre kledu Jesu manade ngwange. Gire kwian onbre gdaite kle kwian ngleske chku Jesudi, ama jongnagwa skutu dba Jesu gwangnagu chudaboi kade Jesuge, gerudu Jesu ole: ");
INSERT INTO sabNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","16","—Kwian chugagwalla, ba tai dage cha kirollage, dolla kle nga kagenga ama chuga giti, ama oga jabale dolla kote, diali ama kle skwetenga kle joge chke dba jitaske kaire kle joge chke dba chiske. Cha chiu cha kirolla dbe kwian geru jwannga banuge dodadale, agwa ama me ñadu dolla kage siere cha kirollage, malen cha chiu ba nate, ba tai dage cha kirollage, ba cha kirolla dodade. ");
INSERT INTO sabNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesu kirogwa ñenua keruchugu gerule ene gire Jesu gerudu kwian ulita kle ne ngwadi ole: —Ba ulita me kle mo ta gbe cha gai ulia, ba ta me no. ¿Ngamangire ba be mo ta gbe cha gai ulia, ene Chube ñage kira kete bage age ulita cha kle age kare? ¿Ngamangire ba be kle kian gbe chage cha ba chudaboadale? Kirogwa du cháge aini. ");
INSERT INTO sabNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jesu gerudu ene kwian ulita ole gire kirogwa dule Jesuge, Jesu ka bo mno dolla ole: —¡Joga siere kirogwage! Jesu gerudu ene gire dolla jo siere kirogwage, sugeti kirogwa cheguni no trate. ");
INSERT INTO sabNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Jesu dolla kagu siere kirogwage gire kwian geru jwannga Jesuge ulita chku Jesudi geru kadu Jesuge sugekare kwian nglea ulitage: —¿Mineade cha me ñadu dolla kage siere kirogwa ege? ");
INSERT INTO sabNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesu jaindunga: —Ba me kle mo ta gbe cha gai ulia malen ba me ñadu. Cha gerule ulia ba ulita ole, ba mo ta gbe sidri alin cha gai ulia, gire bedre bedre cha be ba ta gbe cha gai ma ngle, e salengwli mostaza chudea soli tkakle kle tige kle joge kweri kare. Ba mo ta gbe cha gai ulia ene, gire ba ñage dolla kage siere kwiange cha kiralla giti. Ene kaire ba ñage lle na tanre boi cha kiralla giti, ba ñage gerule jwichuga ai ole: “¡Joga siere aini, joga nga nage!”, ba gerule ene gire jwichuga be joge nga nage ba gerudu kare. Ba cha gadale ulia mo tale, ene ba ñage lle ulita boi cha kirallaske. ");
INSERT INTO sabNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Kwian jwligebanga dolla tirare kote kirogwa e kare, ba ta dolla e kare kagakalin siere kwiange ba mo ta gbadale mo tke bage bligdage gerule tanre Chube ole kira kade amage dolla kagagda siere kwiange, ene ba ñage. Ba me mo tke bage bligdage ni gerule Chube ole kira kade amage, ene ba me ñage dolla e kare kage siere kwiange —Jesu gerudu ene kwian geru jwannga amage ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jesu kledu chage nga Galileage ule kwian geru jwannga amage ulita ole, gire Jesu gerudu ama ole: —Chube cha kagu nga dba ai giti kwian kare, cha ketabe kwian agenga me no cha dollalege gwaleda, ");
INSERT INTO sabNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ama be cha gweda, agwa chui mongikege cha jaba be chkeni gwadeni. Jesu gerudu ene gire kwian geru jwannga Jesuge nga chiu olire tanre ama ulitadi Jesu kle gerule giti. ");
INSERT INTO sabNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jesu kledu chage nga Galileage gire jo chke una Capernaumge, una ege kwian igi ganga u gerungwa Chube ole managda, kwian e jo chke Pedrodi geru kadu Pedroge: —¿Kwian ba tkanga tangle geruge kle igi kete u gerungwa Chube ole managda che ulita kle igi kete kare o me? ");
INSERT INTO sabNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedro jaindunga: —Ima, ama kle igi kete kwian ulita kle age kare. Bigwa Pedro jo chke gwa uge Pedro bebi geru trage Jesu ole igi giti gire Jesu gerudu ama ole: —¿Ba tañachuge mine Simón-Pedro? ¿Chemage kwian nga gwealemu chugagwalla kle igi kade, kle igi kade mo kirogwallage o kwian na nga amañamuge? ");
INSERT INTO sabNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedro jaindunga: —Kwian chugagwalla kle igi kade kwian na nga amañamuge me kle igi kade mo kirogwallage. Jesu gerudu: —Ima, ba gerudu ulia. Kwian chugagwalla me igi kade mo kirogwallage, malen ama kirogwalla me igi ketadale. Ene kaire cha Chube Kirolla malen cha me igi ketadale u gerungwa Chube ole managda, u e cha Ñenuanu. ");
INSERT INTO sabNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Agwa cha me takalin kwian skochie kaire kwian tañachuge chadi cha me kle Chube gai dage malen suge chage ma no che igi kete kwian ulita kle igi kete kare. Joga chibitage ngwe jwen, ngwe ngerutabi be blire ba ole, ngwe e kate igi be skwen bage. Ba igi e kete che gdaboke giti kwian igi gangage u gerungwa Chuge ole manangage. Jesu gerudu ene ulita Pedro ole gire Pedro agedu ulita Jesu gerudu kare. ");
INSERT INTO sabNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","E suiale kwian geru jwannga Jesuge ulita chku Jesudi geru kadu Jesuge: —Chui be chke ba be gerule nga ulita giti kwian ulita Chugagwallale gire chui ege ¿cha ulitage bai be chege ma kweri Chube gwa giti? ");
INSERT INTO sabNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Kwian geru jwannga geru kadu ene Jesuge gire Jesu kirogwa soli gdaite kledu ne ngwadi kadu mo gitigu, Jesu kirogwa e gbu kwian geru jwannga ulita gwa giti, ");
INSERT INTO sabNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","gire Jesu gerudu: —Cha gerule ulia ba ulita ole, ba me mo ta blite ta gbe tañachuge kirogwa soli ai kare cha gai ulia mo tale, ba me ñage kle ule cha ole cha chuiage cha be gerule nga ulita giti kwian ulita Chugagwallale gire. ");
INSERT INTO sabNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kwian bai kle Chube gai dage ulia, bai kle mo gbe suge soli daba na chudaboangale, kwian ene kle mo ta gbe tañachuge salengwli kirogwa soli ai tañachuge kare, kwian ene ma kweri Chube gwa giti. ");
INSERT INTO sabNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Kwian bai kaire no cha ole ulia, kwian ene kle kirogwa ai kare gai ngwange no kle age no ama alin, kwian age ene me kle kirogwa alin allabi gai ngwange no, kaire ama kle cha gai ngwange no kle age no cha agali alin kare, kwian ene be ma kweri Chube ngwadi. ");
INSERT INTO sabNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Jesu gerudu dare kwian geru jwannga amage ulita ole: —Cha gerule ulia ba ulita ole, kwian bai kaire age me no kwian chanu ole kwian cha gerua gaba ulia me sbali kwian na daba ene ta gbeni bliteni naskuni age gweale me no Chube dollale, ma no kwian daba gbanga age me no ene alin ke kweri lugaba mo siroge mlienga ble jereske age me no giti gdale kwian chanu ole, ene kwian e be jogekeda mi chege dare kwian chanu ta gbe age me no joge siere cha geruage. ");
INSERT INTO sabNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Nga dba ai giti lle me no tanre kle diali kwian ulita takalin age, kwian bai age me no diali ama ta agekalin kare, kwian ene be boi daga ngwale age me no ene kbiale. Agwa kwian bai daba na gbe age me no, kwian e be boi daga ngwale ma tirare, ama be ji chuge daga ngwale tanre daba gbe age me no kbiale. ");
INSERT INTO sabNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Malen ba ta agekalin gweale me no mo ko giti chage age gweale me no mo sera giti ba mo ta gbadale me tañachuge dare age me no ene kare mo ko e giti mo sera e giti, ba age me no ene talla chuge ngwadi, e salengwli ba mo ko tkenga kare mo sera tkenga kare, ene ba me age me no dare mo ko giti mo sera giti kare. Ma no ba alin joge ko bitale ole sera bitale ole toi Chube ole nga ngaña giti diali dale alin ba agedu no Chube takalin kare ñanale, agwa me no ba alin joge ko no gdabonate ole sera no gdabonate ole ji chuge tirare ngwadi boi daga ngwale jitaske ba agedu me no mo ko giti mo sera giti Chube dollale ñanale, jita ne ngwadi mi joge gwabada dale be chege diali gwade tirare kwian agenga me no gbagda boi daga ngwale diali chui tangle. ");
INSERT INTO sabNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Kaire agwe ba gwage lle gwealedi mo gwagwa giti gire gwage edi giti ba ta agekalin gweale me no, ba me mo chuge ngwadi gwage lle edi dare ni tañachuge lle e giti dare, ma no ba mo linge siere lle ege. Ba agedale salengwli ba gwagwa gbaite jo jwanba siere mliabanga kare ene ba me ñage gwage lle me nodi ba takalin kare. Ma no ba alin joge gwagwa gbaitre alin ole toi Chube ole nga ngaña giti diali dale alin ba agedu no Chube takalin kare ñanale, agwa me no ba alin joge mliabanga gwagwa gbabonate no ole ji chuge tirare ngwadi boi daga ngwale jitaske ba agedu me no Chube dollale ñanale. Ba mo ta gbadale diali age no Chube takalin kare me tañachuge age me no giti dare, ma no lle ulita kle ba gbe age me no ba joge siere lle e karege. ");
INSERT INTO sabNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Jesu gerudu: —Cha gerule ba ole, ba mo ta gbadale me daba na cha gerua gaba ibade, ba daba ene gweale ibade ba me kle age sugekare Chube gwage, me ene, diali lle boanga ulita cha Ñenua Chube alin nga ngaña giti kle cha Ñenua ole, cha Ñenua kle ama kage kwian cha gerua gaba manade. ");
INSERT INTO sabNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Cha chiu nga dba ai giti kwian kare kwian agenga me no alin, cha chiu kwian ene chudaboi ta blite Chube ole, cha chiu ama jwen siere ji chugege age me no gdale. Kwian agenga me no kle chage sugekare Chubege salengwli bda oveja jogebanga kle chage sugekare mo mauñage kare. ");
INSERT INTO sabNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’Cha geru ñachuge ai kare bage: Kwian gdaite bda oveja ngle molen cien, bda oveja gdaite jogengwa kwian ngeru, ¿ba tañachuge mine? ¿Kwian oveja mauña be age mine? ¿Oveja mauña be ta jogenga oveja gdaite jogebanga giti be oveja chuge ngwadi jogenga? ¡Me dale! Ama be oveja na dare noventa y nueve jige litaba ole ngmadi nga oveja manangwage gire ama be joge oveja jogebanga gdaite jinade nate. ");
INSERT INTO sabNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Cha gerule ulia ba ole, oveja soli be skwen amage gire nga be chie suga noare amadi oveja gdaite jogebanga giti ma no oveja na dare noventa y nueve me jogebangage. ");
INSERT INTO sabNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Kwian oveja mauña me tadu oveja jogebanga chugakalin ngwadi, ene kaire ba ulita Ñenua Chube nga ngaña giti me takalin kwian gdaite cha gerua gaba joge siere cha geruage oveja jogebanga kare, malen ba mo ta gbadale me kwian Chubenu ibade ni ama ta gbe age me no —Jesu gerudu ene kwian geru jwannga amage ole. ");
INSERT INTO sabNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jesu gerudu dare: —Cha gerule ba ulita ole, daba Chubenu gweale age me no ba dollale, ba gerudale ama ole sugekare ama agedu me no giti. Daba Chubenu e ba gerua keruchuge chke uñale amage ama agedu me no gire ama mo ta blite no ba ole gerule ba ole: “Cha mi age dare me no ba dollale, cha agedu me no ba dollale ba talla mlienga.” Ama gerule ene gire chke uñale bage ba ñadu ama chudaboi tien gitiru ama agedu me no giti. ");
INSERT INTO sabNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Agwa daba Chubenu e me ba gerua gbe gdadi me mo ta blite no ba ole, ba jogedale daba Chubenu na gdaite o gdaboke jwen dbe ule daba agedu me no ngwadi. Gire ba gerudale nakwaite ama ole daba bai ba du ule gwa giti, ene daba bai ba duge be chke uñale ba takalin daba Chubenu agedu me no chudaboi ba takalin toi no naskuni ama ole, daba bai ba du be chege ba ka chudaboanga. ");
INSERT INTO sabNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Daba agedu me no ba ka chudaboanga keruchuge gire mo ta blite no ba ole, e no, ene daba e be chegeni no ba ole. Agwa daba agedu me no ni ba keruchuge ni ba ka chudaboanga keruchuge, gire ba daba e dbadale kwian Chubenu ulita kle mo lite ole ngwadi, ba daba e kaitadale kwian Chubenu ulita kle mo litaba olege gerule ulita daba e agedu me no ba dollale giti. Ba age ene, daba e ni kwian Chubenu ulita kle mo litaba ole keruchuge me mo ta blite no ba ole, gire ba ñage gerule ama ole: “Ba kwian agenga me no me Chube uñe kare.” Gire kwian Chubenu ulita gwa giti daba e be chege kwian agenga me no kwian me Chube uñe kare kaire kwian me Moisés nu Chube gerua degaba ganga ulia kare, ama jogedale siere ba kwian Chubenu ulitage, ba me ñage skate dare amage. ");
INSERT INTO sabNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Cha gerule ulia ba kwian geru jwannga chage ole, ba ulita mo ta gbe ule geru gbe salengwli daba alin daba agedu me no gdale, ba geru trage modi daba e giti kaire ba chudaboi kade Chubege gire be suge ba ulitage ba geru gbadale mine daba e alin ba ji gbadale daba alin ama agedu me no gdale o ba talla e mliadalenga. Ba ulita mo ta gbe salengwli geru gbe ene daba alin nga dba ai giti, ene kaire geru be joge gbaba nga ngaña giti Chube kle ngwadi. ");
INSERT INTO sabNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Kaire cha gerule ba ulita ole, ba gdabokle alin allabi mo ta gbe ule tañachuge salengwli daba gweale giti, ba gdabonate gerule ule ama giti Chube ole, ba chudaboi kade Chubege, Chube be ta kete bage ba agedale mine daba alin. ");
INSERT INTO sabNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ulia baini kaire kwian cha gerua gaba mo lite ole gdaboke o gdamai cha kalla giti, ne ngwadi cha be kle amaske cha ama keruchuge cha ama chudaboi. ");
INSERT INTO sabNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Jesu gerudu ene kwian geru jwannga amage ulita ole gire Pedro geru kadu Jesuge: —Cha Chugagwalla, daba gweale age me no cha dollale me bitaitre alin agwa bitangle bitaguke, ¿cha ama age me no talla mlialenga kaire bitaguke o me? ¿Bitamangire daba amaña age me no cha dollale cha talla mlialenga? ");
INSERT INTO sabNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesu jaindunga Pedro kalen: —Cha gerule ba ole, me bitagukle alin ba ama agedu me no talla mlialenga, agwa ba mo ta gbale ama agedu me no talla mlienga diali bitangle ngle, ba me ñage tañachuge ama agedu me no talla mliadalenga bedre alin. ");
INSERT INTO sabNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Bitangle diali Chube kle ba age me no ama dollale talla mlienga malen ba kaire mo ta gbadale daba age me no ba dollale talla mlienga Chube kle age ba alin kare, e salengwli ai kare: Kwian chugagwalla gdaite lle boanga tanre molen mo alin, lle boanga e ulita jiske igi giti mo chugagwallage. Chui chku gire chugagwalla e tadu igi kadakalin naskuni kwian lle boanga ama alin ulitage lle boanga gdaite gdaite jiske batre. ");
INSERT INTO sabNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kwian chugagwalla kledu tañachuge kwian lle boanga ama alin ulita gdaite gdaite jiske mangire amage, gire kwian lle boanga ama alin gdaite dbajo kaitadale chugagwalla ngwadi, lle boanga e jiske ngleare igi e diez mil. ");
INSERT INTO sabNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kwian lle boanga e me igi molen ketadaleni mo chugagwallage gire ama chugagwalla mo ta gbu ama chbade kwian nage kaire ama muira ama kirogwalla ulita chbade. Chugagwalla tadu agekalin ene gire ama ñage igi jwen nate naskuni kwian lle boanga e jiske amage batre. ");
INSERT INTO sabNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Chugagwalla tadu agekalin ene gire kwian lle boanga e jongnagwa skutu dba ama chugagwalla ngnagu gerudu: “Cha chugagwalla, ba manade sugeti kaire ba tai dage chage, cha ole igi me, igi be skwen chage gire cha be igi ulita keteni naskuni ulita bage cha jiske batre.” ");
INSERT INTO sabNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kwian lle boanga e gerudu ene mo chugagwalla ole gire chugagwalla taidu dage kwian lle boanga amanuge, ama gerudu lle boanga e ole: “Ba me igi ketadaleni chage, cha mi ba chbade dale, ba me jiske chage dare, cha be ba jiske talla mlienga ulita.” Chugagwalla gerudu ene gire chugagwalla lle boanga e chugu ngwadi ngwedi ngeru kare. ");
INSERT INTO sabNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Chugagwalla kwian lle boanga mo alin e jiske talla mliunga ene, gire kwian lle boanga e jo siere ne ngwadi tendu ama skatemanalla gdaite jiske sidri amage ngwange. Ama mo skatemanalla gau siroge siro kwetunga nga kagunga skatemanalla giti gire ama gerudu skatemanalla ole: “¡Ba jiske chage igi e ba ketadaleni chage blikare!” ");
INSERT INTO sabNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Kwian lle boanga gerudu ene mo skatemanalla ole gire ama skatemanalla jongnagwa skutu dba ama gwa giti, ama skatemanalla gerudu ama ole: “Igi me cha ole, ba manade sugeti kaire ba tai dage chage, igi be skwen chage gire cha be igi ulita keteni naskuni bage cha jiske batre.” ");
INSERT INTO sabNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Kwian lle boanga skatemanalla gerudu ene ama ole agwa lle boanga e me taidu dage mo skatemanallage, ama mo skatemanalla kaitu tkadale skage, ama skatemanalla igi keteni ulita amage gire ñage skachienga. ");
INSERT INTO sabNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Kwian lle boanga na ulita gwagedu kwian lle boanga gdaite edi daba na tke skage igi gerua giti gire kwian lle boanga e ulita jo geru kete chugagwallage boidu giti. ");
INSERT INTO sabNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Chugagwalla geru e keruchugu gire ama kwian lle boanga daba tkanga skage kadu mo ullage gerudu ama ole: “Ba kwian agenga me no me no. Ba jiske tanre chage, cha igi kaduni bage ba gerudu cha taidale dage bage gire cha agedu ba gerudu kare, ba me chegu jiske chage, cha ba jiske ulita talla mliunga. ");
INSERT INTO sabNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Gire mineade ba me taidu dage ba skatemanallage cha taidu dage bage kare? ¿Mineade ba me agedu no ba skatemanalla ole cha agedu no ba ole kare? Ulia ba agedu me no me no.” ");
INSERT INTO sabNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Chugagwalla ka bo ene kwian lle boanga ole, ama skochiu tanre kwian lle boanga edi gire chugagwalla kwian lle boanga e kaitu dbadale skage ji chugadale, ama chegedale skage, ama igi ulita ketale naskuni ama chugagwallage ama jiske batre gire ama ñage chienga skage. ");
INSERT INTO sabNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jesu geru ñachugu ene kwian geru jwannga ulita ole gire gerudu dare: —Chugagwalla agedu kwian lle boanga ole kare, ene kaire cha Ñenua Chube be age ba ulita ole ba bai me daba agedu me no talla mlienga mo tale trate. ");
INSERT INTO sabNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesu gerudu ene ulita kwian geru jwannga amage ulita ole gire ama ulita jo siere nga Galileage jo nga Judeage jo chke chi Jordán kagda giti ongoru. ");
INSERT INTO sabNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ne ngwadi kwian tanre chagedu Jesu nate gire Jesu kwian tanre oga dodadu. ");
INSERT INTO sabNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Kwian fariseo gweale chku Jesudi mo chuge Jesu ole, ama ulita takalin Jesu gerule gweale me no Moisés chadalla dollale, ene ama ñage Jesu gbe jiske e gdale, ta ene ole kwian fariseo ulita geru kadu Jesuge: —Cha geru kade bage, ¿kwian onbre mo jwanba ñage mo muiralla chuge ngwadi muinga age gweale gdale? ¿Age ene e skwen no Chube gwa giti o skwen me no Chube gwa giti? ");
INSERT INTO sabNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesu jaindunga: —¿Ba me Moisés nu Chube gerua degaba unsuialin batabanga? Chada e gerule: “Gwange jondege alin Chube nga ulita lle ulita dodadu, Chube kwian onbre dodadu kwian muire dodadu.” ");
INSERT INTO sabNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Kaire chada e amaña gerule: “Chube kwian dodadu ene onbre, muire, malen kwian onbre mo jwankalin muinga ole ama mo ñenua mo chebia chugadale ngwadi mo ta gbe ule muinga ole gire ene ama gdabonate chege kwian gdaitre alin kare ta salengwli ole.” Moisés Chube gerua degu ene. ");
INSERT INTO sabNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nege cha gerule ba ulita ole, kwian mo jwanba me chege kwian gdaboke kare agwa Chube gwa giti ama boke chege kwian gdaitre alin kare onbre muinga ole muinga onbre ole, ama boke ta chegedale ule salengwli. Ulia me no kwian onbre mo gbe sugekare mo muirallage, Chube muinga ketu onbrege, Chube onbre ketu muingage, Chube kwian gbu mo jwen ene, malen onbrenu muirenu me ñage age ama takalin kare joge siere muingage o muinga joge siere onbrege, e me no Chube gwa giti. ");
INSERT INTO sabNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Jesu gerudu ene gire kwian fariseo gerudu Jesu ole dare: —Agwa kaire Moisés nu Chube gerua degaba unsuialin gerule onbre mo muiralla chugakalin ngwadi, onbre e chada degadale kete mo muirallage, chada e gerule muinga e me amanu dare, onbre age ene gire onbre ñage mo muiralla chuge ngwadi. E ulia ba kle gerule kare, gire ¿mineade Moisés chada degu ene? ");
INSERT INTO sabNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesu jaindunga: —Ulia gwange jondege alin Chube kwian onbre dodadu kwian muire dodadu mo jwanle toi no ule diali, agwa ba ulita ta mnoare ba me Chube gerua gbakalin gdadi no age Chube takalin kare, ba ulita agekalin mau tale ba takalin kare, malen Chube Moisés ta gbu chada dege ene kwian ulita alin. ");
INSERT INTO sabNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Cha gerule ba ole, muinga mo jwanba me kle chage onbre na ole ke giti agwa kle toi no mo ñengulalla alin allabi ole, gire muinga e ñengulalla ama chuge ngwadi mo jwen muinga na ole, onbre e kle age me no Chube gwa giti, Chube gwage e salengwli onbre e kle mo chuge ke giti muinga e ole kare. ");
INSERT INTO sabNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jesu gerudu ene ulita kwian fariseo ole gire kwian geru jwannga Jesuge gerudu Jesu ole: —E ene ulia ba kle gerule kare onbre toidale no ule diali mo muiralla ole me ñage mo muiralla chuge ngwadi, ma no kwian onbre chege gballa me mo jwen muinga ole. ");
INSERT INTO sabNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesu jaindunga: —Ulia mnoare kwian onbre alin mo ta gbe toi no ule diali mo muiralla ole me mo muiralla chuge ngwadi, agwa kaire mnoare onbre alin chege gballa diali me mo jwen muinga ole, agwa Chube onbre gweale ta gbe chege toi gballa me mo jwen muinga ole. ");
INSERT INTO sabNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kwian onbre gweale menga chebia kote me ñage toi muinga ole me ñage kirogwa molen muinga giti, malen onbre ene kle chege gballa me mo jwen. Kwian onbre gweale ole kwian na me no kle age gweale gire ene onbre e me ñage kirogwa molen muinga giti, malen onbre ene kle chege gballa me mo jwen. Kwian onbre gweale ta lle boakalin Chube alin allabi, malen onbre ene kle mo ta gbe toi gballa me mo jwen, onbre bai kaire ta chegekalin toi ene lle boi Chube alin Chube gerua kete kwian nage, noare ama alin mo ta gbe kiraske me mo jwen chege toi gballa diali lle boi Chube alin —Jesu gerudu ene ulita kwian geru jwannga amage ole. ");
INSERT INTO sabNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Kirogwa ñenua kirogwa chebia tanre chiu mo kirogwalla soli dbe Jesu kle ngwadi, kirogwa ñenua, chebia takalin Jesu ko gbe kirogwa soli e giti gerule Chube ole Chube age no kirogwa alin Chube kirogwa manade no. Kwian geru jwannga Jesuge ulita gwagedu kwian tanre edi chie kirogwa dbe Jesu kle ngwadi gire ama ka bo kirogwa ñenua ole chebia ole: —¿Lledale ba kle chie kirogwa dbe Jesuge? ¡Joga, joga siere, ba me chie kirogwa dbe Jesuge! ");
INSERT INTO sabNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Kwian geru jwannga ka bo ene kirogwa dbanga ulita ole gire Jesu gerudu kwian geru jwannga ole: —Me no ka boi ene kirogwa ñenua ole chebia ole, ba ama ulita chugene chie mo kirogwalla dbe chage. Kirogwa soli ta kle biale Chube gerua gai blike, kirogwa talla ene kare Chube takalinge, kwian ulita bai kaire mo ta gbe ulia Chube ole kirogwa talla ene kare ole, kwian ene chege Chubenu, ama be toi diali chui tangle Chube ole. ");
INSERT INTO sabNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jesu gerudu ene kwian geru jwannga ole gire kirogwa ñenua, chebia ulita chiu mo kirogwalla dbe Jesuge, Jesu ko gbu kirogwa ulita gdaite gdaite giti, Jesu gerudu Chube ole Chube age no kirogwa alin kirogwa manade no. Jesu agedu ene kirogwa ulita dbachiu amage alin, gire Jesu jo siere nga ege. ");
INSERT INTO sabNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Kwian onbre gdaite chku tienda Jesudi geru gweale kade Jesuge, ama gerudu Jesu ole: —Ba kwian tkanga tangle geruge, cha takalin ba geru kete chage, ¿cha llema no boadale nga dba ai giti gire ene cha ñage toi no diali chui tangle Chube ole nga ngaña giti? ");
INSERT INTO sabNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesu jaindunga onbre e kalen: —¿Mineade ba kle geru kade chage lle no boi giti? Kwian ulita nga dba ai giti ni gdaite agenga no agwa gdaitre alin agenga no kle, e Chube. Cha gerule ba ole, ba ta toikalin no diali chui tangle Chube ole, ba mo ta gbale Chube gerua unsuialin Chube ketu Moisége gbe gdadi geru e gai dage. ");
INSERT INTO sabNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Jesu gerudu ene gire kwian onbre e geru kadu Jesuge: —Chube geru ketu Moisége, Moisés geru e ulita degu, ¿geru e bai cha gadale dage? Jesu gerudu: —Chube geru ketu Moisége kwian toidale mine Chube gwa giti, Moisés Chube gerua e degu unsuialin, chada e gerule: “Ba me daba gweda. Ba onbre mo jwanba me mo chuge ke giti muinga na ole, ba muinga mo jwanba me mo chuge ke giti onbre na ole. Ba me skwe boi daba ngeru. Ba me geru jinade ngwale daba na dollale. ");
INSERT INTO sabNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ba mo ñenua mo chebia gadale dage. Kaire agwe ba mo ta dbadale no daba na ulita ole salengwli ba kle mo ta dbe no mo ole kare.” Ba agedale ene geru ai kle gerule kare ene ba toi no diali chui tangle Chube ole. ");
INSERT INTO sabNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Kwian onbre gerudu Jesu kalen: —Geru e ulita cha nu gaba dage, cha kle toi geru e ulita kle gerule kare. ¿Llema dare cha me kle age cha me kle gai dage? ¿Llema dare kle cháge boadale? ");
INSERT INTO sabNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesu jaindunga: —Ba takalin chege no trate Chube gwa giti, ba jogedale lle banu ulita chbade, igi ulita lle e ñana ba kete kwian me lle molenge. Ba age ene ulita gire ba chieni cha kle ngwadi ba mo ta gbe chage cha ole diali geru jwen chage. Gire ene ba be kle biale joge toi diali chui tangle Chube ole nga ngaña giti, Chube be age no ba alin ba age no ñanale. ");
INSERT INTO sabNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kwian onbre Jesu keruchugu gerule ene gire ama joni ta olire tanre ole, onbre e lle molen tanre, malen ama me ta lle ulita chbadakalin Jesu gerudu kare ama ole. ");
INSERT INTO sabNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Kwian e joni gire Jesu gerudu kwian geru jwannga ulita ole: —Cha gerule ulia ba ulita ole, mnoare kwian lle molen tanre alin Chube gerua gai ulia mo ta gbe age ulita Chube takalin kare. Agwa kwian me age ene kwian me ñage toi diali chui tangle Chube ole nga ngaña giti. ");
INSERT INTO sabNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Cha gerule nakwaite ba ole kwian lle molen tanre giti, kwian lle molen tanre alin mnoare Chube gerua gai ulia age Chube takalin kare, kwian ene kle mo ta dbe no no mo llea tanre ulita ole malen mnoare ama alin mo ta gbe mo llea chuge ngwadi Chube gerua gai ulia mo alin age Chube takalin kare, mnoare kwian ene alin mo ta dbe ma no Chube ole ama kle mo ta dbe no mo llea olege, kwian ene me ñage mo ta gbe age Chube takalin kare salengwli bda kweri kadakle camello me ñage joge tangle agu kwebege kare. ");
INSERT INTO sabNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kwian geru jwannga Jesuge Jesu keruchugu gerule ene gire ama ulita chegu tañachuge tanre ma ngle geru e giti, ama geru kadu Jesuge: —E ene ulia mnoare age Chube takalin kare ba kle gerule kare, gire ¿chema ñage age ulita Chube takalin kare, ene toi no diali chui tangle Chube ole nga ngaña giti? ");
INSERT INTO sabNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesu gwagedu ama ulitadige, Jesu gerudu: —Kwian agali gballa me ñage age ulita Chube takalin kare me ñage age mau alin agali toi diali chui tangle Chube ole. Agwa Chube alin allabi ñage kwian kira gbe age ulita Chube takalin kare ñage kwian gbe toi diali chui tangle ama ole. Chube alin allabi ñage age ulita, lle ulita me mno ama alin boadale. ");
INSERT INTO sabNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Gire Pedro gerudu Jesu ole: —Cha ulita geru jwannga bage kle chage ba ole diali geru jwen bage, cha ulita mo llea ulita nga dba ai giti chugu ngwadi gire cha ulita mo ta gbu chage diali ba ole baini kaire ba kle joge ngwadi. Cha ulita agedu ulita ba gerudu kare onbre lle molen tanre ole, ¿cha ulita be llema gai bdagli mo ta gbe chage no ene ba ole ñanale? ");
INSERT INTO sabNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesu jaindunga: —Chui bdagli Chube be lle ulita nga ngaña giti nga dba ai giti dodadeni nakwaite jagere, gire ne suiale Chube be cha gbe gerule nga ulita giti kwian ulita Chugagwallale, chui ege Chube gwa giti cha be gerule kwian nga ulitamu giti bai jiske Chube gwage bai me jiske Chube gwage. Ene kaire chui ege ba ulita geru jwannga chage kle chage diali cha ole nga dba ai giti, ba ulita be chege daba chugagwallale ule cha ole gerule kwian ulita giti, chui ege cha be ba ulita gbe ba bitalla ulita israelita mne gdataboko giti gdaboke chugagwallale gerunga kwian e ulita giti bai jiske bai me jiske Chube gwage. ");
INSERT INTO sabNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kaire cha gerule ba ole, kwian ulita bai kaire mo ta dbe ma no cha ole kwian kle mo ta dbe no mo bitalla ulita olege mo llea ulita olege, kwian ene ta kle biale mo llea chuge ngwadi kaire mo bitalla chuge ngwadi cha gerua dbe gdale. Kwian u chuge ngwadi, kwian dbi chuge ngwadi, kwian mo daballa chuge ngwadi, kwian mo ñenua chuge ngwadi, kwian mo chebia chuge ngwadi, kwian mo kirogwalla chuge ngwadi, kwian bai mo ta gbe lle gweale o bitalla gweale chuge ngwadi ene cha gerua dbe kwian nage gdale, kwian ege Chube be lle ma no ma ngle kwian e nu lle chugaba ngwadige kete amage nga dba ai giti kwian ene age cha takalin kare ñanale, kaire bdagli kwian ene be toi no diali chui tangle nga ngaña giti Chube ole. ");
INSERT INTO sabNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Cha gerule ba ulita ole, nege nga dba ai giti kwian gweale kle suge moge ma kweri daba nage, chui bdaglige kwian ene be ma soli Chube gwa giti Chube ngwadi. Agwa nege nga dba ai giti kwian gweale suge moge ma soli daba nage, chui bdaglige kwian ene be ma kweri Chube gwa giti Chube ngwadi —Jesu gerudu ene ulita kwian geru jwannga amage ole. ");
INSERT INTO sabNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jesu gerudu dare kwian geru jwannga ole: —Cha gerule ba ole, kwian ulita salengwli Chube gwa giti, kwian bai age Chube takalin kare Chube be age no salengwli kwian ene ulita alin. Chube chuia be chke gire Chube be gerule nga ulita giti kwian Chugagwallale, chui ege Chube be age no kwian ulita alin bai kaire lle bo no ama alin ama takalin kare, e salengwli dbi mauña igi kete kwian lle boanga ama alinge kare. Cha geru ñachuge ba ulitage e giti: Chui gbaitege ngabebitabi kwian dbi mauña mo ta gbu joge kwian ngle jinade lle boangale mo alin deage. ");
INSERT INTO sabNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Kwian gweale skwendu amage ama gerudu kwian e ulita ole lle boi giti ama alin, ama gerudu: “Cha be igi kete bage lle boi ñanale mangire batre kwian ulita kle gai kare lle boi chui gbaitege.” Kwian lle boanga jaindunga kwian dbi mauña kalen: “Nobi, cha be lle boi ba alin ba takalin kare.” Gire kwian dbi mauña kwian lle boanga kagu lle boi deage, kwian dbi mauña joni gudegu. ");
INSERT INTO sabNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Chui e amañage chui jo bate ngaña gire dbi mauña joni nakwaite naskuni kwian na jinade lle boi ama alin, ama tendu kwian ngwange jonke kwian e ulita kledu ngwale, ");
INSERT INTO sabNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","gire ama gerudu kwian e ole: “Ba kle ngwale, noare ba ulita joge lle boi cha ngwadi deage, cha be igi kete no bage ba lle boi ñanale.” Dbi mauña gerudu ene kwian ole gire kwian e ulita jo lle boi kwian dbi mauña alin, kwian dbi mauña jo naskuni gudegu ama toi ngwadige. ");
INSERT INTO sabNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Chui bduke gire kwian dbi mauña joni nakwaite kwian na dare jinade lle boi mo alin, kwian gweale na kle ngwale skwendu amage gire ama kwian e ulita kadu lle boi mo alin deage. Chui jwlite ongoru dbige gire dbi mauña jo nakwaite kwian na jinade, kwian na skwendu amage, ama kwian e ulita kadu lle boi mo alin. ");
INSERT INTO sabNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ngabi gire dbi mauña joni nakwaite tendu kwian na kle ngwale ngwange jonke gire geru kadu kwian e ulitage: “¿Mineade ba ulita kle aini chui ai ulita kagenga ngwale? ¿Lle me boadale ba alin?” ");
INSERT INTO sabNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Gire kwian e ulita jaindunga: “Kwian me cha kadu lle boi mo alin malen cha kle aini ngwale.” Gire kwian dbi mauña gerudu: “Ba ulita jogedale lle boi cha alin cha ngwadi deage.” Kwian dbi mauña gerudu ene gire kwian e ulita jo lle boi dbi mauña alin deage. ");
INSERT INTO sabNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","’Nga jeredu gire kwian dbi mauña gerudu kwian ulita lle boanga deage chugagwalla ole: “Ba kwian ulita lle bo cha alin chui gbaite aige kade ba igi ketadale ama ulitage ama lle bo ñanale. Kwian chku bdagli lle boi ngabi ngnagu, amage ba igi ketadale ngeru, gire kwian chku ngeruge ba igi ketadale bdagli.” ");
INSERT INTO sabNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Kwian dbi mauña gerudu ene gire kwian lle boanga chugagwalla kwian kadu igi ketadale ama ulitage ama lle boi ñanale, kwian e ulita chku amadige. Kwian lle bo ngabi ngnagu, ama chku ngeru igi gai, kwian e igi gau ko ñanale ama lle bo chui gbaite ulita kare. ");
INSERT INTO sabNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Kwian lle boanga ngeruge chku uñale igi ketre ngle kwian chku ngabi ngnaguge, malen ama tañachugu igi ketabe ma ngle amage ama lle bo chui ulita ñanale. Kwian lle boanga nage igi ketre ulita, gire kwian ulita bai lle bo chui ulita chiu igi gai, ama ulita tañachugu igi gai ma ngle, agwa dbi mauña igi ketangu amage salengwli igi ketre kwian lle boanga na ulitage kare. ");
INSERT INTO sabNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","12","Kwian lle boanga e ulita lle bo chui ulita agwa ama igi gau lle boi ñanale salengwli batre kwian lle bo chui bonga alin kare, e giti lle boanga ulita bai lle bo chui ulita ta skochiu tanre dbi mauñadi, lle boanga e igi gau gire ama ulita daba gdaitre alin gau gbu gerule kwian dbi mauña ole ama ulita giti, daba e ka bo mo gdale dbi mauña ole: “¿Mineade kwian chku ma bdagli cha ulitage lle boi deage sidri mebi hora gdaitre alin allabi gire ba igi ketu batreti ba kle kete chage kare? ¿Mineade cha ulita lle bo ngabebita nga joge jere chui juteske gire ba igi ketu chage batreti ba igi ketu amage kare? ¿Mineade ba kle age ene?” ");
INSERT INTO sabNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Kwian dbi mauña gerudu kwian lle boanga e ole: “Cha skatemanalla, cha me kle skwe boi ba ngeru ba kle tañachuge kare. ¿Bage me chke uñale cha gerudu ba ole cha be igi kete e batre bage ba lle boi ñanale? Gire ba jaindunga: ‘Ima.’ Malen cha kle igi kete bage cha igi geruadu batre ba ole. ");
INSERT INTO sabNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","15","Igi e ulita cha igia, cha ñage mo igia kete kwiange cha takalin kare. Cha kle mo ta dbe no kwian ulita ole, malen cha tale cha igi ketangu kwian chku bdaglige cha igi ketangu bage batre kare. ¿Ba kle mo ta dbe semale daba ole cha kle age no ama alin gdale? Ma no ba igi gai ta suga no ole cha igi ketangu bage batre kare gire jogani gudegu.” Kwian dbi mauña gerudu ene kwian lle boanga e ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jesu geru ñachugu ene kwian geru jwannga ole gire gerudu dare ama ulita ole: —Cha gerule ba ole, ene kare chui bdaglige Chube be age kwian ole. Nege nga dba ai giti kwian gweale kle suge moge ma kweri daba nage, chui bdaglige kwian ene be ma soli Chube gwa giti Chube ngwadi. Agwa nege nga dba ai giti kwian gweale suge moge ma soli daba nage, chui bdaglige kwian ene be ma kweri Chube gwa giti Chube ngwadi —Jesu gerudu ene ulita kwian geru jwannga amage ole. ");
INSERT INTO sabNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesu jo chage kwian tanre ole jon Jerusalén ngnagu giti gire Jesu kwian geru jwannga amage kwian gdataboko giti gdaboke kadu sugekare kwian ngleage gerule ama ole Jesu be boi giti ulita, jonkare Jesu gerudu ama ulita ole: ");
INSERT INTO sabNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","19","—Bage uñale che ulita kle joge una Jerusalénge, una ege kwian be age cha dollale, cha ketabe boalenga ngwale kwian gerunga Chube ole daba alin chugagwalla ulitage kaire kwian daba tkanga tangle Moisés chadalla gitige, kwian e ulita me kle cha gerua gai ulia Chube cha kagu nga dba ai giti kwian kare malen ama be gerule cha jogedaleda cha jiske kweri Chube gwa giti kbiale, ama ulita be cha kete kwian me israelitage gwaleda. Kwian me israelita be kidere tanre chadige, be cha bate tanre obere giska giti, be cha gbe boi daga ngwale tanre ene gire bdagli be cha gweda kruge. Cha gwabeda agwa chui mongikege cha be chkeni gwadeni —Jesu gerudu ene ulita kwian geru jwannga amage gdataboko giti gdaboke ole. ");
INSERT INTO sabNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Zebedeo muira ule mo kirolla boke Santiago ole Juan ole jo chke Jesudige gire muinga e jongnagwa skutu dba Jesu gwangnagu gerudale Jesu ole mo kirolla boke giti. ");
INSERT INTO sabNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesu geru kadu muingage: —¿Ba takalin cha age mine ba alin? Muinga gerudu Jesu ole: —Ba chuia be chke gire ba be chege kwian ulita Chugagwalla ma kweri, chui ege cha takalin ba cha kirolla boke ai gbe kweri ule ba ole daba chugagwallale, noare ba cha kirolla ai gdaite gbe toi dba ba ko taingwli giti gdaite gbe toi dba ba ko jole giti, cha takalin ba age no ene cha kirolla boke ai alin. ");
INSERT INTO sabNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesu jaindunga: —Bage me suge ba kle llema kade chage. ¿Ba tañachuge ba kirolla gdaboke ñage mo kete boange daga ngwale cha be boi daga ngwale kare? Gire Santiago kaire Juan gerudu Jesu ole: —Ima, cha ñage mo kete boange daga ngwale ba gerua gdale ba be boi daga ngwale kare. ");
INSERT INTO sabNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesu gerudu: —Ulia ba be boi daga ngwale cha kare cha gerua gdale, agwa cha me ñage gerule ba ole cha chuia be chke gire ba gdaite be chege toiba dba cha ko taingwli giti gdaite cha ko jole giti daba chugagwallale ma kweri daba na ulitage. Cha me ñage gerule ene, agwa cha e jige Chube kote, Chube alin allabi ñage kwian gbe kweri daba chugagwallale toi dba cha ko taingwli giti cha ko jole giti chui bdaglige —Jesu gerudu ene Santiago ole Juan ole. ");
INSERT INTO sabNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Kwian geru jwannga Jesuge na ulita gdataboko geru e keruchugu gire ama ulita skochiu tanre daba gdabokedi ama boke gerudu Jesu ole gdale. ");
INSERT INTO sabNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jesu kwian geru jwannga amage ulita kadu mo gitigu gire Jesu gerudu ama ulita ole: —Bage uñale nga ulitage nga dba ai giti kwian chugagwalla ulita kle kwian ulita kage age chugagwalla takalin kare, kwian agedale ulita chugagwalla kle gerule kare, kwian chugagwalla kle kwian kage age chugagwalla takalin kare, ene chugagwalla suge moge kweri. ");
INSERT INTO sabNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","27","Agwa ba ulita me ñage tañachuge kwian chugagwalla nga dba ai giti ulita kle tañachuge kare, ba tañachugadale nganake, ba me mo ta gbe daba kage age ba takalin kare, agwa ba mo ta gbale diali age no daba na ulita alin daba chudaboi ta no giti, ba age ene gire Chube gwa giti ba chege kweri daba chugagwallale. ");
INSERT INTO sabNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ba ulita tañachugadale cha kle tañachuge kare, cha chiu nga dba ai giti kwian kare, cha me chiu kwian kagangale age no cha alin cha chudaboi, agwa cha chiu kwian ulita chudaboangale, cha chiu age no kwian alin kwian chudaboi, kaire cha chiu mo ketale gwaleda kwian ulita alin, ene cha jogeda giti cha kwian jwen siere ji chugege ama agedu me no gdale —Jesu gerudu ene ulita kwian geru jwannga amage ole. ");
INSERT INTO sabNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jesu kledu una Jericóge Jesu jo dare chage una Jerusalén ngnagu ule kwian geru jwannga amage ulita ole, kaire kwian na tanre chagedu Jesu ole Jesu gatedi. ");
INSERT INTO sabNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Kwian gdaboke gwagwa me, ama kledu toiba dba jonke, ama ologe gerudre Jesu kle joge tangle gire ama boke ngautu Jesuge: —¡Ba kwian chugagwalla kweri unsuialin David oindalla, ba tai dage chage! ");
INSERT INTO sabNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Kwian boke ngautu ene Jesuge gire kwian nglea kledu ne ngwadi ka bo kwian gwagwa me ole: —¡Me ngaute, chegede kamne! Kwian nglea ka bo ene agwa kwian gdaboke gwagwa me ama me talladu, ama mo ta gbu ngaute gwangerugu ma ngle Jesuge: —¡Cha ba gai kweri, ba kwian chugagwalla kweri unsuialin David oindalla, ba tai dage chage! ");
INSERT INTO sabNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesu kwian boke e keruchugu gire Jesu me chagedu dare, Jesu chegu jagenga gdate jonke, Jesu kwian gwagwa me kadu mo gitigu gire geru kadu kwian gwagwa mege: —¿Ba takalin cha llema boi ba alin ba chudaboagda? ");
INSERT INTO sabNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Kwian gwagwa me jaindunga: —Cha takalin ba cha gwagwa dodade ba cha gbe ten. ");
INSERT INTO sabNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesu taidu dage tanre ama bokege, Jesu ko chugu ama gwagwadi gire sugetibi allabi ama gwagwa jo chkeni ama gwagwa chra chku ñadu ten no trate. Jesu kwian gwagwa dodadu ene gire kwian e boke jo chage Jesu nate Jesu gatedi. ");
INSERT INTO sabNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jesu jo chage dare una Jerusalén ngnagu jo chke kodi una Jerusalénge ule kwian geru jwannga amage gdataboko giti gdaboke ole, una soli kada Betfagége chege kodi kodi una Jerusalénge Ngwiskinro Jwichugalla gdoge dba. Ama ulita jo chke ne ngwadi, gire Jesu kwian geru jwannga amage gdaboke kagu mo ngeru, ");
INSERT INTO sabNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Jesu gerudu ama boke ole: —Joga gdabonate cha ngeru una soli kle ngeruge, ba be joge chke una soli ege burro chebia ule soli ole be skwen bage ba ngwange lugabada glige, ba ama skatrennga, ba chie ama gdaboke dbe chage. ");
INSERT INTO sabNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kwian gweale geru kade bage lledale ba kle burro e skatrennga, ba gerule kwian e ole: “Cha Chugagwalla takalin burro aige, me sbali cha Chugagwalla be burro ai gdaboke kageni naskuni aini.” ");
INSERT INTO sabNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","5","Jesu kwian geru jwannga amage gdaboke kagu ene burro jwen ama alin chagedale giti una Jerusalénge, ene ai ulita boidu Jesu ole kwian Chube gerua ketanga unsuialin Chube gerua degu kare, chada e gerule: “Ba gerule kwian una Siónmu ole (una amaña kada Jerusalén), ba gerule kwian e ulita ole: ‘Gwagede ba Chugagwalla kweridi chie ba ulitaske. Ama me kle mo ta gbe chie ba ulitaske kwian chugagwalla kweri nga dba ai giti kle mo ta gbe kare, ama kle chie chage burro soli giti, burro chebia teru alin dbanga, ama solia giti ba Chugagwalla kweri kle chie chage ba ulitaske.’ ” Chube gerua degaba unsuialin gerule ene Jesu giti. ");
INSERT INTO sabNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kwian geru jwannga Jesuge gdaboke jo agedu ulita Jesu ama kagu age kare. ");
INSERT INTO sabNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ama chiu burro chebia dbe ule burro soli ole Jesu kle ngwadi, ama mo ñometralla gitiru gbu burro soli trigda giti Jesu alin, gire Jesu skwendu burro soli giti, gire Jesu jo chage dare una Jerusalén ngnagu burro soli giti. ");
INSERT INTO sabNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Kwian tanre kledu Jesu ngwange jon jegwale, kwian e ngle mo ñometralla gitiru treun dba jonkare Jesu gai ngwange no mo Chugagwallale kweri, kwian gweale na ugananga tkunga gbu jonkare, e giti burro soli chagedu Jesu gwaru. ");
INSERT INTO sabNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Kwian tanre chagedu Jesu gwangerudba kaire Jesu natedba, kwian e ulita kledu ngaute nga suga no ole Jesu giti: —¡Nga suga noare chadi ba giti! Noare ba chiu cha ulita Chugagwallale, suge chage ulia ba che chugagwalla kweri unsuialin David oindalla. Noare Chube ba kagu nga dba ai giti cha ulita alin. Chube kle nga ngaña giti, ama noare ama kweri, ama kle age no tanre cha ulita alin ba giti —kwian tanre ngautu ene jonkare Jesu gai ngwange no Jesu gai mo Chugagwallale kweri. ");
INSERT INTO sabNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jesu jo chke una Jerusalénge ule kwian ngle kle ngaute ole gire kwian ulita toinga una ege chegu tañachuge tanre kledu boi giti, me sugedu amage kle boi mine, ama ulita me chegu ngwedi ama chagedu geru kade tanre moge ongoru ongoru Jesu giti: —¿Kwian e mine? ¿E chema? ");
INSERT INTO sabNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Kwian nglea kle chage Jesu ole kwian toinga una Jerusalénge keruchugu geru kade ene moge gire ama jaindunga: —E Jesu kle chage, ama kwian toinga una Nazarege nga kweri Galileage, ama Chube gerua ketanga. ");
INSERT INTO sabNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Una Jerusalénge Jesu jo u gerungwa Chube olege, u ege kwian tanre skwendu Jesuge lle chbade kaire lle gige, kaire kwian kledu igi blite daba na ole u ege. Jesu gwagedu kwian ulitadi age ene ulita gire Jesu ama ulita kagu siere, Jesu mesa igi blitangwa blitunga ulita kaire Jesu glidrega beusi chbadanga toingwalla chbadangwa blitunga ulita, ene kwian me ñage lle chbade dare eni. ");
INSERT INTO sabNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Jesu agedu ene, gire Jesu ka bo kwian e ulita ole: —Uñale ba ulitage Chube gerua degaba unsuialin gerule u ai giti, chada e gerule: “Chube gerudu: ‘U ai chanu chegedale u gerungwa cha ole alin allabi.’ ” Chube gerua degaba unsuialin gerule ene agwa ba ulita kle u ai gai mo alin, ba kwian skwere, ba kle lle chbade dabage kwangleare, ene ba igi gai ngle mo alin, Chube gwage e me no, e salengwli ba kle u Chubenu gai mo alin skwe boanga daba na ngeru kare —Jesu gerudu ene ulita kwian ole. ");
INSERT INTO sabNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jesu kledu u gerungwa Chube olege gire kwian tanre gwagwa me kaire kwian tanre sera kwebanga jo chke Jesudige u ege, Jesu kwian oga ene ulita dodadu. ");
INSERT INTO sabNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Kwian gerunga Chube ole daba alin chugagwalla tanre kaire kwian daba tkanga tangle Moisés chadalla giti tanre kledu eni, ama ulita gwagedu Jesudi kwian oga ulita dodade ene, kaire ama ulita kirogwa soli tanre keruchugu ngaute no Jesu giti u gerungwa Chube olege, kirogwa e ulita kledu gerule: “¡Nga suga noare chadi ba giti che chugagwalla unsuialin David oindalla chiu nege, ba cha Chugagwalla!” Kirogwa soli ngautu no ene Jesu giti gire kwian gerunga Chube ole chugagwalla ulita kaire kwian daba tkanga tangle Moisés chadalla giti ulita skochiu Jesudige, ");
INSERT INTO sabNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ta skochie ole ama gerudu Jesuge: —¿Geru suge bage kirogwa e ulita kle gerule mine ba giti? Jesu jaindunga: —Ima, geru suge chage. Chube gerua degaba unsuialin gerule kirogwa e giti, ¿ba me chada e batabanga? Chada e gerule: “Kirogwa soli jalindi nga be suga noare Chube giti, malen ama be Chube ollade be kle mo gate diali no trate Chube giti.” Ba chada e batunga tanre agwa me suge bage chada e kle gerule mine. ");
INSERT INTO sabNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jesu gerudu ene kwian e ulita ole, gire Jesu jo siere ne ngwadige jo una soli kadakle Betaniage, chui ege ngajrege Jesu gbedu una ege. ");
INSERT INTO sabNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Nagbietege ngabebita Jesu joni chage naskuni una Jerusalén ngnagu ule kwian geru jwannga amage ole, ama ulita kledu chage jonkare gire Jesu bli ole, Jesu tadu blikalin. ");
INSERT INTO sabNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Jesu gwagedu gli kadakle higueradige jonke gire ama jo gli e gitigu gligba gweale jwen gutadale, gligba me skwenduge gutadale glinanga jegwale, gliga alin skwendu Jesuge gire Jesu gerudu glige: —¡Chui aige gwangerugu ba mi gbachie dare, ni kwian gdaite be ñage ba gba gute! Jesu gerudu ene gire sugeti allabi gli jokeda. ");
INSERT INTO sabNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kwian geru jwannga Jesuge ulita gwagedu Jesu agedu ene gli ole gire ama chegu tañachuge tanre, geru kadu Jesuge: —Gli kle no, ¿mineade gli e jokeda sugeti ngwale? Gli jogeda bedre bedre, gli me ñage jogeda blike ene gli e jokeda kare. ");
INSERT INTO sabNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesu jaindunga: —Cha gerule ulia ba ole, ba mo ta gbe ulia Chube ole Chube gai ulia me tañachuge ni sidri mo tale Chube me ñage age ba alin, ba mo ta gbe ulia ene Chube ole gire Chube kiralla giti ba ñage age ulita. Ba ñage age cha agedu kare gli ole, kaire ta amaña giti ba ñage age ma ngle cha agedu aige, ba ñage gerule jwichuga aige: “¡Joga siere nga aige, joga bleske!” Ba gerule ene jwichugage mo ta gbaba ulia Chube ole giti gire Chube be jwichuga kage bleske ba gerudu kare. ");
INSERT INTO sabNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","E kare ene ba gerule Chube ole lle gweale giti ba takalin ama age ba alin kare, kaire ba mo ta gbe ulia Chube ole Chube be age ba alin ulia ba gerudu ama ole kare, ba lle kade Chubege ta ene giti gire ulia Chube be age ba alin ba takalin kare. ");
INSERT INTO sabNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jesu jo chkeni una Jerusalénge gire jo u gerungwa Chube olege, ama kledu ne ngwadi kwian tke tangle Chube giti gire kwian gerunga Chube ole daba alin chugagwalla mneite kaire kwian israelita chugagwalla juma mneite, ama ulita chku Jesudige, geru kadu Jesuge: —¿Chema ba kagu age ba kle age kare? ¿Chema kiralla giti ba kle age ulita? ");
INSERT INTO sabNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","25","Jesu jaindunga: —Cha kaire agwe geru kade gbaite bage: ¿Chema Juan-Bautista kagu? ¿Chube Juan-Bautista kagu kwian ñe chiske o kwian Juan-Bautista kagu kwian ñe chiske? Cha gerule ba ole, ba jainnga cha kalen chema Juan-Bautista kagu, gire cha be geru kete bage chema cha kagu age ulita cha kle age kare. Jesu gerudu ene gire kwian ulita bai geru kadu Jesuge chegu gerule tanre modi Jesu geru kadu amage giti: —¿Che jainnga mine Jesu kalen? Che gerule Chube Juan-Bautista kagu kwian ñe chiske, gire Jesu be geru kade chege: “¿Gire mineade ba me Juan-Bautista gerua cha giti gau ulia?” ");
INSERT INTO sabNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Agwa che gerule kwian Juan-Bautista kagu, gire kwian ulita be che keruchuge be age gweale me no che ole gerule ene gdale, che kennga gerule ene, kwian kle tañachuge ulia Chube Juan-Bautista kagu Chube gerua kete kwiange. ¿Malen che gerule mine ama ole Juan-Bautista giti? ");
INSERT INTO sabNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kwian geru tragu ene modi Juan-Bautista giti gire ama mo ta gbu gerule Jesu ole: —Cha ulitage me uñale chema Juan-Bautista kagu. Gire Jesu gerudu ama ole: —Kaire agwe cha mi gerule ba ole chema cha kagu age ene ni cha be gerule ba ole chema kiralla giti cha kle age aini ba ulita gwa giti. ");
INSERT INTO sabNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesu gerudu dare kwian israelita chugagwalla ulita ole: —Cha be geru ñachuge bage onbre kirolla gdaboke giti, ba ulita cha keruchuge no ene ba be ñage gerule cha ole ba tañachuge mine onbre kirolla e giti. Onbre gdaite kirolla gdaboke molen, ñenua gerudu kirogwa gdaite ole: “Cha kirolla, cha takalin ba joge lle boi deage cha alin nege.” ");
INSERT INTO sabNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Kirolla e jaindunga ñenua kalen: “Cha me ta jogekalin lle boi deage nege, cha mi joge.” Kirolla gerudu ene agwa bigwa ama ta jwlitedu ama jo lle boi deage ñenua alin. ");
INSERT INTO sabNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Kaire ñenua gerudu kirolla gdaite na ole: “Cha kirolla, cha takalin ba joge lle boi deage cha alin nege.” Kirolla e jaindunga: “Ima, cha be joge lle boi deage ba alin.” Kirolla e gerudu ene agwa bigwa ama ta jwlitedu ama me jo dale. ");
INSERT INTO sabNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Jesu geru ñachugu ene gire Jesu geru kadu kwian israelita chugagwalla ulitage: —¿Kirogwa gdaboke e miamne agedu ñenua takalin kare? Kwian jaindunga: —Ñenua gerudu kirogwa ngeru ole, ama alin allabi agedu ñenua takalin kare. Jesu gerudu: —Ba gerudu ulia. Cha gerule ba ole, kwian igi ganga chugagwalla emperador nga Romamu alin kaire muinga mo chbadanga kwian onbrege, kwian ene ulita giti suge ba ulitage kwian agenga me no me no, ba ulita gwage amadi ama lle me no boanga, ama ulita salengwli kirogwa ngeru kare mo ta gbu age ñenua alin. Kwian e agedu me no me no agwa bigwa ama ta jwlitedu Chube ole, nege ama kle Chube gai ulia kle mo ta gbe age ulia Chube takalin kare, ama chege no trate Chube gwa giti ama Chubenu malen ama be toi bdagli Chube ole nga ngaña giti. Agwa ba me dale, ba ulita salengwli kirogwa bai ñenua gerudu bdagli ole kare, ba kle gerule ngwale mo ka giti alin ba ta agekalin no Chube takalin kare, agwa ba me kle Chube gai ulia me kle mo ta gbe age ulia Chube takalin kare, malen ba me Chubenu ba mi ñage toi bdagli Chube ole nga ngaña giti. ");
INSERT INTO sabNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Juan-Bautista chiu ba ulita tke tangle Chube giti, ama gerudu ba ulita ole ba mo ta blitadale Chube ole ba jogedale siere ba kle age me noge toi no Chube gwa giti Chube takalin kare, agwa ba me Juan-Bautista gerua gau ulia ba me agedu ama gerudu kare. Agwa kwian igi ganga kaire muinga mo chbadanga kwian onbrege, kwian ene tanre Juan-Bautista keruchugu Juan-Bautista gerua gau ulia, ama mo ta blitu joge siere ama kle age me noge chage no Chube takalin kare. Ba gwagedu kwian edi mo ta blite ene Chube ole, ba gwagedu kwian edi agwa ba me mo ta blitu Chube gai ulia —Jesu gerudu ene kwian israelita chugagwalla ulitage. ");
INSERT INTO sabNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jesu geru na ñachugu kwian israelita chugagwalla tanre kle mo litaba Jesudi alin, Jesu gerudu: —Cha gerule ba ulita ole, kwian onbre gdaite uvagba ngama gbu gire ama gere tku uva ngama giti tangle, kaire ama nga dodadu uvagba chia ogangwa, kaire ama dbi gweale jigu ngwale uva ngamaske u gbangwa, ama ke ulla dodadu jeike ngaña uva ngamaske uva manangwa. Uva ngama mauña lle e bo ulita bigire ama kwian gweale gau uva ngama manangale, ama uva ngama ketu kaire u uva manangwa ketu uva ngama mananga ulitage, uva ngama mauña uva ngama jigu uva manangage gire ama jo toi nga batege. ");
INSERT INTO sabNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Chui jo sbali gire uva mauñage chku uñale uvagba joge dabe suia chku gire uva mauña kwian lle boanga gweale mo alin kagu uvagba bonga amanu kade mo alin kwian uva manangage. ");
INSERT INTO sabNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kwian lle boanga e ulita jo chke kwian uva manangadige uvagba kade uva manangage, kwian uva mananga ulita kira batu ama ulita ole, uva mananga kwian lle boanga gdaite guda, ama lle boanga gdaite lendegu, ama lle boanga gdaite skiu ke giti. ");
INSERT INTO sabNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Boidu ene gire kwian uva mauña kwian lle boanga na ma ngle kagu uvagba amanu nate. Lle boanga e ulita jo chke uva manangadige gire kwian uva mananga agedu kwian lle boanga e ulita ole salengwli agedu lle boanga kagaba ngeru ulita ole kare. ");
INSERT INTO sabNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Bdagli kwian uva mauña kirolla amanu kagu uvagba nate. Ama tañachugu mo tale: “Cha be mo kirollanu kage, uñale chage kwian uva mananga ulita be cha kirolla gai dage gai ngwange no.” Uva mauña tañachugu ene, malen ama mo kirolla kagu. ");
INSERT INTO sabNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Kwian uva mananga ulita gwagedu uva mauña kirolladi chie ama gitigu, gire ama ulita gerudu modi ongoru ongoru: “Kwian chiu e uva ngama mauña kirolla, bdagli ama be chege ama ñenua llea ulita dbia ulita mauñale. Ale ama gweda, ene lle ulita be chege chege, che be chege uva ngama ai ulita mauñale.” ");
INSERT INTO sabNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Uva mananga ulita gerudu ene modi gire ama uva mauña kirolla gau du siere uva ngamallage, gire ama ulita uva mauña kirolla guda. ");
INSERT INTO sabNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jesu geru ñachugu ene ulita gire geru kadu kwiange: —¿Ba tañachuge mine geru e giti? Kwian uva mauñage be chke uñale boidu ulita ama kirolla ole gire ¿ama be age mine kwian uva mananga ulita ole? ");
INSERT INTO sabNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Kwian israelita chugagwalla ulita jaindunga Jesu kalen: —Kwian uva mauñage be chke uñale, gire ama mi tai dage kwian agedu me no ama kirolla olege, ama be kirolla jia gbe kwian e ulitage be kwian e gweda. Kaire agwe ama be kwian na gbe uva ngama manade kwian bai mo ta gbe uvagba bonga uva mauñanu kete uva mauñage uvagba joge dabe suiale. ");
INSERT INTO sabNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesu gerudu ama ulita ole: —Ulia ba gerudu e ulia. Cha gerule ba ole, Chube be age ene kwian ole kwian bai me Chube Kirolla gai ulia. ¿Ba me nu Chube gerua batabanga? Chube gerua degaba unsuialin tangle gerule Chube Kirolla be boi giti, chada e gerule: “Kwian u dodanga ke gbu gerere, ke gbaite ama mliunga, ama gerudu ke e me no dale ke e ngwale, agwa ke e ama mliunga, ke e ma no ke na ulitage. Kwian ke gbu ulita gerere, nga bebi ke gbaite alin gere me kle kiraske, ke mliabanga gbere gerere gire u chegu kiraske. Ai ulita Chube dodadu malen nga suga noare chedige.” Chube gerua degaba unsuialin gerule ene. ");
INSERT INTO sabNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","44","Cha gerule ba ole ke e giti, kwian gweale joge chke dba ke e giti kwian lentige, ke e joge chke dba kwian giti kwian mnuña alin chege ke e kote. Cha salengwli ke mliabanga kare, kwian bai me cha gai ulia ama salengwli kwian u dodanga kare, kwian bai me ta cha gakalin ulia, bdagli kwian ene be boi tanre daga ngwale be chege ji chuge diali. Cha gerule ba ole, ba kle age cha ole salengwli kwian uva mananga agedu kwian uva mauña kirolla ole kare, ba me cha gakalin ulia malen Chube be mo gerua cha giti kete kwian nage kwian me israelitage, kwian e be geru e gai ulia. ");
INSERT INTO sabNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Jesu geru ñachugu ene ulita gire sugedu trate kwian gerunga Chube ole daba alin chugagwalla ulitage kaire kwian fariseo ulitage Jesu kle gerule ama ulita giti. ");
INSERT INTO sabNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Gire e giti ama ulita skochiu tanre Jesudi, ama ulita tadu Jesu gakalin blike tkale skage gwaleda agwa ama ulita kendunga kwian ngleadi age Jesu ole, kwian ngle kle Jesu gai kwian Chube gerua ketangale malen kwian Jesu dollale kendunga age Jesu ole ama tadu agekalin kare. ");
INSERT INTO sabNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesu geru ñachugu kwian ngle alin kwian mo jwen chuia ollade giti, Jesu gerudu: ");
INSERT INTO sabNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Cha gerule ba ole, kwian ulita bai Chube gai ulia mo Chugagwallale, bdagli kwian ene be joge toi Chube ole nga ngaña giti salengwli kwian joge mo jwen chuia ollade kare, cha geru ñachuge bage e giti: Kwian chugagwalla gdaite chui tke mo kirolla mo jwen chuia ollade, ama kwian ulita ta gbangu mo jwen chuia giti. ");
INSERT INTO sabNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Chui e chku, lle ulita kledu biale mo jwen chuia ollade gire kwian chugagwalla lle boanga mo alin gweale kagu kwian ulita kade mo lite ule mo kirolla mo jwen chuia ollade, agwa kwian ngle jo kadaba me jaindu mo lite mo jwen chuia ollade. ");
INSERT INTO sabNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Boidu ene gire kwian chugagwalla kwian lle boanga na kagu gerule kwian kadaba ole nakwaite, chugagwalla gerudu kwian lle boanga e ulita ole: “Ba gerule kwian kadaba ulita ole: ‘Bligda kle biale gutadale, cha chugagwalla bda ngle blodi gwanguda kwian ulita alin gutadale, bai mo jwen chuia ollade.’ ” ");
INSERT INTO sabNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Kwian lle boanga mo chugagwalla gerua ketu kwian kadaba ulitage agwa kwian me nga talladu chui ollade giti, ni gdaite jo chugagwalla ngwadi chui ollade. Kwian kadaba gweale jo lle boi deage, gweale jo lle na boi mo alin, ");
INSERT INTO sabNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","kwian kadaba na ulita lle boanga chugagwalla alin ulita gau batu bo dagale gire kwian ama ulita guda. ");
INSERT INTO sabNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","E ulita chku uñale kwian chugagwallage gire ama skochiu tanre, chugagwalla guardia donga tanre mo alin kagu kwian gweda lle boanga jokeda jiale, kaire chugagwalla gerudu guardia donga ulita ole kwian lle boanga gwangada unalla gugadale ulita. Kwian chugagwalla gerudu ene gire guardia ulita agedu kwian chugagwalla gerudu kare. ");
INSERT INTO sabNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Bigire kwian chugagwalla gerudu nakwaite kwian lle boanga na gweale ole: “Lle ulita kle boabale chui ollade kwian alin agwa kwian me tadu chiekalin, kwian e ulita ta me no, ma no che kwian na jinade mo jwen chuia ollade. ");
INSERT INTO sabNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Joga chage jonkare, kwian ulita bai kaire ba ten ngwange jonkare ba kade cha kirolla mo jwen chuia ollade.” ");
INSERT INTO sabNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Chugagwalla gerudu ene gire kwian lle boanga chugagwalla alin jo chage jonkare, kwian ulita skwendu amage, ama kwian e kadu, kwian e gweale kwian no kaire gweale kwian me no. Kwian e ulita jo mo lite mo jwen chuia ollade, gire kwian chugagwalla ulla chku ete kwian ngle ole chui ollade. ");
INSERT INTO sabNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Kwian kadaba ulita kledu manade gwa gire kwian chugagwalla jo chke kwian ulita kle manade ngwadi, chugagwalla chku gwa tienda kwian ulita kadaba chui olladedige. Ama tendu kwian onbre gdaitedi, kwian onbre e me mo ngama tkaba no mo jwen chuia ollade ñometrallaske kwian na ulita kare. ");
INSERT INTO sabNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kwian chugagwalla gerudu kwian gdaite e ole: “¿Mineade ba chku aini gwa me mo ngama tkaba no mo jwen chuia ollade ñometrallaske? Bage chke uñale ba me kle chage ñometra noske, ñometra e ba kle chageske me tkakle modi chui mo jwanngwa olladakle ngwadi.” Kwian chugagwalla ka bo ene kwian onbre e ole gire kwian onbre chegu kamne mo giti. ");
INSERT INTO sabNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Kwian chugagwalla gerudu lle boanga amanu ole: “Onbre e jwen sugekare ko luge sera luge, mli jondoi nga jereske, ama chegedale goga olire sugekare chage.” Kwian chugagwalla gerudu ene ulita gire lle boanga agedu onbre ole ama gerudu kare. Jesu geru ñachugu ene, gire Jesu gerudu dare: —Cha gerule ba ole, e kare ene kwian bai me Chube gerua gakalin, bdagli ama be boi daga ngwale ji chuge ngwadi nga dbigu giti, ne ngwadi ama be ta olire tanre sugekare Chubege. ");
INSERT INTO sabNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Kwian tanre kle Chube gerua keruchuge agwa gire uñale Chubege kwian ulita me ta ama gerua gakalin ulia, kwian bedreare alin be ama gerua gai ulia, Chube kwian ene ta gbe tañachuge no geru ulia giti. ");
INSERT INTO sabNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Jesu gerudu ene ulita gire kwian fariseo ulita jo mo ten Jesudi sugekare Jesu tke gdege, ama takalin Jesu gerule gweale mau tale ene ama ñage Jesu tke skage Jesu gerudu giti. ");
INSERT INTO sabNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Malen ama ulita mo skatemanalla gweale kagu ule kwian chugagwalla rey Herodes skatemanalla gweale ole tienda Jesudi Jesu kle ngwadi mo chuge Jesu ole Jesu gbe gerule gweale chugagwalla kweri emperador dollale giti, kwian e ulita jo chke Jesudige gire gerudu Jesu ole: —Ba kwian tkanga tangle geruge, uñale chage ba diali kle gerule ulia trate, kaire ba kle kwian ulita tke tangle geru ulia giti kwian toidale mine Chube takalin kare. Ba kle gerule kwian ulita ole salengwli, ba gwa giti kwian salengwli ulita. Ba kle mo ta gbe age ene diali me mo tallade kwian tañachuge mine badi giti. ");
INSERT INTO sabNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ba kwian ene malen cha geru kade bage gbaite, ba jainnga cha kalen ba tañachuge mine. Geru gbaba nga Romage kwian ulita igi ketadale kwian chugagwalla kweri nga Romamuge, cha me kwian nga Romamu, cha kwian israelita, gire ¿no Chube gwa giti cha igi kete kwian chugagwalla kweri nga Romamuge ama kle kade chage kare o cha me igi ketadale amage? —kwian geru kadu ene Jesuge ta me no ole Jesu gbagda jiske gerule me no gweale giti. ");
INSERT INTO sabNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesuge uñadu kwian e kle tañachuge me no amadige, gire Jesu gerudu ama ulita ole: —Ba ulita kle mo chuge ta me no giti cha ole, ¿mineade ba kle gerule ene cha ole? Cha gwale ba kle gerule no cha ole agwa ba tale ba kle tañachuge me no chadi. ¿Mineade ba cha batakalin gdege? ");
INSERT INTO sabNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Igi ketakle kwian chugagwalla nga Romamuge, igi kete chage gaite gwagegda. Kwian igi ketu Jesuge gaite gwagegda, ");
INSERT INTO sabNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","gire Jesu geru kadu kwiange: —¿Chema oña kle gbaba igi ai giti? ¿Kaire chema kalla kle gbaba igi ai giti? ");
INSERT INTO sabNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Kwian jaindunga: —Kwian oña e chugagwalla kweri emperador nga Romamu kada César, kaire ama kalla kle gbaba igi e giti. Kwian jaindunga ene gire Jesu gerudu: —Lle chugagwalla kweri Césarnu kaire keteni Césarge, lle Chubenu kaire keteni Chubege. ");
INSERT INTO sabNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Kwian ulita Jesu keruchugu gerule ene gire kwian chegu tañachuge tanre Jesu gerudu giti ama ole, gire ama me ñadu Jesu gbe jiske malen ama ulita Jesu jigu ne ngwadi ama ulita joni. ");
INSERT INTO sabNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Chui amañage kwian saduceo mneite jo Jesu kle ngwadi geru kade Jesuge, kwian saduceo kle gerule kwian jogebakeda jaba mi chkeni gwade chui bdaglige, ama tadu Jesu gbe gerule gweale Moisés nu Chube gerua degaba unsuialin dollale, malen ama gerudu Jesu ole: ");
INSERT INTO sabNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Ba kwian tkanga tangle geruge, uñale bage Moisés Chube gerua degu unsuialin, chada e gerule kwian onbre jogekeda me kirogwa molen mo muira giti, gire ama daballa na kle gwade mo jwandale ñanea oli ole, ene onbre e kirogwa molen muinga e giti daballa jogebakeda alin, ene daballa olia chege gdaite muinga e giti. Moisés chadalla gerule ene. ");
INSERT INTO sabNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nege cha gerule ba ole boidu cha bitallaske giti, aini cha bitallaske onbre gdaguke modi mo daballale. Daballa kimule mo jun muinga ole agwa ama jokeda ni ama kirogwa molen gdaite mo muira giti. Gire daballa nate mo jun ñanea oli ole, ");
INSERT INTO sabNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","agwa daballa e kaire jokeda ni ama kirogwa molen gdaite muinga e giti. Gire onbre jogebakeda daballa na ama nate mo jun muinga amaña ole, agwa ama boidu salengwli ama daballa ngeru gdaboke kare, ama gdamai ulita jokeda ni muinga ko toidu kirogwage gdaite. Boidu ene ulita onbre gdaguke e ulita ole, ama ulita gdaite gdaite mo jun muinga amaña ole, muinga e chegu ama gdaguke muiralla, agwa ulita gdaguke jokeda gdaite gdaite, ni ama gdaite kirogwa molen muinga e giti. ");
INSERT INTO sabNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Bdagli muinga gballa e jokeda kaire agwe. ");
INSERT INTO sabNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Cha gerule ba ole, ulia onbre e gdaguke ulita toidu gdaite gdaite muinga amaña ole mo muira kare, chui bdaglige kwian jaba ulita be chkeni gwade chuiage, ¿chui ege onbre bai be chege muinga e ñengulallale? ");
INSERT INTO sabNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesu jaindunga kwian saduceo kalen: —Ba me kle tañachuge trate dale, ni ba geru ulia uñe. Ba me Moisés nu Chube gerua degaba unsuialin uñe trate, kaire me suge trate bage Chube kweri Chube ñage age ulita mo kiralla giti, malen ba me kle tañachuge trate geru e giti. ");
INSERT INTO sabNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Sugedale trate ba ulitage chui bdaglige Chube be kwian jaba ulita gbeni gwade kwian onbrenu muirenu mi mo jwen ni be tañachuge mo jwen giti, ama ulita be chege salengwli lle boanga Chube alin nga ngaña giti kare, lle boanga Chube alin nga ngaña giti me mo jwen. ");
INSERT INTO sabNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","¿Me uñale ba ulitage Moisés nu Chube gerua degaba unsuialin gerule trate kwian jaba be chkeni gwade giti? ¿Ba me chada e batabanga? Chada e giti Chube gerule trate ba ulita alin, chada e gerule: ");
INSERT INTO sabNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Cha Abraham Chubea, cha Isaac Chubea, cha Jacob Chubea, ama ulita kle cha gai mo Chugagwallale.” Moisés Chube gerua degu ene unsuialin tangle, e giti ñage suge trate ba ulitage chui bdaglige kwian ulita jogebakeda jaba be chkeni gwade. Abraham kaire Isaac kaire Jacob ama gdamai jogebakeda gire Chube gerudu Moisés ole ama gdamai giti Chube ama Chubea, ulia Chube kwian gwade alin Chubea, ama me kwian jaba Chubea, malen chkedale uñale bage kwian jogekeda kwian oña e kle chege gwade, kaire agwe chui bdaglige kwian jaba ulita be chkeni gwadeni. ");
INSERT INTO sabNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jesu gerudu ene ulita kwian saduceo ole, gire kwian nglea kledu eni kaire Jesu keruchugu, kwian e ulita chegu tañachuge tanre no Jesu kwian saduceo tku tangle giti. ");
INSERT INTO sabNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jesu gerudu giti kwian saduceo ole Jesu ama ulita gbu ka chite, e chku uñale kwian fariseoge gire kwian fariseo ulita mo litu Jesudi tangle. ");
INSERT INTO sabNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Kwian fariseo e gdaite ama daba tkanga tangle Moisés chadalla giti, ama tadukalin Jesu gbe jiske geru gweale giti, ta ene ole ama geru kadu Jesuge: ");
INSERT INTO sabNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Ba kwian tkanga tangle geruge, cha geru kade bage, Moisés Chube gerua degu unsuialin, ¿geru e bai ma kweri geru ulitage cha gadale dage? ");
INSERT INTO sabNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesu jaindunga ama kalen: —Moisés chadalla gerule ene: “Ba nodale ba Chugagwalla kweri Chube ole, ba mo ta dbadale no trate ulita ama ole diali, ba tañachugadale diali mo tale ama giti, ba mo chuga gbale no Chube alin ole.” ");
INSERT INTO sabNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Chube gerua e ma kweri na ulitage gbadale gdadi. ");
INSERT INTO sabNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Agwa kaire agwe geru na gbabokedale kweri ba gbadale gdadi, geru e kle gerule: “Ba mo ta dbadale no daba na ulita ole salengwli ba no mo ole naskuni kare.” ");
INSERT INTO sabNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Moisés Chube gerua tanre jigu degaba geru e no, kaire kwian Chube gerua ketanga ama ulita Chube gerua tanre jigu degaba trate kwian alin, agwa geru gbaboke ai ma kweri Chube gerua na ulita kle degabage —Jesu gerudu ene kwian fariseo ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Kwian fariseo kledu Jesudi tangle mo litaba ole ngmadi, gire Jesu geru kadu ama ulitage: ");
INSERT INTO sabNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—Uñale bage unsuialin Chube gerudu be Cristo kage kwian alin, ¿ba tañachuge mine Cristo giti, Cristo chema oindalla? Kwian fariseo jaindunga: —Cristo che enusulian oña David oindalla. ");
INSERT INTO sabNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jesu gerudu: —Ba gerule Cristo enusulian oña David oindalla, e ulia, agwa Cristo me David oindalla alin allabi, kaire Chube Oña David ta gbu Cristo kade mo Chugagwalla, unsuialin David chada degu e giti, chada e gerule: ");
INSERT INTO sabNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Chube gerudu cha Chugagwalla ole: ‘Toi dba cha ngena cha ko taingwli giti, chui be chke gire cha be ba gbe kirachke ba dolla ulitadi, ba be chege dolla ulita Chugagwalla kweri.’ ” ");
INSERT INTO sabNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","David chada degu ene unsuialin Cristo giti, chada e giti sugedale kwian ulitage Cristo me David oindalla alin allabi, agwa kaire Cristo David Chugagwalla, David agali gerudu Cristo ama Chugagwalla. ");
INSERT INTO sabNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Jesu gerudu ene kwian fariseo ulita ole agwa ni ama gdaite ñadu jainnga ni sidri Jesu kalen. Ne suiagebi kwian me jaindu geru kade dare Jesuge mo chuge Jesu ole, sugedu kwian ulitage Jesu ta ole kwian me ñage kirachke Jesu gbe jiske geru giti ama tadukalin kare. ");
INSERT INTO sabNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ne suiagebi kaire Jesu gerudu kwian tanre kle mo litaba Jesudi ole kaire kwian geru jwannga amage gdataboko giti gdaboke ole: ");
INSERT INTO sabNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Kwian daba tkanga tangle Moisés chadalla giti ulita kaire kwian fariseo ulita kle geru trage Moisés nu Chube gerua degaba unsuialin giti kwian na ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Cha gerule ba ole, ama ulita kle gerule ulia Moisés chadalla giti, ba kwian e kerua gai kle gerule Moisés chadalla giti, ba agedale ama kle gerule kare agwa ba me age ama kle age kare, ama agali me kle age no ama kle daba tke tangle kare, ama kle gerule nganake gire kle age nganake. ");
INSERT INTO sabNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Kwian daba tkanga tangle Moisés chadalla giti kaire kwian fariseo, kwian e ulita kle age me no daba na ulita ole, ama kle daba na gbe age ulita Moisés chadalla gerule kare, kaire ama kle daba gbe age geru na ama agali kle gbe gerule kare. Ama daba na ulita gbe age ene agwa ama agali me kle age. Kaire ama me kle daba na chudaboi age no geru kle gbaba kare. ");
INSERT INTO sabNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ama ulita ta lle boakalin ulita Chube alin kwian na gwa giti ene kwian na ñage gwage amadi kwian ñage gerule no ama giti. Chube gerua gweale degaba chada soli giti ama kle luge mo skadagdage kaire mo kligda jegwale kwian israelita kle age kare, agwa ama kle chada e dodade ma kweri kwian na ulita kle dodadege kle luge mo skadagdage kaire mo kligda jegwale, ene ama tañachuge kwian na ulita ñage ten chadadi no ñage gerule kwian e lle boanga no ulia Chube alin. Kaire ama kle ñometra no tke modi ama kle gerule Chube oleske dbe ma no jeike kwian na gwa giti, ene ama tañachuge kwian na ulita ñage gerule no ama giti ama kwian gerunga no Chube ole. ");
INSERT INTO sabNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Kaire kwian e kle joge chui ollade gire kle nga ma no bligda gutangwa jinade ama toikalin dba ule kwian chui olladanga chugagwalla ole, ama kle mo gbe ma kweri kwian nage. Kaire ama kle joge u mo litangwa Chube gerua jwanngwage gire ama ta toikalin toingwa ma no giti kwian na ulita gwa giti. ");
INSERT INTO sabNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Kaire agwe kwian e kle chage jonkare, kwian na ten ama ngwange ama takalin kwian e ulita ama gai dage tañachuge ama kwian kweri, ama takalin kwian gbi kade no amage kwian kle gbi kade mo chugagwalla kwerige kare. Kaire ama takalin kwian gerule no ama ole: “Ba daba tkanga tangle geruge no.” Ama takalin kwian gerule diali no ene ama ole. ");
INSERT INTO sabNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Jesu gerudu jonlekanga kwian ulitage ene, gire Jesu gerudu kwian geru jwannga ole: —Cha me takalin ba age kwian fariseo ulita kaire kwian daba tkanga tangle Moisés chadalla giti ulita kle age kare. Ba me mo gbe ma kweri daba nage, kaire ba me daba na chuge ngwadi ba kade daba tkanga tangle geruge, ba ulita salengwli modi, cha alin allabi ba ulita tkanga tangle. ");
INSERT INTO sabNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kaire ba me ñage kwian ngwale nga dba ai giti kade mo ñenua kare ba Chube ka jwen kare. Ba Ñenua gdaitre alin allabi kle toi nga ngaña giti, ba Ñenua Chube, ba ama gadale dage. ");
INSERT INTO sabNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Chube nu cha kagaba nga dba ai giti kwian ulita Chugagwallale. Cha alin allabi ba ulita Chugagwalla ba me ñage mo gbe daba na chugagwallale. ");
INSERT INTO sabNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ba ta chegekalin kweri daba na gwa giti ba mo ta gbadale diali age no daba na ulita alin daba chudaboi ta no giti. ");
INSERT INTO sabNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kwian baige suge kweri mo tale kaire mo gbe no kweri kwian na gwa giti, Chube gwage kwian ene me kweri, ama ngwale ama soli. Agwa kwian baige suge soli mo tale kaire mo gbe daba na chudaboangale, Chube gwage kwian ene kweri. ");
INSERT INTO sabNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Jesu gerudu ene ulita kwian geru jwannga amage ole, gire Jesu mo ta gbu gerule kwian daba tkanga tangle Moisés chadalla giti ulita gwale kaire kwian fariseo ulita gwale, Jesu gerudu: —Ba kwian daba tkanga tangle Moisés chadalla giti kaire ba kwian fariseo, cha gerule ba ulita ole, ba ulita be ji chuge tirare bdagli ba kle age giti, ba kle gerule nganake ba kle age nganake. Ba kate ba kle gerule ba kle Chube gerua gai ulia ba kle Chube gai mo Chugagwallale, agwa ba tale ba me kle Chube gerua gai ulia ba me kle Chube gai mo Chugagwallale, malen ba me Chube uñe ba me Chubenu. Kwian na tanre ta Chube gerua uñakalin no trate ba giti agwa ba me takalin kwian e Chube gerua gai ulia mo alin ba me takalin ama Chube gai mo Chugagwallale, malen ba me kle ama chudaboi Chube gerua ulia uñe ba me kle ama tke tangle trate geru uliage. Age ene gdale ba ulita be ji chuge tanre bdagli. ");
INSERT INTO sabNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ba kwian daba tkanga tangle Moisés chadalla giti kaire ba kwian fariseo, cha gerule ba ulita ole, ba ulita be ji chuge tirare bdagli ba kle age giti, ba kle mo gbe no kweri kwian gwa giti, ba takalin kwian ulita gerule no ba giti malen ba kle gerule sbali Chube ole ngle kwian gwa giti, ene kwian be tañachuge ulia ba kwian agenga no no Chube alin. Ba kle age ene kwian gwa giti agwa ba tale ba kwian me no, ba kle age tanre me no muinga chegeba oli ñengulage ole, ba kle u jwennga muinga e ngeru, e gdale ba be ji chuge tanre ba agedu me no ene muinga oli ole giti. ");
INSERT INTO sabNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ba kwian daba tkanga tangle Moisés chadalla giti kaire ba kwian fariseo, cha gerule ba ulita ole, ba ulita be ji chuge tirare bdagli ba kle age giti. Ba kle joge nga ulitage baini kaire ba ñage joge ngwadi, nga e ulitage ba kle kwian me israelita tke tangle ba kwian israelita suia giti, ba takalin kwian ene ba suia gai mo alin. Kwian me israelita gdaitre alin mo ta blite ba ole ba suia gai mo alin gire nga suga no no badi. Agwa ba me kle age no kwian e alin, kwian e ba suia gai gire ama mi Chube gerua ulia gai, ama be mo ta gbe age me no ba kle age me no kare, agwa kaire ama be age ma me no ba kle agege. Ba kle age ene ba kle kwian e gbe jiske Chube gwa giti ba kbiale, ama be boi daga ngwale tanre bdagli nga dbigu giti ma tirare ba be boige. ");
INSERT INTO sabNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’Cha gerule ba ulita ole, ba ulita be ji chuge tirare bdagli ba kle age giti. Ba kle kwian tke tangle Chube gerua giti, agwa Chube gerua me suge bage trate, ba me ñage kwian tke tangle no trate geru ege salengwli kwian gwagwa me me ñage kwian na jonlla dbe kare. Ba kle daba tke tangle gire ba kle sole ama ole, ba kle gerule ai kare ama ole: “Ba gerule u gerungwa Chube ole kalla giti ba be age gweale ulia ulia, ba gerule ene gire ba me age ba gerudu kare ba me talladale e giti, ba me agedale ba gerudu kare u gerungwa Chube ole kalla giti. Agwa ba gerule lle ñanaske kada oro kle gwa u gerungwa Chube olege kalla giti ba be age gweale ulia ulia, ba gerule ene ba me ñage gerule alin ngwale ba be age, ba mo ta gbadale age ulia ba gerudu kare oro kalla giti.” Ba kle gerule ngwale ene kwian ole. ");
INSERT INTO sabNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ulia ba ulita chuga me, ba kwian gwagwa me kare, geru ulia me suge bage. ¿Mineade ba kle gerule oro kle gwa u gerungwa Chube olege oro e ma ñanaske Chube gwa giti u e amañage? Oro me kle gwa u ege gire oro e me ñanaske dale Chube gwa giti. ");
INSERT INTO sabNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kaire ba kle sole daba na ole ai kare: “Ba gerule nga bda gugakle ngwadi kalla giti ba be age gweale ulia ulia, ba gerule ene gire ba me age ba gerudu kare ba me talladale e giti, ba me mo ta gbadale age ulia ba gerudu kare nga bda gugakle ngwadi kalla giti. Agwa ba gerule bda gugakle Chube alin kalla giti ba be age gweale ulia ulia, ba gerule ene ba me ñage gerule alin ngwale ba be age, ba mo ta gbadale age ulia ba gerudu kare.” Ba kle gerule ene daba ole, ene ba kle kwian tke tangle age ngwale. ");
INSERT INTO sabNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ba ulita kwian gwagwa me kare, geru ulia me suge bage dale. ¿Mineade ba kle gerule bda gugakle Chube alin ma ñanaske Chube gwa giti ngage bda gugakle ngwadi? Bda e me kle nga ege gire bda e me ñanaske dale Chube gwa giti. ");
INSERT INTO sabNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kwian bai kle gerule nga bda gugakle ngwadi kalla giti ama be age gweale ulia ulia, kwian ene me kle gerule nga e kalla alin allabi giti, agwa kaire ama kle gerule lle ulita mangire batre kle ne ngwadi kalla giti. ");
INSERT INTO sabNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Kaire agwe kwian bai kle gerule u gerungwa Chube ole kalla giti ama be age gweale ulia ulia, kwian ene me kle gerule u e kalla alin allabi giti, kaire ama kle gerule Chube agali kalla giti, Chube kle kwian ole diali u ege. ");
INSERT INTO sabNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kwian bai kle gerule nga ngaña Chube kle ngwadi kalla giti ama be age gweale ulia ulia, kwian ene me kle gerule nga e kalla alin allabi giti, ama kle gerule kaire agwe Chube toigdalla no kweri kalla giti, Chube kwian ulita Chugagwalla kle toiba dba toigda e giti nga ngaña giti. ");
INSERT INTO sabNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’Ba kwian daba tkanga tangle Moisés chadalla giti kaire ba kwian fariseo, cha gerule ba ulita ole, ba ulita be ji chuge tanre bdagli, ba me kle age no Chube takalin kare. Ngwale ba kle lle ulita maunu kete sidri Chubege Moisés chadalla gerule kare, gliga kada menta kaire gliga kada anís kaire chude soli kada comino ba kle kete sidri Chubege, ba kle lle e ulita kete sidri Chubege gire ba tañachuge ba no trate ulita Chube gwa giti. Ngwale ba kle lle alin kete Chubege, ba ta me kle Chube ole, kaire ba me kle mo ta gbe age no daba na alin. Ba ta chegekalin no trate Chube gwa giti, ngeru ba mo ta gbadale ulia Chube ole, ba agedale no daba ulita alin, ba taidale dage dabage ama chudaboi, Chube gwage age ene ulita ma no lle ulita maunu kete sidrige, ba mo ta gbe age ene gire ba lle ulita maunu kete sidri Chubege Moisés chada degu kare. ");
INSERT INTO sabNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ba kle kwian tke tangle Chube gerua giti agwa geru e me suge trate bage dale, ba kwian gwagwa me kare kwian na jonlla dbe. Diali ba kle tañachuge age Moisés nu Chube gerua degaba alin gerule kare ene ba tañachuge ba chege no trate Chube gwa giti. Agwa ba me kle mo ta gbe ulia Chube ole age no trate ulita ama takalin kare, ni suge bage ba kle age me no Chube gwa giti. E salengwli kwian kle bellekwa jai kare gire ama ten jinisolindi bellekwaske, ama jinisolin jwennga bellekwage mlienga gire bellekwa chege no trate ama bellekwa jai ulita. Agwa lle ma kweri jinisolinge kle bellekwaske bda camello batre, ni ama ten lle edi, ama bellekwa e ulita jai dbige me tallade, me chke uñale amage lle me no kle bellekwaske. ");
INSERT INTO sabNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","26","’Ba kwian daba tkanga tangle Moisés chadalla giti kaire ba kwian fariseo, ba ulita be ji chuge tirare bdagli, ba kle mo gbe no kweri kwian gwa giti agwa ba ta me no ulia. E salengwli kwian kle chi jangwa kaire batekwa glige giti tangle alin kare gire tañachuge chi jangwa kaire batekwa chege trate ulita, agwa batekwa kaire chi jangwa gligaba ene me trate dale, chi jangwa e kaire batekwa e skieru kle chege sugaska. Ene kaire ba, ba ulita kle tañachuge ba age ba enusulian unsuialin suia alin kare, ene ba kwian no trate Chube gwa giti, agwa me ene ba kle tañachuge kare, ba tale ba ta me no, age me no tanre kle ba tale diali, diali ba kle tañachuge mo tale skwe boi daba ngeru kaire age tanre me no daba dollale. Ba ulita kle chage kwian gwagwa me kare, me suge bage Chube takalin mine. Ba ulita gdaite gdaite mo ta blitadale ngeru Chube ole gire ba ta be chege no trate chi jangwa kaire batekwa gligaba no trate skieru kare, ene ba be ta agekalin no trate Chube takalin kare. ");
INSERT INTO sabNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’Ba kwian daba tkanga tangle Moisés chadalla giti kaire ba kwian fariseo, ba ulita be ji chuge tirare bdagli ba kle age giti, ba me kle age no ulia Chube takalin kare. Ba ulita salengwli nga kwian jogebakeda tkakle keugage ngwadi kare, kwian kle nga keuga ege dai jutre ene kwian gwage keugadi keuga kle chege no trate giti tangle. Agwa keuga skieru kwian jogebakeda gda alin kle ngle keugage kaire lle na tanre ñachke sugaska kle ne ngwadi. ");
INSERT INTO sabNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","E kare ene ba, kwian kle gwage ba ulitadi kle tañachuge ba kwian no ba kle age no Chube takalin kare, agwa ba tale ba ta me no Chube gwa giti. Ba kle gerule nganake ba kle age nganake, ba kle gerule mo ka giti alin allabi no, agwa ba kle age mau tale diali me no, e gdale Chube be ji gbe ba giti bdagli. ");
INSERT INTO sabNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’Ba kwian daba tkanga tangle Moisés chadalla giti kaire ba kwian fariseo, cha gerule ba ulita ole ba ulita be ji chuge tanre bdagli ba kle age me no gdale, ba kle gerule nganake ba kle tañachuge mo tale nganake. Ba enusulian unsuialin kwian ngle Chube gerua ketanga gau, guda, kwian Chube gerua ketanga e jaba jo tkaba dbige, gire nege tangle ba ulita kle kwian e jaba dbia dodade no trate ba kle nga e manade no, ba kle lle gweale no gbe kwian Chube gerua ketanga unsuialin jaba dbia giti, age ene giti ba takalin kwian ulita tañachuge ba kle Chube gerua ketanga oña e ulita gai dage malen ba kle ama jaba dbia manade no. ");
INSERT INTO sabNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Kaire ba ulita kle gerule: “Cha enusulian unsuialin kwian ngle Chube gerua ketanga guda, cha me kledu toi chui ege, agwa cha toidu chui ege cha me agedu cha enusulian unsuialin agedu kare kwian Chube gerua ketanga ole, chage suge cha enusulian unsuialin ulita agedu me no.” ");
INSERT INTO sabNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ba ulita kle gerule ene agwa ba tale ba kle tañachuge nobi ba enusulian unsuialin Chube gerua ketanga ngle guda, malen ba kle mo gbe jiske Chubege salengwli ba agali kwian e guda kare. ");
INSERT INTO sabNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ba ulita kwian ta me no ba enusulian unsuialin tangle ta me no kare, malen ba kaire be age me no kwian Chube gerua ketanga dabage nege tangle ole, ba be ama gbe boi daga ngwale ba be ama gweda. ");
INSERT INTO sabNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’Ba ulita kwian agenga me no me no, diali ba ta agekalin me no Chube dollale, ba ta me no molen. Ba kle tañachuge ba be tien gitiru ji chugege nga dbigu giti agwa me dale, ba ulia be boi daga ngwale tanre ji chuge ngwadi nga dbigu giti ba agedu me no ulita kbiale. ");
INSERT INTO sabNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Chage uñale ba be age me no kwian Chubenu tanre ole, malen cha be kwian Chube gerua ketanga kage ba alin, cha be kwian ta ole kage ba alin kaire cha be kwian daba tkanga tangle kage Chube gerua trage ba ole. Agwa ba be kwian ene gweale gweda kaire ba be ama gweale gbe kruge gwaleda, ba be ama gweale gbe boi daga ngwale, ba be ama gweale lendege u mo litangwa Chube gerua jwanngwage kwian na gwa giti kaire ba be ama gweale jrite nate una kaire kairege. ");
INSERT INTO sabNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Bdagli ba be ama ulita jia chuge ba agedu me no ulita ene kare ama ole gdale. Kaire ba enusulian unsuialin tangle kbiale ba be ji chuge, ba enusulian unsuialin tangle kwian Chube gerua ketanga guda tanre, Chube be kwian e ulita gwabada jia kade ba kwian kle toi nege tanglege. Kwian kada Abel ama kwian unsuialin agenga no Chube gwa giti ama jo gwabada, e suiage dare kwian ngle Chube gerua ketanga jo gwabada, chku kwian kada Zacarías suiage tangle, Zacarías kaire jo gwabada, ama jo gwabada u gerungwa Chube olege, Zacarías e Berequías kirolla. ");
INSERT INTO sabNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Cha gerule ulia ba ulita ole, Chube be kwian Chube gerua ketanga e ulita gwabada jia kade ba kwian kle toi nege tanglege —Jesu gerudu ene ulita kwian daba tkanga tangle Moisés chadalla giti ulitage kaire kwian fariseo ulitage. ");
INSERT INTO sabNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jesu kledu tañachuge tanre kwian ulita una Jerusalénmu giti gire gerudu: —Kwian ulita una Jerusalénmu, ba enusulian unsuialin kwian ngle Chube gerua ketanga guda, kaire nege Chube kle mo gerua dbanga ngle kage ba ulita alin, ba kle ama skie ke giti kle ama gweda, ba kle age salengwli ba enusulian oña unsuialin agedu kare. Cha ta olire tanre ba ulita giti, cha noare ba ulita ole, agwa ba me no cha ole. Cha tadukalin tanre age no ba ulita alin ba ulita manade no salengwli koi kle soli lite ole manade no jiga gwaru kare, agwa ba ulita me tadukalin cha age ene ba alin, ba me cha gau ulia. ");
INSERT INTO sabNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Malen cha ba chuge ngwadi jogengale sugekare chage. ");
INSERT INTO sabNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Cha gerule ba ulita ole, nege gwangerugu ba mi gwage chadi dare aini, agwa chui bdagli be chke gire ba ulita be gwage chadi chieni nakwaite, chui ege be suge ba ulitage Chube cha kagu ba ulita alin gire ba ulita be gerule cha giti: “Ama noare, Chube ama kagu nga dba ai giti kwian ulita alin” —Jesu gerudu ene ulita kwian una Jerusalénmu giti. ");
INSERT INTO sabNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesu jo gwajondoida u gerungwa Chube olege gire kwian geru jwannga amage ulita chku Jesudi gerule ama ole u gerungwa Chube ole giti. Kwian geru jwannga gerudu u e noare, ");
INSERT INTO sabNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","gire Jesu gerudu ama ole: —Nege ba kle gwage u kweri edi u e no no dodaba ke kweri no giti, agwa cha gerule ulia ba ulita ole, me sbali u e ulita be chege skianbada lle ngwale kare, ke mi chege gbaba mo giti giti ni gbaite, u ulita be chege skianbada. ");
INSERT INTO sabNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jesu gerudu ene kwian geru jwannga ole gire Jesu jo Ngwiskinro Jwichugallage, ne ngwadi Jesu toidu dba gire kwian geru jwannga Jesuge ulita chku Jesudige, geru kadu Jesuge sugekare: —Cha geru jwannga bage batre takalin ba geru kete chage, ¿ngaminegire u gerungwa Chube ole be joge skiendba ba gerudu kare? ¿Nga ai ulita be boi mine ba be chieni ngwange gire? ¿Be boi mine ngeru gire ene chke uñale cha ulitage chui bdagli kle kodi? ");
INSERT INTO sabNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesu jaindunga: —Ba ulita kledale ta giti ene ba mi skate alenske ba mi mo chuge ngwadi mo anblitange kwian daba anblitangage cha chieni chuia giti. ");
INSERT INTO sabNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Chui bdagli chke kodi gire kwian tanre be chie mo gbe kweri gerule no mo giti daba anblitagda, ama be chage kwianske mo ka gbaba cha kalla giti gerule mau giti: “Cha Cristo, Chube cha kaguni kwian alin.” Kwian tanre be chage gerule ene agwa kwian ene me ulia Cristo, kwian ene ulita be kwian tanre anblite geru ngwalege, kwian tanre be ama gerua gai ulia. ");
INSERT INTO sabNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ba be geru keruchuge kwian kle dole tanre kweri modi nga tanrege, ba geru e keruchuge ba me mo ta dbe kennga kle boi giti. Boidale ene ulita ngeru agwa chui bdagli bebi chke. ");
INSERT INTO sabNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Kwian chudalla na be mo tke dole kwian chudalla na ole, kaire kwian toinga nga kweri nage be mo tke dole kwian toinga nga kweri nage ole. Kaire bli suia kweri be kle tanre, kwian ngle be jogekeda bli kweri kote, kaire nga be jwlien tanre kegde kweri be chite tanre nga tanrege. ");
INSERT INTO sabNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","E ulita be kle boi gwangeale nga dba ai giti agwa chui bdagli bebi chke, lle na tanre tirare be boi ngeru, lle e ulita kote kwian be ta olire tanre boi daga ngwaleske. ");
INSERT INTO sabNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Kaire kwian cha dollale be ba ulita cha gerua ganga kete mo chugagwallage, chugagwalla e kote ba be boi daga ngwale tanre, ba gweale gwabeda, kwian nga ulitamu be jainchke badi cha gerua giti. ");
INSERT INTO sabNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Chui ege tangle kwian tanre cha gerua ganga be cha gerua chuge ngwadi be mo ta blite age me no joge siere cha geruage, kwian ene ulita be jainchke modi ongoru ongoru kaire be daba kete boadale daga ngwale tanre kwian chugagwallage. ");
INSERT INTO sabNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Kaire agwe chui ege tangle kwian daba tkanga tangle geru ngwale me uliage, kwian ene tanre be chie tangle gerule ama kle chage geru ulia Chubenu dbe kwian alin, agwa ama kle sole ngwale kwian ole kle geru ngwale trage, kwian tanre be mo anblitange kwian ege be ama gerua ngwale gai ulia. ");
INSERT INTO sabNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","E suiage tangle age me no tanre be kle nga dba ai giti kwian ulitaske, age me no tanre ene be kwian tanre cha gerua ganga ulia ta gbe bate chage, kwian ene mi mo ta dbe no cha ole ngeru kare kaire ama mi mo ta dbe no daba na ole. ");
INSERT INTO sabNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Agwa kwian bai me mo chuge ngwadi joge siere cha geruage boi daga ngwaleske, kwian ene mo ta gbe cha gerua gai ulia mo tale diali gwangerugu mo ta gbe age no diali Chube takalin kare, kwian bai mo ta gbe ene, chui bdagli be chke gire kwian e be toi no diali chui tangle cha ole Chube ngwadi. ");
INSERT INTO sabNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Chube gerua no ulia cha giti jogedale ketaba kwian nga ulitamuge, ene chke uñale kwian nga ulitamuge ama cha gai mo Chugagwallale ene ama chege no Chube gwa giti ama Chubenu, kwian nga ulitamu geru e keruchugadale ngeru, gire chui bdagli be chke —Jesu gerudu ene ulita kwian geru jwannga ole. ");
INSERT INTO sabNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Cha chada ai deganga gerule ba bai chada ai batenga ole, ba geru ai gbadale gdadi tañachuge no mo tale Jesu kle gerule giti gire ene geru be suge no trate bage. Jesu gerudu dare kwian geru jwannga amage ulita ole: —Kwian Chube gerua ketanga dabage unsuialin kada Daniel Chube gerua degu, chada e gerule chui be chke kwian be age gweale me no me no sugaska Chube gwa giti una no Chubenu Jerusalénge nga kweri Judeage. Ba gwage kwian age me no sugaska enedi una Jerusalénge Daniel chada degu kare, ");
INSERT INTO sabNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","gire ba bai kaire ulita kle nga Judeage kigedale ngaske jwichugage mo manadale nga be boi tirare ngeru. ");
INSERT INTO sabNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Chui ege kwian ulita kigedale blikare ni lle amanu tallade. Kwian bai kaire skate goga tangle ama me jogedaleni chiga u amanuge lle gweale amanu gwa tangle lite ole dbadale, ama lle ulita amanu chugadale ngwadi gwa ama jogedale kige blike kole. ");
INSERT INTO sabNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Kaire agwe kwian bai kaire skate lle boi deage me jogedaleni gudegu mo ñometralla lite ole, ama jogedale kige blike gwangerugu me joge naskuni. ");
INSERT INTO sabNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Chui ege muinga bai kaire kle chage gaba kaire muinga bai kaire kle chage kirogwa soli sidri jusulidi ole, muinga e ulitage cha tai dage noare, ama ulita be boi daga ngwale tirare, be mnoare ama alin kige blike. ");
INSERT INTO sabNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","21","Chui ege kwian be boi tanre daga ngwale tirare me nu boiba daga ngwale ngeru kare chui Chube nga ulita dodaduge gwangerugu joge nege tangle, boi daga ngwale ene chuia be joge tangle ulita gire mi boi dare ene kare nakwaite. Ulia chui ege be boi tanre daga ngwale malen e gdale ba ulita gerudale diali Chube ole boi daga ngwale e chuia me chke noi suiale ni kwian israelita undege chuiage, chui be chke undege chuiage o noi suiage ene kwian ñage boi ma jabale me ñage kige blike dale. ");
INSERT INTO sabNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","E suiale Chube kwian chuge ngwadi boi daga ngwale chui ngle kwian ulita be jogenga boi daga ngwale kote, agwa Chube tale Chube be mo ta dbe no kwian ole kwian bai Chube nu gaba mo alin ole, Chube mi kwian chuge ngwadi boi daga ngwale chui ngle, Chube be boi daga ngwale chuia gbe buli, ama me takalin kwian amanu boi daga ngwale chui ngle, ama no no kwian ole. ");
INSERT INTO sabNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Kaire e suiale kwian gweale be gerule ba ole: “¡Gwage ai, Cristo chku! Ama kle aini, Chube ama kagu.” Kaire kwian na be gerule: “Kwian chiu e, ama Cristo ulia.” Kwian gerule ene ba ole, sugedale bage ama me kle gerule ulia ama kle gerule mau tale ngwale, ba me ama gerua gai ulia. ");
INSERT INTO sabNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kaire chui ege kwian gweale be chage kwianske mo kalla itenga, be gerule: “Cha Cristo ulia, Chube cha kagu.” Kwian na be sole kwian ole kwian ulita anblite, be gerule: “Ulia cha Chube gerua ketanga dabage.” Kwian e ulita be gerule ene kaire ama be lle daga ngwale tanre dodade kwian gwa giti, age ene giti ama takalin kwian tañachuge ama kle age Chube kiralla giti, ama be age ene ulita kwian Chubenu anblitagda. Kwian daba anblitanga e ulita be takalin kwian Chube nu gaba mau alin gbe age me no Chube dollale me Chube gerua gai ulia dare, ama tañachuge ama ñage kwian Chubenu ta blite chage ama nate ama gerua ngwale gai ulia, agwa kwian daba anblitanga e ulita kle tañachuge ene ngwale. ");
INSERT INTO sabNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Cha geru ai ulita ketu bage ba ta gbale be boi giti chui bdaglige, ene chui ege kwian me ba anblite joge siere geru uliage. ");
INSERT INTO sabNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ba ulita me mo chuge ngwadi mo anblitange, kwian gweale be gerule ba ole: “Cristo kle nga gballage, joga nga ege tienda Cristodi.” Kwian gerule ene ba ole gire ba me joge. Kwian gweale na be gerule ba ole: “Bai aini tienda Cristodi, Cristo kle mo ogabada nga aige.” Kwian gerule ene ba ole gire ba me ama gerua gai ulia, ama kle sole. ");
INSERT INTO sabNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Cha gerule ulia ba ole, cha chieni chuiage me kwian bedre alin be gwage chadi chieni, agwa kwian ulita nga ulitage be gwage trate chadi cha be chieni chuiage salengwli kwian ulita kle gwage nga ko chrachiengadi nga ngaña giti kare. ");
INSERT INTO sabNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Cha gerule ba ole, juntenge uñale lle jogebakeda chegale kle baini, ne ngwadi junten ngle kle mo lite dba, ene kaire kwian cha gerua gaba uliage be chke uñale trate cha chieni chuia kle kodi gire. ");
INSERT INTO sabNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Jesu gerudu ene gire gerudu dare kwian geru jwannga ole ama chieni chuia giti: —E ulita cha gerudu kare ba ole be boi daga ngwale ene ulita, gire sugeti ngwale chui be gwajoge jere ngajudi, kaire dai mi chege gwadenga ngajrege, beu ulita be jain dbige nga ngaña giti, nga ngaña giti nga ulita be jwlien, beu mi chege ngwedi beu kle kare, lle ulita mi chege ngeru kare nga ngaña giti. ");
INSERT INTO sabNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Nga be boi ene ulita gire Chube be cha kageni, cha be chieni nga dba ai giti ngnagu bogakwaske Chube kirallaske, chui ege kwian ulita nga ulitamu be gwage chadi cha noare cha kweri, ulia cha kwian ulita Chugagwalla. Kwian ulita be gwage chadi chieni ene gire ama be kennga tanre kaire be ta olire tanre mau giti, be suge trate ama ulitage e cha amaña chiu nga dba ai giti kwian kare kle chieni nabitaite. ");
INSERT INTO sabNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Lle ngwanegda kada trompeta be gdade kweri kweri gire cha be lle boanga cha alin nga ngaña giti ngle kage cha ngeru nga ulitage nga dba ai giti, ama be kwian nga ulitamu bai kaire cha nu gaba mau alin lite ole ulita dbale nga ngaña giti toi cha ole Chube kle ngwadi. ");
INSERT INTO sabNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Nege cha geru ñachuge ba ulita alin gli kada higuera giti, ba cha keruchuge no gire ene be suge bage cha kle gerule mine ulia. Gli higuera kle ga jain ulita gire gliga na bli erutu kle chieni, ba gwage glidi ene aini che jwiage gire bage uñale chuda suia kle kodi. ");
INSERT INTO sabNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ene kaire ba be gwage lle tanredi boi ulita cha gerudu kare ba ole sbaliga gire chkedale uñale bage cha be chieni chuia kle kodi kodi, me sbali gire cha be chieni. ");
INSERT INTO sabNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Cha geru kete bage e ulia, cha gerudu kare be boi ene ulita ngeru kwian ulita kle toi chui aige bebi joge tangle. ");
INSERT INTO sabNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Nga ngaña giti nga dba ai giti mi chege diali dale alin, nga ulita ulita be joge tangle, agwa cha gerua mi joge tangle dale, cha gerua be chege diali dale alin, be boi ulita cha gerua kle gerule kare. ");
INSERT INTO sabNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Cha geru kete bage ni kwian gdaitege uñale chui baige chui mangire cha be chieni, kaire agwe lle boanga cha Ñenua Chube alin nga ngaña giti ulita ni gdaitege uñale cha be chieni ngaminegire, ni cha Chube Kirolla agalige uñale chui baige Chube be cha kageni, cha Ñenua Chubege alin allabi uñale. ");
INSERT INTO sabNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Cha be chieni chuiage, e suiale kwian tanre be kle toi age salengwli kwian unsuialin kledu toi age Noé suiale kare. ");
INSERT INTO sabNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kwian ulita toidu Noé suiale me kledu Noé kerua gbe gdadi me kledu tañachuge chui be boi tirare giti. Kwian e kledu blire, kwian kledu mo jwen, kaire kwian kledu mo jian gbe ule, kwian ulita kledu tañachuge toi age diali ene kare alin allabi, kaire kwian ulita kledu toi nga suga no ole age me no diali me kledu tañachuge chui be boi tirare giti. Agwa chui boi tirare chuia chku gire Noé jo chiga du kweri toli ule mo bitalla ulita batre ole Chube gerudu Noé ole kare. ");
INSERT INTO sabNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Agwa kwian na ulita me kledu mo tallade nga be boi giti, toidu ama kledu toi diali kare gire sugeti ngwale noi kweri boidu, kwian me ñadu tien gitiru chi udage, kwian ulita unjo chiske jokeda chi kote. Ene kaire kwian tanre be kle toi cha chieni suiage kwian ene mi kle tañachuge be boi giti be kle toi age diali kare, gire sugeti ngwale cha be chieni, kwian ene ulita be chege boi daga ngwale tanre diali, mi ñage tien gitiru ege. ");
INSERT INTO sabNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Chui e suiage kwian onbre boke be skate deage lle boi, onbre gdaite dbabe Chube kle ngwadi onbre gdaite jigabeda ji chuge. ");
INSERT INTO sabNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Muinga boke be skate ke uge ule gwa, muinga gdaite dbabe Chube kle ngwadi muinga gdaite jigabeda ji chuge. ");
INSERT INTO sabNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Me uñale bage ngaminegire cha ba Chugagwalla be chieni malen ba kledale ta giti diali chui ulitage, ba ta kledale biale cha chieni chuia ngwange, me skate alenske ta me gbaba biale cha be chieni chuiage. ");
INSERT INTO sabNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ba geru ai gbe gdadige ba tañachuge geru ai giti: Kwian u mauñage chke uñale trate ngajrege kwian skwe boanga be chie lle jwennga ama ngeru, ene kwian u mauña be chege gwade ta giti ngajrege ulita kwian skwe boanga jege ngwange, ama mi kwian skwe boanga chuge ngwadi lle jwennga ngajrege ama ngeru. ");
INSERT INTO sabNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ene kaire ba ulita kledale biale cha chieni chuia manade ngwange. Cha chiu nga dba ai giti kwian kare, cha be chieni nakwaite, agwa me uñale bage chui baige cha be chieni, malen ba kledale biale diali. Ba me mo ta gbe tañachuge diali cha be chieni giti, gire cha be chieni chuiage ba be skate alenske chage, cha me takalin ba skate alenske chage. ");
INSERT INTO sabNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Jesu gerudu ene ulita ama be chieni chuia giti gire Jesu geru ñachugu kwian lle boanga u mauña alin giti: —Cha gerule ba ulita ole, ba kledale biale cha manade ngwange lle boi no diali cha takalin kare. E salengwli kwian gdaite lle boanga no u mauña alin kare. Kwian lle boanga e ta molen lle boi, u mauña be joge toi nga nage chui gwealege gire u mauña be kwian lle boanga no e jige lle boanga na ulita chugagwallale, lle boanga no ene be lle boanga na ulita manade no be bligda kete ama ulitage gutadale, be age ulita u mauña gerudu kare. ");
INSERT INTO sabNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","U mauña be chkeni, be gwage kwian lle boanga ama alin gdaitedige ama jigu lle boanga na ulita chugagwallale ama kle lle boi no u mauña gerudu kare, nga be suga noare kwian lle boanga edi ama skwendu u mauñage lle boi no u mauña gerudu kare. ");
INSERT INTO sabNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ulia cha gerule ba ole, kwian ene lle boi no ulita u mauña gerule kare gire ene u mauña be lle boanga e gbe lle amanu ulita manade. ");
INSERT INTO sabNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Agwa kwian lle boanga u mauña alin me no, u mauña kwian ene jige lle boanga na ulita chugagwallale gire joge nga gwealege, lle boanga me no e be tañachuge mo tale: “Cha chugagwalla u mauña mi chieni blike, cha me lle boadale blike dale.” ");
INSERT INTO sabNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ama tañachuge ene, gire ama be age dagale lle boanga na ulita ole be lle boanga na ulita gbe boi tanre daga ngwale, ama be skate ule kwian lle gage janga ole, ama be sui chuge blire lle gage jai ule kwian ene ole. ");
INSERT INTO sabNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Agwa gire chui gbaite kwian lle boanga me no e me kle mo chugagwalla u mauña manade ngwange me kle tañachuge chui baige chui mangirege chugagwalla be chieni, ama ni kle tañachuge ama chugagwalla be chieni giti, gire chui ege chugagwalla be chkeni. ");
INSERT INTO sabNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","U mauña kwian jigu lle boanga ama alin ulita chugagwallale, kwian e be skate u mauñage age me no, malen u mauña be ji gbe kweri kwian ene giti, ama me agedu u mauña gerudu kare, u mauña be ama mlienga, ama be joge boi daga ngwale ule kwian na agenga me no ulita ole, ne ngwadi ama be olire tanre be boi daga ngwale tirare —Jesu geru ñachugu ene kwian lle boanga u mauña alin giti, ene ñage suge trate kwian ulitage kwian mo ta gbadale age no Chube takalin kare diali Jesu chieni chuia manade ngwange ta giti. ");
INSERT INTO sabNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jesu geru na ñachugu kwian geru jwannga amage alin, Jesu gerudu: —Cha gerule ba ulita ole, chui bdaglige Chube be cha kageni gerule nga ulita giti kwian Chugagwallale, chui ege kwian gweale be kle mo ta gbaba biale no cha chieni chuia manade ngwange, agwa kwian na mi kle biale dale cha ngwange, ama me nu Chube gerua cha giti gaba ulia. Chui ege be boi salengwli kwian ulita ole boidu muinga judige gdataboko ole kare, muinga e ulita jo jichra dbe mo skatemanalla onbrella manade ngwange jonkare gadale ngwange onbre e mo jwen chuiage. ");
INSERT INTO sabNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Muinga judige gdataboko ulita jo jichra dbe kwian onbre gai ngwange jonkare onbre mo jwen chuiage, muinga judi e gdatiga me kin jichra gwadegagda du ngle, ama jichra alin du kin ole llagli, ama me kin na du jichra gwadegagda nakwaite, ama me chagedu ta giti, ama me tañachugu kwian onbre ñage chke sbali, ama kaire manadale sbali. Agwa muinga na gdatiga ama tachku jichra gwadegagda ñage bidege, malen ama kin du ngle tkale jichrage, ama chagedu biale ta giti. ");
INSERT INTO sabNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Muinga gdataboko kle mo skatemanalla onbrella manade ngwange ene jichra ole jonkare, agwa onbre e me chku blikare, muinga ulita skwatigu manade gire ama ulita gbigachiu, ama gbedu. ");
INSERT INTO sabNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Agwa nga jere bduke chku gire muinga gdataboko ulitage geru sugedu, ngautre: “¡Ba skatemanalla kwian onbrella chiu! ¡Joga kwian onbre e gai ngwange jonkare!” ");
INSERT INTO sabNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ngautre ene amage gire muinga judi ulita chku bduge, ama jichra dodadu ene ama ñage joge ten kwian onbre ngwange. ");
INSERT INTO sabNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Agwa muinga judi gdatiga ta me ama gerudu muinga gdatiga ta molen ole: “Ba kin kete chage sidri cha jichralla alin, cha jichralla me gwadenga no, jichra ta jogekalinda.” ");
INSERT INTO sabNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Agwa muinga gdatiga ta molen gerudu: “Cha me ñage kin kete bage, cha kete bage kin me ñage chege cha alin ngle. Ma no ba joge kin chbadakle ngwadi ba ñage kin gige llani.” ");
INSERT INTO sabNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Gire muinga judi gdatiga ta me ama jo kin gige kin chbadakle ngwadi, ama me kle gire ama skatemanalla onbrella chku. Muinga judi gdatiga ta molen, ama alin allabi onbre e gau ngwange no, muinga gdatiga e jo chiga ule onbre ole mo jwen chuia ollade, gire ugaka jegle ama ulita nate. ");
INSERT INTO sabNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Boidu ene gire muinga na gdatiga chku ugakadi gerule: “¡Ugaka dégenga, cha jogekalin chiga!” ");
INSERT INTO sabNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Gire kwian onbre be mo jwen ama kledu chiga jaindunga muinga judi gdatiga e kalen: “Cha gerule ulia ulia ba ole, cha me ba uñe, malen ba me ñage chie chiga chui ollade ule cha ulita ole.” Kwian onbre be mo jwen gerudu ene muinga judi gdatiga ta me ole, gire muinga e ulita chegu goga sugekare. ");
INSERT INTO sabNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jesu geru ñachugu ene gire gerudu: —Ene kaire ba ulita kledale ta giti cha chieni chuia manade ngwange muinga judi gdatiga ta molen kare. Ba ulitage me uñale cha be chieni chui mangirege malen ba kledale biale cha manade ngwange diali —Jesu gerudu ene ulita kwian geru jwannga amage ole. ");
INSERT INTO sabNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Jesu geru ñachugu dare kwian geru jwannga ulita alin, Jesu gerudu: —Cha gerule ba ole, chui bdaglige Chube be cha kageni gerule nga ulita giti kwian Chugagwallale, chui e ngwange ba kledale biale, kwian ulita bai agedu cha takalin kare nga dba ai giti, kwian e alin cha be age no chui ege ama agedu no ñanale. Cha be chieni salengwli kwian chugagwalla jo nga batege chiuni kare. Kwian chugagwalla e bebi joge gire ama kwian lle boanga mau alin gdamai kadu mo gitigu gire igi ketu ama ulitage, ene kwian lle boanga e ulita ñage igi e gbe jrien ma ngle mo chugagwalla alin. ");
INSERT INTO sabNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Kwian lle boanga gdaitege chugagwalla igi ketu ngle ngle cinco mil, lle boanga na gdaitege chugagwalla igi ketu ma bedrekanga ngeruge dos mil, lle boanga na gdaitege chugagwalla igi ketu un mil alin allabi ma sidri. Chugagwalla me igi ketu salengwli lle boanga gdamai ulitage, chugagwallage uñadu kwian lle boanga ama alin ta mine. Chugagwalla jo nga na batege. ");
INSERT INTO sabNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Kwian lle boanga gdaite igi gau cinco mil mo chugagwallage, kwian lle boanga e lle gweale gigu igi e giti gire lle chbadu, kledu age ene gire igi jriendunga ama ole bitaboke tangle ma ngle, bdagli igi chku ulita ama ole ngle ngle diez mil. ");
INSERT INTO sabNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Kaire agwe kwian lle boanga na gdaite igi gau dos mil mo chugagwalla alin, ama agedu kaire agwe, igi jriendunga ama ole bitaboke tangle ma ngle, ene ama igi litu ole ngle cuatro mil. ");
INSERT INTO sabNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Agwa kwian lle boanga gdaite igi ma sidri igi un mil gau mo chugagwallage, kwian lle boanga e dbi bagu gire ne ngwadi ama igi e ulita ogo chugagwalla alin, ama ole igi me ñadu jriennga, igi chegu salengwli igi ketre batre amage kare. ");
INSERT INTO sabNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Chui jo sbali gire kwian lle boanga chugagwalla chkuni ama kwian maidige, chugagwalla kwian lle boanga e kadu mo gitigu geru trage ama ole igi giti ama igi gbu jriennga mangire. ");
INSERT INTO sabNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Kwian lle boanga igi ketrege ngle cinco mil, ama jo tienda ngeru chugagwalladige, ama gerudu: “Ba igi ketu cinco mil chage, cha igi na gau e batre cinco mil, igi ngle ngle ulita diez mil kle ai ba alin cha chugagwalla.” ");
INSERT INTO sabNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Kwian lle boanga gerudu ene gire chugagwalla gerudu ama ole: “Ba kwian lle boanga no ulia, ba mo ta gbu lle boi no cha alin, ba agedu no no. Cha igi ketu bage, igi e ole ba lle bo no cha alin, ba igi na gau ngle cha alin. Ba lle bo no cha alin igi e ole, malen nege cha be lle ma kweri kete bage boadale cha alin. Nga suga no chadi ba lle bo no cha alin giti, bai cha ole chui ollade nga suga no ole.” Chugagwalla gerudu ene kwian lle boanga ngeru ole. ");
INSERT INTO sabNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Kaire agwe kwian lle boanga gdaitege igi dos mil ketaba, ama jo tienda chugagwalladi, gerudu chugagwalla ole: “Ba igi ketu chage dos mil, cha igi na gau e batre dos mil, igi ulita cuatro mil kle ai ba alin cha chugagwalla.” ");
INSERT INTO sabNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Kwian lle boanga gerudu ene gire chugagwalla gerudu ama ole: “Kaire agwe ba kwian lle boanga no ulia, ba mo ta gbu lle boi no cha alin, ba agedu no no. Cha igi ketu bage, igi e ole ba lle bo no cha alin, ba igi na gau ngle cha alin. Ba lle bo no cha alin igi e giti, malen nege cha be lle na ma kweri kete bage boadale cha alin. Nga suga no chadi ba lle bo no cha alin giti, bai cha ole chui ollade nga suga no ole.” Chugagwalla gerudu ene kwian lle boanga e ole. ");
INSERT INTO sabNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","’Kwian lle boanga gdaitege igi un mil ketaba, ama jo tienda chugagwalladi gire gerudu: “Cha chugagwalla, chage uñale ba kibale ba kle kwian gbe lle boi mno ba alin bigire ba kle lle ulita jwen ama ngeru mau alin. ");
INSERT INTO sabNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ba kwian ene malen cha ta kendunga badi, cha tañachugu cha lle boi igi e giti igi e jogenga gire ba skochie chadige igi gdale, malen cha igi e ulita ogo dbiske, cha me igi na litu ole ba alin, nege cha igi amaña keteni bage.” ");
INSERT INTO sabNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","27","Gire chugagwalla jaindunga lle boanga e kalen: “Ba kwian lle boanga me no kaire ba kwian kianle tanre. Ba tañachugu chadi cha kle kwian gbe lle boi mno gire cha kle lle ulita jwen ama ngeru mau alin, e uñale bage ene ¿mineade ba me jo igi oge kwian kle igi oge ngwadi? Ene llani kwian na ñadu lle boi igi e giti, cha chieni gire ama igi na kete chage ma ngle cha igia kledu llani ñanale.” Chugagwalla gerudu ene kwian lle boanga me no ole. ");
INSERT INTO sabNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Kwian na kledu ule ne ngwadi chugagwalla ole, kwian e ulita ama ole chugagwalla gerudu kwian lle boanga me no giti: “Cha igi ketu un mil amage ba igi e jwennga ama ngeru kete kwian lle boangage bai igi molen ma ngle diez mil. ");
INSERT INTO sabNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","30","Kwian ai lle boanga me no kianle tanre ba ama mlie siere cháge goga nga jereske, ne ngwadi ama be olire tanre ama be boi daga ngwale tanre ama agedu me no giti. Cha gerule ba ole, kwian bai lle boi no cha alin cha takalin kare, cha be lle na kete amage boadale cha alin, cha be age no no ama alin lle boi no cha alin ñanale. Agwa kwian bai me lle boi no cha alin cha takalin kare, kwian ene mi ñage lle boi cha alin dare.” Chugagwalla gerudu ene lle boanga ama alin giti. Jesu geru ñachugu ene kwian geru jwannga alin, ene ñage suge trate ama ulitage ama mo ta gbadale ulia lle boi no Chube alin Jesu chieni chuia manade ngwange. ");
INSERT INTO sabNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jesu gerudu dare kwian geru jwannga amage ulita ole: —Chube nu cha kagaba nga dba ai giti kwian kare, ama be cha kageni nabitaite kira kweri molen kwian ulita Chugagwallale. Cha chieni chuiage lle boanga Chube alin nga ngaña giti ngle be chie ule cha ole mo litaba chadi tangle, chui ege cha be gerule kwian ulita giti nga ulitage kwian bai Chube gerua gau ulia kwian bai me Chube gerua gau ulia. ");
INSERT INTO sabNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","33","Kwian ulita nga ulitamu dbabe cha gwa giti gire cha be kwian ta no gbe sugekare cha be kwian ta me no jige sugekare salengwli kwian bda mananga kle bda oveja gbe sugekare chivoge kare. Cha be kwian ta no Chube gerua gaba ulia gbe ko taingwli ngnagu, kwian ta me no me Chube gerua gaba ulia cha be ama gbe ko jole ngnagu. ");
INSERT INTO sabNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Cha kwian ulita Chugagwalla be gerule kwian cha ko taingwli ngnagu ole: “Bai cha ole ba mangire batre Chube gerua gau ulia, cha Ñenua Chube no no ba ole ama age no ba alin diali. Nege nga no lle no kle dodaba ba alin nga ngaña giti Chube kle ngwadi, Chube nga ulita lle ulita dodadu unsuialin gwangerutabi gire ama nga dodadubi ama kle ngwadi ba mangire batre ngwange. ");
INSERT INTO sabNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ulia ba ulita agedu tanre no cha alin ai kare: Cha bli ole, ba bligda ketu chage. Cha siechiu, ba chi ketu chage jadale. Cha chagedu basale ba kledu toi ngwadi, ba me cha uñu agwa ba cha gau ngwange no, ba nga ketu chage gbengwa. ");
INSERT INTO sabNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Cha me ñometra ole, ba ñometra ketu chage. Cha ogadu, ba diali cha manadu. Cha tkere skage, diali ba jo tienda chadi. Ba diali cha chudabo ene, malen nege ba ñage chege toi cha ole.” Chui bdaglige cha be gerule ene kwian ulita ole bai mo ta gbu age no. ");
INSERT INTO sabNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Cha be gerule ene gire kwian ene ulita be geru kade chage: “Cha Chugagwalla, ¿ngaminegire cha gwagedu badi bli ole, gire cha lle ketu bage gutadale? ¿Ngaminegire cha gwagedu badi sie ole, gire cha chi ketu bage jadale? ");
INSERT INTO sabNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Ngaminegire ba chagedu basale cha kledu toi ngwadi, gire cha nga ketu bage gbengwa? ¿Ngaminegire ba me ñometra ole, gire cha ñometra ketu bage? ");
INSERT INTO sabNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Ngaminegire cha gwagedu badi oga, gire cha ba manadu? ¿Ngaminegire ba tkere skage, gire cha jo tienda badi?” ");
INSERT INTO sabNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Kwian be geru kade ene chage, gire cha be jainnga: “Cha gerule ulia ba ulita ole, kwian tanre cha gerua gaba ulia me lle molen, ba kwian ene manadu no, ba lle ketu amage, ba ama chudabo, e salengwli ba cha agali chudabo kare.” ");
INSERT INTO sabNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Cha kwian Chugagwalla be gerule no ene kwian ulita ole bai mo ta gbu age no kle cha ko taingwli ngnagu ole, gire cha be gerule kwian ulita ole bai mo ta gbu age me no kle cha ko jole ngnagu ole: “Joga siere chage, ba jiske kweri Chube gwa giti, ji kle ngle ba giti ba agedu me no gdale, joga nga dbigu giti, ne ngwadi jita me kle jogekeda dale, nga e kle dodaba biale ji chugangwa dolla chugagwalla Satanás alin kaire Satanás chudaboangalla ulita alin. ¡Joga nga ege kaire! ");
INSERT INTO sabNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ba agedu me no cha alin ai kare: Ba gwagedu chadi bli ole, ba me bligda ketu chage gutadale. Ba gwagedu chadi sie ole, ba me chi ketu chage jadale. ");
INSERT INTO sabNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Cha jo chage basale ba kledu toi ngwadi, ba me cha gau ngwange no, ba me cha chudabo ba me nga ketu chage gbengwa. Ñometra me chegu cha ole, ba me ñometra ketu chage. Cha ogadu, ba me cha manadu. Cha kledu skage, ba me jo tienda chadi. Ba me cha chudabo, malen ba be boi daga ngwale ji chuge tanre.” ");
INSERT INTO sabNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Chui bdaglige cha be gerule ene kwian ulita ole bai mo ta gbu age me no cha ole, gire ama be geru kade chage: “Cha Chugagwalla, ¿ngaminegire cha gwagedu badi bli ole, gire cha me bligda ketu bage gutadale? ¿Ngaminegire cha gwagedu badi sie ole, gire cha me chi ketu bage jadale? ¿Ngaminegire ba chagedu basale cha kledu toi ngwadi, gire cha me nga ketu bage gbengwa? ¿Ngaminegire ñometra me chegu ba ole, gire cha me ñometra ketu bage? ¿Ngaminegire ba ogadu, gire cha me ba manadu? ¿Ngaminegire ba tkere skage, gire cha me jo tienda badi?” ");
INSERT INTO sabNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Kwian be geru kade ene chage gire cha be jainnga ama kalen: “Ulia ulia cha gerule ba ulita ole, ba me kwian cha gerua gaba chudabo lle me ama ole gire, ba me lle ketu amage e salengwli ba me cha agali chudabo kare. Ba me kwian ene chudabo, ene kaire ba me cha chudabo.” Cha be jainnga ene kwian mo ta gbu age me no kalen. ");
INSERT INTO sabNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Cha be kwian mo ta gbanga age me no kage boi daga ngwale tanre nga dbigu giti chui diali chui tangle. Agwa kwian mo ta gbanga ulia cha ole age no cha takalin kare, kwian ene be joge toi nga ngaña giti cha ole kaire cha Ñenua Chube ole diali chui tangle —Jesu gerudu ene ulita kwian geru jwannga amage ole. ");
INSERT INTO sabNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jesu kwian geru jwannga amage ulita ta gbu ene Jesu chieni chuia giti gire Jesu gerudu dare ama ulita ole: ");
INSERT INTO sabNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Bage uñale chui chegu gbabokle alin allabi gire Pascua chuia chke chui olladangwa, chui ege cha gabe cha ketabe gwaleda kruge —Jesu gerudu ene kwian geru jwannga amage ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Kwian gerunga Chube ole daba alin chugagwalla ulita kaire kwian israelita chugagwalla juma ulita, kwian e ulita mo litu kwian kada Caifás ullage, Caifás kwian gerunga Chube ole chugagwalla ma kweri. ");
INSERT INTO sabNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ne ngwadi kwian e ulita mo litu mo ten sugekare Jesudige mo kaire, ama ulita mo ta gbu age gweale skwlenre Jesu gai dbale skage Jesu gwangeda. ");
INSERT INTO sabNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Kwian e ulita gerudu modi: —Che me ñage age gweale Jesu dollale Pascua chuiage, kwian tanre be kle chui ege chui ollade una aige, che age me no Jesu ole kwian ngleaske gire kwian ulita be kira bate modi Jesu gdale, ma no che chui na manade kwian ngle me kle mo litaba una aige gire —kwian israelita chugagwalla ulita gerudu ene modi. ");
INSERT INTO sabNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","7","Jesu jo chke una Betaniage ule kwian geru jwannga amage ulita ole, ama ulita jo Simón ullage blire Simón ole ule. Ngeru Simón e amaña chagedu oga kwara tuge jingmea kada lepra ole agwa ama jogeba chkeni noni, Simón e ngwadi Jesu jo blire kwian geru jwannga amage ole, ama ulita kledu blire gire muinga gdaite chku Jesudige lle ñachke no kada nardo chia dbe lle gweale limeta soli karege tkale Jesu chuga giti, nardo e kwangleare. Muinga nardo chia e ulita oto Jesu chuga giti. ");
INSERT INTO sabNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Kwian geru jwannga Jesuge ulita gwagedu muingadi nardo chia ote Jesu chuga giti, gire ama ulita ta skochiu muingadi nardo chia gdale, ama ulita gerudu modi muingadi: —¿Mineade muinga nardo chia kwangleare kagunga ngwale? ");
INSERT INTO sabNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Muinga ñadu nardo chia chbade kwangleare, ene ama ñadu kwian me lle molen chudaboi nardo chia ñanalla giti. ");
INSERT INTO sabNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesuge chku uñale kwian geru jwannga amage ulita gerudu ene modi muingadi gire Jesu gerudu kwian geru jwannga ulita ole: —Muinga ai agedu no no cha alin, ¿mineade ba kle mo ta dbe gerule me no amadi ama nardo chia oto cha chuga giti gdale? ");
INSERT INTO sabNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Cha gerule ba ole, kwian me lle molen be kle toi diali ba ulitaske, chui ngle kle ba alin kwian me lle molen chudaboale, agwa cha mi chege toi diali aini baske. ");
INSERT INTO sabNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Me sbali cha be jogekeda, muinga ai nardo chia oto cha chuga giti cha jegwale gbe biale cha jaba ogabe chuia ngwange. ");
INSERT INTO sabNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Cha gerule ulia ba ole, chui aige gwangerugu nga ulitage baini kaire geru no cha giti be joge tragaba kwian ole ngwadi, nga e ulitage geru muinga ai agedu no cha alin giti be joge tragaba kaire, ene kwian nga e ulitage be tachke diali muinga ai agedu giti cha alin. ");
INSERT INTO sabNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Jesu gerudu ene kwian geru jwannga Jesuge gdataboko giti gdaboke ole gire ama gdaitea kada Judas-Iscariote jo tienda kwian gerunga Chube ole chugagwalla ulitadi, ");
INSERT INTO sabNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Judas-Iscariote gerudu kwian e ulita ole: —¿Ba takalin igi kete mangire chage Jesu ñanale, ene cha Jesu kete bage gadale gwangeda? Kwian gerunga Chube ole chugagwalla ulita ta Jesu gakalin ama kle biale, ama ulita gerudu Judas-Iscariote kalen: —Cha igi treinta kete bage Jesu kete ñanale. ");
INSERT INTO sabNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Chui ege gwangerugu Judas-Iscariote kledu kote Jesu ole Jesu gdea tke baini Jesu be kle gballa gire ama Jesu kete gwaleda. ");
INSERT INTO sabNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pan me dodadre levadura ole gute suia chku, chui gwangeage kwian israelita ulita diali Pascua chuia ollade, chui e chku gire kwian geru jwannga Jesuge ulita chku Jesudi geru kadu Jesuge: —¿Baini ba takalin cha bli jinade che ulita alin gutadale Pascua chuia olladale ule? ¿Che be blire baini? ");
INSERT INTO sabNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesu jaindunga: —Joga una Jerusalénge ba ten kwian gdaite ngwange, amage ba gerule: “Cha tkanga tangle geruge cha kagu gerule ba ole, ama gerudu: ‘Cha chuia kle kodi jogeda, nege cha ta jogekalin ba ullage Pascua chuia ollade bdagli ule kwian geru jwannga chage ulita ole.’ ” Ba geru kete ene kwian ege. ");
INSERT INTO sabNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jesu gerudu ene kwian geru jwannga amage ole gire kwian geru jwannga agedu ulita Jesu gerudu kare, kwian geru jwanngage u skwendu, ama bligda jinadu u ege Pascua chuia olladale. ");
INSERT INTO sabNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Jesu jo u bligda jinadre ngwadige, nga jo jere ngabi gire Jesu toiba dba blire ule kwian geru jwannga amage gdataboko giti gdaboke ole. ");
INSERT INTO sabNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ama ulita kledu blire gire Jesu gerudu: —Cha gerule ulia ba ulita ole, ba ulita kle aini blire ule cha ole gdaite be cha kete kwian cha dollalege gwaleda. ");
INSERT INTO sabNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Kwian geru jwannga Jesuge ulita Jesu keruchugu gerule ene gire kwian geru jwannga ulita ta chegu olire tanre mo tale, kaire ama ulita gdaite gdaite geru kadu Jesuge: —¿Chema be age ene ba dollale? ¿Cha? ");
INSERT INTO sabNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesu jaindunga: —Ba kwian geru jwannga chage ulita kle blire ule cha ole aini kle pan bita gbe date bligda chiaske batekwa amaña giti cha ole, ba gdaite e be cha kete gwaleda. ");
INSERT INTO sabNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Cha chiu nga dba ai giti kwian kare, ulia cha ketabe boadale daga ngwale gwaleda Chube gerua degaba unsuialin kle gerule kare. Agwa kwian onbre bai be cha kete boadalenga daga ngwale gwaleda ama be boi dageare daga ngwale tanre ama agedu cha ole kbiale, ma no ama alin ama me medunga chebia kote dale. ");
INSERT INTO sabNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Jesu gerudu ene kwian geru jwannga ulita ole gire geru jwannga gdaite kada Judas-Iscariote ama be Jesu kete gwaleda, amaña e geru kadu Jesuge: —Cha tkanga tangle geruge, ¿chema be age ene ba dollale? ¿Cha? Jesu gerudu: —Ima, ba amaña be age cha dollale —Jesu gerudu ene Judas-Iscariote ole. ");
INSERT INTO sabNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Kwian geru jwannga Jesuge kledu blire ule Jesu ole, gire Jesu pan gau kote gerudu Chube ole pan giti: “Cha Ñenua, noare ba pan ai ketu cha ulitage gutadale.” Jesu gerudu ene Chube ole pan giti gire Jesu pan skutunga ketu kwian geru jwannga kaire kairege gutale, Jesu gerudu: —Ba pan ai gute, pan ai cha uda kare. ");
INSERT INTO sabNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","28","Gire Jesu chi jangwa gau kote uva chia ole, Jesu gerudu Chube ole uva chia giti: “Cha Ñenua, noare ba uva chia ai ketu cha ulitage jadale.” Jesu gerudu ene Chube ole uva chia giti gire ama uva chia ketu kwian geru jwannga kaire kairege jadale, Jesu gerudu: —Ba ulita uva chia ai jai, uva chia ai cha be kare, cha jogeda giti be suge trate ba ulitage Chube kle geru jagere gbe kwian ulita alin cha giti, nege gwangerugu cha jogeda giti kwian ulita bai kaire cha gai ulia be chege no trate Chube gwa giti, kwian e agedu me no Chube be talla mlienga ulita. ");
INSERT INTO sabNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Cha geru kete bage, nege alin cha kle uva chia jai ba ole ule, agwa nege gwangerugu cha mi kle ba ole dare ba gatedi uva chia jai ule nga dba ai giti. Chui bdagli be chke gire cha Ñenua Chube be cha gbe gerule kwian ulita giti kwian Chugagwallale, gire chui ege cha be uva chia jai nakwaite ule ba ole —Jesu gerudu ene geru jwannga amage ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Blidubi gire ama ulita mo gatu no Chube giti, gire ama ulita jo siere nga ege, ama ulita jo chage Ngwiskinro Jwichugalla ngnagu. ");
INSERT INTO sabNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jesu gerudu kwian geru jwannga amage ulita ole: —Cha gerule ulia ba ulita ole nege, nege ngajrege ba ulita be cha chuge ngwadi boidale daga ngwale gballa Chube gerua degaba unsuialin tangle kle gerule kare, Zacarías Chube gerua degu cha giti kaire ba ulita giti, chada e gerule: “Chube gerudu: ‘Cha be kwian oveja mananga chuge ngwadi kagadale kodi gire oveja ulita be kige.’ ” Zacarías Chube gerua degu ene unsuialin. ");
INSERT INTO sabNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Cha be jogeda, cha jaba be chkeni gwadeni Chube kiralla giti gire cha be joge nga Galileage ma ngeru ba ulitage, ba be joge cha nate gire nga ege che be mo lite ule. ");
INSERT INTO sabNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Jesu gerudu ene kwian geru jwannga ulita ole gire Pedro gerudu Jesu ole: —Kwian geru jwannga na ulita be ba chuge ngwadi agwa cha me dale, cha mi ba chuge ngwadi jogeda gballa. ");
INSERT INTO sabNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesu gerudu Pedro ole: —Cha gerule ulia ba ole, nege ngajrege ngakamalin bdugu antalan bebi ngwane gire ba agali be gerule bitamai kwian na ole ba me cha uñe. ");
INSERT INTO sabNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedro ka bo mno Jesu ole: —Cha me dale, cha me mo tallade cha jogekeda ba ole ule, cha mi gerule kwian ole cha me ba uñe, cha be chege ba ole diali. Pedro gerudu ene, kaire agwe kwian geru jwannga Jesuge na ulita kledu eni gerudu salengwli Pedro gerudu kare. ");
INSERT INTO sabNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jesu kledu Ngwiskinro Jwichugallage ule kwian geru jwannga ulita ole gire ama ulita jo nga kada Getsemaníge, ne ngwadi Jesu gerudu kwian geru jwannga ulita ole: —Ba ulita toi dba aini sugeti cha manade, cha be joge sugekare gerule Chube ole gballa. ");
INSERT INTO sabNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jesu gerudu ene gire Jesu jo Pedro dbe kaire Zebedeo kirolla gdaboke dbe mo ole llagli. Jesudi nga chiu olire tanre ama be boi daga ngwale giti, ");
INSERT INTO sabNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ta ene ole Jesu gerudu kwian geru jwannga gdamai e ole: —Cha ta olire tanre mo giti cha be boi daga ngwale giti, suge chage cha me jage tañachuge e giti. Cha joge sugekare gerule Chube ole, cha takalin ba gdamai chege aini ngmadi cha manade, ba chegedale ta giti gwade ba me mo chuge ngwadi gbe, ba jagedale gbiga kote gwade. ");
INSERT INTO sabNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jesu gerudu ene kwian geru jwannga gdamai ole gire Jesu jo chage ma ngerugu sidri sugekare gballa, ama mo ñeu kaboge jongnagwa giti ama gwa ñadu dbidi gire ama gerudu Chube ole: “Cha Ñenua, cha me ta boikalin daga ngwale, cha me takalin ba kwian me no chuge ngwadi cha gweda, ba takalin ba ñage cha jwen siere cha be boi tirarege, agwa ba age cha alin mo tale ba takalin kare, me cha takalinge kare.” ");
INSERT INTO sabNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Jesu gerudu ene Chube ole gire joni naskuni kwian geru jwannga amage gdamai kledu manade ngwadige, kwian geru jwannga e ulita skwendu Jesuge gbe, gire Jesu gerudu Pedro ole: —¡Chkede bduge! ¿Ba gdamai me ñadu chege gwade sugeti alin cha manade? ");
INSERT INTO sabNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ba ulita mo ta gbadale chege gwade, ba gerudale Chube ole mo chudaboi kade amage, ene ba me ta jwlite joge siere cháge age me no. Uñale chage ulia ba ta agekalin ulita cha kle gerule kare agwa ba me kira molen age cha takalin kare, malen ba gerudale Chube ole kira kade amage mo alin. ");
INSERT INTO sabNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jesu gerudu ene gire Jesu jo sugekare nakwaite gerule Chube ole: “Cha Ñenua, ba me takalin cha jwen siere cha be boi daga ngwalege, ba ñage age ulita ba takalin kare cha ole.” ");
INSERT INTO sabNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Jesu gerudu ene Chube ole gire ama joni naskuni kwian geru jwannga gdamaidini gire nakwaite kwian geru jwannga e ulita skwendu Jesuge gbe, ama me ñadu chege gwade chuge, ama gbigachiu tanre ama gwagwa kledu jegaba gbiga kote. ");
INSERT INTO sabNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Jesu jo sugekare gerule nakwaite bitamaige tangle Chube ole, Jesu geru amaña ama gerudu Chube ole giti ngeru jun kate bitamaige tangle. ");
INSERT INTO sabNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","46","Jesu gerudubi ene ulita Chube ole gire ama jo naskuni kwian geru jwannga gdamai kledu gbe ngwadi, Jesu gerudu ama ulita ole: —¿Ba kle chage gbe kaire? ¡Chkede bduge! Nege cha boabe daga ngwale gwaleda chuia chku. Chube cha kagu nga dba ai giti kwian kare, nege sugeti cha ketabe kwian cha dollalege boadale daga ngwale gwaleda kwian agenga me no kote. Nege nege kwian cha ketanga kwian cha dollalege chiu kodi, ale ten ama ngwange jonkare. ");
INSERT INTO sabNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesu kle gerule ene kwian geru jwannga amage ole gire kwian geru jwannga Jesuge na gdaite kada Judas-Iscariote chku ule guardia donga nglea ole Jesu kle ngwadi, guardia donga e gweale chku sbadi ole na chku glita ole. Kwian gerunga Chube ole daba alin chugagwalla ulita kaire kwian israelita chugagwalla juma ulita, kwian e ulita nu guardia donga ngle kagaba Jesu gai dbale skadi. ");
INSERT INTO sabNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Guardia donga ulita bebi joge Jesu nate ule Judas-Iscariote ole gire Judas-Iscariote nu geruba: “Kwian gdaite bai cha be sobade, ama chkedale uñale bage e Jesu, ba kwian e amaña gai dbale skadi.” ");
INSERT INTO sabNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judas-Iscariote jo chke Jesudige, gerudu Jesu ole: —Cha tkanga tangle geruge, ¿che kle mine? Judas-Iscariote gbi kadu ene Jesuge gire ama Jesu sobadu. ");
INSERT INTO sabNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesu gerudu Judas-Iscariote ole: —Cha skatemanalla, ba chiu age cha ole, agede ene blike ba takalin kare. Jesu gerudu ene Judas-Iscariote ole gire guardia donga ulita jo Jesu gitigu ama Jesu gau dbale skadi. ");
INSERT INTO sabNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Boidu ene Jesu ole gire kwian geru jwannga ulita kle chage Jesu ole ama gdaite sbadi junnga kwarage, sbadi giti ama kwian gdaite ologa gaite tkunga ulita, kwian ologa jo tkabanga, kwian e lle boanga kwian gerunga Chube ole chugagwalla ma kweri alin. ");
INSERT INTO sabNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Kwian geru jwannga kwian ologa tkunga ene gire Jesu gerudu ama ole: —Ba mo sbadilla gbe naskuni sbadi kwarage. Cha gerule ba ole, kwian bai kle kira bate sbadi giti kwian ene gwabeda sbadi giti kaire agwe. ");
INSERT INTO sabNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Me uñale bage cha takalin cha ñage gerule nege cha Ñenua ole chudaboi kade amage? Gire blike ama be lle boanga ama alin nga ngaña giti ngle ngle kage cha chudaboi cha jwen siere cha dolla kote. ");
INSERT INTO sabNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Agwa cha mi age ene, cha age ene gire me ñage boi ulita cha ole Chube gerua degaba unsuialin gerule kare, Chube gerua kle gerule kwian agenga me no be cha gbe boi daga ngwale. ");
INSERT INTO sabNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Jesu gerudu ene kwian geru jwannga ole gire Jesu geru kadu kwian Jesu dolla ulitage: —¿Mineade ba ulita kle chage sbadi ole glita ole cha gai nate kwian jiskenga kare? Ba kle age cha ole salengwli ba age kwian agenga me no me no ole kare. Chui ulitage diali cha kledu ba ulita gwa giti kwian tke tangle u gerungwa Chube olege agwa ni bitaite ba cha gau dbale skadi cha kledu gerule giti. ");
INSERT INTO sabNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Kwian tanre Chube gerua ketanga Chube gerua degu unsuialin, chada e gerule cha be boi giti, nege ba kle age cha ole, e ulita kle boi ulia Chube gerua degaba unsuialin gerule kare. Jesu gerudu ene ulita kwian Jesu dolla ulita ole gire kwian geru jwannga Jesuge ulita jo kige, ama ulita Jesu chugu ngwadi boi daga ngwale gballa. ");
INSERT INTO sabNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Kwian Jesu ganga dbale skage, ama ulita Jesu du kwian gerunga Chube ole daba alin chugagwalla ma kweri ullage, chugagwalla e kada Caifás. U ege kwian israelita chugagwalla na ulita kledu mo litaba, kwian daba tkanga tangle Moisés chadalla giti ulita kaire kwian israelita chugagwalla juma ulita, kwian e ulita kledu mo litaba Jesu manade ngwange. ");
INSERT INTO sabNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedro jo chage gwage bate Jesu nate jo chke chege goga kodi uge kwian gerunga Chube ole daba alin chugagwalla ma kweri ullage, ne ngwadi Pedro toidu dba ule guardia u gerungwa Chube ole mananga ngle ole, Pedro kledu gwage ne ngwadi ene chke uñale Pedroge Jesu boabe mine bdagli. ");
INSERT INTO sabNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Kwian gerunga Chube ole daba alin chugagwalla ulita kaire kwian israelita chugagwalla kweri na ulita kle mo litaba u ege jennga Jesudi, ama ulita kledu kwian gweale jinade gerule ngwale Jesu dollale Jesu gbagda jiske, ene kwian israelita chugagwalla e ulita ñage Jesu gwangeda Jesu agedu gweale gdale. ");
INSERT INTO sabNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Kwian tanre chiu chugagwalla ulita mo litaba ngwadi geru gweale jinade ngwale Jesu dollale agwa ni kwian gdaite e gerua ngwale giti chugagwalla ñadu Jesu gbe jiske Jesu gwangeda, ama ulita me kle gerule ulia Jesu giti. Bdagli kwian gdaboke chku gerule me no Jesu giti, ");
INSERT INTO sabNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","kwian e gdaboke gerudu: —Cha Jesu keruchugu gerule ene: “Cha ñage u gerungwa Chube ole skiendba ulita gire chui gbamaire alin cha ñage u gbeni naskuni no biale.” Cha Jesu keruchugu sole ngwale ene, ama gerudu giti chage suge ama kle mo gbe kweri Chube kare, Chube alin allabi ñage age ene ama gerudu kare ama me Chube. ");
INSERT INTO sabNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kwian gdaboke gerudu ene gire kwian gerunga Chube ole chugagwalla ma kweri chku gdate geru kadu Jesuge: —¿Mineade ba me kle jainnga gerule mo giti kwian boke e kalen? Ama kle gerule ba dollale, ¿ama kle gerule ulia ba giti o me? ");
INSERT INTO sabNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Kwian gerunga Chube ole chugagwalla ma kweri gerudu ene Jesuge agwa Jesu me jaindunga dale, Jesu chegu kamne. Kwian gerunga Chube ole chugagwalla ma kweri gerudu nakwaite Jesu ole: —Cha gerule ba ole Chube gwa giti, Chube kle gwade ama kle che keruchuge che kle gerule giti, malen ba gerudale ulia mo giti cha ulita ole: ¿Ba Cristo, Chube nu ba kagaba ulia kwian alin o me? ¿Ba Chube Kirolla ulia o me? ");
INSERT INTO sabNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesu jaindunga: —Ima, cha amaña ba ulita kle gerule kare, cha Chube Kirolla. Cha gerule ba ulita ole, Chube kira molen tanre ulita, ama cha kagu kwian kare nga dba ai giti, chui be chke gire ba ulita be gwage chadi toiba dba Chube ko taingwli giti nga ngaña giti kwian ulita Chugagwallale, bdagli cha be chieni bogakwaske nga ngaña giti ba ulita gwa giti. ");
INSERT INTO sabNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Kwian gerunga Chube ole daba alin chugagwalla ma kweri Jesu keruchugu gerule ene gire ama skochiu Jesu gerudu giti, ta skochie ene ole ama ñometra modige gagunga, ama gerudu kwian chugagwalla na ulita ole Jesu giti: —Ba ulita onbre ai keruchugu gerule ama Chube Kirolla Chube nu ama kagaba. Ama kle gerule ene mo giti ama kle gerule Chube dollale. Ama kle mo gbe jiske agali ama kle gerule giti, malen che me kwian jinade dare gerule amadi ama gbagda jiske. ");
INSERT INTO sabNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Ba ulita tañachuge mine ama giti? ¿Che age mine ama ole? Kwian chugagwalla mo litaba ole ulita jaindunga: —Ama jiske tanre ulia, ama jogedaleda ama gerudu Chube dollale kbiale, che ama gwangeda. ");
INSERT INTO sabNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Kwian chugagwalla ulita gerudu ene gire ama gweale jolo tku Jesu gwadige ama Jesu batu, na Jesu batu gwage, ");
INSERT INTO sabNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","gire geru kadu Jesuge Jesu gbe kidegda: —Ba kle gerule ba Cristo, e ulia gire gerule cha ole, ¿chema kle ba bate gwage? ");
INSERT INTO sabNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Jesu kle boi ene gwa Caifás ullage gire Pedro kledu manade goga jita ngwachuge. Muinga gdaite lle boanga chugagwalla ma kweri alin kledu eni, ama chku Pedrodige gerudu Pedro ole: —Ba kaire kledu chage ule Jesu nga Galileamu ole. ");
INSERT INTO sabNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pedro gerudu muinga ole kwian ulita gwa giti: —Me dale, cha me ama uñe dale, ni uñale chage ba kle llema geruade cha ole. ");
INSERT INTO sabNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pedro gerudu ene gire Pedro jo manade ugakage, eni muinga lle boanga na gdaite gwagedu Pedrodi gerudu kwian na ole Pedro giti: —Kwian onbre e kledu chage ule Jesu una Nazaremu ole. ");
INSERT INTO sabNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pedro muinga lle boanga e keruchugu gerule ene gire Pedro gerudu nakwaite: —Cha gerule ulia ba ole Chube gwa giti, cha me kwian onbre e uñe dale. ");
INSERT INTO sabNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Sugeti kwian na ulita kledu eni Pedroge kodi jo Pedro gitigu gerudu Pedroge: —Kwian mneite chagedu Jesu ole diali, suge chage ulia ulia ba kwian ene gdaite. Ba gerule kwian nga Galileamu kare, ba kerua chege Jesu kle gerule kare, e giti suge chage ba ama chagemanalla ulia. ");
INSERT INTO sabNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pedro kwian keruchugu gerule ene gire ama ta skochiu tanre e gdale, ama gerudu: —Cha gerule ulia ulia ba ulita ole Chube gwa giti, cha me kwian onbre e ba kle gerule giti uñe. Cha me kle gerule ulia ba ole, gire ene Chube ñage cha gbe ji chuge tanre e gdale. Pedro gerudu ene gire sugetibi allabi antalan ngwanedu, ");
INSERT INTO sabNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","blikare Pedro tachku Jesu gerudu giti ama ole ngeru: “Antalan bebi ngwane gire ba agali be gerule bitamai kwian na ole ba me cha uñe.” Pedro tachku Jesu gerudu ene giti gire Pedro jo sugekare, ama olidu tanre tanre ama gerudu Jesu dollale giti. ");
INSERT INTO sabNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nga chku ju gire kwian gerunga Chube ole daba alin chugagwalla ulita kwian israelita chugagwalla juma ulita mo ta gbu salengwli biale Jesu gweda giti, ");
INSERT INTO sabNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","kwian e ulita Jesu ko lugangu, ama Jesu du chugagwalla gobernador Pilato ngwadi gbale jiske Pilatoge, Pilato kwian nga Romamu ama kwian nga Judeamu chugagwalla. ");
INSERT INTO sabNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas-Iscariote Jesu ketanga kwian Jesu dollage, ama gwagedu Jesudi mo dbange gbale jiske gire ama tale sugedu amage ama agedu me no Jesu ole. Judas-Iscariote ta olidu tanre ama tañachugu mo tale: “Ma no cha me agedu ene Jesu dollale.” Judas-Iscariote tañachugu ene malen ama mo ta gbu igi treinta Jesu ñanalla keteni naskuni kwian israelita chugagwalla ulitage, ama jo u gerungwa Chube olege kwian gerunga Chube ole daba alin chugagwalla ulita kaire kwian israelita chugagwalla juma ulita kle mo litaba ngwadi, ");
INSERT INTO sabNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Judas-Iscariote gerudu kwian e ulita ole: —Cha agedu me no Jesu ole, cha Jesu ketu ba ulitage gwaleda agwa cha gerule ba ole ama me jiske, ama agedu no diali kwian ulita alin, malen cha chiuni igi keteni naskuni bage. Gire kwian chugagwalla ulita jaindunga: —Ba me chie gerule cha ole e giti, cha ulita me kle tañachuge ba agedu giti, e ba agedu me cha agedu. ");
INSERT INTO sabNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Kwian gerudu ene Judas-Iscariote ole gire igi treinta Jesu ñanalla Judas-Iscariote mliunga dba gwa ne ngwadi u gerungwa Chube olege. Judas-Iscariote agedu ene gire ama jo siere u ege jo nga sugekarege, nga ege Judas-Iscariote giska tku mo siroge, ama mo guda agali. ");
INSERT INTO sabNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Kwian gerunga Chube ole daba alin chugagwalla ulita igi e jun nate gire gerudu modi igi giti: —Igi ai kwian gwabeda bea ñanalla, geru gbaba che ulita alin gerule che me ñage igi ai kare tke igi ogangwage u ai gerungwa Chube olege. ");
INSERT INTO sabNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Kwian gerunga Chube ole chugagwalla ulita geru tragu modige igi giti, gire bdagli ama ulita mo ta gbu dbi gige igi e giti, gire dbi ege kwian ñage kwian me una Jerusalénmu jaba tke dbige, ene kwian una namu jogekeda ama kle una Jerusalénge gire, nga kle ama jaba tkangwa dbige. Kwian dbi jutre jwdetigenga dodanga jogdale kaire lle na tanrere, kwian ege kwian gerunga Chube ole daba alin chugagwalla ulita dbi gigu. ");
INSERT INTO sabNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Dbi e jo gigaba ene kwian ege igi Jesu gwabeda bea ñanalla giti, malen dbi e ka gbere “Be Ngalla”, kadakle ene kaire nege tangle. ");
INSERT INTO sabNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ai boidu ene ulita kwian Chube gerua ketanga kada Jeremías Chube gerua degu unsuialin tangle kare, chada e gerule: “Igi treinta galeni naskuni kwian israelita ketu batre kwian gwabeda ñanale. ");
INSERT INTO sabNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Igi e giti dbi gigle kwian dbi jutre jwdetigenga dodanga jogdalege, ulita boidu salengwli Chube gerudu kare cha ole.” Jeremías Chube gerua degu ene unsuialin tangle. ");
INSERT INTO sabNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesu dbajo chke kwian nga Judeamu chugagwalla Pilato ngwadige, Pilato geru kadu Jesuge: —¿Ba kwian israelita ulita chugagwalla kweri? Jesu jaindunga Pilato kalen: —Ima, cha amaña ba kle gerule kare. ");
INSERT INTO sabNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Jesu gerudu ene gire kwian gerunga Chube ole daba alin chugagwalla ulita kaire kwian israelita chugagwalla juma ulita me chegu ta chuge Jesu gbe jiske Pilatoge ama ulita gerudu tanre me no Jesu giti, agwa Jesu chegu kamne kwian ulita keruchuge alin. ");
INSERT INTO sabNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Gire Pilato geru kadu Jesuge: —Kwian ulita kle ba gbe jiske, ¿ba me kle ama ulita keruchuge gerule ba dollale? ¿Mineade ba me gerule mo giti? ");
INSERT INTO sabNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Agwa Jesu ni gerudu gbaite, Jesu chegu kamne me jaindunga dale kwian ulita kalen kaire Pilato kalen, malen Pilato chegu tañachuge tanre Jesu giti mineade Jesu me kle gerule mo giti ni sidri. ");
INSERT INTO sabNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Diali Pascua chuiage chura kaire kaire Pilato kwian ageba me no kle skage gweale gdaite skajwanngenga kwian ulita takalin kare. ");
INSERT INTO sabNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","E suiale kwian gdaite agenga tanre me no kada Barrabás kledu skage agedu me no gdale. Kwian ulitage uñadu Barrabás agedu tanre me no malen e gdale ama kle skage. ");
INSERT INTO sabNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Kwian nglea ulita kledu mo litaba Pilatodi Jesu giti, Pilato geru kadu amage: —¿Ba ulita takalin cha chema skajwanngenga, cha Barrabás skajwanngenga o cha Jesu amaña kada Cristo skajwanngenga? ");
INSERT INTO sabNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilatoge uñadu ulita trate kwian israelita chugagwalla ulita semadu tanre Jesu ole, malen ama ulita Jesu du Pilatoge Jesu gbe jiske gwaleda. ");
INSERT INTO sabNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilato kledu manade toi dba kle lle boi ngwadige gire Pilato muira geru kagu Pilato alin Pilato ta gbagda: “Ba me age me no sidri onbre e ole, ama kwian no ama me jiske. Ngajrege cha gbi chugu tirare ama giti, e giti cha chegu tañachuge tanre chui ulita nege, ma no ba me age ama ole.” Pilato muira geru kagu ene Pilato alin agwa Pilato me geru e talladu. ");
INSERT INTO sabNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Kwian gerunga Chube ole daba alin chugagwalla ulita kaire kwian israelita chugagwalla juma ulita kwian ulita kledu eni ta gbu chke gerule Pilato ole Barrabás giti Pilato Barrabás skajwanngenga, ene Jesu chege Barrabás taneage gwaleda. ");
INSERT INTO sabNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Gire Pilato geru kadu nakwaite kwian ulitage: —¿Kwian gdaboke ai bai ba takalin cha skajwanngenga? Kwian ngle ulita jaindunga: —Cha takalin ba Barrabás skajwanngenga. ");
INSERT INTO sabNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Gire Pilato geru kadu: —Cha Barrabás skajwanngenga, gire ¿cha be age mine Jesu amaña kada Cristo ole? Kwian ulita jaindunga: —¡Ama gwangeda kruge! ");
INSERT INTO sabNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilato gerudu: —¿Mineade ba takalin cha ama gwangeda kruge? Chage suge trate ni ama agedu me no sidri, ¿llema giti ama jiske? Kwian ulita ngautu ma kweri Jesu dollale: —¡Ama gwangeda kruge! ");
INSERT INTO sabNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilato gwagedu kwian ngle ulita kledu skochie ma ngle Pilatodi Jesu giti, ta skochie ene ole kwian ngle ulita ñage mo ta gbe dole tirare, malen sugedu Pilatoge ngwale ama gerule dare kwian ngle ole Jesu giti, kwian mi ta jwlite dale Jesu giti. Gire Pilato chi kadu mo ko gligagda kwian ulita gwa giti, Pilato tañachugu age ene Pilato ñage chege trate Chube gwa giti me chege jiske Jesu giti, Pilato mo ko gligu kwian ngle ulita gwa giti, ama gerudu: —Cha me jiske dale onbre ai giti, bage uñale ba be age mine kaire ama ole, ba be ama gweda, ama jia be chege ba ulita alin me cha alin. ");
INSERT INTO sabNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Kwian ngle ulita gerudu Pilato kalen: —Chage suge onbre ai jogeda gdale jia mi kle ni kwian gdaite alin, agwa onbre ai jogeda gdale jia ulia kle, e be chege cha alin kaire cha chudalla ulita alin onbre ai gweda gdale. ");
INSERT INTO sabNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Kwian ngle ulita gerudu ene Pilato ole, gire Pilato Barrabás skajwanngunga. Pilato Jesu batangu ngeru gire Pilato Jesu ketu kwiange kwian ulita takalin kare Jesu gwaleda kruge. ");
INSERT INTO sabNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Guardia donga Pilato alin Jesu du Pilato ulla kwerige gwa gire eni guardia donga e ngle ulita mo litu Jesudi tangle kidere Jesudi. ");
INSERT INTO sabNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Guardia donga Jesu ñometralla junnga Jesudige, ama Jesu ngama tku kwian chugagwalla kweri nga dba aimu kle mo ngama tke kare, ñometra e kareske Jesu jo ngama tkaba. ");
INSERT INTO sabNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Kaire guardia donga giska kobaske bliu Jesu chuga batreti gire batu Jesu chugaske, guardia donga glita kliu Jesu ko taingwli kote. Guardia donga Jesu ngama tku ene ulita gire ama ulita jongnagwa skutu dba Jesu gwangnagu ngaute kweri Jesu gbe gidagda, ama gerudu Jesu ole kidere: —¡Ba kwian israelita ulita chugagwalla kweri noare, ba chege no kweri kwian ulita gwa giti! ");
INSERT INTO sabNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Guardia donga ulita gerudu ene Jesu ole ta me no ole, gire ama jolokwa tku Jesudi, kaire glita klire Jesu kote guardia donga glita e amaña junnga Jesuge kote glita e amaña giti guardia donga Jesu batu chugage. ");
INSERT INTO sabNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Guardia donga agedu ene ulita kidere Jesudi, gire ama ñometra chada dabere junnga Jesudige, ama Jesu ngama tkuni naskuni Jesu ñometrallaske, gire ama ulita jo Jesu dbe gwaleda kruge. ");
INSERT INTO sabNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Guardia donga ulita jo Jesu dbe kru ole nga Jesu gwabeda ngwadi, gire jonkare guardia donga tendu onbre kada Simón ngwange, Simón una Cirenemu, guardia donga Simón gau gbu Jesu krulla dbe. ");
INSERT INTO sabNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Guardia donga ulita jo chke Jesu dbe nga kada Gólgotage, kaire nga e amaña kada Calavera, nga ege Jesu dule gwaleda. ");
INSERT INTO sabNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Guardia donga bebi Jesu bate clavo giti kruge gire ama uva chia dage tugebanga gdege gageske ketu Jesuge jadale, Jesu uva chia e manachugu allabi gire me jaindu jai dare. ");
INSERT INTO sabNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Guardia donga Jesu gbu kruge ngaña, gire Jesu ñometralla jo jwanbanga Jesudige, ñometra e ulita guardia donga ulita girabatu modi guardia donga bai kaire blachku ole. ");
INSERT INTO sabNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Guardia donga ulita toidu dba Jesu kle kruge ngaña ngwadi, ama ulita chegu gwage Jesudi Jesu manadedi. ");
INSERT INTO sabNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Jesu chuga giti ngaña Jesu krullage chada degle gbere, chada e gerule: “Kwian ai kada Jesu ama kwian israelita ulita chugagwalla kweri rey.” ");
INSERT INTO sabNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Kaire kwian na gdaboke gbere kru na gdabokege ule Jesu ole, kwian e gdabonate agenga me no kwian skwe boanga, gdaite gbere kruge Jesu ko taingwli ngnagu giti, gdaite gbere kru nage Jesu ko jole ngnagu giti. ");
INSERT INTO sabNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Kwian ulita bai kaire kledu joge tangle Jesu kle kruge ngaña ngwadi, kwian e ulita gwagedu Jesudi kruge gire kwian chuga mliunga kidere Jesudi, ");
INSERT INTO sabNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ama gerudu me no tanre Jesu ole: —¿Ba amaña me gerudu ba ñage u gerungwa Chube ole skiendba ulita gire chui gbamaire alin ba ñage u e gbeni naskuni no biale? Ulia ba Chube Kirolla, gire ba mo jwennga kruge agali, ¡bai dbige kruge! ");
INSERT INTO sabNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Kwian ulita jo tangle Jesu kledu kruge ngwadi gerudu ene kidere Jesudi, ene kaire kwian gerunga Chube ole daba alin chugagwalla ulita, kwian daba tkanga tangle Moisés chadalla giti ulita, kwian israelita chugagwalla juma ulita, kwian e ulita kledu eni, ama kidedu tanre Jesudige, kwian e ulita gerudu me no modige Jesu giti: ");
INSERT INTO sabNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","43","—Ama ñadu kwian na tanre chudaboi agwa ama me ñage mo chudaboi agali dale mo jwennga kruge. Ama kwian israelita chugagwalla kweri ulia ama mo jwanlenga agali kruge, ene be suge che ulitage ama ulia Chube Kirolla gire che be ama gai ulia. Ama agali gerudu mo giti ama Chube Kirolla ama nu mo ta gbaba Chube ole, ulia ama Chube Kirolla ama gerudu kare, ulia Chube no ama ole, ¿mineade Chube me ama jwen siere ama kle boige nege? ");
INSERT INTO sabNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Kwian israelita chugagwalla ulita gerudu me no ene kidere Jesudi, kaire kwian agenga me no gdaboke kledu Jesu ole mo kaire kruge, ama gdabonate gerudu me no kidere Jesudi salengwli kwian na ulita kledu gerule kare. ");
INSERT INTO sabNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Chui chku bduke gire nga ulita nga dba ai giti chegu nga jereske, nga jere jagedu ene hora gdamai, chui jo chege nga bonga dbigu gire nga chra chiuni. ");
INSERT INTO sabNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Chui jo chege nga bonga dbigu gire Jesu ngautu kiraske mau kwirale: —Elí, Elí, ¿lema sabactani? —geru e gerule: “Cha Chubea, cha Chubea, ¿mineade ba cha chugu ngwadi boi daga ngwale gballa?” ");
INSERT INTO sabNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Kwian gweale kle ne ngwadi Jesu keruchugu, geru me sugedu trate kwian ege gire kwian e ulita gerudu modi: —Jesu kle ngaute kwian gerunga Chube alin daba ole unsuialin kadakle Elíage. ");
INSERT INTO sabNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Kwian ulita kle ne ngwadi gerudu ene modi Jesu giti gire kwian e gdaite jo jrite blike Jesu chudaboi, kwian e lle dagli kare ñeu uva chia gageske gbu glita gwagdage gire ama jo Jesu krulladi, glita giti ama uva chia gage gbu Jesu kate jadale ngaña kruge. ");
INSERT INTO sabNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Kwian na ulita kledu eni gerudu kwian gdaite e ole: —Ama chugene, ale manade gwage alin amadi Elías be chie ama jwen dbige kruge o me. ");
INSERT INTO sabNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jesu ngautu kweri nakwaite gire Jesu jokeda. ");
INSERT INTO sabNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Jesu jokeda ene gire sugeti ngwale ñometra ura kle itabanga gwa u gerungwa Chube olege, ñometra e skagedunga tainkwli bonga ngaña joge dba. Dbi jwliendu, kechuga skiendunga, ");
INSERT INTO sabNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","kaire keuga kwian jaba ogaba ngwadi tanre skiendunga nate, gire kwian jogebakeda sbali Chubenu ngle chkuni gwade. ");
INSERT INTO sabNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Kwian chkuni gwade ama chegu ne ngwadi, Jesu chkuni gwade gire kwian e ulita jo una Jerusalénge, kwian na tanre gwagedu kwian jogebakeda chkuni gwadedi. ");
INSERT INTO sabNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Guardia donga chugagwalla gdaite kledu ne ngwadi ule guardia donga na ngle ole Jesu gdachuge giti, ama ulita gwagedu dbi jwliendudi kaire lle na tanre kledu boi Jesu giti, kwian e ulita kendunga tanre kaire ama gerudu Jesu giti: —¡Ulia ulia kwian onbre ai Chube Kirolla! ");
INSERT INTO sabNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","56","Kaire muinga tanre kledu gwage bate Jesudige Jesu boidu ulita giti, muinga e ulita nu chieba nga Galileage Jesu ole llagli, ama ulita nu chageba Jesu ole Jesu chudaboi baini kaire Jesu chagedu ngwadi, muinga e ulita nu jogeba chke una Jerusalénge ule Jesu ole Jesu gatedi. Muinga e ulitaske muinga gdaite kadakle María-Magdalena kledu. Kaire María na kledu, ama Santiago kaire José chebia. Kaire Zebedeo kirolla chebia kledu ule. Muinga gdamai e kledu ule muinga na ulita ole gwage bate Jesudige Jesu jokeda ngwadi. ");
INSERT INTO sabNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Jesu jokeda chuia ngabi gire kwian onbre gdaite igi molen tanre kadakle José jo tienda Pilatodi, José una Arimateamu ama Jesu gerua ganga. ");
INSERT INTO sabNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","José jo chke Pilato ngwadi, ama Jesu jaba kadu Pilatoge ogadale. Gire Pilato geru kagu guardia donga alin guardia ñage José chuge ngwadi Jesu jaba jwennga kruge dbe ogadale keugage. ");
INSERT INTO sabNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","José jo chke Jesu jabadige gire José Jesu jaba jun dbige kruge, José Jesu jaba bliu ñometra no glitaleske. ");
INSERT INTO sabNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","José jo Jesu jaba dbe, jo chke Jesu jaba oge keuga jagere dodabage keuga e jagere Josénu, kaire keuga ege ni kwian jaba ogaba gdaite ne ngwadi. José Jesu jaba ogo ne ngwadi chiga gire ama kechuga kweri gbu ugakallage Jesu jaba nate gire José joni. ");
INSERT INTO sabNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Agwa María-Magdalena kaire María na gdaite ama boke chegu toiba dba keuga Jesu ogle ngwadi ugakalla ngnagu. ");
INSERT INTO sabNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Chui nagbietege chui e undege chuiage kwian gerunga Chube ole daba alin chugagwalla ulita kaire kwian fariseo ulita jo tienda Pilatodi, ");
INSERT INTO sabNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","kwian ene ulita gerudu Pilato ole: —Cha chugagwalla, che tachkedale Jesu oña giti, ama songa ngwale, ama kledu gwade gire ama gerudu ama be chkeni gwade chui gbamaige. ");
INSERT INTO sabNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Malen ma no ba kwian gweale kagadale Jesu ogle ngwadi keuga e manadedi chui mongikege, ene kwian geru jwannga amage me ñage chke ngajrege skwe boi Jesu jabage. Kwian gweale me keuga e manade gire kwian geru jwannga Jesuge ñage skwe boi Jesu jabage gire ñage gerule Jesu chkuni gwade, ene kwian songa ngwale e gerua ñage chege tragale ma ngle ngeruge. ");
INSERT INTO sabNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato jaindunga: —Guardia donga mneite kle e, ba ama ulita dbe keuga ugakalla manade, ba ama ulita gbe ugaka manade no no ta giti, ba me kwian chuge ngwadi skwe boi Jesu jabage. ");
INSERT INTO sabNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Pilato gerudu ene kwian israelita chugagwalla ulita ole gire kwian e ulita jo kwian guardia donga mneite dbe Jesu ogle ngwadi, keuga ugakalla giti ama lle uda eru gbu, lle uda e sklie kejre ene kwian me ñage keuga ugakalla e jwennga. Ama ulita keuga jegu kejre ene, gire ama guardia donga gbu Jesu jaba ogle ngwadi manadedi, ene kwian mi chie skwe boi Jesu jabage. Kwian israelita chugagwalla agedu ene ulita gire ama ulita joni. ");
INSERT INTO sabNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Undege chuia jo tangle gire nagbietege chui domingoge ngabebitabi muinga gdaboke joni Jesu jaba ogle ngwadi, muinga e gdaite María-Magdalena kaire María na gdaite jo tienda keugadi Jesu ogle ngwadi. ");
INSERT INTO sabNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Muinga e bebi joge chke ne ngwadi gire lle boanga Chube alin nga ngaña giti chku nga dba ai giti Jesu jaba ogle ngwadi, lle boanga Chube alin kechuga kweri gbaba keuga kage biunga siere, gire e kote nga jwliendu kweri, lle boanga toidu dba kechuga biabanga siere giti. ");
INSERT INTO sabNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Lle boanga Chube alin e gwadenga no nga ko chrachienga kare, ama ñometralla jutre salengwli dagli kare. ");
INSERT INTO sabNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Guardia donga ulita kledu Jesu jaba ogle ngwadi manadedi, ama ulita gwagedu lle boanga Chube alin edi gire guardia donga ulita gda jiredunga chru ole ama kira jonga nga jonga ama giti, ama chegu sugeti kwian jogebakeda kare. ");
INSERT INTO sabNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","María-Magdalena kaire María na jo chke ne ngwadi gire lle boanga Chube alin nga ngaña giti gerudu muinga e ole: —Ba me kennga, uñale chage ba kle chage Jesu jinade nate. ");
INSERT INTO sabNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ama me kle aini dale. Ulia ama gbere kruge, ama jokeda agwa ama chkuni gwadeni ama gerudu kare. ¡Bai aini, gwagede ama jaba ogle ngwadi, ama me kle aini dale, nege ama kle gwadeni! ");
INSERT INTO sabNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Joga blikare kwian geru jwannga Jesuge gdataboko giti gdaite kle ngwadi, ba geru ketadale ama ulitage Jesu giti, ba geru ai kete ama ulitage: “Jesu chkuni gwade, ama be joge nga Galileage ba ngeru, ba ulita jogedale ne ngwadige ten ama ngwange.” Ba geru kete ene ama ulitage cha kle gerule kare ba ole. ¡Joga, joga! ");
INSERT INTO sabNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Lle boanga Chube alin gerudu ene ulita gire blikare muinga boke jo siere keuga Jesu ogle ngwadige kennga tanre kaire agwe nga suga no ole, ama jo jrite blikare geru kete kwian geru jwannga ulitage lle boanga Chube alin geru ketu amage kare. ");
INSERT INTO sabNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Muinga boke kledu jrite geru kete kwian geru jwanngage gire Jesu chku mo kaite muinga ege jonke, Jesu gbi kadu muingage: —¿Che kle mine? Muinga boke jo Jesu gitigu ama jongnagwa skutu dba ko bliu Jesu seradi Jesu gai dage ama Jesu olladu. ");
INSERT INTO sabNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jesu gerudu muinga e ole: —Ba me ta kennga gerule cha giti. Joga geru kete kwian geru jwannga chage ulitage ama jogedale nga Galileage ten cha ngwange, ne ngwadi ama be gwage chadige —Jesu gerudu ene ulita María-Magdalena ole kaire María na ole. ");
INSERT INTO sabNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","María-Magdalena ule María na ole jo jrite geru Jesu giti kete kwian geru jwannga Jesuge ulitage gire kaire agwe guardia donga keuga Jesu jaba ogle ngwadi mananga gweale jo unaske, guardia e ulita geru ketu kwian gerunga Chube ole daba alin chugagwalla ulitage boidu mine ulita ama gwa giti Jesu jaba ogle ngwadige. ");
INSERT INTO sabNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Kwian gerunga Chube ole daba alin chugagwalla e mo litu kwian israelita chugagwalla juma ulita ole, ama ulita mo teun boidu Jesu ole giti. Gire ama ulita mo ta gbu ule igi kete tanre guardia donga keuga Jesu jaba ogle ngwadi mananga ulitage. ");
INSERT INTO sabNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Kwian gerunga Chube ole daba alin chugagwalla kaire kwian israelita chugagwalla juma ulita gerudu guardia donga e ulita ole ama ulita gerudale mine kwian ole Jesu jaba giti, ama ulita gerudu guardia ole: —Ba gerule kwian geru jwannga Jesuge ulita kigedu Jesu jaba ole ngajrege ba kledu gbe gire. Ba geru tragadale ene kwian ulita ole Jesu jaba giti. ");
INSERT INTO sabNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Chugagwalla Pilatoge be chke uñale ba ulita chegu gbe gire kigedre Jesu jaba ole, cha ulita be Pilato sko ñe, cha be gerule no trate ama ole ba ulita giti, ene ama mi ba gbe boi daga ngwale Jesu jaba gdale —kwian israelita chugagwalla gerudu ene ulita guardia keuga Jesu jaba ogle ngwadi mananga ole. ");
INSERT INTO sabNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Guardia e igi gau gerule ngwale Jesu jaba giti ñanale gire ama agedu ulita kwian israelita chugagwalla gerudu kare. E boidu ene e suiage tangle chui jo aige tangle kwian israelita kle gerule kaire kwian geru jwannga Jesuge ulita kigedu Jesu jaba ole ngajrege. ");
INSERT INTO sabNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","María-Magdalena ule María na ole jo chke kwian geru jwannga Jesuge gdataboko giti gdaite ngwadi, muinga e Jesu gerua ulita ketu ama ulitage gire geru jwannga ulita jo nga Galileage jwichuga Jesu nu geruba ama ole giti kare. ");
INSERT INTO sabNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Kwian geru jwannga Jesuge jo chke jwichuga ege, ne ngwadi ama ulita gwagedu Jesudige gire ama gwealege sugedu e ulia Jesu, geru jwannga e Jesu olladu nga suga no ole, agwa gweale na tañachugu e me dale Jesu ulia. ");
INSERT INTO sabNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesu jo kwian geru jwannga amage ulita gitigu gire Jesu gerudu: —Chube cha gbu nga ngaña giti mauñale nga dba ai giti mauñale, cha ñage age ulita Chube kiralla giti cha takalin kare. ");
INSERT INTO sabNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Malen cha gerule ba ulita ole, joga cha gerua trage kwian nga ulitamu ole, ba gerudale ama ole cha giti ene ama ñage cha gerua gai ulia ba kare, kwian ulita bai kaire cha gerua keruchuge ba giti gire mo ta gbe cha gai ulia, ba kwian ene ulita ñeadale chiske gai ngaña chigage cha Ñenua kalla giti cha Chube Kirolla kalla giti kaire Chube Oña kalla giti. ");
INSERT INTO sabNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Kaire ba kwian e ulita tkale tangle cha gerua gai dage ulia age diali ulita cha gerudu ba ole kare. Ba ulita joge cha gerua dbe ene, gire cha be kle ba ole ule diali ba chudaboi chui tangle chui ulitage —Jesu gerudu ene ulita kwian geru jwannga amage ulita ole.");
INSERT INTO sabNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jesucristo Chube Kirolla, Chube gerua no ama giti kle degaba chada ai ulita giti. ");
INSERT INTO sabNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ngeru Jesucristo bebi chie nga dba ai giti Chube gerudu ama be kwian gdaite Jesucristo gerua dbanga kage kwianske gerule gwangea kwian ole Jesucristo giti, e suiale kwian Chube gerua ketanga kadakle Isaías Chube ama gbu chada dege kwian Jesucristo gerua dbanga be chie giti, chada e gerule, Chube gerudu: “Cha be kwian gdaite cha gerua dbanga kage ba ngeru, kwian geru dbanga e be kwian na ta gbe biale ulita ba ngwange. ");
INSERT INTO sabNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Nga gballage kwian gdaite e be gerule kwian ole ene: ‘Che Chugagwalla be chie baske, ba ulita kledale biale ama ngwange, ba mo ta gbadale biale no trate ama ngwange kwian kle jon lite trate biale chugagwalla ngwange kare.’ ” Isaías chada jigu degaba unsuialin gerule ene kwian geru dbanga be chie giti, ");
INSERT INTO sabNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","6","kwian geru dbanga e kada Juan-Bautista, ama chku Isaías chada degu kare. Juan-Bautista suiage tangle boidu ene ulia Chube Isaías ta gbu chada dege kare. Juan-Bautista toidu nga gballage, bda kada camello boli dodaba ñometraleske Juan-Bautista mo ngama tku, kaire ama mo ñometralla mo bonga tangle luguda chbi kwara dodaba drega giti. Juan-Bautista sri kweri kweri gutu, kaire ama likin jau. Juan-Bautista toidu nga gballage, nga ege kwian tanre kledu joge chke Juan-Bautistadi Juan-Bautista keruchuge gerule Chube gerua giti. Kwian tanre nga Judeamu kaire kwian tanre una Jerusalénmu jo chke Juan-Bautista kle ngwadi, kwian e ulita bai kaire kledu joge chke Juan-Bautista kle ngwadi Juan-Bautista gerudu ai kare ama ole: “Ba ulita mo ta blitadale Chube ole, ba age me no chuge ngwadi me chage age me no dare, kaire ba mo chugadale ngwadi mo ñeange chiske kwian na gwa giti ene ba kle mo kaite nate kwian nage ba mi chage age me no ba chagedu ngeru kare. Ba age ene gire ba agedu me no ulita Chube be talla mlienga, ama mi tañachuge dare ba agedu me no giti.” Kwian ulita Juan-Bautista keruchugu gerule ene gire ama gweale mo ta blitu Chube ole, kwian ene ulita gerudu ai kare Chube ole kwian na ulita gwa giti: “Chube, cha agedu me no tanre ba dollale, cha me ta agekalin me no ene dare, nege cha ba gakalin ulia mo Chugagwallale.” Kwian mo ta gbu no ene Chube ole gire Juan-Bautista ama ulita ñeu chiske gau ngaña chigage chi kada Jordánge. ");
INSERT INTO sabNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","8","Kaire Juan-Bautista gerudu kwian ulita ole Jesu giti, ama gerudu: “Ulia kwian gdaite be chie cha nate, ama ma kira molen chage, ama be ñage age ma no kwian alin chage, ama be Chube Oña gbe kwian tale. Cha ñage kwian ñe chiske alin agwa cha me ñage Chube Oña gbe kwian tale. Ulia kwian gdaite be chie cha nate ama ma no ma kweri ulita chage, cha me ñanaske ama chudaboangale ni ama zapatolla jwennga ama serage.” Juan-Bautista chagedu gerule ene kwian ole Jesu giti. ");
INSERT INTO sabNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Jesu kledu toi una Nazarege nga kweri Galileage gire ama jo chke Juan-Bautista kle kwian ñe chiske ngwadi chi Jordánge, ne ngwadi Juan-Bautista Jesu ñeu chiske. ");
INSERT INTO sabNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jesu joni keda chi kagdage gire ama tienduda nga ngaña giti, ama gwagedu nga tigedunga nga ngaña giti, ama gwagedu Chube Oñadi beusi kare chie gwadbiguda ama giti. ");
INSERT INTO sabNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Gire Chube kerua sugedu Jesuge gerule nga ngaña giti, Chube gerudu Jesu ole: “Ba cha Kirolla, cha no no ba ole, nga suga noare chadi ba giti.” Chube kerua sugedu ene gerule mo Kirolla Jesu ole. ");
INSERT INTO sabNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Boidu ene Jesu ole chi Jordánge gire Chube Oña Jesu ta gbu joge toi nga gballage, ");
INSERT INTO sabNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","lle ngaske chudalla daga ngwale kledu ne ngwadi. Jesu toidu gballa nga ege chui ngle cuarenta, Jesu kle toi ne ngwadi gire che dolla Satanás mo chugu tanre Jesu ole, Satanás tadu Jesu ta blitakalin age me no Chube dollale, agwa Jesu me agedu Satanás tadukalin kare. Nga ege lle boanga Chube alin nga ngaña giti tanre chku Jesudi Jesu chudaboi Jesu kira gbe. ");
INSERT INTO sabNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Juan-Bautista kle skage suiale Jesu joni nga Galileage Chube gerua kete kwian ulitage. ");
INSERT INTO sabNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Jesu gerudu kwian ole ene: “Me sbali gire kwian ulitage be suge Chube kwian Chugagwalla kweri kiraske, Chube cha kagu ba ulita jwen siere ji chugege ba agedu me no gdale, malen cha gerule ba ole, ba ulita mo ta blitadale Chube ole age no ama takalin kare, ba age me no chuge ngwadi me chage age me no dare, ba ulita mo ta gbadale Chube gerua gai ulia age no Chube takalin kare.” Jesu chagedu gerule ene kwian ole nga Galileage. ");
INSERT INTO sabNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Chui gbaite Jesu jo chage chibita kada Galilea kagdage, ne ngwadi Jesu gwagedu kwian onbre gdabokedi, ama gdaite kada Simón kaire Simón daballa kada Andrés. Kwian gdaboke e ngwe jwannga ama kledu gdeba tke chiske ngwe gagda, ");
INSERT INTO sabNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","gire Jesu gerudu kwian ngwe jwannga boke e ole: —Bai chage cha ole geru jwen chage, nege ba kwian ngwe jwannga, agwa chui negege gwangerugu cha be ba gbe kwian na tke tangle cha gerua giti, ene ba giti kwian ngle be cha gerua gai ulia, ba kle ngwe gai ngle gdebage kare ene ba be kwian gai cha alin cha gerua giti. ");
INSERT INTO sabNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Jesu gerudu ene Simón ole kaire Andrés ole gire sugeti ama gdabonate gdeba chugu ngwadi, jo chage Jesu ole. ");
INSERT INTO sabNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jesu jo chage na sugeti onbre e boke ole gire Jesu tendu Santiago ngwange kaire Santiago daballa kada Juan ngwange, Santiago kaire Juan kledu ule ñenua kadakle Zebedeo ole gdeba ugachuge du toli chiga. ");
INSERT INTO sabNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Gire Jesu gerudu Santiago ole kaire Juan ole: —Bai chage cha ole geru jwen chage. Jesu gerudu ene gire onbre gdabonate e ñenua Zebedeo jigu du toli chiga kwian na ñenua chudaboanga ulita ole, gire ama gdabonate jo chage Jesu ole. ");
INSERT INTO sabNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jesu ule kwian geru jwannga amage ulita ole jo chke una Capernaumge gire chui e ama jo chkege chui e undege chuia kwian israelita alin, chui ege Jesu jo u mo litangwa Chube gerua jwanngwage, u ege Jesu kwian tku tangle Chube gerua giti. ");
INSERT INTO sabNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Kwian ulita kledu eni Jesu keruchuge ama ulita chegu tañachuge tanre Jesu gerudu giti, kwian tañachugu mo tale: “¿Mineade ama ñage che tke tangle ene trate? Ama kle che tke tangle ma no ma kiraske kwian che tkanga tangle Moisés chadalla giti ulitage, ama kle che tke tangle kwian geru mauña kweri kare.” Kwian ulita tañachugu ene mo tale Jesu giti. ");
INSERT INTO sabNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Jesu kledu kwian tke tangle ene gwa u mo litangwa Chube gerua jwanngwage, kwian onbre gdaite jwligebanga che dolla kote kledu eni, ");
INSERT INTO sabNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","dolla onbre e gbu ngaute Jesuge: —¡Jesu una Nazaremu, cha ulita chugene toi no! Chage uñale ba chema, ba Chube Kirolla no trate, uñale chage ba chiu nga dba ai giti cha ulita gbe ji chuge. Cha me takalin ba cha gbe boi daga ngwale, ba cha ulita chuge ngwadi ngwedi. ");
INSERT INTO sabNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesu ka bo dolla e ole: —¡Chegede kamne, joga siere onbre ege! ");
INSERT INTO sabNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Jesu gerudu kiraske ene dollage gire dolla kledu kwian edi nga kagunga onbre e giti onbre gbu trateda dba tangle, dolla e onbre gbu ngaute kiraske kweri gire dolla e jo siere onbre ege. ");
INSERT INTO sabNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Boidu ene kwian ulita gwa giti gire kwian chegu tañachuge tanre, kwian geru kadu moge ongoru ongoru: —¿Kle boi mine aini cheske? Ulia Jesu kle che tke tangle geru jagere giti, kaire ama kle age kiraske che gwa giti. Ama kle gerule dolla ole dolla jogedale siere kwian jwligebangage gire dolla kle ama kerua gai dage kle age Jesu kle ama kage kare. ");
INSERT INTO sabNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ai ulita kledu boi ene Jesu ole, gire nga ulita nga Galileage geru chagedu kwianske, chku uñale kwiange Jesu kledu age kiraske tanre kwian gwa giti kwian ngwale me ñage age kare. ");
INSERT INTO sabNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jesu jo siere u mo litangwa Chube gerua jwanngwage gire Jesu jo chage Santiago ole kaire Juan ole, kaire kwian geru jwannga Jesuge na jo ama ole ule. Ama ulita jo chke Simón kaire Andrés ullage. ");
INSERT INTO sabNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Jo chke ne ngwadi gire kwian geru ketu Jesuge Simón ñemaña giti ama kledu gwa ankwa giti oga nganagda ole. ");
INSERT INTO sabNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesu geru e keruchugu gire Jesu jo Simón ñemaña kledu gbeba dba ngwadige, Jesu muinga e ko gau kote ama gau bdugu. Gire sugetibi allabi nganagda jo siere muingage muinga jo chkeni noni, gire muinga e mo gbubi bli jinade Jesu alin kaire kwian na ulita kledu eni alin, ama bligda dodadu gutadale. ");
INSERT INTO sabNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","33","Chui amañage ngabi nga jo jere gire kwian tanre una ege jo chke u Jesu kle ngwadige daba oga dbe Jesuge dodadale. Kwian ngle oga jingme tanre ole dule Jesu kle ngwadi, kaire kwian ngle jwligebanga dolla kote dule Jesu kle ngwadi dodadale. ");
INSERT INTO sabNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Gire Jesu kwian oga jingme ole tanre ulita dodadu kaire dolla kwian gbaba jwligebanga ulita Jesu kagu siere kwian jwligebangage, kwian ulita cheguni no naskuni. Jesu dolla ulita kagu siere kwiange, dolla e ulitage uñadu Jesu Chube Kirolla, Jesu me tadukalin dolla geru e kete kwiange malen Jesu me dolla chugu ngwadi gerule, dolla ulita chegu kamne. ");
INSERT INTO sabNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Nga ju ngwange nga bebi chra chke dba no gire Jesu chku bduge jo siere unage ama jo nga gballage kwian me ngwadi gerule Chube ole. ");
INSERT INTO sabNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","37","Nga chku ju ni uñadu Simónge ni uñadu geru jwannga na ulitage Jesu kle baini. Simón kwian geru jwannga na ulita ole jo Jesu jinade nate, gire Jesu skwendu amage nga gballage. Simón gerudu Jesu ole: —Kwian ulita kle ba jinade nate. ");
INSERT INTO sabNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesu jaindunga Simón kalen: —Ale una nage kodi che kle ngwadige Chube gerua no kete kwiange. Ulia Chube cha kagu nga dba ai giti ama gerua gbadale chke uñale kwian nage kaire. ");
INSERT INTO sabNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Jesu chagedu una ulitage nga Galileage kwian tke tangle Chube gerua giti, diali ama jo u mo litangwa Chube gerua jwanngwage una kaire kairege Chube gerua trage kwian ole, kaire ama dolla tanre kagu siere kwiange, diali Jesu kwian chudabo no ulita. ");
INSERT INTO sabNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Kwian onbre gdaite oga jingme kwian kwara gbe tuge ole, kwian e jo Jesu gitigu. Kwian ege sugedu Jesu kira molen ngle malen ama jongnagwa skutu dba Jesu gwangnagu gire gerudu Jesu ole: —Ba takalin cha dodade, uñale chage ba ñage jingme ai jwen siere chage ene cha chege no trate jingme aige. ");
INSERT INTO sabNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Kwian gerudu ene Jesu ole gire Jesu taidu dage amage, Jesu ko gbu onbre e giti gire Jesu gerudu: —Cha takalin ba jingmea jwen siere bage, nege nege ba chege no trate. ");
INSERT INTO sabNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Jesu gerudu ene gire sugeti jingme jongwa onbredi, ama chegu noni. ");
INSERT INTO sabNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Gire Jesu gerudu onbre jo chke noni ole: —Ba me gerule ni kwian gdaite ole cha ba dodadu giti agwa ba agedale Chube nu geru gbaba unsuialin kwian alin Moisés giti gerule kare, chada e gerule ba agedale ai kare: Joga u gerungwa Chube olege mo kaite kwian gerunga Chube ole daba alinge, ba bdada gbaboke dbadale ule gugadale Chube gwa giti u ege ba chegu no trate ñanale, joga age ene ulita gire be chke uñale kwian ulitage ba jo chkeni no ba jingmeage. ");
INSERT INTO sabNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Jesu gerudu kwian onbre e ole onbre me geru ketadale kwian nage Jesu ama dodadu giti, agwa onbre me geru e gatu mo tale Jesu gerudu kare, onbre chagedu geru e trage kwian ulitage Jesu agedu ama alin giti, onbre e giti kwian tanrege chku uñale Jesu giti, malen Jesu me chegu ñage joge unaske, ama chegu nga gballage kwian me kle toi ngle ngwadige agwa kwian nga tanremu chiu kaire Jesu nate Jesu kledu ngwadige mo chudaboi kade Jesuge. ");
INSERT INTO sabNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Chui gweale jo tangle gire Jesu joni naskuni una Capernaumge, jo chke gwa ama kle toi ngwadige una ege, gire chku uñale kwian una emuge Jesu kledu gwa. ");
INSERT INTO sabNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Kwian tanre mo litu ne ngwadi ni kwian na gdaite ñage tien kwianske tangle u ugakallage. Jesu kledu geru Chube giti kete kwiange kwian tke tangle Chube gerua giti, ");
INSERT INTO sabNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","gire kwian gdabaga chku daba oga dbe ankwage mo kaskwada dodadale Jesuge. Kwian e oga skliedba trate jegwale me ñage chage. ");
INSERT INTO sabNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kwian chku daba oga dbe goga ugakage agwa me ñadu tien gudegu ugakage kwian tanre kledu ugakage, gire ama ulita jo u giti bdugu kalerage daba oga ole, jo chke u giti gire udrega junnga ankwa tien mangire batre gire ama ankwa ska tku giska giti, ankwa tku dbige daba oga ole Jesu gwangnaru Jesu kle ngwadi gwa. ");
INSERT INTO sabNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesu gwagedu kwian ogadi gire uñadu Jesuge kwian oga kaire kwian oga dbanga ulita mo ta gbaba ulia Jesu ole Jesu ñage kwian oga dodade, malen Jesu gerudu kwian oga ole: —Cha gerule ba ole, ba ageba me no ulita talla cha mlienga, nege ba chege no trate me jiske Chube gwa giti. ");
INSERT INTO sabNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Kwian daba tkanga tangle Moisés chadalla giti gweale kledu toiba dba eni Jesu keruchuge gerule ene kwian oga ole gire tañachugu Jesudi mo tale: ");
INSERT INTO sabNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Mineade onbre e kle gerule ene kwian oga ole? Ama me ñage gerule ene, ama kle mo gbe kweri Chube kare. ¿Chema ñage kwian age me no ulita talla mlienga kwian gbe no trate me jiske Chube gwa giti? Chube alin allabi ñage, onbre e me ñage age ene Chube kare.” ");
INSERT INTO sabNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Kwian daba tkanga tangle Moisés chadalla giti ulita kledu tañachuge ene mo tale Jesudi gire ulia Jesuge uñadu trate kwian e ulita kle tañachuge giti, Jesu geru kadu kwian e ulitage: —¿Mineade ba ulita kle tañachuge ene chadi? ");
INSERT INTO sabNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Bai ma mno cha alin: kwian oga ai ageba me no ulita talla mlienga o kwian oga ai dodade jingmege? Cha alin ai me mno ulita gdabonate. ");
INSERT INTO sabNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nege cha be kwian oga ai dodade ba ulita gwa giti ene be chke uñale bage ulia Chube cha kagu nga dba ai giti kwian kare, Chube kiralla giti cha ñage kwian oga dodade jingmege kaire agwe cha ñage kwian age me no ulita talla mlienga kwian gbe no trate me jiske Chube gwa giti. Jesu gerudu ene kwian daba tkanga tangle Moisés chadalla giti ulita ole gire Jesu gerudu kwian oga skliebada trate jegwale ole: ");
INSERT INTO sabNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Nege cha gerule ba ole, chkede gdate mo ankwalla blienga dbadale, jogani chage ba kle toi ngwadige. ");
INSERT INTO sabNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Jesu gerudu ene gire kwian oga skliebada chku gdate sugeti no trate, ama mo ankwalla gau kote, ama joni chage kwian ulita kle ne ngwadi gwa giti. Kwian e ulita gwagedu ai ulita boidudi gire kwian ulita ta me jo sugano chegu tañachuge tanre, kwian gerudu no Chube giti: —Chube noare, ama kira molen ulita. Noare Jesu kwian oga dodadu Chube kiralla giti, ni bitaite che nu gwageba kwian skliebada gbere chage no trate ai karedi, ulia Chube no no —kwian ulita gerudu no ene Chube giti. ");
INSERT INTO sabNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesu kwian oga skliebada dodadu ene gire Jesu joni nakwaiteni chage chibita kagda giti. Ne ngwadi kwian ngle jo chke Jesudi tangle gire Jesu kwian ulita tku tangle Chube gerua giti diali kare. ");
INSERT INTO sabNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Jesu jo chage dare gire ama gwagedu kwian onbre kadakle Levídi, Leví Alfeo kirolla, Leví kwian igi ganga chugagwalla emperador nga Romamu alin, ama kledu toiba dba igi ketakle ngwadi igi gai kwiange, gire Jesu chku amadi, gerudu ama ole: —Bai chage cha ole geru jwen chage. Jesu gerudu ene gire Leví chku gdate lle e boi chugu ngwadi ulita, ama jo chage Jesu ole. ");
INSERT INTO sabNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Bigire Leví Jesu kadu blire mo ullage, gire Jesu jo ule kwian geru jwannga amage ulita ole Leví ullage blire ule Leví ole. Kaire agwe kwian na tanre igi ganga chugagwalla emperador nga Romamu alin kaire kwian na tanre agenga me no kledu chage Jesu nate diali Jesu keruchuge gerule Chube giti, kwian e ulita chku ne ngwadi kaire blire ule Jesu ole. ");
INSERT INTO sabNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Kwian ulita kle blire ene gire kwian daba tkanga tangle Moisés chadalla giti mneite kaire kwian fariseo mneite kledu eni gwagedu Jesudi blire ule kwian tanre agenga me no ole, gire kwian e geru kadu Jesu giti ta me no ole kwian geru jwannga Jesuge ulitage: —¿Mineade ama kle blire ule kwian igi ganga chugagwalla emperador nga Romamu alin ole kaire kwian na tanre agenga me no ole? ");
INSERT INTO sabNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Kwian gerudu ene kwian geru jwannga Jesuge ole gire Jesuge geru sugedu kwian kledu geru kade giti, malen Jesu gerudu kwian e ole: —Cha gerule ba ulita ole, kwian kle no trate me oga me joge kwian mo dodanga ngwadi mo dodade, agwa kwian oga ima ama joge kwian mo dodanga ngwadi mo dodade. Cha chiu nga dba ai giti kwian agenga me no ta blite Chube ole joge siere ama kle age me noge, agwa kwian gweale kle tañachuge mo tale ama no trate me jiske Chube gwage, kwian kle tañachuge mo giti ene alin cha me chiu, cha chiu kwian agenga me no alin —Jesu gerudu ene kwian ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Chui gbaitege kwian geru jwannga Juan-Bautistage ulita kaire kwian fariseo ulita kledu mo tke bage bligdage gerudale Chube ole, gire kwian gweale jo geru kade Jesuge e giti, kwian e gerudu Jesu ole: —Kwian geru jwannga Juan-Bautistage ulita kaire kwian fariseo ulita diali kle chui gweale gai mo tkale bage bligdage gerudale Chube ole alin chui ulita me blire. Kwian e ulita kle age ene tanre agwa kwian geru jwannga bage ni gdaite kle age ene. ¿Mineade kwian geru jwannga bage me kle mo tke bage bligdage chui gwealege cha ulita kle age kare? Kwian geru jwannga bage ulita kle blire chui ulitage. ");
INSERT INTO sabNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Geru kadre ene Jesuge gire Jesu jaindunga ene kwian kalen: —Cha be geru ai ñachuge ba ulita alin, ene be chke uñale bage mineade kwian geru jwannga chage me kle mo tke bage bligdage kwian na kle age kare. Kwian onbre mo jwen chuia gbe, mo jwen chuia chke gire kwian kadaba ulita be joge chui ollade ule kwian onbre mo jwannga ole. Kwian kadaba ulita be chke chui ollade, ¿chema be gerule kwian e me ñage blire? Kwian ulita be blire nga suga no ole chui ollade ule kwian onbre mo jwannga ole. ");
INSERT INTO sabNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Agwa chui e joge tangle gire chui gbaite be chke kwian onbre mo jwannga dbabe sugekare, chui ege kwian mo jwen chuia olladanga be chege ta olire kwian onbre mo jwannga nate gire kwian chui olladanga ulita be mo tke bage bligdage ta olire ole. Ulia cha gerule ba ulita ole, cha kwian onbre mo jwannga e kare, kwian geru jwannga chage ulita kwian mo jwen chuia olladanga kare. Nege cha kle ule geru jwannga chage ulita ole, agwa chui be chke gire cha dbabe sugekare amage, chui ege ama be mo tke bage bligdage ta olire tanre ole. ");
INSERT INTO sabNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Jesu geru ñachugu ene kwian alin gire Jesu geru na ñachugu dare ai kare: —Cha gerule ba ulita ole, ni kwian gdaite kle mo ñometralla juda ugachuge ñometra jagere me gligabage. Che ñometra jagere gbe ñometra juda giti, gire che ñometra jagere glige ñometra junbate ñometra chege ma soli, ñometra jagere kle ñometra juda gbe dretenga, gire ñometra uga kle chege ma me no kweri, ulita kle chege me no. ");
INSERT INTO sabNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Kaire ni kwian gdaite kle lle gage jagere tke bda kwara dodaba lle gage dbangwa judage. Che lle gage jagere tke bda kwara judage lle gage jagere kle lie gire bda kwara juda kle skiennga ulita, gire lle gage ulita kle jogenga ngwale ulita kaire bda kwara kle chege me no ulita. Malen diali lle gage jagere tkakle bda kwara jagerege, ene lle gage kle lie, bda kwara me skiennga, lle gage me jogenga ngwale. Jesu geru ñachugu ene ulita kwian alin, uñadu Jesuge kwian gweale me ta Jesu gerua jagere gakalin ulia me ta mo gerua juda gbaba unsuialin chugakalin ngwadi, malen Jesu geru ñachugu ene kwian alin geru jagere giti geru juda giti. ");
INSERT INTO sabNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Chui gbaite undege chuiage Jesu kledu chage trigoske tangle deage ule kwian geru jwannga amage ulita ole, gire kwian geru jwannga Jesuge ulita mo gbu trigo dabe bulu ite gutadale. ");
INSERT INTO sabNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Kwian fariseo mneite gwagedu kwian geru jwannga Jesuge ulitadi ama kle lle boi kare deage undege chuiage gire kwian fariseo gerudu Jesuge: —Gwagede kwian geru jwannga bage ulitadi, ama kle age me no Chube gerua Moisés nu degaba unsuialin dollale. Uñale bage Moisés chadalla e giti geru kle gbaba che alin che me ñage lle boi undege chuiage, ¿mineade ba kle geru jwannga bage ulita chuge ngwadi lle boi deage undege chuiage? ");
INSERT INTO sabNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesu jaindunga kwian fariseo kalen: —¿Ni bitaite ba nu chada batabanga che chugagwalla unsuialin David agedu giti? Chui gbaite David ule ama chagemanalla ulita ole bli ole tanre, ¿gire ama agedu mine? ");
INSERT INTO sabNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Uñale ba ulitage David jo gwa u gerungwa Chube olege ule ama chagemanalla ulita ole, u ege gwa pan gbakle, pan e chegedale Chube gwa giti diali, Chube gerua kle gbaba kwian ulita alin geru e gerule kwian gerunga Chube ole daba alin ama alin allabi ñage pan e gute ni kwian na gdaite ñage pan e gute. Agwa David bli ole tanre, ama pan e gutu kaire ama pan e ketu kwian ulita kledu chage ama olege gutadale. David pan e gutu Chube gwa giti agwa ama me boidu dale, Chube me ama gbu jiske ama pan e gutu gdale. David agedu ene suiale kwian kada Abiatar chegu gerunga Chube ole daba alin ma kweri na ulitage u gerungwa Chube olege. ");
INSERT INTO sabNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Cha gerule ba ulita ole, ba me ñage kwian geru jwannga chage gbe jiske ama trigo bulu itu undege chuiage gdale, Chube gwa giti ama me jiske dale. Chube undege chuia gbu kwian alin undegangwa nga suga no ole, chui e chegu no kwian ulita alin, Chube me chui e gbu kwian alin kwian ta gbagda olire. ");
INSERT INTO sabNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Chube cha kagu nga dba ai giti kwian kare, ama cha gbu undege chuia mauña, malen cha ñage gerule kwian ole kwian llema boadale chui undegangwage llema me boadale chui undegangwage —Jesu gerudu ene ulita kwian fariseo mneitege. ");
INSERT INTO sabNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Kwian israelita me lle boi chuiage chui undegangwa chui ege Jesu jo chkeni nakwaite u mo litangwa Chube gerua jwanngwage, eni onbre gdaite oga kledu, onbre e oga ko kwebanga ole. ");
INSERT INTO sabNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Kwian fariseo mneite kledu eni gwa u ege, kwian fariseo e kledu tatra onbre oga ko kwebanga giti, ama ulita tadu Jesu gbakalin jiske lle boi undege chuiage gdale, malen ama ulita chegu gwage Jesudi Jesu be onbre oga dodade o mi onbre dodade undege chuiage. ");
INSERT INTO sabNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesu gwagedu onbre ko kwebangadi, Jesu gerudu onbre e ole: —Chkede gdate, bai aini kwian ulita gwa ngeru mo ko oga kaite kwian ulita gwa giti. ");
INSERT INTO sabNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Onbre oga chku gdate kwian ulita gwa giti, gire Jesu geru kadu kwian ulita kle amadi tanglege: —¿Che llema boadale undege chuiage? ¿Che age no kwian alin o che age me no kwian alin? ¿Che ñage kwian oga chudaboi o che kwian oga chugadale ngwadi boi daga ngwale jogekeda? Jesu geru kadu ene kwiange, agwa kwian ulita chegu kamne kwian me jaindunga Jesu kalen. ");
INSERT INTO sabNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Gire Jesu ta skochiu kwian mangire batre kledu amadi tangle ole, kaire Jesu ta olire kwian ulita giti, uñale Jesuge kwian ulita me kle tai dage daba ogage ni ta daba chudaboakalin. Jesu gerudu kwian oga ko kwebanga ole kwian ulita gwa giti: —Mo ko kwebanga kwrida trate. Onbre mo ko kwriu Jesu gerudu kare, gire ama ko kwebanga jo chkeni no trate. ");
INSERT INTO sabNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Jesu onbre ko kwebanga dodadu undege chuiage kwian fariseo gwa giti, e giti kwian fariseo ulita ta skochiu tanre Jesudi jo siere blike u ege, ama ulita mo ta gbu ule chugagwalla Herodes skatemanalla ulita ole ama ulita mo ta gbu salengwli Jesu gbe jiske Herodege Jesu agedu giti, ene Herodes be Jesu gwangeda talla jo chke kwian fariseoge kaire Herodes skatemanalla ulitage. ");
INSERT INTO sabNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesu jo siere u mo litangwa Chube gerua jwanngwage gire ama jo chage chibita kagda giti ule kwian geru jwannga amage ulita ole, kwian tanre jo chage Jesu nate, kwian tanre nga Galileamu, ");
INSERT INTO sabNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","kwian tanre nga Judeamu, kwian tanre una Jerusalénmu, kwian tanre nga Idumeamu, kwian tanre toinga chi kada Jordán giti chkagu, kwian tanre toinga una Tiro giti tangle, kwian tanre toinga una Sidón giti tangle, kwian tanre nga ege ulitamuge geru Jesu giti chkeba uñale malen ama ulita jo tienda Jesudi Jesu keruchuge. ");
INSERT INTO sabNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Kwian e ulitaske Jesu kwian oga tanre dodadu malen kwian oga na ulita kledu kwian nglea bienga jogedale chke kodi Jesuge, kwian oga e tadu Jesu chugakalindi ene ama tañachuge ama joge chkeni noni trate. Kwian tanre kledu mo lite Jesudi tangle kwian chege sklieba kejre moske malen Jesu gerudu kwian geru jwannga amage ulita ole: —Ba du gaite gbadale biale cha alin. Kwian ngle kle, nga me cha alin gerungwa no kwian ulita ole, cha joge duge chi kagdage ene cha ñage gerule ma no kwian ulita ole —Jesu gerudu ene kwian geru jwannga amage ulita ole, kwian geru jwannga agedu Jesu gerudu kare ama ole. ");
INSERT INTO sabNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","12","Ne ngwadi kwian tanre jwligebanga che dolla kote kledu kwian nglea ulitaske, kwian jwligebanga e bai kaire chku Jesudi dolla kwian e gbu mo jongnagwa skute dba Jesu gwangnagu, dolla kwian tale kwian ta gbu gerule Jesu ole: —¡Uñale chage ulia ba Chube Kirolla! Dolla kwian tale kwian ta gbu gerule ene, Jesu me tadukalin dolla Jesu kalla itenga Jesu Chube Kirolla, malen Jesu ka bo kiraske dolla ole: —Ba me gerudale kwian na ologe cha Chube Kirolla, joga siere kwiange —Jesu ka bo ene dolla ole dolla ka chite Jesu ngeru, dolla jo siere kwiange. ");
INSERT INTO sabNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Bigire Jesu jo jwichuga giti, Jesu kwian tanre bai ama tadukalin joge ama ole Jesu kwian e ulita kadu chie ama nate jwichuga giti. Kwian e ulita mo litu ule Jesu ole, ");
INSERT INTO sabNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","gire kwian eske ulita Jesu kwian gdataboko giti gdaboke gau chage diali ama ole ama gatedi, Jesu kwian e amaña gau kagadale Jesu gerua dbe kwian nage, kaire Jesu kira ketu kwian ege dolla kagagda siere kwian jwligebangage. Jesu kwian mneite e ka gbu kwian Jesu gerua ketanga. ");
INSERT INTO sabNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Kwian Jesu gerua ketanga gdataboko giti gdaboke ama ulita kada ene: Simón (kaire Jesu ama ka gbu Pedro), ");
INSERT INTO sabNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Santiago (ama Zebedeo kirolla), Juan (ama kaire Zebedeo kirolla ama Santiago daballa, Zebedeo kirolla boke e Jesu ama ka gbu Boanerges, geru e kle gerule ama boke kerua enusulindra kare, onbre boke e gerule kweri kiraske kwian ulita ole malen Jesu ama boke ka gbu ene Boanerges), ");
INSERT INTO sabNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrés, Felipe, Bartolomé, Mateo, Tomás, Santiago (Santiago ai Alfeo kirolla), Tadeo, Simón (Simón ai kira batanga mo jwia gdale), ");
INSERT INTO sabNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas-Iscariote (bigwa ama jwlitedu Jesu dollale Jesu ketu gwaleda). Jesu kwian e ulita gdataboko giti gdaboke gau ama gerua ketangale kwian nage. ");
INSERT INTO sabNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Bigire Jesu joni gudegu ule kwian geru jwannga amage gdataboko giti gdaboke ole. Ama jo chkeni gwa ama kledu toi ngwadige gire kwian tanre mo litu nakwaite Jesudi, malen ni Jesu ni geru jwannga amage ñadu blire kwian tanreske. ");
INSERT INTO sabNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","E suiale kledu boi ene diali Jesu ole Jesu kle age tanre no kwian ulita alin kwian chudaboi ni ama kle tañachuge bligda gute giti. Kwian gweale gwagedu Jesudi toi ene gire ama gerudu Jesu giti: “Jesu kle chage kwian jwligebanga kare me kle mo manade no kwian ulita mo manade kare.” Kwian gweale gerudu ene Jesu giti, geru e chku uñale Jesu bitallanuge malen ama ulita jo Jesu jwen nate Jesu dbe ama ulita kle toi ngwadi. ");
INSERT INTO sabNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Jesu bitalla bebi joge chke Jesu kledu ngwadige, gire kwian daba tkanga tangle Moisés chadalla giti mneite nu chieba una Jerusalénge gerudu Jesudi: —Jesu kle chage age ulita Satanás kirallaske, Satanás dolla ulita chugagwalla kweri, ama kle kira kete Jesuge malen Jesu ñage dolla kage siere kwiange, dolla kle Jesu kerua gai dage. ");
INSERT INTO sabNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Kwian daba tkanga tangle Moisés chadalla giti gerudu ene me no Jesudi, Jesuge uñale kwian kle gerule me no amadi, Jesu kwian e ulita kadu mo gitigu gire gerudu ama ole: —Sugedale ba ulitage kwian agenga Satanás kiralla giti me kle dolla chugagwalla Satanás chudaboangalla kage siere kwiange Satanás me ta agekalin me no ene mo chudaboangalla ole. Satanás takalin mo chudaboangalla ulita chege age kwian tale kwian gbe age me no Satanás takalin kare. ");
INSERT INTO sabNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Cha geru ñachuge bage e giti: Kwian chugagwalla nga gdaitemu mo tke dole kwian ulita kle toi nga amañage ole, ama kwian ulita gbe kira bate modi ongoru ongoru, ene bdagli kwian be mo gweda ulita, chugagwalla be chege gballa ama mi chege kiraske. ");
INSERT INTO sabNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kaire kwian toi u gbaitre alinge kira bate modi mo bitalla gwa ole ulita, kwian ulita u ege be boi tanre daga ngwale, ene bdagli kwian ulita be joge toi sugekare gdaite gdaite gire kwian u mauña be chege toi gballa ama mi chege kiraske ama gdaitre alin chudaboanga me. ");
INSERT INTO sabNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","E kare ene dolla chugagwalla Satanás mo tke dole mo chudaboangalla ole mo gbe kira bate modi daba kage siere kwiange, dolla Satanás age ene mo chudaboangalla ole ama mi chege kiraske kwian gbanga age me no Chube dollale. ");
INSERT INTO sabNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Jesu gerudu ene gire Jesu geru na ñachugu kwiange kwian boke giti, kwian gdaite kirachkedale kwian gdaitedi, Jesu gerudu: —Kwian gdaite ta jogekalin gwa onbre kiraske ullage skwe boi lle ulitage onbre e ngeru, kwian skwe boanga e chegedale ma kiraske onbre lle mauñage ene kwian skwe boanga ñage onbre lle mauña gai ko luge kejre, ene kwian skwe boanga ñage lle ulita dbe lle mauña ngeru ama takalin kare. Agwa skwe boanga me kira molen lle mauña ko luge, ama me ñage skwe boi lle mauña ngeru. E kare ene Satanás kiraske tanre agwa cha ma kiraske dolla chugagwalla Satanáge, Chube kiralla giti cha kirachke diali Satanádi, cha dolla Satanás chudaboangalla kage siere kwiange. ");
INSERT INTO sabNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Cha gerule ulia ba ulita ole, ba cha keruchuge no, kwian age me no kaire gerule me no cha dollale Chube dollale, gire bigwa kwian e mo ta blite Chube ole cha ole, kwian ene agedu me no ulita kaire gerudu me no ulita Chube dollale cha dollale Chube talla mlienga ulita Chube me tañachuge dare kwian e agedu me no kaire gerudu me no giti. ");
INSERT INTO sabNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Agwa kwian bai kaire gerule cha kle age dolla Satanás kiralla giti, kwian ene kle gerule me no Chube Oña dollale Chube me kwian gerule me no ene talla mlienga dale, kwian ene chege jiske tanre Chube gwa giti diali ama gerudu me no Chube Oña dollale kbiale —Jesu gerudu ene ulita kwian daba tkanga tangle Moisés chadalla giti ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Kwian daba tkanga tangle Moisés chadalla giti kledu gerule Jesudi Jesu kle age ulita dolla Satanás kiralla giti. Kwian kledu gerule ene Jesudi agwa ulia Jesu kledu age ulita Chube Oña kiralla giti, malen Jesu gerudu kiraske kwian ole kwian kledu gerule me no Chube Oña dollale giti. ");
INSERT INTO sabNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jesu kledu gerule ene kwian daba tkanga tangle Moisés chadalla giti ole gire Jesu chebia kaire Jesu daballa ulita chku Jesu kle ngwadige Jesu jwen nate. Jesu chebia Jesu daballa ulita chegu manade goga tangle gire ama geru kagu Jesu alin kwian gweale ole chiga Jesu kle ngwadige. ");
INSERT INTO sabNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Kwian tanre kledu toiba dba Jesudi tangle gire kwian geru dbanga chku Jesudi ama gerudu Jesu ole: —Ba chebia ba daballa kle goga tangle ba jinade nate, ama takalin gerule ba ole. ");
INSERT INTO sabNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Gire Jesu gerudu kwian ole: —Cha be gerule ba ole chema ulia cha chebia chema ulia cha daballa. ");
INSERT INTO sabNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ama gerudu ene gire ama tienduda modi tangle kwian ulita kledu toiba dba Jesudi tangle Jesu keruchuge, kwian e ulita giti Jesu gerudu: —Kwian ai ulita kle cha ole cha keruchuge, kwian ai ulita cha chebia kare cha daballa kare. ");
INSERT INTO sabNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Kwian bai kaire ulita cha keruchuge age cha Ñenua Chube takalin kare, kwian ene cha daballa kare cha ibotea kare cha chebia kare, ama cha bitallanu ulia Chube giti, cha no no ama ulita ole —Jesu gerudu ene kwian ulita kle mo ta gbe age Chube takalin kare giti. ");
INSERT INTO sabNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesu joni nakwaite chibita kagda giti kwian tke tangle. Kwian litedu tanre Jesudi, nga me chegu Jesu alin toingwa malen Jesu jo chiga du kledu ne ngwadige, Jesu toidu dba du toli, kwian ulita chegu kedagu Jesu keruchuge. ");
INSERT INTO sabNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Gire Jesu geru tanre ñachugu kwiange, ngeru ama geru ñachugu chude giti, ama gerudu kwian ole: ");
INSERT INTO sabNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Cha gerule ba ulita ole chude drennga giti, ba ulita cha keruchuge no cha be gerule ai kare ba ulita ole: Kwian jo chude drennga deage, kwian jo chke deage, ama chude ngle dreunnga kote. ");
INSERT INTO sabNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Kwian e kle chude drennga kote gire chude e gweale jo chke dba jon jegwale, bdada chiu, bdada chude gutu ulita. ");
INSERT INTO sabNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Chude na gweale jo chke dba dbi arale ke giti ngwadi, chude e numachiu blikare, agwa me dbi uda alin malen chude e me sera toiduda dbiske no, ke kle, chude me ñadu sera joge dbiske no. ");
INSERT INTO sabNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Chudenuma chku ngaña agwa ama sera me jo no dbiske, chui jute kote chudenuma junbatu jokeda. ");
INSERT INTO sabNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Chude na jo chke dba drinkin sera tanre ngwadi, chude gwatigu agwa drinkin tigedu ule chudenuma ole, drinkin chudenuma guda, chude me tigedu chude me gbachiu, drinkin kote chude jokeda ulita. ");
INSERT INTO sabNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Agwa chude na jo chke dba dbi no giti, chude e gwatigu no gbachiu no ngle. Chude skute chuia chku gire chude e nu gbachieba ngle, chude bulu gweale gbachiu no chude treinta, chude bulu gweale na gbachiu ngle chude sesenta, chude bulu gweale na gbachiu ngle ngle chude cien bulu gdaitege. ");
INSERT INTO sabNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jesu geru ñachugu ene ulita chude giti gire Jesu gerudu dare kwian ole: —Cha kle geru ai ñachuge ba alin, ba me geru ai keruchuge alin allabi mo ologe, agwa kaire ba ulita mo ta gbadale geru ai gbe gdadi, ba tañachugadale lledale cha kle geru ai chude giti ñachuge ba ulita alin. ");
INSERT INTO sabNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jesu geru ñachugu ene kwian nglea ulita alin gire kwian geru jwannga amage gdataboko giti gdaboke kaire kwian na kle chage Jesu ole geru jwen amage, kwian e ulita mo litu Jesudi sugekare kwian ngleage, geru kadu Jesuge: —¿Ba gerudu giti kwian ole, geru e mine? Me suge cha ulitage mineade ba geru ñachugu kwiange chude giti. ¿Mineade ba me geru gbu chke uñale nate trate kwiange Chube giti? ");
INSERT INTO sabNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Kwian geru jwannga Jesuge geru kadu ene gire Jesu jaindunga ama kalen: —Ba ulita kle cha gerua gai ulia malen Chube kle ba ta gbe chke cha kle gerule giti, ene geru e giti kle suge trate bage kwian bai kaire cha gai ulia mo Chugagwallale kwian ene chege no trate Chube gwa giti. Kwian na me kle cha gerua gai ulia, ama alin cha kle geru ñachuge, kwian geru e keruchuge agwa geru e ulita skwen mnoare amage geru e me suge amage dale. ");
INSERT INTO sabNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Kwian ene gwa giti cha kle lle tanre no dodade agwa ama chege kwian gwagwa me kare, me suge amage cha kle lle e dodade Chube kiralla giti kwian ta gbagda Chube giti. Kaire kwian ene kle cha gerua keruchuge, agwa ama chege kwian olo me kare, geru me suge trate amage cha kle gerule giti. Geru suge amage ama mo ta blite Chube ole, ene Chube kwian ene agedu me no talla mlienga ulita. Agwa kwian ene me ta cha gerua gakalin ulia malen cha gerua me suge amage, ama chege jiske Chube gwa giti —Jesu gerudu ene kwian geru jwannga amage ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Gire Jesu gerudu dare ama chude drennga gerua ñachugu kwian alin giti, Jesu gerudu kwian geru jwannga ole: —¿Geru chude drennga giti cha ñachugu ba alin geru e me suge bage? Geru e me suge bage, ene kaire cha geru na ma mno ñachuge ba alin, geru e mi suge bage kaire. ");
INSERT INTO sabNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ba cha keruchuge no, nege cha geru chude drennga giti gbe chke uñale bage cha gerudu kare giti. Cha gerudu kwian chude dreannga giti kwian e chege salengwli kwian Chube gerua ketanga daba nage kare. ");
INSERT INTO sabNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Kwian gweale kle boi Chube gerua ole salengwli chude jo chke dba jon jegwale kare. Kwian e Chube gerua keruchuge, agwa geru me suge amage trate, bigire che dolla Satanás kwian ta gbe geru e chuge ngwadi me geru e gai ulia jumale. Satanás kle geru jwennga kwian tale salengwli bdada kle chude jwennga kare, ene geru Chubenu ulita jogenga kwian tale. ");
INSERT INTO sabNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","Kwian gweale kle boi Chube gerua ole salengwli chude jo chke dba dbi arale ke giti ngwadi kare. Kwian e Chube gerua keruchuge, ama kle geru e gai blikare nga suga no ole, agwa ama me mo ta gbe ulia Chube ole, ama me kle Chube gerua gai jumale ulia, malen ama tale geru me ñage tige no kiraske salengwli chude me ñage sera joge dbiske ke giti me ñage tige no kare. Kwian e Chube gerua gau agwa me kira ole gwangerugudba geru e gai ulia, ama boi daga ngwale Chube gerua gdale, gire blikare kwian e Chube gerua chuge ngwadi, ama jogeni naskuni chage ngeru kare. ");
INSERT INTO sabNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Kwian na gweale kle boi Chube gerua ole salengwli chude jo chke dba drinkin sera tanre ngwadi kare drinkinnuma tige chude ole ule kare. Kwian e kle Chube gerua keruchuge kle Chube gerua gai ulia agwa me kle mo ta gbe tañachuge diali Chube gerua giti no, ama kle mo ta gbe tañachuge tanre lle ngwale alin giti, ama ta igi jwankalin ngle mau alin kle gwage lle ulitadi ama takalin lle ege mau alin, ama ta agekalin ulita ama takalin kare. Ama kle tañachuge ma ngle lle e kare gitige me kle tañachuge no Chube gerua gitige, malen Chube gerua kle jogenga ama tale, gire ene kwian me kira molen toi no Chube takalin kare ni kwian ñage Chube gerua dbe kwian nage. ");
INSERT INTO sabNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Agwa kwian gweale kle boi Chube gerua ole salengwli chude jo chke dba dbi no giti kare. Kwian e kle Chube gerua keruchuge, Chube gerua kle suge trate amage gire ama mo ta gbe ulia Chube ole Chube gerua gai ulia. Ama kle Chube chuge ngwadi age ama tale Chube takalin kare, ene Chube ama ta gbe chui gbaite gbaite kaire kairege ma ngle Chube gerua giti. Kwian ene mo ta dbe suge no diali Chube gerua kete daba na ulitage daba chudaboi ta gbe chage gwangerugu Chube gerua giti. Kwian Chube gerua ketanga ene giti kwian tanre chke Chube gerua gai ulia salengwli chude joge chke dba dbi no giti gbachie no ngle kare, chude gweale gbachie treinta, na gbachie ma ngle sesenta, na gbachie ngle ngle cien. Ene kaire kwian bai mo ta gbe ulia Chube ole Chube gerua gai ulia diali, kwian ene giti kwian na tanre Chube gerua gai ulia mo tale —Jesu gerudu ene kwian geru jwannga amage ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesu geru na ñachugu kwian alin, Jesu gerudu: —Nege cha geru ñachuge ba ulita alin jichra giti, kwian age jichra ole kare, e kare ene kwian agedale Chube gerua ole. Kwian jichra gwadege me kle un blite kaboge jichra giti ni kle jichra gbe ankwa gwaru nga gbagda chra, kwian me age ene jichra ole. Kwian jichra gwadege, kwian jichra gbe ngaña nga ngwale giti ene jichra chra chratigenga ulita gwa tangle ene kwian ulita ten lle ulitadi jichra chra giti nga jereske, jichra chrage lle ulita me chege skwlenre kwian gwage. ");
INSERT INTO sabNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ene kaire Chube gerua me chege skwlenre, kwian Chube gerua ganga giti geru e be chke uñale kwian nage, kwian Chube gerua ganga me ta chegedale skwlenre Chube gerua ole kwianske. ");
INSERT INTO sabNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Cha kle geru ai ñachuge ba alin, ba me geru ai keruchuge alin allabi mo ologe, agwa kaire ba ulita mo ta gbadale geru ai gbe gdadi, ba tañachugadale lledale cha kle geru ai jichra giti ñachuge ba ulita alin. ");
INSERT INTO sabNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jesu geru ñachugu ene kwian alin gire Jesu gerudu dare: —Ba mo ta gbadale tañachuge trate Chube gerua ba kle keruchuge chage giti, kaire ba mo ta gbadale geru e gbe gdadi age Chube takalin kare. Ba me mo ta gbe Chube gerua gai ulia kiraske age Chube takalin kare gire Chube gerua mi suge trate bage dale. Ba Chube gerua gbe gdadi batre Chube be mo gerua na gbe suge bage. Ba Chube gerua gbe gdadi ba age cha kle gerule kare ba ole ene Chube mo gerua gbe suge ma no trate bage. ");
INSERT INTO sabNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kwian bai kaire kle Chube gerua gai ulia Chube gerua manade no mo tale, kwian ene mi ta jogenga Chube geruage, kaire Chube be kwian ene ta gbe dare Chube gerua giti. Agwa kwian bai kaire me kle mo ta gbe Chube gerua gai ulia me kle mo ta gbe tañachuge Chube gerua giti kaire me kle age Chube gerua kle gbaba kare, kwian ene be ta jogenga Chube geruage ulita ama be chege kwian me Chube gerua keruchugaba kare. ");
INSERT INTO sabNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesu geru na ñachugu kwian alin chude giti, ama gerudu: —Cha be geru na ñachuge ba ulita alin, ba cha keruchuge no. Geru ai giti sugedale bage cha kle ba ta gbe suge Chube alin allabi kle kwian ta gbe Chube gerua gai ulia Chube gai mo Chugagwallale. Cha geru kete bage ene: Kwian chude skie ulita deage gire ama jogeni gudegu. ");
INSERT INTO sabNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Kwian me kle manade deage chude chudaboi tige no, ngajrege ulita sbali kwian kle gbe ngajrege gwa, ngajudi ama kle lle na boi, agwa chude ama skiaba deage kle gwatige no kle tige no gballa. Ulia ni uñale kwian chude skiangage chude e kle tige mine. ");
INSERT INTO sabNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Dbi gballa kle chude gbe tige. Chude kle gwatige kle gachie gire kle skachie, ska jegwale kle gbachie no ulita. ");
INSERT INTO sabNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Chudegba kle joge dabe, gire kwian chude skiangage chke uñale chude skute chuia chkeba, ene kwian kle joge deage chude skute kle chude lite ole ulita —Jesu geru ñachugu ene chude giti kwian alin kwian ta gbagda kwian Chube gai mo Chugagwallale giti. ");
INSERT INTO sabNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","31","Jesu geru ñachugu kwian ole mostaza chudea giti: —Cha geru na ñachuge ba ulita alin, geru ai giti sugedale bage nege kwian bedreare kle mo ta gbe ulia Chube gerua gai jumale cha kle gerule giti, agwa bdagli kwian ngle be Chube gerua gai ulia be Chube gai mo Chugagwallale, e salengwli kle boi mostaza chudea ole kare. Mostaza chudea ma soli jalin chude na ulitage skiadale dbige. ");
INSERT INTO sabNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Agwa mostaza chudea skiakle dbige gire chude e kle tige kle chege gli kweri kweri ngaña. Mostaza glia kle nangachie kweri kweri, gire bdada ngle ñage ugara gbe gli e nanga jegwale ulita toingwa. E kare ene kwian bai Chube gerua gai ulia, kwian e Chube gerua trage kwian na ole ene geru e chke uñale kwian na tanrege, gire bdagli kwian tanre be Chube gerua gai ulia be Chube gai mo Chugagwallale salengwli mostaza chudea soli tige joge kweri nanga tanre molen kare. ");
INSERT INTO sabNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesu geru ngle ai kare ñachugu kwian nglea alin ñage suge kwiange batre. Ulia Jesu me kledu geru trage geru ngwale alin giti kwian gweale tañachugu kare agwa geru ai giti Jesu kledu kwian tke tangle Chube gerua giti. ");
INSERT INTO sabNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Jesu diali geru ñachugu ene kwian alin lle gweale giti kwian ngle ta gbagda Chube giti, agwa Jesu chegu gballa sugekare ule kwian geru jwannga amage ole gire ama geru e tragu ama ole geru e kle gerule llema llema giti ulita. ");
INSERT INTO sabNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","36","Chui e amañage ngabi Jesu kledu toiba dba du toli kwian nglea tke tangle Chube gerua giti, gire Jesu gerudu kwian geru jwannga amage gdataboko giti gdaboke ole: —Ale chibita kagda giti chkagu. Jesu gerudu ene gire kwian geru jwannga ulita jo Jesu ole duge kwian nglea ulita chugu ngwadi chi kagda giti, kaire kwian na jo du nage du Jesu jóge gatedi. ");
INSERT INTO sabNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","Du kledu chage anleda chiga giti Jesu kledu gbe mo chuga gbaba chugagda giti du skugda ngnagu, gire mle tirare kweri kweri chku dba kiraske, mle chi gbu chite tanre, chi skwendu bdugu mlege chi jo chiga du toli, du kledu chke ete chi kote. Gire kwian geru jwannga Jesu gau gdate ta kennga ole, ama gerudu: —¡Cha tkanga tangle! ¡Chkede bduge cha chudaboi! ¡Che ulita be joge chiske duge llagli, che be unjoge ba kle gbeba jabale gire! ");
INSERT INTO sabNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Kwian geru jwannga gerudu ene Jesuge gire Jesu chku bduge mo gbu gdate, ama gerudu mle ole: —¡Chegede kamne, me tiennga dare! Kaire Jesu gerudu chi ole: —¡Klede ngwedi! Jesu gerudu ene gire sugeti ngwale mle jo tangle me tiunnga dare kaire chi chegu ngwedi ulita me chitedu dare. ");
INSERT INTO sabNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ulita chegu ngwedi gire Jesu ka bo kwian geru jwannga amage ulita ole: —¿Mineade ba ulita ta kennga tanre mledi? ¿Ba me cha gai ulia cha ñage ba manade nga tirareske? ");
INSERT INTO sabNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Jesu gerudu ene gire kwian geru jwannga ulita ta chegu kwachie tanre, ama ulita geru kadu moge ongoru ongoru: —¿Kwian ai mine, ade mle kaire chi kle ama kerua gai dage ama kle gerule kare? —kwian geru jwannga geru kadu moge ene Jesu giti. ");
INSERT INTO sabNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jesu jo chage dare duge chiga giti kwian geru jwannga amage ulita ole, Jesu jo chke chi kagda giti chkagu nga ka jwankle Gadarage. ");
INSERT INTO sabNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","3","Ne ngwadi Jesu chiu dbige duge ule geru jwannga amage ole gire kwian onbre jwligebanga che dolla kote chku ten Jesu ngwange. Kwian jwligebanga e kledu toi kwian jaba ogakle keugage ngwadi, ama kiraske tanre che dolla kiralla giti ni kwian gdaite ñadu kwian jwligebanga e lugeda hierrogda dodabale cadenale giti. ");
INSERT INTO sabNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Kwian kle no kle kwian jwligebanga e ska gbe diali agwa blikare che dolla kle kwian jwligebanga kira gbe kwian jwligebanga kle cadena datenga mau giti kle kige, ama kiraske tanre, malen ama diali toidu gbale, kwian me ñadu ama gai manadale skage. ");
INSERT INTO sabNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Kwian jwligebanga e diali kledu chage ngajudi ngajrege jwichuga jegwale kaire kwian jaba ogakle keugage ngwadi, ama kledu ngaute kweri kledu mo lendege jere jere kechugage diali. ");
INSERT INTO sabNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","8","Kwian jwligebanga tendu Jesu ngwange gwagedu Jesudi chie bate, ama jo jrite Jesu ngnagu, gire Jesu gerudu kiraske dolla kle kwian e tale ole: —¡Ba me no me no, joga siere onbre aige, onbre ai chuge ngwadi sugekare! Jesu gerudu ene dolla ole gire dolla kwian jwligebanga gbu jongnagwa skute dba Jesudi Jesu gagda dage gire dolla kwian gbu gerule kweri Jesu ole: —Uñale chage ba Jesu, ba Chube kweri kiraske Kirolla. ¿Lledale ba chiu cha nate nga aige? Cha ulita gerule ba ole Chube gwa giti, ba me age me no cha ole cha gbe boi daga ngwale sugekare kwian aige, ma no ba cha chuge ngwadi toi kwian ai tale. ");
INSERT INTO sabNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesu geru kadu dolla kle chage kwian olege: —¿Ba kada mine? Dolla jaindunga Jesu kalen: —Cha kada Ngleare. Cha bitalla tanre kle toi ule cha ole kwian ai tale malen cha ulita kada Ngleare. ");
INSERT INTO sabNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Dolla chegu gerule tanre Jesu ole: —Ba tai dage cha ulitage, ba me cha ulita kage nga ji chugangwage, ba cha kage toi nga gwealege ngmadi aini. ");
INSERT INTO sabNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Jesu kledu gerule dolla ole ngwadi kodi jwichuga giti chunchi tanre kledu chage jwichugage blire. ");
INSERT INTO sabNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Dolla ulita kledu kwian jwligebanga gbe gerule, ama ulita gerudu Jesu ole: —Ba cha ulita kage chunchi kle ngwadi, ene cha ulita ñage toi no chunchi tale. ");
INSERT INTO sabNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesu gerudu dolla ole: —¡Joga siere onbre aige, joga toi chunchidi ulita! Jesu gerudu ene dolla ole gire dolla ulita jo siere blike onbrege, dolla ulita jo chunchi ngle ngwadi toi chunchi tale. Chunchi ngle dos mil kledu nga ege, dolla jo chke chunchi e ulita tale gire chunchi ulita jo jrite jo kegdege dolla kote, chunchi ulita jwatedunga kegdege chunchi jo chiske, chunchi dos mil ulita unjo jokeda chi kote dolla kbiale. ");
INSERT INTO sabNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Kwian chunchi mananga ulita gwagedu chunchidi boi ene ulita gire ama ulita jo jrite jo chunchi gerua kete kwian ngleage unaske kaire kwian kle toi jon jegwalege chunchi mananga geru ketu. Kwian ulita chunchi mananga gerua keruchugu, kwian e jo tienda chunchi boidu giti chunchi tanege. ");
INSERT INTO sabNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Gire kwian ulita jo tienda Jesudi ama jo chke Jesu kledu ngwadi, kwian ulita gwagedu kwian onbre nu jwligebanga nu jogeba chkeni noni, onbre e kledu toiba dba ngwedi mo ngama tkaba no. Kwian ulita gwagedu ene kwian onbre Jesu nu dodabadi, gire kwian ulita kwachiu tanre Jesu ngeru. ");
INSERT INTO sabNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Kwian ulita bai gwagedu Jesudi mo gwagwa giti Jesu dolla kagu siere onbre jwligebanga ege gire, kwian e ulita geru e ulita tragu kwian chiu unaskege ole kwian jon jegwalege ole, kwian geru tragu kwian na ulita ole Jesu dolla kagu siere onbre jwligebangage giti. ");
INSERT INTO sabNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Gire kwian ulita toinga nga Gadarage mo ta gbu gerule Jesu ole: —Cha me takalin ba chege dare cha kle toi ngwadi nga aige. ¡Joga siere nga aige, ba me chegedale age ene dare aini nga aige! ");
INSERT INTO sabNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Kwian gerudu ene Jesu ole gire Jesu joni naskuni du toli, kwian nu jogeba chkeni noni jo Jesu nate gerudu Jesu ole: —Ba cha dbe ule cha ta jogekalin ule ba ole nga baini kairege ba be joge ngwadi cha be chage ule. ");
INSERT INTO sabNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jesu gerudu ama ole: —Ba me ñage joge ule cha ole, ba jogedaleni ba bitalla kle toi ngwadi geru trage kwian ulita ole Chube ba Chugagwalla agedu giti ba alin. Ba ogadu dolla kote Chube taidu dage bage, Chube ba dodadu ba geru e ketadale ba bitalla ulitage. ");
INSERT INTO sabNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Jesu gerudu ene onbre e ole gire onbre e cheguda ama jo una ulitage nga kada Decápolige gerule kwian ulita ole Jesu ama dodadu giti, kwian ulita bai kaire onbre e keruchugu gerule Chube agedu giti ama alin, kwian e ulita chegu tañachuge no tanre Chube agedu giti onbre e alin. ");
INSERT INTO sabNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesu joni naskuni duge chi kagda giti ongoru ule kwian geru jwannga amage ulita ole, ama ulita jo chkeni llani gire kwian tanre litedu Jesudi Jesu chegu chi kagda giti kwian tke tangle Chube giti. ");
INSERT INTO sabNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Jesu kle kwian ulita tke tangle gire onbre gdaite kwian israelita chugagwalla u mo litangwa Chube gerua jwanngwage chku Jesu kle ngwadi, onbre e kada Jairo ama chku Jesudi gire ama jongnagwa skutu dba Jesu gwangnagu mo chudaboi kade Jesuge, ");
INSERT INTO sabNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Jairo gerudu Jesu ole: —Ba cha chudaboi, cha jian oga jabale jabale chege bedre ama ngeru ama jogekeda. Bai blike cha ullage tienda cha jian ogadi, ba ko gbe cha jian oga giti ene ama mi jogekeda, uñale chage ba kiralla giti ama be joge chkeni noni ama chege gwade. ");
INSERT INTO sabNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jesu Jairo keruchugu gire Jesu jo Jairo ole Jairo ulla ngnagu. Kwian tanre jo Jesu ole llagli Jesu gatedi, kwian tanre jo chage moge kejre Jesu nate Jesu ngeru kaire Jesudi tangle chage ule Jesu ole. ");
INSERT INTO sabNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Jesu kledu chage kwian tanre ole Jairo ulla ngnagu gire muinga oga daige sbali chku chage Jesu nate kwian ngleaske. Chura gdataboko giti gdaboke muinga e kledu toi daige diali chui ulita oga jabale dai gitige ole. ");
INSERT INTO sabNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Muinga e nu jogeba kwian mo dodanga tanre ngwadi, ama nu igi maunu ulita ketaba mo dodade giti kwian mo dodangage, agwa ni ama jo chkeni noni, ngwale ama igi ngle ketu mo dodade giti agwa ama kledu chage oga daige ma jabale diali. ");
INSERT INTO sabNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","29","Muinga ege geru chku uñale Jesu kledu chage kwianske gire muinga e jo chage Jesu nate kwian ngleaske. Muinga e jo chke kodi Jesudi, ama tañachugu mo tale: “Uñale chage cha ko chuge Jesu ñometralladi alin allabi gire ene cha be joge chkeni noni Jesu kiralla giti.” Muinga tañachugu ene gire ama ko chugu Jesu ñometralladi gire sugeti allabi ama me chegu toi oga dare daige ama kledu toi sbali kare, blike ama sugedu moge ama jo chkeni noni trate ama kledu ogage, ama jo chkeni mo ta gbe Jesu ñometralla chugedi giti, ene muinga e chegu no trate. ");
INSERT INTO sabNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesuge chku uñale ama kiralla giti kwian gweale oga jo chkeni, Jesuge sugedu moge ene, gire Jesu tiunda mo nate, ama geru kadu kwian ulita kledu ne ngwadige: —¿Chema ko chugu cha ñometralladi? ");
INSERT INTO sabNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Kwian geru jwannga Jesuge jaindunga Jesu kalen: —Kwian tanre kle chage ba nate ba ngeru badi tangle ba gate kejre moske, ¿mineade ba geru kade chema kle ba ñometralla chugedi? ");
INSERT INTO sabNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Kwian geru jwannga gerudu ene Jesu ole, agwa Jesuge uñadu ulia kwian gweale oga ama chugudi jo chkeni no, malen ama kledu tienda mo nate dba kwian oga jo chkeni nate chema ama ñometralla chugudi. ");
INSERT INTO sabNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Uñadu muingage Jesu ama dodadu, gire muinga e jo Jesu ngnagu ama mo jongnagwa skutu dba Jesudi Jesu gagda dage, ama kennga tanre jirenga trate jegwale chru ole Jesu ngeru, muinga gerudu Jesu ole: —Cha chagedu sbali oga tanre daige ole chui ulita, malen cha chiu ba nate cha mo ta gbu ko chuge ba ñometralladi cha tañachugu ene cha be joge chkeni noni, cha mo ta gbu age ene gire nege cha kle noni ba cha dodadu. ");
INSERT INTO sabNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Muinga gerudu ene Jesu ole gire Jesu gerudu ama ole: —Ba mo ta gbu cha gai ulia malen e giti cha ba dodadu, nege ba jo chkeni noni trate. Jogani nga suga no ole me tañachuge dare ba jingmea giti. ");
INSERT INTO sabNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesu kle gerule ene muinga ole gire kwian gweale chiu Jairo ullage chku geru jige Jairoge jonke Jairo jian giti, kwian e ulita gerudu: —Ba kwian tkanga tangle chuge ngwadi lle na boi, ngwale ba kle ama dbe mo ullage, ba jian me chegu. ");
INSERT INTO sabNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Kwian e ulita chku geru jige ene Jairoge, agwa Jesu me kwian e kerua talladu, ama gerudu Jairo ole: —Ba me ta dbe kennga ba jian giti, ba me mo ta gbe olire ba jian nate, ba mo ta gbe cha gai ulia cha ñage ba jian dodade. ");
INSERT INTO sabNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jesu gerudu ene Jairo ole, gire Jesu me kwian na chugu ngwadi joge dare ule ama gatedi, agwa Jesu kwian geru jwannga amage kada Pedro kaire Santiago kaire Santiago daballa kada Juan du ule mo ole llagli Jairo ngwadi. ");
INSERT INTO sabNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jesu jo chke ugakage Jairo kle toi ngwadige, gire Jesu gwagedu kwian tanredi olire, kwian ulita kledu sui jwennga kirogwa muire jabadi. ");
INSERT INTO sabNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jesu jo chke gwa Jairo ullage, ama gerudu kwian ole: —¿Mineade ba ulita kle mo ta dbe olire kirogwa nate? Ba me olire dare, ulia kirogwa muire me jogebakeda dale, agwa ama kle gbe alin allabi. ");
INSERT INTO sabNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Jesu gerudu ene kwian ole gire kwian gidedu Jesudi Jesu gerudu giti. Kwian ulita kledu gwa Jesu kwian e ulita kagu siere, gire Jesu kwian geru jwannga gdamai kle Jesu gatedi kaire kirogwa muire ñenua kirogwa muire chebia, Jesu kwian e alin du ule kirogwa muire jaba kledu ngwadi. ");
INSERT INTO sabNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jesu kirogwa muire jaba gau koge, Jesu gerudu jaba ole mo kwirale: —Talita, cum —geru e gerule: “Kirogwa muire, cha gerule ba ole, ¡chkede bduge!” ");
INSERT INTO sabNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","43","Jesu gerudu ene gire blike kirogwa muire jaba chkuni gwade, kirogwa chku gdate chagedu mo ñenua mo chebia gwa giti. Kirogwa muire ñenua, chebia gwagedu mo jian chkuni gwadenidi gire ama chegu tañachuge tanre nga suga no ole Jesu agedu giti, ama gerudu no modi Jesu giti: —¡Ulia Jesu kiraske, ama agedu no no che alin, ama che jian jaba gbuni gwade! Gire Jesu gerudu kirogwa muire ñenua ole chebia ole: —Cha ba jian jaba gbuni gwade giti ba me geru e ketadale kwian nage, ba geru e gatadale mo tale. Nege ba bligda kete ba jiange gutadale ama kira gbagda. Jesu kirogwa muire jaba gbuni gwade ene, kirogwa muire ege chura gdataboko giti gdaboke chkeba. ");
INSERT INTO sabNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesu joni mo jwiage una ama manadre ngwadi ule kwian geru jwannga amage ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Jesu jo chkeni una ege gire kwian israelita undege chuiage Jesu jo u mo litangwa Chube gerua jwanngwage kwian tke tangle Chube gerua giti. Kwian tanre kledu u ege Jesu keruchuge gerule Chube giti, kwian e ulita chegu tañachuge tanre Jesudi, kwian gerudu modi ongoru ongoru Jesu giti, ama gerudu: —Ama kle gerule no tanre Chube giti, ¿ama geru e ulita jun baini? Ama ta ngle molen, ¿chema ama tku tangle tachke ngle ene? Kaire kwian oga me boale dodadale ama kle ñage kwian oga tanre ene dodade, ama kle age tanre kwian ngwale me ñage age kare. ");
INSERT INTO sabNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Agwa ama me che tigemanalla? ¿Ama me kwian glidrega dodanga lle tanrere? ¿Kaire ama me María kirolla? Che ama daballa ulita uñe, ¿ama daballa me Santiago kaire José kaire Judas kaire Simón? ¿Kaire ama ibotea ulita me kle toi cheske kaire agwe? ¿Agwa gire mineade geru ai ulita Chube giti kle chke uñale amage? Kwian ulita gerudu ene Jesudige malen kwian me jaindu Jesu gerua gai ulia, sugedu kwiange Jesu kwian ngwale kare. ");
INSERT INTO sabNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesu gerudu kwian e ulita ole: —Cha gerule ba ole, kwian Chube gerua ketanga kle joge nga baini kairege kwian tke tangle Chube gerua giti, kwian nga emu kle kwian Chube gerua ketanga keruchuge kle ama gerua gai dage. Agwa kwian Chube gerua ketanga jogeni mo bitallaske mo jwiage ama manadre ngwadi, kwian me ama gai ngwange no, ni ama bitalla gdaite ama gai kwian Chube gerua ketanga ulia, kwian me ama gerua gai dage ni kwian ama keruchugakalin —Jesu gerudu ene kwian ama jwiamu ole. ");
INSERT INTO sabNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Kwian Jesu jwiage me Jesu gau ngwange no me Jesu gerua gau ulia, malen Jesu me kwian tanre oga dodadu ni lle na daga ngwale no tanre dodadu kwian nga ege alin, Jesu kwian bedreare alin oga dodadu, ama mo ko gbu kwian oga e giti gire kwian jo chkeni noni ulita. ");
INSERT INTO sabNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jesu chegu tañachuge tanre kwian ama jwiamu giti mineade kwian me ta mo ta gbakalin ama gerua gai ulia. Jesu jo chage kwian geru jwannga amage ulita ole una kaire kairege una Nazaret giti tangle kwian tke tangle Chube gerua giti. ");
INSERT INTO sabNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jesu kwian geru jwannga amage gdataboko giti gdaboke kadu mo gitigu, Jesu mo kiralla ketu ama ulitage dolla kagagda siere kwian jwligebanga dolla kotege, gire Jesu kwian geru jwannga amage kagu gdaboke kaire kaire modi nga ulitage Chube gerua Jesu giti kete kwian nage. ");
INSERT INTO sabNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Kwian geru jwannga ulita bebi joge Chube gerua dbe kwiange, gire Jesu ama ulita ta gbu ama agedale giti ama joge chage geru dbe gire, Jesu gerudu ama ulita ole: —Ba joge chage Chube gerua dbe gire ba jogedale kole ba me lle gweale dbe mo alin, ba ñage glita gdaitre alin dbe chagegda. Ba me gde teru dbangwa dbe ni ba bligda dbe mo liullale jonkare ni ba igi dbe mo alin lle gigagda. ");
INSERT INTO sabNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ba joge ñometra modi alinske kaire ba zapato dbe modi alin, ba me zapato na ni ñometra na dbe mo ole llagli. ");
INSERT INTO sabNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Una ulitage baini kaire ba joge chke ngwadi ba u gbaitre alin gai toingwa, ba chege toi u e mauña ole ba kle Chube gerua dbe kwian una emuske gire. Ba joge dare una nage, ba age ene una kaire kairege baini kaire ba joge chke ngwadi. ");
INSERT INTO sabNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Una ulitage baini kaire ba joge chke ngwadi, una e gwealege kwian me ba gai ngwange no ni kwian ta ba keruchugakalin gerule Chube gerua giti, ba me tallade, ba jogedale siere una ege, ba me chege geru dbe kwian una emuske, ba joge siere una ege ba dbi mnuña skiennga mo serage kwian ene gwa giti, ene be suge kwian una emuge ama chege jiske tanre Chube gwa giti me ba gai ngwange no gdale Chube gerua giti. ");
INSERT INTO sabNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jesu gerudu ene kwian geru jwannga ulita ole ama ta gbagda gire kwian geru jwannga ulita jo chage gdaboke kaire kaire modi una kaire kairege Chube gerua trage kwian na ole, ama gerudu kwian ulita ole: —Ba ulita Chube gerua gadale ulia, ba ulita mo ta blitadale Chube ole, ba age me no ulita chugadale ngwadi me chage age me no dare. ");
INSERT INTO sabNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Kwian geru jwannga Jesuge chagedu una kaire kairege gerule ene kwian ulita ole. Kaire kwian geru jwannga dolla kagu siere kwian tanre jwligebanga dolla kotege, kaire ama kwian tanre oga dodadu, ama lle kinre gbu kwian oga chuga giti gire kwian oga jo chkeni noni. ");
INSERT INTO sabNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Chube gerua Jesu giti kledu chage nga ulitage, e suiale kwian kada Herodes ama nga kwian nga Galileamu chugagwalla, Herodes geru e Jesu giti keruchugu Jesu kle age giti, geru chku uñale Herodege kwian gweale kle gerule Jesu giti ene: —Juan-Bautista jogebakeda amaña chkuni gwadeni, malen nege ama kle age tanre no mo kiralla giti kwian ulita gwa giti. ");
INSERT INTO sabNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Kaire kwian na kledu gerule Jesu giti: —Onbre e kwian Chube gerua ketanga unsuialin tangle kada Elías amaña chkuni. Kaire kwian na kledu gerule Jesu giti: —Onbre e kle age tanre no kiraske kwian gwa giti salengwli kwian Chube gerua ketanga unsuialin tangle kledu age kare Chube ama ta gbu age kare. ");
INSERT INTO sabNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Geru ai ulita Jesu giti chku uñale chugagwalla rey Herodege, Herodes gerudu: —Cha kwian gbu Juan-Bautista chuga tkenga, agwa nege Juan-Bautista nu jogebakeda amaña chkuni gwade —chugagwalla rey Herodes gerudu ene ta kennga ole. ");
INSERT INTO sabNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Ulia Herodes nu Juan-Bautista gbaba boi daga ngwale jogekeda chuia jo tangle sbali. Juan-Bautista giti boidu ulita ai kare: Herodes mo jun mo daballanu Felipe muira kada Herodías ole, e giti Juan-Bautista gerudu Herodege: “Chube gerua kle degaba gerule ba me ñage chage mo daballa muira ole mo muira kare, e giti ba jiske tanre Chube gwa giti.” Juan-Bautista gerudu ene Herodes ole Herodes ñanea Herodías giti, malen muinga Herodías jainchku tanre Juan-Bautistadi Juan-Bautista gerudu gdale, Herodías tadu Juan-Bautista gwakalinda, agwa me chku boale amage ama Juan-Bautista gweda mine. Herodes kendunga Juan-Bautista gbe boi daga ngwale gweda, ulia Herodes Juan-Bautista gau dage, Herodege uñadu Juan-Bautista kwian Chubenu no trate me jiske Chube gwa giti, Herodege me sugedu ulita Juan-Bautista kle gerule giti agwa ama diali tadu Juan-Bautista keruchugakalin ta no ole gerule Chube giti. Herodes Juan-Bautista manadu skage gwade Herodías ngeru, Herodías tadu Juan-Bautista gwakalinda Juan-Bautista gerudu giti agwa me chku boale Herodíage age mine tra no Juan-Bautista ole gire ama ta chege no. ");
INSERT INTO sabNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Chui gbaitege chku uñale Herodíage ama ñage Juan-Bautista gweda mine. Chura chku chugagwalla rey Herodege gire ama mo skatemanalla tanre kadu blire ama ole ama medunga chebia kote chuia ollade. Herodes kwian tanre kadu, kwian Herodes chudaboanga ngle Herodes nu gbaba daba chugagwallale kaire guardia donga chugagwalla ngle kaire kwian na kweri nga Galileage ngle, Herodes kwian ene ulita kadu mo chuia ollade. ");
INSERT INTO sabNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Kwian chui olladanga ulita kledu blire gire Herodías jian ama kirogwa muire biale jo chke Herodes kledu ngwadi ama skatemanalla ole chui ollade, Herodías jian e skwendu gdate kwian ulita gwa giti, gire skwendu noare Herodege kaire Herodes skatemanalla ulitage Herodías jian kledu skwen gdate giti, Herodes gerudu ama jingdalla ole nga suga no ole: —Nga suga no chadi ba skwendu gdate noare cha ulita gwa giti. Ba ñage lle ba takalinge kade chage cha be kete bage. ");
INSERT INTO sabNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Chube gwa giti cha geru gbe egdage ba ole kwian chui olladanga ulita gwa giti, ba takalin lle ulita chanu bonga, cha be lle kete bonga ulita bage, ba ñage chege daba gweale chugagwallale nga aige. ");
INSERT INTO sabNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Chugagwalla rey Herodes gerudu ene Herodías jian ole gire Herodías jian jo siere ne ngwadige ama jo gerule ama chebia ole, ama gerudu: —¿Cha llema kade chugagwalla rey Herodege cha skwendu gdate ñanale? Herodías jaindunga mo jian kalen: —Ba Juan-Bautista chugabita kade Herodege. ");
INSERT INTO sabNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Chebia gerudu ene jian ole gire jian joni blikare Herodes kledu chui ollade ngwadi, Herodías jian gerudu Herodes ole ama chebia ama ta gbu gerule kare: —Negetabi cha takalin ba Juan-Bautista chugabita kete chage batekwa giti. ");
INSERT INTO sabNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Chugagwalla rey Herodes Herodías jian keruchugu gerule ene ama ole gire ama ta olidu tanre. Agwa ama nu gerubabi Chube gwa giti kaire kwian na ulita gwa giti ama be lle kete Herodías jiange Herodías jian lle kade amage kare malen Herodes me ñadu geru e blite nganake Herodías jiange. ");
INSERT INTO sabNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Malen Herodes kwian lle boanga ama alin gdaite kadu mo gitigu, Herodes gerudu kwian e ole: —Joga Juan-Bautista gweda, ba ama chuga tkenga gire ba chieni Juan-Bautista chugabita dbe chage batekwa giti. ");
INSERT INTO sabNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Kwian lle boanga e jo Juan-Bautista kledu skage ngwadi, ama jo chke llani gire ama Juan-Bautista chuga tkunga. Kwian e Juan-Bautista chugabita du batekwa giti Herodías jian alin, gire Herodías jian Juan-Bautista chugabita ketu mo chebia Herodíage. ");
INSERT INTO sabNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Geru chku uñale kwian Juan-Bautista gerua jwannga ulitage Juan-Bautista guleda gire ama ulita jo Juan-Bautista kledu skage ngwadi Juan-Bautista jaba jwen ogadale keugage. Ai ulita boidu ene Juan-Bautista giti malen geru chku Herodes ologe kwian gweale kle tañachuge Juan-Bautista jogebakeda chkebani gwade, gire Herodes ta kendunga tanre ama tañachugu ulia Juan-Bautista chkuni gwade, agwa me ene ulia Herodes kwian keruchugu gerule kare. ");
INSERT INTO sabNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jesu nu kwian geru jwannga amage ulita kagaba chage una kaire kairege Chube gerua trage daba na ole, kwian geru jwannga ulita chkuni Jesu kle ngwadige, gire ama ulita geru ketu Jesuge ama lle bo ulita giti kaire ama kwian tku tangle mine giti. ");
INSERT INTO sabNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Kwian geru jwannga kledu geru e trage ulita Jesu ole, gire kwian na tanre kledu chie Jesu kledu ngwadi, kwian gweale kledu jogeni kaire kwian na kledu chke Jesudi, kwian tanre kledu ne ngwadi ni Jesu ni kwian geru jwannga amage ñadu blire, malen Jesu gerudu geru jwannga amage ole: —Kwian tanre kle chke chedi, ale joge sugekare kwian ai ulitage, che alin ulita jogedale undege nga gballage kwian tanre me kle joge chke ngwadi. ");
INSERT INTO sabNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Gire Jesu ule kwian geru jwannga amage ulita ole kwian na ulita chugu ngwadi kedagu, jo duge nga gballage. ");
INSERT INTO sabNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Kwian tanre gwagedu ama ulitadi joge, chku uñale kwian ege e Jesu amaña jo sugekare nga ege kwian geru jwannga Jesuge ulita ole, gire kwian ngle una tanrege jo chage blike seradi chi kagda jegwale Jesu nate, kwian ñadu ngeru nga Jesu be joge undege ngwadige. ");
INSERT INTO sabNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesu jo chke chibita kagda giti ongoru nga ama be undege ngwadi ule kwian geru jwannga amage ole, Jesu jo siere duge gire Jesu gwagedu kwian tanredi kledu mo litaba ama manade ngwange. Jesu taidu dage kwian e ulitage, chudaboanga me kwian e alin kwian e tke tangle no trate Chube gerua giti, Jesuge sugedu kwian e ulita bda oveja me mo mananga molen kare, malen Jesu taidu dage kwian e ulitage Jesu kwian e chudabo Jesu kwian e tku tangle tanre Chube gerua giti. ");
INSERT INTO sabNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nga jo chege bi, gire kwian geru jwannga Jesuge ulita chku Jesudi gerudu Jesu ole: —Nga jo jere, nga ai che kle ngwadi nga gballa, bligda me nga aige kwian ulita alin gutadale. ");
INSERT INTO sabNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Noare ba gbi kade bdagli kwian ulitage ba ama ulita kage siere nga aige, ene ama ulita ñage joge nga gwealege una gwealege bligda gige mo alin gutadale. ");
INSERT INTO sabNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Geru jwannga Jesuge gerudu ene Jesu ole gire Jesu gerudu ama ole: —Ba ulita agali bligda kete kwian ulitage gutadale. Kwian geru jwannga jaindunga: —¿Cha kwian ulita ulle llemadi? ¿Ba takalin cha joge pan gige kwian ai ngle ulita alin? Igi kwangle pan gigagda kwian ngle alin gutadale. ");
INSERT INTO sabNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesu geru kadu kwian geru jwanngage: —¿Ba kle chage pan dbe gdamangire? Joga pan ten pan gdamangire kle. Kwian geru jwannga Jesuge jo pan gdachuge bigire ama geru duni Jesuge pan giti, ama gerudu Jesu ole: —Pan kle gdatigale alin allabi, kaire ngwe kle gdabokle alin allabi. ");
INSERT INTO sabNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Kwian geru jwannga gerudu ene Jesu ole gire Jesu kwian nglea ulita gbangu toi dba ngauda giti mne kaire kaire. ");
INSERT INTO sabNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Kwian ulita toidu dba mne kaire kaire sugekare, kwian cincuenta mne gweale kaire kaire kwian cien mne gweale kaire kaire, kwian ulita toidu dba ene ngauda giti. ");
INSERT INTO sabNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Gire Jesu pan gdatiga ngwe gdaboke gau kote, Jesu gwagedu nga ngaña giti, Jesu gerudu Chube ole bligda giti: “Cha Ñenua, noare ba pan ai ngwe ai ketu kwian ai ulita alin gutadale.” Jesu gerudu ene Chube ole gire ama pan gdatiga skutunga pan ketu kwian geru jwanngage girabatadale kwian ulita ole. Jesu pan gbu jriennga pan ñadu kwian ulita mo litabage. Kaire Jesu ngwe uda junnga ngwe ketu kwian geru jwanngage girabatadale kwian ulita ole. Boidu ngwe ole salengwli boidu pan ole kare Jesu kiralla giti bligda jriendunga ngle. ");
INSERT INTO sabNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","44","Kwian ngle ulita blidu no, kwian onbre ngle cinco mil blidu, kaire muinga ngle kirogwa ngle blidu agwa ama me jo teanba, Jesu kwian e ulita ullu pan gdatigale alindi ngwe gdabokle alindi. Kwian ulita unchku no bligdadi gire bligda bita ngle cheguda, kwian geru jwannga Jesuge bligda bita e ulita litu ole ski kweri gbataboko giti gbaboke, ski e ulita chku ete bligda cheguda ole. ");
INSERT INTO sabNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jesu kwian ngle ullu ene, bigire Jesu gerudu kwian geru jwannga amage ulita ole: —Joga duge chibita tkenga tangle chkagu chi kagda giti una kada Betsaidage. Cha be chege gbi jige bdagli kwian nglege, gire cha be joge ba nate. ");
INSERT INTO sabNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kwian geru jwannga Jesuge ulita jo chage duge chiga giti una Betsaida ngnagu, gire Jesu gbi jigu bdagli kwian ulitage Jesu jo sugekare kwian e ulitage jo gballa jwichuga giti ngaña gerule Chube ole. ");
INSERT INTO sabNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nga jo jere gire Jesu chegu gballa jwichuga giti, kwian geru jwannga Jesuge jo bate duge chi bonga. ");
INSERT INTO sabNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","50","Nga chiu kamalin ngwange bdugu gire Jesu jo chage seradi chiga giti kwian geru jwannga ulita kle duge ngwadi ngnagu chi bonga. Mle kweri kledu tiennga kiraske dudi kwian geru jwannga gwangnagu, ama ulita kledu chi bage blikare agwa mle kweri kote ama me ñadu du dbe no. Uñadu Jesuge kwian geru jwannga ulita kledu kira bate tanre ene mle ole. Jesu jo chke kodi duge gire kwian geru jwannga ulita gwagedu Jesudi chage seradi chiga giti agwa me chku Jesu uñe, kwian geru jwannga ulita ta kendunga tanre, ama ulita tañachugu oñakwa kledu chage. Kwian geru jwannga ulita ngwanedunga chru ole, gire blikare Jesu gerudu: —Ba me kennga, ba mo ta gbe kiraske, cha amaña kle chage. ");
INSERT INTO sabNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Jesu jo du toli kwian geru jwannga ulita kledu ngwadi gire mle me chegu tiennga dare, chi chegu ngwedi. Boidu ene gire kwian geru jwannga ulita chegu tañachuge tanre Jesu agedu giti, e ulita me sugedu trate amage. ");
INSERT INTO sabNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Kaire ama ulita nu gwageba Jesudi bligda gbe jriennga ngle kwian tanre ullagda, agwa ni e sugedu kwian geru jwanngage, ama me kle mo ta gbe Jesu gai ulia, malen Jesu agedu ene ulita mo kirallaske me sugedu amage. ");
INSERT INTO sabNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Jesu jo chage duge gwangerugu kwian geru jwannga amage ulita ole, ama ulita jo chke chi kagda giti ongoru nga kada Genesarege. Ne ngwadi ama ulita jo siere duge ama du jun kedagu chi kagda giti, ama du luguda. ");
INSERT INTO sabNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Kwian tanre nga emu gwagedu Jesudi joge dbige gire chku uñale kwian e ulitage Jesu amaña chku. ");
INSERT INTO sabNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","56","Kwian e jo blikare daba ulita nga e ulitage ta gbe Jesu kle chage nga ege, gire kwian tanre chiu daba oga dbe ankwa giti Jesu kledu ngwadi dodadale. Jesu jo chke kwian ngle kle toi ngwadi jo chke kwian bedre kle toi ngwadi, nga ulitage baini kaire Jesu jo chke ngwadi kwian tanre chiu diali daba oga dbe Jesu ngwange jonke dodadale Jesuge. Kwian daba oga dbanga ulita gerudu Jesu ole daba oga giti: —Ba daba oga chuge ngwadi ko chuge sidri ba ñometralladi alin allabi, ene daba oga be joge chkeni noni. Kwian chudaboi kadu ene Jesuge daba oga alin, gire kwian oga ulita bai kaire ko chugu alin Jesu ñometralladi, kwian ene ulita jo chkeni noni me chegu oga dare. ");
INSERT INTO sabNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Kwian fariseo mneite ule kwian daba tkanga tangle Moisés chadalla giti gweale ole chiu una Jerusalénge, chku Jesu kle ule kwian geru jwannga amage ulita ole ngwadi. ");
INSERT INTO sabNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Kwian e ulita gwagedu kwian geru jwannga Jesuge ulitadi blire, chku uñale amage kwian geru jwannga Jesuge bebi blire gire ama me mo ko gligu trate bitangle geru unsuialin kle gbaba kwian israelita alin gerule kare. ");
INSERT INTO sabNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Kwian fariseo e ulita kaire kwian israelita na ulita kle mo ta gbaba age diali ama enusulian unsuialin tangle geru gbu kare kwian israelita toidale giti, geru e gerule kwian israelita bebi blire gire ama mo ko gligadale trate tanre geru kledu gbaba unsuialin tangle gerule kare. ");
INSERT INTO sabNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Kwian israelita joge lle gige lle chbade gire ama joge chkeni gwa ama agedale ulita geru kle gbaba gerule kare, ama me ñage blire ama bebi mo ko glige trate tanre gire. Kaire geru na tanre kledu gbaba unsuialin tangle kwian israelita kle gai dage, geru e gweale kle gbaba un giti lle chi jangwa giti batekwa giti. Kwian israelita lle e kare ulita gligadale no trate geru kle gbaba gerule kare ama bebi gai gire. Kwian israelita kle tañachuge ama me age ulita ai kare gire ene ama kle age me no Chube dollale ama chege jiske Chube gwa giti. ");
INSERT INTO sabNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kwian fariseo ulita kaire kwian daba tkanga tangle Moisés chadalla giti ulita bai nu chieba una Jerusalénge kle toi ene geru unsuialin kle gbaba gerule kare, kwian e ulita jo chke Jesu kle ngwadi, ama ulita gwagedu kwian geru jwannga Jesugedi blire ama bebi ko glige trate tanre gire, ama ulita tañachugu e me no gire ama ka bo Jesu ole kwian geru jwannga Jesuge kledu age giti gdale: —¿Mineade kwian geru jwannga bage me kle che enusulian unsuialin suia gai dage? Ama me kle age ulita geru kle gbaba gerule che israelita toidale giti kare. Ama me kle ko glige trate bitangle ama bebi blire gire, ama kle age me no blire ko sugaska ole llagli. ");
INSERT INTO sabNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesu jaindunga kwian e ulita kalen: —¿Mineade ba kle gerule kate ba kle Chube gerua gai dage, gire ba me kle age ba kle gerule kare? Ba ulita ta me no. Kwian Chube gerua ketanga kada Isaías Chube gerua degu unsuialin tangle ba ulita giti, chada e gerule: “Chube gerudu: ‘Kwian ai ulita kle gerule ama kle cha gai dage, kle gerule ene ka giti alin allabi, agwa ulia ama me kle cha gai dage ulia mo tale, ama ta kle bate chage ama kle gerule alin allabi. ");
INSERT INTO sabNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kwian kle gerule ama kle cha gai dage mo Chubeale, agwa ngwale ama kle gerule ene, ama me kle mo ta gbe cha ole ulia. Kaire ama me kle daba tke tangle cha gerua ulia giti, agwa ama kle daba tke tangle geru ngwale giti ama agali kle tañachuge kare mo tale.’ ” Kwian Chube gerua ketanga Isaías chada degu ene Chube gerudu giti. ");
INSERT INTO sabNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ulia Chube kledu gerule ba kwian fariseo giti kaire ba kwian daba tkanga tangle Moisés chadalla giti ulita giti. Cha gerule ulia ba ulita ole, ba me kle Chube gerua ulia gai dage age geru e kle gbaba kare, agwa ba kle chage kwian ngwale unsuialin tangle suia kle gbaba kare, e ngwale ba kle age kare. ");
INSERT INTO sabNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jesu gerudu mno dare kwian e ulita ole: —Diali ba kle mo ta gbe Chube gerua gai ngwale, ba kle ba enusulian unsuialin tangle suia alin allabi gai mo alin, unsuialin ba enusulian geru gbu kwian israelita toidale mine gire nege tangle ba kle age ama geru gbu kare alin allabi ba me kle age Chube geru gbu kare. ");
INSERT INTO sabNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Unsuialin Chube geru ketu Moisége degadale kwian ulita alin, chada e gerule: “Ba mo ñenua kaire mo chebia gadale dage no.” Kaire chada na Moisés nu degaba kle gerule: “Kwian bai kaire gerule me no mo ñenua dollale mo chebia dollale kwian ene gwadaleda blike.” ");
INSERT INTO sabNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Moisés Chube gerua degu ene ulita unsuialin, agwa ba ulita agali me kle geru e gbe gdadi kaire ba kle daba na tke tangle age nganake me age chada e kle degaba gerule kare. Ba kle kwian ta gbe me mo ñenua mo chebia chudaboadale me lle ketadale amage ama llea me gire. Ba kle kwian tke tangle gerule mo ñenua ole mo chebia ole: “Mama, tata, cha me ñage ba chudaboi, lle ulita chanu cha ketu Chubege, cha ole lle me ba chudaboagda.” Ba kle kwian tke tangle ama llea ulita ka gbe “corbán” (geru e gerule “lle ai cha nu ketaba Chubege”). ");
INSERT INTO sabNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ba kle kwian tke tangle kwian gerule ene ama nu mo llea ulita ketaba Chubege, gire ama me chege jiske ama ñenuage ama chebiage Chube gwa giti, ama me mo ñenua mo chebia chudaboadale. ");
INSERT INTO sabNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ba kle age me no ene malen cha gerule ba ole, ba ulita nu Chube gerua mliabanga me mo ñenua mo chebia manade Chube geru gbu kare unsuialin tangle, ba kle ba enusulian unsuialin suia gai dage ma no Chube gerua uliage. Ba kle kwian tke tangle geru na tanre ngwale giti. ");
INSERT INTO sabNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jesu gerudu ene kwian fariseo ulita ole kwian daba tkanga tangle Moisés chadalla giti ulita ole, gire Jesu kwian na ulita kledu ne ngwadi kadu mo gitigu ama keruchuge, Jesu gerudu kwian e ulita ole: —Ba cha keruchuge no, cha takalin geru ai suge trate ba ulitage: ");
INSERT INTO sabNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ni lle gdaite kwian kle gute kle kwian gbe me no jiske Chube gwa giti, agwa kwian kle tañachuge me no mo tale, gire kwian kle gerule me no age me no ama kle tañachuge kare, e ulita kle kwian gbe me no jiske Chube gwa giti. ");
INSERT INTO sabNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ba ulita me cha gerua ai keruchuge alin allabi mo ologe, agwa kaire ba ulita mo ta gbadale geru ai gbe gdadi. ");
INSERT INTO sabNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jesu gerudu ene ulita kwian ole gire ama kwian ulita chugu ngwadi goga tangle, ama jo gwa ule kwian geru jwannga amage ulita ole, kwian geru jwannga Jesuge gerudu Jesu ole: —Ba gerudu sbaliga kwian ole bligda che kle gute me che gbe me no jiske Chube gwa giti, geru e me suge chage ba kledu gerule llema giti, cha takalin ba geru e trennga cha ulitage. ");
INSERT INTO sabNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesu jaindunga kwian geru jwannga amage kalen: —¿Ba ulitage kaire agwe geru e me suge? Sugedale bage ni lle gdaite che kle gute ñage che ta gbe me no jiske Chube gwa giti. ");
INSERT INTO sabNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Che blire gire bligda me kle joge chke che tale che ta gbagda age me no Chube dollale, agwa che kle blire gire bligda kle joge che kdege bigire bligda e kle joge tangle ulita, che kle mlienga. Jesu gerudu ene bligda giti, Jesu kwian ta gbu bligda ulita no trate kwian alin gutadale. ");
INSERT INTO sabNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Gire Jesu gerudu gwangerugu kwian geru jwannga amage ulita ole: —Cha gerule ba ulita ole, kwian kle tañachuge me no mo tale, talla e giti kwian kle age me no kle gerule me no ama kle tañachuge kare, e kle kwian gbe jiske Chube gwa giti. ");
INSERT INTO sabNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kwian tale bai kaire talla me no kle, kwian ene be mo ta gbe age me no diali ai kare ulita: Onbre muinga me mo jwanba mo chuge ke giti. Onbre mo jwanba mo chuge ke giti muinga na ole, muinga mo jwanba mo chuge ke giti onbre na ole. Kwian skwe boi daba ngeru. Kwian daba gweda. ");
INSERT INTO sabNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Kwian ta lle tanre gakalin mau alin allabi. Kwian age tanre sugaska me no. Kwian daba anblite geru ngwalege. Kwian mo ta gbe age ulita me no ama takalin kare kwian na gwa giti. Kwian jainchke dabadi lle dabanu gdale ama semale tanre daba ole lle dabanu giti. Kwian gerule me no daba nadi. Kwian mo sobade daba nadi. Kwian age ulita ama takalin kare ni tañachuge Chube giti, ama me ta ole. ");
INSERT INTO sabNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Lle ai ulita cha kle ka jwen ba ole, e ulita kle chie kwian tale, e kle kwian gbe me no jiske Chube gwa giti. Kwian tañachuge me no mo tale gire ama kle age me no ama tañachuge kare, age me no giti kwian mo gbe me no jiske Chube gwa giti —Jesu gerudu ene kwian geru jwannga amage ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesu jo chage dare kwian geru jwannga amage ulita ole una Tiro ngnagu, ama jo chke kodi una Tiroge gire u skwendu amage undegangwa. Ama jo chke gwa u ege, ama me tadukalin chke uñale ni kwian gdaitege ama kle nga ege agwa ama me ñadu mo ogeda dale kwian ngeru. ");
INSERT INTO sabNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Geru chku uñale kwiange Jesu kle ngmadi, gire blike muinga gdaite jo tienda Jesudi. Muinga e me kwian israelita, ama nga namu nga kada Sirofeniciamu, muinga e jian oga jwligebanga dolla kote, malen muinga e jo Jesu kle ngwadi chudaboi kade Jesuge mo jian alin. Ama jo chke Jesu kle ngwadi ama jongnagwa skutu dba Jesu gwangnagu Jesu gai dage, gire muinga e gerudu Jesu ole: —Cha jian jwligebanga dolla kote, cha takalin ba cha jian dodade ba dolla kage siere cha jiange. ");
INSERT INTO sabNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesu gerudu muinga ole: —Cha bitalla israelita alin cha lle no tanre boadale, ba muinga me israelita, cha ba chudaboi e chege salengwli bligda jwennga kirogwa ngeru kete toge gutadale kare, ma no kirogwa chuge ngwadi blire ngeru. ");
INSERT INTO sabNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Jesu gerudu ene gire muinga jaindunga Jesu kalen: —E ulia ba gerudu kare kwian chugagwalla, agwa to kle manade kirogwa kle blire ngwadi gire bligda jwna jwatenga kirogwa kote to kle e gute. E kare ene cha takalin ba cha chudaboi, ba dolla kage siere cha jiange. ");
INSERT INTO sabNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesu gerudu muinga ole: —Ulia ba gerudu no, ba gerudu giti suge chage ba kle cha gai ulia, malen e giti cha be dolla gbe joge siere ba jiange, ba ñage jogeni gudegu ba jian kle ngwadi, ba jian kle no. ");
INSERT INTO sabNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Muinga joni mo ullage, ama jo chkeni gwa gire jian skwendu amage mo undege ankwa giti, ama jian jo chkeni noni chegu trate, dolla jogeba siere kirogwa muire ege Jesu kiralla giti. ");
INSERT INTO sabNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesu jo siere una Tiroge jo chage ule kwian geru jwannga amage ulita ole chibita kada Galilea ngnagu, Jesu chagedu una Sidónske tangle kaire una na tanreske tangle nga Decápolige gire Jesu jo chke chibitage nga Galileage. ");
INSERT INTO sabNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ne ngwadi kwian chku daba gdaite olo me dbe Jesudi dodadale, kaire daba oga e me ñage gerule trate. Kwian daba oga e dbanga gerudu Jesu ole: —Cha takalin ba ko gbe daba ai giti, uñale chage ba ñage daba ai dodade ene ama joge chkeni noni. ");
INSERT INTO sabNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesu onbre oga du sugekare kwian ngleage, gire Jesu ko chugu onbre olo toli, Jesu mo jolokwa jun kodige gbu onbre kwira giti. ");
INSERT INTO sabNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Jesu gwa gaunga ngaña, Jesu unjunnga kweri tai dage tanre onbre oga ege, gire Jesu gerudu mo kwirale onbre oga ole: —¡Efata! —geru e gerule: “¡Olo trende!” ");
INSERT INTO sabNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Jesu gerudu ene onbre oga ole gire sugeti onbre olo trendu ama ñadu geru keruchuge kaire ama kwira chegu no ama ñadu gerule no trate. ");
INSERT INTO sabNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesu onbre dodadu ene gire Jesu gerudu kwian ulita ole: —Ba me geru kete ni kwian gdaitege cha onbre ai dodadu giti. Jesu gerudu ene tanre kwian ole me geru kete kwian nage Jesu onbre e dodadu giti agwa kwian me ñadu chege kamne, kwian ulita geru e tragu kwian na ole Jesu onbre oga dodadu giti. ");
INSERT INTO sabNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Kwian ulita bai geru e keruchugu chegu tañachuge tanre no Jesu giti, ama ulita chegu gerule no modi Jesu giti: —Jesu kle age ulita no kwian alin. Kwian olo me ama kle kwian ene gbe olo tren geru keruchuge trate, kaire kwian keru me ama kwian ene gbe gerule trate —kwian ngle gerudu no ene Jesu giti. ");
INSERT INTO sabNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","E suiale nakwaite kwian ngle mo litu Jesudi tangle Jesu keruchuge, Jesu gwagedu kwian ulitadi sugedu Jesuge kwian ulita me bligda molen gutadale, Jesu kwian geru jwannga amage ulita kadu mo gitigu, Jesu gerudu kwian geru jwannga ole: ");
INSERT INTO sabNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Cha tai dage kwian ai ulitage, chui maike chku ama ulita kle cha ole aini, bligda ulita bidegu ama ole gire nege ama ulita me bligda molen gutadale. ");
INSERT INTO sabNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Cha kwian ulita kageni gudeguni me bliba, gire nga ñage jogenga kwian ulita gwage bli ole jonkare, cha me takalin kwian boi ene, kwian gweale nu chieba nga batege, cha me ama ulita kagakalin bliage. ");
INSERT INTO sabNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Kwian geru jwannga Jesuge ulita gerudu Jesu ole: —¿Che age mine? Aini nga gballa kwian na me kle toi aini, ¿chema ngwadi che joge bligda jinade kwian ngle alin gutadale? ");
INSERT INTO sabNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesu geru kadu kwian geru jwanngage: —¿Pan gdamangire ba kle chage dbe? Kwian geru jwannga jaindunga Jesu kalen: —Pan gdagukle alin kle. ");
INSERT INTO sabNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jesu kwian ulita gbu toi dba dbi giti gire ama pan gdaguke gau kote, ama gerudu Chube ole: “Cha Ñenua, nga suga noare chadi ba pan ai ketu chage kwian ulita ullagda.” Jesu gerudu ene Chube ole pan giti gire ama pan skutunga kote, ama pan ketu kwian geru jwannga ulitage girabatale kwian ulita ole, pan jriendunga ngle pan ñadu kwian mo litaba mangire batre alin. ");
INSERT INTO sabNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Kaire agwe kwian geru jwannga kledu chage ngwe soli ole gdamoite, Jesu ngwe gau kote, gerudu Chube ole ngwe giti gire ama ngwe ketu kwian geru jwannga ulitage girabatale ulita kwian ulita ole, ngwe jriendunga ngle ngwe ñadu kwian mo litaba mangire batre alin ulita. ");
INSERT INTO sabNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Kwian ngle cuatro mil blidu ulita pan gutu kaire ngwe gutu ulita unchku ama takalin kare. Pan bita ngwe bita cheguda ngle, kwian geru jwannga bligda bita e litu ole, ski kweri gbaguke chku ete bligda bita cheguda ole. Jesu kwian ulita ullu ene gire Jesu gbi jigu bdagli kwiange, kwian kaguni gudeguni. ");
INSERT INTO sabNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Gire Jesu jo duge ule kwian geru jwannga ulita ole chi kagda giti ongoru nga kada Dalmanutage. ");
INSERT INTO sabNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Jesu jo chke nga Dalmanutage ule kwian geru jwannga ulita ole, gire kwian fariseo ngle chku mo lite Jesudi mo chuge Jesu ole ta me no ole, kwian fariseo gerudu Jesu ole: —Ba kle gerule Chube ba kagu nga dba ai giti, cha takalin nege ba lle daga ngwale no kweri kwian me ñage dodade mo kira giti kare ba lle ene dodade cha ulita gwa giti, ene be chke uñale trate cha ulitage ulia Chube ba kagu ba kle age Chube kiralla giti. ");
INSERT INTO sabNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesu ta olire tanre kwian fariseo me kle ama gai ulia giti, Jesu gerudu kwian fariseo e ulita ole: —¿Mineade diali ba ulita kle toi chui aige tangle takalin cha age ene ba gwa giti? Ba kle gerule alin cha lle daga ngwale no dodade ba gwa giti kwian me ña lle dodade mo kira giti lle ene cha dodadale gire ba be cha gai ulia Chube cha kagu age ama kiralla giti. Agwa ulia cha gerule ba ole, cha mi age ba kle toi chui aige tangle alin ba ulita takalin kare. ");
INSERT INTO sabNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Jesu gerudu ene kwian fariseoge, gire Jesu nga jigunga ama ulitadi, Jesu joni naskuni du toli kwian geru jwannga amage ulita ole, ama ulita jo chage duge chkagu chibita kagda ongoru ngnagu. ");
INSERT INTO sabNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Kwian geru jwannga Jesuge ta jonga pan dbe gutadale duge, pan gdaitre alin allabi kledu ama ole du toli. ");
INSERT INTO sabNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesu kwian geru jwannga ulita ta gbu me geru ngwale gai, Jesu gerudu ama ulita ole: —Cha gerule ulia ba ole, ba mo ta manadale chage ta giti kwian fariseoske kaire chugagwalla rey Herodege, ba me mo chuge ngwadi ama levaduralla gai pan dodale mo alin. ");
INSERT INTO sabNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Kwian geru jwannga ulita tañachugu Jesu kle gerule pan dodaba levadura ole ulia giti gire gerudu modi: —Che me chiu pan dbe gutadale malen Jesu kle gerule ene che ole levadura giti. ");
INSERT INTO sabNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesuge chku uñale kwian geru jwannga kle gerule modi Jesu gerudu giti, uñadu Jesuge geru levadura giti me sugedu trate kwian geru jwanngage, Jesu gerudu ama ulita ole: —¿Mineade ba kle gerule modi ba me chiu pan dbe mo ole llagli giti? ¿Bage me suge bligda me gire cha ñage bligda kete ba ulitage? ¿Ba bebi mo ta gbe ulia cha ole cha kiraske cha ñage age ulita Chube kiralla giti? ");
INSERT INTO sabNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Cha lle daga ngwale no tanre dodadu ba gwa giti, agwa me suge bage cha mine. Ba cha gerua keruchugu cha kledu kwian tanre tke tangle gire, agwa geru me suge bage dale. ¿Ba ta jonga ulita cha kwian ngle ullu bligda sidridi giti? ");
INSERT INTO sabNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Cha pan gdatiga girabatangu bage kwian onbre ngle cinco milge, kwian e ulita unchku gire ¿ba bligda bita cheguda litu ole ski gbamangirege? Kwian geru jwannga Jesuge jaindunga: —Ski gbataboko giti gbaboke chku ete bligda bita cheguda ole. ");
INSERT INTO sabNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jesu gerudu dare: —Ba gerudu trate. Kaire agwe cha pan gdaguke girabatangu bage kwian ngle cuatro milge, gire ¿ba bligda bita cheguda litu ole ski gbamangirege? Kwian geru jwannga jaindunga: —Ski gbaguke chku ete bligda bita cheguda ole. ");
INSERT INTO sabNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Gire Jesu gerudu geru jwannga ole: —¿Bage geru bebi suge cha gerudu sbaliga ba ole giti? Cha gerudu ba ulita ole ba me mo chuge ngwadi kwian fariseo kaire chugagwalla rey Herodes levaduralla gai mo alin giti, cha me kledu gerule levadura ulia giti, agwa cha kledu gerule kwian fariseo gerua ngwale giti kaire chugagwalla rey Herodes gerua ngwale giti —Jesu gerudu ene kwian geru jwannga amage ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jesu ule kwian geru jwannga amage ulita ole chagedu dare duge gire ama ulita jo chke una Betsaidage, ama ulita chiu dbige duge gire onbre gdaite gwagwa me dbachku Jesudi dodadale. Onbre gwagwa me dbanga gerudu Jesu ole: —Ba ko gbe onbre ai gwagwa giti ene ama joge chkeni noni. ");
INSERT INTO sabNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Kwian gerudu ene Jesu ole gire Jesu onbre gwagwa me gau koge du sugekare una ege. Jesu mo jolokwa jun gbu onbre gwagwa giti, Jesu ko gbu onbre gwagwa giti gire ko junnga onbre gwagwa giti, Jesu geru kadu onbre gwagwa mege: —¿Ba ñage ten lle gwealedi o me? ");
INSERT INTO sabNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Onbre gwagwa me ama gwagwa trendu sidri gire ama jaindunga Jesu kalen: —Ima, cha kle ten kwiandi agwa kwian kle meñe cha gwage salengwli gli kare, ama kle chage. ");
INSERT INTO sabNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesu ko gbu nakwaite onbre gwagwa giti, gire onbre gwagwa trendu no jo chkeni ulita, ama tendu lle ulitadi trate. ");
INSERT INTO sabNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesu gerudu ama ole: —Ba jogeni blike gudegu mo ullage, ba me joge unaske geru trage kwian na ole cha ba dodadu giti —Jesu gerudu ene onbre ama nu dodaba ole. ");
INSERT INTO sabNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesu jo chage dare kwian geru jwannga amage ulita ole una soli ulita gdaite gdaitege una kweri kada Cesarea-Filipo giti tangle. Gire jonkare Jesu geru kadu kwian geru jwanngage: —¿Kwian ulita kle gerule mine cha giti cha chema? ");
INSERT INTO sabNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Kwian geru jwannga jaindunga: —Kwian gweale kle gerule ba Juan-Bautista jogebakeda chkuni gwade, kwian na kle gerule ba kwian Chube gerua ketanga dabage unsuialin kada Elías chkuni, kaire kwian na kle gerule ba Chube gerua ketanga unsuialin jogebakeda chkuni gwade. ");
INSERT INTO sabNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Kwian geru jwannga gerudu ene Jesu ole gire Jesu geru kadu dare ama ulitage: —Kwian na kle gerule ene cha giti, ¿agwa ba gerule mine? ¿Cha chema? Pedro jaindunga Jesu kalen: —Ba Cristo, Chube ba kagu nga dba ai giti kwian kare kwian jwen siere ji chugege agedu me no gdale. ");
INSERT INTO sabNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Pedro gerudu ene Jesu giti gire Jesu gerudu kwian geru jwannga ulita ole: —Pedro gerudu trate, agwa ba me geru e trageni kwian gdaite na ole, me gerule kwian na ole cha Cristo Chube nu cha kagaba nga dba ai giti —Jesu gerudu ene kwian geru jwannga amage ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jesu kwian geru jwannga amage ulita ta gbu Jesu be boi mine giti, Jesu gerudu: —Chube cha kagu nga dba ai giti kwian kare, kwian tanre be age cha dollale cha gbe boi tanre daga ngwale, kwian israelita chugagwalla juma ulita kaire kwian gerunga Chube ole daba alin chugagwalla ulita kaire kwian daba tkanga tangle Moisés chadalla giti, kwian e ulita me cha gerua gai ulia, ama ulita be jainchke chadi cha gerua gdale be cha gbe boi daga ngwale, bdagli cha gwabeda agwa mongikege cha jaba be chkeni gwade. ");
INSERT INTO sabNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jesu gerudu trate ene mau giti kwian geru jwannga amage ta gbagda Jesu be boi giti, gire Pedro Jesu du sugekare, Pedro gerudu Jesu ole: —Ba me gerule ene, ba mi boi daga ngwale ene ba kle gerule kare. ");
INSERT INTO sabNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesu jwlituda gdate naskuni gwagedu kwian geru jwannga na ulita ngnagu gire ama ka bo mno Pedro ole: —¡Chegede kamne! Ba kle gerule Satanás kiralla giti ba kle gerule ama takalin kare, ulia ba me kle tañachuge Chube takalin kare ba kle gerule kwian onbre ngwale kle tañachuge kare. ");
INSERT INTO sabNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jesu gerudu ene Pedro ole gire Jesu kwian na nglea kadu mo gitigu ule kwian geru jwannga amage ulita ole, Jesu gerudu kwian ulita ole: —Kwian bai ta chagekalin ulia cha ole me tañachugadale dare mau giti alin allabi me agedale dare ama agali ta agekalin kare, ama mo ta gbadale cha gerua gbe gdadi age cha takalin kare, kwian na ama gbe boi daga ngwale cha gerua gdale kaire kwian na ta ama gwakalinda cha gerua gdale ama me mo talladale. Kwian bai mo ta gbe boi cha giti kwian ene ñage chage cha ole. ");
INSERT INTO sabNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kwian bai tañachuge mau giti alin allabi toi no nga dba ai giti mo manade no me tañachuge age Chube takalin kare giti, bdagli kwian ene be jogenga sugekare Chubege be chege boi daga ngwale tanre diali chui tangle. Agwa kwian bai mo ta gbe chage cha ole mo chuge ngwadi boi daga ngwale nga dba ai giti cha gerua dbe gdale, ama me mo tallade, ama tañachuge ma no age Chube takalin kare, bdagli kwian ene be toi no diali chui tangle nga ngaña giti cha ole cha Ñenua Chube ole. ");
INSERT INTO sabNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Cha gerule ba ole, ngwale kwian tañachuge tanre lle lite ole ngle giti ama kle toi nga dba ai giti gire. Kwian tañachuge lle lite ole alin allabi mau alin agwa ama me mo ta gbe ulia Chube ole, kwian e be jogenga ngwale ulita, ama be chege sugekare Chubege diali chui tangle. ");
INSERT INTO sabNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Kwian me ñage tañachuge lle no ñanaske gweale kete Chubege, gire e giti Chube be ama gbe toi no ule Chube ole nga ngaña giti diali chui tangle, me ene dale. ");
INSERT INTO sabNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Cha gerule ba ole, Chube cha kagu nga dba ai giti kwian kare chui bdaglige cha be chieni nakwaite cha Ñenua Chube kiralla giti, cha be chieni ule lle boanga Chube alin nga ngaña giti ngle ole. Kwian nege tangle bai kaire cha gai ulia agwa ama ibule cha giti cha gerua giti kwian agenga me no me cha gerua gaba ngeru, kwian ene ole nga chie ibule amage gerule ama cha gai ulia. Kwian bai ibule ene cha giti nege, kwian ene giti cha mi gerule no cha be chieni chuiage, chui ege cha mi gerule ama giti ama chanu. ");
INSERT INTO sabNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesu gerudu dare kwian ulita ole: —Cha gerule ulia ba ulita ole, ba gweale kle aini cha ole cha keruchuge ba bebi jogekeda, gire ba gwa giti Chube be age no no cha ole ama kiralla giti, ba gwage chadi ene, gire be suge trate bage cha noare cha kweri cha kwian ulita Chugagwalla —Jesu gerudu ene ulita. ");
INSERT INTO sabNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Chui gbadereke jo tangle gire Jesu jo jwichuga giti bate ngaña, ama kwian geru jwannga amage gdamaire alin allabi du ule, ama Pedro kaire Santiago kaire Juan du ule ama gatedi. Ama ulita jo chke jwichuga giti kwian na me kle ngwadi, gire Jesu jegwale jwlitedu ulita kwian geru jwannga gdamai e gwa giti. ");
INSERT INTO sabNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Jesu ñometralla ulita jwlitedu jutre jutre Jesudige gwadenga noare, ni kwian gdaite ñage ñometra glige ene chege jutre Jesu ñometralla kare. ");
INSERT INTO sabNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Kwian geru jwannga gdamai gwagedu Jesudi ene, gire blike kwian unsuialin boke kada Elías kaire Moisés medu geru trage Jesu ole ama gdamai gwa giti. ");
INSERT INTO sabNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pedro gwagedu ene Moisédi Elíadi geru trage Jesu ole, gire Pedro gerudu Jesu ole: —Cha tkanga tangle geruge, nga suga noare chadi che ulita chku aini. Cha be u soli gbe aini gbamai toingwa sugetidale, u gbaite ba alin, u gbaite Moisés alin, u gbaite Elías alin —Pedro gerudu ene Jesu ole. ");
INSERT INTO sabNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ulia kwian geru jwannga Jesuge kendunga tanre ama kle gwage giti me sugedu amage kle boi mine gire me chku uñale Pedroge ama gerudale mine. ");
INSERT INTO sabNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Pedro kledu gerule ene Jesu ole gire bogakwa jutre chra gwadetranga chku blikare ama ulita giti, ama ulita chegu bogakwaske gire bogakwaske Chube kerua sugedu ama ologe gerule: “Ai cha Kirolla, cha no no ama ole. Ba ulita ama keruchugadale no, ba mo ta gbadale ama kerua gbe gdadi no diali.” ");
INSERT INTO sabNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Chube kerua sugedu ene kwiange gire blikare kwian geru jwannga Jesuge tienduda modi tangle gire Elías Moisés me medu dare kwian geru jwannga gwage, Jesu alin kleduni gballa. ");
INSERT INTO sabNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Boidu ene ulita jwichuga giti gire Jesu joni chage jwichugadi gwadbiguda ule kwian geru jwannga gdamai ole, Jesu gerudu ama ole jonkare: —Mo gwagwa giti ba gwagedudi jwichuga giti nege kaire ba geru keruchugu cha giti, ba me e trage ni kwian na gdaite ole. Cha chiu nga dba ai giti kwian kare cha be jogekeda, cha jaba be chkeni gwade gire ba ñage boidu nege gerua trage kwian na ole. ");
INSERT INTO sabNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Jesu kwian geru jwannga gdamai ta gbu ene kwian gwagedu giti kaire kwian geru keruchugu giti, gire kwian geru jwannga gdamai geru e ulita gatu mo tale, agwa ama gdamai kledu gerule modi ongoru ongoru: —Jesu gerudu ama be chkeni gwade, geru e me suge chage. ¿Ama kledu gerule llema giti? Ama gerudu modi ene agwa boidu ulita jwichuga giti ama me geru e ketu kwian nage. ");
INSERT INTO sabNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Kaire kwian geru jwannga gdamai geru kadu Jesuge: —¿Mineade kwian daba tkanga tangle Moisés chadalla giti kle gerule Elías chkedale chage kwianske nga dba ai giti ngeru, gire Chube be kwian daba jwannga siere kage kwian ulita alin? Ba klebi nga dba ai giti kwianske malen me suge chage mineade kwian e kle gerule Elías bebi chke. ");
INSERT INTO sabNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesu jaindunga ama kalen: —E ulia kwian kle gerule kare, Elías chiedale kwian ulita ta gbe biale ngeru, gire Chube kwian daba jwannga siere kage chuiage kwian ulita ta kle biale kwian daba jwannga siere gai ngwange no, e trate ene ulia. Chube gerua degaba unsuialin gerule cha giti chada e kle gerule Chube be cha kage nga dba ai giti kwian jwanngale siere, kaire chada e gerule kwian tanre be cha gai kwian ngwale kare be cha gbe boi daga ngwale tanre me no. Chube gerua kle degaba unsuialin gerule ene cha giti, ¿ba tañachuge mine geru e giti? ");
INSERT INTO sabNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Cha gerule ba ole, Elías chkubi kwianske agwa kwian ama gau kwian ngwale kare kwian me ama gau dage, kwian ama gbu boi jere jere kwian tadukalin kare, ama boidu ene ulia Chube gerua kle degaba unsuialin kle gerule kare —Jesu gerudu ene kwian geru jwannga amage gdamai ole. ");
INSERT INTO sabNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jesu kaire kwian geru jwannga gdamai jo chkeni kwian geru jwannga na ulita kledu ngwadi gire amage kwian geru jwannga na ulita skwendu kwian na tanre ole mo litaba. Kaire kwian daba tkanga tangle Moisés chadalla giti ngle kledu gerule tanre ka boi kwian geru jwannga ole dolla kage siere kwiange giti. ");
INSERT INTO sabNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Kwian ulita gwagedu Jesudi chie ama gitigu, ama ulitadi nga chegu suga noare, ama ulita jo jrite Jesu gitigu Jesu gai ngwange no ama gbi kadu Jesuge: —¿Che kle mine? ");
INSERT INTO sabNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesu gerudu kwian ulita ole: —Che kle ngwakwli. ¿Kle boi mine aini? ¿Kwian kle gerule llema giti aini ka boi kwian geru jwannga chage ole? ");
INSERT INTO sabNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Kwian gdaite kledu kwian ngleaske jaindunga Jesu kalen: —Kwian tkanga tangle geruge, cha chiu cha kirolla ai dbe dodadale, cha tañachugu ba kle aini ene ba ñage cha chudaboi cha kirolla jwligebanga dolla kote dodade. Cha kirolla oga sbali dolla kbiale ama me ñage gerule dale ama keru me. ");
INSERT INTO sabNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Dolla kle age me no cha kirolla ole diali chui gwealege ama kle no chui gwealege ama kle boi tirare dolla kote, dolla kle nga kagenga cha kirolla giti, dolla kiralla kle cha kirolla lugeda dba tangle, ama kle jolokwa mlienga tanre kate, ama kle dau jrite tirare kaire dolla kle ama gbe sklieda ulita jegwale. Cha gerudu kwian geru jwannga bage ulita ole chudaboi kade amage dolla kage siere cha kirollage agwa ama ulita me ñadu, malen cha chiu ba nate ba cha kirolla dodade. ");
INSERT INTO sabNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesu kirogwa ñenua keruchugu gerule ene gire Jesu gerudu kwian ulita kle ne ngwadi ole: —Ba ulita me kle mo ta gbe cha gai ulia. ¿Ngaminegire ba be mo ta gbe cha gai ulia, ene Chube ñage kira kete bage age ulita cha kle age kare? ¿Ngamangire ba be kle kian gbe chage cha ba chudaboadale? Kirogwa du chage aini. ");
INSERT INTO sabNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Jesu gerudu ene kwian ole gire kirogwa e dule Jesuge, dolla kle kirogwa tale gwagedu Jesudi gire dolla e nga kagunga ma obere kirogwa giti, dolla kirogwa luguda dba tangle, kirogwa jolo alin mliunga ngle kate. ");
INSERT INTO sabNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesu geru kadu kirogwa ñenuage: —¿Ngaminegire ama kledu boi ene? Kirogwa ñenua jaindunga Jesu kalen: —Ama chiu tige sidri ama ogabi ene dolla kote. ");
INSERT INTO sabNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Diali dolla kle kirogwa gbe boi tirare ama kle boi ba gwa giti nege kare kaire agwe chui gwealege dolla kle ama gbe joge chke dba jitaske kaire chiske. Dolla kle age ene kirogwa gbale jogekeda, malen cha gerule ba ole, ba ñage age gweale cha kirolla chudaboi ba agedale. Ba tai dage chage ba cha chudaboi, ba dolla kage siere cha kirollage. ");
INSERT INTO sabNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesu gerudu kirogwa ñenua ole: —¿Mineade ba kle gerule cha ñage age gweale ba kirolla chudaboi cha agedale? Kwian ulita bai kaire kle mo ta gbe ulia Chube ole kle mo ta gbe Chube gerua gai ulia, kwian ene alin Chube be age ulita no kwian chudaboagda. ");
INSERT INTO sabNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Kirogwa ñenua gerudu Jesu ole: —Cha kle mo ta gbe ulia Chube ole, agwa ba cha chudaboi mo ta gbe ma ngle gwangerugu Chube gai ulia diali. ");
INSERT INTO sabNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesu gwagedu kwian tanre kledu mo litaba amadi tangle, gire Jesu gerudu dolla kledu kirogwa tale ole: —Ba dolla kwian gbanga olo me keru me, ba ole cha gerule, ba jogedale siere kirogwa aige, ba me ñage age dare me no ama ole ni ba ñage joge chkeni ama tale dare. ¡Joga siere amage! ");
INSERT INTO sabNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Jesu gerudu ene gire dolla ngautu kweri skochiu tanre ama nga kagunga kirogwa giti nakwaite ma obere ngerugu gire dolla jo siere kirogwage, dolla kirogwa jigu jogebakeda kare. Kwian tanre gerudu dolla kirogwa guda, ");
INSERT INTO sabNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","agwa Jesu kirogwa ko gau kote Jesu kirogwa chudabo chke gdate, kirogwa chku gdate chegu no trate ulita. ");
INSERT INTO sabNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Bigire Jesu jo sugekare kwian ngleage ama jo gwa u gbaitege ule kwian geru jwannga amage ulita ole, gire kwian geru jwannga geru kadu amage: —¿Mineade cha me ñadu dolla kage siere kirogwa ege? ");
INSERT INTO sabNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesu jaindunga kwian geru jwannga amage kalen: —Kwian jwligebanga dolla tirare kote kirogwa e kare, ba ta dolla e kare kagakalin siere kwiange, ba mo ta gbadale mo tke bage bligdage gerule tanre Chube ole kira kade amage dolla kagagda siere kwiange, ene Chube kirallaske ba ñage. Ba me mo tke bage bligdage ni gerule Chube ole kira kade amage, ene ba me ñage dolla e kare kage siere kwiange —Jesu gerudu ene kwian geru jwannga amage ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Jesu kaire kwian geru jwannga amage ulita jo siere ne ngwadige ama ulita jo chage nga Galileage tangle. Jesu tadukalin kwian geru jwannga amage tke tangle sugekare kwian na ulitage Jesu be boi giti malen Jesu kledu chage nga ege tangle skwlenre kwian ngleage, Jesu kledu chage kwian geru jwannga ole, gire ama gerudu: —Chube cha kagu nga dba ai giti kwian kare, cha ketabe kwian agenga me no cha dollalege gwaleda, ama be cha gweda, agwa chui mongikege cha jaba be chkeni gwadeni. ");
INSERT INTO sabNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Kwian geru jwannga ulitage me sugedu trate Jesu kledu ama tke tangle giti, ama ulita ibudu geru kade Jesuge geru Jesu kledu gerule ama ole giti. ");
INSERT INTO sabNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","34","Bigire Jesu jo chke una Capernaumge ule kwian geru jwannga amage ole. Jonkare kwian geru jwannga ulita kledu mo ka dodadeda ongoru ongoru ama kledu chage modi batre, malen ama ulita jo chke gwa uge gire Jesu geru kadu ama ulitage: —¿Ba ulita kledu mo ka dodadeda llema giti ongoru ongoru jonkare? ¿Geru mine giti ba kledu mo ka dodadeda jonkare? Jesu geru kadu kwian geru jwanngage ene, gire ni kwian gdaite jaindunga ama kalen, ama ulita chegu kamne, ulia jonkare ama ulita kledu gerule modi chema be chege ma kweri Chube gwa giti daba na ulitage, ama ulita ibudu gerule Jesu ole llema giti ama kledu gerule modi jonkare malen ama ulita me jaindunga Jesu kalen. ");
INSERT INTO sabNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Agwa uñadu Jesuge ama ulita kledu gerule llema giti. Jesu toidu dba gire ama kwian geru jwannga gdataboko giti gdaboke ulita kadu mo gitigu, Jesu gerudu ama ulita ole: —Kwian bai kaire chegekalin ma kweri daba nage, kwian ene sugedale moge ma soli daba nage, ama mo ta gbadale daba na ulita chudaboi ta no ole age no daba ulita alin. ");
INSERT INTO sabNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Jesu gerudu ene gire Jesu kirogwa soli gdaite kle ne ngwadi gau kote ama kirogwa gbu toi dba mo skwagda giti kwian ulita gwa giti, Jesu gerudu: ");
INSERT INTO sabNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Kwian bai kaire no cha ole ulia, kwian ene kle kirogwa ai kare gai ngwange no kle age no ama alin, kwian age ene me kle kirogwa alin allabi gai ngwange no, kaire ama kle cha gai ngwange no kle age no cha agali alin kare. Ene kaire kwian bai kaire cha gai ngwange no, kwian ene kle Chube cha kaganga nga dba ai giti gai ngwange no kaire —Jesu gerudu ene kwian geru jwannga amage ole. ");
INSERT INTO sabNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Gire Juan gerudu Jesu ole: —Cha tkanga tangle geruge, cha ulita gwagedu kwian gdaitedi dolla kage siere daba jwligebangage, kwian e gerudu ama kledu dolla kage siere dabage ba kiralla giti. Ama me kle chage che ole malen cha gerudu ama ole ama me ñage age ene dare. ");
INSERT INTO sabNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesu gerudu: —Ba me gerule ama ole ama me ñage age ene dare, ba me ñage mo gbe ma kweri amage. Kwian ulita bai kaire kle lle daga ngwale no dodade cha kiralla giti, kwian ene mi gerule blike me no cha dollale, ama be gerule no cha giti. ");
INSERT INTO sabNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ulia kwian bai me kle age che dollale, kwian ene kle age che bale kle che chudaboi, ba me ka boi ama ole. ");
INSERT INTO sabNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Cha gerule ba ole, kwian bai kaire tai dage ba cha gerua gangage age no ba alin ba cha gerua dbe gdale ama chi kete bage jadale ba siechie gire, kwian ene alin Chube be age no kwian ba chudabo ñanale. ");
INSERT INTO sabNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jesu gerudu dare: —Cha gerule ulia ba ulita ole, kwian bai kaire age me no kwian chanu ole kwian cha gerua gaba ulia me sbali kwian na daba ene ta gbeni bliteni naskuni age gweale me no Chube dollale, ma no kwian daba gbanga age me no ene alin ke kweri lugaba mo siroge mlienga ble jereske age me no giti gdale kwian chanu ole, ene kwian e be jogekeda mi ñage chege dare kwian chanu ta gbe age me no joge siere cha geruage. ");
INSERT INTO sabNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kaire sugedale bage ba agali kle mo gbe age me no. Ba ta agekalin gweale me no mo ko gdaite giti, ba mo ta gbadale me tañachuge dare age me no ene kare ko e giti, ba age me no ene talla chuge ngwadi, e salengwli ba mo ko tkenga kare, ene ba me age me no dare mo ko giti kare. Ma no ba alin joge ko bitale ole toi Chube ole nga ngaña giti diali dale alin ba agedu no Chube takalin kare ñanale, agwa me no ba alin joge ko no gdabonate ole ji chuge tirare ngwadi boi daga ngwale jitaske ba agedu me no mo ko giti Chube dollale ñanale, jita e kle ngwadi mi jogeda dale jita e chege diali gwade tirare kwian agenga me no gbagda boi daga ngwale chui tangle. ");
INSERT INTO sabNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ji chuge daga ngwale ngwadi lle ulita joge chegale sugaska gutaba gwita kote, gwita e ulita mi jogekeda dale. Kaire jita diali be kle gwade kwian agenga me no gbagda boi daga ngwale, jita e mi joge gwabada jita e chege diali chui tangle. ");
INSERT INTO sabNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Kaire ba sera giti ba jogekalin age gweale me no, ba mo ta gbe mo sera tkenga kare ene ba me tañachuge dare age me no mo sera giti, ba agedale salengwli ba sera bitale kare ene ba me ñage age me no mo sera giti ba takalin kare. Ma no ba alin joge sera bitale ole toi Chube ole nga ngaña giti diali dale alin ba agedu no Chube takalin kare ñanale, agwa me no ba alin ba joge mliabanga sera no gdabonate ole ji chuge tirare ngwadi boi daga ngwale ba agedu me no mo sera giti Chube dollale ñanale. ");
INSERT INTO sabNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ji chuge daga ngwale ngwadi lle ulita joge chegale sugaska gutaba gwita kote, gwita e ulita mi jogekeda dale. Kaire jita diali be kle gwade kwian agenga me no gbagda boi daga ngwale, jita e mi joge gwabada jita e chege diali chui tangle. ");
INSERT INTO sabNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Kaire agwe ba gwage lle gwealedi mo gwagwa giti gire gwage edi giti ba ta agekalin gweale me no, ba me mo chuge ngwadi gwage lle edi dare tañachuge lle e giti dare, ma no ba mo linge siere lle ege. Ba agedale salengwli ba gwagwa gbaite jo jwanba siere kare ene ba me ñage gwage lle me nodi ba takalin kare. Ma no ba alin joge gwagwa gbaitre alin ole toi Chube ole nga ngaña giti diali chui tangle ba agedu no Chube takalin kare ñanale, agwa me no ba alin joge mliabanga gwagwa gbabonate no ole ji chuge tirare ngwadi boi daga ngwale ba agedu me no Chube dollale ñanale. ");
INSERT INTO sabNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ji chuge daga ngwale ngwadi lle ulita joge chegale sugaska gutaba gwita kote, gwita e ulita mi jogekeda dale ne ngwadi, kaire jita diali be kle gwade kwian agenga me no gbagda boi daga ngwale, jita e mi joge gwabada jita e chege diali chui tangle. ");
INSERT INTO sabNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Cha gerule ulia ba ulita ole, che me takalin samla tuge gire che cho bate ngle samlage, ene samla me joge chegale, e kare ene Chube kle ba kwian amanu gbe boi daga ngwale gweale ba ta gbagda ama gai ma ngle, ene ba me mo ta blite age me no Chube dollale. ");
INSERT INTO sabNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Cho mana noare, agwa cho joge skeke gire che me ñage cho gbeni naskuni bale, che cho skeke mliadalenga, cho e ngwale. E kare ene ba kle gerule modi chema chema ma kweri daba na ulitage, ba mo gbakalin ma kweri daba nage ba me ñage lle boi no Chube alin, ene ba kle chege cho skeke kare ngwale. Ba me mo gbe ma kweri daba nage, ba mo ta gbadale toi no daba na ulita ole daba ulita chudaboangale —Jesu gerudu ene ulita kwian geru jwannga amage ole. ");
INSERT INTO sabNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesu jo siere una Capernaumge ule kwian geru jwannga amage ulita ole, ama ulita jo nga Judeage, jo chke chi Jordánge ama jo chi kagda giti ongoru. Ne ngwadi kwian tanre litedu Jesudi tangle gire Jesu kwian tku tangle Chube giti ama kle age diali kare. ");
INSERT INTO sabNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Kwian fariseo gweale chku Jesudi mo chuge Jesu ole, ama ulita takalin Jesu gerule gweale me no Moisés chadalla dollale, ene ama ñage Jesu gbe jiske e gdale, ta ene ole kwian fariseo ulita geru kadu Jesuge: —Cha geru kade bage, ¿kwian onbre mo jwanba ñage mo muiralla chuge ngwadi? ¿Age ene e skwen no Chube gwa giti o skwen me no Chube gwa giti? ");
INSERT INTO sabNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesu jaindunga: —Kaire cha geru kade bage, Moisés Chube gerua degu unsuialin, ¿chada e gerule mine muinga chuge ngwadi giti? ");
INSERT INTO sabNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Kwian fariseo jaindunga Jesu kalen: —Moisés Chube gerua degu unsuialin chada e gerule onbre ta mo muiralla chugakalin ngwadi, onbre e chada degadale kete mo muirallage, chada e gerule muinga e me amanu dare, onbre age ene gire onbre ñage mo muiralla chuge ngwadi. ");
INSERT INTO sabNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Gire Jesu gerudu: —Kwian ulita me age Chube takalin kare, kwian me no kwian ta agekalin mau tale me no kwian takalin kare, malen Chube Moisés ta gbu chada dege kwian ulita alin ene kwian ulita tachke ama me agedale me no. ");
INSERT INTO sabNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Kaire Chube Moisés ta gbu chada dege unsuialin gwange jondege alin nga ulita lle ulita jo dodaba giti, chada e gerule: “Chube kwian onbre dodadu kwian muire dodadu.” ");
INSERT INTO sabNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","Kaire chada e amaña gerule: “Chube kwian dodadu ene onbre muire, malen kwian onbre mo jwankalin muinga ole, ama mo ñenua mo chebia chugadale ngwadi mo ta gbe ule muinga ole gire ene ama gdabonate chege kwian gdaitre alin kare ta salengwli ole.” Moisés Chube gerua degu ene. Nege cha gerule ba ulita ole, kwian mo jwanba me chege kwian gdaboke kare, agwa Chube gwa giti ama boke chege kwian gdaitre alin kare onbre muinga ole muinga onbre ole, ama boke ta chegedale ule salengwli. ");
INSERT INTO sabNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ulia me no kwian onbre mo gbe sugekare mo muirallage, Chube muinga ketu onbrege, Chube onbre ketu muingage, Chube kwian gbu mo jwen ene, malen onbrenu muirenu me ñage age ama takalin kare, onbre joge siere muingage o muinga joge siere onbrege, e me no Chube gwa giti —Jesu gerudu ene kwian fariseo ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Bigire Jesu jo gwa ule kwian geru jwannga amage ulita ole, kwian geru jwannga geru kadu Jesuge: —Jesu, cha takalin ba cha ulita ta gbe dare ba gerudu giti kwian fariseo ole onbre mo muiralla chuge ngwadi giti. ");
INSERT INTO sabNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesu gerudu kwian geru jwannga ole: —Cha gerule ulia ba ulita ole, kwian onbre bai kaire mo muiralla chuge ngwadi gire mo jwen muinga na ole, onbre e kle age me no Chube gwa giti, Chube gwage e salengwli onbre e kle mo chuge ke giti muinga e ole kare, kaire onbre e kle age me no muinga ngeru dollale. ");
INSERT INTO sabNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Kaire agwe muinga mo ñengulalla chuge ngwadi gire mo jwen onbre na ole, muinga e kle age me no Chube gwa giti, Chube gwa giti e salengwli muinga e kle mo chuge ke giti onbre na ole kare —Jesu gerudu ene kwian geru jwannga amage gdataboko giti gdaboke ole. ");
INSERT INTO sabNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Kirogwa ñenua kirogwa chebia tanre chiu mo kirogwalla soli dbe Jesu kle ngwadi, kirogwa ñenua chebia takalin Jesu ko gbe kirogwa soli e giti gerule Chube ole Chube age no kirogwa alin Chube kirogwa manade no. Kwian geru jwannga Jesuge ulita gwagedu kwian tanre edi chie kirogwa dbe Jesuge gire ama ka bo kirogwa ñenua ole chebia ole: —¿Lledale ba kle chie kirogwa dbe Jesuge? ¡Joga, joga siere, ba me chie kirogwa dbe Jesuge! ");
INSERT INTO sabNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesu gwagedu kwian geru jwanngadi ka boi kirogwa ñenua ole chebia ole me ñage kirogwa dbe Jesuge, gire Jesu ta skochiu tanre kwian geru jwannga ulitadi, Jesu gerudu kwian geru jwannga ole: —Me no ka boi ene kirogwa ñenua ole chebia ole, ba ama chugene chie mo kirogwalla dbe chage. Kirogwa soli ta kle biale Chube gerua gai ulia blike, kirogwa talla ene kare Chube takalinge, kwian ulita bai kaire mo ta gbe ulia Chube ole kirogwa talla ene kare ole, kwian ene chege Chubenu, ama be toi diali chui tangle Chube ole. ");
INSERT INTO sabNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Cha gerule ulia ba ulita ole, kwian ulita bai kaire me mo ta gbe kirogwa talla kare Chube ole, kwian ene me ñage toi ule Chube ole, ama be chege sugekare Chubege. ");
INSERT INTO sabNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Jesu gerudu ene kwian geru jwannga ole gire kirogwa ñenua chebia ulita chiu mo kirogwalla dbe Jesuge, Jesu kirogwa soli ulita gdaite gdaite gau kote, ama ko gbu kirogwa ulita giti gerudu Chube ole Chube age no kirogwa alin kirogwa manade no. ");
INSERT INTO sabNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesu jo chage dare gwangerugu, gire onbre gdaite chiu jrite Jesu ngnagu jonkare, onbre e mo jongnagwa skutu dba Jesu ngwange Jesu gai dage gire ama gerudu Jesu ole: —Ba kwian tkanga tangle noare, cha takalin ba geru kete chage, ¿cha llema boadale nga dba ai giti gire ene cha ñage toi no diali chui tangle Chube ole nga ngaña giti? ");
INSERT INTO sabNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesu jaindunga kwian e kalen: —¿Mineade ba gerudu cha no? Ulia ni kwian gdaite no trate, Chube alin allabi no trate ulita. ");
INSERT INTO sabNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Bage uñale trate Chube nu geru gbaba kwian ulita alin kwian toidale mine Chube gwa giti, Moisés Chube gerua e degu unsuialin ba chada e uñe trate, chada e gerule: “Ba me daba gweda. Ba onbre mo jwanba me mo chuge ke giti muinga na ole, ba muinga mo jwanba me mo chuge ke giti onbre na ole. Ba me skwe boi daba ngeru. Ba me geru jinade ngwale daba na dollale. Ba me gerule ngwale daba anblitagda lle amanu jwennga ama ngeru mau alin. Ba mo ñenua mo chebia gai dage.” Moisés Chube gerua degu ene unsuialin kwian ulita alin, ba agedale ulita geru e kle degaba kare. ");
INSERT INTO sabNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Jesu gerudu ene kwian onbre ole gire kwian onbre e gerudu Jesu ole: —Cha kledubi soli gwangeabi cha jo juma gdate cha kle geru e ulita gai dage age ulita geru e kle gbaba kare. ");
INSERT INTO sabNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesu gwagedu kwian onbre edi Jesu ta no onbre e ole, Jesu gerudu: —Noare ba kle age ene, agwa cha gerule ba ole, ba mo ta gbadale age na gdaite. Joga, lle banu ulita chbade, igi ulita lle e ñana ba kete kwian me lle molenge. Ba age ene ulita gire ba chieni cha kle ngwadi ba mo ta gbe chage cha ole diali geru jwen chage. Gire ene ba be kle biale joge toi diali Chube ole nga ngaña giti, Chube be age no ba alin ba agedu no ñanale. ");
INSERT INTO sabNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kwian onbre Jesu keruchugu gerule ene gire ama chegu ta olire tanre, onbre e lle molen tanre, malen ama me tadu lle ulita chbadakalin Jesu gerudu kare ama ole, ama jo siere Jesuge ta olire ole. ");
INSERT INTO sabNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesu gwagedu modi tangle, Jesu gerudu kwian geru jwannga amage ulita ole: —Ulia mnoare kwian lle molen tanre alin Chube gerua gai ulia mo ta gbe age ulita Chube takalin kare. Agwa kwian me age ene kwian me ñage toi diali chui tangle Chube ole nga ngaña giti. ");
INSERT INTO sabNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Kwian geru jwannga Jesuge ulita chegu tañachuge tanre Jesu gerudu giti gire Jesu gerudu dare ama ole: —Ba ulita cha olia kare, cha gerule ulia ba ole, mnoare kwian lle molen tanre Chube gerua gai ulia mo ta gbe age ulita Chube takalin kare. ");
INSERT INTO sabNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Uñale bage bda kweri kada camello me ñage joge tangle agu kwebege, camello kweriare, ene kaire kwian lle molen tanre alin mnoare Chube gerua gai mo ta gbe age Chube takalin kare. Kwian ene kle mo ta dbe no no lle amanu tanre ulita ole malen mnoare ama alin mo ta gbe lle amanu chuge ngwadi Chube gerua gai ulia mo alin age Chube takalin kare, mnoare kwian ene alin mo ta dbe ma no Chube ole ama kle mo ta dbe no lle amanu olege. ");
INSERT INTO sabNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kwian geru jwannga Jesuge Jesu keruchugu gerule ene gire ama ulita chegu tañachuge tanre ma ngle geru e giti, ama geru kadu moge ongoru ongoru: —E ene ulia mnoare age Chube takalin kare ama kle gerule kare, gire ¿chema ñage age ulita Chube takalin kare, ene toi no diali chui tangle Chube ole nga ngaña giti? Ni kwian gdaite ñage age ene. ");
INSERT INTO sabNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesu gwagedu ama ulitadige, Jesu gerudu: —Kwian agali gballa me ñage age ulita Chube takalin kare me ñage age mau alin agali toi diali chui tangle Chube ole. Agwa Chube alin allabi ñage kwian kira gbe age ulita Chube takalin kare, ñage kwian gbe toi diali chui tangle ama ole. Chube alin allabi ñage age ulita, lle ulita me mno ama alin boadale. ");
INSERT INTO sabNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Gire Pedro gerudu Jesu ole: —Cha ulita geru jwannga bage kle chage ba ole diali geru jwen bage, cha ulita lle ulita chanu nga dba ai giti chugu ngwadi gire cha ulita mo ta gbu chage diali ba ole baini kaire ba kle joge ngwadi, cha ulita agedu ulita ba gerudu kare onbre lle molen tanre ole. ");
INSERT INTO sabNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Jesu gerudu: —Cha gerule ulia ba ulita ole, kwian ulita bai kaire mo ta dbe ma no cha ole kwian kle mo ta dbe no mo bitalla ulita olege lle ulita amanu olege, kwian ene ta kle biale lle amanu chuge ngwadi kaire mo bitalla chuge ngwadi cha gerua dbe gdale. Kwian e ulita bai lle amanu gweale o mo bitalla gweale chuge ngwadi age cha takalin kare cha gerua dbe, kwian enege Chube be lle tanre no kete kwian ene age cha takalin kare ñanale. Kwian u chuge ngwadi, kwian dbi chuge ngwadi, kwian mo daballa chuge ngwadi, kwian mo ibotea chuge ngwadi, kwian mo chebia chuge ngwadi, kwian mo ñenua chuge ngwadi, kwian mo kirogwalla chuge ngwadi, kwian bai mo ta gbe lle gweale o bitalla gweale chuge ngwadi ene cha gerua dbe kwian nage gdale, kwian enege Chube be lle ma no ma ngle kwian e nu lle chugaba ngwadige kete amage nga dba ai giti kwian ene age cha takalin kare ñanale. Chube be age no kwian ene alin kwian ene be chege lle ulita ma ngle ole, kwian enege Chube be u na kete toingwa, kaire Chube be dbi na kete amage, kaire Chube be daballa na ibotea na chebia na ñenua na kirogwalla na kete kwian enege. Ulia Chube be bitalla kaire lle ma ngle keteni kwiange kwian mo ta gbu cha gerua dbe daba nage ñanale agwa kaire kwian ene be boi daga ngwale tanre cha gerua dbe gdale. ");
INSERT INTO sabNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Cha gerule ba ulita ole, nege nga dba ai giti kwian gweale kle suge moge ma kweri daba nage, chui bdaglige kwian ene be ma soli Chube gwa giti Chube ngwadi. Agwa nege nga dba ai giti kwian gweale suge moge ma soli daba nage, chui bdaglige kwian ene be ma kweri Chube gwa giti Chube ngwadi —Jesu gerudu ene ulita kwian geru jwannga amage ole. ");
INSERT INTO sabNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jesu jo chage una Jerusalén ngnagu, kwian geru jwannga amage gdataboko giti gdaboke kledu chage Jesu nate tañachuge tanre Jesu gerudu giti. Kaire kwian na tanre kledu chage Jesu nate ta kennga ole. Jesu kwian geru jwannga amage ulita kadu sugekare kwian ngleage gerule nakwaite ama ole Jesu be boi giti ulita, ");
INSERT INTO sabNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Jesu gerudu: —Bage uñale che ulita kle joge una Jerusalénge, una ege kwian be age cha dollale, cha ketabe boalenga daga ngwale kwian gerunga Chube ole daba alin chugagwalla ulitage kaire kwian daba tkanga tangle Moisés chadalla giti ulitage, kwian e ulita me kle cha gerua gai ulia Chube cha kagu nga dba ai giti kwian kare, malen ama be gerule cha jogedaleda cha jiske kweri Chube gwa giti kbiale, ama ulita be cha kete kwian me israelitage gwaleda. ");
INSERT INTO sabNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Kwian me israelita e ulita be kidere tanre chadi, ama be jolo tke cha giti, ama be cha bate tanre obere giska giti be age ene ulita dagale cha ole gire bdagli ama be cha gweda. Cha gwabeda agwa chui mongikege cha jaba be chkeni gwadeni —Jesu gerudu ene ulita kwian geru jwannga amage ole ama ta gbagda Jesu be boi giti una Jerusalénge. ");
INSERT INTO sabNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Santiago kaire Juan ama gdaboke Zebedeo kirolla, ama jo kodi Jesu gitigu gire ama gerudu Jesu ole: —Cha tkanga tangle geruge, cha takalin ba age no cha alin cha be kade bage kare. ");
INSERT INTO sabNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesu geru kadu amage: —¿Ba takalin cha age mine ba alin? ");
INSERT INTO sabNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ama gdabonate jaindunga Jesu kalen: —Ba chuia be chke gire ba be chege kwian ulita Chugagwalla ma kweri, chui ege cha gdaite toikalin dba ba ko jole giti cha gdaite toikalin dba ba ko taingwli giti, cha gdabonate ta chegekalin kweri ule ba ole daba chugagwallale. ");
INSERT INTO sabNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesu gerudu ama ole: —Bage me suge ba kle llema kade chage. Ulia cha gbabe boi daga ngwale kaire cha gwabeda Chube gerua gdale, gire cha geru kade bage, ¿ba kle biale boi daga ngwale ene cha be boi kare? ¿Ba kle biale jogeda cha be jogeda kare? ");
INSERT INTO sabNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Gire ama gdabonate jaindunga: —Ima, cha ñage mo kete boange daga ngwale ba gerua gdale ba be boi daga ngwale kare. Jesu gerudu: —Ulia ba be boi tanre daga ngwale cha kare cha gerua gdale, ");
INSERT INTO sabNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","agwa cha me ñage gerule ba ole cha chuia be chke gire ba be chege toiba dba cha ko jole giti cha ko taingwli giti daba chugagwallale ma kweri daba na ulitage. Cha me ñage gerule ene, cha e jige Chube kote, Chube alin allabi ñage kwian gbe kweri daba chugagwallale toi dba cha ko jole giti cha ko taingwli giti chui bdaglige —Jesu gerudu ene Santiago ole Juan ole. ");
INSERT INTO sabNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Kwian geru jwannga Jesuge na ulita gdataboko geru e keruchugu gire ama ulita skochiu tanre Santiagodi kaire Juandi ama boke gerudu Jesu ole gdale. ");
INSERT INTO sabNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesu kwian geru jwannga amage ulita kadu mo gitigu gire Jesu gerudu ama ulita ole: —Bage uñale nga ulitage nga dba ai giti kwian chugagwalla ulita kle kwian kage age chugagwalla takalin kare, kwian agedale ulita chugagwalla kle gerule kare, kwian chugagwalla kle kwian kage age chugagwalla takalin kare, ene chugagwalla suge moge kweri. ");
INSERT INTO sabNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","44","Agwa ba ulita me ñage tañachuge kwian chugagwalla nga dba ai giti ulita kle tañachuge kare, ba tañachugadale nganake. Ba me mo ta gbe daba kage age ba takalin kare, agwa ba mo ta gbale diali age no daba na ulita alin daba chudaboi ta no giti, ba age ene gire Chube gwa giti ba chege kweri daba chugagwallale. ");
INSERT INTO sabNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ba ulita tañachugadale cha kle tañachuge kare. Cha chiu nga dba ai giti kwian kare, cha me chiu kwian kagangale age no cha alin cha chudaboi, agwa cha chiu kwian ulita chudaboangale, cha chiu age no kwian alin kwian chudaboi kaire cha chiu mo ketale gwaleda kwian ulita alin, ene cha jogeda giti cha kwian jwen siere ji chugege ama agedu me no gdale —Jesu gerudu ene ulita kwian geru jwannga amage ole. ");
INSERT INTO sabNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jesu kledu chage una Jerusalén ngnagu ule kwian geru jwannga amage ulita ole gire ama ulita jo chke una Jericóge. Jesu jo tangle una ege, kwian geru jwannga amage kaire kwian na tanre jo chage ama ole ama gatedi. Jesu kledu chage kwian tanre ole gire Jesu tendu kwian gdaite ngwange jonke, kwian e gwagwa me ama kledu toiba dba jonke igi kade kwian nage, kwian e kadakle Bartimeo ama Timoteo kirolla. ");
INSERT INTO sabNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Bartimeo kwian na keruchugu gerule Jesu una Nazaremu kle chage ngmadi gire Bartimeo mo gbu ngaute Jesuge: —¡Jesu, ba kwian chugagwalla kweri unsuialin David oindalla, ba tai dage chage! ");
INSERT INTO sabNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Kwian tanre Bartimeo keruchugu ngaute ene Jesuge, gire kwian ka bo jabale Bartimeo ole ene ama ka chite ngaute, agwa Bartimeo me ka chitedu, ama mo ta gbu ngaute gwangerugu ma ngle: —¡Jesu, ba kwian chugagwalla kweri unsuialin David oindalla, ba tai dage chage! ");
INSERT INTO sabNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesu Bartimeo e keruchugu ama me chagedu dare, Jesu chegu jagenga gdate jonke, Jesu gerudu kwian na ole: —Ba kwian e kade chie cha gitigu. Kwian ngautu Bartimeoge: —¡Chkede gdate nga suga no ole! Bai aini, Jesu kle ba kade mo gitigu. ");
INSERT INTO sabNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Bartimeo kwian keruchugu gerule ene gire blike ama ñometra kledu mo bliabaske jigu mliabanga, ama chku gdate blikare, jo Jesu gitigu. ");
INSERT INTO sabNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesu geru kadu Bartimeoge: —¿Ba takalin cha llema boi ba alin ba chudaboagda? Bartimeo jaindunga Jesu kalen: —Cha ba gai kweri, cha takalin ba cha gwagwa dodade ba cha gbe ten. ");
INSERT INTO sabNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesu gerudu ama ole: —Ba mo ta gbu ulia cha ole malen cha ba gwagwa ulita dodade, ba ñage jogeni gudegu. Jesu gerudu ene Bartimeo ole gire sugetibi allabi Bartimeo gwagwa ulita trendu no trate, ama ñadu ten no trate, gire ama jo chage Jesu nate Jesu gatedi. ");
INSERT INTO sabNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jesu jo chage dare una Jerusalén ngnagu jo chke kodi una Jerusalénge ule kwian geru jwannga amage gdataboko giti gdaboke ole, una soli boke kada Betfagé kada Betania chege kodi kodi una Jerusalénge Ngwiskinro Jwichugalla gdoge dba. Ama ulita jo chke ne ngwadi, gire Jesu kwian geru jwannga amage gdaboke kagu mo ngeru, ");
INSERT INTO sabNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Jesu gerudu ama boke ole: —Joga gdabonate cha ngeru, una soli kle ngeruge, ba be joge chke una soli ege burro soli be skwen bage ba ngwange lugabada glige, burro soli e giti ni kwian gdaite nu chageba bitaite giti, burro e ba skatrennga, ba chie dbe chage. ");
INSERT INTO sabNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kwian gweale geru kade bage: “¿Lledale ba kle burro soli e skatrennga?” Ba gerule kwian e ole: “Cha Chugagwalla takalin burro soli aige, me sbali ama be burro soli ai kageni naskuni aini.” ");
INSERT INTO sabNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Jesu gerudu ene ulita gire kwian geru jwannga gdaboke e jo Jesu ama kagu kare, amage burro soli skwendu lugabada jonke kodi ugakage. Kwian geru jwannga jo chke burro solidi, ama kle burro soli skatrennga dbadale, ");
INSERT INTO sabNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","gire kwian gweale kledu eni geru kadu amage: —¿Ba kle llema boi? ¿Lledale ba kle burro soli e skatrennga? ");
INSERT INTO sabNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ama jaindunga kwian kalen Jesu gerudu kare ama ole: —Cha Chugagwalla takalin burro soli aige, me sbali ama be burro soli ai kageni naskuni aini. Kwian geru jwannga gerudu ene gire kwian ama chugu ngwadi burro soli dbe. ");
INSERT INTO sabNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Kwian geru jwannga boke chiu burro soli dbe Jesu kle ngwadi, ama mo ñometralla gitiru gbu burro soli trigda giti Jesu alin, gire Jesu skwendu burro soli giti, burro soli giti Jesu jo chage una Jerusalén ngnagu. ");
INSERT INTO sabNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Kwian tanre kledu Jesu ngwange jon jegwale kwian e ngle mo ñometralla gitiru treun dba jonkare Jesu gai ngwange no mo Chugagwallale kweri, kwian gweale na ugananga tkunga gbu jonkare, e giti burro soli chagedu Jesu gwaru. ");
INSERT INTO sabNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","10","Kwian tanre chagedu Jesu gwangerudba kaire Jesu natedba, kwian e ulita kledu ngaute nga suga no ole Jesu giti: —¡Nga suga no chadi ba giti! Noare ba chiu cha ulita Chugagwallale, suge chage ulia Chube kle ba gbe kweri cha Chugagwallale salengwli Chube che enusulian David gbu kweri kwian chugagwallale unsuialin kare. Noare Chube ba kagu nga dba ai giti cha ulita alin, Chube kle nga ngaña giti, ama noare ama kweri, ama kle age no tanre cha ulita alin ba giti —kwian tanre ngautu ene jonkare Jesu gai ngwange no Jesu gai mo Chugagwallale kweri. ");
INSERT INTO sabNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesu jo chke una Jerusalénge gire ama jo u gerungwa Chube olege, ne ngwadi Jesu gwagedu lle ulita kle boidi u ege, Jesu ta olidu kle boi giti, Jesu tadu agekalin gweale ene me boi dare eni, agwa nga jeredu malen ama joni kwian geru jwannga amage gdataboko giti gdaboke ole una soli Betaniage chege gbe eni. ");
INSERT INTO sabNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Nagbietege ngabebita Jesu jo siere una Betaniage joni chage naskuni una Jerusalén ngnagu ule kwian geru jwannga amage ole, ama ulita kledu chage jonkare gire Jesu bli ole Jesu tadu blikalin. ");
INSERT INTO sabNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Jesu gwagedu bate mo ngeru gli kada higueradi, Jesu gwagedu gliga tanre kle gli ege, Jesu jo gli e gitigu gligba gweale jwen gutadale, gligba me skwenduge gutadale glinanga jegwale, gliga alin skwendu Jesuge, higueragba suia bebi chke higuerage, bebi gbachie. ");
INSERT INTO sabNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Gire Jesu gerudu higuerage: —¡Chui aige gwangerugu ba mi gbachie dare, ni kwian gdaite be ñage ba gba gute! Kwian geru jwannga Jesuge ulita Jesu keruchugu gerule ene gli higuerage. ");
INSERT INTO sabNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Bigire Jesu jo chkeni una Jerusalénge ule kwian geru jwannga amage ulita ole, Jesu jo u gerungwa Chube olege, u ege kwian tanre skwendu Jesuge lle chbade lle gige kaire kwian kledu igi blite daba na ole u ege. Jesu gwagedu kwiandi age ene ulita, gire Jesu ama ulita kagu siere, Jesu mesa igi blitangwa blitunga ulita kaire Jesu kwian beusi chbadanga toingwalla blitunga ulita, ene kwian me ñage lle chbade dare eni. ");
INSERT INTO sabNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Jesu agedu ene, gire ama ni kwian gdaite chugu ngwadi chage dare lle dbe u gerungwa Chube olegedi tangle. ");
INSERT INTO sabNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Kaire Jesu kwian tku tangle trate u gerungwa Chube ole giti, Jesu gerudu: —Uñale bage Chube gerua degaba unsuialin gerule u ai giti, chada e gerule: “Chube gerudu: ‘U ai chanu chegedale u gerungwa cha alin ole allabi kwian nga ulitamu alin.’ ” Chube gerua kle degaba ene, agwa ba ulita kle u ai gai mo alin, ba kwian skwere, ba kle lle chbade dabage kwangleare, ene ba igi gai ngle mo alin, Chube gwage e me no, e salengwli ba kle u Chubenu gai mo alin skwe boangwa daba na ngeru kare —Jesu gerudu ene ulita kwian ole. ");
INSERT INTO sabNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Kwian gerunga Chube ole daba alin chugagwalla ulita kaire kwian daba tkanga tangle Moisés chadalla giti ulita kledu ne ngwadi, ama Jesu keruchugu gerule ene ulita gire ama mo ta gbu age gweale mo ten modi Jesu dollale ama ulita ñage age mine Jesu gwangeda. Kwian na tanre diali kle mo ta gbe Jesu keruchuge ulita no, malen e giti kwian gerunga Chube ole daba alin ulita kaire kwian daba tkanga tangle Moisés chadalla giti ulita semadu Jesu ole, ama ulita kendunga kwian na tanre be chage Jesu gerua nate me ama gerua nate, malen ama tadu Jesu gbe jogekeda. ");
INSERT INTO sabNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Agwa nga jo jere gire Jesu kaire kwian geru jwannga amage ulita jo siere una ege, ama ulita joni una Betaniage. ");
INSERT INTO sabNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Nagbietege ngabebita Jesu joni chage nakwaite una Jerusalén ngnagu ule kwian geru jwannga amage ulita ole, ama ulita jo tangle kodi gli higuerage Jesu nu geruba ole. Ama ulita gwagedu gli edi drale, gli nu kwebanga ulita, gli sera ulita junbatebanga. ");
INSERT INTO sabNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pedro tachku boidu giti higuera ole gire ama geru kadu Jesuge: —Cha tkanga tangle geruge, gwage higueradi. Ba ka bo gli e ole me gbachie dare, gire ulia gli e kwedunga jokeda ulita. ");
INSERT INTO sabNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesu jaindunga: —Ba mo ta gbadale ulia Chube ole, ene ba ñage age ulita cha kle age kare. ");
INSERT INTO sabNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Cha gerule ulia ba ole, ba cha keruchuge no no. Ba bai kaire mo ta gbe ulia Chube ole Chube gai ulia me tañachuge ni sidri mo tale Chube me ñage age ba alin ba kade Chubege kare, ba mo ta gbe ulia ene Chube ole gire Chube kiralla giti ba ñage age ulita. Ba ñage gerule jwichuga aige: “¡Joga siere nga aige, joga bleske!” Ba gerule ene jwichugage mo ta gbaba ulia Chube ole giti gire Chube be jwichuga kage bleske ba gerudu kare. ");
INSERT INTO sabNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","E kare ene ba gerule Chube ole lle gweale giti ba takalin ama age ba alin kare, kaire ba mo ta gbe ulia Chube ole Chube be age ba alin ulia ba gerudu ama ole kare, ba lle kade Chubege ta ene giti gire ulia Chube be age ba alin ba tadukalin kare. ");
INSERT INTO sabNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Agwa ba kle biale gerule Chube ole gire ba tale talla me no kle daba gweale agedu me no ba ole giti, ba talla e mliadalenga me tañachuge daba agedu giti ba ole dare, gire ene kaire che Ñenua Chube be ba agedu me no ama dollale talla mlienga kaire agwe. Ba age ene ulita gire ba ta kle biale gerule Chube ole. ");
INSERT INTO sabNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Agwa ba me daba agedu me no ba ole talla mlienga ba kle geru e oge mo tale, che Ñenua Chube mi ba agedu me no talla mlienga kaire. ");
INSERT INTO sabNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jesu gerudu ene kwian geru jwannga amage ole gire ama ulita jo chkeni nakwaite una Jerusalénge, Jesu jo u gerungwa Chube olege gire ne ngwadi kwian gerunga Chube ole daba alin chugagwalla mneite jo chke Jesudi kaire kwian daba tkanga tangle Moisés chadalla giti mneite kaire kwian israelita chugagwalla juma mneite ama ulita jo chke Jesudi gerule Jesu ole, ");
INSERT INTO sabNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ama ulita geru kadu Jesuge: —¿Chema ba kagu age ba kle age kare? ¿Chema kiralla giti ba kle age ulita? ");
INSERT INTO sabNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","30","Jesu jaindunga: —Cha kaire agwe geru kade gbaite bage: ¿Chema Juan-Bautista kagu? ¿Chube Juan-Bautista kagu kwian ñe chiske o kwian Juan-Bautista kagu kwian ñe chiske? Cha gerule ba ole, ba jainnga cha kalen chema Juan-Bautista kagu, gire cha be geru kete bage chema cha kagu age ulita cha kle age kare. ");
INSERT INTO sabNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Jesu gerudu ene gire kwian ulita bai geru kadu Jesuge chegu gerule tanre modi Jesu geru kadu amage giti: —¿Che jainnga mine Jesu kalen? Che gerule Chube Juan-Bautista kagu kwian ñe chiske gire Jesu be geru kade chege: “¿Gire mineade ba me Juan-Bautista gerua cha giti gau ulia?” ");
INSERT INTO sabNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Che me ñage gerule Chube Juan-Bautista kagu, agwa ni che ñage gerule kwian ngwale Juan-Bautista kagu, kwian tanre tañachuge Chube nu Juan-Bautista kagaba malen kle Juan-Bautista gerua gai dage ulia. Kwian geru tragu ene modi ama jainnga mine Jesu kalen giti. Ulia kwian tanre Juan-Bautista gerua gau ulia tañachuge Chube nu Juan-Bautista kagaba Chube gerua ulia kete kwian nage malen e giti kwian israelita chugagwalla ulita geru kadanga Jesuge kwachiu kwian ngleadi kwachiu gerule kwian ngwale nu Juan-Bautista kagaba daba ñe chiske Chube gwa giti, ama gerule ene gire kwian ngle ñage kira bate jabale ama ole Juan-Bautista gerua gdale. ");
INSERT INTO sabNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Malen kwian geru kadanga Jesuge jaindunga Jesu kalen: —Cha ulitage me uñale chema Juan-Bautista kagu. Gire Jesu gerudu ama ole: —Kaire agwe cha mi gerule ba ole chema cha kagu age ulita cha kle age kare aini ba gwa giti. ");
INSERT INTO sabNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Kwian israelita chugagwalla tanre kledu mo litaba Jesudi, ama alin Jesu geru ñachuge, Jesu gerudu: —Cha gerule ba ulita ole, kwian onbre gdaite uva ngama gbu gire ama gere gbu uva ngama giti tangle, kaire ama nga dodadu uvagba chia ogangwa, kaire ama dbi gweale jigu ngwale uva ngamaske u gbangwa, ama ke ulla dodadu jeike ngaña uva ngamaske uva manangwa. Uva ngama mauña lle e bo ulita bigire ama kwian gweale gau uva ngama manangale ama uva ngama ketu kaire u uva manangwa ketu uva ngama mananga ulitage, uva ngama mauña uva ngama jigu uva manangage gire ama jo toi nga batege sbali. ");
INSERT INTO sabNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Chui jo sbali gire uva mauñage chku uñale uvagba joge dabe suia chku, uva mauña kwian lle boanga mo alin gdaite kagu uvagba bonga amanu kade mo alin kwian uva manangage. ");
INSERT INTO sabNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Kwian lle boanga e jo chke kwian uva manangadige uvagba kade uva manangage, kwian uva mananga ulita daba e lle boanga uva mauña alin batu jabale agedu dagale daba e ole, kwian uva mananga ulita daba kaguni kole uva mauña ngwadi, me su uvagba kete ni malen gbaite dabage. ");
INSERT INTO sabNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Boidu ene gire kwian uva mauña lle boanga mo alin na kagu uvagba kade. Lle boanga e jo chke kwian uva manangadi, gire kwian uva mananga ulita daba e batu obere chugage agedu me no tanre daba dollale, uva mananga daba kaguni kole lendegaba uva mauña ngwadi. ");
INSERT INTO sabNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Boidu ene nakwaite gire uva mauña lle boanga na gdaite kagu uvagba kade kwian uva manangage agwa lle boanga e jo chke kwian uva mananga ngwadi ama bole ma jabale ama guleda. Chui nage uva mauña lle boanga na tanre kagu gdaite gdaite uvagba kade kwian uva mananga ulitage, gire uva mananga lle boanga gweale batu bo daga ngwale, lle boanga gweale na, uva mananga ama guda. ");
INSERT INTO sabNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Bdagli kwian gdaitre alin allabi chegu gwa uva mauña ole kagadale, kwian e uva mauña kirollanu, uva mauña no no mo kirolla e ole gire ama mo kirolla kagu, ama tañachugu mo tale: “Cha be mo kirollanu kage, uñale chage kwian uva mananga ulita be cha kirolla gai dage gai ngwange no.” Uva mauña tañachugu ene, malen ama mo kirolla kagu. ");
INSERT INTO sabNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Uva mauña kirolla medu jonkare uva manangage gire uva mananga gerudu modi ongoru ongoru: “Kwian chiu e uva ngama mauña kirolla, bdagli ama be chege ama ñenua llea ulita dbia ulita mauñale. Ale ama gweda, ene lle ulita be chege chege, che be chege uva ngama ai ulita mauñale.” ");
INSERT INTO sabNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Uva mananga ulita gerudu ene modi gire ama uva mauña kirolla gau guda jaba mliunga sugekare bate uva ngamallage. ");
INSERT INTO sabNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Jesu geru ñachugu ene ulita gire ama geru kadu kwiange: —¿Ba tañachuge mine geru e giti? Kwian uva mauñage be chke uñale boidu ulita ama kirolla ole gire ¿ama be age mine kwian uva mananga ulita ole? Cha gerule ulia ba ole, uva mauñage be chke uñale ama kirolla guleda gire ama be joge kwian uva mananga gweda ulita, ama be kwian na gbe uva ngama manade. ");
INSERT INTO sabNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ene kaire Chube be age kwian ole kwian bai me ama Kirolla gai ulia. ¿Ba me nu Chube gerua batabanga? Chube gerua degaba unsuialin gerule Chube Kirolla be boi giti, chada e gerule: “Kwian u dodanga ke gbu gerere ke gbaite ama mliunga ama gerudu ke e me no dale ke e ngwale, agwa ke e ama mliunga, ke e ma no ke na ulitage. Kwian ke gbu ulita gerere, nga bebi ke gbaite alin gere me kle kiraske, ke mliabanga gbere gerere gire u chegu kiraske. ");
INSERT INTO sabNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ai ulita Chube dodadu, malen nga suga noare chedi.” Chube gerua degaba unsuialin gerule ene. ");
INSERT INTO sabNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jesu gerudu ene ulita gire kwian israelita chugagwalla ulitage sugedu trate Jesu kle gerule ama giti ama ulita salengwli uva ngama mananga me no ulita kare, e giti ama ulita skochiu tanre Jesudi, malen ama tadu Jesu gakalin blike tkale skage, agwa me ñadu, kwian israelita chugagwalla ulita kendunga kwian ngleadi, uñadu amage kwian tanre no Jesu ole, ama age me no Jesu ole kwian gwa giti, kwian ulita be skochie amadi Jesu gdale, malen ama Jesu chugu ngwadi ne ngwadi, kwian israelita chugagwalla ulita joni siere. ");
INSERT INTO sabNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Kwian israelita chugagwalla mneite jo siere Jesuge ta skochie ole, ama ulita mo ta gbu Jesu tke gdege, ama takalin Jesu gerule gweale, ene Jesu tke skage Jesu gerudu giti. Malen ama ulita kwian fariseo gweale kaire kwian chugagwalla rey Herodes skatemanalla gweale kagu tienda Jesudi Jesu kle ngwadi mo chuge Jesu ole Jesu gbe gerule gweale chugagwalla kweri dollale giti. ");
INSERT INTO sabNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Kwian e ulita jo chke Jesudige gire gerudu Jesu ole: —Cha ulita ba gai kweri, uñale chage ba diali kle gerule ulia trate, ba kle mo ta gbe gerule ene diali me mo tallade kwian tañachuge mine badi giti, ba gwa giti kwian ulita salengwli, ba kle kwian ulita tke tangle salengwli geru ulia giti kwian toidale mine Chube takalin kare. Ba kwian ene malen cha geru kade bage gbaite, ba jainnga cha kalen ba tañachuge mine. Geru gbaba nga Romage kwian ulita igi ketadale kwian chugagwalla kweri emperador nga Romamuge, cha me kwian nga Romamu, cha kwian israelita, gire ¿no Chube gwa giti cha igi kete kwian chugagwalla kweri emperador nga Romamuge ama kle kade chage kare o me? ");
INSERT INTO sabNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","¿Ba gerule mine, cha igi e ketadale chugagwallage o cha me igi ketadale? —kwian geru kadu ene Jesuge ta me no ole. Jesuge uñadu trate kwian kledu mo ta gbe geru kade alin ngwale amage ama gbagda jiske, malen Jesu gerudu ama ulita ole: —¿Mineade ba cha batakalin gdege? Ba igi kete chage gaite gwagegda sugeti. ");
INSERT INTO sabNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Jesu gerudu ene kwiange gire igi ketre Jesuge, Jesu gerudu kwian ole: —¿Chema oña kle gbaba igi ai giti? ¿Kaire chema kalla kle gbaba igi ai giti? Kwian jaindunga Jesu kalen: —Kwian oña e chugagwalla emperador nga Romamu kada César, kaire ama kalla kle gbaba igi e giti. ");
INSERT INTO sabNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Kwian jaindunga ene gire Jesu gerudu: —Lle chugagwalla kweri Césarnu kaire keteni Césarge, lle Chubenu kaire keteni Chubege. Jesu jaindunga ene kwian kalen gire kwian chegu tañachuge tanre Jesu gerua no giti, ama me ñadu Jesu gbe jiske Jesu gerudu giti. ");
INSERT INTO sabNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Kwian saduceo mneite jo Jesu kle ngwadi geru kade Jesuge, kwian saduceo kle gerule kwian jogebakeda jaba mi chkeni gwade chui bdaglige, ama ulita tadu Jesu gbe gerule gweale Moisés nu Chube gerua degaba unsuialin dollale, ");
INSERT INTO sabNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","malen ama gerudu Jesu ole: —Kwian tkanga tangle geruge, uñale bage Moisés Chube gerua degu unsuialin tangle, chada e gerule kwian onbre jogekeda me kirogwa molen mo muira giti, gire ama daballa na kle gwade mo jwandale ñanea oli ole, onbre kirogwa molen muinga e giti daballa jogebakeda alin, ene daballa jogebakeda olia chege gdaite muinga e giti. Moisés chadalla gerule ene. ");
INSERT INTO sabNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Nege cha gerule ba ole boidu cha bitallaske giti, aini cha bitallaske onbre gdaguke modi mo daballale. Daballa kimule mo jun muinga ole, agwa ama jokeda ni ama kirogwa molen gdaite mo muira giti. ");
INSERT INTO sabNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Gire daballa nate mo jun ñanea ole, agwa daballa e kaire jokeda ni ama kirogwa molen gdaite muinga e giti. Gire onbre jogebakeda daballa na ama nate mo jun muinga amaña ole, agwa ama boidu salengwli ama daballa ngeru gdaboke kare, ama gdamai ulita jokeda ni muinga ko toidu kirogwage. ");
INSERT INTO sabNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Boidu ene ulita onbre gdaguke e ulita ole, ama ulita mo jun gdaite gdaite muinga amaña ole, muinga e chegu ama gdaguke muirale, agwa ulita gdaguke jokeda gdaite gdaite, ni ama gdaite kirogwa molen muinga e giti. Bdagli muinga gballa e jokeda kaire. ");
INSERT INTO sabNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Cha gerule ba ole, ulia onbre e gdaguke ulita toidu gdaite gdaite muinga amaña ole mo muira kare, chui bdaglige kwian jaba ulita be chkeni gwade chuiage, ¿chui ege onbre bai be chege muinga e ñengulallale? ");
INSERT INTO sabNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesu jaindunga kwian saduceo kalen: —Ba me kle tañachuge trate dale, ni geru ulia ba uñe. Ba me Moisés nu Chube gerua degaba unsuialin uñe trate, kaire me suge bage Chube kweri Chube ñage age ulita mo kiralla giti, malen ba me kle tañachuge trate e giti. ");
INSERT INTO sabNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Sugedale trate ba ulitage chui bdaglige Chube be kwian jaba ulita gbeni gwade, kwian onbrenu muirenu mi mo jwen ni be tañachuge mo jwen giti, ama ulita be chege salengwli lle boanga Chube alin nga ngaña giti kare, lle boanga Chube alin nga ngaña giti me mo jwen. ");
INSERT INTO sabNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","¿Me uñale ba ulitage Moisés nu Chube gerua degaba unsuialin gerule trate kwian jaba be chkeni gwade giti? ¿Ba me chada e batabanga? Chada ege chke uñale bage unsuialin Chube kerua sugedu Moisége gerule Moisés ole gli soli kle kugeske, Moisés chada degu e giti, chada e gerule: “Cha Abraham Chubea, cha Isaac Chubea, cha Jacob Chubea, ama ulita kle cha gai mo Chugagwallale.” Moisés Chube gerua degu ene unsuialin tangle, ");
INSERT INTO sabNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","e giti ñage suge trate ba ulitage chui bdaglige kwian ulita jogebakeda jaba be chkeni gwade. Abraham kaire Isaac kaire Jacob ama gdamai jogebakeda, gire Chube gerudu Moisés ole ama gdamai giti Chube ama Chubea, ulia Chube kwian gwade alin Chubea, ama me kwian jaba Chubea, malen chkedale uñale bage kwian jogekeda kwian e oña kle chege gwade, kaire agwe chui bdaglige kwian jaba ulita be chkeni gwade. Sugedale bage ba me kle tañachuge trate kwian jaba mi chkeni gwade, ulia kwian jaba ulita be chkeni gwade, ba kle tañachuge nganake geru Chubenuge, malen ba kle jogebanga geru uliage —Jesu gerudu ene kwian saduceo ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Kwian gdaite daba tkanga tangle Moisés chadalla giti kledu ne ngwadi Jesu keruchuge geru trage kwian saduceo ulita ole, kaire ama kwian saduceo keruchugu gerule Jesu ole Jesu gbagda jiske Moisés chadalla giti, amage sugedu Jesu jaindunga no trate kwian saduceo kalen saduceo me ñadu gerule dare saduceo chegu kamne jo ngeru, gire kwian fariseo geru kadu Jesuge: —Moisés Chube gerua degu unsuialin tangle, geru e kle degaba che ta gbagda che toidale mine Chube gwa giti, ¿geru e miamne ma kweri geru na ulitage kwian gadale dage? ");
INSERT INTO sabNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesu jaindunga kwian e daba tkanga tangle Moisés chadalla giti kalen: —Chube gerua ma kweri Moisés jigu degaba kwian gadale dage, geru e kle gerule: “Cha gerule ba kwian israelita ulita ole, ba cha keruchuge no, ba geru ai gbadale gdadi: Chube che Chugagwalla kweri, ama gdaitre alin allabi ulia. ");
INSERT INTO sabNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Gire ba nodale ba Chugagwalla kweri Chube ole, ba mo ta dbadale no trate ulita ama ole diali, ba tañachugadale diali mo tale ama giti, ba mo chuga gbale no Chube alin ole, ba mo ta gbadale kiraske lle boi ama alin ama takalin kare.” Chube gerua e ma kweri gbadale gdadi. ");
INSERT INTO sabNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Agwa kaire agwe geru na gbabokedale kweri ba gbadale gdadi, geru e kle gerule: “Ba mo ta dbadale no daba na ulita ole salengwli ba no mo ole naskuni kare.” Geru na tanre kle gbaba ba alin agwa geru gbaboke e ma kweri ulitage ba mo ta gbadale geru e gai dage ulia ba agedale ulita geru gbaboke e kle gerule kare. ");
INSERT INTO sabNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Kwian daba tkanga tangle Moisés chadalla giti gerudu Jesu ole: —Ba gerudu no trate ulia, ulia Chube gdaitre alin allabi kle, Chube na me kle dale. ");
INSERT INTO sabNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kwian unsuialin tangle bda guda bda gugu Chube gwa giti kwian agedu me no giti, age ene giti Chubedi nga sugadu no. Agwa nga suga ma no Chubedi che mo ta dbe no ama ole diali, che tañachuge mo tale diali ama giti, che mo ta gbe kiraske lle boi ama alin ama takalin kare, kaire che mo ta dbe no daba na ulita ole salengwli mo ole naskuni kare. Che age ene ulita geru kle gbaba gerule kare, e skwen no no Chubege, e kle ama gbe nga suga no ole che giti. ");
INSERT INTO sabNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Kwian daba tkanga tangle Moisés chadalla giti gerudu ene Jesu gerudu giti ama ole, gire Jesuge sugedu kwian e kledu jainnga ta no ulia ole Jesu kalen, Jesu gerudu ama ole: —Ulia ba kle tañachuge no trate, me sbali gire ba be Chube gai ulia mo Chugagwallale. Ne suiagebi ni kwian gdaite jaindu geru kade dare Jesuge ama kledu age kare diali Jesu gbagda jiske Moisés chadalla giti, sugedu kwian ulitage Jesu ta ole kwian me ñage kirachke Jesudi Jesu gbe jiske geru giti. ");
INSERT INTO sabNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesu kledu kwian tke tangle Chube gerua giti u gerungwa Chube olege, gire Jesu gerudu kwian ulita kle ama keruchuge ole: —Kwian daba tkanga tangle Moisés chadalla giti ulita kle gerule Chube be Cristo kage kwian alin Cristo amaña che chugagwalla unsuialin David oindalla alin allabi. ¿Bage suge mine geru e giti? ¿E ulia kwian e kle gerule kare? ");
INSERT INTO sabNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Cha gerule ba ulita ole, Chube Oña David amaña ta gbu chada dege Cristo giti unsuialin tangle, chada e gerule: “Chube gerudu cha Chugagwalla ole: ‘Toi dba cha ngena cha ko taingwli giti, chui be chke gire cha be ba gbe kirachke ba dolla ulitadi, ba be chege dolla ulita Chugagwalla kweri.’ ” ");
INSERT INTO sabNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David chada degu ene unsuialin Cristo giti, chada e giti sugedale kwian ulitage Cristo me David oindalla alin allabi agwa kaire Cristo David Chugagwalla, David agali gerudu Cristo ama Chugagwalla. Jesu gerudu ene gire kwian ngle Jesu keruchugu nga suga no ole. ");
INSERT INTO sabNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesu chegu kwian tke tangle dare, Jesu gerudu: —Ba mo manadale ta giti kwian daba tkanga tangle Moisés chadalla giti ulitage, ba me ama chuge ngwadi ba anblite. Ama ulita takalin kwian na ama gai ngwange no mo chugagwallale kweri, ama ta chegekalin no kwian na ulita gwa giti, malen ama diali ñometra jeike no dbe modi mo kaite kwian ngleaske, kaire nga ulita baini kaire ama kle chage ngwadi ama takalin kwian ulita gbi kade no amage ama gai dage kwian chugagwallale. ");
INSERT INTO sabNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ama kle joge u mo litangwa Chube gerua jwanngwage gire diali ama kle toingwa ma no jinade mo alin toi dba kwian ulita gwa giti mo gbagda kweri daba na ulitage. Kaire kwian e kle joge chui ollade gire kle nga ma no bligda gutangwa jinade, ama toikalin dba ule kwian chui olladanga chugagwalla ole. ");
INSERT INTO sabNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Kaire kwian daba tkanga tangle Moisés chadalla giti ulita kle muinga chegeba oli onbrege anblite lle ulita jwennga muinga oli ngeru u jwennga kaire muinga ngeru mo alin. Kaire kwian e kle mo gbe gerule kweri sbali Chube ole kwian ngle gwa giti, ene kwian ulita be tañachuge kwian e no no Chube ole. Kwian daba tkanga tangle Moisés chadalla giti diali ta mo gbakalin no kweri kwian ulita gwa giti agwa ama tale ama kwian me no me no, e gdale ama be boi tanre daga ngwale bdagli, Chube be ji gbe tirare tirare ama ulita giti —Jesu kwian tku tangle ene ulita kwian daba tkanga tangle Moisés chadallage giti. ");
INSERT INTO sabNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesu kledu u gerungwa Chube olege ule kwian geru jwannga amage gdataboko giti gdaboke ole, gire Jesu jo toi dba kodi nga igi ketakle ngwadige. Ama gwagedu kwian tanredi eni chie igi tke lle igi litangwa olege. Kwian ngle igi molen tanre chku igi tanre tke igi litangwa ole tadi, ");
INSERT INTO sabNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","kaire agwe ama gwagedu muinga chegeba oli onbrege gdaitedi chie igi monu ulita dbe, muinga e me lle molen ama igi gabokle alin allabi molen agwa ama igi e ulita tku igi litangwa olege Chube alin. Ulia igi e bedreare me ñanaske kwian na gwa giti, ");
INSERT INTO sabNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","agwa Jesu gwa giti igi e ngle, Jesu gwagedu muinga edi igi monu ulita tke igi litangwa tadi, gire Jesu kwian geru jwannga kadu mo gitigu, Jesu gerudu ama ulita ole muinga e giti: —Cha gerule ulia ba ulita ole, muinga oli e llea me, ama igi gabokle alin molen allabi ketu ulita, kwian ulita gwa giti muinga igi ketu ma bedre kwian na ulitage, agwa Chube gwa giti muinga e igi ketu ma ngle kwian na ulitage. ");
INSERT INTO sabNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kwian igi molen tanre kle lle gige tanre mo alin ama takalin kare gire igi chegeda ama kle igi e kete Chube alin, ulia kwian gwa giti ama igi tanre ketu, Chube gwa giti me dale. Agwa muinga e me kle age ene dale, muinga e igi amanu mo managda ulita ketu Chube alin, igi toigda me chegu ama ole, Chube gwa giti muinga e igi ma ngle ketu Chube alin kwian na ulitage —Jesu gerudu ene kwian geru jwannga ole muinga igi monu ulita ketu Chube alin giti. ");
INSERT INTO sabNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesu jo siere u gerungwa Chube olege ule kwian geru jwannga amage gdataboko giti gdaboke ole, gire kwian geru jwannga gdaite gerudu Jesu ole: —Cha tkanga tangle geruge, u gerungwa Chube ole u kweri noare, u dodaba ke kweri no giti, u e no no. ");
INSERT INTO sabNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesu jaindunga: —Nege ba kle gwage no u kweri edi u e no no, agwa cha gerule ulia ba ole, me sbali u e ulita be chege skianbada lle ngwale kare, ke mi chege gbaba mo giti ni gbaite, u ulita be chege skianbada. ");
INSERT INTO sabNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jesu gerudu ene kwian geru jwannga amage ole gire Jesu jo ule geru jwannga ulita ole Ngwiskinro Jwichugallage, jwichuga e chege u gerungwa Chube ole ngwadi gwangnagu. Ne ngwadi Jesu toidu dba, kaire Pedro kaire Santiago kaire Juan kaire Andrés toidu dba Jesu ole sugekare kwian na ulitage, ama geru kadu Jesuge: ");
INSERT INTO sabNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Cha geru jwannga bage batre takalin ba geru kete chage, ¿ngaminegire u gerungwa Chube ole be skiendba ba gerudu kare? ¿Be boi mine ngeru gire ene chke uñale cha ulitage chui bdagli kle kodi? ");
INSERT INTO sabNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesu jaindunga kwian e kalen: —Ba ulita kledale ta giti ene ba mi skate alenske ba mi mo chuge ngwadi mo anblitange kwian daba anblitangage chui bdagli giti. ");
INSERT INTO sabNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Chui bdagli chke kodi gire kwian tanre be chie mo gbe kweri gerule mo giti daba anblitagda, ama be chage kwianske mo ka gbaba cha kalla giti gerule mau giti: “Cha Cristo, Chube cha kaguni kwian alin.” Kwian tanre be chage gerule ene agwa kwian ene me ulia Cristo, kwian ene ulita be kwian tanre anblite geru ngwalege kwian tanre be ama gerua gai ulia. ");
INSERT INTO sabNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ba be geru keruchuge kwian kle dole tanre kweri modi nga tanrege, ba geru e keruchuge, ba me mo ta dbe kennga kle boi giti, boidale ene ulita ngeru agwa chui bdagli bebi chke. ");
INSERT INTO sabNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kwian chudalla na be mo tke dole kwian chudalla na ole, kaire kwian toinga nga kweri nage be mo tke dole kwian toinga nga kweri nage ole. Kaire nga be jwlien tanre kegde kweri be chite tanre nga tanrege, kaire bli suia kweri be kle tanre, kwian ngle be jogekeda bli kweri kote. E ulita be kle boi gwangea nga dba ai giti agwa chui bdagli bebi chke, lle na tanre tirare be boi ngeru, lle e ulita kote kwian be ta olire tanre boi daga ngwaleske. ");
INSERT INTO sabNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Jesu gerudu ene kwian geru jwannga amage ole gire gerudu dare: —Ba ulita kledale ta giti, kwian che dollale be ba ulita cha gerua ganga gai be ba kete kwian israelita chugagwallage boadalenga daga ngwale cha gdale, kwian chugagwalla e be ba dbe u mo litangwa Chube gerua jwanngwage ba batange obere giska giti kwian na ulita gwa giti. Kaire ba dbabe kwian chugagwalla tanre ma kweri ngwadi, chugagwalla e ulitage ba gbabe jiske cha gerua gdale, ba kle kwian chugagwalla e ngwadi gire ba be ñage gerule no cha giti kwian e ulita gwa giti. ");
INSERT INTO sabNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Chube gerua no cha giti jogedale ketaba kwian nga ulitamuge ngeru gire chui bdagli be chke. ");
INSERT INTO sabNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ba ulita be geru cha giti kete kwiange, e giti kwian tanre be mo tke dole ba ole ama be ba gai be ba dbe gbale jiske kwian chugagwalla kweri ulitage, be boi ene gire ba me mo tallade ba be gerule mine mau giti kwian chugagwalla kweri e ulita gwa giti. Ba be kle eni kwian e gwa giti gire ba mi gerule mau tale, Chube Oña be ba ta gbe ba gerudale mine kwian ole, ulia Chube Oña be ba chudaboi ene ulita geru giti. ");
INSERT INTO sabNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Chui bdagli bebi chke gire kwian be ta jwlite mo daballanu dollale be mo daballa kete kwian chugagwallage gwaleda cha gerua gdale, kaire ñenua be ta jwlite mo kirogwallanu dollale be mo kirogwalla gwangeda cha gerua gdale, kirogwa be ta jwlite mo ñenua dollale mo chebia dollale be mo chebia mo ñenua gwangeda cha gerua gdale. ");
INSERT INTO sabNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kaire cha gerua gdale kwian ulita be jainchke badi agwa ba me mo tallade, ba bai me mo chuge ngwadi joge siere cha geruage boi daga ngwaleske ba mo ta gbe cha gerua gai ulia mo tale diali gwangerugu mo ta gbe age no diali Chube takalin kare, ba bai mo ta gbe ene, chui bdagli be chke gire ba be toi no diali chui tangle cha ole Chube ngwadi —Jesu gerudu ene kwian geru jwannga ole. ");
INSERT INTO sabNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Cha chada ai deganga gerule ba bai chada ai batenga ole, ba geru ai gbadale gdadi tañachuge no mo tale Jesu kle gerule giti, gire ene geru be suge no trate bage. Jesu gerudu dare kwian geru jwannga amage ole: —Chui be chke gire kwian be age gweale me no me no sugaska Chube gwa giti una no Chubenu Jerusalénge nga kweri Judeage, ba gwage kwian age me no sugaska enedi una Jerusalénge, gire ba bai kaire ulita kle nga Judeage kigedale ngaske jwichugage mo manadale nga be boi tirare ngeru. ");
INSERT INTO sabNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Chui ege kwian ulita kigedale blikare ni lle amanu tallade. Kwian bai kaire kle goga tangle ama me jogedale gwa u amanuge lle gweale amanu ñanaske gwa tangle lite ole dbadale, ama lle ulita amanu chugadale ngwadi gwa ama jogedale kige blike kole. ");
INSERT INTO sabNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Agwa kwian bai kaire skate lle boi deage me jogedaleni gudegu mo ñometralla lite ole, ama jogedale kige blike gwangerugu me joge naskuni. ");
INSERT INTO sabNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Chui ege muinga bai kaire kle chage gaba kaire muinga bai kaire kle chage kirogwa soli sidri jusulidi ole, muinga e ulitage cha tai dage noare, ama ulita be boi daga ngwale tirare, be mnoare ama alin kige blike. ");
INSERT INTO sabNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","19","Chui ege kwian be boi tanre daga ngwale tirare me nu boiba daga ngwale ngeru kare chui Chube nga ulita dodaduge gwangerugu joge nege tangle, boi daga ngwale ene chuia be joge tangle ulita gire mi boi dare ene kare nakwaite. Ulia chui ege be boi tanre daga ngwale malen e gdale ba ulita gerudale diali Chube ole boi daga ngwale ene chuia me chke noi suiale, chui be chke noi suiage ene kwian ñage boi ma jabale me ñage kige blike dale. ");
INSERT INTO sabNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","E suiale Chube kwian chuge ngwadi boi daga ngwale chui ngle kwian ulita be jogenga boi daga ngwale kote, agwa Chube tale Chube be mo ta dbe no kwian ole kwian bai Chube nu gaba mo alin ole, Chube mi kwian chuge ngwadi boi daga ngwale chui ngle, Chube be boi daga ngwale chuia gbe buli, ama me takalin kwian amanu boi daga ngwale chui ngle, ama no no kwian ole. ");
INSERT INTO sabNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Kaire e suiale kwian gweale be gerule ba ole: “¡Gwage ai, Cristo chku! Ama kle aini Chube ama kagu.” Kaire kwian na gerule ba ole: “Kwian chiu e, ama Cristo ulia.” Kwian gerule ene ba ole, sugedale bage ama me kle gerule ulia ama kle gerule mau tale ngwale, ba me ama gerua gai ulia. ");
INSERT INTO sabNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kaire chui ege kwian gweale be chage kwianske mo kalla itenga be gerule: “Cha Cristo ulia, Chube cha kagu.” Kwian na be sole kwian ole kwian ulita anblite, be gerule: “Ulia cha Chube gerua ketanga dabage.” Kwian e ulita be gerule ene kaire ama be lle daga ngwale no tanre dodade kwian ulita gwa giti, age ene giti ama takalin kwian tañachuge ama kle age Chube kiralla giti, ama be age ene ulita kwian Chubenu anblitagda. Kwian daba anblitanga e ulita be takalin kwian Chube nu gaba mau alin gbe age me no Chube dollale me Chube gerua gai ulia dare, ama tañachuge ama ñage kwian Chubenu ta blite chage ama nate ama gerua ngwale gai ulia, agwa kwian daba anblitanga e ulita kle tañachuge ene ngwale. ");
INSERT INTO sabNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ba ulita kledale ta giti, cha geru ai ulita ketu bage ba ta gbale be boi giti chui bdaglige, ene chui ege kwian me ba anblite joge siere geru uliage. ");
INSERT INTO sabNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","25","Jesu gerudu ene gire gerudu dare kwian geru jwannga amage ole ama chieni chuia giti: —E ulita cha gerudu kare ba ole be boi daga ngwale ene ulita, gire chui be gwajoge jere ngajudi, kaire dai mi chege gwadenga ngajrege, beu ulita be jain dbige nga ngaña giti, nga ngaña giti nga ulita be jwlien, beu mi chege ngwedi beu kle kare, lle ulita mi chege ngeru kare nga ngaña giti. ");
INSERT INTO sabNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Nga be boi ene ulita gire Chube be cha kageni, cha be chieni nga dba ai giti ngnagu bogakwaske Chube kiralla giti, chui ege kwian ulita be gwage chadi cha noare cha kweri, ulia cha kwian ulita Chugagwalla. Be suge trate kwian ulitage e cha amaña chiu nga dba ai giti kwian kare kle chieni nabitaite. ");
INSERT INTO sabNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Cha be lle boanga cha alin nga ngaña giti ngle kage cha ngeru nga ulitage nga dba ai giti, ama be kwian nga ulitamu bai kaire cha nu gaba mau alin lite ole ulita dbale nga ngaña giti toi cha ole Chube kle ngwadi. ");
INSERT INTO sabNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Nege cha geru ñachuge ba ulita alin gli kada higuera giti, ba cha keruchuge no gire ene be suge bage cha kle gerule mine ulia. Gli higuera kle ga jain ulita gire gliga na bli erutu kle chieni, ba gwage glidi ene aini che jwiage gire bage uñale chuda suia kle kodi. ");
INSERT INTO sabNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ene kaire ba be gwage lle tanredi boi ulita cha gerudu kare ba ole sbaliga gire chkedale uñale bage cha be chieni chuia kle kodi kodi, me sbali gire cha be chieni. ");
INSERT INTO sabNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Cha geru kete bage ulia, cha gerudu kare be boi ene ulita ngeru kwian ulita kle toi chui aige bebi joge tangle. ");
INSERT INTO sabNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Nga ngaña giti nga dba ai giti mi chege diali dale alin, nga ulita be joge tangle, agwa cha gerua mi joge tangle dale. Cha gerua be chege diali chui tangle, ulita be boi cha gerua kle gerule kare. ");
INSERT INTO sabNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Jesu gerudu ene gire gerudu dare ama be chieni chuia giti: —Ni kwian gdaitege uñale chui baige chui mangire cha be chieni, kaire agwe lle boanga cha Ñenua Chube alin nga ngaña giti ulita ni gdaitege uñale cha be chieni ngaminegire, ni cha Chube Kirolla agalige uñale chui baige Chube be cha kageni, cha Ñenua Chube alin allabige uñale. ");
INSERT INTO sabNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Cha gerule ulia ba ole, me uñale bage ngaminegire cha be chieni malen ba kledale ta giti diali chui ulitage, ba ta kledale biale cha chieni chuia ngwange, me skate alenske ta me gbaba biale cha be chieni chuiage. ");
INSERT INTO sabNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ai ulita cha kle gerule kare cha be chieni chuia giti chege salengwli kwian onbre gweale jo chage bate nga nage kare. Kwian onbre e bebi joge gire, ama lle boanga mau alin ta gbu llema boadale u mauña me gire. Kwian u mauña lle boanga gdaite gdaite ta gbu u kaire lle ulita u mauñanu manadale mine, kwian u mauña kwian lle boanga gdaite gbu ugaka manade no tatra kwian u mauña chieni ngwange. ");
INSERT INTO sabNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","E kare ene ba kledale diali ta giti cha be chieni ngwange. Me uñale bage chui baige cha be chieni salengwli lle boangage me uñadu chui baige kwian u mauña be chieni kare. Cha ñage chieni ngakamalin bdugu, cha ñage chieni ngabebitabi, cha ñage chieni chui bduke, cha ñage chieni ngabi, cha ñage chieni ngajrege ba kle gbe gire, bage me uñale chui mangire cha be chieni. ");
INSERT INTO sabNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Malen diali ba mo ta gbadale biale cha chieni ngwange, me no cha chieni gire ba skate alenske cháge ba kle gbe kare. ");
INSERT INTO sabNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ulia ba ulita kledale ta giti diali, ba cha chieni chuia manadale ngwange tatra me chege gbeba kare. Cha ba ulita ta gbe ene kaire cha kwian na ulita ta gbe ene, ene ba ulita be kle biale cha ngwange cha chieni chuiage —Jesu gerudu ene ulita kwian geru jwannga amage ole. ");
INSERT INTO sabNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Chui chegu gbabokle alin allabi gire Pascua chuia chke chui olladangwa kwian israelita alin, chui ege kwian israelita kle tachke Chube ama enusulian unsuialin ulita jun siere nga kweri Egiptoge, kwian israelita kle chui e ollade ama kle pan me dodadre levadura ole gute. E suiale kwian gerunga Chube ole daba alin chugagwalla tanre kaire kwian daba tkanga tangle Moisés chadalla giti tanre, kwian e ulita mo ta gbu age gweale skwlenre Jesu gai dbale skage Jesu gwangeda. ");
INSERT INTO sabNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Kwian ene ulita gerudu modi: —Che me ñage age gweale Jesu dollale Pascua chuiage, kwian tanre be kle chui ege chui ollade una aige, che age me no Jesu ole kwian ngleaske gire kwian ulita be kira bate modi Jesu gdale, ma no che chui na manade kwian ngle me kle mo litaba una aige gire —kwian israelita chugagwalla ulita gerudu ene modi. ");
INSERT INTO sabNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesu jo chke una kada Betaniage ule kwian geru jwannga amage ulita ole, ama ulita jo Simón ullage blire Simón ole ule. Ngeru Simón e amaña chagedu oga kwara tuge jingmea kada lepra ole, agwa ama jogeba chkeni noni. Simón e ngwadi Jesu jo blire kwian geru jwannga amage ole, ama ulita kledu blire gire muinga gdaite chku Jesudige lle ñachke no kada nardo chia dbe lle gweale limeta soli karege tkale Jesu chuga giti, nardo chia e kwangleare. Muinga limeta e kagda skutunga gire ama nardo chia e ulita oto Jesu chuga giti. ");
INSERT INTO sabNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Kwian gweale kledu blire ne ngwadi gwagedu muingadi nardo chia kwangleare ote Jesu chuga giti gire kwian ta skochiu muingadi nardo chia gdale. Kwian e gerudu modi muingadi: —¿Mineade muinga nardo chia kwangleare kagunga ngwale? ");
INSERT INTO sabNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ma no muinga nardo chia e chbade kwangle trescientos ene ama ña kwian na me lle molen chudaboi nardo chia ñanalla giti —kwian gerudu me no ene ta skochie ole muingadi muinga nardo chia oto Jesu chuga giti gdale. ");
INSERT INTO sabNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Agwa Jesu gerudu muinga giti kwian ole: —¡Muinga chugene! Ba me mo ta dbe gerule me no amadi dare, ama agedu no no cha alin, ¿mineade ba kle tañachuge me no amadi nardo chia gdale? ");
INSERT INTO sabNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Cha gerule ba ole, kwian me lle molen be kle toi diali ba ulitaske, chui ngle kle ba alin kwian me lle molen chudaboale ba takalin kare, agwa cha mi chege toi diali aini baske. ");
INSERT INTO sabNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Me sbali cha be jogekeda, muinga ai kle nardo chia ote cha chuga giti cha jegwale gbe biale cha jaba ogabe chuia ngwange, muinga kle age no ulita cha alin ama ñadu kare. ");
INSERT INTO sabNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Cha gerule ulia ba ole, chui aige gwangerugu nga ulitage baini kaire geru no cha giti be joge tragaba kwian ole ngwadi, nga e ulitage geru muinga ai agedu no cha alin giti be joge tragaba kaire, ene kwian nga ulitage be tachke muinga ai agedu giti cha alin. ");
INSERT INTO sabNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Jesu gerudu ene gire kwian geru jwannga Jesuge gdataboko giti gdaboke gdaite kada Judas-Iscariote, Judas-Iscariote jo Jesu chada jige gadale kwian gerunga Chube ole daba alin chugagwalla ulitage, Judas-Iscariote gerudu ama ulita ole: —Cha ta ba ulita chudaboakalin cha ña Jesu kete bage gwangeda. ");
INSERT INTO sabNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Kwian chugagwalla ulita Judas-Iscariote keruchugu gerule ene Jesu giti gire ama ulitadi nga chegu suga no Judas-Iscariote be ama chudaboi Jesu kete gadale, ama ulita mo ta gbu no Judas-Iscariote ole ama igi ketu Judas-Iscariotege Jesu kete ñanale. Chui ege gwangerugu Judas-Iscariote kledu kote Jesu ole Jesu gdea tke baini Jesu be kle gballa sugekare kwian ngleage ene ama be Jesu kete kwian Jesu dollalege. ");
INSERT INTO sabNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pan me dodadre levadura ole gute suia chku, chui gwangeage diali kwian israelita ulita bda cordero gweda gutadale Pascua chuia ollade. Chui e chku gire kwian geru jwannga Jesuge geru kadu Jesuge: —¿Baini ba takalin cha bli jinade che ulita alin gutadale Pascua chuia olladale ule? ¿Che be blire baini? ");
INSERT INTO sabNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Kwian geru jwannga ulita geru kadu ene Jesuge gire Jesu geru jwannga gdaboke gau, Jesu gerudu ama boke ole: —Joga una Jerusalénge, una ege kwian onbre gdaite be skwen bage chage chi dbe lle chi tkangwage, kwian e nate ba joge chage, ama be ba jonlla dbe. ");
INSERT INTO sabNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Kwian e be joge chke gwa ngwadi ba joge gwa kaire, ba geru kade kwian u mauñage: “Cha tkanga tangle geruge cha kagu aini geru kade bage nga giti blingwa, ¿baini nga kle biale cha tkanga tangle alin blire ule geru jwannga amage ulita ole Pascua chuia ollade?” ");
INSERT INTO sabNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ba gerule ene u mauña ole gire ama be nga kweri dodabale ngaña gwa u amanuge kaite bage, nga e be kle litaba trate ulita gbaba biale. Ne ngwadi ba bli jinade che ulita alin gutadale. ");
INSERT INTO sabNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Jesu kwian geru jwannga amage gdaboke ta gbu ene gire kwian gdaboke jo una Jerusalénge. Ama jo chke una ege gire lle ulita skwendu boabale Jesu gerudu kare ama ole. Ne ngwadi kwian geru jwannga gdaboke bligda dodadu gutadale Pascua chuiage Jesu ama kagu kare. ");
INSERT INTO sabNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nga jo jere ngabi gire Jesu jo una Jerusalénge ule kwian geru jwannga ulita ole, ama ulita jo chke u ege ama be blire Pascua chuia ollade ngwadi. ");
INSERT INTO sabNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Jesu kledu toiba dba blire ule kwian geru jwannga gdataboko giti gdaboke ole gire Jesu gerudu: —Cha gerule ulia ba ulita ole, ba ulita kle aini blire ule cha ole gdaite be cha kete kwian cha dollalege gwaleda. ");
INSERT INTO sabNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Kwian geru jwannga Jesuge ulita Jesu keruchugu gerule ene gire kwian geru jwannga ulita ta chegu olire tanre mo tale, ama ulita gdaite gdaite geru kadu Jesuge: —¿Chema be age ene ba dollale? ¿Cha? ");
INSERT INTO sabNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesu jaindunga: —Ba kwian geru jwannga chage gdataboko giti gdaboke kle blire ule cha ole aini kle pan bita gbe date bligda chiaske batekwa amaña giti cha ole ba gdaite e be cha kete gwaleda. ");
INSERT INTO sabNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Cha chiu nga dba ai giti kwian kare, ulia cha ketabe boadale daga ngwale gwaleda Chube gerua degaba unsuialin kle gerule kare. Agwa kwian onbre bai be cha kete boadalenga daga ngwale gwaleda, onbre e be boi dageare daga ngwale tanre ama agedu cha ole kbiale, ma no ama alin ama me medunga chebia kote dale —Jesu gerudu ene kwian geru jwannga amage gdaite giti. ");
INSERT INTO sabNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ama ulita kledu blire ule gire Jesu pan gau kote gerudu Chube ole pan giti: “Cha Ñenua, noare ba pan ai ketu cha ulitage gutadale.” Jesu gerudu ene Chube ole pan giti gire Jesu pan skutunga ketu kwian geru jwannga kaire kairege gutale, Jesu gerudu: —Ba pan ai gute, pan ai cha uda kare. ");
INSERT INTO sabNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Gire Jesu chi jangwa gau kote uva chia ole, Jesu gerudu Chube ole uva chia giti: “Cha Ñenua, noare ba uva chia ai ketu cha ulitage jadale.” Jesu gerudu ene Chube ole uva chia giti gire ama uva chia ketu kwian geru jwannga kaire kairege jadale, geru jwannga ulita uva chia jau. ");
INSERT INTO sabNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jesu gerudu: —Uva chia ai cha be kare, cha jogeda giti be suge trate ba ulitage Chube kle geru jagere gbe kwian ulita alin cha giti, nege gwangerugu cha jogeda giti kwian ulita bai kaire cha gai ulia be chege no trate Chube gwa giti. ");
INSERT INTO sabNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Cha gerule ulia ba ole, nege alin cha kle uva chia jai ba ole ule, agwa nege gwangerugu cha mi kle ba ole dare ba gatedi uva chia jai ule nga dba ai giti. Chui bdagli be chke gire Chube be cha gbe gerule kwian ulita giti kwian Chugagwallale, chui ege cha be uva chia jai nakwaite ule ba ole —Jesu gerudu ene geru jwannga amage ole. ");
INSERT INTO sabNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Blidubi gire ama ulita mo gatu no Chube giti, gire ama ulita jo siere nga ege, ama ulita jo chage Ngwiskinro Jwichugalla ngnagu. ");
INSERT INTO sabNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesu gerudu kwian geru jwannga amage ulita ole: —Cha gerule ulia ba ole, nege ngajrege ba ulita be cha chuge ngwadi boi daga ngwale gballa Chube gerua degaba unsuialin tangle kle gerule kare, chada e gerule: “Chube gerudu: ‘Cha be kwian oveja mananga chuge ngwadi gwangeda gire oveja ulita be kige.’ ” Chube gerua degaba unsuialin tangle gerule ene ba giti cha giti. ");
INSERT INTO sabNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Cha gwabeda, cha jaba be chkeni gwadeni Chube kiralla giti, gire cha be joge ba ulita ngeru nga Galileage. ");
INSERT INTO sabNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Jesu gerudu ene geru jwannga amage ulita ole Jesu be boi giti, gire Pedro gerudu: —Kwian na ulita be ba chuge ngwadi boi daga ngwale gballa, agwa cha mi ba chuge ngwadi boi daga ngwale gballa. ");
INSERT INTO sabNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesu gerudu Pedro ole: —Cha gerule ulia ba ole, nege ngajrege ngakamalin bdugu antalan bebi ngwane bitabokedale gire ba agali be gerule bitamai kwian na ole ba me cha uñe. ");
INSERT INTO sabNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Jesu gerudu ene Pedroge agwa Pedro gerudu dare: —Me dale, cha mi age ene ba kle gerule kare cha ole, cha me mo tallade cha be jogekeda ba ole ule, cha mi gerule kwian ole cha me ba uñe. Pedro gerudu ene gire kaire kwian geru jwannga Jesuge na ulita gerudu gdaite gdaite salengwli Pedro gerudu kare. ");
INSERT INTO sabNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jesu kledu Ngwiskinro Jwichugallage ule kwian geru jwannga amage ulita ole gire ama ulita jo nga kada Getsemaníge, ne ngwadi Jesu gerudu kwian geru jwannga ulita ole: —Ba ulita toi dba aini sugeti cha manade. Cha be joge sugekare gerule Chube ole gballa. ");
INSERT INTO sabNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Jesu gerudu ene gire Jesu jo Pedro dbe jo Santiago dbe kaire jo Juan dbe mo ole llagli. Jesudi nga chiu olire tanre ama be boi daga ngwale giti, ");
INSERT INTO sabNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ta ene ole Jesu gerudu kwian geru jwannga gdamai ole: —Cha ta olire tanre mo giti cha be boi daga ngwale giti, suge chage cha me jage tañachuge e giti. Cha joge sugekare gerule Chube ole, cha takalin ba gdamai chege aini ngmadi cha manade, ba chegedale ta giti gwade ba me mo chuge ngwadi gbigage gbe. ");
INSERT INTO sabNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Jesu gerudu ene kwian geru jwannga gdamai ole gire Jesu jo chage ma ngerugu sidri sugekare gballa, ama mo ñeu kaboge jongnagwa giti ama gwa ñadu dbidi gire ama gerudu Chube ole: “Cha Ñenua, cha me ta boikalin daga ngwale, cha me takalin ba kwian me no chuge ngwadi cha gweda, ba takalin ba ñage cha jwen siere cha be boi tirarege. Uñale chage ba kiraske ba ñage age no ulita cha alin cha takalin kare, agwa cha me takalin boi ulita cha ole cha takalin kare, ma no cha takalin boi ulita cha ole ba takalin kare cha mo gbe biale age ba takalin kare.” ");
INSERT INTO sabNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Jesu gerudu ene Chube ole gire ama joni naskuni kwian geru jwannga amage gdamai kledu ama manade ngwadige, kwian geru jwannga e ulita skwendu Jesuge gbe, gire Pedro amaña kadakle Simón Jesu gerudu ama ole: —¡Simón, chkede bduge! ¿Mineade ba kle gbe? ¿Ba gdamai ni ñadu chege gwade cha manade sugeti? ");
INSERT INTO sabNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ba ulita mo ta gbadale chege gwade, ba gerudale Chube ole mo chudaboi kade amage, ene ba me ta jwlite age me no ba takalin kare. Uñale chage ulia ba ta agekalin ulita cha kle gerule kare, agwa ba me kira molen age cha takalin kare, malen ba gerudale Chube ole kira kade amage mo ta kira gbagda. ");
INSERT INTO sabNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jesu gerudu ene gire Jesu joni nakwaite sugekare gballa gerule Chube ole, Jesu gerudu ngeru kare Chube ole ama be boi giti. ");
INSERT INTO sabNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Gire Jesu joni naskuni kwian geru jwannga gdamaidini gire kwian geru jwannga ulita skwendu gbe Jesuge nakwaite, ama me ñadu chege gwade chuge, ama gbigachiu tanre ama gwagwa kledu jegaba gbiga kote, ama ulitage me chku uñale ama gerule mine Jesu ole mo giti. ");
INSERT INTO sabNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","42","Jesu joni nakwaite bitamaidale sugekare gballa gerule Chube ole. Jesu gerudubi ulita Chube ole gire ama joni naskuni kwian geru jwannga gdamai kledu gbe ngwadi, Jesu gerudu ama ulita ole: —¿Ba kle chage gbe kaire? ¡Chkede bduge, ba me gbe dare! Nege cha boabe daga ngwale kwiange chuia chku kaire cha gwabeda chuia chku. Chube cha kagu nga dba ai giti kwian kare, nege sugeti cha ketabe kwian agenga me no kote boadale daga ngwale ama be cha gweda. Nege nege cha ketanga kle chie ule cha dollale ole kodi chege, ale ten ama ngwange jonkare. ");
INSERT INTO sabNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesu kle gerule ene kwian geru jwannga amage ole gire kwian geru jwannga Jesuge na gdaite kada Judas-Iscariote chku ule guardia donga nglea ole Jesu kle ngwadi, guardia donga e gweale chiu sbadi ole na chiu glita ole. Kwian gerunga Chube ole daba alin chugagwalla ulita kaire kwian daba tkanga tangle Moisés chadalla giti ulita kaire kwian israelita chugagwalla juma ulita, kwian e ulita nu guardia nglea kagaba Jesu gai dbale skadi. ");
INSERT INTO sabNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Guardia donga ulita bebi joge Jesu nate ule Judas-Iscariote ole, Judas-Iscariote nu geruba: “Kwian gdaite bai cha be sobade, ama chkedale uñale bage e Jesu, ba kwian e amaña gai ba ama ko luge kejre ba ama dbe skage che chugagwalla ulita ngwadige.” ");
INSERT INTO sabNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas-Iscariote jo chke Jesudige, gerudu Jesu ole: —Ba cha tkanga tangle geruge. Judas-Iscariote gbi kadu ene Jesuge gire ama Jesu sobadu. ");
INSERT INTO sabNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Judas-Iscariote agedu ene gire guardia donga ulita Jesu gau dbale skadi. ");
INSERT INTO sabNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Boidu ene Jesu ole gire kwian geru jwannga ulita kle chage Jesu ole ama gdaite sbadi jun modi gire ama kwian gdaite ologa gaite tkunga ulita, kwian ologa jo tkabanga kwian e lle boanga kwian gerunga Chube ole chugagwalla ma kweri alin. ");
INSERT INTO sabNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesu geru kadu kwian Jesu dolla ngleage: —¿Mineade ba ulita kle chage sbadi ole glita ole cha gai nate kwian jiskenga kare? Ba kle age cha ole salengwli ba age kwian agenga me no me no ole kare. ");
INSERT INTO sabNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Chui ulitage diali cha kledu ba gwa giti kwian tke tangle u gerungwa Chube olege, ni bitaite ba cha gau dbale skadi cha kledu gerule giti. Agwa nege kle boi ulita cha ole salengwli Chube gerua degaba unsuialin tangle kle gerule be boi cha ole giti kare. ");
INSERT INTO sabNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Jesu gerudu ene kwian Jesu dolla ulita ole gire kwian geru jwannga Jesuge ulita jo kige, ama ulita Jesu chugu ngwadi boi daga ngwale gballa. ");
INSERT INTO sabNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Jesu gale Jesu dbajo gire kirogwa onbre biale gdaite kledu chage Jesu nate mo bliaba manta alinske, guardia donga tadu kirogwa e gakalin kaire dbale skage ule Jesu ole, kirogwa mantalla skatu guardia donga kote kirogwa kigedu taglale, guardia donga me ñadu kirogwa gai. ");
INSERT INTO sabNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Guardia donga ulita Jesu du kwian gerunga Chube ole daba alin chugagwalla ma kweri ullage. U ege kwian israelita chugagwalla na ulita kledu mo litaba, kwian gerunga Chube ole daba alin chugagwalla na ulita kaire kwian israelita chugagwalla juma ulita kaire kwian daba tkanga tangle Moisés chadalla giti ulita, kwian e ulita kledu mo litaba Jesu manade ngwange. ");
INSERT INTO sabNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedro jo chage gwage bate Jesu nate jo chke chege goga kodi uge kwian gerunga Chube ole daba alin chugagwalla ma kweri ullage, ne ngwadi Pedro toidu dba ule guardia u gerungwa Chube ole mananga ngle ole, Pedro chegu jita ngwachuge ule kwian e ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","56","Kwian gerunga Chube ole daba alin chugagwalla ulita, kaire kwian israelita chugagwalla kweri na ulita kle mo litaba u ege jennga Jesudi, ama ulita kledu kwian jinade gerule ngwale Jesu dollale Jesu gbagda jiske, ene kwian israelita chugagwalla e ulita ñage Jesu gwangeda Jesu agedu gweale gdale. Kwian tanre chiu chugagwalla ulita mo litaba ngwadi geru gweale jinade ngwale Jesu dollale, agwa kwian gerunga ngwale ulita kledu gerule nganake, me kledu gerule salengwli Jesu dollale Jesu gbagda jiske, malen kwian chugagwalla ulita me ñadu Jesu gbe jiske Jesu gwangeda geru ngwale e giti. ");
INSERT INTO sabNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Bdagli kwian gweale ta me no ole gerudu Jesudi kwian chugagwalla gwa giti: —Cha ulita Jesu keruchugu gerule ene: “Cha be u ai gerungwa Chube ole kwian nu dodaba skiendba ulita, gire chui gbamaire alin cha be u gbeni naskuni no biale agwa u jagere mi joge dodaba kwian giti, cha agali be u e dodade.” Cha Jesu keruchugu sole ngwale ene, ama gerudu giti chage suge ama kle mo gbe kweri Chube kare, Chube alin allabi ñage age ene Jesu gerudu kare. ");
INSERT INTO sabNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Kwian gweale gerudu ene Jesu dollale kaire kwian na gerudu Jesu gerua e amaña giti agwa kwian e gerudu nganake, kwian ulita me gerudu salengwli Jesu gerua e amaña giti. ");
INSERT INTO sabNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Kwian gerunga Chube ole chugagwalla ma kweri ama kwian e ulita keruchugu gerule Jesu dollale gire ama chku gdate kwian israelita chugagwalla na ulita gwa giti, ama geru kadu Jesuge: —¿Mineade ba me kle jainnga gerule mo giti kwian kalen? Kwian tanre kle gerule ba dollale, ¿ama ulita kle gerule ulia ba giti o me? ");
INSERT INTO sabNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Kwian gerunga Chube ole ma kweri gerudu ene Jesuge agwa Jesu me jaindunga dale, Jesu chegu kamne. Kwian gerunga Chube ole chugagwalla ma kweri gerudu nakwaite Jesu ole: —Cha geru kade bage, ba jainnga ulia cha kalen, ¿ulia ba Cristo Chube Kirolla? ¿Chube nu ba kagaba nga dba ai giti kwian alin o me? ");
INSERT INTO sabNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesu jaindunga: —Ima, cha amaña ba ulita kle gerule kare, cha Chube Kirolla. Chube kira molen ulita, ama cha kagu kwian kare nga dba ai giti, chui be chke gire ba ulita be gwage chadi toiba dba Chube ko taingwli giti nga ngaña giti kwian ulita Chugagwallale, kaire bdagli cha be chieni bogakwaske nga ngaña giti ba ulita gwa giti. ");
INSERT INTO sabNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","Kwian gerunga Chube ole daba alin chugagwalla ma kweri Jesu keruchugu gerule ene gire ama skochiu Jesu gerudu giti, ta skochie ene ole ama ñometra modige gagunga, ama gerudu kwian chugagwalla na ulita ole Jesu giti: —Ba ulita onbre ai keruchugu gerule ama Chube Kirolla Chube nu ama kagaba. Ama kle gerule ene mo giti, ama kle gerule Chube dollale. Ama kle mo gbe jiske agali ama kle gerule giti malen che me kwian jinade dare gerule amadi ama gbagda jiske. ¿Ba ulita tañachuge mine ama giti? ¿Che age mine ama ole? Kwian chugagwalla mo litaba ole ulita jaindunga: —Ama jiske tanre ulia, ama jogedaleda ama gerudu Chube dollale kbiale, che ama gwangeda. ");
INSERT INTO sabNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Kwian chugagwalla ulita gerudu ene gire ama gweale jolo tku Jesudi, kaire kwian Jesu gwagwa gatuda ñomedrega giti, ene Jesu me chegu ten kwiandi, kwian Jesu batu obere gire geru kadu Jesuge: —Gerule cha ole, ¿chema kle ba bate? Ama ulita kledu kidere ene Jesudi, kaire guardia u gerungwa Chube ole mananga ulita Jesu batu obere agedu dagale Jesu ole tanre me no. ");
INSERT INTO sabNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Jesu kle boi ene gwa kwian gerunga Chube ole chugagwalla ma kweri ullage, gire Pedro kledu manade goga jita ngwachuge. Muinga gdaite lle boanga chugagwalla ma kweri alin chku eni, ");
INSERT INTO sabNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ama gwagedu Pedrodi toiba dba jita ngwachuge, gire muinga chegu gwage tanre Pedrodi, ama gerudu Pedro ole: Pedro kle goga jita ngwachuge —Ba kaire kledu chage ule Jesu una Nazaremu ole. ");
INSERT INTO sabNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pedro gerudu: —Me dale, cha me ama uñe dale, ni uñale chage ba kle llema geruade cha ole. Pedro gerudu ene muinga kalen gire Pedro jo manade ugakage, gire antalan ngwanedu. ");
INSERT INTO sabNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Muinga lle boanga chugagwalla alin chegu gwage tanre Pedrodi, gerudu kwian na ulita kledu eni ole Pedro giti: —Onbre ai ulia kledu chage ule Jesu ole. ");
INSERT INTO sabNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pedro gerudu nakwaite: —Me dale, cha me kwian e uñe. Bigire kwian na ulita kledu ne ngwadi gerudu Pedroge: —Kwian mneite chagedu Jesu ole diali, suge chage ulia ulia ba kwian ene gdaite. Uñale chage ba kwian nga Galileamu. ");
INSERT INTO sabNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pedro kwian keruchugu gerule ene gire ama ta skochiu tanre e gdale, ama gerudu: —Cha gerule ulia ulia ba ulita ole Chube gwa giti, cha me kwian onbre e ba kle gerule giti uñe. Cha me kle gerule ulia ba ole, gire ene Chube ñage cha gbe ji chuge tanre e gdale. ");
INSERT INTO sabNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Pedro gerudu ene gire sugetibi allabi antalan ngwanedu bitabokedale, blikare Pedro tachku Jesu gerudu giti ama ole ngeru: “Antalan bebi ngwane bitabokedale gire ba agali be gerule bitamai kwian na ole ba me cha uñe.” Pedro tachku Jesu gerudu ene giti gire Pedro olidu tanre tanre ama gerudu Jesu dollale giti. ");
INSERT INTO sabNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Nga chku ju gire kwian gerunga Chube ole daba alin chugagwalla ulita mo litu ule kwian israelita chugagwalla juma ulita ole kaire kwian daba tkanga tangle Moisés chadalla giti ulita ole kaire kwian israelita chugagwalla na ulita ole, kwian e ulita mo litu jennga Jesu giti ama be age mine Jesu ole. Ama ulita mo ta gbu salengwli Jesu gbe jiske chugagwalla gobernador Pilatoge. Ama ulita Jesu ko lugangu Jesu du skage chugagwalla Pilato ngwadi. ");
INSERT INTO sabNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato geru kadu Jesuge: —¿Ba kwian israelita ulita chugagwalla kweri? Jesu jaindunga Pilato kalen: —Ima, cha amaña ba kle gerule kare. ");
INSERT INTO sabNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Kwian gerunga Chube ole daba alin chugagwalla ulita gerudu tanre Pilato ole Jesu gbe jiske lle tanre giti. ");
INSERT INTO sabNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilato geru kadu nabitaite Jesuge: —¿Mineade ba me kle gerule mo giti sidri kwian kle ba gbe jiske giti? Ama kle ba gbe jiske chage ba gwa giti lle tanre giti. Gerule cha ole, ¿ama kle gerule ulia o me? ");
INSERT INTO sabNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Agwa Jesu me jaindunga dale, Jesu chegu kamne, malen Pilato tañachugu tanre Jesu giti mineade Jesu me kle gerule mo giti ni sidri. ");
INSERT INTO sabNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Diali Pascua chuiage chura kaire kaire Pilato kwian ageba me no kle skage gweale gdaite skajwanngenga kwian ulita takalin kare. ");
INSERT INTO sabNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","E suiale onbre agenga me no gdaite kada Barrabás kledu skage daba agenga me no na tanre ole, ama ulita nu mo ta gbaba ule kira bate gobierno dollale kaire ama kwian gweale guda, malen ama ulita kledu skage age me no ene gdale. ");
INSERT INTO sabNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Kwian nglea chku Pilatodige gerudu Pilato ole: —Cha takalin ba kwian gdaite skajwanngenga jige gbale ba diali kle age kare Pascua chuiage. ");
INSERT INTO sabNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato geru kadu kwiange: —¿Ba ulita takalin cha ba kwian israelita chugagwalla kweri ai skajwanngenga jige gbale nege? ");
INSERT INTO sabNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilatoge uñadu ulita trate kwian gerunga Chube ole daba alin chugagwalla ulita semale tanre Jesu ole, malen ama ulita Jesu du Pilatoge Jesu gbe jiske gwaleda. ");
INSERT INTO sabNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kwian gerunga Chube ole daba alin chugagwalla ulita kwian nglea ulita ta gbu gerule Pilato ole ma no Barrabás giti Pilato Barrabás skajwanngenga, ene Jesu chege Barrabás taneage. ");
INSERT INTO sabNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Gire Pilato geru kadu kwian nglea ulitage: —Cha Barrabás skajwanngenga, ¿gire cha be age mine kwian ai ka jwankle kwian israelita chugagwalla kweri rey ole? ");
INSERT INTO sabNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Gire kwian nglea ulita jaindunga Pilato kalen: —¡Ama gwangeda kruge! ");
INSERT INTO sabNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato gerudu kwian ole: —¿Mineade ba takalin cha ama gwangeda kruge? Chage suge trate ni ama agedu me no sidri, ¿llema giti ama jiske? Kwian ulita ngautu ma kweri Jesu dollale: —¡Ama gwangeda kruge! ");
INSERT INTO sabNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato kwian keruchugu gerule ene, Pilato tadukalin chege no kwian ulita ole malen ama Barrabás skajwanngunga, Pilato Jesu batangu ngeru gire Pilato Jesu ketu kwiange kwian ulita takalin kare Jesu gwaleda kruge. ");
INSERT INTO sabNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Guardia donga Pilato alin Jesu du Pilato ulla kwerige gwa, gire eni guardia donga e ulita mo litu Jesudi tangle kidere Jesudi. ");
INSERT INTO sabNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Guardia donga Jesu ngama tku kwian chugagwalla kweri nga dba aimu kle mo ngama tke kare ñometra chada dabere, ñometra e kareske Jesu jo ngama tkaba, guardia donga giska kobaske bliu Jesu chuga batreti batu Jesu chugaske. ");
INSERT INTO sabNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Gire ama ulita mo gbu ngaute kweri Jesu gbe gidagda, ama gerudu Jesu ole kidere: —¡Ba kwian israelita chugagwalla kweri rey noare, ba chege no kweri kwian ulita gwa giti! ");
INSERT INTO sabNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Guardia donga ulita gerudu ene Jesu ole ta me no ole, gire ama Jesu batu chugage glita giti, ama jolokwa tku Jesudi, kaire ama jongnagwa skutu dba Jesu gwangnagu ama kle chugagwalla kweri gai dage kare agwa ama kledu age ene Jesu gbe gidagda. ");
INSERT INTO sabNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Guardia donga agedu ene ulita kidere Jesudi gire ama ñometra chada dabere junnga Jesudige, ama Jesu ngama tkuni naskuni Jesu ñometrallaske, gire ama ulita jo Jesu dbe gwaleda kruge. ");
INSERT INTO sabNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Guardia donga ulita jo Jesu dbe kru ole nga Jesu gwabeda ngwadi gire jonkare guardia donga tendu onbre kada Simón ngwange, Simón una Cirenemu, ama Alejandro kaire Rufo ñenua, Simón kledu chage una Jerusalén ngnagu gire guardia donga Simón gau gbu Jesu krulla dbe. ");
INSERT INTO sabNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Guardia donga ulita jo chke Jesu dbe nga kada Gólgotage, kaire nga e amaña kada Calavera, nga ege Jesu dule gwaleda. ");
INSERT INTO sabNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Guardia donga bebi Jesu bate clavo giti kruge gire ama uva chia gage tugebanga gdege kada mirraske ketu Jesuge jadale, agwa Jesu me jaindu uva chia jai. ");
INSERT INTO sabNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Guardia donga Jesu gbu kruge ngaña, gire Jesu ñometralla jo jwanbanga Jesudige, ñometra e ulita guardia donga ulita girabatu modi guardia donga bai kaire blachku no ole. ");
INSERT INTO sabNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","26","Chada jo degaba Jesu giti, chada e gbere kruge Jesu chuga giti ngaña, chada e gerule Jesu jiske llema giti kwian ulita gwage, chada e gerule: “Ai kwian israelita ulita chugagwalla kweri rey.” Chui jo bate ngaña gire Jesu gbere kruge ngaña. ");
INSERT INTO sabNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Kaire kwian na gdaboke gbere kru na gdabokege ule Jesu ole, kwian e gdabonate agenga me no kwian skwe boanga, gdaite gbere kruge Jesu ko taingwli ngnagu giti, gdaite gbere kru nage Jesu ko jole ngnagu giti. ");
INSERT INTO sabNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Boidu ene ulita Chube gerua degaba unsuialin gerule kare, chada e gerule: “Ama boidu daga ngwale ule kwian agenga me no ole.” Chube gerua degaba unsuialin gerule ene Jesu giti. ");
INSERT INTO sabNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Kwian ulita bai kaire kledu joge tangle Jesu kle kruge ngaña ngwadi, kwian e ulita gwagedu Jesudi kruge gire ama chuga mliunga kidere Jesudi, ama gerudu me no tanre Jesuge: —¿Ba amaña me gerudu ba ñage u gerungwa Chube ole skiendba ulita gire gbeni naskuni no biale chui gbamaire alin? ");
INSERT INTO sabNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Bage suge ba kira molen tanre ene, gire ba mo jwennga kruge agali, ¡bai dbige kruge! ");
INSERT INTO sabNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Kwian ulita jo tangle Jesu kle kruge ngaña ngwadi gerudu ene kidere Jesudi, ene kaire kwian gerunga Chube ole daba alin chugagwalla ulita kaire kwian daba tkanga tangle Moisés chadalla giti ulita, kwian e ulita kledu eni, ama kidedu Jesudige, kwian e ulita gerudu me no modige Jesu giti: —Ama ñadu kwian na tanre chudaboi, agwa ama me ñage mo chudaboi agali dale mo jwennga kruge. ");
INSERT INTO sabNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ama ulia Cristo Chube nu ama kagaba nga dba ai giti, ama ulia kwian israelita ulita Chugagwalla kweri, ama mo jwanlenga agali kruge che ulita gwa giti, ene be suge che ulitage ama ulia Cristo gire che ulita be ama gai ulia. Kwian israelita chugagwalla ulita gerudu me no ene kidere Jesudi, kaire kwian gdaboke kledu Jesu ole kruge mo kaire ama gdabonate gerudu me no kidere Jesudi salengwli kwian na ulita kledu gerule kare. ");
INSERT INTO sabNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Chui chku bduke gire nga ulita nga dba ai giti chegu nga jereske, nga jere jagedu hora gdamai, chui jo chege nga bonga dbigu gire nga chra chiuni. ");
INSERT INTO sabNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Chui jo chege nga bonga dbigu gire Jesu ngautu kiraske mau kwirale: —Eloi, Eloi, ¿lema sabactani? —geru e gerule: “Cha Chubea, cha Chubea, ¿mineade ba cha chugu ngwadi boi daga ngwale gballa?” ");
INSERT INTO sabNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Kwian gweale kle ne ngwadi Jesu keruchugu, geru me sugedu trate kwian ege Jesu ngautu mine gire kwian e ulita gerudu modi: —Jesu kle ngaute kwian Chube gerua ketanga unsuialin kadakle Elíage. ");
INSERT INTO sabNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Kwian ulita kle ne ngwadi gerudu ene modi Jesu giti gire kwian e gdaite jo jrite Jesu chudaboi, kwian e lle dagli kare ñeu uva chia gageske gbu glita gwagdage ama jo Jesu krulladi gire glita giti ama uva chia gage gbu Jesu kate jadale ngaña kruge, gire ama gerudu kwian na ulita ole: —Ale manade gwage alin amadi Elías be chie ama jwen dbige kruge o me. ");
INSERT INTO sabNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesu ngautu kweri kiraske gire Jesu jokeda. ");
INSERT INTO sabNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Jesu jokeda ene gire sugeti ngwale ñometra ura kle itabanga gwa u gerungwa Chube olege, ñometra e skagedunga tainkwli bonga ngaña joge dba. ");
INSERT INTO sabNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Guardia donga chugagwalla kweri gdaite kledu Jesu gwangnagu, ama gwagedu ulita boidudi kaire ama Jesu keruchugu ngaute kweri kiraske gire Jesu jokeda, guardia donga chugagwalla gwagedu e ulitadi gire ama gerudu Jesu giti: —¡Ulia ulia kwian onbre ai Chube Kirolla! ");
INSERT INTO sabNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Kaire muinga tanre kledu gwage bate Jesudige Jesu boidu ulita giti, muinga e ulita nu chieba nga Galileage Jesu ole llagli, ama ulita nu chageba Jesu ole Jesu chudaboi baini kaire Jesu chagedu ngwadi, muinga e ulita nu jogeba chke una Jerusalénge ule Jesu ole Jesu gatedi. Muinga e ulitaske muinga gdaite kadakle María-Magdalena kledu. Kaire muinga na gdaite kadakle María kledu, María e ama kirolla boke gdaite kadakle José gdaite kadakle Santiago, ama José daballa soli. Kaire muinga na gdaite kadakle Salomé kledu. Muinga gdamai e kledu muinga na ulita ole gwage bate Jesudige Jesu jokeda kruge ngwadi. ");
INSERT INTO sabNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Jesu jokeda chuia, chui ege kwian ulita kle lle ulita gbe biale undege chuia ngwange suialin kare. Chui lle gbangwa bialege ngabi gire kwian onbre kadakle José mo ta gbu kiraske joge Jesu jaba kade chugagwalla Pilatoge. José nga Arimateamu ama kwian israelita chugagwalla gdaite, kwian ulita gwa giti José kwian no kwian ulita ama gai dage. José noare Chube ole ama kledu Chube chuia manade ngwange chui Chube be gerule kwian ulita giti kwian ulita Chugagwallale. José jo Pilato kledu ngwadi, ama gerudu Pilato ole: —Cha takalin Jesu jaba jwen dbige kruge ogadale keugage. ¿Cha ñage o me? ");
INSERT INTO sabNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato chegu tañachuge tanre, me uñadu Pilatoge Jesu jokeda ulia o kle gwade. Pilato guardia donga chugagwalla kweri kadu mo gitigu, Pilato geru kadu kwian ege: —¿Ulia Jesu jokeda? ");
INSERT INTO sabNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Guardia donga chugagwalla jaindunga Pilato kalen: —Ima, ulia Jesu jokeda sbaliga. Pilato guardia donga chugagwalla keruchugu gerule ene gire Pilato gerudu José ole: —Ba ñage Jesu jaba jwen dbige kruge dbe nga ogangwage ba takalin kare. ");
INSERT INTO sabNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Gerudre ene José ole gire José jo ñometra no glitale dbe Jesu jaba kledu kruge ngwadi, ñometra e Jesu jaba bliagda. José Jesu jaba jun dbige kruge, José Jesu jaba bliu no ñometra eske gire José jo Jesu jaba dbe nga jaba ogakle ngwadige, José Jesu jaba ogo keugage gire ama ke kweri bolole gbu keuga ugakallage gire nga chegu jenba trate. ");
INSERT INTO sabNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","José Jesu jaba ogo keugage ene gire muinga boke kledu eni gwage Josédi, muinga gdaite María-Magdalena, muinga gdaite María, María e José na chebia. Muinga e gdaboke gwagedu Josédi Jesu jaba oge. ");
INSERT INTO sabNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","2","Undege chuia jo tangle gire nagbietege chui domingoge ngabebitabi María-Magdalena kaire María na Santiago chebia kaire Salomé, muinga e gdamai jo lle ñachke no tanre dbe tkadale Jesu jaba giti, muinga nu lle ñachke e gigaba sábadoge ngajrege. Chui chku ngwale dbi giti gire muinga e ulita kledu chage Jesu jaba ogle ngwadi ngnagu, ");
INSERT INTO sabNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ama ulita kledu gerule modi jonkare: —¿Che be age mine? ¿Chema be kechuga kweri kle keuga ugakallage Jesu jaba ogle ngwadi jwennga che alin? Kechuga kweriare che me kira molen kechuga e jwen siere keuga ugakallage. ");
INSERT INTO sabNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ama kledu gerule ene jonkare, ama jo chke Jesu jaba ogle ngwadi, ama gwagedu kechuga kweridi klodegaba siere keuga ugakallage, keuga ugakalla chegeba ka ngwale. ");
INSERT INTO sabNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Muinga e ulita gdamainate jo chiga keugage gire ama gwagedu mo ko taingwli giti kirogwa bialedi, kirogwa biale e mo ngama tkaba ñometra jutreske ama kledu toiba dba Jesu jaba ogle ngwadi. Muinga e ulita kwachiu tanre kirogwa bialedi. ");
INSERT INTO sabNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kirogwa biale gerudu muinga ole: —Ba me kwachie, uñale chage ba kle Jesu una Nazaremu jinade nate. Ama me kle aini dale. Ulia ama gbere kruge, ama jokeda, agwa ama chkuni gwadeni. ¡Gwagede aini ama jaba ogle ngwadi, ama me kle aini dale, nege ama kle gwadeni! ");
INSERT INTO sabNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Joga blike kwian geru jwannga Jesuge gdataboko giti gdaite kle ngwadi, ba geru ketadale ama ulitage Jesu giti, ba geru ai kete Pedroge kaire kwian geru jwannga na ulitage: “Joga nga Galileage, Jesu be joge nga ege ba ulita ngeru, ne ngwadige ba be ten ama ngwange ama gerudu kare ba ole ama bebi jogekeda gire.” Ba gerudale ene Pedro ole kaire kwian geru jwannga na ulita ole. ¡Joga, joga! ");
INSERT INTO sabNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Kirogwa biale gerudu ene muinga gdamai ole gire muinga ulita jo kige keugage siere, ama ulita kledu gdajirenga tanre chru ole. Jonkare muinga me geru ketu kwiange dale, ama kwachiu tanre malen ama me geru e gbu chke uñale kwian nage Jesu giti. ");
INSERT INTO sabNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesu chkuni gwade chui domingoge ngabebitabi gire Jesu medu gwangea María-Magdalenage, María ege Jesu nu dolla gdaguke kagaba siere. ");
INSERT INTO sabNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Jesu medu muinga ege gire muinga jo, geru ketu kwian geru jwannga ulitage Jesu chkuni gwade giti, kwian e ulita kledu olire tanre Jesu nate. ");
INSERT INTO sabNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","María-Magdalena jo chke kwian geru jwannga kledu ngwadi, ama gerudu: —¡Jesu chkuni gwade! Ulia cha gwagedu amadi gwadeni. ¡Jesu kle gwadeni! Kwian geru jwannga Jesuge ulita María-Magdalena keruchugu gerule ene Jesu giti gire ama ulita María-Magdalena kerua gau ngwale, tañachugu María-Magdalena kle sole ama ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kwian geru jwannga Jesuge gdaboke kledu chage ngaske ngnagu, gire jonke Jesu medu amage. Kwian geru jwannga e gdabonate me chku Jesu uñe nate blikare, ");
INSERT INTO sabNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","agwa bigwa chku uñale trate ama bokege ulia Jesu amaña kledu chage ama ole jonkare gire ama joni kwian geru jwannga na kledu ngwadi, ama geru ketu dabage ulita Jesu giti, ama gerudu: —¡Jesu chkuni gwade ulia! Cha gwagedu amadi sbaliga jonkare. Kwian geru jwannga gdaboke gerudu ene Jesu giti geru jwannga na ulita ole, gire kaire kwian geru jwannga na ulita ama boke kerua gau ngwale ni gdaite ama kerua Jesu chkuni gwade giti gau ulia. ");
INSERT INTO sabNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Bigwa Jesu medu kwian geru jwannga ulita gdataboko giti gdaitege gwadeni, ama ulita kledu mo litaba blire gire Jesu chku, Jesu gerudu ama ulita ole: —Cha ta olire tanre ba giti. Kwian ulita bai kaire gwagedu chadi gwadeni ama geru kete bage cha giti, ni ba ama kerua gau ulia cha chkuni gwade giti, ba me kle mo ta gbe ulia cha ole. ");
INSERT INTO sabNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jesu ka bo ene kwian geru jwannga amage gdataboko giti gdaite ole gire Jesu gerudu dare ama ole: —Ba jogedale nga ulitage Chube gerua no cha giti kete kwian na ulitage. ");
INSERT INTO sabNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Kwian bai kaire ulita mo ta gbe cha gerua gai ulia, ba kwian e ñeadale chiske gai ngaña chigage. Kwian cha gerua gai ulia giti Chube be kwian e jwen siere ji chugege age me no gdale gire kwian e be toi diali chui tangle ule Chube ole nga ngaña giti. Agwa kwian bai kaire me cha gerua gai ulia ba geru kete amage kare, kwian ene Chube be ama kage ji chuge daga ngwale ngwadi toi diali sugekare Chubege. ");
INSERT INTO sabNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Kwian bai kaire ulita mo ta gbe cha gerua gai ulia, amage cha be kira kete lle daga ngwale no tanre dodade, cha kiralla giti kwian cha gerua ganga be ñage age ulita ai kare: Kwian cha gerua ganga be ñage dolla kage siere kwian jwligebangage, kaire ama be ñage gerule kwira nale ni ama geru jwanba giti, ");
INSERT INTO sabNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","kaire ama be ñage jorisi jwen kote ni jorisi be age me no ama ole, kaire ama be ñage veneno jai gire ni ama be oga venenodi ni ama be jogeda kote, kaire ama be ñage ko gbe kwian oga giti gerule Chube ole gire kwian oga be joge chkeni noni trate. Kwian cha gerua ganga be ñage age ene ulita cha kiralla giti —Jesu gerudu ene kwian geru jwannga amage ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Chugagwalla Jesu gerudu ene ulita kwian geru jwannga ulita ole ama ulita ta gbagda, Jesu gerudu ene ulita gire Jesu dule nga ngaña giti Chube kle ngwadi, Jesu toidu dba Chube ko taingwli giti kwian Chugagwalla kweri. ");
INSERT INTO sabNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Jesu joni nga ngaña giti ene, gire kwian geru jwannga Jesuge ulita jo nga ulitage Jesu ama kagu kare geru no Jesu giti kete kwian na ulitage. Jesu ama chudabo, Jesu mo kira ketu ama ulitage Jesu kiralla giti ama ulita lle daga ngwale no tanre dodadu kwian tanre na gwa giti, e giti kwian nage sugedu Jesu kle ama chudaboi age no kwianske.");
INSERT INTO sabNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Jesu kledu chage nga dba ai giti gire kwian tanre gwagedu mo gwagwa giti Jesudi Jesu boidu ulita mine nga dba ai giti. Kwian ene ulita chegu geru Jesu boidu giti trage kwian na ole, ene kwian tanre geru e keruchugu gire kwian e gweale geru Jesu giti degu ama geru keruchugu kare. ");
INSERT INTO sabNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","Cha gerule ba ole cha skatemanalla Teófilo, cha chagedu tanre geru e ulita jwen no ta giti, kaire cha geru kadu kwian tanrege Jesu giti, ene chku uñale no trate chage Jesu boidu mine ulita nga dba ai giti. Cha takalin geru e ulita chke uñale trate bage Teófilo, malen cha tañachuge noare cha geru ai ulita dege ba alin nege ta giti, ene geru ulia Jesu giti be chke uñale ma no ma trate bage kwian ba tku tangle Jesu gerua giti kare. Cha takalin geru ulita Jesu giti chke uñale trate bage. ");
INSERT INTO sabNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Kwian kada Herodes ama kwian ulita chugagwalla rey nga kweri kada Judeage, e suiale kwian onbre kada Zacarías kle toi nga Judeage. Zacarías kwian gerunga Chube ole daba alin, ama kle lle boi u gerungwa Chube olege ule kwian gerunga Chube ole tanre na ole, kwian gerunga Chube ole e ulita kwian gdaite unsuialin kada Abías mneitella, ama ulita Abías oña oindalla. Zacarías muingalla kada Elisabet, Elisabet kwian unsuialin gerunga Chube ole kada Aarón oña oindalla. ");
INSERT INTO sabNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zacarías kaire Elisabet kwian noare, ama bonate chagedu trate no Chube gwa giti, ama bonate Chube gau mo Chugagwallale, diali ama kle age Chube takalin kare Chube nu geru gbaba kare. ");
INSERT INTO sabNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Sbali Zacarías, Elisabet mo jun bdale, Zacarías toidu ule Elisabet ole agwa Elisabet muinga gballa ama me ñadu kirogwa molen, ama bonate toidu chui sbali ule ama jo juma juma me kirogwa molen gdaite. ");
INSERT INTO sabNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Chui chku gire Abías mneitella jogedale lle boi u gerungwa Chube olege, e suiale Zacarías jo chke kaire lle boale ule Abías mneitella kle age kare. Chui gbaitege kwian gerunga Chube ole ulita Abías mneitellanu blachke gbu ama ulita kle mo litaba eni alin, ene kwian gdaite bai blachke ama jogedale gwa u gerungwa Chube olege lle ñachke no kada incienso guge Chube gwa giti, chui ege Zacarías blachku joge gwa incienso guge jita ngama giti. ");
INSERT INTO sabNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Zacarías jo gballa dbige gwa incienso gugale gire kwian tanre mo litaba chegu goga gerule Chube ole. ");
INSERT INTO sabNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Zacarías kle incienso guge jita ngama giti gwa gire lle boanga Chube alin nga ngaña giti gdaite me chiu gda uñale kle jageba gdate jita ngamadi ko taingwli giti. ");
INSERT INTO sabNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zacarías gwagedu amadi Zacarías me tachku gda uñale Zacarías kwachiu tanre. ");
INSERT INTO sabNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Lle boanga Chube alin gerudu Zacarías ole: —Zacarías, ba me ta dbe kwachie, Chube cha kagu geru jige bage, sbali ba gerudu tanre Chube ole ba takalin kirogwage, e giti Chube ba keruchugu Chube be age no ba alin, ba muingalla Elisabet be kirogwa onbre molen, ba be kirogwa e ka gbe Juan. ");
INSERT INTO sabNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kirogwa e be chke Elisabet kote ba ta be suga noare kirogwa giti, nga be suga noare badi, kaire kwian na tanredi nga be suga noare. ");
INSERT INTO sabNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Kirogwa be chage no trate Chube gwa giti, ama me ñage mo chuge ngwadi lle gage jai dale ni uva chia jai, ama be kle chebiadige gire Chube Oña be kle ama ole, kaire ama chke chebia kote gire Chube Oña be kle ama ole diali chui gdale, ama be toi Chube Oña kirallaske diali. ");
INSERT INTO sabNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ama be kwian israelita tanre ta gbeni Chube ole, ene kwian israelita tanre be mo ta bliteni Chube ole be Chube gai mo Chugagwallale. ");
INSERT INTO sabNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Juan be joge ngeru gerule kwian ulita ole Chugagwalla be chie giti, ama be chage Chube Oña kiralla giti kwian unsuialin kada Elías chagedu kare. Ama be kwian ta gbe toi no mo bitalla ole, ñenua skochie kirogwa skochie me toi no ule, Juan be kirogwa ene ta gbe chke toi no mo ñenua ole ñenua ta gbe chke toi no mo kirolla ole. Kwian me Chube gai dage, kaire Juan be kwian ene ta gbe chke no Chube ole trate. Ene Juan be kwian ta gbe biale Chugagwalla ngwange. ");
INSERT INTO sabNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Lle boanga Chube alin gerudu ene Zacarías ole gire Zacarías geru kadu amage: —¿Mine be chke uñale chage e be boi ene ba kle gerule kare? Cha juma, cha muingalla kaire juma. ");
INSERT INTO sabNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Lle boanga Chube alin jaindunga: —Cha kada Gabriel, cha kle lle boi Chube alin, diali Chube kle cha kage, nege aini cha kle Chube gwa giti gerule ba ole, Chube cha kagu geru no ai kete bage. ");
INSERT INTO sabNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ulia chui be chke gire be boi ene ulita cha gerudu kare ba ole, agwa ba me cha gerua gau ulia malen nege gwangerugu ba mi ñage gerule, ba be chege kwian keru me kare, ba kirolla be chke ba muingalla kote gire ba be ñage geruleni —lle boanga gerudu ene ulita Zacarías ole gire ama joni. ");
INSERT INTO sabNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Kledu boi ene Zacarías ole gwa incienso gugangwage gire kwian nglea kledu Zacarías manade goga, ama ulita chegu tañachuge mo tale: “¿Mineade nga chegu ta Zacarías nate dbige gwa incienso gugangwage?” ");
INSERT INTO sabNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kwian nglea kledu tañachuge ene gire Zacarías chiu jondoi dbige. Zacarías me ñadu gerule kwian ole, Zacarías ko alin ñachugu kwian ole, Zacarías chegu kwian keru me kare. Kwian gwagedu Zacaríadi ene gire chku uñale kwiange Zacarías gwagedu lle gweale Chubenudi incienso gugangwage. ");
INSERT INTO sabNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Boidu ene ulita Zacarías ole gire Zacarías chegu lle boi u gerungwa Chube olege Abías mneitella ole chui gweale dare, Zacarías alin lle boi chuia ulita bidu gire Zacarías joni mo ullage. ");
INSERT INTO sabNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Zacarías jo chkeni mo ullage, chui gweale jo tangle gire Zacarías muingalla Elisabet chegu gaba. Elisabet chegu gwa mo ullage dai gdatiga, dai e gdatiga ulita ama me jo siere mo ullage chage kwianske, ama chegu gwa gerule mo tale: ");
INSERT INTO sabNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Chube cha Chugagwalla cha chudabo tanre malen nege cha ñadu chage gaba. Sbali kwian tanre cha gidadu cha me kirogwa molen, nege kwian ene mi ñage tañachuge me no chadi nge kare.” ");
INSERT INTO sabNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Dai gdadereke bebi joge tangle Elisabege gire Chube lle boanga mo alin nga ngaña giti gdaite kagu geru jige muinga kadakle Maríage. María toinga una kadakle Nazarege nga Galileage, María me chageba kwian onbre ole mo ñengula kare ni bitaite. María muinga biale mo chuia tkaba bebi mo jwen kwian onbre kadakle José ole, José enusulian oña David oindalla. Chube lle boanga mo alin kadakle Gabriel kagu llani María kle toi ngwadi geru jige Maríage. ");
INSERT INTO sabNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gabriel jo chke María ngwadi, ama gbi kadu Maríage: —¿Che kle mine? Ba dageare Chubedi, Chube kle ba ole kle age no no ba alin. ");
INSERT INTO sabNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Gabriel gbi kadu ene Maríage, geru e me chku suge Maríage, ama tañachugu mo tale: “¿Mineade ama gbi kadu ene chage?” ");
INSERT INTO sabNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Gire Gabriel gerudu María ole: —María, ba me kwachie, ba dageare Chubedi. ");
INSERT INTO sabNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ba be chage gaba, ba be kirogwa onbre molen, ba be kirogwa e ka gbe Jesu. ");
INSERT INTO sabNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Kaire agwe kirogwa e ka be chege Chube kweri nga ngaña giti Kirolla, kirogwa e be chege kweri. Chube be kirogwa e gbe kwian Chugagwallale kweri salengwli ama enusulian oña unsuialin kadakle David kare. ");
INSERT INTO sabNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Kirogwa e be chege kwian israelita ulita Chugagwallale diali, ama kiralla mi bidege dale. ");
INSERT INTO sabNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Gabriel gerudu ene María ole, gire María geru kadu Gabrielge: —Cha bebi mo jwen toi ule onbre ole, ¿mine cha be kirogwa molen? ");
INSERT INTO sabNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Gabriel jaindunga María kalen: —Chube Oña be chke badi, ene Chube kiralla giti ba be kirogwa molen, kirogwa e no trate ama Chube Kirolla. ");
INSERT INTO sabNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ba bitalla kada Elisabet me olia giti, ama juma juma be kirogwa molen kaire agwe, amage dai gdadereke chku. ");
INSERT INTO sabNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ulia Chube alin lle ulita me mno, Chube ñage age ulita. ");
INSERT INTO sabNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Gabriel gerudu ene María ole, gire María gerudu: —Cha Chubenu, ama cha Chugagwalla, cha be chege lle boangale ama alin, nobi cha alin ama be age cha ole ba kle gerule kare —María gerudu ene Gabriel ole gire Gabriel joni. ");
INSERT INTO sabNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","E suiale María me manadu, ama jo blike Elisabet ngwadi, Elisabet kle toi Zacarías ole unaske una chege jwichuga giti nga Judeage. ");
INSERT INTO sabNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","María jo chke gwa Elisabet ngwadi gire María gbi kadu Elisabege, ");
INSERT INTO sabNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabet María keruchugu gbi kade amage gire kirogwa Elisabedige skwendu ngaña Elisabedige, Chube Oña kiralla chku Elisabedige, ");
INSERT INTO sabNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","gire Chube Oña kirallaske Elisabet gerudu kiraske María ole: —Chube kle age noare ba alin, ba me muinga ulita kare, Chube ba gau muinga na ulitaske, kaire ba kirolla bebi chke ba kote Chube kle age no ama alin. ");
INSERT INTO sabNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Cha me muinga kweri ba cha Chugagwalla chebia kare, ¿lledale ba cha Chugagwalla chebia chiu basale chadi? ");
INSERT INTO sabNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ba gbi kadu chage, cha ba keruchugu gire blike cha kirolla skwendu ngaña nga suga no ole chadige. ");
INSERT INTO sabNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Noare ulia Chube nu geru kagaba ba alin ba geru gau ulia mo tale Chube be age ulita ba ole Chube gerudu kare. ");
INSERT INTO sabNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","47","Elisabet gerudu ene ulita Chube Oña kirallaske gire María gerudu: “Chube noare ulia, ama cha Chugagwalla, ama cha jwannga siere, nga suga noare chadi ama giti. ");
INSERT INTO sabNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","49","Chube cha Chugagwalla, ama ñage cha kage ama takalin kare, cha kwian ngwale, cha kwian ene gire Chube noare cha ole, ama kle cha manade diali. Chube noare trate ulita, ama me age me no ni sidri. Chube agedu no tanre cha alin mo kiralla giti, malen nege gwangerugu kwian ulita be gerule diali cha giti Chube agedu noare cha alin. ");
INSERT INTO sabNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Chube tai dage kwiange bai ama gai dage, Chube taidu dage kwian unsuialinge bai ama gau dage, Chube tai dage kwian negege bai kaire Chube gai dage, Chube be tai dage kwian bdaglige bai kaire be Chube gai dage. ");
INSERT INTO sabNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Chube kira molen tanre ama agedu tanre mo kiralla giti. Kwian gweale diali suge moge ama ma no kwian na ulitage, Chube kwian ene kagu sugekare mo kaire kaire, ene kwian e me ñage age kwian agali takalin kare. ");
INSERT INTO sabNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kwian chugagwalla nga dba ai giti daba ulita kage age chugagwalla takalin kare, Chube kwian chugagwalla ene gbu kwian ngwale kare, ene kwian e me ñage daba kage dare. Kwian ngwale kwian ulitaske Chube kwian ene gbu daba chugagwallale. ");
INSERT INTO sabNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Kwian me lle molen, Chube kwian ene gbu lle molen tanre. Kwian lle ngle molen, Chube kwian ene jigu me lle molen gbu chage ko ngwale. ");
INSERT INTO sabNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Chube kwian israelita ulita gau lle boangale Chube alin, Chube kwian e chudabo. Unsuialin Chube gerudu kwian israelita enusulian nge oña ulita ole Chube be tai dage kwian israelita kada Abrahamge kaire Abraham oindalla ulitage, Chube gerudu Chube be kwian ene chudaboi diali chui ulita. Chube agedu ene ulia Chube gerudu kare, kaire Chube be age dare no gwangerugu.” María gerudu noare ene ulita Chube giti. ");
INSERT INTO sabNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","María chegu toi Elisabet ole dai gdamai gire María joni mo ullage. ");
INSERT INTO sabNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Kirogwa chuia tigunga Elisabege gire kirogwa chku Elisabet kote, kirogwa onbre. ");
INSERT INTO sabNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Geru chku uñale Elisabet bitalla ulitage kaire kwian na tanrege kle toi kodi Elisabet ullage, kwian ene ulitadi nga chegu suga no Elisabet kirolla giti, ama ulita gerudu modi: —Nga suga noare cha ulitadi Elisabet kirolla giti, ulia Chube taidu dage amage, Chube agedu noare ama alin. ");
INSERT INTO sabNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kirogwage chuiapake chku gire kwian e ulita jo Elisabet ngwadi kirogwa kwara tkangenga sidri chada gbe kare kwian israelita ulita kle age kare, kaire chui ege kirogwa ka gbere, kwian ulita tadu kirogwa ka gbe ñenua kadakle kare, Zacarías, ");
INSERT INTO sabNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","agwa Elisabet gerudu: —Kirogwa ka mi chege Zacarías, ama ka be chege Juan. ");
INSERT INTO sabNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Kwian gerudu Elisabet ole: —¿Mineade ba be kirogwa ka gbe Juan? Ni ba bitalla gdaite kada Juan. ");
INSERT INTO sabNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Kwian gerudu ene Elisabet ole gire kwian ko alin ñachugu kirogwa ñenuage geru kade ñenuage ñenua takalin kirogwa ka chege mine. ");
INSERT INTO sabNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zacarías chada kadu kirogwa ka degagda, chada ketre Zacaríage gire Zacarías kirogwa ka degu ai kare: “Kirogwa ka be chege jwanle Juan.” Kwian ulita chada e batunga gire chegu tañachuge tanre mo tale e giti. ");
INSERT INTO sabNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Zacarías kirogwa ka degu ene gire blike ama ñaduni geruleni nge kare, gire ama gerudu tanre no Chube giti Chube agedu no ulita ama alin giti. ");
INSERT INTO sabNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Kwian ulita kle toi kodi Zacarías ullage gwagedu Zacaríadi boi ulita ene, kwian e ulita chegu tañachuge tanre Zacarías giti Zacarías kirolla giti, nga Judeage ulita kwian ulita geru tragu modi daba na ole e ulita boidu giti. ");
INSERT INTO sabNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Kwian ulita geru keruchugu e giti, sugedu kwiange ulita kirogwa e me kirogwa ulita kare agwa ulia Chube kiralla kle kirogwa e ole, malen kwian ulita chegu tañachuge tanre boidu ulita giti, kwian geru kadu mo tale kirogwa giti: “¿Kirogwa e be joge juma be chege mine?” ");
INSERT INTO sabNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Boidu ene ulita gire Chube Oña Juan ñenua Zacarías ta gbu gerule Chube be age giti kwian israelita ulita alin, Zacarías gerudu: ");
INSERT INTO sabNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Cha tale nga suga no no Chube giti, ama noare ulita, ama kwian israelita ulita Chugagwalla. Che kwian israelita ulita Chubenu, Chube be chie che chudaboi, be che ulita jwen siere ji chugege age me no gdale. ");
INSERT INTO sabNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Chube be che jwannga siere kage che alin, ama kira molen, ama David oña oindalla, David che enusulian oña lle boanga Chube alin unsuialin. ");
INSERT INTO sabNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Unsuialin Chube gerudu kwian Chube gerua ketanga ole, gire kwian e Chube gerua ketu daba na ulitage, ");
INSERT INTO sabNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Chube gerudu ama be che jwen siere kwian agenga me no che dollalege, kwian kle dole che ole kwian ta me no chedi, kwian ene ulitage Chube be che jwen siere. ");
INSERT INTO sabNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Chube gerudu che enusulian oña nge ole Chube be tai dage che kwian israelita ulitage be age no che ulita alin. Chube be age ene ulia ama gerudu kare, mi geru e talla mlienga. ");
INSERT INTO sabNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Chube gerudu che enusulian oña kada Abraham ole ulia Chube be Abraham chudaboi kaire Chube be Abraham bdadalla nabitaite ulita chudaboi. ");
INSERT INTO sabNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Kaire Chube gerudu unsuialin Abraham ole Chube be che jwen siere kwian che dollalege ene che me ta dbale kwachie ni sidri lle boi no Chube alin, ");
INSERT INTO sabNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ene che be kle diali mo ta gbaba Chube ole chage no trate Chube gwage. Che mo ta gbale joge siere ulita age me noge Chube gwa giti, che mo ta gbadale ene diali chui ulita che be kle toi gwade gire.” ");
INSERT INTO sabNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Zacarías gerudubi ene kwian ulita ole Chube giti gire gerudu mo kirolla alin ole, Zacarías gerudu: “Ba cha kirolla, ulia Chube kweri kira molen, ba kirogwa amanu, ba joge juma ba be chege lle boanga Chube alin Chube gerua ketangale daba nage, Chube be ba kage gerule kwian ulita ole ngeru Chugagwalla be chie giti, ba be kwian ta gbe biale Chugagwalla kweri ngwange. ");
INSERT INTO sabNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ba be Chube gerua trage kwian israelita ole, ene ba giti be chke uñale kwian israelitage ama ñage tien gitiru ji chugege agedu me no ulita gdale, ama ba gerua Chube giti gai ulia, ene ama agedu me no ulita Chube be talla mlienga. ");
INSERT INTO sabNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Chube noare kwian ulita ole, Chube tai dage che kwian israelita ulitage malen Chube be kwian jwannga siere kage che ulita alin, kwian jwannga siere be chie kwian ta gbale suge ma no trate Chube giti chui chra kle chie ngabebita kle kwian gbe ten kare. ");
INSERT INTO sabNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Kwian me Chube uñe kle toi nga jereske kare kle toi kennga tanre jogedadi, ba be kwian ene ulita ta gbe suge Chube giti, ene ama mi chage dare nga jereske kare, ba giti kwian tanre be mo ta gbe chage no Chugagwalla nga suga no mauña ngwange salengwli chui chra kle kwian gbe ten kare.” Zacarías gerudu ene ulita mo kirolla Juan ole Chube Oña kirallaske. ");
INSERT INTO sabNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Chui chagedu kirogwage kirogwa kledu tige no trate, kaire kirogwa jo ta ole Chube kiralla giti. Jo juma gire jo toi nga gballage kwian me kle toi ngwadi, kledu toi nga ege gire ama chuia chku gerule Chube giti kwian israelita ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","2","Kwian kada Augusto, ama kwian nga kweri ulita chugagwalla emperador, kwian na kada Cirenio ama kwian chugagwalla gobernador nga kadakle Siriage, e suiale Augusto geru gbu kwian ulita alin nga ulitage kwian ulita mo ka gbadale chada giti, ene be chke uñale Augustoge kwian gdabaige kle toi nga ulitage. Augusto kwian gwangea geru e kare gbe kwian ulita alin kwian ulita nga ulitage teanle. ");
INSERT INTO sabNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Augusto geru gbu ene kwian ulita alin gire kwian ulita joni mo enusulian jwiage mo ka gbe chada giti. ");
INSERT INTO sabNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","E suiale kwian kadakle José kledu toi una kadakle Nazarege nga Galileage gire Augusto gerua jo chke Josége. José jo kaire mo enusulian jwiage una kadakle Belénge nga Judeage, una Belén José enusulian oña kadakle David jwia. ");
INSERT INTO sabNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","José jo una Belénge mo ka gbe chada giti José bebi mo jwen muinga kadakle María ole, ama jo María dbe ule gire e suiale María kledu chage gaba. ");
INSERT INTO sabNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","José jo chke una Belénge María ole, kledu una Belénge gire Maríage chui chku María be kirogwa molen. ");
INSERT INTO sabNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Mo ka gbe chada giti suiale kwian tanre jogeba chke una Belénge, José alin María alin u me skwendu gbengwa, malen chbi ulla ketre amage gbengwa, ne ngwadi María kirolla kimule chku María kote, María kirogwa bliuda ñometraske, gbu chbi blingwalla tabale, ni u gbaite kle ngwale José alin chegengwa ule kirogwa ole María ole. ");
INSERT INTO sabNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kodi una Belénge kwian bda oveja mananga tanre kledu oveja manade kegda giti ngajrege. ");
INSERT INTO sabNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kwian kle oveja manade gire Chube lle boanga mo alin nga ngaña giti gdaite kagu geru jige bda oveja mananga e ulitage. Lle boanga Chube alin e gdaite medu kwian oveja mananga ulita gwage, gire Chube kiralla giti nga chratigunga kwian ulitadi tangle, kwian ulita kledu oveja manade kwachiu tanre ni gwageba boi enedi bitaite. ");
INSERT INTO sabNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Lle boanga Chube alin e gerudu ama ulita ole: —Ba me kwachie, cha kle chage geru noare jige bage kwian ulita alin. Kwian ulita be geru ai cha kle kete bage uñe, nga be suga noare amadi geru ai giti. ");
INSERT INTO sabNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Cha geru kete ba ulitage, nege ba enusulian oña David unallaske kirogwa no no chku chebia kote, kirogwa e kwian ulita jwannga siere ji chugege kwian agedu me no gdale. Sbali Chube gerudu be ama kage, nege ama chku kwian ulita alin kaire agwe ba ulita alin, ama kada Cristo, ama che Chugagwalla. ");
INSERT INTO sabNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Cha nga gbe egdage ba ulita alin, ba ulita be joge, kirogwa be skwen bage bliabada ñometraske chbi blingwalla tabale, ene be chke uñale bage cha gerudu ulia ba ole cha kle geru kete bage kare. ");
INSERT INTO sabNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Lle boanga Chube alin gdaite e gerudu ene gire sugeti lle boanga Chube alin na tanre chku daba nate, ama ulita chku gerule noare Chube giti. ");
INSERT INTO sabNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","15","Ama ulita gerudu: —Chube noare, ama kweri, nga ngaña giti Chube ngwadi nga suga no no cha ulitadi Chube kle age giti no kwian nga dba ai giti alin. Nege gwangerugu kwian ulita bai kaire alin Chube age no, nga be suga noare kwian ene ulitadi, kwian ene be ta dbe no Chube ole kaire agwe be ta dbe no daba na ulita ole nga dba ai giti —lle boanga Chube alin gerudu ene gire ama ulita joni nga ngaña giti. Oveja mananga gerudu modige: —Lle boanga Chube alin nga ngaña giti chku Chube gerua jige che alin, ale llani una Belénge tienda boidu minedi. ");
INSERT INTO sabNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ama ulita jo jrite blike kirogwa jinade nate una Belénge, jo chke llani gire María kaire José kaire kirogwa onbre soli skwendu oveja mananga ulitage, kirogwa kle chbi blingwalla tabale. ");
INSERT INTO sabNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Oveja mananga ulita gwagedu kirogwadi, gire ama lle boanga Chube alin nga ngaña giti gerua tragu kwian na ole ulita lle boanga Chube alin geru ketu amage kare kirogwa giti. ");
INSERT INTO sabNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kwian tanre oveja mananga keruchugu geru e trage, kwian e ulita chegu tañachuge tanre noare oveja mananga keruadi gerule kirogwa giti. ");
INSERT INTO sabNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","María chegu kamne María geru keruchugu geru ogo mo tale ulita, María me ta jonga geru ege mo tale. ");
INSERT INTO sabNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Kwian oveja mananga ulitadi nga suga no no, ama joni geru trage modi jonkare gerule no Chube giti, ama gerudu: —¿Chema Chube kare ñage age ene no? Chube alin ñage age no ene ulita, boidu ulita lle boanga Chube alin nga ngaña giti gerudu kare che ole. ");
INSERT INTO sabNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","María kirollage chuiapake chku gire kirogwa kwara tkerenga sidri chada gbe kare kwian israelita ulita kle age kare. Kirogwa ka gbere Jesu, lle boanga Chube alin nga ngaña giti ka e ketu ngeru Maríage María bebi chage gaba gire. ");
INSERT INTO sabNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","José, María mo ta gbu age ulita kirogwa soli Jesu giti Moisés nu Chube gerua degaba unsuialin gerule kare, chada e gerule: “Kirogwa onbre chke chebia kote, ñenua, chebia manadale dai gdaite giti chui gbataboko gire ñenua, chebia jogedale u gerungwa Chube olege beusi gbaboke dbe gugale bda gugangwage Chube gwa giti, ene ñenua, chebia chege no trate Chube gwa giti. Kwian me ñage beusi dbe kwian bdada soli chke beusidi kare dbadale gbaboke gugadale.” Moisés chadalla gerule ene malen José, María jo una Jerusalénge bdada dbe gugadale bda gugangwage Chube gwa giti u gerungwa Chube olege. Kaire ama Jesu du ule una Jerusalénge Jesu kaite Chubege Moisés nu Chube gerua degaba unsuialin gerule kare, chada e gerule: “Chebia biale kirogwa onbre molen kimule, chebia kirogwa e kaitadale Chubege lle boangale Chube alin, kirogwa e Chubenu.” María, José jo chke u gerungwa Chube olege una Jerusalénge, ama agedu ulita Moisés chadalla gerule kare. ");
INSERT INTO sabNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","E suiale kwian onbre kada Simeón kle toi una Jerusalénge, ama kwian no kle mo ta gbe diali chage no trate Chube ole kle Chube gai dage. Simeón kledu chui manade ngwange gire Chube be kwian jwannga siere kage kwian israelita ulita chudaboale, diali Chube Oña kledu Simeón ole ta gbe manade ta no ole. ");
INSERT INTO sabNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Sbali Chube Oña geru ketu Simeónge ngeru jogedage Simeón be gwage Cristodi, Chube be Cristo kage kwian israelita ulita alin Chube gerudu kare. ");
INSERT INTO sabNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Chube Oña Simeón ta gbu joge u gerungwa Chube olege malen Simeón kledu u ege gire José, María jo chke Jesu dbe u gerungwa Chube olege Jesu kaitadale Chubege Moisés nu Chube gerua degaba unsuialin gerule kare. ");
INSERT INTO sabNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeón gwagedu Jesudi, sugedu Simeónge e Cristo malen Simeón Jesu jun kote gire Simeón gerudu no no Chube ole: ");
INSERT INTO sabNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","“Cha Chugagwalla, cha lle boanga ba alin nga dba ai giti, noare cha ñadu gwage kwian jwannga sieredi, noare ba ama kagu kwian ulita alin. Nege cha ñage jogeda ta no no ole, ba agedu ba gerudu kare cha ole, ");
INSERT INTO sabNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ba Cristo kagu kwian nga ulitage alin. ");
INSERT INTO sabNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Cristo giti kwian me israelita be ba uñe, ba Cristo kagu jichra kare kwian me israelita alin, ene kwian me israelita be ba uñe, kwian me israelita be gerule no no kwian banu israelita giti.” ");
INSERT INTO sabNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeón gerudu ene Chube ole Jesu giti, José, María geru e keruchugu, chegu tañachuge tanre noare geru e giti. ");
INSERT INTO sabNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Gire Simeón gerudu José ole María ole kirogwa ole: —Cha takalin Chube age no no ba ulita alin. Simeón gerudu ene gire gerudu kirogwa chebia María ole: —Chube kirogwa ai kagu nga dba ai giti kwian ulita alin, ama be gerule Chube giti kwian ulita ole, ene ama giti kwian tanre be Chube uñe. Kaire ama giti be chke uñale nate kwian israelita ulita ta mine Chube ole, kwian israelita gweale be ba kirolla gerua gai ulia, kwian e be tien gitiru ji chugege age me no gdale, gweale na mi ba kirolla gerua gai ulia, bdagli Chube be kwian e gbe ji chuge tirare diali chui tangle age me no gdale. Ba be ta dbe dageare ba kirollage, kwian tanre be mo tke dole ama ole malen ba be ta dbe olire tanre ama giti —Simeón gerudu ene María ole Jesu giti. ");
INSERT INTO sabNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Chui ege muinga kada Ana kledu u gerungwa Chube olege, Ana Chube gerua ketanga, ama onbre kada Fanuel jian, Ana onbre israelita unsuialin kada Aser chudalla. Ana muinga juma juma, chura ochenta y cuatro chkeba amage. Ana mo jun bdale bdale, chura gdaguke toidu ule ñengula ole, gire ñengula jokeda, Ana chegeba oli onbrege. Ana noare Chube ole, ama gerule diali Chube ole u gerungwa Chube olege, ama lle boi nga ju nga jere Chube alin, chui gwealege ama mo tke bagere bligdage, me blire chuiete ulita, ama chege gerule Chube ole chui ulita bliage. ");
INSERT INTO sabNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simeón kle gerule kirogwa Jesu giti gire Ana chku Simeón kle ngwadi Jesu ole, Ana Simeón keruchugu gire Ana gerudu Chube ole kirogwa giti: “Chube, noare ba kirogwa ai kagu nga dba ai giti kwian ulita alin.” Ana chegu gerule kirogwa Jesu giti kwian ulita una Jerusalénge ole kwian bai kledu kwian jwannga siere manade. ");
INSERT INTO sabNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","José, María agedu ulita Moisés nu Chube gerua degaba gerule kare, gire José, María joni kirogwa dbe nga Galileage, jo chkeni mo ullage una Nazarege. ");
INSERT INTO sabNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Una ege kirogwa Jesu toidu José ole María ole, chui chagedu Jesuge Jesu tigedu no kaire Jesu jo ta ole Chube kiralla giti, diali Chube agedu noare kirogwa Jesu alin Chube Jesu gbu tige ta molen tanre ole. ");
INSERT INTO sabNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Chura kaire kairege kwian israelita ulita kle Pascua chuia ollade una Jerusalénge, chui ege kwian israelita kle tachkeni Chube ama enusulian unsuialin ulita jun siere nga Egiptoge. Diali Jesu ñenua, Jesu chebia kle joge una Jerusalénge Pascua chuia ollade ule kwian nglea ole. ");
INSERT INTO sabNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jesuge chura gdataboko giti gdaboke chku gire José, María jo una Jerusalénge chui ollade ama kle age diali kare, Jesu jo ule. ");
INSERT INTO sabNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","José, María chui olladubi gire joni chage una Nazaret ngnagu, me uñadu Josége Maríage kirogwa Jesu cheguda una Jerusalénge. ");
INSERT INTO sabNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","José, María joni chage kwian tanre ole, ama bonate tañachugu Jesu kle chage kwian ngleaske skatemanalla ole. Ama chagedu kwian nglea ulita ole chui gbaite, chui e jo tangle gire ama tañachugu ma no ama Jesu jinade nate kwian ngleaske. José, María Jesu jinadu jinadu, ");
INSERT INTO sabNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Jesu me skwendu Josége Maríage gire José, María joni naskuni Jesu jinade una Jerusalénge baini chagedu ngwadi. ");
INSERT INTO sabNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","José, María jo chkeni una Jerusalénge Jesu jinade nate, mongike gire Jesu skwendu nate Josége Maríage u gerungwa Chube olege. Jesu kle gwa u ege toiba dba geru trage kwian daba tkanga tangle geruge tanre ole, Jesu kle kwian e gerua keruchuge, kle geru kade tanre amage. ");
INSERT INTO sabNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Kwian daba tkanga tangle e ulita kaire kwian na kle Jesu keruchuge, kwian ulita kle gwage Jesudi tañachuge tanre Jesudi, ni kirogwa gdaitedi kwian keruchugaba gerule ene Jesu kle gerule kare, kwian ulita chegu tañachuge mo tale Jesu giti: “¿Mineade kirogwa e ñage gerule no ta giti ene? Amage kwian daba tkanga tangle kle geru kade gire kirogwa kle jainnga no ama kalen. Ulia kirogwa e ta ngleare molen, ama kle gerule no no ulita.” Kwian kle Jesu keruchuge chegu tañachuge tanre Jesu gerudu giti ulita kwian e ole. ");
INSERT INTO sabNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Josége Maríage Jesu skwendu geru trage kwian daba tkanga tangle ole u gerungwa Chube olege, José, María gwagedu Jesudi, chegu tañachuge tanre mo tale: “¿Mineade boidu ene? ¿Kaikwliade che kirolla ñage gerule no kwian daba tkanga tangle ole ta ngleare ole?” José María tañachugu ene mo tale Jesu giti gire María ka bo Jesu ole: —Cha kirolla, ¿mineade ba agedu ene cha ole? Cha ba ñenua ole kledu ba jinade nate tañachuge tanre ba giti. ");
INSERT INTO sabNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesu gerudu chebia kalen: —¿Mineade ba kle cha jinade nate? ¿Me suge bage cha chegedale cha Ñenua ullage lle boi cha Ñenua alin? ");
INSERT INTO sabNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","José, María Jesu keruchugu, agwa geru me sugedu ama bokege. ");
INSERT INTO sabNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Jesu joni gudegu ule José ole María ole, jo chkeni una Nazarege, una ege Jesu toidu José ole María ole Jesu José gau dage María gau dage diali. Jesu boidu ulita una Jerusalénge María geru e manadu mo tale, María me ta jonga geru ege mo tale. ");
INSERT INTO sabNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesu tigedu no kaire Jesu tigedu ta ngleare ole. Chube gwage kwian gwage Jesu diali agedu noare ulita, Chubedi kwiandi nga suga noare Jesu giti. ");
INSERT INTO sabNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Kwian kada Tiberio-César ama kwian nga kweri ulita chugagwalla emperador, ama chegu kwian chugagwallale churalla gdataboko giti gdatiga chku. E suiale Poncio-Pilato kwian nga Judeage ulita chugagwalla gobernador, Herodes kwian nga Galileage ulita chugagwalla Herodes daballa kada Felipe kwian nga Itureage ulita chugagwalla kaire kwian nga Traconitege ulita chugagwalla, Lisanias kwian nga Abiliniage chugagwalla. ");
INSERT INTO sabNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Kwian boke kada Anás kada Caifás ama gdaboke kwian gerunga Chube ole daba alin chugagwalla ma kweri. E suiale Zacarías kirolla kada Juan-Bautista gerule Chube giti kwian ole chuia chku, Juan-Bautista kle toi nga gballage gire Chube geru ketu amage tragadale kwian na ole. ");
INSERT INTO sabNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Chube geru ketu Juan-Bautistage gire Juan-Bautista jo chage chi kada Jordán kagdage ulita Chube gerua trage kwian ulita ole, Juan-Bautista gerudu kwian ulita bai ama tendu ngwange ole: “Ba ulita mo ta blitadale Chube ole, ba age me no chuge ngwadi me chage age me no dare, kaire ba mo chugadale ngwadi mo ñeange chiske kwian na gwa giti ene ba kle mo kaite nate kwian nage ba mi chage age me no ba chagedu ngeru kare. Ba age ene gire ba agedu me no ulita Chube be talla mlienga ama mi tañachuge dare ba agedu me no giti.” Juan-Bautista chagedu gerule ene kwian ole. ");
INSERT INTO sabNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Boidu ulita Chube gerua degaba unsuialin gerule kare, kwian Chube gerua ketanga kada Isaías chada degu Juan-Bautista giti, chada e gerule: “Nga gballage kwian gdaite kerua be suge kwian tanrege, ama be gerule: ‘Che Chugagwalla be chie, ba ulita kledale biale ama ngwange, ba mo ta gbadale biale trate no ama ngwange kwian kle jon lite trate biale chugagwalla ngwange kare. ");
INSERT INTO sabNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kwian kle jon lite trate biale chugagwalla kweri gai ngwange no ama kle nga kegdere jonkare ulita gbe no trate dba kegata kare, kaire kle jwichuga, dbira gbe no trate dba kegata kare, kle jon itole lite tainkwli kle jon sugaskare lite trate. Ene kaire ba ulita mo ta gbadale no trate biale che Chugagwalla be chie gai ngwange no, ");
INSERT INTO sabNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Chube be ama kage gire kwian ulita be gwage amadi ama kwian ulita jwannga sieredi.’ ” Isaías nu chada degaba unsuialin gerule ene. ");
INSERT INTO sabNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Kwian tanre chku Juan-Bautista kle ngwadi, kwian e ulita takalin Juan-Bautista ama ulita ñe chiske, Juan-Bautista gerudu ama ulita ole: —Ba ulita kwian agenga me no me no, diali ba ta agekalin me no Chube dollale, ba ta me no molen. ¿Chema geru ketu bage ba mo ñeange chiske alin allabi me mo ta blite Chube ole, ene ba tien gitiru ji chugege ba agedu me no gdale? ");
INSERT INTO sabNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Me ene dale. Ba ta tienkalin gitiru ji chugege ba agedu me no gdale ba mo ta blitadale Chube ole mo ta gbe chage trate no Chube takalin kare, ene kwian gwage badi ulia ba mo ta blitu Chube ole. Ba me ñage tañachuge mau giti: “Cha enusulian oña Abraham oindalla, malen Chube me ñage ji gbe cha giti cha agedu me no gdale.” Ba me ñage tañachuge ene. Cha gerule ba ulita ole, ba me mo ta blite Chube ole ba me ña tien gitiru ji chugege ba agedu me no gdale. Ba Abraham oindalla agwa ba me kle age Chube takalin kare. Chube takalin ama ñage ke blite Abraham oindallale gire ke e joge blitaba kwianle, kwian e be age Chube takalin kare. ");
INSERT INTO sabNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ba me mo ta blite ulia, ba salengwli gli me no kare, me gbachie no, gli ene alin gli mauña kle biale mochuga ole gli datagda, gli mauña be gli ene date guge ulita, ene kaire Chube kle biale ji gbe kwian me no giti bai kaire me mo ta blitakalin ulia Chube ole. ");
INSERT INTO sabNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Juan-Bautista gerudu ene kwian ulita ole gire kwian geru kadu amage: —¿Cha llema boadale gire cha ñage chage no Chube takalin kare? ");
INSERT INTO sabNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juan-Bautista jaindunga: —Ba camisa boke molen camisa gdaite ketadale kwiange kwian bai me camisa molen bitaite. Ba bligda molen bligda girabatadale kwian ole kwian bai me bligda molen sidri —Juan-Bautista gerudu ene kwian ole. ");
INSERT INTO sabNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Kaire kwian gweale igi ganga chugagwalla emperador nga Romamu alin chiu Juan-Bautista kle ngwadi mo ñeange chiske, ama geru kadu Juan-Bautistage: —Kwian tkanga tangle geruge, cha ulita igi ganga chugagwalla emperador nga Romamu alin, ¿cha llema boadale gire cha ñage chage no Chube takalin kare? ");
INSERT INTO sabNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juan-Bautista jaindunga: —Ba igi gadale mangire batre ba chugagwalla gerudu kare, me igi gai ma gitikanga sidri mau alin —Juan-Bautista gerudu ene kwian igi ganga ole. ");
INSERT INTO sabNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Kaire guardia donga gweale geru kadu Juan-Bautistage: —Cha guardia donga, ¿cha llema boadale gire cha ñage chage no Chube takalin kare? Juan-Bautista jaindunga: —Ba lle boi ñanale igi keta bage, igi e alin ole ba ta chegedale no. Ba me lle jwennga kwian ngeru, ba me kwian oña boi lle gdale, ba me kwian gbe jiske geru me ulia giti. ");
INSERT INTO sabNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Kwian ulita kle Juan-Bautista keruchuge chegu tañachuge mo tale Juan-Bautistadi: “¿Ama Cristo? Sbali Chube gerudu be kwian jwannga siere kage che ulita alin, ¿ama e Chube gerudu kare o me?” Kwian ulita chegu tañachuge ene manade Juan-Bautista be age mine ama ulita gwa giti ene chke uñale amage Juan-Bautista amaña Cristo o me. ");
INSERT INTO sabNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Kwian ulita kle tañachuge ene mo tale gire Juan-Bautista gerudu kwian ulita ole: —Cha me Cristo, agwa kwian gdaite be chie cha nate, ama Cristo, ama ma kira molen chage, ama be ñage age ma no kwian alin chage, ama be Chube Oña gbe kwian tale, ene diali kwian be chage Chube Oña ole, Chube Oña be kwian ta gbe age no diali Chube takalin kare. Cha ñage kwian ñe chiske alin, agwa cha me ñage Chube Oña gbe kwian tale kwian ta blite age Chube takalin kare. Ulia kwian gdaite be chie cha nate ama ma no ma kweri ulita chage, cha me ñanaske ama chudaboangale ni ama zapatolla jwennga ama serage. ");
INSERT INTO sabNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Kwian gdaite be chie cha nate kle biale kwian chage no Chube takalin kare jwen sugekare kwian me noge, kwian no be toi no Chube ole diali, agwa kwian me no be toi sugekare diali Chubege ji chuge chui tangle, kwian mi ñage joge siere ji chuge ege. E salengwli kwian kle trigo kwara batenga kare, trigo tagla no alin chege sugekare trigo kwara me noge, trigo tagla ogakle no agwa trigo kwara gugakle jitaske. Malen cha gerule ba ulita ole ba tienkalin gitiru ji chugege ba mo ta blitadale Chube ole. ");
INSERT INTO sabNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Juan-Bautista gerudu ene Cristo chie chuia giti, kaire chagedu geru na no Chubenu Cristo giti trage kwian ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Chui gbaite Juan-Bautista gerudu kwian nga Galileage ulita chugagwalla rey kada Herodes ole, Juan-Bautista ka bo Herodes ole: —Herodes, ba kle age tanre me no, ba kle toi muinga kada Herodías ole, ama me ba muiralla, ama ba daballa kada Felipe muiralla, me no ba kle age ene, kaire ba lle na tanre me no boabale, ba ta jwlitedale age nganake ba kle agege nege kare. ");
INSERT INTO sabNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Juan-Bautista ka bo ene Herodes ole, agwa Herodes me Juan-Bautista keru talladu, Herodes skochiu, kaire Herodes lle na me no bo, ama mo ta gbu Juan-Bautista tke skage Juan-Bautista ka bo ama ole kle age giti gdale. ");
INSERT INTO sabNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Juan-Bautista bebi tka skage gire ama kledu kwian ulita mo ta gbu Chube ole ñe chiske, e suiale Jesu kaire chku Juan-Bautista kle ngwadi mo ñeangale chiske Juan-Bautistage. Juan-Bautista Jesu ñeu chiske Jesu gau ngaña chigage gire Jesu gerudu Chube ole. Jesu kle gerule Chube ole gire nga ngaña giti nga tigedunga, ");
INSERT INTO sabNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Chube Oña chku dba Jesu giti beusi kare, gire Chube kerua sugedu Jesuge gerule nga ngaña giti, Chube gerudu Jesu ole: “Ba cha Kirolla, cha no no ba ole, nga suga noare chadi ba giti.” Kwian kledu enige Chube kerua sugedu ene gerule no mo Kirolla Jesu ole. ");
INSERT INTO sabNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesuge chura treinta chku gire ege gwangerugu Jesu lle bo kwian gwa giti gwangea Chube alin kwianske. Kwian ulita tañachugu Jesu José kirolla. José Elí kirolla, ");
INSERT INTO sabNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí Matat kirolla, Matat Leví kirolla, Leví Melqui kirolla, Melqui Jana kirolla, Jana José kirolla, ");
INSERT INTO sabNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José Matatías kirolla, Matatías Amós kirolla, Amós Nahúm kirolla, Nahúm Esli kirolla, Esli Nagai kirolla, ");
INSERT INTO sabNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai Maat kirolla, Maat Matatías kirolla, Matatías Semei kirolla, Semei Josec kirolla, Josec Judá kirolla, ");
INSERT INTO sabNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá Joanán kirolla, Joanán Resa kirolla, Resa Zorobabel kirolla, Zorobabel Salatiel kirolla, Salatiel Neri kirolla, ");
INSERT INTO sabNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri Melqui kirolla, Melqui Adi kirolla, Adi Cosam kirolla, Cosam Elmadam kirolla, Elmadam Er kirolla, ");
INSERT INTO sabNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er Josué kirolla, Josué Eliezer kirolla, Eliezer Jorim kirolla, Jorim Matat kirolla, ");
INSERT INTO sabNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat Leví kirolla, Leví Simeón kirolla, Simeón Judá kirolla, Judá José kirolla, José Jonám kirolla, Jonám Eliaquim kirolla, ");
INSERT INTO sabNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim Melea kirolla, Melea Mena kirolla, Mena Matata kirolla, Matata Natán kirolla, ");
INSERT INTO sabNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán David kirolla, David Isaí kirolla, Isaí Obed kirolla, Obed Booz kirolla, Booz Sala kirolla, Sala Naasón kirolla, ");
INSERT INTO sabNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón Aminadab kirolla, Aminadab Admin kirolla, Admin Arni kirolla, Arni Esrom kirolla, Esrom Fares kirolla, Fares Judá kirolla, ");
INSERT INTO sabNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá Jacob kirolla, Jacob Isaac kirolla, Isaac Abraham kirolla, Abraham Taré kirolla, Taré Nacor kirolla, ");
INSERT INTO sabNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor Serug kirolla, Serug Ragau kirolla, Ragau Peleg kirolla, Peleg Heber kirolla, Heber Sala kirolla, ");
INSERT INTO sabNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala Cainán kirolla, Cainán Arfaxad kirolla, Arfaxad Sem kirolla, Sem Noé kirolla, Noé Lamec kirolla, ");
INSERT INTO sabNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec Matusalén kirolla, Matusalén Enoc kirolla, Enoc Jared kirolla, Jared Mahalaleel kirolla, Mahalaleel Cainán kirolla, ");
INSERT INTO sabNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán Enós kirolla, Enós Set kirolla, Set Adán kirolla, Adán Chube kirolla. ");
INSERT INTO sabNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesu mo ñeangu chiske chi Jordánge, ne ngwadi Chube Oña chkeba dba Jesudige chi Jordánge Jesu mo ñeangu chiske ngwadi, Jesu jo siere nga ege gire Chube Oña ama ta gbu joge toi nga gballage. ");
INSERT INTO sabNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Nga gballage Jesu toidu chagere chui cuarenta Chube Oña ama ta gbu kare chage nga gballage. Jesu kledu toi nga gballa ege gire che dolla Satanás mo chugu tanre Jesu ole, Satanás tadu Jesu ta blitakalin age me no Chube dollale. Chui ngle cuarenta ulita Jesu me blidu dale, gire bdagli ama bli ole tanre. ");
INSERT INTO sabNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Uñadu Satanáge Jesu bli ole gire Satanás chku Jesudi mo chuge Jesu ole, Satanás gerudu Jesu ole: —Ba Chube Kirolla ulia ba ke ai blite bligdale mo alin ba gute. Ba ke blite bligdale ene be suge chage ulia ba Chube Kirolla. ");
INSERT INTO sabNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesu gerudu: —Cha mi age ba takalin kare, Chube gerua degaba unsuialin gerule: “Me bligda alin allabi giti kwian ñage toi, agwa kaire Chube gerua gai ulia giti kwian ñage toi no.” ");
INSERT INTO sabNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Jesu gerudu ene Satanás ole gire Satanás Jesu du jwichuga ngaña giti gire sugeti ngwale Satanás nga ulita nga dba ai giti kaitu Jesuge, ");
INSERT INTO sabNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Satanás gerudu: —¡Gwagede nga e ulita no nodi! Nga e ulita chanu, e ulita ketaba chage cha ñage nga e kete kwian bai kaire cha takalin karege. Cha takalin ba jongnagwa skute dba chadi cha gai dage gerule no cha giti, gire cha be nga e no no kweri ulita kete bage, ba be chege nga e ulita mauña, kaire ba be chege kwian nga ulitamu chugagwallale. ");
INSERT INTO sabNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Satanás gerudu ene ulita Jesu ole gire Jesu jaindunga Satanás kalen: —Cha mi age ba takalin kare, cha mi ba gai dage dale, Chube gerua degaba unsuialin gerule: “Chube kwian ulita Chugagwalla, kwian ulita mo Chugagwalla Chube alin allabi gadale dage gerule no ama alin giti, kaire kwian ulita mo ta gbadale no lle boi Chube alin allabi.” ");
INSERT INTO sabNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Jesu gerudu ene gire Satanás jo Jesu dbe una kada Jerusalénge, jo chke llani gire ama Jesu du ngaña u jiri bdagli giti u gerungwa Chube ole giti, jo chke ngaña gire Satanás gerudu Jesu ole: —Ba Chube Kirolla ulia ba skwen dbige aini. ");
INSERT INTO sabNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Chube gerua degaba unsuialin gerule: “Chube be lle boanga mo alin nga ngaña giti kage ba alin, lle boanga Chube alin be ba manade. ");
INSERT INTO sabNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Lle boanga Chube alin be ba gai ngwange kote, ene ba me lentige, ni ba sera lentige kege.” Chube gerua degaba unsuialin gerule ene malen ba ña skwen dbige aini ba mi lentige dale. ");
INSERT INTO sabNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesu jaindunga: —Cha mi age ba takalin kare, Chube gerua degaba unsuialin gerule: “Chube kwian ulita Chugagwalla, kwian me mo chugadale mo Chugagwalla Chube ole.” ");
INSERT INTO sabNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Bdagli Satanáge me chku boale age ama takalin kare Jesu ole, Satanás me ñadu mo chuge dare Jesu ole, Satanás Jesu chugu ngwadi ama jo siere Jesuge, chui gweale ama be mo chugakalin kwaite Jesu ole. ");
INSERT INTO sabNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Satanás mo chugu ene ulita Jesu ole nga gballage gire Chube Oña kiralla giti Jesu joni nga Galileage, Jesu jo chkeni nga Galileage gire geru Jesu giti chagedu nga ulitage nga Galileage. ");
INSERT INTO sabNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nga ege Jesu kwian tku tangle tanre Chube geruadi u mo litangwa Chube gerua jwanngwage, kwian ulita bai ama keruchugu gerudu Jesu giti: —Jesu noare, ama kle cha tke tangle no, kwian na me ama kare kwian tke tangle no. ");
INSERT INTO sabNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jesu chagedu kwian nga Galileage tke tangle gire Jesu joni mo jwiage una kada Nazarege Jesu manadre ngwadi. Jesu kledu una Nazarege gire kwian israelita undege chuia chku, chui ege Jesu jo u mo litangwa Chube gerua jwanngwage, u ege Jesu jo mo lite kwian ole Jesu kle age diali kare undege chuiage kaire kairege. Gwa u ege Jesu chku gdate kwian ulita gwangnagu Chube gerua degaba unsuialin batalenga kwian ulita alin. ");
INSERT INTO sabNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Kwian Chube gerua ketanga kada Isaías nu Chube gerua degaba unsuialin, chada e ketre Jesuge batadalenga. Jesu chada e treunda, geru kle degaba Jesu jinadu batadalenga, geru skwendu Jesuge gire ama geru e batunga kwian ulita alin, geru e gerule ene Jesu giti: ");
INSERT INTO sabNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Chube mo Oña ketu chage, Chube cha gbu geru noare trage Chube Oña kirallaske kwian ulita ole bai me lle molen. Chube cha kagu kwian ta olire tanre blite nga suga no ole, ene nga be suga noare kwiandi. Chube cha kagu kwian skage skajwennga, ene kwian me chege toi skage. Chube cha kagu kwian me gwagwa molen dodade gbe ten, ene kwian be ten no mo gwagwa giti. Kwian me ngwaña kwian nage Chube cha kagu kwian ene gbe toi ta suga no ole. ");
INSERT INTO sabNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Kaire Chube cha kagu geru trage kwian ulita ole: ‘Nege Chube chuia chku Chube be age no no kwian ulita alin.’ ” ");
INSERT INTO sabNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jesu chada batunga ene ulita, gire Jesu chada bliuda, Jesu chada ketuni kwian u manangage, Jesu toidu dba. Kwian ulita kle ne ngwadi chegu gwage tanre Jesudi alin, ");
INSERT INTO sabNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Jesu gerudu kwian ulita ole: —Nege geru ai kle degaba unsuialin kle boi ulia ba ulita gwa giti chada kle gerule kare. ");
INSERT INTO sabNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Kwian Jesu keruchugu gerule ene gire kwian kle mo litaba chegu tañachuge tanre noare Jesu giti, ama ulita gerudu Jesu giti modige: —Kwian e noare ulia, ama gerule noare ulita, ¿mineade ama ene? ¿Agwa e me José kirolla? ");
INSERT INTO sabNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesu gerudu kwian ulita ole: —Ulia ba be gerule geru uñale aige cha ole: “Ba kwian mo dodanga, nege mo dodade agali.” Kaire ba be gerule cha ole: “Cha geru keruchugu ba lle daga ngwale no tanre dodadu una Capernaumge, nege dodade kaire ene aini ba jwiage.” ");
INSERT INTO sabNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Jesu gerudu dare kwian ole: —Ulia cha gerule ba ole, kwian Chube gerua ketanga, ama jwiage bitalla me ama gai ngwange kwian Chube gerua ketanga ulia kare. ");
INSERT INTO sabNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Unsuialin muinga tanre me chegu kwian onbrege nga Israelge Elías suiale, Elías kwian Chube gerua ketanga, e suiale noi me boidu chura gdamai giti dai gdadereke, bli kweri gbere kwian ulita alin. ");
INSERT INTO sabNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Chube me Elías kagu muinga me chegu kwian onbrege kle toi nga Israelge chudaboi, me ene, agwa Chube Elías kagu muinga gdaite kle toi nga nage chudaboi, muinga gdaite me chegu kwian onbrege kle toi una kada Sarepta nga Sidónge, Elías muinga e chudabo. ");
INSERT INTO sabNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kwian Chube gerua ketanga na kada Eliseo, ama suiale kwian tanre oga nga Israelge kwara tuge jingmea kada lepra ole. Eliseo me kwian nga Israelge oga kwara tuge jingmea ole dodadu, me ene, agwa Eliseo kwian onbre gdaite kada Naamán toinga nga na kada Siriage dodadu. ");
INSERT INTO sabNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jesu gerudu ene kwian ole u mo litangwa Chube gerua jwanngwage, kwian ulita Jesu keruchugu, kwian skochiu tanre Jesudi tañachugu Jesu kledu gerule kwian ama jwiallamu dollale. ");
INSERT INTO sabNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Kwian ulita chku gdate Jesu dbe mlialenga unage, kwian Jesu du una jwichugalla gwagda giti, be Jesu mlienga kegdege. ");
INSERT INTO sabNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Agwa Jesu jwliteduda kwianske tangle, Jesu jo siere kwian e ulitage, kwian me ñadu Jesu mlienga kegdege kwian tadukalin kare. ");
INSERT INTO sabNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jesu jo siere una Nazarege jo chkeni una Capernaumge nga Galileage. Undege chuiage Jesu jo u mo litangwa Chube gerua jwanngwage, u ege Jesu kwian tku tangle Chube gerua giti. ");
INSERT INTO sabNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Kwian ulita kledu eni Jesu keruchuge chegu tañachuge tanre Jesu gerudu giti, kwian tañachugu mo tale: “¿Mineade ama ñage che tke tangle ene trate? Ama kle che tke tangle no kwian geru mauña kweri kare.” ");
INSERT INTO sabNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Jesu kledu kwian tke tangle ene gwa u mo litangwa Chube gerua jwanngwage, kwian onbre gdaite jwligebanga dolla kote kledu eni, dolla onbre e gbu ngaute kweri Jesudi: ");
INSERT INTO sabNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¡Jesu una Nazaremu, cha ulita chugene! Chage uñale ba chema, ba Chube Kirolla no trate, uñale chage ba chiu nga dba ai giti cha ulita gbe ji chuge. Cha me takalin ba cha gbe boi daga ngwale, ba cha ulita chuge ngwadi toi ngwedi. ");
INSERT INTO sabNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesu ka bo dolla e ole: —¡Chegede kamne, joga siere onbre ege! Dolla onbre e mliu dba kwian ulita gwa giti gire dolla jo siere onbrege, onbre chegu no ulita, me boidu dare. ");
INSERT INTO sabNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Boidu ene kwian ulita gwa giti, kwian chegu tañachuge tanre, ama ulita ta me jo sugano ama ulita gerudu: —¿Kle boi mine aini cheske? ¿Mine Jesu ñage gerule alin dolla ole gire dolla age ama gerule kare? Ama kle gerule dolla ole dolla jogedale siere kwian jwligebangage gire dolla kle ama kerua gai dage dolla joge siere ama gerule kare. ");
INSERT INTO sabNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Jesu dolla kagu siere onbrege giti geru e jo chage kwian ulitaske nga Galilea ulitage. ");
INSERT INTO sabNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesu jo siere u mo litangwa Chube gerua jwanngwage gire ama jo Simón ullage Simón ñemaña oga ngwadi, Simón ñemaña oga jabale nganagda ole, kwian tanre gerudu Jesu ole: —Cha takalin ba Simón ñemaña oga nganagda ole dodade. ");
INSERT INTO sabNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Gire Jesu jo oga ankwallage kodi, Jesu gerudu nganagda ole: —¡Joga siere muingage! Gire nganagda ulita jo siere blike muingage, sugeti ama cheguni noni chku gdate gire ama bli jinadu Jesu alin kaire kwian na ulita alin. ");
INSERT INTO sabNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Chui jo joge dba dbi giti kwian ngle kle no chiu oga tanre jingme ole dbe Jesudi dodadale. Jesu ko gbu kwian oga gdaite gdaite giti ulita, Jesu kwian oga ulita dodadu. ");
INSERT INTO sabNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Jingme jo siere kwian tanrege, kaire dolla jo siere kwian tanrege, dolla ulita kle joge siere kwiange gire gerudu Jesuge: —Ba Chube Kirolla. Jesu ka bo dolla ole: —Ba me gerule ene cha giti, joga kamne siere. Uñale dolla ulitage Jesu amaña Cristo, Chube nu Jesu kagaba kwian jwen siere ji chugege age me no gdale Chube nu geruba sbali kare, malen dolla gerudu Jesu Chube Kirolla. Jesu me dolla chugu ngwadi Jesu kalla itenga Jesu amaña Cristo Jesu Chube Kirolla, malen Jesu ka bo dolla ulita ole, Jesu me dolla gdaite chugu ngwadi gerule trate Jesu giti. ");
INSERT INTO sabNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Nagbietege ngabebitabi Jesu jo nga gballage kwian me ngwadi. Kwian ulita jo Jesu jinade nate, kwian jo chke Jesudige, kwian ulita gerudu Jesu ole: —Cha ulita me takalin ba joge siere chage. ");
INSERT INTO sabNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Jesu gerudu kwian ole: —Cha me ñage chegeda aini ba ulita ole, Chube cha kagu geru no kete kwian ulitage nga kaire kairege malen cha chagedale nga ulitage gerule kwian ole kwian ulita ñage Chube uñe, kwian mo ta blitadale Chube ole ene Chube be kwian jwen siere ji chugege agedu me no gdale. Chube cha kagu geru e kete kwian nga ulitage, malen cha me ñage chegeda aini, cha jogedale dare. ");
INSERT INTO sabNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Jesu gerudu ene kwian ole gire Jesu jo chage nga Galileage ulita, nga Galileage ulita Jesu chagedu Chube gerua trage kwian nga Galileamu ole u mo litangwa Chube gerua jwanngwage. ");
INSERT INTO sabNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Bitaite Jesu kle chibita kada Genesaret kagdage, kwian tanre chku sklie kejre Jesudi tangle, kwian ulita ta Chube gerua keruchugakalin. ");
INSERT INTO sabNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jesu gwagedu du kwara alindi gabonate kodi chibita kagda giti, kwian ngwe jwannga nu du jwanba kedagu, du mauña kle gdeba glige. ");
INSERT INTO sabNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Du e gaite Simónnu, Jesu jo chiga du ege, gire Jesu gerudu Simón ole: —Du binga bamlinga chibita kagdage. Simón du biunga, du chegu bamlinga chibita kagdage gire Jesu toidu dba du toli, ama kwian ngle ulita kle kedagu tku tangle Chube gerua giti. ");
INSERT INTO sabNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ama geru tragubi kwian e ole gire gerudu Simón ole: —Che joge chibita jerege gire ba gdeba tke chiske ngwe jwangda. ");
INSERT INTO sabNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simón jo du toli ule Jesu ole gire Simón gerudu Jesu ole: —Ba cha tkanga tangle geruge, cha lle bo tanre ule cha chagemanalla ole beigliga nga chiu ju nege, cha ni ngwe gdaite jun, gire ba cha kage chibita amañage cha be gdeba tke chiske nakwaite ba gerudu kare. ");
INSERT INTO sabNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Simón gerudu ene Jesu ole gire ama daba na ole gdeba tku chiske. Ama gdeba tku chiske gire ngwe tanre chku gdebage. Simón gdeba jun keda ngwe ngle kle gdebage, gdeba chege bedre gdeba dretenga ngwe ole. ");
INSERT INTO sabNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ama chagemanalla kle du nage bate, ama ko meagu mo gitigu ama chudaboi ngwe jwen keda. Ama chagemanalla chku amadi, ama Simón kaire daba na chudabo ngwe jwen keda, ama ngwe gbu du boke toli, du bonate chku ete ulita ngwe ole, du boke biri joge chiske ngwe tanre ole. ");
INSERT INTO sabNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simón-Pedro gwagedu ngwe tanredi gire ama jongnagwa skutu dba Jesu gwangnaru gerudu Jesu ole: —Cha Chugagwalla, suge trate chage ba noare kweri ba kiraske tanre, chage suge cha kwian agenga me no tanre, malen ma no ba me chage dare cha ole. ");
INSERT INTO sabNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simón ngwe tanre gau chagemanalla ole, ngwe e giti ama ulita ta me jo sugano ama ngwe jun giti, ama ulita chegu tañachuge mo tale: “¿Mineade che ngwe jun ngle ene?” ");
INSERT INTO sabNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Zebedeo kirolla kada Juan kada Santiago, ama boke Simón chagemanalla, ama chegu tañachuge tanre kaire. Jesu gerudu Simón ole: —Ba me chegedale tañachuge tanre, nege ba kwian ngwe jwannga agwa nege gwangerugu cha be ba gbe kwian gangale cha gerua giti, ene ba giti kwian ngle be cha gerua gai ulia. ");
INSERT INTO sabNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Jesu gerudu ene Simón ole, gire Simón jo ule Jesu ole Juan ole Santiago ole du dbe chibita kagda ngnagu, ama jo chkeni chibita kagdage gire Simón kaire Juan kaire Santiago lle chugu ngwadi ulita gire jo chage Jesu ole geru jwen amage. ");
INSERT INTO sabNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Chui gbaite Jesu kle una gdaitege gire kwian onbre gdaite oga trate jegwale chku Jesu kle ngwadi, ama oga jingme kwara tuge ole. Kwian oga e gwagedu Jesudi gire ama mo ñeu dba jongnagwa giti kaboge dba dbidi Jesu gwangnaru, ama gerudu Jesu ole: —Ba takalin cha dodade, uñale chage ba ñage jingme ai jwen siere chage ene cha chege trate jingme aige. ");
INSERT INTO sabNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Kwian oga gerudu ene Jesu ole gire Jesu ko gbu ama giti, Jesu gerudu: —Cha takalin ba jingmea jwen siere bage, nege nege ba chege no trate. Jesu gerudu ene gire sugeti jingme jongwa kwiandi, kwian oga chegu noni. ");
INSERT INTO sabNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesu gerudu dare kwian jo chkeni ole: —Ba me gerule ni kwian gdaite ole cha ba dodadu giti agwa ba agedale Chube nu geru gbaba unsuialin kwian alin Moisés giti gerule kare, chada e gerule ba agedale ai kare: Joga u gerungwa Chube olege mo kaite kwian gerunga Chube ole daba alinge, ba bdada gbaboke dbadale ule gugadale Chube gwa giti u ege ba chegu no trate ñanale, joga age ene ulita gire be chke uñale kwian ulitage ba jo chkeni no ba jingmeage —Jesu gerudu ene kwian onbre jo chkeni ole. ");
INSERT INTO sabNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Chui ege gwangerugu geru Jesu giti chagedu ma dare kwian ulitaske malen diali kwian tanre kledu mo lite Jesudi Jesu gerua keruchuge, kaire kwian tanre oga chku Jesudi Jesu ama dodadale. ");
INSERT INTO sabNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Chui gwealege Jesu joge nga gballage geru trage Chube ole agwa gire chieni kwian chudaboi nakwaiteni. ");
INSERT INTO sabNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Bitaite Jesu kledu kwian tke tangle gwa gire kwian fariseo mneite kaire kwian daba tkanga tangle Moisés chadalla giti mneite kle toiba dba Jesu kle kwian tke tangle ngwadi, kwian e gweale nu chieba una ulitage nga Galileage kaire una ulitage nga Judeage kaire una Jerusalénge, una e ulitage kwian e nu chieba. Kaire kwian na tanre kledu eni Jesu keruchuge. Jesu kle kwian tke tangle kaire kle kwian oga dodade Chube kiralla giti, ");
INSERT INTO sabNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","gire kwian na gweale chiu daba oga gdaite skliebada trate jegwale dbe ankwage Jesu kle ngwadi dodadale, kwian e kle no tadu daba oga e dbe ugakage gudegu gbe Jesu gwangnaru. ");
INSERT INTO sabNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Agwa kwian tanre kle gwa sklieba kejre ulita ugakage malen daba oga dbanga ulita me ñadu tien gudegu oga ole, gire jo oga dbe ankwage u giti bdugu, jo chke u giti ama u uga degunga ankwa tien mangire batre gire ama ankwa kagu giskage dbige Jesu gwangnaru. ");
INSERT INTO sabNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesu gwagedu kwian ogadi gire uñadu Jesuge kwian oga kaire kwian oga dbanga ulita mo ta gbaba ulia Jesu ole Jesu ñage kwian oga dodade, malen Jesu gerudu kwian oga ole: Kwian israelita ulla —Cha gerule ba ole, ba ageba me no ulita talla cha mlienga, nege ba chege no trate me jiske Chube gwa giti. ");
INSERT INTO sabNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Jesu gerudu ene kwian oga ole gire kwian daba tkanga tangle Moisés chadalla giti ulita kaire kwian fariseo ulita tañachugu mo tale Jesudi: “¿Mineade onbre e kle gerule ene kwian oga ole? Ama me ñage gerule ene, ama kle mo gbe kweri Chube kare. ¿Chema ñage kwian age me no ulita talla mlienga kwian gbe no trate me jiske Chube gwa giti? Chube alin allabi ñage, onbre e me ñage age ene Chube kare.” ");
INSERT INTO sabNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Kwian kledu tañachuge ene mo tale Jesudi gire Jesuge uñadu ama ulita kle tañachuge giti, Jesu geru kadu ama ulitage: —¿Mineade ba ulita kle tañachuge ene chadi? ");
INSERT INTO sabNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Bai ma mno cha alin: kwian oga ai ageba me no ulita talla mlienga o kwian oga ai dodade jingmege? Cha alin ai me mno ulita gdabonate. ");
INSERT INTO sabNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Nege cha be kwian oga ai dodade ba ulita gwa giti ene be chke uñale bage ulia Chube cha kagu nga dba ai giti kwian kare, Chube kiralla giti cha ñage kwian oga dodade jingmege kaire agwe cha ñage kwian age me no ulita talla mlienga kwian gbe no trate me jiske Chube gwa giti. Jesu gerudu ene kwian fariseo ulita ole kaire kwian daba tkanga tangle Moisés chadalla giti ulita ole, gire Jesu gerudu kwian oga ole: —Nege cha gerule ba ole, chkede gdate mo ankwalla gai blienga dbadale, jogani chage ba kle toi ngwadige. ");
INSERT INTO sabNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Jesu gerudu ene gire kwian oga skliebada chku gdate blike trate no kwian ngle gwa giti, ama mo ankwalla gau kote joni chage ama kle toi ngwadige gerule noare Chube giti. ");
INSERT INTO sabNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Kwian ngle ulita gwagedu ai ulita boidudi gire kwian ulita ta me jo sugano kwian ulita chegu tañachuge tanre, kwian gerudu noare Chube giti: —Chube noare, ama kira molen ulita, nege Chube kiralla giti Jesu kwian oga skliebada trate jegwale dodadu che ulita gwa giti, ni bitaite che nu gwageba boi ene karedi, ulia Chube no no —kwian ulita gerudu no ene Chube giti. ");
INSERT INTO sabNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Jesu kwian oga skliebada dodadu ene gire Jesu jo chage dare, ama gwagedu kwian onbre kada Levídi. Leví kwian igi ganga chugagwalla emperador nga Romamu alin, ama kledu toiba dba nga igi ketakle ngwadi igi gai kwiange gire Jesu chku amadi gerudu ama ole: —Bai chage cha ole geru jwen chage. ");
INSERT INTO sabNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Jesu gerudu ene gire Leví chku gdate, lle chugu ngwadi ulita, jo chage Jesu ole. ");
INSERT INTO sabNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Leví Jesu du ule kwian geru jwannga Jesuge ulita ole mo ullage blire, Leví jo chkeni mo ullage, bligda dodangu no Jesu alin. Kaire kwian na tanre kle Leví ullage, ama gweale igi ganga chugagwalla emperador nga Romamu alin Leví kare, kwian e ulita blidu ule Jesu ole Leví ole. ");
INSERT INTO sabNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Kwian ulita kle blire kle geru trage gire kwian fariseo mneite kaire kwian daba tkanga tangle Moisés chadalla giti mneite kledu eni gwagedu kwian tanredi blire ule kwian geru jwannga Jesuge ulita ole, ama ulita ka bo geru jwannga Jesuge ole: —¿Mineade ba kle blire ule kwian igi ganga chugagwalla emperador nga Romamu alin ole kaire kwian na tanre agenga me no ole? ");
INSERT INTO sabNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Kwian gerudu ene kwian geru jwannga Jesuge ole gire Jesuge geru sugedu kwian kledu geru kade giti, malen Jesu gerudu ama ulita ole: —Cha gerule ba ulita ole, kwian kle no trate me oga me joge kwian mo dodanga ngwadi mo dodade, agwa kwian oga mo dodanga jinade ama joge kwian mo dodanga ngwadi mo dodade, kwian tañachuge kle no ¿lledale ama be mo dodanga jinade mo dodade? ");
INSERT INTO sabNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Cha chiu nga dba ai giti kwian agenga me no ta blite Chube ole joge siere ama kle age me noge, agwa kwian gweale kle tañachuge mo tale ama no trate me jiske Chube gwage, kwian kle tañachuge mo giti ene alin cha me chiu, cha chiu kwian agenga me no alin ama ta blite age no. ");
INSERT INTO sabNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Jesu gerudu ene ulita gire kwian gweale na kledu eni ama gerudu Jesuge geru na giti, ama gerudu: —Kwian geru jwannga Juan-Bautistage kaire kwian geru jwannga kwian fariseoge, kwian e ulita kle chui gweale gai mo tkale bage bligdage, chui ege kwian e kle tañachuge gerule Chube ole alin me blire, kwian e kle age ene chui tanrege. ¿Mineade kwian geru jwannga bage me kle age ene kwian e kare? Kwian geru jwannga bage ulita diali kle blire. ");
INSERT INTO sabNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesu jaindunga: —Cha be geru ai ñachuge ba ulita alin, ene be chke uñale bage mineade kwian geru jwannga chage me kle mo tke bage bligdage kwian na kle age kare. Kwian onbre mo jwen chuia gbe, mo jwen chuia chke gire kwian kadaba ulita be joge chui ollade ule kwian onbre mo jwannga ole. Kwian kadaba ulita be chke chui ollade, ¿chema be gerule kwian e me ñage blire? Kwian ulita be blire nga suga no ole chui ollade ule kwian onbre mo jwannga ole. ");
INSERT INTO sabNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Agwa chui e joge tangle gire chui gbaite be chke gire kwian onbre mo jwannga dbabe sugekare, chui ege kwian mo jwen chuia olladanga ulita be chege ta olire kwian onbre mo jwannga nate gire kwian chui olladanga ulita be mo tke bage bligdage ta olire ole. Ulia cha gerule ba ulita ole, cha kwian onbre mo jwannga e kare, kwian geru jwannga chage ulita kwian mo jwen chuia olladanga kare. Nege cha kle ule geru jwannga chage ulita ole, agwa chui be chke gire cha dbabe sugekare amage, chui ege ama be mo tke bage bligdage ta olire tanre ole. ");
INSERT INTO sabNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jesu geru ñachugu ene kwian ulita alin gire Jesu geru na ñachugu ama alin kaire: —Ni kwian gdaite ñometra jegaba jagere drega jwennga ñometra juda ugachuge ñometra drega jagere ege. Kwian age ene ñometra jegaba jagere me chege no, kaire ñometra drega jagere me chege no ñometra judage. ");
INSERT INTO sabNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kaire ni kwian gdaite kle lle gbe gage bda kwara dodaba lle gage dbangwa judage. Kwian lle gbe gage bda kwara judage lle gage kle lie gire bda kwara juda kle skiennga ulita, gire lle gage ulita kle jogenga ngwale ulita kaire bda kwara kle chege me no ulita. ");
INSERT INTO sabNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Malen diali lle gbakle gage bda kwara jagerege, ene lle gage kle lie, bda kwara me skiennga, lle gage me jogenga ngwale. ");
INSERT INTO sabNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kwian ulita lle gage no no jai me ta lle bale jakalin, lle bale me skwen no amage, ama gerule lle gage ma no ama alin jadale. Jesu geru ñachugu ene ulita kwian fariseo alin kaire kwian daba tkanga tangle Moisés chadalla giti alin, uñadu Jesuge kwian e ulita me ta Jesu gerua jagere gakalin ulia, me ta mo gerua juda gbaba unsuialin chugakalin ngwadi, malen Jesu geru ñachugu ene ama ulita alin geru jagere giti geru juda giti. ");
INSERT INTO sabNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Chui gbaite undege chuiage Jesu kledu chage trigoske tangle deage ule kwian geru jwannga amage ulita ole, gire kwian geru jwannga Jesuge ulita mo gbu trigo dabe bulu ite gutadale, ama trigogba gweale mongonga, kwara glogonga sulikwa giti, gba skieru gutu. ");
INSERT INTO sabNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Kwian fariseo mneite gwagedu kwian geru jwannga Jesuge ulitadi ama kle lle boi kare deage undege chuiage gire kwian fariseo gerudu ama ulita ole: —¿Mineade ba ulita kle lle boi deage undege chuiage? Ba age ene ba kle age me no Chube gerua Moisés nu degaba unsuialin dollale. Uñale ba ulitage Moisés chadalla e giti geru kle gbaba che alin che me ñage lle boi undege chuiage, ¿mineade ba me kle geru e gbe gdadi? ");
INSERT INTO sabNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesu jaindunga kwian fariseo kalen: —¿Ba ulita me nu chada batabanga che chugagwalla unsuialin David agedu giti? Chui gbaite David ule ama chagemanalla ulita ole bli ole tanre, ¿gire ama agedu mine? ");
INSERT INTO sabNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Uñale ba ulitage David jo gwa u gerungwa Chube olege ule ama chagemanalla ulita ole, u ege gwa pan gbakle, pan e chegedale Chube gwa giti diali, Chube gerua gbaba unsuialin kwian ulita alin geru e gerule kwian gerunga Chube ole daba alin, ama alin allabi ñage pan e gute, ni kwian na gdaite ñage pan e gute. Agwa David bli ole tanre ama pan e gutu kaire ama pan e ketu kwian ulita kledu chage ama olege gutadale. David pan e gutu Chube gwa giti agwa ama me boidu dale, Chube me ama gbu jiske ama pan e gutu gdale. ");
INSERT INTO sabNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ene kaire kwian geru jwannga chage me jiske Chube gwa giti ama trigo bulu itu undege chuiage gdale, Chube cha kagu nga dba ai giti kwian kare, ama cha gbu undege chuiage mauña malen cha ñage gerule kwian ole kwian llema boadale undege chuiage llema me boadale undege chuiage —Jesu gerudu ene ulita kwian fariseo mneite ole. ");
INSERT INTO sabNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Chuia nale undege chuiage Jesu jo u mo litangwa Chube gerua jwanngwage, Jesu jo chke ne ngwadi gire Jesu kwian tku tangle. Eni kwian onbre gdaite oga kledu, onbre e oga ko taingwli ole ko kwebanga. ");
INSERT INTO sabNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Kwian daba tkanga tangle Moisés chadalla giti mneite kaire kwian fariseo mneite kledu eni gwa u ege, kwian e ulita kledu tatra onbre oga ko kwebanga giti, ama ulita tadu Jesu gbakalin jiske lle boi undege chuiage, malen ama ulita chegu gwage Jesudi Jesu be onbre oga dodade o mi onbre oga dodade undege chuiage. ");
INSERT INTO sabNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jesuge uñale kwian daba tkanga tangle Moisés chadalla giti kaire kwian fariseo ulita kle tañachuge mine Jesudige, Jesu gerudu onbre oga ole: —Chkede gdate, bai aini kwian ulita gwangnaru mo ko oga kaite kwian ulita gwa giti. Onbre oga chku gdate mo gbu kwian ulita gwangnaru, ");
INSERT INTO sabNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","gire Jesu gerudu kwian daba tkanga tangle Moisés chadalla giti ole kaire kwian fariseo ole ulita: —Cha geru kade bage: ¿Che llema boadale undege chuiage? ¿Che age no kwian alin o che age me no kwian alin? ¿Che ñage kwian oga chudaboi o che kwian oga chugadale ngwadi boi daga ngwale jogeda? ");
INSERT INTO sabNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jesu gerudu ene gire Jesu gwagedu kwian ulitadi, Jesu gerudu onbre oga ole: —Mo ko kwebanga kwrida trate. Onbre agedu Jesu gerudu kare gire onbre ko kwebanga jo chkeni no trate. ");
INSERT INTO sabNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Jesu onbre oga dodadu ene undege chuiage kwian daba tkanga tangle Moisés chadalla giti ulita gwa giti kaire kwian fariseo ulita gwa giti, e giti kwian e ulita skochiu tanre Jesudi, ama ulita geru tragu modige ama be llema boi Jesu dollale. ");
INSERT INTO sabNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Chui gbaitege Jesu jo nga jwichugale giti geru trage gballa Chube ole, ngajrege ulita Jesu gerudu Chube ole. ");
INSERT INTO sabNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Nga chku ju, kwian tanre kle chage Jesu nate diali geru jwen amage, Jesu ama ulita kadu Jesu kle ngwadi, ama ulita jo chke Jesudige gire kwian e ulitaske Jesu kwian gdataboko giti gdaboke gau ama gerua dbe kwian nage, Jesu kwian mneite e ka gbu Jesu gerua ketanga, ");
INSERT INTO sabNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","kwian e ulita kada ene: Simón (kaire Jesu ama ka gbu Pedro), Andrés (ama Simón-Pedro daballa), Santiago, Juan, Felipe, Bartolomé, ");
INSERT INTO sabNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, Santiago (Santiago ai Alfeo kirolla), Simón (Simón ai kira batanga mo jwia gdale), ");
INSERT INTO sabNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas (ama Santiago na daballa), Judas-Iscariote (bigwa ama jwlitedu Jesu dollale Jesu ketu gwaleda). Jesu kwian e ulita gdataboko giti gdaboke gau ama gerua ketangale. ");
INSERT INTO sabNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesu kwian gdataboko giti gdaboke gau ene ama gerua dbe kwian nage gire Jesu jo dbige jwichugage ama ulita ole, chkuni manade nga kegatale giti. Kwian ngle ulita kle chage Jesu nate diali geru jwen amage kledu nga ege, kaire kwian na tanre chkeba nga ege, ama ulita chieba nga tanrege: kwian tanre nga Judeamu, kwian tanre una Jerusalénmu, kaire kwian blemu toinga una Tiroge una Sidónge. Kwian e ulita chkeba Jesu kle ngwadi Jesu keruchuge, kaire kwian ta mo dodakalin Jesuge. ");
INSERT INTO sabNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Jesu kwian oga tanre dodadu, kaire Jesu dolla kagu siere kwian ulita jwligebanga dolla kotege gire kwian e ulita chegu no. ");
INSERT INTO sabNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kwian oga na ulita chagedu dabaske tangle Jesu nate, kwian oga e ulita takalin Jesu chugedi mo dodadale Jesuge, uñale amage Jesu kira molen Jesu kwian oga dodade jingme ulitage. Kwian oga ulita bai jo chke Jesudi ko ñadu Jesudi, kwian ene jo chke noni Jesu kiralla giti. ");
INSERT INTO sabNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesu kwian oga dodadu ulita gire Jesu gerudu kwian geru jwannga amage ulita ole: —Ba bai kaire me lle molen, suge bage Chube ba Chugagwalla, ama kle ba manade, malen nga suga no badi mo tale. ");
INSERT INTO sabNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Nege ba bai kaire bli ole, suge bage chui be chke gire ba mi bli ole dare, ba be kle diali unchkeba no, malen nga suga no badi mo tale. ’Nege ba bai kaire kle olire, suge bage chui be chke gire ba be gide nga suga no ole, malen nga suga no badi mo tale. ");
INSERT INTO sabNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","23","’Chube nu cha kagaba nga dba ai giti kwian kare, cha giti kwian jainchke badi, kwian ba tke jondoi, kwian ba ta gbe olire, kwian gerule badi ba kwian me no, kwian age me no ene ba ole, suge bage chui be chke gire Chube be lle noare kete bage nga ngaña giti Chube ngwadi ba mo ta gbu me joge siere cha geruage boi daga ngwaleske ñanale, suge bage Chube be age ene ba alin, malen nga suga no badi mo tale. Kwian age me no ba ole cha gdale ba me tallade, ma no ba mo ta gbadale nga suga no ole diali, kwian kle age me no ba ole nege, ene kaire unsuialin kwian e enusulian oña agedu me no kwian Chube gerua ketanga ole. ");
INSERT INTO sabNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Ba bai kaire lle molen tanre ba mo ta dbe no lle e ulita alin allabi ole me tañachuge Chube giti, bdagli lle ulita banu be bidege, ba mi chege lle molen, gire ba be chege boi tanre daga ngwale sugekare Chubege. ");
INSERT INTO sabNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Ba bai kaire kle blire no nege, ba mo ta dbe tañachuge blire no alin allabi giti me tañachuge Chube giti, bdagli ba be boi daga ngwale, bligda mi kle ba alin gutadale, ba be bli ole tanre sugekare Chubege. ’Ba bai kaire nga dbe suga noare age ba takalin kare nga dba ai giti me tañachuge Chube giti, bdagli ba be boi tanre daga ngwale, ba be olire, ba ta be chege olire diali sugekare Chubege. ");
INSERT INTO sabNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Ba bai kaire giti kwian na ulita gerule noare, bdagli ba be boi tanre daga ngwale, ba enusulian oña unsuialin gerudu no kaire kwian geru me ulia ketanga giti, bdagli kwian ene ulita be boi daga ngwale sugekare Chubege. ");
INSERT INTO sabNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Jesu gerudu dare: —Ba ulita kle aini cha keruchuge, cha gerule ba ulita ole, ba mo ta dbadale no mo dolla ole, kwian kle jainchke badi, kwian ene alin ba agedale no. ");
INSERT INTO sabNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Kwian kle ba oña boi me no, kwian ene ole ba gerudale: “Cha takalin Chube age no ba alin.” Kwian kle ba ta gbe olire kle gerule me no bage, kwian ene giti ba gerudale Chube ole. ");
INSERT INTO sabNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kwian ba bate gwage ba gwa ongoru gbadale kwiange batadale. Kwian camisa badige jwennga dbadale, kwian ene ole ba gerudale: “Ba takalin cha llea na gweale dbe kaire ba ñage.” ");
INSERT INTO sabNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Kwian lle gweale kade bage, ba lle ketadale kwian enege. Kwian ba llea gweale jwennga dbadale, ba me lle e kadeni kwian enege. ");
INSERT INTO sabNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ba takalin kwian na ulita age no ba alin, kaire ba mo ta gbadale age no ngeru kwian na ulita alin. ");
INSERT INTO sabNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Ba me mo ta dbadale no ba skatemanalla alin ole allabi agwa kaire ba mo ta dbadale no kwian ba dolla ole, ba noare ba skatemanalla alin allabi ole, ¿Chube be age mine no ba alin e ñanale? Chube mi age no ba alin dale e ñanale, kwian ulita no mo skatemanalla ole, kaire kwian me no ama no mo skatemanalla ole. ");
INSERT INTO sabNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ba age no kwian bai age no ba ole alin allabi, kwian ene alin allabi ole ba age no, ¿Chube be age mine no ba alin age ene ñanale? Kwian me Chube uñe kle age ene diali, kwian bai age no ama ole, kwian ene alin allabi ole ama age no. ");
INSERT INTO sabNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Kwian lle kade sugeti bage ba lle kete kwiange kwian bai ñage lle keteni naskuni bage, kwian ene alinge ba lle kete sugeti, ¿Chube be age mine no ba alin age ene ñanale? Kwian me Chube uñe kle age ene diali, kwian bai ñage lle keteni naskuni amage, kwian ene alinge ama lle kete sugeti. ");
INSERT INTO sabNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ba me ñage tañachuge kwian ulita tañachuge kare, ba tañachugadale nganake. Ba mo ta dbadale no mo dolla ole age no ama alin diali. Ama lle gweale kade sugeti bage ba lle ketadale me tañachuge lle e gaini naskuni. Ba mo ta dbe ene mo dolla ole, bdagli nga ngaña giti Chube be lle noare kete bage age no ene ñanale, ba age ene ba kle age ba Ñenua Chube takalin kare, ulia ba Chube olia. Chube kweri, ama noare ulita, ama age no kwian ulita alin, me age no kwian no alin allabi, agwa kaire ama age no kwian me no alin, kwian me Chube uñe ni gerule no Chube ole Chube kle age no ama alin. ");
INSERT INTO sabNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Chube tai dage kwian ulitage, ene kaire ba taidale dage no kwian ulitage Chube kle age kare. ");
INSERT INTO sabNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Jesu gerudu dare kwian ulita ole: —Me no mo ta dbe tañachuge ba alin allabi kle age no Chube gwa giti gerule daba nadi daba me no Chube gwa giti, me no mo ta dbe daba gbe jiske diali lle gweale giti, ba ta daba gbakalin jiske ene diali ta me no ole, ene kaire Chube be ba gbe jiske. Daba na age gweale me no ba ole ba talla e mlienga, ene kaire Chube be ba age me no Chube dollale talla mlienga. ");
INSERT INTO sabNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ba mo ta gbe daba na chudaboi lle kete amage, ene Chube be age kaire ba ole, ba me lle kete sidri alin allabi dabage, ba lle ketadale ngle. Ba kle arogba kete dabage ba arogba ñachuge no gdege, ba gde dage dbige alin, ene arogba chke kejre gdege arogba chke ete ete gdege. Ba lle kete dabage ene kare, ene Chube be age kaire ba ole. Ba lle kete mangire batre dabage Chube lle keteni kaire mangire batre bage. ");
INSERT INTO sabNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesu gerudu ene ulita gire Jesu geru ñachugu kwian ulita alin, Jesu gerudu: —Kwian boke gwagwa me, ¿ama gdaite me ten ñage daba na me ten jonlla dbe? Me dale. Ama gdabonate me ten, me uñale amage ama kle chage baini, ama gdabonate be joge chage be jogenga be joge chke dba dbiugage. ");
INSERT INTO sabNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Kwian geru jwannga me ñage mo ta gbe chke ma ngle geru uñe ma no kwian ama tkanga tanglege, agwa geru jwannga geru jwen ulita trate ama tkanga tanglege, gire ene ama ñage geru uñe kwian ama tkanga tangle geru uñe kare. ");
INSERT INTO sabNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","42","¿Mineade ba kle tañachuge diali daba na kle age me no giti? Diali ba kle gerule me no dabadi daba gbale jiske daba kle age me no giti, agwa ni ba kle tañachuge sidri ba agali kle age ma me no dabage giti. E salengwli ba kle gwage ngajwna daba gwagwagedi kare, ba ta ngajwna e jwankalinnga daba gwagwage agwa ngajwna ma kweri kle mo gwagwage. Bage me suge ngajwna kweri kle ba gwagwage, ngwale ba gerule daba ole: “Daba, cha chugene ngajwna soli jwennga ba gwagwage.” Ngeru ba ngajwna kweri jwandalenga mo gwagwage mo gwagwa jige trate, ene ba ñage daba chudaboi ngajwna soli jwennga ama gwagwage. E salengwli kwian kle gerule dabadi age me no sidri giti, me suge mo tale ama kle age ma me no dabage. Ama takalin daba na ulita tañachuge ama giti ama no ulita agwa gire ama ulia ta me no. Cha gerule ba ulita ole, ma no ba mo ta gbe tañachuge ba kle age me no giti ngeru me tañachuge daba na kle age me no giti, ba mo ta gbadale trate biale gire ba ñage daba na ta gbe ama kle age giti ba ñage ama chudaboi. ");
INSERT INTO sabNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Jesu geru na ñachugu kwian ulita alin, Jesu gerudu: —Gli no me ñage gbachie me no, gli me no me ñage gbachie no. ");
INSERT INTO sabNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Gli kaire kaire chke uñale nate gba giti, drinkin me gbachie higogba kare, idongi me gbachie uvagba kare. ");
INSERT INTO sabNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ene kaire kwian ta no ama age no ama gerule no, kwian ta me no gerule me no, kwian kle tañachuge mo tale kaire kle gerule ama kle tañachuge kare. ");
INSERT INTO sabNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Jesu gerudu: —¿Mineade ba ulita cha kade mo Chugagwalla agwa ba me kle age cha gerule kare? ");
INSERT INTO sabNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","48","Cha gerule ba ulita ole, kwian bai kle chie chadi cha keruchuge gire mo ta gbe age cha gerule kare, kwian e ta no molen tañachuge trate, ama salengwli kwian u gbanga no kare. Ngeru kwian u gbanga no kle dbi bage jere bu tke dbige jere gire kle ke ten budi tangle, ene bu chege kejre me joge chke dba, u kle dodaba no kiraske. Chi uda joge kweri, chi uda chke udi kiraske, u me joge chke dba, chi uda me ñage u dbe, u gbanga no bu tku jere dbige malen chi uda me ñage u e dbe. Kwian bai cha gerua keruchuge gire mo ta gbe age cha gerule kare, kwian ene salengwli kwian u gbanga no e kare. ");
INSERT INTO sabNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Agwa kwian bai kle cha keruchuge gire me mo ta gbe age cha gerule kare, kwian ene salengwli kwian kle u gbe dbi giti alin me bu tke dbige jere me ke ten budi tangle, ene chi uda joge kweri, chi uda chke udi kiraske, u joge chke dba, u joge ulita chi giti —Jesu gerudu ene ulita kwian ole. ");
INSERT INTO sabNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesu geru tragubi kwian ulita ole gire Jesu jo chage una Capernaum ngnagu, Jesu jo chke una ege. ");
INSERT INTO sabNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Guardia donga chugagwalla nga Romamu gdaite kle una Capernaumge, kwian lle boanga gdaite ama alin oga chegu sidri lle boanga jogeda, guardia donga chugagwalla noare kwian lle boanga e ole. ");
INSERT INTO sabNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Gire guardia donga chugagwalla ologe gerudre Jesu giti, amage chku uñale Jesu kwian oga dodade malen ama kwian israelita chugagwalla juma gweale kagu geru jige Jesuge guardia donga chugagwalla takalin Jesu chie kwian lle boanga ama alin oga dodade. ");
INSERT INTO sabNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Gire kwian israelita chugagwalla juma mneite jo chke Jesudige gerule Jesu ole, ama gerudu: —Kwian lle boanga gdaite guardia donga chugagwalla alin oga jabale chegu sidri ama ngeru ama jogeda, cha ulita takalin ba joge guardia donga chugagwalla chudaboi ba lle boanga ama alin dodade. Guardia donga chugagwalla ama kwian noare, ");
INSERT INTO sabNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ama no no kwian israelita ulita ole, ama u mo litangwa Chube gerua jwanngwa dodangu cha ulita alin una aige. Guardia donga chugagwalla kwian ene malen noare ba joge lle boanga ama alin oga dodade. ");
INSERT INTO sabNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","7","Kwian israelita chugagwalla juma ulita gerudu ene Jesu ole gire Jesu jo chage ule ama ole guardia donga chugagwalla ulla ngnagu, Jesu jo chke kodi uge gire guardia donga chugagwalla mo skatemanalla na kagu mneite geru jige Jesuge jonke, guardia donga chugagwalla skatemanalla gerudu Jesu ole: —Guardia donga chugagwalla geru ai kagu ba alin: “Cha ba gai kweri, chage suge cha me no, uñale chage trate ba no no, malen cha me jo agali ba jwen. Ma no ba me joge gwa cha ullage oga kle ngwadi, ba gerule alin allabi jonke lle boanga oga giti cha alin, ene uñale chage ama be joge chkeni noni. ");
INSERT INTO sabNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Uñale chage ba kwian chugagwalla kweri ba kira molen ulita, ba gerule alin allabi gire jingme joge siere kwian ogage. Cha chugagwalla ñage cha kage lle boi ene cha age ama gerule kare, kaire cha guardia donga chugagwalla ñage guardia donga ulita kage lle boi ama age cha gerule kare, cha gerule guardia donga gdaite ole: ‘¡Joga!’, gire ama joge. Cha gerule na ole: ‘¡Bai aini!’, gire ama chie. Cha kwian lle boanga cha alin kage lle boi gire ama lle boi cha gerule kare. Ba ma kweri kira molen malen uñale chage ba gerule alin allabi jonke ba kle ngwadi jingme kage siere lle boanga chanuge, gire jingme be joge siere amage ama be joge chkeni noni.” ");
INSERT INTO sabNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Guardia donga chugagwalla skatemanalla ulita geru e ketu Jesuge, Jesu geru e keruchugu gire Jesu chegu tañachuge noare guardia donga chugagwalla giti ama kle mo ta gbe giti Jesu gai ulia no. Jesu jwlituda gdate naskuni gwagedu kwian nglea kle chage Jesu natedige, Jesu gerudu ama ulita ole: —Ni kwian gdaite nga Israel ulitage guardia donga chugagwalla ta e kare molen, ama kle mo ta gbe cha gerua gai ulia mo tale ma no kwian israelita ulitage. ");
INSERT INTO sabNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Guardia donga chugagwalla skatemanalla mneite joni gudegu oga kle ngwadi, jo chkeni gwa gire gwagedu lle boanga guardia donga chugagwalla alin nu jogeba chkeni noni ulita jingmege. ");
INSERT INTO sabNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Boidu ene ulita gire Jesu jo una kada Naínge, kwian geru jwannga Jesuge ulita kle chage ule Jesu ole, kaire kwian na tanre jo ule. ");
INSERT INTO sabNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Jesu jo chke kodi una Naínge gire Jesu gwagedu kwian tanre una emudi jonke, kwian e ulita kle chage oñakwa jaba dbe lugaba glige tkadale dbige, kirogwa onbre e gdaitre alin chebiage jokeda, sbali chebia chegeba oli mo ñengulallage, kwian tanre una emu kledu muinga oli gatedi. ");
INSERT INTO sabNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jesu gwagedu muinga olidige olire tanre Jesu taidu dage muingage, Jesu gerudu muinga oli ole: —Ba me mo ta dbe olire dare ba kirolla nate. ");
INSERT INTO sabNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Jesu gerudu ene muinga ole gire Jesu jo oñakwa jaba gitigu, Jesu oñakwa jaba glilla gau kodi, kwian oñakwa jaba dbanga ulita jagedu gdate jonke oñakwa jaba gwaru, gire Jesu gerudu oñakwa jaba ole: —¡Kirogwa onbre, chkedeni bduge! ");
INSERT INTO sabNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Jesu gerudu ene jaba ole gire blike jaba chkuni gwade chku bduge gerule no, Jesu ama ketuni gwadeni chebiage. ");
INSERT INTO sabNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Kwian ulita gwagedu edi kwian ta me jo sugano Jesu agedu gitidi, gire kwian ulita gerudu noare Chube giti, kwian gerudu: —Nege kwian Chube gerua ketanga kle cheske aini, ama noare, Chube ama kagu che ulita chudaboi. ");
INSERT INTO sabNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Kwian nga Judeage ulita kaire kwian toinga nga Judeadi tangle, ulitage geru chku nate uñale Jesu kwian jaba gbuni gwadeni. ");
INSERT INTO sabNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Geru chku uñale Juan-Bautistage kwian geru jwannga amage geru tragu Jesu kle age giti ulita kwianske giti, ");
INSERT INTO sabNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","gire Juan-Bautista kwian geru jwannga amage boke gau kagu, ama gerudu: —Ba geru kade ai kare Jesuge: “Unsuialin Chube gerudu be kwian jwannga siere kage kwian alin, ¿ba amaña o ama bebi chie, cha chegedale ama manade ngwange dare o me?” ");
INSERT INTO sabNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Kwian geru jwannga Juan-Bautistage boke jo chke Jesudige gire gerudu: —Juan-Bautista cha kagu gdabonate geru kade bage, ama geru ai kagu ba alin: “Unsuialin Chube gerudu be kwian jwannga siere kage kwian alin, ¿ba amaña o ama bebi chie, cha chegedale ama manade ngwange dare o me?” ");
INSERT INTO sabNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Kwian geru jwannga Juan-Bautistage boke geru kadu ene Jesuge, gire ama gwagedu Jesudi kwian oga tanre dodade ama boke gwa giti. Jesu kwian oga tanre ai kare dodadu: Jesu kwian oga jingme ole dodadu, Jesu dolla kagu siere kwian jwligebangage, kwian tanre me gwagwa molen Jesu gbu ten. ");
INSERT INTO sabNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jesu agedu ene ulita kwian geru jwannga Juan-Bautistage gwa giti gire Jesu gerudu ama ole: —Jogani Juan-Bautista kle ngwadi, ba gerule Juan-Bautista ole ba kle gwagedi nege giti, kaire ba kle geru keruchuge nege ba e tragadale Juan-Bautista ole. Kwian gwagwa me cha kle gwagwa gbe ten, kwian me ñage chage cha kle ama gbe chage, kwian oga kwara tuge jingmea ole cha kle dodade ene ama chege trate, kwian me olo molen cha kle olo gbe tren, kwian jaba cha kle gbeni gwade, kaire Chube gerua cha giti kle joge chke kwian me lle molenge, ene ama ñage Chube gerua cha giti gai ulia tiendale gitiru ji chugege age me no gdale. ");
INSERT INTO sabNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Cha kle age no ene ulitadi ba kle gwage nege, jogani Juan-Bautista kle ngwadi e ulita trage ama ole. Kaire ba geru ai kete amage: “Nga suga no kwiandi kwian bai cha gai ulia Chube nu cha kagaba kwian ulita jwanngale siere ji chugege age me no gdale, kwian bai mo ta gbe cha gai ulia ene diali, kwian ene me jogenga cha giti mo tale, ama be chege ta suga no ole.” Ba geru e ulita kete Juan-Bautistage cha alin. ");
INSERT INTO sabNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jesu gerudu ene ulita kwian geru jwannga Juan-Bautistage boke ole gire kwian e joni Juan-Bautista kle ngwadi. Kwian e jo gire Jesu gerudu kwian ulita kledu eni ole Juan-Bautista giti, Jesu gerudu: —Ba ulita jo tienda Juan-Bautistadi nga gballage, ba gwagedu amadi ama me kledu boi eske kle jwliennga ongoru ongoru mleudage kare, kwian boi eske kare mleuda ole e salengwli gerule kwian me ñage tañachuge mo tale no gwangeru alin trate, diali kle tañachuge gwangeru gwanaskuda, Juan-Bautista me ene, ama mo ta gbu kiraske Chube gerua cha giti gai ulia diali. ");
INSERT INTO sabNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ba jo tienda Juan-Bautistadi nga gballage ba me jo tienda kwiandi kwian nu mo ngama tkaba ñometra noare gigaba kwangleske. Uñale bage kwian kle mo ngama tke ñometra eneske me kle toi nga gballage, kwian ene kle toi chugagwalla ullage u no kweri tratege. Juan-Bautista me toidu u enege. ");
INSERT INTO sabNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ba me jo tienda kwian kle toi u e karegedi, ba jo tienda kwian Chube gerua ketangadi. Cha gerule ba ole, ulia Juan-Bautista kwian Chube gerua ketanga, kaire agwe Juan-Bautista ma kweri kwian Chube gerua ketanga na ulitage. ");
INSERT INTO sabNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Chube gerua degaba unsuialin gerule Chube be Juan-Bautista kage cha ngeru, chada e gerule: “Chube gerudu: ‘Cha be kwian gdaite cha gerua ba giti dbanga kage ba ngeru, kwian geru dbanga e be kwian na ta gbe biale ulita ba ngwange.’ ” Chube gerua degaba unsuialin gerule ene Juan-Bautista giti. ");
INSERT INTO sabNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Cha gerule ba ole, aini nga dba giti kwian na me Juan-Bautista kare, ni kwian gdaite ma kweri Juan-Bautistage Chube gwa giti. Agwa nege gwangerugu kwian bai mo ta gbe cha gerua gai ulia, kwian e me chege kweri kwian na gwa giti agwa Chube gwa giti kwian ene ulita chege ma kweri Juan-Bautistage —Jesu gerudubi ene kwian ole Juan-Bautista giti. ");
INSERT INTO sabNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Kwian Jesu gerua Juan-Bautista giti keruchugu gire kwian igi ganga chugagwalla emperador nga Romamu alin ulita bai Juan-Bautista nu ñeaba chiske kaire kwian na ulita bai Juan-Bautista nu ñeaba chiske, ama ulita gerudu Chube giti: “Ulia Chube noare, Chube diali age no trate ulita.” ");
INSERT INTO sabNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Kwian fariseo ulita kaire kwian daba tkanga tangle Moisés chadalla giti ulita, kwian e ulita me gerudu ene no Chube giti, ama me mo ñeangu chiske Juan-Bautistage, ama me mo ta blitakalin Chube ole. Chube tadu agekalin no ama ulita alin agwa ama Chube ibaitu me tadu agekalin Chube takalin kare. ");
INSERT INTO sabNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jesu gerudu dare kwian ulita ole: —Nege cha be gerule ba ole kwian kle toi ai suiale giti. ¿Ama kwian mine? ¿Ama llema kare? ");
INSERT INTO sabNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Kwian tanre nege tangle salengwli kirogwa kare kirogwa kle kolale mo skatemanalla ole goga tangle, me kolale no kle ka boi mo skatemanalla ole, kirogwa gerule daba ole: “Cha ngwanedu chirege ba alin, ene ba ñage skwen gdate chire keruge, agwa ba me nga talladu, nga me sugedu no badi. Gire cha mo gatu ta olire giti, agwa ba me tadu olire.” Kirogwa kira bate ene ulita modi, kwian tanre nga ai suiale kle age ene kare. ");
INSERT INTO sabNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Juan-Bautista chku Chube gerua trage kwian ole, ba ulita gwagedu Juan-Bautistadi Juan-Bautista toidu me blire kwian ulita kle blire kare, Juan-Bautista me uva chia jau kwian ulita kle jai kare, Juan-Bautista toidu ene gdale ba me Juan-Bautista gau ngwange no ba gerudu me no Juan-Bautistadi Juan-Bautista kwian jwligebanga kare che dolla kote toi nga gballage. ");
INSERT INTO sabNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Chube nu cha kagaba kwian kare nga dba ai giti, cha me kle toi Juan-Bautista toidu kare nga gballage, cha kle toi kwianske, cha kle blire kwian ulita kle blire kare kaire cha kle uva chia jai kwian ulita kle uva chia jai kare, cha kle toi ene gdale ba me kle cha gai ngwange no ba ulita kle gerule me no chadi cha kwian bligda gutanga ngle cha kle chage kwian llale kare, kaire ba gerule chadi cha kwian igi ganga chugagwalla emperador nga Romamu alin gai mo skatemanallale kaire ba gerule cha kwian agenga me no na ulita gai mo skatemanallale. ");
INSERT INTO sabNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Kwian tanre kle gerule me no ene chadi, kwian gerudu me no kaire Juan-Bautistadi, agwa Chube gwa giti Juan-Bautista kwian no kaire cha kwian no. Juan-Bautista toidu no Chube ama ta gbu toi kare, kaire agwe ene cha kle toi no Chube kle cha ta gbe toi kare kwian gwa giti, malen cha giti kaire Juan-Bautista giti kwian tanre kle mo ta gbe Chube gerua gai ulia —Jesu gerudu ene ulita kwian ole. ");
INSERT INTO sabNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Kwian onbre fariseo gdaite kada Simón Jesu kadu joge mo ullage blire ule. Jesu jo, jo chke gwa Simón ullage, Jesu toidu dba blingwage. ");
INSERT INTO sabNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Gire muinga gdaite kle toi una ege agenga me no, muinga ege chku uñale Jesu kle blire Simón ullage, gire muinga jo Jesu nate u ege, lle chiale ñachke noare muinga du lle gweale limeta soli karege Jesu alin. ");
INSERT INTO sabNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Muinga jo chke Jesudi muinga toidu dba Jesu sera ngena olire tanre, amage sugedu ama ageba me no tanre, muinga olidu tanre Jesu sera jo date ulita muinga ngwalangwallage, muinga Jesu sera unbatu mo chugaga giti. Muinga Jesu sera sobadu gire muinga lle chiale ñachke noare ulita tku Jesu sera giti. ");
INSERT INTO sabNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Kwian fariseo nu Jesu kadaba blire mo ullage gwagedu muingadi age ene Jesu ole, gire kwian fariseo e tañachugu mo tale: “Muinga e agenga me no me no, onbre e Chube gerua ketanga ulia muinga e talla chkedale uñale onbre ege muinga e no ni no gire, agwa ama kle mo chuge ngwadi mo gange kodi muingage.” ");
INSERT INTO sabNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Kwian fariseo kle tañachuge ene mo tale Jesudi muinga giti, e chku uñale Jesuge gire Jesu gerudu kwian fariseo e ole: —Simón, cha gerukalin gbaite ba ole. Simón gerudu: —Kwian tkanga tangle geruge, gerule cha ole. ");
INSERT INTO sabNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","42","Jesu gerudu: —Onbre boke jiske onbre na gdaitege igi giti, onbre gdaite e igi mauña igi ketu sugetidale onbre boke ege, igi mauña igi ketu onbre gdaitege cincuenta igi ma ngle ketu onbre na gdaitege quinientos, ama boke igi kadu sugetidale igi mauñage. Gire onbre bonate me ñadu igi keteni igi mauñage, bonate chegu jiske igi giti, igi mauña me su igi kadeni onbre bokege, igi mauña gerudu onbre boke jiske ole: “Ba nu igi kadaba sugetidale chage, cha gerule ba ole ba me igi e ketadaleni naskuni chage, ba me tañachuge dare ba jiske giti, cha ba jiske talla mlienga ulita, cha no ba ole.” Igi mauña gerudu ene onbre boke ole ene ama boke me chegu jiske dare igi mauñage. Nege cha geru kade bage Simón, kwian boke jiske igi giti, ¿bai be ta dbe ma no igi mauña ole? ");
INSERT INTO sabNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simón jaindunga: —Cha tañachuge kwian jiske ma ngle ama be ta dbe ma no igi mauña ole, ama jiske ma ngle igi giti igi mauñage agwa igi mauña ama jiske ngle talla mliunga mo ta gbu no ama ole, ene ama chegu ama me jiske kare, e giti kwian e ta dbe ma no igi mauña ole igi mauña agedu giti ama alin. Jesu gerudu: —Ba gerudu e ulia. ");
INSERT INTO sabNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Gire Jesu gwagedu muingadi Jesu gerudu Simón ole: —Gwage muinga aidi ama kle age giti cha alin. Ba ullage cha chku ba me chiu chi dbe cha alin cha sera gligagda, agwa muinga ai chku aini ama cha sera gliguda ngwalangwa giti, ama cha sera unbatu mo chugaga giti. ");
INSERT INTO sabNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Cha chku ba ullage ba me cha sobadu ngwange, agwa muinga ai chku aini blike ama jo chke dba cha sera ngena, ama me kle skwatige cha sera sobade. ");
INSERT INTO sabNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Cha chku aini ba me cha gau ngwange lle ñachke no giti, ba me lle ñachke no tku cha chuga giti, agwa muinga ai lle ñachke noare tku cha sera giti. ");
INSERT INTO sabNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Cha gerule ba ole Simón, muinga ai agedu tanre me no Chube dollale, Chube muinga ai agedu me no ulita talla mliunga, malen muinga ai kle mo ta dbe no tanre cha giti Chube ole kle cha gai dage no ngle Chube agedu giti ama alin. Agwa kwian bai agedu me no bedre Chube dollale, Chube kwian ene agedu me no bedre talla mliunga, kwian ene mo ta dbe no bedre cha ole ama me cha gai dage no ngle. ");
INSERT INTO sabNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jesu gerudu ene ulita Simón ole gire gerudu muinga ole: —Ba agebale me no ulita Chube dollale cha talla ulita mlienga. ");
INSERT INTO sabNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Kwian ulita kle toiba dba blingwage Jesu keruchugu gerule ene muinga ole gire ama ulita chegu tañachuge mo tale Jesu giti: “¿Onbre e chema ade ñage kwian age me no talla mlienga Chube kare?” ");
INSERT INTO sabNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesu gerudu dare muinga ole: —Ba cha gau ulia mo jwanngale siere ji chugege ba agedu me no ulita gdale, malen cha ba agedu me no ulita talla mlienga nege, ba ñage jogeni gudegu nga suga no ole. ");
INSERT INTO sabNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Jesu chagedu una kaire kairege, una ulita baini kaire Jesu jo chke ngwadi ama gerudu kwian ulita ole kwian ñage Chube uñe, kwian mo ta blitadale Chube ole Chube gai mo Chugagwallale, ene Chube be kwian e jwen siere ji chugege agedu me no gdale. Jesu chagedu geru trage ene kwian ulita ole una kaire kairege, kwian geru jwannga Jesuge gdataboko giti gdaboke chagedu ule Jesu gatedi. ");
INSERT INTO sabNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Kaire muinga gweale Jesu nu dolla jwanba sierege, kaire muinga gweale oga Jesu nu dodabale nu jogeba chkeni no, muinga ene ulita Jesu gatudi kaire. Muinga e ulitaske María-Magdalena kledu, amage dolla gdaguke Jesu nu jwanba siere. ");
INSERT INTO sabNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Muinga na gdaite kada Juana, ama Cuza muingalla, onbre kada Cuza daba ulita lle boanga Herodes alin chugagwalla. Muinga na gdaite kada Susana. Muinga e ulita, kaire muinga na tanre Jesu gatudi chudaboi bligda ole igi ole lle na tanre ole. ");
INSERT INTO sabNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kwian una tanrege jo chke Jesu kle ngwadi, kwian e ulita mo litu Jesudi gire Jesu geru ñachugu ama alin chude drennga giti, Jesu gerudu: ");
INSERT INTO sabNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Cha gerule ba ulita ole chude drennga giti, kwian jo chude drennga deage, kwian jo chke deage, ama chude ngle dreunnga kote. Kwian e kle chude drennga kote, gire chude e gweale jo chke dba jon jegwale, kwian ngle chagedu jon jegwale skitedu chude giti, bdada chiu, bdada chude gutu. ");
INSERT INTO sabNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Chude na gweale jo chke dba dbi arale ngwadi ke giti, chude e gwatigu, chudenuma junbatedunga dbi arale ulenge. ");
INSERT INTO sabNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Chude na gweale jo chke dba drinkin sera tanre ngwadi, chude gwatigu, agwa drinkinnuma gwatigu ule chudenuma ole, drinkin chudenuma guda. ");
INSERT INTO sabNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Chude na jo chke dba dbi no giti, chude e ulita gwatigu no gbachiu no ngle. Chude skute chuia chku gire chude e ulita nu gbachieba ngle ngle chude cien bulu gdaitege. Jesu geru ñachugu ene ulita chude giti gire Jesu gerudu kweri kwian ole: —Cha kle geru ai ñachuge ba alin, ba me geru ai keruchuge alin allabi mo ologe, agwa kaire ba ulita mo ta gbadale geru ai gbe gdadi, ba tañachugadale lledale cha kle geru ai chude giti ñachuge ba ulita alin. ");
INSERT INTO sabNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jesu gerudu ene kwian ngle ulita ole gire kwian geru jwannga Jesuge geru kadu Jesuge: —¿Ba geru ñachugu chude giti, e gerule mine? ");
INSERT INTO sabNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesu jaindunga: —Ba ulita kle cha gerua gai ulia malen Chube kle ba ta gbe chke cha kle gerule giti, ene geru e giti kle suge trate bage kwian bai kaire cha gai ulia mo Chugagwallale kwian ene chege no trate Chube gwa giti. Kwian na me kle cha gerua gai ulia, ama alin cha kle geru ñachuge, kwian geru e keruchuge agwa geru e ulita skwen mnoare amage, geru e me suge amage dale. Kwian ene gwa giti cha kle lle tanre no dodade, agwa ama chege kwian gwagwa me kare, me suge amage cha kle lle e dodade Chube kiralla giti kwian ta gbagda Chube giti. Kaire kwian ene kle cha gerua keruchuge agwa ama chege kwian olo me kare, geru me suge trate amage cha kle gerule giti. ");
INSERT INTO sabNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Cha geru ñachugu chude drennga giti, nege cha geru e gbe chke uñale bage cha gerudu kare giti. Chube gerua chude kare. ");
INSERT INTO sabNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Kwian gweale kle boi Chube gerua ole chude jo chke dba jon jegwale kare. Kwian e Chube gerua keruchuge, bigwa che dolla Satanás chie Chube gerua jwennga bdada agedu chude ole kare, gire geru Chubenu ulita jogenga kwian tale, ene kwian e me ñage geru e gai ulia, me ñage tien gitiru ji chugege ama agedu me no gdale, ene me ñage toi Chube ole. ");
INSERT INTO sabNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Kwian gweale kle boi Chube gerua ole chude jo chke dba dbi arale ke giti ngwadi kare. Kwian e Chube gerua keruchuge, geru e gai, nga suga noare amadi geru e giti agwa ama me mo ta gbe ulia Chube ole me kle Chube gerua gai jumale ulia malen ama tale geru me ñage tige no kiraske chude me ñage sera joge dbiske ke giti me ñage tige no kare. Kwian e Chube gerua gai ulia bedre me kira ole gwangerugudba geru e gai ulia, ama boi daga ngwale Chube gerua gdale, gire ama geru e chuge ngwadi, ama jogeni naskuni chage ngeru kare. ");
INSERT INTO sabNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Kwian gweale kle boi Chube gerua ole chude jo chke dba drinkin sera tanre ngwadi kare. Kwian e Chube gerua keruchuge Chube gerua gai ulia agwa ama me kle mo ta gbe tañachuge diali Chube gerua giti no, ama kle mo ta gbe tañachuge tanre lle ngwale alin giti, ama ta igi jwankalin ngle mau alin, ama ta agekalin ulita ama takalin kare. Ama kle tañachuge ma ngle lle e kare giti Chube gerua gitige, malen Chube gerua kle jogenga ama tale, gire ene kwian me kira molen toi no Chube takalin kare ni kwian ñage Chube gerua dbe kwian nage. ");
INSERT INTO sabNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Kwian gweale kle boi Chube gerua ole chude jo chke dba dbi no giti kare. Kwian e Chube gerua keruchuge gire ama mo ta gbe geru e gai jumale mo tale, ama tañachuge no diali Chube gerua giti, ama Chube chuge ngwadi age ama tale Chube takalin kare, ene Chube ama ta gbe chui gbaite gbaite kaire kairege ma ngle Chube gerua giti. Kwian ene mo ta dbe no diali Chube gerua kete daba na ulitage, ene daba tanre chke geru gai ulia kwian e giti —Jesu gerudu ene kwian geru jwannga amage ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jesu geru na ñachugu kwian alin, Jesu gerudu: —Nege cha geru ñachuge ba ulita alin jichra giti, kwian age jichra ole kare, e kare ene kwian agedale Chube gerua ole. Kwian jichra gwadege me kle un blite kaboge jichra giti ni kle jichra gbe ankwa gwaru nga gbagda chra, kwian me age ene jichra ole. Kwian jichra gwadege kwian jichra gbe ngaña nga ngwale giti, ene jichra chra chratigenga ulita gwa tangle, ene kwian na chie gwa ñage ten jichra chralla giti, ene uñale kwiange ama chagedale baini, jichra chrage lle ulita me chege skwlenre kwian gwage. ");
INSERT INTO sabNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ene kaire Chube gerua me chege skwlenre kwiange, kwian Chube gerua ganga giti geru e be chke uñale kwian nage malen kwian Chube gerua ganga me chagedale ta skwlenre Chube gerua ole kwianske. ");
INSERT INTO sabNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Jesu geru ñachugu ene gire Jesu gerudu dare: —Ba cha keruchuge no no. Kwian bai kaire Chube gerua gai ulia Chube gerua manade no mo tale, kwian ene mi ta jogenga Chube geruage, kwian enege Chube gerua be suge ma ngle diali, Chube be kwian ene chudaboi be kwian ene ta gbe suge ma ngle Chube gerua giti. Agwa kwian bai kaire me mo ta gbe Chube gerua gai ulia, ama kle tañachuge alin allabi kle Chube gerua gai ulia kle mo anblite agali, kwian ene be ta jogenga Chube geruage ulita be chege kwian me Chube gerua keruchugaba kare. ");
INSERT INTO sabNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesu kle gerule ene kwian ngle ole gire Jesu chebia jo chke ule Jesu daballa ulita ole Jesu kle ngwadi, kwian tanre kle Jesu ole Jesu keruchuge malen Jesu chebia Jesu daballa me ñadu joge chke Jesudige kodige. ");
INSERT INTO sabNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Kwian na geru ketu Jesuge chebia giti daballa giti: —Ba chebia ba daballa ulita kle goga, ama ta geru tragakalin ba ole. ");
INSERT INTO sabNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jesu gerudu kwian ole: —Kwian bai Chube gerua keruchuge Chube gerua gbe gdadi age geru e gerule kare, cha alin kwian e ulita cha chebia kare cha daballa kare, ama cha bitallanu ulia, cha no no ama ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Bitaite Jesu jo du toli ule kwian geru jwannga amage gdataboko giti gdaboke ole, gire Jesu gerudu: —Ale chibita kagda giti chkagu. Jesu kwian geru jwannga ole jo. ");
INSERT INTO sabNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Jesu kwian geru jwannga ole kle chage duge chiga giti gire Jesu gbedu. Jesu kle gbe gire mle kweri chiu dudi, chi mlege jo chite juga juga chi jo du toli, du kagda chagedu mebi chigage nga tirareske. ");
INSERT INTO sabNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Gire ta kennga tanre ole kwian geru jwannga Jesu gau gdate gerudu Jesu ole: —¡Cha tkanga tangle geruge! ¡Chkede bduge cha chudaboi! ¡Che ulita be joge chiske duge llagli, che be unjoge! Jesu chku bduge mo gbu gdate, Jesu gerudu mle ole chi ole: —¡Chegede ngwedige! Gire sugeti ngwale mle kaire chi chegu ngwedi ulita Jesu gerudu kare. ");
INSERT INTO sabNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jesu agedu ene mle ole chi ole gire Jesu gerudu kwian geru jwannga ole: —¿Mineade ba ulita ta kennga tanre mledi? ¿Ba me cha gai ulia cha ñage ba manade nga tirareske? Jesu gerudu ene kwian geru jwannga ole gire ama ulita ta chegu kwachie tanre, kaire ama ulita chegu tañachuge tanre noare, kwian geru jwannga geru kadu modige ulita: —¿Kwian ai mine ade ama gerule mle ole chi ole, gire chi kaire mle ama kerua gai dage chege ngwedi? —kwian geru jwannga geru kadu modige ene Jesu giti. ");
INSERT INTO sabNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jesu jo chage dare duge chiga giti kwian geru jwannga amage ulita ole, Jesu jo chke chi kagda giti chkagu nga kada Gadarage, nga e nga Galileadi chkagu. ");
INSERT INTO sabNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Ne ngwadi Jesu jo kedagu gire kwian onbre jwligebanga dolla kote chku ten Jesu ngwange, kwian jwligebanga e una emu. Sbali kwian jwligebanga e toidu dolla ole, me toidu ñometraske, me toidu gwa, toidu sbali jaba ogakle keugage ngwadi. Diali dolla kira ulita kete kwian jwligebanga ege malen ama kiraske tanre. Diali kwian kle no kle kwian jwligebanga e gai lugeda hierrogda dodabale cadenale giti tañachuge kwian jwligebanga me ñage kige, agwa dolla kirallaske kwian jwligebanga cadena datenga gire dolla ama gbe kige bate nga gballage kwian me kle toi ngwadi. Jesu jo chke nga ege gire kwian jwligebanga e kledu chage eni kaire, kwian jwligebanga gwagedu Jesudige gire dolla kwian jwligebanga gbu joge chke dba jongnagwa giti Jesu ngeru, Jesu gerudu dolla kle toiba kwian e tale ole: —¡Joga siere kwian aige! Dolla kwian jwligebanga gbu gerule kweri Jesu ole: —Uñale chage ba Jesu ba Chube kweri kiraske Kirolla. ¿Lledale ba chiu cha nate nga aige? Ba me age me no cha ole cha gbe boi daga ngwale sugekare kwian aige, ma no ba cha chuge ngwadi toi kwian ai tale. ");
INSERT INTO sabNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesu geru kadu dollage: —¿Ba kada mine? Ama jaindunga: —Cha kada Ngleare. Dolla tanre kle toi kwian jwligebanga e tale malen dolla gerudu ene Jesu ole. ");
INSERT INTO sabNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","32","Jesu kledu gerule dolla ole ngwadi kodi jwichuga giti chunchi tanre kledu chage jwichugage blire. Dolla ulita gerudu Jesu ole: —Cha me takalin ba cha kage bate nga dbigu giti ji chuge ngwadi, ma no ba cha ulita kage chunchi kle ngwadi, ene cha ulita ñage toi no chunchi tale. Jesu gerudu dolla ole: —¡Joga siere onbre aige, joga toi chunchi ole ulita! ");
INSERT INTO sabNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Jesu gerudu ene dolla ole gire dolla ulita jo siere blike onbrege, dolla ulita jo chunchi ngle ngwadi toi chunchi tale. Gire sugeti chunchi ulita jo jrite jo kegdege dolla kote, chunchi ulita jwatedunga kegde gwagda giti, chunchi ulita jo chiske, chunchi ulita unjo jokeda chi kote dolla kbiale. ");
INSERT INTO sabNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Kwian chunchi mananga ulita gwagedu chunchidi boi ene ulita gire ama ulita jo jrite, ama jo geru trage kwian kle toi jon jegwale ole kwian kle toi unaske ole boidu ulita giti. ");
INSERT INTO sabNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Kwian ulita chunchi mananga gerua keruchugu, kwian e jo tienda boidu chunchi oledi. Kwian e ulita jo chke Jesu kle ngwadi, ama ulita gwagedu kwian onbredi dolla nu toiba ole, dolla jogeba siere amage, kwian onbre e jogeba chkeni noni, ama kle ñometraske toiba dba Jesu kle ngwadi. Kwian ulita gwagedu ene kwian onbre Jesu nu dodabadi gire ama ulita kwachiu tanre Jesu ngeru. ");
INSERT INTO sabNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Kwian ulita bai gwagedu Jesudi mo gwagwa giti Jesu dolla kagu siere onbre jwligebanga ege gire, kwian e geru e ulita tragu kwian chiu unaskege ole kwian jon jegwalege ole, geru tragu ama ulita ole Jesu dolla kagu siere onbre jwligebangage. ");
INSERT INTO sabNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Gire kwian ulita toinga nga Gadarage ta kwachiu tanre Jesudi kwian gerudu Jesu ole: —Cha me takalin ba chege dare cha kle toi ngwadi nga aige. ¡Joga siere nga aige me age ene dare aini! ");
INSERT INTO sabNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","39","Kwian gerudu ene Jesu ole gire Jesu joni naskuni du toli, kwian onbre jogeba chkeni noni jo Jesu nate gerudu Jesu ole: —Cha ta jogekalin ule ba ole, ba cha dbe ule nga baini kaire ba joge ngwadi. Jesu gerudu ama ole: —Ba me ñage joge ule cha ole, ba jogedaleni ba ullage geru trage ba bitalla ulita ole Chube agedu giti ba alin. Jesu gerudu ene onbre e ole gire Jesu joni, kwian onbre jo mo bitalla ngwadi geru trage kwian unaske ulita ole Jesu agedu noare ama alin, Jesu dolla kagu siere amage ama geru e tragu kwian ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesu joni duge chi giti chkagu, jo chkeni llani kwian ngle kle Jesu manade ngwange, kwian ulita Jesu gau ngwange nga suga no ole. ");
INSERT INTO sabNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Gire onbre gdaite kwian israelita chugagwalla u mo litangwa Chube gerua jwanngwage chku Jesu kle ngwadi, onbre e kada Jairo, ama chku Jesudi toidu dba jongnagwa giti Jesu gwangnaru mo chudaboi kade Jesuge, Jairo gerudu Jesu ole: —Cha takalin ba joge cha ullage cha jian dodade. ");
INSERT INTO sabNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Cha jian gdaitre alin ama oga jabale, amage chege bedre jogeda, cha jian chura gdataboko giti gdaboke molen. Jesu Jairo keruchugu gire Jesu jo Jairo ole Jairo ulla ngnagu, kwian tanre jo Jesu ole ule, Jesu chagedu sklie kejre kwianske. ");
INSERT INTO sabNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Kaire kwian ngleaske muinga oga chagedu, muinga e oga daige sbali, chura gdataboko giti gdaboke chui kaire kairege muinga e kledu toi daige diali. Muinga e nu jogeba kwian mo dodanga tanrege mo dodade, kwian mo dodanga ulita me ñadu muinga dodade, ngwale muinga igi ulita monu ketu kwian mo dodangage, mo dodanga me ñadu muinga dodade. ");
INSERT INTO sabNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Muinga e chagedu Jesu nate jo chke kodi Jesudi, muinga ko chugu Jesu ñometralladi alin allabi gire sugeti muinga oga daige jo chke noni. ");
INSERT INTO sabNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Muinga ko chugu Jesu ñometralladi ene gire Jesu geru kadu kwian nglege: —¿Chema cha chugudi? Kwian ulita gerudu: —Cha me ba chugudi. Kwian ulita gerudu ene gire Pedro gerudu Jesu ole: —Cha tkanga tangle geruge, kwian tanre kle chage ba ugenga, kwian kle ba bienga ulita ongoru ongoru, ¿mineade ba kle geru kade chema ba chugudi? ");
INSERT INTO sabNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jesu gerudu: —Ulia kwian gdaite oga cha chugudi, nege sugeti uñale chage cha kwian oga dodadu cha kiralla giti. ");
INSERT INTO sabNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Muingage sugedu uñadu Jesuge ama Jesu chugudi muinga kendunga, muinga chku Jesudi jirenga trate jegwale toidu dba jongnagwa giti Jesu ngeru Jesu gai dage, gire muinga gerudu Jesu ole kwian ngle gwa giti: —Cha chagedu oga sbali malen cha mo ta gbu ba chugedi, sugedu chage cha ba chugedi alin allabi ene cha be joge chkeni. Boidu ene ulia cha tañachugu kare, cha ko chugu ba ñometralladi gire sugeti cha chegu trate no ulita. ");
INSERT INTO sabNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Muinga gerudu ene gire Jesu gerudu ama ole: —Ba mo ta gbu cha gai ulia malen e giti cha ba dodadu ba jo chke noni. Jogani nga suga no ole me tallade. ");
INSERT INTO sabNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesu kle gerule ene muinga ole gire onbre gdaite chiu Jairo ullage chku geru jige Jairoge jonke Jairo jian giti, onbre geru jiganga gerudu Jairo ole: —Ba kwian tkanga tangle geruge chuge ngwadi lle na boi, ngwale ba kle ama dbe mo ullage, ba jian me chegu. ");
INSERT INTO sabNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesu geru e keruchugu gire Jesu gerudu Jairo ole: —Ba me ta dbe kennga ba jian giti, ba me mo ta gbe olire ba jian nate, ba mo ta gbe cha gai ulia alin, e giti ba jian be joge chkeni noni. ");
INSERT INTO sabNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","Jesu jo dare Jairo ole, jo chke Jairo ullage, ne ngwadi kwian tanre kle olire kle sui jwennga Jairo jian jaba nate, Jesu gerudu kwian e ulita ole: —Ba me olire dare, ulia kirogwa muire me jogebada dale, agwa ama kle gbe alin allabi. Jesu gerudu ene gire kwian ulita gidedu Jesudi, kwiange uñale Jairo jian jokeda, ama me kle gbe ulia. Jesu jo chiga Jairo jian jaba kle ngwadi, Jesu jo Pedro ole Juan ole Santiago ole kaire kirogwa muire ñenua ole chebia ole, Jesu kwian e alin allabi chugu ngwadi joge chiga ule, Jesu me kwian na chugu ngwadi joge ule jaba kledu ngwadi. ");
INSERT INTO sabNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jesu kirogwa muire jaba gau koge, Jesu gerudu ama ole: —¡Kirogwa muire, chkede bduge! ");
INSERT INTO sabNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","56","Jesu gerudu ene gire kirogwa muire jaba chkuni gwade naskuni, blike chku mo klodegenga bduge, gire ama ñenua ama chebia chegu tañachuge tanre Jesu agedu giti, ama gerudu no modi Jesu giti: —Ulia Jesu kiraske, ama agedu no no che alin, ama che jian jaba gbuni gwadeni. Gire Jesu gerudu kirogwa muire ñenua ole chebia ole: —Cha ba jian jaba gbuni gwade giti ba me geru e kete kwian nage, ba geru e gatadale mo tale. Nege ba bligda kete ba jiange gutadale ama kira gbagda. ");
INSERT INTO sabNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesu kwian geru jwannga amage gdataboko giti gdaboke kadu mo lite ule ama ole, gire Jesu mo kiralla ketu ama ulitage dolla daga ngwale kagagda siere kwian jwligebanga dolla kotege kaire kira ketu kwian oga jingme daga ngwale ole dodagda. ");
INSERT INTO sabNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Jesu mo kiralla ketu ene kwian geru jwanngage gire Jesu ama ulita kagu Chube gerua Jesu giti trage kwian ole, kaire Jesu kwian geru jwannga kagu kwian tanre oga dodade. ");
INSERT INTO sabNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Kwian geru jwannga bebi joge Chube gerua dbe kwiange gire Jesu ama ulita ta gbu ama agedale giti ama joge chage geru dbe gire, Jesu gerudu ama ulita ole: —Ba joge Chube gerua dbe gire ba me lle dbe mo alin, ba jogedale kole. Ba me glita chagegda dbe, ba me gde teru dbangwa dbe ni ba bligda dbe mo liullale jonkare ni ba igi dbe mo alin lle gigagda. Ba ñometra dbe modi alin, ba me ñometra na dbe mo ole llagli. ");
INSERT INTO sabNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Una ulitage baini kaire ba joge chke ngwadi, ba u gbaitre alin gai toingwa, ba chege toi u e mauña ole gire ba Chube gerua dbe kwian una emuske. Ba joge dare una nage ba age ene una kaire kairege baini kare ba joge chke ngwadi. ");
INSERT INTO sabNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Una ulitage baini kaire ba joge chke ngwadi, una e gwealege kwian me ba gai ngwange no, ba me tallade, ba jogedale siere una ege, ba me chege geru dbe kwian una emuske, ba joge siere una ege ba dbi mnuña skiennga mo serage kwian ene gwa giti, ene be suge kwian una emuge ama chege jiske tanre Chube gwa giti me ba gai ngwange no gdale Chube gerua giti. ");
INSERT INTO sabNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Jesu gerudu ene kwian geru jwannga ulita ole gire kwian geru jwannga ulita jo una ulitage kaire kaire Chube gerua trage kwian ole kaire kwian tanre oga dodade. ");
INSERT INTO sabNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","E suiale kwian kada Herodes ama kwian nga Galileamu chugagwalla rey, Herodes ole kwian tanre geru tragu Jesu giti Jesu kle age giti ulita nga Galileage, e giti Herodes tañachugu tanre ni chku uñale amage kle boi mine. Kwian gweale gerudu Jesu giti Jesu amaña Juan-Bautista jogebada chkuni gwade. Kwian na gerudu Jesu giti Jesu amaña kwian Chube gerua ketanga unsuialin kada Elías chkuni. Kwian na gerudu Jesu giti Jesu amaña kwian gweale Chube gerua ketanga na nu jogebada unsuialin chkuni gwade. Kwian gerudu ene Herodes ole, Herodes me tachku gda uñale. ");
INSERT INTO sabNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodes gerudu kwian ole: —Cha agali kwian kagu Juan-Bautista chuga tkenga, ¿chema tra no kle chage nege, cha geru keruchuge tanre ama kle age giti? Herodes gerudu ene gire ama mo ta gbu gwage mo gwagwa giti Jesudi blike. ");
INSERT INTO sabNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jesu nu kwian geru jwannga amage ulita kagaba chage una kaire kairege Chube gerua trage daba na ole, ama ulita chkuni Jesu kle ngwadige, ama geru tragu Jesu ole ama lle bo ulita giti. Bigire Jesu jo ama ulita ole sugekare kwian na ulitage jo nga gballage kodi una Betsaidage. ");
INSERT INTO sabNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Kwian tanrege chku uñale Jesu jo nga gballage gire kwian e ulita jo Jesu nate, kwian jo chke Jesudi, Jesu kwian e ulita gau ngwange no, Jesu gerudu no trate kwian e ole Chube giti kaire Jesu kwian tanre oga dodadu. ");
INSERT INTO sabNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ngabi kodi nga jere ngnagu kwian geru jwannga ulita jo chke Jesudige gerudu Jesu ole: —Nga ai che kle ngwadi nga gballa, nga aige bligda me kwian ulita ai alin gutadale, kaire u gbengwa me ama alin. Noare ba gbi kade bdagli kwian ulitage, ba ama ulita kage siere nga aige, ene ama ulita ñage joge nga gwealege o una gwealege bligda gige mo alin gutadale kaire u gbengwa jinade mo alin. ");
INSERT INTO sabNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesu gerudu: —Ba ulita agali bligda kete kwian ulitage gutadale. Kwian geru jwannga gerudu Jesu ole: —¿Che kwian ngle ulita ulle llemadi? Bligda me ngle che ole kwian tanre alin gutadale, che pan molen gdatigale alin ngwe gdabokle alin, bligda e me ñage kwiange ulita. ¿Ba takalin cha ulita joge bligda ngle ngle gige kwian ai ulita ullagda, ene che ñage bligda kete kwian ulitage gutadale? ");
INSERT INTO sabNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","15","Kwian geru jwannga Jesuge gerudu ene gire Jesu gerudu ama ulita ole: —Ba kwian ngle ulita gbe toi dba kwian cincuenta mne kaire kaire. Kwian geru jwannga kwian gbu toi dba ulita Jesu gerudu kare, kwian ene ulitaske kwian onbre ngle cinco mil kledu, kaire muinga ngle kirogwa ngle kledu ule kwian onbre ngle eske, agwa muinga, kirogwa me jo teanba. ");
INSERT INTO sabNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ama ulita toidu dba gire Jesu pan gdatiga ngwe gdaboke gau kote, Jesu gwagedu nga ngaña giti, Jesu gerudu Chube ole: “Cha Ñenua, noare ba pan ai ngwe ai ketu kwian ai ulita alin gutadale.” Jesu gerudu ene Chube ole gire Jesu pan skutunga ngwe uda junnga, Jesu ngwe uda pan bita ketu kwian geru jwanngage girabatadale kwian ngle ulita ole. Jesu bligda gbu jriennga kwian ngle ulita alin gutadale. ");
INSERT INTO sabNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Kwian ngle ulita blidu no, kwian ulita unchku no bligdadi, gire bligda bita ngle cheguda, kwian geru jwannga Jesuge bligda bita e ulita litu ole ski kweri gbataboko giti gbaboke, ski e ulita chku ete bligda cheguda ole. ");
INSERT INTO sabNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Chui gbaite Jesu jo sugekare kwian ngle ulitage gerule Chube ole, kwian geru jwannga alin allabi kledu ama ole gire Jesu geru kadu kwian geru jwannga ulitage: —¿Kwian ulita kle gerule mine cha giti cha chema? ");
INSERT INTO sabNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Kwian geru jwannga jaindunga: —Kwian gweale kle gerule ba Juan-Bautista jogebakeda chkuni gwade, kwian na kle gerule ba kwian unsuialin kada Elías chkuni, kwian na kle gerule ba kwian Chube gerua ketanga dabage unsuialin gdaite chkuni gwade. ");
INSERT INTO sabNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Kwian geru jwannga gerudu ene Jesu ole gire Jesu geru kadu dare ama ulitage: —Kwian na kle gerule ene cha giti, ¿agwa ba gerule mine? ¿Cha chema? Pedro jaindunga Jesu kalen: —Ba Cristo, Chube ba kagu nga dba ai giti kwian kare kwian jwen siere ji chugege agedu me no gdale. ");
INSERT INTO sabNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pedro gerudu ene Jesu giti gire Jesu gerudu kwian geru jwannga amage gdataboko giti gdaboke ulita ole: —Pedro gerudu trate, agwa ba me geru e cha giti trage ni kwian gdaite na ole —Jesu gerudu ene kwian geru jwannga amage ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Jesu kwian geru jwannga amage ulita ta gbu Jesu be boi mine giti, Jesu gerudu: —Chube cha kagu nga dba ai giti kwian kare, kwian tanre be age cha dollale cha gbe boi daga ngwale, kwian israelita chugagwalla juma ulita kaire kwian gerunga Chube ole daba alin chugagwalla ulita kaire kwian daba tkanga tangle Moisés chadalla giti ulita, kwian e ulita me cha gerua gai ulia, ama ulita be jainchke chadi cha gerua gdale be cha gbe boi daga ngwale, bdagli cha gwabeda agwa mongikege cha jaba be chkeni gwade. ");
INSERT INTO sabNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Jesu gerudu ene mau giti gire gerudu dare: —Kwian bai ta chagekalin ulia cha ole me tañachugadale dare mau giti alin allabi me agedale dare ama agali ta agekalin kare, chui gdale ama mo ta gbadale cha gerua gbe gdadi age cha takalin kare, kwian na ama gbe boi daga ngwale cha gerua gdale kaire kwian na ta ama gwakalinda cha gerua gdale, ama me mo talladale. Kwian bai mo ta gbe ene ñage chage cha ole. ");
INSERT INTO sabNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kwian bai tañachuge mau giti alin allabi toi no nga dba ai giti mo manade no me tañachuge age Chube takalin kare giti, bdagli kwian ene be jogenga sugekare Chubege be chege boi daga ngwale tanre diali chui tangle. Agwa kwian bai mo ta gbe chage cha ole mo chuge ngwadi boi daga ngwale nga dba ai giti cha gerua gdale, ama me mo tallade, ama tañachuge ma no age Chube takalin kare, bdagli kwian ene be toi no diali chui tangle nga ngaña giti cha ole cha Ñenua Chube ole. ");
INSERT INTO sabNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Cha gerule ulia ba ole, ngwale kwian tañachuge tanre lle lite ole ngle giti ama kle toi nga dba ai giti gire. Kwian tañachuge lle lite ole alin allabi mau alin agwa ama me mo ta gbe ulia Chube ole, kwian e be jogenga ngwale, ama be chege sugekare Chubege diali chui tangle. ");
INSERT INTO sabNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Cha gerule ba ole, Chube cha kagu nga dba ai giti kwian kare, chui bdaglige cha be chieni nakwaite cha Ñenua Chube kiralla giti, cha be chieni ule lle boanga Chube alin nga ngaña giti ngle ole, kwian ulita be gwage chadi cha noare cha kweri. Kwian nege tangle bai kaire cha gai ulia agwa ama ibule cha giti cha gerua giti, nga chie ibule amage gerule kwian na ole ama cha gai ulia giti, kwian bai ibule ene cha giti nege, kwian ene giti cha mi gerule no cha be chieni chuiage, chui ege cha mi gerule ama giti ama chanu. ");
INSERT INTO sabNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Cha gerule ulia ba ulita ole, ba gweale kle aini cha ole cha keruchuge ba bebi jogeda gire ba gwa giti Chube be age no no cha ole ama kiralla giti, ba gwage chadi ene gire be suge trate bage cha noare cha kweri cha kwian ulita Chugagwalla —Jesu gerudu ene ulita. ");
INSERT INTO sabNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jesu gerudu ene ulita kwian ole, chui gbapa jo tangle gire Jesu jo jwichuga giti gerule Chube ole, Jesu kwian geru jwannga amage gdamaire alin allabi du ule, ama Pedro kaire Juan kaire Santiago du ule ama gatedi. ");
INSERT INTO sabNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Jesu jo chke jwichuga giti, eni Jesu kle gerule Chube ole gire Jesu gwa jwlitedu Jesu ñometralla ulita jwlitedu kwian geru jwannga gdamai gwa giti, Jesu ñometralla chratigunga jutre jutre. ");
INSERT INTO sabNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Kwian geru jwannga gdamai gwagedu Jesudi ene gire sugeti onbre nga ngaña giti boke chiu Chube kirallaske chku Jesu kle ngwadi, onbre edi tangle nga chratigunga, onbre e kada Moisés kaire Elías, ama boke chku geru trage Jesu ole Jesu be boi giti, ama gerudu Jesu ole: —Ba be boi dagale tanre, ba gwabeda una Jerusalénge Chube gerudu unsuialin kare. ");
INSERT INTO sabNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Kledu boi ene ulita gire Pedro kaire kwian geru jwannga na boke gbigachiu tanre, agwa ama jagedu gwade gwagedu nga chralladi nga chratigunga Jesu kle ngwadi kwian boke kle Jesu ole. ");
INSERT INTO sabNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Moisés kaire Elías jo jogeni siere Jesuge gire Pedro gerudu Jesu ole: —Cha tkanga tangle geruge, nga suga noare chadi che ulita chku aini. Cha be u soli gbe gbamai aini toingwa sugetidale, u gbaite ba alin, u gbaite Moisés alin, u gbaite Elías alin. Pedro gerudu ene ngwale, Pedroge me uñale ama kle gerule llema giti. ");
INSERT INTO sabNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pedro kledu gerule ene u giti gire bogakwa chku amadi tangle kaire ama skatemanalla bokedi tangle, ama ulita chegu bogakwaske gire ama kwachiu tanre. ");
INSERT INTO sabNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Gire bogakwaske Chube kerua sugedu ama ologe gerule: “Ai cha Kirolla, cha no no ama ole, ba ulita ama keruchugadale no, ba mo ta gbadale ama kerua gbe gdadi diali.” ");
INSERT INTO sabNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Chube kerua sugedu ene bogakwaske gire Pedro kaire Juan kaire Santiago gwageduni Jesudi Jesu kle gballa. Ulita gwagedu Jesudi boi ene me su gerule kwian na ole gdaite Jesu boidu giti, ama chegu kamne, gerudu modi alin allabi gwagedudi giti. ");
INSERT INTO sabNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Nagbietege Jesu ule kwian geru jwannga gdamai ole jo chkeni jwichuga gdoge dba, gire kwian geru jwannga Jesuge na ulita kaire kwian na tanre tendu Jesu ngwange jonke. ");
INSERT INTO sabNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Gire kwian onbre gdaite kle kwian ngleaske ngautu Jesuge: —Kwian tkanga tangle geruge, ba cha keruchuge, cha gerule ba ole cha takalin ba tai dage chage, cha kirolla gdaitre alin cháge ama oga, cha takalin ba ama dodade. ");
INSERT INTO sabNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Dolla kle age me no cha kirolla ole diali, chui gwealege ama kle no, chui gwealege ama kle boi tirare dolla kote, dolla kle cha kirolla gbe ngaute kweri, kaire kle nga kagenga kirogwa giti, kle kirogwa gbe trateda dba tangle gire kirogwa jolo tanre mlienga kate dolla kote, dolla age tanre me no cha kirolla ole, dolla me ta kirogwa chugakalin ngwadi ngwedige. ");
INSERT INTO sabNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Cha gerudu kwian geru jwannga bage ulita ole chudaboi kade amage dolla kage siere cha kirollage, agwa ama ulita me ñadu, malen cha chiu ba nate ba cha kirolla dodade. ");
INSERT INTO sabNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesu kirogwa ñenua keruchugu gerule ene gire Jesu gerudu kwian ulita kle eni ole: —Ba ulita me kle mo ta gbe cha gai ulia, ba ta me no. ¿Ngaminegire ba be mo ta gbe cha gai ulia, ene Chube ñage kira kete bage age ulita cha kle age kare? ¿Ngaminegire ba be kle kian gbe chage cha ba chudaboadale? Jesu gerudu ene kwian ulita ole gire Jesu gerudu kirogwa ñenua ole: —Kirogwa du chage aini. ");
INSERT INTO sabNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ñenua jo mo kirolla dbe Jesu ngnagu gire blike dolla kirogwa mliudba, dolla nga kagunga kirogwa giti, kirogwa tratuda dba tangle dolla kiralla kote, Jesu ka bo mno dolla ole: —¡Joga siere kirogwage blike! Jesu gerudu ene gire dolla jo siere kirogwage, sugeti kirogwa jo chkeni noni, Jesu kirogwa ketuni noni ñenuage manadale. ");
INSERT INTO sabNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Kwian ulita gwagedu Jesudi dolla kage siere kirogwage kwian ta me jo sugano Jesu agedu Chube kiralla gitidi. Gire Jesu gerudu kwian geru jwannga gdataboko giti gdaboke ole: ");
INSERT INTO sabNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Ba ulita geru ai keruchuge ba gbe mo chugadi, ba me geru talla kagenga mo giti. Chube cha kagu nga dba ai giti kwian kare, kwian cha dollale be cha gai be age me no cha ole ama takalin kare. ");
INSERT INTO sabNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Jesu gerudu ene kwian geru jwannga ole, agwa kwian geru jwanngage geru e me sugedu, Chube me ama ta gbu chke uñale malen ama tale ama kledu nga jereske kare, ama ulita ibudu geru kade Jesuge Jesu kle gerule llema giti. ");
INSERT INTO sabNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Kwian geru jwannga Jesuge gdataboko giti gdaboke kledu mo ka dodadeda ongoru ongoru ama ulitage bai be chege ma kweri Chube gwa giti. ");
INSERT INTO sabNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Chku uñale Jesuge kwian geru jwannga ulita kle tañachuge mine mo tale gire Jesu kirogwa soli gdaite kle eni gau gbu gdate mo ngena, ");
INSERT INTO sabNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Jesu gerudu kwian geru jwannga ulita ole: —Kwian bai kaire no cha ole ulia, kwian ene kle kirogwa ai kare gai ngwange no kle age no ama alin, kwian age ene me kle kirogwa alin allabi gai ngwange no, kaire ama kle cha gai ngwange no kle age no cha agali alin kare. Ene kaire kwian bai kaire cha gai ngwange no, kwian ene kle Chube cha kaganga nga dba ai giti gai ngwange no kaire. Kwian kle baske aini nga dba ai giti bai mo gbe soli daba na chudaboangale, kwian ene kweri Chube gwage —Jesu gerudu ene kwian geru jwannga amage ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Gire Juan gerudu Jesu ole: —Cha tkanga tangle geruge, cha ulita gwagedu kwian gdaitedi dolla kage siere kwian jwligebangage, kwian e gerudu ama kledu dolla kage siere dabage ba kiralla giti. Ama me kle chage che ole malen cha gerudu ama ole ama me ñage age ene dare. ");
INSERT INTO sabNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesu gerudu Juan ole: —Ba me gerule ama ole ama me ñage age ene dare, ba me ñage mo gbe ma kweri amage. Ulia kwian bai me kle age che dollale kwian ene kle age che bale kle che chudaboi, ba me ka boi ama ole —Jesu gerudu ene Juan ole. ");
INSERT INTO sabNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Chui chege kodi Jesu ngeru Jesu be jogeni nga ngaña giti, gire Jesu mo ta gbu joge una Jerusalénge. ");
INSERT INTO sabNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Jesu jo chage una Jerusalén ngnagu gire ama kwian gweale kagu mo ngeru u jinade nga Samariage, kwian e jo chke una gdaitege nga Samariage u jinade Jesu alin chegedaleda sugetidale. ");
INSERT INTO sabNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Bigwa Jesu chku una ege, chku uñale kwian toinga una ege Jesu be joge una Jerusalénge malen ama me Jesu gau ngwange no me u ketu amage gbengwa, kwian toinga nga Samariage me no kwian una Jerusalénmu ole. ");
INSERT INTO sabNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Kwian geru jwannga Jesuge boke kada Santiago kaire Juan gwagedu kwian nga Samariamu me Jesu gau ngwange no, Santiago kaire Juan gerudu Jesu ole: —Cha Chugagwalla, ¿ba takalin cha jita nga ngaña giti kade kwian una aimu gugagda ulita? ");
INSERT INTO sabNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Santiago kaire Juan gerudu ene Jesu ole kwian nga Samariamu giti gire Jesu gwagedu ama bokedi ka bo ama ole, Jesu gerudu: —¿Ni uñale bage cha talla mine kwian ole? ");
INSERT INTO sabNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Chube cha kagu nga dba ai giti kwian kare, cha me chiu kwian gwangaleda, cha chiu kwian jwanngale siere ji chugege age me no gdale. Jesu ka bo ene Santiago kaire Juan ole gire Jesu jo ule ama ole una nage. ");
INSERT INTO sabNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Jesu kle chage jonkare gire kwian gdaite gerudu Jesu ole: —Kwian chugagwalla, cha ta mo ta gbakalin chage ba ole baini kaire ba be joge ngwadi, cha be chage ule ba ole geru jwen bage. ");
INSERT INTO sabNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesu gerudu kwian e ole: —¿Ulia ba be ñage mo ta gbe chage cha ole baini kaire cha be joge chage ngwadige? Bliski ugara molen gbengwa kaire bdada ugara molen gbengwa, agwa cha me dale. Chube nu cha kagaba nga dba ai giti kwian kare, cha me u molen agali toingwa kaire gbengwa. ");
INSERT INTO sabNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesu gerudu ene gire chagedu dare, jonkare Jesu gerudu kwian na gdaite ole: —Bai chage cha ole geru jwen chage. Kwian e gerudu Jesu ole: —Kwian chugagwalla, cha chagekalin ba ole geru jwen bage agwa nege nege cha me ñage, cha be manade, cha ñenua be jogeda cha be ama jaba tke dbige gire cha be ñage chage ba ole. ");
INSERT INTO sabNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesu gerudu kwian e ole: —Ba ta chagekalin cha ole me ñage manade, ba chie chage cha ole nege. Ba mo ta gbadale ulia chage cha ole cha gerua nate, ba bitalla ulita me Chube gerua gai ulia ba ama jige ba ñenua jaba tke dbige, agwa ba chiedale chage cha ole Chube gerua jwen Chube gerua dbe kwian ulitage, ba geru Chube giti tragadale kwian ole. ");
INSERT INTO sabNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Jesu gerudu ene gire kwian na gdaite chku Jesudi gerule Jesu ole, ama gerudu: —Kwian chugagwalla, cha ta chagekalin ba ole, agwa cha takalin ba cha chuge ngwadi ngeru basale bdagli cha bitalladi, gire cha be chage ba ole. ");
INSERT INTO sabNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesu gerudu kwian e ole: —Kwian joge deage nga bate, ama nga bate sidri alin allabi gire blike ama ta jogekalinni gudegu, kwian ene me mo ta gbu lle boi no ulia, kwian ene me ñage lle boi no. Ene kaire kwian ta chagekalin cha ole lle boakalin no cha alin me ñage mo ta gbe tañachuge ngeru lle na giti, kwian tañachuge lle na giti ngeru, kwian ene me ñage Chube gerua dbe trage kwian ole. ");
INSERT INTO sabNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Iti Jesu kwian na setenta y dos gau kagale gdaboke mo kaire kaire mo ngeru ngage unage ulita baini Jesu be joge ngwadi. ");
INSERT INTO sabNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kwian e ulita mo litu Jesudi gire Jesu gerudu ama ole: —Cha kle ba kage Chube gerua trage kwian ole salengwli kwian bligda ngamalla mauña kle kwian bligda jwannga kage kare. Bligda chke noare joge dabe gire bligda mauña kwian bligda jwannga kage bligda jwen. Ene kaire kwian tanre me Chube gerua uñe, ama kle Chube gerua manade ngwange, ama bligda jogeba dabe kare, cha kle ba kage Chube gerua dbe amage. Kwian ngle kle Chube gerua manade ngwange, kwian geru dbanga bedreare, ba gerudale Chube ole ba takalin mo chudaboanga nglege, ene Chube be kwian na kage ba chudaboi Chube gerua dbe. ");
INSERT INTO sabNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Jesu gerudu ene kwian setenta y dos ole gire Jesu gerudu dare ama ole: —Cha kle ba ulita kage Chube gerua trage kwian ole, joga ta giti kwianske. Cha kle ba kage, kwian ta me no ama me no cha gerua ulia ole be age ba dollale, ama ta ba gbakalin boi daga ngwale, ba be chage kwian eneske salengwli bda oveja soli chage gude tirareske kare. ");
INSERT INTO sabNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ba joge Chube gerua dbe ba me teru dbe mo ole llagli, ba jogedale kole. Ba me igi dbe mo alin lle gigagda, ba me gde teru dbangwa dbe, ba zapato dbe modi alin, ba me chege jagenga gdate jonkare gbi kade kwiange. ");
INSERT INTO sabNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","U bai kairege ba joge chke, ba gbi kadadale no kwian ulitage kle toi u ege, ba gerudale ama ulita ole: “Cha takalin Chube age no ba ulita alin, ene ba ulita ta dbe suga no.” ");
INSERT INTO sabNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ba gbi kade no ene kwiange gire kwian jainnga ta no giti ba kalen gwajondoida kwian ba gai ngwange no, kwian ene alin Chube be age no. Agwa ba gbi kade kwiange gire kwian me jainnga ba kalen ta no giti me ba gai ngwange no, kwian ene alin Chube mi age no, Chube be age no ba alin allabi, ngwale ba gbi kade kwian enege, ama mi ba keruchuge gerule Chube giti. ");
INSERT INTO sabNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Una ulitage baini kaire ba joge chke ngwadi, ba u gbaitre alin gai toingwa, ba chegedale toi u e amañage, ba me joge chage uge nganake nganake. Bligda ketabe bage ba gute, ba kle cha gerua dbe kwiange ñanale Chube be kwian e ta gbe bligda kete bage, e salengwli igi ketakle lle boangage lle boi ñanale. ");
INSERT INTO sabNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ba be joge chke una baige kaire ba gabe ngwange bligda ole, ba bligda e ulita gutadale kwian kete bage kare. ");
INSERT INTO sabNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Una bai kairege ba joge chke ngwadi ba kwian oga dodadale, kaire ba gerudale kwian ulita una ege ole: “Chube be age kwian ulita alin chuia kle kodi, ba mo ta blitadale Chube ole ama gai mo Chugagwallale.” ");
INSERT INTO sabNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Una baini kaire ba joge chke ngwadige kwian me ba gai ngwange no, ba me tallade, ba jogedale siere una ege, ba gerudale kwian ulita una ege ole: ");
INSERT INTO sabNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Dbi mnuña ba unallage kwedu cha serage, cha dbi mnuña e skiennga trate cha serage ba ulita dollale ba me cha gau ngwange no gdale, ene be suge bage ba chege jiske tanre Chube gwa giti me cha gai ngwange no gdale Chube gerua giti. Cha takalin chke uñale bage Chube be age kwian ulita alin chuia kle kodi.” Ba gerudale ene ulita kwian una emu ole gire ba mo linge siere una ege. ");
INSERT INTO sabNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Cha gerule ba ulita ole, chui be chke gire Chube be ji gbe kwian una ege alin bai me ba gau ngwange no me tadu Chube gerua keruchugakalin, kwian ene alin Chube be ji gbe ma mno Chube ji gbu kwian agenga me no ulita alin una Sodomamuge unsuialin tangle. ");
INSERT INTO sabNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Kaire Chube be ji gbe tirare kwian una Corazínmu alin kwian una Betsaidamu alin, una Corazínge una Betsaidage cha lle daga ngwale no tanre dodadu Chube kiralla giti, kwian tanre toinga una boke ege gwagedu chadi age no ene amaske agwa ama me mo ta blitu Chube ole joge siere ama kle age me no Chube dollalege. E kare ene lle daga ngwale no jo dodabale una Sidónge una Tiroge kwian una boke emu gwa giti, gire ene kwian tanre una emu sbali mo ta blitu Chube ole, ene kwian e ulita ñometra juda me no tku modi ta olire ole kaire mnugda batu mo jegwale, ene ama mo kaite ta olire ole agedu me no ngerule giti. ");
INSERT INTO sabNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Agwa lle daga ngwale no me jo dodabale Chube kiralla giti una Sidónge una Tiroge lle daga ngwale no jo dodabale una Corazínge una Betsaidage kare, malen chui bdaglige Chube be ji gbe kwian agenga me no alin ulita chuia, chui ege Chube be kwian una Corazínmu kwian una Betsaidamu gbe ji chuge ma jabale kwian una Tiromuge kwian una Sidónmuge. ");
INSERT INTO sabNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kaire kwian una Capernaumge jiske tanre, ama kle tañachuge ama ulita ma no kwian una na ulitage ene bdagli ama be joge toi no Chube ole nga ngaña giti. E me ene dale. Bdagli Chube be ji gbe tirare kwian una Capernaummu alin, kwian e kagabe ji chuge tirare ngwadi nga dbigu giti. ");
INSERT INTO sabNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jesu gerudu ene kwian setenta y dos ole kwian me Chube gerua gai giti, gire Jesu gerudu dare kwian setenta y dos ulita ole: —Nege cha kle ba kage Chube gerua trage kwian na ole, kwian bai ba gai ngwange no ba keruchuge no, kwian ene me kle ba alin allabi gai ngwange no keruchuge no, kaire ama kle cha gai ngwange no cha keruchuge no agali kare ba giti. Kwian me ba gai ngwange no me ba gerua Chube giti gai ulia, e salengwli ama me kle cha agali gai ngwange no kare e salengwli ama me kle cha agali gerua gai ulia kare. Kwian me cha gerua gai ulia, e salengwli ama me kle Chube cha kaganga agali gerua gai ulia kare. Gire nege cha gerule ba ulita ole, joga Chube gerua trage kwian ulita ole una kaire kairege. Jesu gerudu ene kwian setenta y dos ole, gire kwian ulita jo gdaboke modi kaire kaire, ama ulita chagedu Chube gerua dbe kwian nage Jesu gerudu kare. ");
INSERT INTO sabNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Chui jo tangle gire kwian e ulita Jesu nu kagabage lle boadale bidegu Jesu kagu kare, ama chiunini nga suga noare oledi, chkuni Jesu kle ngwadi gire gerudu Jesu ole: —Cha Chugagwalla, ba kiralla giti cha dolla kagu siere kwian jwligebangage, dolla agedu cha gerudu kare. ");
INSERT INTO sabNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesu gerudu: —Ba kledu dolla kage siere kwiange, ba gerudu dolla ole gire sugeti cha gwagedu dolla ulita chugagwalla kada Satanádi, Satanás kira jonga ulita, cha kirachku Satanádi ulita blike salengwli nga ko chrachienga dba blike kare. ");
INSERT INTO sabNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Cha kiralla giti ba ñage kirachke dolladi, ba ñage skite jorisi giti jebda giti lle e me ba lendege. Cha kiralla giti ba ñage kirachke dolla ulitadi diali, dolla me ñage age me no ba ole. ");
INSERT INTO sabNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ba ñage kirachke dolla ulitadi, agwa e giti ba me nga dbe suga no, ma no ba nga dbadale suga no mo kalla giti kle degaba nga ngaña giti Chube kle ngwadi. ");
INSERT INTO sabNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Jesu kle gerule ene kwian setenta y dos ole gire Jesudi nga suga noare Chube Oña kirallaske, Jesu gerudu Chube ole: “Cha Ñenua, ba nga ngaña giti nga dba ai giti ulita Chugagwalla, nga suga noare chadi ba giti, ba noare ulita. Kwian me geru molen ama ta ba gerua gakalin ulia blike salengwli kirogwa geru gai blike kare, noare ba kwian ene ta gbu, ene amage ba gerua sugedu. Agwa kwian geru molen geru jun tanre lle ulita giti, kwian enege ba gerua me sugedu, ba gerua chegu ogabada kare amage. Chadi nga suga noare ba giti, ba kle kwian ta gbe ba takalinge kare, e no cha Ñenua.” ");
INSERT INTO sabNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Jesu gerudu ene Chube ole gire gerudu dare kwian setenta y dos ole: —Chube cha Ñenua ama mo kiralla mo talla ulita ketu chage. Cha Chube Kirolla, ulia ni kwian gdaite cha talla uñe trate, cha Ñenua alin allabi cha talla uñe trate. Kaire agwe ni kwian gdaite cha Ñenua talla uñe trate, cha alin allabi cha Ñenua talla uñe trate. Kwian baige cha takalin chke uñale cha Ñenua mine, cha kwian ene ta gbe, ene cha giti ama ñage cha Ñenua talla uñe trate. ");
INSERT INTO sabNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","24","Jesu gerudu ene kwian setenta y dos ole gire Jesu gerudu kwian geru jwannga amage gdataboko giti gdaboke ole sugekare kwian na ulitage, Jesu gerudu: —Cha gerule ba ulita ole, Chube kle age no no ba ulita alin malen ba ulita nga dbadale suga no. Cha kle aini baske age tanre no ba gwa giti Chube kiralla giti, ba ulita mo gwagwa giti kle gwage Chube kle agedi. Kwian Chube gerua ketanga unsuialin kaire kwian chugagwalla kweri unsuialin, kwian ene ngle tadu gwagekalin Chube kle agedi ba ulita kle gwagedi nege kare, agwa e suiale kwian e ulita me ñadu gwage ba ulita nege tangle kle gwage Chube kle agedige. Kaire kwian e ulita tadu geru keruchugakalin ba kle geru keruchuge nege kare cha giti, agwa ama me ñadu geru ai kare keruchuge —Jesu gerudu ene kwian geru jwannga amage ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Chui gbaite kwian daba tkanga tangle Moisés chadalla giti gdaite jo Jesu kle ngwadi ama ta mo chugakalin Jesu ole, kwian e chku Jesudi geru kadu Jesuge: —Ba kwian tkanga tangle geruge, cha geru kade bage, ¿cha llema boadale gire cha ñage toi diali chui tangle Chube ole nga ngaña giti? ");
INSERT INTO sabNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesu gerudu: —¿Moisés chadalla kle degaba gerule mine e giti? ¿Chada e suge mine bage? ");
INSERT INTO sabNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Kwian daba tkanga tangle Moisés chadalla giti jaindunga: —Moisés chadalla gerule: “Ba nodale ba Chugagwalla kweri Chube ole, ba mo ta dbadale no trate ulita ama ole, ba tañachugadale diali mo tale ama giti, ba mo ta gbadale kiraske lle boi ama alin ama takalin kare, ba mo chuga gbale no Chube alin ole.” Kaire Moisés chadalla gerule: “Mo ta dbadale no daba na ulita ole salengwli ba no mo ole naskuni kare.” ");
INSERT INTO sabNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesu gerudu: —Ba jaindunga geru uliage. Ba age ene ba ñage toi diali chui tangle Chube ole nga ngaña giti. ");
INSERT INTO sabNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Kwian daba tkanga tangle Moisés chadalla giti me tadukalin Jesu ama gbe jiske malen ama geru kadu Jesuge: —¿Kwian bai ole cha mo ta dbadale no? ");
INSERT INTO sabNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesu jaindunga: —Cha geru ai kete bage: Kwian onbre gdaite chagedu una Jerusalén jonlla kare joge una Jericó ngnagu, ama kwian israelita, kle chage jonkare gire ama tendu skwe boanga gweale ngwange, skwe boanga onbre batu tanre onbre kwara ngwale alin tkudadba, skwe boanga lle junnga ulita ama ngeru, ñometra onbre kle chage dbe modi skwe boanga junnga kigedu ole onbre ngeru, skwe boanga onbre chugu ngwadi jonke lendegaba jabale. ");
INSERT INTO sabNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Boidu ene gire kwian israelita gerunga Chube ole daba alin gdaite jo jon amaña kare, ama gwagedu onbre lentigeba jabaledi me onbre lentigeba jabale talladu, ama nga bliu giti jo tangle. ");
INSERT INTO sabNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Bigwa kwian israelita gerunga Chube ole daba alin chudaboanga gdaite chagedu jon amaña kare, ama gwagedu onbre lentigeba jabaledi me onbre lentigeba jabale talladu, ama nga bliu giti jo tangle. ");
INSERT INTO sabNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Bigwa onbre gdaite nga Samariamu jo jon amaña kare, onbre e gwagedu onbre lentigeba jabaledi jonke, ama taidu dage onbre ege. ");
INSERT INTO sabNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ama jo chke onbre lentigeba jabaledi ama onbre e dodadu, drega gligu gdege kadakle vino giti, gdege na lle kin kare gbu dregage, ama onbre lentigeba jabale drega gatuda drega luguda onbre lentigeba dodadu ulita. Gire onbre nga Samariamu onbre e gbu mo jalla giti gire du, ama u jinadu onbre lentigeba jabale manale ngwadi, u skwendu gire ama onbre lentigeba manadu u ege chuiete. ");
INSERT INTO sabNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Nagbietege onbre nga Samariamu be joge dare gire ama igi jun kwaboke modige ketu kwian u mauñage, ama gerudu u mauña ole: “Ba onbre ai manade no, ama be jiske ngle bage ba ama manade ñanale, cha be chieni gire cha be igi ama manade ñana kete ulita bage.” Onbre nga Samariamu gerudu ene gire ama jo dare. ");
INSERT INTO sabNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jesu gerudu ene ulita kwian daba tkanga tangle Moisés chadalla giti ole gire Jesu geru kadu amage: —¿Ba tañachuge mine, onbre gdamai bai mo ta du no daba lentigeba jabale ole? ");
INSERT INTO sabNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Kwian daba tkanga tangle Moisés chadalla giti jaindunga Jesu kalen: —Gdaitre alin allabi taidu dage onbre lentigeba jabalege agedu no ulita onbre e alin, onbre nga Samariamu mo ta du no daba ole. Gire Jesu gerudu: —Ba mo ta gbadale age kaire onbre nga Samariamu agedu kare, ba agedale no daba ulita alin diali. ");
INSERT INTO sabNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesu chagedu dare kwian geru jwannga gdataboko giti gdaboke ole una Jerusalén ngnagu, Jesu jo chke unage muinga kada Marta kle toi ngwadi, Marta Jesu gau ngwange no mo ullage. ");
INSERT INTO sabNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Jesu jo chke gwa, Marta daballa kada María kle gwa, María toidu dba Jesu sera ngena Jesu gerua keruchuge, agwa Marta me dale. ");
INSERT INTO sabNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta kle lle boi tanre, kle tañachuge lle tanre giti boadale, ama chku Jesudi gerudu Jesu ole: —Cha Chugagwalla, ¿ba me nga tallade cha giti? Lle tanre boadale, cha daballa kle cha chuge ngwadi lle boi gballa, gerule cha daballa ole ama cha chudaboi, ama kle toiba dba ngwale geru alin keruchuge. Jesu chke basale Martadi Maríadi ");
INSERT INTO sabNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jesu gerudu Marta ole: —Marta, ba kle tañachuge lle tanre giti, ba kle ta olire lle tanre kle boadale bage giti, lle e ulita ba me ta chugakalin ngwadi sugeti gire cha gerua keruchuge. ");
INSERT INTO sabNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Lle gdaitre alin allabi noare ba alin, e Chube gerua. Cha kle gerule Chube giti, María kle cha keruchuge, geru e be chege diali ama tale, kwian na mi ñage geru e jwennga ama ngeru. ");
INSERT INTO sabNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Chui gbaite Jesu kledu gerule Chube ole nga gwealege, kwian geru jwannga gdataboko giti gdaboke kledu ule Jesu ole, Jesu gerudubi Chube ole gire kwian geru jwannga gdaite gerudu Jesu ole: —Cha Chugagwalla, cha takalin ba cha ulita tke tangle gerule Chube ole Juan-Bautista kwian geru jwannga amage tku tangle kare. ");
INSERT INTO sabNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesu gerudu kwian geru jwannga amage ulita ole: —Ba gerule Chube ole ba gerudale ene: “Cha Ñenua, ba kle nga ngaña giti, ba no trate ulita, cha takalin kwian ulita gerule no ba giti. Cha takalin kwian ulita nga ulitage ba gai mo Chugagwallale. Cha takalin ba age mo ta giti ba ta agekalin kare nga dba ai giti salengwli ba kle age nga ngaña giti kare. ");
INSERT INTO sabNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Cha takalin ba bligda kete chage gutadale chui gdale toigda. ");
INSERT INTO sabNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Cha agedu me no cha takalin ba talla mlienga, ene kaire daba age me no cha ole cha talla mlienga. Ba me cha chuge ngwadi che dolla Satanáge, ene ama me ñage age me no cha ole. Ba cha jwen siere lle me no ulitage.” Ba ulita gerudale ene Chube ole. ");
INSERT INTO sabNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Kaire Jesu gerudu: —Ale gerule ba gweale skatemanalla molen gdaite, ba joge chke ba skatemanalla ullage nga jere bduke lle kade amage ba gerule ama ole: “Cha skatemanalla, ba bligda kete chage cha be bligda keteni daba ñanale bage. ");
INSERT INTO sabNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Cha skatemanalla na chiu bate chku cha ullage nege sugeti, cha ole bligda me ama ullagda.” ");
INSERT INTO sabNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","8","Ba bligda kade ene ba skatemanallage nga jere bduke, ¿ama be jainnga mine? Ale gerule ama jainnga ene: “Ba me cha chugedi, ulia ba cha skatemanalla agwa nege cha me ñage bligda kete bage, ugaka kle jegaba, cha kle gbe kaire cha kirolla ulita, cha me chkekalin gdate bligda kete bage sidri.” Ba skatemanalla gerule ene ba ole ba be bligda kade dare amage, ba be bligda kade tanre bdagli ama be chke gdate bligda kete bage ulita ba takalinge kare, ene ba me ama chugedi dare. Ene kaire ba ulita lle kadadale diali Chubege. ");
INSERT INTO sabNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ba lle kade diali ene Chubege, e salengwli kwian kle lle kade dabage diali kare gire lle ketakle amage, e salengwli kwian kle lle jinade nate diali kare gire lle kle skwen amage, e salengwli kwian kle ugaka dagenga kare ta jogekalin gwa daba ullage gire daba kle ugaka degenga ama alin jogedale gwa. ");
INSERT INTO sabNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kwian ulita bai kaire lle kade diali, kwian enege lle keta. Kwian bai kaire lle jinade nate diali, kwian enege lle be skwen. Kwian bai kaire ugaka dagenga diali, kwian ene alin ugaka tigenga. Ene kaire ba lle kade Chubege Chube be ba keruchuge Chube be age ba alin. ");
INSERT INTO sabNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ba ulita gweale kirogwa molen, kirogwa pan kade bage, ¿gire ba be ke kete amage gutale? Me dale, ba mi mo ta gbe ke kete kirogwage gutale, diali ba lle no ketakalin kirogwa banuge. Ba kirogwalla ngwe kade bage gutale, ¿gire ba be jorisi kete amage gutadale? Me dale, ba mi mo ta gbe age ene. ");
INSERT INTO sabNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ba kirogwalla koi kegwa kade bage gutadale, ¿gire ba be jebda kete amage gutadale? Me dale, ba be lle no alin kete amage gutadale. ");
INSERT INTO sabNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ba ulita talla agenga me no, agwa gire ba me lle me no kete ba kirogwallage, ba kle mo ta gbe age no mo kirogwalla alin, ba lle no ketakalin diali ba kirogwallage. Chube ba Ñenua kle nga ngaña giti, ama no trate ulita, ama ñage age ma no ulita ba alin ba kle age ba kirogwalla alinge, ama lle ma no kete bage, ama ta agekalin no no ba alin diali, kaire ama mo Oña kage ba alin ba bai ama Oña kade amage —Jesu gerudubi ene kwian geru jwannga amage ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Bitaite Jesu kle dolla kage siere kwian onbre gdaite jwligebangage, dolla nu onbre e gbaba keru me, onbre me ñage gerule. Jesu dolla kagu siere onbre ege gire onbre e jo chkeni ama ñaduni gerule. Kwian na ulita gwagedu boi enedi chegu tañachuge tanre Jesudi onbre jwligebanga jo chkeni no giti, kwian e ulita gerudu Jesu giti: —¡Kwian e kira molen tanre kwian oga dodade ene! ");
INSERT INTO sabNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Agwa kwian na gweale gerudu Jesudi: —Dolla chugagwalla Satanás kle kira kete amage, kira e giti ama kle dolla kage siere kwian jwligebangage. ");
INSERT INTO sabNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Kwian gweale na mo chugakalin Jesu ole, ama gerudu Jesu ole: —Ba kle gerule Chube ba kagu nga dba ai giti, cha takalin nege ba lle daga ngwale no kweri kwian me ña dodade mo kira giti kare, ba lle ene dodade cha ulita gwa giti, ene be chke uñale trate cha ulitage ulia Chube ba kagu ba kle age Chube kiralla giti. ");
INSERT INTO sabNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Uñale Jesuge kwian kle tañachuge mine Jesudi mo tale malen Jesu gerudu ama ulita ole: —Cha gerule ba ulita ole, kwian chugagwalla nga gdaitemu mo tke dole kwian ulita kle toi nga amañage ole, ama kwian ulita gbe kira bate modi ongoru ongoru, ene bdagli kwian be mo gweda ulita, chugagwalla be chege gballa ama mi chege kiraske. Kaire kwian toinga u gbaitre alinge kira bate modi mo bitalla gwa ole ulita, kwian ulita u ege be boi tanre daga ngwale, ene bdagli kwian e ulita be joge toi sugekare gdaite gdaite gire u mauña be chege toi gballa ama mi chege kiraske ama gdaitre alin chudaboanga me. ");
INSERT INTO sabNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","E kare ene dolla chugagwalla Satanás mo tke dole mo chudaboangalla ole mo gbe kira bate modi daba kage siere kwiange, dolla Satanás age ene mo chudaboangalla ole ama mi chege kiraske kwian gbanga age me no Chube dollale. Ba ulita kle gerule cha kle dolla kage siere kwiange dolla chugagwalla kada Satanás kiralla giti, agwa e me ulia ba ulita kle gerule kare. ");
INSERT INTO sabNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ba ulita tañachuge cha kle dolla kage siere kwiange Satanás kiralla giti, ba geru kade ba bitallage ba bitalla bai kle dolla kage siere kwiange, geru kade amage chema kle kira kete amage dolla kage siere kwiange, gire ulia ama be gerule ba ole ama me kle dolla kage siere kwiange dolla kiralla giti. Ba bitalla be gerule ene ba ole, gire e giti ñage suge trate bage ba me kle gerule ulia cha giti. ");
INSERT INTO sabNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Cha me kle dolla kage siere kwiange Satanás kiralla giti, me ene, Chube kiralla giti cha kle dolla kage siere kwiange, e giti chkedale uñale ba ulitage ulia Chube cha kagu ba ulitaske aini age ama kiralla giti. ");
INSERT INTO sabNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","22","’Cha geru ai ñachuge ba ulita alin: Onbre gdaite donga kiraske tanre, ama kle mo ulla manade no, ama kle mo dogdalla ulita manade no, ama tañachuge mo tale: “Cha dogdalla kle biale ulita, kwian na me ñage lle jwennga ni dogda jwennga cha ngeru, cha ñage kirachke kwian ulitadi dogda giti.” Ama kle tañachuge ene gire donga na ma kiraske chke ama ullage kira bate ama ole, donga u mauña me kirachke donga nadi gire kwian donga na dogda jwennga ulita ama ngeru lle ulita ama ullage jwen dbe girabate mo skatemanalla na ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Cha gerule ba ole, kwian bai me kle cha bale ama kle cha dollale, ama me kle cha gerua gai ulia me kle cha gerua kete daba nage, ama kle daba na gbe kige cha geruadi. ");
INSERT INTO sabNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Jesu gerudu dare dolla giti: —Dolla joge siere kwiange gire dolla chage nga gballage nga jinade undegangwa, nga me skwen amage gire ama tañachuge: “Cha be jogeni naskuni cha kwian jigu ngwadi, cha be jogeni toi ama tale nakwaite.” ");
INSERT INTO sabNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Gire dolla joge chkeni kwian e ngwadi, kwian e tale skwen dollage salengwli u gballa kare, nga kle litaba trate ulita, u e kle biale kwian alin toingwa. ");
INSERT INTO sabNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Kwian ta skwen ene dollage u gballa biale kare, gire dolla e joge dolla na tirare gdaguke jwen toi ule ama ole kwian e tale, bdagli kwian e boi ma dare ngeruge. ");
INSERT INTO sabNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesu kle gerule ene gire muinga gdaite gerudu kweri kwian ngleaske, ama gerudu Jesu ole: —Cha tañachuge nga suga noare ba chebiadi ba giti, noare ba medunga ama kote ama ba manadu no, ulia Chube agedu no ba chebia alin. ");
INSERT INTO sabNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Muinga gerudu ene gire Jesu gerudu muingage: —E ulia no agwa kwian bai Chube gerua keruchuge age Chube gerule kare, kwian ene mo ta dbe ma suga no ole cha chebia mo ta dbe nga suga no ole cha gitige. ");
INSERT INTO sabNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Kwian tanre litedu Jesudi gire Jesu gerudu kwian ulita ole: —Ba ulita kle toi chui aige ba kwian me no me no, ba ulita agenga me no, diali ba takalin cha lle daga ngwale no na dodade ba gwa giti, ene ba gerule ba be cha gai ulia Chube cha kagu nga dba ai giti, agwa nege nege cha mi age ba ulita takalin kare. Chui be chke gire cha be boi ba ulita gwa giti salengwli Jonás boidu unsuialin kare, Jonás toidu chui gbamai ngwe kweri kweri tadi gire ngwe Jonás mliunga kedagu gwade, e giti chku uñale kwian ngle toinga Jonás suialege ulia Chube Jonás kagu Chube gerua trage kwian ole. ");
INSERT INTO sabNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Nege cha chiu nga dba ai giti kwian kare, Chube cha kagu kwian kle toi chui aige alin salengwli Chube Jonás kagu kwian unsuialin toinga una Nínivege alin kare. ");
INSERT INTO sabNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Chui bdaglige Chube be ji gbe kwian agenga me no ulita giti chuia be chke, chui ege muinga gdaite nga kada Sabámu be meñe kwian ulitage, muinga e kwian nga Sabámu chugagwalla unsuialin. Muinga ege geru chku uñale kwian israelita chugagwalla unsuialin kada Salomón giti Salomón ta molen tanre, malen unsuialin muinga e jo bate bate Salomón jwiage Salomón gerua keruchugale, muinga e jo ene Salomón gerua nate. Cha gerua ma kweri Salomón geruage, nege cha agali kle gerule baske aini ba me ta cha gerua gakalin ulia, malen chui bdaglige muinga e be ba ulita kle toi nege tangle gbe jiske Chubege ba me cha gerua gau ulia gdale. ");
INSERT INTO sabNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Chui bdaglige Chube be ji gbe kwian agenga me no ulita alin chuia be chke, chui ege kaire kwian unsuialin toinga una Nínivege be meñe kwian ulitage. Unsuialin Jonás jo Chube gerua kete kwian Nínivemu ulitage, kwian Nínivege Jonás gerua keruchugu no, kwian mo ta blitu Chube ole jo siere ama kledu age me no Chube dollale ulitage. Cha gerua ma kweri Jonás geruage, nege cha agali kle gerule baske aini agwa ba me ta cha gerua gakalin ulia, malen chui bdaglige kwian una Nínivemu be ba ulita kle toi nege tangle gbe jiske Chubege ba me cha gerua gau ulia gdale. ");
INSERT INTO sabNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Jesu gerudu ene kwian ulita ole gire geru ñachugu jichra giti, Jesu gerudu: —Kwian jichra gwadege me kle jichra gbe sugekare baini kwian me tendi, me kle un blite kaboge jichra giti, agwa kwian jichra gbe ngaña nga ngwale giti, ene jichra chra tien no gwa tangle ene kwian chie eni ñage ten no gwa. ");
INSERT INTO sabNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ba gwagwa salengwli jichra kare. Ba gwagwa kle ba gbe ten, ba gwagwa kle no me oga, ene ba ñage ten no trate ulita. Ene kaire kwian bai kle chage no trate Chube takalin kare ama kwian gwagwa no kare chage nga chra no giti. Agwa ba gwagwa oga, ba me ñage ten no trate ba kle chage nga jereske. Ene kaire kwian bai me kle chage trate Chube geruadi kle chage age me no diali ama kwian gwagwa me no kare chage nga jereske. ");
INSERT INTO sabNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ba chage ta giti me mo chuge ngwadi chage age me no, ene ba me chege nga jereske kare. ");
INSERT INTO sabNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ulia ba mo ta gbadale chage no trate ulita Chube gwa giti ba me mo ta gbe age me no, ene ba me chege nga jereske kare agwa ba chege diali nga chra no giti kare, be chke uñale bage ba toidale mine no trate Chube takalin kare. ");
INSERT INTO sabNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesu kledu geru trage kwian ole gire kwian fariseo gdaite Jesu kadu blire ule mo ullage. Jesu jo, jo chke gwa, Jesu toidu dba blingwage kwian fariseo ole. ");
INSERT INTO sabNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Jesu kle blire gire kwian fariseo Jesu kadanga chegu tañachuge tanre mo tale Jesudi: “Jesu me agedu kwian israelita ulita kle age kare, kwian israelita diali kle ko glige trate tanre ngeru blirege, Jesu blidu me ko gligu ene kare.” ");
INSERT INTO sabNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Uñale Jesuge fariseo e kle tañachuge mine mo tale amadi, Jesu gerudu: —Ba kwian fariseo ulita kle tañachuge ba age ba enusulian unsuialin suia alin kare, ene ba tañachuge ba kwian no trate Chube gwa giti, agwa me ene ba kle tañachuge kare, ba tale ba ta me no, age me no tanre kle ba tale diali, diali ba kle tañachuge mo tale skwe boi daba ngeru kaire age tanre me no daba dollale. E salengwli kwian kle chi jangwa kaire batekwa glige giti tangle alin kare gire tañachuge chi jangwa kaire batekwa chege trate ulita, agwa batekwa kaire chi jangwa gligaba ene me trate dale, chi jangwa e batekwa e skieru kle chege sugaska. Ene kaire ba, ba tale ba kwian me no sugaska. ");
INSERT INTO sabNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nga ngwale ba chuga giti, ba me kle tañachuge no. ¿Ba tañachuge Chube ba jegwale alin dodadu me ba tadi dodadu? Chube ba jegwale dodadu kaire ba tadi dodadu, malen uñale amage ba ta mine ulita. ");
INSERT INTO sabNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ba kwian fariseo ulita mo ta ketadale Chubege gire Chube be ba ta lite trate ulita kwian kle lle gligenga trate kare, ene Chube be ba ta gbe suge ta no daba ole daba bai me lle molen. ");
INSERT INTO sabNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’Ba kwian fariseo ulita be ji chuge tanre bdagli, ba me kle age no Chube takalin kare. Ngwale ba kle lle ulita maunu kete sidri Chubege Moisés nu Chube gerua degaba unsuialin gerule kare, gliga kada menta kaire gliga kada ruda kaire gliga na tanre ba kle kete sidri Chubege, ba kle gliga e ulita kete sidri Chubege gire ba tañachuge ba no trate ulita Chube gwa giti. Ngwale ba kle lle alin kete Chubege, ba ta me kle Chube ole kaire ba me kle mo ta gbe age no daba na alin. Ba ta chegekalin no trate Chube gwa giti, ngeru ba mo ta gbadale no Chube ole kaire daba ulita ole, ba agedale no daba ulita alin, gire ba mo ta gbe lle maunu kete Chubege, ene no Chube alin. ");
INSERT INTO sabNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’Ba kwian fariseo ulita be ji chuge tanre bdagli, diali ba mo gbakalin ma kweri daba na ulitage. Ba kle joge u mo litangwa Chube gerua jwanngwage gire ba ta toikalin toingwa ma no giti kwian na ulita gwa giti. Ba kle chage jonkare, kwian na ten ba ngwange ba takalin kwian e ulita ba gai dage tañachuge ba kwian kweri, ba takalin kwian gbi kade bage kwian kle gbi kade mo chugagwallage kare. ");
INSERT INTO sabNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’Ba kwian fariseo ulita be ji chuge tanre bdagli ba kle age me no gdale. Ba ulita salengwli jaba dbia kare. Kwian ulita ñage chage ba nate ba kle age kare, kwian na ulita kle tañachuge ba kle chage no Chube gwa giti, agwa ba me chage ene dale, me chke uñale kwiange ba ta me no molen gire kwian kle chage ba nate chege kaire ba kare ta me no molen. E salengwli kwian chage jaba dbia giti tangle me chke uñale amage ama kle chage jaba dbia giti, agwa age ene gdale ama chege me no Chube gwa giti kwian israelita kle gerule kare. ");
INSERT INTO sabNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jesu gerudu ene kwian fariseo ole gire kwian daba tkanga tangle Moisés chadalla giti gdaite Jesu gerua keruchugu, ama gerudu Jesuge: —Ba kwian tkanga tangle geruge, ba kle ka boi kwian fariseo ole me chege no chage, chage suge ba kle ka boi kaire cha ulita daba tkanga tangle Moisés chadalla giti ole. ");
INSERT INTO sabNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesu gerudu: —Ba ulita kwian daba tkanga tangle Moisés chadalla giti ba kaire be ji chuge tanre bdagli, ba ulita kle age me no daba na ulita ole, ba kle daba na gbe age ulita Moisés chadalla gerule kare, kaire ba kle daba gbe age geru na ba agali kle gbe gerule kare. Ba daba na ulita gbe age ene agwa ba agali me kle age, kaire ba me kle daba na chudaboi age no geru kle gbaba kare e giti. ");
INSERT INTO sabNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","’Ba ulita be ji chuge tanre bdagli, ba salengwli ba enusulian unsuialin kare, ba enusulian unsuialin kwian ngle Chube gerua ketanga gau, guda, Chube gerua ketanga e jaba jo tkaba dbige. Gire nege tangle ba ulita kle nga lite trate dbi edi diali, age ene giti ba takalin kwian ulita tañachuge ba kle kwian Chube gerua ketanga oña e ulita gai dage malen ba kle ama jaba dbia manade no. Agwa ba tale ba kle tañachuge nobi ba enusulian unsuialin kwian Chube gerua ketanga ngle guda. ");
INSERT INTO sabNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Jondege uñale ulita Chubege kwian be age me no kwian Chube gerua ketanga ole, malen unsuialin Chube gerudu: “Cha be kwian tanre cha gerua ketanga dabage kaire kwian tanre cha gerua dbanga kwianske kage kwian ulita alin, kwian me no be ama gweale gweda be na gweale gbe boi tanre daga ngwale.” Chube gerudu ene unsuialin be boi giti. ");
INSERT INTO sabNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ba enusulian unsuialin ulita kwian ngle Chube gerua ketanga guda, Chube be kwian e ulita gwabada jia kade ba kwian kle toi negege. ");
INSERT INTO sabNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Kwian kada Abel ama kwian Chube gerua ketanga ngeru jo gwabada, e suiage dare kwian ngle Chube gerua ketanga jo gwabada, chku kwian kada Zacarías suiage tangle, Zacarías kaire jo gwabada, ama jo gwabada u gerungwa Chube olege. Cha gerule nakwaite ba ulita ole, Chube be kwian Chube gerua ketanga e ulita gwabada jia kade ba kwian kle toi negege tangle. ");
INSERT INTO sabNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’Ba kwian daba tkanga tangle Moisés chadalla giti ba ulita be ji chuge tanre bdagli, ba kate ba kle gerule ba kle Chube gerua gai ulia agwa ba tale ba me kle geru e gai ulia dale, malen ba me Chube uñe ba me Chubenu. Kwian na tanre ta Chube gerua uñakalin no trate ba giti agwa ba me takalin kwian e Chube gerua gai ulia mo alin, malen ba me kle ama chudaboi Chube gerua ulia uñe ba me kle ama tke tangle trate geru uliage. Age ene gdale ba ulita be ji chuge tanre bdagli. ");
INSERT INTO sabNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jesu gerudubi ene ulita gire Jesu jo siere nga ege. Kwian daba tkanga tangle Moisés chadalla giti ulita kaire kwian fariseo ulita skochiu tanre Jesudi geru e giti, malen ama ulita jo chage Jesu nate geru kade tanre Jesuge Jesu tkale gdege, ");
INSERT INTO sabNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ama tañachuge geru kade tanre ene Jesuge Jesu ñage gerule gweale me no, ene ama ñage Jesu gbe jiske geru gweale giti ama ulita takalin kare. ");
INSERT INTO sabNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Kwian nglea litedu Jesudi kwian jennga moge alin dabaske gire Jesu gerudu ngeru kwian geru jwannga amage gdataboko giti gdaboke ole: —Ba ulita kledale ta giti kwian fariseo ulitage, kwian fariseo kle gerule ama kle Chube gerua ulia alin trage kwian ole, ene kwian ulita tañachuge kwian fariseo kwian no trate, agwa ulia kwian fariseo ta me no, ama kle kwian tanre anblite geru giti. Malen ba ulita mo ta manadale no kwian fariseoge, ba kwian fariseo keru gbe gdadi ama ta me no be ñage chege ba tale. E salengwli pan dodade levadura ole kare, levadura tugaklenga ulita harinaske gire kle sie dodadale panle. ");
INSERT INTO sabNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kwian fariseo age skwlenre me no ulita mi chege ogabada diali, chui be chke gire kwian fariseo agedu talla ulita be chke uñale nate. ");
INSERT INTO sabNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ba mo ta gbadale me age kwian fariseo kare. Ba gerule skwlenre, bdagli be chke nate uñale ulita ba gerudu mine. Ba gerule jalin jalin sugekare kwian na ole, bdagli ba gerudu mine be suge kweri kwian ulitage, kwian ulita be ba gerua e keruchuge. ");
INSERT INTO sabNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Jesu gerudu dare: —Ba ulita cha skatemanalla chanu, cha gerule ba ole ba me mo ta dbadale kennga kwiandi kwian bai ba gwakalinda cha gerua gdale, ama ñage ba gweda alin allabi, ama me ñage age ba oña ole. ");
INSERT INTO sabNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Cha gerule ba ole, ma no ba mo ta dbe kennga Chubedi, Chube ñage kwian gweda, kaire Chube ñage age kwian oña ole ñage kwian oña kage nga dbigu giti ji chuge diali. Chube ñage age ene malen ma no ba mo ta dbadale kennga Chubedi mo ta gbadale Chube gai dage no. ");
INSERT INTO sabNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","7","Chube kle ba ulita manade no malen ba me mo ta dbadale kennga kwian agenga me no ba oledi. Bdada soli gai gbatiga bdada soli chbade, igi gai sidri bdada ñanale, bdada me ñanaske. Ba ulita me ene, ba ulita ñanaske tanre Chube alin. Bdada me ñanaske agwa Chube kle bdada manade no diali, Chube tale ama me bdada talla kagenga gbaite. Kaire ene Chube kle ba manade ma no bdadage, ba chugaga ulita Chubege uñale gdamangire. Ulia Chube kle ba manade no no malen ba me mo tallade kwian kle age me no ba ole giti, ba me ta dbe kennga cha gerua trage kwian ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Cha gerule ba ole, cha chiu nga dba ai giti kwian kare, kwian bai kaire gerule no cha giti nga dba ai giti kwian ulita gwa giti, kwian e gerule ama cha gai ulia, ama gerule ene no cha giti, ene kaire bdagli cha be gerule no kwian e giti lle boanga Chube alin nga ngaña giti ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Agwa kwian bai kaire gerule me no cha giti nga dba ai giti kwian ulita gwa giti, kwian e gerule kwian ulita ole ama me cha gai ulia ama me cha uñe, ene kaire bdagli cha be gerule lle boanga Chube alin nga ngaña giti ulita ole cha me kwian e uñe dale, ama me kwian chanu. ");
INSERT INTO sabNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Kwian bai gerule me no cha dollale gire bigwa kwian e ta jwlite cha ole, kwian ene gerudu ulita me no cha dollale Chube talla mlienga. Agwa kwian bai gerule me no Chube Oña dollale, Chube me kwian gerudu me no ene talla mlienga dale, kwian ene chege jiske diali Chube gwa giti ama gerudu Chube Oña dollale gdale. ");
INSERT INTO sabNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Kwian tanre cha gerua dollale be ba cha gerua ganga dbe u mo litangwa Chube gerua jwanngwage, u ege kwian e be ba gbe jiske kwian israelita chugagwalla ulitage cha gerua gdale, ba boi ene gire ba me mo tallade ba be gerule mine mau giti chugagwalla kweri e ulita gwa giti. ");
INSERT INTO sabNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ba be kle eni kwian e gwa giti gire chui ege Chube Oña be ba ta gbe ba gerudale mine kwian ole, ulia Chube Oña be ba chudaboi ulita geru giti —Jesu gerudu ene ulita kwian geru jwannga gdataboko giti gdaboke ole. ");
INSERT INTO sabNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Kwian onbre daba ngleaske gdaite gerudu Jesu ole: —Kwian tkanga tangle geruge, cha ñenua me chegu, ama lle jigu ngle cha alin cha daballa alin, ama chude jigu bda jigu dbi jigu cha gdaboke alin. Cha daballa lle e gau ulita mau alin, cha takalin ba gerule ama ole ama lle ulita girabatadale bonga cha ole. ");
INSERT INTO sabNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesu gerudu onbre e ole: —Cha me ta agekalin ba takalin kare. Chube me cha kagu nga dba ai giti kwian daba gbanga jiske kare kle kwian me chegeba llea girabate kwian oña bitalla ole. ");
INSERT INTO sabNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Kaire Jesu gerudu kwian nglea ole ulita: —Ba me mo ta gbadale tañachuge diali ba ta lle na tanre gakalin mau alin. Kwian lle tanre gai, ama jogeda lle e ulita me ñage ama oña jwen siere ji chugege me ñage ama oña gbe toi diali chui tangle Chube ole. ");
INSERT INTO sabNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Gire Jesu geru ñachugu kwian ulita alin: —Kwian onbre gdaite lle molen tanre, ama chudea ulita chku noare. ");
INSERT INTO sabNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Kwian e lle molen tanre tañachugu mo tale: “¿Cha be age mine? ¿Cha be bligda jwen ulita cha be oge baini? Bligda ngle, u bligda ogangwa soliare.” ");
INSERT INTO sabNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Kwian lle molen tanre kle tañachuge ene gire tachku, ama gerudu mo tale: “Nege uñale chage cha be age mine, cha be u soli skiendba cha be u na kweri dodade u soli tanege, ene bligda ulita kaire cha llea ulita cha be oge u kweri e gbaitre alinge. ");
INSERT INTO sabNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Lle kle ogaba ulita gire cha be tañachuge mo tale gballa: ‘Lle tanre kle ogaba chura tanre alin, nege cha undege, cha blire, cha lle jai, cha nga dbe suga no.’ ” ");
INSERT INTO sabNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","21","Kwian kle tañachuge ene gire Chube gerudu ama ole: “Nga ngwale ba chuga giti, nege ngajrege ba be jogeda, ba kle lle ulita oge, ¿e be chege chema alin?” Jesu geru ñachugu ene gire Jesu gerudu kwian nglea ole: —Chube gerudu ene kwian lle molen tanre e ole. Cha gerule ba ole, ngwale kwian lle tanre gai, ama tañachuge toi no ene, tañachuge e alin giti me tañachuge Chube giti, Chube gwage kwian ene me lle molen dale. ");
INSERT INTO sabNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","23","Jesu gerudu ene kwian nglea ulita ole gire Jesu gerudu kwian geru jwannga amage ulita ole: —Cha gerule ba ole, ba me mo ta dbe tañachuge tanre diali lle toigda giti, ba be llema gute toigda chui bdugu, llema giti ba be mo ngama tke. Noare ba bligda molen gutadale, noare ba ñometra molen mo ngama tkagda, agwa me no tañachuge tanre diali bligda alin giti ñometra alin giti mo alin toigda. Chube ba dodadu ama ba gbu toi gwade, ene kaire Chube be lle ulita kete bage toigda, malen ma no ba mo ta gbe tañachuge diali Chube giti me tañachuge lle alin allabi giti toigda no nga dba ai giti. ");
INSERT INTO sabNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ba ulita tachkedale bdada giti, bdada me kle chude ngama gbe, me kle chude tke, me kle bligda lite ole ogadale, me kle lle boi dale agwa kle toi no, Chube kle ama manade, Chube kle bligda kete bdadage gutadale. Chube alin ba ma ñanaske bdadage, bdada me ñanaske ba kare Chube gwa giti agwa Chube kle ama manade no, ene kaire bage sugedale Chube be ba manade no diali. ");
INSERT INTO sabNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ngwale ba tañachuge tanre lle ulita giti mo alin toigda, tañachuge tanre ene kare giti ba me ñage chui na dare gai mo alin toigda, chui be chke ba alin jogeda gire ba be jogeda diali. ");
INSERT INTO sabNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ulia ba agali me ñage chui na dare gbaite gai mau alin toingwa, Chube alin allabi ñage ba gbe toi chui dare. ¿Mineade ba kle tañachuge tanre lle ulita giti mo alin toigda? Chube kle ba manade. ");
INSERT INTO sabNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ba ulita tachkedale glijra giti, che gwage glijradi glijra noare, diali glijra meñe no, e Chube kle gbe ene, glijra me lle boi dale, meñe no alin allabi. Cha gerule ba ole, kwian chugagwalla unsuialin kada Salomón, ama kwian kweri, ama mo ngama tku ñometra noareske, agwa glijra ma noare Salomón ñometrallage. ");
INSERT INTO sabNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Chube glijra gbe tige no, nege glijra kle no, suialin gire glijra kwenga. Glijra me ñanaske ba kare Chube gwa giti agwa Chube kle glijra gbe skiennga no, Chube alin ba ñanaske tanre ama be ba manade no diali, lle gweale me ba ole toigda Chube be lle e kete bage. Ba me kle Chube gai ulia Chube ñage ba manade no, ba mo ta gbadale me tañachuge ene dare, ulia Chube be ba manade no diali, ba ama gadale ulia. ");
INSERT INTO sabNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ba Chube uñe malen ba me mo ta dbadale olire lle toigda nate, ba be llema gute, ba be llema jai, llema giti ba be mo ngama tke. ");
INSERT INTO sabNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kwian me Chube uñe ulita diali kle mo ta dbe olire lle toigda nate. Agwa ba Chubenu, Chube ba Ñenua, amage uñale ba takalin llemage ene ba toi no. ");
INSERT INTO sabNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ba mo ta gbadale Chube gai diali mo Chugagwallale, ba ama gadale dage age ama takalin kare, ene Chube be ba manade no be lle toigda kete bage lle bai me ba ole ene ba toi no nga dba ai giti. ");
INSERT INTO sabNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Jesu gerudu dare: —Ba bedreare kle mo ta gbe cha gai ulia, agwa gire ba ulita me mo ta dbadale kennga, Chube ba Ñenua, ama ba gau mau alin, ama kle ba manade no, ama ta lle ketakalin bage toigda chui gdale nga dba ai giti, kaire chui be chke gire ba be toi no ule ama ole nga ngaña giti diali chui tangle, e nobi Chube alin. ");
INSERT INTO sabNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ba me mo ta gbe tañachuge lle oge mau alin nga dba ai giti diali chui tangle, chui gweale lle e ulita be jogenga ngwale. Ba lle molen ba lle e chbadale, igi gai lle ñanale ba igi e ketadale kwian bai me lle molenge. Ba kwian chudaboi ene nga dba ai giti, nga ngaña giti Chube kle lle noare oge ba alin, lle nga ngaña giti me jogenga ngwale dale, llani kwian skwe boanga me joge chke lle banu jwen, kaire chubdu me lle banu gute. ");
INSERT INTO sabNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ba mo ta gbe lle lite ole tanre mau alin nga dba ai giti ba be kle tañachuge diali lle nga dba ai giti alinge, ba be ta jogenga tañachuge Chube giti. Agwa ba mo ta gbe diali tachke Chube giti age ama takalin kare nga dba ai giti, ba ta be kle ule diali Chube ole nga ngaña giti tañachuge Chube giti alin allabi. ");
INSERT INTO sabNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Jesu gerudu ene ulita kwian geru jwannga gdataboko giti gdaboke ole gire Jesu geru ñachugu ama alin: —Cha be chieni ba ulita kledale manade biale cha ngwange salengwli kwian lle boanga kle manade biale mo chugagwalla ngwange kare. Chugagwalla joge kwian mo jwen chuia ollade, kwian lle boanga ama alin ulita chegeda gwa chugagwalla chieni manade ngwange, ngajrege kwian lle boanga jichra gwadege chugagwalla manade ngwange jichra giti, ama be kle manade gire sugeti chugagwalla be chkeni ugaka dagenga, gire kwian lle boanga be ugaka degenga chugagwalla ngwange. ");
INSERT INTO sabNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","38","Chugagwalla ñage chkeni nga jere bduke ñage chkeni ngakamalin bdugu, kwian lle boanga me kle gbe, kle chege gwade chugagwalla manade ngwange, noare kwian lle boanga ulita skate chugagwallage gwade. Chugagwalla be chkeni gwa, lle boanga skate chugagwallage gwade chugagwalla manade ngwange chugagwalla be bligda kete agali kwian lle boangage, nga be suga noare kwian lle boangadi. ");
INSERT INTO sabNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Jesu geru na ñachugu: —Kwian u mauñage chke uñale ngaminegire kwian skwe boanga be chie lle jwennga ama ngeru, ene kwian u mauña be chege gwade ta giti kwian skwe boanga jege ngwange, ama mi kwian skwe boanga chuge ngwadi lle jwennga ama ngeru. ");
INSERT INTO sabNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ene kaire ba ulita kledale biale cha chieni chuia manade ngwange. Cha chiu nga dba ai giti kwian kare, cha be chieni nabitaite, agwa me uñale bage chui baige cha be chieni, malen ba kledale biale diali. Ba me mo ta gbe tañachuge diali cha be chieni giti, gire cha be chieni chuiage ba be skate alenske chage. Cha me takalin ba ulita skate alenske chage. ");
INSERT INTO sabNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Jesu gerudu ene gire Pedro geru kadu Jesuge: —Cha Chugagwalla, ¿ba geru e ñachugu cha geru jwannga bage gdataboko giti gdabokege alin allabi o kwian na ulitage kaire? ");
INSERT INTO sabNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jesu gerudu Pedro ole: —Cha gerule ba ulita ole, ba kledale biale cha manade ngwange lle boi no diali cha takalin kare, cha geru ñachuge bage ai kare: Kwian gdaite lle boanga no u mauña alin, kwian lle boanga e ta molen lle boi, u mauña be joge toi nga nage chui gwealege gire u mauña be kwian lle boanga no e jige lle boanga na ulita chugagwallale, lle boanga no ene be lle boanga na ulita manade no be bligda kete ama ulitage gutadale, be age ulita u mauña gerudu kare. ");
INSERT INTO sabNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","U mauña be chkeni be gwage kwian lle boanga ama alin gdaitedige ama jigu lle boanga na ulita chugagwallale ama kle lle boi no u mauña gerudu kare, nga be suga noare kwian lle boanga edi ama skwendu u mauñage lle boi no u mauña gerudu kare. ");
INSERT INTO sabNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ulia cha gerule ba ole kwian ene lle boi no ulita u mauña gerule kare gire ene u mauña be lle boanga e gbe lle amanu ulita manade. ");
INSERT INTO sabNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Agwa kwian lle boanga u mauña alin me no, u mauña kwian ene jige lle boanga na ulita chugagwallale gire joge nga gwealege, lle boanga me no e be tañachuge mo tale: “Cha chugagwalla u mauña mi chieni blike, cha me lle boadale blike dale.” Ama tañachuge ene, gire ama be age dagale lle boanga na ulita ole be lle boanga na ulita gbe boi daga ngwale tanre, ama be sui chuge blire lle gage jai. ");
INSERT INTO sabNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Agwa gire chui gbaite kwian lle boanga me no e me kle mo chugagwalla u mauña manade ngwange ama me kle tañachuge chui baige chui mangirege chugagwalla be chieni, ama ni kle tañachuge ama chugagwalla be chieni giti, gire chui ege chugagwalla be chkeni. U mauña kwian jigu lle boanga ama alin ulita chugagwallale, kwian e be skate u mauñage age me no, malen u mauña be ji gbe kweri kwian ene giti, ama me agedu u mauña gerudu kare, u mauña be ama mlienga, ama be joge boi daga ngwale ule kwian na agenga me no ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","U mauña kwian jige lle boanga na ulita chugagwallalege suge uñale u mauña takalin ama agedale u mauña gerule kare, agwa gire kwian e me u mauña gai dage me age u mauña gerudu kare, kwian ene alin u mauña be ji gbe mnoare. ");
INSERT INTO sabNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Agwa kwian baige me uñale u mauña takalin ama agedale u mauña gerule kare gire kwian e age me no, me uñale amage u mauña takalin mine, kwian ene be ji chuge bedre. Kaire ene kwian bai me Chube gai dage me age ama gerule kare, Chube be ji gbe kwian alin. Kwian bai Chube gerua uñe ngle kwian ene Chube gerua gadale dage ngle. Chube kwian bai ta gbe lle boi ama alin, kwian ene lle boadale no diali Chube alin, kwian me age ene kwian be ji chuge tanre. ");
INSERT INTO sabNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jesu gerudu ene mo chieni chuia giti gire gerudu dare: —Cha chiu nga dba ai giti lle ulita me no mlienga salengwli nga databa sbali jogeba ulen jita nga ene guge ulita nga chege trate kare. Cha me ta manakalin dare, lle tanre kle boale cha alin nga dba ai giti, cha ta lle e boakalin ulita blike. ");
INSERT INTO sabNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Uñale chage cha be boi daga ngwale, kwian me no be cha gweda, cha kle ta dbe olire tanre tañachuge cha be boi giti. ");
INSERT INTO sabNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Ba kle tañachuge cha chiu nga dba ai giti kwian ulita gbe toi no ule ene kwian me kira bate? Me dale. Cha gerua giti kwian tanre be mo dollale daba na ole, kwian gweale be cha gerua gai ulia, gweale na me dale, gire kwian ene me cha gerua gai ulia be kira bate daba ole bai cha gerua gai ulia ole. ");
INSERT INTO sabNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Cha gerua giti nege gwangerugu kwian tanre be mo dollale mo bitallanu ole, kwian tiga toi u gbaitre alinge, kwian gdamai be kira bate kwian boke ole, kwian boke be kira bate kwian gdamai ole. ");
INSERT INTO sabNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ñenua be kira bate kirolla ole, kirolla be kira bate ñenua ole, chebia be kira bate jian ole, jian be kira bate chebia ole, ñemaña be kira bate gwadimea ole, gwadimea be kira bate ñemaña ole, ulita gwa mi tañachuge ule modi. ");
INSERT INTO sabNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesu gerudu ene kwian geru jwannga ulita ole, gire Jesu gerudu kwian nglea ulita ole: —Ba ulita ta kle chke nga gbe gdadi noi be boi noi mi boi, ba gwage bogakwadi nga gwalugenga gire ba kle gerule: “Noi be boi”, gire kle boi ene ulia ba gerule kare. ");
INSERT INTO sabNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kaire ba gwage nga ngañadi, bogakwa me, nga trate ngaña gire ba kle gerule: “Chui be boi jute”, gire kle boi ene ulia ba gerule kare. ");
INSERT INTO sabNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Uñale bage gwage nga ngañadi suge bage nga be boi mine, noi be boi o noi mi boi. E suge trate ba ulitage, ¿mineade me suge kaire bage cha kle age Chube kiralla giti cha me kle age Chube kiralla giti aini baske? Ngwale ba kle gerule ba Chube uñe, ba me Chube uñe ulia, ba kle gerule alin allabi ba Chube uñe, agwa gire ta me kle Chube ole. ");
INSERT INTO sabNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Mineade ba me mo ta gbe ulia Chube ole age no ama takalin kare, ene ba me jiske Chube gwa giti? ");
INSERT INTO sabNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ale gerule ba jiske daba gwealege age gweale me no ama ole giti, daba e ba dbe chugagwalla ngwadi ba gbale jiske chugagwallage, daba age ene ba ole ma no jonkare ba mo ta gbadale no kwian ba dbanga ole, ba gerule no ama ole: “Cha me ta jogekalin chugagwalla ngwadi, ma no cha alin cha agedu me no che chege e trage modi ta no giti aini jonkare, gire ene ulita ñage chege no trate ba tale kaire cha tale, ene ba me cha gbe jiske chugagwallage.” Ba gerule ene ba dbanga ole jonkare, gire kwian ba dbanga me ba dbe chugagwalla ngwadi, ene chugagwalla me ba kete kwian guardia dongage tkale skage. ");
INSERT INTO sabNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Cha gerule ba ole, guardia donga ba tke skage ba mi ñage joge siere ne ngwadige blike, ngeru ba igi ulita ba agedu me no daba ole ñanalla ketadale mo giti gire ene ba ñage skachienga. E kare ene ba mo ta gbadale no Chube ole nege, ene ba me chege jiske Chube gwa giti, ene Chube mi ba gbe ji chuge ba agedu me no gdale —Jesu gerudubi ene ulita kwian nglea ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","E suiale kwian gweale chku Jesudi gerule Jesu ole kwian chugagwalla gobernador kada Pilato giti, ama gerudu Jesu ole: —Pilato kwian kagu kwian nga Galileamu gweda, Pilato kwian bea tugangunga bda beaske gugle Chube gwa giti u gerungwa Chube olege una Jerusalénge. ");
INSERT INTO sabNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesu gerudu: —¿Ba tañachuge mine e giti? ¿Ba tañachuge kwian toinga nga Galileage ulitaske kwian jokeda alin allabi agenga me no tanre malen ama guleda ene? ");
INSERT INTO sabNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Cha gerule me dale, kwian ulita agenga me no. Ba ulita bai me mo ta blite Chube ole ba be jogeda gire ba oña be kle sugekare Chubege diali chui tangle. ");
INSERT INTO sabNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Nga soli kada Siloége una Jerusalénge u gbaite kweri jeike ngaña kledu, u e jo chke dba kwian gdataboko giti gdapa ulita giti, kwian e ulita jokeda u kote. ¿Ba tañachuge mine e giti? ¿Kwian toinga una Jerusalénge ulitaske kwian gdataboko giti gdapa e alin allabi agenga me no tanre malen ama jokeda ene? ");
INSERT INTO sabNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Cha gerule me dale, kwian ulita agenga me no. Ba ulita bai me mo ta blite Chube ole ba be jogeda gire ba oña be kle sugekare Chubege diali chui tangle. ");
INSERT INTO sabNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesu gerudu ene ulita gire Jesu geru na ñachugu kwian ulita alin, Jesu gerudu: —Cha geru ñachuge bage ai kare: Onbre gdaite gli kada higuera tku deage, gli e tigedu gli jo kweri. Gli mauña jo gwage gli edi deage gli gbachiu gweale itadale o me, gli mauña jo chke deage gwagedu glidi, gligba me skwendu amage. ");
INSERT INTO sabNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Gli mauña chagedu chura gdamai deage gligba nate, gligba me skwendu amage, malen ama gerudu kwian gli mananga ole: “Cha chagedu chura gdamai gligba nate jwandale, gligba me skwendu chage ni gbaite. Ba gli e date, ngwale gli kle dbi gai gli me gbachie.” ");
INSERT INTO sabNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Kwian gli mananga gerudu kwian gli mauña ole: “Ba gli chuge ngwadi chura na gdaite, cha be nga lite trate ulita glidi tangle, cha be mnugda bate glidi tangle, ");
INSERT INTO sabNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ene gli ñage gbachie, agwa gli me gbachie ba ñage cha kage kwaite gli date.” Jesu geru ñachugu ene kwian higuera mauña giti, ene be suge kwiange kwian ta me no kwian me mo ta blite Chube ole Chube be ama gbe ji chuge kwian higuera mauña higuera me no datangu kare, kwian ene be chege sugekare Chubege diali chui tangle. ");
INSERT INTO sabNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Bitaite chui na undege chuiage Jesu kledu kwian tke tangle u mo litangwa Chube gerua jwanngwage. ");
INSERT INTO sabNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Muinga oga gdaite kle eni Jesu gerua keruchuge, muinga e nu ogaba sbali chura gdataboko giti gdapa, ama chagedu kwebanga kaboge, me ñadu chage kwian kle chage kare, dolla ama gbu oga malen ama chegu ene kwebanga. ");
INSERT INTO sabNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesu gwagedu muinga edi Jesu muinga kadu mo gitigu. Muinga chku Jesudi, Jesu gerudu muinga ole: —Nege ba me chege oga dare, ba be chege toi no. ");
INSERT INTO sabNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Jesu gerudu ene gire ama ko gbu muinga giti, sugeti muinga cheguni no trate nge kare. Gire muingadi nga chegu suga noare, muinga gerudu no no Chube giti. ");
INSERT INTO sabNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Jesu muinga dodadu ene gire kwian u mo litangwa Chube gerua jwanngwa mananga skochiu Jesudi Jesu muinga dodadu undege chuiage giti, kwian e u mo litangwa mananga gerudu kwian ulita ole: —Chui dereke lle boi chuia, chui ege ba ñage chie u aige mo dodade, agwa me no chie mo dodade undege chuiage, che undege chuia gadale dage. ");
INSERT INTO sabNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Kwian u mo litangwa mananga gerudu ene gire Jesu gerudu ama ole kaire kwian na ulita kle eni ole: —Ba ulita ta me no, ba kle gerule nganake ba kle age nganake. ¿Mineade ba kle tañachuge cha agedu me no cha muinga dodadu undege chuiage giti? Ba ulita bda molen, bda siechie, undege chuiage ba me bda chuge ngwadi jogeda sie ole, ba bda skajwennga dbe chi jai undege chuiage ba kle age chui na ulita lle boi chuiage kare. ");
INSERT INTO sabNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ba age ene bda alin undege chuiage kaire cha ñage age no muinga ai alin, cha ñage ama dodade undege chuiage. Muinga ai kwian israelita unsuialin kada Abraham oindalla, dolla Satanás nu muinga gaba sbali chura gdataboko giti gdapa, muinga chagedu oga dolla kote chui e ulitage. ¿Ba kle tañachuge ma no cha ama chuge ngwadi oga me ama dodade undege chuiage? Ba ta me no, ba me kle tañachuge no trate. ");
INSERT INTO sabNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jesu gerudu ene gire kwian ulita bai Jesu dollale amadi nga chiu ibule, kwian na nglea ulita gwage Jesudi nga suga noare kwiandi Jesu giti, kwian e ulita gerudu: —Jesu kle age tanre noare Chube kirallaske che gwa giti. ");
INSERT INTO sabNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","19","Jesu geru ñachugu kwian alin mostaza chudea giti, Jesu gerudu: —Cha geru na ñachuge ba ulitage, geru ai giti sugedale bage nege kwian bedreare kle mo ta gbe ulia Chube gerua gai jumale cha kle gerule giti, agwa bdagli kwian ngle be Chube gerua gai ulia be Chube gai mo Chugagwallale, e salengwli kle boi mostaza chudea giti kare. Kwian onbre joge mostaza chudea soli gbaite skie deage, mostaza chudea e tige joge kweri nanga tanre molen gire bdada ngle ñage ugara gbe gli e nanga jegwale ulita toingwa. Ene kaire kwian bai Chube gerua gai ulia kwian e Chube gerua trage kwian na ole, ene geru e chke uñale kwian na tanrege, gire bdagli kwian tanre be Chube gerua gai ulia be Chube gai mo Chugagwallale salengwli mostaza chudea soli tige joge kweri nanga tanre molen kare. ");
INSERT INTO sabNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","21","Jesu geru na ñachugu kwian alin, Jesu gerudu: —Cha geru ñachuge bage ai kare: Muinga kle pan dodade levadura ole, ama levadura sidri tugenga harina tanreske gire bedre bedre harina uda be sie kweri dodadale panle. E kare ene kwian me Chube uñe be Chube gerua keruchuge, kwian be geru e gai ulia, geru e be tige ama tale, kaire Chube gerua giti bedre bedre kwian na tanre be Chube gai ulia mo Chugagwallale levadura sidri harina gbe sie kweri kare —Jesu gerudu ene ulita kwian ole Chube gerua giti. ");
INSERT INTO sabNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesu chagedu dare una Jerusalén ngnagu, una ulita baini kaire Jesu chagedu ngwadi ama kwian una emu ulita tku tangle Chube geruage. ");
INSERT INTO sabNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Una e gdaitege kwian gdaite geru kadu Jesuge: —Kwian chugagwalla, ¿kwian tanre be tien gitiru ji chugege joge toi Chube ngwadi o me? Jesu gerudu kwian ulita ole: ");
INSERT INTO sabNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Kwian tanre ta jogekalin toi Chube ngwadi agwa kwian me mo ta blite ulia Chube ole joge siere age me noge, kwian ene me ñage joge toi Chube ngwadi. Malen cha gerule ba ulita ole, ba ta jogekalin toi Chube ngwadi ba mo ta gbadale ulia kiraske Chube ole age no ama takalin kare. Joge Chube ngwadi salengwli joge tangle ugaka ka ulege kare, ");
INSERT INTO sabNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ba me mo kira gbe joge tangle blike ugaka ka ulege, u mauña ugaka jege gire ba ulita be chege goga ba be ta jogekalin gwa ba be ugaka dagenga ba be gerule u mauña ole: “Cha chugagwalla, ugaka degenga cha alin.” Chugagwalla be gerule ba ulita ole: “Cha me ñage ugaka degenga ba alin, me uñale chage ba chema.” ");
INSERT INTO sabNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Gire ba ulita be gerule chugagwalla ole: “Ba cha ulita uñe, cha ulita blidu ule ba ole, cha unallaske ba cha ulita tku tangle geruge.” ");
INSERT INTO sabNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Chugagwalla be gerule: “Cha gerule ba ulita ole, ¿ba chema? Cha me ba uñe. Ugaka kle jegaba, joga siere chage, ba ulita kwian agenga me no tanre.” ");
INSERT INTO sabNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","29","U mauña be gerule ene gire ba ulita be chege goga olire tanre ji chuge boi tirare ngeru. Ba be chege goga, ba be ñage gwage kwian be kle Chube ngwadidi, ba be ten Abrahamdi Isaacdi Jacobdi kaire ba be ten kwian Chube gerua ketanga ulitadi, agwa ba be chege siere kwian e ulitage. Kaire ba be gwage kwian chieba chui chie ngwangedi kwian chieba chui joge ngwangedi, ba be gwage kwian chieba nga na ulitagedi, kwian ulita be kle toiba dba Chube ngwadi ule Chube ole nga suga no ole. ");
INSERT INTO sabNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Jesu gerudu ene kwian ole gire gerudu dare: —Cha gerule ba ulita ole, nege nga dba ai giti kwian gweale kle suge moge ma kweri dabage, Chube ngwadi kwian ene be ma soli Chube gwa giti. Agwa nege nga dba ai giti kwian gweale suge moge ma soli daba nage, Chube ngwadi kwian ene be ma kweri Chube gwa giti. ");
INSERT INTO sabNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Jesu kle gerule ene gire kwian fariseo chku mneite gerule Jesu ole, ama ulita gerudu: —Joga siere aini, ba me manade dare, chugagwalla rey Herodes ta ba gwakalinda. ");
INSERT INTO sabNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Gire Jesu gerudu kwian fariseo e ulita ole: —Jogani geru dbe kwian daba anblitanga ege, ba geru kete amage ai kare cha alin: “Nege, suialin cha be kle lle boi aini, cha be dolla jwen siere kwiange, cha be kwian oga tanre dodade, gire mongikege lle cha alin boadale be bidege. ");
INSERT INTO sabNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Agwa nege, suialin, mongi cha chagedale dare una Jerusalén ngnagu. Ama me ñage cha gweda aini, kwian Chube gerua ketanga me ñage mo gwangeda sugekare una Jerusalénge.” Ba geru e kete Herodege cha alin. ");
INSERT INTO sabNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jesu geru kagu ene kwian fariseo ole Herodes alin, gire Jesu chagedu lle boi dare una Jerusalén ngnagu, jonkare Jesu kledu tañachuge kwian ulita una Jerusalénmu giti Jesu gerudu: —Kwian ulita una Jerusalénmu, ba enusulian unsuialin kwian ngle Chube gerua ketanga guda, kaire nege Chube kle mo gerua dbanga ngle kage ba ulita alin, ba kle ama skie ke giti kle ama gweda, ba kle age salengwli ba enusulian oña unsuialin agedu kare. Cha ta olire tanre ba ulita giti, cha noare ba ulita ole, agwa ba ulita me no cha ole. Cha tadukalin tanre age no ba ulita alin ba ulita manade no salengwli koi kle soli lite ole manade mo jiga gwaru kare, agwa ba ulita me tadukalin cha age ene ba alin, ba me cha gau ulia. ");
INSERT INTO sabNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Malen cha ba chuge ngwadi jogengale sugekare chage. Cha gerule ba ulita ole, nege gwangerugu ba mi gwage chadi dare aini, agwa chui be chke gire ba ulita be gwage chadi chieni nakwaite, chui ege be suge ba ulitage Chube cha kagu ba ulita alin gire ba ulita be gerule cha giti: “Ama noare, Chube ama kagu nga dba ai giti kwian ulita alin” —Jesu gerudu ene ulita kwian una Jerusalénmu giti. ");
INSERT INTO sabNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Chui gbaite undege chuiage Jesu jo blire kwian fariseo chugagwalla gdaite ullage, kwian fariseo na tanre kledu eni, kaire kwian tanre daba tkanga tangle Moisés chadalla giti kledu u ege, kwian e ulita takalin Jesu gbe jiske age gweale giti undege chuiage malen ama ulita kle eni gwage Jesudi. ");
INSERT INTO sabNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Kwian onbre gdaite oga jingme lute ole kledu u e amañage malen kwian kledu kote kwian oga giti Jesu ole. ");
INSERT INTO sabNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesu geru kadu kwian fariseo ulitage kaire kwian daba tkanga tangle Moisés chadalla giti ulitage: —¿Noare kwian oga dodade undege chuiage o me? ¿Moisés chadalla gerule mine e giti? ");
INSERT INTO sabNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Kwian fariseo ulita kaire kwian ulita daba tkanga tangle Moisés chadalla giti chegu kamne me su jainnga. Jesu kwian oga gau kodi, Jesu kwian oga dodadu gire kwian oga jo chke noni, Jesu ama kaguni gudegu. ");
INSERT INTO sabNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Gire Jesu gerudu kwian fariseo ole kwian daba tkanga tangle Moisés chadalla giti ole ulita: —Ale gerule kirolla banu bda banu joge sklienga blebitaske undege chuiage, ¿ba be lle boi chuia manade gire ba be bda jwen keda kirolla jwen keda, o ba be ama jwen keda blike chui e amañage undege chuiage? Ba mi manade dale, ba be tai dage kirollage bdage gire blike ba be ama jwen siere ama kle skliebanga ngwadige. ");
INSERT INTO sabNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Jesu gerudu ene gire kwian fariseo kaire kwian daba tkanga tangle Moisés chadalla giti chegu kamne me ñadu jainnga Jesu kalen. ");
INSERT INTO sabNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jesu gwagedu kwian ulita kadabadi blire kwian fariseo chugagwalla ullage, kwian ulita kledu toingwa no jinade toigda dba blingwage, malen Jesu geru ñachugu kwian e ulita alin: ");
INSERT INTO sabNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Kwian gweale ba kade mo jwen chuia ollade, ba joge chke chui edi gire ba me toingwa no jinade toigda, kwian na ma kweri ma no bage be chke, ama toidale dba toingwa e giti. ");
INSERT INTO sabNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ba nu toingwa no gaba gire kwian nu ba kadaba ñage gerule ba ole: “Ba toingwa ai chuge ngwadi daba na alin, ama ma kweri bage be toi dba aini.” Kwian gerule ene ba ole gire badi nga be chie ibule joge toi toigda bdagli nate dba giti. ");
INSERT INTO sabNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kwian ba kade chui ollade, ba joge chke gire ba toidale dba toigda bdagli giti, ene kwian ba kadu gwage badi gire gerule ba ole: “Cha skatemanalla, bai toi dba toigda no ai ngerudba giti.” Kwian gerule ene ba ole gire nga be suga noare badi ba be toigda no kweri gai kwian kle ba ole blingwage ulita gwa giti. ");
INSERT INTO sabNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","E kare ene kwian baige suge kweri mo tale kaire mo gbe no kweri kwian na gwa giti, Chube gwage kwian ene me kweri, ama ngwale ama soli. Agwa kwian baige suge soli mo tale kaire mo gbe kwian na chudaboangale, Chube gwage kwian ene kweri. ");
INSERT INTO sabNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jesu gerudu ene kwian kadaba ulita ole gire kwian nu Jesu kadaba ama ole Jesu gerudu: —Ba bligda dodade chui ollade gire ba me mo skatemanalla alin kade, me mo daballa alin kade, me mo bitallagda alin kade, me kwian lle molen tanre kle toi kodi ba ullage alin kade blire ba ole, kwian e ulita lle molen tanre ñage ba kade ama ullage blire ba ama kadu blire kare, agwa kwian me lle molen me ñage age ene naskuni ba alin. ");
INSERT INTO sabNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ma no ba bligda dodade chui ollade ba kwian ai kare kade: Ba kwian me lle molen kade, ba kwian me chage trate kade, ba kwian me ten kade blire ba ole. ");
INSERT INTO sabNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ba kwian ene kade gire nga be suga no badi, kwian ene blire ba ole me ñage ba kade ba ama ullu kare, agwa bdagli Chube be kwian no ulita gbeni gwade chuia, chui ege nga be suga noare badi, ba agedu no kwian alin nga dba ai giti ñanale Chube be age no ba alin nga ngaña giti —Jesu gerudu ene kwian nu Jesu kadaba ole. ");
INSERT INTO sabNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Kwian tanre kle toiba dba blingwage Jesu keruchugu gerule ene gire kwian gdaite gerudu Jesuge: —Chui be chke gire nga be suga no no kwiandi kwian bai joge toi Chube ngwadi nga ngaña giti, nga ngaña giti Chube ngwadi kwian e be kle ule Chube ole kwian e be nga ollade nga suga no ole. ");
INSERT INTO sabNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Kwian gerudu ene ama kledu tañachuge mau giti ama agali be kle ule Chube ole be nga ollade nga ngaña giti. Chku uñale Jesuge kwian gdaite e kle tañachuge ene mau giti, Jesu gerudu ama ole: —Cha geru ñachuge bage ai kare: Kwian gdaite u mauña chui gbu nga ollade, ama kwian ngle kadu blire ule, ama bligda jinangu ngle kwian kadaba ulita alin. ");
INSERT INTO sabNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Chui ollade chku, bligda klebi biale, gire u mauña kwian lle boanga ama alin gdaite kagu geru jige kwian kadaba ulitage bligda kle bialebi gutadale. Kwian lle boanga jo, ama gerudu kwian kadaba ulita ole: “Nege ba chie nga ollade, bligda kle biale gutadale.” ");
INSERT INTO sabNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Kwian lle boanga jo chke geru kete kwian kadaba ulitage gire kwian kadaba ulita gdaite gdaite gerudu: “Ba chugagwalla chui gbu nga ollade, ama cha kadu, cha gerudu ama ole ima cha ñage joge chui ollade ama ole, agwa gire nege cha me ñage joge.” Kwian ngeru gerudu: “Cha dbi gigu, cha jogedale tienda dbidi malen cha me ñage joge nga ollade ule. Gerule ba chugagwalla ole cha me ñage joge blire ama ole, cha lle na boadale mo alin.” ");
INSERT INTO sabNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Na gerudu: “Cha chbi gigu gdataboko lle boagda, cha jogedale ama chuge ama lle boi no o me lle boi no, malen cha me ñage joge blire ule.” ");
INSERT INTO sabNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Na gerudu: “Cha mo jun nege sugeti, cha me muinga jigakalin gballa malen cha me ñage joge.” ");
INSERT INTO sabNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Kwian kadaba ulita gdaite gdaite gerudu salengwli ene kwian lle boanga ole, lle boanga joni jo chkeni chugagwalla ngwadi geru tragu ulita chugagwalla ole, gire chugagwalla skochiu tanre kwian kadaba ulita ole, chugagwalla gerudu kwian lle boanga ole nabitaite: “Joga jrite jon kaire kaire unaske kwian na jinade, ba kwian me lle molen kade, ba kwian me chage trate kade, ba kwian me ten kade. Joga kwian ene kade nga ollade cha ole, ba chieni kwian ene dbe.” ");
INSERT INTO sabNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Lle boanga jo, ama agedu ulita chugagwalla ama kagu kare, gire kwian lle boanga chkuni gerudu chugagwalla ole: “Cha chugagwalla, cha chkuni kwian ngle dbe, agwa nga bebi kwian na alin, bligda kle kwian na alin kaire.” ");
INSERT INTO sabNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Chugagwalla gerudu kwian lle boanga ole: “Joga jrite blike kwian me kle toi unaske nate, ba jrite jon kaire kaire ba ten ngwange ba kwian kade, ba gerule kwian e ulita ole ama chiedale blire nga ollade cha ole, kwian e ulita chke gire u be chke ete kwian ole. ");
INSERT INTO sabNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Cha gerule ba ole, cha kwian ngeru kadu blire, kwian e ulita ni gdaite be cha bligdalla gute nga ollade cha ole.” Jesu geru ñachugu ene ulita kwian fariseo ullage Jesu blidu ngwadi gire Jesu jo dare una Jerusalén ngnagu. ");
INSERT INTO sabNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Jesu kle chage jonkare, kwian tanre jo ule Jesu ole, Jesu gwagedu kwiandi chage mo nate gire Jesu gerudu ama ulita ole: ");
INSERT INTO sabNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Kwian bai ta chagekalin ulia cha ole age cha takalin kare diali, kwian ene mo ta dbadale ma no cha ole mo bitallanu ulita olege, kwian mo ta dbadale ma no cha ole mo ñenua olege mo chebia olege mo muiralla olege mo kirogwalla olege mo daballa olege mo ibotea olege kaire mau olege, kwian bai mo ta dbe no ene cha ole ñage chage ulia cha ole age cha takalin kare diali. Agwa kwian bai me tañachuge cha giti ngeru tañachuge kwian na ulita giti ngeru, kwian ene me kle mo ta gbe age cha takalin kare ama me ñage chage cha ole. ");
INSERT INTO sabNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Kwian bai ta chagekalin ulia cha ole me ñage tañachuge mau giti ngeru, ama mo ta gbadale cha alin ole age ulita cha takalin kare, kwian ene boi daga ngwale cha giti me tallade, kwian ene kle mo ta gbe age cha takalin kare ama ñage chage cha ole. ");
INSERT INTO sabNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ale gerule ba gweale ta u kweri jeike ngaña dodakalin, ngeru ba be tañachuge: “¿Cha be lle ulita u dodagda gige kwabaige?” Ngeru ba be igi banu ten ulita, ene chke uñale bage igi be ñage lle ulita gigagda o me. ");
INSERT INTO sabNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ba me age ene ngeru ba lle gige blike u dodagda igi mi ñage ba ole, u mi joge ka giti ba ole, kwian ulita be gwage badi, kwian be gide badi, ");
INSERT INTO sabNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","kwian be gerule me no badi: “Kwian e u dodadu me ñadu u gbe ka giti, ama ta kirogwa kare me tañachugu kwian juma kare, me ñadu u dodade ulita, ama koladu ngwale udi.” ");
INSERT INTO sabNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ale gerule kwian chugagwalla giti, chugagwalla nga nage be chie dole chugagwalla nga gdaite ole, ngeru chugagwalla gdaite be guardia donga ten nate ulita biale, guardia donga ngle diez mil, donga nga nage ma ngle veinte mil, ¿donga diez mil ñage kirachke donga veinte mildi? ");
INSERT INTO sabNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Suge chugagwalla gdaitege donga diez mil me ñage kirachke veinte mildi, chugagwalla na donga ma ngle veinte mil molen kle bate gire chugagwalla donga ma bedre diez mil ole be kwian mneite gai be kage geru jige chugagwalla na kwian donga veinte mil olege: “Che me kira bate, che chegedale ta no ole modi.” ");
INSERT INTO sabNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Guardia donga ulita bebi kira bate gire chugagwalla gdaite kle tañachuge ngeru be boi bdagli giti, ene kaire ba ulita bai ta chagekalin cha ole, ngeru ba tañachugadale no chage cha ole giti ulia ba be ñage mo ta gbe kiraske chage diali cha ole me mo tallade, ba ta me kle biale ba llea ulita chuge ngwadi chage cha ole gdale, ene ba me ñage chage cha ole. ");
INSERT INTO sabNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Jesu gerudu dare: —Cho mana noare, agwa cho joge skeke gire cho ene me ñage jwliteni naskuni bale gutadale. ");
INSERT INTO sabNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Cho sketigeda me no, ¿lledale kwian cho ene oge? Kwian me cho ene oge dale, kwian cho ene mlienga, cho ene ngwale. Ene kaire kwian bai me kle mo ta gbe tañachuge ngeru cha giti age cha takalin kare, Chube gwa giti kwian ene salengwli cho sketigeda me no cho ngwale kare. ’Kwian bai ta Chube gerua uñakalin kwian ene cha kerua gbadale gdadi —Jesu gerudubi ene kwian ulita kle chage ama nate ole. ");
INSERT INTO sabNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Bitaite kwian ulita igi ganga chugagwalla emperador nga Romamu alin kaire kwian na tanre agenga me no jo chke mo lite Jesu kle ngwadi Jesu keruchuge gerule Chube giti. ");
INSERT INTO sabNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Kwian fariseo mneite kaire kwian daba tkanga tangle Moisés chadalla giti mneite kledu gwage kwian ulita kledu mo lite Jesu oledi gire ama gerudu modige Jesudi kwian ulita kle mo litaba giti: —Onbre e kle age me no, ama kle mo ta dbe no kwian agenga me no ole kle kwian agenga me no ulita gai ngwange no, diali ama kle blire ule kwian agenga me no ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Kwian fariseo mneite alin kaire daba tkanga tangle Moisés chadalla giti mneite alin Jesu geru ai ñachugu, Jesu gerudu: ");
INSERT INTO sabNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Ba ulita kle aini gweale bda oveja ngle molen cien, gire bda oveja gdaite jogengwa ba ngeru, ¿ba be age mine? ¿Ba be ta jogenga oveja gdaite jogebanga giti be oveja gdaite chuge ngwadi jogenga? Ba oveja mauña mi ta jogenga ovejage, ba be oveja na dare noventa y nueve jige litaba ole ngmadi nga oveja manangwage gire ba be joge oveja gdaite jogebanga jinade nate, ba be oveja jinade tanre gire oveja skwen bage. ");
INSERT INTO sabNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Oveja skwen bage ba oveja gai ba oveja mlie kwligage nga suga no ole oveja giti. ");
INSERT INTO sabNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Gire ba chieni oveja dbe gudegu, ba chkeni gude gire ba mo skatemanalla ulita kade kaire ba kwian na ulita kle toi kodi ba ullage kade, gire ba gerule kwian e ulita ole: “Bai nga ollade cha ole oveja ai giti, nga suga noare chadi oveja giti, oveja jongwa cha ngeru, cha oveja jinadu, oveja skwendu chage. ¡Ale oveja ollade nga suga no ole!” ");
INSERT INTO sabNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nga dba ai giti ba mo ta dbe ene oveja jogebanga ole, e kare ene nga suga no nga ngaña giti kwian gdaitre alin joge siere age me noge mo ta blite Chube ole giti, nga ma suga no kweri nga ngaña giti kwian e gdaite giti kwian na ulita noventa y nueve gitige, kwian noventa y nueve ulita tañachuge ama ta no trate Chube gwa giti, kwian e ulitage agali suge ama kle age no ulita malen ama me mo ta blitadale Chube ole —Jesu geru ñachugu ene oveja gdaite jogebanga giti. ");
INSERT INTO sabNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Jesu geru na ñachugu kwian fariseo ulita alin kaire kwian daba tkanga tangle Moisés chadalla giti ulita alin: —Muinga gdaite igi molen gugataboko, igi e gugaite jogenga muinga ngeru, ¿muinga be age mine igi e nate? Muinga be jichra gwadege, jichra giti muinga be igi jinade nate trate gwa ugdo jegwale, muinga be nga lite ulita gwa tangle, bdagli ene igi be skwen nate muingage. ");
INSERT INTO sabNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Igi be skwen nate muingage gire muinga be skatemanalla ulita kade, kaire be kwian na ulita kle toi kodi ama ullage kade, be gerule kwian ulita ole: “Nga suga noare chadi. Bai nga ollade cha ole igi giti, igi jongwa cha ngeru, cha igi jinadu nate, igi skwendu chage. ¡Ale igi ollade nga suga no ole!” Muinga be gerule ene kwian ole be kwian kade nga ollade nga suga no ole. ");
INSERT INTO sabNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Cha gerule ba ole, ene kaire nga ma suga no lle boanga Chube alin nga ngaña giti tanredi kwian gdaitre alin ole joge siere age me noge mo ta blite Chube ole giti. ");
INSERT INTO sabNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Kaire Jesu geru na ñachugu: —Kwian onbre gdaite kirogwa onbre molen gdaboke. ");
INSERT INTO sabNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Kirogwa daba nate gerudu ñenua ole: “Tata, bdagli ba be chude girabate bda girabate dbi girabate ulita cha ole cha daballa ole, ba e bonga chanu kete chage nege, cha me ta manakalin.” Kirogwa daba nate gerudu ene ñenua ole gire ñenua chude girabatu bda girabatu dbi girabatu ulita kirolla boke ole, ñenua lle ngle ketu kirolla bokege. ");
INSERT INTO sabNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Jo chuia kaire kirogwa daba nate chude, bda, dbi maunu ulita chbadu, gire ama igi gau ngle lle e ulita ñanale. Ama jo toi bate nga nage, jo chke nga batege gire ama me mo ta gbu chage trate, ama igi kagunga ulita lle tanre ngwale giti. ");
INSERT INTO sabNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ama igi kagunga ngwale ulita gire bli kweri chiu nga ege kwian ulita alin, kwian onbre e chegu me igi molen ama bli chugu tanre. ");
INSERT INTO sabNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ama ole igi me, ama chagedu kole malen ama jo lle boi jinade boadale kwian onbre gdaite lle molen kle toi nga ege ngwadi, onbre e kle toi nga ege lle boale ketu amage boadale, ama chunchi manadu onbre e alin. ");
INSERT INTO sabNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ama kle chunchi ulle gligbadi, ama bli ole tanre ama takalin chunchi bligdalla gute tike, agwa ama alin ni gligba keta gutadale. ");
INSERT INTO sabNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ama jogeda dare bli ole gire ama tachku mo ñenuage, ama gerudu mo tale: “Llani cha ñenua jwiage bligda tanre no gutadale, kwian lle boanga cha ñenua alin ulita kle blire no, cha ama kirolla aini cha jogeda bli ole. ");
INSERT INTO sabNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Cha be jogeni cha ñenua ngwadi, cha be gerule cha ñenua ole: ‘Tata, cha agedu me no Chube dollale ba dollale kaire, ");
INSERT INTO sabNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","chage suge cha me agedu no ba ole malen cha takalin ba me cha gaini mo kirollale, agwa ba cha gai kwian lle boanga ba alin.’ ” ");
INSERT INTO sabNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ama gerudu ene mo tale gire ama mo gbu biale ama joni jonkare ama ñenua nate, ama jo gwagudeguda bate jonkare ñenua gwagedu mo kirolladi chieni gwagudeguda, ñenua ta sugedu tai dage tanre mo kirollage, ñenua jritedu ama ngwange, ñenua ama gau ngwange nga suga no ole, ñenua ko bliu kirolladi, ñenua kirolla sobadu. ");
INSERT INTO sabNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Gire kirolla gerudu ñenua ole: “Tata, cha agedu me no Chube dollale ba dollale, chage suge cha me agedu no ba ole malen cha takalin ba me cha gaini mo kirollale, ba cha gai kwian lle boanga kare ba alin.” Ñenua gerudu kirolla ole: “Ba cha kirolla chanu, ba me tallade cha ngeru, ba cha kirolla, cha no ba ole.” ");
INSERT INTO sabNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ñenua gerudu ene mo kirolla ole gire gerudu kwian lle boanga ulita ole: “Joga ñometragda no jwen blike cha kirolla alin, ba ama ngama tke no, lle tkale koge jwen tke ama koge, kaire zapato tke ama serage. ");
INSERT INTO sabNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","24","Ba joge chbi ma blodi jwen, ba chbi gweda. Ale blire ule cha kirolla ole, ale nga dbe suga no cha kirolla ole. Cha kirolla ai jongwa chage, cha tañachugu ama jokeda. Me dale ene. Ama kle gwade, nege ama chkuni aini chadige. ¡Ale cha kirolla chuia ollade ule!” Kwian ulita lle boanga tale nga chegu suga no, ama ulita chui olladu ule kirogwa ñenua ole kirolla chkuni giti. ");
INSERT INTO sabNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Kirolla daba ngeru kledu lle boi deage, ama chiuni gudegu chku kodi uge gire ama ologe sugedu kwian kle lle dagenga kwian ulita kle nga ollade skwen gdate. ");
INSERT INTO sabNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Kirolla e lle boanga gdaite kadu mo gitigu gire geru kadu amage: “¿Kle boi mine gwa?” ");
INSERT INTO sabNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Kwian lle boanga gerudu: “Ba daballa chkuni noni gudeni ba ñenuadi, malen ba ñenua kle ba daballa chuia ollade, ba ñenua chbi ma blodi gwanguda ba daballa alin gutadale ule.” ");
INSERT INTO sabNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Daballa ngeruge geru e chku uñale gire ama skochiu tanre mo tale, ama me mo ta gbu joge gwa daballa soli kle ngwadi, ama chegu bate sugekare uge. Bdagli ñenua jo agali kirolla juma jwen gudegu, ñenua gerudu kirolla juma ole: “Bai cha ole gwa ba daballa chkuni chuia ollade.” ");
INSERT INTO sabNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Kirolla juma gerudu ñenua ole: “Cha mi joge gwa ba ole ba kirolla soli chuia ollade. Sbali chura ngle cha kledu lle boi no ba alin, cha ba gau dage no diali, gire mau tale ni ba bda soli gdaite ketu gwaleda chui olladale cha alin blire ule cha skatemanalla ole. ");
INSERT INTO sabNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ba kirolla soli me no ba ole me ba gau dage, ama ba igia junnga ulita ama ba igia kagunga ngwale muinga tanre me nodi, nege ama chkeni gire blike ama alin ba chbi blodi gwanguda gutale ama alin.” ");
INSERT INTO sabNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Kirolla juma ka bo ene ñenua ole gire ñenua gerudu kirolla ole: “Cha kirolla, ba me ka boi ene cha ole, ba diali kle cha ole, lle chanu ulita banu. ");
INSERT INTO sabNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Agwa ba daballa jogebanga ama chkuni, noare che ama chuia ollade ta no ole ama ole ule, che nga dbale suga no ama giti, ama jongwa chege, che tañachugu ama jokeda che mi gwageni amadi, agwa nege ama chkuni aini chedige, ama kle gwade malen noare che ba daballa chuia ollade, che mo ta gbale nga suga no chui ollade ba daballa giti” —Jesu geru ñachugu ene ulita kwian fariseo alin kaire kwian daba tkanga tangle Moisés chadalla giti alin. ");
INSERT INTO sabNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesu geru ñachugu kwian geru jwannga amage gdataboko giti gdaboke alin, Jesu gerudu: —Kwian onbre gdaite igi molen tanre kaire lle molen tanre. Ama kwian igi mananga gdaite gbu igi amanu kaire lle ulita amanu manade. Kwian na gwagedu igi manangadi me kle igi manade no gire kwian e jo geru kete igi mauñage, kwian gerudu: “Kwian igi mananga ba alin me kle igi manade no, ama kle ba igia kagenga tanre ngwale.” ");
INSERT INTO sabNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Kwian igi mauñage chku uñale kwian igi mananga me kle lle boi no gire kwian igi mauña kwian igi mananga kadu geru trage. Kwian igi mananga chku kwian igi mauñadige, gire igi mauña gerudu igi mananga ole: “Cha ole gerudre ba me kle mo ta gbe cha igia manade no, cha takalin ba lle bo ulita chadalla kete chage, nege gwangerugu ba mi lle boi cha alin dare, nege cha ba mlienga.” ");
INSERT INTO sabNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Kwian igi mauña gerudu ene gire kwian igi mananga tañachugu mo tale: “¿Nege gwangerugu cha be age mine? Cha chugagwalla mi cha gbe lle boi dare, cha me ñage lle na boi mo alin toigda, cha kira me chude ngama gbe, kaire nga chie ibule chadi igi kade kwian nage mo alin toigda. ¿Cha be age mine?” ");
INSERT INTO sabNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Kwian igi mananga kle tañachuge ene gire ama tachku ama be age mine, ama tañachugu mo tale: “Nege cha be age no kwian na alin, ene kwian e ulita be cha gai ngwange no ama ullage cha mi kle lle boi dare igi mauña alin gire.” ");
INSERT INTO sabNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Igi mananga tañachugu ene mo tale gire ama daba na jiskenga igi mauñage kadu gdaite gdaite geru trage ole, kwian jiskenga ngeru chku igi manangadi, igi mananga geru kadu daba jiskenga ege: “¿Ba jiske mangire cha chugagwallage?” ");
INSERT INTO sabNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Kwian jaindunga: “Cha jiske kin bajrilella ngle cien.” Kwian igi mananga gerudu: “Chada degaba ba jiske giti kle ai gerule ba jiske kin bajrilella ngle cien, nege ba chada dege ba jiske kin bajrilella ma bedre cincuenta alin allabi.” ");
INSERT INTO sabNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Kwian jiskenga na chku igi manangadi, igi mananga geru kadu amage: “¿Ba jiske mangire cha chugagwallage?” Kwian jaindunga: “Cha jiske trigo sakolla ngle cien.” Kwian igi mananga gerudu: “Chada degaba ba jiske giti kle ai gerule ba jiske trigo sakolla ngle cien, nege ba chada dege ba jiske trigo sakolla ma bedre ochenta alin allabi.” ");
INSERT INTO sabNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Igi mauñage chku uñale igi mananga tachku blike age no kwian jiskenga ole gire igi mauña gerudu no igi mananga ole: “Ba chuga no no, ba tañachugu blike age mo alin, e no.” Jesu geru ñachugu ene gire gerudu dare kwian geru jwannga ole: —Kwian me Chube uñe tachke age ma blike daba na alin ene daba na ñage ama chudaboi naskuni, ama kle mo ta gbe blike age ta giti daba na alin, kwian Chube uñe me age ene. ");
INSERT INTO sabNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Cha gerule ba ole ba bai Chube gai ulia, ba igi molen ba kwian me lle molen chudaboadale igi e giti, ene kwian e be ba gai mo skatemanallale. Lle ulita banu be bidege, ba mi chege lle molen gire ba tachkedale chui be chke gire Chube be ba gai ngwange no nga ngaña giti be age no ba alin ba daba me lle molen chudaboi nga dba ai giti ñanale. ");
INSERT INTO sabNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Bai mo ta gbe ulia lle bedre boi no kaire be mo ta gbe ulia lle ngle boi no, bai me mo ta gbe ulia lle bedre boi no kaire mi mo ta gbe ulia lle ngle boi no. ");
INSERT INTO sabNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nga dba ai giti ba me mo ta gbe ulia ba igia manade no, me age no igi ole, gire Chube mi lle noare nga ngaña giti kete bage. ");
INSERT INTO sabNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ba me ta gbe ulia igi daba nanu manade no, ¿chema be ta igi ketakalin bage ba alin age ole ba takalin kare? Ba me mo ta gbe ulia igi daba nanu manade no, ene kaire ba mi mo ta gbe igi maunu manade no. ");
INSERT INTO sabNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Kwian lle boanga gdaite me ñage lle boi no chugagwalla boke alin. Lle boanga mo ta gbe lle boi no chugagwalla gdaite alin ama me ñage lle boi no chugagwalla na alin kaire. Lle boanga lle boi chugagwalla boke alin gire ama be mo ta dbe no chugagwalla gdaitre alin ole, chugagwalla na ole ama mi mo ta dbe no dale, ama be jainchke chugagwalla edi. Ene kaire ba mo ta gbadale tañachuge lle boi no Chube alin me tañachuge diali igi gai giti lle lite ole ngle mau alin giti, ma no ba mo ta gbe tañachuge Chube giti alin allabi toi ama takalin kare. Ba mo ta dbe no igi alin ole me ñage mo ta dbe no Chube ole, ma no tañachuge Chube alin giti, me tañachuge lle boke giti ule. ");
INSERT INTO sabNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Jesu gerudu ene gire kwian fariseo ulita kle mo ta gbe no igi ole Jesu keruchugu gerule ene igi giti, gire fariseo ulita Jesu gidadu geru Jesu gerudu giti. ");
INSERT INTO sabNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesu gerudu kwian fariseo ole: —Ba ulita takalin kwian na gwage ba kle age nodi, gire ba takalin kwian gerule ba giti ba noare ba kle chage trate. Ba age kwian gwa giti ene kwian tañachuge ba kle age trate ulia Chube takalin kare, agwa me uñale kwiange ba ta mine, Chube gwage ba tadi, uñale Chubege ba ta mine. Ba age no kwian tañachuge kare agwa Chube gwage ba kwian me no —Jesu gerudu ene kwian fariseo ole. ");
INSERT INTO sabNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Jesu gerudu dare: —Unsuialin Moisés Chube gerua degu, geru e chegu degaba kwian ulita alin, ene chku uñale ba enusulian oña ulitage ama chagedale mine Chube gwa giti. Kaire kwian tanre Chube gerua ketanga Chube gerua tragu ba enusulian oña ulita ole. Geru e chku Juan-Bautista chuiage tangle gire Juan-Bautista chuiage gwangerugu Chube gerua jagere tragle kwian ulita ole, geru e gerule kwian bai Chube gerua cha giti gai ulia kaire Chube gai mo Chugagwallale, kwian ene be toi diali chui tangle Chube ole nga ngaña giti. Kwian tanre kle geru e keruchuge nga suga no ole, kwian e ulita kle mo ta gbe ulia Chube gai mo Chugagwallale. ");
INSERT INTO sabNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","E me gerule Moisés nu Chube gerua degaba unsuialin geru e me no ba kle toi nege alin, geru e ulita no ba ulita alin. Nga ngaña giti kaire nga dba ai giti, nga e ulita be bidege, agwa Moisés nu Chube gerua degaba mi bidege dale ni geru gbaite be bidege, geru e ulita be chege diali chui tangle kwian ulita alin. ");
INSERT INTO sabNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Cha gerule ba ulita ole, kwian onbre bai kaire mo muingalla chuge ngwadi gire mo jwen muinga na ole, onbre e kle age me no Chube gwa giti, Chube gwage e salengwli onbre e kle mo chuge ke giti muinga e ole kare. Kaire ñengula nu mo muingalla chugaba ngwadi, muinga e ole onbre na mo jwen, onbre e kle age me no Chube gwa giti, Chube gwage e salengwli onbre e kle mo chuge ke giti muinga e ole kare. ");
INSERT INTO sabNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jesu gerudu ene kwian fariseo ole gire Jesu geru ñachugu ama ulita alin, Jesu gerudu: —Kwian onbre gdaite igi molen tanre lle molen tanre, diali chui gdale ama kle toi no kle bligda tanre no gute kle mo ngama tke ñometra noareske. ");
INSERT INTO sabNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Kwian na kada Lázaro, ama me lle molen, ama oga, ama uda tuge nate jingme ole, diali ama kle toiba dba onbre lle molen ullage goga ugakage. ");
INSERT INTO sabNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Lázaro bli ole kle bligda manade ugakage, kwian lle molen bligdalla bita jwatenga dba Lázaro bligda bita ene jwankalin nate mo alin gutadale, ama ta unchkekalin ngle kwian lle molen bligdalladi, agwa bligda mauña ni bligda sidri kete Lázaroge. Kaire to ngle chke amadige, to ama uda tugebada denga. ");
INSERT INTO sabNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Jo chuia kaire gire Lázaro jokeda, lle boanga Chube alin nga ngaña giti ngle Lázaro oña du Abraham oña kle ngwadi nga noarege kwian no oña kle toi ngwadige. Kwian lle molen tanre kaire jokeda, ama jaba tkere dbige, ");
INSERT INTO sabNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ama oña dule kwian me no oña kle joge ngwadige, nga me noge jitaleske. Kwian lle molen oña kle boi daga ngwale nga ege gire ama gwagedu bate Lázaro oñadi, Lázaro oña kle ule Abraham oña ole nga noarege. ");
INSERT INTO sabNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Kwian lle molen oña ngautu Abraham oñadi: “Cha enusulian unsuialin Abraham, tai dage chage, ba Lázaro kage chi dbe cha alin sidri jadale, cha kle boi daga ngwale tanre aini jitaske.” ");
INSERT INTO sabNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abraham gerudu: “Cha gerule ba ole nege, ¿ba me tachke ba kledu toi nga dba giti ba toidu no ulita agwa Lázaro me toidu no? Nege Lázaro kle toi no aini, ba me dale, nege ba kle boi daga ngwale. ");
INSERT INTO sabNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Kaire kwian aini me ñage joge ba ngwadi, kwian llani me ñage chke aini cha ngwadi, kegde kweri kle cha ngwange ba ngwange, cha me ñage Lázaro kage ba ngwadi.” ");
INSERT INTO sabNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Gire kwian lle molen oña gerudu Abraham ole: “Cha takalin ba Lázaro kage cha bitalla ngwadi gerule cha daballa gdatiga ole chegu llani, ");
INSERT INTO sabNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ba Lázaro kage geru kete cha daballa gdatiga cheguge ama ulita mo ta blitadale Chube ole, ama ulita mo ta gbadale Chube gai ulia, ene ama me chie aini boi nga daga ngwalege.” ");
INSERT INTO sabNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham oña gerudu: “Cha me Lázaro kage Chube gerua trage ba daballa ole, unsuialin Moisés Chube gerua degu kaire kwian ngle Chube gerua ketanga Chube gerua degu, ba daballa chada e ulita molen, Chube gerua degaba chada ege ba daballa mo ta gbadale gai dage.” ");
INSERT INTO sabNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Gire kwian lle molen oña gerudu: “Ulia ama Chube gerua degaba molen, agwa ama me kle geru e gai ulia, ma no kwian jogebada chkeni gwade jogeni nga dba giti geru jige amage gerule no ama ole ama Chube gerua gadale ulia, kwian jogebada chkebani gwade gerule ene ama ole gire ama be mo ta blite ulia Chube ole.” ");
INSERT INTO sabNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraham oña gerudu: “Moisés nu Chube gerua degaba, kwian Chube gerua ketanga nu Chube gerua degaba, ba daballa me kle geru e gai ulia, kaire agwe ene ama mi kwian jogebada chieni gwade gerua gai ulia.” Abraham oña gerudu ene ulita kwian lle molen oña ole —Jesu geru ñachugu ene ulita kwian alin. ");
INSERT INTO sabNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesu gerudu kwian geru jwannga gdataboko giti gdaboke ole: —Diali lle me no be kle nga dba ai giti, kwian be ta agekalin me no. Kwian bai age me no daba na ole daba gbe age me no, kwian ene be boi daga ngwale be ji chuge tanre daba gbe age me no gdale. ");
INSERT INTO sabNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ma no kwian daba gbanga age me no ene alin joge mliaba ble jereske ke kweri lugaba mo siroge, ene kwian e be jogekeda mi chege dare daba nu cha gerua gaba ulia me sbali gbe ta blite age me no joge siere cha geruage. ");
INSERT INTO sabNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ba ulita mo ta gbale chage ta giti me daba na gbe age me no. ’Cha gerule ba ole, daba Chubenu age gweale me no ba dollale ba ka boadale ama ole ta no giti ama kle age giti, ama ba keruchuge mo ta blite ama gerule ba ole: “Cha me age dare me no ba dollale”, gire ama agedu me no ba talla mliadalenga. ");
INSERT INTO sabNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Chui gbaite ama age me no bitaguke ba dollale gire bitaguke ama mo ta blite chke gerule ba ole: “Cha me age dare me no ba dollale”, bitaguke ama agedu me no ba dollale ba talla mlienga. ");
INSERT INTO sabNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jesu gerudu ene gire kwian geru jwannga Jesuge ulita gerudu Jesu ole: —Cha Chugagwalla, cha takalin ba cha ta gbe ma ngle no Chube gerua gai ulia. ");
INSERT INTO sabNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jesu gerudu: —Ba mo ta gbe sidri alin Chube gerua gai ulia gire bedre bedre Chube be ba ta gbe ama gerua gai ma ngle, e salengwli mostaza chudea soli tkakle, kle tige kle joge kweri kare. Ba mo ta gbe Chube gerua gai ulia ene, gire ba ñage gerule gli kweri ole: “Chieda keda, joga toi bleske”, ba gerule ene gli ole gire gli age ba gerudu kare. ");
INSERT INTO sabNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Jesu gerudu dare kwian geru jwannga ole: —Ale gerule ba gweale kwian lle boanga molen, ba ama kage lle boi deage ama kle nga bate kle bda manade, bigwa chieni gudegu chke gwa gire ¿ba be gerule ama ole: “Bai toi dba aini blire cha ole”? ");
INSERT INTO sabNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ba mi age ene dale, ba be gerule ama ole: “Ba bligda dodadale cha alin cha gute, ba cha ulle ngeru gire bigwa ba ñage blire.” ");
INSERT INTO sabNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Kaire ba mi gerule ama ole ama bligda dodadu giti: “Noare ba agedu cha alin no, ba bli jinadu no cha alin.” Ba mi gerule ene dale lle boanga ole, ba ama kagu lle boi, ama me lle bo mo ta giti ba alin. ");
INSERT INTO sabNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ene kaire ba ulita lle boanga Chube alin, Chube ba kagu kare lle boi gire ba gerudale ai kare mau giti: “Mo ta giti cha me lle boanga Chube alin, Chube kle cha kage gire cha lle e alin boi allabi, ni mo ta giti agali cha kle mo ta gbe lle boi Chube alin.” Ba ulita tachkedale ene —Jesu gerudubi ene ulita kwian geru jwannga gdataboko giti gdaboke ole. ");
INSERT INTO sabNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesu kle chage dare una Jerusalén ngnagu Jesu jo tangle nga kada Samariage kaire nga kada Galileage. ");
INSERT INTO sabNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Jesu jo chke una solige gire kwian gdataboko oga kwara tuge jingmea kada lepra ole tendu Jesu ngwange, ama ulita chegu ngaute bate Jesuge, ");
INSERT INTO sabNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ama ulita mo keru gbu kweri ngaute Jesuge, ama gerudu: —Jesu kwian tkanga tangle geruge, ba tai dage cha ulitage. ");
INSERT INTO sabNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesu gwagedu ama ulitadige gire Jesu gerudu: —Joga kwian gerunga Chube ole daba alin ngwadi, ba ulita mo oga kaite amage. Kwian oga kwara tuge jingmea ole ulita jo chage jonkare gire blike ama ulita chegu trate, jingme ulita jongwa. ");
INSERT INTO sabNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Sugedu ama ulitage ama ulita jo chkeni noni, ama ulita sugedu moge ama jegwale kle no, gire gdaitre alin allabi mo ta gbu jogeni Jesu nate gerule no Jesu ole jo chkeni giti, jonke kwian gdaite e mo keru gbu kweri gerule no Chube giti, ama gerudu: —Chube noare, Chube mo kiralla giti cha dodadu, nga suga noare chadi Chube agedu giti kweri cha alin. ");
INSERT INTO sabNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Kwian gdaite e kwian nga Samariamu, ama chiuni Jesu gitigu, ama jo chke dba jongnagwa giti Jesudi ñedu kaboge dbidi Jesu gwangeru dba gire gerudu Jesu ole: —Noare ba agedu no cha alin, ba cha dodadu, nga suga no chadi e giti. ");
INSERT INTO sabNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesu gerudu kwian gdaite e ole: —¿Kwian gdataboko chegu trate siere jingmege gdaitre alin chkuni aini? ¿Gdainka kle baini? ");
INSERT INTO sabNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ba kwian nga Samariamu alin allabi chiuni naskuni gerule no no Chube ba dodadu giti, ");
INSERT INTO sabNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","cha gerule ba ole, chkede gdate, jogani, ba mo ta gbu Chube gai ulia malen Chube ba dodadu ba jo chkeni noni. ");
INSERT INTO sabNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Chui gbaite kwian fariseo tanre geru kadu Jesuge: —¿Ngaminegire chui be chke gire Chube be mo gbe kwian ulita Chugagwalla kweri nga dba ai giti? Jesu jaindunga: —Chube chuia be chke ni be uñale kwiange, edi che me ten che ten lledi kare. ");
INSERT INTO sabNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kwian me ñage gwage aini gire gerule: “Ama kle aini”, kwian me ñage gwage eni gire gerule: “Ama kle eni.” Cha gerule ba ole, chui e chkubi, Chube kle nege ba ulitaske. ");
INSERT INTO sabNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Jesu gerudu ene kwian fariseo ole gire Jesu gerudu kwian geru jwannga amage gdataboko giti gdaboke ole: —Cha chiu nga dba ai giti kwian kare, nege ba ulita kle chage cha ole, agwa cha mi kle ule ba ole diali nga dba ai giti. Chui be chie gire ba be takalin gwageni chadi nga dba ai giti kwian ulita Chugagwallale, agwa ba mi ñage gwage chadi chui ege, cha mi kle aini, ba cha chuia manadale dare. ");
INSERT INTO sabNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Kwian na tanre be gerule ba ole cha giti: “Ama chkuni, ama kle aini”, na be gerule: “Ama chkuni, ama kle eni.” Kwian gerule ene ba ole ama kle sole, ba me kwian ene kerua gbe gdadi, ba me chage ama nate cha jinade nate. ");
INSERT INTO sabNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Cha chieni chuiage me kwian bedre alin be gwage chadi chieni, agwa kwian ulita nga ulitage be gwage trate chadi cha be chieni chuiage salengwli kwian ulita kle gwage nga ko chrachiengadi nga ngaña giti kare. ");
INSERT INTO sabNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ngeru nga dba ai giti cha be boi tanre daga ngwale, kwian tanre kle toi chui aige me cha gai ulia, ama be mo tke cha dollale, be cha gweda. ");
INSERT INTO sabNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Gire cha be chieni chuiage, e suiale kwian tanre be kle toi age salengwli kwian unsuialin kledu toi age Noé suiale kare. ");
INSERT INTO sabNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Kwian ulita toidu Noé suiale me kledu Noé kerua gbe gdadi me kledu tañachuge chui be boi tirare giti. Kwian e kledu blire, kwian kledu mo jwen, kaire kwian kledu mo jian gbe ule, kwian ulita kledu tañachuge toi age diali me no alin allabi, kaire kwian ulita kledu toi nga suga no ole age me no ulita giti diali, me kledu tañachuge chui be boi tirare giti. Agwa chui boi tirare chuia chku gire Noé jo chiga du kweri tadi ule mo bitalla ulita batre ole Chube gerudu Noé ole kare, gire noi kweri chiu, noi boidu tanre, kwian kle toi ulita nga dba ai giti e suiale jokeda chi kote, agwa Noé alin allabi tiun gitiru mo bitalla mneite ole. ");
INSERT INTO sabNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Kaire boidu unsuialin Lot toidu suiale una Sodomage. Chui ege kwian kledu blire, kwian kledu lle chbade, kwian kledu lle gige, kwian kledu chude skie, kwian kledu u dodade. ");
INSERT INTO sabNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Kwian ulita kledu toi kledu lle e kare alin boi allabi, kaire kwian ulita kledu toi nga suga no ole ama kledu age me no giti diali, me kledu tañachuge chui be boi giti gire chui chku boidale tirare. Lot jo siere una Sodomage gire Chube jita kagu nga ngaña giti una Sodomage alin, jita chiu ule lle jribabita gwade kare ole, chku nga dba giti kwianske ulita, kwian ulita una Sodomage kugedu ulita, Lot alin tiun gitiru. ");
INSERT INTO sabNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ene kaire cha be chieni chuiage kwian tanre be kle toi age kwian unsuialin suia toi age Noé chuiage tangle kare, kwian tanre be kle toi age kwian unsuialin suia toi age Lot chuiage tangle kare, kwian ene ulita mi kle tañachuge be boi giti, be kle toi age me no tanre, gire chui ege sugeti ngwale cha be chieni, kwian ene ulita be chege boi daga ngwale tanre diali, mi ñage tien gitiru boi tirarege. ");
INSERT INTO sabNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Cha be chieni chuiage kwian bai kaire skate goga tangle ama me jogedaleni chiga u amanuge lle gweale amanu gwa tangle lite ole dbadale, ama lle ulita amanu chugadale ngwadi gwa ama jogedale kige blike kole. Kaire agwe kwian bai kaire skate lle boi deage me jogedaleni gudegu, ama jogedale kige blike gwangerugu me joge naskuni. ");
INSERT INTO sabNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Tachkede Lot muirallage ama boidu mine unsuialin, ama tadu jogekalinni naskuni una Sodomage. ");
INSERT INTO sabNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Kwian bai tañachuge mau giti alin allabi toi no nga dba ai giti mo manade no me tañachuge age Chube takalin kare, bdagli kwian ene be jogengwa sugekare Chubege be chege boi tanre daga ngwale diali chui tangle. Agwa kwian bai mo ta gbe chage cha ole mo chuge ngwadi boi daga ngwale nga dba ai giti cha gerua gdale, ama me mo tallade, ama tañachuge ma no age Chube takalin kare, bdagli kwian ene be toi no diali chui tangle nga ngaña giti cha ole cha Ñenua Chube ole. ");
INSERT INTO sabNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Cha gerule ba ole, cha be chieni chuiage ngajrege kwian boke be skate gbe ankwa gaitre alin giti, gdaite dbabe Chube kle ngwadi gdaite jigabeda ji chuge. ");
INSERT INTO sabNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Muinga boke be skate ke uge ule gwa, muinga gdaite dbabe Chube kle ngwadi muinga gdaite jigabeda ji chuge. ");
INSERT INTO sabNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Kwian onbre boke be skate deage lle boi, onbre gdaite dbabe Chube kle ngwadi onbre gdaite jigabeda ji chuge. ");
INSERT INTO sabNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Kwian geru jwannga Jesuge Jesu gerua keruchugu gire geru kadu Jesuge: —Cha Chugagwalla, ba kle gerule giti, ¿e be boi ene baini? Jesu jaindunga: —Cha gerule ba ole, juntenge uñale lle jogebakeda chegale kle baini, ne ngwadi junten ngle kle mo lite dba, ene kaire kwian cha gerua gaba uliage be chke uñale trate e ulita be kle boi gire. ");
INSERT INTO sabNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesu kwian geru jwannga amage tku tangle ama ulita gerudale diali Chube ole, ama ulita me skwatigedale chudaboi kade Chubege. Jesu geru ñachugu kwian geru jwannga amage ulita alin ene suge trate geru jwannga ulitage Jesu kle ama tke tangle giti, ");
INSERT INTO sabNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Jesu gerudu: —Una gdaitege kwian gdaite gerunga daba giti kle toi, ama kwian me no, me kle mo ta dbe Chube gai dage, kaire ama me mo ta dbe no kwian na ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Kaire una e amañage muinga me chegu ñengulage kle toi, kwian gdaite kledu age tanre me no muinga e dollale gire muinga e chagedu bitangle gerule kwian gerunga daba giti ole mo jwannge giti: “Cha takalin ba cha chudaboi cha dollage, ba ji gbe ama alin ene ama me age cha dollale dare.” ");
INSERT INTO sabNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Sbali muinga chagedu diali gerule ene kwian gerunga daba giti ole, agwa kwian e me ta muinga chudaboakalin, bdagli kwian e tañachugu mo tale: “Cha me Chube gai dage ni cha no kwian ulita ole, ");
INSERT INTO sabNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","cha me ta muinga chudaboakalin, agwa ama kle chie kian gbe tanre chage aini, cha ama chudaboadale, cha be ama chudaboi, ene ama me chie dare aini cha jugeda kian gbe chage.” ");
INSERT INTO sabNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jesu geru ñachugu ene ulita kwian giti gire Jesu gerudu dare kwian geru jwannga ole: —Kwian gerunga daba giti kwian me no, ama me tadu muinga chudaboakalin ngeru, agwa ama skwatigu muinga keruchuge gerule tanre malen bdagli ama muinga chudabo. ");
INSERT INTO sabNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Kwian me no e ama muinga chudabo ene, Chube me kwian e kare, Chube no trate ulita, Chube ma no ulita ¿ba tañachuge Chube me ta ba chudaboakalin? Chube kwian gau mau alin, kwian ene mo ta gbadale gerule Chube ole chui gdale nga ju nga jere, Chube mi olo jege kwian ene kerua ngeru, agwa Chube be ama chudaboi be age no ama alin kwian kle kade kare. ");
INSERT INTO sabNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Kwian Chubenu gerule nga ju nga jere Chube ole, Chube me manade, ama kwian chudaboi blike. Cha chiu nga dba ai giti kwian kare, cha be chieni nabitaite nga dba ai giti gire ¿kwian ulita Chube gerua gaba be kle mo ta gbaba gerule Chube ole Chube gerua gai ulia chui ege? ");
INSERT INTO sabNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Kwian gweale kledu Jesu ngwadi, kwian e ulita kle tañachuge mo giti ama noare trate ulita kwian na ulita me ama kare no, Jesu geru ñachugu kwian ulita kle tañachuge ene alin, Jesu gerudu: ");
INSERT INTO sabNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Kwian boke jo chke u gerungwa Chube olege gerule Chube ole, kwian gdaite kwian fariseo, gdaite kwian igi ganga chugagwalla emperador nga Romamu alin. ");
INSERT INTO sabNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Kwian fariseo jagedunga gdate gerule Chube ole, ama gerudu ene: “Chube, nga suga noare chadi, noare cha me kwian na kare agenga me no, cha me skwe boanga daba ngeru, cha me mo chuganga ke giti muinga ole daba ngeru, ni cha kle age me no sidri kwian ai kle ule cha ole igi ganga chugagwalla emperador nga Romamu alin kle age kare. ");
INSERT INTO sabNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Diali cha bage bligdage chui boke semana gdaite gdaite tañachugagda ba alin ole. Lle boi ñanale cha igi gai, diali cha kle igi e sidri kete bage.” Kwian fariseo gerudu ene Chube ole. ");
INSERT INTO sabNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Kwian igi ganga kle gdate bate kwian fariseoge, amage sugedu ama kwian me no, ama chegu gwa tkaba dbigu me gwa gau ngaña, ama mo batu kudegdage ta olire ole, gerudu Chube ole: “Chube, ba ta dbe no cha ole tai dage chage, chage cha suge cha agenga me no.” Kwian igi ganga gerudu ene Chube ole. ");
INSERT INTO sabNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jesu gerudu dare: —Cha gerule ba ulita ole, Chube kwian igi ganga ta blitu, kwian igi ganga joni mo ullage Chube ole ta no giti, agwa kwian fariseo me dale. Kwian baige suge kweri mo tale kaire mo gbe no kweri kwian na gwa giti, Chube gwage kwian ene me kweri, ama ngwale ama soli. Agwa kwian baige suge soli mo tale kaire mo gbe daba na chudaboangale, Chube gwage kwian ene kweri. ");
INSERT INTO sabNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Kirogwa ñenua kirogwa chebia tanre chiu mo kirogwalla soli dbe Jesu kle ngwadi, kirogwa ñenua, chebia takalin Jesu ko gbe kirogwa soli e giti gerule Chube ole Chube age no kirogwa alin Chube kirogwa manade no. Kwian geru jwannga Jesuge ulita gwagedu kwian tanredi chie kirogwa dbe Jesuge gire ama ka bo kirogwa ñenua ole chebia ole: —¿Lledale ba kle chie kirogwa dbe Jesuge? ¡Joga, joga siere! Ba me chie kirogwa dbe Jesuge. ");
INSERT INTO sabNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Agwa Jesu gerudu kirogwa ñenua ole chebia ole: —Bai aini kirogwa dbe chage. Gire Jesu gerudu kwian geru jwannga ole: —Me no ka boi kirogwa ñenua ole chebia ole, ba ama ulita chugene chie mo kirogwalla dbe chage. Kirogwa soli ta kle biale Chube gerua gai ulia blike, kirogwa talla ene kare Chube takalinge, kwian ulita bai kaire mo ta gbe ulia Chube ole kirogwa talla ene kare ole, kwian ene chege Chubenu, ama be toi diali chui tangle Chube ole. ");
INSERT INTO sabNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Cha gerule ulia ba ulita ole, kwian ulita bai kaire me mo ta gbe kirogwa talla kare Chube ole, kwian ene me ñage toi ule Chube ole, ama be chege sugekare Chubege —Jesu gerudu ene kwian geru jwannga ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Kwian israelita chugagwalla gdaite chku Jesudi geru gweale kade Jesuge, ama gerudu Jesu ole: —Ba kwian tkanga tangle noare geruge, cha takalin ba gerule cha ole ¿cha llema boadale nga dba ai giti gire ene cha ñage toi no diali chui tangle Chube ole nga ngaña giti? ");
INSERT INTO sabNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesu jaindunga kwian e kalen: —¿Mineade ba gerudu cha no? Ulia ni kwian gdaite no trate, Chube alin allabi no trate ulita. ");
INSERT INTO sabNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Bage uñale trate Chube nu geru gbaba kwian ulita alin kwian toidale mine Chube gwa giti, Moisés Chube gerua e degu unsuialin, ba chada e uñe trate, chada e gerule: “Ba onbre mo jwanba me mo chuge ke giti muinga na ole, ba muinga mo jwanba me mo chuge ke giti onbre na ole. Ba me daba na gweda. Ba me skwe boi daba ngeru. Ba me geru jinade ngwale daba na dollale. Ba mo ñenua mo chebia gai dage.” Moisés Chube gerua degu ene unsuialin kwian ulita alin, ba agedale ulita geru e kle degaba kare. ");
INSERT INTO sabNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Jesu gerudu ene onbre e ole gire onbre gerudu Jesu ole: —Cha kledubi soli gwangeabi cha jo juma gdate cha kle geru e gai dage age ulita geru e kle gbaba kare. ");
INSERT INTO sabNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jesu kwian keruchugu ene gire Jesu gerudu: —Noare ba kle age ene, agwa cha gerule ba ole, lle gdaite ba bebi age. Joga lle banu ulita chbade, igi ulita lle e ñanalla ba kete kwian me lle molenge. Ba age ene ulita gire ba chieni cha kle ngwadi ba mo ta gbe chage cha ole diali geru jwen chage. Gire ene ba be kle biale joge toi diali chui tangle Chube ole nga ngaña giti, Chube be age no ba alin ba agedu no ñanale. ");
INSERT INTO sabNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Onbre Jesu keruchugu gerule ene, gire ama chegu ta olire tanre, onbre e lle molen tanre, malen ama me tadu lle ulita chbadakalin Jesu gerudu kare ama ole. ");
INSERT INTO sabNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesu gwagedu onbre lle molen tanredi ta olire ole gire Jesu gerudu kwian geru jwannga ulita ole: —Ulia mnoare kwian lle molen tanre alin Chube gerua gai ulia mo ta gbe age ulita Chube takalin kare. Agwa kwian me age ene kwian me ñage toi diali chui tangle Chube ole nga ngaña giti. ");
INSERT INTO sabNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Uñale bage bda kweri kada camello me ñage joge tangle agu kwebege, camello kweriare, ene kaire kwian lle molen tanre alin mnoare Chube gerua gai mo ta gbe age Chube takalin kare. Kwian ene kle mo ta dbe no no mo llea tanre ulita ole malen mnoare ama alin mo ta gbe mo llea chuge ngwadi Chube gerua gai ulia mo alin age Chube takalin kare, mnoare kwian ene alin mo ta dbe ma no Chube ole ama mo ta dbe no mo llea olege. ");
INSERT INTO sabNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Kwian geru jwannga Jesu gerua keruchugu gire geru kadu Jesuge: —E ene ulia mnoare age Chube takalin kare ba kle gerule kare, gire ¿chema ñage age ulita Chube takalin kare, ene toi no diali chui tangle Chube ole nga ngaña giti? ");
INSERT INTO sabNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesu gerudu: —Kwian agali gballa me ñage age ulita Chube takalin kare me ñage age mau alin agali toi diali chui tangle Chube ole. Agwa Chube alin allabi ñage kwian kira gbe age ulita Chube takalin kare ñage kwian gbe toi diali chui tangle ama ole. Chube alin allabi ñage age ulita, lle ulita me mno ama alin boadale. ");
INSERT INTO sabNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Gire Pedro gerudu Jesu ole: —Cha ulita geru jwannga bage kle chage ba ole diali geru jwen bage, cha ulita mo llea ulita nga dba ai giti chugu ngwadi gire cha ulita mo ta gbu chage diali ba ole baini kaire ba kle joge ngwadi, cha ulita agedu ulita ba gerudu kare onbre lle molen tanre ole. ");
INSERT INTO sabNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesu gerudu kwian geru jwannga ulita ole: —Cha gerule ulia ba ulita ole, kwian ulita bai kaire mo ta dbe ma no Chube ole kwian kle mo ta dbe no mo bitalla ulita olege mo llea ulita olege, kwian ene ta kle biale mo llea chuge ngwadi mo bitalla chuge ngwadi tañachuge ngeru Chube giti age ulita Chube takalin kare. Kwian u chuge ngwadi, kwian mo ñenua mo chebia chuge ngwadi, kwian mo daballa chuge ngwadi, kwian mo kirogwalla chuge ngwadi, kaire kwian mo ta gbe me mo jwen muinga ole, kwian bai mo ta gbe lle gweale o bitalla gweale chuge ngwadi ene Chube giti tañachuge ngeru Chube giti age Chube takalin kare, ");
INSERT INTO sabNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","kwian enege Chube be lle ma no ma ngle kwian e nu lle chugaba ngwadige kete amage nga dba ai giti, kaire bdagli kwian ene be toi no diali chui tangle Chube ole nga ngaña giti —Jesu gerudu ene kwian geru jwannga ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesu kwian geru jwannga amage gdataboko giti gdaboke kadu sugekare kwian ngleage gerule ama ole Jesu be boi giti ulita, Jesu gerudu: —Nege che be joge una Jerusalénge, Chube cha kagu nga dba ai giti kwian kare, una Jerusalénge cha be boi ulita kwian Chube gerua ketanga nu chada degaba unsuialin gerule kare. ");
INSERT INTO sabNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Cha ketabe kwian me israelitage gwaleda, kwian e be age me no tanre cha ole, be cha gbe gidagda, be ka boi cha ole me no, be jolo tke chadi, ");
INSERT INTO sabNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","be cha bate tanre obere giska giti, be age ene ulita dagale cha ole gire bdagli ama be cha gweda. Cha gwabeda agwa chui mongikege cha be chkeni gwadeni. ");
INSERT INTO sabNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Kwian geru jwannga ulita Jesu keruchugu gerule ene Jesu be boi giti una Jerusalénge, geru e me sugedu gbaite amage, geru chegu skwlenre amage, me uñale Jesu kle llema geruade ama ole, ama tañachugu me mi boi ene ulia Jesu gerudu kare. ");
INSERT INTO sabNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesu kledu chage una Jerusalén ngnagu ule kwian geru jwannga amage ulita ole, gire Jesu jo chke kodi una Jericóge, kwian gdaite gwagwa me kle toiba dba jonke igi kade kwiange. ");
INSERT INTO sabNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Kwian gwagwa me ologe sugedu kwian nglea kle chage amage kodi tangle, gire ama geru kadu kwian nage: —¿Mineade kwian nglea kle chage? ¿Kle boi mine? ");
INSERT INTO sabNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Jaindrenga kwian gwagwa me kalen: —Jesu una Nazaremu kle chage tangle aini. ");
INSERT INTO sabNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Kwian gwagwa me kwian na keruchugu Jesu kle joge tangle kodi amage gire ama ngautu Jesuge: —Jesu, ba kwian chugagwalla kweri unsuialin kada David oindalla, ba tai dage chage. ");
INSERT INTO sabNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Kwian kle chage jonkare Jesu ngeru ama kwian gwagwa me keruchugu ngaute Jesuge, gire kwian ka bo jabale kwian gwagwa me ole ama ka chitedale, kwian ka bo ene ama ole ama me talladu ama me ka chitedu, ama mo ta gbu ngaute gwangerugu ma ngle: —Ba kwian chugagwalla kweri unsuialin David oindalla, ba tai dage chage. ");
INSERT INTO sabNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesu kwian gwagwa me keruchugu gire Jesu me chagedu dare, Jesu chegu jagenga gdate jonke Jesu gerudu kwian na ole chie kwian gwagwa me dbe Jesudige. Kwian gwagwa me dbachku Jesudi gire Jesu geru kadu amage: ");
INSERT INTO sabNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Ba takalin cha llema boi ba alin ba chudaboagda? Kwian gwagwa me jaindunga Jesu kalen: —Cha ba gai kweri, cha takalin ba cha gwagwa dodade ba cha gbe ten. ");
INSERT INTO sabNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesu gerudu ama ole: —Nege ba be gwagwa molen, ba mo ta gbu ulia cha ole malen cha ba gwagwa dodade ulita, nege ba jo chkeni noni. ");
INSERT INTO sabNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Jesu gerudu ene gire sugetibi allabi kwian gwagwa me ñadu ten no trate, ama gwagwa jo chkeni ulita, gire ama chagedu Jesu nate ta noare ole gerule noare Chube giti. Kwian ulita gwagedu amadi ama gwagwa molen ñage ten no trate, gire kwian e ulita gerudu noare Chube giti. ");
INSERT INTO sabNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesu jo chke una Jericóge, jo una Jericóske tangle. ");
INSERT INTO sabNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Una ege kwian gdaite igi molen tanre kada Zaqueo kle toi. Kwian ulita igi ganga chugagwalla emperador nga Romamu alin Zaqueo kwian ene ulita igi ganga chugagwalla. ");
INSERT INTO sabNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Zaqueo ta gwagekalin noare Jesudi Jesu miamne, agwa ama me ñadu gwage Jesudi, kwian tanre kledu ama gwangnaru, Zaqueo kwian soli, ama me tigedu ngaña. ");
INSERT INTO sabNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ama ta gwagekalin noare Jesudi mo gwagwa giti malen ama jo jrite ngeruda Jesu ngwange, Zaqueo jo ngaña glige kada sicómoroge Jesu manade ngwange. Zaqueo kledu ngaña glige kodi Jesu joge tangle ngwadi gire Jesu chiu, ");
INSERT INTO sabNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jesu jo chke Zaqueo glia gdoge gire Jesu gwagedu ngaña glige Zaqueodi, Jesu gerudu: —Zaqueo, bai dbigu blike, ale ba ullage, nege cha be joge chege ba ngwadi. ");
INSERT INTO sabNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zaqueo chiu dbigu blike chku dba, nga suga noare Zaqueodi Jesu giti, ama gerudu Jesu ole: —Jesu, nga suga noare chadi ba joge cha ole cha ullage nege. Gire Zaqueo jo Jesu dbe mo ullage. ");
INSERT INTO sabNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Kwian ulita gwagedu Jesudi joge Zaqueo ullage, gire kwian ulita gerudu modi tanre me no Jesudi Zaqueo giti, kwian gerudu: —Kwian agenga me no ullage Jesu kle joge chege. ");
INSERT INTO sabNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zaqueo jo chke gwa mo ullage Jesu ole gire gerudu Jesu ole: —Kwian chugagwalla, cha llea ulita bonga cha be kete kwian me lle molenge. Cha daba anblitu cha skwe bo daba ngeru, daba enege cha igi keteni naskuni na kwabaga giti dare. ");
INSERT INTO sabNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesu gerudu Zaqueo ole: —Ba kle gerule giti suge trate ba kle mo ta gbe joge siere ba kle age me no ulitage ba kle mo ta gbe no ulia Chube ole, malen nege Chube ba jun siere ji chugege ba agedu me no ulita gdale, nege ba mo ta gbu ulia Chube ole giti ba chege enusulian unsuialin Abraham oindalla ulia. ");
INSERT INTO sabNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Cha chiu nga dba ai giti kwian kare kwian agenga me no alin, kwian agenga me no kle jogebanga sugekare Chubege, cha chiu kwian ene chudaboi ta blite Chube ole, cha chiu ama jwen siere ji chugege age me no gdale. ");
INSERT INTO sabNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jesu gerudu ene Zaqueo ole kwian na tanre kledu Jesu keruchuge, chui ege Jesu kle kodi una Jerusalénge malen kwian e ulita kledu tañachuge mo tale chui be chke sugeti gire Jesu be mo gbe kwian ulita Chugagwallale kweri una Jerusalénge. Kwian kledu tañachuge ene, Jesu kwian talla uñu nate malen Jesu geru ñachugu kwian e ulita alin, ");
INSERT INTO sabNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Jesu gerudu: —Kwian onbre gdaite kweri kwian na gwage ama jo nga na batege, kwian chugagwalla kweri nga ege be ama gbe daba mo jwiamu chugagwallale gire onbre be chieni mo jwiage. ");
INSERT INTO sabNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Onbre e bebi joge, ngeru ama kwian lle boanga ama alin gdataboko kadu mo gitigu, ama igi kwangle ketu gaite gaite ulita kwian lle boanga gdatabokoge, ama gerudu kwian lle boanga e ulita ole: “Igi ai ole ba chege lle boi, cha be chieni gire igi chkeba mangire ma ngle.” Ama gerudu ene lle boanga ole gire jo nga na batege. ");
INSERT INTO sabNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Kwian tanre ama jwiage skochie amadi, kwian me takalin chugagwalla kweri nga na batege ama gbe daba ulita chugagwallale mo jwiage, malen kwian mneite kagle ama nate gerule chugagwalla kweri nga na batege ole: “Cha ulita me takalin ba ama gbe cha chugagwallale.” ");
INSERT INTO sabNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Agwa onbre e chegu diali kwian chugagwalla, gire ama joni mo jwiage. Ama chkuni gire ama kwian lle boanga ama alin ulita kadu bai kairege igi ketu lle boagda, ama ta igi uñakalin lle boanga gdaite gdaite igi gau kwamangire dare. ");
INSERT INTO sabNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Lle boanga gdaite chku ngeru amadige, lle boanga gerudu: “Cha chugagwalla, ba igi kwaite ketu chage, cha igi e gbu jrien, cha igi na gau kwataboko ba alin.” ");
INSERT INTO sabNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Chugagwalla gerudu ama ole: “Ba kwian lle boanga noare, igi bedre ole ba lle bo no ba igi na gau ngle, ba lle soli bo no, nege cha be lle kweri kete bage boadale, nege cha be ba gbe kwian una gdatabokomu chugagwallale.” ");
INSERT INTO sabNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Kwian lle boanga na chku amadige gerudu: “Cha chugagwalla, ba igi kwaite ketu chage, cha igi e gbu jrien, cha igi na gau kwatiga ba alin.” ");
INSERT INTO sabNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Chugagwalla gerudu ama ole: “Ba kwian lle boanga no, nege cha be ba gbe kwian una gdatigamu chugagwallale.” ");
INSERT INTO sabNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Kwian lle boanga na chku amadige gerudu: “Cha chugagwalla, ba igi kwaite ketu chage, cha igi ogo ñometra dregaske, ene igi me jogenga ba ngeru. ");
INSERT INTO sabNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Cha kwachiu badi, uñale chage cha me lle boi no trate ba igia ole ba be skochie, diali kwian na kle lle boi ba kle lle e gai mau alin, ba me kle lle boi agali ngwadi ñanalla ba kle geruade nate mau alin. Ba kwian ene malen cha tañachugu ma no cha me lle boi ba igia ole, cha ba igia ogo no ñometra dregaske, nege ba chkuni cha igi amaña keteni bage.” ");
INSERT INTO sabNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Chugagwalla gerudu lle boanga e ole: “Ba kwian lle boanga ta me no, ba me lle bo igi ole cha tadukalin kare. Uñale bage kwian me lle boi no cha alin cha skochie, kaire uñale bage baini cha me lle boi ngwadi cha kle lle ene geruade nate mo alin. ");
INSERT INTO sabNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","E ulita uñale bage, ¿mineade ba me su joge igi kete kwiange igi ogakle ngwadige?, ene igi ogangwage kwian lle boi igi ole cha chkeni cha igi ñanalla na gai ma giti dare.” ");
INSERT INTO sabNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Gire chugagwalla gerudu kwian na ole kwian lle boanga me no giti: “Cha igi ketu amage igi e jwennga ama ngeru, kete kwian lle boanga bai igi molen kwatabokoge.” ");
INSERT INTO sabNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Kwian gerudu chugagwalla ole: “Me no igi e kete kwian bai igi molen kwatabokoge, ma no igi kete kwian bai me igi molenge.” ");
INSERT INTO sabNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Chugagwalla gerudu: “Cha gerule ba ole, kwian baige lle sidri ketaba boadale gire kwian lle e boi no mo chugagwalla alin, kwian enege lle na tanre ketabe boadale mo chugagwalla alin. Baige lle sidri ketaba boadale gire kwian me lle e boi no mo chugagwalla alin, kwian ene ngeru lle sidri e ulita jwanbenga ama ngeru. ");
INSERT INTO sabNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Kaire cha gerule ba ole kwian cha dollale giti, ama me takalin cha chege ama chugagwallale, joga kwian ene jwen dbe aini gweda cha gwa giti.” Chugagwalla gerudu ene ulita lle boanga ama alin giti. Jesu geru ñachugu ene kwian ulita alin Zaqueo ullage ene suge kwiange ama ulita mo ta gbadale lle boi no Chube alin ama kle Jesu chuia manade ngwange gire. ");
INSERT INTO sabNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jesu geru ñachugu ene ulita kwian alin Zaqueo ullage, gire Jesu jo chage dare una Jerusalén ngnagu ule kwian geru jwannga amage gdataboko giti gdaboke ole. ");
INSERT INTO sabNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Jesu jo chke kodi kodi una soli bokege kada Betfagé kada Betania Ngwiskinro Jwichugalla gdoge dba. Ama ulita jo chke ne ngwadi, gire Jesu kwian geru jwannga amage gdaboke kagu mo ngeru, Jesu gerudu ama boke ole: ");
INSERT INTO sabNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—Joga gdabonate cha ngeru una soli kle ngeruge, ba be joge chke una soli ege burro soli be skwen bage ba ngwange lugabada glige, burro soli e giti ni kwian gdaite nu chageba giti, burro soli e ba skatrennga, ba chie burro dbe cháge. ");
INSERT INTO sabNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kwian gweale geru kade bage: “¿Lledale ba kle burro soli e skatrennga?”, ba gerule kwian e ole: “Cha Chugagwalla takalin burro soli aige.” ");
INSERT INTO sabNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Jesu gerudu ene ulita gire kwian geru jwannga gdaboke e jo, amage burro soli skwendu lugabada ulita Jesu gerudu kare. ");
INSERT INTO sabNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Kwian geru jwannga jo chke burro solidi, ama kle burro soli skatrennga dbadale gire burro soli mauña geru kadu amage: —¿Lledale ba kle burro soli e skatrennga? ");
INSERT INTO sabNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Kwian geru jwannga jaindunga: —Cha Chugagwalla takalin burro soli aige. ");
INSERT INTO sabNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Kwian geru jwannga boke chiu burro soli dbe Jesu kle ngwadi, ama mo ñometralla gitiru gbu burro soli trigda giti Jesu alin, gire kwian geru jwannga Jesu chudabo skwen burro soli giti, ");
INSERT INTO sabNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","burro soli giti Jesu jo chage una Jerusalén ngnagu. Kwian geru jwannga ulita kaire kwian na ulita kle chage ule Jesu ole jo Jesu ngeru mo ñometralla gitiru tren dba jonkare Jesu gai ngwange no mo Chugagwallale kweri. ");
INSERT INTO sabNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","38","Jesu jo chke Ngwiskinro Jwichugallage gwadbigu kodi una Jerusalénge, kwian tanre nu Jesu gerua gaba ulia kle chage Jesu ole, amadi ulita nga suga noare Jesu giti, ama ulita chagedu ngaute kweri Jesu giti: —Cha gerule no no Chube giti, ama kiralla giti ba lle daga ngwale no tanre dodadu cha ulita gwa giti. Noare Chube ba kagu nga dba ai giti cha ulita alin cha Chugagwallale kweri, ba giti kwian tanre be ta gbe no Chube ole, Chube noare Chube kweri, ama kle age no tanre cha ulita alin ba giti. ");
INSERT INTO sabNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Kwian fariseo gweale kle chage kwian nu Jesu gerua gaba ulia ngleaske, kwian fariseo kwian e ulita keruchugu ngaute tanre gire kwian fariseo gerudu Jesu ole: —Kwian tkanga tangle geruge, kwian ulita kle chage ba ole kle ngaute tanre, ka boi ama ole ene ama chege kamne. ");
INSERT INTO sabNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jesu gerudu kwian fariseo ole: —Cha gerule ba ole, kwian kle chage cha ole be ka chite ke be ngaute Chube giti no kwian kle ngaute kare. ");
INSERT INTO sabNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jesu gerudu ene kwian fariseo ole gire Jesu chagedu dare una Jerusalén ngnagu, Jesu jo chke kodi una Jerusalénge, Jesu gwagedu una Jerusaléndi ulita gire olidu kwian kle toi una Jerusalénge giti. ");
INSERT INTO sabNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Jesu gerudu ta olire ole: —Kwian una Jerusalénmu, Chube cha kagu nga dba ai giti ba ulita alin, cha giti Chube ta ba ta gbakalin no ama ole ene ba me chege sugekare amage dare, agwa ba me ta cha gakalin ulia malen me suge bage Chube ta agekalin no ba alin cha giti, e ulita kle ogabada kare bage. ");
INSERT INTO sabNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Chui me no be chke bage, kwian ba dollale be gere gbe ba unalladi tangle, kwian be mo lite badi tangle ulita, ene ba me ñage kige. ");
INSERT INTO sabNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Kwian ba dollale be ba ulita gweda ule ba olia ole, be u banu ulita skiendba ni u gbaite be chege. Chui ai ba chuia ba cha gadale ulia, ene kwian ba dollale me ñage ba gweda ulita, agwa ba me ta cha gakalin ulia, malen kwian ba dollale be chke chui gwealege be ba gweda ulita —Jesu gerudu ene ta olire ole. ");
INSERT INTO sabNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jesu jo chke una Jerusalénge, jo u gerungwa Chube olege, u ege kwian tanre skwendu Jesuge lle chbade, Jesu kwian e ulita kagu siere u ege, ");
INSERT INTO sabNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Jesu ka bo ama ulita ole: —Uñale ba ulitage Chube gerua degaba unsuialin gerule u ai giti, chada e gerule: “Chube gerudu: ‘U ai chanu chegedale u gerungwa cha ole alin allabi.’ ” Chube gerua kle degaba ene agwa ba ulita kle u ai gai mo alin skwe boangwale kwian nage, ba kle bda chbade dabage kwangleare ene ba igi gai ma ngle mo alin, Chube gwage e me no, e salengwli ba kle u Chubenu gai mo alin skwe boi daba na ngeru kare —Jesu gerudu ene kwian bda chbadanga ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jesu kwian lle chbadanga kagu siere u gerungwa Chube olege, gire chui gdale Jesu kwian tku tangle Chube giti u ege. Jesu kle kwian tke tangle ene gire kwian gerunga Chube ole daba alin chugagwalla kaire kwian daba tkanga tangle Moisés chadalla giti kaire kwian chugagwalla na, kwian e ulita mo ta gbu age gweale mo ten modi Jesu dollale ama ulita ñage age mine gire ñage Jesu gwangeda. ");
INSERT INTO sabNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Agwa kwian ene ulitage me chku boale age mine gire ama ulita ñage Jesu gai, kwian ngle kledu Jesu ole kle mo ta gbe Jesu gerua keruchuge ulita no, malen kwian Jesu dollale me ñadu Jesu gai agedale me no ama ole. ");
INSERT INTO sabNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Bitaite Jesu kledu gwa u gerungwa Chube olege kwian tanre tke tangle Chube gerua giti gire kwian gerunga Chube ole daba alin chugagwalla mneite kaire kwian daba tkanga tangle Moisés chadalla giti mneite chku Jesudi ule kwian israelita chugagwalla juma mneite ole, ");
INSERT INTO sabNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ama ulita geru kadu Jesuge: —Ba gerule cha ulita ole, ¿chema ba kagu age ba kle age kare? ¿Chema kiralla giti ba kle age ulita? ");
INSERT INTO sabNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","4","Jesu jaindunga: —Cha kaire agwe geru kade gbaite bage: ¿Chema Juan-Bautista kagu? ¿Chube Juan-Bautista kagu kwian ñe chiske o kwian Juan-Bautista kagu kwian ñe chiske? Cha gerule ba ole, ba jainnga cha kalen chema Juan-Bautista kagu, gire cha geru kete bage chema cha kagu age ulita cha kle age kare. ");
INSERT INTO sabNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Jesu gerudu ene gire kwian ulita bai geru kadu Jesuge chegu gerule tanre modi Jesu geru kadu amage giti: —¿Che jainnga mine Jesu kalen? Che gerule Chube Juan-Bautista kagu kwian ñe chiske gire Jesu be geru kade chege: “¿Gire mineade ba me Juan-Bautista gerua cha giti gau ulia?” ");
INSERT INTO sabNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Agwa che gerule kwian Juan-Bautista kagu gire kwian ulita be che keruchuge be che skie ke giti be che gweda gerule ene gdale, kwian ene ulita tañachuge ulia Chube Juan-Bautista kagu Chube gerua kete kwiange. ");
INSERT INTO sabNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Kwian geru tragu ene modige Juan-Bautista giti gire gerudu Jesu ole: —Cha ulitage me uñale chema Juan-Bautista kagu. ");
INSERT INTO sabNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Gire Jesu gerudu: —Kaire agwe cha mi gerule ba ole chema cha kagu age ulita cha kle age kare aini ba gwa giti. ");
INSERT INTO sabNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jesu gerudu ene kwian ole gire Jesu geru ñachugu ama ulita alin, Jesu gerudu: —Cha gerule ba ulita ole, kwian onbre gdaite uva ngama gbu, gire ama kwian gweale gau uva ngama manangale, ama uva ngama ulita jigu uva ngama mananga ulita kote gire ama jo toi nga batege sbali. ");
INSERT INTO sabNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Chui jo sbali gire chku uñale uva mauñage uvagba joge dabe suia chku, uva mauña kwian lle boanga ama alin gdaite kagu tienda uvagba bonga amanu kade mo alin kwian uva manangage. Kwian lle boanga e jo chke uva manangadige uvagba kade uva manangage, kwian uva mananga ulita daba e lle boanga uva mauña alin batu jabale agedu dagale daba e ole, uva mananga ulita daba kaguni kole uva mauña ngwadi, me su uvagba kete ni malen gbaite dabage. ");
INSERT INTO sabNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Boidu ene gire kwian uva mauña lle boanga na kagu uvagba kade. Lle boanga e jo chke kwian uva manangadige, gire kwian uva mananga daba e batu jabale agedu me no tanre daba dollale, uva mananga ulita daba kaguni kole lendegaba uva mauña ngwadi. ");
INSERT INTO sabNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Boidu ene nakwaite gire uva mauña kwian lle boanga na gdaite kagu uvagba kade uva manangage, kaire kwian uva mananga lle boanga e lendegu tanre kaguni uva mauña ngwadi, me uvagba ketu lle boanga ege. ");
INSERT INTO sabNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Bdagli uva mauña tañachugu mo tale: “¿Cha age mine? Cha be mo kirollanu kage, cha no no mo kirolla ole, cha tañachuge uva ngama mananga be cha kirolla gai dage gai ngwange no.” Uva mauña tañachugu ene malen ama mo kirolla kagu. ");
INSERT INTO sabNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Kwian uva mananga ulita gwagedu uva mauña kirolladi chie ama gitigu gire ama ulita gerudu modige: “Kwian chiu e uva mauña kirolla, bdagli ama be chege ama ñenua llea ulita dbia ulita mauñale. Ale ama gweda, ene lle ulita be chege chege, che be chege uva ngama ai ulita mauñale.” ");
INSERT INTO sabNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Kwian uva mananga ulita gerudu ene modige gire ama uva mauña kirolla gau du siere uva ngamage, gire ama ulita uva mauña kirolla guda. Jesu geru ñachugu ene ulita gire geru kadu kwiange: —¿Ba tañachuge mine geru e giti? Kwian uva mauñage be chke uñale boidu ulita ama kirolla ole giti gire ¿ama be age mine kwian uva mananga ulita ole? ");
INSERT INTO sabNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Cha gerule ulia ba ole, uva mauñage be chke uñale ama kirolla guleda gire ama be joge kwian uva mananga gweda ulita, ama be kwian na gbe uva ngama manade. Ene kaire Chube be age kwian ole kwian bai me ama Kirolla gai ulia. Kwian geru keruchugu ene gire kwian gerudu: —Cha takalin Chube me age ene che ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesu gwagedu kwian israelita chugagwalla ulitadi gire gerudu ama ole: —Ulia Chube be age ene kwian ulita ole bai me Chube Kirolla gai ulia. Chube gerua degaba unsuialin gerule Chube Kirolla be boi giti, chada e gerule: “Kwian u dodanga ke gbu gerere ke gbaite ama mliunga ama gerudu ke e me no dale ke e ngwale, agwa ke e ama mliunga, ke e ma no ke na ulitage. Kwian ke gbu ulita gerere nga bebi ke gbaite alin gere me kle kiraske, ke mliabanga gbere gerere gire u chegu kiraske.” Chube gerua degaba unsuialin gerule ene. ");
INSERT INTO sabNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Cha gerule ba ole ke e giti, kwian gweale joge chke dba ke e giti kwian lentige, ke e joge chke dba kwian giti kwian mnuña alin chege ke e kote. Cha salengwli ke mliabanga kare, kwian bai me cha gai ulia, bdagli kwian ene be boi tanre daga ngwale be chege ji chuge diali. ");
INSERT INTO sabNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Jesu gerudu ene ulita gire sugedu trate kwian gerunga Chube ole daba alin chugagwalla ulitage kaire kwian daba tkanga tangle Moisés chadalla giti ulitage Jesu kle gerule ama giti ama ulita salengwli uva ngama mananga me no ulita kare, e giti ama skochiu tanre Jesudi malen ama tadu Jesu gakalin blike tkale skage, agwa ama me ñadu, ama ulita kendunga kwian ngleadi, uñadu amage kwian tanre no Jesu ole, ama age me no Jesu ole kwian gwa giti kwian ulita be skochie amadi Jesu gdale. ");
INSERT INTO sabNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","21","Kwian gerunga Chube ole chugagwalla ulita kaire kwian daba tkanga tangle Moisés chadalla giti ulita mo ta gbu Jesu gbe jiske geru gweale giti, ama kwian mneite kagu tienda Jesudi Jesu kle ngwadi mo chuge Jesu ole Jesu gbe gerule gweale chugagwalla kweri dollale me no gire be ñage Jesu dbe gbe jiske chugagwallage. Kwian mneite e jo chke Jesudige gire Jesu gwale ama mo ta gbu gerule no Jesu ole agwa ama tale ama kle tañachuge me no Jesudi, ama ulita gerudu no Jesu ole: —Ba kwian tkanga tangle geruge, uñale chage ba diali kle gerule ulia trate, kaire ba kle kwian ulita tke tangle no trate geru ulia giti kwian toidale trate Chube takalin kare. Ba kle gerule kwian ulita ole trate salengwli, kaire ba gwa giti kwian ulita salengwli. ");
INSERT INTO sabNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ba kwian ene malen cha geru kade bage gbaite: Geru gbaba nga Romage kwian ulita igi ketadale kwian chugagwalla kweri emperador nga Romamuge, cha me kwian nga Romamu, cha kwian israelita cha takalin ba gerule cha ole, ¿no Chube gwa giti cha igi kete kwian chugagwalla kweri nga Romamuge ama kle kade chage kare o me? —kwian geru kadu ene Jesuge ta me no ole mo chugagda Jesu ole. ");
INSERT INTO sabNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesuge uñadu kwian e kle tañachuge me no amadige, kate kle gerule no Jesu ole, tadi me kle tañachuge no dale, ama ulita kle mo ta gbe Jesu anblite, Jesu gerudu ama ulita ole: ");
INSERT INTO sabNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Ba igi kete chage gaite gwagegda. Kwian igi ketu Jesuge gire Jesu geru kadu amage: —¿Chema oña kle gbaba igi ai giti? ¿Kaire chema kalla kle gbaba igi ai giti? Kwian jaindunga: —Kwian oña e chugagwalla kweri nga Romamu kada César, kaire ama kalla kle gbaba igi e giti. ");
INSERT INTO sabNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Kwian jaindunga ene gire Jesu gerudu: —Lle chugagwalla kweri Césarnu kaire keteni Césarge, lle Chubenu kaire keteni Chubege. ");
INSERT INTO sabNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Jesu gerudu ene gire kwian e chegu kamne, chegu tañachuge tanre Jesu gerudu ama ole giti, ama me ñadu Jesu gbe jiske geru kade giti Jesuge igi giti kwian ngle gwa giti ama tañachugu kare. ");
INSERT INTO sabNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Kwian saduceo mneite jo Jesu ngwadi geru trage Jesu ole, kwian saduceo kle gerule kwian jogebada jaba mi chkeni gwade chui bdaglige, ama tadu Jesu gbe gerule gweale Moisés nu Chube gerua degaba unsuialin dollale, ");
INSERT INTO sabNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","29","malen ama gerudu Jesu ole: —Ba kwian tkanga tangle geruge, Moisés Chube gerua degu unsuialin, chada e gerule kwian onbre jogeda me kirogwa molen mo muira giti, gire ama daballa na kle gwade mo jwandale ñanea oli ole, onbre kirogwa molen muinga e giti daballa jogebada alin, ene daballa jogebada olia chege gdaite muinga e giti. Nege cha gerule ba ole boidu cha bitallaske giti, aini cha bitallaske onbre gdaguke modi mo daballale kledu. Daballa kimule mo jun muinga ole agwa ama jokeda ni ama kirogwa molen gdaite mo muira giti. ");
INSERT INTO sabNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Gire daballa nate mo jun ñanea oli ole, agwa daballa e kaire jokeda ni ama kirogwa molen gdaite muinga e giti. ");
INSERT INTO sabNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Gire onbre jogebada daballa na ama nate mo jun muinga amaña ole, agwa ama boidu salengwli ama daballa ngeru gdaboke kare, ama gdamai ulita jokeda ni muinga ko toidu kirogwage. Boidu ene ulita onbre gdaguke e ulita ole, ama ulita gdaite gdaite mo jun muinga amaña ole, muinga e chegu ama gdaguke muirale, agwa ulita gdaguke jokeda gdaite gdaite, ni ama gdaite kirogwa molen muinga e giti. ");
INSERT INTO sabNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Bdagli muinga gballa e jokeda kaire. ");
INSERT INTO sabNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Cha gerule ba ole, ulia onbre e gdaguke ulita toidu gdaite gdaite muinga amaña ole mo muira kare, chui bdaglige kwian jaba ulita be chkeni gwade chuiage, ¿chui ege onbre bai be chege muinga e ñengulallale? ");
INSERT INTO sabNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesu jaindunga kwian saduceo kalen: —Nga dba ai giti kwian onbre kwian muire mo jwen. ");
INSERT INTO sabNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","36","Kwian bai Chube gau ulia kle toi nga dba ai giti gire, chui bdaglige Chube be kwian ene jaba gbe chkeni gwade toi diali chui tangle Chube ole nga ngaña giti, nga ege kwian e be toi Chube ole lle boanga Chube alin nga ngaña giti kle toi diali Chube ole kare, malen kwian e mi jogeda dare. Nga ngaña giti onbre be chege Chube kirollale muire be chege Chube jianle, gire onbrenu muirenu mi mo jwen ni be tañachuge mo jwen giti. ");
INSERT INTO sabNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Unsuialin Moisés agali Chube gerua degu, chada e giti chkedale uñale bage kwian jaba be chkeni gwade, chada e gerule Chube kerua sugedu Moisége gli soli kle kugeske, Chube gerudu Moisés ole Chube Abraham Chubea kaire Isaac Chubea kaire Jacob Chubea. Moisés Chube gerua e degu unsuialin, ");
INSERT INTO sabNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","e giti ñage suge trate ba ulitage chui bdaglige kwian ulita jogebada jaba be chkeni gwade. Abraham kaire Isaac kaire Jacob ama gdamai jogebada gire Chube gerudu Moisés ole ama gdamai giti Chube ama Chubea, Chube alin kwian e ulita kle gwade. Ulia Chube kwian gwade alin Chubea, ama me kwian jaba Chubea, malen chkedale uñale bage kwian jogebada kwian e oña kle chege gwade, kaire agwe chui bdalige kwian jaba ulita be chkeni gwadeni. ");
INSERT INTO sabNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Kwian gweale daba tkanga tangle Moisés chadalla giti kledu eni kaire Jesu keruchuge, ama ulita gerudu Jesu ole: —Ba gerudu ulia trate ulita. ");
INSERT INTO sabNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Chui ege gwangerugu kwian saduceo ulita me su geru kade dare Jesuge. ");
INSERT INTO sabNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesu geru kadu kwian ulitage: —¿Mineade kwian tanre kle gerule Cristo chugagwalla David unsuialin oindalla alin allabi? ");
INSERT INTO sabNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Unsuialin David agali chada degu Cristo giti, chada Salmos giti geru e gerule: “Chube gerudu cha Chugagwalla ole: ‘Toi dba cha ngena cha ko taingwli giti, ");
INSERT INTO sabNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","chui be chke gire cha be ba gbe ma kweri ba dolla ulitage, bdagli ba be kirachke ba dolla ulitadi gire ba be chege dolla ulita Chugagwalla kweri.’ ” ");
INSERT INTO sabNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","David chada degu ene unsuialin Cristo giti, chada e giti sugedale kwian ulitage Cristo me David oindalla alin allabi agwa kaire Cristo David Chugagwalla, David agali gerudu Cristo ama Chugagwalla. ");
INSERT INTO sabNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Kwian ulita kle Jesu keruchuge gerule ene gire Jesu gerudu kwian geru jwannga gdataboko giti gdaboke ole: ");
INSERT INTO sabNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Ba mo manadale ta giti kwian daba tkanga tangle Moisés chadalla giti ulitage, ba me mo chuge ngwadi mo anblite ama ulitage. Ama ulita takalin kwian na ama gai ngwange no kweri mo chugagwallale, ama ta chegekalin no kwian na ulita gwa giti, malen ama diali mo ñometra jeike no dbe modi mo kaite kwian ngleaske, kaire nga ulita baini kaire ama kle chage ngwadi ama takalin kwian ulita gbi kade no amage ama gai dage kwian chugagwallale. Ama kle joge u mo litangwa Chube gerua jwanngwage gire diali ama kle toingwa ma no jinade mo alin toigda dba kwian ulita gwa giti mo gbagda kweri daba na ulitage. Kaire kwian e kle joge chui ollade gire kle nga ma no bligda gutangwa jinade, ama toikalin dba ule kwian chui olladanga chugagwalla ole. ");
INSERT INTO sabNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Kaire kwian daba tkanga tangle Moisés chadalla giti ulita kle muinga chegeba oli onbrege anblite lle ulita jwennga muinga oli ngeru u jwennga kaire muinga oli ngeru mo alin. Kaire kwian e kle mo gbe gerule kweri sbali Chube ole kwian ngle gwa giti, ene kwian ulita be tañachuge kwian e no no Chube ole. Kwian daba tkanga tangle Moisés chadalla giti diali ta mo gbakalin no kweri kwian ulita gwa giti agwa ama tale ama kwian me no me no, e gdale ama be boi tanre daga ngwale bdagli, Chube be ji gbe tirare tirare ama ulita alin —Jesu gerudu ene kwian geru jwannga amage ulita ole kwian daba tkanga tangle Moisés chadallage giti. ");
INSERT INTO sabNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesu kledu u gerungwa Chube olege ule kwian geru jwannga amage gdataboko giti gdaboke ole, gire Jesu gwagedu kwian ngle igi molen tanre kle igi tanre tke lle igi litangwage. ");
INSERT INTO sabNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Kaire Jesu gwagedu muinga chegeba oli onbrege gdaitedi chie igi monu ulita dbe, muinga e me lle molen ama igi gabokle alin allabi molen, agwa ama igi e ulita tku igi litangwage Chube alin. ");
INSERT INTO sabNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jesu gwagedu muingadi igi monu ulita tke igi litangwage tadi gire Jesu gerudu kwian geru jwannga ulita ole: —Cha gerule ulia ba ulita ole, muinga oli e llea me, ama igi gabokle alin molen allabi ketu ulita, kwian ulita gwa giti muinga igi ketu ma bedre kwian na ulitage, agwa Chube gwa giti muinga e igi ketu ma ngle kwian na ulitage. ");
INSERT INTO sabNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kwian igi molen tanre kle lle gige tanre mo alin ama takalin kare gire igi chegeda ama kle igi e kete Chube alin, ulia kwian gwa giti ama igi tanre ketu, Chube gwa giti me dale. Agwa muinga e me kle age ene dale, muinga e igi amanu mo managda ulita ketu Chube alin, igi toigda me chegu ama ole, Chube gwa giti muinga e igi ma ngle ketu Chube alin kwian na ulitage —Jesu gerudu ene kwian geru jwannga ole muinga igi monu ulita ketu Chube alin giti. ");
INSERT INTO sabNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Kwian geru jwannga Jesuge gweale kle gerule u gerungwa Chube ole giti, ama kle gwage u edi u dodaba ke kweri noare giti, kaire kle gerule igi giti kwian tanre igi gbu u e dodagda. ");
INSERT INTO sabNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Jesu kwian geru jwannga gweale kledu gerule ene u gerungwa Chube ole giti, Jesu ama keruchugu gire Jesu gerudu ama ulita ole: —Nege ba ulita kle gwage u kweri edi u e dodaba no no, agwa cha gerule ba ole, me sbali u e ulita be chege skianbada lle ngwale kare, ke mi chege gbaba mo giti ni gbaite, u ulita be chege skianbada. ");
INSERT INTO sabNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Jesu gerudu ene gire kwian geru jwannga geru kadu Jesuge: —Ba cha tkanga tangle geruge, ba kle gerule giti ¿e be boi ngaminegire? ¿Be boi mine ngeru? Gerule cha ole e giti gire ene chke uñale cha ulitage be boi chuia kle kodi. ");
INSERT INTO sabNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesu jaindunga: —Ba ulita kledale ta giti ene ba mi skate alenske ba mi mo chuge ngwadi mo anblitange kwian daba anblitangage chui bdagli ngnaguge. Chui bdagli chke kodi gire kwian tanre be chie mo gbe kweri gerule no mo giti daba anblitagda, ama be chage kwianske mo ka gbaba cha kalla giti gerule mau giti: “Cha Cristo, Chube cha kaguni kwian alin, chui bdagli chku.” Kwian gerule ene kle sole, ba me kwian ene keru gbe gdadi, ba me chage ama nate. ");
INSERT INTO sabNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ba be geru keruchuge kwian kle dole tanre kweri modi nga tanrege, kaire kwian kle mo lite ole ngle kira batadale gobierno dollale giti, geru ene chke ba kote ba me mo ta dbe kennga kle boi giti, boidale ene ulita ngeru agwa chui bdagli bebi chke. ");
INSERT INTO sabNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","’Kwian chudalla na be mo tke dole kwian chudalla na ole, kaire kwian toinga nga kweri nage be mo tke dole kwian toinga nga kweri nage ole. ");
INSERT INTO sabNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kaire nga be jwlien tanre, kegde kweri be chite tanre nga tanrege, kaire bli suia kweri be kle tanre, kwian ngle be jogeda bli kweri kote, kaire jingme tirare be chage tangle nga ulitage, kaire lle tirare be meñe nga ngaña giti, kwian nga dba ai giti ulita be gwage nga ngaña giti ulita boi ene gire kwian ulita be kwachie tanre. ");
INSERT INTO sabNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ngeru bebi boi ene ulita kwian cha gerua dollale be ba ulita cha gerua ganga gai cha gdale, kwian e age me no ba ole be ba dbe u mo litangwa Chube gerua jwanngwage ba gbale jiske kwian israelita chugagwallage. Ba tkabe skage, kaire ba dbabe kwian chugagwalla tanre ma kweri ngwadi, chugagwalla e ulitage ba gbabe jiske cha gerua gdale. ");
INSERT INTO sabNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ba kle chugagwalla e ngwadi gire ba be ñage gerule no cha giti kwian e ulita gwa giti. ");
INSERT INTO sabNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ba ulita mo ta gbadale me mo tallade ba be gerule mine mau giti chugagwalla kweri e ulita gwa giti, ");
INSERT INTO sabNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ba kle eni kwian e gwa giti gire chui ege cha be ba ta gbe ngle, cha be ba ta gbe gerule no no, kwian ba dollale be ba keruchuge gire ni ama gdaite be ñage gerule me no ba kalen, ama mi ñage gerule dare me no ba giti ba gbale jiske. ");
INSERT INTO sabNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Chui bdagli bebi chke gire ba ñenua, ba chebia, ba daballa, ba bitalla ulita, ba skatemanalla, kwian ene tanre be ta jwlite ba dollale be ba kete kwian chugagwallage boadalenga daga ngwale cha gerua gdale, kwian chugagwalla e be ba gweale gwangeda cha gerua gdale. ");
INSERT INTO sabNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Kaire cha gerua gdale kwian ulita be jainchke badi, ");
INSERT INTO sabNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","agwa cha ngeru ba mi jogenga gdaite, kaire ni ba ulita chugaga gdaite be jogenga chage. ");
INSERT INTO sabNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kwian age me no ba ole ba me mo tallade, ba bai me mo chuge ngwadi joge siere cha geruage boi daga ngwaleske, ba mo ta gbe cha gerua gai ulia mo tale diali gwangerugu mo ta gbe age no diali Chube takalin kare, ba bai mo ta gbe ene, chui bdagli be chke gire ba be toi no diali chui tangle cha ole Chube ngwadi. ");
INSERT INTO sabNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Chui be chke gire ba be gwage guardia donga tanre be lite una Jerusaléndi tangle, ba gwage edi ba tachkedale chui kle kodi gire guardia donga ulita be kwian una Jerusalénge gweda ulita be u skienda ulita. ");
INSERT INTO sabNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Chui ege kwian kle una Jerusalénge kigedale guardia donga ngeru bate una Jerusalénge, kaire kwian kle nga kweri Judeage kigedale jwichugage bate una Jerusalénge, kwian kle ngaske bate una Jerusalénge me chiedaleni naskuni una ege. ");
INSERT INTO sabNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Chui ege Chube be ji gbe tirare kwian ulita agenga me no alin, be boi ulia ulita Chube gerua degaba unsuialin gerule kare. ");
INSERT INTO sabNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Chui ege muinga bai kaire kle chage gaba kaire muinga bai kaire kle chage kirogwa soli sidri jusulidi ole, muinga e ulitage cha tai dage noare, ama ulita be boi daga ngwale tirare, be mnoare ama alin kige blike. Chui ege kwian ulita nga dba ai giti be boi tanre daga ngwale, chui ege Chube be ji gbe tirare kweri kwian israelita ulita alin bai me Chube gerua gau ulia. ");
INSERT INTO sabNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Guardia donga ngle kwian me israelita alin be kirachke kwian israelita una Jerusalénmu ulitadi, guardia donga e ulita be kwian israelita tanre gweda be kwian israelita na tanre dbe tkale skage nga na ulitage. Be boi ene ulita kwian israelita una Jerusalénmu ulita ole gire kwian me israelita be una e gai mo alin. Chube be kwian me israelita chuge ngwadi dole ene kwian israelita ole sbali, kwian me israelita dole ene chuia be bidege gire Chube mi ama chuge ngwadi age dare kwian israelita ole. ");
INSERT INTO sabNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Chui ege chui, dai, beu ulita be jwlite nganake tirare, ni kwian gwageba chuidi daidi beudi boi ene kare. Kwian nga dba ai giti ulita be gwage nga ngaña giti ulita boi ene gire kwian ulita be kennga tanre. Kaire chui ege ble mi kle ble kle kare, ble be gdade tirare kwian ologe, kwian be kennga tanre ble chite tiraredi. ");
INSERT INTO sabNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Nga ngaña giti nga ulita be jwlien, beu mi chege ngwedi beu kle kare, lle ulita mi chege ngeru kare nga ngaña giti. Kwian nga ulitage be gwage boi enedi nga ngaña giti gire ama be chege tañachuge tanre be boi gwangerugu giti, kwian ulita ta be chege skeke skeke chru ole, kenngaske nga be jogenga kwian tanre giti. ");
INSERT INTO sabNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Nga be boi ene ulita gire Chube be cha kageni, cha be chieni nga dba ai giti ngnagu bogakwaske Chube kiralla giti, chui ege kwian ulita be gwage chadi cha noare cha kweri, ulia cha kwian ulita Chugagwalla. Be suge trate kwian ulitage e cha amaña chiu nga dba ai giti kwian kare kle chieni nabitaite. ");
INSERT INTO sabNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nga be boi ene ba me ta dbe kennga, ba mo ta gbadale suga noare, ba be tien gitiru boi daga ngwale ulitage nga dba ai giti, ba be toi cha ole Chube kle ngwadi chuia kle kodi. ");
INSERT INTO sabNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jesu gerudu ene gire Jesu geru ñachugu kwian geru jwannga ulita alin gli kada higuera giti, Jesu gerudu: —Ba ñage gwage gli higueradi kaire gli na ulitadi. ");
INSERT INTO sabNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ba gwage chuda ngwange glidi, gliga bli kle tige, ene chke uñale bage agali chuda kle kodi. ");
INSERT INTO sabNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ene kaire ba be gwage lle tanredi boi ulita cha gerudu kare ba ole sbaliga gire chkedale uñale bage chui kle kodi gire cha be chieni nga dba ai giti kwian ulita Chugagwallale. ");
INSERT INTO sabNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Cha geru kete bage ulia, cha gerudu kare be boi ene ulita ngeru kwian ulita kle toi chui aige bebi joge tangle. ");
INSERT INTO sabNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Nga ngaña giti nga dba ai giti mi chege diali dale alin, nga ulita be joge tangle, agwa cha gerua mi joge tangle dale, cha gerua be chege diali dale alin, be boi ene ulita cha gerua kle gerule kare. ");
INSERT INTO sabNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ba ulita chagedale ta giti me mo chuge ngwadi age me no, ba me sui chuge lle gage jai, me mo ta gbe tañachuge lle nga dba ai giti alin ole, ba me chegedale tañachuge kle boi ba ole no o me no skegiti, cha be chieni chuiage ba me skatedale alenske. ");
INSERT INTO sabNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Chui ege kwian ulita bai kle toi nga dba ai giti age me no ama agali ta agekalin kare, kwian ene mi kle biale cha ngwange gire sugeti ngwale cha be chieni ama ulita be boi salengwli lle tien dáge kare. ");
INSERT INTO sabNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ba ulita kledale biale trate ta no ole cha ngwange, ba kira kadadale Chubege ba gerudale chui gdale Chube ole, ene ba be kle biale ba ñage tien gitiru lle ulita be boi me noge chui bdaglige, ba kle biale ene chui ege ba be kle cha ole ba mi ibule cha ngeru —Jesu gerudu ene ulita kwian geru jwannga ole. ");
INSERT INTO sabNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Diali chui ulita Jesu kwian tku tangle Chube geruage u gerungwa Chube olege, gire diali ngajrege ulita Jesu jo undege Ngwiskinro Jwichugallage. ");
INSERT INTO sabNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Diali ngabebitabi Jesu jo chkeni u gerungwa Chube olege gire kwian ulita chku Jesu keruchuge ngabebitabi. ");
INSERT INTO sabNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Pan me dodadre levadura ole gute chuia chiu kodi, chui e kada Pascua. ");
INSERT INTO sabNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","E suiale kwian gerunga Chube ole daba alin chugagwalla ulita kaire kwian daba tkanga tangle Moisés chadalla giti ulita, kwian e ulita kle tañachuge age mine gire ama ñage Jesu gai gwangeda. Agwa ama kennga kwian ngleadi kle chage Jesu bale malen ama me takalin age Jesu ole kwian ulita gwa giti. ");
INSERT INTO sabNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kwian gerunga Chube ole daba alin chugagwalla ulita kaire kwian daba tkanga tangle Moisés chadalla giti ulita kle tañachuge ene Jesudi gire dolla Satanás chku Judas-Iscariote tale, Judas-Iscariote ama kwian geru jwannga Jesuge gdaite ule kwian gdataboko giti gdaite na ole. ");
INSERT INTO sabNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Dolla Satanás chku Judas-Iscariote e tale gire Judas-Iscariote jo kwian gerunga Chube ole daba alin chugagwalla ulita kle ngwadige, kaire guardia u gerungwa Chube ole mananga ngle kle ne ngwadi, Judas-Iscariote chku kwian e ulita kle ngwadi gire Judas-Iscariote gerudu ama ulita ole be age giti, ama gerudu: —Cha ta ba ulita chudaboakalin Jesu gai gwangeda, cha ñage ba ulita dbe Jesu kle ngwadi ene ba ulita ñage ama gai. ");
INSERT INTO sabNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Judas-Iscariote gerudu ene kwian chugagwalla e ulita ole gire ama ulitadi nga jo chke suga noare, ama gerudu Judas-Iscariote ole: —Ba be cha chudaboi giti cha be igi ngle kete bage ba Jesu kete chage ñanale. ");
INSERT INTO sabNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas-Iscariote gerudu ama ulita ole: —Nobi cha alin, cha be ba chudaboi. Judas-Iscariote gerudu ene gire chui ege gwangerugu ama kledu kote Jesu ole Jesu gdea tke baini Jesu be kle gballa sugekare kwian nglege gire ama joge kwian Jesu dollale ole Jesu gai. ");
INSERT INTO sabNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Pan me dodadre levadura ole gute chuia chku, chui ege kwian israelita ulita bda cordero gweda gutadale Pascua chuia ollade. ");
INSERT INTO sabNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Chui e chku gire Jesu gerudu Pedro ole Juan ole: —Joga bligda dodade che ulita alin gutadale Pascua chuia ollade ule. ");
INSERT INTO sabNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Pedro, Juan geru kadu Jesuge: —¿Baini ba takalin cha joge bligda dodade? ¿Che be blire baini? ");
INSERT INTO sabNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesu jaindunga: —Ba joge una Jerusalénge, una ege kwian onbre gdaite be skwen bage chi dbe lle chi tkangwage, ba joge kwian onbre e nate baini ama be joge chke gude ngwadi, ");
INSERT INTO sabNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","gire ba gerule kwian u mauña ole: “Cha tkanga tangle geruge cha kagu aini geru kade bage nga giti blingwa, ¿baini nga kle biale cha tkanga tangle alin blire ule geru jwannga amage ulita ole Pascua chuia ollade?” ");
INSERT INTO sabNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ba gerule ene u mauña ole gire ama be nga kweri dodabale ngaña gwa u amanuge kaite bage, nga e be kle litaba trate ulita gbaba biale. Ne ngwadi ba bligda dodade che ulita alin gutadale. ");
INSERT INTO sabNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Jesu Pedro kaire Juan ta gbu ene gire Pedro, Juan jo una Jerusalénge. Ama boke jo chke una ege gire lle ulita skwendu boabale Jesu gerudu kare ama ole. Ne ngwadi Pedro, Juan bligda dodadu gutadale Pascua chuiage Jesu ama kagu kare. ");
INSERT INTO sabNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Bligda kle biale gire Jesu jo u bligda dodadre ngwadige, Jesu toidu dba blire ule kwian geru jwannga amage gdataboko giti gdaboke ole. ");
INSERT INTO sabNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Gire Jesu gerudu kwian geru jwannga ulita ole: —Cha tadu tanre Pascua chuia ai ollade ule ba ulita ole ngeru cha be jogedage. ");
INSERT INTO sabNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Cha gerule ba ole, nege cha kle blire bdagli ba ole Pascua chuia ollade, cha mi Pascua chuia ollade dare ule ba ole nga dba ai giti nege gwangerugu. Chui bdagli be chke gire Chube be cha gbe gerule kwian ulita giti kwian Chugagwallale, chui ege che be kle ule ulita nakwaite. ");
INSERT INTO sabNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Jesu gerudu ene kwian geru jwannga ulita ole gire Jesu chi jangwa gau kote uva chia ole, Jesu gerudu Chube ole uva chia giti: “Cha Ñenua, noare ba uva chia ai ketu cha ulitage jadale.” Jesu gerudu ene Chube ole uva chia giti gire ama chi jangwa uva chia ole ketu kwian geru jwanngage jadale, Jesu gerudu: —Ba uva chia ai girabate modi ulita. ");
INSERT INTO sabNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Cha geru kete bage, nege alin cha kle uva chia jai ba ole ule, agwa nege gwangerugu cha mi kle ba ole dare ba gatedi uva chia jai ule nga dba ai giti. Chui bdagli be chke gire Chube be cha gbe gerule kwian ulita giti kwian Chugagwallale, gire chui ege cha be uva chia jai nakwaite ule ba ole. ");
INSERT INTO sabNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Jesu gerudu ene geru jwannga ulita ole gire Jesu pan gau kote gerudu Chube ole pan giti: “Cha Ñenua, noare ba pan ai ketu cha ulitage gutadale.” Jesu gerudu ene Chube ole pan giti gire Jesu pan skutunga ketu kwian geru jwannga kaire kairege gutale, Jesu gerudu: —Pan ai cha uda kare, cha ketabe gwaleda ba ulita giti, ba blire ai kare cha talla ole diali, ene ba tachke chage, ene ba mi ta jogengwa cha agedu giti ba alin. ");
INSERT INTO sabNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Jesu blidu ulita kwian geru jwannga ulita ole, gire Jesu gerudu kaire uva chia giti: —Uva chia ai cha be kare, ba uva chia jai cha talla ole diali, ene ba ulita be tachke cha bege cha jogeda giti ba ulita alin, cha jogeda giti be suge trate ba ulitage Chube kle geru jagere gbe ba ulita alin. ");
INSERT INTO sabNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Jesu gerudu ene gire gerudu dare: —Cha gerule ba ulita ole, onbre gdaite be cha kete gwaleda, ama kle aini ule toiba dba blire cha ole. ");
INSERT INTO sabNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Cha chiu nga dba ai giti kwian kare, ulia cha ketabe boadale daga ngwale gwaleda Chube nu geruba kare unsuialin. Agwa onbre bai be cha kete boadalenga daga ngwale gwaleda, onbre e be boi dageare daga ngwale tanre, ama be cha jia chuge kweri. ");
INSERT INTO sabNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Jesu gerudu ene gire kwian geru jwannga geru kadu modi ulita: —Che ulita gdataboko giti gdaboke kle aini Jesu ole, ¿che ulitage bai be age ene Jesu dollale? ¿Bai be Jesu kete gwaleda? ");
INSERT INTO sabNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Kwian geru jwannga geru kadu modi ene, gire ama ulita mo ka dodaduda ongoru ongoru, ama gerudu modi: —Che ulita kle chage diali Jesu ole, ¿bai chege ma no ma kweri kwian na ulita gwa giti? ");
INSERT INTO sabNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesu kwian geru jwannga ulita keruchugu gerule ene modi gire Jesu gerudu: —Bage uñale nga ulita nga dba ai giti kwian chugagwalla ulita kle kwian kage age chugagwalla takalin kare, kwian agedale ulita chugagwalla kle gerule kare, kwian chugagwalla kle kwian kage age chugagwalla takalin kare, ene chugagwalla suge moge kweri, ama mo ka gbe: “Cha kwian ulita chudaboanga noare.” ");
INSERT INTO sabNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Agwa ba ulita me ñage tañachuge kwian chugagwalla nga dba ai giti ulita kle tañachuge kare, ba tañachugadale nganake. Kwian bai ma kweri ba ulitaske, kwian e mo gbadale ma soli, kaire kwian bai daba kaganga ama mo ta gbadale daba chudaboi no. ");
INSERT INTO sabNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kwian ulita tañachuge kwian toiba dba blingwage kwian e ma kweri kwian bligda ketangage. Ba me ñage tañachuge ene, ba ulita tañachugadale cha kle tañachuge kare, cha kle chage nga dba ai giti age no kwian ulita alin kwian ulita chudaboi, cha me kle kwian kage age no cha alin cha chudaboi, agwa cha ta agekalin mo tale no kwian ulita chudaboi. ");
INSERT INTO sabNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Kwian tanre agedu me no cha ole, agwa ba ulita chagedu ule cha ole ba me cha chugu ngwadi gballa, ");
INSERT INTO sabNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","30","malen chui bdaglige cha be ba ulita gbe kweri daba chugagwallale. Chui ege cha Ñenua Chube be cha gbe gerule nga ulita giti kwian ulita Chugagwallale, chui ege Chube gwa giti cha be gerule kwian nga ulitamu giti bai jiske Chube gwage bai me jiske Chube gwage. Ene kaire chui ege ba ulita be kle ule cha ole cha be ba ulita gbe daba chugagwallale ule cha ole gerule kwian ulita giti, cha be ba ulita gbe ba bitalla ulita israelita mne gdataboko giti gdaboke chugagwallale gerunga kwian e ulita giti bai jiske bai me jiske Chube gwage. ");
INSERT INTO sabNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jesu gerudu ene kwian geru jwannga amage gdataboko giti gdaboke ole gire gerudu Simón alin ole allabi sugekare: —Simón, ba cha keruchuge, cha gerule ba ole. Satanás ta ba ta gbakalin joge siere cha geruage salengwli kwian trigo kwara batenga batekwa giti kare ene trigo kwara joge siere trigo taglage. Satanás gerudu Chube ole: “Cha ta mo chugakalin Simón ole kaire kwian geru jwannga na ulita ole, ene ama ulita be mo ta blite joge siere ba geruage.” Chube be Satanás chuge ngwadi mo chuge ba ole. ");
INSERT INTO sabNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Gire cha gerudu tanre ba giti Chube ole: “Cha Ñenua, cha takalin ba Simón ta gbe chage no cha alin ole diali me mo ta blite Satanás ole. Ba kira kete amage, ene ama mi joge siere cha geruage.” Cha gerudu ene Chube ole ba giti. Uñale chage ba be mo ta blite sugeti Satanás ole, gire bigwa ba be tachkeni chage, ba be mo ta bliteni cha ole naskuni gire ba geru jwannga na ulita chudaboadale chage no kiraske diali cha geruage. ");
INSERT INTO sabNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simón gerudu Jesu ole: —Cha Chugagwalla, cha mi ba chuge ngwadi dale, cha kle biale joge ule ba ole skage, me joge skage alin allabi ba ole llagli agwa kaire cha mo ta gbe jogeda ule ba ole. ");
INSERT INTO sabNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesu gerudu: —Pedro, cha gerule ba ole, nege ngajrege ngakamalin bdugu antalan bebi ngwane gire ba agali be gerule bitamai kwian na ole ba me cha uñe. ");
INSERT INTO sabNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jesu gerudu ene Simón ole gire Jesu gerudu kwian geru jwannga gdataboko giti gdaboke ulita ole: —Bitaite cha ba kagu Chube gerua trage kwian ulita ole kaire kwian oga dodade. E suiale ba me jo gde dbe ba me jo igi dbe ba me jo zapato giti, ¿ba chagedu no o ba me chagedu no? Kwian geru jwannga ulita gerudu: —Cha chagedu no. ");
INSERT INTO sabNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jesu gerudu: —Nege ba age nganake, ba bai gde molen ba gde dbe, ba bai igi molen ba igi dbe, ba bai me sbadi molen ba camisa chbade camisa ñanalla giti ba sbadi gige dogda. ");
INSERT INTO sabNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Chube gerua degaba unsuialin gerule cha giti, chada e gerule: “Kwian be gerule ama kwian me no, kwian be ama gbe jiske kwian me no kare, ama gwabeda kwian me no ole ule.” Cha boabe ene ulia, cha be boi ene chuia kle kodi chada degaba unsuialin gerule kare. ");
INSERT INTO sabNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Kwian geru jwannga ulita gerudu: —Cha Chugagwalla, sbadi dogda gaboke kle ai biale. Jesu gerudu: —E nobi, che mi gerule dare e giti. ");
INSERT INTO sabNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jesu gerudu ene kwian geru jwannga amage ulita ole gire Jesu jo siere ama kledu ngwadige jo Ngwiskinro Jwichugallage ule kwian geru jwannga ulita ole, jwichuga ege Jesu kle joge diali gerule Chube ole. ");
INSERT INTO sabNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Jesu jo chke jwichuga ege nga e Jesu kle joge kare ngwadi, gire Jesu gerudu kwian geru jwannga ulita ole: —Ba ulita gerudale Chube ole mo chudaboi kade amage, ene ba me ta jwlite joge siere chage age me no. ");
INSERT INTO sabNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Jesu gerudu ene gire Jesu jo sugekare kwian geru jwanngage bateno ke mlie ke jange mangire batre ngwadi, eni Jesu jo chke dba jongnagwa giti gerule Chube ole. ");
INSERT INTO sabNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Jesu gerudu: “Cha Ñenua, cha me ta boikalin daga ngwale, cha me takalin ba kwian me no chuge ngwadi cha gweda, ba takalin ba ñage cha jwen siere cha be boi tirarege. Agwa ba age cha alin mo tale ba takalin kare, me cha takalinge kare.” ");
INSERT INTO sabNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Jesu kledu gerule ene Chube ole gire lle boanga Chube alin nga ngaña giti chku Jesudi Jesu kira gbe. ");
INSERT INTO sabNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jesu kle tañachuge tanre ama be boi giti, ta olire tanre ole Jesu gerudu ma no mno dare Chube ole mo kira gbe ama be boi giti gire Jesu gwingwa jritedu salengwli be kle chie be kle joge dba dbiske kare. ");
INSERT INTO sabNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Jesu gerudubi Chube ole, Jesu chku gdate, Jesu joni kwian geru jwannga kle manade ngwadi. Jesuge kwian geru jwannga skwendu gbe, kwian geru jwannga ta olire ole ama skwatigu ama gbedu. ");
INSERT INTO sabNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Jesu gerudu: —¿Mineade ba ulita kle gbe? Chke bduge gerule Chube ole, ene ba me ta jwlite joge siere chage age me no. ");
INSERT INTO sabNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesu kle gerule ene kwian geru jwannga amage ole gire kwian geru jwannga Jesuge na gdaite kada Judas-Iscariote chku kwian ngle dbe ule Jesu kle ngwadi. Judas-Iscariote jo chke Jesudige Jesu sobadadale, ene chke uñale kwian Jesu dollage Judas-Iscariote giti e Jesu, ene Jesu dolla ñage Jesu gai. ");
INSERT INTO sabNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jesu gerudu Judas-Iscariotege: —Judas-Iscariote, cha gerule ba ole, Chube cha kagu nga dba ai giti kwian kare, ¿nege ba kle mo ta gbe cha sobade ketadale gwaleda kwian agenga me noge? ");
INSERT INTO sabNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Kwian geru jwannga ulita kle chage Jesu ole gwagedu Judas-Iscariotedi age ene Jesu ole gire sugedu ama ulitage Jesu be boi daga ngwale, ama ulita tadu Jesu chudaboakalin malen ama ulita geru kadu Jesuge: —Cha Chugagwalla, ¿ba takalin cha kira bate ba dolla ai ulita ole sbadi giti? ");
INSERT INTO sabNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Kwian geru jwannga ulita geru kadu ene Jesuge gire blike ama gdaite kwian gdaite ologa taingwli tkunga ulita sbadi giti, kwian ologa jo tkabanga kwian e lle boanga kwian gerunga Chube ole chugagwalla ma kweri alin. ");
INSERT INTO sabNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jesu gerudu kwian geru jwannga ole: —¡Ba me age dare ene kwian ole! Jesu gerudu ene gire Jesu kwian ologa gatuda kodi, ene kwian ologa jo chkeni noni. ");
INSERT INTO sabNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Kwian gerunga Chube ole daba alin chugagwalla ngle, kwian u gerungwa Chube ole mananga ngle, kwian israelita chugagwalla juma ngle, kwian e ulita kaire kle chage Jesu jwen dbale skadi, Jesu gerudu ama ulita ole: —¿Mineade ba ulita kle chage sbadi ole glita ole cha gai nate kwian jiskenga kare? Ba kle age cha ole salengwli ba age kwian agenga me no me no ole kare. ");
INSERT INTO sabNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Chui ulitage diali cha kledu ba ulita ole u gerungwa Chube olege, ni bitaite ba cha gau dbale skadi. Agwa nege chui chku ba alin age cha ole Chube kle ba chuge ngwadi age kare, malen nege ba ñage age cha ole ba takalin kare Satanás kiralla giti, Satanás kwian me no ulita chugagwalla, ba ulita kle age ama takalin kare. ");
INSERT INTO sabNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jesu gerudu ene gire kwian ngle ulita Jesu gau Jesu du skadi kwian gerunga Chube ole daba alin chugagwalla ma kweri ullage. Pedro jo chage gwage bate Jesu nate. ");
INSERT INTO sabNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Kwian Jesu ganga jo chke Jesu dbe kwian gerunga Chube ole chugagwalla ma kweri ullage, kwian ulita jo chke llani gire kwian jita teun goga kwian ulita toidu dba jita ngwachuge. Pedro kaire chegu jita ngwachuge ule kwian nglea ole. ");
INSERT INTO sabNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Muinga gdaite lle boanga gwagedu Pedrodi toiba dba jitadi, muinga e chegu gwage tanre Pedrodi, muinga gerudu kwian ulita ole: —Onbre e kledu chage ule Jesu ole. ");
INSERT INTO sabNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pedro gerudu muinga ole: —Cha me chagedu ama ole, cha me ama uñe. ");
INSERT INTO sabNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Bigwa kwian na gwagedu Pedrodi, gerudu Pedro ole: —Kwian mneite chagedu Jesu ole diali, suge chage ba kwian ene gdaite, ulia ba ama chagemanalla. Pedro gerudu kwian ole: —Me dale, cha me ama chagemanalla. ");
INSERT INTO sabNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Hora gdaite jo tangle gire kwian na gerudu Pedro giti: —Uñale chage onbre e nga Galileamu, ama kledu chage Jesu ole. ");
INSERT INTO sabNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pedro gerudu: —Cha me ama uñe dale, me uñale chage ba kle llema geruade cha ole. Pedro kle gerule ene kwian ole, Pedro bebi keru tiendba ulita gire antalan ngwanedu. ");
INSERT INTO sabNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Jesu jwliteduda gwagedu Pedrodige, Pedro tendu Jesudi gire Pedro tachku Jesu gerudu giti ama ole ngeru: “Nege ngajrege ngakamalin bdugu antalan bebi ngwane gire ba agali be gerule bitamai kwian na ole ba me cha uñe.” ");
INSERT INTO sabNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pedro tachku Jesu gerudu ene giti gire Pedro jo sugekare, ama olidu tanre tanre ama gerudu Jesu dollale giti. ");
INSERT INTO sabNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","65","Kwian israelita chugagwalla ulita Jesu gbanga jiske ama ulita agedu tanre me no Jesu ole, ama Jesu gbu gidagda, ama Jesu batu, ama Jesu gwagwa gatuda ñomedrega giti ene Jesu me chegu ten kwiandi, ama Jesu batu obere gire geru kadu Jesuge: —Gerule cha ole, ¿chema kle ba bate? Ama ulita gerudu tanre me no me no Jesu dollale kidere Jesudi. ");
INSERT INTO sabNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nga chku ju gire kwian israelita chugagwalla juma ulita, kwian gerunga Chube ole daba alin chugagwalla ulita kaire kwian daba tkanga tangle Moisés chadalla giti, kwian e ulita mo litu jennga Jesu giti, ama ulita Jesu dbangu ama ulita gwa giti, gire chugagwalla e ulita geru kadu Jesuge: ");
INSERT INTO sabNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Gerule cha ole, ¿ulia ba Cristo? ¿Chube nu ba kagaba ulia nga dba ai giti kwian alin o me? Jesu jaindunga: —Cha jainnga ima ba mi cha gerua gai ulia. ");
INSERT INTO sabNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Cha geru kade bage ba tale ba tañachuge cha chema ba mi jainnga, ba mi gerule ulia cha ole cha chema. ");
INSERT INTO sabNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Cha gerule ulia ba ulita ole, Chube kira molen ulita, ama cha kagu nga dba ai giti kwian kare, nege gwangerugu cha mi chege aini, cha be jogeni nga ngaña giti Chube ngwadi gire cha be toi dba diali Chube ko taingwli giti kwian ulita Chugagwallale. ");
INSERT INTO sabNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Jesu gerudu ene gire kwian ulita geru kadu Jesuge: —¿Ba kle gerule ba Chube Kirolla? Jesu jaindunga: —Ima, cha amaña ba ulita kle gerule kare, cha Chube Kirolla. ");
INSERT INTO sabNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Kwian ulita gerudu modi: —¿Lledale che kwian na kade gerule ama giti ama gbale jiske? Ama kle mo gbe jiske agali ama kle gerule giti, ama agali gerudu ama Chube Kirolla, che ulita ama keruchugu ama me ñage gerule ene, e me ulia. ");
INSERT INTO sabNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Kwian israelita chugagwalla ulita jo Jesu dbe chugagwalla Pilato ngwadi gbale jiske Pilatoge, Pilato nga Romamu ama kwian nga Judeamu chugagwalla. ");
INSERT INTO sabNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Kwian israelita chugagwalla ulita jo chke Pilato ngwadi gire kwian Jesu gbu jiske Pilatoge, kwian gerudu: —Onbre ai skwendu cha ulitage gerule cha bitalla ulita ole gobierno dollale, kle gerule cha ulita me igi ketadale kwian nga Romamu chugagwalla kweri emperador kada Césarge, kaire kle gerule ama Cristo Chube nu ama kagaba nga dba ai giti kwian Chugagwallale. ");
INSERT INTO sabNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Kwian gerudu ene Jesu gbale jiske Pilatoge, gire Pilato geru kadu Jesuge: —¿Ba kwian israelita ulita chugagwalla kweri? Jesu jaindunga: —Ima, cha amaña ba kle gerule kare. ");
INSERT INTO sabNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Jesu gerudu ene gire Pilato gerudu kwian gerunga Chube ole daba alin chugagwalla ulita ole kaire kwian ngle kledu eni ole: —Cha geru tragu tanre onbre ai ole, suge chage trate ama me jiske dale. ");
INSERT INTO sabNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pilato gerudu ene gire kwian ulita me ta chugu gerule Pilato ole Jesu dollale, ama ulita gerudu: —Onbre ai kle chage kwian tke tangle geru me uliage nga Judea ulitage. Ngeru ama chagedu kwian tke tangle nga Galileage, nege ama kle age ene kaire aini, ama kle kwian tanre anblite mau alin kle kwian ta gbe age chugagwalla kweri César dollale. ");
INSERT INTO sabNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilato kwian keruchugu gerule ene Jesu giti Jesu kledu chage kwian tke tangle nga Galileage, gire Pilato geru kadu kwian ulitage: —¿Onbre ai nga Galileamu? ");
INSERT INTO sabNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Kwian jaindunga: —Ima, ama nga Galileamu. Gire Pilato Jesu dbangu Herodes ngwadi, Herodes kwian nga Galileamu chugagwalla gobernador malen Pilato Jesu kagu Herodege, chui ege Herodes kaire kledu una Jerusalénge. ");
INSERT INTO sabNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Jesu dule jo chke Herodes ngwadi, Herodes gwagedu Jesudige gire nga chegu suga noare Herodedi, Herodes ologe kwian geruba Jesu kle lle daga ngwale no tanre dodade Chube kiralla giti malen sbali Herodes tadu gwagekalin Jesudi, Herodes kle Jesu manade ngwange chui gwealege Jesu lle daga ngwale dodade Chube kiralla giti Herodes gwa giti. ");
INSERT INTO sabNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herodes gwagedu Jesudi gire Herodes geru kadu tanre amage, agwa Jesu me jaindunga ni sidri Herodes kalen. ");
INSERT INTO sabNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Kwian gerunga Chube ole daba alin chugagwalla ulita kaire kwian daba tkanga tangle Moisés chadalla giti ulita, kwian e ulita kledu ule eni, ama ulita gerudu tanre me no Jesu giti Jesu gbe jiske Herodege. ");
INSERT INTO sabNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodes geru e ulita Jesu giti keruchugu gire Herodes ule mo guardialla donga ole agedu tanre daga ngwale Jesu ole, ama Jesu gbu gidegda tanre, ama Jesu ngama tku ñometra noareske kwian chugagwalla ñometralla kare Jesu gbale gidegda, ñometra eske Herodes Jesu kaguni naskuni Pilato ngwadi. ");
INSERT INTO sabNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Amaña chuiage Herodes kaire Pilato jwlitu mo skatemanallale, ngeru ama mo dollale. ");
INSERT INTO sabNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Jesu dbajo chkeni Pilato ngwadi gire Pilato mo litu kwian israelita ulita kledu eni ole kaire kwian israelita chugagwalla ulita ole, ");
INSERT INTO sabNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Pilato gerudu kwian e ulita ole: —Ngeru ba chiu onbre ai dbe aini ba gerudu onbre ai kle gerule ba bitalla ulita ole gobierno dollale. Cha geru kadu amage ba ulita gwa giti, ba cha keruchugu, chage suge trate onbre ai me jiske dale ba kle ama gbe jiske kare. ");
INSERT INTO sabNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Cha ama kagu chugagwalla Herodes ngwadi, Herodege kaire onbre ai me skwendu jiske malen Herodes ama kaguni naskuni che ulita ngwadi. Ba ulitage sugedale trate kaire ama me jiske ama me jogedaleda. ");
INSERT INTO sabNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Cha be ama kwabate alin gire bigwa cha be ama chuge ngwadi gbale. ");
INSERT INTO sabNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pilato be kwian gdaite kle skage skajwanngenga ama age diali kare Pascua chuiage, malen Pilato takalin Jesu skajwanngenga, ");
INSERT INTO sabNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","agwa kwian ulita ule ngautu kweri: —Kwian ai gwangeda, Barrabás chuge ngwadi gbale. ");
INSERT INTO sabNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barrabás jo tkaba skage gobierno giti, Barrabás kwian na tanre ole unaske mo ta gbu ule kira bate gobierno dollale, kaire Barrabás daba na guda, age me no e gdale Barrabás kledu skage. ");
INSERT INTO sabNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Kwian ulita takalin Barrabás chege gbale agwa Jesu jogedaleda. Pilato gerudu nabitaite kwian ole: —Cha takalin Jesu chuge ngwadi gbale, cha be ama skajwanngenga. ");
INSERT INTO sabNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Gire kwian ulita ngautu ma kweri: —¡Ama gwangeda kruge! ¡Ama gwangeda kruge! ");
INSERT INTO sabNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Bitamaidale Pilato gerudu kwian ulita ole: —¿Mineade ba takalin cha ama gwangeda kruge? Chage suge trate ni ama agedu me no sidri, ¿llema giti ama jiske? Chage ama me skwen jiske dale ama me jogedaleda. Cha be ama kwabate alin gire bigwa cha be ama chuge ngwadi gbale. ");
INSERT INTO sabNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pilato gerudu ene gire kwian ulita ngautu dare kweri: —¡Ama gwangeda kruge! ¡Ama gwangeda kruge! Kwian ulita ngautu tanre ene, gire bdagli Pilato agedu kwian ulita tadukalin kare. ");
INSERT INTO sabNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilato gerudu kwian nglea ulita ole: —Cha be age ba ulita takalin kare, cha be onbre ai kete bage, ba ta agekalin kare ama ole ba age. ");
INSERT INTO sabNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pilato Jesu ketu ene kwian ulitage gwaleda kwian takalin kare, gire Pilato Barrabás skajwanngunga, Barrabás jo tkaba skage gobierno giti, ama kwian na tanre ole mo ta gbu ule kira bate gobierno dollale, kaire Barrabás daba na guda, age me no e gdale Barrabás kledu skage, Pilato onbre e agenga me no skajwanngunga agwa Pilato Jesu ketu gwadaleda kwian ulita tadukalin kare. ");
INSERT INTO sabNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Guardia donga ulita jo Jesu dbe kru ole nga Jesu gwabeda ngwadi, gire jonkare guardia donga tendu onbre kada Simón ngwange, Simón una Cirenemu, Simón kledu chage una Jerusalén ngnagu gire guardia donga Jesu gau gbu Jesu krulla dbe Jesu nate. ");
INSERT INTO sabNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Kwian nglea una Jerusalénge chagedu Jesu nate, kwian nglea eske muinga tanre chagedu ta olire tanre Jesu giti, ama ulita chagedu Jesu nate. ");
INSERT INTO sabNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesu gwagedu muinga tanre kle oliredi gire Jesu gerudu ama ulita ole: —Muinga una Jerusalénmu, ba ulita me olire cha giti, ma no ba ulita olidale mo giti kaire ba ulita olidale mo kirogwalla giti. ");
INSERT INTO sabNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Bdagli kwian boi daga ngwale chuia be chke, chui ege kwian ulita be gerule: “Noare muinga ulita alin bai toidu onbre ole agwa me ñadu chage gaba, noare muinga ulita alin bai me ñadu kirogwa molen me su jusuli kete kirogwage.” ");
INSERT INTO sabNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Kaire chui ege kwian ulita be gerule dbinanga ole: “¡Chitedenga cha giti!” Be gerule jwichuga dbira ole: “¡Cha gateda!” ");
INSERT INTO sabNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Cha agali ole kwian kle age me no ba ulita gwa giti, ba ole bdagli be boi ma tirare. Cha gli lere kare, kwian kle age tanre me no cha ole. Ba gli dra kare, ba ole be boi ma tirare bdagli —Jesu gerudu ene muinga e ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Kwian jiskenga boke dule gwaleda ule Jesu ole. ");
INSERT INTO sabNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kwian boke e jo chke Jesu ole nga kada Calaverage, eni guardia donga Jesu gbu kruge ngaña, kaire guardia donga kwian jiskenga boke e gbu kru na gdabokege ngaña, gdaite gbere kruge Jesu ko taingwli ngnagu giti, gdaite gbere kru nage Jesu ko jobole ngnagu giti. ");
INSERT INTO sabNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesu kledu kruge ngaña gire Jesu gerudu Chube ole: —Cha Ñenua, kwian ulita kle age me no cha ole, agwa amage me suge ama kle age giti, cha takalin ba ama kle age me no ulita cha ole talla mlienga —Jesu gerudu ene mo Ñenua ole. Jesu ñometralla jo jwanbanga Jesudige, ñometra e ulita guardia donga ulita girabatu modi guardia donga bai kaire blachku no ole. ");
INSERT INTO sabNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Kwian tanre kledu eni gwage Jesudi, kaire kwian israelita chugagwalla tanre kledu eni kidere tanre Jesudige, chugagwalla e ulita gerudu me no modige Jesu giti: —Ama ñadu kwian na tanre chudaboi, nege ama mo chudaboadale agali, ama ulia Cristo Chube nu ama kagaba nga dba ai giti ama mo jwanlenga agali kruge. ");
INSERT INTO sabNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Kwian israelita chugagwalla ulita gerudu me no ene kidere Jesudi, kaire guardia donga ulita ama gidedu tanre Jesudi, ama uva chia gage gatu Jesuge jadale, ");
INSERT INTO sabNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","gire guardia donga gerudu me no Jesu ole Jesu gbagda gidagda, ama ulita gerudu: —Ulia ba kwian israelita ulita chugagwalla kweri ba mo jwennga agali kruge. ");
INSERT INTO sabNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Chada jo degaba Jesu giti, chada e gbere kruge Jesu chuga giti, chada e gerule: “Ai kwian israelita ulita chugagwalla kweri rey.” ");
INSERT INTO sabNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Kwian jiskenga gdaboke kledu Jesu ole kruge mo kaire, kwian jiskenga e gdaite gerudu me no kidere Jesudi, ama gerudu: —¿Ba me gerudu ba Cristo Chube nu ba kagaba nga dba ai giti? Ba ulia Cristo ba gerudu kare gire ba mo jwennga agali kruge, kaire ba cha boke jwennga kruge. ");
INSERT INTO sabNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Kwian jiskenga na gdaite ka bo skatemanalla ole skatemanalla gerudu me no Jesu ole giti, jiskenga e gerudu skatemanallage: —¿Ba ta me kwachie Chubedi? Che kle ji chuge ule onbre ai ole, ");
INSERT INTO sabNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","che ji chugadale gballa gdabonate, che jiske ulia, che agedu me no malen che kle aini ji chuge che agedu me no giti, agwa ama me su age me no, ama me jiske dale. ");
INSERT INTO sabNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Jiskenga gdaite ka bobi ene mo skatemanalla ole Jesu gdale gire ama gerudu Jesu ole: —Jesu, ba chuia be chke gire ba be chege kwian ulita Chugagwalla kweri, chui ege cha takalin ba tachke cha giti ba tai dage chage. ");
INSERT INTO sabNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesu jaindunga onbre e kalen: —Cha gerule ulia ba ole, nege sugeti ba be kle ule cha ole nga noarege nga ngaña giti Chube ngwadi. ");
INSERT INTO sabNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Chui chku bduke gire nga ulita nga dba ai giti chegu nga jereske, chui me chratigunga dare, nga jere ene jagedu hora gdamai, chui jo chege nga bonga dbigu gire nga chra chiuni. Boidu ene gire sugeti ngwale ñometra ura kle itabanga gwa u gerungwa Chube olege, ñometra e skagedunga tainkwli bonga ngaña joge dba. ");
INSERT INTO sabNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Gire Jesu gerudu kweri Chube ole: skagenga tainkwli bonga ngaña joge dba —Cha Ñenua, cha mo oña kete bage manadale. Jesu gerudu ene gire Jesu jokeda. ");
INSERT INTO sabNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Guardia donga chugagwalla gdaite kledu eni ama gwagedu Jesu boidu ene ulitadi, gire guardia chugagwalla e gerudu: —Chube noare kweri, ulia Chube onbre ai kagu nga dba ai giti, ama trate, ama me agenga me no, ama me jiske dale. ");
INSERT INTO sabNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Kwian ngle mo litaba kledu gwage Jesu boidu ulitadi, gire kwian e ulita jo gwasieruda mo bate kudegdage ta olire ta kwachie ole Jesu giti. ");
INSERT INTO sabNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Kwian Jesu uñanga onbre kaire muire ulita nu chieba nga Galileage Jesu ole llagli kledu eni gwage bate Jesudi Jesu boidu ulitadi. ");
INSERT INTO sabNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Onbre gdaite kada José kledu eni Jesu jokeda kruge ngwadi, ama kwian israelita chugagwalla gdaite, ama kwian no, ama chagedu no Chube takalin kare, ama kwian una Arimateamu nga Judeage. ");
INSERT INTO sabNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","José noare Chube ole, ama kledu Chube chuia manade ngwange Chube be gerule nga ulita giti kwian ulita Chugagwallale. Josége me chegu no kwian israelita chugagwalla na ulita agedu Jesu ole Jesu gwanguda. ");
INSERT INTO sabNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","José jo Pilato ngwadi Jesu jaba kade Pilatoge ogadale, José gerudu Pilato ole: —Cha ta Jesu jaba ogakalin. Pilato jaindunga: —Ba ñage Jesu jaba oge. ");
INSERT INTO sabNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","José Jesu jaba jun dbige kruge, José Jesu jaba bliuda ñometra no glitaleske gire José jo Jesu jaba dbe keuga jaba ogangwage, José Jesu jaba gbu keugage, keuga ege ni kwian jaba ogaba gdaite, eni Jesu jaba jo ogaba. ");
INSERT INTO sabNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","55","Muinga ulita nu chieba Jesu ole nga Galileage, muinga e ulita jo chage José nate Jesu jaba oge ngwadi. José Jesu jaba gbu chiga keugage muinga e ulita gwa giti, malen muinga ege chku uñale Jesu jaba chegu ogaba keuga ege. Jesu jaba ogle chuia, chui e chege chuietre alin kwian israelita undege chuia. ");
INSERT INTO sabNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Muinga ulita joni gudegu, muinga lle ñachke noare dodadu gbu biale dbe tkale Jesu jaba giti. Gire chuietege undege chuiage muinga e ulita undegu Moisés chadalla gerule kare. ");
INSERT INTO sabNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Muinga ulita nu chieba Jesu ole nga Galileage muinga e ulita undegu undege chuiage, undege chuia jo tangle gire nagbietege chui domingoge ngabebitabi muinga e ulita jonini Jesu jaba ogle ngwadi lle ñachke noare dbe tkadale Jesu jaba giti. ");
INSERT INTO sabNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Muinga e jo chke keugage Jesu jaba ogle ngwadi, muinga gwagedu kechuga kweridi kechuga e gbaba keugage me kle kaire, kechuga jwanbanga, keuga ugakalla chegeba ka ngwale. ");
INSERT INTO sabNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Muinga jo chiga keugage, muingage ama Chugagwalla Jesu jaba me skwendu. ");
INSERT INTO sabNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Muinga chegu tañachuge tanre, me uñale muingage boidu mine Jesu jaba ole, kle tañachuge ene gire sugeti ngwale onbre boke kle jageba gdate ule muinga ole, onbre e mo ngama tkaba ñometra gwade chra chraske. ");
INSERT INTO sabNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Muinga gwagedu onbre edi, muinga gwa gbu gwadbiguda kenngaske gire onbre e gerudu muinga ole: —¿Mineade ba ulita kle chage aini kwian gwade jinade kwian jaba ogangwage? ");
INSERT INTO sabNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","Aini ama me kle. Ama chkuni gwade. ¿Ba me tachke ama gerudu giti ba ole ama kledu llani nga Galileage gire? Ama gerudu: “Chube cha kagu nga dba ai giti kwian kare, cha ketabe kwian me noge gwadaleda kruge, chui gbamaige gire cha be chkeni gwade.” ¿Ba me tachke e giti? ");
INSERT INTO sabNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Onbre gerudu ene muinga ole gire muinga ulita tachku Jesu gerudu ama ole giti. ");
INSERT INTO sabNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Muinga ulita joni, muinga geru tragu kwian geru jwannga Jesuge gdataboko giti gdaite ole ama gwagedudi giti, kaire muinga geru e tragu kwian na dare ole. ");
INSERT INTO sabNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Muinga geru Jesu giti tragu kwian geru jwannga ulita ole, muinga tanre e ulitaske muinga gdaite kada María-Magdalena, gdaite na kada María, María e Santiago chebia, gdaite na kada Juana, muinga e gdamai kledu chage ule muinga na tanre ole geru Jesu chkuni gwade giti trage. ");
INSERT INTO sabNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Muinga gwagedudi boi ulita gerua tragu kwian geru jwannga Jesuge ole, kwian geru jwannga tañachugu muinga ulita sodu, ama me muinga gerua Jesu giti gau ulia. ");
INSERT INTO sabNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pedro geru e keruchugu gire Pedro jo jrite tienda Jesu jaba ogle ngwadi, Pedro jo chke llani, tiunda dbige keugage gire gwagedu ñometra alin kle, Jesu jaba me kle. Pedro joni gudegu tañachuge tanre mo tale boidu ulita giti, ama tañachugu: “¿Agedre mine Jesu jaba ole? ¿Jesu jaba kle baini?” ");
INSERT INTO sabNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Chui amañage kwian boke jo chage una kada Emaús ngnagu, una e chege kilómetro gdataboko giti gdaite una Jerusalénge. ");
INSERT INTO sabNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Kwian boke e kle chage jonkare geru trage gdabonate Jesu boidu ulita giti. ");
INSERT INTO sabNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ama kle geru trage jonkare Jesu giti gire Jesu amaña chiu amadige, Jesu chagedu ule ama ole. ");
INSERT INTO sabNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Kwian boke gwagedu kwian na kledu chage ule ama ole, agwa me chku uñale ama bokege chema kle chage ule, me sugedu amage Jesu amaña kledu chage ule ama ole. ");
INSERT INTO sabNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesu geru kadu amage: —¿Llema giti ba kle geru trage jonkare? ¿Mineade ba kle ta olire? Jesu geru kadu ene gire kwian boke e jagedunga gdate jonke, ama ta olire tanre, ");
INSERT INTO sabNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ama gdaite kada Cleofas jaindunga Jesu kalen: —Kwian ulitage uñale boidu mine una Jerusalénge chui jo tangle aige. ¿Agwa bage geru e me chku uñale boidu giti una Jerusalénge? ");
INSERT INTO sabNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jesu geru kadu: —¿Boidu mine? Kwian jaindunga: —Cha kle gerule Jesu giti, Jesu una Nazaremu. Ama kwian Chube gerua ketanga dabage, Chube gwage kaire kwian gwage ama gerudu no ulita kiraske lle bo no ulita kiraske. ");
INSERT INTO sabNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Kwian gerunga Chube ole daba alin chugagwalla ulita kaire che chugagwalla na ulita, ama ulita Jesu ketu gwadaleda kruge kwian jiskenga kare. ");
INSERT INTO sabNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Cha tañachugu Chube nu ama kagaba cha chudalla israelita chugagwallale cha chudalla ulita chudaboi jwen siere kwian cha dollale ulitage, agwa gire me boidu ene cha tañachugu kare, ama guleda kruge, bogleriga Jesu jo gwabada. ");
INSERT INTO sabNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Muinga tanre kledu chage cha ulita mneitella ole Jesu nate, muinga e gweale jo nege ngabebitabi Jesu jaba jo ogaba ngwadi keugage, Jesu jaba me su skwen muingage gire muinga chiuni gudegu, muinga e ulita cha kwajun gerudu ama gwagedu lle boanga Chube alin nga ngaña giti bokedi, agwa Jesudi ama me su gwage, lle boanga Chube alin gerudu muinga e ole Jesu kle gwadeni. ");
INSERT INTO sabNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Bigwa daba cha chagemanalla gweale jo tienda agali Jesu jaba jo ogaba ngwadi keugage, cha chagemanalla gwagedu lle ulitadi muinga gerudu kare, agwa Jesudi ama me su gwage. ");
INSERT INTO sabNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Kwian e gerudu ene Jesu ole gire Jesu gerudu ama ole: —Ba me ta molen. Unsuialin kwian Chube gerua ketanga ulita gerudu tanre Cristo giti, ba ama gerua e Cristo giti keruchugu trate Cristo boidale ene, agwa ba me geru e gau ulia. ¿Mangire ba be mo ta gbe geru e gai ulia? ");
INSERT INTO sabNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Chube nu Cristo kagaba nga dba ai giti, bage sugedale trate ama boidale daga ngwale ene ulita ngeru gire be jogeni nga ngaña giti Chube kle ngwadi. ¿Mangire ba be geru e gai ulia? ");
INSERT INTO sabNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Jesu gerudu ene kwian boke ole gire ama gdamai jo chage dare una Emaús ngnagu, jonkare Jesu geru ñeu tanre kwian bokege, Jesu geru ñeu Moisés nu Chube gerua degaba unsuialin giti, kaire Jesu geru ñeu kwian Chube gerua ketanga nu Chube gerua degaba ulita giti, chada e ulita gerule tanre Jesu be boi giti ulita nga dba ai giti. ");
INSERT INTO sabNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Kwian boke jo chke unaske ule Jesu ole, unage ama gwagedu Jesudi Jesu be joge dare. ");
INSERT INTO sabNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Agwa ama boke gerudu Jesu ole: —Ba chegeda cha ole aini, ba me joge dare, nga jere. Ama gerudu ene Jesu ole agwa Jesu jo gudegu chegedaleda ama ole. ");
INSERT INTO sabNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","31","Jesu jo chke gwa kwian boke ole gire boidu ene: Jesu toidu dba blingwage ule kwian boke ole, Jesu pan gau kote, gerudu pan giti Chube ole: “Cha Ñenua, noare ba ai ketu chage gutadale.” Gerudu ene Chube ole gire Jesu pan skutunga, Jesu pan ketu kwian bokege, gire sugeti ngwale chku uñale trate kwian boke ege Jesu amaña kle ule ama ole. Boidu ene gire blike Jesu jongwa kwian boke gwage ne ngwadi blingwage. ");
INSERT INTO sabNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Kwian boke gerudu modi: —Ulia ama chagedu jonkare che ole geru trage, ama geru ñeu Chube gerua degaba unsuialin giti, gire che tadi sugedu no ama kledu gerule giti che ole, agwa che me chku ama uñe nate chema tra no kledu gerule che ole, nege sugedu chege e Jesu amaña. ");
INSERT INTO sabNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Kwian boke me manadu dare eni, ama joni blike una Jerusalénge, una ege kwian geru jwannga Jesuge gdataboko giti gdaite skwendu mo litaba kwian na tanre ole. ");
INSERT INTO sabNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Kwian ulita kle mo litaba ole una Jerusalénge gerudu kwian boke ole: —Che Chugagwalla Jesu chkuni gwade, ama medu Simónge. ");
INSERT INTO sabNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Gire kwian boke kaire geru tragu kwian ulita kle mo litaba ole ama boidu mine ulita jonkare, Jesu geru unsuialin tanre ñeu ama bokege jonkare, kaire unaske gwa Jesu pan skutunga pan ketu ama bokege gire chku Jesu uñe nate Jesu amaña, kwian boke geru e ulita tragu kwian kle mo litaba ole. ");
INSERT INTO sabNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kwian boke kle geru e trage kwian ulita kle mo litaba ole gire Jesu me chiu gda uñale kwiange Jesu chku kwian e ulitaske, Jesu gbi kadu kwian ulitage. ");
INSERT INTO sabNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Kwian ulita kwachiu tanre, tañachugu ama kle gwage oñakwadi. ");
INSERT INTO sabNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","40","Jesu geru kadu kwiange: —¿Mineade ba kle kwachie? ¿Mineade ba kle tañachuge mo tale cha me amaña? Jesu geru kadu ene kwiange gire Jesu ko kaitu sera kaitu kwiange, Jesu gerudu: —Gwagede cha kodi, gwagede cha seradi, mo ta gbege cha gai ulia cha amaña kle ba ulita gwa giti. Cha chugedi mo kodi, ene chke uñale bage cha me oñakwa, oñakwa me uda molen me gda molen, cha uda molen cha gda molen ba ulita kle gwage chadi kare. ");
INSERT INTO sabNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Kwian ulita Jesu keruchugu gerule ene gire kwian ulitadi nga suga noare, ama tadukalin Jesu gerua gai ulia, agwa chegu tañachuge tanre mo tale Jesudige: “¿Ama gerudu ulia o me?” Kwian kledu tañachuge ene gire Jesu geru kadu ama ulitage: —¿Ba bligda molen aini gutadale? Cha ta blikalin. ");
INSERT INTO sabNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Kwian ngwe lingu bitaite ketu, ");
INSERT INTO sabNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Jesu ngwe gutu kwian e ulita gwa giti, ");
INSERT INTO sabNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","gire Jesu gerudu ama ulita ole: —Ngeru cha kledu ba ole gire cha gerudu tanre ba ole Chube gerua degaba unsuialin giti, Moisés nu Chube gerua degaba, kwian Chube gerua ketanga dabage nu Chube gerua degaba, kaire chada kada Salmos, chada e ulita gerule cha giti cha boidale ulita ene ba gwagedu kare chadi boi. ");
INSERT INTO sabNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Jesu ama ulita ta gbu ene, gire ama ulita tachku Jesu gerudu ngeru ama ole giti, ene Chube gerua degaba unsuialin Jesu giti sugedu ama ulitage. ");
INSERT INTO sabNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Jesu gerudu ama ulita ole: —Chube gerua degaba unsuialin gerule ene: “Chube nu Cristo gaba kagadale nga dba ai giti, Cristo boidale daga ngwale, ama jogedaleda, mongike gire ama be chkeni gwade. ");
INSERT INTO sabNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Geru e Cristo giti tragadale ngerule kwian una Jerusalénmuge ole, bigire geru tragadale kwian nga ulitage ole, geru tragadale kwian ulita kle age me no kwian ta jwlitedale Chube ole me age me no dare, gire kwian agedu me no ulita ngeru Chube be talla mlienga.” Chube gerua degaba unsuialin gerule ene. ");
INSERT INTO sabNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nege ba gwagedu agali chadi cha boidu ulia Chube gerua degaba unsuialin gerule kare, ba geru e tragadale kwian ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ba ulita cha keruchuge no, ulia cha be Chube Oña kage ba alin cha Ñenua gerudu kare. Ba manade aini una Jerusalénge gire Chube Oña be chie nga ngaña giti Chube ngwadi, Chube Oña be chke badi mo kira kete bage, ba be kira e gai gire ba be joge geru cha giti trage kwian ulita ole nga ulitage Chube Oña kiralla giti. ");
INSERT INTO sabNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jesu gerudu ene kwian ulita kle mo litaba ole gire Jesu kwian e ulita du una kada Betania ngnagu, jo chke kodi una ege gire Jesu ko gau ngaña gdabonate gerudu ama ulita ole: —Cha takalin Chube age no ba ulita alin ba ulita manade no diali, Chube ba ta gbe nga suga noare ole. ");
INSERT INTO sabNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Jesu kle gerule ene ama ulita ole gire Jesu jo chkenga ngaña kote siere ama ulitage, Jesu dule nga ngaña giti Chube kle ngwadi. ");
INSERT INTO sabNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Kwian ulita chegu gerule noare Jesu giti gire ama joni una Jerusalénge ta noare ole Jesu giti. ");
INSERT INTO sabNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ama ulita jo chkeni una Jerusalénge gire ama kledu diali u gerungwa Chube olege gerule noare Chube giti diali.");
INSERT INTO sabNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Gwangea nga ulita bebi dodadale Cristo klebi enebi, ama klebi Chube ole, ama Chube, ");
INSERT INTO sabNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","gwangea ama klebi enebi Chube ole. ");
INSERT INTO sabNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ama giti Chube nga ulita dodadu lle ulita dodadu, Chube ni lle gdaite dodadu sugekare amage. ");
INSERT INTO sabNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Cristo alin giti lle ulita gwade kwian ulita gwade. Ama kwian ta gbe suge kwian chagedale mine Chube takalin kare, ama jichra kare kwian ulita alin, ama kwian ta gbe suge salengwli jichra kle kwian gbe ten nga jereske kare. ");
INSERT INTO sabNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Kwian me Chube uñe chage nga jereske kare, Cristo chku jichra kare kwian ene alin, jichra chku chratigenga nga jere dbiguske, nga jere dbigu tadu jichra chra gwakalinda ene jichra me chratigenga dare, nga jere dbigu me ñadu jichra gweda. ");
INSERT INTO sabNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Chube kwian onbre gdaite kada Juan-Bautista kagu gerule no jichra giti kwian ulita ole. Juan-Bautista gerudu no trate jichra giti, ene kwian geru e keruchuge, ene kwian ulita ñage jichra uñe jichra gai ulia Juan-Bautista giti. ");
INSERT INTO sabNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juan-Bautista me jichra, ama gerunga alin jichra giti kwian ole. ");
INSERT INTO sabNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Jichra ulia chiu nga dba ai giti kwian ulita alin, ama kwian ta gbe Chube giti, ene suge kwiange Chube mine, jichra e Cristo. ");
INSERT INTO sabNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Cristo nga ulita lle ulita kwian ulita dodadu, Cristo ulita mauña. Ama chku nga dba ai giti kwianske agwa me chku uñale kwian ulitage ama chema. ");
INSERT INTO sabNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ama chagedu mo jwiage mo bitallanuske, ama bitallanu ulita me ama gau ngwange no. ");
INSERT INTO sabNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Agwa kwian bai kaire ama gau ngwange no kwian ama gau ulia, ama kwian ene gbu Chube oliale. ");
INSERT INTO sabNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Kwian chege Chube oliale me salengwli kwian ulita nga dba ai giti menga chebia kote kare, kwian nga dba ai giti age mau tale ama takalin kare ene ama kirogwa molen, agwa Chube kwian ta blite age Chube takalin kare, kwian ene chege Chube oliale, Chube ama ulita Ñenua. ");
INSERT INTO sabNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Chube Cristo kagu nga dba ai giti, ama chku kwian kare, ama toidu chagedu kwianske ama ta du no diali kwian ulita ole, ama agedu tanre no kwian alin, ene kwian gwage amadi chkedale uñale ama Ñenua mine ulia. Ama kledu kwianske agedu no ulita kwian alin gire cha chada ai deganga, cha ule cha chagemanalla ulita ole gwagedu amadi, ama agedu ulita uñale cha ulitage, uñale cha ulitage ama ulia Chube Kirolla gdaitre alin, ama mo Ñenua kirallaske agedu no ulita. ");
INSERT INTO sabNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan-Bautista gerudu no no kwian ole Cristo giti, Juan-Bautista gerudu ene: “Ai cha geruadu kwian ole be chie cha nate ama ma kweri chage, ama kledu ngeru chage, gwangea ama klebi enebi Chube ole.” ");
INSERT INTO sabNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Cristo diali age no che amanu ulita alin, diali ama kle age ma no dare che alin, ama ole age no ene diali me bidege. ");
INSERT INTO sabNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Chube Moisés ta gbu chada dege kwian ulita alin, ene suge kwiange kwian chagedale mine Chube gwa giti nga dba ai giti, agwa chada e giti me sugedu ulia kwiange Chube mine, geru ma trate ulia Chube giti Jesucristo chiu dbe kwian alin, ene nege Jesucristo giti suge kwiange Chube no kwian ulita ole Chube agedu no kwian ulita alin. ");
INSERT INTO sabNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ni kwian gdaite nu gwageba Chubedi, Chube Kirolla alin giti kwian Chube uñe, Chube Kirolla gdaitre alin ama kaire Chube, ama talla kle ule diali mo Ñenua ole. ");
INSERT INTO sabNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Kwian israelita chugagwalla ulita una Jerusalénmu kwian gau mne gdaite kagu geru kade Juan-Bautistage, kwian mne gdaite e gweale gerunga Chube ole daba alin, kwian na gerunga Chube ole daba alin chudaboanga, kwian e ulita jo chke Juan-Bautista kle ngwadi geru kadu Juan-Bautistage: —¿Ba chema? ");
INSERT INTO sabNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Juan-Bautista gerudu trate mau giti kwian ole: —Sbali Chube gerudu be kwian jwannga siere kage kwian alin, e Cristo, ba tañachuge cha Cristo, me ene, cha me Cristo. ");
INSERT INTO sabNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Kwian geru kadu nabitaite Juan-Bautistage: —Ba me Cristo, ¿ba chema? ¿Ba kwian Chube gerua ketanga dabage unsuialin kada Elías amaña chkuni? Juan-Bautista jaindunga: —Me ene, cha me ama. Kwian ulita jogeba chke Juan-Bautista ngwadi me ta chugu geru kade Juan-Bautistage, kwian gerudu Juan-Bautista ole: —Kwian Chube gerua ketanga dabage be chie, ¿ama ba? Juan-Bautista jaindunga: —Me dale, cha me ama. ");
INSERT INTO sabNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Kwian gerudu Juan-Bautista ole: —Ba me ama, ¿ba chema? Ba gerule cha ole ba chema ulia. Cha geru ba giti dbadale, cha geru ba giti ketadale cha kagangage, ¿ba agali gerule mine mau giti? ");
INSERT INTO sabNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Juan-Bautista jaindunga: —Cha kle age kwian Chube gerua ketanga dabage kada Isaías chada jigu degaba unsuialin cha giti gerule kare, cha gerunga kwian ole nga gballage Chugagwalla be chie giti, cha gerule kwian ole: “Kwian mo ta gbadale biale trate no Chugagwalla ngwange kwian kle jon lite trate biale chugagwalla ngwange kare.” Cha kle gerule ene kwian ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Kwian fariseo ulita nu kwian mneite kagaba tienda Juan-Bautistadi, ");
INSERT INTO sabNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ama geru kadu dare Juan-Bautistage: —Ba ulia me Cristo, ba me Elías, ba me kwian Chube gerua ketanga dabage be chie, ba me kwian e, ¿mineade Chube kalla giti ba kle daba ñe chiske gai ngaña chigage? ");
INSERT INTO sabNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juan-Bautista jaindunga: —Cha kle daba ñe chiske alin Chube kalla giti, agwa kwian gdaite kle cheske ma kweri chage, ba ulita bebi ama uñe, ");
INSERT INTO sabNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ama be chie cha nate ama ma no ma kweri ulita chage, cha me ñanaske ama chudaboangale ama zapatolla jwennga ama serage —Juan-Bautista gerudu ene mau giti kwian una Jerusalénmu kagaba ole. ");
INSERT INTO sabNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Boidu ene ulita una kada Betaniage, una e chege una Jerusalénge tanglegu chi Jordánge chkagu Juan-Bautista kledu kwian ñe chiske ngwadi, ne ngwadi kwian una Jerusalénmu geru kadu ene ulita Juan-Bautistage. ");
INSERT INTO sabNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","30","Nagbietege Juan-Bautista gwagedu Jesudi chie ama ngnagu, gire Juan-Bautista gerudu Jesu giti kwian ulita kledu ne ngwadi ole: —¡Gwagede, kwian e cha geruadu! Ama be mo chuge ngwadi jogeda kwian ulita alin bda cordero gwakle kwian kle age me no giti alin kare, Chube ama kagu nga dba ai giti kwian jwen siere ji chugege kwian age me no gdale. Cha gerudu ama giti kwian ole: “Be chie cha nate ama ma kweri chage, ama kledu ngeru chage, gwangea ama klebi enebi Chube ole.” Cha gerudu ene ama giti, nege ama kle chie che ngnagu. ");
INSERT INTO sabNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ngeru cha agalige me chku uñale be chie cha nate ama chema, agwa cha agedu cha kaganga Chube gerudu kare, Chube cha kagu cha kwian ñe chiske Chube kalla giti ene cha giti ñage chke uñale kwian israelitage chema be chie ama jwanngale siere. ");
INSERT INTO sabNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Cha agali me ama uñu agwa cha kaganga Chube gerudu cha ole: “Ba be kle kwian ñe chiske cha kalla giti, gire kwian gdaite be chie mo ñeange chiske bage, ama gití ba be gwage cha Oñadi chie, cha Oña be chege ama gití. Be boi ene gire be chke uñale bage kwian e amaña be cha Oña gbe kwian tale, ene kwian be chage cha Oña ole diali.” Chube gerudu ene cha ole, boidu ene ulita Chube gerudu kare, cha ama ñeu chiske gire cha gwagedu Chube Oñadi chie ngaña ama gití beusi kare, beusi e chegu jageba ama giti ngaña. ");
INSERT INTO sabNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Cha gwagedu Chube Oñadi chie ama gití Chube gerudu kare cha ole, e giti chku uñale chage trate ama Chube Kirolla —Juan-Bautista gerudu ene ulita Jesu giti. ");
INSERT INTO sabNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Nagbietege Juan-Bautista kledu nabitaite kwian ñe chiske gai ngaña chigage ngwadi, kwian gdaboke geru jwannga Juan-Bautistage kledu Juan-Bautista ole, ");
INSERT INTO sabNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","gire Juan-Bautista gwagedu Jesudi joge tangle kodi amage, Juan-Bautista gerudu Jesu giti: —¡Gwagede amadi! Chube ama kagu nga dba ai giti jogedaleda che ulita agedu me no giti alin bda cordero gwakle kwian kle age me no giti alin kare. ");
INSERT INTO sabNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Kwian boke geru jwannga Juan-Bautistage Juan-Bautista keruchugu gerule ene Jesu giti, gire geru jwannga Juan-Bautistage jo Jesu ole. ");
INSERT INTO sabNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Geru jwannga Juan-Bautistage chagedu Jesu nate, Jesu tiunda mo nate, Jesu gwagedu kwian geru jwannga Juan-Bautistage boke kle chage Jesu nate, Jesu geru kadu ama bokege: —¿Ba kle chage llema nate cha nate? Ama gerudu: —Kwian tkanga tangle geruge, ¿ba kle toi baini? ");
INSERT INTO sabNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesu gerudu: —Bai cha ole tienda cha kle toi ngwadi. Ama boke jo ule Jesu ole, jo chke Jesu kle toi ngwadi, ngabi chui jo chege bate no dbi giti, nga jere malen geru jwannga Juan-Bautistage boke me joni, ama chegu Jesu ole, nagbietege ama joni. ");
INSERT INTO sabNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Kwian boke e geru jwannga Juan-Bautistage Juan-Bautista keruchugaba gerule Jesu giti gire boke jogeba Jesu ole, gdaite kada Andrés, ama Simón-Pedro daballa. ");
INSERT INTO sabNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andrés jo siere Jesu kledu ngwadige gire blike Andrés jo mo daballa Simón jwen, ama takalin Jesu kaite daballage, Andrés gerudu daballa ole: —Sbali Chube gerudu be kwian jwannga siere kage kwian alin, e Mesías, nege ama kle cheske, ama skwendu chage. (Mesías amaña kada Cristo.) ");
INSERT INTO sabNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andrés gerudu ene Simón ole gire Andrés mo daballa Simón du Jesu kle ngwadi, Jesu gwagedu Simóndi Jesu gerudu Simón ole: —Ba kada Simón, ba ñenua kada Juan, agwa nege gwangerugu ba ka be chege jwandale Cefas, ka e amaña Pedro. ");
INSERT INTO sabNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Nagbietege Jesu mo ta gbu joge nga kada Galileage, nga ege Jesu tendu Felipe ngwange, Jesu gerudu Felipe ole: —Bai chagé cha ole geru jwen chage. ");
INSERT INTO sabNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipe ai toinga una kada Betsaidage, Andrés kaire Pedro una Betsaidamu. ");
INSERT INTO sabNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Felipe jo Natanael jwen Jesu kaitadale amage, Natanael skwendu Felipege undege gli kada higuera gdoge, Felipe gerudu: —Kwian gdaite skwendu chage, kwian e giti Moisés chada jigu degaba unsuialin kaire kwian Chube gerua ketanga dabage chada jigu degaba unsuialin kwian e giti, kwian e Jesu, ama José kirolla una Nazaremu. ");
INSERT INTO sabNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanael gerudu: —¿Ba tañachuge una Nazaremuge kwian gweale no chada kle degaba giti kare ñage chie? Felipe me ta chugu gerule Natanael ole, Felipe gerudu: —Bai gwage cha kle kwian geruadedi, ene suge bage chema cha kle geruade. ");
INSERT INTO sabNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Natanael jo Felipe ole tienda Jesudi, Jesu gwagedu Natanael chie kodi Jesu ngnagu, Jesu gerudu Natanael giti: —Ai ulia kwian israelita no, ama kle gerule ulia diali no daba ole, ama me chage sole daba ole. ");
INSERT INTO sabNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanael Jesu keruchugu gerule ene gire Natanael gerudu Jesu ole: —¿Baini ba cha uñe? Jesu gerudu Natanael ole: —Felipe bebi gerule ba ole cha giti gire cha gwagedu badi ba kledu undege gli kada higuera gdoge. ");
INSERT INTO sabNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Gire Natanael gerudu Jesu ole: —Kwian tkanga tangle geruge, ¡ulia ba Chube Kirolla ba kwian israelita ulita Chugagwalla! ");
INSERT INTO sabNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesu gerudu Natanael ole: —Cha gwagedu badi undege gli kada higuera gdoge, e giti alin ba cha gai Chube Kirolla, suge bage ulia cha me jo badige ba kledu ngwadi, agwa uñadu bage cha kle gerule kare e ulia, chui aige gwangerugu Chube kiralla giti cha be age tanre ma no aige ba gwa giti, ba me gwagebadi ba be gwagé. ");
INSERT INTO sabNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Kaire Jesu gerudu: —Cha gerule ulia ulia ba ole, aige gwangerugu cha giti ba ulita be gwage nga ngañadi be kle tigebanga kare, kaire ba be gwage lle boanga Chube alindige chage gwabdugu gwadbigu cha Chube Kirolla chieba kwian kare be kle ngwadi nga dba ai giti —Jesu gerudu ene ulita Natanael ole. ");
INSERT INTO sabNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Gire maikege kwian mo jwen chuia chku, kwian tanre kledu daba mo jwen chuia ollade una Caná nga kweri Galileage. ");
INSERT INTO sabNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","E suiale Jesu chebia kledu ule mo jwen chuiadi, Jesu kaire geru jwannga Jesuge jo kadaba mo jwen chuiadi. ");
INSERT INTO sabNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Kwian ngle kledu mo jwen chuia ollade gire uva chia gage bidu. Jesu chebia chegu tañachuge tanre uva chia gage bidu giti kwian kle mo litaba chuia ollade be llema jai, gire Jesu chebia gerudu Jesu ole: —Uva chia ulita bidu, uva chia me jale kwian alin. ");
INSERT INTO sabNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesu gerudu: —Cha chebia, ¿mineade ba gerule cha ole uva chia bidu? Chui be chke gire cha be lle no no boi Chube kiralla giti kwian gwa giti, ene kwiange be suge cha Chube Kirolla ulia. Agwa chui e bebi chke. ");
INSERT INTO sabNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Jesu gerudu ene chebia ole gire chebia gerudu kwian lle boanga mo jwen chuiage ulita ole: —Jesu ba kage age ba age ulita ama gerule kare. ");
INSERT INTO sabNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ke dodaba kantro kare, chi ogangwa ke kantrolla ege gbaite gbaitege chi joge chke litro ngle litro cincuenta. Ke kantrolla ege kwian israelita chi ogo ko gligagda diali, ene kwian israelita tañachuge ama mo ko glige ene ama no trate Chube gwa giti. Ke kantrolla gbadereke kledu ngwale chui ege kwian mo jwen chuiage. ");
INSERT INTO sabNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesu gwagedu ke kantrolla edi kle ngwale, Jesu gerudu kwian lle boanga ulita ole: —Ke kantrolla ai ulita gbe ete chi ole. Kwian lle boanga chi tku ke kantrollage gbadereke gbaite gbaite ulita gbu ete. ");
INSERT INTO sabNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Gire Jesu gerudu kwian lle boanga ole: —Ne gire ba chi jwen sidri ba kete kwian lle gbanga biale chui ollade alinge. Kwian lle boanga agedu ene Jesu gerudu kare. ");
INSERT INTO sabNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","10","Jesu chi blitu uva chia gagere, kwian lle gbanga biale chui ollade alin chi e jau sidri, amage sugedu uva chia gage no, me uñadu amage uva chia e no kledu ogaba baini, agwa kwian lle boanga alinge uñadu, ama ulita chi jun chi tku ke kantrollage, chi e Jesu blitu uva chia gagere. Kwian lle gbanga biale chui ollade alin ta me chegu suga no, ama kwian onbre mo jwannga chui ege kadu, ama gerudu kwian mo jwannga ole: —Kwian kle chui ollade, diali chui ollade mauña kle uva chia gage no kete jondege daba kadaba ulitage, daba kadaba ulita kle uva chia no jai ngle gire chui ollade mauña kle uva chia me no kete bdagli jadale, agwa ba me agedu ene, ba uva chia ma no jigu ogaba jadale bdagli. ");
INSERT INTO sabNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jesu chi blitu uva chia gagere una Caná nga kweri Galileage, e gwangea Jesu agedu Chube kirallaske kwian gwa giti, e giti Jesu takalin suge trate kwiange ulia ama Chube Kirolla. Kwian geru jwannga Jesuge ama ulita Jesu gau ma no ulia Jesu chi blitu giti. ");
INSERT INTO sabNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Boidu ene ulita una Caná nga Galileage gire Jesu jo una Capernaumge, chebia, daballa ulita, kaire geru jwannga Jesuge ulita jo ule Jesu ole chegedale una ege chui gwealege alin. ");
INSERT INTO sabNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Kwian israelita ulita kle tachke Chube kwian israelita enusulian unsuialin jun siere nga kweri Egiptoge giti, e Pascua chuia, e chuia ollade chegu kodi gire Jesu jo una Jerusalénge kwian israelita ulita be chui ollade ngwadi. ");
INSERT INTO sabNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Jesu kledu una Jerusalénge gire ama jo u gerungwa Chube olege, u ege kwian chbi lle boagda chbadanga tanre kle, kwian bda oveja chbadanga tanre kle, kwian beusi chbadanga tanre kle, kaire kwian tanre kle toiba dba nga igi blitangwage kle igi blite daba na ole, kwian ene ulita skwendu Jesuge age ene u ege. ");
INSERT INTO sabNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jesu gwagedu kwiandi bda chbade u ege Jesu giska jun giska gwliu daba jegwale, giska e giti Jesu chbi, oveja ulita kagu siere u gerungwa Chube olege ule kwian bda chbadanga ole, kaire Jesu kwian igi blitanga kagu siere, Jesu igi ulita mliudba tangle kaire mesa igi blitangwa Jesu mesa e blitunga ulita. ");
INSERT INTO sabNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Jesu gerudu beusi chbadangage: —Ba beusi ulita jwen siere u aige. U ai me bda chbadangwa, u ai me bda gigangwa, u ai me igi gangwa bda ñanale, u ai gerungwa cha Ñenua ole alin allabi. ");
INSERT INTO sabNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Kwian geru jwannga Jesuge gwagedu Jesudi age ene, kwian geru jwannga tachku geru kle degaba sbali Jesu giti gerule ene: “Chube cha Ñenua, cha takalin u gerungwa ba ole kwian gai gerudale ba ole alin allabi, u e me lle na boangwa, cha mi kwian chuge ngwadi age dare ama be ta agekalin kare, e giti cha be tañachuge tanre, cha be ta lle boakalin no kwianske ba takalin kare.” ");
INSERT INTO sabNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jesu agedu ene kwian bda chbadanga ole u gerungwa Chube olege gire kwian israelita chugagwalla ulita kledu eni geru kadu Jesuge: —¿Chema ba kagu age ene aini u aige? ¿Bage suge Chube ba kagu? E ene ulia ba lle gweale daga ngwale no dodade Chube kirallaske cha gwa giti ene chke uñale cha ulitage ulia Chube ba kagu. ");
INSERT INTO sabNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesu jaindunga ama kalen: —Noare, cha be age ene ba gwa giti, ba u ai skiendba ulita gire chui gbamaire alin cha be u gbeni naskuni no biale. ");
INSERT INTO sabNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Kwian israelita gerudu Jesu ole: —U ai jo dodaba chura ngle chura cuarenta y seis gire u ai kweri dodadre ulita. U ai be kle skianbada gire ¿ba be u gbeni naskuni biale chui gbamaire alin allabi? ");
INSERT INTO sabNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Kwian israelita gerudu ene ama tañachugu ulia Jesu kledu gerule u gerungwa Chube ole giti, agwa Jesu me gerudu ama ole u e giti, Jesu gerudu mau giti kwian israelita ole, gerudu ama be jogeda giti kaire ama jaba be chkeni gwade giti. ");
INSERT INTO sabNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","(Chui chku gire Jesu boidu ulia Jesu gerudu kare, Jesu jokeda, Jesu jaba chkuni gwade mongikege, boidu ene ulita gire kwian geru jwannga Jesuge ulita tachku Jesu gerudu mau giti kwian israelita ole, e giti kwian geru jwannga ulita Chube gerua degaba unsuialin Jesu giti gau ma no, kaire ama ulita Jesu gerua mau giti gau ulia.) ");
INSERT INTO sabNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jesu kledu Pascua chuia ollade ule kwian israelita ulita ole una Jerusalénge, chui ege Jesu lle tanre daga ngwale no dodadu Chube kiralla giti kwian me ñage dodade kare mo kiralla giti, e giti kwian tanre Jesu gau ulia, kwiange sugedu Chube ama kagu ama Cristo. ");
INSERT INTO sabNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","Jesuge sugedu trate kwian ulita me kle mo ta gbe ulia Jesu gai mo tale, agwa kwian Jesu gau ulia mo chugale alin Jesu lle daga ngwale no dodadu alin giti kwian gwa giti, malen Jesu kledu ta giti kwian eske, chku uñale ulita Jesuge kwian ulita talla mine. Ni kwian gdaite gerudu Jesu ole kwian ta mine, agwa Jesu tale Jesu agali kwian ulita ta uñe trate. ");
INSERT INTO sabNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Kwian fariseo ulitaske onbre gdaite kada Nicodemo, onbre e daba israelita chugagwalla gdaite. ");
INSERT INTO sabNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Chui gbaite ngajrege Nicodemo e jo tienda Jesudi gerule Jesu ole, Nicodemo gerudu: Nicodemo geru trage Jesu ole —Kwian tkanga tangle geruge, chage uñale kaire kwian na tanrege uñale Chube ba kagu cha ulita tke tangle Chube giti. Diali ba kle lle daga ngwale no dodade kwian gwa giti, e giti suge trate chage ba kle age Chube kiralla giti, Chube me kle ba ole ba me ñage age ene ba kle age kare. ");
INSERT INTO sabNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesu gerudu Nicodemo ole: —Cha gerule ulia ulia ba ole, kwian me menga nabitaite me ñage joge Chube ngwadi, kwian ene me Chubenu. ");
INSERT INTO sabNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemo geru kadu Jesuge: —¿Mine che be menga nabitaite? Che juma me ña mo blite soli menga nabitaite kirogwa kare. ¿Che juma mine ña jogeni nabitaite chebiadíge gire menga chebia kote kwaite? ");
INSERT INTO sabNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesu jaindunga: —Cha gerule ulia ulia ba ole, kwian ulita menga nge jondege soli chebia kote, menga ene alin allabi giti kwian me Chubenu me ñage toi Chube ole, agwa kwian ulita mo ta chugadale ngwadi Chube Oñage mo ta blite, ene ama Chubenu, be toi Chube ole, e salengwli kwian menga nabitaite kare. ");
INSERT INTO sabNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Kwian menga chebia kote nge jondege soli che ña gwage kwian soli mine, che ñage gwage amadi. Agwa kwian menga nabitaite Chube Oña giti Chube Oña kwian ta blite, edi che me ten mo gwagwa giti. ");
INSERT INTO sabNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ba me chege tañachuge mineade cha gerudu ene ba ole: “Kwian ulita medalenga nabitaite.” ");
INSERT INTO sabNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Mledi ba me ten, agwa ba jegwalege mle suge, kaire ba mle keruchuge, agwa me uñale bage mle kle chie nga bainige kle joge nga bainige, mle tiennga ngage ulita baini kaire ta tienkalinnga ama joge. Ene kaire Chube Oña kwian ta gbe menga nabitaite kare, Chube Oña kwian ta blite Chube ole, edi kwian me ten, agwa suge kwiange mo tale kwian ta me nge kare. ");
INSERT INTO sabNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemo geru kadu dare: —¿E ñage boi mine ene ba kle gerule kare? ");
INSERT INTO sabNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesu gerudu Nicodemo ole: —Ba daba israelita tkanga tangle no geru ulita giti, ¿mineade geru ai kare cha gerudu giti me suge bage? ");
INSERT INTO sabNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Cha ule kwian geru jwannga chage ulita ole gerule no no Chube Oña kwian ta blite giti, uñale cha ulitage Chube Oña kwian ta blite ulia, Chube Oña kwian ta blitabadi cha ulita gwagedu, kwian ene kle chage Chube takalin kare, e giti cha ulita kle gerule ba ole kaire ba bitalla ole, agwa ba, ba bitalla me kle cha ulita kerua gai ulia cha ulita kle gerule giti. ");
INSERT INTO sabNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Cha geru ñachuge ba alin lle nga dba ai giti ba kle gwagedi gire geru e me suge bage, cha geru ñachuge giti ba me cha kerua gai ulia ba mi ñage cha kerua gai ulia cha gerule Chube giti ba ole, edi ba me kle gwagé. ");
INSERT INTO sabNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ni kwian gdaite nga dba ai giti jo nga ngaña giti Chube kle ngwadi gire chiuni nga dba ai giti geru kete kwian ulitage Chube giti, cha alin allabi kledu nga ngaña giti chiu nga dba ai giti gerule kwian ole Chube giti, cha ama Kirolla, ama cha kagu nga dba ai giti kwian kare. ");
INSERT INTO sabNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Unsuialin Moisés hierro dodadu jorisire, Moisés gli dagu dbige jorisi oña e gbangwa ngaña, ene kwian lentigeba jorisige gwage jorisi oñadi ngaña ama joge chke noni. Moisés agedu jorisi oña ole kare, ene kwian be age cha ole, kwian be cha gbe kruge ngaña, ");
INSERT INTO sabNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ene kwian ulita bai kaire cha gai ulia be toi no chui tangle diali Chube ole nga ngaña giti. ");
INSERT INTO sabNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Chube no no kwian ulita ole, malen ama mo Kirolla gdaitre alin kagu nga dba ai giti kwian ulita alin, ene kwian ulita bai kaire Chube Kirolla gai ulia mi chege sugekare Chubege ji chuge, be toi no chui tangle diali Chube ole nga ngaña giti. ");
INSERT INTO sabNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Chube me mo Kirolla kagu nga dba ai giti kwian ulita gbe jiske age me no giti gdale, Chube mo Kirolla kagu kwian ulita jwen siere ji chugege kwian age me no gdale. ");
INSERT INTO sabNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Kwian ulita bai kaire Chube Kirolla gai ulia me chege jiske dale age me no giti gdale, agwa kwian ulita bai kaire me Chube Kirolla gai ulia kwian ene chege jiske age me no giti diali, ama me Chube Kirolla gdaitre alin gai ulia Chube Kirollale mo jwanngale siere ji chugege age me no gdale, ");
INSERT INTO sabNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","20","kwian ene chege jiske diali age me no gdale. Kwian kle age me no kle age nga jereske kare, Chube Kirolla chku nga dba ai giti jichra kare kwian ene ulitaske, agwa kwian mo ta gbaba age me no diali kwian ene me no jichra ole, me ta jogekalin jichra kle ngwadi, ene ama kle age giti me no me chke uñale, ama ta chegekalin nga jereske kare age me no diali ama ta agekalin kare. ");
INSERT INTO sabNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Agwa kwian bai kaire kle chage Chube takalin kare, ama no jichra ole, ama joge jichra kle ngwadi, ene ama kle age ulita chke uñale ama kle age no Chube takalin kare. ");
INSERT INTO sabNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Jesu gerudu ene ulita Nicodemo ole gire Jesu jo kwian geru jwannga Jesuge ulita ole nga kweri Judeage, nga Judeage Jesu chegu chui sbali ule kwian geru jwannga ole, nga ege Jesu kwian geru jwannga amage ulita gbu kwian ñe chiske gai ngaña chigage Jesu kalla giti. ");
INSERT INTO sabNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Kaire Juan-Bautista kledu kwian ñe chiske una na kada Enónge kodi una Salimge, una ege chi tanre kle, kwian ngle jo Juan-Bautista kle ngwadi mo ñeange chiske Chube kalla giti. ");
INSERT INTO sabNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Juan-Bautista kledu kwian ñe chiske ene, e suiale Juan-Bautista bebi joge skage. ");
INSERT INTO sabNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Chui gbaite kwian geru jwannga Juan-Bautistage ulita kira batu kwian israelita gdaite ole kwian ñe chiske giti, kwian geru jwannga Juan-Bautistage gerudu Juan-Bautista giti Juan-Bautista kwian ñe chiske kwian chege ma trate, kwian israelita gerudu Jesu giti kwian geru jwannga Jesuge kwian ñe chiske kwian chege ma trate. ");
INSERT INTO sabNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Kwian geru jwannga Juan-Bautistage ulita jo gerule Juan-Bautista ole: —Cha tkanga tangle geruge, cha gerule ba ole kwian gdaite giti kledu ba ole chi Jordánge tanglegu, ama giti ba gerudu no cha ole, ama ngwadi kwian ulita kle joge, ama kle kwian geru jwannga amage ulita gbe kwian ñe chiske, nege kwian ulita kle chage ama nate. ");
INSERT INTO sabNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Juan-Bautista gerudu kwian geru jwannga amage ole: —Chube me kle kwian ole kwian me ñage age Chube kiralla giti. ");
INSERT INTO sabNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Cha gerudu kwian ole ba gwa giti, ba ulita cha keruchugu gerule trate mau giti cha me Cristo, Chube cha kagu Cristo ngeru kwian ulita ta gbe ama gai ngwange no. ");
INSERT INTO sabNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nege ama chku, kwian kle chage ule ama ole, e giti nga chege suga no no chadi. E salengwli kwian onbre be mo jwen chuialla gbe, ama be skatemanalla gdaite gbe lle ulita gbe biale mo jwen chuiage alin. Mo jwen chuia chke gire onbre, muire kle ule, ulita kle no. E giti skatemanalladi nga be chege suga no no. Ene kaire nga suga no chadi Cristo chku kwian kle chage ule ama ole. ");
INSERT INTO sabNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Cha takalin Cristo chege ma kweri chage kwian gwa giti, cha chege soli kwian gwa giti. ");
INSERT INTO sabNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Cristo chiu nga ngaña giti Chube kle ngwadi chku nga dba ai giti, ama kwian ulita mauña. Kwian nga dba ai giti nga dba aimu, ama gerule lle nga dba ai giti alin giti. Cristo chiu nga ngaña giti Chube kle ngwadi, ama kwian ulita mauña nga ulita mauña, ama geru nga ngaña giti alin trage kwian ole, ");
INSERT INTO sabNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","amage ulita uñale ama gwagedudi ama keruchugu nga ngaña giti Chube kle ngwadige, ama geru e alin trage kwian ole, kwian bedre alin ama kerua gai ulia ama kle gerule kare. ");
INSERT INTO sabNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Kwian bai kaire mo ta gbe Cristo kerua gai ulia ama gerule kare, kwian ene kle Chube gai ulia kaire. ");
INSERT INTO sabNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Chube mo Kirolla kagu nga dba ai giti, Chube Kirolla kle Chube gerua trage kwian ole, Chube kle mo Oña kage diali Kirolla alin, me kle Kirolla chuge ngwadi ama gerua trage gballa. ");
INSERT INTO sabNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ñenua Chube no mo Kirolla ole, ama lle ulita gbu mo Kirolla kote. ");
INSERT INTO sabNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Kwian ulita bai kaire mo ta gbe Chube Kirolla gai ulia mo alin be toi diali chui tangle Chube ole nga ngaña giti, agwa kwian ulita bai kaire me Chube Kirolla gai ulia mo alin, kwian ene be chege sugekare Chubege chui tangle diali, Chube be ji gbe mno kwian ene alin diali —Juan-Bautista gerudu ene ulita kwian geru jwannga amage ole Jesu giti. ");
INSERT INTO sabNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Geru chku uñale kwian fariseo ulitage kwian ngle kledu chage Jesu nate Jesu gerua jwen kaire mo ñeange chiske Jesuge (Jesu agali me kwian ñeu chiske, agwa Jesu kwian geru jwannga amage ulita gbu kwian ñe chiske). Kwian geru jwannga Jesuge kledu kwian ma ngle ñe chiske Juan-Bautista kledu kwian ñe chiskege, e me skwendu no kwian fariseoge. ");
INSERT INTO sabNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Kwian fariseo me ta chegu no Jesudi chku uñale Jesuge, malen Jesu jo siere nga kweri Judeage Jesu kledu ngwadi, Jesu joni chage naskuni nga kweri Galilea ngnagu ule kwian geru jwannga amage ulita ole. ");
INSERT INTO sabNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Jon joge nga Galileage joge nga kweri Samaria sketangle, ");
INSERT INTO sabNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","malen Jesu jo chke nga Samariage una kada Sicarge, una e chege kodi José dbiage, unsuialin Jacob dbi e ketu mo kirolla Josége, ");
INSERT INTO sabNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","dbi ege Jacob nu chi gwagwa dbiugalla dodaba. Chui jo chke bduke Jesu jo chke chi gwagwa e amañage, Jesu skwatigu tanre chagege jonkare, malen chi gwagwa edi Jesu toidu dba undege chi gwagwa kagdage. ");
INSERT INTO sabNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Jesu chegu undege ne ngwadi gire kwian geru jwannga amage ulita jo unaske bligda gige gutadale, kwian geru jwannga ulita jo skate bligda gige gire muinga gdaite nga Samariamu chku chi gwagwadi chi jwanle, gire Jesu gerudu muinga e ole: —Cha siechie, cha takalin ba chi jwen cha alin jadale. ");
INSERT INTO sabNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Uñadu muingage kwian israelita me no kwian nga Samariamu ole, malen muinga nga Samariamu gerudu Jesu ole: —Ba kwian israelita, ¿mineade ba chi kade chage cha muinga nga Samariamuge? ");
INSERT INTO sabNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesu jaindunga: —Noare bage suge chema kle gerule ba ole, cha giti Chube ta chi no ketakalin bage. Suge trate ene bage, ba chi kade chage blike, ene cha chi gwade kete bage. ");
INSERT INTO sabNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Muinga gerudu: —Ba ole chi jwanngwa me, dbiuga jere chi jwanngwa, ¿ba be chi jwen mine ketadale chage? ¿Ba chi gwagwa gwade molen baini? ");
INSERT INTO sabNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Cha enusulian unsuialin Jacob kledu gwade ama chi ai jau, ama kirolla ama bdadalla kaire chi jun aini jadale, Jacob chi gwagwa ai jigu bdadalla oindalla ulita bdagli alin jadale. Cha enusulian alin ñadu chi gwagwa ai dodade, ¿ba tañachuge ba ma kweri cha enusulian Jacobge chi na ma no kete chage? ");
INSERT INTO sabNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesu jaindunga: —Kwian ulita kle chi gwagwa ai Jacob nu jigaba jwen, kwian ulita chi ai jai sie ole, diali kwian be siechie nakwaite, kwian be ta chi ai jakalin diali. ");
INSERT INTO sabNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Agwa cha chi kete kwiange jadale kwian mi siechie dare, chi e chege diali jrite ama tale, chi gwade no trate ngaintra diali, e giti kwian be toi diali chui tangle. ");
INSERT INTO sabNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Muinga gerudu: —Ba gerule noare chi giti, ba chi e kete chage, ene cha chi e ba kle geruade jai cha mi siechie dare ni cha be chie chi jwen dare chi gwagwa aige jadale. ");
INSERT INTO sabNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesu gerudu dare muinga ole: —Joga ngeru ba ñengula jwen ba chieni ama dbe ule aini. ");
INSERT INTO sabNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","18","Muinga jaindunga Jesu kalen: —Cha me mo ñengulallage. Jesu gerudu: —Ba kle gerule trate ulia cha ole ba me mo ñengulallage, ba mo jun onbre gdatiga ole gdaite gdaite, ba ama ulita gdaite gdaite chugu ngwadi, nege ba kle chage onbre na gdaite ole, onbre e ba kle chage ole me banu. ");
INSERT INTO sabNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Muinga Jesu keruchugu gerule ene ulia muinga kle age giti, gire muinga gerudu Jesu ole: —Chage suge ba kwian kweri Chube gerua ketanga dabage. ");
INSERT INTO sabNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Muinga gerudu ene Jesu ole gire muinga jwichuga kle kodi ama kledu ngwadi kaitu Jesuge: —Gwagede jwichuga edi, jwichuga e giti ngaña diali cha enusulian nga Samariamu unsuialin Chube olladu, kaire nege cha cha bitalla ole kle joge jwichuga e giti eni alin Chube olladadale. Agwa ba kwian israelita ulita kle gerule kwian ulita jogedale una Jerusalénge, llani alin u gerungwa Chube ole kwian ñage Chube ollade. ");
INSERT INTO sabNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesu gerudu muinga ole: —Ba cha keruchuge ba cha kerua gadale ulia, chui be chke gire ba kwian nga Samariamu ulita be ñage Ñenua Chube ollade nga baini kaire ba be kle ngwadi, ba mi tañachuge dare joge jwichuga ege ni tañachuge joge una Jerusalénge Chube olladadale. ");
INSERT INTO sabNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nege ba ulitage me uñale trate ba kle chema ollade, agwa cha kwian israelita ulitage uñale cha kle chema gai ulia mo Chubeale cha kle chema ollade, uñale 