﻿USE sofia;
DROP TABLE IF EXISTS sofia.rwo_rawa_vpl;
CREATE TABLE rwo_rawa_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES rwo_rawa_vpl WRITE;
INSERT INTO rwo_rawa_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Nga oni nga ngu, Yisas Krayisro osi sembeni. Yisas ngu ene Dewitro sowe. Ko Dewit ngu ene Ebarahamro sowe. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ebaraham ngu ene Ayisak eweyi, Ayisak ngu ene Yekob eweyi. Yekob ngu ene Yuda, ko konebeyi nguro awaye. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda ngu ene Peres, Sira eraga awayari. Namoyari ngu Tema. Peres ngu ene Hesaron eweyi. Hesaron ngu ene Ram eweyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ko Ram ngu ene Aminadap eweyi. Aminadap ngu ene Nason eweyi. Nason ngu ene Salomon eweyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ko Salomon ngu ene Bowas eweyi. Nemi ngu Rehap. Bowas ngu ene Obet eweyi. Nemi ngu Rut. Obet ngu ene Yesi eweyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yesi ngu ene Yuda oniro sobosobo koreteyingo oowooyi Dewit, nguro eweyi. (Mayika 5:2) Dewit ngu ene Solomon eweyi. Nemi ngu kuri Yurayiya bareyi oruwo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon ngu ene Riyabowam eweyi. Riyabowam ngu ene Abayisa eweyi. Abayisa ngu ene Asa eweyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ngu ene Yehosapat eweyi. Yehosapat ngu ene Yoram eweyi. Yoram ngu ene Asayiya eweyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Asayiya ngu ene Yootam eweyi. Yootam ngu ene Ehas eweyi. Ehas ngu ene Hesekayiya eweyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekayiya ngu ene Manasa eweyi. Manasa ngu ene Emos eweyi. Emos ngu ene Yosayiya eweyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosayiya ngu ene Yekoniya, ko konebeyi nguro awaye oodoni, ngu naruno mundi oni Babilonnonggo Iserel oni yoyoro yoyokootoyi, Babilon merako oororo oriyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ngu naruno, ene Babilon merako oodoyi, Yekoniya ngu ene Siyalitiyel eweyi. Siyalitiyel ngu ene Serababel eweyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serababel ngu ene Abayiyud eweyi. Abayiyud ngu ene Ilayiyakim eweyi. Ilayiyakim ngu ene Eso eweyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Eso ngu ene Sedok eweyi. Sedok ngu ene Ekim eweyi. Ekim ngu ene Ilayiyud eweyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ilayiyud ngu ene Eliyesa eweyi. Eliyesa ngu ene Matan eweyi. Matan ngu ene Yekob eweyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yekob ngu ene Yosep eweyi. Yosep ngu ene Mariya kameyi oode, Mariyando Yisas bisiyoyingo. Yisas ene Krayis Anutdo noore yoyowero sunggi yeyingo oni ngu. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Nguro ngu, Ebarahamro sowe bidodo omburo, wenga Dewitno nguro osi sembesembeni kande eraya kegidemboro namoraya yokoyingo. Dewitro sowe bidodo omburo, wenga ene osisambaye kande eraya kegidemboro namoraya oororo, Babilon mundi onindo ngu, Iserel oni yoyoro, Babilonno yoyokoyingo. Yoyokootoyi, Babilon merako oruwonggoku oodoyi, wenga omburo, nguro sembesembeni nguya bidodo kande eraya kegidemboro namoraya oororo, Yisas Krayis tunooteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yisas Krayis bisiyootoni tunooteyingo, nguro mande ngu ngandiro. Nemi ngu Mariya, ene kuri Yosepdo Yon, ero rogo teyingo. Ene gobooro ma oriyingo naruno, Yuka Kundingiyi, ngundo Mariya yeni, ene kawuyidodo teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Kameyi Yosep, ngu oni nenengo oorengo, nguro ene Mariya oni doongeyemo oyimo inowero ma ingoyingo. Ngundiro nguro, ene torigemangge yokoweroyimboro ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Yosep nguro ingondandangerootoni, ngu naruno nguno, gabono ngu Oo Simburi Simbunanimboro sambono Engel oni, eneno tunootero eyingo. Yosep, Dewitro osiyi, ge barege Mariya ngu yowero ma sosorewero. Ndadiro nguro, nga simoongongga kawuyimo inowokungga, ngu Yuka Kundingiyimbo inowo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ngu simoongga kawuyimo oorooteku, ngu bisiyootoningga ngu, gedo ngu oowooyi Yisas eya e. Ndawugaro nguro, ngundo enengo simoo barero weti mbumbuwa andangeyunoro ko yoyowa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","Yo, Yuka Kundingiyimbo ngu simooyengga ngu yeni tunootewoku, ene Oo Simburi Simbunani, ngundo Anutro ingondudu eyingo oni manggowoomo, kuri ngandiro eyingo. Ingoyi, bare gura ene simooya ma wereyingomu, ngu ene kawuyidodo tero simoongga bisiyowa. Ngu oowooyi Imanuwel ewanggo. Ero eyingo. Yo, nga mandega nga Anutro ingondudu eyingo oni, enendo kuri eyingomu, ngu ataga enggeni tunootete. Imanuwelngga nguro muri ngu ngandiro: Anut nooreya yowuruwooteto. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yosep werewoku, ngunonggo ene ootoogero, Anutro sambono Engel onindo ewoku, ngundiro teyingo. Ene bareyi Mariya yoro, enengo yano uyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ene Yosep Mariya nguya ma wereyingo. Kini, ene ngundiro kingo oode oode oororo, Mariya simoo bisiyoyingo. Simoonggaku bisiyootoni ngu, oowooyi Yisas eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ngu naruno nguno ngu, Herod ene Yuda oniro tabango koreteyingo oruwokuno, Mariyando Yisas Betelehem endemo, Yudiya merasina nguno bisiyoyingo. Mariya kuri Yisas bisiyootoni ngu, ingondudu oni gidega ogisa ooretekusinanggo ngu, Yerusalem endemo mayero, sumoo eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Yuda oniro sobosobo koreteyingo urungga nemimbo keta simooye bodaga bisiyootoni tunootewoku, ngu ndano? Noore komo enengo tootungga ogisa ooretekusinanggo kenoro, ngu keyoro, nguro noore yade yade omburo, nguro yambo mande teyinowero mayetetoku nga! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Mande ngundiro etoyi, mera sobosobo koreteyingo Herod ngu mandegaku ingoro, ene soriyokoyingo. Ngundiro nangge, Yerusalemno oni simoo bare bidodo, ene nguya ngu mandega ingoro soriyokoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ngundiro nguro, Herodndo Anutno wooro yeyingo oni nguro sobosobo oniku, ko Iserel oni mamana mande etuyeroyingo oni ngudodo yowuruyeroro, sumoo yunoro eyingo. Krayis ngu ndawu endegano tunootewa, ero sumoo yunoro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Sumoo yunootoni, ene mande gumi ngundiro eyingo. Betelehem endemo Yudiyasina nguno tunootewa, ero eyingo. Anutro ingondudu eyingo onindo ngandiro ero nakangoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ye Betelehem oni simoo bare Yuda oniro merako oorootenggoku, yengo ende ngundo ende bidodo dagayeroro, ngu oowooyidodo urungga. Ndadiro nguro, yeno nguno ngu sobosobo oni urungga tunootewaku, ngundo ngu, noro oni Iserelno nguro sobosobo urungga oruwa. Yo, ngu sobosobo oningga, ngundo Yudaro sobosobo oni bidodo ko tewonggoku, ngu dagayerowa. Ngu oningga ngundo mande gome nenengo ngu ero yunororuwa, eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Herodndo ngu mande ingoro, nguro ene torigemangge ingondudu oni ogisa ooretekusinanggo mayeyingoku, ngu negoyerootoni ombuyingo. Ombutoyi, sumoo sumoo yunoro eyingo. Ndawu narunggano ngu tootungga ngu koretero kenootoyi tunootewo? Ero sumoo yunoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ene mande gumi ingoro eyingo. Ye sodedomangge Betelehemno ooroya, ko yanggango teya, ngu simooyengga ngu ereweya kenoyi. Ye ooroya kenoya ngu, arisa, ombuya, nono mande gumi etoyi ingowano. No ingoro ngu, asa, no nguya oororo, eneno esosooteyinowano, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Arisa, Herodro mande ewoku ingomukoro ngu, ene endesina oorero, sa ooretekusina, ngunonggo tootungga kenoro keyowonggoku, ngu ko kenoro, nguro ene oni oni urungga teyingo. Ngundiro tetoyi, tootungga ngundo ene ingondududodo oni ngu koretero oorero, simoo buniyo, Yisas oorooteku yanggaku ngu etuyeroro, ngu sanganimo oriyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Tootunggaku nguno oodoni, oniku ya newendemo uro, ene simooyenggakuya, nemi Mariya nguya, yeyoyingo. Yeyoro, ene boodooye oondoogero, bagootero, Yisasno yambo mande tero, esosooteyinoyingo. Teyinoro, enengo Pawus andangero, oo gome gome uriyi urungga ngu yoro, duwoo kingo inoyingo. Ene digi beye gol, ko, de eraya nguro sidumi ngu wooro yetoyi, ndindingo gome teweroyi, ngu yoro, kingo duwoo Yisas inoyingo. Ngundiro tero, ene Yisas bingaminidodo teyinoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ngu suwoono, Anutdo ingondudu onikuno gabono yootunoro eyingo. Ye Herodno ko ma oorowuwero. Ndawugaro nguro, Herodndo Yisas ureyi kumooweroyimboro, ero eyingo. Nguro ene ingoro, oororo, Herodno ko ma oorowuyingo. Kini, ene oororo, oore gurawoore ko enengo endemo sayingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ingondudu oniku kuri satoyi ngu, suwoono Yosep gabono kenootoni, Oo Simburi Simbunani, nguro sambono Engel onindo eneno yootunoro eyingo. Ge komo sodedomangge ootoogeya, barege ko nangongge yoyoya, Igip merako toongeya oorowu. Ge Igip merako nguno oodoga, nenengombo ko etoowega, ko ombuyi. Ndadiro nguro, Gabuman oni tabango urungga Herod, ngundo simooye yeyoro, yureyi kumoowero, mande ngundiro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Engeldo ngundiro etoni, Yosep ngu ingoro, asa, ene suwoono nangge ootoogero, nangoni ko bareyi Mariya nguya yoyoro, yade yade Igip merako oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Yosep ngu merako oodoni, nguno oni tabango urungga Herod ngu kumootoni, nguro ene Igip mera yokoro toongeyingo. Ngundiro tetoni ngu, asa, Anutro mandeno, ingondudu eyingo oni manggowoomo eyingo ngu engge tunooteyingo. Ene ngandiro eyingo. Nenengo nangone Igipno oorooteku, ngu meno etoowe ombuwa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ngu naruno, Gabuman oni tabango urungga Herod ene ingowoku, ingondudu onindo ogisa ooretekusina, ngundo ganangoro sayingo. Arisa, ene newende sanggiri urungga oorengo teyingo. Ngundiro tero, enengo me oni sureyerootoni oororo, Betelehemno, ko, ende Betelehem namokono nguya simooye owita dagoma eraya ma yokoyingomu, ko, simooye dagomaye eraya nguya, ngu yureyi kumoomukoyingo. Ndadiro nguro, ingondudu oni, ngundo tootu dagoma eraya kuri koretero tunooteyingo ngu etoyi, ingowoku, nguro ene ngundiro teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","Ngu ooku kuri Anutro ingondudu eyingo oni, Yeremayiya, ngundo eyingo ngu, ataga engge tunootete. Ngu ngandiro eyingo. Ene manggoye gura Rama ende Yudasinanonggo ingowonggo. Ene sendo moguru biyobiyomi tero, nowoondoyi tewonggoku, ngu ingowonggo. Resel (Iserel oni simoo bare) enengo simoongokuro sendoro biyomi ingoyingo. Oni simoo baredo newende yeyi, imakeweroyi nguya kini. Ndadiro nguro, simoongo gura ma yokoyingo, ngu bidodo utomukoyingo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","20","Yosep bareyi ko nangoyari Igip merako oodoyi, ngu naruno nguno, Gabuman oni tabango urungga Herod ngu kumooyingo. Kumootoni ngu, Oo Simburi Simbunani, enengo sambono Engel onindo Yosepno omburo, gabono yootunoro eyingo. Ge ootoogeya, Mariya eranasa yoyoya, Iserel, ko oorowu. Oningga nangongge ureyi kumooweroyinggaku, ngu kuri kumooyingo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Arisa, Yosep mande ngu ingoro, ene ootoogero, Mariya eranasa yoyoro, Iserel merako ko oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ene Akeleyasndo eweyi Herodro kongga ngu yoro, Yudiya mera nguro tabango urungga oruwoku, ngu Yosep ingoote. Ngundiro nguro, Yosep nguro sosoretoni, nguro gabo gurano Anutdo Yosepno yootunoro eyingo. Ngundiro nguro, ene Galili gumisina oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ene oororo, ende oowooyi Nasaret nguno bibiteyingo. Nguno ngu, kuri Anutro ingondudu eyingo oni nguro mandeye ewoku, ngu ataga engge ngundiro tunootete. Ene Nasaret oni ewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ngu naruno, sonoyeroyingo Yon oningga ngu tunooteyingo. Ene Yudiyano, oni kini kingo merako nguno, Anutro mande oni simoo bareno wesiyoro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ngundo ngandiro eyingo. Ye komo nowoondoye yowoorengoyi, Anut Oo Bidodo Simburi Simbunani, ngundo naru enengo oni simoo bare soboyerooteku, ngu namoko ombuwero tete. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yon oningga kuri Anutro ingondudu eyingo oni, Ayisaya, ngundo mandega ewoku, ngu ataga engge tunootete. Ene ngandiro eyingo. Oni kini merako, ngunonggo oni gurado menongga ngandiro eyingo. Oo Simburi Simbunani, nguro oo bidodo yoonenengoya, nguro oore yomosiyootoyiga, ene ombuwa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yon ngu, ene bo gura oowooyi Kamel, ngu uyimbo nengguro teyingomu ngu angoyi onindo nengguro ngundiro tero, ko, utombo wanggango gosiyororuwo. Enengo oowari ngu katu, diguno siso ngu neroruwo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","6","Ngu naruno, Yerusalem oni, Yudiya oni bidodo, ko, Yodan sono tanggeyimo ende, ngunonggo oni ngu bidodo Yonno mayero, enengo mbumbuwa wesiyootoyi, nguro ene Yodan sono newendemo utoyi, ngundo sono kundingiyimbo sonoyeroyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yondo Mosesro mamana mande sobowooyingo oni oowooye Parisi, ko kumoononggo ma ootoogewa ero ingoyingo oni oowooye Sadusi, ngu yeyootoni, sono gimuwero ombuyingo. Yondo ene kuri ingowoku, Parisi ko Sadusi oni nowoondoye ngu ma yowoorengoyingo, nguro ngu, ene sanggiri tero eyingo. Ye sire biyomi simoongo! Ye onendo etoni, Anutro sanggirini yeno ombutoni, ye mete sawanggo? Ye ereremo kini! ");
INSERT INTO rwo_rawa_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ye nowoondoye yowoorengoro hamoo tetoyi ngu, asa, yengo endeyoyingo nguro engge nguya yowoorengoro, gome tunootewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ye nowoondoyemonggo ngandiro ma ingowero. Ebaraham ngu noorengo osinani nguro Anutdo gome soboyerowaku ngu, ero ma ingowero! No yeno eteno. Hamoo oorengo, Anutdo mete nga digi nga tetoni, Ebaraham simoongo tunootero, Anutro oowooyi ero okoowanggo! ");
INSERT INTO rwo_rawa_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Yo, Ebarahamro sowe ngu de ngundiro. Soporo kuri de damonimo ooroote. De gidega gome ma enggeteku, ngu onindo doongooro ngu, asa, ene de nombono oorongootoyi dewa. Oni nguya ngundiro nangge, nowoondoyemo hamoo ma tero gome ma enggewanggoku ngu, asa, ngundiro yodoongooro, Setanro de nombo ma kumooweroyi nguno oorongooyerootoni yoodewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ye kuri nowoondoye yowoorengootoyi, nguro nondo sono kundingiyimbo, ngu sonoyerooteno. Ene oni gura no kootunesina ombuwaku, ene ngu oningga nguro yanggangoni urungga oorengo. No yanggangone bodaga nangge, nguro ngu, no enengo ko oni nangge. Enendo ngu Anutro Yuka Kundingiyi, de kookingo ngundo ye sonoyerowa. Yo, Anutdo yengo weti mbumbuwaye dero, ngu nowoondoye yeni, sarayi oorengo yewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Yo, oni simoo bare bidodo Kopi tanggori ngundiro. Oni Kopi tanggori dangero, besooro, ene tanggori metemimu ngu yomosiyoro yoro, enengo yano yewanggo. Ene Kopi biyomimu yoro, ene de nombo ma kumooweroyi, nguno oorongootoni oruwa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ngu naruno, Yisas Galili mera yokoro, ene Yodan sonono uro, Yondo sono kundingiyimbo sononeroni, ero ombuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ngundiro etoni, ene Yondo Yisasro mande gosiyowero ingoro, enendo sumoo eyingo. Ndawugaro nguro, ge nondo sono kundingiyimbo sono nero, ero ingoro ombute? Gedo mete Yuka Kundingiyimbo no sono gimununo, eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ene Yisasdo mande gumi ero eyingo. Nguno yokoya, nondo etenoku ngundiya te. Noore komo muri mesarango oorengo, Anutdo muri ngundiro nguro ingooteku, noore ngu keyowaro, ero eyingo. Ngundiro etoni, Yondo, yo, mete, ero, ene sonowooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yisas sono gimuro yokoro, sagigo ooretoni ngu, sodedomangge sambo ende yamuko goosootoni, nguwoore Anutro Yuka Kundingiyi Yisasno ombuyingo. Yuka ngu, nu mumukondiri ngundiro tero ombuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ombutoni ngu, asa, Anutro manggowo sambononggo ngandiro eyingo. Ngu nenengo nangone. No enengo gome mesarango ingooteno. Nowoondone nguro gome mesarango oorengo ingooteno. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ngu naruno, Yuka Kundingiyimbo Yisas yoro, oni kini kingo merako toongetoni, Setando nguno towoongoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yisas ngu, ene sa onibi eraya, ko suwoo onibi eraya nguno oowari neweroyi oo ma yoyingo. Ene kingo oode oode omburo, ngu naruno, ene oodoro urungga kumooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ngundiro oodoro kumooro oodoni, ene towoongoweroyi oninggaku Setan, ngu tunootero, enendo Yisasya eyingo. Ge Anut Nangoni tetoningga ngu, ge etooga, digi nga yowoorengoya, oo manongoyingo tunootetoningga ne, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ngundiro etoni, ene Yisasdo mande gumi ngandiro eyingo. Anutro nakayano ngandiro ete. Oowari nero, nguno nangge, oni sugi sugi keta ngu yunoweroyi nguya, ereremo kini. Kini, mande bidodo Anut manggowoomonggo tunooteteku, ngundo nangge, oni sugi sugi keta oruweroyi ngu yunowa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ene ngundiro etoni, Setando yoro, ende kundingiyimo Yerusalem oororo, ngu yoro, Yudaro yowuru ya urungga oowooyi Tembel ngu sanganimo ooreyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","7","Oorero, enendo eyingo. Ge Anut Nangoni tetoningga ngu, arisa, ge pareya amuno sore. Ndawugaro nguro, Anutro mandeno ngundiro ete. Anutdo enengo sambono Engel nguno etoni, geno omburo, ngundo kandeye sanganiwoore goyoro utoyi, ge digibo ma gosanggawewa, eyingo. Arisa, Yisasdo enengo mande ngu ingoro, enebana gumi eyingo. Anutro oo nakayano ngandiro nguya ete. Gedo Oo Bidodoboro Simburi Simbuge, ngu ma towoongowero. Ngu gengo Anut Urungga! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ngundiro etoni, asa, Setando Yisas ko mera puringga awuno oorengomu, nguno yoro ooreyingo. Setando nguno mera bidodoboro duridarini, ko, oo gome gome nguya etungoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ene ngundiro oo gome gome etungoro ngu, asa, ngundo Yisasya eyingo. Ge nono boodoo oondoogero, bagootero, yambo mande tewaku ngu, arisa, nondo mete nga oo nga, ge gunowano, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ene mande ngundiro etoni, asa, Yisasdo mande yanggango gumi eneno eyingo. Setan, ge toonge! Anutro nakayano ngandiro ete. Ge Oo Bidodo Simburi Simbunani, nguno nangge, yambo mande teyato! Ngu gengo Anut, ko, ge enengo ko nangge dowooya ootoo! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ngundiro nguro, Setan ene yokootoni, ngu naruno nguno, sambono Engel onikundo omburo, Yisas hoorooweyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ngu naruno nguno, Yisas ngu ene Yon ngu dowooro, ya biyomimo yewonggoku, ngu ingoro, nguro ene Galili merako oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ene oororo, enengo ende damoni Nasaret yokoro, yade oororo, ene Kapeniyam endemo tunootero, nguno ko teyingo. Kapeniyam ngu sono koongeyingo ngu namoko, Sebulan, ko, Naptalayi mera erayaga nguro soweyemboro merako nguno oriyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Yo, ene ngundiro oorowutoni, nguro kuri Anutro ingondudu eyingo oni Ayisayando mandega eyingo, ngu engge tunootete. Enendo kuri ngandiro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","16","Sebulan ko Naptalayi oni simoo bare nguro musiyo oorootenggoku, ngu oore wendeyi tanggeyisina utenggoku, ngu Yodan sono anduroko, Galili mera gumisina, nguno oni sowe gura gura urungga nguno oorootenggo. Ngu merangga ngu bidodomo, muri biyomi gura gura tero oorootenggoku, ngundo soru himi urungga kenootenggo! Ngu oni simoo bare ngu, ene nowoondoyemo hamoo kini oonooteweroyi musiyomo oorowuwero tero oorootenggoku, nguno kuri soru himi eneno tunootewoku ngu! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ngu narunggano nguno, Yisas ene damoni yero, mande wesiyoro eyingo. Ye nowoondoye yowoorengoyi! Ndawugaro nguro, Anut Oo Bidodo Simburi Simbunani, ngundo naru enengo oni simoo bare soboyerooteku, ngu kuri namoko ombute, eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ngu naruno nguno, Yisas ene Galili sono koongeyingo dabemiwoore omburo, erabasa eraya ngu Sayimon oowooyi gura Pita, ko nguro koneyo Enduru ngu yeyoyingo. Erabasa enengo isoro si sono koongeyingomo oorongooro, iso yoro, ngu uriyoweroyimboro. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ene erayaga nguya eyingo. Yari no keneroya endeyori. Yari oni simoo bare yoyoro, Anutro mandeno yoyoweroyi ngu etuyerowano eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ene ngundiro etoni, asa, sodedomangge erayagaku isoro si yokoro, ene Yisas keyoro sayingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ene ngundiro tero, ene songgura bodaga oororo ngu, ene erabasa eraya nguya yeyoyingo. Ngu Yemus, Sebediro nangoni, ko nguro koneyo Yon. Erayaga ngu awayari Sebediya wanggo sanganimo ootooro, ene isoro si yomosiyoro, oodori yeyoyingo. Yeyoro, asa, Yisasdo erayagaku negoyeroyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ngundiro negoyerootoni, arisa, sodedomangge erayagaku awayari ko wanggo nguya yokoro, ene omburo, Yisas keyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yisas Galili mera bidodomo endeyoro, ene Yuda oniro yowuru ya newendemo uro, oni simoo bareno Anutro mande murini, ngundo enengo oni simoo bare soboyerooteku, nguro mandeni gome wesiyoro yunoote. Ene mande ngundiro wesiyoro, ngunonggo oni simoo bare sayi gura gura moondeye yomburiyeroyingomu nguya yomosiyeroyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Enengo mandeni Siriya mera bidodomo, ero endeyoyingo. Ngundiro nguro, oni sayi damoni gura gura yoro; ogingo urungga ingoro oorootenggoku, ngu yoyoro mayero; oni mbooro biyomidodomu; oni gaboye kumooro kekandeye mboorombooro urooteku; ko, oni wimbuye bingo yeyingomu nguya, ngu bidodo yomosiyeroyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Oni simoo bare oowooyingga oorengo Galilinonggo, ko Dikapolissinanggo, ende kande eraya nguro musiyo urungga, Yerusalemnonggo, Yudiyanonggo, ko, Yodan anduroko nguya ene Yisas keyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yisas oni simoo bare oowooyingga oorengo yeyoro ngu, ene mera puri sanganimo oorero, bibitetoni, enengo kirikiri oniku, eneno ooreyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Nguno Yisasdo mande etuyeroro, yunoro, ngandiro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Oni ene ingowanggo. Ene Anut doongeyimo ereremo kini, ero ingootenggoku ngu, asa, ene oni oni tewanggo. Ndadiro nguro, Anutdo ene kumana yunowa. Yo, ngundiro oni, ngundo ngu Anutdo endega enengo oni simoo bare soboyerooteku, nguno uro oruwanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Oni sendoro, nowoondoyemo kowuri urungga ingootenggoku ngu, Anutdo hoorooweyeroro, kowuriye andangero, nowoondoye yeni imakewoku, nguro ene oni oni tewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Oni murini mesarango imakeyingomo oorootenggoku ngu, Anutdo kumana yunoro, mera oo yunowero ero gosiyowoku, ngu yunowaku, nguro ene oni oni tewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Oni oowariro ko sonoro, ingoro, hahangetenggoku ngundiro, oni nowoondoyemonggo Anutro murini nenengo ngu keyowero hahangetenggo. Ene ngundiro tero, oodoyi, asa, Anut enengombo nowoondoye yeni, metemi oorengo tero, nguro ene oni oni tewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Oni ene simoo bare gidarega nowoondoye yunootenggoku muringga, nguro ene oni oni tewanggo. Ndadiro nguro, Anutdo enengo nguya nowoondoyi teyunowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Oni Anut doongeyimo nowoondoye mesarango oorengo oorootenggoku ngu, ene oni oni tewanggo. Ndadiro nguro, ene Anut kenowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Oni ebe toongootoyi, ene nowoondoye imakeyingomo oruweroyi oningga ngu, ene mete oni oni tewanggo. Ndadiro nguro, Anutdo ngu oni nguya nenengo simoone, ero ewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Anut doongeyimo, oni nenengo oodoyi, nguro oni gidaregado kingo kowuri gura gura yunootoyi, nguro ene nowoondoye kowuri ma ingowanggo. Kini, ene oni oni tewanggo. Ndadiro nguro, Anutdo ene yoyoro, endega enengo oni simoo bare soboyerooteku, nguno oruwanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","12","Ngundiro nangge, ye no kenerootoyi, nguro merako oni, ngando kootuyesina mande biyomi ero yomooro, kowuri gura gura yunoro, kingo mande godange etoyi ngu, nguro ye nowoondoye kowuri ma ingowero. Kini, ye komo oni oni teya, nowoondoye imakeyingomo ootooya, Anut oowooyi bingami eya okooya, oni oni teyi. Ndadiro nguro, ye sambo endemo oo urungga ngu yowanggo. Ngundiro nangge, merako onindo Anutro ingondudu eyingo oni nguya koretero yomburibariyeroyingo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Yisasdo mande gura eyingo. Ye Anutno nowoondoyemo hamoo teyingongga, ngu merako ngano sayi nembo (Sol) ngundiro. Sayi nembo ningguriga ngu yoyokootoni ngu, asa, noorendo ngu ningguriga Sayi nembo nguno, ngu ko yeweroyi nguya ereremo kini. Yo, hamoo, sayi nembo ngu koni gura kini. Ngundiro nguro, onindo oorongooro, keyembo wongooweroyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ngundiro nangge, ye Anutno nowoondoyemo hamoo teyingo ngu, mera ngaro soru himi ngundiro. Ende gura purimo sorudodo oruwaku ngu, kombiteyingo ma oruwa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kini, onindo soru karo, kumbe gura newendemo ma oongoowanggo. Kini, soru ngu yaba sanganimo tunoo yetoyi, oni ya newendemo oorootenggoku, ngu bidodo soru himi kenowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ngundiro nangge, oni nowoondoye Anutno hamoo teyingongga ngu, enengo sorungga ngu oni bidodomo tunoo oodoni, yengo muriye nenengo kenoro ngu, Anut sambo endemo oorooteku, ngu oowooyi bingami okoowanggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Yisasdo mande gura eyingo. Ye ngandiro ma ingowero, no ngano omburo, Anutro mamana mande ingondudu eyingo onindo kuri nakangoyingo ngu andangewa, ero ma ingowero. Kini, nondo mamana mande ngu andangewero ma ombuyingo. Nondo mamana mande ngu bidodo engge yewe tunootemukoweroyi, nguro ingooteno. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","No yeno hamoo eteno. Sambo mera kinitetoni, ene noro mamana mande ma kinitewa. Anutro mamana mande nguno noorengo mande gumi bodaga, ko, nakaya bobodi guranangge nangge ngu ma yokowa. Oo bidodo mamana mande ngu newendemo oorooteku, ngu enggeni tunootewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Oni gura Anutro mamana mande gumi gura ma keyoro, ngunonggo ene oni gura ngundiro etuyeroro ngu, arisa, ngu oningga sambo endemo ooreteku naruno, ene Anut doongeyimo, ngu oowooyi kini oruwa. Ene oni Anutro mamana mande ngu keyoro, oni simoo bare oo ngundiro etuyerootoningga ngu, arisa, Anutdo sambo endega enengo oni simoo bare soboyerooteku, nguno ngu, oningga ngu oowooyidodo tewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","No yeno hamoo eteno. Anut doongeyimo, yengo muri nenengongga, ngundo komo Mosesro mamana mande sobowooyingo oni Parisi, ko, mamana mande etuyeroyingo oni nguya, enengo muri nenengo ma dagatenggoku ngu, arisa, ye Anut Oo Bidodo Simburi Simbunani, enengo oni simoo bare soboyerooteku endega, ngu newendemo ma uwanggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Arisa, Yisas mande gura eyingo. Mosesro mamana mande kurimi ngu, ye gome ingootenggo. Ngu ngandiro eyingo. Ye oni ma ureyi kumoowero. Ene ge oni ureyi kumoowaku ngu, asa, ge mande wirikoyingo onino oorero, nguno gumi urungga yowa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ene nondo mande gura nguya yeno eteno. Oni gura dobooyi guraya newende biyomi ingooteku, nguro ene mande wirikoyingo onino ooretoni, nguro gumi inowa. Ngundiro nangge, oni gura ene oni doongeyemo, oni dobooyi kootuyisina mande ero, oyimo inowaku ngu, asa, ene nguya mande wirikoyingo oni tabango urungga nguno ooretoni, nguro gumi urungga inowa. Ene oni gura dobooyiboya sanggiri oorengo tero ewa, ge mboorombo goyoyingo, ingondudu gura metemi kini! Ene ngundiro ewaku ngu, asa, ngu oningga ngu Anutdo soweyootoni, Setanro ende de nombo sugi sugi derorooteku, nguno oororo, sugi oruwa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Ge Anutno yambo mande tewero ingoro, nguro ge eneno kingo oo duwoo yewero uya ngu, doboogebo geya biyomi ingooteku ingoro ngu, asa, koretero ge eneno ooroya, biyomingga ngu andangeya, yomosiyoyagogo, kootuyisina ge ko uya, Anutno oo duwoo ye. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Dobooge gura geya newendemo kowuri ingoro, goyoro, mande wirikoweroyi musiyomo oorowuwero oorekono oorowutoningga ngu, sodedomangge ngu mande kowuringga ngu yoonenengori. Ge ngu mande kowuri koretero ma yomosiyowaku ngu, arisa, ngu oningga, ngundo goyoro, oo wirikoyingo onino oorowutoyi, ngundo goyoro, kumbadogoni oni kandeyemo goyetoyi, ngundo ya biyomimo goyewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","No yeno hamoo eteno. Ge ya biyomimo oode, ngunonggo gengo weti ngu bidodo ma andangero ngu, asa, ge ya biyomi ngu ma yokowa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Asa, ene mande gura eyingo. Mosesro mamana mande kurimi nakangoyingongga ngu, ye kuri ingootenggo. Ene ngundiro eyingo. Ye oni guraro bareyi yakakayi yodowooro, ma yomburiyowero. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ene no mande gura yunooteno. Simoo gurado newendemonggo barega kenomayingoro, nguro ingooteku, ngu ngandiro, ene barega nguya kuri werewori. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ngundiro nguro, doongengge metemisina, ngundo goyeni, weti mbumbuwa tetoningga ngu, andangeya yoko. Ngundiro nangge, moondege gumi, ngundo goyeni weti mbumbuwa tetoningga ngu, andangeya yoko. Ngundiro tewaku ngu, asa, moondege bidodo yoro, Setanro ende de nombo ma kumooweroyi, nguno ma uwa. Ngundiro nguro, ge oo biyomi teteku, ngu sodedomangge yomosiyoro ngu, ngu gome metemi oruwa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Mande adingayi gura ngundiro. Kandege metemisina, ngundo goyeni, weti mbumbuwa tetoningga ngu, toongooya oorongo. Ngundiro tewaku ngu, asa, moondege bidodo yoro, Setanro ende de nombo ma kumooweroyi nguno ma uwa. Ngundiro nguro, ge oo biyomi teteku, ngu sodedomangge yomosiyoro ngu, ngu gome metemi. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Yisasdo mande gura eyingo. Mosesro mamana mandeno kuri ngandiro nakangoyingo. Oni gura bareyi yokowero ngu, ene komo so uyino mande ngundiya nakangoya, bareyi inoni, ero nakangoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ene nondo mande gura moore. Oni erambarisa ngu bareyibo oni guraya ma wereyingo ngu yokoro owewaku ngu, ene bareyi yeni, mbumbuwa tewa. Ngu baregaku kuri kameyi yowoku, ngundo simoo gura kootu yootoni ngu, arisa, Anut doongeyimo, simoo kootungga, ngundo mbumbuwa tewa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Asa, Yisasdo mande gura eyingo. Kuri oo nakaya teyingo ngu, ye gome ingootenggo. Ye Anut doongeyimo mande gagiwi, ero gosiyoyingongga, ngu ma toongoowero, ngu hamoo teyi, ero nakangoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ene no nguro mande soweyoro eweroyi oore. Ye merako onino mande gosiyowero tetoyingga ngu, no ngu mandega Anut oowooyimo gosiyowero ero, ma ewero. Ye sambo oowooyimo mande ma gosiyowero. Ndawugaro nguro, sambo ngu Anutro yaba bibiteweroyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ye mera oowooyimo nguya mande ma gosiyowero, ndadiro nguro, ngu Anutdo keyi yeweroyi musiyo. Ye Yerusalem ende oowooyimo nguya mande ma gosiyowero, ndadiro nguro, ngu Anutro ende urungga. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ye tabaye oowooyimo nguya mande ma gosiyoro ewero. Ndadiro nguro, ye tabaye uye sarayi ngu yeyi, iriyo yeweroyi nguya kini. Ngundiro nangge, tabaye uye iriyo ngu yeyi, sarayi yeweroyi nguya kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ye mande gura ero, yo, etenggoku ngu, hamoo ewanggo. Ye, kini, etenggoku ngu nguya, hamoo ewanggo. Ye mande, yo, kini, etenggoku, nguno mande soweyoro ewanggoku ngu, Setando yeni tunootete. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Asa, Yisasdo mande gura eyingo. Ye Mosesro mamana mandeno, ye kuri ingootenggo. Ene ngundiro eyingo. Oni gurado doongeye yomburiyootoyiga ngu, yebana ngundiya ene doongeyi gumi teyino. Oni gurado metoyi udoyiga ngu, yebana ngundiya ene metoyi gumi teyino. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ene no yeno eteno. Onindo yeno oo biyomi teyunootoyi ngu, yebana ko gumi ma teyunowero. Oni gurado gagiye metemisina udoyi ngu, ye yowoorengootoyiga, ko biyomisina nguya yureyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ngundiro nangge, oni gurado goyoro, mande wirikoweroyi musiyomo oororo, yengo nengguro yootoyiga ngu, asa, mete ye dogigiro nengguro nguya yunoyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Oni gurado yeya oore bodaga oorowuwero ooroya ngu, yendo ngu songgura oore piru nguya oorowuyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Oni gurado oo guraro sumoo yunootoyiga ngu, arisa, inoyi. Ngundiro nangge, oni gurado yeno weti tero, yowero oo etoningga ngu, mete ye inoyi. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Asa, Yisasdo mande gura eyingo. Ye Mosesro mamana mandeno kuri ingootenggo. Ene ngundiro eyingo. Ye dobookuriye konebaye nguro gome ingoya, yengo mundi oni nguya sanggiri teyi. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ene nondo mande gura soweyoro yunowero. Yengo mundi oni ngu nowoondoye yunoya, enendo muri biyomi yeno tero, kootu yunootenggoku ngu, yendo nguro Anutno kira teyunootoyi, enendo muri biyomi tetenggoku, ngu hoorooweyerootoni, ngu yokowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Yo, yendo yengo mundi onino muri metemi tero, nguno simoo bare etuyeroro ngu, hamoo oorengo, ye Awaye sambo endemo oorooteku, nguro simoongo. Yo, Anutdo oni biyomi, ko, oni metemi nguya ogisa yeni eneno tunootewa. Ngundiro nangge, sono nguya oni muriye biyomi, ko, oni muriye nenengomo nguya Anutdo sono yeni, eneno ombuwa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Onindo yengo gome ingootoyi, ko yendo nguya enengo gome ingootenggoku, nguro kowuri kini. Weti mbumbuwa tetenggoku oni, ko, Takis yoweroyi oni nguya ngundiro teyingo. Ene yendo yengo mundi oni nowoondoyi teyunowanggoku ngu, asa, Anutdo nguro oni oni tewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ye konebaye nguya kambayerootenggoku ngu, ko, oni sowe gidarega, ngundo nguya ngundiro tetenggo. Yengo muringga ngundo enengo muriye ngu ma dagawa. Kini, muriye guranangge. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Hamoo, Awaye sambo endemo oorooteku, ngundo oni nenengo, ko, oni biyomimo nguno muri gome nenengo ngu nangge teyunoote. Ngundiro nangge, ye nguya ngundiya teyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ye ingonda teyi! Ye angoyi oni nguno oo gomengga teyunowero ngu, oni doongeyemo ma yunowero. Ndadiro nguro, onindo ngu yendo oo tewonggoku, ngu tunoo kenoro, nguro ye oowooye bingami ero okoowanggo. Ene ngundiro tetoyi ngu, asa, kootuyisina, Awaye sambo endemo oorooteku, ngundo nguro uri gura ma yunowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ye angoyi oni oo gomengga yunowero ngu, asa, ye nguro oni doongeyemo manggaru yanggango ma tewero. Ndadiro nguro, oni Anutro nowoondoyemo hamoo ma teyingo, ngundo yambo yano ko oorekono nguya oo ngundiro tero, enengo oowooye bingami okooweroyimboro. No hamoo oorengo, yeno eteno. Ngu oni ngu, enengo uri kuri yoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ngundiro nangge, ye angoyi oni hoorooweyerowero ngu, arisa, kandeye biyomisinangga ngundo kandeye meteminggado oo tewaku ngu ma ingowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ngundiro nguro, oo gome yunowero muringga ngu kombiteyingo tewonggokungga ngu, kootuyisina, Awayembo uri gumi tunoo yunowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ye kira tewero ngu, oni mibuye tegedodo, ngundo kira tetenggoku, ngundiro ma tewero. Ene newende bidodo enengo oowooye okoowero, oni doongeyemo yambo yano, oorekono nguya, kira tewero gome ingootenggo. No yeno hamoo eteno. Ngundiro oni ngu kuri uri yowonggo. Ye ngundiro ma tewero. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ye kira tewero ngu, yengo ya gumi nguno ooroya, ya goodooya, yesu nangge Awayemo kira teyi. Ye ngundiro tetoyi ngu, asa, Awayembo ngu oo kombiteyingongga tetenggoku, ngu kenoro, gumi yunowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ye kira tewero ngu, kingo mande mande ma eroruwero, kabengo onindo tetenggoku, ngundiro ma tewero. Kabengo oni, ngundo Anutdo ingoni ero, ene mande mande ngundiro oowooyingga tetenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ye ngundiro oni nguro muri ma keyowero. Ndadiro nguro, nowoondoyemo oo guraro kowuri ingoro, nguno ma kira teyingomo ngu, Anutdo ngu oo ngu bidodo kuri kenoro ingomukoote. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Nondo ngu kira eweroyi muri gome ngu etuyerowero, ye mete ngandiya kira teyi. Noorengo Awanani, ge sambo endemo oorooteku, gengo oowoongge ngu kundingiyi oorengo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Oo Bidodo Simburi Simbunani, gengombo narungga gengo oni simoo bare soboyerooteku, ngu mete ombuni. Sambono onindo ge oo ingooteku, ngu nenengo kenggeroro oorootenggoku, ngundiro nangge, noore hoorooweyerootooga, ngano ngundiro keyoro oruwato. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ge noorengo oowari atagamboro rogoyimo yuno. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Noorendo oni gidaregaro kowuri andangero, kabetetooyega ngu, gedo nguya ngundiya noorengo mbumbuwa andangeya kabeteyunowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Gedo Setan ma yokootoyi, omburo, ngundo noore towooyeroro, ngunonggo yoyoro, weti mbumbuwano yoyewero. Oo Bidodo Simburi Simbunani, gengombo naru oni simoo bare soboyerooteku ngu, yanggangongge, bingamingge nguya, gengomu nangge sugi sugi oruwa. Ngu hamoo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ye gome ingoyi! Ye oni gidaregado kowuri yeno tetoyi, ngu andangero kabetetoyi ngu, asa, Anutdo nguya yengo kowuri andangero kabeteyunowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ngundiro nangge, ye oni gidaregado kowuri yeno tetoyi, ma andangero kabetetoyi ngu, asa, ngu Anutdo nguya yengo kowuri ngu ma andangero kabeteyunowa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Asa, Yisasdo mande gura eyingo. Oo neweroyi narunggano nguno, ene oowari roogo tero, ene Anutno kira tewanggo. Ye oowari roogo tewero ngu, omukumundooge ma guwi yewero, oni mibuye tegedodo ngundo tetenggoku, ye ngundiro ma tewero. Ngundiro oni ngu, oni simoo bare doongeyemo ngundiro tetenggoku ngu etuyeroro, ene oowari roogo tetenggo. Arisa, ngundiro oni, ene kuri uri yowo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ye oowari roogo tewero ngu, mete ye omukumundooye sonowooya, uye siwitoya yoonenengoya oriyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ngundiro tetoyiga ngu, oni gurado ye oowari roogo tetenggoku, ngu ma ingowanggo. Ene Sambono Awayembo, enesu nangge oo ngundiro ngu ingowa. Awayembo ye oo kombiteyingo tetenggoku, ngu kenoro, oowooye bingami okoowa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ye nowoondoye bidodo oo sitowi gome gomemu, ngu merako ngano yowuruwooweroyimboro ma ingowero. Nga merako ngano sako, siwi, googoose, yakaka oni, ngundo oo bidodo yomburiyootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Anut doongeyimo, ye enengo mande onino wesiyoro ero, oni yomosiyeroro, oniro kowuri koorowooro, oo ngundiro ko tetenggoku ngu, sambono digi beye ngundiro yowuruwooya, nguno yeyi. Sambo endemo ngu sako, siwi, googoose, ngundo ma yomburiyootoyi, yakaka onindo nguya ya toongooro, oo yoweroyi nguya kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Yengo oo sitowi gome gomemu oorooteku, nguno yengo ingonduduye nowoondoye nguya nguno ooroote. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","23","Asa, Yisasdo mande gura eyingo. Doongeye ngu goweyeboro soru himi, suwoono endeyoweroyi ngundiro. Ngundiro nangge, nowoondoyebo muri metemi Anutnonggo ombuteku ngu tero, hahangetenggoku ngu, ngu suwoonomboro soru himi gome oorengo ngundiro. Nguro ngu, yengo ingondudu nangge keyowero ingootoyi ngu, yengo soru himi ngu yanggango ma ootooro, namoko kumootoni, nguro ye ooreri oorengomo oruwanggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Asa, Yisasdo mande gura eyingo. Oni gurananggebo sobosobo oni erayagomo ko teweroyi nguya ereremo kini. Ene sobosobo gura nguro gome ingoro, sobosobo guraro gome ma ingowa. Ene sobosobo gura gome keyoro, gura kootu inowa. Ene ngundiro nangge, ye Anut keyoro, ko, digi beye yowero hahangeweroyi muri erayaga ngu teweroyi, bine? Kini, Anut keyoro, ko, digi beye yowero hahangeweroyi muri erayaga ngu keyoweroyi, ngu ereremo kini, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Arisa, no yeno hamoo eteno. Ye yengo yanggangoye, oo neweroyi, sono neweroyi, ko, towikumba teweroyimboro nguro nowoondoye kowuri yero, ingondudu oowooyingga ma ingororuwero. Anut doongeyimo, yengo keta oruweroyiga, ngu nowoondoye hamoo teyingongga, nguro oo bidodo dagamukoote. Yo, yengo keta oruweroyiga, ngundo oo neweroyi, sono neweroyi, ko, towikumba yoweroyi, ngu bidodo dagate. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ye nu ngu kenoro ingootenggo. Ene numbo ngu oowari ngu miro, yoro, yano oowari ma watayero yetenggo. Ene Awaye sambono oorooteku, ngundo soboyeroro, oo yunoote. Ngundiro nangge, Anutdo noorengo gome urungga ingoote. Yo, hamoo, ene noorengo gome ingooteku muringga, ngundo nuro ingooteku muringga, ngu dagate. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Anutdo noorengo keta oruweroyi naru rogo teyunoyingo. Noore keta oruweroyi narungga Anutdo rogo tewoku, ngu noore mete ma dagawato. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Irosara gome diguno ooreteku ngu, ene kingo oorero, nungo yewero ko biyomi ma tewa. Kini, ene Anut enengombo nungo inootoni, nungo yero, gome tete. Ngundiro nangge, Anutdo ye nguya hoorooweyerootoni, ye towikumba yowanggoku, nguro ye nowoondoye kowuri urungga ma yewero. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Kuri mera ngaro oni sobosobo koreteyingo urungga oowooyi Solomon, enengo irosara gome gomemu tero, enengo duridarini urungga oorengo tero oruwo. Ene Anutdo irosara merakono yewoku, ngu ooga ngu Solomonro irosarani, ngu bidodo dagate. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Yo, Anutdo irosara merakono nungo gome gome tetoni, ataga gome oode, yangeni ngu buwoo yero, makooro sorewa. Arisa, ene ye nguya hoorooweyeroro, noorengo towikumba ngu rogono yunowa. Ye simoo bare nowoondoye hamoo teyingongga, ngu bodaga nangge. Ndadiro nguro, Anutdo mete ye nguya gome soboyerowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ngundiro nguro, ye nowoondoye kowuri yero, ingondudu oowooyingga ma yowero eyingo. Noore oo ndawuga newato? Noore ndawu sonongga newato? Noorengo towikumba oo ndawuga tewato? Ero eyingo. Ye ngundiro ingondudu urungga ma tewero. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kabengo oni ngundo oo ngundiro yoweroyimboro ingoro hahangetenggo. Ene yengo Awaye sambono oorooteku, ngundo ene kuri gome ingowo. Ye komo sono, oowari, towikumba nguya yengo rogono nenengo ngundiro yowanggo. Anutdo ngundiro ingoote. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ene ye koretero oorengo, Anut Oo Bidodo Simburi Simbunani, ngundo murini enengo simoo bare soboyerooteku, nguno uro, enengo murini nenengo ene yendo teyi, ero ingooteku, ngundiro keyootoyi ngu, arisa, Anutdo mete oo gidarega ye rogono ngundiro hoorooweyerowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ngundiro nguro, ye nowoondoye kowuri yero, ingondudu oowooyingga yangenimboro, nguro ma ingowero. Yangeni narungga ngu, enesu nangge kowuri koorowoowa. Naru gurado kowuringga ngu, ene ngu narungga nguromu nangge. Ene ngundiro ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yisasdo mande gura eyingo. Ye oni goweyemo enengo muri ngu ma wirikowero. Ye ngundiro tetoyi ngu, asa, Anutdo ye nguya wirikoyerowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ngundiro nangge, ye dobookuriyeboro muriye wirikootoyi ngu, Anutdo muri ngundiro yeno nguya tewa. Yengo mamana mandero rogoga dobookuriyemo tetenggoku, ngu Anutdo yeno nguya ngundiro nangge gumi yunowa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Yo, no mande adingayi gura yeno ngandiro eteno. Ge ndawugaro dobooge doongeyimo oo kakawu bodaga oo kenootoni oorooteku, ngu ge doongengge nenengo de bingo urungga oorooteku, nguno ge ma kenoro ingoote? ");
INSERT INTO rwo_rawa_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ndawugaro ge doboogemo ngandiro ete? Doboone, nondo doongenggemo oo kakawu bodaga oorooteku, ngu yewe toongewa. Ge ngundiro eteku, ene naru bidodomo, de sosi urungga doongenggemo nguno ooroote. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ge mibuge tegedodo oni! Ge koreteya de sosi urungga doongenggemo oorooteku, ngu andangeya yoko. Ge ngundiya teya ngu, asa, ge mete doboogemo ngu gome kenoro, oo kakawu bodaga ngu andangewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Nga mande adingayi gura. Ye oo kundingiyi, ngu se, bo ma yunowero. Ye oo ngundiro gome gome bo yunowonggoku ngu, asa, sodedomangge ene bodo yomburiyoro, wongooni utoni, ngundo yowoorengoro yokiwa. Ngundiro nangge, oni gura Anutro Mande Keta Mesarango ngu naru bidodo ngu ma yootoningga ngu, asa, ye ene yokoyi. Ngundiro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Yisasdo ngandiro eyingo. Ye nono ooro sumoo ewanggoku ngu, no yunowano. Ye suwooyi sano oo erewewero ngu, ye kenowanggo. Ye yamuko tanggeyisina dikaro, yokakasangootoyi ngu, asa, Anutdo yamuko goosooyunowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ye Anutno yemboongero, ooro sumoo ewanggoku ngu, Anutdo oo yunowa. Ngundiro nangge, oni simoo bare oo yowero ngu erewero, ene kenowanggo. Ye yamuko tanggeyisina dikaro, yokakasangootoyi ngu, asa, Anutdo yamuko ngu goosooyunowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ngundiro nangge, oni gura nangonimbo oomanongoyingomboro etoni ngu, eweyimbo digiga inowa bine? Kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ngundi oni gura nangonimbo isoro etoni ngu, eweyimbo sire biyomi yoro, inowa, bine? Hamoo oorengo kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Arisa, merako ngano awa awaye songo songo, ngundo oo kingo duwoo gome ngu nangosumooye yunootenggoku, nguno ngu, ye hamoo ingowanggo. Awaye sambono oorooteku, ngundo nangosumooyemo sumoo ero etoyi ngu, hamoo oorengo, ngu oo gomegomemu yunowero ingowa, ero ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Arisa, muri gome oorengo yendo oni simoo baredo yeno teyi, ero ingootenggoku, asa, ye ngu muringga ngundiya nangge eneno teyi. Yo, ye ngu muri nenengo keyootenggoku ngu, asa, ngundo Mosesro mamana mandega Anutro ingondudu eyingo oni oo ngundiro etuyerowonggoku, ngu rogono tero, engge tunooteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Arisa, ye Anutro mamana mande ngu keyoro ngu, ye Anutro oni bidodo oore bodaga tembaniwooremu nguno oorero, Anutro sambo endemo oorewanggo. Ene Setanro oore ngu urungga mera nenengo gome nangge. Yo, oni simoo bare oowooyingga oorengo, ngu oore urungga ngu keyoro, oororo oonootewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ene Sambo Endemo oore, ngundo oore tembaniwoorega ngu bodaga nangge. Yo, keta sugi sugi oruweroyi oore tembaniwoorega ngu bodagamu, nguro ye ko biyomi terogogo, erewero nguno oorewanggo. Oni simoo bare nowoondoyemo hamoo teyingongga, ngundo nangge kenoro, Anutno oorewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ye Setanro ingondudu eyingo oni godange nguro ingonda teyi! Ngu oni ngundo ye kewooroyemo, ememangge ememangge oororo dikaro, torige mande yeno ewanggo. Ene imakeyingo muri tero, torige yeno omburo oorowutoyi, bo gura oowooyi Sipsip enengo muri ngundiro teyingo. Ene kawuye newendemo nguno ngu, ngu se koki biyomi ngundiro. Ngundo ngu omburo, sodedomangge yokiwanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ye koretero enengo muriyengga ngu wirikoro kenootoyi, ngu ene nenengo bine, ngundi biyomi bine ewanggo. Nga oni nga enengo ootootooye, ngu gome tetoyi, kenoro ngu, asa, ye nguno ingoro, enengo muriye ngu nenengo, ero ingowanggo. Yo, Muli dega, ngundo ngu yowoorengoro, koonda ma tewa. Ngundiro nangge, dimoo uto, kakari sanggiri, ngundo yowoorengoro, mbako ma tewa. Hamoo oorengo kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Yo, de bidodo gome yanggango tero ngu, ene tanggori gome nenengo nangge enggewanggo. Ngundiro nangge, de biyomi, ngundo ene engge gome metemi ma enggewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","De metemi, ngundo engge biyomi ma enggewa. Ngundiro nangge, de biyomingga, ngundo ene engge gome metemi ma enggewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","De bidodo gome ma enggetoyi, asa, ene de ngu doongooro, deko yokawanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ngundiro nangge, ye ngundiro oni ngu enengo muri biyomi tetenggoku, ngu kenoro, ye nenengo tunoo ingootenggo. Ene godange eyingo oni nangge, ero ingoyingo. Ngu oni nguno, ene Anutro murini ma keyoyingo, hamoo oorengo kini, ero ingowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Nguro ngu, oni guminggado ngu noorengo Anut Oo Bidodo Simbunani etenggoku, ngu gumi nenengo kini. Kini, oni ngu enengo bingamiye okooro, ene Anut oowooyi nguro ma ingoro tetenggoku ngu, ene Anutro sambo endemo enengo oni simoo bare soboyerooteku, nguno ma uwanggo. Ene oni gura Awane sambo endemo oorooteku, ngu gome keyoro ngu, asa, Awane kenowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","23","Arisa, oode kootuyisina, Anutdo naru wenganggakuno wirikoyeroweroyi naruno, oni oowooyingga oorengo mayero ewanggo. Oo Simburi Simbunani Urungga, noore gengo oowoonggemo, noorendo gengo mandege keta mesarango ngu wesiyoro, merambooro biyomi andangero, muri songo oorengo gura onindo ma teweroyimu nguya teyingo. Ero ewanggoku, ene ngu narunggano nguno, nondo mande ngandiro gumi ewano. Yendo ngu yengo oowooye bingamiye nangge okooro, noro nowoondoye hamoo ma teyingo, nguro ngu, no yeno mande yanggango eteno. Nondo ngu ye watayi kini. Ye weti mbumbuwa oni biyomi! Ye sodedo sayi! No ngundiro ewano, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Arisa, Yisasdo mande adingayi gura eyingo. Oni gura noro mandene gome keyoro, ingoro ngu, ene ingondudu metemi yoote. Ngundiro oningga ngu, ngu ngandiro. Ene ingondudu metemi yoro, nguro ene ya yanggango ngundiro mera yanggangonggakuno de nonggini gagiwi yoro, yeteku ngu. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ngundiro tero, sono urungga omburo, sono tuwi urungga ootoogero, doogo urungga ombutoni ngu, enengo yangga ngu yanggango ootooro, ma tookero sorewa. Ndawugaro nguro, ene mera yanggangonggano de nonggini gagiwi nguno yeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","27","Ngundiro nangge, oni gura noro mandene ingoro ma keyoro, ene oni ingonduduni kini ngundiro. Ene ya yeweroyi ngu ingondudu kini. Nguro ene ya nonggini ngu mere setoni, mera newendemo amuno ma uyingo. Kini, ene ya ngu mera sanganimo nangge yeyingo. Ngundiro nguro, sono doogo urungga omburo, sono mewuyi urungga tetoni, ngu enengo yangga ngu yanggango kini, nguro sodedomangge tookero sorewa. Yo, hamoo oorengo, ngu tookero, sorero yomburiyomukowa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Yisasro mande ngu kinitetoni, oni simoo bare oowooyingga oorengo enengo mandeni etuyerowoku, ngu ingoro, ene soriyokoro hamoo ingowonggo. Ndadiro nguro, Yisasdo mandeningga ngu wesiyoro eteku, ngu mamana mande etuyeroyingo onindo etenggoku, ngundiro ma wesiyoro eyingo. Kini, Yisasdo mande oni simoo bare yunowoku, ngu yanggango oorengo eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yisasdo puringga ngu yokoro, ene ameno ombutoni, oni simoo bare oowooyingga oorengo ene keyoro oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ngu narunggano nguno, oni gura mambugoridodoga, ngundo Yisas tanggeyimo omburo, bagootero eyingo. Noorengo Oo Bidodo Simburi Simbunani, no ingooteno. Ge mete noro ingoya, noyega, mete tewe, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ngundiro etoni, asa, Yisas ngu oni mambugoridodogaku ngu kenoro, nowoondoyi tero, kandeyi eneno yero, eyingo. No ngundiro tewero gome ingooteno. Ge mete te. Ene ngundiro etoni, arisa, sodedomangge ngu oni mambugoridodogaku, enengo sayininggaku mete teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Asa, Yisasdo mande gura eyingo. Ge no manggone gome ingo! Ge oororo ngu, oni gurano gengo sayi yomosiyooteku, nguro ma ewero. Kini, ge sodedo ooroya, gengo gowege moondege Anutro wooro yeyingo oni kundingiyi ngu etuyero. Ene ge geyoro ingoro, gowege moondege sayi mete tero, ero ingoro ngu, kuri Mosesndo ewoku, ngundiya teyi. Ngundiya tetooga, oni simoo baredo geyoro, ataga gengo sayingge ngu mete tete. Ero ingowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yisas Kapeniyam endegano nguno utoni ngu, ngu naruno nguno, me oniro tabango ururu gura nguro me oni ngu onibi kandegura (100), ngundiromu ngu soboyerooteku ngu, ngundo Yisasno omburo, ngandiro sumoo eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Noro Oo Bidodo Simburi Simbune, noro kirikiri oni gura sayi urungga tero, yano ooroote. Ngu ene kekandeyi ngu kuri kumooyingo, ngu ene ogingo urungga yoro ooroote. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yisasdo enengo mande ngu ingoro, enebana gumi eyingo. Nondo oororo, ene yewe, mete tewa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ene ngundiro etoni, asa, me oni tabango urungga Yisasno mande gumi eyingo. Oo Bidodo Simburi, no oni metemi kini. Ngundiro nguro, ge noro yano ma ombuwa. Ge mande kingo nangge etooga ngu, noro kirikiri oningga ngu, ene mete tewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nondo noso nangge noro oni sobosobo urungga moore. Ene oo etoni ngu, nondo oo ngundiro teteno. Ngundiro nangge, noro me oni nowoondonemo oorootenggo. Arisa, nondo guraya, oorowu, ewanoku ngu, ene oorowuwa. Nondo guraya, ombu, ero ewanoku ngu, asa, ngu ombuwa. Nondo nenengo kirikiri oni guraya ko ngundiya te, ewanoku ngu, ene oo ngundiro tewa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yisasdo enengo mandega ngu ingoro ngu, soriyokoro, yowoorengoro, oni eneya namoko nguno etuyeroro eyingo. No yeno hamoo oorengo eteno. No ngu Iserel oni gura newende hamoo teyingongga, ngundiro no ma kenowono, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","No yeno hamoo eteno. Anut Oo Bidodo Simburi Simbunani, ngundo endega enengo oni simoo bare soboyerooteku, nguno oni simoo bare oowooyingga ngu sowe gura gura Yudaro oni kini, me oni tabango urungga ngundiro. Yo, ngundo sambo endemo nguya omburo, oo simbo urungga naruno, Ebaraham, Ayisak, Yekob, ngudodo bibitero, oo nero oruwanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ene Anutdo endega enengo Iserel oni simoo bare soboyerooteku, nguro yomosiyoyingo. Yomosiyootoni, ene enengo Iserel oni simoo bare oowooyingga nowoondoyemo hamoo ma tero, nguro ene sambo endemo ma oorowuwanggo. Anutdo ngu oni ngu oweyerootoni, Setanro ende biyomi de nombo ma kumooweroyi nguno oorongoowa. Oorongootoni, nguno ene ureri urunggano sendo moguru urungga tero, metokarikari tero oruwanggo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ngundiro ero ngu, asa, Yisasdo yowoorengoro, me oni tabango urunggakuya ero, gengo yano u! Gengo nowoondoge hamoo teyingongga, nondo gengo ko oni yomosiyoowe ero ingowokunggaku, ngu ataga engge tunootete. Ero etoni, naru ngundiro nangge, Yisasdo etoni ngu, enengo ko oninggaku sodedomangge mete teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Arisa, Yisasdo omburo, Pitaro yano uro, konggeyi kenoyingo. Ene sayi goweyi kookingo urungga yetoni, yabano wetororiyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ngundiro nguro, Yisasdo Pita konggeyi kandeyi dowootoni ngu, nguno nangge, sayininggaku kinitetoni, nguro ene ootoogero, Yisasro oo karo yomosiyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Arisa, suwootetoni, oni simoo bare oowooyingga mbooro biyomimbo yoyoyingomu, ngu yoyoro, Yisasno mayeyingo. Mayetoyi, asa, Yisasdo mbooro biyomiku oni nowoondoyemo oorootenggoku, nguno ero oweyerootoni, besero sayingo. Ngundiro tero, sayi oniku nguya yomosiyerootoni, ko mete teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Kuri Anutro ingondudu eyingo oni oowooyi Ayisaya, ngundo Yisasro mande ngandiro nakangoro eyingo. Enendo enesu nangge sayinani bidodo andangero yokoro, ene noorengo sayi gura gura kuri koorowooro oorowuyingo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ngu naruno nguno, oni simoo bare oowooyingga oorengo mayero, Yisas pawangootoyi, nguro enendo kirikiri onino eyingo. Noore sono koongeyingo anduroko oorewato, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ngu naruno, Anutro mamana mandero etuyeroyingo oni, ngundo Yisasno omburo eyingo. Oo etuyeroyingo oni, ge ende bidodo oorowuwaku ngu, no nguya geya oorowuwero ingooteno, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ngundiro etoni, asa, Yisasdo mande gumi eyingo. Diguno se koki oorootenggoku ngu, ene kengeweroyi musiyo moore. Ngundiro nangge, nu nguya takiyedodo moore. Ene no, Anutro Nangoni Oni Kirarongo, ngu wereweroyi musiyo hamoo oorengo kini, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ngu naruno nguno, oni newende hamoo teyingo gurado Yisas keyoro eyingo. Oo Simburi Urungga, mete bine, no koretero oororo, Awane sobowootoowe, kumootoni merengoorogogo ko ombuwano. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ene ngundiro sumoo etoni, asa, Yisasdo gumi eyingo. Oni noro nowoondoyemo hamoo ma teyingo, ngundo mete oni bingo merengooyi. Ene komo ge no keneroya ombu. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ngu naruno nguno, Yisas enengo kirikiri oni nguya wanggo newendemo uyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Arisa, ngu naruno nangge, doogo urungga oorengo tunootero, wendeyi tookero, wanggo yowooraringootoni, wanggo wendoni uwero teyingo. Ngundiro tetoni, ene Yisas wanggo newendemo wetororiyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ngundiro tetoni, enengo kirikiri oni sosoreyingo urungga oorengo tero, Yisas yokutuwooro eyingo. Oo Simburi Urungga, ge komo noore hoorooweyero! Noore ataga oonootewero tetetoku nga, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ene ngundiro etoyi, asa, Yisasdo eneno mande gumi eyingo. Ye ndawugaro sosoretenggo? Yengo nowoondoyemo hamoo teyingo ngu bodaga nangge! Eyingo. Ngundiro ero, ene ootoogero, doogo sono nguya yeyoro etoni, sodedomangge imakeyingo. Yo, ene ngundiro etoni, doogo imaketoni, wendeyi nguya nenengo yeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ngundiro tetoni, enengo kirikiri oni ngu kenoro, ingondudu urungga oorengo tero, sosorero, enengo nangge mande ero sumoo eyingo. Nga oningga nga ndadiro oningga, nguro wendeyi, doogo yeyoro etoni, ngundo manggowo ingoro, nguro ene sodedomangge imakeyingo? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ngu naruno, ene sono anduroko oni simoo bare mera nguno oorootenggoku, ngu oowooyi Gadarin nguno ombutoyi ngu, oni eraya mbooro biyomidodo ngu nguya yowuruwooyingo. Ene oni merengooweroyi musiyo yokoro, Yisasno ombuyingo. Mbooro biyomimbo yoyoyingo oni erayaga ngu, se koki ngundiro. Ngundiro nguro, oni simoo bare ngu oni erayagado musiyo oore ma endeyootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ngu naruno nguno, mbooro biyomikundo Yisas kenoro, meno yanggango ero eyingo. Ge Anutro Nangoni, ge nooreno ngano ndawuga tewero ombute? Ge noore ogingo urungga yunowero ombute, bine? Ataga narungga, noore Setanro ko oni yoyoro, Setando musiyo biyomimo yoyeweroyi naru kini, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ngu naruno, bo oowooyingga oorengo sono koongeyingo namoko oo nero oruwonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Bo oo netoyi, mbooro biyomi oni erayagaku nowoondoyarimo oruwonggoku, ngundo bo kenoro, nguro ene Yisasno ngguyinggayi tero, sumoo sumoo eyingo. Noore oweyerootoyi, oorero, mete noore bo andu nowoondoyemo uwato, bine? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ene ngundiro sumoo etoyi, asa, Yisasdo ngu ingoro, mande gumi eyingo. Yo, mete ngundiya teyi! Ene ngundiro etoni, arisa, mbooro biyomiku oni erayagaku yoyokoro, boku nowoondoyemo utoyi ngu, arisa, sodedomangge boku yondoyidoro oororo, mera tembanimo sorero, sono koongeyingomo uro, nguno kumoomukoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ngundiro tetoni, bo sobosobo oniku ngu kenoro, sodedomangge ene yondoyidoro, endemo ko oororo, bo bidodo kumoowonggoku nguro ero, ko, oni erayaga mbooro biyomimbo yoyoyingo ngu mete teworiku, nguro nguya ero endeyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ngundiro etoyi, ngu endemo simoo bareku bidodo sanggiri tero, Yisasno mayeyingo. Ene Yisas kenoro ngu, nguno ngguyinggayi tero, sumoo sumoo inoro, nga merangga nga yokoya, gurasina toonge, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ngu naruno nguno, Yisasdo wanggo newendemo uro, sono koongeyingo anduroko oororo, enengo ende damonimo ko mayeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Mayetoni, oni kekandeyi kuri kumooyingongga yabano yero, oni gidaregado sumooro, Yisasno mayeyingo. Arisa, Yisasdo ngu oni nguro nowoondoye kenoro ingoworomu ngu, ene enengo nowoondoyemo hamoo teyingo kenoro, nguro ene ngu sayi oninggakuya eyingo. Nangone, nowoondoge imakeyingomo ootoo. Nondo gengo mbumbuwage andangero yokoro kabeteteno, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ngundiro etoni, Mosesro mamana mandeno etuyeroyingo onindo ngu ingoro, enengo nangge mande ero, ingoro eyingo. Nga oningga ngando, Anut kootuyisina ero yomooyinoro mande biyomi ete. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Asa, Yisasdo enengo nowoondoye bidodo kenoro ingoro, ngandiro sumoo eyingo. Ye ndawugaro yengo nowoondoyemo ngundiro biyomi ingootenggo? ");
INSERT INTO rwo_rawa_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Oore eraya ngu sayi oningga nguya eweroyi ooroote. Ndawu oorega ngu dagate? Nondo eneya ewano, gengo mbumbuwa andangero yokoro kabetewano; ngundi, ge ootoogeya oorowu, ero ewano, bine? Ndawu oorega ngu gome? Ero sumoo eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","No nenengo etuyeroro ewero. No Anutro Nangoni Oni Kirarongo ootooro, yanggangonedodo no mete merako ngano oni bidodoboro mbumbuwa andangero yokoro, kabetewano, ero eyingo. Arisa, ene ngu oni kekandeyi kuri kumooyingongga nguya eyingo. Ge ootoogeya, gengo yaba yoya, gengo yano u. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ngundiro etoni, ene ootoogero, enengo yano uyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Oni simoo bare namoko oruwonggoku, Anutdo yanggango oni yunowoku, ngu kenoro ngu, ene sori urungga yokoro, Anut oowooyi bingami ero okooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ngu naruno nguno, Yisasdo nguno oororo, Gabuman digi beye yoweroyi oni oowooyi Matiyu ngu kenoro eyingo. Ge ombuya, no kenero, eyingo. Ngundiro etoni ngu, asa, Matiyu ootoogero, Yisas keyoro oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yisasdo kirikiri oni nguya, Matiyuro yano oororo, oo netoyi ngu, digi yoweroyi oni gura, ko, mbumbuwadodo oni nguya omburo, ngudodo oo neyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mosesro mamana mande sobowooyingo oni, oowooye Parisi, ngundo Yisasro kirikiri oniku yeyoro eyingo. Ndawugaro yengo oo Simburi ngu digi beye yoweroyi oni, ko, mbumbuwadodo oni nguya oo netenggo? Ero sumoo eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yisasdo ngu mandega ngu ingoro, mande gumi eyingo. Oni sayi kini ngu, sayi mambu yomosiyoweroyi Doguta onino nguno ma oorowuwanggo. Kini, oni sayidodo, ngundo nangge Dogutano oorowuwanggo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Kuri Anutro ingondudu eyingo onindo nakayanggano nguno Anutro eyingo. Nondo ngu nowoondoye ebe ino ino teweroyi muringga, nguro gome ingooteno. Ngu muringga, ngundo nono wooro yeweroyi, ngu dagate. Ero eyingo. Ene mande soweyoro gura eyingo. Ye Anutro ingondudu eyingo oni nguro mande ngu gome ingoyi, nguro damoni ndadiro? Ngundiro nangge, no oni nenengomboro nangge ma ombuyingo. Kini, no oni mbumbuwadodomu negoyerowero nguya ombuwono. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ngu naruno nguno, sonoyeroyingo Yon oningga nguro kirikiri onindo Yisasno omburo, sumoo eyingo. Ndawugaro nguro, noro, ko Parisi oni nguya oowari roogo tero, gengo kirikiri oni ngundiro ma tetenggo? Ero sumoo eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yisasdo mande ngu ingoro, nguro gumi eyingo. Bare yoweroyi naruno, dobookurine, yayane, awa namone mayetoyi ngu, nguno oni oni teweroyi naruno, oowari ma roogo teweroyi. No merako ngano ma oruwanoku narunggano ngu, asa, nenengo kirikiri oni oowari roogo tewanggo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Yisasdo mande adingayi eraya yunoro, ngu etuyeroro, muri keta ko muri kurimi ngu ma yowuruwoowero. Ngu ngandiro: Oni kumba sosowo ketangga yoro, ngundo nengguro kurimingga nguro witu ma ukingoro webisiyowanggo. Ene ngundiro tetoyi ngu, ngu kumba sosowoongga, witu ukingowonggoku, ngundo nengguro ko omboongewa. Ketanggakundo kuriminggaku omboongetoni, nguno witu urungga tunootewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ngu ngandiro: oni gurado bo simoongo ketamu yoro, si kurimimo ma siriyoote. Ndadiro nguro, ngundiro tewaku, bo simoongonggakundo si kuriminggaku omboongero, merako sorero, si, bo nguya yomburiyowa. Ngundiro nangge, oni bo simoongo, si ketamo siriyootoyi, ngu bo, si nguya mete oruwa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yisasdo mande soweyoro, ero etoni ngu, yowuru yaro tabango oni gura omburo, boodoo oondoogero eyingo. Anangu, no nambone kumoote. Mete, ge ombuya, kandege eneno yeya, yokutuwootooga, ene ko ootoogero, keta orini, Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ene ngundiro etoni, asa, Yisasdo, enengo kirikiri onidodo ootoogero, ene keyoro oorowuwonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ngu naruno, bare gura komboro sayi yoro, mooma naru kande eraya kegidemboro eraya oruwoku, ngundo Yisas kootuyisina oororo, nengguroni tanggeyisina dowoowo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Enengo newendemonggo ngu ngandiro ingoro ewo. No nengguroni tanggeyisina nangge dowoowanoku ngu, asa, nenengo sayine mete kinitewa, ingoro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ngundiro tetoni ngu, Yisasdo yowoorengoro, kenoro eyingo. Nambone, mete, ge nowoondoge imakeyingo ootoo. Ge noro nowoondoge hamoo teyingo nguro ngundiro nangge, sayingge kinitete, ero eyingo. Ngundiro etoni, ngu naruno nangge, enengo sayinggaku kiniteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Arisa, Yisasdo tabango oninggakundo yano ombutoni, nguno oni simoo bare oowooyingga oorengo nguno ootooro, sendo moguru tero, nggusi uwooro oruwonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Yisasdo oo ngundiro kenoro eyingo. Anangu, ye sayi! Nga bare buniyongga nga ngu ma kumooyingo, ene wetoroote nangge. Eyingo. Ene ngu mandega ngu ingoro, nguro ene yomoo inoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ene ngundiro tetoyi, Yisasdo oni simoo bare oweyerootoni ngu, endesina ooretoyi, ya newendemo uro, bare buniyonggaku kandeyi dowootoni, ko keta tero ootoogeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ngu ooga tunootewoku, nguro mandeni sodedomangge ende bidodomo ngu mera guminggano oorooteku, ngu ingowonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ngu naruno nguno, Yisasdo ngu endega yokoro oorowutoni ngu, oni eraya doongeyari kiringomu ene keyoro, meno yanggango eyingo. Ge Yuda oniro tabango urungga Dewit nguro osiyi! Ge noorengo nowoondoyi teyuno! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yisasdo ngu ingoro, ene nowoondoyari kenowero yano utoni, ngu oni doongeyari kiringo erayagaku nguya uyingo. Yano utoyi ngu, asa, Yisasdo erayagaku yeyoro, towooyeroro, sumoo eyingo. Yari nowoondoyarimo ngu nondo yomosiyeroni ingooteri, bine? Ene ngundiro etoni, doongeyari kiringo erayagakundo mande gumi eworiyo. Oo Simburi Urungga, ge mete noore yomosiyoro, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ene mande ngundiro etori ngu, asa, Yisasdo kandeyi doongeyarimo yero eyingo. Arisa, yari nowoondoyari nono hamoo tetori nguro, ataga ngundiro nangge, engge tunootewa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ene ngundiro etoni, sodedomangge doongeyari mete teyingo. Ngundiro tetoni, asa, Yisasdo eneya mande yanggango eyingo. Yari ingonda teri! Yari oni gurano nga ooga ngaro ma ewero! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ene ngu oni erayagaku endesina oorero, ngu ooga Yisasdo tewoku, nguro mandeyi sodedomangge ende bidodomo ngu mera guminggano oorooteku, ngu wesiyoro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ngu naruno nangge, Yisasdo ngu endega yokoro, oorowutoni ngu, oni gidegado oni gura mbooro biyomimbo manggowo gosiyoyingomu, ngu yoro, Yisasno ombuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Arisa, Yisasdo ngu mbooro biyominggaku owetoni, ngu oninggaku mande eyingo. Oni simoo bare ngu kenoro, soriyokoro eyingo. Noore kuri ngundiro ooga Iserel merako tunootetoni, ngu ma kenoyingo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ngundiro nguro, Parisi onindo Yisasro ko kenoro, nowoondoyemonggo boguwooro mande ngandiro eyingo. Ene mbooro biyomi Setanro yanggangomonggo ngu andangete. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ngu naruno nangge, Yisasdo ende bidodomo endeyoro, Yudaro yowuru yano uro, simoo bare etuyeroro, Anutro Mande Keta Mesarango wesiyoro yunoro, oni simoo bare yowoosooro, Anutro mande muriningga, ngundo enengo oni simoo bare soboyerooteku, nguno utoyi, ene nowoondoye hamoo teweroyimboro. Ngundiro tero, ene oni sayidodomu, ko, sayi gura gura nguya yomosiyeroyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yisasdo oni simoo bare yeyootoni, ene kowuri gura gura ingoro, nguro ingondudu urungga tero, ene biyomi nangge oruwonggo. Yisas newendemonggo yeyoro, nguro nowoondoyi urungga teyunoyingo. Ndawugaro nguro, oni simoo bare ngu Sipsip ingonduduye kini ngundiro, ko, sobowooweroyi ko oni gome nguya kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ngundiro nguro, enengo kirikiri onikuya mande gura ngandiro eyingo. Oowari oowooyingga kono kuri mandoni yewoku, ene nguro ko oni oowooyingga kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ngundiro nguro, ye komo Anutno kira etoyi, ko oni oowooyingga soweyerootoni, Anutro kono omburo, oni simoo bare yowuruyerowanggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ngu naruno nguno, Yisasdo enengo kirikiri oni kande eraya kegidemboro erayagaku negoyerootoni, ombutoyi, yanggango yunootoni, ene mbooro biyomi owero, oni sayidodo ngu mete yomosiyeroro, moondeyemo kowuri ngu andangetenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","4","Yisasro kirikiri oni ngu ngandiro: Sayimon oowooyi gura Pita, ko, enengo koneyo Enduru; Yemus ko Yon ngu Sebedi simoongo; Pilip; Batolomeyu; Tomas Matiyu, ngu digi beye yoweroyi oningga; Yemus ene Alipiyasro nangoni; ko Tadiyas; Sayimon, nguro muri ngandiro: enengo mera, ngu mera gura onindo, sobowooweroyi ingonduduni kini oorengo. Ko Yudas Iskariyoot ngu oningga, ngundo damodamoni tero, Yisas mundi oni kandeyemo yeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yisasdo enengo kirikiri oni kirarongo mamana mande ngundiro yunoyingo. Ye oni sowe gura gura Yudaro oni kini nguno ma uwero. Ye ende gidega Sameriya mera nguno oorootenggoku, nguno nguya ma uwero. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Kini, ye Iserel oni simoo bare nangge nguno oorowuyi. Ene Sipsip, ngundo enengo oore yokootenggoku ngundiro. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ye ooroya ngu, mande ngandiya wesiyoya eyi. Anut Oo Bidodo Simburi Simbunani, ngundo naru enengo oni simoo bare soboyerooteku, ngu kuri namoko ombute. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ye ko gura ngandiya teyi. Ye sayi oni yomosiyeroya, oni kumooyingomu yokutuyeroya, ko moondeye gorimambudodomu oni yomosiyerootoyiga mete tetoyiga, ko mbooro biyomi nguya oweyeroyi. Nondo ye Anutro mamana mande yunoro, ko nondo ko biyomi tero, yengo nowoondoye hamoo teyingongga, ngu yanggango kingo yunowono. Arisa, ngundiro nangge, ataga, yengo naru, yeba nangge saya, oni simoo bareno ngundiya kingo yunoyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mete, ye digi beye ma yoro, siriyowero. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ye kasi, ko towi eraya, keye goweyi eraya, ko usudogo gura, ngu ma yowero. Kini, oni endemo oorootenggoku, ngundo mete oo bidodo yunoro hoorooweyerowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ngundiro nangge, ye ende ururumo ko bobodimo, nguno ye oni gome ereweya, yeyoya, oni metemi nenengongga kenoya, ngundo yano nangge oodega, ooroya, naru saweroyigakuno yokoya sayi. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ye ya gurano uya ngu, oni ngu yano oorootenggoku, ngu kumana yunoyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Oni simoo bare ngu yano oorootenggoku, ngundo ye gome soboyerootoyiga ngu, ngu Anutro kumanangga enedodo mete oruwa. Asa, ngundiro nangge, enendo gome ma soboyerootoyiga ngu, ngu Anutro kumanangga eneno ma oruwa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ngundiro nangge, oni gurado yoyoro, enengo yano ma utoni ngu, ko endemo oni simoo baredo Anutro mande kootu inootoyiga ngu, asa, ye ende yokoya, ooroya ngu, keyemo gugukakawu yonggurumooya, ye sayi. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nondo yeno hamoo eteno. Kootuyisina, oni simoo bare wirikoyeroweroyi naru urunggano, ngu Anutdo ngu endemo oni simoo bare ngu kowuri urungga oorengo yunowa. Ngu endemo kowuringga yunoyingo, ngundo oni simoo bare Sodom ko Gomora ende erayagano kowuringga, ngu dagate. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Yisasdo mande gura eyingo. Ye gome ingonda teyi! Nondo ye Kristen oni, Sipsip ngundiro ngu soweyerootoowe, se koki kewooroyemo oorowuwanggo. Ye sirero muri keyoyi. Ene ingondudu urungga tero, oo gome kenoro ingoro, oo tewero ingooteku, ngu tete. Ye nu mumu kondiriro muri nguya keyoya, ngunonggo muri biyomi teweroyimboro, ngu ma ingowero. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ye oniro ingonda gome teyi! Enendo yoyoro, ya biyomimo oorero, wirikoyeroyi musiyomo oorero, enengo yowuru yano gisasaruyerowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ye nono oni nowoondoye hamoo tetoyi, nguro enendo ye yodowooro, Gabuman oni, ko, merako oni koreteyingo tabango urungga, ngu doongeyemo ombuwanggo. Ngundiro nguro, ngu naruno, ye Anutro Mande Keta Mesarango ngu onino, ko oni sowe gura gura Yuda oni kini, nguno nguya wesiyoya yunoyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ye nono nowoondoyemo hamoo tetenggoku, nguro kowuringga ngu tunootetoni ngu, ye nowoondoyemo sosorero, ngandiro ma ingowero, ero eyingo. No oni ururumo ndadiro mandega ewano; ngundi, enendo etoyi ngu, nondo gumi ndadiro ewano, ero ma ingororuwero. Ngu narunggano nguno, ye ma sosorewero. Ndadiro nguro, yengo Anut, ngundo ingondudu ye yunootoni, mande ngundiro wesiyoro ewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Yengombo ngu oo ngu ma wesiyoro ewanggo. Kini, Anutro Yuka Kundingiyi, ngundo nangge ingonduduyemo etoni ewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Kowuri naruno, oni gurado koneyo dowooro, oo wirikoweroyi musiyomo ooretoni, ureyi kumoowa. Ngundiro nangge, eweyimbo nguya nangonimo ngundiro tetoni, simoongombo ewenemi nguya ngundiro tewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Yo, hamoo, ngu naruno, ye noro nowoondoyemo hamoo tetenggoku, nguro oni nowoondoyemo hamoo ma teyingo, ngundo yeya nowoondoye biyomi urungga ingowanggo. Ene ngundiro tetoyi ngu, oni gura newende hamoo yanggango tero oode, naru wengamo oruwaku ngu, asa, Anutdo ene yootoni, ngu oningga ngu Anutya sugi sugi oruwari. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Oni simoo bare ende gurado yomburiyerowero tetoyiga ngu, ye ende gurano sodedo sayi. Ngu endemo oni ngundo nguya muri biyomi yeno tetoyi ngu, asa, ye ende gurano sobiyoya sayi. No yeno hamoo oorengo eteno. Ye Iserel ende bidodomo ko ngundiro ngu ma temukoyingomo, no Anutro Nangoni Oni Kirarongo ko omburo yoyowano. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Simooye Skulno oorowuyingo ngu, ngu komo enengo etuyeroyingo oningga ngu nowoondoyemo oriyi. Ene ngundiro nangge, kirikiri oni nguya komo enengo sobosobo oni ururu nowoondoyemo oriyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Mete Skul oni nguya, etuyeroyingo oni ngu kirarongo oorengo tunootewanggo. Ngundiro nangge, kirikiri oni nguya enengo oni ururu kirarongo oorengo mete tunootewanggo. Ngu hamoo, nondo yengo nowoondoye hamoo teyingo nguro Awaye oorooteno. Ene noro mundi oni gidaregado no kootunesina oowoone biyomi Setan, ngundi, Beyelesebab ero ngu, asa, ngundiro nangge, ye noro kirarongo tero oorootenggoku, ye nguya ngundiro kootuyesina oowooye biyomi guradiro guradiro ewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ngundiro nguro, ye mundi oni merako ngano oorootenggoku, ngu ma sosorewero. Ndadiro nguro, mande bidodo nowoondoyemo ngu ingoro, kombiteyingo oorooteku ngu, kootuyisina oode, tunoo oorengo tunootemukowa. Ngu oo ngu wiriyoyingo ngu, kootuyisina, onindo kenowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nondo mande ureriko etuyeroro, yunootenoku nga ngu, yendo mera himi ogisano wesiyoya yunoyi. Ngundiro nangge, ye mande torige sodeyebo ingootenggoku ngu, ye mande eweroyi musiyomo, ngunonggo mande wesiyoya eyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ene ye oni goweye moondeye ureyi kumootenggoku, nguro ma sosorewero, ndadiro nguro, ene gaboye nguya mete ma ureyi kumoowa. Kini, ye komo Anutro nangge sosoreyi. Ngundo ngu, ene mete moondeye gaboye nguya erayadodo Setanro ende biyomi, de nombo ma kumooweroyi, nguno ye oorongooyerowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Oni ngu nu bobodi digi tanggori guranangge, ngundo nangge uriyootenggo. Ene Awaye sambono oorooteku, ngundo ma ingootoni ngu, asa, ngundiro nu bobodi ngu merako ma sorewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Yo, Anutdo nu nguro gome ingoro, sobowooro, ene ye soboyeroro ingooteku, ngundo nu bobodi soboyerooteku muringga, ngu dagate. Yo, Anutdo tabaye uye ngu kuri kandangero, ingowoku ngu, ye ngu watayi kini. Ngundiro nguro, ye ma sosorewero. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Nguro oni gurado no oowoone oni simoo bare doongeyemo wesiyoro, ewaku ngu, nondo nguya ngu oningga oowooyi Awane sambono oorooteku, ngu doongeyimo nguya wesiyoro ewano. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ene oni gurado oni simoo bare doongeyemo no kootu nunootoni ngu, asa, nondo nguya ngu oningga Awane sambono oorooteku, ngu doongeyimo nguya kootu inowano. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ye ngandiro ma ingondudu tewero, no merako ngano ebe yeni, kumoowero ombute, ero, ma ingowero. Kini, no ebe yewe kumoowero ma ombuyingo. No duge ngu Anutro mandeni ngundiro ngu yoro ombuteno. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Yo, noro dugega ngando ngu oni simoo bare bidodo kewooro wesoowooyerootoni, wata eraya tunootero, gura oni simoo bare nono nowoondoyemo hamoo tero oodoyi, oni simoo bare wata gura nowoondoyemo hamoo ma teyingo oruwanggo. No nguro ombuwono. Simoo gurado eweyimboya mundi tero, songo songo oruwari. Bare gurado nemimboya mundi tero, songo songo oodori, ngundiro nangge, bare gurado neboyiboya mundi tero oruwari. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ngundiro nangge, oni simoonggoro ya gurananggemo oorootenggoku, nguya mundi tero, songo songo oruwanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Oni gura eweyi nemimboro nangge ingooteku muringga, ngundo noro ingooteku muringga, ngu dagatoni ngu, ngu oningga ngu noro doboone kini. Ngundiro nangge, oni gura nangoninggaro ko namboninggaro gome ingooteku muringga, ngundo noro ingooteku muringga, ngu dagatoni ngu, asa, ngu oningga nguya noro doboone kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ene oni gura enengo newendemo hamoo teyingo nguro ene ma kumoowero tero, ngunonggo ene no kenerowaku ngu, asa, ngu oningga noro doboone kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Oni gura merako ngano enengombo enengo keta oruweroyiga ngu yowaku ngu, oniyooge, kootuyisina, ene oonootewa. Ngundiro nangge, oni gura noro ingoro, meyero, noro konemo enengo keta sugi sugi oruweroyi yokowaku ngu, asa, ngu oningga, ngundo noya keta sugi sugi oruweroyi ngu sambo endemo yowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Oni gurado ye yomosiyerowaku ngu, ene ngundiro nangge, no nguya yomosineroote. Ngundiro nangge, oni gurado no yomosinerooteku ngu, asa, ene Anut, no sowenerootoni ombuwonokungga, nguya yomosiyoote. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Oni gura Anutro ingondudu eyingo oningga ombutoni, kenoro, no Anutro ingondudu eyingo oni hooroowewero ingoro, ene yoro, enengo yano uro gome sobowooteku ngu, asa, Anutdo nguro uri urungga inowa. Ngundiro nangge, oni gura oni nenengo metemingga ombutoni, kenoro, ingoro, ene yoro, enengo yano uro sobowoowaku ngu, asa, ngu oningga nguya Anutdo uri urungga inowa. Ndadiro nguro, onindo oni Anutro ko tetenggoku, ngu hoorooweyerootenggoku ngu, Anutro ko gobooro tetenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Oni gurado ngu oni simoo bare noro nowoondoyemo hamoo teyingo ngu oowooyidodo kini, ngu kenoro, ingoro, nguro ene sono gingo tobano wendoro, inowaku ngu, asa, no yeno hamoo eteno. Ngu oningga ngu uriyi gome yowa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yisasdo enengo kirikiri oni kande eraya kegidemboro erayagaku, ko teweroyi nguro mande yunoyingo. Ene mande kinitetoni ngu, asa, ene ngu endegaku yokoro, ende oowooyingga ngu Galili mera oorooteku nguno oororo, Anutro mande wesiyoro etuyeroro, oni simoo bareno yunoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ngu naruno nguno, Sonoyeroyingo Yonngga ya biyomimo oode, ngunonggo Yisasdo ko tewoku ingoro, nguro enengo kirikiri oni soweyerootoni, Yisasno oororo, sumoo ewero. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ene Yisasno mande ngundiro sumoo eyingo. Ge nooreno nenengo tunoo oorengo e. Ge Yuda onindo oni urungga sobowootetoku, bine; ngundi, noorendo oni gura sobowoowato, bine? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ene oo ngundiro sumoo etoyi, asa, Yisasdo mande gumi eyingo. Ye ooroya, Yonno oo kenoro ingootenggoku, nga eyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ye ooroya, Yonno ngandiya eyi. Oni doongeyi kiringomu ngu ataga doongetetoyi; oni keye biyomimu ataga gome endeyootoyi; gorimambudodo oni enengo goweyi ataga metemi tetoyi; oni sodeye tuwoomu ngu mande ingootoyi; oni kuri kumooyingomu ataga ootoogetoyi; angoyi oni Anutro Mande Keta Mesarango ataga ingootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Oni gura newende noro hamoo tero, ingonduduni eraya kini oruwaku ngu, arisa, ngu oningga newende imakeyingo ootooro, oni oni tewa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","9","Arisa, Yonro kirikiri oniku ngu ingoro, ene sayingo. Ngundiro tetoyi, Yisasdo oni simoo bare kewooroyemo, Yonro mande eyingo. Ye kuri oni kini kingo merako oorowuwonggoku, nguno ndawu ooga kenowonggo? Ye, bine, doogobo kumuku nungo umamingootoni, kenowero oorowuwonggo, bine? Kini, ye nguno ndawu ooga kenowero oorowuwonggo? Ye bine, oni gurado nengguro gomengga tetoni, ngu kenowero oorowuwonggo, bine? Kini, oni nengguro gome gomemu tetenggoku ngu, ene mera oni sobosobo koreteyingo urungga, ngundo yano nangge oorootenggo. Asa, ye nono eyi. Ye nguno ndawugaro oorowuwonggo? Anutro ingondudu eyingo oningga kenowero oorowuwonggo, bine? Yo, no yeno hamoo eteno. Yon, ngu Anutro ingondudu eyingo oni, ngundo Anutro ingondudu eyingo oni gidega ngu dagayeroote. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yo, Yon ngu Anutro ingondudu eyingo oni, ngundo Anutro ingondudu eyingo oni gidega ngu dagayeroote. Ndadiro nguro, Anutro mandeno, Anutdo Yonya ngandiro eyingo. Nondo ko oni gura soweyootoowe, ngundo ge koretero uro, noro mandene wesiyoro ewa. Ngundo gengo oorege yoonenengowa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nondo yeno hamoo eteno. Sonoyeroyingo Yon nguro oowooyi, ngundo merako oni tunooteyingo nga bidodo dagayeroote. Ene Anut doongeyemo, noro nowoondoye hamoo tetenggoku, ngu kewooroyemo oni bingamini kiningga, ngudodo Sonoyeroyingo Yonro oowooyi dagate. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Yo, kuri Sonoyeroyingo Yondo no tunooteweroyi, nguro mande wesiyoro eyingo. Ngu naruno, ko ataga nga naruno nguya, Anutro mundi oni enengo yanggangoye, ngundo Anutro mande murini, ngundo enengo oni simoo bare soboyerooteku, ngu oweyeroro, andangewero ko yanggango tetenggo. Ene ngundiro tetenggoku, ene oni oowooyingga oorengo Anutno nowoondoyemo hamoo tetenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Anutro ingondudu eyingo oniku, mamana mandeno nguya, ko sonoyeroyingo oni Yon nguya, ngu bidodo nga narunggano ngano, Anutdo noore ko yoyoweroyi oni Krayis soweyootoni ombuweroyi, nguro mande eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ene ye mete nowoondoyemo hamoo teya ngu, asa, ye ingoyi. Yon ene Ilayisa oningga ngundo ombute. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","16","Oni gura sodeyidodo tetoningga ngu, asa, ene komo gome ingoni! Oni simoo bare ngano oorootenggoku, ngu simooyembo ende kewooroko iriritetenggoku ngundiro. Simooye wata gurado simooye gidegaro meno yanggango eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Noore nggusi uwooro, yambo udooye, nguro ye ma kunoyingo. Ngundiro nangge, noore nggusi uwooro, nowoondoyi teweroyi yambo udooye, nguro ye ma sendoyingo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ngundiro nangge, simooyembo koondoonge tewero ma oni oni teyingo, nguro ye nguya, Sonoyeroyingo Yon oningga, nguro ko noro nguya, ye noorengo ma oni oni tetenggo. Yo, Sonoyeroyingo Yon ngundo omburo, ene oowari ko Wayin sonoyi nguya oowooyingga ma netoni, nguro oni simoo baredo enengo muri ngundiro kenoro eyingo. Nga oningga nga ngu, mbooro biyomi eneno ooroote. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ene Anutro Nangoni Oni Kirarongo nondo omburo, oowari nero, Wayin sono bodaga netoowe, enendo neyoro etenggo. Nga oningga nga oowari urungga oorengo, rogoyimo neweroyi, ngu dagaro nete. Ngundiro nangge, ene Wayin sonoyi nguya urungga rogoyimo neweroyi, ngu dagaro nete. Ene Gabuman digi beye yoweroyi oni ko mbumbuwadodo oni nguya nguro dobooye. Ero eyingo. Ene Anutro ingondudu gomengga, onindo ngu kenoro, ngandiro ingootenggo. Anutro simoo bare, ngundo muri gome nenengo ngu keyootenggoku, ngundo simoo bare gidarega etuyerootoyi, kenoro etenggo. Hamoo oorengo, Anutro ingoyingoni gomengga nga ngu, nenengo oorengo. Ero etenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yisasdo ende gidegawoore muri songo oorengo gura onindo ma teweroyimu, ngu oni simoo bare doongeyemo teyingo. Ngundiro tetoni, ene oni simoo baredo oo ngu kenoro, nowoondoye ma yowoorengoyingo. Nguro Yisasdo ngu naruno nguno damoni yero, ngu endemo simoo bare ngu yeyoro mamanayeroyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ye Korasin, ko, Betisayida ende erayaga nguno simoo bare oorootenggoku, yengo nondo nowoondoyi teyunooteno! Nondo Tayiya ko Sayidon ende erayaga, nguno simoo bareno muri songo oorengo gura onindo ma teweroyi, ngu nondo yengo endemo tewonoku, ngundiro eneno tetoowe ngu, asa, ngu ende erayagano oni simoo bare, ngundo ngundiro oo kenoro, nowoondoye kowuri ingoro, nguro ene sodedomangge nowoondoye yowoorengoro, noro hamoo ingowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Asa, no yeno hamoo eteno. Kootuyisina, oni simoo bare wirikoyeroweroyi naru urungga nguno, yendo kowuri yowanggoku, ngundo Tayiya ko Sayidon oniro kowuriye tunootewaku ngu dagaro yowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Arisa, ataga, no ye Kapeniyam endemo oni yeya eteno. Yengombo ingootenggoku, yengo ende ngundo ende bidodo merako oorootenggoku nga dagayeroote, bine? Ngundiro nguya kini. Anutdo ye yoyoro, Setanro ende biyomi de nombo ma kumooweroyi, nguno oorongooyerowa. Oni gurado Sodom endemo, muri songo oorengo gura onindo ma teweroyi, nondo ye kewooroyemo tewonoku ngu, arisa, ataga Sodom endega ngundiro oruwa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ene no yeno hamoo eteno. Kootuyisina, oni simoo bare wirikoyeroweroyi naru urungga nguno, yengo kowuriye yowanggoku, ngundo Sodom oniro kowuriye tunootero, ngu dagawa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ngu naruno, Yisasdo Eweyimo yemboongero eyingo. Awa, ge sambo meraro Simburi Urungga. No oowoongge ero bingamingge okooteno. Ndadiro nguro, gengo mande gome ngu oni ingonduduyedodo nguno oongooro, oni ingoyingoye bodaga, simooyemboro ingoyingoye ngundiro oni ngu etuyerowo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Yo, awa, gengombo ingoro tewoku, nguro ge oni oni tete. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Yisasdo mande gura eyingo. No Awanembo oo bidodo nunowo. Awando nangge enengo Nangoni ingoote. Ngundiro nangge, Nangonimbo nangge eweyi ingoote. Yo, Anutro Nangoni, ngundo eweyi ingoro, ene Anutro Mande Keta Mesarango ngu oni simoo bareno wesiyoro yunowo. Oni gidarega nowoondoyemo hamoo tewanggoku ngu, Nangoni kuri rogoyerowoku, ngu oni ngundo Awa nguya ingootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ye noro kenemo oni simoo bare, ye kowuri urungga koorowooro, kiyayi yetenggoku ngu, asa, ye nono ombutoyi, nondo ye kengeyingo yunowano. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ye ngu kongga yunowonoku, ngu kowuri kini. Ndadiro nguro, no ye hoorooweyerootoowe, noro murine imakeyingo, ko, nondo nenengo oowoone bingami ngu ma okooteno. Ngundiro nguro, ye nono ombutoyi ngu, nondo yengo gaboye hamoo kengeyingongga, ngu yunowano. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Yo, noro kongga nondo ye yunowonoku ngu, ngu kowuri kini, imakeyingo nangge. Ngu ooga ngu koorowooyi, ero yunootenoku, ngu kowuri kini. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Yudaro naru kundingiyi Sabat gurano, Yisas enengo kirikiri onindo nggire ko gura oore kewoorokuri oorowuyingo. Ngundiro oororo, enengo kirikiri onikundo nggire engge wimbuyimonggo andangero, goweyi besooro, engge tanggorimu keta neyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ene ngundiro netoyi, Mosesro mamana mande sobowooyingo oni oowooye Parisi, ngundo yeyoro eyingo. Yisas, keno! Gengo kirikiri onindo Sabatno ko tetenggoku, ngu mamana mandeno ewoku, ngu toongootenggoku ngu! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ngundiro etoyi, Yisasdo mande gumi eyingo. Ye kuri Iserel mera oni sobosobo koreteyingo urungga Dewit, enengo me oni, ngundo oodooro kumooro teyingomu, ngu ye nguro mande kandangero, kuri ingowonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Dewit ko enengo me oni Yudaro towimbo ya kundingiyi ngu newendemo uro, oomanongoyingo kundingiyi ngu yoro neyingo. Ngu oomanongoyingo kundingiyingga, enendo neweroyi kini. Kini, ngu Anutro wooro yeyingo oni kundingiyi, ngundo nangge neweroyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ye Mosesro mamana mandeno kuri kandangero ingowonggo. Anutro wooro yeyingo oni kundingiyi, ngu Sabatno ngu mete Yudaro towimbo yambo yano ngu ko teweroyi, nguro roogo kini. Yo, ene Sabatno Anutro simoo bare hoorooweyeroweroyi, nguro kowurini kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Arisa, no yeno hamoo eteno. Nga oningga nga oorooteku, ngu oowooyi ngundo Yudaro yowuru ya nguro yanggangoni ngu bidodo dagayeroote. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kuri, Anutro mandeno ngandiro eyingo. Anutdo no wooro kundingiyi nguro ma oni oni tero, ene nowoondoyi teweroyi nguro gome ingoote. Ero eyingo. Ye nga mandega ngaro damoni gome ingoro ngu, asa, ye oni mbumbuwa ma tetenggoku ngu, ma kowuri yunowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Yo, hamoo, no Anutro Nangoni Oni Kirarongo nondo Sabat nguro Simburi urungga. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","10","Yisas ngu musiyonggaku yokoro, ene Yudaro yowuru yano uro, ene oni gura kandeyi bingo yeyingomu, oodoni kenoyingo. Ngu naruno, Mosesro mamana mande sobowooyingo oni oowooye Parisi, ngundo Yisas goweyi sanggawero kingo mande eweroyi ngu erewero, nguro sumoo eyingo. Mosesro mamana mandeno sayi oni mete Sabatno yomosiyeroweroyi, ngundi kini bine? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","12","Ene ngundiro sumoo etoyi, Yisasdo mande gumi eyingo. Sabatno yengo Sipsip ngu mereno soretoni ngu, ye ngundiro kenoro yokootoyi, mereno oruwa, ngundi yowanggo, bine? Ngundiro nangge, Anut doongeyimo, onindo Sipsip ngu dagate. Anut doongeyimo, ngu mete oni nowoondoye yunoro, Sabatno oni hoorooweyerowanggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ngundiro ero, ene yowoorengoro, oni kandeyi biyominggakuya eyingo. Kandege yoonenengo. Etoni, ene ingoro, ngundiro tetoni ngu, kandeyi biyominggaku kandeyi metemi gidarega ngundiro tunooteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Arisa, Parisi onindo ngundiro kenoro, ene sanggiri tero, ngu musiyonggaku yokoro, saro, yowuruwooro, Yisas ureyi kumooweroyimboro mande oowooyingga eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","16","Yisas ene Parisi onindo ureyi kumooweroyimboro mande ewonggoku ngu ingoro, nguro ene ngu endega ngu yokoro toongeyingo. Ene oni simoo bare oowooyingga, ene keyoro, oorowutoyi, Yisasdo oni sayidodomu, ngu bidodo yomosiyeroro, enendo simoo bareya mande yanggango eyingo. Ye ingonda teyi! Nondo ooga tetenoku nga, onino ma yootunoro ewero. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ngundiro nguro, ngu tetoni ngu, kuri Anutro ingondudu eyingo oni, Ayisaya, ngundo mandega eyingomu, ataga engge tunootete. Ene Yisasro ngandiro nakangoro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","21","Nga oningga, noro ko oni oorengo, nondo kuri sunggi yewono. Nondo nguro gome ingoro, nowoondone ene inooteno. Nondo nenengo Yuka Kundingiyi ngu oninggano ngu newendemo yetoowe, ene noro muri nenengo oni simoo bare mera bidodomo wesiyoro ewa. Ene rongge sambi manggaru ma tetoni, oorekononggo manggowo ngguyi ma ingowanggo. Ene oni nowoondoye yanggango kini ngundi kowuri ingootenggoku, ngu nowoondoyi teyunoyi. Ataga, ene ngundiro ko teteku ngu, kootuyisina, wirikoweroyi naru wengamo, nguno nowoondoyi teweroyi muri nenengo ngu simoo bare doongeyemo tunootero, muri songo dagayerowa. Ngundiro nguro, oni simoo bare mera bidodomo nowoondoyemo hamoo tero, ene nangge sobowoowanggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Arisa, ngu naruno, oni gura mbooro biyomimbo doongeyi manggowo gosiyoyingomu, ngu yoro, Yisasno mayeyingo. Yisasdo ngu oninggaku yomosiyootoni ngu, ene mande gome ero, ko doongetero, mera kenoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ene ngundiro tetoni, oni simoo bare ngu kenoro, sori urungga yokoro, eyingo. Nga oningga nga, ene mera oni sobosobo koreteyingo urungga Dewit, nguro soweni nangge bine, ngundi, ene Anutdo noore ko yoyoweroyi oningga rogo tewoku, ngu bine? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Parisi onindo simoo barero mande ngu ingoro, ene Yuka Kundingiyi nguya, kootuyisina mande eyingo. Ngu Yisasga ene mbooro biyomi oweteku, ngu mbooro biyomi nguro tabango urungga, Beyelesebab Setan, ngundo yanggango inootoni, ko tete. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ene ngundiro etoyi, arisa, Yisasdo enengo ingonduduye ingoro eyingo. Mera sobosobo koretero oni gura, ngundo enengo oni simoo bare soboyerooteku nguya, enengo nangge ebe utoro, nguno ma siyero ngu, asa, ene mete yanggango ma dikaro oruwanggo. Ngundiro nangge, ende gurananggemo oni nowoondoye gobooro ma siyero ngu, asa, ngu endega ngu ngundiro sugi yanggango ma oruwa. Ngundiro nangge, ya gurananggemo oni wesoowooro, eraya tunootero, enengo nangge, ngu ebe utoro, ngu yano oni ngu yanggango ma ootooro, ya toongooro, songo songo sawanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ene ngundiro nangge, Setando enengo nangge mbooro biyomimboya ebe utoro ngu, wesoowooro, eraya tero, yanggango ma dikaro oruwa. Ene sodedo kinitewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Asa, nondo mbooro biyomi Beyelesebab Setan ngu oowooyimonggo, owewanoku ngu, arisa, yengo oni ngundo mbooro biyomi owewero ngu, ndawu oningga oowooyimo ko tewanggo? Ngundiro nguro, yengo onindo nangge yengo mande etenggoku ngu, ngu wirikowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ngundiro nangge, Anutro Yukambo hooroowenerootoni, mbooro biyomi owewanoku ngu, arisa, ye ingootenggo. Anutro naru enengo oni simoo bare soboyerooteku, ngu ataga yeno ombute, ero ingootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ngundiro nangge, no mande adingayi gura yeno eteno. Oni gura ene mete oni yanggango guraro yano kingo uro, oo sitowini andangero yowa, bine? Kini, ene koretero komo ngu oni yanggangongga ngu utombo gome gosiyoro yokoro, ngunonggo ene mete yanimo uro, oo sitowini bidodo andangero yowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Oni gura no doboone kini oruwaku ngu, ngu oningga ngu noro mundi oni. Ngundiro nangge, oni gura no ma hoorooweneroro, Sipsip yoyoro, nowoondoye hamoo teyingo pawa newendemo ma yoyetoyi ngu, asa, ene Sipsip yomburiyerowero ingoro oruwa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ngundiro nguro, no yeno hamoo eteno. Yengo mbumbuwa bidodo, ko Anut kootuyisina ero, yomooyinoro mande biyomi etoyi, nguro ye nowoondoyi tero, yowoorengootoyi ngu, asa, Anutdo kowuriye andangeyunoro kabetewa. Ene oni gurado Anutro Yuka Kundingiyi nguya kootuyisina mande biyomi ewaku, ngu nangge, Anutdo nguro mbumbuwa ma andangero kabetewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Yo, oni gurado no Anutro Nangoni Oni Kirarongo kootuyisina mande biyomi ero, Anutno sumoo yemboongero, ewaku ngu, Anutdo nguro mbumbuwa andangero kabetewa. Ene oni gurado Anutro Yuka Kundingiyi kootuyisina mande biyomi ewaku ngu, ngu nangge Anutdo nguro mbumbuwa ma andangero kabetewa. Ngu mbumbuwaga ngu sugi sugi oruwa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Yisasdo Parisi oniya eyingo. De metemingga ngu gome enggewa. Ngundiro nangge, de biyomingga ngu engge biyomi tunootewa. Koretero, oni de tanggori kenoro, ingoro, ene de metemi ngundi biyomi, bine, ngu ingowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ye sire biyomi simoongo! Ye nowoondoye biyomi oorengo oorooteku ngu! Ngundiro nangge, ye mete manggoyemonggo mande metemi wesiyoro, ma ewanggo. Yo, hamoo oorengo, ye nowoondoyemo ingondudu biyomi oorooteku, ngundiro nangge, manggoyemonggo mande biyomi nguya tunootewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ngundiro nangge, oni metemingga ngu, ene ingondudu gome nowoondoyemo oorooteku ngu, ngu ene muri metemi ngu yeni tunootete. Ngundiro nangge, oni biyomingga ngu, ene nowoondoyemo ingondudu biyomi oorooteku ngu, ngundo muri biyomimu yeyi tunootete. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Asa, no yeno eteno. Anutdo wirikoyeroweroyi naruno, oni kingo mande mande bidodo buribari ewonggoku ngu, nguro damoni Anut doongeyimo ngu, wesiyoro ewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Yo, hamoo, Anutdo yengo mande bidodo merako etenggoku ngu, nguro ene ingoro, enengombo wirikoyeroro, ye oni metemi, ngundi, oni biyomi bine, ewa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ngu narunggano nguno, Mosesro mamana mande sobowooyingo oni, oowooye Parisi, ko, etuyeroyingo onindo Yisas towoongoro eyingo. Oo etuyeroyingo oni, mete ge oo muri songo oorengo gura onindo ma teweroyimu gura tetooga, noore kenowero ingooteto. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ene ngundiro etoyi, Yisasdo mande gumi eyingo. Ye merako oni oorootenggoku nga, ye ingonduduye biyomi ingoro, sebobarese muringga ngu tero, ngunonggo Anutno nowoondoye hamoo ma tero, muri songo gura onindo ma teweroyimu, ngu kenowero, nono erorootenggo. Ataga, nondo yeno sunggi gura ma tetoowe kenowanggo. Kini, nondo ngu Anutro ingondudu eyingo oni kurimi Yona, nguro sunggiga ngu nangge ewano. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yo, kuri Yona iso urungga oorengo ngu kawuyi newendemo sa suwoo kabusa, nguno oriyingo. Ngundiro nangge, no Anutro Nangoni Oni Kirarongongga nguya sa suwoo kabusa, mere newendemo ngu oruwano. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Yo, Yonando Anutro mande Niniwa endemo oni ngu yunootoni, nguro ene nowoondoye hamoo yowoorengoyingo. Ene ye kewooroyemo oni gura (Yisas) oorooteku, ngundo Yonaro yanggangoni ngu dagate. Ene ye nguro mande ma ingoro, nowoondoye yowoorengoro, hamoo ma tetenggo. Arisa, nguro ngu, naru wengamo, oni wirikoyeroweroyi naruno, Niniwa onindo ye nga oni oorootenggoku ngano dikaro, mande yanggango ero, goweye sanggaweyerowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kuri, Anutdo Yuda merako oni sobosobo koreteyingo urungga, Solomon, ngu ingondudu urungga oorengo inoyingo. Nguro ngu, merako bare sobosobo koreteyingo urungga, ngundo Solomonro ingondudu urungga ngu ingowero, nguro ngu enengo mera oriroko biyomimu ngu yokoro, yade yade mayero, enendo ingondudu urunggaku ingoyingo. Ene ye kewooroyemo, oni gura (Yisas) oorooteku, ngundo Solomonro ingonduduni, ngu dagate. Ene ye ngu kenoro, nowoondoye hamoo ma yowoorengootenggo. Arisa, ngu bare sobosoboga nguya naru wengangga nguno omburo, dikaro, yengo mande muri biyomi tewonggoku, ngu bidodo yengo goweye sanggawero mande yanggango oorengo ewa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Yisasdo Parisi onino mande gura ko eyingo. Mbooro biyomingga, ngundo oni newende yokoro ngu, ene mera arimo kengewero musiyo erewero oorowuyingo. Ene ngundiro tero, ene ma kenoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Mbooro biyomi kengewero musiyo ma kenoro ngu, nguro ene enengo ya kuri oruwoku, nguno ko oorowuwero eyingo. Arisa, ene yano ko omburo, nguno oni kini, ya sarayi kenoro, oo bidodo nenengo oodoni, ngu kenoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Arisa, ene oo ngundiro kenoro oororo, mbooro biyomi kandegura gidemboro eraya yoyoro, omburo, yano uro, eneya oriyingo. Enengo dobookuriyi, nguro muri biyomi oorengo, ngundo koreteroga muri biyomi tewoku, ngu dagate. Kuri ngu oningga biyomi oruwoku, ataga, ene biyomi oorengo urungga ooroote. Ngundiro nangge, oni muri biyomi merako ngano tero oorootenggoku, ngundiro tewanggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ngu naruno nguno, Yisas oni simoo bare kewooroyemo bibitero, mande wesiyoro, yunorootoni ngu, nemi koneyo eneya mande ewero omburo, endesina dikayingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Dikatoyi, asa, oni gurado Yisasno eyingo. Ingo, nangge konege geya mande ewero omburo, endesina dikatenggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ene ngundiro etoni, asa, Yisasdo mande gumi eyingo. No namone konene ngu oone? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Yisasdo enengo kirikiri onikuno kandesisi tero eyingo. Ngu hamoo oorengo, oni endesina dikatenggoku, ngu noro namone konedoboone. Ene nga oni ngano nowoondoyemo hamoo tero oorootenggoku, nga nguya noro namone konedoboone. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ngundiro nangge, oni simoo bare, ngundo Awane sambo endemo oorooteku, nguro ingondudu keyowanggoku ngu, ngu oni ngu noro konene, kuwookuwoone ko nanamone. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ngundiro naruno, Yisas ya yokoro, oororo, Galili sono koongeyingo dabemimo nguno bibiteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ene ngundiro tetoni, oni simoo bare oowooyingga oorengo mayero, Yisas tanggeyimo yowuruwootoyi, nguro Yisas ene wanggo sanganimo oorero, bibitetoni, oniku ngu sono dabemimo keredi sanganimo oriyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Asa, ngu naruno, ene mande adingayi yunoro, nguno oo oowooyingga etuyeroro eyingo. Oni gura kono Rayis yuwooyi kuriyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ene kuriyootoni, Rayis yuwooyi gidega ooreko soretoni, nguno numbo mayero nemukoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Oo yuwooyi gidega mera digi gumi digidodo musiyosina soreyingo. Mera nguno urungga kini. Nguro oo yuwooyingga ngu sodedomangge ooreyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ene huri uro, mera newendemo uweroyi kini. Mera bodaga nangge nguro ngundiro teyingo. Ene sa oorero, kenootoni ariyeyingo. Nguro digi kookingombo dedoni, bidodo ariyero kumooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Oo yuwooyi gidarega utoo so sanggiridodomu, kakari dimoo uto oo kewoorokono soreyingo. Kakari dimoo uto sanggiridodomu oorero, ngundo doobengoro wiriyoyingo. Ngundiro tetoni, nguro ma enggeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ene oo yuwooyi gidarega mera gome oorengomo soreyingo. Ngu oo yuwooyinggaku gome oorero, urungga yero, gome enggeyingo. Gidarega engge onibi kandegura (100), gidarega engge onibi kabusa (60), gidarega engge onibiga kande eraya (30) enggeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Oni sodeyidodo ngu mande ingoya, ene komo gome ingoyi! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Kootuyisina, Yisasro kirikiri oniku eneno omburo, sumoo eyingo. Ge ndawugaro nguro, mande adingayi nangge oni simoo bareno ete? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ene ngundiro sumoo etoyi, asa, ene mande gumi eyingo. Anut Oo Bidodo Simburi Simbunani, ngundo mande muringga, ngundo enengo oni simoo bare soboyerooteku, ngu kombiteyingo oorooteku, ngu ye tunoo etuyerowa. Ene oni gidaregano ngu, no mande nga eneno yootunoro ma ewano. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ngundiro nangge, oni gura Anutro Mande Keta Mesarango ingoro, ngu dowootoni, Anutdo oo gura soweyoro, ingonduduni oowooyingga inowa. Ngundiro nangge, oni gura Anutro Mande Keta Mesarango ngu ma dowooro, ene koretero yowoku ngu nangge dowoororuwaku ngu, asa, Anutdo ngu nguya andangero yowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nondo mande adingayi eneno etenoku, nguro muri ngandiro. Ene doongetero, oo kenowanggoku ngu, ene nguro muri gome ma ingowanggo. Ngundiro nangge, ene mande ingoro ngu, ene nguro ingondudu tero, nowoondoyemo yoro ma siriyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","15","Ngundiro oni simoo bare, nguro muriye kurimi Anutro ingondudu eyingo oni, Ayisaya, ngundo mandega eyingomu, engge tunooteyingo. Ene ngandiro eyingo. Ye mande ingootenggoku ngu, ene nguro damoni ma ingootenggo. Ye doongetero kenowanggoku ngu, ene oo nguro ma ingowanggo. Oni simoo bare kuri nowoondoye ukingoyingo. Ene sodeye ukingoro, nguro ko doongeye kumoondi teyingo. Muri ngundiro ma tetoyi ngu, arisa, doongeyembo oo kenoro, ingoro, sodeyebo mande gome ingoro, yoro, nowoondoyemo gome siriyoro, ngu ingondudu tewanggo. Ene nowoondoye yowoorengootoyi ngu, asa, nondo mete omburo, ene yomosiyerowano. Ene mande nenengo oorengo ngu ingowero ngu yokootenggoku, nguro enengo muriye biyomi ngu ma yomosiyowanggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Yisasdo mande gura eyingo. Ngu gome oorengo, ye ngu oni ngundiro kini. Ye doongeyembo oo kenoro, nowoondoye gome ingoro, ko sodeyebo ingoro gome ingowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Asa, no yeno mande yanggango eteno. Kuri, Anutro ingondudu eyingo oni, ko, oni gidarega nowoondoyemo hamoo teyingomu, ngundo nowoondoye bidodo yengo ataga kenootenggoku, ngu kenowero ingowanggo. Ene yendo Mande Keta Mesarango ataga ingootenggoku, ene nguya ingowero hahangewonggoku, nguro ngu, ene ereremo kini. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ye komo ingoyi! Onindo oo yuwooyi kono kuriyowoku mande adingayi, nguro damoni ngu ngandiro. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Oni gidarega Anutro mande muringga, ngundo enengo oni simoo bare soboyerooteku, ngu ingoro, ingondudunimo nangge ingoro, nguro gome ma ingootenggoku ngu, arisa, sodedomangge Setando omburo, Anutro mandega ingowonggoku, ngu andangero yowa. Ngungga ngu, oo yuwooyi ooreko soreteku ngundiro. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Oni simoo bare gidarega ngu Rayis yuwooyi mera digidodomo soreteku ngundiro. Ene mande ingoro, sodedo yoro, nguro ene oni oni teyingo. Oni oni tero, ene kootuyisina nguro ingondudu tero, ngu ene newendemo hamoo tewoku ngu yokowa. Ene huri moore kini ngundiro tewa. Enengo newende hamoo teyingo ngu, ootuwoo bodaga. Ene Anutro mundi oni, ngundo oni simoo bare Anutro mande ingowonggoku, ngu kowuri urungga yunootenggo. Ngundiro tetoyi ngu, sodedomangge, oni simoo bare gidarega enengo nowoondoyemo hamoo ngu yokoro, Anut kootu inowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Oni simoo bare gidarega ngundiro oo yuwooyi utoo sanggiridodo kewoorokono soreyingo. Ene mande ngu ingootenggoku, nguromu ene kowuri guradiro nga merangga ngaromu eneno tunootetoni, ko, digi beye urungga yoweroyimboro nguro ingondudu bidodo, ngundo Anutro mande doobengoote. Ngundiro oni simoo bare ene gome ma enggewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Oo yuwooyi mera gomemo soreteku ngu, ene oni simoo bare gidarega ngu, ene Anutro mande ingoro, yoro, gome dowooro, gome enggewanggo. Yo, oni Anutro Mande Keta Mesarango ngu ingoro, nowoondoyemo gome siriyoyingo. Oo gidarega engge oowooyingga oorengo (100), gidarega engge rogomo nangge (60), ko gidarega engge bodaga nangge (30). Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yisasdo mande adingayi gura yunoro eyingo. Anutro mande muringga, ngundo enengo oni simoo bare soboyerooteku, ngu oni kono oo yuwooyi gome kuriyooteku ngundiro. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Oni simoo bare suwoono wetomukootoyi, ko simburiga nguro mundi oninggakundo mayero, kono so biyomi oo yuwooyi kewooroko oorongooro toongeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kootuyisina, Rayis yuwooyi ko so biyominggaku nguya yowuruwooro ooreyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Arisa, ko oniku ko simburimo oororo eyingo. Oni urungga, noorendo ingootetoku, ngu gengo kono oo yuwooyi gomemu ngu kuriyowo. Ndadiro nguro, so biyomingga nga nguya oorete? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ene ngundiro sumoo etoyi, enendo ko onikuya mande gumi eyingo. Ngu mundi oninggado tewo. Ngundiro etoni, ko onikundo eneya gumi eyingo. Ge ingootooga, noorendo oororo, so biyomi ngu mete gumoowato, bine? Ero sumoo eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","30","Ene ngundiro sumoo etoyi, enendo mande gumi eyingo. Kini, yendo so biyomi gumooro nguno ngu, Rayis nguya gumoowanggo. Ngundiro nguro, erayadodo yokootoyiga nguno oriri. Kootuyisina engge mandoni yeyingo narunogogo, ngu koyi teweroyi onino ewano. Yendo koretero so biyomimu gumooro kaweroyimboro witumooyi. Ene yendo Rayis yoro, noro oowariro yano yowuruwooro, wata yewanggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Asa, Yisasdo mande adingayi gura yunoro eyingo. Anut Oo Bidodo Simburi Simbunani, ngundo mande muringga enengo oni simoo bare soboyerooteku, ngu de gura oowooyi Masitet yuwooyi ngundiro. Onindo ngu Masitet yuwooyi yoro, enengo kono miyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Masitet yuwooyingga ngu bobodi oorengo puka yuwooyi ngundiro. Oo ngu mitoyi ngu, enengombo oorero, de urungga biyomi yero, oowari gidarega kono ngu bidodo dagayeroro, enengo kambini urungga yero, yongeyi tetoni, numbo ngu sanganimo bibitetenggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Asa, Yisasdo mande adingayi gura ene yunoro eyingo. Noore Anut Oo Bidodo Simburi Simbunani, ngundo mande muringga enengo oni simoo bare oo soboyerooteku, ngu ene oomanongoyingo koongeweroyi, Yis ngundiro. Baredo ngu Yis yoro, oomanongoyingododo yowuruwoorootoni, Yisga, ngundo yeni oororo, oomanongoyingo ngu bidodo koongewa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yisasdo oni simoo bareno mande adingayi nangge yunoro, ene mande gura tunoo eneno ma wesiyoro yunoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ngundiro nangge, kuri Anutro ingondudu eyingo oni gurado mandega eyingonggaku, ataga engge tunootete. Ene Yisasya ngundiro eyingo. Nondo manggone goosooro, mande adingayi ewano. No mande kuri kombiteyingo oruwoku, Anutdo amana nga sambo mera yeyingo naruno yade yade oororo, wenga omburo, ataga nguro tunoo wesiyoro eteno. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Arisa, Yisasdo enengo kirikiri onidodo oni simoo bare yokoro, yano uro, eneno oororo eyingo. So biyomi kono ooreteku, nguro mande adingayi gedo ewoku, nguro damoni nooreno etooga, ingowato. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yisasdo mande ngundiro ingoro, ene mande gumi eneno eyingo. Oni gura kono oo yuwooyi metemi kuriyowoku ngu, ngu no Anutro Nangoni Oni Kirarongo, ngu no ngundiro. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Enengo ko ngu, ngu mera bidodo ngundiro. Oo yuwooyi kono metemimu ngu oni simoo bare Anutro pawa newendemo oorootenggoku, ngu ngundiro. So biyomingga ngu, ngu oni simoo bare gidarega Setanromu. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Oni so biyomi kono kuriyowoku, ngu Setan. Engge yoweroyi narungga ngu, ngu naru wenga wirikoyeroweroyiga ngu ngundiro. Engge yoweroyi oningga ngu, ngu Anutro sambono oni. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Onindo so biyomi gumooro, yowuruwooro, de nombono kaweroyi ngu, ngu naru wengamo, nga merako ngundiro tunootewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","No, Anutro Nangoni Oni Kirarongo, Anutro sambono oni ngu soweyerootoowe, omburo, ngundo oni simoo baredo oni gidega yowoosooro, mbumbuwa tetenggoku oni ngu oweyeroro, ko, oni muri biyomi tetenggoku nguya oweyerowa. Oweyerootoyi, Anut Oo Bidodo Simburi Simbunani, ngundo endega enengo oni simoo bare soboyerooteku, ngu newendemo ma uwanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ngundiro oni ngu, ene Setanro ende biyomi de nombo ma kumooweroyi nguno oorongooyerootoni, ene sendo urungga biyomi tero, metokarikari tero, ngundiro sugi sugi oruwanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ngundiro naruno, oni biyomi Setanro endemo oruwonggoku, oni nowoondoyemo hamoo teyingo ngu Anut Oo Bidodo Simburi Simbunani, ngundo endega enengo oni simoo bare soboyerooteku, nguno sugi sugi oruwanggo. Ngu ende gomenggano nguno, Kristen oni simoo baredo muri nenengo oorengongga, ngundo himi ogisa ngundiro oruwa. Oni sodeyidodo tetoningga ngu, ene nga mandega nga gome ingoni. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Anutdo endega nguno enengo simoo bare soboyerooteku, ngu digi beye oowooyingga oorengo ngundiro. Ngu digi beye ngu Kesdodo mere newendemo oongooyingo. Naru gurano, oni gurado ngu kenoro, enebana ko yoro, mere gumisina doobengoro oongooyingo. Ngundiro tero, ene oni oni tero, sodedomangge oororo, enengo sitowi bidodo oni yunootoni, uriyootoyi, nguro urini yoro, oororo, ene mera simburimo mera ngu uriyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Oni simoo bare Anutro mande muriningga, ngundo enengo oni simoo bare soboyerooteku, ngu ya dogoni Stuwa oni beye goyayi gura erewero yoweroyi ngundiro. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Oni gurado ngu beye goyayiga kenowoku ngu, ngu gome oorengo tetoni ngu, enengo oo yoro, oororo, oni gidaregano soweyoro, ngunonggo digi beye yoro oororo, ngu beye goyayiga uriyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Mande adingayi gura oni simoo bare Anutro mande muringga, ngundo enengo oni simoo bare soboyerooteku, ngu ngandiro. Isoro si sono koongeyingomo oorongootoyi, iso gura gura enengo siko uro oorootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Isoro si isombo angetoni, arisa, yoro, omburo, sagigo keredi sanganimo yeyingo. Oniku bibitero, iso metemi nangge wiyakoro, koondomo yeyingo. Ngundiro nangge, iso biyomiku ngu oorongooyi uyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","Ngundiro nangge, wirikoyeroweroyi naru wengamo nguno, ngundiro tunootewa. Anutro sambono onindo omburo, oni biyomimu, oni nowoondoyemo hamoo teyingo kewooroyemo oorootenggoku, ngu andangeyeroro, Setanro ende biyomi de nombo ma kumooweroyi, nguno oorongooyerowanggo. Ngundiro oorongooyerootoni, ngu de ma kumooweroyinggano nguno sugi sugi ootooro ngu, sendo urungga tero, metookarikari tero oruwanggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yisasdo enengo mande gura sumoo eyingo. Ye mande nga bidodo ingootenggo bine? Etoni, enebana gumi eyingo. Yo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ngundiro etoyi, enendo gumi eyingo. Arisa, ngundiro nguro, Mosesro mamana mande etuyeroyingo oni, ngundo Anut Oo Bidodo Simburi Simbunanimboro mande muringga, ngundo enengo oni simoo bare soboyerooteku ngu, nguro mande gome ingoro, ene ya urungga nguro Simburi ngundiro oorootenggo. Ngu oningga ngundo ene yano uro, oo kurimimu ko ketamu nguya yoro, yowuruwooro, dowooro, koyi tewa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yisasdo mande adingayi yunomukoro ngu, arisa, ene ngu endegaku yokoro toongeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ene yade yade oororo, enengo ende damoni oowooyi Nasaret nguno oororo, oni simoo bare Yudaro yowuru yano, Anutro Mande Keta Mesarango ngu wesiyoro yunoyingo. Yunootoni, oni simoo bare enengo mande ingoro, soriyokoro, sumoo eyingo. Nga oningga nga ingonduduni, ko, oo muri songo oorengo gura onindo ma teweroyimu, ngu yanggangongga ngu ndanonggo yoro tete? ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","56","Nga oningga nga ya yeweroyi oningga, nguro nangoni nangge. Noore kuri ingowooto. Enengo nemi, Mariya, ko, enengo konedoboongo, Yemus, Yosep, Yudas, ko, Sayimon. Enengo kuwookuwooyi nguya, ngano nooreya oorooteto. Ngu ingonduduningga, ko oo tewoku ngu, ndanonggo yowo? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ngundiro ero nowoondoyemo sanggiri teyingo. Ene Yisasdo gumi eyingo. Mera bidodomo, Anutro ingondudu eyingo oni yeyoro ngu, ngu oni ngu Anutro oni urungga. Ene enengo yano, ko, enengo ende damonimo nguya oowooye bingamiye kini. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ndadiro nguro, ene nowoondoye hamoo ma teyingo, nguro Yisasdo ngu endegano nguno, oo muri songo oorengo gura onindo ma teweroyi, ngu oowooyingga ma teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ngu naruno, Herod ngu Rom Gabuman oni, ngundo Galili oniro tabango oode, nguno ene Yisasro mande binga ngu ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ngundiro nguro, Herodndo sori urungga yokoro, enengo kirikiri onino mande yanggango eyingo. Eyi!! Ngu oningga ngu, ngu sonoyeroyingo Yondo, kumoononggo ko ootoogeteku ngu! Nguro ene muri songo oorengo gura onindo ma teweroyimu, nguro damoni yanggangonidodo tunootete! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Herodro sosoreyingo, ngu muri ngandiro. Kurimi, Herodndo koneyo Pilip bareyi, oowooyi Herodiyas, ngu yakakayi yoyingo. Nguro Yondo barega ngu erambarisa, nguro mbumbuwayari yootunoro mamanayeroyingo. Ngundiro etoni, Herodro me onindo Yon dowooro, ya biyomimo yeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ngundiro tero, Herodndo Yon ureyi kumooweroyimu, ene endemo oni simoo bare yeyoro, sosorero, nguro ene yokoyingo. Ndawugaro nguro, ene ingootenggo. Yon ngu Anutro ingondudu eyingo oni, ero ingoote. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Herod ene oo simbo urungga kayingo, ndadiro nguro, enengo naru nemimbo bisiyoyingo naru ingondudu teweroyimboro oo kayingo. Ngu naruno nguno, Herodiyasro namboni, ngundo ya newendemo omburo ngu, yambo utoro kunoyingo. Herodiyas nambonimbo yambo kunootoni, nguro Herod gome ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ngundiro tetoni, nguro Herodndo ngu bare buniyonggaku ngu kenoro, oni oni tero, ene mande sorumimonggo hamoo oorengo eyingo. Ge komo nono oo gura nuno ewaku ngu, asa, no hamoo gunowano. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ene ngundiro etoni, bare buniyonggaku enengo mande ingoro, nemimo oorero, nguro ingondudu yoro, uro, ene mande gumi Herodno eyingo. Anangu, ge Yon tabango toongooya, koondo samayi gurano yeya, ombuya nuno. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","10","Herodndo bare buniyonggakuro mande ingoro, newende ngu kowuri urungga ingoyingo. Ene kuri mande yanggango hamoo oorengo sorumimonggo tewo. Yo, oni eneya oo newonggoku, ngu doongeyemo ewokuro, nguro ene bare buniyongga nguro mandeni ma yokowa. Ngundiro nguro, ene me oni soweyerootoni, oororo, ya biyomimonggo Yon tabango toongooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Toongooro, koondo samayi gurano Yon tabango yero, yoro, omburo, bare buniyonggaku inootoyi, enendo yoro, nemi inoyingo. Herodiyas Yon tabango kenoro ngu, ene ingonduduno ero ingoro, noro mundi oninggaku kuri kumoote, ero ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Arisa, Yonro kirikiri oni mande ngundiro ingoro ngu, asa, ene omburo, Yon bingo yoro, saro merengooyingo. Ngundiro tero ngu, oororo Yisasno eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yisas ngu mandegaku ingoro, ene ngu endegaku yokoro, ene wanggo yoro, oni kini merako enesu nangge toongeyingo. Ene oni simoo bare oowooyingga oorengo ngu ingoro, enengo ende yokoro, enebana keyoro oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ene Yisas ko oororo, sono dabemimo mayero, wanggo gosiyoro ngu, oni simoo bare oowooyingga oorengo oodoyi yeyoyingo. Nguro ene nowoondoyi teyunoro, enengo sayi nguya yomosiyeroyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Suwootetoni, enengo kirikiri oniku eneno omburo eyingo. Nga merasina ngano oni kini, ngundiro nguro, naru kiniteteku nga. Mete ge oni simoo bare nga soweyerootooga sayi. Nguro ene mete ende namoko namoko ngano saro, ngunonggo enengo oowari uriyowanggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ene ngundiro etoyi, Yisasdo enengo mandeye ngu gumi eyingo. Ndawugaro nguro, ene komo sawanggo? Yendo oowari yunoyi! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ngundiro etoni, kirikiri oni enebana mande gumi eyingo. Noore ngano oowari oowooyingga kini. Ngano oomanongoyingo kandegura, iso eraya nangge moore, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Etoyi, enendo mandeye gumi eyingo. Ngu yoya, ombuya nunoyi, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ene oni simoo bareno ero, ye ombuya so sanganimo bibiteyi. Ero, Yisas ene ngu oomanongoyingo kandeguragaku, iso erayagaku nguya yoro, ene sambono doongetero, Anutno yemboongero esosooteyingo. Enendo oomanongoyingoku oososowooro, kirikiri oni kirarongo yunootoni, ngundo oni simoo bare yunoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Yunootoyi, oni bidodo oo netoyi, kawuye ndinditeyingo. Ngundiro tetoyi, oowari gumi oodoni, enengo kirikiri oni ngu yowuruwooro, si kande eraya kegidemboro eraya (12) siriyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Oni simoo oomanongoyingo neyingo ngu, ngu oowooyingga oorengo ngu 5,000. Ene bare ko simooye ngu ma kandayeroyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kootuyisina, Yisasdo enengo kirikiri onikuya ero, ye sodedo wanggo sanganimo ooreya, ye koreteya Galili sono koongeyingo anduroko urooreyi. Ero nondo oni simoo bare soweyerootoowe sawanggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ene oni simoo bare soweyerootoni, satoyi ngu, asa, Yisas enesu nangge mera purimo nguno, ene Anutno yemboongeweroyimboro ooreyingo. Ene suwootetoni, enesu nangge mera puringgakuno oriyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Suwoono, Yisasdo purimo yemboongetoni ngu, wanggo sono koongeyingo oriroko oodoni, doogo urungga oorero, ngundo wanggo wenggerenggeremoyingo. Ngundiro tetoni, ene sono sanganiwoore wanggo woosooro oorowuweroyi, ko yanggango biyomi teroruwonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Sengewero mera wendooketoni, arisa, Yisas ene Galili sono koongeyingo sanganiwoore kewoongoro, eneno oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ngundiro oorowutoni, enengo kirikiri onikundo Yisas kenootoyi, sono sanganiwoore oorowuyingo. Ene Yisas kenoro ngu, oombooro gurado ero ingoro, nguro ene kimanggaru urungga tero eyingo. Eyi! Oombooroga nga! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ngundiro manggaru tetoyi ngu, sodedomangge, Yisasdo eneya mande mande, ero eyingo. Ye nowoondoye yanggango yeyi! Nondo nangge ombuteno. Ye ma sosorewero! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Etoni, Pitando gumi eyingo. Oo Simburi Urungga, gedo nangge tetoni ngu, arisa, mete no nguya sono sanganiwoore geno oorowuwano. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ngundiro etoni, ene gumi eyingo. Yo, mete ombu. Yisas etoni, asa, Pita wanggo yokoro, sono koongeyingo sanganiwoore Yisasno oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Oororo, ene doogo urungga kenoro, sosorero, damoni yero, sono newendemo uweroyi tero, manggaru urungga teyingo. Oo Simburi Urungga, ge hooroowenero! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Etoni, sodedomangge, Yisasdo kandeyi Pitano yero, dowooro, woosooro eyingo. Ge nowoondoge hamoo teyingo ngu bodaga nangge. Ge ndawugaro ingondudu eraya yoote? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ngundiro ero, enengo erayadodo wanggo sanganimo ooretori ngu, sodedomangge, doogo kiniteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Doogo kinitetoni ngu, asa, enengo kirikiri onindo ngundiro kenoro, soriyokoro, boodoo oondoogero, bagootero eyingo. Hamoo oorengo! Ge Anutro Nangoni Kirarongo! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ngu naruno nguno, ene Galili sono koongeyingonggaku usowooro, mera oowooyi Genesaret, ngu gidesina mayero, wanggo gosiyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","36","Ene wanggo yokootoyi, sodedomangge, oni simoo bare Yisas kenoro, ene ingoro, ende gurasina gurasina yondowidoro, saro, ene sayi oni yoyoro, Yisas oruwoku, nguno mayero, Yisasno ngguyinggayi tero, sumoo sumoo eyingo. Sayi onindo gengo nengguro sosowoomo kandedibiye yetoyi ngu, ge mete enengo sayiye bidodo yeyi kinitewa, bine? Ngundiro etoyi, sayi onikundo Yisasro nengguroni sosowoomo kandedibiye yetoyi ngu, asa, enengo sayi bidodo kiniteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ngu naruno, Mosesro mamana mande sobowooyingo oni, oowooye Parisi, ko, mamana mandero etuyeroyingo oni gidarega nguya, ngundo Yerusalemnonggo omburo, Yisasya yowuruwooro, sumoo eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Ndawugaro, gengo kirikiri oni kandeye ma sonowooro, oo dowooro netenggo? Ene noorengo osisambaro muri ngu ma keyoro yomburiyootenggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","4","Ene ngundiro sumoo etoyi, Yisas enebana eneya sumoo gura gumi eyingo. Ye osisambayeboro mamana mande nguro muri keyoro, ko ndawugaro Anutro mamana mande hamoo ngu, ye ma keyootenggo? Ye kuri Anutro mamana mandeno Anutdo ewoku, ngu ingootenggo. Ero eyingo. Ene ngundiro eyingo. Oni ene komo eweyi nemimboro mandeyari gome keyoni. Oni gura ewenemi kootu yunoro, mande biyomi ewaku ngu, asa, ngu oningga ngu, ene komo kumoowa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Anutdo ngundiro ewoku, ene ye ngu ma keyoro, yengo muriye nangge keyootenggo. Oni gura digi beye ene mete ewenemi hoorooweyeroweroyi mooremu, ene ngu ma hoorooweyerowero ingowa. Ngundiro ingoro, ene ewenemimo eyingo. Gowugowurongo! No digi kuri hoorooweyerowero ewonoku, ngu yoro, no kuri Anut inoyingo. Eneno inoro, nguro no mete yari ma hoorooweyerowano. Ero eyingo. Ngundiro ero ngu, ene Anutro mamana mande kootu inoro, enengo ingondudu nangge keyootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ye mebuye tegedodo oni! Anutro ingondudu eyingo oni, Ayisaya, ngundo, ye ngundiro oni nguno mande nenengo eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Nga oni simoo bare nga manggoyebo nangge oowoone bingami etenggo. Ene nowoondoye ngu no ma nunootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ene kingo nono yambo mande tetenggo. Ngundiro nguro, oni enengo mamana mande nangge etuyeroro, noro mamana mande hamoomu ma etuyerootenggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Arisa, Yisasdo oni simoo bare negoyerootoni, eneno ombutoyi eyingo. Ye ingoya, gome ingondudu teyi! ");
INSERT INTO rwo_rawa_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Oo gura oni goweyi sanganimo oorooteku, ngundo newendesina uro, ngundo oni yeni, ma biyomi yewa. Kini, muri biyomi oni newendemo oorooteku, ngundo endesina ooreteku, ngundo oni yeni, biyomi yewa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ngu naruno nguno, Yisasro kirikiri onindo Yisasno omburo eyingo. Ge Parisi onindo gengo mandege ngu ingoro, geya nowoondoye biyomi yetenggoku, ge ngu ingoote, bine? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","14","Ene ngundiro etoyi, Yisasdo mande gumi eyingo. Ngundiro oni, nguro gome ma ingowero. Yo, hamoo, ene oni doongeyi kiringo ngundiro. Oni doongeyi kiringo gurado, ko, oni doongeyi kiringo gura oore etungoro ngu, asa, enengo erayadodo mereno sorewari. Hamoo oorengo, no yeno eteno. Awane sambo endemo oorooteku, ngundo enengo kono oo miyingo. Oo kono kingo ooreteku, ngu huridodo gumoowa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ngundiro etoni, Pita mande gumi eyingo. Ngu mande adingayingga nguro damoni ndadiro? Ngu nooreno wesiyoya etooga ingowato. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ngundiro etoni, Yisasdo eneno mande sumoo eyingo. Ye nguya ingonduduye kini, bine? ");
INSERT INTO rwo_rawa_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Oo bidodo oni endesina oorooteku, ngundo oni kawuye newendemo uro, ngunonggo oorero toongete. Ye ngundiro kuri ingootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ene muri biyomi oni newendemo oorooteku, ngunonggo endesina ooreteku, ngundo oni yeni, sugabododo tete. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Muri biyomi oni newendemo oorooteku, ngunonggo ootoogero, endesina oorete. Ene ngandiro ingondudu biyomi; oni ureyi kumooweroyi; erambarisa toongooweroyi; oni bare gidarega yakakayi yodowooro yomburiyeroro, yakaka teweroyi; mande godange, ko oniya mande kootuyisina yomoo inoro etenggoku, ngu muri biyomi bidodo nowoondoye newendemonggo oorero, endesina oorete. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ngundiro muri, ngundo oni yeni, sugabododo tetenggo. Ene oo neweroyi naruno, utakaro, kandeyi ma sonowooro ngu, ngundo oni yeni, sugabododo ma tewa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ngu naruno nguno, Yisas ootoogero, ngu endega ngu yokoro, Tayiya ko Sayidon ende erayagano nguno oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Nguno oororo, sodedomangge, bare Kenan merakonggo ngu merasina oorooteku, ngu Yisas kenoro, ngguyinggayi tero, sumoo sumoo eyingo. Oo Simburi Urungga, ge Dewit osiyi! Ge noro nowoondoyi te! Mbooro biyomimbo noro nambone yomburiyoyingo. Nguro ge mete hooroowenero! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ngundiro etoni, Yisasdo nenetero, mande gumi eneno ma eyingo. Ngundiro tetoni, enengo kirikiri onikundo eneno omburo eyingo. Nga barega oweyeroro, meno ero ero ombuteku nga, mete gedo etooga oorowuni! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ene mande gumi eyingo. Anutdo no sowenerootoni, Iserelro Sipsip, enengo oore yokoyingo, ngu hoorooweyerowero ombuwono, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ene ngundiro etoni, ene barega ngu enengo mande ingoro omburo, Yisas keyi damonimo boodoo oondoogero eyingo. Oo Simburi Simbunani, ge no hooroowenero! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ngundiro etoni, nguro ngu, Yisasdo mande gumi ngandiro eyingo. Noore simooyemboro oowari ngu yoro, se ma yunowato. Ngu nenengo kini. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Barega enengo mandeni ngu ingoro, gumi eyingo. Oo Simburi, gedo hamoo ete. Ene sebo ngu oo neweroyi yaba newendemo simooyemboro oo sosorango, ngu netenggo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yisas enengo mandeni ngu ingoro, enebana mande gumi eyingo. Bare, gengo nowoondoge hamoo teyingo, ngu urungga. Nguro ngu, oo sumoo ewoku ngu, ataga engge tunootete, ero eyingo. Ngundiro etoni, ngu naruno nangge, namboni mete teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ngu naruno, Yisas ene ngu endegaku yokoro, Galili sono koongeyingo tanggeyiwoore oorowuyingo. Oororo, ene puri sanganimo oorero, nguno bibiteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Oni simoo bare oowooyingga nguno mayero yowuruwooyingo. Ene oni keye biyomimu; doongeye kiringomu; keyi biyomi yeyingomu; manggoye gosiyoyingomu; ko, sayi oni gidarega nguya yoyoro, Yisas keyi namoko yoyetoyi, enendo yomosiyeroyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ngundiro nguro, oni simoo bare ingondudu urungga teyingo. Ndawugaro nguro, ene oni manggoye gosiyoyingoku mande etoyi, oni keyi biyomingga ngu mete tero, mera wongooro endeyootoyi, doongeyi kiringoku doongeteyingo. Ngundiro nguro, ene Iserelro Anut ngu oowooyi bingami okooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yisasdo enengo kirikiri oniku negoyerootoni, eneno ombutoyi eyingo. No nga oni simoo bare ngaro nowoondoyi teyunooteno. Naru kabusa noya oruwootoku, ene oowariye moore nguya kini. Ene oodoro kumootoyi, soweyerootoowe, enengo yano sawero saro ngu, asa, ene oorekono doongeye toongootoni, mera wongosogurumooro yurewa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Enengo kirikiri onikundo enengo mande ingoro, mande gumi eyingo. Nga mera gumisina ngano oni kini, nguro noore oowari ndanonggo yoro, oni simoo bare rogono yunootooye newanggo? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Sumoo ngundiro etoyi, Yisasdo sumoo gura yunoyingo. Ye oomanongoyingo ndadiro? Etoni, onikundo mande gumi eyingo. Kandegura gidemboro eraya (7), ko, iso bobodi gidega. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Arisa, Yisasdo simoo bareya eyingo. Merakono bibiteyi. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Arisa, Yisas ngu oomanongoyingo, iso nguya yoro, Anutno yemboongero yokoro ngu, oososowooro, enengo kirikiri oni yunoyingo. Yunootoni, ngundo bayetero, simoo bare yunoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Yunootoyi, oo nero mete tetoyi, oo sosorango oodoni, ngu yowuruwooro, si kandegura gidemboro eraya (7) siriyootoyi angeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Simoo oo newonggoku, ngu oowooyingga oorengo, ngu 4,000. Ene bare ko simooye nguya ma kandayeroyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ngundiro tero ngu, Yisasdo oni simoo bare soweyerootoni, enengo endemo endemo sayingo. Satoyi, ngu naruno, Yisas enengo kirikiri onidodo wanggo sanganimo oorero, Magadan merasina nguno sayingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mosesro mamana mande sobowooyingo oni, oowooye Parisi, ko kumooro ko ma ootoogewa ero ingoyingo oni, oowooye Sadusi, ngundo Yisas towoongoro eyingo. Ge sambononggo oo muri songo oorengo gura onindo ma teweroyimu tetooga, oni simoo baredo kenowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","3","Ngundiro nguro, Yisas mande gumi eyingo. Ye sambono doongetero, enengo sunggi kenoro, gome ingootenggo. Suwootetoni, sambo dagoyi yero, kumu yetoni, kenoro ngu, asa, ye ingootenggo. Yangeni naru gome ogisa tewa. Ngundi, suwoononggo ye puri sanganimo doongetero, goboore kenoro, nggururu nguya ingoro ngu, asa, ye ingootenggo. Sono ombuwa, ingoro ewanggo. Yo, ye sambo meraro sunggi gome ingoro, wirikoro ingootenggoku, ene ye ataga muri keta yeno tunooteteku, ye gome ma wirikoro ingootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ye simoo bare biyomi nowoondoye hamoo kini! Ye sebobarese muri biyomi tetenggoku oni! Ye oo muri songo oorengo gura onindo ma teweroyimu, ngu kenowero ngu meno etenggo. Ene no oo muri songo oorengo gura yeno ma tewano. Kini, ye Yonaro oo muri songo oorengo gura onindo ma teweroyimu, ngu kuri ingowonggo. Yisas ngundiro ero, ene yoyokoro toongeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Naru gurano, kirikiri oniku sono koongeyingo usowooro, sagigo oorowuyingomu, ene oomanongoyingo kabetero, ma yoro oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yisasdo mande yunoro eyingo. Ye ingonda teyi! Parisi oni, ko, Sadusi oni nguro oomanongoyingo yeni, koongeweroyi Yis, nguro gome doongeteyi! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ene ngundiro etoni, nguro kirikiri onikundo enengo nangge ero, ingoro eyingo. Noore oomanongoyingo ma yoyingo, nguro ngu, ene ngundiro ete. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ene Yisas ngu enengo mande ingoro, nguro enendo eyingo. Ye nowoondoye hamoo teyingo, ngu bodaga nangge. Ndadiro nguro, yengo nangge mande ngundiro etenggo? Noore oomanongoyingo kini. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ye kuri ingowonggoku, ko ataga ye kabetetenggo. Nondo kuri oni oowooyingga oorengo (5,000 oni) oomanongoyingo kandegura yoro, yemboongero, oososowooro, bayetero yunoyingo. Yunootoyi, nero, mete tetoyi, gumi oodoni, ye oo sosorango gumi si ndadiro siriyootoyi angeyingo? ");
INSERT INTO rwo_rawa_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ngundiro nangge, ye nga mandega nga nguya utakatenggo. Kuri nondo oni oowooyingga oorengo (4,000 oni) oomanongoyingo kandegura gidemboro eraya (7) yoro, yemboongero, oososowooro, bayetero yunoyingo. Yunootoyi, nero, mete tetoyi, gumi oodoni, ye oo sosorango gumi si ndadiro angeyingo? ");
INSERT INTO rwo_rawa_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ndawugaro nguro, ye gome ma ingootenggoku, nondo oomanongoyingomboro ma eteno. Kini, ye Parisi oni Sadusi oni nguro oomanongoyingo yeni koongeweroyi, Yis, nguro ingondare teyi! No nguro eteno. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ene ngundiro etoni, arisa, ngu naruno, ene ingootenggo. Yisas oomanongoyingo yeni koongeweroyi, oo oowooyi Yis, nguro ingondare teyi, ero ma eyingo. Kini, ene Parisi, ko, Sadusi oniro mamana mande biyomi etuyeroyingo, nguro ingondare teyi, nguro ete, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yisas enengo kirikiri oniku ootoogero, ende gura oowooyi Sisariya Pilipayi ngu namoko sayingo. Ngu naruno, saro, oorekono ene kirikiri oni sumoo yunoro eyingo. Oni simoo baredo no ngu Anutro Nangoni Oni Kirarongo, noya ndawu oningga etenggo? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ngundiro sumoo etoni, enebana mande gumi eyingo. Oni gidaregado geya ngandiro etenggo. Ge sonoyeroyingo oni Yon; ngundi, Ilayiya; ngundi, Yeremayiya; ngundi Anutro ingondudu eyingo oni gidarega, ero, geya ngundiro etenggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ngundiro etoyi ngu, asa, Yisas enebana sumoo yunoyingo. Ene yendo ngu noya ndawu oningga etenggo? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Etoni, Sayimon Pitando mande gumi eyingo. Ge Krayis, Anutdo noore yoyowero sunggi yeyingo oni. Anutdo ataga sugi sugi keta oorooteku, ge nguro nangoni. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ngundiro etoni ngu, Yisasdo mande gumi eyingo. Sayimon, Yonaro nangoni, ngu gome oorengo, Anut enengombo ngu ingonduduga gunoote. Merako oni gurado, ngu mandega ma etunggeroyingo. Kini, Awane sambo endemonggo oorooteku, ngundo nga ooga etunggerowo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Pita, no geya eteno. Pita, gengo nowoondoge hamoo teyingo ngu digi yanggango ndoni ngundiro tete. Nguro ngu, Anutdo ge yanggango gunootoni, nguno ge mete oni simoo bare oowooyingga yowuruyeroro, nowoondoyemo hamoo teyingo yanggango yunoro, enengo soboyeroyingo awaye oruwa. Nguro ngu, Setanro yanggangoni, noro oni ngu Anutro pawa newendemo oorootenggoku ngu, ngundo ma oweyerowa. Ene ereremo kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ene nondo ge rogogerowonoku ngu, noro mande murine nguno gedo nenengo oni simoo bare ngu gome etuyeroro soboyerowa. Yo, nondo enengo sambo endega nguro yamuko ngu goosooro, hoorooweyeroweroyi nguro ero, Ki gunooteno. Yo, nondo sambo endemo oorootenoku, ngunonggo ge yanggangone gunootoowe, ge oo gura merako ngano gosiyowaku ngu, nondo sambono nguya gosiyowano. Ngundiro nangge, ge oo gura merako ngano yokowaku ngu, nondo sambono nguya yokowano. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Mande ngundiro ero ngu, asa, Yisasdo enengo kirikiri oniya mande yanggango yunoro eyingo. Ye oni gurano noya Krayis ero, ma ewero, eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ngu naruno Yisas damoni yero, enengo kirikiri oniku mande nenengo oo tunooteweroyi ngu ero yunowo. No kootuyisina, Yerusalem endemo oorowutoowe ngu, Yuda oniro tabango oniku, Anutro wooro yeyingo oni kundingiyi sobosobo oniku, ko, mamana mande etuyeroyingo oni, ngundo nodowooro, ogingo nunoro, nureyi kumoowano. Kumooro ngu, naru kabusagomo, no mere yokoro, ko ootoogero, keta oruwano. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pitando Yisas yoro, sosina oororo, damoni yero, mamanangoro eyingo. Oo Simburi Urungga, ge ngundiro ma ewero! Ngu ooga geno ma tunootewa! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pita mande ngundiro etoni, Yisas ingoro, yowoorengoro, kenoro, mamanangoro eyingo. Pita, gengo ingonduduge ewoku, ngu Setannonggo mayeteku ngu! Ngu Anutro ingondudunonggo kini. Yo, ge oniro ingondudu nangge keyoro, noro ko Anutdo no rogo tewoku, ngu gedo ma hoorooweneroote. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ngundiro ero ngu, Yisasdo enengo kirikiri oni negoyerootoni, mayero, yowuruwootoyi, mande yunoro eyingo. Oni gura no kenerowero ngu, ene komo noro nowoondoyemo hamoo tetoni ngu, nguno ene mete enengo ingonduduni bidodo yokoro, kowuri ene inootenggoku ngu, de omukondi ngundiro koorowooya, no keneroya endeyoni. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Oni gura enengo ingondudu yanggangoni gome dowooro, goweyi sugi oruweroyi ingooteku ngu, asa, ngu oningga ngu, enengo goweyi gaboyi, Anut doongeyimo, ngu hamoo oorengo oonootewa. Ngundiro nangge, oni gura enengo ingonduduni goweyi gaboyi bidodo no nunoro ngu, asa, enengo goweyi gaboyi, kootuyisina, sambo endemo sugi sugi keta oruwa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Oni gura mera ngaro oo bidodo yomukoro, oode kumoowaku ngu, ngu ndawu oogado ene mete hooroowewa? Ngu oningga ngu, ene ndawu oogado enengo goweyi yanggangoni keta oruweroyi, ngu uriyoro yowa? Ene ereremo kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Arisa, no Anutro Nangoni Oni Kirarongo oode, no Awanemboro duridarinidodo enengo sambono Engel oni nguya ombuwato. Ngu naruno, oni merako muri tewonggoku, nguro gumi teyunowano. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","No hamoo oorengo yeno eteno. Oni gidarega nga oorootenggoku nga, ene ma kumooyingomo, ngu koretero, ene no Anutro Nangoni Oni Kirarongo, nondo naru noro oni simoo bare soboyerooteku, ngudodo ombutoni ngu kenowanggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Kootuyisina, naru kandegura gidemboro guranangge yokoro, Yisasdo Pita, Yemus, ko, koneyo Yon ngu oni kabusangga ngu yoyoro, mera puri piru ndandayingo awuno oorengonggano ooreyingo. Nguno enesu nangge oriyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ngu naruno nguno, Yisas moondeyi ngu oni kabusagaku doongeyemo yowoorengoyingo. Yowoorengoro, Yisas enesu guradiro tunooteyingo. Yo, enengo omukumundoongo soru ngundiro tunootetoni, ko, towikumbani nguya soru ngundiro wadori sarayi oorengo tunooteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ilayiya, Mosesya, sambono kuri oode, ngunonggo omburo, Yisas tanggeyimo tunooteyingo. Tunootero, Yisasya mande etoyi, kirikiri oni kabusagakundo yeyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pitando ngundiro kenoro, ene soriyokoro, Yisasno ngandiro eyingo. Oo Simburi Urungga, noore ngano oruweroyi ngu gome. Gedo ngundiro ingootoyi ngu, asa, nondo mete ya tookoododo kabusa yewano. Gura gengo, gura Mosesro, gura Ilayiyaro yewano. Pita ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ene mande eroodoni, goboore gura soru ngundiro tunootero, ngundo doobeyeroyingo. Anutdo ngu goboore kewoorokononggo mande eyingo. Ngu nenengo nangone mesarango. No nowoondone nguro gome oorengo ingooteno. Ye nguro mandeni gome ingoyi! Anutdo mande ngundiro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Arisa, kirikiri oni oo ngundiro ingoro ngu, ene soriyokoro, sosoreyingo urungga tero, nguro ene omukumundooyesinanggo merako sorewonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ene ngundiro tetoyi ngu, asa, Yisas tanggeyemo omburo, ikakoyeroro enendo eyingo. Ye ootoogeyi! Ye ma sosorewero! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Asa, ene mande ngundiro ingoro, doongetero, Yisas enesu nangge eneno oodoni kenowonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ngu naruno nguno, Yisasdo enengo kirikiri onikuya mera puringgaku yokoro, yade yade ooreko utoyi, Yisasdo mande yanggango yunoro eyingo. Ye awuno oo kenowonggoku, ngu ataga nga narunggano ngano, oni gurano ma ewero. Kini, kootuyisina, no Anutro Nangoni Oni Kirarongo mere yokoro, ko ootoogetoowegago, arisa, ngu narunggano nguno, ye mete yootunoya eyi. Yisasdo eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ene ngundiro etoni, Yisasro kirikiri onikundo Yisas sumoo inowonggo. Anut mamana mande etuyeroyingo oni, ngundo ngandiro ewonggo. Anutro ingondudu eyingo oni, Ilayiya, ngundo koretero ko ombutonigogo, ge kootu ko ootoogewa, ero eyingo. Ndatero nguro, ngundiro etenggo? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","12","Ene ngundiro sumoo etoyi, Yisasdo mande gumi ero eyingo. Ngu hamoo, Ilayiya omburogogo oo bidodo yomosiyowa. Nguro, nondo yeno hamoo eteno. Ilayiya kuri ombuwoku, ngu oni watayi kini. Kini, oni enengo muri gura gura ene nangge teyinowonggo. Ngundiro nangge, no Anutro Nangoni Oni Kirarongo, nguya ngundiro ogingo nunowanggo. Ene noro ko nenengo nguya, ene watayi kini. Yisasdo ngundiro ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Yisas oo ngundiro etoni ngu, enengo kirikiri onindo ingoro, Sonoyeroyingo oni, Yonya eteku ngu ero ingowonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","15","Ene puri yokoro, ombutoyi, ngu naruno, oni simoo bare oowooyingga oorengo oodoyi, oni gura omburo, Yisasno boodoo oondoogero, bagootero eyingo. Oo Simburi Urungga, ge no nangonengga nguro nowoondoyi te. Ene komo doongeyi ngganggangero, sagaga tero, mboorombooro tero, gaboyi kumoororoote. Yo, naru bidodo ene nombono, ko, sono nguya soreroroote. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nguro ngu, nondo ene yoro, gengo kirikiri onino ngu oweyi, etoowe, ene ngu mbooroga ngu andangeweroyi nguya, ereremo kini. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yisasdo enengo mande ingoro, nguro ene yuka oorongooro, mande gumi eyingo. Ye nowoondoye hamoo teyingo ngu yanggango kini, ko, ye nowoondoye nenengo nguya kini! No yeya naru puringga oodoowe, naru ndadiro oodegogo, no yengo nowoondoyi tewano? Arisa, ye simooyengga ngu yoya, nono ngano ombuyi! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Asa, Yisasdo ngu mbooro biyominggaku kenoro, mamanangoro, etoni ngu, simoo oorenggaku ngu yokoro toongetoni, ngu naruno nangge, ngu simoo ooregaku mete teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ene ngundiro tetoni, arisa, kirikiri onikundo nangge omburo, Yisas yoro, sosina oororo, sumoo inoro ewonggo. Ndadiro nguro, noore ngu mbooro biyomingga ngu andangeweroyi, ngu ereremo kini? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ene ngundiro sumoo etoyi, asa, enebana mande gumi eyingo. Ye ngu ooga ngu mete ma yomosiyoweroyi, ndawugaro nguro, yengo nowoondoye hamoo teyingo, ngu bodaga nangge. Nondo yeno hamoo eteno. Masitet yuwooyi ngu puka yuwooyi ngundiro. Yengo nowoondoye hamoo teyingo ngu Masitet yuwooyi ngundiro tetoningga ngu, asa, ye mete nga puringga nga etoyiga, nga musiyongga yokoya, musiyo gura etoyiga, ene nguno oororo oruwa. Ngundiro nangge, noro yanggangonemo ngu ko tero ngu, ye mete oo bidodo temukowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Arisa, ye ngundiro mbooro biyomi oweyeroweroyi muringga ngu, ye amana komo yanggango yemboongeya, oowari roogo tero, asa, noro yanggangonemo ye mete mbooro biyomi ngu andangewanggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ngu naruno nguno, ene Galili merako oororo, Yisasdo enengo kirikiri oniku mande yanggango yunoro eyingo. Naru bodagano, no Anutro Nangoni Oni Kirarongo, onindo nodowooro, oni songo kandeyemo noyewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ene no nureyi kumootoyi ngu, no sa kabusagomo mere yokoro, ko keta ootoogewano. Ene ngundiro etoni ngu, enengo kirikiri oni ngu ingoro, nowoondoye kowuri urungga oorengo ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yisasdo enengo kirikiri onidodo Kapeniyam endemo tunooteyingo. Ngu naruno, Yuda yowuru yano digi beye yoweroyi oni, Pitano omburo, sumoo inoro eyingo. Yengo etuyeroyingo oni nguya digi beye yeroote, bine? Sumoo eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ene ngundiro sumoo etoni, Pitando mande gumi eyingo. Yo, ero ngu, yano uyingo. Utoni, asa, koretero Yisasdo eneno sumoo eyingo. Sayimon, ge ndadiro ingoote? Digi beye yoweroyi naruno, merako oni sobosobo koreteyingo ururu mera bidodomo, nguro muri ndadiro? Ene mera simbukuriye oni, ngunonggo digi beye yootenggo, bine; ngundi, oni sowe gidareganonggo digi beye yootenggo, bine? Sumoo eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita enengo mande ingoro, gumi eyingo. Oni sowe gidareganonggo nangge eyingo. Ngundiro etoni, Yisasdo mande gumi eyingo. Asa, ngundiro eteku, nguro mera simbukuriye digi beye yoweroyi koyi ma tewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ene noore ngundiro ma tetooye ngu, ene nooreya sanggiri tewanggo. Ngundiro nguro, ge sono koongeyingomo uya, isoro si oorongo. Oorongooya, iso amana gura yoya, manggowo goosooya ngu, digi beye manggowoomo oorooteku, ngu kenoro, yowaku ngu! Ngu digi beyega yowoku ngu, noorengo geyamboro ene yuno. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ngu naruno, kirikiri oni Yisasno omburo, sumoo ewonggo. Anutro endega enengo oni simoo bare soboyerooteku, nguno oni onendo ngu tabango urungga? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","3","Yisas ngundiro ingoro, ene simooyengga negongootoni, omburo, kewooroyemo dikayingo. Dikatoni, Yisasdo eyingo. No yeno hamoo eteno. Ye nowoondoye yowoorengoya, hamoo teya, simooyemboro muri ngundiro teyi. Ye ngundiro ma tero ngu, asa, ye mete Anutro endega enengo oni simoo bare soboyerooteku, nguno ma uwanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ngundiro nangge, oni gura ye kewooroyemo nguno enengo oowooyi bingami ero ma okootoni, simooye bodagado teteku, ngundiro tewaku ngu, asa, hamoo oorengo, ngu oningga ngu, Anutro endega enengo oni simoo bare soboyerooteku, nguno ene oni gidarega oowooye ngu dagayeroro, urungga tewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Oni ene no oowoonemboro ingondudu tero, ene oni simooye bodaga ngandiro yoro, hooroowewaku ngu, asa, ene no nguya ngundiro hoorooweneroote. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Yisasdo mande gura eyingo. Oni gurado simooye nga noro nowoondoyemo hamoo ingoro oorootenggoku, nga gura yoro, noro nowoondoye hamoo ingootenggoku, ngu yomburiyoro ngu, enengombo muri biyomi tewoku, nguro gumi ogingo urungga oorengo yowa. Yo, ngu oningga ngu enengombo biyomi ngundiro tewoku, ngu ngandiro: oni ngu digi urungga ngu yoro, ngundo bungeyimo gosiyoro yoro, sono koongeyingo urungga ngu kewooroko oorongooyingo. Oorongootoyi, oni sono newendemo uro kumooyingo, ngu ngandiro. Yo, ene oni buniyo newende hamoo teyingo ngu yomburiyowoku, nguro gumi urungga oorengo yowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Mera bidodomo, oo oowooyingga oni nowoondoye hamoo teyingo ngu woosootoyi yokootenggo. Naru oowooyingga, oo ngundiro biyomi ngu tunooteroruwa. Ene oni oni yooge, onindo oni gidarega yowoosootoyi, mbumbuwa tetenggoku, nguro ngu oningga ngu, ngu uriyi biyomi urungga yowa. Yo, no ngundiro oni biyomi nguro nowoondoyi teteno! ");
INSERT INTO rwo_rawa_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Nguro ngu, ye keyembo ngundi kandeyebo yoyeni, weti mbumbuwa gura teya ngu, asa, ye mete ngu toongooya, andangeya, oorongooyiga uni. Ngundiro nangge, kandeye guranangge, ngundi, keye guranangge oodoni ngu, ngundo mete keta oruweroyi gome ngu yowa. Kinitetoni ngu, ye kandeye eraya eraya, ngundi, keye eraya eraya oodoni ngu, ngundo yoyoro, ende biyomi de nombo ma kumooweroyi (Hel) nguno oorongooyerowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ngundiro nangge, doongeyembo yoyeni, weti mbumbuwa gura tetoyiga ngu, ye mete ngu doongeyengga ngu yokoya, oorongooyiga uni. Ye doongeye guranangge, ngu ye mete Anutya keta sugi sugi oruweroyi, ngu yowanggo. Kinitetoni ngu, ye doongeye eraya eraya oodoni ngu, ngundo ye yoyoro, ende biyomi de nombo sugi sugi ma kumooweroyi, nguno oorongooyerootoyi uwanggo. Yisasdo mande ngundiro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Yisas mande gura eyingo. Ye ingondare teyi! Ye simooye bobodi nono nowoondoyemo gome ingootenggoku, ngu ma kootu yunowero. Kini, no yeno hamoo eteno. Sambono Anutro oni, ngundo simooye bobodi gome soboyeroro, Awane sambo endemo oorootenggoku, ngu tanggeyimo ootooro, Anutro omukumundoongo kenororootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ndadiro nguro, no Anutro Nangoni Oni Kirarongo, ngano omburo, oni enengo oore yokoyingo, ngu ko yoyowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ye ndadiro ingonduduga ingootenggo? Oni gurado Sipsip onibi kandegura (100) mooremu, Sipsip gura dobookuringo yoyokoro, enengo oore nenengo yokoyingo. Ngundiro yokowaku ngu, asa, ngu oninggaku Sipsip wata urunggaku purimo oorootenggoku, ngu yoyokoro, ene toongewokunggaku erewero toongewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Yo, no yeno hamoo eteno. Ngu Sipsip sobosobo oningga, ngundo enengo Sipsip toongeyingongga ngu kenoro ngu, asa, ene oni oni urungga tewa. Yo, enengo oni oni tewaku, ngundo Sipsip oowooyingga purimo oruwonggoku, nguro oni oni teyingo, ngu dagate. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Sipsip sobosobo oningga, ngundo enengo Sipsip gura yokootoni, toongewero ma ingooteku, ngundiro nangge, Awangge sambo endemo oorooteku, ngundo nguya, enengo simooye ngu gura yokowero ma ingoote. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yisas mande gura eyingo. Dobooge gurado geya muri biyomi tetoningga ngu, arisa, mete yarisu nangge bibiteya, enengo muri biyomi, ngu yeyiga tunooteni. Ngundiro tetoni, ene gengo mande ingootoni ngu, arisa, ge dobooge ko yowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ene oni muri biyomi tewoku oningga ngu mande ma ingootoningga ngu, arisa, mete ge oni gura, ngundi, oni eraya yoyoya, geya ooroya, ngu oni muri biyomi tewoku ngu yomosiyoyi. Ngu oni gura ngundi oni eraya, ge nguya, ngundo yaringo mande ngu ingoro wirikowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ene oni muri biyomi tewokungga, ngu mande ma ingootoningga ngu, asa, mete Kristen oni yowuruno onino oorowutoyi yowuruwooro, mande tero yomosiyowanggo. Nguno oni muri biyomi tewokungga ngu, ene enengo mande ma ingoro keyootoni ngu, arisa, ngu oningga ngu, ye nowoondoye hamoo teyingo gidaresina ene ma yowuruwooro oruwanggo. Ngu mbumbuwa oningga ngu, Anut hamoo kootu inooteku oni ngundiro, ngundi Takis digi beye yoweroyi oni ngu ngundiro. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","No yeno hamoo eteno. Ye oo bidodo merako ngano gosiyowanggoku ngu, Anut sambo endemo oorooteku, ngundo nguya gosiyowa. Ngundiro nangge, ye oo bidodo merako ngano yokowanggoku ngu, Anutdo nguya sambo endemo nguya yokowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","20","Yo, no yeno ko eteno. Oni eraya merako ngano oo yowero nowoondoyari guranangge yero, yemboongewariku ngu, arisa, Awane sambo endemo oorooteku, ngundo yunowa. Ngundiro nangge, oni eraya ngundi kabusa musiyo gurano no oowoonemo yowuruwoowanggoku ngu, arisa, no ene kewooroyemo oruwano. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ngu naruno, Pita Yisasno tunootero eyingo. Oo Simburi Urungga, naru ndadiro, doboonembo nono muri biyomi tetoni, nondo enengo muri biyomi ngu andangewano? Tambu kandegura gidemboro eraya, bine? Ene ngundiro sumoo eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Sumoo etoni, Yisasdo eneno mande gumi ngandiro eyingo. No geno tambu kandegura gidemboro eraya nanggega, nguro ma eyingo. Kini, naru bidodomo, ye komo oni gidaregado yeno weti mbumbuwa tetenggoku, ngu andangeyunoyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Anut Oo Bidodo Simburi Simbunani, ngundo enengo endega oni simoo bare soboyerooteku, ngu ngandiro. Ngu merako sobosobo oni koreteyingo enengo ko oniya wetiye ngu andangero yomosiyowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Oni urungga, ngundo damoni yero, enengo wetiye andangewero, etoni, ngu ko oni gura yoro, eneno ombuyingo. Ko oningga enengo wetini ngu digi beye kande eraya Miliyon (10,000,000 Kina) ngundiro weti yowo. Ngundiro nguro, oni urunggado ko oningga nguya etoni, weti ko wendangero inowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ene enengo weti urungga oorengo, oni urungga nguno, ene mete ma andangewa. Ene ereremo kini. Nguro ngu, ngu oni sobosobo urungga, ngundo enengo bareyi simoongo enedodo soweyerootoni, ya biyomimo oodegogo, enengo weti ngu mete bidodo andangewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Oni urunggado ngundiro etoni ngu, asa, ko oni wetidodoga enengo mande ingoro, nguro ene sosorero, oni urungga ngu keyi damonimo boodoo oondoogero, bagootero, ngguyinggayi tero, sumoo sumoo tero eyingo. Oo oni urungga, ge noro nowoondoyi teya, sobonerootooga, nondo ngu weti bidodo yokowano! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ngundiro etoni ngu, Oo Simburi urungga nguro nowoondoyi tero, oninggaku yokoro, enengo weti nguya yokoyinoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Yo, enengo oni urunggado enengo weti bidodo andangetoni, ene ngu ko oninggaku enderoko oorero, enengo ko goboorogaku kenoyingomu ngu, eneno weti digi beye kande eraya (10 Kina) ngu moore. Ngundo ngu, ko oninggakundo sanggiri tero, sodedomangge dobooyi bungeyi yanggango dowooro, manggaru tero eyingo. Ge weti bidodo ataga wendangeya nuno! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ngundiro etoni ngu, oninggaku boodoo oondoogero, ngguyinggayi tero, sumoo sumoo eyingo. Ge noro ingoya, sobonerootooga, naru bodagano, gengo weti bidodo ngu andangegunowano. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ngundiro etoni, ene ngu oningga nguro mandeni ma ingoyingo. Nguro ngu, oni urungga ngundo etoni, kumba ootuwoo onindo ene dowooro, ya biyomimo yetoyi, nguno ootooro, ngunonggo oo ngu wendangeni, ero yeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Arisa, ko oni goboorokundo enengo muri biyomi kenoro, nowoondoye kowuri hamoo ingoro, nguro ene enengo sobosobogakuno oororo, mande mande bidodo oningga ngundo tewoku, ngu emukowonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","33","Sobosobogakundo mande ngu ingoro, ene nguro sanggiri urungga tero, ko oninggaku nengongootoni, ombutoni eyingo. Ge ko oni biyomi oorengo! Koretero oorengo, ge nono sendoro, ngguyinggayi tetoyi, nguro nondo kingo gengo weti urungga oorengo ngu andangegunowono. Nondo gengo nowoondoyi tenggunootoowe, ndawugaro gedo gengo ko gobooroga, nguro ma nowoondoyi teyinowo? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Sobosobo oninggaku sanggiri urungga tero, ko oninggaku dowooro, kumbadogoni oni kandeyemo yetoni, ngundo dowooro, ya biyomimo yeyingo. Yetoyi, nguno ootooro, ngunonggo weti bidodo andangeni ero yeyingo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yisasdo mande yanggango gura eneno eyingo. Arisa, ye nga mande adingayingga ko oningga ogingo yoro, kowuri yowoku, nga ye gome ingoyi. Ngundiro nangge, ye nowoondoyemonggo dobookuriyeboro kowuriye yeno tewonggoku, nguro ye ma andangero, kabetewanggoku ngu, asa, Awane sambo endemo oorooteku, ngundo nguya, yengo weti mbumbuwa ngu ma andangero kabetewa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ngu naruno, Yisas mande kinitetoni ngu, ene Galili mera yokoro, ene Yudiya mera Yodan sono anduroko nguno urooreyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Urooretoyi, oni simoo bare oowooyingga oorengo nguya, ene keyoro oorowutoyi, ngu mera gumisina nguno, Yisasdo sayi oni yomosiyerootoni, ene mete temukowonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ngu naruno nguno, Parisi onindo ene towoongowero omburo, sumoo ewonggo. Noorengo mamana mandeno, ngu mete oni enengo ingonduduno bareyi andangewa, bine? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ngundiro sumoo etoyi, asa, Yisasdo enengo mande ingoro, gumi eyingo. Ye kuri nga mandega nga kandangero ingootenggo. Anutro mandeno ngandiro eyingo. Kuri amana oorengo, Anutdo oo bidodo tewokuno nguno, ene simoo ko bare nguya teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ngundiro nguro, simoo ewenemi yokoro, naru bidodo bareyiboya ebe dowoodowoo tero, goweyari guranangge oruwari. Anutro mandeno ngundiro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Yisasdo mande gura soweyoro eyingo. Ngundiro nguro, erambarisa ngu, ene goweyari eraya kini. Ene goweyari guranangge. Nguro Anutdo oo gosiyoro, yokowoku ngu, onindo ma toongoowero. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Parisi onikundo mande ingoro, gumi sumoo eyingo. Ndawugaro nguro, Mosesro mamana mandeno simoondo bareyi yokowero ngu, ene komo so uyi nakangoro, bareyi inoro, owetoni toongewa? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ngundiro sumoo etoyi, Yisasdo mande gumi eyingo. Mosesndo yengo nowoondoye yanggango oorengo erambarisa toongooweroyi muri ngu kenoro, nguro ngu muri damoninggano, ngunonggo yoyookootoni, erambarisa muri ngu toongootenggo. Ene Anutdo amana simoo bare yoyeyingomo, ngu naruno, ene erambarisa toongooweroyi muringga ngu, ene ma yeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","No yeno hamoo eteno. Ene oni gurado enengo bareyi sebobarese muringga ma teyingomu ngu yokoro, ene bare gura yowaku ngu, ngu oningga ngu, ene erambarisa muringga ngu yomburiyoote. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Enengo kirikiri onindo enengo mande wirikoro ingoro, gumi eyingo. Ngu erambarisa muri ngu oo urungga oorengo. Ene sosoreyingo bodaga tero, ingoro, nguro ene mande gura eyingo. Arisa, noore bare ma yowato. Ngu muri mete, bine? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ngundiro sumoo etoyi, asa, Yisasdo mande gumi eyingo. Erambarisa teweroyi muringga nondo etuyerootenoku ngu, ngu oni bidodoboro kini. Kini, ngu erambarisa teweroyi muringga ngu, Anutdo oni rogo teyingomu, nguromu nangge. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ndawugaro nguro, oni gura gura mete bare ma yowanggo. Bare ene simoo bisiyoro ngu, ene kenoro ingoro, oode, bare ma yowero ingowa. Oni gidarega ene bare ma yoweroyi, ndawugaro nguro, oni gurado ene moondeye yootoongooyingo nguro. Oni gidarega enesu nangge erambarisa teweroyi ngu gosiyoro, ndawugaro, ene Anutro ko tero, oni simoo bare yowoosooro, Anutro mandeni muriningga enengo oni simoo bare soboyerooteku, ngu yoyeweroyimboro. Oni gura ene mete nga mandega ingowero ngu, ene komo gome ingoni. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ngu naruno, oni simoo baredo simooye bobodi gidarega yoyoro, Yisasdo kandeyi tabayemo yeya, yemboongeni, ero, yoyoro mayeyingo. Mayetoyi, ene nguro kirikiri onindo ngu oni simoo bareku manggaruyeroro, oweyeroyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ngundiro tetoyi ngu, asa, Yisasdo eyingo. Ye simooye bobodi yoyokootoyiga, nono ombuyi. Ye ngu ma oweyerowero. Kini, ye Anut Oo Bidodo Simburi Simbunani, ngundo enengo oni simoo bare soboyerooteku, ngu komo simooye ngundiromu, ngundo yowanggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ene ngundiro ero, kandeyi simooye tabayemo yero, kumana yunoro, ene yoyokoro toongeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ngu naruno nguno, oni gurado Yisasno omburo, sumoo eyingo. Oo etuyeroyingo oni, no ndadiro muri gomengga terogogo, no suwooyi sano keta oruweroyi ngu yowano? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ene ngundiro etoni, asa, Yisasdo mande gumi eyingo. Ndawugaro nguro, ge nono oo gome nguro sumoo ete? Anut enengombo nangge oni gome. Ge keta sugi sugi oruweroyi ngu yowero ngu, asa, ge komo Anutro mamana mande ngu bidodo keyo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","19","Yisasdo etoni, ngu simoo oorenggakundo sumoo eyingo. Ndadiro mamana mandega? Ene ngundiro etoni, Yisasdo mande gumi eyingo. Mamana mande ngu ngandiro: ge komo oni ma ureyi kumoowero; ge komo bare gidarega yakakayi yodowooro, oweyeroro, ma yomburiyerowero; ge komo yakaka ma tewero; ge oni gurano mande godange ma ewero; ge komo awanangge tanggeyemo gome ootooya, manggoye keyoya, gome oodoya; ge oni gidarega tanggegemo oorootenggoku, ngu hoorooweyeroya, gome soboyeroya, gengo gowege sobowooteku ngundiro. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Simoo oorenggakundo enengo mande ngu ingoro, gumi eyingo. No kuri bodagano, ko, ataga nguya, no ngu mamana mande ngu bidodo keyoro, omburo oorooteno. Arisa, no ataga ndadiro oo gome gura tewano? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yisasdo enengo mande ngu ingoro, gumi eyingo. Ge oni nenengo oorengo tunootewero ngu, asa, ge komo oo guranangge ngu te. Ge komo ooroya, gengo oo bidodo soweyoya, ngunonggo digi beye yoya ngu, angoyi oni ngu bayeteya yuno. Ge ngundiro tewaku ngu, asa, gengo digi beye oo gome gome sambo endemo ooroote. Ge ngundiya teya, ombuya, no keneroya endeyo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Simoo oorenggaku ngu mandeningga ngu ingoro, omukumundoongo bisiwero newende nguya kowuri urungga ingoyingo. Ndawugaro nguro, ene oo sitowini urungga ngu yokoro, oni songo yunoweroyi nguya kini. Ngundiro tero, ene ootoogero toongeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ngundiro tetoni ngu, Yisasdo enengo kirikiri onino yowoorengoro, eyingo. No yeno hamoo eteno. Oni ene sitowidodo ngu, ene Anut Oo Bidodo Simburi Simbunani, ngundo endega enengo oni simoo bare soboyerooteku, ngu newendesina uweroyi ngu, ngu kowuri oorengo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","No mande gura ko eteno. Bo urungga nga, ngu nggusi newendekuri uweroyi ngu kowuri. Ene beye sitowidodo oni ngu Anut Oo Bidodo Simburi Simbunani, ngundo endega enengo oni simoo bare soboyerooteku, nguno uweroyi nguya, ngundiro kowuri urungga oorengo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Yisas enengo kirikiri onikundo ngu ingoro, ene sori urungga tero, enengo nangge mande ero, ingoro, sumoo eyingo. Ngundiro ngu, onendo ngu mete ene suwooyi sano keta oruweroyi ngu yowa? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Enengo kirikiri onindo ngundiro sumoo etoyi, asa, Yisasdo ene gome gome yeyoro eyingo. Anutdo oni ma hoorooweyerootoni ngu, asa, oni enesu nangge oo yanggango ngu hamoo ma tewa. Ene Anutdo oni ootooro, nguro, ngunonggo ene oo yanggangomu ngu bidodo hamoo oorengo temukowa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ngundiro etoni, Pitando mande gura Yisasno ero eyingo. Ingoyi, noore oo bidodo yokoro, ge kenggeroro endeyorooteto. Nguro ngu, noore ndawu ooga yowato? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ene ngundiro sumoo etoni, asa, Yisasdo mande gumi eyingo. No hamoo oorengo, yeno eteno. Kootuyisina, oo bidodo keta tunooteweroyimo ngu naruno, no Anutro Nangoni Oni Kirarongo yaba bingaminidodo sambo endemo nguno, no Anutro yanggangoni duridarinimo bibitewano. Arisa, ngu naruno, ye nguya yaba bingamidodo kande eraya kegidemboro erayaga (12) nguno bibitewanggo. Bibitero, ngunonggo Iserel oni wata kande eraya kegidemboro eraya (12) ngu wirikoyerowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Yo, oni bidodo ene noro ingoro, Anutro mande metemi ngano ingoro wesiyoro, ene enengo ya, konebeyi, kuwooyi, ewenemi, simoongo, enengo oowari koyi yokoro ngu, oo bidodo ye kuri yokowonggoku ngu, nondo ngu dagaro, urungga oorengo ko yunowano. Yo, ngu oo ngu urungga oorengo onibi kandegura (100) ngu yowanggo. Ngandiro nguya, ene keta sugi sugi oruweroyi, ngu yowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ene oni gurado merako ngano ngu oowooyi bingamidodo tero ngu, sambo endemo ene oowooyi kini. Ngundiro nangge, oni gura merako ngano ngu oowooyi kini oorooteku ngu, ene sambo endemo, ngu oowooyidodo urungga tewa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Anut Oo Bidodo Simburi Simbunani, nguro mandeni muriningga ngundo enengo oni simoo bare soboyerooteku, ngu oni gurado enengo mera urungga ngu ngundiro. Ene suwoononggo oorengo ko oni yoyoro, Wayin kono ko teyi, ero oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ene ngundiro tero, Wayin ko nguro simburi enengo ko oni mande yunoro, no digi beye Kina guranangge ataga ko tetenggoku, nguro nangge yunowano. Enengo ko oni mande ingoro, nguro ngu nangge keyoro, enengo Wayin kono oorowuwonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Asa, suwoononggo naru kandegura gidemboro namoraya (9) nguno, ende oo uri yoweroyi musiyomo oororo, oni kingo dikarootoyi yeyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Yeyoro, ene mande eneno ngandiro eyingo. Ye nguya noro Wayin kono uro, ko tetoyi, ngundiro rogono, no digi beye yunowano. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ngundiro etoni, ingoro, kono satoyi, asa, samboro naruno (12), ko naru suwootetoni (3), nguno, ene oni gidarega yeyoro, ene nguya ngundiro teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ene suwootetoni, namoko ko yokoweroyi naruno, (5 Klok) ko simburigaku ko oororo, oni gidega yeyoro, sumoo eyingo. Ye ndawugaro ogisano, ngano kingo oorootenggo? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ngundiro etoni, enendo mande gumi eyingo. Noore ko yunoweroyi oni kini. Ero eyingo. Arisa, ko simburigakundo ingoro, mande gumi eyingo. Asa, ye nguya, noro Wayin kono uya, ko teyi. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Wayin ko sobosobogakundo ngundiro ero, asa, suwootetoni ko kiniteteku naruno ngu, enengo kono oororo, ko sobosobogakuno eyingo. Ye ooroya, ko oni negoyerootooga ombutoyiga ngu, ngu beye yuno. Ge ko oni suwootetoni ko tewonggoku, ngu digi beye yunoya, wenga suwoononggo ko tewonggoku oni, ngu digi beye yuno. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ene ngundiro etoni, asa, ko oni suwootetoni namoko ko yokoweroyi ene ko ootoogewonggoku naruno, (5 Klok), eneno ombutoyi, ko oni sobosobogakundo sa guranangge ko tewonggoku, nguro digi beye Kina guranangge nangge yunoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Arisa, ko oni suwoononggo ko tewonggoku, ngundo ko oni suwootetoni ko tewonggoku, nguro Kina guranangge kenoro, ngandiro ingoyingo. Noorengo digi beyega ngundo enengomu ngu dagawa, ero ingoyingo. Ene ngundiro nguya kini. Kini, ko oni sobosobo ko oni bidodo ko tewonggoku, ngundo digi beye Kina guranangge nangge yunoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","12","Ngundiro nguro, suwoononggo ko tewonggoku oninggakundo Kina guranangge ene bidodo yoro, kenoro, nguro ene ko simburigakuya sanggiri tero, eneya ronggeyoro eyingo. Ndawugaro nguro, nga oni nga kootu oororo, naru bodaga nangge ko tewonggoku, nguro uri noorengo bidodo guranangge yunoote? Noore ogisa urunggano ko urungga tero, nosiri yudoni, naru bidodo ko tewooto. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ngundiro etoyi, ko simburigakundo mande gumi eyingo. Oo dobookurine, no yeno hamoo ewono. No suwoononggo mande yunoro ewono, sa gurananggemboro ko tetenggoku, nguro uri Kina guranangge yowanggo, ewono. Nguno ngu, ye ngu mandega ngu ingoro, mete, ero ewonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Arisa, ye uri yoya sayi. Oni suwootetoni ko tetenggoku, nguro uri ko yengo uri guranangge. No ngundiro tewero gome ingoro teteno. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ngu nenengo digi beyebo oni suwootetoni ko tetenggoku, ngu nowoondoyi yunoro, ngundiro yunooteno. Ye, bine, nondo ngundiro oni ngu nowoondone yunootoowe, nguro sanggiri tetenggo? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yisasdo mande gura eyingo. Yo, ko oni bidodo uriyi guranangge yowonggoku, ngundiro nangge, simoo bare ururu ko buniyo bobodi nguya, nowoondoyemo hamoo teyingongga ngu guranangge. Nguro ngu, ene bidodo Anutro sambo endemo nguno uwanggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ngu naruno nguno, Yisasdo enengo kirikiri oni nangge oorekanare Yerusalemno yade yade oorowutoyi, Yisasdo enengo kirikiri oni kande eraya kegidemboro erayagakuno, enengo mande yunoro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","19","Ingoyi! Ataga noore Yerusalemno ooretooye ngu, no Anutro Nangoni Oni Kirarongo, ngu Anutro wooro yeyingo oni kundingiyi nguro sobosobo oniku, ko, mamana mande etuyeroyingo oni nguya, ngu mundi oni kandeyemo noyewanggo. Ngu oni ngundo mande guranangge nureyi kumooweroyimboro ero gosiyoro ngu, ene Gabuman oni kandeyemo noyewanggo. Ngundo ngu, kootunesina mande yomoonunoro, gisaruneroro nutoro, de omukondino nureyi kumoowano. Naru kabusa yokoro, ko keta ootoogero oruwano, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ngu naruno nguno, Sebedi simoongo erayagaku Yemus, Yon, namoyarimbo yoyoro, Yisas tanggeyimo omburo, boodoo oondoogetoni, namoyarimbo sumoo eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ene Yisasdo koretero namoyari sumoo inoro eyingo. Ge ndawu oo garo ingoote? Etoni, namoyarimbo mande gumi eyingo. Kootuyisina, sambo endemo, ge nguno yaba gengo duridarinidodo yabagemo bibitetoyi ngu, mete ge nenengo simoone erayaga, ngundo kandege koondosina, gurado kandege biyomisina ngundiro bibitewari. Ngu mete, bine? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ene ngundiro sumoo etoni, asa, Yisasdo mande gumi eyingo. Ye ngu ooga nono sumoo etenggoku ngu, ye muri ma ingootenggo. Yari, bine, mete nondo kowuri ogingo koorowoowanoku, ngu yari nguya bine, mete koorowoowari? Ngundiro sumoo etoni, erayagakundo enengo mande ingoro, gumi eyingo. Yo, noore mete, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Etori ngu, asa, Yisasdo eneya eyingo. Hamoo oorengo, ngu sono tobaga (kowuri koorowooteno) no netenokungga, ngu yari nguya newari. Ene onendo kandene koondosina, kandene biyomisina bibiteweroyi ngu, nondo mete ma ewano. Kini, Awane enengombo nangge, ene kuri oni yunoweroyimboro yomosiyoyingo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Kirikiri oni kande erayagaku ngu mande ngu ingoro, ene Yemus Yon erabasa nguya sanggiri biyomi tewonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ene Yisasdo enengo kowuri ingoro, negoyerootoni, eneno ombutoyi, ero eyingo. Oni sowe gidarega Yuda oni kini nguro sobosobo oni ururu, ngundo oni simoo baredo ene oni urungga, ero ingootoyi, nguno ngu, ene yanggango oorengo soboyerootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","28","Ene ngu muringga tabango onindo keyootenggokungga, ngu ye simoo bare nowoondoyemo hamoo teyingo nguya ngundiro ma keyowero. Kini, ene ye kewooroyemo urungga oowooyidodo oruwero tewanggoku ngu, asa, ene yengo kirikiri oni tewanggo. Ngundiro nangge, oni gura ye kewooroyemo tabango urungga oruwero tewaku ngu, ene yengo kingo kirikiri oni oruwa. Ngundiro nangge, no Anutro Nangoni Oni Kirarongo nguya onindo ko teya, hoorooweneroyi ero, ma ombuyingo. Kini, no onino ko tero, hoorooweyeroweroyimboro ombuyingo. Nenengo keta oruweroyi, ngu nondo oni simoo bare bidodo weti mbumbuwanonggo, ko uriyeroweroyimboro ombuyingo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Asa, ngu naruno nguno, Yisasdo enengo kirikiri onindo Yeriko ende ngu yokoro, yade yade oorowutoyi, oni simoo bare ene keyeroro oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Oorowutoyi, oni doongeyari kiringo erayagaku, oore dabemimo bibitero oodori, Yisas oorekana oorowutoni, ingoro, meno yanggango eyingo. Oo Simburi Urungga, ge Dewitro sembeni, ge noorengo nowoondoyi teyuno! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nguno oni simoo baredo sanggiri tero, yeyoro eyingo. Yari manggoyari gosiyori! Ero eyingo. Ene erayagaku meno yanggango urungga oorengo eyingo. Oo Simburi Urungga, ge Dewitro sembeni, ge noorengo nowoondoyi teyuno! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ene ngundiro meno yanggango etori, asa, Yisasdo oni erayagakuro meno ingoro, negoyerootoni, ombutori ngu, sumoo yunoro eyingo. Nondo ndawu ooga teyunowano? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Erayagakundo enengo mande ngu ingoro, nguro ene gumi eyingo. Oo Simburi Urungga, noore doongetewero ingootero, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yisasdo enengo mandeyari ingoro, nguro ene nowoondoyi teyunoro, kandeyi doongeyarimo yewo. Ngundiro tetoni ngu, sodedomangge, ene doongetero, Yisas kenoro, keyoro sayingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yisas enengo kirikiri onikudodo Yerusalem namoko oororo, Betipas ngu ende bodaga Olib puri ngu tanggeyimo, ene nguno tunooteyingo. Ngu naruno nguno, Yisasdo enengo kirikiri oni eraya ende bodagano soweyerowero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Yari endega namokono kenooteriku anduno oorowuri. Yari oororo, Hos gura oowooyi Donggi gura nangonidodo de bungomo gosiyootoyi oorooteriku, ngu kenoya, wesiyoya, kimbonanonggo dowooya, yoya, nono omburi. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ende oni ngundo yari sumoo yunootoningga ngu, arisa, yari ngandiya eri. Oo Simburi Urungga, ngundo nga Donggiga nga ko inowero etoni, ngundiya eya eri. Ngundiro etoni ingoro ngu, asa, yari sodedomangge soweyerootoni, ko ombuwari, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Yisasdo mande gura nguya eyingo. Kuri, Anutro ingondudu eyingo oni gurado mandega eyingo, ngu ataga engge tunootete. Kuri ene ngandiro nakangoro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Ye Yudaro oni simoo bare Sayiyon Yerusalem endemo oorootenggoku, nguno ye ngandiya eyi. Nga kenoyi, gengo sobosobo oni koreteyingongga nga ataga ombute. Enendo Donggi nangoni sanganimo bibitero ombutoni, Donggi nangoni ngu newende imakeyingo nangge oorooteku, nguro ene ememangge yoro ombute. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Arisa, kirikiri oni erayagaku oororo, Yisasdo ewoku, ngundiro teworiyo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ene Donggi nangoni nguya kimbonadodo yoyoro, Yisasno omburo, enengo dogigiro nengguro ngu andangero, Donggi nangoni sanganimo yomiyingo. Ene ngundiro yomitori, arisa, Yisas oorero, ngu sanganimo bibiteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Enengo kirikiri oni ngundiro tetoyi, oni simoo bare oowooyingga oorengo nguya, enengo dogigiro nengguro oorekanare yomiro yomiro oorowuyingo. Gidaregado de uyi urungga nguya toongooro, oorekanare yomiyingo. Ngundiro tero, Yisas oowooyi bingaminidodo okooro, mera ngano sobosobo koreteyingo ngundiro teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ene ngundiro tetoyi, simoo bare koretetoyi, gidarega kootu tero, oororo, ene moguruwooro eyingo. Hosana, gengo oowoongge awuno oorengo! Ge Dewitro sembeni! Anutdo ene mete kumana nga oningga nga inoyingo. Ene Oo Simburi Urungga, oowooyimo ombuteku ngu! Hosana, gengo oowoongge awuno oorengo! Ero meno eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Asa, Yisas yade yade Yerusalem utoni ngu, endemo simoo bare oowooyingga ngu kenoro soriyokoro, sumoo eyingo. Nga oningga nga ndawu oningga? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Simoo bare eneya oorowuwonggoku, ngundo enengo mande ingoro, gumi eyingo. Nga oningga nga ngu Yisas, Nasaret oni, Galili merakononggo omburo, ene Anutro ingondudu eyingo oni gura. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Asa, Yisas oororo, Yuda yowuru ya oowooyi Tembel newendemo uro, damoni yero, oni Tembel yano digi beye oo koyi tewootoyi oweyeroyingo. Ngu konggaku yowuru yano ngundiro tero, oni digi beye guraromu guraromu yowoorengoro, bayetetoyi, nguro Yisas sanggiri teyingo. Sanggiri tero, ene, yabagakudodo wenggeremootoni, ukero uyingo. Oni nu mumukondiri ngu uriyoro, koyi nguya tetoyi, nguro yabani wenggeremootoni, ukero, utoni oweyeroyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Awanemboro mande nakayano, ngandiro ete. Noro yane ngu oni simoo bare bidodobo yemboongeyingo ya, ero ewanggo. Ngundiro nangge, ene yendo ngu yeyi, yakaka oniro kombiteyingo musiyo tete. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ngu naruno nguno, Tembel yano, oni doongeye kiringo ko kekandeye biyomi ngu nguya Yisasno mayetoyi, ene bidodo yomosiyeroyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","16","Ngundiro nguro, Anutro wooro yeyingo oni kundingiyi sobosobo oniku, ko, mamana mande etuyeroyingo oni, Yisasro oo muri songo oorengo gura onindo ma teweroyimu tewoku, ngu kenoro, simooye bobodi Tembel newendemonggo ngandiro meno etoyi ingowonggo. Hosana, gengo oowoongge awuno oorengo! Yisas ge Dewitro sembeni! Ero etoyi, ngu ingoro, nguro ene nowoondoye biyomi urungga ingoyingo. Nguro ene Yisasno eyingo. Ge bine, ngu mandega simooyembo etenggoku, ngu ingoote? Ngundiro etoyi, Yisasdo mande gumi eyingo. Yo, no ingooteno. Anutro mande ye kuri kandangero ingootenggo. Ene Anutno ngandiro eyingo. Ge simooye bobodi ko simooye nonono nguya manggoye tango yetoni, nguro ene gengo oowoongge bingamingge etenggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ngundiro ero yokoro ngu, asa, ene endesina oorero, ende yokoro, Betani endemo oororo, suwoono nguno oriyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Sengetoni, Yisas enengo kirikiri onikudodo endemo ko oorowuwero yade oororo, oorekono Yisasdo oodoro kumooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Oodoro kumooro, nguro ene de gura oowooyi Pik, ngundo kukunga ningguri ngundiro ngu oriroko kenoyingo. Uyi oowooyingga tutu ureyingo. Ene namokono oororo, enggeboro doongetewero damonimo oororo, engge gura ma kenoyingo. Kini, uyi nangge oriyingo. Ngundiro kenoro, nguro ene Pik degakuya eyingo. Kootuyisina, ge ko ma enggewa. Ero eyingo. Ngundiro etoni, sodedomangge Pik degaku ariyero kumooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ngundiro tetoni ngu, asa, enengo kirikiri onikundo kenoro, soriyokoro eyingo. Ndadiro nguro, Pik dega sodedomangge ariyero kumoote? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yisasdo enengo mande ingoro, gumi eyingo. No yeno hamoo eteno. Ye nowoondoye hamoo tero, nowoondoye eraya kini ngu, asa, ye nguya, nondo Pik degano tetenoku, ye nguya mete ngandiro tewanggo. Yo, ye nowoondoyemo hamoo ngu yanggango oorootenggoku ngu, asa, ngu nguya, ye mete nga puringga ngaya ewanggo. Ge ootoogeya, ukeya, wendeyimo u. Ewanggoku ngu, asa, ene ngundiro tewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ngundiro nangge, ye nowoondoye hamoo tero, nguno ye oo guraro ero kira ewanggoku ngu, arisa, Anutdo ngu ooga ngu yunootoni yowanggo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ngu naruno nguno, Yisas ene Yuda oniro yowuru ya urungga oowooyi Tembel, ngu newendemo uro, oni simoo bare oo etuyeroweroyimboro. Ngundiro tetoni, Anutno wooro yeyingo oni kundingiyi sobosobo oniku, ko, Yudaro oni simoo bare tabango oniku nguya omburo, eneno sumoo eyingo. Onendo ngu mande muri yanggangongga ngu, ge gunowo? Onendo ge rogogerootoni, nga kongga nga tete? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yisasdo enengo mande ingoro, gumi eyingo. No nguya, ye oo guraro sumoo yunowero. Ye ngu gumi etoyi ngu, asa, nondo kongga tetenoku, nguro yanggangoni nguya ewano. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","26","Ndawu oninggado Sonoyeroyingo Yon sureyootoni ombuyingo? Anutdo sono kundingiyimbo oni sonoyeroni ero, nguro Yon sureyootoni ombuwo; ngundi, oni simoo baredo bine sureyootoyi sonoyerowo? Arisa, ye noro mandega gumi eyi. Ero eyingo. Etoni, arisa, enengo nangge ero, ingoro, eyingo. Noore ngandiro ewato. Anutdo Sonoyeroyingo Yon sureyoyingo, ewatoku ngu, asa, enebana sumoo yunowa. Ye ndatero nguro nowoondoyemo hamoo ma ingootenggo? Ngundiro nangge, noorendo onindo Yon sureyoyingo ewatoku ngu, arisa, oni simoo baredo nooreya sanggiri urungga tewanggo, nguro noore sosoreteto. Ndadiro nguro, oni simoo bare ene kuri ingootenggo. Yon ngu Anutro ingondudu eyingo oni oorengo, ero ingoyingo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ngundiro nguro, ene Yisasno mande gumi ngandiro eyingo. Noore watayi kini. Ero eyingo. Ene ngundiro etoyi, asa, Yisas enebana eyingo. No nguya yengo sumoo nono ewonggoku ngu, no yanggangonengga ndanonggo yoro, nga kongga tetenoku, ngu nguya yeno ma ewano. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yisasdo mande adingayi gura eyingo. Ye ndadiro ingootenggo? Oni gura simoongo eraya nguno oororo, nangoni koreterogakuno eyingo. Ataga mete ge ooroya, noro Wayin kono uya, ko te. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ngundiro etoni, nangoni koreterogakundo gumi eyingo. Kini, no ma! Eyingo. Ngundiro ero oode, ene kootuyisina ingonduduni yowoorengoro, kono toongero ko teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Asa, awayaringgaku uro, nangoni kootunggakuno nguya ngundiro etoni, ene gumi eyingo. Yo, ero oode, ene kono ma uyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Arisa, ndawu simoongongga, ngundo eweyi manggowo ngu keyowo? Eyingo. Ngundiro etoni, ene mande gumi eyingo. Nangoni koreterogakundo, etoyi, Yisasdo enengo mande ingoro eyingo. Yo, no yeno hamoo oorengo eteno. Gabuman digi beye yoweroyi oni, ko, ooreko ooreko bare nguya, ene koretero ye dagayeroro, Anut enengombo oni simoo bare soboyerooteku endega, nguno uro oruwanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ndadiro nguro, Yon koretero omburo, ngundo oore nenengo ngu keyoyi, ero etuyerootoni, ene ye nowoondoye ma yowoorengootenggo. Ene Gabuman digi beye yoweroyi Takis oni, ko, ooreko ooreko bare nguya, ene Anutro Mande Keta Mesarango ngu ingoro, nguro ene nowoondoye yowoorengoro, hamoo teyingo. Ene ye ngu yeyoro, nguro nowoondoye ma yowoorengoro, nowoondoyemo hamoo ma tetenggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yisasdo mande adingayi gura eyingo. Asa, ye mande gura ingoyi. Oni gura Wayin kongga tero, oonggoyi pawangoro, Wayin nguno miwo. Ene Wayin engge yoro, wongooro, winggooweroyi musiyo nguya teyingo. Ene ko ngu sobowooweroyimboro ya pirungga sambono yero, ngunonggo ene mete Wayin kono oo bidodo gome kenoro, sobowooro oruwo. Oni ko simburiga, ngundo oni gidaregado ngu kongga ngu sobowooya, Wayin nguro engge gumi ko uriyi, enengo yoyi, ero rogoyeroro yokoro, asa, ene mera gura oriroko nguno toongeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Arisa, Wayin enengo enggeyingo naru, ngu tunooteyingo. Tunootetoni, asa, ene ko simburibo enengo kirikiri oni sureyerootoni, Wayin koyi sobosobo tetenggoku onikuno oorowuyingo. Ndadiro nguro, ko simburiga, ngundo ko nguro oo engge gura yenunoyi, ero, nguro ene oni ngu sureyerootoni oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Oorowutoyi ngu, asa, Wayin kono ko onikundo, oni ko simburigakuro kirikiri oniku yodowooro, guranangge ngu ene gome gome utoro, ko oni gura ene ureyi kumootoni, ko oni gura ene digi oowooyingga yoro, moondeyimo oorongooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ene ngundiro tetoyi, ko simburigakundo enengo kirikiri oni oowooyingga soweyerootoni oorowutoyi, ngu muringga koretero tewonggoku, ngundiro nangge teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ngundiro tetoyi, ko simburibo enengo nangoni guranangge kootu ngu soweyootoni oorowuyingo. Ene ngandiro ingoro, nenengo nangone soweyootoowe, oorowutonigogo, nguro manggowo mandeni keyowanggo. Ero ingoro soweyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ene oni kono ko tetenggokundo, enengo nangge kewooroyemo mande ero, ingoro eyingo. Nga oningga ngando ngu eweyimboro oo bidodo yomukoro, enendo simburi tewa. Arisa, noore ene nguya ureyiga kumooni. Noore ngundiro tero ngu, asa, nga kongga nga ngu, noorengombo sobowooro, koyi tewato. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ngundiro ero, ene oni urungga nangoninggaku ngu dowooro, ureyi kumooyingo. Kumootoni, bingo okooro, kanggaroko oorongooyi uyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ene ngundiro tetoyi, asa, oni ko simburigaku omburo, ko sobosobo oni biyomi nguno ene ndadiro muringga tewa? Sumoo ngundiro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ene mandeni ingoro, gumi eyingo. Ene omburo ngu, ko oni biyomi ngu yutoro, yureni kumoomukowanggo. Ngundiro tero, ene kongga ngu ko oni sobosobo gome gidarega yunowa. Wayin enggeteku naruno, asa, ko sobosobo keta, ngundo Wayin bayetero, gidesinanggo enengombo yoro, gidesina Wayin simburi inootoyi yowa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Asa, ngu naruno nguno, Yisasdo mande gura yunoro eyingo. Anutro mande nakangoyingo ngu, ye kuri kandangero, ngandiro ingootenggo. Nga ya ungoomboro ndonggoromi nonggini gomengga nga ngu, ya yeweroyi onindo yokootenggo. Ene ataga, ngu nonggini ndonggoromi ngu, ene ya kowuri ngu bidodo koorowooweroyi nonggini koreteyingo. Oo Simburi Urungga, enengombo ngu ooga ngu yeni tunooteyingo. Noore ngu kenootooye, ngu mesarango tete. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Arisa, no yeno hamoo eteno. Ye nowoondoye ma yowoorengoro, nowoondoye hamoo ma teyingo, nguro no Anutro mandeni muriningga, ngundo enengo oni simoo bare soboyerooteku, ngu yenonggo andangero, oni sowe gidarega Yuda oni kini ngu yunowano. Eneno nguno ngu, oo gome enggewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Oni gura Krayis Yisas kootu inoro, ngu ene ngandiro. Oni ya ungoomboro nongginingga ngu sanganimonggo sorero ngu, ene biyomi yewa. Ko biyomi ngundiro tetoni, nguro ngu Krayis uri gumi biyomi teyinowa. Ene nonggini koreteyingo ngu Krayis, ngundo ngu oningga ngu sanganimo sorero, utoro, yomburiyootoni, ene sosorango yero kinitewa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Anutno wooro yeyingo oni kundingiyi sobosobo oniku, ko, Parisi onindo Yisasro mande adingayi oowooyingga ingoro, nguro ene ingootenggo. Yisasdo ngu enengomboro mande nooreno sanggawero ewo, ero ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ngundiro nguro, ene sanggiri tero, ureyi kumooweroyimboro oore ereweyingo. Yo, ene dowooro, ureyi kumooweroyimboro tewero, ene oni simoo barero sosorero, nguro ene yokoyingo. Ndadiro nguro, ene ingootenggo. Oni simoo bare ngu, Yisas ene Anutro ingondudu eyingo oni, ero ingootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yisasdo eneno mande adingayi gidarega eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Anut Oo Bidodo Simburi Simbunani, ngundo endega enengo oni simoo bare soboyerooteku ngu, ngu merako oni sobosobo koreteyingo urungga, nguro muri ngandiro. Merako oni urungga, ngundo nangonimbo bare yowero tetoni, nguro simbo urungga kayingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Koretero, ene (Yuda) oni ngu simbo urungga nguno mayeyi, ero, naru rogo teyingo. Arisa, oo neweroyi naruno, enengo kirikiri oni soweyerootoni, oororo, ngu oni rogo teyingoku negoyerootoyiga, ombuyi, ero negoyerootoyi, ene yokoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ngu oniku yokootoyi ngu, asa, enengo kirikiri oni gidarega soweyeroro eyingo. Ye oni rogo teyingoku, nguno ngandiya eyi. Oni urunggado kuri oo simbo urungga karo yewo. Bulmakawu ko, oo nusako moondeyi ndindi teyingo gomemu nguya kuri yutoro, karo, oo bidodo yomosiyoro, yetoni ooroote. Nga narungga nga, nangone bare yoweroyi, nguro ngu, ye nguya ombutoyi, ngu naruno, yowuruwooro, oni oni tero, oo newato, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Arisa, kirikiri onikundo oororo etoyi, ene oniku enengo mandeni ma ingowero, nguro yokoro sayingo. Oni gidarega enengo oowari kono satoyi, oni gidarega enengo digi beye yoweroyi kono nguno sayingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ngundiro satoyi, ene oni gidarega oni urungga enengo ko oni yodowooro, gisaruyeroro yureyi kumooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ngundiro tetoyi ngu, merako oni sobosobo koreteyingo urungga ngundo ingoro, nguro ene sanggiri tero, enengo me oni soweyerootoni, oororo, ngundo enengo ko oni yurewonggoku oniku yutomukoro, enengo ende yande nguya kamukoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ene ngundiro ya kamukootoyi ngu, asa, oni urungga enengo kirikiri onikuya eyingo. Bare yoweroyi oo simbo urunggaku ngu oorooteku nga, ene oni negoyerowonoku, nguro muriye nenengo kini, nguro no ene yoyokootoni, ngano ma ombuwanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Arisa, ye ooroya, ooresanga bidodomo oniro doongeteya, negoyerootoyiga, nga bare yoweroyi simbogano ngano ombuyi. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Nguro ngu, enengo kirikiri oniku ngundiro ingoro, ene oore songo songo oororo, oni simoo bare bidodo yeyoro, yowuruyeroro, oni biyomi ko oni metemimu nguya ombuyi ero sumoo yunoro, sureyerootoyi ombuyingo. Ngundiro tetoyi ngu, bare yoweroyi musiyonggaku oni simoo bare oowooyingga angeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ngu bare yoweroyi naruno, enengo muriye ngu ngandiro. Oni simbo simburiga, ngundo oni kuri rogo tewoku, nguno nengguro keta bayetero yunoyingo. Ngu naruno, merako oni sobosobo koreteyingo urunggado yaroko uro, oni simoo bare oo simbo urunggano mayewonggoku yeyoyingomu ngu, oni gura ngu nengguro yunowoku, ngu ma teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Oni urunggakundo ngu oninggakuya eyingo. Doboone, ge ndawugaro bare yoweroyi nengguroga ngu ma teyingo? Ene sumoo etoni, nguro oninggaku sosorero, mande gumi ma eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ngundiro tetoni ngu, oni oo simburigaku enengo kirikiri oniya ngandiro eyingo. Nga oningga nengguro inowonoku, ene ma teyingo, nguro kekandeyi gosiyoya, yoya, endesina oorongootoyiga uya, ureriko orini. Ngu ureri musiyonggano nguno, ngu oni bidodo sendo urungga tero, metokarikari tero oruwanggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yisasdo mande gumi gura soweyoro eyingo. Yo, Anutdo oni bidodo negoyeroro, ngundiromu, ene guranangge nangge rogoyerootoni, newendesina urorootenggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ngu naruno nguno, Mosesro mamana mande sobowooyingo oni oowooye Parisi, ngundo enengombo mande gosiyoro, ingondudu eyingo. Ene mande gosiyoro, Yisas sumoo mande ero inootooye, ene mete mande gumi metemimu ma ewa. Nguro ene oore erewero, Yisas goweyi sanggawero mande ewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ngundiro nguro, Parisiro kirikiri oni, ko, Herodro ko oni soweyerootoyi, Yisasno oororo, sumoo eyingo. Oo etuyeroyingo oni, noore ingooteto. Ge mande hamoomu nangge ete. Ge oni guraro nangge gome ma ingondudu tete. Kini, ge oni simoo bare bidodo yowuruyeroro, Anutro mande muri metemi nangge, ero etuyeroote. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ngundiro nguro, ge nooreno e. Ge ndadiro ingoote? Noore Yuda oni nga, digi beye Takis Sisano inowato, bine, ngundi kini bine? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","19","Ngundiro sumoo etoyi ngu, Yisasdo enengo mande godange ngu ingoro, enebana mande gumi eyingo. Ye mebuye tegedodo oni! Ndawugaro ye no towoonerootenggo? Ye digi beye gura Sisa inoweroyi ngu yoya, ombutoyiga, nondo kenoowe. Ngundiro etoni, ingoro, ene beye gura yoro, omburo, Yisas inoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Inootoyi, Yisasdo kenoro, enebana sumoo yunoyingo. Nga digi beye bungomo gabogaboyi, ko, oowooyi nakangoyingo nga oneromu? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ene ngundiro sumoo etoni, enebana mande gumi eyingo. Ngu Sisaromu. Ngundiro etoyi, Yisas enebana mande gumi eyingo. Sisaro oo ngu, ye komo Sisa inoyi. Anutro oo ngu, ye komo Anut inoyi. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Oniku ngu enengo mandega ngu ingoro, nguro ene soriyokoyingo. Ngundiro nguro, ene Yisas yokoro sayingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Arisa, ngu naruno nangge, Yuda oni gidarega oowooye Sadusi, ngundo Yisasno, mayeyingo. Ngu Sadusi oni, ngundo ngu, ene ngandiro ingoro etenggo. Oni kumootenggoku ngu, ene ko ma ootoogewanggo, ero ingootenggo. Ngu oni ngu Yisasno omburo, towoongowero sumoo inoro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Oo etuyeroyingo oni, Mosesndo mande gura ngandiro nakangoro yunoyingo. Oni gura simoongo kiningga kumoowaku ngu, arisa, kameyimboro konebeyi gura ootooro ngu, ngundo ngu bare wabuga ngu yowa. Nguno nangoningga tunootewaku ngu, ngu beyi hoorooweyingo oruwa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Arisa, oni simoonggoro guranangge ngu, ene kandegura gidemboro eraya, noore kewooronanimo oruwonggo. Koreteroga, ngundo barega yowo. Asa, ngu simoongo kini oode, kootuyisina kumoowo. Kameyi kumootoni ngu, asa, koneyombo ngu bareyi wabugaku ngu yowo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Yo, koneyo enebana ngu baregaku yoro, ene nguya simoongo kini oode, kumooyingo. Nguro koneyo kabusayigaku enebana ngu baregaku nangge yoro oode, ene nguya simoongo kini oode kumooyingo. Ngundiro nangge, ngu simoonggoro kandegura gidemboro erayagaku bare guranangge yoro, kumoorodoyi kiniteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kootuyisina, baregaku nguya kumoowo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Arisa, kootuyisina, oni kumooyingoku, ko ootoogewanggoku naruno nguno, ngu barega ngu oone bareyi nenengo? Ge ingoote. Ngu kandegura gidemboro erayagaku, ngu bidodo bareye guranangge. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yisasdo enengo mande ngu ingoro, gumi eyingo. Ye Anutro mandeno, ko, enengo yanggangoni nguya, ngu ma ingootenggo. Nguro ngu, ye mande buribari etenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Oni kumooyingo ngu ko ootoogeyingo naruno nguno, simoo bare kameyi bareyi teweroyi kini. Kini, ene Anutro sambono Engel oni oorootenggoku, ngundiro oruwanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ene nga mandega oni kumooyingo ko ootoogeweroyi ngu, ye Mosesro buk kuri kandangero ingoro, ene ye nguro muri nenengo ma ingootenggo. Ngu mandegano nguno, Anutdo Mosesro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","No Ebarahamro Anut, Ayisakro Anut, Yekobro Anut. Eyingo. Yisasdo mande gura soweyoro eyingo. Mosesro mande, ngundo etuyerooteku ngu, ngu ngandiro. Oni simoo bare keta oorootenggoku, ko oni kumooyingomu, nguro gaboye keta oorootenggoku, nguro Anut. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ngundiro etoni, oni simoo bare enengo mande etuyerowoku, ngu ingoro soriyokoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ngu naruno, Parisi onindo mande ingootoyi, Yisasdo Sadusi oniro sumoo mande bidodo ewonggoku, ngu andangemukootoni, nguro Parisi oni ene nguya Yisas towoongoweroyimboro oororo yowuruwooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Parisi oni gura, mamana mande gome watayi, ngundo Yisasno omburo, towoongoweroyi mande ngu ingoro, sumoo eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Oo etuyeroyingo oni, ndawu mamana mandega, ngundo mamana mande gidarega ngu dagayeroote? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yisasdo mande ngundiro ingoro, gumi eyingo. Oo Simburi Urungga, ngu gengo Anut hamoo oorengo. Gengo nowoondoge bidodo, ingonduduge bidodo, ngu yanggangongge oo ngu bidodo komo Anut inoya, gome keyo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Nga mamana mandega ngando mamana mande gidarega bidodo dagayeroote. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ngu mamana mande erayayiga nguya ngandiro. Gengomboro gome ingooteku, ngundiro nangge, ge tanggegemo oni gidarega oorootenggoku, ngu bidodoboro nguya nowoondoyi teyuno, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Nga mamana mande erayaga geno etenoku nga, ngu Anutro mamana mande bidodo nguro damoni oorengo, ko, Anutro ingondudu eyingo oniku, enengo mande bidodo nguro damoni nguya, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Asa, ngu naruno nguno, Parisi oni yowuruwooro oodoyi, Yisasdo sumoo yunoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Ye ndadiro ingootenggo? Krayis, Anutdo noore yoyoweroyi sunggi yeyingo oni, ngu oone nangoni? Etoni, Parisi onindo mande gumi ewonggo. Krayis, ngu Dewitro sembeni, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","44","Etoyi, enendo mande gumi eyingo. Arisa, Anutro mandeno nguno, ndawugaro Yuka Kundingiyimbo Dewit newende yokutuwootoni, Krayisro ero eyingo, Oo Simburi Urungga, ero eyingo? Anut Oo Simburi Urungga, ngundo noro Simbune Oo Bidodo Simburi, nguno ngandiro eyingo. Ge kandene koondosina musiyo bingamidodo nguno bibite. Kootuyisina ngu, nondo gengo mundi oni yoyewe, gengo kengge damonimo yoyewano. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Arisa, ene ngu Dewit enengo osiyi nangge ngu, arisa, ndawugaro Dewitdo eneya Oo Simburi Urungga, ewa? Yisasdo eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Yisasdo sumoo mande yanggangongga ewoku, nguro mande gumi eweroyi, oni gura ene ereremo kini. Ene ngu mandega ngu ingoro, ngu naruno, damoni yero, sosorero, nguro ene mande guraro ko ma sumoo inoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ngu naruno, Yisasdo enengo kirikiri oni, ko, oni simoo bare oowooyingga ngu mande wesiyoro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Mamana mande etuyeroyingo oni, ko, Parisi oni, ngundo Mosesro mamana mande ngu sobowooro, ngunonggo ye etuyerootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Mamana mande bidodo etuyerootenggoku, ye komo ngu bidodo keyoyi. Ene nondo ye roogo teyunooteno. Ye komo enengo muriye tetenggoku, ngu ma keyowero. Ndadiro nguro, ene mande metemi wesiyoro ero, ene enengombo ngu ma keyootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Yo, Parisi oni, ngundo mamana mande gura gura oni simoo bareno yetoyi, nguro ene ngu keyowero ko biyomi terootenggo. Ngundiro tero, ene oni simoo bare ma hoorooweyeroro, mamana mande keyootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ene oo bidodo tetenggoku ngu, onindo yeyoya, bingamiye okooyi, ero tetenggo. Ene kembawasayesina oo urungga yero, nguno Anutro mamana mandeni gidarega nakangoro gosiyoyingo. Ene towikumba piru piru oni bingamiyedodoboromu nguya yemuro, dogigiro nengguro darinidodo tero kutuwootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Yo, ene Yuda oniro yowuru yano, oni simoo bare doongeyemo tunoo bibiteweroyimboro, nguro gome oorengo ingootenggo. Ene oo simbo kayingo naruno nguya, yaba koreteyingo nguno bibiteweroyimboro, ngu gome ingootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Oowari uriyoweroyi musiyomo nguno, onindo ene yeyoro, kambayeroyi etoyi, nguro nguya gome ingootenggo. Ngundiro nangge, oni simoo baredo oo etuyeroyingo oni ero, oowooye bingami okooyi, ero teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ene yendo oni gidaregado oowooye bingamiye okooro, ngunonggo oo etuyeroyingo oni, eyi, ero ma ingowero. Ndadiro nguro, ye bidodo Anut doongeyimo ngu siyero oruwanggo. Yengo oo etuyeroyingo oni guranangge, ngu Anutdo nangge. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ngundiro nangge, ye nga merako ngano, oni guraya, Awanani, ero ma ewero. Ndawugaro nguro, ye Awaye guranangge ngu, Anutdo nangge sambo endemo ooroote. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ngundiro nangge, onindo yeya, tabango oni ero, ma ewero. Kini, yengo tabango oni ngu guranangge Krayis nangge. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ene ye kewooroyemo oni urungga tunootewero ingowaku ngu, asa, ene komo yengo ko oni orini. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ngundiro nangge, oni gura enengo oowooyi bingami okoowero ngu, Anutdo ngu oningga nguro oowooyi yeni bodaga ameno uwa. Ngundiro nangge, oni gura, enengo oowooyi ingootoni, ameno bodaga tewaku, Anutdo ngu oningga nguro oowooyi yeni, urungga tewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ye mamana mande etuyeroyingo oni, ko, Parisi oni, ye mebuye tegedodo oni! Ye ingonda teyi! Ye nowoondoye ma yowoorengoro, Anutno nguno ma oorowuwero ingootenggo. Yo, ye nowoondoye hamoo ma teyingo, nguro ye oni simoo bare gidarega nguya, ye yoyokootoyi, ene Anutro mandeni muriningga, ngundo enengo oni simoo bare soboyerooteku, nguno ma utenggo. Yo, yendo enengo Anutro nowoondoyemo hamoo teyingo muringga, nguro oore gosiyorootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ye mamana mande etuyeroyingo oni, ko, Parisi oni! Ye mebuye tegedodo oni! Ye ingonda teyi! Ye bare wabu ngu ganayeroro, torige torige ye enengo oo sitowi, ko, enengo ya nguya ngu kingo yororootenggo. Ngundiro tero ngu, oni doongeyemo, ye Anutno kingo kira piru piru tetoyi, Anutdo mete ngu bare wabu ngu hoorooweyerowa. No yeno mande yanggango eteno! Kootuyisina ngu, yengo muri biyomi tetenggoku, ngu Anutdo nguro gumi kowuri urungga oorengo yunowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ye mamana mande etuyeroyingo oni, ko, Parisi oni, ye mebuye tegedodo oni! Ye ingonda teyi! Ye wendeyino, ko, mera oriroko biyomi yade yade oororo, oni gura yootoyi, ngundo yengo nowoondoye hamoo teyingongga ngu keyowa. Ene ye ngu ko oningga ngu yoro, yengo muriye biyomi etuyerootoyi, enengo muri biyomi, ngundo yengo muri biyomingga ngu bidodo dagayerowa. Yendo ene nguya yoro, Setanro ende biyomi nguno uwanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","17","Ye doongeye kiringo oni, ye oni gidarega oore etuyerowero ngu, ye ingonda teyi! Ye oni simoo bare ngandiro muri biyomi ngu, godange mande, ero etuyerootenggo. Oni gura mande awuno oorengo sorumimonggo ero, Anutro yowuru ya kundingiyi Tembel, ngu oowooyimonggo mande ewaku ngu, arisa, mande ero gosiyowoku, ngu ene mete yokowa. Nguro ngu, onindo ene yoro, mande wirikoyingo onino oorowuweroyi nguya kini. Ngundiro nangge, oni gurado mande ero, digi beye gol gome gome Tembelno oorooteku, ero mande gosiyoro, ene mande awuno oorengo sorumimonggo etoni ngu, arisa, ngu mandega ngu, ene komo keyoni. Ene mande rogo gosiyowoku, ngu ma keyoro tetoni ngu, asa, onindo ene mete yoro, mande wirikoyingo onino oorowuwanggo. Mande godange ngundiro ero etuyerootenggoku, ngu biyomi oorengo! Ye doongeye kiringo oorengo! Ndawu ooga, ngu koreteyingo? Beye gol gome gome Tembelno oorooteku, ngundo bine, ngundi, Anutro Tembel, ngundo beye gome gome ngu yeni, kundingiyi tete, bine? Tembel kundingiyi ngundo gol beye yeni, kundingiyi nguya tunootete. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","19","Yendo mande biyomi gura nguya oni simoo bareno etuyerootenggoku, ngu ngandiro. Oni gura mande gosiyoro ngundiro ero, Anutno wooro yeweroyi digi yawasano ngu hamoo awuno oorengo sorumimonggo etoni ngu, arisa, ene mande gosiyowoku, ngu mete yokowa. Nguro ngu, onindo ene yoro, mande wirikoyingo onino oorowuweroyi nguya kini. Ngundiro nangge, oni gura mande gosiyoro, ngundiro ero, oo Anut inowoku, ngu wooro yeweroyi sanganimo oorooteku, ngu mande hamoo awuno oorengo sorumimonggo etoni ngu, asa, mande ewoku, ngu ene komo keyoni. Ene mande rogo gosiyowoku ngu ma keyoro tetoni ngu, asa, onindo ene mete yoro, mande wirikoyingo onino oorowuwanggo. Ye doongeye kiringo oorengo! Ndawu ooga, ngundo dagate? Oo Anut inowoku ngu, bine; ngundi, Anutno wooro yeweroyi digi yawasa, ngundo oo Anut inowoku, nguno yeni, kundingiyi tete, bine? Gol beye yemboongeyingo musiyomo yetenggoku, ngu musiyongga ngundo yeni, gol beye kundingiyi nguya tunootete. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ngu muri ngu, nenengo kini. Oni gura mande gosiyoro, Anutno wooro yeweroyi digi yawasa, nguro mande awuno oorengo sorumimonggo mande etoni ngu, arisa, ene mande gosiyoro, Anutno wooro yeweroyi, ko oo nguno Anut inowoku, ngu sanganimo nguno oorooteku, nguya gosiyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ngundiro nangge, oni gura Tembel nguro mande gosiyoro, awuno oorengo sorumimonggo etoni ngu, arisa, ene mande gosiyoro, Tembelno ko Anut kundingiyi nguya Tembelno oorooteku, ngu gosiyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Mande gura ngandiro. Oni gura sambo ende nguro mande gosiyoro, awuno oorengo sorumimonggo etoni ngu, arisa, ene mande gosiyoro, Anutro yaba bingaminidodo, ko, Anut nguya yaba sanganimo bibiteteku nguya, mande ero gosiyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ye mamana mande etuyeroyingo oni, ko, Parisi oni, ye manggoye tegedodo! Ye ingonda teyi! Ye yanggango yero, oo bidodo yengo kono suwe oo soodida nguya yootenggoku, nguromu kande erayaga ngu yoro, guranangge andangero, Anut inootenggo. Ngu hamoo oorengo, ngu muri gome tetenggoku, ngu metemi. Ene Anutro mamana mande oo urungga oorengo ngu, ye ma keyootenggo. Yo, ye muri nenengomo oni wirikoweroyi; nowoondoye ebe ino ino teweroyi nguro muri; ko, nowoondoye hamoo teyingo nguro muri, ngu ye ma keyootenggo. Ye komo ngu oo ngu teya, ko, Anut oo inoweroyi nguya keyoyi. Ngundiro muringga ngu, gome oorengo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","25","Ye mamana mande etuyeroyingo oni, ko, Parisi oni! Ye manggoye tegedodo! Ye ingonda teyi! Ye oni doongeye kiringo, ngundo oni gidarega oore etuyerowero tetenggoku ngundiro. Yengo koondo samayi, toba sanganisina ngu sonowooro, newendemo ngu yakaka muri, yengo ingondudu keyootenggoku, ngundo angero ooroote. Koretero, yengo toba newendemo ngu yomosiyootoyi, sarayi oodoni ngu, arisa, sangani nguya sarayi oruwa. Ye oni gura enengo sonono mimoo bodaga ngu sanganimo ooreteku, ngundiro. Oningga ngu sodedomangge mimoongga yoro, yokoro, ene bo urungga biyomi sono nero nemukooteku ngundiro. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ye Parisi oni, ye doongeye kiringo! Ye komo koretero toba newende sonowootoyiga sarayi yetoninggago, asa, kootu sanganisina nguya sarayi oruwa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ye mamana mande etuyeroyingo oni, ko, Parisi oni manggoye tegedodo! Ye ingonda teyi! Ye oni merengooweroyi musiyo sanganimo kumu sarayimbo dowootenggoku ngundiro. Sanganimo ngu, gome oorengo kenomayingoweroyi, ene mere newendemo ngu, oni wimbuye oowooyingga, ko oo bidodomo biyomi buwoo ngundo nangge angete. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ye ngundiro nangge oorootenggo. Oni goweye sangani kenoro ngu, oni nenengo, ero ingootenggo. Ene nowoondoyemo ngu, ye ebe ganagana teweroyi muri, ngundo nowoondoyemo angero oodoni, nguro mamana mande nenengo ngu yokootenggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ye mamana mande etuyeroyingo oni, ko, Parisi oni manggoye tegedodo! Ye ingonda teyi! Ye Anutro ingondudu eyingo oni, ko, oni nenengo kuri kumooyingo, ngu mereyeroyingo nguro mereye ngu gome yomosiyoro, irosara mitoyi, gome tetoni ngu, ngundiro oni nguro oowooye bingamiye okootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Mereyemo ye irosarangga tetenggoku, ngu oni simoo bare tero, etuyerowero ngundiro etenggo. Noore osisambado narungga oruwonggoku, nguno ootooro ngu, arisa, noore Anutro ingondudu eyingo oni yurewonggoku, ngundiro noore ma yureyingo, ero etuyerootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ye simoo bare doongeyemo muri ngundiro tetenggoku, ngundo tunoo oorengo etuyeroote. Ngu hamoo oorengo, ye ngu oni kuri Anutro ingondudu eyingo oni yureyi kumooyingo, ye nguro osisambaye oorengo yootunoro etuyerootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Asa, yengo osisambayebo oo damoni tewonggoku, ngu yendo enengo musiyemo dikaya, oo ngu bidodo temukoyi! ");
INSERT INTO rwo_rawa_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ye sire! Ye sire biyomi simoongo! Ye osisambayeboya, Setanro ende de nombo ma kumooweroyi, nguno oorowuwanggo. Ye saweroyi oore gura kini! ");
INSERT INTO rwo_rawa_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Arisa, no yeno etoowega, ye ingoyi! No Anutro ingondudu eyingo oni, ingondudu gome oni, ko, Anutro mande etuyeroyingo oni gome, no soweyerootoowe, yeno oorowuwanggo. Ene yendo gidarega yureyi kumootoyi; gidarega de omukondino yosanggawetoyi kumootoyi; gidaregado ye yowuru ya bidodo ngu newendemo gisasaruyerowanggo; gidarega yendo ende guranonggo oweyerootoyi, ene ende gurano satoyi, keyeroro sawanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","36","Ye ngu muringga ngu tetenggoku ngu, arisa, oni nenengomu bidodo merako ngano mundi onindo yureyi kumooyingo, nguro kowuri kootuyisina, ye yowanggo. Ye ngundiro oni nguro kowuriye koorowootoyi, kuri oorengo, Adamro nangoni Ebel, beyibo ureni kumooyingomu ngundiro nangge omburo, yade yade oororo, yowuru ya Tembel newendemo Anutro wooro yeweroyi tanggeyemo, ngu naruno, oni gurado Sekarayiya, Berekayiya nangoni, ngu ureyi kumooyingo. Nguro no yeno hamoo eteno. Ye nga oni oorootenggoku nga, ye bidodo uri biyomi, ngu oo tewonggoku nguro yowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Oo Yerusalem, Yerusalem simoo bare! Suwooyi sano, no nowoondoye hamoo teyingo, nguro oore nenengo etuyeroro, kandenembo yodowooro soboyerowero ingooteno. No yodowooro, hoorooweyerootoowe, kootoori nemimbo simoongo wireyo newendemo wiriyoro, boogoyerooteku, ngundiro tewero ingooteno. Ene ye nguro ma ingoro, no noyokowonggo. Ngundiro tero, ye Anutdo enengo ingondudu eyingo oni soweyerootoni yeno oorowutoyi, yendo ene yureyi kumooro, digi yoro, noro ko onino oorongooro, ene nguya yurewonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ngundiro nguro, ye ingoyi! Anutdo ye yoyokootoni, nguro ye kingo oruwanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Yo, no yeno hamoo eteno. Ye ko no ma neyoro oode oode oororo, yengo manggoyebo mete ko ewanggo. Anut, gedo oningga ngu gengo oowoonggemo ombuteku, ngu kumana ino, ero ewanggo. (Sam 118:26) ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yisasdo Yuda oniro yowuru ya oowooyi Tembel ngu yokoro oorowutoni, ngu naruno nguno, enengo kirikiri oniku eneno omburo, ene Yisas Tembel ngu ya digibo yeyingo, ngu etungoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ngundiro etungootoyi, Yisasdo mande gumi eneya eyingo. Ye ngu oo ngu bidodo kenomukootenggo? No hamoo oorengo, yeno eteno. Ngundiromu, kootuyisina, Tembel ngu bidodo toongooro yomburiyowangggo. Yo, digi gura yokootoyi, gura sanganimo ma oruwa. Nga digi nga bidodo usosowooro, oorongooyi merako umukowa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yisas mera puri ngu oowooyi Olib, nguno oorero, bibitetoni, enengo kirikiri onikundo nangge, Yisas tanggeyimo omburo, sumoo inoro eyingo. Ge nooreno e. Ndawu narunggano, ngu ooga ngu tunootewa? Ge ko ombuweroyi naruno, ko naru wengamo oo tunooteweroyi, ngu ndawu sunggiga? Ene ngundiro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yisasdo enengo mande ngu ingoro, enebana gumi eyingo. Ye komo ingonda teyi! Ye oni yoyokootoyi, ngundo ye ma ganayerowero. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Oni oowooyingga oorengo no oowoonemonggo tunootero, ngu ganayeroro, ngandiro ewanggo. No nangge, Krayis. Anutdo oni simoo bare yoyowero ero, no soweneroote, ero ewanggo. Ene ngundiro ero, nguno ene oni simoo bare oowooyingga oorengo ganayerowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kootuyisina, ye me ebe ngguyi ingoro, me ebe nguro mande binga nguya ingowanggo. Ngundiro ingoro, ye nguro ma sosorewero. Ndawugaro nguro, oo ngu hamoo tunootewaku, ene ngu naru wenga kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ngu naruno nguno, oni sowe gurado ootoogero, oni sowe guraya ebe urewari. Mera guraro oo bidodo sobosobo oni, nguro me oni, ngundo ootoogero, mera guraro oo bidodo sobosobo oni, nguro me oniya ebe urewanggo. Ngundiro nangge, mera bidodomo, simoo bare oodoro kumooyingo urungga tunootetoni, mera guminggano, ngu imimi urungga yowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Yo, baredo simoo bisiyowero ogingo urungga koretero ingooteku, ngu ye ingootenggo. Ene simoo bisiyoweroyi ngu namoko. Ngundiro nangge, ye ngu oo ngu tunootetoni kenoro ngu, asa, ye ingowanggo. Naru wenga ngu namoko tete, ero ingowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Yo, ngu naruno, mundi onindo ye yodowooro, ogingo urungga kowuri nguya yunoro, yureyi kumoowanggo. Mera bidodomo, oni simoo baredo ngundiro muri biyomi yeno tetoyi ngu, ndawugaro nguro, no oowoone yeno oodoni, ye nowoondoye nono hamoo tetenggokuro. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kootuyisina, kowuri urungga tunooteweroyi naruno, oni oowooyingga Anutno nowoondoye hamoo teyingo, ngu kowuringga ngu koorowooweroyi ma ingowero. Ngundiro nguro, enengo nowoondoye hamoo teyingo, ngu yokoro, ene ko ma keyowanggo. Ngundiro tero ngu, ene dobookuriye Anutro pawa newendemo oorootenggoku, ngu yodowooro, mundi oni kandeyemo yero, ene nguya ngu oni Anutno nowoondoyemo hamoo teyingo nguya boguwooro, sanggiri tewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ngu naruno, Setanro ingondudu eyingo oni godange oowooyingga, ngundo tunootero, oni simoo bare oowooyingga oorengo ganayerowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ngu naruno, mera bidodomo, muri biyomi urungga oorengo ngu tunootetoni, nguno ngu, oni simoo bare enengo ingondudu nangge keyowanggo. Ngundiro nguro, enengo nowoondoye ebe ino ino teweroyi muringga, ngu yokowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ene oni simoo bare Anutno nowoondoye hamoo teyingo, ngu yanggango oode oode oororo, naru wengamo nguya oodoyi ngu, asa, Anutdo ngu ko yoyowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Kuri ngandiro kowuringga ma tunooteyingomo, arisa, koretero, Anutdo enengo ko oni soweyerootoni, mera bidodomo saro, oni simoo bare sowe gura gura nguno Anutro mandeni muriningga, ngundo enengo oni simoo bare soboyerooteku, ngu wesiyoro yunowanggo. Ngundiro sunggiga ngu temukootoyi ngu, asa, hamoo oorengo, naru wenga nguno tunootewa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Yisas mande gura soweyoro eyingo. Ngu oo biyomi oorengo, Setan ngundo Anutro kundingiyi oorengo musiyomo dikatoni, ye ngu kenoro ingoro ngu, asa, ye ingowanggo. Kuri Anutro ingondudu eyingo oni Daniyel, ngundo mande ngundiro eyingo, ngu ataga engge tunootete, ero eyingo. Oni gura nga mande nakayangga nga kandangeya, ene komo gome ingoni. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ngu naruno nguno, oni simoo bare Yudiyano oorootenggoku ngu, ene komo mete sodedo saro, purimo oorewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Oni endesina oorootenggoku ngu, ene ko ya newendesina uro, enengo oo sitowi yoweroyimboro ma uwanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ngundiro nangge, oni kono oorooteku ngu, ene ko oororo, ya newendesina uro, enengo dogigiro nengguro yoweroyimboro ma uwanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Yo, ngu naruno, bare kawuyedodo, ko, bare simooye nono yunootenggoku, nguro oni oni yooge! Ndadiro nguro, ene sodedo kendutero, mera purimo ooreweroyi, ngu ereremo kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Nguro ye komo yemboongeyi. Doogo dogigi, ko, sono midugu naruno, ngundi, kundingiyi naruno nguno oo ngundiro ngu ma tunootewero. Ndadiro nguro, ngu naru biyomimo tunootetoni ngu, oni purimo ooreweroyi, ngu ereremo kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ngu naruno nguno, kowuri urungga oorengo tunootewa. Kurimi oorengo, Anutdo oo bidodo yeyingo naruno, ngunonggo omburo, ataga nga naruno ngano nguya, kowuri ngundiro kuri ma tunooteyingo. Kootuyisina nguya, kowuri ngundiromu nguya kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ene Oo Simburi Urungga, ngu kowuri narungga ngu woosootoni, ma ootutetoni ngu, arisa, oni simoo bare bidodo Anutdo kuri rogoyeroyingo, ngu keta oruweroyi ereremo kini. Nguro ngu, ene ngu narungga ngu woosootoni ootutewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ngu naruno nguno, oni gurado yeya ewaku ngu, kenoyi, Krayis nga oorooteku nga; ngundi, kenoyi, ene andusina oorooteku andu! Ene ngundiro etoni ngu, ye nguro nowoondoyemonggo hamoo ma tewero. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Nguro ngu, Setanro ko oni gidaregado tunootero, ganayeroro ero, no Krayis, Anutdo noore yoyowero sunggi yeyingo oni, ero ewanggo. Ngundi, Setanro ingondudu eyingo oni godange, ngundo ero ewanggo. No Anutro ingondudu eyingo oni, ero ewanggo. Ene sunggi guradiro guradiro songo songo tewanggoku, ngundo muri songo oorengo gura onindo ma teweroyimu, ngundiro tero, simoo bare Anutdo kuri enengo rogoyerowoku ngu, ene mete tetoni ngu, ene ngu ganaganayeroro yoyoweroyimboro tewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ingoyi, no oo bidodo kootuyisina tunooteweroyi, no ataga yeno etoowe, ye ingootenggoku, nguro ye komo ingonda teyi! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ngundiro nangge, oni gurado yeya ero, kenoyi, ene andesina oni kini kingo merako oorooteku ande, etoyi ngu, ye nguno ma oorowuwero. Ngundiro nangge, ene ko ewanggo. Kenoyi, ene nga yangga nga newendemo kombitero oorooteku nga! Etoyi ngu, ye enengo mande ingootoyi nowoondoyemo hamoo ma tewero. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Yo, yowari soruyi ogisa ooretekusinanggo dero oororo, sa utekusinanggo dero toongete. Yowari soruyi kenooteku, ngundiro nangge, no Anutro Nangoni Oni Kirarongo ngu tunoo oorengo neyootoyi, ko ombuwano. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ngu naruno, mera gumisina punggi bawooro, oororo, omburo tetoni, ye bidodo nguno kenoro tunoo ingowanggo. Oo buwoo gura ngu merasina nguno ooroote. Ngundiro nangge, no ko ombutoowe ngu, ye bidodo tunoo oorengo ingowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Yisasdo mande gura eyingo. Ngu kowuri urungga ngu kinitetoni ngu, arisa, sa kombo nguya doobeyerootoni, himi ma yewari. Tootu bidodo ngu yokutuwooro sisorewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ngu narunggano nguno, no Anutro Nangoni Oni Kirarongo, noro sunggi sambono tunootetoni, merako oni simoo baredo kenoro sendowanggo. Ndadiro nguro, no Anutro Nangoni Oni Kirarongo goobooreno duridarinedodo, yanggangone oorengododo ombutoowe neyowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Anutro unggu gura oowooyi Biyugel ngu yanggango uwootoni, ngu naruno, Anutdo enengo sambono Engel oniku ngu soweyerootoni, omburo, mera bidodomo, ende gura gura bidodomo oororo, oni simoo bare Anutno nowoondoyemo hamoo teyingo, ngu bidodo yoyoro, omburo, eneno watayewanggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","33","Yisasdo mande adingayi gura ero eyingo. Ye Kopi dega ngu kenoya, ko, de gidarega nguya yeyoyi. Ye kenootoyi, nungo yero, bubudingo yetoni, ye ngu kenoro ingootenggo. Ataga Kopi enggeweroyi naruwo tunootewero tete, ero ingootenggo. Ngundiro nangge, kootuyisina, ye ngu ooga ngu kenootoyi, tunootewaku ngu, arisa, ye nguno ingowanggoku ngu, ngu ooga ngu, Yisas ko ombuweroyi naruwo namoko tetoni, nguro sunggi ngundiro tunootewa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","No hamoo oorengo, yeno eteno. Ataga nga naruno, ye Yuda sowengga ngaro simoo bare nga ma kumoomukoyingomo, nga oo nga bidodo tunootewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Sambo mera nguya ngu oororo kinitewa. Ene ngundiromu, noro mandene nga ngu ma kinitewa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Yisas mande gura eyingo. Oni ngu noro naru ko ombuweroyiga, ngu sangga nguya, ene ngu ma ingootenggo. Anutro Engel oni sambono oorootenggoku ngu, ene nguya ma ingootenggo. No nguya, ene ma ingooteno. Awane Anutdo nangge ngu ingoote. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ngundiro muri onindo kuri Nowa oodoni, nguno tewonggoku, ngundiro nangge, no Anutro Nangoni Oni Kirarongo ombutoowe, nguya muri ngundiro tewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Yo, kuri Nowaro naruno, koretero Anutdo sono tuwi urungga oorengo soweyootoni, omburo, mera bidodo ma doobengoyingomo, ngu naruno, oni simoo bare oo nero, sono nero, kamebare teroodoyi, Nowa nguno wanggo newendemo uyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ene ngundiro tero, Anutdo oo yeni tunooteweroyi, ngu ene ma ingoyingo. Nguro Anutdo sono tuwi urungga oorengo soweyootoni, omburo, mera bidodo doobengootoni, oni simoo bare yutomukoyingo. Ngundiro nangge, naru wenga oorengomo, no Anutro Nangoni Oni Kirarongo ombutoowe, ngundiro muri nguya tunootewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ngu naruno nguno, oni eraya kono oruwariku ngu, Anutdo omburo, oni gura yoro, gura kono yokowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ngundiro nangge, bare eraya oomanongoyingo tetori ngu, Anutdo omburo, gura yoro, gura yokowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Arisa, no yeno hamoo oorengo eteno. Ye ingonda teyi! Ndawugaro nguro, Oo Simburi Urungga ngu ombuweroyi narungga, ngu ye ma ingootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ene ye komo ingoyi! Ya simburi (Kristen) ene ndawu narunggano yakaka oni omburo, ya usowooweroyi ngu ingoro ngu, arisa, ene meyero oodoni, yakaka oni omburo ngu, ene ya usowooweroyi, ngu ereremo kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ngundiro nangge, ye nguya komo meyeya, doongeteya oriyi! Ndadiro nguro, no Anutro Nangoni Oni Kirarongo ombuweroyi naru ngu, ye nguro ma ingondudu tetoyi, nguno no ko ombuwano. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ya simburibo ene mera gurasina toongewero ngu, ene ko oni gomengga ingondudu gome ngu rogo tetoni, ngundo ya nguro ko oni sobosobo gome ootooro, oo neweroyi naruno, oo nenengo yunootoni, oo nero gome oruwanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ngundiro nangge, kootuyisina, ya simburigaku ko omburo, ko oninggakuya oo ewoku, ngundiro tetoni, kenoro ngu, arisa, enengo ko oni sobosobogaku, ene mete oni oni tewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Arisa, no yeno hamoo eteno. Ngu ya simburiga, ngundo ko sobosobo oninggaku yero, nguro oo nggiringgara bidodo, ngu ko oningga ngu kandeyimo yetoni, gome sobowoowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","49","Ngundiro nangge, ngu ko sobosoboga nguro muri biyomi oruwaku ngu, enengombo ngundiro ingoro eyingo. Noro sobosobo oni urunggaku naru oowooyingga ngu ma ombuyingo. Ene ngundiro ingoro, nguro ene damoni yero, enengo ko gobooro oni yutoro, ene oni gidarega ngu oowari nero, sono biya gome gome nero, kakabetero oriyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Kootuyisina, naru gurano, ngu ko sobosobo oni biyomingga, ngu enengo sobosobo oni urunggaku ombuweroyi naru ngu ma ingoro oodoni, arisa, enengo sobosobogaku omburo, ko oningga nguro ko biyomi tewoku, ngu kenowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ko biyomi ngundiro kenoro ngu, asa, ngu ko sobosobo oni biyominggaku ogingo urungga inoro, soweyootoni, oororo, oni mibuye tegedodo oni oorootenggoku musiyo biyominggano, nguno ene nguya oruwanggo. Ngu ende biyominggano nguno, sendo urungga tero, metokarikari tero oruwanggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ngu naruno, Anut Oo Bidodo Simburi Simbunani, ngundo naru enengo oni simoo bare ngu soboyerooteku, ngundo nga bare oore simoondoya ma wereyingo kande erayaga, nguro muri ngu ngandiro. Simoo gura bare yoweroyi naruno ngu, ngu bare ko enengo bare dobookuringo mayero, ngu barega ngundo yano kameyinggaku ombuweroyi, ngu sobowooro oruwanggo. Arisa, ngu simoongga ngu bareyi yoweroyimboro ombutoni ngu, enengo bareyi nguro dobookuringo ngu kameyi ombutoni ngguyi ingoro, nguro ene soru karo dowooro, endesina oorero, doongetero, kameyi kenoweroyimboro oorewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Asa, bareyi dobookuringo kande eraya nguromu kandegura ngu ingondudu kini, ko, bare kandegura ngu ene ingonduduyedodo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Bare ingonduduye kiningga enengo soru ngu yowonggoku, ene Karasin ngu ene ma yoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ene bare ingonduduyedodo ngu, enengo soru, ko, Karasin nguya nggusingoro, ngu yoro ombuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ene bare yowoku oninggaku, sodedo ma ombutoni, nguro bareku kubooyerootoni wereyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Suwoo kewooroko oni meno moguru tero, eyingo. Bare yowoku oninggaku ombuteku ngu! Nguro ye ooroya, ooreko kenoya, yoya ombuyi! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Arisa, bareku ngu ingoro ootoogero, enengo soru yomosiyoro yoonenengoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Asa, ngu naruno nguno, bare ingonduduye kinikundo bare ingonduduyedodokuya eyingo. Yendo Karasin gura noore yunootoyiga nggusingowato. Noorendo sorungga kumoowero teteku nga. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ene nguro mande ingoro, enebana gumi eyingo. Kini, noore Karasin ye nguya ko noore nguya rogoyimo kini. Noorengo rogoyimo nangge. Ngundiroga ngu, mete ye ooroya, Karasin gura uriyoyi. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Arisa, ngu bareku Karasin uriyowero oorowutoyi ngu, ngu naruno nguno, bare yoweroyi oninggaku ngu ombuyingo. Bare kandegura ngu enengo soru kuri yomosiyoro, yoonenengoro oodoyi, bare yoweroyi oninggaku ngu omburo, bare yoro, ngu bare oore kandegura nguya hoorooweyeroweroyi, ngu bidodo yoyoro, ya oo simbo kayingo yanggakuno utoyi, ene yamuko goodooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Kootuyisina, bare kandeguragaku Karasin uriyowonggoku ngu omburo, yamuko utoro eyingo. Urungga, urungga, ombuya, noorengo yamuko goosooyuno! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ene nguro mandeye ingoro, enebana gumi eyingo. No yeno hamoo eteno. No ye watayi kini. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Asa, Yisasdo mande gura soweyoro eyingo. Ye komo ingonda teya sobowooyi! Ye oni gurado ombuweroyi narungga ngu, ko sangga nguya, ye ma ingootenggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yisasdo mande adingayi gura eyingo. Anut Oo Bidodo Simburi Simbunani, ngundo endega enengo oni simoo bare soboyerooteku, ngu ngandiro. Oni gura mera orirokono oorowuwero ngu, arisa, ngu enengo ko oni negoyerootoni, ombutoyi, enengo oo sitowi ko oni ngu kandeyemo yetoni sobowooweroyimboro. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Sobosobo oninggakundo enengo ko oniku wirikoyeroro, muriye yanggangoye kenoro, ingoro, nguro ene ngundiro digi beye andangero yunoyingo. Enengo kirikiri oni nguro muriye metemi oorengo kenoro, nguro ene ngu oninggaku ya simburigakundo digi beye oowooyingga oorengo K5,000 Kina sobowooni, ero inoyingo. Enengo kirikiri oni nguro muriye metemi kenoro, ngu oninggaku sobosobo oninggakundo digi beye oowooyingga K2,000 Kina sobowooni, ero inoyingo. Ngundiro nangge, ko oni guraro ene digi beye K1,000 Kina sobowooni, ero inoyingo. Ngundiro tero ngu, ene yoyokoro, orirokono toongeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Toongetoni ngu, arisa, enengo ko oni digi beye K5,000 Kina yowoku, ngundo ko yanggango tero, ngunonggo digi gumi K5,000 Kina gura ngundiro soweyoro yoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ngundiro nangge, oni gurado digi beye K2,000 Kina yowoku, ene nguya ngundiro koyi tero, digi K2,000 Kina gura yoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ngundiro nangge, ko oni digi beye K1,000 Kina yowokunggaku, ene digi yoro, oororo, mere sero, nguno sobosobo oningga nguro digi beyeku, nguno oongooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Kootuyisina, naru kinitetekuno, sobosobo oningga ko mayero, enengo ko oni kabusagaku yeyoro, digi beye yunoyingo, nguro mande ingowero. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Arisa, ko oni digi beye K5,000 Kina yowoku, ene ko tero, ngunonggo digi K5,000 Kina ko yoro, enengo oo sobosobo onikuno oororo eyingo. Oo urungga, ge kuri digi K5,000 Kina nunowoku, nguno nenengombo ko yanggango tero, digi K5,000 Kina gura soweyoro yowonoku, nga keno. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Enengo oo sobosobo oninggakundo enengo mandeni ingoro, enebana gumi eyingo. Ge ko oni gome oorengo! Gedo ko gome hamoo tewo! Gedo nga digi beye bodaga sobowoowokuro, nguro no digi beye oowooyingga gunootoowega sobowo. Arisa, yano ombutooga, noya oni oni tewaro. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ko oningga digi beye K2,000 Kina yowoku, ngundo digi beye K2,000 Kina gura soweyoro, yoro, omburo, oo simburinggaku etungoro eyingo. Oo simburi urungga, gedo digi beye K2,000 Kina nunowoku, ngundo ko yanggango tero, digi beye K2,000 Kina gura ko yowonoku, nga keno. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Etoni, enengo oo sobosobo oninggakundo eneya mande gumi eyingo. Ge ko oni gome! Gedo gome oorengo tero, ko gome tewo! Gedo nga digi beye bodaga gome sobowoowokuro, arisa, nguro no digi beye oowooyingga gunootoowega sobowo. Nguro ngu, yano ombutooga, noya oni oni tewaro. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Arisa, ko oni gura digi beye 1,000 Kina yowoku, nguya omburo, oo sobosobo oni urunggano eyingo. Oo simburi urungga, no kuri ingootenoku, ge digi beye woosooro, yoweroyi oni yanggango. Ge onindo kononggo oowari, gedo ma miyingo, ngu yoote. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ngundiro nguro, no gengo sosorero, nguro digi beye nunowoku, no sodedo oororo, mere sero, nguno oongoowono. Ngu digi beye nunowoku ngu, nga oorooteku nga. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","27","Asa, oo sobosobo oni urunggakundo sanggiri tero, mande gumi eyingo. Ge ko oni biyomi oorengo! Ge surekinikini oni! Ge kuri ingooteku ngu, no onindo kononggo nondo oowari ma miyingo, ngu yootenoku, asa, ndawugaro nguro, ge digi beye sobowo, ero gunowonoku, ngu digi beye yeweroyi musiyomo, nguno ma yewo? Noore digi beye ngundiro oorooteku ngu, no ko ombutenokuno, arisa, ngunonggo digi beye gura nguya yoro, yowuruwooro yowano. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Arisa, oni urunggakundo enengo ko oniya eyingo. Ye ngu oningga, digi beye K1,000 Kina inowonoku, ngu sobiyoya, noro ko oni gome digi beye K10,000 Kinadodoga, ngu inoyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ndawugaro nguro, oni gurado oo oowooyingga ngu gome sobowoowaku ngu, arisa, no oo oowooyingga gura soweyoro inowano. Ngundiro nangge, oni gurado oo bodaga ngu biyomi sobowoowaku ngu, asa, ngu oo bodaga ngu dowooteku, ngu andangero yokowano. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Yo, ngundiro ko oni biyomingga ngu owetoowe, enderoko mera ureriko ootooro, ngunonggo sendo urungga tero, metokarikari tero oruwanggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yisasdo mande ero yokoro ngu, asa, yowoorengoro, enengo kirikiri onino ngandiro eyingo. Kootuyisina, no Anutro Nangoni Oni Kirarongo nenengo duridarinedodo ko ombuwano. Nenengo sambono Anutro Engel oni ngudodo omburo, ngu naruno duridarinedodo nenengo yaba bingaminedodo nguno bibitewano. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ngu naruno nguno, oni simoo bare nono mayero yowuruwootoyi, nondo wirikoyeroro, wata eraya yoyewano. Yo, sobosobo onindo Sipsip andangero, pawa gurano yero, bo Meme andangero, pawa gurano yetenggoku, ngundiro tewano. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","No Sipsip ngu andangeyerootoowe, ngu kandene metemisina oorowutoyi, ngundiro nangge, bo Meme ngu andangeyerootoowe, ngu kandene biyomisina oorowuwanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ngundiro nguro, oo bidodoboro sobosobo koreteyingo oningga, ngu enengo kandeyi metemisina oorootenggoku nguya ewa. Ye Awanembo kumana yunowa! Kuri mera nga keta tunootetoni, Awa ngundo endega enengo oni simoo bare soboyerooteku, ngu kuri yomosiyoyunowoku, ngu endegano nguno uwanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ndawugaro nguro, kuri no oodoro kumootoowe, nguno yendo oowari yoro nunowonggo. No sonoro ingootoowe, nguno yendo sono yoro nunowonggo. Ngundiro nangge, no ende gura onimu, ene yendo noyoro, yengo yano uwonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ngundiro nangge, no towi kinimu, nguno yendo towi nunowonggo. No sayi yootoowe, nguno yendo yomosinerowonggo. Ngundiro nangge, no ya biyomimo oodoowe, ye nguno oororo neyowonggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ngu oni kandeyi metemisina oorootenggoku, ngundo sumoo inoro, ngandiro mande gumi ewanggo. Oo Simburi Urungga, ndawu narunggano, ge oodoro kumootoyi, oowari gunowooto? Ko ndawu narunggano, ge sonoro ingootoyi, nguno noorendo sono gunowooto? ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ndawu narunggano, ge ende gura onimu geyoro goyoro, noorengo yano uwooto? Ko ndawu narunggano, ge towikumba kinimu, nguno noorendo towikumba gunowooto? ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ndawu narunggano, ge sayidodo tero, ngundi, ge ya biyomimo oodoyi geyowooto? Ene ngundiro ero, sumoo ewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Yisasdo enengo mandeye ngu ingoro, enebana gumi ewa. No hamoo oorengo, yeno ewano. Ye merako ngano noro konedoboonengga oowooyi kinimu, ngu yomosiyowonggoku ngu, asa, ye no nguya yomosinerowonggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ngundiro nangge, no oni kandene biyomisina nguya ewano. Ye oonooteweroyi oni! Ye noyokoya, de nombo ma kumooweroyi, nguno oorowuyi! Ngu de nombo ma kumooweroyingga ngu, ngu yengo Awaye Setando nguno enengo Engel oni biyomidodo oriyi, ero yewo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ndadiro nguro, no kuri oodoro kumootoowe ngu, nguno yendo oowari no ma nunoyingo. Ngundiro nangge, no sonoro ingootoowe ngu, nguno ye sono yoro, no ma nunoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","No ende guraro onimu oruwonoku ngu, ye noyoro, yengo yano ma uyingo. Ngundiro nangge, no towikumba kinimu, nguno yendo towikumba ma nunoyingo. No sayi kumooro, ko, ya biyomimo nguya oruwonoku, nguno ye omburo, ma neyoro hoorooweneroyingo, ero ewano. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Yisasdo ngundiro etoni ngu, enebana mande gumi ewanggo. Oo Simburi Urungga, ndawu narunggano noore geyootooye, oodoro kumooro, sonoro ingoro, ngundi, ge ende gura oni, ngundi, ge towikumba kini, ngundi, ge sayi kumooro, ko, ge ya biyomimo nguya oodoyi, nguno noore ge ma yomosinggeroyingo? Ngundiro sumoo ewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ngundiro sumoo etoyi ngu, asa, Yisas enebana mande gumi ewa. No hamoo oorengo, yeno eteno. Ye merako ngano oni gura oowooyi kinimu, ma yomosiyoyingo ngu, ye no nguya ma yomosinerowonggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ngundiro nguro, ngu oni ngu uri biyomi yoro, Setanro ende de nombo ma kumooweroyingga, nguno oorongooyerootoowe, sugi sugi ogingo yoro oruwanggo. Ngundiro nangge, oni nenengo kandene metemisina oorootenggoku, ene ngu musiyo metemimo nguno, Anutya sugi sugi keta oruwanggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yisas mande bidodo etuyeromukoro, yokoro ngu, ngu naruno, enengo kirikiri oniya eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Ye kuri ingootenggo. Naru erayaga nguya yokoro, Anutro sunggi kenoro, dagayeroyingo naruwo, oowooyi Pasowa, ngu tunootewa. Ngu naruno, no Anutro Nangoni Oni Kirarongo, onindo no mundi oni kandeyemo yootunoneroro, de omukondino nureyi kumoowano. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ngu naru nguno, Anutro wooro yeyingo oni kundingiyi sobosobo oniku, ko, Iserel oniro tabango oni bidodo, Kayiyapasro ya gome oorengo, nguno yowuruwooyingo. Kayiyapas ngu Anutro wooro yeyingo oni kundingiyi sobosobo oni koreteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Yo, tabango onindo yowuruwooro, ene oore erewero mande gosiyoro, Yisas yoro, ya biyomimo yewero tero, ureyi kumooweroyimboro teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ene ngandiro ingondudu tero eyingo. Noore naru kundingiyimo, ngu ooga ngu ma tewato. Ndadiro nguro, oni simoo baredo me ebe ngu yeyi tunootewa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ngu naruno nguno, Yisas Betani endemo oororo, kuri oni gorimambudodoga oowooyi Sayimon, ene nguro yano oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ngu naruno nguno, bare gura omburo, ngu nggusiyi gome oorengongga digibo teyingo, ngu kumu bo urumi gura ndindingo gomemu oruwoku, ngu urini urungga yokoro uriyoyingo. Ngu oo ndindingo gomengga ngu yootoni, Yisas ene oo neweroyi yabano bibitetoni ngu, ene ngu bo urumi nggusiga ngu Yisas tabangomo wendoyingo. Ngu barega ngundo muringga teyingo ngu, ene Yisasro gome oorengo ingoro, ngundiro tero etuyeroyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Enengo kirikiri oni oruwonggoku, ngu kenoro, nowoondoye biyomi yero eyingo. Ndawugaro, nga bo urumi gomengga nga kingo yomburiyoote? ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nga ngu oni yunootoyi, ngundo uriyootoyi ngu, nguro urini urungga yoro, ngundo mete angoyi oni yunoweroyi. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yisasdo enengo nowoondoye kuri kenoro, ingoro eyingo. Ndawugaro, ye nga barega nga kowuri inootenggo? Ene muri gome ngu nono tete. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Angoyi oni ngu yeya suwooyi sano oruwanggo. Narudodomo, ye mete ene hoorooweyerowanggo. Ene no ngu, yeya suwooyi sano ma oruwato. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Barega ngundo ingoro, tenunooteku nga, ene bo urumi no gowenemo yeteku ngu, ene no mereno noyeweroyi, nguro no yomosineroote. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","No hamoo oorengo yeno eteno. Mera bidodomo, Anutro Mande Keta Mesarango ngu wesiyoro, ewanggoku ngu, nga bare ngando teteku nga nguya mandeni ero, nguro nguya ingondudu tero ingowanggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ngu narunggano nguno, Yisasro kirikiri oni kande eraya kegidemboro eraya, nguromu gura, Yudas Iskariyoot, ngundo ene Anutro wooro yeyingo oni kundingiyi nguro sobosobo onikuno oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Yudasdo eneno sumoo eyingo. Yendo ndawu ooga ngu nunootoyi, Yisas yoro, omburo, kandeyemo yunowano? Ero eyingo. Enengo mande ngundiro ingoro, arisa, ene digi beye doobe kabusa (30 Kina) kandeyimo yeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ngu naruno, Yudasdo damoni yero, oore erewero, ndawu narunggano Yisas yootunoro, mundi oni kandeyemo yeweroyimboro. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Kowooyingomboro naru koreteyingo, oomanongoyingo Yis kini neweroyi naruwo tunootetoni, kirikiri oni Yisasno omburo, sumoo eyingo. Gedo ngu noore ndano saya, naru kundingiyi nguro oowari yomosiyoro, neweroyimboro ingoote? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yisasdo enengo mandeye ngu ingoro, enebana gumi ero eyingo. Ye ende gurano uya ngu, oni gura Anutdo rogo tewoku, nguno ooroya, ngandiya eyi. Oo etuyeroyingo oningga, ngundo ete. Noro naru namoko tetoni, nguro no nenengo kirikiri oniya gedo yano oowari kundingiyi newato ero ete, ngundiya eyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ene ngundiro etoni, arisa, kirikiri oniku uro, Yisasdo ewoku ngundiro tero, ene oowari kundingiyi ngu yomosiyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Suwootetoni, enengo kirikiri oni kande eraya kegidemboro erayagakudodo, oo neweroyi yabano bibiteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Oo nerootoyi, Yisasdo eyingo. No hamoo oorengo, yeno eteno. Oni gura ye kewooroyemo nganonggo, windogayi no yootunoneroro, mundi oni kandeyemo noyewa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Kirikiri oniku enengo mandeni ngu ingoro, nguro ene nowoondoye kowuri urungga ingoro, guranangge nangge oororo, Yisas sumoo inoro eyingo. Ge noya ete, bine? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ngundiro etoyi, asa, Yisasdo mande gumi eyingo. Nga oningga noya kandenari koondomo gobooro yeterokungga, ngando mundi onino yootunonerowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Yo, oo bidodo kuri Anutdo enengo mande nakangoyingo ngu, no Anutro Nangoni Oni Kirarongo, nono engge ngundiro tunootewa. Ngundiromu oningga no Anutro Nangoni Oni Kirarongo, mundi onindo oni yootunonerooteku ngu, ngu oni yooge! Yo, no ngu oningga ngu oni yooge, ene nemimbo ma bisiyoyingo ngu, kowuri ngundiro ngu eneno ma tunootewa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ngu naruno, Yudasdo mundi oni kandeyemo yewero mande gosiyowoku, ngundo Yisasno eyingo. Oo etuyeroyingo oni, ge noya ete, bine? Etoni, Yisasdo mande gumi eyingo. Gengombo eteku ngu nangge. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ene oo nero oodoyi, Yisasdo oomanongoyingo gura yoro, Anutno yemboongero, oosowooro bayetero, yunoro eyingo. Nga yoya neyi. Nga nenengo songgiwine. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","28","Ngundiro ero ngu, ene Wayin sonoyi tobaga ngu yoro, Anutno yemboongero, yunoro eyingo. Ye bidodo nga Wayinngga nga neyi. Ngangga nga, ngu nenengo sidudarone. Nga sidudaronengga, ngando Anutdo sunggi mande keta ewoku, ngu gosiyoote. Ngu no oni simoo bare oowooyingga ngu, enengo weti mbumbuwaye andangewero ingoro, nenengo sidudarone enengo wendowano. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nguro ngu, no yeno hamoo oorengo eteno. No nga Wayinngga nga ko ma newano. Kootuyisina, Anutdo endega nguno enengo oni simoo bare soboyerooteku, ngu sambo endegano nguno, no Wayin sonoyi keta yeya, ko newato. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ngundiro tero ngu, asa, ene Anutro bingami okooro, yambo gura utoro yokoro, kootuyisina ootoogero, puringga oowooyi Olib, nguno ooreyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ngu naruno nguno, Yisasdo kirikiri onikuya eyingo. Nga suwoongga ngano, yengo nowoondoyemo hamoo teyingo ngu, nono yomburiyowanggo. Yo, hamoo, ye bidodo noyokoro sawanggo. Kurimi, Anutro mandeno ngu ngandiro nakangoro eyingo. No Sipsip Simburi utoowe, nguro Sipsip sosorero, mera bidodomo songo songo sawanggo. Ngundiro nakangoro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ene no merenonggo ko ootoogewanokuno, nguno no ye koreteyunoro, Galili merako oorowuwano. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ene ngundiro etoni, asa, Pita Yisasya mande yanggango gumi eyingo. Oni bidodo ngu ge goyokoro, satoyi ngu, ene nondo ngu ge ma goyokoro toongewano. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yisasdo enengo mandeni ngu ingoro, enebana gumi eyingo. No geno hamoo eteno. Nga suwoonggano ngano, kootoori ma eyingomo ngu, ge tambu kabusa no oowoone oongoowa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ngundiro etoni ngu, Pitando Yisasya mande yanggango gumi eyingo. No mete geya kumoowaroku ngu, no ge oowoongge ma oongoowanoku ngu! Hamoo oorengo, kini! Etoni, kirikiri oni bidodo mande guranangge ngundiro nangge eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ngu naruno nguno, ene oororo, musiyo gura oowooyi Gesemani, nguno oorowuyingo. Nguno Yisasdo enengo kirikiri onikuno eyingo. Ye ngano bibiteya oriyi. Oodoyiga, no oororo, anduno Anutno yemboongewero. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Yisasdo kirikiri oni kabusa yoyoro, eneya oorowuyingo. Ngu kirikiri oniku ngu, Pita ko Sebedi simoongo eraya, ngundo oorowuyingo. Nguno ngu, Yisas damoni yero, newende kowuri urungga oorengo ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ngundiro ingoro, ene kirikiri oni kabusagakuno eyingo. No gabone kowuri urungga oorengo yero, ngundiro tero, namoko yomburinerowa. Ngundiro nguro, ye ngano ootooya, ye komo ingondare meyeya soboneroyi, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Yisas ngundiro ero, ene bodaga songo oororo, merako bagootero wereyingo. Ngundiro tero, Anutno yemboongero eyingo. Oo Awane, nga toba kowuri ogingo urungga nga, ngu mete gedo andange. Ene ge noro ingondudune ma keyowero. Kini, no gengo ingonduduge ngu nangge keyowano, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ngundiro yemboongero yokoro ngu, ene ootoogero, kirikiri oni kabusagakuno oororo, yeyootoni, wetorootoyi, yeyoro, Pitaya eyingo. Ndawugaro, ye kabusaga naru bodagano, no ma sobonerowonggo? ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ye gome sobowooya, yemboongeya, ngundiro tetoyi ngu, Setando towooyerootoni ngu, ye yanggango oruwanggo. Hamoo, ye nowoondoyebo ngu tewero ingootoni, ene goweyebo ngu sureyekiniyero yanggango ma yete, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ngundiro ero, ene tambu eraya ko oororo, Anutno kira ero eyingo. Oo Awane, ge nga tobagano ngano sono neni, ero ingoro, ma yoro yokowaku ngu, arisa, no bidodo nemukoro, gengo ingooteku, ngu nangge keyowano, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ene ngundiro yemboongero ero yokoro, ene kirikiri onino ko oororo, yeyootoni, ene kubooyerootoni, ene wetororiyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ngundiro yeyoro, ene yoyokoro, ko oororo, tambu kabusa koretero yemboongewoku, ngu ngundiro nangge, ko yemboongeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Yemboongero yokoro ngu, enengo kirikiri onino ko omburo eyingo. Ye komo kengero, wetoro, oorootenggo, bine? Ye ingoyi! Ataga, no Anutro Nangoni Oni Kirarongo mundi oni, ngundo noyoro, mbumbuwadodo me oni kandeyemo noyewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Arisa, ye ootoogetoyiga oorowuwooto. Kenoyi! Me oni no yootunoneroro, oni sanggiri kandeyemo noyeweroyi oninggaku ngu, ombuteku andu! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yisasdo mande ewootoni, Yudas Yisasro kirikiri oni kande eraya kegidemboro erayaga, (12) nguromu gura me oni oowooyinggadodo yowuruwooro ombuyingo. Yo, me oni oowooyingga nguya duge, mata komuko ebe ureweroyi oo ngu yootoyi, Anutro wooro yeyingo oni kundingiyi nguro sobosobo oniku, ko, Yuda oniro tabango oni, ngundo sureyerootoyi ombuwonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Windogayi oni Yudas, ngundo kuri sunggi gura yunoro eyingo. Nondo ngu oningga kandeyi dowooro, yenggonangoro, dureyootoowega ngu, ngu oningga ngu Yisas. Ngu dowooya, yoya oorowuyi. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Asa, Yudas sodedomangge Yisasno oororo eyingo. Oo etuyeroyingo oni, suwoo gome ero, ene kandeyi dowooro yenggonangoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ene ngundiro tetoni, asa, Yisasdo mande gumi eyingo. Doboone, ooga tewero ingoro, ombuteku ngu, asa, sodedomangge te! Ero eyingo. Ngundiro etoni ngu, me onikundo Yisasno kandeye oorongooro dowooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ngundiro tetoyi ngu, asa, Yisasro kirikiri oni gurado kewooroyemonggo sanggiri tero, enengo duge sobiyoro, yoro, ngundo Anutro wooro yeyingo oni kundingiyi nguro sobosobo oni koreteyingo, nguro kirikiri oninggaku doongooro urewero teyingo. Nguro ene duge oorongootoni, woosooro oorowutoni, sodeyi nangge takatoni soreyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yisas ngundiro kenoro ngu, enengo kirikiri oningga nguno eyingo. Gengo duge ngu ko musiyomo ye. Oni bidodo dugebo oni ureyi kumoowanggoku ngu, ene nguya dugebo yureyi kumoowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ge komo gome ingo! No mete Awanemo meno etoowe, enengo sambo endemo oni oowooyingga oorengo soweyerootoni, omburo, hooroowenerowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ene no ngundiro tewanoku ngu, oo bidodo Anutdo kuri ero nakangoyingo, ngu engge nenengo ma tunootewa. Ngundiro nguro, ene komo oo ewoku, ngundiro nangge, tunootewa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ngu naruno, Yisasdo me onikuno eyingo. Ye ndawugaro duge, mata komuko ebe ureweroyi oo ngu dowooro, omburo, no yakaka oni ngundiro nodowootenggo? Naru oowooyingga, no yeya Yuda oniro yowuru ya Tembelno ootooro, mande yunororuwonoku, ene ye nguno ma nodowoowonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ene ataga oo tunooteteku nga, kuri Anutro ingondudu eyingo onindo nakangoyingo, ngu ataga engge tunootete. Etoni, ngu naruno, enengo kirikiri oniku sosorero, nguro ene Yisas yokoro, sodedomangge samukoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Onikundo Yisas yoro, Anutro wooro yeyingo oni kundingiyi, nguro sobosobo koreteyingo oowooyi Kayiyapasro yano oorowuyingo. Mosesro mamana mande etuyeroyingo oniku, ko, Yuda oniro tabango oni bidodo mayero, yowuruwooro oruwonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ene Pitando Yisas keyoro, oororo, ene boda orirokoyi oriyingo. Pitando ememonggo torige penggopenggootero, kundingi oniro tabango urungga, ngundo yasiriko uyingo. Ngu yangga nguro kumba ootuwoo onindo de katoyi, Pita ngu yokowero nombono omburo, de yokoro, ngunonggo Yisasno ndadiro tewanggoku, nguro ingoweroyimboro bibiteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Anutno wooro yeyingo oni kundingiyi nguro sobosobo oniku, ko, yowururo oni tabango bidodo, ngundo Yisasro mande godange goweyi sanggaweroyi oninggaku ereweyingo. Ndadiro nguro, ene ureyi kumooweroyimboro oore ereweyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Nguno ngu, oni oowooyingga tunootero, ngundo mande godange oowooyingga Yisasno sanggawero eyingo. Ene mande nenengo gura ero, ngu keyoro, nguno ureweroyi ngu ma kenoyingo. Ngundiro tetoyi, kootuyisina, oni eraya tunootero, omburo, ngandiro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Nga oningga ngando ngandiro ewo. Yudaro yowuru ya, Tembel, ngu nondo mete toongooro, naru kabusagomo, ko yewano, ewo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Anutro wooro yeyingo oni kundingiyi nguro sobosobo koreteyingongga, ngundo enengo mande ingoro, kewooroyemonggo ngu ootoogero, dikaro, Yisas sumoo inoro eyingo. Ge mande nga gumi ma ewa? Nga mandega nga mande wirikoyingo oni doongeyemo, ge bungomo etenggo. Ge mande moore, ngundi kini bine? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yisasdo enengo mande ngundiro ingoro ngu, nenetero, mande gumi ma eyingo. Nguro kundingiyi oniro tabangokundo, Yisas ko sumoo inoro eyingo. Anut keta oorooteku, ngu oowooyimonggo mande hamoo awuno oorengo sorumimonggo, nooreno etooga ingowato. Ge Krayis, Anutdo noore yoyoweroyimboro sunggi yeyingo oni, ko, Anutro Nangoni hamoo, bine? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Asa, Yisasdo enengo mandeni ngu ingoro, enebana gumi eyingo. Gedo kuri ewoku, nguro no yeno eteno. Ataga ko kootuyisina nguya, ye no Anutro Nangoni Oni Kirarongo neyootoyi, no Anut yanggangonidodo ngu kandeyi koondosina bingamidodo bibitewano. Eme no sambono goboore ngu sanganimo omburo oodoowe, neyowanggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","66","Yisasdo ngundiro etoni ngu, asa, kundingiyi oniro tabangonggakundo enengo nengguro dowooro, omboongero, sanggiri oorengo tero eyingo. Ene Anut kootuyisina yomooyinoro mande eteku nga! Noore oni gidaregano meno etooye omburo, ngundo mande gura ma ewanggo. Kini, enengombo mande eteku nga, noorengombo nenengo enengo mandeni ingooteto. Ene Anut kootuyisina yomooyinoro mande ete. Nguro ngu, ye enengo mande ingootenggoku ngu, ye ndadiro ingootenggo? Ngundiro sumoo etoni, enendo gumi eyingo. Yisasdo Anut yomooyinoro mande biyomi kootuyisina eteku, nguro ene komo ureyiga kumooni, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","68","Arisa, oni gidaregado Yisas ene doongeyi dobengoro, omukumundoongomo mukendongoro, nguno utoro eyingo. Ge Krayis, gengo ingondudunonggo ngu yootunoya e. Onendo guroote? Ero yomooyinoro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita ngu enderoko ya gosingomo nguno bibitero oodoni, kundingiyi oniro tabango urungga, nguro kirikiri bare gura tanggeyimo omburo eyingo. Ge nguya Yisas Galili mera oningga, ge nguya oruwori, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Kirikiri baregakundo ngundiro etoni, asa, Pitando oni oowooyingga doongeyemo, no ngu oningga ngu, no watayi kini. No gedo mandega eteku ngu, no watayi kini. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ngundiro ero yokoro, Pita endesina sisipawa nguro yamuko dabemimo ooretoni, bare gurado kenoro, oni namoko dikayingokuno eyingo. Nga oningga nga nguya, Yisas Nasaret oningga nguya oruwori, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ene ngundiro etoni, asa, Pita Yisas oowooyi ko oongooro eyingo. Hamoo oorengo, sorumimonggo, no nga oningga nga no watayi kini! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Asa, ene bodaga oode, oni namokono oruwonggokundo Pitaya ko eyingo. Hamoo oorengo, ge Yisasro oni gura. Gengo mande eteku, ngu Yisasro mande bungeyi ngundiro. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ene ngundiro etoyi, arisa, Pita manggaru tero eyingo. No yeno etenoku, no nenengo ma ewanoku ngu, asa, Anutdo nguro ogingo gumi nunowa. Arisa, no hamoo oorengo, sorumimonggo awuno etenoku ngu! Ngu oningga yendo etenggoku ngu, no ma ingooteno! Ero eyingo. Ngundiro etoni, sodedomangge, kootoori eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pitando kootoori etoni, ingoro, arisa, kuri Yisasdo mandega eneya eyingo, ngu ingondudu urungga teyingo. Kootoori ma eyingonggakuno ngu, ge no oowoone tambu kabusa oongoonerowa, eyingo. Pita ngu ingoro, nguro ene oruwoku musiyo ngu yokoro, sendoro biyobiyomi oorengo teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Sengetoni ootoogero, Anutro wooro yeyingo oni nguro sobosobo oniku, ko, Iserel oniro tabango oniku, ngundo yowuruno mande guranangge gosiyoro, eweroyimboro yowuruwooyingo. Nguro ene Yisas ureyi kumooweroyimboro mande gosiyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Mande ngundiro gosiyoro ngu, asa, Yisas utombo (sen) gosiyoro, yoro, oororo, Rom Gabuman oni, Yuda mera nguro oo sobosobo oni urungga, oowooyi Payilat, ngu kandeyimo yeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ngu naruno, Yudas oningga, ngundo Yisas damoni tero, mundi oni kandeyemo yunoyingo oningga, ngundo Yisas ureyi kumoowero mande gosiyootoyi, ngu kenoro, ingoro, nguro ene muri biyomi tewoku, nguro nowoondoyi tero, Anutro wooro yeyingo oni kundingiyi nguro sobosobo oniku, ko, Iserel oniro tabango onikuno oororo, digi beye doobe kabusa (30 Kina) ko yunowero teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Yudasdo mande ngandiro onikuno eyingo. Nondo weti mbumbuwa tero, Yisas ye kandeyemo yewono. Ene oo biyomi gura ma teyingomu, ngu nondo damoni tewonoku, nguro ene kumoowa. No mbumbuwa urungga oorengo tewono, ero eyingo. Enengo mandeni ngundiro ingoro ngu, enebana mande gumi eyingo. Ngu gengombo tewokuro, ngu gengomu nangge! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yudas nguro mande ingoro, nguro ene newende kowuri urungga oorengo ingoro, digi beyeku yoro, Tembelro yawasa sanganimo oorongooni uwo. Ngundiro tero, ene oororo, utono bungeboro tero kumooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Asa, ngu naruno nguno, Anutro wooro yeyingo oni nguro sobosobo oniku, ngundo ngu, digi beyeku yoro eyingo. Nga digi beyega ngando, ngu oni ureyi kumooweroyi nguro uriyi. Ngundiro nguro, nga digi beye biyomingga nga, Tembelro digi beye nguno ma yowuruwooro yewato, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Nguro ene mera gumisina nguno, mera kumbe gome nguno ooroote. Nguno ngu, Anutro wooro yeyingo oni nguro sobosobo oniku, ngundo mande gosiyoro, mera kumbe teweroyi simburigaku digi beye inoro, ngu mera kumbe musiyonggaku uriyoyingo. Ngu mera gumi uriyowonggoku, ngu oni sowe gidarega Yuda oni kini orirokonggo mayeyingo, ngu kumootoyi, nguno mereyeroweroyimboro, nguro musiyo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ngundiro tero, ngu mera guminggaku ngu oowooyi, siduro mera, eyingo. Ngu oowooyinggaku, ataga ngundiro ooroote. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ngundiro tetoyi ngu, kuri Anutro ingondudu eyingo oni, oowooyi Yeremayiyando mandega eyingomu, ataga engge tunootete. Ene ngandiro eyingo. Ene ngu digi beye onibiga kande eraya ngu yoro, Iserel onindo ngu uriyowero, ngundiro rogo teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ngundiro tetoni, ngu digi beyekundo mera kumbe teweroyi simburigaku inoro, enengo mera uriyoyingo. Oo Simburi Urunggado nono mande eyingomu ngundiro. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ngu naruno nguno, oni ngu Yisas yoro, omburo, Gabuman oni koreteyingo urungga doongeyimo yeyi dikayingo. Payilat ngundo Yisas sumoo inoro eyingo. Ge Yuda mera oni simoo bare ngaro oni sobosobo koreteyingo urungga, bine? Ero eyingo. Ngundiro sumoo etoni, Yisasdo mande gumi ngandiro eyingo. Yo, gedo eteku ngundiro. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Anutro wooro yeyingo oni nguro sobosobo oniku, ko, Iserel oniro tabango oniku, ngundo kingo mande godange Yisas goweyi sanggawero etoyi, ene mande gumi gura ma eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ngu naruno nguno, Payilatdo ko Yisas sumoo inoyingo. Ge gowegemo mande gura gura geno sanggawero etenggoku nga, ge ma ingoote? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ene ngundiro sumoo etoni, ene Yisasdo mande ngu Payilatno gumi gura ma eyingo. Ngundiro nguro, Gabuman oni mera sobosobo oni urungga, ngundo ingondudu urungga teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Dagoma bidodomo, naru kundingiyi oowooyi Pasowa, ngu naruno, mera sobosobo oni urungga nguro muriye ngu ngandiro. Ya biyomimo oni guranangge andangetoyi toongewa. Ngundiro nguro, oni simoo bare enengombo oni guraro etoyi ngu, arisa, Payilatdo ngu oningga ngu nangge andangetoni toongewa. Payilatdo ngu muringga ngu tero, nguno Yuda oni simoo bare oni oni teyunoweroyimboro teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ngu naruno, ene oni biyomi gura moore, ngu ya biyomimo oruwoku, ngu oowooyi Yisas Barabas. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Arisa, oni simoo bare mayero, yowuruwootoyi, Payilatdo sumoo yunoro eyingo. Yendo ngu, nondo ndawu oningga yokootoowega, toongeni, ero ingootenggo? Yisas Barabas andangetoowega toongeni; ngundi, Yisas Krayis etenggokungga, ngu Anutdo ye yoyowero sunggi yeyingo oningga, ngu andangewe, bine? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ene ngundiro sumoo ero, ndadiro nguro, ene kuri ingowoku, ngu Yuda yowuru yaro sobosobo oni ururuku, Yisasdo oo tewoku, nguro nowoondoyemo boguwooro, ingoro, nguro ene mundi oni kandeyemo yero, ureyi kumoowero teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Payilatdo ngundiro ingoro, nguro ene bibitero, Yisasno mande sanggawero etoyi, ngu wirikoro oodoni ngu, ngu naruno, enengo bareyibo mande yanggango soweyoro eyingo. Ge ngu oni nenengonggano, nguno oo gura ma tewero. Ndadiro nguro, suwoono, no gabono ene kenoro, nguro nowoondone kowuri urungga oorengo ingowono, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ene Anutro wooro yeyingo oni nguro sobosobo oniku, ko, Iserel oniro tabango oniku, ngundo oni simoo bare sureyeroro, Payilatno etoyiga, Barabas andangeya, yunoya, Yisas ureyiga kumooni, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Arisa, Payilat ngundo ko sumoo yunoro eyingo. Nga oni erayaga nga, yendo ngu ndawu oningga andangeya yokowe, ero ingootenggo? Ene ngundiro etoni ngu, asa, Barabas andangeya yoko, ero mande gumi eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Payilatdo enengo mandeye ngu ingoro, enebana gumi ngandiro eyingo. Ngundiro nguro, nondo Yisas Krayis etenggokungga, ngu ndadiro teyinowano? Ero eyingo. Ngundiro etoni, oni simoo bare bidodo manggaru urungga tero eyingo. De omukondino boorowooyi! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ene ngundiro meno etoyi ngu, asa, Payilatdo mande gumi eyingo. Ndawugaro? Ene ndawu oo biyomingga tewo? Etoni, ene oni simoo bare bidodo ko manggaru urungga tero eyingo. De omukondino boorowooyi! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ngundiro meno etoyi ngu, asa, ngu naruno nguno, Payilat ngu enengo ingonduduye ngu ene ingooteku, ene damoni yero, ebe urungga yeyi, tunooteweroyi tetoyi, nguro enengo mandeni nguya ma ingoyingo. Ngundiro nguro, ene ngandiro eyingo. Nga oningga nga, ene oo biyomi gura ma teyingo, nguro no ene ureyiga kumooni, ero, ma rogo teteno. Nguro ngu, no ngu ooga nguro kandene sonowooro, andangero, yengo kandeyemo yetenoku ngu! Ataga ngu yengomu nangge. Ero eyingo. Ngundiro ero, ene sono yoro, oni simoo bare doongeyemo kandeyi sonowooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ngundiro tetoni, oni simoo bare bidodo mande gumi eyingo. Nga kowuringga mete ombutoni, noorengombo simoonanidodo koorowoowato. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ngundiro nguro, Payilatdo ngu nangge ingoro, nguro ene Barabas andangero yunoyingo. Ene Yisas turimbo gisasaruboro yoro, me oni kandeyemo yunootoni ngu, ngundo de omukondi sanganimo sanggaweyi, ero yunoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Arisa, Payilatro me oni bidodo Yisas yoro, Rom Gabumanro yano uro, nguno Yisas yomooyinoro, utoro, yomburiyowero mayero yowuruwooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Me onindo Yisasro nengguroni ngu andangero yokoro, enendo nengguro dagoyiga yoro teyinoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ene uto sanggiridodomu ngu yoro, ngundo Yisasro tomuku teyinoyingomu, ngu yoro, enengo tabangomo kutuwooyinoyingo. Ngundiro tero, kumuku wimbuyiga yoro, kandeyi koondosina yeyingo. Ngu kumuku wimbuyiga ngu mera oo sobosobo koreteyingo yanggangoni, nguro sunggiyi, ero, nguro ene kandeyimo yetoyi dowooyingo. Ene ngundiro tero, Yisas tanggeyimo boodooye oondoogero, yomooyinoro mande urungga ero eyingo. Ge mayeteku nga! Ge Yuda oniro oo bidodo sobowooyingo oni koreteyingo urunggaku ge! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ngundiro ero, mukendongoro, ngu kumuku wimbuyigaku kandeyimonggo sobiyoro yoro, ngundo tabangomo oorongooro ureyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Me onindo Yisas yomooyinoro yokoro ngu, arisa, enengo nengguro dagoyigaku andangero yokoro, Yisas enengo nenggurogaku yoro, ko teyinoyingo. Ngundiro tero, Yisas yoro, de omukondino yureweroyi musiyomo, nguno oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ngu naruno nguno, me oniku oorekanare oorowutoyi, oni gura oowooyi Sayimon ngu endeni oowooyi Sayirin, ngu ombutoni kenoyingo. Kenoro, ngu me onikundo nguno dowooro, woosooro, sureyootoyi, oororo, Yisasdo de omukondigaku ngu inootoyi koorowooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ene ngundiro koorowootoni, yade oororo, mera musiyo gura, oowooyi Golugata, nguno tunooteyingo. Golugata oowooyingga nguro muri ngu ngandiro: tabaye wimbuyi musiyo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Nguno ngu, ene sono kowoododo Wayindodo yowuruwooyingomu Yisas inootoyi, ene ngu sono kowoonggaku nero towoongootoni, ngu yokoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ngundiro tero ngu, ene Yisas de omukondino dowooro, sanggawero, enengo nengguroni yoro, ebe pawapawamu tero, yoweroyimboro koondoongetero, oni gurado dagayeroro ngu, asa, ngundo yoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ene ngundiro tero, ngu mera musiyonggakuno bibitero sobowooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Yisas tabango sanganimo de omukondi sosowoomo wirikoyeroyingo oni, ngundo mande ewoku, ngu so uyi gurano ngandiro nakangoyingo. Nga Oningga Nga Ngu, Yisas. Ene Yuda Oniro Sobosobo Oni Koreteyingo Urungga Oorengo. Ngundiro nakangoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ngu musiyomo nguno, oni biyomi eraya Yisas tanggeyi gide gide booroyeroyingo. Gura kandeyi koondosina, gura kandeyi biyomisina booroyeroyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","40","Oni simoo bare mayero, kenoro, yomooyinoro mande ero, tabadori tero, kandesisi tero, kenoro eyingo. Ehe! Ge nga oningga ngando yowuru ya tootoongoro yokoro, naru kabusagomo ko yewero ewo. Ge ngu tewero ngu, arisa, ge mete de omukondi ngu yokowa. Yo, ge Anutro Nangoni tetoningga ngu, asa, ge de omukondi yokoya, merako ombu! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","42","Ene ngundiro etoyi, Anutro wooro yeyingo oni nguro sobosobo oniku, mamana mandero ingondudu oni, ko, Iserel oniro tabango oniku, ngundo yomooyinoro mande ero, yomooro eyingo. Ene oni gidarega yomosiyeroro, ene enengombo enengo ma hoorooweyingo. Arisa, ge Iserel oniro sobosobo koreteyingo urungga tetoningga ngu, asa, ge komo de omukondi yokoya, merako ombutooga, noore geyoro ngu, asa, noore nowoondonanimo hamoo tewa! ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Yo, nga oningga nga, ene Anutno newende hamoo tero ero, No Anutro Nangoni erorooteku ngu. Arisa, Anutdo gengo gome ingoya ngu, ene mete anangu hooroowenggeroni. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ene ngundiro nangge, yakaka oni erayaga Yisas tanggeyimo de omukondino booroyeroyingo erayagaku nguya, Yisas yomooyinoro mande eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Sa kewooro samboro oorengo nguno, mera bidodo suwoo ooreri tero, oororo, sa nemimo utoni 3:00 Klok, ngu kiniteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ngu naruno, Yisasdo meno yanggango urungga ero eyingo. Eloyi, Eloyi Lama Sabakatani? Eyingo. Nga mandega nga, ngu muri ngandiro. Noro Anut, noro Anut, ge ndatero noyokowo? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ene ngundiro meno etoni, oni simoo bare gidarega nguno oruwonggokundo, ngu ingoro eyingo. Nga oningga ngando ngu, ene Ilayiya negongoote. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ngundiro etoyi, sodedomangge kewooroyemo gurado kendutero, oororo, sono kowoo oowooyi Winiga ngu towi sosowo nguno yero, de sanggano gosiyoro, yeyi Yisas manggowoomo neni, ero inoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ene oni gidaregado eyingo. Sobowooro oode, kenowato! Ilayiyando omburo hooroowewa, ngundi kini bine? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ngu naruno nguno, Yisas ki yanggango urungga ko ero, enengo gaboyi yokoro, oorowutoni kumooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ngu naruno nangge, Yuda oniro Tembel yowuru yano towi urunggaku awu wengamonggo kewoorokuri pitiro, oosowooro, omburo, wenga merako nggorongero eraya tunooteyingo. Ngu naruno nguya imimi yoro, digi ururu udookeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ngundiro tetoni ngu, oni mereyeroyingo musiyonggaku goosootoni, Anutro oni simoo bare oowooyingga kuri kumooyingoku, ko ootoogeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ene oni merengooweroyi musiyo yokoro oodoyi, kootu Yisas ko ootoogero, Yerusalem ende kundingiyi nguno oorowuyingo. Oorowutoyi, oni oowooyingga ngu yeyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Me oni ko enengo tabango, ngu Yisas sobowooro oodoyi, mera imimi yootoni, oo bidodo tunootetoni ngu kenoro, nguro ene sosoreyingo urungga tero eyingo. Hamoo oorengo, nga oningga nga, ngu Anutro Nangoni nga! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ngu bare gidarega nguya ngu orirokoyi dikaro, ngunonggo Yisas kenondadangero oruwonggo. Ngu bare ngu, ene kuri Yisas Galili merako oriyingo, ene ngu Yisas keyoro, oororo hoorooweyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ngu bare kabusaga ngu kewooroyemo, ngu Mariya Magadala; Mariya Yemus Yosep eraga namoyari; ko, Sebedi simoongo erayaga ngu namoyari nguya oruwonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Suwootetoni, Yosep Arimatiya merakonggo oningga ngu, ene digi beyenidodomu ngu mayeyingo. Ene nguya Yisasro kirikiri oni gura. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ene yanggango tero, Payilatno oororo, Yisas bingonggaku yoweroyimboro sumoo eyingo. Arisa, Payilatdo me onino etoni, Yisas bingonggaku Yosep yokoyinoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Arisa, Yosepdo Yisas bingonggaku ngu yoro, kumba sarayinggado doobengoro, mbimboongoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ene ngundiro tero, yoro oororo, oni merengooweroyi musiyo gura keta teyingomu, nguno yeyingo. Ngu merengga ngu, digi woondokoyi newendemo teyingo. Mere manggowo ngu digi urungga gura wenggeremooro, ngundo ukingoyingo. Ene ngundiro tero ngu, asa, ene yokoro toongeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mariya Magadala, ko, Mariya gura, ngu bare erayagaku ene nguno mere tanggeyimo bibitero, ootooro, ngunonggo doongetero, Yisas ndadiro tero merengootenggoku, ngu kenowero oruwori. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","63","Naru wengamo, oo yomosiyoweroyi Yudaro kando naru, oowooyi Sabat kinitetoni, Anutro wooro yeyingo oni nguro sobosobo oniku, ko Parisi oniku ngu Payilatno mayero, yowuruwooro eyingo. Oni urungga, noorendo mande gura ngano godange oni ngundo kuri keta oruwokuno, mande eyingoku, ngu ingooteto. Ene ngandiro eyingo. Kootuyisina, sa kabusa yokoro, no ko ootoogewano, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ngundiro nguro, ge etooga, oni ooroya, ngu merengga ngu, sa kabusaga nguno gome sobowooyi. Yokootoyi ngu, enengo kirikiri onindo omburo, yakakayi yoro, saro, oni simoo bareno ewanggo. Ene ko merenonggo ootoogetoni, etoyi, kootu godangengga tewanggoku, ngundo koretero godangengga ewonggoku, ngu dagawa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ngundiro etoyi ngu, Payilatdo eneya mande gumi eyingo. Arisa, ye sobosobo oni gidarega yoyoya, oorowutoyiga, ngundo merengga ngu yanggango gosiyoya sobowooyi. Yengombo ngundiya teyi, eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ngundiro nguro, ene oororo, digi woondokoyi merenggaku, ngu sunggi gura roogo teweroyimboro ngu yetoni, me oni yoyetoni, ngundo ngu merenggaku sobowooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Yudaro kando naru, oowooyi Sabat kinitetoni, sengetoni suwoononggo, kowooyingo nguro naru koreteyingo, ngu Sande naruno, Mariya Magadala, ko, Mariya gura nguya yade oororo, Yisas merengooyingo merenggaku kenowero oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Asa, imimi urungga oorengo yootoni ngu, ngu naruno nangge, Anutro sambono Engel oninggado sambononggo omburo, Yisas merengooyingo musiyomo oororo, digi urungga mere manggowo ukingoyingonggaku ngu andangetoyi, ukero, utoni, ngu sanganimo bibiteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Enengo omukumundoongo soru yowari ngundiro tunootero, enengo nengguroni nguya sarayi oorengo tunooteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Me oni, Yisas merengooyingo mere ngu sobowooro oodoyi, oo ngundiro kenoro ngu, ene sosorero, mboorombooro tero, gaboye kumookumooteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ene Anutro sambono Engel oningga, ngundo bare erayagakuya eyingo. Yari ma sosorewero! No kuri ingooteno. Yari Yisas de omukondino boorowooyingo oningga, ngu erewero ombuteri. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ene ngano kini. Ene kuri enengombo eyingo ngundiro, ataga ene keta ootoogete. Yari ombuya, mereno yewonggoku musiyongga ngu kenori. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Yari enengo musiyongga kenoya, sodedomangge ooroya, enengo kirikiri onikuno ngandiya eri. Ene kuri mere yokoro ootoogero, ye koreteyunoro Galili merako oorowute, eya eri. Ye ngu mera gumisina nguno kenowanggo. Ingoyi, no ataga yeno etenoku ngu! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ene mande ngundiro etoni, asa, bare erayagaku mande ingoro ngu, ene sosorero, oni oni urungga nguya tero, nguro ene sodedomangge mere yokoro, kirikiri onikuno sobiyoro, ngu mande ngu ewero oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ene sobiyoro, yade oorowutori ngu, Yisas oorekono tunootero, eneno eyingo. Yari mayeteriku ngu. Etoni, bare erayakundo enengo mande ingoro, oororo, Yisas keyi damonimo bagootero, nguno yambo mande teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ngundiro tetori ngu, Yisasdo eneya eyingo. Yari ma sosorewero. Yari ooroya, noro kirikiri oni dobookurine oorengo nguno ngandiya etoriga, ene Galili ooroya, nguno neyoyi. Yari ngundiya eri. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Bare erayagaku oorekono oorowutori, me oniku Yisas merengooyingo musiyongga sobowooyingoku, ene endemo uro, Anutro wooro yeyingo oni kundingiyi nguro sobosobo onikuno oororo, oo tunootemukowoku, nguro ewonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","13","Nguro ngu, Anutro wooro yeyingo oni kundingiyi nguro sobosobo onikundo, ko Iserel oniro tabango onikuya yowuruwooro, ngu oo tunootewonggoku, nguro ndadiro tewato, ero, mande gosiyoyingo. Nguro ene me oniku digi beye oowooyingga kingo yunoro eyingo. Arisa, ye saya, oni simoo bareno nga mande ngandiya eyi. Suwoono weteroodoore ngu, kirikiri onindo ngu torige omburo, Yisasro bingo yakakayi yoro sawonggo. Ngundiya ewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Nguro ngu, yengo Gabuman sobosobo oni tabangongga, ngundo nga mandega yendo etoyi, ingootoni ngu, arisa, ye nowoondoye kowuri ma ingowero. Ndadiro nguro, no yengo sobosobo oninggano oororo, mande inowano. Inootoowe, ene ye kowuri ma yunowa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ngundiro etoni ngu, asa, me onindo digi beye yoro, oo ngundiro ewonggoku, ngundiro teyingo. Ngu mandegaku, ene Yuda oni simoo bare bidodo etoyi, ingoyingomu, ataga nguya, ngu mandegaku ero ingororootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Arisa, enengo kirikiri oni kande eraya kegidemboro guranangge, Galili merako oororo, puringga Yisasdo kuri eyingomu, nguno ooreyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ene nguno, Yisas kenoro, kirikiri oni bidodo bagootero, eneno yemboongetoyi, ene gidarega ingonduduye buribari ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Arisa, Yisas tanggeyemo omburo, mande wesiyoro eyingo. Anutdo kuri sambo mera ngaro nguya, yanggango bidodo nunoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ngundiro nguro, ye ooroya, oni simoo bare bidodo, Anutro Mande Keta Mesarango yunoya, yoyeyiga, noro kirikiri oni tunooteyi. Ene nowoondoyemo hamoo tetoyiga ngu, arisa, ye sono kundingiyi newendemo utoyiga, ngu Awa, Nangoni, ko, Yuka Kundingiyi oowooyemo sonoyeroyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ngundiya teya, noro mande bidodo etuyerowonoku, ngu bidodo yebanangge oo ngundiro eneno etuyerowanggo. Ye ma kabetewero. Ingoyi, no suwooyi sano yeya oode, oororo, naru wenga kinitetoni, nguno nguya, no yeya oruwato. Ero eyingo. Ngu hamoo.");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Nga mandega nga, ngu Yisas Krayis Anutro Nangoni, nguro Mande Keta Mesarango. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Anutro ingondudu eyingo oni Ayisaya, ngundo kuri Sonoyeroyingo oni Yon, ko, Yisasro nguya nakangoro, ngandiro eyingo. Ingoyi. Nondo noro ko oni ge koretenggu noro soweyowano. Enendo ngu gengo oore yomosiyonggunowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Kootuyisina, ngu oningga, ngundo oni kini merako, nguno omburo meno ewa. Oo Bidodo Simburi, nguro ooreni ngu yomosiyoyinowa! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Nguro ngu, Yon Sonoyeroyingo oni, ene oni kini kingo merako nguno omburo, oni simoo bareno mande wesiyoro ero eyingo. Ye komo nowoondoye hamoo yowoorengoya, sono kundingiyi gimuyi. Ngundiro tetoyi ngu, asa, Anutdo yengo weti mbumbuwa andangero kabeteyunowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ene mande ngundiro wesiyoro etoni, nguro Yudiya mera, nguro simoo bare bidodo, Yerusalem endemo simoo bare bidodo, ene Yonno oorowuyingo. Ene nguno oororo, enengo weti mbumbuwaye Yonno wesiyoro etoyi, nguro Yondo Yodan sonono yoyoro uro, sonoyeroyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yonro nengguro pirungga, ngu Hos gura oowooyi Kamel, ngu uyimbo nengguroyi ngu teyingo. Ene Kamel goweyi, ngundo utoyi tero, wanggangomo nguya gosiyoyingo. Enengo oowari ngu diguno katu, siso, ngu nero oruwo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ene mande ngandiro wesiyoro eyingo. Kootuyisina, oni gura no keneroro ombuwa. Ene ngu oningga, ngu yanggangoni ngu urungga oorengo. Yo, hamoo, ngu oningga nguro yanggangoni, ngundo noro yanggangone ngu dagate. No ene newendemo ootooro, enengo kirikiri oni nangge oorooteno. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","No ye sonombo sonoyerooteno. Ene ngu oningga, ngundo ngu Anutro Yuka Kundingiyimbo sonoyerowa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ngu narungga nguno, Yisas ene Nasaret ende Galili merakonggo mayeyingo. Mayetoni, Yondo Yisas yoro, Yodan sonongga nguno uro sonowooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ene ngundiro sonowootoni, Yisas sono yokoro, sagigo ooretoni ngu, asa, sodedomangge sambo goosootoni, nguwoore Yuka Kundingiyi sambononggo nu mumukondiri ngundiro tero, Yisasno ombuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ngu naruno nangge, Anutdo sambononggo Yisasya ngandiro meno ewo. Ge nenengo nangone. No gengo gome ingooteno. Nowoondone gengo gome oorengo ingooteno. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ngu naruno sodedomangge, Anutro Yuka Kundingiyimbo Yisas soweyootoni, oni kini kingo merako toongeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Toongero, ene oni kini kingo merako nguno, sa naru onibi eraya ene nusako koki kewooroyemo oriyingo. Nguno oodoni, ene sambono Engel oni garodo omburo, Yisas hoorooweyingo. Ngu naruno nguno, Setando Yisas towoongoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Me onindo Yon dowooro, ya biyomimo yetoyi oodoni, ngu naruno, Yisas Galili merako oororo, nguno Anutro Mande Keta Mesarango simoo bareno wesiyoro, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ataga narunggaku tunootete. Anut Oo Bidodo Simburi Simbunani, ngundo naru enengo oni simoo bare soboyerooteku, ngu kuri namoko ombute. Ngundiro nguro, ye mande gome ngaro nowoondoye yowoorengoya, Mande Keta Mesarango nga ingoya, nowoondoyemo hamoo teni! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ngu naruno, Yisas ene Galili sono koongeyingo dabemiwoore oorowuyingo. Oororo, ene Sayimon koneyo Enduru nguya yeyoyingo. Ngu erabasa erayaga ngu ene isoro si sono koongeyingomo oorongooro, ngu koyi teworiyo. Ene ngu ko ngu tero, iso uriyoro beye yoro oriyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ene ngundiro tetori ngu, Yisasdo erayaga nguya eyingo. Yari ombuya, no keneroya endeyori. Kootuyisina yarindo oni simoo bare yoyoro, Anutro mandeno yoyoweroyi ngu etuyerowano. Yo, hamoo, yari iso yooteriku ngundiro oni yoyowari. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ene ngundiro etoni, ngu naruno nangge erayagaku isoro si ngu yokoro, oororo, ene keyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ngu naruno, Yisasdo bodaga nguya oororo ngu, ene Yemus, Yon erabasa, Sebediro simoongo yeyoyingo. Ngu erayaga nguya wanggo sanganimo isoro si yomosiyorootori yeyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yisasdo erayaga ngu yeyoro negoyeroyingo. Negoyerootoni, erabasa mandeni ngu ingoro, nguro ene awayari Sebedi enengo ko onidodo wanggono yoyokootori, oodoyi, ene oororo, Yisas keyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ene Kapeniyam endemo oororo, ngu Yuda oniro kando naru (Sabat) nguno ene yowuru ya newendemo uro, oni simoo bareno mande wesiyoro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ene ngundiro mande wesiyoro etoni, oni enengo mandeni ingoro, nguro ene sosoreyingo. Ndadiro nguro, enengo mandeni etuyerooteku, ngu yanggango oorengo. Yo, enengo mandeni, ngu mamana mande oniro mande etuyerootenggoku, ngundiro kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ngu naruno, oni gura yowuru yano oruwo. Ngu oningga, nguno mbooro biyomi newendemo oorooteku, ngundo meno ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Yisas Nasaret oni, ge nooreno ngano ndawu ooga tewero ombute? Ge noore yomburiyerowero ombute, bine? No ge kuri ingooteno. Ge Anutro oni kundingiyi! ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ene ngundiro etoni ngu, Yisasdo mbooroga ngu kenoro, manggaruwooro eyingo. Ge manggoge gosiyoya, ge nga oningga nga yokoya toonge! ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ene ngundiro etoni, mbooro biyomi, ngundo mandeni ingoro, nguro ene sodedomangge oninggaku yeni, yanggango biyomi mboorombooro tetoni, mbooroga ngundo kimanggaru tero, ene oningga ngu yokoro besero toongeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ene ngundiro tetoni, oni simoo bare bidodo soriyokoro, enengo nangge kewooroyemo mande mande ero eyingo. Ngu ndawu ooga? Nga mande muri keta gura tunooteteku nga! Nga oningga, nga enengo yanggangoni ngu yanggango oorengo. Nguro ngu, ene mete mbooro biyomi mande yunootoni, enengo manggowo ingoro keyootenggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ngundiro tetoni, ngu mandegaku, sodedomangge Galili meradodo rogowooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ngu naruno, ene Yemus koneyo Yon ngudodo yowuru ya yokoro, endesina oorero, ene oororo, Sayimon koneyo Enduru eragado yano uyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ene yano uro, Sayimon konggeyi ngu yabano wetoro oodoni kenoyingo. Ene sayi urungga moondeyi kookingo urungga tetoni, nguro ene sodedomangge Yisasno nguro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yisasdo mandeye ngu ingoro, nguro ene barega ngu tanggeyimo oorowuyingo. Oororo, kandeyi dowooro hooroowetoni ootoogeyingo. Ene ngundiro tetoni, ngu naruno nangge, sayini kiniteyingo. Kinitetoni, nguro ngu baregaku ootoogero, mete tero, Yisas garoro oo karo yomosiyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Suwootetoni sa utoni, oni sayi oni, ko, mbooro biyomimbo yoyoyingo nguya yoyoro mayeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ngundiro mayetoyi, nguro endemo oni simoo bare bidodo endesina yamuko dabemimo yowuruwooro, ende ndinditero oriyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Asa, nguno Yisasdo oni simoo bare sayi gura gura yomosiyeroro, mbooro biyomi oweyerootoni sayingo. Ngundiro tero, ene Yisasdo oo mbooro biyomi nguya mande ma ewero, ero roogo teyunoote. Ndadiro nguro, mbooro biyomi, ngundo ene ingoyingo, Anutdo Yisas soweyootoni ombuyingo, ngu ingootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Sengewero tetoni, Yisas ootoogero, ende oorero, oni kini mera nguno toongero, ene nguno yemboongero oruwo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ene ngundiro yemboongero oodoni, Sayimondo dobookuriyidodo ene erewero sayingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Saro, oororo ene kenoro ngu, asa, ene Yisasno eyingo. Oni simoo bare bidodo ge erewenggerootenggo! ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ngundiro etoyi, enebana gumi eyingo. Nguno yokoyi. Noore ende gidarega namoko ngano saro, nguno no Anutro mande nguya wesiyoro ewero no ombuwono. Nguro damoni ngandiro: no Anutro Mande Keta Mesarango wesiyoro ewero nguro ombuwono. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Nguro ngu, ene Galili mera bidodomo oororo, Yuda oniro yowuru yano ngu bidodomo uyingo. Nguno uro, Anutro mande wesiyoro ero, ene mbooro biyomi nguya andangeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ngu naruno, oni gura gorimambudodo ngu Yisasno omburo sumoo ero, ngguyinggayi tero, bodowo oondoogero, Yisasno eyingo. Ge mete tetoningga ngu, no yomosinerootooga, mete tewe. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yisasdo, enengo mandeni ngu ingoro, nowoondoyi urungga teyinoro, nguro ene kandeyi eneno yero dowooro eyingo. Yo, no ingooteno. Gengo sayingge kiniteni, eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ene ngundiro etoni, arisa, sodedomangge mambugori goweyimo oruwoku ngu besero kiniteyingo. Ngundiro tero, ene mete teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Arisa, Yisasdo mande yanggango eneya eyingo. Ge ingonda te! Ge oni gurano nga mandega, ngaro ma ewero. Kini, ge sodedomangge yowuru yano oorowuya, Anutno wooro yeyingo oni kundingiyingga, nguno gowege, ene etungoo. Gowege mete tewoku nguro ge wooro yeya, Mosesndo kuri eyingo, ngundiya te! Ngundiro tetoyi ngu, oni ene ingowanggo. Hamoo oorengo, enengo sayi ngu kinitete. Ero ingowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ene ngu oninggaku, ene mande ngu toongooro, oororo, enengo moondeyi mete tewoku, nguro mandeni mera bidodomo, ero endeyoyingo. Ngundiro nguro, Yisas ende bidodo newendesina tunoo ko ma uyingo. Kini, ene diguno oni kini kingo mera gumisina nguno nangge oruwo. Ene nguno oodoni, ene oni simoo bare mera bidodomonggo eneno mayeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Naru gidega yokoro, Yisas Kapeniyam endemo ko oorowuwo. Oorowutoni, oni simoo bare, ene Yisas ya gurano oorooteku ngu, ero etoyi, ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Oni simoo bare oowooyingga ene ngundiro ingoro, nguro ene oororo, Yisas oruwoku yanggakuno yowuruwootoyi, ngu yanggaku ndinditetoyi, musiyo gura ma oriyingo. Yamuko dabemimo musiyo nguya ndinditeyingo. Nguno, Yisas ene Anutro mande yunoro oruwo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Mande wesiyoro eroodoni, oni gidaregado sayi oni gura yoro, Yisasno mayeyingo. Ngu oningga ngu kekandeyi bidodo bingo yero kumooyingo. Ngundiro tetoni, nguro oni namorayagobo ngu sayi oninggaku, yaba tero, nguno yero, sumooro koorowooro mayeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ene onindo musiyo kuri ukingowonggo. Nguro ngu, ene sayi oninggaku yoro, Yisas tanggeyimo uweroyi nguya kini. Ngundiro nguro, ene ya omungo Yisas oruwokusina awuno andangero, nguwoore ene sayi oninggaku wetorodoni yawasadodo yeyi, Yisas tanggeyimo uyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ene sayi oninggaku, yawasadodo yeyi utoni, Yisasdo enengo nowoondoyemo hamoo teyingo, ngu kenoro, nguro ene ngu sayi oninggakuya eyingo. Nangone, no gengo weti mbumbuwage kuri andangenggunootoowe kinitete. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ene ngundiro etoni, asa, ngu naruno nguno, Mosesro mamana mandero etuyeroyingo oni, ene nguno bibitero oruwonggoku, ngundo nowoondoyemo ingondudu tero, ngandiro ero ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Ndadiro nguro, nga oningga, ngando ngundiro ete? Hamoo oorengo, ene Anut kootuyisina ero, yomooyinoro mande biyomi ete. Noore ingootetoku, oni gurado weti mbumbuwa andangeweroyi nguya kini. Ngu Anutdo nangge mete weti mbumbuwa andangewa! ");
INSERT INTO rwo_rawa_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ene mande ngundiro ingowonggoku, nguro Yisas ene sodedomangge ngu ingonduduyega nowoondoyemo ngu ingowo. Ngundiro nguro, enebana gumi eyingo. Ndawu oogaro, ye ngundiro ingonduduga ngu nowoondoyemo ingootenggo? ");
INSERT INTO rwo_rawa_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nondo ndawu mandega etoowe, ngundo mande gumingga dagayeroote? Gengo weti mbumbuwa kinitete, ewano, bine; ngundi, ge ootoogeya, gengo yawasa yoya, oorowu ewano. Ndawu mandegado ngu dagate? ");
INSERT INTO rwo_rawa_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","No, Oni Nangoni, merako ngano yanggangonedodo oniro weti mbumbuwa mete andangeweroyi, ngu tero etuyerowero, nguro no sayi oningga ngaya eteno. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Ge ootoogeya, dikaya, gengo yaba yoya, gengo yano oorowu! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ngundiro etoni, sayi oninggaku mandeni ngu ingoro, sodedomangge ootoogero, oni simoo bare bidodo doongeyemo, enengo yaba yoro, koorowooro oorowuyingo. Ngundiro tetoni, oni bidodo soriyokoro, mboorombooro tero, Anut bingami ero okooro, ene ngandiro eyingo. Hamoo oorengo, noore kuri oo ngandiro ma kenoyingo! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ngu naruno, Yisas ene Galili sono koongeyingo tamakuri ko oorowutoni, oni simoo bare oowooyingga oorengo eneno mayeyingo. Mayetoyi, Yisasdo Anutro mande ero, nguno etuyeroyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ngundiro tero, ene oororo, Liwayi, ngu Alipiyas nangoni kenoyingo. Kenootoni, ene beye yoweroyi yano (Gabuman Takis) nguno bibitero oodoni, Yisasdo eyingo. Ge ombuya, no keneroya endeyo. Ngundiro etoni, Liwayi ootoogero, Yisas keyoro, endeyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ende oororo, Liwayindo Yisas yoro, enengo yano uro, bibitero oo neyingo. Digi beye yoyingo oni oowooyingga, mbumbuwadodo oni oowooyingga, ko, Yisasro kirikiri oni nguya Yisasdodo bibitero, oo neyingo. Ngu naruno, oni oowooyingga Yisasro nowoondoyemo hamoo teyingo, nguro ene nguya Yisas keyoro endeyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ngundiro tetoyi, Yuda oni gidaregado, Mosesro mamana mande etuyeroyingo oni, oowooye Parisi, ngundo Yisas kenootoyi, mbumbuwadodo oniya, ko, digi beye yoyingo oniya oo netoyi, yeyoro, nguro ene Yisasro kirikiri onikuno ero, sumoo ewonggo. Ndadiro nguro, ene digi beye yoyingo oni, ko, mbumbuwadodo oni nguya oo netenggo? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yisas enengo mandeye ngu ingoro, enebana gumi eyingo. Oni enengombo goweyimo, sayi kini ingoro ngu, ene sayi mambu yomosiyingo, onino (Doguta) nguno ma oorowuwanggo. Ngundiro nangge, no oni metemi, ngu yomosiyerowero ma ombuyingo. Kini, no oni weti mbumbuwadodo ngu yomosiyerowero ombuwono. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Naru gurano, Yonro kirikiri oni, Mosesro mamana mande etuyeroyingo oni, oowooye Parisi nguya oowari roogo tewonggo. Ndadiro nguro, oowari neweroyi naruno, Anutno yemboongero oowari ma neyingo. Asa, ngu naruno nguno, oni gidaregado omburo, Yisasno sumoo eyingo. Ndadiro nguro, Yonro kirikiri oni, ko, Parisi oniro kirikiri oniya, ngundo oowari roogo tetoyi, ene gengo kirikiri oni, ngando ngu oowari ma roogo tetenggo? ");
INSERT INTO rwo_rawa_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ene ngundiro sumoo ero etoyi, asa, enebana gumi eyingo. Bare kame yoweroyi naruno, dobooye ngu kenoro, oowari karo, ngu roogo tewanggo, bine? Kini, oni mayewonggoku ngu oodoyi, ene oni oni tero, oowari ma roogo tewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ene kootuyisina, oni bare yoweroyiga ngu andangero, eneya nguya ma oodoni, asa, ngu naruno, ene mete oowari roogo tewanggo. Ngundiro nangge, no nenengo kirikiri oniya oorootetoku ngano, ene oowari ma roogo tewanggo. Ene kootuyisina, mundi onindo noyoro satoyi, asa, ene kowuri koorowootenggoku naruno, ene mete oowari roogo tewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Oni kumba sosowo ketangga yoro, ngundo nengguro kurimingga nguro witu ngu ma ukingoro wesibiyowanggo. Ene ngundiro tetoyi ngu, asa, ngu kumba sosowoongga witu ukingowonggoku, ngundo nengguro ko oomboongewa. Ketangga ngundo kurimingga ngu oomboongetoni, witu urungga tunootewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Parisi oniro mande kurimi, ngundo noro mande keta nguya ma yowuruwoowari. Ngu ngandiro, oni gurado bo nangoni ketangga si kurimiyinggano siriyootoni ngu, asa, ngu si kurimingga ngu oomboongero, si bo nguya ngu biyomi yewari. Ngundiro nangge, ene bo ketangga ngu yoro, si ketanggano siriyootoyi ngu, asa, ngu siga ngu, ko boga nguya ngu gome oruwari, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Yuda oniro kando naru Sabat gurano, Yisasdo enengo kirikiri onidodo nggire gura, oowooyi Wit, ko kewoorokuri endeyoyingo. Ene oororo, Wit engge gidarega andangero, newero yoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ene ngundiro tetoyi, Parisi onindo Yisasro kirikiri onindo oo tewonggoku ngu yeyoro, nguro ene Yisasno sumoo ero eyingo. Ingo, kando naruno, oo yoro neweroyi, ngu roogo oorengo. Ndatero ene ngundiro tetenggo? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ene mande ngundiro sumoo etoyi, asa, enebana gumi eyingo. Ye bine Dewitdo teyingo ngu mande ngu ma kandangero ingootenggo? Ngu narungga nguno, ene enengo onidodo oo kini, nguro ene oodooro kumooro oruwonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ngundiro tero, ngu naruno, Abayiyata ngu, ene Anutno wooro yeyingo oni, nguro sobosobo tabango oodoni, nguno Dewitdo Anutro yowuru ya newendemo uro, ene ngu oomanongoyingo kundingiyi Anut doongeyimo oruwoku, ngu yoro neyingo. Ngu oomanongoyingo ngu roogo, oni kundingiyi ngundo nangge mete newanggo. Ene Dewitdo ngu yoro, nero, gumi enengo dobookuriyi nguya yunootoni neyingo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yisasdo mande gura soweyoro eyingo. Anutdo kando naru kundingiyi (Sabat), ngundo oni hooroowetoni, ene kengero, Anutro ingondudu tewanggo. Anutro kando narungga, ngundo oni ma sobowoowa. Hamoo oorengo kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ngundiro nguro, no Oni Nangoni, ngu kando naru kundingiyingga, no nguro Simburi urungga oorooteno. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Naru gurano, Yisas yowuru ya newendemo ko uyingo. Utoni, oni gura nguno oruwoku, ngu kandeyi biyomi, bingo yero, oo ma dowooweroyi teyingongga, ngu kenoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ngu naruno, Parisi oni, ko, oni gidarega nguya Yisasdo oo tewero ingowoku, nguro sobowooyingo. Ndadiro nguro, ene ngu oningga, ngu naru kundingiyimo yomosiyowa, bine; ngundi kini, bine? Ene nguno Yisasdo oningga yomosiyootoni, kenoro, ngunonggo dowooro mamanangowero nguro teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yisasdo ngu oni kandeyi biyomingga nguya eyingo. Ge ootoogeya, kewooroko dikaya ombu, eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Yisasdo ngundiro tero, yowoorengoro, yeyoro, Parisi onino eyingo. Anutro mamana mandedo kando naru kundingiyi, nguno ndawu kongga tewero nguro ete? Noore mete oni yomosiyoweroyi, bine; ngundi, noore muri biyomi teyunowato, bine? Ngundi noore Sabatno oni hoorooweyerowato, bine; ngundi noore oni yureyi kumoowanggo, bine? Ene ngundiro sumoo etoni, ene Parisi onindo nenetero, ene mande gumi gura ma eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yisasdo yeyondandangero, nowoondoye kenoyingo ngu, ko oo tewoku, nguro nowoondoye ma ingoyingo. Kini, enengo nowoondoye yanggango oorengo ukingoyingo. Ngundiro tetoyi, Yisasdo sanggiri tero, oni kandeyi biyomingga nguya eyingo. Kandege yoonenengo! Ngundiro etoni, arisa, ene kandeyi yoonenengootoni, kandeyi ko mete teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ene ngundiro tetoni, kenoro, sodedomangge Parisi oni ootoogero, saro, Gabuman oniro tabango oowooyi Herod nguro keyimo onikuya saro yowuruwooyingo. Ene nguno yowuruwooro, Yisas ureyi kumoowero nguro oore erewero nguro mande mande ero ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Ngu naruno, Yisas, ko, enengo kirikiri onikudodo, ene ngu endega ngu yokoro, ene Galili sono koongeyingo tanggeyimo uyingo. Nguno simoo bare oowooyingga oorengo Galilinonggo, Yudiyanonggo nguya, Yerusalem ende nguro simoo bare, Idumiya mera nguro simoo bare, Yodan sono anduroko simoo bare, Tayiya ende, ko, Sayidon endemo simoo bare oowooyingga oorengo, ngu bidodo Yisasdo ko oo tewoku, nguro mandeni ingowero nguro ene mayero yowuruwooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yisasdo oni oowooyingga yeyoro, enengo kirikiri oniya eyingo. Oni simoo bare oowooyingga oorengo oorootenggoku, ngundo no wenggerenerowanggo, bine? Ngundiro nguro, ye wanggo gura yomosiyoya, no sobonero. No ngu sanganimo oorewano, eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kuri oni simoo bare oowooyingga yomosiyerowoku, nguro oni sayidodo ngu ene mayero woorogongoyingo. Ndadiro nguro, ene ingootenggoku, ngu kandeye Yisas moondeyimo yetoyi, enengo sayiye kinitewa, ero ingootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ngu naruno ngu, merambooro biyomi oowooyingga oni nowoondoyemo oorootenggoku, ngundo Yisas kenoro, ene boodoo oondoogero, kiyero, Yisasno eyingo. Ge Anutro Nangoni! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ene ngundiro etoyi ngu, Yisasdo mande yanggango merambooro biyomi nguya eyingo. Ge mande ero, no Anutro Nangoni ero, oni gidaregano ma yootunoro ewero. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ngu naruno ngu, Yisas purimo ooreyingo. Ene oni gidarega enengombo ingowoku ngu, oni ngu enengo kirikiri oni teyi, ero yootunoyeroyingo. Ene ngu oniku negoyeroyingoku, ngu eneno ombuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Ene oni kande eraya kegidemboro eraya rogoyeroyingo. Ngu oni ngu eneya oruwero, nguro rogoyeroyingo. Ene ngu oni ngu sureyerootoni, toongero, Anutro mande wesiyoro eweroyimboro. Ene ngu oni ngu yanggango yunoro, mbooro biyomi andangewero, nguro ene yanggangododo yunoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Ene oni kande eraya kegidemboro eraya yootunoyeroyingo. Sayimon oowooyi keta gura inoro, ngu Pita ewo. Yemus koneyo Yon erabasa Sebedi simoongo, Yisasdo ngu oowooyari keta gura Bowanes, ero yunoyingo. Ngu oowooyingga ngu muri ngu, gusiro. Ndadiro nguro, mandeyari, muriyari ngu yanggango oorengo, gusiro ngundiro. Ene Enduru; Pilip; Batolomeyu; Matiyu; Tomas; Yemus, Alipiyas nangoni; Tadiyas; Sayimon, nguya rogoyeroyingo. Sayimon oningga ngu Kenan merakonggo ombuyingo. Sayimonro murini ngandiro. Enengo mera ngu mera gura onindo sobowooweroyi ingonduduni kini oorengo. Yudas Isakariyoot, ngu oningga, ngundo Yisas mundi oni kandeyemo yero yootunowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ngu naruno, Yisas yano oorowutoni, oni simoo bare oowooyingga nguya yowuruwooyingo. Ngundiro nguro, Yisas enengo kirikiri onidodo oo neweroyi naru nguya kini, ene Anutro ko ngu nangge simoo bareno teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Oni simoo baredo ene ngundiro kenoro eyingo. Yisas kakabetete, ero eyingo. Ngundiro etoyi, Yisas enengo konebeyibo mande ngundiro ingoro, ene yanggango yero, Yisas yowero nguro ene ombuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ngu naruno nguno, mamana mande etuyeroyingo oni gidega, Yerusalemnonggo ombuwonggoku, ngundo eyingo. Mbooro biyomi tabango urungga oowooyi Setan, oowooyi gura Beyelesebab, eneno oodoni, ene ngu yanggangomonggo mbooro biyomi gidarega oweyeroote. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ene mande ngundiro etoyi, asa, Yisasdo ngu oniku negoyerootoni, tanggeyimo ombutoyi, ene mande adingayi gidarega eneno eyingo. Ndawu ooga Setan, ngundo mete Setan ngu owewa? ");
INSERT INTO rwo_rawa_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ende gurananggemo oni nowoondoye ma siyero ngu, ngu endega ngu ngundiro sugi yanggango ma oruwa. Hamoo oorengo kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ngundiro nangge, ya gurananggemo oni ngu wesoowooro eraya tunootero, enengo nangge, ngu ebe utoro ngu, asa, ngu yano oni ngu, ene yanggango ma oruwanggo. Kini ene ya toongooro, songo songo saro oruwanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ngundiro nangge, Setando enengo nangge mbooro biyomimboya ebe utoro ngu, asa, wesoowooro eraya tero, yanggango ma oruwa. Ene sodedo kinitewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Oni gura ene mete oni yanggango guraro yano kingo uro, oo sitowini andangero yowa, bine? Kini, ene koretero ngu, oni yanggangongga ngu utombo gome gosiyoro yokoro ngu, asa, ene mete yanimo uro, oo sitowini bidodo andangero yowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","No yeno hamoo oorengo eteno. Anutdo ene weti mbumbuwa, ko, kootuyisina yomooyinoyingo mande oni simoo baredo tetenggoku, ngu bidodo ene mete andangeyunowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ene oni Yuka Kundingiyi kootuyisina yomooyinoro mande eteku, nguro mbumbuwa ngu nangge, Anutdo ngu ma andange inowa. Kini, ataga ko kootuyisina nguya, ngu mbumbuwani ngu suwooyi sano eneno sugi oruwa. Yisasdo ngundiro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ngu muringga nguno, simoo baredo kuri ngandiro ingoro, Yisasno mbooro biyomi ooroote, eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ngu narungga nguno, Yisas nemi, konedoboongo, ene Yisasno tunootero, endesina dikaro, oni gurano Yisasro mande soweyoyingo. Yisas eneno ooreni, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ngu naruno ngu, oni simoo bare oowooyingga oorengo, ene Yisas pawangoro, bibitero oodoyi, eneno ero eyingo. Ingo, nangge, konedobooge, ene endesina dikaro, ngunonggo gengo etenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ene mande etoyi, enebana gumi eyingo. Oone ngu namone konedoboone? ");
INSERT INTO rwo_rawa_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ene ngundiro ero, oni simoo bare pawangoro, bibiteyingo ngu, yeyondandangero eyingo. Yo, hamoo, ene ngu noro namone konedoboone, ene nga oni simoo bare, noro nowoondoyemo hamoo teyingo nga ngu, ngu nguya noro namone konedoboone. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Yo, hamoo, simoo bare ene Anutro ingondudu keyootenggoku, ngu ene noro konedoboone kuwookuwoone, nanamone. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Naru gurano, Yisas ene ko tero, oni simoo bare Galili sono koongeyingo tanggeyimo, mande etuyeroro oriyingo. Nguno ngu, simoo bare oowooyingga oorengo mayero, Yisas tanggeyimo yowuruyingo. Nguro ngu, ene wanggo gura sanganimo oorero, nguno bibitero, wanggo sono koongeyingo sanganimo oriyingo. Ngundiro tetoni, simoo bare ngu sono dabemimo keredi sanganimo oruwonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ngu naruno, ene mande mande oowooyingga oorengo mande adingayi nangge ero yunoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Ene mande ngandiro yunoyingo. Ye ingoyi! Oni gura kono Wit yuwooyi kuriyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ene ngundiro kuriyootoni, Wit yuwooyi gidega ooreko soretoni, numbo mayero nemukoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Oo yuwooyi gidarega mera gumi digidodo musiyosina soreyingo. Mera nguno urungga kini. Digi newendemo amuno mera nguya kini, digi nangge. Nguro oo yuwooyiga ngu sodedo ooreyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ene huri uro, mera newendemo uweroyi kini. Mera bodaga nangge nguro ngundiro teyingo. Ene sa oorero, kenootoni ariyeyingo. Nguro digi kookingombo tetoni, bidodo ariyero kumooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Oo yuwooyi gidare uto so sanggiridodo, kakari dimoo uto oo kewoorokono soreyingo. Kakari dimoo uto sanggiridodo oorero, ngundo doobengoro wiriyoyingo. Ngundiro tetoni, nguro ma enggeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ene oo yuwooyi gidarega mera gome oorengomo soreyingo. Ngu oo yuwooyigaku gome oorero, urungga yero, gome enggeyingo. Gidarega engge onibiga kande eraya (30), gidarega engge onibi kabusa (60), gidarega engge onibi kande eraya (100) enggeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yisasdo oni nguya eyingo. Oni sodeyidodo ngu mande ingoya, ene gome ingoni. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kootuyisina, Yisas enengo kirikiri oni kande eraya kegidemboro erayagaku, ko, oni gidarega eneya oorowuwonggoku, ngundo nangge oriyingo. Ngundiro oode, ene mande adingayi nguro Yisas sumoo inoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ene sumoo etoyi, Yisasdo gumi eyingo. Anut Oo Bidodo Simburi Simbunani, ngundo enengo simoo bare soboyerooteku, ngu ye etuyerowa. Oni Anutro mande ma ingooteku ngu, ene mande adingayi nangge ingowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ngundiro nguro, Anutro mande Ayisayando nguya ngandiro nakangoyingo. Ene nguya doongetero, kenowanggoku ngu, ene oo gura ma kenowanggo. Ene mande ingowanggoku ngu, ene muri ma ingowanggo. Ndadiro nguro, enengo muriye biyomi ma yokoro, yowoorengootoyi, nguro Anutdo enengo weti mbumbuwa ma andangewa. Ene mande nga gome ingoro, newende Anut inootoni ngu, asa, Anutdo oni nguro weti mbumbuwa bidodo andangeyinowa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yisasdo kirikiri oniya eyingo. Ye nga mande adingayingga ngaro muri ma ingootenggo. Nguro ngu, ye mande adingayi gidarega ndadiro terogogo, ye muri ingowanggo? ");
INSERT INTO rwo_rawa_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nga mande adingayingga nga ngandiro. Ngu oningga oo yuwooyi miteku ngu, Anutro mande ngu oo yuwooyi ngundiro mite. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Oo yuwooyi oore dabemimo soreteku ngu, oni simoo bare gidarega Anutro mande ingootoyi, nguno nangge Setando sodedo omburo, Anutdo mandega oni nowoondoyemo miteku ngu, andangero yoote. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Oni simoo bare gidarega ngu Wit yuwooyi mera digidodomo soreteku ngundiro. Ene mande ingoro, sodedo yoro, nguro ene oni oni tewonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ene mande nguro ene nowoondoyemo yanggango kini. Ngundiro nguro, naru bodaga nangge yanggango oodoyi, oni ene Anutro mande ureyi uweroyi oni, ngundo oni simoo bare, Anutro mande ingowonggoku, ngu kowuri yunootenggo. Ngundiro tetoyi, sodedo enengo nowoondoyemo hamoo ngu yokoro, ene Anut kootu inootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Oni simoo bare gidega, ngundiro oo yuwooyi uto sanggiridodo kewooroko soreteku ngu, ene mande ingowonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Mande ngu ingoro, ene kowuri guradiro nga merangga ngaro ngu tunootetoni, nguya digi beye urungga yowero nowoondoye nguro nangge hahangero ingootenggo. Mande godange, ko, oo gura guraro ingondudu tero, ngu muringga, ngundo Anut mande wiriyowa. Ngu oni simoo bare ngu, ene ma enggewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Oo yuwooyi mera gomemo soreteku ngu ngandiro, ene oni simoo bare gidarega ngu, ene mande ingoro, yoro, gome dowootenggo. Ene ngandiro enggewanggo. Gidarega engge onibiga kande eraya (30), gidarega engge onibi kabusa (60), gidarega engge onibi kande eraya (100) ngundiro enggewanggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yisasdo eyingo. Oni ngu soru yoro, omburo, kumbe newendemo yawasa newendemo nguya yewa, bine? Kini, ene tunoo mindingowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Oo bidodo kombiteyingo, ngu kootuyisina tunootewanggo. Ene mande bidodo onindo wiriyooteku ngu, kootuyisina, soru himimo tunootewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Oni sodeyi mande ingoweroyi ngu, ene komo gome ingoni. Yisasdo ngundiro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yisasdo mande gura soweyoro eyingo. Mande ye ingootenggoku ngu, ye gome oorengo ingondudu teyi. Yengo muriye koye nguya ndadiro tewanggoku ngu, ngundiro nangge, gumi yunoro, Anutdo yengo ngu soweyoro, sanganimo nguya yero yunowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ene oni gura, enengo murini koni gome tewaku ngu, Anutdo ngu soweyoro, gumi urungga nguya inowa. Ene oni gura enengo murini koni bodaga tewaku ngu, ngundiro nangge, enengo koni murini ngu yokowaku ngu, ene komo kingo oorengo oruwa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yisasdo eyingo. Anut Oo Bidodo Simburi Simbunani, ngundo enengo simoo bare soboyerooteku, ngu ngandiro. Oni gura oo yuwooyi merako kuriyoote. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Suwoono, oningga ngu wetoro oodoni, sano ngu ene ootoogero endeyowa. Ngu naruno nguno, oningga oo yuwooyi kuriyowoku ngu oorero, urungga yero, enggewoku ngu kenoro, sobowooro ma ingowo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Mera enengombo nangge koyi tetoni, oo yuwooyiga ngu mbongeyi tunootero, oorero, ngu uyi yero enggewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Kootuyisina, oo enengo naru tunootetoni ngu, oo simburigakundo duge dowooro, ngundo koyi tero, engge yowa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yisasdo eyingo. Noore Anut Oo Bidodo Simburi Simbunani, ngundo enengo simoo bare soboyerooteku ngu, noore ndawu ooga bungomo kirarongo tewato? Noore ndadiro mandegano ooga bungomo kirarongo mande tewato? ");
INSERT INTO rwo_rawa_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Anut Oo Bidodo Simburi Simbunani, ngundo enengo simoo bare soboyerooteku, ngu Masitet yuwooyi ngundiro. Ngu de gura oowooyi Masitet, oo yuwooyi gidarega ngu bobodi, ene Masitet yuwooyi ngu puka tanggori ngundiro, kondibo bobodi oorengo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Oo ngu miro yokootoni, enengombo oorero, urungga oorengo yete. Ene oowari gidarega kono ngu bidodo dagayeroro, enendo oorero, de urungga yewa. Enengo kambini urungga yero, yongeyi tetoni, numbo nguno bibitewanggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yisasdo mande adingayi oowooyingga oni simoo bareno ngandiro wesiyoro ero eyingo. Oni simoo bare ingonduduno ingoweroyi rogoyimo eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ene mande gura tunoo oni simoo bareno ma wesiyoro eyingo. Kini, ene mande adingayi nangge wesiyoro eyingo. Naru gura oni simoo bare ma oodoyi, nguno enesu nangge kirikiri oniya nangge oode, asa, nguno ngu, ene mande adingayi nguro muri wesiyoro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ngu sangga ngu suwootetoni, Yisasdo enengo kirikiri onikuya eyingo. Noore Galili sono koongeyingo anduroko uroorewato. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ene ngundiro etoni, nguro Yisasro kirikiri oni ngundo ene oni simoo bare urungga ngu yoyokoro, ene Yisas bibiteyingo wanggogakuno ooreyingo. Oorero, ene Yisas nguya yoro, Galili mera anduroko urooreyingo. Urooretoni, wanggo gidarega nguya ene keyeroro urooreyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Urooretoyi, ngu naruno nangge, doogo urungga oorengo tunooteyingo. Ngundiro tunootero, wendeyi yowooraringoro, dookero, sono wanggo newendemo nguya uyingo. Nguro ngu, wanggogaku sonombo koongero, manggowoomo oorewero teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ene ngundiro tetoni, ene Yisas ngu wanggo timbuyisina oode, ene nguno tabadudu gura sanganimo wereyingo. Wetorodoni, ene yokutuwooro mande yanggango eyingo. Oo etuyeroyingo oni, noore oonootewero tetetoku nga! Ge bine ma ingoyingo? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ene ngundiro etoyi ngu, asa, Yisas ootoogero, doogogaku kenoro, ero, sono koongeyingongga nguya eyingo. Ge imakeya, torige ootoo! Ngundiro etoni, sodedomangge, doogo kinitetoni, sononggaku nguya bodaga ma ikakooteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ene ngundiro tetori, enengo kirikiri oniya eyingo. Ye sosoretenggo? Ndadiro nguro, ye nowoondoyemo hamoo kini? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ene ngundiro etoni, ene sosoreyingo urungga tero, enengo nangge enengo kewooroyemo mande ero ingoro eyingo. Nga oningga nga, ngu oone? Ene mande nangge etoni, nguro doogo, sono nguya, enengo mandeni ingooteri. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yisasdo enengo kirikiri oniya, Galili sono koongeyingo sagi gidaresina mera gura, oowooyi Gerasin, nguno tunooteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ene tunootero, wanggo yokoro, sagigo sodedomangge ooreyingo. Ooretoyi, oni gura mboorombo yoyingo oningga nguno oruwo. Ene nguno ootooro, ngunonggo ene oni kumooyingo yoyeyingo merewoore buribari endeyororuwoku, ngundo omburo, Yisas kenoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Oningga ngu oni merewoore wetoro, endeyoro oruwo. Oodoni, ene oni gurado nguya ene uto yanggayanggango gura, oowooyi (sen), ngundo gosiyoweroyi nguya ereremo kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ngundiro nguro, naru oowooyingga uto gura, oowooyi sen, ngundo kekandeyi gosiyootoyi ngu, nguya omboongeroruwa. Ndadiro nguro, ene oni yanggango oorengo. Nguro ngu, oni gurado ene dowooro, gosiyoweroyi nguya ereremo kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ngundiro nguro, ene suwoo sa ngu bidodo oni yoyeyingomo ko mera pupurimo nguno nangge oruwo. Nguno ootooro, ene kimanggaru tero, digi kuningo ngu yoro, ngundo enengo moondeyi doongooro oruwo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ene Yisas oriroko oodoni kenoro, ene kendutero, omburo, Yisasno bagooteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Bagootetoni, Yisasdo eneya eyingo. Ye oombooro biyomi, ye nga oningga nga, yokoya sayi! Ero eyingo. Ene ngundiro etoni ngu, asa, oombooro biyomingga, ngundo manggaru urungga oorengo tero eyingo. Yisas, ge Anut awuno oorengo nguro Nangoni. Ge ndadiro no tenunowa? Ge hamoo oorengo Anut awuno oorengo ngu oowooyimo, ge hamoo eya. Ge no ogingo ma nunororuwero. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ene ngundiro sumoo etoyi, Yisasdo ene sumoo inoyingo. Ge oowoongge ndadiro? Etoni, enebana gumi eyingo. No oowoone me oni (Ami). Ndadiro nguro, muri ngu noore me oni oowooyingga oorengo! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ngu oombooro biyomingga, ngundo ngguyinggayi tero, sumoo sumoo inoro eyingo. Ge noore nga oombooro nga oweyerootoyi, noore mera gurano ma sawato. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Arisa, mera puri bodaga namoko nguno, bo oowooyingga oorengo nguno oo nero oruwonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Oomboorokundo Yisasno sumoo eyingo. Ge mete bine noore soweyerootooga, bo kewooroyemo oorowuwato. Noore mete ene nowoondoyemo umukowato. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yisasdo meramboorokuro mandeye ngu ingoro, gumi eyingo. Ye mete ngundiya teyi. Eyingo. Etoni ngu, asa, oombooroku ngu oninggaku yokoro, ene oororo, bokuno woorogoyeroyingo. Ngu bo oowooyingga (2000) oorengo. Bo ngu yanggango oorengo yondowidoro oororo, uro, mera biyomimo sorero ngunonggo sono koongeyingomo umukoyingo. Boku sono koongeyingo newendemo uro, ene sono nero kumoomukoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Bo ene sono nero kumootoyi, bo nguro sobosoboku ngu kenoro, nguro ene saro, ngu mandegaku yoro, ende urunggakuno uro, ende bobodimo nguya oorowuyingo. Ene ngundiro tetoyi ngu, oni simoo bare oowooyingga omburo, ngu oogaku kenoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ene Yisasno mayero, kuri mboorombo yoyingo oninggaku, ngu kenoyingo. Kuri oombooro oowooyingga eneno oruwonggoku, ene ataga ngu, ene kumba yemuro, enengo ingondudu nguya himi yero, ene metemi bibitero oruwo. Ngundiro oodoni, oni simoo bare ngu kenoro, nguro ene sosoreyingo urungga teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ngundiro nguro, oni ngu oo ngu kenoyingokundo, oni songokuno ngu oo tunootewoku, nguro mandeni eyingo. Kuri, oombooro biyomi ngu oningga nguno oruwoku nguro, ko, bokuro mande nguya wesiyoro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Oni simoo bare mande ngu ingoro, nguro ene Yisasno omburo, mande yanggango ero, eneno ngguyinggayi tero, sumoo sumoo eyingo. Ge komo nga merangga nga yokoya, mera songomo toonge. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Arisa, ene ngundiro etoyi ngu, Yisas ene wanggo sanganimo ooreyingo. Ooretoni, ngu oombooro biyomi oruwoku, oninggaku, Yisasno ngguyinggayi tero, sumoo sumoo inoro eyingo. No nguya geya sawaro. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Etoni, ene Yisasdo gumi eyingo. Kini, ge gengo dobookurigemo oorowu. Anut Oo Simburi, ngundo oo bidodo gengo nowoondoyi tero, oo tewoku, nguro ge mete eneno wesiyoya e. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Arisa, ene ngundiro etoni ngu, ngu oninggaku oororo, mera oowooyi Dikapolis, nguno ende kande eraya oruwo. Ngu endemo nguno, Yisasdo eneno oo tewoku, nguro muri wesiyoro eyingo. Nguro ngu, oni simoo bare ngu oo nguro ingondudu urungga tewonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Naru gurano, Yisas wanggo sanganimo ko oorero, Galili sono koongeyingo anduroko ko urooreyingo. Ngu naruno, oni simoo bare oowooyingga oorengo mayero, Yisas sono koongeyingo tanggeyimo oruwokuno nguno eneya yowuruwooro oruwonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ngu naruno nguno, Yuda oniro yowuru ya nguro oni tabango gura, oowooyi ngu Yayiras, ngu Yisas kenoro, omburo, tanggeyimo bodo oondoogero, bagootero, sumoo ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Nenengo nambone bodaga komo kumoowero teteku nga! Nguro ngu, ge ombuya, kandege eneno yetooga, ene ma kumoowero, mete teni. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yisasdo, enengo mandeni ngu ingoro, nguro ene Yayirasya oorowutori, oni simoo bare oowooyingga Yisas pawangoro, moguruwooro, keyoro oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Arisa, bare gura nguya ooroote. Ene suwooyi sano komboro sayi yambiyootero ooroote. Ngu barega ngu mooma naru kande eraya kegidemboro eraya oriyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Sayi mambu yomosiyoyingo oni (Doguta), oni oowooyingga oorengo yomosiyootoyi, sayi ma yokoyingo. Ene ogingo urungga ingororuwo. Ngu barega ngu, enengo beye bidodo oni yomosimosi (Doguta) onino yokororiyingo. Ene enengo sayini ngu bodaga ma yokoyingo. Kini, enengo sayini ngu urungga tunooteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ngu barega ngu Yisasro mande binga ingoyingo. Nguro ngu, ene mayero, Yisas tanggeyimo, oni simoo bare urungga, ngu kewooroyemo ene nguya, nguno oruwo. Ene Yisas kootuyisinanggo omburo, kandeyi enengo negguronimo yeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ndadiro nguro, barega ngu ingoyingo. No kandene enengo nenggurono yetoowe, nguro sayine yokootoni, no mete tewano. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ngundiro ero ingootoni, asa, sodedomangge, enengo sidudaroninggaku sori yeyingo. Enengo goweyimo ingootoni, ngu enengo sayinggaku ataga kinitete, ero ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ene ngundiro tetoni ngu, Yisasdo ngu ingoyingo. Nenengo yanggangone gidega no noyokoro toongete. Ngundiro ingoro, oni simoo bare kewooroyemo yowoorengoro sumoo eyingo. Onendo noro towi nengguronemo kandeyi yete? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ene ngundiro sumoo etoni, Yisasro kirikiri onindo gumi eyingo. Ge keno! Oni simoo bare urungga oorengo, ge woorogogerootenggo. Ndadiro nguro ge ngandiro ete? Onendo nono kandeyi yete? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yisasdo ngundiro ero, doongetero endeyoyingo. Ene ngu oningga ngu kenowero, onendo ngu tete. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ene ngundiro tetoni ngu, asa, ngu barega sayini yokowoku, ngu ingoyingo. Oo ngu enendo tewokuro, ene sosorero, mbooro utoro, omburo, Yisas tanggeyimo bagooteyingo. Ngundiro tero, Yisasno oo bidodo tewoku, ngu yootunoro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ngundiro nguro, Yisasdo eneno gumi eyingo. Nambone, gengo nowoondoge hamoo teyingo, ngundo goyeni, mete tete. Ge oorowuya, gengo nowoondoge ngu mete imakeyingomo orini. Gengo sayinggega ngu mete kinitete. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Arisa, Yisas mande ewoodoni, Yuda oniro yowuru yaro oni tabangongga nguro yanonggo ko onikundo omburo eyingo. Gengo namboge ngu kuri kumoowo. Ngundiro nguro, ge ndawugaro Oo Etuyeroyingo Oni ko urungga inowa? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yisasdo ngu mandega etenggoku, ngu sodeyibo ingowero ma ingoyingo. Kini, Yisasdo yowuru yaro oninggakuya eyingo. Ge ma sosorewero. Ge gengo ingondudu ngu hamoo teni. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ene ngundiro ero, oni simoo bare ene keyoro, ya newendemo ma uwero, ero roogo teyingo. Ene Yisasdo Yemus, Yon erabasa, Pita ngu oni kabusaga ngu nangge yoyoro, ya newendemo uyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ene Yayirasdo yano uro, Yisasdo yeyoyingo ngu, oni bidodo mayero, Yayirasro ya newendemo uro, Yayiras namboni bingomo sendomoguru urungga tetoyi, ngu yeyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yisas yeyoro, ya newendesina uro eyingo. Ndawugaro ye sendomoguru giritaga urungga tetenggo? Nga bare buniyongga nga, ngu ma kumooyingo. Ene wetoro, kabetero ooroote. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Yisasdo ngundiro etoni ngu, asa, oniku ngu ingoro, nguro ene yomooyinoyingo. Ene ngundiro tetoyi, ene Yisasdo oni simoo bare bidodo oweyerootoni, endesina ooreyingo. Eweyi, nemi Yisas enengo kirikiri oni kabusaga ngundo nangge Yisasdodo onibi yeyingo ya guminggakuno uyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ngu naruno ngu, Yisas bare buniyonggaku kandeyi dowooro, enengo mandenonggo eyingo. Tarita kumi, ero eyingo. Ngu mandega, nguro muri ngu ngandiro. Bare buniyo no geya eteno. Ge ootooge. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ene ngundiro etoni ngu, arisa, sodedo oorengo, ngu bare buniyonggaku ootoogero, oororo, omburo, teyingo. Bare buniyo, nguro dagomani, ngu kande eraya kegidemboro eraya (12). Oniku oo ngu kenoro, nguro ene soriyokoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Asa, Yisasdo mande yanggango eneya ero eyingo. Ye nga ooga ngaro oni gurano hamoo oorengo ma ewero. Ene ataga ye oowari gura yoya, nga bare buniyongga, nga inootoyiga neni. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ngu naruno ngu, Yisas ngu endega ngu yokoro, ene enengo ende damonimo oorowuyingo. Enengo kirikiri oni kirarongo nguya, ene keyoro oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Yudaro kando naru Sabatno, ene yowuru yano uro, oni simoo bareno Anutro mande etuyeroro eyingo. Oni oowooyingga enengo mande ingoro, soriyokoro eyingo. Nga oningga nga ndanonggo nga mandega nga yowo? Ngu ndadiro ingonduduga ngunonggo ene muri songo oorengo gura onindo ma teweroyi, ngu ngundiro tete? ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ngu oningga ngu ya yeweroyi oni nangge. Ene Mariya nangoni. Ene ngu Yemus, Yosis, Yudas, Sayimon nguro baye. Nguro kuwookuwooye ngu nooreya oorootetoku nga, ngundiro ero eyingo. Ngundiro nguro, ene Yisasya nowoondoye biyomi ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yisasdo enengo mandeye ngu ingoro, nguro eneya gumi eyingo. Anutro ingondudu eyingo oni, ngu ende songomo oowooyi bingamidodo oruwa. Ene enengo ende damonimo, enengo sowenimo, enengo ya gobooro onino ngu, ene oowooyidodo ma tewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ngundiro nguro, ene ngu endega nguno, muri songo oorengo gura onindo ma teweroyi, oo ngu ma teyingo. Kini, ene sayi oni guranangge nanggemo kandeyi okooro yomosiyerootoni, mete teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ene oni simoo bare Yisasro nowoondoyemo hamoo ma teyingo, nguro Yisasdo ngu oni nguro ene ingondudu urungga teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Arisa, ngu naruno, ene oororo, ende songomo nguno endeyoro, oni simoo bareno Anutro mande ero etuyeroro, enengo kirikiri oni kirarongo kande eraya kegidemboro eraya, ngu negoyerootoni ombuyingo. Ombutoyi, ene eraya eraya soweyerootoni sayingo. Yisasdo ene yanggango yunoyingo. Ngu yanggangongga ngu merambooro andangeweroyi nguro yanggango yunoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Yisasdo ko oniya mande yanggango oorengo eyingo. Ye oomanongoyingo, siyaki, beye, oo ngu bidodo ma yowero. Usudoko nangge yoya sayi. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ye towikumba eraya ma yowero. Towi guranangge nguya, keye goweyi nangge, keye eraya eraya doobengoya sayi. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ye ende gurano uya, oni gurado yeyoro, oni oni tero, yoyoro, enengo yano utoningga ngu, asa, ngu yanggano nguno nangge oodega ngu, saweroyi naruno ootoogeya sayi. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ene ende gidaregano satoyiga, ene ye ma yoyoya, enengo yano ma uya, ko yengo mande nguya ma ingootoyiga ngu, asa, ye mete ngu endega ngu yokoya sayi. Saweroyi naruno ngu, ye keyemo gugukakawu oorooteku, ngu endega nguno yonggurumooya sayi. Ngundiro tetoyi ngu, asa, enengo muriye biyomi yeno tewonggoku ngu eneno sugi sugi oruwa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Arisa, ene ngundiro etoni, kirikiri oni kirarongo sayingo. Saro, Anutro mande oni simoo bare nowoondoye yowoorengoweroyi, ngu wesiyoro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ene merambooro biyomi oowooyingga oweyeroro, bo urumi sayi onino yero, sayi oni oowooyingga moondeye dowooro yomosiyerootoyi, mete teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Herod ngu Rom Gabuman oni, ngundo Yudiya merako simoo bare nguro sobosobo koreteyingo oruwoku, ngundo Yisasro mande binga ngu ingoyingo. Yisasro oowooyi mera bidodo pawangootoni, simoo bare gidaregado ngu ingoro eyingo. Sonoyeroyingo Yon, ngu merenonggo ko ootoogete. Ngundiro nguro, ene mete oo songo oorengo gura onindo ma teweroyi, ngu teweroyi, nguro yanggangoni urungga kandeyimo tunootete, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ngundiro etoyi, gidaregado eyingo. Ngu Ilayisa eyingo. Gidaregado eyingo. Ngu Anutro ingondudu eyingo oni, kurimiku gura. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ngundiro nguro, Herodndo Yonro mandeni etoyi, ingoro, enebana eyingo. Yon ngu, kuri nondo bungeyi toongooyingo. Ehe!! Ene ataga ko ootoogeteku ngu! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herodro sosoreyingo nguro muri ngandiro. Kurimi, Herodndo koneyo Pilip bareyi yakakayi yoyingo. Barega ngu oowooyi Herodiyas. Yondo Herod erambarisa nguro mbumbuwayari yootunoro mamanayeroyingo. Ngundiro mamanayerootoni ngu, asa, Herodiyasndo Yonya sanggiri urungga tero, Herodno ewo. Herodndo enengo mandeni ngu ingoro, nguro ene enengo kirikiri oni sureyerootoni, oorero, Yon dowooro, utombo gosiyoro, ya biyomimo yeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Kuri, Yondo Herodya eyingo. Ge konege bareyi yooteku ngu, Anut doongeyimo ngu, ge muri biyomi tewo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Nguro ngu, Herodiyas Yonya biyomi urungga ingoyingo. Ene Yon ureyiga kumooni, ero ingoyingo. Ene Herodndo ngu Yon ureni kumoowero, ma ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ndadiro nguro, Herod ene Yonro sosorero ingoote. Yon ngu Anutro oni nenengo ootooro, kundingiyi oriyingo. Nguro ngu, ene gome sobowooyingo. Naru oowooyingga, Herod ngu Yonro mandeni gome ingowero ingoro, ene nguro ingondudu kowuri urungga teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Kootuyisina, Herodiyas oore ngandiro ereweyingo. Herod enengo naru nemimbo bisiyoyingo naru nguro ingondudu tewero nguro ene oo simbo urungga kayingo. Nguno ngu, me oni tabango ururu, enengo Gabuman oni tabango ururu nguro nguya, Galili merako oni tabango ngu nguya mayero yowuruwooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ngu naruno nguno, Herodiyas namboni, ngundo ya newendemo omburo, ngu gome oorengo kunoyingo. Herodiyas nambonimbo yambono gome kunootoni, ene nguro gome ingoyingo. Ngundiro nguro, Herodndo bare buniyongga nguya eyingo. Ge oo guraro ingoya ngu, ge nono e. Ngundiro tetoyi, hamoo oorengo, no gunowano. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Herod ene sorumimonggo hamoo oorengo, ko eyingo. Ge komo nono oo gura nuno, ewaku ngu, no hamoo gunowano. Ge noro mera oo sitowine nga kewooro wesoowooya gidare no nuno, ero ewaku ngu, arisa, no mete ngundiro tero gunowano. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ngundiro etoni, baregaku mandeni ngu ingoro, nguro ene endesina oorero, nemimo sumoo eyingo. No ndawu oogaro ewano? Etoni, nemimbo gumi eyingo, Ge Sonoyeroyingo Oni, Yon, nguro tabangomboro e! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Arisa, bare buniyonggaku nemimboro mandeni ngu ingoro, nguro ene sodedo ko omburo, Herodno eyingo. No Yon tabango yowero ingoote. Anangu, ge Yon tabango toongooya, koondo samayi gurano yeya, yoya, ombuya, nonuno. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Arisa, Herodndo mandeni ngu ingoro, nguro ene newende ngu kowuri urungga ingoyingo. Ndadiro nguro, ene kuri mande yanggango sorumimonggo oni doongeyemo ero gosiyoyingo. Ngundiro nguro, ene bare buniyo nguro mandeni ngu ma yokowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Arisa, ngundiro nguro, Herodndo me oni gura soweyootoni, ya biyomimo oororo, Yon tabango toongooro, yoro ombuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Toongooro, koondo samayi gurano, Yon tabango yero, yoro, omburo, Herod inootoni, ngundo bare buniyonggaku inoyingo. Bare buniyongga, ngundo yoro, oororo, nemi inoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ngundiro tetoni, Yonro kirikiri oni mande binga ngundiro ingoro ngu, asa, ene omburo, Yon bingo yoro, saro merengooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ngu naruno nguno, Yisasro kirikiri oni kirarongo ko mayero, Yisasno yowuruwooro, simoo bareno ko tewonggoku nguro mandeni Yisasno wesiyoro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ngundiro tero, Yisasdo kirikiri onikuya eyingo. Oni simoo bare oowooyingga oorengo oororo, omburo tetoyi, nguro noore oo ma newato. Arisa, sodedomangge, noorengo nangge mera gura oni kini nguno saro, noore bodaga kengewato. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Etoni, nguro ene wanggo yoro, mera gura oni kini nguno sayingo. Enesu nangge kirikiri oniya nangge sayingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ene oni simoo bare oowooyingga oorengo yeyoro ingoyingo. Nguro oni simoo bare oowooyingga endeni endeni bidodo yondowidoro, ngu mera gidaresina nguno ene nguya saro, ene koretero, Yisasno tunooteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ene Yisas oororo, sono dabemimo mayero, wanggo gosiyoro, oni simoo bare oowooyingga yeyoyingo. Nguro ene nowoondoyi teyunoro ingoyingo. Ngu oni ngu Sipsip sobosobo kini, ero ingoyingo. Nguro ngu, Yisasdo mande damoni yero, mande oowooyingga oorengo ero etuyeroyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ngundiro tero oodoyi, sa uwero tetoni, Yisasro kirikiri oni Yisas tanggeyimo omburo eyingo. Nga merasina ngano oni kini. Ngundiro nguro, naru kiniteteku nga. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ge oni simoo bare nga sureyerootooga sayi. Ene mete ende namoko namoko ngano saro, nguno ene oowari uriyowanggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ene ngundiro etoyi, Yisasdo mande gumi eyingo. Yendo oowari yunowanggo. Eyingo. Etoni, enengo kirikiri oni enebana gumi eyingo. Ge, bine, noore oorowuya, digi doobeno nangge onibigado (Kina 200) oomanongoyingo uriyoya yunowooto? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ene ngundiro sumoo etoyi ngu, asa, Yisas enebana gumi eyingo. Ye oomanongoyingo ndadiro? Ye oorowuya kenoyi. Eyingo. Etoni, ene oororo, kenoro, gumi eyingo. Noore oomanongoyingo kandegura, ko, iso eraya nangge ooroote. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ene ngundiro etoyi, Yisasdo eneya gumi eyingo. Oni simoo bare ene mete tambuyi tambuyi so metemimo nguno bibiteyi. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Arisa, oni bibitewonggoku ngu, wata oowooyingga onibi eraya kande eraya (50), wata oowooyingga onibi kandegura (100), ngundiro bibiteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ene ngundiro bibitetoyi ngu, arisa, Yisas ene ngu oomanongoyingo kandegura, ko iso erayaga ngu yoro, ene sambono doongetero, Anutno esosootero yemboongeyingo. Yemboongero yokoro ngu, ene oomanongoyingo oososowooro, kirikiri oni kirarongo yunootoni, ngundo oni simoo bare bayetero yunoyingo. Iso erayagaku nguya ngundiro nangge teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ngundiro tetoyi, oni bidodo netoyi, kawuye ndinditeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Oni simoo bare oo ngu netoyi, oomanongoyingo sosorango, iso sosorango nguya oriyingoku, ngu yowuruwooro, si kande eraya kegidemboro eraya (12) siriyootoyi, si manggowoomo oorero angeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Oni ngu oomanongoyingo neyingo, simoo nangge oowooyingga oorengo (5,000). ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Kootuyisina, Yisasdo enengo kirikiri oni kirarongoku eririyeroro eyingo. Ye sodedo wanggo sanganimo ooreya, ye koreteya Galili sono koongeyingo andu, Betisayida mera gidaresina oorowutoyiga, nobana oni simoo bareno etoowe, satoyigogo oorowuwano. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ene ngundiro ero, oni simoo bare soweyerootoni, satoyi, Yisas enesu nangge mera purimo oorero, nguno Anutno yemboongewero nguro ene oriyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Suwootetoni, wanggo koongeyingo kewooroko oodoni, Yisas enesu nangge puri bodaga nguno yemboongero oriyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ngu naruno ngu, doogo urungga oorero, ngundo wanggo wenggerenggereyeroyingo. Ngundiro tetoni, ene de sosimbo sono sanggawero wanggo woosooro oorowuweroyi, ko yanggango oorengo teroruwonggo. Sengewero mera wendooketoni, arisa, Yisas ene Galili sono koongeyingo sanganiwoore kewoongoro, enengo kirikiri onino oororo, dagayerowero teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Enengo kirikiri onikundo Yisas kenootoyi, Galili sono koongeyingo sanganiwoore kewoongoro, eneno oorowuyingo. Oorowutoni, kirikiri onindo Yisas kenoro, oo gabogado, ero ingoro, nguro ene kimanggaru urungga teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Oni bidodo ngundiro tero, kenoro, sosoreyingo urungga teyingo. Ngundiro nguro, sodedomangge, Yisasdo eneya mande ero eyingo. Ye nowoondoye yanggango yeyi. Nondo nangge ombutenoku nga! Nguro ye ma sosorewero. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ngundiro ero, Yisas wanggo sanganimo ooretoni, ngu naruno nangge, doogogaku kiniteyingo. Ngundiro tetoni, nowoondoye sosorero, ingondudu urungga oorengo teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ndadiro nguro, Yisasdo oomanongoyingongga oni simoo bare yunowoku yanggangoningga nguro ma ingondudu teyingo. Kini, enengo nowoondoye ukingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ene Galili sono koongeyingonggaku usowooro, mera oowooyi Genesaret, ngu gidaresina mayero, wanggo gosiyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ene wanggo yokootoyi, sodedomangge oni simoo bare Yisas kenoro, ene ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ngundiro nguro, oni sodedomangge ende gurasina gurasina yondowidoro saro, ene sayi oni yoyoro, Yisas ndano oorooteku, nguno mayeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yo, hamoo, ende bobodi, ende ururu, ndawu meranggasina Yisas tunootetoni ngu, asa, ene sayi oni ende kewoorokono yoyeyingo. Ene ngundiro tero, Yisasno ngguyinggayitero, sumoo sumoo inoyingo. Ndadiro nguro, sayi onindo nangge kandeye Yisasdo nengguro dabemisina yetoyi ngu, asa, sayi oniku bidodo mete temukoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Mosesro mamana mande sobowooyingo oni, ngu oowooye Parisi oni gidarega, ko, mamana mande etuyeroyingo oni gidarega, ngundo Yerusalemnonggo omburo, Yisasya yowuruwooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ene Yisasro kirikiri oni gidega kandeye ma sonowooro oo dowooro, netoyi yeyoyingo. Parisi onindo yeyoro, nguro ene nowoondoye kowuri yero eyingo. Noorengo osisambananimboro muri ngundiro kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Parisi oni, Yuda oni bidodo, enengo osisambayeboro muriye keyeroro, kandeye gome ma sonowooro ngu, asa, ene oo ma dowooro newanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ngundiro nangge, ene oo uriyoweroyi musiyomo saro, ngunonggo mayero ngu, ene kandeye ma sonowooro ngu, asa, ene oo ma newanggo. Ene osisambayeboro mamana mande gura gura muri gidarega nguya keyoro, nguro ene sono toba, kumbe, koondo, oo ngu bidodo ngu muringga ewoku, ngu keyoro sonowooyingo.) ");
INSERT INTO rwo_rawa_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ngundiro nguro, Parisi oni, ko, mamana mande etuyeroyingo onikundo Yisas sumoo inoyingo. Ndadiro nguro, gengo kirikiri oni, ene osisambaro muri ngu ma keyootenggo? Enengo kandeye ngu sugabododo oo dowooro netenggo. Noorengo osisambananimboro muri yomburiyootenggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ene ngundiro etoyi, Yisasdo gumi eyingo. Anutro ingondudu eyingo oni Ayisayando yeya mibuye tegedodo, ero nakangoyingo. Ene mande ngandiro nakangoyingo. Ngu oni gidarega ngu, ene kingo manggoyemonggo no bingamine ero okootenggo. Enengo nowoondoyemo biyomi ingootenggoku, ngu muriyemonggo tunoo etuyerootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Nguro ngu, ene kingo nono yambo mande tetenggo. Ene oniro mamana mande nangge oni simoo bareno wesiyoro etuyerootenggoku ngu, ngundiro ngu godange ero eyingo. Noore Anutro mande nangge wesiyoro eteto. Ero eyingo. Ayisayando ngundiro nakangoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yisasdo eyingo. Ye Anutro mamana mande ngu andangero yokoro, ye oniro muriye ngu nangge, yanggango gome dowootenggo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yisasdo mande gura soweyoro eyingo. Yengo ingonduduye yowooraringoweroyi oni, Anutro mamana mande ngu andangero yokowero, gome ingootenggo. Yengo muriye ngu nangge keyootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Kurimi, Mosesndo Anutro mamana mande nguno eyingo. Ge mete gengo awanangge manggowo keyo. Oni gura enengo eweyi nemimboya mande biyomi ero ngu, asa, ene hamoo oorengo udoyi kumoowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ye Anut kootu inoro, ngandiro etenggo. Oni gurado digi beye oododo eweyi nemi hoorooweyeroweroyi, ene eweyi nemi erayagakuya ero ewa. Nga digi beyega nga ngu, no Anut inowero yewano, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ene ngandiro etenggoku, muri nenengo kini eyingo. Arisa, eweyi, nemi yomosiyoweroyi muri nguro gome ma ingootenggoku, nguro ye ganayeroya, eneno etoyiga ene ingoyi. Ngu muringga tetenggoku, ngu gome oorengo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nguro ngu, ye muri osisambayemonggo yoyingo ngu keyootenggoku ngu, ye Anutro mande ngu yeyi, kingo oo ngundiro tetenggo. Ye muri gura gura ngundiro oowooyingga tetenggo. Ye ngu mandega ngu ero etuyerootenggoku, ngu Anutro mamana mande toongootenggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yuda oniro muriye ngandiro. Oni sowe gura gura oowari oo dowootoyi, ngu oo ngu ma neyingo. Nguno Yisasdo oni simoo bare ko negoyeroro eyingo. Ye bidodo noro mande nga ingoya, nguro ingondudu teyi! ");
INSERT INTO rwo_rawa_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Oni gura goweyi sanganimo oo oorooteku, ngundo newendesina uro, ngundo oni yeni, ma biyomi yewa. Kini, muri biyomi oni newendemo oorooteku, ngundo endesina ooreteku, ngundo oni yeni, biyomi yewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Oni sodeyi mande ingoweroyi tetoningga ngu, ene komo nga mandega nga, gome ingoni. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ene oni simoo bare ngu yoyokoro, yano oorowuyingo. Enengo kirikiri onikundo ngu mande adingayingga, nguro sumoo inoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ene sumoo etoyi, Yisasdo gumi eyingo. Ye nguya ingonduduye kini? Ye bine ma ingootenggo? Oo bidodo oni endesina oorooteku, ngundo oni newendesina uro, ngundo oni yeni, ma biyomi yewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ndadiro nguro, oo ngundiro ngundo oni nowoondoye oorengomo ma ute. Kini, ngu enesu kawuyi newendemo uro, ngunonggo oorero toongete. Ngu mandega nguno, ngu Yisasdo oowari bidodo metemi eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ene mande gura soweyoro eyingo. Muri biyomi oni newendemo oorooteku, ngunonggo endesina ooreteku, ngundo oni yeni, biyomi yete. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","23","Muri biyomi oni newendemo oorooteku, ngunonggo ootoogero, endesina oorete. Ngu ngandiro. Ingondudu biyomi teweroyi muri; sebobarese teweroyi muri biyomi; yakaka teweroyi muri; oni ureyi kumooweroyi muri; oni bare gidarega yakakayi yodowooro yomburiyootenggoku muri; oo kenomayingootenggoku muri; muri biyomi gura gura; ebe ganagana mande teweroyi muri; godange mande teweroyi muri; manggo unggaranggara teweroyi muri; oo kenomayingoweroyi muri; yomooyinoro mande, sanggiri teweroyi muri; oni enengombo enengo ingootoni, urungga teteku nguro muri; wenonoyingo mande eweroyi muri; ngu muri biyomi ngu bidodo oni nowoondoyemonggo endesina tunootero, ooreteku, ngu bidodobo oni yeni, biyomi yete. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yisas ootoogero, ngu endega ngu yokoro, Tayiya ende, Sayidon merasina oorowuyingo. Ene oororo, ya gura newendemo uro, Yisas nguno kengewero ingoro kombitetoni, oni gurado nguno mayero ma kenowero, ero ingoote. Ene Yisas kombiteweroyi nguya ereremo kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Kini, sodedomangge bare gurado Yisasno, nguno oorooteku, ngu etoyi ingoyingo. Ngu barega ngu, ene namboni bodaga nguno oombooro biyomidodo ngu oruwo. Ngu barega ngu Girik barega ene ngu Saropinisiya merako mayero, nguno oruwo. Ngundo, ene Yisas oruwoku ngu ingoro, nguro sodedomangge ene yano omburo, Yisas keyi damonimo boodoo oondoogeyingo. Ene boodoo oondoogero, Yisasno ngguyinggayi tero, sumoo sumoo eyingo. Yisas gedo merambooro noro nambonemo oorooteku, ngu oweni, ero eyingo. Ndadiro nguro, ngu barega ngu newendemonggo hamoo ingoyingo, Yisas ene mete nambone yomosiyowa, ero ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yisasdo Yuda oniro ingondudu ngu ngandiro ingoyingo. Noore Yuda oni ngu noore oni oorengo, ero, oni sowe gidarega Yuda oni kini, ngu se ngundiro, ero ingootenggo. Nguro ngu, Yisasdo ngandiro eyingo. Noore simooye oowari yunootooye, nero yokootoyiga, kootuyisina gumi yoro, se yunowato. Simooye oo ma neyingomo oo ngu yoro, se ma inowato. Eyingo. Yisasdo ngu barega nguro newendemo hamoo teyingo, ngu towoongoro, nguro ene ngundiro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ene baregakundo Yisasro mande gumi eyingo. O Oni Urungga, ge hamoo ete. Ene sebo ngu oo neweroyi yaba newendemo simooyemboro oo sosorango, ngu netenggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ene ngundiro etoni, Yisas enebana eneya gumi eyingo. Ge ngundiro etekuro, arisa, ge mete oorowu. Merambooro biyomi ngu kuri namboge yokoro toongewo. Eyingo. Ndadiro nguro, Yisasdo enengo newendemo hamoo teyingo, ngu yanggango kenoro nguro ene mande ngundiro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Arisa, baregaku enengo yano ko oorowuyingo. Ene ko oororo, ene namboni yabano wetoro oodoni, kenowoku, oombooro ngu ene kuri yokowo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ngu naruno nguno, Yisas ko ootoogero, Tayiya mera yokoro, Sayidon mera nguya yokoro, yade mera gura oowooyi Dikapolis nguno oorowuyingo. Ngu merako nguno ende ururu kande eraya nguno oruwo. Ngu kewooroye oorengowoore yade oororo, Galili sono koongeyingo ngu tanggeyimo tunooteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Oni sowe gidaregado oni gura sodeyi tuwo ko mandeni moore nguya kini, ngu yoro, Yisasno mayeyingo. Mayero, ene Yisasno ngguyinggayi tero, sumoo sumoo inoro, ngu oningga nguno kandeyi yeya yeningga, mete teni, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Arisa, Yisasdo enengo mandeye ngu ingoro, nguro ene oninggaku yoro, oni simoo bare yoyokoro, songo oororo, nguno enesu nangge dikaworiyo. Dikaro, Yisasdo kandedibiyi ngu oningga ngu sodeyimo yeyingo. Yero, kandedibiyi yoro, muketero, oninggaku mebuyimo yeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Yero, Yisas sambono randoro doongetero, yanggango iyangero, newende sendoweroyi teyingo. Ene ngu oninggakuya enengo mandenonggo eyingo. Epata! Eyingo. Nguro muri ngu ngandiro. Ge goosoo! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Asa, ngu naruno nangge, oni sodeyigaku ngu himiyetoni, oo mebuyi gosiyoyingonggaku sodedomangge besero toongeyingo. Ene mete mande metemi eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ene mete tetoni, ene Yisasdo roogo yanggango teyunoyingo. Ene oni gurano nga ooga ngaro ma ewero. Ene Yisasro mande ma ingoro, ene yanggango yero, nguro muri wesiyoro, ero endeyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Yo, hamoo, simoo bare bidodo nguro mandeni ngu ingoro, ene hamoo sosoreyingo urungga oorengo tero, ene eyingo. Yisasdo oo bidodo tewoku ngu gome oorengo tete. Ene komo oni sodeye tuwo ngu tetoni, mande gome ingootenggo. Oni mandeye kini, ngu nguya mande gome etenggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ngu narunggano, nguno oni simoo bare oowooyingga oorengo yowuruyingo. Ene yowuruwooro, ene oowariye nguya kini. Ngundiro nguro, Yisasdo enengo kirikiri oniku negoyerootoni, ombutoyi eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","No nga simoo bare ngaro nowoondoyi teyunooteno. Naru kabusa noya oruwootoku, ene oowariye nguya kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ene oodooro kumootoyi, soweyerootoowe, enengo yano sawero saro ngu, asa, oorekono doongeye toongootoni, mera wongosogurumooro yurewa. Nguro ngu, oni gidarega ngu yowokononggo mayewonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ene ngundiro etoni, kirikiri onindo gumi sumoo eyingo. Nga mera gumisina ngano oni kini, nguro noore oowari ndanonggo yoro, oni simoo bare yunootooye newanggo? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ngundiro sumoo etoyi ngu, asa, Yisasdo sumoo gura yunoyingo. Ye oomanongoyingo ndadiro? Ero eyingo. Enebana gumi eyingo. Kandegura gidemboro eraya. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yisasdo mandeye ngu ingoro, nguro ene simoo bareya eyingo. Ye merakono bibiteyi, eyingo. Bibitetoyi, Yisasdo ngu oomanongoyingo kandegura gidemboro erayagaku yoro, Anutno yemboongero yokoro, oososowooro, enengo kirikiri oni yunoyingo. Yunootoni, ngundo bayetero, simoo bare yunoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ene iso bobodi gidarega nguya moore. Nguro ngu Yisas ene nguya yoro, Anutno iso nguro esosootero, yemboongero yokoro ngu, asa, ene kirikiri oniku iso yunoro eyingo. Iso nguya bayeteya, simoo bare yunoyi. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ngundiro yunootoyi, oo netoyi, mete tetoni, oo sosorango oodoni yowuruwooro, nguno ngu ene si kandegura gidemboro eraya siriyootoyi, angeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ngu oni ngu oowooyingga oorengo 4,000 oruwonggo. Ngundiro tero, Yisasdo oni simoo bare soweyerootoni, enengo endemo endemo sayingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ene ngu naruno, enengo kirikiri onidodo wanggo sanganimo oorero Dalumanuta merasina nguno sayingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Mosesro mamana mande sobowooyingo oni oowooye Parisi omburo, Yisasya mande gumi gumi ero ronggeyoro, Yisas towoongowero nguro ene sumoo eyingo. Sambo endeboro sunggi oorengo gura onindo ma teweroyi, ngu teya, etuyerootooga kenowooto, eyingo. Ngu kenoro, noore ingowato. Hamoo oorengo, ge Anut Nangoni oorengo yanggangonggedodo, ero towoongoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yisasdo mandeye ngu ingoro, nguro ene kowuri ingoro, yanggango yuka oorongooro eyingo. Ndadiro nguro, nga simoo bare nga narungga ngano oode sunggiro etenggo? No hamoo yeya eteno. No sunggi gura nga narungga ngano hamoo ma tewano. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ngundiro nguro, ene ko yoyokoro, wanggo sanganimo oorero, ene Galili sono koongeyingo gidaresina toongeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yisasro kirikiri oni oowari kabetero, oomanongoyingo ma yoro ombuyingo, ene oomanongoyingo guranangge wanggono oriyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ngu naruno nguno, Yisasdo mande yanggango eneya eyingo. Ye ingonda teyi! Parisi oni, Gabuman oni tabango urungga Herod ngundo oomanongoyingo yeni, koongeweroyi Yis, nguro gome doongeteyi. Enengo mandeye ngu Yis oomanongoyingo newendemo utoni, koongeteku ngundiro. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Enengo nangge ero ingoro eyingo. Ene ngundiro eteku ngu, ndadiro ngu, noore oomanongoyingo ma yoyingo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Asa, Yisas ene ingoro, nguro gumi eyingo. Ndadiro nguro, yengo nangge mande ngundiro etenggo? Noore oomanongoyingo kini? Ye, bine, ingonduduye kini? Ye bine kuri ma ingoyingo; ngundi, nowoondoye ukingoyingo, bine? ");
INSERT INTO rwo_rawa_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ye doongeyedodo, ye oo ma kenoyingo? Ye sodeyedodo, ye mande ma ingootenggo? Ye kabetetenggo, bine? ");
INSERT INTO rwo_rawa_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Kuri, no oomanongoyingo kandegura oososowoowonoku, oni oowooyingga oorengo 5,000 yunowonoku, nguro ngu gumi oodoni, ye si ndadiro siriyootoyi, manggowoomo oorewo? Eyingo. Etoni, enendo gumi eyingo. Kande eraya kegidemboro eraya. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Asa, Yisasdo mande gura soweyoro eyingo. Naru gurano, oomanongoyingo kandegura gidemboro eraya oososowoowonoku, oni oowooyingga oorengo 4000 yunowonoku, ngu gumi oodoni, ye si ndadiro siriyootoyi, manggowoomo oorewo? Ero sumoo eyingo. Etoni, enebana gumi eyingo. Kandegura gidemboro eraya. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ngundiro etoyi ngu, asa, Yisasdo sumoo gura ero yunoyingo. Ye ngu kenoro ma ingootenggo, bine? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yisas ko kirikiri oni nguya, ene Betisayidano oororo, tunooteyingo. Ngu oni simoo bare gidarega, ngundo oni gura yoro, Yisasno mayeyingo. Ngu oningga ngu, doongeyi kiringo. Nguro ngu, ene Yisasno ngguyinggayi tero, sumoo sumoo inoro eyingo. Ge kandege nga oninggano ngano yetooga mete teni, ero sumoo eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Arisa, Yisasdo mandeye ngu ingoro, nguro ene oni doongeyi kiringonggaku kandeyi dowooro yoro, ende yokoro, ende dabemimo ooreyingo. Yisasdo ngu oni doongeyinggakuno muketeyingo. Muketero, Yisas kandeyi ngu oninggakuno yero, sumoo inoro eyingo. Ge oo kenoote, bine? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ene ngundiro etoni, ngu oni doongeyi biyominggaku doongetero, gumi eyingo. No oni yeyootoowe ngu, de ngundiro tero, ene oororo omburo tetenggo. Oo gome ma kenooteno. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ngundiro etoni ngu, asa, Yisasdo kandeyi, oni doongeyi biyominggakuno ko yeyingo. Ngundiro tetoni, oni doongeyinggaku yanggango doongetero, metemi oorengo tero, oo bidodo gome tunoo kenoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ngundiro tero, Yisasdo ngu oninggaku soweyootoni, enengo yano oorowuyingo. Ene Yisasdo oninggakuya eyingo. Ge ende kewooroko sodedo ma uwero. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yisas enengo kirikiri oniya ootoogero, ende gura oowooyi Sesariya, gura oowooyi Pilipayi nguno sayingo. Saro, ooreko kirikiri oni sumoo yunoro eyingo. Oni simoo baredo noya ndawu oningga etenggo? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ene ngundiro sumoo etoni ngu, asa, kirikiri onindo Yisasno gumi eyingo. Oni gidaregado ngu geya ngandiro etenggo. Sonoyeroyingo Yon. Etoyi, ene oni gidaregado ngu ngandiro etenggo. Ge Ilayisa, Anutro ingondudu eyingo oni. Etoyi, ene gidegado ngu etenggo. Ge Anutro ingondudu eyingo oni gura, etenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ngundiro etoyi, Yisas enebana sumoo yunoyingo. Yendo ngu noya ndawu oningga etenggo? Eyingo. Pitando enengo mandeni ngu ingoro, nguro ene sodedomangge gumi eyingo. Ge Krayis, Anutdo noore yoyowero sunggi yeyingo oni. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ngundiro etoni, Yisasdo mande yanggango eyingo. Ye nga mandega nga onino ma ewero. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yisas damoni yero, kirikiri oni mande keta mesarango ngu ero etuyeroro eyingo. Oni Nangoni tunootewoku, ene komo oo bidodoboro ogingo urungga yowa. Tabango oni, Anutro wooro yeyingo oniro sobosobo mamana mande etuyeroyingo oni nguya, ngundo mandeni biyomi ero, kootu inoro, ureyi kumoowa. Ene naru kabusa oode, nguno ko ootoogewa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yisasdo ngu mandega ngu tunoo oorengo etoni, Pitando Yisas yoro, sosina oororo, damoni yero mamanangoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ngundiro tetoni ngu, asa, Yisasdo Pita kootu inoro, yowoorengoro, kirikiri oni yeyoro, Yisas enebana Pita mamanangoro eyingo. Pita, ge Setanro ingondudu ete. Setan, ge ombuya kootunesina oorowu. Ge Anutro ingondudu ma ingoote. Kini, ge oniro ingondudu nangge ingoote. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ngundiro ero, Yisasdo enengo kirikiri oni, ko, oni simoo bare nguya negoyerootoni, mayero, yowuruwootoyi, mande yunoro eyingo. Oni gura no kenerowero ngu, ene mete enengo ingonduduni bidodo yokoya, kowuri ene inootenggoku ngu de omukondi ngundiro koorowooya, no keneroya endeyoni. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Oni gura enengo ingonduduni yanggangoni gome dowooro, goweyi sugi oruweroyi ingooteku ngu, enengo ootootoni Anut doongeyimo hamoo oorengo oonootewa. Oni gura enengo ingonduduni ootootoni bidodo no nunoro ngu, ene ngunonggo mandene keta mesarango nguro ingoro, gome dowooro ngu, asa, ene mete kootuyisina sambo endemo sugi sugi keta oruwa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Oni gura mera ngaro oo bidodo yomukoro oode, kumoowaku ngu, ndawu oogado ene hooroowewa? ");
INSERT INTO rwo_rawa_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ngu oningga ngu, ene ndawu oogado enengo goweyi yanggangoni keta oruweroyi ngu uriyoro yowa? Oni gurado Anutro endemo oorowuweroyi oore ngu enengombo oo gurado hamoo oorengo uriyoweroyi kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ataga, oni simoo bare endeni endeni bidodomo erambarisa oruweroyi yomburiyoro, buribari endeyoro, muri biyomi nguro ingondudu tero, Anutro mande kootu inootenggo. Ene oni gura oni ngu kewooroyemo ootooro, ngunonggo noro mandene murine ero, oyimo yoro oorooteku ngu, arisa, kootuyisina, no nguya Awanemboro yanggangoni duridarini, sambono Engel oni kundingiyi, ngudodo ombutetoku naruno, no nguya, hamoo oorengo, ngu oningga nguya oyimo yowano. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ngu naruno nguno, Yisasdo eneya eyingo. Hamoo oorengo, no yeno eteno. Oni gidarega nga dikatenggoku nga, gumi ma kumooyingomo, Anutdo enengo simoo bare soboyerooteku naruno, enengo yanggangonidodo tunootetoni ye kenowanggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kootuyisina, naru kandegura gidemboro guranangge yokoro, Yisasdo Pita, Yemus, Yon, ngu oni kabusaga ngu yoyoro, mera puri piru ndandayingo awuno oorengonggano ooreyingo. Nguno oorero, enesu nangge oruwonggo. Ngu naruno, Yisas moondeyi ngu oni kabusaga doongeyemo yowoorengoro, Yisas enesu guradiro tunooteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Yo, hamoo, Yisasro towikumbani ngu soru ngundiro wadori, ko, sarayi oorengo tunooteyingo. Merako ngano oni gurado towikumbani oo ngundiro yeni, ma sarayi yewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ngu naruno, Ilayisa, Mosesya Yisas tanggeyimo tunootero, Yisasya mande etoyi, kirikiri oni kabusaga, ngundo ngu yeyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Pitando oo ngundiro kenoro, nguro ene soriyokoro, Yisasno ndawu mandega ewano, ero, ngu ma ingoyingo. Ngundiro nguro, ene Yisasno ngandiro eyingo. Oo etuyeroyingo oni, noore ngano oruweroyi ngu gome. Nguro ngu, gedo mete ero etoni ngu, asa, noore tookoododo kabusa yewato. Gura gengo, gura Mosesro, gura Ilayisaro yewato. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Pitando mande etoni ngu, asa, ngu naruno nangge, goboore gura tunootero, ngundo doobeyeroyingo. Doobeyerootoni, Anutdo ngu goboore kewoorokononggo tunootero ngandiro eyingo. Ngu nenengo nangone, no nowoondone nguro gome ingooteno. Ye enengo mandeni, ngu gome ingoyi! ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ene ngundiro etoni, asa, sodedo oorengo ene doongetero, Yisas enesu nangge oodoni kenoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Arisa, Yisas, enengo kirikiri onikuya, mera puringgaku yokoro, ko uyingo. Uro, Yisasdo mande yanggango ero eyingo. Ye awuno oo kenowonggoku, nguro oni gurano ma ewero. Anutro Nangoni Oni Kirarongo mere yokoya, ko ootoogetoninggago, asa, ye mete yootunoya eyi. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ene ngu mandega ngu gome dowooro, enengo nangge mande ero ingoyingo. Ngu mandega mere yokoro ko ootoogetoni, ngu ndadiro? Ero ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ngu naruno, Yisasro kirikiri onikundo Yisas sumoo inoyingo. Anutro mamana mande etuyeroyingo oni, ngundo ngandiro etenggo. Ilayisando, Anutro ingondudu eyingo oni, koreteyunoro ombuwa, ero etenggo. Ndadiro nguro, ngundiro etenggo? ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ene mande ngundiro sumoo etoyi, Yisasdo gumi eyingo. Hamoo, Ilayisa omburogogo, oo bidodo yomosiyowa. Ngu ndadiro nguro, Anut mandeno ngu mandega ngu ooroote? Ngu ene Oni Nangoni, ngundo oo bidodoboro ogingo urungga koorowootoni, onindo yomooyinoro mandeni biyomi ewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ene no yeno eteno. Ilayisa ene kuri ombuwo. Ene onindo ngu enengo ingondudu nangge keyoro, muri biyomi gura gura nguya ene teyinoyingo, Anutro mande nakayano ewoku, ngundiro teyinoyingo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yisas kirikiri oni kabusagakuya oororo, enengo kirikiri oni gidaregano tunooteyingo. Ene tunootero, yeyoyingo ngu oni simoo bare oowooyingga oorengo mayero, yowuruwooro, mamana mande etuyeroyingo oni gidarega, kirikiri oni nguya, mande gumi gumi ero ronggeyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ronggeyootoyi, oni simoo bare bidodo Yisas kenootoyi, ombutoni, sodedomangge soriyokoro, yondowidoro, Yisasno oororo, yenggonangoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ene ngundiro tetoyi, Yisasdo enengo kirikiri oniku sumoo yunoyingo. Ye ndadiro mandega eneya ero ronggeyootenggo? ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ngundiro sumoo etoni, ene oni gura ngu oni simoo bare ngu kewooroyemonggo, Yisasro mande gumi eyingo. Oo etuyeroyingo oni urungga, no nangone, oombooro biyomi, ngundo newendemo ootooro, ngunonggo manggowo witumoororoote. Ngundiro nguro, no ngu yoro, geno ombuteno. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Naru oowooyingga ngu, oombooroga, ngundo yanggango biyomi dowooro ooroote. Ene merako wenggeremootoni sorero, ooroote. Kooto sarayi ngu manggowoomo nguya ooretoni, metoyi gome kini ndinditero, moondeyi sagaga tewa. Nguro ngu, no gengo kirikiri onino ngu oweyi, ero etoowe, ene ngu oombooroga ngu andangeweroyi nguya ereremo kini. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yisasdo ngu mandega ngu ingoro, enengo kirikiri oni, ko, simoo barekuya eyingo. Ye simoo bare nowoondoyemo hamoo kini! No yeya naru pirungga oorootetoku, ene naru ndadiro ngu yengo kowuriye koorowoowanggo? Arisa, ye simooye bodaga ngu yoya, nono ombuyi. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ene ngundiro etoni, onikundo ngu simoonggaku yoro, Yisasno ombuyingo. Ene ngu oomboorogakundo Yisas kenoro, sodedo oorengo ngu simoo oorenggaku, newendemonggo yanggango oorengo wenggeremootoni, simoonggaku merako ukero, wetoro, nguno yowooraringoro, sagaga tero, koodoo sarayi manggowoomonggo ooreyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ene ngundiro tetoni ngu, asa, Yisasdo eweyi sumoo inoyingo. Naru ndadiro ngundiro teroruwo? Etoni, eweyimbo gumi eyingo. Kuri ene bodagano damoni yero ooroote, eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Naru oowooyingga, oombooro biyomi, ngundo simooyengga nga wenggeremootoni, de nombono, sonono nguya uro, ureni kumooweroyi teroroote. Ge mete tetoningga ngu, ge nowoondoyi teyunoya, ge noore hoorooweyero. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ene ngundiro etoni, Yisasdo simooyengga ngu eweyimboya eyingo. Ataga, ge noya ngandiro ete. Ge mete tewa tetoni, ngu ge no nangone yomosiyo. Ndadiro nguro, ge ngundiro ete? Oni nowoondoyemo hamoo Anutno yero ngu, asa, ene mete oo bidodo teweroyi ingowa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Yisasdo ngundiro oo etoni, asa, sodedo oorengo, oni eweyingga ngundo meno ero eyingo. No nowoondonemo hamoo tete. Ene noro nowoondone hamoo ngu ootuwoo! Nguro ngu, ge no hooroowenero! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Etoni, Yisasdo yeyoro ngu oni simoo bare oowooyingga oorengo mayero, yowuruwootoyi, nguro ngu, ene ngu oombooroga nguya sanggiri tero, kenoro eyingo. Ge oombooro manggowo sodeyi ukingoyingo, no geya eteno. Ge nga simooyengga nga yokoya, kootuyisina, ge ene newendemo ko ma uwero! Ngundiro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Arisa, ene ngundiro etoni ngu, simoo ooregaku newendemonggo oomboorogaku ki biyomi ero, oninggaku yanggango oorengo wenggerenggeremoyingo. Ngundiro tero, oninggaku yokoro, besero toongeyingo. Oombooro toongetoni, oninggaku gaboyi kumooyingo. Gaboyi kumootoni, oni oowooyingga nguro eyingo. Oni kuri kumooteku nga! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ene ngu naruno, Yisasdo kandeyimonggo dowooro okootoni, ko ootoogero dikayingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Kootuyisina, Yisas enengo kirikiri oniya ya gurano uro, nguno enesu nangge ootooro, Yisasno sumoo eyingo. Ndadiro nguro, noore ngu oombooroga ngu oweweroyi ma ingowooto? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ene ngundiro sumoo etoyi, Yisasdo gumi eyingo. Anutno yemboongetoyi ngu, ngundiro oombooro biyomi ngu ye mete andangetoyi toongewa. Oore gurano ngundiro mbooro biyomi ngu ma andangetoyi toongewa. Kini, Anutno yemboongero andangeweroyi ngu mete. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Ene ngu endega ngu yokoro, oororo, Galili mera kewoorokuri oorowuyingo. Ndadiro nguro, Yisas enengo kirikiri oni etuyeroweroyi naruno, nguro ngu, Yisasdo enengo kirikiri oni nguya kombitero, Anutro mande etuyerowero eyingo. Oni Nangoni, ngu mundi oni kandeyemo yetoyi, ngundo ureyi kumoowa. Ureyi kumootoni, naru kabusa yokoro, ene ko ootoogewa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ene mande ngundiro etoni, ene kirikiri oni ngu mandega, ngu muri ma ingoro, nguro ene sumoo inoweroyi nguya sosoreyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Arisa, ene Kapeniyam endemo tunooteyingo. Ene ende oororo, ya newendemo uro, arisa, Yisasdo kirikiri oni sumoo yunoro eyingo. Ye oorekono ndawu mandegaro ewonggo? Ero sumoo eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ene sumoo ngundiro etoni, ene kirikiri oni mande gumi ma eyingo. Ndadiro nguro, kirikiri oni oorekono oororo, mande ngandiro ero ingoyingo. Onendo koreteyingo urungga oruwa? Ewonggoku nguro ene oyimo yoro, Yisasno mande gura gumi ma eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yisas enengo ingonduduye ngu kuri ingoro, nguro ene bibitero, kirikiri oniku, kande eraya kegidemboro erayagaku negoyerootoni, ombutoyi eyingo. Oni gurado koreteyingo oruwero, ingoro ngu, asa, ene komo omburo kootu tero, oni bidodoboro kirikiri oni tero oruwa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Yisas ngundiro ero, simooye gura bodaga yoro, kewooroyemo yero, ngunonggo okooro boogomooro, enengo kirikiri oni kirarongo nguno eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Oni ene no oowoonemboro ingondudu tero, ene oni simooye ngandiro bodaga yoro, hooroowewaku ngu, ene no hoorooweneroote. Oni ene no hoorooweneroro ngu, ene no, ko, noro Awane no sowenerootoni, ngano ombuwono, ngu ene nguya hooroowewa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yondo Yisasno eyingo. Oo etuyeroyingo oni, noore oni gura kenootooye, ene gengo oowoonggemo merambooro oweyerootoni, ngu noorengomu kini. Ngundiro nguro noore ene roogo teyinowooto. Ndadiro nguro, ene gengo kirikiri oni kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ene ngundiro etoni, Yisasdo gumi eyingo. Ye ma roogo teyinowero. Ene oni gura no oowoonemo muri songo oorengo gura onindo ma teweroyi, ngu tewaku ngu, ene noya mande biyomi sodedo ma ewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ndadiro nguro, oni gura nooreya sanggiri kini, ngu noorengo doboonani ngundo noore hoorooweyerowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","No hamoo oorengo yeno eteno. Krayis oowooyimo, hoorooweyerowo ero ingoro, sono tobano ye yunowaku ngu, arisa, ngu oningga, nguro Anutro uri, ngu hamoo oorengo, ene Anutro endemo sugi sugi ngundiro urini yororuwa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yisasdo kirikiri onino mande gura eyingo. Oni gurado simooye nga noro nowoondoyemo hamoo ingoro oorootenggoku, nga gura yoro, newendemo hamoo ingooteku, ngu yomburiyowaku ngu, enengombo muri biyomi tewoku nguro gumi ogingo urungga oorengo yowa. Arisa, ngu oningga, ngu enengombo ngundiro tewoku, nguro mete ngu digi urungga yoya, ngundo bungeyimo gosiyoya, yoya, sono koongeyingo urungga ngu kewooroko oorongootoyiga uni. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ge kandegebo weti mbumbuwa gura tetoningga ngu, ge mete toongooya, andangeya, oorongooga uni. Kandege guranangge, ngundo mete keta oruweroyi gome ngu yowa. Kinitetoni, ge kandege eraya eraya oodoni, ngundo goyoro, ende biyomi de nombono ma kumooweroyimo nguno oorongoonggerowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ngu endega nguno, bunimbo suwooyi sano oni goweyi songgiwi nero, oodoni, oninggaku ogingo urungga ingoro, sugi sugi oruwa. Enendo de nguya ma wemoowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ngundiro nangge, kengge gurado mbumbuwano goyoya, utoningga ngu, arisa, ngu kengega ngu toongooya yoko. Ngundiro tero, ngu ge mete keta oruweroyi gome ngu yowa. Kengge eraya eraya oodoni ngu, ngundo goyoro, ende biyomi de nombo ma kumooweroyimo, endegano nguno oorongoonggerowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ngu endega, nguno bunimbo suwooyi sano oni goweyi songgiwi nero oodoni, oninggaku ogingo urungga ingoro, sugi sugi oruwa. Enendo de nguya ma wemoowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ngundiro nangge, ene doongenggebo weti mbumbuwa gura tetoningga ngu, ge mete ngu doongenggega ngu yowukeya, oorongoongga uni. Ge doongengge guranangge, ngu ge mete Anutro mande mande murini nguno uwa. Ge doongengge eraya eraya oodoni ngu, ngundo goyoro, ende biyomi de nombo ma kumooweroyi oorengo (Hel) nguno oorongoonggeroni uwa. Anutro Mandeno ngandiro ete. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ngu endega, nguno bunimbo suwooyi sano oni goweyi songgiwi nero, oodoni oninggaku ogingo urungga ingoro, sugi sugi oruwa. De nguya ma wemoowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Kumbe gura dowooro yetoyi, ngu gagiwi kini. Arisa, gagiwi yero, ariyetoni, de koondodongoombo boosowootoyi, yanggango oorengo yeteku ngundiro. Towootowoo omburo, ngundo oni yeni, kumbe boosowootoyi, yanggango yeteku, ngundiro tewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Anutro mande keta gome, ngu sayi nembo ngundiro. Sayi nembo ngu oo gome. Ene sayi nembo, nguro yanggangoni kuri kiniteyingo ngu, ye ndadiro tetoyi, ngu sayi nembo ngu ko mete tewa? Sayi nembo ye nowoondoyemo oorooteku ngu, ye komo dobookuriyeboya gome oorengo imakeyingomo bibiteya oriyi. Ngundiro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ngu naruno nguno, Yisas ootoogero, ngu endegaku yokoyingo. Endegaku ngu yokoro, ene Yudiya mera Yodan sono anduroko urooreyingo. Urooretoni, ngu naruno, Yisas tanggeyimo oni simoo bare urungga oorengo yowuruwooyingo. Ngundiro yowuruwootoyi, Yisasdo enengo muri ngu keyoro, Anutro mande oni simoo bare etuyeroro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ngu naruno, Parisi onindo Yisasno omburo, Yisas dowooro urewero nguro ene Yisas towoongoro sumoo eyingo. Noorengo Mosesro mamana mande ngu oni ene mete bareyi andangewa, ero mete ete, ngundi kini, bine? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ngundiro etoyi, asa, Yisasdo enengo mandeye ngu ingoro, nguro ene Parisi oniro sumoongga ngu gumi eyingo. Mosesndo ndadiro mamana mandega ye yunoyingo? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ene ngundiro sumoo etoni, enebana gumi eyingo. Mosesndo ngu oni ene bare andangeweroyi so uyi ngu nakangoro ngu, ene mete bareyi andangero yokowa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ngundiro nguro, Yisasdo Parisi oniro mandeye gumi eyingo. Ye mande unggarangooro yanggayanggango yetoyi, nguro Mosesndo ngu mamana mandega ngu nakangoro yunoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Koretero oorengo, Anutdo oo bidodo yemukoro, ene oni simoongga ko barega nguya yoyeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ngundiro nguro, simoo ene eweyi nemi yokoro, bareyiboya naru bidodomo, ebe dowoodowoo tero, yowuruwooro oruwari. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ngundiro nguro, erambarisa ngu ene goweyari guranangge. Ene ko goweyari eraya kini, ngu goweyari guranangge ngundiro. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nguro ngu, Anutdo oo gosiyowoku ngu, onindo ngu ma toongoowanggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Kootuyisina, ene yano ko oorowutoyi, kirikiri onikundo nga mande ngaro damonimboro Yisas sumoo inoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ngundiro etoyi, Yisasdo gumi eyingo. Ene oni gurado enengo bareyi yokoro, bare gura yowaku ngu, asa, enengo bareyi koretero ngu yomburiyoro, ene weti mbumbuwa tete. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ngundiro nangge, bare gurado enengo kameyi yokoro, simoo gura yowaku ngu, enengo kameyi koretero ngu yomburiyoro, ene weti mbumbuwa tete, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ngu naruno, oni simoo bare enengo simooye bobodi gidarega yoyoro, Yisas tanggeyimo mayeyingo. Ngundiro yoyoro, mayetoyi, enengo kirikiri onindo simooye yoyoro, ngano ma ombuwero, ero, manggaruyeroro oweyeroyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yisasro kirikiri onindo ngundiro tetoyi, yeyoro, nguro Yisas newende biyomi ingoro, enengo kirikiri onikuya eyingo. Ye simooye bobodi yoyokootoyiga, nono ombuyi. Ye ngu ma oweyerowero. Anut Oo Bidodo Simburi Simbunani, ngundo endega enengo oni simoo bare soboyerooteku ngu, ngu simooye ngundiro ngundo uwanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","No hamoo oorengo yeno eteno. Oni gura Anut Oo Bidodo Simburi Simbunani, ngundo enengo simoo bare soboyerooteku endega, nguno simooye nowoondoyi ngundiro ma tero ngu, asa, ene nguno hamoo oorengo ma uwa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ngundiro ero, Yisasdo simooyeku yodowooro, boogoyeroro, kandeyi tabayemo yero, kumana yunoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ngu naruno, Yisas ootoogero oorowutoni, oni gura kendutero ombuyingo. Omburo, Yisas tanggeyimo boodoo oondoogero, sumoo eyingo. Oo etuyeroyingo oni gome, no ndadiro terogogo, no suwooyi sano keta oruweroyi, ngu yowano? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ene ngundiro sumoo etoni, Yisasdo gumi eyingo. Ndadiro nguro ge noya oni gome ete? Anut enengombo nangge oni gome nenengo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ge Anutro mamana mande kuri ingoote. Ge oni ma ureyi kumoowero; ge bare gidarega yakakayi yodowooro yowoosooro ma yomburiyowero; buribari nguya ma endeyowero; ge yakaka ma tewero; ge oni gurano mande godange ma ewero; ge godange ero, oni guraro oo sitowini ma sobiyoro yowero; ge awanangge tanggeyemo gome ootooya, nguro manggoye keyoya ootoo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Yisasdo ngundiro etoni, ngu oningga ngundo Yisasno gumi eyingo. Oo etuyeroyingo oni, no kuri bodagano, ko, ataga nguya, no ngu mamana mande ngu bidodo keyoro, omburo, oorooteno. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ene ngundiro etoni, Yisasdo ene kenondadangero, oningga, nguro nowoondoyi urungga oorengo tero, nguro gome ingoro, ngu oningga nguya eyingo. Ge oo guranangge ma teyingo. Ge oorowuya, gengo oo sitowi bidodo onino uriyoya, ngunonggo beye yoya ngu, asa, beye ngu angoyi oni ngu bayeteya yuno. Ngundiro tero ngu, asa, gengo oo gome oorengo ngu sambo endemo ooroote. Ge ngundiya teya ngu, asa, ge ombuya, no keneroya endeyo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ngu oningga ngu mandega ngu ingoro, omukumundoongo biyomi bisiwero, newende nguya kowuri yeyingo. Ndadiro nguro, enengo sitowini urungga ngu yokoro, oni yunoweroyi kini. Nguro ngu, ene ootoogero toongeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ngundiro tetoni, ene Yisas doongetero, endeyoro, enengo kirikiri onino eyingo. Oni sitowidodo ngu, ene Anut Oo Bidodo Simburi Simbunani, ngundo endega enengo simoo bare soboyerooteku, ngu newendesina uweroyi nguya, kowuri oorengo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ngundiro etoni, enengo kirikiri oniku ngu ingoro, nguro ene soriyokootoyi, Yisasdo mande soweyoro mande gura eyingo. Ye simoone, oni Anut Oo Bidodo Simburi Simbunani, ngundo endega enengo simoo bare soboyerooteku, ngu newendesina uweroyi nguro koyi, ngu kowuri oorengo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Yo, hamoo, bo urungga nga ngu nggusiyi newendekuri uweroyi ngu kowuri, beye sitowinidodo oni ngu Anut Oo Bidodo Simburi Simbunani, ngundo endega enengo simoo bare soboyerooteku nguno uweroyi nguya ngundiro kowuri oorengo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yisas enengo kirikiri oniku mandeni ngu ingoro, nguro ene sori urungga tero, enengo nangge mande ero ingoro eyingo. Hamoo, onendo suwooyi sano keta oruweroyi, ngu mete yowa? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ngundiro sumoo etoyi, Yisasdo gome gome yeyoro, mande gumi eyingo. Anutdo oni ma hooroowetoni ngu, asa, oni enesu nangge, oo yanggango ngu hamoo ma tewa. Kini, Anutdo oniya ootooro, ngunonggo ene mete oo yanggango ngu bidodo hamoo oorengo tewa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Yisasdo ngundiro etoni, asa, Pitando mande gura Yisasno eyingo. Ingo, noorengo ya, ko, sitowi bidodo kuri yokoro, noore ge kengeroro, endeyootetoku nga! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Ngundiro etoni, Yisasdo gumi eyingo. No hamoo oorengo yeno eteno. Oni bidodo songo songomo ene noro ingoro, Anutro Mande Keta Mesarango nga ingoro, ngu wesiyoro eweroyi nguro enengo ya, konebaye, kuwookuwooye, awanamoye, enengo oowari koye nguya, yoyokowanggoku ngu, asa, oo bidodo ene kuri yokowonggoku, nguro gumi ngu dagaro urungga yowanggo. Yo, hamoo, ngu ketangga, nguno enengo ya, konebaye, kuwookuwooye, awanamoye, oowari koye nguya, urungga oorengo yowanggo. Ene ye no oowoonemo ko tewanggoku ngu, oni gidaregado noro ma ingootenggoku, ngundo muri biyomi ngu ye teyunowanggo. Ene kootuyisina ngu, suwooyi sano keta oruweroyi, ngu yowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ene oni gurado koreteyingo oruwero ewaku ngu, ene omburo, kootu tero, oni bidodoboro kirikiri oni tero oruwa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ene Yerusalem oorowuwero Yisasdo oore keyoro, koretero oorowuyingo. Ngundiro oorowutoni, enengo kirikiri oniku keyoro, oororo, nguno ingondudu urungga tero soriyokoyingo. Ngundiro tetoyi, oni simoo bare oowooyingga ene keyeroro oorowuwonggoku, ngundo sosoreyingo. Nguro ngu, Yisasdo enengo kirikiri oni kande eraya kegidemboro erayagaku yoyoro, songo oororo, enengo goweyimo oo tunooteweroyi, nguro mande yunoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ene ngandiro eyingo. Ingoyi, ataga noore Yerusalem endemo ooretooye, nguno Oni Nangoni, ngu Yudaro yowuru yaro tabango oni ururu, ko, mamana mande etuyeroyingo oni nguya kandeyemo yewa. Ngu oni ngundo, mande guranangge urewero mande ero gosiyoro, oni sowe gidaregaro Gabuman oni kandeyemo yewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Yetoyi, ngundo ngu yomooyinoro, mukendoro, gisaruboro utoro, ureyi kumoowa. Ene naru kabusa yokoro, ene ko keta ootoogewa. Yisasdo ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sebedi simoongo erayagaku, Yemus, Yon, ngundo Yisasno omburo sumoo inoro eworiyo. Oo etuyeroyingo oni, noore oo guraro ge sumoo gunowero. Ge ngu ooga ngu noore teyuno. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ngundiro etori, ene mandeyari gumi eyingo. Nondo ndawu ooga yari teyunoowe? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ngundiro etoni, erayagakundo gumi ewori. Ge nooreno rogo ye. Kootuyisina, gengo yabage duridarinidodo nguno bibitetoyi, noore gurado kandege koondosina, gurado kandege biyomisina, nguno bibitewaro. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ene ngundiro sumoo etori, Yisasdo mandeyari gumi eyingo. Yari ngu ooga nguro nono sumoo eteriku, nguro muri ma ingooteri. Yari bine, nondo tobaga sono netenoku, nguno yari nguya sono newari, bine? Ngundiro nangge, yari sono kundingiyi gimutenoku, ngu yari nguya, bine, mete ngu sonongga ngu gimuwari? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ngundiro etoni, kirikiri oni erayaga ngundo mande gumi ewori. Noore mete, etori, Yisas enebana eyingo. Hamoo oorengo, ngu tobaga no sono netenoku, ngu yari nguya sono newari. Ngu sono kundingiyingga nondo gimutenoku, ngu yari nguya gimuwari. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ene onendo kandene koondosina, kandene biyomisina bibiteweroyi ngu, nondo ma ewano. Ndadiro nguro, Anut enengombo nangge, ene kuri oni yunowero nguro ene yomosiyoyingo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ene kirikiri oni kande erayagaku mande ngu ingoro, ene Yemus, Yon erayaga nguya, sanggiri oorengo teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ngundiro tetoyi, Yisasdo negoyerootoni, eneno ombutoyi eyingo. Oni sowe gidaregaro tabango oni ngu, ene yanggangoyedodo tero, dobookuriye soboyeroweroyi, nguro mamana mande enengo oni ururu ngundo etoyi, ngundiro yanggango soboyerootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ene ngu muringga ngu ye kewooroyemo ma oruwa. Hamoo oorengo kini. Ene ye kewooroyemo oni gurado urungga oruwero tewaku ngu, asa, ene yengo kingo kirikiri oni tewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Oni gura ene yengo koreteyingo oruwaku ngu, asa, ene oni ngu bidodoboro kingo ko oni tero oruwa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ndadiro nguro, Oni Nangoni, nguya onindo ko teya, hoorooweyi ero, ma ombuyingo. Kini, ene ngu oniro ko tero, oni hoorooweyeroro, enengo keta oruweroyi, ngundo simoo bare bidodo weti mbumbuwanonggo, ko uriyerowero ombuyingo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ngu naruno, ene Yeriko endemo mayero, ko, Yeriko dagaro, Yisasro kirikiri oni, oni simoo bare gidarega nguya, ngundo Yisasdodo sawero teyingo. Nguno, Timiyasro nangoni Batimiyas, ngu doongeyi kiringo yeyingo, ngundo oore dabemimo bibitero oriyingo. Ene suwooyi sano oni simoo bareno digi beye ooro ngguyinggayi tero, sumoo sumoo eroruwo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ngu oningga ngundo ingootoni, Yisas Nasaret oni ngu namoko ombutoni, ingoro, damoni yero, ene meno yanggango ero eyingo. Yisas, ge Dewitro sembeni, ge noro nowoondoyi tenuno! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Oni simoo bare oowooyingga oorengo sanggiritero kenoro eyingo. Ge ari yoko! Etoyi, ene oningga ngu ingoro, ene manggaru urungga tero eyingo. Dewitro sembeni, ge noro nowoondoyi tenuno! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Arisa, Yisas enengo mandeni meno ewoku, ngu ingoro, nguro ene omburo dikaro eyingo. Oningga ngu negongootoyiga ombuni, ero etoni, oni songokundo, ngu oni doongeyi kiringonggaku negongoro eyingo. Yisasdo ge negogeroote. Nowoondoge metemi ingoya, sodedo ootoogeya ombu! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Arisa, oni doongeyi kiringonggaku meno ngu ingoro, nguro enengo dogigiro nenggurogaku oorongooni, utoni, sodedo ootoogero, dikaro, Yisas tanggeyimo oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Oorowutoni, Yisasdo oni doongeyi kiringonggakuya sumoo eyingo. Nondo ndawu ooga tenggunowano? Etoni, ngu oni doongeyi kiringongga, ngundo gumi eyingo. Oo etuyeroyingo oni urungga, no doongetewero ingooteno. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ngundiro etoni, Yisasdo ngu oni doongeyi kiringongga nguya eyingo. Ge mete oorowu. Ge noro nowoondogemo hamoo teyingo, ngundo doongengge yeni, metemi tete. Etoni, ngu naruno nangge, oni doongeyingga, ngu metemi teyingo. Ngundiro tetoni, ene doongetero, mera kenoro, ene oorekononggo Yisas keyoro, toongeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yisas ko enengo kirikiri oni nguya Betipas, Betanino ngu, ende bobodi erayaga ngu, Olib puri ngu damonimo, ngu Yerusalem tanggeyimo oruworiku nguno tunooteyingo. Nguno Yisasdo enengo kirikiri oni kirarongo eraya sureyeroro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Yari andu endega namokono kenooteriku, anduno sodedo oorowuya, Hos gura oowooyi Donggi. Ngu nangoni duriyoga gosiyootoyi oorooteku, ngu wesiyoya, yoya omburi. Oni gurado kuri nguno ma bibiteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ene oni gurado yarino sumoo yunoro ewa. Yari ndawu ooga tewero, etoningga ngu, asa, yari ngandiya eri. Oo Bidodo Simburi, ngundo Donggi nga ko inoro, ko sodedo soweyootoni ombuwa, eya eri. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ngundiro etoni, arisa, erayaga ngu oororo, Donggi duriyoga ngu oore oorowuweroyisina nguno endesina yamuko dabemimo gosiyoyingo ngu kenoyingo. Ngundiro kenoro, erayaga, ngundo Donggi ngu uto wesiyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ngundiro tetori, oni namoko dikayingo, ngundo erayaga nguno sumoo eyingo. Yari ndawu ooga tewero Donggi duriyoga ngu uto wesiyooteri? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ngundiro sumoo etoyi, kirikiri oni erayaga, ngundo eworiyo. Yisasdo ngaro ewo, ero etori, nguro ene yokoro sayingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Arisa, erayagaku Donggi duriyogaku yoro, Yisasno ombuworiyo. Ngundiro tero, erayagakundo enengo dogigiro nengguro andangero, Donggi sanganimo yomitori, Yisas ngu sanganimo bibiteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ngundiro bibitetoni, oni simoo bare oowooyingga oorengo enengo dogigiro nengguro andangero, oore sanganiwoore yomiro yomiro oorowuyingo. Ngundiro tetoyi, gidaregado kono oororo, de duwoo toongooro, omburo, oore sanganiwoore yomiro oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ngundiro tero, simoo bare koretetoyi, gidarega kootu tero oororo, ene meno moguru tero eyingo. Sugi sugi oruwa! Hosana! Anutdo ene mete kumana nga oningga, nga inootoni, ngu Oo Bidodo Simburiga, ngu oowooyimo ombuteku nga! ");
INSERT INTO rwo_rawa_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Noore Yisas bingami ero okoowato! Ene osinani, Dewitro naruni ngundiro noore soboyerowero ombuteku nga! Hosana, awuno oorengo! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Asa, Yisas Yerusalem endemo uro, Yudaro yowuru ya oowooyi Tembel ngu newendemo uyingo. Yisas oo bidodo kenondadangero yokoro, suwootetoni, Yisas enengo kirikiri oni kande eraya kegidemboro erayaga nguya Betani endemo oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Sengetoni, Yisas enengo kirikiri onikudodo Betani ende yokoro, omburo, yade oorekono Yisasdo oodooro kumooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Yisasdo de gura oowooyi Pik, ngu de gudo, kukunga ningguri ngundiroga, ngu oriroko kenoyingo. Uyi oowooyingga tutu ureyingo, ene enggeboro doongetewero namoko de damonimo oororo doongetero, engge gura ma kenoyingo. Kini, uyi nangge oriyingo. Ndadiro nguro, de Pik enggeweroyi naruni kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yisasdo ngu degakuya eyingo. Kootuyisina, onindo gengo tanggorige ko ma yoro newanggo. Ngundiro etoni, enengo kirikiri onindo ngu mandega ngu ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yisas enengo kirikiri oni nguya Yerusalem endemo oorowuyingo. Nguno Yisas oororo, Yuda oniro yowuru ya oowooyi Tembel newendemo uro, yeyootoni, oni Tembel yano digi beye yowoorengoweroyi koyi tetoyi, nguro ene damoni yero oweyeroyingo. Ngundiro tero, Yisasdo yeyootoni, oni digi beye gura gura yowooraringoro, bayetetoyi, ngu yeyoro, yabakudodo wenggeremootoni, ukero uyingo. Ngundiro nangge, oni nu mumukondiri ngu uriyowero koyi nguya teyingo nguro yabaye nguya wenggeremootoni, ukero, utoni oweyeroyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Yisasdo roogo tero mamanayeroro eyingo. Ye oo gura gura yoro, Tembel ngaro pawa newendekuri ngando ma oororo, omburo tewero, eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Arisa, Yisasdo oni ngu mamanayeroro mande gura eyingo. Anutro mande nakangoyingo, ngundo ngandiro ete. Noro ya ngu oni simoo bare sowe mera bidodomo oorootenggoku, ngundo oowooyi yemboongeweroyi ya, ero ewanggo. Ene yendo ngu yeyi, yakaka oniro kombiteyingo musiyo tetenggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Yudaro yowuru yano Anutro wooro yeyingo oni nguro sobosobo oni, ko, Anutro mamana mandero etuyeroyingo oni, ngundo Yisasro mandeni ingoro ngu, arisa, ene damoni yero, Yisas ureyi kumoowero nguro ene oore ereweyingo. Ndadiro nguro, oni simoo bare oowooyingga Yisasro mandeni ingowero gome ingootenggo. Ngundiro nguro, Parisi onindo Yisasro koni ngu kenomayingoro, nguro ene Yisas dowooro ureyi kumoowero nguro hahangeyingo. Ndadiro nguro, oni simoo bare bidodo Yisasro mandeni nangge ingowero ingootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Suwootetoni, Yisas enengo kirikiri oni, ngudodo Yerusalem ende yokoro sayingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Suwoononggo oorengo, Yisas, enengo kirikiri onidodo ko oororo, Pik dega ngu kenowonggoku, ngu kuri kumooni yewo. Yo, hamoo, uyi huri oo ngu bidodo kuri ariyero, kumooni yeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pitando ngundiro kenoro, Yisasdo Pik dega nguya kuyowo mande ewoku ngu ingoro, Yisasno eyingo. Oo Bidodo Simburi, keno! Nga Pik dega nga gedo kuyowo kowuri eneno yewoku, nguro kuri kumoowoku nga! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ngundiro etoni, Yisasdo mande gumi eyingo. Ye komo Anutro nowoondoyemo hamoo teyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","No hamoo oorengo yeno eteno. Ye ngandiya ingoyi! Oni gura ene newende tege eraya kini ngunonggo mera puringga ngaya ewa. Ge ootoogeya, ukeya, wendeyimo u, ero ewaku ngu, asa, hamoo oorengo, enendo ewoku, ngundiro tunootewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Arisa, no hamoo oorengo yeya eteno. Ye nowoondoyemo hamoo tero nguno ingoyingo tege eraya kini, ngunonggo ye oo guraro kira ewanggoku ngu, asa, hamoo oorengo, Anutdo ooga ngu yunootoni yowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Yengo yemboongeyingo naruno nguno, oni gurado yeno muri biyomi gura tero, kowuri yunoyingo tetoni ngu, asa, ye Anutno sodedo yemboongeya, ingondudu biyomingga ngu Anut kandeyimo yetoyi, ngundo hoorooweyeroro, ngu kowuringga ngu andangero kabeteyunowa. Ye ngundiro tewanggoku ngu, asa, yengo Awaye sambo endemo oorooteku, ngundo yengo weti mbumbuwaye nguya andangeyunoro kabetewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ene ye oni gurado kowuri ye yunowoku, ngu ma andangewanggoku ngu, asa, yengo Awaye sambo endemo oorooteku, ngundo nguya yengo weti mbumbuwa ma andangeyunowa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yisas ko enengo kirikiri oniya Yerusalem ko oorowuyingo. Ngu naruno, Yisas ene Yuda oniro Tembel ya ngu newendewoore endeyootoni ngu, asa, Anutro wooro yeyingo oni nguro sobosobo oni ururu, Mosesro mamana mandero etuyeroyingo oni, ko, endemo tabango oni ngudodo Yisasno mayeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ngundiro mayero, Yisas sumoo inoro eyingo. Onendo ngu sunggiga ngu ge gunoro ngunonggo nga kongga nga te, ero rogogerowo? Sumoo eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ene ngundiro sumoo etoyi, Yisasdo mande gumi eyingo. No nguya yeno oo guraro sumoo yunowero. Ye nondo sumoongga ngu gumi etoyi ngu, asa, no nguya yengo sumoongga ngu gumi ewano. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Arisa, onendo Sonoyeroyingo Yon oningga ngu sureyootoni ombuyingo? Anutdo sono kundingiyimbo oni sonoyeroni, ero, Yon sureyootoni ombuwo; ngundi, oni simoo baredo sureyootoyi, sonoyerowo, bine? Ye noro mandenengga nga gumi eyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ngundiro sumoo yunootoyi, tabangoku enengo nangge mande ero, ingoro, eyingo. Noore ngandiro ewato. Anutdo Yon sureyootoni, oni simoo bare sono kundingimbo sonoyerowero ombuyingo, ewatoku ngu, arisa, enebana ewa. Ye ndawugaro, ngu nowoondoyemo hamoo ma ingowonggo? ");
INSERT INTO rwo_rawa_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ngundiro nangge, noorendo ngandiro ewato. Onindo Yon sureyootoyi, ngu kongga ngu teyingo, ewatoku ngu, asa, oni simoo baredo nooreya sanggiri urungga tewanggo. Ndadiro nguro, oni simoo bare ene kuri ingootenggo. Yon ngu Anutro ingondudu eyingo oni oorengo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ngundiro nguro, ene Yisasro mande gumi ngandiro eyingo. Noore watayi kini. Etoyi, Yisas enebana eyingo. No nguya yengo sumoongga, ngu gumi ma ewano. Ndawu oninggado nga sunggiga nga nunootoni, ngunonggo no ko nga tetenoku ngu ma ewano. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ngu naruno nguno, Yisasdo mande adingayi gidarega nguya simoo bareno ngandiro eyingo. Oni gura Wayin kongga tero, oonggoyi pawangoro, Wayin nguno miwo. Ene Wayin engge yoro, wongooro, winggooweroyi musiyo nguya tero, ene kongga ngu sobowooweroyi nguro ya pirungga awuno yeyingo. Ngundiro yetoni, oni nguno bibitero, Wayin kono oo ngu bidodo gome kenoro, sobowooro oruwo. Oni ko simburiga, ngundo oni gidaregado ngu kongga nguno digi beye koyi teyi, ero, ene yoyero, ene mera gura oriroko, nguno toongeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Wayin enggeweroyi narunimo, ko simburi, ngundo enengo kirikiri oni gura sureyootoni, Wayin koyi tetenggoku onikuno oorowuyingo. Ko oni ngundo kono oo engge gura yenunoyi, ero, ko oni gura ngu sureyootoni oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ngundiro ko oningga ngu sureyootoni, oorowutoni, Wayinro kono oni, ngundo oni ko simburigakuro kirikiri oninggaku, dowooro, gome gome ureyingo. Ngundiro tero, oo gura ma inoyingo. Kini, ene kingo oorengo sureyootoyi oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ngundiro tetoyi, ko simburibo kirikiri oni gura ko sureyootoni, oorowuyingo. Oorowutoni, ngu kirikiri oninggaku, nguya utoro, tabangomo dongososowooro, ureyi biyomi yetoni, mandeni biyomi ero yomooyinoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ko simburibo kirikiri oni gura nguya sureyootoni oorowuyingo. Oorowutoni, kono onikundo ngu ko oninggaku, nguya ureyi kumooyingo. Ngundiro tetoyi, ko simburibo, kirikiri oni oowooyingga sureyerootoni oorowuyingo. Oorowutoyi, gidarega yutoro, oweyerootoyi, satoyi, gidarega yureyi kumooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ngundiro tetoyi, ko simburi nguro oni gura nguya moore. Ngu enengo nangoni guranangge oorengo. Nguro gome ingoro, newende nangonimo ooroote. Kootu oorengo ngu, enengo nangoni sureyootoni oorowuwero tetoni eyingo. Nga ngu nenengo nangone, nguro ene manggowo ingoro, keyowanggo, ero sureyootoni oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ngundiro oorowutoni, ene kono oni ko tetenggoku, ngundo nangoni kenoro, enengo nangge kewooroyemo mande ero, ingoro eyingo. Nga oningga ngando ngu eweyimboro oo bidodo yomukoro, enendo simburi tewa. Arisa, noore ene nguya udooye kumoowa. Ngundiro tero ngu, asa, nga kongga nga ngu noorengo sobowooro, koyi tewato. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ngundiro ero, kono oni, ngundo ene nguya dowooro, ureyi kumooyingo. Kumootoni, bingo okooro, kanggaroko oorongooyi uyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Arisa, oni ko simburigaku, ngandiro tewa? Ene omburo ngu, oni kono ko tetenggoku ngu yutoro, yureni kumoomukowanggo. Ngundiro tero, ene kongga ngu ko oni gidarega yunowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Anutro mandeno nakangoyingo, ngu ye kuri kandangero ingowonggo. Yisasdo ngandiro eyingo. Nga ya ungoomboro nonggini yanggango ngu ya yeweroyi onindo andangero yokoyingo. Ene ataga, ngu ya nongginingga, ngundo ya yanggango dowooro dikate. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Oo Bidodo Simburi, enengombo ngu ooga ngu yeni tunooteyingo. Noore ngu kenootooye ngu, gome oorengo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yerusalem yowuru yano oni tabango ngu bidodo ngu mandega ngu ingootoyi, Yisasdo ngu mande adingayingga eteku ngu enengomo teyingo. Ngundiro nguro, ene Yisas dowooro, ya biyomimo yewero teyingo. Ene oni simoo barero sosorero, nguro ene yokoro, ootoogero, sayingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ene Parisi oni Herodro oni gidarega, ngudodo Yisasno sureyerootoyi, towoongowero oorowuyingo. Ndadiro nguro, ene mande nenengo gura ma etoni ngunonggo yoro wirikoyingo onino yeweroyi nguro sumoo inowero teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Arisa, oni ngu omburo, Yisasno eyingo. Oo etuyeroyingo oni, noore ingooteto. Ge mande hamoo nangge ete. Gedo ngu oni oowooyedodo, ko, oni oowooye kini nguya mande muri guranangge eneno teyunoote. Yo, ge oni simoo bare bidodo yowuruyeroro Anutro mande muri metemi nangge ero etuyeroote. Arisa, ge ngu ndadiro ingoote? Noore Yuda oni nga digi beye (Takis) Sisa inowato, bine; ngundi, Anut nangge inowato, bine? Anutro mamana mande nguno ooroote, bine? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ngundiro sumoo etoyi, ene Yisas ingoyingo, ene godange etenggo. Nguro Yisas enebana eneya gumi eyingo. Ndadiro nguro, ye no towoonerootenggo? Ye digi beye gura yoya, ombutoyiga, nondo kenoowe. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ngundiro etoni, ene digi beye gura yoro, ombutoyi, Yisasdo sumoo yunoro eyingo. Nga oo gabogaboyiga nga oneromu? Ero etoni, enebana gumi eyingo. Ngu Sisa gabogaboyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ngundiro etoyi, arisa, Yisas enebana gumi eyingo. Sisaro oo ngu, ye komo Sisa inoyi. Anutro oo ngu, ye komo Anut inoyi. Yisasdo ngundiro etoni, oniku ngu mandega, nguro ingondudu urungga teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Arisa, ngu naruno nguno, Yuda oni gidarega oowooye Sadusi, Yisasno mayeyingo. Sadusi oni, ngundo ene ngandiro etenggo. Oni kumootenggoku ko ma ootoogewanggo, ero ingootenggo. Ene Yisas sumoo inoro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Oo etuyeroyingo oni, Mosesndo mande gura ngandiro nakangoro, yunoyingo. Oni gura simoongo kini kumootoni ngu, nguro konebeyi gura ootooro ngu, asa, ngundo ngu bare wabuga ngu mete yowa. Nguno nangoningga tewaku ngu, beyi musiyomo oruwa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Arisa, oni simoongoro gura simoo nangge kandegura gidemboro eraya oruwonggo. Koreteroga, ngundo barega yowo. Asa, ngu simoongo kini oode kootuyisina kumoowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ngundiro kumootoni, enengo koneyo enebana ngu baregaku yoro, ene nguya simoongo kini oode kumoowa. Nguro koneyo kabusayigaku enebana ngu baregaku nangge yoro, oode ene nguya simoongo kini oode kumoowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ngundiro nangge, ngu simoongoro kandegura gidemboro erayagaku bare guranangge yoro, kumoorodoyidoyi kinitewa. Nguro simooye nguya kini. Kootuyisina, baregaku nguya kumoowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Arisa, kootuyisina, oni kumooyingoku, ko ootoogeweroyi naruno nguno, ngu baregaku, ngu oone bareyi nenengo? Ge ingoote, ngu kandegura gidemboro erayagaku ngu bidodo bareye guranangge. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ngundiro sumoo etoyi, Yisasdo gumi eyingo. Ye Anutro mandeno ma ingootenggo. Ye Anutro yanggangoni nguya ma ingootenggo. Nguro ngu, ye mande buribari etenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Oni kumooyingoku ko ootoogeyingo naruno, nguno simoo bare kameyi bareyi kini. Kini, ene Anutro sambono Engel oni oorootenggoku, ngundiro oruwanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ene nga mandega nga oni kumooyingo ko ootoogeweroyi, ngu ye bine Mosesro Buk, ngu ye ma kandangero ingoyingo. Ngu Anutro mandega ngu de bodagano soru tunooteyingo. Ye ngu kuri kandangero ingootenggo. Ngu mandegano nguno Anutdo Mosesno eyingo. No Ebarahamro Anut, Ayisakro Anut, Yekobro Anut, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Mosesro mande ngundo etuyerooteku ngu, ngandiro oni kumootoyi, nguro gaboyi keta oorootenggoku, nguro Anut. Yengo mande ngu hamoo oorengo yomburiyoro etenggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Anutro mande etuyeroyingo oni gura ombuyingo. Omburo, ingootoni, Sadusi onindo Yisasya mande gumi gumi ero ronggeyootoyi, ene ingootoni, Yisasdo Sadusi oniro mande gumi gome oorengo eyingo. Ngundiro tetoni, enebana Yisas sumoo inoro eyingo. Ndadiro mamana mandega, ngundo mamana mande gidarega dagayeroro koreteyingo? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ngundiro sumoo etoni, Yisasdo ngu oningga nguro mande gumi eyingo. Mamana mande guranangge koreteyingo ngu ngandiro. Nguro ye Iserel, gome ingoyi! Oo Bidodo Simburi Simbunani, ngundo nangge, noorengo Anut guranangge. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ye komo Oo Bidodo Simburi nguro nangge gome ingoyi! Yengo Anut nguno ye komo nowoondoye bidodo, gaboye bidodo, yengo ingonduduye bidodo, yengo yanggangoye bidodo, ye ene inoya, ngu nangge keyoya endeyoyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Mamana mande eraya kootu, ngu ngandiro. Gengomboro gome ingooteku, ngundiro, ge tanggegemo oni gura nguya, nowoondoyi teyino. Mamana mande gurado nga mamana mande erayaga, nga ma dagayeroote. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ngundiro etoni, mamana mande etuyeroyingo oningga, ngundo Yisasno eyingo. Oo etuyeroyingo oni, gedo hamoo ete. Yo, hamoo, Anut guranangge oorengo. Anut gura nguya kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Yo, noore komo nguro gome ingooteto. Noore komo nowoondonani bidodo, ingondudunani bidodo, yanggangonani nguya bidodo Anut Oo Bidodo Simburiga inowato. Ngundiro tero, noore komo dobookurinanimboro nowoondoyi teyunoweroyi, ngu noorengo ingootetoku, ngundiro ingowato. Noore nga mamana mande erayaga, nga gome keyowatoku muringga, ngundo nusako utoro, deko kakisokoro, wooro yeweroyi muringga, ngu dagate. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ngu oningga ngundo mande gumi etoni, Yisasdo ingootoni ngu, ene oni ingonduduni metemi. Nguro ngu, Yisasdo oningga, nguya eyingo. Ge Anutno nowoondogemo hamoo tetoni, ngunonggo ge oni gidarega, nguya nowoondoyi teyunoro, ngunonggo ge Anutro mande murini, ngundo simoo bare soboyerooteku, ngu tanggeyimo omburo ooroote. Yisasdo ngundiro etoni, nguro oni gidaregado ingoro, sosorero, nguro ene oo guraro Yisasno ko ma sumoo eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yisas Yuda oniro yowuru yano ootooro, ngunonggo oni simoo bareno mande wesiyoro ero etuyeroro sumoo yunoro eyingo. Anutro mamana mande etuyeroyingo oni, ngundo ndadiro nguro, ene Krayis ngu Dewitro sembeni, ero etenggo? ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Yuka Kundingi, ngundo Dewit ingondudunimo yetoni, nguro Dewit enengombo eyingo. Anut Oo Bidodo Simburi, ngundo noro oni urungga Oo Bidodo Simburi Simbune nguno ngandiro eyingo. Ge kandene koondosina bibite. Kootuyisina ngu, gengo mundi oni yoyewe, gengo kengge damonimo yoyewano. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ndadiro nguro, Dewit enengo sembeni tunooteweroyi ngu noro Simbune, ero ete? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yisasdo ngundiro etoni, simoo urunggaku, Yisasro mandeni ingowero oni oni teyingo. Ngu naruno nguno, Yisasdo oni simoo bare mande yunoro eyingo. Ye Anutro mamana mande etuyeroyingo oni, ngundo tetenggoku, ngundiro ma tewero. Ndadiro nguro, ene towikumba piru piru oni bingamiyedodobo yemutenggoku, ngundiro yemutenggo. Ngundiro yemutoyiga, simoo baredo yeyoya, oni ururu, eya, ingoyi, ero, ngundiro tetenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ene ngundiro tero, Yuda oniro yowuru yano oni simoo bare doongeyemo tunoo bibitewero gome oorengo ingootenggo. Ene oo simbo kayingo naruno, yaba koreteyingo nguno bibitewero nguya, gome ingootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ene bare wabu kamesumooye kumooyingo ngu ganaganayeroro, bare wabunonggo ya oo sitowi kingo sobiyoro yootenggo. Ngundiro yomukoro yokoro ngu, asa, enengo bingamiye ero okooro, ngunonggo ene Anutno kingo yemboongeyingo piru piru tetenggo. Nguno ngu, Anutdo wabu bare ngu hoorooweyeroni, ero ngundiro yemboongetenggo. Ene kootuyisina, oni ngundiro tetenggoku, ngu Anutdo nguro gumi kowuri urungga oorengo yunowa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yisasdo Yuda oniro yowuru yano uro, digi beye yoweroyi musiyomo oororo, namokoyi bibiteyingo. Bibitero, ene ngunonggo simoo bare yeyootoni, digi beye musiyomo yetoyi yeyoyingo. Yeyootoni, oni sitowiyedodo, ngundo ngu digi beye oowooyingga biyomi yetoyi yeyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ngu naruno nguno, bare wabu gurado omburo, enengo digi beye bobodi eraya nangge ngu kondibo yeyingo, siko gura kini. Ngu digi beye bobodi erayaga, ngu Toya guranangge ngundiro. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ngundiro tetoni ngu, asa, Yisasdo enengo kirikiri onikuno negoyerootoni, tanggeyimo ombutoyi eyingo. No hamoo oorengo yeno eteno. Nga bare wabu angoyingga, ngando ene digi beye urungga oorengo yete. Yo, hamoo, oni simoo bare yowuru yaro digi beye musiyomo yetenggoku, ngu bidodo dagayeroote. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ndadiro nguro, nga oni nga bidodo digi beye oowooyingga yano ooroote. Ene gidarega nangge yoro, mayero yetenggo. Ene nga bare wabuga nga, ngu enengo yano gura kini, sikono nguya gura kini. Ene oowari uriyoweroyi nguya gura kini. Enengo digi beye bidodo yeteku nga! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yisas Yuda oniro Tembel ya, yokoro oorowutoni, enengo kirikiri oni gurado eneno eyingo. Oo etuyeroyingo oni, digi yanggango ururu oorengo ngu digi goobe oo wadori gome gome, ngundo yeyingo, nga keno! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yisasdo kirikiri oningga nguro mande eteku gumi ngandiro eyingo. Ge keno nga ya ururu nga, kootuyisina, digi gura yokootoyi, gura sanganimo ma oruwa. Kini, onindo nga digi nga usosowooro, oorongooyi merako umukowa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yisas mera puri oowooyi Olib nguno bibitero, ngunonggo Yuda oniro Tembel, ngu andusina oodoni kenoyingo. Ngu naruno nguno, Pita, Yemus, Yon, Enduru, ngu oni namorayaga, ngundo nangge Yisas tanggeyimo omburo, Yisas sumoo inoro ngandiro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Ge nooreno e. Ndawu narunggano oo ngu tunootewa? Naru wengamo oo bidodo tunooteweroyi, ngu namokono tetoni, nguno noore ndawu sunggiga ngu koretero tunootetoni, nguno noore kenowato? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ene ngundiro sumoo etoyi, Yisasdo mande yunoro, gumi eyingo. Oni gurado ganayeroweroyi nguro ye ingonda teyi! ");
INSERT INTO rwo_rawa_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Oni oowooyingga oorengo no oowoonemonggo tunootero, ngu ngandiro ewanggo. No nangge Yisas Krayis. Anutdo oni simoo bare yoyoweroyi, ero, no soweneroote, ero ewanggo. Ngu oni ngundo ngundiro ero, ene oni simoo bare oowooyingga oorengo ganayerowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Kootuyisina, ye me ebe urungga ngguyi ingoro, ko, me ebe urungga mera songomo tunooteweroyi, nguro mande bingayi nguya ingowanggo. Ngundiro ingoro, ye nguro ma sosorewero, ngundiro muri ngu hamoo koretero tunootewa. Ene naru wenga, nguno kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Yo, hamoo, oni sowe gurado ootoogero, oni sowe guraya ebe urewari. Ngundiro nangge, mera guraro oo bidodo sobosobo oni, ngundo ootoogero, mera guraro oo bidodo sobosobo oniya ebe urewanggo. Mera guminggano ngu imimi urungga yootoni, oni simoo bare oodooro kumooyingo urungga tunootewa. Ngu oo nguro ogingoyi urungga oorengo, ngu baredo simoo bisiyowero ogingo ingootenggoku, ngundiro tunootewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ngundiro oo nguro, ye ingonda teyi! Naru wenga ma tunooteyingomo kowuri ngundiro tunootewa. Ye noro nowoondoyemo hamoo ingoro oodoyi ngu, arisa, mundi onindo, ye nguya, enengo tabango oni yowuruno yoyeyi dikawanggo. Yowuru yano nguya ene ye gisaruyerowanggo. Ndadiro nguro, ene no oowoone, ko, noro mandene nguya wongooyi uwero tewanggo. Yo, hamoo, ye oni mera ngaro oo sobosobo ururu ngu doongeyemo yoyeyi dikawanggo. Ngundiya tetoyiga ngu, asa, ye nguno Anutro Mande Keta Mesarango ngu wesiyoya eneno eyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ngundiya tetoyi ngu, asa, koretero Mande Keta Mesarango ngu simoo bare mera bidodomo oorootenggoku, nguno onindo wesiyoro eneno etoyi, ingowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ene ye yodowooro, wirikoyingo oni yowuruno yoyetenggoku naruno nguno, ye koretero ma sosoreyingo ero ingowero. Noore ndawu mandega ewato, ero, ma ingowero. Kini, ngu naruno nguno, Anutro Yuka Kundingiyi, ngundo mande yendo eweroyi ngu yetoni, ngu nangge ye yootunoya eyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ene beyibo, koneyo, ngu wirikoyingo oni, yowuruno windogayi yunootoni, yureyi kumoowero tewanggo. Ngundiro nangge, eweyimbo enengo nangoni windogayi teyinootoni, nangosumooye ngundo awanamoyemboya nguya sanggiri tero, windogayi yunootoyi, yureyi kumoowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ngundiro tero, oni bidodo yeya, nowoondoye biyomi oorengo yewanggo. Ndatero nguro, no oowoone ngu yeno ooroote. Nguro ngu, ene yeno ngu muringga ngu teyunowanggo. Ene oni noro mande yanggango dowooro oodoni oororo naru wenga tunootewaku ngu, asa, Anutdo ngu oningga ngu ko yowa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yisasdo ngundiro eyingo. Ngu oo biyomi, ngundo Anutro kundingiyi oorengo musiyomo dikatoningga, ngu ingoyi. Ngu narunggano, nguno oni simoo bare Yudiya merako oorootenggoku ngu, ene komo sodedo saro, purimo oorewanggo. (Oni nga mandega nga kandangeya, ngu gome ingondudu teni!) ");
INSERT INTO rwo_rawa_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Oni enderoko oorooteku ngu, ene ya newendesina uro, enengo oo sitowi nguya yowero ma ingowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ngundiro nangge, oni kono oorooteku ngu, ene ko yowoorengoro, enengo towikumba yowero, yano ma oorowuwa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ngu naruno, bare kawuyedodo; ngundi, bare simoonamboye nono yunootenggoku, ngu oni oniyooge. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Nguro ye komo yemboongeyi. Oo ngu doogo dogigi sono midugu naruno ma tunootewero. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ngu narungga nguno, kowuri urungga oorengo tunootewa. Koretero oorengo, Anutdo oo bidodo yemukoyingo naru ngu bidodomo, omburo, nga naruno ngano nguya kowuri ngundiro ngu kuri ma tunooteyingo. Kootuyisina nguya, kowuri ngundiro ngu ko ma tunootewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ene Oo Bidodo Simburi, ngundo kowuri narungga ngu woosootoni, ma ootutetoni ngu, asa, oni simoo bare bidodo oonootewanggo. Ene Anutdo oni simoo barero ingoro, enengo kuri rogo yeyingo. Nguro ngu, ene nga narungga nga woosootoni, ootutewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ngu narungga nguno, oni gurado yeya ewa. Kenoyi! Krayis nga, oorooteku nga; ngundi, kenoyi, ene andusina oorooteku andu, etoni ngu, asa, ye nguro nowoondoyemo hamoo ero ma ingowero. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Oni gidaregado omburo, ganayeroro ewanggo. No Krayis, Anutdo simoo bare yoyowero rogoneroyingo etoni; godange eyingo oni gidarega, ngundo ero ewanggo. No Anutro ingondudu eyingo oni, ero ewanggo. Ene muri songo gura onindo ma teweroyi ngu tero, nguno ene Anutro simoo bare ngu towooyeroro ganaganayerowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Nguro ngu, ye ingonda teyi! No oo bidodoboro kuri yeno etoowe, ingootenggoku ngu! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Yisasdo eyingo. Ngu kowuri urungga ngu kinitetoni ngu, arisa, sa kombo doobeyerootoni, himi ma yewari. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Tootu soretoyi, oo yanggango sambono oorootenggoku, ngu bidodo Anutdo yokutuyerowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ngu narunggano nguno, Oni Nangoni gobooreno duridarini yanggangonidodo oorengo ombutoni, kenowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ngu narungga nguno, enengo Anutro sambono Engel oni ngu sureyerootoni, Anutro simoo bare sambo mera bidodomo oorootenggoku, ngu yoyoro, mayero yowuruyerowanggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yisasdo eyingo. Ye Pik dega nguno ingoyi! Kambini sonoyidodo teteku naruno, ngu nungoyero, tanggori keta ngu yeteku, ngu kenoro ingootenggo. Sa naruwo gome ataga tunootete, ero ingootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ye de ngundiro tetoni, kenoro, ye ingootenggo. Enggeweroyi naru namoko tunootete, ero ingootenggo. Ngundiro nangge, kootuyisina, ye ngundiro oo ngu kenootoyi, tunootetoni ngu, arisa, ye nguno ingowanggo. Yisas ko ombuweroyi naruni namoko tetoni, nguro sunggi ngundiro tunootete, ero ingowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","No hamoo oorengo yeno eteno. Nga naruno ngano oni simoo bare oorootenggoku, ngu ma kumoomukoyingomo, ngu oo ngu bidodo tunootewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Yo, hamoo, sambo mera ngu oororo kinitewari. Ene noro mandene ngu ma kinitewa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Yisasdo eyingo. Ene oni gurado ngu narungga ngu, ko sangga ngu ma ingoote. Anutro Engel oni sambono oorootenggoku ngu, nguya ma ingootenggo. Enengo nangoni nguya ma ingoote. Kini, Eweyi Anutdo nangge ngu ingoote. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ye ingonda teya, gome sobowooya oriyi! Ndadiro nguro, ye ma ingootenggo. Naru ndadiboro tunootewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ngu ngandiro. Oni gura enengo ya yokoro, mera songosina endeyowero. Nguro enengo ko onindo oo sobowooyi, ero, ene ko bayetero, songo songo yunowa. Ene yamuko sobosobo oningga nguya ewa. Ge gome oorengo soboneroya ootoo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Nguro ngu, ye nguya komo gome sobowooyi! Ndadiro nguro, ye ma ingootenggokuro nguro, ndawu narunggano ya simburi ko ombuwa. Ene suwootetoni, ombuwa; ngundi, suwoo kewoorokono, bine; ngundi, sengewero kootoori etoni, bine; ngundi, suwoononggo, bine; ngu ye ma ingootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kinitetoni, ene sodedo omburo, ye yeyootoni, wetororuwanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nondo nga mandega nga, yengo, ko, simoo bare bidodo nguya ero yunooteno. Nguro ye komo gome sobowooya oriyi! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Naru eraya nguya yokoro, Anutdo sunggi kenoro, dagayeroyingo naruwo (oowooyi Pasowa) nguro naru kundingi, Oo Manongoyingo Yis Kini, nguro naru kundingiyi oo simbo urungga neweroyi nguya tunootewa. Anutro wooro yeyingo oni nguro sobosobo ururu, mamana mandero etuyeroyingo oni ururu, ngundo torige Yisas dowooro urewero oore ereweyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ene eyingo. Noore naru kundingiyimo ngu ooga ngu ma tewato. Ndadiro nguro, oni simoo baredo me ebe yeyi tunootewa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yisas Betani ende oororo, gorimambudodo oni oowooyi Sayimon nguro yano uro, nguno oo neweroyi yabano bibiteyingo. Ngu naruno, bare gura ombuyingo. Ngu barega ngu bo urumi nggusi gome oorengongga, ngu kumu bo urumi gura ndindingo gome ngu newendemo nggusingoyingo. Urini urunggado uriyingo oowooyi Nard. Ene ngu nggusiga ngu udookero, Yisas tabangomo wendoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ene ngundiro wendootoni ngu, asa, oni gidarega nguno oruwonggoku, ngundo nowoondoye biyomi yero, enengo nangge ero ingoro eyingo. Ndadiro nguro, bo urumi gomengga nga kingo yomburiyoote? ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nga oni yunootoni, uriyootoyi, nguro uriyi urungga (300.00 Kina) yoro, ngundo angoyi oni yunoweroyi. Ero baregakuya boguwooro kenoro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ngundiro etoyi, ene Yisasdo eyingo. Nguno yokoyi! Ye barega nga ndatero kenoro ero kowuri ene inootenggo? Ene noro muri gome ngu tete. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Angoyi oni ngu, yeya suwooyi sano oodoyi, narudodomo, ye mete ene hoorooweyerowanggo. Ene no ngu yeya suwooyi sano ma oruwato. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ene barega, ngando bo urumi gura no gowenemo wendooteku nga ngu, ene no mereno noyeweroyi nguro yomosineroote. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nondo hamoo oorengo yeno eteno. Mera merani bidodomo Mande Keta Mesarango ngu wesiyoro ewanggoku, ngu merasina nguno nga baregado teteku, ngaro mandeni ero, nguro nguya ingondudu tero ingowanggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ngu narunggano nguno, Yisasro kirikiri oni kande eraya kegidemboro erayaga nguromu gura Yudas Iskariyoot, ngundo ene Anutro wooro yeyingo oni nguro sobosobo ururu nguno oorowuyingo. Ngundiro oororo, ene Yisas yootunoro, kandeyemo yewero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Yudasdo ngundiro etoni, Anutro wooro yeyingo oni nguro sobosobo ururu ngu ingoro, nguro ene oni oni tero, Yudas digi beye inowero mande gosiyoyingo. Ngundiro nguro, Yudasdo damoni yero, oore erewero, ndawu narunggano Yisas yootunoro, kandeyemo yewano, ero ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Kowooyingomboro naru koreteyingo, Oo Manongoyingo Yis Kini oowooyi Pasowa, ngu neweroyi naruni tunooteyingo. Ngu narunggano nguno, ene Anutro sunggi kenoro, dagayeroyingo naruwo Sipsip nangoni utoro, nguro oowari kayingo. Nguro ngu, kirikiri onikundo Yisasno sumoo ewonggo. Gedo ngu noore ndano saya, oowari oo ngu yomosiyoro, neweroyi ingoote? Ero sumoo eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ngundiro sumoo etoyi, arisa, Yisasdo kirikiri oni eraya sureyeroro eyingo. Yari oorowuya, ende uri. Nguno, oni gura sono nggusi koorowooya, oorekanare oorowutoningga ngu, yari kenoya, ene keyoya, endemo oorowuri. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ene oorowuya, ya gura newendemo utoningga ngu, asa, yari ngu ya simburiga, nguno ngandiya eri. Oo etuyeroyingo oni, ngundo geno sumoo ewo. Noro ya gumi ndano, no nguno nenengo kirikiri onidodo Pasowa oowari ngu newato? ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Yari ngundiro sumoo etori, enendo ya gumi urungga awu sanganimo ngu etuyerowa. Ngu ya gumingga ngu, oo neweroyi yaba, bibiteweroyi yaba, ngu bidodo kuri yomosiyingo ngu. Yari nguno noorengo oowari yomosiyori. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Yisasdo ngundiro etoni ngu, arisa, kirikiri oni erayaga ngu endemo oororo, Yisasdo ewoku ngundiro kenoyingo. Ngundiro tero, ene nguno oowari yomosiyoworiyo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Suwootetoni, Yisas enengo kirikiri oni kande eraya kegidemboro erayagakudodo ombuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ngundiro omburo, ene oo neweroyi yabano bibitero, oo nero, Yisasdo eyingo. Nondo hamoo oorengo yeno eteno. Oni gura ye kewooroyemo nganonggo, windogayi no yootunoneroro, mundi oni kandeyemo noyewa. Ngu oningga ngu, noya oo netero. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Yisasdo ngundiro etoni ngu, asa, kirikiri oni nowoondoye kowuri oorengo yeyingo. Ngu mandega nguro, ene damoni yero, guranangge nangge, Yisas sumoo inoyingo. Ge noya ete, bine? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ene ngundiro sumoo sumoo etoyi, Yisasdo gumi eyingo. Ye kande eraya kegidemboro eraya ngu kewooroyemo nga gurado. Nga oningga, noya kandenari koondomo gobooro yeterokungga nga. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Yo, hamoo, no Oni Nangoni, Anutro mandeno kuri eyingo ngundiro oorowute. Ene ngu oningga Oni Nangoni yootunoro etekungga ngu, ngu oniyooge! Ngu oningga ngu oniyooge nemimbo ma bisiyoyingo ngu, kowuri eneno ma tunootewa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ene oo nero oodoyi, Yisasdo oomanongoyingo gura yoro, Anutno yemboongero, oososowooro, bayetero, yunoro eyingo. Nga yoya neyi. Nga nenengo songgiwine. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Yisasdo ngundiro ero, ene toba gura Wayin sonoyimbo newendemo angeyingo, ngu yoro, Anutno yemboongero, kirikiri oni yunootoni ngu, sono toba gurananggegakuno gobooro neyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ngundiro netoyi, Yisasdo yeyoro eyingo. Nga sono tobaga nga nenengo sidudarone. Nga ngu yeya, mande keta, ero gosiyooteno. Nga sidudaronengga nga, ngu oni simoo bare bidodoboro wendoyunooteno. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","No yeno hamoo oorengo eteno. No nga Wayinngga nga ko ma newano. Kootuyisina, Anutro endega enengo simoo bare soboyerooteku nguno, no Wayin sonoyi ko newano. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ngundiro tero yokoro, Anut bingami okooro, ene yambo gura utoro ngu, asa, ene ootoogero, Olib purimo ooreyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ngu naruno nguno, Yisasdo kirikiri onikuya eyingo. Ye bidodo noyokoro sawanggo. Anutro Mandeno ngu ngandiro nakangoyingo. No Sipsip simburi utoowe, Sipsip sosorero, songo songo sawanggo. Ero nakangoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ene no merenonggo ko keta ootoogero ngu, no ye koreteyunoro, Galili merako oorowuwano. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ngundiro etoni, Pitando Yisasro mandeni gumi eyingo. Oni gidarebo goyokoro, satoyi, ene nondo ngu ge ma goyokoro, toongewano. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ngundiro etoni ngu, asa, Yisasdo Pitaya eyingo. Nondo geno hamoo eteno. Ataga nga, suwoonggano ngano, kootoori tambu eraya ma eyingomo, ge no oowoone oongooro ewa. No ngu oningga ngu watayi kini ero, tambu kabusa ewa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ngundiro etoni, ene Pitando yanggango yero gumi eyingo. No hamoo oorengo eteno. No mete geya kumoowaroku ngu, no ge oowoongge ma oongoowano. Eyingo. Ngundiro etoni ngu, asa, kirikiri oni bidodo mande ngundiro nangge emukoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Arisa, ene oororo, musiyo gurano saro, tunooteyingo. Ngu musiyongga ngu oowooyi Gesemani. Nguno ngu, Yisasdo enengo kirikiri onikuno eyingo. Ye ngano bibiteya oodoyiga, no oororo, anduno Anutno yemboongewero. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Yisasdo ngundiro ero, kirikiri oni kabusa, ngu Pita, Yemus, Yon, ngu yoyoro, oorowuyingo. Ngundiro oororo, nguno Yisas newende kowuri urungga oorengo ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ngundiro ingoro, kirikiri oni kabusagakuno eyingo. No nowoondone kowuri urungga oorengo yetoni, no kumooweroyineroote. Nguro ngu, ye ngano ootooya, ye komo ingonda teya sobowooyi. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Yisas ngundiro ero, nguro ene bodaga songo oororo, merako bagootero, wereyingo. Ngundiro tero, eweyi Anutno sumoo ero yemboongeyingo. Awa, Awane, oore moore tetoni ngu, kowuringga ngu ombuya daganeroni. Ge nenengo awane, ge oo bidodo teweroyi ingoote. Nguro no ngandiro ingooteno. Gedo mete nga kowuri ogingo urungga nga ngu, gedo andange. Ene ge noro ingondudune ma keyowero. Kini, gengo ingonduduge ngu nangge no ngu keyowano, ero yemboongeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Yisasdo ngundiro yemboongero yokoro ngu, asa, ene ootoogero, kirikiri oni kabusaga nguno oororo yeyootoni, wetorootoyi, yeyoro, nguro ene Pita yokutuwooro eyingo. Sayimon, ge wetororoote? Ge naru guranangge ma doongetero oruweroyi kini? Sumoo eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ngundiro ero, kirikiri oni kabusagaku yeyoro eyingo. Ye doongeteya, yemboongeya oriyi, Ye ngundiro tero oodoyi ngu, asa, Setando towooyerootoni, yanggango ma yero oonootewanggo. Hamoo, yengo nowoondoyemonggo ngu tewero ingootoni, ene goweyebo ngu sureye kiniyero yanggango ma yetenggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ngundiro ero, Yisas ko oororo, Anutno kira eyingo. Ngu kirangga ngu koretero, Anutno ewokungga, ngundiro nangge ko eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ngundiro yemboongero yokoro ngu, asa, Yisas kirikiri onino ko omburo, yeyootoni, ko wetoro oruwonggo. Ndadiro nguro, nowoondoye kowuri urungga oorengo yetoyi, nguro ene gome gome kubooyerootoni wereyingo. Yisasdo sumoo yunootoni, ene oyimoyerootoni, nguro mande gura eneno ma eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Arisa, Yisas tambu kabusayiga nguno oororo Anutno ewoku ngundiro ko yemboongero yokoro ngu, asa, ene ootoogero, kirikiri oni kabusaga nguno oororo yeyootoni, ko wetoro oriyingo. Ngundiro tero oodoyi, Yisasdo yeyoro eyingo. Ye komo wetoro kengero oorootenggo? Ngu mete, arisa, naru kiniteteku nga! Ye ootoogeya kenoyi! Ataga, mbumbuwadodo onindo, no yootunoneroro, me oni kandeyemo noyewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Nguro ngu, ye ootoogetoyiga oorowuwooto. Kenoyi! Windogayi oni no yootunoneroro, oni sanggiri kandeyemo noyeweroyi oni ombuteku andu! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yisas mande ewootoni, sodedomangge Yudas, Yisasro kirikiri oni nguromu gura ngundo ombuyingo. Ombutoni, me oni oowooyingga omburo, ene duge, idi, nasa, mata komuko ebe ureweroyi, oo bidodo yoro ombuyingo. Anutro wooro yeyingo oni, nguro sobosobo oni ururu, mamana mande etuyeroyingo oni, ko, yowuru yaro tabango oni, ngundo me oni sureyerootoyi ombuwonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Windogayi oni, oowooyi Yudas, kuri sunggi gura yunoro mande ero gosiyoyingo. Nondo ngu oni kandeyi dowooro, yenggonangoro, dureyootoowega ngu, asa, ngu oningga ngu Yisas. Ngu dowooya, yoya oorowuyi. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Arisa, Yudas tanggeyemo omburo eyingo. Oo etuyeroyingo oni, ero, kandeyi dowooro yenggonangoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ngundiro tetoni, arisa, me oni Yudasdodo mayeyingo, ngundo kandeye oorongooro, Yisas dowooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ngundiro tetoyi, Yisasro kirikiri oni kewooroyemo gurado sanggiri tero, enengo duge sobiyoro, ngundo wooro yeyingo oni nguro kirikiri oningga, urewero oorongootoni dagatoni, sodeyi nangge takatoni soreyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ngundiro tetoni, Yisasdo yeyoro eyingo. Ye idi, nasa, duge, ngudodo ye yakaka oni yodowooro yoweroyi ngundiro me ombutenggo? ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Naru oowooyingga, no yeya Yuda oniro yowuru yano ootooro, mande yunororuwono. Ene ye nguno ma nodowoowonggo. Ene Anutro mande nakaya ngu ataga engge tunootete. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ngu naruno nguno, enengo kirikiri oni bidodo Yisas yokoro samukoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Simoo oore gura kumba sarayingga nangge yemuro, Yisas keyoro, oorowutoni, me onikundo kenoro, nguro ene nguya dowooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Dowootoyi, simoo ooregaku, enengo kumba sarayinggaku kandeyemo yokoro, mbirimbiri toongeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Me onindo Yisas yoro, Anutro wooro yeyingo nguro sobosobo oni koreteyingo nguro yano oorowuyingo. Nguno Anutro wooro yeyingo oni nguro sobosobo ururu, yowuru yaro tabango oni, mamana mande etuyeroyingo oni, bidodo mayero yowuruwooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ngundiro yowuruwooro oodoyi, Pita ngu orirokoyi songo Yisas keyoro, oorowuyingo. Ngundiro tero, Pitando ememonggo penggo penggo Anutro wooro yeyingo oniro sobosobo koreteyingo, ngundo yasiriko uyingo. Ngu yangga nguro kumba ootuwoo onindo de katoyi, Pita ngu yakowero nombono omburo, de yakoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Anutro wooro yeyingo oni, nguro sobosobo ururu, yowururo oni tabango bidodo, ngundo Yuda oni negoyerootoyi, mayero, Yisasdo mande biyomi gura eyingo tetoni, ngunonggo Yisas ureyi kumoowero nguro sumoo ero, mande ereweyingo. Ene mande nenengo gura ma kenoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Oni oowooyingga mande godange gura gura Yisasno eyingo. Ene oni nguro mandeye ngu guranangge kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ngundiro nangge, oni gidare ootoogero, mande godange oowooyingga Yisas goweyimo yero, Yisas ganangoro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Yisas enengombo ngandiro etoni ingowooto. Nondo, Yuda oniro Tembel, nga toongoowano. Kuri onindo kandeyebo naru oowooyingga koyi tero yeyingo. Ene nondo ngu naru kabusagomo ko gura yewano. Ene onindo kandeyebo yeweroyi nguya kini. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ene ngu mandega eyingo nguya, mande guranangge kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Wooro yeyingo oni, nguro koreteyingo oningga, ngundo tabango oni, kewooroyemonggo ootoogero, dikaro, Yisas sumoo inoro, eyingo. Ge mande nga gumi gura ma ewa? Nga mandega nga mande wirikoyingo oni doongeyemo ge bungomo etenggo. Ge mande gura moore, bine, ngundi kini? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ngundiro sumoo etoni, ene Yisasdo mande gumi gura ma ero, nenetero, oruwo. Ngundiro nenetetoni, wooro yeyingo oni, nguro koreteyingo oningga, ngundo Yisas ko sumoo inoro eyingo. Ge Krayis, Anutdo simoo bare yoyoweroyi sunggi yeyingo oni? Ge Anut Oo Bidodo Simburi, noore ngu bingami okootetoku, nguro Nangoni, bine? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ngundiro sumoo etoni ngu, asa, Yisasdo gumi eyingo. Nondo nangge. Kootuyisina, no Oni Nangoni, no Anut yanggangonidodo nguro kandeyi koondoyisina bingamidodo bibitero, kootuyisina, sambono gobooreno, ombutoowe, neyowanggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Wooro yeyingo oniro koreteyingo oningga, ngundo sanggiri urungga tero, enengo nengguro dowooro, omboongeweroyi tero eyingo. Noore oni gidaregano sumoo ma ewato. Kini, enengombo mande eteku, nga nangge. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ene Anut kootuyisina yomooyinoro mande ete. Ngundiro nguro, ye enengo mande eteku, nguro ye ndadiro ingootenggo? Ngundiro sumoo etoni, ene bidodo mande guranangge eyingo. Yisas mande biyomi eteku, nguro ene komo kumooni, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Arisa, oni gidarega damoni yero, mukendoro, towimbo doongeyi doobengoro, nguno utoro eyingo. Ge ingondudu eyingo oni tetoni ngu, asa, onendo ge guroote? Ngu yootunoya e! Ngundiro ero, kumba ootuwoo onindo yoro gisaruboro ureyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita ngu yasiriko nguno bibitero oodoni, Anutro wooro yeyingo oni, nguro sobosobo oni koreteyingo oni, nguro kirikiri bare gura ombuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Baregakundo omburo, Pita kenootoni, de yokoro oodoni kenoyingo. Ngu barega ngundo Pita gome gome kenoro eyingo. Ge nguya Yisas Nasaret endemo oningga, nguya oruwori. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ngundiro etoni, Pitando gumi eyingo. Kini, no ngu oningga ngu, no watayi kini. No gedo mandega eteku ngu, no muri ma ingooteno. Ngundiro ero yokoro, Pita endesina yamuko dabemimo ooretoni, ngu naruno, kootoori eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ngundiro tetoni, kirikiri baregakundo, Pita ko kenoro, oni namokono dikayingoku nguno eyingo. Nga oningga nga nguya, Yisasro keyimo oni gura. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ngundiro etoni, Pitando gumi eyingo. Hamoo oorengo kini. Etoni, naru bodaga oode, oni namoko oruwonggoku, ngundo Pitaya ko eyingo. Hamoo oorengo, ge Yisasro oni gura. Gengo mande eteku ngu, Yisasro mandeni ngundiro. Ge nguya Galili oni, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Arisa, Pitando sanggiri sanganimonggo manggaru tero eyingo. No hamoo ma etoowe ngu, Anutdo nurewa! Ngu oningga, yendo etenggoku ngu, no watayi kini! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ngundiro etoni, arisa, kootoori tambu erayayiga ngu eyingo. Arisa, Pita ingoyingo. Kuri Yisasdo eneya eyingo, kootoori tambu eraya ma eyingomo, ge no oowoone tambu kabusa oongoonerowa. Pita mande ngu ingondudu tero, nguro ene sendoro biyobiyomi teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Suwoononggo, Anutro wooro yeyingo oni, nguro sobosobo oni koreteyingo, mamana mande etuyeroyingo oni, yowuru yaro sobosobo oni, Yudaro yowuru ya, nguro tabango oni yowuruno, oni ngu bidodo mande guranangge ewero yowuruyingo. Ngu oni ngundo Yisas utombo gosiyoro, yoro, oororo, Yuda mera nguro, sobosobo oni urungga, ngu Rom Gabuman oni, oowooyi Payilat, ngu kandeyimo yeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Payilat ngundo Yisas sumoo inoro eyingo. Ge, Yuda mera, ngaro oni simoo bare nguro sobosobo oni urungga? Ngundiro sumoo etoni, Yisasdo mande gumi ngandiro eyingo. Yo, gengombo eteku ngundiro. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Anutro wooro yeyingo oni, nguro sobosobo oni koreteyingo, ngundo mande mande oowooyingga kingo Yisas goweyi sanggawero godange eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Payilatdo ko Yisas sumoo inoyingo. Geno mande gura gura etenggoku nga, ge gumi gura ma ewa? Ge ingoote! Mande yanggango gura gura, ge yomburigerowero etenggoku nga! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ene, Yisasdo mande mande, ngu gumi gura ma eyingo. Ngundiro tetoni nguro, Payilat ngu, ene ingondudu urungga ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Dagoma bidodomo, naru kundingiyi oowooyi Pasowa, nguno ngu, Gabuman sobosobo oni ururu, nguro muriye ngundiro, ya biyomimo oni guranangge andangetoyi, toongewa. Ngundiro nguro, oni simoo bare enengombo oni guraro etoyi ngu, oningga ngu nangge andangetoyi, toongewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ngu naruno, nguno oni gura ya biyomimo oruwo. Ngu oningga ngu, oowooyi Barabas. Barabas ngu oni mera oo sobosobo onidodo ebe utoro, oni ureyi kumootoni ngu, oni ngudodo, ene ya biyomimo yoyeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Arisa, oni simoo bare oowooyingga mayero, Payilat sumoo inoro, eyingo. Ge suwooyi sano teteku ngundiya, ataga nguya te. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ene, Payilatdo gumi eyingo. Yuda oniro mera oo sobosobo oni urungga, nga bine, andangetoowega, toongeni? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Payilat, ngundiro ero ene ingoyingo. Anutro wooro yeyingo, oniro sobosobo oni koreteyingo, ngundo Yisasya boguboguwooro nowoondoye biyomi urungga yetoni, nguro ngundiro teyingo. Ndadiro nguro, oni simoo bare urungga Yisas bingami okooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ene, Anutro wooro yeyingo, oniro sobosobo oni koreteyingo, ngundo oni simoo bare sureyeroro eyingo. Barabas andangeya, yuno etoyiga ngu, ene komo Barabas andangeya, yunoni. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Payilatdo oni simoo bareya eyingo. Ye nga oningga nga, Yuda oniro mera oo sobosobo oni urungga etenggoku nga, ndadiro teyinowano? Ero sumoo yunoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Asa, oni simoo bare bidodobo gumi ngandiro meno manggaru tero eyingo. De omukondino sanggawetoyiga kumooni! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ngundiro etoyi, Payilatdo gumi eyingo. Ndadiro etenggo, enendo ndawu oo biyomingga tewo, etoni, ene oni simoo bare bidodo meno moguru urungga tero eyingo. De omukondino sanggawetoyiga kumooni, ero eyingo! ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ngundiro etoyi, Payilatdo, oni simoo baredo ewonggoku, ngundiro nangge ero ingoro, ene Barabas andangetoni, toongeyingo. Ene Yisas yoro, me oni yunootoni, turimbo gisasaruboro, ureyi biyomi yeyingo. Kootuyisina, ngu de omukondi sanganimo sanggawetoyi, kumoowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Me onindo Yisas yoro, Payilatro ende pawaroko oorero, ngunonggo, me oni gidarega bidodo negoyerootoyi, mayero, yowuruwooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Me onindo yowuruwooro nengguro dagoyiga yoro, Yisas teyinoyingo. Uto sanggiridodomu yoro, ngundo Yisasro tomokuyi teyingo. Ngu uto sanggiridodo tomokuyingga ngu yoro, Yisas tabangomo kutuwooyinoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ngundiro tero, Me oni ngundo damoni yero, Yisas doongeyimo tabadori tero, nggunuwooro, eyingo. Ge mayeteku nga, ge Yuda oniro mera oo bidodo sobowooyingo oni koreteyingo urunggaku nga! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ngundiro ero, mata yoro, ngundo Yisas tabangomo oororongooro utoro, mukendoro, kenoro, ero, Yisas tanggeyemo boodooye oondoogero, oni oowooye bingamiye okootenggoku, ngundiro teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ngundiro tero, me onindo Yisas yomooyinoro, yokoro, arisa, Yisasno nengguro dagoyigaku andangero, yokoro, Yisas, enengo nengguroni yoro, Yisas teyinoyingo. Ngundiro tero, Yisas yoro, de omukondino boorowoowero, yoro oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ngundiro oororo, ooreko oni gura oowooyi Sayimon ngu endeni oowooyi Sayirin. Ngu oningga ngu, ene digunonggo ende uwero, mayeyingo. Sayimon, enengo nangosumoongo erayaga ngu oowooyari Alekisanda, Rupus. Me onindo oorekonggo dowooro, woosooro, Yisasro de omukondigaku inootoyi, koorowooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ngundiro tero, me onindo Yisas yoro, mera musiyo gurano oorowuyingo. Ngu merangga, ngu oowooyi Golugata. Golugata oowooyingga, nguro muri ngandiro, tabaye wimbuyi musiyo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Golugatano mayero, nguno sono kowoododo yowuruwooyingo, ngu Yisas inowero teyingo. Ngundiro tetoyi, ene, Yisasdo ngu sono kowoongga ngu yokoro, ene ma neyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Arisa, ene Yisas de omukondino dowooro, sanggaweyingo. Ngundiro tero, Yisasro nengguroni, nguro ebe pawapawamu iriri tero, oni onendo dagayeroro ngu, enendo yowo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Yisas de omukondino boorowooyingo ngu, suwoononggo sa oorero, mera yanggango yeteku, narungga nguno, sa gaboyiboro naru kandegura gidemboro namoraya (9:00am), nguno sanggaweyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Yisas tabango sanganimo de omukondi sosowoomo so uyi gura ngandiro nakangoyingo. Yuda Oniro Mera Oo Bidodo Sobosobo Oni Urungga Oorengo. Ngundiro nakangoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Oni biyomi erayaga, Yisas tanggeyi gide gide booroyeroyingo. Oni gura kandeyi koondosina, gura kandeya biyomisina booroyeroyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ngundiro teyingo ngu, kuri oorengo, Anutro mandeno nakangoyingo nguro engge tunootete. Ngu ngandiro. Ene oni biyobiyomimboya oruwonggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Oni simoo bare mayero, kenoro, yomooyinoro mande ero, tabadori tero, eyingo. Ehe!! Ge nga oningga, ngando yambo ya tootoongoro yokoro, naru kabusagomo ko yewero ewo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Arisa, ataga gengombo de omukondi ngu yokoya, merako ombu! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ngundiro tetoyi, asa, Anutro wooro yeyingo oniro sobosobo oni koreteyingo, Anutro mamana mande etuyeroyingo oni, ngundo nguya, Yisas yomooyinoro mande eyingo. Kenoyi! Ene oni gidarega yomosiyeroote. Enengombo enengo hooroowewero ma ingoote. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Nga Iserelro mera oo bidodo sobosobo oni koreteyingo urungga, Krayis, ene de omukondi yokoro, ombutoni ngu, asa, noore ngu kenoro, nowoondonanimo hamoo tewa! Eyingo. Oni erayaga, Yisas tanggeyi gide gide de omukondino, erayaga nguya, Yisas yomooyinoro mande ewori. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Sa kewooroko (12:00am) oorengo, mera bidodo suwoo ooreri urungga tero, oororo, sa nemimo uyingo (3:00pm). ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ngu naruno, Yisasdo meno yanggango urungga ero eyingo. Eloyi Eloyi Lama Sabakatani? Nga mandega ngaro, muri ngandiro. Noro Anut, Noro Anut, ge ndatero noyokowo? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ngundiro etoni, oni simoo bare gidarega, namoko oruwonggoku, ngundo ingoro, eyingo. Ingoyi! Ene Ilayisa negongoote. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ngundiro etoyi, oni gura kendutero, oororo, sono kowoo oowooyi Winiga ngu towi sosowo, nguno yero, de sanggano gosiyoro, yeyi, Yisas manggomo neni, ero inoro, eyingo. Sobowooro oode kenowato! Ilayisando omburo, andangero, yoro, ombuwa, bine? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yisas ki urungga ero, yuka yokoro, kumooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Yisas kumootoni, asa, Yuda oniro yowuru ya oowooyi Tembel, nguno towi urunggaku awu wengamonggo kewoorokuri pitiro, oosowooro, omburo, wenga merako goroongeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Arisa, me oniro tabango, ngundo Yisas omukumundoongomo dikaro, kenondadangero oruwoku, ngundo Yisas ngundiro tero, kumootoni ngu, kenoro eyingo. Hamoo oorengo. Nga oningga nga, ngu Anutro Nangoni! ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ngundiro etoni, bare gidarega orirokoyi dikaro, kenondadangero, oruwonggo. Ngu bare ngu kewooroyemo, bare kabusa oowooye nga, Mariya Magadala, Mariya, Yemus, beyi oowooyi Yosis nguya, namoyari, ko Salomi, ngundo oruwonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ngu bare ngu, kuri Yisas Galili merako kirikiri teyinoro, yade ngunonggo bare gidarega nguya keyoro, Yerusalem endemo eneya mayeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ngu narungga ngu oororo suwootetoni, kundingi naru yangeni, nguro oo yomosiyoyingo naruwo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ngu narungga nguno, Yosep Arimatiya oningga, ngu tabango oni yowuru, nguro oni gura bingamidodo, ene Anutro Oo Bidodo Simburi Simbunani, nguro naruni enengo oni simoo bare sobowooyeroweroyi, ngu sobowooro oruwo. Ene yanggango tero, Payilat tanggeyimo oororo, Yisas bingomboro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ngundiro etoni, Payilatdo Yisas kumoowo, bine; ngundi ma kumooyingo, bine; ero, ingondudu urungga tero, asa, me oniro tabango gura negongoro, sumoo inoro, eyingo. Oninggaku, kuri kumoowo, bine? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ngundiro sumoo etoni, me oniro tabangongga, ngundo Yisas kuri kumoowo, eyingo. Ngundiro etoni, ingoro, asa, bingongga ngu, Yosep yokoyinoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ngundiro yokoyinootoni, asa, Yosepdo oororo, kumba sarayi gura uriyoro, oororo, Yisas bingo andangero, yoyingo. Ngundiro tero, kumba sarayingga ngundo Yisas bingo doobengoro, mbimboongoro yoro, oororo digi mereyi gura onindo kuri sero digi woondokoyi ngundiro teyingo. Ngu merengga, nguno Yisas bingo merengooro, asa, mere manggowo ngu digi gura urungga wenggeremooro, ngundo ukingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mariya Magadala, barega ngu Mariya, Yosis nemi erayaga, ngundo, Yisas merengootoyi, kenoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Yudaro kando naru, oowooyi Sabat kinitetoni, Mariya Magadala, barega ngu Mariya Yemus oningga ngu nemi, bare gura oowooyi Salomi, ngundo kumu, bo urumi ndindingo gome ngu, uriyoyingo. Ngu bo urumi oo ngu yoro, oororo, ngundo Yisas bingo moondeyi sonowooro, yomosiyowero teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Kowooyingo nguro naru koreteyingo ngu, Sande suwoononggo sa ooretoni, ene oni mereno oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ngundiro oororo, enengo nangge mande ero, ingoro, ngandiro eyingo. Onendo noore hoorooweyeroro, digi urungga mere manggowo ukingoyingo ngu andangewa? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ngundiro ero, oororo, doongetero, mere manggowo kenootoyi, digi urungga mere manggowoomo ukingoyingo nguno kini. Ngu digi urungga mere manggowoomo ngu kuri andangeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ene oororo, mere newendemo uyingo. Uro, doongetetoyi, oni simoo oore gura ngu mere newendemo nengguro sarayi pirungga tero, kandeyi koondosina bibitetoni, kenoyingo. Ngundiro kenoro, ene soriyokoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ngundiro kenootoyi, simoo oorega mereno ngundo eyingo. Ye ma soriyokowero. No ingooteno. Ye Yisas Nasaret oningga de omukondino sanggawero ureyi kumoowokungga, ngu erewero mayetenggo. Ene kuri ootoogewo. Ene ngano kini. Nga kenoyi! Yewonggoku musiyo nangge nga. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ene, ye oorowuya, enengo kirikiri onino eya, Pitano nguya eyi. Yisas ngu koretero, Galili merako oorowute eya eyi. Ye ngu Galili merako ene kenowanggo. Yisasdo kuri yeno eyingo ngundiro. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ngundiro ingoro, ngu bare ngu mere sodedo yokoro, endesina oorero, sayingo. Ene soriyokoro, sosorero, ene oni gurano mande gura ma eyingo. Ndadiro nguro, ene sosorero mboorombooro teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Kowooyingomboro naru koreteyingo ngu, Sande suwoononggo oorengo, Yisas ootoogeyingo. Yisas ngu koretero, Mariya Magadala barega nguno tunooteyingo. Ngu barega, nguno kuri Yisasdo mera mbooro biyomi kandegura gidemboro eraya andangeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mariyando Yisas kenoro oororo, oni Yisasya endeyoyingo, ngundo ngu nowoondoye kowuri ingoro, sendoro, oodoyi nguno eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Mariyando ngu oni nguno eyingo. Yisas keta ooroote! No kuri kenooteno! Ero etoni, ngu oni, ngundo mandega ngu ingoro, ene nowoondoyemo hamoo, ero ma ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kootuyisina, kirikiri oni erayaga, ende yokoro, oore keyoro, oorowutori, nguno Yisas, ene guradiro oorengo tero, kirikiri oni erayaga ngu doongeyarimo tunooteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ngundiro tunootetoni, ngu oni erayaga ngundo oororo, kirikiri oni gidaregano eyingo. Ene, kirikiri oni gidaregado, ngu oni erayaga, ngundo Yisas kenoworiku, ngu etori, mande nguro nowoondoyemo hamoo eteri, ero ma ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kootuyisina, kirikiri oni kande eraya kegidemboro guranangge, ngu oowari newero bibiteyingo. Yisas ngu kewooroyemo tunooteyingo. Yisasdo yeyoro mamana yeroro eyingo. Ye nowoondoye yanggango yetoni, ye nowoondoyemo hamoo ma teyingo, ero eyingo. Ndadiro nguro, ene ootoogewoku, ngu kenoro, ngundo etoyi, ye nguro nowoondoyemo hamoo ma teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Yisasdo mande yunoro, ero eyingo. Ye oorowuya, mera bidodomo mande keta mesarango nga wesiyoya, oni simoo bare bidodo oorengomo eyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Oni ene newendemo hamoo ingoro, ngunonggo ene sono kundingiyi gimuwaku ngu, asa, Anutdo ngu oningga ngu yootoni, ene Anutro oni tero oruwa. Ene, Anutro newendemo hamoo ero, ma ingowoku ngu, ene Setanro ende biyomi, de nombo ma kumooweroyi, nguno uro oruwa. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Arisa, oni noro oowoone, nguro nowoondoyemo hamoo tewaku, nguro sunggi guradiro guradiro yeni tunootewa. Oni simoo bare goweyemo mbooro biyomi oodoyi ngu, asa, no oowoonemo ngu oombooro biyomi ngu oweyerootoyi, sawanggo. Ene mande mebuyi keta gura gura nguya ewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ene kandeyebo sire biyomi dowooro okooro, ko ene, sono oo biyomi oni nero kumooweroyi, ngu nero ngu, ene ma kumoowanggo. Ene ngu ooga, ngundo ma yomburiyerowa. Ene sayi oni tabayemo kandeye okootoyi, sayi oni ngu mete tewanggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Oo Bidodo Simburi Simbunani, Yisas, ngundo enengo kirikiri oni mande yunoro, yokoro, ene Anutdo yoro, sambo endemo ooreyingo. Yisas ngu Anut kandeyi koondoyisina bibiteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Yisasro kirikiri oni ende mera bidodomo saro, mande ngu wesiyoro, eyingo. Anut Oo Bidodo Simburi, ngundo enedodo ootooro, ngunonggo ko tero, enengo mandeni ngu yanggango teyinowero, oo muri songo oorengo guradiro guradiro onindo ma teweroyi, ngu tero, oni simoo bare etuyeroyingo. Mande ngu hamoo oorengo.");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Oni urungga Tiyopilas kuri oni oowooyingga kandeye towoongoro, Krayisdo noore kewooronanimo ko tero ene tunootewoku, ngu bidodo nakangoyingo. Ene oni Yisas enengo doongeyembo kenowonggoku nguro mandeye etoyi, oni songombo nguro mande ingoro wesiyoro etoyi, ngu ingoro nakangoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","Nguro ngu, no nguya nga mandega nga gengo nakangooteno. Naru pirunggano nga mande oo ngaro sumoo sumoo oowooyingga tero, muri bidodo ingoro yowero, asa, no mande nenengo oorengo kuri tunooteyingo ngu ataga nakangooteno. Nguro ge komo gome nenengo oorengo ingo. No nga mandega nga nakangoro ge etunggeroyingo, ngu hamoo mande oorengo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ngu naruno, Herodndo Yudiya mera oo ngu bidodo sobosobo oni koreteyingo oodoni, ngu oni gura oowooyi Sekarayiya ngundo Anutno wooro yeyingo oni tero oruwo. Anutno wooro yeyingo oni ngu, Abayisa ngu Sekarayiyaro wooro yeyingo oni, watangga nguro osiye. Nguro bareyi oowooyi Ilisabet ngu, Eron oningga nguro soweni. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ngu oni erambarisa erayaga ngu, ene Anut doongeyimo ene oni nenengo oorengo oruwori. Ngu erambarisa erayaga ngu Anut Oo Simburi Urungga, nguro mamana mande oo ngu bidodo keyoro oruworiyo. Ene oo biyomi gura ma teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ngu erambarisa erayaga ngu, ene kuri dogoni oorengo. Ilisabet ngu ninggoo teyingo, nguro erambarisa erayaga ngu ene simoo namboyari kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Sekarayiyaro keyimo wooro yeyingo oni ngu, ko tewero mayeyingo. Sekarayiya ngu ene Anut doongeyimo wooro yeweroyi ko ngu teroruwo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Onindo Sekarayiyano rogo tetoyi, ngundo ene Anutno wooro yeweroyi murimo ene yambo ya urunggano (Tembel) nguno uro, Anut Oo Simburi urungga, nguno wooro ndindingo gomemu yeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ngu narungga ngu, Anutno wooro ndindingododo yeweroyi naruwo, oni simoo bare oowooyingga oorengo endesina yowuruwooro, nguno Anutno yemboongero oriyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sekarayiya ko tewoodoni, asa, ngu naruno, Urungga Oo Bidodo Simburiga nguro sambono Engel oni gura kenootoni, wooro ndindingo yeweroyi nombo musiyo ngu tanggeyi koondosina, dikatoni kenoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sekarayiya sambono Engel oninggaku kenoro soriyokoro sosoreyingo urungga oorengo teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ene sambono Engel oninggakundo sodedo ero eyingo. Sekarayiya ge ma sosorewero. Anutdo gengo yemboongengga ngu kuri ingowo. Gengo barege Ilisabet ngundo ngu nangongge simoongga bisiyowa. Oowooyi ngu ge komo Yon eya e. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Gengo nowoondoge ngu gome mete tero oruwaku, ngunonggo ge oni oni tewa. Baredo simoo bisiyootoni, asa, oni simoo bare oowooyingga oorengo, ene nguro nguya oni oni tewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ene ngu Oo Bidodo Simburi Urungga ngu doongeyimo ene oowooyi urungga oruwa. Ene Wayin sonoyi kowoomu, ko sono yanggangomu nguya ma newa. Ene nemi kawuyimo oorooteku ngu Yuka Kundingiyi ngundo newendemo uro angewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Enendo Iserel oni simoo bare oowooyingga oorengo mande yunootoni, nowoondoye yowoorengoro, enengo Anut urungga nguno oororo keyowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Kuri, Anutdo Yuka Kundingiyimbo yanggango urungga oorengo Ilayiya inootoni, ene Anutro ko tewoku, ngundiro nangge, Yon nguya Yuka Kundingiyimboro yanggangonimo, Anutro ko ngu tewa. Enendo simoo bare ururu hoorooweyerootoni, nowoondoye yowoorengoya, ngunonggo enengo simoo namboye nguya hoorooweyerootoyi, nowoondoye yowoorengoro, awanamoyemboya nowoondoye gobooro guranangge yewanggo. Oni Anutro muri ma keyootenggoku nguro nowoondoye nguya enengo mandeni ingoro keyowanggo. Ngundiro muringga ngunonggo oni simoo bare bidodo nowoondoye yomosiyootoni, oo bidodo Simburi Urungga nguro mandeni ingowanggo, eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sekarayiyando sambono Engel onino eyingo. Noore barenemboya kuri dogoni yeworoku, nguro simoo bisiyoweroyi naruwo ngu kuri kini tewo. Ngundiro nguro, no gengo mandega eteku ngu, ndadiro tero ingootoowe hamoo tewa? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ngundiro etoni, sambono Engel oni enebana mandeni gumi, ero eyingo. No Gebiriyel Anut doongeyimo dikaro oorooteno. Anut enengombo no surenerootoni, no geno mande gome nga wesiyoro ewero ombuteno. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Arisa, ge ingo! Ge noro mandene nga nowoondogemo hamoo ma tete. Nguro ngu ngandiro, ataga gengo gagige ngu witumootoowe, ge mande ma ewa. Kootuyisina, nga oo nga tunootetoni ngu, noro mandega nga ngu hamoo oorengo enengo naruno engge tunootetoni ngu, asa, ge mete ko mande ewa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Oni simoo bare Sekarayiya sobowooro ingondudu buribari ingoro eyingo. Ndadiro nguro, Sekarayiya naru pirungga ene ya gumi kundingiyingga, nguno ootooro endesina ma ooreyingo, ero ingootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kootuyisina, Sekarayiya endesina oorero, oni simoo baredoya mande eweroyi kini. Ngundiro nguro, ene ingoyingo, ene ya gumi kundingiyi newendemo ameno oo songo guradiroga Anutdo etungootoni kenoote, ero ingoyingo. Sekarayiya ngu kandeyibo nangge mande towootowoononggo eneya, ero eyingo. Gagingo manggowo ngu witumootoni, mande eweroyi ereremo kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Kootuyisina, Sekarayiya enengo koni kini tetoni, ngu naruno, ene enengo endemo ko toongeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kootuyisina, Sekarayiya bareyi oowooyi Ilisabet kawuyidodo teyingo. Ngundiro tetoni, Ilisabet ya newendemo kombo kandegura kombitero oriyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Oode eyingo. Oo Bidodo Simburi Simbunanembo, ataga noro sumange tenunoro, oni simoo bare doongeyemo oyimonengga ngu andangenunowo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ilisabet Kombo kandegura gidemboro guranangge kawuyidodo teyingo, ngu naruno, Anutdo sambono Engel oni oowooyi Gebiriyel soweyootoni Nasaret ende urungga, Galili merako, nguno oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ngu endemo nguno ene bare oore gura, ene simoo guraya ma wereyingongga, nguno mande yoro oorowuyingo. Ngu barega ngu simoo gurano kameteni ero rogo teyingo. Ngu simoongga ngu oowooyi Yosep. Yosep ngu Dewitro soweni. Ngu bare oorega ngu oowooyi Mariya. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gebiriyel eneno oororo eyingo. Ge oni oni teya ootoo, Anutdo ge bingaminggedodo tenggunoote, Anutdo kumana ge gunooteku, Oo Simburi geya ooroote. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mariyando ngu mandega ngu ingoro sosorero ingondudu urungga tero, enengo newendemonggo eyingo. Ndawugaro nguro, ngu simoongga ngundo omburo nono ngandiro ete? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Anutro sambono oni Engelndo Mariyano eyingo. Mariya ge ma sosorewero. Anutro newende ngu gengo gome ingoro sumangeni gunoote. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Gome ingo! Ge kawunggedodo tero nangongge simoongga bisiyowa. Ngu oowooyi ngu, ge komo Yisas eya e. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ngu oningga ngu, oni urungga oorengo oruwa. Ngu oningga nguya ngandiro ewanggoku, ene Anut bingaminidodo enengo nangoni, ero eyingo. Anutdo ene yoro, sobosobo oni koreteyingo urungga yetoni oruwa. Enengo osiyi Dewitdo sobosobo koreteyingongga ngundo ko tewoku, ene ngundiro nangge ko tewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ene ngu oo bidodo sobosobo koretero oni, ngundo ngu, Yekob Iserel nguro soweni, nguro sobosobo suwooyi sano oruwa. Enengo oo bidodo sobowooteku naru ngu ma kinitewa, eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mariyando ngundiro ingoro sumoo eyingo. No simoo guraya ma wereyingo. Nguro gengo mandega eteku ngu, ndadiro tero engge tunootewa? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Sambono Engelndo mande gumi ero eyingo. Anutro Yuka Kundingiyi ngu geno ombuwa. Anutro yanggangoni awuno oorengo, ngundo ge wiringgeroro kutuwoonggunowa. Ngundiro tetoni, kootuyisina ngu simoonggega ngu ge bisiyowa. Onindo eneya ngandiro ewanggo. Ene oni kundingi, Anutro nangoni, ero ewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ingo! Momongge, Ilisabet ngu, ene kuri bare dogoni ngumu, ene nguya kawuyimo simoongga ooroote. Kuri ngu, oni songombo eyingo. Ene ninggootete eyingo. Ene ataga kawuyidodo oodoni, kombo kandegura gidemboro guranangge kuri yokowo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Merako ngano, ko gura Anutdo teweroyi, kowuri ma ooroote. Hamoo oorengo kini. Anutdo ene oo bidodo temukowa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mariyando gumi eyingo. Ene ngu ooga ngu nono eteku, ngu mete tewa. No ngu oo bidodo Simburi, nguro kirikiri bare nangge. Eyingo. Arisa, sambono oningga ngundo Mariyando oo teteku ngu ingomukoro ene toongeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Ngu naruno, Mariya ootoogero oo bidodo yomosiyoro, sodedomangge yade yade oororo, Yudiya merako ende gura puri sanganimo nguno ooreyingo. Ene Sekarayiyando yano oororo ya newendemo uro, Ilisabetno eyingo. O momo, Ilisabet! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ilisabetdo, Mariyaro, manggowo ingootoni, Ilisabet kawuyimo simoongonggaku parero ooretoni, Yuka Kundingiyimbo Ilisabetro newendemo uro angeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ngundiro tetoni, ene ki urungga, ero eyingo. Anutdo ge Kumana gunooteku ngu, gedo bare gidarega ngu dagayeroote. Ge kawunggemo nangonggega oorooteku nguya ene kumanadodo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","No ndadiro nguro, noorengo Oo Bidodo Simburi Simbunani, nguro nemi, no bingamine okoowero ombute? ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ingo! No mande gura geno ewero. No sodenembo gengo manggoge ingootoowe, kawunemo simoongga oorooteku ngando parero oorero, oni oni tete. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ndawugaro nguro, Oo Bidodo Simburi Simbunani, ngundo mande wesiyoro eteku, ge nowoondoge hamoo teteku nguro engge tunootewa. Nguro ngu, Anutdo ge sobogerootoni, ge mete oni oni tewa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","47","Mariyando eyingo. Noro nowoondonemonggo Oo Bidodo Simburi, nguro bingamini oowooyi hahangero okooteno. Nenengo gabone ngu Anutro oni oni tete. Anut ngu noro hoorooweneroyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","No kuri ngu, enengo kirikiri bare angoyi oodoowe ngu, Anut enengo sumange nunoyingo. Asa, ngundiro nguro, oni simoo bare kootuyisina tunootewanggoku, ngundo nguya noro oowoone bingamine okoowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Anut yanggangonidodo oorengo, ngundo oo urungga tero, no nunowo. Enengo oowooyi kundingiyi oorengo orini! ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Enengo sumangeningga ngu, oni enengo ingoro oowooyi okooro manggowo keyoro oorootenggoku ngu, ko kootuyisina nguro oni sowengga tunootewanggoku, ngu bidodomo nguya oruwa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Enengo kandeyi yanggangomo, ngundo ko yanggango oorengo nenengo tete. Oni ene nowoondoyemonggo enengo bingamiyemboro nangge ingoro endeyootenggoku, ngundiro oni ngu, ene oweyerootoni, songo songo sawanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ene mera ngaro oo sobosobo oni yanggangoyedodo ngu yowoosoodoni, enengo oowooye ameno ombutoyi, oni oowooye kini ngu yowokoro enengo oowooye bingamiye okootoni, awuno oorewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Anutdo oni oodoro kumooro oorootenggoku ngu, ene oo gomemu yunootoni, oni sitowiyedodo tero oorootenggoku ngu, Anutdo ene oweyerootoni, kingo kande sawanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Ene kuri osinani Ebarahamno mande ero gosiyoyingo, nguro nowoondoyi tero, enengo simooye kootuyisina tunootewanggoku, nguro sumangeni teyunowa. Nguro ngu, ene noore enengo ko oni Iserel hoorooweyeroro sumangeni yunowa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ngundiro ero, Mariya ngu Ilisabetya, kombo kabusa oode yokoro, enengo endemo ko toongeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ilisabetdo simoo bisiyoweroyi naruwo tunootetoni ngu, ene nangoni simoongga bisiyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ilisabetro ende gobooro oni ko enengo soweniku nguya Ilisabetro Anut Oo Bidodo Simburi Simbunani Urungga, ngundo sumange teyinoro simoongga inowoku, nguro mandeni ingoro, oni oni urungga oorengo teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Naru kandegura gidemboro kabusa, nguno (naru 8) mayero simooyenggaku moondeyi yomosiyoro, sunggi yeweroyimboro yambo ya urunggano, (Tembel) mayeyingo. Mayero, yowuruwooro simooyengga nguro oowooyi enengo eweyi oowooyi Sekarayiya ewato, ero ewonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ngundiro etoyi, simooyengga ngu nemimbo ngu mandeyega ngu gumi eyingo. Kini, noore komo oowooyi Yon ero ewato, eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Oni songokundo nemimboya mande gumi ewonggo. Gengo gumoogumoongge degooge gura oowooyi ngundiro kini. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ngundiro tero, kande towootowoo tero eweyi sumoo inoro, eweyimbo nangoni oowooyi ndadiro ewa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sekarayiyando oo nakangoweroyi, oo nguro kandeyibo towootowoo tero sumoo eyingo. Ene nguno nangoni oowooyi nakangowero, ero oowooyi Yon nakangoyingo. Oniku ngundiro kenoro nguro ingondudu urungga teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ngundiro nakangootoni ngu, asa, Sekarayiyaro gagingo tango yetoni, ene mande ero Anut bingami ero okooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ngundiro tetoni ngu, enengo ende gobooro oniku bidodo sosoreyingo. Nguro mandeni endeni endeni toongetoni, nguro mande mande urungga ero ingoro, Yudiya mera pupurimo oorootenggoku oni, ngu bidodomo oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Oni bidodo ngu mandega ngu ingoro, nguro ingondudu urungga nowoondoyemo ingoro eyingo. Kootuyisina, ngu simooyengga ngu ndawu ooga tewa? Ero eyingo. Oni simoo bare ene ingoyingoku, Anut oo bidodo Simburi Simbunani, nguro yanggangoni, ngundo ngu simooyengga ngu sobowoote. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Yuka Kundingiyimbo eweyi Sekarayiya newendemo angetoni, oo kootuyisina, tunooteweroyi ngu koretero, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Noorengo oo bidodo Simburi Simbunani, Iserel oniro Anutga, nguro bingami okoowato. Ndawugaro nguro, ene noore hoorooweyerowero omburo, noore, enengo oni simoo bare uriyeroro ko yoyowero ombuwa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Anutdo enengo ko oni Dewit nguro sowenimonggo oni yanggango gura yeni dikaro ngu, ngundo noore ko yoyowero. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","71","Ene kurimi enengo ingondudu eyingo oni kundingiyi, ngu manggoyemo mande ngundiro ero gosiyootoni, Anutdo noorengo mundi oni yanggango ngu kandeyemonggo noore ko yoyoro; oni nooreya nowoondoye biyomi yero boguwootenggoku, ngu kandeyemonggo nguya ko yoyowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ene noorengo osisambanani ngu sumange teyunoro hoorooweyeroyingo. Ene kurimi sunggi mande kundingiyi ero, nguro suwooyi sano ingondudu teroroote. Ene ma kabetewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","75","Ene hamoo mande sorumimonggo Ebarahamno sunggi mande ngandiro eyingo. Ene noorengo mundi oni kandeyemonggo andangeyeroro yoyootoni, nguro noore Anutro koni tewero ma sosorewato. Noore naru bidodomo keta ootooro, nguno ngu, noore gome nenengo oorengo kundingiyi ootooro; asa, noore enengo koni murini kundingiyinimo, ko muri gome nenengo nguno noore mete enengo doongeyimo endeyowato. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ngundiro ero, Sekarayiya yowoorengoro nangoni kenoro eyingo. Ge nangone, oni geyoro geya ero Anut awuno oorengo nguro ingondudu eyingo oni, ero ewanggo. Ge Oo Bidodo Simburi Simbunani, ngu koreteyinoro nguro oore yomosiyoyinowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Gedo enengo oni simoo bare ngu, nguro mande ero etuyerootoyi, ene nguno ingowanggo. Ene enengo weti mbumbuwaye andangeyunoro ko yoyowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Noorengo Anutga nguro sumangeni nowoondoyini urungga, ngundo noorengo ngandiro tete. Anutdo enengo nangoni soweyootoni ombuteku, ngu noorengo nowoondonani oo biyomi oorooteku andangeyunowa. Ngu sengero ooreri toongooteku, ngundiro ene oni nowoondoyemo ooreri biyomi oorooteku, ngu himi yunowa. Ene sambo endeboro himingga ngu yeni nooreno omburo himi ngu, oni ooreriko oorootenggoku, ko oni kumoowero tero oorootenggoku nguya himi yunowa. Noorengo kenani yoonenengootoni, ayibi imakeyingo, oore metemimo nguno oororo omburo tewato. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Kootuyisina, ngu simooyenggaku uru tetoni, enengo goweyi ingonduduni yukani nguya yanggangonidodo uru teyingo. Ene toongero, diguno oni kini merako nguno enesu nangge ootooro oruwoku, ngu naruno, ene Iserel oni simoo bare doongeyemo, Anutro mande etuyerowero tunootewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ngu naruno, mera bidodomo sobosobo oni koreteyingo, oowooyi Sisa Ogastas ngundo mamana mande gura yero eyingo. Mera bidodomo oni simoo bare komo bidodo oowooye bukno nakangowero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Sayiriniyas oningga ngundo Siriya mera nguro Gabuman sobosobo koreteyingo oruwo. Ngu narungga nguno, amana oorengo damoni yero, oowooye bukno nakangoyingo ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ngundiro nguro, oni simoo bare bidodo ene ende damonimo saro, nguno oowooye bukno yeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ngundiro nguro, Yosep ngu Dewitro soweni, ene Galili merako Nasaret ende ngu yokoro, ene Yudiya merako Dewitro endemo yade yade oorowuyingo. Ngu endega ngu oowooyi Betelehem. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yosep ngu enengo bare rogo teyingo, ngu oowooyi Mariya nguya oorowuworiyo. Ene oowooyari bukno yeweroyimboro. Ngu narungga ngu, Mariya kawuyidodo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Yosep Mariya eraga ngu endemo nguno oodori, Mariya simoo bisiyoweroyi naruni tunooteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ngu naruno, endemo wereweroyi ya ngu kuri onindo ndindi teyingo. Nguro ngu, erambarisa Bulmakawuro yano oororo oode, nguno Mariya nangoni gogoro simoongga bisiyoro, kumbagado dobengoro yoro, Bulmakawuro oo neweroyi koondomo yeni wereyingo. Ndadiro nguro, wereweroyi ya onindo kuri ndinditeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ngu merasina nguno, Sipsip sobosobo oni gidarega ende dabemimo suwoono Sipsip sobowooro oriyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Oo Bidodo Simburi Simbunanimboro sambono Engel oni, ngundo Sipsip sobosobo onino omburo tunooteyingo. Urunggado enengo soru himi duridarini urungga yeni omburo, ngundo Sipsip sobosobo oniku pawayeroro himi yeyingo. Ngundiro tetoni ngu, Sipsip sobosobo oniku sosoreyingo urungga teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ene Engel gurado mande yunoyingo. Ye ma sosorewero! Ingoyi, no mande gome mesarango ngu yengo yoro ombuteno. Ngundo ngu oni simoo bare bidodo yoyeni, oni oni tewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ngu sa narunggano, nguno Dewitro endemo bare gura simoo bisiyoote. Ngu simoongga ngu noorengo oo bidodo Simburi Simbunani. Ene Krayis Anutdo rogo tetoni, noore ko yoyowero sunggi yeyingo oni ngu! ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ye ngu simooyengga ngu kenoweroyi, sunggini ngu ngandiro. Kumbabo dobengoro, Bulmakawu ngundo oo neweroyi koondomo yetoni, werooteku ngu! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","14","Sambono onindo ngundiro etoyi, arisa, sodedomangge sambono oni oowooyingga oorengo omburo tunootetoyi, yowuruwooro, Anut bingami okooro, yambo utoro, ngandiro eyingo. Anut awuno oorengo, noore gengo oowoongge bingamingge okooro, noore gengo yemboongetooye, oni simoo bare mete gedo nowoondoge yunoro, gengo imakeyingo muringga nguya yunowa, ero yambo ureyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Sambono oniku ngundiro tero, ene ko sambono ooreyingo. Arisa, Sipsip sobosobo oniku enengo nangge mande ero ingoro eyingo. Noore sodedomangge Betelehem endemo ooroya, ngu ooga ngu Oo Bidodo Simburi Simbunani ngundo ewoku, ngu oororo kenowato. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ngundiro ero, ene sodedomangge oororo, Mariya Yosep eraga yeyoro, ko simooyenggaku Bulmakawu koondomo wetoro oodoni kenoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ngundiro kenoro ngu, sambono onindo ngu simooyengga nguro mande ewonggoku ngu, wesiyoro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Oni simoo bare bidodoboro, Sipsip sobosobo onindo mande ngu etoyi ingoro, ene mande nguro ingondudu urungga oorengo teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ene nemi Mariyando, ngu mande ngu bidodo gome newendemo yero, gome dowooro, ene mande nguro ingondudu teroruwo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Sipsip sobosobo oniku, enengo kono ko oororo, Anutro duridarini sambono onindo etoyi, oororo kenowonggoku, nguro ene Anutro oni oni tero, oowooyi bingami okoororiyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Kootuyisina, sa naru kandegura gidemboro kabusagomo (Naru 8) simooyengga ngu moondeyi yomosiyoweroyi naruwomo, oowooyi Yisas ero eyingo. Mariya kawuyidodo ma teyingomo ngu, oowooyingga ngu Engel oninggado eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mosesro mamana mandeno eteku, Mariya ngu keyoro oodoni, ngu narunggaku tunootetoni, ene yambo yano uro, Anut doongeyimo ko goweyi metemi teweroyimboro oorowuyingo. Ngundiro nguro, Mariya Yosep erambarisa, ngundo Yisas yoro, Yerusalem endemo oororo, yowuru ya urungga (Tembel), nguno Oo Bidodo Simburi Simbunanimo wooro yewero oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ngu Oo Bidodo Simburi nguro mamana mandeno nakangootoni oorooteku ngundiro. Nemimbo nangoni gogoro bisiyootoni ngu, nangoningga ngu, yoro Oo Bidodo Simburi Simbunaningga nguro kundingiyi oni eyingo. Anutdo ngu nangoni gogoroga ngu sunggi yeyingongga, ngu enengo ko teni ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Nguro Anutno wooro yewero ngu, nu mumukondiri ururumu eraya, ngundi, owita duriyo eraya yoro, ngundo Anutno wooro yeweroyimboro. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Mosesro mamana mandeno ewoku, ene ngundiro teyingo. Ngu naruno, oni gura oowooyi Simiyon ngu Yerusalemno oruwo. Ene Anut doongeyimo oni nenengo gome oorengo. Ene Anutno suwooyi sano yambo mande nangge teroruwo. Yuka Kundingiyi ngundo Simiyondodo oruwori. Ene Iserel oni nowoondoye yeni imakero nguro kowuriye andangeweroyi oningga, ngu sobowooro oruwo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Yuka Kundingiyi ngundo Simiyonno kuri eyingo. Ge oode oo Simburi nguro Anutdo noore yoyowero sunggi yeyingo oni, Krayis kenorogogo ge kumoowa, eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","28","Arisa, Yuka Kundingiyimbo yokutuwootoni, ene ootoogero, yambo ya newendemo uyingo. Uro doongetetoni, Mariya Yosep erambarisa nangoyari Yisas yoro, yowuru yano mamana mandeno eyingo, ngundiro tewero ombuworiyo. Simiyonndo Yisas yoro, dowooro, Anut oowooyi bingami ero okooro, ngandiro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Noorengo Oo Bidodo Simburi Simbunani, ataga gengo ko oningga nga yokootooga, sumangenggemo oorowuwe. Ataga no mete kumoowano. Noro nowoondone imakeyingo ootooro, kuri gengombo eyingo, ngundiro ataga tunootete. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","No doongenembo gedo noore yoyoweroyi oningga rogo tewoku, ngu ataga kenooteno. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ge nga oningga ngu rogo tetoyi, omburo oni simoo bare bidodo hoorooweyeroweroyimboro. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ene ngu sorungga ngu Yisas oni sowe gidarega yunoro oore etuyerootoni, Anutno nowoondoye yewanggo. Ngundo ngu, Iserel oni simoo bare nguya oowooye urungga yunowa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Yisas eweyi nemi ngu, Simiyonndo mandega eteku nguro soriyokoro ingondudu urungga teworiyo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simiyonndo kumana yunoro, simooyengga ngu nemi Mariyano oo eme tunooteweroyi, nguro eyingo. Ingo, nga simoongga nga ngu, Anutdo rogo tero soweyowoku ngu, ye Iserel oni simoo bare enengo yanggangoni ngu etuyero. Ene ngundiro tetoni, nguro Iserel oni simoo bare oowooyingga enengo mandeni ngu ingoro, gidarega nowoondoye hamoo tetoyi, gidaregado ene kootu inoro, eneya mundi tewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Nga nangonggega ngando ngu oni simoo barero ingonduduye bidodo nowoondoyemo kombitero oorootenggoku, ngu yeni tunoo oorengo etuyerowa. Kootuyisina, kowuri urungga eneno tunootewaku, nguno ge nguya nowoondoge kowuri oorengo dugebo gosanggawetoni ogingooteku ngundiro ingowa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Anutro ingondudu eyingo bare gura oowooyi Ana ngu, eweyi Panuwel ko enengo soweni oowooyi Aser. Ana ngu kuri dogoni oorengomu, ene kuri kameyimboya dagoma kandegura gidemboro eraya (7) nangge oode, ngu naruno, kameyi kumooyingo. Kameyi kumootoni, enesu wabu oodoni, dagomani onibi namoraya ko dagoma namoraya nguya (84) wabu oruwo. Ene (Tembel) yowuru yangga ngu ma yokoyingo. Ene suwooyi sano, Anutno yambo mande tero, oruwo. Ene ngundiro tero nguno, naru oowooyingga ene oowari roogo tero, nguro yemboongero oruwo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ngu naruno, Ana nguya omburo, Yisas kenoro, Anutno esosootero, Anut bingami okooro, Yisasro mandeni oni simoo bareno wesiyoro eyingo. Yerusalem endemo oni, ko Iserel oni ngu bidodo ko yoyoweroyi oningga Anutdo yunowero eyingo ngu sobowooro oorootenggoku, ngu oningga ngu, Yisas nga! ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yosep Mariya eragado, ene Oo Bidodo Simburi Urungga, nguro mamana mandeno eteku ngundiro temukoro ngu, asa, ene Tembel ya ngu yokoro, Galili merako enengo ende Nasaretno ko oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Simooye bodagaku uru tero, ingondudunidodo urungga tero, yanggangonidodo teyingo. Enengo ingo ingoni, ngu gome oorengo. Anutro sumangeni, ngundo ene wiriyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Dagoma bidodomo, Yisas eweyi nemi, Yosep Mariya eraga ene Yerusalem endemo Anutro sunggi kenoro dagayeroyingo oowooyi Pasowa nguno oororo oorooteri. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","43","Yisasro dagoma ngu kande eraya kegidemboro eraya, (12) tetoni, arisa, ngu naru kundingiyingga, nguno Yosep Mariya eraga, ko Yisas nguya yoro, ene Yerusalemno oorowuyingo. Kootuyisina, Pasowaro narungga ngu kinitetoni, Yosep Mariya eraga, oni songoku ngu bidodo enengo endemo endemo ko sayingo. Ene Yisas enesu nangge, Yerusalemno oodoni, enengo eweyi nemimbo nguro ma ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Yosep Mariya eragado ngu, Yisas ngu oni simoo bare gidaregaya kuri oororo satenggo, ero ingoro, ene nguya ngu sanggano nguno ooreko doongetero doongetero oorowutori, kiniteyingo. Enengo konebeyi dobookuriyi kewooroyemo doongetetori nguya kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Erayaga ngu Yisas erewetori, nguya kini. Ngundiro tetoni, nguro erayaga ngu, ene Yerusalemno Yisas erewero ko oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Yosep Mariya eragado, Yisas erewero endeyoro oodori, sa kabusa kiniteyingo. Kootuyisina, Tembel ya newendemo oodoni kenowori. Yisas ene oo nakangoro etuyeroyingo oni kewooroyemo bibitero, mande etoyi ingoro, ko enebana sumoo ngu oniku nguya yunoro oruwo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ngu ingondudu etuyeroyingo oni, ngundo Yisasro mandeni ingoro, ko ingonduduni ingoyingongga, ko enengo mandeye gumi yootunoro ewokungga, nguro ene soriyokoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Eweyi nemi eraga nguya ngundiro kenoro sosorewori. Nemimbo eyingo. Nangone, ge ndatero nguro, ge nooreya ngundiro teyunoote? Noya awanggeboya nowoondonari ngu kowuri oorengo yetoni, noore ge erewenggeroyingo urungga tetero. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yisasdo enengo mande gumi ero eyingo. Yari ndawugaro no erewenerooteri? Nondo awaro ko teweroyi, ngu yari ngundiro ma ingooteri, bine? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ene eragado, Yisasdo mandega eneya ewoku ngu, muri ma ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Arisa, Yisas ootoogero, eweyi nemimboya oorowuyingo. Oororo, yade yade Nasaretno tunooteyingo. Yisas ene suwooyi sano, eweyi nemimboro manggoyari koorowooro, kirikiri teyunororuwo. Nemi Mariyando ngu mande ngu bidodo ingondudunimo yero, gome dowooro, ingonduduwooro oruwo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yisas uru tetoni, enengo ingoyingo nguya gome urungga oorengo tunooteyingo. Anut doongeyemo, oni simoo bare doongeyemo nguya, ene oni gome nenengo oorengo, ero ingootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Mera bidodomo, tabango koreteyingo oni oowooyi Tayibiriyas Sisa ngu dagoma kande eraya kengga (15) ngu oni simoo barero sobosobo oruwo. Pondiyas Payilat ngundo ngu, ene Yudiya oniro sobosobo koreteyingo oruwo. Ngu naruno, Herodndo ngu Galili mera nguro sobosobo koreteyingo oruwo. Beyi, Pilipdo ngu Ituriya ko Tarakonayitis mera nguro tabango oruwo. Layiseniyas ngundo ngu Abilini mera nguro tabango tero oruwo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ngu naruno, Anas ko Kayiyapas eraga, ngundo ene Anutro wooro yeyingo oni kundingiyi nguro sobosobo oni koretero tero oriyingo. Ngu narunggano nguno nangge, Sekarayiya nangoni Yon ngu diguno oni kini merako nguno oruwo. Yon nguno oodoni, Anutdo enengo mandeni soweyootoni, eneno ombutoni ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ngundiro tetoni, Yon ene oororo, Yodan sono dabemiwoore endeyoro oororo, oni simoo bare bidodo komo nowoondoye yowoorengoro Anutno yetoyi ngu, asa, Anutdo oni simoo bare nguro weti mbumbuwaye andangeyunoro kabeteyunoyingo. Ngundiro tetoni ngu, asa, Yondo sono kundingiyimbo sonoyeroyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nguno ngu Anutro ingondudu eyingo oni oowooyi Ayisaya ngundo kuri nakangoro ngandiro eyingo. Etoni, diguno oni kini merako, oni manggowo gura oni simoo bare gidaregaro meno ewo. Oo bidodo Simburi Simbunani, nguro oore yoonenengoyino! Enengo oore gome yomosiyoyino! ");
INSERT INTO rwo_rawa_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Anutdo oore gigongo, mewuyi ngu bidodo wiriyoyi. Mera pupuri ngu doongootoyiga guwu yeni. Oore wigiwagayingo ngu yoonenengoyino. Oore mera pigipoguri ngu yomosiyoyino. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Nguno ngu, oni simoo bare bidodo ngu, Anutdo noore ko yoyowero ko teteku, ngu kenoro ingowanggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Oni simoo bare oowooyingga oorengo Yon kandeyimo sono kundingiyi gimuwero ombuyingo. Ngundiro ombutoyi, yeyootoni, nowoondoye ma yowoorengootoyi, nguro ngu, Yon sanggiri urungga tero ene mamanayeroro, eyingo. Ye sire dingeyi gosonggini biyomidodo! Onendo yeno etoni, ye mete Anutro sanggirini kootuyisina tunooteweroyi ngu dagaro sawanggo, bine? ");
INSERT INTO rwo_rawa_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ye komo nowoondoye yowoorengootoningga ngu, ye komo engge yeyiga tunooteni. Yengo nowoondoyemonggo ngandiro ma ewero. Ebaraham ngu noorengo awanani, nguro Anutdo nooreya ma sanggiri tewa ero, ma ingondudu tewero. Nondo yeno eteno. Anutdo, ene mete nga digi nga yoyeni, Ebaraham simoongo tunootewanggo. Ye Anutro ko yokootenggoku ngu, asa Anutdo mete oni gidarega yoyootoni, enengo ko tewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Anutro Soboro de damonimo kuri yetoni ooroote. De bidodo engge gome ma enggewaku ngu, ene doongooro, de nombono oorongootoni dewa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Yondo ngundiro etoni, oni simoo bare bidodo enengo mandeni ngundiro ingoro sumoo eyingo. Noore ndadiro tewato? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yondo manggoye gumi eyingo. Oni gura ene nengguro eraya moore ngu, oni gura kenootoni ene nengguro kinitetoni, asa, ngu gura inowa. Oni oowarinidodo ngu, ene komo nguya ngundiro tewa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Gabuman Takis beye yoweroyi oni gidarega nguya, sono kundingiyi yowero Yonno mayero eyingo. Mande etuyeroyingo oni, noore ndawu ooga tewato? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yondo gumi eyingo. Ye ngu komo mera ngaro oo sobosobo onindo etenggoku, ngundiro nangge, beye ngu yoyi. Yengombo, yengo ingonduduno beye sanganimo gura ma yowero. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ngu naruno, kumba ootuwoo oni gidarega nguya Yon sumoo inoro eyingo. Noore ndadiro tewato? Etoyi, Yondo mande gumi eyingo. Ye komo oni yutoro, nguro enengo digi beye kingo ma sobiyoro yowero. Ye oni songomo godange mande ero beye sitowiye ma yowero. Ye komo yengo koye nguro uriyi ngu nenengo yoya nguro oni oni teya oriyi. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","16","Oni simoo bare ingonduduyemonggo, ingondandangero, Yonro eyingo. Nga ngu Krayis bine, ngundi kini, bine? Ero ingoyingo. Yondo enengo mandeye ingoro nguro gumi eyingo. Nondo ngu sonombo nangge ye sono kundingiyi gimuyunooteno. Ngundiro, oni gura no keneroro ombuwa. Ngu oningga nguro yanggangoni, ngundo noro yanggangone, ngu hamoo oorengo dagate. Nondo enengo keyi goweyiga nguro utoyi wesiyoweroyi, ngu ereremo kini. No enengo kirikiri oni nangge. Enendo ngu Yuka Kundingiyimbo, ko debo nguya yowuruwooro, ngundo ye sono kundingiyi gimuyunowa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Kootuyisina, Yisas oningga, ngundo omburo oni simoo barero nowoondoye hamoo teyingo ngu wirikoyerootoni, oni simoo bare bidodo eneno nowoondoye hamoo tetoyi ngu, enendo yoyoro eneya sambo endemo oruwanggo. Nguro ngu, oni simoo bare bidodo eneno nowoondoye hamoo ma tero, Yisas ma keyootoyi ngu, asa, Anutdo ngu oni ngu soweyerootoni, Setanro ende biyomi de nombo ma kumooweroyi, nguno uwanggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yondo mande mande yanggangomonggo ero, ngundo oni simoo bare ingonduduye yokutuwooweroyimboro eyingo. Ngu muringgano ngunonggo, Yondo mande keta mesarango ngu oni simoo bareno wesiyoro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Yondo Galili mera nguro oo bidodo sobosobo oni urungga oowooyi Herod ngu kenoro ero mamanangoyingo. Herodndo muri biyomi gura gura tero, ngunonggo koneyo Pilip bareyi Herodiyas woosooro yoyingo, nguro nguya mamanangoro kenoro eyingo. Ngundiro tero, ngu muri biyominingga nguya tetoni tunoo oorengo teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ngundiro tero, ngu muri biyomi nga, ngunonggo muri gura soweyoro tewo. Ngu Yon dowooro ya biyomimo yeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","Yondo oni simoo bare oorootenggoku, ngu bidodo sono kundingiyi newendemo yodowooro uro sonoyeromukoro oodoni ngu, Yisas nguya Yondo dowooro sono kundingiyimbo sonowooyingo. Ngundiro tetoni, Yisas ngu Anutno yemboongero oodoni, ngu naruno, Sambo yamuko goosootoni, nguwoore Yuka Kundingiyi ombuyingo. Onindo ngu Yuka Kundingiyingga ngu kenoyingo ngu, nu mumukondiri ngundiro teyingo. Ngundiro tero, Yuka Kundingiyingga Yisas tabango sanganiwoore bawooro oororo omburo, tero uyingo. Anutdo Sambononggo meno ero ngandiro eyingo. Ge noro nangone oorengo, no gengo gome ingootenoku ngu! Nowoondone ngu bidodo gengo oni oni teteno! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yisasro dagomani ngu onibiga kande eraya tetoni, (30) ene nguno enengo koni nenengo damoni yero teyingo. Oni simoo baredo ngu Yisas kenoro ngu, ingondudu tero, ngu Yosep nangoni ero ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Hilayi ngu Matat nangoni. Matat ngu Liwayi nangoni. Liwayi ngu Melakayi nangoni. Melakayi ngu Yanayi nangoni. Yanayi ngu Yosep nangoni. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosep ngu Matatayiyas nangoni. Matatayiyas ngu Emos nangoni. Emos ngu Neyam nangoni. Neyam ngu Esalayi nangoni. Esalayi ngu Nagayi nangoni. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagayi ngu Meyat nangoni. Meyat ngu Matatayiyas nangoni. Matatayiyas ngu Semen nangoni. Semen ngu Yosek nangoni. Yosek ngu Yoda nangoni. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda ngu Yowanan nangoni. Yowanan ngu Resa nangoni. Resa ngu Serababel nangoni. Serababel ngu Siyalitiyel nangoni. Siyalitiyel ngu Nerayi nangoni. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerayi ngu Melakayi nangoni. Melakayi ngu Edayi nangoni. Edayi ngu Kosam nangoni. Kosam ngu Elemedam nangoni. Elemedam ngu Eya nangoni. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eya ngu Yosuwa nangoni. Yosuwa ngu Eliyesa nangoni. Eliyesa ngu Yorim nangoni. Yorim ngu Matat nangoni. Matat ngu Liwayi nangoni. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Liwayi ngu Simiyon nangoni. Simiyon ngu Yuda nangoni. Yuda ngu Yosep nangoni. Yosep ngu Yonam nangoni. Yonam ngu Elayiyakim nangoni. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elayiyakim ngu Meliya nangoni. Meliya ngu Mena nangoni. Mena ngu Matata nangoni. Matata eweyi ngu Netan nangoni. Netan ngu Dewit nangoni. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dewit ngu Yesi nangoni. Yesi ngu Obet nangoni. Obet ngu Bowas nangoni. Bowas ngu Salomon nangoni. Salomon ngu Nason nangoni. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason ngu Aminadap nangoni. Aminadap ngu Admin nangoni. Admin ngu Anayi nangoni. Anayi ngu Hesaron nangoni. Hesaron ngu Peres nangoni. Peres ngu Yuda nangoni. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuda ngu Yekob nangoni. Yekob ngu Ayisak nangoni. Ayisak ngu Ebaraham nangoni. Ebaraham ngu Tera nangoni Neho nangoni. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Neho nangoni ngu Serak nangoni. Serak ngu Riyu nangoni. Riyu ngu Pelek nangoni. Pelek ngu Iba nangoni. Iba ngu Sila nangoni. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sila ngu Kenan nangoni. Kenan ngu Apaksat nangoni. Apaksat ngu Sem nangoni. Sem ngu Nowa nangoni. Nowa ngu Lemek nangoni. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lemek ngu Metusala nangoni. Metusala ngu Inok nangoni. Inok ngu Yeret nangoni. Yeret ngu Mahalalil nangoni. Mahalalil ngu Kenan nangoni. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan ngu Inos nangoni. Inos ngu Set nangoni. Set ngu Adam nangoni. Adam ngu Anut nangoni. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yuka Kundingiyi, ngundo Yisas newendemo angetoni, Yisas ene ootoogero Yodan sono yokoro oorowutoni, ngu naruno, Yuka Kundingiyimbo yoro, oni kini kingo mera, diguno toongeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Yisas ene, oni kini merako oororo, nguno naru onibi eraya (40) oode, ene oo ma neyingo. Ngu narungga ngu, kinitetoni ngu, Yisas oodoro kumooyingo urungga oorengo teyingo. Ngu naruno, Setando Yisas towoongowero ombuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Setando Yisasya eyingo. Ge Anutro Nangoni tetoningga ngu, arisa, ge nga digiga ngaya etooga, oo manongoyingo oowari teni. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yisasdo Setanro mande gumi ero eyingo. Anutro mande nakangoyingomo, ete. Oni ene oowariro nangge ngu keta ma oorootenggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ngundiro tetoni, Setando sodedomangge Yisas yoro, mera puri ndandayingonggano oorero, mera ngaro oo gome gome nga keno ero bidodo etungoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Setando Yisasya eyingo. Mera bidodomo nondo yanggango gunootoowe sobowoowa. Oo sitowi gome gomemu oorooteku ngu nguya gunowano. Nga oo nga ngu bidodo noromu, no oni gura inowero ero ngu, no mete ene inowano. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ge nono bagootero nono yemboongetoyi ngu, asa, oo nga bidodo gengomu oorengo tewa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yisasdo mandeni gumi, ero eyingo. Anutro mandeno ete. Ge komo gengo Urungga Oo Bidodo Simburi Simbuge, gengo Anut nguno nangge yambo mande teya, ene guranangge nguro koni ngu nangge teyino. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Asa, Setando Yisas yoro Yerusalemno (Tembel) ya urunggaku, ngu sanganimo awuno ooreyingo. Tembel ya ungoomo awuno dikaro ngunonggo Setando Yisasya eyingo. Ge Anut Nangoni tetoningga ngu, asa, nganonggo pareya soreya u. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Anutro mande nguno ngandiro ete. Anutdo enengo sambono Engel oni, nguno etoni, ngundo omburo sobogeroro goyoro merako goyewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Enengo kandeyebo godowooro goyoro utoyi, digi oo gurado kengge ma sanggawero tutuwoowa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yisasdo Setanro mandeni gumi, ero eyingo. Ge komo gengo ingondudugemonggo oo biyomi gura tero nguro Anutdo hoorooweneroni ero ma ewero. Anutro Mande nakangoyingo oorooteku ngu ngandiro. Gengo oo bidodo Simburi Simbuge, ngu gengo Anut ngu ma towoongowero! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Setando Yisas ngundiro oo ngu bidodomo towootowoongoro yokoro, naru gurano ko towoongowero ingoro ene toongeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yisas ngu Yuka Kundingiyi nguro yanggangoni, ngundo yoro, Galili merako ko oorowuyingo. Yisasro mandeni ngu Galili mera ngu bidodo ero endeyootoyi ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yisasdo suwooyi sano Yudaro yowuru yano uro, oni simoo bare mande yunootoni, nguro oni simoo bare bidodo Yisas bingami, ero okooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yisas Nasaret endemo oorowuyingo. Kuri Yisas bodagano ngu endemo nguno oode urungga teyingo. Yisas enengo murini ngu ngandiro. Kando naruno (Sabat) ene suwooyi sano Yudaro yowuru yano oruwo. Ngu naruno, ene dikaro, Anutro mande kandangewero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ngundiro etoni, ene Anutro ingondudu eyingo oni, Ayisayaro buk nakayangga yoro, Yisas inoyingo. Yisasdo bukga ngu yoro wesiyoro, ene mande ngandiro nakangoyingomu ngu erewero kenoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Ngu ngandiro, Oo Bidodo Simburi Simbunani, nguro Yuka Kundingiyi nono ooroote. Ngundo no rogonerootoni, ngunonggo no angoyi oni simoo bare Anutro mande keta mesarango nga wesiyoro yunowano. Ene no surenerootoni ombuwonoku, ngu mande ngandiro etoowega, ye ya biyomimo oorootenggoku, ngu yokoya sayi. Oni doongeye kiringomu ene doongetero, mera kenowanggo. Ene no sowenerootoni ombuwonoku ngu, oni hoorooweyeroro, enengo mundi oniro kowuriye yunootoyi, andangeweroyimboro ombuteno. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","No mande wesiyoro ngu Oo Bidodo Simburi Simbunani nguro, naru gome ataga ooroote. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yisasdo mande ngundiro kandangero yokoro, ene Bukgaku ukingoro Buk simburi inoro yokoro ene bibiteyingo. Ene oni simoo bare yambo yano oruwonggoku, ngu bidodo Yisas nangge kenondadangeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ngundiro kenootoyi, Yisasdo mande ngandiro, ero eyingo. Anutro mande nakangoyingo nga ngu, ene ataga engge tunootero oorooteku nga! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Oni bidodo Yisasro oni oni tero, enengo bingami okooro ero enengo mandeni nga gomemu tunoo oorengo ewoku, nguro soriyokoro ingondudu tero eyingo. Ene nga oningga nga Yosepro nangoni nangge, bine? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yisasdo mande gumi eyingo. Hamoo oorengo, yengo ingonduduyemonggo mande ngandiro nono ewanggo, bine? Sayi mambu yomosiyeroyingo oni (Doguta), ge komo gengo sayingge yomosiyo. Ge Kapeniyam endemo oo tewoku ngu, noore ingowooto. Ngundiro nangge, gengo ende damonimo ngano nguya ngundiya te. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yisasdo mande ero eyingo. Hamoo oorengo yeno eteno. Anutro ingondudu eyingo oni gura, enengo ende damonimonggo mandeni ngu gome ma ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nga ingonduduyega nga ngu, yengo osi sambayeboro oo biyomi ingoyingoku, ngundiro ingootenggo. No hamoo oorengo yeno eteno. Ilayiyaro naruno, Iserel bare wabu oowooyingga oruwonggo. Ngu naruno, dagoma kabusa ko kombo kandegura gidemboro guranangge sa nangge oodoni, sono ma ombuyingo. Ngundiro tetoni, oowariro kumooyingo naru urungga mera bidodomo tunooteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ngundiro tetoni, Anutdo Ilayiya sureyootoni, Iserel oniro bare wabu gurano ma oorowuyingo. Kini, Anutdo Ilayiya soweyootoni Sarepat ende Sayidon merako, bare wabu gura nguno oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ngundiro nangge, Anutro ingondudu eyingo oni, Ilayisaro naruno nguya, Iserel oni gori mambudodo oowooyingga oruwonggo. Ngu kewooroyemo gura ma mete teyingo. Kini, Siriya oni oowooyi, Neyamando nangge mete teyingo. Yisasdo ngundiro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Oni simoo bare Yuda oniro yambo ya newendemo oruwonggoku, ngu mandega ngu ingoro, sanggiri biyomi teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ngundiro sanggiri tero, oni simoo bare ootoogero, Yisas ureyi kumoowero teyingo. Ngu endega ngu, puri sanganimo nguro, ene ootoogero, Yisas owero moguruwooro yoro uro ende wengamo, kembemo wenggeremootoyiga uni ero ngundiro teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ngundiro tero utoyi ngu, Yisas ngu kewooroyemonggo kini tero toongeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ngu naruno, Yisas ngu Galili mera nguno ende gura oowooyi Kapeniyam nguno uyingo. Ngu endemo nguno kando naruno, Yisasdo oni simoo bareno Anutro mande wesiyoro etuyerowero damoni yeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Yisasro mandeni ingoro, nguro sori yokoyingo. Ndadiro nguro, enengo mandeni ngu yanggango oorengo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","34","Yambo ya nguno oni gura mbooro biyomimbo yoyingomu omburo, nguno oruwo. Ngu oningga ngundo manggaru urungga tero eyingo. Ehe! Yisas Nasaret oni! Ge ndawu ooga noore teyunowero ombute? Ge bine noore yomburiyerowero ombute? No ingooteno. Ge Anutro oni kundingiyi! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ene Yisasdo manggaruwooro eyingo. Ge manggoge ukingo! Ngu oningga ngu yokoya toonge! Eyingo. Ngundiro etoni ngu, asa, merambooro biyominggakundo oninggaku wenggeremootoni, oni songoku kewooroyemo merako wedoni mboorogaku besero toongeyingo. Ene oninggaku goweyi moondeyi ma utoro yomburiyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Oni bidodo ngundiro kenoro soriyokoro enengo nangge mande, ero ingoro eyingo. Nga ndadiro mandega? Enengo yanggango oorengo etoni, merambooro yanggangododo, ngu besero oni yokoro toongeteku nga! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Yisasro mandeni ko oo tewoku nguro, mande ngguyi bingamini, ngu mera nguro ende ngu bidodo rogowooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Naru gurano, Yisas ootoogero, ngu yambo yangga ngu yokoro, Sayimon Pitando yano oororo uyingo. Sayimon Pita konggeyi ngu sayi urungga oorengo tero, moondeyi kookingo urungga teyingo. Ngundiro tetoni, nguro Yisasdo yomosiyoni, ero sumoo eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yisasdo ngu baregakuno oororo ngu sayinggakuya etoni, sayinggaku besero toongeyingo. Arisa, ngu baregaku ootoogero mete tero, oowari kayunowero kirikiri teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Sa nemimo uwero tetoni, oni enengo dobookuriyemo sayi damoni gura gura, yoyoro mayeyingo. Yisasdo kandeyi ngu sayi onikuno songo songo yetoni, ngu sayi oniku goweye moondeye gome mete temukoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ngundiro tero, mera mbooro biyomiku nguya, oni simoo bare oowooyingga yoyokoro besero satoyi, oni mete teyingo. Ngu mera mbooro biyomi, ngundo meno manggaru tero eyingo. Ge Anutro Nangoni! Ero etoyi, ene Yisasdo eyingo. Ye mande ma ewero, ero roogo teyunoyingo. Ndadiro nguro, ene ingootenggoku ngu, Yisas ngu Krayis. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Sengetoni suwoononggo Yisas ootoogero, endesina oorero, mera eruwoongomo oni kinimo toongeyingo. Ngundiro tetoni ngu, oni simoo bare ootoogero ereweyingo. Ngundiro pawangootooyega, ene ma yoyokoro toongeni, ero ngundiro teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ene Yisasdo eyingo. No komo endeni endeni nga bidodomo Anut Oo Bidodo Simburi Simbunani ngundo simoo bare enengo sobowooteku, ngu ero wesiyoro etuyerowano. Ndawugaro nguro, no Anutdo nga kongga ngaro surenerootoni ombuwono. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Enengo mandeni emukoro ngu, Yisas ene oororo, Galili mera nguro ende, ngu bidodomo Yuda oniro yambo ya newendemo uro, nguno Anutro mande onino ero etuyeroyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Naru gurano, Yisas ngu Genesaret sono koongeyingo ngu dabemimo dikatoni, oni simoo bare oowooyingga oorengo, Anutro mande ingoweroyimboro mayero, musiyo bidodo ndindi teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yisas ene doongetero wanggo bobodi eraya yeyootoni ngu, sono koongeyingo ngu tamako nguno oriyingo. Wanggo simbukuriyi ngu sono koongeyingo tamakono uro, isoro siri sonowooro oriyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yisas ngu Sayimondo wanggoga ngu sanganimo oorero Sayimonya eyingo. Wanggo bodaga woosoodoga sono kewoorokoyi oorowuni, ero eyingo. Ngundiro ero, ene wanggono bibitero, oni simoo bare ngu Anutro mande ero etuyeroyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yisasdo mande ero yokoro ngu, yowoorengoro, Sayimon Pitano eyingo. Wanggo woosoodoga sono kewooroko oorowutoningga, ye isoro si oorongooya, iso yoyi, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Sayimon Pitando Yisasro mandega ngu gumi eyingo. Oni urungga, noore suwoono naru urungga ngu si oorongoowootoku iso gura ma yoyingo. Ene gedo etoyi nguro, asa, towoongoro ko oorongoowano. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ene ngundiro tetoyi ngu, iso urungga oorengo si newendemo uyingo. Ene isombo si omboongewero teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ngundiro tetoni, ene dobookuriye wanggo gura sanganimo oruwonggoku, ngu negoyerootoyi, omburo ngudodo iso sigaku woosooro yoro, wanggo eraya eraya angero ooretori, sono newendemo uwero teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Sayimon Pitando ngundiro kenoro ingoyingo, Yisas komo ngu oni kundingiyi. Nguro, ene Yisas keyi damonimo bagootero eyingo. Oni urungga Oo Bidodo Simburi Simbunani, ge no noyokoya toonge. No weti mbumbuwa oni biyomi. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","10","Pita iso oowooyingga oorengo yoro, ngu kenoro soriyokoyingo. Oni gidarega nguya, ngundiro nangge, soriyokoyingo. Sebedi simoongo erayagaku ngu oowooyari Yemus Yon erabasa nguya ngu Sayimon ko gobooro oniku nguya soriyokoyingo. Soriyokootoyi; asa, Yisasdo Sayimonya eyingo. Ge ma sosorewero! Kootuyisina, ge oni simoo bare Anutro mande keta mesarango nguno ngundiro yoyowa, eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ngundiro tero, Pita garo enengo wanggo woosooro sagigo yero, enengo oo bidodo yokoro, ene Yisas keyoro endeyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Naru gurano, Yisas ende gurano uyingo. Ngu endemo nguno oni gura gorimambubo goweyi kondibo yokoyingongga oruwo. Ngundo Yisas tanggeyimo bagootero wetoro, ngguyinggayi tero sumoo eyingo. Oni urungga Oo Bidodo Simburi Simbunani, ge ma yokowero, ge no yomosinerootooga ngu, asa, no gowene metemi tewano. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yisasdo kandeyi sayi oninggakuno yero eyingo. Nondo ge gowege metemi teni ero ingooteno. Asa, ge metemi te! Ngundiro etoni, arisa, sodedomangge ngu gorimambuku tootero kiniteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yisasdo ngu oningga nguya mande yanggango, ero eyingo. Ge oni gurano ma ewero. Ene ge ooroya, gowege Anutno wooro yeyingo oni kundingiyi ngu etuyero. Ge gowege metemi teteku nguro Mosesro mamana mandeno eteku ngundiro, gowege nguro Anutno wooro yetoyi, oni simoo bare nguno ingowanggo. Ge gowege metemi tewo. Ero ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Yisasdo ko mande oo tewoku, nguro ende bidodomo ero sayingo. Ngundiro tetoyi, oni simoo bare oowooyingga oorengo Yisasro mandeni ingowero mayeyingo. Enengo sayi oni nguya yomosiyeroni, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ene naru guranangge nangge, nguno Yisas enesu nangge torige oni kini mera eruwooyingomo toongero, nguno Anutno yemboongero oruwo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Naru gurano, Yisas oni simoo bare Anutro mande yunoro oruwo. Mamana mandero sobosobo oni oowooye Parisi ko mamana mande etuyeroyingo oni gidarega nguya, ngu Yudiya mera nguro endeni endeni bidodomonggo, Yerusalem ende urunggano ngunonggo ko Galili merako ende ngu bidodomonggo mayero oruwonggo. Anut oo bidodo Simburi urungga, ngundo yanggango Yisas inootoni, ngundo sayi oni yoyeni metemi tero sayingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Oni gidaregado oni gura wimbuyi ko kekandeyi bingo yeyingomu, ngu yabanidodo sumooro koorowooro mayero, yoro ya newendemo Yisas keyi damonimo yewero teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ene simoo bare urungga oorengo nguro ya newendemo uweroyi kini. Ngundiro nguro, ene koorowooro, ya sanganimo oorero, ya uyi andangero, nguwoore oni simoo bare kewooroyemo sayi oninggaku wetorodoni yawasadodo yeyi, Yisas omukumundoongosina uyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yisasdo ngu oniku enengo nowoondoyemo hamoo teyingo ngu yeyoro, sayi oninggakuya eyingo. Doboone, gengo weti mbumbuwage andangegunooteno. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ngundiro etoni ngu, mamana mande etuyeroyingo oniya, Parisi oni ngudodo enengo nangge ingonduduno, ero ingoro eyingo. Nga oningga nga onendo? Ene Anut yomooyinoro mande ngundiro ete. Onendo weti mbumbuwa andangeweroyi ingoote? Ngu kongga ngu Anutromu nangge, Anut enengombo ngu weti mbumbuwa andangeweroyi ngu ingooteku ngu! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","24","Yisasdo ngu oni nguro ingonduduye ingoro, nguro mande gumi ero eyingo. Nondo kowuri kini, no mete gengo weti mbumbuwa ngu andangewano. Ndadiro nguro, ye ma ingootenggoku, ngu hamoo bine, ngundi kini bine? Ene nondo ngandiro ewanoku ngu, ge mete ootoogeya, oorowuwero etoowe, asa, ye ngu tunoo kenoro, ngunonggo ingowanggo. No Anutro Oniro Nangoni no yanggangonedodo no mete weti mbumbuwa nguya andangewano. Asa, no mete nga oni kekandeyi biyominggaya ewanoku ngu, ge ootoogeya oorowu! No ngundiro etoowe ngu, ye kenoro, ngu ye ingowanggo. No nguya mera nga bidodoboro simoo barero weti mbumbuwa ngu mete andangeyunowano. Ene ngundiro ero, Yisas yowoorengoro, oni wimbuyi bingo yeyingonggakuya eyingo. Asa, ge ootoogeya gengo yaba yoya, koorowooya, gengo yano oorowu! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ngundiro etoni, asa, ngu oni simoo bare ngu doongeyemo, ngu oni biyominggaku ootoogero, enengo yabaga kuri ngu sanganimo wetoro oruwokunggaku, ngu yoro koorowooro, Anut bingami urungga ero okooro, enengo yano oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ngundiro tetoni ngu, oni simoo bare bidodo ngu kenoro, soriyokowonggo. Ngundiro tero, ene nguya Anutro oowooyi bingami, ero okooyingo. Nowoondoye sosorero eyingo. Ataga, noore muri songo oorengo gura kenootetoku ngu! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kootuyisina, Yisas ootoogero, oororo, oni gura kenootoni, Gabumanro beye yoweroyi tookoododo yano bibitero oodoni kenoyingo. Ngu oningga ngu oowooyi Liwayi (oowooyi gura Matiyu), Yisasdo kenoro eyingo. Ge ombuya, no keneroya endeyo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ngundiro etoni, Liwayi ootoogero, enengo oo sitowi bidodo yokootoni oodoni, ene Yisas keyoro oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Liwayindo enengo yano oo Simbo urungga Yisasro kayingo. Gabumanro digi beye yoyingo oni oowooyingga, ko, oni simoo bare gidarega nguya eneya bibitero oo neyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Parisi oniya, mamana mande etuyeroyingo oni, ngudodo Yisasro kirikiri onikuya boguwooro mande mande urungga eyingo. Ndawugaro ye oni muriye biyomi Gabumanro digi beye yoyingo oni, ko, weti mbumbuwadodo oniya sono oowari netenggo? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","32","Yisasdo manggoye gumi eyingo. Oni goweye moondeye gome metemimu, ngu sayi oni yomosiyeroyingo onino (Doguta) ma oorowuwanggo. Kini, sayi onindo nangge ene nguno oorowuwanggo. Ngundiro nangge, no oni nenengo oorootenggoku, ngu negoyerootoowega, nowoondoye yowoorengoyi, ero ma ombuyingo. Kini, weti mbumbuwadodo oni ngu negoyerootoowega nowoondoye yowoorengoyi, ero nguro ombuwono. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ene Yisasno eyingo. Yonro kirikiri oni, ko Parisi oniro kirikiri oni nguya, ene oowari yokoro kundingiyi tero, naru urungga yemboongero oorootenggoku, ndawugaro gengo kirikiri oni, ngundo ngu muringga ma teyingo? Ene oowari sono nguya netenggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","35","Etoyi, Yisasdo mande adingayi gumi eyingo. Ye bine oni gura bare yoweroyi naruno, nguro keyimo dobookuriyi ngu oodoyi, ene oowari mete roogo tewanggo, bine? Kini, kootuyisina, ngu oni bare yoweroyiga ngu yoro satoyigogo, ngu naruno, nowoondoye kowuri yero, ene oowari roogo tero, kundingiyi tewanggo. Eyingo. Yo, ngundiro nangge, ngu naruno enengo kirikiri oni Yisasya oode, ene oni oni tero oriyingo. Ene Yisas toongeweroyi naruno, nguno ngu, enengo kirikiri oniku, kowuri yoro, nguro oowari roogo tero yemboongewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yisasdo mande adingayi gura, ero yunoyingo. Oni gurado kumba ketangga omboongero, ngundo kumba kuriminggano witu ma ukingoro wesibiyowa. Ene oni gurado ngundiro tewaku ngu, ene kumbani ketanggaku yomburiyowa. Ngu kumba ketangga ngu kumba kurimingga nguya mete kini. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","No mande adingayi gura yeno eteno. Oni gurado bo nangoni keta ngu yoro, siri ngu kurimi nguno ma siriyowa. Ene ngundiro tewaku ngu, bo nangoni, ngundo ngu bo siga ngu oomboongero bo nangoni merako sorero yomburiyowa. Ngundiro tetoni, enengo si, bo nguya biyomi yewari. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kini, oni ene komo bo nangoni ketamu si ketamu nguno siriyowa. Ngundiro tewaku ngu, enengo eraya eraya keta nguro, ene gome oruwari. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ngundiro nangge, oni dogoni ngundo mande muri keta ngu keyoro endeyoro oruweroyi, ngu kowuri oorengo. Ngundo mande muri kurimi, nguro ngandiro ete. Muri gome metemi, ero ete. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Kando naru gurano, Yisas enengo kirikiri oniku nguya, nggire ko gura oore kewoorokuri endeyoyingo. Kono endeyoro, Yisas enengo kirikiri onikundo kono nggire nguro engge gidarega andangero yoro, kandeyebo besooro dangero nunungooro neyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Parisi onindo ngundiro yeyoro eyingo. Kando naruno, ngundiro oo ngu ma teweroyi ngu roogo oorengo. Ndawugaro ye ngundiro tetenggo? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Yisasdo mandeye gumi eyingo. Ye Dewitdo teyingo ngu ma kandangero ingootenggo, bine? Dewitdo enengo keyimo onikuya oowariro kumooro biyomi tero, ene ndadiro teyingo? Dewitdo Anutro yano uro oo manongoyingo, Anut doongeyimo oruwoku yoro nero, gidarega enengo keyimo oniku yunootoni neyingo. Ngu oo manongoyingo ngu kundingiyi, kingo onindo ma neweroyi, yambo yaro sobosobo oni, ngundo nangge mete newanggo. Ye bine ngu ma kandangero ingootenggo? Eyingo. Ngu Dewitdo ngundiro teyingo metemi bine, nguro noro kirikiri onikundo teyingo ngu, nguya metemi nangge. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ngu naruno, Yisasdo mande gura ero eyingo. Oniro Nangoni ene kando naru, nguro Simburi urungga oorengo. Noso nangge mete oni oo gura Sabatno tewero ingowanggoku, no mete sobowoowano. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Kando naru gurano, Yisasdo Yuda oniro yambo ya gura nguno uro mande ero, oni simoo bare etuyeroyingo. Oni gura nguno oruwoku ngu, oningga ngu kandeyi metemisina bingo yeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Mamana mande etuyeroyingo oni, ko mamana mandero sobosobo oniku oowooye Parisi ngundo Yisas ureyi kumooweroyimboro kenondadangero sobowooyingo. Yisasdo kando naruno sayi oningga ngu yomosiyowa ngundi kini, bine? Ero ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yisasdo ngu oni nguro ingonduduye biyomi ngu ingoro, ene yowoorengoro oni kandeyi biyomingga nguya eyingo. Ge ootoogeya kewooroyemo dika. Ngundiro etoni, oni kandeyi biyominggaku ootoogero kewooroyemo dikayingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yisasdo ngu onikuya eyingo. No ye sumoo yunooteno. Noore kando naruno, muri metemimu tewato, bine; ngundi, muri biyomi ngu tewato binengga? Oni yomosiyoro yowato, bine; ngundi, yomburiyowato bine? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ngundiro ero, enendo oniku yeyondandangero yokoro, yowoorengoro kandeyi biyominggakuya eyingo. Kandege yoonenengo, ero etoni, ene ngundiro tetoni, kandeyigaku metemi teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ngundiro tetoni, onikundo ngundiro kenoro nguro sanggiri biyomi oorengo tero, enengo nangge mande ero ingoro eyingo. Noore ndadiro ooga ngu Yisas teyinowato? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ngu naruno, Yisas mera puri gurano kira ewero ooreyingo. Ngu suwoonggano nguno Anutno kira ero oodoni oororo sengeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Sengetoni suwoononggo enengo kirikiri oniku negoyerootoni, ombutoyi, kewooroyemo kande eraya kegidemboro eraya yoyoro oowooye Aposel ero eyingo. (Aposel ngu muri ngandiro ngu Yisasro kirikiri oni kirarongo.) ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","Ngu oniku, ngu oowooye nga: Sayimon Yisasdo oowooyi Pita ero eyingo. Oowooyi gura ngu Enduru ngu Sayimonro koneyo, Yemus Yon Pilip Batolomeyu Matiyu Tomas Yemus ngu Alipiyasro nangoni, Sayimon. Enengo murini ngandiro, enengo mera ngu mera gura onindo sobowooweroyi ingonduduni kini oorengo. Yudas ngu Yemusro nangoni, Yudas Iskariyoot nguya yoyoyingo. Yudas Isakariyoot ngundo kootuyisina, damodamoni tero, Yisas mundi onino yootunoro yunowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yisasdo enengo kirikiri onikudodo mera purimonggo uro, mera ngguwugano dikaro oodoyi, oni simoo bare oowooyingga oorengo mayeyingo. Ene Yudiya meranonggo, Yerusalem endemonggo, ko wendeyi tamako ende Tayiya Sayidon ngunonggo, Yisasro mandeni ingowero mayeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Enengo sayi oni nguya Yisasdo yomosiyeroni, ero yoyoro mayeyingo. Oni gidarega ngu mbooro biyomimbo yomburiyeroyingomu, nguya Yisasdo yomosiyerootoni metemi temukoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Oni simoo bare urungga oorengo Yisas dowooro ingowero ingoyingo. Ndadiro nguro, enengo yanggangoni ngu goweyimonggo tunooteyingo. Ngundo sayi oni bidodo yomosiyerootoni, oni metemi tetenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yisas doongetero enengo kirikiri oniku yeyoro eyingo. Ye angoyi oni, oo gidaregaro wenonoro ngu, ye oni oni teya ingoyi. Anutdo ye ngu oo nguro hoorooweyerowa. Ataga ko kootuyisina nguya, Anut enengo endeningga sobowooro oorooteku nguno uwanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ye ataga Anutro mandeni murini gome nguro hahangero oorootenggoku, kawuyemboro kumootenggoku ngundiro tetenggoku, ene kootuyisina, ye samboro oowari nero kawuye ndindi tetoni, nguro oni oni tewanggo. Ye ataga weti mbumbuwa tetenggoku nguro nowoondoye ogingootoni, sendoro oorootenggoku ngu, kootuyisina Anutdo yengo kowuri ngu yowoorengootoni gome metemi tunootetoni, ye nguro oni oni tero nggonggangoro oruwanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ye oni oni teya oriyi, mera ngaro onindo ye yeyootoyi, Oniro Nangoni, nguro mande murini ngu keyoro oodoyi ngu, yeyoro nowoondoye biyomi kowoo oorengo ingoro, ye owero yoyokoro, mande biyomi ero, yengo oowooye nguya oo biyomimonggo ewanggo. Etoyi ngu, Anutdo ngu kowuriye ngu yoro yowoorengootoni gome metemi tunootetoni, ye komo oni oni teyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Naru gurano, yeno ngundiya teyunootoyiga ngu, ye ootoogeya Anutno oni oni teyi. Nguro yengo uriye sitowiye sambo endemo ngu urungga oorengo ooroote. Kowuri ye yunootenggoku, kurimi enengo osi sambayebo Anutro ingondudu eyingo oni, nguya ngundiro teyunoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ene ye beye sitowiyedodo oni, ye ingonda teyi! Gowugowurongo! Yengo nowoondoye ngu sitowiyemboro ingonduduye nguro yetoyi, dowoomomooro ooroote. Ye nowoondoye yomosiyoyingo oo ngu ye kuri yomukowonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ye mera ngaro oowari, ko oo ngu oo sitowi yomukowero hahangero endeyoote. Nguro gowugowurongo! Anutdo oowari gomemu yunootoni, kawuye ndindi teweroyimu ngu ye yokootenggokuro, kootuyisina, ye komo biyomi oorengo tewanggo. Ye ataga oni oni tero yomooro gonggangootenggo. Ene kootuyisina, ye ngu sendoro biyobiyomi tero oruwanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ene oni simoo bare bidodo ye oowooye bingamiye okootoyiga ngu, arisa, ye ingonda teyi! Kurimi, osi sambayebo ingondudu eyingo oni godange, nguro onino nguya ngundiro teyingo. Ene Anutro ingondudu eyingo oni hamoo, oni simoo baredo enengo mandeni ma ingoro, nguro ene mande inoro, kowuri gura gura inoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ye noro mandene ingootenggoku oni yeno eteno. Yengo mundi oni ngu nowoondoyi teyunoyi. Oni yeya nowoondoye biyomi yetoyiga ngu, yendo ngu komo muri gome nangge eneno teyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Oni yeya mande biyomi eya yomburiyerootoyiga ngu, ye nguro Anutno yemboongetoyi, Anutdo ene hoorooweyerowa. Oni ene kingo ye yomburiyerootoningga ngu, ye Anutno yemboongetoyi, Anutdo ene hoorooweyerowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Oni gurado gagiye gidaresina oorongooya yudoningga ngu, arisa, gagiye gidare nguya yowoorengootooga ureni. Oni gurado yengo dogigiro nengguro sobiyoya yootoningga ngu, ye yengo kumbaye nguya ma sorengowero. Ngu nguya yokoyinootooga, sobiyoya yoni. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Oni gurado yeno oo guraro kira etoningga ngu, ye komo ngu ooga ngu inoyi. Oni gurado yengo oo gura sobiyoya yootoningga ngu, ye komo ko yowero ma ewero. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ye oni nowoondoye yunoro muri metemi tetenggoku ngu ngundiro oni songombo yeno muri metemi tetenggo, nguro yengo nowoondoye ngundiro ingootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Oni ye nowoondoye yunootenggoku ngu, ye nguya ene nowoondoyi teyunoro ngu, asa, ngungga ngu, oo urungga kini. Weti mbumbuwadodo oni nguya, ene oni nowoondoyi teyunootenggoku, ene nguya nowoondoye yunootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Oni gura yeno muri gome tero, yooneneyeroro yomosiyerootenggoku, ye gumi ngundiro nangge yomosiyoro ngu, asa, ngungga ngu, ngu nguya urungga kini. Weti mbumbuwadodo onindo nguya ngundiro nangge tetenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ye oo gura oni yunoro ngu, ndadiro nguro ye ingootenggoku, enebana gumi yunowa, ero ingootenggo. Ye nguro ngu ndadiro esosongga tewanggo? Hamoo oorengo kini. Weti mbumbuwadodo onindo enengo dobooyi oo kingo inoro ngu, enebana oo gumi ngundiro nunowa, ero ingootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ene nondo yeno eteno. Ingoyi! Yengo mundi oni ngu komo nowoondoyi teyunoyi, ye komo nenengo muri gome ngu teya, oo kingo duwoo yunoyingo. Nguro ye ngu oo nguro gumi wendangero, oo gura yunoyi, ero ma ingowero. Oni Anutno esoso ma tetenggoku ko oni biyobiyomi nguya Anutdo ene sumange teyingoote. Ye ngundiro tero ngu, kootuyisina, yengo uriye urungga oorengo Anutro sambo endemo yoro, Anut urungga nguro simoongo tero oruwanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Yengo Awayembo yengo nowoondoyi teyunooteku, ngundiro nangge, ye komo nguya oni songomboro nowoondoyi teyunoyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ye oni gidarega goweye sanggawero mande ero ma wirikoyerootenggoku ngu, asa, Anutdo nguya ye ma wirikoyerowa. Oniro kowuriye, wirikoyunoro, nguro kowuriyengga tewonggoku, nguro yengo ingonduduyemo sugi sugi ma ingondudu tero oruwero. Ye ngundiro tetoyi ngu, Anutdo yengo kowuriye nguya ma ingonduduwooro oruwa. Ye oni guminggaro weti mbumbuwaye andangero kabetewanggoku ngu, Anutdo yengomu nguya andangeyunoro kabetewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ye komo oni oo gidarega yunowanggoku ngu, enebana ye yunowa. Yo, yengo oo wirikoyingo gome nenengo onindo nguya ngundiro oo gome nenengo oorengo wirikoro, urungga oorengo si wongondidiboro siriyootoyi, manggowoomo oorero, wendoni uweroyi tetoni, nguro kowuri okooweroyi kinitetoni, ye yunowanggo. Yendo oni yunowonggoku, ngundiro nangge, Anutdo ye nguya ngundiro yunowa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yisasdo mande adingayi gura nguya ero eyingo. Oni gura doongeyi kiringo, ngundo oni gura nguya doongeyi kiringomu oore etungowa, bine? Kini, enengo eraya eraya mereno yoyoro sorewari. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Skul simooye ngu oo etuyeroyingo oni ngu ma dagayerowanggo. Kini, ene uru tero ingoyingo gome yorogogo ene etungoyingo oninggakundo ko tetenggoku ngundiro ko tewanggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ene mande adingayi gura ngandiro eyingo. Ndawugaro dobooge doongeyimo oo kakawu bodaga oorooteku ngu kenoro ete, ko gengo doongenggemo de sosi urungga oorooteku ngu ma ingowo? ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ge ndatero nguro doboogeboya eteku, doboone, doongenggemo oo kakawu bodaga oorooteku ngu, yewega toongeni, ero ete, ene gengo doongenggemo de sosi urungga oorooteku, ngu ge ma kenoyingo? Ge mebuge tegedodo oni! Ge koreteya komo gengo doongenggemo de sosingga oorooteku ngu, ngu yega toongetoningga, arisa, kootuyisina, ge dobooge doongeyimo oo kakawu oorooteku, nguro gome doongetero yeyi toongewa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","De metemi, ngundo engge biyomi ma enggete. Ngundiro nangge, de biyomi ngundo engge metemimu ma enggewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Onindo ngu de engge nguno kenoro ingootenggoku, ngu de metemi ngundi de biyomi. Onindo bata dega nguro engge ngu utoo sanggiridodo oowooyi dimoo utoo, ngu bungomonggo ma dangero yootenggo. Ngundiro nangge, bo nggire ngundo nggire oorengo engge ma enggewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Oni gome metemingga ngu, ene newendemo ingoyingoni gome metemimu newendemo ooroote. Nguro ingonduduni mandeni gome gome nangge ingoro, enengo ootoo ootoo murini, nguya gome metemi ngu yeni tunootete. Oni biyomi ngu enengo ootoo ootoo murini nguya biyomi, ko ingonduduni biyomi ingooteku, ngu nguya yeni tunootete. Enengo newendemo muri oorooteku, ngundiro nangge ene koyi tero, manggowoomo nguya yeni tunootete. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ndawugaro ye noya ngandiro etenggo, Urungga, Urungga oo bidodo Simburi Simbunani, ero etenggo, nguro ye noro manggone ma keyootenggo? Ene ye noro mandene murine ma keyootenggoku ngu, asa, ye noya Oo Bidodo Simburi Simbunani, ero ma ewero. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Oni gura gura no tanggenemo omburo noro mandene ingoro keyooteku ngu, no enengo murini nenengo etuyerowano. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ngu oni ngu ngandiro. Oni gura ene ya yewero ingooteku ngandiro. Oni ya yewero ngu, ene mera sero gasiyoro mera yanggangonggakuno mere sero de nonggininggaku nguno yetenggo. Ngundiro tero ngu, asa, ngu sanganimo ya yewa. Kootuyisina, sono doogo urungga tero mewuyi omburo ya samango damoni setoni, yanggaku onggi anggi ma tewa. Yanggango dikaro oruwa. Ndadiro nguro, ene koretero ya nonggini ngu mera yanggangomuno mere sero nguno ya yewoku nguro. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ene oni gura noro mandene ingoro yokoro, ngu ma keyooteku ngu, ene oni gura mera mbumbuwango sanganimo mere bodaga nangge sero, nguno nonggini pararo ya nonggini ma samangoyingo. Ngundiro tero, ene kingo mera bodagado damoni wiriyoro nguno ya yeyingo. Ngundiro yetoni, kootuyisina, sono mewuyi tuwi uro yanggaku bungomo oorongootoni, yanggaku onggi anggi tero, ukero uwa. Oni ene noro mandene ingoro yokoro, enengo ingonduduni keyooteku ngu, ngundiro tewa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Asa, Yisasdo oni simoo bare doongeyemo mande ngu yootunoro ero etuyeroro yokoro, ene Kapeniyam endemo uyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Me oniro tabango gura nguno oruwoku, ngu oningga ngu Rom Gabuman (Yuda oni kini) ngunonggo mayero, ene me oni ngu onibi kandegura (100), nguro sobosobo oningga oruwo. Ngu oningga nguro kirikiri oningga nguro gome ingooteku, ngu sayi urungga yoro kumoowero teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ngu me oniro tabangongga ngu mande ingoworomu ngu, Yisas Kapeniyamno ooroote. Ngu ingoro, ene Yuda oni tabango gidarega soweyeroro eneno etoyiga ombuya enengo kirikiri oningga ngu yomosiyoni, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Ngundiro etoni, ene Yisasno omburo ngguyinggayi tero, Yisasno eyingo. Ge komo ma yokowero, ene oni gome, enengo kirikiri oni, ngundo sayi urungga kumoowero tetoni, nguro ge mete ene hooroowe! Enendo, noorengo Yuda oniniro yambo ya gura yeyunoyingo. Ene Yuda oni simoo bare noorengo gome ingoro, newende yunoote. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yisas enengo mande ingoro, arisa, ene ootoogero ngu Yuda oniro tabango onikuya oorowuyingo. Yade oororo, ya tanggeyimo oorowutoyi, ngu me oniro tabangongga, ngundo dobookuriyi gidarega sureyeroro eyingo. Ye ende ooreya ngandiya eyi. Urungga Oo Bidodo Simburi, ge ngaro ko urungga ma tewero. No oni nenengo kini, ngundiro nguro, ge noro ya newendemo ma ombuwero. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nguro ngu, no nenengombo ge tanggegemo ma oorowuyingo. Nguro ge mande gura nangge etooga, noro kirikiri oninengga nga ko metemi teni. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ngu ngandiro; no ngu oni ko no nunootenggoku, nguro kirikiri oni. Nondo nguya ngu me oni gidarega sobosobo oorooteno. Ene nondo ngu me oni ngu guraya eteno. Ge oorowu, ero etoowe ngu, ene oorowute. Guraya eteno. Ge ombu ero etoowe ngu, ene ombute. No kirikiri oni guraya eteno. Oo ngu yomosiyo, ero etoowe ngu, ene oo yomosiyoote. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ngundiro ero yokootoni ngu, Yisasdo ngu mandega ngu ingoro, nguro ingondudu urungga ingoro, yowoorengoro, oni simoo bare urungga ene keyoro endeyootenggoku, nguno eyingo. No yeno eteno. Iserel oni kewooroyemo oni gura, nga oningga newendemo hamoo teyingongga, ngandiro ma kenooteno. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Me oni tabangongga ngundo oni sureyerootoni, Yisasno oorewonggoku ngu, ya newendesina uro, sayidodo oninggaku kenoyingomu, ene kuri metemi oorengo teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Kootuyisina, Yisas ootoogero, Nayin endegano nguno oorowuyingo. Yisas enengo kirikiri oni ngu bidodo, ko oni simoo bare oowooyingga oorengo nguya enedodo oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Yisas garo yade oororo, endesoono oorowuyingo. Ngu endega nguro onindo, oni gura kumootoni, bingo sumooro koorowooro uyingo. Ngu simoongga kumoowoku nguro nemi ngu, nangoni komo gurananggemu kumooteku ngu! Ngu endega nguro oni simoo bare urunggaku ngu bare wabugakundo sendoro utoyi, nguro ene keyoro uyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Urungga oo bidodo Simburi, Yisas ngundo ngu bare wabuga ngu kenoro, nowoondoyi urungga tero, eneno eyingo. Ge ma sendowero. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Yisas ene onibi sumooro ombuyingomu tanggeyimo oororo, onibigakuro Pawusdodo dowooyingo. Oni onibi koorowooyingo oniku dikaro nenetero oodoyi, Yisasdo eyingo. Simoo oore, no geya eteno. Ge ootooge! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ngu oni kumooyingonggaku ootoogero bibitero, mande etoni, Yisasdo dowooro, oororo nemi ko inoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ngundiro tetoni ngu, oni simoo bare bidodo soriyokoro, Anutro bingami okooro eyingo. Anutro ingondudu eyingo oni urungga, noore kewooronanimo ataga tunootete, ero eyingo. Ngundiro ero, Anut kuri ombuwoku, ngundo enengo oni simoo bare hoorooweyerowero! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yisasdo ngu kongga tewoku, nguro mandeni ero endeyootoyi, Yuda mera ngu rogowootoni, oororo mera songomo nguya, ero soweyoro sayingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","19","Sonoyeroyingo Yondo, enengo kirikiri onindo Yisas ko tewoku, ngu bidodoboro murini, Yonno etoyi ingoyingo. Ngundiro tetoyi, ene ingoro, Yondo enengo kirikiri oni eraya negoyerootoni ombutori, sureyerootoni, Oo Bidodo Simburi urungga, nguno mande yoro oorowuworiyo. Yari Yisasno ooroya, ngandiya sumoo eri. Ge Anutdo surenggerootoni, noore yoyoweroyi oninggaku, ngundi, noore komo oni guraro doongetero sobowoowato, bine? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ngu oni erayaga ngu Yisasno omburo eworiyo. Sonoyeroyingo Yon ngundo noore ngandiro ero sureyerootoni ombutero. Ge nga oningga nga, Anutdo surenggerootoni noore yoyowero, binengga, ngundi, noore oni gura sobowoowato, bine? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ngu narunggano nguno, Yisasdo oni simoo bare urungga oorengo, sayi muri gura gura yomosiyeroro, oni merambooro biyomidodomu oowooyingga oweyeroro, oni doongeye kiringomu yooneneyerootoni, ene doongetero oo kenoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ngundiro tero yokoro, Yisasdo Yonro kirikiri oni erayagakuya eyingo. Asa, yari ooroya, Yonno eri. Oo ataga yarindo kenoro ingooteriku nga! Oni doongeye kiringomu ene doongetetenggo. Oni kekandeye bingo yero biyomi yeyingomu, ene mete tero, metemi endeyootenggo. Oni gorimambudodomu ngu goweye metemi tetenggo. Oni sodeye tuwoomu, mera mande ingootenggo. Oni kumooyingomu, ko keta ootoogetenggo. Angoyi oni, ene Anutro mande keta mesarango nga ingootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Oni ene noro newendemo hamoo tero buribari ma teyingo ngu, asa, ngu oni ngu, ene mete oni oni tero oruwa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Sonoyeroyingo Yonro kirikiri oni erayagaku mande ngundiro ingoro, ene Yon tanggeyimo ko oorowuworiyo. Ngu naruno, Yisasdo oni simoo bareno Yonro eyingo. Kuri oni kini kingo merako nguno, ye oororo ndawu ooga kenoyingo? Ye nggusi duwoo doogobo yowooraringootoni, kenowero oorowuyingo, bine; ngundi ye oororo oningga oo buribari tetoni kenoro oorowuyingo, bine? Kini, Yon ngu ngundiro oni kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ngundi ye ndawu ooga kenowero oorowuyingo? Oni gura towikumba gome gomemu tero oodoni kenowero, bine? Kini, ingoyi! Oni towikumba gome gomemu tero ngu, ene sitowiyedodo tero, enengo ya gome oruwanggo. Kini, Yon ngundiro kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ene ye ndawu ooga kenowero oorowuyingo? Ye Anutro ingondudu eyingo oningga kenowero, bine? Yo, no yeno hamoo eteno. Yon ngu Anutro ingondudu eyingo oni. Enendo Anutro ingondudu eyingo oniku, ngu dagayeroro, enendo nangge urungga oorengo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ngu Yonngga, nguro Anutro mandeno Anutdo enengo Nangonimboya ngandiro eyingo. Ingo, no oni gura sureyootoowe, ngundo noro mandene yoro, ge koretegunoro oororo, gengo oore yomosiyonggunowa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","No yeno eteno. Yondo Anutro ko teteku ngu, ngu oni merako ngano ko tero oorootenggoku, ngu bidodo dagayeroote. Ene oni Anutro nowoondoye hamoo teyingo, ko noro mandene keyootenggoku ngu muringga ngundo Yon ko yanggango tewoku ngu dagaro urungga. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Yisasdo Yonro mande etoni, oni simoo bare bidodo ingoro yokoro, asa, simoo baredoya, digi beye yoyingo oniya eyingo. Yo, Anutro mande murini ngu gome oorengo. Eyingo. Ngu oni ngu, ene Yon kandeyimo sono kundingiyi gimuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ene Parisi oni, ko mamana mande kandangero etuyeroyingo oni nguya, ene Yondo ma sonoyeroyingo. Ene ngu Anutdo oore gomemu etuyerootoni, ene kootu inoro yokoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yisasdo eyingo. Nondo nga naruno, oni simoo bare endeyootenggoku ngaro muriye wirikootoowe, ndadiro oningga ngundiro? ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ene ngu simooye iriritero ngandiro teyingo. Ene ende kewooroko bibitero, enengo nangge meno manggaru tero ewanggo. Noorendo sumbi uwootooye, ye yambo ma utoro kunoyingo. Noorendo oni kumootoni ngguyinggayi tero nowoondoyi teweroyi yambo urewootoku, ye ma sendoyingo. Eyingo. Simooye gidega oo tetoyi ko nguro simooye guminggado sureye kiniteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ene sonoyeroyingo Yondo omburo, ene oo manongoyingo ma nero, Wayin sonoyi nguya ma neyingo. Yendo ngu ewonggo. Mbooro biyomi eneno ooroote, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ene Oniro Nangoni Kirarongo omburo, ene oowari nero, sono nguya netoni, yendo ngu kenoro etenggo. Kenoyi, nga oningga nga, ngu oo bidodo nemukoro, Wayin sonoyi nguya gome gome neteku nga! Nga oningga nga, ngu beye yoyingo oni, weti mbumbuwadodo oni nguro dobooye, ero etenggo. Noorendo oo gura tetoowe ngu, ngu bidodo ye nguro ma ingootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Oni simoo bare Anutno nowoondoye hamoo teyingo ngu, enengo keta oruweroyi ngu enggedodo. Oni gidarega keta oruweroyi gomemu ngu kenoro ngundiro ingootenggo. Anutro mande ngu hamoo oorengo, ero ingootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Naru gurano, Parisi oninggado Yisas negongootoni, enengo yano ombutoni, eneya gobooro oo neweroyimboro eyingo. Ngundiro etoni, asa, Yisasdo omburo, eneya oo neweroyimboro oororo, Parisi oningga ngundo yano uro, oo neweroyi yabano bibiteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ngu endemo nguno, bare gura oruwo. Ngu barega ngu, ene buribari sebo barese muri biyomi keyooteku, ngundo ingoworomu, Yisas Parisi oningga nguro yano uro, oowari netenggo. Nguro ngu, barega ngu ene ootoogero, digi nggusiyi gomenggano bo urumi ndindingo gomengga yoro ombuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ngu barega ngu omburo, Yisas kootuyisinanggo omburo, Yisas keyi damonimo dikaro sendootoni, doongeyi sonoyimbo uro Yisas keyi sonowootoni ngu, enengo tabango uyimbo yonggurumooyingo. Ngundiro tero, Yisas keyinggaku dureyoro, nguno bo urumi gomengga ngu wendoro, ngundo Yisas keyi sonowooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Parisi oninggado Yisasno etoni, enengo yano ombuwokungga, ngundo ngundiro tetoni ngu, kenoro, ene ngandiro ero ingoyingo. Nga oningga nga, ngu Anutro ingondudu eyingo oni tetoni ngu, asa, ene barega ngaro murini biyomini ngu kenoro ingoro asa, nga bare biyomingga ngando omburo tanggeyimo roogo yetoni, ma ombuwa, ero ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ngundiro ingootoni, Yisasdo ngu oninggakuro ingonduduningga ngu gumi ero eyingo. Sayimon no geno mande gura ewero. Etoni, Sayimondo eyingo. Oo etuyeroyingo oni, mete mandega ngu e. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yisasdo mande adingayi gura eyingo. Beyedodo oninggado oni eraya beye gumimboro yunoyingo. Oni gurano doobe onibi eraya kande eraya (500 Kina) inoro, ko oni gurano doobe kandegura (50 Kina) nangge inoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Kootuyisina, beyeku wendangero gumi ngundiro inoweroyi nguya ereremo kini. Nguro beye simburiga, ngundo nguno yokori, ero eyingo. Arisa, ngu oni erayaga ngu, onendo beye simburiga nguro gome oorengo ingoro eroruwa? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Sayimondo ngundiro ingoro, gumi eyingo. Ngu oningga beye urungga kingo inoyingongga ngundo. Ngundiro etoni, Yisasdo ko eyingo. Ge hamoo nenengo ingoro ete. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","45","Yisasdo baregakusina yowoorengoro, kenoro Sayimonya eyingo. Nga barega nga keno. No gengo ya newendemo ombutoowe, kene sonowooweroyi sono gura ge ma nunoyingo. Ene nga barega ngando enengo doongeyi sonoyimbo kene sonowoote. Ngundiro tero, enengo tabango uyimbo yonggurumooro yomosiyoote. Ge no ma yenggonaneroro dureneroyingo, kuri gengo yano ombuwonoku, ngunonggo omburo anangu nga! Ene nga bare weti mbumbuwadodoga ngando, ngu ene kenengga ame dureyowero gome ingoro, hahangero yade mayero dureyoote. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ge noro tabane bo urumimbo ma sonowooro dowooyingo, nguro ngu, ene barega ngando moondeye dowooweroyi kumu bo urumi gome, ngundo kene sonowooro yoonenengoote. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ngundiro nguro, no geno eteno. Nga barega ngando, ene noro nowoondoyi urungga oorengo teteku, nguro nondo enengo weti mbumbuwani urunggaku andangetoowe ute. Ene oni guraro weti mbumbuwani bodaga tewoku ngu, Anutdo ngu andangero inootoni uwa. Ngu oningga ngundo newende bodaga nangge Anutno esosootewa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yisasdo ngu barega nguya eyingo. Gengo weti mbumbuwage nondo kuri andangeteno. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Oni Yisasya oo newero bibitewonggoku, ngundo ngu ingoro, enengo nangge mande ero ingoro eyingo. Nga oningga nga, ngu oone, ene mete weti mbumbuwa andangero yokowa? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yisasdo ngu barega nguya eyingo. Ge Anutro nowoondogemo hamoo teyingongga ngunonggo Anutdo ge ko goyoote. Ge mete sumangedodo toongeya nowoondoge imakeyingomo ootoo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","3","Kootuyisina naru gidaregano, Yisasdo enengo kirikiri oni kande eraya kegidemboro erayaga nguya, Anut oo bidodo Simburi Simbunani, ngundo enengo narungga sobowooteku nguro mande mandeni murini, ngu ende ururu, ende bobodi ngu bidodomo, oni simoo bareno wesiyoro ero etuyeroro, oororo omburo teyingo. Bare gura gura nguya, ngu bare ngu Yisasdo kuri mera mboorododomu owero andangeyingoku ngu, ko sayidodomu yomosiyeroyingoku, ngundo Yisas keyoro endeyoyingo. Nguromu, bare gura oowooyi Mariya nguya ngandiro etenggoku, Mariya Magadala bare, ero etenggo. Ngu baregano nguno merambooro kandegura gidemboro eraya (7) oweyeroyingo. Bare gura oowooyi Yowana ngu Herodro yanimo ko sobosobo oningga, oowooyi Kusa nguro bareyi; Susana ko bare gidarega nguya Yisas keyoro, mandeni ingoro yariyingo. Ngu bare ngundo enengo beyebo Yisas ko enengo kirikiri oniya hoorooweyerootoyi, ngundo oowari oo uriyoro nero endeyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Endeni endeni oni simoo bare oowooyingga oorengo ende bidodomonggo mewoosooro Yisas tanggeyimo mayero yowuruwooro dikayingo. Ngu naruno, Yisasdo mande adingayi gura ngu oni simoo barekuno ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Oni gurado Rayis yuwooyi kono yoro oororo kuriyoyingo. Ngundiro kuriyootoni Rayis yuwooyi gumingga oorekono soretoni, onindo wongoomukootoyi, numbo mayero newonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Oo yuwooyi gidarega mera digi gorogorono soreyingo. Ngu oo yuwooyiku ngu gome ooreyingomu, ene mera nguno urumi kini. Ngundiro nguro, oorero ari yero bidodo kumoomukoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Gidarega huru sodabo, kakari so oo kewoorokono soreyingo. Ngu huru so kakari ookudodo oorero ngundo doobeyerootoni siyagongo yeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Rayis yuwooyi gidarega mera gome metemimo soreyingo. Ngu nangge gome oorero engge oowooyingga oorengo enggeyingo. Yisasdo ngundiro ero yokoro, manggaru tero eyingo. Oni gura mande ingoweroyi sodeyidodoga tetoningga ngu, ene komo mande nga gome oorengo ingoni! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yisas enengo kirikiri onindo, Yisas sumoo inoro eyingo. Ge mande muri wiriyoro, ge mande adingayi nangge eteku nguro damoni ndadiro? ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Etoyi, Yisasdo gumi eyingo. Ye ngu, Anut oo bidodo Simburi Simbunani ngundo simoo bare enengo sobowooteku, ngu mande kombiteyingongga ngu ye kuri Anutdo etuyerowo. Ene simoo bare gidaregado ngu, ene mande adingayi nangge ingootenggo. Ene kenowero doongetewanggoku, ene ma kenowanggo. Ene mande ingowanggoku, ene nowoondoyemo mande ngu ma ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Mande adingayi ewonoku, ngu muri ngandiro. Ngu oo yuwooyiga ngu Anutro mandeni. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Oo yuwooyi gidarega oorekono sorete, ero ewonoku ngu, oni simoo bare Anutro mande ingootoyi; kootuyisina, Setando omburo ngu mandeku, oni nowoondoyemonggo andangero yootoni, nguno ene Anutro nowoondoyemo hamoo ma teyingo. Nguro ngu, Anutdo ene ma yoyowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Digi sanganimo ero ewonoku ngu, oni simoo bare koretero Anutro mande ingoro, nguro gome ingoro, oni oni tero ngu koyi teyingo. Ene ngu nowoondoyemo hamoo teyingo ngu bodaga nangge tetoyi, ngu naruno kowuringga kenoro, nguno enengo hamoo ingowonggoku ngu yokowo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Oo yuwooyi so dabo sanggiridodo oorooteku kewooroko, ero ewonoku ngu ngandiro. Simoo bare Anutro mande ingootenggoku, kootuyisina, mera ngaro kowuri gura gura, beye oo sitowi, oo nguro hahangero ingondudu teyingo. Oo nguro nowoondoyemo mande oo ngu dobengoro wiriyootoni, ari yero, enggeye moore kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mera gomemo oo yuwooyi sorero oorete, ero ewonoku ngu, simoo bare Anutro mande ingoro, ene nowoondoye gome yomosiyoro, hamoo ingoro yoro yanggango dowooro keyootenggo. Anutro nangge ingondandangero endeyootenggoku ngu, ene gome enggetenggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Oni soru karo kumbe oo newendemo ma yero wiriyoro, ko yaba newendemo nguya ma yetenggo. Kini, yaba sanganimo yetoyi, ngundo oni gumingga nguya himi yunoote. Oni gidarega ya newendemo omburo ngu, ene soru ngu kenowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Nga mande Anut oo bidodo Simbunani ngundo simoo bare enengo sobowooteku, ngu oo bidodo kombiteyingo ngu, kootuyisina oo ngu tunootewanggo. Oo bidodo onindo oongooyingo ngu, kootuyisina, Anutdo yeni tunootemukowa. Oni oo ngu doongeyembo tunoo kenomukowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ye komo ingonda teyi! Ye komo ndadiro mandega ngu gome ingoyi! Oni ene Anut oo bidodo Simburi Simbunani ngundo simoo bare enengo sobowooteku ngu, nguro ingoyingo bodaga ingoro oorootenggoku ngu, ene newende bidodo hahangero enengo mande ingoro keyootenggoku, asa, Anutdo enengo ingoyingongga ngu yeni urungga yewa. Ene oni ene Anut oo bidodo Simburi Simbunani ngundo simoo bare enengo sobowooteku ngu, nguro muri bodaga ingooteku ngu, asa ngu ingoyingongga soweyoro gumi ma ingootoni ngu, asa, Anutdo enengo ingoyingo bodaga ngu yoro oongoowa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ngu naruno nguno, Yisas enengo nemi, ko enengo konedobooge ngundo Yisasno mayeyingo. Ene oni simoo bare urungga oorengo nguro, ene Yisas tanggeyimo ombuweroyi nguya kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Oni gidaregado Yisasno eyingo. Gengo nanggeboya konedobooge ge geyowero mayero endesina dikatenggoku awe. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ngundiro etoni, Yisasdo mande gumi eyingo. Oni ene Anutro mande ingoro ngu keyootenggoku, ngu noro namone, ko noro konedoboone. Ngundiro ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Naru gurano, Yisasdo enengo kirikiri oniya wanggo gura sanganimo oorero eyingo. Ye wanggo woosootoyiga noore sono koongeyingo anduroko uroorewato. Yisasdo ngundiro etoni, wanggo woosooro wenggeremooro urooreyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Wanggo sono koongeyingo sanganiwoore uroruwootoni, Yisas wanggo sanganimo wetoro kabeteyingo. Ngu naruno, doogoga sono koongeyingo kewoorokono tunooteyingo. Ngu doogo urungga, ngundo wanggo yowooraringootoni, wanggo nguya sono koongetoni, ene oonootewero teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ngundiro tetoni, kirikiri oniku oororo, Yisas yokutuwooro eyingo. Awa, Awa! Noore oonootewero tetetoku nga! Eyingo. Etoyi, Yisasdo ootoogero, doogogakuya sono koongeyingo nguya yeyoro etoni, imakero kiniteworiyo. Doogogaku ko sono koongeyingonggaku ma dokero ikakooteyingo, kondibo imakeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ngundiro tetoni, Yisasdo kirikiri oniku mamanayeroro eyingo. Yengo nowoondoye hamoo ngu ndano? Eyingo. Kirikiri oniku goweye mboorombooro tero, sosorero ngunonggo, enengo nangge ero ingoro eyingo. Nga oningga nga onendo? Doogoya ero, ko sono koongeyingomboya etoni, enengo eraya eraya ene manggowo ingooteriku ngu! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Kootuyisina, ene Gegesa merasina nguno oorowuyingo. Ngu mera ngu, Galili sono koongeyingo ngu gidaresina ooroote. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yisas ene kirikiri oniya wanggo yokoro wendeyi tamako uyingo. Nguno ende gura oruwoku, nguno oni gura oo mbooro biyomimbo yoyingomu, ngundo Yisasno ombuyingo. Ngu oni meramboorombo yoyingongga ngu, ene naru pirungga towikumba ma yemuyingo, ene mbirimbiri endeyoro ootooro, ene ya gurano nguya ma oriyingo. Kini, ene naru bidodomo oni yoyeyingo merewoore nangge wetoro oruwo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Kuri ngu, mbooro biyomingga nguro yanggangoni ngundo oningga ngu gome dowooro oodoni, nguno enengo onindo ene dowooro kekandeyi gome gome gosiyoyingo. Gosiyoro ya biyomimo oni ngundiro sobowooro oriyingo. Ene mbooro biyomi nguro yanggangoni, ngundo ngu sen uto bidodo oomboomboongero ootooro, ene oni yeni oni kini merasina nguno toongero endeyoro oruwo. Ngu oningga, ngundo Yisas kenoro meno manggaru tero, Yisas keyi damonimo ukero merako wereyingo. Ngu oni mboorombo yoyingongga, ngundo manggaru urungga oorengo tero eyingo. Ge Yisas Anut awuno oorengo nguro Nangoni! Ge nono ndawu ooga tewa? No geno ngguyinggayi tero, kira etenoku, ge no ogingo ma nunowero! Eyingo. Yisasdo ngu mbooro biyomingga nguya kuri, ene ngu oningga ngu yokoya toongeni ero ewo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Arisa, Yisasdo sumoo inoro eyingo. Ge oowoongge ngu ndawuga? Etoni, mbooro biyomingga ngundo gumi eyingo. No oowoone Ami ewo. Ndadiro nguro, mbooro biyomi oowooyingga oorengo, ngu oningga ngu newendemo uro oorootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ngu mbooro biyomi, ngundo mande yanggango oorengo Yisasno ngguyinggayi tero sumoo sumoo eyingo. Ge noore soweyerootoyi mere ooriroyi oorengo wenga kini nguno ma uwero! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ngundiro etoyi, ngu mera puri bodaga namokono, nguno bo oowooyingga nguno so erewero neroruwonggo. Ene ngundiro kenoro Yisasno ngguyinggayi tero sumoo sumoo eyingo. Mete noore bo ngu nowoondoyemo uwato, bine? Etoyi, Yisasdo gumi eyingo. Yo, ye ngundiya teyi. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Arisa, ngu mbooroku oninggaku yokoro, sodedomangge ene oororo boku nowoondoyemo utoyi, asa, ngu boku yanggango oorengo kendutero oororo, mera biyomi kembemo sorero sono koongeyingomo uro sono nero kumoomukoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ngundiro tetoni, bo sobosobo oniku ngundiro kenoro, sodedomangge endemo saro, ene oo tunootewoku ngu mandega ngu wesiyoyingo. Ngu mandega ngu ende urunggano onino, ko diguno ende bobodikuno onino nguya ero endeyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ngundiro etoyi, simoo bare ngu ooga ngu kenowero Yisas tanggeyimo mayero mayero oni mboorombo yoyingongga ngu kenoyingo. Mbooroku ene kuri yokoro besero satoyi, ene towikumba yemuro ingonduduni nguya himi yetoni, ene nenengo Yisas tanggeyimo bibitero ooroote. Oni simoo baredo ngundiro kenoro ene soriyokoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Oni Yisas kenootoyi, oni mboorombo yoyingonggano oo tewoku nguro mandeni, simoo bare ngu kenowero kootu mayetenggokuno eyingo. Kuri ngu mbooro biyomimbo nga oningga nga, dowooro oruwo. Ene ataga ngu, ene metemi teteku nga! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Gegesa merasina oni simoo bare bidodo ngu oningga ngu kenoro, ko bo nguro nguya ingoro, nguro ene sosoreyingo urungga tero, Yisasya eyingo. Ge komo noore yoyokoya toonge! Ngundiro etoyi, nguro Yisas ene kirikiri oniya wanggo sanganimo oorero, ene sono koongeyingo gidaresinanggo ko oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","39","Ngu oningga ngu mbooro biyomi ngundo yokowonggoku, ngundo Yisasya toongewero Yisas sumoo sumoo inoro, eyingo. No komo geya oorowuwero. Etoni, Yisasdo sureyoro eyingo. Kini, ge gengo endemo ooroya, Anutdo geno oo tetoni tunootewoku, nguro mandeni yootunoya e. Eyingo. Ngundiro nguro, ngu oningga ngu ko yowoorengoro oorowuyingo. Ene Yisasdo oo tetoni tunootewoku, nguro mandeni enengo endemo oni simoo bare bidodomo yootunoro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yisas ko yowoorengoro ombuworomu ngu, simoo bare urungga oorengo wendeyi tamako yowuruwooro Yisasro doongetero oriyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Ngu naruno, oni gura oowooyi Yayiras ngu, ene Yuda oniro yowuru ya nguro tabango oruwoku, ngundo Yisas tanggeyimo omburo, keyi damonimo bagootero, sumoo sumoo eyingo. Ge komo noro yano u. Eyingo. Ene ngundiro ewoku ngu ndawugaro, Yayiras ngu namboni gurananggemu enengo dagomani ngu kande eraya kegidemboro eraya, (12) ene komo kumoowero namokono teyingo. Asa, Yisas ene Yayirasdo yano oorowuwero oorowutoni, ene simoo bare urunggakundo oore doongooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nguno bare gura nguya oruwoku, ene komboro sayi yoro, yambiyootero, dagoma kande eraya kegidemboro eraya (12) oruwo. Sayi mambu yomosiyoweroyi oni gurado enengo sayiningga ngu yomosiyoyinoweroyi nguya kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ngu barega, ngundo Yisas kootuyisina, kendungomo omburo, torige kandedibiyi, Yisasdo nenggurono yeyingo. Ngundiro tetoni ngu, sodedomangge enengo sidudaroniku sori yetoni, ko ma ombuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ngundiro tetoni, Yisasdo eyingo. Onendo kandeyi nono yete? Etoni, oni bidodo mandeni gumi eyingo. No kini, no kini eyingo. Etoyi, Pita garodo eyingo. Oo etuyeroyingo oni, simoo bare urunggado pawanggeroro ngundo woorogogerootenggo. Ndawugaro, ge ngundiro sumoo ete? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ene Yisasdo eyingo. Oni gurado kandeyi nono yetoni, no ingootoowe, yanggangone gidega noyokoro, eneno oorowute. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Asa, ngu barega ngu ingoyingo, ene kombiteweroyi nguya kini. Ngundiro nguro, ene sosorero mboorombooro tero, ene omburo, Yisas keyi damonimo bagootero, enengo sayini nguro muri wesiyoro simoo bare doongeyemo eyingo. No sayi, ngundiro nguro, omburo kandene Yisasro nenggurono yetenoku ngu, ndawugaro nguro, no nowoondone hamoo tetoowe, Yisasdo mete yomosinerowa. Ngundiro tetoowe, nenengo sayine sodedomangge kinitete. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ngundiro etoni, Yisasdo gumi eyingo. Nambone, gengo nowoondogemo hamoo teteku, nguro Anutdo goyeni mete tete. Ngundiro nguro, ge mete ooroya, nowoondoge imakeyingomo ootoo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yisas ngu mande ngu ewoodoni, Yayirasro yanonggo oni gura omburo, tabango oninggakuno eyingo. Gengo namboge ngu kuri kumoote. Ge oo etuyeroyingo oni ngu keyi ma ogingoro oorowuwero. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yisasdo ngu mandega ngu ingoro, tabango oninggakuya eyingo. Ge ma soriyowero. Ge komo nowoondogemo hamoo teni. Namboge ngu ko mete tewa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Arisa, Yisas tabango oninggakundo yano oorowuyingo. Yisasdo simoo bare eneya ya newendemo ma uwero, ero, nguro ene oweyeroyingo. Yisasdo Pita Yon Yemus ko eweyi nemi ngudodo yoyoro, ya newendemo uyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Oni simoo bare urungga ngu simooyengga nguro sendo moguru teroruwonggo. Nguro ngu, Yisasdo eyingo. Ye ma sendowero, ero eyingo. Nga ngu ma kumooyingo. Ene ngu wetoro ooroote. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Yisasdo ngundiro etoni, nguro ene urungga yomooyinoyingo. Ene ingoyingomu ngu hamoo oorengo kumooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ene Yisasdo bare bodaga ngu kandeyi dowooro, meno ero eyingo. Bare buniyo, ge ootooge! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Arisa, ngu bare bodaga nguro gaboyi omburo woorogongootoni, ene sodedomangge ootoogeyingo. Ngundiro tetoni, Yisasdo mande yunoro eyingo. Ye oowari inootoyiga neni, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ngundiro etoni, bare bodaga nguro eweyi nemi ngundo urungga oorengo soriyokoro, oni oni tetori. Arisa, Yisasdo mande yanggango oorengo eweyi nemimo eyingo. Yari ngaro mandeni oni gurano hamoo oorengo ma ewero, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yisasdo enengo keyimo kirikiri oni kande eraya kegidemboro eraya ngu negoyerootoni, omburo yowuruwooyingo. Ngundiro tetoyi, Yisasdo mbooro biyomi ko sayi muri gura gura nguya yomosiyoweroyi yanggango urungga yunoro rogoyeroyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ngundiro sureyerootoni, saro, Anut Oo Bidodo Simburi Simbunani, ngundo enengo simoo bare sobowooteku muri nguro mandeni ngu ero etuyeroro, ko sayiye nguya yomosiyerootoyi, mete teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Yisasdo ene eyingo. Ye sawero ngu, oo sitowi gura gura ma yowero. Ye usudogo, kasi, oowari, oo uriyowero digi beye, towi nengguro eraya eraya ma yowero. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Oni gurado yoyoya, enengo yano utoningga ngu, ye komo ngu yanggano nguno nangge oriyi. Ye ootoogero saweroyi narunggano, nguno nangge, ngu yangga ngu yokoya sayi. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ye yoyoro yano ma utoyiga ngu, asa, ye ngu endega ngu yokoya sayi. Yengo keyemo ende nguro gugukakawu nogoru keyemo damoowoku, ngu enengo endemo nguno ko gasiyootoyiga uni. Ngundiro tetoni ngu, endemo oni ngu enengo muriye biyomi nguro nangge ingondudu tero oruwanggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ngundiro etoni ingoro ngu, asa, ene sayingo. Ene ende bidodomo saro, Anutro mande gome mesarango ngu wesiyoro ero etuyeroro, sayi oni oowooyingga ende bidodomo yomosiyerootoyi, metemi temukoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Yuda mera nguro oo bidodo sobowooyingo oni koreteyingo oowooyi Herod ngundo Yisasro kirikiri onindo oo tetenggoku, nguro mandeni ingoro, nguro ingonduduni buribari ingoyingo. Ndadiro nguro, gidaregado sonoyeroyingo Yondo kumoononggo, ko ootoogete, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Gidaregado eyingo. Ilayiya ko omburo tunootete, ero etoyi, gidaregado, ero eyingo. Oni gidaregado etenggo. Anutro ingondudu eyingo oni gura ko ootoogewo, eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ngundiro nguro, Herodndo eyingo. Nondo Yon bungeyi toongootoowe kumooyingo. Ngundo binengga ngundiro ko muri gura gura tetoni, nguro mandeni etoyi ingooteno, bine? Eyingo. Herod nguya Yisas kenoro ingoweroyimboro doongetero sobowooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Aposel oni ko mayero, Yisasno ko tewonggoku, nguro mandeni eyingo. Yisas enengo kirikiri oni nangge yoyoro, oni simoo bare gidarega yoyokoro enesu nangge, ende gura oowooyi Betisayida ngu tanggeyimo oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ene simoo bare ngundiro yeyoro ingoro, enebana keyeroro oorowuyingo. Ene ngu simoo bare keyeroro mayetenggoku ngu yeyoro, sureye ma kini yeyingo. Kini, ene oni oni tero, Anut Oo Bidodo Simburi Simbunani, ngundo simoo bare enengo sobowooteku muringga, nguro mande ngu wesiyoro ero etuyeroyingo. Gidarega sayidodomu yomosiyeroyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ngu sangga ngu suwootetoni, Yisas enengo kirikiri oni kande eraya kegidemboro erayaga, ngundo Yisasno omburo eyingo. Ge simoo bare nga yoyokootooga, enengo endemo songo songo saya oowari kenoya neya wereyi. Ndawugaro nguro, noore ngano kingo merako ngano oorootetoku, nga merako ngano oni kini. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ene Yisasdo mande gumi eyingo. Yendo nangge oowari yunootoyi newanggo. Ngundiro etoni, enebana eyingo. Noore oowari kini. Noorengo oomanongoyingo ngu kandegura, ko iso eraya nangge nguya ooroote. Noorendo bine saya oowari uriyoya mayeya nga simoo bare nga bidodo yunootooye, mete newanggo, bine? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Simoo nangge kandangetoyi, 5,000 teyingo. Arisa, Yisasdo kirikiri onino eyingo. Ye ooroya oni ngu kandayeroya onibi eraya kande eraya, (50), wata gura gura bibitetoyiga ngundiya tambuga tambuga bibiteyi. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Yisasro kirikiri onikundo ngu tetoyi, oni simoo bareku ngundiro bibitemukoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ngundiro tero, oo manongoyingo kandeguragaku, ko iso erayagaku yoro yowuruwooro dowooro, sambono randoro doongetero, Anutno esosootero yokoro, oo manongoyingoku iso erayagaku nguya oososowooyingo. Ngundiro tero, enengo kirikiri oniku yunootoni, ngundo oni simoo bareku bayetero yunoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ngundiro tetoyi, oni simoo bare oowari netoyi, kawuye pakini yemukoyingo. Ene oowari gugumi oodoni ngu yowuruwooro si kande eraya kegidemboro eraya (12) siriyootoyi, manggowoomo ooreyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Naru gurano, Yisas enesu nangge songo ootooro, ene yemboongero oruwo. Enengo kirikiri onindo nangge tanggeyimo oorowuyingo. Ngu naruno, Yisasdo kirikiri oniku sumoo yunoro eyingo. Oni simoo baredo noya ndadiro etenggo. No ndawu oningga, ero etenggo? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Kirikiri onindo gumi eyingo. Ene ngandiro etenggo. Ge ngu sonoyeroyingo Yon; gidaregado etenggo. Ge Ilayiya; ko gidaregado etenggo. Ge Anutro ingondudu eyingo oni kurimiku gura ko ootoogewo, ero etenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yisasdo yowoorengoro, kirikiri oniya eyingo. Ene yendo ngu noya ndawu oningga, ero etenggo? Ngundiro etoni, Pitando mandeni gumi eyingo. Ge ngu Krayis Anutdo noore yoyoweroyi nguro sunggi yeyingo oni. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yisasdo mande yanggango oorengo kirikiri onino ero eyingo. Ye komo oni gidaregano nga mandega nga ma ewero ero soreyeroyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Naru gurano, Yisasdo eyingo. Anutro Nangoni Oni Kirarongo ene ogingo urungga oorengo ingowa. Yudaro tabango oni, ko Anutno wooro yeyingo oni kundingiyi nguro sobosobo oni, ko mamana mande etuyeroyingo oni, ngundo kootu inoro, ureyi kumoowa. Ene naru kabusa yokoro ko yokutuwootoni ootoogewa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ngundiro ero, enengo kirikiri oni mande gura yunoro eyingo. Oni gura no kenerowero ngu, ene komo enengo ingonduduni murini biyomingga ngu komo yokoya meyeya oodoni, nguro simoo bare nowoondoye hamoo ma teyingo, ngundo kowuri inowanggoku, ngu koorowoowa. Ene komo ngundiro tero, ngu keneroro endeyowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Oni gura enengo ingondudunimonggo nangge enengo oo teweroyi ko keta oruweroyi ingooteku ngu, asa, kootuyisina naru wengamo, ene oonootewa. Ene oni newende ngu bidodo Anutno yeteku ngu, ngu oningga ngu enengo ingonduduni oororo omburo teteku, ngu komo yokowa. Ngundiro tero ngu, asa, ene kootuyisina suwooyi sano Anutya keta oruwa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Oni gura mera ngaro digi beye oo sitowi nguno ingonduduni bidodo yero endeyooteku ngu, kootuyisina, ene Setanro ende biyomimo oororo oruwaku, nguno ndadiro tero oo ngundo ene hooroowewa? ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Oni gura noro mandene, ngaro oyimo yowaku ngu, asa, kootuyisina, no Oni Nangoni noro duridarine ko awane nguro Engel oni kundingiyi ombutetoku naruno, no enengo oyimo yowano. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","No hamoo oorengo yeno eteno. Oni nga dikatenggoku nga ngu, gidarega ma kumooyingomo, ene oni oowooyingga oorengo Anutro nowoondoyemo hamoo teyingo murimo nguno uro kenowanggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yisasdo ngu mandega ngu ero yokoro, oode naru kandegura gidemboro kabusa yokoro, ene Pita Yon Yemus oni kabusaga ngu yoyoro, mera puri gurano awuno, Anutno yemboongewero ooreyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yisas nguno yemboongero oodoni, enengo omukumundoongo yowoorengoro guradiro oorengo tunooteyingo. Enengo towikumbani nguya sarayi oorengo soru ngundiro wadori oorengo yeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Ngu naruno, Moses Ilayiya oni erayaga, ngundo Anutro duridarinidodo tunootero Yisasya mande ero ingoyingo. Ngu oni erayaga, ngundo kootuyisina Yerusalem endemo nguno Yisas goweyimo oo tunooteweroyiku nguro mande mandeni ero ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita ko enengo dobookuriyi erayagakuya kubooyerootoni, werewero teyingo. Ene ma wereyingo, Yisasro moondeyimo oo wadori kenoro, ko oni songo erayaga nguromu nguya kenoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ngu oni erayagaku yoyokoro sawero tetori, Pitando Yisasno eyingo. Oni urungga, noore ngano oruweroyi ngu gome. Ge etoyi ngu, noorendo mete tookoododo kabusa yewato. Tookoododo gura gengo, gura Mosesro, gura Ilayiyaro yewato. Eyingo. Ene Pitando ngu ma ingoro nguro ngundiro mande eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pitando ngu mande ngu ewoodoni, sodedomangge goboore gura omburo, tabaye sanganimo ombutoni, ngundo ene bidodo doobeyerootoni nguro ene sosoreyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Goboore newendemonggo Anutdo meno ero eyingo. Nga noro nangone nga! Nondo ene rogo tewonoku ngu! Ye komo enengo manggowo ngu ingoyi! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ene mandeni ngu ingoro yokoro, ene doongetero Yisas enesu nangge kenootoyi oriyingo. Ene mande gura ma ero, ene nenetero oriyingo. Ngu naruno nguno, oo kenowonggoku ngu, oni gidaregano ma eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Yangeni ngundiro purimonggo utoyi, simoo bare oowooyingga oorengo mewoosooro omburo Yisas garo ooreko yeyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","39","Ngu oni simoo bare urungga ngu kewooroyemonggo, oni gurado ngguyinggayi tero eyingo. Oo etuyeroyingo oni, no geno kira eteno. Ge noro nangone nga keno. No komo nangone guranangge nga. Oombooro biyomi gurado ene woorogongoro ngundiro dowootoni, ene sodedomangge, kiyero biyobiyomi tero ooroote. Ngu oombooro biyomingga, ngundo yanggango oorengo merako wenggeremootoni, uro sagaga tero nosiriri udoni kumootoni manggowoomo kooto sarayimu oorero ooroote. Ngu oombooro biyomingga, ngundo ene gome gome utoro goweyi urungga yomburiyoro ene sodedo ma yokoro toongete. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","No kuri gengo kirikiri onino etoowe, ene ngu oombooroga ngu owetoyi toongeweroyi, ene ereremo kini. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ngundiro etoni, Yisasdo mandeni gumi ero eyingo. Ye simoo bare, nga naruno ngano oorootenggoku, ye nowoondoyemo hamoo teyingo ngu kini. Yengo nowoondoye ngu nenengo oorengo kini. Naru ndadiro noyeya ootooro yengo kowuriye koorowooro oruwano? Ero, ene yowoorengoro oninggaku kenoro eyingo. Ge nangongge yoya omburi. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ene nangoni yoro ombuwootori, ngu oombooro biyomingga, ngundo simooyenggaku yanggango oorengo wenggeremootoni merako wetoro sagaga tero yowooraringoro gome gome ureyingo. Yisasdo kandesisi tero ngu mboorogaku kenoro ero ene simooyenggaku yomosiyoro, yoro eweyi ko inoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","44","Ngu simoo bare, ngu bidodo Anutro yanggangoni urungga ngu kenoro, ene urungga oorengo soriyokoyingo. Ngu oo Yisasdo tewoku nguro, simoo bare ngu kenoro sosorero, nguro ingondudu urungga teyingo. Ngundiro tetoyi, ene Yisasdo enengo kirikiri onino ero eyingo. Ye mande nga gome sodeyeya, gome oorengo ingoyi! Naru bodaga nangge yokoro, Oni Nangoni ngu yoro oni songo kandeyemo yero yunowanggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ene kirikiri onindo ngu mandega ngu gome ma ingoro, yoro dowooyingo. Mande ngu muri kombiteyingo, ene nguro nowoondoyemo gome ma ingoyingo. Nguro ene Yisasro sosorero nguro ma sumoo tero ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Yisasro kirikiri oniku enengo nangge mande ero, onendo songo bidodo dagayeroro urungga oruwa? Ero mande gumi gumi ero ronggeyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","48","Yisasdo enengo kirikiri oni nowoondoyemo ngu mandega ngu oodoni kenoro ingoro, ngundiro nguro, ene simooye bodaga yoro enengo tanggeyimo yero eyingo. Oni gura ene no oowoonemboro simooye ngandiro gura yoro yomosiyoro yoonenengowaku ngu, ene no hoorooweneroro yomosinerooteku ngundiro. Oni gura no hooroowenerooteku ngu, ene oni no awane surenerootoni, ngano ombuwonomungga ngu hooroowero yomosiyoote. Oni gura ye kewooroyemo nguno enengo oowooyi bingami ero ma okooro, ene Anutro ko nenengo tewaku ngu, hamoo oorengo, ngu oningga ngu, ene oni gidarega dagayeroro urungga tewa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ngu naruno, Yondo mandeni gumi eyingo. Oni urungga, noore oni gura kenootooye, ene ge oowoonggemo oombooro biyomi oweyerootoni kenowooto. Ene ngu noore ma keyeroro endeyootenggoku, nguro noorendo ene roogo teyinowooto. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ene Yisasdo Yonya eyingo. Ye ene ma roogo teyinowero. Oni yeya mundiyi kini, ngu oningga ngu yengo dobooye. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yisas ngu sambo endemo ooreweroyi naru namoko tetoni ingoro nguro ene ingonduduni gosiyoro Yerusalem oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Yisasdo oni gidarega sureyerootoni, enengo mandeni yoro oorowuyingo. Ngu oni ngu koretero Sameriya nguro ende gurano uro nguno Yisas oruweroyimboro oo yomosiyowero. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ene ngu endemo oni, ngundo Yisas yoro, enengo yano oorowuwero yokoyingo. Ndadiro nguro, ene ingoyingo, Yisas ngu ene Yerusalem oorowute, ero ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Yisasro kirikiri oni eraya Yemus Yon eragado enengo muriye biyomi kenoro sanggiri tero eworiyo. Oo Bidodo Simburi Simbunani, ge etooga, sambononggo de ombuya nga oni nga yodemukoni. Ngundiro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","56","Ene Yisasdo yowoorengoro yeyoro mamanayeroro yokootoni, asa, ene ende gurano sayingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Yisasdo enengo kirikiri oniya yade ooreko oorowutoyi, oni gurado Yisasno omburo eyingo. Ge ende bidodomo toongeteku ngu no nguya kenggeroro no nguya toongewano. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yisasdo ngu oningga nguro mandeni gumi eyingo. Mando ngu, ene mera newendemo takiyododo, ko nu nguya de sanganimo takiyododo, ene Oniro Nangoni ngu, ene bibitero wereweroyi musiyoni nguya kini. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yisasdo oni guraya eyingo. Ge ombuya no keneroya oorowu. Eyingo. Ene ngu oningga ngundo eyingo. Oo Bidodo Simburi Simbunani, ge mete noyokootoyi no oororo awane kumootoni kenoro, merengoorogo eme ko ombuwano. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yisasdo nguro mande gumi eyingo. Nguno yoko, oni noro nowoondoyemo hamoo ma teyingo, ngundo ene sobowooya oodega kumootoningga ngu, enengo bingo merengooyi. Ene ge ngu ooroya, Anut Oo Bidodo Simburi Simbunani ngundo simoo bare enengo sobowooteku, ngu wesiyoya oni simoo bare etuyero. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Oni gurado eyingo. Oo bidodo Simburi Simbunani, no nguya ge kenggeroro endeyowano. Ene gedo mete ero etoyi ngu, asa, no oororo nenengo oni kandeye dowoorogogo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ngundiro etoni, Yisasdo oningga nguro mandeni gumi eyingo. Anutdo oni gura enengo koni rogo teweroyimboro negongootoni nguno oodoni, ene ko gura gurano endeyoro oode ngu, asa, ngu oningga ngundo Anut Oo Bidodo Simburi Simbunani, ngundo enengo endega oni simoo sobowooteku, nguno ma uwa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kootuyisina, Oo Bidodo Simburi Simbunani, ngundo oni onibi kabusa kande eraya kegidemboro eraya (72) rogoyeroro enengo ko teweroyimboro eraya eraya sureyerootoni sayingo. Ngundiro saro ngu, ene ende bobodi, ende ururu ngu bidodomo nguya koretero satoyi, asa, kootuyisina Yisas enebana keyeroro toongeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Yisasdo ngu oniku mande adingayi gura yunoro eyingo. Oowari kono gome enggemukoote. Ene ko oni oowooyingga kini. Ngundiro nguro, ye ooroya ko simburi Anutno kira etoyiga, ngundo ene mete ko oni sureyerootoni, oororo, kono oowari engge ngu yoro yowuruwoowanggo. Oowari ngu oni simoo bare ene Anutro mandeni ingowero ingootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ye oorowuyi! Ingoyi, nondo ye sureyerootoowe, satenggoku ngu, bo Sipsip nangoni imakeyingo muriningga ngundiromu ngu bo koki kewooroyemo sureyerootoowe satenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ye beye siri, kasi, ko keye goweyi nguya ma yowero. Saro ooreko oni simoo bare yeyoro nguya, mande mande ma ewero kini ye komo dagayeroya sayi. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ye saro ya gura newendemo uya ngu, ngandiya eyi. Nga ya newendemo simoo bare nga Anutnonggo sumange ayibidodo ombuteku ngu yeya oriyi. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ene ngu yano nguno oni simoo bare gura ene nowoondoye muri imakeyingo ngu oodoyi ngu, asa, yendo Anutro sumange ayibiningga yunootenggoku ngu, oororo ngu oningga nguya oruwa. Ene kinitetoni ngu, yengo sumange ayibiga ngu ko yowoorengoro yengomo ko omburo oruwa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ye komo ngu ya gurananggega nguno nangge oriyi. Ye enendo oowari sono oo yunootenggoku, ngu nero oodoyi, nguno yengo ko tetenggoku, nguro uriyi mete yowanggo. Ye komo ngu yangga nguno nangge wetoya ngunonggo saya ko teyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ene ende gurano saya utoyiga, ngu endemo oni, ngundo ye yoyoya enengo yano utoyiga nguno oowari yunootoyiga, ngu nangge neyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ye mete ngu endemo sayi oni yomosiyeroya, ye ngandiya eyi. Anut Oo Bidodo Simburi Simbunani, ngundo simoo bare soboyeroweroyi naruni, ngu kuri ye tanggeyemo ombuteku nga, eya eyi. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","11","Ye ende gurano oorowutoyiga, ngu oni, ngundo ye ma yoyoya yano uya yoyokootoyiga ngu, asa, ye ooroya, endesoono nguno dikaya ye ngandiya eyi. Yengo ende ngaro gugu nogoru noore kenanimo damoowoku ngu gasiyootooye, yengo endemo ko uteku nga, eya Anutro sumbuyi andangeya yunootoyiga orini. Ene ye gome ingondudu teyi! Ndadiro nguro, Anut Oo Bidodo Simburi Simbunani, ngundo naru enengo simoo bare sobowooteku, ngu kuri namokono omburo sobowooyerooteku nga! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","No yeno hamoo eteno. Anutdo wirikoyeroweroyi naru wenga urunggano, nguno ngu ende gurado Anutro ko oni ma yoyoro kawararayeroro ngu, asa, ene nguro ngu naruno kowuri urungga oorengo yowanggo. Ngu ogingo urungga ngu Sodom endemo oni muri biyomi teyingongga nguro ogingo yowanggoku ngu endemo oni muri biyomi tewonggoku ngu dagayeroro ogingo urungga oorengo yowanggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ye Korasin ende oni, ye Betisayida ende oni ye gowugowurongo! Tayiya Sayidon ende eraya nguno muri songo oorengo gura onindo ma teweroyimu ngu, yeno tewonoku ngundiro nguro tetoowe ngu, ene mete nowoondoye yowoorengootoyi, nguro ngguyinggayi tero, de nombo dabemimo bibitero oriyingo ngundiro. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Hamoo oorengo Anutdo wirikoyeroyingo naruno, yendo kowuringga yoweroyiga ngu, ngu Sayidon Tayiya ende erayaga ngundo kowuri yoweroyi ngu dagayeroro urungga oorengo yowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ye Kapeniyam endemo oni ngundo yengo oowooye bingamiye okootoyi sambono oorero oorootenggo, bine? Hamoo oorengo kini. Ye Anutro nowoondoyemo hamoo ma teyingo nguro Anutdo yoyoro de nombono nguno oorongooyerootoni uwanggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yisasdo enengo kirikiri onino eyingo. Oni ene ye manggoye ingootenggoku, ngu ene no manggone nguya ingoowe. Oni ene kootuyunootenggoku ngu, asa, ene no nguya kootu nunoote. Ene no kootu nunooteku ngu, ene Anutdo sowenerootoni ombuwonomu nguya kootu inoote. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Enengo ko oni onibi kabusa kande eraya kegidemboro eraya ngundo kono sayingoku ko mayero oni oni urungga tero Oo Bidodo Simburi Simbunani nguno eyingo. Urungga Oo Bidodo Simburi, noore saro ko tero nguno, gengo oowoongge etooye oombooro biyomi ngu noorengo manggonani nguya, gome keyoro sawonggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yisasdo gumi eyingo. Kurimi, no Setan kenootoowe, sambononggo himi, yowari ngundiro sorewo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ye ingoyi! Ngu hamoo oorengo. Nondo yanggango ye kuri yunowono. Nguro ngu, ye sire biyomi, putegooro dogingo ko oo biyomi gura wongoowanggoku nguno, ko ye mundi oni oo biyomi nguro yanggangoye ngu, ko oo biyomi gurado ye ma yomburiyerowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Oombooro biyomimbo yengo manggoye ingoro keyowonggoku nguro, ye ma oni oni tewero. Kini, Anutdo yengo weti biyomi ngu andangeyunowokuro nguro yengo oowooye ngu sambo endemo kuri nakangoyunowoku, nguro ye Anutro oni oni teyi. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ngu naruno nguno, Yuka Kundingiyi, ngundo Yisas yeni oni oni tero, ero eyingo. Awa, ge sambo ende nguro, ko mera ngaro nguya oo ngu bidodoboro simburi urungga oorengo ooroote. Nguro no geno esosootero yemboongeteno. Gedo kuri oo ngu oni ingonduduye mande mandeyedodo onino ngu oongooyingo. Ene ge simooye bobodi nangge tunoo etuyeroote. Yo, Awa gengo ingonduduge ngundiro. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Nenengo Awanembo oo bidodo no kandenemo yemukowo. Oni gurado enengo Nangoni nguro ma ingootoni ngu, Awa enengombo nangge Nangonimboro ingoote. Oni gurado Awa ma ingooteku, enengo Nangonimbo nangge Eweyi ingoote. Ene oni ngu Nangonimbo Eweyi etuyerootoni ngu, ene nguya Eweyimboro muri ingowanggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Yisas enengo kirikiri oni nangge oodoyi ngusina yowoorengoro eyingo. Oni ene oo yendo kenootenggoku nga, ene nguya ngu kenoro ngu, ene oni oni tero oruwanggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","No yeno hamoo eteno. Kurimi, Anutro ingondudu eyingo oni, ko mera ngaro oo sobosobo oni Koreteyingo nguya ene oo nga kenowero ero ene ma kenoyingo. Yendo ataga oo kenootenggoku, ngandiro ene ma kenoyingo. Ene nga mandega yendo ingootenggoku nga ingowero eyingo. Ene ma ingoyingo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Naru gurano, mamana mande etuyeroyingo oninggado Yisas towoongowero eyingo. Oo etuyeroyingo oni, no ndadiro terogogo, no suwooyi sano keta gome oruwano? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ngundiro etoni, Yisasdo mande gumi eyingo. Mamana mandeno ngu ndadiro nakangoyingo? Ge ndadiro kandangero ingoote? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ngu oningga ngundo gumi eyingo. Anut ngu gengo Urungga Oo Bidodo Simburi Simbuge. Gengo nowoondoge bidodo, gaboge bidodo, ingonduduge bidodo yanggangongge ngu bidodo ene ino. Gengomboro ingooteku ngundiya nangge oni dobooge tanggegemo oorootenggoku nguro nguya gome ingo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yisasdo ngu oningga nguya eyingo. Ge hamoo nenengo ete. Ge ngundiro nangge tero endeyoro oruwaku ngu, ge keta suwooyi sano oruwa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ngu mamana mandero oningga ngu newendemonggo Yisasdo mandega ewoku ngu ingowero yokoro, enengo ingonduduningga wesiyoro ewero no oni nenengo ero, ene nguro sumoo gura eyingo. Oni no tanggenemo oorooteku ngu, oone ngu noro doboone? ");
INSERT INTO rwo_rawa_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Etoni, arisa, Yisasdo mande adingayi gura ngandiro eyingo. Oni gura Yerusalemnonggo Yeriko uwero uyingo. Ngundiro uwootoni, yakaka oni biyomi, ngundo ooreko kenoro, dowooro ureyi kumoowero tetoni yokoro, enengo sitowini sobibiyoro yomukoro satoyi, oninggaku kumoowero namoko teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ngu naruno, Anutno wooro yeyingo oni gura, oore ngu keyoro uro, ngu oningga ngu kenoro, ene oore dabemisinanggo torige torige uro dagaro toongeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ngu naruno nangge, yambo yaro kirikiri oni ngu oorega ngu keyoro uyingo. Ngu oningga ngu kenoro yokoro, ene oore dabemisinanggo dagaro uro toongeyingo. Liwayi ngu Yekob nangoni gura, nguro soweni. Anutdo ene wooro yeweroyi nguro oo kirikiri teweroyi ko yunoyingo) ");
INSERT INTO rwo_rawa_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Kootu oorengo Sameriya oni gura, ngu oorega ngu nangge keyoro ombuyingo. Yuda oni ngu Sameriya oni ngu ko gobooro ma tetenggo. Ngundiromu ene Sameriya oningga ngu omburo, ngu oningga ngu kenoro, nowoondoyi urungga teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Tanggeyimo omburo kenoro, Wayin sonoyi ko bo urumimbo nguya mambuni sonowooro yomosiyoro Marasinmbo mambuniku gosiyoro yokoro, okooro, enengo Hos bodaga oowooyi Donggi ngu sanganimo yero endemo toongero, nguno ooreko oni mayero wereweroyi yano uro, nguno yomosiyoro gome sobowooro oruwo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Sengetoni, ene toongewero ootoogero, sa guranangge nguro ko uri beye ngu ya simburigaku inoro eyingo. Ge nga oningga nga gome sobowooya ootoo. Gengo beye gura nga oningga ngaro yokowaku ngu, nobana ko omburo, wendangero gumi gunowano. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ge ndadiro ingoote? Oni kabusa ngu oorega ngu keyoro ombuyingo. Onendo ngu oningga ogingo biyomi yoro oruwoku, nguro dobooyi oorengo? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ngundiro ero yokootoni, mamana mande etuyeroyingo oningga ngundo mande gumi eyingo. Ngu oningga nguro nowoondoyi tero hoorooweyingongga nguro dobooyi. Etoni, Yisasdo gumi eyingo. Ge ooroya, ngundiya, nangge te. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Naru gura, Yisasdo enengo kirikiri onidodo, yade yade oororo, ende bodagano tunooteyingo. Nguno bare gura oowooyi Mata ngundo Yisas garo yoyowero enengo yano oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mata nguro koneyo oowooyi Mariya. Mariya ngu omburo Yisas tanggeyimo bibitero, mande etoni ngu ingoro oruwo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ene Matando ngu oowari, ko oo urungga tero, yomosiyoweroyi nguro oororo omburo teyingo. Ngundiro tero, nguno Mataro ingonduduni ngu oowari oo ngu yomosiyoro, nguro ingondudu urungga teyingo. Ngundiro tero, Matando Yisasno oororo eyingo. Oo Bidodo Simburi, konegene Mariya ngu ene no noyokootoni, noso nangge oo yomosiyootoowe, ene ngu kingo bibitero ooroote. Gedo ene sureyootooga, no hoorooweneroni. Ge nguro ma ingondudu tete, eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","42","Yisasdo manggowo gumi eyingo. Mata Mata gengo ingonduduge ngu ge oo oowooyinggaro ingondudu buribari tero, ge nguro gome ingoote. Ene ge oo guranangge nguro ge ma ingoote. Mariyando ngu ene oo gomengga nguro ingoote. Noore ngu oo gomengga Mariyando ingoro yootekungga, ngu ma sobiyoro yoyinowato. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Naru gurano, Yisas enesu nangge songo oriroko oororo, nguno yemboongero oode, yokootoni, kootuyisina enengo kirikiri oni gurado omburo eyingo. Urungga Oo Bidodo Simburi Simbunani, ge noore nguya yemboongeweroyi muri ngu etuyero, Yondo enengo kirikiri oni etuyeroyingo ngundiro. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","4","Ngundiro etoyi, Yisasdo gumi eyingo. Ye yemboongewero naruno ngu, ye mete ngandiya eyi. Awa, noorendo gengo oowoongge ngu komo kundingiyi orini, nguro ewero eteto. Noorendo gengombo naru oni simoo bare enengo soboyerooteku ngu komo ombuyarini, noore ewero eteto. Noorengo oowari engge nga narungga ngaromu, ko naru bidodoboromu nguya yunororuwa. Oni gidaregado nooreno weti mbumbuwa teyunootenggoku nguro noore kowuriye andangero kabeteyunowato. Ngundiro nangge, mete ye nguya noorengo kowurinani andangeyunoya kabete. Gedo oo biyomi noore towooyeroweroyimo, nguno ma yowoosooro oorowuwero. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Yisasdo ko eyingo. Ye kewooroyemo nguno oni gura enengo dobooyibo, suwoo kewoorokono oororo ewa. Doboone, ge oomanongoyingo kabusa nuno, ero ewa. Noro doboone gura orirokononggo mayetoni, nguro no oowari gura ene inoweroyi nguya kini. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ya newendemo oningga, ngundo mande gumi ewa. Ge ndatero nguro suwoo kewooroko omburo no yokutuneroote? Yamuko kuri goodoowono. No nenengo simoonedodo yabano kuri werewooto. No ootoogero oo ge gunoweroyi, ereremo kini. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","No yeya eteno. Ene ngu oningga ngu enengo dobooyi oorengo nguro ma ingoro, nguro ene ootoogero oo ma inowa. Ene ngu oningga kira ero eriritero oorooteku nguro ingoro, ene ootoogero, oo bidodo eneno kinimu nguro ewoku, ngu bidodo yoro inowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ngu no yeno eteno. Ye Anutro nowoondoye hamoomonggo ooro wenonoro, nguro Anutno kira etoyigogo, enendo oo ye yunowa. Ye oo erewero ngu, ye oo kenowanggo. Ye oo ereweya ngu Anutno yemboongetoyi, enendo etuyeroro goosooyunowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Oni bidodo Anutno kira erogogo oo yootenggo. Oni ene oo erewero ngu, ene oo kenootenggo. Oni yamuko udoni ngu, Anutdo yamuko goosooyunoote. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ye kewooroyemo nguno oni gura nangonimbo isoro etoni, ngu eweyimbo yowoorengoro, sire biyomingga yoro, nangoni inowa, binengga? Kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ene nangonimbo nu mindiyoboro etoni, eweyimbo yowoorengoro, oo biyomi putegooroga inowa, bine? Kini, ngundiro nguya ma tewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Arisa, ye oni biyomi merako oorootenggoku, ngundo yengo simooye ngu oo gomemu yunootoyi ngu, asa, yengo Awaye sambono oorooteku nguno kira etoyi, enendo enengo Yuka Kundingiyi ngundo oo urungga oorengo yengo merako oniro muriye, ngu bidodo dagaro yunowa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yisasdo oombooro biyomi gura manggowo kininggado oni gura woorogongoyingomu owetoni toongetoni, oninggaku manggowo tango yetoni, mande eyingo. Ngundiro tetoni, simoo baredo ngu kenoro, ene soriyokoro ingondudu urungga teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ene oni gidaregado eyingo. Ene oombooro biyomi oweteku, ngu oombooro tabango urungga oowooyi Beyelesebab (Setan) nguro yanggangoni, ngunonggo ko tete ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Oni gidaregado Yisas towoongowero, ero ewonggo. Samboro onindo ma teweroyi gura teya etuyerootooga kenowato. Ngundiro kenoro ingowato, ge Anutdo rogogerowo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ene Yisasdo enengo ingonduduye ngu ingoro, nguro ero eyingo. Ene mera oo sobosobo oni guranangge nguro oni simoo bare wesoowootoni, wata eraya tetoni ngu, ngundo enengo nangge ebe utoro, ngu oningga nguro koni ngu biyomi yewa. Ya gurananggemo oni simoonggoro gura nowoondoye guranangge kini wesoowootoyi eraya tetoni ngu, ko gura gobooro teweroyi, ene ereremo kini. Asa, nondo Setan yanggangonimbo oombooro biyomi owewonoku, ngu ngandiro nondo nenengo kone yomburiyowano. Ngu hamoo oorengo ngundiro kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ngundiro nguro, Setando enengo keyimo oni wesoowooyerootoni eraya tetoni, ngundo enengo nangge ebe utoro ngu, enengo koni mandeni ngu ndadiro terogogo, yanggango oruwa? Ene ereremo kini. Yendo noya etenggo. Nondo Beyelesebab (oowooyi Setan) oowooyimonggo oombooro gidarega owete, ero etenggo. Kini, no Setan yanggangonimonggo oombooro biyomi ngu ma oweteno. Kini, no Anutro yanggangonimbo oweteno. No nguro eteno. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ene nondo Beyelesebab oowooyimo ko ngundo no hooroowenerootoni, oombooro biyomi gidarega owewanoku ngu, onendo yengo ko gobooro ngu hoorooweyerootoni, ene oombooro biyomi ngu owetenggo? Ye ngundiro ingootenggoku ngu, asa yengo ko gobooro oombooro biyomi owetenggoku ngu Setanro yanggangonimbo nguya tetenggo? Hamoo oorengo kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ene Anutro yanggangoni, ngundo no hooroowenerootoni, ngunonggo no oombooro biyomi ngu owetoowe ngu, ye ingowanggoku ngu, Anutdo narungga enengombo sobowooteku, ngu yeno omburo tunooteteku nga! ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ene oni yanggango gurado (Setan) enengo yani gome sobowooro, sangga dowooro oodoni ngu, enengo yanimo oo ngu bidodo gome oorengo oruwa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ene oni gura yanggango oorengo, ngundo mayero ngu oni yanggangongga nguya ebe utoro, duge, sangga ooni ngu sobiyoro yoro ngu, asa, ene mete ureni kumootoni, yanimo uro, oo sitowini nguro musiyo, ene watayi ingooteku nguro wiyakoro, bayetero dobookuriyi yunowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Oni no doboone kini ngu, ene noya mundi tete. Oni ene noro kone nguro newende guranangge kini ngu, asa, ene kingo buribari tero endeyooteku ngu, ene noro doboone kini. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yisasdo mande gura eyingo. Oombooro biyomi, ngundo oni gura yokoro toongewa. Toongero mera ariwoore endeyoro yade nguno musiyo ene kengero oruweroyi musiyo gura ma kenoro ngu, ene ewa. No ko oororo nenengo yangga kuri oruwonoku, nguno uro oruwano, ero ewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ene ngundiro ero, oororo yanggaku kenootoni, ngu yangga ngu onindo kitikata gasiyoro yomosiyootoyi, kingo oodoni, gome teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ngundiro tero, ene oororo oombooro kandegura gidemboro eraya nguya yoyoro, ngu yanggano nguno ombuyingo. Enengo yanggangoye ngu koreteroga ngu dagaro biyomi oorengo. Ene ngu oningga ngu koretero bodaga biyomiyi oruwo. Ene ataga ngu, ene biyomi oorengo tero ooroote. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yisasdo ngu mandega ngu etoni, simoo bare oowooyingga oorengo oriyingo. Nguno bare gura ngu oni ngu kewooroyemo oruwoku, ngundo meno ero eyingo. Ngu barega ge bisigeroro nono gunoyingongga, ngundo enesu nangge kumana urungga tewa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ene Yisasdo mande gumi eyingo. Yo, ngundiro oni ngu, ene mande ingoro, nowoondoyemo hamoo tero, Anutro mande ngu gome yoro dowooro, keyootenggoku nguro ene oni oni urungga tewanggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Oni simoo bare urungga mayero yowuruwootoyi, Yisasdo mande yunoro eyingo. Nga naruno oni simoo bare nga biyobiyomi. Ene muri songo oorengo onindo ma teweroyimu kenowero etenggo. Ene nondo ngu ooga ngu gura tero ma etuyerowano. Yonando mande oo teyingo ngu nangge etuyerowano. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kurimi, Yona ngu Anutro sunggi ngundiro tero, Niniwa oni simoo bare etuyeroyingo. Ngundiro nangge, Anutro Nangoni Oni Kirarongo nguya Anutro sunggi ngundiro, ataga nga oni simoo bare nga etuyeroote. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Kootuyisina, Anutdo simoo bare wirikoyeroweroyi naruno nguno, mera ngaro oo sobosobo bare koreteyingo gura oriroko oorengomonggo, nga naruno simoo bare nga kondibo ootoogero; enengo muriye biyomi ngu yootunoyerowa. Ndadiro nguro, ngu barega mera wengamo oo bidodo sobosoboga, ngundo omburo, Solomonro ingonduduni gome ngu etoni ingoyingo. Ene ataga nga oningga nga oorooteku, ngando Solomonro ingoyingoni ngu dagaro oorooteku nga! Bare sobosobo koreteyingongga, ngundo Solomonro mandeni gome ingootoni, ene ye simoo bare ngano oorootenggoku, ngu noro mandene ingowero yokootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Anutdo simoo bare wirikoweroyi naruno nguno, Niniwa oni nguya nga naruno oni simoo bare ngaya ootoogero, enengo muriye biyomi ngu ewanggo. Ndadiro nguro, Niniwa oni ngu Yonaro mandeni ingoro, ene nowoondoye yowoorengootoni, ene hamoo Anutro ingoyingo. Ene ataga nga oningga oorooteku, ngando ngu Yona dagate. (Yisas enengomboro eyingo). Ene ye oni simoo bare ataga oorootenggoku ngu noro mande ma ingoro nowoondoye ngu ma yowoorengoote. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Oni gurado soru (Lam) karo yoro ya gosingomo ngundi kumbe oo gura newendemo ma oongoowa. Kini, oni soru karo ngu, ene tunoo oorengo mindingootoyi, oni ya newendemo utenggoku, ngu nguya soru ngu gome kenowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Doongengge ngu gowegeboro soru ngundiro. Gengo doongengge ngu gome metemi, ngundo gengo gowege moondege ngu bidodo yeni sorudodo tete. Ene gengo doongengge ngu biyomi yetoni ngu, ngu gowege moondege ngu ooreridodo tero oruwa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Nguro ngu, ge ingonda te! Gengo sorungga nowoondogemo oorooteku ngu gome sobowo. Kinitetoni ngu, gengo sorungga ngu ooreri tewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Asa, gengo gowege ngu bidodo himi oodoni ngu, asa, gumisina ooreri kini. Gengo gowege moondege ngu bidodo himi, ngu soru (Lam) himi ngundiro oruwa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yisasdo mande ngu ero yokootoni, Parisi oni gurado Yisas eneya oowari neweroyimboro negongoyingo. Ngundiro tetoni, Yisas ene ngu Parisi oningga, ngundo yano uro oo neweroyi yabano bibiteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Bibitero oo netoni, Parisi oningga ngundo Yisas kenootoni ngu, ene kandeyi ma sonowooro ngundo oo dowooro netoni, nguro ene ingondudu urungga teyingo. (Mosesro mamana mandeno eteku ngu ma keyootoni nguro gome gome kenoyingo.) ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Yisas Oo Bidodo Simburi, ngundo ngu Parisi oningga nguro ingonduduni ingoro eyingo. Ye Parisi oni ngu koondo toba ngu goweyi nangge sonowooro yomosiyootenggo. Ene yengo nowoondoye ngu yakaka, ko muri biyomi, ngundo nangge angero ooroote. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ye wenonoyingo oni! Anutdo ene oo goweyi sangani nangge bine yero, ene newendedodo nguya ma yeyingo, bine? ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ene Anutdo nowoondoye yomosiyooteku ngu, nguro ye nguya oni gura nowoondoye teyunoya hooroowe. Onindo ngundiro kenoro ngu, ene ingowanggo. Gengo nowoondoge ngu gome sarayi. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ene ye Parisi oni, ye ingonda teyi! Ye ngu oo soodida, suwe oo bidodo kono oorooteku, ngu kewooro wesoowooro kande eraya nguromu gura Anut inootenggo. Ene ye mande muri gome nenengo ngu dagaro yokoro, nowoondoye Anut inoweroyi muri ngu yokootenggo. Ye oo ngu yunoweroyi muringga ngu mete tetenggo. Ene ye nowoondoye bidodo oorengo Anut inoweroyi muringga ngu ma yokowero. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ye Parisi oni, ye gowugowurongo ye ingonda teyi! Yengo yambo yano ye koretero oni doongeyemo bibitewero gome ingootenggo. Ye oowari uriyoweroyi musiyomo, simoo baredo yeyoya bingaminani eya okooyi ero gome ingootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ye ingonda teyi! Yengo nowoondoye ngu oni mereyi garongooro uteku musiyo ngundiro. Mere sanganimo ngu so irosara oo gomemu ooroote. Ene mere newendemo ngu buwoo biyomi tero, ndindingo biyomi ooroote. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ngundiro etoni, mamana mande etuyeroyingo oni gurado Yisasro mande gumi, ero eyingo. Oo etuyeroyingo oni, ge ngu mandega ngu nooreya mande kootunanisina ero yimitooro eteku ngu! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yisasdo mande gumi eyingo. Ye mamana mande etuyeroyingo oni, ye ingonda teyi! Yendo mamana mande urungga oorengo oni simoo bare yunootenggoku, nguro ene oo kowuri urungga oorengo ene koorowooweroyi ereremo kini. Ene yendo kandedibiye bodaga nguno yero boda ma hoorooweyeroro kowuri ngu ma koorowootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ye ingonda teyi! Yengo osi sambayebo Anutro ingondudu eyingo oni, gidarega kingo yureyi kumooyingo. Ene yengo muriye ngu osisambayeboro muriye ngundiro. Nguro ngu, ye mereye ngu irosarayi teyunootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nguro ngu, ye nguya enedodo muriye guranangge. Nguro ye osisambayeboro mande muriye biyomi ngu, ero etenggo. Yengo nowoondoye ngu muringga teyingongga nguro gome ingootenggo. Ene Anutro ingondudu eyingo oni yureyi kumooyingo. Ye nguro mereye komoongoro irosara teyunootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Nguro ngu, Anutro ingonduduni gomemo ene kuri ero ewo. Nondo noro ingondudu eyingo oni, ko nenengo kirikiri kirarongo oni sureyerootoowe, eneno oorowuwanggo. Enendo ngu yutoro, mandeye biyomi ero yomooyunoro, gidarega yureyi kumoomukowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Nguro ngu naruno, oni simoo bare nga osisambayebo kowuriye yowanggo. Ene kuri Anutro ingondudu eyingo oni yurewonggoku omburo, nga naruno ngano nguya yurootenggo. Kurimi, Ebel ureyi kumooyingo, ngunonggo yade yade omburo Sekarayiya nguya ureyingo. Sekarayiya ngu Tembel yambo ya newendemo Anutno wooro yeyingo musiyomo ureyi kumooyingo. Nguro kowuri ngu, ataga nga oni simoo bare oorootenggoku ngano, nguro kowurini weti gumi ngu bidodo ataga yowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ye mamana mande etuyeroyingo oni, ye ingonda teyi! Yendo Anutro hamoo mande ngu oni bidodo ingoweroyingga ngu oongootenggo. Yengombo ngu ma keyoro nguro ye oni gidaregado ingoro keyoweroyinggaku nguya oore goodooyunootenggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ngundiro ero yokoro, Yisas ngu yangga ngu yokoro, ene endesina ooretoni, mamana mande etuyeroyingo oniya, Parisi onidodo ngu mandega nguro nowoondoye biyomi oorengo ingoro oruwonggo. Ngu naruno, ene damoni yero Yisas ureyi kumooweroyi nguro suwooyi sano oore erewero oo bidodoboro Yisas sumoo sumoo inoro oruwonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ene ngundiro tero, Yisas kenondadangero sobowooro endeyoro oruwonggo. Yisasdo mande biyomi guradiro gura manggowoomonggo etoni ngu, ingoro, ene ngunonggo dowooro mande ero ureyi kumooweroyimboro. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Naru gurano, oni simoo bare urungga oorengo, endeni endeni bidodo mayero yowuruwooro, ebe wongoowoonggo tero tero ombuyingo. Yisasdo ootoogero enengo kirikiri oni mande yunoro eyingo. Ye Parisi oniro ebe ganagana mande nguro ingonda teyi! Ene oni doongeyemo ngu oni muri nenengo keyootenggoku ngundiro tewanggoku, nguno ngu godange tetenggo. Kootuyisina, ngu muri erayaga tetenggoku, ngu endesina tunootewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Oo bidodo oongooro wiriyootoni oorooteku ngu, kootuyisina, ngu tunoo temukowa. Oo doobengootoni oorooteku ngu, kootuyisina, dobe wesiyootoni tunootetoni, oni nguya kenoro ingowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ngundiro nguro, mande bidodo suwoo oorerikono ewonggoku ngu, oni simoo baredo sano tunoo ero ingowanggo. Mande bidodo yendo ya newendemo torige gisigosononggo ero ingowonggoku ngu, onindo ende kewoorokono dikaro, ngunonggo wesiyoro meno manggaru tero ewanggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Yisas mande gura eyingo. Ye noro dobookurine, nondo yeno ngandiro eteno. Ye onindo goweyega nga ureyi kumootekungga nguro ma sosorewero. Ndadiro nguro, ene kootuyisina, oo gura yeno teweroyi, ereremo kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Oni ye nguro sosoreweroyi ngu etuyerowano. Ye komo Anutro sosoreyi, ngundo oni ureyi kumoowa. Kootuyisina, ene yanggangonidodo, ngundo oni yoro, de nombo ma kumooteku nguno oorongooni uwa. Yo, no yeno eteno. Ye komo Anutro nangge sosoreyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ye ingoyi! Nu sibe bobodi kandegura ngu uriyi bodaga nangge (2 Toya 2 Toya). Ene Anutdo nu bobodi ngundiro ngu ma kabetete. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Anutdo ye tabaye uye ngu bidodo kandangemukoote. Ye nguro ma sosorewero. Anutdo nu bobodi nguro ingoro sobowooro oo yunooteku ngu, asa, ye ingootenggoku, ene ye nguya gome soboyerowa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Yisasdo eyingo. No mande gura nguya yeno eteno. Oni gurado simoo bare doongeyemo no oowoone yootunoro ewaku ngu, no Oniro Nangoni nguya ngu oningga nguro oowooyi Anutro Engel onino yootunoro ewano. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ene oni gura simoo bare doongeyemo, noya mande biyomi ero, no kootu nunowaku ngu, no nguya Anutro oni Engel doongeyemo eneya mandeni biyomi ero kootu inowano. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Oni gurado no Oniro Nangoni yomooyinoro mandega ewoku, ngu andangeweroyimboro yemboongewaku ngu, asa, Anutdo ngu oningga nguro weti mbumbuwani andangeyinowa. Ene oni gura Yuka Kundingiyi yomooyinoro mandega ewaku ngu, Anutdo ngu oningga nguro weti mbumbuwani hamoo oorengo ngu ma andangeyinowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","12","Ene oni gidarega ye yoyoro yambo ya newendemo yoyero, ngundi, Gabuman oni doongeyemo yoyero, ngunonggo yoyoro oni oowooyedodomu nguno nguya yoyewanggoku ngu, asa, ye ma sosorero ngandiro ma ingowero. Noore ndadiro mandega ero nguno enengo mande ngu wongoowe utoni sawato? Noore mande ndadiro ewato? Ero ma ingowero eyingo. Yuka Kundingiyimbo ngu naruno nguno nangge, ye mande eweroyi ngu ingonduduyemo tunootetoni, ye ngu yoro eneno ewanggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Naru gurano, ngu oni simoo bare urungga kewooroyemonggo oni gurado Yisasno ero eyingo. Oo etuyeroyingo oni, no ngandiro ingooteno. Gedo banemo etooga noorengo awanarimboro oo sitowiku wesoowooya gumi gidare no nunoni. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ngundiro etoni, Yisasdo ngu oningga nguya eyingo. Onendo no roogonerootoni, no yengo oo wirikoro ngu wesoowooro bayetero, ye yunoweroyi tabango noyewo? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ngundiro tero, Yisasdo simoo bare bidodomo eyingo. Ye ingonda teyi! Ye oo sitowi urungga yowero ko oo gidaregaro nguya doongeye ma urutewero. Anutdo keta oruweroyiga ngu yunoote. Oo sitowi ngundo keta oruweroyi ngu uriyoweroyi, ereremo kini. Kini, oo sitowi ngu gowenani nga hoorooweyeroyimboro nangge yunoote. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Yisasdo mande adingayi gura ero eyingo. Sitowidodo oni guraro konimo oo urungga enggemukowo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ngu sitowidodo oningga ngundo newendemonggo ingondudu tero ewa. No ndadiro tewano? Oowarine nga yeweroyi yane nguya kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ngu oningga ngundo enengo ingonduduno ingoro eyingo. Yo, no nenengo oowariro ya nga toongooro ya ururumu nangge yero, nguno oowari bidodo yoro, nguno wata yewano. Nggire ko nenengo oo gome gomemu ngu yano nguno yetoowe oruwa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","No ataga mete ero ingondudunemo ingowano. Nenengo oo gome gome urungga oorooteku, ngaro ngu dagoma oowooyingga oorengo yoro netoowe, ma kini tewa. No yoro nero, sonoyi nguya yoro nero, kengero, oni oni tero, oruwano. Ero ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ene Anutdo kenoro eneya eyingo. Ge wenonoyingo oni! Ataga suwoono ge kumoowa. Ngundiro tetoyi, gengo oo yomosiyoro yewoku ngu onendo yowa? Anutdo eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Oo ngundiro yeno nguya tunootewa. Oni ene oo sitowi urungga yoro enengo wata yetenggoku ngu, ene Anut nowoondoyemo hamoo teyingongga ngu kini. Anut doongeyimo ngu, ene angoyi oorengo yetenggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yisasdo ngundiro ero, enengo kirikiri onikuno, ero eyingo. Ngundiro nguro, no yeno eteno. Ye goweyeboro oo nguro ye ma ingondudu urungga tewero. Noore ndawu ooga newato? Ngundi noore ndawu ooga kutuwoowato? Ngundiro ero, ye goweyega ngaro ma ingondudu urungga tewero. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ketangga Anutdo yunoyingo ngu urungga oorengo. Ngu oowari ngundi towikumba oo nguro ingootenggoku ngu oo bobodimu nangge. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ye nu yeyoya ingoyi. Ene ko tero oowari ma mitenggo. Ene oowari engge ma yoro yowuruwooro wata yetenggo. Ene Anutdo suwooyi sano oowari oo yunoro muwooyeroote. Ye oni simoo bare ngando Anut doongeyimo ngu, nu oo ngu dagayerootenggo! Anutdo kuri watayi, ye towikumba, oo neweroyi, ya wereweroyi oo ngu yunowero ingoote. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ye kewooroyemo nguno oni gurado enengo ingondudu tero, enengo keta oruweroyi nguro naruni, ene mete soweyowa, bine? Kini, ye ereremo kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Nguro ngu, yendo oo bobodi ngundiromu ngu ma tetenggoku, ndawugaro ye gidaregado ngundiro ingondudu urungga tetenggo? ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ye so irosara nga yeyoya ingoyi. Ene bungge koyi tero towikumba ma tetenggo. Nguro, no yeno eteno. Ye ooro ma ingondudu tero, ma hahangewero. Kurimi Solomon ngu, ene towikumbani gome mesarangomu ngu bidodo teyingo. Ene ataga nga irosarangga kenootenggoku, enengo irosarani ngu Solomonro ngu dagate. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Yo, uru so oo kono ooretenggoku ngu, ataga nangge oorero dikatenggo. Yangeni ngu gumooro de nombono oorongootoyi dewa. Kingo so uru ngundiromu ngu, Anutdo ngu gome nakangoyeroote. Ngundiro nguro, ye komo gome ingoyi! Ye simoo bare yengo nowoondoyemo hamoo teyingo ngu bodaga nangge. Anutdo yengo nowoondoyi urungga oorengo tero gome soboyeroote. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ngundiro nguro, ye ndawu ooga ko sonongga neweroyi ngundiro ingondudu urungga ma tewero. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Oni endeni endeni ngu, ene oo ngaro erewetenggo. Ene yengo Awaye sambono oorootekungga, ngundo ngu yengo oo nguro ingootenggoku ngu, oo ngu enendo hoorooweyerootoni yowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ene ye Anutro nowoondoyemo hamoo teyingo nguno nowoondoye yero, ngunonggo dobookuriye nguya mande nguno hoorooweyeroro ero yunoro ngu, asa, Anutdo oo songo nguno hoorooweyerowa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ye noro nowoondoye hamoo teyingo oni wata bodaga nangge, ye ma sosorewero. Yengo awayembo ene kuri enengo endega enengo simoo bare sobowooteku, ngu yunowero yomosiyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Yengo oo bidodo oni yunootoyiga uriyoyi, nguro beyeni ngu yoya, angoyi oni ooro wenonootenggoku, ngu hoorooweyeroya yunoyi. Ngu muri gomengga merako ngano tetenggoku ngu, sambo endemo ngu duwoo ma yokowa. Sambo endemo yakaka onindo oo gomemu ma yowanggo. Nguno googoose ma tetoni, toowumbo nguya ngu ma netoni biyomi yewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Yengo oo gome oorooteku musiyongga nguno, yengo nowoondoye nguya nguno yetoyi oruwa. Ye oo gome gome ngano oorooteku, nguro hahangero ingoro ngu, asa, nowoondoye ngu bidodo nguno damooro oruwa. Ngundiro nguya ye Anutro ko tewero nguro hahangero ingootenggoku ngu, asa, yengo nowoondoyemo ngu bidodo sambono oruwanggo. Yo, hamoo, Anutdo sambo endemo musiyo metemimu nguno noorengo oo gome yoonenengootoni ooroote. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Ye oo yomosiyoya doongedoongoodoongo teya noorengo Simbunani urungga ngu sobowooya oodoyi, ene omburo ko yoyoweroyi, ngu ko onindo enengo sobosobo oni urungga sobowootenggoku ngundiro. Ene towikumba ingonda tero, yemuro, wanggayemo utombo gome gosiyoro, enengo soruye karo dowooro oorootenggo. Ngundiro tero, oodoyi, enengo oni urunggaku bare kameyoweroyi oo simbo ngu kinitetoni suwoo kewooroko omburo, enengo ko onikuno yamuko udoni, ya goosootoyi, nguno yeyootoni, doongedoongoodoongo tero ootooro, nguro ene sodedomangge yamuko goosooyinootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Oni urungga ngu omburo, enengo kirikiri oniku yeyootoni, ma wereyingo doongetero oodoyi yeyoro ngu, kirikiri oni ngu, ene oni oni tewanggo. No hamoo oorengo yeno eteno. Kirikiri oni enengombo kumba yemuro kimbonambo wanggaye gosiyoro, ya simburibo sobowooro oodoni, omburo oo neweroyi yabano bibitetoyi, enengombo oowari yunowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ngu oni urunggaku suwoo kewooro oorengomo ombuwa, bine, ngundi, sengeweroyi tero, nu kootoori koretero etoni nguno, bine, omburo, enengo kirikiri oni yeyootoni, ma wereyingo. Nguro ngu, kirikiri oni ngu, ene mete oni oni tewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ye nga mande oo nga gome ingoyi! Ya simburi ngu, ene yakaka oni ombuweroyi naruwo ingoro, ene nguro doongedoongoodoongo tero oruwa. Ndadiro nguro, yakaka oni enengo yano ma ombuwero ero nguro. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ye komo nguro suwooyi sano doongeteya, doongedoongoodoongo teya oriyi! Oniro Nangoni ngu naru gurano ombuweroyi ngu, ye ma ingootoyi nguno ene ko ombuwa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pitando eyingo. Urungga oo bidodo Simburi Simbunani, ge ngu mande adingayingga ngu nooreya nangge ete, bine; ngundi simoo bare bidodoboro ete? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Etoni, Urungga oo bidodo Simburi Yisas ngundo mande gumi eyingo. Oone ngu newende gomemo sobosobo ootooro enengo ko gome tete? Enengo oni urungga, ngundo ngu oningga ngu yetoni, ngundo enengo ko oni ngu soboyeroro, naru nenengo oorengo roogoyimo ingoro oowari yunowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kootuyisina, oni urunggaku ko yowoorengoro omburo, ngu ko sobosobogaku kenootoni, ko kuri teroruwoku ngundiro tero oodoni kenoro ngu, asa, ngu sobosobo oninggaku ngu, ene oni oni urungga teyinowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Hamoo oorengo no yeno eteno. Oni urungga, ngundo ko oni gome ngundiro kenoro, asa, enengo beye sitowi bidodo ngu sobosobo oningga ngu kandeyimo yetoni ngundo gome sobowoowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ene ngu ko oningga nguro ingondudunimonggo ingowaku ngu, nenengo oni urungga ngu sodedo ma ombuwa, ero ingoro, nguro ene damoni yero, ko oni simoo bareku yutoro, ene sono kowoo nero, ngundo yeni wenonoro oruwa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ene ngundiro tero ngu, enengo oni urungga ngu ma sobowooro oodoni, naru gurano, enengo oni urunggaku ko omburo ngu, ko sobosobo oninggaku gome gome utoro yomburiyoro yoro oni enedodo ko gome ma sobowooro oorootenggoku nguno yetoni oruwa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ko sobosobo oninggakundo enengo oni urungga nguro ingonduduni koni murini ngu gome oorengo ingooteku ngu, ene oo ma yomosiyoro enengo oni urungga nguro ingonduduni ma keyoyingo. Ngundiro nguro, enengo oni urungga, ngundo gome gome utoro, ureni biyomi yeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ene ko sobosobo oningga ngu enengo oni urungga nguro ingonduduni ngu, ene ma ingoro, ngundiro ko biyomi tero, nguro enengombo kowuri bodaga ngu yowa. Oni ene oo oowooyingga yowoku ngu, ene ngundiro nangge gumi oowooyingga wendangero hoorooweyerowa. Simoo baredo oo urungga oni gura kandeyimo yetoyi, gome sobowoowaku ngu, asa, ingootenggoku ngu oningga ngu, ene mete ko oo urungga oorengo tero ngu gome sobowoowa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","No de kawero merako ngano ombuwono. Noro nowoondonemo ngu de soru dero sodedo gidooreya deni ero gome ingooteno. (Ene Anutro mande keta gome mesarango nguro eyingo.) ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ene koretero no oniro weti mbumbuwaro de omukondi koorowooro ogingo ingoro kumoowano. Kumoowero, nguro nowoondone kowuri oorengo yetoni, ene ngu ma tunooteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ye bine ngandiro ingootenggo? No merako ngano ombuwonomu ngu, imakeyingo muri ngu yunowero ero ma ombuyingo. Kini, no yeno eteno. No mera ngano oni simoo bare wesoowooyerowero ombuwono. Gidarega Anutno nowoondoye hamoo tetoyi, gidarega nowoondoye hamoo ma tewonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ataga nga naruno ngano, nga wesoowooyeroweroyi muringga nga, ngu ngandiro. Oni gidarega noro nowoondoyemo hamoo teweroyi nguro ataga ko kootuyisina, oni simoonggoro kandegura ya gurananggemo oodoyi, oni kabusa, ngundo oni erayaga nguya ero boguwootoyi, ko oni erayaga ngundo kabusayiga nguya boguwooro ronggeyoro songo songo oruwanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Eweyimbo nangonimboya sanggiri tetoni, nangonimbo eweyimboya sanggiri tewa. Nemimbo nambonimboya sanggiri tetoni, nambonimbo nemimboya sanggiri tewa. Oni gura bareyibo, neboyiboya sanggiri tetoni, ko nangoni bareyi enebana ootoogero neboyiboya sanggiri tewa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yisasdo simoo bareno ero eyingo. Ye sambono goboore sa utekusina kenoro sodedo ingootenggo, sono ombuwa, ero ingootenggo. Ngundiro ingootoyi ngu, hamoo oorengo sono ombute. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Sono midugu naru kinitetoni, doogo urungga mayetoni ngu, ye ingoro etenggo. Sa kookingo urungga tewa, ero etoyi, ngundiro nangge tete. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ye mebuye tegedodo oni! Ye mera ngaro naru sunggi oo ko samboga awero naru sunggi, oo ngu gome kenoro ingootenggo. Ene ndawugaro nguro, ye naru ngaro oo nga gome ma wirikoro kenoro ingootenggo? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ndawugaro yengombo ingondudu gome ma tero, ngunonggo muri nenengo ngu wirikootenggo? ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ye oni gurado yoyoro mande wirikoyingo onino oorowutoningga ngu, asa, ooreko nguno yengo nangge mandeye sodedomangge yomosiyoyi. Kinitetoni, enendo ye yoyoro mande wirikoyingo oni urungga ngu kandeyemo yoyetoni, ngu oningga ngu enebana yoyoro, kumba ootuwoo oni kandeyemo yoyetoyi, enendo yoyoro, oororo ya biyomimo yoyewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","No ye eteno. Ye ya biyomi ngu sodedo ma yokoro sawanggo. Ye komo koretero yengo weti ururu ko weti bobodi ngu bidodo wendangemukoya yokoyi! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ngu narunggano nguno, oni gidarega Yisasno mayero eyingo. Galili oni gidaregado wooro yewero yetoyi, ngu naruno, Rom Gabuman tabango oni oowooyi Payilat ngundo omburo, wooro yeyingo oniku gidare yutoro, nguro sidudaroye nguya wendoni merako uyingo. Nguro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yisasdo enengo mandeye gumi eyingo. Ye ndadiro ingootenggo? Ngu Galili oni nguro muriye biyomiye ngu, Galili oni gidarega dagayeroro, nguro ene weti mbumbuwa urungga tero nguro kumootenggo, bine? ");
INSERT INTO rwo_rawa_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ngundiro ingonduduga ngu nenengo kini. No yeno hamoo nenengo eteno. Ye bidodo nowoondoye hamoo oorengo ma yowoorengowanggoku ngu, ye bidodo ngundiro nangge hamoo oonootewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Kurimi ngu, oni kande eraya kengga gidemboro kabusa (18) ngu Sayilom endemo nguno ya pirungga tookero, ngundo yureni kumooyingo. Nguro ye ndadiro ingootenggo? Enengo weti mbumbuwaye, ngundo Yerusalem oni oorootenggoku, nguro wetiye ngu dagayeroro, ene kumooyingo, bine? ");
INSERT INTO rwo_rawa_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ngundiro ingonduduga nguya metemi kini. No yeno hamoo oorengo eteno. Ye nowoondoyemo hamoo oorengo ma yowoorengoro ngu, asa, ye nguya bidodo ngundiro oonootewanggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yisasdo mande adingayi gura ero eyingo. Oni gurado enengo kono de gura miyingo. Kootuyisina, engge yowero omburo kenoyingomu, ngu engge kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ngundiro kenoro, ngu kongga nguro sobosobono eyingo. Ingo. Dagoma kabusa (3) no nga dega nga enggeboro omburo kenootoowe, engge kini tewo. Ngundiro nguro, ge doongooya oorongooga uni. Oode ngundo ko ngaro mera urumi kingo yeni kinitewa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ko oninggakundo mande gumi ero eyingo. Oni urungga, nguno yokootooga nga dagomangga nguya kono dikaya orini. Nondo damonimo mera ngu komoongoro nguno Bulmakawu boga, nguro use yoro mayero yewano. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Anduno, dagomanggano nguno enggetoni ngu, asa, ngu gome. Nguno ma enggetoningga ngu, arisa, ge mete doongo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Kando naruno, Yisasdo Yuda oniro yambo ya gurano oni simoo bare mande yunoro etuyeroyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Bare gura nguno oruwo. Ngu barega ngu oomboorobo tooburi wimbuyimo woorogongoro oruwo. Ene nenengo randoro nguya ma endeyoyingo. Kini, ene penggo penggo nangge tero endeyoro oruwo. Nguro dagomani ngu (18) kande eraya kengga ke gidemboro kabusa, oombooro ngundo yeni biyomi yeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yisasdo barega ngu kenoro negongootoni, tanggeyimo ombutoni eyingo. Ge nga barega nga gengo sayingge kinitete. Oombooro biyomi beseya sayi. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ngundiro tero, Yisasdo kandeyi ngu barega ngu tabangomo yetoni, ngu barega ngu sodedomangge ootoogero, nenengo oorengo dikaro, Anutro bingamini urungga oorengo ero okooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Yuda oniro yambo ya, nguro tabango, ngundo Yisasya sanggiri tero, oni simoo bareno eyingo. Ko teweroyi naru ngu kandegura gidemboro guranangge, (6) yengo sayiye goweyemo ngu onindo yomosiyoyi, ero ngu ye ko teweroyi naruno mayeyi. Ye ngu oo ngu yoro, Sabat naruno ma mayewero. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Urungga Oo Bidodo Simburi Simbunani, Yisas ngundo mandeni gumi eyingo. Ye nowoondoye godange oni! Yengombo ngu kando naruno, Bulmakawu bo Donggi yoyoro saro, sono yunootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ene nga barega nga, ngu Ebarahamro soweni. Setando dagoma kande eraya kengga kegidemboro kabusa, gosiyoro oruwo. Ngundiro nguro, Sabatno, no ngu utongga ene gosiyoyingongga, ngu wesiyooteno. Ngundiro muringga ngu metemi. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yisasdo ngundiro etoni ngu, enengo mundi oniku oyimo yeroyingo. Simoo bare bidodo Yisasdo ngu oo amana onindo ma teweroyimu ngu tetoni kenoro, nguro ene oni oni urungga oorengo teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Arisa, Yisasdo ko eyingo. Anut Oo Bidodo Simburi Simbunani ngundo simoo bare enengo sobowooteku, ngu ndawu ooga ngundiro? Nondo ndawu ooga bungomo etoowe ngu mete ingowa? ");
INSERT INTO rwo_rawa_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ngu ngandiro. Oowari yuwooyi gura oowooyi Masitet. Nguro tanggori ngu bobodi oorengo. Ngu oni gurado yuwooyi yoro enengo kono mitoni, kootuyisina oorero, de urungga ke kambinidodo tetoni, numbo nguno mayero bibitero nguno tagiyo tero mindiyo yewanggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yisasdo ko eyingo. Anut Oo Bidodo Simburi Simbunani, ngundo simoo bare enengo sobowooteku, ngu ndawu ooga ngundiro? ");
INSERT INTO rwo_rawa_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ngu ngandiro. Ngu oo manongoyingo koongeweroyi oowooyi Yis. Bare gurado ngu Yisga ngu yoro ngundo oo kikidoyingo koondo kabusa ngu yoro, Yis nguno yetoni, yowoorengoro, asa, kootuyisina, Yis ngundo ngu bidodo yeni koongemukowa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ngu naruno, ene ende bobodimo ururumo nguya saro, oni simoo bare mande ero etuyeroro, yade yade oororo, Yerusalem endemo tunooteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ngu naruno, oni gurado Yisasno eyingo. Urungga Oo Bidodo Simburi Simbunani, oni guranangge nangge bine Anutdo yoyowa? Etoni, Yisasdo enengo mande ingoro gumi ngandiro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Ye yanggango oorengo yerogogo, ye komo yamuko bodaga nguwoore uwanggo. No yeno eteno. Oni oowooyingga nguno uwero ingootenggoku, ene uweroyi ereremo kini. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kootuyisina, ya Simburibo ootoogero, yamuko goodootoni, ye ngu naruno omburo, endesina dikaro, ngunonggo yamuko utoro ewanggo. Urungga Oo Bidodo Simburi Simbunani yamuko goosooyuno, ero ewonggo. Ngundiro etoyi, enebana manggoye gumi ngandiro ewa. Ye ndawu oningga? No ye watayi kini! Ye ndanonggo mayetenggo? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Yendo eneno ngandiro ewanggo. Noore geya oowari sono oo gobooro nero, ge noorengo ende kewoorokono dikaro, ngunonggo mande nooreno ero etuyeroyingo, ngundo mayeteku nga. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Etoni, enebana manggoye gumi ngandiro ewa. Ye ndanonggo oni? No ye ma ingooteno! Ye noro nowoondoyemo hamoo kini! Ngunonggo ko sayi, ye oo biyomimu tero yaratenggoku oni biyobiyomi, ye yokoya sayi! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Kootuyisina ye osisambaye Ebaraham Ayisak Yekob ko Anutro ingondudu eyingo oniku sambo endemo oorootenggoku, ngu yeyoro ngu, ye sendoro biyobiyomi tero metooye kini ndindi tero oruwanggo. Ndadiro nguro, ye Anutro mande ingoro ma keyowonggoku, nguro ene ye yoyokootoni, sambo endemo nguno ma uwanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Oni simoo bare ene Anutro nowoondoyemo hamoo tetenggoku ngu, mera bidodomonggo omburo, Anutro endenimo nguno oo simbo urungga katoyi, ngu newanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ye komo gome ingoyi! Oni gidarega kootu ombutenggoku, ngundo oororo koretewanggo. Oni koreteyingo ngu, ene omburo, kootu tewanggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ngu naruno nangge, Parisi oni gidarega mayero, Yisasno eyingo. Ge nga endega nga sodedomangge yokoya, ende gurano toonge. Ndawugaro nguro, Herodndo ge gureni kumoowero ete. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ngundiro etoyi, Yisasdo ngu onikuya mande gumi eyingo. Ye ooroya, ngu se kokingga nguno ngandiya eyi! Ingo! Ataga ngu no simoo bareno oombooro biyomi owero, sayi mambudodo oni yomosiyeroro, ngu no ko temukowano. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ene ataga, yangeni, yangenggoodo nguya, no yade yade oororo, Yerusalem ende yootoowegago; ndadiro nguro, Anutro ingondudu eyingo oni gura, ende songomo ma ureyi kumoowa. Kini, ene komo Yerusalemno ureyi kumoowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ye Yerusalem oni simoo bare, gowugowurongo, ye komo Anutro ingondudu eyingo oni, yureyi kumoowonggo. Anutdo oni ye etuyerowero soweyootoni, yendo digi yoro, ngundo yurewonggo. Naru oowooyingga no yengo simooye yowuruyerowero teteno. Kootooribo simoongo yoyeni wireyo newendemo yowuruyerooteku ngundiro. Ene ye ngu yokoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ye gowugowurongo ingoyi! Anutdo ye hoorooweyerowero teni teni kinitetoni, nguro ene yengo ende ngu kuri yokowo. No yeno eteno. Ye no ko ma neyoro oodoyi, oororo ngu narungga ngu tunootetoni ngunonggo, ye ngandiro ewanggo. Ene oowooyi bingami okoowato. Ene Urungga Oo Bidodo Simburi, ngu oowooyimo ombute. Ngundiro ero, ngu naruno, ye no neyowanggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sabat naru gurano, Yisas oororo, Parisi oniro tabangonggaro yano enedodo oowari neyingo. Ngu yano oni ngu bidodo Yisas kenondadangero oriyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Nguno oni gura kekandeyi koongeyingongga Yisas tanggeyimo ombuworo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yisasdo ngundiro kenoro, yowoorengoro mamana mandero ingondudu onikuya, Parisi oniya sumoo yunoro eyingo. Noore mete sayi oni naru kundingiyimo ngano yomosiyowato, bine, ngundi kini, bine? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ene mande gumi ma ero, neneteyingo. Ngundiro tetoyi, Yisasdo ngu oni moondeyi koongeyingonggaku ngu yoro yomosiyoro sureyootoni toongeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Yisasdo ene bidodo sumoo yunoyingo. Oni gura ye kewooroyemo ngano, enengo nangoni bine ngundi Bulmakawu boningga sono mereno soretoni ngu, ene naru kundingiyimo sodedo ma woosooro yowa, bine? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ene ngu mandega ngu gumi ma eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yisasdo yeyootoni, ngu oowaringga nguno mayero ene yaba koreteyingomo bibitewero ingoyingo. Ngundiro tetoyi, nguro Yisasdo mande adingayi gura ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Oni gurado bare kameyowero oo simbo gurano ge negogerootoni ngu, ge yaba koreteroga nguno ma bibitewa. Ngu oningga, ngundo ene oni gura oowooyi urungga ge dagageroro ene urungga, nguro nguya ombuwa, bine? ");
INSERT INTO rwo_rawa_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ngundiro tero, oo simbo kayingo Simburiga, ngundo omburo geya ewa. Ge woosooya oorowutooga nga oningga ngando ngu yabaga nguno bibiteni, ero ewa. Ge ngu yaba koreteyingongga ngu yokoro, ene inootoyi bibitetoni, ge nguro oyimo urungga oorengo yoro, ge oororo uro, kootuyisina amuno bibitewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ye ingoyi! Ge oni gurado oo simbo kaya, ge negogerootoningga ngu, ge ombuya, yaba wengamo amuno oni kootuyesina bibite. Kootu oo simbo kayingo simburi, ngundo omburo geyoro ewa. Doboone, ge ombuya ooroya, awuno bibite, ero etoni, ge oni mayewonggoku ngu doongeyemo koretero bibitero, ge bingaminggedodo tewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Oni gura enengombo enengo oowooyi bingami okooteku ngu, Anutdo oowooyi yeni merako uwa. Ene oni gura, ene oni songo nowoondoyemo ameno oorootekungga ngu, Anutdo yoro oowooyi bingamidodo awuno oorengo yewa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yisasdo Parisi oningga oo kayingo simburiga nguya eyingo. Ge oowari gura kaya ngu, ge gengo dobookurige, konebage, ko gengo kenggemo oni, ko ende gobooro oni ngu, ene beye digidodo oni ngu nangge ma negoyerowero. Ge ngundiro tewaku ngu, enebana gengo oo kawoku nguro gumi oo karo gunootoyi, ge enengo yano oororo, oowari gumi newa. Gengo nowoondoge nguro nangge ma ingowero. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kini, ge oo simbo urungga ko kaya ngu, arisa, ge komo oni simoo bare angoyi, sayi mambudodo goweye biyomi ngu, kekandeye biyomi ko doongeye kiringo oni ngu negoyerootoyi, ngundo mayero newanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ge muri ngundiro ngu tetoyi, nguro Anutdo geyoro oni oni tewa. Ngundiro oni, ngundo ene gengo oo simboga karo yunowoku, ngu gumi ma karo gunoweroyi, ene ereremo kini. Kootuyisina, Anutdo gengo oo simboga kawoku nguro ngu Anutro oni nenengomu merenonggo ko ootoogewanggoku naruno, ngundo gumi oo gunowa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ngu naruno, oni Yisasdodo oowari neyingomu ngu gurado Yisasro mandeni ngu ingoro, ootoogero Yisasno eyingo. Oni ene Anutro ende musiyonimo simbo kayingo ngu newaku ngu, ene mete oni oni tero oruwa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ene Yisasdo ngu oningga nguya mande adingayi eyingo. Oni gura ene oo simbo urungga kawero ngu, ene koretero oni simoo bare oowooyinggano kuri ero endeyootoni ingowanggo. Nguro naruni nguya ero yunowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Oode oowari kaweroyi naruno, oni oo simburigakundo enengo kirikiri oni sureyeroro ewa. Ge toongeya, nondo kuri onino ewonoku nguno ngandiya e. Ye mete ataga mayeyi, no oo kuri karo yomosiyooteno. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ene ngu oniku bidodo enengo ko songo songo, ero ewonggo. Noore ma oorowuwato, ewonggo. Oni gurado ewo. No mera gura keta uriyowonoku, no toongero ngu kenowano. Oniyooge, no ma oororo kenowano. Gedo ooroya ngundiya e. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ngundiro etoni, oni gurado ero ewo. No Bulmakawu bo keta kande eraya (10) uriyowonoku, nguro no oororo ngu towoongoro kenowero nguro ooroya awanggemo e. Oniyooge, noro ma ingowero. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Oni gurado ewo. No ataga bare yoro, nguro no ma oorowuwano. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ngundiro nguro, kirikiri oni ko oororo, enengo oni urunggakuno ngu bidodoboro ewo. Ya simburigaku ngundiro ingoro, ene sanggiri tero, enengo kirikiri oniya ewo. Ge sodedo ooroya, nga endega ngaro oore urungga nguno ko oore bobodimo nguno, angoyi oni, oni goweye biyomi, doongeye kiringo, ko oni kekandeye biyobiyomi ngu bidodo yoyoya mayetooga, ngundo noro yano ngano ombuyi. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Kootuyisina, kirikiri oninggakundo, oni urunggakuya ewo. Urungga, gedo ewoku ngundiro tewono. Ene yaba gidarega kingo ooroote. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Oni urungga ngundo enengo kirikiri oninggakuya ewo. Ge ooroya, oore ururu bidodomo endeyoya, ko kanggakuri endeyoya ngunonggo, oni simoo bare yoyoya mayetooga, ngundo noro yangga nga ndindi teni, ero ingooteno. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","No geno hamoo eteno! Nondo oni kuri ero endeyowonomu oni ngu bidodo ene nondo oowari simboga katenoku, nga gurado bodaga ma nero ingowa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Oni simoo bare urungga Yisas keyoro endeyoyingomu ngusina yowoorengoro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Oni gura no tanggenemo omburo ngu, ene komo Anutro ingooteku ingonduduga, ngundo eweyi, nemi, simoongo, konebeyi, kuwookuwooyi, ko enengo goweyi keta oruweroyi, ingonduduga ngu Anutro ingootekuga, ngundo oo bidodo dagayeroote. Ene ngundiro ma tero ngu, asa, ene noro kirikiri oni tero ma oruwa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Oni gura noro ingoro no keneroro endeyootoni, nguro ene komo meyero kowuri gura gura onindo inowanggoku ngu no oowoonemboro ngu koorowoo. Ene oni gura kowuri ngundiro koorowooweroyi ereremo kini ngu, ene noro kirikiri oni ma tewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ye kewooroyemo oni gura ya pirungga sambono yewero ngu, ene komo koreteya bibiteya ya ngu yemukoweroyi nguro urini ngu gome kandangero ingowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","30","Ene ngundiro ma tero ngu, ya nguro urini ma ingoro nguno damoni yero, ene Simen yemukoro yokootoni, asa, oni bidodo kenoro yomooyinoro ewanggo. Nga oningga nga oniyooge ene, ya yeweroyi, ereremo kini. Oniyooge! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ngundiro ero, asa, mande adingayi gura eyingo. Mera ngaro oo sobosobo tabango oni gura, ene toongero tabango guraya ebe urewero ngu, asa, koretero, ene bibitero ingondudu gome terogogo, enengo me oni (10,000) ngundo ene mete tabango gurado me oni (20,000) ngu yutoro oweyerowa, bine, ngundi kini, bine? Ene komo gome ingondudu terogogo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ene ebe ureweroyi yanggangoni ereremo kini nguro, asa, enengo me oniku oriroko oodoyi, ene sodedomangge mande soweyoro ewa. Noore ebe sodedo ma urewato. Kini, noore komo koreteya bibiteya, imakeyingo murimo doboo yeyiga. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ene koretero ye komo nowoondoye, ingonduduye ngu bidodo Anutno yero, enengo ko tewanggo. Ngundiro nangge, oni gura ye kewooroyemo nguno, ene enengo oo bidodo ma kootu inoro ngu, asa, ene noro kirikiri oni kirarongo ma tero oruwa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ene mande adingayi gura eyingo. Sayi nembo (Sol) ngu oo gome. Ene sayi nembo ningguri kinitetoni ngu, asa, noore ndadiro tetooye, ngu ningguriga ngu ko mete tewa? Kini, noorendo ngu yomosiyoweroyi, ereremo kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Sayi nembo (Sol) ngundiro ngu, mera oo miweroyi kono nguno yeweroyi nguya kini. Noore Bulmakawu usedodo yowuruwooro ngundo mera tetooye, urumidodo teweroyi nguya kini. Noore ngundiromu ngu kingo tarangooteto. Oni sodeyi mande ingoweroyi gome metemi ngu, ene komo mande nga gome ingoni! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Gabuman beye yoweroyi (Takis) oni, ko weti mbumbuwadodo onindo Yisasro mandeni ingowero tanggeyimo mayeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Parisi oniya, ko mamana mande etuyeroyingo oniya ngundiro kenoro, nguro boguwooro eyingo. Nga oningga nga, ngu ene weti mbumbuwadodo oni yoyoro, nguya oowari netenggoku eke! Ene nguya dobooyero endeyootenggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","4","Ngundiro etoyi, Yisasdo mande adingayi gura ero eyingo. Ye kewooroyemo nguno oni gura ene Sipsip onibi kandegura (100) oruwo. Nguromu gura oonootetoni, ene enengo Sipsip gidarega mera gurasina yokootoni oo newoodoyi, ene Sipsip nangoni gura oonootewokungga ngu erewero yade kenoro yorogogo, asa, ene kengewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ene ngu Sipsipgaku kenoro yoro koorowooro, oni oni tero oorowuwa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ngu oninggaku enengo Sipsipku yoyoro ende mayero, enengo dobookuriyimo ero ete. Ye noya oni oni tewato! Noro Sipsip gura oonootewoku, ene no erewero ko yowono. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","No yeno hamoo eteno. Oni gura ene weti mbumbuwa muri yokoro newende yowoorengootoni ngu, sambono oni ngu bidodo oni oni urungga oorengo tetenggo. Oni oowooyingga ene ngundiro ingootenggo. Noore nenengo ero ingootooye, nguro ene Anutdo nowoondoye ma yowoorengootoni, ngu, asa, Engel oni sambono oorootenggokundo ngu enengo ma oni oni tewanggo. Kondibo kini, oni gura Anutno newende yowoorengootoni ngu, nguro ene oni oni oorengo tewanggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yisas ene mande adingayi gura yunoro eyingo. Yengo bare gura ene beye tanggori kande eraya (10) enengo siko oruwo. Kootuyisina, guranangge toongewo. Ene soru karo ngu himimo ya newendekuri, gugu so oo ememangge gasiyoro, nguwoore erewero oode yorogogo ene kengewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ene yoro yokoro ngu, asa, enengo dobookuriyi negoyerootoni, omburo, yowuruwooro bibitetoyi ewa. Ye noya oni oni tewato. Nguro, noro beye gura toongetoni erewero oode, ko yooteno. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","No yeno hamoo eteno. Anutro oni Engel ngundo weti mbumbuwadodo oni gura newende Anutno hamoo tero yowoorengootoningga, nguro oni oni urungga oorengo ngundiro tewanggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yisasdo mande adingayi ngu soweyoro eyingo. Oni gura ene nango sumoongo eraya. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Naru gurano, nangoni kootungga ngundo eweyimo eyingo. Awa, gengo beye oo sitowi ngu wesoowooya noromu nuno, eyingo. Ene ngundiro etoni, ingoro, beye sitowiku wesoowooro, enengomo enengomo yunoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ene naru bodaga oode, ngu naruno, nangoni kootungga, ngundo enengo oo sitowi bidodo tero tewooro ende urungga orirokomu, nguno toongero nguno oruwo. Ngu simoongga ngu endega nguno oode, nguno beye sitowiniku ngu, buribari endeyoyingo muri biyomi nguno oorongooni umukootoni kingo oruwo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ngundiro oode, enengo beye oo sitowiku oorongooni umukootoni, kootuyisina, ngu endega nguno oowariro kumooyingo naru urungga tunooteyingo. Ngu simoongga ngu, ene oowari gura yoro neweroyi oo gura kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ngundiro nguro, ngu simoongga ngu, ene ende dabemiwoore oo sosorango erewero yade mayero, ngu mera nguro oni sitowinidodo oni urunggano ko tewero sumoo eyingo. Ngundiro sumoo etoni, ngu oni urungga, ngundo yoro sureyootoni, enengo bodoro yano bo sobowooni ero, etoni oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ngundiro tero, ene bodoro de tanggori ngu yunootoni, nero kawuye pakini yetoyi, yeyoro ingoyingo. No nguya gura netoowega kawune ndindi teni, ero ingoworomu nguya kini. Oni gurado kenonggowurongoro oo gura ma inootoyi neyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","18","Ngundiro tero, newende himi yetoni, ingondudu tero ingoyingo. Nenengo awanemboro ko oni ngu ene oowariye urungga tero netenggo. Nondo ngano ootooro oowariro kumooteno. Ngundiro nguro, no ko awano oororo ewano. Awa, no Anut doongeyimo, ge doongenggemo nguya weti mbumbuwa tero, endeyoro oode, ngunonggo ko mayeteno. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","No oni biyomi, nguro noya nenengo nangone, ero ma ewero. Kini, noyoya gengo kirikiri oni eya noye, ero ewano. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ngundiro ero ingoro, ene ootoogero eweyi tanggeyimo oorowuweroyimboro oorowuyingo. Ngundiro tero, yade yade mayetoni, eweyimbo oriroko anduno doongetero, nangoni kenoro, nowoondoyi tero, ootoogero kendutero oorowuyingo. Oororo nangoni dowooro dureyoro yenggonangoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Nangonimbo eweyimo oyimo urungga yoro eyingo. Awa, no Anut doongeyimo ko ge doongenggemo nguya weti mbumbuwa tero endeyoro yade ngunonggo mayeteno. Ngundiro nguro, naru gurano, nenengo nangone ero ma ewero. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ngundiro etoni, eweyimbo enengo kirikiri onino eyingo. Sodedomangge, ye ooroya, ye nenengo kumba gome pirungga ngu yoya ombuya yemuyinoyi! Kandeyimo toombo yeya ko keyi goweyi nguya yoya yeyinoyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ye bo Bulmakawu nangoni moondeyi ndinditeyingo urumidodoga yoya utoya katoyiga ngu nero oni oni tewato. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ndadiro nguro, nga nangonengga nga kuri kumooyingo ero ingoro oodoowe, ene keta oode ataga mayete. Ene kuri oonooteyingomu, ene noore ataga kenoro ko yooteto. Ngundiro nguro, ene damoni yero, oni oni teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ngundiro tewootoyi, asa, enengo nangoni koreterogaku ngu kono ko tero oruwoku, ngunonggo kootu mayero, ya tanggeyimonggo ingoworomu ngu, yambo sumbimbooro tero, kunoburo tetoyi, ngguyi ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ngundiro ingoro, ene kirikiri oni gura etoni tanggeyimo ombutoni eyingo. Ame ndawu ooga tetenggo? ");
INSERT INTO rwo_rawa_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ngundiro etoni, ngu kirikiri oningga ngundo gumi eyingo. Gengo konege yade yade keta mayetoni, nguro awanggebo bo Bulmakawu urumidodoga utoro katoni, ngu nero nguro oni oni tetenggo. Ndadiro nguro, enengo nangoni kootungga ngu ma kumooyingo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ngundiro etoni, nangoni koreterogaku ngu ingoro, sanggiri tero ya newendemo uyingo. Ngundiro tetoni, eweyimbo ya newendemonggo oorero ememangge ememangge nangonimo mande ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ngundiro tetoni, ene nangonimbo eweyimboro mande gumi eyingo. Ge ingo! Dagoma oowooyingga no gengo ko kingo tero oorooteno. No naru gurano gengo mandege manggoge ma toongooyingo. Ge nguro Meme bo nangoningga kingo nunootoyi, utoro karo dobookurinemboya nero, ma oni oni teyingo. Hamoo oorengo kini! ");
INSERT INTO rwo_rawa_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ene nangongge ngu gengo beye sitowi ngu buribari ooreko ooreko se tero endeyoro, nguno beye bareno yokomukoro yade mayetoni, nguro ge bo Bulmakawu urumidodomu utoro kateku ngu! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ngundiro etoni, eweyimbo mande gumi eyingo. Nangone, suwooyi sano noore gome gobooro oorootero. Noro oo sitowi ngu gengomu nangge. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ene ataga ngu noore komo oni oni tero, nowoondonani gome imakeyingomo oruwato. Ndawugaro nguro, ene nga konegega nga kuri kumooyingomu, ene ataga ko keta ooroote. Ene toongero kombiteyingomu, ene noore ko kenooteto. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yisasdo enengo kirikiri oniku mande adingayi gura eyingo. Beye sitowidodo oni gura ene enengo ko sobosobo oni ooroote. Oni beye sitowinidodo oningga, ngu enengo ko sobosobo oningga ngu goweyi sanggawero mande ewonggo. Gengo ko sobosoboga ngundo gengo beye oo sitowige kingo yomburiyowo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ngundiro etoyi, arisa, ngu oni urungga, ngundo ngu ko sobosobo oningga ngu negongootoni ombutoni eyingo. Geya etoyi ingowonoku, ngu ndadiro? Oo tewoku nguro muri wesiyoya e. Ge noro ko sobosobo oni ko ma oruwa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Asa, ngu ko sobosobo oninggaku newendemonggo ingondudu tero ingoyingo. No ndadiro tewano? Nenengo oni urungga oo bidodo Simburi, ngundo ooni no kandenemo oorooteku ngu ko yoro, no sobosobo kono oweneroote. Ngundiro nguro, no ndadiro tewano? No ko urungga yanggango teweroyi oni, ereremo kini. No oni gidaregano oowari ooro kira ewero no oyimo moore. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ene kowuri ingoro, ingondudunimonggo no oo gura ingooteno. Urunggado sobosobo kono, owenerooteku naru nguno, no ndawu kongga tetoowe, ngundo dobookurinembo nowoondoyi tetoyi, no eneya ko doboo yewato? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ngundiro ingoro, oni enengo oni urungga, nguro oo weti tero oo yoyingoku ngu, guranangge nangge songo songo sumoo yunoro eyingo. Ge ko simburi urungga nguro wetini ndadiro inowa? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ngu oni koreteroga, ngundo gumi eyingo. no Daram 100 de oo urumi ngundiro inowano. Etoni ngu, asa, ko sobosobo tabangonggakundo eyingo. Geno weti oorooteku nguro, ge bibiteya sodedomangge ngu weti tewoku Pepangga ngu yoya (50) nangge nakango. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ngundiro tero, oni gura sumoo inoro eyingo. Gedo ngu gumi ndadiro inowa? Etoni, ngu oningga ngundo eyingo. Nondo ngu Rayis si 100 (onibi eraya 25 Kilo Bek Rayis) inowano. Etoni, ko sobosobogakundo eyingo. Ge gowegemo wetidodo nguro, ge sodedo bibiteya 80 Bek (onibiga kande eraya gidemboro eraya 25 Kilo Bek) nangge nakango. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ngundiro tero, ngu ko sobosobo oningga ngu, ene ingondudunimonggo nowoondokara tero, ko teweroyi oni nguro ko simburi urungga, ngundo enengo ko sobosobo oningga nguro murini biyomi ngu kenoro yokowero ingoyingo. Ene ko ingondududodo oni. Ngu hamoo oorengo, nga naruno nguya oni ingonduduyedodomu ngundiro urungga oorootenggo. Oni simoo bare Anutno nowoondoye hamoo teyingo murimo oorootenggoku ngu, ene godange teweroyi nguno ingoyingo metemi nguya kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yisasdo eyingo. No yeno hamoo eteno. Oni Anutno newende hamoo teyingo, ene nguya enengo beye ngu gome sobowooya simoo bare gidega hoorooweya doboo yeyi. Kootuyisina ngu oningga ngu oo tewero wenonootoni, asa, ngu naruno dobookuringombo hooroowewanggo. Kootuyisina ngu oningga ngu oorero Anutya sugi sugi oruwa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ene oni gura oo bidodogano newendemo hamoomonggo gome sobowoowaku ngu, ene oo urungga nguya ngundiro newende hamoomonggo sobowoowa. Oni ene ko bodagano ko gome ma tewaku ngu, ene ko urunggano nguya ngundiro ko gome ma sobowooro tewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ene yengo beye kandeyemo oorooteku ngu, gome ma sobowooro ngu, asa, Anutdo hamoo engge gome ngu ye yunootoni, ngu gome sobowoowanggo? Hamoo oorengo kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ye oni guraro oo ngu gome ma sobowooro ngu, onendo yengo oorengo oo ngu yunowa? Kini, oni gurado oo gura ma inowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ko oni gurado oni ururu erayagomo ko tero ma oororo omburo tewa. Ngu ko oningga ngundo ngu oni ururu erayagaku, gurano newende inoro, nguro nangge ko tewero ingoro, guragakuya newende biyomi ingoro, nguro koni ma tewa. Ene guraro konimo ngu sureyo kiniyetoni, ko guraro konimo ngu, ene ko gome tero yobasiyoro ko teyinowa. Ngundiro nangge, ye Anutro ko oni tero, nowoondoye bidodo beye yoweroyimo nguno nangge ma yewero. Ye nowoondoye ko eraya teweroyi, ngu ereremo kini. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Yisas mande soweyoro gura yunoro eyingo. Parisi oni ngu, ene beyedoro gome ingoro, nguro hahangetenggo. Nguro ngu, Yisasdo mande nga bidodo etoni, ingoro, nguro ene yomooyinoro mande eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ene Yisasdo yeyoro ero eyingo. Ye muriye gome nenengo ngu simoo bare yengo nowoondoye ingoote. Onindo oo bingami okootenggoku ngu, Anut doongeyimo ngu oo ngu buwoo biyomi googoosedodo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Mamanaro mande nguya Anutro ingondudu eyingo oniro mandeye oode oode omburo, Sonoyeroyingo Yon nguro naruno. Ene Yonro narunonggo omburo, wenga ataga nga, ngu Anutro mande gome mesarango ngu Anutro yoyo pawanonggo tunootero, ende bidodomo oorowute. Oni simoo bare bidodo ngu yoyo pawangga ngu newendemo uwero yanggango oorengo yetenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Kootuyisina, sambo ende mera nga nguya oororo kinitetoni, ene mamana mande ngaro gumi bodaga ngu hamoo oorengo ma kinitewa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Oni simoo bidodo enengo bare sumooye yoyokoro bare songo yoyoro, nguno ene erambarisa oruweroyi ngu yomburiyootenggo. Kuri kameyimbo ene yokowoku ngu, ene erambarisa oruweroyi mamana mandega ngu yomburiyowo. Simoondo bare gura yooteku ngu, asa, Anut doongeyimo, ngundo bare erayaga ngu yomburiyeroote. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yisasdo mande gura eyingo. Kurimi beye sitowinidodo oni gura oruwo. Ene suwooyi sano towi nengguro gome gomemu nangge tero, kumba dagoyi gome ngu yemuro ootooro, ngunonggo ene suwooyi sano oowari gome ninggurimu nangge nero oni oni tero, oororo omburo teroruwo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Ngu sitowinidodo oni urungga nguro yamuko dabemimo nguno, oni angoyi gura oruwo. Ngu oowooyi Lasaras ngu mambubo goweyi kondibo yeni kini teyingomu, ngu sitowinidodo oningga nguro yamuko dabemimo bibitero, oowariro ngguyinggayi tero oruwo. Ngu sitowinidodo oningga ngundo oowari neya sosorango yeni merako soretoningga newe, ero Lasaras hahangero, ingondudu urungga tero oruwo. Ene yamuko dabemimo nguno bibitero, oodoni, sebo mayero, enengo mambuniku meyaboro oruwonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Kootuyisina, angoyi oninggaku kumooyingo. Anutro Engel onindo omburo, Lasaras gaboyi okooro yoro oorero, Ebaraham begowoomo yetoyi, bibitero oruwo. Kootuyisina, ngu sitowinidodo oninggaku nguya kumootoni merengooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ngu sitowinidodo oninggaku gaboyi oorero, ende biyomi de nombo buni ma kumooweroyingga, nguno uyingo. Uro, nguno ogingo urungga oorengo ingoro oode, ngunonggo doongetero, Ebaraham oriroko anduno kenootoni, Lasaras begowoomo bibitero oodori yeyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ngundiro yeyoro, meno ero eyingo. Awa, Ebaraham ge noro nowoondoyi teya, Lasaras sureyootooga, kandedibiyibo sono bodaga sanggaweya ombuya, mebunemo yetoningga bodaga gingo yeni. Ndadiro nguro, no de nombono moondene kookingo oorengo yetoni, nguro hahangero ogingo urungga ingooteno. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ngundiro etoni, ene Ebarahamndo gumi eyingo. Nangone, ge ingondudu te! Ge kuri merako keta ootooro nguno, oo gome gomemu bidodo kuri yomukowoku, nguno ge Lasaras ma hoorooweyingo. Ngundiro tetoyi, Lasarasdo ngu, ene oo biyomi nangge yoro oruwoku, nguro ene ataga nga endemo ngano ngu, ene newende imaketoni ooroote. Ene ge ngu ogingo urungga ingooteku ngu! ");
INSERT INTO rwo_rawa_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Oo gura nguya ingo! Noore ko ye kewooronanimo Anutdo kembe urungga ngundo siribo yeyingo. Ngundiro nguro, oni ngarokonggo yeroko oorowuweroyi nguya hamoo oorengo kini. Ko yeroko ngunonggo nooreroko ngano mayeweroyi nguya hamoo oorengo kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","Ngu sitowinidodo oningga, ngundo ngguyinggayi tero eyingo. Ngundiroga ngu, Awa, ge Lasaras sureyootooga, nenengo awanemboro yano uya, noro konebane kandegura oorootenggoku ngu, ene nguno mande yanggango oorengo eya sodeye sobiyootoningga, ene mande ngu gome ingoro, ene nguya nga ende biyomi oorengonggano ngano ma ombuwanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ngundiro etoni, ene Ebarahamndo nguro mandeni gumi eyingo. Ene Mosesro mande ko Anutro ingondudu eyingo oni nguro mandeye nguya eneno ooroote. Ene komo ngu ingowanggo! ");
INSERT INTO rwo_rawa_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ngundiro etoni, sitowinidodo oningga ngundo gumi eyingo. Kini, Awa Ebaraham oni gura ene kumooyingomundo ko ootoogero mayetoni, ngu kenoro ene soriyokoro ngu, asa, ene nowoondoye yowoorengowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Etoni, Ebarahamndo mandeni gumi eyingo. Ngundiro kini. Ene Mosesro, ko Anutro ingondudu eyingo oni, nguro mandeye ma ingoro keyoro ngu, asa, oni kumooyingo ngu ko ootoogero, ngundo mande etoyi, nguya ma ingoro, nguro nowoondoyemo nguya hamoo ma tewanggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yisasdo enengo kirikiri onino eyingo. Oo guradiro guradiro tunootero, ngundo simoo bare yoyeni, weti mbumbuwano uwanggo. Oni ene oni gura yoro, weti mbumbuwa murimo nguno yewoku ngu, ngu oniyooge oorengo! ");
INSERT INTO rwo_rawa_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Oni gura muri biyomi tewoku ngu, nguro uriyi ene kondibo digi urungga yoro bungeyimo gosiyoro wendeyi newendemo oorongooyi utoni kumoowa. Nguro uriyi ngu, ngu urungga. Ene oni gura simooye nowoondoye yomburiyooteku ngu, asa, nguro uriyi ngu, ngu kowuri kondibo urungga oorengo. Yengomboro ingonda teyi! ");
INSERT INTO rwo_rawa_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Gengo konegegado weti mbumbuwaga tetoningga ngu, ge kenoya sanggiri teyinootooga, ene newende yowoorengootoningga ngu, ge komo enengo wetini ngu andangeyinoya wongooga utoningga kabeteyino. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ene naru gurananggemo geno weti mbumbuwa tambu kandegura gidemboro eraya tero, ngu sanganimo nguno nangge tambu kandegura gidemboro eraya omburo, geno ngguyinggayi tero ewa. No nowoondone yowoorengoote, eya etoningga ngu, asa, ge komo weti mbumbuwani andangeya wongooga utoningga kabeteyino. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Aposel onindo Oo Bidodo Simburi urungga, Yisas nguno ero eyingo. Ge komo nooreno nowoondonanimo hamoo nga yega yanggango yeni. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Etoyi, oo bidodo Simburi urungga ngundo eyingo. Ye nowoondoyemo hamoo teyingo bodaga oodoni ngu, asa, ngundo ye mete Anutro ko urungga tewanggo. Yo, hamoo oorengo, ye nowoondoye hamoo teyingo ngu bodaga ngu Masitet yuwooyi ngundiro ngu, asa, Anutdo ngu tetoni, urungga oorengo yewa. Anutdo yeno ngundiro tetoni ngu, ye mete ngu dega nguya ewanggo. Ge gengo damoningge ukeya toongeya uya wendeyi sono koongeyingo kewoorokono uya nguno dika ero etoyi ngu, asa, ene yengo manggoye keyoro ngundiro tewa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yisasdo mande adingayi gura eyingo. Ye gurado enengo kirikiri oni gura ene kono mera doongooro, ngundi Sipsip boga ngu sobowooro oode ngunonggo mayetoni, ye sodedo ngandiro ma ewanggo. Sodedo ombuya bibiteya oowari neya ootoo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Etoyi ngu, ene ngandiro ewa. Ge noro oowari kaya yomosiyoya, oo gidarega yomosiyootooga, oo dedoningga wendoya, no nunootooga, nero sono nguya nero yokootoowe, arisa, gebana kootu oo nero sono nguya newa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Enengo kirikiri oningga, ngundo manggowo keyoro oo bidodo temukootoni, sumange teyinoro esosootewa, bine? Kini, ngu enengo ko nangge. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ngundiro nguro, ye nguya, Anutdo etoni, ye oo bidodo ewoku ngundiro temukoro ngu, arisa, ye ngandiro ewanggo. Noore ko oni biyomi, noorengombo ko oo nangge teteto. Yo, oni Anutno newende hamoo teyingo ngu Anutro oo ewoku ngu temukootoni, nguro ngu merako ngano onindo oni oni teyinowero, nguro ma ingowero. Kini, enengo uriyi hamoo ngu sambo endemo nguno ooroote. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yisas Yerusalem oorowuwero Galili Sameriya mera erayaga ngu kewoorokuri oorega ngu keyoro oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","13","Ngu naruno, Yisas ene ende gurano uro tunootetoni, oni gori mambudodo kande erayagobo omburo, oore dabemimo songo orirokoyi dikaro, Yisasno meno ero eyingo. Yisas oo etuyeroyingo oni, ge noorengo nowoondoyi teyunoya yomosiyero! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ngundiro etoyi, Yisasdo yowoorengoro yeyoro eyingo. Ye ooroya, Anutno wooro yeyingo onino nguno goweye etuyeroyi! Arisa, ngundiro etoni ngu, oni gori mambudodo yowoorengoro oorowuwootoyi, ooreko goweye moondeyemo mambuku besero toongetoni, goweye mete temukoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ngundiro teyunootoni, ngu oni kande erayagaku nguromu gura, ngu Sameriya oningga enengo goweyi kenootoni, ko mete tetoni, nguro ene yowoorengoro, Yisasno ko oororo, meno manggaru tero, Anut bingami ero okooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ene omukumundoongosinanggo Yisas tanggeyimo bagootero wetoro, Yisasno esosootero eyingo. Eso, no gowene mete tetoni nguro ombutenoku nga! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ngundiro etoni, Yisasdo ngu kenoro gumi eyingo. Nondo ngu kande eraya bidodo metemi tetenggoku, ero ingooteno. Kandegura gidemboro namoraya ngu ndano oorootenggo? ");
INSERT INTO rwo_rawa_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ndadiro nguro, ngu oningga ngu, ene Yuda oni kini, enesu nangge omburo, Anutdo oo goweyimo tewoku, nguro ero okoowo. Yuda oni kandegura gidemboro namoraya ngu ndano? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yisasdo ngu Sameriya oninggakuya eyingo. Ge ootoogeya toonge! Gengo nowoondogemo hamoo, ngundo goyeni gowege metemi tete. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","21","Naru gurano, Parisi onindo Yisas sumoo inoro eyingo. Ndawu narunggano, Anutdo oo bidodo Simburi tero oo sobowooweroyi naruningga ngu ombuwa? Etoyi ngu, Yisasdo mandeye gumi ero. Anutdo oo bidodo Simburi tero simoo bare sobowooweroyi naruningga ngu ombutoni ngu, oni simoo baredo ngu doongeyembo tunoo ombutoni ma kenowanggo. Ene ngandiro ma ewanggo. Kenoyi nga oorooteku nga, ngundi, andusina oorooteku andu! Ingoyi! Anutdo oo bidodo Simburi tero oo sobowooweroyiga ngu ye nowoondoyemo oorooteku nga! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yisasdo simoo bare oowooyinggano mande emukoro yokoro ngu, ene yowoorengoro enengo kirikiri onikuno ero eyingo. Kootuyisina naru wengamo ngu namoko tunootetoni ngu, kowuri gura gura omburo ye wiriyerowaku, ngu naruno ye nowoondoye hahangero Oni Nangoni ombutoningga kenowero ero etenggo. Ene yengo ingondudu ngu ma keyowa. Kini, ene enengo ingonduduni nangge keyowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ngundiro ingootoni, oni songombo ewanggo. Kenoyi, Yisas oorooteku nga! Ngundi, ene kenoyi andusina oorooteku andu. Ngundiro etoyi ngu, ye nguro nowoondoyemo hamoo ma tero, ye oororo ngu ma keyowero. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ye ingoyi, sambononggo yowari soruyi ngundo sambo bidodomo himi yero oorowuwa. Ngundiro nangge, Oni Nangoni nguro tunooteweroyi naruwo ngu sodedomangge ombuwa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Koretero, ene komo kowuri urungga koorowooro ogingo ingoro oodoni, ngu naruno, oni simoo bare oorootenggoku, ngundo mandeni sureyo kini ero kootu inowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Nowaro naruno onindo muri biyomi teyingo, ngundiro nangge Oni Nangoni narunimo nguya ngundiro tewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ngu naruno, ene oo simbo karo nero, sono nero, bare kameyoro oororo omburo tero, oodoyi, ngu naruno, Nowa wanggo newendemo utoni, sono tuwi urungga tunootero, ngundo oni simoo bare bidodo yutoro yomburiyeroyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","29","Lotro naruno nguya ngundiro teyingo. Ene oowari karo nero, nguro sonoyi nguya nero, ene oo uriyoro yoro, ko uriromu oni gidareganonggo beye yoro oowari koyi tero, miro, yawudada tero ya yeroruwonggo. Ngundiro tero oodoyi, Lot ngu Sodom ende yokoro toongeyingo. Ngundiro toongetoni, sambononggo de sorudodo, ko digi kookingo ndindingo biyomi oni kumooweroyimu sambo sono ngundiro omburo, ngundo oni simoo bare bidodo yomburiyerootoni kumoomukoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ngundiro nangge, Oniro Nangoni tunooteweroyi naruwomo ngundiro tewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ngu narungga nguno oni gura ene ya sanganimo awuno oorero, oode, ngunonggo enengo oo sitowi ya newendemo oodoni ngu yowero ya newendemo ma uwa. Ngundiro nangge, oni gura kono toongero oode, ngunonggo ene ko endemo mayero sitowi yoweroyimboro ma ingowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ngundiro nangge, ye Lotro bareyimo nguno ingoyi. (Ene Sodom endemo ko doongetetoni nguro Anutdo kowuri inoro ureni kumooyingo.) ");
INSERT INTO rwo_rawa_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ene oni gura enengo keta goweyiga nguro gome sobowoowero nangge ingoro ngu, ene oruweroyi ngu gome dowooro soorengoro oode ngu, asa, kootuyisina naru wengamo, ngu ketaningga ngu oonootewa. Ene oni gura enengo keta oruweroyiga nguro ma ingondudu tero oruwero kini. Ene Anutro koni nguno yetoni oruwaku ngu, asa, ene enengo gaboyi sambo endemo keta gome suwooyi sano oruwa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Yo, no yeno eteno. Ngu suwoongga, nguno Yisas enengo oni simoo bare ko ombuteku naruno, oni eraya yaba gurano werewariku, ene suwoo kewooroko oni gura Anutdo andangero yoro, guranangge yokootoni oruwa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Bare eraya oo manongoyingo kawero yowoorengoro yeworiku, Anutdo gura yoro, gura yokootoni oruwa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Oni simoo eraya kono oruworiku, ene Anutdo ngu simoo erayagaku gura yoro, gura yokootoni kono oruwa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ngundiro etoni ngu, Yisas enengo kirikiri onikundo ngu mandega ngu ingoro sumoo eyingo. Urungga Oo Bidodo Simburi, ngu ooga eteku ngu ndano tunootewa? Eyingo. Ngundiro etoyi, Yisasdo mande gumi eyingo. Oni kumooyingo bingongga oorooteku musiyongga nguno, oni simoo bare ingootenggoku, ngu karakambi bawooro mayero yowuruwoowanggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yisasdo mande adingayi gura enengo kirikiri oni eyingo. Ene naru bidodomo Anutno yemboongero oruweroyi ene sureye ma kini yewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ene ngandiro eyingo. Ende gurano mande wirikoweroyi oni gura oruwo. Ngu oningga mande wirikoweroyiga ngu, ene Anutro ma sosoreyingo, oni simoo barero nguya ma nowoondoyi teyunoote. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Bare wabu gura ngu endemo nguno oruwo. Ngu bare wabuga, ngundo ngu mande wirikoweroyi oninggano nguno suwooyi sano omburo, ngguyinggayi tero eroriyingo. Noro mundi onindo yomburinerowero tetenggo. Ge hoorooweneroya mandene yomosiyo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Ngundiro tetoni, naru pirungga, ene ngu bare wabuga ngu ma hooroowewero eyingo. Kootuyisina, enengo ingondudunimo ingowo. No Anutro ma sosoretenoku, nguro no simoo barero ma ingoro yomburiyerooteno. Ene nga bare wabuga ngando suwooyi sano enengo mande mandeni yomosiyowero, no eririneroro ooroote. Yokowanoku ngu, ene komo ngundiro eririneroro oodoni, surene kini yewa. Ngundiro nguro, no komo ene hooroowero mandeni ero yomosiyowano. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","7","Urungga Oo Simburi ngundo eyingo. Eririterootoni, nguro nangge mande wirikoyingo oni biyomingga, ngundo bare wabuga nguro mandeningga ngu yomosiyoyingo. Asa, Anutdo enengo oni simoo bare sooreyeroro rogo tewoku, nguro mande mandeye yemboongeyega suwooyi sano, naru rogono tetenggokungga, ngu Anutdo nguro nowoondoyi urungga tero, hoorooweyeroro mandeye yomosiyoyunoro oruwa. Ene sodedo hoorooweyerowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","No yeno eteno. Hamoo oorengo, ene sodedo enengo simoo barero kowuriyemo hoorooweyerowa. Ene kootuyisina, ngu Oni Nangoni, ngu omburo, ngu naruno, ene mera ngaro oni simoo bare yeyootoni, ene nowoondoyemo hamoo tero oorootenggo, bine, ngundi kini, bine? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Oni gidaregado enengomboro ingoyingo ngu, ene hamoo oni nenengo oorengo ero ingoro, ene oni gidaregaya ngu, ene ngandiro ingoro etenggo. Oni biyomi, ero ingootenggo. Ngu oni nguro Yisasdo mande adingayi ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Naru gurano, oni eraya yambo ya oowooyi Tembel nguno, yemboongewero oorowuworiyo. Ngu oni erayaga ngu, gura Parisi gura Gabumanro beye yoyingo oni. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ngu Parisi oningga ngu dikaro, enengo newendemonggo, ngandiro yemboongeyingo. O Anut no oni gidarega ngundiro kini, ngundo geno yemboongeteno. No yakaka ma tero ko mande godange ma eteno. No ooreko ooreko buribari se tero ma endeyooteno. No nga beye yoyingo oningga ngandiro nguya kini! ");
INSERT INTO rwo_rawa_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Kowooyingo gurananggemo tambu eraya no oowari roogo tero kundingiyi oorooteno. No oo bidodo yootenoku nguromu wesoowooro kande eraya nguromu guranangge ge gunooteno. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ngundiro yemboongetoni, ene Gabumanro beye yoyingo oninggaku oriroko anduno dikaro, ngunonggo ene sambosina doongetewero oyimo yoro, nguro bagootero yemboongero eyingo. O Anut no weti mbumbuwadodo oni! Ge gengo sumange ayibige ngu yoya wirinero! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yisasdo mande soweyoro gura eyingo. Ngu beye yoyingo oningga ngu, Anutno newende hamoo yero, enengo oowooyi ma okooyingo. Nguro no yeno eteno. Ngu beye yoyingo oningga ngu, Anutdo nguya oni nenengo ero etoni, ene ootoogero, enengo yano oorowuwo. Ngu oni guraga ngu ene kini. Oni gura enengombo bingami ero okootoni, oowooyi urungga teteku ngu, Anutdo oowooyi dowooro woosoodoni omburo, kootu tewa. Oni enengo oowooyi bingami ma eteku ngu, asa, Anutdo oowooyi bingamidodo teyinowa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Oni simoo baredo simooye bobodi yoyoro Yisas tanggeyimo mayetoyi nguro Yisasdo kandeyi tabayemo yero, kumana yunoweroyimboro. Ene kirikiri onindo ngundiro yeyoro sanggiri tero manggaruyeroyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ngundiro tetoyi, ene Yisasdo simooyeku negoyerootoni, tanggeyimo ombutoyi eyingo. Ye komo ingoyi! Yengo nowoondoye bidodo Anutno yetoyi ngu, simooye bobodibo enengo awanamoye nowoondoye yunootenggoku ngundiro. Anut Oo Bidodo Simburi Simbunani, ngundo simoo bare enengo sobowooteku, ngundiro oni nguromu. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","No yeno hamoo oorengo eteno. Oni ene Anutro newendemo hamoo oorengo ngu ma oorooteku ngu, simooye bobodibo awanamoyemboro nowoondoyemo hamoo tetenggoku ngundiro ma tero ngu, asa, ngu oningga ngu, ene Anut Oo Bidodo Simburi Simbunani, ngundo oni simoo bare sobowooteku nguno ma uwa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Naru gurano, sitowinidodo oni tabango gurado omburo, Yisas sumoo inoro eyingo. Oo etuyeroyingo oni gome, no ndawu oo gura gomengga tero ngu, no keta suwooyi sano sugi sugi oruwano? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ngundiro etoni, Yisasdo mande gumi ngandiro eyingo. Ge ndadiro nguro, noya oni gome, ero ete? Anut nangge, ene oni gome. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ge mamana mande ngu, ge kuri kandangero ingoote. Ge buribari ooreko ooreko barese muringga ngu ma tewero, oni ma ureyi kumoowero, oo yakaka ma tewero, oni dobooge goweyi sanggawero mande kootuyisina ma ewero, awanangge tanggeyemo torige kabengo ootoo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Etoni, ngu tabango oningga ngundo mande gumi eyingo. Ngu mamana mande ngu bidodo no kuri simooyemonggo keyoro yade omburo ataga nga. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yisasdo ngu mande ngu ingoro eyingo. Ge oo guranangge ngu ge kuri ma teyingo. Ngu gengo oo ngu bidodo oni songomo uriyoya beye yo. Nguro beyeni ngu bayeteya, angoyi oni ngu yuno. Ge ngundiro tero ngu, asa, gengo oo gome sambo endemo oruwa. Ngundiya teya, ge ombuya, no keneroya endeyo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ngundiro etoni, ngu tabango oningga, ngu mandega ngu ingoro, newende kowuri oorengo ingoyingo. Ndadiro nguro, enengo sitowini beyeni urungga nguro ingoro. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yisasdo ngu oni tabangongga nguro newendemonggo ingooteku ngu, enengo beye sitowini nguro biyomi ingowoku ngu, kenoro eyingo. Oni sitowiye urunggadodo ngu, ene nowoondoye bidodo Anutdo hoorooweyerootenggoku, nguno uweroyi kowuri urungga. Oni beye sitowiyedodo ngu, ene nowoondoye bidodo enengo beye sitowiye, ngundo hoorooweyerowa ero nowoondoye bidodo nguno yetenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Nguro ngu, bo urungga ngu nggusi newendekuri uweroyi ngu kowuri. Ene beye sitowidodo oni ngu, newende bidodo beye sitowinimo yero oorooteku ngu, ngu oningga ngu, ene Anut Oo Bidodo Simburi Simbunani, ngundo simoo bare sobowooro oorooteku, nguno uweroyi ngu kowuri oorengo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ngundiro etoni, oni simoo baredo ngu mandega ngu ingoro eyingo. Ngundiroga ngu, onendo ene mete suwooyi sano keta oruweroyiga ngu yowa? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yisasdo enengo ingonduduni ingoro, mande gumi eyingo. Oo onindo ma teweroyi ngu, Anutdo ngu oo ngu ene mete temukowa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ngundiro etoni, Pitando eyingo. Noore noorengo ende oo sitowinani ngu bidodo yokomukoro, noore mayero ge kenggeroro endeyooteto. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Ngundiro etoni, Yisasdo mande gumi eyingo. Hamoo oorengo no yeno eteno! Oni bidodo Anutro mandeni koyi teweroyi ngaro ingoro, nguro ene enengo ende, ya, bareyi, simoongo, konebeyi, eweyi, nemi, ngu yoyokoro mayetenggo. Ngu oo yokowonggoku, ngu Anutdo wendangero oo urungga oorengo ataga yunoro, ko kootuyisina naruno nguya yunootoni, ene nguno suwooyi sano keta oruweroyimu, ngu yowanggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yisasdo enengo kirikiri oni kande eraya kegidemboro eraya yoyoro, songo oororo ero eyingo. Ingoyi, noore Yerusalem oorewato. Anutro ingondudu eyingo onindo, Oni Nangoni, nguro mande ero nakangoyingo ngu bidodo engge yeni tunootewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ene yoro oni sowe gidarega Yuda oni kini ngu kandeyemo yero yunootoyi, ngundo kootuyisina, mandeni biyomi ero utoro, yomooyinoro, mukendoro, gisaruboro utoro, ureyi kumoowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ene naru kabusagomo, ene merenonggo ko ootoogewa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ngundiro etoni, enengo kirikiri onikundo ngu mandega nguro muri nowoondoyemo ma himi yetoni ingoyingo. Kirikiri onindo ngu mandega Yisasdo eteku, nguro ingondudu gome ma teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yisasdo ene Yeriko ende namoko mayeyingo. Oni doongeyi kiringongga oore dabemimo ootooro, ngunonggo ene oni simoo bareno beye ooro ngguyinggayi tero, kira ero oruwo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ngu oni doongeyi kiringongga, ngundo ingoworomu ngu, oni simoo bare oowooyingga oorengo mayetoyi, ngguye ingoro, nguro ene oni sumoo yunoro eyingo. Ngu oni ngu ndawu ooga tetenggo? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ngundiro sumoo etoni oni songokundo, ngu oni doongeyi kiringonggakuno eyingo. Nasaret oni Yisasga ngundo mayete. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Nguro ngu, oni doongeyi kiringonggaku ngundiro ingoro, ene meno ero eyingo. Yisas Dewitro osiyi, ge noro nowoondoyi tenuno! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Oni koretewonggokundo manggaruwooro eyingo. Ge nenete! Etoyi, ene ngu ma ingoro ingoro, ene meno urungga ero eyingo. Yisas Dewitro osiyi, ge noro nowoondoyi tenuno! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","41","Ngundiro meno etoni, Yisas ingoro, omburo dikaro eyingo. Ngu oningga ngu yoya, no tanggenemo ngano ombuyi! Etoni, oninggaku yoro Yisas tanggeyimo ombutoyi, Yisasdo sumoo inoro eyingo. Nondo ndawu ooga tenggunowero ingoote? Ero sumoo etoni, ngu oni doongeyi biyomingga, ngundo mandeni gumi eyingo. Urungga Oo Bidodo Simburi Simbune, no doongetero, mera oo kenowero ingooteno. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Etoni, Yisasdo eyingo. Doongeteya keno! Gengo nowoondogemo hamoo teyingongga, ngundo yomosinggerootoni, ge ko mete tete. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Yisasdo ngundiro etoni ngu, oni doongeyinggaku sodedomangge metemi tero doongeteyingo. Ene doongetero mera kenoro, Yisas keyoro endeyoro, ene Anutro bingami urungga oorengo ero okooyingo. Oni simoo bare ngundiro kenoro ngu, ene nguya Anut oowooyi bingami ero okooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yisas oororo, Yeriko ende newendemo uro, oorowuwero teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Yeriko nguno oni gura oruwoku, ngu oowooyi Sakiyas. Ene ngu Gabumanro beye yoyingo oningga nguro tabango, ene digi beye sitowinidodo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ene Yisas kenoro ingoweroyimboro Yisas ngu onendo ero, nguro kenowero hahangero oruwo. Ene oni simoo bare urunggado doobengootoyi, nguro ene ma kenoweroyi teyingo. Ene oni ootuwoo oorengo tondongo nguro ene Yisas kenoweroyi kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Sakiyas ingoyingo. Yisas ngu, ene ngu oorega ngu keyoro ombuwa, ero ingoyingo. Nguro ene koretero kendutero oororo, de oorero ngunonggo gome kenowero, ero teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yisasdo ngu oorega, ngu keyoro yade omburo, Sakiyasdo oruwoku degaku damonimo omburo, randoro de sanganimo doongetero, kenoro eyingo. Sakiyas ge sodedo merako ombu! Ataga no komo gengo yano geya oruwaro. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakiyas ngundiro ingoro, ene sodedomangge somooruruwooro merako omburo, ene newendemonggo oni oni tero, nguro Yisas yoro, enengo yano oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Oni bidodo ngundiro kenoro, sanggiri tero boguwooro eyingo. Yisas kenoyi! Ene weti mbumbuwadodo oni Sakiyas nguro yano uro, nguya oorooteriku eke! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sakiyas ene Yisas kenoro, enengo weti mbumbuwa tewoku, nguro ingoro, newendemo hamoo tetoni yowoorengoyingo. Nguro Sakiyas ootoogero dikaro, Urungga Oo Bidodo Simburi Yisasno eyingo. Oo Bidodo Simburi Urungga, ge ingootooga, no nenengo oo bidodo kewooro oorengo wesoowooro, gumi gura ngu angoyi oni bayetero yunowano. Ene nondo oni gidaregaro beye oo kingo ganayeroro yowonoku ngu, nobana gumi ataga tambu namoraya namoraya yunowano. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yisasdo ngu ingoro, mandeni gumi eyingo. Ataga Anutdo nga yano oni simoo bare nga yoyoote. Ndadiro nguro, nga oningga nga, ngu Ebarahamro osiyi gura. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","No Oniro Nangoni, nondo oni oonootero oorootenggoku ngu ereweyeroro ko yoyowero ombuwono. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Yisas Yerusalem ende namoko mayetoni, nguro oni simoo bare ngandiro ingoyingo. Ataga, Yisas Yerusalem oorero utoni ngu, Anut enengombo sobowooweroyi naruwo ataga tunootewa, ero ingootenggo. Nguro oni simoo bare enengo mande ingootoyi, Yisas mande adingayi gura eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ene ngandiro eyingo. Naru gurano, oni urungga ene oriroko ende gurano toongewero, nguno ene oowooyi urungga oo bidodo sobosobo koreteyingo oowooyi ngu etoyi, ene ko mayewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ngu oningga, ngundo enengo ko oni kande eraya negoyerootoni ombutoyi, beye 20 Kina ko oni guranangge nangge yunoro eyingo. Ye nga beye ngando ko teya nguro gumi yoya soweyoya yeyadoyiga, no ko yowoorengoro mayero yeyowano. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Enengo ende gobooro onikundo oo sobosobo tewero toongewoku, nguro ene ngu oningga ngu yokoyingo. Ngundiro nguro, ene enengo oni gidarega sureyerootoyi, keyoro, saro eyingo. Nga oningga ngando oni urungga tero noorengo sobosobo koreteyingo oodoni, ngu ma ingowato. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ene ma ingoro, nguro ene oo bidodo sobosobo koreteyingo orini, ero rogo tewonggo. Oni urunggado mande ngundiro ingoro, arisa, yade yade enengo merako ko mayeyingo. Oni nondo kuri beye yunowonomu, ngu negoyerootoyi, mayetoyi eyingo. Nondo kuri beye yunowonoku ngu koyi tero, nguro gumi ndadiro yowonggoku, ngu etoyiga, ingoowe eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Nga, koreteroga ngundo mayero eyingo. Urungga, gedo kuri beye doobe eraya (20 Kina) nunootoyi, ngundo ko teroodoowe, nguro gumi yowonoku ngu, onibiga (200 Kina) tunootewo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ngundiro etoni, ngu oni urungga ngundo ingoro, gumi eyingo. Ge ko oni gome! Ge ko gome yanggango tewo! Ge oo bodaga ngu gome sobowooro koyi tewo. Ngundiro nguro, no ge goyewe oni urungga tero, ende kande eraya nguro sobosobo oruwa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Arisa, Ko oni erayayiga ngundo omburo eyingo. Urungga, kuri gengo beye doobe eraya (20 Kina) nunoyingoku, no ngundo ko tero, gumi yoro yeroodoowe, doobe kande eraga (100 Kina) tunootewo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ngundiro etoni, asa, oni urunggakundo gumi eyingo. Gome oorengo! No ge goyewe oni urungga tero, ende kandegura nguro sobosobo oruwa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","Asa, ko oni kootungga ngundo omburo eyingo. Urungga, ge kuri doobe eraya (20 Kina) nunoyingomu ngu nga. No nga yoro, oororo, torige towimbo doobemooro oongootoowe oorooteku nga! Ndadiro nguro, no ge geyootenoku ngu, ge oni sanggiri nguro, oni gurado oo yetoni ngu, gedo ngu ooga ngu yoote. Oowari oni gurado miteku ngu, gedo oo ngu sero engge yoote. Ngundiro nguro, no gengo sosorero nguro yetoowe ooroote. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","23","Ngu oni urungga oo bidodo sobosoboga, ngundo sanggiri urungga tero eyingo. Ge ko oni biyomi oorengo! Gengo mandege, ngundo goyeni, ge mandedodo tete. Ge ingooteku ngu, no oni sanggiri oo oni songombo yetenggoku ngu no yooteno. Oni songombo oowari mitenggoku ngu, nondo ngu sero yooteno, ero ete? Ndawugaro ge noro beyega nga, oni beye yowooraringoweroyi oni yunootoyi, ngundo ko tetoyi, no omburo, nenengo beye nga gumi yoro, nguro duwoo nguya gura yoweroyi? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ngu oni urungga ngundo oni tanggeyimo dikayingokuya eyingo. Ye ngu beye doobe eraya (20 Kina) ngu sobiyoya, oni beye onibiga (200 Kina) ngu inoyi! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ngundiro etoni, ngu onikundo, oni urunggakuno eyingo. Urungga, nga oningga nga, ngu ene onibiga (200 Kina) kuri yowo! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Oni ene ingondudu gidarega Anut Oo Bidodo Simburi Simbunani, ngundo simoo bare enengo sobowooteku, nguro muriye sowoongga watayi, asa, Anutdo ngu enengo ingondudu ngu soweyoro urungga inowa. Asa, ene oni gura ngundiro ingondudu bodaga ngu oodoni nguro ma koyi tero ngu, asa Anutdo enengo ingoyingo bodagaga ngu bidodo yoro yokowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ene noro mundi oni, ngundo no enengo sobosobo ma oruwero ewonggoku, ngu oni ngu yoyoya, ngano ombuya, nenengo doongenemo yureyiga kumooyi. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yisasdo ngu mande ngu ero yokoro, ene ootoogero koretero ene Yerusalem oorowutenggoku oorega ngu keyoro oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Yisas yade yade oororo Betipas ko Betani ende erayaga ngu namoko mera puri oowooyi Olib ngu damonimo mayero, ngunonggo enengo kirikiri oni eraya sureyerootoni, koretero oorowuworiyo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Yisasdo kirikiri oni erayaga nguya ero eyingo. Yari andu endegano anduno ooroya, uya Hos gura oowooyi Donggi duriyo gura gosiyootoyi oorooteku ngu, gurado kuri ngu sanganimo ma bibiteyingongga ngu kenoya, yoya omburi. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ngu Donggiga nguro kimbonayi wesiyootoriga, oni gurado ewaku ngu, yari ndawugaro ngu wesiyoro yowero, eya etoningga ngu, yari ngandiya eri. Urungga Oo Bidodo Simburi, ngundo ko tewero ngundiya eya yoya omburi. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Asa, kirikiri oni erayagaku mande ngundiro ingoro oororo, oo bidodo Yisasdo ewoku, ngundiro nangge kenoworiyo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Kirikiri oni erayagaku, ene Donggi duriyo kimbonayinggaku wesiyowootori, nguro simbukuriyibo yeyoro, sumoo eyingo. Yari ndawugaro ngu Donggi nangoningga ngu wesiyooteri? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Kirikiri oni erayagakundo gumi eworiyo. Urungga Oo Bidodo Simburi, ngundo ko tewero ewokuro eworiyo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Arisa, kirikiri oni erayagaku Donggi nangoni duriyogaku yoro Yisasno ombuworiyo. Ngundiro tero, yoro omburo, enengo towikumba ngu Donggi duriyogaku sanganimo yomiyingo. Ngundiro yomitoyi, Yisasdo ngu sanganimo bibiteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yisasdo Donggi sanganimo bibitero oorowutoni, asa, simoo baredo enengo nengguro andangero oorekanare yomitoyi, Donggi ngu sanganiwoore oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Yisas yade omburo, Olib puriwoore ooregaku yokoro uyingo. Ngundiro utoni, asa, Yisas enengo kirikiri onikuya oni songo urungga nganoku nguya, ene Yisasdo bibitero utoni, kenoro, ene oo bidodo onindo ma teweroyimu ngu tetoni kenoyingoku, nguro ingondudu tero, nguro ene damoni yero, Anut bingami ero okooro, oni oni teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ngundiro tero, ene meno moguru tero eyingo. Noore enengo bingami ero okoowato! Anutdo kumana nga oni sobosobo koreteyingongga nga inootoni, ene Oo Bidodo Simburi Urungga, ngu oowooyimo ombuteku ngu! Oni bidodo Sambo endemo oorootenggoku nguya, ene komo Anut urungga awuno oorengo oorooteku, nguro oni oni teya, bingamini duridarinidodo teyingo! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Yisasro kirikiri onindo ari moguru tetoyi, Parisi onindo kewooroyemo ootooro, ngunonggo ngundiro yeyoro Yisasno eyingo. Oo etuyeroyingo oni, gengo kirikiri oni kenggemo oni nga manggaruyeroya etooga, ari moguru nga yokoyi! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ngundiro etoyi, ene Yisasdo gumi ero eyingo. No yeno hamoo eteno! Ene manggoye gosiyoro nenetetoyi ngu, arisa, digi merako nga enengombo ero moguruwoowanggo! Nondo nga oni nga manggoye ma gosiyerowano. Ene komo Anut oowooyi ero okoowanggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","42","Yisas ende namoko tunootero, ene Yerusalem ende kenondadangero, oni simoo barero sendoro eyingo. Ye Yerusalem oni simoo bare gowugowurongo! Nondo ombuwonomu ngu, ye nowoondoye imakeyingo muri ngu, ye Anutya gobooro yeyi etoowe, ene ye nguro ma ingondudu tetenggo. Ene ye yokootoyi, nguro Anutdo oo doongeyemo oongooyunootoni, ye ma kenowonggo. Ene ataga ngu naruni kini teteku nga! ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ye ingoyi! Kootuyisina, naru gura tunootewaku nguno, yengo mundi oni ngu omburo, ebe urewero pawayeroro, mere sero woodoo yero, ende newendemo uro ye bidodo pawayeroro yutomukowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ngundiro tero, ene ye yengo simoo namboye nguya yomburiyeroro yoyokowanggoku ngu, ngu nguya kowuri koorowooro oruwanggo. Ene yengo digi gura yokootoyi, digi dobooyi sanganimo ma oruwa. Ndadiro nguro, ye Anutdo naru ngano omburo yoyoro hoorooweyeroweroyi ngu ma ingowonggoku nguro. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ngu naruno, Yisasdo yambo ya oowooyi Tembel ngu newendemo uro, simoo bare yeyondandangetoni, oo uriyoro yoro, oororo omburo tetoyi, ngu oweyerootoni, oorero sayingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Yisasdo ero eyingo. Anutro mandeno ngandiro nakangoyingo. Noro ya ngu yemboongeweroyi ya nangge oruwa! Eyingo. Ngundiromu, ene yendo ngu yeyi yakaka oniro kombiteyingo digi wondokoyi ngundiro tete. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yisasdo naru bidodomo, Tembel yano mande muri gomemu ero etuyeroro oruwo. Ene Anutno wooro yeyingo oni nguro sobosobo mamana mande etuyeroyingo oni, ko Yuda simoo barero tabango oni, ngundo ureyi kumooweroyimboro oore ereweyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ene oni simoo bare bidodo Yisasro mandeni ingoweroyimboro yanggango yetoyi, nguro ene teweroyi kini. Ngundiro nguro, tabango oni ene Yisas ureyi kumooweroyi oore gura ma kenoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","2","Naru gurano, Yisas Tembelno muri gome etuyeroro, mande mesarango ngu simoo bareno wesiyoro ero oodoni, nguno Anutno wooro yeyingo oni, nguro sobosobo, mamana mande etuyeroyingo oni, ko Yuda simoo barero tabango oni, ngundo Yisasno omburo eyingo. Ge nooreno e. Ge ndawu sunggiga geno oodoni, ge ngunonggo ngu kongga ngu tete? Onendo sunggi ge gunowo? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","4","Yisas enebana mandeye gumi eyingo. No nguya no mande guraro ye sumoo yunowero, ye nono eyi. Yondo sonoyeroyingongga ngu sambo endeboromu, ngundi merako oniromu nangge, bine? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","6","Arisa, enengo nangge mande ero ingoro eyingo. Sambo endeboromu ewatoku ngu, enendo nooreya ewa. Ndadiro nguro, ye nowoondoyemo hamoo kini, ero ewa. Noore ngandiro ewatoku ngu, oo merako oni simoo barero ewatoku ngu, asa, simoo baredo sanggiri tero, digi yoro, ngundo noore yureyi kumoowato. Ene Yonro ngu nowoondoyemonggo ngandiro hamoo ingootenggoku ngu, Yon ngu Anutro ingondudu eyingo oni gura. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ngundiro nguro, ene Yisasno mandeni gumi eyingo. Noore ma ingooteto. Ngu sono gimuyunoyingo mandega ngu Yondo, ndanonggo yoro mayewo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ngundiro etoyi, Yisasdo ngu oni tabango nguya gumi eyingo. Ngundiro nangge, no ndawu sunggigano ko tetenoku, ngu yeno ma ewano. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Asa, Yisasdo ootoogero, ene nga mande adingayingga nga simoo bareno eyingo. Naru gurano, oni gurado Wayin kongga tero miyingo. Ene ngu Wayin kongga ngu, ene oni gidaregado sobowooya beye koyi teyi ero eyingo. Ngundiro tero, ko simburi ngu (Anutdo) ene toongero, ende orirokono naru pirungga nguno oruwo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Wayin engge yoweroyi naruwomo, ko simburigakundo ko oni gura sureyootoni, enengo Wayin kono ko oni ko tewootoyi nguno oorowuyingo. Ko nguro oo engge gura inootoyiga, yoya ombuni, ero sureyoyingo. Ene kono ko onikundo ngu oninggaku dowooro utoro sureyootoyi, kingo kande enengo oni urunggaku tanggeyimo oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ngundiro tetoyi, ko simburigakundo ko oni gura sureyootoni oorowuyingo. Kono onikundo ngunggaku nguya dowooro utoro yokoro sureyootoyi, kingo kande enengo oni urunggakuno oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Oni urunggakundo enengo ko oni tambu kabusayiga ngu soweyootoni oorowuyingo. Kono onikundo ngu ko oningga nguya utoro okooro kanggaroko oorongootoyi uyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ngundiro tetoyi ngu, ko simburi ngundo ingondudu tero eyingo. No ndadiro tewano? No nenengo nangone guranangge (Yisas) no nguro gome ingootenoku nga sureyootoowe oorowuwa. Ene nenengo nangone kenoro ene sosorero, enengo manggowo ingowanggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ngundiro soweyootoni, omburo, ene oni kono ko tero oruwonggoku, ngundo doongetero, ko simburiboro nangoni kenootoyi ombutoni, enengo nangge mande ero eyingo. Ngu oningga ngundo ngu kootuyisina eweyimbo oo ngu bidodo enendo yomukowa. Ngundiro nguro, noore ataga ene ureye kumoowa. Ngundiro tero ngu, asa, nga kongga nga, ngu oode noorengo yowato. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ngundiro ero, sobowootoyi ombutoni, dowooro okooro, kanggaroko oorongooyi utoni, owero uro nguno utoro, ureyi kumooyingo. Arisa, Wayin kongga ngu simburibo ngu oniku ndadiro teyunowa? ");
INSERT INTO rwo_rawa_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Wayin ko simburi, ngundo ngu ko oniku bidodo yureni kumoomukootoyi, ngu Wayin kongga ngu oni songo gidarega yunowa. Ngundiro etoni, ngu oniku ngu mandega ngu ingoro gumi eyingo. Enengo ko sobosobo oni ngundo ngundiro muri ngu ma tewanggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yisasdo yeyondandangero eyingo. Ngu mandega Anutro mandeno oorooteku, nguro muri ngu ndadiro? Nga Anutro mande nakangoyingo ngano oorooteku ngu hamoo bine, asa, mande adingayi nguno ko oni biyomi enengo nangoni ureyi kumooyingo ngu nguya hamoo. Nga ya nomonimboro u nongginingga ko onindo andangero yokowonggo. Ngungga ngu ya nomonimboro u nonggini koreteyingo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Oni bidodo songo songo Krayis Yisas kootu inoro ngu, ene ngundiro tero, ene ya nomonimboro u nongginingga, ngu sanganimo sorero, ene biyomi yewa. Ko biyomi tetoni, nguro ngu Krayis ko uriyi gumi biyomi teyunowa. Ngundiro nangge, ya nomonimboro u nonggini koreteyingo, ngundo ngu oningga ngu sanganimo sorero utoro yomburiyootoni, sosorango oorengo yewa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Mamana mande etuyeroyingo oni, ko Anutno wooro yeyingo oniro sobosoboku, ngundo ngu ingowonggoku, ngu mande adingayingga nguno ko oni oo biyomi tewonggoku ngu, Yisasdo ene yosanggawero ete. Ngundiro nguro, ngu narungga nguno nangge dowooro ureyi kumoowero terogo, ene oni simoo barero sosorero, nguro yokoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Mamana mande etuyeroyingo oni, ko Anutro wooro yeyingo oniro sobosobo, ngundo Yisas ureyi kumoowero oore erewero, nguro ene oni gidarega sureyerootoyi, omburo Yisas kenondadangero sobowooyingo. Ngu oni ngu enengo muriye biyomi ngu oongooro, ene oni gome nenengo eya eyi, ero godange teyingo. Ene Yisasdo mande biyomingga etoningga, nguro dowooro, Gabuman mande wirikoyunoyingo onino yeweroyimboro ngundiro teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ngu onikundo Yisas sumoo inoro eyingo. Oo etuyeroyingo oni, noore ingootetoku ngu, gengo mandege ngu gome nenengo oorengo. Ge Anutro mande gome nenengo nangge oni simoo bare bidodomo etuyeroote. Ge oni goweye nangge ma kenoro ingoote. Kini, ge oni nowoondoye wirikoyeroro kenoote. Nguno noore ingootetoku ngu, gedo Anutro mande hamoomu nangge nenengo etuyeroote. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ge ndadiro ingoote? Noore Gabuman oni (Takis) beye inoweroyi ngu mete inowato, ngundi Anutno beye yewato, bine? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","24","Ngundiro etoyi, ene Yisasdo enengo mande godange etenggoku, ngundiro ingoote. Nga oni ngando, ene no towootowoonerowero etenggo. Nondo guraro etoowe ngu, asa, enendo nosina mande sanggawero ewanggo. Ene ngundiro ingoro yokoro, enebana eyingo. Beye gura no etunerootoyiga kenoowe. Ngu Gabuman tabango gabogaboyi, ko oowooyi nguno oorootekungga ngu, oone oowooyi nakangootoyi ooroote? Etoni, ngu enendo gumi eyingo. Ngu Gabumanromu. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Etoyi, Yisasdo eyingo. Arisa, Gabumanro oo ngu Gabuman inoyi. Anutro oo ngu, Anut inoyi. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ngundiro etoni, ene Yisas sodedo simoo bare doongeyemo dowooweroyi nguya kini. Ene bidodo Yisasro mandeni nguro ingondudu urungga tero, ingoyingomu ngu nenengo, nguro ene mandeni gumi gura ma eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadusi oni ngundo oni kumooro ngu, ene ko ma ootoogewa, ero nowoondoyemo hamoo ingootenggo. Naru gurano, Sadusi oni gidaregado omburo Yisasno ngandiro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Oo etuyeroyingo oni, Mosesndo mande gura ngandiro nakangoyingo. Oni bare yoro oode, ene simoongo kinimo kumootoni ngu, ene kootuyisina, koneyombo ngu barega ngu yoro, bareyi tero oruwa. Oode, nangoni tero, banemboro nangoni, ero ewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Arisa, oni simoonggoro gura ngu kandegura gidemboro eraya oruwonggo. Koretero bayega, ngundo bare yoro, simoongo kini oode kumoowo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Arisa, erayayiga ngundo ngu barega ngu yoro oode, ene nguya kumoowo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Kootuyisina, ngu koneyari kabusayiga oode ngu barega ngu yowo. Ngundiro nangge, ngu oni simoonggoro kandegura gidemboroga ngu bare guranangge ngu yoro simooye kini, kingo yoro, oode kumoomukoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kootuyisina, ngu barega nguya simoongo kini kingo kumooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Arisa, oni kumoononggo ko ootoogeyingo naruno ngu, barega ngu kameyi oorengo ngu oone? Kuri ngu oni simoonggoroga ngu bareye guranangge nguro. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ngundiro etoyi, Yisasdo mande gumi eyingo. Nga naruno ngano, ngu oni bare yoro, kameyi bareyi teweroyi murini ngu tetenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ene oni bidodo Anutno nowoondoye hamoo teyingongga ngu, naru wengamo, ene ko keta ootoogero sambo endemo oruwanggo. Ngu naruno ngu, ene ko ma ebe yoyootero erambarisa ma tewari. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Kini, naru gurano, ko ma kumoowanggo. Nguno, ene Anutro Engel oni ngundiro tero oruwanggo. Ene Anutro simoongo tero oruwanggo. Ngundiro nguro, Anutdo merenonggo yokutuyerootoni ko ootoogewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mosesndo nguya oni kumoononggo ko yokutuyerowa, ero etuyeroyingo. Kurimi, Anutdo de bodagano de soru tunootero ngunonggo Mosesno ngandiro eyingo. Ataga nga naruno ngano, no ngu gengo osi osingge Ebaraham Ayisak ko Yekob ngu Simbuye Anut ero eyingo. Anutdo Mosesya mande eyingo. Osi osingge kuri kumooyingomu, enengo gaboye ngu ataga sambono keta oorootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Anutga ngu oni kumooyingo nguro Anut kini. Kini, oni simoo bare Anutro nowoondoyemo hamoo tero kumoowanggoku ngu, nguro gaboye keta sugi sugi Yisasya oruwanggo. Anut doongeyimo ngu oni nowoondoyemo hamoo teyingomu, ngu ataga keta oorootenggoku, ko kuri kumooyingomu nguro gaboye keta oorootenggoku nguro Anut nguya. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Yisasdo ngundiro etoni, asa, mamana mandero oni gidaregado mandeni gumi eyingo. Oo etuyeroyingo oni, ge hamoo nenengo mande enggemo ero ete. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Nguro ene sosorero, Yisas ko ma sumoo inoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yisasdo eyingo. Onindo noya ngandiro etenggo? Krayis ngu Dewitro osiyi nangge, ero etenggo? ");
INSERT INTO rwo_rawa_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Ene ngundiro ero nguro Anutro yambo bukno ngu Dewitdo enengombo Krayisya eyingo. Anut Oo Bidodo Simburi Simbunani, ngundo noro Simbune urungga ngandiro eyingo. Ge kandene koondosina bibite. Kootuyisina, gengo mundi oni yoyewe gengo kengge damonimo wata yenggunowano. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dewit enengombo ngu ewo. Oo Bidodo Simburi Simbunani Urungga. Eyingo. Ndadiro nguro, enengo osiyi tewa? Eyingo. Dewitdo ngu ko uriyoro yoyoweroyi oni tunooteweroyiga, Krayis nguro ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ngu naruno, oni simoo bare bidodo oode, Yisasro mandeni ingootoyi, Yisasdo enengo kirikiri onino, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Ye mamana mande etuyeroyingo oni nguro ingonda teyi! Ene towikumba piru piru yemuro endeyowero gome ingootenggo. Ene yowuru musiyomo simoo baredo bingamiye ero okooweroyi, nguro gome ingootenggo. Ene yambo yano oni doongeyemo, amuno koretero bibitewero gome ingootenggo. Ene oo simbo urungga kayingo naruno, yaba koreteyingo nguno bibitewero nguya gome ingootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Oni doongeyemo ngu oni nenengo gome, ene nowoondoyemo ngu Anutro ma ingootenggo. Nguro, ene bare wabu ngu ganaganayeroro yemboongeyingo piru piru tetoyi, Anutdo bare wabu ngu hoorooweyeroni, ero tetenggo. Ene torige kombi tero, nguno bare wabu nguro ya, oo sitowi bidodo ganaganayeroro, gasiyoro yoyunootenggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yisas doongetero yeyootoni, oni beye sitowiyedodoku Anutro yambo yano (Tembel) Pawusno beye urungga kingo duwoo yetoyi yeyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ene bare wabu angoyingga nguya kenoyingo. Ngundo enengo beye bobodi erayagaku ene eraya eraya yoro, oororo Pawusno yeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Nguro Yisasdo kenoro ingoro eyingo. Hamoo oorengo no yeno eteno! Nga bare wabuga, ngando oni pawusno beye urungga yetenggoku, ngu dagayeroro, enendo urungga oorengo yete. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ndadiro nguro, oni nga bidodo ene beye urungga enengo yano ooroote. Ene ngunonggo gidarega andangero, yoro omburo, Anutro koni nguro yetenggo. Ene nga bare wabuga nga, ngu ene hamoo ooni kinimu. Ngundo enengo beyeku ngu bidodo yoro omburo yete. Ene oowari uriyoro neweroyi gura kini. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","6","Yisasro kirikiri oni gidaregado yambo ya oowooyi Tembel nguro mande eyingo. Nga Tembelga nga, ngu onindo kuri digi oo gome wadori yero oo ngu kingo sumangeno Anutno yetoyi, ngundo ngu Tembel ya irosarani teyino. Etoyi, Yisasdo ingoro gumi eyingo. Ngu oo ngu ataga kenootenggoku ngu, naru gura tunootetoni, digi gura yokootoyi, digi gura sanganimo ma oruwa. Onindo ngu bidodo usosowooro, dorowooyi merako uwanggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ene Yisas sumoo inoro eyingo. Oo etuyeroyingo oni, ngu ooga ngu ndadiboro tunootewa? Nguro naruwo namoko tetoni, noore ndawu sunggiga kenoro, noore nguno ingowato. Narunggaku namoko tete, ero ingowato? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ngundiro etoyi, Yisasdo mande gumi eyingo. Ye komo ingonda teya oodoyi, oni songombo ye ma ganayerowanggo. Kootuyisina, no oowoonemo, oni oowooyingga oorengo mayero, ye ganayeroro ewanggo. No nga Anutdo noore yoyowero sunggi yeyingo oningga nga nangge, Krayis gura kini. Ngu hamoo! Naru namoko tete, ero ewanggo. Ye ngundiro ingoro ngu, ye oororo, ngu ma keyoro oorowuwero. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kootuyisina, me ebe urungga teweroyi mande binga ye ingowanggo. Oni rongge ebe nguya tero, nowoondoye songo songo yero, buribari oodoyi, ye ngu ingowanggo. Ye nguro ma sosorewero. Oo ngundiro ngu bidodo koretero ombumukoro yokowa. Naru wenga, ngu narunggano, nguno sodedo ma tunootewa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Asa, ngu naruno, Yisasdo ngu mande ngu soweyoro eyingo. Oni sowe gurado ootoogero, oni sowe gidaregaya ebe rongge sambi tero, ebe urewanggo. Merako ngaro sobosobo oni guraro keyimo onindo ootoogero, sobosobo guraro keyimo oniya ebe kendukendu tero, ebe urewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Imimi ururumu nangge mera nga dowooro yokutuwoowa. Mera ngano, oowariro kumooyingo urungga oorengo tunootewa. Sayi ko oo biyomi ururu mera gurano gurano nguya tunootewa. Sambono oo sosoreweroyi sunggi guradiro guradiro nguya tunootetoni kenowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ene oo ngu ma tunooteyingomo nguno ye noro nowoondoyemo hamoo tetenggoku nguro, onindo ye yodowooro, ye kowuri gura gura yunowanggo. Ene ye yoyoro, yowuru yano mande wirikoyingo onino yoyewanggo. Wirikoweroyi musiyomo, yoyoro, ya biyomimo yoyewanggo. Mera ngaro oo sobosobo onino ko Gabuman onino nguya yoyoro oorowutoyi, ngundo yengo mandeye nguya wirikoyunowanggo. Ngu oo ngu bidodo no oowoonemboro ye teyunowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ngundiro teyunootenggoku oni nguno, ngu ye Anutro mande keta mesarango ngu eweroyimboro ooreyi yetenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mande nga nowoondoyemo nakangootoyiga nguno orini. Yeno ngundiro muri ngu ombuwero tetoningga ngu, ye nowoondoye buribari ma ingondudu tero ewero, noore ndadiro ewato, ero ma ingowero. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ndawugaro nguro, no nenengombo manggoye yewe tango yetoni, mandeye ingonduduye nguya yewe himi yetoni, ingondudu gomemu ye yunowano. Yengo mundi oni, ngundo yengo mandeye ngu ma utoro, oorongooro yokowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ngundiro nangge, ene noro nowoondoyemo hamoo tetenggoku ngu, kootuyisina, yengo awanamoye, konebaye, yengo sowisawiye, dobookuriye, ngu bidodobo ye yoyoro, mundi onino yoyetoyi, onindo ye gidarega yureyi kumoowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Oni gura gurado yeya nowoondoye biyomi oorengo yewanggo. Ndadiro nguro, no oowoone ngu yeno oorooteku nguro. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ene yengo tabayemo uye guranangge nguya ma oonootewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ye yanggango ootooro ngu, yengo keta suwooyi sano sugi sugi oruweroyiga ngu yowanggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Yisasdo mande gura eyingo. Ye Yerusalem kenootoyi, me oni mayero, ngundo pawangoro wooriringootoyiga ngu, ye nguno ingoyi. Yerusalem ende yomburiyoweroyi naruwo namoko tete, eya ingoyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Asa, ngu narungga nguno, oni Yudiyano oorootenggoku ngu, ene sodedo saya, mera pupurimo kombiteyi. Oni Yerusalem endemo oorootenggoku ngu, ene mera songomo sayi. Oni Yerusalem dabemimo diguno oorootenggoku ngu, ende newendemo ma uwero. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ngu narungga ngu, Anutdo weti mbumbuwa gumi yunoweroyi naruwo. Ngundiro nguro, mande bidodo Anutro mandeno oorooteku ngu, engge yeni tunootewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ngu narungga nguno, bare kawuyedodo, ko bare simooye owita nono netenggoku, ngu naruno, oni oniyooge! Kowuri urungga oorengo nga meranggano ngano tunootewa. Anutro sanggirini nga oni simoo bareno ngano omburo kutuwooyunowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Me onindo dugebo yootoongoowanggo. Me onindo gidarega yoyoro, enengo merako saro, ya biyomimo yoyetoyi, nguno oruwanggo. Oni sowe gidaregado Yerusalem ende yanggango sugi sugi soboyeroro, yomburiyeroro oodoyi, oororo, Anutdo me ebe yeni, kiniteweroyi naruno yokowa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Yisasdo mande gura eyingo. Kootuyisina, sambono ogisano, kombono, tootuno nguya sunggi guradiro guradiro tunootetoni kenowanggo. Merako oni simoo bare nowoondoye buribari ingoro, hahangero ingowatu oorengo tewanggo. Ndadiro nguro, wendeyi nguya tambu urungga urungga dokero, tuwi tero ngguyi urungga oorengo utoni ingoro, nguro sosorewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Oo kowuri urungga ngundiro merako ngano ombuwero tetoni, nguro oni simoo bare sosoreyingo urungga oorengo tero, nguro ingondudu tewanggo. Nowoondoyemonggo ngundiro sosoreyingo urungga tero, sambono tootu oo ngu kenootoyi, piparero, mboorombooro tetoyi, ngu kenoro, doongeye toongootoni, gaboye kumoowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ngundiro oo ngu tunootetoni ngu, asa, Oni Nangoni ngu goobooreno ombutoni kenowanggo. Ngundiro ombutoni ngu, enengo yanggangoni, bingamini ko duridarini ngu bidodo kenowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kootuyisina, oo ngu tunootewero tetoningga ngu, ye ootoogeya, dikaya, sambosina randoya doongeteyi, Anutdo ye ko yoyoweroyi narunggaku tunooteteku ngu! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yisasdo mande adingayi gura ero eyingo. Ye Kopi dega ngu kenoya, ko de gidarega nguya yeyoyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ye kenootoyi, nungo yero, bubudingo yetoni, ye ngu kenoro ingootenggo. Ataga Kopi enggeweroyi naruwo tunootewero tete, ero ingootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ngundiro nangge, ye nga oo kowuri etenoku nga, tunootetoningga ngu, ye nguno ingoyi! Anutdo oo bidodo sobowooweroyi narunggaku, ngu kuri namoko tete, eya ingoyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ero Yisasdo mande soweyoro eyingo. Hamoo oorengo no yeno eteno! Ataga nga naruno, ye Yuda sowengga ngaro simoo bare nga ma kumoomukoyingomo, nga oo nga bidodo tunootewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Sambo, mera nga, ngu oororo kinitetoni, ene noro mandene nga, ngu sugi sugi oruwa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","Ngu naruno, Yisasdo ngandiro eyingo. Ene yengomboro ingonda teyi! Kinitetoni ngu, ye sono kowoo nero (biya), ye suwooyi sano wenonoro oruwanggoku, ye goweyeboro oo gura guraro ingonduduyemonggo nguro hahangero oode ngu, muri ngundiro ye wiriyerowaku, ngundiro tero oodoyi ngu, asa, ngu narungga ngu sodedomangge tunooteweroyi, ngu sebabo sodedo nusako urooteku ngundiro oorengo tunootewa. Ngu narungga ngu mera bidodomo oni oorootenggoku, nguno kowuri ngu bidodomo tunootewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Suwooyi sano, ye komo sobowooya, doongedoongoodoongo teya, ye komo Anutno yanggango oruweroyi, nguro yemboongeya oriyi! Ndawugaro nguro, oo kowuri kootu tunooteweroyi, nguro Anutdo ye yanggango yunootoni ngunonggo yanggango dikaya ngunonggo nowoondoye hamoo teyingongga ngu ma yokowero. Kootuyisina, ye Anut Oniro Nangoni ngu doongeyimo dikawanggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Naru bidodomo, Yisasdo Tembel ya newendemo simoo bare Anutro mande etuyeroro oruwo. Ene suwoono ngu, Yisas oororo, Olib mera puringgano nguno wetoro oruwo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Oni simoo bare bidodo suwoononggo oorengo ootoogero, Yisasro mandeni ingoweroyimboro, Tembel yano ngu newendemo uroriyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Oo manongoyingo koongeweroyi ooga oowooyi Yis kini kingo kayingo ngu oowooyi Pasowa naruwo, nguro simbo kayingo kundingiyi tunootewero teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Anutno wooro yeyingo oni kundingiyi nguro sobosobo, ko mamana mandero etuyeroyingo oni, ngundo Yisas ureyi kumoowero ereweyingo. Ene ngundo oni simoo bare sosorero nguro ene ereremo kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Setando Yudas Iskariyoot newendemo uyingo. Yudas Yisasro kirikiri oni kegidemboro erayaga nguromu gura. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ngu Yudasga, ngundo oororo, Anutno wooro yeyingo oni kundingiyi, nguro sobosobo, ko Tembelno kumba ootuwoo oniro tabango nguya mande ero, oore erewero kenoro, ngunonggo Yisas ngu oni tabango ngu kandeyemo windogayi damoni tero yunowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Damoni tero yunowero, ene etoni, nguro tabango oni ene oni oni tero, nowoondoye guranangge yero, ene Yudas beye inowero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ngundiro tetoyi, Yudasdo ngu mete ero ingoro, asa, ene oore ndadirogano Yisas yoro, torige ngu oni tabango ngu kandeyemo yewero, oore ereweyingo. Naru gura oni simoo bare oowooyingga kini, ngu naruno ngu, yootunowero sobowooro oruwo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Oo manongoyingo koongeweroyi oo kini kingo kayingo naruwo kundingiyi, Pasowa ngu tunooteyingo. Ngu narunggano nguno, ene Sipsip nangoni wooro yeweroyimboro ureyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ngu naruno, Yisasdo Pita Yon eraga sureyeroro eyingo. Yari ooroya, noorengo Pasowa yomosiyootoriga, noore nguya oo newato. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ngundiro etoni, Pita Yon eragado, Yisasno gumi eworiyo. Noore ndano oo ngu yomosiyowaro? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Etoni, Yisasdo erayagakuya gumi eyingo. Ingori! Yari endemo oororo, ya oni gura kumbe urunggano sono moondoya koorowooya ombutoningga ngu, yari ngu keyoya ooroya, enedodo ya newendemo uri. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Yari ya simburiga nguno eri! Oo etuyeroyingo oningga, ngundo geya ewo. Noro ya gumi ndano, no nguno nenengo kirikiri onidodo Pasowa oo newato? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Nguno ngu, ene ya gumi urungga awu sanganimo ngu etuyerowa. Nguno ngu, oo neweroyi yaba ko bibiteweroyi yaba nguya oorooteku ngu! Yari ngu ya guminggano nguno Pasowa oo yomosiyori. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Arisa, kirikiri oni erayagaku oorowuworiyo. Pita Yon eraga oororo, Yisasdo oo ewoku, ngundiro kenoro, nguno Pasowa oo ngu yomosiyoworiyo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Pasowa naruwo tunootetoni, asa, Yisas ko enengo kirikiri oni nguya oo neweroyi yabano bibiteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ngu naruno, Yisasdo eyingo. No nga Pasowa nga yeya newero gome ingoro hahangero oorooteno. Ngundiro terogogo, asa, no ogingo kowuri urungga ngu koorowoowano. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","No yeno eteno. No ngaromu ko ma nero, ngu ooga ngu engge tetonigo, ngu Anutro endega sobowooteku newendemo nguno ko newano. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","18","Ngundiro tero, Yisasdo sono tobaga yoro dowooro, Anutno esosootero, yemboongero yokoro eyingo. Ye nga yoya, bayeteya neyi. No yeno eteno! No kootuyisina, Wayin sonoyi ngaromu ko ma nero, Anutro narungga sobowooteku tunootetoni, ngu narunggano, nguno sono ko newano. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Yisasdo ngundiro ero, ene oo manongoyingo yoro, Anutno esosootero, yemboongero yokoro, oososowooro yunoro eyingo. Nga ngu, nenengo gowene nondo ye hoorooweyeroyingo yunooteno. No yengo weti mbumbuwaro kumoowano. Nguro ye nero ngu, noro ingondudu tero oruwanggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Oowari nero yokoro, ene sono tobaga yoro ngundiro nangge dowooro, ero eyingo. Nga sono tobaga nga, ngu noro sidudarone ngu ye hoorooweyeroro wendooteno. Nga sidudaronengga nga, ngu sunggi mande keta Anutdo enengo oni simoo bareya ero gosiyoote. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ene ye nga ingoyi! Oni no yootunoneroro mundi oni kandeyemo yeweroyi oningga ngu, nga noya yabano bibiteteku nga! ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Yo, Oni Nangoni ngu, kuri Anutdo ooreningga rogo teyinoyingongga ngu keyoro, ngundiro nangge tewa. Ene oni ngu yootunoro, mundi oni kandeyemo yetekungga ngu, oniyooge oorengo! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Yisasdo ngundiro ero etoni, nguro kirikiri onikundo enengo nangge sumoo sumoo tero eyingo. Onendo ngu mandega ngu tewa? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ngu naruno, Yisasro kirikiri onikundo enengo nangge ronggeyoro eyingo. Onendo noore gidarega dagayeroro, enendo oni urungga oorengo tero, koreteyingo oruwa? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yisasdo enengo mandeye ingoro eyingo. Oni sowe gidarega, Yuda oni kini, nguro oo bidodo sobowooyingo oni koreteyingo ngu, ene oni yanggango oorengo tero, oni gidarega yowongoro, enendo nangge ururu tero oruwanggo. Enengo oni urungga, ngundo enengo merako soboyerooteku ngu yoyeni, Oni Sumangeyi Muri Metemi Teweroyi Oni, eya eyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ene yendo ngundiro ma tewero. Kini, oni gura ene ye kewooroyemo oni urungga tero, ene dagayeroro oruwero ewaku ngu, ene omburo enengo newendemo ngundiro ingoro, (oni songo hoorooweyerootooga, ngundo no oowoonengga ngu daganeroote, ero ingoyingo. Ene oni tabangongga ngu, ene omburo, ye hoorooweyeroyingo oni tero, kirikiri teyunowa.) ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Oni onendo gidarega bidodo dagayeroro urungga oorengo ooroote? Oni ene oowari nero bibiteteku nga, bine, ngundi, ko oni oowari yomosiyoro yoro ombutekungga ngu, bine? Ye kuri ingootenggoku, ngu oningga bibitetekungga ngu! Ene no ngu ye kewooroyemo hoorooweyeroyingo kirikiri oni nangge oorooteno. Ye oni tabangongga ngu, ene omburo ye hoorooweyeroyingo oni tero, kirikiri teyunowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Kuri, ye ngu no towootowooneroyingo naru nguno ngu, ye no ma noyokoro sayingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","No Awanembo oni simoo bare bidodo sobowooteku yanggangoni no nunoyingo. Ngundiro nangge, nondo nguya ngu yanggangoningga ngu ye yunooteno. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ngundiro tetoowe, sambo endemo ye mete noro yaba oo neweroyi nguno bibitero, noya oowari, sono newato. Ngundiro tero, ye mande wirikoweroyi yaba metemimo nguno bibitero, Iserel oni sowe kande eraya kegidemboro erayaga nguro mandeye muriye wirikoyerowanggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yisasdo eyingo. Sayimon Pita ge ingo! Setando ye kirikiri oni bidodo yoyoro yodowooro towooyerowero meno ero, boguboguwooro ooroote. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ene nondo ge hooroowenggeroro, Anutdo ge yanggango gunoni, ero yemboongewonoku ngu, gengo nowoondogemo hamoo ngu ma yomburiyoro yokowero. Ge kootuyisina, nowoondoge ko yowoorengootoni, gengo dobookurige yanggango teyunoyingo mande yunowa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ngundiro etoni, Pitando Yisasno mande gumi eyingo. Oo Bidodo Simburi Simbunani urungga, no hamoo oorengo, no kuri yoonenengoro oode, no komo geya ya biyomimo oororo, nguno gobooro kumoowaro. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yisasdo Pitaya mande gumi eyingo. Pita no geno eteno. Ataga, nga suwoonggano ngano, kootoori ma eyingomo, ge tambu kabusa ero ewa. No Yisas oningga ngu no watayi kini ero, no oongoonerowa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ngu naruno, Yisasdo kirikiri onino eyingo. Kuri, no ye sureyerootoowe sayingo. Ngu naruno nguno, ye beye siri, yengo kingo si, ko keye goweyi nguya ma yoyingo. Ngu narunggano nguno, ye oo guraro ingoro wenonoyingo, bine, ngundi kini, bine? Etoni, kirikiri onikundo mande gumi eyingo. Kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Etoyi ngu, Yisasdo ngandiro eyingo. Ene ataga nga, ngu oni gura ene beye siga tetoningga, ngu yoni, ko enengo si nguya ngundiro nangge yoni. Ene oni duge gura kinitetoningga ngu, ene komo enengo nengguroga andangeya, oni songomonggo dugega uriyoya yoni. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ndadiro nguro, Anutro mande ngundo no gowenemo engge yeni tunooteweroyi, nguro eyingo. Ene oni biyomidodo yowuruwoowanggo. No yeno eteno. Ngu mandega ngu komo no bungomo engge tunootewa. Yo, Anutro mande bidodomo ngu noro eyingoku ngu, ataga engge yeni tunootewa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ngundiro etoni, kirikiri onikundo eyingo. Oo Bidodo Simburi Simbunani urungga keno! Duge eraya oorooteku nga! Etoyi, Yisasdo mande gumi eyingo. Ngu mete, nguno yokoyi. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ngu naruno, Yisas ene ootoogero, ende yokoro, Olib purimo oorero, ene suwooyi sano teteku muringga ngundiro tero yemboongeweroyimboro. Yisas enengo kirikiri oniku enebana ootoogero, keyoro oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ene ngundiro oorowutoyi, Yisasdo nguno tunootero, kirikiri onino eyingo. Ye komo Anutno yemboongetoyi, Anutdo nowoondoye yanggango teyunootoni, ye towootowoono ma kiyayi yewanggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","42","Yisasdo mande ero, ene kirikiri oni yoyokoro, ene musiyo songosina, songo oororo, nguno bodowo oondoogero, mera sanggawero bibitero, Anutno ogingo urungga koorowoowanoku, nguro yemboongero eyingo. Awa, ge etoyi ngu, nga sono tobaga nga omburo daganerowa. Ene noromu kini. Awa, ngu gengomu nangge. Gedo etoyi, no komo ngu nangge keyoro tewano. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ngundiro yemboongetoni, Anutro Engel oni gura sambononggo Yisas tanggeyimo omburo, tunootero, yanggango inoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yisas newende kowuri urungga oorengo ingoro, ene yanggango yero yemboongero oruwo. Ngundiro tero oodoni, nosiriri urungga sidudaro ngundiro tunootero, omburo merako uyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Yisas ngundiro yemboongero yokoro, ootoogero, kirikiri onino oororo, yeyootoni, kubooyerootoni wetoro oodoyi, yeyoyingo. Ene nguro nowoondoye biyomi ingoro kowoo yetoni, nguro ene wetoro oriyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Yisasdo ngundiro yeyoro eyingo. Ye ndadiro tero, nguro wetoro oorootenggo? Ye ootoogeya, yemboongeyi! Ye ngundiro tero ngu, Setanro towootowoo ngu yeno ombutoni, yanggango tero, enengo ingonduduni ma keyowanggo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yisasdo kirikiri oniya mande ewoodoni, me oni endega mayeyingo. Ngu Yudasga ngu Yisasro kirikiri oni kande eraya kegidemboro erayaga (12) nguromu gura, ngundo koreteyunoro omburo, Yisas dowooro yenggonangoro, dureyoweroyimboro ombuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ene ngundiro yenggonangootoni, Yisasdo eyingo. Yudas ge Oni Nangoni yenggonangoro dureyoro, nguno yootunoro, mundi oni kandeyemo yero, yunowero bine, ombute? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Yisas ene kirikiri onikuno eneya oruwonggoku, ngundo mundi onindo Yisas ndadiro teyinowanggo, ero kenoro eyingo. Urungga Oo Bidodo Simburi Simbunani, ge etooga, noore dugebo nga yurewato, bine? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ngundiro etoyi, kirikiri oni kewooroyemo gurado Anutno wooro yeyingo oni tabango guraro ko oni gura utoro, sodeyi gidaregasina takatoni soreyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ene Yisasdo ngu kenoro eyingo. Ye ngundiro mande muringga ngu yokoyi! Yisasdo ngundiro ero, kandeyi ngu oni sodeyigaku yoro yetoni, ko mete teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","53","Asa, Yisasdo Anutno wooro yeyingo oniro sobosobo, yambo yano kumba dogoni oniro sobosobo, ko Yudaro tabango oni gidarega nguya eyingo. Ye yakaka oningga dowoowero nguro ye duge soboro, mata komukododo ombutenggo? Naru bidodomo, no yeya Tembelno oorootetoku, nguno ye ma nodowoowero nguro, ene ataga nga narungga nga, ngu yengo naru! Setanro yanggangoni ngu ngano tunootete. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Yisasdo ngundiro ero yokootoni, onikundo dowooro, yoro oorowuyingo. Yisas yoro, yade oororo, Anutno wooro yeyingo oniro tabango urunggakuro yano uyingo. Pitando ngu keyeroro bodaga orirokoyi songo oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ngu yangga ngu yasiriko de karo yakowero kayingo. Ngu degaku yakoro bibitetoyi, Pita nguya omburo, nguno enedodo de yakoro bibiteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ngundiro tero, kirikiri bare gurado Pita kenootoni, omburo, de yakoro bibitetoni, gome gome kenondadangero eyingo. Ge nga oningga nga nguya kuri Yisasdodo endeyoyingo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ene Pitando oongooro eyingo. Ayi, ngu no kini! Ge nga barega ngando godange ete! No ngu oningga ngu ma ingooteno! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Asa, bodaga nguya oode, oni gurado Pita kenoro eyingo. Ge nguya ame oningga amero keyimo oni gura! Etoni Pitando sodedomangge gumi eyingo. Ge godange ete! No kini! No ngu oningga ngu ma ingooteno! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Naru bodaga nguya oode, oni gurado Pita bungomo kandesisi tero, mande yanggango ero eyingo. Hamoo! Nga oningga nga, ngu eneya endeyoro oruwo! Ene nguya Galili oni! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Asa, Pitando mande yanggango gumi eyingo. Ge nga oningga nga, ge ndadiro ete? No ngu oningga ngu watayi kini! Pita ngundiro ewootoni, sodedomangge kootoori eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Urungga Oo Bidodo Simburi, Yisasdo yowoorengoro, Pita gome kenoyingo. Pita ngundiro kenoro, ene kuri Urungga Oo Bidodo Simburi Yisasdo ewooromu, ngu ingondudu teyingo. Yisasdo ngandiro eyingo. Nga suwoongga ngano kootoori ma eyingomo, ge ewa. No ngu oni Yisasga ngu ma ingooteno, ero tambu kabusa ewa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ngu ingonduduwooro Pita ootoogero, endesina oorero, ya kootuyisina oororo, sendoro biyobiyomi teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ngu naruno, me oni Yisas dowooro tabadori tero, yomooyinoro ureyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Towimbo Yisas doongeyi dobengoro eyingo. Ge Anutro ingondudu eyingo oni tetoningga ngu, asa, oni gurootekungga ngu omukumundoongo nenengo kenoya e. Ngu onendo guroote? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ene mande ngundiro oowooyingga oorengo ero, nguno yomooyinoro mande biyomi ero yomburiyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Sengetoni suwoononggo, Iserel oniro tabango oni, wooro yeyingo oniro sobosobo oniku, ko mamana mande etuyeroyingo oni ngu yowuruwooro oodoyi, nguno Yisas yoro, mande wirikoyingo onino oororo, yeyi dikatoni, sumoo inoro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","69","Ge nooreno e. Ge Krayis bine, ngundi kini, bine? Etoyi, Yisasdo mande gumi eyingo. Nondo yeno etoowe ngu, ye nowoondoyemo hamoo ma tewanggo. Nondo ye mande gidaregaro sumoo yunootoowe ngu, ye ngu mandega nguro gumi yootunoro ma ewanggo. Ene ataga ngano ko kootuyisina nguya, naru bidodomo Oni Nangoni ngu, ene Anut yanggangonidodo, ngu kandeyi koondosina bingamidodo bibitero oruwa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Asa, ngu oni ngu bidodo sumoo eyingo. Ngundiro nguro, ge Anutro Nangoni, bine? Eyingo. Ngundiro etoyi, Yisasdo gumi eyingo. Yengombo etenggoku ngu nangge, no Anutro Nangoni. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Enengo mandeni ero ingoro eyingo. Noore ndawu mande gura ewato? Enengo manggowoobo mande nenengo etoni kuri ingooteto. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Oni bidodo oorengo ootoogero, Yisas yoro, Yuda mera (Rom Gabuman) nguro tabango ngu oowooyi Payilatno oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Nguno ene Yisas kingo ganangoro goweyi sanggawero mande damoni yero eyingo. Noore nga oningga nga kenootooye, ene endeni endeni noorengo oni ganaganayeroro endeyoote. Ye (Gabuman) beye ma inowero ero, noore soreyeroro ete. Ene ngundiro nguya ete. No ngu Krayis mera ngaro oo bidodo sobosobo oni koreteyingo, ete. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Mandeye ngundiro ingoro, Payilatdo Yisas sumoo inoro eyingo. Ge Yuda oniro oo bidodoboro sobosobo koreteyingo, bine? Eyingo. Ngundiro etoni, Yisasdo mande gumi eyingo. Gedo eteku ngu nangge, no Yuda oniro sobosobo koreteyingo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ngundiro etoni, Payilatdo oni simoo bareno, ko Anutno wooro yeyingo oni nguro sobosobo oniku, ngu bidodomo ero eyingo. No nga oningga nga, goweyimo mande kowuri biyomi gura ma kenooteno. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Etoni, ene meno manggaru tero eyingo. Ene Yudiya mera nga bidodomo oni simoo bare ganaganayeroro endeyoote. Ene Galili merako andunonggo ngundiro tero, yade yade ngano mayewo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Payilatdo ngu ingoro simoo bare sumoo yunoyingo. Nga oningga nga Galili oni, bine? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Yisas ngu Galili mera nguro oni ngu ingoro, nguro ene Yisas soweyootoni Herod tanggeyimo oorowuyingo. Herodndo ngu Galili merangga ngu sobowooteku, nguro soweyootoni, eneno oorowuyingo. Ngu narunggano nguno, Herod nguya Yerusalem endemo nguno oriyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodndo Yisas kenoro, nguro ene oni oni tero, newende gome ingoyingo. Ndadiro nguro, ene kuri Yisasro mandeni etoyi ingoro, ene komo kurimimonggo kenowero ingondudu tero, ene muri songo gura onindo ma teweroyimu, ene doongeyimo tetoni, kenoro, ingoweroyimboro ingororuwo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ngundiro nguro, Herodndo oo gura gurano Yisas sumoo sumoo inoyingo. Ene Yisasdo Herodro mandeni gumi gura ma eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Anutno wooro yeyingo oni, nguro sobosobo oniku, ko mamana mande etuyeroyingo oni, ngundo omburo, Yisas bungomo mande godange urungga oorengo eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodndo enengo me oniku, ko enengo keyimo oni ngu bidodo, Yisas yomooyinoro mande ero mukendoro, oni biyomi, ero eyingo. Ngundiro nguro, ene towi nengguro gura nakanakangoyingo gomengga yoro, Yisas yemuyinoro eyingo. Kenoyi! Mera ngaro sobosobo koreteyingo urungga tunooteteku nga! Ero yomooyinoro yoro, Payilatno ko soweyootoyi oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Kurimi Herod ko Payilat eraga ngu, mundi mundi tero oruwori. Ene ataga ngano ngu, ene dobooyero siyero oorooteri. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Payilatdo Anutno wooro yeyingo oniro sobosobo oniku, ko simoo bare, Yudaro tabango garo, ngudodo negoyerootoni omburo yowuruwooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Payilatdo ero eyingo. Yendo nga oningga nga yoro, nono ombuwonggo. Nga oningga ngando simoo bare ganaganayeroro endeyoote, ero ewonggo. Ene nondo ngu mandega nguro yengo doongeyemo nenengo sumoo inowonoku ngu, ye ingoyi! Nondo ngu yendo eneya mande etenggoku ngu wirikootoowe, eneno biyomi gura ma kenooteno. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodndo nguya ene ko sureyerootoni, noorengomo ko ombuteku nga! Nguro ye ingoyi, oo biyomi gura ene ma teyingo. Nguno noore nguya ene urewe kumooweroyi oo biyomi gura eneno ma kenoyingo. Payilatdo ngundiro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ngundiro nguro, nondo gisaru sanggiridodo ngundo utoro, gisaruboro yokootoowe, ene toongewa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Nguro Yudaro muri ngandiro oorooteku, naru kundingiyi bidodomo, Payilatdo ya biyomimonggo oni guranangge nangge andangetoyi toongete. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ngundiro tero, oni simoo bare bidodo meno manggaru tero, eyingo. Ngu oningga ngu utooga kumootoningga, ge Barabas andangeyuno! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ngu Barabas oningga ngu, ene kuri (Gabuman) oniya me yeni tunooteyingo. Ende kewoorokono oni gura ureni kumootoni, nguro ene dowooro ya biyomimo yeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Arisa, Payilatdo mande ero ko eyingo, ene Yisas yokootoni, toongeweroyimboro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ene meno manggaru tero eyingo. De omukondino sanggawega kumooni! Ngu ma yokootoyi oruwero, sanggawega kumooni! Meno ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Payilatdo tambu kabusayigaku sumoo yunoro eyingo. Nga Yisas oningga ngando ndawu oo biyomingga tewoku, nguro noore ene urewe kumoowa? Nondo ene goweyimo mande biyomi gura ma kenooteno. Ngundiro nguro, nondo nangge utoro, gisaru sanggiridodo, ngundo gisaruboro yokootoowe toongewa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ene yanggango oorengo yero, Payilatro mandeni utoro wiriyoro meno moguru tero eyingo. Kini, de omukondino sanggaweya uto! Ngundiro meno ero, ngundo Payilatro manggowo wiriyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ngundiro tetoyi nguro, Payilat ene ko mande gura ma eyingo. Ene simoo bare manggoye keyoro, ewonggoku, ngundiro nangge teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ngu oningga, (Gabuman) ebe utoro oni ureni kumootoni yoro, ya biyomimo yeyingongga nguro simoo baredo eyingo. Mande ewonggoku, ngundiro nangge, Payilatdo Barabas andangetoni toongeyingo. Ene meno manggaru tero etenggoku, nguro Yisas ngundiya teyinoyi ero, me oni kandeyemo yero yunoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ene Yisas yoro oorowuyingo. Ene oni gura oowooyi Sayimon ngu Sayirinya mera nguromu, ene oore ngundiro omburo ende urunggano nguno uwero teyingo. Me oni ngu oningga ngu dowooro de omukondigaku ngu mooreyomo yetoyi, ngundo koorowooro, Yisas keyiwoore oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Simoo bare oowooyingga oorengo ene keyoro oorowutoyi, bare oowooyingga oorengo nowoondoyi tero, ngengeyoro sendoro owero oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","31","Ene Yisasdo yowoorengoro eyingo. Ye Yerusalem bare, ye noro ma sendowero. Kini, yengomboro, ko yengo simooyemboro nguya sendoyi, ero eyingo. Ye ingoyi! Kootuyisina naru biyomi oorengo gura tunootewaku nguno, bare ninggooteyingomu, bare simoo kuri ma bisiyoyingomu, bare simooye nono ma yunootoyi neyingomu, ngundo ene mete oni oni tewanggo. Ndawugaro nguro, ngu naruno nguno, ye kowuri ingoro, ye mera puri nguya ewanggo. Ye bidodo sodedo ukeya mayeya wiriyerootooga kumoowooto. Mera puri bobodiboya nguya ewanggo. Ye ukeya noore wiriyeroyi! Ero ewanggo. Ataga nono muri biyomi tetenggoku nga ngu, no ngu de keta biyomine gura kini ngundiro ene ndadiro muri biyomi gura ye oni simoo bareno teyunowanggoku, ngu ye de kumooni ngundiro? Eyingo. (Ene naru wengamo Anutdo wirikoyeroweroyi naru nguro eyingo.) ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Oni biyobiyomi eraya nguya yurewero, yoyoro, Yisasdodo oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ene yade puri bodaga sanganimo ooreyingo. Ngu musiyongga ngu, oowooyi tabango wimbuyi (Golugata). Ngu musiyonggano nguno Yisas boorowooro, oni biyomi erayagaku Yisas tanggeyi gide gide booroyeroyingo. Gura kandeyi koondosina, gura kandeyi desina booroyeroyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ngundiro booroyerootoyi ngu, Yisasdo yemboongero eyingo. Awa, no nutoro, mukendoneroro, booronerootenggoku, ngu ene ma ingoro nguro tenunootenggo. Nguro ge nga kowuriyengga nga andangeyunoya yokoya kabete! Ero eyingo. Ngundiro ero yokootoni, asa, me oni Yisasro nengguroni ngu yoro, ebe pawapawamu tero, oni gurado oni dagayeroro, ngundo nengguroga ngu yoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Oni simoo bare orirokoyi pawayeroro dikaro yeyorootoyi ngu, Yuda oniro tabango onindo yomooyinoro mande ero, tabadori tero eyingo. Kenoyi, ene kuri oni gidarega hoorooweyerowoku ngu, asa, ene Anutdo noore yoyoweroyi sunggi oni yeyingo oni tetoningga ngu, ene komo enengombo enengo hooroowetoningga merako ko ombuni. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Me oni nguya yomooyinoro mande ero, namoko omburo, Wayin sono kowoo biyomi Yisas inowero teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ngundiro tero, me oni enebana eyingo. Ge Yuda mera oni sobosobo koreteyingo oni tetoningga ngu, asa, gengombo gengo hooroowenggeroya merako ombu. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ene de omukondi sosowoomo awuno, nakaya gura Payilatdo ngandiro nakangoyingo. Nga Oningga Nga, Ngu Yuda Oniro Sobosobo Urungga, ero nakangoyingo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Asa, ngu oni biyomi gura Yisas tanggeyimo boorowoowonggoku, ngundo Yisas yomooyinoro manggaru tero eyingo. Ge Krayis tetoningga ngu, asa, gengo hooroowenggeroya ngunonggo noore nguya hoorooweyero. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","41","Ngundiro etoni, asa, oni biyomi guragakundo dobooyi mamanangoro eyingo. Ndadiro nguro, ge ene yomooyinoro ngundiro ete? Ene oo biyomi gura ma teyingo. Nguro ene kingo duwoo urootenggo. Ene noorendo ngu noorengo biyomi teworoku ngu kenoro, nguro gumi ngundiro teyunootenggo. Noorengo bidodo ngu ataga kumoowato. Nguro ngu, noorengombo biyomi teworoku, nguro ge Anutro ma sosorewa? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Arisa, ngundiro ero tabango yowoorengoro Yisasya eyingo. Oo Yisas gengo Awanggebo endemo ooroya ootooya ngu, asa, noro ingondudu te. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ene ngundiro etoni, Yisasdo mande gumi eyingo. No hamoo oorengo geno eteno. Ataga nga sanggano ngano, ge noya Awando ende gome mesarango oorengongga nguno uro oruwaro. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Sa kewooro oorengo, samboro mera bidodo suwoo ooreri urungga tero, oororo, sa nemimo uteku naruno wenga, (3 klok) yokoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ngu naruno, Tembelno kumba gagiwi urunggado ya gumi kundingiyi wemboongero boorowooyingonggaku, Anut enengombo kumbagaku wengamo awunonggo oomboongetoni, oosowooro, uro merako utoni, gide gide eraya tunooteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ngu naruno nangge, Yisasdo meno ero eyingo. Awa, ataga no nenengo gabone kandegemo yeteno. Eyingo. Ngundiro ero, ene kumooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ngundiro tetoni, me oni tabangongga, ngundo oo ngundiro kenoro, ene Anut bingami okooro eyingo. Hamoo oorengo, nga oningga nga biyomi gura ma teyingo! Ene oni nenengo oorengo! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ngu naruno, oni simoo bare oowooyingga oorengo mayero, Yisas udooyi, kenowero dikayingoku nguya, ene ngundiro kenoro, nowoondoyi tero, ngguyinggayi tero, enengo yano sayingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ene Yisas enengo dobookuriyi, ko bare gidarega Galilinonggo keyoro mayeyingomu, ngu orirokoyi dikaro, ngunonggo Yisas bingo ndadiro tewanggo, ero ingoro oriyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Oni gura, oowooyi Yosep ngu endeni ngu Arimatiya ngunonggo mayeyingo. Ngu oningga ngu, ene Yuda oniro mande wirikoweroyi oni, ene oni nenengo oorengo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ngu oningga ngu, ene oni simoo bare Anutdo oo bidodo sobowooweroyi narungga ngu sobowooro oodoni, nguno Yisas urewero mande ero etoyi, ene nguya nowoondoye guranangge kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Arisa, ene Payilat tanggeyimo oororo, Yisas bingo yowero sumoo inoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ngundiro tero, ene oororo, Yisas bingo de omukondinonggo andangero yoro, kumba sarayinggado bimbomooyingo. Ngundiro tero, enengo bingo yoro oororo, digi woondokoyimo nguno mere seyingomu nguno merengooyingo. Ngu merengga ngu kuri oni gura nguno ma merengooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ngu narungga ngu, (Sabat) naru kundingiyi, nguro oo yomosiyoweroyi naru. Suwootetoni, ngu Sabatro naru namoko tunootewo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ngu naruno, bare gidarega Yisas keyoro, Galilinonggo mayeyingomu, ene Yosep keyoro oororo, Yisas merengootoni, ngu kenoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ngundiro tero, enengo yano sodedo oororo, ene irosara, bo oo urumi ndindingo gomemu winggooro yomosiyoyingo. Ngu oo ngundo ko kootuyisina, Yisas bingo sonowooro yomosiyootoyi, sodedo ma buwoo yewero. Asa, naru kundingiyi, Sabat nguno ene ko kini mamana mandeno eteku, ngundiro tero kengero oriyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sande sengetoni suwoononggo, oo urumi ndindingo gome ngu yomosiyowonggoku, ngu yoro, yade mereno oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ene oni mereno omburo, doongeteyingomu ngu, digi urungga mere manggowo ukingoyingonggaku, nguno kini. Mere manggowo kuri goosooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ene mere newendemo uro, Oo Bidodo Simburi Simbunani Yisas nguro bingo ma kenoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ngundiro tero, nguro ingoyingo oowooyingga tero oodoyi ngu, asa, sodedomangge oni eraya enengo towikumbayari sarayi oorengo, yowari soruyi dedeku ngundiro tunootero, tanggeyemo dikatori yeyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ngundiro kenoro, bareku sosoreyingo urungga tero, bagootero, merasina doongetero oodoyi, oni erayagakundo eyingo. Ye ndawugaro oni keta oorooteku, ngu mereno ngano erewero ombutenggo? ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","Ene mereno ngano kini, kuri ootoogewo. Ye Galilino mande ewooromu ngu ma kabetewero. Ene ngandiro eyingo. No Oni Nangoni ngu mbumbuwadodo oni kandeyemo yetoyi, ngundo de omukondino booronerootoyi kumoowano. Ene sa kabusayigano ko ootoogewano. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ngundiro etoni, ngu bareku nowoondoye imi yetoni ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ene mere yokoro, sodedomangge ende oororo, oo bidodo kenowonggoku nguro kirikiri oni kande eraya kegidemboro guranangge (11), ko oni gidaregano nguya, oo kenowonggoku, nguro mande mande eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ngu bare ngu oowooye ngandiro: Mariya Magadala Yowana Mariya gura Yemus nemi, ko bare gidarega nguya, ngundo kirikiri onino oo kenowonggoku, nguro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ene kirikiri onikundo ngu ingoro ngu, ene nowoondoyemo hamoo etenggo, ero ma ingoyingo. Baredo ganayerootenggo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Asa, Pita ootoogero, kendutero, mereno oororo uyingo. Uro, doongetetoni, hamoo nguno kini. Towi nangge kenoyingo. Ngundiro kenoro, ene yowoorengoro ende oororo, ene Yisasro bingo ngu ndadiro tewo, ero nguro ingondudu urungga tero oriyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ngu sanggano nguno nangge, kirikiri oni kewooroyemonggo oni eraya Yerusalem endemonggo ootoogero, Emeyas oore keyoro, yade (11 Kilomita) ngundiro oorowuworiyo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ngu oni erayaga, ngundo Yisasno oo tewonggoku, nguro ene ero ingoro oore keyoro oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ngundiro ero, ingoro ingoro oorowuwoodori, Yisas enengombo doongeyarimo tunootero, nguya oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ene doongeyari gosiyootoni, nga Yisasdo ero ma ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ngundiro tero, Yisasdo eyingo. Yari ndawu mandega ero ingoro ingoro oorowuteri? Eyingo. Ngundiro etoni, erayagaku omukumundooyari bisiwero dikayingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Asa, oni gura oowooyi Kiliyopas oningga, ngundo yowoorengoro, Yisasya eyingo. Ge Yerusalemno oorooteku ngu, oo Yerusalemno oo tewonggoku ngu, ma kenoro ingoyingo? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ngundiro etoni, enebana gumi eyingo. Ndawu ooga? Eyingo. Erayagakundo mande gumi eyingo. Oo bidodo Nasaret oni, Yisas goweyimo oo tewonggoku ngu! Ene Anut doongeyimo, oni simoo bare doongeyemo nguya, ene Anutro ingondudu eyingo oni. Enengo mandeni, koni oororo omburo teyingo, ngu yanggangonidodo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Anutro wooro yeyingo oni kundingi nguro sobosobo oniku, ko Yuda oniro tabango oniku, ngundo ureyi kumoowero mande guranangge ero gosiyoro, Gabuman oni kandeyemo yetoyi, ngundo dowooro, de omukondino udoyi kumoowo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","23","Noorendo kuri ngandiro ingowooto. Anutdo ngu oningga ngu yootunoro yunootoni, ngundo noore Rom kandeyemonggo ko yoyootoyi, noore gome oruwato, ero ingowooto. Ene utoro yomburiyowonggoku ngu, ene ataga naru kuri kabusa yokowooto. Ngu oo ngu tewonggoku ngu, ene ataga noorengo bare gidaregado mereno oororo, enengo bingo ma kenoro, omburo, nooreno nguro mandeni etoyi, nguro noore soriyokoro sosorewooto. Ene Anutro sambono oni eraya (Engel) yeyootoyi, ngundo ewori. Ene kuri keta ootoogewo, ero ewori! ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Noore ngu ingoro, noorengo oni gidarega ene merengoowonggoku, mereyimo oororo doongetewonggoku, ngu hamoo baredo ewonggoku ngundiro, ene Yisasro bingo ma kenoyingo. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Arisa, Yisasdo mande gumi eyingo. Yari ingonduduyari himi kini, Anutro ingondudu eyingo onindo eyingomu, ngu yari nowoondoyarimo hamoo ma tewori! ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Yari, bine, ma ingooteri? Anutro ingondudu eyingo onindo, kuri ngandiro eyingo. Krayis ene komo ogingo koorowooro yokoro, ene kootuyisina, enengo ende duridarinidodomo oorowuwa. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ngu naruno, Yisas ene damoni yero, ene mande Mosesndo, ko Anutro ingondudu eyingo onindo, enengomboro ero nakangoyingo, mande gumi gumiku bidodo muri wesiyoro erayagakuno, ero etuyeroyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ene ende namoko tetoni, Yisasdo mande ngu ero dagayeroro, toongewero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ngundiro tetori, erayagakundo sorengoro eyingo. Suwootewero teteku nga, ngundiro nguro, ge nooreya ngano oruwato. Ngundiro etori, eneya yano oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Oo neweroyi naruno, yabano bibitero, Yisasdo oo manongoyingo gura yoro, dowooro, Anutno yemboongero yokoro, oososowooro yunoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Arisa, ene nguno doongeyari himi yetoni yokoro, ngundiro ingootori, Yisas doongeyarimo kini tero, ko toongeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ngundiro tetoni, enengo nangge mande eworiyo. Ene nooreya oore keyoro, Anutro mande bidodo muri wesiyoro ero, etuyerootoni ngu, ingootoore, nowoondonarimo ngu hamoo himi yetoni, nguro gome ingoworo! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","34","Ngundiro ero, ene ootoogero, suwoono nangge, ene Yerusalem ko oorowuworiyo. Ngundiro oororo, kirikiri oni kande eraya kegidemboro gurananggegaku ko oni gidarega nguya ereweyeroro yeyoyingo. Erayagakundo eyingo. Hamoo oorengo! Oo Bidodo Simburi Urungga ko ootoogewo! Sayimon doongeyimo tunootetoni kenowo! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Arisa, ngundiro ero yokootoyi, erayagakundo sodedomangge nguya gumi eworiyo. Noore ooreko Yisasdo mande etoni, ingoro, ko yano uro, oo manongoyingo oosowooro yunootoni, nero, ngu naruno, noore ingoworo. Yo, ngu hamoo, Oo Bidodo Simburi Simbunanimbo, ero ingoworo! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ngu oni erayagakundo mande ewootori, ngu naruno nangge, Yisas enengombo kewooroyemo tunootero dikaro eyingo. Ye nowoondoye imakeyingomo oriyi! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ngundiro etoni, ene soriyokoro, sosoreyingo urungga teyingo. Noore enengo gaboyi kenooteto, ero ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","39","Yisasdo enengo ingonduduye ingoro nguro eyingo. Ye ndatero sosoretenggo? Ye ndatero nguro nowoondoye buribari ingootenggo? Ye ombuya, noro kekandene nga kenoyi! No nenengombo nangge. Ye ombuya nodowooya kenoyi! Oombooro ngu, no ngandiro songgiwine wimbunedodo dowooro kenootenggoku ngundiro kini. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ene ngundiro ero yokoro, enengo kekandeyi nguya etuyeroyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ene nowoondoye gome ingoro, oni oni urungga teyingo. Ene nowoondoyemonggo hamoo nenengo ero ma ingoyingo. Nowoondoye kowuri ingoyingo. Ngundiro tetoyi, nguro Yisasdo eyingo. No oodoro kumooteno. Ye oowari bodaga ooroote, bine? Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","43","Ngundiro etoni, ene iso kayingomu gumi gura yoro, inootoyi, ene yoro, doongeyemo neyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ene oo nero yokoro eyingo. Mosesro mamana mande, Anutro ingondudu eyingo oniro mande, ko Iserel oniro yambo bukno (Sam) nguya nakangoyingo ngu, nguro mandeye kuri no yeya ootooro etoowe ingowonggoku, ngu bidodo noro eyingo. Ngu ataga engge nenengo ngundiro nangge tunootete. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ngundiro tero, ene Anutro mande muri gura gura wesiyoro ero etuyerootoni, nowoondoye himi yeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ngu mande gura soweyoro eyingo. Anutro mandeno ngandiro nakangoro eyingo. Krayis Anutdo noore yoyowero sunggi yeyingo oni, ngundo kowuri ogingo urungga ingoro, kumooro, asa, naru kabusayimo merenonggo ko ootoogewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Krayis oowooyimo, nowoondoye yowoorengoweroyi muringga ngu, ko Anutdo oniro weti mbumbuwa ngu andangeyunoweroyimboro muringga ngu oni simoo bare mera bidodomonggo wesiyoro etuyerowanggo. Ngu kongga ngu Yerusalem endemo nguno koretero damoni yero ko tero, ngunonggo mera bidodomo nguya ko tero, ero etuyeroya endeyoyi. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ero, Yisas mande gura soweyoro eyingo. Ye oo bidodo kenowonggoku, nguro mandeni yootunoya eya endeyoyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ye ingoyi! Noro Awanembo Yuka Kundingiyi yanggango ye yunowero mande guranangge ero gosiyoyingongga ngu, nondo soweyootoowe, yeno ombuwa. Ye komo nga endegano ngano sobowooya oodoyiga, ngu Yuka yanggangongga ngu sambo endemo awunonggo omburo, ye nowoondoyemo uro angewa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ene ngundiro ero yokoro, kirikiri oniku yoyoro, oororo yade Betani ende namoko nguno oorowuyingo. Nguno oororo, Yisasdo kirikiri oni kandeyi tabayemo okooro, kumana yunoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ene kumana yunowootoni ngu, Anutdo ene Yisas okooro, kirikiri oni yoyokoro, sambo endemo ooreyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Yisas sambono ooretoni, kirikiri oniku Yisasno yemboongero yokoro, ootoogero, oni oni urungga oorengo tero, Yerusalem ko oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ene suwooyi sano Tembelno uro, Anut bingami nangge ero okoororuwonggo.");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Kurimi oorengo, Anutdo oo bidodo ma yeyingo, ngu naruno, Mande ngu (Yisas) oruwo. Yo, Yisasdo ngu Anutya gobooro oruwori. Ngu enengombo Anut. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Kurimi oorengo damonimonggo ngu, ene Anutya oruwori. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Yo, Yisasdo ene oo bidodo temukoyingo. Nguro ngu, oo gura oore gurano ma tunooteyingo. Kini, oo bidodo tunootewoku ngu, Yisas enengombo yeni tunootemukoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Eneno keta sugi sugi oruweroyi oorooteku, ngu keta oruweroyiga ngu simoo barero soru himi. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ngu soru himingga ngu suwoono dero himi yetoni, ngu ooreri ngundo doobengoweroyi ereremo kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Oni gura tunooteyingo, ngu oowooyi Yon. Anutdo ene koretero soweyootoni ombuyingo. Yo, ene omburo oni simoo bare tunoo etuyeroro, Yisas ngu hamoo soru himi oorengo. Ngundiro tetoni, nguro oni simoo bare mande ngu ingoro, ene nowoondoyemo hamoo tewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yon enengombo ngu soru himingga ngu kini. Kini, ene ombuyingo ngu soru himingga (Yisas) nguro mandeni wesiyoro eweroyimboro ombuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Yo, Yisas ngu hamoo soru oorengo. Ngundo omburo, oni simoo bare bidodo merako oorootenggoku, ngu soru himi yunowero ombuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ngu ene merakono ootooro, ngunonggo ene merako, oni simoo bare, oo bidodo yeyingo. Ene merako oni simoo baredo, ene kenoro ma ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","12","Ene enengo ende damonimo oorowuyingomu, ene enengo Yuda onindo ngu ma yoyingo. Kini, oni gidaregado yoyingo. Ene oni ngu enengo oowooyimo nowoondoyemo hamoo tetenggoku ngu, ene mete Anutro simoongo oorengo tunootetenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Yo, ene Anutro simoongo tunootetenggoku ngu, ene awa namoyemboro sidudaroyebo kini, ko oniro ingonduduno nguya kini, enengo koyemo nguya kini. Anut enengombo yoyeni, enengo simoongo tunootetenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Mande (Yisas) ngundo oni tunooteyingo, ngu naru ootuwoo bodaga nangge, noore kewooronanimo oruwo. Yo, eweyimbo soweyootoni, ombutoni, noore kuri enengo duridarini ngu kenowooto. Ngu duridariningga ngu, enengo nangoni gurananggega nguromu. Sumange ko muri hamoo gome nenengomu, ngu eneno angeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yondo ngu oningga nguro mandeni wesiyoro ero, ngandiro meno eyingo. Ngu oningga ngu, kuri nondo yeno etoowe ingowonggoku, ngu ngandiro. Ene no kootu omburo tunootewoku, ene no oowoone dagaro urungga tunootete. Ndadiro nguro, ene kuri tunootero oruwoku, ngu naruno, no ma oriyingo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Eneno ngu sumange urungga oorengo hangero ooroote. Ngu sumangeningga, ngunonggo nangge suwooyi sano oo gome gome guradiro guradiro, ene noore yunororoote. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Yo, hamoo, Moses kandeyimonggo Anutdo mamana mande noore yunoyingo. Ene sumange nowoondoyi, ko muri hamoo gome nenengo, ngu Yisas Krayisnonggo nangge tunooteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Oni gurado hamoo oorengo Anut ma kenoyingo. Anutro Nangoni guranangge, ngu Anut kirarongo. Ngundo eweyi tanggeyimo oorooteku, ngundo nangge, Anutro muri ngu nooreno yootunoro ete. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yuda onindo Anutro wooro yeyingo oni kundingiyi, Liwayi oni ngu soweyerootoyi Yerusalem yokoro, omburo Yon sumoo inoyingo. Ge ndawu oningga? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ngundiro sumoo etoyi, arisa, Yondo mande tunoo ero, mande gura ma oongooyingo. Ene ngandiro wesiyoro eyingo. No Krayis, Anutdo noore ko yoyoweroyi soweyowoku oningga ngu kini. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Yondo ngundiro etoni, enendo sumoo inoyingo. Ngu ndadiro? Ge ndawu oningga? Ge bine Ilayisando? Etoyi, enendo mande gumi eyingo. No Ilayisa kini. Etoni, enendo sumoo gura eyingo. Ge bine Anutro ingondudu eyingo oningga, noorendo sobowootetoku, ngu bine? Ero eyingo. Asa, enebana mande gumi ero eyingo. Kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ngundiro etoni, enebana Yonno sumoo gura eyingo. Ge ndawu oningga? Noore komo mande gumi oni noore soweyerootoyi ombuwootoku, nguno ewato. Ge, gengomboya ngu, ge ndadiro ete? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ene ngundiro etoyi, Yondo gumi eyingo. No nga oningga ngaro Anutro ingondudu eyingo oni Ayisaya, ngundo eyingo. Oni gura kingo mera oni kini, ngunonggo manggowo gura meno ete. Oo Simburi Urungga, nguro oore yomosiyoyino! Ero eyingo. (Ayisaya 40:3) ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Parisi onindo ngu oni ngu, soweyerootoyi ombuyingo. Ene Yon sumoo inoyingo. Asa, ge Krayis kini, ge Ilayisa kini, ko Anutro ingondudu eyingo oni kini, asa, ndawugaro nguro, ge oni simoo bare sono kundingiyimbo sonoyeroote? Ero sumoo inoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ene ngundiro sumoo etoyi, asa, Yondo mandeye gumi eyingo. Nondo ngu sonombo nangge sonoyerooteno. Ene oni gura kewooroyemo dikaro oorooteku ngu, ye ngu watayi kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ngu oningga ngu, no kootunesina ombuteku, ngu oningga nguro yanggangoni urungga oorengo. Noro yanggangone ngu bodaga nangge, nguro ngu, no enengo ko oni tero, ma oruwano, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Nga mandega nga Betani ende, Yodan sono anduroko nguno tunooteyingo. Nguno Yondo oni simoo bare sono kundingimbo sonoyeroyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Sengetoni, Yisas ombutoni, Yondo kenoro eyingo. Kenoyi, nga ngu Anutro Sipsip Nangoni. Ngundo oni simoo bare mera bidodoboro mbumbuwaye andange yunowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ngu oningga nguro, nondo kuri ewonomu ngu. Oni gura no keneroro ombuteku, ngundo no daganeroyingo. Ndadiro nguro, ene no ma oriyingo naruno nguno, ene kuri oruwo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","No ngu oningga nguya watayi kini. Ene no omburo, oni sono kundingiyimbo sonoyerootoowe, nguno Iserel oni simoo bareno, ngu oningga ngu tunoo etuyerowano, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yondo mande ngandiro yootunoro eyingo. No Yuka Kundingiyi ngu, nu mumukondiri ngundiro tero, sambononggo omburo, ene tabango sanganimo oodoni, kenoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","No nenengombo ngu oningga ngu, kuri watayi kini. Anutdo oni sonoyero ero, soweneroro ngu, ngandiro eyingo. Ge Yuka Kundingiyi kenootoyi, oni gura tabango sanganimo oodoningga ngu, arisa, ngu oningga ngundo Yuka Kundingimbo oni simoo bare sonoyerowa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Asa, no nenengombo ngu ooga kenootoowe tunootewo. No nguro mandeni yeno kuri ewonoku, nga oningga nga, ene Anutro Nangoni. Yondo nguro ngundiro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Sengetoni, Yon dikatoni, enengo kirikiri oni eraya nguya dikayingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ene Yisas kenootoni, oore keyoro ombutoni, eyingo. Kenori, ngungga ngu, Anutro Sipsip Nangoni! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Enengo kirikiri oni erayagaku Yonro mande ngu ingoro, ene Yisas keyoro oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ene ngundiro tetori, Yisas yowoorengoro, erayagaku ene keyoro oorowutori, yeyoro eyingo. Yari ndawu ooga ereweteri? Etoni, erayagakundo gumi eyingo. Rabayi, ge ndawu yanggano ooroote? Ero eyingo. Rabayi mandega nguro muri ngandiro, oo etuyeroyingo oni, eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yisasdo gumi eyingo. Mete yari ombuya kenori. Etoni, asa, erayagaku Yisas keyoro oororo, ene oruwoku ya ngu kenoro, enedodo ngu sangga nguno oriyingo. Ene, ngu sangga nguno mande ero oodoyi, oororo suwootetoni ngu, sa gabogaboyi naru namoraya tunootetoni, ko suwoono nguya oruwonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Nga oni erayaga, ngando Yonro mande ingoro, ene Yisas keyoro oororo, ene oni gura oowooyi Enduru, ngu Sayimon Pita nguro koneyo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Enduru, sodedomangge Yisasdodo oruwonggoku yangga, ngu yokoro uro, beyi Sayimon koretero erewero kenoro eyingo. Noore kuri Mesayiya kenootetoku nga! Ero eyingo. Mesayiya nguro muri ngandiro. Ene Krayis, Anutdo noore ko yoyoweroyi sunggi yeyingo oni, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ngu naruno nguno, Endurundo Sayimon yoro, Yisasno oorowuyingo. Yisasdo kenoro eyingo. Ge Sayimon, Yonro Nangoni. Kootuyisina oowoongge Sipas (Pita) ewanggo, ero eyingo. Ngu oowooyi Pitangga nguro muri ngu digi urungga, eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Sengetoni suwoononggo, Yisasdo enengo ingondudunonggo, Galili merako oorowuwano, ero ingoyingo. Ene Pilip kenoro eyingo. Ge ombuya no kenero, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilip ngu ene Betisayida oni. Enduru Pita eragaro ende damoni nguya. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilipdo oororo, Nataniyel kenoro eyingo. Nga oningga nga ngu, ene kuri Mosesndo mamana mandeno nakangoyingo, ko Anutro ingondudu eyingo onindo nguya nakangoyingonggaku, noorendo kuri kenowooto. Ngu Yisas, Nasaret oni, ngu Yosep Nangoni, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ene ngundiro etoni, arisa, Nataniyeldo eneno ngandiro sumoo eyingo. Oo metemi gura Nasaretno tunootewa, bine? Ene ngundiro etoni, asa, Pilipdo mande gumi eyingo. Ombuya keno, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yisasdo Nataniyel kenootoni, eneno ombutoni, ngandiro eyingo. Keno, Iserel oni ene hamoo! Eneno godange mande ko muri biyomingga nguya, eneno ma ooroote, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ene ngundiro etoni, Nataniyeldo Yisas sumoo inoyingo. Ndatero, ge no watayi tewo? Ene ngundiro etoni, Yisasdo gumi eyingo. Pilipdo ma negogeroyingomo, no nguno (Pik) dega damonimo oodoni geyowono, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Etoni, Nataniyeldo gumi eyingo. Oo etuyeroyingo oni, ge Anutro Nangoni! Ge Iserel mera nguro oniro sobosobo koreteyingo urungga! Ene ngundiro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ngundiro etoni, Yisasdo gumi eyingo. No ge amana (Pik) de damonimo geyowono, ero etoowe, nguro ge nowoondogemo hamoo tete. Kootuyisina, oo urunggado nga ooga nga dagatoni, ge kenowa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yisasdo ene ko eyingo. No hamoo oorengo, yeno eteno. Kootuyisina, ye sambo goosootoni, kenootoyi, Anutro sambono Engel oni, ngundo Oni Nangoni, ngu tanggeyi gidegide oorero, omburo tetoyi, ye yeyowanggo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Sa eraya nguno yokoro, sa kabusayiga nguno, Yisas nemimbo ngu, bare yoweroyi yanggakuno oruwo. Ngu bare yoweroyi narungga ngu, Kena ende ngu, Galili mera nguno tunooteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ene Yisas ko enengo kirikiri oni nguya, ngu bare yoweroyi narungga, nguno negoyerootoyi oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ngundiro oororo oodoyi, Wayin kinitetoni, Yisas nemimbo Yisasya eyingo. Ene Wayin gura kini, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yisasdo eneya eyingo. Namo, nondo ndawu ooga tewe? Ngu noorengo geya oo kini. Noro naru ma tunooteyingo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ene ngundiro etoni, asa, nemimbo ko onikuya eyingo. Yisasdo yeno mande gura etoningga ngu, ye komo ngu keyoya teyi, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ngu yangga nguno, digi kumbe kandegura gidemboro guranangge oruwo. Nguno Yuda oni enengo muriye sono gimuweroyi sono oorengo, nguno oodoni, Anutro mamana mandeni Yuda onindo keyoyi ero, nguro eyingo. Kumbe guranangge nangge ngu 100 Lita ngundiro. (Ngu 6 ngundi 7 Kero Dram ngundiro). ");
INSERT INTO rwo_rawa_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yisasdo ko oniya eyingo. Kumbeno sono moondoya, kumbengootoyiga, hangeni. Ene ngundiro etoni, asa, ko onindo Yisasdo ewoku, ene ngundiro teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Yisasdo ko onikuya eyingo. Nga gumi wendoya, yoya, ooroya, oo simbo kayingo sobosobo ngu inoyi. Ene ngundiro etoni, ko onindo gumi wendoro, yoro, oororo, oo simbo kayingo sobosobogaku inoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Oo simbo kayingo sobosobogakundo, sono towoongoro netoni ngu, ngu naruno ngu, Wayin oorengo tunootete. Nguro ngu, ene ndanonggo yoyingo ngu, ene watayi kini. Ene enengo ko oni ngundo nangge watayi, sono oorengo moondowonggo. Arisa, oo simbo kayingo sobosobogakundo, bare yoweroyi oninggaku negongoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ombutoni eyingo. Oni bidodo koretero Wayin metemimu bayeterogogo, kootu oni simoo oowooyingga netoyi netoyi ngu, arisa, ngu naruno, ene Wayin biyomi bodaga nguno yunootenggo. Ene ge Wayin metemi oorengo ngu gosiyowoku, ge ataga kootu yoro omburo, bayeteteku nga! ");
INSERT INTO rwo_rawa_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Kena ende Galili merako nguno, Yisasdo koretero muri songo oorengo gura onindo ma teweroyimu, ngu teyingo. Nguno enengo duridarini ngu etuyerootoni, enengo kirikiri oni ene damoni yero, Yisasno nowoondoyemo hamoo teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ngu naru ngu kinitetoni, Yisas, nemi, konebeyi, ko enengo kirikiri oni nguya, Kapeniyam endemo uro, nguno sa naru gidarega kengero oruwonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Yuda oniro kengeweroyi kundingiyi naru oowooyi Pasowa, ngu namoko tete. Ngundiro nguro, Yisas yade oororo, Yerusalemno oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Yisas oororo, Yuda oniro yowuru ya oowooyi Tembel, ngu newendemo uro, oni Bulmakawu, Sipsip, nu mumukondiri uriyootoyi yeyoro, ko oni bibiteweroyi yabano bibitero, digi beye yowoorengoro yunootoyi yeyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Yisasdo uto gisaru tero, ngu yoro, Bulmakawu, Sipsip ko nusako bidodo musiyomo oorootenggoku oweyeroyingo. Ngundiro tero, ene oni digi yowoorengowonggokuno oororo, digi beye gasiyoni satoni, yaba bidodo wenggeremootoni, ukero utoni oweyeroyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ene oni nu mumukondiri uriyoyingo nguno eyingo. Ye nu yoya, musiyo nga yokoya sayi! Ye noro Awanemboro yangga nga yeyi, oo uriyoweroyi musiyo ma tewero, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Yisasro kirikiri oni ngu, ene Anut mandeno kuri oorooteku, ngu ingonduduwooro ingoyingo. No gengo ya nguro gome oorengo ingoro, nguro no ko yanggango oorengo tetoowega, gengo ya gome orini, ero ingooteno. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ene Yuda oniro tabango, ngundo ngundiro kenoro, Yisasya mande yanggango ero eyingo. Anutdo nga kongga ngano rogogerowo tetoni ngu, asa, ge oo muri songo oorengo gura onindo ma teweroyi, ngu anangu tetooga, noore kenoro ingowato. Ngu hamoo, Anutdo ngu kongga nguno rogogerowo, ero ingowato, eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ene ngundiro etoyi, Yisasdo mande gumi ero eyingo. Yendo nga yoro yangga nga toongootoyi ngu, nobana naru kabusagomo ko yewe dikawa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ngundiro tero, Yuda onindo eyingo. Oni nga yowuru Tembel yangga nga yerodoyi, mooma naru onibi namoraya, kandegura ke gidemboro guranangge (46) yokoyingo. Ngundiromu, gedo ngu ko sa kabusa nanggemo, ko yewero ete? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ngu yowuru yangga Yisasdo eyingo ngu, enengo goweyiboro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ngundiro nguro, kootuyisina, Anutdo merenonggo Yisas ko yokutuwootoni, ko ootoogeyingo, nguno enengo kirikiri oni ko ingondudu tero, Yisasdo mande kuri eyingo, ngundiro tunootetoni, nguno ingoyingo. Ngundiro tetoni, kirikiri oni ene Anutro mande nakaya, ko Yisasdo mande eyingoku, ngu bidodo ingootoyi, nowoondoyemo hamoo oorengo teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yisas ngu Yerusalemno Pasowa naru kundingiyi ngu sobowooro oodoni, oni simoo bare oowooyingga oorengo, Yisasdo oo onindo ma teweroyimu ngu tetoni, kenoro, nguro oni urungga oorengo, eneno nowoondoyemo hamoo teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ene Yisasdo simoo bare bidodoboro ingonduduye buribari ingootenggoku, nguro ene ngu oningga, nguro newendemo hamoo ma teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ndadiro nguro, Yisasdo ene oni simoo bare bidodoboro muriye, ingonduduye ingomukoote. Yisas ene oniro ingonduduye, nguro oni gurado ma etoni ingowa. Kini, ene bidodo ingomukoote. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Oni gura oruwoku, ngu oowooyi Nikodimas. Ngu Nikodimas oningga ngu Parisi oni, ko Yuda oniro tabango nguya. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ngu oningga ngu, suwoono Yisasno omburo eyingo. Oo etuyeroyingo oni, noore ingooteto. Ge oo etuyerowero, Anutdo sowenggerootoni ombuyingo. Ene Anutdo oni guraya ma ootooro ngu, ene oo songo gura oni ma teweroyi, gedo teteku, ngu ma tewa, ero ingooteto. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ene ngundiro etoyi, asa, Yisasdo mandeni gumi ero eyingo. Hamoo oorengo, no geno eteno. Oni gura ene newende buniyo keta ngundiro ma tunootero ngu, asa, ene Anutro endega enengo oni simoo barero soboyerooteku, nguno ma uro oruwa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ene ngundiro etoni, asa, Nikodimasdo gumi eyingo. Ndadiro terogogo, oni kuri dogoni yeyingo, ngundo ene ko yowoorengoro, oni buniyo keta ngundiro tunootewa? Ene mete nemi kawuyimo utoni, nemimbo ko bisiyowa bine? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ngundiro etoni, Yisasdo Nikodimasro mandeni gumi eyingo. Hamoo oorengo, no geno eteno. Oni ene sono kundingiyi, ko Yuka Kundingiyimo nguya, keta ma tunootero ngu, ene Anutro endega enengo oni simoo barero soboyerooteku, nguno uro ma oruwa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Oni ene eweyi nemimbo ketangga yeri tunootete. Ene Yuka Kundingiyimbo oni newendemo uro, ngundo yeni keta tunootewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ge nondo mandega geno etenoku, nguro ingondudu urungga tero, ma sosorewero. Ye komo yengo nowoondoye buniyo keta ngundiya tunooteyi! ");
INSERT INTO rwo_rawa_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Doogo ngu enengo ingonduduni keyoro, doogo yoro gurasina gurasina, oororo omburo tete. Ge kingo ngguyi nangge ingoote. Ene ndasinanggo omburo, ndasina oorowuteku ngu, ge ma ingoote. Oni bidodo ko keta Yuka Kundingiyimo tunootewanggoku nguya, ngundiro nangge, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ene ngundiro etoni, Nikodimasdo gumi ero eyingo. Nga ooga nga ngu, ndadiro terogo tunootewa? ");
INSERT INTO rwo_rawa_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Etoni, Yisasdo gumi eyingo. Ndadiro nguro, ge Iserel oniro oo etuyeroyingo oni, ge mande oo nga ma wirikoro ingoote? ");
INSERT INTO rwo_rawa_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Hamoo oorengo, no geno eteno. Noore oo kenoro ingootetoku, nguro mandeni yootunoro eteto. Ene noorendo mandega etetoku ngu, ye ingowero yokootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nondo kuri mera ngaro oo nguno ero etuyerowonoku ngu, ye nguro nowoondoyemo hamoo ma teyingo. Nguro nondo sambo endeboro oo nguno mande ero etuyerowanoku ngu, ndadiro terogogo, ye nowoondoyemo hamoo tewanggo? ");
INSERT INTO rwo_rawa_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Oni gura ene sambono oorero, sambo endeboro oo murini ma kenoro ingoyingo. Kini, Oni Nangoni, ngundo ene sambo endemonggo ombuyingo, ngundo nangge, sambo endeboro muri nenengo oorengo, ye etuyeroweroyimboro ombuwo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Kurimi Mosesndo oni kini, kingo merako nguno sire gabogaboyiga tero, de bodaga sanganimo yero boorowooro okootoni, oni ngu kenoro, ene ma kumooyingo. Ngundiro nangge, Anutro Nangoni Oni Kirarongo nguya, de sanganimo yero, okooro boorowoowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Oni simoo bare bidodo nguro nowoondoyemo hamoo tewanggoku ngu, ene suwooyi sano sugi sugi keta gome oruweroyi, ngu yowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Yo, Anutdo oni simoo bare mera ngano oorootenggoku, ngu bidodoboro nowoondoyi urungga tero, nguro enengo Nangoni gurananggega, ngu oni simoo bare yunoyingo. Ene ngundiro teyingongga nguno oni simoo bare bidodo nowoondoyemo hamoo tero ngu, asa, ene ma hoonootewanggo. Ene ngundiro tero ngu, ene suwooyi sano sugi sugi keta oruweroyiga ngu yoro, oni oni tero oruwanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Anutdo enengo Nangoni ngu merako ngano sureyootoni ombuyingo. Ene oni simoo bare wirikoyerowero ma ombuyingo. Kini, Anutdo ngu mera ngaro oni simoo bare bidodo weti mbumbuwanonggo ko yoyoni ero, soweyootoni ombuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Oni ene ataga newendemo hamoo teteku ngu, asa, Anut doongeyimo oni nenengo tunootete. Ene oni ene newendemo hamoo ma teteku ngu, Anut doongeyimo ene weti mbumbuwano hoonootero ooroote. Ndadiro nguro, ene Anutro Nangoni gurananggega nguro newendemo hamoo ma tewoku, nguro ene hoonootewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Mande wirikoyingo muri ngu ngandiro. Soru himi ngu kuri merako ngano tunootewo. Ene onindo ngu ooreriko oruwero ingoro, nguro ene soru himi ngu yokootenggo. Ndadiro nguro, enengo muriye ngu biyomi oorengo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Yo, ngundiro oni simoo bare ngu ooreriko muri biyomi ngu tero oruwero, gome ingootenggo. Ngundiro nguro, ene soru himimo ombuwero ma ingootenggo. Ndadiro nguro, enengo muriye biyomi ngu soru himi ngundo yootunoweroyi, nguro ene yokootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ene oni muri hamoo teteku ngu, ene soru himimo nguno ombute. Enengo murini, enengo koni, ngu Anutya ko teteriku ngu, oni doongeyemo tunoo kenowanggo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ngu naruno nguno, Yisasdo enengo kirikiri onikuya, Yudiya merasina oorowuyingo. Nguno, Yisas enengo kirikiri oniya nguno oode, oni simoo bare gidarega sono kundingiyi gimuyunoro oruwonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ngu naruno nguno, Ayinon ende ngu, Salim ende ngu tanggeyimo, nguno Yondo nguya, oni simoo bare sono gimuyunoyingo. Ngu merasina nguno sono oowooyingga oorooteku, nguro oni simoo bare suwooyi sano nguno mayero, sono kundingiyi yoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ngu naruno nguno, Herodndo Yon yoro ya biyomimo ma yeyingomo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ngu naruno, rongge mande gura Yonro kirikiri oni, ko Yuda oni guraya ngu kewooroyemo tunooteyingo. Ndadiro sono gimuweroyi, Yudaro muringga ngu keyoro ngu, ene Anut doongeyimo, sarayi tunootewato, ero ronggeyoro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ngundiro tero, enengo kirikiri oni Yonno oororo eyingo. Oo etuyeroyingo oni, kuri geya oningga Yodan sono anduroko ootooro, gedo nguro mandeni eyingo. Ngu oningga ngundo oni simoo bare sono kundingiyi gimuyunootoni, simoo bare bidodo eneno oorowutenggo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ene ngundiro etoyi, asa, Yondo mandeye gumi eyingo. Anut sambo endemo oorooteku, ngundo oni gura oo ma inootoni ngu, asa, ngu oningga ngu, ene mete ma yowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nondo mandega yeno ewonomu, ye ngu kuri ingoyingo. No ngu oningga, Anutdo oni noore ko yoyowero ero sunggi yeyingongga, ngu kini. Ene no ngu, Anutdo ngu oningga nguro ooreni yomosiyoyinoweroyimboro ero, koretero no sowenerootoni ombuwono. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ngu ngandiro. Ene oni gura bare yowaku ngu, asa, ngu barega ngu, ene ngu simoongga nguro bareyi. Ngu simoongga nguro dobooyi ngu dikaro, sodeyero, ataga bare yowoku oningga nguro mandeni ingoro, oni oni tewa. Ngundiro nangge, no nguya nowoondonemonggo ngu oningga ombuyingo, nguro no oni oni urungga teteno. Ataga ngu engge oorengo tunootete. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Hamoo oorengo, ngu oningga ngu (Yisas), nguro oowooyi ngu komo urungga oorengo tunootetoni, noro oowoone ngu komo omburo bodaga tero, ameno uwa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Oni sambono awunonggo ombuyingo ngu, enengo murini ngundo mera ngaro muriye ngu bidodo dagayeroote. Oni mera ngano tunooteteku ngu, ene mera ngaromu. Ene mera ngaro oo nguro nangge mandeni ero tete. Yo, hamoo, oni ene sambo endemonggo ombuyingo ngu, enengo murini ngundo mera ngaro muriye ngu bidodo dagayeroote. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ene oo kuri kenowoku, ko ingowoku, nguro ero yootunoro ete. Ene oni gurado ngu mandega ero yootunooteku, ngu ma yoro dowoote. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Oni ene mande ngu gome ingoro, yoro dowooro ngu, asa, ene yo ero ewaku, ngu mandega nguno ngu, Anut ene hamoo mande nangge ete, ero etuyerowa, eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ngu oningga Anutdo sureyootoni ombuwoku ngu, ene Anutro mandeni nangge yootunoro ete. Ndadiro nguro, Anutdo Yuka Kundingiyi ngu urungga oorengo inoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Eweyimbo enengo Nangonimboro gome ingoro, nowoondoyi teyinoro, nguro oo bidodo ene kandeyimo yero inoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Oni ene Nangonimboro newendemo hamoo teteku ngu, ene suwooyi sano keta sugi sugi oruweroyiga ngudodo ooroote. Ene oni Nangonimboro mandeni ngu ma ingoro keyoro ngu, asa, ngu oningga ngu, Anutya nguno keta ma oruwari. Kini, Anutro sanggiriningga ngu eneno oruwa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ngu narunggano nguno, Parisi onindo mande gura ngandiro ingoyingo. Yisasdo Yon dagaro, kirikiri oni oowooyingga oorengo yoyoro, sono kundingiyi gimuyunoote, ero ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Ene Yisas enengombo ma sonoyeroyingo. Kini, enengo kirikiri onindo nangge oni sonoyeroyingo.) ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yisas ene Parisi oniro mandeye ngu ingoro ngu, ene Yudiya mera yokoro, ene ootoogero, Galili merako ko oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Yisas ngu ene ootoogero, Sameriya mera kewoorokuri oorega ngu keyoro oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Yisas ngundiro yade oororo, Sameriya mera nguro ende gura oowooyi Sayika, nguno tunooteyingo. Ngu endega ngu namoko mera gura Yekobdo enengo nangoni Yosep kuri inoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Yo, ngu musiyonggano nguno, Yekobdo kuri sono merengga seyingo. Yisas oore yade yade omburo, moondeyi ogingootoni, nguro ene sono merengga ngu tanggeyimo bibiteyingo. Ngu narungga ngu, sa kewooro (12 Klok). ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ngu naruno nguno, Sameriya mera nguro bare gura sono moondowero ombuyingo. Ene ombutoni, Yisasdo ngu barega ngu kenoro, ngandiro eyingo. Sono bodaga nunootooga newe, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ngu naruno ngu, Yisasro kirikiri oniku bidodo, oowari uriyowero endemo umukoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Yisasdo ngundiro etoni, asa, Sameriya barega ngundo gumi eyingo. Ge ngu Yuda oni, ko no ngu Sameriya bare. Nguro ge ndawugaro, nono sonoro sumoo ete? Ero eyingo. (Ndadiro nguro, Yuda onindo Sameriya oniya doboo ma yero, gobooro ma endeyootenggo.) ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ene ngundiro etoni, asa, Yisasdo ngu barega nguya gumi eyingo. Ene ge Anutdo oo kingo duwoo gunooteku, ngu ingoro ngu, ko nga oningga ngando geno ete, sono bodaga nunootooga newe eteku, ngu nguya ingoro ngu, gebana eneya ewa. Suwooyi sano, keta oruweroyi sono ngu, no nunootooga newe ero ewaku ngu, enendo suwooyi sano keta oruweroyi sono ngu gunootoni newa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ngundiro etoni, barega ngundo Yisasro mandeni gumi eyingo. Oni urungga, ge sono moondoweroyi oo gura kini, nga sono merengga nga ngu, mera newendemo oorengo amu. Ge sono suwooyi sano keta oruweroyiga, ngu ndanonggo yowa? ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Yekobdo nga sono merengga nga ngu, sero yunoyingo. Ngu enengombo enengo simoongo, ko enengo nusakododo nga sonongga nga neroriyingo. Ge noorengo osinani, Yekob, ngu dagaro urungga, bine? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yisasdo barega nguro mandeni ngu ingoro, gumi eyingo. Oni bidodo nga sonongga nga nero ngu, ene kootuyisina sonoro ko ingoro hahangewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ene oni gura nondo sonongga nga inootoowe newaku ngu, asa, ene sonoro nggurongo ko ma soriyetoni hahangewa. Nga sonongga nondo inootenoku ngu, suwooyi sano keta oruweroyi sonongga ngu newendemo ngunonggo oorero oorero, ene sugi sugi oruwa, eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ene ngundiro etoni, asa, baregaku enebana Yisasno eyingo. Oni urungga, ge ngu sonongga ngu, no nuno. Nunootoyi ngu, asa, kootuyisina, no nggurongo soriyetoni, sonoro hahangero, no sono moondowero, ngano ko ma ombuwano. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Etoni, Yisasdo mandeni gumi eyingo. Ge ooroya, kamengge negongoya, yaringo eraya eraya ngano omburi! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ngundiro etoni, baregakundo gumi eyingo. No kamene moore kini. Etoni, Yisasdo baregakuya, eyingo. Ge ngandiro ete, no kamene kini, ge ngu hamoo oorengo ete. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ndadiro nguro, kuri ge kamesumoongge kandegura. Ataga simoongga oorooteriku, ngu gengo kamengge oorengo kini. Gengo mandega eteku, ngu hamoo oorengo ete, eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Etoni, barega ngundo Yisasno eyingo. Oni urungga, ataga no ingooteno. Ge Anutro ingondudu eyingo oni. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Noore osi sambananimbo nga mera purimo ngano yowuruwooro, Anutno yambo mande teyingo. Ene ye Yuda onindo ngu etenggo. Oni yowuruwooro yambo mande teweroyi ngu, Yerusalemno nangge, ero etenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Baredo ngundiro etoni, asa, Yisasdo mandeni gumi eyingo. Ge bare, ge komo noro mande etenoku nga ingoya, nowoondogemo hamoo teni. Naru gura tunootetoningga ngu, ye nga mera purimo ngano, ko ye Yerusalemno nguya, awananimo yambo mande ma tewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ye ngu, oo ye ma ingootenggoku, nguno yambo mande tetenggo. Noore Yuda onindo ngu oo ingootetoku, nguno yambo mande teteto. Ndadiro nguro, Anutdo ko yoyoweroyi koningga, nguro ingonduduga ngu, noore Yuda oni simoo bare kandenanimo ooroote. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Naru gura tunootetoni ngu, ngu narunggaku ngu ataga kuri tunootewoku nga! Oni bidodo hamoo yambo mande tewero ngu, asa, ene komo Yuka Kundingimboro Awangga nguro yanggangoni, murinimo, nguno yambo mande tewanggo. Ene muri ngundiro tetenggoku ngu, asa, Awando ngundiro oni nguro gome ingoote. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Anut ngu Yuka oorengo. Nguro oni simoo bare komo Yuka Kundingiyi, nguro yanggangonimo ngu yambo mande tewanggo. Yo, ene komo Anutdo muri metemi tewero ingooteku, ngu nangge teyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ene ngundiro etoni, asa, baregakundo mandeni gumi eyingo. No ingooteno. Mesayiya ombuwa. Ene Krayis, Anutdo noore ko yoyoweroyimboro ero rogo teyingo oni, ngundo ombuya. Ene ombuteku naruno nguno, ene oo bidodoboro etoni, noore ingowato, eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Barega ngundo ngundiro etoni ngu, Yisasdo enengo mandeni gumi ero eyingo. Ngu nondo nangge, no ataga geya mande eteroku nga! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Yisasdo barega nguya ngundiro ewootoni, asa, ngu naruno nangge, enengo kirikiri oniku omburo, yeyoro, ene nguro ingondudu urungga teyingo. Ene kirikiri oni gurado sumoo ewero ma ingoyingo. Ge ndawu ooga yowero erewete; ngundi, ge ndawugaro eneya mande eteri? Ero ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Arisa, ngu barega ngu, enengo sono nggusi nguno yokoro, ene kendutero, endemo oororo, oni simoo bareno eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Ye ombuya, ande oningga ande kenoyi! Ene nondo oo kuri tewonoku, ngu bidodo yootunoro ete. Ene Krayis bine? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ene ngundiro etoni, arisa, oni simoo bare endemo oruwonggoku, ngu bidodo ootoogero, ende yokoro, Yisas tanggeyimo ombuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ngu narunggano nguno, kirikiri onindo Yisasya oo neni ero, eriringoro eyingo. Oo etuyeroyingo oni, ge komo oowari ne! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ene Yisasdo eyingo. No oowari gidarega moore, ye nguro ma ingootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ngundiro etoni, nguro enengo kirikiri oni enengo nangge ero ingoro, eyingo. Oni gurado bine, oowari kuri yoro, mayero inowo? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yisasdo enengo ingonduduye ngu kenoro ingoro, nguro ene eyingo. Noro oowari ngu ngandiro. No komo oni no sowenerootoni, ngano ombuwonomu, nguro ingonduduni ngu keyoro, enengo koni ngu temukowano. Ngungga ngu, noro oowari nenengo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Yendo ngandiro etenggo. Kombo namoraya yokoro ngu, kono oowari enggero mandoni yemukootoni, yoro, ngu neweroyi naru. Ene no yeno eteno. Ye komo ootoogeya, doongeteya, endeyoya, oowari koyi nga kenoyi. Oowari kuri enggero mandoni yemukowo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Oni oowari engge yooteku ngu, ene enengo uriyi yoro, ene suwooyi sano sugi sugi keta oruweroyi, nguro oowari ngu yowuruwooro watayewa. Ngundiro nguro, oni oo miteku, ko oni oo engge yooteku nguya, ene gobooro oni oni tewari. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ngundiro nguro, nga mandega nga ngu hamoo. Oni gurado ngu, oo yuwooyi mitoni, ko oni gurado ngu oowari enggero mandoni yetoni, ngu yoote. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nondo kuri ye sureyerootoowe, ye ko tero oo ma miyingomo, nguno oowari enggero mandoni yetoni yowanggo. Oni songombo ko kuri yanggango ko tetoyi, oowari oorero enggewoku ngu. Yendo ngu kongga nguno uro, oowari engge yowonggo. Yisasdo mande ngundiro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Sameriya ende urungga nguro oni simoo bare oowooyingga oorengo, barega nguro mandeni ngu ingoro, nguro ene Yisasro nowoondoyemo hamoo teyingo. Ndadiro nguro, barega ngundo eyingo. Nondo kuri oo biyomi tero endeyowonoku, ngu bidodo yootunoro emukoote, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ngundiro etoni, Sameriya endemo oni simoo bare ngu, ene Yisasno omburo eyingo. Ge ombutooga nooreya ngano oruwato. Ngundiro etoyi, nguro Yisasdo ngu endegano, nguno sa eraya oriyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Sa eraya nguno oodoni, nguno ngu, oni simoo bare oowooyingga nguya Yisasdo mande etoni, ngu ingoro, nowoondoyemo hamoo teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ene ngu barega nguya eyingo. Noore gedo etoyi ingoro, nguro noore nowoondonanimo hamoo ma teyingo. Kini, noore ngu noorengombo enengo manggowoomo mandeni nguya ingoro, nguro noore nowoondonanimo hamoo teteto. Noore ingooteto. Nga oningga ngando nangge, ene mera ngaro oni simoo bare bidodo ko yoyoweroyi oni oorengo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ngu sa erayaga nguno yokoro, ene ootoogero Sameriya ende yokoro, yade yade ooreko oororo, Galili merako tunooteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yisas enengomboro ero eyingo. Anutro ingondudu eyingo oni ngu, enengo ende damonimo oowooyi bingami ma tunootewa. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ngundiro ero, Yisas ene yade oororo, Galili merakono tunooteyingo. Ene tunootetoni, Galili oni ngundo Yisas kenoro, ene oni oni teyingo. Ndadiro nguro, ene naru kundingiyi nguno Yisasdo Yerusalemno ko oo tewoku, ngu ene nguya oororo kenoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ngundiro tero, Yisas ene Kena ende Galili mera nguno mayero tunooteyingo. Ngu endega nguno ene kuri sono yowoorengootoni, Wayin tunooteyingo. Ngu merako nguno ende gura oowooyi Kapeniyam. Nguno Gabuman oniro sobosobo tabango gura oruwoku, ngu enengo nangoni ngu sayidodo oruwo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ngu oningga ngundo Yisasro mandeni ingoworomu ngu, Yudiya mera yokoro, ene mayero, Galilino ooroote, ero etoyi, ingoyingo. Nguro, ene Yisas tanggeyimo oororo eyingo. Ge komo ombuya, noro nangone kumoowero namoko tete. Nguro ge ombuya, yomosiyootooga mete teni, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ene ngundiro etoni, asa, Yisasdo eyingo. Ene yeno Anutdo oo songo gura onindo ma teweroyimu teteku, ngu kenoro, nguro ye nowoondoyemo hamoo ma tetenggo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Yisas ngundiro etoni, asa, Gabuman oniro sobosobo oni tabangongga, ngundo Yisasno eyingo. O oni urungga, ge komo sodedo Kapeniyam endemo ombu, no nangone kumoowero teteku nga! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Tabango oningga ngundo ngundiro etoni, Yisasdo gumi eyingo. Ge mete oorowu, gengo nangongge ngu keta oruwa. Ene ngundiro etoni, asa, ngu oningga ngu, ene Yisasro mandeni ngu ingootoni, hamoo tetoni, nguro ene oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ngu oningga ngu ene oorowutoni, enengo yano kirikiri oni ooreko yeyootoni, ngundo eyingo. Gengo nangongge keta ooroote, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ngundiro etoni, nguro enengo kirikiri oniku sumoo yunoro eyingo. Kuyowo ndawu naruggano ene sayimbo yokootoni, ene metemi tewo? Ene ngundiro etoni, enengo kirikiri onikundo gumi eyingo. Ene kuyowo sa gabogaboyi ngu naru gurananggemo (1 klok), moondeyi kookingo urunggaku yokootoni, mete tewo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ngundiro etoyi, eweyi ingoyingo, kuyowo ngu narunggano nguno nangge, Yisasdo gengo nangongge ngu keta oruwa, eneno ewo. Ngundiro nguro, ene Yisasro newendemo hamoo tetoni, enengo keyimo oniku nguya eneno nowoondoyemo hamoo temukoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ngu naruno, Yisas ene Yudiya mera yokoro, Galili merako mayero, nguno ene oo songo gura onindo ma teweroyimu, ngu tambu erayayiga, nguno teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Yuda oniro naru kundingiyi gura tunootetoni, nguro Yisas ene Yerusalemno oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yerusalem endeboro oonggoo pawa nguro yamuko ngu oowooyi, Sipsipro yamuko. Ngu yamukongga ngu tanggeyimo nguno sono koongeyingo gura oruwo. Ngu Hiburu mandeno ngu oowooyi Betisayida, ero eyingo. Ngu sono koongeyingongga ngu, dabemimo ya tookoododo kandegura oruwo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ngu ya tookoododono nguno, sayi oni oowooyingga oorengo oruwonggo. Oni doongeye kiringomu, oni kekandeye nggiminggameyimu, ko kekandeye bingo yeyingo oni, ngudodo nguno oruwonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Naru gidaregano, Anutro sambono Engel ngundo omburo, sono newendemo uro, sono tetoyi, roringoro, ikakowooyingo. Oni gura ene koretero oororo, sonono uwaku ngu, enengo sayini kinitetoni, mete tewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ngu musiyomo nguno, oni gura ngu ya tookoododono oruwoku, ene sayidodo oodoni, dagoma onibiga kande eraya kengga kegidemboro kabusa (38) nguno oruwo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yisasdo oningga ngu kenootoni wetoro oodoni, ene ingoyingo. Nga oningga nga, ene naru pirungga ene sayidodo oruwo. Ngundiro ingoro, Yisasdo oni sayidodoga nguya sumoo ero eyingo. Ge gengo gowege ngu gome metemi tewero ingoote, bine? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ene ngundiro sumoo etoni, sayi oninggakundo Yisasro mandeni gumi ero eyingo. Oni urungga, sono kooto oorero ikakooteteku naruno ngu, oni gura no hoorooweneroro, noyoro sonono noyeweroyi kini. No nenengombo oorowuwero oorowutoowe, oni songombo oororo, no daganeroro, enendo sonono koretero oororo utenggo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Etoni, asa, Yisasdo ngu oni sayidodoga nguya eyingo. Ge ootoogeya, gengo yaba, oo ngu yoya, dikaya oorowu, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ene ngundiro etoni, arisa, sodedomangge ngu sayi oningga nguro goweyi metemi tetoni, ene ootoogero, enengo yaba oo ngu yoro, dikaro oorowuyingo. Ngu kongga ngu Sabat naru kundingiyimo teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Yuda tabango onindo, oni sayidodoga ko metemi teyingongga nguya eyingo. Ataga ngu naru kundingiyi (Sabat). Mosesro mamana mandeno ngu, ge gengo yaba koorowooro endeyoweroyi nguya roogo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ene ngundiro etoyi ngu, asa, ngu oni sayidodoga metemi teyingongga, ngundo mandeye gumi eyingo. Oningga no yomosinerootoni metemi tetenokungga, ngundo ero, nono ete. Gengo yaba oo ngu yoya, koorowooya oorowu, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ngundiro etoni, Yuda onindo sumoo inoro eyingo. Ndawu oninggado geno ete, ge gengo yaba yoya, koorowooya oorowu, ero ete? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ene ngundiro sumoo etoyi, oni goweyi metemi tewokungga ngu, ene onendo tewoku ngu ma ingoyingo. Ndadiro nguro, oni simoo bare oowooyingga oorengo oodoyi, Yisas ene ngu kewooroyemonggo kuri toongeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kootuyisina, Yisasdo ngu oninggaku yowuru yano kenoro eyingo. Ataga ngu ge mete tewoku nga, ge weti mbumbuwa gura ma tewero. Kinitetoni ngu, kowuri gura urungga oorengo ge moondegemo tunootewa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Arisa, ngu oningga Yisasro mandeni ingoro ngu, ene oororo, Yuda onino eyingo. Nga oningga ngando no yomosinerowoku, ngu oowooyi Yisas, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ngundiro etoni, Yuda onindo ngunonggo Yisas yomburiyoweroyimboro damoni yeyingo. Ndadiro nguro, ngu ooga ngu Sabat naru kundingiyimo nguno tewoku nguro. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ene Yisasdo mandeye gumi ero eyingo. Awanembo ngu naru bidodomo ko tero oorooteku, ngundiro nguro, no nguya ko tewano, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ngundiro etoni, Yuda onindo ngu ene komo Yisas ureyi kumooweroyimboro yanggango yeyingo. Ndadiro nguro, Yisasdo Sabat narungga nguro mamana mande ngu yomburiyoro, ko nguya Yisasdo ete. Anut ngu enengo eweyi oorengo, ero ewo. Ngu mandega eteku, nguno ngu, enengombo Anut ngundiro tunootete. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Arisa, Yisasdo Yuda oniro mandeye gumi ero eyingo. Hamoo oorengo, no yeno eteno. Nangonimbo enengo ingondudunonggo oo gura ma tewa. Kini, ene oo eweyimbo tetoni kenowoku, ngu nangge tete. Eweyimbo oo bidodo teteku, ngu enengo Nangonimbo nguya ngundiro nangge tewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Eweyimbo Nangonimboro gome ingoro, nowoondoyi teyinoro, nguro ene oo bidodo gome etungootoni, Nangoni nguya tete. Eweyimbo ko nga dagaro urungga nguya etungootoni tewa. Nguno ye nowoondoye soriyokoro, ingondudu urungga ingowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Eweyimbo oni kumooyingomu yokutuwootoni, ootoogetoyi, keta oruweroyi ngu yunoote. Ngundiro nangge, Nangonimbo nguya, ene keta oruweroyiga ngu yunowero ngu, ene mete keta yunoote. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","Eweyi Anutdo oni guraro mandeni ma wirikoote. Kini, oni wirikoweroyi ko ngu bidodo enengo Nangoni kuri inoyingo. Ndadiro nguro, oni bidodo Anut oowooyi bingami ero okootenggoku, ngundiro nangge, enengo Nangoni nguya ngundiro oowooyi bingami ero okoowanggo, ero ingoote. Oni ene Nangoni oowooyi bingami ma ero okooteku ngu, asa, ene Eweyimbo, Nangoni soweyootoni ombuwoku, nguya oowooyi bingami ma ero okoote. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Hamoo oorengo, no yeno eteno. Oni ene noro mandene ingoro, keyoro, Anutdo surenerowoku, nguya newendemo hamoo tewaku ngu, asa, ngu oningga ngu, ene keta sugi sugi oruwa. Yo, hamoo, ngundiro oningga ngu Anutdo oni nenengo etekungga ngu, kootuyisina, Anutdo ene ko ma wirikowa. Kini, ene Anutya keta oruwari. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Hamoo oorengo, no yeno eteno. Naru tunooteweroyi ngu, ataga kuri tunooteteku nga, oni kumooyingo ngu, ene Anutro Nangoni nguro manggowo ingoro ngu, asa, ene suwooyi sano keta oruweroyi ngu yowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Eweyi enengombo ngu oni simoo bare yoyeni, keta oruweroyi ngu tunootete. Ngu yanggangongga ngu nangge Nangoni inootoni, nguro ene nguya keta oruweroyiga ngu oni simoo bare yunoote. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ene Oni Nangoni, ngundiro nguro, Eweyimbo oni wirikoweroyi kongga ngu ene inoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","29","Ngu hamoo, tunooteweroyi naruno tunootetoni ngu, oni bidodo kumooyingomu mereno oorootenggoku, ngu ene nenengo manggone ingoro ootoogero, enderoko oorewanggo. Yo, hamoo, oni ene muri gome nenengo endeyoro oruwonggoku ngu, ene keta ko ootoogero Anutya sugi sugi oruwanggo. Ene oni muri biyomi tero oruwonggoku ngu, ene ko ootoogero, mandeye wirikoyingo onino oororo, dikaro, ngunonggo ene Setanro ende biyomi nguno sugi sugi oruwanggo. Ye nguro ma soriyokoro tewero. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Yisasdo Yuda oni tabango nguya mande ngandiro eyingo. No nenengombo nenengo ingondudunemonggo oo gura ma tewano. Kini, no Awanonggo mande ingowonomu ngu nangge keyoro, no oni wirikoyerowano. Noro mande wirikoyingo ngu nenengo oorengo. Ndadiro nguro, no nenengo ingondudune ma keyooteno. Kini, Awando no sowenerootoni, ombuyingongga nguro manggowo nangge keyoro ko teteno. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ene no guranangge, nondo nangge nenengo mandene wesiyoro ero ngu, asa, ngu mandega wesiyoro ewonoku, ngu hamoo kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ene gura (Anut) nguya oorooteku, ngundo ene noro mande ero yootunoote. Ngu noro mandega ewoku, ngu hamoo oorengo, ero ingooteno. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Kurimi, yendo oni gura soweyootoyi, Yonno oororo, ene noro mande wesiyoro etoni ingowonggo. Mande bidodo ingowonggoku ngu, ngu hamoo mande nangge. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Oni dikaro, noro mande, oowoone ero yootunootenggoku, nguro no ma ingondudu teteno. Ene nondo ngu Anutdo ye ko yoyoni ero, nguro gome ingooteno. Ngundiro nguro, nondo nga mandega nga yeno etenoku, ngu Yonro koni nguro mande eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yon ngu soru ngundiro dero, oni simoo bare himi gomemo yunowo. Yengo nowoondoye ngu mete tetoni, ye naru ootuwoo bodaga enengo himimboro oni oni tewonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ene noro kone, murine, oo songo gura onindo ma teweroyimu, ngu ye kewooroyemo tewonoku, ngundo Yonro mande hamoo ewoku, ngu dagayingo. Ene ataga noro murine ngu nga yootunoro ete. Ko bidodo awando no nunowoku ngu, no temukowano. Yo, hamoo, nondo ko tetenoku, ngu enengombo oni simoo bare etuyerootoni, Awando no surenerootoni, no ombuyingo, ero ingowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Awando no surenerootoni, ombuwonoku, ngu enengombo no yootunoneroro, mande ero yunoyingo. Yo, hamoo, ye enengo manggowo bodaga ma ingoro, ko enengo omukumundoongo nguya ma kenoyingo. Ene enengo mande ngu Bukno ooroote. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ene ye nguro mandeni nowoondoyemo ngu ma ooroote. Ndadiro nguro, ye Anutdo no sowenerootoni ombuwonoku, ye nguro nowoondoyemo hamoo ma teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","40","Ye ngandiro ingootenggo. Anutro mande nakaya ngundo suwooyi sano keta oruweroyi ketangga ngu yunootoni, suwooyi sano gome oruweroyi ero etenggo. Ngundiro nguro, ye mande bidodo ngu nakaya ngu newendemo oorooteku, nguro koyi tero erewetenggo. Ene ngu nakayangga, ngu noro yootunoro ete. Ene ye nono omburo suwooyi sano keta oruweroyiga ngu ma yowero ingootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","No onindo bingamine eya okooyi ero, ma sumoo yunooteno. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ene nondo ye ingooteno. Yendo ngu, yengo nowoondoyemo Anutno hamoo ma tero oorootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","No kuri awanemboro oowooyimo ombuwonoku, ene ye noro mandene ma yoro ingootenggo. Ene oni gura enengo oowooyimo ero ombuwaku ngu, ye nguro mandeni ngu ye hahangero yoro ingowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ye yengo bingamiye ngu yengo dobookuriyemonggo yootenggo. Ene ngu bingamingga ngu Anutdo yunowero ingooteku, ngu ye yowero ma ingootenggo. Ngundiro nguro, ye nowoondoyemo hamoo ma tero, nguro nguya ma ingootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ye nowoondoyemonggo ngandiro ma ingowero, nondo Awano ye wirikoyerowero mande eweroyi kini ero, ma ingootenggo. Ye Mosesndo nangge ye hoorooweyeroweroyi ero, ingondudu tetenggo. Kini, ngu ingonduduga ngu nenengo kini. Mosesndo ngu yengo wirikoyeroweroyi oni. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mosesndo noro newendemo hamoo teyingo. Nguro ngu, ye Mosesro mande nowoondoyemo hamoo tero ngu, ye noro mandene nguya nowoondoyemo hamoo tewanggo. Ndadiro nguro, Mosesndo ngu ene noro mandene nakangoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ene ye Mosesndo mande nakangoyingo ngu nowoondoyemo hamoo ma tero ngu, ye ndadiro tero ngu, ye noro mandene ngaro nowoondoyemo hamoo tewanggo? Ye ereremo kini. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ngu mandega ngu kinitetoni, Yisas ene Galili mera nguro sono koongeyingo oowooyi Tayibiriyas, (Galili) ngu anduroko nguno urooreyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Nguno urooretoni, oni simoo bare oowooyingga oorengo, ngundo Yisasdo oo songo gura onindo ma teweroyimu sayi onino tetoni, nguro ene Yisas kenoro, keyoro endeyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ene ngundiro tetoyi, Yisasdo enengo kirikiri onikuya purimo oorero, nguno bibiteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ngu naruno nguno, Yuda oniro Pasowa naru kundingiyi, ngu namokono tete. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","6","Yisas doongetero, endeyoro, oni simoo bare oowooyingga oorengo yeyootoni, ene tanggeyimo ombuyingo. Ombutoyi, Yisasdo oo teweroyi kuri ingoro, nguro ene Pilip towoongoro, ngandiro sumoo eyingo. Noore oomanongoyingo ndanonggo uriyoro, nga oni simoo bare nga yunootooye newanggo? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pilipdo mandeni ngu ingoro, gumi ero eyingo. Noore sa naru onibiga (200) ko tetooye ngu, ko nguro uriyi yowatoku, ngundo nga oni simoo bare urungga ngaro oomanongoyingo bodaga uriyootooye, ma mete tewa. Hamoo oorengo kini, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ngu naruno nguno, Yisasro kirikiri oni gura, oowooyi Enduru, ngu Sayimon Pita koneyo, ngundo Yisasno ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Simoo oore gura nooreya ngano oorooteto. Ngundo ene oomanongoyingo kandegura ko iso eraya bodaga nguya moore. Ene ngundo oni simoo bare ngandiro urungga nga ma mete tewa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ene ngundiro etoni, asa, Yisasdo eyingo. Simoo bareno etoyiga, ene bibiteyi, so gome gome nguno oruwo. Ene ngundiro etoyi ngu, asa, oniku nguno bibiteyingo. Ngu simoo ngu bidodo yowuruwootoni, ngu urungga oorengo (5,000). ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Oni simoo bare bibitemukootoyi, Yisasdo ngu oomanongoyingoku yoro, Anutno esosootero, enengo kirikiri oni yunootoni, ngundo bayetero, oni simoo bare yunoyingo. Ngundiro tero, Yisas ene iso erayagaku nguya yoro, Anutno esosootero, bayetero yunootoni, nero, ene kawuye mete teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Oowari netoyi mete tetoni, asa, Yisasdo enengo kirikiri onikuno eyingo. Ye oowari netoyi sosorango gugumi oorooteku, ngu yoya, ngu gura ma yokootoyi biyomi yewero, eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ngundiro etoni, ene oowari manongoyingo gugumi yowuruwooro, siriyootoyi, si kande eraya kegidemboro eraya angeyingo. Ngu oowari oomanongoyingo kandeguraga, ngu netoyi, gumi oodoni, ngundiro siriyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Oni simoo bare ngu oo songo gura onindo ma teweroyimu, ngu Yisasdo tetoni kenoro eyingo. Hamoo oorengo, nga oningga nga, ene Anutro ingondudu eyingo oni Mosesndo sobowooyi, ero ewoku, ngu nga oninggaku nga! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ene ngundiro etoyi ngu, arisa, Yisas ene ingoyingo. Oni simoo baredo ene dowooro, enengo mera nga oo bidodo sobosobo urungga yeweroyimboro ingoyingo. Ngundiro nguro, Yisas enesu nangge oororo, mera purimo ooreyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ngu narungga ngu suwoo tetoni, Yisasro kirikiri oniku sono koongeyingomo uyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ene wanggo gura sanganimo oorero, ene sono koongeyingo kewooro oorengowoore oorowuyingo. Ene Kapeniyam endemo uroorewero oorowutoyi suwooteyingo. Suwootetoni, Yisas eneno ma tunooteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ngu naruno nguno, doogo yanggango urungga oorengo yootoni, sono koongeyingonggaku tookero, pikipokuri urungga yeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ene wanggo woosooro bodaga oriroko (Kilomita) kandegura (5) ngundi kandegura gidemboro guranangge (6) ngundiro oororo ngu, ene Yisas kenootoyi, sono koongeyingo sanganiwoore eneno ombuyingo. Yisas yade oororo, wanggo tanggeyimo ombuwero tetoni, nguro enengo kirikiri oniku sosoreyingo urungga oorengo teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ene Yisasdo enengo sosoreyingo ngu yeyoro ingoro, nguro ene sodedomangge eyingo. Ye ma sosorewero! Nondo nangge, yeno ombutenoku nga! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ene ngundiro etoni, arisa, enengo kirikiri onikundo Yisas wanggo sanganimo ooreni ero etoyi, nguro ene sanganimo ooreyingo. Ooretoni, wanggo ngu naruno nangge, merangga sawero ewonggoku, nguno tunooteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Sengetoni, oni simoo bare sono koongeyingo anduroko oruwonggo. Ene ngandiro ingowonggo. Kuyowo wanggo guranangge oodoni, nguno Yisas ooretoni, ngu ma kenoyingo. Kini, enengo kirikiri oni ngundo nangge wanggo ngu sanganimo oorero sawonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ene ngu naruno nguno, wanggo gidega Tayibiriyas endemonggo ngu mayero, sagigo oni simoo bare oorootenggoku, nguno gosiyoyingo. Ngu musiyonggano, nguno Yisasdo kuri oomanongoyingo Anutno esosootero yunootoni, neyingo meranggano nguno. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Oni simoo baredo, ngu Yisas enengo kirikiri oni nguya, ereweyeroro, ene nguno ma yeyoyingo. Ene ma yeyoro, nguro ene wanggo gidega sanganimo oorero, Yisas erewero Kapeniyam endemo oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Oni simoo bare ngu Yisas sono koongeyingo anduroko kenoro, sumoo inoro eyingo. Oo etuyeroyingo oni urungga, ge ndawu narunggano ngano mayewo? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ene ngundiro sumoo etoyi ngu, asa, Yisasdo mande gumi ero eyingo. No hamoo oorengo, yeno eteno. Ye oo songo gura onindo ma teweroyimu, nondo tetoowe tunooteteku ngu, ye ma kenoro ingoro, nguro ye no erewenerootenggo. Kini, ye no erewenerootenggoku nguro damoni ngandiro. Ye oomanongoyingo newonggoku, ngundo kawuye pakini yewoku, nguro ye no erewenerootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ye oowari ngundiro biyomi yeweroyi, nguro nangge, ma koyi tero yowero. Kini, ye komo oowari sugi sugi oruweroyi nguro koyi teya yoyi. Ngu oowaringga ngu Oni Nangoni ngundo ye yunowa. Yo, enengo eweyimbo ngu kongga nguro eneno ero rogo tewo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ngundiro etoni, enebana Yisasno sumoo inoro eyingo. Noore komo ndadiro tero, noore Anutro ko ngu tewato? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ene ngundiro sumoo etoyi, asa, Yisasdo gumi ero eyingo. Anutro koni ngu ngandiro. Ye komo nga oningga Anutdo sureyootoni, ombuyingo, nguro ye nowoondoyemo hamoo teyi, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ngundiro etoni, enebana Yisasno sumoo eyingo. Ge ndadiro oo songo gura onindo ma teweroyiga ge tewaku, nguro noore ngu kenoro, gengo mandege ingootooye, nowoondonanimo hamoo tewa? Ge ndawu kongga tete? ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Noorengo osi sambanani, ene kuri oni kini merako ootooro, nguno ene oowari gura yoro neyingo. Ngu oowaringga ngu oowooyi Mana. Anutro mandeno ngandiro ero eyingo. Ene sambo endeboro oowari ngu yunootoni, yoro neyingo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ngundiro etoyi, Yisasdo eyingo. Hamoo oorengo, no yeno eteno. Mosesndo sambo endeboro oomanongoyingo ye ma yunoyingo. Kini, noro Awane ngundo sambo endeboro oowari oorengo ngu ye yunoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Nga oomanongoyingo hamoongga nga, ngu Anutdo sambo endemonggo oningga soweyootoni ombuyingongga ngu. Omburo, ngundo keta oorengo oruweroyi ngu oni simoo bare merako ngano oorootenggoku, ngu yunoote, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ngundiro etoni, onikundo Yisasno eyingo. Oni urungga, ge komo ngu oowari manongoyingongga ngu suwooyi sano noore yunoyato, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ene ngundiro etoyi, asa, Yisasdo gumi eyingo. Nondo nangge, no suwooyi sano keta oruweroyi nguro oomanongoyingo oorengo. Oni ene nono omburo ngu, ene oowariro ko ma kumoowa. Ngundiro nangge, oni noro newendemo hamoo teteku ngu, ene sonoro ko ma ingoro hahangewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nondo yeno eteno. Ye kuri no neyowonggoku, ene ye nono nowoondoyemo hamoo ma teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Oni simoo bare bidodo ngu Awando no nunootoni, ene nono ombuwanggo. Oni nono ombuwanggoku, ngu nondo ene ma oweyerootoowe, sawanggo. Hamoo oorengo kini! ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","No sambo endemonggo ombuyingo ngu, no nenengo ingondudune keyowero ma ombuyingo. Kini, no mera ngano ombuwonoku ngu, noro Awane, ngundo no surenerootoni, ombuwonokungga, nguro ingonduduni nangge keyoro ombuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","No surenerootoni ombuyingo, Awanengga nguro ingonduduni, ngu ngandiro. Oni simoo bare ene kuri no nunoyingo, no ngu gura ma yokowano. Kini, no komo naru wengamo ko yokutuyerootoowe, ootoogewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Noro Awanemboro ingonduduni ngu ngandiro. Oni bidodo nangoni kenoro, nguro nowoondoyemo hamoo tero ngu, asa, ene suwooyi sano sugi sugi ketangga ngu yowanggo. Nondo kootuyisina naru wengamo ko yokutuyerootoowe ootoogewanggo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yisasdo eyingo. No nangge, no nga oomanongoyingongga ngando sambo ende ngu yokoro, ombuwonoku nga! Yisasdo ngundiro etoni, nguro Yuda onindo ngu ingoro sanggiri tero, mande mande urungga eneya eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Enendo eyingo. Nga Yisas oningga nga, ngu Yosepro nangoni. Noore enengo eweyi nemi nguya ingooteto. Ndadiro nguro, ene ngandiro ete. Nondo sambo ende yokoro ombuwonowo, ero ete? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ene mande ngundiro etoyi, asa, Yisasdo mande gumi ero eyingo. Yengo nangge mande oowooyingga ero, ma boguwooro oruwero. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Oni gura kingo nono ma ombuwa. Kini, Awando no sowenerootoni, ombuwonoku, ngu enengombo oni gura ingoyingo inootoni, ngunonggo ene nono ombuwaku ngu, asa, naru wengamo, nondo yokutuwootoowe, ene ko keta ootoogewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Mande nga ngu, Anutro ingondudu eyingo oniro nakayano ooroote. Anutdo oni simoo bare bidodo etuyerowa, ero eyingo. Oni bidodo ene Awaro mandeni ingoro yootenggoku ngu, asa, ene noro nguya ingootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Oni gurado ene no Awane kuri ma kenoyingo. Kini, nga oningga ngando nangge, ene Anut tanggeyimonggo ombuwoku, ngundo nangge ene Anut kenoro oruwori. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Hamoo oorengo, no yeno eteno. Oni noro newende hamoo tewaku ngu, ene ngu suwooyi sano sugi sugi keta oruwa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nondo nangge, no oowari manongoyingo oorengo suwooyi sano keta oruweroyiga ngu! ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Kurimi yengo osisambayebo, ene oni kini merako oruwonggoku, nguno ene Sambononggo Mana nero, ene kuri kumoomukoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ene nga oowari manongoyingo hamoongga, ngu sambo endemonggo yokootoni, merako ngano ombuyingongga nga, oni ngu nero ngu, ene ma kumoowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","No nga oomanongoyingongga nga ngu, suwooyi sano keta oruweroyiga nga sambo ende yokoro, merako ngano ombuyingo. Oni gura ene ngu oowari manongoyingongga ngu nero ngu, ene suwooyi sano keta oruwa. Yo, hamoo, nenengo gowene nga ngu, mera ngaro oni simoo barero wooro yeweroyimboro yunootoowe, ene nguno suwooyi sano keta oruweroyiga ngu yowanggo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ngundiro etoni ngu, Yuda onindo enengo nangge ronggeyoro eyingo. Ndadiro nguro, nga oningga ngando enengo songgiwi ngu noorendo neweroyi yunowa? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ene ngundiro etoyi, nguro Yisasdo Yuda onino ero eyingo. Hamoo oorengo, no yeno eteno. Ye Oni Nangoni, nguro songgiwi ma nero, ko ye ngu oningga nguro sidu daroni nguya ma nero ngu, asa, ye suwooyi sano ketangga ngu yengombo ma yowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Oni ene noro songgiwi nero, ko sidu darone nguya newaku ngu, ene suwooyi sano gome keta oodoni, nondo naru wengamo yokutuwootoowe, ko keta ootoogewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ndadiro nguro, noro songgiwine, ngu oowari oorengo, ko noro sidu darone ngu, neweroyi sono gome oorengo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Oni ene noro songgiwine, sidu darone nero ngu, ene noya oodoni, no eneya oruwaro. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Awa ngu ene suwooyi sano sugi sugi oruweroyi keta ngudodo, ngundo no surenerootoni ombuwono. Nguro ngu, no keta yanggango Awanemo oorooteno. Ngundiro nangge, oni no nonero ngu, ene ngunonggo yanggango yoro, ene noya sugi sugi keta oruwaro. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ngangga nga ngu, ene oowari manongoyingo oorengo sambo endemonggo soweyootoni ombuyingo. Nga ngu kuri osi sambado oomanongoyingo nero kumooyingo, ngundiro kini. Oni nga oomanongoyingongga nga nero ngu, ene suwooyi sano keta sugi sugi oruwa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yisasdo Kapeniyam ende nguro yowuru ya newendemo, nga mandega nga ero etuyeroyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Arisa, kirikiri oni oowooyingga Yisasro mandeni ngu ingoro eyingo. Nga mandega nga ngu, kowuri oorengo. Onendo ene mete ingowa? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ene Yisasdo newendemonggo ingooteku ngu, kirikiri onindo mande nguro boguwootoyi, nguro eyingo. Nondo nga mandega etenoku, ngando yengo ingonduduye yomburiyoote, bine? ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Arisa, ye Oni Nangoni kuri sambo endemo oruwoku, nguno ko ooretoni, kenoro ngu, ye ndadiro ewanggo? ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Yuka Kundingiyi, ngundo oni suwooyi sano keta oruweroyi ngu yunoote. Ene oni enengombo oni keta yunoweroyi ngu ereremo kini. Ene nga mandega nondo ye yunoro etenoku nga ngu, ene Yuka Kundingiyi ngundo yeni, ene suwooyi sano keta oruweroyiga, ngu yeno oruwa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ene Yisasdo ene kurimimonggo oni ene kewooroyemo, nowoondoyemo hamoo kini ngu ingoro, ko kootuyisina, oni ngundo ene dowooro, mundi oni kandeyemo yeweroyi nguya, ene kuri ingoyingo. Ngundiro nguro, ene ngandiro eyingo. Ye kewooroyemo nguno oni gidarega ngu, ene nowoondoyemo hamoo ma teyingo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Yisasdo mande ngu soweyoro eyingo. Ngu muringgano nguno, no yeno eteno. Ene Awando yo ero ma etoni ngu, asa, ngu oningga ngu ene nono ombuweroyi nguya kini, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Yisasdo mande ngundiro etoni, nguro enengo kirikiri oni urungga ene Yisas yokoro, enengo endemo ko sayingo. Ene Yisas keyoro, ko ma endeyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ngundiro tetoyi, Yisasdo yowoorengoro, enengo kirikiri oni kande eraya kegidemboro erayaga, nguno ero eyingo. Ye nguya bine, no noyokoro sawanggo? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ene ngundiro etoni ngu, Sayimon Pitando gumi ero eyingo. Oo Bidodo Simburi Simbunani Urungga, noore ndawu oninggano oorowuwato? Gengo mandege ngu suwooyi sano keta gome oruweroyimboro yunoote. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Noore nowoondonanimo hamoo tetoni, ngandiro kuri inooteto. Ge nangge, oni kundingiyi Anutdo sowenggerootoni ombuyingo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yisasdo enengo kirikiri onikuro mandeye gumi ero eyingo. Yo, hamoo, nondo ngu ye kande eraya kegidemboro erayaga kuri rogoyerowono. Ene ye kewooroyemo nguno, oni gurano booro biyomi eneno ooroote, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yisasdo ngu Yudas, Sayimon Iskariyoot nangoningga, nguro eyingo. Ngu oningga ngu Yisas enengo kirikiri oni kande eraya kegidemboro erayaga nguromu gura. Enendo kootuyisina Yisas dowooro, mundi oni kandeyemo yetoni ureyi kumoowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ngu naruno, Yisas ene Galili mera nguwoore ko tero, oororo omburo tero, ene Yudiya merasina ko oorowuwero ma ingoyingo. Ndadiro nguro, Yuda onindo ngu ureyi kumoowero teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Yuda oniro naru kundingiyi, oowooyi Towimbo ya Tookoododo (Sel Ya) Naru Kundingiyi, ngu namoko. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ngundiro nguro, enengo konedoboongombo Yisasno eyingo. Ge komo ootoogeya, nga endega nga yokoya, ge Yudiya merako oorowu. Gengo kirikiri oni ngundo ene mete gedo ko teteku, ngu kenowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Oni gura ene tunoo oni doongeyemo oruwero ngu, ene oo tewero nguya, kombitero ma tewa. Yo, ge ko oo nga tunoo tewaku ngu, asa, oni simoo bare bidodo doongeyemo ge tunoo dikaro, ko mete tero etuyerowa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Yisas enengo konedoboongo nguya, Yisasro nowoondoyemo hamoo kini. Nguro ene ngundiro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ngundiro nguro, Yisasdo eyingo. Noro narune, ngu ma tunooteyingo. Ene naru bidodo ngu yengo naruye. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Mera ngaro oni simoo baredo yeya mundi ma tewanggo. Kini, ene ngu noro mundi oni tewanggo. Ndadiro nguro, nondo enengombo muri biyomi tetenggoku, ngu yootunoro etenoku nguro. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Yengombo ooroya, ngu naru kundingiyingga ngu kenoyi. Kootuyisina no nguya naru kundingiyingga nguno oorowuwanoku, ene ataga no nguno, no ma oorowuwano, eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yisasdo ngundiro ero, nguro ene sa naru gidega Galilino oruwo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Yisas enengo konedoboongo ene naru kundingiyi ngu kenowero kuri Yerusalemno oorowuyingo. Kootuyisina, Yisas ene nguya Yerusalemno oororo, ene oni doongeyemo tunoo ma oorowuyingo. Kini, ene torige naru kundingiyi nguno oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Yuda onindo, naru kundingiyi nguno, ene erewero eyingo. Yisas oningga ngu ndano ooroote? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Oni simoo baredo Yisasro mande mande urungga oorengo, enengo nangge eyingo. Oni gidaregado, ene oni gome, etoyi, gidaregado eyingo. Kini, ngu oningga ngundo simoo bare ganaganayeroro endeyoote, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ene Yuda tabango oniro sosorero, nguro oni gurado Yisasro mandeni tunoo ma ero endeyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Naru kundingiyi ngu kewooroko, Yisas ene yowuru ya nguro yasiriko uro, oni simoo bareno mande ero etuyeroyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Yuda oni mandeni ngu ingoro, nguro ingondudu urungga tero eyingo. Nga oningga nga, ndanonggo ingoyingo nga yoro, ete? Ene kuri ngu oo nguro ingondudu yowero ma Skul teyingo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ngundiro etoyi, Yisasdo enengo mandeye gumi ero eyingo. Nga mandega nondo yeno etenoku nga, noro mandene kini. Nga mandega nga ngu, Anutromu. Enendo no surenerootoni, no ombuyingo nguro mandeni eteno. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ene oni gura Anutro mandeni keyoro ingowero ngu, ngu oningga ngu, ene nga mandega ero etuyerootenoku, ngaro muri ingowa. Ene ngandiro ingowa. Nga mandega nga, ngu Anutro ingondudunonggo bine, ngundi no nenengo ingondudunemonggo eteno bine, ngu wirikoya ingoyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Oni enengo ingondudunimonggo, mande mande ewaku ngu, ene nguno oowooyi bingamidodo teweroyimboro tete. Ene oni ene sureyootoni, ombuyingongga nguro oowooyi bingami ero okoowaku ngu, asa, ene oni nenengo oorengo tero, ene godange ma ewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Kurimi Mosesndo mamana mande ye yunoyingo. Ene ye kewooroyemo nguno oni gurado ngu mamana mandega ngu ma keyoote. Ndawugaro, ye no nurewero ingondudu tetenggo? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ene ngundiro etoni, simoo baredo mandeni gumi eyingo. Geno oombooro biyomi gura oorooteku ngu! Onendo ge gureni kumoowa? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ene ngundiro etoyi ngu, Yisasdo mandeye gumi ero eyingo. No kuri oo songo gura onindo ma teweroyi ngu tewonoku, ye ngu kenoro nguro soriyokowonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mosesndo goweye doongooro yomosiyoweroyi mande muringga ngu ye yunoyingo. Hamoo, ngu muringga ngu Mosesno ma tunooteyingo. Kini, ngu muringga, ngu osi sambano tunooteyingo. Ene yendo ngu yengo nangosumooye ngu, Sabat naruno nguya goweye doongootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Yendo ngu Mosesro mamana mande ngu keyowero ingoro, ye nangosumooye gura Sabat naruno tunootetoni ngu, asa, ye Sabat naruno goweyi doongooro yomosiyootenggo. Arisa, nondo ngu Sabat naruno nguno, no oni gura sayidodomu yomosiyootoowe ngu, yendo ndawugaro nguro noya sanggiri tetenggo? ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ye oo doongeyembo nangge kenoro, nguro ero ma wirikowero. Kini, ye komo oo bidodo muri gome nenengo nguno wirikowanggoku, ngu metemi, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Yerusalem ende nguro oni simoo bare gidaregado ero eyingo. Ndadiro nguro, nga oningga nga nangge ureyi kumoowero tetenggo? ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Kenoyi, ene mande mande tunoo oorengo eteku nga, ene oni ururu ngundo mande gura eneya ma etenggo. Ene nguya bine nga oningga nga ene Krayis, ero ingootenggo? ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ene noore nga oningga ngaro endeni ngu noore ingooteto. Krayis tunootewero naruno ngu, oni gurado nguro endeni ngu kenoro ingoweroyi kini, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yisas ngu Tembel ya newendemo ootooro ngu, onino mande ero etuyeroro oode, ngunonggo ene manggaru tero eyingo. Yengo ingoyingoyemo ngu noro ingoro, ko noro endene nguya ingootenggo. Ene no nenengo ingonduduno ma ombuyingo. Kini, Awando surenerootoni, no ngano ombuyingo. Awa enengo murini ngu hamoo oorengo, ene yendo nguro ma ingootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ene nondo ngu Awane ingooteno. Ndadiro nguro, no kuri eneya oruworo, enendo no surenerootoni, ngano ombuwono, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ngu naruno, ene dowooro ya biyomimo yewero teyingo. Ene Yisasro naru ma tunooteyingo, nguro oni gurado Yisas dowoowero ma teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ene oni simoo bare oowooyingga Yisasro nowoondoyemo hamoo tero eyingo. Krayis omburo ngu, nga oningga ngando oo songo gura onindo ma teweroyimu teteku, nga dagaro enendo oo urungga oorengo tewa, bine? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Parisi oni ingootoyi, oni simoo baredo Yisasya mande guradiro guradiro eyingo. Ngundiro nguro, Anutno wooro yeweroyi nguro sobosobo oni, ko Parisi oni nguya, ngundo enengo kumba ootuwoo oni gidarega sureyerootoyi, Yisas dowooro, ya biyomimo yewero oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ngu naruno nguno, Yisasdo eyingo. Naru bodaga nangge no yeya oode, Awando surenerootoni, no ombuwonokungga, ngu tanggeyimo no ko oorowuwano. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","No oorowuwanoku, ene ye no ereweneroro, ko ma neyowanggo. No oorootenoku endegano nguno, ye nguya oorowuweroyi kini, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ene ngundiro etoni ngu, asa, Yuda oni enengo nangge mande mande ero eyingo. Ene ndawoore utoni, noore ene ko ma kenowato? Ene bine, noorengo dobookurinani, Girik oni, enengo mera kewoorokono uro, nguno Girik oni, mande yunoro etuyeroro oodoni, nguno noore ene ma kenowato? ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Mande eteku, nguro damoni ndadiro ete? Ene ngandiro ewo. Ye no ereweneroro, ye no ma neyowanggo. Nondo endega oorootenoku, nguno ye nguya, ma oorowuwanggo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Kundingiyi naru wengangga, ngu enengo naru kundingiyi urungga. Ngu naruno nguno, Yisas ootoogero, dikaro, manggaru tero eyingo. Oni gura gura sonoro ingoya ngu, arisa, ene komo no tanggenemo ngano ombuya, sono nga neyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ngungga ngu, Anutro mande nakaya ngundo ngandiro ete. Oni ene noro ingootoni newendemo hamoo tero oorooteku ngu, ene newendemo ngunonggo suwooyi sano sugi sugi keta oruweroyi, nguro sono urungga oorero urooruwa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yisasdo Yuka Kundingiyi oo nguro eyingo. Oni simoo bare ene Yisasro nowoondoyemo hamoo tero, ngundo ngu Yuka Kundingiyi yowanggo. Ene ngu narunggano nguno, Anutdo Yisas enengo duridarini ngu yoro ma teyinoyingo. Nguro ngu, Anutdo Yuka Kundingiyi nguya ma soweyootoni ombuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Oni simoo bare gidarega, ngu mandega ngu ingoro eyingo. Hamoo oorengo, nga oningga nga ngu, ene Anutro ingonduduni eyingo oni, noore sobowootetokungga ngundo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ene ngundiro etoyi, gidaregado eyingo. Ene Krayis Anutdo noore ko yoyoweroyi sunggi yeyingo oni ngu! Etoyi, ene oni gidaregado eyingo. Galili merako nguno Krayis mete tunootewakuro bine? ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Kini, Anutro mande nakaya ngundo kuri ete. Krayis ngu Dewitro soweni nguromu. Ngu Betelehem endemo nguno tunootewa. Ngu endega ngu Dewitdo kuri oruwo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Nguro ngu, simoo bare usowooro wata erayaga tetoyi, wata gurado Yisasya sanggiri tero, mundi teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Yo, hamoo, oni gidaregado dowooro ya biyomimo yewero eyingo. Ene oni gurado kandeyi sodedo Yisasno ma yero dowooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ngundiro nguro, kumba ootuwoo oni ene Tembelno ko oorowutoyi, wooro yeweroyi sobosobo onindo, ko Parisi onindo ene yeyoro eyingo. Ye ndawugaro, Yisas oningga ngu yoro ma ombuyingo? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ene ngundiro etoyi ngu, asa, kumba ootuwoo onikundo mande gumi ero eyingo. Kurimi oni gurado ngundiro ingondudu mandega ande oningga andedo mande eteku, ngundiro ma eyingo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ngundiro etoyi, Parisi onindo sanggiri tero, mande gumi eyingo. Enendo ye nguya ganayeroote bine? ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Noore tabango oni, ko Parisi oni nga kewoorokono gura kenootoyi, ene ngu Yisas oningga, nguro newendemo hamoo tete, bine? Hamoo oorengo, kini! ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ene nga oni simoo bare nga ngu, ene mamana mande ma ingootenggo. Nguro ene Anut doongeyimo kuri biyomi yemukowonggo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodimas ngu naru gurano Yisas tanggeyimo oorowuyingo, ene nguya ngu tabango oni nguromu gura, ngundo sumoo eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Noorengo mamana mande ngando oni mandeni ma ingoro, nguno mete wirikowa, bine? Kini, koretero noore enengo mandeni wirikoro ingorogogo, nguno ngu, noore mete oo enendo teteku, ngu gome oorengo ingowato, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ene ngundiro etoni ngu, asa, tabango onikundo mandeni gumi eyingo. Ge nguya Galili oni, binengga? Anutro mande nakayano oorooteku, ngu gome kandangeya ingo. Anutro ingondudu eyingo oni gura Galili merako ma tunootewa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Oni simoo bare bidodo enengo yano samukootoyi, ene Yisas Olib purimo ooreyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Sengetoni suwoononggo, Yisas ene ootoogero, Tembel yasiriko oorowuyingo. Nguno oni simoo bare bidodo Yisas tanggeyimo omburo yowuruwootoyi, Yisasdo mande ero etuyeroro bibitero oruwo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ngu naruno, mamana mande etuyeroyingo oni, ko Parisi oni, ngundo ooreko ooreko bare gura enengo kameyi yano oodoni, ene oororo simoo guraya wedoni, kenoyingo. Ngundiro muri biyomi tetoni, nguro kenoro, yoro ombuyingo. Oni Yisasya yowuruwooro oodoyi, ngu kewooroyemo yeyi dikayingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ene ngundiro tero, Yisasno eyingo. Oo etuyeroyingo oni, nga barega nga ngu enengo kameyi oodoni, ene oororo, simoo gidaregaya sebobarese tero endeyootoni kenowonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mosesro mamana mande ngundo nooreya ngandiro ete. Bare gura ngundiya tetoni nga ngu, asa, digi yoya, yudoyiga kumooyi, ero eyingo. Ene gedo ngu ndadiro ete? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ene Yisas towoongowero ero ngundiro teyingo. Ene nguno Yisasdo mande biyomi gura etoni, ene ngunonggo Yisas yoro, mande wirikoyingo onino yero, ene ganangoro, mande godangengga etoningga ingowooto, ero teyingo. Ene ngundiro sumoo etoyi, Yisas ene nenetero, merasina bagootero, kandedibiyibo mera bungomo nakangoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ene ngundiro tetoni, tabango onikundo sumoo sumoo urungga ero oodoyi, asa, Yisasdo ootoogero eyingo. Ye kewooroyemo nguno, oni gura ene weti mbumbuwani kiningga, ngundo ene mete koreteya, digi yoya, nga barega nga bungomo oorongooni, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Yisasdo ngundiro ero yokoro, asa, ene merako ko bagootero, mera bungomo ko nakangoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Tabango oniku mande ngundiro ingoro, ene bidodo gura nangge nangge endesina ooreyingo. Oni tabango urungga ene mande damoni yero ewoku, ngundo oorero toongetoni, songoku bidodo ende oorero samukoyingo. Yisasdo enesu nangge bagootero oodoni, ko barega ngundo nangge Yisas tanggeyimo dikaro oruwo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yisas ootoogero, dikaro, baregakuya ero eyingo. Bare, oni geya ewonggoku, ndano? Oni gura ngano, gengo biyomingge, ngu eweroyi nguya kini, bine? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ene mande ngundiro etoni ngu, barega ngundo gumi eyingo, Oni Urungga, ngano oni gura kini. Etoni, Yisasdo gumi eyingo. No nguya gengo biyomingge nguro ma ewano. Ge toongero, kootuyisina weti mbumbuwa gura ma tewero, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yisasdo ene ko eyingo. No ngu mera ngaro soru himi. Oni ene no neyoro keneroro ngu, ene ooreriko ma endeyowa. Kini, enengo keta oruweroyiga ngu, ene soru himidodo oruwa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ene mande ngundiro etoni, asa, Parisi onindo Yisasya ero eyingo. Ge, gengomboro mandege ero wesiyoote. Ngundiro nguro, gengo mandege ngu hamoo kini, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yisasdo mandeye ngu ingoro, gumi ero eyingo. Ngu hamoo, nondo nenengo mandene yootunoro eteno. Ene noro mandega ngu hamoo oorengo. Ndadiro nguro, no nenengombo ootoogero ombuwonomu endega ngu ingooteno. No nganonggo nguno oorowuweroyi ngu, no ingooteno. Ene yendo noro ende damoni ngu ma ingootenggo. No ndawoore toongewanoku nguya, ye ma ingowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Yendo ngu mera ngaro murinimo oni wirikoyerootoyi, ene nondo ngu oni ma wirikoyerooteno. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ene nondo oni wirikowero ngu, no oni gome nenengo wirikowano. Ndadiro nguro, nondo noso nangge oni ma wirikoyerooteno. Kini, Awane no surenerootoni ngano ombuyingongga, ngu noya gobooro ko tetero. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Yengo mamana mandeno ngu ngandiro ooroote. Oni eraya enengo mandeyari ero wesiyooteriku, ngu guranangge etori ngu, asa, ngu oni erayaga nguro mandeyari, ngu hamoo, eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","No nenengo mandene wesiyoro etoowe ngu, Awando no surenerootoni ombuwonomu, ene nguya noro mande wesiyoro ete, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ene ngundiro etoni ngu, asa, ene Yisasno sumoo eyingo. Gengo Awangge ndano ooroote? Etoyi, Yisasdo mandeye gumi ngandiro eyingo. Ye noro ma ingootenggo. Nguro ngu, ye noro Awane nguya ma ingootenggo. Ene ye noro ingoro ngu, ye Awane nguya ingowanggo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yisasdo nga mandega nga ngu, Beye yeweroyi ya gumimo eyingo. Ene oni simoo bare Tembel ya newendemo oorootenggoku, ngu mande ero etuyeroro oriyingo. Ene oni gurado ene dowooro, ya biyomimo ma yeyingo. Ndadiro nguro, Yisasro naruni ma tunooteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yisasdo ko eyingo. No toongetenoku nga, ye no ereweneroro ma neyowanggo. Ye weti mbumbuwa tero oode ngu, asa, ye kumoowanggo. Ye nondo musiyongga oorowutenoku nguno, ye ma oorowuwanggo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ngundiro etoni, Yuda tabango onindo enengo nangge mande ero eyingo. Ndadiro nguro, Yisasdo ete? Ye nondo musiyongga oorowutenoku, nguno ye ma oorowuwanggo, ete. Enengombo enengo ureni kumoowero bine ete? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ene ngundiro etoyi, Yisasdo gumi eyingo. Ye ngu ameno, no ngu awuno. Yo, hamoo, ye ngu mera ngaromu, ene no ngu mera ngaromu kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ngundiro nguro, no yeno kuri ewonoku ngu. Ye kumootoyi ngu, yengo weti mbumbuwa ngu yengomo oruwa. No tambu eraya yeno eteno. Ye no nga oningga ngando yeno etenoku, ngu nowoondoyemo hamoo ma tero ngu, arisa, ye kumootoyi ngu, yengo weti mbumbuwaye yengomo oruwa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ene ngundiro etoni, asa, Yuda onindo gumi eyingo. Ge onendo? Ngundiro etoyi, Yisasdo gumi eyingo. Nondo, no nga oningga ngando no kuri yeno ewonoku ngu! ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","No mande oowooyingga, no komo yengomo yengo muriyemo ewono. Nondo yengo muriye ngu, mande wirikoyingo oni ngundiro mandeye wirikowano. Ene oni no surenerootoni ombuwonomu, ngu enengo murini ngu hamoo oorengo. Mande bidodo no eneno ingowonomu, ngu nangge, no mera ngaro oni simoo bareno ero etuyerooteno, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Yisasdo eweyimboro mande ewoku ngu, Yuda onindo ngu nenengo ma ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yisasdo eyingo. Kootuyisina, yendo Oni Nangoni dowooro, boorowoowanggoku, ngu narunggano nguno, ye noro tunoo oorengo ingowanggo. Nondo nenengo ingonduduno ko oo gura ma teteno. Kini, no mande ero, wesiyoro etuyerootenoku nga ngu, Awando ene kuri no etuneroyingo, ngu nangge eteno. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Awando no surenerootoni, no mera ngano kuri ombuwonomu ngu, ene Awa noya ooroote. Ene no ma noyokootoni, noso nangge ma oorooteno. Kini, suwooyi sano no Awando oo nondo tewero ingooteku, ngu nangge tetenoku, nguro ene oni oni tete, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yisasdo ngundiro etoni, oni simoo bare urungga oorengo, enengo mandeni ngu ingoro, nowoondoyemo hamoo teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yisasdo Yuda oni ene kuri enengo nowoondoyemo hamoo tetenggoku, nguno eyingo. Ye noro mandene nga gome ingoro yoro, dowooro, keyoro ngu, arisa, ye ngu noro kirikiri oni oorengo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ye ngu Anutro hamoo mande ngu ingowanggo. Hamoo mande, ngundo ye hoorooweyerootoni, yengo endeyoyingo ngu gome sobowooro, nguno ye kingo ko oni ma oruwanggo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Yuda onindo Yisasro mande ngu ingoro, gumi eyingo. Noore ngu Ebarahamro soweni. Noore naru gurano, oni guraro kingo ko oni ma teyingo. Ndadiro nguro, ge ngundiro ete, ge kingo ko oni ma oruwanggo, ero ete? ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Etoyi, Yisasdo mandeye gumi eyingo. Hamoo oorengo, no yeno eteno. Oni bidodo weti mbumbuwa tetenggoku, ngu ene weti mbumbuwaro yanggangoni, ngundo gosiyeroro witumooyerootoni oorootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Hamoo, kingo ko oni ngu, ene ya simburi nguro nangoni ngundiro kini. Kini, enengo nangoni oorengo, ngundo nangge ene suwooyi sano sugi sugi oruwa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nguro ngu, Anutro Nangoni, ngundo yengo weti mbumbuwa ngu andange yunootoni ngu, asa, ngundo hoorooweyerootoni, ngunonggo yengo mbumbuwaro yanggangoni ngu andangero yokootoyi, ngundo ye ko ma soboyerowero. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","No ingooteno. Ye Ebarahamro soweni, ene noro mandene nga ngu, ye nowoondoyemo nguno ma ooroote. Ngundiro nguro, ye no nureyi kumoowero tetenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","No mande wesiyoro ero etuyerootenoku nga ngu, no kuri Awanembo oo etunerootoni, kenoro ingowonoku, ngu ero etuyerooteno. Ene yendo ngu yengo awayemonggo mande muri yoyingo, ngu tetenggo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ene ngundiro etoni, asa, Yuda onindo gumi eyingo. Noorengo awanani, ngu Ebaraham! Etoyi, Yisasdo gumi eyingo. Hamoo ye Ebaraham simoongo tetoni ngu, ye komo Ebarahamro murini ngu yoya keyoyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nondo kuri hamoo mande bidodo Anutro manggowoomonggo ingowonomu ngu, yeno ero etuyerowonoku ngu. Ene yendo ataga no nureyi kumoowero tetenggo. Ebarahamndo ene muri ngundiro ma teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ye ngu yengo awayemboro mande murini nangge tetenggo. Yisasdo mande ngundiro etoni, asa, Yuda onindo gumi eyingo. Namo garodo ene kuri buribari endeyoro, nguno noore ma bisiyeroyingo. Hamoo oorengo, noore ngu awanani guranangge, ngu Anut! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ene ngundiro etoyi, Yisasdo gumi eyingo. Ngu hamoo, Anut ngu yengo Awaye tetoningga ngu, asa, ye noro nguya ingowanggo. Ndadiro nguro, no Anutya oode, ngunonggo no nenengo ingondudunemonggo ma ombuyingo. Kini, Anutdo no surenerootoni, no ombuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ndadiro nguro, ye noro mandene ngaro ma ingondudu tero, nowoondoyemo siriyootenggo? Nguro murini ngu ngandiro. Ye noro mande nga ingowero yokoro, nguro ye nowoondoye ukingootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ye ngu, awaye Setan nguro simoongo! Ye ngu awayengga ngundo yendo oo tewero ingootenggoku, ngu nangge tewero gome ingoro, koyi tetenggo. Kurimi ngu, ene oni yureyi kumooweroyi, nguro nangge oruwo. Ene muri hamoo nenengo ngu ma keyoyingo. Ndadiro nguro, muri hamoo nenengo ngu eneno kini. Ene mande godange eweroyi muringga nguro simburi oorengo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ngu muringga ngunonggo nangge, ye nondo hamoo mande nga ero etuyerootenoku, ye nguro nowoondoyemo hamoo ma yoro siriyootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ye kewooroyemo nguno oni gurado nondo mbumbuwa tewonoku, ngu ingowoku ngu, arisa, wesiyoya etoningga noorengododo ngu wirikoro kenowato. Ene nondo weti mbumbuwa ma teyingo tetoni ngu, ndadiro nguro, nondo hamoo mande ero etuyerootoowe, ye nguro nowoondoyemo hamoo ma tetenggo? ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Hamoo, Anutro simoongo ngu, ene Anutro mandeni gome ingootenggo. Ene ye ngu Anutro simoongo kini. Ngundiro nguro, ye enengo mandeni ma ingootenggoku ngu! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yuda onindo Yisasro mandeni ngu ingoro, sanggiri tero gumi eyingo. Noore hamoo oorengo, geno eteto. Ge ngu Sameriya ende nguro oni gura. Nguro ngu, geno oombooro biyomi gura oorooteku ngu! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ene ngundiro etoyi ngu, asa, Yisasdo mande gumi ngandiro eyingo. Nono ngano oombooro biyomi gura ma ooroote. Kini, no nenengo Awanemboro oowooyi bingami ero okooteno. Ene yendo noro oowoone ngu yomburiyootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","No nenengo bingamine ero ma okooteno. Ene oni gurado (Anut) noro bingamine ero okoote. Ngu oningga ngundo noro murine wirikonerowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Hamoo oorengo, no yeno eteno. Oni gura ene noro mandene nga keyoro ngu, asa, ene ma kumoowa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Yisasdo ngundiro etoni, asa, Yuda onindo gumi eyingo. Noore ataga ingooteto. Geno oombooro biyomi gura oorooteku ngu! Ebaraham ngu kuri kumooyingo, ko Anutro ingondudu eyingo oni nguya kuri kumoomukoyingo, ene gedo ngandiro ete. Oni gura ene noro mandene gome keyoro ngu, ene ma kumoowa, ero ete. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ndadiro nguro? Gedo bine noorengo osinani Ebaraham dagate? Ene kuri kumooyingo. Anutro ingondudu eyingo oni nguya, ene kuri kumoomukoyingo. Gengombo ngu ge oone, ero ingoote? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yisasdo mandeye ngu ingoro, gumi eyingo. Nondo nenengo oowoone bingami nangge ero okoowanoku ngu, asa, noro oowoone bingamine ngu kingo oo ngundiro tewa. Ene Awanembo noro oowoone bingamine ero okootekungga, ngu yendo noorengo Anut, ero etenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ene yendo nguro ma ingootenggoku, ene nondo ngu, no ene ingooteno. Ene nondo ene ma ingooteno, ero ewanoku ngu, asa, no yendo etenggoku, ngundiro godange oni tewano. Ene no enengo kuri ingootenoku, nguro ngu, no enengo mandeni ngu gome keyooteno. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Yengo osiye Ebaraham ngu, ene no tunooteweroyi narune nga kenowero, ene oni oni oorengo tero, sobowooro hahangero oruwo. Ebaraham ene kuri ingoyingo hamoo oorengo no ombuwano ero, ene newendemonggo gome ingoyingo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ene ngundiro etoni, asa, Yuda onindo mande gumi eyingo. Gengo dagoma onibi eraya kande eraga (50) kini, nguno ge Ebaraham kuri kenowono, ete? Hamoo oorengo kini! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ene ngundiro etoyi, asa, Yisasdo gumi eyingo. Hamoo oorengo, no yeno eteno. Kurimi oorengo, Ebaraham ma tunooteyingo naruno, no kuri oruwono, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Yisasdo mande ngundiro emukootoni ngu, Yuda onindo sanggiri tero, digi yoro, ngundo Yisas urewero oorongooyingo. Ene Yisasdo ngu oni ngu kewooroyemonggo ene kombitero, torige oororo, Tembel yasiri pawa ngu yokoro, endesina ooreyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yisas ngu ene oororo, oni doongeyi kiringo gura kenoyingo. Ngu oningga ngu nemimbo doongeyi kiringo ngundiro bisiyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Yisas enengo kirikiri onikundo sumoo inoro eyingo. Oo etuyeroyingo oni, onendo weti mbumbuwa tetoni, nguro nga oningga nga nemimbo ngandiro doongeyi kiringo bisiyoyingo? Nga oningga enengombo weti mbumbuwa tetoni, ngundi enengo eweyi nemimbo weti mbumbuwa tetori, bine? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ene ngundiro sumoo etoyi, Yisasdo mande gumi ngandiro eyingo, Nga oningga ngando weti mbumbuwa ma teyingo, ko enengo eweyi nemimbo nguya weti mbumbuwa ma teyingo. Kini, nga ooga nga ngu, ngano Anutro koni murini nguno tunoo oorengo teweroyimboro tunooteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Mera himi oodoningga, noore komo Anutdo no surenerootoni ombuwonoku, nguro enengo koni tewato. Ndadiro nguro, suwoo tunooteweroyimo ngu, oni gurado ene ko teweroyi kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","No mera ngano oorootenoku naruno ngu, simoo barero oore etuyeroyingo, nguro soru himi. Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ngundiro ero, Yisasdo merako muketero, muke ngu tetoni, nogoruyi yetoni, ngu yoro, oni doongeyi kiringongga ngu doongeyimo yeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Yisasdo ngu oningga nguya eyingo. Ge ooroya, Silowam sono koongeyingo ngu gimu, eyingo. Silowam mandega nguro damoni ngu ngandiro. Ene soweyootoyi oorowuyingo. Asa, ngu oni doongeyi kiringongga ngu oororo, Silowam sonono sono gimuro ombutoni, doongeyi metemi tetoni doongetero oo kenoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ngu oningga doongeyi kiringongga ngu, enengo ende gobooro oni, ngundo ene kuri kenoro ingoyingo. Nga oningga nga, ene oni simoo bareno digi beye ooro ngguyinggayi tero, kira eroruwo, ero ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Oni gidaregado eyingo. Yo, nga oningga ngando nangge. Etoyi, gidaregado eyingo. Kini, nga oningga ngandiro, ene ngu oningga ngu gura. Etoyi, ene ngu doongeyi kiringo oningga ngu enengombo eyingo. Ngu nondo nangge, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ene ngundiro etoni, simoo baredo oninggakuya eyingo. Ndadiro tero, ge doongengge metemi tewo? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ngu oni doongeyi kiringongga, ngundo mandeye ngu ingoro, gumi ero eyingo. Ngu oningga oowooyi Yisas ero etenggoku, ngundo no doongenengga nga, merako muketetoni, nogoruyi yetoni, ngundo no doongenemo nogoru yonggurumooro sureneroro ewo. Ge ooroya, Silowam sono koongeyingomo sono gimu, ewo. Ero etoni, nguro no oororo, sono gimutoowe, doongene metemi tetoni, no doongetewono, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ene ngundiro etoni ngu, onikundo ngu oni doongeyi kiringongga nguya eyingo. Ngu oningga ngu ndano ooroote? Etoyi, ngu oningga ngundo gumi eyingo. No watayi kini, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Arisa, ngu naruno, ene ngu oningga kuri doongeyi kiringongga ngu yoro, Parisi onino oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ngu narunggano nguno, Yisasdo mera yeni nogoruyi yetoni, ngundo oni doongeyi yeni, mete teyingo narungga ngu Sabat naru. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Arisa, Parisi onindo sumoo inoro eyingo. Ge doongengge ndadiro tero, ko metemi tewo? Etoyi, ngu oningga ngundo gumi eyingo. Ene mera nogoruyi yoro, doongenemo yetoni, no sonono oororo sonowootoowe, nguno doongene metemi tetoni, no mete oo kenooteno, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ngundiro etoni, Parisi oni gidaregado eyingo. Anutdo ngu oningga ngu, ma sureyootoni ombuyingo. Ndadiro nguro, ene Sabatro mamana mande ngu ma keyoyingo. Etoyi, Parisi oni gidaregado ewonggo. Ndadiro terogogo, weti mbumbuwadodo onindo, ngundiro oo songo gura onindo ma teweroyi, ngu tewa? Ngundiro ero, Parisi oni usowooro, wata eraya tunooteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Arisa, ngu naruno, Parisi onindo ko yowoorengoro oni doongeyi kiringongga nguno eyingo. Ngu oningga doongengge yeni metemi tewokungga nguya, ge ndadiro ete? Etoyi enebana eyingo. Ngu oningga ngu, ene Anutro ingondudu eyingo oni gura. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ngu hamoo, kuri ngu oningga ngu, ene doongeyi kiringo oorengo, ene ataga ngu doongeyi metemi tete. Ene Yuda onindo nguro nowoondoyemo hamoo ma teyingo. Nguro ngu, oni doongeyi kiringongga, metemi tewokungga, nguro eweyi nemi negoyeroyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ene oningga nguro eweyi nemi sumoo yunoro eyingo. Nga oningga nga yari nangoyari, bine? Nga doongeyi ngundiro kiringo biyomi, nemi gedo ngundiro bisiyoyingo, bine? Arisa, ndadiro tero, nguro ene ataga oo mete kenowa? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ngundiro sumoo etoyi ngu, eweyi nemimbo mande gumi eworiyo. Noore ingootero, nga ngu noorengo nangonari. Nemimbo bisiyootoni, ngunonggo doongeyi ngundiro kiringo yeyingomu, ngu noore ingootero. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ene ataga ngano doongeyi metemi teteku nga, ndadiro ngundiro tewoku, ngu noore nguya watayi kini. Onendo doongeyi yeni metemi tewoku, ngu nguya noore watayi kini. Ene kuri oni urungga nguro enengo sumoo inoya ingoyi, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Oningga nguro eweyi nemi ngu, Yuda oniro tabango oni nguro sosorero, nguro ene ngundiro eworiyo. Yuda onindo mande guranangge ngandiro ero gosiyoyingo. Oni gurado, Yisasro Krayis ero ewaku ngu, asa, Yuda oniro tabango, onindo ngu oningga ngu, yowuru yanonggo owetoyi, oorero toongewa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ngu muringga nguro nangge, eweyi nemimbo eworiyo. Ene kuri oni urungga nga, nguro ye komo enengo sumoo inoya, mande nenengo oorengo ingoyi, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ngu oni doongeyi kiringongga ngu tambu erayayigaku negongoro, nguno eyingo. Ge komo Anutro oowooyimonggo, ngunonggo ge mande nenengo oorengo, nooreno etooga ingowooto. Noore kuri ingooteto. Ngu oningga ngu gengo doongengge yomosiyowoku ngu, ene weti mbumbuwadodo oni! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ene ngundiro etoyi, oni doongeyi kiringongga ngundo gumi ngandiro eyingo. Ene bine weti mbumbuwadodo, ngundi kini, no nguro watayi kini. Ene nondo ngu oo guranangge ingooteno. Kurimi no doongene kiringo oruwonoku, ene ataga nga ngu no doongene metemi tete, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ene mande ngundiro etoni, asa, Yuda onindo ngu doongeyi biyomi oningga nguya ko eyingo. Enendo geno ndadiro tewo? Enendo ndadiro tero doongengge yeni metemi tewo? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ene mandeye ngu ingoro, gumi ero eyingo. No yeno kuri ewono. Ene ye ngu ma ingowonggo. Ndawugaro ye ko ingowero? Ye nguya enengo kirikiri oni tewero, bine? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ene mandeni biyomi eyinoro gumi eyingo. Gedo nangge enengo kirikiri oni teya ootoo. Ene noore ngu Mosesro kirikiri oni tero oorootetoku ngu! ");
INSERT INTO rwo_rawa_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Noore kuri ingooteto. Anutdo Moses mande kuri inoyingo. Ene ngu oningga ngu ndanonggo tunootewo, ngu noore ma ingooteto, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Tabango onindo mande ngundiro etoyi, oni doongeyi kiringongga ngundo gumi eyingo. Yengo mande etenggoku, ngu nenengo kini! Yendo ewonggo, ngu oningga ngu ndanonggo mayewo, noore watayi kini, ero ewonggo. Ene ngu oningga, ngundo no doongene yeni mete tewo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Noore ingooteto. Anutdo weti mbumbuwadodo oniro manggoye ma ingowa. Ene oni gura ene Anutno yambo mande tero, nguro ingonduduni manggowo keyootoni ngu, asa, Anutdo ngu oningga nguro mandeni nguya ingowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kurimimonggo omburo, ataga nga, oni gura nemimbo doongeyi kiringo bisiyootoni, oni gurado kootuyisina doongeyi yomosiyoyingomu, nguro mandeni ma ingooteto. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Hamoo oorengo, Anutdo ngu oningga ngu ma sureyootoni, omburo ngu, asa, ene ngandiro ko nga tewero ngu, ene ereremo kini! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ene ngundiro etoni, asa, Yuda tabango onindo sanggiri tero, mande gumi ero eyingo. Gengo nanggebo, ge weti mbumbuwa murimo bisigerootoni, ge weti mbumbuwaro oni oorengo tero ooroote! Ene ataga gedo noore mande yunoro muri gome ngu etuyerowero ete, bine? Yuda onindo ngundiro ero yokoro ngu, ene oni doongeyi kiringongga, doongeteyingo, oningga ngu yowuru yanonggo owero, ko eneya yambo mande ma tewero ero, roogo teyinoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yuda onindo ngu oni doongeyi kiringongga owetoyi toongetoni, Yisasdo ngu ingoro, ene ngu oningga ngu erewero kenoro, ero eyingo. Ge Oni Nangoni, nguro nowoondogemo hamoo tete bine, ngundi kini? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ene ngundiro etoni, ngu oningga ngu enebana gumi ero eyingo. Oni urungga, Oni Nangoni ngu oone? Ge nono etooga, no ene kenoro, nowoondonemo hamoo teni, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yisasdo mandeni ngu ingoro, gumi eyingo. Ge kuri kenowo. Ngu nga oningga ataga geya mande mande eterikungga nga! Eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Yisasdo mande ngundiro etoni, ngu oningga ngundo gumi eyingo. Oo Bidodo Simburi Simbunani, no nowoondonemo hamoo tete, ero, ene Yisas keyi damonimo bagootero, eneno yambo mande teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yisasdo eyingo, No merako ngano ombuwonomu ngu, simoo barero weti mbumbuwa yootunoro etuyerowero ombuwono. Ngundiro nguro, oni doongeye kiringo ngu ene doongetewanggo. Ene oni doongeye metemi oo kenootenggoku, ngu doongeye kiringo yetoni oo ma kenowanggo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Parisi gidarega, Yisas tanggeyimo oruwonggoku, ngundo enengo mande ngu ingoro, sumoo inoro eyingo. Noore nguya doongenani kiringo bine? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ene ngundiro sumoo etoyi, asa, Yisasdo gumi eyingo. Ye doongeye kiringo tero ngu, ye weti mbumbuwaye kini. Ene yendo ngandiro etenggo. Noorengo doongenani ngu metemi ero etenggokuro, nguro yengo weti mbumbuwaye, nguya sugi ooroote, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yisasdo ngandiro eyingo. Hamoo oorengo, no yeno eteno. Oni ene Sipsip nguro sisipawa newendesina yamukowoore ma uwaku ngu, ene sisipawa karongoro, sisipawa newendemo uteku, ngu oningga ngu, ene Sipsip yakakayi yoro, yutoro yoyoweroyi oni. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ene oni Sipsipro sisipawa nguro yamukowoore, newendemo uteku ngu, asa, ngu oningga ngu Sipsip nguro Simburi. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Sisipawa nguro sobosobo, ngundo ngu Sipsip simburiboro yamuko goosooyinoote. Ene yamuko goosootoni, Sipsip ngundo simbuye manggowo ingootoyi, simbuyebo enengo Sipsip oowooye ero mudiyerootoni, keyoro, endesina ooretenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ene Sipsip bidodo yoyoro, ende ooremukoro yokoro, arisa, simbuyebo koretero oorowutoni, Sipsip ngu, simbuye manggowo ingoro, ene keyoro kootu oorowutenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ene Sipsip ngu, oni gura manggowo songo ingoro, ene ma keyootenggo. Kini, ene sosorero songo songo sawanggo. Ndadiro nguro, ene oni songo guraro manggowo ma ingootenggo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yisasdo ngu mande adingayingga ngu etoni, ene onindo mandeningga nguro muri ma ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Nguro ngu, Yisasdo mande yootunoro, oni simoo bareno ko eyingo. No yeno hamoo oorengo eteno. Nondo nangge, Sipsipro sisipawa nguro yamuko. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Oni bidodo no koretenunoro ombutenggoku, ngu ene yakaka oni, ko yutoro enengo oo sobibiyoro yoweroyi oni. Ndadiro nguro, Sipsip ngundo enengo manggoye ma ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","No nenengombo nangge no yamuko. Oni gura ene nono omburo sisipawa newendemo uwaku ngu, ene imakeyingo ootooro, ene oni oni tero, ene sisipawa newendemo uro, ko enderoko oorero, oowari gome yoro nero oruwa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ene yakaka oni ngundo Sipsip yomosiyerowero ma ombute. Kini, ene Sipsip yakakayi yoyoro, yomburibariyeroro yureyi kumooweroyimboro nangge ombutenggo. Ene nondo ombuwonomu ngu, no yoyoro suwooyi sano keta oruweroyi ketangga ngu yunoweroyimboro nguro ombuyingo. Yo, hamoo, oni ene noro newendemo hamoo tetoni ngu, asa, no eneya keta oruweroyi ketangga ngu inootoowe, eneno angero oorero, ngunonggo sugi sugi hooroowero oruwa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Yo, hamoo, no Sipsip nguro sobosobo gome oorengo. Sipsip nguro sobosobo gome ngu, ene enengo Sipsip ngu hoorooweyeroro, kumooweroyimboro meyero oruwa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Oni ene uriro nangge ko tero oorooteku, ene Sipsip nguro simbuye kini. Nguro ngu, ene se koki oo biyomi ombutoni, ngu kenoro ngu, ene sosorero toongewa. Ene ngundiro toongetoni, se koki oo biyomi, ngundo omburo, Sipsip ngu yutoro, yoonero, yomburiyerootoni, nguro Sipsip songo songo sawanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ndadiro nguro, ngu oningga ngu ene uriro nangge ko teteku nguro. Yo, hamoo, ene Sipsip nguro ma ingondudu tero nowoondoyi teyunowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Nondo nangge no Sipsip sobosobo gome oorengo. No nenengo Sipsip nguro ingootoowe, ko noro Sipsip ngundo nguya, ene noro ingootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ngu ngandiro, Awando noro ingootoni, nondo ngu Awaro nguya no ingooteno. No nenengo Sipsip ngu hoorooweyeroro, nenengo ketangga, ngu yokoro, hoorooweyeroro kumoowano. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Noro Sipsip gidarega, nga sisipawangga, ngano ma oorootenggoku, ngu nguya yoyoro, omburo, nga sisipawano ngano yoyetoowe, ene nguya noro manggone ingowanggo. Ngundiro tero, Sipsip wata guranangge, ko Sipsip nguro sobosobo nguya guranangge oruwa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Awando noro gome nowoondoyi tenunoro, newende no nunoote. Ndadiro nguro, no kumooro nenengo ketangga ngu yokoro ngu, ene no ketangga, oruweroyi ngu ko yowano. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Oni gurado, noro ketangga oruweroyiga, ngu ma andangewanggo. Kini, no nenengombo ngu ketangga ngu yokowano. No kumooweroyimboro yanggangonedodo, ko no keta ootoogeweroyi, nguro nguya yanggangonedodo. Ngu mamana mandega ngu, no Awanemonggo yoyingo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yisasdo mande ngundiro etoni, ingoro, Yuda oni simoo bare kewooro usowooro wata eraya tunooteyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Oni oowooyingga eyingo. Oombooro biyomi eneno oodoni, ngundo yeni kakabeteteku eke. Ndadiro nguro, ye enengo mandeni ingoro keyootenggo? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ene ngundiro etoyi, gidaregado eyingo. Nga ngu oni oomboorombo yoyingo, nguro mandeni ngundiro kini. Oombooro biyomidodo, ngundo ene mete oni doongeyi kiringomu ngu yeni, doongeyi metemi tero, ko doongetewa, bine? Hamoo oorengo, kini! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Yerusalem ende urungga nguno naru kundingiyi tunooteyingo. Ngu ngandiro. Anutro yowuru ya oowooyi Tembel ngu yero goosooyingo, nguro ingondudu teweroyi naruwo tunooteyingo. Ngu narungga ngu, doogo dogigi gingo yeyingo naruwo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ngu naruno nguno, Yisas ene Tembel ya koneyo oowooyi Solomon, ngu newendekuri oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ngundiro tetoni, Yuda oni omburo Yisas pawangoro, sumoo inoro eyingo. Naru ndadiro, ge noore nowoondonani yeyi buribari teroruwato? Ge Krayis tetoningga ngu, asa, ge komo nooreno nenengo oorengo tunoo e. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yisasdo mandeye ngu ingoro, gumi eyingo. No yeno kuri ewonoku ngu, ene ye nguro nowoondoyemo hamoo ma teyingo. Nondo oo songo gura onindo ma teweroyimu, ngu bidodo awane oowooyimo tewono. Ngundo noro murine yootunoote. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ye nondo oo songo gura tetenoku, nguro nowoondoyemo hamoo ma tetenggoku ngu, ndadiro nguro, ye noro Sipsip kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Noro Sipsip bidodo ngu, ene noro manggone ingootoyi, nondo nguya enengo ingootoowe, ene no keneroro endeyootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nguro ngu, nondo suwooyi sano sugi sugi keta oruweroyi ngu yunootoowe, ene ma oonootewanggo. Ngu oni ngu, oni gurado no kandenemonggo, hamoo oorengo ma andangero yoyowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Noro Awanembo ngu oni ngu, ene kuri no nunowoku ngu. Awane ngu, ene oo bidodoboro koreteyingo awuno oorengo. Oni gurado Awa kandeyimonggo ene andangeyeroro yoyoweroyi nguya kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","No nenengo Awane nguya noore guranangge. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ngundiro etoni ngu, asa, Yuda onindo sanggiri urungga tero, nguro ene digi yoro, ngundo Yisas ureyi kumoowero teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ngundiro tetoyi, Yisasdo eneno eyingo. Nondo Awaro oo songo gura onindo ma teweroyi, ngu oowooyingga tero etuyerowono. Nondo ngundiro etuyerootoowe, ngunonggo nondo ndawu ko metemingga tetoowe, kenoro, yendo ko nguro ndadiro ingondudu tero, nguro ye digi yoro, no bungomo oorongooro nureyi kumoowero tetenggo? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Yisasdo mande ngundiro etoni, Yuda onindo eneno gumi eyingo. Noore gengo ko gome guraro ingoro, noore digi ge bungomo ma oorongooteto. Kini, gedo Anut kootuyisina yomooyinoro mande etoyi nguro. Ge ngu oni oorengo nangge. Ene gedo ngandiro ete, gengombo no Anut, ero ete, eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Onindo mande ngundiro etoyi ngu, asa, Yisasdo gumi ero eyingo. Nakaya ngu yengo mamana mandeno nakangoro, Anutro eyingo. Nondo kuri ewono. Ye ngu anut ngundiro, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Noore kuri ingooteto. Anutro mande bidodo bukno oorooteku, ngu hamoo mande nangge, ngu sugi sugi oruwa. Ngu bukno nguno, Anutdo oni mande yunoro, ngu oni nguya anut ngundiro ero ewo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ene awa enengombo no rogoneroyingo. Enendo no surenerootoni, no merako ngano ombuwonowo. Asa, nondo eteno, no Anutro nangoni, nguro ndawugaro yendo etenggo, ge Anut kootuyisina yomooyinoro mande ete, ero etenggo? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ene no nenengo Awanemboro koni ma tetoowe ngu, arisa, ye mete noro mandene ngaro nowoondoyemo hamoo ma tewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ene no enengo koni tetoowe ngu, ye noro mandene nguro nowoondoyemo hamoo ma teya ngu, asa, ye mete nondo oo songo gura onindo ma teweroyimu tetenoku, nguro nowoondoyemo hamoo teni. Nguro ngu, ye mete ingondudu metemi ngu, ngandiya ingoyi. Awando noya oodoni, nondo Awaya oorootero, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Yisasdo mande emukootoni ngu, asa, Yuda onindo sanggiri urungga tero, Yisas ko towoongoro, dowooro, ya biyomimo yewero tetoyi, ene Yisas Yuda oni kandeye dagaro, torige toongeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yisas toongero, oororo, Yodan sono ko wongooro, gidareroko uroorero, ene yade oororo, kuri Yondo oni sono kundingiyi gimuyunoyingo endega, nguno tunootero, nguno oruwo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ngu naruno, oni simoo bare oowooyingga oorengo, ene Yisasno mayero mande enengombo ngandiro eyingo. Hamoo oorengo, Yondo oo songo gura onindo ma teweroyimu gura ngu ma teyingo, ene Yondo nga oningga, ngaro mande eyingo ngu hamoo nenengo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ngu mera gumisina nguno, oni simoo bare oowooyingga oorengo, ene Yisasro nowoondoyemo hamoo teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Oni gura oowooyi Lasaras ene sayi yoyingo. Lasaras ngu Mariya, Mata, eraga nguro gumooyari, enengo endeyari oowooyi Betani. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ngu Mariyangga ngundo ene kuri bo urumi (Sanda) Urungga Oo Bidodo Simburi Yisas, ngu keyimo wendoro, enengo uyimbo yonggurumooyingongga ngu. Ngu enengo gumooni Lasaras ngu sayidodo teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ngundiro nguro, kuwookuwooyi erayagakundo mande Yisasno soweyoro eyingo. Urungga Oo Bidodo Simburi, gengo oningga nguro gome ingootekungga, ngu ene sayidodo tero ooroote, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ene mande ngundiro soweyootori ngu, asa, Yisasdo ngu mandega ngu ingoro eyingo. Ngu sayingga ngundo oni yeni ma kumoowa. Kini, ngu sayingga ngundo tetoni, oni simoo bareno Anutro duridarini tunootewa. Ngu oo nguno Anutro Nangoni ene duridarinidodo tunootero, enengo oowooyi bingaminidodo oruwa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yisasdo Mariya, Mata, erabasa ko gumooyari Lasaras, nguro gome ingoote. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ene mande etoyi, Yisas ingoworomu ngu, Lasaras sayi kumooro ooroote, ero etoyi ingoro ngu, ene sa eraya nguya ngu endega oruwokungga, nguno oruwo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ngu naruno nguno, Yisasdo enengo kirikiri onikuno eyingo. Noore Yuda merasina ko oorowuyiga, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ene ngundiro etoni ngu, asa, kirikiri onikundo eneno eyingo. Oo etuyeroyingo oni, kuyowo yange nga, Yuda onindo, digibo gurewero tewonggoku, nguno ge ataga ko oorowuwero ete? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Etoyi, Yisasdo gumi eyingo. Sa guranangge nangge ngu ogisa ooroote. Oni ene sano endeyoro ngu, ene digino ma yurewa. Ndadiro nguro, ene merangga ngaro himimo mera kenoro endeyowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ene oni suwoono endeyoro ngu, ene digi wongosogurumooro werewa. Ndadiro nguro, ene soru himi kini nguro, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yisasdo ngundiro ero, kootuyisina ene mande gura soweyoro eyingo. Noorengo doboonani Lasaras kuri wetoro kabetewo. Ene nondo oororo, yokutuwootoowe ootoogewa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ngundiro tero, kirikiri onindo eyingo. Oo Bidodo Simburi Simbunani, ene wetoro, kabetero ngu, ene ko metemi tero oruwa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yisasdo ngu Lasaras ngu kuri kumootoni, nguro ngundiro eyingo. Ene kirikiri onindo ngu, Lasaras ngu hamoo wetoro kabetero oodoni, nguro ete, ero ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ngundiro tetoyi, Yisasdo yootunoro, ero eyingo. Lasaras doboonani ngu hamoo kumoowo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ene no yengo ingoro nowoondoyemo yanggango teyunowero, nguro no anduno eneya ma ootooro, nguro no oni oni teteno. Arisa, ataga noore mete ene tanggeyimo oorowuyiga, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Yisasdo mande emukoro ngu, Tomas oowooyi gura Didimas, ngundo kirikiri oni gidaregaya eyingo. Arisa, noore ootoogetoyiga, ooroya, enendo Yisas ureyi kumootoni ngu, noore eneya gobooro kumoowooto, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Arisa, Yisas enengo kirikiri oniya yade oororo, Betani endemo tunootero ingoyingo, Lasaras bingo ngu mereno naru kuri namoraya oruwo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani endega ngu Yerusalem ende urungga ngu tanggeyimo. Nguro rogo ngu 3 (Kilomita), ngundiro nangge. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Yuda oni simoo bare oowooyingga oorengo Mariya, Mata, eragano gumooyari kumoowoku naruno nguno mayero, enengo nowoondoyari yeyi imakeweroyimboro. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ngu naruno nguno, Matado ingoworomu ngu, Yisas mayeyingo. Nguro, Mata ootoogero, Mariya yokoro, ooreko oororo, Yisas kenoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Matado Yisas kenoro eneno eyingo. Urungga Oo Bidodo Simburi, ge ngano oodoyi ngu, noro gumoone ma kumoowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ene no ingooteno. Ge oo guraro Anutno yemboongewaku ngu, asa, ngu ooga ngu, ene ge gunowa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ene ngundiro etoni ngu, Yisasdo Matano gumi eyingo. Gengo gumoonggega ngu ko ootoogewa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ene ngundiro etoni, Matado eneno gumi eyingo. No ingooteno. Ene naru wengamo ko ootoogewa. Ngu narunggano nguno, oni simoo bare merenonggo ko ootoogewanggo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ene ngundiro etoni, Yisasdo gumi eyingo. Ko ootoogeweroyi ngu nondo nangge, ko keta sugi sugi suwooyi sano oruweroyi nguya, nondo nangge. Oni ene noro ingootoni, newendemo hamoo tero, nguno ene kumoowaku ngu, asa, ene noya keta oruwaro. Yo, ene keta ko ootoogero sugi sugi oruwa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Oni bidodo doongeye keta ootooro, ngunonggo noro nowoondoyemo hamoo tero oorootenggoku ngu, ene ma kumoowanggo. Kini, ene suwooyi sano sugi sugi keta oruwanggo. Ge nguro nowoondogemo hamoo tete bine, ngundi kini? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Etoni, Matado eneno eyingo. Yo, Urungga Oo Bidodo Simburi, no nowoondonemo hamoo ge Krayis, Anutro Nangoni, ge nga oningga nga Anutdo mera ngano sowenggerootoni ombuwo, ero ewo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Matado ngundiro ero yokoro, ene ko oororo, Mariya yoro, songo oororo eyingo. Oo etuyeroyingo oningga ngu omburo, ge negogeroote, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mariyando mandeni ngu ingoro, ene sodedomangge ootoogero, Yisasno oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ene Yisas endemo ma tunooteyingo. Kini, Yisas ngu Mataya mande eworiku, musiyongga, nguno nangge oruwo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Yuda oni Mariyadodo yano ootooro, ene ngunonggo Mariya newende yeyi imakeweroyimboro oriyingo. Ngundo Mariya kenootoyi, sodedomangge ootoogero, endesina ooretoni, nguro ene keyoro, ene nguya endesina ooreyingo. Ndadiro nguro, Mariya ngu mereno sendowero oorowute, ero ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mariya ngu ene Yisas oruwoku mera musiyonggakuno oororo, kenoro ngu, ene Yisas keyi damonimo bagootero eyingo. Urungga Oo Bidodo Simburi, ge ngano oodoyi ngu, noro gumoone ma kumootoni, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ene ngundiro etoni ngu, asa, Yisasdo Mariya ko Yuda oni Mariya keyoro oorowuwonggoku nguya sendootoyi yeyoyingo. Ngundiro yeyoro, Yisas newendemonggo, enengo nowoondoyi teyunoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Yisasdo ngundiro tero eyingo. Ye enengo bingo yoro ndano merengoowonggo? Etoni enebana eyingo. Urungga Oo Bidodo Simburi, ombuya keno. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yisasdo sendoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ngundiro tetoni, Yuda onindo kenoro eyingo. Kenoyi, ene ngu oningga nguro gome ingoote, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Etoyi, ene oni gidaregado eyingo. Nga oningga nga ngu, oni doongeye kiringo yomosiyootoni doongetetenggo. Ene Lasaras hooroowetoni ngu, ene bine ma kumoowo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Arisa, Yisas ngu newende kowuri oorengo yetoni, oni mere tanggeyimo oorowuyingo. Ngu oni merengga ngu, digi woondokoyi urungga newendemo oni mereyi yomosiyoro, oni nguno merengooro, digi urungga yoro, ngundo mere manggowo ukingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yisasdo eyingo. Ye digiga mere manggowo ukingoyingongga ngu andangeyi. Ngundiro etoni, oni kumooyingongga nguro kuwooyi, Mata ngundo Yisasno gumi eyingo. Urungga Oo Bidodo Simburi, ene kumootoni, merengooyingo ngu noore naru namoraya kuri yokowooto. Ngundiro nguro, ndindingo ukayi biyomi merenonggo oorewa! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Matado ngundiro etoni ngu, asa, Yisasdo eneno gumi eyingo. No kuri geno ewonoku, ge nowoondogemo hamoo tetoni ngu, ge Anutro duridarini yanggangoni ngu kenowa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Arisa, ene Yisasro mandeni ingoro, nguro ene digigaku andangeyingo. Ngundiro andangetoyi, Yisasdo randoro doongetero eyingo. Awa, ge noro yemboongene ingowoku, nguro no geno esosooteteno. Ndadiro nguro, ge noro yemboonge ngu kuri ingowoku ngu! ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","No kuri ingooteno, ge suwooyi sano nondo mande etenoku, ngu ingoro ooroote. Ene nondo, ataga nga oni simoo bare dikatenggoku, ngando ngu ingoya, ene nowoondoyemo hamoo tetoningga, gedo nangge kuri no surenerootoyi, ombuyingo, nguro ero, meno yanggango tero, yemboongeyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yisasdo yemboongeyingo ngundiro ero yokoro ngu, ene meno eyingo. Lasaras, ge endesina oore! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Arisa, Yisasdo mande ngundiro etoni ngu, oni kumooyingonggaku ootoogero, endesina ooreyingo. Keyi kandeyi, omukumundoongo ngu towikumbabo doobengoro mbimboongoro gosiyoyingo. Ene ngundiro oodoni, Yisasdo eyingo. Towikumba ngu wesiyoya yokootoyiga oorowuni! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Arisa, ngundiro tetoyi, Yuda oni oowooyingga ene kuri mayero, Mariyadodo oruwonggoku, ngundo ngu oo Yisasdo teteku ngu kenoro, ene nguro nowoondoyemo hamoo teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ene Yuda oni gidarega kewooroyemo ngundo Parisi onino oororo, Yisasdo oo tewoku, nguro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ngundiro nguro, Anutno wooro yeyingo oniro sobosobo oniku, ko Parisi oni, ngundo Yuda tabango oniya yowuruwooro eyingo. Noore ndadiro tewato? Ngu oningga ngundo ene oo songo gura onindo ma teweroyimu, ngu oowooyingga tete. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ene noore doongenanimbo nangge kenowatoku ngu! Ngu oningga ngu yokootooye ngu, asa, ene ko ngundiro urungga tewa. Ngundiro tetoni ngu, simoo bare oowooyingga enengo nowoondoyemo hamoo tewanggo. Ngundiro tetoyi, asa, Rom onindo omburo, noorengo yowuru ya kundingiyi oowooyi Tembel, ko noorengo Yuda oni simoo bare kenanimo nguya yomburiyerowanggo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ene mande ngundiro etoyi, asa, oni gura ene kewooroyemo, ngu oowooyi Kayiyapas, ngu oningga ngu, ene ngu dagomangga nguno, ene Anutno wooro yeweroyi nguro sobosobo tabango oruwo. Ngundo mande ero eyingo. Ye ingonduduye kini. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ye oo gura ma ingootenggoku, ngu mete oni gurananggebo oni simoo bare hoorooweyeroro kumoowa. Kini tetoni ngu, noorengo kenanimo Yuda oni simoo bare nga oonootewanggo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kayiyapasdo, enengo ingondudunonggo ma eyingo, enendo kootuyisina oo tunooteweroyi nguro eyingo. Kini, Kayiyapas ngu dagomangga, nguno ene Anutno wooro yeweroyi nguro sobosobo rogo tetoyi, Yisasro mande nguro ene koretero ingondudu tero eyingo. Yisasdo Yuda oni simoo bare hoorooweyeroro kumoowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ene Yuda oni nangge hoorooweyerowero nangge ma kumoowa. Kini, ene kumooweroyingga ngu Anutro simoongo mera bidodomo oorootenggoku, ngu yowuruyerootoni, wata guranangge tunootewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Arisa, ene ngu sa narungga nguno, oororo, ene Yisas ureweroyimboro mande ero oore ereweyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ngundiro nguro, Yisas ene Yuda oni kewooroyemo tunoo ma endeyoyingo. Kini, Yisas ngu, ene ngu endega ngu yokoro, oororo, oni kini kingo mera ngu tanggeyimo, Ipirim ende bodaga, nguno enengo kirikiri onidodo nguno oruwonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Yuda oniro sunggi Anutdo dagayeroyingo naruwo, Pasowa, ngu namoko teyingo. Pasowa ma tunooteyingomo, oni oowooyingga endeni endenimonggo, Yerusalem endemo mayero, nguno enengo yoyeyi, Anut doongeyimo, metemi teweroyimboro mayeyingo. Ndadiro nguro, ene Mosesro mamana mandeni ngu nenengo keyoro oorootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Mayero, ene Yisasro doongetero, erewero eyingo. Ye ndadiro ingoro etenggo? Yisas ene naru kundingiyi ngaro mayewa, ngundi kini, bine? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Yuda onindo Yisas ereweyingo ngu damoni ngandiro. Anutno wooro yeyingo oniro sobosobo oni, ko, Parisi oniya mande ngandiro kuri eyingo. Onindo Yisas ndano oorooteku ngu ingoya ngu, asa, ene komo mayeya etoni, ingoro, nguno dowooro, yoro, ya biyomimo yewato, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Naru kundingiyi ngu ma tunooteyingomo, naru kandegura gidemboro guranangge oodoni, Yisas nguno ene Betani endemo oorowuyingo. Betani endega ngu, Lasarasro ende. Ngu Lasaras oningga ngu, kuri Yisasdo merenonggo ko yokutuwootoni, ootoogeyingongga ngu. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ene Yisasro oo simbo gura ngu endemo nguno kayingo. Mata ngu ene oowari moondootoni, Lasarasdo ngu oniya nguya bibitero, Yisasdodo oowari neyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ene oowari netoyi, Mariyando kumu bo urumi gura oowooyi Nard, ngu ndindingo gome, (Kilo) gumi nangge yoro, ngundo Yisas keyi sonowooyingo. Ngundiro sonowooro, enengo tabango uyimbo yonggurumooyingo. Ngu kumu bo urumingga nguro urini ngu urungga oorengo. Yo, ndindingo ngu gome, ngunonggo ndindingo gomengga ngu yangga ngu nangge teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ene kirikiri oni gura, ngu oowooyi Yudas Iskariyoot, ngu oningga, ngundo kootuyisina Yisas yootunoro, mundi oni kandeyemo yero yunowaku, ngundo boguwooro ngandiro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Ndawugaro nguro, noore nga kumu bo urumingga nga oni yunoro, nguro urini ngu, dagoma guranangge ko tero digi beye yoro, angoyi oni ma yunoyingo? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ene Yudasdo angoyi oniro ingondudu tero ma eyingo. Kini, ene ngu yakaka oni, ene ngu digi beye sobowooro, ngunonggo ene beye onindo yetoyi, enendo yakakayi gidarega yororuwo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ngundiro etoni, Yisasdo gumi eyingo. Ngundo yokoyi! Ye nga barega ngando teteku, nguro ma eweroyi. Ndadiro nguro, no kumootoowe, mereno mereneroweroyi narungga, ngu yootunoote. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Yo, hamoo, angoyi oni ngu, ene yeya suwooyi sano oruwanggo. Ene nondo ngu yeya suwooyi sano ma oruwato, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Yuda oni simoo bare oowooyingga ene Yisas Betanino oorooteku ngu ingoro, nguro ene nguno ombuyingo. Ene Yisas kenowero nangge kini. Yisasdo ene kuri Lasaras merenonggo yokutuwootoni ootoogeyingo, nguro ene Lasaras nguya kenowero ombuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ngundiro nguro, Anutno wooro yeyingo oni nguro sobosoboku, ngundo Lasaras nguya ureyi kumooweroyimboro mande ero gosiyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Ndadiro nguro, Yuda oni oowooyingga, ene Lasaras kenoro ingoro, nguro ene Yisasro nowoondoyemo hamoo tetoyi, enengo tabango oni yoyokoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Sengetoni, oni simoo bare urungga oorengo ene naru kundingiyi ngu kenowero mayero oorootenggo. Ngu narungga nguno, ngu simoo bare ngundo Yisas ene Yerusalem ngu ombuteku ngu ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ngundiro nguro, ene toonggoo uyi toongooro yoro, irosarayi dowooro, umamingoro, Yisas oowooyi bingami okooro oororo, ooreko Yisas kenoro, meno moguru urungga tero eyingo. Hosana! Gengo oowoongge awuno oorengo! Nga oningga nga ngu, ene Oo Bidodo Simburi Simbunani, ngu oowooyimo ombuteku nga! Ene Iserel oniro oo bidodo sobowooyingo oni urungga! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yisas ngu Hos gura oowooyi Donggi nangoni gura kenoro, yoro, nguno bibiteyingo. Ngu Anutro mandeno ngandiro ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Ye Sayiyon (Yerusalem) endemo oni simoo bare, ye ma sosorewero! Kenoyi! Yengo oo bidodo sobosobo oni ombuteku ngu! Ene Donggi nangoningga sanganimo bibitero ombute! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Yisas enengo kirikiri oni ngu, ene ngu mandega nguro muri ma ingoyingo. Ene, Yisas ko ootoogeyingongga, ngu duridarinidodo tunootetoni, ene nguno nowoondoyemo ingondudu teyingo. Ngu naruno nguno, kirikiri onindo Anutro mandeno ewoku, tunoo oorengo ingoro, ngunonggo onindo Yisasno teyingomu nguro ingondudu teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Kuri Lasaras kumootoni merengootoyi, nguno oodoni, oni simoo bare urungga oorengo Yisasdodo oode, ngunonggo Lasaras negongootoni, ko ootoogetoni kenoyingo. Ngu oni simoo bare urungga, ngundo ene ngu ko mande oo Yisasdo teyingo, nguro mande mandeni ero yootunoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ene ngundiro mande mandeni yootunootoyi, oni simoo bare oowooyingga ene Yisasdo kuri oo songo gura onindo ma teweroyimu tewoku, ngu kenoro ingoro, nguro ene oororo, ooreko Yisas kenowero oorowuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ngundiro tetoyi, Parisi onindo enengo nangge mande ero ingoro eyingo. Nga kenoyi! Oni simoo bare ene oororo, Yisas keyoro endeyootenggoku nga! Noorendo oo tetetoku ngu, kingo oo ngundiro tunootete! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Oni simoo bare ene Yerusalem endemo oorero, naru kundingiyimo nguno Anutno yambo mande tewero ooretoyi, Girik oni gidarega nguya yambo mande tewero, nguro ene Yerusalemno ooreyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ngu Girik oni ngu, ene Pilipno omburo eyingo. Urungga, noore Yisas kenowero. Ero eyingo. Pilip oningga ngu, ene Betisayida ende Galili mera ngunonggo ombuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Arisa, Pilipdo enengo mandeye ngu ingoro oororo, Enduruno ero enengo eraya eraya oororo, Yisasno Girik oniro mande eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ene ngundiro etori ngu, asa, Yisasdo mandeyari gumi eyingo. Anutro Nangoni Oni Kirarongo nguro naru ombutoni, ene duridarinidodo ngu yoweroyi narungga ngu kuri tunootete. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Hamoo oorengo, no yeno eteno. Nggire yuwooyi merako uro ma kindangero ooretoni ngu, asa, enesu nangge oruwa. Ene oo yuwooyi kindangero oorero ngu, oo engge oowooyingga tunootewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Oni enengo goweyi nguro nangge ingoro sobowooro oruwaku ngu, ngu oningga nguro keta oruweroyiga ngu oonootewa. Ene oni enengo ketangga ngu mera ngano kootu inoro, ene dobookuriyi nowoondoyi teyunoro, Anutro koni ngu tero hoorooweyeroro ngu, asa, ene suwooyi sano keta sugi sugi oruwa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ene oni gura noro kone nga dowoowero tero ngu, ene komo no keneroni. Ene ngundiro keneroro ko tetoyi ngu, asa, nondo endega oorootenoku, nguno noro ko oni nguya noya gobooro oruwaro. Yo, ene ngundiro tero no hoorooweneroro ko tero oodoore ngu, noro Awanembo ene oowooyi bingamidodo inowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ataga, noro nowoondone kowuri oorengo yetoni, nguro no ingondudu oowooyingga teteno. Nguro no ndadiro ewano? Nondo bine ewano, Awa ge nono oo ataga tunooteweroyiga nga andangenuno, ewano? Kini, no ngundiro ma ewano. No ngu kowuringga ngu koorowoowero, nguro nangge no merako ngano ombuwono. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Awa, gengo oowoongge yega urungga tunooteni! Yisasdo ngundiro etoni, Anutdo sambononggo ngandiro meno eyingo. Nondo nenengo oowoone kuri yewe urungga tunootewoku, ko kootuyisina nguya no oowoone yewe urungga oorengo tunootewa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ene ngundiro etoni, asa, oni simoo bare oowooyingga oorengo ene tanggeyimo dikayingo, ngundo ngu ingoro eyingo. Nggururu gusiroga ngguyi ute, ero eyingo. Oni gidaregado eyingo. Sambono Engel oninggado eneno mande ete, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ene ngundiro etoyi, Yisasdo mande gumi eyingo. Kini, noro Awanembo mandega eteku nga ngu, no hooroowenerowero ma ete. Kini, ye hoorooweyeroweroyimboro nguro ete. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ataga nga narunggano, ngano ngu, Anutdo mera ngaro oni simoo bare wirikoyeroro ete. Yengo muriye ngu biyomi nangge, ero ete. Ataga ngu mera ngaro muri biyomi nguro sobosobo tabangongga, ngu Anutdo andangero owewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","No ataga merako ngano oorooteno. Ene kootuyisina, onindo nowokooro awuno noyetenggoku, narungga nguno, oni simoo bare bidodo yoyewe, nono ombuwanggo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yisasdo ngundiro eyingongga ngu, enengo kumooweroyi, nguro murini tunoo yootunoro ngundiro eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ngundiro etoni, oni simoo bare urungga, ngundo Yisasro mande gumi eneno eyingo. Noore mamana mandeno, mande eteku, ngu ngandiro ingooteto. Krayis, ene Anutdo simoo bare ko yoyowero sunggi yeyingo oningga ngu, ene ngano omburo, sugi sugi oruwa. Ndadiro nguro, gedo ete, oni ene komo Oni Nangoni, ngu okooro boorowoowanggo? Ngu Oni Nangoni oningga, ngu oone? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ene ngundiro sumoo inootoyi, Yisasdo ngandiro eyingo. Naru bodaga nangge noro soru himi ngu yeya oruwa. Ataga ngu ye soru himidodo oorootenggo. Nguro ngu, ye komo soru himimo endeyoyi. Kini tetoni ngu, suwoo ooreri biyomi, ngundo omburo ye wiriyerowa. Oni ene ooreriko endeyooteku ngu, ene oore oorowuteku, ngu kenoro, ma ingootenggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ataga, ye noro soru himidodo oorootenggo. Nguro ngu, ye komo, nondo soru himi yoro ombuyingo, nguro nowoondoyemo hamoo teyi! Ye ngundiro tero ngu, asa, ye noro simoone nguro soru himimo nguno endeyowanggo. Yisasdo ngu mandega ngu ero yokoro, ene musiyo songosina oni nguno kini nguno oororo kengeyingo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Oni ene Yisas kenootoyi, oo songo gura onindo ma teweroyimu, ngu urungga tetoni kenoro, nguro ene nowoondoyemo hamoo ma teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ngundiro nguro, Anutro ingonduduni eyingo oni, Ayisayaro mandeni, nguro engge tunootete. Ayisayando kurimi ngandiro eyingo. Urungga Oo Bidodo Simburi Simbunani, onendo ngu noorengo mandenani ngaro newendemo hamoo tewa? Urungga Oo Bidodo Simburi Simbunani, ngundo enengo yanggangoni ngu oone etungowo? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ene Yisasro nowoondoyemo hamoo ma teyingo. Nguro muri ngu, Ayisayando nakaya gurano ngandiro nakangoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Anutdo enengo doongeye ngu, kuri ukingoyingo, enendo tetoni nowoondoye yeni digi ngundiro gagiwi oorengo yeyingo. Ngundiro nguro, ene doongeyembo oo kenoro, nowoondoyemo hamoo ingoweroyi nguya kini. Nguno ngu, ene nowoondoye ma yowoorengootoyi, nondo ma yomosiyerowano, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Anutdo Yisasro duridarini tunootero teweroyi, ngu Ayisaya etungootoni, kenoro, nguro ene Yisasro mandeni eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Hamoo, oni tabango urungga nguya Yisasro nowoondoyemo hamoo teyingo. Ene Parisi oniro sosorero, nguro enengo nowoondoyemo hamoo ngu, ene yootunoro ma eyingo. Ene tunoo etoyi ngu, asa, Parisi onindo yambo yanonggo oweyeroro, yambo mande teweroyi nguro roogo teyunoyingo, ero ingoro, nguro ngundiro teyingo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ene tabango onindo enengo ingonduduye urungga ngu simoo baredo enengo oowooye eya okooyi ero, gome ingootenggo. Yo, hamoo, ngundiro ingoyingongga, ngundo Anutdo oowooye okooweroyiga ngu, dagate. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yisasdo manggaru tero eyingo. Oni ene noro newendemo hamoo teteku ngu, ene noro Awane no sowenerootoni ombuwonoku, nguro nguya newendemo hamoo tete. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Oni ene no neyoro ngu, ene noro Awane no surenerootoni, no ngano ombuwonoku ngu nguya kenowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","No ngu mera ngano ombuwonoku, ngu soru himi ngundiro ombuyingo. Nguro ngu, oni bidodo ene noro nowoondoyemo hamoo tewanggoku ngu, ene ooreriko ma oruwanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ene oni gura noro mandene ingoro, ene ngu ma keyoro ngu, asa, no nguya ene ma wirikowano. Kini, no mera ngaro oni simoo bare wirikoyerowero ma ombuyingo. Kini, nondo ngu enengo weti mbumbuwanonggo andangeyeroro yoyoweroyimboro ombuyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Oni ene no kootu nunoro noyokoro, ene nondo mande ewonoku, ngu ma ingoro, yoro dowooro ngu, asa, naru wengamo, nondo mandega ewonoku, ngundo ene wirikowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nondo nenengo ingondudunonggo mande nga ma eteno. Kini, Awane enengombo no surenerootoni ombuwonoku, ngundo oo bidodo nunootoni mete temukowanoku, ngu no ngu nangge yootunoro eteno. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","No ngu ingooteno. Awaro mamana mandeni ngundo suwooyi sano sugi sugi keta oruweroyiga, ngu oni Awaro nowoondoyemo hamoo tetenggoku, nguno yeni tunootete. Ngundiro nguro, nondo mande bidodo etenoku nga ngu, Awando kuri etoni, ingowonoku, ngu nangge eteno. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Naru kundingiyi oowooyi Pasowa, nguro naruwo namoko tetoni, nguno Yisas ene ngandiro ingoyingo. Ene komo nga merangga nga yokoro, ene eweyi tanggeyimo, ko ooreweroyi naruwo ngu tunooteyingo. Enengo oni simoo bare mera ngano oorootenggoku, nguro nowoondoyi teyunoyingo. Ene bidodoboro nowoondoyi teyunoro oode oororo, ene kumooyingo naruno wenga. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Suwootetoni ene oowari nero oodoyi, Setando ingondudu biyomimu, kuri Yudas Iskariyoot, Sayimon oningga nguro nangoni, nguno yeyingo. Yo, hamoo, Setando Yudas eriringootoni, ngu Yisas yoro, mundi oni kandeyemo yeweroyimboro oore yomosiyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yisasdo ngu ene kuri ingoyingo. Eweyimbo oo bidodo ene kandeyimo yero inoyingo. Eweyimbo ene sureyootoni, ombuyingomu, ngu Eweyi tanggeyimo ko oorewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ngundiro ingoro, Yisas ene oowari nero yokoro, ootoogero, enengo towi pirungga nengguroyi ngu andangero yero, ene sono gimuweroyi towingga yoro, wanggangomo gosiyoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Yisasdo ngundiro tero, ene sono yoro, koondo gurano wendoro, sono ngundo enengo kirikiri oni keye damonimo yero, sonoyeroyingo. Ngundiro sonoyeroro, enengo wanggangomo sono gimuweroyi towingga, ngundo yonggurumooyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Yisasdo ngundiro tero, yade Sayimon Pitano ombutoni, Pitando Yisas sumoo inoro eyingo. Urungga Oo Bidodo Simburi Simbunani, ge no kene nguya sonowoowero, bine? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ene ngundiro sumoo etoni, Yisasdo mandeni gumi eyingo. Nondo ataga oo tetenoku nga, ge nguro damoni ge ma ingoote. Ene kootuyisina ngu ge ngaro damoni ingowa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ngundiro etoni, Pitando mande gumi eyingo. Ge noro kene hamoo oorengo ma sonowoowero. Etoni, Yisasdo gumi eyingo. Nondo ge ma sononggerowanoku ngu, ge noya gobooro ma oruwaro, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Etoni, Sayimon Pitando eneno gumi eyingo. Urungga Oo Bidodo Simburi Simbunani, ge kene nangge ma sonowoowero. Kini, ge komo kene, kandene, tabane nguya sonowoomuko, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Etoni, Yisasdo gumi eyingo. Oni ene goweyi bidodo sono gimuwoku ngu, ene sugabo kini. Ene mete keyi nangge sonowoowaku ngu, asa, ene goweye moondeye bidodo sarayi. Yo, ye bidodo metemi oorootenggo. Ene, ye kewooroyemo, ngano oni guranangge ene metemi kini, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yisas ene kuri ingoote. Ngu oningga ngundo ene yootunoro, mundi oni kandeyemo yewa. Ngundiro nguro, ene ngandiro ewoku, ye kewooroyemo oni gura ngu metemi kini, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Arisa, Yisasdo keye sonowooro yokoro, enengo nenggurogaku yoro tero, bibitero, enengo kirikiri oniku sumoo yunoro eyingo. Ye bine nga kongga yeno tetenoku ngaro damoni ingootenggo? ");
INSERT INTO rwo_rawa_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Yendo noya ngandiro etenggo. Oo etuyeroyingo oni, ko, Oo Bidodo Simburi Simbunani, ero etenggo. Ngu yendo hamoo etenggoku, no ngu nangge. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ngu hamoo, no ngu yengo Urungga Oo Bidodo Simburi, ko no yengo Oo Etuyeroyingo oni nguya, nondo yengo keye sonowootenoku ngu, arisa, yendo nguya dobookuriye keye sonowooyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nondo ataga ye etuyerootenoku muringga ngu, kingo gabogaboyi nangge etuyerooteno. Yendo nguya ngu muringga ngu teyariyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Hamoo oorengo, no yeno eteno. Ko oni ngu, enengo sobosobo oningga ngu dagaro awuno ma oruwa. Ngundiro nangge, oni gura ko gurano oororo ngu, enengo oningga sureyootoni kono oorowuteku, ngu dagaro awuno ma oruwa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ene ye nga oo nga ingoro, ye nguya ngundiro tero ngu, asa, ye mete oni oni tewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Nondo ye bidodoboro ma eteno. Nondo oni nenengo rogo tewonoku, nguro ingooteno. Ene ngu ooga, ngu Anutro mande, ngu engge tunootete. Anutro mandeno ngandiro ete. Oni ene noya oomanongoyingo gobooro nero, ene no nowoongowero keyi okoowa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ngu ma tunooteyingomo, no yeno eteno. Nguro ngu kootuyisina ngu tunootetoni, asa, ye nowoondoyemo hamoo teweroyi ngu no nga oningga nga. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nondo hamoo oorengo, yeno eteno. Oni nondo ko oni sureyootoowe, oorowuteku ngu yoro, gome tero, yomosiyoro ngu, asa, ngu oningga ngu, ene no nguya noyoro yomosinerowo. Yo, ngu oningga ngu no noyoro ngu, ene noro Awane no surenerootoni, ombuwonomungga, ngu nguya yowa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yisasdo ngundiro ero yokoro, ene newende kowuri oorengo yetoni, nguro ene yootunoro eyingo. Hamoo oorengo, no yeno eteno. Ye kewooroyemo nganonggo gurado no yootunoneroro, mundi oni kandeyemo noyewa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Yisasdo ngundiro etoni, kirikiri oni enengo nangge ebe keno keno tero, ngu oneya ete, ero ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ene ngundiro tetoyi, kirikiri oni gura, Yisasdo nguro gome oorengo ingooteku, ngundo Yisas tanggeyimo oruwo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ngundiro oodoni, Sayimon Pitando tabangombo tero, eneno eyingo. Gedo sumoo ino ene oneya ete, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Arisa, ngu oni Yisas tanggeyi oorengomo bibiteyingongga, ngundo Yisas tanggeyi oorengomo oororo rorowooro, sumoo inoro eyingo. Oo Bidodo Simburi, ge oneya ete ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ene ngundiro sumoo etoni, Yisasdo mandeni gumi eyingo. Nondo oomanongoyingo gumi gura oo sonoyimo yero yoro, oni gura inootoowega ngu, ngu oningga ngu! Ngundiro ero, ene oomanongoyingo gumi gura yoro, oo sonoyimo yero, yoro, Yudas Iskariyoot, Sayimonro nangoni, ngu inoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yudas oowari ngu yoro netoni, ngu naruno, Setando newendemo utoni, Yisasdo Yudasya eyingo. Ge oo tewero ingooteku, ngu ge komo sodedo ngundiya te! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Yisasdo mande ngundiro Yudasya etoni, oni oo neweroyi yabano bibiteyingo ngundo mandeni ingoro, ene nguro muri ma ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yudasdo ngu, Yisas garo ngu bidodoboro digi beye nguro siri, ngu enendo sobowoote. Yisasro kirikiri oni gidaregado ngu, Yisasdo mande ngu etoni, ene ingoyingo. Naru kundingiyi nguro oo gura uriyoni, ngundi, oo gura angoyi oni yunoni, ero eteku, ngu ero ingoyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Arisa, Yudas oomanongoyingo gumingga ngu yoro, ene ende oorero toongeyingo. Ngundiro toongetoni, ngu narungga ngu, suwoo ooreri teyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yudas endesina oorero toongetoni, ngu naruno, Yisasdo eyingo. Ataga Oni Nangoni, ene bingaminidodo tetoni, ngunonggo Anut nguya enengo nangonimonggo bingaminidodo tete. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ene Anutdo enengo nangonimonggo bingaminidodo yoro ngu, asa, Anutdo bingaminidodoga ngu yoro, enengo Oni Nangoni nguya ko inootoni, enengo eraya eraya sodedomangge bingamiyaridodo tunootewari. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ye simoone, naru bodaga nangge, no yeya oode, kootuyisina, ye no erewenerowanggo. No kuri Yuda onino ewonomu, ngundiro nangge, ataga yeno nguya eteno. Ye nondo endega oorowutenoku, nguno ye ma oorowuwanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ene ataga nondo mamana mande keta gura ye yunooteno. Ye komo dobookuriye nowoondoyi teyunoyi! Yo, nondo yengo nowoondoyi teyunootenoku, ngundiro nangge, ye komo dobookuriyeboro nguya nowoondoyi teyunoyi! ");
INSERT INTO rwo_rawa_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ye dobookuriyeboro nowoondoyi tewanggoku ngu, asa, oni simoo bare, bidodo ye yeyoro ingowanggo. Ye ngu noro kirikiri oni oorengo. Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Sayimon Pitando Yisasno eyingo. Oo Bidodo Simburi, ge ndawoore ute? Etoni, Yisasdo mandeni gumi eyingo. Nondo endega oorowutenoku, nguno ge no keneroro, oorowuweroyi, ngu ereremo kini. Ene kootuyisina, ge no keneroro nguno oorowuwa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ene ngundiro etoni, Pitando gumi eyingo. Oo Bidodo Simburi Urungga, ndadiro nguro, no ataga ge ma kenggeroro oorowuwano? No nenengo ketangga, ngundo ge hooroowenggerowero, ingooteno, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ene ngundiro etoni, Yisasdo mandeni gumi eyingo. Gedo gengo ketangga ngu yokoro, no hooroowenerowero ete? Hamoo oorengo, no geno eteno. Kootoori ma eyingomo, ge no oowoone tambu kabusa ero oongoonerowa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yisasdo enengo kirikiri onino mande gura eyingo. Yengo nowoondoye soriyokoro ma sosorewero. Ye Anutro nowoondoyemo hamoo tetoningga, ngunonggo ye komo noro nguya nowoondoyemo hamoo teyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Noro Awanemboro yangga ngu, ya gumi kowookowoo ooroote. Ngundiro kini ngu, asa, no kuri yeno ewano. No yeno hamoo eteno. No yengo musiyo yomosiyoyunowero oorowuteno. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","No oororo, yengo musiyo yoonenengoro yokoro ngu, asa, no ko omburo, ye yoyoro oorero, noya gobooro oruwato. Yo, nondo musiyongga oorootenoku, nguno ye nguya noya gobooro oruwato. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Yo, hamoo, nondo ngu endemo nguno oorowuweroyi ooreyiga ngu, ye kuri ingootenggo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ene ngundiro etoni, Tomasdo mande gumi eyingo. Urungga Oo Bidodo Simburi, ge ndaruwero ete? Noore ma ingooteto. Arisa, ndadiro terogogo, noore ngu oorega ngu kenoro ingowato? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Etoni, Yisasdo gumi eyingo. No, nondo nangge no oore. No nangge hamoo mande nguro Simburi, nondo nangge, suwooyi sano keta oruweroyi nguro Simburi. Oore guranonggo Awa tanggeyimo oorowuweroyi kini. Hamoo oorengo, kini, nononggo nangge Awa tanggeyimo oorowuweroyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ene ye kuri noro ingootenggoku, nguro ngu, ye noro Awanemboro nguya ingootenggo. Ataga ye damoni yero, ye ene ingoro kenootenggo, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ene ngundiro etoni, Pilipdo eneno eyingo. Oo Bidodo Simburi Simbunani, ge Awangge etuyero! Ge ngundiro etoyi ngu, asa, noore mete ero ingowato, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ene ngundiro etoni, Yisasdo gumi eyingo. Pilip, naru pirungga no yeya gobooro oruwootoku, ge noro ma ingoote? Oni ene no neyooteku ngu, ene Awane nguya kenoote. Ndadiro nguro, ge Awangge noore etuyero, ero ete? ");
INSERT INTO rwo_rawa_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","No Awano oodoowe, ko Awando ene nono oorooteroku, nguro ge nowoondogemo hamoo ma tete, bine? Nondo mande yeno etenoku nga ngu, nondo nenengo ingondudunonggo ma eteno. Kini, Awa noya ootooro, ngunonggo enengo ingondudunimonggo nangge enengo koni ngu tete. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ye ngu komo nga mande ngaro nowoondoyemo hamoo teyi. No awano oodoowe, ko Awa ene nono ooroote. Ye nguro nowoondoyemo hamoo mete ma tetoni ngu, asa, ye komo nondo oo songo gura onindo ma teweroyi tetenoku, nga bidodoboro ingondudu teya, nguro ye komo noro nowoondoyemo hamoo teyi. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Hamoo oorengo, no yeno eteno. Oni ene noro newendemo hamoo tetoni ngu, nondo ko oo tetenoku nga, ene nguya ngu ko oo ngu mete tewa. Ene ko urungga oorengo tero, ene nondo kongga tewonoku, ngundo no daganerowa. Ndadiro nguro, no Awa tanggeyimo oorowuteno. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Yendo oo bidodoboro no oowoonemo kira ewanggoku ngu, no ngu ooga ngu tewano. Ngundiro nguro, Awa ngu enengo nangonimo ene bingamini duridarinidodo tewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Yo, hamoo, ye no oowoonemo oo guraro kira ero teni ewanggoku ngu, asa, no ngu ooga ngu komo hamoo tewano, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Yisasdo ngandiro eyingo. Ene ye nowoondoye no nunoro ngu, arisa, ye noro mamana mandene ngu gome keyowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nondo Awano kira etoowe, enendo ngu oo gura ye hoorooweyeroro yanggango teyunootoni (Yuka Kundingiyi), ngundo yeya suwooyi sano sugi sugi oruwanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ngungga ngu, hamoo mande eweroyi Yuka. Mera ngaro oni simoo bare ngu, ene ma yowanggo. Ndadiro nguro, ene nowoondoye ma teyingo, nguro ene kenoro ingoweroyi nguya, ereremo kini. Ene yendo ngu ingootenggo. Ene yeya gobooro ootooro, ngunonggo ye nowoondoye newendemo uro, yeya oruwanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nondo ye yoyokootoowe, ye awanamoye kini kookewa ngundiro ma oruwanggo. Kini, no ye tanggeyemo omburo, yeya oruwato. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Naru bodaga nangge, mera ngaro oni simoo baredo, ngu no ma neyowanggo. Ene yendo nangge no neyowanggo. Ndadiro nguro, nondo keta sugi sugi oruwanoku, ngundiro nangge, ye nguya sugi sugi ketangga nguno oruwanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Yo, hamoo, ngu naruno nguno, ye ingowanggo. No Awanemboya oodoowe, ko yendo ngu noya oodoyi, nondo yeya oruwato. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Oni ene noro mamana mande yoro, gome keyooteku ngu, ngu oningga ngu ene newende no nunoote. Oni ene newende no nunooteku ngu, Awaro newende nguya ene inowa. Nondo nguya nowoondone ene inoro, nenengo murine, ene doongeyimo yootunoro etungootoowe, ene no neyoro ingowa, ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yisasdo ngundiro etoni, Yudas gura, Yudas Iskariyoot kini, ngundo Yisasno eyingo. Oo Bidodo Simburi Simbunani, ndadiro nguro, ge noore doongenanimo tunootewero eteku, ene ge mera ngano oni simoo bare doongeyemo ma tunootewa? Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yudas ngundiro sumoo etoni, asa, Yisasdo mandeni gumi eyingo. Oni ene newende no nunoro ngu, ene noro mande gome keyowa. Ene ngundiro keyootoni ngu, asa, noro Awanembo nguya, ngu oningga ngu, newende inootoni, noore eneno omburo eneya suwooyi sano sugi sugi oruwato. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Oni ene newende no ma nunoro ngu, ene noro mandene gome nga ma keyoote. Nga mandega yendo ingootenggoku nga, ngu noromu kini. Nga ngu Awa no surenerootoni ombuyingongga, nguro mandeni. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","No ataga yeya gobooro ootooro, ngunonggo mande oo nga tunooteweroyi ngu yeno ero etuyerootenoku nga. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ene ye hamoo oorengo Hoorooweyeroyingo ngu, Yuka Kundingiyi. Ngu no oowoonemo ngu Awando yengo soweyootoni ombuwa. Enengo koni ngu ngandiro. Ngundo ngu oo bidodo etuyeroro, nowoondoye yokutuwootoni, ngunonggo nondo mande yeno ewonoku, ngu bidodo tunoo oorengo ingomukowanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Arisa, no ye yoyokowero, nguro noro nowoondoyi imakeyingo oorooteku, ngu yeno nguya yewe tunootero oruwa. Nondo yengo nowoondoyiga ko nowoondoyi imakeyingo teyunootenoku, ngundo mera ngaro oni simoo baredo nowoondoyi imakeyingo teyunootenggoku, ngu dagate. Nguro ye nowoondoye ma soriyokoro sosorewero. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ye nga mandega nga ngu etuyerowonoku, ngu ye kuri ingowonggo. No ye yoyokoro oorero, no ko yeno ombuwano, ero ewonoku, ngu ingoyi. Ene kuri ye nowoondoye no nunowonggoku ngu, asa, ye ingoro oni oni tetoyi, no Awano ko oorowuwano. Ndadiro nguro, Awando no daganeroro, ene Urungga oorengo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ataga oo ngu ma tunooteyingomo, no yeno kuri ero etenoku nga. Ngundiro nguro, kootuyisina oo ngu tunootetoni ngu, asa, ye nguno nowoondoyemo hamoo tewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Arisa, no yeya mande mande urungga ko ma ero ingowato. Ndadiro nguro, mera ngaro nguro sobosobo tabango urungga ngu ombute. Enengo yanggangoni ngundo no ma sobonerowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ene mera ngaro oni simoo bare ngu komo ingowanggo. No nowoondone Awane inooteno. Ngundiro nguro, no Awando oo teweroyi mande ero no nunowoku, ngu nangge teteno. Arisa, ye ootoogetoyiga oorowuwooto! Ero eyingo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yisasdo mande gura eyingo. No ngu Wayin de oorengo. Awanembo ngu ene Wayin kongga nguro Simburi. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Noro kambini ngu ma enggetoni ngu, Awando andangero yokowa. Ene ko kambinine bidodo enggeteku ngu, Awando gome toongooro, gome yomosiyowa. Ngundiro tetoni, engge gome oowooyingga oorengo enggewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ye ngu nondo mande ngu ero etuyerowonoku, ngundo ye nowoondoye yeni gome sarayi tunootewonggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ye komo no dowooro oodoyi ngu, asa, nondo nguya ye yodowooro oruwato. Wayin dega ngu kambini wimbuyi bungomo ma dowooro ngu, ene enggeweroyi nguya kini. Ngundiro nangge, ye nguya nono ma ootooro ngu, ye ma enggewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","No de Wayin. Ye ngu Wayin de nguro kambini. Oni ene nono oodoni ngu, no nguya eneya oodoore, ene ngunonggo gome urungga enggewanggo. Ene ye no noyokoro ngu, asa, ye oo gura nguya ma tewanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ene oni gura nono ma oruwaku ngu, asa, ene ngu de kambini ngundiro andangero yokootoyi ariyewa. Yo, onindo ngu de kambini, ngu yowuruwooro gasiyoro, de nombono katoyi demukowa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ene ye noya oodoyi, noro mandene yeya oodoni ngu, arisa, ye oo guraro ingoro kira ewanggoku ngu, oo ngu, ngundiro yeno tunootewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ene yendo gome urungga enggewanggoku muringga nguno, ye noro kirikiri oni kirarongo, ngu simoo bare etuyerowanggo. Ngundiro muri gomengga, ngunonggo noro Awane nguro oowooyi bingaminidodo tunootewa. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Awando newende no nunoyingo, ngundiro nangge, nondo yengo kuri nowoondoyi nguya teyunowono. Nguro, ye komo noro mandene nga suwooyi sano ingoro oodoyi, ngu nondo hamoo nowoondone ye yunowano. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nondo kuri Awanemboro mamana mandeni gome keyowonoku, nguro ngu, no Awane enengo nowoondoyiningga ngu newendemo oorooteno. Ngundiro nangge, ye noro mamana mande gome keyowanggoku ngu, arisa, ye nguya noro nowoondoyinengga ngu newendemo oruwanggo. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","No ngandiro ingooteno. Noro oni oningga ngu yeno oodoni, ye nowoondoyemo nguno angeya manggowoomo ooreni, ero ngundiro ingooteno. Ngundiro nguro, no nga mandega nga, yeno eteno. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Noro mamana mande ngu ngandiro. Nondo yengo nowoondoyi teyunootenoku, ngundiro nangge, ye komo dobookuriyeboro ngundiya teyi! ");
INSERT INTO rwo_rawa_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ene oni gurado ene dobookuriyi hoorooweyerowero, enengo ketangga ngu yokowaku ngu, arisa, nowoondoyi teyingo muringga, ngundo nowoondoyi teweroyi muri gidarega, ngu hamoo oorengo dagayeroote. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ye nondo etenoku muringga nga tetoyi ngu, asa, ye ngu noro dobookurine. ");
INSERT INTO rwo_rawa_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ko oni ngu enengo oni urungga, ngundo ko oo teteku ngu ma ingoote. Ngundiro nguro, nondo yeya ko oni ero ma ewano. Kini, mande bidodo nondo Awanonggo ingowonoku, ngu yeno etoowe, ingomukowonggoku ngu! Nguro nondo yeya ngu dobookurine, ero ewano. ");
INSERT INTO 