﻿USE sofia;
DROP TABLE IF EXISTS sofia.rwo_karo_vpl;
CREATE TABLE rwo_karo_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES rwo_karo_vpl WRITE;
INSERT INTO rwo_karo_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Nga oni nga ngu, Yesus Kristuslo osi sembeni. Yesus ngu ene Dewitlo sowe. Ko Dewit ngu ene Ebarahamlo sowe. ");
INSERT INTO rwo_karo_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ebaraham ngu ene Ayisak eweyi, Ayisak ngu ene Yekob eweyi. Yekob ngu ene Yuda, ko konebobeyi ngulo awaye. ");
INSERT INTO rwo_karo_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda ngu ene Peres, Sira elaga awayali. Namoyali ngu Tema. Peres ngu ene Hesalon eweyi. Hesalon ngu ene Ram eweyi. ");
INSERT INTO rwo_karo_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ko Ram ngu ene Aminadap eweyi. Aminadap ngu ene Nason eweyi. Nason ngu ene Salomon eweyi. ");
INSERT INTO rwo_karo_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ko Salomon ngu ene Bowas eweyi. Nemi ngu Rehap. Bowas ngu ene Obet eweyi. Nemi ngu Rut. Obet ngu ene Yesi eweyi. ");
INSERT INTO rwo_karo_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yesi ngu ene Yuda onilo sobosobo koleteyingo oowooyi Dewit, ngulo eweyi. Dewit ngu ene Solomon eweyi. Nemi ngu kuli Yurayiya baleyi oluwoli. ");
INSERT INTO rwo_karo_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon ngu ene Riyabowam eweyi. Riyabowam ngu ene Abayisa eweyi. Abayisa ngu ene Asa eweyi. ");
INSERT INTO rwo_karo_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ngu ene Yehosapat eweyi. Yehosapat ngu ene Yoram eweyi. Yoram ngu ene Asayiya eweyi. ");
INSERT INTO rwo_karo_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Asayiya ngu ene Yootam eweyi. Yootam ngu ene Ehas eweyi. Ehas ngu ene Hesekayiya eweyi. ");
INSERT INTO rwo_karo_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekayiya ngu ene Manasa eweyi. Manasa ngu ene Emos eweyi. Emos ngu ene Yosayiya eweyi. ");
INSERT INTO rwo_karo_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosayiya ngu ene Yekoniya, ko konebobeyi ngulo awaye oodoni, ngu naluno me oni Babilonnonggo Iserel oni yoyolo yoyokootoyi, Babilon melako oololo oluwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ngu naluno, ene Babilon melako oodoyi, Yekoniya ngu ene Siyalitiyel eweyi. Siyalitiyel ngu ene Serababel eweyi. ");
INSERT INTO rwo_karo_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serababel ngu ene Abayiyud eweyi. Abayiyud ngu ene Ilayiyakim eweyi. Ilayiyakim ngu ene Eso eweyi. ");
INSERT INTO rwo_karo_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Eso ngu ene Sedok eweyi. Sedok ngu ene Ekim eweyi. Ekim ngu ene Ilayiyud eweyi. ");
INSERT INTO rwo_karo_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ilayiyud ngu ene Eliyesa eweyi. Eliyesa ngu ene Matan eweyi. Matan ngu ene Yekob eweyi. ");
INSERT INTO rwo_karo_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yekob ngu ene Yosep eweyi. Yosep ngu ene Mariya kameyi oode, Mariyando Yesus yomoowolo. Yesus ene Kristus Anutndo noole yoyowelo sunggi yeyingo oni ngu. ");
INSERT INTO rwo_karo_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ngulo ngu, Ebarahamlo sowe bidodo ombulo, wenga Dewitno ngulo osi sembesembeni kande elaya kegidembolo namolaya yokowonggori. Dewitlo sowe bidodo ombulo, wenga ene osisambaye kande elaya kegidembolo namolaya oololo, Babilon me onindo ngu, Iserel oni yoyolo, Babilonno yoyokowonggori. Yoyokootoyi, Babilon melako oluwonggoku oodoyi, wenga ombulo, ngulo sembesembeni nguya bidodo kande elaya kegidembolo namolaya oololo, Yesus Kristus tunootewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesus Kristus yomootoni tunooteyingo, ngulo mande ngu ngandilo. Nemi ngu Mariya, ene kuli Yosepndo sunggi yewolo. Ene goboolo ma oluwoku naluno, Yuka Kundingiyi, ngundo Mariya yeni, ene useyidodo tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Kameyi Yosep, ngu oni nenengo oolengo, ngulo ene Mariya oni doongeyemo oyumo inowelo ma ingowolo. Ngundilo ngulo, ene toligemangge yokoweloyimbolo ingowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Yosep ngulo ingondandangelootoni, ngu naluno nguno, gabono ngu Oo Sembuli Sembunayimbolo Sambono Engel oni, eneno tunootelo ewolo. Yosep, Dewitlo osiyi, ge balege Mariya ngu yowelo ma sosolewelo. Ndatelo ngulo, nga simoongongga useyimo inowokungga, ngu Yuka Kundingiyimbo inowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ngu simoongga useyimo oolooteku, ngu yomootoningga ngu, gedo ngu oowooyi Yesus eya e. Ndawugalo ngulo, ngundo enengo simoo balelo mbumbuwa andangeyunolo ko yoyowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","Yo, Yuka Kundingiyimbo ngu simooyengga ngu yeni tunootewoku, ene Oo Sembuli Sembunaye, ngundo Anutlo ingondudu eyingo oni manggowoomo, kuli ngandilo ewolo. Ingoyi, bale gula ene simooya ma weleyingomu, ngu ene useyidodo telo simoongga yomoowa. Ngu oowooyi Imanuwel ewanggolo ewolo. Yo, nga mandega nga Anutlo ingondudu eyingo oni, enendo kuli eyingomu, ngu ataga enggeni tunootete. Imanuwelngga ngulo damoni ngu ngandilo: Anut nooledodo ooloote. ");
INSERT INTO rwo_karo_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yosep welewoku, ngunonggo ene ootookoolo, Anutlo Sambono Engel onindo ewoku, ngundilo tewolo. Ene baleyi Mariya yolo, enengo yano uwoli. ");
INSERT INTO rwo_karo_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ene Yosep Mariya nguya ma welewoli. Kini, ene ngundilo kingo oode oode oololo, Mariya simoo yomoowolo. Simoonggaku yomootoni, ngu oowooyi Yesus ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ngu naluno nguno ngu, Herod ene Yuda onilo tabango koleteyingo oluwokuno, Mariyando Yesus Betelehem endemo, Yudiya melasina nguno yomoowolo. Mariya kuli Yesus yomootoni ngu, ingondudu oni gidega sa ooletekusinanggo ngu, Yerusalem endemo mayelo, sumoo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Yuda onilo sobosobo koleteyingo ulungga nemimbo keda simooye bodaga yomootoni tunootewoku, ngu ndano? Noole komo enengo dootungga sa ooletekusinanggo kenolo, ngu keyolo, ngulo noole yade yade ombulo, ngulo yambo mande teyinowelo mayetetoku nga! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Mande ngundilo etoyi, mela sobosobo koleteyingo Herod ngu mandegaku ingolo, ene soliyokowolo. Ngundilo nangge, Yerusalemno oni simoo bale bidodo, ene nguya ngu mandega ingolo soliyokowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ngundilo ngulo, Herodndo Anutno woolo yeyingo oni ngulo sobosobo oniku, ko Iserel oni mamana mande etuyeloyingo oni ngudodo goobooyingoyelolo, sumoo yunolo ewolo. Kristus ngu ndawu endegano tunootewalo, sumoo yunolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Sumoo yunootoni, ene mande gumi ngundilo ewonggori. Betelehem endemo Yudiyasina nguno tunootewalo ewonggori. Anutlo ingondudu eyingo onindo ngandilo elo nakangowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ye Betelehem oni simoo bale Yuda onilo melako oolootenggoku, yengo ende ngundo ende bidodo dagayelolo, ngu oowooyidodo ulungga. Ndatelo ngulo, yeno nguno ngu sobosobo oni ulungga tunootewaku, ngundo ngu, nolo oni Iserelno ngulo sobosobo ulungga oluwa. Yo, ngu sobosobo oningga, ngundo Yudalo sobosobo oni bidodo ko tewonggoku, ngu dagayelowa. Ngu oningga ngundo mande gome nenengo ngu elo yunololuwalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Herodndo ngu mande ingolo, ngulo ene toligemangge ingondudu oni sa ooletekusinanggo mayeyingoku, ngu negoyelootoni ombuwolo. Ombutoyi, sumoo sumoo yunolo ewolo. Ndawu nalunggano ngu dootungga ngu koletelo kenootoyi tunootewo? Elo sumoo yunowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ene mande gumi ingolo ewonggori. Ye sodedonangge Betelehemno oolouya, ko yanggango teya, ngu simooyengga ngu ereweya kenoyi. Ye oolouya kenoya ngu, ariya, ombuya, nono mande gumi etoyi ingowano. No ingolo ngu, asa, no nguya oololo, eneno eseteyinowanolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Ariya, Herodlo mande ewoku ingomukolo ngu, ene endesina oolelo, sa ooletekusina, ngunonggo dootungga kenolo keyowonggoku, ngu ko kenolo, ngulo ene oni oni ulungga tewonggori. Ngundilo tetoyi, dootungga ngundo ene ingondududodo oni ngu koletelo oolelo, simoo buniyo, Yesus oolooteku yanggaku ngu etuyelolo, ngu sanganimo oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Dootunggaku nguno oodoni, oniku ya newendemo ulo, ene simooyenggakuya, nemi Mariya nguya yeyowonggori. Yeyolo, ene boodooye oondookelo, penggootelo, Yesusno yambo mande telo eseteyinowonggori. Teyinolo, enengo Pawus andangelo, oo gome gome uliyi ulungga ngu yolo, duwoo kingo inowonggori. Ene bobeye gol, ko, de elaya ngulo situmi ngu woolo yetoyi, ndindingo gome teweloyi, ngu yolo, kingo duwoo Yesus inowonggori. Ngundilo telo, ene Yesus bingaminidodo teyinowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ngu suwoono, Anutndo ingondudu onikuno gabono yootunolo ewolo. Ye Herodno ko ma oolouwelo. Ndawugalo ngulo, Herodndo Yesus uleyi kumooweloyimbololo ewolo. Ngulo ene ingolo, oololo, Herodno ko ma oolouwonggori. Kini, ene oololo, oole gulawoole ko enengo endemo sawonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ingondudu oniku kuli satoyi ngu, suwoono Yosep gabono kenootoni, Oo Sembuli Sembunaye, ngulo Sambono Engel onindo eneno yootunolo ewolo. Ge komo sodedonangge ootookooya, balege ko nangongge yoyoya, Igip melako toongeya oolou. Ge Igip melako nguno oodoga, nenengombo ko etoowega, ko ombuyi. Ndatelo ngulo, Gabman oni tabango ulungga Herod, ngundo simooye yeyolo, yuleyi kumoowelo, mande ngundilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Engelndo ngundilo etoni, Yosep ngu ingolo, asa, ene suwoono nangge ootookoolo, nangoni ko baleyi Mariya nguya yoyolo, yade yade Igip melako oolouwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Yosep ngu melako oodoni, nguno oni tabango ulungga Herod ngu kumootoni, ngulo ene Igip mela yokolo toongewonggori. Ngundilo tetoni ngu, asa, Anutlo mandeno, ingondudu eyingo oni manggowoomo eyingo, ngu engge tunootewolo. Ene ngandilo ewolo. Nenengo nangone Igipno oolooteku, ngu meno etoowe ombuwalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ngu naluno, Gabman oni tabango ulungga Herod ene ingowoku, ingondudu onindo sa ooletekusina, ngundo ganangolo toongewolo. Ariya, ene newende sanggili ulungga oolengo tewolo. Ngundilo telo, enengo me oni suleyelootoni oololo, Betelehemno, ko, ende Betelehem namokono nguya simooye owita mooma elaya ma yokoyingomu, ko, simooye moomaye elaya nguya, ngu yuleyi kumoomukowonggori. Ndatelo ngulo, ingondudu oni, ngundo dootu mooma elaya kuli koletelo tunooteyingo ngu etoyi, ingowoku, ngulo ene ngundilo tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","Ngu ooku kuli Anutlo ingondudu eyingo oni, Yeremayiya, ngundo eyingo ngu, ataga engge tunootete. Ngu ngandilo ewolo. Ene manggoye gula Rama ende Yudasinanonggo ingowonggo. Ene sendo mogulu biyobiyomi telo, nowoondoyi tewonggoku, ngu ingowonggo. Resel (Iserel oni simoo bale) enengo simoongokulo sendolo biyomi ingowolo. Oni simoo baledo newende yeyi, imakeweloyi nguya kini. Ndatelo ngulo, simoongo gula ma yokoyingo, ngu bidodo utomukowonggorilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","20","Yosep baleyi ko nangoyali Igip melako oodoyi, ngu naluno nguno, Gabman oni tabango ulungga Herod ngu kumoowolo. Kumootoni ngu, Oo Sembuli Sembunaye, enengo Sambono Engel onindo Yosepno ombulo, gabono yootunolo ewolo. Ge ootookooya, Mariya elanasa yoyoya, Iserel ko oolou. Oningga nangongge uleyi kumooweloyinggaku, ngu kuli kumoowololo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ariya, Yosep mande ngu ingolo, ene ootookoolo, Mariya elanasa yoyolo, Iserel melako ko oolouwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ene Akeleyasndo eweyi Herodlo kongga ngu yolo, Yudiya mela ngulo tabango ulungga oluwoku, ngu Yosep ingoote. Ngundilo ngulo, Yosep ngulo sosoletoni, ngulo gabo gulano Anutndo Yosepno yootunolo ewolo. Ngundilo ngulo, ene Galili gumisina oolouwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ene oololo, ende oowooyi Nasaret nguno bibitewonggori. Nguno ngu, kuli Anutlo ingondudu eyingo oni ngulo mandeye ewoku, ngu ataga engge ngundilo tunootete. Ene Nasaret oni ewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ngu naluno, Sonoyeloyingo oni Yon ngu tunootewolo. Ene Yudiyano, oni kini kingo melako nguno, Anutlo mande oni simoo baleno wesiyolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ngundo ngandilo ewolo. Ye komo nowoondoye yowoolengoyi, Anut Oo Bidodo Sembuli Sembunaye, ngundo nalu enengo oni simoo bale soboyelooteku, ngu namoko ombuwelo tetelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yon oningga kuli Anutlo ingondudu eyingo oni, Ayisaya, ngundo mandega ewoku, ngu ataga engge tunootete. Ene ngandilo ewolo. Oni kini melako, ngunonggo oni gulado menongga ngandilo ewolo. Oo Sembuli Sembunaye, ngulo oo bidodo yoonenengoya, ngulo oole yomosiyootoyiga, ene ombuwalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yon ngu, ene bo gula oowooyi Kamel, ngu uyimbo nenggulo teyingomu ngu owoolongo onindo nenggulo ngundilo telo, ko, utombo wanggango gosiyololuwolo. Enengo oowali ngu katu, deguno siso ngu neloluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","6","Ngu naluno, Yerusalem oni, Yudiya oni bidodo, ko, Yodan sono tanggeyimo ende, ngunonggo oni ngu bidodo Yonno mayelo, enengo mbumbuwa wesiyootoyi, ngulo ene Yodan sono newendemo utoyi, ngundo sono kundingiyimbo sonoyelowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yondo Moseslo mamana mande sobowooyingo oni oowooye Parisi, ko kumoononggo ma ootookoowa elo ingoyingo oni oowooye Sadusi, ngu yeyootoni, sono gemuwelo ombuwonggori. Yondo ene kuli ingowoku, Parisi ko Sadusi oni nowoondoye ngu ma yowoolengoyingo, ngulo ngu, ene sanggili telo ewolo. Ye sile biyomi simoongo! Ye onendo etoni, Anutlo sanggilini yeno ombutoni, ye mete sawanggo? Ye ereremo kini! ");
INSERT INTO rwo_karo_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ye nowoondoye yowoolengolo hamoo tetoyi ngu, asa, yengo endeyoyingo ngulo engge nguya yowoolengolo, gome tunootewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ye nowoondoyemonggo ngandilo ma ingowelo. Ebaraham ngu noolengo osinayi ngulo Anutndo gome soboyelowaku ngu, elo ma ingowelo! No yeno eteno. Hamoo oolengo, Anutndo mete nga digi nga tetoni, Ebaraham simoongo tunootelo, Anutlo oowooyi elo okoowanggo! ");
INSERT INTO rwo_karo_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Yo, Ebarahamlo sowe ngu de ngundilo. Sopolo kuli de damonimo ooloote. De gidega gome ma enggeteku, ngu onindo doongoolo ngu, asa, ene de nombono oolongootoyi dewa. Oni nguya ngundilo nangge, nowoondoyemo hamoo ma telo gome ma enggewanggoku ngu, asa, ngundilo yodoongoolo, Setanlo de nombo ma kumooweloyi nguno oolongooyelootoni yoodewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ye kuli nowoondoye yowoolengootoyi, ngulo nondo sono kundingiyimbo, ngu sonoyelooteno. Ene oni gula no kootunesina ombuwaku, ene ngu oningga ngulo yanggangoni ulungga oolengo. No yanggangone bodaga nangge, ngulo ngu, no enengo ko oni nangge. Enendo ngu Anutlo Yuka Kundingiyi, de gookingo ngundo ye sonoyelowa. Yo, Anutndo yengo mbumbuwaye delo, ngu nowoondoye yeni, namboyi oolengo yewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Yo, oni simoo bale bidodo Kopi tanggooli ngundilo. Oni Kopi tanggooli dangelo, tuloolo, ene tanggooli metemimu ngu yomosiyolo yolo, enengo yano yewanggo. Ene Kopi biyomimu yolo, ene de nombo ma kumooweloyi, nguno oolongootoni oluwalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ngu naluno, Yesus Galili mela yokolo, ene Yodan sonono ulo, Yondo sono kundingiyimbo sononelonilo ombuwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ngundilo etoni, ene Yondo Yesuslo mande gosiyowelo ingolo, enendo sumoo ewonggori. Ndawugalo ngulo, ge nondo sono kundingiyimbo sono nelolo ingolo ombute? Gedo mete Yuka Kundingiyimbo no sono gemununo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ene Yesusndo mande gumilo ewolo. Nguno yokoya, nondo etenoku ngundiya te. Noole komo damoni mesalango oolengo, Anutndo damoni ngundilo ngulo ingooteku, noole ngu keyowalolo ewolo. Ngundilo etoni, Yondo yo, mete, elo, ene sonowoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesus sono gemulo yokolo, sakiko ooletoni ngu, sodedonangge Sambo ende yamako goosootoni, nguwoole Anutlo Yuka Kundingiyi Yesusno ombuwolo. Yuka ngu, nu kundilimanggowo ngundilo telo ombuwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ombutoni ngu, asa, Anutlo manggowo Sambononggo ngandilo ewolo. Ngu nenengo nangone. No enengo gome mesalango ingooteno. Nowoondone ngulo gome mesalango oolengo ingootenolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ngu naluno, Yuka Kundingiyimbo Yesus yolo, oni kini kingo melako toongetoni, Setando nguno tewoongowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yesus ngu, ene sa onibi elaya, ko suwoo onibi elaya nguno oowali neweloyi oo ma yowolo. Ene kingo oode oode ombulo, ngu naluno, ene oodoolo ulungga kumoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ngundilo oodoolo kumoolo oodoni, ene tewoongoweloyi oninggaku Setan, ngu tunootelo, enendo Yesusya ewolo. Ge Anut Nangoni tetoningga ngu, ge etooga, digi nga yowoolengoya, oomanangoyingo tunootetoningga nelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ngundilo etoni, ene Yesusndo mande gumi ngandilo ewolo. Anutlo nakayano ngandilo ete. Oowali nelo, nguno nangge, oni sugi sugi keda ngu yunoweloyi nguya, ereremo kini. Kini, mande bidodo Anut manggowoomonggo tunooteteku, ngundo nangge, oni sugi sugi keda oluweloyi ngu yunowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ene ngundilo etoni, Setando yolo, ende kundingiyimo Yerusalem oololo, ngu yolo, Yudalo goobooyingo ya ulungga oowooyi Tempel ngu sanganimo oolewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","7","Oolelo, enendo ewolo. Ge Anut Nangoni tetoningga ngu, ariya, ge paleya amuno sole. Ndawugalo ngulo, Anutlo mandeno ngundilo ete. Anutndo enengo Sambono Engel nguno etoni, geno ombulo, ngundo kandeye sanganiwoole goyolo utoyi, ge digibo ma gosanggawewa, ewolo. Ariya, Yesusndo enengo mande ngu ingolo, enebana gumi ewolo. Anutlo oo nakayano ngandilo nguya ete. Gedo Oo Bidodo Sembuli Sembuge, ngu ma tewoongowelo. Ngu gengo Anut Ulungga! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ngundilo etoni, asa, Setando Yesus ko mela pulingga awuno oolengomu, nguno yolo oolewoli. Setando nguno mela bidodo dulidalini, ko, oo gome gome nguya etungowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ene ngundilo oo gome gome etungolo ngu, asa, ngundo Yesusya ewolo. Ge nono boodoo oondookelo, penggootelo, yambo mande tewaku ngu, ariya, nondo mete nga oo nga, ge gunowanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ene mande ngundilo etoni, asa, Yesusndo mande yanggango gumi eneno ewolo. Setan, ge toonge! Anutlo mandeno ngandilo ete. Ge Oo Bidodo Sembuli Sembunaye, nguno nangge, yambo mande teyato! Ngu gengo Anut, ko, ge enengo ko nangge dowooya ootoo! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ngundilo ngulo, Setan ene yokootoni, ngu naluno nguno, Sambono Engel onikundo ombulo, Yesus hooloowewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ngu naluno nguno, Yesus ngu ene Yon ngu dowoolo, ya biyomimo yewonggoku, ngu ingolo, ngulo ene Galili melako oolouwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ene oololo, enengo ende damoni Nasaret yokolo, yade oololo, ene Kaperniyam endemo tunootelo, nguno ko tewolo. Kaperniyam ngu sono koongewo ngu namoko, Sebulan, ko, Naptalayi mela elayaga ngulo suleyembolo melako nguno oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Yo, ene ngundilo ooloutoni, ngulo kuli Anutlo ingondudu eyingo oni Ayisayando mandega ewoko, ngu engge tunootete. Enendo kuli ngandilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","16","Sebulan ko Naptalayi oni simoo bale ngulo musiyo oolootenggoku, ngu oole wendeyi tanggeyisina utenggoku, ngu Yodan sono anduloko, Galili mela gumisina, nguno oni sowe oowooyingga ulungga nguno oolootenggo. Ngu melangga ngu bidodomo, damoni biyomi oowooyingga telo oolootenggoku, ngundo solu himi ulungga kenootenggo! Ngu oni simoo bale ngu, ene nowoondoyemo hamoo kini oonateweloyi musiyomo oolouwelo telo oolootenggoku, nguno kuli solu himi eneno tunootewoku ngu! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ngu nalunggano nguno, Yesus ene damoni yelo, mande wesiyolo ewolo. Ye nowoondoye yowoolengoyi! Ndawugalo ngulo, Anut Oo Bidodo Sembuli Sembunaye, ngundo nalu enengo oni simoo bale soboyelooteku, ngu kuli namoko ombutelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ngu naluno nguno, Yesus ene Galili sono koongeyingo dabemiwoole ombulo, elabasa elaya ngu Sayimon oowooyi gula Pita, ko ngulo koneyo Enduru ngu yeyowolo. Elabasa enengo isolo si sono koongeyingomo oolongoolo, iso yolo, ngu uliyoweloyimbolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ene elayaga nguya ewolo. Yali no keneloya endeyoli. Yali oni simoo bale yoyolo, Anutlo mandeno yoyoweloyi ngu etuyelowanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ene ngundilo etoni, asa, sodedonangge elayagaku isolo si yokolo, ene Yesus keyolo sawonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ene ngundilo telo, ene songgula bodaga oololo ngu, ene elabasa elaya nguya yeyowolo. Ngu Yems, Sebedilo nangoni, ko ngulo koneyo Yon. Elayaga ngu awayali Sebediya wanggo sanganimo ootoolo, ene isolo si yomosiyolo, oodoli yeyowolo. Yeyolo, asa, Yesusndo elayagaku negoyelowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ngundilo negoyelootoni, ariya, sodedonangge elayagaku awayali ko wanggo nguya yokolo, ene ombulo, Yesus keyowoli. ");
INSERT INTO rwo_karo_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesus Galili mela bidodomo endeyolo, ene Yuda onilo goobooyingo ya newendemo ulo, oni simoo baleno Anutlo mande damoni, ngundo enengo oni simoo bale soboyelooteku, ngulo mandeni gome wesiyolo yunoote. Ene mande ngundilo wesiyolo, ngunonggo oni simoo bale sayi oowooyingga moondeye yombuliyeloyingomu nguya yomosiyelowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Enengo mandeni Siriya mela bidodomolo endeyowolo. Ngundilo ngulo, oni sayi damoni gula gula yolo; ogingoyingo ulungga ingolo oolootenggoku, ngu yoyolo mayelo; oni yuka biyomidodomu; oni gaboye kumoolo kekandeye mboolomboolo ulooteku; ko, oni wembuye bingo yeyingomu nguya, ngu bidodo yomosiyelowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Oni simoo bale oowooyingga oolengo Galilinonggo, ko Dikapolissinonggo, ende kande elaya ngulo musiyo ulungga, Yerusalemnonggo, Yudiyanonggo, ko, Yodan anduloko nguya ene Yesus keyowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesus oni simoo bale oowooyingga oolengo yeyolo ngu, ene mela puli sanganimo oolelo, bibitetoni, enengo sulena oniku, eneno oolewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Nguno Yesusndo mande etuyelolo, yunolo, ngandilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Oni ene ingowanggo. Ene Anut doongeyimo ereremo kini, elo ingootenggoku ngu, asa, ene oni oni tewanggo. Ndatelo ngulo, Anutndo ene kumana yunowa. Yo, ngundilo oni, ngundo ngu Anutndo endega enengo oni simoo bale soboyelooteku, nguno ulo oluwanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Oni sendolo, nowoondoyemo kowuli ulungga ingootenggoku ngu, Anutndo hoolooweyelolo, kowuliye andangelo, nowoondoye yeni imakewoku, ngulo ene oni oni tewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Oni damoni mesalango imakeyingomo oolootenggoku ngu, Anutndo kumana yunolo, mela oo yunowelo elo gosiyowoku, ngu yunowaku, ngulo ene oni oni tewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Oni oowalilo ko sonolo, ingolo, hahangetenggoku ngundilo, oni nowoondoyemonggo Anutlo damoni nenengo ngu keyowelo hahangetenggo. Ene ngundilo telo oodoyi, asa, Anut enengombo nowoondoye yeni, metemi oolengo telo, ngulo ene oni oni tewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Oni ene simoo bale gidalega nowoondoye yunootenggoku damoningga, ngulo ene oni oni tewanggo. Ndatelo ngulo, Anutndo enengo nguya nowoondoyi yunowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Oni Anut doongeyimo nowoondoye mesalango oolengo oolootenggoku ngu, ene oni oni tewanggo. Ndatelo ngulo, ene Anut kenowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Oni ebe toongootoyi, ene nowoondoye imakeyingomo oluweloyi oningga ngu, ene mete oni oni tewanggo. Ndatelo ngulo, Anutndo ngu oni nguya nenengo simoonelo ewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Anut doongeyimo, oni nenengo oodoyi, ngulo oni gidalegado kingo kowuli oowooyingga yunootoyi, ngulo ene nowoondoye kowuli ma ingowanggo. Kini, ene oni oni tewanggo. Ndatelo ngulo, Anutndo ene yoyolo, endega enengo oni simoo bale soboyelooteku, nguno oluwanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","12","Ngundilo nangge, ye no kenelootoyi, ngulo melako oni, ngando kootuyesina mande biyomi elo kowuli oowooyingga yunolo, kingo mande ebe ganagana etoyi ngu, ngulo ye nowoondoye kowuli ma ingowelo. Kini, ye komo oni oni teya, nowoondoye imakeyingomo ootooya, Anut oowooyi bingami eya okooya, oni oni teyi. Ndatelo ngulo, ye Sambo endemo oo ulungga ngu yowanggo. Ngundilo nangge, melako onindo Anutlo ingondudu eyingo oni nguya koletelo yombulibaliyelowonggorilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Yesusndo mande gula ewolo. Ye Anutno nowoondoyemo hamoo teyingongga, ngu melako ngano sayi nembo (Sol) ngundilo. Sayi nembo nengguloga ngu yoyokootoni ngu, asa, noolendo ngu nengguloga Sayi nembo nguno, ngu ko yeweloyi nguya ereremo kini. Yo, hamoo, sayi nembo ngu koni gula kini. Ngundilo ngulo, onindo oolongoolo, keyembo wongooweloyi. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ngundilo nangge, ye Anutno nowoondoyemo hamoo teyingo ngu, mela ngalo solu himi ngundilo. Ende gula pulimo soludodo oluwaku ngu, kombiteyingo ma oluwa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kini, onindo solu kalo, kumbe gula newendemo ma oongoowanggo. Kini, solu ngu yaba sanganimo tunoo yetoyi, oni ya newendemo oolootenggoku, ngu bidodo solu himi kenowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ngundilo nangge, oni nowoondoye Anutno hamoo teyingongga ngu, enengo solungga ngu oni bidodomo tunoo oodoni, yengo damoniye nenengo kenolo ngu, Anut Sambo Endemo oolooteku, ngu oowooyi bingami okoowanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Yesusndo mande gula ewolo. Ye ngandilo ma ingowelo, no ngano ombulo, Anutlo mamana mande ingondudu eyingo onindo kuli nakangoyingo ngu andangewalo ma ingowelo. Kini, nondo mamana mande ngu andangewelo ma ombuwonowolo. Nondo mamana mande ngu bidodo engge yewe tunootemukoweloyi, ngulo ingooteno. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","No yeno hamoo eteno. Sambo mela kinitetoni, ene nolo mamana mande ma kinitewa. Anutlo mamana mande nguno noolengo mande gumi bodaga, ko, so uyi nakango bobodi gulanangge nangge, ngu ma yokowa. Oo bidodo mamana mande ngu newendemo oolooteku, ngu enggeni tunootewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Oni gula Anutlo mamana mande gumi gula ma keyolo, ngunonggo ene oni gula ngundilo etuyelolo ngu, ariya, ngu oningga Sambo endemo ooleteku naluno, ene Anut doongeyimo, ngu oowooyi kini oluwa. Ene oni Anutlo mamana mande ngu keyolo, oni simoo bale oo ngundilo etuyelootoningga ngu, ariya, Anutndo Sambo endega enengo oni simoo bale soboyelooteku, nguno ngu, oningga ngu oowooyidodo tewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","No yeno hamoo eteno. Anut doongeyimo, yengo damoni nenengongga, ngundo komo Moseslo mamana mande sobowooyingo oni Parisi, ko, mamana mande etuyeloyingo oni nguya, enengo damoni nenengo ma dagatenggoku ngu, ariya, ye Anut Oo Bidodo Sembuli Sembunaye, enengo oni simoo bale soboyelooteku endega, ngu newendemo ma uwanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ariya, Yesus mande gula ewolo. Moseslo mamana mande kulimi ngu, ye gome ingootenggo. Ngu ngandilo ewolo. Ye oni ma uleyi kumoowelo. Ene ge oni uleyi kumoowaku ngu, asa, ge mande wilikoyingo onino oolelo, nguno gumi ulungga yowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ene nondo mande gula nguya yeno eteno. Oni gula dobooyi gulaya newende biyomi ingooteku, ngulo ene mande wilikoyingo onino ooletoni, ngulo gumi inowa. Ngundilo nangge, oni gula ene oni doongeyemo, oni dobooyi kootuyisina mande elo, oyumo inowaku ngu, asa, ene nguya mande wilikoyingo oni tabango ulungga nguno ooletoni, ngulo gumi ulungga inowa. Ene oni gula dobooyiboya sanggili oolengo telo ewa, ge mboolombo goyoyingo, ingondudu gula metemi kini! Ene ngundilo ewaku ngu, asa, ngu oningga ngu Anutndo suleyootoni, Setanlo ende de nombo sugi sugi delolooteku, nguno oololo, sugi oluwa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Ge Anutno yambo mande tewelo ingolo, ngulo ge eneno kingo oo duwoo yewelo uya ngu, doboogebo geya biyomi ingooteku ingolo ngu, asa, koletelo ge eneno oolouya, biyomingga ngu andangeya, yomosiyoyago, kootusina ge ko uya, Anutno oo duwoo ye. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Dobooge gula geya newendemo kowuli ingolo, goyolo, mande wilikoweloyi musiyomo oolouwelo oolekono ooloutoningga ngu, sodedonangge ngu mande kowulingga ngu yoonenengoli. Ge ngu mande kowuli koletelo ma yomosiyowaku ngu, ariya, ngu oningga, ngundo goyolo, oo wilikoyingo onino ooloutoyi, ngundo goyolo, kumba ootuwoo oni kandeyemo goyetoyi, ngundo ya biyomimo goyewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","No yeno hamoo eteno. Ge ya biyomimo oode, ngunonggo gengo weti ngu bidodo ma andangelo ngu, asa, ge ya biyomi ngu ma yokowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Asa, ene mande gula ewolo. Moseslo mamana mande kulimi nakangoyingongga ngu, ye kuli ingootenggo. Ene ngundilo ewolo. Ye oni gulalo baleyi yakakayi yodowoolo, ma yombuliyowelolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ene no mande gula yunooteno. Simoo gulado newendemonggo balega kenomayingolo, ngulo ingooteku, ngu ngandilo, ene balega nguya kuli welewoli. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ngundilo ngulo, doongengge koondosina, ngundo goyeni, mbumbuwa tetoningga ngu, andangeya yoko. Ngundilo nangge, moondege gumi, ngundo goyeni mbumbuwa tetoningga ngu, andangeya yoko. Ngundilo tewaku ngu, asa, moondege bidodo yolo, Setanlo ende de nombo ma kumooweloyi, nguno ma uwa. Ngundilo ngulo, ge oo biyomi teteku, ngu sodedonangge yomosiyolo ngu, ngu gome metemi oluwa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Mande yamonggawo gula ngundilo. Kandege koondosina, ngundo goyeni, mbumbuwa tetoningga ngu, toongooya oolongoo. Ngundilo tewaku ngu, asa, moondege bidodo yolo, Setanlo ende de nombo ma kumooweloyi nguno ma uwa. Ngundilo ngulo, ge oo biyomi teteku, ngu sodedonangge yomosiyolo ngu, ngu gome metemilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Yesusndo mande gula ewolo. Moseslo mamana mandeno kuli ngandilo nakangowolo. Oni gula baleyi yokowelo ngu, ene komo so uyino mande ngundiya nakangoya, baleyi inonilo nakangowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ene nondo mande gula moole. Oni elambalisa ngu baleyibo oni gulaya ma weleyingo ngu yokolo owewaku ngu, ene baleyi yeni, mbumbuwa tewa. Ngu balegaku kuli kameyi yowoku, ngundo simoo gula kootu yootoni ngu, ariya, Anut doongeyimo, simoo kootungga, ngundo mbumbuwa tewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Asa, Yesusndo mande gula ewolo. Kuli oo so uyi nakango teyingo ngu, ye gome ingootenggo. Ye Anut doongeyimo mande gagiwi, elo gosiyoyingongga, ngu ma toongoowelo, ngu hamoo teyilo nakangowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ene no ngulo mande soweyolo eweloyi moole. Ye melako onino mande gosiyowelo tetoyingga ngu, no ngu mandega Anut oowooyimo gosiyowelo elo, ma ewelo. Ye Sambo oowooyimo mande ma gosiyowelo. Ndawugalo ngulo, Sambo ngu Anutlo yaba bibiteweloyi. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ye mela oowooyimo nguya mande ma gosiyowelo, ndatelo ngulo, ngu Anutndo keyi yeweloyi musiyo. Ye Yerusalem ende oowooyimo nguya mande ma gosiyowelo, ndatelo ngulo, ngu Anutlo ende ulungga. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ye tabaye oowooyimo nguya mande ma gosiyolo ewelo. Ndatelo ngulo, ye tabaye uye namboyi ngu yeyi, iliyo yeweloyi nguya kini. Ngundilo nangge, tabaye uye iliyo ngu yeyi, namboyi yeweloyi nguya kini. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ye mande gula elo, yo, etenggoku ngu, hamoo ewanggo. Ye, kini, etenggoku ngu nguya, hamoo ewanggo. Ye mande, yo, kini, etenggoku, nguno mande soweyolo ewanggoku ngu, Setando yeni tunootetelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Asa, Yesusndo mande gula ewolo. Ye Moseslo mamana mandeno, ye kuli ingootenggo. Ene ngundilo ewolo. Oni gulado doongeye yombuliyootoyiga ngu, yebana ngundiya ene doongeyi gumi teyino. Oni gulado metoyi udoyiga ngu, yebana ngundiya ene metoyi gumi teyinolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ene no yeno eteno. Onindo yeno oo biyomi yunootoyi ngu, yebana ko gumi ma yunowelo. Oni gulado gagiye koondosina udoyi ngu, ye yowoolengootoyiga, ko biyomisina nguya yuleyi. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ngundilo nangge, oni gulado goyolo, mande wilikoweloyi musiyomo oololo, yengo nenggulo yootoyiga ngu, asa, mete ye dokikilo nenggulo nguya yunoyi. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Oni gulado yeya oole bodaga oolouwelo oolouya ngu, yendo ngu songgula oole pelungga nguya oolouyi. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Oni gulado oo gulalo sumoo yunootoyiga ngu, ariya, inoyi. Ngundilo nangge, oni gulado yeno weti telo, yowelo oo etoningga ngu, mete ye inoyilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Asa, Yesusndo mande gula ewolo. Ye Moseslo mamana mandeno kuli ingootenggo. Ene ngundilo ewolo. Ye dobooguliye konebaye ngulo gome ingoya, yengo me oni nguya sanggili teyilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ene nondo mande gula soweyolo yunowelo. Yengo me oni ngu nowoondoye yunoya, enendo damoni biyomi yeno telo, kootu yunootenggoku ngu, yendo ngulo Anutno kila yunootoyi, enendo damoni biyomi tetenggoku, ngu hoolooweyelootoni, ngu yokowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Yo, yendo yengo me onino damoni metemi telo, nguno simoo bale etuyelolo ngu, hamoo oolengo, ye Awaye sambo endemo oolooteku, ngulo simoongo. Yo, Anutndo oni biyomi, ko, oni metemi nguya sa yeni eneno tunootewa. Ngundilo nangge, sono nguya oni damoniye biyomi, ko, oni damoniye nenengomo nguya Anutndo sono yeni, eneno ombuwa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Onindo yengo gome ingootoyi, ko yendo nguya enengo gome ingootenggoku, ngulo kowuli kini. Weti mbumbuwa tetenggoku oni, ko, Takis yoweloyi oni nguya ngundilo tewonggori. Ene yendo yengo me oni nowoondoyi yunowanggoku ngu, asa, Anutndo ngulo oni oni tewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ye konebaye nguya kambayelootenggoku ngu, ko, oni sowe gidalega, ngundo nguya ngundilo tetenggo. Yengo damoningga ngundo enengo damoniye ngu ma dagawa. Kini, damoniye gulanangge. ");
INSERT INTO rwo_karo_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Hamoo, Awaye Sambo endemo oolooteku, ngundo oni nenengo, ko, oni biyomimo nguno damoni gome nenengo ngu nangge yunoote. Ngundilo nangge, ye nguya ngundiya teyi. ");
INSERT INTO rwo_karo_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ye ingondale teyi! Ye owoolongo oni nguno oo gomengga yunowelo ngu, oni doongeyemo ma yunowelo. Ndatelo ngulo, onindo ngu yendo oo tewonggoku, ngu tunoo kenolo, ngulo ye oowooye bingamilo okoowanggo. Ene ngundilo tetoyi ngu, asa, kootusina, Awaye Sambo endemo oolooteku, ngundo ngulo uli gula ma yunowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ye owoolongo oni oo gomengga yunowelo ngu, asa, ye ngulo oni doongeyemo manggalu yanggango ma tewelo. Ndatelo ngulo, oni Anutlo nowoondoyemo hamoo ma teyingo, ngundo yambo yano ko oolekono nguya oo ngundilo telo, enengo oowooyi bingami okooweloyimbolo. No hamoo oolengo, yeno eteno. Ngu oni ngu, enengo uli kuli yowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ngundilo nangge, ye owoolongo oni hoolooweyelowelo ngu, aliya, kandeye biyomisinangga ngundo kandeye meteminggado oo tewaku ngu ma ingowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ngundilo ngulo, oo gome yunowelo damoningga ngu kombiteyingo tewonggokungga ngu, kootusina, Awayembo uli gumi tunoo yunowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ye kila tewelo ngu, oni mebuye sangala, ngundo kila tetenggoku, ngundilo ma tewelo. Ene newende bidodo enengo oowooyi okoowelo, oni doongeyemo yambo yano, oolekono nguya, kila tewelo gome ingootenggo. No yeno hamoo eteno. Ngundilo oni ngu kuli uli yowonggo. Ye ngundilo ma tewelo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ye kila tewelo ngu, yengo ya gumi nguno oolouya, ya goodooya, yesu nangge Awayemo kila teyi. Ye ngundilo tetoyi ngu, asa, Awayembo ngu oo kombiteyingongga tetenggoku, ngu kenolo, gumi yunowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ye kila tewelo ngu, kingo mande mande ma eloluwelo, kapengo onindo tetenggoku, ngundilo ma tewelo. Kapengo oni, ngundo Anutndo ingoni elo, ene mande mande ngundilo oowooyingga tetenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ye ngundilo oni ngulo damoni ma keyowelo. Ndatelo ngulo, nowoondoyemo oo gulalo kowuli ingolo, nguno ma kila teyingomo ngu, Anutndo ngu oo ngu bidodo kuli kenolo ingomukoote. ");
INSERT INTO rwo_karo_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Nondo ngu yemboongeweloyi damoni gome ngu etuyelowelo, ye mete ngandiya kila teyi. Noolengo Awanayi, ge Sambo endemo oolooteku, gengo oowoongge ngu kundingiyi oolengo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Oo Bidodo Sembuli Sembunaye, gengombo nalungga gengo oni simoo bale soboyelooteku, ngu mete ombuni. Sambono Onindo ge oo ingooteku, ngu nenengo kenggelolo oolootenggoku, ngundilo nangge, noole hoolooweyelootooga, ngano ngundilo keyolo oluwato. ");
INSERT INTO rwo_karo_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ge noolengo oowali atagambolo logoyimo yuno. ");
INSERT INTO rwo_karo_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Noolendo oni gidalegalo kowuli andangelo, kapengo yetooyega ngu, gedo nguya ngundiya noolengo mbumbuwa andangeya kapengo yeyunowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Gedo Setan ma yokootoyi, ombulo, ngundo noole tewooyelolo, ngunonggo yoyolo, mbumbuwano yoyewelo. Oo Bidodo Sembuli Sembunaye, gengombo nalu oni simoo bale soboyelooteku ngu, yanggangongge, bingamingge nguya, gengomu nangge sugi sugi oluwa. Ngu hamoolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ye gome ingoyi! Ye oni gidalegado kowuli yeno tetoyi, ngu andangelo kapengo yetoyi ngu, asa, Anutndo nguya yengo kowuli andangelo kapengo yeyunowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ngundilo nangge, ye oni gidalegado kowuli yeno tetoyi, ma andangelo kapengo yetoyi ngu, asa, ngu Anutndo nguya yengo kowuli ngu ma andangelo kapengo yeyunowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Asa, Yesusndo mande gula ewolo. Oo neweloyi nalunggano nguno, ene oowali loogu telo, ene Anutno kila tewanggo. Ye oowali loogu tewelo ngu, omukumundooge ma goweyewelo, oni mebuye sangala ngundo tetenggoku, ye ngundilo ma tewelo. Ngundilo oni ngu, oni simoo bale doongeyemo ngundilo tetenggoku ngu etuyelolo, ene oowali loogu tetenggo. Ariya, ngundilo oni, ene kuli uli yowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ye oowali loogu tewelo ngu, mete ye omukumundooye sonowooya, uye pitoya yoonenengoya oliyi. ");
INSERT INTO rwo_karo_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ngundilo tetoyiga ngu, oni gulado ye oowali loogu tetenggoku, ngu ma ingowanggo. Ene Sambono Awayembo, enesu nangge oo ngundilo ngu ingowa. Awayembo ye oo kombiteyingo tetenggoku, ngu kenolo, oowooyi bingami okoowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ye nowoondoye bidodo oo sitowi gome gomemu, ngu melako ngano goobooyingoweloyimbolo ma ingowelo. Nga melako ngano sago, siwi, kookoose, yakaka oni, ngundo oo bidodo yombuliyootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Anut doongeyimo, ye enengo mande onino wesiyolo elo, oni yomosiyelolo, onilo kowuli koolowoolo, oo ngundilo ko tetenggoku ngu, Sambono bobeye ngundilo goobooyingoya, nguno yeyi. Sambo endemo ngu sago, siwi, kookoose, ngundo ma yombuliyootoyi, yakaka onindo nguya ya toongoolo, oo yoweloyi nguya kini. ");
INSERT INTO rwo_karo_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Yengo oo sitowi gome gomemu oolooteku, nguno yengo ingonduduye nowoondoye nguya nguno oolootelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","23","Asa, Yesusndo mande gula ewolo. Doongeye ngu goweye solu himi, suwoono endeyoweloyi ngundilo. Ngundilo nangge, nowoondoyebo damoni metemi Anutnonggo ombuteku ngu telo, hahangetenggoku ngu, ngu suwoonombolo solu himi gome oolengo ngundilo. Ngulo ngu, yengo ingondudu nangge keyowelo ingootoyi ngu, yengo solu himi ngu yanggango ma ootoolo, namoko kumootoni, ngulo ye ooleli oolengomo oluwanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Asa, Yesusndo mande gula ewolo. Oni gulananggebo sobosobo oni elayagomo ko teweloyi nguya ereremo kini. Ene sobosobo gula ngulo gome ingolo, sobosobo gulalo gome ma ingowa. Ene sobosobo gula gome keyolo, gula kootu inowa. Ene ngundilo nangge, ye Anut keyolo, ko, bobeye yowelo hahangeweloyi damoni elayaga ngu teweloyi, bine? Kini, Anut keyolo, ko, digi beye yowelo hahangeweloyi damoni elayaga ngu keyoweloyi, ngu ereremo kinilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ariya, no yeno hamoo eteno. Ye yengo yanggangoye, oo neweloyi, sono neweloyi, ko, towikumba teweloyim ngulo nowoondoye kowuli yelo, ingondudu oowooyingga ma ingololuwelo. Anut doongeyimo, yengo keda oluweloyiga, ngu nowoondoye hamoo teyingongga, ngulo oo bidodo dagamukoote. Yo, yengo keda oluweloyiga, ngundo oo neweloyi, sono neweloyi, ko, towikumba yoweloyi, ngu bidodo dagate. ");
INSERT INTO rwo_karo_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ye nu ngu kenolo ingootenggo. Ene numbo ngu oowali ngu imilo, yolo, yano oowali ma watayelo yetenggo. Ene Awaye Sambono oolooteku, ngundo soboyelolo, oo yunoote. Ngundilo nangge, Anutndo noolengo gome ulungga ingoote. Yo, hamoo, ene noolengo gome ingooteku damoningga, ngundo nulo ingooteku damoningga, ngu dagate. ");
INSERT INTO rwo_karo_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Anutndo noolengo keda oluweloyi nalu sunggi yeyunowolo. Noole keda oluweloyi nalungga Anutndo sunggi yewoku, ngu noole mete ma dagawato. ");
INSERT INTO rwo_karo_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ilosala gome deguno ooleteku ngu, ene kingo oolelo, nungo yewelo ko biyomi ma tewa. Kini, ene Anut enengombo nungo inootoni, nungo yelo, gome tete. Ngundilo nangge, Anutndo ye nguya hoolooweyelootoni, ye towikumba yowanggoku, ngulo ye nowoondoye kowuli ulungga ma yewelo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Kuli mela ngalo oni sobosobo koleteyingo ulungga oowooyi Solomon, enengo so uyi nakango gome gomemu telo, enengo dulidalini ulungga oolengo telo oluwolo. Ene Anutndo so uyi nakango melako yewoku, ngu ooga ngu Solomonlo nakayani, ngu bidodo dagate. ");
INSERT INTO rwo_karo_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Yo, Anutndo so uyi nakango melako nungo gome gome tetoni, ataga gome oode, yangeni ngu buwoo yelo, makoolo solewa. Ariya, ene ye nguya hoolooweyelolo, noolengo towikumba ngu logono yunowa. Ye simoo bale nowoondoye hamoo teyingongga, ngu bodaga nangge. Ndatelo ngulo, Anutndo mete ye nguya gome soboyelowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ngundilo ngulo, ye nowoondoye kowuli yelo, ingondudu oowooyingga ma yowelo ewolo. Noole oo ndawuga newato? Noole ndawu sonongga newato? Noolengo towikumba oo ndawuga tewato? Elo ewolo. Ye ngundilo ingondudu ulungga ma tewelo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kapengo oni ngundo oo ngundilo yoweloyimbolo ingolo hahangetenggo. Ene yengo Awaye Sambono oolooteku, ngundo ene kuli gome ingowolo. Ye komo sono, oowali, towikumba nguya yengo logono nenengo ngundilo yowanggo. Anutndo ngundilo ingoote. ");
INSERT INTO rwo_karo_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ene ye koletelo oolengo, Anut Oo Bidodo Sembuli Sembunaye, ngundo damoni enengo simoo bale soboyelooteku, nguno ulo, enengo damoni nenengo ene yendo teyi, elo ingooteku, ngundilo keyootoyi ngu, ariya, Anutndo mete oo gidalega ye logono ngundilo hoolooweyelowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ngundilo ngulo, ye nowoondoye kowuli yelo, ingondudu oowooyingga yangenim, ngulo ma ingowelo. Yangeni nalungga ngu, enesu nangge kowuli koolowoowa. Nalu gulado kowulingga ngu, ene ngu nalungga ngulomu nangge. Ene ngundilolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yesusndo mande gula ewolo. Ye oni goweyemo enengo damoni ngu ma wilikowelo. Ye ngundilo tetoyi ngu, asa, Anutndo ye nguya wilikoyelowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ngundilo nangge, ye dobooguliye damoniye wilikootoyi ngu, Anutndo damoni ngundilo yeno nguya tewa. Yengo mamana mandelo logoga dobooguliyemo tetenggoku, ngu Anutndo yeno nguya ngundilo nangge gumi yunowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Yo, no mande yamonggawo gula yeno ngandilo eteno. Ge ndawugalo dobooge doongeyimo oo kakawu bodaga oo kenootoni oolooteku, ngu ge doongengge nenengo de bingo ulungga oolooteku, nguno ge ma kenolo ingoote? ");
INSERT INTO rwo_karo_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ndawugalo ge doboogemo ngandilo ete? Doboone, nondo doongenggemo oo kakawu bodaga oolooteku, ngu yewe toongewa. Ge ngundilo eteku, ene nalu bidodomo, de sosi ulungga doongenggemo nguno ooloote. ");
INSERT INTO rwo_karo_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ge mebuge sangala oni! Ge koleteya de sosi ulungga doongenggemo oolooteku, ngu andangeya yoko. Ge ngundiya teya ngu, asa, ge mete doboogemo ngu gome kenolo, oo kakawu bodaga ngu andangewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Nga mande yamonggawo gula. Ye oo kundingiyi, ngu se, bo ma yunowelo. Ye oo ngundilo gome gome bo yunowonggoku ngu, asa, sodedonangge ene bodo yombuliyolo, wongooni utoni, ngundo yowoolengolo yokiwa. Ngundilo nangge, oni gula Anutlo Mande Keda Mesalango ngu nalu bidodo ngu ma yootoningga ngu, asa, ye ene yokoyi. Ngundilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Yesusndo ngandilo ewolo. Ye nono oolo sumoo ewanggoku ngu, no yunowano. Ye suwoo suwoo oo erewewelo ngu, ye kenowanggo. Ye yamako tanggeyisina dikalo, yokakasangootoyi ngu, asa, Anutndo yamako goosooyunowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ye Anutno yemboongelo, oolo sumoo ewanggoku ngu, Anutndo oo yunowa. Ngundilo nangge, oni simoo bale oo yowelo ngu erewelo, ene kenowanggo. Ye yamako tanggeyisina dikalo, yokakasangootoyi ngu, asa, Anutndo yamako ngu goosooyunowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ngundilo nangge, oni gula nangonimbo oomanongoyingombolo etoni ngu, eweyimbo digiga inowa bine? Kini. ");
INSERT INTO rwo_karo_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ngundi oni gula nangonimbo isolo etoni ngu, eweyimbo sile biyomi yolo, inowa, bine? Hamoo oolengo kini. ");
INSERT INTO rwo_karo_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ariya, melako ngano awa awaye sungo sungo, ngundo oo kingo duwoo gome ngu nangosumooye yunootenggoku, nguno ngu, ye hamoo ingowanggo. Awaye Sambono oolooteku, ngundo nangosumooyemo sumoo elo etoyi ngu, hamoo oolengo, ngu oo gome gomemu yunowelo ingowalo ingowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ariya, damoni gome oolengo yendo oni simoo baledo yeno teyi, elo ingootenggoku, asa, ye ngu damoningga ngundiya nangge eneno teyi. Yo, ye ngu damoni nenengo keyootenggoku ngu, asa, ngundo Moseslo mamana mandega Anutlo ingondudu eyingo oni oo ngundilo etuyelowonggoku, ngu logono telo, engge tunootewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ariya, ye Anutlo mamana mande ngu keyolo ngu, ye Anutlo oni bidodo oole bodaga tembaniwoolemu nguno oolelo, Anutlo Sambo endemo oolewanggo. Ene Setanlo oole ngu ulungga mela nenengo gome nangge. Yo, oni simoo bale oowooyingga oolengo, ngu oole ulungga ngu keyolo, oololo oonatewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ene Sambo Endemo oole, ngundo oole tembaniwoolega ngu bodaga nangge. Yo, keda sugi sugi oluweloyi oole tembaniwoolega ngu bodagamu, ngulo ye ko biyomi telogo, erewelo nguno oolewanggo. Oni simoo bale nowoondoyemo hamoo teyingongga, ngundo nangge kenolo, Anutno oolewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ye Setanlo ingondudu eyingo oni ebe ganagana ngulo ingondale teyi! Ngu oni ngundo ye kewooloyemo, oolengo oololo dikalo, tolige mande yeno ewanggo. Ene imakeyingo damoni telo, tolige yeno ombulo ooloutoyi, bo gula oowooyi Sipsip enengo damoni ngundilo tewolo. Ene useye newendemo nguno ngu, ngu se goki biyomi ngundilo. Ngundo ngu ombulo, sodedonangge yokiwanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ye koletelo enengo damoniyengga ngu wilikolo kenootoyi, ngu ene nenengo bine, ngundi biyomi bine ewanggo. Nga oni nga enengo ootootooye, ngu gome tetoyi, kenolo ngu, asa, ye nguno ingolo, enengo damoniye ngu nenengolo ingowanggo. Yo, Damoni dega, ngundo ngu yowoolengolo, koonda ma tewa. Ngundilo nangge, dimoo uto, kakali sanggili, ngundo yowoolengolo, mbako ma tewa. Hamoo oolengo kini. ");
INSERT INTO rwo_karo_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Yo, de bidodo gome yanggango telo ngu, ene tanggooli gome nenengo nangge enggewanggo. Ngundilo nangge, de biyomi, ngundo ene engge gome metemi ma enggewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","De metemi, ngundo engge biyomi ma enggewa. Ngundilo nangge, de biyomingga, ngundo ene engge gome metemi ma enggewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","De bidodo gome ma enggetoyi, asa, ene de ngu doongoolo, deko yokawanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ngundilo nangge, ye ngundilo oni ngu enengo damoni biyomi tetenggoku, ngu kenolo, ye nenengo tunoo ingootenggo. Ene ebe ganagana eyingo oni nanggelo ingowolo. Ngu oni nguno, ene Anutlo damoni ma keyoyingo, hamoo oolengo kinilo ingowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ngulo ngu, oni guminggado ngu noolengo Anut Oo Bidodo Sembunaye etenggoku, ngu gumi nenengo kini. Kini, oni ngu enengo bingamiye okoolo, ene Anut oowooyi ngulo ma ingolo tetenggoku ngu, ene Anutlo Sambo endemo enengo oni simoo bale soboyelooteku, nguno ma uwanggo. Ene oni gula Awane Sambo endemo oolooteku, ngu gome keyolo ngu, asa, Awane kenowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","23","Ariya, oode kootusina, Anutndo nalu wenganggakuno wilikoyeloweloyi naluno, oni oowooyingga oolengo mayelo ewanggo. Oo Sembuli Sembunaye Ulungga, noole gengo oowoonggemo, noolendo gengo mandege keda mesalango ngu wesiyolo, mela yuka biyomi andangelo, damoni sungo oolengo gula onindo ma teweloyim nguya tewololo ewanggoku, ene ngu nalunggano nguno, nondo mande ngandilo gumi ewano. Yendo ngu yengo oowooye bingamiye nangge okoolo, nolo nowoondoye hamoo ma teyingo, ngulo ngu, no yeno mande yanggango eteno. Nondo ngu ye watayi kini. Ye mbumbuwa oni biyomi! Ye sodedo sayi! No ngundilo ewanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ariya, Yesusndo mande yamonggawo gula ewolo. Oni gula nolo mandene gome keyolo, ingolo ngu, ene ingondudu metemi yoote. Ngundilo oningga ngu, ngu ngandilo. Ene ingondudu metemi yolo, ngulo ene ya yanggango ngundilo mela yanggangonggakuno de nonggini gagiwi yolo, yeteku ngu. ");
INSERT INTO rwo_karo_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ngundilo telo, sono ulungga ombulo, sono tuwi ulungga ootookoolo, doogo ulungga ombutoni ngu, enengo yangga ngu yanggango ootoolo, ma dookelo solewa. Ndawugalo ngulo, ene mela yanggangonggano de nonggini gagiwi nguno yewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","27","Ngundilo nangge, oni gula nolo mandene ingolo ma keyolo, ene oni ingonduduni kini ngundilo. Ene ya yeweloyi ngu ingondudu kini. Ngulo ene ya osiyi ngu mele setoni, mela newendemo amuno ma uwolo. Kini, ene ya ngu mela sanganimo nangge yewolo. Ngundilo ngulo, sono doogo ulungga ombulo, sono mewuyi ulungga tetoni, ngu enengo yangga ngu yanggango kini, ngulo sodedonangge dookelo solewa. Yo, hamoo oolengo, ngu dookelo, solelo yombuliyomukowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Yesuslo mande ngu kinitetoni, oni simoo bale oowooyingga oolengo enengo mandeni etuyelowoku, ngu ingolo, ene soliyokolo hamoo ingowonggo. Ndatelo ngulo, Yesusndo mandeningga ngu wesiyolo eteku, ngu mamana mande etuyeloyingo onindo etenggoku, ngundilo ma wesiyolo ewolo. Kini, Yesusndo mande oni simoo bale yunowoku, ngu yanggango oolengo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesusndo pulingga ngu yokolo, ene ameno ombutoni, oni simoo bale oowooyingga oolengo ene keyolo oolouwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ngu nalunggano nguno, oni gula mambugolidodoga, ngundo Yesus tanggeyimo ombulo, penggootelo ewonggori. Noolengo Oo Bidodo Sembuli Sembunaye, no ingooteno. Ge mete nolo ingoya, noyega, mete tewelo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ngundilo etoni, asa, Yesus ngu oni mambugolidodogaku ngu kenolo, nowoondoyi telo, kandeyi eneno yelo, ewonggori. No ngundilo tewelo gome ingooteno. Ge mete te. Ene ngundilo etoni, ariya, sodedonangge ngu oni mambugolidodogaku, enengo sayininggaku mete tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Asa, Yesusndo mande gula ewolo. Ge no manggone gome ingo! Ge oololo ngu, oni gulano gengo sayi yomosiyooteku, ngulo ma ewelo. Kini, ge sodedo oolouya, gengo gowege moondege Anutlo woolo yeyingo oni kundingiyi ngu etuyelo. Ene ge geyolo ingolo, gowege moondege sayi mete telo, elo ingolo ngu, kuli Mosesndo ewoku, ngundiya teyi. Ngundiya tetooga, oni simoo baledo geyolo, ataga gengo sayingge ngu mete tetelo ingowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesus Kaperniyam endegano nguno utoni ngu, ngu naluno nguno, me onilo tabango ululu gula ngulo me oni ngu onibi kandegula (100), ngundilomu ngu soboyelooteku ngu, ngundo Yesusno ombulo, ngandilo sumoo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Nolo Oo Bidodo Sembuli Sembune, nolo sulena oni gula sayi ulungga telo, yano ooloote. Ngu ene kekandeyi ngu kuli kumooyingo, ngu ene ogingoyingo ulungga yolo oolootelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesusndo enengo mande ngu ingolo, enebana gumi ewolo. Nondo oololo, ene yewe, mete tewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ene ngundilo etoni, asa, me oni tabango ulungga Yesusno mande gumi ewolo. Oo Bidodo Sembuli, no oni metemi kini. Ngundilo ngulo, ge nolo yano ma ombuwa. Ge mande kingo nangge etooga ngu, nolo sulena oningga ngu, ene mete tewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nondo noso nangge nolo oni sobosobo ulungga moole. Ene oo etoni ngu, nondo oo ngundilo teteno. Ngundilo nangge, nolo me oni nowoondonemo oolootenggo. Ariya, nondo gulaya, oolou, ewanoku ngu, ene oolouwa. Nondo gulaya, ombu, elo ewanoku ngu, asa, ngu ombuwa. Nondo nenengo sulena oni gulaya ko ngundiya te, ewanoku ngu, ene oo ngundilo tewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesusndo enengo mandega ngu ingolo ngu, soliyokolo, yowoolengolo, oni enedodo namoko nguno etuyelolo ewolo. No yeno hamoo oolengo eteno. No ngu Iserel oni gula newende hamoo teyingongga, ngundilo no ma kenowonolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","No yeno hamoo eteno. Anut Oo Bidodo Sembuli Sembunaye, ngundo endega enengo oni simoo bale soboyelooteku, nguno oni simoo bale oowooyingga ngu sowe oowooyingga Yudalo oni kini, me oni tabango ulungga ngundilo. Yo, ngundo Sambo endemo nguya ombulo, oo simbo ulungga naluno, Ebaraham, Ayisak, Yekob, ngudodo bibitelo, oo nelo oluwanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ene Anutndo endega enengo Iserel oni simoo bale soboyelooteku, ngulo yomosiyowolo. Yomosiyootoni, ene enengo Iserel oni simoo bale oowooyingga nowoondoyemo hamoo ma telo, ngulo ene Sambo endemo ma oolouwanggo. Anutndo ngu oni ngu oweyelootoni, Setanlo ende biyomi de nombo ma kumooweloyi nguno oolongoowa. Oolongootoni, nguno ene uleli ulunggano sendo mogulu ulungga telo, metokalikali telo oluwanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ngundilo elo ngu, asa, Yesusndo yowoolengolo, me oni tabango ulunggakuya elo, gengo yano u! Gengo nowoondoge hamoo teyingongga, nondo gengo ko oni yomosiyoowe elo ingowokunggaku, ngu ataga engge tunootetelo etoni, nalu ngundilo nangge, Yesusndo etoni ngu, enengo ko oninggaku sodedonangge mete tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ariya, Yesusndo ombulo, Pitalo yano ulo, konggeyi kenowolo. Ene sayi goweyi gookingo ulungga yetoni, yabano wetololuwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ngundilo ngulo, Yesusndo Pita konggeyi kandeyi dowootoni ngu, nguno nangge, sayininggaku kinitetoni, ngulo ene ootookoolo, Yesuslo oo kalo yomosiyowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ariya, suwootetoni, oni simoo bale oowooyingga yuka biyomimbo yoyoyingomu, ngu yoyolo, Yesusno mayewonggori. Mayetoyi, asa, Yesusndo yuka biyomiku oni nowoondoyemo oolootenggoku, nguno elo oweyelootoni, peselo toongewolo. Ngundilo telo, sayi oniku nguya yomosiyelootoni, ko mete tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Kuli Anutlo ingondudu eyingo oni oowooyi Ayisaya, ngundo Yesuslo mande ngandilo nakangolo ewolo. Enendo enesu nangge sayinayi bidodo andangelo yokolo, ene noolengo sayi oowooyingga kuli koolowoolo oolouwololo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ngu naluno nguno, oni simoo bale oowooyingga oolengo mayelo, Yesus pawangootoyi, ngulo enendo sulena onino ewonggori. Noole sono koongeyingo anduloko oolewatolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ngu naluno, Anutlo mamana mandelo etuyeloyingo oni, ngundo Yesusno ombulo ewolo. Oo etuyeloyingo oni, ge ende bidodo oolouwaku ngu, no nguya geya oolouwelo ingootenolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ngundilo etoni, asa, Yesusndo mande gumi ewolo. Deguno se goki oolootenggoku ngu, ene kengeweloyi musiyo moole. Ngundilo nangge, nu nguya tagiyedodo moole. Ene no, Anut Nangoni Oni Kilalongo, ngu weleweloyi musiyo hamoo oolengo kinilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ngu naluno nguno, oni newende hamoo teyingo gulado Yesus keyolo ewolo. Oo Sembuli Ulungga, mete bine, no koletelo oololo, Awane sobowootoowe, kumootoni melengoologo ko ombuwanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ene ngundilo sumoo etoni, asa, Yesusndo gumi ewolo. Oni nolo nowoondoyemo hamoo ma teyingo, ngundo mete oni bingo melengooyi. Ene komo ge no keneloya ombulo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ngu naluno nguno, Yesus enengo sulena oni nguya wanggo newendemo uwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ariya, ngu naluno nangge, doogo ulungga oolengo tunootelo, wendeyi dookelo, wanggo yowoolalingootoni, wanggo wendoni uwelo tewolo. Ngundilo tetoni, ene Yesus wanggo newendemo wetololuwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ngundilo tetoni, enengo sulena oni sosoleyingo ulungga oolengo telo, Yesus yokutuwoolo ewonggori. Oo Sembuli Ulungga, ge komo noole hoolooweyelo! Noole ataga oonatewelo tetetoku ngalo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ene ngundilo etoyi, asa, Yesusndo eneno mande gumi ewonggori. Ye ndawugalo sosoletenggo? Yengo nowoondoyemo hamoo teyingo ngu bodaga nangge! Ewonggori. Ngundilo elo, ene ootookoolo, doogo sono nguya yeyolo etoni, sodedonangge imakewolo. Yo, ene ngundilo etoni, doogo imaketoni, wendeyi nguya nenengo yewoli. ");
INSERT INTO rwo_karo_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ngundilo tetoni, enengo sulena oni ngu kenolo, ingondudu ulungga oolengo telo, sosolelo, enengo nangge mande elo sumoo ewolo. Nga oningga nga ndatelo oningga, ngulo wendeyi, doogo yeyolo etoni, ngundo manggowo ingolo, ngulo ene sodedonangge imakewolo? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ngu naluno, ene sono anduloko oni simoo bale mela nguno oolootenggoku, ngu oowooyi Gadalin nguno ombutoyi ngu, oni elaya yuka biyomidodo ngu nguya goobooyingowoli. Ene oni melengooweloyi musiyo yokolo, Yesusno ombuwolo. Mboolo biyomimbo yoyoyingo oni elayaga ngu, se goki ngundilo. Ngundilo ngulo, oni simoo bale ngu oni elayagado musiyo oole ma endeyootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ngu naluno nguno, yuka biyomikundo Yesus kenolo, meno yanggango elo ewolo. Ge Anut Nangoni, ge nooleno ngano ndawuga tewelo ombute? Ge noole ogingoyingo ulungga yunowelo ombute, bine? Ataga nalungga, noole Setanlo ko oni yoyolo, Setando musiyo biyomimo yoyeweloyi nalu kinilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ngu naluno, bo oowooyingga oolengo sono koongeyingo namoko oo nelo oluwonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Bo oo netoyi, yuka biyomi oni elayagaku nowoondoyalimo oluwonggoku, ngundo bo kenolo, ngulo ene Yesusno solengoyelo, sumoo sumoo ewolo. Noole oweyelootoyi, oolelo, mete noole bo andu nowoondoyemo uwato, bine? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ene ngundilo sumoo etoyi, asa, Yesusndo ngu ingolo, mande gumi ewolo. Yo, mete ngundiya teyi! Ene ngundilo etoni, ariya, yuka biyomiku oni elayagaku yoyokolo, boku nowoondoyemo utoyi ngu, ariya, sodedonangge boku kendutelo oololo, mela tembanimo solelo, sono koongeyingomo ulo, nguno kumoomukowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ngundilo tetoni, bo sobosobo oniku ngu kenolo, sodedonangge ene kendutelo, endemo ko oololo, bo bidodo kumoowonggoku ngulo elo, ko, oni elayaga yuka biyomimbo yoyoyingo ngu mete tewoliku, ngulo nguya elo endeyowoli. ");
INSERT INTO rwo_karo_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ngundilo etoyi, ngu endemo simoo baleku bidodo sanggili telo, Yesusno mayewonggori. Ene Yesus kenolo ngu, nguno solengoyelo, sumoo sumoo inolo, nga melangga nga yokoya, gulasina toongelo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ngu naluno nguno, Yesusndo wanggo newendemo ulo, sono koongeyingo anduloko oololo, enengo ende damonimo ko mayewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Mayetoni, oni kekandeyi kuli kumooyingongga yabano yelo, oni gidalegado sumoolo, Yesusno mayewolo. Ariya, Yesusndo ngu oni ngulo nowoondoye kenolo ingowolomu ngu, ene enengo nowoondoyemo hamoo teyingo kenolo, ngulo ene ngu sayi oninggakuya ewolo. Nangone, nowoondoge imakeyingomo ootoo. Nondo gengo mbumbuwage andangelo yokolo kapengo yetenolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ngundilo etoni, Moseslo mamana mandeno etuyeloyingo onindo ngu ingolo, enengo nangge mande elo, ingolo ewolo. Nga oningga ngando, Anut kootuyisina elo yumooyinolo mande biyomi etelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Asa, Yesusndo enengo nowoondoye bidodo kenolo ingolo, ngandilo sumoo ewolo. Ye ndawugalo yengo nowoondoyemo ngundilo biyomi ingootenggo? ");
INSERT INTO rwo_karo_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Oole elaya ngu sayi oningga nguya eweloyi ooloote. Ndawu oolega ngu dagate? Nondo enedodo ewano, gengo mbumbuwa andangelo yokolo kapengo yewano; ngundi, ge ootookooya ooloulo ewano, bine? Ndawu oolega ngu gome? Elo sumoo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","No nenengo etuyelolo ewelo. No Anut Nangoni Oni Kilalongo ootoolo, yanggangonedodo no mete melako ngano oni bidodo mbumbuwa andangelo yokolo, kapengo yewanolo ewolo. Ariya, ene ngu oni kekandeyi kuli kumooyingongga nguya ewolo. Ge ootookooya, gengo yaba yoya, gengo yano ulo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ngundilo etoni, ene ootookoolo, enengo yano uwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Oni simoo bale namoko oluwonggoku, Anutndo yanggango oni yunowoku, ngu kenolo ngu, ene soli ulungga yokolo, Anut oowooyi bingamilo okoowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ngu naluno nguno, Yesusndo nguno oololo, Gabman bobeye yoweloyi oni oowooyi Matiyu ngu kenolo ewolo. Ge ombuya, no kenelo, ewolo. Ngundilo etoni ngu, asa, Matiyu ootookoolo, Yesus keyolo oolouwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesusndo sulena oni nguya, Matiyulo yano oololo, oo netoyi ngu, digi yoweloyi oni gula, ko, mbumbuwadodo oni nguya ombulo, ngudodo oo newonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Moseslo mamana mande sobowooyingo oni, oowooyi Parisi, ngundo Yesuslo sulena oniku yeyolo ewolo. Ndawugalo yengo oo Sembuli ngu bobeye yoweloyi oni, ko, mbumbuwadodo oni nguya oo netenggo? Elo sumoo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesusndo ngu mandega ngu ingolo, mande gumi ewolo. Oni sayi kini ngu, sayi mambu yomosiyoweloyi Dokta onino nguno ma oolouwanggo. Kini, oni sayidodo, ngundo nangge Doktano oolouwanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Kuli Anutlo ingondudu ewo onindo nakayanggano nguno Anutlo ewolo. Nondo ngu nowoondoye ebe ino ino teweloyi damoningga, ngulo gome ingooteno. Ngu damoningga, ngundo nono woolo yeweloyi, ngu dagatelo ewolo. Ene mande soweyolo gula ewolo. Ye Anutlo ingondudu ewo oni ngulo mande ngu gome ingoyi, ngulo damoni ndatelo? Ngundilo nangge, no oni nenengombolo nangge ma ombuwono. Kini, no oni mbumbuwadodomu negoyelowelo nguya ombuwonolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ngu naluno nguno, sonoyeloyingo oni Yon oningga ngulo sulena onindo Yesusno ombulo, sumoo ewolo. Ndawugalo ngulo, nolo, ko Parisi oni nguya oowali loogu telo, gengo sulena oni ngundilo ma tetenggo? Elo sumoo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesusndo mande ngu ingolo, ngulo gumi ewolo. Bale yoweloyi naluno, dobooguline, yayane, awa namone mayetoyi ngu, nguno oni oni teweloyi naluno, oowali ma loogu teweloyi. No melako ngano ma oluwanoku nalunggano ngu, asa, nenengo sulena oni oowali loogu tewanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Yesusndo mande yamonggawo elaya yunolo, ngu etuyelolo, damoni keda ko damoni kulimi ngu ma gooboowoowelo. Ngu ngandilo: Oni kumba sosowoo kedaga yolo, ngundo nenggulo kulimingga ngulo wetu ma ukingolo weyomoowanggo. Ene ngundilo tetoyi ngu, ngu kumba sosowoongga, wetu ukingowonggoku, ngundo nenggulo ko oomboongewa. Kedanggakundo kuliminggaku oomboongetoni, nguno wetu ulungga tunootewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ngu ngandilo: oni gulado bo simoongo kedamu yolo, si kulimimo ma siliyoote. Ndatelo ngulo, ngundilo tewaku, bo simoongonggakundo si kuliminggaku oomboongelo, melako solelo, si, bo nguya yombuliyowa. Ngundilo nangge, oni bo simoongo, si kedamo siliyootoyi, ngu bo, si nguya mete oluwalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesusndo mande soweyolo, elo etoni ngu, goobooyingo yalo tabango oni gula ombulo, boodoo oondookelo ewolo. Anangu, no nambone kumoote. Mete, ge ombuya, kandege eneno yeya, yokutuwootooga, ene ko ootookoolo, keda olinilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ene ngundilo etoni, asa, Yesusndo, enengo sulena onidodo ootookoolo, ene keyolo oolouwonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ngu naluno, bale gula kombolo sayi yolo, mooma nalu kande elaya kegidembolo elaya oluwoku, ngundo Yesus kootusina oololo, nengguloni tanggeyisina dowoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Enengo newendemonggo ngu ngandilo ingolo ewolo. No nengguloni tanggeyisina nangge dowoowanoku ngu, asa, nenengo sayine mete kinitewa, ingolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ngundilo tetoni ngu, Yesusndo yowoolengolo, kenolo ewolo. Nambone, mete, ge nowoondoge imakeyingo ootoo. Ge nolo nowoondoge hamoo teyingo ngulo ngundilo nangge, sayingge kinitetelo ewolo. Ngundilo etoni, ngu naluno nangge, enengo sayinggaku kinitewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ariya, Yesusndo tabango oninggakundo yano ombutoni, nguno oni simoo bale oowooyingga oolengo nguno ootoolo, sendo mogulu telo, nggusi uwoolo oluwonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Yesusndo oo ngundilo kenolo ewolo. Anangu, ye sayi! Nga bale buniyongga nga ngu ma kumooyingo, ene wetoloote nanggelo ewolo. Ene ngu mandega ngu ingolo, ngulo ene yumoo inowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ene ngundilo tetoyi, Yesusndo oni simoo bale oweyelootoni ngu, endesina ooletoyi, ya newendemo ulo, bale buniyonggaku kandeyi dowootoni, ko keda telo ootookoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ngu ooga tunootewoku, ngulo mandeni sodedonangge ende bidodomo ngu mela guminggano oolooteku, ngu ingowonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ngu naluno nguno, Yesusndo ngu endega yokolo ooloutoni ngu, oni elaya doongeyali kilingomu ene keyolo, meno yanggango ewoli. Ge Yuda onilo tabango ulungga Dewit ngulo osiyi! Ge noolengo nowoondoyi yuno! Elo ewoli. ");
INSERT INTO rwo_karo_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesusndo ngu ingolo, ene nowoondoyali kenowelo yano utoni, ngu oni doongeyali kilingo elayagaku nguya uwoli. Yano utoyi ngu, asa, Yesusndo elayagaku yeyolo, tewooyelolo, sumoo ewolo. Yali nowoondoyalimo ngu nondo yomosiyeloni ingooteli, bine? Ene ngundilo etoni, doongeyali kilingo elayagakundo mande gumi ewoliyo. Oo Sembuli Ulungga, ge mete noole yomosiyololo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ene mande ngundilo etoli ngu, asa, Yesusndo kandeyi doongeyalimo yelo ewolo. Ariya, yali nowoondoyali nono hamoo tetoli ngulo, ataga ngundilo nangge, engge tunootewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ene ngundilo etoni, sodedonangge doongeyali mete tewolo. Ngundilo tetoni, asa, Yesusndo enedodo mande yanggango ewolo. Yali ingondale teli! Yali oni gulano nga ooga ngalo ma ewelo! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ene ngu oni elayagaku endesina oolelo, ngu ooga Yesusndo tewoku, ngulo mandeyi sodedonangge ende bidodomo ngu mela guminggano oolooteku, ngu wesiyolo ewoli. ");
INSERT INTO rwo_karo_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ngu naluno nangge, Yesusndo ngu endega yokolo, ooloutoni ngu, oni gidegado oni gula yuka biyomimbo manggowo gosiyoyingomu, ngu yolo, Yesusno ombuwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ariya, Yesusndo ngu yuka biyominggaku owetoni, ngu oninggaku mande ewolo. Oni simoo bale ngu kenolo, soliyokolo ewolo. Noole kuli ngundilo ooga Iserel melako tunootetoni, ngu ma kenowololo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ngundilo ngulo, Parisi onindo Yesuslo ko kenolo, nowoondoyemonggo boguwoolo mande ngandilo ewolo. Ene mboolo biyomi Setanlo yanggangomonggo ngu andangetelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ngu naluno nangge, Yesusndo ende bidodomo endeyolo, Yudalo goobooyingo yano ulo, simoo bale etuyelolo, Anutlo Mande Keda Mesalango wesiyolo yunolo, oni simoo bale yowoosoolo, Anutlo mande damoningga, ngundo enengo oni simoo bale soboyelooteku, nguno utoyi, ene nowoondoye hamoo teweloyim. Ngundilo telo, ene oni sayidodomu, ko, sayi oowooyingga nguya yomosiyelowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yesusndo oni simoo bale yeyootoni, ene kowuli oowooyingga ingolo, ngulo ingondudu ulungga telo, ene biyomi nangge oluwonggo. Yesus newendemonggo yeyolo, ngulo nowoondoyi ulungga yunowolo. Ndawugalo ngulo, oni simoo bale ngu Sipsip ingonduduye kini ngundilo, ko, sobowooweloyi ko oni gome nguya kini. ");
INSERT INTO rwo_karo_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ngundilo ngulo, enengo sulena onikuya mande gula ngandilo ewonggori. Oowali oowooyingga kono kuli mandoni yewoku, ene ngulo ko oni oowooyingga kini. ");
INSERT INTO rwo_karo_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ngundilo ngulo, ye komo Anutno kila etoyi, ko oni oowooyingga suleyelootoni, Anutlo kono ombulo, oni simoo bale goobooyelowanggo. Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ngu naluno nguno, Yesusndo enengo sulena oni kande elaya kegidembolo elayagaku negoyelootoni, ombutoyi, yanggango yunootoni, ene yuka biyomi owelo, oni sayidodo ngu mete yomosiyelolo, moondeyemo kowuli ngu andangetenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","4","Yesuslo sulena oni ngu ngandilo: Sayimon oowooyi gula Pita, ko, enengo koneyo Enduru; Yems ko Yon ngu Sebedi simoongo; Pilip; Batolomeyu; Tomas Matiyu, ngu bobeye yoweloyi oningga; Yems ene Alipiyaslo nangoni; ko Tadiyas; Sayimon, ngulo damoni ngandilo: enengo mela, ngu mela gula onindo, sobowooweloyi ingonduduni kini oolengo. Ko Yudas Iskariyoot ngu oningga, ngundo damodamoni telo, Yesus me oni kandeyemo yewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesusndo enengo sulena oni kilalongo mamana mande ngundilo yunowolo. Ye oni sowe oowooyingga Yudalo oni kini nguno ma uwelo. Ye ende gidega Sameriya mela nguno oolootenggoku, nguno nguya ma uwelo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Kini, ye Iserel oni simoo bale nangge nguno oolouyi. Ene Sipsip, ngundo enengo oole yokootenggoku ngundilo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ye oolouya ngu, mande ngandiya wesiyoya eyi. Anut Oo Bidodo Sembuli Sembunaye, ngundo nalu enengo oni simoo bale soboyelooteku, ngu kuli namoko ombute. ");
INSERT INTO rwo_karo_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ye ko gula ngandiya teyi. Ye sayi oni yomosiyeloya, oni kumooyingomu yokutuyeloya, ko moondeye golimambudodomu oni yomosiyelootoyiga mete tetoyiga, ko yuka biyomi nguya oweyeloyi. Nondo ye Anutlo mamana mande yunolo, ko nondo ko biyomi telo, yengo nowoondoye hamoo teyingongga, ngu yanggango kingo yunowono. Ariya, ngundilo nangge, ataga, yengo nalu, yeba nangge saya, oni simoo baleno ngundiya kingo yunoyi. ");
INSERT INTO rwo_karo_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mete, ye bobeye ma yolo, siliyowelo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ye siyaki, ko towi elaya, keye goweyi elaya, ko usutoko gula, ngu ma yowelo. Kini, oni endemo oolootenggoku, ngundo mete oo bidodo yunolo hoolooweyelowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ngundilo nangge, ye ende ululumo ko bobodimo, nguno ye oni gome ereweya, yeyoya, oni metemi nenengongga kenoya, ngundo yano nangge oodega, oolouya, nalu saweloyigakuno yokoya sayi. ");
INSERT INTO rwo_karo_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ye ya gulano uya ngu, oni ngu yano oolootenggoku, ngu kumana yunoyi. ");
INSERT INTO rwo_karo_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Oni simoo bale ngu yano oolootenggoku, ngundo ye gome soboyelootoyiga ngu, ngu Anutlo kumanangga enedodo mete oluwa. Asa, ngundilo nangge, enendo gome ma soboyelootoyiga ngu, ngu Anutlo kumanangga eneno ma oluwa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ngundilo nangge, oni gulado yoyolo, enengo yano ma utoni ngu, ko endemo oni simoo baledo Anutlo mande kootu inootoyiga ngu, asa, ye ende yokoya, oolouya ngu, keyemo gugukakawu yonggulumooya, ye sayi. ");
INSERT INTO rwo_karo_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nondo yeno hamoo eteno. Kootusina, oni simoo bale wilikoyeloweloyi nalu ulunggano, ngu Anutndo ngu endemo oni simoo bale ngu kowuli ulungga oolengo yunowa. Ngu endemo kowulingga yunoyingo, ngundo oni simoo bale Sodom ko Gomora ende elayagano kowulingga, ngu dagatelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Yesusndo mande gula ewolo. Ye gome ingondale teyi! Nondo ye Kristen oni, Sipsip ngundilo ngu suleyelootoowe, se goki kewooloyemo oolouwanggo. Ye silelo damoni keyoyi. Ene ingondudu ulungga telo, oo gome kenolo ingolo, oo tewelo ingooteku, ngu tete. Ye nu mumukondililo damoni nguya keyoya, ngunonggo damoni biyomi teweloyim, ngu ma ingowelo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ye onilo ingonda gome teyi! Enendo yoyolo, ya biyomimo oolelo, wilikoyeloyi musiyomo oolelo, enengo goobooyingo yano gisasaluyelowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ye nono oni nowoondoye hamoo tetoyi, ngulo enendo ye yodowoolo, Gabman oni, ko, melako oni koleteyingo tabango ulungga, ngu doongeyemo ombuwanggo. Ngundilo ngulo, ngu naluno, ye Anutlo Mande Keda Mesalango ngu onino, ko oni sowe oowooyingga Yuda oni kini, nguno nguya wesiyoya yunoyi. ");
INSERT INTO rwo_karo_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ye nono nowoondoyemo hamoo tetenggoku, ngulo kowulingga ngu tunootetoni ngu, ye nowoondoyemo sosolelo, ngandilo ma ingowelolo ewolo. No oni ululumo ndatelo mandega ewano; ngundi, enendo etoyi ngu, nondo gumi ndatelo ewanolo ma ingololuwelo. Ngu nalunggano nguno, ye ma sosolewelo. Ndatelo ngulo, yengo Anut, ngundo ingondudu ye yunootoni, mande ngundilo wesiyolo ewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Yengombo ngu oo ngu ma wesiyolo ewanggo. Kini, Anutlo Yuka Kundingiyi, ngundo nangge ingonduduyemo etoni ewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Kowuli naluno, oni gulado koneyo dowoolo, oo wilikoweloyi musiyomo ooletoni, uleyi kumoowa. Ngundilo nangge, eweyimbo nguya nangonimo ngundilo tetoni, simoongombo ewenemi nguya ngundilo tewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Yo, hamoo, ngu naluno, ye nolo nowoondoyemo hamoo tetenggoku, ngulo oni nowoondoyemo hamoo ma teyingo, ngundo yeya nowoondoye biyomi ulungga ingowanggo. Ene ngundilo tetoyi ngu, oni gula newende hamoo yanggango telo oode, nalu wengamo oluwaku ngu, asa, Anutndo ene yootoni, ngu oningga ngu Anutya sugi sugi oluwali. ");
INSERT INTO rwo_karo_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Oni simoo bale ende gulado yombuliyelowelo tetoyiga ngu, ye ende gulano sodedo sayi. Ngu endemo oni ngundo nguya damoni biyomi yeno tetoyi ngu, asa, ye ende gulano sopiyoya sayi. No yeno hamoo oolengo eteno. Ye Iserel ende bidodomo ko ngundilo ngu ma temukoyingomo, no Anut Nangoni Oni Kilalongo ko ombulo yoyowano. ");
INSERT INTO rwo_karo_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Simooye Skulno oolouwonggoku ngu, ngu komo enengo etuyeloyingo oningga ngu nowoondoyemo oliyi. Ene ngundilo nangge, sulena oni nguya komo enengo sobosobo oni ululu nowoondoyemo oliyi. ");
INSERT INTO rwo_karo_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Mete Skul oni nguya, etuyeloyingo oni ngu kilalongo oolengo tunootewanggo. Ngundilo nangge, sulena oni nguya enengo oni ululu kilalongo oolengo mete tunootewanggo. Ngu hamoo, nondo yengo nowoondoye hamoo teyingo ngulo Awaye oolooteno. Ene nolo me oni gidalegado no kootunesina oowoone biyomi Setan, ngundi, Biyelsebab elo ngu, asa, ngundilo nangge, ye nolo kilalongo telo oolootenggoku, ye nguya ngundilo kootuyesina oowooyi biyomi guladilo guladilo ewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ngundilo ngulo, ye me oni melako ngano oolootenggoku, ngu ma sosolewelo. Ndatelo ngulo, mande bidodo nowoondoyemo ngu ingolo, kombiteyingo oolooteku ngu, kootusina oode, tunoo oolengo tunootemukowa. Ngu oo ngu wiliyoyingo ngu, kootusina, onindo kenowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nondo mande uleriko etuyelolo, yunootenoku nga ngu, yendo mela himi sano wesiyoya yunoyi. Ngundilo nangge, ye mande tolige sodeyebo ingootenggoku ngu, ye mande eweloyi musiyomo, ngunonggo mande wesiyoya eyi. ");
INSERT INTO rwo_karo_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ene ye oni goweye moondeye uleyi kumootenggoku, ngulo ma sosolewelo, ndatelo ngulo, ene gaboye nguya mete ma uleyi kumoowa. Kini, ye komo Anutlo nangge sosoleyi. Ngundo ngu, ene mete moondeye gaboye nguya elayadodo Setanlo ende biyomi, de nombo ma kumooweloyi, nguno ye oolongooyelowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Oni ngu nu bobodi digi tanggooli gulanangge, ngundo nangge uliyootenggo. Ene Awaye Sambono oolooteku, ngundo ma ingootoni ngu, asa, ngundilo nu bobodi ngu melako ma solewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Yo, Anutndo nu ngulo gome ingolo, sobowoolo, ene ye soboyelolo ingooteku, ngundo nu bobodi soboyelooteku damoningga, ngu dagate. Yo, Anutndo tabaye uye ngu kuli kandangelo, ingowoku ngu, ye ngu watayi kini. Ngundilo ngulo, ye ma sosolewelolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ngulo oni gulado no oowoone oni simoo bale doongeyemo wesiyolo, ewaku ngu, nondo nguya ngu oningga oowooyi Awane Sambono oolooteku, ngu doongeyimo nguya wesiyolo ewano. ");
INSERT INTO rwo_karo_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ene oni gulado oni simoo bale doongeyemo no kootu nunootoni ngu, asa, nondo nguya ngu oningga Awane Sambono oolooteku, ngu doongeyimo nguya kootu inowano. ");
INSERT INTO rwo_karo_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ye ngandilo ma ingondudu tewelo, no melako ngano ebe yeni, kumoowelo ombutelo, ma ingowelo. Kini, no ebe yewe kumoowelo ma ombuwonowolo. No duge ngu Anutlo mandeni ngundilo ngu yolo ombuteno. ");
INSERT INTO rwo_karo_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Yo, nolo dugega ngando ngu oni simoo bale bidodo kewoolo wesowooyilootoni, wata elaya tunootelo, gula oni simoo bale nono nowoondoyemo hamoo telo oodoyi, oni simoo bale wata gula nowoondoyemo hamoo ma teyingo oluwanggo. No ngulo ombuwono. Simoo gulado eweyimboya mundi telo, sungo sungo oluwali. Bale gulado nemimboya mundi telo, sungo sungo oodoli, ngundilo nangge, bale gulado neboyiboya mundi telo oluwali. ");
INSERT INTO rwo_karo_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ngundilo nangge, oni simoongolo ya gulananggemo oolootenggoku, nguya mundi telo, sungo sungo oluwanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Oni gula eweyi nemimbolo nangge ingooteku damoningga, ngundo nolo ingooteku damoningga, ngu dagatoni ngu, ngu oningga ngu nolo doboone kini. Ngundilo nangge, oni gula nangoninggalo ko namboninggalo gome ingooteku damoningga, ngundo nolo ingooteku damoningga, ngu dagatoni ngu, asa, ngu oningga nguya nolo doboone kini. ");
INSERT INTO rwo_karo_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ene oni gula enengo newendemo hamoo teyingo ngulo ene ma kumoowelo telo, ngunonggo ene no kenelowaku ngu, asa, ngu oningga nolo doboone kini. ");
INSERT INTO rwo_karo_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Oni gula melako ngano enengombo enengo keda oluweloyiga ngu yowaku ngu, oniyooge, kootusina, ene oonatewa. Ngundilo nangge, oni gula nolo ingolo, meyelo, nolo konemo enengo keda sugi sugi oluweloyi yokowaku ngu, asa, ngu oningga, ngundo noya keda sugi sugi oluweloyi ngu Sambo endemo yowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Oni gulado ye yomosiyelowaku ngu, ene ngundilo nangge, no nguya yomosineloote. Ngundilo nangge, oni gulado no yomosinelooteku ngu, asa, ene Anut, no sulenelootoni ombuwonokungga, nguya yomosiyoote. ");
INSERT INTO rwo_karo_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Oni gula Anutlo ingondudu ewo oningga ombutoni, kenolo, no Anutlo ingondudu eyingo oni hooloowewelo ingolo, ene yolo, enengo yano ulo gome sobowooteku ngu, asa, Anutndo ngulo uli ulungga inowa. Ngundilo nangge, oni gula oni nenengo metemingga ombutoni, kenolo, ingolo, ene yolo, enengo yano ulo sobowoowaku ngu, asa, ngu oningga nguya Anutndo uli ulungga inowa. Ndatelo ngulo, onindo oni Anutlo ko tetenggoku, ngu hoolooweyelootenggoku ngu, Anutlo ko goboolo tetenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Oni gulado ngu oni simoo bale nolo nowoondoyemo hamoo teyingo ngu oowooyidodo kini, ngu kenolo, ingolo, ngulo ene sono gingo tobano wendolo, inowaku ngu, asa, no yeno hamoo eteno. Ngu oningga ngu uliyi gome yowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesusndo enengo sulena oni kande elaya kegidembolo elayagaku, ko teweloyi ngulo mande yunowolo. Ene mande kinitetoni ngu, asa, ene ngu endegaku yokolo, ende oowooyingga ngu Galili mela oolooteku nguno oololo, Anutlo mande wesiyolo etuyelolo, oni simoo baleno yunowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ngu naluno nguno, Sonoyeloyingo oni Yonngga ya biyomimo oode, ngunonggo Yesusndo ko tewoku ingolo, ngulo enengo sulena oni suleyelootoni, Yesusno oololo, sumoo ewelo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ene Yesusno mande ngundilo sumoo ewolo. Ge nooleno nenengo tunoo oolengo e. Ge Yuda onindo oni ulungga sobowootetoku, bine; ngundi, noolendo oni gula sobowoowato, bine? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ene oo ngundilo sumoo etoyi, asa, Yesusndo mande gumi ewolo. Ye oolouya, Yonno oo kenolo ingootenggoku, nga eyi. ");
INSERT INTO rwo_karo_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ye oolouya, Yonno ngandiya eyi. Oni doongeyi kilingomu ngu ataga doongetetoyi; oni keye biyomimu ataga gome endeyootoyi; golimambudodo oni enengo goweyi ataga metemi tetoyi; oni sodeye tuwoomu ngu mande ingootoyi; oni kuli kumooyingomu ataga ootookoodoyi; owoolongo oni Anutlo Mande Keda Mesalango ataga ingootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Oni gula newende nolo hamoo telo, ingonduduni elaya kini oluwaku ngu, ariya, ngu oningga newende imakeyingo ootoolo, oni oni tewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","9","Ariya, Yonlo sulena oniku ngu ingolo, ene sawonggori. Ngundilo tetoyi, Yesusndo oni simoo bale kewooloyemo, Yonlo mande ewolo. Ye kuli oni kini kingo melako oolouwonggoku, nguno ndawuga kenowonggo? Ye, bine, doogobo kumuku nungo umamingootoni, kenowelo oolouwonggo, bine? Kini, ye nguno ndawuga kenowelo oolouwonggo? Ye bine, oni gulado nenggulo gomengga tetoni, ngu kenowelo oolouwonggo, bine? Kini, oni nenggulo gome gomemu tetenggoku ngu, ene mela oni sobosobo koleteyingo ulungga, ngundo yano nangge oolootenggo. Asa, ye nono eyi. Ye nguno ndawugalo oolouwonggo? Anutlo ingondudu eyingo oningga kenowelo oolouwonggo, bine? Yo, no yeno hamoo eteno. Yon, ngu Anutlo ingondudu ewo oni, ngundo Anutlo ingondudu eyingo oni gidega ngu dagayeloote. ");
INSERT INTO rwo_karo_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yo, Yon ngu Anutlo ingondudu eyingo oni, ngundo Anutlo ingondudu eyingo oni gidega ngu dagayeloote. Ndatelo ngulo, Anutlo mandeno, Anutndo Yonya ngandilo ewolo. Nondo ko oni gula suleyootoowe, ngundo ge koletelo ulo, nolo mandene wesiyolo ewa. Ngundo gengo oolege yoonenengowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nondo yeno hamoo eteno. Sonoyeloyingo Yon ngulo oowooyi, ngundo melako oni tunooteyingo nga bidodo dagayeloote. Ene Anut doongeyemo, nolo nowoondoye hamoo tetenggoku, ngu kewooloyemo oni bingamini kiningga, ngudodo Sonoyeloyingo Oni Yonlo oowooyi dagate. ");
INSERT INTO rwo_karo_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Yo, kuli Sonoyeloyingo Oni Yondo no tunooteweloyi, ngulo mande wesiyolo ewolo. Ngu naluno, ko ataga nga naluno nguya, Anutlo me oni enengo yanggangoye, ngundo Anutlo mande damoni, ngundo enengo oni simoo bale soboyelooteku, ngu keyoyelolo, andangewelo ko yanggango tetenggo. Ene ngundilo tetenggoku, ene oni oowooyingga oolengo Anutno nowoondoyemo hamoo tetenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Anutlo ingondudu eyingo oniku, mamana mandeno nguya, ko Sonoyeloyingo Oni Yon nguya, ngu bidodo nga nalunggano ngano, Anutndo noole ko yoyoweloyi oni Kristus suleyootoni ombuweloyi, ngulo mande ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ene ye mete nowoondoyemo hamoo teya ngu, asa, ye ingoyi. Yon ene Ilayisa oningga ngundo ombute. ");
INSERT INTO rwo_karo_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","16","Oni gula sodeyidodo tetoningga ngu, asa, ene komo gome ingoni! Oni simoo bale ngano oolootenggoku, ngu simooyembo ende kewooloko koondoongetetenggoku ngundilo. Simooye wata gulado simooye gidegalo meno yanggango ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Noole nggusi uwoolo, yambo utooye, ngulo ye ma kunowonggori. Ngundilo nangge, noole nggusi uwoolo, nowoondoyi teweloyi yambo utooye, ngulo ye ma sendowonggorilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ngundilo nangge, simooyembo koondoonge tewelo ma oni oni teyingo, ngulo ye nguya, Sonoyeloyingo Oni Yon oningga, ngulo ko nolo nguya, ye noolengo ma oni oni tetenggo. Yo, Sonoyeloyingo Oni Yon ngundo ombulo, ene oowali ko Wayin sonoyi nguya oowooyingga ma netoni, ngulo oni simoo baledo enengo damoni ngundilo kenolo ewolo. Nga oningga nga ngu, yuka biyomi eneno oolootelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ene Anut Nangoni Oni Kilalongo nondo ombulo, oowali nelo, Wayin sono bodaga netoowe, enendo neyolo etenggo. Nga oningga nga oowali ulungga oolengo, logoyimo neweloyi, ngu dagalo nete. Ngundilo nangge, ene Wayin sonoyi nguya ulungga logoyimo neweloyi, ngu dagalo nete. Ene Gabman bobeye yoweloyi oni ko mbumbuwadodo oni nguya ngulo dobooyelo ewolo. Ene Anutlo ingondudu gomengga, onindo ngu kenolo, ngandilo ingootenggo. Anutlo simoo bale, ngundo damoni gome nenengo ngu keyootenggoku, ngundo simoo bale gidalega etuyelootoyi, kenolo etenggo. Hamoo oolengo, Anutlo ingoyingoni gomengga nga ngu, nenengo oolengolo etenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yesusndo ende gidegawoole damoni sungo oolengo gula onindo ma teweloyim, ngu oni simoo bale doongeyemo tewolo. Ngundilo tetoni, ene oni simoo baledo oo ngu kenolo, nowoondoye ma yowoolengowonggori. Ngulo Yesusndo ngu naluno nguno damoni yelo, ngu endemo simoo bale ngu yeyolo mamanayelowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ye Korasin, ko, Betsayida ende elayaga nguno simoo bale oolootenggoku, yengo nondo nowoondoyi yunooteno! Nondo Tayiya ko Sayidon ende elayaga, nguno simoo baleno damoni sungo oolengo gula onindo ma teweloyi, ngu nondo yengo endemo tewonoku, ngundilo eneno tetoowe ngu, asa, ngu ende elayagano oni simoo bale, ngundo ngundilo oo kenolo, nowoondoye kowuli ingolo, ngulo ene sodedonangge nowoondoye yowoolengolo, nolo hamoo ingowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Asa, no yeno hamoo eteno. Kootusina, oni simoo bale wilikoyeloweloyi nalu ulungga nguno, yendo kowuli yowanggoku, ngundo Tayiya ko Sayidon onilo kowuliye tunootewaku ngu dagalo yowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ariya, ataga, no ye Kaperniyam endemo oni yeya eteno. Yengombo ingootenggoku, yengo ende ngundo ende bidodo melako oolootenggoku nga dagayeloote, bine? Ngundilo nguya kini. Anutndo ye yoyolo, Setanlo ende biyomi de nombo ma kumooweloyi, nguno oolongooyelowa. Oni gulado Sodom endemo, damoni sungo oolengo gula onindo ma teweloyi, nondo ye kewooloyemo tewonoku ngu, ariya, ataga Sodom endega ngundilo oluwa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ene no yeno hamoo eteno. Kootusina, oni simoo bale wilikoyeloweloyi nalu ulungga nguno, yengo kowuliye yowanggoku, ngundo Sodom onilo kowuliye tunootelo, ngu dagawalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ngu naluno, Yesusndo Eweyimo yemboongelo ewolo. Awa, ge sambo melalo Sembuli Ulungga. No oowoongge elo bingamingge okooteno. Ndatelo ngulo, gengo mande gome ngu oni ingonduduyedodo nguno imangoolo, oni ingoyingoye bodaga, simooyembolo ingoyingoye ngundilo oni ngu etuyelowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Yo, awa, gengombo ingolo tewoku, ngulo ge oni oni tete. Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Yesusndo mande gula ewolo. No Awanembo oo bidodo nunowolo. Awando nangge enengo Nangoni ingoote. Ngundilo nangge, Nangonimbo nangge eweyi ingoote. Yo, Anut Nangoni, ngundo eweyi ingolo, ene Anutlo Mande Keda Mesalango ngu oni simoo baleno wesiyolo yunowolo. Oni gidalega nowoondoyemo hamoo tewanggoku ngu, Nangoni kuli logoyelowoku, ngu oni ngundo Awa nguya ingootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ye nolo kenemo oni simoo bale, ye kowuli ulungga koolowoolo, kiyayi yetenggoku ngu, asa, ye nono ombutoyi, nondo ye kengeyingo yunowano. ");
INSERT INTO rwo_karo_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ye ngu kongga yunowonoku, ngu kowuli kini. Ndatelo ngulo, no ye hoolooweyelootoowe, nolo damonine imakeyingo, ko, nondo nenengo oowoone bingami ngu ma okooteno. Ngundilo ngulo, ye nono ombutoyi ngu, nondo yengo gaboye hamoo kengeyingongga, ngu yunowano. ");
INSERT INTO rwo_karo_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Yo, nolo kongga nondo ye yunowonoku ngu, ngu kowuli kini, imakeyingo nangge. Ngu ooga ngu koolowooyi, elo yunootenoku, ngu kowuli kinilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Yudalo nalu kundingiyi Sabat gulano, Yesus enengo sulena onindo nggile ko gula oole kewoolokuli oolouwolo. Ngundilo oololo, enengo sulena onikundo nggile engge wembuyimonggo andangelo, goweyi tuloolo, engge tanggoolimu keda newonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ene ngundilo netoyi, Moseslo mamana mande sobowooyingo oni oowooyi Parisi, ngundo yeyolo ewonggori. Yesus, keno! Gengo sulena onindo Sabatno ko tetenggoku, ngu mamana mandeno ewoku, ngu toongootenggoku ngu! Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ngundilo etoyi, Yesusndo mande gumi ewolo. Ye kuli Iserel mela oni sobosobo koleteyingo ulungga Dewit, enengo me oni, ngundo oodoolo kumoolo teyingomu, ngu ye ngulo mande kandangelo, kuli ingowonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Dewit ko enengo me oni Yudalo towimbo ya kundingiyi ngu newendemo ulo, oomanongoyingo kundingiyi ngu yolo newonggori. Ngu oomanongoyingo kundingiyingga, enendo neweloyi kini. Kini, ngu Anutlo woolo yeyingo oni kundingiyi, ngundo nangge neweloyi. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ye Moseslo mamana mandeno kuli kandangelo ingowonggo. Anutlo woolo yeyingo oni kundingiyi, ngu Sabatno ngu mete Yudalo towimbo yambo yano ngu ko teweloyi, ngulo loogu kini. Yo, ene Sabatno Anutlo simoo bale hoolooweyeloweloyi, ngulo kowulini kini. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ariya, no yeno hamoo eteno. Nga oningga nga oolooteku, ngu oowooyi ngundo Yudalo goobooyingo ya ngulo yanggangoni ngu bidodo dagayeloote. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kuli, Anutlo mandeno ngandilo ewolo. Anutndo no woolo kundingiyi ngulo ma oni oni telo, ene nowoondoyi teweloyi ngulo gome ingootelo ewolo. Ye nga mandega ngalo damoni gome ingolo ngu, asa, ye oni mbumbuwa ma tetenggoku ngu, ma kowuli yunowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Yo, hamoo, no Anut Nangoni Oni Kilalongo nondo Sabat ngulo Sembuli ulunggalo ewonowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","10","Yesus ngu musiyonggaku yokolo, ene Yudalo goobooyingo yano ulo, ene oni gula kandeyi bingo yeyingomu, oodoni kenowolo. Ngu naluno, Moseslo mamana mande sobowooyingo oni oowooyi Parisi, ngundo Yesus goweyi sanggawelo kingo mande eweloyi ngu erewelo, ngulo sumoo ewonggori. Moseslo mamana mandeno sayi oni mete Sabatno yomosiyeloweloyi, ngundi kini bine? Ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","12","Ene ngundilo sumoo etoyi, Yesusndo mande gumi ewolo. Sabatno yengo Sipsip ngu meleno soletoni ngu, ye ngundilo kenolo yokootoyi, meleno oluwa, ngundi yowanggo, bine? Ngundilo nangge, Anut doongeyimo, onindo Sipsip ngu dagate. Anut doongeyimo, ngu mete oni nowoondoye yunolo, Sabatno oni hoolooweyelowanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ngundilo elo, ene yowoolengolo, oni kandeyi biyominggakuya ewolo. Kandege yoonenengo. Etoni, ene ingolo, ngundilo tetoni ngu, kandeyi biyominggaku kandeyi metemi gidalega ngundilo tunootewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ariya, Parisi onindo ngundilo kenolo, ene sanggili telo, ngu musiyonggaku yokolo, salo, goobooyingolo, Yesus uleyi kumooweloyimbolo mande oowooyingga ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","16","Yesus ene Parisi onindo uleyi kumooweloyimbolo mande ewonggoku ngu ingolo, ngulo ene ngu endega ngu yokolo toongewolo. Ene oni simoo bale oowooyingga, ene keyolo, ooloutoyi, Yesusndo oni sayidodomu, ngu bidodo yomosiyelolo, enendo simoo baleya mande yanggango ewolo. Ye ingondale teyi! Nondo ooga tetenoku nga, onino ma yootunolo ewelolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ngundilo ngulo, ngu tetoni ngu, kuli Anutlo ingondudu eyingo oni, Ayisaya, ngundo mandega eyingomu, ataga engge tunootete. Ene Yesuslo ngandilo nakangolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","21","Nga oningga, nolo ko oni oolengo, nondo kuli sunggi yewono. Nondo ngulo gome ingolo, nowoondone ene inooteno. Nondo nenengo Yuka Kundingiyi ngu oninggano ngu newendemo yetoowe, ene nolo damoni nenengo oni simoo bale mela bidodomo wesiyolo ewa. Ene longge sambi manggalu ma tetoni, oolekononggo manggowo ngguyi ma ingowanggo. Ene oni nowoondoye yanggango kini ngundi kowuli ingootenggoku, ngu nowoondoyi yunoyi. Ataga, ene ngundilo ko teteku ngu, kootusina, wilikoweloyi nalu wengamo, nguno nowoondoyi teweloyi damoni nenengo ngu simoo bale doongeyemo tunootelo, damoni sungo dagayelowa. Ngundilo ngulo, oni simoo bale mela bidodomo nowoondoyemo hamoo telo, ene nangge sobowoowanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ariya, ngu naluno, oni gula mboolo biyomimbo doongeyi manggowo gosiyoyingomu, ngu yolo, Yesusno mayewolo. Yesusndo ngu oninggaku yomosiyootoni ngu, ene mande gome elo, ko doongetelo, mela kenowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ene ngundilo tetoni, oni simoo bale ngu kenolo, soli ulungga yokolo, ewonggori. Nga oningga nga, ene mela oni sobosobo koleteyingo ulungga Dewit, ngulo nangge bine, ngundi, ene Anutndo noole ko yoyoweloyi oningga sunggi yewoku, ngu bine? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Parisi onindo simoo balelo mande ngu ingolo, ene Yuka Kundingiyi nguya, kootusina mande ewonggori. Ngu Yesusga ene yuka biyomi oweteku, ngu mboolo biyomi ngulo tabango ulungga, Biyelsebab Setan, ngundo yanggango inootoni, ko tetelo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ene ngundilo etoyi, ariya, Yesusndo enengo ingonduduye ingolo ewolo. Mela sobosobo koletelo oni gula, ngundo enengo oni simoo bale soboyelooteku nguya, enengo nangge ebe utolo, nguno ma siyelo ngu, asa, ene mete yanggango ma dikalo oluwanggo. Ngundilo nangge, ende gulananggemo oni nowoondoye goboolo ma siyelo ngu, asa, ngu endega ngu ngundilo sugi yanggango ma oluwa. Ngundilo nangge, ya gulananggemo oni wesowoolo, elaya tunootelo, enengo nangge, ngu ebe utolo, ngu yano oni ngu yanggango ma ootoolo, ya toongoolo, sungo sungo sawanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ene ngundilo nangge, Setando enengo nangge yuka biyomimboya ebe utolo ngu, wesowoolo, elaya telo, yanggango ma dikalo oluwa. Ene sodedo kinitewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Asa, nondo yuka biyomi Biyelsebab Setan ngu oowooyimonggo, owewanoku ngu, ariya, yengo oni ngundo yuka biyomi owewelo ngu, ndawu oningga oowooyimo ko tewanggo? Ngundilo ngulo, yengo onindo nangge yengo mande etenggoku ngu, ngu wilikowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ngundilo nangge, Anutlo Yukambo hooloowenelootoni, yuka biyomi owewanoku ngu, ariya, ye ingootenggo. Anutlo nalu enengo oni simoo bale soboyelooteku, ngu ataga yeno ombutelo ingootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ngundilo nangge, no mande yamonggawo gula yeno eteno. Oni gula ene mete oni yanggango gulalo yano kingo ulo, oo sitowini andangelo yowa, bine? Kini, ene koletelo komo ngu oni yanggangongga ngu utombo gome gosiyolo yokolo, ngunonggo ene mete yanimo ulo, oo sitowini bidodo andangelo yowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Oni gula no doboone kini oluwaku ngu, ngu oningga ngu nolo me oni. Ngundilo nangge, oni gula no ma hooloowenelolo, Sipsip yoyolo, nowoondoye hamoo teyingo pawa newendemo ma yoyetoyi ngu, asa, ene Sipsip yombuliyelowelo ingolo oluwa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ngundilo ngulo, no yeno hamoo eteno. Yengo mbumbuwa bidodo, ko Anut kootuyisina elo, yumooyinolo mande biyomi etoyi, ngulo ye nowoondoyi telo, yowoolengootoyi ngu, asa, Anutndo kowuliye andangeyunolo kapengo yewa. Ene oni gulado Anutlo Yuka Kundingiyi nguya kootuyisina mande biyomi ewaku, ngu nangge, Anutndo ngulo mbumbuwa ma andangelo kapengo yewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Yo, oni gulado no Anut Nangoni Oni Kilalongo kootuyisina mande biyomi elo, Anutno sumoo yemboongelo, ewaku ngu, Anutndo ngulo mbumbuwa andangelo kapengo yewa. Ene oni gulado Anutlo Yuka Kundingiyi kootuyisina mande biyomi ewaku ngu, ngu nangge Anutndo ngulo mbumbuwa ma andangelo kapengo yewa. Ngu mbumbuwaga ngu sugi sugi oluwalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Yesusndo Parisi oniya ewolo. De metemingga ngu gome enggewa. Ngundilo nangge, de biyomingga ngu engge biyomi tunootewa. Koletelo, oni de tanggooli kenolo, ingolo, ene de metemi ngundi biyomi, bine, ngu ingowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ye sile biyomi simoongo! Ye nowoondoye biyomi oolengo oolooteku ngu! Ngundilo nangge, ye mete manggoyemonggo mande metemi wesiyolo, ma ewanggo. Yo, hamoo oolengo, ye nowoondoyemo ingondudu biyomi oolooteku, ngundilo nangge, manggoyemonggo mande biyomi nguya tunootewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ngundilo nangge, oni metemingga ngu, ene ingondudu gome nowoondoyemo oolooteku ngu, ngu ene damoni metemi ngu yeni tunootete. Ngundilo nangge, oni biyomingga ngu, ene nowoondoyemo ingondudu biyomi oolooteku ngu, ngundo damoni biyomimu yeyi tunootete. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Asa, no yeno eteno. Anutndo wilikoyeloweloyi naluno, oni kingo mande mande bidodo bulibali ewonggoku ngu, ngulo damoni Anut doongeyimo ngu, wesiyolo ewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Yo, hamoo, Anutndo yengo mande bidodo melako etenggoku ngu, ngulo ene ingolo, enengombo wilikoyelolo, ye oni metemi, ngundi, oni biyomi bine, ewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ngu nalunggano nguno, Moseslo mamana mande sobowooyingo oni, oowooyi Parisi, ko, etuyeloyingo onindo Yesus tewoongolo ewonggori. Oo etuyeloyingo oni, mete ge oo damoni sungo oolengo gula onindo ma teweloyim gula tetooga, noole kenowelo ingooteto. Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ene ngundilo etoyi, Yesusndo mande gumi ewolo. Ye melako oni oolootenggoku nga, ye ingonduduye biyomi ingolo, bosebalese damoningga ngu telo, ngunonggo Anutno nowoondoye hamoo ma telo, damoni sungo gula onindo ma teweloyim, ngu kenowelo, nono elolootenggo. Ataga, nondo yeno sunggi gula ma tetoowe kenowanggo. Kini, nondo ngu Anutlo ingondudu eyingo oni kulimi Yona, ngulo sunggiga ngu nangge ewano. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yo, kuli Yona iso ulungga oolengo ngu useyi newendemo sa suwoo kabusa, nguno oluwolo. Ngundilo nangge, no Anut Nangoni Oni Kilalongongga nguya sa suwoo kabusa, mele newendemo ngu oluwano. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Yo, Yonando Anutlo mande Niniwa endemo oni ngu yunootoni, ngulo ene nowoondoye hamoo yowoolengowolo. Ene ye kewooloyemo oni gula (Yesus) oolooteku, ngundo Yonalo yanggangoni ngu dagate. Ene ye ngulo mande ma ingolo, nowoondoye yowoolengolo, hamoo ma tetenggo. Ariya, ngulo ngu, nalu wengamo, oni wilikoyeloweloyi naluno, Niniwa onindo ye nga oni oolootenggoku ngano dikalo, mande yanggango elo, goweye sanggaweyelowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kuli, Anutndo Yuda melako oni sobosobo koleteyingo ulungga, Solomon, ngu ingondudu ulungga oolengo inowolo. Ngulo ngu, melako bale sobosobo koleteyingo ulungga, ngundo Solomonlo ingondudu ulungga ngu ingowelo, ngulo ngu enengo mela yowoko biyomimu ngu yokolo, yade yade mayelo, enendo ingondudu ulunggaku ingowolo. Ene ye kewooloyemo, oni gula (Yesus) oolooteku, ngundo Solomonlo ingonduduni, ngu dagate. Ene ye ngu kenolo, nowoondoye hamoo ma yowoolengootenggo. Aliya, ngu bale sobosoboga nguya nalu wengangga nguno ombulo, dikalo, yengo mande damoni biyomi tewonggoku, ngu bidodo yengo goweye sanggawelo mande yanggango oolengo ewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Yesusndo Parisi onino mande gula ko ewolo. Mboolo biyomingga, ngundo oni newende yokolo ngu, ene mela arimo kengewelo musiyo erewelo oolouwolo. Ene ngundilo telo, ene ma kenowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Mboolo biyomi kengewelo musiyo ma kenolo ngu, ngulo ene enengo ya kuli oluwoku, nguno ko oolouwelo ewolo. Ariya, ene yano ko ombulo, nguno oni kini, ya namboyi kenolo, oo bidodo nenengo oodoni, ngu kenowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ariya, ene oo ngundilo kenolo oololo, yuka biyomi kandegula gidembolo elaya yoyolo, ombulo, yano ulo, enedodo oluwonggori. Enengo dobooguliyi, ngulo damoni biyomi oolengo, ngundo koleteloga damoni biyomi tewoku, ngu dagate. Kuli ngu oningga biyomi oluwoku, ataga, ene biyomi oolengo ulungga ooloote. Ngundilo nangge, oni damoni biyomi melako ngano telo oolootenggoku, ngundilo tewanggo. Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ngu naluno nguno, Yesus oni simoo bale kewooloyemo bibitelo, mande wesiyolo, yunolootoni ngu, nemi koneyo enedodo mande ewelo ombulo, endesina dikawonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Dikatoyi, asa, oni gulado Yesusno ewolo. Ingo, nangge konege geya mande ewelo ombulo, endesina dikatenggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ene ngundilo etoni, asa, Yesusndo mande gumi ewolo. No namone konene ngu oone? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Yesusndo enengo sulena onikuno kandedisi telo ewolo. Ngu hamoo oolengo, oni endesina dikatenggoku, ngu nolo namone konedoboone. Ene nga oni ngano nowoondoyemo hamoo telo oolootenggoku, nga nguya nolo namone konedoboone. ");
INSERT INTO rwo_karo_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ngundilo nangge, oni simoo bale, ngundo Awane Sambo Endemo oolooteku, ngulo ingondudu keyowanggoku ngu, ngu oni ngu nolo konene, kuwookuwoone ko nanamonelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ngundilo naluno, Yesus ya yokolo, oololo, Galili sono koongeyingo dabemimo nguno bibitewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ene ngundilo tetoni, oni simoo bale oowooyingga oolengo mayelo, Yesus tanggeyimo gooboowootoyi, ngulo Yesus ene wanggo sanganimo oolelo, bibitetoni, oniku ngu sono dabemimo kelidi sanganimo oluwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Asa, ngu naluno, ene mande yamonggawo yunolo, nguno oo oowooyingga etuyelolo ewolo. Oni gula kono Rayis yuwooyi kuliyowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ene kuliyootoni, Rayis yuwooyi gidega ooleko soletoni, nguno numbo mayelo nemukowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Oo yuwooyi gidega mela digi gumi digidodo musiyosina solewonggori. Mela nguno ulungga kini. Ngulo oo yuwooyingga ngu sodedonangge oolewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ene uli ulo, mela newendemo uweloyi kini. Mela bodaga nangge ngulo ngundilo tewolo. Ene sa oolelo, kenootoni ariyewolo. Ngulo digi gookingombo dedoni, bidodo ariyelo kumoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Oo yuwooyi gidalega utoo so sanggilidodomu, kakali dimoo uto oo kewoolokono solewonggori. Kakali dimoo uto sanggilidodomu oolelo, ngundo doobengolo wiliyowonggori. Ngundilo tetoni, ngulo ma enggewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ene oo yuwooyi gidalega mela gome oolengomo solewonggori. Ngu oo yuwooyinggaku gome oolelo, ulungga yelo, gome enggewonggori. Gidalega engge onibi kandegula (100), gidalega engge onibi kabusa (60), gidalega engge onibiga kande elaya (30) enggewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Oni sodeyidodo ngu mande ingoya, ene komo gome ingoyi! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Kootusina, Yesuslo sulena oniku eneno ombulo, sumoo ewonggori. Ge ndawugalo ngulo, mande yamonggawo nangge oni simoo baleno ete? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ene ngundilo sumoo etoyi, asa, ene mande gumi ewolo. Anut Oo Bidodo Sembuli Sembunaye, ngundo mande damoningga, ngundo enengo oni simoo bale soboyelooteku, ngu kombiteyingo oolooteku, ngu ye tunoo etuyelowa. Ene oni gidalegano ngu, no mande nga eneno yootunolo ma ewano. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ngundilo nangge, oni gula Anutlo Mande Keda Mesalango ingolo, ngu dowootoni, Anutndo oo gula suleyolo, ingonduduni oowooyingga inowa. Ngundilo nangge, oni gula Anutlo Mande Keda Mesalango ngu ma dowoolo, ene koletelo yowoku ngu nangge dowoololuwaku ngu, asa, Anutndo ngu nguya andangelo yowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nondo mande yamonggawo eneno etenoku, ngulo damoni ngandilo. Ene doongetelo, oo kenowanggoku ngu, ene ngulo damoni gome ma ingowanggo. Ngundilo nangge, ene mande ingolo ngu, ene ngulo ingondudu telo, nowoondoyemo yolo ma siliyowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","15","Ngundilo oni simoo bale, ngulo damoniye kulimi Anutlo ingondudu eyingo oni, Ayisaya, ngundo mandega eyingomu, engge tunootewolo. Ene ngandilo ewolo. Ye mande ingootenggoku ngu, ene ngulo damoni ma ingootenggo. Ye doongetelo kenowanggoku ngu, ene oo ngulo ma ingowanggo. Oni simoo bale kuli nowoondoye ukingowonggori. Ene sodeye ukingolo, ngulo ko doongeye kumoondi tewonggori. Damoni ngundilo ma tetoyi ngu, ariya, doongeyembo oo kenolo, ingolo, sodeyebo mande gome ingolo, yolo, nowoondoyemo gome siliyolo, ngu ingondudu tewanggo. Ene nowoondoye yowoolengootoyi ngu, asa, nondo mete ombulo, ene yomosiyelowano. Ene mande nenengo oolengo ngu ingowelo ngu yokootenggoku, ngulo enengo damoniye biyomi ngu ma yomosiyowanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Yesusndo mande gula ewolo. Ngu gome oolengo, ye ngu oni ngundilo kini. Ye doongeyembo oo kenolo, nowoondoye gome ingolo, ko sodeyebo ingolo gome ingowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Asa, no yeno mande yanggango eteno. Kuli, Anutlo ingondudu eyingo oni, ko, oni gidalega nowoondoyemo hamoo teyingomu, ngundo nowoondoye bidodo yengo ataga kenootenggoku, ngu kenowelo ingowanggo. Ene yendo Mande Keda Mesalango ataga ingootenggoku, ene nguya ingowelo hahangewonggoku, ngulo ngu, ene ereremo kinilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ye komo ingoyi! Onindo oo yuwooyi kono kuliyowoku mande yamonggawo, ngulo damoni ngu ngandilo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Oni gidalega Anutlo mande damoningga, ngundo enengo oni simoo bale soboyelooteku, ngu ingolo, ingondudunimo nangge ingolo, ngulo gome ma ingootenggoku ngu, ariya, sodedonangge Setando ombulo, Anutlo mandega ingowonggoku, ngu andangelo yowa. Ngungga ngu, oo yuwooyi ooleko soleteku ngundilo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Oni simoo bale gidalega ngu Rayis yuwooyi mela digidodomo soleteku ngundilo. Ene mande ingolo, sodedo yolo, ngulo ene oni oni tewonggori. Oni oni telo, ene kootusina ngulo ingondudu telo, ngu ene newendemo hamoo tewoku ngu yokowa. Ene uli moole kini ngundilo tewa. Enengo newende hamoo teyingo ngu, ootuwoo bodaga. Ene Anutlo me oni, ngundo oni simoo bale Anutlo mande ingowonggoku, ngu kowuli ulungga yunootenggo. Ngundilo tetoyi ngu, sodedonangge, oni simoo bale gidalega enengo nowoondoyemo hamoo ngu yokolo, Anut kootu inowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Oni simoo bale gidalega ngundilo oo yuwooyi utoo sanggilidodo kewoolokono solewonggori. Ene mande ngu ingootenggoku, ngulomu ene kowuli guladilo nga melangga ngalomu eneno tunootetoni, ko, bobeye ulungga yoweloyimbolo ngulo ingondudu bidodo, ngundo Anutlo mande doobengoote. Ngundilo oni simoo bale ene gome ma enggewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Oo yuwooyi mela gomemo soleteku ngu, ene oni simoo bale gidalega ngu, ene Anutlo mande ingolo, yolo, gome dowoolo, gome enggewanggo. Yo, oni Anutlo Mande Keda Mesalango ngu ingolo, nowoondoyemo gome siliyowonggori. Oo gidalega engge oowooyingga oolengo (100), gidalega engge logomo nangge (60), ko gidalega engge bodaga nangge (30). Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesusndo mande yamonggawo gula yunolo ewolo. Anutlo mande damoningga, ngundo enengo oni simoo bale soboyelooteku, ngu oni kono oo yuwooyi gome kuliyooteku ngundilo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Oni simoo bale suwoono wetomukootoyi, ko sembuliga ngulo me oninggakundo mayelo, kono so biyomi oo yuwooyi kewooloko oolongoolo toongewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kootusina, Rayis yuwooyi ko so biyominggaku nguya goobooyingolo oolewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ariya, ko oniku ko sembulimo oololo ewonggori. Oni ulungga, noolendo ingootetoku, ngu gengo kono oo yuwooyi gomemu ngu kuliyowonggori. Ndatelo ngulo, so biyomingga nga nguya oolete? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ene ngundilo sumoo etoyi, enendo ko onikuya mande gumi ewonggori. Ngu me oninggado tewolo. Ngundilo etoni, ko onikundo enedodo gumi ewonggori. Ge ingootooga, noolendo oololo, so biyomi ngu mete gumoowato, bine? Elo sumoo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","30","Ene ngundilo sumoo etoyi, enendo mande gumi ewolo. Kini, yendo so biyomi gumoolo nguno ngu, Rayis nguya gumoowanggo. Ngundilo ngulo, elayadodo yokootoyiga nguno olili. Kootusina engge mandoni yewo nalunogo, ngu koyi teweloyi onino ewano. Yendo koletelo so biyomimu gumoolo kaweloyimbolo wetumooyi. Ene yendo Rayis yolo, nolo oowalilo yano goobooyingolo, wata yewanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Asa, Yesusndo mande yamonggawo gula yunolo ewolo. Anut Oo Bidodo Sembuli Sembunaye, ngundo mande damoningga enengo oni simoo bale soboyelooteku, ngu de gula oowooyi Mastet yuwooyi ngundilo. Onindo ngu Mastet yuwooyi yolo, enengo kono imiwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mastet yuwooyingga ngu bobodi oolengo puka yuwooyi ngundilo. Oo ngu imitoyi ngu, enengombo oolelo, de ulungga biyomi yelo, oowali gidalega kono ngu bidodo dagayelolo, enengo kambini ulungga yelo, yongeyi tetoni, numbo ngu sanganimo bibitetenggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Asa, Yesusndo mande yamonggawo gula ene yunolo ewolo. Noole Anut Oo Bidodo Sembuli Sembunaye, ngundo mande damoningga enengo oni simoo bale oo soboyelooteku, ngu ene oomanongoyingo koongeweloyi, Yis ngundilo. Baledo ngu Yis yolo, oomanongoyingododo goobooyingolootoni, Yisga, ngundo yeni oololo, oomanongoyingo ngu bidodo koongewa. Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesusndo oni simoo baleno mande yamonggawo nangge yunolo, ene mande gula tunoo eneno ma wesiyolo yunowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ngundilo nangge, kuli Anutlo ingondudu eyingo oni gulado mandega eyingonggaku, ataga engge tunootete. Ene Yesusya ngundilo ewolo. Nondo manggone goosoolo, mande yamonggawo ewano. No mande kuli kombiteyingo oluwoku, Anutndo amana nga sambo mela yewo naluno yade yade oololo, wenga ombulo, ataga ngulo tunoo wesiyolo etenolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ariya, Yesusndo enengo sulena onidodo oni simoo bale yokolo, yano ulo, eneno oololo ewolo. So biyomi kono ooleteku, ngulo mande yamonggawo gedo ewoku, ngulo damoni nooleno etooga, ingowato. Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesusndo mande ngundilo ingolo, ene mande gumi eneno ewolo. Oni gula kono oo yuwooyi metemi kuliyowoku ngu, ngu no Anut Nangoni Oni Kilalongo, ngu no ngundilo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Enengo ko ngu, ngu mela bidodo ngundilo. Oo yuwooyi kono metemimu ngu oni simoo bale Anutlo pawa newendemo oolootenggoku, ngu ngundilo. So biyomingga ngu, ngu oni simoo bale gidalega Setanlomu. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Oni so biyomi kono kuliyowoku, ngu Setan. Engge yoweloyi nalungga ngu, ngu nalu wenga wilikoyeloweloyiga ngu ngundilo. Engge yoweloyi oningga ngu, ngu Anutlo Sambono Oni. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Onindo so biyomi gumoolo, goobooyingolo, de nombono kaweloyi ngu, ngu nalu wengamo, nga melako ngundilo tunootewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","No, Anut Nangoni Oni Kilalongo, Anutlo Sambono Oni ngu suleyelootoowe, ombulo, ngundo oni simoo baledo oni gidega yowoosoolo, mbumbuwa tetenggoku oni ngu keyoyelolo, ko, oni damoni biyomi tetenggoku nguya keyoyelowa. Keyoyelootoyi, Anut Oo Bidodo Sembuli Sembunaye, ngundo endega enengo oni simoo bale soboyelooteku, ngu newendemo ma uwanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ngundilo oni ngu, ene Setanlo ende biyomi de nombo ma kumooweloyi nguno oolongooyelootoni, ene sendo ulungga biyomi telo, metokalikali telo, ngundilo sugi sugi oluwanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ngundilo naluno, oni biyomi Setanlo endemo oluwonggoku, oni nowoondoyemo hamoo teyingo ngu Anut Oo Bidodo Sembuli Sembunaye, ngundo endega enengo oni simoo bale soboyelooteku, nguno sugi sugi oluwanggo. Ngu ende gomenggano nguno, Kristen oni simoo baledo damoni nenengo oolengongga, ngundo himi sa ngundilo oluwa. Oni sodeyidodo tetoningga ngu, ene nga mandega nga gome ingonilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Anutndo endega nguno enengo simoo bale soboyelooteku, ngu bobeye oowooyingga oolengo ngundilo. Ngu bobeye ngu Kesdodo mele newendemo oongoowolo. Nalu gulano, oni gulado ngu kenolo, enebana ko yolo, mele gumisina doobengolo oongoowolo. Ngundilo telo, ene oni oni telo, sodedonangge oololo, enengo sitowi bidodo oni yunootoni, uliyootoyi, ngulo ulini yolo, oololo, ene mela sembulimo mela ngu uliyowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Oni simoo bale Anutlo mande damoningga, ngundo enengo oni simoo bale soboyelooteku, ngu ya dogoni Stuwa oni beye goyayi gula erewelo yoweloyi ngundilo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Oni gulado ngu beye goyayiga kenowoku ngu, ngu gome oolengo tetoni ngu, enengo oo yolo, oololo, oni gidalegano suleyolo, ngunonggo bobeye yolo oololo, ngu beye goyayiga uliyowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Mande yamonggawo gula oni simoo bale Anutlo mande damoningga, ngundo enengo oni simoo bale soboyelooteku, ngu ngandilo. Isolo si sono koongeyingomo oolongootoyi, iso oowooyingga enengo siko ulo oolootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Isolo si isombo hangetoni, yolo, ombulo, sakiko kelidi sanganimo yewolo. Oniku bibitelo, iso metemi nangge wiyokolo, koondomo yewonggori. Ngundilo nangge, iso biyomiku ngu oolongooyi uwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","Ngundilo nangge, wilikoyeloweloyi nalu wengamo nguno, ngundilo tunootewa. Anutlo Sambono Onindo ombulo, oni biyomimu, oni nowoondoyemo hamoo teyingo kewooloyemo oolootenggoku, ngu andangeyelolo, Setanlo ende biyomi de nombo ma kumooweloyi, nguno oolongooyelowanggo. Ngundilo oolongooyelootoni, ngu de ma kumooweloyinggano nguno sugi sugi ootoolo ngu, sendo ulungga telo, metokalikali telo oluwanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesusndo enengo mande gula sumoo ewolo. Ye mande nga bidodo ingootenggo bine? Etoni, enebana gumi ewolo. Yolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ngundilo etoyi, enendo gumi ewolo. Ariya, ngundilo ngulo, Moseslo mamana mande etuyeloyingo oni, ngundo Anut Oo Bidodo Sembuli Sembunayimbolo mande damoningga, ngundo enengo oni simoo bale soboyelooteku ngu, ngulo mande gome ingolo, ene ya ulungga ngulo Sembuli ngundilo oolootenggo. Ngu oningga ngundo ene yano ulo, oo kulimimu ko kedamu nguya yolo, goobooyingolo, dowoolo, koyi tewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesusndo mande yamonggawo yunomukolo ngu, ariya, ene ngu endegaku yokolo toongewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ene yade yade oololo, enengo ende damoni oowooyi Nasaret nguno oololo, oni simoo bale Yudalo goobooyingo yano, Anutlo Mande Keda Mesalango ngu wesiyolo yunowolo. Yunootoni, oni simoo bale enengo mande ingolo, soliyokolo, sumoo ewonggori. Nga oningga nga ingonduduni, ko, oo damoni sungo oolengo gula onindo ma teweloyim, ngu yanggangongga ngu ndanonggo yolo tete? ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","56","Nga oningga nga ya yeweloyi oningga, ngulo nangoni nangge. Noole kuli ingowooto. Enengo nemi, Mariya, ko, enengo konedoboongo, Yems, Yosep, Yudas, ko, Sayimon. Enengo kuwookuwooyi nguya, ngano nooledodo oolooteto. Ngu ingonduduningga, ko oo tewoku ngu, ndanonggo yowo? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ngundilo elo nowoondoyemo sanggili tewonggori. Ene Yesusndo gumi ewolo. Mela bidodomo, Anutlo ingondudu eyingo oni yeyolo ngu, ngu oni ngu Anutlo oni ulungga. Ene enengo yano, ko, enengo ende damonimo nguya oowooyi bingamiye kinilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ndatelo ngulo, ene nowoondoye hamoo ma teyingo, ngulo Yesusndo ngu endegano nguno, oo damoni sungo oolengo gula onindo ma teweloyi, ngu oowooyingga ma tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ngu naluno, Herod ngu Rom Gabman oni, ngundo Galili onilo tabango oode, nguno ene Yesuslo mande binga ngu ingowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ngundilo ngulo, Herodndo soli ulungga yokolo, enengo sulena onino mande yanggango ewolo. Eyi! Ngu oningga ngu, ngu Sonoyeloyingo Oni Yondo, kumoononggo ko ootookooteku ngu! Ngulo ene damoni sungo oolengo gula onindo ma teweloyim, ngulo damoni yanggangonidodo tunootete! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Herodlo sosoleyingo, ngu damoni ngandilo. Kulimi, Herodndo koneyo Pilip baleyi, oowooyi Herodiyas, ngu yakakayi yowolo. Ngulo Yondo balega ngu elambalisa, ngulo mbumbuwayali yootunolo mamanayelowolo. Ngundilo etoni, Herodlo me onindo Yon dowoolo, ya biyomimo yewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ngundilo telo, Herodndo Yon uleyi kumooweloyimbolo, ene endemo oni simoo bale yeyolo, sosolelo, ngulo ene yokowolo. Ndawugalo ngulo, ene ingootenggo. Yon ngu Anutlo ingondudu eyingo onilo ingoote. ");
INSERT INTO rwo_karo_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Herod ene oo simbo ulungga kayingo, ndatelo ngulo, enengo nalu nemimbo yomoowoolo nalu ingondudu teweloyim oo kawolo. Ngu naluno nguno, Herodiyaslo namboni, ngundo ya newendemo ombulo ngu, yambo utolo kunowolo. Herodiyas nambonimbo yambo kunootoni, ngulo Herod gome ingowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ngundilo tetoni, ngulo Herodndo ngu bale buniyonggaku ngu kenolo, oni oni telo, ene mande solumimonggo hamoo oolengo ewolo. Ge komo nono oo gula nuno ewaku ngu, asa, no hamoo gunowanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ene ngundilo etoni, bale buniyonggaku enengo mande ingolo, nemimo oolelo, ngulo ingondudu yolo, ulo, ene mande gumi Herodno ewolo. Anangu, ge Yon tabango toongooya, koondo samayi gulano yeya, ombuya nunolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","10","Herodndo bale buniyonggakulo mande ingolo, newende ngu kowuli ulungga ingowolo. Ene kuli mande yanggango hamoo oolengo solumimonggo tewolo. Yo, oni enedodo oo newonggoku, ngu doongeyemo ewokulo, ngulo ene bale buniyongga ngulo mandeni ma yokowa. Ngundilo ngulo, ene me oni suleyelootoni, oololo, ya biyomimonggo Yon tabango toongoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Toongoolo, koondo samayi gulano Yon tabango yelo, yolo, ombulo, bale buniyonggaku inootoyi, enendo yolo, nemi inowolo. Herodiyas Yon tabango kenolo ngu, ene ingonduduno elo ingolo, nolo me oninggaku kuli kumootelo ingowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ariya, Yonlo sulena oni mande ngundilo ingolo ngu, asa, ene ombulo, Yon bingo yolo, salo melengoowonggori. Ngundilo telo ngu, oololo Yesusno ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesus ngu mandegaku ingolo, ene ngu endegaku yokolo, ene wanggo yolo, oni kini melako enesu nangge toongewolo. Ene oni simoo bale oowooyingga oolengo ngu ingolo, enengo ende yokolo, enebana keyolo oolouwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ene Yesus ko oololo, sono dabemimo mayelo, wanggo gosiyolo ngu, oni simoo bale oowooyingga oolengo oodoyi yeyowonggori. Ngulo ene nowoondoyi yunolo, enengo sayi nguya yomosiyelowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Suwootetoni, enengo sulena oniku eneno ombulo ewonggori. Nga melasina ngano oni kini, ngundilo ngulo, nalu kiniteteku nga. Mete ge oni simoo bale nga suleyelootooga sayi. Ngulo ene mete ende namoko namoko ngano salo, ngunonggo enengo oowali uliyowanggo. Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ene ngundilo etoyi, Yesusndo enengo mandeye ngu gumi ewolo. Ndawugalo ngulo, ene komo sawanggo? Yendo oowali yunoyi! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ngundilo etoni, sulena oni enebana mande gumi ewonggori. Noole ngano oowali oowooyingga kini. Ngano oomanongoyingo kandegula, iso elaya nangge moolelo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Etoyi, enendo mandeye gumi ewolo. Ngu yoya, ombuya nunoyilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ene oni simoo baleno elo, ye ombuya so sanganimo bibiteyi. Elo, Yesus ene ngu oomanongoyingo kandegulagaku, iso elayagaku nguya yolo, ene Sambono doongetelo, Anutno yemboongelo esetewolo. Enendo oomanongoyingoku oososowoolo, sulena oni kilalongo yunootoni, ngundo oni simoo bale yunowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Yunootoyi, oni bidodo oo netoyi, useye ndindi tewonggori. Ngundilo tetoyi, oowali gumi oodoni, enengo sulena oni ngu goobooyingolo, si kande elaya kegidembolo elaya (12) siliyowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Oni simoo oomanongoyingo newonggoku ngu, ngu oowooyingga oolengo ngu 5,000. Ene bale ko simooye ngu ma kandangeyelowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kootusina, Yesusndo enengo sulena onikuya elo, ye sodedo wanggo sanganimo ooleya, ye koleteya Galili sono koongeyingo anduloko uleleyi. Elo nondo oni simoo bale suleyelootoowe sawanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ene oni simoo bale suleyelootoni, satoyi ngu, asa, Yesus enesu nangge mela pulimo nguno, ene Anutno yemboongeweloyimbolo oolewolo. Ene suwootetoni, enesu nangge mela pulinggakuno oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Suwoono, Yesusndo pulimo yemboongetoni ngu, wanggo sono koongeyingo yowoko oodoni, doogo ulungga oolelo, ngundo wanggo wenggelenggeremowolo. Ngundilo tetoni, ene sono sanganiwoole wanggo woosoolo oolouweloyi, ko yanggango biyomi teloluwonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Sengewelo mela wendooketoni, ariya, Yesus ene Galili sono koongeyingo sanganiwoole kewoongolo, eneno oolouwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ngundilo ooloutoni, enengo sulena onikundo Yesus kenootoyi, sono sanganiwoole oolouwolo. Ene Yesus kenolo ngu, oomboolo gulado elo ingolo, ngulo ene ki manggalu ulungga telo ewolo. Eyi! Oomboologa nga! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ngundilo manggalu tetoyi ngu, sodedonangge, Yesusndo enedodo mande mandelo ewolo. Ye nowoondoye yanggango yeyi! Nondo nangge ombuteno. Ye ma sosolewelo! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Etoni, Pitando gumi ewolo. Oo Sembuli Ulungga, gedo nangge tetoni ngu, ariya, mete no nguya sono sanganiwoole geno oolouwano. Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ngundilo etoni, ene gumi ewolo. Yo, mete ombu. Yesus etoni, asa, Pita wanggo yokolo, sono koongeyingo sanganiwoole Yesusno oolouwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Oololo, ene doogo ulungga kenolo, sosolelo, damoni yelo, sono newendemo uweloyi telo, manggalu ulungga tewolo. Oo Sembuli Ulungga, ge hooloowenelo! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Etoni, sodedonangge, Yesusndo kandeyi Pitano yelo, dowoolo, woosoolo ewolo. Ge nowoondoge hamoo teyingo ngu bodaga nangge. Ge ndawugalo ingondudu elaya yoote? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ngundilo elo, enengo elayadodo wanggo sanganimo ooletoli ngu, sodedonangge, doogo kinitewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Doogo kinitetoni ngu, asa, enengo sulena onindo ngundilo kenolo, soliyokolo, boodoo oondookelo, penggootelo ewonggori. Hamoo oolengo! Ge Anutlo Nangoni Kilalongo! Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ngu naluno nguno, ene Galili sono koongeyingonggaku usowoolo, mela oowooyi Genesaret, ngu gidesina mayelo, wanggo gosiyowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","36","Ene wanggo yokootoyi, sodedonangge, oni simoo bale Yesus kenolo, ene ingolo, ende gulasina gulasina kendutelo, salo, ene sayi oni yoyolo, Yesus oluwoku, nguno mayelo, Yesusno solengoyelo, sumoo sumoo ewonggori. Sayi onindo gengo nenggulo sosowoomo kandedibiye yetoyi ngu, ge mete enengo sayiye bidodo yeyi kinitewa, bine? Ngundilo etoyi, sayi onikundo Yesuslo nengguloni sosowoomo kandedibiye yetoyi ngu, asa, enengo sayi bidodo kinitewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ngu naluno, Moseslo mamana mande sobowooyingo oni, oowooyi Parisi, ko, mamana mandelo etuyeloyingo oni gidalega nguya, ngundo Yerusalemnonggo ombulo, Yesusya goobooyingolo, sumoo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Ndawugalo, gengo sulena oni kandeye ma sonowoolo, oo dowoolo netenggo? Ene noolengo osisambalo damoni ngu ma keyolo yombuliyootenggo. Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","4","Ene ngundilo sumoo etoyi, Yesus enebana enedodo sumoo gula gumi ewolo. Ye osisambaye mamana mande ngulo damoni keyolo, ko ndawugalo Anutlo mamana mande hamoo ngu, ye ma keyootenggo? Ye kuli Anutlo mamana mandeno Anutndo ewoku, ngu ingootenggolo ewolo. Ene ngundilo ewolo. Oni ene komo eweyi nemimbolo mandeyali gome keyoni. Oni gula ewenemi kootu yunolo, mande biyomi ewaku ngu, asa, ngu oningga ngu, ene komo kumoowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Anutndo ngundilo ewoku, ene ye ngu ma keyolo, yengo damoniye nangge keyootenggo. Oni gula bobeye ene mete ewenemi hoolooweyeloweloyi moolemu, ene ngu ma hoolooweyelowelo ingowa. Ngundilo ingolo, ene ewenemimo ewolo. Gowugowulongo! No digi kuli hoolooweyelowelo ewonoku, ngu yolo, no kuli Anut inowolo. Eneno inolo, ngulo no mete yali ma hoolooweyelowanolo ewolo. Ngundilo elo ngu, ene Anutlo mamana mande kootu inolo, enengo ingondudu nangge keyootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ye mebuye sangala oni! Anutlo ingondudu eyingo oni, Ayisaya, ngundo, ye ngundilo oni nguno mande nenengo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Nga oni simoo bale nga manggoyebo nangge oowoone bingami etenggo. Ene nowoondoye ngu no ma nunootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ene kingo nono yambo mande tetenggo. Ngundilo ngulo, oni enengo mamana mande nangge etuyelolo, nolo mamana mande hamoomu ma etuyelootenggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ariya, Yesusndo oni simoo bale negoyelootoni, eneno ombutoyi ewolo. Ye ingoya, gome ingondudu teyi! ");
INSERT INTO rwo_karo_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Oo gula oni goweyi sanganimo oolooteku, ngundo newendesina ulo, ngundo oni yeni, ma biyomi yewa. Kini, damoni biyomi oni newendemo oolooteku, ngundo endesina ooleteku, ngundo oni yeni, biyomi yewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ngu naluno nguno, Yesuslo sulena onindo Yesusno ombulo ewonggori. Ge Parisi onindo gengo mandege ngu ingolo, geya nowoondoye biyomi yetenggoku, ge ngu ingoote, bine? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","14","Ene ngundilo etoyi, Yesusndo mande gumi ewolo. Ngundilo oni, ngulo gome ma ingowelo. Yo, hamoo, ene oni doongeyi kilingo ngundilo. Oni doongeyi kilingo gulado, ko, oni doongeyi kilingo gula oole etungolo ngu, asa, enengo elayadodo meleno solewali. Hamoo oolengo, no yeno eteno. Awane Sambo endemo oolooteku, ngundo enengo kono oo imiwolo. Oo kono kingo ooleteku, ngu ulidodo gumoowa. Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ngundilo etoni, Pita mande gumi ewolo. Ngu mande yamonggawongga ngulo damoni ndatelo? Ngu nooleno wesiyoya etooga ingowatolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ngundilo etoni, Yesusndo eneno mande sumoo ewolo. Ye nguya ingonduduye kini, bine? ");
INSERT INTO rwo_karo_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Oo bidodo oni endesina oolooteku, ngundo oni useye newendemo ulo, ngunonggo oolelo toongete. Ye ngundilo kuli ingootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ene damoni biyomi oni newendemo oolooteku, ngunonggo endesina ooleteku, ngundo oni yeni, sugabododo tete. ");
INSERT INTO rwo_karo_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Damoni biyomi oni newendemo oolooteku, ngunonggo ootookoolo, endesina oolete. Ene ngandilo ingondudu biyomi; oni uleyi kumooweloyi; elambalisa toongooweloyi; oni bale gidalega yakakayi yodowoolo yombuliyelolo, yakaka teweloyi; mande ebe ganagana, ko oniya mande kootuyisina yumoo inolo etenggoku, ngu damoni biyomi bidodo nowoondoye newendemonggo oolelo, endesina oolete. ");
INSERT INTO rwo_karo_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ngundilo damoni, ngundo oni yeni, sugabododo tetenggo. Ene oo neweloyi naluno, utakalo, kandeyi ma sonowoolo ngu, ngundo oni yeni, sugabododo ma tewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ngu naluno nguno, Yesus ootookoolo, ngu endega ngu yokolo, Tayiya ko Sayidon ende elayagano nguno oolouwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Nguno oololo, sodedonangge, bale Kenan melakonggo ngu melasina oolooteku, ngu Yesus kenolo, solengoyelo, sumoo sumoo ewolo. Oo Sembuli Ulungga, ge Dewit osiyi! Ge nolo nowoondoyi te! Mboolo biyomimbo nolo nambone yombuliyowolo. Ngulo ge mete hooloowenelo! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ngundilo etoni, Yesusndo nenetelo, mande gumi eneno ma ewolo. Ngundilo tetoni, enengo sulena onikundo eneno ombulo ewonggori. Nga balega keyoyelolo, meno elo ombuteku nga, mete gedo etooga oolouni! Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ene mande gumi ewolo. Anutndo no sulenelootoni, Iserello Sipsip, enengo oole yokoyingo, ngu hoolooweyelowelo ombuwonolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ene ngundilo etoni, ene balega ngu enengo mande ingolo ombulo, Yesus keyi damonimo boodoo oondookelo ewolo. Oo Sembuli Sembunaye, ge no hooloowenelo! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ngundilo etoni, ngulo ngu, Yesusndo mande gumi ngandilo ewolo. Noole simooyembolo oowali ngu yolo, se ma yunowato. Ngu nenengo kinilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Balega enengo mandeni ngu ingolo, gumi ewolo. Oo Sembuli, gedo hamoo ete. Ene sebo ngu oo neweloyi yaba newendemo simooyembolo oo sosolango, ngu netenggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yesus enengo mandeni ngu ingolo, enebana mande gumi ewonggori. Bale, gengo nowoondoge hamoo tewoku, ngu ulungga. Ngulo ngu, oo sumoo ewoku ngu, ataga engge tunootetelo ewonggori. Ngundilo etoni, ngu naluno nangge, namboni mete tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ngu naluno, Yesus ene ngu endegaku yokolo, Galili sono koongeyingo tanggeyiwoole oolouwolo. Oololo, ene puli sanganimo oolelo, nguno bibitewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Oni simoo bale oowooyingga nguno mayelo goobooyingo. Ene oni keye biyomimu; doongeye kilingomu; keyi biyomi yeyingomu; manggoye gosiyoyingomu; ko, sayi oni gidalega nguya yoyolo, Yesus keyi namoko yoyetoyi, enendo yomosiyelowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ngundilo ngulo, oni simoo bale ingondudu ulungga tewonggori. Ndawugalo ngulo, ene oni manggoye gosiyoyingoku mande etoyi, oni keyi biyomingga ngu mete telo, mela wongoolo endeyootoyi, doongeyi kilingoku doongetewonggori. Ngundilo ngulo, ene Iserello Anut ngu oowooyi bingami okoowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesusndo enengo sulena oniku negoyelootoni, eneno ombutoyi ewolo. No nga oni simoo bale ngalo nowoondoyi yunooteno. Nalu kabusa noya oluwootoku, ene oowaliye moole nguya kini. Ene oodoolo kumootoyi, suleyelootoowe, enengo yano sawelo salo ngu, asa, ene oolekono doongeye toongootoni, mela wongosogulumoolo yulewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Enengo sulena onikundo enengo mande ingolo, mande gumi ewonggori. Nga mela gumisina ngano oni kini, ngulo noole oowali ndanonggo yolo, oni simoo bale logono yunootooye newanggo? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Sumoo ngundilo etoyi, Yesusndo sumoo gula yunowolo. Ye oomanongoyingo ndatelo? Etoni, onikundo mande gumi ewonggori. Kandegula gidembolo elaya (7), ko, iso bobodi gidegalo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ariya, Yesusndo simoo baleya ewolo. Melakono bibiteyilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ariya, Yesus ngu oomanongoyingo, iso nguya yolo, Anutno yemboongelo yokolo ngu, oososowoolo, enengo sulena oni yunowolo. Yunootoni, ngundo bayetelo, simoo bale yunowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Yunootoyi, oo nelo mete tetoyi, oo sosolango oodoni, ngu goboolo, si kandegula gidembolo elaya (7) siliyootoyi hangewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Simoo oo newonggoku, ngu oowooyingga oolengo, ngu 4,000. Ene bale ko simooye nguya ma kandangeyelowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ngundilo telo ngu, Yesusndo oni simoo bale suleyelootoni, enengo endemo endemo sawonggori. Satoyi, ngu naluno, Yesus enengo sulena onidodo wanggo sanganimo oolelo, Magadan melasina nguno sawonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Moseslo mamana mande sobowooyingo oni, oowooyi Parisi, ko kumoolo ko ma ootookoowa elo ingoyingo oni, oowooyi Sadusi, ngundo Yesus tewoongolo ewonggori. Ge Sambononggo oo damoni sungo oolengo gula onindo ma teweloyim tetooga, oni simoo baledo kenowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","3","Ngundilo ngulo, Yesus mande gumi ewolo. Ye Sambono doongetelo, enengo sunggi kenolo, gome ingootenggo. Suwootetoni, sambo seleyingo yelo, kumu yetoni, kenolo ngu, asa, ye ingootenggo. Yangeni nalu gome sa tewa. Ngundi, suwoononggo ye puli sanganimo doongetelo, goboole kenolo, gululu nguya ingolo ngu, asa, ye ingootenggo. Sono ombuwa, ingolo ewanggo. Yo, ye sambo melalo sunggi gome ingolo, wilikolo ingootenggoku, ene ye ataga damoni keda yeno tunooteteku, ye gome ma wilikolo ingootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ye simoo bale biyomi nowoondoye hamoo kini! Ye bosebalese damoni biyomi tetenggoku oni! Ye oo damoni sungo oolengo gula onindo ma teweloyim, ngu kenowelo ngu meno etenggo. Ene no oo damoni sungo oolengo gula yeno ma tewano. Kini, ye Yonalo oo damoni sungo oolengo gula onindo ma teweloyim, ngu kuli ingowonggo. Yesus ngundilo elo, ene yoyokolo toongewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Nalu gulano, sulena oniku sono koongeyingo usowoolo, sakiko oolouyingomu, ene oomanongoyingo kapengo yelo, ma yolo oolouwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesusndo mande yunolo ewolo. Ye ingondale teyi! Parisi oni, ko, Sadusi oni ngulo oomanongoyingo yeni, koongeweloyi Yis, ngulo gome doongeteyi! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ene ngundilo etoni, ngulo sulena onikundo enengo nanggelo, ingolo ewonggori. Noole oomanongoyingo ma yoyingo, ngulo ngu, ene ngundilo etelo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ene Yesus ngu enengo mande ingolo, ngulo enendo ewolo. Ye nowoondoye hamoo teyingo, ngu bodaga nangge. Ndatelo ngulo, yengo nangge mande ngundilo etenggo? Noole oomanongoyingo kinilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ye kuli ingowonggoku, ko ataga ye kapengo yetenggo. Nondo kuli oni oowooyingga oolengo (5,000 oni) oomanongoyingo kandegula yolo, yemboongelo, oososowoolo, bayetelo yunowonggori. Yunootoyi, nelo, mete tetoyi, gumi oodoni, ye oo sosolango gumi si ndatelo siliyootoyi hangeyingo? ");
INSERT INTO rwo_karo_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ngundilo nangge, ye nga mandega nga nguya utakatenggo. Kuli nondo oni oowooyingga oolengo (4,000 oni) oomanongoyingo kandegula gidembolo elaya (7) yolo, yemboongelo, oososowoolo, bayetelo yunowonggori. Yunootoyi, nelo, mete tetoyi, gumi oodoni, ye oo sosolango gumi si ndatelo hangewonggo? ");
INSERT INTO rwo_karo_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ndawugalo ngulo, ye gome ma ingootenggoku, nondo oomanongoyingombolo ma eteno. Kini, ye Parisi oni Sadusi oni ngulo oomanongoyingo yeni koongeweloyi, Yis, ngulo ingondale teyi! No ngulo eteno. ");
INSERT INTO rwo_karo_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ene ngundilo etoni, ariya, ngu naluno, ene ingootenggo. Yesus oomanongoyingo yeni koongeweloyi, oo oowooyi Yis, ngulo ingondale teyilo ma ewolo. Kini, ene Parisi, ko, Sadusi onilo mamana mande biyomi etuyeloyingo, ngulo ingondale teyi, ngulo etelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesus enengo sulena oniku ootookoolo, ende gula oowooyi Sisariya Pilipayi ngu namoko sawonggori. Ngu naluno, salo, ooleko nguno ene sulena oni sumoo yunolo ewonggori. Oni simoo baledo no ngu Anut Nangoni Oni Kilalongo, noya ndawu oningga etenggo? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ngundilo sumoo etoni, enebana mande gumi ewonggori. Oni gidalegado geya ngandilo etenggo. Ge Sonoyeloyingo Oni Yon; ngundi, Ilayiya; ngundi, Yeremayiya; ngundi Anutlo ingondudu eyingo oni gidalega, elo, geya ngundilo etenggolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ngundilo etoyi ngu, asa, Yesus enebana sumoo yunowolo. Ene yendo ngu noya ndawu oningga etenggo? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Etoni, Sayimon Pitando mande gumi ewolo. Ge Kristus, Anutndo noole yoyowelo sunggi yewo oni. Anutndo ataga sugi sugi keda oolooteku, ge ngulo nangonilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ngundilo etoni ngu, Yesusndo mande gumi ewolo. Sayimon, Yonalo nangoni, ngu gome oolengo, Anut enengombo ngu ingonduduga gunoote. Melako oni gulado, ngu mandega ma etunggelowolo. Kini, Awane Sambo endemonggo oolooteku, ngundo nga ooga etunggelowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Pita, no geya eteno. Pita, gengo nowoondoge hamoo teyingo ngu digi yanggango ndoni ngundilo tete. Ngulo ngu, Anutndo ge yanggango gunootoni, nguno ge mete oni simoo bale oowooyingga goobooyelolo, nowoondoyemo hamoo teyingo yanggango yunolo, enengo soboyeloyingo awaye oluwa. Ngulo ngu, Setanlo yanggangoni, nolo oni ngu Anutlo pawa newendemo oolootenggoku ngu, ngundo ma keyoyelowa. Ene ereremo kini. ");
INSERT INTO rwo_karo_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ene nondo ge logogelowonoku ngu, nolo mande damonine nguno gedo nenengo oni simoo bale ngu gome etuyelolo soboyelowa. Yo, nondo enengo Sambo endega ngulo yamako ngu goosoolo, hoolooweyeloweloyi ngulo elo, Ki gunooteno. Yo, nondo Sambo endemo oolootenoku, ngunonggo ge yanggangone gunootoowe, ge oo gula melako ngano ukingowaku ngu, nondo Sambono nguya ukingowano. Ngundilo nangge, ge oo gula melako ngano yokowaku ngu, nondo Sambono nguya yokowanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Mande ngundilo elo ngu, asa, Yesusndo enengo sulena oniya mande yanggango yunolo ewolo. Ye oni gulano noya Kristuslo, ma ewelo, ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ngu naluno Yesus damoni yelo, enengo sulena oniku mande nenengo oo tunooteweloyi ngu elo yunowolo. No kootusina, Yerusalem endemo ooloutoowe ngu, Yuda onilo tabango oniku, Anutlo woolo yeyingo oni kundingiyi sobosobo oniku, ko, mamana mande etuyeloyingo oni, ngundo nodowoolo, ogingoyingo nunolo, nuleyi kumoowano. Kumoolo ngu, nalu kabusagomo, no mele yokolo, ko ootookoolo, keda oluwano. ");
INSERT INTO rwo_karo_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pitando Yesus yolo, sosina oololo, damoni yelo, mamanangolo ewolo. Oo Sembuli Ulungga, ge ngundilo ma ewelo! Ngu ooga geno ma tunootewa! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pita mande ngundilo etoni, Yesus ingolo, yowoolengolo, kenolo, mamanangolo ewolo. Pita, gengo ingonduduge ewoku, ngu Setannonggo mayeteku ngu! Ngu Anutlo ingondudunonggo kini. Yo, ge onilo ingondudu nangge keyolo, nolo ko Anutndo no sunggi yewoku, ngu gedo ma hoolooweneloote. Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ngundilo elo ngu, Yesusndo enengo sulena oni negoyelootoni, mayelo, gooboowootoyi, mande yunolo ewolo. Oni gula no kenelowelo ngu, ene komo nolo nowoondoyemo hamoo tetoni ngu, nguno ene mete enengo ingonduduni bidodo yokolo, kowuli ene inootenggoku ngu, de mombi ngundilo koolowooya, no keneloya endeyoni. ");
INSERT INTO rwo_karo_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Oni gula enengo ingondudu yanggangoni gome dowoolo, goweyi sugi oluweloyi ingooteku ngu, asa, ngu oningga ngu, enengo goweyi gaboyi, Anut doongeyimo, ngu hamoo oolengo oonatewa. Ngundilo nangge, oni gula enengo ingonduduni goweyi gaboyi bidodo no nunolo ngu, asa, enengo goweyi gaboyi, kootusina, Sambo endemo sugi sugi keda oluwa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Oni gula mela ngalo oo bidodo yomukolo, oode kumoowaku ngu, ngu ndawu oogado ene mete hooloowewa? Ngu oningga ngu, ene ndawugado enengo goweyi yanggangoni keda oluweloyi, ngu uliyolo yowa? Ene ereremo kini. ");
INSERT INTO rwo_karo_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ariya, no Anut Nangoni Oni Kilalongo oode, no Awanembolo dulidalinidodo enengo Sambono Engel oni nguya ombuwato. Ngu naluno, oni melako damoni tewonggoku, ngulo gumi yunowano. ");
INSERT INTO rwo_karo_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","No hamoo oolengo yeno eteno. Oni gidalega nga oolootenggoku nga, ene ma kumooyingomo, ngu koletelo, ene no Anut Nangoni Oni Kilalongo, nondo nalu nolo oni simoo bale soboyelooteku, ngudodo ombutoni ngu kenowanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Kootusina, nalu kandegula gidembolo gulanangge yokolo, Yesusndo Pita, Yems, ko, koneyo Yon ngu oni kabusangga ngu yoyolo, mela puli pelungga ndandayingo awuno oolengonggano oolewonggori. Nguno enesu nangge oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ngu naluno nguno, Yesus moondeyi ngu oni kabusagaku doongeyemo yowoolengowolo. Yowoolengolo, Yesus enesu guladilo tunootewolo. Yo, enengo omukumundoongo solu ngundilo tunootetoni, ko, towikumbani nguya solu ngundilo yowali namboyi oolengo tunootewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ilayiya, Mosesya, Sambono kuli oode, ngunonggo ombulo, Yesus tanggeyimo tunootewoli. Tunootelo, Yesusya mande etoyi, sulena oni kabusagakundo yeyowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pitando ngundilo kenolo, ene soliyokolo, Yesusno ngandilo ewolo. Oo Sembuli Ulungga, noole ngano oluweloyi ngu gome. Gedo ngundilo ingootoyi ngu, asa, nondo mete ya tookoododo kabusa yewano. Gula gengo, gula Moseslo, gula Ilayiyalo yewano. Pita elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ene mande eloodoni, goboole gula solu ngundilo tunootelo, ngundo doobeyelowolo. Anutndo ngu goboole kewoolokononggo mande ewolo. Ngu nenengo nangone mesalango. No nowoondone ngulo gome oolengo ingooteno. Ye ngulo mandeni gome ingoyi! Anutndo mande ngundilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ariya, sulena oni oo ngundilo ingolo ngu, ene soliyokolo, sosoleyingo ulungga telo, ngulo ene omukumundooyesinanggo melako solewonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ene ngundilo tetoyi ngu, asa, Yesus tanggeyemo ombulo, ikakoyelolo enendo ewolo. Ye ootookooyi! Ye ma sosolewelo! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Asa, ene mande ngundilo ingolo, doongetelo, Yesus enesu nangge eneno oodoni kenowonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ngu naluno nguno, Yesusndo enengo sulena onikuya mela pulinggaku yokolo, yade yade ooleko utoyi, Yesusndo mande yanggango yunolo ewolo. Ye awuno oo kenowonggoku, ngu ataga nga nalunggano ngano, oni gulano ma ewelo. Kini, kootusina, no Anutlo Nangoni Oni Kilalongo mele yokolo, ko ootookootoowegago, ariya, ngu nalunggano nguno, ye mete yootunoya eyi. Yesusndo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ene ngundilo etoni, Yesuslo sulena onikundo Yesus sumoo inowonggo. Anut mamana mande etuyeloyingo oni, ngundo ngandilo ewonggo. Anutlo ingondudu eyingo oni, Ilayiya, ngundo koletelo ko ombutonigo, ge kootu ko ootookoowalo ewolo. Ndatelo ngulo, ngundilo etenggo? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","12","Ene ngundilo sumoo etoyi, Yesusndo mande gumi elo ewolo. Ngu hamoo, Ilayiya ombulogo oo bidodo yomosiyowa. Ngulo, nondo yeno hamoo eteno. Ilayiya kuli ombuwoku, ngu oni watayi kini. Kini, oni enengo damoni oowooyingga ene nangge teyinowonggo. Ngundilo nangge, no Anut Nangoni Oni Kilalongo, nguya ngundilo ogingoyingo nunowanggo. Ene nolo ko nenengo nguya, ene watayi kini. Yesusndo ngundilo elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Yesus oo ngundilo etoni ngu, enengo sulena onindo ingolo, Sonoyeloyingo Oni, Yonya eteku ngu elo ingowonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","15","Ene puli yokolo, ombutoyi, ngu naluno, oni simoo bale oowooyingga oolengo oodoyi, oni gula ombulo, Yesusno boodoo oondookelo, penggootelo ewolo. Oo Sembuli Ulungga, ge no nangonengga ngulo nowoondoyi te. Ene komo doongeyi ngganggangelo, sagaga telo, mboolomboolo telo, gaboyi kumoololoote. Yo, nalu bidodo ene nombono, ko, sono nguya soleloloote. ");
INSERT INTO rwo_karo_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ngulo ngu, nondo ene yolo, gengo sulena onino ngu keyoyi, etoowe, ene ngu mboologa ngu andangeweloyi nguya, ereremo kini. Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesusndo enengo mande ingolo, ngulo ene yuka oolongoolo, mande gumi ewolo. Ye nowoondoye hamoo teyingo ngu yanggango kini, ko, ye nowoondoye nenengo nguya kini! No yeya nalu pulingga oodoowe, nalu ndatelo oodego, no yengo nowoondoyi tewano? Ariya, ye simooyengga ngu yoya, nono ngano ombuyi! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Asa, Yesusndo ngu yuka biyominggaku kenolo, mamanangolo, etoni ngu, simoo kosiyinggaku ngu yokolo toongetoni, ngu naluno nangge, ngu simoo kosiyigaku mete tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ene ngundilo tetoni, ariya, sulena onikundo nangge ombulo, Yesus yolo, sosina oololo, sumoo inolo ewonggo. Ndatelo ngulo, noole ngu yuka biyomingga ngu andangeweloyi, ngu ereremo kini? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ene ngundilo sumoo etoyi, asa, enebana mande gumi ewonggori. Ye ngu ooga ngu mete ma yomosiyoweloyi, ndawugalo ngulo, yengo nowoondoye hamoo teyingo, ngu bodaga nangge. Nondo yeno hamoo eteno. Mastet yuwooyi ngu puka yuwooyi ngundilo. Yengo nowoondoye hamoo teyingo ngu Mastet yuwooyi ngundilo tetoningga ngu, asa, ye mete nga pulingga nga etoyiga, nga musiyongga yokoya, musiyo gula etoyiga, ene nguno oololo oluwa. Ngundilo nangge, nolo yanggangonemo ngu ko telo ngu, ye mete oo bidodo temukowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ariya, ye ngundilo yuka biyomi oweyeloweloyi damoningga ngu, ye amana komo yanggango yemboongeya, oowali loogu telo, asa, nolo yanggangonemo ye mete yuka biyomi ngu andangewanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ngu naluno nguno, ene Galili melako oololo, Yesusndo enengo sulena oniku mande yanggango yunolo ewolo. Nalu bodagano, no Anut Nangoni Oni Kilalongo, onindo nodowoolo, oni sungo kandeyemo noyewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ene no nuleyi kumootoyi ngu, no sa kabusagomo mele yokolo, ko keda ootookoowano. Ene ngundilo etoni ngu, enengo sulena oni ngu ingolo, nowoondoye kowuli ulungga oolengo ingowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesusndo enengo sulena onidodo Kaperniyam endemo tunootewonggori. Ngu naluno, Yuda goobooyingo yano bobeye yoweloyi oni, Pitano ombulo, sumoo inolo ewolo. Yengo etuyeloyingo oni nguya bobeye yeloote, bine? Sumoo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ene ngundilo sumoo etoni, Pitando mande gumi ewolo. Yo, elo ngu, yano uwolo. Utoni, asa, koletelo Yesusndo eneno sumoo ewolo. Sayimon, ge ndatelo ingoote? Bobeye yoweloyi naluno, melako oni sobosobo koleteyingo ululu mela bidodomo, ngulo damoni ndatelo? Ene mela sembuguliye oni, ngunonggo bobeye yootenggo, bine; ngundi, oni sowe gidaleganonggo bobeye yootenggo, bine? Sumoo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita enengo mande ingolo, gumi ewolo. Oni sowe gidaleganonggo nangge ewolo. Ngundilo etoni, Yesusndo mande gumi ewolo. Asa, ngundilo eteku, ngulo mela sembuguliye digi beye yoweloyi koyi ma tewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ene noole ngundilo ma tetooye ngu, ene nooledodo sanggili tewanggo. Ngundilo ngulo, ge sono koongeyingomo uya, isolo si oolongoo. Oolongooya, iso amana gula yoya, manggowo goosooya ngu, bobeye manggowoomo oolooteku, ngu kenolo, yowaku ngu! Ngu bobeyega yowoku ngu, noolengo geyambolo ene yunolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ngu naluno, sulena oni Yesusno ombulo, sumoo ewonggo. Anutlo endega enengo oni simoo bale soboyelooteku, nguno oni onendo ngu tabango ulungga? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","3","Yesus ngundilo ingolo, ene simooyengga negongootoni, ombulo, kewooloyemo dikawolo. Dikatoni, Yesusndo ewolo. No yeno hamoo eteno. Ye nowoondoye yowoolengoya, hamoo teya, simooyembolo damoni ngundilo teyi. Ye ngundilo ma telo ngu, asa, ye mete Anutlo endega enengo oni simoo bale soboyelooteku, nguno ma uwanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ngundilo nangge, oni gula ye kewooloyemo nguno enengo oowooyi bingami elo ma okootoni, simooye bodagado teteku, ngundilo tewaku ngu, asa, hamoo oolengo, ngu oningga ngu, Anutlo endega enengo oni simoo bale soboyelooteku nguno, ene oni gidalega oowooye ngu dagayelolo, ulungga tewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Oni ene no oowoonembolo ingondudu telo, ene oni simooye bodaga ngandilo yolo, hooloowewaku ngu, asa, ene no nguya ngundilo hoolooweneloote. Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Yesusndo mande gula ewolo. Oni gulado simooye nga nolo nowoondoyemo hamoo ingolo oolootenggoku, nga gula yolo, nolo nowoondoye hamoo ingootenggoku, ngu yombuliyolo ngu, enengombo damoni biyomi tewoku, ngulo gumi ogingoyingo ulungga oolengo yowa. Yo, ngu oningga ngu enengombo biyomi ngundilo tewoku, ngu ngandilo: oni ngu digi ulungga ngu yolo, ngundo bungeyimo gosiyolo yolo, sono koongeyingo ulungga ngu kewooloko oolongoowonggori. Oolongootoyi, oni sono newendemo ulo kumooyingo, ngu ngandilo. Yo, ene oni buniyo newende hamoo teyingo ngu yombuliyowoku, ngulo gumi ulungga oolengo yowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Mela bidodomo, oo oowooyingga oni nowoondoye hamoo teyingo ngu woosootoyi yokootenggo. Nalu oowooyingga, oo ngundilo biyomi ngu tunooteloluwa. Ene oni oni yooge, onindo oni gidalega yowoosootoyi, mbumbuwa tetenggoku, ngulo ngu oningga ngu, ngu uliyi biyomi ulungga yowa. Yo, no ngundilo oni biyomi ngulo nowoondoyi teteno! ");
INSERT INTO rwo_karo_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ngulo ngu, ye keyembo ngundi kandeyebo yoyeni, mbumbuwa gula teya ngu, asa, ye mete ngu toongooya, andangeya, oolongooyiga uni. Ngundilo nangge, kandeye gulanangge, ngundi, keye gulanangge oodoni ngu, ngundo mete keda oluweloyi gome ngu yowa. Kinitetoni ngu, ye kandeye ela elaya, ngundi, keye ela elaya oodoni ngu, ngundo yoyolo, ende biyomi de nombo ma kumooweloyi (Hel) nguno oolongooyelowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ngundilo nangge, doongeyembo yoyeni, mbumbuwa gula tetoyiga ngu, ye mete ngu doongeyengga ngu yokoya, oolongooyiga uni. Ye doongeye gulanangge, ngu ye mete Anutya keda sugi sugi oluweloyi, ngu yowanggo. Kinitetoni ngu, ye doongeye ela elaya oodoni ngu, ngundo ye yoyolo, ende biyomi de nombo sugi sugi ma kumooweloyi, nguno oolongooyelootoyi uwanggo. Yesusndo mande ngundilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Yesus mande gula ewolo. Ye ingondale teyi! Ye simooye bobodi nono nowoondoyemo gome ingootenggoku, ngu ma kootu yunowelo. Kini, no yeno hamoo eteno. Sambono Anutlo oni, ngundo simooye bobodi gome soboyelolo, Awane Sambo endemo oolootenggoku, ngu tanggeyimo ootoolo, Anutlo omukumundoongo kenololootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ndatelo ngulo, no Anut Nangoni Oni Kilalongo, ngano ombulo, oni enengo oole yokoyingo, ngu ko yoyowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ye ndatelo ingonduduga ingootenggo? Oni gulado Sipsip onibi kandegula (100) moolemu, Sipsip gula doboogulingo yoyokolo, enengo oole nenengo yokowolo. Ngundilo yokowaku ngu, asa, ngu oninggaku Sipsip wata ulunggaku pulimo oolootenggoku, ngu yoyokolo, ene toongewokunggaku erewelo toongewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Yo, no yeno hamoo eteno. Ngu Sipsip sobosobo oningga, ngundo enengo Sipsip toongeyingongga ngu kenolo ngu, asa, ene oni oni ulungga tewa. Yo, enengo oni oni tewaku, ngundo Sipsip oowooyingga pulimo oluwonggoku, ngulo oni oni teyingo, ngu dagate. ");
INSERT INTO rwo_karo_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Sipsip sobosobo oningga, ngundo enengo Sipsip gula yokootoni, toongewelo ma ingooteku, ngundilo nangge, Awangge Sambo endemo oolooteku, ngundo nguya, enengo simooye ngu gula yokowelo ma ingootelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yesus mande gula ewolo. Dobooge gulado geya damoni biyomi tetoningga ngu, ariya, mete yalisu nangge bibiteya, enengo damoni biyomi, ngu yeyiga tunooteni. Ngundilo tetoni, ene gengo mande ingootoni ngu, ariya, ge dobooge ko yowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ene oni damoni biyomi tewoku, ngu oningga ngu mande ma ingootoningga ngu, ariya, mete ge oni gula, ngundi, oni elaya yoyoya, geya oolouya, ngu oni damoni biyomi tewoku, ngu yomosiyoyi. Ngu oni gula ngundi oni elaya, gedodo ngundo yalingo mande ngu ingolo wilikowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ene oni damoni biyomi tewokungga, ngu mande ma ingootoningga ngu, asa, mete Kristen oni gooboono onino ooloutoyi gooboongoolo, mande telo yomosiyowanggo. Nguno oni damoni biyomi tewokungga ngu, ene enengo mande ma ingolo keyootoni ngu, ariya, ngu oningga ngu, ye nowoondoye hamoo teyingo gidalesina ene ma gooboongoolo oluwanggo. Ngu mbumbuwa oningga ngu, Anut hamoo kootu inooteku oni ngundilo, ngundi Takis bobeye yoweloyi oni ngu ngundilo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","No yeno hamoo eteno. Ye oo bidodo melako ngano ukingowanggoku ngu, Anut Sambo endemo oolooteku, ngundo nguya ukingowa. Ngundilo nangge, ye oo bidodo melako ngano yokowanggoku ngu, Anutndo nguya Sambo endemo nguya yokowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","20","Yo, no yeno ko eteno. Oni elaya melako ngano oo yowelo nowoondoyali gulanangge yelo, yemboongewaliku ngu, ariya, Awane Sambo endemo oolooteku, ngundo yunowa. Ngundilo nangge, oni elaya ngundi kabusa musiyo gulano no oowoonemo gooboongoowanggoku ngu, ariya, no ene kewooloyemo oluwanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ngu naluno, Pita Yesusno tunootelo ewolo. Oo Sembuli Ulungga, nalu ndatelo, doboonembo nono damoni biyomi tetoni, nondo enengo damoni biyomi ngu andangewano? Tambu kandegula gidembolo elaya, bine? Ene ngundilo sumoo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Sumoo etoni, Yesusndo eneno mande gumi ngandilo ewolo. No geno tambu kandegula gidembolo elaya nanggega, ngulo ma ewolo. Kini, nalu bidodomo, ye komo oni gidalegado yeno mbumbuwa tetenggoku, ngu andangeyunoyi. ");
INSERT INTO rwo_karo_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Anut Oo Bidodo Sembuli Sembunaye, ngundo enengo endega oni simoo bale soboyelooteku, ngu ngandilo. Ngu melako sobosobo oni koleteyingo enengo ko oniya wetiye ngu andangelo yomosiyowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Oni ulungga, ngundo damoni yelo, enengo wetiye andangewelo, etoni, ngu ko oni gula yolo, eneno ombuwolo. Ko oningga enengo wetini ngu bobeye kande elaya Miliyon (10,000,000 Kina) ngundilo weti yowolo. Ngundilo ngulo, oni ulunggado ko oningga nguya etoni, weti ko wendangelo inowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ene enengo weti ulungga oolengo, oni ulungga nguno, ene mete ma andangewa. Ene ereremo kini. Ngulo ngu, ngu oni sobosobo ulungga, ngundo enengo baleyi simoongo enedodo suleyelootoni, ya biyomimo oodego, enengo weti ngu mete bidodo andangewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Oni ulunggado ngundilo etoni ngu, asa, ko oni wetidodoga enengo mande ingolo, ngulo ene sosolelo, oni ulungga ngu keyi damonimo boodoo oondookelo, penggootelo, sumoo sumoo elo telo, ewolo. Oo oni ulungga, ge nolo nowoondoyi teya, sobonelootooga, nondo ngu weti bidodo yokowano! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ngundilo etoni ngu, Oo Sembuli ulungga ngulo nowoondoyi telo, oninggaku yokolo, enengo weti nguya yokoyinowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Yo, enengo oni ulunggado enengo weti bidodo andangetoni, ene ngu ko oninggaku endesina oolelo, enengo ko goboologaku kenoyingomu ngu, eneno weti bobeye kande elaya (10 Kina) ngu moole. Ngundo ngu, ko oninggakundo sanggili telo, sodedonangge dobooyi bungeyi yanggango dowoolo, manggalu telo ewolo. Ge weti bidodo ataga wendangeya nuno! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ngundilo etoni ngu, oninggaku boodoo oondookelo, solengoyelo, sumoo sumoo ewolo. Ge nolo ingoya, sobonelootooga, nalu bodagano, gengo weti bidodo ngu andangegunowanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ngundilo etoni, ene ngu oningga ngulo mandeni ma ingowolo. Ngulo ngu, oni ulungga ngundo etoni, kumba ootuwoo onindo ene dowoolo, ya biyomimo yetoyi, nguno ootoolo, ngunonggo oo ngu wendangenilo yewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ariya, ko oni goboolokundo enengo damoni biyomi kenolo, nowoondoye kowuli hamoo ingolo, ngulo ene enengo sobosobogakuno oololo, mande mande bidodo oningga ngundo tewoku, ngu emukowonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","33","Sobosobogakundo mande ngu ingolo, ene ngulo sanggili ulungga telo, ko oninggaku negongootoni, ombutoni ewolo. Ge ko oni biyomi oolengo! Koletelo oolengo, ge nono sendolo, sumoo sumoo elo tetoyi, ngulo nondo kingo gengo weti ulungga oolengo ngu andangegunowono. Nondo gengo nowoondoyi tenggunootoowe, ndawugalo gedo gengo ko goboologa, ngulo ma nowoondoyi teyinowo? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Sobosobo oninggaku sanggili ulungga telo, ko oninggaku dowoolo, kumbadogoni oni kandeyemo yetoni, ngundo dowoolo, ya biyomimo yewonggori. Yetoyi, nguno ootoolo, ngunonggo weti bidodo andangenilo yewololo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yesusndo mande yanggango gula eneno ewolo. Ariya, ye nga mande yamonggawongga ko oningga ogingoyingo yolo, kowuli yowoku, nga ye gome ingoyi. Ngundilo nangge, ye nowoondoyemonggo dobooguliye kowuliye yeno tewonggoku, ngulo ye ma andangelo, kapengo yewanggoku ngu, asa, Awane Sambo endemo oolooteku, ngundo nguya, yengo mbumbuwa ngu ma andangelo kapengo yewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ngu naluno, Yesus mande kinitetoni ngu, ene Galili mela yokolo, ene Yudiya mela Yodan sono anduloko nguno ulelewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Uleletoyi, oni simoo bale oowooyingga oolengo nguya, ene keyolo ooloutoyi, ngu mela gumisina nguno, Yesusndo sayi oni yomosiyelootoni, ene mete temukowonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ngu naluno nguno, Parisi onindo ene tewoongowelo ombulo, sumoo ewonggo. Noolengo mamana mandeno, ngu mete oni enengo ingonduduno baleyi andangewa, bine? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ngundilo sumoo etoyi, asa, Yesusndo enengo mande ingolo, gumi ewolo. Ye kuli nga mandega nga kandangelo ingootenggo. Anutlo mandeno ngandilo ewolo. Kuli amana oolengo, Anutndo oo bidodo tewokuno nguno, ene simoo ko bale nguya tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ngundilo ngulo, simoo ewenemi yokolo, nalu bidodo baleyiboya ebe dowoodowoo telo, goweyali gulanangge oluwali. Anutlo mandeno ngundilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Yesusndo mande gula suleyolo ewolo. Ngundilo ngulo, elambalisa ngu, ene goweyali elaya kini. Ene goweyali gulanangge. Ngulo Anutndo oo gosiyolo yokowoku ngu, onindo ma toongoowelolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Parisi onikundo mande ingolo, gumi sumoo ewonggori. Ndawugalo ngulo, Moseslo mamana mandeno simoondo baleyi yokowelo ngu, ene komo so uyi nakangolo, baleyi inolo, owetoni toongewa? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ngundilo sumoo etoyi, Yesusndo mande gumi ewolo. Mosesndo yengo nowoondoye yanggango oolengo elambalisa toongooweloyi damoni ngu kenolo, ngulo ngu damoni damoninggano, ngunonggo yoyokootoni, elambalisa damoni ngu toongootenggo. Ene Anutndo amana simoo bale yoyeyingomo, ngu naluno, ene elambalisa toongooweloyi damoningga ngu, ene ma yewoli. ");
INSERT INTO rwo_karo_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","No yeno hamoo eteno. Ene oni gulado enengo baleyi bosebalese damoningga ma teyingomu ngu yokolo, ene bale gula yowaku ngu, ngu oningga ngu, ene elambalisa damoningga ngu yombuliyootelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Enengo sulena onindo enengo mande wilikolo ingolo, gumi ewonggori. Ngu elambalisa damoni ngu oo ulungga oolengo. Ene sosoleyingo bodaga telo, ingolo, ngulo ene mande gula ewolo. Ariya, noole bale ma yowato. Ngu damoni mete, bine? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ngundilo sumoo etoyi, asa, Yesusndo mande gumi ewolo. Elambalisa teweloyi damoningga nondo etuyelootenoku ngu, ngu oni bidodobolo kini. Kini, ngu elambalisa teweloyi damoningga ngu, Anutndo oni sunggi yeyingomu, ngulomu nangge. ");
INSERT INTO rwo_karo_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ndawugalo ngulo, oni oowooyingga mete bale ma yowanggo. Bale ene simoo yomoolo ngu, ene kenolo ingolo oode, bale ma yowelo ingowa. Oni gidalega ene bale ma yoweloyi, ndawugalo ngulo, oni gulado ene moondeye yootoongooyingo ngulo. Oni gidalega enesu nangge elambalisa teweloyi ngu gosiyolo, ndawugalo, ene Anutlo ko telo, oni simoo bale yowoosoolo, Anutlo mandeni damoningga enengo oni simoo bale soboyelooteku, ngu yoyeweloyimbolo Oni gula ene mete nga mandega ingowelo ngu, ene komo gome ingonilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ngu naluno, oni simoo baledo simooye bobodi gidalega yoyolo, Yesusndo kandeyi tabayemo yeya, yemboongeni, elo, yoyolo mayewonggori. Mayetoyi, ene ngulo sulena onindo ngu oni simoo baleku manggaluyelolo oweyelowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ngundilo tetoyi ngu, asa, Yesusndo ewolo. Ye simooye bobodi yoyokootoyiga, nono ombuyi. Ye ngu ma oweyelowelo. Kini, ye Anut Oo Bidodo Sembuli Sembunaye, ngundo enengo oni simoo bale soboyelooteku, ngu komo simooye ngundilomu, ngundo yowanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ene ngundilo elo, kandeyi simooye tabayemo yelo, kumana yunolo, ene yoyokolo toongewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ngu naluno nguno, oni gulado Yesusno ombulo, sumoo ewolo. Oo etuyeloyingo oni, no ndatelo damoni gomengga telogo, no suwoo suwoo keda oluweloyi ngu yowano? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ene ngundilo etoni, asa, Yesusndo mande gumi ewolo. Ndawugalo ngulo, ge nono oo gome ngulo sumoo ete? Anut enengombo nangge oni gome. Ge keda sugi sugi oluweloyi ngu yowelo ngu, asa, ge komo Anutlo mamana mande ngu bidodo keyolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","19","Yesusndo etoni, ngu simoo kosiyinggakundo sumoo ewolo. Ndatelo mamana mandega? Ene ngundilo etoni, Yesusndo mande gumi ewolo. Mamana mande ngu ngandilo: ge komo oni ma uleyi kumoowelo; ge komo bale gidalega yakakayi yodowoolo, oweyelolo, ma yombuliyelowelo; ge komo yakaka ma tewelo; ge oni gulano mande ebe ganagana ma ewelo; ge komo awanangge tanggeyemo gome ootooya, manggoye oweya, gome oodoya; ge oni gidalega tanggegemo oolootenggoku, ngu hoolooweyeloya, gome soboyeloya, gengo gowege sobowooteku ngundilolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Simoo kosiyinggakundo enengo mande ngu ingolo, gumi ewolo. No kuli bodagano, ko, ataga nguya, no ngu mamana mande ngu bidodo keyolo, ombulo oolooteno. Ariya, no ataga ndatelo oo gome gula tewano? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesusndo enengo mande ngu ingolo, gumi ewolo. Ge oni nenengo oolengo tunootewelo ngu, asa, ge komo oo gulanangge ngu te. Ge komo oolouya, gengo oo bidodo suleyoya, ngunonggo bobeye yoya ngu, owoolongo oni ngu bayeteya yuno. Ge ngundilo tewaku ngu, asa, gengo bobeye oo gome gome Sambo endemo ooloote. Ge ngundiya teya, ombuya, no keneloya endeyolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Simoo kosiyinggaku ngu mandeningga ngu ingolo, omukumundoongo yomoowelo newende nguya kowuli ulungga ingowolo. Ndawugalo ngulo, ene oo sitowini ulungga ngu yokolo, oni sungo yunoweloyi nguya kini. Ngundilo telo, ene ootookoolo toongewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ngundilo tetoni ngu, Yesusndo enengo sulena onino yowoolengolo ewolo. No yeno hamoo eteno. Oni ene sitowidodo ngu, ene Anut Oo Bidodo Sembuli Sembunaye, ngundo endega enengo oni simoo bale soboyelooteku, ngu newendesina uweloyi ngu, ngu kowuli oolengo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","No mande gula ko eteno. Bo ulungga nga, ngu nggusi newendekuli uweloyi ngu kowuli. Ene beye sitowidodo oni ngu Anut Oo Bidodo Sembuli Sembunaye, ngundo endega enengo oni simoo bale soboyelooteku, nguno uweloyi nguya, ngundilo kowuli ulungga oolengolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Yesus enengo sulena onikundo ngu ingolo, ene soli ulungga telo, enengo nangge mande elo, ingolo, sumoo ewonggori. Ngundilo ngu, onendo ngu mete ene suwoo suwoo keda oluweloyi ngu yowa? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Enengo sulena onindo ngundilo sumoo etoyi, asa, Yesusndo ene gome gome yeyolo ewolo. Anutndo oni ma hoolooweyelootoni ngu, asa, oni enesu nangge oo yanggango ngu hamoo ma tewa. Ene Anutndo oni ootoolo ngulo, ngunonggo ene oo yanggangomu ngu bidodo hamoo oolengo temukowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ngundilo etoni, Pitando mande gula Yesusnolo ewolo. Ingoyi, noole oo bidodo yokolo, ge kenggelolo endeyolooteto. Ngulo ngu, noole ndawuga yowato? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ene ngundilo sumoo etoni, asa, Yesusndo mande gumi ewolo. No hamoo oolengo yeno eteno. Kootusina, oo bidodo keda tunooteweloyimbolo ngu naluno, no Anut Nangoni Oni Kilalongo yaba bingaminidodo Sambo endemo nguno, no Anutlo yanggangoni dulidalinimo bibitewano. Ariya, ngu naluno, ye nguya yaba bingamidodo kande elaya kegidembolo elayaga (12) nguno bibitewanggo. Bibitelo, ngunonggo Iserel oni wata kande elaya kegidembolo elaya (12) ngu wilikoyelowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Yo, oni bidodo ene nolo ingolo, Anutlo mande metemi ngano ingolo wesiyolo, ene enengo ya, konebobeyi, kuwooyi, ewenemi, simoongo, enengo oowali koyi yokolo ngu, oo bidodo ye kuli yokowonggoku ngu, nondo ngu dagalo, ulungga oolengo ko yunowano. Yo, ngu oo ngu ulungga oolengo onibi kandegula (100) ngu yowanggo. Ngandilo nguya, ene keda sugi sugi oluweloyi, ngu yowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ene oni gulado melako ngano ngu oowooyi bingamidodo telo ngu, Sambo endemo, ene oowooyi kini. Ngundilo nangge, oni gula melako ngano ngu oowooyi kini oolooteku ngu, ene Sambo endemo, ngu oowooyidodo ulungga tewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Anut Oo Bidodo Sembuli Sembunaye, ngulo mandeni damoningga ngundo enengo oni simoo bale soboyelooteku, ngu oni gulado enengo mela ulungga ngu ngundilo. Ene suwoononggo oolengo ko oni yoyolo, Wayin kono ko teyilo oolouwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ene ngundilo telo, Wayin ko ngulo sembuli enengo ko oni mande yunolo, no bobeye Kina gulanangge ataga ko tetenggoku, ngulo nangge yunowano. Enengo ko oni mande ingolo, ngulo ngu nangge keyolo, enengo Wayin kono oolouwonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Asa, suwoononggo nalu kandegula gidembolo namolaya (9) nguno, ende oo uli yoweloyi musiyomo oololo, oni kingo dikaloodoyi yeyowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Yeyolo, ene mande eneno ngandilo ewolo. Ye nguya nolo Wayin kono ulo, ko tetoyi, ngundilo logono, no bobeye yunowanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ngundilo etoni, ingolo, kono satoyi, asa, sambolo naluno (12), ko nalu suwootetoni (3) nguno, ene oni gidalega yeyolo, ene nguya ngundilo tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ene suwootetoni, namoko ko yokoweloyi naluno, (5 Klok) ko sembuligaku ko oololo, oni gidega yeyolo, sumoo ewolo. Ye ndawugalo sano ngano kingo oolootenggo? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ngundilo etoni, enendo mande gumi ewonggori. Noole ko yunoweloyi oni kinilo ewonggori. Ariya, ko sembuligakundo ingolo, mande gumi ewolo. Asa, ye nguya, nolo Wayin kono uya, ko teyilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Wayin ko sobosobogakundo ngundilo elo, asa, suwootetoni ko kiniteteku naluno ngu, enengo kono oololo, ko sobosobogakuno ewolo. Ye oolouya, ko oni negoyelootooga ombutoyiga ngu, ngu beye yuno. Ge ko oni suwootetoni ko tewonggoku, ngu digi beye yunoya, wenga suwoononggo ko tewonggoku oni, ngu bobeye yunolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ene ngundilo etoni, asa, ko oni suwootetoni namoko ko yokoweloyi ene ko ootookoowonggoku naluno, (5 Klok), eneno ombutoyi, ko oni sobosobogakundo sa gulanangge ko tewonggoku, ngulo bobeye Kina gulanangge nangge yunowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ariya, ko oni suwoononggo ko tewonggoku, ngundo ko oni suwootetoni ko tewonggoku, ngulo Kina gulanangge kenolo, ngandilo ingowonggori. Noolengo bobeyega ngundo enengomu ngu dagawalo ingowonggori. Ene ngundilo nguya kini. Kini, ko oni sobosobo ko oni bidodo ko tewonggoku, ngundo bobeye Kina gulanangge nangge yunowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","12","Ngundilo ngulo, suwoononggo ko tewonggoku oninggakundo Kina gulanangge ene bidodo yolo, kenolo, ngulo ene ko sembuligakuya sanggili telo, enedodo longgeyolo ewonggori. Ndawugalo ngulo, nga oni nga kootu oololo, nalu bodaga nangge ko tewonggoku, ngulo uli noolengo bidodo gulanangge yunoote? Noole sa ulunggano ko ulungga telo, nosili yudoni, nalu bidodo ko tewootolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ngundilo etoyi, ko sembuligakundo mande gumi ewolo. Oo dobooguline, no yeno hamoo ewono. No suwoononggo mande yunolo ewono. Sa gulananggembolo ko tetenggoku, ngulo uli Kina gulanangge yowanggolo ewono. Nguno ngu, ye ngu mandega ngu ingolo, metelo ewonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ariya, ye uli yoya sayi. Oni suwootetoni ko tetenggoku, ngulo uli ko yengo uli gulanangge. No ngundilo tewelo gome ingolo teteno. ");
INSERT INTO rwo_karo_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ngu nenengo bobeyebo oni suwootetoni ko tetenggoku, ngu nowoondoyi yunolo, ngundilo yunooteno. Ye, bine, nondo ngundilo oni ngu nowoondone yunootoowe, ngulo sanggili tetenggo? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yesusndo mande gula ewolo. Yo, ko oni bidodo uliyi gulanangge yowonggoku, ngundilo nangge, simoo bale ululu ko buniyo bobodi nguya, nowoondoyemo hamoo teyingongga ngu gulanangge. Ngulo ngu, ene bidodo Anutlo Sambo endemo nguno uwanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ngu naluno nguno, Yesusndo enengo sulena oni nangge oolekanare Yerusalemno yade yade ooloutoyi, Yesusndo enengo sulena oni kande elaya kegidembolo elayagakuno, enengo mande yunolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","19","Ingoyi! Ataga noole Yerusalemno ooletooye ngu, no Anut Nangoni Oni Kilalongo, ngu Anutlo woolo yeyingo oni kundingiyi ngulo sobosobo oniku, ko, mamana mande etuyeloyingo oni nguya, ngu me oni kandeyemo noyewanggo. Ngu oni ngundo mande gulanangge nuleyi kumooweloyimbolo elo gosiyolo ngu, ene Gabman oni kandeyemo noyewanggo. Ngundo ngu, kootunesina mande yumoonunolo, gisalunelolo nutolo, de mombimo nuleyi kumoowano. Nalu kabusa yokolo, ko keda ootookoolo oluwanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ngu naluno nguno, Sebedi simoongo elayagaku Yems, Yon, namoyalimbo yoyolo, Yesus tanggeyimo ombulo, boodoo oondooketoni, namoyalimbo sumoo ewoli. ");
INSERT INTO rwo_karo_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ene Yesusndo koletelo namoyali sumoo inolo ewolo. Ge ndawu oo galo ingoote? Etoni, namoyalimbo mande gumi ewolo. Kootusina, Sambo endemo, ge nguno yaba gengo dulidalinidodo yabagemo bibitetoyi ngu, mete ge nenengo simoone elayaga, ngundo kandege koondosina, gulado kandege dedalesina ngundilo bibitewali. Ngu mete, bine? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ene ngundilo sumoo etoni, asa, Yesusndo mande gumi ewolo. Ye ngu ooga nono sumoo etenggoku ngu, ye damoni ma ingootenggo. Yali, bine, mete nondo kowuli ogingoyingo koolowoowanoku, ngu yali nguya bine, mete koolowoowali? Ngundilo sumoo etoni, elayagakundo enengo mande ingolo, gumi ewoli. Yo, noole metelo ewoli. ");
INSERT INTO rwo_karo_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Etoli ngu, asa, Yesusndo enedodo ewolo. Hamoo oolengo, ngu sono tobaga (kowuli koolowooteno) no netenokungga, ngu yali nguya newali. Ene onendo kandene koondosina, kandene biyomisina bibiteweloyi ngu, nondo mete ma ewano. Kini, Awane enengombo nangge, ene kuli oni yunoweloyimbolo yomosiyoyingolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Sulena oni kande elayagaku ngu mande ngu ingolo, ene Yems Yon elabasa nguya sanggili biyomi tewonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ene Yesusndo enengo kowuli ingolo, negoyelootoni, eneno ombutoyilo ewolo. Oni sowe gidalega Yuda oni kini ngulo sobosobo oni ululu, ngundo oni simoo baledo ene oni ulungga, elo ingootoyi, nguno ngu, ene yanggango oolengo soboyelootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","28","Ene ngu damoningga tabango onindo keyootenggokungga, ngu ye simoo bale nowoondoyemo hamoo teyingo nguya ngundilo ma keyowelo. Kini, ene ye kewooloyemo ulungga oowooyidodo oluwelo tewanggoku ngu, asa, ene yengo sulena oni tewanggo. Ngundilo nangge, oni gula ye kewooloyemo tabango ulungga oluwelo tewaku ngu, ene yengo kingo sulena oni oluwa. Ngundilo nangge, no Anut Nangoni Oni Kilalongo nguya onindo ko teya, hoolooweneloyi elo, ma ombuwono. Kini, no onino ko telo, hoolooweyeloweloyimbolo ombuwono. Nenengo keda oluweloyi, ngu nondo oni simoo bale bidodo mbumbuwanonggo, ko uliyeloweloyimbolo ombuwonolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Asa, ngu naluno nguno, Yesusndo enengo sulena onindo Yeriko ende ngu yokolo, yade yade ooloutoyi, oni simoo bale ene keyelolo oolouwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ooloutoyi, oni doongeyali kilingo elayagaku, oole dabemimo bibitelo oodoli, Yesus oolekana ooloutoni, ingolo, meno yanggango ewoli. Oo Sembuli Ulungga, ge Dewitlo sembeni, ge noolengo nowoondoyi yuno! Elo ewoli. ");
INSERT INTO rwo_karo_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nguno oni simoo baledo sanggili telo, yeyolo ewonggori. Yali manggoyali gosiyoli! Elo ewonggori. Ene elayagaku meno yanggango ulungga oolengo ewoli. Oo Sembuli Ulungga, ge Dewitlo sembeni, ge noolengo nowoondoyi yuno! Elo ewoli. ");
INSERT INTO rwo_karo_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ene ngundilo meno yanggango etoli, asa, Yesusndo oni elayagakulo meno ingolo, negoyelootoni, ombutoli ngu, sumoo yunolo ewolo. Nondo ndawuga yunowano? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Elayagakundo enengo mande ngu ingolo, ngulo ene gumi ewoli. Oo Sembuli Ulungga, noole doongetewelo ingootelo, elo ewoli. ");
INSERT INTO rwo_karo_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesusndo enengo mandeyali ingolo, ngulo ene nowoondoyi yunolo, kandeyi doongeyalimo yewolo. Ngundilo tetoni ngu, sodedonangge, ene doongetelo, Yesus kenolo, keyolo sawoli. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesus enengo sulena onikudodo Yerusalem namoko oololo, Betipas ngu ende bodaga Olib puli ngu tanggeyimo, ene nguno tunootewonggori. Ngu naluno nguno, Yesusndo enengo sulena oni elaya ende bodagano suleyelowelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Yali endega namokono kenooteliku anduno oolouli. Yali oololo, Hos gula oowooyi Donki gula nangonidodo de bungomo gosiyootoyi oolooteliku, ngu kenoya, wesiyoya, kimbonanonggo dowooya, yoya, nono ombuli. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ende oni ngundo yali sumoo yunootoningga ngu, ariya, yali ngandiya eli. Oo Sembuli Ulungga, ngundo nga Donkingga nga ko inowelo etoni, ngundiya eya eli. Ngundilo etoni ingolo ngu, asa, yali sodedonangge suleyelootoni, ko ombuwalilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Yesusndo mande gula nguya ewolo. Kuli, Anutlo ingondudu eyingo oni gulado mandega eyingo, ngu ataga engge tunootete. Kuli ene ngandilo nakangolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Ye Yudalo oni simoo bale Sayon Yerusalem endemo oolootenggoku, nguno ye ngandiya eyi. Nga kenoyi, gengo sobosobo oni koleteyingongga nga ataga ombute. Enendo Donki nangoni sanganimo bibitelo ombutoni, Donki nangoni ngu newende imakeyingo nangge oolooteku, ngulo ene oolengo yolo ombutelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ariya, sulena oni elayagaku oololo, Yesusndo ewoku, ngundilo tewoliyo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ene Donki nangoni nguya kimbonadodo yoyolo, Yesusno ombulo, enengo dokikilo nenggulo ngu andangelo, Donki nangoni sanganimo yomiwoli. Ene ngundilo yomitoli, ariya, Yesus oolelo, ngu sanganimo bibitewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Enengo sulena oni ngundilo tetoyi, oni simoo bale oowooyingga oolengo nguya, enengo dokikilo nenggulo oolekana yomilo yomilo oolouwonggori. Gidalegado de uyi ulungga nguya toongoolo, oolekanare yomiwonggori. Ngundilo telo, Yesus oowooyi bingaminidodo okoolo, mela ngano sobosobo koleteyingo ngundilo tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ene ngundilo tetoyi, simoo bale koletetoyi, gidalega kootu telo, oololo, ene moguluwoolo ewonggori. Hosana, gengo oowoongge awuno oolengo! Ge Dewitlo sembeni! Anutndo ene mete kumana nga oningga nga inowolo. Ene Oo Sembuli Ulungga, oowooyimo ombuteku ngu! Hosana, gengo oowoongge awuno oolengo! Elo meno ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Asa, Yesus yade yade Yerusalem utoni ngu, endemo simoo bale oowooyingga ngu kenolo soliyokolo, sumoo ewonggori. Nga oningga nga ndawu oningga? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Simoo bale enedodo oolouwonggoku, ngundo enengo mande ingolo, gumi ewonggori. Nga oningga nga ngu Yesus, Nasaret oni, Galili melakononggo ombulo, ene Anutlo ingondudu eyingo oni gulalo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Asa, Yesus oololo, Yuda goobooyingo ya oowooyi Tempel newendemo ulo, damoni yelo, oni Tempel yano bobeye oo koyi tewootoyi oweyelowolo. Ngu konggaku goobooyingo yano ngundilo telo, oni bobeye gulalomu gulalomu yowoolengolo, bayetetoyi, ngulo Yesus sanggili tewolo. Sanggili telo, ene, yabagakudodo wenggelemootoni, ukelo uwolo. Oni nu kundirimanggowo ngu uliyolo, koyi nguya tetoyi, ngulo yabani wenggelemootoni, ukelo, utoni oweyelowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Awanembolo mande nakayano, ngandilo ete. Nolo yane ngu oni simoo bale bidodobo yemboongeyingo yalo ewanggo. Ngundilo nangge, ene yendo ngu yeyi, yakaka onilo kombiteyingo musiyo tetelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ngu naluno nguno, Tempel yano, oni doongeye kilingo ko kekandeye biyomi ngu nguya Yesusno mayetoyi, ene bidodo yomosiyelowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","16","Ngundilo ngulo, Anutlo woolo yeyingo oni kundingiyi sobosobo oniku, ko, mamana mande etuyeloyingo oni, Yesuslo oo damoni sungo oolengo gula onindo ma teweloyim tewoku, ngu kenolo, simooye bobodi Tempel newendemonggo ngandilo meno etoyi ingowonggo. Hosana, gengo oowoongge awuno oolengo! Yesus ge Dewitlo sembeni! Elo etoyi, ngu ingolo, ngulo ene nowoondoye biyomi ulungga ingowonggori. Ngulo ene Yesusno ewonggori. Ge bine, ngu mandega simooyembo etenggoku, ngu ingoote? Ngundilo etoyi, Yesusndo mande gumi ewolo. Yo, no ingooteno. Anutlo mande ye kuli kandangelo ingootenggo. Ene Anutno ngandilo ewolo. Ge simooye bobodi ko simooye nonono nguya manggoye tango yetoni, ngulo ene gengo oowoongge bingamingge etenggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ngundilo elo yokolo ngu, asa, ene endesina oolelo, ende yokolo, Betani endemo oololo, suwoono nguno oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Sengetoni, Yesus enengo sulena onikudodo endemo ko oolouwelo yade oololo, oolekono Yesusndo oodoolo kumoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Oodoolo kumoolo, ngulo ene de gula oowooyi Pik, ngundo tanggooli nenggulo ngundilo ngu yowoko kenowolo. Uyi oowooyingga tutu ulewolo. Ene namokono oololo, engge doongetewelo damonimo oololo, engge gula ma kenowolo. Kini, uyi nangge oluwolo. Ngundilo kenolo, ngulo ene Pik degakuya ewolo. Kootusina, ge ko ma enggewalo ewolo. Ngundilo etoni, sodedonangge Pik degaku ariyelo kumoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ngundilo tetoni ngu, asa, enengo sulena onikundo kenolo, soliyokolo ewonggori. Ndatelo ngulo, Pik dega sodedonangge ariyelo kumoote? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesusndo enengo mande ingolo, gumi ewolo. No yeno hamoo eteno. Ye nowoondoye hamoo telo, nowoondoye elaya kini ngu, asa, ye nguya, nondo Pik degano tetenoku, ye nguya mete ngandilo tewanggo. Yo, ye nowoondoyemo hamoo ngu yanggango oolootenggoku ngu, asa, ngu nguya, ye mete nga pulingga ngaya ewanggo. Ge ootookooya, ukeya, wendeyino u. Ewanggoku ngu, asa, ene ngundilo tewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ngundilo nangge, ye nowoondoye hamoo telo, nguno ye oo gulalo elo yemboongewanggoku ngu, ariya, Anutndo ngu ooga ngu yunootoni yowanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ngu naluno nguno, Yesus ene Yuda onilo goobooyingo ya ulungga oowooyi Tempel, ngu newendemo ulo, oni simoo bale oo etuyeloweloyimbolo. Ngundilo tetoni, Anutno woolo yeyingo oni kundingiyi sobosobo oniku, ko, Yudalo oni simoo bale tabango oniku nguya ombulo, eneno sumoo ewonggori. Onendo ngu mande damoni yanggangongga ngu, ge gunowo? Onendo ge logogelootoni, nga kongga nga tete? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesusndo enengo mande ingolo, gumi ewolo. No nguya, ye oo gulalo sumoo yunowelo. Ye ngu gumi etoyi ngu, asa, nondo kongga tetenoku, ngulo yanggangoni nguya ewano. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","26","Ndawu oninggado Sonoyeloyingo Oni Yon suleyootoni ombuwolo? Anutndo sono kundingiyimbo oni sonoyeloni elo, ngulo Yon suleyootoni ombuwo; ngundi, oni simoo baledo bine suleyootoyi sonoyelowo? Ariya, ye nolo mandega gumi eyilo ewolo. Etoni, ariya, enengo nangge elo, ingolo, ewonggori. Noole ngandilo ewato. Anutndo Sonoyeloyingo Oni Yon suleyoyingo, ewatoku ngu, asa, enebana sumoo yunowa. Ye ndatelo ngulo nowoondoyemo hamoo ma ingootenggo? Ngundilo nangge, noolendo onindo Yon suleyoyingo ewatoku ngu, ariya, oni simoo baledo nooledodo sanggili ulungga tewanggo, ngulo noole sosoleteto. Ndatelo ngulo, oni simoo bale ene kuli ingootenggo. Yon ngu Anutlo ingondudu eyingo oni oolengolo ingowololo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ngundilo ngulo, ene Yesusno mande gumi ngandilo ewonggori. Noole watayi kinilo ewonggori. Ene ngundilo etoyi, asa, Yesus enebana ewolo. No nguya yengo sumoo nono ewonggoku ngu, no yanggangonengga ndanonggo yolo, nga kongga tetenoku, ngu nguya yeno ma ewanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesusndo mande yamonggawo gula ewolo. Ye ndatelo ingootenggo? Oni gula simoongo elaya nguno oololo, nangoni koletelogakuno ewolo. Ataga mete ge oolouya, nolo Wayin kono uya, ko telo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ngundilo etoni, nangoni koletelogakundo gumi ewolo. Kini, no ma! Ewolo. Ngundilo elo oode, ene kootusina ingonduduni yowoolengolo, kono toongelo ko tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Asa, awayalinggaku ulo, nangoni kootunggakuno nguya ngundilo etoni, ene gumi ewolo. Yo, elo oode, ene kono ma uwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ariya, ndawu simoongongga, ngundo eweyi manggowo ngu keyowo? Ewolo. Ngundilo etoni, ene mande gumi ewolo. Nangoni koletelogakundo, etoyi, Yesusndo enengo mande ingolo ewonggori. Yo, no yeno hamoo oolengo eteno. Gabman bobeye yoweloyi oni, ko, ooleko ooleko bale nguya, ene koletelo ye dagayelolo, Anut enengombo oni simoo bale soboyelooteku endega, nguno ulo oluwanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ndatelo ngulo, Yon koletelo ombulo, ngundo oole nenengo ngu keyoyi, elo etuyelootoni, ene ye nowoondoye ma yowoolengootenggo. Ene Gabman bobeye yoweloyi Takis oni, ko, ooleko ooleko bale nguya, ene Anutlo Mande Keda Mesalango ngu ingolo, ngulo ene nowoondoye yowoolengolo, hamoo tewonggori. Ene ye ngu yeyolo, ngulo nowoondoye ma yowoolengolo, nowoondoyemo hamoo ma tetenggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesusndo mande yamonggawo gula ewolo. Asa, ye mande gula ingoyi. Oni gula Wayin kongga telo, oonggoyi pawangolo, Wayin nguno imiwolo. Ene Wayin engge yolo, wongoolo, winggooweloyi musiyo nguya tewolo. Ene ko ngu sobowooweloyimbo ya pelungga Sambono yelo, ngunonggo ene mete Wayin kono oo bidodo gome kenolo, sobowoolo oluwolo. Oni ko sembuliga, ngundo oni gidalegado ngu kongga ngu sobowooya, Wayin ngulo engge gumi ko uliyi, enengo yoyi, elo logoyelolo yokolo, asa, ene mela gula yowoko nguno toongewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ariya, Wayin enengo enggeyingo nalu, ngu tunootewolo. Tunootetoni, asa, ene ko sembulibo enengo sulena oni suleyelootoni, Wayin koyi sobosobo tetenggoku onikuno oolouwonggori. Ndatelo ngulo, ko sembuliga, ngundo ko ngulo oo engge gula yenunoyi, elo, ngulo ene oni ngu suleyelootoni oolouwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ooloutoyi ngu, asa, Wayin kono ko onikundo, oni ko sembuligakulo sulena oniku yodowoolo, gulanangge ngu ene gome gome utolo, ko oni gula ene uleyi kumootoni, ko oni gula ene digi oowooyingga yolo, moondeyimo oolongoowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ene ngundilo tetoyi, ko sembuligakundo enengo sulena oni oowooyingga suleyelootoni ooloutoyi, ngu damoningga koletelo tewonggoku, ngundilo nangge tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ngundilo tetoyi, ko sembulibo enengo nangoni gulanangge kootu ngu suleyootoni oolouwolo. Ene ngandilo ingolo, nenengo nangone suleyootoowe, ooloutonigo, ngulo manggowo mandeni keyowanggo. Elo ingolo suleyowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ene oni kono ko tetenggokundo, enengo nangge kewooloyemo mandelo, ingolo ewolo. Nga oningga ngando ngu eweyimbolo oo bidodo yomukolo, enendo sembuli tewa. Ariya, noole ene nguya uleyiga kumooni. Noole ngundilo telo ngu, asa, nga kongga nga ngu, noolengombo sobowoolo, koyi tewatolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ngundilo elo, ene oni ulungga nangoninggaku ngu dowoolo, uleyi kumoowolo. Kumootoni, bingo okoolo, kanggaloko oolongooyi uwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ene ngundilo tetoyi, asa, oni ko sembuligaku ombulo, ko sobosobo oni biyomi nguno ene ndatelo damoningga tewa? Sumoo ngundilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ene mandeni ingolo, gumi ewolo. Ene ombulo ngu, ko oni biyomi ngu yutolo, yuleni kumoomukowanggo. Ngundilo telo, ene kongga ngu ko oni sobosobo gome gidalega yunowa. Wayin enggeteku naluno, asa, ko sobosobo keda, ngundo Wayin bayetelo, gidesinanggo enengombo yolo, gidesina Wayin sembuli inootoyi yowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Asa, ngu naluno nguno, Yesusndo mande gula yunolo ewolo. Anutlo mande nakangoyingo ngu, ye kuli kandangelo, ngandilo ingootenggo. Nga ya ungoombolo ndonggolomi nonggini gomengga nga ngu, ya yeweloyi onindo yokootenggo. Ene ataga, ngu nonggini ndonggolomi ngu, ene ya kowuli ngu bidodo koolowooweloyi nonggini koletewolo. Oo Sembuli Ulungga, enengombo ngu ooga ngu yeni tunootewolo. Noole ngu kenootooye, ngu mesalango tetelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ariya, no yeno hamoo eteno. Ye nowoondoye ma yowoolengolo, nowoondoye hamoo ma teyingo, ngulo no Anutlo mandeni damoningga, ngundo enengo oni simoo bale soboyelooteku, ngu yenonggo andangelo, oni sowe gidalega Yuda oni kini ngu yunowano. Eneno nguno ngu, oo gome enggewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Oni gula Kristus Yesus kootu inolo, ngu ene ngandilo. Oni ya ungoombolo osiyingga ngu sanganimonggo solelo ngu, ene biyomi yewa. Ko biyomi ngundilo tetoni, ngulo ngu Kristus uli gumi biyomi teyinowa. Ene osiyi koleteyingo ngu Kristus, ngundo ngu oningga ngu sanganimo solelo, utolo, yombuliyootoni, ene sosolango yelo kinitewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Anutno woolo yeyingo oni kundingiyi sobosobo oniku, ko, Parisi onindo Yesuslo mande yamonggawo oowooyingga ingolo, ngulo ene ingootenggo. Yesusndo ngu enengombolo mande nooleno sanggawelo ewolo ingowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ngundilo ngulo, ene sanggili telo, uleyi kumooweloyimbolo oole erewewonggori. Yo, ene dowoolo, uleyi kumooweloyimbolo tewelo, ene oni simoo balelo sosolelo, ngulo ene yokowonggori. Ndatelo ngulo, ene ingootenggo. Oni simoo bale ngu, Yesus ene Anutlo ingondudu eyingo onilo ingootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesusndo eneno mande yamonggawo gidalega ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Anut Oo Bidodo Sembuli Sembunaye, ngundo endega enengo oni simoo bale soboyelooteku ngu, ngu melako oni sobosobo koleteyingo ulungga, ngulo damoni ngandilo. Melako oni ulungga, ngundo nangonimbo bale yowelo tetoni, ngulo simbo ulungga kawolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Koletelo, ene (Yuda) oni ngu simbo ulungga nguno mayeyi, elo, nalu logo tewolo. Ariya, oo neweloyi naluno, enengo sulena oni suleyelootoni, oololo, ngu oni sunggi yeyingoku negoyelootoyiga, ombuyi, elo negoyelootoyi, ene yokowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ngu oniku yokootoyi ngu, asa, enengo sulena oni gidalega suleyelolo ewonggori. Ye oni sunggi yeyingoku, nguno ngandiya eyi. Oni ulunggado kuli oo simbo ulungga kalo yewolo. Bulmakau ko, oo nusago moondeyi ndindi teyingo gomemu nguya kuli yutolo, kalo, oo bidodo yomosiyolo, yetoni ooloote. Nga nalungga nga, nangone bale yoweloyi, ngulo ngu, ye nguya ombutoyi, ngu naluno, gooboongoolo, oni oni telo, oo newatolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ariya, sulena onikundo oololo etoyi, ene oniku enengo mandeni ma ingowelo, ngulo yokolo sawonggori. Oni gidalega enengo oowali kono satoyi, oni gidalega enengo bobeye yoweloyi kono nguno sawonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ngundilo satoyi, ene oni gidalega oni ulungga enengo ko oni yodowoolo, gisaluyelolo yuleyi kumoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ngundilo tetoyi ngu, melako oni sobosobo koleteyingo ulungga ngundo ingolo, ngulo ene sanggili telo, enengo me oni suleyelootoni, oololo, ngundo enengo ko oni yulewonggoku oniku yutomukolo, enengo ende yande nguya kamukowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ene ngundilo ya kamukootoyi ngu, asa, oni ulungga enengo sulena onikuya ewolo. Bale yoweloyi oo simbo ulunggaku ngu oolooteku nga, ene oni negoyelowonoku, ngulo damoniye nenengo kini, ngulo no ene yoyokootoni, ngano ma ombuwanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ariya, ye oolouya, oolesanga bidodomo onilo doongeteya, negoyelootoyiga, nga bale yoweloyi simbogano ngano ombuyilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ngulo ngu, enengo sulena oniku ngundilo ingolo, ene oole sungo sungo oololo, oni simoo bale bidodo yeyolo, goobooyelolo, oni biyomi ko oni metemimu nguya ombuyi elo sumoo yunolo, suleyelootoyi ombuwonggori. Ngundilo tetoyi ngu, bale yoweloyi musiyonggaku oni simoo bale oowooyingga hangewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ngu bale yoweloyi naluno, enengo damoniye ngu ngandilo. Oni simbo sembuliga, ngundo oni kuli sunggi yewoku, nguno nenggulo keda bayetelo yunowolo. Ngu naluno, melako oni sobosobo koleteyingo ulunggado yaloko ulo, oni simoo bale oo simbo ulunggano mayewonggoku yeyoyingomu ngu, oni gula ngu nenggulo yunowoku, ngu ma tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Oni ulunggakundo ngu oninggakuya ewolo. Doboone, ge ndawugalo bale yoweloyi nengguloga ngu ma tewolo? Ene sumoo etoni, ngulo oninggaku sosolelo, mande gumi ma ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ngundilo tetoni ngu, oni oo sembuligaku enengo sulena oniya ngandilo ewolo. Nga oningga nenggulo inowonoku, ene ma teyingo, ngulo kekandeyi ukingoya, yoya, endesina oolongootoyiga uya, uleliko olini. Ngu uleli musiyonggano nguno, ngu oni bidodo sendo ulungga telo, metokalikali telo oluwanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesusndo mande gumi gula soweyolo ewolo. Yo, Anutndo oni bidodo negoyelolo, ngundilomu, ene gulanangge nangge logoyelootoni, newendesina ulolootenggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ngu naluno nguno, Moseslo mamana mande sobowooyingo oni oowooyi Parisi, ngundo enengombo mande gosiyolo, ingondudu ewonggori. Ene mande gosiyolo, Yesus sumoo mande elo inootooye, ene mete mande gumi metemimu ma ewa. Ngulo ene oole erewelo, Yesus goweyi sanggawelo mande ewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ngundilo ngulo, Parisilo sulena oni, ko, Herodlo ko oni suleyelootoyi, Yesusno oololo, sumoo ewonggori. Oo etuyeloyingo oni, noole ingooteto. Ge mande hamoomu nangge ete. Ge oni gulalo nangge gome ma ingondudu tete. Kini, ge oni simoo bale bidodo goobooyelolo, Anutlo mande damoni metemi nanggelo etuyeloote. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ngundilo ngulo, ge nooleno e. Ge ndatelo ingoote? Noole Yuda oni nga, digi beye Takis Sisano inowato, bine, ngundi kini bine? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","19","Ngundilo sumoo etoyi ngu, Yesusndo enengo mande ebe ganagana ngu ingolo, enebana mande gumi ewolo. Ye mebuye sangala oni! Ndawugalo ye no tewoonelootenggo? Ye bobeye gula Sisa inoweloyi ngu yoya, ombutoyiga, nondo kenoowe. Ngundilo etoni, ingolo, ene beye gula yolo, ombulo, Yesus inowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Inootoyi, Yesusndo kenolo, enebana sumoo yunowolo. Nga bobeye bungomo gabogaboyi, ko, oowooyi nakangoyingo nga oonelomu? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ene ngundilo sumoo etoni, enebana mande gumi ewonggori. Ngu Sisalomu. Ngundilo etoyi, Yesus enebana mande gumi ewonggori. Sisalo oo ngu, ye komo Sisa inoyi. Anutlo oo ngu, ye komo Anut inoyilo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Oniku ngu enengo mandega ngu ingolo, ngulo ene soliyokowonggori. Ngundilo ngulo, ene Yesus yokolo sawonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ariya, ngu naluno nangge, Yuda oni gidalega oowooyi Sadusi, ngundo Yesusno, mayewonggori. Ngu Sadusi oni, ngundo ngu, ene ngandilo ingolo etenggo. Oni kumootenggoku ngu, ene ko ma ootookoowanggolo ingootenggo. Ngu oni ngu Yesusno ombulo, tewoongowelo sumoo inolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Oo etuyeloyingo oni, Mosesndo mande gula ngandilo nakangolo yunowolo. Oni gula simoongo kiningga kumoowaku ngu, ariya, kameyimbolo konebeyi gula ootoolo ngu, ngundo ngu bale nggami ngu yowa. Nguno nangoningga tunootewaku ngu, ngu bobeyi hoolooweyingo oluwalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ariya, oni simoongolo gulanangge ngu, ene kandegula gidembolo elaya, noole kewoolonayimo oluwonggo. Koleteloga, ngundo balega yowolo. Asa, ngu simoongo kini oode, kootusina kumoowolo. Kameyi kumootoni ngu, asa, koneyombo ngu baleyi nggaminggaku ngu yowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Yo, koneyo enebana ngu balegaku yolo, ene nguya simoongo kini oode, kumoowolo. Ngulo koneyo kabusayigaku enebana ngu balegaku nangge yolo oode, ene nguya simoongo kini oode kumoowonggori. Ngundilo nangge, ngu simoongolo kandegula gidembolo elayagaku bale gulanangge yolo, kumooloodoyi kinitewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kootusina, balegaku nguya kumoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ariya, kootusina, oni kumooyingoku, ko ootookoowanggoku naluno nguno, ngu balega ngu oone baleyi nenengo? Ge ingoote. Ngu kandegula gidembolo elayagaku, ngu bidodo baleye gulanangge. Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesusndo enengo mande ngu ingolo, gumi ewolo. Ye Anutlo mandeno, ko, enengo yanggangoni nguya, ngu ma ingootenggo. Ngulo ngu, ye mande bulibali etenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Oni kumooyingo ngu ko ootookooyingo naluno nguno, simoo bale kameyi baleyi teweloyi kini. Kini, ene Anutlo Sambono Engel oni oolootenggoku, ngundilo oluwanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ene nga mandega oni kumooyingo ko ootookooweloyi ngu, ye Moseslo buk kuli kandangelo ingolo, ene ye ngulo damoni nenengo ma ingootenggo. Ngu mandegano nguno, Anutndo Moseslo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","No Ebarahamlo Anut, Ayisaklo Anut, Yekoblo Anut. Ewolo. Yesusndo mande gula soweyolo ewolo. Moseslo mande, ngundo etuyelooteku ngu, ngu ngandilo. Oni simoo bale keda oolootenggoku, ko oni kumooyingomu, ngulo gaboye keda oolootenggoku, ngulo Anut. Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ngundilo etoni, oni simoo bale enengo mande etuyelowoku, ngu ingolo soliyokowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ngu naluno, Parisi onindo mande ingootoyi, Yesusndo Sadusi onilo sumoo mande bidodo ewonggoku, ngu andangemukootoni, ngulo Parisi oni ene nguya Yesus tewoongoweloyimbolo oololo gooboongoowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Parisi oni gula, mamana mande gome watayi, ngundo Yesusno ombulo, tewoongoweloyi mande ngu ingolo, sumoo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Oo etuyeloyingo oni, ndawu mamana mandega, ngundo mamana mande gidalega ngu dagayeloote? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesusndo mande ngundilo ingolo, gumi ewolo. Oo Sembuli Ulungga, ngu gengo Anut hamoo oolengo. Gengo nowoondoge bidodo, ingonduduge bidodo, ngu yanggangongge oo ngu bidodo komo Anut inoya, gome keyo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Nga mamana mandega ngando mamana mande gidalega bidodo dagayeloote. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ngu mamana mande elayayiga nguya ngandilo. Gengombolo gome ingooteku, ngundilo nangge, ge tanggegemo oni gidalega oolootenggoku, ngu bidodo nguya nowoondoyi yunolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Nga mamana mande elayaga geno etenoku nga, ngu Anutlo mamana mande bidodo ngulo damoni oolengo, ko, Anutlo ingondudu eyingo oniku, enengo mande bidodo ngulo damoni nguyalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Asa, ngu naluno nguno, Parisi oni gooboongoolo oodoyi, Yesusndo sumoo yunowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Ye ndatelo ingootenggo? Kristus, Anutndo noole yoyoweloyi sunggi yewo oni, ngu oone nangoni? Etoni, Parisi onindo mande gumi ewonggo. Kristus, ngu Dewitlo sembenilo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","44","Etoyi, enendo mande gumi ewolo. Ariya, Anutlo mandeno nguno, ndawugalo Yuka Kundingiyimbo Dewit newende yokutuwootoni, Kristuslo elo eyingo, Oo Sembuli Ulunggalo eyingo? Anut Oo Sembuli Ulungga, ngundo nolo Sembune Oo Bidodo Sembuli, nguno ngandilo ewolo. Ge kandene koondosina musiyo bingamidodo nguno bibite. Kootusina ngu, nondo gengo me oni yoyewe, gengo kengge damonimo yoyewanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ariya, ene ngu Dewit enengo osiyi nangge ngu, ariya, ndawugalo Dewitndo enedodo Oo Sembuli Ulungga, ewa? Yesusndo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Yesusndo sumoo mande yanggangongga ewoku, ngulo mande gumi eweloyi, oni gula ene ereremo kini. Ene ngu mandega ngu ingolo, ngu naluno, damoni yelo, sosolelo, ngulo ene mande gulalo ko ma sumoo inowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ngu naluno, Yesusndo enengo sulena oni, ko, oni simoo bale oowooyingga ngu mande wesiyolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Mamana mande etuyeloyingo oni, ko, Parisi oni, ngundo Moseslo mamana mande ngu sobowoolo, ngunonggo ye etuyelootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Mamana mande bidodo etuyelootenggoku, ye komo ngu bidodo keyoyi. Ene nondo ye loogu yunooteno. Ye komo enengo damoniye tetenggoku, ngu ma keyowelo. Ndatelo ngulo, ene mande metemi wesiyolo elo, ene enengombo ngu ma keyootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Yo, Parisi oni, ngundo mamana mande oowooyingga oni simoo baleno yetoyi, ngulo ene ngu keyowelo ko biyomi telootenggo. Ngundilo telo, ene oni simoo bale ma hoolooweyelolo, mamana mande keyootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ene oo bidodo tetenggoku ngu, onindo yeyoya, bingamiye okooyi, elo tetenggo. Ene kembwasayesina oo ulungga yelo, nguno Anutlo mamana mandeni gidalega nakangolo gosiyowolo. Ene towikumba pelungga pelungga oni bingamiyedodomu nguya yemulo, dokikilo nenggulo dalinidodo telo kuduwootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Yo, ene Yuda onilo goobooyingo yano, oni simoo bale doongeyemo tunoo bibiteweloyimbolo, ngulo gome oolengo ingootenggo. Ene oo simbo kayingo naluno nguya, yaba koleteyingo nguno bibiteweloyimbolo, ngu gome ingootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Oowali uliyoweloyi musiyomo nguno, onindo ene yeyolo, kambayeloyi etoyi, ngulo nguya gome ingootenggo. Ngundilo nangge, oni simoo baledo oo etuyeloyingo oni elo, oowooye bingami okooyi, elo tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ene yendo oni gidalegado oowooye bingamiye okoolo, ngunonggo oo etuyeloyingo oni, eyilo ma ingowelo. Ndatelo ngulo, ye bidodo Anut doongeyimo ngu siyelo oluwanggo. Yengo oo etuyeloyingo oni gulanangge, ngu Anutndo nangge. ");
INSERT INTO rwo_karo_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ngundilo nangge, ye nga melako ngano, oni gulaya, Awanayilo ma ewelo. Ndawugalo ngulo, ye Awaye gulanangge ngu, Anutndo nangge Sambo endemo ooloote. ");
INSERT INTO rwo_karo_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ngundilo nangge, onindo yeya, tabango onilo, ma ewelo. Kini, yengo tabango oni ngu gulanangge Kristus nangge. ");
INSERT INTO rwo_karo_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ene ye kewooloyemo oni ulungga tunootewelo ingowaku ngu, asa, ene komo yengo ko oni olini. ");
INSERT INTO rwo_karo_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ngundilo nangge, oni gula enengo oowooyi bingami okoowelo ngu, Anutndo ngu oningga ngulo oowooyi yeni bodaga ameno uwa. Ngundilo nangge, oni gula, enengo oowooyi ingootoni, ameno bodaga tewaku, Anutndo ngu oningga ngulo oowooyi yeni, ulungga tewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ye mamana mande etuyeloyingo oni, ko, Parisi oni, ye mebuye sangala oni! Ye ingondale teyi! Ye nowoondoye ma yowoolengolo, Anutno nguno ma oolouwelo ingootenggo. Yo, ye nowoondoye hamoo ma teyingo, ngulo ye oni simoo bale gidalega nguya, ye yoyokootoyi, ene Anutlo mandeni damoningga, ngundo enengo oni simoo bale soboyelooteku, nguno ma utenggo. Yo, yendo enengo Anutlo nowoondoyemo hamoo teyingo damoningga, ngulo oole gosiyolootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ye mamana mande etuyeloyingo oni, ko, Parisi oni! Ye mebuye sangala oni! Ye ingondale teyi! Ye bale nggami ngu ganayelolo, tolige tolige ye enengo oo sitowi, ko, enengo ya nguya ngu kingo yololootenggo. Ngundilo telo ngu, oni doongeyemo, ye Anutno kingo kila pelu pelungga tetoyi, Anutndo mete ngu bale nggami ngu hoolooweyelowa. No yeno mande yanggango eteno! Kootusina ngu, yengo damoni biyomi tetenggoku, ngu Anutndo ngulo gumi kowuli ulungga oolengo yunowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ye mamana mande etuyeloyingo oni, ko, Parisi oni, ye mebuye sangala oni! Ye ingondale teyi! Ye wendeyino, ko, mela yowoko biyomi yade yade oololo, oni gula yootoyi, ngundo yengo nowoondoye hamoo teyingongga ngu keyowa. Ene ye ngu ko oningga ngu yolo, yengo damoniye biyomi etuyelootoyi, enengo damoni biyomi, ngundo yengo damoni biyomingga ngu bidodo dagayelowa. Yendo ene nguya yolo, Setanlo ende biyomi nguno uwanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","17","Ye doongeye kilingo oni, ye oni gidalega oole etuyelowelo ngu, ye ingondale teyi! Ye oni simoo bale ngandilo damoni biyomi ngu, ebe ganagana mandelo etuyelootenggo. Oni gula mande awuno oolengo solumimonggo elo, Anutlo goobooyingo ya kundingiyi Tempel, ngu oowooyimonggo mande ewaku ngu, ariya, mande elo gosiyowoku, ngu ene mete yokowa. Ngulo ngu, onindo ene yolo, mande wilikoyingo onino oolouweloyi nguya kini. Ngundilo nangge, oni gulado mande elo, bobeye gol gome gome Tempelno oolooteku, elo mande gosiyolo, ene mande awuno oolengo solumimonggo etoni ngu, ariya, ngu mandega ngu, ene komo keyoni. Ene mande logo gosiyowoku, ngu ma keyolo tetoni ngu, asa, onindo ene mete yolo, mande wilikoyingo onino oolouwanggo. Mande ebe ganagana ngundilo elo etuyelootenggoku, ngu biyomi oolengo! Ye doongeye kilingo oolengo! Ndawuga, ngu koleteyingo? Beye gol gome gome Tempelno oolooteku, ngundo bine, ngundi, Anutlo Tempel, ngundo beye gome gome ngu yeni, kundingiyi tete, bine? Tempel kundingiyi ngundo gol beye yeni, kundingiyi nguya tunootete. ");
INSERT INTO rwo_karo_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","19","Yendo mande biyomi gula nguya oni simoo baleno etuyelootenggoku, ngu ngandilo. Oni gula mande gosiyolo ngundilo elo, Anutno woolo yeweloyi digi yawasano ngu hamoo awuno oolengo solumimonggo etoni ngu, ariya, ene mande gosiyowoku, ngu mete yokowa. Ngulo ngu, onindo ene yolo, mande wilikoyingo onino oolouweloyi nguya kini. Ngundilo nangge, oni gula mande gosiyolo, ngundilo elo, oo Anut inowoku, ngu woolo yeweloyi sanganimo oolooteku, ngu mande hamoo awuno oolengo solumimonggo etoni ngu, asa, mande ewoku, ngu ene komo keyoni. Ene mande logo gosiyowoku ngu ma keyolo tetoni ngu, asa, onindo ene mete yolo, mande wilikoyingo onino oolouwanggo. Ye doongeye kilingo oolengo! Ndawuga, ngundo dagate? Oo Anut inowoku ngu, bine; ngundi, Anutno woolo yeweloyi digi yawasa, ngundo oo Anut inowoku, nguno yeni, kundingiyi tete, bine? Gol beye yemboongeyingo musiyomo yetenggoku, ngu musiyongga ngundo yeni, gol beye kundingiyi nguya tunootete. ");
INSERT INTO rwo_karo_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ngu damoni ngu, nenengo kini. Oni gula mande gosiyolo, Anutno woolo yeweloyi digi yawasa, ngulo mande awuno oolengo solumimonggo mande etoni ngu, ariya, ene mande gosiyolo, Anutno woolo yeweloyi, ko oo nguno Anut inowoku, ngu sanganimo nguno oolooteku, nguya gosiyowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ngundilo nangge, oni gula Tempel ngulo mande gosiyolo, awuno oolengo solumimonggo etoni ngu, ariya, ene mande gosiyolo, Tempelno ko Anut kundingiyi nguya Tempelno oolooteku, ngu gosiyowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Mande gula ngandilo. Oni gula Sambo ende ngulo mande gosiyolo, awuno oolengo solumimonggo etoni ngu, ariya, ene mande gosiyolo, Anutlo yaba bingaminidodo, ko, Anut nguya yaba sanganimo bibiteteku nguya, mandelo gosiyowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ye mamana mande etuyeloyingo oni, ko, Parisi oni, ye manggoye sangala! Ye ingondale teyi! Ye yanggango yelo, oo bidodo yengo kono suwe oo sookiyagoolo nguya yootenggoku, ngulomu kande elayaga ngu yolo, gulanangge andangelo, Anut inootenggo. Ngu hamoo oolengo, ngu damoni gome tetenggoku, ngu metemi. Ene Anutlo mamana mande oo ulungga oolengo ngu, ye ma keyootenggo. Yo, ye damoni nenengomo oni wilikoweloyi; nowoondoye ebe ino ino teweloyi ngulo damoni; ko, nowoondoye hamoo teyingo ngulo damoni, ngu ye ma keyootenggo. Ye komo ngu oo ngu teya, ko, Anut oo inoweloyi nguya keyoyi. Ngundilo damoningga ngu, gome oolengo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","25","Ye mamana mande etuyeloyingo oni, ko, Parisi oni! Ye manggoye sangala! Ye ingondale teyi! Ye oni doongeye kilingo, ngundo oni gidalega oole etuyelowelo tetenggoku ngundilo. Yengo koondo samayi, toba sanganisina ngu sonowoolo, newendemo ngu yakaka damoni, yengo ingondudu keyootenggoku, ngundo hangelo ooloote. Koletelo, yengo toba newendemo ngu yomosiyootoyi, namboyi oodoni ngu, ariya, sangani nguya namboyi oluwa. Ye oni gula enengo sonono imimoo bodaga ngu sanganimo ooleteku, ngundilo. Oningga ngu sodedonangge mimoongga yolo, yokolo, ene bo ulungga biyomi sono nelo nemukooteku ngundilo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ye Parisi oni, ye doongeye kilingo! Ye komo koletelo toba newende sonowootoyiga namboyi yetoninggago, asa, kootu sanganisina nguya namboyi oluwa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ye mamana mande etuyeloyingo oni, ko, Parisi oni manggoye sangala! Ye ingondale teyi! Ye oni melengooweloyi musiyo sanganimo kumu nomboyimbo dowootenggoku ngundilo. Sanganimo ngu, gome oolengo kenomayingoweloyi, ene mele newendemo ngu, oni wembuye oowooyingga, ko oo bidodomo biyomi buwoo ngundo nangge hangete. ");
INSERT INTO rwo_karo_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ye ngundilo nangge oolootenggo. Oni goweye sangani kenolo ngu, oni nenengolo ingootenggo. Ene nowoondoyemo ngu, ye ebe ganagana teweloyi damoni, ngundo nowoondoyemo hangelo oodoni, ngulo mamana mande nenengo ngu yokootenggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ye mamana mande etuyeloyingo oni, ko, Parisi oni manggoye sangala! Ye ingondale teyi! Ye Anutlo ingondudu eyingo oni, ko, oni nenengo kuli kumooyingo, ngu meleyeloyingo ngulo meleye ngu gome yomosiyolo, so uyi nakango imitoyi, gome tetoni ngu, ngundilo oni ngulo oowooyi bingamiye okootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Meleyemo ye nakayangga tetenggoku, ngu oni simoo bale telo, etuyelowelo ngundilo etenggo. Noole osisambado nalungga oluwonggoku, nguno ootoolo ngu, ariya, noole Anutlo ingondudu eyingo oni yulewonggoku, ngundilo noole ma yulewootowolo etuyelootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ye simoo bale doongeyemo damoni ngundilo tetenggoku, ngundo tunoo oolengo etuyeloote. Ngu hamoo oolengo, ye ngu oni kuli Anutlo ingondudu eyingo oni yuleyi kumooyingo, ye ngulo osisambaye oolengo yootunolo etuyelootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Asa, yengo osisambayebo oo damoni tewonggoku, ngu yendo enengo musiyemo dikaya, oo ngu bidodo temukoyi! ");
INSERT INTO rwo_karo_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ye sile! Ye sile biyomi simoongo! Ye osisambayeboya, Setanlo ende de nombo ma kumooweloyi, nguno oolouwanggo. Ye saweloyi oole gula kini! ");
INSERT INTO rwo_karo_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ariya, no yeno etoowega, ye ingoyi! No Anutlo ingondudu eyingo oni, ingondudu gome oni, ko, Anutlo mande etuyeloyingo oni gome, no suleyelootoowe, yeno oolouwanggo. Ene yendo gidalega yuleyi kumootoyi; gidalega de mombimo yosanggawetoyi kumootoyi; gidalegado ye goobooyingo ya bidodo ngu newendemo gisasaluyelowanggo; gidalega yendo ende gulanonggo oweyelootoyi, ene ende gulano satoyi, keyelolo sawanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","36","Ye ngu damoningga ngu tetenggoku ngu, ariya, oni nenengomu bidodo melako ngano me onindo yuleyi kumooyingo, ngulo kowuli kootusina, ye yowanggo. Ye ngundilo oni ngulo kowuliye koolowootoyi, kuli oolengo, Adamlo nangoni Ebel, bebeyibo uleni kumooyingomu ngundilo nangge ombulo, yade yade oololo, goobooyingo ya Tempel newendemo Anutlo woolo yeweloyi tanggeyemo, ngu naluno, oni gulado Sekarayiya, Berekayiya nangoni, ngu uleyi kumoowonggori. Ngulo no yeno hamoo eteno. Ye nga oni oolootenggoku nga, ye bidodo uli biyomi, ngu oo tewonggoku ngulo yowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Oo Yerusalem, Yerusalem simoo bale! Suwoo suwoo, no nowoondoye hamoo teyingo, ngulo oole nenengo etuyelolo, kandenembo yodowoolo soboyelowelo ingooteno. No yodowoolo, hoolooweyelootoowe, kooduli nemimbo simoongo wileyo newendemo wiliyolo, boogoyelooteku, ngundilo tewelo ingooteno. Ene ye ngulo ma ingolo, no noyokowonggo. Ngundilo telo, ye Anutndo enengo ingondudu eyingo oni suleyelootoni yeno ooloutoyi, yendo ene yuleyi kumoolo, digi yolo, nolo ko onino oolongoolo, ene nguya yulewonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ngundilo ngulo, ye ingoyi! Anutndo ye yoyokootoni, ngulo ye kingo oluwanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Yo, no yeno hamoo eteno. Ye ko no ma neyolo oode oode oololo, yengo manggoyebo mete ko ewanggo. Anut, gedo oningga ngu gengo oowoonggemo ombuteku, ngu kumana inolo ewanggo. (Sam 118:26) ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesusndo Yuda onilo goobooyingo ya oowooyi Tempel ngu yokolo ooloutoni, ngu naluno nguno, enengo sulena oniku eneno ombulo, ene Yesus Tempel ngu ya digibo yeyingo, ngu etungowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ngundilo etungootoyi, Yesusndo mande gumi enedodo ewolo. Ye ngu oo ngu bidodo kenomukootenggo? No hamoo oolengo, yeno eteno. Ngundilomu, kootusina, Tempel ngu bidodo toongoolo yombuliyowanggo. Yo, digi gula yokootoyi, gula sanganimo ma oluwa. Nga digi nga bidodo usosowoolo, oolongooyi melako umukowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesus mela puli ngu oowooyi Olib, nguno oolelo, bibitetoni, enengo sulena onikundo nangge, Yesus tanggeyimo ombulo, sumoo inolo ewonggori. Ge nooleno e. Ndawu nalunggano, ngu ooga ngu tunootewa? Ge ko ombuweloyi naluno, ko nalu wengamo oo tunooteweloyi, ngu ndawu sunggiga? Ene ngundilo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesusndo enengo mande ngu ingolo, enebana gumi ewolo. Ye komo ingondale teyi! Ye oni yoyokootoyi, ngundo ye ma ganayelowelo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Oni oowooyingga oolengo no oowoonemonggo tunootelo, ngu ganayelolo, ngandilo ewanggo. No nangge, Kristus. Anutndo oni simoo bale yoyowelo elo, no sulenelootelo ewanggo. Ene ngundilo elo, nguno ene oni simoo bale oowooyingga oolengo ganayelowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kootusina, ye me ebe ngguyi ingolo, me ebe ngulo mande binga nguya ingowanggo. Ngundilo ingolo, ye ngulo ma sosolewelo. Ndawugalo ngulo, oo ngu hamoo tunootewaku, ene ngu nalu wenga kini. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ngu naluno nguno, oni sowe gulado ootookoolo, oni sowe gulaya ebe ulewali. Mela gulalo oo bidodo sobosobo oni, ngulo me oni, ngundo ootookoolo, mela gulalo oo bidodo sobosobo oni, ngulo me oniya ebe ulewanggo. Ngundilo nangge, mela bidodomo, simoo bale oodoolo kumooyingo ulungga tunootetoni, mela guminggano, ngu imimi ulungga yowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Yo, baledo simoo yomoowelo ogingoyingo ulungga koletelo ingooteku, ngu ye ingootenggo. Ene simoo yomooweloyi ngu namoko. Ngundilo nangge, ye ngu oo ngu tunootetoni kenolo ngu, asa, ye ingowanggo. Nalu wenga ngu namoko tetelo ingowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Yo, ngu naluno, me onindo ye yodowoolo, ogingoyingo ulungga kowuli nguya yunolo, yuleyi kumoowanggo. Mela bidodomo, oni simoo baledo ngundilo damoni biyomi yeno tetoyi ngu, ndawugalo ngulo, no oowoone yeno oodoni, ye nowoondoye nono hamoo tetenggokulo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kootusina, kowuli ulungga tunooteweloyi naluno, oni oowooyingga Anutno nowoondoye hamoo teyingo, ngu kowulingga ngu koolowooweloyi ma ingowelo. Ngundilo ngulo, enengo nowoondoye hamoo teyingo, ngu yokolo, ene ko ma keyowanggo. Ngundilo telo ngu, ene dobooguliye Anutlo pawa newendemo oolootenggoku, ngu yodowoolo, me oni kandeyemo yelo, ene nguya ngu oni Anutno nowoondoyemo hamoo teyingo nguya boguwoolo, sanggili tewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ngu naluno, Setanlo ingondudu ewo oni ebe ganagana oowooyingga, ngundo tunootelo, oni simoo bale oowooyingga oolengo ganayelowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ngu naluno, mela bidodomo, damoni biyomi ulungga oolengo ngu tunootetoni, nguno ngu, oni simoo bale enengo ingondudu nangge keyowanggo. Ngundilo ngulo, enengo nowoondoye ebe ino ino teweloyi damoningga, ngu yokowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ene oni simoo bale Anutno nowoondoye hamoo teyingo, ngu yanggango oode oode oololo, nalu wengamo nguya oodoyi ngu, asa, Anutndo ngu ko yoyowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Kuli ngandilo kowulingga ma tunooteyingomo, ariya, koletelo, Anutndo enengo ko oni suleyelootoni, mela bidodomo salo, oni simoo bale sowe oowooyingga nguno Anutlo mandeni damoningga, ngundo enengo oni simoo bale soboyelooteku, ngu wesiyolo yunowanggo. Ngundilo sunggiga ngu temukootoyi ngu, asa, hamoo oolengo, nalu wenga nguno tunootewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Yesus mande gula soweyolo ewolo. Ngu oo biyomi oolengo, Setan ngundo Anutlo kundingiyi oolengo musiyomo dikatoni, ye ngu kenolo ingolo ngu, asa, ye ingowanggo. Kuli Anutlo ingondudu eyingo oni Daniyel, ngundo mande ngundilo eyingo, ngu ataga engge tunootetelo ewolo. Oni gula nga mande oo naka nga kandangeya, ene komo gome ingoni. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ngu naluno nguno, oni simoo bale Yudiyano oolootenggoku ngu, ene komo mete sodedo salo, pulimo oolewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Oni endesina oolootenggoku ngu, ene ko ya newendesina ulo, enengo oo sitowi yoweloyimbolo ma uwanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ngundilo nangge, oni kono oolooteku ngu, ene ko oololo, ya newendesina ulo, enengo dokikilo nenggulo yoweloyimbolo ma uwanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Yo, ngu naluno, bale useyedodo, ko, bale simooye nono yunootenggoku, ngulo oni oni yooge! Ndatelo ngulo, ene sodedo kendutelo, mela pulimo ooleweloyi, ngu ereremo kini. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ngulo ye komo yemboongeyi. Doogo dokiki, ko, sono medugu naluno, ngundi, kundingiyi naluno nguno oo ngundilo ngu ma tunootewelo. Ndatelo ngulo, ngu nalu biyomimo tunootetoni ngu, oni pulimo ooleweloyi, ngu ereremo kini. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ngu naluno nguno, kowuli ulungga oolengo tunootewa. Kulimi oolengo, Anutndo oo bidodo yewo naluno, ngunonggo ombulo, ataga nga naluno ngano nguya, kowuli ngundilo kuli ma tunootewolo. Kootusina nguya, kowuli ngundilomu nguya kini. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ene Oo Sembuli Ulungga, ngu kowuli nalungga ngu woosootoni, ma ootutetoni ngu, ariya, oni simoo bale bidodo Anutndo kuli logoyeloyingo, ngu keda oluweloyi ereremo kini. Ngulo ngu, ene ngu nalungga ngu woosootoni ootutewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ngu naluno nguno, oni gulado yeya ewaku ngu, kenoyi, Kristus nga oolooteku nga; ngundi, kenoyi, ene andusina oolooteku andu! Ene ngundilo etoni ngu, ye ngulo nowoondoyemonggo hamoo ma tewelo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ngulo ngu, Setanlo ko oni gidalegado tunootelo, ganayelolo elo, no Kristus, Anutndo noole yoyowelo sunggi yewo onilo ewanggo. Ngundi, Setanlo ingondudu eyingo oni ebe ganagana, ngundo elo ewanggo. No Anutlo ingondudu eyingo onilo ewanggo. Ene sunggi guladilo guladilo sungo sungo tewanggoku, ngundo damoni sungo oolengo gula onindo ma teweloyim, ngundilo telo, simoo bale Anutndo kuli enengo logoyelowoku ngu, ene mete tetoni ngu, ene ngu ganaganayelolo yoyoweloyimbolo tewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ingoyi, no oo bidodo kootusina tunooteweloyi, no ataga yeno etoowe, ye ingootenggoku, ngulo ye komo ingondale teyi! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ngundilo nangge, oni gulado yeya elo, kenoyi, ene andesina oni kini kingo melako oolooteku ande, etoyi ngu, ye nguno ma oolouwelo. Ngundilo nangge, ene ko ewanggo. Kenoyi, ene nga yangga nga newendemo kombitelo oolooteku nga! Etoyi ngu, ye enengo mande ingootoyi nowoondoyemo hamoo ma tewelo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Yo, yowali soluyi sa ooletekusinanggo delo oololo, sa utekusinanggo delo toongete. Yowaliwali soluyi kenooteku, ngundilo nangge, no Anutlo Nangoni Oni Kilalongo ngu tunoo oolengo neyootoyi, ko ombuwano. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ngu naluno, mela gumisina punggi ululumelo, oololo, ombulo tetoni, ye bidodo nguno kenolo tunoo ingowanggo. Oo buwoo gula ngu melasina nguno ooloote. Ngundilo nangge, no ko ombutoowe ngu, ye bidodo tunoo oolengo ingowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Yesusndo mande gula ewolo. Ngu kowuli ulungga ngu kinitetoni ngu, ariya, sa kombo nguya doobeyelootoni, himi ma yewali. Dootu bidodo ngu yokutuwoolo sisolewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ngu nalunggano nguno, no Anut Nangoni Oni Kilalongo, nolo sunggi Sambono tunootetoni, melako oni simoo baledo kenolo sendowanggo. Ndatelo ngulo, no Anut Nangoni Oni Kilalongo goobooleno dulidalinedodo, yanggangone oolengododo ombutoowe neyowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Anutlo unggu gula oowooyi Biyugel ngu yanggango uwootoni, ngu naluno, Anutndo enengo Sambono Engel oniku ngu suleyelootoni, ombulo, mela bidodomo, ende oowooyingga bidodomo oololo, oni simoo bale Anutno nowoondoyemo hamoo teyingo, ngu bidodo yoyolo, ombulo, eneno watayewanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","33","Yesusndo mande yamonggawo gulalo ewolo. Ye Kopi dega ngu kenoya, ko, de gidalega nguya yeyoyi. Ye kenootoyi, nungo yelo, busiyo yetoni, ye ngu kenolo ingootenggo. Ataga Kopi enggeweloyi naluwo tunootewelo tetelo ingootenggo. Ngundilo nangge, kootusina, ye ngu ooga ngu kenootoyi, tunootewaku ngu, ariya, ye nguno ingowanggoku ngu, ngu ooga ngu, Yesus ko ombuweloyi naluwo namoko tetoni, ngulo sunggi ngundilo tunootewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","No hamoo oolengo, yeno eteno. Ataga nga naluno, ye Yuda sowengga ngalo simoo bale nga ma kumoomukoyingomo, nga oo nga bidodo tunootewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Sambo mela nguya ngu oololo kinitewa. Ene ngundilomu, nolo mandene nga ngu ma kinitewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Yesus mande gula ewolo. Oni ngu nolo nalu ko ombuweloyiga, ngu sangga nguya, ene ngu ma ingootenggo. Anutlo Engel oni Sambono oolootenggoku ngu, ene nguya ma ingootenggo. No nguya, ene ma ingooteno. Awane Anutndo nangge ngu ingoote. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ngundilo damoni onindo kuli Nowa oodoni, nguno tewonggoku, ngundilo nangge, no Anut Nangoni Oni Kilalongo ombutoowe, nguya damoni ngundilo tewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Yo, kuli Nowalo naluno, koletelo Anutndo sono tuwi ulungga oolengo suleyootoni, ombulo, mela bidodo ma doobengoyingomo, ngu naluno, oni simoo bale oo nelo, sono nelo, kamebale teloodoyi, Nowa nguno wanggo newendemo uwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ene ngundilo telo, Anutndo oo yeni tunooteweloyi, ngu ene ma ingowolo. Ngulo Anutndo sono tuwi ulungga oolengo suleyootoni, ombulo, mela bidodo doobengootoni, oni simoo bale yutomukowolo. Ngundilo nangge, nalu wenga oolengomo, no Anut Nangoni Oni Kilalongo ombutoowe, ngundilo damoni nguya tunootewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ngu naluno nguno, oni elaya kono oluwaliku ngu, Anutndo ombulo, oni gula yolo, gula kono yokowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ngundilo nangge, bale elaya oomanongoyingo tetoli ngu, Anutndo ombulo, gula yolo, gula yokowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ariya, no yeno hamoo oolengo eteno. Ye ingondale teyi! Ndawugalo ngulo, Oo Sembuli Ulungga ngu ombuweloyi nalungga, ngu ye ma ingootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ene ye komo ingoyi! Ya sembuli (Kristen) ene ndawu nalunggano yakaka oni ombulo, ya usowooweloyi ngu ingolo ngu, ariya, ene meyelo oodoni, yakaka oni ombulo ngu, ene ya usowooweloyi, ngu ereremo kini. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ngundilo nangge, ye nguya komo meyeya, doongeteya oliyi! Ndatelo ngulo, no Anut Nangoni Oni Kilalongo ombuweloyi nalu ngu, ye ngulo ma ingondudu tetoyi, nguno no ko ombuwanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ya sembulibo ene mela gulasina toongewelo ngu, ene ko oni gomengga ingondudu gome ngu sunggi yetoni, ngundo ya ngulo ko oni sobosobo gome ootoolo, oo neweloyi naluno, oo nenengo yunootoni, oo nelo gome oluwanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ngundilo nangge, kootusina, ya sembuligaku ko ombulo, ko oninggakuya oo ewoku, ngundilo tetoni, kenolo ngu, ariya, enengo ko oni sobosobogaku, ene mete oni oni tewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ariya, no yeno hamoo eteno. Ngu ya sembuliga, ngundo ko sobosobo oninggaku yelo, ngulo oo nggilinggala bidodo, ngu ko oningga ngu kandeyimo yetoni, gome sobowoowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","49","Ngundilo nangge, ngu ko sobosoboga ngulo damoni biyomi oluwaku ngu, enengombo ngundilo ingolo ewolo. Nolo sobosobo oni ulunggaku nalu oowooyingga ngu ma ombuwolo. Ene ngundilo ingolo, ngulo ene damoni yelo, enengo ko goboolo oni yutolo, ene oni gidalega ngu oowali nelo, sono biya gome gome nelo, kapengo yelo oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Kootusina, nalu gulano, ngu ko sobosobo oni biyomingga, ngu enengo sobosobo oni ulunggaku ombuweloyi nalu ngu ma ingolo oodoni, ariya, enengo sobosobogaku ombulo, ko oningga ngulo ko biyomi tewoku, ngu kenowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ko biyomi ngundilo kenolo ngu, asa, ngu ko sobosobo oni biyominggaku ogingoyingo ulungga inolo, suleyootoni, oololo, oni mebuye sangala oni oolootenggoku musiyo biyominggano, nguno ene nguya oluwanggo. Ngu ende biyominggano nguno, sendo ulungga telo, metokalikali telo oluwanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ngu naluno, Anut Oo Bidodo Sembuli Sembunaye, ngundo nalu enengo oni simoo bale ngu soboyelooteku, ngundo nga bale kosiyi simoondoya ma weleyingo kande elayaga, ngulo damoni ngu ngandilo. Simoo gula bale yoweloyi naluno ngu, ngu bale ko enengo bale doboogulingo mayelo, ngu balega ngundo yano kameyinggaku ombuweloyi, ngu sobowoolo oluwanggo. Ariya, ngu simoongga ngu baleyi yoweloyimbolo ombutoni ngu, enengo baleyi ngulo doboogulingo ngu kameyi ombutoni ngguyi ingolo, ngulo ene solu kalo dowoolo, endesina oolelo, doongetelo, kameyi kenoweloyimbolo oolewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Asa, baleyi doboogulingo kande elaya ngulomu kandegula ngu ingondudu kini, ko, bale kandegula ngu ene ingonduduyedodo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Bale ingonduduye kiningga enengo solu ngu yowonggoku, ene Karasin ngu ene ma yowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ene bale ingonduduyedodo ngu, enengo solu, ko, Karasin nguya nggusingolo, ngu yolo ombuwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ene bale yowoku oninggaku, sodedo ma ombutoni, ngulo baleku kubooyelootoni welewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Suwoo kewooloko oni meno mogulu telo, ewolo. Bale yowoku oninggaku ombuteku ngu! Ngulo ye oolouya, ooleko kenoya, yoya ombuyi! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ariya, baleku ngu ingolo ootookoolo, enengo solu yomosiyolo yoonenengowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Asa, ngu naluno nguno, bale ingonduduye kinikundo bale ingonduduyedodokuya ewonggori. Yendo Karasin gula noole yunootoyiga nggusingowato. Noolendo solungga kumoowelo teteku ngalo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ene ngulo mande ingolo, enebana gumi ewonggori. Kini, noole Karasin ye nguya ko noole nguya logoyimo kini. Noolengo logoyimo nangge. Ngundiloga ngu, mete ye oolouya, Karasin gula uliyoyi. Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ariya, ngu baleku Karasin uliyowelo ooloutoyi ngu, ngu naluno nguno, bale yoweloyi oninggaku ngu ombuwolo. Bale kandegula ngu enengo solu kuli yomosiyolo, yoonenengolo oodoyi, bale yoweloyi oninggaku ngu ombulo, bale yolo, ngu bale kosiyi kandegula nguya hoolooweyeloweloyi, ngu bidodo yoyolo, ya oo simbo kayingo yanggakuno utoyi, ene yamako goodoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Kootusina, bale kandegulagaku Karasin uliyowonggoku ngu ombulo, yamako utolo ewonggori. Ulungga, ulungga, ombuya, noolengo yamako goosooyuno! Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ene ngulo mandeye ingolo, enebana gumi ewolo. No yeno hamoo eteno. No ye watayi kinilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Asa, Yesusndo mande gula soweyolo ewolo. Ye komo ingondale teya sobowooyi! Ye oni gulado ombuweloyi nalungga ngu, ko sangga nguya, ye ma ingootenggololo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yesusndo mande yamonggawo gula ewolo. Anut Oo Bidodo Sembuli Sembunaye, ngundo endega enengo oni simoo bale soboyelooteku, ngu ngandilo. Oni gula mela yowokono oolouwelo ngu, ariya, ngu enengo ko oni negoyelootoni, ombutoyi, enengo oo sitowi ko oni ngu kandeyemo yetoni sobowooweloyimbolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Sobosobo oninggakundo enengo ko oniku wilikoyelolo, damoniye yanggangoye kenolo, ingolo, ngulo ene ngundilo bobeye andangelo yunowonggori. Enengo sulena oni ngulo damoniye metemi oolengo kenolo, ngulo ene ngu oninggaku ya sembuligakundo bobeye oowooyingga oolengo K5,000 Kina sobowoonilo inowolo. Enengo sulena oni ngulo damoniye metemi kenolo, ngu oninggaku sobosobo oninggakundo bobeye oowooyingga K2,000 Kina sobowoonilo inowolo. Ngundilo nangge, ko oni gulalo ene bobeye K1,000 Kina sobowoonilo inowolo. Ngundilo telo ngu, ene yoyokolo, yowokono toongewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Toongetoni ngu, ariya, enengo ko oni bobeye K5,000 Kina yowoku, ngundo ko yanggango telo, ngunonggo digi gumi K5,000 Kina gula ngundilo soweyolo yowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ngundilo nangge, oni gulado digi beye K2,000 Kina yowoku, ene nguya ngundilo koyi telo, digi K2,000 Kina gula yowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ngundilo nangge, ko oni bobeye K1,000 Kina yowokunggaku, ene digi yolo, oololo, mele selo, nguno sobosobo oningga ngulo bobeyeku, nguno oongoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Kootusina, nalu kinitetekuno, sobosobo oningga ko mayelo, enengo ko oni kabusagaku yeyolo, bobeye yunowoku, ngulo mande ingowelo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ariya, ko oni bobeye K5,000 Kina yowoku, ene ko telo, ngunonggo digi K5,000 Kina ko yolo, enengo oo sobosobo onikuno oololo ewolo. Oo ulungga, ge kuli digi K5,000 Kina nunowoku, nguno nenengombo ko yanggango telo, digi K5,000 Kina gula soweyolo yowonoku, nga kenolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Enengo oo sobosobo oninggakundo enengo mandeni ingolo, enebana gumi ewolo. Ge ko oni gome oolengo! Gedo ko gome hamoo tewo! Gedo nga bobeye bodaga sobowookulo, ngulo no digi beye oowooyingga gunootoowega sobowoo lo. Ariya, yano ombutooga, noya oni oni tewalo. Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ko oningga bobeye K2,000 Kina yowoku, ngundo bobeye K2,000 Kina gula soweyolo, yolo, ombulo, oo sembulinggaku etungolo ewolo. Oo sembuli ulungga, gedo bobeye K2,000 Kina nunowoku, ngundo ko yanggango telo, bobeye K2,000 Kina gula ko yowonoku, nga keno. Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Etoni, enengo oo sobosobo oninggakundo enedodo mande gumi ewolo. Ge ko oni gome! Gedo gome oolengo telo, ko gome tewo! Gedo nga bobeye bodaga gome sobowookulo, ariya, ngulo no bobeye oowooyingga gunootoowega sobowoo lo. Ngulo ngu, yano ombutooga, noya oni oni tewalolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ariya, ko oni gula bobeye 1,000 Kina yowoku, nguya ombulo, oo sobosobo oni ulunggano ewolo. Oo sembuli ulungga, no kuli ingootenoku, ge bobeye woosoolo, yoweloyi oni yanggango. Ge onindo kononggo oowali, gedo ma imiwoko, ngu yoote. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ngundilo ngulo, no gengo sosolelo, ngulo bobeye nunowoku, no sodedo oololo, mele selo, nguno oongoowono. Ngu digi beye nunowoku ngu, nga oolooteku ngalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","27","Asa, oo sobosobo oni ulunggakundo sanggili telo, mande gumi ewolo. Ge ko oni biyomi oolengo! Ge suleyokinikini oni! Ge kuli ingooteku ngu, no onindo kononggo nondo oowali ma imiwoko, ngu yootenoku, asa, ndawugalo ngulo, ge bobeye sobowoo, elo gunowonoku, ngu bobeye yeweloyi musiyomo, nguno ma yewo? Noole bobeye ngundilo oolooteku ngu, no ko ombutenokuno, ariya, ngunonggo bobeye gula nguya yolo, gooboongoolo yowano. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ariya, oni ulunggakundo enengo ko oniya ewolo. Ye ngu oningga, bobeye K1,000 Kina inowonoku, ngu sopiyoya, nolo ko oni gome bobeye K10,000 Kinadodoga, ngu inoyi. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ndawugalo ngulo, oni gulado oo oowooyingga ngu gome sobowoowaku ngu, ariya, no oo oowooyingga gula soweyolo inowano. Ngundilo nangge, oni gulado oo bodaga ngu biyomi sobowoowaku ngu, asa, ngu oo bodaga ngu dowooteku, ngu andangelo yokowano. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Yo, ngundilo ko oni biyomingga ngu owetoowe, endeloko mela uleriko ootoolo, ngunonggo sendo ulungga telo, metokalikali telo oluwanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yesusndo mande elo yokolo ngu, asa, yowoolengolo, enengo sulena onino ngandilo ewolo. Kootusina, no Anut Nangoni Oni Kilalongo nenengo dulidalinedodo ko ombuwano. Nenengo Sambono Anutlo Engel oni ngudodo ombulo, ngu naluno dulidalinedodo nenengo yaba bingaminedodo nguno bibitewano. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ngu naluno nguno, oni simoo bale nono mayelo gooboongootoyi, nondo wilikoyelolo, wata elaya yoyewano. Yo, sobosobo onindo Sipsip andangelo, pawa gulano yelo, bo Meme andangelo, pawa gulano yetenggoku, ngundilo tewano. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","No Sipsip ngu andangeyelootoowe, ngu kandene koondosina ooloutoyi, ngundilo nangge, bo Meme ngu andangeyelootoowe, ngu kandene biyomisina oolouwanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ngundilo ngulo, oo bidodo sobosobo koleteyingo oningga, ngu enengo kandeyi koondosina oolootenggoku nguya ewa. Ye Awanembo kumana yunowa! Kuli mela nga keda tunootetoni, Awa ngundo endega enengo oni simoo bale soboyelooteku, ngu kuli yomosiyoyunowoku, ngu endegano nguno uwanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ndawugalo ngulo, kuli no oodoolo kumootoowe, nguno yendo oowali yolo nunowonggo. No sonolo ingootoowe, nguno yendo sono yolo nunowonggo. Ngundilo nangge, no ende gula oni, ene yendo noyolo, yengo yano uwonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ngundilo nangge, no towi kinimu, nguno yendo towi nunowonggo. No sayi yootoowe, nguno yendo yomosinelowonggo. Ngundilo nangge, no ya biyomimo oodoowe, ye nguno oololo neyowonggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ngu oni kandeyi koondosina oolootenggoku, ngundo sumoo inolo, ngandilo mande gumi ewanggo. Oo Sembuli Ulungga, ndawu nalunggano, ge oodoolo kumootoyi, oowali gunowooto? Ko ndawu nalunggano, ge sonolo ingootoyi, nguno noolendo sono gunowooto? ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ndawu nalunggano, ge ende gula onimu geyolo goyolo, noolengo yano uwooto? Ko ndawu nalunggano, ge towikumba kinimu, nguno noolendo towikumba gunowooto? ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ndawu nalunggano, ge sayidodo telo, ngundi, ge ya biyomimo oodoyi geyowooto? Ene ngundilo elo, sumoo ewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Yesusndo enengo mandeye ngu ingolo, enebana gumi ewa. No hamoo oolengo, yeno ewano. Ye melako ngano nolo konedoboonengga oowooyi kinimu, ngu yomosiyowonggoku ngu, asa, ye no nguya yomosinelowonggo. Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ngundilo nangge, no oni kandene biyomisina nguya ewano. Ye oonateweloyi oni! Ye noyokoya, de nombo ma kumooweloyi, nguno oolouyi! Ngu de nombo ma kumooweloyingga ngu, ngu yengo Awaye Setando nguno enengo Engel oni biyomidodo oliyilo yewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ndatelo ngulo, no kuli oodoolo kumootoowe ngu, nguno yendo oowali no ma nunowonggori. Ngundilo nangge, no sonolo ingootoowe ngu, nguno ye sono yolo, no ma nunowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","No ende gulalo onimu oluwonoku ngu, ye noyolo, yengo yano ma uwonggori. Ngundilo nangge, no towikumba kinimu, nguno yendo towikumba ma nunowonggori. No sayi kumoolo, ko, ya biyomimo nguya oluwonoku, nguno ye ombulo, ma neyolo hooloowenelowonggorilo ewano. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Yesusndo ngundilo etoni ngu, enebana mande gumi ewanggo. Oo Sembuli Ulungga, ndawu nalunggano noole geyootooye, oodoolo kumoolo, sonolo ingolo, ngundi, ge ende gula oni, ngundi, ge towikumba kini, ngundi, ge sayi kumoolo, ko, ge ya biyomimo nguya oodoyi, nguno noole ge ma yomosinggelowooto? Ngundilo sumoo ewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ngundilo sumoo etoyi ngu, asa, Yesus enebana mande gumi ewa. No hamoo oolengo, yeno eteno. Ye melako ngano oni gula oowooyi kinimu, ma yomosiyoyingo ngu, ye no nguya ma yomosinelowonggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ngundilo ngulo, ngu oni ngu uli biyomi yolo, Setanlo ende de nombo ma kumooweloyingga, nguno oolongooyelootoowe, sugi sugi ogingoyingo yolo oluwanggo. Ngundilo nangge, oni nenengo kandene koondosina oolootenggoku, ene ngu musiyo metemimo nguno, Anutya sugi sugi keda oluwanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesus mande bidodo etuyelomukolo, yokolo ngu, ngu naluno, enengo sulena oniya ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Ye kuli ingootenggo. Nalu elayaga nguya yokolo, Anutlo sunggi kenolo, dagayeloyingo naluwo, oowooyi Pasowa, ngu tunootewa. Ngu naluno, no Anut Nangoni Oni Kilalongo, onindo no mundi oni kandeyemo yootunonelolo, de mombimo nuleyi kumoowanolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ngu nalu nguno, Anutlo woolo yewo oni kundingiyi sobosobo oniku, ko, Iserel onilo tabango oni bidodo, Kayiyapaslo ya gome oolengo, nguno gooboongoowonggori. Kayiyapas ngu Anutlo woolo yeyingo oni kundingiyi sobosobo oni koletewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Yo, tabango onindo gooboongoolo, ene oole erewelo mande gosiyolo, Yesus yolo, ya biyomimo yewelo telo, uleyi kumooweloyimbolo tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ene ngandilo ingondudu telo ewonggori. Noole nalu kundingiyimo, ngu ooga ngu ma tewato. Ndatelo ngulo, oni simoo baledo me ebe ngu yeyi tunootewalo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ngu naluno nguno, Yesus Betani endemo oololo, kuli oni golimambudodoga oowooyi Sayimon, ene ngulo yano oolouwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ngu naluno nguno, bale gula ombulo, ngu nggusiyi gome oolengongga digibo teyingo, ngu kumu bo ulumi gula ndindingo gomemu oluwoku, ngu ulini ulungga yokolo uliyowolo. Ngu oo ndindingo gomengga ngu yootoni, Yesus ene oo neweloyi yabano bibitetoni ngu, ene ngu bo ulumi nggusiga ngu Yesus tabangomo wendowolo. Ngu balega ngundo damoningga teyingo ngu, ene Yesuslo gome oolengo ingolo, ngundilo telo etuyelowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Enengo sulena oni oluwonggoku, ngu kenolo, nowoondoye biyomi yelo ewonggori. Ndawugalo, nga bo ulumi gomengga nga kingo yombuliyoote? ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nga ngu oni yunootoyi, ngundo uliyootoyi ngu, ngulo ulini ulungga yolo, ngundo mete owoolongo oni yunoweloyilo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesusndo enengo nowoondoye kuli kenolo, ingolo ewolo. Ndawugalo, ye nga balega nga kowuli inootenggo? Ene damoni gome ngu nono tete. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Owoolongo oni ngu yeya suwoo suwoo oluwanggo. Naludodomo, ye mete ene hoolooweyelowanggo. Ene no ngu, yeya suwoo suwoo ma oluwato. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Balega ngundo ingolo, tenunooteku nga, ene bo ulumi no gowenemo yeteku ngu, ene no meleno noyeweloyi, ngulo no yomosineloote. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","No hamoo oolengo yeno eteno. Mela bidodomo, Anutlo Mande Keda Mesalango ngu wesiyolo, ewanggoku ngu, nga bale ngando teteku nga nguya mandeni elo, ngulo nguya ingondudu telo ingowanggo. Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ngu nalunggano nguno, Yesuslo sulena oni kande elaya kegidembolo elaya, ngulomu gula, Yudas Iskariyoot, ngundo ene Anutlo woolo yeyingo oni kundingiyi ngulo sobosobo onikuno oolouwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Yudasndo eneno sumoo ewolo. Yendo ndawuga ngu nunootoyi, Yesus yolo, ombulo, kandeyemo yunowano? Elo ewolo. Enengo mande ngundilo ingolo, ariya, ene bobeye doobe kabusa (30 Kina) kandeyimo yewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ngu naluno, Yudasndo damoni yelo, oole erewelo, ndawu nalunggano Yesus yootunolo, me oni kandeyemo yeweloyimbolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Kowooyingombolo nalu koleteyingo, oomanongoyingo Yis kini neweloyi naluwo tunootetoni, sulena oni Yesusno ombulo, sumoo ewonggori. Gedo ngu noole ndano saya, nalu kundingiyi ngulo oowali yomosiyolo, neweloyimbolo ingoote? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yesusndo enengo mandeye ngu ingolo, enebana gumilo ewolo. Ye ende gulano uya ngu, oni gula Anutndo sunggi yewoku, nguno oolouya, ngandiya eyi. Oo etuyeloyingo oningga, ngundo ete. Nolo nalu namoko tetoni, ngulo no nenengo sulena oniya gedo yano oowali kundingiyi newatolo ete, ngundiya eyi. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ene ngundilo etoni, ariya, sulena oniku ulo, Yesusndo ewoku ngundilo telo, ene oowali kundingiyi ngu yomosiyowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Suwootetoni, enengo sulena oni kande elaya kegidembolo elayagakudodo, oo neweloyi yabano bibitewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Oo nelootoyi, Yesusndo ewolo. No hamoo oolengo, yeno eteno. Oni gula ye kewooloyemo nganonggo, windoga no yootunonelolo, me oni kandeyemo noyewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Sulena oniku enengo mandeni ngu ingolo, ngulo ene nowoondoye kowuli ulungga ingolo, gulanangge nangge oololo, Yesus sumoo inolo ewolo. Ge noya ete, bine? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ngundilo etoyi, asa, Yesusndo mande gumi ewolo. Nga oningga noya kandenali koondomo goboolo yetelokungga, ngando me onino yootunonelowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Yo, oo bidodo kuli Anutndo enengo mande nakangoyingo ngu, no Anutlo Nangoni Oni Kilalongo, nono engge ngundilo tunootewa. Ngundilomu oningga no Anut Nangoni Oni Kilalongo, me onindo oni yootunonelooteku ngu, ngu oni yooge! Yo, no ngu oningga ngu oni yooge, ene nemimbo ma yomoowoolo ngu, kowuli ngundilo ngu eneno ma tunootewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ngu naluno, Yudasndo me oni kandeyemo yewelo mande gosiyowoku, ngundo Yesusno ewolo. Oo etuyeloyingo oni, ge noya ete, bine? Etoni, Yesusndo mande gumi ewolo. Gengombo eteku ngu nanggelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ene oo nelo oodoyi, Yesusndo oomanongoyingo gula yolo, Anutno yemboongelo, oosowoolo bayetelo, yunolo ewolo. Nga yoya neyi. Nga nenengo songgiwinelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","28","Ngundilo elo ngu, ene Wayin sonoyi tobaga ngu yolo, Anutno yemboongelo, yunolo ewolo. Ye bidodo nga Wayinngga nga neyi. Ngangga nga, ngu nenengo dalone. Nga dalonengga, ngando Anutndo sunggi mande keda ewoku, ngu gosiyoote. Ngu no oni simoo bale oowooyingga ngu, enengo mbumbuwaye andangewelo ingolo, nenengo dalone enengo wendowano. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ngulo ngu, no yeno hamoo oolengo eteno. No nga Wayinngga nga ko ma newano. Kootusina, Anutndo endega nguno enengo oni simoo bale soboyelooteku, ngu Sambo endegano nguno, no Wayin sonoyi keda yeya, ko newatolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ngundilo telo ngu, asa, ene Anutlo bingami okoolo, yambo gula utolo yokolo, kootusina ootookoolo, pulingga oowooyi Olib, nguno oolewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ngu naluno nguno, Yesusndo sulena onikuya ewolo. Nga suwoongga ngano, yengo nowoondoyemo hamoo teyingo ngu, nono yombuliyowanggo. Yo, hamoo, ye bidodo noyokolo sawanggo. Kulimi, Anutlo mandeno ngu ngandilo nakangolo ewolo. No Sipsip Sembuli utoowe, ngulo Sipsip sosolelo, mela bidodomo sungo sungo sawanggo. Ngundilo nakangolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ene no melenonggo ko ootookoowanokuno, nguno no ye koletelo, Galili melako oolouwanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ene ngundilo etoni, asa, Pita Yesusya mande yanggango gumi ewolo. Oni bidodo ngu ge goyokolo, satoyi ngu, ene nondo ngu ge ma goyokolo toongewanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesusndo enengo mandeni ngu ingolo, enebana gumi ewolo. No geno hamoo eteno. Nga suwoonggano ngano, kooduli ma eyingomo ngu, ge tambu kabusa no oowoone oongoowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ngundilo etoni ngu, Pitando Yesusya mande yanggango gumi ewolo. No mete geya kumoowaloku ngu, no ge oowoongge ma oongoowanoku ngu! Hamoo oolengo, kini! Etoni, sulena oni bidodo mande gulanangge ngundilo nangge ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ngu naluno nguno, ene oololo, musiyo gula oowooyi Gesemani, nguno oolouwonggori. Nguno Yesusndo enengo sulena onikuno ewonggori. Ye ngano bibiteya oliyi. Oodoyiga, no oololo, anduno Anutno yemboongewelo. Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Yesusndo sulena oni kabusa yoyolo, enedodo oolouwonggori. Ngu sulena oniku ngu, Pita ko Sebedi simoongo elaya, ngundo oolouwonggori. Nguno ngu, Yesus damoni yelo, newende kowuli ulungga oolengo ingowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ngundilo ingolo, ene sulena oni kabusagakuno ewolo. No gabone kowuli ulungga oolengo yelo, ngundilo telo, namoko yombulinelowa. Ngundilo ngulo, ye ngano ootooya, ye komo ingondale meyeya soboneloyilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Yesus ngundilo elo, ene bodaga sungo oololo, melako penggootelo welewolo. Ngundilo telo, Anutno yemboongelo ewolo. Oo Awane, nga toba kowuli ogingoyingo ulungga nga, ngu mete gedo andange. Ene ge nolo ingondudune ma keyowelo. Kini, no gengo ingonduduge ngu nangge keyowanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ngundilo yemboongelo yokolo ngu, ene ootookoolo, sulena oni kabusagakuno oololo, yeyootoni, wetoloodoyi, yeyolo, Pitaya ewolo. Ndawugalo, ye kabusaga nalu bodagano, no ma sobonelowonggo? ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ye gome sobowooya, yemboongeya, ngundilo tetoyi ngu, Setando tewooyelootoni ngu, ye yanggango oluwanggo. Hamoo, ye nowoondoyebo ngu tewelo ingootoni, ene goweyebo ngu suleyeyokiniyelo yanggango ma yetelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ngundilo elo, ene tambu elaya ko oololo, Anutno yemboongelo ewolo. Oo Awane, ge nga tobagano ngano sono neni, elo ingolo, ma yolo yokowaku ngu, ariya, no bidodo nemukolo, gengo ingooteku, ngu nangge keyowanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ene ngundilo yemboongelo elo yokolo, ene sulena onino ko oololo, yeyootoni, ene kubooyelootoni, ene wetololuwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ngundilo yeyolo, ene yoyokolo, ko oololo, tambu kabusa koletelo yemboongewoku, ngu ngundilo nangge, ko yemboongewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Yemboongelo yokolo ngu, enengo sulena onino ko ombulo ewolo. Ye komo kengelo, wetolo, oolootenggo, bine? Ye ingoyi! Ataga, no Anut Nangoni Oni Kilalongo me oni, ngundo noyolo, mbumbuwadodo me oni kandeyemo noyewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ariya, ye ootookootoyiga oolouwooto. Kenoyi! Me oni no yootunonelolo, oni sanggili kandeyemo noyeweloyi oninggaku ngu, ombuteku andu! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesusndo mande ewootoni, Yudas Yesuslo sulena oni kande elaya kegidembolo elayaga, (12) ngulomu gula me oni oowooyinggadodo gooboongoolo ombuwonggori. Yo, me oni oowooyingga nguya duge, mata komuko ebe uleweloyi oo ngu yootoyi, Anutlo woolo yeyingo oni kundingiyi ngulo sobosobo oniku, ko, Yuda onilo tabango oni, ngundo suleyelootoyi ombuwonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Windoga oni Yudas, ngundo kuli sunggi gula yunolo ewolo. Nondo ngu oningga kandeyi dowoolo, yenggonangootoowega ngu, ngu oningga ngu Yesus. Ngu dowooya, yoya oolouyilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Asa, Yudas sodedonangge Yesusno oololo ewolo. Oo etuyeloyingo oni, suwoo gome elo, ene kandeyi dowoolo yenggonangowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ene ngundilo tetoni, asa, Yesusndo mande gumi ewolo. Doboone, ooga tewelo ingolo, ombuteku ngu, asa, sodedonangge te! Elo ewolo. Ngundilo etoni ngu, me onikundo Yesusno kandeye oolongoolo dowoowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ngundilo tetoyi ngu, asa, Yesuslo sulena oni gulado kewooloyemonggo sanggili telo, enengo duge woosoolo, yolo, ngundo Anutlo woolo yeyingo oni kundingiyi ngulo sobosobo oni koleteyingo, ngulo sulena oninggaku doongoolo ulewelo tewolo. Ngulo ene duge oolongootoni, woosoolo ooloutoni, sodeyi nangge takatoni solewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesus ngundilo kenolo ngu, enengo sulena oningga nguno ewolo. Gengo duge ngu ko musiyomo ye. Oni bidodo dugebo oni uleyi kumoowanggoku ngu, ene nguya dugebo yuleyi kumoowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ge komo gome ingo! No mete Awanemo meno etoowe, enengo Sambo Endemo oni oowooyingga oolengo suleyelootoni, ombulo, hooloowenelowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ene no ngundilo tewanoku ngu, oo bidodo Anutndo kuli elo nakangoyingo, ngu engge nenengo ma tunootewa. Ngundilo ngulo, ene komo oo ewoku, ngundilo nangge, tunootewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ngu naluno, Yesusndo me onikuno ewolo. Ye ndawugalo duge, mata komuko ebe uleweloyi oo ngu dowoolo, ombulo, no yakaka oni ngundilo nodowootenggo? Nalu oowooyingga, no yeya Yuda onilo goobooyingo ya Tempelno ootoolo, mande yunololuwonoku, ene ye nguno ma nodowoowonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ene ataga oo tunooteteku nga, kuli Anutlo ingondudu eyingo onindo nakangoyingo, ngu ataga engge tunootete. Etoni, ngu naluno, enengo sulena oniku sosolelo, ngulo ene Yesus yokolo, sodedonangge samukowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Onikundo Yesus yolo, Anutlo woolo yeyingo oni kundingiyi, ngulo sobosobo koleteyingo oowooyi Kayiyapaslo yano oolouwonggori. Moseslo mamana mande etuyeloyingo oniku, ko, Yuda onilo tabango oni bidodo mayelo, gooboongoolo oluwonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ene Pitando Yesus keyolo, oololo, ene boda yowokoyi oluwolo. Pitando olengomonggo tolige penggopenggootelo, kundingi onilo tabango ulungga, ngundo yasiliko uwolo. Ngu yangga ngulo kumba ootuwoo onindo de katoyi, Pita ngu yokowelo nombono ombulo, de yokolo, ngunonggo Yesusno ndatelo tewanggoku, ngulo ingoweloyimbolo bibitewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Anutno woolo yeyingo oni kundingiyi ngulo sobosobo oniku, ko, gooboolo oni tabango bidodo, ngundo Yesuslo mande ebe ganagana goweyi sanggaweloyi oninggaku erewewonggori. Ndatelo ngulo, ene uleyi kumooweloyimbolo oole erewewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Nguno ngu, oni oowooyingga tunootelo, ngundo mande ebe ganagana oowooyingga Yesusno sanggawelo ewonggori. Ene mande nenengo gula elo, ngu keyolo, nguno uleweloyi ngu ma kenowonggori. Ngundilo tetoyi, kootusina, oni elaya tunootelo, ombulo, ngandilo ewoli. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Nga oningga ngando ngandilo ewolo. Yudalo goobooyingo ya, Tempel, ngu nondo mete toongoolo, nalu kabusagomo, ko yewanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Anutlo woolo yeyingo oni kundingiyi ngulo sobosobo koleteyingongga, ngundo enengo mande ingolo, kewooloyemonggo ngu ootookoolo, dikalo, Yesus sumoo inolo ewolo. Ge mande nga gumi ma ewa? Nga mandega nga mande wilikoyingo oni doongeyemo, ge bungomo etenggo. Ge mande moole, ngundi kini bine? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yesusndo enengo mande ngundilo ingolo ngu, nenetelo, mande gumi ma ewolo. Ngulo kundingiyi onilo tabangokundo, Yesus ko sumoo inolo ewonggori. Anut keda oolooteku, ngu oowooyimonggo mande hamoo awuno oolengo solumimonggo, nooleno etooga ingowato. Ge Kristus, Anutndo noole yoyoweloyimbolo sunggi yewo oni, ko, Anut Nangoni hamoo, bine? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Asa, Yesusndo enengo mandeni ngu ingolo, enebana gumi ewolo. Gedo kuli ewoku, ngulo no yeno eteno. Ataga ko kootusina nguya, ye no Anut Nangoni Oni Kilalongo neyootoyi, no Anut yanggangonidodo ngu kandeyi koondosina bingamidodo bibitewano. Eme no Sambono goboole ngu sanganimo ombulo oodoowe, neyowanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","66","Yesusndo ngundilo etoni ngu, asa, kundingiyi onilo tabangonggakundo enengo nenggulo dowoolo, oomboongelo, sanggili oolengo telo ewolo. Ene Anut kootuyisina yumooyinolo mande eteku nga! Noole oni gidalegano meno etooye ombulo, ngundo mande gula ma ewanggo. Kini, enengombo mande eteku nga, noolengombo nenengo enengo mandeni ingooteto. Ene Anut kootuyisina yumooyinolo mande ete. Ngulo ngu, ye enengo mande ingootenggoku ngu, ye ndatelo ingootenggo? Ngundilo sumoo etoni, enendo gumi ewolo. Yesusndo Anut yumooyinolo mande biyomi kootuyisina eteku, ngulo ene komo uleyiga kumoonilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","68","Ariya, oni gidalegado Yesus ene doongeyi doobengolo, omukumundoongomo mukendongolo, nguno utolo ewonggori. Ge Kristus, gengo ingondudunonggo ngu yootunoya e. Onendo gulete? Elo yumooyinolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita ngu endesina ya kosingeyimo nguno bibitelo oodoni, kundingiyi onilo tabango ulungga, ngulo sulena bale gula tanggeyimo ombulo ewolo. Ge nguya Yesus Galili mela oningga, ge nguya oluwolilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Sulena balegakundo ngundilo etoni, asa, Pitando oni oowooyingga doongeyemo, no ngu oningga ngu, no watayi kini. No gedo mandega eteku ngu, no watayi kinilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ngundilo elo yokolo, Pita endesina sisipawa ngulo yamako dabemimo ooletoni, bale gulado kenolo, oni namoko dikayingokuno ewolo. Nga oningga nga nguya, Yesus Nasaret oningga nguya oluwolilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ene ngundilo etoni, asa, Pita Yesus oowooyi ko imangoolo ewolo. Hamoo oolengo, solumimonggo, no nga oningga nga no watayi kini! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Asa, ene bodaga oode, oni namokono oluwonggokundo Pitaya ko ewolo. Hamoo oolengo, ge Yesuslo oni gula. Gengo mande eteku, ngu Yesuslo mande bungeyi ngundilolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ene ngundilo etoyi, ariya, Pita manggalu telo ewolo. No yeno etenoku, no nenengo ma ewanoku ngu, asa, Anutndo ngulo ogingoyingo gumi nunowa. Ariya, no hamoo oolengo, solumimonggo awuno etenoku ngu! Ngu oningga yendo etenggoku ngu, no ma ingooteno! Elo ewolo. Ngundilo etoni, sodedonangge, kooduli ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pitando kooduli etoni, ingolo, ariya, kuli Yesusndo mandega enedodo eyingo, ngu ingondudu ulungga tewolo. Kooduli ma eyingonggakuno ngu, ge no oowoone tambu kabusa oongoonelowa, ewolo. Pita ngu ingolo, ngulo ene oluwoku musiyo ngu yokolo, sendolo biyobiyomi oolengo tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Sengetoni ootookoolo, Anutlo woolo yewo oni ngulo sobosobo oniku, ko, Iserel onilo tabango oniku, ngundo goobooyingomo mande gulanangge gosiyolo, eweloyimbolo gooboongoowonggori. Ngulo ene Yesus uleyi kumooweloyimbolo mande gosiyowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Mande ngundilo gosiyolo ngu, asa, Yesus utombo (sen) gosiyolo, yolo, oololo, Rom Gabman oni, Yuda mela ngulo oo sobosobo oni ulungga, oowooyi Payilat, ngu kandeyimo yewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ngu naluno, Yudas oningga, ngundo Yesus damoni telo, me oni kandeyemo yunoyingo oningga, ngundo Yesus uleyi kumoowelo mande gosiyootoyi, ngu kenolo, ingolo, ngulo ene damoni biyomi tewoku, ngulo nowoondoyi telo, Anutlo woolo yeyingo oni kundingiyi ngulo sobosobo oniku, ko, Iserel onilo tabango onikuno oololo, bobeye doobe kabusa (30 Kina) ko yunowelo tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Yudasndo mande ngandilo onikuno ewolo. Nondo mbumbuwa telo, Yesus ye kandeyemo yewono. Ene oo biyomi gula ma teyingomu, ngu nondo damoni tewonoku, ngulo ene kumoowa. No mbumbuwa ulungga oolengo tewonolo ewolo. Enengo mandeni ngundilo ingolo ngu, enebana mande gumi ewonggori. Ngu gengombo tewokulo, ngu gengomu nangge! Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yudas ngulo mande ingolo, ngulo ene newende kowuli ulungga oolengo ingolo, bobeyeku yolo, Tempello yawasa sanganimo oolongooni uwolo. Ngundilo telo, ene oololo, utono bungebolo telo kumoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Asa, ngu naluno nguno, Anutlo woolo yeyingo oni ngulo sobosobo oniku, ngundo ngu, bobeyeku yolo ewonggori. Nga bobeyega ngando, ngu oni uleyi kumooweloyi ngulo uliyi. Ngundilo ngulo, nga bobeye biyomingga nga, Tempello digi beye nguno ma gooboongoolo yewatolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ngulo ene mela gumisina nguno, nogo kumbe gome nguno ooloote. Nguno ngu, Anutlo woolo yeyingo oni ngulo sobosobo oniku, ngundo mande gosiyolo, nogo kumbe teweloyi sembuligaku bobeye inolo, ngu mela kumbe musiyonggaku uliyowolo. Ngu mela gumi uliyowonggoku, ngu oni sowe gidalega Yuda oni kini yowokonggo mayeyingo, ngu kumootoyi, nguno meleyeloweloyimbolo, ngulo musiyo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ngundilo telo, ngu mela guminggaku ngu oowooyi, dalolo mela, ewolo. Ngu oowooyinggaku, ataga ngundilo ooloote. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ngundilo tetoyi ngu, kuli Anutlo ingondudu eyingo oni, oowooyi Yeremayiyando mandega eyingomu, ataga engge tunootete. Ene ngandilo ewolo. Ene ngu bobeye onibiga kande elaya ngu yolo, Iserel onindo ngu uliyowelo, ngundilo sunggi yewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ngundilo tetoni, ngu bobeyekundo nogo kumbe teweloyi sembuligaku inolo, enengo mela uliyowolo. Oo Sembuli Ulunggado nono mande eyingomu ngundilolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ngu naluno nguno, oni ngu Yesus yolo, ombulo, Gabman oni koleteyingo ulungga doongeyimo yeyi dikawolo. Payilat ngundo Yesus sumoo inolo ewolo. Ge Yuda mela oni simoo bale ngalo oni sobosobo koleteyingo ulungga, bine? Elo ewolo. Ngundilo sumoo etoni, Yesusndo mande gumi ngandilo ewolo. Yo, gedo eteku ngundilolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Anutlo woolo yeyingo oni ngulo sobosobo oniku, ko, Iserel onilo tabango oniku, ngundo kingo mande ebe ganagana Yesus goweyi sanggawelo etoyi, ene mande gumi gula ma ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ngu naluno nguno, Payilatndo ko Yesus sumoo inowolo. Ge gowegemo mande oowooyingga geno sanggawelo etenggoku nga, ge ma ingoote? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ene ngundilo sumoo etoni, ene Yesusndo mande ngu Payilatno gumi gula ma ewolo. Ngundilo ngulo, Gabman oni mela sobosobo oni ulungga, ngundo ingondudu ulungga tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Mooma bidodomo, nalu kundingiyi oowooyi Pasowa, ngu naluno, mela sobosobo oni ulungga ngulo damoniye ngu ngandilo. Ya biyomimo oni gulanangge andangetoyi toongewa. Ngundilo ngulo, oni simoo bale enengombo oni gulalo etoyi ngu, ariya, Payilatndo ngu oningga ngu nangge andangetoni toongewa. Payilatndo ngu damoningga ngu telo, nguno Yuda oni simoo bale oni oni yunoweloyimbolo tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ngu naluno, ene oni biyomi gula moole, ngu ya biyomimo oluwoku, ngu oowooyi Yesus Barabas. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ariya, oni simoo bale mayelo, gooboongootoyi, Payilatndo sumoo yunolo ewolo. Yendo ngu, nondo ndawu oningga yokootoowega, toongenilo ingootenggo? Yesus Barabas andangetoowega toongeni; ngundi, Yesus Kristus etenggokungga, ngu Anutndo ye yoyowelo sunggi yewo oningga, ngu andangewe, bine? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ene ngundilo sumoo elo, ndatelo ngulo, ene kuli ingowoku, ngu Yuda goobooyingo yalo sobosobo oni ululuku, Yesusndo oo tewoku, ngulo nowoondoyemo boguwoolo, ingolo, ngulo ene me oni kandeyemo yelo, uleyi kumoowelo tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Payilatndo ngundilo ingolo, ngulo ene bibitelo, Yesusno mande sanggawelo etoyi, ngu wilikolo oodoni ngu, ngu naluno, enengo baleyibo mande yanggango soweyolo ewolo. Ge ngu oni nenengonggano, nguno oo gula ma tewelo. Ndatelo ngulo, suwoono, no gabono ene kenolo, ngulo nowoondone kowuli ulungga oolengo ingowonolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ene Anutlo woolo yeyingo oni ngulo sobosobo oniku, ko, Iserel onilo tabango oniku, ngundo oni simoo bale suleyelolo, Payilatno etoyiga, Barabas andangeya, yunoya, Yesus uleyiga kumoonilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ariya, Payilat ngundo ko sumoo yunolo ewolo. Nga oni elayaga nga, yendo ngu ndawu oningga andangeya yokowelo ingootenggo? Ene ngundilo etoni ngu, asa, Barabas andangeya yoko, elo mande gumi ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Payilatndo enengo mandeye ngu ingolo, enebana gumi ngandilo ewolo. Ngundilo ngulo, nondo Yesus Kristus etenggokungga, ngu ndatelo teyinowano? Elo ewolo. Ngundilo etoni, oni simoo bale bidodo manggalu ulungga telo ewonggori. De mombimo boolowooyi! Ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ene ngundilo meno etoyi ngu, asa, Payilatndo mande gumi ewolo. Ndawugalo? Ene ndawu oo biyomingga tewo? Etoni, ene oni simoo bale bidodo ko manggalu ulungga telo ewolo. De mombimo boolowooyi! Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ngundilo meno etoyi ngu, asa, ngu naluno nguno, Payilat ngu enengo ingonduduye ngu ene ingooteku, ene damoni yelo, ebe ulungga yeyi, tunooteweloyi tetoyi, ngulo enengo mandeni nguya ma ingowolo. Ngundilo ngulo, ene ngandilo ewolo. Nga oningga nga, ene oo biyomi gula ma teyingo, ngulo no ene uleyiga kumooni, elo, ma sunggi yeteno. Ngulo ngu, no ngu ooga ngulo kandene sonowoolo, andangelo, yengo kandeyemo yetenoku ngu! Ataga ngu yengomu nangge. Elo ewolo. Ngundilo elo, ene sono yolo, oni simoo bale doongeyemo kandeyi sonowoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ngundilo tetoni, oni simoo bale bidodo mande gumi ewonggori. Nga kowulingga mete ombutoni, noolengombo simoonayidodo koolowoowato. Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ngundilo ngulo, Payilatndo ngu nangge ingolo, ngulo ene Barabas andangelo yunowolo. Ene Yesus tulimbo gisasaluwolo, me oni kandeyemo yunootoni ngu, ngundo de mombi sanganimo sanggaweyilo yunowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ariya, Payilatlo me oni bidodo Yesus yolo, Rom gabmanlo yano ulo, nguno Yesus yumooyinolo, utolo, yombuliyowelo mayelo gooboongoowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Me onindo Yesuslo nengguloni ngu andangelo yokolo, enendo nenggulo seleyingongga yolo teyinowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ene uto sanggilidodomu ngu yolo, ngundo Yesuslo tomuku teyinoyingomu, ngu yolo, enengo tabangomo kuduwooyinowolo. Ngundilo telo, kumuku wembuyiga yolo, kandeyi koondosina yewolo. Ngu kumuku wembuyiga ngu mela oo sobosobo koleteyingo yanggangoni, ngulo sunggiyi, elo, ngulo ene kandeyimo yetoyi dowoowolo. Ene ngundilo telo, Yesus tanggeyimo boodooye oondookelo, yumooyinolo mande ulunggalo ewonggori. Ge mayeteku nga! Ge Yuda onilo oo bidodo sobowooyingo oni koleteyingo ulunggaku ge! Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ngundilo elo, mukendongolo, ngu kumuku wembuyigaku kandeyimonggo woosoolo yolo, ngundo tabangomo oolongoolo ulewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Me onindo Yesus yumooyinolo yokolo ngu, ariya, enengo nenggulo seleyingonggaku andangelo yokolo, Yesus enengo nenggulogaku yolo, ko teyinowonggori. Ngundilo telo, Yesus yolo, de mombimo yuleweloyi musiyomo, nguno oolouwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ngu naluno nguno, me oniku oolekanare ooloutoyi, oni gula oowooyi Sayimon ngu endeni oowooyi Sayirin, ngu ombutoni kenowonggori. Kenolo, ngu me onikundo nguno dowoolo, woosoolo, suleyootoyi, oololo, Yesusndo de mombigaku ngu inootoyi koolowoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ene ngundilo koolowootoni, yade oololo, mela musiyo gula, oowooyi Golgata, nguno tunootewonggori. Golgata oowooyingga ngulo damoni ngu ngandilo: tabaye wembuyi musiyo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Nguno ngu, ene sono kowoododo Wayindodo goobooyingomu Yesus inootoyi, ene ngu sono kowoonggaku nelo tewoongootoni, ngu yokowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ngundilo telo ngu, ene Yesus de mombimo dowoolo, sanggawelo, enengo nengguloni yolo, ebe dagadaga telo, yoweloyimbolo koondoongetelo, oni gulado dagayelolo ngu, asa, ngundo yowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ene ngundilo telo, ngu mela musiyonggakuno bibitelo sobowoowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Yesus tabango sanganimo de mombi sosowoomo wilikoyeloyingo oni, ngundo mande ewoku, ngu so uyi gulano ngandilo nakangowolo. Nga Oningga Nga Ngu, Yesus. Ene Yuda Onilo Sobosobo Oni Koleteyingo Ulungga Oolengo. Ngundilo nakangowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ngu musiyomo nguno, oni biyomi elaya Yesus tanggeyi gide gide booloyelowoli. Gula kandeyi koondosina, gula kandeyi biyomisina booloyelowoli. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","40","Oni simoo bale mayelo, kenolo, yumooyinolo mande elo, tabadoli telo, kandedisi telo, kenolo ewonggori. Ehe! Ge nga oningga ngando goobooyingo ya tootoongolo yokolo, nalu kabusagomo ko yewelo ewonggori. Ge ngu tewelo ngu, ariya, ge mete de mombi ngu yokowa. Yo, ge Anut Nangoni tetoningga ngu, asa, ge de mombi yokoya, melako ombu! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","42","Ene ngundilo etoyi, Anutlo woolo yeyingo oni ngulo sobosobo oniku, mamana mandelo ingondudu oni, ko, Iserel onilo tabango oniku, ngundo yumooyinolo mande elo, yumoolo ewonggori. Ene oni gidalega yomosiyelolo, ene enengombo enengo ma hooloowewolo. Ariya, ge Iserel onilo sobosobo koleteyingo ulungga tetoningga ngu, asa, ge komo de mombi yokoya, melako ombutooga, noole geyolo ngu, asa, noole nowoondonayimo hamoo tewa! ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Yo, nga oningga nga, ene Anutno newende hamoo telo elo, No Anut Nangoni elolooteku ngu. Ariya, Anutndo gengo gome ingoya ngu, ene mete anangu hooloowenggelonilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ene ngundilo nangge, yakaka oni elayaga Yesus tanggeyimo de mombimo booloyeloyingo elayagaku nguya, Yesus yumooyinolo mande ewoli. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Sa kewoolo sambolo oolengo nguno, mela bidodo suwoo ooleli telo, oololo, sa nemimo utoni 3:00 Klok, ngu kinitewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ngu naluno, Yesusndo meno yanggango ulunggalo ewolo. Eloyi, Eloyi Lama Sabakatani? Ewolo. Nga mandega nga, ngu damoni ngandilo. Nolo Anut, nolo Anut, ge ndatelo noyokowo? Ewolo. (Sam 22:1) ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ene ngundilo meno etoni, oni simoo bale gidalega nguno oluwonggokundo, ngu ingolo ewonggori. Nga oningga ngando ngu, ene Ilayiya negongoote. Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ngundilo etoyi, sodedonangge kewooloyemo gulado kendutelo, oololo, sono kowoo oowooyi Winiga ngu towi sosowoo nguno yelo, de sanggano gosiyolo, yeyi Yesus manggowoomo nenilo inowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ene oni gidalegado ewonggori. Sobowoolo oode, kenowato! Ilayiyando ombulo hooloowewa, ngundi kini bine? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ngu naluno nguno, Yesus ki yanggango ulungga ko elo, enengo gaboyi yokolo, ooloutoni kumoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ngu naluno nangge, Yuda onilo Tempel goobooyingo yano towi ulunggaku awu wengamonggo kewoolokuli pitilo, oosowoolo, ombulo, wenga melako nggolongelo elaya tunootewolo. Ngu naluno nguya imimi yolo, digi ululu udookewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ngundilo tetoni ngu, oni meleyeloyingo musiyonggaku goosootoni, Anutlo oni simoo bale oowooyingga kuli kumooyingoku, ko ootookoowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ene oni melengooweloyi musiyo yokolo oodoyi, kootu Yesus ko ootookoolo, Yerusalem ende kundingiyi nguno oolouwonggori. Ooloutoyi, oni oowooyingga ngu yeyowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Me oni ko enengo tabango, ngu Yesus sobowoolo oodoyi, mela imimi yootoni, oo bidodo tunootetoni ngu kenolo, ngulo ene sosoleyingo ulungga telo ewonggori. Hamoo oolengo, nga oningga nga, ngu Anut Nangoni nga! Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ngu bale gidalega nguya ngu yowokoyi dikalo, ngunonggo Yesus kenondadangelo oluwonggo. Ngu bale ngu, ene kuli Yesus Galili melako oliyingo, ene ngu Yesus keyolo, oololo hooloowewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ngu bale kabusaga ngu kewooloyemo, ngu Mariya Magadala; Mariya Yems Yosep elaga namoyali; ko, Sebedi simoongo elayaga ngu namoyali nguya oluwonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Suwootetoni, Yosep Arimatiya melakonggo oningga ngu, ene bobeyenidodomu ngu mayewolo. Ene nguya Yesuslo sulena oni gula. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ene yanggango telo, Payilatno oololo, Yesus bingonggaku yoweloyimbolo sumoo ewolo. Ariya, Payilatndo me onino etoni, Yesus bingonggaku Yosep yokoyinowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ariya, Yosepndo Yesus bingonggaku ngu yolo, kumba nomboyinggado doobengolo, mbimboongowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ene ngundilo telo, yolo oololo, oni melengooweloyi musiyo gula keda teyingomu, nguno yewolo. Ngu melengga ngu, digi kowu newendemo tewolo. Mele manggowo ngu digi ulungga gula wenggelemoolo, ngundo ukingowolo. Ene ngundilo telo ngu, asa, ene yokolo toongewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mariya Magadala, ko, Mariya gula, ngu bale elayagaku ene nguno mele tanggeyimo bibitelo, ootoolo, ngunonggo doongetelo, Yesus ndatelo telo melengootenggoku, ngu kenowelo oluwoli. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","63","Nalu wengamo, oo yomosiyoweloyi Yudalo Kengeyingo nalu, oowooyi Sabat kinitetoni, Anutlo woolo yeyingo oni ngulo sobosobo oniku, ko Parisi oniku ngu Payilatno mayelo, gooboongoolo ewonggori. Oni ulungga, noolendo mande gula ngano ebe ganagana oni ngundo kuli keda oluwokuno, mande eyingoku, ngu ingooteto. Ene ngandilo ewonggori. Kootusina, sa kabusa yokolo, no ko ootookoowanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ngundilo ngulo, ge etooga, oni oolouya, ngu melengga ngu, sa kabusaga nguno gome sobowooyi. Yokootoyi ngu, enengo sulena onindo ombulo, yakakayi yolo, salo, oni simoo baleno ewanggo. Ene ko melenonggo ootookootoni, etoyi, kootu ebe ganaganangga tewanggoku, ngundo koletelo ebe ganaganangga ewonggoku, ngu dagawalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ngundilo etoyi ngu, Payilatndo enedodo mande gumi ewolo. Ariya, ye sobosobo oni gidalega yoyoya, ooloutoyiga, ngundo melengga ngu yanggango ukingoya sobowooyi. Yengombo ngundiya teyi, ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ngundilo ngulo, ene oololo, digi kowu melenggaku, ngu sunggi gula loogu teweloyim ngu yetoni, me oni yoyetoni, ngundo ngu melenggaku sobowoowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Yudalo Kengeyingo nalu, oowooyi Sabat kinitetoni, sengetoni suwoononggo, kowooyingo ngulo nalu koleteyingo, ngu Sande naluno, Mariya Magadala, ko, Mariya gula nguya yade oololo, Yesus melengooyingo melenggaku kenowelo oolouwoli. ");
INSERT INTO rwo_karo_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Asa, imimi ulungga oolengo yootoni ngu, ngu naluno nangge, Anutlo Sambono Engel oninggado Sambononggo ombulo, Yesus melengooyingo musiyomo oololo, digi ulungga mele manggowo ukingoyingonggaku ngu andangetoyi, ukelo, utoni, ngu sanganimo bibitewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Enengo omukumundoongo solu yowali ngundilo tunootelo, enengo nengguloni nguya namboyi oolengo tunootewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Me oni, Yesus melengooyingo mele ngu sobowoolo oodoyi, oo ngundilo kenolo ngu, ene sosolelo, mboolomboolo telo, gaboye kumookumootewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ene Anutlo Sambono Engel oningga, ngundo bale elayagakuya ewolo. Yali ma sosolewelo! No kuli ingooteno. Yali Yesus de mombimo boolowooyingo oningga, ngu erewelo ombuteli. ");
INSERT INTO rwo_karo_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ene ngano kini. Ene kuli enengombo ewo ngundilo, ataga ene keda ootookoote. Yali ombuya, meleno yewonggoku musiyongga ngu kenoli. ");
INSERT INTO rwo_karo_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Yali enengo musiyongga kenoya, sodedonangge oolouya, enengo sulena onikuno ngandiya eli. Ene kuli mele yokolo ootookoolo, ye koleteyunolo Galili melako ooloute, eya eli. Ye ngu mela gumisina nguno kenowanggo. Ingoyi, no ataga yeno etenoku ngu! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ene mande ngundilo etoni, asa, bale elayagaku mande ingolo ngu, ene sosolelo, oni oni ulungga nguya telo, ngulo ene sodedonangge mele yokolo, sulena onikuno woosoolo, ngu mande ngu ewelo oolouwoli. ");
INSERT INTO rwo_karo_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ene woosoolo, yade ooloutoli ngu, Yesus oolekono tunootelo, eneno ewolo. Yali mayeteliku ngu. Etoni, bale elayakundo enengo mande ingolo, oololo, Yesus keyi damonimo penggootelo, nguno yambo mande tewoli. ");
INSERT INTO rwo_karo_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ngundilo tetoli ngu, Yesusndo enedodo ewolo. Yali ma sosolewelo. Yali oolouya, nolo sulena oni dobooguline oolengo nguno ngandiya etoliga, ene Galili oolouya, nguno neyoyi. Yali ngundiya eli. Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Bale elayagaku oolekono ooloutoli, me oniku Yesus melengooyingo musiyongga sobowooyingoku, ene endemo ulo, Anutlo woolo yeyingo oni kundingiyi ngulo sobosobo onikuno oololo, oo tunootemukowoku, ngulo ewonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","13","Ngulo ngu, Anutlo woolo yeyingo oni kundingiyi ngulo sobosobo onikundo, ko Iserel onilo tabango onikuya gooboongoolo, ngu oo tunootewonggoku, ngulo ndatelo tewatolo, mande gosiyowolo. Ngulo ene me oniku digi beye oowooyingga kingo yunolo ewolo. Ariya, ye saya, oni simoo baleno nga mande ngandiya eyi. Suwoono wetelootoole ngu, sulena onindo ngu tolige ombulo, Yesuslo bingo yakakayi yolo sawonggo. Ngundiya ewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ngulo ngu, yengo Gabman sobosobo oni tabangongga, ngundo nga mandega yendo etoyi, ingootoni ngu, ariya, ye nowoondoye kowuli ma ingowelo. Ndatelo ngulo, no yengo sobosobo oninggano oololo, mande inowano. Inootoowe, ene ye kowuli ma yunowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ngundilo etoni ngu, asa, me onindo digi beye yolo, oo ngundilo ewonggoku, ngundilo tewonggori. Ngu mandegaku, ene Yuda oni simoo bale bidodo etoyi, ingoyingomu, ataga nguya, ngu mandegakulo ingololootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ariya, enengo sulena oni kande elaya kegidembolo gulanangge, Galili melako oololo, pulingga Yesusndo kuli eyingomu, nguno oolewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ene nguno, Yesus kenolo, sulena oni bidodo penggootelo, eneno yemboongetoyi, ene gidalega ingonduduye bulibali ingowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ariya, Yesus tanggeyemo ombulo, mande wesiyolo ewolo. Anutndo kuli Sambo mela ngalo nguya, yanggango bidodo nunowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ngundilo ngulo, ye oolouya, oni simoo bale bidodo, Anutlo Mande Keda Mesalango yunoya, yoyeyiga, nolo sulena oni tunooteyi. Ene nowoondoyemo hamoo tetoyiga ngu, ariya, ye sono (kundingiyi) newendemo utoyiga, ngu Awa, Nangoni, ko, Yuka Kundingiyi oowooyimo sonoyeloyi. ");
INSERT INTO rwo_karo_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ngundiya teya, nolo mande bidodo etuyelowonoku, ngu bidodo yeba nangge oo ngundilo eneno etuyelowanggo. Ye ma kapengo yewelo. Ingoyi, no suwoo suwoo yeya oode, oololo, nalu wenga kinitetoni, nguno nguya, no yeya oluwatolo ewolo. Ngu hamoo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Nga mandega nga, ngu Yesus Kristus Anut Nangoni, ngulo Mande Keda Mesalango. ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Anutlo ingondudu eyingo oni Ayisaya, ngundo kuli Sonoyeloyingo Oni Yon, ko, Yesuslo nguya nakangolo, ngandilo ewolo. Ingoyi. Nondo nolo ko oni ge koleteyingo nolo sulenggelowano. Enendo ngu gengo oole yomosiyonggunowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Kootusina, ngu oningga, ngundo oni kini melako, nguno ombulo meno ewa. Oo Bidodo Sembuli, ngulo ooleni ngu yomosiyoyinowa! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ngulo ngu, Yon Sonoyeloyingo Oni, ene oni kini kingo melako nguno ombulo, oni simoo baleno mande wesiyolo ewolo. Ye komo nowoondoye hamoo yowoolengoya, sono (kundingiyi) gemuyi. Ngundilo tetoyi ngu, asa, Anutndo yengo mbumbuwa andangelo kapengo yeyunowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ene mande ngundilo wesiyolo etoni, ngulo Yudiya mela, ngulo simoo bale bidodo, Yerusalem endemo simoo bale bidodo, ene Yonno oolouwonggori. Ene nguno oololo, enengo mbumbuwaye Yonno wesiyolo etoyi, ngulo Yondo Yodan sonono yoyolo ulo, sonoyelowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yonlo nenggulo ngu pelungga, ngu Hos gula oowooyi Kamel, ngu uyimbo nengguloni ngu tewolo. Ene Kamel goweyi, ngundo utoyi telo, wanggangomo nguya gosiyowolo. Enengo oowali ngu deguno katu, siso, ngu nelo oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ene mande ngandilo wesiyolo ewolo. Kootusina, oni gula no kenelolo ombuwa. Ene ngu oningga, ngu yanggangoni ngu ulungga oolengo. Yo, hamoo, ngu oningga ngulo yanggangoni, ngundo nolo yanggangone ngu dagate. No ene newendemo ootoolo, enengo sulena oni nangge oolooteno. ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","No ye sonombo sonoyelooteno. Ene ngu oningga, ngundo ngu Anutlo Yuka Kundingiyimbo sonoyelowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ngu nalungga nguno, Yesus ene Nasaret ende Galili melakonggo mayewolo. Mayetoni, Yondo Yesus yolo, Yodan sonongga nguno ulo sonowoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ene ngundilo sonowootoni, Yesus sono yokolo, sakiko ooletoni ngu, asa, sodedonangge Sambo goosootoni, nguwoole Yuka Kundingiyi Sambononggo nu kundirimanggowo ngundilo telo, Yesusno ombuwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ngu naluno nangge, Anutndo Sambononggo Yesusya ngandilo meno ewolo. Ge nenengo nangone. No gengo gome ingooteno. Nowoondone gengo gome oolengo ingootenolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ngu naluno sodedonangge, Anutlo Yuka Kundingiyimbo Yesus suleyootoni, oni kini kingo melako toongewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Toongelo, ene oni kini kingo melako nguno, sa nalu onibi elaya ene nusago goki kewooloyemo oluwolo. Nguno oodoni, ene Sambono Engel oni galodo ombulo, Yesus hooloowewolo. Ngu naluno nguno, Setando Yesus tewoongowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Me onindo Yon dowoolo, ya biyomimo yetoyi oodoni, ngu naluno, Yesus Galili melako oololo, nguno Anutlo Mande Keda Mesalango simoo baleno wesiyolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ataga nalunggaku tunootete. Anut Oo Bidodo Sembuli Sembunayi, ngundo nalu enengo oni simoo bale soboyelooteku, ngu kuli namoko ombute. Ngundilo ngulo, ye mande gome ngalo nowoondoye yowoolengoya, Mande Keda Mesalango nga ingoya, nowoondoyemo hamoo teni! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ngu naluno, Yesus ene Galili sono koongeyingo dabemiwoole oolouwolo. Oololo, ene Sayimon koneyo Enduru nguya yeyowolo. Ngu elabasa elayaga ngu ene isolo si sono koongeyingomo oolongoolo, ngu koyi tewoliyo. Ene ngu ko ngu telo, iso uliyolo beye telo oluwoli. ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ene ngundilo tetoli ngu, Yesusndo elayaga nguya ewolo. Yali ombuya, no keneloya endeyoli. Kootusina yalindo oni simoo bale yoyolo, Anutlo mandeno yoyoweloyi ngu etuyelowano. Yo, hamoo, yali iso yooteliku ngundilo oni yoyowaliwali. ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ene ngundilo etoni, ngu naluno nangge elayagaku isolo si ngu yokolo, oololo, ene keyowoli. ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ngu naluno, Yesusndo bodaga nguya oololo ngu, ene Yems, Yon elabasa, Sebedilo simoongo yeyowolo. Ngu elayaga nguya wanggo sanganimo isolo si yomosiyoloodoli yeyowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yesusndo elayaga ngu yeyolo negoyelowolo. Negoyelootoni, elabasa mandeni ngu ingolo, ngulo ene awayali Sebedi enengo ko onidodo wanggono yoyokootoli, oodoyi, ene oololo, Yesus keyowoli. ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ene Kaperniyam endemo oololo, ngu Yuda onilo Kengeyingo Nalu (Sabat) nguno ene goobooyingo ya newendemo ulo, oni simoo baleno mande wesiyolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ene ngundilo mande wesiyolo etoni, oni enengo mandeni ingolo, ngulo ene sosolewonggori. Ndatelo ngulo, enengo mandeni etuyelooteku, ngu yanggango oolengo. Yo, enengo mandeni, ngu mamana mande onilo mande etuyelootenggoku, ngundilo kini. ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ngu naluno, oni gula goobooyingo yano oluwolo. Ngu oningga, nguno yuka biyomi newendemo oolooteku, ngundo menolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Yesus Nasaret oni, ge nooleno ngano ndawuga tewelo ombute? Ge noole yombuliyelowelo ombute, bine? No ge kuli ingooteno. Ge Anutlo oni kundingiyi! ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ene ngundilo etoni ngu, Yesusndo yuka biyomingga ngu kenolo, manggaluwoolo ewolo. Ge manggoge ukingoya, ge nga oningga nga yokoya toonge! ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ene ngundilo etoni, yuka biyomingga, ngundo mandeni ingolo, ngulo ene sodedonangge oninggaku yeni, yanggango biyomi mboolomboolo tetoni, mboologa ngundo manggalu telo, ene oningga ngu yokolo peselo toongewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ene ngundilo tetoni, oni simoo bale bidodo soliyokolo, enengo nangge kewooloyemo mande mandelo ewolo. Ngu ndawuga? Nga mande damoni keda gula tunooteteku nga! Nga oningga, nga enengo yanggangoni ngu yanggango oolengo. Ngulo ngu, ene mete yuka biyomi mande yunootoni, enengo manggowo ingolo keyootenggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ngundilo tetoni, ngu mandegaku, sodedonangge Galili meladodo logowoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ngu naluno, ene Yems koneyo Yon ngudodo goobooyingo ya yokolo, endesina oolelo, ene oololo, Sayimon koneyo Enduru elagado yano uwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ene yano ulo, Sayimon konggeyi ngu yabano wetolo oodoni kenowolo. Ene sayi ulungga moondeyi gookingo ulungga tetoni, ngulo ene sodedonangge Yesusno ngulo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yesusndo mandeye ngu ingolo, ngulo ene balega ngu tanggeyimo oolouwolo. Oololo, kandeyi dowoolo hooloowetoni ootookoowolo. Ene ngundilo tetoni, ngu naluno nangge, sayini kinitewolo. Kinitetoni, ngulo ngu balegaku ootookoolo, mete telo, Yesus galolo oo kalo yomosiyowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Suwootetoni sa utoni, oni sayi oni, ko, yuka biyomimbo yoyoyingo nguya yoyolo mayewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ngundilo mayetoyi, ngulo endemo oni simoo bale bidodo endesina yamako dabemimo gooboongoolo, ende ndindi telo oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Asa, nguno Yesusndo oni simoo bale sayi oowooyingga yomosiyelolo, yuka biyomi oweyelootoni sawonggori. Ngundilo telo, ene Yesusndo oo yuka biyomi nguya mande ma ewelo, elo loogu yunoote. Ndatelo ngulo, yuka biyomi, ngundo ene ingoyingo, Anutndo Yesus suleyootoni ombuyingo, ngu ingootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Sengewelo tetoni, Yesus ootookoolo, ende oolelo, oni kini mela nguno toongelo, ene nguno yemboongelo oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ene ngundilo yemboongelo oodoni, Sayimondo dobooguliyidodo ene erewelo sawonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Salo, oololo ene kenolo ngu, asa, ene Yesusno ewolo. Oni simoo bale bidodo ge erewenggelootenggo! ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ngundilo etoyi, enebana gumi ewolo. Nguno yokoyi. Noole ende gidalega namoko ngano salo, nguno no Anutlo mande nguya wesiyolo ewelo no ombuwono. Ngulo damoni ngandilo: no Anutlo Mande Keda Mesalango wesiyolo ewelo ngulo ombuwonolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ngulo ngu, ene Galili mela bidodomo oololo, Yuda onilo goobooyingo yano ngu bidodomo uwolo. Nguno ulo, Anutlo mande wesiyolo elo, ene yuka biyomi nguya andangewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ngu naluno, oni gula golimambudodo ngu Yesusno ombulo sumoo elo, solengoyelo, bodowo oondookelo, Yesusno ewolo. Ge mete tetoningga ngu, no yomosinelootooga, mete tewelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesusndo, enengo mandeni ngu ingolo, nowoondoyi ulungga teyinolo, ngulo ene kandeyi eneno yelo dowoolo ewolo. Yo, no ingooteno. Gengo sayingge kinitenilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ene ngundilo etoni, ariya, sodedonangge mambugoli goweyimo oluwoku ngu peselo kinitewolo. Ngundilo telo, ene mete tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Ariya, Yesusndo mande yanggango enedodo ewolo. Ge ingondale te! Ge oni gulano nga mandega, nga ma ewelo. Kini, ge sodedonangge goobooyingo yano oolouya, Anutno woolo yeyingo oni kundingiyingga, nguno gowege, ene etungo. Gowege mete tewoku ngulo ge woolo yeya, Mosesndo kuli eyingo, ngundiya te! Ngundilo tetoyi ngu, oni ene ingowanggo. Hamoo oolengo, enengo sayi ngu kinitetelo ingowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ene ngu oninggaku, ene mande ngu toongoolo, oololo, enengo moondeyi mete tewoku, ngulo mandeni mela bidodomo, elo endeyowolo. Ngundilo ngulo, Yesus ende bidodo newendesina tunoo ko ma uwolo. Kini, ene deguno oni kini kingo mela gumisina nguno nangge oluwolo. Ene nguno oodoni, ene oni simoo bale mela bidodomonggo eneno mayewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nalu gidega yokolo, Yesus Kaperniyam endemo ko oolouwolo. Ooloutoni, oni simoo bale, ene Yesus ya gulano oolooteku ngulo, etoyi, ingowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Oni simoo bale oowooyingga ene ngundilo ingolo, ngulo ene oololo, Yesus oluwoku yanggakuno gooboongootoyi, ngu yanggaku ndindi tetoyi, musiyo gula ma oluwolo. Yamako dabemimo musiyo nguya ndindi tewolo. Nguno, Yesus ene Anutlo mande yunolo oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Mande wesiyolo eloodoni, oni gidalegado sayi oni gula yolo, Yesusno mayewonggori. Ngu oningga ngu kekandeyi bidodo bingo yelo kumoowolo. Ngundilo tetoni, ngulo oni namolayagobo ngu sayi oninggaku, yaba telo, nguno yelo, sumoolo koolowoolo mayewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ene onindo musiyo kuli ukingowonggo. Ngulo ngu, ene sayi oninggaku yolo, Yesus tanggeyimo uweloyi nguya kini. Ngundilo ngulo, ene ya omungo Yesus oluwokusina awuno andangelo, nguwoole ene sayi oninggaku wetoloodoni yawasadodo yeyi, Yesus tanggeyimo uwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ene sayi oninggaku, yawasadodo yeyi utoni, Yesusndo enengo nowoondoyemo hamoo teyingo, ngu kenolo, ngulo ene ngu sayi oninggakuya ewolo. Nangone, no gengo mbumbuwage kuli andangengunootoowe kinitetelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ene ngundilo etoni, asa, ngu naluno nguno, Moseslo mamana mandelo etuyeloyingo oni, ene nguno bibitelo oluwonggoku, ngundo nowoondoyemo ingondudu telo, ngandilo elo ingowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Ndatelo ngulo, nga oningga, ngando ngundilo ete? Hamoo oolengo, ene Anut kootuyisina elo, yumooyinolo mande biyomi ete. Noole ingootetoku, oni gulado mbumbuwa andangeweloyi nguya kini. Ngu Anutndo nangge mete mbumbuwa andangewa! ");
INSERT INTO rwo_karo_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ene mande ngundilo ingowonggoku, ngulo Yesus ene sodedonangge ngu ingonduduyega nowoondoyemo ngu ingowolo. Ngundilo ngulo, enebana gumi ewolo. Ndawugalo, ye ngundilo ingonduduga ngu nowoondoyemo ingootenggo? ");
INSERT INTO rwo_karo_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nondo ndawu mandega etoowe, ngundo mande gumingga dagayeloote? Gengo mbumbuwa kinitete, ewano, bine; ngundi, ge ootookooya, gengo yawasa yoya, oolou ewano. Ndawu mandegado ngu dagate? ");
INSERT INTO rwo_karo_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","No, Oni Nangoni, melako ngano yanggangonedodo onilo mbumbuwa mete andangeweloyi, ngu telo etuyelowelo, ngulo no sayi oningga ngaya eteno. ");
INSERT INTO rwo_karo_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Ge ootookooya, dikaya, gengo yaba yoya, gengo yano oolou! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ngundilo etoni, sayi oninggaku mandeni ngu ingolo, sodedonangge ootookoolo, oni simoo bale bidodo doongeyemo, enengo yaba yolo, koolowoolo oolouwolo. Ngundilo tetoni, oni bidodo soliyokolo, mboolomboolo telo, Anut bingami elo okoolo, ene ngandilo ewolo. Hamoo oolengo, noole kuli oo ngandilo ma kenoyingo! Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ngu naluno, Yesus ene Galili sono koongeyingo tamakuli ko ooloutoni, oni simoo bale oowooyingga oolengo eneno mayewonggori. Mayetoyi, Yesusndo Anutlo mande elo, nguno etuyelowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ngundilo telo, ene oololo, Liwayi, ngu Aripiyas nangoni kenowolo. Kenootoni, ene beye yoweloyi yano (Gabman Takis) nguno bibitelo oodoni, Yesusndo ewolo. Ge ombuya, no keneloya endeyo. Ngundilo etoni, Liwayi ootookoolo, Yesus keyolo, endeyowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ende oololo, Liwayindo Yesus yolo, enengo yano ulo, bibitelo oo newonggori. Bobeye yoyingo oni oowooyingga, mbumbuwadodo oni oowooyingga, ko, Yesuslo sulena oni nguya Yesusndo bibitelo, oo newolo. Ngu naluno, oni oowooyingga Yesusno nowoondoyemo hamoo teyingo, ngulo ene nguya Yesus keyolo endeyowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ngundilo tetoyi, Yuda oni gidalegado, Moseslo mamana mande etuyeloyingo oni, oowooyi Parisi, ngundo Yesus kenootoyi, mbumbuwadodo oniya, ko, bobeye yoyingo oniya oo netoni, yeyolo, ngulo ene Yesuslo sulena onikuno elo, sumoo ewonggori. Ndatelo ngulo, ene bobeye yoyingo oni, ko, mbumbuwadodo oni nguya oo netenggolo? Ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesus enengo mandeye ngu ingolo, enebana gumi ewolo. Oni enengombo goweyimo, sayi kini ingolo ngu, ene sayi mambu yomosiyeyingo, onino (Dokta) nguno ma oolouwanggo. Ngundilo nangge, no oni metemi, ngu yomosiyelowelo ma ombuwono. Kini, no oni mbumbuwadodo ngu yomosiyelowelo ombuwonolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Nalu gulano, Yonlo sulena oni, ko, Moseslo mamana mande etuyeloyingo oni, oowooyi Parisi nguya oowali loogu tewonggo. Ndatelo ngulo, oowali neweloyi naluno, Anutno yemboongelo oowali ma newonggori. Asa, ngu naluno nguno, oni gidalegado ombulo, Yesusno sumoo ewonggori. Ndatelo ngulo, Yonlo sulena oni, ko, Parisi onilo sulena oniya, ngundo oowali loogu tetoyi, ene gengo sulena oni, ngando ngu oowali ma loogu tetenggo? ");
INSERT INTO rwo_karo_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ene ngundilo sumoo elo etoyi, asa, enebana gumi ewolo. Bale kame yoweloyi naluno, dobooye ngu kenolo, oowali kalo, ngu loogu tewanggo, bine? Kini, oni mayewonggoku ngu oodoyi, ene oni oni telo, oowali ma loogu tewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ene kootusina, oni bale yoweloyiga ngu andangelo, enedodo nguya ma oodoni, asa, ngu naluno, ene mete oowali loogu tewanggo. Ngundilo nangge, no nenengo sulena oniya oolootetoku ngano, ene oowali ma loogu tewanggo. Ene kootusina, me onindo noyolo satoyi, asa, ene kowuli koolowootenggoku naluno, ene mete oowali loogu tewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Oni kumba sosowoo kedaga yolo, ngundo nenggulo kulimingga ngulo wetu ngu ma ukingolo wesibiyowanggo. Ene ngundilo tetoyi ngu, asa, ngu kumba sosowoongga wetu ukingowonggoku, ngundo nenggulo ko oomboongewa. Kedaga ngundo kulimingga ngu oomboongetoni, wetu ulungga tunootewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Parisi onilo mande kulimi, ngundo nolo mande keda nguya ma gooboongoowali. Ngu ngandilo, oni gulado bo nangoni kedaga si kuliminggano siliyootoni ngu, asa, ngu si kulimingga ngu oomboongelo, si bo nguya ngu biyomi yewali. Ngundilo nangge, ene bo kedaga ngu yolo, si kedanggano siliyootoyi ngu, asa, ngu siga ngu, ko boga nguya ngu gome oluwalilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Yuda onilo Kengeyingo nalu Sabat gulano, Yesusndo enengo sulena onidodo nggile gula, oowooyi Wit, ko kewoolokuli endeyowonggori. Ene oololo, Wit engge gidalega andangelo, newelo yowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ene ngundilo tetoyi, Parisi onindo Yesuslo sulena onindo oo tewonggoku ngu yeyolo, ngulo ene Yesusno sumoo elo ewonggori. Ingo, kengeyingo naluno, oo yolo neweloyi, ngu loogu oolengo. Ndatelo ene ngundilo tetenggolo? Ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ene mande ngundilo sumoo etoyi, asa, enebana gumi ewolo. Ye bine Dewitndo oo tewoku ngu mande ngu ma kandangelo ingootenggo? Ngu nalungga nguno, Dewitndo enengo onidodo oo kini, ngulo ene oodoolo kumoolo oluwonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ngundilo telo, ngu naluno, Abayiyata ngu, ene Anutno woolo yeyingo oni, ngulo sobosobo tabango oodoni, nguno Dewitndo Anutlo goobooyingo ya newendemo ulo, ene ngu oomanongoyingo kundingiyi Anut doongeyimo oluwoku, ngu yolo newolo. Ngu oomanongoyingo ngu loogu, oni kundingiyi ngundo nangge mete newanggo. Ene Dewitndo ngu yolo, nelo, gumi enengo dobooguliyi nguya yunootoni newonggorilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yesusndo mande gula suleyolo ewolo. Anutndo Kengeyingo Nalu Kundingiyi (Sabat), ngundo oni hooloowetoni, ene kengelo, Anutlo ingondudu tewanggo. Anutlo Kengeyingo Nalungga, ngundo oni ma sobowoowa. Hamoo oolengo kini. ");
INSERT INTO rwo_karo_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ngundilo ngulo, no Oni Nangoni, ngu Kengeyingo Nalu Kundingiyingga, no ngulo Sembuli ulungga oolooteno. ");
INSERT INTO rwo_karo_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Nalu gulano, Yesus goobooyingo ya newendemo ko uwolo. Utoni, oni gula nguno oluwoku, ngu kandeyi biyomi, bingo yelo, oo ma dowooweloyi teyingongga, ngu kenowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ngu naluno, Parisi oni, ko, oni gidalega nguya Yesusndo oo tewelo ingowoku, ngulo sobowoowolo. Ndatelo ngulo, ene ngu oningga, ngu nalu kundingiyimo yomosiyowa, bine; ngundi kini, bine? Ene nguno Yesusndo oningga yomosiyootoni, kenolo, ngunonggo dowoolo mamanangowelo ngulo tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesusndo ngu oni kandeyi biyomingga nguya ewolo. Ge ootookooya, kewooloko dikaya ombulo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Yesusndo ngundilo telo, yowoolengolo, yeyolo, Parisi onino ewolo. Anutlo mamana mandedo kengeyingo nalu kundingiyi, nguno ndawu kongga tewelo ngulo ete? Noole mete oni yomosiyoweloyi, bine; ngundi, noole damoni biyomi yunowato, bine? Ngundi noole Sabatno oni hoolooweyelowato, bine; ngundi noole oni yuleyi kumoowato, bine? Ene ngundilo sumoo etoni, ene Parisi onindo nenetelo, ene mande gumi gula ma ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesusndo yeyondandangelo, nowoondoye kenoyingo ngu, ko oo tewoku, ngulo nowoondoye ma ingowonggori. Kini, enengo nowoondoye yanggango oolengo ukingowonggori. Ngundilo tetoyi, Yesusndo sanggili telo, oni kandeyi biyomingga nguya ewolo. Kandege yoonenengo! Ngundilo etoni, ariya, ene kandeyi yoonenengootoni, kandeyi ko mete tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ene ngundilo tetoni, kenolo, sodedonangge Parisi oni ootookoolo, salo, Gabman onilo tabango oowooyi Herod ngulo keyimo onikuya salo gooboongoowolo. Ene nguno gooboongoolo, Yesus uleyi kumoowelo ngulo oole erewelo ngulo mande mandelo ingowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Ngu naluno, Yesus, ko, enengo sulena onikudodo, ene ngu endega ngu yokolo, ene Galili sono koongeyingo tanggeyimo uwonggori. Nguno simoo bale oowooyingga oolengo Galilinonggo, Yudiyanonggo nguya, Yerusalem ende ngulo simoo bale, Idumiya mela ngulo simoo bale, Yodan sono anduloko simoo bale, Tayiya ende, ko, Sayidon endemo simoo bale oowooyingga oolengo, ngu bidodo Yesusndo ko oo tewoku, ngulo mandeni ingowelo ngulo ene mayelo gooboongoowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yesusndo oni oowooyingga yeyolo, enengo sulena oniya ewolo. Oni simoo bale oowooyingga oolengo oolootenggoku, ngundo no wenggelenelowanggo, bine? Ngundilo ngulo, ye wanggo gula yomosiyoya, no soboneloyi. No ngu sanganimo oolewanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kuli oni simoo bale oowooyingga yomosiyelowoku, ngulo oni sayidodo ngu ene mayelo woologongowolo. Ndatelo ngulo, ene ingootenggoku, ngu kandeye Yesus moondeyimo yetoyi, enengo sayiye kinitewalo ingootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ngu naluno ngu, yuka biyomi oowooyingga oni nowoondoyemo oolootenggoku, ngundo Yesus kenolo, ene boodoo oondookelo, kiyelo, Yesusno ewonggori. Ge Anut Nangoni! Ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ene ngundilo etoyi ngu, Yesusndo mande yanggango mela yuka biyomi nguya ewolo. Ge mande elo, no Anut Nangoni elo, oni gidalegano ma yootunolo ewelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ngu naluno ngu, Yesus pulimo oolewolo. Ene oni gidalega enengombo ingowoku ngu, oni ngu enengo sulena oni teyi, elo yootunoyelowolo. Ene ngu oniku negoyeloyingoku, ngu eneno ombuwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Ene oni kande elaya kegidembolo elaya logoyelowolo. Ngu oni ngu enedodo oluwelo, ngulo logoyelowolo. Ene ngu oni ngu suleyelootoni, toongelo, Anutlo mande wesiyolo eweloyimbolo. Ene ngu oni ngu yanggango yunolo, yuka biyomi andangewelo, ngulo ene yanggangododo yunowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Ene oni kande elaya kegidembolo elaya yootunoyelowolo. Sayimon oowooyi keda gula inolo, ngu Pita ewolo. Yems koneyo Yon elabasa Sebedi simoongo, Yesusndo ngu oowooyali keda gula Bowaneslo yunowolo. Ngu oowooyingga ngu damoni ngu, gusilo. Ndatelo ngulo, mandeyali, damoniyali ngu yanggango oolengo, gusilo ngundilo. Ene Enduru; Pilip; Batolomeyu; Matiyu; Tomas; Yems, Alipiyas nangoni; Tadiyas; Sayimon, nguya logoyelowolo. Sayimon oningga ngu Kenan melakonggo ombuwolo. Sayimonlo damoni ngandilo. Enengo mela ngu mela gula onindo sobowooweloyi ingonduduni kini oolengo. Yudas Isakaliyoot, ngu oningga, ngundo Yesus me oni kandeyemo yelo yootunowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ngu naluno, Yesus yano ooloutoni, oni simoo bale oowooyingga nguya gooboongoowolo. Ngundilo ngulo, Yesus enengo sulena onidodo oo neweloyi nalu nguya kini, ene Anutlo ko ngu nangge simoo baleno tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Oni simoo baledo ene ngundilo kenolo ewolo. Yesus kapengo yetelo ewolo. Ngundilo etoyi, Yesus enengo konebeyibo mande ngundilo ingolo, ene yanggango yelo, Yesus yowelo ngulo ene ombuwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ngu naluno nguno, mamana mande etuyeloyingo oni gidega, Yerusalemnonggo ombuwonggoku, ngundo ewolo. Mboolo biyomi tabango ulungga oowooyi Setan, oowooyi gula Biyelsebab, eneno oodoni, ene ngu yanggangomonggo yuka biyomi gidalega oweyelootelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ene mande ngundilo etoyi, asa, Yesusndo ngu oniku negoyelootoni, tanggeyimo ombutoyi, ene mande yamonggawo gidalega eneno ewolo. Ndawuga Setan, ngundo mete Setan ngu owewa? ");
INSERT INTO rwo_karo_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ende gulananggemo oni nowoondoye ma siyelo ngu, ngu endega ngu ngundilo sugi yanggango ma oluwa. Hamoo oolengo kini. ");
INSERT INTO rwo_karo_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ngundilo nangge, ya gulananggemo oni ngu wesowoolo elaya tunootelo, enengo nangge, ngu ebe utolo ngu, asa, ngu yano oni ngu, ene yanggango ma oluwanggo. Kini ene ya toongoolo, sungo sungo salo oluwanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ngundilo nangge, Setando enengo nangge yuka biyomimboya ebe utolo ngu, asa, wesowoolo elaya telo, yanggango ma oluwa. Ene sodedo kinitewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Oni gula ene mete oni yanggango gulalo yano kingo ulo, oo sitowini andangelo yowa, bine? Kini, ene koletelo ngu, oni yanggangongga ngu utombo gome gosiyolo yokolo ngu, asa, ene mete yanimo ulo, oo sitowini bidodo andangelo yowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","No yeno hamoo oolengo eteno. Anutndo ene mbumbuwa, ko, kootuyisina yumooyinoyingo mande oni simoo baledo tetenggoku, ngu bidodo ene mete andangeyunowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ene oni Yuka Kundingiyi kootuyisina yumooyinolo mande eteku, ngulo mbumbuwa ngu nangge, Anutndo ngu ma andange inowa. Kini, ataga ko kootusina nguya, ngu mbumbuwani ngu suwoo suwoo eneno sugi oluwa. Yesusndo ngundilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ngu mande damoningga nguno, simoo baledo kuli ngandilo ingolo, Yesusno yuka biyomi oolootelo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ngu nalungga nguno, Yesus nemi, konedoboongo, ene Yesusno tunootelo, endesina dikalo, oni gulano Yesuslo mande soweyowolo. Yesus eneno oolenilo, ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ngu naluno ngu, oni simoo bale oowooyingga oolengo, ene Yesus pawangolo, bibitelo oodoyi, enenolo ewolo. Ingo, nangge, konedobooge, ene endesina dikalo, ngunonggo gengo etenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ene mande etoyi, enebana gumi ewolo. Oone ngu namone konedoboone? ");
INSERT INTO rwo_karo_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ene ngundilo elo, oni simoo bale pawangolo, bibiteyingo ngu, yeyondandangelo ewolo. Yo, hamoo, ene ngu nolo namone konedoboone, ene nga oni simoo bale, nolo nowoondoyemo hamoo teyingo nga ngu, ngu nguya nolo namone konedoboone. ");
INSERT INTO rwo_karo_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Yo, hamoo, simoo bale ene Anutlo ingondudu keyootenggoku, ngu ene nolo konedoboone kuwookuwoone, nanamonelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Nalu gulano, Yesus ene ko telo, oni simoo bale Galili sono koongeyingo tanggeyimo, mande etuyelolo oluwolo. Nguno ngu, simoo bale oowooyingga oolengo mayelo, Yesus tanggeyimo gooboowolo. Ngulo ngu, ene wanggo gula sanganimo oolelo, nguno bibitelo, wanggo sono koongeyingo sanganimo oluwolo. Ngundilo tetoni, simoo bale ngu sono dabemimo kelidi sanganimo oluwonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ngu naluno, ene mande mande oowooyingga oolengo mande yamonggawo nangge elo yunowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Ene mande ngandilo yunowolo. Ye ingoyi! Oni gula kono Wit yuwooyi kuliyowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ene ngundilo kuliyootoni, Wit yuwooyi gidega ooleko soletoni, numbo mayelo nemukowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Oo yuwooyi gidalega mela gumi digidodo musiyosina solewolo. Mela nguno ulungga kini. Digi newendemo amuno mela nguya kini, digi nangge. Ngulo oo yuwooyiga ngu sodedo oolewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ene uli ulo, mela newendemo uweloyi kini. Mela bodaga nangge ngulo ngundilo tewolo. Ene sa oolelo, kenootoni aliyewolo. Ngulo digi gookingombo tetoni, bidodo ariyelo kumoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Oo yuwooyi gidale uto so sanggilidodo, kakali dimoo uto oo kewooloko solewolo. Kakali dimoo uto sanggilidodo oolelo, ngundo doobengolo wiliyowolo. Ngundilo tetoni, ngulo ma enggewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ene oo yuwooyi gidalega mela gome oolengomo solewolo. Ngu oo yuwooyigaku gome oolelo, ulungga yelo, gome enggewolo. Gidalega engge onibiga kande elaya (30), gidalega engge onibi kabusa (60), gidalega engge onibi kande elaya (100) enggewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yesusndo oni nguya ewolo. Oni sodeyidodo ngu mande ingoya, ene gome ingonilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kootusina, Yesus enengo sulena oni kande elaya kegidembolo elayagaku, ko, oni gidalega enedodo oolouwonggoku, ngundo nangge oluwonggori. Ngundilo oode, ene mande yamonggawo ngulo Yesus sumoo inowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ene sumoo etoyi, Yesusndo gumi ewolo. Anut Oo Bidodo Sembuli Sembunayi, ngundo enengo simoo bale soboyelooteku, ngu ye etuyelowa. Oni Anutlo mande ma ingooteku ngu, ene mande yamonggawo nangge ingowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ngundilo ngulo, Anutlo mande Ayisayando nguya ngandilo nakangowolo. Ene nguya doongetelo, kenowanggoku ngu, ene oo gula ma kenowanggo. Ene mande ingowanggoku ngu, ene damoni ma ingowanggo. Ndatelo ngulo, enengo damoniye biyomi ma yokolo, yowoolengootoyi, ngulo Anutndo enengo mbumbuwa ma andangewa. Ene mande nga gome ingolo, newende Anut inootoni ngu, asa, Anutndo oni ngulo mbumbuwa bidodo andangeyinowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesusndo sulena oniya ewolo. Ye nga mande yamonggawongga ngalo mande damoni ma ingootenggo. Ngulo ngu, ye mande yamonggawo gidalega ndatelo telogo, ye damoni ingowanggo? ");
INSERT INTO rwo_karo_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nga mande yamonggawongga, nga ngandilo. Ngu oningga oo yuwooyi imiteku ngu, Anutlo mande ngu oo yuwooyi ngundilo imite. ");
INSERT INTO rwo_karo_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Oo yuwooyi oole dabemimo soleteku ngu, oni simoo bale gidalega Anutlo mande ingootoyi, nguno nangge Setando sodedo ombulo, Anutndo mandega oni nowoondoyemo imiteku ngu, andangelo yoote. ");
INSERT INTO rwo_karo_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Oni simoo bale gidalega ngu Wit yuwooyi mela digidodomo soleteku ngundilo. Ene mande ingolo, sodedo yolo, ngulo ene oni oni tewonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ene mande ngulo ene nowoondoyemo yanggango kini. Ngundilo ngulo, nalu bodaga nangge yanggango oodoyi, oni ene Anutlo mande uleyi uweloyi oni, ngundo oni simoo bale, Anutlo mande ingowonggoku, ngu kowuli yunootenggo. Ngundilo tetoyi, sodedo enengo nowoondoyemo hamoo ngu yokolo, ene Anut kootu inootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Oni simoo bale gidega, ngundilo oo yuwooyi uto sanggilidodo kewooloko soleteku ngu, ene mande ingowonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Mande ngu ingolo, ene kowuli guladilo nga melangga ngalo ngu tunootetoni, nguya digi beye ulungga yowelo nowoondoye ngulo nangge hahangelo ingootenggo. Mande ebe ganagana, ko, oo gula gulalo ingondudu telo, ngu damoningga, ngundo Anut mande wiliyowa. Ngu oni simoo bale ngu, ene ma enggewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Oo yuwooyi mela gomemo soleteku ngu ngandilo, ene oni simoo bale gidalega ngu, ene mande ingolo, yolo, gome dowootenggo. Ene ngandilo enggewanggo. Gidalega engge onibiga kande elaya (30), gidalega engge onibi kabusa (60), gidalega engge onibi kande elaya (100) ngundilo enggewanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesusndo ewolo. Oni ngu solu yolo, ombulo, kumbe newendemo yawasa newendemo nguya yewa, bine? Kini, ene tunoo mindingowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Oo bidodo kombiteyingo, ngu kootusina tunootewanggo. Ene mande bidodo onindo wiliyootenggoku ngu, kootusina, solu himimo tunootewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Oni sodeyidodo mande ingoweloyi ngu, ene komo gome ingoni. Yesusndo ngundilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yesusndo mande gula soweyolo ewolo. Mande ye ingootenggoku ngu, ye gome oolengo ingondudu teyi. Yengo damoniye koye nguya ndatelo tewanggoku ngu, ngundilo nangge, gumi yunolo, Anutndo yengo ngu suleyolo, sanganimo nguya yelo yunowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ene oni gula, enengo damoni koni gome tewaku ngu, Anutndo ngu suleyolo, gumi ulungga nguya inowa. Ene oni gula enengo damoni koni bodaga tewaku ngu, ngundilo nangge, enengo koni damoni ngu yokowaku ngu, ene komo kingo oolengo oluwalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesusndo ewolo. Anut Oo Bidodo Sembuli Sembunayi, ngundo enengo simoo bale soboyelooteku, ngu ngandilo. Oni gula oo yuwooyi melako kuliyoote. ");
INSERT INTO rwo_karo_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Suwoono, oningga ngu wetolo oodoni, sano ngu ene ootookoolo endeyowa. Ngu naluno nguno, oningga oo yuwooyi kuliyowoku ngu oolelo, ulungga yelo, enggewoku ngu kenolo, sobowoolo ma ingowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Mela enengombo nangge koyi tetoni, oo yuwooyiga ngu mbongeyi tunootelo, oolelo, ngu uyi yelo enggewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Kootusina, oo enengo nalu tunootetoni ngu, oo sembuligakundo duge dowoolo, ngundo koyi telo, engge yowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesusndo ewolo. Noole Anut Oo Bidodo Sembuli Sembunayi, ngundo enengo simoo bale soboyelooteku ngu, noole ndawuga bungomo kilalongo tewato? Noole ndatelo mandegano ooga bungomo kilalongo mande tewato? ");
INSERT INTO rwo_karo_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Anut Oo Bidodo Sembuli Sembunayi, ngundo enengo simoo bale soboyelooteku, ngu Mastet yuwooyi ngundilo. Ngu de gula oowooyi Mastet, oo yuwooyi gidalega ngu bobodi, ene Mastet yuwooyi ngu buka tanggooli ngundilo, kondibo bobodi oolengo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Oo ngu milo yokootoni, enengombo oolelo, ulungga oolengo yete. Ene oowali gidalega kono ngu bidodo dagayelolo, enendo oolelo, de ulungga yewa. Enengo de kandeyi ulungga yelo, yongeyi tetoni, numbo nguno bibitewanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesusndo mande yamonggawo oowooyingga oni simoo baleno ngandilo wesiyolo ewolo. Oni simoo bale ingonduduno ingoweloyi logoyimolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ene mande gula tunoo oni simoo baleno ma wesiyolo ewolo. Kini, ene mande yamonggawo nangge wesiyolo ewolo. Nalu gula oni simoo bale ma oodoyi, nguno enesu nangge sulena oniya nangge oode, asa, nguno ngu, ene mande yamonggawo ngulo damoni wesiyolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ngu sangga ngu suwootetoni, Yesusndo enengo sulena onikuya ewolo. Noole Galili sono koongeyingo anduloko ulelewatolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ene ngundilo etoni, ngulo Yesuslo sulena oni ngundo ene oni simoo bale ulungga ngu yoyokolo, ene Yesus bibiteyingo wanggogakuno oolewolo. Oolelo, ene Yesus nguya yolo, Galili mela anduloko ulelewonggori. Uleletoni, wanggo gidalega nguya ene keyelolo ulelewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Uleletoyi, ngu naluno nangge, doogo ulungga oolengo tunootewolo. Ngundilo tunootelo, wendeyi yowoolalingolo, dookelo, sono wanggo newendemo nguya uwolo. Ngulo ngu, wanggogaku sonombo koongelo, manggowoomo oolewelo tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ene ngundilo tetoni, ene Yesus ngu wanggo timbuyisina oode, ene nguno tabadudu gula sanganimo welewolo. Wetoloodoni, ene yokutuwoolo mande yanggango ewonggori. Oo etuyeloyingo oni, noole oonatewelo tetetoku nga! Ge bine ma ingoyingo? Ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ene ngundilo etoyi ngu, asa, Yesus ootookoolo, doogogaku kenolo, elo, sono koongeyingongga nguya ewolo. Ge imakeya, tolige ootoo! Ngundilo etoni, sodedonangge, doogo kinitetoni, sononggaku nguya bodaga ma ikakootewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ene ngundilo tetoli, enengo sulena oniya ewolo. Ye sosoletenggo? Ndatelo ngulo, ye nowoondoyemo hamoo kinilo? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ene ngundilo etoni, ene sosoleyingo ulungga telo, enengo nangge enengo kewooloyemo mandelo ingolo ewonggori. Nga oningga nga, ngu oone? Ene mande nangge etoni, ngulo doogo, sono nguya, enengo mandeni ingootelilo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesusndo enengo sulena oniya, Galili sono koongeyingo sagi gidalesina mela gula, oowooyi Gerasin, nguno tunootewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ene tunootelo, wanggo yokolo, sakiko sodedonangge oolewonggori. Ooletoyi, oni gula mboolombo yoyingo oningga nguno oluwolo. Ene nguno ootoolo, ngunonggo ene oni kumooyingo yoyeyingo melewoole bulibali endeyololuwoku, ngundo ombulo, Yesus kenowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Oningga ngu oni melewoole wetolo, endeyolo oluwolo. Oodoni, ene oni gulado nguya ene uto yanggayanggango gula, oowooyi (sen), ngundo gosiyoweloyi nguya ereremo kini. ");
INSERT INTO rwo_karo_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ngundilo ngulo, nalu oowooyingga uto gula, oowooyi sen, ngundo kekandeyi gosiyootoyi ngu, nguya oomboongeloluwa. Ndatelo ngulo, ene oni yanggango oolengo. Ngulo ngu, oni gulado ene dowoolo, gosiyoweloyi nguya ereremo kini. ");
INSERT INTO rwo_karo_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ngundilo ngulo, ene suwoo sa ngu bidodo oni yoyeyingomo ko mela pupulimo nguno nangge oluwolo. Nguno ootoolo, ene ki manggalu telo, digi kuningo ngu yolo, ngundo enengo moondeyi doongoolo oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ene Yesus yowoko oodoni kenolo, ene kendutelo, ombulo, Yesusno penggootewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Bogoomootoni, Yesusndo enedodo ewolo. Ye oo yuka biyomi, ye nga oningga nga, yokoya sayi! Elo ewolo. Ene ngundilo etoni ngu, asa, oo yuka biyomingga, ngundo manggalu ulungga oolengo telo ewolo. Yesus, ge Anut awuno oolengo ngulo Nangoni. Ge ndatelo no tenunowa? Ge hamoo oolengo Anut awuno oolengo ngu oowooyimo, ge hamoo eya. Ge no ogingoyingo ma nunololuwelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ene ngundilo sumoo etoyi, Yesusndo ene sumoo inowolo. Ge oowoongge ndatelo? Etoni, enebana gumi ewolo. No oowoone me oni (Ami). Ndatelo ngulo, damoni ngu noole me oni oowooyingga oolengo! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ngu oomboolo biyomingga, ngundo solengoyelo, sumoo sumoo inolo ewolo. Ge noole nga oomboolo nga oweyelootoyi, noole mela gulano ma sawatolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ariya, mela puli bodaga namoko nguno, bo oowooyingga oolengo nguno oo nelo oluwonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Oomboolokundo Yesusno sumoo ewolo. Ge mete bine noole suleyelootooga, bo kewooloyemo oolouwato. Noole mete ene nowoondoyemo umukowatolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesusndo melamboolokulo mandeye ngu ingolo, gumi ewolo. Ye mete ngundiya teyilo ewolo. Etoni ngu, asa, oombooloku ngu oninggaku yokolo, ene oololo, bokuno newende uwonggori. Ngu bo oowooyingga (2,000) oolengo. Bo ngu yanggango oolengo kendutelo oololo, ulo, mela biyomimo solelo ngunonggo sono koongeyingomo umukowonggori. Boku sono koongeyingo newendemo ulo, ene sono nelo kumoomukowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Bo ene sono nelo kumootoyi, bo ngulo sobosoboku ngu kenolo, ngulo ene salo, ngu mandegaku yolo, ende ulunggakuno ulo, ende bobodimo nguya oolouwonggori. Ene ngundilo tetoyi ngu, oni simoo bale oowooyingga ombulo, ngu oogaku kenowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ene Yesusno mayelo, kuli mboolombo yoyingo oninggaku, ngu kenowolo. Kuli oomboolo oowooyingga eneno oluwonggoku, ene ataga ngu, ene kumba yemulo, enengo ingondudu nguya himi yelo, ene metemi bibitelo oluwolo. Ngundilo oodoni, oni simoo bale ngu kenolo, ngulo ene sosoleyingo ulungga tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ngundilo ngulo, oni ngu oo ngu kenoyingokundo, oni sungokuno ngu oo tunootewoku, ngulo mandeni ewolo. Kuli, oo yuka biyomi ngu oningga nguno oluwoku ngulo, ko, bokulo mande nguya wesiyolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Oni simoo bale mande ngu ingolo, ngulo ene Yesusno ombulo, mande yanggango elo, eneno sumoo sumoo ewonggori. Ge komo nga melangga nga yokoya, mela sungomo toongelo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ariya, ene ngundilo etoyi ngu, Yesus ene wanggo sanganimo oolewolo. Ooletoni, ngu oo yuka biyomi oluwokuno oninggaku, Yesusno sumoo sumoo inolo ewolo. No nguya geya sawalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Etoni, ene Yesusndo gumi ewolo. Kini, ge gengo dobooguligemo oolou! Anut Oo Sembuli, ngundo oo bidodo gengo nowoondoyi telo, oo tewoku, ngulo ge mete eneno wesiyoyalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ariya, ene ngundilo etoni ngu, ngu oninggaku oololo, mela oowooyi Dikapolis, nguno ende kande elaya oluwolo. Ngu endemo nguno, Yesusndo eneno oo tewoku, ngulo mande damoni wesiyolo ewolo. Ngulo ngu, oni simoo bale ngu oo ngulo ingondudu ulungga tewonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Nalu gulano, Yesus wanggo sanganimo ko oolelo, Galili sono koongeyingo anduloko ko ulelewolo. Ngu naluno, oni simoo bale oowooyingga oolengo mayelo, Yesus sono koongeyingo tanggeyimo oluwokuno nguno enedodo gooboongoolo oluwonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ngu naluno nguno, Yuda onilo goobooyingo ya ngulo oni tabango gula, oowooyi ngu Yayiras, ngu Yesus kenolo, ombulo, tanggeyimo bodo oondookelo, penggootelo, sumoolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Nenengo nambone bodaga komo kumoowelo teteku nga! Ngulo ngu, ge ombuya, kandege eneno yetooga, ene ma kumoowelo, mete tenilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yesusndo, enengo mandeni ngu ingolo, ngulo ene Yayirasya ooloutoli, oni simoo bale oowooyingga Yesus pawangolo, moguluwoolo, keyolo oolouwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ariya, bale gula nguya ooloote. Ene suwoo suwoo kombolo sayi yambiyootelo ooloote. Ngu balega ngu mooma nalu kande elaya kegidembolo elaya oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Sayi mambu yomosiyoyingo oni (Dokta), oni oowooyingga oolengo yomosiyootoyi, sayi ma yokowolo. Ene ogingoyingo ulungga ingololuwolo. Ngu balega ngu, enengo beye bidodo oni yomosiyoyingo (Dokta) onino yokololuwolo. Ene enengo sayini ngu bodaga ma yokowolo. Kini, enengo sayini ngu ulungga tunootewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ngu balega ngu Yesuslo mande binga ingowolo. Ngulo ngu, ene mayelo, Yesus tanggeyimo, oni simoo bale ulungga, ngu kewooloyemo, ene nguya, nguno oluwolo. Ene Yesus kootusinanggo ombulo, kandeyi enengo nenggulonimo yewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ndatelo ngulo, balega ngu ingowolo. No kandene enengo nenggulono yetoowe, ngulo sayine yokootoni, no mete tewano. ");
INSERT INTO rwo_karo_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ngundilo elo ingootoni, asa, sodedonangge, enengo daloninggaku soli yewolo. Enengo goweyimo ingootoni, ngu enengo sayinggaku, ataga kinitetelo, ingowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ene ngundilo tetoni ngu, Yesusndo ngu ingowolo. Nenengo yanggangone gidega no noyokolo toongete. Ngundilo ingolo, oni simoo bale kewooloyemo yowoolengolo sumoo ewolo. Onendo nolo towi nenggulonemo kandeyi yetelo? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ene ngundilo sumoo etoni, Yesuslo sulena onindo gumi ewolo. Ge keno! Oni simoo bale ulungga oolengo, ge woologogelootenggo. Ndatelo ngulo ge ngandilo ete? Onendo nono kandeyi yetelo? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yesusndo ngundilo elo, doongetelo endeyowolo. Ene ngu oningga ngu kenowelo, onendo ngu tete. ");
INSERT INTO rwo_karo_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ene ngundilo tetoni ngu, asa, ngu balega sayini yokowoku, ngu ingowolo. Oo ngu enendo tewokulo, ene sosolelo, mboolo utolo, ombulo, Yesus tanggeyimo penggootewolo. Ngundilo telo, Yesusno oo bidodo tewoku, ngu yootunolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ngundilo ngulo, Yesusndo eneno gumi ewolo. Nambone, gengo nowoondoge hamoo teyingo, ngundo goyeni, mete tete. Ge oolouya, gengo nowoondoge ngu mete imakeyingomo olini. Gengo sayinggega ngu mete kinitetelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ariya, Yesus mande etoni, Yuda onilo goobooyingo yalo oni tabangongga ngulo yanonggo ko onikundo ombulo ewonggori. Gengo namboge ngu kuli kumoowolo. Ngundilo ngulo, ge ndawugalo Oo Etuyeloyingo Oni ko ulungga inowalo? Ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesusndo ngu mandega etenggoku, ngu sodeyibo ingowelo ma ingowolo. Kini, Yesusndo goobooyingo yalo oninggakuya ewolo. Ge ma sosolewelo. Ge gengo ingondudu ngu, hamoo tenilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ene ngundilo elo, oni simoo bale ene keyolo, ya newendemo ma uwelo, elo loogu tewolo. Ene Yesusndo Yems, Yon elabasa, Pita ngu oni kabusaga ngu nangge yoyolo, ya newendemo uwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ene Yayirasndo yano ulo, Yesusndo yeyoyingo ngu, oni bidodo mayelo, Yayiraslo ya newendemo ulo, Yayiras namboni bingomo sendo mogulu ulungga tetoyi, ngu yeyowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yesus yeyolo, ya newendesina ulo ewolo. Ndawugalo ye sendo mogulu gilitaka ulungga tetenggo? Nga bale buniyongga nga, ngu ma kumoowolo. Ene wetolo, kapengoyelo ooloote. ");
INSERT INTO rwo_karo_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Yesusndo ngundilo etoni ngu, asa, oniku ngu ingolo, ngulo ene yumooyinowonggori. Ene ngundilo tetoyi, ene Yesusndo oni simoo bale bidodo keyoyelootoni, endesina oolewolo. Eweyi, nemi Yesus enengo sulena oni kabusaga ngundo nangge Yesusndo onibi yeyingo ya guminggakuno uwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ngu naluno ngu, Yesus bale buniyonggaku kandeyi dowoolo, enengo mandenonggo ewolo. Talita kumilo ewolo. Ngu mandega, ngulo damoni ngu ngandilo. Bale buniyo no geya eteno. Ge ootookoolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ene ngundilo etoni ngu, ariya sodedo oolengo, ngu bale buniyonggaku ootookoolo, oololo, ombulo, tewolo. Bale buniyo, ngulo moomani, ngu kande elaya kegidembolo elaya (12). Oniku oo ngu kenolo, ngulo ene soliyokowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Asa, Yesusndo mande yanggango enedodo elo ewolo. Ye nga ooga ngalo oni gulano hamoo oolengo ma ewelo. Ene ataga ye oowali gula yoya, nga bale buniyongga, nga inootoyiga nenilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ngu naluno ngu, Yesus ngu endega ngu yokolo, ene enengo ende damonimo oolouwolo. Enengo sulena oni kilalongo nguya, ene keyolo oolouwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Yudalo Kengeyingo nalu Sabatno, ene goobooyingo yano ulo, oni simoo baleno Anutlo mande etuyelo ewolo. Oni oowooyingga enengo mande ingolo, soliyokolo ewonggori. Nga oningga nga, ndanonggo nga mandega nga yowo? Ngu ndatelo ingonduduga, ngunonggo ene damoni sungo oolengo gula onindo ma teweloyi, ngu ngundilo tete? ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ngu oningga ngu, ya yeweloyi oni nangge. Ene Mariya nangoni. Ene ngu Yems, Yosis, Yudas, Sayimon ngulo baye. Ngulo kuwookuwooye ngu, nooledodo oolootetoku nga, ngundilo elo ewonggori. Ngundilo ngulo, ene Yesusya nowoondoye biyomi ingowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesusndo enengo mandeye ngu ingolo, ngulo enedodo gumi ewolo. Anutlo ingondudu eyingo oni, ngu ende sungomo oowooye bingamidodo oluwa. Ene enengo ende damonimo, enengo sowenimo, enengo ya goboolo onino ngu, ene oowooyidodo ma tewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ngundilo ngulo, ene ngu endega nguno, damoni sungo oolengo gula onindo ma teweloyi, oo ngu ma tewolo. Kini, ene sayi oni gulanangge nanggemo kandeyi okoolo yomosiyelootoni, mete tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ene oni simoo bale Yesusno nowoondoyemo hamoo ma teyingo, ngulo Yesusndo ngu oni ngulo ene ingondudu ulungga tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ariya, ngu naluno, ene oololo, ende sungomo nguno endeyolo, oni simoo baleno Anutlo mande elo etuyelolo, enengo sulena oni kilalongo kande elaya kegidembolo elaya, ngu negoyelootoni ombuwonggori. Ombutoyi, ene ela elaya suleyelootoni sawonggori. Yesusndo ene yanggango yunowolo. Ngu yanggangongga ngu yuka biyomimbolo andangeweloyi ngulo yanggango yunowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Yesusndo ko oniya mande yanggango oolengo ewolo. Ye oomanongoyingo, siyaki, beye, oo ngu bidodo ma yowelo. Usutoko nangge yoya sayi. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ye towikumba elaya ma yowelo. Towi gulanangge nguya, keye goweyi nangge, keye elaya elaya doobengoya sayi. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ye ende gulano uya, oni gulado yeyolo, oni oni telo, yoyolo, enengo yano utoningga ngu, asa, ngu yanggano nguno nangge oodega ngu, saweloyi naluno ootookooya sayi. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ene ende gidalegano satoyiga, ene ye ma yoyoya, enengo yano ma uya, ko yengo mande nguya ma ingootoyiga ngu, asa, ye mete ngu endega ngu yokoya sayi. Saweloyi naluno ngu, ye keyemo gugukakawu oolooteku, ngu endega nguno yonggulumooya sayi. Ngundilo tetoyi ngu, asa, enengo damoniye biyomi yeno tewonggoku ngu eneno sugi sugi oluwalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ariya, ene ngundilo etoni, sulena oni kilalongo sawonggori. Salo, Anutlo mande oni simoo bale nowoondoye yowoolengoweloyi, ngu wesiyolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ene yuka biyomi oowooyingga oweyelolo, bo ulumi sayi onino yelo, sayi oni oowooyingga moondeye dowoolo yomosiyelootoyi, mete tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Herod ngu Rom Gabman oni, ngundo Yudiya melako simoo bale ngulo sobosobo koleteyingo oluwoku, ngundo Yesuslo mande binga ngu ingowolo. Yesuslo oowooyi mela bidodo pawangootoni, simoo bale gidalegado ngu ingolo ewonggori. Sonoyeloyingo Oni Yon, ngu melenonggo ko ootookoote. Ngundilo ngulo, ene mete oo sungo oolengo gula onindo ma teweloyi, ngu teweloyi, ngulo yanggangoni ulungga kandeyimo tunootetelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ngundilo etoyi, gidalegado ewonggori. Ngu Ilayisa ewonggori. Gidalegado ewonggori. Ngu Anutlo Ingondudu Eyingo Oni, kulimiku gulalo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ngundilo ngulo, Herodndo Yonlo mandeni etoyi, ingolo, enebana ewolo. Yon ngu, kuli nondo bungeyi toongoowolo. Ehe! Ene ataga ko ootookooteku ngu! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herodlo sosoleyingo ngulo damoni ngandilo. Kulimi, Herodndo koneyo Pilip baleyi yakakayi yowolo. Balega ngu oowooyi Herodiyas. Yondo Herod elambalisa ngulo mbumbuwayali yootunolo mamanayelowolo. Ngundilo mamanayelootoni ngu, asa, Herodiyasndo Yonya sanggili ulungga telo, Herodno ewolo. Herodndo enengo mandeni ngu ingolo, ngulo ene enengo sulena oni suleyelootoni, oolelo, Yon dowoolo, utombo gosiyolo, ya biyomimo yewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Kuli, Yondo Herodya ewolo. Ge konege baleyi yooteku ngu, Anut doongeyimo ngu, ge damoni biyomi tewolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ngulo ngu, Herodiyas Yonya biyomi ulungga ingowolo. Ene Yon uleyiga kumoonilo ingowolo. Ene Herodndo ngu Yon uleni kumoowelo, ma ingowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ndatelo ngulo, Herod ene Yonlo sosolelo ingoote. Yon ngu Anutlo oni nenengo ootoolo, kundingiyi oluwolo. Ngulo ngu, ene gome sobowoowolo. Nalu oowooyingga, Herod ngu Yonlo mandeni gome ingowelo ingolo, ene ngulo ingondudu kowuli ulungga tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Kootusina, Herodiyas oole ngandilo erewewolo. Herod enengo nalu nemimbo yomoowoolo nalu ngulo ingondudu tewelo ngulo ene oo simbo ulungga kawolo. Nguno ngu, me oni tabango ululu, enengo Gabman oni tabango ululu ngulo nguya, Galili melako oni tabango ngu nguya mayelo gooboongoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ngu naluno nguno, Herodiyas namboni, ngundo ya newendemo ombulo, ngu gome oolengo kunowolo. Herodiyas nambonimbo yambono gome kunootoni, ene ngulo gome ingowolo. Ngundilo ngulo, Herodndo bale buniyongga nguya ewolo. Ge oo gulalo ingoya ngu, ge nono e! Ngundilo tetoyi, hamoo oolengo, no gunowanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Herod ene solumimonggo hamoo oolengo, ko ewolo. Ge komo nono oo gula nuno, ewaku ngu, no hamoo gunowano. Ge nolo mela oo sitowine nga kewoolo wesowooya gidale no nuno, elo ewaku ngu, ariya, no mete ngundilo telo gunowanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ngundilo etoni, balegaku mandeni ngu ingolo, ngulo ene endesina oolelo, nemimo sumoo ewolo. No ndawugalo ewano? Etoni, nemimbo gumi eyingo, Ge Sonoyeloyingo Oni, Yon, ngulo tabangombolo e! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ariya, bale buniyonggaku nemimbolo mandeni ngu ingolo, ngulo ene sodedo ko ombulo, Herodno ewolo. No Yon tabango yowelo ingoote. Anangu, ge Yon tabango toongooya, koondo samayi gulano yeya, yoya, ombuya, nonunolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ariya, Herodndo mandeni ngu ingolo, ngulo ene newende ngu kowuli ulungga ingowolo. Ndatelo ngulo, ene kuli mande yanggango solumimonggo oni doongeyemo elo gosiyowolo. Ngundilo ngulo, ene bale buniyo ngulo mandeni ngu ma yokowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ariya, ngundilo ngulo, Herodndo me oni gula suleyootoni, ya biyomimo oololo, Yon tabango toongoolo, yolo ombuwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Toongoolo, koondo samayi gulano, Yon tabango yelo, yolo, ombulo, Herod inootoni, ngundo bale buniyonggaku inowolo. Bale buniyongga, ngundo yolo, oololo, nemi inowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ngundilo tetoni, Yonlo sulena oni mande binga ngundilo ingolo ngu, asa, ene ombulo, Yon bingo yolo, salo melengoowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ngu naluno nguno, Yesuslo sulena oni kilalongo ko mayelo, Yesusno gooboongoolo, simoo baleno ko tewonggoku ngulo mandeni Yesusno wesiyolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ngundilo telo, Yesusndo sulena onikuya ewolo. Oni simoo bale oowooyingga oolengo oololo, ombulo tetoyi, ngulo noole oo ma newato. Ariya, sodedonangge, noolengo nangge mela gula oni kini nguno salo, noole bodaga kengewatolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Etoni, ngulo ene wanggo yolo, mela gula oni kini nguno sawonggori. Enesu nangge sulena oniya nangge sawonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ene oni simoo bale oowooyingga oolengo yeyolo ingowolo. Ngulo oni simoo bale oowooyingga endeni endeni bidodo kendutelo, ngu mela gidalesina nguno ene nguya salo, ene koletelo, Yesusno tunootewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ene Yesus oololo, sono dabemimo mayelo, wanggo gosiyolo, oni simoo bale oowooyingga yeyowolo. Ngulo ene nowoondoyi yunolo ingowolo. Ngu oni ngu Sipsip sobosobo kinilo ingowolo. Ngulo ngu, Yesusndo mande damoni yelo, mande oowooyingga oolengo elo etuyelowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ngundilo telo oodoyi, sa uwelo tetoni, Yesuslo sulena oni Yesus tanggeyimo ombulo ewonggori. Nga melasina ngano oni kini. Ngundilo ngulo, nalu kiniteteku nga. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ge oni simoo bale nga suleyelootooga sayi. Ene mete ende namoko namoko ngano salo, nguno ene oowali uliyowanggolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ene ngundilo etoyi, Yesusndo mande gumi ewolo. Yendo oowali yunowanggo. Etoni, enengo sulena oni enebana gumi ewonggori. Ge, bine, noole oolouya, digi doobeno nangge onibigado (Kina 200) oomanongoyingo uliyoya yunowootolo? Ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ene ngundilo sumoo etoyi ngu, asa, Yesus enebana gumi ewolo. Ye oomanongoyingo ndatelo? Ye oolouya kenoyilo ewolo. Etoni, ene oololo, kenolo, gumi ewonggori. Noole oomanongoyingo kandegula, ko, iso elaya nangge oolootelo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ene ngundilo etoyi, Yesusndo enedodo gumi ewolo. Oni simoo bale ene mete tambuyi tambuyi so metemimo nguno bibiteyilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ariya, oni bibitewonggoku ngu, wata oowooyingga onibi elaya kande elaya (50), wata oowooyingga onibi kandegula (100), ngundilo bibitewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ene ngundilo bibitetoyi ngu, ariya, Yesus ene ngu oomanongoyingo kandegula, ko iso elayaga ngu yolo, ene Sambono doongetelo, Anutno esetelo yemboongewolo. Yemboongelo yokolo ngu, ene oomanongoyingo oososowoolo, sulena oni kilalongo yunootoni, ngundo oni simoo bale bayetelo yunowolo. Iso elayagaku nguya ngundilo nangge tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ngundilo tetoyi, oni bidodo netoyi, useye ndindi tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Oni simoo bale oo ngu netoyi, oomanongoyingo sosolango, iso sosolango nguya oliyingoku, ngu gooboongoolo, si kande elaya kegidembolo elaya (12) siliyootoyi, si manggowoomo oolelo angewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Oni ngu oomanongoyingo neyingo, simoo nangge oowooyingga oolengo (5,000). ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Kootusina, Yesusndo enengo sulena oni kilalongoku eririyelolo ewolo. Ye sodedo wanggo sanganimo ooleya, ye koleteya Galili sono koongeyingo andu, Betsayida mela gidalesina ooloutoyiga, nobana oni simoo baleno etoowe, satoyigo oolouwanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ene ngundilo elo, oni simoo bale suleyelootoni, satoyi, Yesus enesu nangge mela pulimo oolelo, nguno Anutno yemboongewelo ngulo ene oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Suwootetoni, wanggo sono koongeyingo kewooloko oodoni, Yesus enesu nangge puli bodaga nguno yemboongelo oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ngu naluno ngu, doogo ulungga oolelo, ngundo wanggo wenggelenggereyelowolo. Ngundilo tetoni, ene de sosimbo sono sanggawelo wanggo woosoolo oolouweloyi, ko yanggango oolengo teloluwonggo. Sengewelo mela wendooketoni, ariya, Yesus ene Galili sono koongeyingo sanganiwoole kewoongolo, enengo sulena onino oololo, dagayelowelo tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Enengo sulena onikundo Yesus kenootoyi, Galili sono koongeyingo sanganiwoole kewoongolo, eneno oolouwolo. Ooloutoni, sulena onindo Yesus kenolo, oo gabo elo ingolo, ngulo ene ki manggalu ulungga tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Oni bidodo ngundilo telo, kenolo, sosoleyingo ulungga tewonggori. Ngundilo ngulo, sodedonangge, Yesusndo enedodo mandelo ewolo. Ye nowoondoye yanggango yeyi. Nondo nangge ombutenoku nga! Ngulo ye ma sosolewonggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ngundilo elo, Yesus wanggo sanganimo ooletoni, ngu naluno nangge, doogogaku kinitewolo. Ngundilo tetoni, nowoondoye sosolelo, ingondudu ulungga oolengo tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ndatelo ngulo, Yesusndo oomanongoyingongga oni simoo bale yunowoku, yanggangoningga ngulo ma ingondudu tewolo. Kini, enengo nowoondoye ukingowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ene Galili sono koongeyingonggaku usowoolo, mela oowooyi Genesaret, ngu gidalesina mayelo, wanggo gosiyowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ene wanggo yokootoyi, sodedonangge oni simoo bale Yesus kenolo, ene ingowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ngundilo ngulo, oni sodedonangge ende gulasina gulasina kendutelo salo, ene sayi oni yoyolo, Yesus ndano oolooteku, nguno mayewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yo, hamoo, ende bobodi, ende ululu, ndawu melanggasina Yesus tunootetoni ngu, asa, ene sayi oni ende kewoolokono yoyewonggori. Ene ngundilo telo, Yesusno sumoo sumoo elo, inowonggori. Ndatelo ngulo, sayi onindo nangge kandeye Yesusndo nenggulo dabemisina yetoyi ngu, asa, sayi oniku bidodo mete temukowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Moseslo mamana mande sobowooyingo oni, ngu oowooyi Parisi oni gidalega, ko, mamana mande etuyeloyingo oni gidalega, ngundo Yerusalemnonggo ombulo, Yesusya gooboongoowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ene Yesuslo sulena oni gidega kandeye ma sonowoolo oo dowoolo, netoyi yeyowonggori. Parisi onindo yeyolo, ngulo ene nowoondoye kowuli yelo ewonggori. Noolengo osisambanayimbolo damoni ngundilo kini. ");
INSERT INTO rwo_karo_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Parisi oni, Yuda oni bidodo, enengo osisambaye damoniye keyelolo, kandeye gome ma sonowoolo ngu, asa, ene oo ma dowoolo newanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ngundilo nangge, ene oo uliyoweloyi musiyomo salo, ngunonggo mayelo ngu, ene kandeye ma sonowoolo ngu, asa, ene oo ma newanggo. Ene osisambaye mamana mande oowooyingga damoni gidalega nguya keyolo, ngulo ene sono toba, kumbe, koondo, oo ngu bidodo ngu damoningga ewoku, ngu keyolo sonowoowonggori.) ");
INSERT INTO rwo_karo_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ngundilo ngulo, Parisi oni, ko, mamana mande etuyeloyingo onikundo Yesus sumoo inowonggori. Ndatelo ngulo, gengo sulena oni, ene osisambalo damoni ngu ma keyootenggo? Enengo kandeye ngu sugabododo oo dowoolo netenggo. Noolengo osisambanayimbolo damoni yombuliyootenggolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ene ngundilo etoyi, Yesusndo gumi ewolo. Anutlo Ingondudu Eyingo Oni Ayisayando yeya mebuye sangala nakangowolo. Ene mande ngandilo nakangowolo. Ngu oni gidalega ngu, ene kingo manggoyemonggo no bingaminelo okootenggo. Enengo nowoondoyemo biyomi ingootenggoku, ngu damoniyemonggo tunoo etuyelootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ngulo ngu, ene kingo nono yambo mande tetenggo. Ene onilo mamana mande nangge oni simoo baleno wesiyolo etuyelootenggoku ngu, ngundilo ngu ebe ganaganalo ewolo. Noole Anutlo mande nangge wesiyolo etetolo ewolo. Ayisayando ngundilo nakangowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yesusndo ewolo. Ye Anutlo mamana mande ngu andangelo yokolo, ye onilo damoniye ngu nangge, yanggango gome dowootenggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesusndo mande gula soweyolo ewolo. Yengo ingonduduye yowoolalingoweloyi oni, Anutlo mamana mande ngu andangelo yokowelo, gome ingootenggo. Yengo damoniye ngu nangge keyootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Kulimi, Mosesndo Anutlo mamana mande nguno ewolo. Ge mete gengo awanangge manggowo keyo. Oni gula enengo eweyi nemimboya mande biyomi elo ngu, asa, ene hamoo oolengo udoyi kumoowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ye Anut kootu inolo, ngandilo etenggo. Oni gulado bobeye oododo eweyi nemi hoolooweyeloweloyi, ene eweyi nemi elayagakuya elo ewa. Nga bobeyega nga ngu, no Anut inowelo yewanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ene ngandilo etenggoku, damoni nenengo kini ewolo. Ariya, eweyi, nemi yomosiyoweloyi damoni ngulo gome ma ingootenggoku, ngulo ye ganayeloya, eneno etoyiga ene ingoyi. Ngu damoningga tetenggoku, ngu gome oolengolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ngulo ngu, ye damoni osisambayemonggo yoyingo ngu keyootenggoku ngu, ye Anutlo mande ngu yeyi, kingo oo ngundilo tetenggo. Ye damoni oowooyingga ngundilo oowooyingga tetenggo. Ye ngu mandega ngu elo etuyelootenggoku, ngu Anutlo mamana mande toongootenggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yuda onilo damoniye ngu ngandilo. Oni sowe oowooyingga oowali oo dowootoyi, ngu oo ngu ma newonggori. Nguno Yesusndo oni simoo bale ko negoyelo ewolo. Ye bidodo nolo mande nga ingoya, ngulo ingondudu teyi! ");
INSERT INTO rwo_karo_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Oni gula goweyi sanganimo oo oolooteku, ngundo newendesina ulo, ngundo oni yeni, ma biyomi yewa. Kini, damoni biyomi oni newendemo oolooteku, ngundo endesina ooleteku, ngundo oni yeni, biyomi yewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Oni sodeyi mande ingoweloyi tetoningga ngu, ene komo nga mandega nga, gome ingonilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ene oni simoo bale ngu yoyokolo, yano oolouwolo. Enengo sulena onikundo ngu mande yamonggawongga, ngulo sumoo inowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ene sumoo etoyi, Yesusndo gumi ewolo. Ye nguya ingonduduye kini? Ye bine ma ingootenggo? Oo bidodo oni endesina oolooteku, ngundo oni newendesina ulo, ngundo oni yeni, ma biyomi yewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ndatelo ngulo, oo ngundilo ngundo oni nowoondoye oolengomo ma ute. Kini, ngu enesu useyi newendemo ulo, ngunonggo oolelo toongete. Ngu mandega nguno, ngu Yesusndo oowali bidodo metemi ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ene mande gula suleyolo ewolo. Damoni biyomi oni newendemo oolooteku, ngunonggo endesina ooleteku, ngundo oni yeni, biyomi yete. ");
INSERT INTO rwo_karo_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","23","Damoni biyomi oni newendemo oolooteku, ngunonggo ootookoolo, endesina oolete. Ngu ngandilo. Ingondudu biyomi teweloyi damoni; bosebalese teweloyi damoni biyomi; yakaka teweloyi damoni; oni uleyi kumooweloyi damoni; oni bale gidalega yakakayi yodowoolo yombuliyootenggoku damoni; oo kenomayingootenggoku damoni; damoni biyomi oowooyingga; ebe ganagana mande teweloyi damoni; oyumoyumo teweloyi damoni; oo kenomayingoweloyi damoni; yumooyinolo mande, sanggili teweloyi damoni; oni enengombo enengo ingootoni, ulungga teteku ngulo damoni; wenonoyingo mande eweloyi damoni; ngu damoni biyomi ngu bidodo oni nowoondoyemonggo endesina tunootelo, ooleteku, ngu bidodobo oni yeni, biyomi yetelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesus ootookoolo, ngu endega ngu yokolo, Tayiya ende, Sayidon melasina oolouwolo. Ene oololo, ya gula newendemo ulo, Yesus nguno kengewelo ingolo kombitetoni, oni gulado nguno mayelo ma kenowelo, elo ingowolo. Ene Yesus kombiteweloyi nguya ereremo kini. ");
INSERT INTO rwo_karo_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Kini, sodedonangge bale gulado Yesusno nguno oolooteku, ngu etoyi ingowolo. Ngu balega ngu, ene namboni bodaga nguno oo yuka biyomidodo ngu oluwolo. Ngu balega ngu Girik balega ene ngu Salopinisiya melako mayelo, nguno oluwolo. Ngundo, ene Yesus oluwoku ngu ingolo, ngulo sodedonangge ene yano ombulo, Yesus keyi damonimo boodoo oondookewolo. Ene boodoo oondookelo, Yesusno sumoo sumoo ewolo. Yesus gedo melamboolo nolo nambonemo oolooteku, ngu owenilo ewolo. Ndatelo ngulo, ngu balega ngu newendemonggo hamoo ingoyingo, Yesus ene mete nambone yomosiyowalo ingowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesusndo Yuda onilo ingondudu ngu ngandilo ingowolo. Noole Yuda oni ngu noole oni oolengo, elo, oni sowe gidalega Yuda oni kini, ngu se ngundilo, elo ingootenggo. Ngulo ngu, Yesusndo ngandilo ewolo. Noole simooye oowali yunootooye, nelo yokootoyiga, kootusina gumi yolo, se yunowato. Simooye oo ma neyingomo oo ngu yolo, se ma inowatolo ewolo. Yesusndo ngu balega ngulo newendemo hamoo teyingo, ngu tewoongolo, ngulo ene ngundilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ene balegakundo Yesuslo mande gumi ewolo. O Oni Ulungga, ge hamoo ete. Ene sebo ngu oo neweloyi yaba newendemo simooyembolo oo sosolango, ngu netenggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ene ngundilo etoni, Yesus enebana enedodo gumi ewolo. Ge ngundilo etekulo, ariya, ge mete oolou! Melamboolo biyomi ngu kuli namboge yokolo toongewolo ewolo. Ndatelo ngulo, Yesusndo enengo newendemo hamoo teyingo, ngu yanggango kenolo ngulo ene mande ngundilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ariya, balegaku enengo yano ko oolouwolo. Ene ko oololo, ene namboni yabano wetolo oodoni, kenowoku, oomboolo ngu ene kuli yokolo toongewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ngu naluno nguno, Yesus ko ootookoolo, Tayiya mela yokolo, Sayidon mela nguya yokolo, yade mela gula oowooyi Dikapolis nguno oolouwolo. Ngu melako nguno ende ululu kande elaya nguno oluwolo. Ngu kewooloye oolengowoole yade oololo, Galili sono koongeyingo ngu tanggeyimo tunootewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Oni sowe gidalegado oni gula sodeyi tuwoo ko mandeni moole nguya kini, ngu yolo, Yesusno mayewonggori. Mayelo, ene Yesusno solengoyelo, sumoo sumoo inolo, ngu oningga nguno kandeyi yeya yeningga, mete tenilo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ariya, Yesusndo enengo mandeye ngu ingolo, ngulo ene oninggaku yolo, oni simoo bale yoyokolo, sungo oololo, nguno enesu nangge dikawoliyo. Dikalo, Yesusndo kandedibiyi ngu oningga ngu sodeyimo yewolo. Yelo, kandedibiyi yolo, muketelo, oninggaku mebuyimo yewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Yelo, Yesus Sambono randolo doongetelo, yanggango iyangelo, newende sendoweloyi tewolo. Ene ngu oninggakuya enengo mandenonggo ewolo. Epata! Ewolo. Ngulo damoni ngu ngandilo. Ge goosoo! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Asa, ngu naluno nangge, oni sodeyigaku ngu himi yetoni, oo mebuyi gosiyoyingonggaku sodedonangge peselo toongewolo. Ene mete mande metemi ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ene mete tetoni, ene Yesusndo loogu yanggango yunowolo. Ene oni gulano nga ooga ngalo ma ewelo. Ene Yesuslo mande ma ingolo, ene yanggango yelo, ngulo damoni wesiyolo, elo endeyowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Yo, hamoo, simoo bale bidodo ngulo mandeni ngu ingolo, ene hamoo sosoleyingo ulungga oolengo telo, ene ewonggori. Yesusndo oo bidodo tewoku ngu gome oolengo tete. Ene komo oni sodeye tuwoo ngu tetoni, mande gome ingootenggo. Oni mandeye kini, ngu nguya mande gome etenggolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ngu nalunggano, nguno oni simoo bale oowooyingga oolengo gooboowonggori. Ene gooboongoolo, ene oowaliye nguya kini. Ngundilo ngulo, Yesusndo enengo sulena oniku negoyelootoni, ombutoyi ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","No nga simoo bale ngalo nowoondoyi yunooteno. Nalu kabusa noya oluwootoku, ene oowaliye nguya kini. ");
INSERT INTO rwo_karo_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ene oodoolo kumootoyi, suleyelootoowe, enengo yano sawelo salo ngu, asa, oolekono doongeye toongootoni, mela wongosogulumoolo yulewa. Ngulo ngu, oni gidalega ngu yowokononggo mayewonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ene ngundilo etoni, sulena onindo gumi sumoo ewonggori. Nga mela gumisina ngano oni kini, ngulo noole oowali ndanonggo yolo, oni simoo bale yunootooye newanggolo? Ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ngundilo sumoo etoyi ngu, asa, Yesusndo sumoo gula yunowolo. Ye oomanongoyingo ndatelo? Ewolo. Enebana gumi ewonggori. Kandegula gidembolo elayalo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yesusndo mandeye ngu ingolo, ngulo ene simoo baleya ewolo. Ye melako bibiteyilo ewolo. Bibitetoyi, Yesusndo ngu oomanongoyingo kandegula gidembolo elayagaku yolo, Anutno yemboongelo yokolo, oososowoolo, enengo sulena oni yunowolo. Yunootoni, ngundo bayetelo, simoo bale yunowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ene iso bobodi gidalega nguya moole. Ngulo ngu Yesus ene nguya yolo, Anutno iso ngulo esetelo, yemboongelo yokolo ngu, asa, ene sulena oniku iso yunolo ewolo. Iso nguya bayeteya, simoo bale yunoyilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ngundilo yunootoyi, oo netoyi, mete tetoni, oo sosolango oodoni gooboongoolo, nguno ngu ene si kandegula gidembolo elaya siliyootoyi, angewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ngu oni ngu oowooyingga oolengo 4,000 oluwonggo. Ngundilo telo, Yesusndo oni simoo bale suleyelootoni, enengo endemo endemo sawonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ene ngu naluno, enengo sulena onidodo wanggo sanganimo oolelo Dalumanuta melasina nguno sawonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Moseslo mamana mande sobowooyingo oni oowooyi Parisi ombulo, Yesusya mande gumgum elo longgeyolo, Yesus tewoongowelo ngulo ene sumoo ewonggori. Sambo ende sunggi oolengo gula onindo ma teweloyi, ngu teya, etuyelootooga kenowootolo ewonggori. Ngu kenolo, noole ingowato. Hamoo oolengo, ge Anut Nangoni oolengo yanggangonggedodo, elo tewoongowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesusndo mandeye ngu ingolo, ngulo ene kowuli ingolo, yanggango yuka oolongoolo ewolo. Ndatelo ngulo, nga simoo bale nga nalungga ngano oode sunggilo etenggo? No hamoo yeya eteno. No sunggi gula nga nalungga ngano hamoo ma tewanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ngundilo ngulo, ene ko yoyokolo, wanggo sanganimo oolelo, ene Galili sono koongeyingo gidalesina toongewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yesuslo sulena oni oowali kapengoyelo, oomanongoyingo ma yolo ombuyingo, ene oomanongoyingo gulanangge wanggono oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ngu naluno nguno, Yesusndo mande yanggango enedodo ewolo. Ye ingondale teyi! Parisi oni, Gabman oni tabango ulungga Herod ngundo oomanongoyingo yeni, koongeweloyi Yis, ngulo gome doongeteyi. Enengo mandeye ngu Yis oomanongoyingo newendemo utoni, koongeteku ngundilo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Enengo nangge elo ingolo ewonggori. Ene ngundilo eteku ngu, ndatelo ngu, noole oomanongoyingo ma yoyingolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Asa, Yesus ene ingolo, ngulo gumi ewolo. Ndatelo ngulo, yengo nangge mande ngundilo etenggo? Noole oomanongoyingo kini? Ye, bine, ingonduduye kini? Ye bine kuli ma ingoyingo; ngundi, nowoondoye ukingoyingo, bine? ");
INSERT INTO rwo_karo_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ye doongeyedodo, ye oo ma kenoyingo? Ye sodeyedodo, ye mande ma ingootenggo? Kapengo yetenggo, bine? ");
INSERT INTO rwo_karo_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Kuli, no oomanongoyingo kandegula oososowoowonoku, oni oowooyingga oolengo 5,000 yunowonoku, ngulo ngu gumi oodoni, ye si ndatelo siliyootoyi, manggowoomo oolewolo? Ewolo. Etoni, enendo gumi ewonggori. Kande elaya kegidembolo elayalo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Asa, Yesusndo mande gula soweyolo ewonggori. Nalu gulano, oomanongoyingo kandegula gidembolo elaya oososowoowonoku, oni oowooyingga oolengo 4,000 yunowonoku, ngu gumi oodoni, ye si ndatelo siliyootoyi, manggowoomo oolewo? Elo sumoo etoni, enebana gumi ewonggori. Kandegula gidembolo elayalo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ngundilo etoyi ngu, asa, Yesusndo sumoo gula elo yunowolo. Ye ngu kenolo ma ingootenggo, bine? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesus ko sulena oni nguya, ene Betsayidano oololo tunootewonggori. Ngu oni simoo bale gidalega, ngundo oni gula yolo, Yesusno mayewonggori. Ngu oningga ngu, doongeyi kilingo. Ngulo ngu, ene Yesusno solengoyelo, sumoo sumoo inolo ewonggori. Ge kandege nga oninggano ngano yetooga mete tenilo sumoo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ariya, Yesusndo mandeye ngu ingolo, ngulo ene oni doongeyi kilingonggaku kandeyi dowoolo yolo, ende yokolo, ende dabemimo oolewoliyo. Yesusndo ngu oni doongeyinggakuno muketewolo. Muketelo, Yesus kandeyi ngu oninggakuno yelo, sumoo inolo ewolo. Ge oo kenoote, bine? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ene ngundilo etoni, ngu oni doongeyi biyominggaku doongetelo, gumi ewolo. No oni yeyootoowe ngu, de ngundilo telo, ene oololo ombulo tetenggo. Oo gome ma kenootenolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ngundilo etoni ngu, asa, Yesusndo kandeyi, oni doongeyi biyominggakuno ko yewolo. Ngundilo tetoni, oni doongeyinggaku yanggango doongetelo, metemi oolengo telo, oo bidodo gome tunoo kenowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ngundilo telo, Yesusndo ngu oninggaku suleyootoni, enengo yano oolouwolo. Ene Yesusndo oninggakuya ewolo. Ge ende kewooloko sodedo ma uwelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesus enengo sulena oniya ootookoolo, ende gula oowooyi Sesariya, gula oowooyi Pilipayi nguno sawonggori. Salo, ooleko sulena oni sumoo yunolo ewolo. Oni simoo baledo noya ndawu oningga etenggo? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ene ngundilo sumoo etoni ngu, asa, sulena onindo Yesusno gumi ewonggori. Oni gidalegado ngu geya ngandilo etenggo. Sonoyeloyingo Oni Yon. Etoyi, ene oni gidalegado ngu ngandilo etenggo. Ge Ilayisa, Anutlo Ingondudu Eyingo Oni. Etoyi, ene gidegado ngu etenggo. Ge Anutlo Ingondudu Eyingo Oni gula, etenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ngundilo etoyi, Yesus enebana sumoo yunowolo. Yendo ngu noya ndawu oningga etenggo? Ewolo. Pitando enengo mandeni ngu ingolo, ngulo ene sodedonangge gumi ewolo. Ge Kristus, Anutndo noole yoyowelo sunggi yeyingo oni. ");
INSERT INTO rwo_karo_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ngundilo etoni, Yesusndo mande yanggango ewolo. Ye nga mandega nga onino ma ewelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesus damoni yelo, sulena oni mande keda mesalango ngu elo etuyelo ewolo. Oni Nangoni tunootewoku, ene komo oo bidodo ogingoyingo ulungga yowa. Tabango oni, Anutlo Woolo Yeyingo Onilo sobosobo mamana mande etuyeloyingo oni nguya, ngundo mande biyomi elo, kootu inolo, uleyi kumoowa. Ene nalu kabusa oode, nguno ko ootookoowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesusndo ngu mandega ngu tunoo oolengo etoni, Pitando Yesus yolo, sosina oololo, damoni yelo mamanangowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ngundilo tetoni ngu, asa, Yesusndo Pita kootu inolo, yowoolengolo, sulena oni yeyolo, Yesus enebana Pita mamanangolo ewolo. Pita, ge Setanlo ingondudu ete. Setan, ge ombuya kootunesina oolou! Ge Anutlo ingondudu ma ingoote. Kini, ge onilo ingondudu nangge ingootelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ngundilo elo, Yesusndo enengo sulena oni, ko, oni simoo bale nguya negoyelootoni, mayelo, gooboongootoyi, mande yunolo ewolo. Oni gula no kenelowelo ngu, ene mete enengo ingonduduni bidodo yokoya, kowuli ene inootenggoku ngu de mombi ngundilo koolowooya, no keneloya endeyoni. ");
INSERT INTO rwo_karo_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Oni gula enengo ingonduduni, yanggangoni gome dowoolo, goweyi sugi oluweloyi ingooteku ngu, enengo ootootoni Anut doongeyimo hamoo oolengo oonatewa. Oni gula enengo ingonduduni ootootoni bidodo no nunolo ngu, ene ngunonggo mandene keda mesalango ngulo ingolo, gome dowoolo ngu, asa, ene mete kootusina Sambo endemo sugi sugi keda nguno oluwa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Oni gula mela ngalo oo bidodo yomukolo oode, kumoowaku ngu, ndawugado ene hooloowewa? ");
INSERT INTO rwo_karo_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ngu oningga ngu, ene ndawugalo enengo goweyi yanggangoni keda oluweloyi ngu uliyolo yowa? Oni gulado Anutlo endemo oolouweloyi oole ngu enengombo oo gulado hamoo oolengo uliyoweloyi kini. ");
INSERT INTO rwo_karo_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ataga, oni simoo bale endeni endeni bidodomo elambalisa oluweloyi yombuliyolo, bulibali endeyolo, damoni biyomi ngulo ingondudu telo, Anutlo mande kootu inootenggo. Ene oni gula oni ngu kewooloyemo ootoolo, ngunonggo nolo mandene damonine elo, oyumo yolo oolooteku ngu, ariya, kootusina, no nguya Awanembolo yanggangoni dulidalini, Sambono Engel oni kundingiyi, ngudodo ombutetoku naluno, no nguya hamoo oolengo, ngu oningga nguya oyumo yowano. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ngu naluno nguno, Yesusndo enedodo ewolo. Hamoo oolengo, no yeno eteno. Oni gidalega nga dikatenggoku nga, gumi ma kumooyingomo, Anutndo enengo simoo bale soboyelooteku naluno, enengo yanggangonidodo tunootetoni ye kenowanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kootusina, nalu kandegula gidembolo gulanangge yokolo, Yesusndo Pita, Yems, Yon, ngu oni kabusaga ngu yoyolo, mela puli pelungga ndandayingo oolewolo. Nguno oolelo, enesu nangge oluwonggo. Ngu naluno, Yesus moondeyi ngu oni kabusaga doongeyemo yowoolengolo, Yesus enesu guladilo tunootewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Yo, hamoo, Yesuslo towikumbani ngu solu ngundilo yowali, ko, namboyi oolengo tunootewolo. Melako ngano oni gulado towikumbani oo ngundilo yeni, ma namboyi yewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ngu naluno, Ilayisa, Mosesya Yesus tanggeyimo tunootelo, Yesusya mande etoyi, sulena oni kabusaga, ngundo ngu yeyowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Pitando oo ngundilo kenolo, ngulo ene soliyokolo, Yesusno ndawu mandega ewanolo, ngu ma ingowolo. Ngundilo ngulo, ene Yesusno ngandilo ewolo. Oo etuyeloyingo oni, noole ngano oluweloyi ngu gome. Ngulo ngu, gedo mete elo etoni ngu, asa, noole tookoododo kabusa yewato. Gula gengo, gula Moseslo, gula Ilayisalo yewatolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Pitando mande etoni ngu, asa, ngu naluno nangge, goboole gula tunootelo, ngundo doobeyelowolo. Doobeyelootoni, Anutndo ngu goboole kewoolokononggo tunootelo ngandilo ewolo. Ngu nenengo nangone, no nowoondone ngulo gome ingooteno. Ye enengo mandeni, ngu gome ingoyi! ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ene ngundilo etoni, asa, sodedo oolengo ene doongetelo, Yesus enesu nangge oodoni kenowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ariya, Yesus, enengo sulena onikuya, mela pulinggaku yokolo, ko uwolo. Ulo, Yesusndo mande yanggangolo ewolo. Ye awuno oo kenowonggoku, ngulo oni gulano ma ewelo. Anut Nangoni Oni Kilalongo mele yokoya, ko ootookootoninggago, asa, ye mete yootunoya eyilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ene ngu mandega ngu gome dowoolo, enengo nangge mandelo ingowolo. Ngu mandega mele yokolo ko ootookootoni, ngu ndatelo? Ingowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ngu naluno, Yesuslo sulena onikundo Yesus sumoo inowolo. Anutlo mamana mande etuyeloyingo oni, ngundo ngandilo etenggo. Ilayisando, Anutlo ingondudu eyingo oni, koleteyunolo ombuwalo etenggo. Ndatelo ngulo, ngundilo etenggo? ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ene mande ngundilo sumoo etoyi, Yesusndo gumi ewolo. Hamoo, Ilayisa ombulogo, oo bidodo yomosiyowa. Ngu ndatelo ngulo, Anut mandeno ngu mandega ngu ooloote? Ngu ene Oni Nangoni, ngundo oo bidodo ogingoyingo ulungga koolowootoni, onindo yumooyinolo mandeni biyomi ewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ene no yeno eteno. Ilayisa ene kuli ombuwolo. Ene onindo ngu enengo ingondudu nangge keyolo, damoni biyomi oowooyingga nguya ene teyinoyingo, Anutlo mande nakayano ewoku, ngundilo teyinowololo. Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesus sulena oni kabusagakuya oololo, enengo sulena oni gidalegano tunootewolo. Ene tunootelo, yeyoyingo ngu oni simoo bale oowooyingga oolengo mayelo, gooboongoolo, mamana mande etuyeloyingo oni gidalega, sulena oni nguya, mande gumgumlo longgeyowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Longgeyootoyi, oni simoo bale bidodo Yesus kenootoyi, ombutoni, sodedonangge soliyokolo, kendutelo, Yesusno oololo, yenggonangowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ene ngundilo tetoyi, Yesusndo enengo sulena oniku sumoo yunowolo. Ye ndatelo mandega enedodo elo longgeyootenggo? ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ngundilo sumoo etoni, ene oni gula ngu oni simoo bale ngu kewooloyemonggo, Yesuslo mande gumi ewolo. Oo etuyeloyingo oni ulungga, no nangone, oo yuka biyomi, ngundo newendemo ootoolo, ngunonggo manggowo wetumoololoote. Ngundilo ngulo, no ngu yolo, geno ombuteno. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Nalu oowooyingga ngu, oomboologa, ngundo yanggango biyomi dowoolo ooloote. Ene melako wenggelemootoni solelo ooloote. Koodo namboyi ngu manggowoomo nguya ooletoni, metoyi gome kini ndindi telo, moondeyi sagaga tewa. Ngulo ngu, no gengo sulena onino ngu oweyilo etoowe, ene ngu oomboologa ngu andangeweloyi nguya ereremo kinilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesusndo ngu mandega ngu ingolo, enengo sulena oni, ko, simoo balekuya ewolo. Ye simoo bale nowoondoyemo hamoo kini! No yeya nalu pelungga oolootetoku, ene nalu ndatelo ngu yengo kowuliye koolowoowanggo? Ariya, ye simooye bodaga ngu yoya, nono ombuyilo. Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ene ngundilo etoni, onikundo ngu simoonggaku yolo, Yesusno ombuwolo. Ene ngu oomboologakundo Yesus kenolo, sodedo oolengo ngu simoo kosiyinggaku, newendemonggo yanggango oolengo wenggelemootoni, simoonggaku melako ukelo, wetolo, nguno yowoolalingolo, sagaga telo, koodu namboyi manggowoomonggo oolewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ene ngundilo tetoni ngu, asa, Yesusndo eweyi sumoo inowolo. Nalu ndatelo ngundilo teloluwo? Etoni, eweyimbo gumi ewolo. Kuli ene bodagano damoni yelo oolootelo, ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Nalu oowooyingga, oo yuka biyomi, ngundo simooyengga nga wenggelemootoni, de nombono, sonono nguya ulo, uleni kumooweloyi teloloote. Ge mete tetoningga ngu, ge nowoondoyi yunoya, ge noole hoolooweyelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ene ngundilo etoni, Yesusndo simooyengga ngu eweyimboya ewolo. Ataga, ge noya ngandilo ete. Ge mete tewa tetoni ngu, ge no nangone yomosiyo. Ndatelo ngulo, ge ngundilo ete? Oni nowoondoyemo hamoo Anutno yelo ngu, asa, ene mete oo bidodo teweloyi ingowa. Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Yesusndo ngundilo oo etoni, asa, sodedo oolengo, oni eweyingga ngundo menolo ewolo. No nowoondonemo hamoo tete. Ene nolo nowoondone hamoo ngu ootuwoo! Ngulo ngu, ge no hooloowenelo! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Etoni, Yesusndo yeyolo, ngu oni simoo bale oowooyingga oolengo mayelo, gooboongootoyi, ngulo ngu, ene ngu oomboologa nguya sanggili telo, kenolo ewolo. Ge oomboolo manggowo sodeyi ukingoyingo, no geya eteno. Ge nga simooyengga nga yokoya, kootusina, ge ene newendemo ko ma uwelo! Ngundilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ariya, ene ngundilo etoni ngu, simoo kosiyigaku newendemonggo oomboologaku ki biyomi elo, oninggaku yanggango oolengo wenggelenggeremowolo. Ngundilo telo, oninggaku yokolo, peselo toongewolo. Oomboolo toongetoni, oninggaku gaboyi kumoowolo. Gaboyi kumootoni, oni oowooyingga ngulo ewonggo. Oni kuli kumooteku nga! Elo ewonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ene ngu naluno, Yesusndo kandeyimonggo dowoolo okootoni, ko ootookoolo dikawolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Kootusina, Yesus enengo sulena oniya ya gulano ulo, nguno enesu nangge ootoolo, Yesusno sumoo ewolo. Ndatelo ngulo, noole ngu oomboologa ngu oweweloyi ma ingowootolo? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ene ngundilo sumoo etoyi, Yesusndo gumi ewolo. Anutno yemboongetoyi ngu, ngundilo oo yuka biyomi ngu ye mete andangetoyi toongewa. Oole gulano ngundilo yuka biyomi ngu, ma andangetoyi toongewa. Kini, Anutno yemboongelo andangeweloyi ngu mete. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Ene ngu endega ngu yokolo, oololo, Galili mela kewoolokuli oolouwolo. Ndatelo ngulo, Yesus enengo sulena oni etuyeloweloyi naluno, ngulo ngu, Yesusndo enengo sulena oni nguya kombitelo, Anutlo mande etuyelowelo ewolo. Oni Nangoni, ngu me oni kandeyemo yetoyi, ngundo uleyi kumoowa. Uleyi kumootoni, nalu kabusa yokolo, ene ko ootookoowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ene mande ngundilo etoni, ene sulena oni ngu mandega, ngu damoni ma ingolo, ngulo ene sumoo inoweloyi nguya sosolewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ariya, ene Kaperniyam endemo tunootewolo. Ene ende oololo, ya newendemo ulo, ariya, Yesusndo sulena oni sumoo yunolo ewolo. Ye oolekono ndawu mandegalo ewonggo? Elo sumoo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ene sumoo ngundilo etoni, ene sulena oni mande gumi ma ewonggori. Ndatelo ngulo, sulena oni oolekono oololo, mande ngandilo elo ingowolo. Onendo koleteyingo ulungga oluwa? Ewonggoku ngulo ene oyumo yolo, Yesusno mande gula gumi ma ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesus enengo ingonduduye ngu kuli ingolo, ngulo ene bibitelo, sulena oniku kande elaya kegidembolo elayagaku negoyelootoni, ombutoyi ewolo. Oni gulado koleteyingo oluwelo, ingolo ngu, asa, ene komo ombulo kootu telo, oni bidodo sulena oni telo oluwalo. Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Yesus ngundilo elo, simooye gula bodaga yolo, kewooloyemo yelo, ngunonggo okoolo boogomoolo, enengo sulena oni kilalongo nguno ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Oni ene no oowoonembolo ingondudu telo, ene oni simooye ngandilo bodaga yolo, hooloowewaku ngu, ene no hoolooweneloote. Oni ene no hooloowenelolo ngu, ene no, ko, nolo Awane no sulenelootoni ngano ombuwono, ngu ene nguya hooloowewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yondo Yesusno ewolo. Oo etuyeloyingo oni, noole oni gula kenootooye, ene gengo oowoonggemo melamboolo oweyelootoni, ngu noolengomu kini. Ngundilo ngulo, noole ene loogu teyinowooto. Ndatelo ngulo, ene gengo sulena oni kini. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ene ngundilo etoni, Yesusndo gumi ewolo. Ye ma loogu teyinowelo. Ene oni gula no oowoonemo damoni sungo oolengo gula onindo ma teweloyi, ngu tewaku ngu, ene noya mande biyomi sodedo ma ewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ndatelo ngulo, oni gula nooledodo sanggili kini, ngu noolengo doboonayi ngundo noole hoolooweyelowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","No hamoo oolengo yeno eteno. Kristus oowooyimo, hoolooweyelowo, elo ingolo, sono tobano ye yunowaku ngu, ariya, ngu oningga, ngulo Anutlo uli, ngu hamoo oolengo, ene Anutlo endemo sugi sugi ngundilo ulini yololuwalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yesusndo sulena onino mande gula ewolo. Oni gulado simooye nga nolo nowoondoyemo hamoo ingolo oolootenggoku, nga gula yolo, newendemo hamoo ingooteku, ngu yombuliyowaku ngu, enengombo damoni biyomi tewoku, ngulo gumi ogingoyingo ulungga oolengo yowa. Ariya, ngu oningga, ngu enengombo ngundilo tewoku, ngulo mete ngu digi ulungga yoya, ngundo bungeyimo ukingoya, yoya, sono koongeyingo ulungga ngu kewooloko oolongootoyiga uni. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ge kandegebo weti mbumbuwa gula tetoningga ngu, ge mete toongooya, andangeya, oolongooga uni. Kandege gulanangge, ngundo mete keda oluweloyi gome, ngu yowa. Kinitetoni, ge kandege ela elaya oodoni, ngundo goyolo, ende biyomi de nombono ma kumooweloyi nguno oolongoonggelowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ngu endega nguno, bunimbo suwoo suwoo oni goweyi songgiwi nelo oodoni, oninggaku ogingoyingo ulungga ingolo, sugi sugi oluwa. Enendo de nguya ma wemoowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ngundilo nangge, kengge gulado mbumbuwano goyoya, utoningga ngu, ariya, ngu kengega ngu toongooya yoko. Ngundilo telo, ngu ge mete keda oluweloyi gome ngu yowa. Kengge ela elaya oodoni ngu, ngundo goyolo, ende biyomi de nombo ma kumooweloyimbolo endegano, nguno oolongoonggelowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ngu endega, nguno bunimbo suwoo suwoo oni goweyi songgiwi nelo oodoni, oninggaku ogingoyingo ulungga ingolo, sugi sugi oluwa. Enendo de nguya ma wemoowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ngundilo nangge, ene doongenggebo mbumbuwa gula tetoningga ngu, ge mete ngu doongenggega ngu yowukeya, oolongoongga uni. Ge doongengge gulanangge, ngu ge mete Anutlo mande mande damoni nguno uwa. Ge doongengge ela elaya oodoni ngu, ngundo goyolo, ende biyomi de nombo ma kumooweloyi oolengo (Hel) nguno oolongoonggeloni uwa. Anutlo Mandeno ngandilo ete. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ngu endega nguno, bunimbo suwoo suwoo oni goweyi songgiwi nelo oodoni, oninggaku ogingoyingo ulungga ingolo, sugi sugi oluwa. De nguya ma wemoowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Kumbe gula dowoolo yetoyi, ngu gagiwi kini. Ariya, gagiwi yelo, ariyetoni, de koondodongoombo poosowootoyi, yanggango oolengo yeteku ngundilo. Tewootewoo ombulo, ngundo oni yeni, kumbe poosowootoyi, yanggango yeteku, ngundilo tewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Anutlo mande keda gome, ngu sayi nembo ngundilo. Sayi nembo ngu oo gome. Ene sayi nembo, ngulo yanggangoni kuli kiniteyingo ngu, ye ndatelo tetoyi, ngu sayi nembo ngu ko mete tewa? Sayi nembo ye nowoondoyemo oolooteku ngu, ye komo dobooguliyeboya gome oolengo imakeyingomo bibiteya oliyi. Ngundilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ngu naluno nguno, Yesus ootookoolo, ngu endegaku yokowolo. Endegaku ngu yokolo, ene Yudiya mela Yodan sono anduloko ulelewolo. Uleletoni, ngu naluno, Yesus tanggeyimo oni simoo bale ulungga oolengo gooboongoowonggori. Ngundilo gooboongootoyi, Yesusndo enengo damoni ngu keyolo, Anutlo mande oni simoo bale etuyelolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ngu naluno, Parisi onindo Yesusno ombulo, Yesus dowoolo ulewelo ngulo ene Yesus tewoongolo sumoo ewonggori. Noolengo Moseslo mamana mande ngu oni ene mete baleyi andangewalo mete ete, ngundi kini, binelo? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ngundilo etoyi, asa, Yesusndo enengo mandeye ngu ingolo, ngulo ene Parisi onilo sumoongga ngu gumi ewonggori. Mosesndo ndatelo mamana mandega ye yunoyingolo? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ene ngundilo sumoo etoni, enebana gumi ewolo. Mosesndo ngu oni ene bale andangeweloyi so uyi ngu nakangolo ngu, ene mete baleyi andangelo yokowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ngundilo ngulo, Yesusndo Parisi onilo mande gumi ewolo. Ye mande unggalangoolo yanggayanggango yetoyi, ngulo Mosesndo ngu mamana mandega ngu nakangolo yunowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Koletelo oolengo, Anutndo oo bidodo yemukolo, ene oni simoongga ko balega nguya yoyewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ngundilo ngulo, simoo ene eweyi nemi yokolo, baleyiboya nalu bidodomo, ebe dowoodowoo telo, gooboongoolo oluwali. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ngundilo ngulo, elambalisa ngu ene goweyali gulanangge. Ene ko goweyali elaya kini, ngu goweyali gulanangge ngundilo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ngulo ngu, Anutndo oo gosiyowoku ngu, onindo ngu ma toongoowanggolo. Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Kootusina, ene yano ko ooloutoyi, sulena onikundo nga mande ngalo damonimbolo Yesus sumoo inowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ngundilo etoyi, Yesusndo gumi ewolo. Ene oni gulado enengo baleyi yokolo, bale gula yowaku ngu, asa, enengo baleyi koletelo ngu yombuliyolo, ene mbumbuwa tete. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ngundilo nangge, bale gulado enengo kameyi yokolo, simoo gula yowaku ngu, enengo kameyi koletelo ngu yombuliyolo, ene mbumbuwa tetelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ngu naluno, oni simoo bale enengo simooye bobodi gidalega yoyolo, Yesus tanggeyimo mayewonggori. Ngundilo yoyolo, mayetoyi, enengo sulena onindo simooye yoyolo, ngano ma ombuwelo, elo, manggaluyelolo keyoyelowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesuslo sulena onindo ngundilo tetoyi, yeyolo, ngulo Yesus newende biyomi ingolo, enengo sulena onikuya ewolo. Ye simooye bobodi yoyokootoyiga, nono ombuyi. Ye ngu ma oweyelowelo. Anut Oo Bidodo Sembuli Sembunayi, ngundo endega enengo oni simoo bale soboyelooteku ngu, ngu simooye ngundilo ngundo uwanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","No hamoo oolengo yeno eteno. Oni gula Anut Oo Bidodo Sembuli Sembunayi, ngundo enengo simoo bale soboyelooteku endega, nguno simooye nowoondoyi ngundilo ma telo ngu, asa, ene nguno hamoo oolengo ma uwalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ngundilo elo, Yesusndo simooyeku yodowoolo, boogoyelolo, kandeyi tabayemo yelo, kumana yunowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ngu naluno, Yesus ootookoolo ooloutoni, oni gula kendutelo ombuwolo. Ombulo, Yesus tanggeyimo boodoo oondookelo, sumoo ewolo. Oo etuyeloyingo oni gome, no ndatelo telogo, no suwoo suwoo keda oluweloyi, ngu yowanolo? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ene ngundilo sumoo etoni, Yesusndo gumi ewolo. Ndatelo ngulo ge noya oni gome ete? Anut enengombo nangge oni gome nenengo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ge Anutlo mamana mande kuli ingoote. Ge oni ma uleyi kumoowelo; ge bale gidalega yakakayi yodowoolo yowoosoolo ma yombuliyowelo; bulibali nguya ma endeyowelo; ge yakaka ma tewelo; ge oni gulano mande ebe ganagana ma ewelo; ge ebe ganagana elo, oni gulalo oo sitowini ma woosoolo yowelo; ge awanangge tanggeyemo gome ootooya, ngulo manggoye keyoya ootoolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Yesusndo ngundilo etoni, ngu oningga ngundo Yesusno gumi ewolo. Oo etuyeloyingo oni, no kuli bodagano, ko, ataga nguya, no ngu mamana mande ngu bidodo keyolo, ombulo, oolootenolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ene ngundilo etoni, Yesusndo ene kenondadangelo, oningga ngulo nowoondoyi ulungga oolengo telo, ngulo gome ingolo, ngu oningga nguya ewolo. Ge oo gulanangge ma tewolo. Ge oolouya, gengo oo sitowi bidodo onino uliyoya, ngunonggo beye yoya ngu, asa, beye ngu owoolongo oni ngu bayeteya yuno. Ngundilo telo ngu, asa, gengo oo gome oolengo ngu Sambo endemo ooloote. Ge ngundiya teya ngu, asa, ge ombuya, no keneloya endeyolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ngu oningga ngu mandega ngu ingolo, omukumundoongo biyomi yomoowelo, newende nguya kowuli yewolo. Ndatelo ngulo, enengo sitowini ulungga ngu yokolo, oni yunoweloyi kini. Ngulo ngu, ene ootookoolo toongewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ngundilo tetoni, ene Yesus doongetelo, endeyolo, enengo sulena onino ewolo. Oni sitowidodo ngu, ene Anut Oo Bidodo Sembuli Sembunayi, ngundo endega enengo simoo bale soboyelooteku, ngu newendesina uweloyi nguya, kowuli oolengo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ngundilo etoni, enengo sulena oniku ngu ingolo, ngulo ene soliyokootoyi, Yesusndo mande suleyolo mande gula ewolo. Ye simoone, oni Anut Oo Bidodo Sembuli Sembunayi, ngundo endega enengo simoo bale soboyelooteku, ngu newendesina uweloyi ngulo koyi, ngu kowuli oolengo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Yo, hamoo, bo ulungga nga ngu nggusiyi newendekuli uweloyi ngu kowuli, beye sitowinidodo oni ngu Anut Oo Bidodo Sembuli Sembunayi, ngundo endega enengo simoo bale soboyelooteku nguno uweloyi nguya ngundilo kowuli oolengolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yesus enengo sulena oniku mandeni ngu ingolo, ngulo ene soli ulungga telo, enengo nangge mandelo ingolo ewolo. Hamoo, onendo suwoo suwoo keda oluweloyi, ngu mete yowalo? Ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ngundilo sumoo etoyi, Yesusndo gome gome yeyolo, mande gumi ewolo. Anutndo oni ma hooloowetoni ngu, asa, oni enesu nangge, oo yanggango ngu hamoo ma tewa. Kini, Anutndo oniya ootoolo, ngunonggo ene mete oo yanggango ngu bidodo hamoo oolengo tewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Yesusndo ngundilo etoni, asa, Pitando mande gula Yesusno ewolo. Ingo, noolengo ya, ko, sitowi bidodo kuli yokolo, noole ge kengelolo endeyootetoku nga! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Ngundilo etoni, Yesusndo gumi ewolo. No hamoo oolengo yeno eteno. Oni bidodo sungo sungomo ene nolo ingolo, Anutlo Mande Keda Mesalango nga ingolo, ngu wesiyolo eweloyi ngulo enengo ya, konebaye, kuwookuwooye, awanamoye, enengo oowali koye nguya, yoyokowanggoku ngu, asa, oo bidodo ene kuli yokowonggoku, ngulo gumi ngu dagalo ulungga yowanggo. Yo, hamoo, ngu kedaga, nguno enengo ya, konebaye, kuwookuwooye, awanamoye, oowali koye nguya, ulungga oolengo yowanggo. Ene ye no oowoonemo ko tewanggoku ngu, oni gidalegado nolo ma ingootenggoku, ngundo damoni biyomi ngu ye yunowanggo. Ene kootusina ngu, suwoo suwoo keda oluweloyi, ngu yowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ene oni gulado koleteyingo oluwelo ewaku ngu, ene ombulo, kootu telo, oni bidodo sulena oni telo oluwalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ene Yerusalem oolouwelo Yesusndo oole keyolo, koletelo oolouwolo. Ngundilo ooloutoni, enengo sulena oniku keyolo, oololo, nguno ingondudu ulungga telo soliyokowolo. Ngundilo tetoyi, oni simoo bale oowooyingga ene keyelolo oolouwonggoku, ngundo sosolewonggori. Ngulo ngu, Yesusndo enengo sulena oni kande elaya kegidembolo elayagaku yoyolo, sungo oololo, enengo goweyimo oo tunooteweloyi, ngulo mande yunowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ene ngandilo ewolo. Ingoyi, ataga noole Yerusalem endemo ooletooye, nguno Oni Nangoni, ngu Yudalo goobooyingo yalo tabango oni ululu, ko, mamana mande etuyeloyingo oni nguya kandeyemo yewa. Ngu oni ngundo, mande gulanangge ulewelo mande elo gosiyolo, oni sowe gidalegalo Gabman oni kandeyemo yewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Yetoyi, ngundo ngu yumooyinolo, mukendolo, gisalu utolo, uleyi kumoowa. Ene nalu kabusa yokolo, ene ko keda ootookoowa. Yesusndo ngundilo elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sebedi simoongo elayagaku, Yems, Yon, ngundo Yesusno ombulo, sumoo inolo ewoliyo. Oo etuyeloyingo oni, noole oo gulalo ge sumoo gunowelo. Ge ngu ooga ngu noole yunolo ewoli. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ngundilo etoli, ene mandeyali gumi ewolo. Nondo ndawuga yali yunoowelo? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ngundilo etoni, elayagakundo gumi ewoli. Ge nooleno logo ye. Kootusina, gengo yabage dulidalinidodo nguno bibitetoyi, noole gulado kandege koondosina, gulado kandege biyomisina, nguno bibitewalolo. Ewoliyo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ene ngundilo sumoo etoli, Yesusndo mandeyali gumi ewolo. Yali ngu ooga ngulo nono sumoo eteliku, ngulo damoni ma ingooteli. Yali bine, nondo tobaga sono netenoku, nguno yali nguya sono newali, bine? Ngundilo nangge, yali sono (kundingiyimbo) sonowootenoku, ngu yali nguya, bine, mete ngu sonongga ngu gemuwali? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ngundilo etoni, sulena oni elayaga ngundo mande gumi ewoli. Noole mete, etoli, Yesus enebana ewolo. Hamoo oolengo, ngu tobaga no sono netenoku, ngu yali nguya sono newali. Ngu sono (kundingiyingga) nondo gemutenoku, ngu yali nguya gemuwali. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ene onendo kandene koondosina, kandene dedalesina bibiteweloyi ngu, nondo ma ewano. Ndatelo ngulo, Anut enengombo nangge, ene kuli oni yunowelo ngulo ene yomosiyowolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ene sulena oni kande elayagaku mande ngu ingolo, ene Yems, Yon elayaga nguya, sanggili oolengo tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ngundilo tetoyi, Yesusndo negoyelootoni, eneno ombutoyi ewolo. Oni sowe gidalegalo tabango oni ngu, ene yanggangoyedodo telo, dobooguliye soboyeloweloyi, ngulo mamana mande enengo oni ululu ngundo etoyi, ngundilo yanggango soboyelootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ene ngu damoningga ngu ye kewooloyemo ma oluwa. Hamoo oolengo kini. Ene ye kewooloyemo oni gulado ulungga oluwelo tewaku ngu, asa, ene yengo kingo sulena oni tewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Oni gula ene yengo koleteyingo oluwaku ngu, asa, ene oni ngu bidodo kingo ko oni telo oluwanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ndatelo ngulo, Oni Nangoni, nguya onindo ko teya, hoolooweyilo, ma ombuwolo. Kini, ene ngu onilo ko telo, oni hoolooweyelolo, enengo keda oluweloyi, ngundo simoo bale bidodo mbumbuwanonggo, ko uliyelowelo ombuwolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ngu naluno, ene Yeriko endemo mayelo, ko, Yeriko dagalo, Yesuslo sulena oni, oni simoo bale gidalega nguya, ngundo Yesusndo sawelo tewonggori. Nguno, Timiyaslo nangoni Batimiyas, ngu doongeyi kilingo yeyingo, ngundo oole dabemimo bibitelo oluwolo. Ene suwoo suwoo oni simoo baleno bobeye oolo solengoyelo, sumoo sumoo eloluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ngu oningga ngundo ingootoni, Yesus Nasaret oni ngu namoko ombutoni, ingolo, damoni yelo, ene meno yanggango ewolo. Yesus, ge Dewitlo sembeni, ge nolo nowoondoyi tenunolo! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Oni simoo bale oowooyingga oolengo sanggilitelo, kenolo ewonggori. Ge ali yoko! Etoyi, ene oningga ngu ingolo, ene manggalu ulungga telo ewolo. Dewitlo sembeni, ge nolo nowoondoyi tenunolo! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ariya, Yesus enengo mandeni meno ewoku, ngu ingolo, ngulo ene ombulo, dikalo ewolo. Oningga ngu negongootoyiga ombunilo etoni, oni sungokundo, ngu oni doongeyi kilingonggaku negongolo ewolo. Yesusndo ge negogeloote. Nowoondoge metemi ingoya, sodedo ootookooya ombulo! Ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ariya, oni doongeyi kilingonggaku meno ngu ingolo, ngulo enengo dokikilo nenggulogaku oolongooni, utoni, sodedo ootookoolo, dikalo, Yesus tanggeyimo oolouwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ooloutoni, Yesusndo oni doongeyi kilingonggakuya sumoo ewolo. Nondo ndawuga tenggunowano? Etoni, ngu oni doongeyi kilingongga, ngundo gumi ewolo. Oo etuyeloyingo oni ulungga, no doongetewelo ingootenolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ngundilo etoni, Yesusndo ngu oni doongeyi kilingongga nguya ewolo. Ge mete oolou. Ge nolo nowoondogemo hamoo teyingo, ngundo doongengge yeni, metemi tete. Etoni, ngu naluno nangge, oni doongeyingga, ngu metemi tewolo. Ngundilo tetoni, ene doongetelo, mela kenolo, ene oolekana Yesus keyolo, toongewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesus ko enengo sulena oni nguya Betipas, Betanino ngu, ende bobodi elayaga ngu, Olib puli damonimo, ngu Yerusalem tanggeyimo oluwoliku nguno tunootewolo. Nguno Yesusndo enengo sulena oni kilalongo elaya suleyelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Yali andu endega namoko kenooteliku, anduno sodedo oolouya, Hos gula oowooyi Donki. Ngu nangoni duliyoga gosiyootoyi oolooteku, ngu wesiyoya, yoya ombuli. Oni gulado kuli nguno ma bibitewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ene oni gulado yalino sumoo yunolo ewa. Yali ndawuga tewelo, etoningga ngu, asa, yali ngandiya eli. Oo Bidodo Sembuli, ngundo Donki nga ko inolo, ko sodedo suleyootoni ombuwa, eya elilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ngundilo etoni, ariya, elayaga ngu oololo, Donki duliyoga ngu oole oolouweloyisina nguno endesina yamako dabemimo gosiyoyingo, ngu kenowolo. Ngundilo kenolo, elayaga, ngundo Donki ngu uto wesiyowoli. ");
INSERT INTO rwo_karo_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ngundilo tetoli, oni namoko dikayingo, ngundo elayaga nguno sumoo ewolo. Yali ndawuga tewelo Donki duliyoga ngu uto wesiyootelilo? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ngundilo sumoo etoyi, sulena oni elayaga, ngundo ewoliyo. Yesusndo ngalo ewololo etoli, ngulo ene yokolo sawonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ariya, elayagaku Donki duliyogaku yolo, Yesusno ombuwoliyo. Ngundilo telo, elayagakundo enengo dokikilo nenggulo andangelo, Donki sanganimo yomitoli, Yesus ngu sanganimo bibitewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ngundilo bibitetoni, oni simoo bale oowooyingga oolengo enengo dokikilo nenggulo andangelo, oole sanganiwoole yomilo yomilo oolouwonggori. Ngundilo tetoyi, gidalegado kono oololo, de duwoo toongoolo, ombulo, oole sanganiwoole yomilo oolouwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ngundilo telo, simoo bale koletetoyi, gidalega kootu telo oololo, ene meno mogulu telo ewonggori. Sugi sugi oluwa! Hosana! Anutndo ene mete kumana nga oningga, nga inootoni, ngu Oo Bidodo Sembuliga, ngu oowooyimo ombuteku nga! ");
INSERT INTO rwo_karo_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Noole Yesus bingamilo okoowato! Ene osinayi, Dewitlo naluni ngundilo noole soboyelowelo ombuteku nga! Hosana, awuno oolengo! Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Asa, Yesus Yerusalem endemo ulo, Yudalo goobooyingo ya oowooyi Tempel ngu newendemo uwolo. Yesus oo bidodo kenondadangelo yokolo, suwootetoni, Yesus enengo sulena oni kande elaya kegidembolo elayaga nguya Betani endemo oolouwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Sengetoni, Yesus enengo sulena onikudodo Betani ende yokolo, ombulo, yade ooleko Yesusndo oodoolo kumoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Yesusndo de gula oowooyi Pik, ngu de gudo, kukungo nenggulo ngundiloga, ngu yowoko kenowolo. Uyi oowooyingga tutu uleyingo, ene engge doongetewelo namoko de damonimo oololo doongetelo, engge gula ma kenowolo. Kini, uyi nangge oluwolo. Ndatelo ngulo, de Pik enggeweloyi naluni kini. ");
INSERT INTO rwo_karo_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yesusndo ngu degakuya ewolo. Kootusina, onindo gengo tanggoolige ko ma yolo newanggo. Ngundilo etoni, enengo sulena onindo ngu mandega ngu ingowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yesus enengo sulena oni nguya Yerusalem endemo oolouwonggori. Nguno Yesus oololo, Yuda onilo goobooyingo ya oowooyi Tempel newendemo ulo, yeyootoni, oni Tempel yano bobeye yowoolengoweloyi koyi tetoyi, ngulo ene damoni yelo oweyelowolo. Ngundilo telo, Yesusndo yeyootoni, oni bobeye oowooyingga yowoolalingolo, bayetetoyi, ngu yeyolo, yabakudodo wenggelemootoni, ukelo uwolo. Ngundilo nangge, oni nu kundilimanggowo ngu uliyowelo koyi nguya teyingo ngulo yabaye nguya wenggelemootoni, ukelo, utoni oweyelowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Yesusndo loogu telo mamanayelo ewolo. Ye oo oowooyingga yolo, Tempel ngalo pawa newendekuli ngando ma oololo, ombulo tewelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ariya, Yesusndo oni ngu mamanayelolo mande gula ewolo. Anutlo mande nakangoyingo, ngundo ngandilo ete. Nolo ya ngu oni simoo bale sowe mela bidodomo oolootenggoku, ngundo oowooyi yemboongeweloyi ya, elo ewanggo. Ene yendo ngu yeyi, yakaka onilo kombiteyingo musiyo tetenggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Yudalo goobooyingo yano Anutlo woolo yeyingo oni ngulo sobosobo oni, ko, Anutlo mamana mandelo etuyeloyingo oni, ngundo Yesuslo mandeni ingolo ngu, ariya, ene damoni yelo, Yesus uleyi kumoowelo ngulo ene oole erewewolo. Ndatelo ngulo, oni simoo bale oowooyingga Yesuslo mandeni ingowelo gome ingootenggo. Ngundilo ngulo, Parisi onindo Yesuslo koni ngu kenomayingolo, ngulo ene Yesus dowoolo uleyi kumoowelo, ngulo hahangewonggori. Ndatelo ngulo, oni simoo bale bidodo Yesuslo mandeni nangge ingowelo ingootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Suwootetoni, Yesus enengo sulena oni, ngudodo Yerusalem ende yokolo sawonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Suwoononggo oolengo, Yesus, enengo sulena onidodo, ko oololo, Pik dega ngu kenowonggoku, ngu kuli kumooni yewolo. Yo, hamoo, uyi uli oo ngu bidodo kuli ariyelo, kumooni yewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pitando ngundilo kenolo, Yesusndo Pik dega nguya kuyowo mande ewoku ngu ingolo, Yesusno ewolo. Oo Bidodo Sembuli, keno! Nga Pik dega nga gedo kuyowo kowuli eneno yewoku, ngulo kuli kumoowoku nga! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ngundilo etoni, Yesusndo mande gumi ewolo. Ye komo Anutlo nowoondoyemo hamoo teyi. ");
INSERT INTO rwo_karo_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","No hamoo oolengo yeno eteno. Ye ngandiya ingoyi! Oni gula ene newende elaya kini ngunonggo mela pulingga ngaya ewa. Ge ootookooya, ukeya, wendeyino u, elo ewaku ngu, asa, hamoo oolengo, enendo ewoku, ngundilo tunootewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ariya, no hamoo oolengo yeya eteno. Ye nowoondoyemo hamoo telo, nguno ingoyingo elaya kini, ngunonggo ye oo gulalo yemboongewanggoku ngu, asa, hamoo oolengo, Anutndo ooga ngu yunootoni yowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Yengo yemboongeyingo naluno nguno, oni gulado yeno damoni biyomi gula telo, kowuli yunoyingo tetoni ngu, asa, ye Anutno sodedo yemboongeya, ingondudu biyomingga ngu Anut kandeyimo yetoyi, ngundo hoolooweyelolo, ngu kowulingga ngu andangelo kapengoyeyunowa. Ye ngundilo tewanggoku ngu, asa, yengo Awaye Sambo endemo oolooteku, ngundo yengo mbumbuwaye nguya andangeyunolo kapengoyewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ene ye oni gulado kowuli ye yunowoku, ngu ma andangewanggoku ngu, asa, yengo Awaye Sambo endemo oolooteku, ngundo nguya yengo mbumbuwa ma andangeyunowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesus ko enengo sulena oniya Yerusalem ko oolouwolo. Ngu naluno, Yesus ene Yuda onilo Tempel ya ngu newendewoole endeyootoni ngu, asa, Anutlo woolo yeyingo oni ngulo sobosobo oni ululu, Moseslo mamana mandelo etuyeloyingo oni, ko, endemo tabango oni ngudodo Yesusno mayewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ngundilo mayelo, Yesus sumoo inolo ewonggori. Onendo ngu sunggiga ngu ge gunolo, ngunonggo nga kongga nga telo logogelowo? Sumoo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ene ngundilo sumoo etoyi, Yesusndo mande gumi ewolo. No nguya yeno oo gulalo sumoo yunowelo. Ye nondo sumoongga ngu gumi etoyi ngu, asa, no nguya yengo sumoongga ngu gumi ewano. ");
INSERT INTO rwo_karo_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ariya, onendo Sonoyeloyingo Oni Yon oningga ngu suleyootoni ombuyingo? Anutndo sono kundingiyimbo oni sonoyeloni, elo, Yon suleyootoni ombuwo; ngundi, oni simoo baledo suleyootoyi, sonoyelowo, bine? Ye nolo mandenengga nga gumi eyi. ");
INSERT INTO rwo_karo_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ngundilo sumoo yunootoyi, tabangoku enengo nangge mande elo, ingolo ewonggori. Noole ngandilo ewato. Anutndo Yon suleyootoni, oni simoo bale sono kundingimbo sonoyelowelo ombuyingo, ewatoku ngu, ariya, enebana ewa. Ye ndawugalo, ngu nowoondoyemo hamoo ma ingowonggo? ");
INSERT INTO rwo_karo_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ngundilo nangge, noolendo ngandilo ewato. Onindo Yon suleyootoyi, ngu kongga ngu teyingo ewatoku ngu, asa, oni simoo baledo nooledodo sanggili ulungga tewanggo. Ndatelo ngulo, oni simoo bale ene kuli ingootenggo. Yon ngu Anutlo ingondudu eyingo oni oolengo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ngundilo ngulo, ene Yesuslo mande gumi ngandilo ewonggo. Noole watayi kini, etoyi, Yesus enebana ewolo. No nguya yengo sumoongga, ngu gumi ma ewano. Ndawu oninggado nga sunggiga nga nunootoni, ngunonggo no ko nga tetenoku, ngu ma ewanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ngu naluno nguno, Yesusndo mande yamonggawo gidalega nguya simoo baleno ngandilo ewolo. Oni gula Wayin kongga telo, oonggoo pawangolo, Wayin nguno imiwolo. Ene Wayin engge yolo, wongoolo, winggooweloyi musiyo nguya telo, ene kongga ngu sobowooweloyi ngulo ya pelungga awuno yewolo. Ngundilo yetoni, oni nguno bibitelo, Wayin kono oo ngu bidodo gome kenolo, sobowoolo oluwolo. Oni ko sembuliga, ngundo oni gidalegado ngu kongga nguno digi beye koyi teyi, elo, ene yoyelo, ene mela gula yowoko, nguno toongewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Wayin enggeweloyi nalunimo, ko sembuli, ngundo enengo sulena oni gula suleyootoni, Wayin koyi tetenggoku onikuno oolouwolo. Ko oni ngundo kono oo engge gula yenunoyi, elo, ko oni gula ngu suleyootoni oolouwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ngundilo ko oningga ngu suleyootoni, ooloutoni, Wayinlo kono oni, ngundo oni ko sembuligakulo sulena oninggaku dowoolo, gome gome ulewolo. Ngundilo telo, oo gula ma inowolo. Kini, ene kingo oolengo suleyootoyi oolouwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ngundilo tetoyi, ko sembulibo sulena oni gula ko suleyootoni oolouwolo. Ooloutoni, ngu sulena oninggaku nguya utolo, tabangomo dongo sosowoolo, uleyi biyomi yetoni, mandeni biyomi elo yumooyinowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ko sembulibo sulena oni gula nguya suleyootoni oolouwolo. Ooloutoni, kono onikundo ngu ko oninggaku nguya, uleyi kumoowonggori. Ngundilo tetoyi, ko sembulibo, sulena oni oowooyingga suleyelootoni oolouwolo. Ooloutoyi, gidalega yutolo, oweyelootoyi, satoyi, gidalega yuleyi kumoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ngundilo tetoyi, ko sembuli ngulo oni gula nguya moole. Ngu enengo nangoni gulanangge oolengo. Ngulo gome ingolo, newende nangonimo ooloote. Kootu oolengo ngu, enengo nangoni suleyootoni oolouwelo tetoni ewolo. Nga ngu nenengo nangone, ngulo ene manggowo ingolo, keyowanggolo suleyootoni oolouwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ngundilo ooloutoni, ene kono oni ko tetenggoku, ngundo nangoni kenolo, enengo nangge kewooloyemo mandelo, ingolo ewonggo. Nga oningga ngando ngu eweyimbolo oo bidodo yomukolo, enendo sembuli tewa. Ariya, noole ene nguya utooye kumoowa. Ngundilo telo ngu, asa, nga kongga nga ngu noolengo sobowoolo, koyi tewatolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ngundilo elo, kono oni, ngundo ene nguya dowoolo, uleyi kumoowolo. Kumootoni, bingo okoolo, kanggaloko oolongooyi uwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ariya, oni ko sembuligaku, ndandilo tewa? Ene ombulo ngu, oni kono ko tetenggoku ngu yutolo, yuleni kumoomukowanggo. Ngundilo telo, ene kongga ngu ko oni gidalega yunowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Anutlo mandeno nakangoyingo, ngu ye kuli kandangelo ingowonggo. Yesusndo ngandilo ewolo. Nga ya ungoombolo osiyi yanggango ngu ya yeweloyi onindo andangelo yokowonggo. Ene ataga, ngu ya osiyingga, ngundo ya yanggango dowoolo dikate. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Oo Bidodo Sembuli, enengombo ngu ooga ngu yeni tunootewolo. Noole ngu kenootooye ngu, gome oolengolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yerusalem goobooyingo yano oni tabango ngu bidodo ngu mandega ngu ingootoyi, Yesusndo ngu mande yamonggawongga eteku, ngu enengombolo tewolo. Ngundilo ngulo, ene Yesus dowoolo, ya biyomimo yewelo tewonggo. Ene oni simoo balelo sosolelo, ngulo ene yokolo, ootookoolo sawonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ene Parisi oni Herodlo oni gidalega, ngudodo Yesusno suleyelootoyi, tewoongowelo oolouwonggori. Ndatelo ngulo, ene mande nenengo gula ma etoni ngunonggo yolo, wilikoyingo onino yeweloyi ngulo sumoo inowelo tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ariya, ngu oni ngu ombulo, Yesusno ewonggori. Oo etuyeloyingo oni, noole ingooteto. Ge mande hamoo nangge ete. Gedo ngu oni oowooyedodo, ko, oni oowooye kini nguya mande damoni gulanangge eneno yunoote. Yo, ge oni simoo bale bidodo goobooyelolo Anutlo mande damoni metemi nanggelo etuyeloote. Ariya, ge ngu ndatelo ingoote? Noole Yuda oni nga bobeye (Takis) Sisa inowato, bine; ngundi, Anut nangge inowato, bine? Anutlo mamana mande nguno ooloote, binelo? Ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ngundilo sumoo etoyi, ene Yesus ingoyingo, ene ebe ganagana etenggo. Ngulo Yesus enebana enedodo gumi ewolo. Ndatelo ngulo, ye no tewoonelootenggo? Ye bobeye gula yoya, ombutoyiga, nondo kenoowelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ngundilo etoni, ene bobeye gula yolo, ombutoyi, Yesusndo sumoo yunolo ewolo. Nga oo gaboyiga nga oonelomu? Elo etoni, enebana gumi ewonggo. Ngu Sisa gaboyi. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ngundilo etoyi, ariya, Yesus enebana gumi ewolo. Sisalo oo ngu, ye komo Sisa inoyi. Anutlo oo ngu, ye komo Anut inoyi. Yesusndo ngundilo etoni, oniku ngu mandega, ngulo ingondudu ulungga tewonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ariya, ngu naluno nguno, Yuda oni gidalega oowooyi Sadusi, Yesusno mayewonggori. Sadusi oni, ngundo ene ngandilo etenggo. Oni kumootenggoku ko ma ootookoowanggolo ingootenggo. Ene Yesus sumoo inolo ewonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Oo etuyeloyingo oni, Mosesndo mande gula ngandilo nakangolo yunowolo. Oni gula simoongo kini kumootoni ngu, ngulo konebeyi gula ootoolo ngu, asa, ngundo ngu bale nggamingga ngu mete yowa. Nguno nangoningga tewaku ngu, beyi musiyomo oluwalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ariya, oni simoongolo gula simoo nangge kandegula gidembolo elaya oluwonggo. Koleteloga, ngundo balega yowolo. Asa, ngu simoongo kini oode kootusina kumoowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ngundilo kumootoni, enengo koneyo enebana ngu balegaku yolo, ene nguya simoongo kini oode kumoowa. Ngulo koneyo kabusayigaku enebana ngu balegaku nangge yolo oode, ene nguya simoongo kini oode kumoowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ngundilo nangge, ngu simoongolo kandegula gidembolo elayagaku bale gulanangge yolo, kumooloodoyi kinitewa. Ngulo simooye nguya kini. Kootusina, balegaku nguya kumoowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ariya, kootusina, oni kumooyingoku, ko ootookooweloyi naluno nguno, ngu balegaku, ngu oone baleyi nenengo? Ge ingoote, ngu kandegula gidembolo elayagaku ngu bidodo baleye gulananggelo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ngundilo sumoo etoyi, Yesusndo gumi ewolo. Ye Anutlo mandeno ma ingootenggo. Ye Anutlo yanggangoni nguya ma ingootenggo. Ngulo ngu, ye mande bulibali etenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Oni kumooyingoku ko ootookooyingo naluno, nguno simoo bale kameyi baleyi kini. Kini, ene Anutlo Sambono Engel oni oolootenggoku, ngundilo oluwanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ene nga mandega nga oni kumooyingo ko ootookooweloyi, ngu ye bine Moseslo Buk, ngu ye ma kandangelo ingowonggo. Ngu Anutlo mandega ngu de bodagano solu tunootewolo. Ye ngu kuli kandangelo ingootenggo. Ngu mandegano nguno Anutndo Mosesno ewolo. No Ebarahamlo Anut, Ayisaklo Anut, Yekoblo Anutlo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Moseslo mande ngundo etuyelooteku ngu, ngandilo oni kumootoyi, ngulo gaboyi keda oolootenggoku, ngulo Anut. Yengo mande ngu hamoo oolengo yombuliyolo etenggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Anutlo mande etuyeloyingo oni gula ombuwolo. Ombulo, ingootoni, Sadusi onindo Yesusya mande gumgum elo longgeyootoyi, ene ingootoni, Yesusndo Sadusi onilo mande gumi gome oolengo ewolo. Ngundilo tetoni, enebana Yesus sumoo inolo ewolo. Ndatelo mamana mandega, ngundo mamana mande gidalega dagayelolo koleteyingolo? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ngundilo sumoo etoni, Yesusndo ngu oningga ngulo mande gumi ewolo. Mamana mande gulanangge koleteyingo ngu ngandilo. Ngulo ye Iserel, gome ingoyi! Oo Bidodo Sembuli Sembunayi, ngundo nangge, noolengo Anut gulanangge. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ye komo Oo Bidodo Sembuli ngulo nangge gome ingoyi! Yengo Anut nguno ye komo nowoondoye bidodo, gaboye bidodo, yengo ingonduduye bidodo, yengo yanggangoye bidodo, ye ene inoya, ngu nangge keyoya endeyoyi. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Mamana mande elaya kootu, ngu ngandilo. Gengombolo gome ingooteku, ngundilo ge tanggegemo oni gula nguya, nowoondoyi teyino. Mamana mande gulado nga mamana mande elayaga, nga ma dagayelootelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ngundilo etoni, mamana mande etuyeloyingo oningga, ngundo Yesusno ewolo. Oo etuyeloyingo oni, gedo hamoo ete. Yo, hamoo, Anut gulanangge oolengo. Anut gula nguya kini. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Yo, noole komo ngulo gome ingooteto. Noole komo nowoondonayi bidodo, ingondudunayi bidodo, yanggangonayi nguya bidodo Anut Oo Bidodo Sembuliga inowato. Ngundilo telo, noole komo doboogulinayimbolo nowoondoyi yunoweloyi, ngu noolengo ingootetoku, ngundilo ingowato. Noole nga mamana mande elayaga, nga gome keyowatoku damoningga, ngundo nusago utolo, deko kagisokolo, woolo yeweloyi damoningga, ngu dagate. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ngu oningga ngundo mande gumi etoni, Yesusndo ingootoni ngu, ene oni ingonduduni metemi. Ngulo ngu, Yesusndo oningga nguya ewolo. Ge Anutno nowoondogemo hamoo tetoni, ngunonggo ge oni gidalega nguya nowoondoyi teyunolo, ngunonggo ge Anutlo mande damoni, ngundo simoo bale soboyelooteku, ngu tanggeyimo ombulo ooloote. Yesusndo ngundilo etoni, ngulo oni gidalegado ingolo, sosolelo, ngulo ene oo gulalo Yesusno ko ma sumoo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesus Yuda onilo goobooyingo yano ootoolo, ngunonggo oni simoo baleno mande wesiyolo elo etuyelolo, sumoo yunolo ewolo. Anutlo mamana mande etuyeloyingo oni, ngundo ndatelo ngulo, ene Kristus ngu Dewitlo sembenilo etenggo? ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Yuka Kundingi, ngundo Dewit ingondudunimo yetoni, ngulo Dewit enengombo ewolo. Anut Oo Bidodo Sembuli, ngundo nolo oni ulungga Oo Bidodo Sembuli Sembune nguno ngandilo ewolo. Ge kandene koondosina bibite. Kootusina ngu, gengo me oni yoyewe, gengo kengge damonimo yoyewanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ndatelo ngulo, Dewit enengo sembeni tunooteweloyi ngu nolo Sembunelo etelo? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesusndo ngundilo etoni, simoo ulunggaku, Yesuslo mandeni ingowelo oni oni tewolo. Ngu naluno nguno, Yesusndo oni simoo bale mande yunolo ewolo. Ye Anutlo mamana mande etuyeloyingo oni, ngundo tetenggoku, ngundilo ma tewelo. Ndatelo ngulo, ene towikumba pelu pelungga oni bingamiyedodobo yemutenggoku, ngundilo yemutenggo. Ngundilo yemutoyiga, simoo baledo yeyoya, oni ululu, eya, ingoyilo, ngundilo tetenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ene ngundilo telo, Yuda onilo goobooyingo yano oni simoo bale doongeyemo tunoo bibitewelo gome oolengo ingootenggo. Ene oo simbo kayingo naluno, yaba koleteyingo nguno bibitewelo nguya, gome ingootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ene bale nggami kamesumooye kumooyingo ngu ganaganayelolo, bale nggaminonggo ya oo sitowi kingo woosoolo yootenggo. Ngundilo yomukolo yokolo ngu, asa, enengo bingamiye elo okoolo, ngunonggo ene Anutno kingo yemboongeyingo pelu pelungga tetenggo. Nguno ngu, Anutndo nggami bale ngu hoolooweyeloni, elo ngundilo yemboongetenggo. Ene kootusina, oni ngundilo tetenggoku, ngu Anutndo ngulo gumi kowuli ulungga oolengo yunowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesusndo Yuda onilo goobooyingo yano ulo, bobeye yoweloyi musiyomo oololo, namokoyi bibitewolo. Bibitelo, ene ngunonggo simoo bale yeyootoni, bobeye musiyomo yetoyi yeyowolo. Yeyootoni, oni sitowiyedodo, ngundo ngu bobeye oowooyingga biyomi yetoyi yeyowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ngu naluno nguno, bale nggami gulado ombulo, enengo bobeye bobodi elaya nangge ngu kondibo yewolo, siko gula kini. Ngu bobeye bobodi elayaga, ngu Toya gulanangge ngundilo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ngundilo tetoni ngu, asa, Yesusndo enengo sulena onikuno negoyelootoni, tanggeyimo ombutoyi ewolo. No hamoo oolengo yeno eteno. Nga bale nggami howoolongonggangga, ngando ene bobeye ulungga oolengo yete. Yo, hamoo, oni simoo bale goobooyingo yalo bobeye musiyomo yetenggoku, ngu bidodo dagayeloote. ");
INSERT INTO rwo_karo_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ndatelo ngulo, nga oni nga bidodo bobeye oowooyingga yano ooloote. Ene gidalega nangge yolo, mayelo yetenggo. Ene nga bale nggamingga nga, ngu enengo yano gula kini, siko nguya gula kini. Ene oowali uliyoweloyi nguya gula kini. Enengo bobeye bidodo yeteku ngalo! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesus Yuda onilo Tempel ya yokolo ooloutoni, enengo sulena oni gulado eneno ewolo. Oo etuyeloyingo oni, digi yanggango ululu oolengo ngu digi goobe oo yowali gome gome, ngundo yeyingo, nga kenolo! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesusndo sulena oningga ngulo mande eteku gumi ngandilo ewolo. Ge keno nga ya ululu nga, kootusina, digi gula yokootoyi, gula sanganimo ma oluwa. Kini, onindo nga digi nga usosowoolo, oolongooyi, melako umukowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesus mela puli oowooyi Olib nguno bibitelo, ngunonggo Yuda onilo Tempel, ngu andusina oodoni kenowolo. Ngu naluno nguno, Pita, Yems, Yon, Enduru, ngu oni namolayaga, ngundo nangge Yesus tanggeyimo ombulo, Yesus sumoo inolo ngandilo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Ge nooleno e. Ndawu nalunggano oo ngu tunootewa? Nalu sosowoomo oo bidodo tunooteweloyi, ngu namokono tetoni, nguno noole ndawu sunggiga ngu koletelo tunootetoni, nguno noole kenowato? Ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ene ngundilo sumoo etoyi, Yesusndo mande yunolo, gumi ewolo. Oni gulado ganayeloweloyi ngulo ye ingondale teyi! ");
INSERT INTO rwo_karo_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Oni oowooyingga oolengo no oowoonemonggo tunootelo, ngu ngandilo ewanggo. No nangge Yesus Kristus. Anutndo oni simoo bale yoyoweloyi, elo, no sulenelootelo ewanggo. Ngu oni ngundo ngundilo elo, ene oni simoo bale oowooyingga oolengo ganayelowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Kootusina, ye me ebe ulungga ngguyi ingolo, ko, me ebe ulungga mela sungomo tunooteweloyi, ngulo mande binga nguya ingowanggo. Ngundilo ingolo, ye ngulo ma sosolewelo, ngundilo damoni ngu hamoo koletelo tunootewa. Ene nalu wenga, nguno kini. ");
INSERT INTO rwo_karo_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Yo, hamoo, oni sowe gulado ootookoolo, oni sowe gulaya ebe ulewali. Ngundilo nangge, mela gulalo oo bidodo sobosobo oni, ngundo ootookoolo, mela gulalo oo bidodo sobosobo oniya ebe ulewanggo. Mela guminggano ngu imimi ulungga yootoni, oni simoo bale oodoolo kumooyingo ulungga tunootewa. Ngu oo ngulo ogingoyingoyi ulungga oolengo, ngu baledo simoo yomoowelo ogingoyingo ingootenggoku, ngundilo tunootewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ngundilo oo ngulo, ye ingondale teyi! Nalu wenga ma tunooteyingomo, kowuli ngundilo tunootewa. Ye nolo nowoondoyemo hamoo ingolo oodoyi ngu, ariya, mundi onindo, ye nguya, enengo tabango oni goobooyingomo yoyeyi dikawanggo. Goobooyingo yano nguya ene ye gisaluyelowanggo. Ndatelo ngulo, ene no oowoone, ko, nolo mandene nguya wongooyi uwelo tewanggo. Yo, hamoo, ye oni mela ngalo oo sobosobo ululu ngu doongeyemo yoyeyi dikawanggo. Ngundiya tetoyiga ngu, asa, ye nguno Anutlo Mande Keda Mesalango ngu wesiyoya eneno eyi. ");
INSERT INTO rwo_karo_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ngundiya tetoyi ngu, asa, koletelo Mande Keda Mesalango ngu simoo bale mela bidodomo oolootenggoku, nguno onindo wesiyolo eneno etoyi ingowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ene ye yodowoolo, wilikoyingo oni goobooyingomo yoyetenggoku naluno nguno, ye koletelo ma sosoleyingo, elo ingowelo. Noole ndawu mandega ewatolo, ma ingowelo. Kini, ngu naluno nguno, Anutlo Yuka Kundingiyi, ngundo mande yendo eweloyi ngu yetoni, ngu nangge ye yootunoya eyi. ");
INSERT INTO rwo_karo_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ene bebeyibo, koneyo, ngu wilikoyingo oni, goobooyingomo windoga yunootoni, yuleyi kumoowelo tewanggo. Ngundilo nangge, eweyimbo enengo nangoni windoga teyinootoni, nangosumooye ngundo awanamoyemboya nguya sanggili telo, windoga yunootoyi, yuleyi kumoowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ngundilo telo, oni bidodo yeya, nowoondoye biyomi oolengo yewanggo. Ndatelo ngulo, no oowoone ngu yeno ooloote. Ngulo ngu, ene yeno ngu damoningga ngu yunowanggo. Ene oni nolo mande yanggango dowoolo oodoni, oololo nalu wenga tunootewaku ngu, asa, Anutndo ngu oningga ngu ko yowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yesusndo ngundilo ewolo. Ngu oo biyomi, ngundo Anutlo kundingiyi oolengo musiyomo dikatoningga, ngu ingoyi. Ngu nalunggano nguno, oni simoo bale Yudiya melako oolootenggoku ngu, ene komo sodedo salo, pulimo oolewanggo. (Oni nga mandega nga kandangeya, ngu gome ingondudu teni!) ");
INSERT INTO rwo_karo_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Oni endeloko oolooteku ngu, ene ya newendesina ulo, enengo oo sitowi nguya yowelo ma ingowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ngundilo nangge, oni kono oolooteku ngu, ene ko yowoolengolo, enengo towikumba yowelo, yano ma oolouwa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ngu naluno, bale useyedodo; ngundi, bale simoonamboye nono yunootenggoku, ngu oni oniyooge. ");
INSERT INTO rwo_karo_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ngulo ye komo yemboongeyi. Oo ngu doogo dokiki sono medugu naluno ma tunootewelo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ngu nalungga nguno, kowuli ulungga oolengo tunootewa. Koletelo oolengo, Anutndo oo bidodo yemukoyingo nalu ngu bidodomo, ombulo, nga naluno ngano nguya kowuli ngundilo ngu kuli ma tunootewolo. Kootusina nguya, kowuli ngundilo ngu ko ma tunootewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ene Oo Bidodo Sembuli, ngundo kowuli nalungga ngu woosootoni, ma ootutetoni ngu, asa, oni simoo bale bidodo oonatewanggo. Ene Anutndo oni simoo balelo ingolo, enengo kuli logo yewolo. Ngulo ngu, ene nga nalungga nga woosootoni ootutewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ngu nalungga nguno, oni gulado yeya ewa. Kenoyi! Kristus nga oolooteku nga; ngundi, kenoyi, ene andusina oolooteku andu, etoni ngu, asa, ye ngulo nowoondoyemo hamoolo ma ingowelo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Oni gidalegado ombulo, ganayelolo ewanggo. No Kristus, Anutndo simoo bale yoyowelo logoneloyingo etoni; ebe ganagana eyingo oni gidalega, ngundolo ewanggo. No Anutlo ingondudu eyingo onilo ewanggo. Ene damoni sungo gula onindo ma teweloyi ngu telo, nguno ene Anutlo simoo bale ngu tewooyelolo ganaganayelowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ngulo ngu, ye ingondale teyi! No oo bidodo kuli yeno etoowe, ingootenggoku ngu! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Yesusndo ewolo. Ngu kowuli ulungga ngu kinitetoni ngu, ariya, sa kombo doobeyelootoni, himi ma yewali. ");
INSERT INTO rwo_karo_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Dootu soletoyi, oo yanggango Sambono oolootenggoku, ngu bidodo Anutndo yokutuyelowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ngu nalunggano nguno, Oni Nangoni gobooleno dulidalini yanggangonidodo oolengo ombutoni kenowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ngu nalungga nguno, enengo Anutlo Sambono Engel oni ngu suleyelootoni, Anutlo simoo bale Sambo mela bidodomo oolootenggoku, ngu yoyolo, mayelo goobooyelowanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yesusndo ewolo. Ye Pik dega nguno ingoyi! Kambini sonoyidodo teteku naluno, ngu nungoyelo, tanggooli keda ngu yeteku, ngu kenolo ingootenggo. Sa naluwo gome ataga tunootetelo ingootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ye de ngundilo tetoni, kenolo, ye ingootenggo. Enggeweloyi nalu namoko tunootetelo ingootenggo. Ngundilo nangge, kootusina, ye ngundilo oo ngu kenootoyi, tunootetoni ngu, ariya, ye nguno ingowanggo. Yesus ko ombuweloyi naluni namoko tetoni, ngulo sunggi ngundilo tunootetelo ingowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","No hamoo oolengo yeno eteno. Nga naluno ngano oni simoo bale oolootenggoku, ngu ma kumoomukoyingomo, ngu oo ngu bidodo tunootewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Yo, hamoo, Sambo mela ngu oololo kinitewali. Ene nolo mandene ngu ma kinitewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Yesusndo ewolo. Ene oni gulado ngu nalungga ngu, ko sangga ngu ma ingoote. Anutlo Engel oni Sambono oolootenggoku, ngu nguya ma ingootenggo. Enengo nangoni nguya ma ingoote. Kini, Eweyi Anutndo nangge ngu ingoote. ");
INSERT INTO rwo_karo_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ye ingondale teya, gome sobowooya oliyi! Ndatelo ngulo, ye ma ingootenggo. Nalu ndatelo tunootewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ngu ngandilo: oni gula enengo ya yokolo, mela sungosina endeyowelo. Ngulo enengo ko onindo oo sobowooyi, elo, ene ko bayetelo, sungo sungo yunowa. Ene yamako sobosobo oningga nguya ewa. Ge gome oolengo soboneloya ootoo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ngulo ngu, ye nguya komo gome sobowooyi! Ndatelo ngulo, ye ma ingootenggokulo ngulo, ndawu nalunggano ya sembuli ko ombuwa. Ene suwootetoni ombuwa; ngundi, suwoo kewooloko, bine; ngundi, sengewelo kootoori etoni, bine; ngundi, suwoononggo, bine; ngu ye ma ingootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kinitetoni, ene sodedo ombulo, ye yeyootoni wetololuwanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nondo nga mandega nga, yengo, ko, simoo bale bidodo nguya elo yunooteno. Ngulo ye komo gome sobowooya oliyi! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nalu elaya nguya yokolo, Anutndo sunggi kenolo, dagayeloyingo naluwo (oowooyi Pasowa) ngulo nalu kundingi, Oomanangoyingo Yis Kini, ngulo nalu kundingiyi oo simbo ulungga neweloyi nguya tunootewa. Anutlo woolo yeyingo oni ngulo sobosobo ululu, mamana mandelo etuyeloyingo oni ululu, ngundo tolige Yesus dowoolo ulewelo oole erewewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ene ewolo. Noole nalu kundingiyimo ngu ooga ngu ma tewato. Ndatelo ngulo, oni simoo baledo me ebe yeyi tunootewalo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesus Betani ende oololo, golimambudodo oni oowooyi Sayimon ngulo yano ulo, nguno oo neweloyi yabano bibitewolo. Ngu naluno, bale gula ombuwolo. Ngu balega ngu bo ulumi nggusi gome oolengongga, ngu kumu bo ulumi gula ndindingo gome ngu newendemo nggusingowolo. Ulini ulunggado uliyingo oowooyi Nard. Ene ngu nggusiga ngu udookelo, Yesus tabangomo wendowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ene ngundilo wendootoni ngu, asa, oni gidalega nguno oluwonggoku, ngundo nowoondoye biyomi yelo, enengo nanggelo ingolo ewonggori. Ndatelo ngulo, bo ulumi gomengga nga kingo yombuliyoote? ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nga oni yunootoni, uliyootoyi, ngulo uliyi ulungga (300.00 Kina) yolo, ngundo owoolongo oni yunoweloyi. Elo balegakuya boguwoolo kenolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ngundilo etoyi, ene Yesusndo ewolo. Nguno yokoyi! Ye balega nga ndatelo kenolo elo kowuli ene inootenggo? Ene nolo damoni gome ngu tete. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Owoolongo oni ngu yeya suwoo suwoo oodoyi, naludodomo, ye mete ene hoolooweyelowanggo. Ene no ngu yeya suwoo suwoo ma oluwato. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ene balega, ngando bo ulumi gula no gowenemo wendooteku nga ngu, ene no meleno noyeweloyi ngulo yomosineloote. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nondo hamoo oolengo yeno eteno. Mela mela bidodomo, Mande Keda Mesalango ngu wesiyolo ewanggoku, ngu melasina nguno nga balegado teteku ngalo mandeni elo, ngulo nguya ingondudu telo ingowanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ngu nalunggano nguno, Yesuslo sulena oni kande elaya kegidembolo elayaga ngulomu gula Yudas Iskariyoot, ngundo ene Anutlo woolo yeyingo oni ngulo sobosobo ululu nguno oolouwolo. Ngundilo oololo, ene Yesus yootunolo, kandeyemo yewelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Yudasndo ngundilo etoni, Anutlo woolo yeyingo oni ngulo sobosobo ululu ngu ingolo, ngulo ene oni oni telo, Yudas bobeye inowelo mande gosiyowonggori. Ngundilo ngulo, Yudasndo damoni yelo, oole erewelo, ndawu nalunggano Yesus yootunolo, kandeyemo yewanolo ingowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Kowooyingombolo nalu koleteyingo, Oo Omanongoyingo Yis Kini oowooyi Pasowa, ngu neweloyi naluni tunootewolo. Ngu nalunggano nguno, ene Anutlo sunggi kenolo, dagayeloyingo naluwo Sipsip nangoni utolo, ngulo oowali kawonggori. Ngulo ngu, sulena onikundo Yesusno sumoo ewonggo. Gedo ngu noole ndano saya, oowali oo ngu yomosiyolo, neweloyi ingoote? Elo sumoo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ngundilo sumoo etoyi, ariya, Yesusndo sulena oni elaya suleyelolo ewolo. Yali oolouya, ende uli. Nguno, oni gula sono nggusi koolowooya, oolekana ooloutoningga ngu, yali kenoya, ene keyoya, endemo oolouli. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ene oolouya, ya gula newendemo utoningga ngu, asa, yali ngu ya sembuliga, nguno ngandiya eli. Oo etuyeloyingo oni, ngundo geno sumoo ewolo. Gengo ya gumi ndano, no nguno nenengo sulena onidodo Pasowa oowali ngu newato? ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Yali ngundilo sumoo etoli, enendo ya gumi ulungga awu sanganimo ngu etuyelowa. Ngu ya gumingga ngu, oo neweloyi yaba, bibiteweloyi yaba, ngu bidodo kuli yomosiyeyingo ngu. Yali nguno noolengo oowali yomosiyolilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Yesusndo ngundilo etoni ngu, ariya, sulena oni elayaga ngu endemo oololo, Yesusndo ewoku ngundilo kenowoliyo. Ngundilo telo, ene nguno oowali yomosiyowoliyo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Suwootetoni, Yesus enengo sulena oni kande elaya kegidembolo elayagakudodo ombuwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ngundilo ombulo, ene oo neweloyi yabano bibitelo, oo nelo, Yesusndo ewolo. Nondo hamoo oolengo yeno eteno. Oni gula ye kewooloyemo nganonggo, windoga no yootunonelolo, me oni kandeyemo noyewa. Ngu oningga ngu, noya oo netelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Yesusndo ngundilo etoni ngu, asa, sulena oni nowoondoye kowuli oolengo yewolo. Ngu mandega ngulo, ene damoni yelo, gulanangge nangge, Yesus sumoo inowonggori. Ge noya ete, binelo? Ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ene ngundilo sumoo sumoo etoyi, Yesusndo gumi ewolo. Ye kande elaya kegidembolo elaya ngu kewooloyemo nga gulado. Nga oningga, noya kandenali koondomo goboolo yetelokungga nga. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Yo, hamoo, no Oni Nangoni, Anutlo mandeno kuli eyingo ngundilo ooloute. Ene ngu oningga Oni Nangoni yootunolo etekungga ngu, ngu oniyooge! Ngu oningga ngu oniyooge nemimbo ma yomoowoolo ngu, kowuli eneno ma tunootewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ene oo nelo oodoyi, Yesusndo oomanongoyingo gula yolo, Anutno yemboongelo, oososowoolo, bayetelo yunolo ewolo. Nga yoya neyi. Nga nenengo songgiwinelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Yesusndo ngundilo elo, ene toba gula Wayin sonoyimbo newendemo hangeyingo, ngu yolo, Anutno yemboongelo, sulena oni yunootoni ngu, sono toba gulananggegakuno goboolo newonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ngundilo netoyi, Yesusndo yeyolo ewolo. Nga sono tobaga nga nenengo dalone. Nga ngu yeya, mande kedalo gosiyooteno. Nga dalonengga nga, ngu oni simoo bale bidodomo wendoyunooteno. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","No yeno hamoo oolengo eteno. No nga Wayinngga nga ko ma newano. Kootusina, Anutlo Endega enengo simoo bale soboyelooteku nguno, no Wayin sonoyi ko newanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ngundilo telo yokolo, Anut bingami okoolo, ene yambo gula utolo ngu, asa, ene ootookoolo, Olib pulimo oolewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ngu naluno nguno, Yesusndo sulena onikuya ewolo. Ye bidodo noyokolo sawanggo. Anutlo Mandeno ngu ngandilo nakangowolo. No Sipsip sembuli utoowe, Sipsip sosolelo, sungo sungo sawanggo. Elo nakangowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ene no melenonggo ko keda ootookoolo ngu, no ye koleteyunolo, Galili melako oolouwanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ngundilo etoni, Pitando Yesuslo mande gumi ewolo. Oni gidalebo goyokolo, satoyi, ene nondo ngu ge ma goyokolo toongewanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ngundilo etoni ngu, asa, Yesusndo Pitaya ewolo. Nondo geno hamoo eteno. Ataga nga, suwoonggano ngano, kootoori tambu elaya ma eyingomo, ge no oowoone imangoolo ewa. No ngu oningga ngu watayi kini, elo, tambu kabusa ewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ngundilo etoni, ene Pitando yanggango yelo, gumi ewolo. No hamoo oolengo eteno. No mete geya kumoowaloku ngu, no ge oowoongge ma oongoowanolo ewolo. Ngundilo etoni ngu, asa, sulena oni bidodo mande ngundilo nangge emukowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ariya, ene oololo, musiyo gulano salo tunootewonggori. Ngu musiyongga ngu oowooyi Gesemani. Nguno ngu, Yesusndo enengo sulena onikuno ewolo. Ye ngano bibiteya oodoyiga, no oololo, anduno Anutno yemboongewelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Yesusndo ngundilo elo, sulena oni kabusa, ngu Pita, Yems, Yon, ngu yoyolo, oolouwolo. Ngundilo oololo, nguno Yesus newende kowuli ulungga oolengo ingowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ngundilo ingolo, sulena oni kabusagakuno ewolo. No nowoondone kowuli ulungga oolengo yetoni, no kumooweloyineloote. Ngulo ngu, ye ngano ootooya, ye komo ingondale teya sobonelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Yesus ngundilo elo, ngulo ene bodaga sungo oololo, melako penggootelo welewolo. Ngundilo telo, eweyi Anutno sumoolo yemboongewolo. Awa, Awane, oole moole tetoni ngu, kowulingga ngu ombuya daganeloni. Ge nenengo awane, ge oo bidodo teweloyi ingoote. Ngulo no ngandilo ingooteno. Gedo mete nga kowuli ogingoyingo ulungga nga ngu, gedo andange. Ene ge nolo ingondudune ma keyowelo. Kini, gengo ingonduduge ngu nangge, no ngu keyowanolo yemboongewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Yesusndo ngundilo yemboongelo yokolo ngu, asa, ene ootookoolo, sulena oni kabusaga nguno oololo yeyootoni, wetolootoyi, yeyolo, ngulo ene Pita yokutuwoolo ewolo. Sayimon, ge wetololoote? Ge nalu gulanangge ma doongetelo oluweloyi kini? Sumoo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ngundilo elo, sulena oni kabusagaku yeyolo ewolo. Ye doongeteya, yemboongeya oliyi, Ye ngundilo telo oodoyi ngu, asa, Setando tewooyelootoni, yanggango ma yelo oonatewanggo. Hamoo, yengo nowoondoyemonggo ngu tewelo ingootoni, ene goweyebo ngu suleyeyokiniyelo yanggango ma yetenggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ngundilo elo, Yesus ko oololo, Anutno yemboongewolo. Ngu kilangga ngu koletelo, Anutno ewokungga, ngundilo nangge ko ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ngundilo yemboongelo yokolo ngu, asa, Yesus sulena onino ko ombulo yeyootoni, ko wetolo oluwonggo. Ndatelo ngulo, nowoondoye kowuli ulungga oolengo yetoyi, ngulo ene gome gome kubooyelootoni welewonggori. Yesusndo sumoo yunootoni, ene oyumoyelootoni, ngulo mande gula eneno ma ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ariya, Yesus tambu kabusayi nguno oololo Anutno ewoku ngundilo ko yemboongelo yokolo ngu, asa, ene ootookoolo, sulena oni kabusaga nguno oololo yeyootoni, ko wetolo oluwonggori. Ngundilo telo oodoyi, Yesusndo yeyolo ewolo. Ye komo wetolo kengelo oolootenggo? Ngu mete, ariya, nalu kiniteteku nga! Ye ootookooya kenoyi! Ataga, mbumbuwadodo onindo, no yootunonelolo, me oni kandeyemo noyewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ngulo ngu, ye ootookootoyi oolouwooto. Kenoyi! Windoga oni no yootunonelolo, oni sanggili kandeyemo noyeweloyi oni ombuteku andu! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesus mande etoni, sodedonangge Yudas, Yesuslo sulena oni ngulomu gula, ngundo ombuwolo. Ombutoni, me oni oowooyingga ombulo, ene duge, idi, nasa, mata komuko ebe uleweloyi, oo bidodo yolo ombuwonggori. Anutlo woolo yeyingo oni, ngulo sobosobo oni ululu, mamana mande etuyeloyingo oni, ko, goobooyingo yalo tabango oni, ngundo me oni suleyelootoyi ombuwonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Windoga oni, oowooyi Yudas, kuli sunggi gula yunolo mandelo gosiyowolo. Nondo ngu oni kandeyi dowoolo, yenggonangolo, yenggonangootoowega ngu, asa, ngu oningga ngu Yesus. Ngu dowooya, yoya oolouyilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ariya, Yudas tanggeyemo ombulo ewolo. Oo etuyeloyingo oni, elo, kandeyi dowoolo yenggonangowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ngundilo tetoni, ariya, me oni Yudasdodo mayeyingo, ngundo kandeye oolongoolo, Yesus dowoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ngundilo tetoyi, Yesuslo sulena oni kewooloyemo gulado sanggili telo, enengo duge woosoolo, ngundo woolo yeyingo oni ngulo sulena oningga, ulewelo oolongootoni dagatoni, sodeyi nangge takatoni solewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ngundilo tetoni, Yesusndo yeyolo ewolo. Ye idi, nasa, duge, ngudodo ye yakaka oni yodowoolo yoweloyi ngundilo me ombutenggo? ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nalu oowooyingga, no yeya Yuda onilo goobooyingo yano ootoolo, mande yunololuwono. Ene ye nguno ma nodowoowonggo. Ene Anutlo mande nakangoyingo ngu ataga engge tunootetelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ngu naluno nguno, enengo sulena oni bidodo Yesus yokolo samukowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Simoo kosiyi gula kumba nomboyingga nangge yemulo, Yesus keyolo ooloutoni, me onikundo kenolo, ngulo ene nguya dowoowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Dowootoyi, simoo kosiyigaku, enengo kumba nomboyinggaku kandeyemo yokolo, mbilimbili toongewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Me onindo Yesus yolo, Anutlo woolo yeyingo ngulo sobosobo oni koleteyingo ngulo yano oolouwonggori. Nguno Anutlo woolo yeyingo oni ngulo sobosobo ululu, goobooyingo yalo tabango oni, mamana mande etuyeloyingo oni, bidodo mayelo gooboongoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ngundilo gooboongoolo oodoyi, Pita ngu yowokoyi sungo Yesus keyolo oolouwolo. Ngundilo telo, Pitando olengomonggo penggo penggo Anutlo woolo yeyingo onilo sobosobo koleteyingo, ngundo yasiliko uwolo. Ngu yangga ngulo kumba ootuwoo onindo de katoyi, Pita ngu yokowelo nombono ombulo, de yokowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Anutlo woolo yeyingo oni, ngulo sobosobo ululu, gooboolo oni tabango bidodo, ngundo Yuda oni negoyelootoyi, mayelo, Yesusndo mande biyomi gula eyingo tetoni, ngunonggo Yesus uleyi kumoowelo ngulo sumoo elo, mande erewewolo. Ene mande nenengo gula ma kenowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Oni oowooyingga mande ebe ganagana oowooyingga Yesusno ewonggori. Ene oni ngulo mandeye ngu gulanangge kini. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ngundilo nangge, oni gidale ootookoolo, mande ebe ganagana oowooyingga Yesus goweyimo yelo, Yesus ganangolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Yesus enengombo ngandilo etoni ingowooto. Nondo, Yuda onilo Tempel, nga toongoowano. Kuli onindo kandeyebo nalu oowooyingga koyi telo yewonggori. Ene nondo ngu nalu kabusagomo ko gula yewano. Ene onindo kandeyebo yeweloyi nguya kinilo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ene ngu mandega eyingo nguya, mande gulanangge kini. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Woolo yeyingo oni, ngulo koleteyingo oningga, ngundo tabango oni, kewooloyemonggo ootookoolo, dikalo, Yesus sumoo inolo ewolo. Ge mande nga gumi gula ma ewa? Nga mandega nga mande wilikoyingo oni doongeyemo ge bungomo etenggo. Ge mande gula moole, bine, ngundi kinilo? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ngundilo sumoo etoni, ene Yesusndo mande gumi gula ma elo, nenetelo oluwolo. Ngundilo nenetetoni, woolo yeyingo oni, ngulo koleteyingo oningga, ngundo Yesus ko sumoo inolo ewolo. Ge Kristus, Anutndo simoo bale yoyoweloyi sunggi yeyingo oni? Ge Anut Oo Bidodo Sembuli, noole ngu bingami okootetoku, ngulo Nangoni, binelo? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ngundilo sumoo etoni ngu, asa, Yesusndo gumi ewolo. Nondo nangge. Kootusina, no Oni Nangoni, no Anut yanggangonidodo ngulo kandeyi koondoyisina bingamidodo bibitelo, kootusina, Sambono gobooleno, ombutoowe, neyowanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Woolo yeyingo onilo koleteyingo oningga, ngundo sanggili ulungga telo, enengo nenggulo dowoolo, oomboongeweloyi telo ewolo. Noole oni gidalegano sumoo ma ewato. Kini, enengombo mande eteku, nga nangge. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ene Anut kootuyisina yumooyinolo mande ete. Ngundilo ngulo, ye enengo mande eteku, ngulo ye ndatelo ingootenggo? Ngundilo sumoo etoni, ene bidodo mande gulanangge ewonggori. Yesus mande biyomi eteku, ngulo ene komo kumoonilo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ariya, oni gidalega damoni yelo, mukendolo, towimbo doongeyi doobengolo, nguno utolo ewonggori. Ge ingondudu eyingo oni tetoni ngu, asa, onendo ge gulete? Ngu yootunoya e! Ngundilo elo, kumba ootuwoo onindo yolo, gisalu ulewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita ngu yasiliko nguno bibitelo oodoni, Anutlo woolo yeyingo oni, ngulo sobosobo oni koleteyingo oni, ngulo sulena bale gula ombuwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Balegakundo ombulo, Pita kenootoni, de yokolo oodoni kenowolo. Ngu balega ngundo Pita gome gome kenolo ewolo. Ge nguya Yesus Nasaret endemo oningga nguya oluwolilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ngundilo etoni, Pitando gumi ewolo. Kini, no ngu oningga ngu, no watayi kini. No gedo mandega eteku ngu, no damoni ma ingooteno. Ngundilo elo yokolo, Pita endesina yamako dabemimo ooletoni, ngu naluno, kootoori ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ngundilo tetoni, sulena balegakundo, Pita ko kenolo, oni namoko dikayingoku, nguno ewonggori. Nga oningga nga nguya, Yesuslo keyimo oni gulalo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ngundilo etoni, Pitando gumi ewolo. Hamoo oolengo kini. Etoni, nalu bodaga oode, oni namoko oluwonggoku, ngundo Pitaya ko ewonggori. Hamoo oolengo, ge Yesuslo oni gula. Gengo mande eteku ngu, Yesuslo mandeni ngundilo. Ge nguya Galili onilo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ariya, Pitando sanggili sanganimonggo manggalu telo ewolo. No hamoo ma etoowe ngu, Anutndo nulewa! Ngu oningga, yendo etenggoku ngu, no watayi kini! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ngundilo etoni, ariya, kootoori tambu elayayiga ngu ewolo. Ariya, Pita ingowolo. Kuli Yesusndo enedodo eyingo, kootoori tambu elaya ma eyingomo, ge no oowoone tambu kabusa oongoonelowa. Pita mande ngu ingondudu telo, ngulo ene sendolo biyobiyomi tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Suwoononggo, Anutlo woolo yeyingo oni, ngulo sobosobo oni koleteyingo, mamana mande etuyeloyingo oni, goobooyingo yalo sobosobo oni, Yudalo goobooyingo ya ngulo tabango oni goobooyingomo, oni ngu bidodo mande gulanangge ewelo gooboowolo. Ngu oni ngundo Yesus utombo gosiyolo, yolo, oololo, Yuda mela ngulo sobosobo oni ulungga, ngu Rom Gabman oni, oowooyi Payilat, ngu kandeyimo yewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Payilat ngundo Yesus sumoo inolo ewolo. Ge, Yuda mela, ngalo oni simoo bale ngulo sobosobo oni ulungga? Ngundilo sumoo etoni, Yesusndo mande gumi ngandilo ewolo. Yo, gengombo eteku ngundilolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Anutlo woolo yeyingo oni, ngulo sobosobo oni koleteyingo, ngundo mande mande oowooyingga kingo Yesus goweyi sanggawelo ebe ganagana ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Payilatndo ko Yesus sumoo inowolo. Geno mande oowooyingga etenggoku nga, ge gumi gula ma ewa? Ge ingoote! Mande yanggango oowooyingga, ge yombuligelowelo etenggoku nga! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ene, Yesusndo mande mande, ngu gumi gula ma ewolo. Ngundilo tetoni ngulo, Payilat ngu, ene ingondudu ulungga ingowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Mooma bidodomo, nalu kundingiyi oowooyi Pasowa, nguno ngu, Gabman sobosobo oni ululu, ngulo damoniye ngundilo, ya biyomimo oni gulanangge andangetoyi toongewa. Ngundilo ngulo, oni simoo bale enengombo oni gulalo etoyi ngu, oningga ngu nangge andangetoyi toongewa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ngu naluno nguno, oni gula ya biyomimo oluwolo. Ngu oningga ngu, oowooyi Barabas. Barabas ngu oni mela oo sobosobo onidodo ebe utolo, oni uleyi kumootoni ngu, oni ngudodo, ene ya biyomimo yoyewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ariya, oni simoo bale oowooyingga mayelo, Payilat sumoo inolo ewonggori. Ge suwoo suwoo teteku ngundiya, ataga nguya telo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ene, Payilatndo gumi ewolo. Yuda onilo mela oo sobosobo oni ulungga, nga bine, andangetoowega toongenilo? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Payilat, ngundilo elo ene ingowolo. Anutlo Woolo Yeyingo Onilo sobosobo oni koleteyingo, ngundo Yesusya boguboguwoolo nowoondoye biyomi ulungga yetoni, ngulo ngundilo tewolo. Ndatelo ngulo, oni simoo bale ulungga Yesus bingami okoowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ene Anutlo Woolo Yeyingo Onilo sobosobo oni koleteyingo, ngundo oni simoo bale suleyelo ewonggori. Barabas andangeya, yuno, etoyiga ngu, ene komo Barabas andangeya, yunonilo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Payilatndo oni simoo baleya ewolo. Ye nga oningga nga, Yuda onilo mela oo sobosobo oni ulungga etenggoku nga, ndatelo teyinowano? Elo sumoo yunowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Asa, oni simoo bale bidodobo gumi ngandilo meno manggalu telo ewonggori. De mombimo sanggawetoyiga kumooni! Ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ngundilo etoyi, Payilatndo gumi ewolo. Ndatelo etenggo, enendo ndawu oo biyomingga tewo? Etoni, ene oni simoo bale bidodo meno mogulu ulungga telo ewonggori. De mombimo sanggawetoyiga kumoonilo ewonggori! ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ngundilo etoyi, Payilatndo, oni simoo baledo ewonggoku, ngundilo nangge elo ingolo, ene Barabas andangetoni toongewolo. Ene Yesus yolo, me oni yunootoni, tulimbo gisasalu, uleyi biyomi yewolo. Kootusina, ngu de mombi sanganimo sanggawetoyi kumoowa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Me onindo Yesus yolo, Payilatlo ende pawaloko oolelo, ngunonggo, me oni gidalega bidodo negoyelootoyi, mayelo gooboongoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Me onindo gooboongoolo nenggulo seleyingongga yolo, Yesus teyinowolo. Uto sanggilidodomu yolo, ngundo Yesuslo tomokuyi tewolo. Ngu uto sanggilidodo tomokuyingga ngu yolo, Yesus tabangomo kuduwooyinowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ngundilo telo, Me oni ngundo damoni yelo, Yesus doongeyimo tabadoli telo, nggunuwoolo ewonggori. Ge mayeteku nga, ge Yuda onilo mela oo bidodo sobowooyingo oni koleteyingo ulunggaku nga! Ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ngundilo elo, mata yolo, ngundo Yesus tabangomo oololongoolo utolo, mukendolo, kenolo, elo, Yesus tanggeyemo boodooye oondookelo, oni oowooye bingamiye okootenggoku, ngundilo tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ngundilo telo, me onindo Yesus yumooyinolo yokolo, ariya, Yesusno nenggulo seleyingonggaku andangelo yokolo, Yesus, enengo nengguloni yolo, Yesus teyinowolo. Ngundilo telo, Yesus yolo, de mombimo boolowoowelo, yolo oolouwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ngundilo oololo, ooleko oni gula oowooyi Sayimon ngu endeni oowooyi Sayirin. Ngu oningga ngu, ene degunonggo ende uwelo mayewolo. Sayimon, enengo nangosumoongo elayaga ngu oowooyali Aleksanda, Rupus. Me onindo oolekonggo dowoolo, woosoolo, Yesuslo de mombigaku inootoyi koolowoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ngundilo telo, me onindo Yesus yolo, mela musiyo gulano oolouwonggori. Ngu melangga, ngu oowooyi Golgata. Golgata oowooyingga, ngulo damoni ngandilo: tabaye wembuyi musiyo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Golgatano mayelo, nguno sono kowoododo goobooyingo, ngu Yesus inowelo tewolo. Ngundilo tetoyi, ene Yesusndo ngu sono kowoongga ngu yokolo, ene ma newolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ariya, ene Yesus de mombimo dowoolo sanggawewolo. Ngundilo telo, Yesuslo nengguloni, ngulo ebe dagadaga koondoonge telo, oni onendo dagayelolo ngu, enendo yowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Yesus de mombimo boolowooyingo ngu, suwoononggo sa oolelo, mela yanggango yeteku nalungga nguno, sa gaboyi nalu kandegula gidembolo namolaya (9:00am), nguno sanggawewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Yesus tabango sanganimo de mombi sosowoomo so uyi gula ngandilo nakangowolo. Yuda Onilo Mela Oo Bidodo Sobosobo Oni Ulungga Oolengo. Ngundilo nakangowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Oni biyomi elayaga, Yesus tanggeyi gide gide booloyelowolo. Oni gula kandeyi koondosina, gula kandeya dedalesina booloyelowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ngundilo teyingo ngu, kuli oolengo, Anutlo mandeno nakangoyingo ngulo engge tunootete. Ngu ngandilo: Ene oni biyobiyomimboya oluwonggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Oni simoo bale mayelo, kenolo, yumooyinolo mande elo, tabadoli telo ewonggori. Ehe! Ge nga oningga ngando yambo ya tootoongolo yokolo, nalu kabusagomo ko yewelo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ariya, ataga gengombo de mombi ngu yokoya, melako ombu! Ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ngundilo tetoyi, asa, Anutlo woolo yeyingo onilo sobosobo oni koleteyingo, Anutlo mamana mande etuyeloyingo oni, ngundo nguya Yesus yumooyinolo mande ewolo. Kenoyi! Ene oni gidalega yomosiyeloote. Ene enengombo hooloowewelo ma ingoote. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Nga Iserello mela oo bidodo sobosobo oni koleteyingo ulungga, Kristus, ene de mombi yokolo, ombutoni ngu, asa, noole ngu kenolo, nowoondonayimo hamoo tewa! Ewolo. Oni elayaga, Yesus tanggeyi gide gide de mombimo elayaga nguya, Yesus yumooyinolo mande ewoliyo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Sa kewooloko (12:00am) oolengo, mela bidodo suwoo ooleli ulungga telo, oololo, sa nemimo uyingo (3:00pm). ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ngu naluno, Yesusndo meno yanggango ulunggalo ewolo. Eloyi Eloyi Lama Sabakatani? Nga mandega ngalo, damoni ngandilo: Nolo Anut, Nolo Anut, ge ndatelo noyokowolo? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ngundilo etoni, oni simoo bale gidalega namoko oluwonggoku, ngundo ingolo ewonggori. Ingoyi! Ene Ilayisa negongootelo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ngundilo etoyi, oni gula kendutelo oololo, sono kowoo oowooyi Winiga ngu towi sosowoo, nguno yelo, de sanggano gosiyolo, yeyi, Yesus manggomo nenilo inolo ewonggori. Sobowoolo oode kenowato! Ilayisando ombulo, andangelo, yolo, ombuwa, binelo? Ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesus ki ulungga elo, yuka yokolo kumoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Yesus kumootoni, asa, Yuda onilo goobooyingo ya oowooyi Tempel, nguno towi ulunggaku awu wengamonggo kewoolokuli pitilo, oosowoolo, ombulo, wenga melako goloongewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ariya, me onilo tabango, ngundo Yesus omukumundoongomo dikalo, kenondadangelo oluwoku, ngundo Yesus ngundilo telo, kumootoni ngu, kenolo ewonggori. Hamoo oolengo. Nga oningga nga, ngu Anut Nangoni! ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ngundilo etoni, bale gidalega yowokoyi dikalo, kenondadangelo oluwonggo. Ngu bale ngu kewooloyemo, bale kabusa oowooyi nga, Mariya Magadala; Mariya, Yems, bebeyi oowooyi Yosis nguya, namoyali; ko, Salomi, ngundo oluwonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ngu bale ngu, kuli Yesus Galili melako sulena teyinolo, yade ngunonggo bale gidalega nguya keyolo, Yerusalem endemo enedodo mayewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ngu nalungga ngu oololo suwootetoni, kundingi nalu yangeni, ngulo oo yomosiyoyingo naluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ngu nalungga nguno, Yosep Arimatiya oningga, ngu tabango oni goobooyingo, ngulo oni gula bingamidodo, ene Anutlo Oo Bidodo Sembuli Sembunayi, ngulo naluni enengo oni simoo bale sobowooyeloweloyi, ngu sobowoolo oluwolo. Ene yanggango telo, Payilat tanggeyimo oololo, Yesus bingombolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ngundilo etoni, Payilatndo Yesus kumoowo, bine; ngundi ma kumoowo, binelo, ingondudu ulungga telo, asa, me onilo tabango gula negongolo, sumoo inolo ewolo. Oninggaku, kuli kumoowo, binelo? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ngundilo sumoo etoni, me onilo tabangongga, ngundo Yesus kuli kumoowolo ewolo. Ngundilo etoni, ingolo, asa, bingongga ngu, Yosep yokoyinowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ngundilo yokoyinootoni, asa, Yosepndo oololo, kumba namboyi gula uliyolo, oololo, Yesus bingo andangelo yowolo. Ngundilo telo, kumba nomboyingga, ngundo Yesus bingo doobengolo, mbimboongolo yolo, oololo, digi meleyi gula onindo kuli selo digi kowu ngundilo tewolo. Ngu melengga nguno, Yesus bingo melengoolo, asa, mele manggowo ngu digi gula ulungga wenggelemoolo, ngundo ukingowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mariya Magadala balega, ngu Mariya, Yosis nemi elayaga, ngundo, Yesus melengootoyi kenowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Yudalo Kengeyingo nalu oowooyi Sabat kinitetoni, Mariya Magadala balega; ngu Mariya, Yems oningga ngu nemi; bale gula oowooyi Salomi, ngundo kumu, bo ulumi ndindingo gome ngu uliyowolo. Ngu bo ulumi oo ngu yolo, oololo, ngundo Yesus bingo moondeyi sonowoolo, yomosiyowelo tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Kowooyingo ngulo nalu koleteyingo ngu, Sande suwoononggo sa ooletoni, ene oni meleno oolouwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ngundilo oololo, enengo nangge mandelo, ingolo, ngandilo ewonggori. Onendo noole hoolooweyelolo, digi ulungga mele manggowo ukingoyingo, ngu andangewalo? Ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ngundilo elo, oololo, doongetelo, mele manggowo kenootoyi, digi ulungga mele manggowoomo ukingoyingo nguno kini. Ngu digi ulungga mele manggowoomo ngu kuli andangewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ene oololo, mele newendemo uwonggori. Ulo, doongetetoyi, oni simoo kosiyi gula, ngu mele newendemo nenggulo namboyi pelungga telo, kandeyi koondosina bibitetoni kenowonggori. Ngundilo kenolo, ene soliyokowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ngundilo kenootoyi, simoo kosiyiga meleno ngundo ewolo. Ye ma soliyokowelo. No ingooteno. Ye Yesus Nasaret oningga de mombimo sanggawelo uleyi kumoowokungga, ngu erewelo mayetenggo. Ene kuli ootookoowolo. Ene ngano kini. Nga kenoyi! Yewonggoku musiyo nangge nga. ");
INSERT INTO rwo_karo_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ene, ye oolouya, enengo sulena onino eya, Pitano nguya eyi. Yesus ngu koletelo, Galili melako ooloute, eya eyi. Ye ngu Galili melako ene kenowanggo. Yesusndo kuli yeno eyingo ngundilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ngundilo ingolo, ngu bale ngu mele sodedo yokolo, endesina oolelo sawoliyo. Ene soliyokolo, sosolelo, ene oni gulano mande gula ma ewoli. Ndatelo ngulo, ene sosolelo mboolomboolo tewoliyo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Kowooyingombolo nalu koleteyingo ngu, Sande suwoononggo oolengo, Yesus ootookoowolo. Yesus ngu koletelo, Mariya Magadala balega nguno tunootewolo. Ngu balega nguno, kuli Yesusndo mela yuka biyomi kandegula gidembolo elaya andangewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mariyando Yesus kenolo oololo, oni Yesusya endeyoyingo, ngundo ngu nowoondoye kowuli ingolo, sendolo oodoyi, nguno ewoliyo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Mariyando ngu oni nguno ewolo. Yesus keda ooloote! No kuli kenooteno! Elo etoni, ngu oni, ngundo mandega ngu ingolo, ene nowoondoyemo hamoolo ma ingowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kootusina, sulena oni elayaga, ende yokolo, oole keyolo ooloutoli, nguno Yesus, ene guladilo oolengo telo, sulena oni elayaga ngu doongeyalimo tunootewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ngundilo tunootetoni, ngu oni elayaga ngundo oololo, sulena oni gidalegano ewoliyo. Ene, sulena oni gidalegado, ngu oni elayaga, ngundo Yesus kenowoliku, ngu etoli, mande ngulo nowoondoyemo hamoo etelilo ma ingowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kootusina, sulena oni kande elaya kegidembolo gulanangge, ngu oowali newelo bibitewonggori. Yesus ngu kewooloyemo tunootewolo. Yesusndo yeyolo, mamana yelo ewolo. Ye nowoondoye yanggango yetoni, ye nowoondoyemo hamoo ma teyingolo ewolo. Ndatelo ngulo, ene ootookoowoku, ngu kenolo, ngundo etoyi, ye ngulo nowoondoyemo hamoo ma tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Yesusndo mande yunolo ewolo. Ye oolouya, mela bidodomo mande keda mesalango nga wesiyoya, oni simoo bale bidodo oolengomo eyi. ");
INSERT INTO rwo_karo_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Oni ene newendemo hamoo ingolo, ngunonggo ene sono (kindingiyimbo) sonowoowaku ngu, asa, Anutndo ngu oningga ngu yootoni, ene Anutlo oni telo oluwa. Ene, Anutno newendemo hamoo elo, ma ingowoku ngu, ene Setanlo ende biyomi, de nombo ma kumooweloyi, nguno ulo oluwa. ");
INSERT INTO rwo_karo_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ariya, oni nolo oowoone, ngulo nowoondoyemo hamoo tewaku, ngulo sunggi guladilo guladilo yeni tunootewa. Oni simoo bale goweyemo yuka biyomi oodoyi ngu, asa, no oowoonemo ngu oomboolo biyomi ngu oweyelootoyi sawanggo. Ene mande mebuyi keda oowooyingga nguya ewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ene kandeyebo sile biyomi dowoolo okoolo, ko, ene sono oo biyomi oni nelo kumooweloyi, ngu nelo ngu, ene ma kumoowanggo. Ene ngu ooga, ngundo ma yombuliyelowa. Ene sayi oni tabayemo kandeye okootoyi, sayi oni ngu mete tewanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Oo Bidodo Sembuli Sembunayi, Yesus, ngundo enengo sulena oni mande yunolo yokolo, ene Anutndo yolo, Sambo endemo oolewolo. Yesus ngu Anut kandeyi koondoyisina bibitewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Yesuslo sulena oni ende mela bidodomo salo, mande ngu wesiyolo ewonggori. Anut Oo Bidodo Sembuli, ngundo enedodo ootoolo, ngunonggo ko telo, enengo mandeni ngu yanggango teyinowelo, oo damoni sungo oolengo guladilo guladilo onindo ma teweloyi, ngu telo, oni simoo bale etuyelowonggori. Mande ngu hamoo oolengo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Oni ulungga Tiyopilas, kuli oni oowooyingga kandeye tewoongolo, Kristusndo noole kewoolonayimo ko telo ene tunootewoku, ngu bidodo nakangowolo. Ene oni Yesus enengo doongeyembo kenowonggoku ngulo mande etoyi, oni sungombo ngulo mande ingolo wesiyolo etoyi, ngu ingolo nakangowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","Ngulo ngu, no nguya nga mandega nga gengo nakangooteno. Nalu pelunggano nga mande oo ngalo sumoo oowooyingga telo, damoni bidodo ingolo yowelo, asa, no mande nenengo oolengo kuli tunootewoku, ngu ataga nakangooteno. Ngulo ge komo gome nenengo oolengo ingo. No nga mandega nga nakangolo ge etunggelowonoku, ngu hamoo mande oolengo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ngu naluno, Herodndo Yudiya mela oo ngu bidodo sobosobo oni koleteyingo oodoni, ngu oni gula oowooyi Sekarayiya, ngundo Anutno woolo yeyingo oni telo oluwolo. Anutno woolo yeyingo oni ngu, Abayisa ngu Sekarayiyalo woolo yeyingo oni, watangga ngulo osiye. Ngulo baleyi oowooyi Ilisabet ngu, Eron oningga ngulo soweni. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ngu oni elambalisa elayaga ngu, ene Anut doongeyimo ene oni nenengo oolengo oluwoli. Ngu elambalisa elayaga ngu Anut Oo Sembuli Ulungga, ngulo mamana mande oo ngu bidodo keyolo oluwoliyo. Ene oo biyomi gula ma tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ngu elambalisa elayaga ngu, ene kuli dogoni oolengo. Ilisabet ngu ninggoo teyingo, ngulo elambalisa elayaga ngu ene simoo namboyali kini. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Sekarayiyalo keyimo woolo yeyingo oni ngu, ko tewelo mayewonggori. Sekarayiya ngu ene Anut doongeyimo woolo yeweloyi ko ngu teloluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Onindo Sekarayiyano sunggi yetoyi, ngundo ene Anutno woolo yeweloyi damonimo ene yambo ya ulunggano (Tempel) nguno ulo, Anut Oo Sembuli ulungga, nguno woolo ndindingo gomemu yewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ngu nalungga ngu, Anutno woolo ndindingododo yeweloyi naluwo, oni simoo bale oowooyingga oolengo endesina gooboongoolo, nguno Anutno yemboongelo oluwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sekarayiya ko tewoodoni, asa, ngu naluno, Ulungga Oo Bidodo Sembuliga ngulo Sambono Engel oni gula kenootoni, woolo ndindingo yeweloyi nombo musiyo ngu kandeyi koondosina, dikatoni kenowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sekarayiya Sambono Engel oninggaku kenolo soliyokolo sosoleyingo ulungga oolengo tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ene Sambono Engel oninggakundo sodedo elo ewolo. Sekarayiya, ge ma sosolewelo. Anutndo gengo yemboongengga ngu kuli ingowolo. Gengo balege Ilisabet, ngundo ngu nangongge simoongga yomoowa. Oowooyi ngu ge komo Yonya e! ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Gengo nowoondoge ngu gome mete telo oluwaku, ngunonggo ge oni oni tewa. Baledo simoo yomootoni, asa, oni simoo bale oowooyingga oolengo, ene ngulo nguya oni oni tewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ene ngu Oo Bidodo Sembuli Ulungga ngu doongeyimo, ene oowooyi ulungga oluwa. Ene Wayin sonoyi kowoomu, ko sono yanggangomu nguya ma newa. Ene nemi useyimo oolooteku ngu Yuka Kundingiyi ngundo newendemo ulo hangewa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Enendo Iserel oni simoo bale oowooyingga oolengo mande yunootoni, nowoondoye yowoolengolo, enengo Anut ulungga nguno oololo keyowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Kuli, Anutndo Yuka Kundingiyimbo yanggango ulungga oolengo Ilayiya inootoni, ene Anutlo ko tewoku, ngundilo nangge, Yon nguya Yuka Kundingiyimbolo yanggangonimo, Anutlo ko ngu tewa. Enendo simoo bale ululu hoolooweyelootoni, nowoondoye yowoolengoya, ngunonggo enengo simoo namboye nguya hoolooweyelootoyi, nowoondoye yowoolengolo, awanamoyemboya nowoondoye goboolo gulanangge yewanggo. Oni Anutlo damoni ma keyootenggoku ngulo nowoondoye nguya enengo mandeni ingolo keyowanggo. Ngundilo damoningga ngunonggo oni simoo bale bidodo nowoondoye yomosiyootoni, oo bidodo Sembuli Ulungga ngulo mandeni ingowanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sekarayiyando Sambono Engel onino ewolo. Noole balenemboya kuli dogoni yewoloku, ngulo simoo yomooweloyi naluwo ngu kuli kini tewolo. Ngundilo ngulo, no gengo mandega eteku ngu, ndatelo telo ingootoowe hamoo tewa? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ngundilo etoni, Sambono Engel oni enebana mandeni gumilo ewolo. No Gebiriyel Anut doongeyimo dikalo oolooteno. Anut enengombo no sulenelootoni, no geno mande gome nga wesiyolo ewelo ombuteno. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ariya, ge ingo! Ge nolo mandene nga nowoondogemo hamoo ma tete. Ngulo ngu ngandilo, ataga gengo gagige ngu wetumootoowe, ge mande ma ewa. Kootusina, nga oo nga tunootetoni ngu, nolo mandega nga, ngu hamoo oolengo enengo naluno engge tunootetoni ngu, asa, ge mete ko mande ewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Oni simoo bale Sekarayiya, sobowoolo ingondudu bulibali ingolo ewonggo. Ndatelo ngulo, Sekarayiya nalu pelungga ene ya gumi kundingiyingga, nguno ootoolo endesina ma oolewolo ingootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kootusina, Sekarayiya endesina oolelo, oni simoo baledoya mande eweloyi kini. Ngundilo ngulo, ene ingoyingo, ene ya gumi kundingiyi newendemo ameno oo sungo guladiloga Anutndo etungootoni kenootelo ingowonggori. Sekarayiya, ngu kandeyibo nangge mande tewootewoongolo enedodolo ewolo. Gagingo manggowo ngu wetumootoni, mande eweloyi ereremo kini. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Kootusina, Sekarayiya enengo ko kini tetoni, ngu naluno, ene enengo endemo ko toongewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kootusina, Sekarayiya baleyi oowooyi Ilisabet, useyidodo tewolo. Ngundilo tetoni, Ilisabet, ya newendemo kombo kandegula kombitelo oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Oode ewolo. Oo Bidodo Sembuli Sembunayembo, ataga nolo sumange tenunolo, oni simoo bale doongeyemo oyumonengga ngu andangenunowolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ilisabet, kombo kandegula gidembolo gulanangge useyidodo tewoolo. Ngu naluno, Anutndo Sambono Engel oni oowooyi Gebiriyel suleyootoni, Nasaret, ende ulungga, Galili melako, nguno oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ngu endemo nguno, ene bale buniyo gula, ene simoo gulaya ma weleyingongga, nguno mande yolo oolouwolo. Ngu balega ngu simoo gulano kametenilo sunggi yewolo. Ngu simoongga ngu oowooyi Yosep. Yosep ngu Dewitlo soweni. Ngu balega ngu, oowooyi Mariya. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gebiriyel eneno oololo ewolo. Ge oni oni teya ootoo, Anutndo ge bingamingge awuno okoote. Anutndo kumana ge gunooteku, Oo Sembuli geya oolootelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mariyando ngu mandega ngu ingolo, sosolelo, ingondudu ulungga telo, enengo newendemonggo ewolo. Ndawugalo ngulo, ngu simoongga ngundo ombulo nono ngandilo ete? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Anutlo Sambono Oni Engelndo Mariyano ewolo. Mariya, ge ma sosolewelo. Anutno newende ngu gengo gome ingolo, sumangeni gunoote. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Gome ingo! Ge usenggedodo telo nangongge simoongga yomoowa. Ngu oowooyi ngu, ge komo Yesusya e! ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ngu oningga ngu, oni ulungga oolengo oluwa. Ngu oningga nguya ngandilo ewanggoku, ene Anut bingaminidodo enengo nangonilo ewolo. Anutndo ene yolo, sobosobo oni koleteyingo ulungga yetoni oluwa. Enengo osiyi Dewitndo sobosobo koleteyingongga, ngundo ko tewoku, ene ngundilo nangge ko tewa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ene ngu oo bidodo sobosobo koletelo oni, ngundo ngu, Yekob Iserel ngulo soweni, ngulo sobosobo suwoo suwoo oluwa. Enengo oo bidodo sobowooteku nalu ngu ma kinitewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mariyando ngundilo ingolo sumoo ewolo. No simoo gulaya ma welewolo. Ngulo gengo mandega eteku ngu, ndatelo telo, engge tunootewa? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Sambono Engelndo mande gumilo ewolo. Anutlo Yuka Kundingiyi ngu geno ombuwa. Anutlo yanggangoni awuno oolengo, ngundo ge wilinggelolo kuduwoonggunowa. Ngundilo tetoni, kootusina ngu simoongga ngu ge yomoowa. Onindo enedodo ngandilo ewanggo. Ene oni kundingi, Anut Nangonilo ewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ingo! Momongge, Ilisabet ngu, ene kuli bale dogoni ngu, ene nguya useyimo simoongga ooloote. Kuli ngu, oni sungombo ewonggori. Ene ninggootete ewonggori. Ene ataga useyidodo oodoni, kombo kandegula gidembolo gulanangge kuli yokowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Melako ngano, ko gula Anutndo teweloyi, kowuli ma ooloote. Hamoo oolengo kini. Anutndo ene oo bidodo temukowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mariyando gumi ewolo. Ene ngu ooga ngu nono eteku, ngu mete tewa. No ngu oo bidodo Sembuli, ngulo sulena bale nanggelo ewolo. Ariya, Sambono Oningga, ngundo Mariyando oo teteku ngu ingomukolo, ene toongewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Ngu naluno, Mariya ootookoolo oo bidodo yomosiyolo, sodedonangge yade yade oololo, Yudiya melako ende gula puli sanganimo nguno oolewolo. Ene Sekarayiyando yano oololo ya newendemo ulo, Ilisabetno ewolo. O momo, Ilisabet! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ilisabetndo, Mariyalo, manggowo ingootoni, Ilisabet useyimo simoongonggaku palelo ooletoni, Yuka Kundingiyimbo Ilisabetlo newendemo ulo hangewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ngundilo tetoni, ene ki ulunggalo ewolo. Anutndo ge Kumana gunooteku ngu, gedo bale gidalega ngu dagayeloote. Ge usenggemo nangonggega oolooteku nguya ene kumanadodo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","No ndatelo ngulo, noolengo Oo Bidodo Sembuli Sembunaye, ngulo nemi, no bingamine okoowelo ombute? ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ingo! No mande gula geno ewelo. No sodenembo gengo manggoge ingootoowe, usenemo simoongga oolooteku, ngando palelo oolelo, oni oni tete. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ndawugalo ngulo, Oo Bidodo Sembuli Sembunaye, ngundo mande wesiyolo eteku, ge nowoondoge hamoo teteku ngulo engge tunootewa. Ngulo ngu, Anutndo ge sobogelootoni, ge mete oni oni tewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","47","Mariyando ewolo. Nolo nowoondonemonggo Oo Bidodo Sembuli, ngulo bingami oowooyi hahangelo okooteno. Nenengo gabone ngu Anutlo oni oni tete. Anut ngu nolo hooloowenelowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","No kuli ngu, enengo sulena bale owoolongo oodoowe ngu, Anut enengo sumange nunowolo. Asa, ngundilo ngulo, oni simoo bale kootusina tunootewanggoku, ngundo nguya nolo oowoone bingamine okoowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Anut yanggangonidodo oolengo, ngundo oo ulungga telo, no nunowolo. Enengo oowooyi kundingiyi oolengo olini! ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Enengo sumangeningga ngu, oni enengo ingolo oowooyi okoolo manggowo keyolo oolootenggoku ngu, ko kootusina ngulo oni sowengga tunootewanggoku, ngu bidodomo nguya oluwa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Enengo kandeyi yanggangomo, ngundo ko yanggango oolengo nenengo tete. Oni ene nowoondoyemonggo enengo bingamiyembolo nangge ingolo endeyootenggoku, ngundilo oni ngu, ene oweyelootoni, sungo sungo sawanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ene mela ngalo oo sobosobo oni yanggangoyedodo ngu yowoosootoni, enengo oowooye ameno ombutoyi, oni oowooye kini ngu yowokolo, enengo oowooye bingamiye okootoni, awuno oolewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Anutndo oni oodoolo kumoolo oolootenggoku ngu, ene oo gomemu yunootoni, oni sitowiyedodo telo oolootenggoku ngu, Anutndo ene oweyelootoni, kingo kande sawanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Ene kuli osinaye Ebarahamno mande elo gosiyoyingo, ngulo nowoondoyi telo, enengo simooye kootusina tunootewanggoku, ngulo sumange yunowa. Ngulo ngu, ene noole enengo ko oni Iserel hoolooweyelolo sumange yunowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ngundilo elo, Mariya, ngu Ilisabetya, kombo kabusa oode yokolo, enengo endemo ko toongewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ilisabetndo simoo yomooweloyi naluwo tunootetoni ngu, ene nangoni simoongga yomoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ilisabetlo ende goboolo oni ko enengo sulena oniku nguya Ilisabetlo Anut Oo Bidodo Sembuli Sembunaye Ulungga, ngundo sumange teyinolo simoongga inowoku, ngulo mandeni ingolo, oni oni ulungga oolengo tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nalu kandegula gidembolo kabusa, nguno (nalu 8) mayelo simooyenggaku moondeyi yomosiyolo, sunggi yeweloyimbolo yambo ya ulunggano, (Tempel) mayewonggo. Mayelo, gooboongoolo simooyengga ngulo oowooyi enengo eweyi oowooyi Sekarayiya ewatolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ngundilo etoyi, simooyengga ngu nemimbo ngu mandega ngu gumi ewolo. Kini, noole komo oowooyi Yonlo ewatolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Oni sungokundo nemimboya mande gumi ewonggo. Gengo gumoogumoongge degooge gula oowooyi ngundilo kinilo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ngundilo telo, kande tewootewoo telo eweyi sumoo inolo, eweyimbo nangoni oowooyi ndatelo ewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sekarayiyando oo nakangoweloyi, oo ngulo kandeyibo tewootewoo telo sumoo ewolo. Ene nguno nangoni oowooyi nakangowelo, elo oowooyi Yonlo nakangowolo. Oniku ngundilo kenolo, ngulo ingondudu ulungga tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ngundilo nakangootoni ngu, asa, Sekarayiyalo gagingo tango yetoni, ene mande elo, Anut bingamilo okoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ngundilo tetoni ngu, enengo ende goboolo oniku bidodo sosolewonggori. Ngulo mandeni ende ende toongetoni, ngulo mande mande ulungga elo ingolo, Yudiya mela pupulimo oolootenggoku oni, ngu bidodomo oolouwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Oni bidodo ngu mandega ngu ingolo, ngulo ingondudu ulungga nowoondoyemo ingolo ewonggori. Kootusina, ngu simooyengga ngu ndawuga tewa? Elo ewonggori. Oni simoo bale ene ingoyingoku, Anut oo bidodo Sembuli Sembunaye, ngulo yanggangoni, ngundo ngu simooyengga ngu sobowoote. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Yuka Kundingiyimbo eweyi Sekarayiya, newendemo hangetoni, oo kootusina, tunooteweloyi ngu koletelolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Noolengo oo bidodo Sembuli Sembunaye, Iserel onilo Anutga, ngulo bingami okoowato. Ndawugalo ngulo, ene noole hoolooweyelowelo ombulo, noole enengo oni simoo bale uliyelowoolo ko yoyowelo ombuwa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Anutndo enengo ko oni Dewit, ngulo sowenimonggo oni yanggango gula yeni, dikalo ngu, ngundo noole ko yoyowelo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","71","Ene kulimi enengo ingondudu eyingo oni kundingiyi, ngu manggoyemo mande ngundilo elo gosiyootoni, Anutndo noolengo longge oni yanggango ngu kandeyemonggo noole ko yoyolo; oni nooledodo nowoondoye biyomi yelo boguwootenggoku, ngu kandeyemonggo nguya ko yoyowa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ene noolengo osisambanaye ngu sumange teyunolo hoolooweyelowolo. Ene kulimi sunggi mande kundingiyi elo, ngulo suwoo suwoo ingondudu teloloote. Ene ma kapengoyewa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","75","Ene hamoo mande solumimonggo Ebarahamno sunggi mande ngandilo ewolo. Ene noolengo longge oni kandeyemonggo andangeyelolo yoyootoni, ngulo noole Anutlo koni tewelo ma sosolewato. Noole nalu bidodomo keda ootoolo, nguno ngu, noole gome nenengo oolengo kundingiyi ootoolo; asa, noole enengo koni damoni kundingiyimo, ko damoni gome nenengo nguno noole mete enengo doongeyimo endeyowato. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ngundilo elo, Sekarayiya yowoolengolo nangoni kenolo ewolo. Ge nangone, oni geyolo geya elo Anut awuno oolengo ngulo ingondudu eyingo onilo ewanggo. Ge Oo Bidodo Sembuli Sembunaye, ngu koleteyinolo ngulo oole yomosiyoyinowa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Gedo enengo oni simoo bale ngu, ngulo mande elo etuyelootoyi, ene nguno ingowanggo. Ene enengo mbumbuwaye andangeyunolo ko yoyowa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Noolengo Anutga ngulo sumange ayibiyi ulungga, ngundo noolengo ngandilo tete. Anutndo enengo nangoni suleyootoni ombuteku, ngu noolengo nowoondonaye oo biyomi oolooteku andangeyunowa. Ngu sengelo ooleli toongooteku, ngundilo ene oni nowoondoyemo ooleli biyomi oolooteku, ngu himi yunowa. Ene Sambo ende himingga ngu yeni, nooleno ombulo himi ngu, oni ooleliko oolootenggoku, ko oni kumoowelo telo oolootenggoku nguya himi yunowa. Noolengo kenaye yoonenengootoni, ayibi imakeyingo, oole metemimo nguno oololo ombulo tewatolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Kootusina, ngu simooyenggaku ulu tetoni, enengo goweyi ingonduduni yukani nguya yanggangonidodo ulu tewolo. Ene toongelo, deguno oni kini melako nguno enesu nangge oluwokuno, ngu nalu nguno, ene Iserel oni simoo bale doongeyemo, Anutlo mande etuyelowelo tunootewa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ngu naluno, mela bidodomo sobosobo oni koleteyingo, oowooyi Sisa Ogastas, ngundo mamana mande gula yelo ewolo. Mela bidodomo, oni simoo bale komo bidodo oowooye bukno nakangowelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Sayiriniyas oningga, ngundo Siriya mela ngulo Gabman sobosobo koleteyingo oluwolo. Ngu nalungga nguno, amana oolengo damoni yelo, oowooye bukno nakangowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ngundilo ngulo, oni simoo bale bidodo enengo ende damonimo salo, nguno oowooye bukno yewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ngundilo ngulo, Yosep ngu Dewitlo soweni, ene Galili melako Nasaret ende ngu yokolo, ene Yudiya melako Dewitlo endemo yade yade oolouwoliyo. Ngu endega ngu, oowooyi Betelehem. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yosep ngu enengo bale sunggi yeyingo, ngu oowooyi Mariya nguya oolouwoliyo. Ene oowooyali bukno yeweloyimbolo. Ngu nalungga ngu, Mariya useyidodo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Yosep Mariya elaga ngu endemo nguno oodoli, Mariya simoo yomooweloyi nalu tunootewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ngu naluno, endemo weleweloyi ya ngu kuli onindo ndindi tewonggori. Ngulo ngu, elambalisa bulmakaulo yano oololo oode, nguno Mariya nangoni gogolo simoongga yomoolo, towimbo doobengolo yolo, bulmakaulo oo neyingo koondomo yeni welewoolo. Ndatelo ngulo, weleweloyi ya onindo kuli ndindi tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ngu melasina nguno, sipsip sobosobo oni gidalega ende dabemimo suwoono Sipsip sobowoolo oluwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Oo Bidodo Sembuli Sembunayembolo Sambono Engel oni, ngundo sipsip sobosobo onino ombulo tunootewolo. Ulunggado enengo solu himi dulidalini ulungga yeni ombulo, ngundo sipsip sobosobo oniku pawayelolo himi yewolo. Ngundilo tetoni ngu, sipsip sobosobo oniku sosoleyingo ulungga tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ene Engel gulado mande yunowolo. Ye ma sosolewelo! Ingoyi! No mande gome mesalango ngu yengo yolo ombuteno. Ngundo ngu oni simoo bale bidodo yoyeni, oni oni tewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ngu sa nalunggano nguno, Dewitlo endemo bale gula simoo yomoote. Ngu simoongga ngu noolengo oo bidodo Sembuli Sembunaye. Ene Kristus, Anutndo sunggi yetoni, Noole Ko Yoyowelo Sunggi Yeyingo oni ngu! ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ye ngu simooyengga ngu kenoweloyi, sunggi ngu ngandilo. Kumbabo doobengolo, bulmakau, ngundo oo neweloyi koondomo yetoni, welooteku ngu! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","14","Sambono Onindo ngundilo etoyi, ariya, sodedonangge Sambono Oni oowooyingga oolengo ombulo tunootetoyi, gooboongoolo, Anut bingami okoolo, yambo utolo, ngandilo ewonggori. Anut awuno oolengo, noole gengo oowoongge bingamingge okoolo, noole gengo yemboongetooye, oni simoo bale mete gedo nowoondoge yunolo, gengo imakeyingo damoningga nguya yunowalo yambo ulewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Sambono Oniku ngundilo telo, ene ko Sambono oolewonggori. Ariya, sipsip sobosobo oniku enengo nangge mandelo ingolo ewonggori. Noole sodedonangge Betelehem endemo oolouya, ngu ooga ngu Oo Bidodo Sembuli Sembunaye, ngundo ewoku, ngu oololo kenowatolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ngundilo elo, ene sodedonangge oololo, Mariya Yosep elaga yeyolo, ko simooyenggaku bulmakaulo koondomo wetolo oodoni kenowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ngundilo kenolo ngu, Sambono Onindo ngu simooyengga ngulo mande ewonggoku ngu, wesiyolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Oni simoo bale bidodo, Sipsip sobosobo onindo mande ngu etoyi ingolo, ene mande ngulo ingondudu ulungga oolengo tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ene nemi Mariyando, ngu mande ngu bidodo gome newendemo yelo, gome dowoolo, ene mande ngulo ingondudu teloluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Sipsip sobosobo oniku, enengo kono ko oololo, Anutlo dulidalini Sambono Onindo etoyi, oololo kenowonggoku, ngulo ene Anutlo oni oni telo, oowooyi bingami okoololuwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Kootusina, sa nalu kandegula gidembolo kabusagomo (Nalu 8) simooyengga ngu moondeyi yomosiyoweloyi naluwomo, oowooyi Yesuslolo ewolo. Mariya useyidodo ma teyingomo ngu, oowooyingga ngu Engel oninggado ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Moseslo mamana mandeno eteku, Mariya ngu keyolo oodoni, ngu nalunggaku tunootetoni, ene yambo yano ulo, Anut doongeyimo ko goweyi metemi teweloyim oolouwolo. Ngundilo ngulo, Mariya, Yosep elambalisa, ngundo Yesus yolo, Yerusalem endemo oololo, goobooyingo ya ulunggano (Tempel), nguno Oo Bidodo Sembuli Sembunayemo woolo yewelo oolouwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ngu Oo Bidodo Sembuli ngulo mamana mandeno nakangootoni oolooteku ngundilo. Nemimbo nangoni gogolo yomootoni ngu, nangoningga ngu yolo, Oo Bidodo Sembuli Sembunayingga ngulo kundingiyi oni ewolo. Anutndo ngu nangoni gogologa ngu sunggi yeyingongga, ngu enengo ko tenilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ngulo Anutno woolo yewelo ngu, nu kundilimanggowo ululumu elaya, ngundi, owita duliyo elaya yolo, ngundo Anutno woolo yeweloyimbolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Moseslo mamana mandeno ewoku, ene ngundilo tewoliyo. Ngu naluno, oni gula oowooyi Simiyon ngu Yerusalemno oluwolo. Ene Anut doongeyimo, oni nenengo gome oolengo. Ene Anutno suwoo suwoo yambo mande nangge teloluwolo. Yuka Kundingiyi, ngundo Simiyondodo oluwolo. Ene Iserel oni nowoondoye yeni, imakelo ngulo kowuliye andangeweloyi oningga, ngu sobowoolo oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Yuka Kundingiyi, ngundo Simiyonno kuli ewolo. Ge oode oo Sembuli ngulo Anutndo noole yoyowelo sunggi yeyingo oni, Kristus, kenologo ge kumoowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","28","Ariya, Yuka Kundingiyimbo yokutuwootoni, ene ootookoolo, yambo ya newendemo uwolo. Ulo doongetetoni, Mariya Yosep elambalisa nangoyali Yesus yolo, gobooyingo yano, mamana mandeno ewoku, ngundilo tewelo ombuwoliyo. Simiyonndo Yesus yolo, dowoolo, Anut oowooyi bingami elo okoolo, ngandilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Noolengo Oo Bidodo Sembuli Sembunaye, ataga gengo ko oningga nga yokootooga, sumangenggemo oolouni. Ataga no mete kumoowano. Nolo nowoondone imakeyingo ootoolo, kuli gengombo ewolomu, ngundilo ataga tunootete. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","No doongenembo gedo noole yoyoweloyi oningga sunggi yewoku, ngu ataga kenooteno. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ge nga oningga ngu sunggi yetoyi, ombulo, oni simoo bale bidodo hoolooweyeloweloyimbolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ene ngu solungga ngu, Yesus oni sowe gidalega yunolo, oole etuyelootoni, Anutno nowoondoye yewanggo. Ngundo ngu, Iserel oni simoo bale nguya oowooye ulungga yunowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Yesus eweyi nemi ngu, Simiyonndo mandega eteku, ngulo soliyokolo, ingondudu ulungga tewoliyo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simiyonndo kumana yunolo, simooyengga ngu nemi Mariyano oo eme tunooteweloyi, ngulo ewolo. Ingo, nga simoongga nga ngu, Anutndo sunggi yelo suleyowoku ngu, ye Iserel oni simoo bale enengo yanggangoni ngu etuyelo. Ene ngundilo tetoni, ngulo Iserel oni simoo bale oowooyingga enengo mandeni ngu ingolo, gidalega nowoondoye hamoo tetoyi, gidalegado ene kootu inolo, enedodo sanggili tewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Nga nangonggega ngando ngu oni simoo balelo ingonduduye bidodo nowoondoyemo kombitelo oolootenggoku, ngu yeni, tunoo oolengo etuyelowa. Kootusina, kowuli ulungga eneno tunootewaku, nguno ge nguya nowoondoge kowuli oolengo dugebo gosanggawetoni ogingoyingooteku ngundilo ingowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Anutlo ingondudu eyingo bale gula oowooyi Ana, ngu eweyi Panuwel, ko enengo soweni oowooyi Aser. Ana ngu kuli dogoni oolengo, ene kuli kameyimboya mooma kandegula gidembolo elaya (7) nangge oode, ngu naluno nguno, ngu kameyi kumoowolo. Kameyi kumootoni, enesu nggami oodoni, moomani onibi namolaya ko mooma namolaya nguya (84) nggami oluwolo. Ene (Tempel) goobooyingo ya ulunggano ngu ma yokowolo. Ene suwoo suwoo, Anutno yambo mande telo oluwolo. Ene ngundilo telo nguno, nalu oowooyingga ene oowali loogu telo, ngulo yemboongelo oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ngu naluno, Ana nguya ombulo, Yesus kenolo, Anutno eselo, Anut bingami okoolo, Yesuslo mandeni oni simoo baleno wesiyolo ewolo. Yerusalem endemo oni, ko Iserel oni ngu bidodo ko yoyoweloyi oningga Anutndo yunowelo eyingo ngu sobowoolo oolootenggoku, ngu oningga ngu, Yesusngga nga! ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yosep, Mariya elagado, ene Oo Bidodo Sembuli Ulungga, ngulo mamana mandeno eteku, ngundilo temukolo ngu, asa, ene Tempel ya ngu yokolo, Galili melako enengo ende Nasaretno ko oolouwoliyo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Simooye bodagaku ulu telo, ingonduduni ulungga oolengo telo, yanggangonidodo tewolo. Enengo ingo ingoni, ngu gome oolengo. Anutlo sumangeni, ngundo ene wiliyowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Mooma bidodomo, Yesus eweyi nemi, Yosep Mariya elaga, ene Yerusalem endemo Anutlo sunggi kenolo dagayeloyingo oowooyi Pasowa, nguno oololo oolooteli. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","43","Yesuslo mooma ngu kande elaya kegidembolo elaya, (12) tetoni, ariya, ngu nalu kundingiyingga, nguno Yosep Mariya elaga, ko Yesus nguya yolo, ene Yerusalemno oolouwonggori. Kootusina, Pasowalo nalungga ngu kinitetoni, Yosep Mariya elaga, oni sungoku ngu bidodo enengo endemo endemo ko sawoliyo. Ene Yesus enesu nangge, Yerusalemno oodoni, enengo eweyi nemimbo ngulo ma ingowoliyo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Yosep, Mariya elagado, ngu Yesus ngu oni simoo bale gidalegaya kuli oololo satenggolo ingolo, ene nguya ngu sanggano nguno ooleko doongetelo doongetelo ooloutoli, kinitewolo. Enengo konebobeyi dobooguliyi kewooloyemo doongetewoliyomu nguya kini. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Elayaga ngu Yesus erewetoli, nguya kini. Ngundilo tetoni, ngulo elayaga ngu, ene Yerusalemno Yesus erewelo ko oolouwoliyo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Yosep Mariya elagado, Yesus erewelo endeyolo oodoli, sa kabusa kinitewolo. Kootusina, Tempel ya newendemo oodoni kenowoli. Yesus ene oo nakangolo etuyeloyingo oni kewooloyemo bibitelo, mande etoyi ingolo, ko enebana sumoo ngu oniku nguya yunolo oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ngu ingondudu etuyeloyingo oni, ngundo Yesuslo mandeni ingolo, ko ingonduduni ingoyingongga, ko enengo mandeye gumi yootunolo ewokungga, ngulo ene soliyokowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Eweyi nemi elaga nguya ngundilo kenolo sosolewoliyo. Nemimbo ewolo. Nangone, ge ndatelo ngulo, ge nooledodo ngundilo tete? Noya awanggeboya nowoondonale ngu kowuli oolengo yetoni, noole ge erewenggeloyingo ulungga tetelolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yesusndo enengo mande gumilo ewolo. Yali ndawugalo no erewenelooteli? Nondo awalo ko teweloyi, ngu yali ngundilo ma ingooteli, bine? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ene elagado, Yesusndo mandega enedodo ewoku ngu, damoni ma ingowoliyo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ariya, Yesus ootookoolo, eweyi nemimboya oolouwonggori. Oololo, yade yade Nasaretno tunootewonggori. Yesus ene suwoo suwoo, eweyi nemimbolo manggoyali keyolo, sulena yunowolo. Nemi Mariyando ngu mande ngu bidodo ingondudunimo yelo, gome dowoolo, ingonduduwoolo oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesus ulu tetoni, enengo ingoyingo nguya gome ulungga oolengo tunootewolo. Anut doongeyemo, oni simoo bale doongeyemo nguya, ene oni gome nenengo oolengo oluwoolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Mela bidodomo, tabango koleteyingo oni oowooyi Tayibiriyas Sisa, ngu mooma kande elaya kengga (15) ngu oni simoo balelo sobosobo oluwolo. Pontiyas Payilat ngundo ngu, ene Yudiya onilo sobosobo koleteyingo oluwolo. Ngu naluno, Herodndo ngu Galili mela ngulo sobosobo koleteyingo oluwolo. Beyi, Pilipndo ngu Ituliya ko Tarakonayitis mela ngulo tabango oluwolo. Layiseniyas, ngundo ngu Abilini mela ngulo tabango telo oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ngu naluno, Anas ko Kayiyapas elaga, ngundo ene Anutlo woolo yeyingo oni kundingiyi ngulo sobosobo oni koletelo telo oluwoliyo. Ngu nalunggano nguno nangge, Sekarayiya nangoni Yon, ngu deguno oni kini melako nguno oluwolo. Yon nguno oodoni, Anutndo enengo mandeni soweyootoni, eneno ombutoni ingowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ngundilo tetoni, Yon ene oololo, Yodan sono dabemiwoole endeyolo oololo, oni simoo bale bidodo komo nowoondoye yowoolengolo Anutno yetoyi ngu, asa, Anutndo oni simoo bale ngulo mbumbuwaye andangeyunolo kapengo yewoolo. Ngundilo tetoni ngu, asa, Yondo sonoyelowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nguno ngu Anutlo ingondudu eyingo oni oowooyi Ayisaya, ngundo kuli nakangolo, ngandilo ewolo. Etoni, deguno oni kini melako, oni manggowo gula oni simoo bale gidalegalo meno ewolo. Oo bidodo Sembuli Sembunaye, ngulo oole yoonenengoyino! Enengo oole gome yomosiyoyino! ");
INSERT INTO rwo_karo_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Anutndo oole nggitinggooto, mewuyi ngu bidodo wiliyoyi. Mela pupuli ngu doongootoyiga guwu yeni. Oole wigiwagayingo ngu yoonenengoyi. Oole mela pikipokuli ngu yomosiyoyi. ");
INSERT INTO rwo_karo_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Nguno ngu, oni simoo bale bidodo ngu, Anutndo noole ko yoyowelo ko teteku, ngu kenolo ingowanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Oni simoo bale oowooyingga oolengo Yon kandeyimo sono yowelo ombuwonggori. Ngundilo ombutoyi, yeyootoni, nowoondoye ma yowoolengootoyi, ngulo ngu, Yon sanggili ulungga telo, ene mamanayelolo ewolo. Ye sile dingeyi kosonggini biyomidodo! Onendo yeno etoni, ye mete Anutlo sanggilini kootusina tunooteweloyi, ngu dagalo sawanggo, bine? ");
INSERT INTO rwo_karo_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ye komo nowoondoye yowoolengootoningga ngu, ye komo engge yeyiga tunooteni. Yengo nowoondoyemonggo ngandilo ma ewelo. Ebaraham ngu noolengo awanaye, ngulo Anutndo nooledodo ma sanggili tewalo, ma ingondudu tewelo. Nondo yeno eteno. Anutndo, ene mete nga digiga nga yoyeni, Ebaraham simoongo tunootewanggo. Ye Anutlo ko yokootenggoku ngu, asa Anutndo mete oni gidalega yoyootoni, enengo ko tewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Anutlo sopolo de damonimo kuli yetoni ooloote. De bidodo engge gome ma enggewaku ngu, ene doongoolo, deko oolongootoni dewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Yondo ngundilo etoni, oni simoo bale bidodo enengo mandeni ngundilo ingolo, sumoo ewonggori. Noole ndatelo tewato? Ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yondo manggoye gumi ewolo. Oni gula ene nenggulo elaya moole ngu, oni gula kenootoni, ene nenggulo kinitetoni, asa, ngu gula inowa. Oni oowalinidodo ngu, ene komo nguya ngundilo tewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Gabman Takis bobeye yoweloyi oni gidalega nguya, sono yowelo Yonno mayelo ewonggori. Mande etuyeloyingo oni, noole ndawuga tewato? Ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yondo gumi ewolo. Ye ngu komo mela ngalo oo sobosobo onindo etenggoku, ngundilo nangge, bobeye ngu yoyi. Yengombo, yengo ingonduduno bobeye sanganimo gula ma yowelolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ngu naluno, me oni gidalega nguya Yon sumoo inolo ewonggori. Noole ndatelo tewato? Etoyi, Yondo mande gumi ewolo. Ye komo oni yutolo, ngulo enengo bobeye kingo ma yowelo. Ye oni sungomo ebe ganagana mande elo bobeye sitowiye ma yowelo. Ye komo yengo koye ngulo uliyi ngu nenengo yoya, ngulo oni oni teya oliyilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","16","Oni simoo bale ingonduduyemonggo, ingondandangelo, Yonlo ewonggori. Nga ngu Kristus bine, ngundi kini, bine? Elo ingowonggori. Yondo enengo mandeye ingolo ngulo gumi ewolo. Nondo ngu sonombo nangge ye sonoyelooteno. Ngundilo, oni gula no kenelolo ombuwa. Ngu oningga ngulo yanggangoni, ngundo nolo yanggangone, ngu hamoo oolengo dagate. Nondo enengo keyi goweyiga ngulo utoyi wesiyoweloyi, ngu ereremo kini. No enengo sulena oni nangge. Enendo ngu Yuka Kundingiyimbo, ko debo nguya gooboongoolo, ngundo ye sonoyelowa ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Kootusina, Yesus oningga, ngundo ombulo, oni simoo balelo nowoondoye hamoo teyingo ngu wilikoyelootoni, oni simoo bale bidodo eneno nowoondoye hamoo tetoyi ngu, enendo yoyolo, enedodo Sambo Endemo oluwanggo. Ngulo ngu, oni simoo bale bidodo eneno nowoondoye hamoo ma telo, Yesus ma keyootoyi ngu, asa, Anutndo ngu oni ngu suleyelootoni, Setanlo ende biyomi de ma kumootekuno, nguno uwanggo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yondo mande mande yanggangomonggo elo, ngundo oni simoo bale ingonduduye yokutuwoolo ewolo. Ngu damoninggano ngunonggo, Yondo Mande Keda Mesalango ngu oni simoo baleno wesiyolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Yondo Galili mela ngulo oo bidodo sobosobo oni ulungga oowooyi Herod, ngu kenolo, elo mamanangowolo. Herodndo damoni biyomi oowooyingga telo, ngunonggo koneyo Pilip baleyi Herodiyas woosoolo yowoolo, ngulo nguya mamanangolo kenolo ewolo. Ngundilo telo, ngu damoni biyomingga nguya tetoni, tunoo oolengo tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ngundilo telo, ngu damoni biyomingga, ngunonggo damoni gula soweyolo tewolo. Ngulo Yon dowoolo, ya biyomimo yewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","Yondo oni simoo bale oolootenggoku, ngu bidodo sono newendemo yodowoolo ulo, sonoyelomukolo oodoni ngu, Yesus nguya Yondo dowoolo sonombo sonowoowolo. Ngundilo tetoni, Yesus ngu Anutno yemboongelo oodoni, ngu naluno, Sambo yamako goosootoni, nguwoole Yuka Kundingiyi ombuwolo. Onindo ngu Yuka Kundingiyingga ngu kenoyingo ngu, nu kundilimanggowo ngundilo tewolo. Ngundilo telo, Yuka Kundingiyingga Yesus tabango sanganiwoole ululumelo oololo ombulo, telo uwolo. Anutndo Sambononggo menolo, ngandilo ewolo. Ge nolo nangone oolengo, no gengo gome kumootenoku ngu! Nowoondone ngu bidodo gengo oni oni teteno! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesuslo moomani ngu onibiga kande elaya tetoni, (30) ene nguno enengo koni nenengo damoni yelo tewolo. Oni simoo baledo ngu Yesus kenolo ngu, ingondudu telo, ngu Yosep nangonilo ingowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Hilayi ngu Matat nangoni. Matat ngu Liwayi nangoni. Liwayi ngu Melki nangoni. Melki ngu Yanayi nangoni. Yanayi ngu Yosep nangoni. ");
INSERT INTO rwo_karo_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosep ngu Matatayiyas nangoni. Matatayiyas ngu Emos nangoni. Emos ngu Neyam, nangoni. Neyam ngu Esalayi nangoni. Esalayi ngu Nagayi nangoni. ");
INSERT INTO rwo_karo_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagayi ngu Meyat nangoni. Meyat ngu Matatayiyas nangoni. Matatayiyas ngu Semen nangoni. Semen ngu Yosek nangoni. Yosek ngu Yoda nangoni. ");
INSERT INTO rwo_karo_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda ngu Yowanan nangoni. Yowanan ngu Resa nangoni. Resa ngu Serababel nangoni. Serababel ngu Siyalitiyel nangoni. Siyalitiyel ngu Nerayi nangoni. ");
INSERT INTO rwo_karo_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerayi ngu Melki nangoni. Melki ngu Edayi nangoni. Edayi ngu Kosam nangoni. Kosam ngu Elemedam nangoni. Elemedam ngu Eya nangoni. ");
INSERT INTO rwo_karo_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eya ngu Yosuwa nangoni. Yosuwa ngu Eliyesa nangoni. Eliyesa ngu Yolim nangoni. Yolim ngu Matat nangoni. Matat ngu Liwayi nangoni. ");
INSERT INTO rwo_karo_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Liwayi ngu Simiyon nangoni. Simiyon ngu Yuda nangoni. Yuda ngu Yosep nangoni. Yosep ngu Yonam nangoni. Yonam ngu Elayiyakim nangoni. ");
INSERT INTO rwo_karo_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elayiyakim ngu Meliya nangoni. Meliya ngu Mena nangoni. Mena ngu Matata nangoni. Matata eweyi ngu Netan nangoni. Netan ngu Dewit nangoni. ");
INSERT INTO rwo_karo_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dewit ngu Yesi nangoni. Yesi ngu Obet nangoni. Obet ngu Bowas nangoni. Bowas ngu Salomon nangoni. Salomon ngu Nason nangoni. ");
INSERT INTO rwo_karo_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason ngu Aminadap nangoni. Aminadap ngu Admin nangoni. Admin ngu Anayi nangoni. Anayi ngu Hesalon nangoni. Hesalon ngu Peres nangoni. Peres ngu Yuda nangoni. ");
INSERT INTO rwo_karo_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuda ngu Yekob nangoni. Yekob ngu Ayisak nangoni. Ayisak ngu Ebaraham nangoni. Ebaraham ngu Tera nangoni Tera ngu Nehor nangoni. ");
INSERT INTO rwo_karo_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nehor ngu Serak nangoni. Serak ngu Riyu nangoni. Riyu ngu Pelek nangoni. Pelek ngu Iba nangoni. Iba ngu Sila nangoni. ");
INSERT INTO rwo_karo_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sila ngu Kenan nangoni. Kenan ngu Apaksat nangoni. Apaksat ngu Sem nangoni. Sem ngu Nowa nangoni. Nowa ngu Lemek nangoni. ");
INSERT INTO rwo_karo_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lemek ngu Metusala nangoni. Metusala ngu Inok nangoni. Inok ngu Yeret nangoni. Yeret ngu Mahalalil nangoni. Mahalalil ngu Kenan nangoni. ");
INSERT INTO rwo_karo_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan ngu Inos nangoni. Inos ngu Set nangoni. Set ngu Adam nangoni. Adam ngu Anut nangoni. ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yuka Kundingiyi, ngundo Yesus newendemo hangetoni, Yesus ene ootookoolo Yodan sono yokolo ooloutoni, ngu naluno, Yuka Kundingiyimbo yolo, oni kini kingo mela, degu kewooloko toongewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Yesus ene, oni kini melako oololo, nguno nalu onibi elaya (40) oode, ene oo ma newolo. Ngu nalungga ngu kinitetoni ngu, Yesus oodoolo kumooyingo ulungga oolengo tewolo. Ngu naluno, Setando Yesus tewoongowelo ombuwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Setando Yesusya ewolo. Ge Anut Nangoni tetoningga ngu, ariya, ge nga digiga ngaya etooga, oomanongoyingo oowali tenilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesusndo Setanlo mande gumilo ewolo. Anutlo mande nakangoyingomo ete. Oni ene oowalilo nangge ngu keda ma oolootenggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ngundilo tetoni, Setando sodedonangge Yesus yolo, mela puli ndandayingonggano oolelo, mela ngalo oo gome gome nga keno, elo, bidodo etungowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Setando Yesusya ewolo. Mela bidodomo, nondo yanggango gunootoowe sobowoowa. Oo sitowi gome gomemu oolooteku, ngu nguya gunowano. Nga oo nga ngu bidodo nolomu. No oni gula inowelo elo ngu, no mete ene inowano. ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ge nono penggootelo, yemboongetoyi ngu, asa, oo nga ngu bidodo gengo oolengo yowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesusndo mandeni gumilo ewolo. Anutlo mandeno ete. Ge komo gengo Ulungga Oo Bidodo Sembuli Sembuge, gengo Anut nguno nangge yambo mande teya, ene gulanangge ngulo koni ngu nangge teyinolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Asa, Setando Yesus yolo, Yerusalemno Tempel ya ulunggaku, ngu sanganimo awuno oolewoliyo. Tempel ya ungoomo awuno dikalo, ngunonggo Setando Yesusya ewolo. Ge Anut Nangoni tetoningga ngu, asa, nganonggo paleya soleya u! ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Anutlo mande nguno ngandilo ete. Anutndo enengo Sambono Engel oni, nguno etoni, ngundo ombulo, sobogelolo goyolo, melako goyewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Enengo kandeyebo godowoolo goyolo utoyi, digi oo gulado kengge ma sanggayelo tutuwoowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesusndo Setanlo mande gumilo ewolo. Ge komo gengo ingondudugemonggo oo biyomi gula telo, ngulo Anutndo hooloowenelonilo ma ewelo. Anutlo Mande nakangoyingo oolooteku ngu ngandilo. Gengo oo Bidodo Sembuli Sembuge, ngu gengo Anut. Ngu ma tewoongowelo! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Setando Yesus ngundilo oo ngu bidodomo tewootewoongolo yokolo, nalu gulano ko tewoongowelo ingolo, ene toongewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesus ngu Yuka Kundingiyi ngulo yanggangoni, ngundo yolo, Galili melako ko oolouwolo. Yesuslo mandeni ngu Galili mela ngu bidodo elo endeyootoyi ingowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yesusndo suwoo suwoo Yudalo goobooyingo yano ulo, oni simoo bale mande yunootoni, ngulo oni simoo bale bidodo Yesus bingami, elo okoowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesus Nasaret endemo oolouwolo. Kuli Yesus bodagano, ngu endemo nguno oode ulungga tewolo. Yesus enengo damoni ngu ngandilo. Sabat naluno, ene suwoo suwoo Yudalo goobooyingo yano oluwolo. Ngu naluno, ene dikalo, Anutlo mande kandangelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ngundilo etoni, ene Anutlo ingondudu eyingo oni, Ayisayalo bukno oo naka yolo, Yesus inowolo. Yesusndo bukga ngu yolo wesiyolo, ene mande ngandilo nakangoyingomu ngu erewelo kenowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Ngu ngandilo, Oo Bidodo Sembuli Sembunaye, ngulo Yuka Kundingiyi nono ooloote. Ngundo no sunggi yenunootoni, ngunonggo no owoolongo oni simoo bale Anutlo mande keda mesalango nga wesiyolo yunowano. Ene no sulenelootoni ombuwonoku, ngu mande ngandilo etoowega, ye ya biyomimo oolootenggoku, ngu yokoya sayi. Oni doongeye kilingomu ene doongetelo, mela kenowanggo. Ene no sulenelootoni ombuwonoku ngu, oni hoolooweyelolo, enengo longge onilo kowuliye yunootoyi, andangeweloyimbolo ombuteno. ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","No mande wesiyolo, ngu Oo Bidodo Sembuli Sembunaye ngulo nalu gome ataga oolootelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesusndo mande ngundilo kandangelo yokolo, ene bukgaku ukingolo buk sembuli inolo yokolo, ene bibitewolo. Ene oni simoo bale yambo yano oluwonggoku, ngu bidodo Yesus nangge kenondadangewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ngundilo kenootoyi, Yesusndo mande ngandilo elo ewolo. Anutlo mande nakangoyingo nga ngu, ene ataga engge tunootelo oolooteku nga! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Oni bidodo Yesuslo oni oni telo, enengo bingami okoolo elo, enengo mande nga gome tunoo oolengo ewoku, ngulo soliyokolo, ingondudu telo ewonggori. Ene nga oningga nga Yoseplo nangoni nangge, binelo ewonggori? ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesusndo mande gumi ewolo. Hamoo oolengo, yengo ingonduduyemonggo mande ngandilo nono ewanggo, bine? Sayi mambu yomosiyeloyingo oni, Dokta, ge komo gengo sayingge yomosiyo. Ge Kaperniyam endemo oo tewoku ngu, noole ingowooto. Ngundilo nangge, gengo ende damonimo ngano nguya ngundiya telo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yesusndo mandelo ewolo. Hamoo oolengo yeno eteno. Anutlo ingondudu eyingo oni gula, enengo ende damonimonggo mande ngu gome ma ingowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nga ingonduduyega nga ngu, yengo osi sambaye oo biyomi ingoyingoku, ngundilo ingootenggo. No hamoo oolengo yeno eteno. Ilayiyalo naluno, Iserel bale nggami oowooyingga oluwonggori. Ngu naluno, mooma kabusa ko kombo kandegula gidembolo gulanangge sa nangge oodoni, sono ma ombuwolo. Ngundilo tetoni, oowalilo kumooyingo nalu ulungga mela bidodomo tunootewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ngundilo tetoni, Anutndo Ilayiya suleyootoni, Iserel onilo bale nggami gulano ma oolouwolo. Kini, Anutndo Ilayiya suleyootoni, Sarepat ende Sayidon melako, bale nggami gula nguno oolouwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ngundilo nangge, Anutlo ingondudu eyingo oni, Ilayisalo naluno nguya, Iserel oni goli mambudodo oowooyingga oluwonggori. Ngu kewooloyemo gula ma mete tewolo. Kini, Siriya oni oowooyi, Neyamando nangge mete tewolo. Yesusndo ngundilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Oni simoo bale Yuda onilo goobooyingo ya newendemo oluwonggoku, ngu mandega ngu ingolo, sanggili biyomi tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ngundilo sanggili telo, oni simoo bale ootookoolo, Yesus uleyi kumoowelo tewonggori. Ngu endega ngu, puli sanganimo ngulo, ene ootookoolo, Yesus owelo moguluwoolo yolo ulo, ende wengamo, kembemo wenggelemootoyiga uni, elo, ngundilo tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ngundilo telo utoyi ngu, Yesus ngu kewooloyemonggo kini telo toongewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ngu naluno, Yesus ngu Galili mela nguno ende gula oowooyi Kaperniyam, nguno uwolo. Ngu endemo nguno Sabat naluno, Yesusndo oni simoo baleno Anutlo mande wesiyolo etuyelowelo damoni yewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Yesuslo mandeni ingolo, ngulo soliyokowonggori. Ndatelo ngulo, enengo mandeni ngu yanggango oolengo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","34","Goobooyingo ya nguno, oni gula yuka biyomimbo yoyingomu ombulo, nguno oluwolo. Ngu oningga, ngundo manggalu ulungga telo ewolo. Ehe! Yesus Nasaret oni! Ge ndawuga noole tewelo ombute? Ge bine noole yombuliyelowelo ombute? No ingooteno. Ge Anutlo oni kundingiyi! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ene Yesusndo manggaluwoolo ewolo. Ge manggoge ukingo! Ngu oningga ngu yokoya toonge! Ewolo. Ngundilo etoni ngu, asa, yuka biyominggakundo oninggaku wenggelemootoni, oni sungoku kewooloyemo melako wedoni yuka biyominggaku peselo toongewolo. Ene oninggaku goweyi moondeyi ma utolo yombuliyowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Oni bidodo ngundilo kenolo soliyokolo, enengo nangge mande, elo ingolo ewonggori. Nga ndatelo mandega? Enengo yanggango oolengo etoni, yuka biyomi yanggangododo ngu peselo oni yokolo, toongeteku ngalo ewonggori! ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Yesuslo mandeni ko oo tewoku, ngulo mande ngguyi bingamini, ngu mela ngulo ende ngu bidodomo logowoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Nalu gulano, Yesus ootookoolo, ngu goobooyingo ya ngu yokolo, Sayimon Pitando yano oololo uwolo. Sayimon Pita konggeyi ngu sayi ulungga oolengo telo, moondeyi gookingo ulungga tewolo. Ngundilo tetoni, ngulo Yesusndo yomosiyonilo sumoo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesusndo ngu balegakuno oololo, ngu sayinggakuya etoni, sayinggaku peselo toongewolo. Ariya, ngu balegaku ootookoolo mete telo, oowali kayunowelo sulena tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Sa nemimo uwelo tetoni, oni enengo dobooguliyemo sayi damoni oowooyingga, yoyolo mayewonggori. Yesusndo kandeyi ngu sayi onikuno sungo sungo yetoni, ngu sayi oniku goweye moondeye gome mete temukowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ngundilo telo, mela yuka biyomiku nguya, oni simoo bale oowooyingga yoyokolo peselo satoyi, oni mete tewonggori. Ngu mela yuka biyomi, ngundo meno manggalu telo ewonggori. Ge Anut Nangoni! Elo etoyi, ene Yesusndo ewolo. Ye mande ma ewelo, elo loogu yunowolo. Ndatelo ngulo, ene ingootenggoku, Yesus ngu Kristus. ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Sengetoni suwoononggo Yesus ootookoolo, endesina oolelo, mela eluwooyingomo oni kinimo toongewolo. Ngundilo tetoni ngu, oni simoo bale ootookoolo erewewonggori. Ngundilo pawangootoyiga, ene ma yoyokolo toongenilo ngundilo tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ene Yesusndo ewolo. No komo ende ende nga bidodomo Anut Oo Bidodo Sembuli Sembunaye, ngundo simoo bale enengo sobowooteku, ngu elo wesiyolo etuyelowano. Ndawugalo ngulo, no Anutndo nga kongga ngalo sulenelootoni ombuwonowolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Enengo mandeni emukolo ngu, Yesus ene oololo, Galili mela ngulo ende ngu bidodomo, Yuda onilo goobooyingo ya newendemo ulo, nguno Anutlo mande onino elo etuyelowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Nalu gulano, Yesus ngu Genesaret sono koongeyingo ngu dabemimo dikatoni, oni simoo bale oowooyingga oolengo, Anutlo mande ingoweloyimbolo mayelo, musiyo bidodo ndindi tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yesus ene doongetelo, wanggo bobodi elaya yeyootoni ngu, sono koongeyingo ngu tamako nguno oluwolo. Wanggo sembuguliyi ngu sono koongeyingo tamakono ulo, isolo si sonowoolo oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesus ngu Sayimondo wanggoga ngu sanganimo oolelo, Sayimonya ewolo. Wanggo bodaga woosootooga sono kewooloko oolounilo ewolo. Ngundilo elo, ene wanggono bibitelo, oni simoo bale ngu Anutlo mandelo etuyelowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yesusndo mande elo yokolo ngu, yowoolengolo, Sayimon Pitano ewolo. Wanggo woosootooga, sono kewooloko ooloutoningga, ye isolo si oolongooya, iso yoyilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Sayimon Pitando Yesuslo mandega ngu gumi ewolo. Oni ulungga, noole suwoono nalu ulungga ngu si oolongoowootoku iso gula ma yowolo. Ene gedo etoyi ngulo, asa, tewoongolo ko oolongoowanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ene ngundilo tetoyi ngu, iso ulungga oolengo si newendemo uwonggori. Ene isombo si oomboongewelo tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ngundilo tetoni, ene dobooguliye wanggo gula sanganimo oluwonggoku, ngu negoyelootoyi, ombulo ngudodo iso sigaku woosoolo yolo, wanggo ela elaya hangelo ooletoli, sono newendemo uwelo tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Sayimon Pitando ngundilo kenolo ingowolo. Yesus komo ngu oni kundingiyi. Ngulo, ene Yesus keyi damonimo penggootelo ewolo. Oni ulungga Oo Bidodo Sembuli Sembunaye, ge no noyokoya toonge. No mbumbuwa oni biyomilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","10","Pita iso oowooyingga oolengo yolo, ngu kenolo soliyokowolo. Oni gidalega nguya, ngundilo nangge, soliyokowonggori. Sebedi simoongo elayagaku ngu oowooyali Yems, Yon, elabasa nguya ngu Sayimon ko goboolo oniku nguya soliyokowoliyo. Soliyokootoyi; asa, Yesusndo Sayimonya ewolo. Ge ma sosolewelo! Kootusina, ge oni simoo bale Anutlo mande keda mesalango nguno ngundilo yoyowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ngundilo telo, Pita galo enengo wanggo woosoolo, sakiko yelo, enengo oo bidodo yokolo, ene Yesus keyolo endeyowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Nalu gulano, Yesus ende gulano uwolo. Ngu endemo nguno, oni gula golimambudo goweyi kondibo yombuliyootoni oluwolo. Ngundo Yesus tanggeyimo penggootelo wetolo, solengoyelo, sumoo ewolo. Oni ulungga Oo Bidodo Sembuli Sembunaye, ge ma yokowelo, ge no yomosinelootoyi ngu, asa, no gowene mete tewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesusndo kandeyi sayi oninggakuno yelo ewolo. Nondo ge gowege mete tenilo, elo ingooteno. Asa, ge mete te! Ngundilo etoni, ariya, sodedonangge ngu golimambuku tootelo kinitewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesusndo ngu oningga nguya mande yanggangolo ewolo. Ge oni gulano ma ewelo. Ene ge oolouya, gowege Anutno woolo yeyingo oni kundingiyi ngu etuyelo. Ge gowege mete teteku ngulo Moseslo mamana mandeno eteku ngundilo, gowege ngulo Anutno woolo yetoyi, oni simoo bale nguno ingowanggo. Ge gowege mete tewololo ingowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Yesusndo ko mande oo tewoku, ngulo ende bidodomo elo toongewolo. Ngundilo tetoyi, oni simoo bale oowooyingga oolengo Yesuslo mandeni ingowelo mayewonggori. Enengo sayi oni nguya yomosiyelonilolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ene nalu gulanangge nangge, nguno Yesus enesu nangge tolige oni kini mela eluwooyingomo toongelo, nguno Anutno yemboongelo oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nalu gulano, Yesus oni simoo bale Anutlo mande yunolo oluwolo. Mamana mandelo sobosobo oni oowooyi Parisi, ko mamana mande etuyeloyingo oni gidalega nguya, ngu Yudiya mela ngulo ende ende bidodomonggo, Yerusalem ende ulunggano ngunonggo ko Galili melako ende ngu bidodomonggo mayelo oluwonggori. Anut oo bidodo Sembuli Ulungga, ngundo yanggango Yesus inootoni, ngundo sayi oni yoyeni, metemi telo toongewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Oni gidalegado oni gula wembuyi ko kekandeyi bingo yeyingomu, ngu yabanidodo sumoolo, koolowoolo mayelo, yolo ya newendemo Yesus keyi damonimo yewelo tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ene simoo bale ulungga oolengo ngulo ya newendemo uweloyi kini. Ngundilo ngulo, ene koolowoolo, ya sanganimo oolelo, ya uyi andangelo, nguwoole oni simoo bale kewooloyemo sayi oninggaku wetoloodoni yawasadodo yeyi, Yesus tanggeyimo uwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesusndo ngu oniku enengo nowoondoyemo hamoo teyingo ngu yeyolo, sayi oninggakuya ewolo. Doboone, gengo mbumbuwage andangetenolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ngundilo etoni ngu, mamana mande etuyeloyingo oniya, Parisi oni ngudodo enengo nangge ingondudunolo ingolo ewonggori. Nga oningga nga onendo? Ene Anut yumooyinolo mande ngundilo ete. Onendo mbumbuwa andangeweloyi ingoote? Ngu kongga ngu Anutlo nangge, Anut enengombo ngu mbumbuwa andangeweloyi ngu ingooteku ngu! Ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","24","Yesusndo ngu oni ngulo ingonduduye ingolo, ngulo mande gumilo ewolo. Nondo kowuli kini, no mete gengo mbumbuwa ngu andangewano. Ndatelo ngulo, ye ma ingootenggoku, ngu hamoo bine, ngundi kini bine? Ene nondo ngandilo ewanoku ngu, ge mete ootookooya, oolouwelo etoowe, asa, ye ngu tunoo kenolo, ngunonggo ingowanggo. No Anutlo Onilo Nangoni no yanggangonedodo no mete mbumbuwa nguya andangewano. Asa, no mete nga oni kekandeyi biyominggaya ewanoku ngu, ge ootookooya oolou! No ngundilo etoowe ngu, ye kenolo, ngu ye ingowanggo. No nguya mela nga bidodo simoo balelo mbumbuwa ngu mete andangeyunowano. Ene ngundilo elo, Yesus yowoolengolo, oni wembuyi bingo yeyingonggakuya ewolo. Asa, ge ootookooya, gengo yaba yoya, koolowooya, gengo yano ooloulo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ngundilo etoni, asa, ngu oni simoo bale ngu doongeyemo, ngu oni biyominggaku ootookoolo, enengo yabaga kuli ngu sanganimo wetolo oluwokunggaku, ngu yolo koolowoolo, Anut bingami ulungga elo okoolo, enengo yano oolouwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ngundilo tetoni ngu, oni simoo bale bidodo ngu kenolo soliyokowonggori. Ngundilo telo, ene nguya Anutlo oowooyi bingamilo okoowonggori. Nowoondoye sosolelo ewonggori. Ataga, noole damoni sungo oolengo gula kenootetoku ngu! Ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kootusina, Yesus ootookoolo, oololo, oni gula kenootoni, Gabmanlo bobeye yoweloyi tookoododo yano bibitelo oodoni kenowolo. Ngu oningga ngu oowooyi Liwayi, (oowooyi gula Matiyu), Yesusndo kenolo ewolo. Ge ombuya, no keneloya endeyolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ngundilo etoni, Liwayi ootookoolo, enengo oo sitowi bidodo yokootoni oodoni, ene Yesus keyolo oolouwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Liwayindo enengo yano oo Simbo ulungga Yesuslo kawolo. Gabmanlo bobeye yoyingo oni oowooyingga, ko, oni simoo bale gidalega nguya enedodo bibitelo oo newonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Parisi oniya, mamana mande etuyeloyingo oni, ngudodo Yesuslo sulena onikuya boguwoolo mande mande ulungga ewonggori. Ndawugalo ye oni damoniye biyomi Gabmanlo bobeye yoyingo oni, ko, mbumbuwadodo oniya sono oowali netenggo? Ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","32","Yesusndo manggoye gumi ewolo. Oni goweye moondeye gome metemimu, ngu sayi oni yomosiyeloyingo onino (Dokta) ma oolouwanggo. Kini, sayi onindo nangge ene nguno oolouwanggo. Ngundilo nangge, no oni nenengo oolootenggoku, ngu negoyelootoowega, nowoondoye yowoolengoyilo ma ombuwolo. Kini, mbumbuwadodo oni ngu negoyelootoowega nowoondoye yowoolengoyi, elo ngulo ombuwonowolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ene Yesusno ewolo. Yonlo sulena oni, ko, Parisi onilo sulena oni nguya, ene oowali yokolo kundingiyi telo, nalu ulungga yemboongelo oolootenggoku, ndawugalo gengo sulena oni, ngundo ngu damoningga ma tewonggori? Ene oowali sono nguya netenggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","35","Etoyi, Yesusndo mande yamonggawo gumi ewolo. Ye bine oni gula bale yoweloyi naluno, ngulo keyimo dobooguliyi ngu oodoyi, ene oowali mete loogu tewanggo, bine? Kini, kootusina, ngu oni bale yoweloyiga ngu yolo satoyigo, ngu naluno, nowoondoye kowuli yelo, ene oowali loogu telo, kundingiyi tewanggolo ewolo. Yo, ngundilo nangge, ngu naluno enengo sulena oni Yesusya oode, ene oni oni telo oluwonggori. Ene Yesus toongeweloyi naluno, nguno ngu, enengo sulena oniku, kowuli yolo, ngulo oowali loogu telo yemboongewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesusndo mande yamonggawo gula, elo yunowolo. Oni gulado kumba kedaga oomboongelo, ngundo kumba kuliminggano wetu ma ukingolo wesibiyowa. Ene oni gulado ngundilo tewaku ngu, ene kumbani kedagaku yombuliyowa. Ngu kumba kedaga ngu kumba kulimingga nguya metemi kinilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","No mande yamonggawo gula yeno eteno. Oni gulado bo nangoni keda ngu yolo, si kulimimo nguno ma siliyowa. Ene ngundilo tewaku ngu, bo nangoni, ngundo ngu bo siga ngu oomboongelo bo nangoni melako solelo yombuliyowa. Ngundilo tetoni, enengo si, bo nguya biyomi yewali. ");
INSERT INTO rwo_karo_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kini, oni ene komo bo nangoni keda si kedamo nguno siliyowa. Ngundilo tewaku ngu, enengo ela elaya keda, ngulo ene gome oluwali. ");
INSERT INTO rwo_karo_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ngundilo nangge, oni dogoni, ngundo mande damoni keda ngu keyolo endeyolo oluweloyi, ngu kowuli oolengo. Ngundo mande damoni kulimi, ngulo ngandilo ete. Damoni gome metemilolo ete. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sabat nalu gulano, Yesus, enengo sulena oniku nguya, nggile ko gula kewoolokuli endeyowonggori. Kono endeyolo, Yesus enengo sulena onikundo kono nggile ngulo engge gidalega andangelo yolo, kandeyebo tuloolo, andangelo daboolo newonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Parisi onindo ngundilo yeyolo ewonggori. Sabat naluno, ngundilo oo ngu ma teweloyi, ngu loogu oolengo. Ndawugalo ye ngundilo tetenggo? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Yesusndo mande gumi ewolo. Ye Dewitndo teyingo ngu ma kandangelo ingootenggo, bine? Dewitndo enengo keyimo onikuya oowalilo kumoolo biyomi telo, ene ndatelo tewo? Dewitndo Anutlo yano ulo, oomanangoyingo, Anut doongeyimo oluwoku yolo nelo, gidalega enengo keyimo oniku yunootoni newonggori. Ngu oomanangoyingo ngu kundingiyi, kingo onindo ma neweloyi, goobooyingo yalo sobosobo oni, ngundo nangge mete newanggo. Ye bine ngu ma kandangelo ingootenggo? Ewolo. Ngu Dewitndo ngundilo tewolomu, ngu mete bine, ngulo nolo sulena onikundo teyingo ngu, nguya metemi nangge? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ngu naluno, Yesusndo mande gula elo ewolo. Onilo Nangoni ene Sabat nalu, ngulo Sembuli ulungga oolengo. Noso nangge mete oni oo gula Sabatno tewelo ingowanggoku, no mete sobowoowano ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sabat nalu gulano, Yesusndo Yuda onilo goobooyingo ya gula nguno ulo mande elo, oni simoo bale etuyelowolo. Oni gula nguno oluwoku ngu, oningga ngu kandeyi koondosina ngu biyomi yewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Mamana mande etuyeloyingo oni, ko mamana mandelo sobosobo oniku oowooyi Parisi, ngundo Yesus uleyi kumooweloyimbolo kenondadangelo sobowoowonggori. Yesusndo Sabat naluno sayi oningga ngu yomosiyowa, ngundi kini, bine? Elo ingowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yesusndo ngu oni ngulo ingonduduye biyomi ngu ingolo, ene yowoolengolo, oni kandeyi biyomingga nguya ewolo. Ge ootookooya kewooloyemo dika. Ngundilo etoni, oni kandeyi biyominggaku ootookoolo kewooloyemo dikawolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yesusndo ngu onikuya ewolo. No ye sumoo yunooteno. Noole Sabat naluno, damoni metemimu tewato, bine; ngundi, damoni biyomi ngu tewato, binengga? Oni yomosiyolo yowato, bine; ngundi, yombuliyowato bine? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ngundilo elo, enendo oniku yeyondandangelo yokolo, yowoolengolo kandeyi biyominggakuya ewolo. Kandege yoonenengo, elo etoni, ene ngundilo tetoni, kandeyigaku mete tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ngundilo tetoni, onikundo ngundilo kenolo, ngulo sanggili biyomi oolengo telo, enengo nangge mandelo ingolo ewonggori. Noole ndatelo ooga ngu Yesus teyinowato? Ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ngu naluno, Yesus mela puli gulano yemboongewelo oolewolo. Ngu suwoonggano nguno, Anutno kila elo oodoni oololo sengewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Sengetoni suwoononggo enengo sulena oniku negoyelootoni, ombutoyi, kewooloyemo kande elaya kegidembolo elaya yoyolo oowooyi Aposello ewonggori. (Aposel, ngu damoni ngandilo, ngu Yesuslo sulena oni kilalongo.) ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","Ngu oniku, ngu oowooyi nga: Sayimon, Yesusndo oowooyi Pitalo ewolo. Oowooyi gula ngu Enduru ngu Sayimonlo koneyo; Yems, Yon, Pilip, Batolomeyu Matiyu, Tomas, Yems, ngu Alipiyaslo nangoni, Sayimon. Enengo damoni ngandilo, enengo mela ngu mela gula onindo sobowooweloyi ingonduduni kini oolengo. Yudas ngu Yemslo nangoni, Yudas Iskariyoot, nguya yoyowolo. Yudas Isakaliyoot, ngundo kootusina, damodamoni telo, Yesus longge onino yootunolo yunowa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesusndo enengo sulena onikudodo mela pulimonggo ulo, mela ngguwungoomo dikalo oodoyi, oni simoo bale oowooyingga oolengo mayewonggori. Ene Yudiya melanonggo, Yerusalem endemonggo, ko wendeyi tamako ende Tayiya Sayidon ngunonggo, Yesuslo mandeni ingowelo elo mayewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Enengo sayi oni nguya Yesusndo yomosiyeloni, elo yoyolo mayewolo. Oni gidalega ngu yuka biyomimbo yombuliyeloyingomu, nguya Yesusndo yomosiyelootoni mete temukowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Oni simoo bale ulungga oolengo Yesus dowoolo ingowelo ingowonggori. Ndatelo ngulo, enengo yanggangoni ngu goweyimonggo tunootewolo. Ngundo sayi oni bidodo yomosiyelootoni, oni metemi tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesus doongetelo enengo sulena oniku yeyolo ewolo. Ye owoolongo oni, oo gidalegalo ootututetenggoku ngu, ye oni oni teya ingoyi. Anutndo ye ngu oo ngulo hoolooweyelowa. Ataga ko kootusina nguya, Anut enengo endeningga sobowoolo oolooteku nguno uwanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ye ataga Anutlo mandeni damoni gome ngulo hahangelo oolootenggoku, useyembolo kumootenggoku ngundilo tetenggoku, ene kootusina, ye sambolo oowali nelo useye ndindi tetoni, ngulo oni oni tewanggo. Ye ataga mbumbuwa tetenggoku ngulo nowoondoye ogingoyingootoni, sendolo oolootenggoku ngu, kootusina Anutndo yengo kowuli ngu yowoolengootoni gome metemi tunootetoni, ye ngulo oni oni telo nggonggangolo oluwanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ye oni oni teya oliyi. Mela ngalo onindo ye yeyootoyi, Onilo Nangoni, ngulo mande damoni ngu keyolo oodoyi ngu, yeyolo nowoondoye biyomi kowoo oolengo ingolo, ye keyolo yoyokolo, mande biyomi elo, yengo oowooye nguya oo biyomimonggo ewanggo. Etoyi ngu, Anutndo ngu kowuliye ngu yolo yowoolengootoni gome metemi tunootetoni, ye komo oni oni tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Nalu gulano, yeno ngundiya yunootoyiga ngu, ye ootookooya Anutno oni oni teyi. Ngulo yengo uliye sitowiye Sambo Endemo ngu ulungga oolengo ooloote. Kowuli ye yunootenggoku, kulimi enengo osi sambayebo Anutlo ingondudu eyingo oni, nguya ngundilo yunowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ene ye bobeye sitowiyedodo oni, ye ingondale teyi! Gowugowulongo! Yengo nowoondoye ngu sitowiyembolo ingonduduye ngulo yetoyi, dowoomomoolo ooloote. Ye nowoondoye yomosiyoyingo oo ngu ye kuli yomukowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ye mela ngalo oowali, ko oo ngu oo sitowi yomukowelo hahangelo endeyootenggo. Ngulo gowugowulongo! Anutndo oowali gomemu yunootoni, useye ndindi teweloyim ngu ye yokootenggokulo, kootusina, ye komo biyomi oolengo tewanggo. Ye ataga oni oni telo yumoolo gonggangootenggo. Ene kootusina, ye ngu sendolo biyobiyomi telo oluwanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ene oni simoo bale bidodo ye oowooye bingamiye okootoyiga ngu, ariya, ye ingondale teyi! Kulimi, osi sambayebo ingondudu eyingo oni ebe ganagana ngulo onino nguya ngundilo tewonggori. Ene Anutlo ingondudu eyingo oni hamoo, oni simoo baledo enengo mandeni ma ingolo, ngulo ene mande inolo, kowuli oowooyingga inowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ye nolo mandene ingootenggoku oni yeno eteno. Yengo longge oni ngu nowoondoyi yunoyi. Oni yeya nowoondoye biyomi yetoyiga ngu, yendo ngu komo damoni gome nangge eneno teyi. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Oni yeya mande biyomi eya yombuliyelootoyiga ngu, ye ngulo Anutno yemboongetoyi, Anutndo ene hoolooweyelowa. Oni ene kingo ye yombuliyelootoningga ngu, ye Anutno yemboongetoyi, Anutndo ene hoolooweyelowa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Oni gulado gagiye gidalesina oolongooya yudoningga ngu, ariya, gagiye gidale nguya yowoolenggootooga uleni. Oni gulado yengo dokikilo nenggulo udageloya yootoningga ngu, yengo kumbaye nguya ma solengowelo. Ngu nguya yokoyinootooga, udageloya yoni. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Oni gulado yeno oo gulalo kila etoni ngu, ye komo ngu ooga ngu inoyi. Oni gulado yengo oo gula udayelolo yootoningga ngu, ye komo ko yowelo ma ewelo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ye oni nowoondoye yunolo, damoni metemi yeno tetenggoku, ye ngulo gome ingootenggo. Ngundilo ngulo, ye nguya damoni ngundilo nangge oni sungomboya tewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Oni ye nowoondoye yunootenggoku ngu, ye nguya ene nowoondoye yunolo ngu, asa, ngungga ngu, oo ulungga kini. Mbumbuwadodo oni nguya, ene oni nowoondoye yunootenggoku, ene nguya nowoondoye yunootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Oni gula yeno damoni gome telo, yooneneyelolo yomosiyelootenggoku, ye gumi ngundilo nangge yomosiyolo ngu, asa, ngungga ngu, ngu nguya ulungga kini. Mbumbuwadodo onindo nguya ngundilo nangge tetenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ye oo gula oni yunolo ngu, ndatelo ngulo ye ingootenggoku, enebana gumi yunowalo ingootenggo. Ye ngulo ngu ndatelo eselo ewanggo? Hamoo oolengo kini. Mbumbuwadodo onindo enengo dobooye oo kingo inolo ngu, enebana oo gumi ngundilo nunowalo ingootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ene nondo yeno eteno. Ingoyi! Yengo longge oni ngu komo nowoondoye yunoyi, ye komo nenengo damoni gome ngu teya, oo kingo duwoo yunowolo. Ngulo ye ngu oo ngulo gumi wendangelo, oo gula yunoyilo ma ingowelo. Oni Anutno ese ma tetenggoku, ko, oni biyobiyomi nguya Anutndo ene sumange yunoote. Ye ngundilo telo ngu, kootusina, yengo uliye ulungga oolengo Anutlo Sambo Endemo yolo, Anut ulungga ngulo simoongo telo oluwanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Yengo Awayembo yengo newende yunooteku, ngundilo nangge, ye komo nguya oni sungo nowoondoye yunoyi. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ye oni gidalega goweye sanggawelo mande elo ma wilikoyelootenggoku ngu, asa, Anutndo nguya ye ma wilikoyelowa. Onilo kowuliye, wilikoyunolo, ngulo kowuliyengga tewonggoku, ngulo yengo ingonduduyemo sugi sugi ma ingondudu telo oluwelo. Ye ngundilo tetoyi ngu, Anutndo yengo kowuliye nguya ma ingonduduwoolo oluwa. Ye oni guminggalo mbumbuwaye andangelo kapeyelowanggoku ngu, Anutndo yengomu nguya andangeyunolo kapeyelowa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ye komo oni oo gidalega yunowanggoku ngu, enebana ye yunowa. Yo, yengo oo wilikoyingo gome nenengo onindo nguya ngundilo oo gome nenengo oolengo yunootenggo. Ye wilikolo, ulungga oolengo siko gome siliyootoyi, manggowoomo oolelo, wendoni uweloyi tetoni, ngulo kowuli okooweloyi kinitetoni, ye yunowanggo. Yendo oni yunowonggoku, ngundilo nangge, Anutndo ye nguya ngundilo yunowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesusndo mande yumoonggawo gula nguya elo ewolo. Oni gula doongeyi kilingo, ngundo oni gula nguya doongeyi kilingomu oole etungowa, bine? Kini, enengo ela elaya meleno yoyolo solewali. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Skul simooye ngu oo etuyeloyingo oni ngu ma dagayelowanggo. Kini, ene ulu telo, ingoyingo gome yologo ene etungoyingo oninggakundo ko tetenggoku ngundilo ko tewanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ene mande yumoonggawo gula ngandilo ewolo. Ndawugalo dobooge doongeyimo oo kakawu bodaga oolooteku ngu kenolo ete, ko gengo doongenggemo de sosi ulungga oolooteku, ngu ma ingowo? ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ge ndatelo ngulo doboogeboya ete, doboone, doongenggemo oo kakawu bodaga oolooteku ngu, yewega toongenilo ete. Ene gengo doongenggemo, de sosi ulungga oolooteku, ngu ge ma kenowo? Ge mebuge sangala oni! Ge koleteya komo gengo doongenggemo de sosingga oolooteku ngu, ngu yega toongetoningga, ariya, kootusina, ge dobooge doongeyimo oo kakawu oolooteku, ngulo gome doongetelo yeyi toongewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","De metemi, ngundo engge biyomi ma enggete. Ngundilo nangge, de biyomi, ngundo engge metemi ma enggewa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Onindo ngu de engge nguno kenolo ingootenggoku, ngu de metemi, ngundi de biyomi binelo ingootenggo. Onindo bata dega ngulo engge ngu utoo sanggilidodo oowooyi dimoo utoo, ngu bungomonggo ma andangelo yootenggo. Ngundilo nangge, bo nggile ngundo nggile oolengo engge ma enggewa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Oni gome metemingga ngu, ene newendemo ingoyingoni gome metemimu newendemo ooloote. Ngulo ingonduduni mandeni gome gome nangge ingolo, enengo ootoo ootoo damoni, nguya gome metemi ngu yeni tunootete. Oni biyomi ngu enengo ootoo ootoo damoni nguya biyomi, ko ingonduduni biyomi ingooteku, ngu nguya yeni tunootete. Enengo newendemo damoni oolooteku, ngundilo nangge ene koyi telo, manggowoomo nguya yeni tunootete. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ndawugalo ye noya ngandilo etenggo? Ulungga, Ulungga oo Bidodo Sembuli Sembunaye, elo etenggo, ngulo ye nolo manggone ma keyootenggo? Ene ye nolo mandene damoni ma keyootenggoku ngu, asa, ye noya Oo Bidodo Sembuli Sembunayelo ma ewelo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","No ngandilo etuyelowano. Oni oowooyingga no tanggenemo ombulo, nolo mandene ingolo ngu, ene ngandilo keyowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ngu oni ngu ngandilo. Oni gula ene ya yewelo ingooteku ngandilo. Oni ya yewelo ngu, ene mela selo, siyakiyolo, mela yanggangonggakuno mele selo de osiyinggaku nguno yetenggo. Ngundilo telo ngu, asa, ngu sanganimo ya yewa. Kootusina, sono doogo ulungga telo, mewuyi ombulo, ya samanga damoni setoni, yanggaku onggi anggi ma tewa. Yanggango dikalo oluwa. Ndatelo ngulo, ene koletelo ya osiyi ngu mela gagiyimo mele selo, nguno ya yewoku ngulo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ene oni gula nolo mandene ingolo yokolo, ngu ma keyooteku ngu, ene oni gula mela mbumbuwango sanganimo mele bodaga nangge selo, nguno ya osiyi palalo, ya osiyi imilo ma samangawolo. Ngundilo telo, ene kingo mela bodagado damoni wiliyolo nguno ya yewolo. Ngundilo yetoni, kootusina, sono mewuyi tuwi ulo, yanggaku bungomo oolongootoni, yanggaku onggi anggi telo, ukelo uwa. Oni ene nolo mandene ingolo yokolo, enengo ingonduduni keyooteku ngu, ngundilo tewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Asa, Yesusndo oni simoo bale doongeyemo mande ngu yootunolo, elo etuyelolo yokolo, ene Kaperniyam endemo uwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Me onilo tabango gula nguno oluwoku, ngu oningga ngu Rom Gabman (Yuda oni kini) ngunonggo mayelo, ene me oni ngu onibi kandegula (100), ngulo sobosobo oningga oluwolo. Ngu oningga ngulo sulena oningga ngulo gome ingooteku, ngu sayi ulungga yolo, kumoowelo tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ngu me onilo tabangongga ngu mande ingowolomu ngu, Yesus Kaperniyamno ooloote. Ngu ingolo, ene Yuda oni tabango gidalega suleyelolo eneno etoyiga ombuya enengo sulena oningga ngu yomosiyonilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Ngundilo etoni, ene Yesusno ombulo, sumoo sumoo telo ewolo. Ge komo ma yokowelo, ene oni gome, enengo sulena oni, ngundo sayi ulungga kumoowelo tetoni, ngulo ge mete ene hooloowe! Enendo, noolengo Yuda onilo goobooyingo ya gula yeyunowolo. Ene Yuda oni simoo bale noolengo gome ingolo, newende yunootelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yesus enengo mande ingolo, ariya, ene ootookoolo, ngu Yuda onilo tabango onikuya oolouwolo. Yade oololo, ya tanggeyimo ooloutoyi, ngu me onilo tabangongga, ngundo dobooguliyi gidalega suleyelolo ewolo. Ye ende ooleya, ngandiya eyi. Ulungga Oo Bidodo Sembuli, ge ngalo ko ulungga ma tewelo. No oni nenengo kini. Ngundilo ngulo, ge nolo ya newendemo ma ombuwelo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ngulo ngu, no nenengombo ge tanggegemo ma oolouwonowo. Ngulo ge mande gula nangge etooga, nolo sulena oninengga nga ko mete teni. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ngu ngandilo. No ngu oni ko no nunootenggoku, ngulo sulena oni. Nondo nguya ngu me oni gidalega sobosobo oolooteno. Ene nondo ngu me oni ngu gulaya eteno. Ge oolou, elo etoowe ngu, ene ooloute. Gulaya eteno. Ge ombu, elo etoowe ngu, ene ombute. No sulena oni gulaya eteno. Oo ngu yomosiyo, elo etoowe ngu, ene oo yomosiyootelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ngundilo elo yokootoni ngu, Yesusndo ngu mandega ngu ingolo, ngulo ingondudu ulungga ingolo, yowoolengolo, oni simoo bale ulungga ene keyolo endeyootenggoku, nguno ewolo. No yeno eteno. Iserel oni kewooloyemo oni gula, nga oningga newendemo hamoo teyingongga, ngandilo ma kenootenolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Me oni tabangongga, ngundo oni suleyelootoni, Yesusno oolewonggoku ngu, ya newendesina ulo, sayidodo oninggaku kenowoku, ene kuli mete tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Kootusina, Yesus ootookoolo, Nayin endegano nguno oolouwolo. Yesus enengo sulena oni ngu bidodo, ko, oni simoo bale oowooyingga oolengo nguya enedodo oolouwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Yesus galo yade oololo, endesoono oolouwonggori. Ngu endega ngulo onindo, oni gula kumootoni, bingo sumoolo koolowoolo uwonggori. Ngu simoongga kumoowoku, ngulo nemi ngu, nangoni komo gulanangge ngu kumooteku ngu! Ngu endega ngulo oni simoo bale ulunggaku, ngu bale nggaminggakundo sendolo utoyi, ngulo ene keyolo uwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ulungga oo Bidodo Sembuli, Yesus, ngundo ngu bale nggamingga ngu kenolo, nowoondoyi ulungga telo, eneno ewolo. Ge ma sendowelolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Yesus ene onibi sumoolo ombuyingomu tanggeyimo oololo, onibigakulo Bogis dowoowolo. Oni onibi koolowooyingo oniku dikalo, nenetelo oodoyi, Yesusndo ewolo. Simoo kosiyi, no geya eteno. Ge ootookoo! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ngu oni kumooyingonggaku ootookoolo, bibitelo, mande etoni, Yesusndo dowoolo, oololo, nemi ko inowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ngundilo tetoni ngu, oni simoo bale bidodo soliyokolo, Anutlo bingami okoolo ewonggori. Anutlo ingondudu eyingo oni ulungga, noole kewoolonayemo ataga tunootetelo ewonggori. Ngundilo elo, Anut kuli ombuwoku, ngundo enengo oni simoo bale hoolooweyelowelo! Ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yesusndo ngu kongga tewoku, ngulo mandeni elo endeyootoyi, Yuda mela ngu logowootoni, oololo mela sungomo nguya, elo soweyolo sawonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","19","Sonoyeloyingo Oni Yondo, enengo sulena onindo Yesus ko tewoku, ngu bidodo damoni, Yonno etoyi ingowolo. Ngundilo tetoyi, ene ingolo, Yondo enengo sulena oni elaya negoyelootoni ombutoli. Suleyelootoni, Oo Bidodo Sembuli Ulungga, nguno mande yolo oolouwoliyo. Yali Yesusno oolouya, ngandiya sumoo eli. Ge Anutndo sulenggelootoni, noole yoyoweloyi oninggaku, ngundi, noole komo oni gulalo doongetelo sobowoowato, bine? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ngu oni elayaga ngu Yesusno ombulo ewoliyo. Sonoyeloyingo Oni Yon, ngundo noole ngandilo elo, suleyelootoni ombutelo. Ge nga oningga nga, Anutndo sulenggelootoni noole yoyowelo, binengga, ngundi, noole oni gula sobowoowato, bine? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ngu nalunggano nguno, Yesusndo oni simoo bale ulungga oolengo, sayi damoni oowooyingga yomosiyelolo, oni mela yuka biyomidodo oowooyingga oweyelolo, oni doongeye kilingomu yooneneyelootoni, ene doongetelo, oo kenowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ngundilo telo yokolo, Yesusndo Yonlo sulena oni elayagakuya ewolo. Asa, yali oolouya, Yonno eli. Oo ataga yalindo kenolo ingooteliku nga! Oni doongeye kilingomu ene doongetetenggo. Oni kekandeye biyomi yeyingomu, ene mete telo, metemi endeyootenggo. Oni golimambudodomu ngu goweye metemi tetenggo. Oni sodeye tuwoomu, mela mande ingootenggo. Oni kumooyingomu, ko keda ootookootenggo. Owoolongo oni, ene Anutlo mande keda mesalango, nga ingootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Oni ene nolo newendemo hamoo telo bulibali ma teyingo ngu, asa, ngu oni ngu, ene mete oni oni telo oluwalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Sonoyeloyingo Oni Yonlo sulena oni elayagaku mande ngundilo ingolo, ene Yon tanggeyimo ko oolouwoliyo. Ngu naluno, Yesusndo oni simoo baleno Yonlo ewolo. Kuli oni kini kingo melako nguno, ye oololo, ndawuga kenoyingo? Ye nggusi duwoo doogobo yowoolalingootoni, kenowelo oolouyingo, bine; ngundi ye oololo, oningga oo bulibali tetoni, kenolo oolouyingo, bine? Kini, Yon ngu ngundilo oni kini. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ngundi ye ndawuga kenowelo oolouwonggo? Oni gula towikumba gome gomemu telo oodoni kenowelo, bine? Kini, ingoyi! Oni towikumba gome gomemu telo ngu, ene sitowiyedodo telo, enengo ya gome oluwanggo. Kini, Yon ngundilo kini. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ene ye ndawuga kenowelo oolouwonggo? Ye Anutlo ingondudu eyingo oningga kenowelo, bine? Yo, no yeno hamoo eteno. Yon ngu Anutlo ingondudu eyingo oni. Enendo Anutlo ingondudu eyingo oniku, ngu dagayelolo, enendo nangge ulungga oolengo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ngu Yonngga, ngulo Anutlo mandeno Anutndo enengo Nangonimboya ngandilo ewolo. Ingo, no oni gula suleyootoowe, ngundo nolo mandene yolo, ge koletelo oololo, gengo oole yomosiyonggunowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","No yeno eteno. Yondo Anutlo ko teteku ngu, ngu oni melako ngano ko telo oolootenggoku, ngu bidodo dagayeloote. Ene oni Anutlo nowoondoye hamoo teyingo, ko nolo mandene keyootenggoku ngu damoningga ngundo Yon ko yanggango tewoku ngu dagalo ulunggalolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Yesusndo Yonlo mande etoni, oni simoo bale bidodo ingolo yokolo, asa, simoo baledoya, bobeye yoyingo oniya ewolo. Yo, Anutlo mande damoni ngu gome oolengolo ewolo. Ngu oni ngu, ene Yon kandeyimbo sonoyelowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ene Parisi oni, ko mamana mande kandangelo etuyeloyingo oni nguya, ene Yondo ma sonoyelowolo. Ene ngu Anutndo oole gomemu etuyelootoni, ene kootu inolo yokowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesusndo ewolo. Nga naluno, oni simoo bale endeyootenggoku ngalo damoniye wilikootoowe, ndatelo oningga ngundilo? ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ene ngu simooye koondoonge tetoyi ngandilo tewonggori. Ene ende kewooloko bibitelo, enengo nangge meno manggalu telo ewonggo. Noolendo sumbi uwootooye, ye yambo ma utolo kunowolo. Noolendo oni kumootoni solengoyelo nowoondoyi teweloyi yambo ulewootoku, ye ma sendowolo ewolo. Simooye gidega oo tetoyi ko ngulo simooye guminggado suleyeyokini yewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ene Sonoyeloyingo Oni Yondo ombulo, ene oomanangoyingo ma nelo, Wayin sonoyi nguya ma newolo. Yendo ngu ewonggori. Yuka biyomi eneno oolootelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ene Onilo Nangoni Kilalongo ombulo, ene oowali nelo, sono nguya netoni, yendo ngu kenolo etenggo. Kenoyi, nga oningga nga, ngu oo bidodo nemukolo, Wayin sonoyi nguya gome gome neteku nga! Nga oningga nga, ngu bobeye yoyingo oni, mbumbuwadodo oni ngulo dobooyelo etenggo. Noolendo oo gula tetoowe ngu, ngu bidodo ye ngulo ma ingootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Oni simoo bale Anutno nowoondoye hamoo teyingo ngu, enengo keda oluweloyi ngu enggedodo. Oni gidalega keda oluweloyi gomemu ngu kenolo, ngundilo ingootenggo. Anutlo mande ngu hamoo oolengolo ingootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Nalu gulano, Parisi oninggado Yesus negongootoni, enengo yano ombutoni, enedodo goboolo oo neweloyimbolo ewolo. Ngundilo etoni, asa, Yesusndo ombulo, enedodo oo neweloyimbolo oololo, Parisi oningga ngundo yano ulo, oo neweloyi yabano bibitewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ngu endemo nguno, bale gula oluwolo. Ngu balega ngu, ene bulibali bosebalese damoni biyomi keyooteku, ngundo ingowolomu, Yesus Parisi oningga ngulo yano ulo, oowali netenggo. Ngulo ngu, balega ngu ene ootookoolo, digi nggusiyi gomenggano bo ulumi ndindingo gomengga yolo ombuwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ngu balega ngu ombulo, Yesus kootusinanggo ombulo, Yesus keyi damonimo dikalo sendootoni, doongeyi sonoyimbo ulo, Yesus keyi sonowootoni, ngu enengo tabango uyimbo yonggulumoowolo. Ngundilo telo, Yesus keyinggaku mududu yunolo, nguno bo ulumi gomengga ngu wendolo, ngundo Yesus keyi sonowoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Parisi oninggado Yesusno etoni, enengo yano ombuwonggokungga, ngundo ngundilo tetoni ngu, kenolo, ene ngandilo elo ingowonggori. Nga oningga nga, ngu Anutlo ingondudu eyingo oni tetoningga ngu, asa, ene balega ngalo damoni biyomi ngu kenolo ingolo, asa, nga bale biyomingga ngando ombulo, tanggeyimo loogu yetoni, ma ombuwalo ingowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ngundilo ingootoni, Yesusndo ngu oninggakulo ingonduduningga, ngu gumilo ewolo. Sayimon, no geno mande gula ewelo. Etoni, Sayimondo ewolo. Oo etuyeloyingo oni, mete mandega ngu elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesusndo mande yamonggawo gula ewolo. Bobeyedodo oninggado oni elaya bobeye gumimbolo yunowolo. Oni gulano doobe onibi elaya kande elaya (500 Kina) inolo, ko oni gulano doobe kandegula (50 Kina) nangge inowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Kootusina, bobeyeku wendangelo gumi ngundilo inoweloyi nguya ereremo kini. Ngulo bobeye sembuliga, ngundo nguno yokolilo ewolo. Ariya, ngu oni elayaga ngu, onendo bobeye sembuliga ngulo gome oolengo ingolo eloluwa? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Sayimondo ngundilo ingolo, gumi ewolo. Ngu oningga bobeye ulungga kingo inoyingongga ngundo. Ngundilo etoni, Yesusndo ko ewolo. Ge hamoo nenengo ingolo etelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","45","Yesusndo balegakusina yowoolengolo, kenolo, Sayimonya ewolo. Nga balega nga keno. No gengo ya newendemo ombutoowe, kene sonowooweloyi sono gula ge ma nunowolo. Ene nga balega ngando enengo doongeyi sonoyimbo kene sonowoote. Ngundilo telo, enengo tabango uyimbo yonggulumoolo yomosiyoote. Ge no ma yenggonayelolo mududu teyinolo, kuli gengo yano ombuwonoku, ngunonggo ombulo anangu nga! Ene nga bale mbumbuwadodoga ngando, ngu ene kenengga ame mududu teyinolo, gome ingolo, hahangelo yade mayelo mududu tete. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ge nolo tabane bo ulumimbo ma sonowoolo domooyingo, ngulo ngu, ene balega ngando moondene dowooweloyi bo ulumi ndindingo gome, ngundo kene sonowoolo yoonenengoote. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ngundilo ngulo, no geno eteno. Nga balega ngando, ene nolo newende ulungga oolengo teteku, ngulo nondo enengo mbumbuwani ulunggaku andangetoowe ute. Ene oni gulalo mbumbuwani bodaga tewoku ngu, Anutndo ngu andangelo inootoni uwa. Ngu oningga ngundo newende bodaga nangge Anutno esetewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yesusndo ngu balega nguya ewolo. Gengo mbumbuwage ngu, nondo kuli andangetenolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Oni Yesusya oo newelo bibitewonggoku, ngundo ngu ingolo, enengo nangge mandelo ingolo ewonggori. Nga oningga nga, ngu oone, ene mete mbumbuwa andangelo yokowa? Ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yesusndo ngu balega nguya ewolo. Ge Anutlo nowoondogemo hamoo tewokuga, ngunonggo Anutndo ge ko goyoote. Ge mete sumangedodo toongeya, nowoondoge imakeyingomo ootoolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","3","Kootusina nalu gidalegano, Yesusndo enengo sulena oni kande elaya kegidembolo elayaga nguya, Anut oo bidodo Sembuli Sembunaye, ngundo enengo nalungga sobowooteku ngulo mande mandeni damoni, ngu ende ululu, ende bobodi ngu bidodomo, oni simoo baleno wesiyolo elo etuyelolo, oololo ombulo tewolo. Bale gula gula nguya, ngu bale ngu Yesusndo kuli yuka biyomidodomu owelo andangeyunowoku ngu, ko sayidodomu yomosiyeloyingoku, ngundo Yesus keyolo endeyowonggori. Ngulomu, bale gula oowooyi Mariya nguya ngandilo etenggoku, Mariya Magadala balelo etenggo. Ngu balegano nguno yuka biyomi kandegula gidembolo elaya (7) oweyelowolo. Bale gula oowooyi Yowana, ngu Herodlo yanimo ko sobosobo oningga, oowooyi Kusa, ngulo baleyi; Susana, ko bale gidalega nguya Yesus keyolo, mandeni ingolo yaliwolo. Ngu bale ngundo enengo bobeyebo Yesus, ko, enengo sulena oniya hoolooweyelootoyi, ngundo oowali oo uliyolo, nelo endeyowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ende ende oni simoo bale oowooyingga oolengo ende bidodomonggo mewoosoolo, Yesus tanggeyimo mayelo, gooboongoolo dikawonggori. Ngu naluno, Yesusndo mande yamonggawo gula, ngu oni simoo balekunolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Oni gulado Rayis yuwooyi kono yolo oololo kuliyowolo. Ngundilo kuliyootoni, Rayis yuwooyi gumingga ooleko soletoni, onindo wongoomukootoyi, numbo mayelo newonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Oo yuwooyi gidalega mela digi sangganimo solewonggori. Ngu oo yuwooyiku ngu gome ooleyingomu, ene mela ngu ulumi kini. Ngundilo ngulo, bidodo oolelo, ariyelo kumoomukowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Gidalega ulu sodabo, kakali so oo kewoolokono solewolo. Ngu ulu so kakali ookudodo oolelo, ngundo doobeyelootoni, siyokongo yewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Rayis yuwooyi gidalega mela gome metemimo solewolo. Ngu nangge gome oolelo, engge oowooyingga oolengo enggewolo. Yesusndo ngundilo elo yokolo, manggalu telo ewolo. Oni gula mande ingoweloyi sodeyidodoga tetoningga ngu, ene komo mandega nga gome oolengo ingonilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yesus enengo sulena onindo, Yesus sumoo inolo ewonggori. Ge mande damoni wiliyolo, ge mande yamonggawo nangge eteku, ngulo damoni ndatelo? ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Etoyi, Yesusndo gumi ewolo. Ye ngu, Anut oo bidodo Sembuli Sembunaye, ngundo simoo bale enengo soboyelooteku, ngu mande kombiteyingongga ngu, ye kuli Anutndo etuyelowolo. Ene simoo bale gidalegado ngu, ene mande yamonggawo nangge ingootenggo. Ene kenowelo doongetewanggoku, ene ma kenowanggo. Ene mande ingowanggoku, ene nowoondoyemo mande ngu ma ingowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Mande yamonggawo ewonoku, ngu damoni ngandilo. Ngu oo yuwooyingga ngu Anutlo mande. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Oo yuwooyi gidalega ooleko soletelo ewonoku ngu, oni simoo bale Anutlo mande ingootoyi, kootusina, Setando ombulo, ngu mandeku, oni nowoondoyemonggo andangelo yootoni, nguno ene Anutlo nowoondoyemo hamoo ma tewonggo. Ngulo ngu, Anutndo ene ma yoyowa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Digi sanganimo elo ewonoku ngu, oni simoo bale koletelo Anutlo mande ingolo, ngulo gome ingolo, oni oni telo, ngu koyi tewolo. Ene ngu nowoondoyemo hamoo teyingo ngu bodaga nangge tetoyi, ngu naluno, kowulingga kenolo, nguno enengo hamoo ingowonggoku, ngu yokowonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Oo yuwooyi so daboo sanggilidodo kewooloko oolooteku, elo ewonoku, ngu ngandilo. Simoo bale Anutlo mande ingootenggoku, kootusina, mela ngalo kowuli oowooyingga, bobeye oo sitowi, oo ngulo hahangelo, ingondudu tewonggori. Oo ngulo nowoondoyemo mande oo ngu doobengolo wiliyootoni, aliyelo, enggeni kini. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mela gomemo oo yuwooyi solelo ooletelo, elo ewonoku ngu, simoo bale Anutlo mande ingolo, ene nowoondoye gome yomosiyolo, hamoo ingolo, yolo, yanggango dowoolo keyootenggo. Anutlo nangge ingondandangelo endeyootenggoku ngu, ene gome enggetenggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Oni solu kalo, kumbe oo newendemo ma yelo wiliyolo, ko, yaba newendemo nguya ma yetenggo. Kini, yaba sanganimo yetoyi, ngundo oni gumingga nguya himi yunoote. Oni gidalega ya newendemo ombulo ngu, ene solu ngu kenowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Nga mande Anut oo bidodo Sembunaye, ngundo simoo bale enengo sobowooteku, ngu oo bidodo kombiteyingo ngu, kootusina, oo ngu tunootewanggo. Oo bidodo onindo oongooyingo ngu, kootusina, Anutndo yeni tunootemukowa. Oni oo ngu doongeyembo tunoo kenomukowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ye komo ingondale teyi! Ye komo ndatelo mandega nga, ngu gome ingoyi! Oni ene Anut oo bidodo Sembuli Sembunaye, ngundo simoo bale enengo sobowooteku ngu, ngulo ingoyingo bodaga ingolo oolootenggoku ngu, ene newende bidodo hahangelo, enengo mande ingolo keyootenggoku, asa, Anutndo enengo ingoyingongga ngu yeni, ulungga yewa. Ene oni ene Anut oo Bidodo Sembuli Sembunaye, ngundo simoo bale enengo sobowooteku ngu, ngulo damoni bodaga ingooteku ngu, asa, ngu ingoyingongga soweyolo, gumi ma ingootoni ngu, asa, Anutndo enengo ingoyingo bodaga ngu yolo oongoowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ngu naluno nguno, Yesus enengo nemi, ko enengo konedobooge, ngundo Yesusno mayewonggori. Ene oni simoo bale ulungga oolengo ngulo, ene Yesus tanggeyimo ombuweloyi nguya kini. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Oni gidalegado Yesusno ewonggori. Gengo nangge ko konedobooge ge geyowelo mayelo, endesina dikatenggoku awelo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ngundilo etoni, Yesusndo mande gumi ewolo. Oni ene Anutlo mande ingolo, ngu keyootenggoku, ngu nolo namone, ko nolo konedoboone. Ngundilo elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nalu gulano, Yesusndo enengo sulena oniya wanggo gula sanganimo oolelo ewolo. Ye wanggo woosootoyiga, noole sono koongeyingo anduloko ulelewato. Yesusndo ngundilo etoni, wanggo woosoolo, dowoolo ulelewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Wanggo sono koongeyingo sanganiwoole uloluwootoni, Yesus wanggo sanganimo wetolo kapengo yewolo. Ngu naluno, doogoga sono koongeyingo kewooloko tunootewolo. Ngu doogo ulungga, ngundo wanggo yowoolalingootoni, wanggo nguya sono koongetoni, ene oonatewelo tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ngundilo tetoni, sulena oniku oololo, Yesus yokutuwoolo ewonggori. Awa, Awa! Noole oonatewelo tetetoku nga! Ewonggori. Etoyi, Yesusndo ootookoolo, doogo, sono koongeyingo nguya yeyolo etoni, imakelo kinitewoliyo. Doogogaku ko sono koongeyingonggaku ma dokelo ikakooteyingo, ngu kondibo imakewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ngundilo tetoni, Yesusndo sulena oniku mamanayelolo ewolo. Yengo nowoondoye hamoo tewoku, ngu ndano? Ewolo. Sulena oniku goweye mboolomboolo telo, sosolelo ngunonggo, enengo nanggelo ingolo ewonggori. Nga oningga nga onendo? Doogoya elo, ko, sono koongeyingomboya etoni, enengo ela elaya ene manggowo keyooteliku ngu! Ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Kootusina, ene Gegesa melasina nguno oolouwonggori. Ngu mela ngu, Galili sono koongeyingo ngu gidalesina ooloote. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesus ene sulena oniya wanggo yokolo, wendeyi tamako uwolo. Nguno ende gula oluwoku, nguno oni gula oo yuka biyomimbo yoyingomu, ngundo Yesusno ombuwolo. Ngu oni yuka biyomimbo yoyingongga ngu, ene nalu pelungga towikumba ma yemuyingo, ene mbilimbili endeyolo ootoolo, ene ya gulano nguya ma oluwolo. Kini, ene nalu bidodomo, oni yoyeyingo melewoole nangge wetolo oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Kuli ngu, yuka biyomingga ngulo yanggangoni ngundo oningga ngu gome dowoolo oodoni, nguno enengo onindo ene dowoolo kekandeyi gome gome gosiyowolo. Gosiyolo ya biyomimo oni ngundilo sobowoolo oluwolo. Ene yuka biyomi ngulo yanggangoni, ngundo ngu sen uto bidodo oomboomboongelo ootoolo, ene oni yeni oni kini melasina nguno toongelo endeyolo oluwolo. Ngu oningga, ngundo Yesus kenolo meno manggalu telo, Yesus keyi damonimo ukelo melako welewolo. Ngu oni mboolombo yoyingongga, ngundo manggalu ulungga oolengo telo ewolo. Ge Yesus, Anut awuno oolengo ngulo Nangoni! Ge nono ndawuga tewa? No geno solengoyelo, yemboongetenoku, ge no ogingoyingo ma nunowelo! Ewolo. Yesusndo ngu yuka biyomingga nguya kuli, ene ngu oningga ngu yokoya toongenilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ariya, Yesusndo sumoo inolo ewolo. Ge oowoongge ngu ndawuga? Etoni, yuka biyomingga ngundo gumi ewolo. No oowoone Ami ewolo. Ndatelo ngulo, yuka biyomi oowooyingga oolengo, ngu oningga ngu newendemo ulo oolootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ngu yuka biyomi, ngundo mande yanggango oolengo Yesusno sumoo sumoo elo ewolo. Ge noole suleyelootoyi mele goloyi oolengo wenga kini nguno ma uwelo! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ngundilo etoyi, ngu mela puli bodaga namoko, nguno bo oowooyingga nguno so erewelo neloluwonggo. Ene ngundilo kenolo Yesusno solengoyelo sumoo sumoo ewolo. Mete noole bo ngu nowoondoyemo uwato, bine? Etoyi, Yesusndo gumi ewolo. Yo, ye ngundiya teyilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ariya, ngu mbooloku oninggaku yokolo, sodedonangge ene oololo boku nowoondoyemo utoyi, asa, ngu boku yanggango oolengo kendutelo oololo, mela biyomi kembemo solelo sono koongeyingomo ulo sono nelo kumoomukowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ngundilo tetoni, bo sobosobo oniku ngundilo kenolo, sodedonangge endemo salo, ene oo tunootewoku ngu mandega ngu wesiyowolo. Ngu mandega ngu ende ulunggano onino, ko deguno ende bobodikuno onino nguya elo endeyowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ngundilo etoyi, simoo bale ngu ooga ngu kenowelo Yesus tanggeyimo mayelo oni mboolombo yoyingongga ngu kenowolo. Mbooloku ene kuli yokolo peselo satoyi, ene towikumba yemulo ingonduduni nguya himi yetoni, ene nenengo Yesus tanggeyimo bibitelo ooloote. Oni simoo baledo ngundilo kenolo ene soliyokowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Oni Yesus kenootoyi, oni mboolombo yoyingonggano oo tewoku ngulo mandeni, simoo bale ngu kenowelo kootu mayetenggokuno ewolo. Kuli ngu yuka biyomimbo nga oningga nga, dowoolo oluwolo. Ene ataga ngu, ene metemi teteku nga! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Gegesa melasina oni simoo bale bidodo ngu oningga ngu kenolo, ko bo ngulo nguya ingolo, ngulo ene sosoleyingo ulungga telo, Yesusdodo ewonggori. Ge komo noole yoyokoya toonge! Ngundilo etoyi, ngulo Yesus ene sulena oniya wanggo sanganimo oolelo, ene sono koongeyingo gidalesinanggo ko oolouwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","39","Ngu oningga ngu yuka biyomi ngundo yokowonggoku, ngundo Yesusya toongewelo Yesus sumoo sumoo inolo ewolo. No komo geya oolouwelo ewolo. Etoni, Yesusndo suleyolo ewolo. Kini, ge gengo endemo oolouya, Anutndo geno oo tetoni tunootewoku, ngulo mandeni yootunoyalo ewolo. Ngundilo ngulo, ngu oningga ngu ko yowoolengolo oolouwolo. Ene Yesusndo oo tetoni tunootewoku, ngulo mandeni enengo endemo oni simoo bale bidodomo yootunolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesus ko yowoolengolo ombuwolomu ngu, simoo bale ulungga oolengo wendeyi tamako gooboongoolo Yesuslo doongetelo oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Ngu naluno, oni gula oowooyi Yayiras ngu, ene Yuda onilo goobooyingo ya ngulo tabango oluwoku, ngundo Yesus tanggeyimo ombulo, keyi damonimo penggootelo, sumoo sumoo ewolo. Ge komo nolo yano ulo ewolo. Ene ngundilo ewoku ngu ndawugalo, Yayiras ngu namboni gulanangge enengo moomani ngu kande elaya kegidembolo elaya, (12) ene komo kumoowelo namoko tewolo. Asa, Yesus ene Yayirasndo yano oolouwelo ooloutoni, ene simoo bale ulunggakundo oole doongoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nguno bale gula nguya oluwoku, ene kombolo sayi yolo, yambiyootelo, mooma kande elaya kegidembolo elaya (12) oluwolo. Sayi mambu yomosiyoweloyi oni gulado enengo sayiningga ngu yomosiyoyinoweloyi nguya kini. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ngu balega, ngundo Yesus kootusina, kendungomo ombulo, tolige kandedibiyi, Yesusndo nenggulono yewolo. Ngundilo tetoni ngu, sodedonangge enengo dalo soli yetoni, ko ma ombuwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ngundilo tetoni, Yesusndo ewolo. Onendo kandeyi nono yete? Ewolo. Etoni, oni bidodo mande gumi ewonggori. No kini, no kini ewonggori. Etoyi, Pita galodo ewonggori. Oo etuyeloyingo oni, simoo bale ulunggado pawanggelolo ngundo woologogelootenggo. Ndawugalo, ge ngundilo sumoo ete? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ene Yesusndo ewolo. Oni gulado kandeyi nono yetoni, no ingootoowe, yanggangone gidega noyokolo, eneno ooloutelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Asa, ngu balega ngu ingoyingo, ene kombiteweloyi nguya kini. Ngundilo ngulo, ene sosolelo mboolomboolo telo, ene ombulo, Yesus keyi damonimo penggootelo, enengo sayini ngulo damoni wesiyolo simoo bale doongeyemo ewolo. No sayi, ngundilo ngulo, ombulo kandene Yesuslo nenggulono yetenoku ngu, ndawugalo ngulo, no nowoondone hamoo tetoowe, Yesusndo mete yomosinelowa. Ngundilo tetoowe, nenengo sayine sodedonangge kinitetelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ngundilo etoni, Yesusndo gumi ewolo. Nambone, gengo nowoondogemo hamoo teteku, ngulo Anutndo goyeni mete tete. Ngundilo ngulo, ge mete oolouya, nowoondoge imakeyingomo ootoolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesus ngu mande ngu ewoodoni, Yayiraslo yanonggo oni gula ombulo, tabango oninggakuno ewolo. Gengo namboge ngu kuli kumoote. Ge oo etuyeloyingo oni ngu keyi ma ogingoyingolo oolouwelolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesusndo ngu mandega ngu ingolo, tabango oninggakuya ewolo. Ge ma soliyowelo. Ge komo nowoondogemo hamoo teni. Namboge ngu ko mete tewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ariya, Yesus tabango oninggakundo yano oolouwonggori. Yesusndo simoo bale enedodo ya newendemo ma uwelo, elo, ngulo ene oweyelowolo. Yesusndo Pita, Yon, Yems, ko eweyi nemi ngudodo yoyolo, ya newendemo uwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Oni simoo bale ulungga ngu simooyengga ngulo sendo mogulu teloluwonggo. Ngulo ngu, Yesusndo ewolo. Ye ma sendowelolo ewolo. Nga ngu ma kumoowolo. Ene ngu wetolo oolootelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Yesusndo ngundilo etoni, ngulo ene ulungga yumooyinowolo. Ene ingoyingomu ngu hamoo oolengo kumoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ene Yesusndo bale bodaga ngu kandeyi dowoolo, menolo ewolo. Bale buniyo, ge ootookoo! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ariya, ngu bale bodaga ngulo gaboyi ombulo woologongootoni, ene sodedonangge ootookoowolo. Ngundilo tetoni, Yesusndo mande yunolo ewolo. Ye oowali inootoyiga nenilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ngundilo etoni, bale bodaga ngulo eweyi nemi ngundo ulungga oolengo soliyokolo, oni oni tetoli. Ariya, Yesusndo mande yanggango oolengo eweyi nemimo ewolo. Yali ngalo mandeni oni gulano hamoo oolengo ma ewelolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesusndo enengo keyimo sulena oni kande elaya kegidembolo elaya ngu negoyelootoni, ombulo gooboongoowonggori. Ngundilo tetoyi, Yesusndo yuka biyomi ko sayi damoni oowooyingga nguya yomosiyoweloyi yanggango ulungga yunolo sunggi yewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ngundilo soweyelootoni, salo, Anut Oo Bidodo Sembuli Sembunaye, ngundo enengo simoo bale sobowooteku damoni ngulo mandeni ngu elo etuyelolo, ko sayiye nguya yomosiyelootoyi, mete tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Yesusndo enedodo ewolo. Ye sawelo ngu, oo sitowi oowooyingga ma yowelo. Ye usutoko, siyaki, oowali, oo uliyowelo bobeye, towi nenggulo ela elaya ma yowelo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Oni gulado yoyoya, enengo yano utoningga ngu, ye komo ngu yanggano nguno nangge oliyi. Ye ootookoolo saweloyi nalunggano, nguno nangge, ngu yangga ngu yokoya sayi. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ye yoyolo yano ma utoyiga ngu, asa, ye ngu endega ngu yokoya sayi. Yengo keyemo ende ngulo gugukakawu nogolu keyemo damoowoku, ngu enengo endemo nguno ko siyakiyootoyiga uni. Ngundilo tetoni ngu, endemo oni ngu enengo damoniye biyomi ngulo nangge ingondudu telo oluwanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ngundilo etoni ingolo ngu, asa, ene sawonggori. Ene ende bidodomo salo, Anutlo mande gome mesalango ngu wesiyolo elo etuyelolo, sayi oni oowooyingga ende bidodomo yomosiyelootoyi, metemi temukowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Yuda mela ngulo oo bidodo sobowooyingo oni koleteyingo oowooyi Herod, ngundo Yesuslo sulena onindo oo tetenggoku, ngulo mande ingolo, ngulo ingondudu bulibali ingowolo. Ndatelo ngulo, gidalegado Sonoyeloyingo Oni Yondo kumooyingo nga, ko ootookootelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Gidalegado ewonggori. Ilayiya ko ombulo tunootetelo etoyi, gidalegadolo ewonggori. Oni gidalegado etenggo. Anutlo ingondudu eyingo oni gula ko ootookoowo, ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ngundilo ngulo, Herodndo ewolo. Nondo Yon bungeyi toongootoowe kumoowolo. Ngundo binengga ngundilo ko damoni oowooyingga tetoni, ngulo mande etoyi ingooteno, bine? Ewolo. Herod nguya Yesus kenolo ingoweloyimbolo doongetelo sobowoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Aposel oni ko mayelo, Yesusno ko tewonggoku, ngulo mandeni ewonggori. Yesus enengo sulena oni nangge yoyolo, oni simoo bale gidalega yoyokolo enesu nangge, ende gula oowooyi Betsayida ngu tanggeyimo oolouwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ene simoo bale ngundilo yeyolo ingolo, enebana keyelolo oolouwonggori. Ene ngu simoo bale keyelolo mayetenggoku ngu yeyolo, suleye ma kini yewonggori. Kini, ene oni oni telo, Anut Oo Bidodo Sembuli Sembunaye, ngundo simoo bale enengo sobowooteku damoningga, ngulo mande ngu wesiyolo elo etuyelowolo. Gidalega sayidodomu yomosiyelowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ngu sangga ngu suwootetoni, Yesus enengo sulena oni kande elaya kegidembolo elayaga, ngundo Yesusno ombulo ewonggori. Ge simoo bale nga yoyokootooga, enengo endemo sungo sungo saya oowali kenoya neya weleyi. Ndawugalo ngulo, noole ngano kingo melako ngano oolootetoku, nga melako ngano oni kinilo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ene Yesusndo mande gumi ewolo. Yendo nangge oowali yunootoyi newanggo. Ngundilo etoni, enebana ewonggori. Noole oowali kini. Noolengo oomanongoyingo ngu kandegula, ko iso elaya nangge nguya ooloote. Noolendo bine saya oowali uliyoya mayeya nga simoo bale nga bidodo yunootooye, mete newanggo, bine? Ewooto. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Simoo nangge kandangetoyi, 5,000 tewonggori. Ariya, Yesusndo sulena onino ewolo. Ye oolouya oni ngu kandangeyeloya onibi elaya kande elaya, (50), wata oowooyingga bibitetoyiga ngundiya tambuga tambuga bibiteyilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Yesuslo sulena onikundo ngu tetoyi, oni simoo baleku ngundilo bibitemukowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ngundilo telo, oomanangoyingo kandegulagaku, ko iso elayagaku yolo gooboongoolo dowoolo, Sambono randolo doongetelo, Anutno esetelo yokolo, oomanangoyingoku iso elayagaku nguya oososowoowolo. Ngundilo telo, enengo sulena oniku yunootoni, ngundo oni simoo baleku bayetelo yunowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ngundilo tetoyi, oni simoo bale oowali netoyi, useye bakini yemukowonggori. Ene oowali gumgum oodoni ngu gooboongoolo si kande elaya kegidembolo elaya (12) siliyootoyi, manggowoomo oolewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nalu gulano, Yesus enesu nangge sungo ootoolo, ene yemboongelo oluwolo. Enengo sulena onindo nangge tanggeyimo oolouwonggori. Ngu naluno, Yesusndo sulena oniku sumoo yunolo ewonggori. Oni simoo baledo noya ndatelo etenggo. No ndawu oninggalo etenggo? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Sulena onindo gumi ewonggori. Ene ngandilo etenggo. Ge ngu sonoyeloyingo Yon; gidalegado etenggo. Ge Ilayiya; ko gidalegado etenggo. Ge Anutlo ingondudu eyingo oni kulimiku gula ko ootookoowolo etenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yesusndo yowoolengolo, sulena oniya ewonggori. Ene yendo ngu noya ndawu oningga, elo etenggo? Ngundilo etoni, Pitando mande gumi ewolo. Ge ngu Kristus Anutndo noole yoyoweloyi ngulo sunggi yeyingo onilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yesusndo mande yanggango oolengo sulena oninolo ewolo. Ye komo oni gidalegano nga mandega nga ma ewelo elo soleyelowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Nalu gulano, Yesusndo ewolo. Anut Nangoni Oni Kilalongo ene ogingoyingo ulungga oolengo ingowa. Yudalo tabango oni, ko Anutno woolo yeyingo oni kundingiyi ngulo sobosobo oni, ko mamana mande etuyeloyingo oni, ngundo kootu inolo, uleyi kumoowa. Ene nalu kabusa yokolo ko yokutuwootoni ootookoowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ngundilo elo, enengo sulena oni mande gula yunolo ewolo. Oni gula no kenelowelo ngu, ene komo enengo ingonduduni damoni biyomingga ngu komo yokoya meyeya oodoni, ngulo simoo bale nowoondoye hamoo ma teyingo, ngundo kowuli inowanggoku, ngu koolowoowa. Ene komo ngundilo telo, ngu kenelolo endeyowa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Oni gula enengo ingondudunimonggo nangge enengo oo teweloyi ko keda oluweloyi ingooteku ngu, asa, kootusina nalu wengamo, ene oonatewa. Ene oni newende ngu bidodo Anutno yeteku ngu, ngu oningga ngu enengo ingonduduni oololo ombulo teteku, ngu komo yokowa. Ngundilo telo ngu, asa, ene kootusina suwoo suwoo Anutya keda oluwa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Oni gula mela ngalo bobeye oo sitowi nguno ingonduduni bidodo yelo endeyooteku ngu, kootusina, ene Setanlo ende biyomimo oololo oluwaku, nguno ndatelo telo oo ngundo ene hooloowewa? ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Oni gula nolo mandene, ngalo oyumo yowaku ngu, asa, kootusina, no Oni Nangoni nolo dulidaline ko awane ngulo Engel oni kundingiyi ombutetoku naluno, no enengo oyumo yowanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","No hamoo oolengo yeno eteno. Oni nga dikatenggoku nga ngu, gidalega ma kumooyingomo, ene oni oowooyingga oolengo Anutlo nowoondoyemo hamoo teyingo damonimo nguno ulo kenowanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesusndo ngu mandega ngu elo yokolo, oode nalu kandegula gidembolo kabusa yokolo, ene Pita, Yon, Yems, oni kabusaga ngu yoyolo, mela puli gulano awuno, Anutno yemboongewelo oolewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yesus nguno yemboongelo oodoni, enengo omukumundoongo yowoolengolo guladilo oolengo tunootewolo. Enengo towikumbani nguya nomboyi oolengo solu ngundilo yowali oolengo yewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Ngu naluno, Moses, Ilayiya oni elayaga, ngundo Anutlo dulidalinidodo tunootelo Yesusya mandelo ingowoli. Ngu oni elayaga, ngundo kootusina Yerusalem endemo nguno Yesus goweyimo oo tunooteweloyiku ngulo mande mandenilo ingowoli. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita ko enengo dobooguliyi elayagakuya kubooyelootoni, welewelo tewonggori. Ene ma welewolo, Yesuslo moondeyimo oo yowali kenolo, ko oni sungo elayaga ngulomu nguya kenowoli. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ngu oni elayagaku yoyokolo sawelo tetoli, Pitando Yesusno ewolo. Oni ulungga, noole ngano oluweloyi ngu gome. Ge etoyi ngu, noolendo mete tookoododo kabusa yewato. Tookoododo gula gengo, gula Moseslo, gula Ilayiyalo yewatolo ewolo. Ene Pitando ngu ma ingolo ngulo ngundilo mande ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pitando ngu mande ngu ewoodoni, sodedonangge goboole gula ombulo, tabaye sanganimo ombutoni, ngundo ene bidodo doobeyelootoni ngulo ene sosolewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Goboole newendemonggo Anutndo menolo ewolo. Nga nolo nangone nga! Nondo ene sunggi yewonoku ngu! Ye komo enengo manggowo ngu ingoyi! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ene mandeni ngu ingolo yokolo, ene doongetelo Yesus enesu nangge kenootoyi oluwolo. Ene mande gula ma elo, ene nenetelo oluwolo. Ngu naluno nguno, oo kenowonggoku ngu, oni gidalegano ma ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Yangeni ngundilo pulimonggo utoyi, simoo bale oowooyingga oolengo mewoosoolo ombulo Yesus galo ooleko yeyowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","39","Ngu oni simoo bale ulungga ngu kewooloyemonggo, oni gulado solengoyelo ewonggori. Oo etuyeloyingo oni, no geno yemboongeteno. Ge nolo nangone nga keno. No komo nangone gulanangge nga. Oo yuka biyomi gulado ene woologongolo ngundilo dowootoni, ene sodedonangge, kiyelo biyobiyomi telo ooloote. Ngu oo yuka biyomingga, ngundo yanggango oolengo melako wenggelemootoni, ulo sagaga telo nosilili udoni kumootoni manggowoomo koodo nomboyi oolelo ooloote. Ngu oomboolo biyomingga, ngundo ene gome gome utolo goweyi ulungga yombuliyolo ene sodedo ma yokolo toongete. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","No kuli gengo sulena onino etoowe, ene ngu oomboologa ngu owetoyi toongeweloyi, ene ereremo kinilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ngundilo etoni, Yesusndo mande gumi elo ewolo. Ye simoo bale, nga naluno ngano oolootenggoku, ye nowoondoyemo hamoo teyingo ngu kini. Yengo nowoondoye ngu nenengo oolengo kini. Nalu ndatelo no yeya ootoolo yengo kowuliye koolowoolo oluwano? Ewolo. Elo, ene yowoolengolo oninggaku kenolo ewolo. Ge nangongge yoya ombulilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ene nangoni yolo ombuwootoli, ngu oomboolo biyomingga, ngundo simooyenggaku yanggango oolengo wenggelemootoni, melako wetolo sagaga telo yowoolalingolo gome gome ulewolo. Yesusndo kandedisi telo ngu mboologaku, kenolo elo ene simooyenggaku yomosiyolo, yolo eweyi ko inowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","44","Ngu simoo bale, ngu bidodo Anutlo yanggangoni ulungga ngu kenolo, ene ulungga oolengo soliyokowolo. Ngu oo Yesusndo tewoku ngulo, simoo bale ngu kenolo sosolelo, ngulo ingondudu ulungga tewonggori. Ngundilo tetoyi, ene Yesusndo enengo sulena oninolo ewolo. Ye mande nga gome sodeyeya, gome oolengo ingoyi! Nalu bodaga nangge yokolo, Oni Nangoni ngu yolo oni sungo kandeyemo yelo yunowanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Enengo sulena onindo ngu mandega ngu gome ma ingolo, yolo dowoowonggori. Mande ngu damoni kombiteyingo, ene ngulo nowoondoyemo gome ma ingowonggori. Ngulo ene Yesuslo sosolelo ngulo ma sumoo telo ingowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Yesuslo sulena oniku enengo nangge mande elo, onendo sungo bidodo dagayelolo ulungga oluwa? Ewolo. Elo, mande gumgum elo longgeyowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","48","Yesusndo enengo sulena oni nowoondoyemo ngu mandega ngu oodoni kenolo ingolo, ngundilo ngulo, ene simooye bodaga yolo enengo tanggeyimo yelo ewolo. Oni gula ene no oowoonembolo simooye ngandilo gula yolo yomosiyolo yoonenengowaku ngu, ene no hooloowenelolo yomosinelooteku ngundilo. Oni gula no hooloowenelooteku ngu, ene oni no awane sulenelootoni, ngano ombuwonomungga ngu hooloowelo yomosiyoote. Oni gula ye kewooloyemo nguno enengo oowooyi bingami elo ma okoolo, ene Anutlo ko nenengo tewaku ngu, hamoo oolengo, ngu oningga ngu, ene oni gidalega dagayelolo ulungga tewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ngu naluno, Yondo mande gumi ewolo. Oni ulungga, noole oni gula kenootooye, ene ge oowoonggemo oo yuka biyomi oweyelootoni kenowooto. Ene ngu noole ma keyelolo endeyootenggoku, ngulo noolendo ene loogu teyinowootolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ene Yesusndo Yonya ewolo. Ye ene ma loogu teyinowelo. Oni yeya mundiyi kini, ngu oningga ngu yengo dobooyelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yesus ngu Sambo endemo ooleweloyi nalu namoko tetoni ingolo ngulo ene ingonduduni gosiyolo Yerusalem oolouwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Yesusndo oni gidalega suleyelootoni, enengo mandeni yolo oolouwonggori. Ngu oni ngu koletelo Sameriya ngulo ende gulano ulo nguno Yesus oluweloyimbolo oo yomosiyowelo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ene ngu endemo oni, ngundo Yesus yolo, enengo yano oolouwelo yokowolo. Ndatelo ngulo, ene ingoyingo, Yesus ngu ene Yerusalem ooloutelo ingowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Yesuslo sulena oni elaya Yems, Yon elagado enengo damoniye biyomi kenolo sanggili telo ewoliyo. Oo Bidodo Sembuli Sembunaye, ge etooga, Sambononggo de ombuya nga oni nga yodemukoni. Ngundilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","56","Ene Yesusndo yowoolengolo yeyolo mamanayelolo yokootoni, asa, ene ende gulano sawolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Yesusndo enengo sulena oniya yade ooleko ooloutoyi, oni gulado Yesusno ombulo ewolo. Ge ende bidodomo toongeteku ngu no nguya kenggelolo no nguya toongewanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesusndo ngu oningga ngulo mandeni gumi ewolo. Mando ngu, ene mela newendemo tagiyododo, ko nu nguya de sanganimo tagiyododo, ene Onilo Nangoni ngu, ene bibitelo weleweloyi musiyoni nguya kini. Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yesusndo oni gulaya ewolo. Ge ombuya no keneloya oolou! Ewolo. Ene ngu oningga ngundo ewolo. Oo Bidodo Sembuli Sembunaye, ge mete noyokootoyi no oololo awane kumootoni kenolo, melengoologo eme ko ombuwanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesusndo ngulo mande gumi ewolo. Nguno yoko, oni nolo nowoondoyemo hamoo ma teyingo, ngundo ene sobowooya oodega kumootoningga ngu, enengo bingo melengooyi. Ene ge ngu oolouya, Anut Oo Bidodo Sembuli Sembunaye ngundo simoo bale enengo sobowooteku, ngu wesiyoya oni simoo bale etuyelolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Oni gulado ewolo. Oo bidodo Sembuli Sembunaye, no nguya ge kenggelolo endeyowano. Ene gedo mete elo etoyi ngu, asa, no oololo nenengo oni kandeye dowoologolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ngundilo etoni, Yesusndo oningga ngulo mande gumi ewolo. Anutndo oni gula enengo koni logo teweloyim negongootoni nguno oodoni, ene ko gula gulano endeyolo oode ngu, asa, ngu oningga ngundo Anut Oo Bidodo Sembuli Sembunaye, ngundo enengo endega oni simoo sobowooteku, nguno ma uwalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kootusina, Oo Bidodo Sembuli Sembunaye, ngundo oni onibi kabusa kande elaya kegidembolo elaya (72) sunggi enengo ko teweloyim ela elaya suleyelootoni sawonggori. Ngundilo salo ngu, ene ende bobodi, ende ululu ngu bidodomo nguya koletelo satoyi, asa, kootusina Yesus enebana keyelolo toongewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Yesusndo ngu oniku mande yamonggawo gula yunolo ewolo. Oowali kono gome enggemukoote. Ene ko oni oowooyingga kini. Ngundilo ngulo, ye oolouya ko sembuli Anutno yemboongetoyiga, ngundo ene mete ko oni suleyelootoni, oololo, kono oowali engge ngu yolo gooboongoowanggo. Oowali ngu oni simoo bale ene Anutlo mandeni ingowelo ingootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ye oolouyi! Ingoyi! Nondo ye suleyelootoowe, satenggoku ngu, bo Sipsip nangoni imakeyingo damoningga ngundilomu ngu bo goki kewooloyemo suleyelootoowe satenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ye bobeye sili, siyaki, ko keye goweyi nguya ma yowelo. Salo ooleko oni simoo bale yeyolo nguya, mande mande ma ewelo kini ye komo dagayeloya sayi. ");
INSERT INTO rwo_karo_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ye salo ya gula newendemo uya ngu, ngandiya eyi. Nga ya newendemo simoo bale nga Anutnonggo sumange ayibidodo ombuteku ngu yeya oliyilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ene ngu yano nguno oni simoo bale gula ene nowoondoye damoni imakeyingo ngu oodoyi ngu, asa, yendo Anutlo sumange ayibiningga yunootenggoku ngu, oololo ngu oningga nguya oluwa. Ene kinitetoni ngu, yengo sumange ayibiga ngu ko yowoolengolo yengomo ko ombulo oluwa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ye komo ngu ya gulananggega nguno nangge oliyi. Ye enendo oowali sono oo yunootenggoku, ngu nelo oodoyi, nguno yengo ko tetenggoku, ngulo uliyi mete yowanggo. Ye komo ngu yangga nguno nangge wetoya ngunonggo saya ko teyi. ");
INSERT INTO rwo_karo_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ene ende gulano saya utoyiga, ngu endemo oni, ngundo ye yoyoya enengo yano utoyiga nguno oowali yunootoyiga, ngu nangge neyi. ");
INSERT INTO rwo_karo_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ye mete ngu endemo sayi oni yomosiyeloya, ye ngandiya eyi. Anut Oo Bidodo Sembuli Sembunaye, ngundo simoo bale soboyeloweloyi naluni, ngu kuli ye tanggeyemo ombuteku nga, eya eyilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","11","Ye ende gulano ooloutoyiga, ngu oni, ngundo ye ma yoyoya yano uya yoyokootoyiga ngu, asa, ye oolouya, endesoono nguno dikaya ye ngandiya eyi. Yengo ende ngalo gugu nogolu noole kenayimo damoowoku ngu siyakiyootooye, yengo endemo ko uteku nga, eya Anutlo sumbuyi andangeya yunootoyiga olini. Ene ye gome ingondudu teyi! Ndatelo ngulo, Anut Oo Bidodo Sembuli Sembunaye, ngundo nalu enengo simoo bale sobowooteku, ngu kuli namokono ombulo sobowooyelooteku nga! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","No yeno hamoo eteno. Anutndo wilikoyeloweloyi nalu wenga ulunggano, nguno ngu ende gulado Anutlo ko oni ma yoyolo kawararayelolo ngu, asa, ene ngulo ngu naluno kowuli ulungga oolengo yowanggo. Ngu ogingoyingo ulungga ngu Sodom endemo oni damoni biyomi teyingongga ngulo ogingoyingo yowanggoku ngu endemo oni damoni biyomi tewonggoku ngu dagayelolo ogingoyingo ulungga oolengo yowanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ye Korasin ende oni, ye Betsayida ende oni ye gowugowulongo! Tayiya Sayidon ende elaya nguno damoni sungo oolengo gula onindo ma teweloyim ngu, yeno tewonoku ngundilo ngulo tetoowe ngu, ene mete nowoondoye yowoolengootoyi, ngulo solengoyelo, de nombo dabemimo bibitelo oliyingo ngundilo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Hamoo oolengo Anutndo wilikoyeloyingo naluno, yendo kowulingga yoweloyiga ngu, ngu Sayidon Tayiya ende elayaga ngundo kowuli yoweloyi ngu dagayelolo ulungga oolengo yowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ye Kaperniyam endemo oni ngundo yengo oowooye bingamiye okootoyi Sambono oolelo oolootenggo, bine? Hamoo oolengo kini. Ye Anutlo nowoondoyemo hamoo ma teyingo ngulo Anutndo yoyolo de nombono nguno oolongooyelootoni uwanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesusndo enengo sulena onino ewolo. Oni ene ye manggoye ingootenggoku, ngu ene no manggone nguya ingowanggo. Oni ene kootuyunootenggoku ngu, asa, ene no nguya kootu nunoote. Ene no kootu nunooteku ngu, ene Anutndo sulenelootoni ombuwonomu nguya kootu inootelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Enengo ko oni onibi kabusa kande elaya kegidembolo elaya ngundo kono sayingoku ko mayelo oni oni ulungga telo Oo Bidodo Sembuli Sembunaye nguno ewonggori. Ulungga Oo Bidodo Sembuli, noole salo ko telo nguno, gengo oowoongge etooye oo yuka biyomi ngu noolengo manggonayi nguya, gome keyolo sawonggolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesusndo gumi ewolo. Kulimi, no Setan kenootoowe, Sambononggo himi, yowali ngundilo solewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ye ingoyi! Ngu hamoo oolengo! Nondo yanggango ye kuli yunowono. Ngulo ngu, ye sile biyomi, budegoolo dogingoyingo ko oo biyomi gula wongoowanggoku nguno, ko ye longge oni oo biyomi ngulo yanggangoye ngu, ko oo biyomi gulado ye ma yombuliyelowa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Oomboolo biyomimbo yengo manggoye ingolo keyowonggoku ngulo, ye ma oni oni tewelo. Kini, Anutndo yengo weti biyomi ngu andangeyunowokulo ngulo yengo oowooye ngu Sambo endemo kuli nakangoyunowoku, ngulo ye Anutlo oni oni teyilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ngu naluno nguno, Yuka Kundingiyi, ngundo Yesus yeni oni oni telolo ewolo. Awa, ge Sambo ende ngulo, ko mela ngalo nguya oo ngu bidodo sembuli ulungga oolengo ooloote. Ngulo no geno esetelo yemboongeteno. Gedo kuli oo ngu oni ingonduduye mande mandeyedodo onino ngu oongoowolo. Ene ge simooye bobodi nangge tunoo etuyeloote. Yo, Awa gengo ingonduduge ngundilo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Nenengo Awanembo oo bidodo no kandenemo yemukowolo. Oni gulado enengo Nangoni ngulo ma ingootoni ngu, Awa enengombo nangge Nangonimbolo ingoote. Oni gulado Awa ma ingooteku, enengo Nangonimbo nangge Eweyi ingoote. Ene oni ngu Nangonimbo Eweyi etuyelootoni ngu, ene nguya Eweyimbolo damoni ingowanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Yesus enengo sulena oni nangge oodoyi ngusina yowoolengolo ewolo. Oni ene oo yendo kenootenggoku nga, ene nguya ngu kenolo ngu, ene oni oni telo oluwanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","No yeno hamoo eteno. Kulimi, Anutlo ingondudu eyingo oni, ko mela ngalo oo sobosobo oni Koleteyingo nguya ene oo nga kenowelo elo ene ma kenowonggori. Yendo ataga oo kenootenggoku, ngandilo ene ma kenowonggori. Ene nga mandega yendo ingootenggoku nga ingowelo ewonggori. Ene ma ingowonggorilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Nalu gulano, mamana mande etuyeloyingo oninggado Yesus tewoongowelo ewonggori. Oo etuyeloyingo oni, no ndatelo telogo, no suwoo suwoo keda gome oluwano? Ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ngundilo etoni, Yesusndo mande gumi ewolo. Mamana mandeno ngu ndatelo nakangoyingo? Ge ndatelo kandangelo ingoote? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ngu oningga ngundo gumi ewolo. Anut ngu gengo Ulungga Oo Bidodo Sembuli Sembuge. Gengo nowoondoge bidodo, gaboge bidodo, ingonduduge bidodo yanggangongge ngu bidodo ene ino! Gengombolo ingooteku ngundiya nangge oni dobooge tanggegemo oolootenggoku ngulo nguya gome ingolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesusndo ngu oningga nguya ewolo. Ge hamoo nenengo ete. Ge ngundilo nangge telo endeyolo oluwaku ngu, ge keda suwoo suwoo oluwalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ngu mamana mandelo oningga ngu newendemonggo Yesusndo mandega ewoku ngu ingowelo yokolo, enengo ingonduduningga wesiyolo ewelo no oni nenengo elo, ene ngulo sumoo gula ewolo. Oni no tanggenemo oolooteku ngu, oone ngu nolo doboone? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Etoni, ariya, Yesusndo mande yamonggawo gula ngandilo ewolo. Oni gula Yerusalemnonggo Yeriko uwelo uwolo. Ngundilo uwootoni, yakaka oni biyomi, ngundo ooleko kenolo, dowoolo uleyi kumoowelo tetoni yokolo, enengo sitowini udangelo yomukolo satoyi, oninggaku kumoowelo namoko tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ngu naluno, Anutno woolo yeyingo oni gula, oole ngu keyolo ulo, ngu oningga ngu kenolo, ene oole dabemisinanggo tolige tolige ulo dagalo toongewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ngu naluno nangge, yambo yalo sulena oni ngu oolega ngu keyolo uwolo. Ngu oningga ngu kenolo yokolo, ene oole dabemisinanggo dagalo ulo toongewolo. Liwayi ngu Yekob nangoni gula, ngulo sowe. Anutndo ene woolo yeweloyi ngulo oo sulena teweloyi ko yunoyingo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Kootu oolengo Sameriya oni gula, ngu oolega ngu nangge keyolo ombuwolo. Yuda oni ngu Sameriya oni ngu ko goboolo ma tetenggo. Ngundilomu ene Sameriya oningga ngu ombulo, ngu oningga ngu kenolo, nowoondoyi ulungga tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Tanggeyimo ombulo kenolo, Wayin sonoyi ko bo ulumimbo nguya mambuni sonowoolo yomosiyolo Marasinmbo mambuniku gosiyolo yokolo, okoolo, enengo Hos bodaga oowooyi Donki, ngu sanganimo yelo endemo toongelo, nguno ooleko oni mayelo weleweloyi yano ulo, nguno yomosiyolo gome sobowoolo oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Sengetoni, ene toongewelo ootookoolo, sa gulanangge ngulo ko uli bobeye ngu ya sembuligaku inolo ewolo. Ge nga oningga nga gome sobowooya ootoo! Gengo bobeye gula nga oningga ngalo yokowaku ngu, nobana ko ombulo, wendangelo gumi gunowanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ge ndatelo ingoote? Oni kabusa ngu oolega ngu keyolo ombuwonggori. Onendo ngu oningga ogingoyingo biyomi yolo oluwoku, ngulo dobooyi oolengo? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ngundilo elo yokootoni, mamana mande etuyeloyingo oningga ngundo mande gumi ewolo. Ngu oningga ngulo nowoondoyi telo hoolooweyingongga ngulo dobooyilo ewolo. Etoni, Yesusndo gumi ewolo. Ge oolouya, ngundiya, nangge telo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Nalu gula, Yesusndo enengo sulena onidodo, yade yade oololo, ende bodagano tunootewonggori. Nguno bale gula oowooyi Mata, ngundo Yesus galo yoyowelo enengo yano oolouwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mata ngulo koneyo oowooyi Mariya. Mariya ngu ombulo Yesus tanggeyimo bibitelo, mande etoni ngu ingolo oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ene Matando ngu oowali, ko oo ulungga telo, yomosiyoweloyi ngulo oololo ombulo tewolo. Ngundilo telo, nguno Matalo ingonduduni ngu oowali oo ngu yomosiyolo, ngulo ingondudu ulungga tewolo. Ngundilo telo, Matando Yesusno oololo ewolo. Oo Bidodo Sembuli, konegene Mariya ngu ene no noyokootoni, noso nangge oo yomosiyootoowe, ene ngu kingo bibitelo ooloote. Gedo ene suleyootooga, no hoolooweneloni. Ge ngulo ma ingondudu tetelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","42","Yesusndo manggowo gumi ewolo. Mata, Mata, gengo ingonduduge ngu ge oo oowooyinggalo ingondudu bulibali telo, ge ngulo gome ingoote. Ene ge oo gulanangge ngulo ge ma ingoote. Mariyando ngu ene oo gomengga ngulo ingoote. Noole ngu oo gomengga Mariyando ingolo yootekungga, ngu ma woosoolo yoyinowatolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Nalu gulano, Yesus enesu nangge sungo yowoko oololo, nguno yemboongelo oode, yokootoni, kootusina enengo sulena oni gulado ombulo ewonggori. Ulungga Oo Bidodo Sembuli Sembunaye, ge noole nguya yemboongeweloyi damoni ngu etuyelo, Yondo enengo sulena oni etuyeloyingo ngundilolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","4","Ngundilo etoyi, Yesusndo gumi ewolo. Ye yemboongewelo naluno ngu, ye mete ngandiya eyi. Awa, noolendo gengo oowoongge ngu komo kundingiyi olini, ngulo ewelo eteto. Noolendo gengombo nalu oni simoo bale enengo soboyelooteku ngu komo ombuyalini, noole ewelo eteto. Noolengo oowali engge nga nalungga ngalomu, ko nalu bidodomo nguya yunololuwa. Oni gidalegado nooleno mbumbuwa tetenggoku ngulo noole kowuli ngu andangelo kapengo yewato. Ngundilo nangge, mete ye nguya noolengo kowulinayi andangeyunoya kapengo. Gedo oo biyomi noole tewooyeloweloyimbolo, nguno ma yowoosoolo oolouwelolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Yesusndo ko ewolo. Ye kewooloyemo nguno oni gula enengo dobooyibo, suwoo kewooloko oololo ewa. Doboone, ge oomanongoyingo kabusa nunolo ewa. Nolo doboone gula yowokononggo mayetoni, ngulo no oowali gula ene inoweloyi nguya kinilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ya newendemo oningga, ngundo mande gumi ewa. Ge ndatelo ngulo suwoo kewooloko ombulo no yokutuneloote? Yamako kuli goodoowono. No nenengo simoonedodo yabano kuli welewooto. No ootookoolo oo ge gunoweloyi, ereremo kinilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","No yeya eteno. Ene ngu oningga ngu enengo dobooyi oolengo ngulo ma ingolo, ngulo ene ootookoolo oo ma inowa. Ene ngu oningga yemboongelo eriritelo oolooteku ngulo ingolo, ene ootookoolo, oo bidodo eneno kini ngulo ewoku, ngu bidodo yolo inowa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ngu no yeno eteno. Ye Anutlo nowoondoye hamoomonggo oolo wenonolo, ngulo Anutno yemboongetoyigo, enendo oo ye yunowa. Ye oo erewelo ngu, ye oo kenowanggo. Ye oo ereweya ngu Anutno yemboongetoyi, enendo etuyelolo goosooyunowa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Oni bidodo Anutno yemboongelogo oo yootenggo. Oni ene oo erewelo ngu, ene oo kenootenggo. Oni yamako udoni ngu, Anutndo yamako goosooyunoote. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ye kewooloyemo nguno oni gula nangonimbo isolo etoni, ngu eweyimbo yowoolengolo, sile biyomingga yolo, nangoni inowa, bine? Kini. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ene nangonimbo nu mindiyo etoni, eweyimbo yowoolengolo, oo biyomi budegoologa inowa, bine? Kini, ngundilo nguya ma tewa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ariya, ye oni biyomi melako oolootenggoku, ngundo yengo simooye ngu oo gomemu yunootoyi ngu, asa, yengo Awaye Sambono oolooteku nguno yemboongetoyi, enendo enengo Yuka Kundingiyi ngundo oo ulungga oolengo yengo melako onilo damoniye, ngu bidodo dagalo yunowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yesusndo oo yuka biyomi gula manggowo kininggado oni gula yoyingomu owetoni toongetoni, oninggaku manggowo tango yetoni, mande ewolo. Ngundilo tetoni, simoo baledo ngu kenolo, ene soliyokolo ingondudu ulungga tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ene oni gidalegado ewonggori. Ene oo yuka biyomi oweteku, ngu oomboolo tabango ulungga oowooyi Biyelsebab (Setan) ngulo yanggangoni, ngunonggo ko tetelo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Oni gidalegado Yesus tewoongowelolo ewonggo. Sambolo onindo ma teweloyi gula teya etuyelootooga kenowato. Ngundilo kenolo ingowato, ge Anutndo sunggi yewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ene Yesusndo enengo ingonduduye ngu ingolo, ngulo elo ewolo. Ene mela oo sobosobo oni gulanangge ngulo oni simoo bale wesowootoni, wata elaya tetoni ngu, ngundo enengo nangge ebe utolo, ngu oningga ngulo koni ngu biyomi yewa. Ya gulananggemo oni simoongolo gula nowoondoye gulanangge kini wesowootoyi elaya tetoni ngu, ko gula goboolo teweloyi, ene ereremo kini. Asa, nondo Setan yanggangonimbo oomboolo biyomi owewonoku, ngu ngandilo nondo nenengo kone yombuliyowano. Ngu hamoo oolengo ngundilo kini. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ngundilo ngulo, Setando enengo keyimo oni wesowooyelootoni elaya tetoni, ngundo enengo nangge ebe utolo ngu, enengo koni mandeni ngu ndatelo telogo, yanggango oluwa? Ene ereremo kini. Yendo noya etenggo. Nondo Biyelsebab (oowooyi Setan) oowooyimonggo oomboolo gidalega owetelo etenggo. Kini, no Setan yanggangonimonggo oo yuka biyomi ngu ma oweteno. Kini, no Anutlo yanggangonimbo oweteno. No ngulo eteno. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ene nondo Biyelsebab oowooyimo ko ngundo no hooloowenelootoni, oo yuka biyomi gidalega owewanoku ngu, onendo yengo ko goboolo ngu hoolooweyelootoni, ene oo yuka biyomi ngu owetenggo? Ye ngundilo ingootenggoku ngu, asa yengo ko goboolo oo yuka biyomi owetenggoku ngu Setanlo yanggangonimbo nguya tetenggo? Hamoo oolengo kini. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ene Anutlo yanggangoni, ngundo no hooloowenelootoni, ngunonggo no oo yuka biyomi ngu owetoowe ngu, ye ingowanggoku ngu, Anutndo nalungga enengombo sobowooteku, ngu yeno ombulo tunooteteku nga! ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ene oni yanggango gulado (Setan) enengo yani gome sobowoolo, sangga dowoolo oodoni ngu, enengo yanimo oo ngu bidodo gome oolengo oluwa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ene oni gula yanggango oolengo, ngundo mayelo ngu oni yanggangongga nguya ebe utolo, duge, sangga ooni ngu woosoolo yolo ngu, asa, ene mete uleni kumootoni, yanimo ulo, oo sitowi ngulo musiyo, ene watayi ingooteku ngulo wiyokolo, bayetelo dobooguli yunowa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Oni no doboone kini ngu, ene noya mundi tete. Oni ene nolo kone ngulo newende gulanangge kini ngu, asa, ene kingo bulibali telo endeyooteku ngu, ene nolo doboone kini. Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yesusndo mande gula ewolo. Oomboolo biyomi, ngundo oni gula yokolo toongewa. Toongelo mela ariwoole endeyolo yade nguno musiyo ene kengelo oluweloyi musiyo gula ma kenolo ngu, ene ewa. No ko oololo nenengo yangga kuli oluwonoku, nguno ulo oluwanolo ewa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ene ngundilo elo, oololo yanggaku kenootoni, ngu yangga ngu onindo kitikata siyakiyolo yomosiyootoyi, kingo oodoni, gome tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ngundilo telo, ene oololo oomboolo kandegula gidembolo elaya nguya yoyolo, ngu yanggano nguno ombuwonggori. Enengo yanggangoye ngu koleteloga ngu dagalo biyomi oolengo. Ene ngu oningga ngu koletelo bodaga biyomiyi oluwolo. Ene ataga ngu, ene biyomi oolengo telo oolootelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesusndo ngu mandega ngu etoni, simoo bale oowooyingga oolengo oluwonggori. Nguno bale gula ngu oni ngu kewooloyemo oluwoku, ngundo meno elo ewolo. Ngu balega ge yomoonggelolo nono gunoyingongga, ngundo enesu nangge kumana ulungga tewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ene Yesusndo mande gumi ewolo. Yo, ngundilo oni ngu, ene mande ingolo, nowoondoyemo hamoo telo, Anutlo mande ngu gome yolo dowoolo, keyootenggoku ngulo ene oni oni ulungga tewanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Oni simoo bale ulungga mayelo gooboongootoyi, Yesusndo mande yunolo ewolo. Nga naluno oni simoo bale nga biyobiyomi. Ene damoni sungo oolengo onindo ma teweloyim kenowelo etenggo. Ene nondo ngu ooga ngu gula telo ma etuyelowano. Yonando mande oo teyingo ngu nangge etuyelowano. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kulimi, Yona ngu Anutlo sunggi ngundilo telo, Niniwa oni simoo bale etuyelowolo. Ngundilo nangge, Anut Nangoni Oni Kilalongo nguya Anutlo sunggi ngundilo, ataga nga oni simoo bale nga etuyeloote. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Kootusina, Anutndo simoo bale wilikoyeloweloyi naluno nguno, mela ngalo oo sobosobo bale koleteyingo gula yowoko oolengomonggo, nga naluno simoo bale nga kondibo ootookoolo; enengo damoniye biyomi ngu yootunoyelowa. Ndatelo ngulo, ngu balega mela wengamo oo bidodo sobosoboga, ngundo ombulo, Solomonlo ingonduduni gome ngu etoni ingowolo. Ene ataga nga oningga nga oolooteku, ngando Solomonlo ingoyingoni ngu dagalo oolooteku nga! Bale sobosobo koleteyingongga, ngundo Solomonlo mandeni gome ingootoni, ene ye simoo bale ngano oolootenggoku, ngu nolo mandene ingowelo yokootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Anutndo simoo bale wilikoweloyi naluno nguno, Niniwa oni nguya nga naluno oni simoo bale ngaya ootookoolo, enengo damoniye biyomi ngu ewanggo. Ndatelo ngulo, Niniwa oni ngu Yonalo mandeni ingolo, ene nowoondoye yowoolengootoni, ene hamoo Anutlo ingowolo. Ene ataga nga oningga oolooteku, ngando ngu Yona dagate. (Yesus enengombolo eyingo). Ene ye oni simoo bale ataga oolootenggoku ngu nolo mande ma ingolo nowoondoye ngu ma yowoolengootelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Oni gulado solu (Lam) kalo yolo ya kosingeyimo ngundi kumbe oo gula newendemo ma oongoowa. Kini, oni solu kalo ngu, ene tunoo oolengo mindingootoyi, oni ya newendemo utenggoku, ngu nguya solu ngu gome kenowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Doongengge ngu gowege solu ngundilo. Gengo doongengge ngu gome metemi, ngundo gengo gowege moondege ngu bidodo yeni soludodo tete. Ene gengo doongengge ngu biyomi yetoni ngu, ngu gowege moondege ngu oolelidodo telo oluwa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ngulo ngu, ge ingondale te! Gengo solungga nowoondogemo oolooteku ngu gome sobowoolo. Kinitetoni ngu, gengo solungga ngu ooleli tewa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Asa, gengo gowege ngu bidodo himi oodoni ngu, asa, gumisina ooleli kini. Gengo gowege moondege ngu bidodo himi, ngu solu (Lam) himi ngundilo oluwalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesusndo mande ngu elo yokootoni, Parisi oni gulado Yesus enedodo oowali neweloyimbolo negongowolo. Ngundilo tetoni, Yesus ene ngu Parisi oningga, ngundo yano ulo oo neweloyi yabano bibitewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Bibitelo oo netoni, Parisi oningga ngundo Yesus kenootoni ngu, ene kandeyi ma sonowoolo ngundo oo dowoolo netoni, ngulo ene ingondudu ulungga tewolo. (Moseslo mamana mandeno eteku ngu ma keyootoni ngulo gome gome kenowolo.) ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Yesus Oo Bidodo Sembuli, ngundo ngu Parisi oningga ngulo ingonduduni ingolo ewolo. Ye Parisi oni ngu koondo toba ngu goweyi nangge sonowoolo yomosiyootenggo. Ene yengo nowoondoye ngu yakaka, ko, damoni biyomi, ngundo nangge hangelo ooloote. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ye wenonoyingo oni! Anutndo ene oo goweyi sangani nangge bine yelo, ene newendedodo nguya ma yeyingo, bine? ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ene Anutndo nowoondoye yomosiyooteku ngu, ngulo ye nguya oni gula nowoondoye yunoya hooloowe. Onindo ngundilo kenolo ngu, ene ingowanggo. Gengo nowoondoge ngu gome nomboyi. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ene ye Parisi oni, ye ingondale teyi! Ye ngu oo sookiyagoolo, suwe oo bidodo kono oolooteku, ngu kewoolo wesowoolo kande elaya ngulomu gula Anut inootenggo. Ene ye mande damoni gome nenengo ngu dagalo yokolo, nowoondoye Anut inoweloyi damoni ngu yokootenggo. Ye oo ngu yunoweloyi damoningga ngu mete tetenggo. Ene ye nowoondoye bidodo oolengo Anut inoweloyi damoningga ngu ma yokowelo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ye Parisi oni, ye gowugowulongo ye ingondale teyi! Yengo yambo yano ye koletelo oni doongeyemo bibitewelo gome ingootenggo. Ye oowali uliyoweloyi musiyomo, simoo baledo yeyoya bingaminayi eya okooyi elo gome ingootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ye ingondale teyi! Yengo nowoondoye ngu oni mele goloongelo uteku musiyo ngundilo. Mele sanganimo ngu so uyi nakango oo gomemu ooloote. Ene mele newendemo ngu buwoo biyomi telo, ndindingo biyomi oolootelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ngundilo etoni, mamana mande etuyeloyingo oni gulado Yesuslo mande gumilo ewolo. Oo etuyeloyingo oni, ge ngu mandega ngu nooledodo mande kootunayisina elo yimitoolo eteku ngu! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesusndo mande gumi ewolo. Ye mamana mande etuyeloyingo oni, ye ingondale teyi! Yendo mamana mande ulungga oolengo oni simoo bale yunootenggoku, ngulo ene oo kowuli ulungga oolengo ene koolowooweloyi ereremo kini. Ene yendo kandedibiye bodaga nguno yelo boda ma hoolooweyelolo kowuli ngu ma koolowootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ye ingondale teyi! Yengo osi sambayebo Anutlo ingondudu eyingo oni, gidalega kingo yuleyi kumoowonggori. Ene yengo damoniye ngu osisambaye damoniye ngundilo. Ngulo ngu, ye meleye ngu nakayelootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ngulo ngu, ye nguya enedodo damoniye gulanangge. Ngulo ye osisambaye mande damoniye biyomi ngulo etenggo. Yengo nowoondoye ngu damoningga teyingongga ngulo gome ingootenggo. Ene Anutlo ingondudu eyingo oni yuleyi kumoowonggori. Ye ngulo meleye komoongolo nakangootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ngulo ngu, Anutlo ingonduduni gomemo ene kuli elo ewolo. Nondo nolo ingondudu eyingo oni, ko nenengo sulena kilalongo oni suleyelootoowe, eneno oolouwanggo. Enendo ngu yutolo, mandeye biyomi elo yumooyunolo, gidalega yuleyi kumoomukowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Ngulo ngu naluno, oni simoo bale nga osisambayebolo kowuliye yowanggo. Ene kuli Anutlo ingondudu eyingo oni yulewonggoku ombulo, nga naluno ngano nguya yulootenggo. Kulimi, Ebel uleyi kumooyingo, ngunonggo yade yade ombulo Sekarayiya nguya ulewolo. Sekarayiya ngu Tempel, yambo ya newendemo Anutno woolo yeyingo musiyomo uleyi kumoowolo. Ngulo kowuli ngu, ataga nga oni simoo bale oolootenggoku ngano, ngulo kowulini weti gumi ngu bidodo ataga yowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ye mamana mande etuyeloyingo oni, ye ingondale teyi! Yendo Anutlo hamoo mande ngu oni bidodo ingoweloyingga ngu oongootenggo. Yengombo ngu ma keyolo ngulo ye oni gidalegado ingolo keyoweloyinggaku nguya oole goodooyunootenggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ngundilo elo yokolo, Yesus ngu yangga ngu yokolo, ene endesina ooletoni, mamana mande etuyeloyingo oniya, Parisi onidodo ngu mandega ngulo nowoondoye biyomi oolengo ingolo oluwonggo. Ngu naluno, ene damoni yelo Yesus uleyi kumooweloyi ngulo suwoo suwoo oole erewelo oo bidodo Yesus sumoo sumoo inolo oluwonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ene ngundilo telo, Yesus kenondadangelo sobowoolo endeyolo oluwonggo. Yesusndo mande biyomi guladilo gula manggowoomonggo etoni ngu, ingolo, ene ngunonggo dowoolo mande elo uleyi kumooweloyimbolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Nalu gulano, oni simoo bale ulungga oolengo, ende ende bidodo mayelo gooboongoolo, ebelolo telo ombuwolo. Yesusndo ootookoolo enengo sulena oni mande yunolo ewolo. Ye Parisi onilo ebe ganagana mande ngulo ingondale teyi! Ene oni doongeyemo ngu oni damoni nenengo keyootenggoku ngundilo tewanggoku, nguno ngu ebe ganagana tetenggo. Kootusina, ngu damoni elayaga tetenggoku, ngu endesina tunootewa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Oo bidodo imangoolo wiliyootoni oolooteku ngu, kootusina, ngu tunoo temukowa. Oo doobengootoni oolooteku ngu, kootusina, doobe wesiyootoni tunootetoni, oni nguya kenolo ingowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ngundilo ngulo, mande bidodo suwoo oolelikono ewonggoku ngu, oni simoo baledo sano tunoo elo ingowanggo. Mande bidodo yendo ya newendemo tolige kisikoso telo ingowonggoku ngu, onindo ende kewooloko dikalo, ngunonggo wesiyolo meno manggalu telo ewanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Yesus mande gula ewolo. Ye nolo dobooguline, nondo yeno ngandilo eteno. Ye onindo goweyega nga uleyi kumootekungga ngulo ma sosolewelo. Ndatelo ngulo, ene kootusina, oo gula yeno teweloyi, ereremo kini. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Oni ye ngulo sosoleweloyi ngu etuyelowano. Ye komo Anutlo sosoleyi, ngundo oni uleyi kumoowa. Kootusina, ene yanggangonidodo, ngundo oni yolo, de nombo ma kumooteku nguno oolongooni uwa. Yo, no yeno eteno. Ye komo Anutlo nangge sosoleyi. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ye ingoyi! Nu sibe bobodi kandegula ngu uliyi bodaga nangge (2 Toya 2 Toya). Ene Anutndo nu bobodi ngundilo ngu ma kapengo yewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Anutndo ye tabaye uyi ngu bidodo kandangemukoote. Ye ngulo ma sosolewelo. Anutndo nu bobodi ngulo ingolo sobowoolo oo yunooteku ngu, asa, ye ingootenggoku, ene ye nguya gome soboyelowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Yesusndo ewolo. No mande gula nguya yeno eteno. Oni gulado simoo bale doongeyemo no oowoone yootunolo ewaku ngu, no Onilo Nangoni nguya ngu oningga ngulo oowooyi Anutlo Engel onino yootunolo ewano. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ene oni gula simoo bale doongeyemo, noya mande biyomi elo, no kootu nunowaku ngu, no nguya Anutlo oni Engel doongeyemo enedodo mande biyomi elo kootu inowano. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Oni gulado no Onilo Nangoni yomooyinolo mandega ewoku, ngu andangeweloyimbolo yemboongewaku ngu, asa, Anutndo ngu oningga ngulo mbumbuwani andangeyinowa. Ene oni gula Yuka Kundingiyi yumooyinolo mandega ewaku ngu, Anutndo ngu oningga ngulo mbumbuwani hamoo oolengo ngu ma andangeyinowa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","12","Ene oni gidalega ye yoyolo yambo ya newendemo yoyelo, ngundi, Gabman oni doongeyemo yoyelo, ngunonggo yoyolo oni oowooyedodomu nguno nguya yoyewanggoku ngu, asa, ye ma sosolelo ngandilo ma ingowelo. Noole ndatelo mandega elo nguno enengo mande ngu wongoowe utoni sawato? Noole mande ndatelo ewato? Elo, ma ingowelo ewolo. Yuka Kundingiyimbo ngu naluno nguno nangge, ye mande eweloyi ngu ingonduduyemo tunootetoni, ye ngu yolo eneno ewanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Nalu gulano, ngu oni simoo bale ulungga kewooloyemonggo oni gulado Yesusno elo ewolo. Oo etuyeloyingo oni, no ngandilo ingooteno. Gedo banemo etooga noolengo awanarimbolo oo sitowiku wesowooya gumi gidale no nunonilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ngundilo etoni, Yesusndo ngu oningga nguya ewolo. Onendo no sunggayetoni, no yengo oo wilikolo ngu wesowoolo bayetelo, ye yunoweloyi tabango noyewo? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ngundilo telo, Yesusndo simoo bale bidodomo ewolo. Ye ingondale teyi! Ye oo sitowi ulungga yowelo ko oo gidalegalo nguya doongeye ma ulu tewelo. Anutndo keda oluweloyiga ngu yunoote. Oo sitowi ngundo keda oluweloyi ngu uliyoweloyi, ereremo kini. Kini, oo sitowi ngu gowenayi nga hoolooweyeloyimbolo nangge yunoote. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Yesusndo mande yamonggawo gulalo ewolo. Sitowidodo oni gulalo konimo oo ulungga enggemukowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ngu sitowidodo oningga ngundo newendemonggo ingondudu telo ewa. No ndatelo tewano? Oowaline nga yeweloyi yane nguya kini. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ngu oningga ngundo enengo ingonduduno ingolo ewolo. Yo, no nenengo oowalilo ya nga toongoolo ya ululumu nangge yelo, nguno oowali bidodo yolo, nguno wata yewano. Nggile ko nenengo oo gome gome ngu yano nguno yetoowe oluwa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","No ataga mete elo ingondudunemo ingowano. Nenengo oo gome gome ulungga oolooteku, ngalo ngu mooma oowooyingga oolengo yolo netoowe, ma kini tewa. No yolo nelo, sonoyi nguya yolo nelo, kengelolo, oni oni telo, oluwanolo ingowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ene Anutndo kenolo enedodo ewolo. Ge wenonoyingo oni! Ataga suwoono ge kumoowa. Ngundilo tetoyi, gengo oo yomosiyolo yewoku ngu onendo yowa? Anutndo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Oo ngundilo yeno nguya tunootewa. Oni ene oo sitowi ulungga yolo enengo wata yetenggoku ngu, ene Anut nowoondoyemo hamoo teyingongga ngu kini. Anut doongeyimo ngu, ene owoolongo oolengo yetenggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yesusndo ngundilo elo, enengo sulena onikunolo ewolo. Ngundilo ngulo, no yeno eteno. Ye goweyebolo oo ngulo ye ma ingondudu ulungga tewelo. Noole ndawuga newato? Ngundi noole ndawuga kuduwoowato? Ngundilo elo, ye goweye ngalo ma ingondudu ulungga tewelo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kedaga Anutndo yunoyingo ngu ulungga oolengo. Ngu oowali ngundi towikumba oo ngulo ingootenggoku ngu oo bobodi nangge. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ye nu yeyoya ingoyi. Ene ko telo oowali ma imitenggo. Ene oowali engge ma yolo gooboongoolo wata yetenggo. Ene Anutndo suwoo suwoo oowali oo yunolo muwooyeloote. Ye oni simoo bale ngando Anut doongeyimo ngu, nu oo ngu dagayelootenggo! Anutndo kuli watayi, ye towikumba, oo neweloyi, ya weleweloyi oo ngu yunowelo ingoote. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ye kewooloyemo nguno oni gulado enengo ingondudu telo, enengo keda oluweloyi ngulo nalu, ene mete suleyowa, bine? Kini, ye ereremo kini. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ngulo ngu, yendo oo bobodi ngundilo ngu ma tetenggoku, ndawugalo ye gidalegado ngundilo ingondudu ulungga tetenggo? ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ye so uyi nakango nga yeyoya ingoyi. Ene yaki koyi telo towikumba ma tetenggo. Ngulo, no yeno eteno. Ye oolo ma ingondudu telo, ma hahangewelo. Kulimi Solomon ngu, ene towikumbani gome mesalango ngu bidodo tewolo. Ene ataga nga oo naka kenootenggoku, enengo so uyi nakango ngu Solomonlo ngu dagate. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Yo, ulu so oo kono ooletenggoku ngu, ataga nangge oolelo dikatenggo. Yangeni ngu gumoolo de nombono oolongootoyi dewa. Kingo so ulu ngundilo ngu, Anutndo ngu gome nakangoyeloote. Ngundilo ngulo, ye komo gome ingoyi! Ye simoo bale yengo nowoondoyemo hamoo teyingo ngu bodaga nangge. Anutndo yengo nowoondoyi ulungga oolengo telo gome soboyeloote. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ngundilo ngulo, ye ndawuga ko sonongga neweloyi ngundilo ingondudu ulungga ma tewelo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Oni ende ende ngu, ene oo ngalo erewetenggo. Ene yengo Awaye Sambono oolootekungga, ngundo ngu yengo oo ngulo ingootenggoku ngu, oo ngu enendo hoolooweyelootoni yowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ene ye Anutlo nowoondoyemo hamoo teyingo nguno nowoondoye yelo, ngunonggo dobooguliye nguya mande nguno hoolooweyelolo elo yunolo ngu, asa, Anutndo oo sungo nguno hoolooweyelowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ye nolo nowoondoye hamoo teyingo oni wata bodaga nangge, ye ma sosolewelo. Yengo awayembo ene kuli enengo endega enengo simoo bale sobowooteku, ngu yunowelo yomosiyowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Yengo oo bidodo oni yunootoyiga uliyoyi, ngulo bobeye ngu yoya, owoolongo oni oolo wenonootenggoku, ngu hoolooweyeloya yunoyi. Ngu damoni gomengga melako ngano tetenggoku ngu, Sambo endemo ngu duwoo ma yokowa. Sambo endemo yakaka onindo oo gomemu ma yowanggo. Nguno kookoose ma tetoni, toowumbo nguya ngu ma netoni biyomi yewa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Yengo oo gome oolooteku musiyongga nguno, yengo nowoondoye nguya nguno yetoyi oluwa. Ye oo gome gome ngano oolooteku, ngulo hahangelo ingolo ngu, asa, nowoondoye ngu bidodo nguno domoolo oluwa. Ngundilo nguya ye Anutlo ko tewelo ngulo hahangelo ingootenggoku ngu, asa, yengo nowoondoyemo ngu bidodo Sambono oluwanggo. Yo, hamoo, Anutndo Sambo endemo musiyo metemi nguno noolengo oo gome yoonenengootoni oolootelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Ye oo yomosiyoya doongedoongoodoongoo teya noolengo Sembunaye ulungga ngu sobowooya oodoyi, ene ombulo ko yoyoweloyi, ngu ko onindo enengo sobosobo oni ulungga sobowootenggoku ngundilo. Ene towikumba ingondale telo, yemulo, wanggayemo utombo gome gosiyolo, enengo solu kalo dowoolo oolootenggo. Ngundilo telo, oodoyi, enengo oni ulunggaku bale kameyoweloyi oo simbo ngu kinitetoni suwoo kewooloko ombulo, enengo ko onikuno yamako udoni, ya goosootoyi, nguno yeyootoni, doongedoongoodoongoo telo ootoolo, ngulo ene sodedonangge yamako goosooyinootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Oni ulungga ngu ombulo, enengo sulena oniku yeyootoni, ma weleyingo doongetelo oodoyi yeyolo ngu, sulena oni ngu, ene oni oni tewanggo. No hamoo oolengo yeno eteno. Sulena oni enengombo kumba yemulo kimbonambo wanggaye gosiyolo, ya sembulibo sobowoolo oodoni, ombulo oo neweloyi yabano bibitetoyi, enengombo oowali yunowa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ngu oni ulunggaku suwoo kewoolo oolengomo ombuwa, bine, ngundi, sengeweloyi telo, nu kootoori koletelo etoni nguno, bine, ombulo, enengo sulena oni yeyootoni, ma welewolo. Ngulo ngu, sulena oni ngu, ene mete oni oni tewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ye nga mande oo nga gome ingoyi! Ya sembuli ngu, ene yakaka oni ombuweloyi naluwo ingolo, ene ngulo doongedoongoodoongoo telo oluwa. Ndatelo ngulo, yakaka oni enengo yano ma ombuwelo elo ngulo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ye komo ngulo suwoo suwoo doongeteya, doongedoongoodoongoo teya oliyi! Onilo Nangoni ngu nalu gulano ombuweloyi ngu, ye ma ingootoyi nguno ene ko ombuwalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pitando ewolo. Ulungga oo bidodo Sembuli Sembunaye, ge ngu mande yamonggawongga ngu nooledodo nangge ete, bine; ngundi simoo bale bidodo ete? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Etoni, Ulungga oo bidodo Sembuli Yesus, ngundo mande gumi ewolo. Oone ngu newende gome sobosobo ootoolo enengo ko gome tete? Enengo oni ulungga, ngundo ngu oningga ngu yetoni, ngundo enengo ko oni ngu soboyelolo, nalu nenengo oolengo looguyimo ingolo oowali yunowa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kootusina, oni ulunggaku ko yowoolengolo ombulo, ngu ko sobosobogaku kenootoni, ko kuli teloluwoku ngundilo telo oodoni kenolo ngu, asa, ngu sobosobo oninggaku ngu, ene oni oni ulungga teyinowa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Hamoo oolengo no yeno eteno. Oni ulungga, ngundo ko oni gome ngundilo kenolo, asa, enengo bobeye sitowi bidodo ngu sobosobo oningga ngu kandeyimo yetoni ngundo gome sobowoowa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ene ngu ko oningga ngulo ingondudunimonggo ingowaku ngu, nenengo oni ulungga ngu sodedo ma ombuwalo ingolo, ngulo ene damoni yelo, ko oni simoo baleku yutolo, ene sono kowoo nelo, ngundo yeni wenonolo oluwa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ene ngundilo telo ngu, enengo oni ulungga ngu ma sobowoolo oodoni, nalu gulano, enengo oni ulunggaku ko ombulo ngu, ko sobosobo oninggaku gome gome utolo yombuliyolo yolo oni enedodo ko gome ma sobowoolo oolootenggoku nguno yetoni oluwa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ko sobosobo oninggakundo enengo oni ulungga ngulo ingonduduni koni damoni ngu gome oolengo ingooteku ngu, ene oo ma yomosiyolo enengo oni ulungga ngulo ingonduduni ma keyowolo. Ngundilo ngulo, enengo oni ulungga, ngundo gome gome utolo, uleni biyomi yewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ene ko sobosobo oningga ngu, enengo oni ulungga ngulo ingonduduni ngu, ene ma ingolo, ngundilo ko biyomi telo, ngulo enengombo kowuli bodaga ngu yowa. Oni ene oo oowooyingga yowoku ngu, ene ngundilo nangge gumi oowooyingga wendangelo hoolooweyelowa. Simoo baledo oo ulungga oni gula kandeyimo yetoyi, gome sobowoowaku ngu, asa, ingootenggoku ngu oningga ngu, ene mete ko oo ulungga oolengo telo ngu gome sobowoowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","No de kawelo melako ngano ombuwono. Nolo nowoondonemo ngu de solu delo sodedo denilo gome ingooteno. (Ene Anutlo mande keda gome mesalango ngulo ewolo.) ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ene koletelo no onilo mbumbuwalo de mombi koolowoolo ogingoyingo ingolo kumoowano. Kumoowelo, ngulo nowoondone kowuli oolengo yetoni, ene ngu ma tunootewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ye bine ngandilo ingootenggo? No melako ngano ombuwonomu ngu, imakeyingo damoni ngu yunowelo elo ma ombuwono. Kini, no yeno eteno. No mela ngano oni simoo bale wesowooyelowelo ombuwono. Gidalega Anutno nowoondoye hamoo tetoyi, gidalega nowoondoye hamoo ma tewonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ataga nga naluno ngano, nga wesowooyeloweloyi damoni nga, ngu ngandilo. Oni gidalega nolo nowoondoyemo hamoo teweloyi ngulo ataga ko kootusina, oni simoongolo kandegula ya gulananggemo oodoyi, oni kabusa, ngundo oni elayaga nguya elo boguwootoyi, ko oni elayaga ngundo kabusayi nguya boguwoolo longgeyolo sungo sungo oluwanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Eweyimbo nangonimboya sanggili tetoni, nangonimbo eweyimboya sanggili tewa. Nemimbo nambonimboya sanggili tetoni, nambonimbo nemimboya sanggili tewa. Oni gula baleyibo, neboyiboya sanggili tetoni, ko nangoni baleyi enebana ootookoolo neboyiboya sanggili tewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesusndo simoo baleno elo ewolo. Ye Sambono goboole sa utekusina kenolo sodedo ingootenggo, sono ombuwalo ingootenggo. Ngundilo ingootoyi ngu, hamoo oolengo sono ombute. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Sono medugu nalu kinitetoni, doogo ulungga mayetoni ngu, ye ingolo etenggo. Sa gookingo ulungga tewalo etoyi, ngundilo nangge tete. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ye ebe ganagana oni! Ye mela ngalo nalu sunggi oo ko samboga awelo nalu sunggi, oo ngu gome kenolo ingootenggo. Ene ndawugalo ngulo, ye nalu ngalo oo nga gome ma wilikolo kenolo ingootenggo? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ndawugalo yengombo ingondudu gome ma telo, ngunonggo damoni nenengo ngu wilikootenggo? ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ye oni gulado yoyolo mande wilikoyingo onino ooloutoningga ngu, asa, ooleko nguno yengo nangge mande sodedonangge yomosiyoyi. Kinitetoni, enendo ye yoyolo mande wilikoyingo oni ulungga ngu kandeyemo yoyetoni, ngu oningga ngu enebana yoyolo, kumba ootuwoo oni kandeyemo yoyetoyi, enendo yoyolo, oololo ya biyomimo yoyewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","No ye eteno! Ye ya biyomi ngu sodedo ma yokolo sawanggo! Ye komo koletelo yengo weti ululu ko weti bobodi ngu bidodo wendangemukoya yokoyi! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ngu nalunggano nguno, oni gidalega Yesusno mayelo ewonggori. Galili oni gidalegado woolo yewelo yetoyi, ngu naluno, Rom Gabman tabango oni oowooyi Payilat, ngundo ombulo, woolo yeyingo oniku gidale yutolo, ngulo daloye nguya wendoni melako uwonggori. Ngulo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesusndo enengo mande gumi ewolo. Ye ndatelo ingootenggo? Ngu Galili oni ngulo damoniye biyomi ngu, Galili oni gidalega dagayelolo, ngulo ene mbumbuwa ulungga telo ngulo kumootenggo, bine? ");
INSERT INTO rwo_karo_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ngundilo ingonduduga ngu nenengo kini. No yeno hamoo nenengo eteno. Ye bidodo nowoondoye hamoo oolengo ma yowoolengowanggoku ngu, ye bidodo ngundilo nangge hamoo oonatewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Kulimi ngu, oni kande elaya kengga gidembolo kabusa (18) ngu Sayilom endemo nguno ya pelungga dookelo, ngundo yuleni kumoowonggori. Ngulo ye ndatelo ingootenggo? Enengo mbumbuwaye, ngundo Yerusalem oni oolootenggoku, ngulo weti ngu dagayelolo, ene kumooyingo, bine? ");
INSERT INTO rwo_karo_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ngundilo ingonduduga nguya metemi kini. No yeno hamoo oolengo eteno. Ye nowoondoyemo hamoo oolengo ma yowoolengolo ngu, asa, ye nguya bidodo ngundilo oonatewanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yesusndo mande yamonggawo gula elo ewolo. Oni gulado enengo kono de gula imiwolo. Kootusina, engge yowelo ombulo kenowoku, ngu engge kini. ");
INSERT INTO rwo_karo_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ngundilo kenolo, ngu kongga ngulo sobosobono ewolo. Ingo. Mooma kabusa (3) no nga dega nga engge ombulo kenootoowe, engge kini tewolo. Ngundilo ngulo, ge doongooya oolongooga uni. Oode, ngundo ko ngalo mela ulumi kingo yeni kinitewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ko oninggakundo mande gumilo ewolo. Oni ulungga, nguno yokootooga, nga moomangga nguya kono dikaya olini. Nondo damonimo mela ngu komoongolo nguno bulmakau boga, ngulo use yolo mayelo yewano. ");
INSERT INTO rwo_karo_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Anduno, moomanggano nguno enggetoni ngu, asa, ngu gome. Nguno ma enggetoningga ngu, ariya, ge mete doongoolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Kengeyingo naluno, Yesusndo Yuda onilo yambo ya gulano oni simoo bale mande yunolo etuyelowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Bale gula nguno oluwolo. Ngu balega ngu oomboolobo toobuli wembuyimo woologongolo oluwolo. Ene nenengo randolo nguya ma endeyowolo. Kini, ene penggo penggo nangge telo endeyolo oluwolo. Ngulo moomani ngu (18) kande elaya kengga ke gidembolo kabusa, oomboolo ngundo yeni biyomi yewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesusndo balega ngu kenolo negongootoni, tanggeyimo ombutoni ewolo. Ge nga balega nga gengo sayingge kinitete. Oo yuka biyomi peseya sayilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ngundilo telo, Yesusndo kandeyi ngu balega ngu tabangomo yetoni, ngu balega ngu sodedonangge ootookoolo, nenengo oolengo dikalo, Anutlo bingami ulungga oolengo elo okoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Yuda onilo yambo ya, ngulo tabango, ngundo Yesusya sanggili telo, oni simoo baleno ewolo. Ko teweloyi nalu ngu kandegula gidembolo gulanangge, (6) yengo sayiye goweyemo ngu onindo yomosiyoyi, elo ngu ye ko teweloyi naluno mayeyi. Ye ngu oo ngu yolo, Sabat naluno ma mayewelolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ulungga Oo Bidodo Sembuli Sembunaye, Yesus, ngundo mandeni gumi ewolo. Ye nowoondoye ebe ganagana oni! Yengombo ngu kengeyingo naluno, bulmakau bo donki yoyolo salo, sono yunootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ene nga balega nga, ngu Ebarahamlo sowe. Setando mooma kande elaya kengga kegidembolo kabusa, gosiyolo oluwolo. Ngundilo ngulo, Sabatno, no ngu utongga ene gosiyoyingongga, ngu wesiyooteno. Ngundilo damoningga ngu metemilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesusndo ngundilo etoni ngu, enengo longge oniku oyumo yelowonggori. Simoo bale bidodo Yesusndo ngu oo amana onindo ma teweloyim ngu tetoni kenolo, ngulo ene oni oni ulungga oolengo tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ariya, Yesusndo ko ewolo. Anut Oo Bidodo Sembuli Sembunaye ngundo simoo bale enengo sobowooteku, ngu ndawuga ngundilo? Nondo ndawuga bungomo etoowe ngu mete ingowanggo? ");
INSERT INTO rwo_karo_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ngu ngandilo. Oowali yuwooyi gula oowooyi Mastet. Ngulo tanggooli ngu bobodi oolengo. Ngu oni gulado yuwooyi yolo enengo kono imitoni, kootusina oolelo, de ulungga ke kambinidodo tetoni, numbo nguno mayelo bibitelo nguno tagiyo telo mindiyo yomoowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesusndo ko ewolo. Anut Oo Bidodo Sembuli Sembunaye, ngundo simoo bale enengo sobowooteku, ngu ndawuga ngundilo? ");
INSERT INTO rwo_karo_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ngu ngandilo. Ngu oomanangoyingo koongeweloyi oowooyi Yis. Bale gulado ngu Yisga ngu yolo ngundo oo kiki uleyingo koondo kabusa ngu yolo, Yis nguno yetoni, yowoolengolo, asa, kootusina, Yis ngundo ngu bidodo yeni koongemukowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ngu naluno, ene ende bobodimo ululumo nguya salo, oni simoo bale mande elo etuyelolo, yade yade oololo, Yerusalem endemo tunootewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ngu naluno, oni gulado Yesusno ewolo. Ulungga Oo Bidodo Sembuli Sembunaye, oni gulanangge nangge bine Anutndo yoyowa? Etoni, Yesusndo enengo mande ingolo gumi ngandilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Ye yanggango oolengo yelogo, ye komo yamako bodaga nguwoole uwanggo. No yeno eteno. Oni oowooyingga nguno uwelo ingootenggoku, ene uweloyi ereremo kinilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kootusina, ya Sembulibo ootookoolo, yamako goodootoni, ye ngu naluno ombulo, endesina dikalo, ngunonggo yamako utolo ewanggo. Ulungga Oo Bidodo Sembuli Sembunaye yamako goosooyunolo ewonggo. Ngundilo etoyi, enebana manggoye gumi ngandilo ewa. Ye ndawu oningga? No ye watayi kini! Ye ndanonggo mayetenggo? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Yendo eneno ngandilo ewanggo. Noole geya oowali sono oo goboolo nelo, ge noolengo ende kewooloko dikalo, ngunonggo mande nooleno elo etuyeloyingo, ngundo mayeteku nga. ");
INSERT INTO rwo_karo_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Etoni, enebana manggoye gumi ngandilo ewa. Ye ndanonggo oni? No ye ma ingooteno! Ye nolo nowoondoyemo hamoo kini! Ngunonggo ko sayi, ye oo biyomimu telo yalatenggoku oni biyobiyomi, ye yokoya sayi! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Kootusina ye osisambaye Ebaraham, Ayisak, Yekob, ko Anutlo ingondudu eyingo oniku Sambo endemo oolootenggoku, ngu yeyolo ngu, ye sendolo biyobiyomi telo metooye kini ndindi telo oluwanggo. Ndatelo ngulo, ye Anutlo mande ingolo ma keyowonggoku, ngulo ene ye yoyokootoni, Sambo endemo nguno ma uwanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Oni simoo bale ene Anutlo nowoondoyemo hamoo tetenggoku ngu, mela bidodomonggo ombulo, Anutlo endenimo nguno oo simbo ulungga katoyi, ngu newanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ye komo gome ingoyi! Oni gidalega kootu ombutenggoku, ngundo oololo koletewanggo. Oni koleteyingo ngu, ene ombulo, kootu tewanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ngu naluno nangge, Parisi oni gidalega mayelo, Yesusno ewonggori. Ge nga endega nga sodedonangge yokoya, ende gulano toonge. Ndawugalo ngulo, Herodndo ge guleni kumoowelo etelo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ngundilo etoyi, Yesusndo ngu onikuya mande gumi ewolo. Ye oolouya, ngu se gokingga nguno ngandiya eyi! Ingo! Ataga ngu no simoo baleno oo yuka biyomi owelo, sayi mambudodo oni yomosiyelolo, ngu no ko temukowano. ");
INSERT INTO rwo_karo_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ene ataga, yangeni, yangenggoodoo nguya, no yade yade oololo, Yerusalem ende yootoowegago; ndatelo ngulo, Anutlo ingondudu eyingo oni gula, ende sungomo ma uleyi kumoowa. Kini, ene komo Yerusalemno uleyi kumoowa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ye Yerusalem oni simoo bale, gowugowulongo, ye komo Anutlo ingondudu eyingo oni, yuleyi kumoowonggo. Anutndo oni ye etuyelowelo suleyootoni, yendo digi yolo, ngundo yulewonggo. Nalu oowooyingga no yengo simooye goobooyelowelo teteno. Kootooribo simoongo yoyeni wileyo newendemo goobooyelooteku ngundilo. Ene ye ngu yokowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ye gowugowulongo ingoyi! Anutndo ye hoolooweyelowelo teni kinitetoni, ngulo ene yengo ende ngu kuli yokowolo. No yeno eteno. Ye no ko ma neyolo oodoyi, oololo ngu nalungga ngu tunootetoni ngunonggo ye ngandilo ewanggo. Ene oowooyi bingami okoowato. Ene Ulungga Oo Bidodo Sembuli, ngu oowooyimo ombute. Ngundilo elo, ngu naluno, ye no neyowanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sabat nalu gulano, Yesus oololo, Parisi onilo tabangonggalo yano enedodo oowali newonggori. Ngu yano oni ngu bidodo Yesus kenondadangelo oluwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Nguno oni gula kekandeyi koongeyingongga Yesus tanggeyimo ombuwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesusndo ngundilo kenolo, yowoolengolo mamana mandelo ingondudu onikuya, Parisi oniya sumoo yunolo ewolo. Noole mete sayi oni nalu kundingiyimo ngano yomosiyowato, bine, ngundi kini, bine? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ene mande gumi ma elo nenetewolo. Ngundilo tetoyi, Yesusndo ngu oni moondeyi koongeyingonggaku ngu yolo yomosiyolo suleyootoni toongewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Yesusndo ene bidodo sumoo yunowolo. Oni gula ye kewooloyemo ngano, enengo nangoni bine ngundi bulmakau boningga sono meleno soletoni ngu, ene nalu kundingiyimo sodedo ma woosoolo yowa, bine? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ene ngu mandega ngu gumi ma ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesusndo yeyootoni, ngu oowalingga nguno mayelo ene yaba koleteyingomo bibitewelo ingowonggori. Ngundilo tetoyi, ngulo Yesusndo mande yamonggawo gula elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Oni gulado bale kameyowelo oo simbo gulano ge negogelootoni ngu, ge yaba koleteloga nguno ma bibitewa. Ngu oningga, ngundo ene oni gula oowooyi ulungga ge dagagelolo ene ulungga, ngulo nguya ombuwa, bine? ");
INSERT INTO rwo_karo_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ngundilo telo, oo simbo kayingo Sembuliga, ngundo ombulo geya ewa. Ge woosooya ooloutooga nga oningga ngando ngu yabaga nguno bibitenilo ewa. Ge ngu yaba koleteyingongga ngu yokolo, ene inootoyi bibitetoni, ge ngulo oyumo ulungga oolengo yolo, ge oololo ulo, kootusina amuno bibitewa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ye ingoyi! Ge oni gulado oo simbo kaya, ge negogelootoningga ngu, ge ombuya, yaba wengamo amuno oni kootuyesina bibite. Kootu oo simbo kayingo sembuli, ngundo ombulo geyolo ewa. Doboone, ge ombuya oolouya, awuno bibitelo etoni, ge oni mayewonggoku ngu doongeyemo koletelo bibitelo, ge bingaminggedodo tewa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Oni gula enengombo enengo oowooyi bingami okooteku ngu, Anutndo oowooyi yeni melako uwa. Ene oni gula, ene oni sungo nowoondoyemo ameno oolootekungga ngu, Anutndo yolo oowooyi bingamidodo awuno oolengo yewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yesusndo Parisi oningga oo kayingo sembuliga nguya ewolo. Ge oowali gula kaya ngu, ge gengo doboogulige, konebage, ko gengo kenggemo oni, ko ende goboolo oni ngu, ene bobeye digidodo oni ngu nangge ma negoyelowelo. Ge ngundilo tewaku ngu, enebana gengo oo kawoku ngulo gumi oo kalo gunootoyi, ge enengo yano oololo, oowali gumi newa. Gengo nowoondoge ngulo nangge ma ingowelo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kini, ge oo simbo ulungga ko kaya ngu, ariya, ge komo oni simoo bale owoolongo, sayi mambudodo goweye biyomi ngu, kekandeye biyomi ko doongeye kilingo oni ngu negoyelootoyi, ngundo mayelo newanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ge damoni ngundilo ngu tetoyi, ngulo Anutndo geyolo oni oni tewa. Ngundilo oni, ngundo ene gengo oo simboga kalo yunowoku, ngu gumi ma kalo gunowanggo. Ene ereremo kini. Kootusina, Anutndo gengo oo simboga kawoku ngulo ngu Anutlo oni nenengomu melenonggo ko ootookoowanggoku naluno, ngundo gumi oo gunowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ngu naluno, oni Yesusndo oowali neyingomu ngu gulado Yesuslo mandeni ngu ingolo, ootookoolo Yesusno ewolo. Oni ene Anutlo ende musiyonimo simbo kayingo ngu newaku ngu, ene mete oni oni telo oluwalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ene Yesusndo ngu oningga nguya mande yamonggawo ewolo. Oni gula ene oo simbo ulungga kawelo ngu, ene koletelo oni simoo bale oowooyinggano kuli elo endeyootoni ingowanggo. Ngulo naluni nguya elo yunowa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Oode oowali kaweloyi naluno, oni oo sembuligakundo enengo sulena oni suleyelolo ewa. Ge toongeya, nondo kuli onino ewonoku nguno ngandiya e. Ye mete ataga mayeyi, no oo kuli kalo yomosiyootenolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ene ngu oniku bidodo enengo ko sungo sungolo ewonggo. Noole ma oolouwatolo ewonggo. Oni gulado ewolo. No mela gula keda uliyowonoku, no toongelo ngu kenowano. Oniyooge, no ma oololo kenowano. Gedo oolouya ngundiya e. ");
INSERT INTO rwo_karo_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ngundilo etoni, oni gulado elo ewolo. No bulmakau bo keda kande elaya (10) uliyowonoku, ngulo no oololo ngu tewoongolo kenowelo ngulo oolouya awanggemo e. Oniyooge, nolo ma ingowelolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Oni gulado ewolo. No ataga bale yolo, ngulo no ma oolouwano. ");
INSERT INTO rwo_karo_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ngundilo ngulo, sulena oni ko oololo, enengo oni ulunggakuno ngu bidodo ewolo. Ya sembuligaku ngundilo ingolo, ene sanggili telo, enengo sulena oniya ewolo. Ge sodedo oolouya, nga endega ngalo oole ulungga nguno ko oole bobodimo nguno, owoolongo oni, oni goweye biyomi, doongeye kilingo, ko, oni kekandeye biyobiyomi ngu bidodo yoyoya mayetooga, ngundo nolo yano ngano ombuyilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Kootusina, sulena oninggakundo, oni ulunggakuya ewonggori. Ulungga, gedo ewoku ngundilo tewono. Ene yaba gidalega kingo oolootelo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Oni ulungga ngundo enengo sulena oninggakuya ewolo. Ge oolouya, oole ululu bidodomo endeyoya, ko kanggaguli endeyoya ngunonggo, oni simoo bale yoyoya mayetooga, ngundo nolo yangga nga ndindi tenilo ingooteno. ");
INSERT INTO rwo_karo_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","No geno hamoo eteno! Nondo oni kuli elo endeyowonomu oni ngu bidodo ene nondo oowali simboga katenoku, nga gulado bodaga ma nelo ingowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Oni simoo bale ulungga Yesus keyolo endeyoyingomu ngusina yowoolengolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Oni gula no tanggenemo ombulo ngu, ene komo Anutlo ingooteku ingonduduga, ngundo eweyi, nemi, simoongo, konebeyi, kuwookuwooyi, ko enengo goweyi keda oluweloyi, ingonduduga ngu Anutlo ingootekuga, ngundo oo bidodo dagayeloote. Ene ngundilo ma telo ngu, asa, ene nolo sulena oni telo ma oluwa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Oni gula nolo ingolo no kenelolo endeyootoni, ngulo ene komo meyelo kowuli oowooyingga onindo inowanggoku ngu no oowoonembolo ngu koolowoo. Ene oni gula kowuli ngundilo koolowooweloyi elelemo kini ngu, ene nolo sulena oni ma tewa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ye kewooloyemo oni gula ya pelungga Sambono yewelo ngu, ene komo koleteya bibiteya ya ngu yemukoweloyi ngulo ulini ngu gome kandangelo ingowa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","30","Ene ngundilo ma telo ngu, ya ngulo ulini ma ingolo nguno damoni yelo, ene Simen yemukolo yokootoni, asa, oni bidodo kenolo yumooyinolo ewanggo. Nga oningga nga oniyooge ene, ya yeweloyi, ereremo kini. Oniyooge! Ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ngundilo elo, asa, mande yamonggawo gula ewolo. Mela ngalo oo sobosobo tabango oni gula, ene toongelo tabango gulaya ebe ulewelo ngu, asa, koletelo, ene bibitelo ingondudu gome telogo, enengo me oni (10,000) ngundo ene mete tabango gulado me oni (20,000) ngu yutolo oweyelowa, bine, ngundi kini, bine? Ene komo gome ingondudu telogo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ene ebe uleweloyi yanggangoni ereremo kini ngulo, asa, enengo me oniku yowoko oodoyi, ene sodedonangge mande soweyolo ewa. Noole ebe sodedo ma ulewato. Kini, noole komo koleteya bibiteya, imakeyingo damonimo doboo yeyigalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ene koletelo ye komo nowoondoye, ingonduduye ngu bidodo Anutno yelo, enengo ko tewanggo. Ngundilo nangge, oni gula ye kewooloyemo nguno, ene enengo oo bidodo ma kootu inolo ngu, asa, ene nolo sulena oni kilalongo ma telo oluwalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ene mande yamonggawo gula ewolo. Wendeyi nembo (Sol) ngu oo gome. Ene wendeyi nembo nenggulo kinitetoni ngu, asa, noole ndatelo tetooye, ngu nengguloga ngu ko mete tewa? Kini, noolendo ngu yomosiyoweloyi, ereremo kini. ");
INSERT INTO rwo_karo_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Wendeyi nembo (Sol) ngundilo ngu, mela oo imiweloyi kono nguno yeweloyi nguya kini. Noole bulmakau usedodo gooboongoolo ngundo mela tetooye, ulumidodo teweloyi nguya kini. Noole ngundilomu ngu kingo talangooteto. Oni sodeyi mande ingoweloyi gome metemi ngu, ene komo mande nga gome ingoni! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Gabman bobeye yoweloyi (Takis) oni, ko mbumbuwadodo onindo Yesuslo mandeni ingowelo tanggeyimo mayewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Parisi oniya, ko mamana mande etuyeloyingo oniya ngundilo kenolo, ngulo boguwoolo ewonggori. Nga oningga nga, ngu ene mbumbuwadodo oni yoyolo, nguya oowali netenggoku eke! Ene nguya dobooyelo endeyootenggolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","4","Ngundilo etoyi, Yesusndo mande yamonggawo gula elo ewolo. Ye kewooloyemo nguno oni gula ene Sipsip onibi kandegula (100) oluwolo. Ngulomu gula oonatetoni, ene enengo Sipsip gidalega mela gulasina yokootoni oo newoodoyi, ene Sipsip nangoni gula oonatewokungga ngu erewelo yade kenolo yologo, asa, ene kengewa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ene ngu Sipsipgaku kenolo yolo koolowoolo, oni oni telo oolouwa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ngu oninggaku enengo Sipsipku yoyolo ende mayelo, enengo dobooguliyimo elo ete. Ye noya oni oni tewato! Nolo Sipsip gula oonatewoku, ene no erewelo ko yowonolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","No yeno hamoo eteno. Oni gula ene mbumbuwa damoni yokolo newende yowoolengootoni ngu, Sambono Oni ngu bidodo oni oni ulungga oolengo tetenggo. Oni oowooyingga ene ngundilo ingootenggo. Noole nenengo elo ingootooye, ngulo ene Anutndo nowoondoye ma yowoolengootoni ngu, asa, Engel oni Sambono oolootenggokundo ngu enengo ma oni oni tewanggo. Kondibo kini, oni gula Anutno newende yowoolengootoni ngu, ngulo ene oni oni oolengo tewanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yesus ene mande yamonggawo gula yunolo ewolo. Yengo bale gula ene bobeye tanggooli kande elaya (10) enengo siko oluwolo. Kootusina, gulanangge toongewolo. Ene solu kalo ngu himimo ya newendekuli, gugu so oo oolengo siyakiyolo, nguwoole erewelo oode yologo ene kengewa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ene yolo yokolo ngu, asa, enengo dobooguliyi negoyelootoni, ombulo, gooboongoolo bibitetoyi ewa. Ye noya oni oni tewato. Ngulo nolo bobeye gula toongetoni erewelo oode, ko yootenolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","No yeno hamoo eteno. Anutlo oni Engel, ngundo mbumbuwadodo oni gula newende Anutno hamoo telo yowoolengootoningga, ngulo oni oni ulungga oolengo ngundilo tewanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesusndo mande yamonggawo ngu soweyolo ewolo. Oni gula ene nangosumoongo elaya. ");
INSERT INTO rwo_karo_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Nalu gulano, nangoni kootungga ngundo eweyimo ewolo. Awa, gengo bobeye oo sitowi ngu wesowooya nolomu nunolo ewolo. Ene ngundilo etoni, ingolo, bobeye sitowiku wesowoolo, enengomo enengomo yunowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ene nalu bodaga oode, ngu naluno, nangoni kootungga, ngundo enengo oo sitowi bidodo telo tewoolo ende ulungga yowokomu, nguno toongelo nguno oluwolo. Ngu simoongga ngu endega nguno oode, nguno bobeye sitowiniku ngu, bulibali endeyoyingo damoni biyomi nguno oolongooni umukootoni kingo oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ngundilo oode, enengo bobeye oo sitowiku oolongooni umukootoni, kootusina, ngu endega nguno oowalilo kumooyingo nalu ulungga tunootewolo. Ngu simoongga ngu, ene oowali gula yolo neweloyi oo gula kini. ");
INSERT INTO rwo_karo_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ngundilo ngulo, ngu simoongga ngu, ene ende dabemiwoole oo sosolango erewelo yade mayelo, ngu mela ngulo oni sitowinidodo oni ulunggano ko tewelo sumoo ewolo. Ngundilo sumoo etoni, ngu oni ulungga, ngundo yolo suleyootoni, enengo bodolo yano bo sobowoonilo, etoni oolouwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ngundilo telo, ene bodolo de tanggooli ngu yunootoni, nelo useye bakini yetoyi, yeyolo ingowolo. No nguya gula netoowega usene ndindi teni, elo ingowolomu nguya kini. Oni gulado kenolo oo gula ma inootoyi neyingo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","18","Ngundilo telo, newende himi yetoni, ingondudu telo ingowolo. Nenengo awanembolo ko oni ngu ene oowaliye ulungga telo netenggo. Nondo ngano ootoolo oowalilo kumooteno. Ngundilo ngulo, no ko awano oololo ewano. Awa, no Anut doongeyimo, ge doongenggemo nguya mbumbuwa telo, endeyolo oode, ngunonggo ko mayeteno. ");
INSERT INTO rwo_karo_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","No oni biyomi, ngulo noya nenengo nangonelo ma ewelo. Kini, noyoya gengo sulena oni eya noyelo ewanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ngundilo elo ingolo, ene ootookoolo eweyi tanggeyimo oolouweloyimbolo oolouwolo. Ngundilo telo, yade yade mayetoni, eweyimbo yowoko anduno doongetelo, nangoni kenolo, nowoondoyi telo, ootookoolo kendutelo oolouwolo. Oololo nangoni dowoolo mududu telo yenggonangowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Nangonimbo eweyimo oyumo ulungga yolo ewolo. Awa, no Anut, doongeyimo ko ge doongenggemo nguya mbumbuwa telo endeyolo yade ngunonggo mayeteno. Ngundilo ngulo, nalu gulano, nenengo nangone elo ma ewelolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ngundilo etoni, eweyimbo enengo sulena onino ewolo. Sodedonangge, ye oolouya, ye nenengo kumba gome pelungga ngu yoya ombuya yemuyinoyi! Kandeyimo tombo yeya ko keyi goweyi nguya yoya yeyinoyi. ");
INSERT INTO rwo_karo_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ye bo bulmakau nangoni moondeyi ndindi teyingo ulumidodoga yoya utoya katoyiga ngu nelo oni oni tewato. ");
INSERT INTO rwo_karo_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ndatelo ngulo, nga nangonengga nga kuli kumooyingo elo ingolo oodoowe, ene keda oode ataga mayete. Ene kuli oonateyingomu, ene noole ataga kenolo ko yooteto. Ngundilo ngulo, ene damoni yelo, oni oni tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ngundilo tewootoyi, asa, enengo nangoni koletelogaku ngu kono ko telo oluwoku, ngunonggo kootu mayelo, ya tanggeyimonggo ingowolo ngu, yambo sumbimboolo telo, kunobulo tetoyi, ngguyi ingowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ngundilo ingolo, ene sulena oni gula etoni tanggeyimo ombutoni ewolo. Ame ndawuga tetenggo? ");
INSERT INTO rwo_karo_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ngundilo etoni, ngu sulena oningga ngundo gumi ewolo. Gengo konege yade yade keda mayetoni, ngulo awanggebo bo bulmakau ulumidodoga utolo katoni, ngu nelo ngulo oni oni tetenggo. Ndatelo ngulo, enengo nangoni kootungga ngu ma kumoowolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ngundilo etoni, nangoni koletelogaku ngu ingolo, sanggili telo ya newendemo uwolo. Ngundilo tetoni, eweyimbo ya newendemonggo oolelo oolengo oolengomangge nangonimo mandelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ngundilo tetoni, ene nangonimbo eweyimbolo mande gumi ewolo. Ge ingo! Mooma oowooyingga no gengo ko kingo telo oolooteno. No nalu gulano gengo mandege manggoge ma toongoowolo. Ge ngulo meme bo nangoningga kingo nunootoyi, utolo, kalo doboogulinemboya nelo, ma oni oni tewolo. Hamoo oolengo kini! ");
INSERT INTO rwo_karo_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ene nangongge ngu gengo bobeye sitowi ngu bulibali ooleko ooleko se telo endeyolo, nguno bobeye baleno yokomukolo yade mayetoni, ngulo ge bo bulmakau ulumidodomu utolo kateku ngu! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ngundilo etoni, eweyimbo mande gumi ewolo. Nangone, suwoo suwoo noole gome goboolo oolootelo. Nolo oo sitowi ngu gengomu nangge. ");
INSERT INTO rwo_karo_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ene ataga ngu noole komo oni oni telo, nowoondonayi gome imakeyingomo oluwato. Ndawugalo ngulo, ene nga konegega nga kuli kumooyingomu, ene ataga ko keda ooloote. Ene toongelo kombiteyingomu, ene noole ko kenooteto. ");
INSERT INTO rwo_karo_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesusndo enengo sulena oniku mande yamonggawo gula ewolo. Beye sitowidodo oni gula ene enengo ko sobosobo oni ooloote. Oni bobeye sitowinidodo oningga, ngu enengo ko sobosobo oningga ngu goweyi sanggawelo mande ewonggo. Gengo ko sobosoboga ngundo gengo bobeye oo sitowige kingo yombuliyowolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ngundilo etoyi, ariya, ngu oni ulungga, ngundo ngu ko sobosobo oningga ngu negongootoni ombutoni ewolo. Geya etoyi ingowonoku, ngu ndatelo? Oo tewoku ngulo damoni wesiyoya e. Ge nolo ko sobosobo oni ko ma oluwalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Asa, ngu ko sobosobo oninggaku newendemonggo ingondudu telo ingowonggori. No ndatelo tewano? Nenengo oni ulungga oo bidodo Sembuli, ngundo ooni no kandenemo oolooteku ngu ko yolo, no sobosobo kono oweneloote. Ngundilo ngulo, no ndatelo tewano? No ko ulungga yanggango teweloyi oni, ereremo kini. No oni gidalegano oowali oolo yemboongewelo no oyumo ulungga moole. ");
INSERT INTO rwo_karo_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ene kowuli ingolo, ingondudunimonggo no oo gula ingooteno. Ulunggado sobosobo kono, owenelooteku nalu nguno, no ndawu kongga tetoowe, ngundo doboogulinembo nowoondoyi tetoyi, no enedodo ko doboo yewato? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ngundilo ingolo, oni enengo oni ulungga, ngulo oo weti telo oo yoyingoku ngu, gulanangge nangge sungo sungo sumoo yunolo ewolo. Ge ko sembuli ulungga ngulo weti ndatelo inowa? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ngu oni koleteloga, ngundo gumi ewolo. No Daram 100 de oo ulumi ngundilo inowano. Etoni ngu, asa, ko sobosobo tabangonggakundo ewolo. Geno weti oolooteku ngulo, ge bibiteya sodedonangge ngu weti tewoku Pepangga ngu yoya (50) nangge nakangolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ngundilo telo, oni gula sumoo inolo ewolo. Gedo ngu gumi ndatelo inowa? Etoni, ngu oningga ngundo ewolo. Nondo ngu Rayis si 100 (onibi elaya 25 Kilo Bek Rayis) inowano. Etoni, ko sobosobogakundo ewolo. Ge gowegemo wetidodo ngulo, ge sodedo bibiteya 80 Bek (onibiga kande elaya gidembolo elaya 25 Kilo Bek) nangge nakango. ");
INSERT INTO rwo_karo_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ngundilo telo, ngu ko sobosobo oningga ngu, ene ingondudunimonggo nowoondokara telo, ko teweloyi oni ngulo ko sembuli ulungga, ngundo enengo ko sobosobo oningga ngulo damoni biyomi ngu kenolo yokowelo ingowolo. Ene ko ingondududodo oni. Ngu hamoo oolengo, nga naluno nguya oni ingonduduyedodomu ngundilo ulungga oolootenggo. Oni simoo bale Anutno nowoondoye hamoo teyingo damonimo oolootenggoku ngu, ene ebe ganagana teweloyi nguno ingoyingo metemi nguya kini. ");
INSERT INTO rwo_karo_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yesusndo ewolo. No yeno hamoo eteno. Oni Anutno newende hamoo teyingo, ene nguya enengo bobeye ngu gome sobowooya simoo bale gidega hoolooweya doboo yeyi. Kootusina ngu oningga ngu oo tewelo wenonootoni, asa, ngu naluno doboogulingombo hooloowewanggo. Kootusina ngu oningga ngu oolelo Anutya sugi sugi oluwa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ene oni gula oo bidodogano newendemo hamoomonggo gome sobowoowaku ngu, ene oo ulungga nguya ngundilo newende hamoomonggo sobowoowa. Oni ene ko bodagano ko gome ma tewaku ngu, ene ko ulunggano nguya ngundilo ko gome ma sobowoolo tewa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ene yengo bobeye kandeyemo oolooteku ngu, gome ma sobowoolo ngu, asa, Anutndo hamoo engge gome ngu ye yunootoni, ngu gome sobowoowanggo? Hamoo oolengo kini. ");
INSERT INTO rwo_karo_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ye oni gulalo oo ngu gome ma sobowoolo ngu, onendo yengo oolengo oo ngu yunowa? Kini, oni gulado oo gula ma inowa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ko oni gulado oni ululu elayagomo ko telo ma oololo ombulo tewa. Ngu ko oningga ngundo ngu oni ululu elayagaku, gulano newende inolo, ngulo nangge ko tewelo ingolo, gulagakuya newende biyomi ingolo, ngulo koni ma tewa. Ene gulalo konimo ngu suleyo kiniyetoni, ko gulalo konimo ngu, ene ko gome telo yomoosiyolo ko teyinowa. Ngundilo nangge, ye Anutlo ko oni telo, nowoondoye bidodo bobeye yoweloyimbolo nguno nangge ma yewelo. Ye nowoondoye ko elaya teweloyi, ngu ereremo kinilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Yesus mande soweyolo gula yunolo ewolo. Parisi oni ngu, ene bobeyedolo gome ingolo, ngulo hahangetenggo. Ngulo ngu, Yesusndo mande nga bidodo etoni, ingolo, ngulo ene yumooyinolo mande ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ene Yesusndo yeyolo elo ewolo. Ye damoniye gome nenengo ngu simoo bale yengo nowoondoye ingoote. Onindo oo bingami okootenggoku ngu, Anut doongeyimo ngu oo ngu buwoo biyomi kookoosedodo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Mamanalo mande nguya Anutlo ingondudu eyingo onilo mandeye oode oode ombulo, Sonoyeloyingo Oni Yon ngulo naluno. Ene Yonlo nalunonggo ombulo, wenga ataga nga, ngu Anutlo mande gome mesalango ngu Anutlo yoyo pawanonggo tunootelo, ende bidodomo ooloute. Oni simoo bale bidodo ngu yoyo pawangga ngu newendemo uwelo yanggango oolengo yetenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Kootusina, Sambo ende mela nga nguya oololo kinitetoni, ene mamana mande ngalo gumi bodaga ngu hamoo oolengo ma kinitewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Oni simoo bidodo enengo bale sumooye yoyokolo bale sungo yoyolo, nguno ene elambalisa oluweloyi ngu yombuliyootenggo. Kuli kameyimbo ene yokowoku ngu, ene elambalisa oluweloyi mamana mandega ngu yombuliyowolo. Simoondo bale gula yooteku ngu, asa, Anut doongeyimo, ngundo bale elayaga ngu yombuliyelootelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesusndo mande gula ewolo. Kulimi bobeye sitowinidodo oni gula oluwolo. Ene suwoo suwoo towi nenggulo gome gomemu nangge telo, kumba seleyingo gome ngu yemulo ootoolo, ngunonggo ene suwoo suwoo oowali gome nenggulomu nangge nelo oni oni telo, oololo ombulo teloluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Ngu sitowinidodo oni ulungga ngulo yamako dabemimo nguno, oni owoolongo gula oluwolo. Ngu oowooyi Lasaras, ngu mambubo goweyi kondibo yeni kini teyingomu, ngu sitowinidodo oningga ngulo yamako dabemimo bibitelo, oowalilo sumoo sumoo elo oluwolo. Ngu sitowinidodo oningga ngundo oowali neya sosolango yeni melako soletoningga newelo Lasaras hahangelo, ingondudu ulungga telo oluwolo. Ene yamako dabemimo nguno bibitelo oodoni, sebo mayelo, enengo mambuniku meyabolo oluwonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Kootusina, owoolongo oninggaku kumoowolo. Anutlo Engel onindo ombulo, Lasaras gaboyi okoolo yolo oolelo, Ebaraham begowoomo yetoyi, bibitelo oluwolo. Kootusina, ngu sitowidodo oninggaku nguya kumootoni melengoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ngu sitowinidodo oninggaku gaboyi oolelo, ende biyomi de nombo buni ma kumooteku, nguno uwolo. Ulo, nguno ogingoyingo ulungga oolengo ingolo oode, ngunonggo doongetelo, Ebaraham yowoko anduno kenootoni, Lasaras begowoomo bibitelo oodoli yeyowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ngundilo yeyolo, menolo ewolo. Awa, Ebaraham, ge nolo nowoondoyi teya, Lasaras suleyootooga, kandedibiyibo sono bodaga sanggaweya ombuya, mebunemo yetoningga bodaga gingo yeni. Ndatelo ngulo, no de nombono moondene gookingo oolengo yetoni, ngulo hahangelo ogingoyingo ulungga ingootenolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ngundilo etoni, ene Ebarahamndo gumi ewolo. Nangone, ge ingondudu te! Ge kuli melako keda ootoolo nguno, oo gome gomemu bidodo kuli yomukowoku, nguno ge Lasaras ma hooloowewolo. Ngundilo tetoyi, Lasarasndo ngu, ene oo biyomi nangge yolo oluwoku, ngulo ene ataga nga endemo ngano ngu, ene newende imaketoni ooloote. Ene ge ngu ogingoyingo ulungga ingooteku ngu! ");
INSERT INTO rwo_karo_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Oo gula nguya ingo! Noole ko ye kewoolonayimo Anutndo kembe ulungga ngundo logo yewolo. Ngundilo ngulo, oni ngalokonggo yeloko oolouweloyi nguya hamoo oolengo kini. Ko yeloko ngunonggo nooleloko ngano mayeweloyi nguya hamoo oolengo kini. ");
INSERT INTO rwo_karo_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","Ngu sitowinidodo oningga, ngundo solengoyelo ewolo. Ngundiloga ngu, Awa, ge Lasaras suleyootooga, nenengo awanembolo yano uya, nolo konebane kandegula oolootenggoku ngu, ene nguno mande yanggango oolengo eya sodeye kookootoningga, ene mande ngu gome ingolo, ene nguya nga ende biyomi oolengonggano ngano ma ombuwanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ngundilo etoni, ene Ebarahamndo ngulo mande gumi ewolo. Ene Moseslo mande ko Anutlo ingondudu eyingo oni ngulo mande nguya eneno ooloote. Ene komo ngu ingowanggo! ");
INSERT INTO rwo_karo_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ngundilo etoni, sitowinidodo oningga ngundo gumi ewolo. Kini, Awa Ebaraham, oni gula ene kumooyingomundo ko ootookoolo mayetoni, ngu kenolo ene soliyokolo ngu, asa, ene nowoondoye yowoolengowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Etoni, Ebarahamndo mande gumi ewolo. Ngundilo kini. Ene Moseslo, ko Anutlo ingondudu eyingo oni, ngulo mande ma ingolo keyolo ngu, asa, oni kumooyingo ngu ko ootookoolo, ngundo mande etoyi, nguya ma ingolo, ngulo nowoondoyemo nguya hamoo ma tewanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesusndo enengo sulena onino ewolo. Oo guladilo guladilo tunootelo, ngundo simoo bale yoyeni, mbumbuwano uwanggo. Oni ene oni gula yolo, mbumbuwa damonimo nguno yewoku ngu, ngu oniyooge oolengo! ");
INSERT INTO rwo_karo_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Oni gula damoni biyomi tewoku ngu, ngulo uliyi ene kondibo digi ulungga yolo bungeyimo gosiyolo wendeyi dumuyimo oolongooyi utoni kumoowa. Ngulo uliyi ngu, ngu ulungga. Ene oni gula simooye nowoondoye yombuliyooteku ngu, asa, ngulo uliyi ngu, ngu kowuli kondibo ulungga oolengo. Yengombolo ingondale teyi! ");
INSERT INTO rwo_karo_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Gengo konegegado mbumbuwaga tetoningga ngu, ge kenoya sanggili tetooga, ene newende yowoolengootoningga ngu, ge komo enengo weti ngu andangeyinoya wongooga utoningga kapengoye. ");
INSERT INTO rwo_karo_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ene nalu gulananggemo geno mbumbuwa tambu kandegula gidembolo elaya telo, ngu sanganimo nguno nangge tambu kandegula gidembolo elaya ombulo, geno solengoyelo ewa. No nowoondone yowoolengoote, eya etoningga ngu, asa, ge komo mbumbuwani andangeya wongooga utoningga kapengoyeyinolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Aposel onindo Oo Bidodo Sembuli ulungga, Yesus nguno elo ewolo. Ge komo nooleno nowoondonayemo hamoo nga yega yanggango yeni. ");
INSERT INTO rwo_karo_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Etoyi, oo bidodo Sembuli ulungga ngundo ewolo. Ye nowoondoyemo hamoo teyingo bodaga oodoni ngu, asa, ngundo ye mete Anutlo ko ulungga tewanggo. Yo, hamoo oolengo, ye nowoondoye hamoo teyingo ngu bodaga ngu Mastet yuwooyi ngundilo ngu, asa, Anutndo ngu tetoni, ulungga oolengo yewa. Anutndo yeno ngundilo tetoni ngu, ye mete ngu dega nguya ewanggo. Ge gengo damoningge ukeya toongeya uya wendeyi sono koongeyingo kewooloko uya nguno dika elo etoyi ngu, asa, ene yengo manggoye keyolo ngundilo tewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yesusndo mande yamonggawo gula ewolo. Ye gulado enengo sulena oni gula ene kono mela doongoolo, ngundi Sipsip boga ngu sobowoolo oode ngunonggo mayetoni, ye sodedo ngandilo ma ewanggo. Sodedo ombuya bibiteya oowali neya ootoo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Etoyi ngu, ene ngandilo ewa. Ge nolo oowali kaya yomosiyoya, oo gidalega yomosiyootooga, oo detoningga wendoya, no nunootooga, nelo sono nguya nelo yokootoowe, ariya, gebana kootu oo nelo sono nguya newalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Enengo sulena oningga, ngundo manggowo keyolo oo bidodo temukootoni, sumange teyinolo esetewa, bine? Kini, ngu enengo ko nangge. ");
INSERT INTO rwo_karo_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ngundilo ngulo, ye nguya, Anutndo etoni, ye oo bidodo ewoku ngundilo temukolo ngu, ariya, ye ngandilo ewanggo. Noole ko oni biyomi, noolengombo ko oo nangge teteto. Yo, oni Anutno newende hamoo teyingo ngu Anutlo oo ewoku ngu temukootoni, ngulo ngu melako ngano onindo oni oni teyinowelo, ngulo ma ingowelo. Kini, enengo uliyi hamoo ngu Sambo endemo nguno oolootelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesus Yerusalem oolouwelo Galili Sameriya mela elayaga ngu kewoolokuli oolega ngu keyolo oolouwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","13","Ngu naluno, Yesus ene ende gulano ulo tunootetoni, oni goli mambudodo kande elayagobo ombulo, oole dabemimo sungo yowoko dikalo, Yesusno meno elo ewolo. Yesus, oo etuyeloyingo oni, ge noolengo nowoondoyi teyunoya yomosiyelo! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ngundilo etoyi, Yesusndo yowoolengolo yeyolo ewolo. Ye oolouya, Anutno woolo yeyingo onino nguno goweye etuyeloyi! Ariya, ngundilo etoni ngu, oni goli mambudodo yowoolengolo oolouwootoyi, ooleko goweye moondeyemo mambuku peselo toongetoni, goweye mete temukowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ngundilo teyunootoni, ngu oni kande elayagaku ngulomu gula, ngu Sameriya oningga enengo goweyi kenootoni, ko mete tetoni, ngulo ene yowoolengolo, Yesusno ko oololo, meno manggalu telo, Anut bingamilo okoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ene omukumundoongosinanggo Yesus tanggeyimo penggootelo wetolo, Yesusno esetelo ewolo. Eso, no gowene mete tetoni ngulo ombutenoku nga! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ngundilo etoni, Yesusndo ngu kenolo gumi ewolo. Nondo ngu kande elaya bidodo metemi tetenggoku, elo ingooteno. Kandegula gidembolo namolaya ngu ndano oolootenggo? ");
INSERT INTO rwo_karo_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ndatelo ngulo, ngu oningga ngu, ene Yuda oni kini, enesu nangge ombulo, Anutndo oo goweyimo tewoku, ngulo elo okoowolo. Yuda oni kandegula gidembolo namolaya ngu ndano? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yesusndo ngu Sameriya oninggakuya ewolo. Ge ootookooya toonge! Gengo nowoondogemo hamoo, ngundo goyeni gowege metemi tetelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","21","Nalu gulano, Parisi onindo Yesus sumoo inolo ewolo. Ndawu nalunggano, Anutndo oo bidodo Sembuli telo oo sobowooweloyi naluningga ngu ombuwa? Etoyi ngu, Yesusndo mande gumi elo, Anutndo oo bidodo Sembuli telo simoo bale sobowooweloyi naluningga ngu ombutoni ngu, oni simoo baledo ngu doongeyembo tunoo ombutoni ma kenowanggo. Ene ngandilo ma ewanggo. Kenoyi nga oolooteku nga, ngundi, andusina oolooteku andu! Ingoyi! Anutndo oo bidodo Sembuli telo oo sobowooweloyiga ngu ye nowoondoyemo oolooteku nga! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yesusndo simoo bale oowooyinggano mande emukolo yokolo ngu, ene yowoolengolo enengo sulena onikunolo ewolo. Kootusina nalu wengamo ngu namoko tunootetoni ngu, kowuli oowooyingga ombulo ye wiliyelowaku, ngu naluno ye nowoondoye hahangelo Oni Nangoni ombutoningga kenowelolo etenggo. Ene yengo ingondudu ngu ma keyowa. Kini, ene enengo ingonduduni nangge keyowa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ngundilo ingootoni, oni sungombo ewanggo. Kenoyi, Yesus oolooteku nga! Ngundi, ene kenoyi andusina oolooteku andu. Ngundilo etoyi ngu, ye ngulo nowoondoyemo hamoo ma telo, ye oololo ngu ma keyowelo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ye ingoyi! Sambononggo yowali soluyi ngundo Sambo bidodomo himi yelo oolouwa. Ngundilo nangge, Oni Nangoni ngulo tunooteweloyi naluwo ngu sodedonangge ombuwa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Koletelo, ene komo kowuli ulungga koolowoolo ogingoyingo ingolo oodoni, ngu naluno, oni simoo bale oolootenggoku, ngundo mandeni soweyo kini elo kootu inowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Nowalo naluno onindo damoni biyomi teyingo, ngundilo nangge Oni Nangoni nalunimo nguya ngundilo tewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ngu naluno, ene oo simbo kalo nelo, sono nelo, bale kameyolo oololo ombulo telo oodoyi, ngu naluno, Nowa wanggo newendemo utoni, sono tuwi ulungga tunootelo, ngundo oni simoo bale bidodo yutolo yombuliyelowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","29","Lotlo naluno nguya ngundilo tewonggori. Ene oowali kalo nelo, ngulo sonoyi nguya nelo, ene oo uliyolo yolo, ko ulilomu oni gidaleganonggo bobeye yolo oowali koyi telo, imilo, yawudada telo ya yeloluwonggo. Ngundilo telo oodoyi, Lot ngu Sodom ende yokolo toongewonggori. Ngundilo toongetoni, Sambononggo de soludodo, ko digi gookingo wooloyi biyomi oni kumooweloyimbolo sambo sono ngundilo ombulo, ngundo oni simoo bale bidodo yombuliyelootoni kumoomukowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ngundilo nangge, Onilo Nangoni tunooteweloyi naluwomo ngundilo tewa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ngu nalungga nguno oni gula ene ya sanganimo awuno oolelo oode, ngunonggo enengo oo sitowi ya newendemo oodoni ngu yowelo ya newendemo ma uwa. Ngundilo nangge, oni gula kono toongelo oode, ngunonggo ene ko endemo mayelo sitowi yoweloyimbolo ma ingowa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ngundilo nangge, ye Lotlo baleyimo nguno ingoyi. (Ene Sodom endemo ko doongetetoni ngulo Anutndo kowuli inolo uleni kumoowolo.) ");
INSERT INTO rwo_karo_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ene oni gula enengo keda goweyiga ngulo gome sobowoowelo nangge ingolo ngu, ene oluweloyi ngu gome dowoolo solengolo oode ngu, asa, kootusina nalu wengamo, ngu kedaga ngu oonatewa. Ene oni gula enengo keda oluweloyiga ngulo ma ingondudu telo oluwelo kini. Ene Anutlo koni nguno yetoni oluwaku ngu, asa, ene enengo gaboyi Sambo endemo keda gome suwoo suwoo oluwa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Yo, no yeno eteno. Ngu suwoongga, nguno Yesus enengo oni simoo bale ko ombuteku naluno, oni elaya yaba gulano welewaliku, ene suwoo kewooloko oni gula Anutndo andangelo yolo, gulanangge yokootoni oluwa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Bale elaya oomanangoyingo kawelo yowoolengolo yewoliku, Anutndo gula yolo, gula yokootoni oluwa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Oni simoo elaya kono oluwoliku, ene Anutndo ngu simoo elayagaku gula yolo, gula yokootoni kono oluwa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ngundilo etoni ngu, Yesus enengo sulena onikundo ngu mandega ngu ingolo sumoo ewonggori. Ulungga Oo Bidodo Sembuli, ngu ooga eteku ngu ndano tunootewa? Ewonggori. Ngundilo etoyi, Yesusndo mande gumi ewolo. Oni kumooyingo bingongga oolooteku musiyongga nguno, oni simoo bale ingootenggoku, ngu karakambi ululumelo mayelo gooboongoowanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesusndo mande yamonggawo gula enengo sulena oni ewolo. Ene nalu bidodomo Anutno yemboongelo oluweloyi ene suleye ma kini yewa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ene ngandilo ewolo. Ende gulano mande wilikoweloyi oni gula oluwolo. Ngu oningga mande wilikoweloyiga ngu, ene Anutlo ma sosoleyingo, oni simoo balelo nguya ma nowoondoyi teyunoote. ");
INSERT INTO rwo_karo_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Bale nggami gula ngu endemo nguno oluwolo. Ngu bale nggamingga, ngundo ngu mande wilikoweloyi oninggano nguno suwoo suwoo ombulo, sumoo eloluwolo. Nolo longge onindo yombulinelowelo tetenggo. Ge hoolooweneloya mandene yomosiyolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Ngundilo tetoni, nalu pelungga, ene ngu bale nggamingga ngu ma hooloowewelo ewolo. Kootusina, enengo ingondudunimo ingowolo. No Anutlo ma sosoletenoku, ngulo no simoo balelo ma ingolo yombuliyelooteno. Ene nga bale nggami ngando suwoo suwoo enengo mande mande yomosiyowelo, no eririnelolo ooloote. Yokowanoku ngu, ene komo ngundilo eririnelolo oodoni, sulenekini yewa. Ngundilo ngulo, no komo ene hooloowelo mandeni elo yomosiyowanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","7","Ulungga Oo Sembuli ngundo ewolo. Eriritelootoni, ngulo nangge mande wilikoyingo oni biyomingga, ngundo bale nggamingga ngulo mandeningga ngu yomosiyowolo. Asa, Anutndo enengo oni simoo bale soleyelolo sunggi yewoku, ngulo mande mandeye yemboongega suwoo suwoo, nalu logono tetenggokungga, ngu Anutndo ngulo nowoondoyi ulungga telo, hoolooweyelolo mandeye yomosiyoyunolo oluwa. Ene sodedo hoolooweyelowa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","No yeno eteno. Hamoo oolengo, ene sodedo enengo simoo balelo kowuliyemo hoolooweyelowa. Ene kootusina, ngu Oni Nangoni, ngu ombulo, ngu naluno, ene mela ngalo oni simoo bale yeyootoni, ene nowoondoyemo hamoo telo oolootenggo, bine, ngundi kini, bine? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Oni gidalegado enengombolo ingoyingo ngu, ene hamoo oni nenengo oolengo elo ingolo, ene oni gidalegaya ngu, ene ngandilo ingolo etenggo. Oni biyomilo ingootenggo. Ngu oni ngulo Yesusndo mande yamonggawolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Nalu gulano, oni elaya yambo ya oowooyi Tempel nguno yemboongewelo oolouwoliyo. Ngu oni elayaga ngu, gula Parisi, gula gabmanlo bobeye yoyingo oni. ");
INSERT INTO rwo_karo_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ngu Parisi oningga ngu dikalo, enengo newendemonggo, ngandilo yemboongewolo. O Anut, no oni gidalega ngundilo kini, ngundo geno yemboongeteno. No yakaka ma telo ko mande ebe ganagana ma teteno. No ooleko ooleko bulibali se telo ma endeyooteno. No nga bobeye yoyingo oningga ngandilo nguya kini! ");
INSERT INTO rwo_karo_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Kowooyingo gulananggemo tambu elaya no oowali loogu telo kundingiyi oolooteno. No oo bidodo yootenoku ngulomu wesowoolo kande elaya ngulomu gulanangge ge gunootenolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ngundilo yemboongetoni, ene Gabmanlo bobeye yoyingo oninggaku yowoko anduno dikalo, ngunonggo ene sambosina doongetewelo oyumo yolo, ngulo penggootelo yemboongelo ewolo. O Anut, no mbumbuwadodo oni! Ge gengo sumange ayibige ngu yoya wilinelo! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesusndo mande soweyolo gula ewolo. Ngu bobeye yoyingo oningga ngu, Anutno newende hamoo telo, enengo oowooyi ma okoowolo. Ngulo no yeno eteno. Ngu bobeye yoyingo oningga ngu, Anutndo nguya oni nenengolo etoni, ene ootookoolo, enengo yano oolouwolo. Ngu oni gulaga ngu ene kini. Oni gula enengombo bingami elo okootoni, oowooyi ulungga teteku ngu, Anutndo oowooyi dowoolo woosootoni ombulo, kootu tewa. Oni enengo oowooyi bingami ma eteku ngu, asa, Anutndo oowooyi bingami okoowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Oni simoo baledo simooye bobodi yoyolo, Yesus tanggeyimo mayetoyi, ngulo Yesusndo kandeyi tabayemo yelo, kumana yunoweloyimbolo. Enengo sulena onindo ngundilo yeyolo, sanggili telo manggaluyelowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ngundilo tetoyi, ene Yesusndo simooyeku negoyelootoni, tanggeyimo ombutoyi ewolo. Ye komo ingoyi! Yengo nowoondoye bidodo Anutno yetoyi ngu, simooye bobodibo enengo awanamoye nowoondoye yunootenggoku ngundilo. Anut Oo Bidodo Sembuli Sembunaye, ngundo simoo bale enengo sobowooteku, ngundilo oni ngulomu. ");
INSERT INTO rwo_karo_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","No yeno hamoo oolengo eteno. Oni ene Anutno newendemo hamoo oolengo ngu ma oolooteku ngu, simooye bobodibo awanamoyembolo nowoondoyemo hamoo tetenggoku ngundilo ma telo ngu, asa, ngu oningga ngu, ene Anut Oo Bidodo Sembuli Sembunaye, ngundo oni simoo bale sobowooteku nguno ma uwalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Nalu gulano, sitowidodo oni tabango gulado ombulo, Yesus sumoo inolo ewolo. Oo etuyeloyingo oni gome, no ndawu oo gula gomengga telo ngu, no keda suwoo suwoo sugi sugi oluwano? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ngundilo etoni, Yesusndo mande gumi ngandilo ewolo. Ge ndatelo ngulo, noya oni gome, elo ete? Anut nangge, ene oni gome. ");
INSERT INTO rwo_karo_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ge mamana mande ngu, ge kuli kandangelo ingoote. Ge bulibali ooleko ooleko balese mande ngu ma tewelo, oni ma uleyi kumoowelo, oo yakaka ma tewelo, oni dobooge goweyi sanggawelo mande kootuyisina ma ewelo, awanangge tanggeyemo tolige kapengo ootoolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Etoni, ngu tabango oningga ngundo mande gumi ewolo. Ngu mamana mande ngu bidodo no kuli simooyemonggo keyolo yade ombulo ataga ngalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesusndo ngu mande ngu ingolo ewolo. Ge oo gulanangge ngu ge kuli ma tewolo. Ngu gengo oo ngu bidodo oni sungomo uliyoya bobeye yo. Ngulo bobeyeni ngu bayeteya, owoolongo oni ngu yuno. Ge ngundilo telo ngu, asa, gengo oo gome Sambo endemo oluwa. Ngundiya teya, ge ombuya, no keneloya endeyolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ngundilo etoni, ngu tabango oningga, ngu mandega ngu ingolo, newende kowuli oolengo ingowolo. Ndatelo ngulo, enengo sitowini bobeyeni ulungga ngulo ingolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesusndo ngu oni tabangongga ngulo newendemo ingooteku ngu, enengo bobeye sitowini ngulo biyomi ingowoku ngu, kenolo ewolo. Oni sitowiye ulunggadodo ngu, ene nowoondoye bidodo Anutndo hoolooweyelootenggoku, nguno uweloyi kowuli ulungga. Oni bobeye sitowiyedodo ngu, ene nowoondoye bidodo enengo bobeye sitowiye, ngundo hoolooweyelowa elo nowoondoye bidodo nguno yetenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ngulo ngu, bo ulungga ngu nggusi yayimo uweloyi ngu kowuli. Ene bobeye sitowidodo oni ngu, newende bidodo bobeye sitowinimo yeloolooteku ngu, ngu oningga ngu, ene Anut Oo Bidodo Sembuli Sembunaye, ngundo simoo bale sobowoolo oolooteku, nguno uweloyi ngu kowuli oolengolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ngundilo etoni, oni simoo baledo ngu mandega ngu ingolo ewonggori. Ngundiloga ngu, onendo ene mete suwoo suwoo keda oluweloyiga ngu yowa? Ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesusndo enengo ingonduduni kenolo, mande gumi ewolo. Oo onindo ma teweloyi ngu, Anutndo ngu oo ngu ene mete temukowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ngundilo etoni, Pitando ewolo. Noole noolengo ende oo sitowinayi ngu bidodo yokomukolo, noole mayelo ge kenggelolo endeyootetolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Ngundilo etoni, Yesusndo mande gumi ewolo. Hamoo oolengo no yeno eteno! Oni bidodo Anutlo mandeni koyi teweloyi ngalo ingolo, ngulo ene enengo ende, ya, baleyi, simoongo, konebeyi, eweyi, nemi, ngu yoyokolo mayetenggo. Ngu oo yokowonggoku, ngu Anutndo wendangelo oo ulungga oolengo ataga yunolo, ko kootusina naluno nguya yunootoni, ene nguno suwoo suwoo keda oluweloyimbolo, ngu yowanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesusndo enengo sulena oni kande elaya kegidembolo elaya yoyolo, sungo oololo elo ewolo. Ingoyi, noole Yerusalem oolewato. Anutlo ingondudu eyingo onindo, Oni Nangoni, ngulo mande elo nakangoyingo ngu bidodo engge yeni tunootewa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ene yolo oni sowe gidalega Yuda oni kini ngu kandeyemo yeloyunootoyi, ngundo kootuyisina mandeni biyomi elo utolo, yumooyinolo, mukendolo, gisalu utolo, uleyi kumoowa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ene nalu kabusagomo, ene melenonggo ko ootookoowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ngundilo etoni, enengo sulena onikundo ngu mandega ngulo damoni nowoondoyemo ma himi yetoni ingowonggori. Sulena onindo ngu mandega Yesusndo eteku, ngulo ingondudu gome ma tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesusndo ene Yeriko ende tanggeyimo ombuwolo. Oni doongeyi kilingongga oole dabemimo ootoolo, ngunonggo ene oni simoo baleno bobeye oolo solengoyelo, yemboongelo oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ngu oni doongeyi kilingongga, ngundo ingowolomu ngu, oni simoo bale oowooyingga oolengo mayetoyi, ngguyi ingolo, ngulo ene oni sumoo yunolo ewolo. Ngu oni ngu ndawuga tetenggo? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ngundilo sumoo etoni oni sungokundo, ngu oni doongeyi kilingonggakuno ewolo. Nasaret oni Yesusga ngundo mayetelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ngulo ngu, oni doongeyi kilingonggaku ngundilo ingolo, ene meno elo ewolo. Yesus Dewitlo osiyi, ge nolo nowoondoyi nuno! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Oni koletewonggokundo manggaluwoolo ewonggori. Ge nenete! Etoyi, ene ngu ma ingolo, ene meno ulunggalo ewonggori. Yesus Dewitlo osiyi, ge no nowoondoyi nuno! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","41","Ngundilo meno etoni, Yesus ingolo, ombulo dikalo ewolo. Ngu oningga ngu yoya, no tanggenemo ngano ombuyi! Etoni, oninggaku yolo Yesus tanggeyimo ombutoyi, Yesusndo sumoo inolo ewolo. Nondo ndawu ooga tenggunowelo ingoote? Elo sumoo etoni, ngu oni doongeyi biyomingga, ngundo mande gumi ewolo. Ulungga Oo Bidodo Sembuli Sembune, no doongetelo, mela oo kenowelo ingooteno. ");
INSERT INTO rwo_karo_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Etoni, Yesusndo ewolo. Doongeteya keno! Gengo nowoondogemo hamoo teyingongga, ngundo yomosinggelootoni, ge ko mete tetelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Yesusndo ngundilo etoni ngu, oni doongeyinggaku sodedonangge metemi telo doongetewolo. Ene doongetelo mela kenolo, Yesus keyolo endeyolo, ene Anutlo bingami ulungga oolengo elo okoowolo. Oni simoo bale ngundilo kenolo ngu, ene nguya Anut oowooyi bingami elo okoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesus oololo, Yeriko ende yayimo ulo, oolouwelo tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Yeriko nguno oni gula oluwoku, ngu oowooyi Sakiyas. Ene ngu Gabmanlo bobeye yoyingo oningga ngulo tabango, ene bobeye sitowinidodo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ene Yesus kenolo ingoweloyimbolo Yesus ngu onendo elo, ngulo kenowelo hahangelo oluwolo. Ene oni simoo bale ulunggado doobengootoyi, ngulo ene ma kenoweloyi tewolo. Ene oni ootuwoo oolengo tondongo ngulo ene Yesus kenoweloyi ereremo kini. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Sakiyas ingowolo. Yesus ngu, ene ngu oolega ngu keyolo ombuwalo ingowolo. Ngulo ene koletelo kendutelo oololo, de oolelo ngunonggo ene Yesus gome kenowelo, elo tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesusndo ngu oolega, ngu keyolo yade ombulo, Sakiyasndo oluwoku degaku damonimo ombulo, randolo de sanganimo doongetelo, kenolo ewolo. Sakiyas, ge sodedo melako ombu! Ataga no komo gengo yano geya oluwalolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakiyas ngundilo ingolo, ene sodedonangge somooluluwoolo melako ombulo, ene newendemo oni oni telo, ngulo Yesus yolo, enengo yano oolouwoli. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Oni bidodo ngundilo kenolo, sanggili telo boguwoolo ewonggori. Yesus kenoyi! Ene weti mbumbuwadodo oni Sakiyas, ngulo yano ulo, nguya oolooteliku eke! Ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sakiyas ene Yesus kenolo, enengo mbumbuwa tewoku, ngulo ingolo, newendemo hamoo tetoni yowoolengowolo. Ngulo Sakiyas ootookoolo dikalo, Ulungga Oo Bidodo Sembuli Yesusno ewolo. Oo Bidodo Sembuli Ulungga, ge ingootooga, no nenengo oo bidodo kewoolo oolengo wesowoolo, gumi gula ngu owoolongo oni bayetelo yunowano. Ene nondo oni gidalegalo bobeye oo kingo ganayelolo yowonoku ngu, nobana gumi ataga tambu namolaya namolaya yunowanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesusndo ngu ingolo, mande gumi ewolo. Ataga Anutndo nga yano oni simoo bale nga yoyoote. Ndatelo ngulo, nga oningga nga, ngu Ebarahamlo osiyi gula. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","No Onilo Nangoni, nondo oni oonatelo oolootenggoku ngu ereweyelolo ko yoyowelo ombuwonolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Yesus Yerusalem ende namoko mayetoni, ngulo oni simoo bale ngandilo ingowonggori. Ataga, Yesus Yerusalem oolelo utoni ngu, Anut enengombo sobowooweloyi naluwo ataga tunootewalo ingootenggo. Ngulo oni simoo bale enengo mande ingootoyi, Yesus mande yamonggawo gula ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ene ngandilo ewolo. Nalu gulano, oni ulungga ene yowoko ende gulano toongewelo, nguno ene oowooyi ulungga oo bidodo sobosobo koleteyingo oowooyi ngu etoyi, ene ko mayewa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ngu oningga, ngundo enengo ko oni kande elaya negoyelootoni ombutoyi, bobeye 20 Kina ko oni gulanangge nangge yunolo ewolo. Ye nga bobeye ngando ko teya ngulo gumi yoya soweyoya yeyadoyiga, no ko yowoolengolo mayelo yeyowanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Enengo ende goboolo onikundo oo sobosobo tewelo toongewoku, ngulo ene ngu oningga ngu yokowolo. Ngundilo ngulo, ene enengo oni gidalega suleyelootoyi, keyolo, salo ewolo. Nga oningga ngando oni ulungga telo noolengo sobosobo koleteyingo oodoni, ngu ma ingowatolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ene ma ingolo, ngulo ene oo bidodo sobosobo koleteyingo olini, elo sunggi yewonggo. Oni ulunggado mande ngundilo ingolo, ariya, yade yade enengo melako ko mayewolo. Oni nondo kuli bobeye yunowonomu, ngu negoyelootoyi, mayetoyi ewolo. Nondo kuli bobeye yunowonoku ngu koyi telo, ngulo gumi ndatelo yowonggoku, ngu etoyiga, ingowe ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Nga, koleteloga ngundo mayelo ewolo. Ulungga, gedo kuli bobeye doobe elaya (20 Kina) nunootoyi, ngundo ko teloodoowe, ngulo gumi yowonoku ngu, onibiga (200 Kina) tunootewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ngundilo etoni, ngu oni ulungga ngundo ingolo, gumi ewolo. Ge ko oni gome! Ge ko gome yanggango tewo! Ge oo bodaga ngu gome sobowoolo koyi tewolo. Ngundilo ngulo, no ge goyewe oni ulungga telo, ende kande elaya ngulo sobosobo oluwalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ariya, Ko oni elayayiga ngundo ombulo ewolo. Ulungga, kuli gengo bobeye doobe elaya (20 Kina) nunowoku, no ngundo ko telo, gumi yolo yelootoowe, doobe kande elaga (100 Kina) tunootewololo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ngundilo etoni, asa, oni ulunggakundo gumi ewolo. Gome oolengo! No ge goyewe oni ulungga telo, ende kandegula ngulo sobosobo oluwalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","Asa, ko oni kootungga ngundo ombulo ewolo. Ulungga, ge kuli doobe elaya (20 Kina) nunowomu ngu nga. No nga yolo, oololo, tolige towimbo doobengolo oongootoowe oolooteku nga! Ndatelo ngulo, no ge geyootenoku ngu, ge oni sanggili ngulo, oni gulado oo yetoni ngu, gedo ngu ooga ngu yoote. Oowali oni gulado imiteku ngu, gedo oo ngu selo engge yoote. Ngundilo ngulo, no gengo sosolelo ngulo yetoowe oolootelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","23","Ngu oni ulungga oo bidodo sobosoboga, ngundo sanggili ulungga telo ewolo. Ge ko oni biyomi oolengo! Gengo mandege, ngundo goyeni, ge mandedodo tete. Ge ingooteku ngu, no oni sanggili oo oni sungombo yetenggoku ngu no yooteno. Oni sungombo oowali imitenggoku ngu, nondo ngu selo yooteno, elo ete? Ndawugalo ge nolo bobeyega nga, oni bobeye yowoolalingoweloyi oni yunootoyi, ngundo ko tetoyi, no ombulo, nenengo bobeye nga gumi yolo, ngulo duwoo nguya gula yoweloyi? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ngu oni ulungga ngundo oni tanggeyimo dikayingokuya ewolo. Ye ngu bobeye doobe elaya (20 Kina) ngu sopiyoya, oni bobeye onibiga (200 Kina) ngu inoyi! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ngundilo etoni, ngu onikundo, oni ulunggakuno ewolo. Ulungga, nga oningga nga, ngu ene onibiga (200 Kina) kuli yowo! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Oni ene ingondudu gidalega Anut Oo Bidodo Sembuli Sembunaye, ngundo simoo bale enengo sobowooteku, ngulo damoniye sowoongga watayi, asa, Anutndo ngu enengo ingondudu ngu soweyolo ulungga inowa. Asa, ene oni gula ngundilo ingondudu bodaga ngu oodoni ngulo ma koyi telo ngu, asa, Anutndo enengo ingoyingo bodaga ngu bidodo yolo yokowa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ene nolo longge oni, ngundo no enengo sobosobo ma oluwelo ewonggoku, ngu oni ngu yoyoya, ngano ombuya, nenengo doongenemo yuleyiga kumooyilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesusndo ngu mande ngu elo yokolo, ene ootookoolo koletelo ene Yerusalem ooloutenggoku oolega ngu keyolo oolouwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Yesus yade yade oololo Betipas ko Betani ende elayaga ngu namoko mela puli oowooyi Olib, ngu damonimo mayelo, ngunonggo enengo sulena oni elaya suleyelootoni, koletelo oolouwoliyo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Yesusndo sulena oni elayaga nguya elo ewolo. Yali andu endegano anduno oolouya, uya Hos gula oowooyi donki duliyo gula gosiyootoyi oolooteku ngu, gulado kuli ngu sanganimo ma bibiteyingongga ngu kenoya, yoya ombuli. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ngu donkingga ngulo kimbonayi wesiyootoliga, oni gulado ewaku ngu, yali ndawugalo ngu wesiyolo yowelo, eya etoningga ngu, yali ngandiya eli. Ulungga Oo Bidodo Sembuli, ngundo ko tewelo ngundiya eya yoya ombulilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Asa, sulena oni elayagaku mande ngundilo ingolo oololo, oo bidodo Yesusndo ewoku, ngundilo nangge kenowoliyo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Sulena oni elayagaku, ene donki duliyo kimbonayinggaku wesiyowootoli, ngulo sembuguliyibo yeyolo, sumoo ewoli. Yali ndawugalo ngu donki nangoningga ngu wesiyooteli? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Sulena oni elayagakundo gumi ewoliyo. Ulungga Oo Bidodo Sembuli, ngundo ko tewelo ewokulo ewoliyo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ariya, sulena oni elayagaku donki nangoni duliyogaku yolo Yesusno ombuwoliyo. Ngundilo telo, yolo ombulo, enengo towikumba ngu donki duliyogaku sanganimo yomiwolo. Ngundilo yomitoyi, Yesusndo ngu sanganimo bibitewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yesusndo donki sanganimo bibitelo ooloutoni, asa, simoo baledo enengo nenggulo andangelo oolekana yomitoyi, donki ngu sanganiwoole oolouwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Yesus yade ombulo, Olib puliwoole oolegaku yokolo uwolo. Ngundilo utoni, asa, Yesus enengo sulena onikuya oni sungo ulungga nganoku nguya, ene Yesusndo bibitelo utoni, kenolo, ene oo bidodo onindo ma teweloyim ngu tetoni kenoyingoku, ngulo ingondudu telo, ngulo ene damoni yelo, Anut bingami elo okoolo, oni oni tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ngundilo telo, ene meno mogulu telo ewonggori. Noole enengo bingami elo okoowato! Anutndo kumana nga oni sobosobo koleteyingongga nga inootoni, ene Oo Bidodo Sembuli Ulungga, ngu oowooyimo ombuteku ngu! Oni bidodo Sambo endemo oolootenggoku nguya, ene komo Anut ulungga awuno oolengo oolooteku, ngulo oni oni teya, bingamini dulidalinidodo teyingo! Ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Yesuslo sulena onindo ali mogulu tetoyi, Parisi onindo kewooloyemo ootoolo, ngunonggo ngundilo yeyolo Yesusno ewonggori. Oo etuyeloyingo oni, gengo sulena oni kenggemo oni nga manggaluyeloya etooga, ali mogulu nga yokoyi! Ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ngundilo etoyi, ene Yesusndo gumi elo ewolo. No yeno hamoo eteno! Ene manggoye gosiyolo nenetetoyi ngu, ariya, digi melako nga enengombo elo moguluwoowanggo! Nondo nga oni nga manggoye ma gosiyelowano. Ene komo Anut oowooyi elo okoowanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","42","Yesus ende namoko tunootelo, ene Yerusalem ende kenondadangelo, oni simoo balelo sendolo ewolo. Ye Yerusalem oni simoo bale gowugowulongo! Nondo ombuwonomu ngu, ye nowoondoye imakeyingo damoni ngu, ye Anutya goboolo yeyi etoowe, ene ye ngulo ma ingondudu tetenggo. Ene ye yokootoyi, ngulo Anutndo oo doongeyemo oongooyunootoni, ye ma kenowonggo. Ene ataga ngu naluni kini teteku nga! ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ye ingoyi! Kootusina, nalu gula tunootewaku nguno, yengo longge oni ngu ombulo, ebe ulewelo pawayelolo, mele selo woodoo yelo, ende newendemo ulo ye bidodo pawayelolo yutomukowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ngundilo telo, ene ye yengo simoo namboye nguya yombuliyelolo yoyokowanggoku ngu, ngu nguya kowuli koolowoolo oluwanggo. Ene yengo digi gula yokootoyi, digi dobooyi sanganimo ma oluwa. Ndatelo ngulo, ye Anutndo nalu ngano ombulo yoyolo hoolooweyeloweloyi ngu ma ingowonggoku ngulolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ngu naluno, Yesusndo yambo ya oowooyi Tempel ngu newendemo ulo, simoo bale yeyondandangetoni, oo uliyolo yolo, oololo ombulo tetoyi, ngu oweyelootoni, oolelo sawonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Yesusndo elo ewolo. Anutlo mandeno ngandilo nakangowolo. Nolo ya ngu yemboongeweloyi ya nangge oluwa! Ewolo. Ngundilomu, ene yendo ngu yeyi yakaka onilo kombiteyingo digi wondokoyi ngundilo tetelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yesusndo nalu bidodomo, Tempel yano mande damoni gomemu elo etuyelolo oluwolo. Ene Anutno woolo yeyingo oni ngulo sobosobo mamana mande etuyeloyingo oni, ko, Yuda simoo balelo tabango oni, ngundo uleyi kumooweloyimbolo oole erewewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ene oni simoo bale bidodo Yesuslo mande ingoweloyimbolo yanggango yetoyi, ngulo ene teweloyi kini. Ngundilo ngulo, tabango oni ene Yesus uleyi kumooweloyi oole gula ma kenowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","2","Nalu gulano, Yesus Tempelno damoni gome etuyelolo, mande mesalango ngu simoo baleno wesiyolo elo oodoni, nguno Anutno woolo yeyingo oni, ngulo sobosobo, mamana mande etuyeloyingo oni, ko, Yuda simoo balelo tabango oni, ngundo Yesusno ombulo ewonggori. Ge nooleno e! Ge ndawu sunggiga geno oodoni, ge ngunonggo ngu kongga ngu tete? Onendo sunggi ge gunowo? Ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","4","Yesus enebana mande gumi ewolo. No nguya no mande gulalo ye sumoo yunowelo, ye nono eyi. Yondo sonoyeloyingongga ngu Sambo Endelomu, ngundi melako onilomu nangge, bine? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","6","Ariya, enengo nangge mandelo ingolo ewonggori. Sambo endelomu ewatoku ngu, enendo nooledodo ewa. Ndatelo ngulo, ye nowoondoyemo hamoo kinilo ewa. Noole ngandilo ewatoku ngu, oo melako oni simoo balelo ewatoku ngu, asa, simoo baledo sanggili telo, digi yolo, ngundo noole yuleyi kumoowato. Ene Yonlo ngu nowoondoyemonggo ngandilo hamoo ingootenggoku ngu, Yon ngu Anutlo ingondudu eyingo oni gulalo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ngundilo ngulo, ene Yesusno mande gumi ewonggori. Noole ma ingooteto. Ngu sono gemuyingo mandega ngu Yondo, ndanonggo yolo mayewololo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ngundilo etoyi, Yesusndo ngu oni tabango nguya gumi ewolo. Ngundilo nangge, no ndawu sunggigano ko tetenoku, ngu yeno ma ewanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Asa, Yesusndo ootookoolo, ene nga mande yamonggawongga nga simoo baleno ewolo. Nalu gulano, oni gulado Wayin kongga telo imiwonggori. Ene ngu Wayin kongga ngu, ene oni gidalegado sobowooya bobeye koyi teyilo ewolo. Ngundilo telo, ko sembuli ngu (Anutndo) ene toongelo, ende yowoko nalu pelungga nguno oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Wayin engge yoweloyi naluwomo, ko sembuligakundo ko oni gula suleyootoni, enengo Wayin kono ko oni ko tewootoyi nguno oolouwolo. Ko ngulo oo engge gula inootoyiga, yoya ombunilo suleyowolo. Ene kono ko onikundo ngu oninggaku dowoolo utolo suleyootoyi, kingo kande enengo oni ulunggaku tanggeyimo oolouwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ngundilo tetoyi, ko sembuligakundo ko oni gula suleyootoni oolouwolo. Kono onikundo ngunggaku nguya dowoolo utolo yokolo suleyootoyi, kingo kande enengo oni ulunggakuno oolouwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Oni ulunggakundo enengo ko oni tambu kabusayi ngu suleyootoni oolouwolo. Kono onikundo ngu ko oningga nguya utolo okoolo kanggaloko oolongootoyi uwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ngundilo tetoyi ngu, ko sembuli ngundo ingondudu telo ewolo. No ndatelo tewano? No nenengo nangone gulanangge (Yesus) no ngulo gome ingootenoku nga suleyootoowe oolouwa. Ene nenengo nangone kenolo ene sosolelo, enengo manggowo ingowanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ngundilo suleyootoni, ombulo, ene oni kono ko telo oluwonggoku, ngundo doongetelo, ko sembuli nangoni kenootoyi ombutoni, enengo nangge mandelo ewolo. Ngu oningga ngundo ngu kootusina eweyimbo oo ngu bidodo enendo yomukowa. Ngundilo ngulo, noole ataga ene uleye kumoowa. Ngundilo telo ngu, asa, nga kongga nga, ngu oode noolengo yowato. ");
INSERT INTO rwo_karo_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ngundilo elo, sobowootoyi ombutoni, dowoolo okoolo, kanggaloko oolongooyi utoni, owelo ulo nguno utolo, uleyi kumoowolo. Ariya, Wayin kongga ngu sembulibo ngu oniku ndatelo yunowa? ");
INSERT INTO rwo_karo_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Wayin ko sembuli, ngundo ngu ko oniku bidodo yuleni kumoomukootoyi, ngu Wayin kongga ngu oni sungo gidalega yunowa. Ngundilo etoni, ngu oniku ngu mandega ngu ingolo gumi ewonggori. Enengo ko sobosobo oni ngundo ngundilo damoni ngu ma tewanggolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesusndo yeyondandangelo ewolo. Ngu mandega Anutlo mandeno oolooteku, ngulo damoni ngu ndatelo? Nga Anutlo mande nakangoyingo ngano oolooteku ngu hamoo bine, asa, mande yamonggawo nguno ko oni biyomi enengo nangoni uleyi kumooyingo ngu nguya hamoo. Nga ya nomonimbolo osiyi ko onindo andangelo yokowonggo. Ngungga ngu ya nomonimbolo osiyi koletewolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Oni bidodo sungo sungo Kristus Yesus kootu inolo ngu, ene ngundilo telo, ene ya nomonimbolo osiyi, ngu sanganimo solelo, ene biyomi yewa. Ko biyomi tetoni, ngulo ngu Kristus ko uliyi gumi biyomi yunowa. Ngundilo nangge, ya nomonimbolo u osiyi koleteyingo, ngundo ngu oningga ngu sanganimo solelo utolo yombuliyootoni, sosolango oolengo yewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Mamana mande etuyeloyingo oni, ko, Anutno woolo yeyingo onilo sobosoboku, ngundo ngu ingowonggoku, ngu mande yamonggawongga nguno ko oni oo biyomi tewonggoku ngu, Yesusndo ene yosanggawelo ete. Ngundilo ngulo, ngu nalungga nguno nangge dowoolo uleyi kumoowelo telogo, ene oni simoo balelo sosolelo, ngulo yokowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Mamana mande etuyeloyingo oni, ko, Anutlo woolo yeyingo onilo sobosobo, ngundo Yesus uleyi kumoowelo oole erewelo, ngulo ene oni gidalega suleyelootoyi, ombulo Yesus kenondadangelo sobowoowonggori. Ngu oni ngu enengo damoniye biyomi ngu imangoolo, ene oni gome nenengo eya eyi, ebe ganagana tewonggori. Ene Yesusndo mande biyomingga etoningga, ngulo dowoolo, Gabman mande wilikoyunoyingo onino yeweloyimbolo ngundilo tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ngu onikundo Yesus sumoo inolo ewonggori. Oo etuyeloyingo oni, noole ingootetoku ngu, gengo mandege ngu gome nenengo oolengo. Ge Anutlo mande gome nenengo nangge oni simoo bale bidodomo etuyeloote. Ge oni goweye nangge ma kenolo ingoote. Kini, ge oni nowoondoye wilikoyelolo kenoote. Nguno noole ingootetoku ngu, gedo Anutlo mande hamoo nangge nenengo etuyeloote. ");
INSERT INTO rwo_karo_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ge ndatelo ingoote? Noole Gabman oni (Takis) bobeye inoweloyi ngu mete inowato, ngundi Anutno bobeye yewato, bine? Ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","24","Ngundilo etoyi, ene Yesusndo enengo mande ebe ganagana etenggoku, ngundilo ingoote. Nga oni ngando, ene no tewootewoonelowelo etenggo. Nondo gulalo etoowe ngu, asa, enendo nosina mande sanggawelo ewanggo. Ene ngundilo ingolo yokolo, enebana ewolo. Beye gula no etunelootoyiga kenoowe. Ngu Gabman tabango gabogaboyi, ko oowooyi nguno oolootekungga ngu, oone oowooyi nakangootoyi ooloote? Etoni, ngu enendo gumi ewonggori. Ngu Gabmanlomulo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Etoyi, Yesusndo ewolo. Ariya, Gabmanlo oo ngu Gabman inoyi. Anutlo oo ngu, Anut inoyilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ngundilo etoni, ene Yesus sodedo simoo bale doongeyemo dowooweloyi nguya kini. Ene bidodo Yesuslo mandeni ngulo ingondudu ulungga telo, ingoyingomu ngu nenengo, ngulo ene mandeni gumi gula ma ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadusi oni ngundo oni kumoolo ngu, ene ko ma ootookoowa, elo nowoondoyemo hamoo ingootenggo. Nalu gulano, Sadusi oni gidalegado ombulo Yesusno ngandilo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Oo etuyeloyingo oni, Mosesndo mande gula ngandilo nakangowolo. Oni bale yolo oode, ene simoongo kinimo kumootoni ngu, ene kootusina, koneyombo ngu balega ngu yolo, baleyi telo oluwa. Oode, nangoni telo, banembolo nangonilo ewa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ariya, oni simoongolo gula ngu kandegula gidembolo elaya oluwonggo. Koletelo bayega, ngundo bale yolo, simoongo kini oode kumoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ariya, elayayiga ngundo ngu balega ngu yolo oode, ene nguya kumoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Kootusina, ngu koneyali kabusayi oode ngu balega ngu yowolo. Ngundilo nangge, ngu oni simoongolo kandegula gidembolo elaya ngu bale gulanangge ngu yolo simooye kini, kingo yolo, oode kumoomukowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kootusina, ngu balega nguya simoongo kini kingo kumoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ariya, oni kumoononggo ko ootookooyingo naluno ngu, balega ngu kameyi oolengo ngu oone? Kuli ngu oni simoongologa ngu baleye gulanangge ngulolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ngundilo etoyi, Yesusndo mande gumi ewolo. Nga naluno ngano, ngu oni bale yolo, kameyi baleyi teweloyi damoni ngu tetenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ene oni bidodo Anutno nowoondoye hamoo teyingongga ngu, nalu wengamo, ene ko keda ootookoolo Sambo endemo oluwanggo. Ngu naluno ngu, ene ko ma ebe yoyootelo elambalisa ma tewali. ");
INSERT INTO rwo_karo_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Kini, nalu gulano, ko ma kumoowanggo. Nguno, ene Anutlo Engel oni ngundilo telo oluwanggo. Ene Anutlo simoongo telo oluwanggo. Ngundilo ngulo, Anutndo melenonggo yokutuyelootoni ko ootookoowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mosesndo nguya oni kumoononggo ko yokutuyelowa, elo etuyelowolo. Kulimi, Anutndo de bodagano de solu tunootelo ngunonggo Mosesno ngandilo ewolo. Ataga nga naluno ngano, no ngu gengo osi osingge Ebaraham, Ayisak, ko Yekob ngu Sembuye Anutlo ewolo. Anutndo Mosesya mande ewolo. Osi osingge kuli kumooyingomu, enengo gaboye ngu ataga Sambono keda oolootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Anutga ngu oni kumooyingo ngulo Anut kini. Kini, oni simoo bale Anutlo nowoondoyemo hamoo telo kumoowanggoku ngu, ngulo gaboye keda sugi sugi Yesusya oluwanggo. Anut doongeyimo ngu oni nowoondoyemo hamoo teyingomu, ngu ataga keda oolootenggoku, ko kuli kumooyingomu ngulo gaboye keda oolootenggoku ngulo Anut nguyalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Yesusndo ngundilo etoni, asa, mamana mandelo oni gidalegado mandeni gumi ewonggori. Oo etuyeloyingo oni, ge hamoo nenengo mande enggemo elo etelo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ngulo ene sosolelo, Yesus ko ma sumoo inowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesusndo ewolo. Onindo noya ngandilo etenggo? Kristus ngu Dewitlo osiyi nanggelo etenggo? ");
INSERT INTO rwo_karo_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Ene ngundilo elo ngulo Anutlo yambo bukno ngu Dewitndo enengombo Kristusdodo ewolo. Anut Oo Bidodo Sembuli Sembunaye, ngundo nolo Sembune ulungga ngandilo ewolo. Ge kandene koondosina bibite. Kootusina, gengo longge oni yoyewe gengo kengge damonimo wata yenggunowanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dewit enengombo ngu ewolo. Oo Bidodo Sembuli Sembunaye Ulunggalo ewolo. Ndatelo ngulo, enengo osiyi tewa? Ewolo. Dewitndo ngu ko uliyolo yoyoweloyi oni tunooteweloyiga, Kristus, ngulolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ngu naluno, oni simoo bale bidodo oode, Yesuslo mandeni ingootoyi, Yesusndo enengo sulena oninolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Ye mamana mande etuyeloyingo oni ngulo ingondale teyi! Ene towikumba pelu pelungga yemulo endeyowelo gome ingootenggo. Ene gobooyingo musiyomo simoo baledo bingamiye elo okooweloyi, ngulo gome ingootenggo. Ene yambo yano oni doongeyemo, amuno koletelo bibitewelo gome ingootenggo. Ene oo simbo ulungga kayingo naluno, yaba koleteyingo nguno bibitewelo nguya gome ingootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Oni doongeyemo ngu oni nenengo gome, ene nowoondoyemo ngu Anutlo ma ingootenggo. Ngulo, ene bale nggami ngu ganaganayelolo yemboongeyingo pelu pelungga tetoyi, Anutndo bale nggami ngu hoolooweyeloni, elo tetenggo. Ene tolige kombi telo, nguno bale nggami ngulo ya, oo sitowi bidodo ganaganayelolo, siyakiyolo yoyunootenggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesus doongetelo yeyootoni, oni bobeye sitowiyedodoku Anutlo yambo yano (Tempel) Pawusno bobeye ulungga kingo duwoo yetoyi yeyowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ene bale nggami sumbuyiga nguya kenowolo. Ngundo enengo bobeye bobodi elayagaku ene ela elaya yolo, oololo Pawusno yewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ngulo Yesusndo kenolo ingolo ewolo. Hamoo oolengo no yeno eteno! Nga bale nggami, ngando oni pawusno bobeye ulungga yetenggoku, ngu dagayelolo, enendo ulungga oolengo yete. ");
INSERT INTO rwo_karo_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ndatelo ngulo, oni nga bidodo ene bobeye ulungga enengo yano ooloote. Ene ngunonggo gidalega andangelo, yolo ombulo, Anutlo koni ngulo yetenggo. Ene nga bale nggami nga, ngu ene hamoo ooni kini. Ngundo enengo bobeye ngu bidodo yolo ombulo yete. Ene oowali uliyolo neweloyi gula kinilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","6","Yesuslo sulena oni gidalegado yambo ya oowooyi Tempel ngulo mande ewonggori. Nga Tempelga nga, ngu onindo kuli digi oo gome nakayaye yelo oo ngu kingo sumangeno Anutno yetoyi, ngundo ngu Tempel ya nakanakangoyingge tewonggori. Etoyi, Yesusndo ingolo gumi ewonggori. Ngu oo ngu ataga kenootenggoku ngu, nalu gula tunootetoni, digi gula yokootoyi, digi gula sanganimo ma oluwa. Onindo ngu bidodo usosowoolo, dolowooyi melako uwanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ene Yesus sumoo inolo ewonggori. Oo etuyeloyingo oni, ngu ooga ngu ndadi tunootewa? Ngulo naluwo namoko tetoni, noole ndawu sunggiga kenolo, noole nguno ingowato. Nalunggaku namoko tete, elo ingowato? Ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ngundilo etoyi, Yesusndo mande gumi ewolo. Ye komo ingondale teya oodoyi, oni sungombo ye ma ganayelowanggo. Kootusina, no oowoonemo, oni oowooyingga oolengo mayelo, ye ganayelolo ewanggo. No nga Anutndo noole yoyowelo sunggi yeyingo oningga nga nangge, Kristus gula kini. Ngu hamoo! Nalu namoko tetelo ewanggo. Ye ngundilo ingolo ngu, ye oololo, ngu ma keyolo oolouwelo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kootusina, me ebe ulungga teweloyi mande binga ye ingowanggo. Oni longge ebe nguya telo, nowoondoye sungo sungo yelo, bulibali oodoyi, ye ngu ingowanggo. Ye ngulo ma sosolewelo. Oo ngundilo ngu bidodo koletelo ombumukolo yokowa. Nalu wenga, ngu nalunggano, nguno sodedo ma tunootewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Asa, ngu naluno, Yesusndo ngu mande ngu soweyolo ewolo. Oni sowe gulado ootookoolo, oni sowe gidalegaya ebe longge sambi telo, ebe ulewanggo. Melako ngalo sobosobo oni gulalo keyimo onindo ootookoolo, sobosobo gulalo keyimo oniya ebe kendukendu telo, ebe ulewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Imimi ululumu nangge mela nga dowoolo yokutuwoowa. Mela ngano, oowalilo kumooyingo ulungga oolengo tunootewa. Sayi ko oo biyomi ululu mela gulano gulano nguya tunootewa. Sambono oo sosoleweloyi sunggi guladilo guladilo nguya tunootetoni kenowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ene oo ngu ma tunooteyingomo nguno ye nolo nowoondoyemo hamoo tetenggoku ngulo, onindo ye yodowoolo, ye kowuli oowooyingga yunowanggo. Ene ye yoyolo, goobooyingo yano mande wilikoyingo onino yoyewanggo. Wilikoweloyi musiyomo, yoyolo, ya biyomimo yoyewanggo. Mela ngalo oo sobosobo onino, ko, Gabman onino nguya yoyolo ooloutoyi, ngundo yengo mandeye nguya wilikoyunowanggo. Ngu oo ngu bidodo no oowoonembolo yeno tewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ngundilo teyunootenggoku oni nguno, ngu ye Anutlo mande keda mesalango ngu eweloyimbolo ooleyi yetenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mande nga nowoondoyemo nakangootoyiga nguno olini. Yeno ngundilo damoni ngu ombuwelo tetoningga ngu, ye nowoondoye bulibali ma ingondudu telo ewelo, noole ndatelo ewatolo ma ingowelo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ndawugalo ngulo, no nenengombo manggoye yewe tango yetoni, mandeye ingonduduye nguya yewe himi yetoni, ingondudu gome ye yunowano. Yengo longge oni, ngundo yengo mandeye ngu ma utolo, oolongoolo yokowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ngundilo nangge, ene nolo nowoondoyemo hamoo tetenggoku ngu, kootusina, yengo awanamoye, konebaye, yengo sowisawi, dobooguliye, ngu bidodobo ye yoyolo, mundi onino yoyetoyi, onindo ye gidalega yuleyi kumoowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Oni gula gulado yeya nowoondoye biyomi oolengo yewanggo. Ndatelo ngulo, no oowoone ngu yeno oolooteku ngulo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ene yengo tabayemo uye gulanangge nguya ma oonatewa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ye yanggango ootoolo ngu, yengo keda suwoo suwoo sugi sugi oluweloyiga ngu yowanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Yesusndo mande gula ewolo. Ye Yerusalem kenootoyi, me oni mayelo, ngundo pawangolo woolilingootoyiga ngu, ye nguno ingoyi. Yerusalem ende yombuliyoweloyi naluwo namoko tete, eya ingoyi. ");
INSERT INTO rwo_karo_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Asa, ngu nalungga nguno, oni Yudiyano oolootenggoku ngu, ene sodedo saya, mela pupulimo kombiteyi. Oni Yerusalem endemo oolootenggoku ngu, ene mela sungomo sayi. Oni Yerusalem dabemimo deguno oolootenggoku ngu, ende newendemo ma uwelo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ngu nalungga ngu, Anutndo mbumbuwa gumi yunoweloyi naluwolo. Ngundilo ngulo, mande bidodo Anutlo mandeno oolooteku ngu, engge yeni tunootewa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ngu nalungga nguno, bale useyedodo, ko, bale simooye owita nono netenggoku, ngu naluno, oni oniyooge! Kowuli ulungga oolengo nga melanggano ngano tunootewa. Anutlo sanggili nga oni simoo baleno ngano ombulo kuduwooyunowa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Me onindo dugebo yootoongoowanggo. Me onindo gidalega yoyolo, enengo melako salo, ya biyomimo yoyetoyi, nguno oluwanggo. Oni sowe gidalegado Yerusalem ende yanggango sugi sugi soboyelolo, yombuliyelolo oodoyi, oololo, Anutndo me ebe yeni, kiniteweloyi naluno yokowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Yesusndo mande gula ewolo. Kootusina, Sambono sano, kombono, dootuno nguya sunggi guladilo guladilo tunootetoni kenowanggo. Melako oni simoo bale nowoondoye bulibali ingolo, hahangelo ingowatoku oolengo tewanggo. Ndatelo ngulo, wendeyi nguya ulungga ulungga dokelo, tuwi telo ngguyi ulungga oolengo utoni ingolo, ngulo sosolewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Oo kowuli ulungga ngundilo melako ngano ombuwelo tetoni, ngulo oni simoo bale sosoleyingo ulungga oolengo telo, ngulo ingondudu tewanggo. Nowoondoyemonggo ngundilo sosoleyingo ulungga telo, Sambono dootu oo ngu kenootoyi, pipalelo, mboolomboolo tetoyi, ngu kenolo, doongeye toongootoni, gaboye kumoowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ngundilo oo ngu tunootetoni ngu, asa, Oni Nangoni ngu goobooleno ombutoni kenowanggo. Ngundilo ombutoni ngu, enengo yanggangoni, bingami ko dulidalini ngu bidodo kenowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kootusina, oo ngu tunootewelo tetoningga ngu, ye ootookooya, dikaya, sambosina randoya doongeteyi, Anutndo ye ko yoyoweloyi nalunggaku tunooteteku ngu! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesusndo mande yamonggawo gula elo ewolo. Ye Kopi dega ngu kenoya, ko, de gidalega nguya yeyoyi. ");
INSERT INTO rwo_karo_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ye kenootoyi, nungo yelo, busiyo yetoni, ye ngu kenolo ingootenggo. Ataga Kopi enggeweloyi naluwo tunootewelo tetelo ingootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ngundilo nangge, ye nga oo kowuli etenoku nga, tunootetoningga ngu, ye nguno ingoyi! Anutndo oo bidodo sobowooweloyi nalunggaku, ngu kuli namoko tete, eya ingoyi. ");
INSERT INTO rwo_karo_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Elo, Yesusndo mande soweyolo ewolo. Hamoo oolengo no yeno eteno! Ataga nga naluno, ye Yuda sowengga ngalo simoo bale nga ma kumoomukoyingomo, nga oo nga bidodo tunootewa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Sambo, mela nga, ngu oololo kinitetoni, ene nolo mandene nga, ngu sugi sugi oluwalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","Ngu naluno, Yesusndo ngandilo ewolo. Ene yengombolo ingondale teyi! Kinitetoni ngu, ye sono kowoo nelo (biya), ye suwoo suwoo wenonolo oluwanggoku, ye goweye oo gula gulalo ingonduduyemonggo ngulo hahangelo oode ngu, damoni ngundilo ye wiliyelowaku, ngundilo telo oodoyi ngu, asa, ngu nalungga ngu sodedonangge tunooteweloyi, ngu sepando sodedo nusago uleteku ngundilo oolengo tunootewa. Ngu nalungga ngu mela bidodomo oni oolootenggoku, nguno kowuli ngu bidodomo tunootewa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Suwoo suwoo, ye komo sobowooya, doongedoongoodoongoo teya, ye komo Anutno yanggango oluweloyi, ngulo yemboongeya oliyi! Ndawugalo ngulo, oo kowuli kootu tunooteweloyi, ngulo Anutndo ye yanggango yunootoni ngunonggo yanggango dikaya ngunonggo nowoondoye hamoo teyingongga ngu ma yokowelo. Kootusina, ye Anut Onilo Nangoni ngu doongeyimo dikawanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Nalu bidodomo, Yesusndo Tempel ya newendemo simoo bale Anutlo mande etuyelolo oluwolo. Ene suwoono ngu, Yesus oololo, Olib, mela pulinggano nguno wetolo oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Oni simoo bale bidodo suwoononggo oolengo ootookoolo, Yesuslo mandeni ingoweloyimbolo, Tempel yano ngu newendemo ulo oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Oomanangoyingo koongeweloyi ooga oowooyi Yis kini kingo kayingo ngu oowooyi Pasowa naluwo, ngulo simbo kayingo kundingiyi tunootewelo tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Anutno woolo yeyingo oni kundingiyi ngulo sobosobo, ko, mamana mandelo etuyeloyingo oni, ngundo Yesus uleyi kumoowelo erewewonggori. Ene ngundo oni simoo bale sosolelo ngulo ene ereremo kini. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Setando Yudas Iskariyoot newendemo uwolo. Yudas Yesuslo sulena oni kegidembolo elayaga ngulomu gula. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ngu Yudasga, ngundo oololo, Anutno woolo yeyingo oni kundingiyi, ngulo sobosobo, ko, Tempelno kumba ootuwoo onilo tabango nguya mande elo, oole erewelo kenolo, ngunonggo Yesus ngu oni tabango ngu kandeyemo windoga damoni telo yunowa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Damoni telo yunowelo, ene etoni, ngulo tabango oni ene oni oni telo, nowoondoye gulanangge yelo, ene Yudas bobeye inowelo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ngundilo tetoyi, Yudasndo ngu metelo ingolo, asa, ene oole ndatelogano Yesus yolo, tolige ngu oni tabango ngu kandeyemo yewelo, oole erewewonggori. Nalu gula oni simoo bale oowooyingga kini, ngu naluno ngu, yootunowelo sobowoolo oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Oomanangoyingo koongeweloyi oo kini kingo kayingo naluwo kundingiyi, Pasowa, ngu tunootewolo. Ngu nalunggano nguno, ene Sipsip nangoni woolo yeweloyimbolo ulewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ngu naluno, Yesusndo Pita, Yon, elaga suleyelolo ewolo. Yali oolouya, noolengo Pasowa yomosiyootoliga, noole nguya oo newatolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ngundilo etoni, Pita, Yon elagado, Yesusno gumi ewoliyo. Noole ndano oo ngu yomosiyowalo? Ewoliyo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Etoni, Yesusndo elayagakuya gumi ewolo. Ingoli! Yali endemo oololo, ya oni gula kumbe ulunggano sono moondoya koolowooya ombutoningga ngu, yali ngu keyoya oolouya, enedodo ya newendemo uli. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Yali ya sembuliga nguno eli! Oo etuyeloyingo oningga, ngundo geya ewolo. Nolo ya gumi ndano, no nguno nenengo sulena onidodo Pasowa oo newato? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Nguno ngu, ene ya gumi ulungga awu sanganimo ngu etuyelowa. Nguno ngu, oo neweloyi yaba ko bibiteweloyi yaba nguya oolooteku ngu! Yali ngu ya guminggano nguno Pasowa oo yomosiyolilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ariya, sulena oni elayagaku oolouwoliyo. Pita, Yon elaga oololo, Yesusndo oo ewoku, ngundilo kenolo, nguno Pasowa oo ngu yomosiyowoliyo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Pasowa naluwo tunootetoni, asa, Yesus ko enengo sulena oni nguya oo neweloyi yabano bibitewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ngu naluno, Yesusndo ewolo. No nga Pasowa nga yeya newelo gome ingolo hahangelo oolooteno. Ngundilo telogo, asa, no ogingoyingo kowuli ulungga ngu koolowoowano. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","No yeno eteno. No ngalomu ko ma nelo, ngu ooga ngu engge tetonigo, ngu Anutlo endega sobowooteku newendemo nguno ko newanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","18","Ngundilo telo, Yesusndo sono tobaga yolo dowoolo, Anutno esetelo, yemboongelo yokolo ewolo. Ye nga yoya, bayeteya neyi. No yeno eteno! No kootusina, Wayin sonoyi ngalomu ko ma nelo, Anutlo nalungga sobowooteku tunootetoni, ngu nalunggano nguno, sono ko newanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Yesusndo ngundilo elo, ene oomanangoyingo yolo, Anutno esetelo, yemboongelo yokolo, oososowoolo yunolo ewolo. Nga ngu, nenengo gowene nondo ye hoolooweyeloyingo yunooteno. No yengo mbumbuwalo kumoowano. Ngulo ye nelo ngu, nolo ingondudu telo oluwanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Oowali nelo yokolo, ene sono tobaga yolo ngundilo nangge dowoololo ewolo. Nga sono tobaga nga, ngu nolo dalone ngu ye hoolooweyelolo wendooteno. Nga dalonengga nga, ngu sunggi mande keda Anutndo enengo oni simoo baleyalo gosiyoote. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ene ye nga ingoyi! Oni no yootunonelolo longge oni kandeyemo yeweloyi oningga ngu, nga noya yabano bibiteteku nga! ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Yo, Oni Nangoni ngu, kuli Anutndo ooleningga sunggi yeyinoyingongga ngu keyolo, ngundilo nangge tewa. Ene oni ngu yootunolo, longge oni kandeyemo yetekungga ngu, oniyooge oolengo! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Yesusndo ngundilo elo etoni, ngulo sulena onikundo enengo nangge sumoo sumoo telo ewonggori. Onendo ngu mandega ngu tewa? Ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ngu naluno, Yesuslo sulena onikundo enengo nangge longgeyolo ewonggori. Onendo noole gidalega dagayelolo, enendo oni ulungga oolengo telo, koleteyingo oluwa? Ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesusndo enengo mande ingolo ewolo. Oni sowe gidalega, Yuda oni kini, ngulo oo bidodo sobowooyingo oni koleteyingo ngu, ene oni yanggango oolengo telo, oni gidalega yowongolo, enendo nangge ululu telo oluwanggo. Enengo oni ulungga, ngundo enengo melako soboyelooteku ngu yoyeni, Oni Sumangeyi Damoni Metemi Teweloyi Oni, eya eyi. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ene yendo ngundilo ma tewelo. Kini, oni gula ene ye kewooloyemo oni ulungga telo, ene dagayelolo oluwelo ewaku ngu, ene ombulo enengo newendemo ngundilo ingolo, (oni sungo hoolooweyelootooga, ngundo no oowoonengga ngu daganelootelo ingowonggori. Ene oni tabangongga ngu, ene ombulo, ye hoolooweyeloyingo oni telo, sulena yunowa.) ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Oni onendo gidalega bidodo dagayelolo ulungga oolengo ooloote? Oni ene oowali nelo bibiteteku nga, bine, ngundi, ko oni oowali yomosiyolo yolo ombutekungga ngu, bine? Ye kuli ingootenggoku, ngu oningga bibitetekungga ngu! Ene no ngu ye kewooloyemo hoolooweyeloyingo sulena oni nangge oolooteno. Ye oni tabangongga ngu, ene ombulo ye hoolooweyeloyingo oni telo, sulena yunowa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Kuli, ye ngu no tewootewooneloyingo nalu nguno ngu, ye no ma noyokolo sawonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","No Awanembo oni simoo bale bidodo sobowooteku yanggangoni no nunowolo. Ngundilo nangge, nondo nguya ngu yanggangoningga ngu ye yunooteno. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ngundilo tetoowe, Sambo endemo ye mete nolo yaba oo neweloyi nguno bibitelo, noya oowali, sono newato. Ngundilo telo, ye mande wilikoweloyi yaba metemimo nguno bibitelo, Iserel oni sowe kande elaya kegidembolo elayaga ngulo mandeye damoniye wilikoyelowanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesusndo ewolo. Sayimon Pita, ge ingo! Setando ye sulena oni bidodo yoyolo yodowoolo tewooyelowelo meno elo, boguboguwoolo ooloote. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ene nondo ge hooloowenggelolo, Anutndo ge yanggango gunoni, elo yemboongewonoku ngu, gengo nowoondogemo hamoo ngu ma yombuliyolo yokowelo. Ge kootusina, nowoondoge ko yowoolengootoni, gengo doboogulige yanggango teyunoyingo mande yunowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ngundilo etoni, Pitando Yesusno mande gumi ewolo. Oo Bidodo Sembuli Sembunaye ulungga, no hamoo oolengo, no kuli yoonenengolo oode, no komo geya ya biyomimo oololo, nguno goboolo kumoowalolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesusndo Pitaya mande gumi ewolo. Pita, no geno eteno. Ataga, nga suwoonggano ngano, kootoori ma eyingomo, ge tambu kabusalo ewa. No Yesus oningga ngu no watayi kini elo, no oongoonelowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ngu naluno, Yesusndo sulena onino ewolo. Kuli, no ye suleyelootoowe toongewolo. Ngu naluno nguno, ye bobeye sili, yengo kingo si, ko keye goweyi nguya ma yowonggori. Ngu nalunggano nguno, ye oo gulalo ingolo wenonoyingo, bine, ngundi kini, bine? Etoni, sulena onikundo mande gumi ewonggori. Kini. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Etoyi ngu, Yesusndo ngandilo ewolo. Ene ataga nga, ngu oni gula ene bobeye siga tetoningga, ngu yoni, ko enengo si nguya ngundilo nangge yoni. Ene oni duge gula kinitetoningga ngu, ene komo enengo nengguloga andangeya, oni sungomonggo dugega uliyoya yoni. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ndatelo ngulo, Anutlo mande ngundo no gowenemo engge yeni tunooteweloyi, ngulo ewolo. Ene oni biyomidodo gooboongoowanggo. No yeno eteno. Ngu mandega ngu komo no bungomo engge tunootewa. Yo, Anutlo mande bidodomo ngu nolo eyingoku ngu, ataga engge yeni tunootewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ngundilo etoni, sulena onikundo ewonggori. Oo Bidodo Sembuli Sembunaye ulungga keno! Duge elaya oolooteku nga! Etoyi, Yesusndo mande gumi ewolo. Ngu mete, nguno yokoyilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ngu naluno, Yesus ene ootookoolo, ende yokolo, Olib, pulimo oolelo, ene suwoo suwoo teteku damoningga ngundilo telo yemboongeweloyimbolo. Yesus enengo sulena oniku enebana ootookoolo, keyolo oolouwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ene ngundilo ooloutoyi, Yesusndo nguno tunootelo, sulena onino ewolo. Ye komo Anutno yemboongetoyi, Anutndo nowoondoye yanggango inootoni, ye tewootewoono ma kiyayi yewanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","42","Yesusndo mande elo, ene sulena oni yoyokolo, ene musiyo sungosina, sungo oololo, nguno bodowo oondookelo, mela sanggawelo bibitelo, Anutno ogingoyingo ulungga koolowoowanoku, ngulo yemboongelo ewolo. Awa, ge etoyi ngu, nga sono tobaga nga ombulo daganelowa. Ene nolomu kini. Awa, ngu gengomu nangge. Gedo etoyi, no komo ngu nangge keyolo tewanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ngundilo yemboongetoni, Anutlo Engel oni gula Sambononggo Yesus tanggeyimo ombulo, tunootelo, yanggango inowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yesus newende kowuli ulungga oolengo ingolo, ene yanggango yelo yemboongelo oluwolo. Ngundilo telo oodoni, nosilili ulungga dalo ngundilo tunootelo, ombulo melako uwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Yesus ngundilo yemboongelo yokolo, ootookoolo, sulena onino oololo, yeyootoni, kubooyelootoni wetolo oodoyi yeyowolo. Ene ngulo nowoondoye biyomi ingolo kowoo yetoni, ngulo ene wetolo oluwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Yesusndo ngundilo yeyolo ewolo. Ye ndatelo telo, ngulo wetolo oolootenggo? Ye ootookooya, yemboongeyi! Ye ngundilo telo ngu, Setanlo tewootewoo ngu yeno ombutoni, yanggango telo, enengo ingonduduni ma keyowanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesusndo sulena oniya mande ewoodoni, me oni endega mayewonggori. Ngu Yudasga ngu Yesuslo sulena oni kande elaya kegidembolo elayaga (12) ngulo gula, ngundo koletelo yunolo ombulo, Yesus dowoolo yenggonangolo, duleyoweloyimbolo ombuwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ene ngundilo yenggonangootoni, Yesusndo ewolo. Yudas, ge Oni Nangoni yenggonangolo mududu, nguno yootunolo, longge oni kandeyemo yelo, yunowelo bine, ombute? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Yesus ene sulena onikuno enedodo oluwonggoku, ngundo longge onindo Yesus ndatelo teyinowanggo, elo kenolo ewonggori. Ulungga Oo Bidodo Sembuli Sembunaye, ge etooga, noole dugebo nga yulewato, bine? Ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ngundilo etoyi, sulena oni kewooloyemo gulado Anutno woolo yeyingo oni tabango gulalo ko oni gula utolo, sodeyi gidalegasina takatoni solewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ene Yesusndo ngu kenolo ewolo. Ye ngundilo mande damoningga ngu yokoyi! Yesusndo ngundilo elo, kandeyi ngu oni sodeyigaku yolo yetoni, ko mete tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","53","Asa, Yesusndo Anutno woolo yeyingo onilo sobosobo, yambo yano kumba dogoni onilo sobosobo, ko, Yudalo tabango oni gidalega nguya ewolo. Ye yakaka oningga dowoowelo ngulo ye duge, so, mata komukododo ombutenggo? Nalu bidodomo, no yeya Tempelno oolootetoku, nguno ye ma nodowoowelo ngulo, ene ataga nga nalungga nga, ngu yengo nalu! Setanlo yanggangoni ngu ngano tunootetelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Yesusndo ngundilo elo yokootoni, onikundo dowoolo, yolo oolouwonggori. Yesus yolo, yade oololo, Anutno woolo yeyingo onilo tabango ulunggakulo yano uwonggori. Pitando ngu keyelolo bodaga yowokoyi sungo oolouwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ngu yangga ngu yasiliko de kalo yokowelo kawonggori. Ngu degaku yokolo bibitetoyi, Pita nguya ombulo, nguno enedodo de yokolo bibitewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ngundilo telo, sulena bale gulado Pita kenootoni, ombulo, de yokolo bibitetoni, gome gome kenondadangelo ewolo. Ge nga oningga nga nguya kuli Yesusndodo endeyowolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ene Pitando imangoolo ewolo. Ayi, ngu no kini! Ge nga balega ngando ebe ganagana ete! No ngu oningga ngu ma ingooteno! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Asa, bodaga nguya oode, oni gulado Pita kenolo ewolo. Ge nguya ame oningga amelo keyimo oni gula! Etoni, Pitando sodedonangge gumi ewolo. Ge ebe ganagana ete! No kini! No ngu oningga ngu ma ingooteno! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Nalu bodaga nguya oode, oni gulado Pita bungomo kandedisi telo, mande yanggango elo ewolo. Hamoo! Nga oningga nga, ngu enedodo endeyolo oluwolo! Ene nguya Galili oni! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Asa, Pitando mande yanggango gumi ewolo. Ge nga oningga nga, ge ndatelo ete? No ngu oningga ngu watayi kini! Pita ngundilo etoni, sodedonangge kootoori ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ulungga Oo Bidodo Sembuli, Yesusndo yowoolengolo, Pita gome kenowolo. Pita ngundilo kenolo, ene kuli Ulungga Oo Bidodo Sembuli Yesusndo ewolomu, ngu ingondudu tewolo. Yesusndo ngandilo ewolo. Nga suwoongga ngano kootoori ma eyingomo, ge ewa. No ngu oni Yesusga ngu ma ingootenolo tambu kabusa ewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ngu ingonduduwoolo Pita ootookoolo, endesina oolelo, ya kootusina oololo, sendolo biyobiyomi tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ngu naluno, me oni Yesus dowoolo kerekasi telo, yumooyinolo ulewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Towimbo Yesus doongeyi doobengolo ewonggori. Ge Anutlo ingondudu eyingo oni tetoningga ngu, asa, oni gulootekungga ngu omukumundoongo nenengo kenoya e. Ngu onendo gulete? Ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ene mande ngundilo oowooyingga oolengo elo, nguno yumooyinolo mande biyomi elo yombuliyowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Sengetoni suwoononggo, Iserel onilo tabango oni, woolo yeyingo onilo sobosobo oniku, ko, mamana mande etuyeloyingo oni ngu gooboongoolo oodoyi, nguno Yesus yolo, mande wilikoyingo onino oololo, yeyi dikatoni, sumoo inolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","69","Ge nooleno e. Ge Kristus, bine, ngundi kini, bine? Etoyi, Yesusndo mande gumi ewolo. Nondo yeno etoowe ngu, ye nowoondoyemo hamoo ma tewanggo. Nondo ye mande gidalegalo sumoo yunootoowe ngu, ye ngu mandega ngulo gumi yootunolo ma ewanggo. Ene ataga ngano ko kootusina nguya, nalu bidodomo Oni Nangoni ngu, ene Anut yanggangonidodo, ngu kandeyi koondosina bingamidodo bibitelo oluwalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Asa, ngu oni ngu bidodo sumoo ewonggori. Ngundilo ngulo, ge Anut Nangoni, bine? Ewonggori. Ngundilo etoyi, Yesusndo gumi ewolo. Yengombo etenggoku ngu nangge, no Anut Nangonilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Enengo mandeni elo ingolo ewolo. Noole ndawu mande gula ewato? Enengo manggowoobo mande nenengo etoni kuli ingooteto. Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Oni bidodo oolengo ootookoolo, Yesus yolo, Yuda mela (Rom Gabman) ngulo tabango ngu oowooyi Payilatno oolouwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Nguno ene Yesus kingo ganangolo goweyi sanggawelo mande damoni yelo ewonggori. Noole nga oningga nga kenootooye, ene ende ende noolengo oni ganaganayelolo endeyoote. Ye (Gabman) bobeye ma inowelo elo, noole soleyelolo ete. Ene ngundilo nguya ete. No ngu Kristus, mela ngalo oo bidodo sobosobo oni koleteyingo, etelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Mandeye ngundilo ingolo, Payilatndo Yesus sumoo inolo ewolo. Ge Yuda onilo oo bidodo sobosobo koleteyingo, bine? Ewolo. Ngundilo etoni, Yesusndo mande gumi ewolo. Gedo eteku ngu nangge, no Yuda onilo sobosobo koletewololo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ngundilo etoni, Payilatndo oni simoo baleno, ko, Anutno woolo yeyingo oni ngulo sobosobo oniku, ngu bidodomo elo ewolo. No nga oningga nga, goweyimo mande kowuli biyomi gula ma kenootenolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Etoni, ene meno manggalu telo ewonggori. Ene Yudiya mela nga bidodomo oni simoo bale ganaganayelolo endeyoote. Ene Galili melako andunonggo ngundilo telo, yade yade ngano mayewololo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Payilatndo ngu ingolo simoo bale sumoo yunowolo. Nga oningga nga Galili oni, bine? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Yesus ngu Galili mela ngulo oni ngu ingolo, ngulo ene Yesus suleyootoni Herod tanggeyimo oolouwolo. Herodndo ngu Galili melangga ngu sobowooteku, ngulo suleyootoni, eneno oolouwolo. Ngu nalunggano nguno, Herod nguya Yerusalem endemo nguno oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodndo Yesus kenolo, ngulo ene oni oni telo, newende gome ingowolo. Ndatelo ngulo, ene kuli Yesuslo mandeni etoyi ingolo, ene komo kulimimonggo kenowelo ingondudu telo, ene damoni sungo gula onindo ma teweloyim, ene doongeyimo tetoni, kenolo, ingoweloyimbolo ingololuwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ngundilo ngulo, Herodndo oo gula gulano Yesus sumoo sumoo inowolo. Ene Yesusndo Herodlo mande gumi gula ma ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Anutno woolo yeyingo oni, ngulo sobosobo oniku, ko mamana mande etuyeloyingo oni, ngundo ombulo, Yesus bungomo mande ebe ganagana ulungga oolengo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodndo enengo me oniku, ko enengo keyimo oni ngu bidodo, Yesus yumooyinolo mande elo mukendolo, oni biyomilo ewonggori. Ngundilo ngulo, ene towi nenggulo gula nakanakangoyingo gomengga yolo, Yesus yemuyinolo ewolo. Kenoyi! Mela ngalo sobosobo koleteyingo ulungga tunooteteku nga! Elo yumooyinolo yolo, Payilatno ko suleyootoyi oolouwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Kulimi Herod, ko Payilat, elaga ngu, mundi mundi telo oluwoli. Ene ataga ngano ngu, ene dobooyelo siyelo oolooteli. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Payilatndo Anutno woolo yeyingo onilo sobosobo oniku, ko simoo bale, Yudalo tabango galo, ngudodo negoyelootoni ombulo gooboongoowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Payilatndo elo ewolo. Yendo nga oningga nga yolo, nono ombuwonggo. Nga oningga ngando simoo bale ganaganayelolo endeyootelo ewonggo. Ene nondo ngu mandega ngulo yengo doongeyemo nenengo sumoo inowonoku ngu, ye ingoyi! Nondo ngu yendo enedodo mande etenggoku ngu wilikootoowe, eneno biyomi gula ma kenooteno. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodndo nguya ene ko suleyelootoni, noolengomo ko ombuteku nga! Ngulo ye ingoyi! Oo biyomi gula ene ma tewolo. Nguno noole nguya ene ulewe kumooweloyi oo biyomi gula eneno ma kenowolo. Payilatndo ngundilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ngundilo ngulo, nondo gisalu sanggilidodo ngundo utolo, gisalu yokootoowe, ene toongewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ngulo Yudalo damoni ngandilo oolooteku, nalu kundingiyi bidodomo, Payilatndo ya biyomimonggo oni gulanangge nangge andangetoyi toongete. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ngundilo telo, oni simoo bale bidodo meno manggalu telo ewonggori. Ngu oningga ngu utooga kumootoningga, ge Barabas andangeyuno! Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ngu Barabas oningga ngu, ene kuli (Gabman) oniya me yeni tunootewolo. Ende kewooloko oni gula uleni kumootoni, ngulo ene dowoolo ya biyomimo yewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ariya, Payilatndo mande elo ko eyingo, ene Yesus yokootoni, toongeweloyimbolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ene meno manggalu telo ewonggori. De mombimo sanggawega kumooni! Ngu ma yokootoyi oluwelo, sanggawega kumooni! Meno elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Payilatndo tambu kabusayi sumoo yunolo ewolo. Nga Yesus oningga ngando ndawu oo biyomingga tewoku, ngulo noole ene ulewe kumoowa? Nondo ene goweyimo mande biyomi gula ma kenooteno. Ngundilo ngulo, nondo nangge utolo, gisalu sanggilidodo, ngundo gisalu yokootoowe toongewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ene yanggango oolengo yelo, Payilatlo mande utolo wiliyolo meno mogulu telo ewonggori. Kini, de mombimo sanggaweya uto! Ngundilo meno elo, ngundo Payilatlo manggowo wiliyowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ngundilo tetoyi ngulo, Payilat ene ko mande gula ma ewolo. Ene simoo bale manggoye keyolo, ewonggoku, ngundilo nangge tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ngu oningga, (Gabman) ebe utolo oni uleni kumootoni yolo, ya biyomimo yeyingongga ngulo simoo baledo ewonggori. Mande ewonggoku, ngundilo nangge, Payilatndo Barabas andangetoni toongewolo. Ene meno manggalu telo etenggoku, ngulo Yesus ngundiya teyinoyi elo, me oni kandeyemo yelo yunowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ene Yesus yolo oolouwonggori. Ene oni gula oowooyi Sayimon ngu Sayirinya mela ngulo, ene oole ngundilo ombulo ende ulunggano nguno uwelo tewolo. Me oni ngu oningga ngu dowoolo de mombigaku ngu mooleyomo yetoyi, ngundo koolowoolo, Yesus keyiwoole oolouwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Simoo bale oowooyingga oolengo ene keyolo ooloutoyi, bale oowooyingga oolengo nowoondoyi telo, ngengeyolo sendolo keyolo oolouwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","31","Ene Yesusndo yowoolengolo ewolo. Ye Yerusalem bale, ye nolo ma sendowelo. Kini, yengom, ko yengo simooyembolo nguya sendoyilo ewolo. Ye ingoyi! Kootusina nalu biyomi oolengo gula tunootewaku nguno, bale ninggooteyingomu, bale simoo kuli ma yomooyingomu, bale simooye nono ma yunootoyi neyingomu, ngundo ene mete oni oni tewanggo. Ndawugalo ngulo, ngu naluno nguno, ye kowuli ingolo, ye mela puli nguya ewanggo. Ye bidodo sodedo ukeya mayeya wiliyelootooga kumoowooto. Mela puli bobodiboya nguya ewanggo. Ye ukeya noole wiliyeloyi! Elo ewanggo. Ataga nono damoni biyomi tetenggoku nga ngu, no ngu de keda biyomine gula kini ngundilo ene ndatelo damoni biyomi gula ye oni simoo baleno yunowanggoku, ngu ye de kumooni ngundilo? Ewolo. (Ene nalu wengamo Anutndo wilikoyeloweloyi nalu ngulo ewolo.) ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Oni biyobiyomi elaya nguya yulewelo, yoyolo, Yesusndodo oolouwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ene yade puli bodaga sanganimo oolewonggori. Ngu musiyongga ngu, oowooyi tabango wembuyi (Golgata). Ngu musiyonggano nguno Yesus boolowoolo, oni biyomi elayagaku Yesus tanggeyi gide gide booloyelowonggori. Gula kandeyi koondosina, gula kandeyi dedalesina booloyelowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ngundilo booloyelootoyi ngu, Yesusndo yemboongelo ewolo. Awa, no nutolo, mukendonelolo, boolonelootenggoku, ngu ene ma ingolo ngulo tetenggo. Ngulo ge nga kowuliyengga nga andangeyunoya yokoya kapengo! Elo ewolo. Ngundilo elo yokootoni, asa, me oni Yesuslo nengguloni ngu yolo, ebe dagadaga telo, oni gulado oni dagayelolo, ngundo nengguloga ngu yowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Oni simoo bale yowoko pawayelolo dikalo yeyolootoyi ngu, Yuda onilo tabango onindo yumooyinolo mande elo, tabadoli telo ewolo. Kenoyi, ene kuli oni gidalega hoolooweyelowoku ngu, asa, ene Anutndo noole yoyoweloyi sunggi oni yeyingo oni tetoningga ngu, ene komo enengombo enengo hooloowetoningga melako ko ombuni. Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Me oni nguya yumooyinolo mande elo, namoko ombulo, Wayin sono kowoo biyomi Yesus inowelo tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ngundilo telo, me oni enebana ewolo. Ge Yuda mela oni sobosobo koleteyingo oni tetoningga ngu, asa, gengombo gengo hooloowenggeloya melako ombulo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ene de mombi sosowoomo awuno, so uyi nakango gula Payilatndo ngandilo nakangowolo. Nga Oningga Nga, Ngu Yuda Onilo Sobosobo Ulunggalo nakangowolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Asa, ngu oni biyomi gula Yesus tanggeyimo boolowoowonggoku, ngundo Yesus yumooyinolo manggalu telo ewolo. Ge Kristus tetoningga ngu, asa, gengo hooloowenggeloya ngunonggo noole nguya hoolooweyelolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","41","Ngundilo etoni, asa, oni biyomi gulagakundo dobooyi mamanangolo ewolo. Ndatelo ngulo, ge ene yumooyinolo ngundilo ete? Ene oo biyomi gula ma tewolo. Ngulo ene kingo duwoo uletenggo. Ene noolendo ngu noolengo biyomi tewoloku ngu kenolo, ngulo gumi ngundilo teyunootenggo. Noolengo bidodo ngu ataga kumoowato. Ngulo ngu, noolengombo biyomi tewoloku, ngulo ge Anutlo ma sosolewa? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ariya, ngundilo elo tabango yowoolengolo Yesusya ewolo. Oo Yesus, gengo Awanggebo endemo oolouya ootooya ngu, asa, nolo ingondudu telo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ene ngundilo etoni, Yesusndo mande gumi ewolo. No hamoo oolengo geno eteno. Ataga nga sanggano ngano, ge noya Awando ende gome mesalango oolengongga nguno ulo oluwalolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Sa kewoolo oolengo, sambolo mela bidodo suwoo ooleli ulungga telo, oololo, sa nemimo uteku naluno wenga, (3 klok) yokowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ngu naluno, Tempelno kumba gagiwi ulunggado ya gumi kundingiyi wemboongelo boolowooyingonggaku, Anut enengombo kumbagaku wengamo awunonggo oomboongetoni, oosowoolo, ulo melako utoni, gide gide elaya tunootewoli. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ngu naluno nangge, Yesusndo menolo ewolo. Awa, ataga no nenengo gabone kandegemo yetenolo ewolo. Ngundilo elo, ene kumoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ngundilo tetoni, me oni tabangongga, ngundo oo ngundilo kenolo, ene Anut bingami okoolo ewolo. Hamoo oolengo, nga oningga nga biyomi gula ma teyingo! Ene oni nenengo oolengo! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ngu naluno, oni simoo bale oowooyingga oolengo mayelo, Yesus udooyi, kenowelo dikayingoku nguya, ene ngundilo kenolo, nowoondoyi telo, solengoyelo, enengo yano sawonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ene Yesus enengo dobooguliyi, ko bale gidalega Galilinonggo keyolo mayeyingomu, ngu yowoko dikalo, ngunonggo Yesus bingo ndatelo tewanggolo ingolo oluwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Oni gula, oowooyi Yosep, ngu endeni ngu Arimatiya ngunonggo mayewolo. Ngu oningga ngu, ene Yuda onilo mande wilikoweloyi oni, ene oni nenengo oolengo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ngu oningga ngu, ene oni simoo bale Anutndo oo bidodo sobowooweloyi nalungga ngu sobowoolo oodoni, nguno Yesus ulewelo mande elo etoyi, ene nguya nowoondoye gulanangge kini. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ariya, ene Payilat tanggeyimo oololo, Yesus bingo yowelo sumoo inowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ngundilo telo, ene oololo, Yesus bingo de mombimonggo andangelo yolo, towi nomboyinggado doobengowolo. Ngundilo telo, enengo bingo yolo oololo, digi kowu nguno mele seyingomu nguno melengoowolo. Ngu melengga ngu kuli oni gula nguno ma melengoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ngu nalungga ngu, (Sabat) nalu kundingiyi, ngulo oo yomosiyoweloyi nalu. Suwootetoni, ngu Sabatlo nalu namoko tunootewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ngu naluno, bale gidalega Yesus keyolo, Galilinonggo mayeyingo, ene Yosep keyolo oololo, Yesus melengootoni, ngu kenowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ngundilo telo, enengo yano sodedo oololo, ene sosara, bo oo ulumi ndindingo gomemu winggoolo yomosiyowonggori. Ngu oo ngundo ko kootusina, Yesus bingo sonowoolo yomosiyootoyi, sodedo ma buwoo yewelo. Asa, nalu kundingiyi, Sabat, nguno ene ko kini mamana mandeno eteku, ngundilo telo kengelo oluwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sande sengetoni suwoononggo, oo ulumi ndindingo gome ngu yomosiyowonggoku, ngu yolo, yade meleno oolouwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ene oni meleno ombulo, doongeteyingomu ngu, digi ulungga mele manggowo ukingoyingonggaku, nguno kini. Mele manggowo kuli goosoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ene mele newendemo ulo, Oo Bidodo Sembuli Sembunaye Yesus ngulo bingo ma kenowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ngundilo telo, ngulo ingoyingo oowooyingga telo oodoyi ngu, asa, sodedonangge oni elaya enengo towikumbayali namboyi oolengo, yowali soluyi dedeku ngundilo tunootelo, tanggeyemo dikatoli yeyowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ngundilo kenolo, baleku sosoleyingo ulungga telo, penggootelo, melasina doongetelo oodoyi, oni elayagakundo ewoliyo. Ye ndawugalo oni keda oolooteku, ngu meleno ngano erewelo ombutenggo? ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","Ene meleno ngano kini, kuli ootookoowolo. Ye Galilino mande ewolomu ngu ma kapengoyewelo. Ene ngandilo ewolo. No Oni Nangoni ngu mbumbuwadodo oni kandeyemo yetoyi, ngundo de mombimo boolonelootoyi kumoowano. Ene sa kabusayi yokolo ko ootookoowanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ngundilo etoni, ngu baleku nowoondoye imi yetoni ingowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ene mele yokolo, sodedonangge ende oololo, oo bidodo kenowonggoku ngulo sulena oni kande elaya kegidembolo gulanangge (11), ko oni gidalegano nguya, oo kenowonggoku, ngulo mande mande ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ngu bale ngu oowooye ngandilo: Mariya Magadala, Yowana, Mariya gula Yems nemi, ko, bale gidalega nguya, ngundo sulena onino oo kenowonggoku, ngulo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ene sulena onikundo ngu ingolo ngu, ene nowoondoyemo hamoo etenggolo ma ingowonggori. Baledo ganayelootenggolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Asa, Pita ootookoolo, kendutelo, meleno oololo uwolo. Ulo, doongetetoni, hamoo nguno kini. Towi nangge kenowolo. Ngundilo kenolo, ene yowoolengolo ende oololo, ene Yesuslo bingo ngu ndatelo tewolo ngulo ingondudu ulungga telo oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ngu sanggano nguno nangge, sulena oni kewooloyemonggo oni elaya Yerusalem endemonggo ootookoolo, Emeyas oole keyolo, yade (11 Kilomita) ngundilo oolouwoliyo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ngu oni elayaga, ngundo Yesusno oo tewonggoku, ngulo ene elo ingolo oole keyolo oolouwoliyo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ngundilo elo, ingolo ingolo oolouwoodoli, Yesus enengombo doongeyalimo tunootelo, nguya oolouwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ene doongeyali ukingootoni, nga Yesusndo elo ma ingowoliyo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ngundilo telo, Yesusndo ewolo. Yali ndawu mandega elo ingolo ingolo oolouteli? Ewolo. Ngundilo etoni, elayagaku omukumundooyali yumoowelo dikawoliyo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Asa, oni gula oowooyi Kiliyopas oningga, ngundo yowoolengolo, Yesusya ewolo. Ge Yerusalemno oolooteku ngu, oo Yerusalemno oo tewonggoku ngu, ma kenolo ingoyingo? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ngundilo etoni, enebana gumi ewolo. Ndawuga? Ewolo. Elayagakundo mande gumi ewoliyo. Oo bidodo Nasaret oni, Yesus, goweyimo oo tewonggoku ngu! Ene Anut doongeyimo, oni simoo bale doongeyemo nguya, ene Anutlo ingondudu eyingo oni. Enengo mandeni, koni oololo ombulo teyingo, ngu yanggangonidodo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Anutlo woolo yeyingo oni kundingi ngulo sobosobo oniku, ko Yuda onilo tabango oniku, ngundo uleyi kumoowelo mande gulanangge elo gosiyolo, Gabman oni kandeyemo yetoyi, ngundo dowoolo, de mombimo udoyi kumoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","23","Noolendo kuli ngandilo ingowooto. Anutndo ngu oningga ngu yootunolo yunootoni, ngundo noole Rom kandeyemonggo ko yoyootoyi, noole gome oluwatolo ingowooto. Ene utolo yombuliyowonggoku ngu, ene ataga nalu kuli kabusa yokowooto. Ngu oo ngu tewonggoku ngu, ene ataga noolengo bale gidalegado meleno oololo, enengo bingo ma kenolo, ombulo, nooleno ngulo mandeni etoyi, ngulo noole soliyokolo sosolewooto. Ene Anutlo Sambono Oni elaya (Engel) yeyootoyi, ngundo ewoli. Ene kuli keda ootookoowolo ewoli! ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Noole ngu ingolo, noolengo oni gidalega ene melengoowonggoku, meleyimo oololo doongetewonggoku, ngu hamoo baledo ewonggoku ngundilo, ene Yesuslo bingo ma kenowonggorilo ewoliyo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ariya, Yesusndo mande gumi ewolo. Yali ingonduduyali himi kini, Anutlo ingondudu eyingo onindo eyingomu, ngu yali nowoondoyalimo hamoo ma tewoli! ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Yali, bine, ma ingooteli? Anutlo ingondudu eyingo onindo, kuli ngandilo ewolo. Kristus ene komo ogingoyingo koolowoolo yokolo, ene kootusina, enengo ende dulidalinidodomo oolouwalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ngu naluno, Yesus ene damoni yelo, ene mande Mosesndo, ko Anutlo ingondudu eyingo onindo, enengombolo elo nakangoyingo, mande gumgumku bidodo damoni wesiyolo elayagakuno, elo etuyelowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ene ende namoko tetoni, Yesusndo mande ngu elo dagayelolo, toongewelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ngundilo tetoli, elayagakundo solengolo ewoliyo. Suwootewelo teteku nga, ngundilo ngulo, ge nooledodo ngano oluwato. Ngundilo etoli, enedodo yano oolouwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Oo neweloyi naluno, yabano bibitelo, Yesusndo oomanangoyingo gula yolo, dowoolo, Anutno yemboongelo yokolo, oososowoolo yunowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ariya, ene nguno doongeyali himi yetoni yokolo, ngundilo ingootoli, Yesus, doongeyalimo kini telo, ko toongewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ngundilo tetoni, enengo nangge mande ewoliyo. Ene nooledodo oole keyolo, Anutlo mande bidodo damoni wesiyolo elo, etuyelootoni ngu, ingootoole, nowoondonayemo ngu hamoo himi yetoni, ngulo gome ingowolo! Elo ewoliyo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","34","Ngundilo elo, ene ootookoolo, suwoono nangge, ene Yerusalem ko oolouwoliyo. Ngundilo oololo, sulena oni kande elaya kegidembolo gulananggegaku ko oni gidalega nguya ereweyelolo yeyowonggori. Elayagakundo ewoliyo. Hamoo oolengo! Oo Bidodo Sembuli Ulungga ko ootookoowo! Sayimon doongeyimo tunootetoni kenowo! Ewoliyo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ariya, ngundilo elo yokootoyi, elayagakundo sodedonangge nguya gumi ewoliyo. Noole ooleko Yesusndo mande etoni, ingolo, ko yano ulo, oomanangoyingo oosowoolo yunootoni, nelo, ngu naluno, noole ingowooto. Yo, ngu hamoo, Oo Bidodo Sembuli Sembunayimbolo ingowooto! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ngu oni elayagakundo mande ewootoli, ngu naluno nangge, Yesus enengombo kewooloyemo tunootelo dikalo ewolo. Ye nowoondoye imakeyingomo oliyi! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ngundilo etoni, ene soliyokolo, sosoleyingo ulungga tewonggori. Noole enengo gaboyi kenootetolo ingowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","39","Yesusndo enengo ingonduduye ingolo ngulo ewolo. Ye ndatelo sosoletenggo? Ye ndatelo ngulo nowoondoye bulibali ingootenggo? Ye ombuya, nolo kekandene nga kenoyi! No nenengombo nangge. Ye ombuya nodowooya kenoyi! Oomboolo ngu, no ngandilo songgiwine wembunedodo dowoolo kenootenggoku ngundilo kinilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ene ngundilo elo yokolo, enengo kekandeyi nguya etuyelowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ene nowoondoye metemi ingolo, oni oni ulungga tewonggori. Ene nowoondoyemonggo hamoo nenengo elo ma ingowonggori. Nowoondoye kowuli ingowonggori. Ngundilo tetoyi, ngulo Yesusndo ewolo. No oodoolo kumooteno. Ye oowali bodaga ooloote, bine? Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","43","Ngundilo etoni, ene iso kayingomu gumi gula yolo, inootoyi, ene yolo, doongeyemo newolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ene oo nelo yokolo ewolo. Moseslo mamana mande, Anutlo ingondudu eyingo onilo mande, ko Iserel onilo yambo bukno (Sam) nguya nakangoyingo ngu, ngulo mandeye kuli no yeya ootoolo etoowe ingowonggoku, ngu bidodo nolo ewolo. Ngu ataga engge nenengo ngundilo nangge tunootetelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ngundilo telo, ene Anutlo mande damoni oowooyingga wesiyolo elo etuyelootoni, nowoondoye himi yewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ngu mande gula soweyolo ewolo. Anutlo mandeno ngandilo nakangolo ewolo. Kristus, Anutndo noole yoyowelo sunggi yeyingo oni, ngundo kowuli ogingoyingo ulungga ingolo, kumoolo, asa, nalu kabusayi melenonggo ko ootookoowa. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Kristus oowooyimo, nowoondoye yowoolengoweloyi damoningga ngu, ko Anutndo onilo mbumbuwa ngu andangeyunoweloyimbolo damoningga ngu oni simoo bale mela bidodomonggo wesiyolo etuyelowanggo. Ngu kongga ngu Yerusalem endemo nguno koletelo damoni yelo ko telo, ngunonggo mela bidodomo nguya ko telo, elo etuyeloya endeyoyilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Elo, Yesus mande gula soweyolo ewolo. Ye oo bidodo kenowonggoku, ngulo mandeni yootunoya eya endeyoyi. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ye ingoyi! Nolo Awanembo Yuka Kundingiyi yanggango ye yunowelo mande gulanangge elo gosiyoyingongga ngu, nondo suleyootoowe, yeno ombuwa. Ye komo nga endegano ngano sobowooya oodoyiga, ngu Yuka yanggangongga ngu Sambo endemo awunonggo ombulo, ye nowoondoyemo ulo hangewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ene ngundilo elo yokolo, sulena oniku yoyolo, oololo yade Betani ende namoko nguno oolouwonggori. Nguno oololo, Yesusndo sulena oni kandeyi tabayemo okoolo, kumana yunowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ene kumana yunowootoni ngu, Anutndo ene Yesus okoolo, sulena oni yoyokolo, Sambo endemo oolewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Yesus Sambono ooletoni, sulena oniku Yesusno yemboongelo yokolo, ootookoolo, oni oni ulungga oolengo telo, Yerusalem ko oolouwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ene suwoo suwoo Tempelno ulo, Anut bingami nangge elo okoololuwonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Kulimi oolengo, Anutndo oo bidodo ma yeyingo, ngu naluno, Mande ngu (Yesus) oluwoliyo. Yo, Yesusndo ngu Anutya goboolo oluwoliyo. Ngu enengombo Anut. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Kulimi oolengo damonimonggo ngu, ene Anutya oluwoli. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Yo, Yesusndo ene oo bidodo temukowolo. Ngulo ngu, oo gula oole gulano ma tunootewolo. Kini, oo bidodo tunootewoku ngu, Yesus enengombo yeni tunootemukowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Eneno keda sugi sugi oluweloyi oolooteku, ngu keda oluweloyiga ngu simoo balelo solu himi. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ngu solu himingga ngu suwoono delo himi yetoni, ngu ooleli ngundo doobengoweloyi ereremo kini. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Oni gula tunootewo, ngu oowooyi Yon. Anutndo ene koletelo suleyootoni ombuwolo. Yo, ene ombulo oni simoo bale tunoo etuyelolo, Yesus ngu hamoo solu himi oolengo. Ngundilo tetoni, ngulo oni simoo bale mande ngu ingolo, ene nowoondoyemo hamoo tewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yon enengombo ngu solu himingga ngu kini. Kini, ene ombuyingo ngu solu himingga (Yesus) ngulo mandeni wesiyolo eweloyimbolo ombuwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Yo, Yesus ngu hamoo solu oolengo. Ngundo ombulo, oni simoo bale bidodo melako oolootenggoku, ngu solu himi yunowelo ombuwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ngu ene melako ootoolo, ngunonggo ene melako, oni simoo bale, oo bidodo yewolo. Ene melako oni simoo baledo, ene kenolo, ma ingowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","12","Ene enengo ende damonimo oolouyingomu, ene enengo Yuda onindo ngu ma yowonggori. Kini, oni gidalegado yowonggori. Ene oni ngu enengo oowooyimo nowoondoyemo hamoo tetenggoku ngu, ene mete Anutlo simoongo oolengo tunootetenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Yo, ene Anutlo simoongo tunootetenggoku ngu, ene awa namoyembolo daloyebo kini, ko onilo ingonduduno nguya kini, enengo koyemo nguya kini. Anut enengombo yoyeni, enengo simoongo tunootetenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Mande (Yesus) ngundo oni tunootewoku, ngu nalu ootuwoo bodaga nangge, noole kewoolonayimo oluwolo. Yo, eweyimbo suleyootoni, ombutoni, noole kuli enengo dulidalini ngu kenowootowolo. Ngu dulidaliningga ngu, enengo nangoni gulananggega ngulomu. Sumange ko damoni hamoo gome nenengomu, ngu eneno hangewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yondo ngu oningga ngulo mandeni wesiyolo elo, ngandilo meno ewolo. Ngu oningga ngu, kuli nondo yeno etoowe ingowonggoku, ngu ngandilo. Ene no kootunemo ombulo tunootewoku, ene no oowoone dagalo ulungga tunootete. Ndatelo ngulo, ene kuli tunootelo oluwoku, ngu naluno, no ma oluwololo ewono. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Eneno ngu sumange ulungga oolengo hangelo ooloote. Ngu sumangeningga, ngunonggo nangge suwoo suwoo oo gome gome guladilo guladilo, ene noole yunololoote. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Yo, hamoo, Moses kandeyimonggo Anutndo mamana mande noole yunowolo. Ene sumange nowoondoyi, ko mande damoni hamoo gome nenengo, ngu Yesus Kristusnonggo nangge tunootewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Oni gulado hamoo oolengo Anut ma kenowolo. Anut Nangoni gulanangge, ngu Anut kilalongo. Ngundo eweyi tanggeyimo oolooteku, ngundo nangge, Anutlo damoni ngu nooleno yootunolo ete. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yuda onindo Anutlo woolo yeyingo oni kundingiyi, Liwayi oni ngu suleyelootoyi Yerusalem yokolo, ombulo, Yon sumoo inowonggori. Ge ndawu oningga? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ngundilo sumoo etoyi, ariya, Yondo mande tunoo elo, mande gula ma oongoowolo. Ene ngandilo wesiyolo ewolo. No Kristus, Anutndo noole ko yoyoweloyi suleyowoku oningga ngu kinilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Yondo ngundilo etoni, enendo sumoo inowonggori. Ngu ndatelo? Ge ndawu oningga? Ge bine Ilayisando? Ewolo. Etoyi, enendo mande gumi ewolo. No Ilayisa kini. Etoni, enendo sumoo gula ewonggori. Ge bine Anutlo ingondudu eyingo oningga, noolendo sobowootetoku, ngu bine? Elo ewonggori. Asa, enebana mande gumi ewolo. Kini. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ngundilo etoni, enebana Yonno sumoo gula ewonggori. Ge ndawu oningga? Noole komo mande gumi oni noole suleyelootoyi ombuwootoku, nguno ewato. Ge, gengomboya ngu, ge ndatelo ete? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ene ngundilo etoyi, Yondo gumi ewolo. No nga oningga ngalo Anutlo ingondudu eyingo oni Ayisaya, ngundo ewolo. Oni gula kingo mela oni kini, ngunonggo manggowo gula meno ete. Oo Sembuli Ulungga, ngulo oole yomosiyoyino! Elo ewolo. (Ayisaya 40:3) ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Parisi onindo ngu oni ngu, suleyelootoyi ombuwolo. Ene Yon sumoo inowonggori. Asa, ge Kristus kini, ge Ilayisa kini, ko Anutlo ingondudu eyingo oni kini, asa, ndawugalo ngulo, ge oni simoo bale sono kundingiyimbo sonoyeloote? Elo sumoo inowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ene ngundilo sumoo etoyi, asa, Yondo mandeye gumi ewolo. Nondo ngu sonombo nangge sonoyelooteno. Ene oni gula kewooloyemo dikalo oolooteku ngu, ye ngu watayi kini. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ngu oningga ngu, no kootusina ombuteku, ngu oningga ngulo yanggangoni ulungga oolengo. Nolo yanggangone ngu bodaga nangge, ngulo ngu, no enengo ko oni telo, ma oluwanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Nga mandega nga Betani ende, Yodan sono anduloko nguno tunootewolo. Nguno Yondo oni simoo bale sono kundingimbo sonoyelowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Sengetoni, Yesus ombutoni, Yondo kenolo ewolo. Kenoyi, nga ngu Anutlo Sipsip Nangoni. Ngundo oni simoo bale mela bidodo mbumbuwaye andange yunowa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ngu oningga ngulo, nondo kuli ewonomu ngu. Oni gula no kenelolo ombuteku, ngundo no daganelowolo. Ndatelo ngulo, ene no ma oliyingo naluno nguno, ene kuli oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","No ngu oningga nguya watayi kini. Ene no ombulo, oni sono kundingiyimbo sonoyelootoowe, nguno Iserel oni simoo baleno, ngu oningga ngu tunoo etuyelowanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yondo mande ngandilo yootunolo ewolo. No Yuka Kundingiyi ngu, nu kundirimanggowo ngundilo telo, Sambononggo ombulo, ene tabango sanganimo oodoni kenowono. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","No nenengombo ngu oningga ngu, kuli watayi kini. Anutndo oni sonoyelo elo, sulenelolo ngu, ngandilo ewolo. Ge Yuka Kundingiyi kenootoyi, oni gula tabango sanganimo oodoningga ngu, ariya, ngu oningga ngundo Yuka Kundingimbo oni simoo bale sonoyelowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Asa, no nenengombo ngu ooga kenootoowe tunootewolo. No ngulo mandeni yeno kuli ewonoku, nga oningga nga, ene Anut Nangoni. Yondo ngulo ngundilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Sengetoni, Yon dikatoni, enengo sulena oni elaya nguya dikawoliyo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ene Yesus kenootoni, oole keyolo ombutonilo ewolo. Kenoli, ngungga ngu, Anutlo Sipsip Nangoni! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Enengo sulena oni elayagaku Yonlo mande ngu ingolo, ene Yesus keyolo oolouwoliyo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ene ngundilo tetoli, Yesus yowoolengolo, elayagaku ene keyolo ooloutoli, yeyolo ewolo. Yali ndawuga ereweteli? Ewolo. Etoni, elayagakundo gumi ewoliyo. Rabayi, ge ndawu yanggano ooloote? Elo ewoliyo. Rabayi mandega ngulo damoni ngandilo, oo etuyeloyingo oni ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yesusndo gumi ewolo. Mete yali ombuya kenoli! Ewolo. Etoni, asa, elayagaku Yesus keyolo oololo, ene oluwoku ya ngu kenolo, enedodo ngu sangga nguno oluwolo. Ene, ngu sangga nguno mande elo oodoyi, oololo suwootetoni ngu, sa gaboyi nalu namolaya tunootetoni, ko suwoono nguya oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Nga oni elayaga, ngando Yonlo mande ingolo, ene Yesus keyolo oololo, ene oni gula oowooyi Enduru, ngu Sayimon Pita ngulo koneyo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Enduru, sodedonangge Yesusndo oluwonggoku yangga, ngu yokolo ulo, bebeyi Sayimon koletelo erewelo kenolo ewolo. Noole kuli Mesayiya kenootetoku nga! Elo ewolo. Mesayiya ngulo damoni ngandilo. Ene Kristus, Anutndo noole ko yoyoweloyi sunggi yeyingo onilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ngu naluno nguno, Endurundo Sayimon yolo, Yesusno oolouwolo. Yesusndo kenolo ewolo. Ge Sayimon, Yonlo Nangoni. Kootusina oowoongge Sipas (Pita) ewanggolo ewolo. Ngu oowooyi Pitangga ngulo damoni ngu digi ulunggalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Sengetoni suwoononggo, Yesusndo enengo ingondudunonggo, Galili melako oolouwanolo ingowolo. Ene Pilip kenolo ewolo. Ge ombuya no kenelolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilip ngu ene Betsayida oni. Enduru Pita elagalo ende damoni nguya. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilipndo oololo, Nataniyel kenolo ewolo. Nga oningga nga ngu, ene kuli Mosesndo mamana mandeno nakangoyingo, ko Anutlo ingondudu eyingo onindo nguya nakangoyingonggaku, noolendo kuli kenowooto. Ngu Yesus, Nasaret oni, ngu Yosep Nangonilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ene ngundilo etoni, ariya, Nataniyeldo eneno ngandilo sumoo ewolo. Oo metemi gula Nasaretno tunootewa, bine? Ene ngundilo etoni, asa, Pilipndo mande gumi ewolo. Ombuya kenolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesusndo Nataniyel kenootoni, eneno ombutoni, ngandilo ewolo. Keno, Iserel oni ene hamoo! Eneno ebe ganagana mande ko damoni biyomingga nguya, eneno ma oolootelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ene ngundilo etoni, Nataniyeldo Yesus sumoo inowolo. Ndatelo, ge no watayi tewo? Ene ngundilo etoni, Yesusndo gumi ewolo. Pilipndo ma negogeloyingomo, no nguno (Pik) dega damonimo oodoni geyowonolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Etoni, Nataniyeldo gumi ewolo. Oo etuyeloyingo oni, ge Anutlo Nangoni! Ge Iserel mela ngulo onilo sobosobo koleteyingo ulungga! Ene ngundilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ngundilo etoni, Yesusndo gumi ewolo. No ge amana (Pik) de damonimo geyowonolo etoowe, ngulo ge nowoondogemo hamoo tete. Kootusina, oo ulunggado nga ooga nga dagatoni, ge kenowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yesusndo ene ko ewolo. No hamoo oolengo, yeno eteno. Kootusina, ye Sambo goosootoni, kenootoyi, Anutlo Sambono Engel oni, ngundo Oni Nangoni, ngu tanggeyi gidegide oolelo, ombulo tetoyi, ye yeyowanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Sa elaya nguno yokolo, sa kabusayiga nguno, Yesus nemimbo ngu, bale yoweloyi yanggakuno oluwoliyo. Ngu bale yoweloyi nalungga ngu, Kena ende ngu, Galili mela nguno tunootewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ene Yesus ko enengo sulena oni nguya, ngu bale yoweloyi nalungga, nguno negoyelootoyi oolouwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ngundilo oololo oodoyi, Wayin kinitetoni, Yesus nemimbo Yesusya ewolo. Ene Wayin gula kinilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesusndo eneya ewolo. Namo, nondo ndawuga tewe? Ngu noolengo geya oo kini. Nolo nalu ma tunooteyingolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ene ngundilo etoni, asa, nemimbo ko onikuya ewolo. Yesusndo yeno mande gula etoningga ngu, ye komo ngu keyoya teyilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ngu yangga nguno, nogo kumbe kandegula gidembolo gulanangge oluwonggori. Nguno Yuda oni enengo damoniye sono gemuweloyi sono oolengo, nguno oodoni, Anutlo mamana mandeni Yuda onindo keyoyi elo, ngulo ewolo. Kumbe gulanangge nangge ngu 100 Lita ngundilo. (Ngu 6 ngundi 7 Kelo Dram ngundilo). ");
INSERT INTO rwo_karo_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesusndo ko oniya ewolo. Kumbeno sono moondoya, kumbengootoyiga, hangeni. Ene ngundilo etoni, asa, ko onindo Yesusndo ewoku, ene ngundilo tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Yesusndo ko onikuya ewolo. Nga gumi wendoya, yoya, oolouya, oo simbo kayingo sobosobo ngu inoyi. Ene ngundilo etoni, ko onindo gumi wendolo, yolo, oololo, oo simbo kayingo sobosobogaku inowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Oo simbo kayingo sobosobogakundo, sono tewoongolo netoni ngu, ngu naluno ngu, Wayin oolengo tunootete. Ngulo ngu, ene ndanonggo yoyingo ngu, ene watayi kini. Ene enengo ko oni ngundo nangge watayi, sono oolengo moondowonggori. Ariya, oo simbo kayingo sobosobogakundo, bale yoweloyi oninggaku negongowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ombutoni ewolo. Oni bidodo koletelo Wayin metemimu bayetelogo, kootu oni simoo oowooyingga netoyi ngu, ariya, ngu naluno, ene Wayin biyomi bodaga nguno yunootenggo. Ene ge Wayin metemi oolengo ngu gosiyowoku, ge ataga kootu yolo ombulo, bayeteteku nga! ");
INSERT INTO rwo_karo_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Kena ende Galili melako nguno, Yesusndo koletelo damoni sungo oolengo gula onindo ma teweloyim, ngu tewolo. Nguno enengo dulidalini ngu etuyelootoni, enengo sulena oni ene damoni yelo, Yesusno nowoondoyemo hamoo tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ngu nalu ngu kinitetoni, Yesus, nemi, konebeyi, ko enengo sulena oni nguya, Kaperniyam endemo ulo, nguno sa nalu gidalega kengelo oluwonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Yuda onilo kengeweloyi kundingiyi nalu oowooyi Pasowa, ngu namoko tete. Ngundilo ngulo, Yesus yade oololo, Yerusalemno oolouwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Yesus oololo, Yuda onilo goobooyingo ya oowooyi Tempel, ngu newendemo ulo, oni Bulmakau, Sipsip, nu kundirimanggowo uliyootoyi yeyolo, ko oni bibiteweloyi yabano bibitelo, bobeye yowoolengolo yunootoyi yeyowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Yesusndo uto gisalu telo, ngu yolo, Bulmakau, Sipsip ko nusago bidodo musiyomo oolootenggoku oweyelowolo. Ngundilo telo, ene oni digi yowoolengowonggokuno oololo, bobeye siyakiyoni satoni, yaba bidodo wenggelemootoni, ukelo utoni oweyelowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ene oni nu kundirimanggowo uliyoyingo nguno ewolo. Ye nu yoya, musiyo nga yokoya sayi! Ye nolo Awanembolo yangga nga yeyi, oo uliyoweloyi musiyo ma tewelolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Yesuslo sulena oni ngu, ene Anut mandeno kuli oolooteku, ngu ingonduduwoolo ingowolo. No gengo ya ngulo gome oolengo ingolo, ngulo no ko yanggango oolengo tetoowega, gengo ya gome olinilo ingootenolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ene Yuda onilo tabango, ngundo ngundilo kenolo, Yesusya mande yanggango elo ewonggori. Anutndo nga kongga ngano logogelowo tetoni ngu, asa, ge oo damoni sungo oolengo gula onindo ma teweloyi, ngu anangu tetooga, noole kenolo ingowato. Ngu hamoo, Anutndo ngu kongga nguno logogelowolo ingowato ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ene ngundilo etoyi, Yesusndo mande gumi elo ewolo. Yendo nga yolo yangga nga toongootoyi ngu, nobana nalu kabusagomo ko yewe dikawalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ngundilo telo, Yuda onindo ewonggori. Oni nga goobooyingo Tempel yangga nga yeloodoyi, mooma nalu onibi namolaya, kandegula ke gidembolo gulanangge (46) yokowonggori. Ngundilomu, gedo ngu ko sa kabusa nanggemo, ko yewelo ete? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ngu goobooyingo yangga Yesusndo ewoku ngu, enengo goweyimbolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ngundilo ngulo, kootusina, Anutndo melenonggo Yesus ko yokutuwootoni, ko ootookooyingo, nguno enengo sulena oni ko ingondudu telo, Yesusndo mande kuli ewo, ngundilo tunootetoni, nguno ingowolo. Ngundilo tetoni, sulena oni ene Anutlo mande so uyi nakango, ko Yesusndo mande ewoku, ngu bidodo ingootoyi, nowoondoyemo hamoo oolengo tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesus ngu Yerusalemno Pasowa nalu kundingiyi ngu sobowoolo oodoni, oni simoo bale oowooyingga oolengo, Yesusndo oo onindo ma teweloyim ngu tetoni, kenolo, ngulo oni ulungga oolengo, eneno nowoondoyemo hamoo tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ene Yesusndo simoo bale bidodo ingonduduye bulibali ingootenggoku, ngulo ene ngu oningga, ngulo newendemo hamoo ma tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ndatelo ngulo, Yesusndo ene oni simoo bale bidodo damoniye, ingonduduye ingomukoote. Yesus ene onilo ingonduduye, ngulo oni gulado ma etoni ingowa. Kini, ene bidodo ingomukoote. ");
INSERT INTO rwo_karo_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Oni gula oluwoku, ngu oowooyi Nikodimas. Ngu Nikodimas oningga ngu Parisi oni, ko Yuda onilo tabango nguya. ");
INSERT INTO rwo_karo_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ngu oningga ngu, suwoono Yesusno ombulo ewolo. Oo etuyeloyingo oni, noole ingooteto. Ge oo etuyelowelo, Anutndo sulenggelootoni ombuwolo. Ene Anutndo oni gulaya ma ootoolo ngu, ene oo sungo gula oni ma teweloyi, gedo teteku, ngu ma tewalo ingooteto. ");
INSERT INTO rwo_karo_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ene ngundilo etoyi, asa, Yesusndo mandeni gumi ewolo. Hamoo oolengo, no geno eteno. Oni gula ene newende buniyo keda ngundilo ma tunootelo ngu, asa, ene Anutlo endega enengo oni simoo balelo soboyelooteku, nguno ma ulo oluwalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ene ngundilo etoni, asa, Nikodimasndo gumi ewolo. Ndatelo telogo, oni kuli dogoni yeyingo, ngundo ene ko yowoolengolo, oni buniyo ngundilo tunootewa? Ene mete nemi useyimo utoni, nemimbo ko yomoowa bine? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ngundilo etoni, Yesusndo Nikodimaslo mande gumi ewolo. Hamoo oolengo, no geno eteno. Oni ene sono (kundingiyi), ko Yuka Kundingiyimo nguya, keda ma tunootelo ngu, ene Anutlo endega enengo oni simoo balelo soboyelooteku, nguno ulo ma oluwa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Oni ene eweyi nemimbo kedaga yeli tunootete. Ene Yuka Kundingiyimbo oni newendemo ulo, ngundo yeni keda tunootewa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ge nondo mandega geno etenoku, ngulo ingondudu ulungga telo, ma sosolewelo. Ye komo yengo nowoondoye buniyo keda ngundiya tunooteyi! ");
INSERT INTO rwo_karo_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Doogo ngu enengo ingonduduni keyolo, doogo yolo gulasina gulasina, oololo ombulo tete. Ge kingo ngguyi nangge ingoote. Ene ndasinanggo ombulo, ndasina oolouteku ngu, ge ma ingoote. Oni bidodo ko keda Yuka Kundingiyimo tunootewanggoku nguya, ngundilo nanggelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ene ngundilo etoni, Nikodimasndo gumi ewolo. Nga ooga nga ngu, ndatelo telogo tunootewa? ");
INSERT INTO rwo_karo_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Etoni, Yesusndo gumi ewolo. Ndatelo ngulo, ge Iserel onilo oo etuyeloyingo oni, ge mande oo nga ma wilikolo ingoote? ");
INSERT INTO rwo_karo_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Hamoo oolengo, no geno eteno. Noole oo kenolo ingootetoku, ngulo mandeni yootunolo eteto. Ene noolendo mandega etetoku ngu, ye ingowelo yokootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nondo kuli mela ngalo oo nguno elo etuyelowonoku ngu, ye ngulo nowoondoyemo hamoo ma tewolo. Ngulo nondo Sambo ende oo nguno mande elo etuyelowanoku ngu, ndatelo telogo, ye nowoondoyemo hamoo tewanggo? ");
INSERT INTO rwo_karo_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Oni gula ene Sambono oolelo, Sambo ende oo damoni ma kenolo ingowolo. Kini, Oni Nangoni, ngundo ene Sambo endemonggo ombuyingo, ngundo nangge, Sambo ende damoni nenengo oolengo, ye etuyeloweloyimbolo ombuwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Kulimi Mosesndo oni kini, kingo melako nguno sile gaboyiga telo, de bodaga sanganimo yelo boolowoolo okootoni, oni ngu kenolo, ene ma kumooyingo. Ngundilo nangge, Anutlo Nangoni Oni Kilalongo nguya, de sanganimo yelo, okoolo boolowoowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Oni simoo bale bidodo ngulo nowoondoyemo hamoo tewanggoku ngu, ene suwoo suwoo sugi sugi keda gome oluweloyi, ngu yowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Yo, Anutndo oni simoo bale mela ngano oolootenggoku, ngu bidodo nowoondoyi ulungga telo, ngulo enengo Nangoni gulananggega, ngu oni simoo bale yunowolo. Ene ngundilo tewongga nguno oni simoo bale bidodo nowoondoyemo hamoo telo ngu, asa, ene ma oonatewanggo. Ene ngundilo telo ngu, ene suwoo suwoo sugi sugi keda oluweloyiga ngu yolo, oni oni telo oluwanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Anutndo enengo Nangoni ngu melako ngano suleyootoni ombuwolo. Ene oni simoo bale wilikoyelowelo ma ombuwolo. Kini, Anutndo ngu mela ngalo oni simoo bale bidodo mbumbuwanonggo ko yoyoni elo, suleyootoni ombuwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Oni ene ataga newendemo hamoo teteku ngu, asa, Anut doongeyimo oni nenengo tunootete. Ene oni ene newendemo hamoo ma teteku ngu, Anut doongeyimo ene mbumbuwano oonatelo ooloote. Ndatelo ngulo, ene Anut Nangoni gulananggega ngulo newendemo hamoo ma tewoku, ngulo ene oonatewa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Mande wilikoyingo damoni ngu ngandilo. Solu himi ngu kuli melako ngano tunootewolo. Ene onindo ngu ooleliko oluwelo ingolo, ngulo ene solu himi ngu yokootenggo. Ndatelo ngulo, enengo damoniye ngu biyomi oolengo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Yo, ngundilo oni simoo bale ngu ooleliko damoni biyomi ngu telo oluwelo, gome ingootenggo. Ngundilo ngulo, ene solu himimo ombuwelo ma ingootenggo. Ndatelo ngulo, enengo damoniye biyomi ngu solu himi ngundo yootunoweloyi, ngulo ene yokootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ene oni damoni hamoo teteku ngu, ene solu himimo nguno ombute. Enengo damoni, enengo koni, ngu Anutya ko teteliku ngu, oni doongeyemo tunoo kenowanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ngu naluno nguno, Yesusndo enengo sulena onikuya, Yudiya melasina oolouwonggori. Nguno, Yesus enengo sulena oniya nguno oode, oni simoo bale gidalega sono (kundingiyi) gemuyunolo oluwonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ngu naluno nguno, Ayinon ende ngu, Salim ende ngu tanggeyimo, nguno Yondo nguya, oni simoo bale sono gemuyunowolo. Ngu melasina nguno sono oowooyingga oolooteku, ngulo oni simoo bale suwoo suwoo nguno mayelo, sono (kundingiyi) yowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ngu naluno nguno, Herodndo Yon yolo ya biyomimo ma yewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ngu naluno, longge mande gula Yonlo sulena oni, ko Yuda oni gulaya ngu kewooloyemo tunootewolo. Ndatelo sono gemuweloyi, Yudalo damoningga ngu keyolo ngu, ene Anut doongeyimo, namboyi tunootewatolo longgeyolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ngundilo telo, enengo sulena oni Yonno oololo ewonggori. Oo etuyeloyingo oni, kuli geya oningga Yodan sono anduloko ootoolo, gedo ngulo mandeni ewolo. Ngu oningga ngundo oni simoo bale sono (kindingiyimbo) sonowooyunootoni, simoo bale bidodo eneno ooloutenggolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ene ngundilo etoyi, asa, Yondo mandeye gumi ewolo. Anut Sambo endemo oolooteku, ngundo oni gula oo ma inootoni ngu, asa, ngu oningga ngu, ene mete ma yowa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nondo mandega yeno ewonomu, ye ngu kuli ingowonggo. No ngu oningga, Anutndo oni noole ko yoyowelo elo sunggi yewokungga, ngu kini. Ene no ngu, Anutndo ngu oningga ngulo ooleni yomosiyoyinoweloyimbolo elo, koletelo no sulenelootoni ombuwono. ");
INSERT INTO rwo_karo_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ngu ngandilo. Ene oni gula bale yowaku ngu, asa, ngu balega ngu, ene ngu simoongga ngulo baleyi. Ngu simoongga ngulo dobooyi ngu dikalo, sodeyelo, ataga bale yowoku oningga ngulo mandeni ingolo, oni oni tewa. Ngundilo nangge, no nguya nowoondonemonggo ngu oningga ombuyingo, ngulo no oni oni ulungga teteno. Ataga ngu engge oolengo tunootete. ");
INSERT INTO rwo_karo_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Hamoo oolengo, ngu oningga ngu (Yesus), ngulo oowooyi ngu komo ulungga oolengo tunootetoni, nolo oowoone ngu komo ombulo bodaga telo, ameno uwalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Oni Sambono awunonggo ombuyingo ngu, enengo damoni ngundo mela ngalo damoniye ngu bidodo dagayeloote. Oni mela ngano tunooteteku ngu, ene mela ngalomu. Ene mela ngalo oo ngulo nangge mandenilo tete. Yo, hamoo, oni ene Sambo endemonggo ombuyingo ngu, enengo damoni ngundo mela ngalo damoniye ngu bidodo dagayeloote. ");
INSERT INTO rwo_karo_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ene oo kuli kenowoku, ko ingowoku, ngulo elo yootunolo ete. Ene oni gulado ngu mandega elo yootunooteku, ngu ma yolo dowoote. ");
INSERT INTO rwo_karo_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Oni ene mande ngu gome ingolo, yolo dowoolo ngu, asa, ene yo elo ewaku, ngu mandega nguno ngu, Anut ene hamoo mande nangge etelo etuyelowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ngu oningga Anutndo suleyootoni ombuwoku ngu, ene Anutlo mandeni nangge yootunolo ete. Ndatelo ngulo, Anutndo Yuka Kundingiyi ngu ulungga oolengo inowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Eweyimbo enengo Nangonimbolo gome ingolo, nowoondoyi teyinolo, ngulo oo bidodo ene kandeyimo yelo inowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Oni ene Nangonimbolo newendemo hamoo teteku ngu, ene suwoo suwoo keda sugi sugi oluweloyiga ngudodo ooloote. Ene oni Nangonimbolo mandeni ngu ma ingolo keyolo ngu, asa, ngu oningga ngu, Anutya nguno keda ma oluwali. Kini, Anutlo sanggiliningga ngu eneno oluwa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ngu nalunggano nguno, Parisi onindo mande gula ngandilo ingowonggori. Yesusndo Yon dagalo, sulena oni oowooyingga oolengo yoyolo, sono (kindingiyimbo) sonowooyunootelo ingowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Ene Yesus enengombo ma sonoyelowolo. Kini, enengo sulena onindo nangge oni sonoyelowonggori.) ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yesus ene Parisi onilo mandeye ngu ingolo ngu, ene Yudiya mela yokolo, ene ootookoolo, Galili melako ko oolouwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Yesus ngu ene ootookoolo, Sameriya mela kewoolokuli oolega ngu keyolo oolouwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Yesus ngundilo yade oololo, Sameriya mela ngulo ende gula oowooyi Sayika, nguno tunootewolo. Ngu endega ngu namoko mela gula Yekobndo enengo nangoni Yosep kuli inowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Yo, ngu musiyonggano nguno, Yekobndo kuli sono melengga sewolo. Yesus oole yade yade ombulo, moondeyi ogingoyingootoni, ngulo ene sono melengga ngu tanggeyimo bibitewolo. Ngu nalungga ngu, sa kewoolo (12 Klok). ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ngu naluno nguno, Sameriya mela ngulo bale gula sono moondowelo ombuwolo. Ene ombutoni, Yesusndo ngu balega ngu kenolo, ngandilo ewolo. Sono bodaga nunootooga newelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ngu naluno ngu, Yesuslo sulena oniku bidodo, oowali uliyowelo endemo umukowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Yesusndo ngundilo etoni, asa, Sameriya balega ngundo gumi ewolo. Ge ngu Yuda oni, ko no ngu Sameriya bale. Ngulo ge ndawugalo, nono sonolo sumoo ete? Elo ewolo. (Ndatelo ngulo, Yuda onindo Sameriya oniya doboo ma yelo, goboolo ma endeyootenggo.) ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ene ngundilo etoni, asa, Yesusndo ngu balega nguya gumi ewolo. Ene ge Anutndo oo kingo duwoo gunooteku, ngu ingolo ngu, ko nga oningga ngando geno ete, sono bodaga nunootooga newe eteku, ngu nguya ingolo ngu, gebana eneya ewa. Suwoo suwoo, keda oluweloyi sono ngu, no nunootooga newe elo ewaku ngu, enendo suwoo suwoo keda oluweloyi sono ngu gunootoni newa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ngundilo etoni, balega ngundo Yesuslo mandeni gumi ewolo. Oni ulungga, ge sono moondoweloyi oo gula kini, nga sono melengga nga ngu, mela newendemo oolengo amu. Ge sono suwoo suwoo keda oluweloyiga, ngu ndanonggo yowa? ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Yekobndo nga sono melengga nga ngu, selo yunowolo. Ngu enengombo enengo simoongo, ko enengo nusagododo nga sonongga nga neloluwolo. Ge noolengo osinayi, Yekob, ngu dagalo ulungga, bine? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesusndo balega ngulo mandeni ngu ingolo, gumi ewolo. Oni bidodo nga sonongga nga nelo ngu, ene kootusina sonolo ko ingolo hahangewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ene oni gula nondo sonongga nga inootoowe newaku ngu, asa, ene sonolo bungeyi ko ma soliyetoni hahangewa. Nga sonongga nondo inootenoku ngu, suwoo suwoo keda oluweloyi sonongga ngu newendemo ngunonggo oolelo oolelo, ene sugi sugi oluwalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ene ngundilo etoni, asa, balegaku enebana Yesusno ewolo. Oni ulungga, ge ngu sonongga ngu, no nuno. Nunootoyi ngu, asa, kootusina, no bungene soliyetoni, sonolo hahangelo, no sono moondowelo, ngano ko ma ombuwanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Etoni, Yesusndo mandeni gumi ewolo. Ge oolouya, kamengge negongoya, yalingo ela ela ngano ombuli! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ngundilo etoni, balegakundo gumi ewolo. No kamene moole kini. Etoni, Yesusndo balegakuyalo ewolo. Ge ngandilo ete, no kamene kini, ge ngu hamoo oolengo ete. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ndatelo ngulo, kuli ge kamesumoongge kandegula. Ataga simoongga oolooteliku, ngu gengo kamengge oolengo kini. Gengo mandega eteku, ngu hamoo oolengo etelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Etoni, balega ngundo Yesusno ewolo. Oni ulungga, ataga no ingooteno. Ge Anutlo ingondudu ewo oni. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Noole osi sambanayimbo nga mela pulimo ngano gooboongoolo, Anutno yambo mande tewonggori. Ene ye Yuda onindo ngu etenggo. Oni gooboongoolo yambo mande teweloyi ngu, Yerusalemno nanggelo etenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Baledo ngundilo etoni, asa, Yesusndo mandeni gumi ewolo. Ge bale, ge komo nolo mande etenoku nga ingoya, nowoondogemo hamoo teni. Nalu gula tunootetoningga ngu, ye nga mela pulimo ngano, ko ye Yerusalemno nguya, awanayimo yambo mande ma tewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ye ngu, oo ye ma ingootenggoku, nguno yambo mande tetenggo. Noole Yuda onindo ngu oo ingootetoku, nguno yambo mande teteto. Ndatelo ngulo, Anutndo ko yoyoweloyi koningga, ngulo ingonduduga ngu, noole Yuda oni simoo bale kandenayimo ooloote. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Nalu gula tunootetoni ngu, ngu nalunggaku ngu ataga kuli tunootewoku nga! Oni bidodo hamoo yambo mande tewelo ngu, asa, ene komo Yuka Kundingimbolo Awangga ngulo yanggangoni, damonimo, nguno yambo mande tewanggo. Ene damoni ngundilo tetenggoku ngu, asa, Awando ngundilo oni ngulo gome ingoote. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Anut ngu Yuka oolengo. Ngulo oni simoo bale komo Yuka Kundingiyi, ngulo yanggangonimo ngu yambo mande tewanggo. Yo, ene komo Anutndo damoni metemi tewelo ingooteku, ngu nangge teyi. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ene ngundilo etoni, asa, balegakundo mandeni gumi ewolo. No ingooteno. Mesayiya ombuwa. Ene Kristus, Anutndo noole ko yoyoweloyimbolo elo sunggi yewo oni, ngundo ombuya. Ene ombuteku naluno nguno, ene oo bidodo etoni, noole ingowatolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Balega ngundo ngundilo etoni ngu, Yesusndo enengo mandeni gumi ewolo. Ngu nondo nangge, no ataga geya mande eteloku nga! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Yesusndo balega nguya ngundilo etoni, asa, ngu naluno nangge, enengo sulena oniku ombulo, yeyolo, ene ngulo ingondudu ulungga tewonggori. Ene sulena oni gulado sumoo ewelo ma ingowolo. Ge ndawuga yowelo erewete; ngundi, ge ndawugalo eneya mande eteli? Elo ingowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ariya, ngu balega ngu, enengo sono nggusi nguno yokolo, ene kendutelo, endemo oololo, oni simoo baleno ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Ye ombuya, ande oningga ande kenoyi! Ene nondo oo kuli tewonoku, ngu bidodo yootunolo ete. Ene Kristus bine? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ene ngundilo etoni, ariya, oni simoo bale endemo oluwonggoku, ngu bidodo ootookoolo, ende yokolo, Yesus tanggeyimo ombuwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ngu nalunggano nguno, sulena onindo Yesusya oo neni elo, eriringolo ewonggori. Oo etuyeloyingo oni, ge komo oowali ne! Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ene Yesusndo ewolo. No oowali gidalega moole, ye ngulo ma ingootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ngundilo etoni, ngulo enengo sulena oni enengo nangge elo ingolo ewonggori. Oni gulado bine, oowali kuli yolo, mayelo inowo? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesusndo enengo ingonduduye ngu kenolo ingolo, ngulo ene ewolo. Nolo oowali ngu ngandilo. No komo oni no sulenelootoni, ngano ombuwonomu, ngulo ingonduduni ngu keyolo, enengo koni ngu temukowano. Ngungga ngu, nolo oowali nenengo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Yendo ngandilo etenggo. Kombo namolaya yokolo ngu, kono oowali enggelo mandoni yemukootoni, yolo, ngu neweloyi nalu. Ene no yeno eteno. Ye komo ootookooya, doongeteya, endeyoya, oowali koyi nga kenoyi. Oowali kuli enggelo mandoni yemukowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Oni oowali engge yooteku ngu, ene enengo uliyi yolo, ene suwoo suwoo sugi sugi keda oluweloyi, ngulo oowali ngu gooboongoolo watayewa. Ngundilo ngulo, oni oo imiteku, ko oni oo engge yooteku nguya, ene goboolo oni oni tewali. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ngundilo ngulo, nga mandega nga ngu hamoo. Oni gulado ngu, oo yuwooyi imitoni, ko oni gulado ngu oowali enggelo mandoni yetoni, ngu yoote. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nondo kuli ye suleyelootoowe, ye ko telo oo ma imiyingomo, nguno oowali enggelo mandoni yetoni yowanggo. Oni sungombo ko kuli yanggango ko tetoyi, oowali oolelo enggewoku ngu. Yendo ngu kongga nguno ulo, oowali engge yowonggo. Yesusndo mande ngundilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Sameriya ende ulungga ngulo oni simoo bale oowooyingga oolengo, balega ngulo mandeni ngu ingolo, ngulo ene Yesusno nowoondoyemo hamoo tewonggori. Ndatelo ngulo, balega ngundo ewolo. Nondo kuli oo biyomi telo endeyowonoku, ngu bidodo yootunolo emukootelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ngundilo etoni, Sameriya endemo oni simoo bale ngu, ene Yesusno ombulo ewonggori. Ge ombutooga nooledodo ngano oluwato. Ngundilo etoyi, ngulo Yesusndo ngu endegano, nguno sa elaya oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Sa elaya nguno oodoni, nguno ngu, oni simoo bale oowooyingga nguya Yesusndo mande etoni, ngu ingolo, nowoondoyemo hamoo tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ene ngu balega nguya ewonggori. Noole gedo etoyi ingolo, ngulo noole nowoondonayimo hamoo ma tewootowolo. Kini, noole ngu noolengombo enengo manggowoomo mandeni nguya ingolo, ngulo noole nowoondonayimo hamoo teteto. Noole ingooteto. Nga oningga ngando nangge, ene mela ngalo oni simoo bale bidodo ko yoyoweloyi oni oolengolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ngu sa elayaga nguno yokolo, ene ootookoolo Sameriya ende yokolo, yade yade ooleko oololo, Galili melako tunootewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yesus enengombololo ewolo. Anutlo ingondudu eyingo oni ngu, enengo ende damonimo oowooye bingami ma tunootewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ngundilo elo, Yesus ene yade oololo, Galili melako tunootewolo. Ene tunootetoni, Galili oni ngundo Yesus kenolo, ene oni oni tewonggori. Ndatelo ngulo, ene nalu kundingiyi nguno Yesusndo Yerusalemno ko oo tewoku, ngu ene nguya oololo kenowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ngundilo telo, Yesus ene Kena ende Galili mela nguno mayelo tunootewolo. Ngu endega nguno ene kuli sono yowoolengootoni, Wayin tunootewolo. Ngu melako nguno ende gula oowooyi Kaperniyam. Nguno Gabman onilo sobosobo tabango gula oluwoku, ngu enengo nangoni ngu sayidodo oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ngu oningga ngundo Yesuslo mandeni ingowolomu ngu, Yudiya mela yokolo, ene mayelo, Galilino ooloote, elo etoyi, ingowolo. Ngulo, ene Yesus tanggeyimo oololo ewolo. Ge komo ombuya, nolo nangone kumoowelo namoko tete. Ngulo ge ombuya, yomosiyootooga mete tenilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ene ngundilo etoni, asa, Yesusndo ewolo. Ene yeno Anutndo oo sungo gula onindo ma teweloyim teteku, ngu kenolo, ngulo ye nowoondoyemo hamoo ma tetenggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Yesus ngundilo etoni, asa, Gabman onilo sobosobo oni tabangongga, ngundo Yesusno ewolo. O oni ulungga, ge komo sodedo Kaperniyam endemo ombu, no nangone kumoowelo teteku nga! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Tabango oningga ngundo ngundilo etoni, Yesusndo gumi ewolo. Ge mete oolou, gengo nangongge ngu keda oluwa. Ene ngundilo etoni, asa, ngu oningga ngu, ene Yesuslo mandeni ngu ingootoni, hamoo tetoni, ngulo ene oolouwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ngu oningga ngu ene ooloutoni, enengo yano sulena oni ooleko yeyootoni, ngundo ewonggori. Gengo nangongge keda oolootelo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ngundilo etoni, ngulo enengo sulena oniku sumoo yunolo ewonggori. Kuyowo ndawunalunggano ene sayimbo yokootoni, ene metemi tewo? Ene ngundilo etoni, enengo sulena onikundo gumi ewonggori. Ene kuyowo sa gaboyi ngu nalu gulananggemo (1 klok), moondeyi gookingo ulunggaku yokootoni, mete tewo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ngundilo etoyi, eweyi ingoyingo, kuyowo ngu nalunggano nguno nangge, Yesusndo gengo nangongge ngu keda oluwa, eneno ewolo. Ngundilo ngulo, ene Yesusno newendemo hamoo tetoni, enengo keyimo oniku nguya eneno nowoondoyemo hamoo temukowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ngu naluno, Yesus ene Yudiya mela yokolo, Galili melako mayelo, nguno ene oo sungo gula onindo ma teweloyim, ngu tambu elayayiga, nguno tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Yuda onilo nalu kundingiyi gula tunootetoni, ngulo Yesus ene Yerusalemno oolouwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yerusalem ende oonggoo pawa ngulo yamako ngu oowooyi, Sipsiplo yamako. Ngu yamakongga ngu tanggeyimo nguno sono koongeyingo gula oluwolo. Ngu Hiburu mandeno ngu oowooyi Betsayidalo ewolo. Ngu sono koongewongga ngu, dabemimo ya tookoododo kandegula oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ngu ya tookoododo nguno, sayi oni oowooyingga oolengo oluwonggo. Oni doongeye kilingomu, oni kekandeye nggiminggameyimu, ko kekandeye bingo yeyingo oni, ngudodo nguno oluwonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Nalu gidalegano, Anutlo Sambono Engel ngundo ombulo, sono newendemo ulo, sono tetoyi, lolingolo, ikakowoowolo. Oni gula ene koletelo oololo, sonono uwaku ngu, enengo sayini kinitetoni, mete tewa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ngu musiyomo nguno, oni gula ngu ya tookoododono oluwoku, ene sayidodo oodoni, mooma onibiga kande elaya kengga kegidembolo kabusa (38) nguno oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesusndo oningga ngu kenootoni wetolo oodoni, ene ingowolo. Nga oningga nga, ene nalu pelungga ene sayidodo oluwolo. Ngundilo ingolo, Yesusndo oni sayidodoga nguya sumoolo ewolo. Ge gengo gowege ngu gome metemi tewelo ingoote, bine? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ene ngundilo sumoo etoni, sayi oninggakundo Yesuslo mandeni gumilo ewolo. Oni ulungga, sono koodo oolelo ikakooteteku naluno ngu, oni gula no hooloowenelolo, noyolo sonono noyeweloyi kini. No nenengombo oolouwelo ooloutoowe, oni sungombo oololo, no daganelolo, enendo sonono koletelo oololo utenggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Etoni, asa, Yesusndo ngu oni sayidodoga nguya ewolo. Ge ootookooya, gengo yaba, oo ngu yoya, dikaya ooloulo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ene ngundilo etoni, ariya, sodedonangge ngu sayi oningga ngulo goweyi mete tetoni, ene ootookoolo, enengo yaba oo ngu yolo, dikalo oolouwolo. Ngu kongga ngu Sabat nalu kundingiyimo tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Yuda tabango onindo, oni sayidodoga ko mete tewokungga nguya ewonggori. Ataga ngu nalu kundingiyi (Sabat). Moseslo mamana mandeno ngu, ge gengo yaba koolowoolo endeyoweloyi nguya loogulo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ene ngundilo etoyi ngu, asa, ngu oni sayidodoga mete tewokungga, ngundo mandeye gumi ewolo. Oningga no yomosinelootoni mete tetenokungga, ngundo elo, nono ete. Gengo yaba oo ngu yoya, koolowooya ooloulo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ngundilo etoni, Yuda onindo sumoo inolo ewonggori. Ndawu oninggado geno ete, ge gengo yaba yoya, koolowooya ooloulo ete? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ene ngundilo sumoo etoyi, oni goweyi mete tewokungga ngu, ene onendo tewoku ngu ma ingowolo. Ndatelo ngulo, oni simoo bale oowooyingga oolengo oodoyi, Yesus ene ngu kewooloyemonggo kuli toongewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kootusina, Yesusndo ngu oninggaku goobooyingo yano kenolo ewolo. Ataga ngu ge mete tewoku nga, ge mbumbuwa gula ma tewelo. Kinitetoni ngu, kowuli gula ulungga oolengo ge moondegemo tunootewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ariya, ngu oningga Yesuslo mandeni ingolo ngu, ene oololo, Yuda onino ewolo. Nga oningga ngando no yomosinelowoku, ngu oowooyi Yesuslo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ngundilo etoni, Yuda onindo ngunonggo Yesus yombuliyoweloyimbolo damoni yewonggori. Ndatelo ngulo, ngu ooga ngu Sabat nalu kundingiyimo nguno tewoku ngulo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ene Yesusndo mandeye gumilo ewolo. Awanembo ngu nalu bidodomo ko telo oolooteku, ngundilo ngulo, no nguya ko tewanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ngundilo etoni, Yuda onindo ngu ene komo Yesus uleyi kumooweloyimbolo yanggango yewonggori. Ndatelo ngulo, Yesusndo Sabat nalungga ngulo mamana mande ngu yombuliyolo, ko nguya Yesusndo ete. Anut ngu enengo eweyi oolengolo ewolo. Ngu mandega eteku, nguno ngu, enengombo Anut ngundilo tunootete. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ariya, Yesusndo Yuda onilo mandeye gumi ewolo. Hamoo oolengo, no yeno eteno. Nangonimbo enengo ingondudunonggo oo gula ma tewa. Kini, ene oo eweyimbo tetoni kenowoku, ngu nangge tete. Eweyimbo oo bidodo teteku, ngu enengo Nangonimbo nguya ngundilo nangge tewa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Eweyimbo Nangonimbolo gome ingolo, nowoondoyi teyinolo, ngulo ene oo bidodo gome etungootoni, Nangoni nguya tete. Eweyimbo ko nga dagalo ulungga nguya etungootoni tewa. Nguno ye nowoondoye soliyokolo, ingondudu ulungga ingowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Eweyimbo oni kumooyingomu yokutuwootoni, ootookootoyi, keda oluweloyi ngu yunoote. Ngundilo nangge, Nangonimbo nguya, ene keda oluweloyiga ngu yunowelo ngu, ene mete keda yunoote. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","Eweyi Anutndo oni gulalo mandeni ma wilikoote. Kini, oni wilikoweloyi ko ngu bidodo enengo Nangoni kuli inowolo. Ndatelo ngulo, oni bidodo Anut oowooyi bingami elo okootenggoku, ngundilo nangge, enengo Nangoni nguya ngundilo oowooyi bingami elo okoowanggolo ingoote. Oni ene Nangoni oowooyi bingami ma elo okooteku ngu, asa, ene Eweyimbo, Nangoni suleyootoni ombuwoku, nguya oowooyi bingami ma elo okoote. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Hamoo oolengo, no yeno eteno. Oni ene nolo mandene ingolo, keyolo, Anutndo sulenelowoku, nguya newendemo hamoo tewaku ngu, asa, ngu oningga ngu, ene keda sugi sugi oluwa. Yo, hamoo, ngundilo oningga ngu Anutndo oni nenengo etekungga ngu, kootusina, Anutndo ene ko ma wilikowa. Kini, ene Anutya keda oluwali. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Hamoo oolengo, no yeno eteno. Nalu tunooteweloyi ngu, ataga kuli tunooteteku nga, oni kumooyingo ngu, ene Anut Nangoni ngulo manggowo ingolo ngu, asa, ene suwoo suwoo keda oluweloyi ngu yowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Eweyi enengombo ngu oni simoo bale yoyeni, keda oluweloyi ngu tunootete. Ngu yanggangongga ngu nangge Nangoni inootoni, ngulo ene nguya keda oluweloyiga ngu oni simoo bale yunoote. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ene Oni Nangoni, ngundilo ngulo, Eweyimbo oni wilikoweloyi kongga ngu ene inowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","29","Ngu hamoo, tunooteweloyi naluno tunootetoni ngu, oni bidodo kumooyingomu meleno oolootenggoku, ngu ene nenengo manggone ingolo ootookoolo, endeloko oolewanggo. Yo, hamoo, oni ene damoni gome nenengo endeyolo oluwonggoku ngu, ene keda ko ootookoolo Anutya sugi sugi oluwanggo. Ene oni damoni biyomi telo oluwonggoku ngu, ene ko ootookoolo, mandeye wilikoyingo onino oololo, dikalo, ngunonggo ene Setanlo ende biyomi nguno sugi sugi oluwanggo. Ye ngulo ma soliyokolo tewelo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Yesusndo Yuda oni tabango nguya mande ngandilo ewolo. No nenengombo nenengo ingondudunemonggo oo gula ma tewano. Kini, no Awanonggo mande ingowonomu ngu nangge keyolo, no oni wilikoyelowano. Nolo mande wilikoyingo ngu nenengo oolengo. Ndatelo ngulo, no nenengo ingondudune ma keyooteno. Kini, Awando no sulenelootoni, ombuyingongga ngulo manggowo nangge keyolo ko teteno. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ene no gulanangge, nondo nangge nenengo mandene wesiyolo elo ngu, asa, ngu mandega wesiyolo ewonoku, ngu hamoo kini. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ene gula (Anut) nguya oolooteku, ngundo ene nolo mande elo yootunoote. Ngu nolo mandega ewoku, ngu hamoo oolengolo ingooteno. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Kulimi, yendo oni gula suleyootoyi, Yonno oololo, ene nolo mande wesiyolo etoni ingowonggo. Mande bidodo ingowonggoku ngu, ngu hamoo mande nangge. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Oni dikalo, nolo mande, oowoone elo yootunootenggoku, ngulo no ma ingondudu teteno. Ene nondo ngu Anutndo ye ko yoyoni elo, ngulo gome ingooteno. Ngundilo ngulo, nondo nga mandega nga yeno etenoku, ngu Yonlo koni ngulo mande ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yon ngu solu ngundilo delo, oni simoo bale himi gomemo yunowolo. Yengo nowoondoye ngu mete tetoni, ye nalu ootuwoo bodaga enengo himimbolo oni oni tewonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ene nolo kone, damonine, oo sungo gula onindo ma teweloyim, ngu ye kewooloyemo tewonoku, ngundo Yonlo mande hamoo ewoku, ngu dagawolo. Ene ataga nolo damonine ngu nga yootunolo ete. Ko bidodo awando no nunowoku ngu, no temukowano. Yo, hamoo, nondo ko tetenoku, ngu enengombo oni simoo bale etuyelootoni, Awando no sulenelootoni, no ombuwonolo ingowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Awando no sulenelootoni, ombuwonoku, ngu enengombo no yootunonelolo, mande elo yunowolo. Yo, hamoo, ye enengo manggowo bodaga ma ingolo, ko enengo omukumundoongo nguya ma kenowonggori. Ene enengo mande ngu bukno ooloote. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ene ye ngulo mandeni nowoondoyemo ngu ma ooloote. Ndatelo ngulo, ye Anutndo no sulenelootoni ombuwonoku, ye ngulo nowoondoyemo hamoo ma tewoowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","40","Ye ngandilo ingootenggo. Anutlo mande so uyi nakangoyingo, ngundo suwoo suwoo keda oluweloyi kedaga ngu yunootoni, suwoo suwoo gome oluweloyilo etenggo. Ngundilo ngulo, ye mande bidodo ngu so uyi nakango ngu newendemo oolooteku, ngulo koyi telo erewetenggo. Ene ngu oo naka, ngu nolo yootunolo ete. Ene ye nono ombulo suwoo suwoo keda oluweloyiga ngu ma yowelo ingootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","No onindo bingamine eya okooyi elo, ma sumoo yunooteno. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ene nondo ye ingooteno. Yendo ngu, yengo nowoondoyemo Anutno hamoo ma telo oolootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","No kuli awanembolo oowooyimo ombuwonoku, ene ye nolo mandene ma yolo ingootenggo. Ene oni gula enengo oowooyimo elo ombuwaku ngu, ye ngulo mandeni ngu ye hahangelo yolo ingowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ye yengo bingamiye ngu yengo dobooguliyemonggo yootenggo. Ene ngu bingamingga ngu Anutndo yunowelo ingooteku, ngu ye yowelo ma ingootenggo. Ngundilo ngulo, ye nowoondoyemo hamoo ma telo, ngulo nguya ma ingootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ye nowoondoyemonggo ngandilo ma ingowelo, nondo Awano ye wilikoyelowelo mande eweloyi kini elo, ma ingootenggo. Ye Mosesndo nangge ye hoolooweyeloweloyi elo, ingondudu tetenggo. Kini, ngu ingonduduga ngu nenengo kini. Mosesndo ngu yengo wilikoyeloweloyi oni. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mosesndo nolo newendemo hamoo tewolo. Ngulo ngu, ye Moseslo mande nowoondoyemo hamoo telo ngu, ye nolo mandene nguya nowoondoyemo hamoo tewanggo. Ndatelo ngulo, Mosesndo ngu ene nolo mandene nakangowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ene ye Mosesndo mande nakangoyingo ngu nowoondoyemo hamoo ma telo ngu, ye ndatelo telo ngu, ye nolo mandene ngalo nowoondoyemo hamoo tewanggo? Ye ereremo kini! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ngu mandega ngu kinitetoni, Yesus ene Galili mela ngulo sono koongeyingo oowooyi Tayibiriyas, (Galili) ngu anduloko nguno ulelewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Nguno ulooletoni, oni simoo bale oowooyingga oolengo, ngundo Yesusndo oo sungo gula onindo ma teweloyim sayi onino tetoni, ngulo ene Yesus kenolo, keyolo endeyowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ene ngundilo tetoyi, Yesusndo enengo sulena onikuya pulimo oolelo, nguno bibitewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ngu naluno nguno, Yuda onilo Pasowa nalu kundingiyi, ngu namoko tete. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","6","Yesus doongetelo, endeyolo, oni simoo bale oowooyingga oolengo yeyootoni, ene tanggeyimo ombuwonggori. Ombutoyi, Yesusndo oo teweloyi kuli ingolo, ngulo ene Pilip tewoongolo, ngandilo sumoo ewolo. Noole oomanongoyingo ndanonggo uliyolo, nga oni simoo bale nga yunootooye newanggo? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pilipndo mandeni ngu ingolo, gumilo ewolo. Noole sa nalu onibiga (200) ko tetooye ngu, ko ngulo uliyi yowatoku, ngundo nga oni simoo bale ulungga ngalo oomanongoyingo bodaga uliyootooye, ma mete tewa. Hamoo oolengo kinilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ngu naluno nguno, Yesuslo sulena oni gula, oowooyi Enduru, ngu Sayimon Pita koneyo, ngundo Yesusnolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Simoo kosiyi gula nooledodo ngano oolooteto. Ngundo ene oomanongoyingo kandegula ko iso elaya bodaga nguya moole. Ene ngundo oni simoo bale ngandilo ulungga nga ma mete tewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ene ngundilo etoni, asa, Yesusndo ewolo. Simoo baleno etoyiga, ene bibiteyi, so gome gome nguno oluwolo. Ene ngundilo etoyi ngu, asa, oniku nguno bibitewonggori. Ngu simoo ngu bidodo gooboongootoni, ngu ulungga oolengo (5,000). ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Oni simoo bale bibitemukootoyi, Yesusndo ngu oomanongoyingoku yolo, Anutno esetelo, enengo sulena oni yunootoni, ngundo bayetelo, oni simoo bale yunowonggori. Ngundilo telo, Yesus ene iso elayagaku nguya yolo, Anutno esetelo, bayetelo yunootoni, nelo, ene useye mete tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Oowali netoyi mete tetoni, asa, Yesusndo enengo sulena onikuno ewolo. Ye oowali netoyi sosolango gumgum oolooteku, ngu yoya, ngu gula ma yokootoyi biyomi yewelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ngundilo etoni, ene oowali oomanongoyingo gumgum gooboongoolo, siliyootoyi, si kande elaya kegidembolo elaya hangewolo. Ngu oowali oomanongoyingo kandegulaga, ngu netoyi, gumi oodoni, ngundilo siliyowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Oni simoo bale ngu oo sungo gula onindo ma teweloyim, ngu Yesusndo tetoni kenolo ewonggori. Hamoo oolengo, nga oningga nga, ene Anutlo ingondudu eyingo oni Mosesndo sobowooyi, elo ewoku, ngu nga oninggaku nga! Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ene ngundilo etoyi ngu, ariya, Yesus ene ingowolo. Oni simoo baledo ene dowoolo, enengo mela nga oo bidodo sobosobo ulungga yeweloyimbolo ingowonggori. Ngundilo ngulo, Yesus enesu nangge oololo, mela pulimo oolewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ngu nalungga ngu suwoo tetoni, Yesuslo sulena oniku sono koongeyingomo uwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ene wanggo gula sanganimo oolelo, ene sono koongeyingo kewoolo oolengowoole oolouwonggori. Ene Kaperniyam endemo ulelewelo ooloutoyi suwootewolo. Suwootetoni, Yesus eneno ma tunooteyingo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ngu naluno nguno, doogo yanggango ulungga oolengo yootoni, sono koongeyingonggaku dookelo, pigipokuli ulungga yewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ene wanggo woosoolo bodaga yowoko (Kilomita) kandegula (5) ngundi kandegula gidembolo gulanangge (6) ngundilo oololo ngu, ene Yesus kenootoyi, sono koongeyingo sanganiwoole eneno ombuwolo. Yesus yade oololo, wanggo tanggeyimo ombuwelo tetoni, ngulo enengo sulena oniku sosoleyingo ulungga oolengo tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ene Yesusndo enengo sosoleyingo, ngu yeyolo ingolo, ngulo ene sodedonangge ewolo. Ye ma sosolewelo! Nondo nangge, yeno ombutenoku nga! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ene ngundilo etoni, ariya, enengo sulena onikundo Yesus wanggo sanganimo oolenilo etoyi, ngulo ene sanganimo oolewolo. Ooletoni, wanggo ngu naluno nangge, melangga sawelo ewonggoku, nguno tunootewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Sengetoni, oni simoo bale sono koongewo anduloko oluwonggo. Ene ngandilo ingowonggori. Kuyowo wanggo gulanangge oodoni, nguno Yesus ooletoni, ngu ma kenowonggori. Kini, enengo sulena oni ngundo nangge wanggo ngu sanganimo oolelo sawonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ene ngu naluno nguno, wanggo gidega Tayibiriyas endemonggo ngu mayelo, sakiko oni simoo bale oolootenggoku, nguno gosiyowonggori. Ngu musiyonggano, nguno Yesusndo kuli oomanongoyingo Anutno esetelo yunootoni, newonggoku melanggano nguno. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Oni simoo baledo, ngu Yesus enengo sulena oni nguya, ereweyelolo, ene nguno ma yeyowonggori. Ene ma yeyolo, ngulo ene wanggo gidega sanganimo oolelo, Yesus erewelo Kaperniyam endemo oolouwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Oni simoo bale ngu Yesus sono koongeyingo anduloko kenolo, sumoo inolo ewonggori. Oo etuyeloyingo oni ulungga, ge ndawu nalunggano ngano mayewo? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ene ngundilo sumoo etoyi ngu, asa, Yesusndo mande gumi ewolo. No hamoo oolengo, yeno eteno. Ye oo sungo gula onindo ma teweloyim, nondo tetoowe tunooteteku ngu, ye ma kenolo ingolo, ngulo ye no erewenelootenggo. Kini, ye no erewenelootenggoku ngulo damoni ngandilo. Ye oomanongoyingo newonggoku, ngundo useye bakini yewoku, ngulo ye no erewenelootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ye oowali ngundilo biyomi yeweloyi, ngulo nangge, ma koyi telo yowelo. Kini, ye komo oowali sugi sugi oluweloyi ngulo koyi teya yoyi. Ngu oowalingga ngu Oni Nangoni ngundo ye yunowa. Yo, enengo eweyimbo ngu kongga ngulo eneno elo sunggi yewolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ngundilo etoni, enebana Yesusno sumoo inolo ewonggori. Noole komo ndatelo telo, noole Anutlo ko ngu tewato? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ene ngundilo sumoo etoyi, asa, Yesusndo gumi ewolo. Anutlo koni ngu ngandilo. Ye komo nga oningga Anutndo suleyootoni, ombuyingo, ngulo ye nowoondoyemo hamoo teyilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ngundilo etoni, enebana Yesusno sumoo ewonggori. Ge ndatelo oo sungo gula onindo ma teweloyiga ge tewaku, ngulo noole ngu kenolo, gengo mandege ingootooye, nowoondonayimo hamoo tewa? Ge ndawu kongga tete? ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Noolengo osi sambanayi, ene kuli oni kini melako ootoolo, nguno ene oowali gula yolo newonggori. Ngu oowalingga ngu oowooyi Mana. Anutlo mandeno ngandilolo ewolo. Ene Sambo endemo oowali ngu yunootoni, yolo newolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ngundilo etoyi, Yesusndo ewolo. Hamoo oolengo, no yeno eteno. Mosesndo Sambo endemo oomanongoyingo ye ma yunowolo. Kini, nolo Awane ngundo Sambo endemo oowali oolengo ngu ye yunowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Nga oomanongoyingo hamoongga nga, ngu Anutndo Sambo endemonggo oningga suleyootoni ombuyingongga ngu. Ombulo, ngundo keda oolengo oluweloyi ngu oni simoo bale melako ngano oolootenggoku, ngu yunootelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ngundilo etoni, onikundo Yesusno ewonggori. Oni ulungga, ge komo ngu oowali oomanongoyingongga ngu suwoo suwoo noole yunoyatolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ene ngundilo etoyi, asa, Yesusndo gumi ewolo. Nondo nangge, no suwoo suwoo keda oluweloyi ngulo oomanongoyingo oolengo. Oni ene nono ombulo ngu, ene oowalilo ko ma kumoowa. Ngundilo nangge, oni nolo newendemo hamoo teteku ngu, ene sonolo ko ma ingolo hahangewa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nondo yeno eteno. Ye kuli no neyowonggoku, ene ye nono nowoondoyemo hamoo ma tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Oni simoo bale bidodo ngu Awando no nunootoni, ene nono ombuwanggo. Oni nono ombuwanggoku, ngu nondo ene ma oweyelootoowe, sawanggo. Hamoo oolengo kini! ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","No Sambo Endemonggo ombuyingo ngu, no nenengo ingondudune keyowelo ma ombuwonowo. Kini, no mela ngano ombuwonoku ngu, nolo Awane, ngundo no sulenelootoni, ombuwonokungga, ngulo ingonduduni nangge keyolo ombuwonowo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","No sulenelootoni ombuyingo, Awanengga ngulo ingonduduni, ngu ngandilo. Oni simoo bale ene kuli no nunoyingo, no ngu gula ma yokowano. Kini, no komo nalu sosowoomo ko yokutuyelootoowe, ootookoowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nolo Awanembolo ingonduduni ngu ngandilo. Oni bidodo nangoni kenolo, ngulo nowoondoyemo hamoo telo ngu, asa, ene suwoo suwoo sugi sugi kedaga ngu yowanggo. Nondo kootusina nalu sosowoomo ko yokutuyelootoowe ootookoowanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yesusndo ewolo. No nangge, no nga oomanongoyingongga ngando Sambo ende ngu yokolo, ombuwonoku nga! Yesusndo ngundilo etoni, ngulo Yuda onindo ngu ingolo sanggili telo, mande mande ulungga eneya ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Enendo ewonggori. Nga Yesus oningga nga, ngu Yoseplo nangoni. Noole enengo eweyi nemi nguya ingooteto. Ndatelo ngulo, ene ngandilo ete. Nondo Sambo ende yokolo ombuwonowo, elo ete? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ene mande ngundilo etoyi, asa, Yesusndo mande gumi ewolo. Yengo nangge mande oowooyingga elo, ma boguwoolo oluwelo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Oni gula kingo nono ma ombuwa. Kini, Awando no sulenelootoni, ombuwonoku, ngu enengombo oni gula ingoyingo inootoni, ngunonggo ene nono ombuwaku ngu, asa, nalu sosowoomo, nondo yokutuwootoowe, ene ko keda ootookoowa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Mande nga ngu, Anutlo ingondudu eyingo onilo nakayano ooloote. Anutndo oni simoo bale bidodo etuyelowalo ewolo. Oni bidodo ene Awalo mandeni ingolo yootenggoku ngu, asa, ene nolo nguya ingootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Oni gulado ene no Awane kuli ma kenowolo. Kini, nga oningga ngando nangge, ene Anut tanggeyimonggo ombuwoku, ngundo nangge ene Anut kenolo oluwoli. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Hamoo oolengo, no yeno eteno. Oni nolo newende hamoo tewaku ngu, ene ngu suwoo suwoo sugi sugi keda oluwa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nondo nangge, no oowali oomanongoyingo oolengo suwoo suwoo keda oluweloyiga ngu! ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Kulimi yengo osisambayebo, ene oni kini melako oluwonggoku, nguno ene Sambononggo Mana nelo, ene kuli kumoomukowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ene nga oowali oomanongoyingo hamoongga, ngu Sambo endemonggo yokootoni, melako ngano ombuyingongga nga, oni ngu nelo ngu, ene ma kumoowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","No nga oomanongoyingongga nga ngu, suwoo suwoo keda oluweloyiga nga Sambo ende yokolo, melako ngano ombuwonowo. Oni gula ene ngu oowali oomanongoyingongga ngu nelo ngu, ene suwoo suwoo keda oluwa. Yo, hamoo, nenengo gowene nga ngu, mela ngalo oni simoo balelo woolo yeweloyimbolo yunootoowe, ene nguno suwoo suwoo keda oluweloyiga ngu yowanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ngundilo etoni ngu, Yuda onindo enengo nangge longgeyolo ewonggori. Ndatelo ngulo, nga oningga ngando enengo songgiwi ngu noolendo neweloyi yunowa? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ene ngundilo etoyi, ngulo Yesusndo Yuda oninolo ewolo. Hamoo oolengo, no yeno eteno. Ye Oni Nangoni, ngulo songgiwi ma nelo, ko ye ngu oningga ngulo daloni nguya ma nelo ngu, asa, ye suwoo suwoo kedaga ngu yengombo ma yowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Oni ene nolo songgiwi nelo, ko dalone nguya newaku ngu, ene suwoo suwoo gome keda oodoni, nondo nalu sosowoomo yokutuwootoowe, ko keda ootookoowa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ndatelo ngulo, nolo songgiwine, ngu oowali oolengo, ko nolo dalone ngu, neweloyi sono gome oolengo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Oni ene nolo songgiwine, dalone nelo ngu, ene noya oodoni, no eneya oluwalo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Awa ngu ene suwoo suwoo sugi sugi oluweloyi keda ngudodo, ngundo no sulenelootoni ombuwono. Ngulo ngu, no keda yanggango Awanemo oolooteno. Ngundilo nangge, oni no nonelo ngu, ene ngunonggo yanggango yolo, ene noya sugi sugi keda oluwalo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ngangga nga, ngu ene oowali oomanongoyingo oolengo Sambo endemonggo suleyootoni ombuwolo. Nga ngu kuli osi sambado oomanongoyingo nelo kumooyingo, ngundilo kini. Oni nga oomanongoyingongga nga nelo ngu, ene suwoo suwoo keda sugi sugi oluwalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesusndo Kaperniyam ende ngulo goobooyingo ya newendemo, nga mandega nga elo etuyelowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ariya, sulena oni oowooyingga Yesuslo mandeni ngu ingolo ewonggori. Nga mandega nga ngu, kowuli oolengo. Onendo ene mete ingowa? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ene Yesusndo newendemonggo ingooteku ngu, sulena onindo mande ngulo boguwootoyi, ngulo ewolo. Nondo nga mandega etenoku, ngando yengo ingonduduye yombuliyoote, bine? ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ariya, ye Oni Nangoni kuli Sambo endemo oluwoku, nguno ko ooletoni, kenolo ngu, ye ndatelo ewanggo? ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Yuka Kundingiyi, ngundo oni suwoo suwoo keda oluweloyi ngu yunoote. Ene oni enengombo oni keda yunoweloyi ngu ereremo kini. Ene nga mandega nondo ye yunolo etenoku nga ngu, ene Yuka Kundingiyi ngundo yeni, ene suwoo suwoo keda oluweloyiga, ngu yeno oluwa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ene Yesusndo ene kulimimonggo oni ene kewooloyemo, nowoondoyemo hamoo kini ngu ingolo, ko kootusina, oni ngundo ene dowoolo, mundi oni kandeyemo yeweloyi nguya, ene kuli ingowolo. Ngundilo ngulo, ene ngandilo ewolo. Ye kewooloyemo nguno oni gidalega ngu, ene nowoondoyemo hamoo ma tewolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Yesusndo mande ngu soweyolo ewolo. Ngu damoninggano nguno, no yeno eteno. Ene Awando yo elo ma etoni ngu, asa, ngu oningga ngu ene nono ombuweloyi nguya kini. Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Yesusndo mande ngundilo etoni, ngulo enengo sulena oni ulungga ene Yesus yokolo, enengo endemo ko sawonggori. Ene Yesus keyolo, ko ma endeyowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ngundilo tetoyi, Yesusndo yowoolengolo, enengo sulena oni kande elaya kegidembolo elayaga, nguno elo ewolo. Ye nguya bine, no noyokolo sawanggo? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ene ngundilo etoni ngu, Sayimon Pitando gumi elo ewolo. Oo Bidodo Sembuli Sembunayi Ulungga, noole ndawu oninggano oolouwato? Gengo mandege ngu suwoo suwoo keda gome oluweloyimbolo yunoote. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Noole nowoondonayimo hamoo tetoni, ngandilo kuli inooteto. Ge nangge, oni kundingiyi Anutndo sulenggelootoni ombuwolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesusndo enengo sulena onikulo mandeye gumilo ewolo. Yo, hamoo, nondo ngu ye kande elaya kegidembolo elayaga kuli logoyelowono. Ene ye kewooloyemo nguno, oni gulano boolomboyoyingo biyomi eneno oolootelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yesusndo ngu Yudas, Sayimon Iskariyoot nangoningga, ngulo ewolo. Ngu oningga ngu Yesus enengo sulena oni kande elaya kegidembolo elayaga ngulomu gula. Enendo kootusina Yesus dowoolo, me oni kandeyemo yetoni uleyi kumoowa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ngu naluno, Yesus ene Galili mela nguwoole ko telo, oololo ombulo telo, ene Yudiya melasina ko oolouwelo ma ingowolo. Ndatelo ngulo, Yuda onindo ngu uleyi kumoowelo tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Yuda onilo nalu kundingiyi, oowooyi Towimbo ya Tookoododo (Sel Ya) Nalu Kundingiyi, ngu namoko. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ngundilo ngulo, enengo konedoboongombo Yesusno ewonggori. Ge komo ootookooya, nga endega nga yokoya, ge Yudiya melako oolou! Gengo sulena oni ngundo ene mete gedo ko teteku, ngu kenowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Oni gula ene tunoo oni doongeyemo oluwelo ngu, ene oo tewelo nguya, kombitelo ma tewa. Yo, ge ko oo nga tunoo tewaku ngu, asa, oni simoo bale bidodo doongeyemo ge tunoo dikalo, ko mete telo etuyelowalo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Yesus enengo konedoboongo nguya, Yesusno nowoondoyemo hamoo kini. Ngulo ene ngundilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ngundilo ngulo, Yesusndo ewolo. Nolo nalune, ngu ma tunootewolo. Ene nalu bidodo ngu yengo naluye. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Mela ngalo oni simoo baledo yeya mundi ma tewanggo. Kini, ene ngu nolo me oni tewanggo. Ndatelo ngulo, nondo enengombo damoni biyomi tetenggoku, ngu yootunolo etenoku ngulo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Yengombo oolouya, ngu nalu kundingiyingga ngu kenoyi. Kootusina no nguya nalu kundingiyingga nguno oolouwanoku, ene ataga no nguno, no ma oolouwanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yesusndo ngundilo elo, ngulo ene sa nalu gidega Galilino oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Yesus enengo konedoboongo ene nalu kundingiyi ngu kenowelo kuli Yerusalemno oolouwonggori. Kootusina, Yesus ene nguya Yerusalemno oololo, ene oni doongeyemo tunoo ma oolouwolo. Kini, ene tolige nalu kundingiyi nguno oolouwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Yuda onindo, nalu kundingiyi nguno, ene erewelo ewonggori. Yesus oningga ngu ndano ooloote? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Oni simoo baledo Yesuslo mande mande ulungga oolengo, enengo nangge ewonggori. Oni gidalegado, ene oni gome, etoyi, gidalegado ewonggori. Kini, ngu oningga ngundo simoo bale ganaganayelolo endeyootelo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ene Yuda tabango onilo sosolelo, ngulo oni gulado Yesuslo mandeni tunoo ma elo endeyowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Nalu kundingiyi ngu kewooloko, Yesus ene goobooyingo ya ngulo yasiliko ulo, oni simoo baleno mande elo etuyelowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Yuda oni mandeni ngu ingolo, ngulo ingondudu ulungga telo ewonggori. Nga oningga nga, ndanonggo ingoyingo nga yolo, ete? Ene kuli ngu oo ngulo ingondudu yowelo ma Skul tewolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ngundilo etoyi, Yesusndo enengo mandeye gumi ewolo. Nga mandega nondo yeno etenoku nga, nolo mandene kini. Nga mandega nga ngu, Anutlomu. Enendo no sulenelootoni, no ombuyingo ngulo mandeni eteno. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ene oni gula Anutlo mandeni keyolo ingowelo ngu, ngu oningga ngu, ene nga mandega elo etuyelootenoku, ngalo damoni ingowa. Ene ngandilo ingowa. Nga mandega nga, ngu Anutlo ingondudunonggo bine, ngundi no nenengo ingondudunemonggo eteno bine, ngu wilikoya ingoyi. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Oni enengo ingondudunimonggo, mande mande ewaku ngu, ene nguno oowooyi bingamidodo teweloyim tete. Ene oni ene suleyootoni, ombuyingongga ngulo oowooye bingami elo okoowaku ngu, asa, ene oni nenengo oolengo telo, ene ebe ganagana ma ewa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Kulimi Mosesndo mamana mande ye yunowolo. Ene ye kewooloyemo nguno oni gulado ngu mamana mandega ngu ma keyoote. Ndawugalo, ye no nulewelo ingondudu tetenggo? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ene ngundilo etoni, simoo baledo mandeni gumi ewonggori. Geno oo yuka biyomi gula oolooteku ngu! Onendo ge guleni kumoowa? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ene ngundilo etoyi ngu, Yesusndo mandeye gumi ewolo. No kuli oo sungo gula onindo ma teweloyi ngu tewonoku, ye ngu kenolo ngulo soliyokowonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mosesndo goweye doongoolo, yomosiyoweloyi mande damoningga ngu, ye yunowolo. Hamoo, ngu damoningga ngu Mosesno ma tunootewolo. Kini, ngu damoningga, ngu osi sambano tunootewolo. Ene yendo ngu yengo nangosumooye ngu, Sabat naluno nguya goweye doongootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Yendo ngu Moseslo mamana mande ngu keyowelo ingolo, ye nangosumooye gula Sabat naluno tunootetoni ngu, asa, ye Sabat naluno goweyi doongoolo yomosiyootenggo. Ariya, nondo ngu Sabat naluno nguno, no oni gula sayidodomu yomosiyootoowe ngu, yendo ndawugalo ngulo noya sanggili tetenggo? ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ye oo doongeyembo nangge kenolo, ngulo elo ma wilikowelo. Kini, ye komo oo bidodo damoni gome nenengo nguno wilikowanggoku, ngu metemilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Yerusalem ende ngulo oni simoo bale gidalegado elo ewonggori. Ndatelo ngulo, nga oningga nga nangge uleyi kumoowelo tetenggo? ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Kenoyi, ene mande mande tunoo oolengo eteku nga, ene oni ululu ngundo mande gula eneya ma etenggo. Ene nguya bine nga oningga nga ene Kristuslo ingootenggo? ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ene noole nga oningga ngalo endeni ngu noole ingooteto. Kristus tunootewelo naluno ngu, oni gulado ngulo endeni ngu kenolo ingoweloyi kinilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesus ngu Tempel ya newendemo ootoolo ngu, onino mande elo etuyelolo oode, ngunonggo ene manggalu telo ewolo. Yengo ingoyingoyemo ngu nolo ingolo, ko nolo endene nguya ingootenggo. Ene no nenengo ingonduduno ma ombuwono. Kini, Awando sulenelootoni, no ngano ombuwono. Awa enengo damoni ngu hamoo oolengo, ene yendo ngulo ma ingootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ene nondo ngu Awane ingooteno. Ndatelo ngulo, no kuli eneya oluwolo, enendo no sulenelootoni, ngano ombuwonolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ngu naluno, ene dowoolo ya biyomimo yewelo tewonggori. Ene Yesuslo nalu ma tunootewoku, ngulo oni gulado Yesus dowoowelo ma tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ene oni simoo bale oowooyingga Yesusno nowoondoyemo hamoo telo ewonggori. Kristus ombulo ngu, nga oningga ngando oo sungo gula onindo ma teweloyim teteku, nga dagalo, enendo oo ulungga oolengo tewa, bine? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Parisi oni ingootoyi, oni simoo baledo Yesusya mande guladilo guladilo ewonggori. Ngundilo ngulo, Anutno woolo yeweloyi ngulo sobosobo oni, ko Parisi oni nguya, ngundo enengo kumba ootuwoo oni gidalega suleyelootoyi, Yesus dowoolo, ya biyomimo yewelo oolouwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ngu naluno nguno, Yesusndo ewolo. Nalu bodaga nangge no yeya oode, Awando sulenelootoni, no ombuwonokungga, ngu tanggeyimo no ko oolouwano. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","No oolouwanoku, ene ye no erewenelolo, ko ma neyowanggo. No oolootenoku endegano nguno, ye nguya oolouweloyi kini. Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ene ngundilo etoni ngu, asa, Yuda oni enengo nangge mande mandelo ewonggori. Ene ndawoole utoni, noole ene ko ma kenowato? Ene bine, noolengo doboogulinayi, Girik oni, enengo mela kewoolokono ulo, nguno Girik oni, mande yunolo etuyelolo oodoni, nguno noole ene ma kenowato? ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Mande eteku, ngulo damoni ndatelo ete? Ene ngandilo ewolo. Ye no erewenelolo, ye no ma neyowanggo. Nondo endega oolootenoku, nguno ye nguya, ma oolouwanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Kundingiyi nalu wengangga, ngu enengo nalu kundingiyi ulungga. Ngu naluno nguno, Yesus ootookoolo, dikalo, manggalu telo ewolo. Oni oowooyingga sonolo ingoya ngu ene komo no tanggenemo ngano ombuya, sono nga neyi. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ngungga ngu, Anutlo mande so uyi nakangoyingo, ngundo ngandilo ete. Oni ene nolo ingootoni newendemo hamoo telo oolooteku ngu, ene newendemo ngunonggo suwoo suwoo sugi sugi keda oluweloyi, ngulo sono ulungga oolelo ulooluwalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesusndo Yuka Kundingiyi oo ngulo ewolo. Oni simoo bale ene Yesusno nowoondoyemo hamoo telo, ngundo ngu Yuka Kundingiyi yowanggo. Ene ngu nalunggano nguno, Anutndo Yesus enengo dulidalini ngu yolo ma teyinowolo. Ngulo ngu, Anutndo Yuka Kundingiyi nguya ma suleyootoni ombuwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Oni simoo bale gidalega, ngu mandega ngu ingolo ewonggori. Hamoo oolengo, nga oningga nga ngu, ene Anutlo ingonduduni eyingo oni, noole sobowootetokungga ngundolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ene ngundilo etoyi, gidalegado ewonggori. Ene Kristus Anutndo noole ko yoyoweloyi sunggi yewo oni ngu! Ewonggori. Etoyi, ene oni gidalegado ewonggori. Galili melako nguno Kristus mete tunootewakulo bine? ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Kini, Anutlo mande so uyi nakangoyingo ngundo kuli ete. Kristus ngu Dewitlo soweni ngulomu. Ngu Betelehem endemo nguno tunootewa. Ngu endega ngu Dewitndo kuli oluwolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ngulo ngu, simoo bale usowoolo, wata elayaga tetoyi, wata gulado Yesusya sanggili telo, mundi tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Yo, hamoo, oni gidalegado dowoolo, ya biyomimo yewelo ewonggori. Ene oni gulado kandeyi sodedo Yesusno ma yelo dowoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ngundilo ngulo, kumba ootuwoo oni ene Tempelno ko ooloutoyi, woolo yeweloyi sobosobo onindo, ko Parisi onindo ene yeyolo ewonggori. Ye ndawugalo, Yesus oningga ngu yolo ma ombuyingo? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ene ngundilo etoyi ngu, asa, kumba ootuwoo onikundo mande gumi elo ewonggori. Kulimi oni gulado ngundilo ingondudu mandega ande oningga andedo mande eteku, ngundilo ma ewololo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ngundilo etoyi, Parisi onindo sanggili telo, mande gumi ewonggori. Enendo ye nguya ganayeloote bine? ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Noole tabango oni, ko Parisi oni nga kewoolokono gula kenootoyi, ene ngu Yesus oningga, ngulo newendemo hamoo tete, bine? Hamoo oolengo, kini! ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ene nga oni simoo bale nga ngu, ene mamana mande ma ingootenggo. Ngulo ene Anut doongeyimo kuli biyomi yemukowonggolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodimas ngu nalu gulano, Yesus tanggeyimo oolouyingo, ene nguya ngu tabango oni ngulomu gula, ngundo sumoo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Noolengo mamana mande ngando oni mandeni ma ingolo, nguno mete wilikowa, bine? Kini, koletelo noole enengo mandeni wilikolo ingologo, nguno ngu, noole mete oo enendo teteku, ngu gome oolengo ingowatolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ene ngundilo etoni ngu, asa, tabango onikundo mandeni gumi ewonggori. Ge nguya Galili oni, binengga? Anutlo mande nakangoyingomo oolooteku, ngu gome kandangeya ingo. Anutlo ingondudu eyingo oni gula Galili melako ma tunootewalo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ariya, oni bidodo enengo yano ko oolouwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Oni simoo bale bidodo enengo yano samukootoyi, ene Yesus Olib pulimo oolewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Sengetoni suwoononggo, Yesus ene ootookoolo, Tempel yasiliko oolouwolo. Nguno oni simoo bale bidodo Yesus tanggeyimo ombulo gooboongootoyi, Yesusndo mande elo etuyelolo bibitelo oluwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ngu naluno, mamana mande etuyeloyingo oni, ko Parisi oni, ngundo ooleko ooleko bale gula enengo kameyi yano oodoni, ene oololo simoo gulaya wedoni, kenowonggori. Ngundilo oo biyomi tetoni, ngulo kenolo, yolo ombuwonggori. Oni Yesusya gooboongoolo oodoyi, ngu kewooloyemo yeyi dikawolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ene ngundilo telo, Yesusno ewonggori. Oo etuyeloyingo oni, nga balega nga ngu enengo kameyi oodoni, ene oololo, simoo gidalegaya bosebalese telo endeyootoni kenowonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moseslo mamana mande ngundo nooledodo ngandilo ete. Bale gula ngundiya tetoni nga ngu, asa, digi yoya, yudoyiga kumooyilo ewolo. Ene gedo ngu ndatelo ete? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ene Yesus tewoongowelo elo ngundilo tewonggori. Ene nguno Yesusndo mande biyomi gula etoni, ene ngunonggo Yesus yolo, mande wilikoyingo onino yelo, ene ganangolo, mande ebe ganaganangga etoningga ingowootolo tewonggori. Ene ngundilo sumoo etoyi, Yesus ene nenetelo, melasina penggootelo, kandedibiyibo mela bungomo oo nakangowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ene ngundilo tetoni, tabango onikundo sumoo sumoo ulungga elo oodoyi, asa, Yesusndo ootookoolo ewolo. Ye kewooloyemo nguno, oni gula ene mbumbuwani kiningga, ngundo ene mete koleteya, digi yoya, nga balega nga bungomo oolongoonilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Yesusndo ngundilo elo yokolo, asa, ene melako ko penggootelo, mela bungomo ko nakangowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Tabango oniku mande ngundilo ingolo, ene bidodo gulanangge nangge endesina oolewonggori. Oni tabango ulungga ene mande damoni yelo ewoku, ngundo oolelo toongetoni, sungoku bidodo ende oolelo samukowonggori. Yesusndo enesu nangge penggootelo oodoni, ko balega ngundo nangge Yesus tanggeyimo dikalo oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesus ootookoolo, dikalo, balegakuyalo ewolo. Bale, oni geya ewonggoku, ndano? Oni gula ngano, gengo biyomingga, ngu eweloyi nguya kini, bine? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ene mande ngundilo etoni ngu, balega ngundo gumi ewolo. Oni Ulungga, ngano oni gula kini. Etoni, Yesusndo gumi ewolo. No nguya gengo biyomingga ngulo ma ewano. Ge toongelo, kootusina mbumbuwa gula ma tewelolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesusndo ene ko ewolo. No ngu mela ngalo solu himi. Oni ene no neyolo kenelolo ngu, ene ooleliko ma endeyowa. Kini, enengo keda oluweloyiga ngu, ene solu himidodo oluwalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ene mande ngundilo etoni, asa, Parisi onindo Yesusdodolo ewonggori. Ge, gengombolo mandege elo wesiyoote. Ngundilo ngulo, gengo mandege ngu hamoo kinilo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesusndo mandeye ngu ingolo, gumi ewolo. Ngu hamoo, nondo nenengo mandene yootunolo eteno. Ene nolo mandega ngu hamoo oolengo. Ngundilo ngulo, no nenengombo ootookoolo ombuwonomu endega ngu ingooteno. No nganonggo nguno oolouweloyi ngu, no ingooteno. Ene yendo nolo ende damoni ngu ma ingootenggo. No ndawoole toongewanoku nguya, ye ma ingowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Yendo ngu mela ngalo damonimo oni wilikoyelootoyi, ene nondo ngu oni ma wilikoyelooteno. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ene nondo oni wilikowelo ngu, no oni gome nenengo wilikowano. Ngundilo ngulo, nondo noso nangge oni ma wilikoyelooteno. Kini, Awane no sulenelootoni ngano ombuyingongga, ngu noya goboolo ko tetelo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Yengo mamana mandeno ngu ngandilo ooloote. Oni elaya enengo mandeyali elo wesiyooteliku, ngu gulanangge etoli ngu, asa, ngu oni elayaga ngulo mandeyali, ngu hamoolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","No nenengo mandene wesiyolo etoowe ngu, Awando no sulenelootoni ombuwonomu, ene nguya nolo mande wesiyolo etelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ene ngundilo etoni ngu, asa, ene Yesusno sumoo ewonggori. Gengo Awangge ndano ooloote? Etoyi, Yesusndo mandeye gumi ngandilo ewolo. Ye nolo ma ingootenggo. Ngulo ngu, ye nolo Awane nguya ma ingootenggo. Ene ye nolo ingolo ngu, ye Awanembolo nguya ingowanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesusndo nga mandega nga ngu, Beye yeweloyi ya gumimo ewolo. Ene oni simoo bale Tempel ya newendemo oolootenggoku, ngu mande elo etuyelolo oluwolo. Ene oni gulado ene dowoolo, ya biyomimo ma yewonggori. Ngundilo ngulo, Yesuslo naluni ma tunootewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesusndo ko ewolo. No toongetenoku nga, ye no erewenelolo ma neyowanggo. Ye mbumbuwa telo oode ngu, asa, ye kumoowanggo. Ye nondo musiyongga ooloutenoku nguno, ye ma oolouwanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ngundilo etoni, Yuda tabango onindo enengo nangge mandelo ewonggori. Ndatelo ngulo, Yesusndo ete? Ye nondo musiyongga ooloutenoku, nguno ye ma oolouwanggo, ete. Enengombo enengo uleni kumoowelo bine ete? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ene ngundilo etoyi, Yesusndo gumi ewolo. Ye ngu ameno, no ngu awuno. Yo, hamoo, ye ngu mela ngalomu, ene no ngu mela ngalomu kini. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ngundilo ngulo, no yeno kuli ewonoku ngu. Ye kumootoyi ngu, yengo mbumbuwa ngu yengomo oluwa. No tambu elaya yeno eteno. Ye no nga oningga ngando yeno etenoku, ngu nowoondoyemo hamoo ma telo ngu, ariya, ye kumootoyi ngu, yengo mbumbuwaye yengomo oluwalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ene ngundilo etoni, asa, Yuda onindo gumi ewonggori. Ge onendo? Ngundilo etoyi, Yesusndo gumi ewolo. Nondo, no nga oningga ngando no kuli yeno ewonoku ngu! ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","No mande oowooyingga, no komo yengomo yengo damoniyemo ewono. Nondo yengo damoniye ngu, mande wilikoyingo oni ngundilo mandeye wilikowano. Ene oni no sulenelootoni ombuwonomu, ngu enengo damoni ngu hamoo oolengo. Mande bidodo no eneno ingowonomu, ngu nangge, no mela ngalo oni simoo baleno elo etuyelootenolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Yesusndo eweyimbolo mande ewoku ngu, Yuda onindo ngu nenengo ma ingowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yesusndo ewolo. Kootusina, yendo Oni Nangoni dowoolo, boolowoowanggoku, ngu nalunggano nguno, ye nolo tunoo oolengo ingowanggo. Nondo nenengo ingonduduno ko oo gula ma teteno. Kini, no mande elo, wesiyolo etuyelootenoku nga ngu, Awando ene kuli no etuneloyingo, ngu nangge eteno. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Awando no sulenelootoni, no mela ngano kuli ombuwonomu ngu, ene Awa noya ooloote. Ene no ma noyokootoni, noso nangge ma oolooteno. Kini, suwoo suwoo no Awando oo nondo tewelo ingooteku, ngu nangge tetenoku, ngulo ene oni oni tetelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yesusndo ngundilo etoni, oni simoo bale ulungga oolengo, enengo mandeni ngu ingolo, nowoondoyemo hamoo tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesusndo Yuda oni ene kuli enengo nowoondoyemo hamoo tetenggoku, nguno ewolo. Ye nolo mandene nga gome ingolo yolo, dowoolo, keyolo ngu, ariya, ye ngu nolo sulena oni oolengo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ye ngu Anutlo hamoo mande ngu ingowanggo. Hamoo mande, ngundo ye hoolooweyelootoni, yengo endeyoyingo ngu gome sobowoolo, nguno ye kingo ko oni ma oluwanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Yuda onindo Yesuslo mande ngu ingolo, gumi ewonggori. Noole ngu Ebarahamlo soweni. Noole nalu gulano, oni gulalo kingo ko oni ma tewooto. Ndatelo ngulo, ge ngundilo ete, ge kingo ko oni ma oluwanggolo ete? ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Etoyi, Yesusndo mande gumi ewolo. Hamoo oolengo, no yeno eteno. Oni bidodo mbumbuwa tetenggoku, ngu ene mbumbuwalo yanggangoni, ngundo gosiyelolo wetumooyelootoni oolootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Hamoo, kingo ko oni ngu, ene ya sembuli ngulo nangoni ngundilo kini. Kini, enengo nangoni oolengo, ngundo nangge ene suwoo suwoo sugi sugi oluwa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ngulo ngu, Anut Nangoni, ngundo yengo mbumbuwa ngu andangeyunootoni ngu, asa, ngundo hoolooweyelootoni, ngunonggo yengo mbumbuwalo yanggangoni ngu andangelo yokootoyi, ngundo ye ko ma soboyelowelo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","No ingooteno. Ye Ebarahamlo soweni, ene nolo mandene nga ngu, ye nowoondoyemo nguno ma ooloote. Ngundilo ngulo, ye no nuleyi kumoowelo tetenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","No mande wesiyolo elo etuyelootenoku nga ngu, no kuli Awanembo oo etunelootoni, kenolo ingowonoku, ngu elo etuyelooteno. Ene yendo ngu yengo awayemonggo mande damoni yoyingo, ngu tetenggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ene ngundilo etoni, asa, Yuda onindo gumi ewonggori. Noolengo awanayi, ngu Ebaraham! Etoyi, Yesusndo gumi ewolo. Hamoo ye Ebaraham simoongo tetoni ngu, ye komo Ebarahamlo damoni ngu yoya keyoyi. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nondo kuli hamoo mande bidodo Anutlo manggowoomonggo ingowonomu ngu, yeno elo etuyelowonoku ngu. Ene yendo ataga no nuleyi kumoowelo tetenggo. Ebarahamndo ene damoni ngundilo ma tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ye ngu yengo awayembolo mande damoni nangge tetenggo. Yesusndo mande ngundilo etoni, asa, Yuda onindo gumi ewonggori. Namo galodo ene kuli bulibali endeyolo, nguno noole ma yomoowonggori. Hamoo oolengo, noole ngu awanayi gulanangge, ngu Anut! Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ene ngundilo etoyi, Yesusndo gumi ewolo. Ngu hamoo, Anut ngu yengo Awaye tetoningga ngu, asa, ye nolo nguya ingowanggo. Ndatelo ngulo, no Anutya oode, ngunonggo no nenengo ingondudunemonggo ma ombuwono. Kini, Anutndo no sulenelootoni, no ombuwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ndatelo ngulo, ye nolo mandene ngalo ma ingondudu telo, nowoondoyemo siliyootenggo? Ngulo damoni ngu ngandilo. Ye nolo mande nga ingowelo yokolo, ngulo ye nowoondoye ukingootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ye ngu, awaye Setan ngulo simoongo! Ye ngu awayengga ngundo yendo oo tewelo ingootenggoku, ngu nangge tewelo gome ingolo, koyi tetenggo. Kulimi ngu, ene oni yuleyi kumooweloyi, ngulo nangge oluwolo. Ene damoni hamoo nenengo ngu ma keyowolo. Ndatelo ngulo, damoni hamoo nenengo ngu eneno kini. Ene mande ebe ganagana eweloyi damoningga ngulo sembuli oolengo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ngu damoningga ngunonggo nangge, ye nondo hamoo mande nga elo etuyelootenoku, ye ngulo nowoondoyemo hamoo ma yolo siliyootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ye kewooloyemo nguno oni gulado nondo mbumbuwa tewonoku, ngu ingowoku ngu, ariya, wesiyoya etoningga noolengododo ngu wilikolo kenowato. Ene nondo mbumbuwa ma teyingo tetoni ngu, ndatelo ngulo, nondo hamoo mande elo etuyelootoowe, ye ngulo nowoondoyemo hamoo ma tetenggo? ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Hamoo, Anutlo simoongo ngu, ene Anutlo mandeni gome ingootenggo. Ene ye ngu Anutlo simoongo kini. Ngundilo ngulo, ye enengo mandeni ma ingootenggoku ngu! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yuda onindo Yesuslo mandeni ngu ingolo, sanggili telo gumi ewonggori. Noole hamoo oolengo, geno eteto. Ge ngu Sameriya ende ngulo oni gula. Ngulo ngu, geno oomboolo biyomi gula oolooteku ngu! Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ene ngundilo etoyi ngu, asa, Yesusndo mande gumi ngandilo ewolo. Nono ngano oo yuka biyomi gula ma ooloote. Kini, no nenengo Awanembolo oowooyi bingami elo okooteno. Ene yendo nolo oowoone ngu yombuliyootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","No nenengo bingamine elo ma okooteno. Ene oni gulado (Anut) nolo bingamine elo okoote. Ngu oningga ngundo nolo damonine wilikonelowa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Hamoo oolengo, no yeno eteno. Oni gula ene nolo mandene nga keyolo ngu, asa, ene ma kumoowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Yesusndo ngundilo etoni, asa, Yuda onindo gumi ewonggori. Noole ataga ingooteto. Geno oo yuka biyomi gula oolooteku ngu! Ebaraham ngu kuli kumooyingo, ko Anutlo ingondudu eyingo oni nguya kuli kumoomukoyingo, ene gedo ngandilo ete. Oni gula ene nolo mandene gome keyolo ngu, ene ma kumoowalo ete. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ndatelo ngulo? Gedo bine noolengo osinayi Ebaraham dagate? Ene kuli kumoowolo. Anutlo ingondudu eyingo oni nguya, ene kuli kumoomukowonggori. Gengombo ngu ge oone, elo ingoote? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesusndo mandeye ngu ingolo, gumi ewolo. Nondo nenengo oowoone bingami nangge okoowanoku ngu, asa, nolo oowoone bingamine ngu kingo oo ngundilo tewa. Ene Awanembo nolo oowoone bingamine elo okootekungga, ngu yendo noolengo Anut, elo etenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ene yendo ngulo ma ingootenggoku, ene nondo ngu, no ene ingooteno. Ene nondo ene ma ingootenolo ewanoku ngu, asa, no yendo etenggoku, ngundilo ebe ganagana oni tewano. Ene no enengo kuli ingootenoku, ngulo ngu, no enengo mandeni ngu gome keyooteno. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Yengo osiye Ebaraham ngu, ene no tunooteweloyi nalune nga kenowelo, ene oni oni oolengo telo, sobowoolo hahangelo oluwolo. Ebaraham ene kuli ingowoku hamoo oolengo no ombuwanolo, ene newendemonggo gome ingowololo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ene ngundilo etoni, asa, Yuda onindo mande gumi ewonggori. Gengo mooma onibi elaya kande elaga (50) kini, nguno ge Ebaraham kuli kenowonolo ete? Hamoo oolengo kini! Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ene ngundilo etoyi, asa, Yesusndo gumi ewolo. Hamoo oolengo, no yeno eteno. Kulimi oolengo, Ebaraham ma tunooteyingo naluno, no kuli oluwonolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Yesusndo mande ngundilo emukootoni ngu, Yuda onindo sanggili telo, digi yolo, ngundo Yesus ulewelo oolongoowonggori. Ene Yesusndo ngu oni ngu kewooloyemonggo ene kombitelo, tolige oololo, Tempel yasili pawa ngu yokolo, endesina oolewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesus ngu ene oololo, oni doongeyi kilingo gula kenowolo. Ngu oningga ngu nemimbo doongeyi kilingo ngundilo yomoowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Yesus enengo sulena onikundo sumoo inolo ewonggori. Oo etuyeloyingo oni, onendo mbumbuwa tetoni, ngulo nga oningga nga nemimbo ngandilo doongeyi kilingo yomoowolo? Nga oningga enengombo mbumbuwa tetoni, ngundi enengo eweyi nemimbo mbumbuwa tetoli, bine? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ene ngundilo sumoo etoyi, Yesusndo mande gumi ngandilo ewolo. Nga oningga ngando mbumbuwa ma tewo, ko enengo eweyi nemimbo nguya mbumbuwa ma tewoli. Kini, nga ooga nga ngu, ngano Anutlo koni damoni nguno tunoo oolengo teweloyim tunootewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Mela himi oodoningga, noole komo Anutndo no sulenelootoni ombuwonoku, ngulo enengo koni tewato. Ndatelo ngulo, suwoo tunooteweloyimbolo ngu, oni gulado ene ko teweloyi kini. ");
INSERT INTO rwo_karo_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","No mela ngano oolootenoku naluno ngu, simoo balelo oole etuyeloyingo, ngulo solu himilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ngundilo elo, Yesusndo melako muketelo, muke ngu tetoni, nogoluyi yetoni, ngu yolo, oni doongeyi kilingongga ngu doongeyimo yewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Yesusndo ngu oningga nguya ewolo. Ge oolouya, Silowam sono koongeyingo ngu gemulo ewolo. Silowam mandega ngulo damoni ngu ngandilo. Ene suleyootoyi oolouwolo. Asa, ngu oni doongeyi kilingongga ngu oololo, Silowam sonono sono gemulo ombutoni, doongeyi mete tetoni doongetelo oo kenowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ngu oningga doongeyi kilingongga ngu, enengo ende goboolo oni, ngundo ene kuli kenolo ingowonggori. Nga oningga nga, ene oni simoo baleno bobeye oolo kalongoyelo, yemboongeloluwolo ingowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Oni gidalegado ewonggori. Yo, nga oningga ngando nangge. Etoyi, gidalegado ewonggori. Kini, nga oningga ngandilo, ene ngu oningga ngu gula. Etoyi, ene ngu doongeyi kilingo oningga ngu enengombo ewolo. Ngu nondo nanggelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ene ngundilo etoni, simoo baledo oninggakuya ewonggori. Ndatelo telo, ge doongengge mete tewo? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ngu oni doongeyi kilingongga, ngundo mandeye ngu ingolo, gumi ewolo. Ngu oningga oowooyi Yesus elo etenggoku, ngundo no doongenengga nga, melako muketetoni, nogoluyi yetoni, ngundo no doongenemo nogolu yonggulumoolo sulenelolo ewolo. Ge oolouya, Silowam sono koongeyingomo sono gemulo ewolo. Etoni, ngulo no oololo, sono gemutoowe, doongene mete tetoni, no doongetewonolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ene ngundilo etoni ngu, onikundo ngu oni doongeyi kilingongga nguya ewonggori. Ngu oningga ngu ndano ooloote? Etoyi, ngu oningga ngundo gumi ewolo. No watayi kinilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ariya, ngu naluno, ene ngu oningga kuli doongeyi kilingongga ngu yolo, Parisi onino oolouwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ngu nalunggano nguno, Yesusndo mela yeni nogoluyi yetoni, ngundo oni doongeyi yeni, mete teyingo nalungga ngu Sabat nalu. ");
INSERT INTO rwo_karo_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ariya, Parisi onindo sumoo inolo ewonggori. Ge doongengge ndatelo telo, ko mete tewo? Ewolo. Etoyi, ngu oningga ngundo gumi ewolo. Ene mela nogoluyi yolo, doongenemo yetoni, no sonono oololo sonowootoowe, nguno doongene mete tetoni, no mete oo kenootenolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ngundilo etoni, Parisi oni gidalegado ewonggori. Anutndo ngu oningga ngu, ma suleyootoni ombuwolo. Ndatelo ngulo, ene Sabatlo mamana mande ngu ma keyowolo. Etoyi, Parisi oni gidalegado ewonggo. Ndatelo telogo, mbumbuwadodo onindo, ngundilo oo sungo gula onindo ma teweloyi, ngu tewa? Ngundilo elo, Parisi oni usowoolo, wata elaya tunootewoliyo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ariya, ngu naluno, Parisi onindo ko yowoolengolo oni doongeyi kilingongga nguno ewonggori. Ngu oningga doongengge yeni mete tewokungga nguya, ge ndatelo ete? Ewolo. Etoyi, enebana ewolo. Ngu oningga ngu, ene Anutlo ingondudu eyingo oni gulalo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ngu hamoo, kuli ngu oningga ngu, ene doongeyi kilingo oolengo, ene ataga ngu doongeyi mete tete. Ene Yuda onindo ngulo nowoondoyemo hamoo ma tewonggori. Ngulo ngu, oni doongeyi kilingongga, mete tewokungga, ngulo eweyi nemi negoyelowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ene oningga ngulo eweyi nemi sumoo yunolo ewonggori. Nga oningga nga yali nangoyali, bine? Nga doongeyi ngundilo kilingo biyomi, nemi gedo ngundilo yomoowoolo, bine? Ariya, ndatelo telo, ngulo ene ataga oo mete kenowa? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ngundilo sumoo etoyi ngu, eweyi nemimbo mande gumi ewoliyo. Noole ingootelo, nga ngu noolengo nangonali. Nemimbo yomootoni, ngunonggo doongeyi ngundilo kilingo yeyingomu, ngu noole ingootelo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ene ataga ngano doongeyi mete teteku nga, ndatelo ngundilo tewoku, ngu noole nguya watayi kini. Onendo doongeyi yeni mete tewoku, ngu nguya noole watayi kini. Ene kuli oni ulungga ngulo enengo sumoo inoya ingoyilo ewoliyo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Oningga ngulo eweyi nemi ngu, Yuda onilo tabango oni ngulo sosolelo, ngulo ene ngundilo ewoliyo. Yuda onindo mande gulanangge ngandilo elo gosiyowonggori. Oni gulado, Yesuslo Kristus elo ewaku ngu, asa, Yuda onilo tabango, onindo ngu oningga ngu, goobooyingo yanonggo owetoyi, oolelo toongewalo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ngu damoningga ngulo nangge, eweyi nemimbo ewoliyo. Ene kuli oni ulungga nga, ngulo ye komo enengo sumoo inoya, mande nenengo oolengo ingoyilo ewoliyo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ngu oni doongeyi kilingongga ngu tambu elayayigaku negongolo, nguno ewonggori. Ge komo Anutlo oowooyimonggo, ngunonggo ge mande nenengo oolengo, nooleno etooga ingowooto. Noole kuli ingooteto. Ngu oningga ngu gengo doongengge yomosiyowoku ngu, ene mbumbuwadodo oni! Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ene ngundilo etoyi, oni doongeyi kilingongga ngundo gumi ngandilo ewolo. Ene bine mbumbuwadodo, ngundi kini, no ngulo watayi kini. Ene nondo ngu oo gulanangge ingooteno. Kulimi, no doongene kilingo oluwonoku, ene ataga nga ngu no doongene mete tetelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ene mande ngundilo etoni, asa, Yuda onindo ngu doongeyi biyomi oningga nguya ko ewonggori. Enendo geno ndatelo tewo? Enendo ndatelo telo doongengge yeni mete tewo? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ene mandeye ngu ingolo, gumi ewolo. No yeno kuli ewono. Ene ye ngu ma ingowonggo. Ndawugalo ye ko ingowelo? Ye nguya enengo sulena oni tewelo, bine? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ene mandeni biyomi eyinolo gumi ewonggori. Gedo nangge enengo sulena oni teya ootoo! Ene noole ngu Moseslo sulena oni telo oolootetoku ngu! ");
INSERT INTO rwo_karo_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Noole kuli ingooteto. Anutndo Moses mande kuli inowolo. Ene ngu oningga ngu ndanonggo tunootewoku, ngu noole ma ingootetolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Tabango onindo mande ngundilo etoyi, oni doongeyi kilingongga ngundo gumi ewolo. Yengo mande etenggoku, ngu nenengo kini! Yendo ewonggo. Ngu oningga ngu ndanonggo mayewoku, noole watayi kini ewonggo. Ene ngu oningga, ngundo no doongene yeni mete tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Noole ingooteto. Anutndo mbumbuwadodo onilo manggoye ma ingowa. Ene oni gula ene Anutno yambo mande telo, ngulo ingonduduni manggowo keyootoni ngu, asa, Anutndo ngu oningga ngulo mandeni nguya ingowa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kulimimonggo ombulo, ataga nga, oni gula nemimbo doongeyi kilingo yomootoni, oni gulado kootusina doongeyi yomosiyoyingomu, ngulo mandeni ma ingooteto. ");
INSERT INTO rwo_karo_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Hamoo oolengo, Anutndo ngu oningga ngu ma suleyootoni, ombulo ngu, asa, ene ngandilo ko nga tewelo ngu, ene ereremo kini! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ene ngundilo etoni, asa, Yuda tabango onindo sanggili telo, mande gumi ewonggori. Gengo nanggebo, ge mbumbuwa damonimo yomoonggelootoni, ge mbumbuwalo oni oolengo telo ooloote! Ene ataga gedo noole mande yunolo damoni gome ngu etuyelowelo ete, bine? Yuda onindo ngundilo elo yokolo ngu, ene oni doongeyi kilingongga, doongeteyingo oningga ngu goobooyingo yanonggo owelo, ko eneya yambo mande ma tewelo elo, loogu teyinowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yuda onindo ngu oni doongeyi kilingongga owetoyi toongetoni, Yesusndo ngu ingolo, ene ngu oningga ngu erewelo kenololo ewolo. Ge Oni Nangoni, ngulo nowoondogemo hamoo tete bine, ngundi kini? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ene ngundilo etoni, ngu oningga ngu enebana gumi ewolo. Oni ulungga, Oni Nangoni ngu oone? Ge nono etooga, no ene kenolo, nowoondonemo hamoo tenilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesusndo mandeni ngu ingolo, gumi ewolo. Ge kuli kenowolo. Ngu nga oningga ataga geya mande mande etelikungga nga! Ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Yesusndo mande ngundilo etoni, ngu oningga ngundo gumi ewolo. Oo Bidodo Sembuli Sembunayi, no nowoondonemo hamoo tetelo, ene Yesus keyi damonimo penggootelo, eneno yambo mande tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesusndo ewo, No melako ngano ombuwonomu ngu, simoo balelo mbumbuwa yootunolo etuyelowelo ombuwono. Ngundilo ngulo, oni doongeye kilingo ngu ene doongetewanggo. Ene oni doongeye mete oo kenootenggoku, ngu doongeye kilingo yetoni oo ma kenowanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Parisi gidalega, Yesus tanggeyimo oluwonggoku, ngundo enengo mande ngu ingolo, sumoo inolo ewonggori. Noole nguya doongenayi kilingo bine? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ene ngundilo sumoo etoyi, asa, Yesusndo gumi ewolo. Ye doongeye kilingo telo ngu, ye mbumbuwaye kini. Ene yendo ngandilo etenggo. Noolengo doongenayi ngu metemi elo etenggokulo, ngulo yengo mbumbuwaye, nguya sugi oolootelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesusndo ngandilo ewolo. Hamoo oolengo, no yeno eteno. Oni ene Sipsip ngulo sisipawa newendesina yamakowoole ma uwaku ngu, ene sisipawa kalongolo, sisipawa newendemo uteku, ngu oningga ngu, ene Sipsip yakakayi yolo, yutolo yoyoweloyi oni. ");
INSERT INTO rwo_karo_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ene oni Sipsiplo sisipawa ngulo yamakowoole, newendemo uteku ngu, asa, ngu oningga ngu Sipsip ngulo Sembuli. ");
INSERT INTO rwo_karo_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Sisipawa ngulo sobosobo, ngundo ngu Sipsip sembuli yamako goosooyinoote. Ene yamako goosootoni, Sipsip ngundo sembuye manggowo ingootoyi, sembuyebo enengo Sipsip oowooye elo mudiyelootoni, keyolo, endesina ooletenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ene Sipsip bidodo yoyolo, ende oolemukolo yokolo, ariya, sembuyebo koletelo ooloutoni, Sipsip ngu, sembuye manggowo ingolo, ene keyolo kootu ooloutenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ene Sipsip ngu, oni gula manggowo sungo ingolo, ene ma keyootenggo. Kini, ene sosolelo sungo sungo sawanggo. Ngundilo ngulo, ene oni sungo gulalo manggowo ma ingootenggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesusndo ngu mande yamonggawo ngu etoni, ene onindo mandeningga ngulo damoni ma ingowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ngulo ngu, Yesusndo mande yootunolo, oni simoo baleno ko ewolo. No yeno hamoo oolengo eteno. Nondo nangge, Sipsiplo sisipawa ngulo yamako. ");
INSERT INTO rwo_karo_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Oni bidodo no koletenunolo ombutenggoku, ngu ene yakaka oni, ko yutolo enengo oo udayelolo yoweloyi oni. Ndatelo ngulo, Sipsip ngundo enengo manggoye ma ingowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","No nenengombo nangge no yamako. Oni gula ene nono ombulo sisipawa newendemo uwaku ngu, ene imakeyingo ootoolo, ene oni oni telo, ene sisipawa newendemo ulo, ko endeloko oolelo, oowali gome yolo nelo oluwa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ene yakaka oni ngundo Sipsip yomosiyelowelo ma ombute. Kini, ene Sipsip yakakayi yoyolo, yombulibaliyelolo yuleyi kumooweloyimbolo nangge ombutenggo. Ene nondo ombuwonomu ngu, no yoyolo, suwoo suwoo keda oluweloyi kedaga ngu yunoweloyimbolo ngulo ombuwono. Yo, hamoo, oni ene nolo newendemo hamoo tetoni ngu, asa, no eneya keda oluweloyi kedaga ngu inootoowe, eneno hangelo oolelo, ngunonggo sugi sugi hooloowelo oluwa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Yo, hamoo, no Sipsip ngulo sobosobo gome oolengo. Sipsip ngulo sobosobo gome ngu, ene enengo Sipsip ngu hoolooweyelolo, kumooweloyimbolo meyelo oluwa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Oni ene ulilo nangge ko telo oolooteku, ene Sipsip ngulo sembuye kini. Ngulo ngu, ene se goki oo biyomi ombutoni, ngu kenolo ngu, ene sosolelo toongewa. Ene ngundilo toongetoni, se goki oo biyomi, ngundo ombulo, Sipsip ngu yutolo, yoonelo, yombuliyelootoni, ngulo Sipsip sungo sungo sawanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ngundilo ngulo, ngu oningga ngu ene ulilo nangge ko teteku ngulo. Yo, hamoo, ene Sipsip ngulo ma ingondudu telo nowoondoyi yunowa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Nondo nangge no Sipsip sobosobo gome oolengo. No nenengo Sipsip ngulo ingootoowe, ko nolo Sipsip ngundo nguya, ene nolo ingootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ngu ngandilo, Awando nolo ingootoni, nondo ngu Awalo nguya no ingooteno. No nenengo Sipsip ngu hoolooweyelolo, nenengo kedaga, ngu yokolo, hoolooweyelolo kumoowano. ");
INSERT INTO rwo_karo_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nolo Sipsip gidalega, nga sisipawangga, ngano ma oolootenggoku, ngu nguya yoyolo, ombulo, nga sisipawano ngano yoyetoowe, ene nguya nolo manggone ingowanggo. Ngundilo telo, Sipsip wata gulanangge, ko Sipsip ngulo sobosobo nguya gulanangge oluwa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Awando nolo gome nowoondoyi tenunolo, newende no nunoote. Ngundilo ngulo, no kumoolo nenengo kedaga ngu yokolo ngu, ene no kedaga, oluweloyi ngu ko yowano. ");
INSERT INTO rwo_karo_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Oni gulado, nolo kedaga oluweloyiga, ngu ma andangewanggo. Kini, no nenengombo ngu kedaga ngu yokowano. No kumooweloyimbolo yanggangonedodo, ko no keda ootookooweloyi, ngulo nguya yanggangonedodo. Ngu mamana mandega ngu, no Awanemonggo yowonowolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yesusndo mande ngundilo etoni, ingolo, Yuda oni simoo bale kewoolo usowoolo wata elaya tunootewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Oni oowooyingga ewonggori. Oo yuka biyomi eneno oodoni, ngundo yeni kapeteteku eke. Ndatelo ngulo, ye enengo mandeni ingolo keyootenggo? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ene ngundilo etoyi, gidalegado ewonggori. Nga ngu oni mboolomboyoyingo, ngulo mandeni ngundilo kini. Oo yuka biyomidodo, ngundo ene mete oni doongeyi kilingomu ngu yeni, doongeyi mete telo, ko doongetewa, bine? Hamoo oolengo kini! Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Yerusalem ende ulungga nguno nalu kundingiyi tunootewolo. Ngu ngandilo. Anutlo goobooyingo ya oowooyi Tempel ngu yelo goosooyingo, ngulo ingondudu teweloyi naluwo tunootewolo. Ngu nalungga ngu, doogo dokiki gingo yewo naluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ngu naluno nguno, Yesus ene Tempel ya koneyo oowooyi Solomon, ngu newendekuli oolouwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ngundilo tetoni, Yuda oni ombulo, Yesus pawangolo, sumoo inolo ewonggori. Nalu ndatelo, ge noole nowoondonayi yeyi bulibali teloluwato? Ge Kristus tetoningga ngu, asa, ge komo nooleno nenengo oolengo tunoolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesusndo mandeye ngu ingolo, gumi ewolo. No yeno kuli ewonoku ngu, ene ye ngulo nowoondoyemo hamoo ma tewonggori. Nondo oo sungo gula onindo ma teweloyim, ngu bidodo awane oowooyimo tewono. Ngundo nolo damonine yootunoote. ");
INSERT INTO rwo_karo_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ye nondo oo sungo gula tetenoku, ngulo nowoondoyemo hamoo ma tetenggoku ngu, ndatelo ngulo, ye nolo Sipsip kini. ");
INSERT INTO rwo_karo_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nolo Sipsip bidodo ngu, ene nolo manggone ingootoyi, nondo nguya enengo ingootoowe, ene no kenelolo endeyootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ngulo ngu, nondo suwoo suwoo sugi sugi keda oluweloyi ngu yunootoowe, ene ma oonatewanggo. Ngu oni ngu, oni gulado no kandenemonggo, hamoo oolengo ma andangelo yoyowa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Nolo Awanembo ngu oni ngu, ene kuli no nunowoku ngu. Awane ngu, ene oo bidodobolo koleteyingo awuno oolengo. Oni gulado Awa kandeyimonggo ene andangeyelolo yoyoweloyi nguya kini. ");
INSERT INTO rwo_karo_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","No nenengo Awane nguya noole gulananggelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ngundilo etoni ngu, asa, Yuda onindo sanggili ulungga telo, ngulo ene digi yolo, ngundo Yesus uleyi kumoowelo tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ngundilo tetoyi, Yesusndo eneno ewolo. Nondo Awalo oo sungo gula onindo ma teweloyi, ngu oowooyingga telo etuyelowono. Nondo ngundilo etuyelootoowe, ngunonggo nondo ndawu ko metemingga tetoowe, kenolo, yendo ko ngulo ndatelo ingondudu telo, ngulo ye digi yolo, no bungomo oolongoolo nuleyi kumoowelo tetenggo? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Yesusndo mande ngundilo etoni, Yuda onindo eneno gumi ewonggori. Noole gengo ko gome gulalo ingolo, noole digi ge bungomo ma oolongooteto. Kini, gedo Anut kootuyisina yumooyinolo mande etoyi ngulo. Ge ngu oni oolengo nangge. Ene gedo ngandilo ete, gengombo no Anut, elo etelo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Onindo mande ngundilo etoyi ngu, asa, Yesusndo gumi elo ewolo. So uyi nakangoyingo, ngu yengo mamana mandeno nakangolo, Anutlo ewolo. Nondo kuli ewono. Ye ngu anut ngundilo, elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Noole kuli ingooteto. Anutlo mande bidodo bukno oolooteku, ngu hamoo mande nangge, ngu sugi sugi oluwa. Ngu bukno nguno, Anutndo oni mande yunolo, ngu oni nguya anut ngundilo elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ene awa enengombo no logonelowolo. Enendo no sulenelootoni, no melako ngano ombuwonowolo. Asa, nondo eteno, no Anut Nangoni, ngulo ndawugalo yendo etenggo, ge Anut kootuyisina yumooyinolo mande ete, elo etenggo? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ene no nenengo Awanembolo koni ma tetoowe ngu, ariya, ye mete nolo mandene ngalo nowoondoyemo hamoo ma tewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ene no enengo koni tetoowe ngu, ye nolo mandene ngulo nowoondoyemo hamoo ma teya ngu, asa, ye mete nondo oo sungo gula onindo ma teweloyim tetenoku, ngulo nowoondoyemo hamoo teni. Ngulo ngu, ye mete ingondudu metemi ngu, ngandiya ingoyi. Awando noya oodoni, nondo Awaya oolootelolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Yesusndo mande emukootoni ngu, asa, Yuda onindo sanggili ulungga telo, Yesus ko tewoongolo, dowoolo, ya biyomimo yewelo tetoyi, ene Yesus Yuda oni kandeye dagalo, tolige toongewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yesus toongelo, oololo, Yodan sono ko wongoolo, gidaleloko ulelelo, ene yade oololo, kuli Yondo oni sono (kindingiyimbo) sonowooyunoyingo endega, nguno tunootelo, nguno oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ngu naluno, oni simoo bale oowooyingga oolengo, ene Yesusno mayelo, mande enengombo ngandilo ewonggori. Hamoo oolengo, Yondo oo sungo gula onindo ma teweloyim gula ngu ma tewoku, ene Yondo nga oningga, ngalo mande ewoku, ngu hamoo nenengolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ngu mela gumisina nguno, oni simoo bale oowooyingga oolengo, ene Yesusno nowoondoyemo hamoo tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Oni gula oowooyi Lasaras ene sayi yowolo. Lasaras ngu Mariya, Mata, elaga ngulo gumooyali, enengo endeyali oowooyi Betani. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ngu Mariyangga ngundo ene kuli bo ulumi (Sanda) Ulungga Oo Bidodo Sembuli Yesus, ngu keyimo wendolo, enengo uyimbo yonggulumooyingongga ngu. Ngu enengo gumooni Lasaras ngu sayidodo tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ngundilo ngulo, kuwookuwooyi elayagakundo mande Yesusno suleyolo ewoli. Ulungga Oo Bidodo Sembuli, gengo oningga ngulo gome ingootekungga, ngu ene sayidodo telo oolootelo ewoli. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ene mande ngundilo soweyootoli ngu, asa, Yesusndo ngu mandega ngu ingolo ewolo. Ngu sayingga ngundo oni yeni ma kumoowa. Kini, ngu sayingga ngundo tetoni, oni simoo baleno Anutlo dulidalini tunootewa. Ngu oo nguno Anutlo Nangoni ene dulidalinidodo tunootelo, enengo oowooyi bingamidodo oluwalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesusndo Mariya, Mata, elabasa ko gumooyali Lasaras, ngulo gome ingoote. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ene mande etoyi, Yesus ingowolomu ngu, Lasaras sayi kumoolo oolootelo etoyi ingolo ngu, ene sa elaya nguya ngu endega oluwokungga, nguno oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ngu naluno nguno, Yesusndo enengo sulena onikuno ewonggori. Noole Yuda melasina ko oolouyigalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ene ngundilo etoni ngu, asa, sulena onikundo eneno ewonggori. Oo etuyeloyingo oni, kuyowo yange nga, Yuda onindo, digibo gulewelo tewonggoku, nguno ge ataga ko oolouwelo ete? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Etoyi, Yesusndo gumi ewolo. Sa gulanangge nangge ngu sa ooloote. Oni ene sano endeyolo ngu, ene digino ma yulewa. Ndatelo ngulo, ene melangga ngalo himimo mela kenolo endeyowa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ene oni suwoono endeyolo ngu, ene digi wongosogulumoolo welewa. Ndatelo ngulo, ene solu himi kini ngulo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesusndo ngundilo elo, kootusina ene mande gula soweyolo ewolo. Noolengo doboonayi Lasaras kuli wetolo kapengoye yewolo. Ene nondo oololo, yokutuwootoowe ootookoowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ngundilo telo, sulena onindo ewonggori. Oo Bidodo Sembuli Sembunayi, ene wetolo, kapengoyelo ngu, ene ko mete telo oluwalo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesusndo ngu Lasaras ngu kuli kumootoni, ngulo ngundilo ewolo. Ene sulena onindo ngu, Lasaras ngu hamoo wetolo kapengoyelo oodoni, ngulo etelo ingowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ngundilo tetoyi, Yesusndo yootunololo ewolo. Lasaras doboonayi ngu hamoo kumoowolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ene no yengo ingolo, nowoondoyemo yanggango yunowelo, ngulo no anduno eneya ma ootoolo, ngulo no oni oni teteno. Ariya, ataga noole mete ene tanggeyimo oolouyigalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Yesusndo mande emukolo ngu, Tomas oowooyi gula Didimas, ngundo sulena oni gidalegaya ewolo. Ariya, noole ootookootoyiga, oolouya, enendo Yesus uleyi kumootoni ngu, noole eneya goboolo kumoowootolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ariya, Yesus enengo sulena oniya yade oololo, Betani endemo tunootelo ingoyingo, Lasaras bingo ngu meleno nalu kuli namolaya oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani endega ngu Yerusalem ende ulungga ngu tanggeyimo. Ngulo logo ngu 3 (Kilomita), ngundilo nangge. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Yuda oni simoo bale oowooyingga oolengo Mariya, Mata, elagano gumooyali kumoowoku naluno nguno mayelo, enengo nowoondoyali yeyi imakeweloyimbolo oluwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ngu naluno nguno, Matando ingowolomu ngu, Yesus mayewolo. Ngulo, Mata ootookoolo, Mariya yokolo, ooleko oololo, Yesus kenowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Matando Yesus kenolo, eneno ewolo. Ulungga Oo Bidodo Sembuli, ge ngano oodoyi ngu, nolo gumoone ma kumoowa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ene no ingooteno. Ge oo gulalo Anutno yemboongewaku ngu, asa, ngu ooga ngu, ene ge gunowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ene ngundilo etoni ngu, Yesusndo Matano gumi ewolo. Gengo gumoonggega ngu ko ootookoowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ene ngundilo etoni, Matando eneno gumi ewolo. No ingooteno. Ene nalu sosowoomo ko ootookoowa. Ngu nalunggano nguno, oni simoo bale melenonggo ko ootookoowanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ene ngundilo etoni, Yesusndo gumi ewolo. Ko ootookooweloyi ngu nondo nangge, ko keda sugi sugi suwoo suwoo oluweloyi nguya, nondo nangge. Oni ene nolo ingootoni, newendemo hamoo telo, nguno ene kumoowaku ngu, asa, ene noya keda oluwalo. Yo, ene keda ko ootookoolo sugi sugi oluwa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Oni bidodo doongeye keda ootoolo, ngunonggo nolo nowoondoyemo hamoo telo oolootenggoku ngu, ene ma kumoowanggo. Kini, ene suwoo suwoo sugi sugi keda oluwanggo. Ge ngulo nowoondogemo hamoo tete bine, ngundi kini? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Etoni, Matando eneno ewolo. Yo, Ulungga Oo Bidodo Sembuli, no nowoondonemo hamoo ge Kristus, Anut Nangoni, ge nga oningga nga Anutndo mela ngano sulenggelootoni ombuwolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Matando ngundilo elo yokolo, ene ko oololo, Mariya yolo, sungo oololo ewolo. Oo etuyeloyingo oningga ngu ombulo, ge negogelootelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mariyando mandeni ngu ingolo, ene sodedonangge ootookoolo, Yesusno oolouwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ene Yesus endemo ma tunootewolo. Kini, Yesus ngu Mataya mande ewoliku, musiyongga, nguno nangge oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Yuda oni Mariyadodo yano ootoolo, ene ngunonggo Mariya newende yeyi imakeweloyimbolo oluwonggori. Ngundo Mariya kenootoyi, sodedonangge ootookoolo, endesina ooletoni, ngulo ene keyolo, ene nguya endesina oolewonggori. Ndatelo ngulo, Mariya ngu meleno sendowelo ooloutelo ingowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mariya ngu ene Yesus oluwoku mela musiyonggakuno oololo, kenolo ngu, ene Yesus keyi damonimo penggootelo ewolo. Ulungga Oo Bidodo Sembuli, ge ngano oodoyi ngu, nolo gumoone ma kumootonilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ene ngundilo etoni ngu, asa, Yesusndo Mariya ko Yuda oni Mariya keyolo oolouwonggoku nguya sendootoyi yeyowolo. Ngundilo yeyolo, Yesus newendemonggo, enengo nowoondoyi yunowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Yesusndo ngundilo telo ewolo. Ye enengo bingo yolo ndano melengoowonggo? Etoni enebana ewonggori. Ulungga Oo Bidodo Sembuli, ombuya kenolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesusndo sendowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ngundilo tetoni, Yuda onindo kenolo ewonggori. Kenoyi, ene ngu oningga ngulo gome ingootelo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Etoyi, ene oni gidalegado ewonggori. Nga oningga nga ngu, oni doongeye kilingo yomosiyootoni doongetetenggo. Ene Lasaras hooloowetoni ngu, ene bine ma kumoowolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ariya, Yesus ngu newende kowuli oolengo yetoni, oni mele tanggeyimo oolouwolo. Ngu oni melengga ngu, digi kowu ulungga newendemo oni meleyi yomosiyolo, oni nguno melengoolo, digi ulungga yolo, ngundo mele manggowo ukingowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesusndo ewolo. Ye digiga mele manggowo ukingoyingongga ngu andangeyi. Ngundilo etoni, oni kumooyingongga ngulo kuwooyi, Mata ngundo Yesusno gumi ewolo. Ulungga Oo Bidodo Sembuli, ene kumootoni, melengooyingo ngu noole nalu namolaya kuli yokowooto. Ngundilo ngulo, ndindingo ukayi biyomi melenonggo oolewa! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Matando ngundilo etoni ngu, asa, Yesusndo eneno gumi ewolo. No kuli geno ewonoku, ge nowoondogemo hamoo tetoni ngu, ge Anutlo dulidalini yanggangoni ngu kenowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ariya, ene Yesuslo mandeni ingolo, ngulo ene digigaku andangewonggori. Ngundilo andangetoyi, Yesusndo randolo doongetelo ewolo. Awa, ge nolo yemboongene ingowoku, ngulo no geno eseteteno. Ndatelo ngulo, ge nolo yemboonge ngu kuli ingowoku ngu! ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","No kuli ingooteno, ge suwoo suwoo nondo mande etenoku, ngu ingolo ooloote. Ene nondo, ataga nga oni simoo bale dikatenggoku, ngando ngu ingoya, ene nowoondoyemo hamoo tetoningga, gedo nangge kuli no sulenelootoyi, ombuyingo, ngulo elo, meno yanggango telo, yemboongewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yesusndo yemboongewo ngundilo elo yokolo ngu, ene meno ewolo. Lasaras, ge endesina oole! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ariya, Yesusndo mande ngundilo etoni ngu, oni kumooyingonggaku ootookoolo, endesina oolewolo. Keyi kandeyi, omukumundoongo ngu towikumbabo doobengolo mbimboongolo gosiyowonggori. Ene ngundilo oodoni, Yesusndo ewolo. Towikumba ngu wesiyoya yokootoyiga oolouni! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ariya, ngundilo tetoyi, Yuda oni oowooyingga ene kuli mayelo, Mariyadodo oluwonggoku, ngundo ngu oo Yesusndo teteku ngu kenolo, ene ngulo nowoondoyemo hamoo tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ene Yuda oni gidalega kewooloyemo ngundo Parisi onino oololo, Yesusndo oo tewoku, ngulo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ngundilo ngulo, Anutno woolo yeyingo onilo sobosobo oniku, ko Parisi oni, ngundo Yuda tabango oniya gooboongoolo ewonggori. Noole ndatelo tewato? Ngu oningga ngundo ene oo sungo gula onindo ma teweloyim, ngu oowooyingga tete. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ene noole doongenayimbo nangge kenowatoku ngu! Ngu oningga ngu yokootooye ngu, asa, ene ko ngundilo ulungga tewa. Ngundilo tetoni ngu, simoo bale oowooyingga enengo nowoondoyemo hamoo tewanggo. Ngundilo tetoyi, asa, Rom onindo ombulo, noolengo goobooyingo ya kundingiyi oowooyi Tempel, ko noolengo Yuda oni simoo bale kenayimo nguya yombuliyelowanggolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ene mande ngundilo etoyi, asa, oni gula ene kewooloyemo, ngu oowooyi Kayiyapas, ngu oningga ngu, ene ngu moomangga nguno, ene Anutno woolo yeweloyi ngulo sobosobo tabango oluwolo. Ngundo mandelo ewolo. Ye ingonduduye kini. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ye oo gula ma ingootenggoku, ngu mete oni gulananggebo oni simoo bale hoolooweyelolo kumoowa. Kini tetoni ngu, noolengo kenayimo Yuda oni simoo bale nga oonatewanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kayiyapasndo, enengo ingondudunonggo ma ewoku, enendo kootusina oo tunooteweloyi ngulo ewolo. Kini, Kayiyapas ngu moomangga, nguno ene Anutno woolo yeweloyi ngulo sobosobo sunggi yetoyi, Yesuslo mande ngulo ene koletelo ingondudu telo ewolo. Yesusndo Yuda oni simoo bale hoolooweyelolo kumoowa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ene Yuda oni nangge hoolooweyelowelo nangge ma kumoowa. Kini, ene kumooweloyingga ngu Anutlo simoongo mela bidodomo oolootenggoku, ngu goobooyelootoni, wata gulanangge tunootewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ariya, ene ngu sa nalungga nguno, oololo, ene Yesus uleweloyimbolo mande elo oole erewewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ngundilo ngulo, Yesus ene Yuda oni kewooloyemo tunoo ma endeyowolo. Kini, Yesus ngu, ene ngu endega ngu yokolo, oololo, oni kini kingo mela ngu tanggeyimo, Ipirim ende bodaga, nguno enengo sulena onidodo nguno oluwonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Yuda onilo sunggi Anutndo dagayeloyingo naluwo, Pasowa, ngu namoko tewolo. Pasowa ma tunooteyingomo, oni oowooyingga endeni endenimonggo, Yerusalem endemo mayelo, nguno enengo yoyeyi, Anut doongeyimo, mete teweloyim mayewonggori. Ndatelo ngulo, ene Moseslo mamana mandeni ngu nenengo keyolo oolootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Mayelo, ene Yesuslo doongetelo, erewelo ewonggori. Ye ndatelo ingolo etenggo? Yesus ene nalu kundingiyi ngalo mayewa, ngundi kini, bine? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Yuda onindo Yesus erewewo ngu damoni ngandilo. Anutno woolo yeyingo onilo sobosobo oni, ko, Parisi oniya mande ngandilo kuli ewonggori. Onindo Yesus ndano oolooteku ngu ingoya ngu, asa, ene komo mayeya etoni, ingolo, nguno dowoolo, yolo, ya biyomimo yewatolo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Nalu kundingiyi ngu ma tunooteyingomo, nalu kandegula gidembolo gulanangge oodoni, Yesus nguno ene Betani endemo oolouwolo. Betani endega ngu, Lasaraslo ende. Ngu Lasaras oningga ngu, kuli Yesusndo melenonggo ko yokutuwootoni, ootookoowokungga ngu. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ene Yesuslo oo simbo gula ngu endemo nguno kawonggori. Mata ngu ene oowali moondootoni, Lasarasndo ngu oniya nguya bibitelo, Yesusndo oowali newolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ene oowali netoyi, Mariyando kumu bo ulumi gula oowooyi Nard, ngu ndindingo gome, (Kilo) gumi nangge yolo, ngundo Yesus keyi sonowoowolo. Ngundilo sonowoolo, enengo tabango uyimbo yonggulumoowolo. Ngu kumu bo ulumngga ngulo ulini ngu ulungga oolengo. Yo, ndindingo ngu gome, ngunonggo ndindingo gomengga ngu yangga ngu nangge tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ene sulena oni gula, ngu oowooyi Yudas Iskariyoot, ngu oningga, ngundo kootusina Yesus yootunolo, me oni kandeyemo yelo yunowaku, ngundo boguwoolo ngandilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Ndawugalo ngulo, noole nga kumu bo ulumngga nga oni yunolo, ngulo ulini ngu, mooma gulanangge ko telo, bobeye yolo, owoolongo oni ma yunoyingo? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ene Yudasndo owoolongo onilo ingondudu telo ma ewolo. Kini, ene ngu yakaka oni, ene ngu bobeye sobowoolo, ngunonggo ene beye onindo yetoyi, enendo yakakayi gidalega yololuwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ngundilo etoni, Yesusndo gumi ewolo. Nguno yokoyi! Ye nga balega ngando teteku, ngulo ma ewelo. Ndatelo ngulo, no kumootoowe, meleno meleneloweloyi nalungga, ngu yootunoote. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Yo, hamoo, owoolongo oni ngu, ene yeya suwoo suwoo oluwanggo. Ene nondo ngu yeya suwoo suwoo ma oluwatolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Yuda oni simoo bale oowooyingga ene Yesus Betanino oolooteku ngu ingolo, ngulo ene nguno ombuwonggori. Ene Yesus kenowelo nangge kini. Yesusndo ene kuli Lasaras melenonggo yokutuwootoni ootookooyingo, ngulo ene Lasaras nguya kenowelo ombuwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ngundilo ngulo, Anutno woolo yeyingo oni ngulo sobosoboku, ngundo Lasaras nguya uleyi kumooweloyimbolo mandelo gosiyowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Ndatelo ngulo, Yuda oni oowooyingga, ene Lasaras kenolo ingolo, ngulo ene Yesusno nowoondoyemo hamoo tetoyi, enengo tabango oni yoyokowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Sengetoni, oni simoo bale ulungga oolengo ene nalu kundingiyi ngu kenowelo mayelo oolootenggo. Ngu nalungga nguno, ngu simoo bale ngundo Yesus ene Yerusalemno ombuteku ngu ingowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ngundilo ngulo, ene toonggoo uyi toongoolo yolo, ilosarayi dowoolo, umamingolo, Yesus oowooyi bingami okoolo oololo, ooleko Yesus kenolo, meno mogulu ulungga telo ewonggori. Hosana! Gengo oowoongge awuno oolengo! Nga oningga nga ngu, ene Oo Bidodo Sembuli Sembunayi, ngu oowooyimo ombuteku nga! Ene Iserel onilo oo bidodo sobowooyingo oni ulungga! Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesus ngu Hos gula oowooyi donki nangoni gula kenolo, yolo, nguno bibitewolo. Ngu Anutlo mandeno ngandilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Ye Sayon (Yerusalem) endemo oni simoo bale, ye ma sosolewelo! Kenoyi! Yengo oo bidodo sobosobo oni ombuteku ngu! Ene donki nangoningga sanganimo bibitelo ombute! Elo ewolo. (Sekarayiya 9:9) ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Yesus enengo sulena oni ngu, ene ngu mandega ngulo damoni ma ingowonggori. Ene, Yesus ko ootookoowongga, ngu dulidalinidodo tunootetoni, ene nguno nowoondoyemo ingondudu tewonggori. Ngu naluno nguno, sulena onindo Anutlo mandeno ewoku, tunoo oolengo ingolo, ngunonggo onindo Yesusno teyingomu ngulo ingondudu tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Kuli Lasaras kumootoni melengootoyi, nguno oodoni, oni simoo bale ulungga oolengo Yesusndo oode, ngunonggo Lasaras negongootoni, ko ootookootoni kenowonggori. Ngu oni simoo bale ulungga, ngundo ene ngu ko mande oo Yesusndo tewoku, ngulo mande mandeni elo yootunowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ene ngundilo mande mandeni yootunootoyi, oni simoo bale oowooyingga ene Yesusndo kuli oo sungo gula onindo ma teweloyim tewoku, ngu kenolo ingolo, ngulo ene oololo, ooleko Yesus kenowelo oolouwonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ngundilo tetoyi, Parisi onindo enengo nangge mande elo ingolo ewonggori. Nga kenoyi! Oni simoo bale ene oololo, Yesus keyolo endeyootenggoku nga! Noolendo oo tetetoku ngu, kingo oo ngundilo tunootete! Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Oni simoo bale ene Yerusalem endemo oolelo, nalu kundingiyimo nguno Anutno yambo mande tewelo ooletoyi, Girik oni gidalega nguya yambo mande tewelo, ngulo ene Yerusalemno oolewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ngu Girik oni ngu, ene Pilipno ombulo ewonggori. Ulungga, noole Yesus kenowelolo ewonggori. Pilip oningga ngu, ene Betsayida ende Galili mela ngunonggo ombuwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ariya, Pilipndo enengo mandeye ngu ingolo oololo, Enduruno elo enengo ela ela oololo, Yesusno Girik onilo mande ewoli. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ene ngundilo etoli ngu, asa, Yesusndo mandeyali gumi ewolo. Anut Nangoni Oni Kilalongo ngulo nalu ombutoni, ene dulidalinidodo ngu yoweloyi nalungga ngu kuli tunootete. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Hamoo oolengo, no yeno eteno. Nggile yuwooyi melako ulo ma kindangelo ooletoni ngu, asa, enesu nangge oluwa. Ene oo yuwooyi kindangelo oolelo ngu, oo engge oowooyingga tunootewa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Oni enengo goweyi ngulo nangge ingolo sobowoolo oluwaku ngu, ngu oningga ngulo keda oluweloyiga ngu oonatewa. Ene oni enengo kedaga ngu mela ngano kootu inolo, ene dobooguliyi nowoondoyi yunolo, Anutlo koni ngu telo hoolooweyelolo ngu, asa, ene suwoo suwoo keda sugi sugi oluwa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ene oni gula nolo kone nga dowoowelo telo ngu, ene komo no keneloni. Ene ngundilo kenelolo ko tetoyi ngu, asa, nondo endega oolootenoku, nguno nolo ko oni nguya noya goboolo oluwalo. Yo, ene ngundilo telo no hooloowenelolo ko telo oodoole ngu, nolo Awanembo ene oowooyi bingamidodo inowa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ataga, nolo nowoondone kowuli oolengo yetoni, ngulo no ingondudu oowooyingga teteno. Ngulo no ndatelo ewano? Nondo bine ewano, Awa ge nono oo ataga tunooteweloyiga nga andangenuno, ewano? Kini, no ngundilo ma ewano. No ngu kowulingga ngu koolowoowelo, ngulo nangge no melako ngano ombuwono. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Awa, gengo oowoongge yega ulungga tunooteni! Yesusndo ngundilo etoni, Anutndo Sambononggo ngandilo meno ewolo. Nondo nenengo oowoone kuli yewe ulungga tunootewoku, ko kootusina nguya no oowoone yewe ulungga oolengo tunootewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ene ngundilo etoni, asa, oni simoo bale oowooyingga oolengo ene tanggeyimo dikayingo, ngundo ngu ingolo ewonggori. Gululu gusiloga ngguyi utelo ewonggori. Oni gidalegado ewonggori. Sambono Engel oninggado eneno mande etelo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ene ngundilo etoyi, Yesusndo mande gumi ewolo. Kini, nolo Awanembo mandega eteku nga ngu, no hooloowenelowelo ma ete. Kini, ye hoolooweyeloweloyimbolo ngulo ete. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ataga nga nalunggano ngu, Anutndo mela ngalo oni simoo bale wilikoyelolo ete. Yengo damoniye ngu biyomi nanggelo ete. Ataga ngu mela ngalo damoni biyomi ngulo sobosobo tabangongga, ngu Anutndo andangelo owewa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","No ataga melako ngano oolooteno. Ene kootusina, onindo nowokoolo awuno noyetenggoku, nalungga nguno, oni simoo bale bidodo yoyewe, nono ombuwanggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesusndo ngundilo ewokungga ngu, enengo kumooweloyi, ngulo damoni tunoo yootunolo ngundilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ngundilo etoni, oni simoo bale ulungga, ngundo Yesuslo mande gumi eneno ewonggori. Noole mamana mandeno, mande eteku, ngu ngandilo ingooteto. Kristus, ene Anutndo simoo bale ko yoyowelo sunggi yeyingo oningga ngu, ene ngano ombulo, sugi sugi oluwa. Ndatelo ngulo, gedo ete, oni ene komo Oni Nangoni, ngu okoolo boolowoowanggo? Etoni, ngu Oni Nangoni oningga, ngu oone? Elo ewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ene ngundilo sumoo inootoyi, Yesusndo ngandilo ewolo. Nalu bodaga nangge nolo solu himi ngu yeya oluwa. Ataga ngu ye solu himidodo oolootenggo. Ngulo ngu, ye komo solu himimo endeyoyi. Kini tetoni ngu, suwoo ooleli biyomi, ngundo ombulo ye wiliyelowa. Oni ene ooleliko endeyooteku ngu, ene oole oolouteku, ngu kenolo, ma ingootenggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ataga, ye nolo solu himidodo oolootenggo. Ngulo ngu, ye komo, nondo solu himi yolo ombuyingo, ngulo nowoondoyemo hamoo teyi! Ye ngundilo telo ngu, asa, ye nolo simoone ngulo solu himimo nguno endeyowanggo. Yesusndo ngu mandega ngu elo yokolo, ene musiyo sungosina oni nguno kini nguno oololo kengewololo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Oni ene Yesus kenootoyi, oo sungo gula onindo ma teweloyim, ngu ulungga tetoni kenolo, ngulo ene nowoondoyemo hamoo ma tewonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ngundilo ngulo, Anutlo ingonduduni eyingo oni, Ayisayalo mandeni, ngulo engge tunootete. Ayisayando kulimi ngandilo ewolo. Ulungga Oo Bidodo Sembuli Sembunayi, onendo ngu noolengo mandenayi ngalo newendemo hamoo tewa? Ulungga Oo Bidodo Sembuli Sembunayi, ngundo enengo yanggangoni ngu oone etungowo? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ene Yesusno nowoondoyemo hamoo ma tewonggori. Ngulo damoni ngu, Ayisayando so uyi nakangoyingo gulano ngandilo nakangowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Anutndo enengo doongeye ngu, kuli ukingoyingo, enendo tetoni nowoondoye yeni digi ngundilo gagiwi oolengo yewolo. Ngundilo ngulo, ene doongeyembo oo kenolo, nowoondoyemo hamoo ingoweloyi nguya kini. Nguno ngu, ene nowoondoye ma yowoolengootoyi, nondo ma yomosiyelowanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Anutndo Yesuslo dulidalini tunootelo teweloyi, ngu Ayisaya etungootoni, kenolo, ngulo ene Yesuslo mandeni ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Hamoo, oni tabango ulungga nguya Yesuslo nowoondoyemo hamoo tewonggori. Ene Parisi onilo sosolelo, ngulo enengo nowoondoyemo hamoo ngu, ene yootunolo ma ewonggori. Ene tunoo etoyi ngu, asa, Parisi onindo yambo yanonggo oweyelolo, yambo mande teweloyi ngulo loogu teyunolo, elo ingolo, ngulo ngundilo tewonggorilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ene tabango onindo enengo ingonduduye ulungga ngu simoo baledo enengo oowooye eya okooyi elo, gome ingootenggo. Yo, hamoo, ngundilo ingoyingongga, ngundo Anutndo oowooyi okooweloyiga, ngu dagate. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesusndo manggalu telo ewolo. Oni ene nolo newendemo hamoo teteku ngu, ene nolo Awane no sulenelootoni ombuwonoku, ngulo nguya newendemo hamoo tete. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Oni ene no neyolo ngu, ene nolo Awane no sulenelootoni, no ngano ombuwonoku ngu nguya kenowa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","No ngu mela ngano ombuwonoku, ngu solu himi ngundilo ombuwono. Ngulo ngu, oni bidodo ene nolo nowoondoyemo hamoo tewanggoku ngu, ene ooleliko ma oluwanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ene oni gula nolo mandene ingolo, ene ngu ma keyolo ngu, asa, no nguya ene ma wilikowano. Kini, no mela ngalo oni simoo bale wilikoyelowelo ma ombuwono. Kini, nondo ngu enengo mbumbuwanonggo andangeyelolo yoyoweloyimbolo ombuwono. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Oni ene no kootu nunolo noyokolo, ene nondo mande ewonoku, ngu ma ingolo, yolo dowoolo ngu, asa, nalu sosowoomo, nondo mandega ewonoku, ngundo ene wilikowa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nondo nenengo ingondudunonggo mande nga ma eteno. Kini, Awane enengombo no sulenelootoni ombuwonoku, ngundo oo bidodo nunootoni mete temukowanoku, ngu no ngu nangge yootunolo eteno. ");
INSERT INTO rwo_karo_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","No ngu ingooteno. Awalo mamana mandeni ngundo suwoo suwoo sugi sugi keda oluweloyiga, ngu oni Awalo nowoondoyemo hamoo tetenggoku, nguno yeni tunootete. Ngundilo ngulo, nondo mande bidodo etenoku nga ngu, Awando kuli etoni, ingowonoku, ngu nangge etenolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Nalu kundingiyi oowooyi Pasowa, ngulo naluwo namoko tetoni, nguno Yesus ene ngandilo ingowolo. Ene komo nga melangga nga yokolo, ene eweyi tanggeyimo, ko ooleweloyi naluwo ngu tunootewolo. Enengo oni simoo bale mela ngano oolootenggoku, ngulo nowoondoyi yunowolo. Ene bidodo nowoondoyi yunolo oode oololo, ene kumooyingo naluno wenga. ");
INSERT INTO rwo_karo_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Suwootetoni ene oowali nelo oodoyi, Setando ingondudu biyomimu, kuli Yudas Iskariyoot, Sayimon oningga ngulo nangoni, nguno yewolo. Yo, hamoo, Setando Yudas eriringootoni, ngu Yesus yolo, me oni kandeyemo yeweloyimbolo oole yomosiyowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesusndo ngu ene kuli ingowolo. Eweyimbo oo bidodo ene kandeyimo yelo inowolo. Eweyimbo ene suleyootoni, ombuyingomu, ngu Eweyi tanggeyimo ko oolewa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ngundilo ingolo, Yesus ene oowali nelo yokolo, ootookoolo, enengo towi pelungga nengguloyi ngu andangelo yelo, ene sono gemuweloyi towingga yolo, wanggangomo gosiyowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Yesusndo ngundilo telo, ene sono yolo, koondo gulano wendolo, sono ngundo enengo sulena oni keye damonimo yelo sonoyelowolo. Ngundilo sonoyelolo, enengo wanggangomo sono gemuweloyi towingga, ngundo yonggulumooyunowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Yesusndo ngundilo telo, yade Sayimon Pitano ombutoni, Pitando Yesus sumoo inolo ewolo. Ulungga Oo Bidodo Sembuli Sembunayi, ge no kene nguya sonowoowelo, bine? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ene ngundilo sumoo etoni, Yesusndo mandeni gumi ewolo. Nondo ataga oo tetenoku nga, ge ngulo damoni ge ma ingoote. Ene kootusina ngu ge ngalo damoni ingowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ngundilo etoni, Pitando mande gumi ewolo. Ge nolo kene hamoo oolengo ma sonowoowelo. Etoni, Yesusndo gumi ewolo. Nondo ge ma sononggelowanoku ngu, ge noya goboolo ma oluwalolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Etoni, Sayimon Pitando eneno gumi ewolo. Ulungga Oo Bidodo Sembuli Sembunayi, ge kene nangge ma sonowoowelo. Kini, ge komo kene, kandene, tabane nguya sonowoomukolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Etoni, Yesusndo gumi ewolo. Oni ene goweyi bidodo sono gemuwoku ngu, ene sugabo kini. Ene mete keyi nangge sonowoowaku ngu, asa, ene goweye moondeye bidodo namboyi. Yo, ye bidodo mete oolootenggo. Ene, ye kewooloyemo, ngano oni gulanangge ene mete kinilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesus ene kuli ingoote. Ngu oningga ngundo ene yootunolo, me oni kandeyemo yewa. Ngundilo ngulo, ene ngandilo ewoku, ye kewooloyemo oni gula ngu mete kinilo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ariya, Yesusndo keye sonowoolo yokolo, enengo nenggulogaku yolo telo, bibitelo, enengo sulena oniku sumoo yunolo ewolo. Ye bine nga kongga yeno tetenoku ngalo damoni ingootenggo? ");
INSERT INTO rwo_karo_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Yendo noya ngandilo etenggo. Oo etuyeloyingo oni, ko, Oo Bidodo Sembuli Sembunayilo etenggo. Ngu yendo hamoo etenggoku, no ngu nangge. ");
INSERT INTO rwo_karo_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ngu hamoo, no ngu yengo Ulungga Oo Bidodo Sembuli, ko, no yengo Oo Etuyeloyingo oni nguya, nondo yengo keye sonowootenoku ngu, ariya, yendo nguya dobooguliye keye sonowooyi. ");
INSERT INTO rwo_karo_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nondo ataga ye etuyelootenoku damoningga ngu, kingo gaboyi nangge etuyelooteno. Yendo nguya ngu damoningga ngu teyaliyi. ");
INSERT INTO rwo_karo_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Hamoo oolengo, no yeno eteno. Ko oni ngu, enengo sobosobo oningga ngu dagalo awuno ma oluwa. Ngundilo nangge, oni gula ko gulano oololo ngu, enengo oningga suleyootoni kono oolouteku, ngu dagalo awuno ma oluwa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ene ye nga oo nga ingolo, ye nguya ngundilo telo ngu, asa, ye mete oni oni tewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Nondo ye bidodo ma eteno. Nondo oni nenengo sunggi yewonoku, ngulo ingooteno. Ene ngu ooga, ngu Anutlo mande, ngu engge tunootete. Anutlo mandeno ngandilo ete. Oni ene noya oomanongoyingo goboolo nelo, ene no nowoondowelo keyi okoowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ngu ma tunooteyingomo, no yeno eteno. Ngulo ngu kootusina ngu tunootetoni, asa, ye nowoondoyemo hamoo teweloyi ngu no nga oningga nga. ");
INSERT INTO rwo_karo_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nondo hamoo oolengo yeno eteno. Oni nondo ko oni suleyootoowe, oolouteku ngu yolo, gome telo, yomosiyolo ngu, asa, ngu oningga ngu, ene no nguya noyolo yomosinelowa. Yo, ngu oningga ngu no noyolo ngu, ene nolo Awane no sulenelootoni, ombuwonomungga, ngu nguya yowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesusndo ngundilo elo yokolo, ene newende kowuli oolengo yetoni, ngulo ene yootunolo ewolo. Hamoo oolengo, no yeno eteno. Ye kewooloyemo nganonggo gulado no yootunonelolo, mundi oni kandeyemo noyewalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Yesusndo ngundilo etoni, sulena oni enengo nangge ebe keno keno telo, ngu ooneya etelo ingowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ene ngundilo tetoyi, sulena oni gula, Yesusndo ngulo gome oolengo ingooteku, ngundo Yesus tanggeyimo oluwolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ngundilo oodoni, Sayimon Pitando tabangombo telo, eneno ewolo. Gedo sumoo ino ene ooneya etelo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ariya, ngu oni Yesus tanggeyi oolengomo bibitewonggokungga, ngundo Yesus tanggeyi oolengomo oololo, sumoo inolo ewolo. Oo Bidodo Sembuli, ge ooneya ete? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ene ngundilo sumoo etoni, Yesusndo mandeni gumi ewolo. Nondo oomanongoyingo gumi gula oo sonoyimo yelo yolo, oni gula inootoowega ngu, ngu oningga ngu! Ngundilo elo, ene oomanongoyingo gumi gula yolo, oo sonoyimo yelo, yolo, Yudas Iskariyoot, Sayimonlo nangoni, ngu inowolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yudas oowali ngu yolo netoni, ngu naluno, Setando newendemo utoni, Yesusndo Yudasya ewolo. Ge oo tewelo ingooteku, ngu ge komo sodedo ngundiya te! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Yesusndo mande ngundilo Yudasya etoni, oni oo neweloyi yabano bibitewonggoku, ngundo mande ingolo, ene ngulo damoni ma ingowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yudasndo ngu, Yesus galo ngu bidodobolo bobeye ngulo si, ngu enendo sobowoote. Yesuslo sulena oni gidalegado ngu, Yesusndo mande ngu etoni, ene ingowonggori. Nalu kundingiyi ngulo oo gula uliyoni, ngundi, oo gula owoolongo oni yunoni, elo eteku, ngu elo ingowonggori. ");
INSERT INTO rwo_karo_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ariya, Yudas oomanongoyingo gumingga ngu yolo, ene ende oolelo toongewolo. Ngundilo toongetoni, ngu nalungga ngu, suwoo ooleli tewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yudas endesina oolelo toongetoni, ngu naluno, Yesusndo ewolo. Ataga Oni Nangoni, ene bingaminidodo tetoni, ngunonggo Anut nguya enengo nangonimonggo bingaminidodo tete. ");
INSERT INTO rwo_karo_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ene Anutndo enengo nangonimonggo bingamidodo yolo ngu, asa, Anutndo bingamidodoga ngu yolo, enengo Oni Nangoni nguya ko inootoni, enengo ela ela sodedonangge bingamiyalidodo tunootewali. ");
INSERT INTO rwo_karo_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ye simoone, nalu bodaga nangge, no yeya oode, kootusina, ye no erewenelowanggo. No kuli Yuda onino ewonomu, ngundilo nangge, ataga yeno nguya eteno. Ye nondo endega ooloutenoku, nguno ye ma oolouwanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ene ataga nondo mamana mande keda gula ye yunooteno. Ye komo dobooguliye nowoondoyi teyunoyi! Yo, nondo yengo nowoondoyi yunootenoku, ngundilo nangge, ye komo dobooguliye nguya nowoondoyi yunoyi! ");
INSERT INTO rwo_karo_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ye dobooguliye nowoondoyi tewanggoku ngu, asa, oni simoo bale bidodo ye yeyolo ingowanggo. Ye ngu nolo sulena oni oolengolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Sayimon Pitando Yesusno ewolo. Oo Bidodo Sembuli, ge ndawoole ute? Etoni, Yesusndo mandeni gumi ewolo. Nondo endega ooloutenoku, nguno ge no kenelolo oolouweloyi, ngu ereremo kini. Ene kootusina, ge no kenelolo nguno oolouwalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ene ngundilo etoni, Pitando gumi ewolo. Oo Bidodo Sembuli Ulungga, ndatelo ngulo, no ataga ge ma kenggelolo oolouwano? No nenengo kedaga, ngundo ge hooloowenggelowelo, ingootenolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ene ngundilo etoni, Yesusndo mandeni gumi ewolo. Gedo gengo kedaga ngu yokolo, no hooloowenelowelo ete? Hamoo oolengo, no geno eteno. Kootooli ma eyingomo, ge no oowoone tambu kabusa elo oongoonelowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesusndo enengo sulena onino mande gula ewolo. Yengo nowoondoye soliyokolo ma sosolewelo. Ye Anutlo nowoondoyemo hamoo tetoningga, ngunonggo ye komo nolo nguya nowoondoyemo hamoo teyi. ");
INSERT INTO rwo_karo_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nolo Awanembolo yangga ngu, ya gumi kowookowoo ooloote. Ngundilo kini ngu, asa, no kuli yeno ewano. No yeno hamoo eteno. No yengo musiyo yomosiyoyunowelo oolouteno. ");
INSERT INTO rwo_karo_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","No oololo, yengo musiyo yoonenengolo yokolo ngu, asa, no ko ombulo, ye yoyolo oolelo, noya goboolo oluwato. Yo, nondo musiyongga oolootenoku, nguno ye nguya noya goboolo oluwato. ");
INSERT INTO rwo_karo_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Yo, hamoo, nondo ngu endemo nguno oolouweloyi ooleyiga ngu, ye kuli ingootenggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ene ngundilo etoni, Tomasndo mande gumi ewolo. Ulungga Oo Bidodo Sembuli, ge ndaruwelo ete? Noole ma ingooteto. Ariya, ndatelo telogo, noole ngu oolega ngu kenolo ingowato? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Etoni, Yesusndo gumi ewolo. No, nondo nangge no oole. No nangge hamoo mande ngulo Sembuli. Nondo nangge, suwoo suwoo keda oluweloyi ngulo Sembuli. Oole gulanonggo Awa tanggeyimo oolouweloyi kini. Hamoo oolengo kini. Nononggo nangge Awa tanggeyimo oolouweloyi. ");
INSERT INTO rwo_karo_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ene ye kuli nolo ingootenggoku, ngulo ngu, ye nolo Awanembolo nguya ingootenggo. Ataga ye damoni yelo, ye ene ingolo kenootenggolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ene ngundilo etoni, Pilipndo eneno ewolo. Oo Bidodo Sembuli Sembunayi, ge Awangge etuyelo! Ge ngundilo etoyi ngu, asa, noole mete elo ingowatolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ene ngundilo etoni, Yesusndo gumi ewolo. Pilip, nalu pelungga no yeya goboolo oluwootoku, ge nolo ma ingoote? Oni ene no neyooteku ngu, ene Awane nguya kenoote. Ndatelo ngulo, ge Awangge noole etuyelo, elo ete? ");
INSERT INTO rwo_karo_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","No Awano oodoowe, ko, Awando ene nono oolooteloku, ngulo ge nowoondogemo hamoo ma tete, bine? Nondo mande yeno etenoku nga ngu, nondo nenengo ingondudunonggo ma eteno. Kini, Awa noya ootoolo, ngunonggo enengo ingondudunimonggo nangge enengo koni ngu tete. ");
INSERT INTO rwo_karo_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ye ngu komo nga mande ngalo nowoondoyemo hamoo teyi. No awano oodoowe, ko, Awa ene nono ooloote. Ye ngulo nowoondoyemo hamoo mete ma tetoni ngu, asa, ye komo nondo oo sungo gula onindo ma teweloyi tetenoku, nga bidodo ingondudu teya, ngulo ye komo nolo nowoondoyemo hamoo teyi. ");
INSERT INTO rwo_karo_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Hamoo oolengo, no yeno eteno. Oni ene nolo newendemo hamoo tetoni ngu, nondo ko oo tetenoku nga, ene nguya ngu ko oo ngu mete tewa. Ene ko ulungga oolengo telo, ene nondo kongga tewonoku, ngundo no daganelowa. Ndatelo ngulo, no Awa tanggeyimo oolouteno. ");
INSERT INTO rwo_karo_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Yendo oo bidodo no oowoonemo yemboongewanggoku ngu, no ngu ooga ngu tewano. Ngundilo ngulo, Awa ngu enengo nangonimo ene bingami dulidalinidodo tewa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Yo, hamoo, ye no oowoonemo oo gulalo yemboongelo teni ewanggoku ngu, asa, no ngu ooga ngu komo hamoo tewanolo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Yesusndo ngandilo ewolo. Ene ye nowoondoye no nunolo ngu, ariya, ye nolo mamana mandene ngu gome keyowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nondo Awano yemboongetoowe, enendo ngu oo gula ye hoolooweyelolo yanggango yunootoni (Yuka Kundingiyi), ngundo yeya suwoo suwoo sugi sugi oluwanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ngungga ngu, hamoo mande eweloyi Yuka. Mela ngalo oni simoo bale ngu, ene ma yowanggo. Ndatelo ngulo, ene nowoondoye hamoo ma teyingo, ngulo ene kenolo ingoweloyi nguya, ereremo kini. Ene yendo ngu ingootenggo. Ene yeya goboolo ootoolo, ngunonggo ye nowoondoye newendemo ulo, yeya oluwanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nondo ye yoyokootoowe, ye awanamoye kini koogewa ngundilo ma oluwanggo. Kini, no ye tanggeyemo ombulo, yeya oluwato. ");
INSERT INTO rwo_karo_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Nalu bodaga nangge, mela ngalo oni simoo baledo, ngu no ma neyowanggo. Ene yendo nangge no neyowanggo. Ndatelo ngulo, nondo keda sugi sugi oluwanoku, ngundilo nangge, ye nguya sugi sugi kedaga nguno oluwanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Yo, hamoo, ngu naluno nguno, ye ingowanggo. No Awanemboya oodoowe, ko, yendo ngu noya oodoyi, nondo yeya oluwato. ");
INSERT INTO rwo_karo_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Oni ene nolo mamana mande yolo, gome keyooteku ngu, ngu oningga ngu ene newende no nunoote. Oni ene newende no nunooteku ngu, Awando newende nguya ene inowa. Nondo nguya nowoondone ene inolo, nenengo damonine, ene doongeyimo yootunolo etungootoowe, ene no neyolo ingowalo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yesusndo ngundilo etoni, Yudas gula, Yudas Iskariyoot kini, ngundo Yesusno ewolo. Oo Bidodo Sembuli Sembunayi, ndatelo ngulo, ge noole doongenayimo tunootewelo eteku, ene ge mela ngano oni simoo bale doongeyemo ma tunootewa? Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yudas ngundilo sumoo etoni, asa, Yesusndo mandeni gumi ewolo. Oni ene newende no nunolo ngu, ene nolo mande gome keyowa. Ene ngundilo keyootoni ngu, asa, nolo Awanembo nguya, ngu oningga ngu, newende inootoni, noole eneno ombulo eneya suwoo suwoo sugi sugi oluwato. ");
INSERT INTO rwo_karo_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Oni ene newende no ma nunolo ngu, ene nolo mandene gome nga ma keyoote. Nga mandega yendo ingootenggoku nga, ngu nolomu kini. Nga ngu Awa no sulenelootoni ombuyingongga, ngulo mandeni. ");
INSERT INTO rwo_karo_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","No ataga yeya goboolo ootoolo, ngunonggo mande oo nga tunooteweloyi ngu yeno elo etuyelootenoku nga. ");
INSERT INTO rwo_karo_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ene ye hamoo oolengo Hoolooweyeloyingo ngu, Yuka Kundingiyi. Ngu no oowoonemo ngu Awando yengo suleyootoni ombuwa. Enengo koni ngu ngandilo. Ngundo ngu oo bidodo etuyelolo, nowoondoye yokutuwootoni, ngunonggo nondo mande yeno ewonoku, ngu bidodo tunoo oolengo ingomukowanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ariya, no ye yoyokowelo, ngulo nolo nowoondoyi imakeyingo oolooteku, ngu yeno nguya yewe tunootelo oluwa. Nondo yengo nowoondoyiga ko nowoondoyi imakeyingo yunootenoku, ngundo mela ngalo oni simoo baledo nowoondoyi imakeyingo yunootenggoku, ngu dagate. Ngulo ye nowoondoye ma soliyokolo sosolewelo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ye nga mandega nga ngu etuyelowonoku, ngu ye kuli ingowonggo. No ye yoyokolo oolelo, no ko yeno ombuwanolo ewonoku, ngu ingoyi. Ene kuli ye nowoondoye no nunowonggoku ngu, asa, ye ingolo oni oni tetoyi, no Awano ko oolouwano. Ndatelo ngulo, Awando no daganelolo, ene Ulungga oolengo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ataga oo ngu ma tunooteyingomo, no yeno kuli elo etenoku nga. Ngundilo ngulo, kootusina oo ngu tunootetoni ngu, asa, ye nguno nowoondoyemo hamoo tewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ariya, no yeya mande mande ulungga ko ma elo ingowato. Ndatelo ngulo, mela ngalo ngulo sobosobo tabango ulungga ngu ombute. Enengo yanggangoni ngundo no ma sobonelowa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ene mela ngalo oni simoo bale ngu komo ingowanggo. No nowoondone Awane inooteno. Ngundilo ngulo, no Awando oo teweloyi mande elo no nunowoku, ngu nangge teteno. Ariya, ye ootookootoyiga oolouwooto! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesusndo mande gula ewolo. No ngu Wayin de oolengo. Awanembo ngu ene Wayin kongga ngulo Sembuli. ");
INSERT INTO rwo_karo_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nolo kandene ngu ma enggetoni ngu, Awando andangelo yokowa. Ene ko kandene bidodo enggeteku ngu, Awando gome toongoolo, gome yomosiyowa. Ngundilo tetoni, engge gome oowooyingga oolengo enggewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ye ngu nondo mande ngu elo etuyelowonoku, ngundo ye nowoondoye yeni gome namboyi tunootewonggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ye komo no dowoolo oodoyi ngu, asa, nondo nguya ye yodowoolo oluwato. Wayin dega ngu kandeyi wembuyi bungomo ma dowoolo ngu, ene enggeweloyi nguya kini. Ngundilo nangge, ye nguya nono ma ootoolo ngu, ye ma enggewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","No de Wayin. Ye ngu Wayin de ngulo kandeyi. Oni ene nono oodoni ngu, no nguya eneya oodoole, ene ngunonggo gome ulungga enggewanggo. Ene ye no noyokolo ngu, asa, ye oo gula nguya ma tewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ene oni gula nono ma oluwaku ngu, asa, ene ngu de kandeyi ngundilo andangelo yokootoyi aliyewa. Yo, onindo ngu de kandeyi, ngu gooboongoolo siyakiyolo, de nombono katoyi demukowa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ene ye noya oodoyi, nolo mandene yeya oodoni ngu, ariya, ye oo gulalo ingolo yemboongewanggoku, ngu oo ngu ngundilo yeno tunootewa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ene yendo gome ulungga enggewanggoku damoningga nguno, ye nolo sulena oni kilalongo, ngu simoo bale etuyelowanggo. Ngundilo damoni gomengga, ngunonggo nolo Awane ngulo oowooyi bingaminidodo tunootewa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Awando newende no nunoyingo, ngundilo nangge, nondo yengo kuli nowoondone nguya yunowono. Ngulo, ye komo nolo mandene nga suwoo suwoo ingolo oodoyi, ngu nondo hamoo nowoondone ye yunowano. ");
INSERT INTO rwo_karo_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nondo kuli Awanembolo mamana mandeni gome keyowonoku, ngulo ngu, no Awane enengo nowoondoyiningga ngu newendemo oolooteno. Ngundilo nangge, ye nolo mamana mande gome keyowanggoku ngu, ariya, ye nguya nolo nowoondoyinengga ngu newendemo oluwanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","No ngandilo ingooteno. Nolo oni oningga ngu yeno oodoni, ye nowoondoyemo nguno hangeya manggowoomo ooleni, elo ngundilo ingooteno. Ngundilo ngulo, no nga mandega nga yeno eteno. ");
INSERT INTO rwo_karo_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nolo mamana mande ngu ngandilo. Nondo yengo nowoondoyi yunootenoku, ngundilo nangge, ye komo dobooguliye ngundiya teyi! ");
INSERT INTO rwo_karo_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ene oni gulado ene dobooguliyi hoolooweyelowelo, enengo kedaga ngu yokowaku ngu, ariya, nowoondoyi teyingo damoningga, ngundo nowoondoyi teweloyi damoni gidalega, ngu hamoo oolengo dagayeloote. ");
INSERT INTO rwo_karo_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ye nondo etenoku damoningga nga tetoyi ngu, asa, ye ngu nolo dobooguline. ");
INSERT INTO rwo_karo_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ko oni ngu enengo oni ulungga, ngundo ko oo teteku ngu ma ingoote. Ngundilo ngulo, nondo yeya ko oni elo ma ewano. Kini, mande bidodo nondo Awanonggo ingowonoku, ngu yeno etoowe, ingomukowonggoku ngu! Ngulo nondo yeya ngu doboogulinelo ewano. ");
INSERT INTO rwo_karo_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Yendo no ma logonelowonggori. Kini, nondo ye ngu nenengo logoyelowonoku, ngulo ye komo oolouya, gome oolengo enggewanggo. Yengo enggeyega ngu gome sugi sugi oluwanggo. Ye ngundilo telo, ngunonggo ye oo gula yowelo, no oowoonemo Awano yemboongetoyi ngu, asa, Awando ngu ooga ngu, hamoo oolengo, ye yunowa. ");
INSERT INTO rwo_karo_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nondo nga mamana mandega nga ye yunooteno. Ye komo dobooguliye nowoondoyi teyi! Elo ewolo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Yesusndo ngandilo ewolo. Mela ngalo oni simoo bale ngando yeya mundiyi tetoyiga ngu, asa, ye ingoyi! Ene noya koletelo mundi tewonggoku, ngulo yeno nguya tewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ene hamoo ye mela ngalo damoni biyomi ngu keyootoyi ngu, ariya, mela ngalo damoni biyomi tetenggoku oni simoo baledo, ene mete yengo ingowanggo. Ye enengo keyemo oni ngulo, elo ingowanggo. Ene ye ngu damoni biyomimbolo oni kini. Kini, nondo ye kuli logoyelowonoku ngu, ye mela ngalo damoni biyomi yokootoyi, yoyolo, sungo yoyewono. Ngundilo ngulo, mela ngalo oni simoo bale, ngundo yeya mundi tewanggo. ");
INSERT INTO rwo_karo_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ye komo nondo mandega yeno ewonoku, ngulo ingondudu teyi! Ko oni ngu enengo oni ulungga ngu dagalo ma oluwa. Ngulo ngu, no noyolo yombulinelolo, no keyonelowonggoku ngu, asa, ye nguya 