﻿USE sofia;
DROP TABLE IF EXISTS sofia.russyn_vpl;
CREATE TABLE russyn_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES russyn_vpl WRITE;
INSERT INTO russyn_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1"," В начале сотворил Бог небо и землю. ");
INSERT INTO russyn_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Земля же была безвидна и пуста, и тьма над бездною, и Дух Божий носился над водою. ");
INSERT INTO russyn_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","И сказал Бог: да будет свет. И стал свет. ");
INSERT INTO russyn_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","И увидел Бог свет, что он хорош, и отделил Бог свет от тьмы. ");
INSERT INTO russyn_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","И назвал Бог свет днем, а тьму ночью. И был вечер, и было утро: день один. ");
INSERT INTO russyn_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","И сказал Бог: да будет твердь посреди воды, и да отделяет она воду от воды. И стало так. ");
INSERT INTO russyn_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","И создал Бог твердь, и отделил воду, которая под твердью, от воды, которая над твердью. И стало так. ");
INSERT INTO russyn_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","И назвал Бог твердь небом. И увидел Бог, что это хорошо. И был вечер, и было утро: день второй. ");
INSERT INTO russyn_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","И сказал Бог: да соберется вода, которая под небом, в одно место, и да явится суша. И стало так. И собралась вода под небом в свои места, и явилась суша. ");
INSERT INTO russyn_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","И назвал Бог сушу землею, а собрание вод назвал морями. И увидел Бог, что это хорошо. ");
INSERT INTO russyn_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","И сказал Бог: да произрастит земля зелень, траву, сеющую семя по роду и по подобию ее, и дерево плодовитое, приносящее по роду своему плод, в котором семя его на земле. И стало так. ");
INSERT INTO russyn_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","И произвела земля зелень, траву, сеющую семя по роду и по подобию ее, и дерево плодовитое, приносящее плод, в котором семя его по роду его на земле. И увидел Бог, что это хорошо. ");
INSERT INTO russyn_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","И был вечер, и было утро: день третий. ");
INSERT INTO russyn_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","И сказал Бог: да будут светила на тверди небесной для освещения земли и для отделения дня от ночи, и для знамений, и времен, и дней, и годов; ");
INSERT INTO russyn_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","и да будут они светильниками на тверди небесной, чтобы светить на землю. И стало так. ");
INSERT INTO russyn_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","И создал Бог два светила великие: светило большее, для управления днем, и светило меньшее, для управления ночью, и звезды; ");
INSERT INTO russyn_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","и поставил их Бог на тверди небесной, чтобы светить на землю, ");
INSERT INTO russyn_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","и управлять днем и ночью, и отделять свет от тьмы. И увидел Бог, что это хорошо. ");
INSERT INTO russyn_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","И был вечер, и было утро: день четвертый. ");
INSERT INTO russyn_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","И сказал Бог: да произведет вода пресмыкающихся, душу живую; и птицы да полетят над землею, по тверди небесной. И стало так. ");
INSERT INTO russyn_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","И сотворил Бог рыб больших и всякую душу животных пресмыкающихся, которых произвела вода, по роду их, и всякую птицу пернатую по роду ее. И увидел Бог, что это хорошо. ");
INSERT INTO russyn_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","И благословил их Бог, говоря: плодитесь и размножайтесь, и наполняйте воды в морях, и птицы да размножаются на земле. ");
INSERT INTO russyn_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","И был вечер, и было утро: день пятый. ");
INSERT INTO russyn_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","И сказал Бог: да произведет земля душу живую по роду ее, скотов, и гадов, и зверей земных по роду их. И стало так. ");
INSERT INTO russyn_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","И создал Бог зверей земных по роду их, и скот по роду его, и всех гадов земных по роду их. И увидел Бог, что это хорошо. ");
INSERT INTO russyn_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","И сказал Бог: сотворим человека по образу Нашему и по подобию Нашему, и да владычествуют они над рыбами морскими, и над птицами небесными, и над зверями, и над скотом, и над всею землею, и над всеми гадами, пресмыкающимися по земле. ");
INSERT INTO russyn_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","И сотворил Бог человека по образу Своему, по образу Божию сотворил его; мужчину и женщину сотворил их. ");
INSERT INTO russyn_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","И благословил их Бог, и сказал им Бог: плодитесь и размножайтесь, и наполняйте землю, и обладайте ею, и владычествуйте над рыбами морскими и над зверями, и над птицами небесными, и над всяким скотом, и над всею землею, и над всяким животным, пресмыкающимся по земле. ");
INSERT INTO russyn_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","И сказал Бог: вот, Я дал вам всякую траву, сеющую семя, какая есть на всей земле, и всякое дерево, у которого плод древесный, сеющий семя; - вам сие будет в пищу; ");
INSERT INTO russyn_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","а всем зверям земным, и всем птицам небесным, и всякому гаду, пресмыкающемуся по земле, в котором душа живая, дал Я всю зелень травную в пищу. И стало так. ");
INSERT INTO russyn_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","И увидел Бог все, что Он создал, и вот, хорошо весьма. И был вечер, и было утро: день шестой. ");
INSERT INTO russyn_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Так совершены небо и земля и все воинство их. ");
INSERT INTO russyn_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","И совершил Бог к седьмому дню дела Свои, которые Он делал, и почил в день седьмый от всех дел Своих, которые делал. ");
INSERT INTO russyn_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","И благословил Бог седьмой день, и освятил его, ибо в оный почил от всех дел Своих, которые Бог творил и созидал. ");
INSERT INTO russyn_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Вот происхождение неба и земли, при сотворении их, в то время, когда Господь Бог создал землю и небо, ");
INSERT INTO russyn_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","и всякий полевой кустарник, которого еще не было на земле, и всякую полевую траву, которая еще не росла, ибо Господь Бог не посылал дождя на землю, и не было человека для возделывания земли, ");
INSERT INTO russyn_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","но пар поднимался с земли и орошал все лице земли. ");
INSERT INTO russyn_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","И создал Господь Бог человека из праха земного, и вдунул в лице его дыхание жизни, и стал человек душею живою. ");
INSERT INTO russyn_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","И насадил Господь Бог рай в Едеме на востоке, и поместил там человека, которого создал. ");
INSERT INTO russyn_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","И произрастил Господь Бог из земли всякое дерево, приятное на вид и хорошее для пищи, и дерево жизни посреди рая, и дерево познания добра и зла. ");
INSERT INTO russyn_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Из Едема выходила река для орошения рая; и потом разделялась на четыре реки. ");
INSERT INTO russyn_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Имя одной Фисон: она обтекает всю землю Хавила, ту, где золото; ");
INSERT INTO russyn_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","и золото той земли хорошее; там бдолах и камень оникс. ");
INSERT INTO russyn_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Имя второй реки Гихон (Геон): она обтекает всю землю Куш. ");
INSERT INTO russyn_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Имя третьей реки Хиддекель (Тигр): она протекает пред Ассириею. Четвертая река Евфрат. ");
INSERT INTO russyn_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","И взял Господь Бог человека, которого создал, и поселил его в саду Едемском, чтобы возделывать его и хранить его. ");
INSERT INTO russyn_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","И заповедал Господь Бог человеку, говоря: от всякого дерева в саду ты будешь есть, ");
INSERT INTO russyn_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","а от дерева познания добра и зла не ешь от него, ибо в день, в который ты вкусишь от него, смертью умрешь. ");
INSERT INTO russyn_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","И сказал Господь Бог: не хорошо быть человеку одному; сотворим ему помощника, соответственного ему. ");
INSERT INTO russyn_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Господь Бог образовал из земли всех животных полевых и всех птиц небесных, и привел их к человеку, чтобы видеть, как он назовет их, и чтобы, как наречет человек всякую душу живую, так и было имя ей. ");
INSERT INTO russyn_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","И нарек человек имена всем скотам и птицам небесным и всем зверям полевым; но для человека не нашлось помощника, подобного ему. ");
INSERT INTO russyn_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","И навел Господь Бог на человека крепкий сон; и, когда он уснул, взял одно из ребер его, и закрыл то место плотию. ");
INSERT INTO russyn_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","И создал Господь Бог из ребра, взятого у человека, жену, и привел ее к человеку. ");
INSERT INTO russyn_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","И сказал человек: вот, это кость от костей моих и плоть от плоти моей; она будет называться женою, ибо взята от мужа своего. ");
INSERT INTO russyn_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Потому оставит человек отца своего и мать свою и прилепится к жене своей; и будут два одна плоть. ");
INSERT INTO russyn_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","И были оба наги, Адам и жена его, и не стыдились. ");
INSERT INTO russyn_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Змей был хитрее всех зверей полевых, которых создал Господь Бог. И сказал змей жене: подлинно ли сказал Бог: не ешьте ни от какого дерева в раю? ");
INSERT INTO russyn_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","И сказала жена змею: плоды с дерев мы можем есть, ");
INSERT INTO russyn_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","только плодов дерева, которое среди рая, сказал Бог, не ешьте их и не прикасайтесь к ним, чтобы вам не умереть. ");
INSERT INTO russyn_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","И сказал змей жене: нет, не умрете, ");
INSERT INTO russyn_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","но знает Бог, что в день, в который вы вкусите их, откроются глаза ваши, и вы будете, как боги, знающие добро и зло. ");
INSERT INTO russyn_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","И увидела жена, что дерево хорошо для пищи, и что оно приятно для глаз и вожделенно, потому что дает знание; и взяла плодов его и ела; и дала также мужу своему, и он ел. ");
INSERT INTO russyn_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","И открылись глаза у них обоих, и узнали они, что наги, и сшили смоковные листья, и сделали себе опоясания. ");
INSERT INTO russyn_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","И услышали голос Господа Бога, ходящего в раю во время прохлады дня; и скрылся Адам и жена его от лица Господа Бога между деревьями рая. ");
INSERT INTO russyn_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","И воззвал Господь Бог к Адаму и сказал ему: Адам, где ты? ");
INSERT INTO russyn_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Он сказал: голос Твой я услышал в раю, и убоялся, потому что я наг, и скрылся. ");
INSERT INTO russyn_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","И сказал Бог: кто сказал тебе, что ты наг? не ел ли ты от дерева, с которого Я запретил тебе есть? ");
INSERT INTO russyn_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Адам сказал: жена, которую Ты мне дал, она дала мне от дерева, и я ел. ");
INSERT INTO russyn_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","И сказал Господь Бог жене: что ты это сделала? Жена сказала: змей обольстил меня, и я ела. ");
INSERT INTO russyn_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","И сказал Господь Бог змею: за то, что ты сделал это, проклят ты пред всеми скотами и пред всеми зверями полевыми; ты будешь ходить на чреве твоем, и будешь есть прах во все дни жизни твоей; ");
INSERT INTO russyn_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","и вражду положу между тобою и между женою, и между семенем твоим и между семенем ее; оно будет поражать тебя в голову, а ты будешь жалить его в пяту. ");
INSERT INTO russyn_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Жене сказал: умножая умножу скорбь твою в беременности твоей; в болезни будешь рождать детей; и к мужу твоему влечение твое, и он будет господствовать над тобою. ");
INSERT INTO russyn_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Адаму же сказал: за то, что ты послушал голоса жены твоей и ел от дерева, о котором Я заповедал тебе, сказав: не ешь от него, проклята земля за тебя; со скорбью будешь питаться от нее во все дни жизни твоей; ");
INSERT INTO russyn_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","терния и волчцы произрастит она тебе; и будешь питаться полевою травою; ");
INSERT INTO russyn_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","в поте лица твоего будешь есть хлеб, доколе не возвратишься в землю, из которой ты взят, ибо прах ты и в прах возвратишься. ");
INSERT INTO russyn_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","И нарек Адам имя жене своей: Ева, ибо она стала матерью всех живущих. ");
INSERT INTO russyn_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","И сделал Господь Бог Адаму и жене его одежды кожаные и одел их. ");
INSERT INTO russyn_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","И сказал Господь Бог: вот, Адам стал как один из Нас, зная добро и зло; и теперь как бы не простер он руки своей, и не взял также от дерева жизни, и не вкусил, и не стал жить вечно. ");
INSERT INTO russyn_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","И выслал его Господь Бог из сада Едемского, чтобы возделывать землю, из которой он взят. ");
INSERT INTO russyn_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","И изгнал Адама, и поставил на востоке у сада Едемского Херувима и пламенный меч обращающийся, чтобы охранять путь к дереву жизни. ");
INSERT INTO russyn_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Адам познал Еву, жену свою; и она зачала, и родила Каина, и сказала: приобрела я человека от Господа. ");
INSERT INTO russyn_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","И еще родила брата его, Авеля. И был Авель пастырь овец, а Каин был земледелец. ");
INSERT INTO russyn_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Спустя несколько времени, Каин принес от плодов земли дар Господу, ");
INSERT INTO russyn_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","и Авель также принес от первородных стада своего и от тука их. И призрел Господь на Авеля и на дар его, ");
INSERT INTO russyn_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","а на Каина и на дар его не призрел. Каин сильно огорчился, и поникло лице его. ");
INSERT INTO russyn_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","И сказал Господь Бог Каину: почему ты огорчился? и отчего поникло лице твое? ");
INSERT INTO russyn_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","если делаешь доброе, то не поднимаешь ли лица? а если не делаешь доброго, то у дверей грех лежит; он влечет тебя к себе, но ты господствуй над ним. ");
INSERT INTO russyn_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","И сказал Каин Авелю, брату своему. И когда они были в поле, восстал Каин на Авеля, брата своего, и убил его. ");
INSERT INTO russyn_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","И сказал Господь Бог Каину: где Авель, брат твой? Он сказал: не знаю; разве я сторож брату моему? ");
INSERT INTO russyn_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","И сказал Господь: что ты сделал? голос крови брата твоего вопиет ко Мне от земли; ");
INSERT INTO russyn_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","и ныне проклят ты от земли, которая отверзла уста свои принять кровь брата твоего от руки твоей; ");
INSERT INTO russyn_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","когда ты будешь возделывать землю, она не станет более давать силы своей для тебя; ты будешь изгнанником и скитальцем на земле. ");
INSERT INTO russyn_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","И сказал Каин Господу Богу: наказание мое больше, нежели снести можно; ");
INSERT INTO russyn_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","вот, Ты теперь сгоняешь меня с лица земли, и от лица Твоего я скроюсь, и буду изгнанником и скитальцем на земле; и всякий, кто встретится со мною, убьет меня. ");
INSERT INTO russyn_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","И сказал ему Господь Бог: за то всякому, кто убьет Каина, отомстится всемеро. И сделал Господь Бог Каину знамение, чтобы никто, встретившись с ним, не убил его. ");
INSERT INTO russyn_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","И пошел Каин от лица Господня и поселился в земле Нод, на восток от Едема. ");
INSERT INTO russyn_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","И познал Каин жену свою; и она зачала и родила Еноха. И построил он город; и назвал город по имени сына своего: Енох. ");
INSERT INTO russyn_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","У Еноха родился Ирад Гаидад; Ирад родил Мехиаеля Малелеила; Мехиаель родил Мафусала; Мафусал родил Ламеха. ");
INSERT INTO russyn_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","И взял себе Ламех две жены: имя одной: Ада, и имя второй: Цилла. ");
INSERT INTO russyn_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ада родила Иавала: он был отец живущих в шатрах со стадами. ");
INSERT INTO russyn_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Имя брату его Иувал: он был отец всех играющих на гуслях и свирели. ");
INSERT INTO russyn_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Цилла также родила Тувалкаина (Фовела), который был ковачом всех орудий из меди и железа. И сестра Тувалкаина Ноема. ");
INSERT INTO russyn_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","И сказал Ламех женам своим: Ада и Цилла! послушайте голоса моего; жены Ламеховы! внимайте словам моим: я убил мужа в язву мне и отрока в рану мне; ");
INSERT INTO russyn_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","если за Каина отмстится всемеро, то за Ламеха в семьдесят раз всемеро. ");
INSERT INTO russyn_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","И познал Адам еще Еву, жену свою, и она родила сына, и нарекла ему имя: Сиф, потому что, говорила она, Бог положил мне другое семя, вместо Авеля, которого убил Каин. ");
INSERT INTO russyn_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","У Сифа также родился сын, и он нарек ему имя: Енос; тогда начали призывать имя Господа Бога. ");
INSERT INTO russyn_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Вот родословие Адама: когда Бог сотворил человека, по подобию Божию создал его, ");
INSERT INTO russyn_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","мужчину и женщину сотворил их, и благословил их, и нарек им имя: человек, в день сотворения их. ");
INSERT INTO russyn_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Адам жил сто тридцать лет и родил сына по подобию своему и по образу своему, и нарек ему имя: Сиф. ");
INSERT INTO russyn_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Дней Адама по рождении им Сифа было восемьсот лет, и родил он сынов и дочерей. ");
INSERT INTO russyn_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Всех же дней жизни Адамовой было девятьсот тридцать лет; и он умер. ");
INSERT INTO russyn_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Сиф жил сто пять лет и родил Еноса. ");
INSERT INTO russyn_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","По рождении Еноса Сиф жил восемьсот семь лет и родил сынов и дочерей. ");
INSERT INTO russyn_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Всех же дней Сифовых было девятьсот двенадцать лет; и он умер. ");
INSERT INTO russyn_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Енос жил девяносто лет и родил Каинана. ");
INSERT INTO russyn_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","По рождении Каинана Енос жил восемьсот пятнадцать лет и родил сынов и дочерей. ");
INSERT INTO russyn_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Всех же дней Еноса было девятьсот пять лет; и он умер. ");
INSERT INTO russyn_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Каинан жил семьдесят лет и родил Малелеила. ");
INSERT INTO russyn_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","По рождении Малелеила Каинан жил восемьсот сорок лет и родил сынов и дочерей. ");
INSERT INTO russyn_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Всех же дней Каинана было девятьсот десять лет; и он умер. ");
INSERT INTO russyn_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Малелеил жил шестьдесят пять лет и родил Иареда. ");
INSERT INTO russyn_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","По рождении Иареда Малелеил жил восемьсот тридцать лет и родил сынов и дочерей. ");
INSERT INTO russyn_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Всех же дней Малелеила было восемьсот девяносто пять лет; и он умер. ");
INSERT INTO russyn_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Иаред жил сто шестьдесят два года и родил Еноха. ");
INSERT INTO russyn_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","По рождении Еноха Иаред жил восемьсот лет и родил сынов и дочерей. ");
INSERT INTO russyn_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Всех же дней Иареда было девятьсот шестьдесят два года; и он умер. ");
INSERT INTO russyn_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Енох жил шестьдесят пять лет и родил Мафусала. ");
INSERT INTO russyn_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","И ходил Енох пред Богом, по рождении Мафусала, триста лет и родил сынов и дочерей. ");
INSERT INTO russyn_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Всех же дней Еноха было триста шестьдесят пять лет. ");
INSERT INTO russyn_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","И ходил Енох пред Богом; и не стало его, потому что Бог взял его. ");
INSERT INTO russyn_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Мафусал жил сто восемьдесят семь лет и родил Ламеха. ");
INSERT INTO russyn_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","По рождении Ламеха Мафусал жил семьсот восемьдесят два года и родил сынов и дочерей. ");
INSERT INTO russyn_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Всех же дней Мафусала было девятьсот шестьдесят девять лет; и он умер. ");
INSERT INTO russyn_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Ламех жил сто восемьдесят два года и родил сына, ");
INSERT INTO russyn_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","и нарек ему имя: Ной, сказав: он утешит нас в работе нашей и в трудах рук наших при возделывании земли, которую проклял Господь Бог. ");
INSERT INTO russyn_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","И жил Ламех по рождении Ноя пятьсот девяносто пять лет и родил сынов и дочерей. ");
INSERT INTO russyn_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Всех же дней Ламеха было семьсот семьдесят семь лет; и он умер. ");
INSERT INTO russyn_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Ною было пятьсот лет и родил Ной трех сынов: Сима, Хама и Иафета. ");
INSERT INTO russyn_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Когда люди начали умножаться на земле и родились у них дочери, ");
INSERT INTO russyn_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","тогда сыны Божии увидели дочерей человеческих, что они красивы, и брали их себе в жены, какую кто избрал. ");
INSERT INTO russyn_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","И сказал Господь Бог: не вечно Духу Моему быть пренебрегаемым человеками сими, потому что они плоть; пусть будут дни их сто двадцать лет. ");
INSERT INTO russyn_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","В то время были на земле исполины, особенно же с того времени, как сыны Божии стали входить к дочерям человеческим, и они стали рождать им: это сильные, издревле славные люди. ");
INSERT INTO russyn_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","И увидел Господь Бог, что велико развращение человеков на земле, и что все мысли и помышления сердца их были зло во всякое время; ");
INSERT INTO russyn_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","и раскаялся Господь, что создал человека на земле, и восскорбел в сердце Своем. ");
INSERT INTO russyn_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","И сказал Господь: истреблю с лица земли человеков, которых Я сотворил, от человека до скотов, и гадов и птиц небесных истреблю, ибо Я раскаялся, что создал их. ");
INSERT INTO russyn_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ной же обрел благодать пред очами Господа Бога. ");
INSERT INTO russyn_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Вот житие Ноя: Ной был человек праведный и непорочный в роде своем; Ной ходил пред Богом. ");
INSERT INTO russyn_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Ной родил трех сынов: Сима, Хама и Иафета. ");
INSERT INTO russyn_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Но земля растлилась пред лицем Божиим, и наполнилась земля злодеяниями. ");
INSERT INTO russyn_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","И воззрел Господь Бог на землю, и вот, она растленна, ибо всякая плоть извратила путь свой на земле. ");
INSERT INTO russyn_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","И сказал Господь Бог Ною: конец всякой плоти пришел пред лице Мое, ибо земля наполнилась от них злодеяниями; и вот, Я истреблю их с земли. ");
INSERT INTO russyn_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Сделай себе ковчег из дерева гофер; отделения сделай в ковчеге и осмоли его смолою внутри и снаружи. ");
INSERT INTO russyn_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","И сделай его так: длина ковчега триста локтей; ширина его пятьдесят локтей, а высота его тридцать локтей. ");
INSERT INTO russyn_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","И сделай отверстие в ковчеге, и в локоть сведи его вверху, и дверь в ковчег сделай с боку его; устрой в нем нижнее, второе и третье жилье. ");
INSERT INTO russyn_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","И вот, Я наведу на землю потоп водный, чтоб истребить всякую плоть, в которой есть дух жизни, под небесами; все, что есть на земле, лишится жизни. ");
INSERT INTO russyn_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Но с тобою Я поставлю завет Мой, и войдешь в ковчег ты, и сыновья твои, и жена твоя, и жены сынов твоих с тобою. ");
INSERT INTO russyn_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Введи также в ковчег из всякого скота, и из всех гадов, и из всех животных, и от всякой плоти по паре, чтоб они остались с тобою в живых; мужеского пола и женского пусть они будут. ");
INSERT INTO russyn_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Из всех птиц по роду их, и из всех скотов по роду их, и из всех пресмыкающихся по земле по роду их, из всех по паре войдут к тебе, чтобы остались в живых с тобою, мужеского пола и женского. ");
INSERT INTO russyn_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ты же возьми себе всякой пищи, какою питаются, и собери к себе; и будет она для тебя и для них пищею. ");
INSERT INTO russyn_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","И сделал Ной все как повелел ему Господь Бог, так он и сделал. ");
INSERT INTO russyn_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","И сказал Господь Бог Ною: войди ты и все семейство твое в ковчег, ибо тебя увидел Я праведным предо Мною в роде сем; ");
INSERT INTO russyn_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","и всякого скота чистого возьми по семи, мужеского пола и женского, а из скота нечистого по два, мужеского пола и женского; ");
INSERT INTO russyn_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","также и из птиц небесных чистых по семи, мужеского пола и женского, и из всех птиц нечистых по две, мужеского пола и женского, чтобы сохранить племя для всей земли, ");
INSERT INTO russyn_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","ибо чрез семь дней Я буду изливать дождь на землю сорок дней и сорок ночей; и истреблю все существующее, что Я создал, с лица земли. ");
INSERT INTO russyn_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ной сделал все, что Господь Бог повелел ему. ");
INSERT INTO russyn_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Ной же был шестисот лет, как потоп водный пришел на землю. ");
INSERT INTO russyn_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","И вошел Ной и сыновья его, и жена его, и жены сынов его с ним в ковчег от вод потопа. ");
INSERT INTO russyn_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","И из птиц чистых и из птиц нечистых, и из скотов чистых и из скотов нечистых, и из зверей и из всех пресмыкающихся по земле ");
INSERT INTO russyn_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","по паре, мужеского пола и женского, вошли к Ною в ковчег, как Господь Бог повелел Ною. ");
INSERT INTO russyn_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Чрез семь дней воды потопа пришли на землю. ");
INSERT INTO russyn_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","В шестисотый год жизни Ноевой, во второй месяц, в семнадцатый день месяца, в сей день разверзлись все источники великой бездны, и окна небесные отворились; ");
INSERT INTO russyn_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","и лился на землю дождь сорок дней и сорок ночей. ");
INSERT INTO russyn_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","В сей самый день вошел в ковчег Ной, и Сим, Хам и Иафет, сыновья Ноевы, и жена Ноева, и три жены сынов его с ними. ");
INSERT INTO russyn_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Они, и все звери земли по роду их, и всякий скот по роду его, и все гады, пресмыкающиеся по земле, по роду их, и все летающие по роду их, все птицы, все крылатые, ");
INSERT INTO russyn_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","и вошли к Ною в ковчег по паре мужеского пола и женского от всякой плоти, в которой есть дух жизни; ");
INSERT INTO russyn_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","и вошедшие к Ною в ковчег мужеский и женский пол всякой плоти вошли, как повелел ему Господь Бог. И затворил Господь Бог за ним ковчег. ");
INSERT INTO russyn_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","И продолжалось на земле наводнение сорок дней и сорок ночей, и умножилась вода, и подняла ковчег, и он возвысился над землею; ");
INSERT INTO russyn_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","вода же усиливалась и весьма умножалась на земле, и ковчег плавал по поверхности вод. ");
INSERT INTO russyn_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","И усилилась вода на земле чрезвычайно, так что покрылись все высокие горы, какие есть под всем небом; ");
INSERT INTO russyn_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","на пятнадцать локтей поднялась над ними вода, и покрылись все высокие горы. ");
INSERT INTO russyn_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","И лишилась жизни всякая плоть, движущаяся по земле, и птицы, и скоты, и звери, и все гады, ползающие по земле, и все люди; ");
INSERT INTO russyn_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","все, что имело дыхание духа жизни в ноздрях своих на суше, умерло. ");
INSERT INTO russyn_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Истребилось всякое существо, которое было на поверхности всей земли; от человека до скота, и гадов, и птиц небесных, - все истребилось с земли, остался только Ной и что было с ним в ковчеге. ");
INSERT INTO russyn_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Вода же усиливалась на земле сто пятьдесят дней. ");
INSERT INTO russyn_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","И вспомнил Бог о Ное, и о всех зверях, и о всех скотах, и о всех птицах, и о всех гадах пресмыкающихся, бывших с ним в ковчеге; и навел Бог ветер на землю, и воды остановились. ");
INSERT INTO russyn_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","И закрылись источники бездны и окна небесные, и перестал дождь с неба. ");
INSERT INTO russyn_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Вода же постепенно возвращалась с земли, и стала убывать вода по окончании ста пятидесяти дней. ");
INSERT INTO russyn_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","И остановился ковчег в седьмом месяце, в семнадцатый день месяца, на горах Араратских. ");
INSERT INTO russyn_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Вода постоянно убывала до десятого месяца; в первый день десятого месяца показались верхи гор. ");
INSERT INTO russyn_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","По прошествии сорока дней Ной открыл сделанное им окно ковчега ");
INSERT INTO russyn_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","и выпустил ворона, чтобы видеть, убыла ли вода с земли, который, вылетев, отлетал и прилетал, пока осушилась земля от воды. ");
INSERT INTO russyn_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Потом выпустил от себя голубя, чтобы видеть, сошла ли вода с лица земли, ");
INSERT INTO russyn_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","но голубь не нашел места покоя для ног своих и возвратился к нему в ковчег, ибо вода была еще на поверхности всей земли; и он простер руку свою, и взял его, и принял к себе в ковчег. ");
INSERT INTO russyn_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","И помедлил еще семь дней других и опять выпустил голубя из ковчега. ");
INSERT INTO russyn_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Голубь возвратился к нему в вечернее время, и вот, свежий масличный лист во рту у него, и Ной узнал, что вода сошла с земли. ");
INSERT INTO russyn_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Он помедлил еще семь дней других и опять выпустил голубя; и он уже не возвратился к нему. ");
INSERT INTO russyn_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Шестьсот первого года жизни Ноевой к первому дню первого месяца иссякла вода на земле; и открыл Ной кровлю ковчега и посмотрел, и вот, обсохла поверхность земли. ");
INSERT INTO russyn_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","И во втором месяце, к двадцать седьмому дню месяца, земля высохла. ");
INSERT INTO russyn_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","И сказал Господь Бог Ною: ");
INSERT INTO russyn_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","выйди из ковчега ты и жена твоя, и сыновья твои, и жены сынов твоих с тобою; ");
INSERT INTO russyn_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","выведи с собою всех животных, которые с тобою, от всякой плоти, из птиц, и скотов, и всех гадов, пресмыкающихся по земле: пусть разойдутся они по земле, и пусть плодятся и размножаются на земле. ");
INSERT INTO russyn_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","И вышел Ной и сыновья его, и жена его, и жены сынов его с ним; ");
INSERT INTO russyn_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","все звери, и весь скот, и все гады, и все птицы, все движущееся по земле, по родам своим, вышли из ковчега. ");
INSERT INTO russyn_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","И устроил Ной жертвенник Господу; и взял из всякого скота чистого и из всех птиц чистых и принес во всесожжение на жертвеннике. ");
INSERT INTO russyn_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","И обонял Господь приятное благоухание, и сказал Господь Бог в сердце Своем: не буду больше проклинать землю за человека, потому что помышление сердца человеческого - зло от юности его; и не буду больше поражать всего живущего, как Я сделал: ");
INSERT INTO russyn_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","впредь во все дни земли сеяние и жатва, холод и зной, лето и зима, день и ночь не прекратятся. ");
INSERT INTO russyn_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","И благословил Бог Ноя и сынов его и сказал им: плодитесь и размножайтесь, и наполняйте землю и обладайте ею; ");
INSERT INTO russyn_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","да страшатся и да трепещут вас все звери земные, и весь скот земной, и все птицы небесные, все, что движется на земле, и все рыбы морские: в ваши руки отданы они; ");
INSERT INTO russyn_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","все движущееся, что живет, будет вам в пищу; как зелень травную даю вам все; ");
INSERT INTO russyn_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","только плоти с душею ее, с кровью ее, не ешьте; ");
INSERT INTO russyn_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Я взыщу и вашу кровь, в которой жизнь ваша, взыщу ее от всякого зверя, взыщу также душу человека от руки человека, от руки брата его; ");
INSERT INTO russyn_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","кто прольет кровь человеческую, того кровь прольется рукою человека: ибо человек создан по образу Божию; ");
INSERT INTO russyn_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","вы же плодитесь и размножайтесь, и распространяйтесь по земле, и умножайтесь на ней. ");
INSERT INTO russyn_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","И сказал Бог Ною и сынам его с ним: ");
INSERT INTO russyn_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","вот, Я поставляю завет Мой с вами и с потомством вашим после вас, ");
INSERT INTO russyn_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","и со всякою душею живою, которая с вами, с птицами и со скотами, и со всеми зверями земными, которые у вас, со всеми вышедшими из ковчега, со всеми животными земными; ");
INSERT INTO russyn_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","поставляю завет Мой с вами, что не будет более истреблена всякая плоть водами потопа, и не будет уже потопа на опустошение земли. ");
INSERT INTO russyn_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","И сказал Господь Бог: вот знамение завета, который Я поставляю между Мною и между вами и между всякою душею живою, которая с вами, в роды навсегда: ");
INSERT INTO russyn_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Я полагаю радугу Мою в облаке, чтоб она была знамением вечного завета между Мною и между землею. ");
INSERT INTO russyn_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","И будет, когда Я наведу облако на землю, то явится радуга Моя в облаке; ");
INSERT INTO russyn_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","и Я вспомню завет Мой, который между Мною и между вами и между всякою душею живою во всякой плоти; и не будет более вода потопом на истребление всякой плоти. ");
INSERT INTO russyn_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","И будет радуга Моя в облаке, и Я увижу ее, и вспомню завет вечный между Богом и между землею и между всякою душею живою во всякой плоти, которая на земле. ");
INSERT INTO russyn_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","И сказал Бог Ною: вот знамение завета, который Я поставил между Мною и между всякою плотью, которая на земле. ");
INSERT INTO russyn_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Сыновья Ноя, вышедшие из ковчега, были: Сим, Хам и Иафет. Хам же был отец Ханаана. ");
INSERT INTO russyn_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Сии трое были сыновья Ноевы, и от них населилась вся земля. ");
INSERT INTO russyn_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Ной начал возделывать землю и насадил виноградник; ");
INSERT INTO russyn_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","и выпил он вина, и опьянел, и лежал обнаженным в шатре своем. ");
INSERT INTO russyn_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","И увидел Хам, отец Ханаана, наготу отца своего, и выйдя рассказал двум братьям своим. ");
INSERT INTO russyn_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Сим же и Иафет взяли одежду и, положив ее на плечи свои, пошли задом и покрыли наготу отца своего; лица их были обращены назад, и они не видали наготы отца своего. ");
INSERT INTO russyn_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Ной проспался от вина своего и узнал, что сделал над ним меньший сын его, ");
INSERT INTO russyn_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","и сказал: проклят Ханаан; раб рабов будет он у братьев своих. ");
INSERT INTO russyn_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Потом сказал: благословен Господь Бог Симов; Ханаан же будет рабом ему; ");
INSERT INTO russyn_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","да распространит Бог Иафета, и да вселится он в шатрах Симовых; Ханаан же будет рабом ему. ");
INSERT INTO russyn_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","И жил Ной после потопа триста пятьдесят лет. ");
INSERT INTO russyn_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Всех же дней Ноевых было девятьсот пятьдесят лет, и он умер. ");
INSERT INTO russyn_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Вот родословие сынов Ноевых: Сима, Хама и Иафета. После потопа родились у них дети. ");
INSERT INTO russyn_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Сыны Иафета: Гомер, Магог, Мадай, Иаван, Елиса, Фувал, Мешех и Фирас. ");
INSERT INTO russyn_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Сыны Гомера: Аскеназ, Рифат и Фогарма. ");
INSERT INTO russyn_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Сыны Иавана: Елиса, Фарсис, Киттим и Доданим. ");
INSERT INTO russyn_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","От сих населились острова народов в землях их, каждый по языку своему, по племенам своим, в народах своих. ");
INSERT INTO russyn_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Сыны Хама: Хуш, Мицраим, Фут и Ханаан. ");
INSERT INTO russyn_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Сыны Хуша: Сева, Хавила, Савта, Раама и Савтеха. Сыны Раамы: Шева и Дедан. ");
INSERT INTO russyn_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Хуш родил также Нимрода; сей начал быть силен на земле; ");
INSERT INTO russyn_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","он был сильный зверолов пред Господом Богом, потому и говорится: сильный зверолов, как Нимрод, пред Господом Богом. ");
INSERT INTO russyn_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Царство его вначале составляли: Вавилон, Эрех, Аккад и Халне в земле Сеннаар. ");
INSERT INTO russyn_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Из сей земли вышел Ассур и построил Ниневию, Реховоф-ир, Калах ");
INSERT INTO russyn_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","и Ресен между Ниневиею и между Калахом; это город великий. ");
INSERT INTO russyn_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","От Мицраима произошли Лудим, Анамим, Легавим, Нафтухим, ");
INSERT INTO russyn_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Патрусим, Каслухим, откуда вышли Филистимляне, и Кафторим. ");
INSERT INTO russyn_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","От Ханаана родились: Сидон, первенец его, Хет, ");
INSERT INTO russyn_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Иевусей, Аморрей, Гергесей, ");
INSERT INTO russyn_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Евей, Аркей, Синей, ");
INSERT INTO russyn_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Арвадей, Цемарей и Химафей. Впоследствии племена Ханаанские рассеялись, ");
INSERT INTO russyn_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","и были пределы Хананеев от Сидона к Герару до Газы, отсюда к Содому, Гоморре, Адме и Цевоиму до Лаши. ");
INSERT INTO russyn_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Это сыны Хамовы, по племенам их, по языкам их, в землях их, в народах их. ");
INSERT INTO russyn_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Были дети и у Сима, отца всех сынов Еверовых, старшего брата Иафетова. ");
INSERT INTO russyn_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Сыны Сима: Елам, Ассур, Арфаксад, Луд, Арам и Каинан. ");
INSERT INTO russyn_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Сыны Арама: Уц, Хул, Гефер и Маш. ");
INSERT INTO russyn_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Арфаксад родил Каинана, Каинан родил Салу, Сала родил Евера. ");
INSERT INTO russyn_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","У Евера родились два сына; имя одному: Фалек, потому что во дни его земля разделена; имя брату его: Иоктан. ");
INSERT INTO russyn_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Иоктан родил Алмодада, Шалефа, Хацармавефа, Иераха, ");
INSERT INTO russyn_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Гадорама, Узала, Диклу, ");
INSERT INTO russyn_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Овала, Авимаила, Шеву, ");
INSERT INTO russyn_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Офира, Хавилу и Иовава. Все эти сыновья Иоктана. ");
INSERT INTO russyn_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Поселения их были от Меши до Сефара, горы восточной. ");
INSERT INTO russyn_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Это сыновья Симовы по племенам их, по языкам их, в землях их, по народам их. ");
INSERT INTO russyn_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Вот племена сынов Ноевых, по родословию их, в народах их. От них распространились народы на земле после потопа ");
INSERT INTO russyn_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","На всей земле был один язык и одно наречие. ");
INSERT INTO russyn_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Двинувшись с востока, они нашли в земле Сеннаар равнину и поселились там. ");
INSERT INTO russyn_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","И сказали друг другу: наделаем кирпичей и обожжем огнем. И стали у них кирпичи вместо камней, а земляная смола вместо извести. ");
INSERT INTO russyn_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","И сказали они: построим себе город и башню, высотою до небес, и сделаем себе имя, прежде нежели рассеемся по лицу всей земли. ");
INSERT INTO russyn_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","И сошел Господь посмотреть город и башню, которые строили сыны человеческие. ");
INSERT INTO russyn_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","И сказал Господь: вот, один народ, и один у всех язык; и вот что начали они делать, и не отстанут они от того, что задумали делать; ");
INSERT INTO russyn_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","сойдем же и смешаем там язык их, так чтобы один не понимал речи другого. ");
INSERT INTO russyn_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","И рассеял их Господь оттуда по всей земле; и они перестали строить город и башню. ");
INSERT INTO russyn_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Посему дано ему имя: Вавилон, ибо там смешал Господь язык всей земли, и оттуда рассеял их Господь по всей земле. ");
INSERT INTO russyn_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Вот родословие Сима: Сим был ста лет и родил Арфаксада, чрез два года после потопа; ");
INSERT INTO russyn_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","по рождении Арфаксада Сим жил пятьсот лет и родил сынов и дочерей и умер. ");
INSERT INTO russyn_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Арфаксад жил тридцать пять лет и родил Каинана. По рождении Каинана Арфаксад жил триста тридцать лет и родил сынов и дочерей и умер. Каинан жил сто тридцать лет, и родил Салу. ");
INSERT INTO russyn_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","По рождении Салы Арфаксад Каинан жил четыреста три года и родил сынов и дочерей и умер. ");
INSERT INTO russyn_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Сала жил тридцать лет и родил Евера. ");
INSERT INTO russyn_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","По рождении Евера Сала жил четыреста три года и родил сынов и дочерей и умер. ");
INSERT INTO russyn_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Евер жил тридцать четыре года и родил Фалека. ");
INSERT INTO russyn_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","По рождении Фалека Евер жил четыреста тридцать лет и родил сынов и дочерей и умер. ");
INSERT INTO russyn_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Фалек жил тридцать лет и родил Рагава. ");
INSERT INTO russyn_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","По рождении Рагава Фалек жил двести девять лет и родил сынов и дочерей и умер. ");
INSERT INTO russyn_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Рагав жил тридцать два года и родил Серуха. ");
INSERT INTO russyn_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","По рождении Серуха Рагав жил двести семь лет и родил сынов и дочерей и умер. ");
INSERT INTO russyn_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Серух жил тридцать лет и родил Нахора. ");
INSERT INTO russyn_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","По рождении Нахора Серух жил двести лет и родил сынов и дочерей и умер. ");
INSERT INTO russyn_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Нахор жил двадцать девять лет и родил Фарру. ");
INSERT INTO russyn_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","По рождении Фарры Нахор жил сто девятнадцать лет и родил сынов и дочерей и умер. ");
INSERT INTO russyn_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Фарра жил семьдесят лет и родил Аврама, Нахора и Арана. ");
INSERT INTO russyn_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Вот родословие Фарры: Фарра родил Аврама, Нахора и Арана. Аран родил Лота. ");
INSERT INTO russyn_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","И умер Аран при Фарре, отце своем, в земле рождения своего, в Уре Халдейском. ");
INSERT INTO russyn_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Аврам и Нахор взяли себе жен; имя жены Аврамовой: Сара; имя жены Нахоровой: Милка, дочь Арана, отца Милки и отца Иски. ");
INSERT INTO russyn_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","И Сара была неплодна и бездетна. ");
INSERT INTO russyn_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","И взял Фарра Аврама, сына своего, и Лота, сына Аранова, внука своего, и Сару, невестку свою, жену Аврама, сына своего, и вышел с ними из Ура Халдейского, чтобы идти в землю Ханаанскую; но, дойдя до Харрана, они остановились там. ");
INSERT INTO russyn_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","И было дней жизни Фарры в Харранской земле двести пять лет, и умер Фарра в Харране. ");
INSERT INTO russyn_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","И сказал Господь Авраму: пойди из земли твоей, от родства твоего и из дома отца твоего и иди в землю, которую Я укажу тебе; ");
INSERT INTO russyn_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","и Я произведу от тебя великий народ, и благословлю тебя, и возвеличу имя твое, и будешь ты в благословение; ");
INSERT INTO russyn_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Я благословлю благословляющих тебя, и злословящих тебя прокляну; и благословятся в тебе все племена земные. ");
INSERT INTO russyn_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","И пошел Аврам, как сказал ему Господь; и с ним пошел Лот. Аврам был семидесяти пяти лет, когда вышел из Харрана. ");
INSERT INTO russyn_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","И взял Аврам с собою Сару, жену свою, Лота, сына брата своего, и все имение, которое они приобрели, и всех людей, которых они имели в Харране; и вышли, чтобы идти в землю Ханаанскую; и пришли в землю Ханаанскую. ");
INSERT INTO russyn_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","И прошел Аврам по земле сей по длине ее до места Сихема, до дубравы Море. В этой земле тогда жили Хананеи. ");
INSERT INTO russyn_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","И явился Господь Авраму и сказал ему: потомству твоему отдам Я землю сию. И создал там Аврам жертвенник Господу, Который явился ему. ");
INSERT INTO russyn_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Оттуда двинулся он к горе, на восток от Вефиля; и поставил шатер свой так, что от него Вефиль был на запад, а Гай на восток; и создал там жертвенник Господу и призвал имя Господа явившегося ему. ");
INSERT INTO russyn_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","И поднялся Аврам и продолжал идти к югу. ");
INSERT INTO russyn_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","И был голод в той земле. И сошел Аврам в Египет, пожить там, потому что усилился голод в земле той. ");
INSERT INTO russyn_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Когда же он приближался к Египту, то сказал Саре, жене своей: вот, я знаю, что ты женщина, прекрасная видом; ");
INSERT INTO russyn_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","и когда Египтяне увидят тебя, то скажут: это жена его; и убьют меня, а тебя оставят в живых; ");
INSERT INTO russyn_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","скажи же, что ты мне сестра, дабы мне хорошо было ради тебя, и дабы жива была душа моя чрез тебя. ");
INSERT INTO russyn_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","И было, когда пришел Аврам в Египет, Египтяне увидели, что она женщина весьма красивая; ");
INSERT INTO russyn_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","увидели ее и вельможи фараоновы и похвалили ее фараону; и взята была она в дом фараонов. ");
INSERT INTO russyn_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","И Авраму хорошо было ради ее; и был у него мелкий и крупный скот и ослы, и рабы и рабыни, и лошаки и верблюды. ");
INSERT INTO russyn_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Но Господь поразил тяжкими ударами фараона и дом его за Сару, жену Аврамову. ");
INSERT INTO russyn_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","И призвал фараон Аврама и сказал: что ты это сделал со мною? для чего не сказал мне, что она жена твоя? ");
INSERT INTO russyn_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","для чего ты сказал: она сестра моя? и я взял было ее себе в жену. И теперь вот жена твоя; возьми ее и пойди. ");
INSERT INTO russyn_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","И дал о нем фараон повеление людям, и проводили его, и жену его, и все, что у него было, и Лота с ним. ");
INSERT INTO russyn_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","И поднялся Аврам из Египта, сам и жена его, и все, что у него было, и Лот с ним, на юг. ");
INSERT INTO russyn_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","И был Аврам очень богат скотом, и серебром, и золотом. ");
INSERT INTO russyn_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","И продолжал он переходы свои от юга до Вефиля, до места, где прежде был шатер его между Вефилем и между Гаем, ");
INSERT INTO russyn_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","до места жертвенника, который он сделал там вначале; и там призвал Аврам имя Господа. ");
INSERT INTO russyn_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","И у Лота, который ходил с Аврамом, также был мелкий и крупный скот и шатры. ");
INSERT INTO russyn_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","И непоместительна была земля для них, чтобы жить вместе, ибо имущество их было так велико, что они не могли жить вместе. ");
INSERT INTO russyn_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","И был спор между пастухами скота Аврамова и между пастухами скота Лотова; и Хананеи и Ферезеи жили тогда в той земле. ");
INSERT INTO russyn_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","И сказал Аврам Лоту: да не будет раздора между мною и тобою, и между пастухами моими и пастухами твоими, ибо мы родственники; ");
INSERT INTO russyn_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","не вся ли земля пред тобою? отделись же от меня: если ты налево, то я направо; а если ты направо, то я налево. ");
INSERT INTO russyn_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Лот возвел очи свои и увидел всю окрестность Иорданскую, что она, прежде нежели истребил Господь Содом и Гоморру, вся до Сигора орошалась водою, как сад Господень, как земля Египетская; ");
INSERT INTO russyn_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","и избрал себе Лот всю окрестность Иорданскую; и двинулся Лот к востоку. И отделились они друг от друга. ");
INSERT INTO russyn_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Аврам стал жить на земле Ханаанской; а Лот стал жить в городах окрестности и раскинул шатры до Содома. ");
INSERT INTO russyn_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Жители же Содомские были злы и весьма грешны пред Господом. ");
INSERT INTO russyn_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","И сказал Господь Авраму, после того как Лот отделился от него: возведи очи твои и с места, на котором ты теперь, посмотри к северу и к югу, и к востоку и к западу; ");
INSERT INTO russyn_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","ибо всю землю, которую ты видишь, тебе дам Я и потомству твоему навеки, ");
INSERT INTO russyn_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","и сделаю потомство твое, как песок земной; если кто может сосчитать песок земной, то и потомство твое сочтено будет; ");
INSERT INTO russyn_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","встань, пройди по земле сей в долготу и в широту ее, ибо Я тебе дам ее и потомству твоему навсегда. ");
INSERT INTO russyn_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","И двинул Аврам шатер, и пошел, и поселился у дубравы Мамре, что в Хевроне; и создал там жертвенник Господу. ");
INSERT INTO russyn_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","И было во дни Амрафела, царя Сеннаарского, Ариоха, царя Елласарского, Кедорлаомера, царя Еламского, и Фидала, царя Гоимского, ");
INSERT INTO russyn_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","пошли они войною против Беры, царя Содомского, против Бирши, царя Гоморрского, Шинава, царя Адмы, Шемевера, царя Севоимского, и против царя Белы, которая есть Сигор. ");
INSERT INTO russyn_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Все сии соединились в долине Сиддим, где ныне море Соленое. ");
INSERT INTO russyn_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Двенадцать лет были они в порабощении у Кедорлаомера, а в тринадцатом году возмутились. ");
INSERT INTO russyn_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","В четырнадцатом году пришел Кедорлаомер и цари, которые с ним, и поразили Рефаимов в Аштероф-Карнаиме, Зузимов в Гаме, Эмимов в Шаве-Кириафаиме, ");
INSERT INTO russyn_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","и Хорреев в горе их Сеире, до Эл-Фарана, что при пустыне. ");
INSERT INTO russyn_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","И возвратившись оттуда, они пришли к источнику Мишпат, который есть Кадес, и поразили всю страну Амаликитян, и также Аморреев, живущих в Хацацон-Фамаре. ");
INSERT INTO russyn_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","И вышли царь Содомский, царь Гоморрский, царь Адмы, царь Севоимский и царь Белы, которая есть Сигор; и вступили в сражение с ними в долине Сиддим, ");
INSERT INTO russyn_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","с Кедорлаомером, царем Еламским, Фидалом, царем Гоимским, Амрафелом, царем Сеннаарским, Ариохом, царем Елласарским, - четыре царя против пяти. ");
INSERT INTO russyn_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","В долине же Сиддим было много смоляных ям. И цари Содомский и Гоморрский, обратившись в бегство, упали в них, а остальные убежали в горы. ");
INSERT INTO russyn_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Победители взяли все имущество Содома и Гоморры и весь запас их и ушли. ");
INSERT INTO russyn_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","И взяли Лота, племянника Аврамова, жившего в Содоме, и имущество его и ушли. ");
INSERT INTO russyn_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","И пришел один из уцелевших и известил Аврама Еврея, жившего тогда у дубравы Мамре, Аморреянина, брата Эшколу и брата Анеру, которые были союзники Аврамовы. ");
INSERT INTO russyn_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Аврам, услышав, что Лот сродник его взят в плен, вооружил рабов своих, рожденных в доме его, триста восемнадцать, и преследовал неприятелей до Дана; ");
INSERT INTO russyn_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","и, разделившись, напал на них ночью, сам и рабы его, и поразил их, и преследовал их до Ховы, что по левую сторону Дамаска; ");
INSERT INTO russyn_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","и возвратил все имущество и Лота, сродника своего, и имущество его возвратил, также и женщин и народ. ");
INSERT INTO russyn_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Когда он возвращался после поражения Кедорлаомера и царей, бывших с ним, царь Содомский вышел ему навстречу в долину Шаве, что ныне долина царская; ");
INSERT INTO russyn_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","и Мелхиседек, царь Салимский, вынес хлеб и вино, он был священник Бога Всевышнего,- ");
INSERT INTO russyn_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","и благословил его, и сказал: благословен Аврам от Бога Всевышнего, Владыки неба и земли; ");
INSERT INTO russyn_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","и благословен Бог Всевышний, Который предал врагов твоих в руки твои. Аврам дал ему десятую часть из всего. ");
INSERT INTO russyn_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","И сказал царь Содомский Авраму: отдай мне людей, а имение возьми себе. ");
INSERT INTO russyn_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Но Аврам сказал царю Содомскому: поднимаю руку мою к Господу Богу Всевышнему, Владыке неба и земли, ");
INSERT INTO russyn_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","что даже нитки и ремня от обуви не возьму из всего твоего, чтобы ты не сказал: я обогатил Аврама; ");
INSERT INTO russyn_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","кроме того, что съели отроки, и кроме доли, принадлежащей людям, которые ходили со мною; Анер, Эшкол и Мамрий пусть возьмут свою долю. ");
INSERT INTO russyn_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","После сих происшествий было слово Господа к Авраму в видении ночью, и сказано: не бойся, Аврам; Я твой щит; награда твоя будет весьма велика. ");
INSERT INTO russyn_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Аврам сказал: Владыка Господи! что Ты дашь мне? я остаюсь бездетным; распорядитель в доме моем этот Елиезер из Дамаска. ");
INSERT INTO russyn_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","И сказал Аврам: вот, Ты не дал мне потомства, и вот, домочадец мой наследник мой. ");
INSERT INTO russyn_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","И было слово Господа к нему, и сказано: не будет он твоим наследником, но тот, кто произойдет из чресл твоих, будет твоим наследником. ");
INSERT INTO russyn_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","И вывел его вон и сказал ему: посмотри на небо и сосчитай звезды, если ты можешь счесть их. И сказал ему: столько будет у тебя потомков. ");
INSERT INTO russyn_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Аврам поверил Господу, и Он вменил ему это в праведность. ");
INSERT INTO russyn_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","И сказал ему: Я Господь, Который вывел тебя из Ура Халдейского, чтобы дать тебе землю сию во владение. ");
INSERT INTO russyn_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Он сказал: Владыка Господи! по чему мне узнать, что я буду владеть ею? ");
INSERT INTO russyn_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Господь сказал ему: возьми Мне трехлетнюю телицу, трехлетнюю козу, трехлетнего овна, горлицу и молодого голубя. ");
INSERT INTO russyn_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Он взял всех их, рассек их пополам и положил одну часть против другой; только птиц не рассек. ");
INSERT INTO russyn_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","И налетели на трупы хищные птицы; но Аврам отгонял их. ");
INSERT INTO russyn_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","При захождении солнца крепкий сон напал на Аврама, и вот, напал на него ужас и мрак великий. ");
INSERT INTO russyn_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","И сказал Господь Авраму: знай, что потомки твои будут пришельцами в земле не своей, и поработят их, и будут угнетать их четыреста лет, ");
INSERT INTO russyn_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","но Я произведу суд над народом, у которого они будут в порабощении; после сего они выйдут сюда с большим имуществом, ");
INSERT INTO russyn_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","а ты отойдешь к отцам твоим в мире и будешь погребен в старости доброй; ");
INSERT INTO russyn_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","в четвертом роде возвратятся они сюда: ибо мера беззаконий Аморреев доселе еще не наполнилась. ");
INSERT INTO russyn_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Когда зашло солнце и наступила тьма, вот, дым как бы из печи и пламя огня прошли между рассеченными животными. ");
INSERT INTO russyn_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","В этот день заключил Господь завет с Аврамом, сказав: потомству твоему даю Я землю сию, от реки Египетской до великой реки, реки Евфрата: ");
INSERT INTO russyn_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Кенеев, Кенезеев, Кедмонеев, ");
INSERT INTO russyn_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Хеттеев, Ферезеев, Рефаимов, ");
INSERT INTO russyn_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Аморреев, Хананеев, Евеев, Гергесеев и Иевусеев. ");
INSERT INTO russyn_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Но Сара, жена Аврамова, не рождала ему. У ней была служанка Египтянка, именем Агарь. ");
INSERT INTO russyn_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","И сказала Сара Авраму: вот, Господь заключил чрево мое, чтобы мне не рождать; войди же к служанке моей: может быть, я буду иметь детей от нее. Аврам послушался слов Сары. ");
INSERT INTO russyn_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","И взяла Сара, жена Аврамова, служанку свою, Египтянку Агарь, по истечении десяти лет пребывания Аврамова в земле Ханаанской, и дала ее Авраму, мужу своему, в жену. ");
INSERT INTO russyn_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Он вошел к Агари, и она зачала. Увидев же, что зачала, она стала презирать госпожу свою. ");
INSERT INTO russyn_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","И сказала Сара Авраму: в обиде моей ты виновен; я отдала служанку мою в недро твое; а она, увидев, что зачала, стала презирать меня; Господь пусть будет судьею между мною и между тобою. ");
INSERT INTO russyn_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Аврам сказал Саре: вот, служанка твоя в твоих руках; делай с нею, что тебе угодно. И Сара стала притеснять ее, и она убежала от нее. ");
INSERT INTO russyn_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","И нашел ее Ангел Господень у источника воды в пустыне, у источника на дороге к Суру. ");
INSERT INTO russyn_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","И сказал ей Ангел Господень: Агарь, служанка Сарина! откуда ты пришла и куда идешь? Она сказала: я бегу от лица Сары, госпожи моей. ");
INSERT INTO russyn_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ангел Господень сказал ей: возвратись к госпоже своей и покорись ей. ");
INSERT INTO russyn_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","И сказал ей Ангел Господень: умножая умножу потомство твое, так что нельзя будет и счесть его от множества. ");
INSERT INTO russyn_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","И еще сказал ей Ангел Господень: вот, ты беременна, и родишь сына, и наречешь ему имя Измаил, ибо услышал Господь страдание твое; ");
INSERT INTO russyn_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","он будет между людьми, как дикий осел; руки его на всех, и руки всех на него; жить будет он пред лицем всех братьев своих. ");
INSERT INTO russyn_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","И нарекла Агарь Господа, Который говорил к ней, сим именем: Ты Бог видящий меня. Ибо сказала она: точно я видела здесь в след видящего меня. ");
INSERT INTO russyn_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Посему источник тот называется: Беэр-лахай-рои. Он находится между Кадесом и между Баредом. ");
INSERT INTO russyn_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Агарь родила Авраму сына; и нарек Аврам имя сыну своему, рожденному от Агари: Измаил. ");
INSERT INTO russyn_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Аврам был восьмидесяти шести лет, когда Агарь родила Авраму Измаила. ");
INSERT INTO russyn_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Аврам был девяноста девяти лет, и Господь явился Авраму и сказал ему: Я Бог Всемогущий; ходи предо Мною и будь непорочен; ");
INSERT INTO russyn_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","и поставлю завет Мой между Мною и тобою, и весьма, весьма размножу тебя. ");
INSERT INTO russyn_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","И пал Аврам на лице свое. Бог продолжал говорить с ним и сказал: ");
INSERT INTO russyn_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Я - вот завет Мой с тобою: ты будешь отцом множества народов, ");
INSERT INTO russyn_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","и не будешь ты больше называться Аврамом, но будет тебе имя: Авраам, ибо Я сделаю тебя отцом множества народов; ");
INSERT INTO russyn_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","и весьма, весьма распложу тебя, и произведу от тебя народы, и цари произойдут от тебя; ");
INSERT INTO russyn_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","и поставлю завет Мой между Мною и тобою и между потомками твоими после тебя в роды их, завет вечный в том, что Я буду Богом твоим и потомков твоих после тебя; ");
INSERT INTO russyn_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","и дам тебе и потомкам твоим после тебя землю, по которой ты странствуешь, всю землю Ханаанскую, во владение вечное; и буду им Богом. ");
INSERT INTO russyn_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","И сказал Бог Аврааму: ты же соблюди завет Мой, ты и потомки твои после тебя в роды их. ");
INSERT INTO russyn_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Сей есть завет Мой, который вы должны соблюдать между Мною и между вами и между потомками твоими после тебя в роды их: да будет у вас обрезан весь мужеский пол; ");
INSERT INTO russyn_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","обрезывайте крайнюю плоть вашу: и сие будет знамением завета между Мною и вами. ");
INSERT INTO russyn_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Восьми дней от рождения да будет обрезан у вас в роды ваши всякий младенец мужеского пола, рожденный в доме и купленный за серебро у какого-нибудь иноплеменника, который не от твоего семени. ");
INSERT INTO russyn_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Непременно да будет обрезан рожденный в доме твоем и купленный за серебро твое, и будет завет Мой на теле вашем заветом вечным. ");
INSERT INTO russyn_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Необрезанный же мужеского пола, который не обрежет крайней плоти своей в восьмой день, истребится душа та из народа своего, ибо он нарушил завет Мой. ");
INSERT INTO russyn_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","И сказал Бог Аврааму: Сару, жену твою, не называй Сарою, но да будет имя ей: Сарра; ");
INSERT INTO russyn_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Я благословлю ее и дам тебе от нее сына; благословлю ее, и произойдут от нее народы, и цари народов произойдут от нее. ");
INSERT INTO russyn_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","И пал Авраам на лице свое, и рассмеялся, и сказал сам в себе: неужели от столетнего будет сын? и Сарра, девяностолетняя, неужели родит? ");
INSERT INTO russyn_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","И сказал Авраам Богу: о, хотя бы Измаил был жив пред лицем Твоим! ");
INSERT INTO russyn_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Бог же сказал Аврааму: именно Сарра, жена твоя, родит тебе сына, и ты наречешь ему имя: Исаак; и поставлю завет Мой с ним заветом вечным в том, что Я буду Богом ему и потомству его после него. ");
INSERT INTO russyn_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","И о Измаиле Я услышал тебя: вот, Я благословлю его, и возращу его, и весьма, весьма размножу; двенадцать князей родятся от него; и Я произведу от него великий народ. ");
INSERT INTO russyn_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Но завет Мой поставлю с Исааком, которого родит тебе Сарра в сие самое время на другой год. ");
INSERT INTO russyn_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","И Бог перестал говорить с Авраамом и восшел от него. ");
INSERT INTO russyn_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","И взял Авраам Измаила, сына своего, и всех рожденных в доме своем и всех купленных за серебро свое, весь мужеский пол людей дома Авраамова; и обрезал крайнюю плоть их в тот самый день, как сказал ему Бог. ");
INSERT INTO russyn_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Авраам был девяноста девяти лет, когда была обрезана крайняя плоть его. ");
INSERT INTO russyn_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","А Измаил, сын его, был тринадцати лет, когда была обрезана крайняя плоть его. ");
INSERT INTO russyn_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","В тот же самый день обрезаны были Авраам и Измаил, сын его, ");
INSERT INTO russyn_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","и с ним обрезан был весь мужеский пол дома его, рожденные в доме и купленные за серебро у иноплеменников. ");
INSERT INTO russyn_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","И явился ему Господь у дубравы Мамре, когда он сидел при входе в шатер свой, во время зноя дневного. ");
INSERT INTO russyn_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Он возвел очи свои и взглянул, и вот, три мужа стоят против него. Увидев, он побежал навстречу им от входа в шатер свой и поклонился до земли, ");
INSERT INTO russyn_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","и сказал: Владыка! если я обрел благоволение пред очами Твоими, не пройди мимо раба Твоего; ");
INSERT INTO russyn_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","и принесут немного воды, и омоют ноги ваши; и отдохните под сим деревом, ");
INSERT INTO russyn_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","а я принесу хлеба, и вы подкрепите сердца ваши; потом пойдите в путь свой; так как вы идете мимо раба вашего. Они сказали: сделай так, как говоришь. ");
INSERT INTO russyn_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","И поспешил Авраам в шатер к Сарре и сказал ей: поскорее замеси три саты лучшей муки и сделай пресные хлебы. ");
INSERT INTO russyn_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","И побежал Авраам к стаду, и взял теленка нежного и хорошего, и дал отроку, и тот поспешил приготовить его. ");
INSERT INTO russyn_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","И взял масла и молока и теленка приготовленного, и поставил перед ними, а сам стоял подле них под деревом. И они ели. ");
INSERT INTO russyn_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","И сказали ему: где Сарра, жена твоя? Он отвечал: здесь, в шатре. ");
INSERT INTO russyn_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","И сказал один из них: Я опять буду у тебя в это же время в следующем году, и будет сын у Сарры, жены твоей. А Сарра слушала у входа в шатер, сзади его. ");
INSERT INTO russyn_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Авраам же и Сарра были стары и в летах преклонных, и обыкновенное у женщин у Сарры прекратилось. ");
INSERT INTO russyn_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Сарра внутренно рассмеялась, сказав: мне ли, когда я состарилась, иметь сие утешение? и господин мой стар. ");
INSERT INTO russyn_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","И сказал Господь Аврааму: отчего это сама в себе рассмеялась Сарра, сказав: “неужели я действительно могу родить, когда я состарилась”? ");
INSERT INTO russyn_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Есть ли что трудное для Господа? В назначенный срок буду Я у тебя в следующем году, и будет у Сарры сын. ");
INSERT INTO russyn_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Сарра же не призналась, а сказала: я не смеялась. Ибо она испугалась. Но Он сказал ей: нет, ты рассмеялась. ");
INSERT INTO russyn_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","И встали те мужи и оттуда отправились к Содому и Гоморре; Авраам же пошел с ними, проводить их. ");
INSERT INTO russyn_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","И сказал Господь: утаю ли Я от Авраама раба Моего, что хочу делать! ");
INSERT INTO russyn_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","От Авраама точно произойдет народ великий и сильный, и благословятся в нем все народы земли, ");
INSERT INTO russyn_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","ибо Я избрал его для того, чтобы он заповедал сынам своим и дому своему после себя, ходить путем Господним, творя правду и суд; и исполнит Господь над Авраамом все, что сказал о нем. ");
INSERT INTO russyn_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","И сказал Господь: вопль Содомский и Гоморрский, велик он, и грех их, тяжел он весьма; ");
INSERT INTO russyn_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","сойду и посмотрю, точно ли они поступают так, каков вопль на них, восходящий ко Мне, или нет; узнаю. ");
INSERT INTO russyn_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","И обратились мужи оттуда и пошли в Содом; Авраам же еще стоял пред лицем Господа. ");
INSERT INTO russyn_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","И подошел Авраам и сказал: неужели Ты погубишь праведного с нечестивым и с праведником будет то же, что с нечестивым? ");
INSERT INTO russyn_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","может быть, есть в этом городе пятьдесят праведников? неужели Ты погубишь, и не пощадишь всего места сего ради пятидесяти праведников, если они находятся в нем? ");
INSERT INTO russyn_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","не может быть, чтобы Ты поступил так, чтобы Ты погубил праведного с нечестивым, чтобы то же было с праведником, что с нечестивым; не может быть от Тебя! Судия всей земли поступит ли неправосудно? ");
INSERT INTO russyn_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Господь сказал: если Я найду в городе Содоме пятьдесят праведников, то Я ради них пощажу весь город и все место сие. ");
INSERT INTO russyn_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Авраам сказал в ответ: вот, я решился говорить Владыке, я, прах и пепел: ");
INSERT INTO russyn_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","может быть, до пятидесяти праведников недостанет пяти, неужели за недостатком пяти Ты истребишь весь город? Он сказал: не истреблю, если найду там сорок пять. ");
INSERT INTO russyn_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Авраам продолжал говорить с Ним и сказал: может быть, найдется там сорок? Он сказал: не сделаю того и ради сорока. ");
INSERT INTO russyn_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","И сказал Авраам: да не прогневается Владыка, что я буду говорить: может быть, найдется там тридцать? Он сказал: не сделаю, если найдется там тридцать. ");
INSERT INTO russyn_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Авраам сказал: вот, я решился говорить Владыке: может быть, найдется там двадцать? Он сказал: не истреблю ради двадцати. ");
INSERT INTO russyn_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Авраам сказал: да не прогневается Владыка, что я скажу еще однажды: может быть, найдется там десять? Он сказал: не истреблю ради десяти. ");
INSERT INTO russyn_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","И пошел Господь, перестав говорить с Авраамом; Авраам же возвратился в свое место. ");
INSERT INTO russyn_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","И пришли те два Ангела в Содом вечером, когда Лот сидел у ворот Содома. Лот увидел, и встал, чтобы встретить их, и поклонился лицем до земли ");
INSERT INTO russyn_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","и сказал: государи мои! зайдите в дом раба вашего и ночуйте, и умойте ноги ваши, и встаньте поутру и пойдете в путь свой. Но они сказали: нет, мы ночуем на улице. ");
INSERT INTO russyn_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Он же сильно упрашивал их; и они пошли к нему и пришли в дом его. Он сделал им угощение и испек пресные хлебы, и они ели. ");
INSERT INTO russyn_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Еще не легли они спать, как городские жители, Содомляне, от молодого до старого, весь народ со всех концов города, окружили дом: ");
INSERT INTO russyn_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","и вызвали Лота и говорили ему: где люди, пришедшие к тебе на ночь? выведи их к нам; мы познаем их. ");
INSERT INTO russyn_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Лот вышел к ним ко входу, и запер за собою дверь, ");
INSERT INTO russyn_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","и сказал им: братья мои, не делайте зла; ");
INSERT INTO russyn_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","вот у меня две дочери, которые не познали мужа; лучше я выведу их к вам, делайте с ними, что вам угодно, только людям сим не делайте ничего, так как они пришли под кров дома моего. ");
INSERT INTO russyn_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Но они сказали ему: пойди сюда. И сказали: вот пришлец, и хочет судить? теперь мы хуже поступим с тобою, нежели с ними. И очень приступали к человеку сему, к Лоту, и подошли, чтобы выломать дверь. ");
INSERT INTO russyn_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Тогда мужи те простерли руки свои и ввели Лота к себе в дом, и дверь дома заперли; ");
INSERT INTO russyn_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","а людей, бывших при входе в дом, поразили слепотою, от малого до большого, так что они измучились, искав входа. ");
INSERT INTO russyn_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Сказали мужи те Лоту: кто у тебя есть еще здесь? зять ли, сыновья ли твои, дочери ли твои, и кто бы ни был у тебя в городе, всех выведи из сего места, ");
INSERT INTO russyn_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","ибо мы истребим сие место, потому что велик вопль на жителей его к Господу, и Господь послал нас истребить его. ");
INSERT INTO russyn_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","И вышел Лот, и говорил с зятьями своими, которые брали за себя дочерей его, и сказал: встаньте, выйдите из сего места, ибо Господь истребит сей город. Но зятьям его показалось, что он шутит. ");
INSERT INTO russyn_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Когда взошла заря, Ангелы начали торопить Лота, говоря: встань, возьми жену твою и двух дочерей твоих, которые у тебя, чтобы не погибнуть тебе за беззакония города. ");
INSERT INTO russyn_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","И как он медлил, то мужи те Ангелы, по милости к нему Господней, взяли за руку его и жену его, и двух дочерей его, и вывели его и поставили его вне города. ");
INSERT INTO russyn_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Когда же вывели их вон, то один из них сказал: спасай душу свою; не оглядывайся назад и нигде не останавливайся в окрестности сей; спасайся на гору, чтобы тебе не погибнуть. ");
INSERT INTO russyn_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Но Лот сказал им: нет, Владыка! ");
INSERT INTO russyn_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","вот, раб Твой обрел благоволение пред очами Твоими, и велика милость Твоя, которую Ты сделал со мною, что спас жизнь мою; но я не могу спасаться на гору, чтоб не застигла меня беда и мне не умереть; ");
INSERT INTO russyn_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","вот, ближе бежать в сей город, он же мал; побегу я туда, - он же мал; и сохранится жизнь моя ради Тебя. ");
INSERT INTO russyn_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","И сказал ему: вот, в угодность тебе Я сделаю и это: не ниспровергну города, о котором ты говоришь; ");
INSERT INTO russyn_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","поспешай, спасайся туда, ибо Я не могу сделать дела, доколе ты не придешь туда. Потому и назван город сей: Сигор. ");
INSERT INTO russyn_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Солнце взошло над землею, и Лот пришел в Сигор. ");
INSERT INTO russyn_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","И пролил Господь на Содом и Гоморру дождем серу и огонь от Господа с неба, ");
INSERT INTO russyn_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","и ниспроверг города сии, и всю окрестность сию, и всех жителей городов сих, и все произрастания земли. ");
INSERT INTO russyn_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Жена же Лотова оглянулась позади его, и стала соляным столпом. ");
INSERT INTO russyn_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","И встал Авраам рано утром и пошел на место, где стоял пред лицем Господа, ");
INSERT INTO russyn_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","и посмотрел к Содому и Гоморре и на все пространство окрестности и увидел: вот, дым поднимается с земли, как дым из печи. ");
INSERT INTO russyn_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","И было, когда Бог истреблял все города окрестности сей, вспомнил Бог об Аврааме и выслал Лота из среды истребления, когда ниспровергал города, в которых жил Лот. ");
INSERT INTO russyn_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","И вышел Лот из Сигора и стал жить в горе, и с ним две дочери его, ибо он боялся жить в Сигоре. И жил в пещере, и с ним две дочери его. ");
INSERT INTO russyn_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","И сказала старшая младшей: отец наш стар, и нет человека на земле, который вошел бы к нам по обычаю всей земли; ");
INSERT INTO russyn_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","итак напоим отца нашего вином, и переспим с ним, и восставим от отца нашего племя. ");
INSERT INTO russyn_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","И напоили отца своего вином в ту ночь; и вошла старшая и спала с отцом своим в ту ночь; а он не знал, когда она легла и когда встала. ");
INSERT INTO russyn_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","На другой день старшая сказала младшей: вот, я спала вчера с отцом моим; напоим его вином и в эту ночь; и ты войди, спи с ним, и восставим от отца нашего племя. ");
INSERT INTO russyn_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","И напоили отца своего вином и в эту ночь; и вошла младшая и спала с ним; и он не знал, когда она легла и когда встала. ");
INSERT INTO russyn_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","И сделались обе дочери Лотовы беременными от отца своего, ");
INSERT INTO russyn_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","и родила старшая сына, и нарекла ему имя Моав, говоря: он от отца моего. Он отец Моавитян доныне. ");
INSERT INTO russyn_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","И младшая также родила сына, и нарекла ему имя: Бен-Амми говоря: он сын рода моего. Он отец Аммонитян доныне. ");
INSERT INTO russyn_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Авраам поднялся оттуда к югу и поселился между Кадесом и между Суром; и был на время в Гераре. ");
INSERT INTO russyn_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","И сказал Авраам о Сарре, жене своей: она сестра моя. Ибо он боялся сказать, что это жена его, чтобы жители города того не убили его за нее. И послал Авимелех, царь Герарский, и взял Сарру. ");
INSERT INTO russyn_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","И пришел Бог к Авимелеху ночью во сне и сказал ему: вот, ты умрешь за женщину, которую ты взял, ибо она имеет мужа. ");
INSERT INTO russyn_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Авимелех же не прикасался к ней и сказал: Владыка! неужели ты погубишь не знавший сего и невинный народ? ");
INSERT INTO russyn_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Не сам ли он сказал мне: она сестра моя? И она сама сказала: он брат мой. Я сделал это в простоте сердца моего и в чистоте рук моих. ");
INSERT INTO russyn_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","И сказал ему Бог во сне: и Я знаю, что ты сделал сие в простоте сердца твоего, и удержал тебя от греха предо Мною, потому и не допустил тебя прикоснуться к ней; ");
INSERT INTO russyn_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","теперь же возврати жену мужу, ибо он пророк и помолится о тебе, и ты будешь жив; а если не возвратишь, то знай, что непременно умрешь ты и все твои. ");
INSERT INTO russyn_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","И встал Авимелех утром рано, и призвал всех рабов своих, и пересказал все слова сии в уши их; и люди сии все весьма испугались. ");
INSERT INTO russyn_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","И призвал Авимелех Авраама и сказал ему: что ты с нами сделал? чем согрешил я против тебя, что ты навел было на меня и на царство мое великий грех? Ты сделал со мною дела, каких не делают. ");
INSERT INTO russyn_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","И сказал Авимелех Аврааму: что ты имел в виду, когда делал это дело? ");
INSERT INTO russyn_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Авраам сказал: я подумал, что нет на месте сем страха Божия, и убьют меня за жену мою; ");
INSERT INTO russyn_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","да она и подлинно сестра мне: она дочь отца моего, только не дочь матери моей; и сделалась моею женою; ");
INSERT INTO russyn_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","когда Бог повел меня странствовать из дома отца моего, то я сказал ей: сделай со мною сию милость, в какое ни придем мы место, везде говори обо мне: это брат мой. ");
INSERT INTO russyn_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","И взял Авимелех серебра тысячу сиклей и мелкого и крупного скота, и рабов и рабынь, и дал Аврааму; и возвратил ему Сарру, жену его. ");
INSERT INTO russyn_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","И сказал Авимелех Аврааму: вот, земля моя пред тобою; живи, где тебе угодно. ");
INSERT INTO russyn_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","И Сарре сказал: вот, я дал брату твоему тысячу сиклей серебра; вот, это тебе покрывало для очей пред всеми, которые с тобою, и пред всеми ты оправдана. ");
INSERT INTO russyn_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","И помолился Авраам Богу, и исцелил Бог Авимелеха, и жену его, и рабынь его, и они стали рождать; ");
INSERT INTO russyn_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","ибо заключил Господь всякое чрево в доме Авимелеха за Сарру, жену Авраамову. ");
INSERT INTO russyn_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","И призрел Господь на Сарру, как сказал; и сделал Господь Сарре, как говорил. ");
INSERT INTO russyn_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Сарра зачала и родила Аврааму сына в старости его во время, о котором говорил ему Бог; ");
INSERT INTO russyn_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","и нарек Авраам имя сыну своему, родившемуся у него, которого родила ему Сарра, Исаак; ");
INSERT INTO russyn_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","и обрезал Авраам Исаака, сына своего, в восьмой день, как заповедал ему Бог. ");
INSERT INTO russyn_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Авраам был ста лет, когда родился у него Исаак, сын его. ");
INSERT INTO russyn_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","И сказала Сарра: смех сделал мне Бог; кто ни услышит обо мне, рассмеется. ");
INSERT INTO russyn_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","И сказала: кто сказал бы Аврааму: Сарра будет кормить детей грудью? ибо в старости его я родила сына. ");
INSERT INTO russyn_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Дитя выросло и отнято от груди; и Авраам сделал большой пир в тот день, когда Исаак сын его отнят был от груди. ");
INSERT INTO russyn_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","И увидела Сарра, что сын Агари Египтянки, которого она родила Аврааму, насмехается над ее сыном, Исааком, ");
INSERT INTO russyn_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","и сказала Аврааму: выгони эту рабыню и сына ее, ибо не наследует сын рабыни сей с сыном моим Исааком. ");
INSERT INTO russyn_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","И показалось это Аврааму весьма неприятным ради сына его Измаила. ");
INSERT INTO russyn_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Но Бог сказал Аврааму: не огорчайся ради отрока и рабыни твоей; во всем, что скажет тебе Сарра, слушайся голоса ее, ибо в Исааке наречется тебе семя; ");
INSERT INTO russyn_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","и от сына рабыни Я произведу великий народ, потому что он семя твое. ");
INSERT INTO russyn_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Авраам встал рано утром, и взял хлеба и мех воды, и дал Агари, положив ей на плечи, и отрока, и отпустил ее. Она пошла, и заблудилась в пустыне Вирсавии; ");
INSERT INTO russyn_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","и не стало воды в мехе, и она оставила отрока под одним кустом ");
INSERT INTO russyn_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","и пошла, села вдали, в расстоянии на один выстрел из лука. Ибо она сказала: не хочу видеть смерти отрока. И она села поодаль против него, и подняла вопль, и плакала; ");
INSERT INTO russyn_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","и услышал Бог голос отрока оттуда, где он был; и Ангел Божий с неба воззвал к Агари и сказал ей: что с тобою, Агарь? не бойся; Бог услышал голос отрока оттуда, где он находится; ");
INSERT INTO russyn_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","встань, подними отрока и возьми его за руку, ибо Я произведу от него великий народ. ");
INSERT INTO russyn_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","И Бог открыл глаза ее, и она увидела колодезь с водою живою, и пошла, наполнила мех водою и напоила отрока. ");
INSERT INTO russyn_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","И Бог был с отроком; и он вырос, и стал жить в пустыне, и сделался стрелком из лука. ");
INSERT INTO russyn_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Он жил в пустыне Фаран; и мать его взяла ему жену из земли Египетской. ");
INSERT INTO russyn_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","И было в то время, Авимелех с Фихолом, военачальником своим, сказал Аврааму: с тобою Бог во всем, что ты ни делаешь; ");
INSERT INTO russyn_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","и теперь поклянись мне здесь Богом, что ты не обидишь ни меня, ни сына моего, ни внука моего; и как я хорошо поступал с тобою, так и ты будешь поступать со мною и землею, в которой ты гостишь. ");
INSERT INTO russyn_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","И сказал Авраам: я клянусь. ");
INSERT INTO russyn_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","И Авраам упрекал Авимелеха за колодезь с водою, который отняли рабы Авимелеховы. ");
INSERT INTO russyn_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Авимелех же сказал ему: не знаю, кто это сделал, и ты не сказал мне; я даже и не слыхал о том доныне. ");
INSERT INTO russyn_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","И взял Авраам мелкого и крупного скота и дал Авимелеху, и они оба заключили союз. ");
INSERT INTO russyn_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","И поставил Авраам семь агниц из стада мелкого скота особо. ");
INSERT INTO russyn_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Авимелех же сказал Аврааму: на что здесь сии семь агниц из стада овец, которых ты поставил особо? ");
INSERT INTO russyn_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Авраам сказал: семь агниц сих возьми от руки моей, чтобы они были мне свидетельством, что я выкопал этот колодезь. ");
INSERT INTO russyn_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Потому и назвал он сие место: Вирсавия, ибо тут оба они клялись ");
INSERT INTO russyn_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","и заключили союз в Вирсавии. И встал Авимелех и Фихол, военачальник его, и возвратились в землю Филистимскую. ");
INSERT INTO russyn_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","И насадил Авраам при Вирсавии рощу и призвал там имя Господа, Бога вечного. ");
INSERT INTO russyn_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","И жил Авраам в земле Филистимской, как странник, дни многие. ");
INSERT INTO russyn_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","И было, после сих происшествий Бог искушал Авраама и сказал ему: Авраам! Он сказал: вот я. ");
INSERT INTO russyn_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Бог сказал: возьми сына твоего, единственного твоего, которого ты любишь, Исаака; и пойди в землю Мориа и там принеси его во всесожжение на одной из гор, о которой Я скажу тебе. ");
INSERT INTO russyn_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Авраам встал рано утром, оседлал осла своего, взял с собою двоих из отроков своих и Исаака, сына своего; наколол дров для всесожжения, и встав пошел на место, о котором сказал ему Бог. ");
INSERT INTO russyn_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","На третий день Авраам возвел очи свои, и увидел то место издалека. ");
INSERT INTO russyn_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","И сказал Авраам отрокам своим: останьтесь вы здесь с ослом, а я и сын пойдем туда и поклонимся, и возвратимся к вам. ");
INSERT INTO russyn_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","И взял Авраам дрова для всесожжения, и возложил на Исаака, сына своего; взял в руки огонь и нож, и пошли оба вместе. ");
INSERT INTO russyn_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","И начал Исаак говорить Аврааму, отцу своему, и сказал: отец мой! Он отвечал: вот я, сын мой. Он сказал: вот огонь и дрова, где же агнец для всесожжения? ");
INSERT INTO russyn_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Авраам сказал: Бог усмотрит Себе агнца для всесожжения, сын мой. И шли далее оба вместе. ");
INSERT INTO russyn_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","И пришли на место, о котором сказал ему Бог; и устроил там Авраам жертвенник, разложил дрова и, связав сына своего Исаака, положил его на жертвенник поверх дров. ");
INSERT INTO russyn_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","И простер Авраам руку свою и взял нож, чтобы заколоть сына своего. ");
INSERT INTO russyn_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Но Ангел Господень воззвал к нему с неба и сказал: Авраам! Авраам! Он сказал: вот я. ");
INSERT INTO russyn_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Ангел сказал: не поднимай руки твоей на отрока и не делай над ним ничего, ибо теперь Я знаю, что боишься ты Бога и не пожалел сына твоего, единственного твоего, для Меня. ");
INSERT INTO russyn_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","И возвел Авраам очи свои и увидел: и вот, позади овен, запутавшийся в чаще рогами своими. Авраам пошел, взял овна и принес его во всесожжение вместо Исаака, сына своего. ");
INSERT INTO russyn_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","И нарек Авраам имя месту тому: Иегова-ире. Посему и ныне говорится: на горе Иеговы усмотрится. ");
INSERT INTO russyn_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","И вторично воззвал к Аврааму Ангел Господень с неба ");
INSERT INTO russyn_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","и сказал: Мною клянусь, говорит Господь, что, так как ты сделал сие дело, и не пожалел сына твоего, единственного твоего, для Меня, ");
INSERT INTO russyn_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","то Я благословляя благословлю тебя и умножая умножу семя твое, как звезды небесные и как песок на берегу моря; и овладеет семя твое городами врагов своих; ");
INSERT INTO russyn_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","и благословятся в семени твоем все народы земли за то, что ты послушался гласа Моего. ");
INSERT INTO russyn_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","И возвратился Авраам к отрокам своим, и встали и пошли вместе в Вирсавию; и жил Авраам в Вирсавии. ");
INSERT INTO russyn_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","После сих происшествий Аврааму возвестили, сказав: вот, и Милка родила Нахору, брату твоему, сынов: ");
INSERT INTO russyn_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Уца, первенца его, Вуза, брата сему, Кемуила, отца Арамова, ");
INSERT INTO russyn_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Кеседа, Хазо, Пилдаша, Идлафа и Вафуила; ");
INSERT INTO russyn_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","от Вафуила родилась Ревекка. Восьмерых сих сынов родила Милка Нахору, брату Авраамову; ");
INSERT INTO russyn_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","и наложница его, именем Реума, также родила Теваха, Гахама, Тахаша и Мааху. ");
INSERT INTO russyn_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Жизни Сарриной было сто двадцать семь лет: вот лета жизни Сарриной; ");
INSERT INTO russyn_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","и умерла Сарра в Кириаф-Арбе, который на долине, что ныне Хеврон, в земле Ханаанской. И пришел Авраам рыдать по Сарре и оплакивать ее. ");
INSERT INTO russyn_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","И отошел Авраам от умершей своей, и говорил сынам Хетовым, и сказал: ");
INSERT INTO russyn_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","я у вас пришлец и поселенец; дайте мне в собственность место для гроба между вами, чтобы мне умершую мою схоронить от глаз моих. ");
INSERT INTO russyn_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Сыны Хета отвечали Аврааму и сказали ему: ");
INSERT INTO russyn_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","послушай нас, господин наш; ты князь Божий посреди нас; в лучшем из наших погребальных мест похорони умершую твою; никто из нас не откажет тебе в погребальном месте, для погребения на нем умершей твоей. ");
INSERT INTO russyn_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Авраам встал и поклонился народу земли той, сынам Хетовым; ");
INSERT INTO russyn_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","и говорил им Авраам и сказал: если вы согласны, чтобы я похоронил умершую мою, то послушайте меня, попросите за меня Ефрона, сына Цохарова, ");
INSERT INTO russyn_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","чтобы он отдал мне пещеру Махпелу, которая у его над конце поля его, чтобы за довольную цену отдал ее мне посреди вас, в собственность для погребения. ");
INSERT INTO russyn_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ефрон же сидел посреди сынов Хетовых; и отвечал Ефрон Хеттеянин Аврааму вслух сынов Хета, всех входящих во врата города его, и сказал: ");
INSERT INTO russyn_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","нет, господин мой, послушай меня: я даю тебе поле и пещеру, которая на нем, даю тебе, пред очами сынов народа моего дарю тебе ее, похорони умершую твою. ");
INSERT INTO russyn_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Авраам поклонился пред народом земли той ");
INSERT INTO russyn_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","и говорил Ефрону вслух всего народа земли той и сказал: если послушаешь, я даю тебе за поле серебро; возьми у меня, и я похороню там умершую мою. ");
INSERT INTO russyn_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ефрон отвечал Аврааму и сказал ему: ");
INSERT INTO russyn_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","господин мой! послушай меня: земля стоит четыреста сиклей серебра; для меня и для тебя что это? похорони умершую твою. ");
INSERT INTO russyn_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Авраам выслушал Ефрона; и отвесил Авраам Ефрону серебра, сколько он объявил вслух сынов Хетовых, четыреста сиклей серебра, какое ходит у купцов. ");
INSERT INTO russyn_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","И стало поле Ефроново, которое при Махпеле, против Мамре, поле и пещера, которая на нем, и все деревья, которые на поле, во всех пределах его вокруг, ");
INSERT INTO russyn_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","владением Авраамовым пред очами сынов Хета, всех входящих во врата города его. ");
INSERT INTO russyn_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","После сего Авраам похоронил Сарру, жену свою, в пещере поля в Махпеле, против Мамре, что ныне Хеврон, в земле Ханаанской. ");
INSERT INTO russyn_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Так достались Аврааму от сынов Хетовых поле и пещера, которая на нем, в собственность для погребения. ");
INSERT INTO russyn_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Авраам был уже стар и в летах преклонных. Господь благословил Авраама всем. ");
INSERT INTO russyn_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","И сказал Авраам рабу своему, старшему в доме его, управлявшему всем, что у него было: положи руку твою под стегно мое ");
INSERT INTO russyn_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","и клянись мне Господом, Богом неба и Богом земли, что ты не возьмешь сыну моему Исааку жены из дочерей Хананеев, среди которых я живу, ");
INSERT INTO russyn_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","но пойдешь в землю мою, на родину мою и к племени моему, и возьмешь оттуда жену сыну моему Исааку. ");
INSERT INTO russyn_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Раб сказал ему: может быть, не захочет женщина идти со мною в эту землю, должен ли я возвратить сына твоего в землю, из которой ты вышел? ");
INSERT INTO russyn_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Авраам сказал ему: берегись, не возвращай сына моего туда; ");
INSERT INTO russyn_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Господь, Бог неба и Бог земли, Который взял меня из дома отца моего и из земли рождения моего, Который говорил мне и Который клялся мне, говоря: тебе и потомству твоему дам сию землю,- Он пошлет Ангела Своего пред тобою, и ты возьмешь жену сыну моему Исааку оттуда; ");
INSERT INTO russyn_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","если же не захочет женщина идти с тобою в землю сию, ты будешь свободен от сей клятвы моей; только сына моего не возвращай туда. ");
INSERT INTO russyn_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","И положил раб руку свою под стегно Авраама, господина своего, и клялся ему в сем. ");
INSERT INTO russyn_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","И взял раб из верблюдов господина своего десять верблюдов и пошел. В руках у него были также всякие сокровища господина его. Он встал и пошел в Месопотамию, в город Нахора, ");
INSERT INTO russyn_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","и остановил верблюдов вне города, у колодезя воды, под вечер, в то время, когда выходят женщины черпать воду, ");
INSERT INTO russyn_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","и сказал: Господи, Боже господина моего Авраама! пошли ее сегодня навстречу мне и сотвори милость с господином моим Авраамом; ");
INSERT INTO russyn_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","вот, я стою у источника воды, и дочери жителей города выходят черпать воду; ");
INSERT INTO russyn_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","и девица, которой я скажу: наклони кувшин твой, я напьюсь, и которая скажет мне: пей, я и верблюдам твоим дам пить, пока не напьются,- вот та, которую Ты назначил рабу Твоему Исааку; и по сему узнаю я, что Ты творишь милость с господином моим Авраамом. ");
INSERT INTO russyn_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Еще не перестал он говорить в уме своем, и вот, вышла Ревекка, которая родилась от Вафуила, сына Милки, жены Нахора, брата Авраамова, и кувшин ее на плече ее; ");
INSERT INTO russyn_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","девица была прекрасна видом, дева, которой не познал муж. Она сошла к источнику, наполнила кувшин свой и пошла вверх. ");
INSERT INTO russyn_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","И побежал раб навстречу ей и сказал: дай мне испить немного воды из кувшина твоего. ");
INSERT INTO russyn_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Она сказала: пей, господин мой. И тотчас спустила кувшин свой на руку свою и напоила его. ");
INSERT INTO russyn_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","И, когда напоила его, сказала: я стану черпать и для верблюдов твоих, пока не напьются все. ");
INSERT INTO russyn_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","И тотчас вылила воду из кувшина своего в поило и побежала опять к колодезю почерпнуть воды, и начерпала для всех верблюдов его. ");
INSERT INTO russyn_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Человек тот смотрел на нее с изумлением в молчании, желая уразуметь, благословил ли Господь путь его, или нет. ");
INSERT INTO russyn_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Когда верблюды перестали пить, тогда человек тот взял золотую серьгу, весом полсикля, и два запястья на руки ей, весом в десять сиклей золота; ");
INSERT INTO russyn_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","и спросил ее и сказал: чья ты дочь? скажи мне, есть ли в доме отца твоего место нам ночевать? ");
INSERT INTO russyn_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Она сказала ему: я дочь Вафуила, сына Милки, которого она родила Нахору. ");
INSERT INTO russyn_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","И еще сказала ему: у нас много соломы и корму, и есть место для ночлега. ");
INSERT INTO russyn_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","И преклонился человек тот и поклонился Господу, ");
INSERT INTO russyn_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","и сказал: благословен Господь Бог господина моего Авраама, Который не оставил господина моего милостью Своею и истиною Своею! Господь прямым путем привел меня к дому брата господина моего. ");
INSERT INTO russyn_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Девица побежала и рассказала об этом в доме матери своей. ");
INSERT INTO russyn_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","У Ревекки был брат, именем Лаван. Лаван выбежал к тому человеку, к источнику. ");
INSERT INTO russyn_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","И когда он увидел серьгу и запястья на руках у сестры своей и услышал слова Ревекки, сестры своей, которая говорила: так говорил со мною этот человек,- то пришел к человеку, и вот, он стоит при верблюдах у источника; ");
INSERT INTO russyn_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","и сказал ему: войди, благословенный Господом; зачем ты стоишь вне? я приготовил дом и место для верблюдов. ");
INSERT INTO russyn_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","И вошел человек. Лаван расседлал верблюдов и дал соломы и корму верблюдам, и воды умыть ноги ему и людям, которые были с ним; ");
INSERT INTO russyn_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","и предложена была ему пища; но он сказал: не стану есть, доколе не скажу дела своего. И сказали: говори. ");
INSERT INTO russyn_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Он сказал: я раб Авраамов; ");
INSERT INTO russyn_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Господь весьма благословил господина моего, и он сделался великим: Он дал ему овец и волов, серебро и золото, рабов и рабынь, верблюдов и ослов; ");
INSERT INTO russyn_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Сарра, жена господина моего, уже состарившись, родила господину моему одного сына, которому он отдал все, что у него; ");
INSERT INTO russyn_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","и взял с меня клятву господин мой, сказав: не бери жены сыну моему из дочерей Хананеев, в земле которых я живу, ");
INSERT INTO russyn_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","а пойди в дом отца моего и к родственникам моим, и возьмешь оттуда жену сыну моему. ");
INSERT INTO russyn_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Я сказал господину моему: может быть, не пойдет женщина со мною. ");
INSERT INTO russyn_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Он сказал мне: Господь Бог, пред лицем Которого я хожу, пошлет с тобою Ангела Своего и благоустроит путь твой, и возьмешь жену сыну моему из родных моих и из дома отца моего; ");
INSERT INTO russyn_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","тогда будешь ты свободен от клятвы моей, когда сходишь к родственникам моим; и если они не дадут тебе, то будешь свободен от клятвы моей. ");
INSERT INTO russyn_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","И пришел я ныне к источнику, и сказал: Господи, Боже господина моего Авраама! Если Ты благоустроишь путь, который я совершаю, ");
INSERT INTO russyn_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","то вот, я стою у источника воды, и дочери жителей города выходят черпать воду, и девица, которая выйдет почерпать, и которой я скажу: дай мне испить немного из кувшина твоего, ");
INSERT INTO russyn_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","и которая скажет мне: и ты пей, и верблюдам твоим я начерпаю,- вот жена, которую Господь назначил сыну господина моего рабу Своему Исааку; и по сему узнаю я, что Ты творишь милость с господином моим Авраамом. ");
INSERT INTO russyn_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Еще не перестал я говорить в уме моем, и вот вышла Ревекка, и кувшин ее на плече ее, и сошла к источнику и почерпнула воды; и я сказал ей: напой меня. ");
INSERT INTO russyn_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Она тотчас спустила с себя кувшин свой на руку свою и сказала: пей, и верблюдов твоих я напою. И я пил, и верблюдов моих она напоила. ");
INSERT INTO russyn_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Я спросил ее и сказал: чья ты дочь? скажи мне. Она сказала: дочь Вафуила, сына Нахорова, которого родила ему Милка. И дал я серьги ей и запястья на руки ее. ");
INSERT INTO russyn_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","И преклонился я и поклонился Господу, и благословил Господа, Бога господина моего Авраама, Который прямым путем привел меня, чтобы взять дочь брата господина моего за сына его. ");
INSERT INTO russyn_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","И ныне скажите мне: намерены ли вы оказать милость и правду господину моему или нет? скажите мне, и я обращусь направо, или налево. ");
INSERT INTO russyn_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","И отвечали Лаван и Вафуил и сказали: от Господа пришло это дело; мы не можем сказать тебе вопреки ни худого, ни доброго; ");
INSERT INTO russyn_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","вот Ревекка пред тобою; возьми ее и пойди; пусть будет она женою сыну господина твоего, как сказал Господь. ");
INSERT INTO russyn_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Когда раб Авраамов услышал слова их, то поклонился Господу до земли. ");
INSERT INTO russyn_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","И вынул раб серебряные вещи и золотые вещи и одежды и дал Ревекке; также и брату ее и матери ее дал богатые подарки. ");
INSERT INTO russyn_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","И ели и пили он и люди, бывшие с ним, и переночевали. Когда же встали поутру, то он сказал: отпустите меня и я пойду к господину моему. ");
INSERT INTO russyn_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Но брат ее и мать ее сказали: пусть побудет с нами девица дней хотя десять, потом пойдешь. ");
INSERT INTO russyn_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Он сказал им: не удерживайте меня, ибо Господь благоустроил путь мой; отпустите меня, и я пойду к господину моему. ");
INSERT INTO russyn_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Они сказали: призовем девицу и спросим, что она скажет. ");
INSERT INTO russyn_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","И призвали Ревекку и сказали ей: пойдешь ли с этим человеком? Она сказала: пойду. ");
INSERT INTO russyn_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","И отпустили Ревекку, сестру свою, и кормилицу ее, и раба Авраамова, и людей его. ");
INSERT INTO russyn_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","И благословили Ревекку и сказали ей: сестра наша! да родятся от тебя тысячи тысяч, и да владеет потомство твое жилищами врагов твоих! ");
INSERT INTO russyn_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","И встала Ревекка и служанки ее, и сели на верблюдов, и поехали за тем человеком. И раб взял Ревекку и пошел. ");
INSERT INTO russyn_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","А Исаак пришел из Беэр-лахай-рои, ибо жил он в земле полуденной. ");
INSERT INTO russyn_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","При наступлении вечера Исаак вышел в поле поразмыслить, и возвел очи свои, и увидел: вот, идут верблюды. ");
INSERT INTO russyn_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ревекка взглянула, и увидела Исаака, и спустилась с верблюда. ");
INSERT INTO russyn_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","И сказала рабу: кто этот человек, который идет по полю навстречу нам? Раб сказал: это господин мой. И она взяла покрывало и покрылась. ");
INSERT INTO russyn_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Раб же сказал Исааку все, что сделал. ");
INSERT INTO russyn_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","И ввел ее Исаак в шатер Сарры, матери своей, и взял Ревекку, и она сделалась ему женою, и он возлюбил ее; и утешился Исаак в печали по Сарре, матери своей. ");
INSERT INTO russyn_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","И взял Авраам еще жену, именем Хеттуру. ");
INSERT INTO russyn_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Она родила ему Зимрана, Иокшана, Медана, Мадиана, Ишбака и Шуаха. ");
INSERT INTO russyn_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Иокшан родил Шеву, Фемана и Дедана. Сыны Дедана были: Рагуил, Навдеил, Ашурим, Летушим и Леюмим. ");
INSERT INTO russyn_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Сыны Мадиана: Ефа, Ефер, Ханох, Авида и Елдага. Все сии сыны Хеттуры. ");
INSERT INTO russyn_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","И отдал Авраам все, что было у него, Исааку сыну своему, ");
INSERT INTO russyn_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","а сынам наложниц, которые были у Авраама, дал Авраам подарки и отослал их от Исаака, сына своего, еще при жизни своей, на восток, в землю восточную. ");
INSERT INTO russyn_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Дней жизни Авраамовой, которые он прожил, было сто семьдесят пять лет; ");
INSERT INTO russyn_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","и скончался Авраам, и умер в старости доброй, престарелый и насыщенный жизнью, и приложился к народу своему. ");
INSERT INTO russyn_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","И погребли его Исаак и Измаил, сыновья его, в пещере Махпеле, на поле Ефрона, сына Цохара, Хеттеянина, которое против Мамре, ");
INSERT INTO russyn_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","на поле и в пещере, которые Авраам приобрел от сынов Хетовых. Там погребены Авраам и Сарра, жена его. ");
INSERT INTO russyn_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","По смерти Авраама Бог благословил Исаака, сына его. Исаак жил при Беэр-лахай-рои. ");
INSERT INTO russyn_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Вот родословие Измаила, сына Авраамова, которого родила Аврааму Агарь Египтянка, служанка Саррина; ");
INSERT INTO russyn_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","и вот имена сынов Измаиловых, имена их по родословию их: первенец Измаилов Наваиоф, за ним Кедар, Адбеел, Мивсам, ");
INSERT INTO russyn_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Мишма, Дума, Масса, ");
INSERT INTO russyn_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Хадад, Фема, Иетур, Нафиш и Кедма. ");
INSERT INTO russyn_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Сии суть сыны Измаиловы, и сии имена их, в селениях их, в кочевьях их. Это двенадцать князей племен их. ");
INSERT INTO russyn_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Лет же жизни Измаиловой было сто тридцать семь лет; и скончался он, и умер, и приложился к народу своему. ");
INSERT INTO russyn_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Они жили от Хавилы до Сура, что пред Египтом, как идешь к Ассирии. Они поселились пред лицем всех братьев своих. ");
INSERT INTO russyn_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Вот родословие Исаака, сына Авраамова. Авраам родил Исаака. ");
INSERT INTO russyn_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Исаак был сорока лет, когда он взял себе в жену Ревекку, дочь Вафуила Арамеянина из Месопотамии, сестру Лавана Арамеянина. ");
INSERT INTO russyn_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","И молился Исаак Господу о Ревекке жене своей, потому что она была неплодна; и Господь услышал его, и зачала Ревекка, жена его. ");
INSERT INTO russyn_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Сыновья в утробе ее стали биться, и она сказала: если так будет, то для чего мне это? И пошла вопросить Господа. ");
INSERT INTO russyn_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Господь сказал ей: два племени во чреве твоем, и два различных народа произойдут из утробы твоей; один народ сделается сильнее другого, и больший будет служить меньшему. ");
INSERT INTO russyn_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","И настало время родить ей: и вот близнецы в утробе ее. ");
INSERT INTO russyn_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Первый вышел красный, весь, как кожа, косматый; и нарекли ему имя Исав. ");
INSERT INTO russyn_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Потом вышел брат его, держась рукою своею за пяту Исава; и наречено ему имя Иаков. Исаак же был шестидесяти лет, когда они родились от Ревекки. ");
INSERT INTO russyn_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Дети выросли, и стал Исав человеком искусным в звероловстве, человеком полей; а Иаков человеком кротким, живущим в шатрах. ");
INSERT INTO russyn_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Исаак любил Исава, потому что дичь его была по вкусу его, а Ревекка любила Иакова. ");
INSERT INTO russyn_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","И сварил Иаков кушанье; а Исав пришел с поля усталый. ");
INSERT INTO russyn_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","И сказал Исав Иакову: дай мне поесть красного, красного этого, ибо я устал. От сего дано ему прозвание: Едом. ");
INSERT INTO russyn_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Но Иаков сказал Исаву: продай мне теперь же свое первородство. ");
INSERT INTO russyn_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Исав сказал: вот, я умираю, что мне в этом первородстве? ");
INSERT INTO russyn_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Иаков сказал ему: поклянись мне теперь же. Он поклялся ему, и продал Исав первородство свое Иакову. ");
INSERT INTO russyn_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","И дал Иаков Исаву хлеба и кушанья из чечевицы; и он ел и пил, и встал и пошел; и пренебрег Исав первородство. ");
INSERT INTO russyn_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Был голод в земле, сверх прежнего голода, который был во дни Авраама; и пошел Исаак к Авимелеху, царю Филистимскому, в Герар. ");
INSERT INTO russyn_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Господь явился ему и сказал: не ходи в Египет; живи в земле, о которой Я скажу тебе, ");
INSERT INTO russyn_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","странствуй по сей земле, и Я буду с тобою и благословлю тебя, ибо тебе и потомству твоему дам все земли сии и исполню клятву Мою, которою Я клялся Аврааму, отцу твоему; ");
INSERT INTO russyn_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","умножу потомство твое, как звезды небесные, и дам потомству твоему все земли сии; благословятся в семени твоем все народы земные, ");
INSERT INTO russyn_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","за то, что Авраам отец твой послушался гласа Моего и соблюдал, что Мною заповедано было соблюдать: повеления Мои, уставы Мои и законы Мои. ");
INSERT INTO russyn_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Исаак поселился в Гераре. ");
INSERT INTO russyn_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Жители места того спросили о Ревекке жене его, и он сказал: это сестра моя; потому что боялся сказать: жена моя, чтобы не убили меня, думал он, жители места сего за Ревекку, потому что она прекрасна видом. ");
INSERT INTO russyn_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Но когда уже много времени он там прожил, Авимелех, царь Филистимский, посмотрев в окно, увидел, что Исаак играет с Ревеккою, женою своею. ");
INSERT INTO russyn_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","И призвал Авимелех Исаака и сказал: вот, это жена твоя; как же ты сказал: она сестра моя? Исаак сказал ему: потому что я думал, не умереть бы мне ради ее. ");
INSERT INTO russyn_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Но Авимелех сказал ему: что это ты сделал с нами? едва один из народа моего не совокупился с женою твоею, и ты ввел бы нас в грех. ");
INSERT INTO russyn_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","И дал Авимелех повеление всему народу, сказав: кто прикоснется к сему человеку и к жене его, тот предан будет смерти. ");
INSERT INTO russyn_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","И сеял Исаак в земле той и получил в тот год ячменя во сто крат: так благословил его Господь. ");
INSERT INTO russyn_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","И стал великим человек сей и возвеличивался больше и больше до того, что стал весьма великим. ");
INSERT INTO russyn_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","У него были стада мелкого и стада крупного скота и множество пахотных полей, и Филистимляне стали завидовать ему. ");
INSERT INTO russyn_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","И все колодези, которые выкопали рабы отца его при жизни отца его Авраама, Филистимляне завалили и засыпали землею. ");
INSERT INTO russyn_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","И Авимелех сказал Исааку: удались от нас, ибо ты сделался гораздо сильнее нас. ");
INSERT INTO russyn_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","И Исаак удалился оттуда, и расположился шатрами в долине Герарской, и поселился там. ");
INSERT INTO russyn_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","И вновь выкопал Исаак колодези воды, которые выкопаны были во дни Авраама, отца его, и которые завалили Филистимляне по смерти Авраама отца его; и назвал их теми же именами, которыми назвал их Авраам, отец его. ");
INSERT INTO russyn_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","И копали рабы Исааковы в долине Герарской и нашли там колодезь воды живой. ");
INSERT INTO russyn_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","И спорили пастухи Герарские с пастухами Исаака, говоря: наша вода. И он нарек колодезю имя: Есек, потому что спорили с ним. ");
INSERT INTO russyn_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Когда двинулся оттуда Исаак, выкопали другой колодезь; спорили также и о нем; и он нарек ему имя: Ситна. ");
INSERT INTO russyn_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","И он двинулся отсюда и выкопал иной колодезь, о котором уже не спорили, и нарек ему имя: Реховоф, ибо, сказал он, теперь Господь дал нам пространное место, и мы размножимся на земле. ");
INSERT INTO russyn_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Оттуда перешел он в Вирсавию. ");
INSERT INTO russyn_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","И в ту ночь явился ему Господь и сказал: Я Бог Авраама, отца твоего; не бойся, ибо Я с тобою; и благословлю тебя и умножу потомство твое, ради отца твоего Авраама, раба Моего. ");
INSERT INTO russyn_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","И он устроил там жертвенник и призвал имя Господа. И раскинул там шатер свой, и выкопали там рабы Исааковы колодезь, в долине Герарской. ");
INSERT INTO russyn_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Пришел к нему из Герара Авимелех и Ахузаф, друг его, и Фихол, военачальник его. ");
INSERT INTO russyn_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Исаак сказал им: для чего вы пришли ко мне, когда вы возненавидели меня и выслали меня от себя? ");
INSERT INTO russyn_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Они сказали: мы ясно увидели, что Господь с тобою, и потому мы сказали: поставим между нами и тобою клятву и заключим с тобою союз, ");
INSERT INTO russyn_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","чтобы ты не делал нам зла, как и мы не коснулись до тебя, а делали тебе одно доброе и отпустили тебя с миром; теперь ты благословен Господом. ");
INSERT INTO russyn_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Он сделал им пиршество, и они ели и пили. ");
INSERT INTO russyn_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","И встав рано утром, поклялись друг другу; и отпустил их Исаак, и они пошли от него с миром. ");
INSERT INTO russyn_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","В тот же день пришли рабы Исааковы и известили его о колодезе, который копали они, и сказали ему: мы нашли воду. ");
INSERT INTO russyn_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","И он назвал его: Шива. Посему имя городу тому Беэршива (Вирсавия) до сего дня. ");
INSERT INTO russyn_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","И был Исав сорока лет, и взял себе в жены Иегудифу, дочь Беэра Хеттеянина, и Васемафу, дочь Елона Хеттеянина; ");
INSERT INTO russyn_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","и они были в тягость Исааку и Ревекке. ");
INSERT INTO russyn_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Когда Исаак состарился и притупилось зрение глаз его, он призвал старшего сына своего Исава и сказал ему: сын мой! Тот сказал ему: вот я. ");
INSERT INTO russyn_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Исаак сказал: вот, я состарился; не знаю дня смерти моей; ");
INSERT INTO russyn_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","возьми теперь орудия твои, колчан твой и лук твой, пойди в поле, и налови мне дичи, ");
INSERT INTO russyn_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","и приготовь мне кушанье, какое я люблю, и принеси мне есть, чтобы благословила тебя душа моя, прежде нежели я умру. ");
INSERT INTO russyn_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ревекка слышала, когда Исаак говорил сыну своему Исаву. И пошел Исав в поле достать и принести дичи; ");
INSERT INTO russyn_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","а Ревекка сказала меньшему сыну своему Иакову: вот, я слышала, как отец твой говорил брату твоему Исаву: ");
INSERT INTO russyn_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","принеси мне дичи и приготовь мне кушанье; я поем и благословлю тебя пред лицем Господним, пред смертью моею. ");
INSERT INTO russyn_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Теперь, сын мой, послушайся слов моих в том, что я прикажу тебе: ");
INSERT INTO russyn_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","пойди в стадо и возьми мне оттуда два козленка молодых хороших, и я приготовлю из них отцу твоему кушанье, какое он любит, ");
INSERT INTO russyn_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","а ты принесешь отцу твоему, и он поест, чтобы благословить тебя пред смертью своею. ");
INSERT INTO russyn_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Иаков сказал Ревекке, матери своей: Исав, брат мой, человек косматый, а я человек гладкий; ");
INSERT INTO russyn_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","может статься, ощупает меня отец мой, и я буду в глазах его обманщиком и наведу на себя проклятие, а не благословение. ");
INSERT INTO russyn_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Мать его сказала ему: на мне пусть будет проклятие твое, сын мой, только послушайся слов моих и пойди, принеси мне. ");
INSERT INTO russyn_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Он пошел, и взял, и принес матери своей; и мать его сделала кушанье, какое любил отец его. ");
INSERT INTO russyn_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","И взяла Ревекка богатую одежду старшего сына своего Исава, бывшую у ней в доме, и одела в нее младшего сына своего Иакова; ");
INSERT INTO russyn_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","а руки его и гладкую шею его обложила кожею козлят; ");
INSERT INTO russyn_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","и дала кушанье и хлеб, которые она приготовила, в руки Иакову, сыну своему. ");
INSERT INTO russyn_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Он вошел к отцу своему и сказал: отец мой! Тот сказал: вот я; кто ты, сын мой? ");
INSERT INTO russyn_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Иаков сказал отцу своему: я Исав, первенец твой; я сделал, как ты сказал мне; встань, сядь и поешь дичи моей, чтобы благословила меня душа твоя. ");
INSERT INTO russyn_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","И сказал Исаак сыну своему: что так скоро нашел ты, сын мой? Он сказал: потому что Господь Бог твой послал мне навстречу. ");
INSERT INTO russyn_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","И сказал Исаак Иакову: подойди ко мне, я ощупаю тебя, сын мой, ты ли сын мой Исав, или нет? ");
INSERT INTO russyn_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Иаков подошел к Исааку, отцу своему, и он ощупал его и сказал: голос, голос Иакова; а руки, руки Исавовы. ");
INSERT INTO russyn_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","И не узнал его, потому что руки его были, как руки Исава, брата его, косматые; и благословил его ");
INSERT INTO russyn_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","и сказал: ты ли сын мой Исав? Он отвечал: я. ");
INSERT INTO russyn_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Исаак сказал: подай мне, я поем дичи сына моего, чтобы благословила тебя душа моя. Иаков подал ему, и он ел; принес ему и вина, и он пил. ");
INSERT INTO russyn_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Исаак, отец его, сказал ему: подойди ко мне, поцелуй меня, сын мой. ");
INSERT INTO russyn_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Он подошел и поцеловал его. И ощутил Исаак запах от одежды его и благословил его и сказал: вот, запах от сына моего, как запах от поля полного, которое благословил Господь; ");
INSERT INTO russyn_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","да даст тебе Бог от росы небесной и от тука земли, и множество хлеба и вина; ");
INSERT INTO russyn_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","да послужат тебе народы, и да поклонятся тебе племена; будь господином над братьями твоими, и да поклонятся тебе сыны матери твоей; проклинающие тебя - прокляты; благословляющие тебя - благословенны! ");
INSERT INTO russyn_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Как скоро совершил Исаак благословение над Иаковом сыном своим, и как только вышел Иаков от лица Исаака, отца своего, Исав, брат его, пришел с ловли своей. ");
INSERT INTO russyn_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Приготовил и он кушанье, и принес отцу своему, и сказал отцу своему: встань, отец мой, и поешь дичи сына твоего, чтобы благословила меня душа твоя. ");
INSERT INTO russyn_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Исаак же, отец его, сказал ему: кто ты? Он сказал: я сын твой, первенец твой, Исав. ");
INSERT INTO russyn_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","И вострепетал Исаак весьма великим трепетом, и сказал: кто ж это, который достал мне дичи и принес мне, и я ел от всего, прежде нежели ты пришел, и я благословил его? он и будет благословен. ");
INSERT INTO russyn_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Исав, выслушав слова отца своего Исаака, поднял громкий и весьма горький вопль и сказал отцу своему: отец мой! благослови и меня. ");
INSERT INTO russyn_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Но он сказал ему: брат твой пришел с хитростью и взял благословение твое. ");
INSERT INTO russyn_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","И сказал Исав: не потому ли дано ему имя: Иаков, что он запнул меня уже два раза? Он взял первородство мое, и вот, теперь взял благословение мое. И еще сказал Исав отцу своему: неужели ты не оставил и мне благословения? ");
INSERT INTO russyn_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Исаак отвечал Исаву: вот, я поставил его господином над тобою и всех братьев его отдал ему в рабы; одарил его хлебом и вином; что же я сделаю для тебя, сын мой? ");
INSERT INTO russyn_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Но Исав сказал отцу своему: неужели, отец мой, одно у тебя благословение? благослови и меня, отец мой! И как Исаак молчал, возвысил Исав голос свой и заплакал. ");
INSERT INTO russyn_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","И отвечал Исаак, отец его, и сказал ему: вот, от тука земли будет обитание твое и от росы небесной свыше; ");
INSERT INTO russyn_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","и ты будешь жить мечом твоим и будешь служить брату твоему; будет же время, когда воспротивишься и свергнешь иго его с выи твоей. ");
INSERT INTO russyn_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","И возненавидел Исав Иакова за благословение, которым благословил его отец его; и сказал Исав в сердце своем: приближаются дни плача по отце моем, и я убью Иакова, брата моего. ");
INSERT INTO russyn_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","И пересказаны были Ревекке слова Исава, старшего сына ее; и она послала, и призвала младшего сына своего Иакова, и сказала ему: вот, Исав, брат твой, грозит убить тебя; ");
INSERT INTO russyn_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","и теперь, сын мой, послушайся слов моих, встань, беги в Месопотамию к Лавану, брату моему, в Харран, ");
INSERT INTO russyn_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","и поживи у него несколько времени, пока утолится ярость брата твоего, ");
INSERT INTO russyn_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","пока утолится гнев брата твоего на тебя, и он позабудет, что ты сделал ему: тогда я пошлю и возьму тебя оттуда; для чего мне в один день лишиться обоих вас? ");
INSERT INTO russyn_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","И сказала Ревекка Исааку: я жизни не рада от дочерей Хеттейских; если Иаков возьмет жену из дочерей Хеттейских, каковы эти, из дочерей этой земли, то к чему мне и жизнь? ");
INSERT INTO russyn_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","И призвал Исаак Иакова и благословил его, и заповедал ему и сказал: не бери себе жены из дочерей Ханаанских; ");
INSERT INTO russyn_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","встань, пойди в Месопотамию, в дом Вафуила, отца матери твоей, и возьми себе жену оттуда, из дочерей Лавана, брата матери твоей; ");
INSERT INTO russyn_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Бог же Всемогущий да благословит тебя, да расплодит тебя и да размножит тебя, и да будет от тебя множество народов, ");
INSERT INTO russyn_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","и да даст тебе благословение Авраама отца моего, тебе и потомству твоему с тобою, чтобы тебе наследовать землю странствования твоего, которую Бог дал Аврааму! ");
INSERT INTO russyn_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","И отпустил Исаак Иакова, и он пошел в Месопотамию к Лавану, сыну Вафуила Арамеянина, к брату Ревекки, матери Иакова и Исава. ");
INSERT INTO russyn_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Исав увидел, что Исаак благословил Иакова и благословляя послал его в Месопотамию, взять себе жену оттуда, и заповедал ему, сказав: не бери жены из дочерей Ханаанских; ");
INSERT INTO russyn_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","и что Иаков послушался отца своего и матери своей и пошел в Месопотамию. ");
INSERT INTO russyn_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","И увидел Исав, что дочери Ханаанские не угодны Исааку, отцу его; ");
INSERT INTO russyn_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","и пошел Исав к Измаилу и взял себе жену Махалафу, дочь Измаила, сына Авраамова, сестру Наваиофову, сверх других жен своих. ");
INSERT INTO russyn_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Иаков же вышел из Вирсавии и пошел в Харран, ");
INSERT INTO russyn_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","и пришел на одно место, и остался там ночевать, потому что зашло солнце. И взял один из камней того места, и положил себе изголовьем, и лег на том месте. ");
INSERT INTO russyn_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","И увидел во сне: вот, лестница стоит на земле, а верх ее касается неба; и вот, Ангелы Божии восходят и нисходят по ней. ");
INSERT INTO russyn_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","И вот, Господь стоит на ней и говорит: Я Господь, Бог Авраама, отца твоего, и Бог Исаака; не бойся. Землю, на которой ты лежишь, Я дам тебе и потомству твоему; ");
INSERT INTO russyn_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","и будет потомство твое, как песок земной; и распространишься к морю и к востоку, и к северу и к полудню; и благословятся в тебе и в семени твоем все племена земные; ");
INSERT INTO russyn_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","и вот Я с тобою, и сохраню тебя везде, куда ты ни пойдешь; и возвращу тебя в сию землю, ибо Я не оставлю тебя, доколе не исполню того, что Я сказал тебе. ");
INSERT INTO russyn_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Иаков пробудился от сна своего и сказал: истинно Господь присутствует на месте сем; а я не знал! ");
INSERT INTO russyn_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","И убоялся и сказал: как страшно сие место! это не иное что, как дом Божий, это врата небесные. ");
INSERT INTO russyn_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","И встал Иаков рано утром, и взял камень, который он положил себе изголовьем, и поставил его памятником, и возлил елей на верх его. ");
INSERT INTO russyn_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","И нарек Иаков имя месту тому: Вефиль, а прежнее имя того города было: Луз. ");
INSERT INTO russyn_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","И положил Иаков обет, сказав: если Господь Бог будет со мною и сохранит меня в пути сем, в который я иду, и даст мне хлеб есть и одежду одеться, ");
INSERT INTO russyn_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","и я в мире возвращусь в дом отца моего, и будет Господь моим Богом,- ");
INSERT INTO russyn_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","то этот камень, который я поставил памятником, будет у меня домом Божиим; и из всего, что Ты, Боже, даруешь мне, я дам Тебе десятую часть. ");
INSERT INTO russyn_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","И встал Иаков и пошел в землю сынов востока к Лавану, сыну Вафуила Арамеянина, к брату Ревекки, матери Иакова и Исава. ");
INSERT INTO russyn_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","И увидел: вот, на поле колодезь, и там три стада мелкого скота, лежавшие около него, потому что из того колодезя поили стада. Над устьем колодезя был большой камень. ");
INSERT INTO russyn_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Когда собирались туда все стада, отваливали камень от устья колодезя и поили овец; потом опять клали камень на свое место, на устье колодезя. ");
INSERT INTO russyn_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Иаков сказал им: братья мои! откуда вы? Они сказали: мы из Харрана. ");
INSERT INTO russyn_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Он сказал им: знаете ли вы Лавана, сына Нахорова? Они сказали: знаем. ");
INSERT INTO russyn_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Он еще сказал им: здравствует ли он? Они сказали: здравствует; и вот, Рахиль, дочь его, идет с овцами. ");
INSERT INTO russyn_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","И сказал Иаков: вот, дня еще много; не время собирать скот; напойте овец и пойдите, пасите. ");
INSERT INTO russyn_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Они сказали: не можем, пока не соберутся все стада, и не отвалят камня от устья колодезя; тогда будем мы поить овец. ");
INSERT INTO russyn_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Еще он говорил с ними, как пришла Рахиль дочь Лавана с мелким скотом отца своего, потому что она пасла мелкий скот отца своего. ");
INSERT INTO russyn_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Когда Иаков увидел Рахиль, дочь Лавана, брата матери своей, и овец Лавана, брата матери своей, то подошел Иаков, отвалил камень от устья колодезя и напоил овец Лавана, брата матери своей. ");
INSERT INTO russyn_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","И поцеловал Иаков Рахиль и возвысил голос свой и заплакал. ");
INSERT INTO russyn_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","И сказал Иаков Рахили, что он родственник отцу ее и что он сын Ревеккин. А она побежала и сказала отцу своему все сие. ");
INSERT INTO russyn_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Лаван, услышав о Иакове, сыне сестры своей, выбежал ему навстречу, обнял его и поцеловал его, и ввел его в дом свой; и он рассказал Лавану все сие. ");
INSERT INTO russyn_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Лаван же сказал ему: подлинно ты кость моя и плоть моя. И жил у него Иаков целый месяц. ");
INSERT INTO russyn_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","И Лаван сказал Иакову: неужели ты даром будешь служить мне, потому что ты родственник? скажи мне, что заплатить тебе? ");
INSERT INTO russyn_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","У Лавана же было две дочери; имя старшей: Лия; имя младшей: Рахиль. ");
INSERT INTO russyn_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Лия была слаба глазами, а Рахиль была красива станом и красива лицем. ");
INSERT INTO russyn_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Иаков полюбил Рахиль и сказал: я буду служить тебе семь лет за Рахиль, младшую дочь твою. ");
INSERT INTO russyn_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Лаван сказал ему: лучше отдать мне ее за тебя, нежели отдать ее за другого кого; живи у меня. ");
INSERT INTO russyn_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","И служил Иаков за Рахиль семь лет; и они показались ему за несколько дней, потому что он любил ее. ");
INSERT INTO russyn_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","И сказал Иаков Лавану: дай жену мою, потому что мне уже исполнилось время, чтобы войти к ней. ");
INSERT INTO russyn_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Лаван созвал всех людей того места и сделал пир. ");
INSERT INTO russyn_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Вечером же взял Лаван дочь свою Лию и ввел ее к нему; и вошел к ней Иаков. ");
INSERT INTO russyn_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","И дал Лаван служанку свою Зелфу в служанки дочери своей Лии. ");
INSERT INTO russyn_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Утром же оказалось, что это Лия. И Иаков сказал Лавану: что это сделал ты со мною? не за Рахиль ли я служил у тебя? зачем ты обманул меня? ");
INSERT INTO russyn_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Лаван сказал: в нашем месте так не делают, чтобы младшую выдать прежде старшей; ");
INSERT INTO russyn_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","окончи неделю этой, потом дадим тебе и ту за службу, которую ты будешь служить у меня еще семь лет других. ");
INSERT INTO russyn_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Иаков так и сделал и окончил неделю этой. И Лаван дал Рахиль, дочь свою, ему в жену. ");
INSERT INTO russyn_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","И дал Лаван служанку свою Валлу в служанки дочери своей Рахили. ");
INSERT INTO russyn_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Иаков вошел и к Рахили, и любил Рахиль больше, нежели Лию; и служил у него еще семь лет других. ");
INSERT INTO russyn_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Господь Бог узрел, что Лия была нелюбима, и отверз утробу ее, а Рахиль была неплодна. ");
INSERT INTO russyn_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Лия зачала и родила Иакову сына, и нарекла ему имя: Рувим, потому что сказала она: Господь призрел на мое бедствие и дал мне сына, ибо теперь будет любить меня муж мой. ");
INSERT INTO russyn_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","И зачала Лия опять и родила Иакову второго сына, и сказала: Господь услышал, что я нелюбима, и дал мне и сего. И нарекла ему имя: Симеон. ");
INSERT INTO russyn_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","И зачала еще и родила сына, и сказала: теперь-то прилепится ко мне муж мой, ибо я родила ему трех сынов. От сего наречено ему имя: Левий. ");
INSERT INTO russyn_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","И еще зачала и родила сына, и сказала: теперь-то я восхвалю Господа. Посему нарекла ему имя Иуда. И перестала рождать. ");
INSERT INTO russyn_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","И увидела Рахиль, что она не рождает детей Иакову, и позавидовала Рахиль сестре своей, и сказала Иакову: дай мне детей, а если не так, я умираю. ");
INSERT INTO russyn_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Иаков разгневался на Рахиль и сказал ей: разве я Бог, Который не дал тебе плода чрева? ");
INSERT INTO russyn_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Она сказала: вот служанка моя Валла; войди к ней; пусть она родит на колени мои, чтобы и я имела детей от нее. ");
INSERT INTO russyn_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","И дала она Валлу, служанку свою, в жену ему; и вошел к ней Иаков. ");
INSERT INTO russyn_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Валла служанка Рахилина зачала и родила Иакову сына. ");
INSERT INTO russyn_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","И сказала Рахиль: судил мне Бог, и услышал голос мой, и дал мне сына. Посему нарекла ему имя: Дан. ");
INSERT INTO russyn_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","И еще зачала и родила Валла, служанка Рахилина, другого сына Иакову. ");
INSERT INTO russyn_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","И сказала Рахиль: борьбою сильною боролась я с сестрою моею и превозмогла. И нарекла ему имя: Неффалим. ");
INSERT INTO russyn_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Лия увидела, что перестала рождать, и взяла служанку свою Зелфу, и дала ее Иакову в жену, и он вошел к ней. ");
INSERT INTO russyn_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","И Зелфа, служанка Лиина, зачала и родила Иакову сына. ");
INSERT INTO russyn_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","И сказала Лия: прибавилось. И нарекла ему имя: Гад. ");
INSERT INTO russyn_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","И еще зачала Зелфа, служанка Лии, и родила другого сына Иакову. ");
INSERT INTO russyn_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","И сказала Лия: к благу моему, ибо блаженною будут называть меня женщины. И нарекла ему имя: Асир. ");
INSERT INTO russyn_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Рувим пошел во время жатвы пшеницы, и нашел мандрагоровые яблоки в поле, и принес их Лии, матери своей. И Рахиль сказала Лии сестре своей: дай мне мандрагоров сына твоего. ");
INSERT INTO russyn_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Но Лия сказала ей: неужели мало тебе завладеть мужем моим, что ты домогаешься и мандрагоров сына моего? Рахиль сказала: так пусть он ляжет с тобою эту ночь, за мандрагоры сына твоего. ");
INSERT INTO russyn_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Иаков пришел с поля вечером, и Лия вышла ему навстречу и сказала: войди ко мне сегодня, ибо я купила тебя за мандрагоры сына моего. И лег он с нею в ту ночь. ");
INSERT INTO russyn_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","И услышал Бог Лию, и она зачала и родила Иакову пятого сына. ");
INSERT INTO russyn_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","И сказала Лия: Бог дал возмездие мне за то, что я отдала служанку мою мужу моему. И нарекла ему имя: Иссахар что значит возмездие. ");
INSERT INTO russyn_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","И еще зачала Лия и родила Иакову шестого сына. ");
INSERT INTO russyn_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","И сказала Лия: Бог дал мне прекрасный дар; теперь будет жить у меня муж мой, ибо я родила ему шесть сынов. И нарекла ему имя: Завулон. ");
INSERT INTO russyn_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Потом родила дочь и нарекла ей имя: Дина. ");
INSERT INTO russyn_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","И вспомнил Бог о Рахили, и услышал ее Бог, и отверз утробу ее. ");
INSERT INTO russyn_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Она зачала и родила Иакову сына, и сказала Рахиль: снял Бог позор мой. ");
INSERT INTO russyn_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","И нарекла ему имя: Иосиф, сказав: Господь даст мне и другого сына. ");
INSERT INTO russyn_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","После того, как Рахиль родила Иосифа, Иаков сказал Лавану: отпусти меня, и пойду я в свое место и в свою землю; ");
INSERT INTO russyn_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","отдай мне жен моих и детей моих, за которых я служил тебе, и я пойду, ибо ты знаешь службу мою, какую я служил тебе. ");
INSERT INTO russyn_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","И сказал ему Лаван: о, если бы я нашел благоволение пред очами твоими! я примечаю, что за тебя Господь благословил меня. ");
INSERT INTO russyn_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","И сказал: назначь себе награду от меня, и я дам тебе. ");
INSERT INTO russyn_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","И сказал ему Иаков: ты знаешь, как я служил тебе, и каков стал скот твой при мне; ");
INSERT INTO russyn_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","ибо мало было у тебя до меня, а стало много; Господь благословил тебя с приходом моим; когда же я буду работать для своего дома? ");
INSERT INTO russyn_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","И сказал ему Лаван: что дать тебе? Иаков сказал ему: не давай мне ничего. Если только сделаешь мне, что я скажу, то я опять буду пасти и стеречь овец твоих. ");
INSERT INTO russyn_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Я пройду сегодня по всему стаду овец твоих; отдели из него всякий скот с крапинами и с пятнами, всякую скотину черную из овец, также с пятнами и с крапинами из коз. Такой скот будет наградою мне и будет мой. ");
INSERT INTO russyn_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","И будет говорить за меня пред тобою справедливость моя в следующее время, когда придешь посмотреть награду мою. Всякая из коз не с крапинами и не с пятнами, и из овец не черная, краденое это у меня. ");
INSERT INTO russyn_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Лаван сказал ему: хорошо, пусть будет по твоему слову. ");
INSERT INTO russyn_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","И отделил в тот день козлов пестрых и с пятнами, и всех коз с крапинами и с пятнами, всех, на которых было несколько белого, и всех черных овец, и отдал на руки сыновьям своим; ");
INSERT INTO russyn_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","и назначил расстояние между собою и между Иаковом на три дня пути. Иаков же пас остальной мелкий скот Лаванов. ");
INSERT INTO russyn_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","И взял Иаков свежих прутьев тополевых, миндальных и яворовых, и вырезал на них Иаков белые полосы, сняв кору до белизны, которая на прутьях, ");
INSERT INTO russyn_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","и положил прутья с нарезкою перед скотом в водопойных корытах, куда скот приходил пить и где, приходя пить, зачинал пред прутьями. ");
INSERT INTO russyn_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","И зачинал скот пред прутьями, и рождался скот пестрый, и с крапинами, и с пятнами. ");
INSERT INTO russyn_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","И отделял Иаков ягнят и ставил скот лицем к пестрому и всему черному скоту Лаванову; и держал свои стада особо и не ставил их вместе со скотом Лавана. ");
INSERT INTO russyn_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Каждый раз, когда зачинал скот крепкий, Иаков клал прутья в корытах пред глазами скота, чтобы он зачинал пред прутьями. ");
INSERT INTO russyn_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","А когда зачинал скот слабый, тогда он не клал. И доставался слабый скот Лавану, а крепкий Иакову. ");
INSERT INTO russyn_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","И сделался этот человек весьма, весьма богатым, и было у него множество мелкого скота и крупного скота, и рабынь, и рабов, и верблюдов, и ослов. ");
INSERT INTO russyn_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","И услышал Иаков слова сынов Лавановых, которые говорили: Иаков завладел всем, что было у отца нашего, и из имения отца нашего составил все богатство сие. ");
INSERT INTO russyn_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","И увидел Иаков лице Лавана, и вот, оно не таково к нему, как было вчера и третьего дня. ");
INSERT INTO russyn_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","И сказал Господь Иакову: возвратись в землю отцов твоих и на родину твою; и Я буду с тобою. ");
INSERT INTO russyn_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","И послал Иаков, и призвал Рахиль и Лию в поле, к стаду мелкого скота своего, ");
INSERT INTO russyn_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","и сказал им: я вижу лице отца вашего, что оно ко мне не таково, как было вчера и третьего дня; но Бог отца моего был со мною; ");
INSERT INTO russyn_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","вы сами знаете, что я всеми силами служил отцу вашему, ");
INSERT INTO russyn_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","а отец ваш обманывал меня и раз десять переменял награду мою; но Бог не попустил ему сделать мне зло. ");
INSERT INTO russyn_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Когда сказал он, что скот с крапинами будет тебе в награду, то скот весь родил с крапинами. А когда он сказал: пестрые будут тебе в награду, то скот весь и родил пестрых. ");
INSERT INTO russyn_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","И отнял Бог весь скот у отца вашего и дал его мне. ");
INSERT INTO russyn_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Однажды в такое время, когда скот зачинает, я взглянул и увидел во сне, и вот козлы и овны, поднявшиеся на скот на коз и овец пестрые, с крапинами и пятнами. ");
INSERT INTO russyn_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Ангел Божий сказал мне во сне: Иаков! Я сказал: вот я. ");
INSERT INTO russyn_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Он сказал: возведи очи твои и посмотри: все козлы и овны, поднявшиеся на скот на коз и овец, пестрые, с крапинами и с пятнами, ибо Я вижу все, что Лаван делает с тобою; ");
INSERT INTO russyn_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Я Бог явившийся тебе в Вефиле, где ты возлил елей на памятник и где ты дал Мне обет; теперь встань, выйди из земли сей и возвратись в землю родины твоей и Я буду с тобою. ");
INSERT INTO russyn_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Рахиль и Лия сказали ему в ответ: есть ли еще нам доля и наследство в доме отца нашего? ");
INSERT INTO russyn_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","не за чужих ли он нас почитает? ибо он продал нас и съел даже серебро наше; ");
INSERT INTO russyn_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","посему все имение и богатство, которое Бог отнял у отца нашего, есть наше и детей наших; итак делай все, что Бог сказал тебе. ");
INSERT INTO russyn_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","И встал Иаков, и посадил детей своих и жен своих на верблюдов, ");
INSERT INTO russyn_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","и взял с собою весь скот свой и все богатство свое, которое приобрел, скот собственный его, который он приобрел в Месопотамии, и все свое, чтобы идти к Исааку, отцу своему, в землю Ханаанскую. ");
INSERT INTO russyn_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","И как Лаван пошел стричь скот свой, то Рахиль похитила идолов, которые были у отца ее. ");
INSERT INTO russyn_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Иаков же похитил сердце у Лавана Арамеянина, потому что не известил его, что удаляется. ");
INSERT INTO russyn_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","И ушел со всем, что у него было; и, встав, перешел реку и направился к горе Галаад. ");
INSERT INTO russyn_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","На третий день сказали Лавану Арамеянину, что Иаков ушел. ");
INSERT INTO russyn_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Тогда он взял с собою сынов и родственников своих, и гнался за ним семь дней, и догнал его на горе Галаад. ");
INSERT INTO russyn_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","И пришел Бог к Лавану Арамеянину ночью во сне и сказал ему: берегись, не говори Иакову ни доброго, ни худого. ");
INSERT INTO russyn_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","И догнал Лаван Иакова; Иаков же поставил шатер свой на горе, и Лаван со сродниками своими поставил на горе Галаад. ");
INSERT INTO russyn_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","И сказал Лаван Иакову: что ты сделал? для чего ты обманул меня, и увел дочерей моих, как плененных оружием? ");
INSERT INTO russyn_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","зачем ты убежал тайно, и укрылся от меня, и не сказал мне? я отпустил бы тебя с веселием и с песнями, с тимпаном и с гуслями; ");
INSERT INTO russyn_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","ты не позволил мне даже поцеловать внуков моих и дочерей моих; безрассудно ты сделал. ");
INSERT INTO russyn_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Есть в руке моей сила сделать вам зло; но Бог отца вашего вчера говорил ко мне и сказал: берегись, не говори Иакову ни хорошего, ни худого. ");
INSERT INTO russyn_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Но пусть бы ты ушел, потому что ты нетерпеливо захотел быть в доме отца твоего,- зачем ты украл богов моих? ");
INSERT INTO russyn_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Иаков отвечал Лавану и сказал: я боялся, ибо я думал, не отнял бы ты у меня дочерей своих. ");
INSERT INTO russyn_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","И сказал Иаков: у кого найдешь богов твоих, тот не будет жив; при родственниках наших узнавай, что есть твоего у меня, и возьми себе. Иаков не знал, что Рахиль, жена его, украла их. ");
INSERT INTO russyn_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","И ходил Лаван в шатер Иакова, и в шатер Лии, и в шатер двух рабынь, и обыскивал, но не нашел. И, выйдя из шатра Лии, вошел в шатер Рахили. ");
INSERT INTO russyn_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Рахиль же взяла идолов, и положила их под верблюжье седло, и села на них. И обыскал Лаван весь шатер; но не нашел. ");
INSERT INTO russyn_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Она же сказала отцу своему: да не прогневается господин мой, что я не могу встать пред тобою, ибо у меня обыкновенное женское. И Лаван искал во всем шатре, но не нашел идолов. ");
INSERT INTO russyn_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Иаков рассердился и вступил в спор с Лаваном. И начал Иаков говорить и сказал Лавану: какая вина моя, какой грех мой, что ты преследуешь меня? ");
INSERT INTO russyn_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","ты осмотрел у меня все вещи в доме моем, что нашел ты из всех вещей твоего дома? покажи здесь пред родственниками моими и пред родственниками твоими; пусть они рассудят между нами обоими. ");
INSERT INTO russyn_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Вот, двадцать лет я был у тебя; овцы твои и козы твои не выкидывали; овнов стада твоего я не ел; ");
INSERT INTO russyn_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","растерзанного зверем я не приносил к тебе, это был мой убыток; ты с меня взыскивал, днем ли что пропадало, ночью ли пропадало; ");
INSERT INTO russyn_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","я томился днем от жара, а ночью от стужи, и сон мой убегал от глаз моих. ");
INSERT INTO russyn_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Таковы мои двадцать лет в доме твоем. Я служил тебе четырнадцать лет за двух дочерей твоих и шесть лет за скот твой, а ты десять раз переменял награду мою. ");
INSERT INTO russyn_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Если бы не был со мною Бог отца моего, Бог Авраама и страх Исаака, ты бы теперь отпустил меня ни с чем. Бог увидел бедствие мое и труд рук моих и вступился за меня вчера. ");
INSERT INTO russyn_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","И отвечал Лаван и сказал Иакову: дочери - мои дочери; дети - мои дети; скот - мой скот, и все, что ты видишь, это мое: могу ли я что сделать теперь с дочерями моими и с детьми их, которые рождены ими? ");
INSERT INTO russyn_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Теперь заключим союз я и ты, и это будет свидетельством между мною и тобою. При сем Иаков сказал ему: вот, с нами нет никого; смотри, Бог свидетель между мною и тобою. ");
INSERT INTO russyn_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","И взял Иаков камень и поставил его памятником. ");
INSERT INTO russyn_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","И сказал Иаков родственникам своим: наберите камней. Они взяли камни, и сделали холм, и ели и пили там на холме. И сказал ему Лаван: холм сей свидетель сегодня между мною и тобою. ");
INSERT INTO russyn_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","И назвал его Лаван: Иегар-Сагадуфа; а Иаков назвал его Галаадом. ");
INSERT INTO russyn_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","И сказал Лаван Иакову: сегодня этот холм и памятник, который я поставил, между мною и тобою свидетель. Посему и наречено ему имя: Галаад, ");
INSERT INTO russyn_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","также: Мицпа, оттого, что Лаван сказал: да надзирает Господь надо мною и над тобою, когда мы скроемся друг от друга; ");
INSERT INTO russyn_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","если ты будешь худо поступать с дочерями моими, или если возьмешь жен сверх дочерей моих, то, хотя нет человека между нами, который бы видел, но смотри, Бог свидетель между мною и между тобою. ");
INSERT INTO russyn_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","И сказал Лаван Иакову: вот холм сей и вот памятник, который я поставил между мною и тобою; ");
INSERT INTO russyn_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","этот холм свидетель, и этот памятник свидетель, что ни я не перейду к тебе за этот холм, ни ты не перейдешь ко мне за этот холм и за этот памятник, для зла; ");
INSERT INTO russyn_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Бог Авраамов и Бог Нахоров да судит между нами, Бог отца их. Иаков поклялся страхом отца своего Исаака. ");
INSERT INTO russyn_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","И заколол Иаков жертву на горе и позвал родственников своих есть хлеб; и они ели хлеб и пили и ночевали на горе. ");
INSERT INTO russyn_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","И встал Лаван рано утром и поцеловал внуков своих и дочерей своих, и благословил их. И пошел и возвратился Лаван в свое место. ");
INSERT INTO russyn_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","А Иаков пошел путем своим. И, взглянув, увидел ополчение Божие ополчившееся. И встретили его Ангелы Божии. ");
INSERT INTO russyn_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Иаков, увидев их, сказал: это ополчение Божие. И нарек имя месту тому: Маханаим. ");
INSERT INTO russyn_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","И послал Иаков пред собою вестников к брату своему Исаву в землю Сеир, в область Едом, ");
INSERT INTO russyn_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","и приказал им, сказав: так скажите господину моему Исаву: вот что говорит раб твой Иаков: я жил у Лавана и прожил доныне; ");
INSERT INTO russyn_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","и есть у меня волы и ослы и мелкий скот, и рабы и рабыни; и я послал известить о себе господина моего Исава, дабы приобрести рабу твоему благоволение пред очами твоими. ");
INSERT INTO russyn_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","И возвратились вестники к Иакову и сказали: мы ходили к брату твоему Исаву; он идет навстречу тебе, и с ним четыреста человек. ");
INSERT INTO russyn_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Иаков очень испугался и смутился; и разделил людей, бывших с ним, и скот мелкий и крупный и верблюдов на два стана. ");
INSERT INTO russyn_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","И сказал Иаков: если Исав нападет на один стан и побьет его, то остальной стан может спастись. ");
INSERT INTO russyn_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","И сказал Иаков: Боже отца моего Авраама и Боже отца моего Исаака, Господи Боже, сказавший мне: возвратись в землю твою, на родину твою, и Я буду благотворить тебе! ");
INSERT INTO russyn_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Недостоин я всех милостей и всех благодеяний, которые Ты сотворил рабу Твоему, ибо я с посохом моим перешел этот Иордан, а теперь у меня два стана. ");
INSERT INTO russyn_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Избавь меня от руки брата моего, от руки Исава, ибо я боюсь его, чтобы он, придя, не убил меня и матери с детьми. ");
INSERT INTO russyn_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ты сказал: Я буду благотворить тебе и сделаю потомство твое, как песок морской, которого не исчислить от множества. ");
INSERT INTO russyn_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","И ночевал там Иаков в ту ночь. И взял из того, что у него было, и послал в подарок Исаву, брату своему: ");
INSERT INTO russyn_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","двести коз, двадцать козлов, двести овец, двадцать овнов, ");
INSERT INTO russyn_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","тридцать верблюдиц дойных с жеребятами их, сорок коров, десять волов, двадцать ослиц, десять ослов. ");
INSERT INTO russyn_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","И дал в руки рабам своим каждое стадо особо и сказал рабам своим: пойдите предо мною и оставляйте расстояние от стада до стада. ");
INSERT INTO russyn_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","И приказал первому, сказав: когда брат мой Исав встретится тебе и спросит тебя, говоря: чей ты? и куда идешь? и чье это стадо идет пред тобою? ");
INSERT INTO russyn_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","то скажи: раба твоего Иакова; это подарок, посланный господину моему Исаву; вот, и сам он за нами идет. ");
INSERT INTO russyn_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","То же что первому приказал он и второму, и третьему, и всем, которые шли за стадами, говоря: так скажите Исаву, когда встретите его; ");
INSERT INTO russyn_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","и скажите: вот, и раб твой Иаков идет за нами. Ибо он сказал сам в себе: умилостивлю его дарами, которые идут предо мною, и потом увижу лице его; может быть, и примет меня. ");
INSERT INTO russyn_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","И пошли дары пред ним, а он ту ночь ночевал в стане. ");
INSERT INTO russyn_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","И встал в ту ночь, и, взяв двух жен своих и двух рабынь своих, и одиннадцать сынов своих, перешел через Иавок вброд; ");
INSERT INTO russyn_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","и, взяв их, перевел через поток, и перевел все, что у него было. ");
INSERT INTO russyn_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","И остался Иаков один. И боролся Некто с ним до появления зари; ");
INSERT INTO russyn_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","и, увидев, что не одолевает его, коснулся состава бедра его и повредил состав бедра у Иакова, когда он боролся с Ним. ");
INSERT INTO russyn_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","И сказал ему: отпусти Меня, ибо взошла заря. Иаков сказал: не отпущу Тебя, пока не благословишь меня. ");
INSERT INTO russyn_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","И сказал: как имя твое? Он сказал: Иаков. ");
INSERT INTO russyn_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","И сказал ему: отныне имя тебе будет не Иаков, а Израиль, ибо ты боролся с Богом, и человеков одолевать будешь. ");
INSERT INTO russyn_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Спросил и Иаков, говоря: скажи мне имя Твое. И Он сказал: на что ты спрашиваешь о имени Моем? оно чудно. И благословил его там. ");
INSERT INTO russyn_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","И нарек Иаков имя месту тому: Пенуэл; ибо, говорил он, я видел Бога лицем к лицу, и сохранилась душа моя. ");
INSERT INTO russyn_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","И взошло солнце, когда он проходил Пенуэл; и хромал он на бедро свое. ");
INSERT INTO russyn_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Поэтому и доныне сыны Израилевы не едят жилы, которая на составе бедра, потому что Боровшийся коснулся жилы на составе бедра Иакова. ");
INSERT INTO russyn_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Взглянул Иаков и увидел, и вот, идет Исав, брат его, и с ним четыреста человек. И разделил Иаков детей Лии, Рахили и двух служанок. ");
INSERT INTO russyn_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","И поставил двух служанок и детей их впереди, Лию и детей ее за ними, а Рахиль и Иосифа позади. ");
INSERT INTO russyn_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","А сам пошел пред ними и поклонился до земли семь раз, подходя к брату своему. ");
INSERT INTO russyn_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","И побежал Исав к нему навстречу и обнял его, и пал на шею его и целовал его, и плакали оба. ");
INSERT INTO russyn_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","И взглянул Исав и увидел жен и детей и сказал: кто это у тебя? Иаков сказал: дети, которых Бог даровал рабу твоему.” ");
INSERT INTO russyn_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","И подошли служанки и дети их и поклонились; ");
INSERT INTO russyn_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","подошла и Лия и дети ее и поклонились; наконец подошли Иосиф и Рахиль и поклонились. ");
INSERT INTO russyn_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","И сказал Исав: для чего у тебя это множество, которое я встретил? И сказал Иаков: дабы рабу твоему приобрести благоволение в очах господина моего. ");
INSERT INTO russyn_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Исав сказал: у меня много, брат мой; пусть будет твое у тебя. ");
INSERT INTO russyn_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Иаков сказал: нет, если я приобрел благоволение в очах твоих, прими дар мой от руки моей, ибо я увидел лице твое, как бы кто увидел лице Божие, и ты был благосклонен ко мне; ");
INSERT INTO russyn_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","прими благословение мое, которое я принес тебе, потому что Бог даровал мне, и есть у меня все. И упросил его, и тот взял ");
INSERT INTO russyn_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","и сказал: поднимемся и пойдем; и я пойду пред тобою. ");
INSERT INTO russyn_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Иаков сказал ему: господин мой знает, что дети нежны, а мелкий и крупный скот у меня дойный: если погнать его один день, то помрет весь скот; ");
INSERT INTO russyn_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","пусть господин мой пойдет впереди раба своего, а я пойду медленно, как пойдет скот, который предо мною, и как пойдут дети, и приду к господину моему в Сеир. ");
INSERT INTO russyn_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Исав сказал: оставлю я с тобою несколько из людей, которые при мне. Иаков сказал: к чему это? только бы мне приобрести благоволение в очах господина моего! ");
INSERT INTO russyn_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","И возвратился Исав в тот же день путем своим в Сеир. ");
INSERT INTO russyn_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","А Иаков двинулся в Сокхоф, и построил себе дом, и для скота своего сделал шалаши. От сего он нарек имя месту: Сокхоф. ");
INSERT INTO russyn_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Иаков, возвратившись из Месопотамии, благополучно пришел в город Сихем, который в земле Ханаанской, и расположился пред городом. ");
INSERT INTO russyn_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","И купил часть поля, на котором раскинул шатер свой, у сынов Еммора, отца Сихемова, за сто монет. ");
INSERT INTO russyn_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","И поставил там жертвенник, и призвал имя Господа Бога Израилева. ");
INSERT INTO russyn_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Дина, дочь Лии, которую она родила Иакову, вышла посмотреть на дочерей земли той. ");
INSERT INTO russyn_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","И увидел ее Сихем, сын Еммора Евеянина, князя земли той, и взял ее, и спал с нею, и сделал ей насилие. ");
INSERT INTO russyn_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","И прилепилась душа его к Дине, дочери Иакова, и он полюбил девицу и говорил по сердцу девицы. ");
INSERT INTO russyn_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","И сказал Сихем Еммору, отцу своему, говоря: возьми мне эту девицу в жену. ");
INSERT INTO russyn_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Иаков слышал, что сын Емморов обесчестил Дину, дочь его, но как сыновья его были со скотом его в поле, то Иаков молчал, пока не пришли они. ");
INSERT INTO russyn_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","И вышел Еммор, отец Сихемов, к Иакову, поговорить с ним. ");
INSERT INTO russyn_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Сыновья же Иакова пришли с поля, и когда услышали, то огорчились мужи те и воспылали гневом, потому что бесчестие сделал он Израилю, переспав с дочерью Иакова, а так не надлежало делать. ");
INSERT INTO russyn_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Еммор стал говорить им, и сказал: Сихем, сын мой, прилепился душею к дочери вашей; дайте же ее в жену ему; ");
INSERT INTO russyn_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","породнитесь с нами; отдавайте за нас дочерей ваших, а наших дочерей берите себе за сыновей ваших; ");
INSERT INTO russyn_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","и живите с нами; земля сия пространна пред вами, живите и промышляйте на ней и приобретайте ее во владение. ");
INSERT INTO russyn_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Сихем же сказал отцу ее и братьям ее: только бы мне найти благоволение в очах ваших, я дам, что ни скажете мне; ");
INSERT INTO russyn_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","назначьте самое большое вено и дары; я дам, что ни скажете мне, только отдайте мне девицу в жену. ");
INSERT INTO russyn_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","И отвечали сыновья Иакова Сихему и Еммору, отцу его, с лукавством; а говорили так потому, что он обесчестил Дину, сестру их; ");
INSERT INTO russyn_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","и сказали им Симеон и Левий, братья Дины, сыновья Лиины: не можем этого сделать, выдать сестру нашу за человека, который необрезан, ибо это бесчестно для нас; ");
INSERT INTO russyn_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","только на том условии мы согласимся с вами и поселимся у вас, если вы будете как мы, чтобы и у вас весь мужеский пол был обрезан; ");
INSERT INTO russyn_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","и будем отдавать за вас дочерей наших и брать за себя ваших дочерей, и будем жить с вами, и составим один народ; ");
INSERT INTO russyn_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","а если не послушаетесь нас в том, чтобы обрезаться, то мы возьмем дочь нашу и удалимся. ");
INSERT INTO russyn_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","И понравились слова сии Еммору и Сихему, сыну Емморову. ");
INSERT INTO russyn_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Юноша не умедлил исполнить это, потому что любил дочь Иакова. А он более всех уважаем был из дома отца своего. ");
INSERT INTO russyn_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","И пришел Еммор и Сихем, сын его, к воротам города своего, и стали говорить жителям города своего и сказали: ");
INSERT INTO russyn_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","сии люди мирны с нами; пусть они селятся на земле и промышляют на ней; земля же вот пространна пред ними. Станем брать дочерей их себе в жены и наших дочерей выдавать за них. ");
INSERT INTO russyn_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Только на том условии сии люди соглашаются жить с нами и быть одним народом, чтобы и у нас обрезан был весь мужеский пол, как они обрезаны. ");
INSERT INTO russyn_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Не для нас ли стада их, и имение их, и весь скот их? Только в том согласимся с ними, и будут жить с нами. ");
INSERT INTO russyn_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","И послушались Еммора и Сихема, сына его, все выходящие из ворот города его: и обрезан был весь мужеский пол,- все выходящие из ворот города его. ");
INSERT INTO russyn_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","На третий день, когда они были в болезни, два сына Иакова, Симеон и Левий, братья Динины, взяли каждый свой меч, и смело напали на город, и умертвили весь мужеский пол; ");
INSERT INTO russyn_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","и самого Еммора и Сихема, сына его, убили мечом; и взяли Дину из дома Сихемова и вышли. ");
INSERT INTO russyn_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Сыновья Иакова пришли к убитым и разграбили город за то, что обесчестили Дину сестру их. ");
INSERT INTO russyn_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Они взяли мелкий и крупный скот их, и ослов их, и что ни было в городе, и что ни было в поле; ");
INSERT INTO russyn_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","и все богатство их, и всех детей их, и жен их взяли в плен, и разграбили все, что было в городе, и все, что было в домах. ");
INSERT INTO russyn_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","И сказал Иаков Симеону и Левию: вы возмутили меня, сделав меня ненавистным для всех жителей сей земли, для Хананеев и Ферезеев. У меня людей мало; соберутся против меня, поразят меня, и истреблен буду я и дом мой. ");
INSERT INTO russyn_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Они же сказали: а разве можно поступать с сестрою нашею, как с блудницею! ");
INSERT INTO russyn_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Бог сказал Иакову: встань, пойди в Вефиль и живи там, и устрой там жертвенник Богу, явившемуся тебе, когда ты бежал от лица Исава, брата твоего. ");
INSERT INTO russyn_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","И сказал Иаков дому своему и всем бывшим с ним: бросьте богов чужих, находящихся у вас, и очиститесь, и перемените одежды ваши; ");
INSERT INTO russyn_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","встанем и пойдем в Вефиль; там устрою я жертвенник Богу, Который услышал меня в день бедствия моего и был со мною и хранил меня в пути, которым я ходил. ");
INSERT INTO russyn_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","И отдали Иакову всех богов чужих, бывших в руках их, и серьги, бывшие в ушах у них, и закопал их Иаков под дубом, который близ Сихема. ");
INSERT INTO russyn_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","И отправились они от Сихема. И был ужас Божий на окрестных городах, и не преследовали сынов Иаковлевых. ");
INSERT INTO russyn_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","И пришел Иаков в Луз, что в земле Ханаанской, то есть в Вефиль, сам и все люди, бывшие с ним, ");
INSERT INTO russyn_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","и устроил там жертвенник, и назвал сие место: Эл-Вефиль, ибо тут явился ему Бог, когда он бежал от лица Исава брата своего. ");
INSERT INTO russyn_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","И умерла Девора, кормилица Ревеккина, и погребена ниже Вефиля под дубом, который и назвал Иаков дубом плача. ");
INSERT INTO russyn_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","И явился Бог Иакову в Лузе по возвращении его из Месопотамии, и благословил его, ");
INSERT INTO russyn_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","и сказал ему Бог: имя твое Иаков; отныне ты не будешь называться Иаковом, но будет имя тебе: Израиль. И нарек ему имя: Израиль. ");
INSERT INTO russyn_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","И сказал ему Бог: Я Бог Всемогущий; плодись и умножайся; народ и множество народов будет от тебя, и цари произойдут из чресл твоих; ");
INSERT INTO russyn_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","землю, которую Я дал Аврааму и Исааку, Я дам тебе, и потомству твоему по тебе дам землю сию. ");
INSERT INTO russyn_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","И восшел от него Бог с места, на котором говорил ему. ");
INSERT INTO russyn_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","И поставил Иаков памятник на месте, на котором говорил ему Бог, памятник каменный, и возлил на него возлияние, и возлил на него елей; ");
INSERT INTO russyn_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","и нарек Иаков имя месту, на котором Бог говорил ему: Вефиль. ");
INSERT INTO russyn_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","И отправились из Вефиля. И раскинул он шатер свой за башнею Гадер. И когда еще оставалось некоторое расстояние земли до Ефрафы, Рахиль родила, и роды ее были трудны. ");
INSERT INTO russyn_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Когда же она страдала в родах, повивальная бабка сказала ей: не бойся, ибо и это тебе сын. ");
INSERT INTO russyn_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","И когда выходила из нее душа, ибо она умирала, то нарекла ему имя: Бенони. Но отец его назвал его Вениамином. ");
INSERT INTO russyn_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","И умерла Рахиль, и погребена на дороге в Ефрафу, то есть Вифлеем. ");
INSERT INTO russyn_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Иаков поставил над гробом ее памятник. Это надгробный памятник Рахили до сего дня. ");
INSERT INTO russyn_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","И отправился оттуда Израиль и раскинул шатер свой за башнею Гадер. ");
INSERT INTO russyn_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Во время пребывания Израиля в той стране, Рувим пошел и переспал с Валлою, наложницею отца своего. И услышал Израиль. Сынов же у Иакова было двенадцать. ");
INSERT INTO russyn_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Сыновья Лии: первенец Иакова Рувим, по нем Симеон, Левий, Иуда, Иссахар и Завулон. ");
INSERT INTO russyn_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Сыновья Рахили: Иосиф и Вениамин. ");
INSERT INTO russyn_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Сыновья Валлы, служанки Рахилиной: Дан и Неффалим. ");
INSERT INTO russyn_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Сыновья Зелфы, служанки Лииной: Гад и Асир. Сии сыновья Иакова, родившиеся ему в Месопотамии. ");
INSERT INTO russyn_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","И пришел Иаков к Исааку, отцу своему, ибо он был еще жив, в Мамре, в Кириаф-Арбу, то есть Хеврон в земле Ханаанской, где странствовал Авраам и Исаак. ");
INSERT INTO russyn_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","И было дней жизни Исааковой сто восемьдесят лет. ");
INSERT INTO russyn_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","И испустил Исаак дух и умер, и приложился к народу своему, будучи стар и насыщен жизнью; и погребли его Исав и Иаков, сыновья его. ");
INSERT INTO russyn_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Вот родословие Исава, он же Едом. ");
INSERT INTO russyn_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Исав взял себе жен из дочерей Ханаанских: Аду, дочь Елона Хеттеянина, и Оливему, дочь Аны, сына Цивеона Евеянина, ");
INSERT INTO russyn_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","и Васемафу, дочь Измаила, сестру Наваиофа. ");
INSERT INTO russyn_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ада родила Исаву Елифаза, Васемафа родила Рагуила, ");
INSERT INTO russyn_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Оливема родила Иеуса, Иеглома и Корея. Это сыновья Исава, родившиеся ему в земле Ханаанской. ");
INSERT INTO russyn_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","И взял Исав жен своих и сыновей своих, и дочерей своих, и всех людей дома своего, и все стада свои, и весь скот свой, и все имение свое, которое он приобрел в земле Ханаанской, и пошел Исав в другую землю от лица Иакова, брата своего, ");
INSERT INTO russyn_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","ибо имение их было так велико, что они не могли жить вместе, и земля странствования их не вмещала их, по множеству стад их. ");
INSERT INTO russyn_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","И поселился Исав на горе Сеир, Исав, он же Едом. ");
INSERT INTO russyn_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","И вот родословие Исава, отца Идумеев, на горе Сеир. ");
INSERT INTO russyn_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Вот имена сынов Исава: Елифаз, сын Ады, жены Исавовой, и Рагуил, сын Васемафы, жены Исавовой. ");
INSERT INTO russyn_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","У Елифаза были сыновья: Феман, Омар, Цефо, Гафам и Кеназ. ");
INSERT INTO russyn_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Фамна же была наложница Елифаза, сына Исавова, и родила Елифазу Амалика. Вот сыновья Ады, жены Исавовой. ");
INSERT INTO russyn_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","И вот сыновья Рагуила: Нахаф и Зерах, Шамма и Миза. Это сыновья Васемафы, жены Исавовой. ");
INSERT INTO russyn_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","И сии были сыновья Оливемы, дочери Аны, сына Цивеонова, жены Исавовой: она родила Исаву Иеуса, Иеглома и Корея. ");
INSERT INTO russyn_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Вот старейшины сынов Исавовых. Сыновья Елифаза, первенца Исавова: старейшина Феман, старейшина Омар, старейшина Цефо, старейшина Кеназ, ");
INSERT INTO russyn_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","старейшина Корей, старейшина Гафам, старейшина Амалик. Сии старейшины Елифазовы в земле Едома; сии сыновья Ады. ");
INSERT INTO russyn_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Сии сыновья Рагуила, сына Исавова: старейшина Нахаф, старейшина Зерах, старейшина Шамма, старейшина Миза. Сии старейшины Рагуиловы в земле Едома; сии сыновья Васемафы, жены Исавовой. ");
INSERT INTO russyn_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Сии сыновя Оливеммы, жены Исавовой: старейшина Иеус, старейшина Иеглом, старейшина Корей. Сии старейшины Оливемы, дочери Аны, жены Исавовой. ");
INSERT INTO russyn_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Вот сыновья Исава, и вот старейшины их. Это Едом. ");
INSERT INTO russyn_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Сии сыновья Сеира Хорреянина, жившие в земле той: Лотан, Шовал, Цивеон, Ана, ");
INSERT INTO russyn_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Дишон, Эцер и Дишан. Сии старейшины Хорреев, сынов Сеира, в земле Едома. ");
INSERT INTO russyn_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Сыновья Лотана были: Хори и Геман; а сестра у Лотана: Фамна. ");
INSERT INTO russyn_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Сии сыновья Шовала: Алван, Манахаф, Эвал, Шефо и Онам. ");
INSERT INTO russyn_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Сии сыновья Цивеона: Аиа и Ана. Это тот Ана, который нашел теплые воды в пустыне, когда пас ослов Цивеона, отца своего. ");
INSERT INTO russyn_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Сии дети Аны: Дишон и Оливема, дочь Аны. ");
INSERT INTO russyn_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Сии сыновья Дишона: Хемдан, Эшбан, Ифран и Херан. ");
INSERT INTO russyn_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Сии сыновья Эцера: Билган, Зааван, Укам и Акан. ");
INSERT INTO russyn_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Сии сыновья Дишана: Уц и Аран. ");
INSERT INTO russyn_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Сии старейшины Хорреев: старейшина Лотан, старейшина Шовал, старейшина Цивеон, старейшина Ана, ");
INSERT INTO russyn_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","старейшина Дишон, старейшина Эцер, старейшина Дишан. Вот старейшины Хорреев, по старшинствам их в земле Сеир. ");
INSERT INTO russyn_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Вот цари, царствовавшие в земле Едома, прежде царствования царей у сынов Израилевых: ");
INSERT INTO russyn_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","царствовал в Едоме Бела, сын Веоров, а имя городу его Дингава. ");
INSERT INTO russyn_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","И умер Бела, и воцарился по нем Иовав, сын Зераха, из Восоры. ");
INSERT INTO russyn_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Умер Иовав, и воцарился по нем Хушам, из земли Феманитян. ");
INSERT INTO russyn_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","И умер Хушам, и воцарился по нем Гадад, сын Бедадов, который поразил Мадианитян на поле Моава; имя городу его Авиф. ");
INSERT INTO russyn_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","И умер Гадад, и воцарился по нем Самла из Масреки. ");
INSERT INTO russyn_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","И умер Самла, и воцарился по нем Саул из Реховофа, что при реке. ");
INSERT INTO russyn_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","И умер Саул, и воцарился по нем Баал-Ханан, сын Ахбора. ");
INSERT INTO russyn_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","И умер Баал-Ханан, сын Ахбора, и воцарился по нем Гадар сын Варадов; имя городу его Пау; имя жене его Мегетавеель, дочь Матреды, сына Мезагава. ");
INSERT INTO russyn_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Сии имена старейшин Исавовых, по племенам их, по местам их, по именам их, по народам их: старейшина Фимна, старейшина Алва, старейшина Иетеф, ");
INSERT INTO russyn_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","старейшина Оливема, старейшина Эла, старейшина Пинон, ");
INSERT INTO russyn_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","старейшина Кеназ, старейшина Феман, старейшина Мивцар, ");
INSERT INTO russyn_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","старейшина Магдиил, старейшина Ирам. Вот старейшины Идумейские, по их селениям, в земле обладания их. Вот Исав, отец Идумеев. ");
INSERT INTO russyn_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Иаков жил в земле странствования отца своего Исаака, в земле Ханаанской. ");
INSERT INTO russyn_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Вот житие Иакова. Иосиф, семнадцати лет, пас скот отца своего вместе с братьями своими, будучи отроком, с сыновьями Валлы и с сыновьями Зелфы, жен отца своего. И доводил Иосиф худые о них слухи до Израиля, отца их. ");
INSERT INTO russyn_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Израиль любил Иосифа более всех сыновей своих, потому что он был сын старости его,- и сделал ему разноцветную одежду. ");
INSERT INTO russyn_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","И увидели братья его, что отец их любит его более всех братьев его; и возненавидели его и не могли говорить с ним дружелюбно. ");
INSERT INTO russyn_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","И видел Иосиф сон, и рассказал его братьям своим: и они возненавидели его еще более. ");
INSERT INTO russyn_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Он сказал им: выслушайте сон, который я видел: ");
INSERT INTO russyn_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","вот, мы вяжем снопы посреди поля; и вот, мой сноп встал и стал прямо; и вот, ваши снопы стали кругом и поклонились моему снопу. ");
INSERT INTO russyn_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","И сказали ему братья его: неужели ты будешь царствовать над нами? неужели будешь владеть нами? И возненавидели его еще более за сны его и за слова его. ");
INSERT INTO russyn_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","И видел он еще другой сон и рассказал его отцу своему и братьям своим, говоря: вот, я видел еще сон: вот, солнце и луна и одиннадцать звезд поклоняются мне. ");
INSERT INTO russyn_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","И он рассказал отцу своему и братьям своим; и побранил его отец его и сказал ему: что это за сон, который ты видел? неужели я и твоя мать, и твои братья придем поклониться тебе до земли? ");
INSERT INTO russyn_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Братья его досадовали на него, а отец его заметил это слово. ");
INSERT INTO russyn_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Братья его пошли пасти скот отца своего в Сихем. ");
INSERT INTO russyn_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","И сказал Израиль Иосифу: братья твои не пасут ли в Сихеме? пойди, я пошлю тебя к ним. Он отвечал ему: вот я. ");
INSERT INTO russyn_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Израиль сказал ему: пойди, посмотри, здоровы ли братья твои и цел ли скот, и принеси мне ответ. И послал его из долины Хевронской; и он пришел в Сихем. ");
INSERT INTO russyn_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","И нашел его некто блуждающим в поле, и спросил его тот человек, говоря: чего ты ищешь? ");
INSERT INTO russyn_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Он сказал: я ищу братьев моих; скажи мне, где они пасут? ");
INSERT INTO russyn_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","И сказал тот человек: они ушли отсюда, ибо я слышал, как они говорили: пойдем в Дофан. И пошел Иосиф за братьями своими и нашел их в Дофане. ");
INSERT INTO russyn_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","И увидели они его издали, и прежде нежели он приблизился к ним, стали умышлять против него, чтобы убить его. ");
INSERT INTO russyn_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","И сказали друг другу: вот, идет сновидец; ");
INSERT INTO russyn_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","пойдем теперь, и убьем его, и бросим его в какой-нибудь ров, и скажем, что хищный зверь съел его; и увидим, что будет из его снов. ");
INSERT INTO russyn_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","И услышал сие Рувим и избавил его от рук их, сказав: не убьем его. ");
INSERT INTO russyn_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","И сказал им Рувим: не проливайте крови; бросьте его в ров, который в пустыне, а руки не налагайте на него. Сие говорил он с тем намерением, чтобы избавить его от рук их и возвратить его к отцу его. ");
INSERT INTO russyn_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Когда Иосиф пришел к братьям своим, они сняли с Иосифа одежду его, одежду разноцветную, которая была на нем, ");
INSERT INTO russyn_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","и взяли его и бросили его в ров; ров же тот был пуст; воды в нем не было. ");
INSERT INTO russyn_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","И сели они есть хлеб, и, взглянув, увидели, вот, идет из Галаада караван Измаильтян, и верблюды их несут стираксу, бальзам и ладан: идут они отвезти это в Египет. ");
INSERT INTO russyn_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","И сказал Иуда братьям своим: что пользы, если мы убьем брата нашего и скроем кровь его? ");
INSERT INTO russyn_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Пойдем, продадим его Измаильтянам, а руки наши да не будут на нем, ибо он брат наш, плоть наша. Братья его послушались ");
INSERT INTO russyn_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","и, когда проходили купцы Мадиамские, вытащили Иосифа изо рва и продали Иосифа Измаильтянам за двадцать сребренников; а они отвели Иосифа в Египет. ");
INSERT INTO russyn_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Рувим же пришел опять ко рву; и вот, нет Иосифа во рве. И разодрал он одежды свои, ");
INSERT INTO russyn_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","и возвратился к братьям своим, и сказал: отрока нет, а я, куда я денусь? ");
INSERT INTO russyn_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","И взяли одежду Иосифа, и закололи козла, и вымарали одежду кровью; ");
INSERT INTO russyn_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","и послали разноцветную одежду, и доставили к отцу своему, и сказали: мы это нашли; посмотри, сына ли твоего эта одежда, или нет. ");
INSERT INTO russyn_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Он узнал ее и сказал: это одежда сына моего; хищный зверь съел его; верно, растерзан Иосиф. ");
INSERT INTO russyn_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","И разодрал Иаков одежды свои, и возложил вретище на чресла свои, и оплакивал сына своего многие дни. ");
INSERT INTO russyn_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","И собрались все сыновья его и все дочери его, чтобы утешить его; но он не хотел утешиться и сказал: с печалью сойду к сыну моему в преисподнюю. Так оплакивал его отец его. ");
INSERT INTO russyn_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Мадианитяне же продали его в Египте Потифару, царедворцу фараонову, начальнику телохранителей. ");
INSERT INTO russyn_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","В то время Иуда отошел от братьев своих и поселился близ одного Одолламитянина, которому имя: Хира. ");
INSERT INTO russyn_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","И увидел там Иуда дочь одного Хананеянина, которому имя: Шуа; и взял ее и вошел к ней. ");
INSERT INTO russyn_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Она зачала и родила сына; и он нарек ему имя: Ир. ");
INSERT INTO russyn_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","И зачала опять, и родила сына, и нарекла ему имя: Онан. ");
INSERT INTO russyn_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","И еще родила сына третьего и нарекла ему имя: Шела. Иуда был в Хезиве, когда она родила его. ");
INSERT INTO russyn_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","И взял Иуда жену Иру, первенцу своему; имя ей Фамарь. ");
INSERT INTO russyn_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ир, первенец Иудин, был неугоден пред очами Господа, и умертвил его Господь. ");
INSERT INTO russyn_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","И сказал Иуда Онану: войди к жене брата твоего, женись на ней, как деверь, и восстанови семя брату твоему. ");
INSERT INTO russyn_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Онан знал, что семя будет не ему, и потому, когда входил к жене брата своего, изливал семя на землю, чтобы не дать семени брату своему. ");
INSERT INTO russyn_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Зло было пред очами Господа то, что он делал; и Он умертвил и его. ");
INSERT INTO russyn_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","И сказал Иуда Фамари, невестке своей по смерти двух сыновей своих: живи вдовою в доме отца твоего, пока подрастет Шела, сын мой. Ибо он сказал в уме своем: не умер бы и он подобно братьям его. Фамарь пошла и стала жить в доме отца своего. ");
INSERT INTO russyn_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Прошло много времени, и умерла дочь Шуи, жена Иудина. Иуда, утешившись, пошел в Фамну к стригущим скот его, сам и Хира, друг его, Одолламитянин. ");
INSERT INTO russyn_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","И уведомили Фамарь, говоря: вот, свекор твой идет в Фамну стричь скот свой. ");
INSERT INTO russyn_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","И сняла она с себя одежду вдовства своего, покрыла себя покрывалом и, закрывшись, села у ворот Енаима, что на дороге в Фамну. Ибо видела, что Шела вырос, и она не дана ему в жену. ");
INSERT INTO russyn_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","И увидел ее Иуда и почел ее за блудницу, потому что она закрыла лице свое. И не узнал ее. ");
INSERT INTO russyn_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Он поворотил к ней и сказал: войду я к тебе. Ибо не знал, что это невестка его. Она сказала: что ты дашь мне, если войдешь ко мне? ");
INSERT INTO russyn_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Он сказал: я пришлю тебе козленка из стада моего. Она сказала: дашь ли ты мне залог, пока пришлешь? ");
INSERT INTO russyn_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Он сказал: какой дать тебе залог? Она сказала: печать твою, и перевязь твою, и трость твою, которая в руке твоей. И дал он ей и вошел к ней; и она зачала от него. ");
INSERT INTO russyn_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","И, встав, пошла, сняла с себя покрывало свое и оделась в одежду вдовства своего. ");
INSERT INTO russyn_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Иуда же послал козленка чрез друга своего Одолламитянина, чтобы взять залог из руки женщины, но он не нашел ее. ");
INSERT INTO russyn_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","И спросил жителей того места, говоря: где блудница, которая была в Енаиме при дороге? Но они сказали: здесь не было блудницы. ");
INSERT INTO russyn_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","И возвратился он к Иуде и сказал: я не нашел ее; да и жители места того сказали: здесь не было блудницы. ");
INSERT INTO russyn_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Иуда сказал: пусть она возьмет себе, чтобы только не стали над нами смеяться; вот, я посылал этого козленка, но ты не нашел ее. ");
INSERT INTO russyn_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Прошло около трех месяцев, и сказали Иуде, говоря: Фамарь, невестка твоя, впала в блуд, и вот, она беременна от блуда. Иуда сказал: выведите ее, и пусть она будет сожжена. ");
INSERT INTO russyn_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Но когда повели ее, она послала сказать свекру своему: я беременна от того, чьи эти вещи. И сказала: узнавай, чья эта печать и перевязь и трость. ");
INSERT INTO russyn_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Иуда узнал и сказал: она правее меня, потому что я не дал ее Шеле, сыну моему. И не познавал ее более. ");
INSERT INTO russyn_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Во время родов ее оказалось, что близнецы в утробе ее. ");
INSERT INTO russyn_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","И во время родов ее показалась рука одного; и взяла повивальная бабка и навязала ему на руку красную нить, сказав: этот вышел первый. ");
INSERT INTO russyn_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Но он возвратил руку свою; и вот, вышел брат его. И она сказала: как ты расторг себе преграду? И наречено ему имя: Фарес. ");
INSERT INTO russyn_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Потом вышел брат его с красной нитью на руке. И наречено ему имя: Зара. ");
INSERT INTO russyn_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Иосиф же отведен был в Египет, и купил его из рук Измаильтян, приведших его туда, Египтянин Потифар, царедворец фараонов, начальник тело-хранителей. ");
INSERT INTO russyn_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","И был Господь с Иосифом: он был успешен в делах и жил в доме господина своего, Египтянина. ");
INSERT INTO russyn_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","И увидел господин его, что Господь с ним и что всему, что он делает, Господь в руках его дает успех. ");
INSERT INTO russyn_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","И снискал Иосиф благоволение в очах его и служил ему. И он поставил его над домом своим, и все, что имел, отдал на руки его. ");
INSERT INTO russyn_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","И с того времени, как он поставил его над домом своим и над всем, что имел, Господь благословил дом Египтянина ради Иосифа, и было благословение Господне на всем, что имел он в доме и в поле его. ");
INSERT INTO russyn_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","И оставил он все, что имел, в руках Иосифа и не знал при нем ничего, кроме хлеба, который он ел. Иосиф же был красив станом и красив лицем. ");
INSERT INTO russyn_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","И обратила взоры на Иосифа жена господина его и сказала: спи со мною. ");
INSERT INTO russyn_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Но он отказался и сказал жене господина своего: вот, господин мой не знает при мне ничего в доме, и все, что имеет, отдал в мои руки; ");
INSERT INTO russyn_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","нет больше меня в доме сем; и он не запретил мне ничего, кроме тебя, потому что ты жена ему; как же сделаю я сие великое зло и согрешу пред Богом? ");
INSERT INTO russyn_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Когда так она ежедневно говорила Иосифу, а он не слушался ее, чтобы спать с нею и быть с нею, ");
INSERT INTO russyn_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","случилось в один день, что он вошел в дом делать дело свое, а никого из домашних тут в доме не было; ");
INSERT INTO russyn_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","она схватила его за одежду его и сказала: ложись со мной. Но он, оставив одежду свою в руках ее, побежал и выбежал вон. ");
INSERT INTO russyn_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Она же, увидев, что он оставил одежду свою в руках ее и побежал вон, ");
INSERT INTO russyn_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","кликнула домашних своих и сказала им так: посмотрите, он привел к нам Еврея ругаться над нами. Он пришел ко мне, чтобы лечь со мною, но я закричала громким голосом, ");
INSERT INTO russyn_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","и он, услышав, что я подняла вопль и закричала, оставил у меня одежду свою, и побежал, и выбежал вон. ");
INSERT INTO russyn_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","И оставила одежду его у себя до прихода господина его в дом свой. ");
INSERT INTO russyn_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","И пересказала ему те же слова, говоря: раб Еврей, которого ты привел к нам, приходил ко мне ругаться надо мною и говорил мне: лягу я с тобою, ");
INSERT INTO russyn_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","но, когда услышал, что я подняла вопль и закричала, он оставил у меня одежду свою и убежал вон. ");
INSERT INTO russyn_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Когда господин его услышал слова жены своей, которые она сказала ему, говоря: так поступил со мною раб твой, то воспылал гневом; ");
INSERT INTO russyn_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","и взял Иосифа господин его и отдал его в темницу, где заключены узники царя. И был он там в темнице. ");
INSERT INTO russyn_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","И Господь был с Иосифом, и простер к нему милость, и даровал ему благоволение в очах начальника темницы. ");
INSERT INTO russyn_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","И отдал начальник темницы в руки Иосифу всех узников, находившихся в темнице, и во всем, что они там ни делали, он был распорядителем. ");
INSERT INTO russyn_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Начальник темницы и не смотрел ни за чем, что было у него в руках, потому что Господь был с Иосифом, и во всем, что он делал, Господь давал успех. ");
INSERT INTO russyn_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","После сего виночерпий царя Египетского и хлебодар провинились пред господином своим, царем Египетским. ");
INSERT INTO russyn_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","И прогневался фараон на двух царедворцев своих, на главного виночерпия и на главного хлебодара, ");
INSERT INTO russyn_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","и отдал их под стражу в дом начальника телохранителей, в темницу, в место, где заключен был Иосиф. ");
INSERT INTO russyn_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Начальник телохранителей приставил к ним Иосифа, и он служил им. И пробыли они под стражею несколько времени. ");
INSERT INTO russyn_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Однажды виночерпию и хлебодару царя Египетского, заключенным в темнице, виделись сны, каждому свой сон, обоим в одну ночь, каждому сон особенного значения. ");
INSERT INTO russyn_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","И пришел к ним Иосиф поутру, увидел их, и вот, они в смущении. ");
INSERT INTO russyn_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","И спросил он царедворцев фараоновых, находившихся с ним в доме господина его под стражею, говоря: отчего у вас сегодня печальные лица? ");
INSERT INTO russyn_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Они сказали ему: нам виделись сны; а истолковать их некому. Иосиф сказал им: не от Бога ли истолкования? расскажите мне. ");
INSERT INTO russyn_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","И рассказал главный виночерпий Иосифу сон свой и сказал ему: мне снилось, вот виноградная лоза предо мною; ");
INSERT INTO russyn_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","на лозе три ветви; она развилась, показался на ней цвет, выросли и созрели на ней ягоды; ");
INSERT INTO russyn_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","и чаша фараонова в руке у меня; я взял ягод, выжал их в чашу фараонову и подал чашу в руку фараону. ");
INSERT INTO russyn_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","И сказал ему Иосиф: вот истолкование его: три ветви - это три дня; ");
INSERT INTO russyn_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","через три дня фараон вознесет главу твою и возвратит тебя на место твое, и ты подашь чашу фараонову в руку его, по прежнему обыкновению, когда ты был у него виночерпием; ");
INSERT INTO russyn_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","вспомни же меня, когда хорошо тебе будет, и сделай мне благодеяние, и упомяни обо мне фараону, и выведи меня из этого дома, ");
INSERT INTO russyn_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","ибо я украден из земли Евреев; а также и здесь ничего не сделал, за что бы бросить меня в темницу. ");
INSERT INTO russyn_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Главный хлебодар увидел, что истолковал он хорошо, и сказал Иосифу: мне также снилось: вот на голове у меня три корзины решетчатых; ");
INSERT INTO russyn_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","в верхней корзине всякая пища фараонова, изделие пекаря, и птицы небесные клевали ее из корзины на голове моей. ");
INSERT INTO russyn_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","И отвечал Иосиф и сказал ему: вот истолкование его: три корзины - это три дня; ");
INSERT INTO russyn_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","через три дня фараон снимет с тебя голову твою и повесит тебя на дереве, и птицы небесные будут клевать плоть твою с тебя. ");
INSERT INTO russyn_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","На третий день, день рождения фараонова, сделал он пир для всех слуг своих и вспомнил о главном виночерпии и главном хлебодаре среди слуг своих; ");
INSERT INTO russyn_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","и возвратил главного виночерпия на прежнее место, и он подал чашу в руку фараону, ");
INSERT INTO russyn_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","а главного хлебодара повесил на дереве, как истолковал им Иосиф. ");
INSERT INTO russyn_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","И не вспомнил главный виночерпий об Иосифе, но забыл его. ");
INSERT INTO russyn_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","По прошествии двух лет фараону снилось: вот, он стоит у реки; ");
INSERT INTO russyn_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","и вот, вышли из реки семь коров, хороших видом и тучных плотью, и паслись в тростнике; ");
INSERT INTO russyn_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","но вот, после них вышли из реки семь коров других, худых видом и тощих плотью, и стали подле тех коров, на берегу реки; ");
INSERT INTO russyn_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","и съели коровы худые видом и тощие плотью семь коров хороших видом и тучных. И проснулся фараон, ");
INSERT INTO russyn_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","и заснул опять, и снилось ему в другой раз: вот, на одном стебле поднялось семь колосьев тучных и хороших; ");
INSERT INTO russyn_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","но вот, после них выросло семь колосьев тощих и иссушенных восточным ветром; ");
INSERT INTO russyn_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","и пожрали тощие колосья семь колосьев тучных и полных. И проснулся фараон и понял, что это сон. ");
INSERT INTO russyn_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Утром смутился дух его, и послал он, и призвал всех волхвов Египта и всех мудрецов его, и рассказал им фараон сон свой; но не было никого, кто бы истолковал его фараону. ");
INSERT INTO russyn_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","И стал говорить главный виночерпий фараону и сказал: грехи мои вспоминаю я ныне; ");
INSERT INTO russyn_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","фараон прогневался на рабов своих и отдал меня и главного хлебодара под стражу в дом начальника телохранителей; ");
INSERT INTO russyn_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","и снился нам сон в одну ночь, мне и ему, каждому снился сон особенного значения; ");
INSERT INTO russyn_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","там же был с нами молодой Еврей, раб начальника телохранителей; мы рассказали ему сны наши, и он истолковал нам каждому соответственно с его сновидением; ");
INSERT INTO russyn_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","и как он истолковал нам, так и сбылось: я возвращен на место мое, а тот повешен. ");
INSERT INTO russyn_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","И послал фараон и позвал Иосифа. И поспешно вывели его из темницы. Он остригся и переменил одежду свою и пришел к фараону. ");
INSERT INTO russyn_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Фараон сказал Иосифу: мне снился сон, и нет никого, кто бы истолковал его, а о тебе я слышал, что ты умеешь толковать сны. ");
INSERT INTO russyn_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","И отвечал Иосиф фараону, говоря: это не мое; Бог даст ответ во благо фараону. ");
INSERT INTO russyn_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","И сказал фараон Иосифу: мне снилось: вот, стою я на берегу реки; ");
INSERT INTO russyn_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","и вот, вышли из реки семь коров тучных плотью и хороших видом и паслись в тростнике; ");
INSERT INTO russyn_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","но вот, после них вышли семь коров других, худых, очень дурных видом и тощих плотью: я не видывал во всей земле Египетской таких худых, как они; ");
INSERT INTO russyn_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","и съели тощие и худые коровы прежних семь коров тучных; ");
INSERT INTO russyn_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","и вошли тучные в утробу их, но не приметно было, что они вошли в утробу их: они были так же худы видом, как и сначала. И я проснулся. ");
INSERT INTO russyn_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Потом снилось мне: вот, на одном стебле поднялись семь колосьев полных и хороших; ");
INSERT INTO russyn_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","но вот, после них выросло семь колосьев тонких, тощих и иссушенных восточным ветром; ");
INSERT INTO russyn_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","и пожрали тощие колосья семь колосьев хороших. Я рассказал это волхвам, но никто не изъяснил мне. ");
INSERT INTO russyn_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","И сказал Иосиф фараону: сон фараонов один: что Бог сделает, то Он возвестил фараону. ");
INSERT INTO russyn_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Семь коров хороших, это семь лет; и семь колосьев хороших, это семь лет: сон один; ");
INSERT INTO russyn_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","и семь коров тощих и худых, вышедших после тех, это семь лет, также и семь колосьев тощих и иссушенных восточным ветром, это семь лет голода. ");
INSERT INTO russyn_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Вот почему сказал я фараону: что Бог сделает, то Он показал фараону. ");
INSERT INTO russyn_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Вот, наступает семь лет великого изобилия во всей земле Египетской; ");
INSERT INTO russyn_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","после них настанут семь лет голода, и забудется все то изобилие в земле Египетской, и истощит голод землю, ");
INSERT INTO russyn_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","и неприметно будет прежнее изобилие на земле, по причине голода, который последует, ибо он будет очень тяжел. ");
INSERT INTO russyn_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","А что сон повторился фараону дважды, это значит, что сие истинно слово Божие, и что вскоре Бог исполнит сие. ");
INSERT INTO russyn_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","И ныне да усмотрит фараон мужа разумного и мудрого и да поставит его над землею Египетскою. ");
INSERT INTO russyn_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Да повелит фараон поставить над землею надзирателей и собирать в семь лет изобилия пятую часть всех произведений земли Египетской; ");
INSERT INTO russyn_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","пусть они берут всякий хлеб этих наступающих хороших годов и соберут в городах хлеб под ведение фараона в пищу, и пусть берегут; ");
INSERT INTO russyn_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","и будет сия пища в запас для земли на семь лет голода, которые будут в земле Египетской, дабы земля не погибла от голода. ");
INSERT INTO russyn_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Сие понравилось фараону и всем слугам его. ");
INSERT INTO russyn_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","И сказал фараон слугам своим: найдем ли мы такого, как он, человека, в котором был бы Дух Божий? ");
INSERT INTO russyn_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","И сказал фараон Иосифу: так как Бог открыл тебе все сие, то нет столь разумного и мудрого, как ты; ");
INSERT INTO russyn_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","ты будешь над домом моим, и твоего слова держаться будет весь народ мой; только престолом я буду больше тебя. ");
INSERT INTO russyn_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","И сказал фараон Иосифу: вот, я поставляю тебя над всею землею Египетскою. ");
INSERT INTO russyn_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","И снял фараон перстень свой с руки своей и надел его на руку Иосифа; одел его в виссонные одежды, возложил золотую цепь на шею ему; ");
INSERT INTO russyn_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","велел везти его на второй из своих колесниц и провозглашать пред ним: преклоняйтесь! И поставил его над всею землею Египетскою. ");
INSERT INTO russyn_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","И сказал фараон Иосифу: я фараон; без тебя никто не двинет ни руки своей, ни ноги своей во всей земле Египетской. ");
INSERT INTO russyn_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","И нарек фараон Иосифу имя: Цафнаф-панеах, и дал ему в жену Асенефу, дочь Потифера, жреца Илиопольского. И пошел Иосиф по земле Египетской. ");
INSERT INTO russyn_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Иосифу было тридцать лет от рождения, когда он предстал пред лице фараона, царя Египетского. И вышел Иосиф от лица фараонова и прошел по всей земле Египетской. ");
INSERT INTO russyn_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Земля же в семь лет изобилия приносила из зерна по горсти. ");
INSERT INTO russyn_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","И собрал он всякий хлеб семи лет, которые были плодородны в земле Египетской, и положил хлеб в городах; в каждом городе положил хлеб полей, окружающих его. ");
INSERT INTO russyn_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","И скопил Иосиф хлеба весьма много, как песку морского, так что перестал и считать, ибо не стало счета. ");
INSERT INTO russyn_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","До наступления годов голода у Иосифа родились два сына, которых родила ему Асенефа, дочь Потифера, жреца Илиопольского. ");
INSERT INTO russyn_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","И нарек Иосиф имя первенцу: Манассия, потому что говорил он Бог дал мне забыть все несчастья мои и весь дом отца моего. ");
INSERT INTO russyn_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","А другому нарек имя: Ефрем, потому что говорил он Бог сделал меня плодовитым в земле страдания моего. ");
INSERT INTO russyn_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","И прошли семь лет изобилия, которое было в земле Египетской, ");
INSERT INTO russyn_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","и наступили семь лет голода, как сказал Иосиф. И был голод во всех землях, а во всей земле Египетской был хлеб. ");
INSERT INTO russyn_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Но когда и вся земля Египетская начала терпеть голод, то народ начал вопиять к фараону о хлебе. И сказал фараон всем Египтянам: пойдите к Иосифу и делайте, что он вам скажет. ");
INSERT INTO russyn_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","И был голод по всей земле; и отворил Иосиф все житницы, и стал продавать хлеб Египтянам. Голод же усиливался в земле Египетской. ");
INSERT INTO russyn_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","И из всех стран приходили в Египет покупать хлеб у Иосифа, ибо голод усилился по всей земле. ");
INSERT INTO russyn_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","И узнал Иаков, что в Египте есть хлеб, и сказал Иаков сыновьям своим: что вы смотрите? ");
INSERT INTO russyn_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","И сказал: вот, я слышал, что есть хлеб в Египте; пойдите туда и купите нам оттуда хлеба, чтобы нам жить и не умереть. ");
INSERT INTO russyn_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Десять братьев Иосифовых пошли купить хлеба в Египте, ");
INSERT INTO russyn_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","а Вениамина, брата Иосифова, не послал Иаков с братьями его, ибо сказал: не случилось бы с ним беды. ");
INSERT INTO russyn_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","И пришли сыны Израилевы покупать хлеб, вместе с другими пришедшими, ибо в земле Ханаанской был голод. ");
INSERT INTO russyn_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Иосиф же был начальником в земле той; он и продавал хлеб всему народу земли. Братья Иосифа пришли и поклонились ему лицем до земли. ");
INSERT INTO russyn_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","И увидел Иосиф братьев своих и узнал их; но показал, будто не знает их, и говорил с ними сурово и сказал им: откуда вы пришли? Они сказали: из земли Ханаанской, купить пищи. ");
INSERT INTO russyn_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Иосиф узнал братьев своих, но они не узнали его. ");
INSERT INTO russyn_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","И вспомнил Иосиф сны, которые снились ему о них; и сказал им: вы соглядатаи, вы пришли высмотреть наготу земли сей. ");
INSERT INTO russyn_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Они сказали ему: нет, господин наш; рабы твои пришли купить пищи; ");
INSERT INTO russyn_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","мы все дети одного человека; мы люди честные; рабы твои не бывали соглядатаями. ");
INSERT INTO russyn_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Он сказал им: нет, вы пришли высмотреть наготу земли сей. ");
INSERT INTO russyn_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Они сказали: нас, рабов твоих, двенадцать братьев; мы сыновья одного человека в земле Ханаанской, и вот, меньший теперь с отцом нашим, а одного не стало. ");
INSERT INTO russyn_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","И сказал им Иосиф: это самое я и говорил вам, сказав: вы соглядатаи; ");
INSERT INTO russyn_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","вот как вы будете испытаны: клянусь жизнью фараона, вы не выйдете отсюда, если не придет сюда меньший брат ваш; ");
INSERT INTO russyn_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","пошлите одного из вас, и пусть он приведет брата вашего, а вы будете задержаны; и откроется, правда ли у вас; и если нет, то клянусь жизнью фараона, что вы соглядатаи. ");
INSERT INTO russyn_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","И отдал их под стражу на три дня. ");
INSERT INTO russyn_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","И сказал им Иосиф в третий день: вот что сделайте, и останетесь живы, ибо я боюсь Бога: ");
INSERT INTO russyn_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","если вы люди честные, то один брат из вас пусть содержится в доме, где вы заключены; а вы пойдите, отвезите хлеб, ради голода семейств ваших; ");
INSERT INTO russyn_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","брата же вашего меньшого приведите ко мне, чтобы оправдались слова ваши и чтобы не умереть вам. Так они и сделали. ");
INSERT INTO russyn_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","И говорили они друг другу: точно мы наказываемся за грех против брата нашего; мы видели страдание души его, когда он умолял нас, но не послушали его; за то и постигло нас горе сие. ");
INSERT INTO russyn_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Рувим отвечал им и сказал: не говорил ли я вам: не грешите против отрока? но вы не послушались; вот, кровь его взыскивается. ");
INSERT INTO russyn_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","А того не знали они, что Иосиф понимает; ибо между ними был переводчик. ");
INSERT INTO russyn_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","И отошел от них Иосиф и заплакал. И возвратился к ним, и говорил с ними, и, взяв из них Симеона, связал его пред глазами их. ");
INSERT INTO russyn_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","И приказал Иосиф наполнить мешки их хлебом, а серебро их возвратить каждому в мешок его, и дать им запасов на дорогу. Так и сделано с ними. ");
INSERT INTO russyn_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Они положили хлеб свой на ослов своих, и пошли оттуда. ");
INSERT INTO russyn_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","И открыл один из них мешок свой, чтобы дать корму ослу своему на ночлеге, и увидел серебро свое в отверстии мешка его, ");
INSERT INTO russyn_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","и сказал своим братьям: серебро мое возвращено; вот оно в мешке у меня. И смутилось сердце их, и они с трепетом друг другу говорили: что это Бог сделал с нами? ");
INSERT INTO russyn_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","И пришли к Иакову, отцу своему, в землю Ханаанскую и рассказали ему все случившееся с ними, говоря: ");
INSERT INTO russyn_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","начальствующий над тою землею говорил с нами сурово и принял нас за соглядатаев земли той. ");
INSERT INTO russyn_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","И сказали мы ему: мы люди честные; мы не бывали соглядатаями; ");
INSERT INTO russyn_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","нас двенадцать братьев, сыновей у отца нашего; одного не стало, а меньший теперь с отцом нашим в земле Ханаанской. ");
INSERT INTO russyn_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","И сказал нам начальствующий над тою землею: вот как узнаю я, честные ли вы люди: оставьте у меня одного брата из вас, а вы возьмите хлеб ради голода семейств ваших и пойдите, ");
INSERT INTO russyn_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","и приведите ко мне меньшого брата вашего; и узнаю я, что вы не соглядатаи, но люди честные; отдам вам брата вашего, и вы можете промышлять в этой земле. ");
INSERT INTO russyn_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Когда же они опорожняли мешки свои, вот, у каждого узел серебра его в мешке его. И увидели они узлы серебра своего, они и отец их, и испугались. ");
INSERT INTO russyn_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","И сказал им Иаков, отец их: вы лишили меня детей: Иосифа нет, и Симеона нет, и Вениамина взять хотите,- все это на меня! ");
INSERT INTO russyn_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","И сказал Рувим отцу своему, говоря: убей двух моих сыновей, если я не приведу его к тебе; отдай его на мои руки; я возвращу его тебе. ");
INSERT INTO russyn_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Он сказал: не пойдет сын мой с вами; потому что брат его умер, и он один остался; если случится с ним несчастье на пути, в который вы пойдете, то сведете вы седину мою с печалью во гроб. ");
INSERT INTO russyn_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Голод усилился на земле. ");
INSERT INTO russyn_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","И когда они съели хлеб, который привезли из Египта, тогда отец их сказал им: пойдите опять, купите нам немного пищи. ");
INSERT INTO russyn_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","И сказал ему Иуда, говоря: тот человек решительно объявил нам, сказав: не являйтесь ко мне на лице, если брата вашего не будет с вами. ");
INSERT INTO russyn_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Если пошлешь с нами брата нашего, то пойдем и купим тебе пищи, ");
INSERT INTO russyn_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","а если не пошлешь, то не пойдем, ибо тот человек сказал нам: не являйтесь ко мне на лице, если брата вашего не будет с вами. ");
INSERT INTO russyn_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Израиль сказал: для чего вы сделали мне такое зло, сказав тому человеку, что у вас есть еще брат? ");
INSERT INTO russyn_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Они сказали: расспрашивал тот человек о нас и о родстве нашем, говоря: жив ли еще отец ваш? есть ли у вас брат? Мы и рассказали ему по этим расспросам. Могли ли мы знать, что он скажет: приведите брата вашего? ");
INSERT INTO russyn_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Иуда же сказал Израилю, отцу своему: отпусти отрока со мною, и мы встанем и пойдем, и живы будем и не умрем и мы, и ты, и дети наши; ");
INSERT INTO russyn_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","я отвечаю за него, из моих рук потребуешь его; если я не приведу его к тебе и не поставлю его пред лицем твоим, то останусь я виновным пред тобою во все дни жизни; ");
INSERT INTO russyn_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","если бы мы не медлили, то уже сходили бы два раза. ");
INSERT INTO russyn_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Израиль, отец их, сказал им: если так, то вот что сделайте: возьмите с собою плодов земли сей и отнесите в дар тому человеку несколько бальзама и несколько меду, стираксы и ладану, фисташков и миндальных орехов; ");
INSERT INTO russyn_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","возьмите и другое серебро в руки ваши; а серебро, обратно положенное в отверстие мешков ваших, возвратите руками вашими: может быть, это недосмотр; ");
INSERT INTO russyn_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","и брата вашего возьмите и, встав, пойдите опять к человеку тому; ");
INSERT INTO russyn_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Бог же Всемогущий да даст вам найти милость у человека того, чтобы он отпустил вам и другого брата вашего и Вениамина, а мне если уже быть бездетным, то пусть буду бездетным. ");
INSERT INTO russyn_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","И взяли те люди дары эти, и серебра вдвое взяли в руки свои, и Вениамина, и встали, пошли в Египет и предстали пред лице Иосифа. ");
INSERT INTO russyn_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Иосиф, увидев между ними Вениамина брата своего, сына матери своей, сказал начальнику дома своего: введи сих людей в дом и заколи что-нибудь из скота, и приготовь, потому что со мною будут есть эти люди в полдень. ");
INSERT INTO russyn_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","И сделал человек тот, как сказал Иосиф, и ввел человек тот людей сих в дом Иосифов. ");
INSERT INTO russyn_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","И испугались люди эти, что ввели их в дом Иосифов, и сказали: это за серебро, возвращенное прежде в мешки наши, ввели нас, чтобы придраться к нам и напасть на нас, и взять нас в рабство и ослов наших. ");
INSERT INTO russyn_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","И подошли они к начальнику дома Иосифова, и стали говорить ему у дверей дома, ");
INSERT INTO russyn_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","и сказали: послушай, господин наш, мы приходили уже прежде покупать пищи, ");
INSERT INTO russyn_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","и случилось, что, когда пришли мы на ночлег и открыли мешки наши,- вот серебро каждого в отверстии мешка его, серебро наше по весу его, и мы возвращаем его своими руками; ");
INSERT INTO russyn_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","а для покупки пищи мы принесли другое серебро в руках наших, мы не знаем, кто положил серебро наше в мешки наши. ");
INSERT INTO russyn_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Он сказал: будьте спокойны, не бойтесь; Бог ваш и Бог отца вашего дал вам клад в мешках ваших; серебро ваше дошло до меня. И привел к ним Симеона. ");
INSERT INTO russyn_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","И ввел тот человек людей сих в дом Иосифов и дал воды, и они омыли ноги свои; и дал корму ослам их. ");
INSERT INTO russyn_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","И они приготовили дары к приходу Иосифа в полдень, ибо слышали, что там будут есть хлеб. ");
INSERT INTO russyn_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","И пришел Иосиф домой; и они принесли ему в дом дары, которые были на руках их, и поклонились ему до земли. ");
INSERT INTO russyn_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Он спросил их о здоровье и сказал: здоров ли отец ваш старец, о котором вы говорили? жив ли еще он? ");
INSERT INTO russyn_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Они сказали: здоров раб твой, отец наш; еще жив. Он сказал: благословен человек сей от Бога. И преклонились они и поклонились. ");
INSERT INTO russyn_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","И поднял глаза свои Иосиф, и увидел Вениамина, брата своего, сына матери своей, и сказал: это брат ваш меньший, о котором вы сказывали мне? И сказал: да будет милость Божия с тобою, сын мой! ");
INSERT INTO russyn_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","И поспешно удалился Иосиф, потому что воскипела любовь к брату его, и он готов был заплакать, и вошел он во внутреннюю комнату и плакал там. ");
INSERT INTO russyn_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","И, умыв лице свое, вышел, и скрепился и сказал: подавайте кушанье. ");
INSERT INTO russyn_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","И подали ему особо, и им особо, и Египтянам, обедавшим с ним, особо, ибо Египтяне не могут есть с Евреями, потому что это мерзость для Египтян. ");
INSERT INTO russyn_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","И сели они пред ним, первородный по первородству его, и младший по молодости его, и дивились эти люди друг пред другом. ");
INSERT INTO russyn_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","И посылались им кушанья от него, и доля Вениамина была впятеро больше долей каждого из них. И пили, и довольно пили они с ним. ");
INSERT INTO russyn_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","И приказал Иосиф начальнику дома своего, говоря: наполни мешки этих людей пищею, сколько они могут нести, и серебро каждого положи в отверстие мешка его, ");
INSERT INTO russyn_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","а чашу мою, чашу серебряную, положи в отверстие мешка к младшему вместе с серебром за купленный им хлеб. И сделал тот по слову Иосифа, которое сказал он. ");
INSERT INTO russyn_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Утром, когда рассвело, эти люди были отпущены, они и ослы их. ");
INSERT INTO russyn_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Еще не далеко отошли они от города, как Иосиф сказал начальнику дома своего: ступай, догоняй этих людей и, когда догонишь, скажи им: для чего вы заплатили злом за добро? для чего украли у меня серебряную чашу? ");
INSERT INTO russyn_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Не та ли это, из которой пьет господин мой и он гадает на ней? Худо это вы сделали. ");
INSERT INTO russyn_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Он догнал их и сказал им эти слова. ");
INSERT INTO russyn_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Они сказали ему: для чего господин наш говорит такие слова? Нет, рабы твои не сделают такого дела. ");
INSERT INTO russyn_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Вот, серебро, найденное нами в отверстии мешков наших, мы обратно принесли тебе из земли Ханаанской: как же нам украсть из дома господина твоего серебро или золото? ");
INSERT INTO russyn_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","У кого из рабов твоих найдется чаша, тому смерть, и мы будем рабами господину нашему. ");
INSERT INTO russyn_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Он сказал: хорошо; как вы сказали, так пусть и будет: у кого найдется чаша, тот будет мне рабом, а вы будете не виноваты. ");
INSERT INTO russyn_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Они поспешно спустили каждый свой мешок на землю и открыли каждый свой мешок. ");
INSERT INTO russyn_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Он обыскал, начал со старшего и окончил младшим; и нашлась чаша в мешке Вениаминовом. ");
INSERT INTO russyn_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","И разодрали они одежды свои, и, возложив каждый на осла своего ношу, возвратились в город. ");
INSERT INTO russyn_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","И пришли Иуда и братья его в дом Иосифа, который был еще дома, и пали пред ним на землю. ");
INSERT INTO russyn_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Иосиф сказал им: что это вы сделали? разве вы не знали, что такой человек, как я, конечно угадает? ");
INSERT INTO russyn_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Иуда сказал: что нам сказать господину нашему? что говорить? чем оправдываться? Бог нашел неправду рабов твоих; вот, мы рабы господину нашему, и мы, и тот, в чьих руках нашлась чаша. ");
INSERT INTO russyn_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Но Иосиф сказал: нет, я этого не сделаю; тот, в чьих руках нашлась чаша, будет мне рабом, а вы пойдите с миром к отцу вашему. ");
INSERT INTO russyn_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","И подошел Иуда к нему и сказал: господин мой, позволь рабу твоему сказать слово в уши господина моего, и не прогневайся на раба твоего, ибо ты то же, что фараон. ");
INSERT INTO russyn_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Господин мой спрашивал рабов своих, говоря: есть ли у вас отец или брат? ");
INSERT INTO russyn_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Мы сказали господину нашему, что у нас есть отец престарелый, и у него младший сын, сын старости, которого брат умер, а он остался один от матери своей, и отец любит его. ");
INSERT INTO russyn_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Ты же сказал рабам твоим: приведите его ко мне, чтобы мне взглянуть на него. ");
INSERT INTO russyn_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Мы сказали господину нашему: отрок не может оставить отца своего, и если он оставит отца своего, то сей умрет. ");
INSERT INTO russyn_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Но ты сказал рабам твоим: если не придет с вами меньший брат ваш, то вы более не являйтесь ко мне на лице. ");
INSERT INTO russyn_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Когда мы пришли к рабу твоему, отцу нашему, то пересказали ему слова господина моего. ");
INSERT INTO russyn_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","И сказал отец наш: пойдите опять, купите нам немного пищи. ");
INSERT INTO russyn_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Мы сказали: нельзя нам идти; а если будет с нами меньший брат наш, то пойдем; потому что нельзя нам видеть лица того человека, если не будет с нами меньшого брата нашего. ");
INSERT INTO russyn_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","И сказал нам раб твой, отец наш: вы знаете, что жена моя родила мне двух сынов; ");
INSERT INTO russyn_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","один пошел от меня, и я сказал: верно он растерзан; и я не видал его доныне; ");
INSERT INTO russyn_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","если и сего возьмете от глаз моих и случится с ним несчастье, то сведете вы седину мою с горестью во гроб. ");
INSERT INTO russyn_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Теперь если я приду к рабу твоему, отцу нашему, и не будет с нами отрока, с душею которого связана душа его, ");
INSERT INTO russyn_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","то он, увидев, что нет отрока, умрет; и сведут рабы твои седину раба твоего, отца нашего, с печалью во гроб. ");
INSERT INTO russyn_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Притом я, раб твой, взялся отвечать за отрока отцу моему, сказав: если не приведу его к тебе и не поставлю его пред тобою, то останусь я виновным пред отцом моим во все дни жизни. ");
INSERT INTO russyn_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Итак пусть я, раб твой, вместо отрока останусь рабом у господина моего, а отрок пусть идет с братьями своими: ");
INSERT INTO russyn_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","ибо как пойду я к отцу моему, когда отрока не будет со мною? я увидел бы бедствие, которое постигло бы отца моего. ");
INSERT INTO russyn_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Иосиф не мог более удерживаться при всех стоявших около него и закричал: удалите от меня всех. И не оставалось при Иосифе никого, когда он открылся братьям своим. ");
INSERT INTO russyn_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","И громко зарыдал он, и услышали Египтяне, и услышал дом фараонов. ");
INSERT INTO russyn_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","И сказал Иосиф братьям своим: я - Иосиф, жив ли еще отец мой? Но братья его не могли отвечать ему, потому что они смутились пред ним. ");
INSERT INTO russyn_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","И сказал Иосиф братьям своим: подойдите ко мне. Они подошли. Он сказал: я - Иосиф, брат ваш, которого вы продали в Египет; ");
INSERT INTO russyn_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","но теперь не печальтесь и не жалейте о том, что вы продали меня сюда, потому что Бог послал меня перед вами для сохранения вашей жизни; ");
INSERT INTO russyn_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","ибо теперь два года голода на земле: остается еще пять лет, в которые ни орать, ни жать не будут; ");
INSERT INTO russyn_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Бог послал меня перед вами, чтобы оставить вас на земле и сохранить вашу жизнь великим избавлением. ");
INSERT INTO russyn_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Итак не вы послали меня сюда, но Бог, Который и поставил меня отцом фараону и господином во всем доме его и владыкою во всей земле Египетской. ");
INSERT INTO russyn_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Идите скорее к отцу моему и скажите ему: так говорит сын твой Иосиф: Бог поставил меня господином над всем Египтом; приди ко мне, не медли; ");
INSERT INTO russyn_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","ты будешь жить в земле Гесем; и будешь близ меня, ты, и сыны твои, и сыны сынов твоих, и мелкий и крупный скот твой, и все твое; ");
INSERT INTO russyn_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","и прокормлю тебя там, ибо голод будет еще пять лет, чтобы не обнищал ты и дом твой и все твое. ");
INSERT INTO russyn_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","И вот, очи ваши и очи брата моего Вениамина видят, что это мои уста говорят с вами; ");
INSERT INTO russyn_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","скажите же отцу моему о всей славе моей в Египте и о всем, что вы видели, и приведите скорее отца моего сюда. ");
INSERT INTO russyn_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","И пал он на шею Вениамину, брату своему, и плакал; и Вениамин плакал на шее его. ");
INSERT INTO russyn_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","И целовал всех братьев своих и плакал, обнимая их. Потом говорили с ним братья его. ");
INSERT INTO russyn_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Дошел в дом фараона слух, что пришли братья Иосифа; и приятно было фараону и рабам его. ");
INSERT INTO russyn_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","И сказал фараон Иосифу: скажи братьям твоим: вот что сделайте: навьючьте скот ваш хлебом и ступайте в землю Ханаанскую; ");
INSERT INTO russyn_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","и возьмите отца вашего и семейства ваши и придите ко мне; я дам вам лучшее место в земле Египетской, и вы будете есть тук земли. ");
INSERT INTO russyn_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Тебе же повелеваю сказать им: сделайте сие: возьмите себе из земли Египетской колесниц для детей ваших и для жен ваших и привезите отца вашего и придите; ");
INSERT INTO russyn_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","и не жалейте вещей ваших, ибо лучшее из всей земли Египетской дам вам. ");
INSERT INTO russyn_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Так и сделали сыны Израилевы. И дал им Иосиф колесницы по приказанию фараона, и дал им путевой запас, ");
INSERT INTO russyn_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","каждому из них он дал перемену одежд, а Вениамину дал триста сребренников и пять перемен одежд; ");
INSERT INTO russyn_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","также и отцу своему послал десять ослов, навьюченных лучшими произведениями Египетскими, и десять ослиц, навьюченных зерном, хлебом и припасами отцу своему на путь. ");
INSERT INTO russyn_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","И отпустил братьев своих, и они пошли. И сказал им: не ссорьтесь на дороге. ");
INSERT INTO russyn_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","И пошли они из Египта, и пришли в землю Ханаанскую к Иакову, отцу своему, ");
INSERT INTO russyn_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","и известили его, сказав: Иосиф сын твой жив и теперь владычествует над всею землею Египетскою. Но сердце его смутилось, ибо он не верил им. ");
INSERT INTO russyn_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Когда же они пересказали ему все слова Иосифа, которые он говорил им, и когда увидел колесницы, которые прислал Иосиф, чтобы везти его, тогда ожил дух Иакова, отца их, ");
INSERT INTO russyn_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","и сказал Израиль: довольно сего для меня, еще жив сын мой Иосиф; пойду и увижу его, пока не умру. ");
INSERT INTO russyn_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","И отправился Израиль со всем, что у него было, и пришел в Вирсавию, и принес жертвы Богу отца своего Исаака. ");
INSERT INTO russyn_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","И сказал Бог Израилю в видении ночном: Иаков! Иаков! Он сказал: вот я. ");
INSERT INTO russyn_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Бог сказал: Я Бог, Бог отца твоего; не бойся идти в Египет, ибо там произведу от тебя народ великий; ");
INSERT INTO russyn_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Я пойду с тобою в Египет, Я и выведу тебя обратно. Иосиф своею рукою закроет глаза твои. ");
INSERT INTO russyn_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Иаков отправился из Вирсавии; и повезли сыны Израилевы Иакова, отца своего, и детей своих, и жен своих на колесницах, которые послал фараон, чтобы привезти его. ");
INSERT INTO russyn_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","И взяли они скот свой и имущество свое, которое приобрели в земле Ханаанской, и пришли в Египет,- Иаков и весь род его с ним. ");
INSERT INTO russyn_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Сынов своих и внуков своих с собою, дочерей своих и внучек своих и весь род свой привел он с собою в Египет. ");
INSERT INTO russyn_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Вот имена сынов Израилевых, пришедших в Египет: Иаков и сыновья его. Первенец Иакова Рувим. ");
INSERT INTO russyn_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Сыны Рувима: Ханох и Фаллу, Хецрон и Харми. ");
INSERT INTO russyn_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Сыны Симеона: Иемуил и Иамин, и Огад, и Иахин, и Цохар, и Саул, сын Хананеянки. ");
INSERT INTO russyn_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Сыны Левия: Гирсон, Кааф и Мерари. ");
INSERT INTO russyn_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Сыны Иуды: Ир и Онан, и Шела, и Фарес, и Зара; но Ир и Онан умерли в земле Ханаанской. Сыны Фареса были: Есром и Хамул. ");
INSERT INTO russyn_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Сыны Иссахара: Фола и Фува, Иов и Шимрон. ");
INSERT INTO russyn_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Сыны Завулона: Серед и Елон, и Иахлеил. ");
INSERT INTO russyn_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Это сыны Лии, которых она родила Иакову в Месопотамии, и Дину, дочь его. Всех душ сынов его и дочерей его - тридцать три. ");
INSERT INTO russyn_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Сыны Гада: Цифион и Хагги, Шуни и Эцбон, Ери и Ароди и Арели. ");
INSERT INTO russyn_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Сыны Асира: Имна и Ишва, и Ишви, и Бриа, и Серах, сестра их. Сыны Брии: Хевер и Малхиил. ");
INSERT INTO russyn_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Это сыны Зелфы, которую Лаван дал Лии, дочери своей; она родила их Иакову шестнадцать душ. ");
INSERT INTO russyn_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Сыны Рахили, жены Иакова: Иосиф и Вениамин. ");
INSERT INTO russyn_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","И родились у Иосифа в земле Египетской Манассия и Ефрем, которых родила ему Асенефа, дочь Потифера, жреца Илиопольского. ");
INSERT INTO russyn_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Сыны Вениамина: Бела и Бехер и Ашбел; сыны Белы были: Гера и Нааман, Эхи и Рош, Муппим и Хуппим и Ард. ");
INSERT INTO russyn_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Это сыны Рахили, которые родились у Иакова, всего четырнадцать душ. ");
INSERT INTO russyn_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Сын Дана: Хушим. ");
INSERT INTO russyn_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Сыны Неффалима: Иахцеил и Гуни, и Иецер, и Шиллем. ");
INSERT INTO russyn_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Это сыны Валлы, которую дал Лаван дочери своей Рахили; она родила их Иакову всего семь душ. ");
INSERT INTO russyn_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Всех душ, пришедших с Иаковом в Египет, которые произошли из чресл его, кроме жен сынов Иаковлевых, всего шестьдесят шесть душ. ");
INSERT INTO russyn_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Сынов Иосифа, которые родились у него в Египте, две души. Всех душ дома Иаковлева, перешедших с Иаковом в Египет, семьдесят пять. ");
INSERT INTO russyn_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Иуду послал он пред собою к Иосифу, чтобы он указал путь в Гесем. И пришли в землю Гесем. ");
INSERT INTO russyn_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Иосиф запряг колесницу свою и выехал навстречу Израилю, отцу своему, в Гесем, и, увидев его, пал на шею его, и долго плакал на шее его. ");
INSERT INTO russyn_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","И сказал Израиль Иосифу: умру я теперь, увидев лице твое, ибо ты еще жив. ");
INSERT INTO russyn_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","И сказал Иосиф братьям своим и дому отца своего: я пойду, извещу фараона и скажу ему: братья мои и дом отца моего, которые были в земле Ханаанской, пришли ко мне; ");
INSERT INTO russyn_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","эти люди пастухи овец, ибо скотоводы они; и мелкий и крупный скот свой, и все, что у них, привели они. ");
INSERT INTO russyn_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Если фараон призовет вас и скажет: какое занятие ваше? ");
INSERT INTO russyn_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","то вы скажите: мы, рабы твои, скотоводами были от юности нашей доныне, и мы и отцы наши, чтобы вас поселили в земле Гесем. Ибо мерзость для Египтян всякий пастух овец. ");
INSERT INTO russyn_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","И пришел Иосиф и известил фараона и сказал: отец мой и братья мои, с мелким и крупным скотом своим и со всем, что у них, пришли из земли Ханаанской; и вот, они в земле Гесем. ");
INSERT INTO russyn_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","И из братьев своих он взял пять человек и представил их фараону. ");
INSERT INTO russyn_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","И сказал фараон братьям его: какое ваше занятие? Они сказали фараону: пастухи овец рабы твои, и мы и отцы наши. ");
INSERT INTO russyn_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","И сказали они фараону: мы пришли пожить в этой земле, потому что нет пажити для скота рабов твоих, ибо в земле Ханаанской сильный голод; итак позволь поселиться рабам твоим в земле Гесем. ");
INSERT INTO russyn_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","И сказал фараон Иосифу: отец твой и братья твои пришли к тебе; ");
INSERT INTO russyn_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","земля Египетская пред тобою; на лучшем месте земли посели отца твоего и братьев твоих; пусть живут они в земле Гесем; и если знаешь, что между ними есть способные люди, поставь их смотрителями над моим скотом. ");
INSERT INTO russyn_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","И привел Иосиф Иакова, отца своего, и представил его фараону; и благословил Иаков фараона. ");
INSERT INTO russyn_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Фараон сказал Иакову: сколько лет жизни твоей? ");
INSERT INTO russyn_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Иаков сказал фараону: дней странствования моего сто тридцать лет; малы и несчастны дни жизни моей и не достигли до лет жизни отцов моих во днях странствования их. ");
INSERT INTO russyn_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","И благословил фараона Иаков и вышел от фараона. ");
INSERT INTO russyn_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","И поселил Иосиф отца своего и братьев своих, и дал им владение в земле Египетской, в лучшей части земли, в земле Раамсес, как повелел фараон. ");
INSERT INTO russyn_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","И снабжал Иосиф отца своего и братьев своих и весь дом отца своего хлебом, по потребностям каждого семейства. ");
INSERT INTO russyn_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","И не было хлеба по всей земле, потому что голод весьма усилился, и изнурены были от голода земля Египетская и земля Ханаанская. ");
INSERT INTO russyn_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Иосиф собрал все серебро, какое было в земле Египетской и в земле Ханаанской, за хлеб, который покупали, и внес Иосиф серебро в дом фараонов. ");
INSERT INTO russyn_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","И серебро истощилось в земле Египетской и в земле Ханаанской. Все Египтяне пришли к Иосифу и говорили: дай нам хлеба; зачем нам умирать пред тобою, потому что серебро вышло у нас? ");
INSERT INTO russyn_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Иосиф сказал: пригоняйте скот ваш, и я буду давать вам хлеб за скот ваш, если серебро вышло у вас. ");
INSERT INTO russyn_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","И пригоняли они к Иосифу скот свой; и давал им Иосиф хлеб за лошадей, и за стада мелкого скота, и за стада крупного скота, и за ослов; и снабжал их хлебом в тот год за весь скот их. ");
INSERT INTO russyn_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","И прошел этот год; и пришли к нему на другой год и сказали ему: не скроем от господина нашего, что серебро истощилось и стада скота нашего у господина нашего; ничего не осталось у нас пред господином нашим, кроме тел наших и земель наших; ");
INSERT INTO russyn_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","для чего нам погибать в глазах твоих, и нам и землям нашим? купи нас и земли наши за хлеб, и мы с землями нашими будем рабами фараону, а ты дай нам семян, чтобы нам быть живыми и не умереть, и чтобы не опустела земля. ");
INSERT INTO russyn_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","И купил Иосиф всю землю Египетскую для фараона, потому что продали Египтяне каждый свое поле, ибо голод одолевал их. И досталась земля фараону. ");
INSERT INTO russyn_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","И народ сделал он рабами от одного конца Египта до другого. ");
INSERT INTO russyn_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Только земли жрецов не купил Иосиф, ибо жрецам от фараона положен был участок, и они питались своим участком, который дал им фараон; посему и не продали земли своей. ");
INSERT INTO russyn_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","И сказал Иосиф народу: вот, я купил теперь для фараона вас и землю вашу; вот вам семена, и засевайте землю; ");
INSERT INTO russyn_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","когда будет жатва, давайте пятую часть фараону, а четыре части останутся вам на засеяние полей, на пропитание вам и тем, кто в домах ваших, и на пропитание детям вашим. ");
INSERT INTO russyn_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Они сказали: ты спас нам жизнь; да обретем милость в очах господина нашего и да будем рабами фараону. ");
INSERT INTO russyn_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","И поставил Иосиф в закон земле Египетской, даже до сего дня: пятую часть давать фараону, исключая только землю жрецов, которая не принадлежала фараону. ");
INSERT INTO russyn_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","И жил Израиль в земле Египетской, в земле Гесем, и владели они ею, и плодились, и весьма умножились. ");
INSERT INTO russyn_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","И жил Иаков в земле Египетской семнадцать лет; и было дней Иакова, годов жизни его, сто сорок семь лет. ");
INSERT INTO russyn_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","И пришло время Израилю умереть, и призвал он сына своего Иосифа и сказал ему: если я нашел благоволение в очах твоих, положи руку твою под стегно мое и клянись, что ты окажешь мне милость и правду, не похоронишь меня в Египте, ");
INSERT INTO russyn_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","дабы мне лечь с отцами моими; вынесешь меня из Египта и похоронишь меня в их гробнице. Иосиф сказал: сделаю по слову твоему., ");
INSERT INTO russyn_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","И сказал: клянись мне. И клялся ему. И поклонился Израиль на возглавие постели. ");
INSERT INTO russyn_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","После того Иосифу сказали: вот, отец твой болен. И он взял с собою двух сынов своих, Манассию и Ефрема и пошел к Иакову. ");
INSERT INTO russyn_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Иакова известили и сказали: вот, сын твой Иосиф идет к тебе. Израиль собрал силы свои и сел на постели. ");
INSERT INTO russyn_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","И сказал Иаков Иосифу: Бог Всемогущий явился мне в Лузе, в земле Ханаанской, и благословил меня, ");
INSERT INTO russyn_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","и сказал мне: вот, Я распложу тебя, и размножу тебя, и произведу от тебя множество народов, и дам землю сию потомству твоему после тебя, в вечное владение. ");
INSERT INTO russyn_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","И ныне два сына твои, родившиеся тебе в земле Египетской, до моего прибытия к тебе в Египет, мои они; Ефрем и Манассия, как Рувим и Симеон, будут мои; ");
INSERT INTO russyn_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","дети же твои, которые родятся от тебя после них, будут твои; они под именем братьев своих будут именоваться в их уделе. ");
INSERT INTO russyn_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Когда я шел из Месопотамии, умерла у меня Рахиль мать твоя в земле Ханаанской, по дороге, не доходя несколько до Ефрафы, и я похоронил ее там на дороге к Ефрафе, что ныне Вифлеем. ");
INSERT INTO russyn_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","И увидел Израиль сыновей Иосифа и сказал: кто это? ");
INSERT INTO russyn_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","И сказал Иосиф отцу своему: это сыновья мои, которых Бог дал мне здесь. Иаков сказал: подведи их ко мне, и я благословлю их. ");
INSERT INTO russyn_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Глаза же Израилевы притупились от старости; не мог он видеть ясно. Иосиф подвел их к нему, и он поцеловал их и обнял их. ");
INSERT INTO russyn_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","И сказал Израиль Иосифу: не надеялся я видеть твое лице; но вот, Бог показал мне и детей твоих. ");
INSERT INTO russyn_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","И отвел их Иосиф от колен его и поклонился ему лицем своим до земли. ");
INSERT INTO russyn_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","И взял Иосиф обоих сыновей своих, Ефрема в правую свою руку против левой Израиля, а Манассию в левую против правой Израиля, и подвел к нему. ");
INSERT INTO russyn_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Но Израиль простер правую руку свою и положил на голову Ефрему, хотя сей был меньший, а левую на голову Манассии. С намерением положил он так руки свои, хотя Манассия был первенец. ");
INSERT INTO russyn_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","И благословил Иосифа и сказал: Бог, пред Которым ходили отцы мои Авраам и Исаак, Бог, пасущий меня с тех пор, как я существую, до сего дня, ");
INSERT INTO russyn_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Ангел, избавляющий меня от всякого зла, да благословит отроков сих; да будет на них наречено имя мое и имя отцов моих Авраама и Исаака, и да возрастут они во множество посреди земли. ");
INSERT INTO russyn_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","И увидел Иосиф, что отец его положил правую руку свою на голову Ефрема; и прискорбно было ему это. И взял он руку отца своего, чтобы переложить ее с головы Ефрема на голову Манассии, ");
INSERT INTO russyn_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","и сказал Иосиф отцу своему: не так, отец мой, ибо это - первенец; положи на его голову правую руку твою. ");
INSERT INTO russyn_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Но отец его не согласился и сказал: знаю, сын мой, знаю; и от него произойдет народ, и он будет велик; но меньший его брат будет больше его, и от семени его произойдет многочисленный народ. ");
INSERT INTO russyn_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","И благословил их в тот день, говоря: тобою будет благословлять Израиль, говоря: Бог да сотворит тебе, как Ефрему и Манассии. И поставил Ефрема выше Манассии. ");
INSERT INTO russyn_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","И сказал Израиль Иосифу: вот, я умираю; и Бог будет с вами и возвратит вас в землю отцов ваших; ");
INSERT INTO russyn_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","я даю тебе, преимущественно пред братьями твоими, один участок, который я взял из рук Аморреев мечом моим и луком моим. ");
INSERT INTO russyn_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","И призвал Иаков сыновей своих и сказал: соберитесь, и я возвещу вам, что будет с вами в грядущие дни; ");
INSERT INTO russyn_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","сойдитесь и послушайте, сыны Иакова, послушайте Израиля, отца вашего. ");
INSERT INTO russyn_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Рувим, первенец мой! ты крепость моя и начаток силы моей, верх достоинства и верх могущества; ");
INSERT INTO russyn_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","но ты бушевал, как вода,- не будешь преимуществовать, ибо ты взошел на ложе отца твоего, ты осквернил постель мою, на которую взошел. ");
INSERT INTO russyn_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Симеон и Левий братья, орудия жестокости мечи их; ");
INSERT INTO russyn_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","в совет их да не войдет душа моя, и к собранию их да не приобщится слава моя, ибо они во гневе своем убили мужа и по прихоти своей перерезали жилы тельца; ");
INSERT INTO russyn_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","проклят гнев их, ибо жесток, и ярость их, ибо свирепа; разделю их в Иакове и рассею их в Израиле. ");
INSERT INTO russyn_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Иуда! тебя восхвалят братья твои. Рука твоя на хребте врагов твоих; поклонятся тебе сыны отца твоего. ");
INSERT INTO russyn_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Молодой лев Иуда, с добычи, сын мой, поднимается. Преклонился он, лег, как лев и как львица: кто поднимет его? ");
INSERT INTO russyn_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Не отойдет скипетр от Иуды и законодатель от чресл его, доколе не приидет Примиритель, и Ему покорность народов. ");
INSERT INTO russyn_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Он привязывает к виноградной лозе осленка своего и к лозе лучшего винограда сына ослицы своей; моет в вине одежду свою и в крови гроздов одеяние свое; ");
INSERT INTO russyn_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","блестящи очи его от вина, и белы зубы его от молока. ");
INSERT INTO russyn_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Завулон при береге морском будет жить и у пристани корабельной, и предел его до Сидона. ");
INSERT INTO russyn_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Иссахар осел крепкий, лежащий между протоками вод; ");
INSERT INTO russyn_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","и увидел он, что покой хорош, и что земля приятна: и преклонил плечи свои для ношения бремени и стал работать в уплату дани. ");
INSERT INTO russyn_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Дан будет судить народ свой, как одно из колен Израиля; ");
INSERT INTO russyn_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Дан будет змеем на дороге, аспидом на пути, уязвляющим ногу коня, так что всадник его упадет назад. ");
INSERT INTO russyn_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","На помощь твою надеюсь, Господи! ");
INSERT INTO russyn_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Гад,- толпа будет теснить его, но он оттеснит ее по пятам. ");
INSERT INTO russyn_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Для Асира - слишком тучен хлеб его, и он будет доставлять царские яства. ");
INSERT INTO russyn_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Неффалим - теревинф рослый, распускающий прекрасные ветви. ");
INSERT INTO russyn_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Иосиф - отрасль плодоносного дерева, отрасль плодоносного дерева над источником; ветви его простираются над стеною; ");
INSERT INTO russyn_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","огорчали его, и стреляли и враждовали на него стрельцы, ");
INSERT INTO russyn_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","но тверд остался лук его, и крепки мышцы рук его, от рук мощного Бога Иаковлева. Оттуда Пастырь и твердыня Израилева, ");
INSERT INTO russyn_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","от Бога отца твоего, Который и да поможет тебе, и от Всемогущего, Который и да благословит тебя благословениями небесными свыше, благословениями бездны, лежащей долу, благословениями сосцов и утробы, ");
INSERT INTO russyn_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","благословениями отца твоего, которые превышают благословения гор древних и приятности холмов вечных; да будут они на голове Иосифа и на темени избранного между братьями своими. ");
INSERT INTO russyn_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Вениамин, хищный волк, утром будет есть ловитву и вечером будет делить добычу. ");
INSERT INTO russyn_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Вот все двенадцать колен Израилевых; и вот что сказал им отец их; и благословил их, и дал им благословение, каждому свое. ");
INSERT INTO russyn_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","И заповедал он им и сказал им: я прилагаюсь к народу моему; похороните меня с отцами моими в пещере, которая на поле Ефрона Хеттеянина, ");
INSERT INTO russyn_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","в пещере, которая на поле Махпела, что пред Мамре, в земле Ханаанской, которую пещеру купил Авраам с полем у Ефрона Хеттеянина в собственность для погребения; ");
INSERT INTO russyn_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","там похоронили Авраама и Сарру, жену его; там похоронили Исаака и Ревекку, жену его; и там похоронил я Лию; ");
INSERT INTO russyn_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","это поле и пещера, которая на нем, куплена у сынов Хеттеевых. ");
INSERT INTO russyn_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","И окончил Иаков завещание сыновьям своим, и положил ноги свои на постель, и скончался, и приложился к народу своему. ");
INSERT INTO russyn_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Иосиф пал на лице отца своего, и плакал над ним, и целовал его. ");
INSERT INTO russyn_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","И повелел Иосиф слугам своим - врачам бальзамировать отца его; и врачи набальзамировали Израиля. ");
INSERT INTO russyn_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","И исполнилось ему сорок дней, ибо столько дней употребляется на бальзамирование, и оплакивали его Египтяне семьдесят дней. ");
INSERT INTO russyn_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Когда же прошли дни плача по нем, Иосиф сказал придворным фараона, говоря: если я обрел благоволение в очах ваших, то скажите фараону так: ");
INSERT INTO russyn_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","отец мой заклял меня, сказав: вот, я умираю; во гробе моем, который я выкопал себе в земле Ханаанской, там похорони меня. И теперь хотел бы я пойти и похоронить отца моего и возвратиться. Слова Иосифа пересказали фараону. ");
INSERT INTO russyn_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","И сказал фараон: пойди и похорони отца твоего, как он заклял тебя. ");
INSERT INTO russyn_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","И пошел Иосиф хоронить отца своего. И пошли с ним все слуги фараона, старейшины дома его и все старейшины земли Египетской, ");
INSERT INTO russyn_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","и весь дом Иосифа, и братья его, и дом отца его. Только детей своих и мелкий и крупный скот свой оставили в земле Гесем. ");
INSERT INTO russyn_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","С ним отправились также колесницы и всадники, так что сонм был весьма велик. ");
INSERT INTO russyn_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","И дошли они до Горен-гаатада при Иордане и плакали там плачем великим и весьма сильным; и сделал Иосиф плач по отце своем семь дней. ");
INSERT INTO russyn_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","И видели жители земли той, Хананеи, плач в Горен-гаатаде, и сказали: велик плач этот у Египтян! Посему наречено имя месту тому: плач Египтян, что при Иордане. ");
INSERT INTO russyn_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","И сделали сыновья Иакова с ним, как он заповедал им; ");
INSERT INTO russyn_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","и отнесли его сыновья его в землю Ханаанскую и похоронили его в пещере на поле Махпела, которую купил Авраам с полем в собственность для погребения у Ефрона Хеттеянина, пред Мамре. ");
INSERT INTO russyn_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","И возвратился Иосиф в Египет, сам и братья его и все ходившие с ним хоронить отца его, после погребения им отца своего. ");
INSERT INTO russyn_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","И увидели братья Иосифовы, что умер отец их, и сказали: что, если Иосиф возненавидит нас и захочет отмстить нам за все зло, которое мы ему сделали? ");
INSERT INTO russyn_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","И послали они сказать Иосифу: отец твой пред смертью своею завещал, говоря: ");
INSERT INTO russyn_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","так скажите Иосифу: прости братьям твоим вину и грех их, так как они сделали тебе зло. И ныне прости вины рабов Бога отца твоего. Иосиф плакал, когда ему говорили это. ");
INSERT INTO russyn_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Пришли и сами братья его, и пали пред лицем его, и сказали: вот, мы рабы тебе. ");
INSERT INTO russyn_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","И сказал Иосиф: не бойтесь, ибо я боюсь Бога; ");
INSERT INTO russyn_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","вот, вы умышляли против меня зло; но Бог обратил это в добро, чтобы сделать то, что теперь есть: сохранить жизнь великому числу людей; ");
INSERT INTO russyn_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","итак не бойтесь: я буду питать вас и детей ваших. И успокоил их и говорил по сердцу их. ");
INSERT INTO russyn_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","И жил Иосиф в Египте сам и дом отца его; жил же Иосиф всего сто десять лет. ");
INSERT INTO russyn_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","И видел Иосиф детей у Ефрема до третьего рода, также и сыновья Махира, сына Манассиина, родились на колени Иосифа. ");
INSERT INTO russyn_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","И сказал Иосиф братьям своим: я умираю, но Бог посетит вас и выведет вас из земли сей в землю, о которой клялся Аврааму, Исааку и Иакову. ");
INSERT INTO russyn_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","И заклял Иосиф сынов Израилевых, говоря: Бог посетит вас, и вынесите кости мои отсюда. ");
INSERT INTO russyn_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","И умер Иосиф ста десяти лет. И набальзамировали его и положили в ковчег в Египте. ");
INSERT INTO russyn_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Вот имена сынов Израилевых, которые вошли в Египет с Иаковом отцом их, вошли каждый со всем домом своим: ");
INSERT INTO russyn_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Рувим, Симеон, Левий и Иуда, ");
INSERT INTO russyn_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Иссахар, Завулон и Вениамин, ");
INSERT INTO russyn_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Дан и Неффалим, Гад и Асир. ");
INSERT INTO russyn_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Всех же душ, происшедших от чресл Иакова, было семьдесят пять, а Иосиф был уже в Египте. ");
INSERT INTO russyn_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","И умер Иосиф и все братья его, и весь род их; ");
INSERT INTO russyn_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","а сыны Израилевы расплодились и размножились, и возросли и усилились чрезвычайно, и наполнилась ими земля та. ");
INSERT INTO russyn_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","И восстал в Египте новый царь, который не знал Иосифа, ");
INSERT INTO russyn_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","и сказал народу своему: вот, народ сынов Израилевых многочислен и сильнее нас; ");
INSERT INTO russyn_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","перехитрим же его, чтобы он не размножался; иначе, когда случится война, соединится и он с нашими неприятелями, и вооружится против нас, и выйдет из земли нашей. ");
INSERT INTO russyn_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","И поставили над ним начальников работ, чтобы изнуряли его тяжкими работами. И он построил фараону Пифом и Раамсес, города для запасов, и Он, иначе Илиополь. ");
INSERT INTO russyn_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Но чем более изнуряли его, тем более он умножался и тем более возрастал, так что Египтяне опасались сынов Израилевых. ");
INSERT INTO russyn_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","И потому Египтяне с жестокостью принуждали сынов Израилевых к работам ");
INSERT INTO russyn_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","и делали жизнь их горькою от тяжкой работы над глиною и кирпичами и от всякой работы полевой, от всякой работы, к которой принуждали их с жестокостью. ");
INSERT INTO russyn_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Царь Египетский повелел повивальным бабкам Евреянок, из коих одной имя Шифра, а другой Фуа, ");
INSERT INTO russyn_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","и сказал им: когда вы будете повивать у Евреянок, то наблюдайте при родах: если будет сын, то умерщвляйте его, а если дочь, то пусть живет. ");
INSERT INTO russyn_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Но повивальные бабки боялись Бога и не делали так, как говорил им царь Египетский, и оставляли детей в живых. ");
INSERT INTO russyn_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Царь Египетский призвал повивальных бабок и сказал им: для чего вы делаете такое дело, что оставляете детей в живых? ");
INSERT INTO russyn_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Повивальные бабки сказали фараону: Еврейские женщины не так, как Египетские; они здоровы, ибо прежде нежели придет к ним повивальная бабка, они уже рождают. ");
INSERT INTO russyn_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","За сие Бог делал добро повивальным бабкам, а народ умножался и весьма усиливался. ");
INSERT INTO russyn_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","И так как повивальные бабки боялись Бога, то Он устроял домы их. ");
INSERT INTO russyn_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Тогда фараон всему народу своему повелел, говоря: всякого новорожденного у Евреев сына бросайте в реку, а всякую дочь оставляйте в живых. ");
INSERT INTO russyn_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Некто из племени Левиина пошел и взял себе жену из того же племени. ");
INSERT INTO russyn_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Жена зачала и родила сына и, видя, что он очень красив, скрывала его три месяца; ");
INSERT INTO russyn_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","но, не могши долее скрывать его, взяла корзинку из тростника и осмолила ее асфальтом и смолою и, положив в нее младенца, поставила в тростнике у берега реки, ");
INSERT INTO russyn_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","а сестра его стала вдали наблюдать, что с ним будет. ");
INSERT INTO russyn_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","И вышла дочь фараонова на реку мыться, а прислужницы ее ходили по берегу реки. Она увидела корзинку среди тростника и послала рабыню свою взять ее. ");
INSERT INTO russyn_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Открыла и увидела младенца; и вот, дитя плачет в корзинке; и сжалилась над ним дочь фараонова и сказала: это из Еврейских детей. ");
INSERT INTO russyn_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","И сказала сестра его дочери фараоновой: не сходить ли мне и не позвать ли к тебе кормилицу из Евреянок, чтоб она вскормила тебе младенца? ");
INSERT INTO russyn_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Дочь фараонова сказала ей: сходи. Девица пошла и призвала мать младенца. ");
INSERT INTO russyn_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Дочь фараонова сказала ей: возьми младенца сего и вскорми его мне; я дам тебе плату. Женщина взяла младенца и кормила его. ");
INSERT INTO russyn_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","И вырос младенец, и она привела его к дочери фараоновой, и он был у нее вместо сына, и нарекла имя ему: Моисей, потому что, говорила она, я из воды вынула его. ");
INSERT INTO russyn_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Спустя много времени, когда Моисей вырос, случилось, что он вышел к братьям своим сынам Израилевым и увидел тяжкие работы их; и увидел, что Египтянин бьет одного Еврея из братьев его, сынов Израилевых. ");
INSERT INTO russyn_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Посмотрев туда и сюда и видя, что нет никого, он убил Египтянина и скрыл его в песке. ");
INSERT INTO russyn_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","И вышел он на другой день, и вот, два Еврея ссорятся; и сказал он обижающему: зачем ты бьешь ближнего твоего? ");
INSERT INTO russyn_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","А тот сказал: кто поставил тебя начальником и судьею над нами? не думаешь ли убить меня, как убил вчера Египтянина? Моисей испугался и сказал: верно, узнали об этом деле. ");
INSERT INTO russyn_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","И услышал фараон об этом деле и хотел убить Моисея; но Моисей убежал от фараона и остановился в земле Мадиамской, и придя в землю Мадиамскую сел у колодезя. ");
INSERT INTO russyn_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","У священника Мадиамского было семь дочерей, которые пасли овец отца своего Иофора. Они пришли, начерпали воды и наполнили корыта, чтобы напоить овец отца своего Иофора. ");
INSERT INTO russyn_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","И пришли пастухи и отогнали их. Тогда встал Моисей и защитил их, и начерпал им воды и напоил овец их. ");
INSERT INTO russyn_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","И пришли они к Рагуилу, отцу своему, и он сказал им: что вы так скоро пришли сегодня? ");
INSERT INTO russyn_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Они сказали: какой-то Египтянин защитил нас от пастухов, и даже начерпал нам воды и напоил овец наших. ");
INSERT INTO russyn_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Он сказал дочерям своим: где же он? зачем вы его оставили? позовите его, и пусть он ест хлеб. ");
INSERT INTO russyn_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Моисею понравилось жить у сего человека; и он выдал за Моисея дочь свою Сепфору. ");
INSERT INTO russyn_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Она зачала и родила сына, и Моисей нарек ему имя: Гирсам, потому что, говорил он, я стал пришельцем в чужой земле. И зачав еще, родила другого сына, и он нарек ему имя: Елиезер, сказав: Бог отца моего был мне помощником и избавил меня от руки фараона. ");
INSERT INTO russyn_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Спустя долгое время, умер царь Египетский. И стенали сыны Израилевы от работы и вопияли, и вопль их от работы восшел к Богу. ");
INSERT INTO russyn_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","И услышал Бог стенание их, и вспомнил Бог завет Свой с Авраамом, Исааком и Иаковом. ");
INSERT INTO russyn_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","И увидел Бог сынов Израилевых, и призрел их Бог. ");
INSERT INTO russyn_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Моисей пас овец у Иофора, тестя своего, священника Мадиамского. Однажды провел он стадо далеко в пустыню и пришел к горе Божией, Хориву. ");
INSERT INTO russyn_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","И явился ему Ангел Господень в пламени огня из среды тернового куста. И увидел он, что терновый куст горит огнем, но куст не сгорает. ");
INSERT INTO russyn_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Моисей сказал: пойду и посмотрю на сие великое явление, отчего куст не сгорает. ");
INSERT INTO russyn_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Господь увидел, что он идет смотреть, и воззвал к нему Бог из среды куста, и сказал: Моисей! Моисей! Он сказал: вот я, Господи! ");
INSERT INTO russyn_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","И сказал Бог: не подходи сюда; сними обувь твою с ног твоих, ибо место, на котором ты стоишь, есть земля святая. ");
INSERT INTO russyn_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","И сказал ему: Я Бог отца твоего, Бог Авраама, Бог Исаака и Бог Иакова. Моисей закрыл лице свое, потому что боялся воззреть на Бога. ");
INSERT INTO russyn_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","И сказал Господь Моисею: Я увидел страдание народа Моего в Египте и услышал вопль его от приставников его; Я знаю скорби его ");
INSERT INTO russyn_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","и иду избавить его от руки Египтян и вывести его из земли сей и ввести его в землю хорошую и пространную, где течет молоко и мед, в землю Хананеев, Хеттеев, Аморреев, Ферезеев, Гергесеев, Евеев и Иевусеев. ");
INSERT INTO russyn_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","И вот, уже вопль сынов Израилевых дошел до Меня, и Я вижу угнетение, каким угнетают их Египтяне. ");
INSERT INTO russyn_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Итак пойди: Я пошлю тебя к фараону царю Египетскому; и выведи из Египта народ Мой, сынов Израилевых. ");
INSERT INTO russyn_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Моисей сказал Богу: кто я, чтобы мне идти к фараону царю Египетскому и вывести из Египта сынов Израилевых? ");
INSERT INTO russyn_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","И сказал Бог: Я буду с тобою, и вот тебе знамение, что Я послал тебя: когда ты выведешь народ Мой из Египта, вы совершите служение Богу на этой горе. ");
INSERT INTO russyn_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","И сказал Моисей Богу: вот, я приду к сынам Израилевым и скажу им: Бог отцов ваших послал меня к вам. А они скажут мне: как Ему имя? Что сказать мне им? ");
INSERT INTO russyn_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Бог сказал Моисею: Я есмь Сущий. И сказал: так скажи сынам Израилевым: Сущий (Иегова) послал меня к вам. ");
INSERT INTO russyn_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","И сказал еще Бог Моисею: так скажи сынам Израилевым: Господь, Бог отцов ваших, Бог Авраама, Бог Исаака и Бог Иакова послал меня к вам. Вот имя Мое навеки, и памятование о Мне из рода в род. ");
INSERT INTO russyn_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Пойди, собери старейшин сынов Израилевых и скажи им: Господь, Бог отцов ваших, явился мне, Бог Авраама, Бог Исаака и Бог Иакова, и сказал: Я посетил вас и увидел, что делается с вами в Египте. ");
INSERT INTO russyn_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","И сказал: Я выведу вас от угнетения Египетского в землю Хананеев, Хеттеев, Аморреев, Ферезеев, Гергесеев, Евеев и Иевусеев, в землю, где течет молоко и мед. ");
INSERT INTO russyn_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","И они послушают голоса твоего, и пойдешь ты и старейшины Израилевы к фараону царю Египетскому, и скажете ему: Господь, Бог Евреев, призвал нас; итак отпусти нас в пустыню, на три дня пути, чтобы принести жертву Господу, Богу нашему. ");
INSERT INTO russyn_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Но Я знаю, что фараон царь Египетский не позволит вам идти, если не принудить его рукою крепкою; ");
INSERT INTO russyn_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","и простру руку Мою и поражу Египет всеми чудесами Моими, которые сделаю среди его; и после того он отпустит вас. ");
INSERT INTO russyn_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","И дам народу сему милость в глазах Египтян; и когда пойдете, то пойдете не с пустыми руками: ");
INSERT INTO russyn_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","каждая женщина выпросит у соседки своей и у живущей в доме ее вещей серебряных и вещей золотых, и одежд, и вы нарядите ими и сыновей ваших и дочерей ваших, и оберете Египтян. ");
INSERT INTO russyn_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","И отвечал Моисей и сказал: а если они не поверят мне и не послушают голоса моего и скажут: не явился тебе Господь? что сказать им? ");
INSERT INTO russyn_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","И сказал ему Господь: что это в руке у тебя? Он отвечал: жезл. ");
INSERT INTO russyn_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Господь сказал: брось его на землю. Он бросил его на землю, и жезл превратился в змея, и Моисей побежал от него. ");
INSERT INTO russyn_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","И сказал Господь Моисею: простри руку твою и возьми его за хвост. Он простер руку свою, и взял его за хвост; и он стал жезлом в руке его. ");
INSERT INTO russyn_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Это для того, чтобы поверили тебе, что явился тебе Господь, Бог отцов их, Бог Авраама, Бог Исаака и Бог Иакова. ");
INSERT INTO russyn_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Еще сказал ему Господь: положи руку твою к себе в пазуху. И он положил руку свою к себе в пазуху, вынул ее из пазухи своей, и вот, рука его побелела от проказы, как снег. ");
INSERT INTO russyn_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Еще сказал ему Господь: положи опять руку твою к себе в пазуху. И он положил руку свою к себе в пазуху; и вынул ее из пазухи своей, и вот, она опять стала такою же, как тело его. ");
INSERT INTO russyn_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Если они не поверят тебе и не послушают голоса первого знамения, то поверят голосу знамения другого; ");
INSERT INTO russyn_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","если же не поверят и двум сим знамениям и не послушают голоса твоего, то возьми воды из реки и вылей на сушу; и вода, взятая из реки, сделается кровью на суше. ");
INSERT INTO russyn_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","И сказал Моисей Господу: о, Господи! человек я не речистый, и таков был и вчера и третьего дня, и когда Ты начал говорить с рабом Твоим: я тяжело говорю и косноязычен. ");
INSERT INTO russyn_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Господь сказал Моисею: кто дал уста человеку? кто делает немым, или глухим, или зрячим, или слепым? не Я ли Господь Бог? ");
INSERT INTO russyn_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","итак пойди, и Я буду при устах твоих и научу тебя, что тебе говорить. ");
INSERT INTO russyn_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Моисей сказал: Господи! пошли другого, кого можешь послать. ");
INSERT INTO russyn_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","И возгорелся гнев Господень на Моисея, и Он сказал: разве нет у тебя Аарона брата, Левитянина? Я знаю, что он может говорить вместо тебя, и вот, он выйдет навстречу тебе, и, увидев тебя, возрадуется в сердце своем; ");
INSERT INTO russyn_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","ты будешь ему говорить и влагать слова Мои в уста его, а Я буду при устах твоих и при устах его и буду учить вас, что вам делать; ");
INSERT INTO russyn_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","и будет говорить он вместо тебя к народу; итак он будет твоими устами, а ты будешь ему вместо Бога; ");
INSERT INTO russyn_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","и жезл сей который был обращен в змея возьми в руку твою: им ты будешь творить знамения. ");
INSERT INTO russyn_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","И пошел Моисей, и возвратился к Иофору, тестю своему, и сказал ему: пойду я, и возвращусь к братьям моим, которые в Египте, и посмотрю, живы ли еще они? И сказал Иофор Моисею: иди с миром. Спустя много времени умер царь Египетский. ");
INSERT INTO russyn_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","И сказал Господь Моисею в земле Мадиамской: пойди, возвратись в Египет, ибо умерли все, искавшие души твоей. ");
INSERT INTO russyn_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","И взял Моисей жену свою и сыновей своих, посадил их на осла и отправился в землю Египетскую. И жезл Божий Моисей взял в руку свою. ");
INSERT INTO russyn_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","И сказал Господь Моисею: когда пойдешь и возвратишься в Египет, смотри, все чудеса, которые Я поручил тебе, сделай пред лицем фараона, а Я ожесточу сердце его, и он не отпустит народа. ");
INSERT INTO russyn_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","И скажи фараону: так говорит Господь Бог Еврейский: Израиль есть сын Мой, первенец Мой; ");
INSERT INTO russyn_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Я говорю тебе: отпусти сына Моего, чтобы он совершил Мне служение; а если не отпустишь его, то вот, Я убью сына твоего, первенца твоего. ");
INSERT INTO russyn_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Дорогою на ночлеге случилось, что встретил его Господь и хотел умертвить его. ");
INSERT INTO russyn_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Тогда Сепфора, взяв каменный нож, обрезала крайнюю плоть сына своего и, бросив к ногам его, сказала: ты жених крови у меня. ");
INSERT INTO russyn_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","И отошел от него Господь. Тогда сказала она: жених крови - по обрезанию. ");
INSERT INTO russyn_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","И Господь сказал Аарону: пойди навстречу Моисею в пустыню. И он пошел, и встретился с ним при горе Божией, и поцеловал его. ");
INSERT INTO russyn_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","И пересказал Моисей Аарону все слова Господа, Который его послал, и все знамения, которые Он заповедал. ");
INSERT INTO russyn_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","И пошел Моисей с Аароном, и собрали они всех старейшин сынов Израилевых, ");
INSERT INTO russyn_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","и пересказал им Аарон все слова, которые говорил Господь Моисею; и сделал Моисей знамения пред глазами народа, ");
INSERT INTO russyn_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","и поверил народ; и услышали, что Господь посетил сынов Израилевых и увидел страдание их, и преклонились они и поклонились. ");
INSERT INTO russyn_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","После сего Моисей и Аарон пришли к фараону и сказали ему: так говорит Господь, Бог Израилев: отпусти народ Мой, чтоб он совершил Мне праздник в пустыне. ");
INSERT INTO russyn_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Но фараон сказал: кто такой Господь, чтоб я послушался голоса Его и отпустил сынов Израиля? я не знаю Господа и Израиля не отпущу. ");
INSERT INTO russyn_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Они сказали ему: Бог Евреев призвал нас; отпусти нас в пустыню на три дня пути принести жертву Господу, Богу нашему, чтобы Он не поразил нас язвою, или мечом. ");
INSERT INTO russyn_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","И сказал им царь Египетский: для чего вы, Моисей и Аарон, отвлекаете народ мой от дел его? ступайте каждый из вас на свою работу. ");
INSERT INTO russyn_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","И сказал фараон: вот, народ в земле сей многочислен, и вы отвлекаете его от работ его. ");
INSERT INTO russyn_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","И в тот же день фараон дал повеление приставникам над народом и надзирателям, говоря: ");
INSERT INTO russyn_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","не давайте впредь народу соломы для делания кирпича, как вчера и третьего дня, пусть они сами ходят и собирают себе солому, ");
INSERT INTO russyn_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","а кирпичей наложите на них то же урочное число, какое они делали вчера и третьего дня, и не убавляйте; они праздны, потому и кричат: пойдем, принесем жертву Богу нашему; ");
INSERT INTO russyn_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","дать им больше работы, чтоб они работали и не занимались пустыми речами. ");
INSERT INTO russyn_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","И вышли приставники народа и надзиратели его и сказали народу: так говорит фараон: не даю вам соломы; ");
INSERT INTO russyn_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","сами пойдите, берите себе солому, где найдете, а от работы вашей ничего не убавляется. ");
INSERT INTO russyn_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","И рассеялся народ по всей земле Египетской собирать жниво вместо соломы. ");
INSERT INTO russyn_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Приставники же понуждали их, говоря: выполняйте урочную работу свою каждый день, как и тогда, когда была у вас солома. ");
INSERT INTO russyn_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","А надзирателей из сынов Израилевых, которых поставили над ними приставники фараоновы, били, говоря: почему вы вчера и сегодня не изготовляете урочного числа кирпичей, как было до сих пор? ");
INSERT INTO russyn_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","И пришли надзиратели сынов Израилевых и возопили к фараону, говоря: для чего ты так поступаешь с рабами твоими? ");
INSERT INTO russyn_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","соломы не дают рабам твоим, а кирпичи, говорят нам, делайте. И вот, рабов твоих бьют; грех народу твоему. ");
INSERT INTO russyn_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Но он сказал им: праздны вы, праздны, поэтому и говорите: пойдем, принесем жертву Господу. ");
INSERT INTO russyn_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Пойдите же, работайте; соломы не дадут вам, а положенное число кирпичей давайте. ");
INSERT INTO russyn_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","И увидели надзиратели сынов Израилевых беду свою в словах: не убавляйте числа кирпичей, какое положено на каждый день. ");
INSERT INTO russyn_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","И когда они вышли от фараона, то встретились с Моисеем и Аароном, которые стояли, ожидая их, ");
INSERT INTO russyn_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","и сказали им: да видит и судит вам Господь за то, что вы сделали нас ненавистными в глазах фараона и рабов его и дали им меч в руки, чтобы убить нас. ");
INSERT INTO russyn_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","И обратился Моисей к Господу и сказал: Господи! для чего Ты подвергнул такому бедствию народ сей, и для чего послал меня? ");
INSERT INTO russyn_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","ибо с того времени, как я пришел к фараону и стал говорить именем Твоим, он начал хуже поступать с народом сим; избавить же, - Ты не избавил народа Твоего. ");
INSERT INTO russyn_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","И сказал Господь Моисею: теперь увидишь ты, что Я сделаю с фараоном; по действию руки крепкой он отпустит их; по действию руки крепкой даже выгонит их из земли своей. ");
INSERT INTO russyn_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","И говорил Бог Моисею и сказал ему: Я Господь. ");
INSERT INTO russyn_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Являлся Я Аврааму, Исааку и Иакову с именем “Бог Всемогущий”, а с именем Моим “Господь” (Сущий) не открылся им; ");
INSERT INTO russyn_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","и Я поставил завет Мой с ними, чтобы дать им землю Ханаанскую, землю странствования их, в которой они странствовали. ");
INSERT INTO russyn_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","И Я услышал стенание сынов Израилевых о том, что Египтяне держат их в рабстве, и вспомнил завет Мой. ");
INSERT INTO russyn_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Итак скажи сынам Израилевым: Я Господь, и выведу вас из-под ига Египтян, и избавлю вас от рабства их, и спасу вас мышцею простертою и судами великими; ");
INSERT INTO russyn_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","и приму вас Себе в народ и буду вам Богом, и вы узнаете, что Я Господь, Бог ваш, изведший вас из земли Египетской из-под ига Египетского; ");
INSERT INTO russyn_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","и введу вас в ту землю, о которой Я, подняв руку Мою, клялся дать ее Аврааму, Исааку и Иакову, и дам вам ее в наследие. Я Господь. ");
INSERT INTO russyn_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Моисей пересказал это сынам Израилевым; но они не послушали Моисея по малодушию и тяжести работ. ");
INSERT INTO russyn_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","войди, скажи фараону, царю Египетскому, чтобы он отпустил сынов Израилевых из земли своей. ");
INSERT INTO russyn_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","И сказал Моисей пред Господом, говоря: вот, сыны Израилевы не слушают меня; как же послушает меня фараон? а я не словесен. ");
INSERT INTO russyn_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","И говорил Господь Моисею и Аарону, и давал им повеления к сынам Израилевым и к фараону, царю Египетскому, чтобы вывести сынов Израилевых из земли Египетской. ");
INSERT INTO russyn_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Вот начальники поколений их: сыны Рувима, первенца Израилева: Ханох и Фаллу, Хецрон и Харми: это семейства Рувимовы. ");
INSERT INTO russyn_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Сыны Симеона: Иемуил и Иамин, и Огад, и Иахин, и Цохар, и Саул, сын Хананеянки: это семейства Симеона. ");
INSERT INTO russyn_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Вот имена сынов Левия по родам их: Гирсон и Кааф и Мерари. А лет жизни Левия было сто тридцать семь. ");
INSERT INTO russyn_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Сыны Гирсона: Ливни и Шимеи с семействами их. ");
INSERT INTO russyn_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Сыны Каафовы: Амрам и Ицгар, и Хеврон, и Узиил. А лет жизни Каафа было сто тридцать три года. ");
INSERT INTO russyn_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Сыны Мерари: Махли и Муши. Это семейства Левия по родам их. ");
INSERT INTO russyn_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Амрам взял Иохаведу, тетку свою, себе в жену, и она родила ему Аарона и Моисея и Мариам, сестру их. А лет жизни Амрама было сто тридцать семь. ");
INSERT INTO russyn_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Сыны Ицгаровы: Корей и Нефег и Зихри. ");
INSERT INTO russyn_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Сыны Узииловы: Мисаил и Елцафан и Сифри. ");
INSERT INTO russyn_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Аарон взял себе в жену Елисавету, дочь Аминадава, сестру Наассона, и она родила ему Надава и Авиуда, Елеазара и Ифамара. ");
INSERT INTO russyn_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Сыны Корея: Асир, Елкана и Авиасаф: это семейства Кореевы. ");
INSERT INTO russyn_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Елеазар, сын Аарона, взял себе в жену одну из дочерей Футииловых, и она родила ему Финееса. Вот начальники поколений левитских по семействам их. ");
INSERT INTO russyn_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Аарон и Моисей, это - те, которым сказал Господь: выведите сынов Израилевых из земли Египетской по ополчениям их. ");
INSERT INTO russyn_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Они-то говорили фараону, царю Египетскому, чтобы вывести сынов Израилевых из Египта; это - Моисей и Аарон. ");
INSERT INTO russyn_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Итак в то время, когда Господь говорил Моисею в земле Египетской, ");
INSERT INTO russyn_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Господь сказал Моисею, говоря: Я Господь! скажи фараону, царю Египетскому, все, что Я говорю тебе. ");
INSERT INTO russyn_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Моисей же сказал пред Господом: вот, я несловесен: как же послушает меня фараон? ");
INSERT INTO russyn_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Но Господь сказал Моисею: смотри, Я поставил тебя Богом фараону, а Аарон, брат твой, будет твоим пророком: ");
INSERT INTO russyn_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","ты будешь говорить ему все, что Я повелю тебе, а Аарон, брат твой, будет говорить фараону, чтобы он отпустил сынов Израилевых из земли своей; ");
INSERT INTO russyn_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","но Я ожесточу сердце фараоново, и явлю множество знамений Моих и чудес Моих в земле Египетской; ");
INSERT INTO russyn_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","фараон не послушает вас, и Я наложу руку Мою на Египет и выведу воинство Мое, народ Мой, сынов Израилевых, из земли Египетской - судами великими; ");
INSERT INTO russyn_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","тогда узнают все Египтяне, что Я Господь, когда простру руку Мою на Египет и выведу сынов Израилевых из среды их. ");
INSERT INTO russyn_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","И сделали Моисей и Аарон, как повелел им Господь, так они и сделали. ");
INSERT INTO russyn_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Моисей был восьмидесяти, а Аарон брат его восьмидесяти трех лет, когда стали говорить они к фараону. ");
INSERT INTO russyn_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","И сказал Господь Моисею и Аарону, говоря: ");
INSERT INTO russyn_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","если фараон скажет вам: сделайте знамение или чудо, то ты скажи Аарону брату твоему: возьми жезл твой и брось на землю пред фараоном и пред рабами его, - он сделается змеем. ");
INSERT INTO russyn_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Моисей и Аарон пришли к фараону и к рабам его и сделали так, как повелел им Господь. И бросил Аарон жезл свой пред фараоном и пред рабами его, и он сделался змеем. ");
INSERT INTO russyn_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","И призвал фараон мудрецов Египетских и чародеев; и эти волхвы Египетские сделали то же своими чарами: ");
INSERT INTO russyn_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","каждый из них бросил свой жезл, и они сделались змеями, но жезл Ааронов поглотил их жезлы. ");
INSERT INTO russyn_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Сердце фараоново ожесточилось, и он не послушал их, как и говорил им Господь. ");
INSERT INTO russyn_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","И сказал Господь Моисею: упорно сердце фараоново: он не хочет отпустить народ. ");
INSERT INTO russyn_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Пойди к фараону завтра: вот, он выйдет к воде, ты стань на пути его, на берегу реки, и жезл, который превращался в змея, возьми в руку твою ");
INSERT INTO russyn_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","и скажи ему: Господь, Бог Евреев, послал меня сказать тебе: отпусти народ Мой, чтобы он совершил Мне служение в пустыне; но вот, ты доселе не послушался. ");
INSERT INTO russyn_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Так говорит Господь: из сего узнаешь, что Я Господь: вот этим жезлом, который в руке моей, я ударю по воде, которая в реке, и она превратится в кровь, ");
INSERT INTO russyn_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","и рыба в реке умрет, и река воссмердит, и Египтянам омерзительно будет пить воду из реки. ");
INSERT INTO russyn_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","И сказал Господь Моисею: скажи Аарону брату твоему: возьми жезл твой в руку твою и простри руку твою на воды Египтян: на реки их, на потоки их, на озера их и на всякое вместилище вод их, - и превратятся в кровь, и будет кровь по всей земле Египетской и в деревянных и в каменных сосудах. ");
INSERT INTO russyn_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","И сделали Моисей и Аарон, как повелел им Господь. И поднял Аарон жезл свой и ударил по воде речной пред глазами фараона и пред глазами рабов его, и вся вода в реке превратилась в кровь,- ");
INSERT INTO russyn_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","и рыба в реке вымерла, и река воссмердела, и Египтяне не могли пить воды из реки; и была кровь по всей земле Египетской. ");
INSERT INTO russyn_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","И волхвы Египетские чарами своими сделали то же. И ожесточилось сердце фараона, и не послушал их, как и говорил Господь. ");
INSERT INTO russyn_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","И оборотился фараон, и пошел в дом свой; и сердце его не тронулось и сим. ");
INSERT INTO russyn_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","И стали копать все Египтяне около реки, чтобы найти воду для питья, потому что не могли пить воды из реки. ");
INSERT INTO russyn_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","И исполнилось семь дней после того, как Господь поразил реку. ");
INSERT INTO russyn_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","И сказал Господь Моисею: пойди к фараону и скажи ему: так говорит Господь: отпусти народ Мой, чтобы он совершил Мне служение; ");
INSERT INTO russyn_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","если же ты не согласишься отпустить, то вот, Я поражаю всю область твою жабами; ");
INSERT INTO russyn_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","и воскишит река жабами, и они выйдут и войдут в дом твой, и в спальню твою, и на постель твою, и в домы рабов твоих и народа твоего, и в печи твои, и в квашни твои, ");
INSERT INTO russyn_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","и на тебя, и на народ твой, и на всех рабов твоих взойдут жабы. ");
INSERT INTO russyn_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","И сказал Господь Моисею: скажи Аарону брату твоему: простри руку твою с жезлом твоим на реки, на потоки и на озера и выведи жаб на землю Египетскую. ");
INSERT INTO russyn_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Аарон простер руку свою на воды Египетские и вывел жаб; и вышли жабы и покрыли землю Египетскую. ");
INSERT INTO russyn_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","То же сделали и волхвы Египетские чарами своими и вывели жаб на землю Египетскую. ");
INSERT INTO russyn_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","И призвал фараон Моисея и Аарона и сказал: помолитесь обо мне Господу, чтоб Он удалил жаб от меня и от народа моего, и я отпущу народ Израильский принести жертву Господу. ");
INSERT INTO russyn_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Моисей сказал фараону: назначь мне сам, когда помолиться за тебя, за рабов твоих и за народ твой, чтобы жабы исчезли у тебя, у народа твоего, в домах твоих, и остались только в реке. ");
INSERT INTO russyn_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Он сказал: завтра. Моисей отвечал: будет по слову твоему, дабы ты узнал, что нет никого, как Господь Бог наш; ");
INSERT INTO russyn_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","и удалятся жабы от тебя, от домов твоих и с полей, и от рабов твоих и от твоего народа; только в реке они останутся. ");
INSERT INTO russyn_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Моисей и Аарон вышли от фараона, и Моисей воззвал к Господу о жабах, которых Он навел на фараона. ");
INSERT INTO russyn_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","И сделал Господь по слову Моисея: жабы вымерли в домах, на дворах и на полях их; ");
INSERT INTO russyn_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","и собрали их в груды, и воссмердела земля. ");
INSERT INTO russyn_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","И увидел фараон, что сделалось облегчение, и ожесточил сердце свое, и не послушал их, как и говорил Господь. ");
INSERT INTO russyn_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","И сказал Господь Моисею: скажи Аарону: простри рукою жезл твой и ударь в персть земную, и будут мошки на людях и на скоте и на фараоне, и в доме его и на рабах его, вся персть земная сделается мошками по всей земле Египетской. ");
INSERT INTO russyn_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Так они и сделали: Аарон простер руку свою с жезлом своим и ударил в персть земную, и явились мошки на людях и на скоте. Вся персть земная сделалась мошками по всей земле Египетской. ");
INSERT INTO russyn_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Старались также и волхвы чарами своими произвести мошек, но не могли. И были мошки на людях и на скоте. ");
INSERT INTO russyn_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","И сказали волхвы фараону: это перст Божий. Но сердце фараоново ожесточилось, и он не послушал их, как и говорил Господь. ");
INSERT INTO russyn_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","И сказал Господь Моисею: завтра встань рано и явись пред лице фараона. Вот, он пойдет к воде, и ты скажи ему: так говорит Господь: отпусти народ Мой, чтобы он совершил Мне служение в пустыне; ");
INSERT INTO russyn_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","а если не отпустишь народа Моего, то вот, Я пошлю на тебя и на рабов твоих, и на народ твой, и в домы твои песьих мух, и наполнятся домы Египтян песьими мухами и самая земля, на которой они живут; ");
INSERT INTO russyn_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","и отделю в тот день землю Гесем, на которой пребывает народ Мой, и там не будет песьих мух, дабы ты знал, что Я Господь Бог среди всей земли; ");
INSERT INTO russyn_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Я сделаю разделение между народом Моим и между народом твоим. Завтра будет сие знамение на земле. ");
INSERT INTO russyn_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Так и сделал Господь: налетело множество песьих мух в дом фараонов, и в домы рабов его, и на всю землю Египетскую: погибала земля от песьих мух. ");
INSERT INTO russyn_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","И призвал фараон Моисея и Аарона и сказал: пойдите, принесите жертву Господу Богу вашему в сей земле. ");
INSERT INTO russyn_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Но Моисей сказал: нельзя сего сделать, ибо отвратительно для Египтян жертвоприношение наше Господу, Богу нашему: если мы отвратительную для Египтян жертву станем приносить в глазах их, то не побьют ли они нас камнями? ");
INSERT INTO russyn_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","мы пойдем в пустыню, на три дня пути, и принесем жертву Господу, Богу нашему, как скажет нам Господь. ");
INSERT INTO russyn_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","И сказал фараон: я отпущу вас принести жертву Господу Богу вашему в пустыне, только не уходите далеко; помолитесь обо мне Господу. ");
INSERT INTO russyn_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Моисей сказал: вот, я выхожу от тебя и помолюсь Господу Богу, и удалятся песьи мухи от фараона, и от рабов его, и от народа его завтра, только фараон пусть перестанет обманывать, не отпуская народа принести жертву Господу. ");
INSERT INTO russyn_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","И вышел Моисей от фараона и помолился Господу. ");
INSERT INTO russyn_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","И сделал Господь по слову Моисея и удалил песьих мух от фараона, от рабов его и от народа его: не осталось ни одной. ");
INSERT INTO russyn_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Но фараон ожесточил сердце свое и на этот раз и не отпустил народа. ");
INSERT INTO russyn_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","И сказал Господь Моисею: пойди к фараону и скажи ему: так говорит Господь, Бог Евреев: отпусти народ Мой, чтобы он совершил Мне служение; ");
INSERT INTO russyn_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","ибо если ты не захочешь отпустить народ Мой и еще будешь удерживать его, ");
INSERT INTO russyn_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","то вот, рука Господня будет на скоте твоем, который в поле, на конях, на ослах, на верблюдах, на волах и овцах: будет моровая язва весьма тяжкая; ");
INSERT INTO russyn_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","и разделит Господь в то время между скотом Израильским и скотом Египетским, и из всего скота сынов Израилевых не умрет ничего. ");
INSERT INTO russyn_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","И назначил Господь время, сказав: завтра сделает это Господь в земле сей. ");
INSERT INTO russyn_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","И сделал это Господь на другой день, и вымер весь скот Египетский; из скота же сынов Израилевых не умерло ничего. ");
INSERT INTO russyn_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Фараон послал узнать, и вот, из всего скота сынов Израилевых не умерло ничего. Но сердце фараоново ожесточилось, и он не отпустил народа. ");
INSERT INTO russyn_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","И сказал Господь Моисею и Аарону: возьмите по полной горсти пепла из печи, и пусть бросит его Моисей к небу в глазах фараона и рабов его; ");
INSERT INTO russyn_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","и поднимется пыль по всей земле Египетской, и будет на людях и на скоте воспаление с нарывами, во всей земле Египетской. ");
INSERT INTO russyn_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Они взяли пепла из печи и предстали пред лице фараона. Моисей бросил его к небу, и сделалось воспаление с нарывами на людях и на скоте. ");
INSERT INTO russyn_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","И не могли волхвы устоять пред Моисеем по причине воспаления, потому что воспаление было на волхвах и на всех Египтянах. ");
INSERT INTO russyn_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Но Господь ожесточил сердце фараона, и он не послушал их, как и говорил Господь Моисею. ");
INSERT INTO russyn_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","И сказал Господь Моисею: завтра встань рано и явись пред лице фараона, и скажи ему: так говорит Господь, Бог Евреев: отпусти народ Мой, чтобы он совершил Мне служение; ");
INSERT INTO russyn_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","ибо в этот раз Я пошлю все язвы Мои в сердце твое, и на рабов твоих, и на народ твой, дабы ты узнал, что нет подобного Мне на всей земле; ");
INSERT INTO russyn_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","так как Я простер руку Мою, то поразил бы тебя и народ твой язвою, и ты истреблен был бы с земли: ");
INSERT INTO russyn_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","но для того Я сохранил тебя, чтобы показать на тебе силу Мою, и чтобы возвещено было имя Мое по всей земле; ");
INSERT INTO russyn_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","ты еще противостоишь народу Моему, чтобы не отпускать его, ");
INSERT INTO russyn_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","вот, Я пошлю завтра, в это самое время, град весьма сильный, которому подобного не было в Египте со дня основания его доныне; ");
INSERT INTO russyn_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","итак пошли собрать стада твои и все, что есть у тебя в поле: на всех людей и скот, которые останутся в поле и не соберутся в домы, падет град, и они умрут. ");
INSERT INTO russyn_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Те из рабов фараоновых, которые убоялись слова Господня, поспешно собрали рабов своих и стада свои в домы; ");
INSERT INTO russyn_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","а кто не обратил сердца своего к слову Господню, тот оставил рабов своих и стада свои в поле. ");
INSERT INTO russyn_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","И сказал Господь Моисею: простри руку твою к небу, и падет град на всю землю Египетскую, на людей, на скот и на всю траву полевую в земле Египетской. ");
INSERT INTO russyn_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","И простер Моисей жезл свой к небу, и Господь произвел гром и град, и огонь разливался по земле; и послал Господь град на всю землю Египетскую; ");
INSERT INTO russyn_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","и был град и огонь между градом, град весьма сильный, какого не было во всей земле Египетской со времени населения ее. ");
INSERT INTO russyn_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","И побил град по всей земле Египетской все, что было в поле, от человека до скота, и всю траву полевую побил град, и все деревья в поле поломал град; ");
INSERT INTO russyn_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","только в земле Гесем, где жили сыны Израилевы, не было града. ");
INSERT INTO russyn_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","И послал фараон, и призвал Моисея и Аарона, и сказал им: на этот раз я согрешил; Господь праведен, а я и народ мой виновны; ");
INSERT INTO russyn_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","помолитесь обо мне Господу: пусть перестанут громы Божии и град и огонь на земле, и отпущу вас и не буду более удерживать. ");
INSERT INTO russyn_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Моисей сказал ему: как скоро я выйду из города, простру руки мои к Господу на небо, громы перестанут, и града и дождя более не будет, дабы ты узнал, что Господня земля; ");
INSERT INTO russyn_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","но я знаю, что ты и рабы твои еще не убоитесь Господа Бога. ");
INSERT INTO russyn_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Лен и ячмень были побиты, потому что ячмень выколосился, а лен осеменился; ");
INSERT INTO russyn_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","а пшеница и полба не побиты, потому что они были поздние. ");
INSERT INTO russyn_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","И вышел Моисей от фараона из города и простер руки свои к Господу, и прекратились гром и град, и дождь перестал литься на землю. ");
INSERT INTO russyn_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","И увидел фараон, что перестал дождь и град и гром, и продолжал грешить, и отягчил сердце свое сам и рабы его. ");
INSERT INTO russyn_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","И ожесточилось сердце фараона и рабов его, и он не отпустил сынов Израилевых, как и говорил Господь чрез Моисея. ");
INSERT INTO russyn_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","И сказал Господь Моисею: войди к фараону, ибо Я отягчил сердце его и сердце рабов его, чтобы явить между ними сии знамения Мои, ");
INSERT INTO russyn_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","и чтобы ты рассказывал сыну твоему и сыну сына твоего о том, что Я сделал в Египте, и о знамениях Моих, которые Я показал в нем, и чтобы вы знали, что Я Господь. ");
INSERT INTO russyn_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Моисей и Аарон пришли к фараону и сказали ему: так говорит Господь, Бог Евреев: долго ли ты не смиришься предо Мною? отпусти народ Мой, чтобы он совершил Мне служение; ");
INSERT INTO russyn_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","а если ты не отпустишь народа Моего, то вот, завтра в это самое время Я наведу саранчу на всю твою область: ");
INSERT INTO russyn_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","она покроет лице земли так, что нельзя будет видеть земли, и поест у вас все оставшееся на земле, уцелевшее от града; объест также все дерева, растущие у вас в поле, ");
INSERT INTO russyn_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","и наполнит домы твои, домы всех рабов твоих и все домы всех Египтян, чего не видели отцы твои, ни отцы отцов твоих со дня, как живут на земле, даже до сего дня. Моисей обратился и вышел от фараона. ");
INSERT INTO russyn_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Тогда рабы фараоновы сказали ему: долго ли он будет мучить нас? отпусти сих людей, пусть они совершат служение Господу, Богу своему; неужели ты еще не видишь, что Египет гибнет? ");
INSERT INTO russyn_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","И возвратили Моисея и Аарона к фараону, и фараон сказал им: пойдите, совершите служение Господу, Богу вашему; кто же и кто пойдет? ");
INSERT INTO russyn_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","И сказал Моисей: пойдем с малолетними нашими и стариками нашими, с сыновьями нашими и дочерями нашими, и с овцами нашими и с волами нашими пойдем, ибо у нас праздник Господу Богу нашему. ");
INSERT INTO russyn_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Фараон сказал им: пусть будет так, Господь с вами! я готов отпустить вас: но зачем с детьми? видите, у вас худое намерение! ");
INSERT INTO russyn_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","нет: пойдите одни мужчины и совершите служение Господу, так как вы сего просили. И выгнали их от фараона. ");
INSERT INTO russyn_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Тогда Господь сказал Моисею: простри руку твою на землю Египетскую, и пусть нападет саранча на землю Египетскую и поест всю траву земную и все плоды древесные, все, что уцелело от града. ");
INSERT INTO russyn_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","И простер Моисей жезл свой на землю Египетскую, и Господь навел на сию землю восточный ветер, продолжавшийся весь тот день и всю ночь. Настало утро, и восточный ветер нанес саранчу. ");
INSERT INTO russyn_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","И напала саранча на всю землю Египетскую и легла по всей стране Египетской в великом множестве: прежде не бывало такой саранчи, и после сего не будет такой; ");
INSERT INTO russyn_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","она покрыла лице всей земли, так что земли не было видно, и поела всю траву земную и все плоды древесные, уцелевшие от града, и не осталось никакой зелени ни на деревах, ни на траве полевой во всей земле Египетской. ");
INSERT INTO russyn_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Фараон поспешно призвал Моисея и Аарона и сказал: согрешил я пред Господом, Богом вашим, и пред вами; ");
INSERT INTO russyn_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","теперь простите грех мой еще раз и помолитесь Господу Богу вашему, чтобы Он только отвратил от меня сию смерть. ");
INSERT INTO russyn_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Моисей вышел от фараона и помолился Господу. ");
INSERT INTO russyn_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","И воздвигнул Господь с противной стороны западный весьма сильный ветер, и он понес саранчу и бросил ее в Чермное море: не осталось ни одной саранчи во всей стране Египетской. ");
INSERT INTO russyn_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Но Господь ожесточил сердце фараона, и он не отпустил сынов Израилевых. ");
INSERT INTO russyn_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","И сказал Господь Моисею: простри руку твою к небу, и будет тьма на земле Египетской, осязаемая тьма. ");
INSERT INTO russyn_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Моисей простер руку свою к небу, и была густая тьма по всей земле Египетской три дня; ");
INSERT INTO russyn_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","не видели друг друга, и никто не вставал с места своего три дня; у всех же сынов Израилевых был свет в жилищах их. ");
INSERT INTO russyn_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Фараон призвал Моисея и Аарона и сказал: пойдите, совершите служение Господу Богу вашему, пусть только останется мелкий и крупный скот ваш, а дети ваши пусть идут с вами. ");
INSERT INTO russyn_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Но Моисей сказал: нет, дай также в руки наши жертвы и всесожжения, чтобы принести Господу Богу нашему; ");
INSERT INTO russyn_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","пусть пойдут и стада наши с нами, не останется ни копыта; ибо из них мы возьмем на жертву Господу, Богу нашему; но доколе не придем туда, мы не знаем, что принести в жертву Господу Богу нашему. ");
INSERT INTO russyn_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","И ожесточил Господь сердце фараона, и он не захотел отпустить их. ");
INSERT INTO russyn_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","И сказал ему фараон: пойди от меня; берегись, не являйся более пред лице мое; в тот день, когда ты увидишь лице мое, умрешь. ");
INSERT INTO russyn_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","И сказал Моисей: как сказал ты, так и будет; я не увижу более лица твоего ");
INSERT INTO russyn_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","И сказал Господь Моисею: еще одну казнь Я наведу на фараона и на Египтян; после того он отпустит вас отсюда; когда же он будет отпускать вас, с поспешностью будет гнать вас отсюда; ");
INSERT INTO russyn_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","внуши народу тайно, чтобы каждый у ближнего своего и каждая женщина у ближней своей выпросили вещей серебряных и вещей золотых и одежд. ");
INSERT INTO russyn_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","И дал Господь милость народу Своему в глазах Египтян, и они давали ему; да и Моисей был весьма велик в земле Египетской, в глазах фараона и рабов фараоновых и в глазах всего народа. ");
INSERT INTO russyn_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","И сказал Моисей: так говорит Господь: в полночь Я пройду посреди Египта, ");
INSERT INTO russyn_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","и умрет всякий первенец в земле Египетской от первенца фараона, который сидит на престоле своем, до первенца рабыни, которая при жерновах, и все первородное из скота; ");
INSERT INTO russyn_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","и будет вопль великий по всей земле Египетской, какого не бывало и какого не будет более; ");
INSERT INTO russyn_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","у всех же сынов Израилевых ни на человека, ни на скот не пошевелит пес языком своим, дабы вы знали, какое различие делает Господь между Египтянами и между Израильтянами. ");
INSERT INTO russyn_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","И придут все рабы твои сии ко мне и поклонятся мне, говоря: выйди ты и весь народ твой, которым ты предводительствуешь. После сего я и выйду. И вышел Моисей от фараона с гневом. ");
INSERT INTO russyn_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","И сказал Господь Моисею: не послушал вас фараон, чтобы умножились знамения Мои и чудеса Мои в земле Египетской. ");
INSERT INTO russyn_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Моисей и Аарон сделали все сии знамения и чудеса пред фараоном; но Господь ожесточил сердце фараона, и он не отпустил сынов Израилевых из земли своей. ");
INSERT INTO russyn_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","И сказал Господь Моисею и Аарону в земле Египетской, говоря: ");
INSERT INTO russyn_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","месяц сей да будет у вас началом месяцев, первым да будет он у вас между месяцами года. ");
INSERT INTO russyn_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Скажите всему обществу сынов Израилевых: в десятый день сего месяца пусть возьмут себе каждый одного агнца по семействам, по агнцу на семейство; ");
INSERT INTO russyn_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","а если семейство так мало, что не съест агнца, то пусть возьмет с соседом своим, ближайшим к дому своему, по числу душ: по той мере, сколько каждый съест, расчислитесь на агнца. ");
INSERT INTO russyn_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Агнец у вас должен быть без порока, мужеского пола, однолетний; возьмите его от овец, или от коз, ");
INSERT INTO russyn_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","и пусть он хранится у вас до четырнадцатого дня сего месяца: тогда пусть заколет его все собрание общества Израильского вечером, ");
INSERT INTO russyn_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","и пусть возьмут от крови его и помажут на обоих косяках и на перекладине дверей в домах, где будут есть его; ");
INSERT INTO russyn_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","пусть съедят мясо его в сию самую ночь, испеченное на огне; с пресным хлебом и с горькими травами пусть съедят его; ");
INSERT INTO russyn_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","не ешьте от него недопеченного, или сваренного в воде, но ешьте испеченное на огне, голову с ногами и внутренностями; ");
INSERT INTO russyn_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","не оставляйте от него до утра и кости его не сокрушайте, но оставшееся от него до утра сожгите на огне. ");
INSERT INTO russyn_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Ешьте же его так: пусть будут чресла ваши препоясаны, обувь ваша на ногах ваших и посохи ваши в руках ваших, и ешьте его с поспешностью: это - Пасха Господня. ");
INSERT INTO russyn_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","А Я в сию самую ночь пройду по земле Египетской и поражу всякого первенца в земле Египетской, от человека до скота, и над всеми богами Египетскими произведу суд. Я Господь. ");
INSERT INTO russyn_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","И будет у вас кровь знамением на домах, где вы находитесь, и увижу кровь и пройду мимо вас, и не будет между вами язвы губительной, когда буду поражать землю Египетскую. ");
INSERT INTO russyn_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","И да будет вам день сей памятен, и празднуйте в оный праздник Господу во все роды ваши; как установление вечное празднуйте его. ");
INSERT INTO russyn_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Семь дней ешьте пресный хлеб; с самого первого дня уничтожьте квасное в домах ваших, ибо кто будет есть квасное с первого дня до седьмого дня, душа та истреблена будет из среды Израиля. ");
INSERT INTO russyn_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","И в первый день да будет у вас священное собрание, и в седьмой день священное собрание: никакой работы не должно делать в них; только что есть каждому, одно то можно делать вам. ");
INSERT INTO russyn_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Наблюдайте опресноки, ибо в сей самый день Я вывел ополчения ваши из земли Египетской, и наблюдайте день сей в роды ваши, как установление вечное. ");
INSERT INTO russyn_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","С четырнадцатого дня первого месяца, с вечера ешьте пресный хлеб до вечера двадцать первого дня того же месяца; ");
INSERT INTO russyn_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","семь дней не должно быть закваски в домах ваших, ибо кто будет есть квасное, душа та истреблена будет из общества сынов Израилевых, пришлец ли то, или природный житель земли той. ");
INSERT INTO russyn_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Ничего квасного не ешьте; во всяком местопребывании вашем ешьте пресный хлеб. ");
INSERT INTO russyn_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","И созвал Моисей всех старейшин сынов Израилевых и сказал им: выберите и возьмите себе агнцев по семействам вашим и заколите пасху; ");
INSERT INTO russyn_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","и возьмите пучок иссопа, и обмочите в кровь, которая в сосуде, и помажьте перекладину и оба косяка дверей кровью, которая в сосуде; а вы никто не выходите за двери дома своего до утра. ");
INSERT INTO russyn_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","И пойдет Господь поражать Египет, и увидит кровь на перекладине и на обоих косяках, и пройдет Господь мимо дверей, и не попустит губителю войти в домы ваши для поражения. ");
INSERT INTO russyn_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Храните сие как закон для себя и для сынов своих навеки. ");
INSERT INTO russyn_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Когда войдете в землю, которую Господь даст вам, как Он говорил, соблюдайте сие служение. ");
INSERT INTO russyn_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","И когда скажут вам дети ваши: что это за служение? ");
INSERT INTO russyn_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","скажите им: это пасхальная жертва Господу, Который прошел мимо домов сынов Израилевых в Египте, когда поражал Египтян, и домы наши избавил. И преклонился народ и поклонился. ");
INSERT INTO russyn_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","И пошли сыны Израилевы и сделали: как повелел Господь Моисею и Аарону, так и сделали. ");
INSERT INTO russyn_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","В полночь Господь поразил всех первенцев в земле Египетской, от первенца фараона, сидевшего на престоле своем, до первенца узника, находившегося в темнице, и все первородное из скота. ");
INSERT INTO russyn_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","И встал фараон ночью сам и все рабы его и весь Египет; и сделался великий вопль во всей земле Египетской, ибо не было дома, где не было бы мертвеца. ");
INSERT INTO russyn_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","И призвал фараон Моисея и Аарона ночью и сказал им: встаньте, выйдите из среды народа моего, как вы, так и сыны Израилевы, и пойдите, совершите служение Господу Богу вашему, как говорили вы; ");
INSERT INTO russyn_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","и мелкий и крупный скот ваш возьмите, как вы говорили; и пойдите и благословите меня. ");
INSERT INTO russyn_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","И понуждали Египтяне народ, чтобы скорее выслать его из земли той; ибо говорили они: мы все помрем. ");
INSERT INTO russyn_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","И понес народ тесто свое, прежде нежели оно вскисло; квашни их, завязанные в одеждах их, были на плечах их. ");
INSERT INTO russyn_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","И сделали сыны Израилевы по слову Моисея и просили у Египтян вещей серебряных и вещей золотых и одежд. ");
INSERT INTO russyn_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Господь же дал милость народу Своему в глазах Египтян: и они давали ему, и обобрал он Египтян. ");
INSERT INTO russyn_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","И отправились сыны Израилевы из Раамсеса в Сокхоф до шестисот тысяч пеших мужчин, кроме детей; ");
INSERT INTO russyn_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","и множество разноплеменных людей вышли с ними, и мелкий и крупный скот, стадо весьма большое. ");
INSERT INTO russyn_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","И испекли они из теста, которое вынесли из Египта, пресные лепешки, ибо оно еще не вскисло, потому что они выгнаны были из Египта и не могли медлить, и даже пищи не приготовили себе на дорогу. ");
INSERT INTO russyn_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Времени же, в которое сыны Израилевы и отцы их обитали в Египте и в земле Ханаанской, было четыреста тридцать лет. ");
INSERT INTO russyn_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","По прошествии четырехсот тридцати лет, в этот самый день вышло все ополчение Господне из земли Египетской ночью. ");
INSERT INTO russyn_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Это - ночь бдения Господу за изведение их из земли Египетской; эта самая ночь - бдение Господу у всех сынов Израилевых в роды их. ");
INSERT INTO russyn_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","И сказал Господь Моисею и Аарону: вот устав Пасхи: никакой иноплеменник не должен есть ее; ");
INSERT INTO russyn_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","а всякий раб, купленный за серебро, когда обрежешь его, может есть ее; ");
INSERT INTO russyn_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","поселенец и наемник не должен есть ее. ");
INSERT INTO russyn_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","В одном доме должно есть ее, не оставляйте от нее до утра, не выносите мяса вон из дома и костей ее не сокрушайте. ");
INSERT INTO russyn_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Все общество сынов Израиля должно совершать ее. ");
INSERT INTO russyn_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Если же поселится у тебя пришлец и захочет совершить Пасху Господу, то обрежь у него всех мужеского пола, и тогда пусть он приступит к совершению ее и будет как природный житель земли; а никакой необрезанный не должен есть ее; ");
INSERT INTO russyn_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","один закон да будет и для природного жителя, и для пришельца, поселившегося между вами. ");
INSERT INTO russyn_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","И сделали все сыны Израилевы: как повелел Господь Моисею и Аарону, так и сделали. ");
INSERT INTO russyn_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","В этот самый день Господь вывел сынов Израилевых из земли Египетской по ополчениям их. ");
INSERT INTO russyn_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","освяти Мне каждого первенца, разверзающего всякие ложесна между сынами Израилевыми, от человека до скота, потому что Мои они. ");
INSERT INTO russyn_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","И сказал Моисей народу: помните сей день, в который вышли вы из Египта, из дома рабства, ибо рукою крепкою вывел вас Господь оттоле, и не ешьте квасного: ");
INSERT INTO russyn_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","сегодня выходите вы, в месяце Авиве. ");
INSERT INTO russyn_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","И когда введет тебя Господь Бог твой в землю Хананеев и Хеттеев, и Аморреев, и Евеев, и Иевусеев, Гергесеев, и Ферезеев, о которой клялся Он отцам твоим, что даст тебе землю, где течет молоко и мед, то совершай сие служение в сем месяце; ");
INSERT INTO russyn_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","семь дней ешь пресный хлеб, и в седьмой день - праздник Господу; ");
INSERT INTO russyn_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","пресный хлеб должно есть семь дней, и не должно находиться у тебя квасного хлеба, и не должно находиться у тебя квасного во всех пределах твоих. ");
INSERT INTO russyn_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","И объяви в день тот сыну твоему, говоря: это ради того, что Господь Бог сделал со мною, когда я вышел из Египта. ");
INSERT INTO russyn_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","И да будет тебе это знаком на руке твоей и памятником пред глазами твоими, дабы закон Господень был в устах твоих, ибо рукою крепкою вывел тебя Господь Бог из Египта. ");
INSERT INTO russyn_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Исполняй же устав сей в назначенное время, из года в год. ");
INSERT INTO russyn_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","И когда введет тебя Господь Бог твой в землю Ханаанскую, как Он клялся тебе и отцам твоим, и даст ее тебе, ");
INSERT INTO russyn_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","отделяй Господу все мужеского пола разверзающее ложесна; и все первородное из скота, какой у тебя будет, мужеского пола, посвящай Господу, ");
INSERT INTO russyn_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","а всякого из ослов, разверзающего утробу, заменяй агнцем; а если не заменишь, выкупи его; и каждого первенца человеческого из сынов твоих выкупай. ");
INSERT INTO russyn_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","И когда после спросит тебя сын твой, говоря: что это? то скажи ему: рукою крепкою вывел нас Господь из Египта, из дома рабства; ");
INSERT INTO russyn_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","ибо когда фараон упорствовал отпустить нас, Господь умертвил всех первенцев в земле Египетской, от первенца человеческого до первенца из скота,- посему я приношу в жертву Господу все, разверзающее ложесна, мужеского пола, а всякого первенца из сынов моих выкупаю; ");
INSERT INTO russyn_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","и да будет это знаком на руке твоей и вместо повязки над глазами твоими, ибо рукою крепкою Господь вывел нас из Египта. ");
INSERT INTO russyn_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Когда же фараон отпустил народ, Бог не повел его по дороге земли Филистимской, потому что она близка; ибо сказал Бог: чтобы не раскаялся народ, увидев войну, и не возвратился в Египет. ");
INSERT INTO russyn_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","И обвел Бог народ дорогою пустынною к Чермному морю. И вышли сыны Израилевы вооруженные из земли Египетской. ");
INSERT INTO russyn_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","И взял Моисей с собою кости Иосифа, ибо Иосиф клятвою заклял сынов Израилевых, сказав: посетит вас Бог, и вы с собою вынесите кости мои отсюда. ");
INSERT INTO russyn_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","И двинулись сыны Израилевы из Сокхофа и расположились станом в Ефаме, в конце пустыни. ");
INSERT INTO russyn_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Господь же шел пред ними днем в столпе облачном, показывая им путь, а ночью в столпе огненном, светя им, дабы идти им и днем и ночью. ");
INSERT INTO russyn_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Не отлучался столп облачный днем и столп огненный ночью от лица всего народа. ");
INSERT INTO russyn_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","скажи сынам Израилевым, чтобы они обратились и расположились станом пред Пи-Гахирофом, между Мигдолом и между морем, пред Ваал-Цефоном; напротив его поставьте стан у моря. ");
INSERT INTO russyn_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","И скажет фараон народу своему о сынах Израилевых: они заблудились в земле сей, заперла их пустыня. ");
INSERT INTO russyn_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","А Я ожесточу сердце фараона, и он погонится за ними, и покажу славу Мою на фараоне и на всем войске его; и познают все Египтяне, что Я Господь. И сделали так. ");
INSERT INTO russyn_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","И возвещено было царю Египетскому, что народ бежал; и обратилось сердце фараона и рабов его против народа сего, и они сказали: что это мы сделали? зачем отпустили Израильтян, чтобы они не работали нам? ");
INSERT INTO russyn_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Фараон запряг колесницу свою и народ свой взял с собою; ");
INSERT INTO russyn_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","и взял шестьсот колесниц отборных и все колесницы Египетские, и начальников над всеми ими. ");
INSERT INTO russyn_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","И ожесточил Господь сердце фараона, царя Египетского и рабов его, и он погнался за сынами Израилевыми; сыны же Израилевы шли под рукою высокою. ");
INSERT INTO russyn_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","И погнались за ними Египтяне, и все кони с колесницами фараона, и всадники, и все войско его, и настигли их расположившихся у моря, при Пи-Гахирофе пред Ваал-Цефоном. ");
INSERT INTO russyn_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Фараон приблизился, и сыны Израилевы оглянулись, и вот, Египтяне идут за ними: и весьма устрашились и возопили сыны Израилевы к Господу, ");
INSERT INTO russyn_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","и сказали Моисею: разве нет гробов в Египте, что ты привел нас умирать в пустыне? что это ты сделал с нами, выведя нас из Египта? ");
INSERT INTO russyn_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Не это ли самое говорили мы тебе в Египте, сказав: оставь нас, пусть мы работаем Египтянам? Ибо лучше быть нам в рабстве у Египтян, нежели умереть в пустыне. ");
INSERT INTO russyn_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Но Моисей сказал народу: не бойтесь, стойте - и увидите спасение Господне, которое Он соделает вам ныне, ибо Египтян, которых видите вы ныне, более не увидите вовеки; ");
INSERT INTO russyn_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Господь будет поборать за вас, а вы будьте спокойны. ");
INSERT INTO russyn_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","И сказал Господь Моисею: что ты вопиешь ко Мне? скажи сынам Израилевым, чтоб они шли, ");
INSERT INTO russyn_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","а ты подними жезл твой и простри руку твою на море, и раздели его, и пройдут сыны Израилевы среди моря по суше; ");
INSERT INTO russyn_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Я же ожесточу сердце фараона и всех Египтян, и они пойдут вслед за ними; и покажу славу Мою на фараоне и на всем войске его, на колесницах его и на всадниках его; ");
INSERT INTO russyn_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","и узнают все Египтяне, что Я Господь, когда покажу славу Мою на фараоне, на колесницах его и на всадниках его. ");
INSERT INTO russyn_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","И двинулся Ангел Божий, шедший пред станом сынов Израилевых, и пошел позади их; двинулся и столп облачный от лица их и стал позади их; ");
INSERT INTO russyn_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","и вошел в средину между станом Египетским и между станом сынов Израилевых, и был облаком и мраком для одних и освещал ночь для других, и не сблизились одни с другими во всю ночь. ");
INSERT INTO russyn_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","И простер Моисей руку свою на море, и гнал Господь море сильным восточным ветром всю ночь и сделал море сушею, и расступились воды. ");
INSERT INTO russyn_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","И пошли сыны Израилевы среди моря по суше: воды же были им стеною по правую и по левую сторону. ");
INSERT INTO russyn_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Погнались Египтяне, и вошли за ними в средину моря все кони фараона, колесницы его и всадники его. ");
INSERT INTO russyn_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","И в утреннюю стражу воззрел Господь на стан Египтян из столпа огненного и облачного и привел в замешательство стан Египтян; ");
INSERT INTO russyn_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","и отнял колеса у колесниц их, так что они влекли их с трудом. И сказали Египтяне: побежим от Израильтян, потому что Господь поборает за них против Египтян. ");
INSERT INTO russyn_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","И сказал Господь Моисею: простри руку твою на море, и да обратятся воды на Египтян, на колесницы их и на всадников их. ");
INSERT INTO russyn_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","И простер Моисей руку свою на море, и к утру вода возвратилась в свое место; а Египтяне бежали навстречу воде. Так потопил Господь Египтян среди моря. ");
INSERT INTO russyn_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","И вода возвратилась и покрыла колесницы и всадников всего войска фараонова, вошедших за ними в море; не осталось ни одного из них. ");
INSERT INTO russyn_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","А сыны Израилевы прошли по суше среди моря: воды были им стеною по правую и стеною по левую сторону. ");
INSERT INTO russyn_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","И избавил Господь в день тот Израильтян из рук Египтян, и увидели сыны Израилевы Египтян мертвыми на берегу моря. ");
INSERT INTO russyn_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","И увидели Израильтяне руку великую, которую явил Господь над Египтянами, и убоялся народ Господа и поверил Господу и Моисею, рабу Его. Тогда Моисей и сыны Израилевы воспели Господу песнь сию и говорили: ");
INSERT INTO russyn_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Пою Господу, ибо Он высоко превознесся; коня и всадника его ввергнул в море. ");
INSERT INTO russyn_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Господь крепость моя и слава моя, Он был мне спасением. Он Бог мой, и прославлю Его; Бог отца моего, и превознесу Его. ");
INSERT INTO russyn_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Господь муж брани, Иегова имя Ему. ");
INSERT INTO russyn_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Колесницы фараона и войско его ввергнул Он в море, и избранные военачальники его потонули в Чермном море. ");
INSERT INTO russyn_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Пучины покрыли их: они пошли в глубину, как камень. ");
INSERT INTO russyn_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Десница Твоя, Господи, прославилась силою; десница Твоя, Господи, сразила врага. ");
INSERT INTO russyn_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Величием славы Твоей Ты низложил восставших против Тебя. Ты послал гнев Твой, и он попалил их, как солому. ");
INSERT INTO russyn_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","От дуновения Твоего расступились воды, влага стала, как стена, огустели пучины в сердце моря. ");
INSERT INTO russyn_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Враг сказал: погонюсь, настигну, разделю добычу; насытится ими душа моя, обнажу меч мой, истребит их рука моя. ");
INSERT INTO russyn_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Ты дунул духом Твоим, и покрыло их море: они погрузились, как свинец, в великих водах. ");
INSERT INTO russyn_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Кто, как Ты, Господи, между богами? Кто, как Ты, величествен святостью, досточтим хвалами, Творец чудес? ");
INSERT INTO russyn_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Ты простер десницу Твою: поглотила их земля. ");
INSERT INTO russyn_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Ты ведешь милостью Твоею народ сей, который Ты избавил, сопровождаешь силою Твоею в жилище святыни Твоей. ");
INSERT INTO russyn_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Услышали народы и трепещут: ужас объял жителей Филистимских; ");
INSERT INTO russyn_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","тогда смутились князья Едомовы, трепет объял вождей Моавитских, уныли все жители Ханаана. ");
INSERT INTO russyn_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Да нападет на них страх и ужас; от величия мышцы Твоей да онемеют они, как камень, доколе проходит народ Твой, Господи, доколе проходит сей народ, который Ты приобрел. ");
INSERT INTO russyn_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Введи его и насади его на горе достояния Твоего, на месте, которое Ты соделал жилищем Себе, Господи, во святилище, которое создали руки Твои, Владыка! ");
INSERT INTO russyn_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Господь будет царствовать вовеки и в вечность. ");
INSERT INTO russyn_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Когда вошли кони фараона с колесницами его и с всадниками его в море, то Господь обратил на них воды морские, а сыны Израилевы прошли по суше среди моря. ");
INSERT INTO russyn_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","И взяла Мариам пророчица, сестра Ааронова, в руку свою тимпан, и вышли за нею все женщины с тимпанами и ликованием. ");
INSERT INTO russyn_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","И воспела Мариам пред ними: пойте Господу, ибо высоко превознесся Он, коня и всадника его ввергнул в море. ");
INSERT INTO russyn_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","И повел Моисей Израильтян от Чермного моря, и они вступили в пустыню Сур; и шли они три дня по пустыне и не находили воды. ");
INSERT INTO russyn_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Пришли в Мерру - и не могли пить воды в Мерре, ибо она была горька, почему и наречено тому месту имя: Мерра. ");
INSERT INTO russyn_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","И возроптал народ на Моисея, говоря: что нам пить? ");
INSERT INTO russyn_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Моисей возопил к Господу, и Господь показал ему дерево, и он бросил его в воду, и вода сделалась сладкою. Там Бог дал народу устав и закон и там испытывал его. ");
INSERT INTO russyn_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","И сказал: если ты будешь слушаться гласа Господа, Бога твоего, и делать угодное пред очами Его, и внимать заповедям Его, и соблюдать все уставы Его, то не наведу на тебя ни одной из болезней, которые навел Я на Египет, ибо Я Господь Бог твой, целитель твой. ");
INSERT INTO russyn_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","И пришли в Елим; там было двенадцать источников воды и семьдесят финиковых дерев, и расположились там станом при водах. ");
INSERT INTO russyn_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","И двинулись из Елима, и пришло все общество сынов Израилевых в пустыню Син, что между Елимом и между Синаем, в пятнадцатый день второго месяца по выходе их из земли Египетской. ");
INSERT INTO russyn_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","И возроптало все общество сынов Израилевых на Моисея и Аарона в пустыне, ");
INSERT INTO russyn_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","и сказали им сыны Израилевы: о, если бы мы умерли от руки Господней в земле Египетской, когда мы сидели у котлов с мясом, когда мы ели хлеб досыта! ибо вывели вы нас в эту пустыню, чтобы все собрание это уморить голодом. ");
INSERT INTO russyn_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","И сказал Господь Моисею: вот, Я одождю вам хлеб с неба, и пусть народ выходит и собирает ежедневно, сколько нужно на день, чтобы Мне испытать его, будет ли он поступать по закону Моему, или нет; ");
INSERT INTO russyn_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","а в шестой день пусть заготовляют, что принесут, и будет вдвое против того, по сколько собирают в прочие дни. ");
INSERT INTO russyn_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","И сказали Моисей и Аарон всему обществу сынов Израилевых: вечером узнаете вы, что Господь вывел вас из земли Египетской, ");
INSERT INTO russyn_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","и утром увидите славу Господню, ибо услышал Он ропот ваш на Господа: а мы что такое, что ропщете на нас? ");
INSERT INTO russyn_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","И сказал Моисей: узнаете, когда Господь вечером даст вам мяса в пищу, а утром хлеба досыта, ибо Господь услышал ропот ваш, который вы подняли против Него: а мы что? не на нас ропот ваш, но на Господа. ");
INSERT INTO russyn_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","И сказал Моисей Аарону: скажи всему обществу сынов Израилевых: предстаньте пред лице Господа, ибо Он услышал ропот ваш. ");
INSERT INTO russyn_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","И когда говорил Аарон ко всему обществу сынов Израилевых, то они оглянулись к пустыне, и вот, слава Господня явилась в облаке. ");
INSERT INTO russyn_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","Я услышал ропот сынов Израилевых; скажи им: вечером будете есть мясо, а поутру насытитесь хлебом - и узнаете, что Я Господь, Бог ваш. ");
INSERT INTO russyn_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Вечером налетели перепелы и покрыли стан, а поутру лежала роса около стана; ");
INSERT INTO russyn_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","роса поднялась, и вот, на поверхности пустыни нечто мелкое, круповидное, мелкое, как иней на земле. ");
INSERT INTO russyn_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","И увидели сыны Израилевы и говорили друг другу: что это? Ибо не знали, что это. И Моисей сказал им: это хлеб, который Господь дал вам в пищу; ");
INSERT INTO russyn_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","вот что повелел Господь: собирайте его каждый по столько, сколько ему съесть; по гомору на человека, по числу душ, сколько у кого в шатре, собирайте. ");
INSERT INTO russyn_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","И сделали так сыны Израилевы и собрали, кто много, кто мало; ");
INSERT INTO russyn_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","и меряли гомором, и у того, кто собрал много, не было лишнего, и у того, кто мало, не было недостатка: каждый собрал, сколько ему съесть. ");
INSERT INTO russyn_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","И сказал им Моисей: никто не оставляй сего до утра. ");
INSERT INTO russyn_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Но не послушали они Моисея, и оставили от сего некоторые до утра, - и завелись черви, и оно воссмердело. И разгневался на них Моисей. ");
INSERT INTO russyn_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","И собирали его рано поутру, каждый сколько ему съесть; когда же обогревало солнце, оно таяло. ");
INSERT INTO russyn_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","В шестой же день собрали хлеба вдвое, по два гомора на каждого. И пришли все начальники общества и донесли Моисею. ");
INSERT INTO russyn_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","И Моисей сказал им: вот что сказал Господь: завтра покой, святая суббота Господня; что надобно печь, пеките, и что надобно варить, варите сегодня, а что останется, отложите и сберегите до утра. ");
INSERT INTO russyn_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","И отложили то до утра, как повелел им Моисей, и оно не воссмердело, и червей не было в нем. ");
INSERT INTO russyn_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","И сказал Моисей: ешьте его сегодня, ибо сегодня суббота Господня; сегодня не найдете его на поле; ");
INSERT INTO russyn_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","шесть дней собирайте его, а в седьмой день - суббота: не будет его в этот день. ");
INSERT INTO russyn_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Но некоторые из народа вышли в седьмой день собирать и не нашли. ");
INSERT INTO russyn_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","И сказал Господь Моисею: долго ли будете вы уклоняться от соблюдения заповедей Моих и законов Моих? ");
INSERT INTO russyn_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","смотрите, Господь дал вам субботу, посему Он и дает в шестой день хлеба на два дня: оставайтесь каждый у себя в доме своем, никто не выходи от места своего в седьмой день. ");
INSERT INTO russyn_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","И покоился народ в седьмой день. ");
INSERT INTO russyn_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","И нарек дом Израилев хлебу тому имя: манна; она была, как кориандровое семя, белая, вкусом же как лепешка с медом. ");
INSERT INTO russyn_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","И сказал Моисей: вот что повелел Господь: наполните манною гомор для хранения в роды ваши, дабы видели хлеб, которым Я питал вас в пустыне, когда вывел вас из земли Египетской. ");
INSERT INTO russyn_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","И сказал Моисей Аарону: возьми один сосуд золотой, и положи в него полный гомор манны, и поставь его пред Господом, для хранения в роды ваши. ");
INSERT INTO russyn_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","И поставил его Аарон пред ковчегом свидетельства для хранения, как повелел Господь Моисею. ");
INSERT INTO russyn_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Сыны Израилевы ели манну сорок лет, доколе не пришли в землю обитаемую; манну ели они, доколе не пришли к пределам земли Ханаанской. ");
INSERT INTO russyn_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","А гомор есть десятая часть ефы. ");
INSERT INTO russyn_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","И двинулось все общество сынов Израилевых из пустыни Син в путь свой, по повелению Господню, и расположилось станом в Рефидиме, и не было воды пить народу. ");
INSERT INTO russyn_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","И укорял народ Моисея, и говорили: дайте нам воды пить. И сказал им Моисей: что вы укоряете меня? что искушаете Господа? ");
INSERT INTO russyn_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","И жаждал там народ воды, и роптал народ на Моисея, говоря: зачем ты вывел нас из Египта, уморить жаждою нас и детей наших и стада наши? ");
INSERT INTO russyn_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Моисей возопил к Господу и сказал: что мне делать с народом сим? еще немного, и побьют меня камнями. ");
INSERT INTO russyn_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","И сказал Господь Моисею: пройди перед народом, и возьми с собою некоторых из старейшин Израильских, и жезл твой, которым ты ударил по воде, возьми в руку твою, и пойди; ");
INSERT INTO russyn_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","вот, Я стану пред тобою там на скале в Хориве, и ты ударишь в скалу, и пойдет из нее вода, и будет пить народ. И сделал так Моисей в глазах старейшин Израильских. ");
INSERT INTO russyn_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","И нарек месту тому имя: Масса и Мерива, по причине укорения сынов Израилевых и потому, что они искушали Господа, говоря: есть ли Господь среди нас, или нет? ");
INSERT INTO russyn_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","И пришли Амаликитяне и воевали с Израильтянами в Рефидиме. ");
INSERT INTO russyn_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Моисей сказал Иисусу: выбери нам мужей сильных и пойди, сразись с Амаликитянами; завтра я стану на вершине холма, и жезл Божий будет в руке моей. ");
INSERT INTO russyn_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","И сделал Иисус, как сказал ему Моисей, и пошел сразиться с Амаликитянами; а Моисей и Аарон и Ор взошли на вершину холма. ");
INSERT INTO russyn_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","И когда Моисей поднимал руки свои, одолевал Израиль, а когда опускал руки свои, одолевал Амалик; ");
INSERT INTO russyn_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","но руки Моисеевы отяжелели, и тогда взяли камень и подложили под него, и он сел на нем, Аарон же и Ор поддерживали руки его, один с одной, а другой с другой стороны. И были руки его подняты до захождения солнца. ");
INSERT INTO russyn_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","И низложил Иисус Амалика и народ его острием меча. ");
INSERT INTO russyn_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","И сказал Господь Моисею: напиши сие для памяти в книгу и внуши Иисусу, что Я совершенно изглажу память Амаликитян из поднебесной. ");
INSERT INTO russyn_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","И устроил Моисей жертвенник Господу и нарек ему имя: Иегова Нисси. ");
INSERT INTO russyn_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Ибо, сказал он, рука на престоле Господа: брань у Господа против Амалика из рода в род. ");
INSERT INTO russyn_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","И услышал Иофор, священник Мадиамский, тесть Моисеев, о всем, что сделал Бог для Моисея и для Израиля, народа Своего, когда вывел Господь Израиля из Египта, ");
INSERT INTO russyn_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","и взял Иофор, тесть Моисеев, Сепфору, жену Моисееву, пред тем возвращенную, ");
INSERT INTO russyn_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","и двух сынов ее, из которых одному имя Гирсам, потому что говорил Моисей: я пришлец в земле чужой; ");
INSERT INTO russyn_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","а другому имя Елиезер, потому что говорил он Бог отца моего был мне помощником и избавил меня от меча фараонова. ");
INSERT INTO russyn_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","И пришел Иофор, тесть Моисея, с сыновьями его и женою его к Моисею в пустыню, где он расположился станом у горы Божией, ");
INSERT INTO russyn_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","и дал знать Моисею: я, тесть твой Иофор, иду к тебе, и жена твоя, и два сына ее с нею. ");
INSERT INTO russyn_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Моисей вышел навстречу тестю своему, и поклонился ему, и целовал его, и после взаимного приветствия они вошли в шатер. ");
INSERT INTO russyn_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","И рассказал Моисей тестю своему о всем, что сделал Господь с фараоном и со всеми Египтянами за Израиля, и о всех трудностях, какие встретили их на пути, и как избавил их Господь из руки фараона и из руки Египтян. ");
INSERT INTO russyn_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Иофор радовался о всех благодеяниях, которые Господь явил Израилю, когда избавил его из руки Египтян и из руки фараона, ");
INSERT INTO russyn_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","и сказал Иофор: благословен Господь, Который избавил вас из руки Египтян и из руки фараоновой, Который избавил народ сей из-под власти Египтян; ");
INSERT INTO russyn_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","ныне узнал я, что Господь велик паче всех богов, в том самом, чем они превозносились над Израильтянами. ");
INSERT INTO russyn_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","И принес Иофор, тесть Моисеев, всесожжение и жертвы Богу; и пришел Аарон и все старейшины Израилевы есть хлеба с тестем Моисеевым пред Богом. ");
INSERT INTO russyn_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","На другой день сел Моисей судить народ, и стоял народ пред Моисеем с утра до вечера. ");
INSERT INTO russyn_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","И видел Иофор, тесть Моисеев, все, что он делает с народом, и сказал: что это такое делаешь ты с народом? для чего ты сидишь один, а весь народ стоит пред тобою с утра до вечера? ");
INSERT INTO russyn_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","И сказал Моисей тестю своему: народ приходит ко мне просить суда у Бога; ");
INSERT INTO russyn_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","когда случается у них какое дело, они приходят ко мне, и я сужу между тем и другим и объявляю им уставы Божии и законы Его. ");
INSERT INTO russyn_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Но тесть Моисеев сказал ему: не хорошо это ты делаешь: ");
INSERT INTO russyn_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","ты измучишь и себя и народ сей, который с тобою, ибо слишком тяжело для тебя это дело: ты один не можешь исправлять его; ");
INSERT INTO russyn_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","итак послушай слов моих; я дам тебе совет, и будет Бог с тобою: будь ты для народа посредником пред Богом и представляй Богу дела его; ");
INSERT INTO russyn_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","научай их уставам Божиим и законам Его, указывай им путь Его, по которому они должны идти, и дела, которые они должны делать; ");
INSERT INTO russyn_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","ты же усмотри себе из всего народа людей способных, боящихся Бога, людей правдивых, ненавидящих корысть, и поставь их над ним тысяченачальниками, стоначальниками, пятидесятиначальниками и десятиначальниками и письмоводителями; ");
INSERT INTO russyn_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","пусть они судят народ во всякое время и о всяком важном деле доносят тебе, а все малые дела судят сами: и будет тебе легче, и они понесут с тобою бремя; ");
INSERT INTO russyn_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","если ты сделаешь это, и Бог повелит тебе, то ты можешь устоять, и весь народ сей будет отходить в свое место с миром. ");
INSERT INTO russyn_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","И послушал Моисей слов тестя своего и сделал все, что он говорил ему; ");
INSERT INTO russyn_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","и выбрал Моисей из всего Израиля способных людей и поставил их начальниками народа, тысяченачальниками, стоначальниками, пятидесятиначальниками и десяти-начальниками и письмоводителями, ");
INSERT INTO russyn_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","и судили они народ во всякое время; о всех делах важных доносили Моисею, а все малые дела судили сами. ");
INSERT INTO russyn_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","И отпустил Моисей тестя своего, и он пошел в землю свою. ");
INSERT INTO russyn_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","В третий месяц по исходе сынов Израиля из земли Египетской, в самый день новолуния, пришли они в пустыню Синайскую. ");
INSERT INTO russyn_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","И двинулись они из Рефидима, и пришли в пустыню Синайскую, и расположились там станом в пустыне; и расположился там Израиль станом против горы. ");
INSERT INTO russyn_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Моисей взошел к Богу на гору, и воззвал к нему Господь с горы, говоря: так скажи дому Иаковлеву и возвести сынам Израилевым: ");
INSERT INTO russyn_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","вы видели, что Я сделал Египтянам, и как Я носил вас как бы на орлиных крыльях, и принес вас к Себе; ");
INSERT INTO russyn_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","итак, если вы будете слушаться гласа Моего и соблюдать завет Мой, то будете Моим уделом из всех народов, ибо Моя вся земля, ");
INSERT INTO russyn_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","а вы будете у Меня царством священников и народом святым; вот слова, которые ты скажешь сынам Израилевым. ");
INSERT INTO russyn_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","И пришел Моисей и созвал старейшин народа и предложил им все сии слова, которые заповедал ему Господь. ");
INSERT INTO russyn_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","И весь народ отвечал единогласно, говоря: все, что сказал Господь, исполним и будем послушны. И донес Моисей слова народа Господу. ");
INSERT INTO russyn_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","И сказал Господь Моисею: вот, Я приду к тебе в густом облаке, дабы слышал народ, как Я буду говорить с тобою, и поверил тебе навсегда. И Моисей объявил слова народа Господу. ");
INSERT INTO russyn_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","И сказал Господь Моисею: пойди к народу, объяви и освяти его сегодня и завтра; пусть вымоют одежды свои, ");
INSERT INTO russyn_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","чтоб быть готовыми к третьему дню: ибо в третий день сойдет Господь пред глазами всего народа на гору Синай; ");
INSERT INTO russyn_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","и проведи для народа черту со всех сторон и скажи: берегитесь восходить на гору и прикасаться к подошве ее; всякий, кто прикоснется к горе, предан будет смерти; ");
INSERT INTO russyn_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","рука да не прикоснется к нему, а пусть побьют его камнями, или застрелят стрелою; скот ли то, или человек, да не останется в живых; во время протяжного трубного звука, когда облако отойдет от горы, могут они взойти на гору ");
INSERT INTO russyn_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","И сошел Моисей с горы к народу и освятил народ, и они вымыли одежду свою. ");
INSERT INTO russyn_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","И сказал народу: будьте готовы к третьему дню; не прикасайтесь к женам. ");
INSERT INTO russyn_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","На третий день, при наступлении утра, были громы и молнии, и густое облако над горою Синайскою, и трубный звук весьма сильный; и вострепетал весь народ, бывший в стане. ");
INSERT INTO russyn_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","И вывел Моисей народ из стана в сретение Богу, и стали у подошвы горы. ");
INSERT INTO russyn_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Гора же Синай вся дымилась оттого, что Господь сошел на нее в огне; и восходил от нее дым, как дым из печи, и вся гора сильно колебалась; ");
INSERT INTO russyn_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","и звук трубный становился сильнее и сильнее. Моисей говорил, и Бог отвечал ему голосом. ");
INSERT INTO russyn_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","И сошел Господь на гору Синай, на вершину горы, и призвал Господь Моисея на вершину горы, и взошел Моисей. ");
INSERT INTO russyn_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","И сказал Господь Моисею: сойди и подтверди народу, чтобы он не порывался к Господу видеть Его, и чтобы не пали многие из него; ");
INSERT INTO russyn_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","священники же, приближающиеся к Господу Богу, должны освятить себя, чтобы не поразил их Господь. ");
INSERT INTO russyn_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","И сказал Моисей Господу: не может народ взойти на гору Синай, потому что Ты предостерег нас, сказав: проведи черту вокруг горы и освяти ее. ");
INSERT INTO russyn_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","И Господь сказал ему: пойди, сойди, потом взойди ты и с тобою Аарон; а священники и народ да не порываются восходить к Господу, чтобы Господь не поразил их. ");
INSERT INTO russyn_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","И сошел Моисей к народу и пересказал ему. ");
INSERT INTO russyn_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","И изрек Бог к Моисею все слова сии, говоря: ");
INSERT INTO russyn_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Я Господь, Бог твой, Который вывел тебя из земли Египетской, из дома рабства; ");
INSERT INTO russyn_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","да не будет у тебя других богов пред лицем Моим. ");
INSERT INTO russyn_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Не делай себе кумира и никакого изображения того, что на небе вверху, и что на земле внизу, и что в воде ниже земли; ");
INSERT INTO russyn_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","не поклоняйся им и не служи им, ибо Я Господь, Бог твой, Бог ревнитель, наказывающий детей за вину отцов до третьего и четвертого рода, ненавидящих Меня,” ");
INSERT INTO russyn_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","и творящий милость до тысячи родов любящим Меня и соблюдающим заповеди Мои. ");
INSERT INTO russyn_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Не произноси имени Господа, Бога твоего, напрасно, ибо Господь не оставит без наказания того, кто произносит имя Его напрасно. ");
INSERT INTO russyn_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Помни день субботний, чтобы святить его; ");
INSERT INTO russyn_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","шесть дней работай и делай в них всякие дела твои, ");
INSERT INTO russyn_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","а день седьмой - суббота Господу, Богу твоему: не делай в оный никакого дела ни ты, ни сын твой, ни дочь твоя, ни раб твой, ни рабыня твоя, ни вол твой, ни осел твой, ни всякий скот твой, ни пришлец, который в жилищах твоих; ");
INSERT INTO russyn_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","ибо в шесть дней создал Господь небо и землю, море и все, что в них, а в день седьмой почил; посему благословил Господь день субботний и освятил его. ");
INSERT INTO russyn_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Почитай отца твоего и мать твою, чтобы тебе было хорошо и чтобы продлились дни твои на земле, которую Господь, Бог твой, дает тебе. ");
INSERT INTO russyn_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Не убивай. ");
INSERT INTO russyn_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Не прелюбодействуй. ");
INSERT INTO russyn_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Не кради. ");
INSERT INTO russyn_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Не произноси ложного свидетельства на ближнего твоего. ");
INSERT INTO russyn_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Не желай дома ближнего твоего; не желай жены ближнего твоего, ни поля его, ни раба его, ни рабыни его, ни вола его, ни осла его, ни всякого скота его, ничего, что у ближнего твоего. ");
INSERT INTO russyn_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Весь народ видел громы и пламя, и звук трубный, и гору дымящуюся; и увидев то, весь народ отступил и стал вдали. ");
INSERT INTO russyn_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","И сказали Моисею: говори ты с нами, и мы будем слушать, но чтобы не говорил с нами Бог, дабы нам не умереть. ");
INSERT INTO russyn_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","И сказал Моисей народу: не бойтесь; Бог к вам пришел, чтобы испытать вас и чтобы страх Его был пред лицем вашим, дабы вы не грешили. ");
INSERT INTO russyn_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","И стоял весь народ вдали, а Моисей вступил во мрак, где Бог. ");
INSERT INTO russyn_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","И сказал Господь Моисею: так скажи дому Иаковлеву и возвести сынам Израилевым: вы видели, как Я с неба говорил вам; ");
INSERT INTO russyn_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","не делайте предо Мною богов серебряных, или богов золотых, не делайте себе: ");
INSERT INTO russyn_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","сделай Мне жертвенник из земли и приноси на нем всесожжения твои и мирные жертвы твои, овец твоих и волов твоих; на всяком месте, где Я положу память имени Моего, Я приду к тебе и благословлю тебя; ");
INSERT INTO russyn_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","если же будешь делать Мне жертвенник из камней, то не сооружай его из тесаных, ибо, как скоро наложишь на них тесло твое, то осквернишь их; ");
INSERT INTO russyn_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","и не всходи по ступеням к жертвеннику Моему, дабы не открылась при нем нагота твоя. ");
INSERT INTO russyn_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","И вот законы, которые ты объявишь им: ");
INSERT INTO russyn_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","если купишь раба Еврея, пусть он работает тебе шесть лет, а в седьмой год пусть выйдет на волю даром; ");
INSERT INTO russyn_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","если он пришел один, пусть один и выйдет; а если он женатый, пусть выйдет с ним и жена его; ");
INSERT INTO russyn_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","если же господин его дал ему жену и она родила ему сынов, или дочерей, то жена и дети ее пусть останутся у господина ее, а он выйдет один; ");
INSERT INTO russyn_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","но если раб скажет: люблю господина моего, жену мою и детей моих, не пойду на волю, ");
INSERT INTO russyn_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","то пусть господин его приведет его пред богов и поставит его к двери, или к косяку, и проколет ему господин его ухо шилом, и он останется рабом его вечно. ");
INSERT INTO russyn_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Если кто продаст дочь свою в рабыни, то она не может выйти, как выходят рабы; ");
INSERT INTO russyn_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","если она не угодна господину своему и он не обручит ее, пусть позволит выкупить ее; а чужому народу продать ее господин не властен, когда сам пренебрег ее; ");
INSERT INTO russyn_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","если он обручит ее сыну своему, пусть поступит с нею по праву дочерей; ");
INSERT INTO russyn_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","если же другую возьмет за него, то она не должна лишаться пищи, одежды и супружеского сожития; ");
INSERT INTO russyn_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","а если он сих трех вещей не сделает для нее, пусть она отойдет даром, без выкупа. ");
INSERT INTO russyn_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Кто ударит человека так, что он умрет, да будет предан смерти; ");
INSERT INTO russyn_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","но если кто не злоумышлял, а Бог попустил ему попасть под руки его, то Я назначу у тебя место, куда убежать убийце; ");
INSERT INTO russyn_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","а если кто с намерением умертвит ближнего коварно и прибежит к жертвеннику, то и от жертвенника Моего бери его на смерть. ");
INSERT INTO russyn_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Кто ударит отца своего, или свою мать, того должно предать смерти. ");
INSERT INTO russyn_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Кто украдет человека из сынов Израилевых и поработив его продаст его, или найдется он в руках у него, то должно предать его смерти. ");
INSERT INTO russyn_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Кто злословит отца своего, или свою мать, того должно предать смерти. ");
INSERT INTO russyn_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Когда ссорятся двое, и один человек ударит другого камнем, или кулаком, и тот не умрет, но сляжет в постель, ");
INSERT INTO russyn_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","то, если он встанет и будет выходить из дома с помощью палки, ударивший его не будет повинен смерти; только пусть заплатит за остановку в его работе и даст на лечение его. ");
INSERT INTO russyn_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","А если кто ударит раба своего, или служанку свою палкою, и они умрут под рукою его, то он должен быть наказан; ");
INSERT INTO russyn_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","но если они день или два дня переживут, то не должно наказывать его, ибо это его серебро. ");
INSERT INTO russyn_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Когда дерутся люди, и ударят беременную женщину, и она выкинет, но не будет другого вреда, то взять с виновного пеню, какую наложит на него муж той женщины, и он должен заплатить оную при посредниках; ");
INSERT INTO russyn_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","а если будет вред, то отдай душу за душу, ");
INSERT INTO russyn_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","глаз за глаз, зуб за зуб, руку за руку, ногу за ногу, ");
INSERT INTO russyn_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","обожжение за обожжение, рану за рану, ушиб за ушиб. ");
INSERT INTO russyn_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Если кто раба своего ударит в глаз, или служанку свою в глаз, и повредит его, пусть отпустит их на волю за глаз; ");
INSERT INTO russyn_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","и если выбьет зуб рабу своему, или рабе своей, пусть отпустит их на волю за зуб. ");
INSERT INTO russyn_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Если вол забодает мужчину или женщину до смерти, то вола побить камнями и мяса его не есть; а хозяин вола не виноват; ");
INSERT INTO russyn_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","но если вол бодлив был и вчера и третьего дня, и хозяин его, быв извещен о сем, не стерег его, а он убил мужчину или женщину, то вола побить камнями, и хозяина его предать смерти; ");
INSERT INTO russyn_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","если на него наложен будет выкуп, пусть даст выкуп за душу свою, какой наложен будет на него. ");
INSERT INTO russyn_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Сына ли забодает, дочь ли забодает, - по сему же закону поступать с ним. ");
INSERT INTO russyn_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Если вол забодает раба или рабу, то господину их заплатить тридцать сиклей серебра, а вола побить камнями. ");
INSERT INTO russyn_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Если кто раскроет яму, или если выкопает яму и не покроет ее, и упадет в нее вол или осел, ");
INSERT INTO russyn_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","то хозяин ямы должен заплатить, отдать серебро хозяину их, а труп будет его. ");
INSERT INTO russyn_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Если чей-нибудь вол забодает до смерти вола у соседа его, пусть продадут живого вола и разделят пополам цену его; также и убитого пусть разделят пополам; ");
INSERT INTO russyn_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","а если известно было, что вол бодлив был и вчера и третьего дня, но хозяин его быв извещен о сем не стерег его, то должен он заплатить вола за вола, а убитый будет его. ");
INSERT INTO russyn_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Если кто украдет вола или овцу и заколет или продаст, то пять волов заплатит за вола и четыре овцы за овцу. ");
INSERT INTO russyn_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Если кто застанет вора подкапывающего и ударит его, так что он умрет, то кровь не вменится ему; ");
INSERT INTO russyn_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","но если взошло над ним солнце, то вменится ему кровь. Укравший должен заплатить; а если нечем, то пусть продадут его для уплаты за украденное им; ");
INSERT INTO russyn_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","если он пойман будет и украденное найдется у него в руках живым, вол ли то, или осел, или овца, пусть заплатит за них вдвое. ");
INSERT INTO russyn_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Если кто потравит поле, или виноградник, пустив скот свой травить чужое поле, смотря по плодам его пусть заплатит со своего поля; а если потравит все поле, пусть вознаградит лучшим из поля своего и лучшим из виноградника своего. ");
INSERT INTO russyn_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Если появится огонь и охватит терн и выжжет копны, или жатву, или поле, то должен заплатить, кто произвел сей пожар. ");
INSERT INTO russyn_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Если кто отдаст ближнему на сохранение серебро или вещи, и они украдены будут из дома его, то, если найдется вор, пусть он заплатит вдвое; ");
INSERT INTO russyn_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","а если не найдется вор, пусть хозяин дома придет пред судей и поклянется, что не простер руки своей на собственность ближнего своего. ");
INSERT INTO russyn_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","О всякой вещи спорной, о воле, об осле, об овце, об одежде, о всякой вещи потерянной, о которой кто-нибудь скажет, что она его, дело обоих должно быть доведено до судей: кого обвинят судьи, тот заплатит ближнему своему вдвое. ");
INSERT INTO russyn_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Если кто отдаст ближнему своему осла, или вола, или овцу, или какой другой скот на сбережение, а он умрет, или будет поврежден, или уведен, так что никто сего не увидит, ");
INSERT INTO russyn_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","клятва пред Господом да будет между обоими в том, что взявший не простер руки своей на собственность ближнего своего; и хозяин должен принять, а тот не будет платить; ");
INSERT INTO russyn_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","а если украден будет у него, то должен заплатить хозяину его; ");
INSERT INTO russyn_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","если же будет зверем растерзан, то пусть в доказательство представит растерзанное: за растерзанное он не платит. ");
INSERT INTO russyn_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Если кто займет у ближнего своего скот, и он будет поврежден, или умрет, а хозяина его не было при нем, то должен заплатить; ");
INSERT INTO russyn_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","если же хозяин его был при нем, то не должен платить; если он взят был внаймы за деньги, то пусть и пойдет за ту цену. ");
INSERT INTO russyn_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Если обольстит кто девицу необрученную и переспит с нею, пусть даст ей вено и возьмет ее себе в жену; ");
INSERT INTO russyn_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","а если отец не согласится и не захочет выдать ее за него, пусть заплатит отцу столько серебра, сколько полагается на вено девицам. ");
INSERT INTO russyn_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Ворожеи не оставляй в живых. ");
INSERT INTO russyn_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Всякий скотоложник да будет предан смерти. ");
INSERT INTO russyn_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Приносящий жертву богам, кроме одного Господа, да будет истреблен. ");
INSERT INTO russyn_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Пришельца не притесняй и не угнетай его, ибо вы сами были пришельцами в земле Египетской. ");
INSERT INTO russyn_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Ни вдовы, ни сироты не притесняйте; ");
INSERT INTO russyn_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","если же ты притеснишь их, то, когда они возопиют ко Мне, Я услышу вопль их, ");
INSERT INTO russyn_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","и воспламенится гнев Мой, и убью вас мечом, и будут жены ваши вдовами и дети ваши сиротами. ");
INSERT INTO russyn_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Если дашь деньги взаймы бедному из народа Моего, то не притесняй его и не налагай на него роста. ");
INSERT INTO russyn_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Если возьмешь в залог одежду ближнего твоего, до захождения солнца возврати ее, ");
INSERT INTO russyn_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","ибо она есть единственный покров у него, она - одеяние тела его: в чем будет он спать? итак, когда он возопиет ко Мне, Я услышу, ибо Я милосерд. ");
INSERT INTO russyn_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Судей не злословь и начальника в народе твоем не поноси. ");
INSERT INTO russyn_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Не медли приносить Мне начатки от гумна твоего и от точила твоего; отдавай Мне первенца из сынов твоих; ");
INSERT INTO russyn_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","то же делай с волом твоим и с овцою твоею и с ослом твоим: семь дней пусть они будут при матери своей, а в восьмой день отдавай их Мне. ");
INSERT INTO russyn_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","И будете у Меня людьми святыми; и мяса, растерзанного зверем в поле, не ешьте, псам бросайте его. ");
INSERT INTO russyn_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Не внимай пустому слуху, не давай руки твоей нечестивому, чтоб быть свидетелем неправды. ");
INSERT INTO russyn_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Не следуй за большинством на зло, и не решай тяжбы, отступая по большинству от правды; ");
INSERT INTO russyn_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","и бедному не потворствуй в тяжбе его. ");
INSERT INTO russyn_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Если найдешь вола врага твоего, или осла его заблудившегося, приведи его к нему; ");
INSERT INTO russyn_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","если увидишь осла врага твоего упавшим под ношею своею, то не оставляй его; развьючь вместе с ним. ");
INSERT INTO russyn_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Не суди превратно тяжбы бедного твоего. ");
INSERT INTO russyn_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Удаляйся от неправды и не умерщвляй невинного и правого, ибо Я не оправдаю беззаконника. ");
INSERT INTO russyn_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Даров не принимай, ибо дары слепыми делают зрячих и превращают дело правых. ");
INSERT INTO russyn_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Пришельца не обижай и не притесняй его: вы знаете душу пришельца, потому что сами были пришельцами в земле Египетской. ");
INSERT INTO russyn_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Шесть лет засевай землю твою и собирай произведения ее, ");
INSERT INTO russyn_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","а в седьмой оставляй ее в покое, чтобы питались убогие из твоего народа, а остатками после них питались звери полевые; так же поступай с виноградником твоим и с маслиною твоею. ");
INSERT INTO russyn_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Шесть дней делай дела твои, а в седьмой день покойся, чтобы отдохнул вол твой и осел твой и успокоился сын рабы твоей и пришлец. ");
INSERT INTO russyn_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Соблюдайте все, что Я сказал вам, и имени других богов не упоминайте; да не слышится оно из уст твоих. ");
INSERT INTO russyn_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Три раза в году празднуй Мне: ");
INSERT INTO russyn_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","наблюдай праздник опресноков: семь дней ешь пресный хлеб, как Я повелел тебе, в назначенное время месяца Авива, ибо в оном ты вышел из Египта; и пусть не являются пред лице Мое с пустыми руками; ");
INSERT INTO russyn_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","наблюдай и праздник жатвы первых плодов труда твоего, какие ты сеял на поле, и праздник собирания плодов в конце года, когда уберешь с поля работу твою. ");
INSERT INTO russyn_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Три раза в году должен являться весь мужеский пол твой пред лице Владыки, Господа твоего. ");
INSERT INTO russyn_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Когда изгоню язычников от лица твоего и распространю пределы твои, не изливай крови жертвы Моей на квасное, и тук от праздничной жертвы Моей не должен оставаться до утра. ");
INSERT INTO russyn_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Начатки плодов земли твоей приноси в дом Господа, Бога твоего. Не вари козленка в молоке матери его. ");
INSERT INTO russyn_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Вот, Я посылаю пред тобою Ангела Моего хранить тебя на пути и ввести тебя в то место, которое Я приготовил тебе; ");
INSERT INTO russyn_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","блюди себя пред лицем Его и слушай гласа Его; не упорствуй против Него, потому что Он не простит греха вашего, ибо имя Мое в Нем. ");
INSERT INTO russyn_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Если будешь слушать гласа Моего, и будешь исполнять все, что скажу тебе, и сохранишь завет Мой, то вы будете у Меня народом избранным из всех племен, ибо вся земля Моя; вы будете у Меня царственным священством и народом святым. Сии слова скажи сынам Израилевым. Если ты будешь слушать гласа Его и исполнять все, что скажу тебе, то врагом буду врагов твоих и противником противников твоих. ");
INSERT INTO russyn_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Когда пойдет пред тобою Ангел Мой и поведет тебя к Аморреям, Хеттеям, Ферезеям, Хананеям, Гергесеям, Евеям и Иевусеям, и истреблю их от лица вашего, ");
INSERT INTO russyn_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","то не поклоняйся богам их, и не служи им, и не подражай делам их, но сокруши их и разрушь столбы их: ");
INSERT INTO russyn_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","служите Господу, Богу вашему, и Он благословит хлеб твой и вино твое и воду твою; и отвращу от вас болезни. ");
INSERT INTO russyn_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Не будет преждевременно рождающих и бесплодных в земле твоей; число дней твоих сделаю полным. ");
INSERT INTO russyn_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Ужас Мой пошлю пред тобою, и в смущение приведу всякий народ, к которому ты придешь, и буду обращать к тебе тыл всех врагов твоих; ");
INSERT INTO russyn_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","пошлю пред тобою шершней, и они погонят от лица твоего Аморреев, Евеев, Иевусеев, Хананеев и Хеттеев; ");
INSERT INTO russyn_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","не выгоню их от лица твоего в один год, чтобы земля не сделалась пуста и не умножились против тебя звери полевые: ");
INSERT INTO russyn_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","мало-помалу буду прогонять их от тебя, доколе ты не размножишься и не возьмешь во владение земли сей. ");
INSERT INTO russyn_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Проведу пределы твои от моря Чермного до моря Филистимского и от пустыни до реки великой Евфрата, ибо предам в руки ваши жителей сей земли, и прогонишь их от лица твоего; ");
INSERT INTO russyn_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","не смешивайся и не заключай союза ни с ними, ни с богами их; ");
INSERT INTO russyn_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","не должны они жить в земле твоей, чтобы они не ввели тебя в грех против Меня; ибо если ты будешь служить богам их, то это будет тебе сетью. ");
INSERT INTO russyn_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","И Моисею сказал Он: взойди к Господу ты и Аарон, Надав и Авиуд и семьдесят из старейшин Израилевых, и поклонитесь Господу издали; ");
INSERT INTO russyn_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Моисей один пусть приблизится к Господу, а они пусть не приближаются, и народ пусть не восходит с ним. ");
INSERT INTO russyn_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","И пришел Моисей и пересказал народу все слова Господни и все законы. И отвечал весь народ в один голос, и сказали: все, что сказал Господь, сделаем и будем послушны. ");
INSERT INTO russyn_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","И написал Моисей все слова Господни и, встав рано поутру, поставил под горою жертвенник и двенадцать камней, по числу двенадцати колен Израилевых; ");
INSERT INTO russyn_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","и послал юношей из сынов Израилевых, и принесли они всесожжения, и заклали тельцов в мирную жертву Господу Богу. ");
INSERT INTO russyn_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Моисей, взяв половину крови, влил в чаши, а другою половиною окропил жертвенник; ");
INSERT INTO russyn_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","и взял книгу завета и прочитал вслух народу, и сказали они: все, что сказал Господь, сделаем и будем послушны. ");
INSERT INTO russyn_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","И взял Моисей крови и окропил народ, говоря: вот кровь завета, который Господь заключил с вами о всех словах сих. ");
INSERT INTO russyn_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Потом взошел Моисей и Аарон, Надав и Авиуд и семьдесят из старейшин Израилевых, ");
INSERT INTO russyn_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","и видели место стояния Бога Израилева; и под ногами Его нечто подобное работе из чистого сапфира и, как самое небо, ясное. ");
INSERT INTO russyn_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","И Он не простер руки Своей на избранных из сынов Израилевых: они видели место Бога, и ели и пили. ");
INSERT INTO russyn_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","И сказал Господь Моисею: взойди ко Мне на гору и будь там; и дам тебе скрижали каменные, и закон и заповеди, которые Я написал для научения их. ");
INSERT INTO russyn_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","И встал Моисей с Иисусом, служителем своим, и пошел Моисей на гору Божию, ");
INSERT INTO russyn_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","а старейшинам сказал: оставайтесь здесь, доколе мы не возвратимся к вам; вот Аарон и Ор с вами; кто будет иметь дело, пусть приходит к ним. ");
INSERT INTO russyn_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","И взошел Моисей на гору, и покрыло облако гору, ");
INSERT INTO russyn_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","и слава Господня осенила гору Синай; и покрывало ее облако шесть дней, а в седьмой день Господь воззвал к Моисею из среды облака. ");
INSERT INTO russyn_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Вид же славы Господней на вершине горы был пред глазами сынов Израилевых, как огонь поядающий. ");
INSERT INTO russyn_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Моисей вступил в средину облака и взошел на гору; и был Моисей на горе сорок дней и сорок ночей. ");
INSERT INTO russyn_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","скажи сынам Израилевым, чтобы они сделали Мне приношения; от всякого человека, у которого будет усердие, принимайте приношения Мне. ");
INSERT INTO russyn_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Вот приношения, которые вы должны принимать от них: золото и серебро и медь, ");
INSERT INTO russyn_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","и шерсть голубую, пурпуровую и червленую, и виссон, и козью шерсть, ");
INSERT INTO russyn_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","и кожи бараньи красные, и кожи синие, и дерева ситтим, ");
INSERT INTO russyn_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","елей для светильника, ароматы для елея помазания и для благовонного курения, ");
INSERT INTO russyn_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","камень оникс и камни вставные для ефода и для наперсника. ");
INSERT INTO russyn_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","И устроят они Мне святилище, и буду обитать посреди их; ");
INSERT INTO russyn_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","все сделайте, как Я показываю тебе, и образец скинии и образец всех сосудов ее; так и сделайте. ");
INSERT INTO russyn_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Сделайте ковчег из дерева ситтим: длина ему два локтя с половиною, и ширина ему полтора локтя, и высота ему полтора локтя; ");
INSERT INTO russyn_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","и обложи его чистым золотом, изнутри и снаружи покрой его; и сделай наверху вокруг его золотой венец витый; ");
INSERT INTO russyn_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","и вылей для него четыре кольца золотых и утверди на четырех нижних углах его: два кольца на одной стороне его, два кольца на другой стороне его. ");
INSERT INTO russyn_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Сделай из дерева ситтим шесты и обложи их чистым золотом; ");
INSERT INTO russyn_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","и вложи шесты в кольца, по сторонам ковчега, чтобы посредством их носить ковчег; ");
INSERT INTO russyn_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","в кольцах ковчега должны быть шесты и не должны отниматься от него. ");
INSERT INTO russyn_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","И положи в ковчег откровение, которое Я дам тебе. ");
INSERT INTO russyn_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Сделай также крышку из чистого золота: длина ее два локтя с половиною, а ширина ее полтора локтя; ");
INSERT INTO russyn_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","и сделай из золота двух херувимов: чеканной работы сделай их на обоих концах крышки; ");
INSERT INTO russyn_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","сделай одного херувима с одного края, а другого херувима с другого края; выдавшимися из крышки сделайте херувимов на обоих краях ее; ");
INSERT INTO russyn_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","и будут херувимы с распростертыми вверх крыльями, покрывая крыльями своими крышку, а лицами своими будут друг к другу: к крышке будут лица херувимов. ");
INSERT INTO russyn_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","И положи крышку на ковчег сверху, в ковчег же положи откровение, которое Я дам тебе; ");
INSERT INTO russyn_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","там Я буду открываться тебе и говорить с тобою над крышкою, посреди двух херувимов, которые над ковчегом откровения, о всем, что ни буду заповедовать чрез тебя сынам Израилевым. ");
INSERT INTO russyn_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","И сделай стол из дерева ситтим, длиною в два локтя, шириною в локоть, и вышиною в полтора локтя, ");
INSERT INTO russyn_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","и обложи его золотом чистым, и сделай вокруг него золотой венец витый; ");
INSERT INTO russyn_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","и сделай вокруг него стенки в ладонь и у стенок его сделай золотой венец вокруг; ");
INSERT INTO russyn_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","и сделай для него четыре кольца золотых и утверди кольца на четырех углах у четырех ножек его; ");
INSERT INTO russyn_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","при стенках должны быть кольца, чтобы влагать шесты, для ношения на них стола; ");
INSERT INTO russyn_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","а шесты сделай из дерева ситтим и обложи их чистым золотом, и будут носить на них сей стол; ");
INSERT INTO russyn_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","сделай также для него блюдо, кадильницы, чаши и кружки, чтобы возливать ими: из золота чистого сделай их; ");
INSERT INTO russyn_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","и полагай на стол хлебы предложения пред лицем Моим постоянно. ");
INSERT INTO russyn_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","И сделай светильник из золота чистого; чеканный должен быть сей светильник; стебель его, ветви его, чашечки его, яблоки его и цветы его должны выходить из него; ");
INSERT INTO russyn_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","шесть ветвей должны выходить из боков его: три ветви светильника из одного бока его и три ветви светильника из другого бока его; ");
INSERT INTO russyn_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","три чашечки наподобие миндального цветка, с яблоком и цветами, должны быть на одной ветви, и три чашечки наподобие миндального цветка на другой ветви, с яблоком и цветами: так на всех шести ветвях, выходящих из светильника; ");
INSERT INTO russyn_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","а на стебле светильника должны быть четыре чашечки наподобие миндального цветка с яблоками и цветами; ");
INSERT INTO russyn_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","у шести ветвей, выходящих из стебля светильника, яблоко под двумя ветвями его, и яблоко под другими двумя ветвями, и яблоко под третьими двумя ветвями его и на светильнике четыре чашечки, наподобие миндального цветка; ");
INSERT INTO russyn_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","яблоки и ветви их из него должны выходить: он весь должен быть чеканный, цельный, из чистого золота. ");
INSERT INTO russyn_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","И сделай к нему семь лампад и поставь на него лампады его, чтобы светили на переднюю сторону его; ");
INSERT INTO russyn_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","и щипцы к нему и лотки к нему сделай из чистого золота; ");
INSERT INTO russyn_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","из таланта золота чистого пусть сделают его со всеми сими принадлежностями. ");
INSERT INTO russyn_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Смотри, сделай их по тому образцу, какой показан тебе на горе. ");
INSERT INTO russyn_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Скинию же сделай из десяти покрывал крученого виссона и из голубой, пурпуровой и червленой шерсти, и херувимов сделай на них искусною работою; ");
INSERT INTO russyn_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","длина каждого покрывала двадцать восемь локтей, а ширина каждого покрывала четыре локтя: мера одна всем покрывалам. ");
INSERT INTO russyn_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Пять покрывал пусть будут соединены одно с другим, и другие пять покрывал соединены одно с другим. ");
INSERT INTO russyn_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Сделай к ним петли голубого цвета на краю первого покрывала, в конце соединяющего обе половины; так сделай и на краю последнего покрывала, соединяющего обе половины; ");
INSERT INTO russyn_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","пятьдесят петлей сделай у одного покрывала и пятьдесят петлей сделай на краю покрывала, которое соединяется с другим; петли должны соответствовать одна другой; ");
INSERT INTO russyn_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","и сделай пятьдесят крючков золотых и крючками соедини покрывала одно с другим, и будет скиния одно целое. ");
INSERT INTO russyn_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","И сделай покрывала на козьей шерсти, чтобы покрывать скинию; одиннадцать покрывал сделай таких; ");
INSERT INTO russyn_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","длина одного покрывала тридцать локтей, а ширина четыре локтя; это одно покрывало: одиннадцати покрывалам одна мера. ");
INSERT INTO russyn_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","И соедини пять покрывал особо и шесть покрывал особо; шестое покрывало сделай двойное с передней стороны скинии. ");
INSERT INTO russyn_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Сделай пятьдесят петлей на краю крайнего покрывала, для соединения его с другим, и пятьдесят петлей сделай на краю другого покрывала, для соединения с ним; ");
INSERT INTO russyn_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","сделай пятьдесят крючков медных, и вложи крючки в петли, и соедини покров, чтобы он составлял одно. ");
INSERT INTO russyn_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","А излишек, остающийся от покрывал скиний, - половина излишнего покрывала пусть будет свешена на задней стороне скинии; ");
INSERT INTO russyn_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","а излишек от длины покрывал скинии, на локоть с одной и на локоть с другой стороны, пусть будет свешен по бокам скинии с той и с другой стороны, для покрытия ее. ");
INSERT INTO russyn_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","И сделай покрышку для покрова из кож бараньих красных и еще покров верхний из кож синих. ");
INSERT INTO russyn_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","И сделай брусья для скинии из дерева ситтим, чтобы они стояли: ");
INSERT INTO russyn_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","длиною в десять локтей сделай брус, и полтора локтя каждому брусу ширина; ");
INSERT INTO russyn_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","у каждого бруса по два шипа на концах, один против другого: так сделай у всех брусьев скинии. ");
INSERT INTO russyn_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Так сделай брусья для скинии: двадцать брусьев для полуденной стороны к югу, ");
INSERT INTO russyn_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","и под двадцать брусьев сделай сорок серебряных подножий: два подножия под один брус для двух шипов его, и два подножия под другой брус для двух шипов его; ");
INSERT INTO russyn_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","и двадцать брусьев для другой стороны скинии к северу, ");
INSERT INTO russyn_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","и для них сорок подножий серебряных: два подножия для двух шипов его под один брус, и два подножия под другой брус для двух шипов его; ");
INSERT INTO russyn_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","для задней же стороны скинии к западу сделай шесть брусьев ");
INSERT INTO russyn_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","и два бруса сделай для углов скинии на заднюю сторону; ");
INSERT INTO russyn_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","они должны быть соединены внизу и соединены вверху к одному кольцу: так должно быть с ними обоими; для обоих углов пусть они будут; ");
INSERT INTO russyn_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","и так будет восемь брусьев, и для них серебряных подножий шестнадцать: два подножия под один брус, и два подножия под другой брус для двух шипов его. ");
INSERT INTO russyn_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","И сделай шесты из дерева ситтим, пять шестов для брусьев одной стороны скинии, ");
INSERT INTO russyn_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","и пять шестов для брусьев другой стороны скинии, и пять шестов для брусьев задней стороны сзади скинии, к западу; ");
INSERT INTO russyn_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","а внутренний шест будет проходить по средине брусьев от одного конца до другого; ");
INSERT INTO russyn_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","брусья же обложи золотом, и кольца, для вкладывания шестов, сделай из золота, и шесты обложи золотом. ");
INSERT INTO russyn_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","И поставь скинию по образцу, который показан тебе на горе. ");
INSERT INTO russyn_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","И сделай завесу из голубой, пурпуровой и червленой шерсти и крученого виссона; искусною работою должны быть сделаны на ней херувимы; ");
INSERT INTO russyn_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","и повесь ее на четырех столбах из ситтим, обложенных золотом, с золотыми крючками, на четырех подножиях серебряных; ");
INSERT INTO russyn_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","и повесь завесу на крючках и внеси туда за завесу ковчег откровения; и будет завеса отделять вам святилище от Святаго-святых. ");
INSERT INTO russyn_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","И положи крышку на ковчег откровения во Святом-святых. ");
INSERT INTO russyn_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","И поставь стол вне завесы и светильник против стола на стороне скинии к югу; стол же поставь на северной стороне скинии. ");
INSERT INTO russyn_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","И сделай завесу для входа в скинию из голубой и пурпуровой и червленой шерсти и из крученого виссона узорчатой работы; ");
INSERT INTO russyn_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","и сделай для завесы пять столбов из ситтим и обложи их золотом; крючки к ним золотые; и вылей для них пять подножий медных. ");
INSERT INTO russyn_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","И сделай жертвенник из дерева ситтим длиною пяти локтей и шириною пяти локтей, так чтобы он был четырехугольный, и вышиною трех локтей. ");
INSERT INTO russyn_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","И сделай роги на четырех углах его, так чтобы роги выходили из него; и обложи его медью. ");
INSERT INTO russyn_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Сделай к нему горшки для высыпания в них пепла, и лопатки, и чаши, и вилки, и угольницы; все принадлежности сделай из меди. ");
INSERT INTO russyn_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Сделай к нему решетку, род сетки, из меди, и сделай на сетке, на четырех углах ее, четыре кольца медных; ");
INSERT INTO russyn_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","и положи ее по окраине жертвенника внизу, так чтобы сетка была до половины жертвенника. ");
INSERT INTO russyn_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","И сделай шесты для жертвенника, шесты из дерева ситтим, и обложи их медью; ");
INSERT INTO russyn_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","и вкладывай шесты его в кольца, так чтобы шесты были по обоим бокам жертвенника, когда нести его. ");
INSERT INTO russyn_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Сделай его пустой внутри, дощатый: как показано тебе на горе, так пусть сделают его. ");
INSERT INTO russyn_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Сделай двор скинии: с полуденной стороны к югу завесы для двора должны быть из крученого виссона, длиною во сто локтей по одной стороне; ");
INSERT INTO russyn_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","столбов для них двадцать, и подножий для них двадцать медных; крючки у столбов и связи на них из серебра. ");
INSERT INTO russyn_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Также и вдоль по северной стороне - завесы ста локтей длиною; столбов для них двадцать, и подножий для них двадцать медных; крючки у столбов и связи на них и подножия их из серебра. ");
INSERT INTO russyn_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","В ширину же двора с западной стороны - завесы пятидесяти локтей; столбов для них десять, и подножий к ним десять. ");
INSERT INTO russyn_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","И в ширину двора с передней стороны к востоку - завесы пятидесяти локтей; столбов для них десять, и подножий для них десять. ");
INSERT INTO russyn_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","К одной стороне - завесы в пятнадцать локтей вышиною, столбов для них три, и подножий для них три; ");
INSERT INTO russyn_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","и к другой стороне - завесы в пятнадцать локтей вышиною, столбов для них три, и подножий для них три. ");
INSERT INTO russyn_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","А для ворот двора завеса в двадцать локтей из голубой и пурпуровой и червленой шерсти и из крученого виссона узорчатой работы; столбов для нее четыре, и подножий к ним четыре. ");
INSERT INTO russyn_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Все столбы вокруг двора должны быть соединены связями из серебра; крючки у них из серебра, а подножия к ним из меди. ");
INSERT INTO russyn_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Длина двора сто локтей, а ширина по всему протяжению пятьдесят, высота пять локтей; завесы из крученого виссона, а подножия у столбов из меди. ");
INSERT INTO russyn_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Все принадлежности скинии для всякого употребления в ней, и все колья ее, и все колья двора - из меди. ");
INSERT INTO russyn_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","И вели сынам Израилевым, чтобы они приносили тебе елей чистый, выбитый из маслин, для освещения, чтобы горел светильник во всякое время; ");
INSERT INTO russyn_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","в скинии собрания вне завесы, которая пред ковчегом откровения, будет зажигать его Аарон и сыновья его, от вечера до утра, пред лицем Господним. Это устав вечный для поколений их от сынов Израилевых. ");
INSERT INTO russyn_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","И возьми к себе Аарона, брата твоего, и сынов его с ним, от среды сынов Израилевых, чтоб он был священником Мне, Аарона и Надава, Авиуда, Елеазара и Ифамара, сынов Аароновых. ");
INSERT INTO russyn_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","И сделай священные одежды Аарону, брату твоему, для славы и благолепия. ");
INSERT INTO russyn_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","И скажи всем мудрым сердцем, которых Я исполнил духа премудрости и смышления, чтобы они сделали Аарону священные одежды для посвящения его, чтобы он был священником Мне. ");
INSERT INTO russyn_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Вот одежды, которые должны они сделать: наперсник, ефод, верхняя риза, хитон стяжной, кидар и пояс. Пусть сделают священные одежды Аарону, брату твоему, и сынам его, чтобы он был священником Мне. ");
INSERT INTO russyn_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Пусть они возьмут золота, голубой и пурпуровой и червленой шерсти и виссона, ");
INSERT INTO russyn_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","и сделают ефод из золота, из голубой, пурпуровой и червленой шерсти, и из крученого виссона, искусною работою. ");
INSERT INTO russyn_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","У него должны быть на обоих концах его два связывающие нарамника, чтобы он был связан. ");
INSERT INTO russyn_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","И пояс ефода, который поверх его, должен быть одинаковой с ним работы, из чистого золота, из голубой, пурпуровой и червленой шерсти и из крученого виссона. ");
INSERT INTO russyn_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","И возьми два камня оникса и вырежь на них имена сынов Израилевых: ");
INSERT INTO russyn_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","шесть имен их на одном камне и шесть имен остальных на другом камне, по порядку рождения их; ");
INSERT INTO russyn_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","чрез резчика на камне, который вырезывает печати, вырежь на двух камнях имена сынов Израилевых; и вставь их в золотые гнезда ");
INSERT INTO russyn_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","и положи два камня сии на нарамники ефода: это камни на память сынам Израилевым; и будет Аарон носить имена их пред Господом на обоих раменах своих для памяти. ");
INSERT INTO russyn_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","И сделай гнезда из чистого золота; ");
INSERT INTO russyn_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","и сделай две цепочки из чистого золота, витыми сделай их работою плетеною, и прикрепи витые цепочки к гнездам на нарамниках их спереди. ");
INSERT INTO russyn_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Сделай наперсник судный искусною работою; сделай его такою же работою, как ефод: из золота, из голубой, пурпуровой и червленой шерсти и из крученого виссона сделай его; ");
INSERT INTO russyn_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","он должен быть четырехугольный, двойной, в пядень длиною и в пядень шириною; ");
INSERT INTO russyn_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","и вставь в него оправленные камни в четыре ряда; рядом: рубин, топаз, изумруд,- это один ряд; ");
INSERT INTO russyn_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","второй ряд: карбункул, сапфир и алмаз; ");
INSERT INTO russyn_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","третий ряд: яхонт, агат и аметист; ");
INSERT INTO russyn_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","четвертый ряд: хризолит, оникс и яспис; в золотых гнездах должны быть вставлены они. ");
INSERT INTO russyn_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Сих камней должно быть двенадцать, по числу двенадцати имен сынов Израилевых на двух раменах его, по именам их и по рождению их; на каждом, как на печати, должно быть вырезано по одному имени из числа двенадцати колен. ");
INSERT INTO russyn_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","К наперснику сделай цепочки витые плетеною работою из чистого золота; ");
INSERT INTO russyn_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","и сделай к наперснику два кольца из золота и прикрепи два золотых кольца к двум концам наперсника; ");
INSERT INTO russyn_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","и вдень две плетеные цепочки из золота в оба кольца по обоим концам наперсника, ");
INSERT INTO russyn_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","а два конца двух цепочек прикрепи к двум гнездам и прикрепи к нарамникам ефода с лицевой стороны его; ");
INSERT INTO russyn_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","еще сделай два кольца золотых и прикрепи их к двум другим концам наперсника, на той стороне, которая лежит к ефоду внутрь; ");
INSERT INTO russyn_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","также сделай два кольца золотых и прикрепи их к двум нарамникам ефода снизу, с лицевой стороны его, у соединения его, над поясом ефода; ");
INSERT INTO russyn_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","и прикрепят наперсник кольцами его к кольцам ефода шнуром из голубой шерсти, чтобы он был над поясом ефода, и чтоб не спадал наперсник с ефода. ");
INSERT INTO russyn_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","И будет носить Аарон имена сынов Израилевых на наперснике судном у сердца своего, когда будет входить во святилище, для постоянной памяти пред Господом. И положи на наперсник судный витые цепочки, положи на оба конца наперсника, и положи оба гнезда на обоих плечах на нарамнике с лица. ");
INSERT INTO russyn_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","На наперсник судный возложи урим и туммим, и они будут у сердца Ааронова, когда будет он входить во святилище пред лице Господне; и будет Аарон всегда носить суд сынов Израилевых у сердца своего пред лицем Господним. ");
INSERT INTO russyn_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","И сделай верхнюю ризу к ефоду всю голубого цвета; ");
INSERT INTO russyn_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","среди ее должно быть отверстие для головы; у отверстия ее вокруг должна быть обшивка тканая, подобно как у отверстия брони, чтобы не дралось; ");
INSERT INTO russyn_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","по подолу ее сделай яблоки из нитей голубого, яхонтового, пурпурового и червленого цвета и из крученого виссона, вокруг по подолу ее; такого вида яблоки и позвонки золотые между ними кругом: ");
INSERT INTO russyn_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","золотой позвонок и яблоко, золотой позвонок и яблоко, по подолу верхней ризы кругом; ");
INSERT INTO russyn_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","она будет на Аароне в служении, дабы слышен был от него звук, когда он будет входить во святилище пред лице Господне и когда будет выходить, чтобы ему не умереть. ");
INSERT INTO russyn_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","И сделай полированную дощечку из чистого золота, и вырежь на ней, как вырезывают на печати: “Святыня Господня”, ");
INSERT INTO russyn_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","и прикрепи ее шнуром голубого цвета к кидару, так чтобы она была на передней стороне кидара; ");
INSERT INTO russyn_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","и будет она на челе Аароновом, и понесет на себе Аарон недостатки приношений, посвящаемых от сынов Израилевых, и всех даров, ими приносимых; и будет она непрестанно на челе его, для благоволения Господня к ним. ");
INSERT INTO russyn_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","И сделай хитон из виссона и кидар из виссона и сделай пояс узорчатой работы; ");
INSERT INTO russyn_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","сделай и сынам Аароновым хитоны, сделай им поясы, и головные повязки сделай им для славы и благолепия, ");
INSERT INTO russyn_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","и облеки в них Аарона, брата твоего, и сынов его с ним, и помажь их, и наполни руки их, и посвяти их, и они будут священниками Мне. ");
INSERT INTO russyn_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","И сделай им нижнее платье льняное, для прикрытия телесной наготы от чресл до голеней, ");
INSERT INTO russyn_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","и да будут они на Аароне и на сынах его, когда будут они входить в скинию собрания, или приступать к жертвеннику для служения во святилище, чтобы им не навести на себя греха и не умереть. Это устав вечный, да будет для него и для потомков его по нем. ");
INSERT INTO russyn_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Вот что должен ты совершить над ними, чтобы посвятить их во священники Мне: возьми одного тельца из волов, и двух овнов без порока, ");
INSERT INTO russyn_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","и хлебов пресных, и опресноков, смешанных с елеем, и лепешек пресных, помазанных елеем: из муки пшеничной сделай их, ");
INSERT INTO russyn_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","и положи их в одну корзину, и принеси их в корзине, и вместе тельца и двух овнов. ");
INSERT INTO russyn_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Аарона же и сынов его приведи ко входу в скинию собрания и омой их водою. ");
INSERT INTO russyn_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","И возьми священные одежды, и облеки Аарона в хитон и в верхнюю ризу, в ефод и в наперсник, и опояшь его по ефоду; ");
INSERT INTO russyn_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","и возложи ему на голову кидар и укрепи диадиму святыни на кидаре; ");
INSERT INTO russyn_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","и возьми елей помазания, и возлей ему на голову, и помажь его. ");
INSERT INTO russyn_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","И приведи также сынов его и облеки их в хитоны; ");
INSERT INTO russyn_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","и опояшь их поясом, Аарона и сынов его, и возложи на них повязки и будет им принадлежать священство по уставу навеки; и наполни руки Аарона и сынов его. ");
INSERT INTO russyn_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","И приведи тельца пред скинию собрания, и возложат Аарон и сыны его руки свои на голову тельца пред Господом у дверей скинии собрания; ");
INSERT INTO russyn_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","и заколи тельца пред лицем Господним при входе в скинию собрания; ");
INSERT INTO russyn_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","возьми крови тельца и возложи перстом твоим на роги жертвенника, а всю остальную кровь вылей у основания жертвенника; ");
INSERT INTO russyn_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","возьми весь тук, покрывающий внутренности, и сальник с печени, и обе почки и тук, который на них, и воскури на жертвеннике; ");
INSERT INTO russyn_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","а мясо тельца и кожу его и нечистоты его сожги на огне вне стана: это - жертва за грех. ");
INSERT INTO russyn_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","И возьми одного овна, и возложат Аарон и сыны его руки свои на голову овна; ");
INSERT INTO russyn_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","и заколи овна, и возьми крови его, и покропи на жертвенник со всех сторон; ");
INSERT INTO russyn_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","рассеки овна на части, вымой в воде внутренности его и голени его, и положи их на рассеченные части его и на голову его; ");
INSERT INTO russyn_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","и сожги всего овна на жертвеннике. Это всесожжение Господу, благоухание приятное, жертва Господу. ");
INSERT INTO russyn_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Возьми и другого овна, и возложат Аарон и сыны его руки свои на голову овна; ");
INSERT INTO russyn_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","и заколи овна, и возьми крови его, и возложи на край правого уха Ааронова и на край правого уха сынов его, и на большой палец правой руки их, и на большой палец правой ноги их; и покропи кровью на жертвенник со всех сторон; ");
INSERT INTO russyn_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","и возьми крови, которая на жертвеннике, и елея помазания, и покропи на Аарона и на одежды его, и на сынов его, и на одежды сынов его с ним, - и будут освящены, он и одежды его, и сыны его и одежды их с ним. ");
INSERT INTO russyn_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","И возьми от овна тук и курдюк, и тук, покрывающий внутренности, и сальник с печени, и обе почки и тук, который на них, правое плечо потому что это овен вручения священства, ");
INSERT INTO russyn_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","и один круглый хлеб, одну лепешку на елее и один опреснок из корзины, которая пред Господом, ");
INSERT INTO russyn_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","и положи все на руки Аарону и на руки сынам его, и принеси это, потрясая пред лицем Господним; ");
INSERT INTO russyn_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","и возьми это с рук их и сожги на жертвеннике со всесожжением, в благоухание пред Господом: это жертва Господу. ");
INSERT INTO russyn_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","И возьми грудь от овна вручения, который для Аарона, и принеси ее, потрясая пред лицем Господним, - и это будет твоя доля; ");
INSERT INTO russyn_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","и освяти грудь приношения, которая потрясаема была и плечо возношения, которое было возносимо, от овна вручения, который для Аарона и для сынов его, ");
INSERT INTO russyn_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","и будет это Аарону и сынам его в участок вечный от сынов Израилевых, ибо это - возношение; возношение должно быть от сынов Израилевых при мирных жертвах сынов Израилевых, возношение их Господу. ");
INSERT INTO russyn_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","А священные одежды, которые для Аарона, перейдут после него к сынам его, чтобы в них помазывать их и вручать им священство; ");
INSERT INTO russyn_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","семь дней должен облачаться в них великий священник из сынов его, заступающий его место, который будет входить в скинию собрания для служения во святилище. ");
INSERT INTO russyn_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Овна же вручения возьми и свари мясо его на месте святом; ");
INSERT INTO russyn_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","и пусть съедят Аарон и сыны его мясо овна сего из корзины, у дверей скинии собрания, ");
INSERT INTO russyn_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","ибо чрез это совершено очищение для вручения им священства и для посвящения их; посторонний не должен есть сего, ибо это святыня; ");
INSERT INTO russyn_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","если останется от мяса вручения и от хлеба до утра, то сожги остаток на огне: не должно есть его, ибо это святыня. ");
INSERT INTO russyn_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","И поступи с Аароном и с сынами его во всем так, как Я повелел тебе; в семь дней наполняй руки их. ");
INSERT INTO russyn_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","И тельца за грех приноси каждый день для очищения, и жертву за грех совершай на жертвеннике для очищения его, и помажь его для освящения его; ");
INSERT INTO russyn_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","семь дней очищай жертвенник, и освяти его, и будет жертвенник святыня великая: все, прикасающееся к жертвеннику, освятится. ");
INSERT INTO russyn_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Вот что будешь ты приносить на жертвеннике: двух агнцев однолетних без порока каждый день постоянно в жертву всегдашнюю; ");
INSERT INTO russyn_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","одного агнца приноси поутру, а другого агнца приноси вечером, ");
INSERT INTO russyn_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","и десятую часть ефы пшеничной муки, смешанной с четвертью гина битого елея, а для возлияния четверть гина вина, для одного агнца; ");
INSERT INTO russyn_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","другого агнца приноси вечером: с мучным даром, подобным утреннему, и с таким же возлиянием приноси его в благоухание приятное, в жертву Господу. ");
INSERT INTO russyn_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Это - всесожжение постоянное в роды ваши пред дверями скинии собрания пред Господом, где буду открываться вам, чтобы говорить с тобою; ");
INSERT INTO russyn_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","там буду открываться сынам Израилевым, и освятится место сие славою Моею. ");
INSERT INTO russyn_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","И освящу скинию собрания и жертвенник; и Аарона и сынов его освящу, чтобы они священнодействовали Мне; ");
INSERT INTO russyn_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","и буду обитать среди сынов Израилевых, и буду им Богом, ");
INSERT INTO russyn_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","и узнают, что Я Господь, Бог их, Который вывел их из земли Египетской, чтобы Мне обитать среди них. Я Господь, Бог их. ");
INSERT INTO russyn_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","И сделай жертвенник для приношения курений, из дерева ситтим сделай его: ");
INSERT INTO russyn_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","длина ему локоть, и ширина ему локоть; он должен быть четырехугольный; а вышина ему два локтя; из него должны выходить роги его; ");
INSERT INTO russyn_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","обложи его чистым золотом, верх его и бока его кругом, и роги его; и сделай к нему золотой венец вокруг; ");
INSERT INTO russyn_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","под венцом его на двух углах его сделай два кольца из чистого золота; сделай их с двух сторон его; и будут они влагалищем для шестов, чтобы носить его на них; ");
INSERT INTO russyn_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","шесты сделай из дерева ситтим и обложи их золотом. ");
INSERT INTO russyn_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","И поставь его пред завесою, которая пред ковчегом откровения, против крышки, которая на ковчеге откровения, где Я буду открываться тебе. ");
INSERT INTO russyn_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","На нем Аарон будет курить благовонным курением; каждое утро, когда он приготовляет лампады, будет курить им; ");
INSERT INTO russyn_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","и когда Аарон зажигает лампады вечером, он будет курить им: это - всегдашнее курение пред Господом в роды ваши. ");
INSERT INTO russyn_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Не приносите на нем никакого иного курения, ни всесожжения, ни приношения хлебного, и возлияния не возливайте на него. ");
INSERT INTO russyn_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","И будет совершать Аарон очищение над рогами его однажды в год; кровью очистительной жертвы за грех он будет очищать его однажды в год в роды ваши. Это святыня великая у Господа. ");
INSERT INTO russyn_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","когда будешь делать исчисление сынов Израилевых при пересмотре их, то пусть каждый даст выкуп за душу свою Господу при исчислении их, и не будет между ними язвы губительной при исчислении их; ");
INSERT INTO russyn_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","всякий, поступающий в исчисление, должен давать половину сикля, сикля священного; в сикле двадцать гер: полсикля приношение Господу; ");
INSERT INTO russyn_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","всякий, поступающий в исчисление от двадцати лет и выше, должен давать приношение Господу; ");
INSERT INTO russyn_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","богатый не больше и бедный не меньше полсикля должны давать в приношение Господу, для выкупа душ ваших; ");
INSERT INTO russyn_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","и возьми серебро выкупа от сынов Израилевых и употребляй его на служение скинии собрания; и будет это для сынов Израилевых в память пред Господом, для искупления душ ваших. ");
INSERT INTO russyn_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","сделай умывальник медный для омовения и подножие его медное, и поставь его между скиниею собрания и между жертвенником, и налей в него воды; ");
INSERT INTO russyn_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","и пусть Аарон и сыны его омывают из него руки свои и ноги свои; ");
INSERT INTO russyn_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","когда они должны входить в скинию собрания, пусть они омываются водою, чтобы им не умереть; или когда должны приступать к жертвеннику для служения, для жертвоприношения Господу, ");
INSERT INTO russyn_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","пусть они омывают руки свои и ноги свои водою, чтобы им не умереть; и будет им это уставом вечным, ему и потомкам его в роды их. ");
INSERT INTO russyn_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","возьми себе самых лучших благовонных веществ: смирны самоточной пятьсот сиклей, корицы благовонной половину против того, двести пятьдесят, тростника благовонного двести пятьдесят, ");
INSERT INTO russyn_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","касии пятьсот сиклей, по сиклю священному, и масла оливкового гин; ");
INSERT INTO russyn_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","и сделай из сего миро для священного помазания, масть составную, искусством составляющего масти: это будет миро для священного помазания; ");
INSERT INTO russyn_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","и помажь им скинию собрания и ковчег скинии откровения, ");
INSERT INTO russyn_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","и стол и все принадлежности его, и светильник и все принадлежности его, и жертвенник курения, ");
INSERT INTO russyn_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","и жертвенник всесожжения и все принадлежности его, и умывальник и подножие его; ");
INSERT INTO russyn_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","и освяти их, и будет святыня великая: все, прикасающееся к ним, освятится; ");
INSERT INTO russyn_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","помажь и Аарона и сынов его и посвяти их, чтобы они были священниками Мне. ");
INSERT INTO russyn_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","А сынам Израилевым скажи: это будет у Меня миро священного помазания в роды ваши; ");
INSERT INTO russyn_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","тела прочих людей не должно помазывать им, и по составу его не делайте сами себе подобного ему; оно - святыня: святынею должно быть для вас; ");
INSERT INTO russyn_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","кто составит подобное ему или кто помажет им постороннего, тот истребится из народа своего. ");
INSERT INTO russyn_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","И сказал Господь Моисею: возьми себе благовонных веществ: стакти, ониха, халвана душистого и чистого ливана, всего половину, ");
INSERT INTO russyn_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","и сделай из них искусством составляющего масти курительный состав, стертый, чистый, святый, ");
INSERT INTO russyn_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","и истолки его мелко, и полагай его пред ковчегом откровения в скинии собрания, где Я буду открываться тебе: это будет святыня великая для вас; ");
INSERT INTO russyn_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","курения, сделанного по сему составу, не делайте себе: святынею да будет оно у тебя для Господа; ");
INSERT INTO russyn_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","кто сделает подобное, чтобы курить им, душа та истребится из народа своего. ");
INSERT INTO russyn_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","смотри, Я назначаю именно Веселеила, сына Уриева, сына Орова, из колена Иудина; ");
INSERT INTO russyn_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","и Я исполнил его Духом Божиим, мудростью, разумением, ведением и всяким искусством, ");
INSERT INTO russyn_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","работать из золота, серебра и меди, из голубой, пурпуровой и червленой шерсти и из крученого виссона, ");
INSERT INTO russyn_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","резать камни для вставливания и резать дерево для всякого дела; ");
INSERT INTO russyn_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","и вот, Я даю ему помощником Аголиава, сына Ахисамахова, из колена Данова, и в сердце всякого мудрого вложу мудрость, дабы они сделали все, что Я повелел тебе: ");
INSERT INTO russyn_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","скинию собрания и ковчег откровения и крышку на него, и все принадлежности скинии, ");
INSERT INTO russyn_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","и стол и все принадлежности его, и светильник из чистого золота и все принадлежности его, и жертвенник курения, ");
INSERT INTO russyn_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","и жертвенник всесожжения и все принадлежности его, и умывальник и подножие его, ");
INSERT INTO russyn_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","и одежды служебные и одежды священные Аарону священнику, и одежды сынам его, для священнослужения, ");
INSERT INTO russyn_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","и елей помазания и курение благовонное для святилища: все так, как Я повелел тебе, они сделают. ");
INSERT INTO russyn_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","скажи сынам Израилевым так: субботы Мои соблюдайте, ибо это - знамение между Мною и вами в роды ваши, дабы вы знали, что Я Господь, освящающий вас; ");
INSERT INTO russyn_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","и соблюдайте субботу, ибо она свята для вас: кто осквернит ее, тот да будет предан смерти; кто станет в оную делать дело, та душа должна быть истреблена из среды народа своего; ");
INSERT INTO russyn_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","шесть дней пусть делают дела, а в седьмой - суббота покоя, посвященная Господу: всякий, кто делает дело в день субботний, да будет предан смерти; ");
INSERT INTO russyn_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","и пусть хранят сыны Израилевы субботу, празднуя субботу в роды свои, как завет вечный; ");
INSERT INTO russyn_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","это - знамение между Мною и сынами Израилевыми навеки, потому что в шесть дней сотворил Господь небо и землю, а в день седьмой почил и покоился. ");
INSERT INTO russyn_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","И когда Бог перестал говорить с Моисеем на горе Синае, дал ему две скрижали откровения, скрижали каменные, на которых написано было перстом Божиим. ");
INSERT INTO russyn_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Когда народ увидел, что Моисей долго не сходит с горы, то собрался к Аарону и сказал ему: встань и сделай нам бога, который бы шел перед нами, ибо с этим человеком, с Моисеем, который вывел нас из земли Египетской, не знаем, что сделалось. ");
INSERT INTO russyn_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","И сказал им Аарон: выньте золотые серьги, которые в ушах ваших жен, ваших сыновей и ваших дочерей, и принесите ко мне. ");
INSERT INTO russyn_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","И весь народ вынул золотые серьги из ушей своих и принесли к Аарону. ");
INSERT INTO russyn_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Он взял их из рук их, и сделал из них литого тельца, и обделал его резцом. И сказали они: вот бог твой, Израиль, который вывел тебя из земли Египетской! ");
INSERT INTO russyn_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Увидев сие, Аарон поставил пред ним жертвенник, и провозгласил Аарон, говоря: завтра праздник Господу. ");
INSERT INTO russyn_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","На другой день они встали рано и принесли всесожжения и привели жертвы мирные: и сел народ есть и пить, а после встал играть. ");
INSERT INTO russyn_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","И сказал Господь Моисею: поспеши сойти отсюда, ибо развратился народ твой, который ты вывел из земли Египетской; ");
INSERT INTO russyn_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","скоро уклонились они от пути, который Я заповедал им: сделали себе литого тельца и поклонились ему, и принесли ему жертвы и сказали: вот бог твой, Израиль, который вывел тебя из земли Египетской! ");
INSERT INTO russyn_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","И сказал Господь Моисею: Я вижу народ сей, и вот, народ он - жестоковыйный; ");
INSERT INTO russyn_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","итак оставь Меня, да воспламенится гнев Мой на них, и истреблю их, и произведу многочисленный народ от тебя. ");
INSERT INTO russyn_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Но Моисей стал умолять Господа, Бога своего, и сказал: да не воспламеняется, Господи, гнев Твой на народ Твой, который Ты вывел из земли Египетской силою великою и рукою крепкою, ");
INSERT INTO russyn_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","чтобы Египтяне не говорили: на погибель Он вывел их, чтобы убить их в горах и истребить их с лица земли; отврати пламенный гнев Твой и отмени погубление народа Твоего; ");
INSERT INTO russyn_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","вспомни Авраама, Исаака и Израиля Иакова, рабов Твоих, которым клялся Ты Собою, говоря: умножая умножу семя ваше, как звезды небесные, и всю землю сию, о которой Я сказал, дам семени вашему, и будут владеть ею вечно. ");
INSERT INTO russyn_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","И отменил Господь зло, о котором сказал, что наведет его на народ Свой. ");
INSERT INTO russyn_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","И обратился и сошел Моисей с горы; в руке его были две скрижали откровения каменные, на которых написано было с обеих сторон: и на той и на другой стороне написано было; ");
INSERT INTO russyn_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","скрижали были дело Божие, и письмена, начертанные на скрижалях, были письмена Божии. ");
INSERT INTO russyn_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","И услышал Иисус голос народа шумящего и сказал Моисею: военный крик в стане. ");
INSERT INTO russyn_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Но Моисей сказал: это не крик побеждающих и не вопль поражаемых; я слышу голос поющих. ");
INSERT INTO russyn_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Когда же он приблизился к стану и увидел тельца и пляски, тогда он воспламенился гневом и бросил из рук своих скрижали и разбил их под горою; ");
INSERT INTO russyn_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","и взял тельца, которого они сделали, и сжег его в огне, и стер в прах, и рассыпал по воде, и дал ее пить сынам Израилевым. ");
INSERT INTO russyn_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","И сказал Моисей Аарону: что сделал тебе народ сей, что ты ввел его в грех великий? ");
INSERT INTO russyn_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Но Аарон сказал Моисею: да не возгорается гнев господина моего; ты знаешь этот народ, что он буйный. ");
INSERT INTO russyn_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Они сказали мне: сделай нам бога, который шел бы перед нами; ибо с Моисеем, с этим человеком, который вывел нас из земли Египетской, не знаем, что сделалось. ");
INSERT INTO russyn_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","И я сказал им: у кого есть золото, снимите с себя. Они сняли и отдали мне; я бросил его в огонь, и вышел этот телец. ");
INSERT INTO russyn_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Моисей увидел, что это народ необузданный, ибо Аарон допустил его до необузданности, к посрамлению пред врагами его. ");
INSERT INTO russyn_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","И стал Моисей в воротах стана и сказал: кто Господень, иди ко мне! И собрались к нему все сыны Левиины. ");
INSERT INTO russyn_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","И он сказал им: так говорит Господь Бог Израилев: возложите каждый свой меч на бедро свое, пройдите по стану от ворот до ворот и обратно, и убивайте каждый брата своего, каждый друга своего, каждый ближнего своего. ");
INSERT INTO russyn_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","И сделали сыны Левиины по слову Моисея: и пало в тот день из народа около трех тысяч человек. ");
INSERT INTO russyn_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Ибо Моисей сказал им: сегодня посвятите руки ваши Господу, каждый в сыне своем и брате своем, да ниспошлет Он вам сегодня благословение. ");
INSERT INTO russyn_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","На другой день сказал Моисей народу: вы сделали великий грех; итак я взойду к Господу, не заглажу ли греха вашего. ");
INSERT INTO russyn_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","И возвратился Моисей к Господу и сказал: о, Господи! народ сей сделал великий грех: сделал себе золотого бога; ");
INSERT INTO russyn_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","прости им грех их, а если нет, то изгладь и меня из книги Твоей, в которую Ты вписал. ");
INSERT INTO russyn_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Господь сказал Моисею: того, кто согрешил предо Мною, изглажу из книги Моей; ");
INSERT INTO russyn_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","итак иди, сойди, веди народ сей, куда Я сказал тебе; вот Ангел Мой пойдет пред тобою, и в день посещения Моего Я посещу их за грех их. ");
INSERT INTO russyn_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","И поразил Господь народ за сделанного тельца, которого сделал Аарон. ");
INSERT INTO russyn_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","И сказал Господь Моисею: пойди, иди отсюда ты и народ, который ты вывел из земли Египетской, в землю, о которой Я клялся Аврааму, Исааку и Иакову, говоря: потомству твоему дам ее; ");
INSERT INTO russyn_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","и пошлю пред тобою Ангела Моего, и прогоню Хананеев, Аморреев, Хеттеев, Ферезеев, Гергесеев, Евеев и Иевусеев, ");
INSERT INTO russyn_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","и введет он вас в землю, где течет молоко и мед; ибо Сам не пойду среди вас, чтобы не погубить Мне вас на пути, потому что вы народ жестоковыйный. ");
INSERT INTO russyn_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Народ, услышав грозное слово сие, возрыдал, и никто не возложил на себя украшений своих. ");
INSERT INTO russyn_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Ибо Господь сказал Моисею: скажи сынам Израилевым: вы народ жестоковыйный; если Я пойду среди вас, то в одну минуту истреблю вас; итак снимите с себя украшения свои; Я посмотрю, что Мне делать с вами. ");
INSERT INTO russyn_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Сыны Израилевы сняли с себя украшения свои у горы Хорива. ");
INSERT INTO russyn_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Моисей же взял и поставил себе шатер вне стана, вдали от стана, и назвал его скиниею собрания; и каждый, ищущий Господа, приходил в скинию собрания, находившуюся вне стана. ");
INSERT INTO russyn_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","И когда Моисей выходил к скинии, весь народ вставал, и становился каждый у входа в свой шатер и смотрел вслед Моисею, доколе он не входил в скинию. ");
INSERT INTO russyn_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Когда же Моисей входил в скинию, тогда спускался столп облачный и становился у входа в скинию, и Господь говорил с Моисеем. ");
INSERT INTO russyn_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","И видел весь народ столп облачный, стоявший у входа в скинию; и вставал весь народ, и поклонялся каждый у входа в шатер свой. ");
INSERT INTO russyn_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","И говорил Господь с Моисеем лицом к лицу, как бы говорил кто с другом своим; и он возвращался в стан; а служитель его Иисус, сын Навин, юноша, не отлучался от скинии. ");
INSERT INTO russyn_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Моисей сказал Господу: вот, Ты говоришь мне: веди народ сей, а не открыл мне, кого пошлешь со мною, хотя Ты сказал: “Я знаю тебя по имени, и ты приобрел благоволение в очах Моих”; ");
INSERT INTO russyn_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","итак, если я приобрел благоволение в очах Твоих, то молю: открой мне путь Твой, дабы я познал Тебя, чтобы приобрести благоволение в очах Твоих; и помысли, что сии люди Твой народ. ");
INSERT INTO russyn_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Господь сказал ему: Сам Я пойду пред тобою и введу тебя в покой. ");
INSERT INTO russyn_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Моисей сказал Ему: если не пойдешь Ты Сам с нами, то и не выводи нас отсюда, ");
INSERT INTO russyn_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","ибо по чему узнать, что я и народ Твой обрели благоволение в очах Твоих? не по тому ли, когда Ты пойдешь с нами? тогда я и народ Твой будем славнее всякого народа на земле. ");
INSERT INTO russyn_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","И сказал Господь Моисею: и то, о чем ты говорил, Я сделаю, потому что ты приобрел благоволение в очах Моих, и Я знаю тебя по имени. ");
INSERT INTO russyn_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Моисей сказал: покажи мне славу Твою. ");
INSERT INTO russyn_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","И сказал Господь Моисею: Я проведу пред тобою всю славу Мою и провозглашу имя Иеговы пред тобою, и кого помиловать - помилую, кого пожалеть - пожалею. ");
INSERT INTO russyn_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","И потом сказал Он: лица Моего не можно тебе увидеть, потому что человек не может увидеть Меня и остаться в живых. ");
INSERT INTO russyn_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","И сказал Господь: вот место у Меня, стань на этой скале; ");
INSERT INTO russyn_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","когда же будет проходить слава Моя, Я поставлю тебя в расселине скалы и покрою тебя рукою Моею, доколе не пройду; ");
INSERT INTO russyn_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","и когда сниму руку Мою, ты увидишь Меня сзади, а лице Мое не будет видимо тебе. ");
INSERT INTO russyn_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","И сказал Господь Моисею: вытеши себе две скрижали каменные, подобные прежним, и взойди ко Мне на гору, и Я напишу на сих скрижалях слова, какие были на прежних скрижалях, которые ты разбил; ");
INSERT INTO russyn_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","и будь готов к утру, и взойди утром на гору Синай, и предстань предо Мною там на вершине горы; ");
INSERT INTO russyn_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","но никто не должен восходить с тобою, и никто не должен показываться на всей горе; даже скот, мелкий и крупный, не должен пастись близ горы сей. ");
INSERT INTO russyn_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","И вытесал Моисей две скрижали каменные, подобные прежним, и, встав рано поутру, взошел на гору Синай, как повелел ему Господь; и взял в руки свои две скрижали каменные. ");
INSERT INTO russyn_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","И сошел Господь в облаке, и остановился там близ него, и провозгласил имя Иеговы. ");
INSERT INTO russyn_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","И прошел Господь пред лицом его и возгласил: Господь, Господь, Бог человеколюбивый и милосердый, долготерпеливый и многомилостивый и истинный, ");
INSERT INTO russyn_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","сохраняющий правду и являющий милость в тысячи родов, прощающий вину и преступление и грех, но не оставляющий без наказания, наказывающий вину отцов в детях и в детях детей до третьего и четвертого рода. ");
INSERT INTO russyn_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Моисей тотчас пал на землю и поклонился Богу ");
INSERT INTO russyn_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","и сказал: если я приобрел благоволение в очах Твоих, Владыка, то да пойдет Владыка посреди нас; ибо народ сей жестоковыен; прости беззакония наши и грехи наши и сделай нас наследием Твоим. ");
INSERT INTO russyn_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","И сказал Господь Моисею: вот, Я заключаю завет: пред всем народом твоим соделаю чудеса, каких не было по всей земле и ни у каких народов; и увидит весь народ, среди которого ты находишься, дело Господа; ибо страшно будет то, что Я сделаю для тебя; ");
INSERT INTO russyn_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","сохрани то, что повелеваю тебе ныне: вот, Я изгоняю от лица твоего Аморреев, Хананеев, Хеттеев, Ферезеев, Евеев, Гергесеев и Иевусеев; ");
INSERT INTO russyn_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","смотри, не вступай в союз с жителями той земли, в которую ты войдешь, дабы они не сделались сетью среди вас. ");
INSERT INTO russyn_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Жертвенники их разрушьте, столбы их сокрушите, вырубите священные рощи их, и изваяния богов их сожгите огнем, ");
INSERT INTO russyn_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","ибо ты не должен поклоняться богу иному, кроме Господа Бога, потому что имя Его - ревнитель; Он Бог ревнитель. ");
INSERT INTO russyn_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Не вступай в союз с жителями той земли, чтобы, когда они будут блудодействовать вслед богов своих и приносить жертвы богам своим, не пригласили и тебя, и ты не вкусил бы жертвы их; ");
INSERT INTO russyn_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","и не бери из дочерей их жен сынам своим и дочерей своих не давай в замужество за сыновей их, дабы дочери их, блудодействуя вслед богов своих, не ввели и сынов твоих в блужение вслед богов своих. ");
INSERT INTO russyn_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Не делай себе богов литых. ");
INSERT INTO russyn_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Праздник опресноков соблюдай: семь дней ешь пресный хлеб, как Я повелел тебе, в назначенное время месяца Авива, ибо в месяце Авиве вышел ты из Египта. ");
INSERT INTO russyn_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Все, разверзающее ложесна, Мне, как и весь скот твой мужеского пола, разверзающий ложесна, из волов и овец; ");
INSERT INTO russyn_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","первородное из ослов заменяй агнцем, а если не заменишь, то выкупи его; всех первенцев из сынов твоих выкупай; пусть не являются пред лице Мое с пустыми руками. ");
INSERT INTO russyn_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Шесть дней работай, а в седьмой день покойся; покойся и во время посева и жатвы. ");
INSERT INTO russyn_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","И праздник седмиц совершай, праздник начатков жатвы пшеницы и праздник собирания плодов в конце года; ");
INSERT INTO russyn_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","три раза в году должен являться весь мужеский пол твой пред лице Владыки, Господа Бога Израилева, ");
INSERT INTO russyn_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","ибо Я прогоню народы от лица твоего и распространю пределы твои, и никто не пожелает земли твоей, если ты будешь являться пред лице Господа Бога твоего три раза в году. ");
INSERT INTO russyn_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Не изливай крови жертвы Моей на квасное, и жертва праздника Пасхи не должна переночевать до утра. ");
INSERT INTO russyn_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Самые первые плоды земли твоей принеси в дом Господа Бога твоего. Не вари козленка в молоке матери его. ");
INSERT INTO russyn_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","И сказал Господь Моисею: напиши себе слова сии, ибо в сих словах Я заключаю завет с тобою и с Израилем. ");
INSERT INTO russyn_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","И пробыл там Моисей у Господа сорок дней и сорок ночей, хлеба не ел и воды не пил; и написал Моисей на скрижалях слова завета, десятословие. ");
INSERT INTO russyn_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Когда сходил Моисей с горы Синая, и две скрижали откровения были в руке у Моисея при сошествии его с горы, то Моисей не знал, что лице его стало сиять лучами оттого, что Бог говорил с ним. ");
INSERT INTO russyn_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","И увидел Моисея Аарон и все сыны Израилевы, и вот, лице его сияет, и боялись подойти к нему. ");
INSERT INTO russyn_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","И призвал их Моисей, и пришли к нему Аарон и все начальники общества, и разговаривал Моисей с ними. ");
INSERT INTO russyn_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","После сего приблизились к нему все сыны Израилевы, и он заповедал им все, что говорил ему Господь на горе Синае. ");
INSERT INTO russyn_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","И когда Моисей перестал разговаривать с ними, то положил на лице свое покрывало. ");
INSERT INTO russyn_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Когда же входил Моисей пред лице Господа, чтобы говорить с Ним, тогда снимал покрывало, доколе не выходил; а выйдя пересказывал сынам Израилевым все, что заповедано было ему от Господа. ");
INSERT INTO russyn_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","И видели сыны Израилевы, что сияет лице Моисеево, и Моисей опять полагал покрывало на лице свое, доколе не входил говорить с Ним. ");
INSERT INTO russyn_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","И собрал Моисей все общество сынов Израилевых и сказал им: вот что заповедал Господь делать: ");
INSERT INTO russyn_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","шесть дней делайте дела, а день седьмой должен быть у вас святым, суббота покоя Господу: всякий, кто будет делать в нее дело, предан будет смерти; ");
INSERT INTO russyn_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","не зажигайте огня во всех жилищах ваших в день субботы. Я Господь. ");
INSERT INTO russyn_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","И сказал Моисей всему обществу сынов Израилевых: вот что заповедал Господь: ");
INSERT INTO russyn_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","сделайте от себя приношения Господу: каждый по усердию пусть принесет приношение Господу, золото, серебро, медь, ");
INSERT INTO russyn_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","шерсть голубого, пурпурового и червленого цвета, и виссон крученый, и козью шерсть, ");
INSERT INTO russyn_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","кожи бараньи красные, и кожи синие, и дерево ситтим, ");
INSERT INTO russyn_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","и елей для светильника, и ароматы для елея помазания и для благовонных курений, ");
INSERT INTO russyn_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","камень оникс и камни вставные для ефода и наперсника. ");
INSERT INTO russyn_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","И всякий из вас мудрый сердцем пусть придет и сделает все, что повелел Господь: ");
INSERT INTO russyn_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","скинию и покров ее и верхнюю покрышку ее, крючки и брусья ее, шесты ее, столбы ее и подножия ее, ");
INSERT INTO russyn_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","ковчег и шесты его, крышку и завесу для преграды, и завесы двора и столбы его, и камни смарагдовые и фимиам и елей помазания, ");
INSERT INTO russyn_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","стол и шесты его и все принадлежности его, и хлебы предложения, ");
INSERT INTO russyn_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","и светильник для освещения со всеми принадлежностями его, и лампады его и елей для освящения, ");
INSERT INTO russyn_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","и жертвенник для курений и шесты его, и елей помазания, и благовонные курения, и завесу ко входу скинии, ");
INSERT INTO russyn_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","жертвенник всесожжения и решетку медную для него, и шесты его и все принадлежности его, умывальник и подножие его, ");
INSERT INTO russyn_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","завесы двора, столбы его и подножия их, и завесу у входа во двор, ");
INSERT INTO russyn_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","колья скинии, и колья двора и веревки их, ");
INSERT INTO russyn_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","одежды служебные для служения во святилище, и священные одежды Аарону священнику и одежды сынам его для священнодействия. ");
INSERT INTO russyn_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","И пошло все общество сынов Израилевых от Моисея. ");
INSERT INTO russyn_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","И приходили все, которых влекло к тому сердце, и все, которых располагал дух, и приносили приношения Господу для устроения скинии собрания и для всех потребностей ее и для всех священных одежд; ");
INSERT INTO russyn_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","и приходили мужья с женами, и все по расположению сердца приносили кольца, серьги, перстни и привески, всякие золотые вещи, каждый, кто только хотел приносить золото Господу; ");
INSERT INTO russyn_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","и каждый, у кого была шерсть голубого, пурпурового и червленого цвета, виссон и козья шерсть, кожи бараньи красные и кожи синие, приносил их; ");
INSERT INTO russyn_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","и каждый, кто жертвовал серебро или медь, приносил сие в дар Господу; и каждый, у кого было дерево ситтим, приносил сие на всякую потребность для скинии; ");
INSERT INTO russyn_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","и все женщины, мудрые сердцем, пряли своими руками и приносили пряжу голубого, пурпурового и червленого цвета и виссон; ");
INSERT INTO russyn_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","и все женщины, которых влекло сердце, умевшие прясть, пряли козью шерсть; ");
INSERT INTO russyn_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","князья же приносили камень оникс и камни вставные для ефода и наперсника, ");
INSERT INTO russyn_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","также и благовония, и елей для светильника и для составления елея помазания и для благовонных курений; ");
INSERT INTO russyn_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","и все мужья и жены из сынов Израилевых, которых влекло сердце принести на всякое дело, какое Господь чрез Моисея повелел сделать, приносили добровольный дар Господу. ");
INSERT INTO russyn_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","И сказал Моисей сынам Израилевым: смотрите, Господь назначил именно Веселеила, сына Урии, сына Ора, из колена Иудина, ");
INSERT INTO russyn_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","и исполнил его Духом Божиим, мудростью, разумением, ведением и всяким искусством, ");
INSERT INTO russyn_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","составлять искусные ткани, работать из золота, серебра и меди, ");
INSERT INTO russyn_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","и резать камни для вставливания, и резать дерево, и делать всякую художественную работу; ");
INSERT INTO russyn_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","и способность учить других вложил в сердце его, его и Аголиава, сына Ахисамахова, из колена Данова; ");
INSERT INTO russyn_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","он исполнил сердце их мудростью, чтобы делать всякую работу резчика и искусного ткача, и вышивателя по голубой, пурпуровой, червленой и виссонной ткани, и ткачей, делающих всякую работу и составляющих искусные ткани. ");
INSERT INTO russyn_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","И стал работать Веселеил и Аголиав и все мудрые сердцем, которым Господь дал мудрость и разумение, чтоб уметь сделать всякую работу, потребную для святилища, как повелел Господь. ");
INSERT INTO russyn_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","И призвал Моисей Веселеила и Аголиава и всех мудрых сердцем, которым Господь дал мудрость, и всех, коих влекло сердце приступить к работе и работать. ");
INSERT INTO russyn_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","И взяли они от Моисея все приношения, которые принесли сыны Израилевы, на все потребности святилища, чтобы работать. Между тем еще продолжали приносить к нему добровольные дары каждое утро. ");
INSERT INTO russyn_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Тогда пришли все мудрые сердцем, производившие всякие работы святилища, каждый от своей работы, какою кто занимался, ");
INSERT INTO russyn_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","и сказали Моисею, говоря: народ много приносит, более нежели потребно для работ, какие повелел Господь сделать. ");
INSERT INTO russyn_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","И приказал Моисей, и объявлено было в стане, чтобы ни мужчина, ни женщина не делали уже ничего для приношения во святилище; и перестал народ приносить. ");
INSERT INTO russyn_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Запаса было достаточно на всякие работы, какие надлежало делать, и даже осталось. ");
INSERT INTO russyn_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","И сделали все мудрые сердцем, занимавшиеся работою скинии: десять покрывал из крученого виссона и из голубой, пурпуровой и червленой шерсти; и херувимов сделали на них искусною работою; ");
INSERT INTO russyn_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","длина каждого покрывала двадцать восемь локтей, и ширина каждого покрывала четыре локтя: всем покрывалам одна мера. ");
INSERT INTO russyn_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","И соединил он пять покрывал одно с другим, и другие пять покрывал соединил одно с другим. ");
INSERT INTO russyn_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","И сделал петли голубого цвета на краю одного покрывала, где оно соединяется с другим; так же сделал он и на краю последнего покрывала, для соединения его с другим; ");
INSERT INTO russyn_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","пятьдесят петель сделал он у одного покрывала, и пятьдесят петель сделал в конце покрывала, где оно соединяется с другим; петли сии соответствовали одна другой; ");
INSERT INTO russyn_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","и сделал пятьдесят крючков золотых, и крючками соединил одно покрывало с другим, и стала скиния одно целое. ");
INSERT INTO russyn_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Потом сделал покрывала из козьей шерсти для покрытия скинии: одиннадцать покрывал сделал таких; ");
INSERT INTO russyn_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","длиною покрывало тридцать локтей, и шириною покрывало четыре локтя: одиннадцати покрывалам мера одна. ");
INSERT INTO russyn_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","И соединил он пять покрывал особо и шесть покрывал особо. ");
INSERT INTO russyn_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","И сделал пятьдесят петель на краю покрывала крайнего, где оно соединяется с другим, и пятьдесят петель сделал на краю покрывала, соединяющегося с другим; ");
INSERT INTO russyn_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","и сделал пятьдесят медных крючков для соединения покрова, чтоб составилось одно целое. ");
INSERT INTO russyn_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","И сделал для скинии покров из красных бараньих кож и покрышку сверху из кож синих. ");
INSERT INTO russyn_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","И сделал брусья для скинии из дерева ситтим прямостоящие: ");
INSERT INTO russyn_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","десять локтей длина бруса, и полтора локтя ширина каждого бруса; ");
INSERT INTO russyn_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","у каждого бруса по два шипа, один против другого: так сделал он все брусья скинии. ");
INSERT INTO russyn_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","И сделал для скинии двадцать таких брусьев для полуденной стороны, ");
INSERT INTO russyn_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","и сорок серебряных подножий сделал под двадцать брусьев: два подножия под один брус для двух шипов его, и два подножия под другой брус для двух шипов его; ");
INSERT INTO russyn_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","и для другой стороны скинии, к северу, сделал двадцать брусьев ");
INSERT INTO russyn_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","и сорок серебряных подножий: два подножия под один брус, и два подножия под другой брус; ");
INSERT INTO russyn_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","а для задней стороны скинии, к западу, сделал шесть брусьев, ");
INSERT INTO russyn_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","и два бруса сделал для угла в скинии на заднюю сторону; ");
INSERT INTO russyn_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","и были они соединены внизу и соединены вверху к одному кольцу: так сделал он с ними обоими на обоих углах; ");
INSERT INTO russyn_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","и было восемь брусьев и серебряных подножий шестнадцать, по два подножия под каждый брус. ");
INSERT INTO russyn_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","И сделал шесты из дерева ситтим, пять для брусьев одной стороны скинии, ");
INSERT INTO russyn_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","и пять шестов для брусьев другой стороны скинии, и пять шестов для брусьев задней стороны скинии; ");
INSERT INTO russyn_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","и сделал внутренний шест, который проходил бы по средине брусьев от одного конца до другого; ");
INSERT INTO russyn_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","брусья обложил золотом, и кольца, в которые вкладываются шесты, сделал из золота, и шесты обложил золотом. ");
INSERT INTO russyn_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","И сделал завесу из голубой, пурпуровой и червленой шерсти и из крученого виссона, и искусною работою сделал на ней херувимов; ");
INSERT INTO russyn_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","и сделал для нее четыре столба из ситтим и обложил их золотом, с золотыми крючками, и вылил для них четыре серебряных подножия. ");
INSERT INTO russyn_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","И сделал завесу ко входу скинии из голубой, пурпуровой и червленой шерсти и из крученого виссона, узорчатой работы, ");
INSERT INTO russyn_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","и пять столбов для нее с крючками; и обложил верхи их и связи их золотом, и вылил пять медных подножий. ");
INSERT INTO russyn_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","И сделал Веселеил ковчег из дерева ситтим; длина его два локтя с половиною, ширина его полтора локтя и высота его полтора локтя; ");
INSERT INTO russyn_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","и обложил его чистым золотом внутри и снаружи и сделал вокруг него золотой венец; ");
INSERT INTO russyn_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","и вылил для него четыре кольца золотых, на четырех нижних углах его: два кольца на одной стороне его и два кольца на другой стороне его. ");
INSERT INTO russyn_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","И сделал шесты из дерева ситтим и обложил их золотом; ");
INSERT INTO russyn_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","и вложил шесты в кольца, по сторонам ковчега, чтобы носить ковчег. ");
INSERT INTO russyn_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","И сделал крышку из чистого золота: длина ее два локтя с половиною, а ширина полтора локтя. ");
INSERT INTO russyn_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","И сделал двух херувимов из золота: чеканной работы сделал их на обоих концах крышки, ");
INSERT INTO russyn_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","одного херувима с одного конца, а другого херувима с другого конца: выдавшимися из крышки сделал херувимов с обоих концов ее; ");
INSERT INTO russyn_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","и были херувимы с распростертыми вверх крыльями и покрывали крыльями своими крышку, а лицами своими были обращены друг к другу; к крышке были лица херувимов. ");
INSERT INTO russyn_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","И сделал стол из дерева ситтим длиною в два локтя, шириною в локоть и вышиною в полтора локтя, ");
INSERT INTO russyn_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","и обложил его золотом чистым, и сделал вокруг него золотой венец; ");
INSERT INTO russyn_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","и сделал вокруг него стенки в ладонь и сделал золотой венец у стенок его; ");
INSERT INTO russyn_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","и вылил для него четыре кольца золотых и утвердил кольца на четырех углах, у четырех ножек его; ");
INSERT INTO russyn_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","при стенках были кольца, чтобы влагать шесты для ношения стола; ");
INSERT INTO russyn_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","и сделал шесты из дерева ситтим и обложил их золотом для ношения стола. ");
INSERT INTO russyn_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Потом сделал сосуды, принадлежавшие к столу: блюда, кадильницы, кружки и чаши, чтобы возливать ими, из чистого золота. ");
INSERT INTO russyn_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","И сделал светильник из золота чистого, чеканный сделал светильник; стебель его, ветви его, чашечки его, яблоки его и цветы его выходили из него; ");
INSERT INTO russyn_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","шесть ветвей выходило из боков его: три ветви светильника из одного бока его и три ветви светильника из другого бока его; ");
INSERT INTO russyn_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","три чашечки были наподобие миндального цветка, яблоко и цветы на одной ветви, и три чашечки наподобие миндального цветка, яблоко и цветы на другой ветви: так на всех шести ветвях, выходящих из светильника; ");
INSERT INTO russyn_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","а на стебле светильника было четыре чашечки наподобие миндального цветка с яблоками и цветами; ");
INSERT INTO russyn_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","у шести ветвей, выходящих из него, яблоко под первыми двумя ветвями, и яблоко под вторыми двумя ветвями, и яблоко под третьими двумя ветвями; ");
INSERT INTO russyn_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","яблоки и ветви их выходили из него; весь он был чеканный, цельный, из чистого золота. ");
INSERT INTO russyn_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","И сделал к нему семь лампад, и щипцы к нему и лотки к нему, из чистого золота; ");
INSERT INTO russyn_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","из таланта чистого золота сделал его со всеми принадлежностями его. ");
INSERT INTO russyn_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","И сделал жертвенник курения из дерева ситтим: длина его локоть и ширина его локоть, четырехугольный, вышина его два локтя; из него выходили роги его; ");
INSERT INTO russyn_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","и обложил его чистым золотом, верх его и стороны его кругом, и роги его, и сделал к нему золотой венец вокруг; ");
INSERT INTO russyn_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","под венцом его на двух углах его сделал два кольца золотых; с двух сторон его сделал их, чтобы вкладывать в них шесты для ношения его; ");
INSERT INTO russyn_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","шесты сделал из дерева ситтим и обложил их золотом. ");
INSERT INTO russyn_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","И сделал миро для священного помазания и курение благовонное, чистое, искусством составляющего масти. ");
INSERT INTO russyn_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","И сделал жертвенник всесожжения из дерева ситтим длиною в пять локтей и шириною в пять локтей, четырехугольный, вышиною в три локтя; ");
INSERT INTO russyn_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","и сделал роги на четырех углах его, так что из него выходили роги, и обложил его медью. ");
INSERT INTO russyn_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","И сделал все принадлежности жертвенника: горшки, лопатки, чаши, вилки и угольницы; все принадлежности его сделал из меди. ");
INSERT INTO russyn_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","И сделал для жертвенника решетку, род сетки, из меди, по окраине его внизу до половины его; ");
INSERT INTO russyn_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","и сделал четыре кольца на четырех углах медной решетки для вкладывания шестов. ");
INSERT INTO russyn_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","И сделал шесты из дерева ситтим, и обложил их медью, ");
INSERT INTO russyn_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","и вложил шесты в кольца на боках жертвенника, чтобы носить его посредством их; пустой внутри из досок сделал его. ");
INSERT INTO russyn_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","И сделал умывальник из меди и подножие его из меди с изящными изображениями, украшающими вход скинии собрания. ");
INSERT INTO russyn_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","И сделал двор: с полуденной стороны, к югу, завесы из крученого виссона, длиною во сто локтей; ");
INSERT INTO russyn_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","столбов для них двадцать и подножий к ним двадцать медных; крючки у столбов и связи их из серебра. ");
INSERT INTO russyn_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","И по северной стороне - завесы во сто локтей; столбов для них двадцать и подножий к ним двадцать медных; крючки у столбов и связи их из серебра. ");
INSERT INTO russyn_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","И с западной стороны - завесы в пятьдесят локтей, столбов для них десять и подножий к ним десять; крючки у столбов и связи их из серебра. ");
INSERT INTO russyn_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","И с передней стороны к востоку - завесы в пятьдесят локтей. ");
INSERT INTO russyn_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Для одной стороны ворот двора - завесы в пятнадцать локтей, столбов для них три и подножий к ним три; ");
INSERT INTO russyn_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","и для другой стороны по обеим сторонам ворот двора - завесы в пятнадцать локтей, столбов для них три и подножий к ним три. ");
INSERT INTO russyn_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Все завесы во все стороны двора из крученого виссона, ");
INSERT INTO russyn_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","а подножия у столбов из меди, крючки у столбов и связи их из серебра; верхи же у них обложены серебром, и все столбы двора соединены связями серебряными. ");
INSERT INTO russyn_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Завеса же для ворот двора узорчатой работы из голубой, пурпуровой и червленой шерсти и из крученого виссона, длиною в двадцать локтей, вышиною в пять локтей, по всему протяжению, подобно завесам двора; ");
INSERT INTO russyn_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","и столбов для нее четыре, и подножий к ним четыре медных; крючки у них серебряные, а верхи их обложены серебром, и связи их серебряные. ");
INSERT INTO russyn_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Все колья вокруг скинии и двора медные. ");
INSERT INTO russyn_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Вот исчисление того, что употреблено для скинии откровения, сделанное по повелению Моисея, посредством левитов под надзором Ифамара, сына Ааронова, священника. ");
INSERT INTO russyn_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Делал же все, что повелел Господь Моисею, Веселеил, сын Урии, сына Ора, из колена Иудина, ");
INSERT INTO russyn_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","и с ним Аголиав, сын Ахисамахов, из колена Данова, резчик и искусный ткач и вышиватель по голубой, пурпуровой, червленой и виссонной ткани. ");
INSERT INTO russyn_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Всего золота, употребленного в дело на все принадлежности святилища, золота, принесенного в дар, было двадцать девять талантов и семьсот тридцать сиклей, сиклей священных; ");
INSERT INTO russyn_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","серебра же от исчисленных лиц общества сто талантов и тысяча семьсот семьдесят пять сиклей, сиклей священных; ");
INSERT INTO russyn_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","с шестисот трех тысяч пятисот пятидесяти человек, с каждого поступившего в исчисление, от двадцати лет и выше, по полсиклю с человека, считая на сикль священный. ");
INSERT INTO russyn_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Сто талантов серебра употреблено на вылитие подножий святилища и подножий у завесы; сто подножий из ста талантов, по таланту на подножие; ");
INSERT INTO russyn_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","а из тысячи семисот семидесяти пяти сиклей сделал он крючки у столбов и покрыл верхи их и сделал связи для них. ");
INSERT INTO russyn_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Меди же, принесенной в дар, было семьдесят талантов и две тысячи четыреста сиклей; ");
INSERT INTO russyn_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","из нее сделал он подножия для столбов у входа в скинию свидетельства, и жертвенник медный, и решетку медную для него, и все сосуды жертвенника, ");
INSERT INTO russyn_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","и подножия для столбов всего двора, и подножия для столбов ворот двора, и все колья скинии и все колья вокруг двора. ");
INSERT INTO russyn_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Из голубой же, пурпуровой и червленой шерсти сделали они служебные одежды, для служения во святилище; также сделали священные одежды Аарону, как повелел Господь Моисею. ");
INSERT INTO russyn_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","И сделал ефод из золота, из голубой, пурпуровой и червленой шерсти и из крученого виссона; ");
INSERT INTO russyn_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","и разбили они золото в листы и вытянули нити, чтобы воткать их между голубыми, пурпуровыми, червлеными и виссонными нитями, искусною работою. ");
INSERT INTO russyn_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","И сделали у него нарамники связывающие; на обоих концах своих он был связан. ");
INSERT INTO russyn_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","И пояс ефода, который поверх его, одинаковой с ним работы, сделан был из золота, из голубой, пурпуровой и червленой шерсти и крученого виссона, как повелел Господь Моисею. ");
INSERT INTO russyn_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","И обделали камни ониксовые, вставив их в золотые гнезда и вырезав на них имена сынов Израилевых, как вырезывают на печати; ");
INSERT INTO russyn_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","и положил он их на нарамники ефода, в память сынов Израилевых, как повелел Господь Моисею. ");
INSERT INTO russyn_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","И сделал наперсник искусною работою, такою же работою, как ефод, из золота, из голубой, пурпуровой и червленой шерсти и из крученого виссона; ");
INSERT INTO russyn_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","он был четырехугольный; двойной сделали они наперсник в пядень длиною и в пядень шириною, двойной он был; ");
INSERT INTO russyn_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","и вставили в него в четыре ряда камни. Рядом: рубин, топаз, изумруд,- это первый ряд; ");
INSERT INTO russyn_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","во втором ряду: карбункул, сапфир и алмаз; ");
INSERT INTO russyn_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","в третьем ряду: яхонт, агат и аметист; ");
INSERT INTO russyn_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","в четвертом ряду: хризолит, оникс и яспис; и вставлены они в золотых гнездах. ");
INSERT INTO russyn_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Камней было по числу имен сынов Израилевых: двенадцать было их, по числу имен их, и на каждом из них вырезано было, как на печати, по одному имени, для двенадцати колен. ");
INSERT INTO russyn_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","К наперснику сделали толстые цепочки витою работою из чистого золота; ");
INSERT INTO russyn_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","и сделали два золотых гнезда и два золотых кольца и прикрепили два кольца к двум концам наперсника; ");
INSERT INTO russyn_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","и вдели обе плетеные цепочки из золота в два кольца по концам наперсника, ");
INSERT INTO russyn_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","а два конца двух цепочек прикрепили к двум гнездам и прикрепили их к нарамникам ефода с лицевой стороны его; ");
INSERT INTO russyn_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","еще сделали два кольца золотых и прикрепили к двум другим концам наперсника, на той стороне, которая находится к ефоду внутрь; ");
INSERT INTO russyn_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","и еще сделали два кольца золотых и прикрепили их к двум нарамникам ефода снизу, с лицевой стороны его, у соединения его над поясом ефода; ");
INSERT INTO russyn_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","и прикрепили наперсник кольцами его к кольцам ефода посредством шнура из голубой шерсти, чтобы он был над поясом ефода, и чтобы не отставал наперсник от ефода, как повелел Господь Моисею. ");
INSERT INTO russyn_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","И сделал верхнюю ризу к ефоду, тканую, всю из голубой шерсти, ");
INSERT INTO russyn_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","и среди верхней ризы отверстие, как отверстие у брони, и вокруг него обшивку, чтобы не дралось; ");
INSERT INTO russyn_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","по подолу верхней ризы сделали они яблоки из голубой, пурпуровой и червленой шерсти; ");
INSERT INTO russyn_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","и сделали позвонки из чистого золота и повесили позвонки между яблоками по подолу верхней ризы кругом; ");
INSERT INTO russyn_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","позвонок и яблоко, позвонок и яблоко, по подолу верхней ризы кругом для служения, как повелел Господь Моисею. ");
INSERT INTO russyn_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","И сделали для Аарона и для сыновей его хитоны из виссона, тканые, ");
INSERT INTO russyn_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","и кидар из виссона, и головные повязки из виссона, и нижнее льняное платье из крученого виссона, ");
INSERT INTO russyn_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","и пояс из крученого виссона и из голубой, пурпуровой и червленой шерсти, узорчатой работы, как повелел Господь Моисею. ");
INSERT INTO russyn_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","И сделали полированную дощечку, диадиму святыни, из чистого золота, и начертали на ней письмена, как вырезывают на печати: Святыня Господня; ");
INSERT INTO russyn_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","и прикрепили к ней шнур из голубой шерсти, чтобы привязать ее к кидару сверху, как повелел Господь Моисею. ");
INSERT INTO russyn_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Так кончена была вся работа для скинии собрания; и сделали сыны Израилевы все: как повелел Господь Моисею, так и сделали. ");
INSERT INTO russyn_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","И принесли к Моисею скинию, покров и все принадлежности ее, крючки ее, брусья ее, шесты ее, столбы ее и подножия ее, ");
INSERT INTO russyn_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","покров из кож бараньих красных и покров из кож синих и завесу закрывающую, ");
INSERT INTO russyn_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","ковчег откровения и шесты его, и крышку, ");
INSERT INTO russyn_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","стол со всеми принадлежностями его и хлебы предложения, ");
INSERT INTO russyn_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","светильник из чистого золота, лампады его, лампады расставленные на нем и все принадлежности его, и елей для освящения, ");
INSERT INTO russyn_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","золотой жертвенник и елей помазания, и благовония для курения, и завесу ко входу в скинию, ");
INSERT INTO russyn_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","жертвенник медный и медную решетку к нему, шесты его и все принадлежности его, умывальник и подножие его, ");
INSERT INTO russyn_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","завесы двора, столбы и подножия, завесу к воротам двора, веревки и колья и все вещи, принадлежащие к служению в скинии собрания, ");
INSERT INTO russyn_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","одежды служебные для служения во святилище, священные одежды Аарону священнику и одежды сыновьям его для священнодействия. ");
INSERT INTO russyn_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Как повелел Господь Моисею, так и сделали сыны Израилевы все сии работы. ");
INSERT INTO russyn_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","И увидел Моисей всю работу, и вот они сделали ее: как повелел Господь, так и сделали. И благословил их Моисей. ");
INSERT INTO russyn_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","в первый месяц, в первый день месяца поставь скинию собрания, ");
INSERT INTO russyn_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","и поставь в ней ковчег откровения, и закрой ковчег завесою; ");
INSERT INTO russyn_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","и внеси стол и расставь на нем все вещи его, и внеси светильник и поставь на нем лампады его; ");
INSERT INTO russyn_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","и поставь золотой жертвенник для курения пред ковчегом откровения и повесь завесу у входа в скинию собрания; ");
INSERT INTO russyn_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","и поставь жертвенник всесожжения пред входом в скинию собрания; ");
INSERT INTO russyn_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","и поставь умывальник между скиниею собрания и между жертвенником и влей в него воды; ");
INSERT INTO russyn_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","и поставь двор кругом и повесь завесу в воротах двора. ");
INSERT INTO russyn_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","И возьми елея помазания, и помажь скинию и все, что в ней, и освяти ее и все принадлежности ее, и будет свята; ");
INSERT INTO russyn_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","помажь жертвенник всесожжения и все принадлежности его, и освяти жертвенник, и будет жертвенник святыня великая; ");
INSERT INTO russyn_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","и помажь умывальник и подножие его и освяти его. ");
INSERT INTO russyn_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","И приведи Аарона и сынов его ко входу в скинию собрания и омой их водою, ");
INSERT INTO russyn_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","и облеки Аарона в священные одежды, и помажь его, и освяти его, чтобы он был священником Мне. ");
INSERT INTO russyn_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","И сынов его приведи, и одень их в хитоны, ");
INSERT INTO russyn_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","и помажь их, как помазал ты отца их, чтобы они были священниками Мне, и помазание их посвятит их в вечное священство в роды их. ");
INSERT INTO russyn_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","И сделал Моисей все, как повелел ему Господь, так и сделал. ");
INSERT INTO russyn_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","В первый месяц второго года по исшествии их из Египта, в первый день месяца поставлена скиния. ");
INSERT INTO russyn_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","И поставил Моисей скинию, положил подножия ее, поставил брусья ее, положил шесты и поставил столбы ее, ");
INSERT INTO russyn_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","распростер покров над скиниею, и положил покрышку поверх сего покрова, как повелел Господь Моисею. ");
INSERT INTO russyn_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","И взял и положил откровение в ковчег, и вложил шесты в кольца ковчега, и положил крышку на ковчег сверху; ");
INSERT INTO russyn_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","и внес ковчег в скинию, и повесил завесу, и закрыл ковчег откровения, как повелел Господь Моисею. ");
INSERT INTO russyn_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","И поставил стол в скинии собрания, на северной стороне скинии, вне завесы, ");
INSERT INTO russyn_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","и разложил на нем ряд хлебов пред Господом, как повелел Господь Моисею. ");
INSERT INTO russyn_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","И поставил светильник в скинии собрания против стола, на южной стороне скинии, ");
INSERT INTO russyn_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","и поставил лампады его пред Господом, как повелел Господь Моисею. ");
INSERT INTO russyn_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","И поставил золотой жертвенник в скинии собрания пред завесою ");
INSERT INTO russyn_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","и воскурил на нем благовонное курение, как повелел Господь Моисею. ");
INSERT INTO russyn_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","И повесил завесу при входе в скинию; ");
INSERT INTO russyn_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","и жертвенник всесожжения поставил у входа в скинию собрания и принес на нем всесожжения и приношение хлебное, как повелел Господь Моисею. ");
INSERT INTO russyn_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","И поставил умывальник между скиниею собрания и жертвенником и налил в него воды для омовения, ");
INSERT INTO russyn_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","и омывали из него Моисей и Аарон и сыны его руки свои и ноги свои: ");
INSERT INTO russyn_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","когда они входили в скинию собрания и подходили к жертвеннику служить, тогда омывались из него, как повелел Господь Моисею. ");
INSERT INTO russyn_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","И поставил двор вокруг скинии и жертвенника и повесил завесу в воротах двора. И так окончил Моисей дело. ");
INSERT INTO russyn_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","И покрыло облако скинию собрания, и слава Господня наполнила скинию; ");
INSERT INTO russyn_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","и не мог Моисей войти в скинию собрания, потому что осеняло ее облако, и слава Господня наполняла скинию. ");
INSERT INTO russyn_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Когда поднималось облако от скинии, тогда отправлялись в путь сыны Израилевы во все путешествие свое; ");
INSERT INTO russyn_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","если же не поднималось облако, то и они не отправлялись в путь, доколе оно не поднималось, ");
INSERT INTO russyn_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","ибо облако Господне стояло над скиниею днем, и огонь был ночью в ней пред глазами всего дома Израилева во все путешествие их. ");
INSERT INTO russyn_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","И воззвал Господь к Моисею и сказал ему из скинии собрания, говоря: ");
INSERT INTO russyn_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","объяви сынам Израилевым и скажи им: когда кто из вас хочет принести жертву Господу, то, если из скота, приносите жертву вашу из скота крупного и мелкого. ");
INSERT INTO russyn_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Если жертва его есть всесожжение из крупного скота, пусть принесет ее мужеского пола, без порока; пусть приведет ее к дверям скинии собрания, чтобы приобрести ему благоволение пред Господом; ");
INSERT INTO russyn_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","и возложит руку свою на голову жертвы всесожжения - и приобретет он благоволение, во очищение грехов его; ");
INSERT INTO russyn_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","и заколет тельца пред Господом; сыны же Аароновы, священники, принесут кровь и покропят кровью со всех сторон на жертвенник, который у входа скинии собрания; ");
INSERT INTO russyn_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","и снимет кожу с жертвы всесожжения и рассечет ее на части; ");
INSERT INTO russyn_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","сыны же Аароновы, священники, положат на жертвенник огонь и на огне разложат дрова; ");
INSERT INTO russyn_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","и разложат сыны Аароновы, священники, части, голову и тук на дровах, которые на огне, на жертвеннике; ");
INSERT INTO russyn_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","а внутренности жертвы и ноги ее вымоет он водою, и сожжет священник все на жертвеннике: это всесожжение, жертва, благоухание, приятное Господу. ");
INSERT INTO russyn_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Если жертва всесожжения его Господу из мелкого скота, из овец, или из коз, пусть принесет ее мужеского пола, без порока, и пусть возложит руку на голову ее, ");
INSERT INTO russyn_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","и заколет ее пред Господом на северной стороне жертвенника, и сыны Аароновы, священники, покропят кровью ее на жертвенник со всех сторон; ");
INSERT INTO russyn_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","и рассекут ее на части, отделив голову ее и тук ее, и разложит их священник на дровах, которые на огне, на жертвеннике, ");
INSERT INTO russyn_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","а внутренности и ноги вымоет водою, и принесет священник все и сожжет на жертвеннике: это всесожжение, жертва, благоухание, приятное Господу. ");
INSERT INTO russyn_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Если же из птиц приносит он Господу всесожжение, пусть принесет жертву свою из горлиц, или из молодых голубей; ");
INSERT INTO russyn_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","священник принесет ее к жертвеннику, и свернет ей голову, и сожжет на жертвеннике, а кровь выцедит к стене жертвенника; ");
INSERT INTO russyn_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","зоб ее с перьями ее отнимет и бросит его подле жертвенника на восточную сторону, где пепел; ");
INSERT INTO russyn_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","и надломит ее в крыльях ее, не отделяя их, и сожжет ее священник на жертвеннике, на дровах, которые на огне: это всесожжение, жертва, благоухание, приятное Господу. ");
INSERT INTO russyn_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Если какая душа хочет принести Господу жертву приношения хлебного, пусть принесет пшеничной муки, и вольет на нее елея, и положит на нее ливана, ");
INSERT INTO russyn_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","и принесет ее к сынам Аароновым, священникам, и возьмет полную горсть муки с елеем и со всем ливаном, и сожжет сие священник в память на жертвеннике; это жертва, благоухание, приятное Господу; ");
INSERT INTO russyn_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","а остатки от приношения хлебного Аарону и сынам его: это великая святыня из жертв Господних. ");
INSERT INTO russyn_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Если же приносишь жертву приношения хлебного из печеного в печи, то приноси пшеничные хлебы пресные, смешанные с елеем, и лепешки пресные, помазанные елеем. ");
INSERT INTO russyn_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Если жертва твоя приношение хлебное со сковороды, то это должна быть пшеничная мука, смешанная с елеем, пресная; ");
INSERT INTO russyn_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","разломи ее на куски и влей на нее елея: это приношение хлебное Господу. ");
INSERT INTO russyn_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Если жертва твоя приношение хлебное из горшка, то должно сделать оное из пшеничной муки с елеем, ");
INSERT INTO russyn_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","и принеси приношение, которое из сего составлено, Господу; представь оное священнику, а он принесет его к жертвеннику; ");
INSERT INTO russyn_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","и возьмет священник из сей жертвы часть в память и сожжет на жертвеннике: это жертва, благоухание, приятное Господу; ");
INSERT INTO russyn_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","а остатки приношения хлебного Аарону и сынам его: это великая святыня из жертв Господних. ");
INSERT INTO russyn_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Никакого приношения хлебного, которое приносите Господу, не делайте квасного, ибо ни квасного, ни меду не должны вы сожигать в жертву Господу; ");
INSERT INTO russyn_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","как приношение начатков приносите их Господу, а на жертвенник не должно возносить их в приятное благоухание. ");
INSERT INTO russyn_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Всякое приношение твое хлебное соли солью, и не оставляй жертвы твоей без соли завета Бога твоего: при всяком приношении твоем приноси Господу Богу твоему соль. ");
INSERT INTO russyn_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Если приносишь Господу приношение хлебное из первых плодов, приноси в дар от первых плодов твоих из колосьев, высушенных на огне, растолченные зерна, ");
INSERT INTO russyn_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","и влей на них елея, и положи на них ливана: это приношение хлебное; ");
INSERT INTO russyn_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","и сожжет священник в память часть зерен и елея со всем ливаном: это жертва Господу. ");
INSERT INTO russyn_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Если жертва его жертва мирная, и если он приносит из крупного скота, мужеского или женского пола, пусть принесет ее Господу, не имеющую порока, ");
INSERT INTO russyn_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","и возложит руку свою на голову жертвы своей, и заколет ее у дверей скинии собрания; сыны же Аароновы, священники, покропят кровью на жертвенник со всех сторон; ");
INSERT INTO russyn_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","и принесет он из мирной жертвы в жертву Господу тук, покрывающий внутренности, и весь тук, который на внутренностях, ");
INSERT INTO russyn_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","и обе почки и тук, который на них, который на стегнах, и сальник, который на печени; с почками он отделит это; ");
INSERT INTO russyn_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","и сыны Аароновы сожгут это на жертвеннике вместе со всесожжением, которое на дровах, на огне: это жертва, благоухание, приятное Господу. ");
INSERT INTO russyn_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","А если из мелкого скота приносит он мирную жертву Господу, мужеского или женского пола, пусть принесет ее, не имеющую порока. ");
INSERT INTO russyn_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Если из овец приносит он жертву свою, пусть представит ее пред Господа, ");
INSERT INTO russyn_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","и возложит руку свою на голову жертвы своей, и заколет ее пред скиниею собрания, и сыны Аароновы покропят кровью ее на жертвенник со всех сторон; ");
INSERT INTO russyn_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","и пусть принесет из мирной жертвы в жертву Господу тук ее, весь курдюк, отрезав его по самую хребтовую кость, и тук, покрывающий внутренности, и весь тук, который на внутренностях, ");
INSERT INTO russyn_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","и обе почки и тук, который на них, который на стегнах, и сальник, который на печени; с почками он отделит это; ");
INSERT INTO russyn_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","священник сожжет это на жертвеннике; это пища огня жертва Господу. ");
INSERT INTO russyn_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","А если он приносит жертву из коз, пусть представит ее пред Господа, ");
INSERT INTO russyn_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","и возложит руку свою на голову ее, и заколет ее перед скиниею собрания, и покропят сыны Аароновы кровью ее на жертвенник со всех сторон; ");
INSERT INTO russyn_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","и принесет из нее в приношение, в жертву Господу тук, покрывающий внутренности, и весь тук, который на внутренностях, ");
INSERT INTO russyn_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","и обе почки и тук, который на них, который на стегнах, и сальник, который на печени; с почками он отделит это ");
INSERT INTO russyn_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","и сожжет их священник на жертвеннике: это пища огня - приятное благоухание Господу; весь тук Господу. ");
INSERT INTO russyn_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Это постановление вечное в роды ваши, во всех жилищах ваших; никакого тука и никакой крови не ешьте. ");
INSERT INTO russyn_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","скажи сынам Израилевым: если какая душа согрешит по ошибке против каких-либо заповедей Господних и сделает что-нибудь, чего не должно делать; ");
INSERT INTO russyn_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","если священник помазанный согрешит и сделает виновным народ,- то за грех свой, которым согрешил, пусть представит из крупного скота тельца, без порока, Господу в жертву о грехе, ");
INSERT INTO russyn_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","и приведет тельца к дверям скинии собрания пред Господа, и возложит руки свои на голову тельца, и заколет тельца пред Господом; ");
INSERT INTO russyn_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","и возьмет священник помазанный, посвященный совершенным посвящением, крови тельца и внесет ее в скинию собрания, ");
INSERT INTO russyn_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","и омочит священник перст свой в кровь и покропит кровью семь раз пред Господом пред завесою святилища; ");
INSERT INTO russyn_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","и возложит священник крови тельца пред Господом на роги жертвенника благовонных курений, который в скинии собрания, а остальную кровь тельца выльет к подножию жертвенника всесожжений, который у входа скинии собрания; ");
INSERT INTO russyn_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","и вынет из тельца за грех весь тук его, тук, покрывающий внутренности, и весь тук, который на внутренностях, ");
INSERT INTO russyn_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","и обе почки и тук, который на них, который на стегнах, и сальник на печени; с почками отделит он это, ");
INSERT INTO russyn_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","как отделяется из тельца жертвы мирной; и сожжет их священник на жертвеннике всесожжения; ");
INSERT INTO russyn_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","а кожу тельца и все мясо его с головою и с ногами его, и внутренности его и нечистоту его, ");
INSERT INTO russyn_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","всего тельца пусть вынесет вне стана на чистое место, где высыпается пепел, и сожжет его огнем на дровах; где высыпается пепел, там пусть сожжен будет. ");
INSERT INTO russyn_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Если же все общество Израилево согрешит по ошибке и скрыто будет дело от глаз собрания, и сделает что-нибудь против заповедей Господних, чего не надлежало делать, и будет виновно, ");
INSERT INTO russyn_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","то, когда узнан будет грех, которым они согрешили, пусть от всего общества представят они из крупного скота тельца в жертву за грех и приведут его пред скинию собрания; ");
INSERT INTO russyn_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","и возложат старейшины общества руки свои на голову тельца пред Господом и заколют тельца пред Господом. ");
INSERT INTO russyn_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","И внесет священник помазанный крови тельца в скинию собрания, ");
INSERT INTO russyn_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","и омочит священник перст свой в кровь тельца и покропит семь раз пред Господом пред завесою святилища, ");
INSERT INTO russyn_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","и возложит крови на роги жертвенника благовонных курений, который пред лицем Господним в скинии собрания, а остальную кровь выльет к подножию жертвенника всесожжений, который у входа скинии собрания; ");
INSERT INTO russyn_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","и весь тук его вынет из него и сожжет на жертвеннике; ");
INSERT INTO russyn_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","и сделает с тельцом то, что делается с тельцом за грех; так должен сделать с ним, и так очистит их священник, и прощено будет им; ");
INSERT INTO russyn_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","и вынесет тельца вне стана, и сожжет его так, как сожег прежнего тельца. Это жертва за грех общества. ");
INSERT INTO russyn_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","А если согрешит начальник, и сделает по ошибке что-нибудь против заповедей Господа, Бога своего, чего не надлежало делать, и будет виновен, ");
INSERT INTO russyn_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","то, когда узнан будет им грех, которым он согрешил, пусть приведет он в жертву козла без порока, ");
INSERT INTO russyn_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","и возложит руку свою на голову козла, и заколет его на месте, где заколаются всесожжения пред Господом: это жертва за грех; ");
INSERT INTO russyn_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","и возьмет священник перстом своим крови от жертвы за грех и возложит на роги жертвенника всесожжения, а остальную кровь его выльет к подножию жертвенника всесожжения; ");
INSERT INTO russyn_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","и весь тук его сожжет на жертвеннике, подобно как тук жертвы мирной, и так очистит его священник от греха его, и прощено будет ему. ");
INSERT INTO russyn_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Если же кто из народа земли согрешит по ошибке и сделает что-нибудь против заповедей Господних, чего не надлежало делать, и виновен будет, ");
INSERT INTO russyn_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","то, когда узнан будет им грех, которым он согрешил, пусть приведет он в жертву козу без порока за грех свой, которым он согрешил, ");
INSERT INTO russyn_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","и возложит руку свою на голову жертвы за грех, и заколют козу в жертву за грех на месте, где заколают жертву всесожжения; ");
INSERT INTO russyn_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","и возьмет священник крови ее перстом своим, и возложит на роги жертвенника всесожжения, а остальную кровь ее выльет к подножию жертвенника; ");
INSERT INTO russyn_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","и весь тук ее отделит, подобно как отделяется тук из жертвы мирной, и сожжет его священник на жертвеннике в приятное благоухание Господу; и так очистит его священник, и прощено будет ему. ");
INSERT INTO russyn_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","А если из стада овец захочет он принести жертву за грех, пусть принесет женского пола, без порока, ");
INSERT INTO russyn_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","и возложит руку свою на голову жертвы за грех, и заколет ее в жертву за грех на том месте, где заколают жертву всесожжения; ");
INSERT INTO russyn_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","и возьмет священник перстом своим крови от сей жертвы за грех и возложит на роги жертвенника всесожжения, а остальную кровь ее выльет к подножию жертвенника; ");
INSERT INTO russyn_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","и весь тук ее отделит, как отделяется тук овцы из жертвы мирной, и сожжет сие священник на жертвеннике в жертву Господу; и так очистит его священник от греха, которым он согрешил, и прощено будет ему. ");
INSERT INTO russyn_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Если кто согрешит тем, что слышал голос проклятия и был свидетелем, или видел, или знал, но не объявил, то он понесет на себе грех. ");
INSERT INTO russyn_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Или если прикоснется к чему-нибудь нечистому, или к трупу зверя нечистого, или к трупу скота нечистого, или к трупу гада нечистого, но не знал того, то он нечист и виновен. ");
INSERT INTO russyn_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Или если прикоснется к нечистоте человеческой, какая бы то ни была нечистота, от которой оскверняются, и он не знал того, но после узнает, то он виновен. ");
INSERT INTO russyn_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Или если кто безрассудно устами своими поклянется сделать что-нибудь худое или доброе, какое бы то ни было дело, в котором люди безрассудно клянутся, и он не знал того, но после узнает, то он виновен в том. ");
INSERT INTO russyn_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Если он виновен в чем-нибудь из сих, и исповедается, в чем он согрешил, ");
INSERT INTO russyn_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","то пусть принесет Господу за грех свой, которым он согрешил, жертву повинности из мелкого скота, овцу или козу, за грех, и очистит его священник от греха его. ");
INSERT INTO russyn_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Если же он не в состоянии принести овцы, то в повинность за грех свой пусть принесет Господу двух горлиц или двух молодых голубей, одного в жертву за грех, а другого во всесожжение; ");
INSERT INTO russyn_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","пусть принесет их к священнику, и священник представит прежде ту из сих птиц, которая за грех, и надломит голову ее от шеи ее, но не отделит; ");
INSERT INTO russyn_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","и покропит кровью сей жертвы за грех на стену жертвенника, а остальную кровь выцедит к подножию жертвенника: это жертва за грех; ");
INSERT INTO russyn_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","а другую употребит во всесожжение по установлению; и так очистит его священник от греха его, которым он согрешил, и прощено будет ему. ");
INSERT INTO russyn_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Если же он не в состоянии принести двух горлиц или двух молодых голубей, пусть принесет за то, что согрешил, десятую часть ефы пшеничной муки в жертву за грех; пусть не льет на нее елея, и ливана пусть не кладет на нее, ибо это жертва за грех; ");
INSERT INTO russyn_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","и принесет ее к священнику, а священник возьмет из нее полную горсть в память и сожжет на жертвеннике в жертву Господу: это жертва за грех; ");
INSERT INTO russyn_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","и так очистит его священник от греха его, которым он согрешил в котором-нибудь из оных случаев, и прощено будет ему; остаток же принадлежит священнику, как приношение хлебное. ");
INSERT INTO russyn_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","если кто сделает преступление и по ошибке согрешит против посвященного Господу, пусть за вину свою принесет Господу из стада овец овна без порока, по твоей оценке, серебряными сиклями по сиклю священному, в жертву повинности; ");
INSERT INTO russyn_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","за ту святыню, против которой он согрешил, пусть воздаст и прибавит к тому пятую долю, и отдаст сие священнику, и священник очистит его овном жертвы повинности, и прощено будет ему. ");
INSERT INTO russyn_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Если кто согрешит и сделает что-нибудь против заповедей Господних, чего не надлежало делать, и по неведению сделается виновным и понесет на себе грех, ");
INSERT INTO russyn_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","пусть принесет к священнику в жертву повинности овна без порока, по оценке твоей, и загладит священник проступок его, в чем он преступил по неведению, и прощено будет ему. ");
INSERT INTO russyn_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Это жертва повинности, которою он провинился пред Господом. ");
INSERT INTO russyn_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","если кто согрешит и сделает преступление пред Господом и запрется пред ближним своим в том, что ему поручено, или у него положено, или им похищено, или обманет ближнего своего, ");
INSERT INTO russyn_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","или найдет потерянное и запрется в том, и поклянется ложно в чем-нибудь, что люди делают и тем грешат, ");
INSERT INTO russyn_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","то, согрешив и сделавшись виновным, он должен возвратить похищенное, что похитил, или отнятое, что отнял, или порученное, что ему поручено, или потерянное, что он нашел; ");
INSERT INTO russyn_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","или если он в чем поклялся ложно, то должен отдать сполна, и приложить к тому пятую долю и отдать тому, кому принадлежит, в день приношения жертвы повинности; ");
INSERT INTO russyn_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","и за вину свою пусть принесет Господу к священнику в жертву повинности из стада овец овна без порока, по оценке твоей; ");
INSERT INTO russyn_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","и очистит его священник пред Господом, и прощено будет ему, что бы он ни сделал, все, в чем он сделался виновным. ");
INSERT INTO russyn_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","заповедай Аарону и сынам его: вот закон всесожжения: всесожжение пусть остается на месте сожигания на жертвеннике всю ночь до утра, и огонь жертвенника пусть горит на нем и не угасает; ");
INSERT INTO russyn_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","и пусть священник оденется в льняную одежду свою, и наденет на тело свое льняное нижнее платье, и снимет пепел от всесожжения, которое сжег огонь на жертвеннике, и положит его подле жертвенника; ");
INSERT INTO russyn_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","и пусть снимет с себя одежды свои, и наденет другие одежды, и вынесет пепел вне стана на чистое место; ");
INSERT INTO russyn_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","а огонь на жертвеннике пусть горит и не угасает; и пусть священник зажигает на нем дрова каждое утро, и раскладывает на нем всесожжение, и сожигает на нем тук мирной жертвы; ");
INSERT INTO russyn_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","огонь непрестанно пусть горит на жертвеннике и не угасает. ");
INSERT INTO russyn_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Вот закон о приношении хлебном: священники сыны Аароновы должны приносить его пред Господа к жертвеннику; ");
INSERT INTO russyn_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","и пусть возьмет священник горстью своею из приношения хлебного и пшеничной муки и елея и весь ливан, который на жертве, и сожжет на жертвеннике: это приятное благоухание, в память пред Господом; ");
INSERT INTO russyn_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","а остальное из него пусть едят Аарон и сыны его; пресным должно есть его на святом месте, на дворе скинии собрания пусть едят его; ");
INSERT INTO russyn_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","не должно печь его квасным. Сие даю Я им в долю из жертв Моих. Это великая святыня, подобно как жертва за грех и жертва повинности. ");
INSERT INTO russyn_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Все потомки Аароновы мужеского пола могут есть ее. Это вечный участок в роды ваши из жертв Господних. Все, прикасающееся к ним, освятится. ");
INSERT INTO russyn_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","вот приношение от Аарона и сынов его, которое принесут они Господу в день помазания его: десятая часть ефы пшеничной муки в жертву постоянную, половина сего для утра и половина для вечера; ");
INSERT INTO russyn_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","на сковороде в елее она должна быть приготовлена; напитанную елеем приноси ее в кусках, как разламывается в куски приношение хлебное; приноси ее в приятное благоухание Господу; ");
INSERT INTO russyn_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","и священник, помазанный на место его из сынов его, должен совершать сие: это вечный устав Господа. Вся она должна быть сожжена; ");
INSERT INTO russyn_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","и всякое хлебное приношение от священника все да будет сожигаемо, а не съедаемо. ");
INSERT INTO russyn_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","скажи Аарону и сынам его: вот закон о жертве за грех: жертва за грех должна быть заколаема пред Господом на том месте, где заколается всесожжение; это великая святыня; ");
INSERT INTO russyn_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","священник, совершающий жертву за грех, должен есть ее; она должна быть съедаема на святом месте, на дворе скинии собрания; ");
INSERT INTO russyn_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","все, что прикоснется к мясу ее, освятится; и если кровью ее обрызгана будет одежда, то обрызганное омой на святом месте; ");
INSERT INTO russyn_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","глиняный сосуд, в котором она варилась, должно разбить; если же она варилась в медном сосуде, то должно его вычистить и вымыть водою; ");
INSERT INTO russyn_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","весь мужеский пол священнического рода может есть ее: это великая святыня у Господа; ");
INSERT INTO russyn_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","а всякая жертва за грех, от которой кровь вносится в скинию собрания для очищения во святилище, не должна быть съедаема; ее должно сожигать на огне. ");
INSERT INTO russyn_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Вот закон о жертве повинности: это великая святыня; ");
INSERT INTO russyn_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","жертву повинности должно заколать на том месте, где заколается всесожжение, и кровью ее кропить на жертвенник со всех сторон; ");
INSERT INTO russyn_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","приносящий должен представить из нее весь тук, курдюк и тук, покрывающий внутренности, ");
INSERT INTO russyn_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","и обе почки и тук, который на них, который на стегнах, и сальник, который на печени; с почками пусть он отделит сие; ");
INSERT INTO russyn_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","и сожжет сие священник на жертвеннике в жертву Господу: это жертва повинности. ");
INSERT INTO russyn_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Весь мужеский пол священнического рода может есть ее; на святом месте должно есть ее: это великая святыня. ");
INSERT INTO russyn_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Как о жертве за грех, так и о жертве повинности закон один: она принадлежит священнику, который очищает посредством ее. ");
INSERT INTO russyn_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","И когда священник приносит чью-нибудь жертву всесожжения, кожа от жертвы всесожжения, которое он приносит, принадлежит священнику; ");
INSERT INTO russyn_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","и всякое приношение хлебное, которое печено в печи, и всякое приготовленное в горшке или на сковороде, принадлежит священнику, приносящему его; ");
INSERT INTO russyn_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","и всякое приношение хлебное, смешанное с елеем и сухое, принадлежит всем сынам Аароновым, как одному, так и другому. ");
INSERT INTO russyn_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Вот закон о жертве мирной, которую приносят Господу: ");
INSERT INTO russyn_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","если кто в благодарность приносит ее, то при жертве благодарности он должен принести пресные хлебы, смешанные с елеем, и пресные лепешки, помазанные елеем, и пшеничную муку, напитанную елеем, хлебы, смешанные с елеем; ");
INSERT INTO russyn_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","кроме лепешек пусть он приносит в приношение свое квасный хлеб, при мирной жертве благодарной; ");
INSERT INTO russyn_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","одно что-нибудь из всего приношения своего пусть принесет он в возношение Господу: это принадлежит священнику, кропящему кровью мирной жертвы; ");
INSERT INTO russyn_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","мясо мирной жертвы благодарности должно съесть в день приношения ее, не должно оставлять от него до утра. ");
INSERT INTO russyn_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Если же кто приносит жертву по обету, или от усердия, то жертву его должно есть в день приношения, и на другой день оставшееся от нее есть можно, ");
INSERT INTO russyn_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","а оставшееся от жертвенного мяса к третьему дню должно сжечь на огне; ");
INSERT INTO russyn_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","если же будут есть мясо мирной жертвы на третий день, то она не будет благоприятна; кто ее принесет, тому ни во что не вменится: это осквернение, и кто будет есть ее, тот понесет на себе грех; ");
INSERT INTO russyn_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","мяса сего, если оно прикоснется к чему-либо нечистому, не должно есть, но должно сжечь его на огне; а мясо чистое может есть всякий чистый; ");
INSERT INTO russyn_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","если же какая душа, имея на себе нечистоту, будет есть мясо мирной жертвы Господней, то истребится душа та из народа своего; ");
INSERT INTO russyn_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","и если какая душа, прикоснувшись к чему-нибудь нечистому, к нечистоте человеческой, или к нечистому скоту, или какому-нибудь нечистому гаду, будет есть мясо мирной жертвы Господней, то истребится душа та из народа своего. ");
INSERT INTO russyn_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","скажи сынам Израилевым: никакого тука ни из вола, ни из овцы, ни из козла не ешьте. ");
INSERT INTO russyn_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Тук из мертвого и тук из растерзанного зверем можно употреблять на всякое дело; а есть не ешьте его; ");
INSERT INTO russyn_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","ибо, кто будет есть тук из скота, который приносится в жертву Господу, истребится душа та из народа своего; ");
INSERT INTO russyn_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","и никакой крови не ешьте во всех жилищах ваших ни из птиц, ни из скота; ");
INSERT INTO russyn_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","а кто будет есть какую-нибудь кровь, истребится душа та из народа своего. ");
INSERT INTO russyn_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","скажи сынам Израилевым: кто представляет мирную жертву свою Господу, тот из мирной жертвы часть должен принести в приношение Господу; ");
INSERT INTO russyn_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","своими руками должен он принести в жертву Господу: тук с грудью должен он принести и сальник на печени, потрясая грудь пред лицем Господним; ");
INSERT INTO russyn_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","тук сожжет священник на жертвеннике, а грудь принадлежит Аарону и сынам его; ");
INSERT INTO russyn_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","и правое плечо, как возношение, из мирных жертв ваших отдавайте священнику: ");
INSERT INTO russyn_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","кто из сынов Аароновых приносит кровь из мирной жертвы и тук, тому и правое плечо на долю; ");
INSERT INTO russyn_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","ибо Я беру от сынов Израилевых из мирных жертв их грудь потрясания и плечо возношения, и отдаю их Аарону священнику и сынам его в вечный участок от сынов Израилевых. ");
INSERT INTO russyn_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Вот участок Аарону и участок сынам его из жертв Господних со дня, когда они предстанут пред Господа для священнодействия, ");
INSERT INTO russyn_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","который повелел Господь давать им со дня помазания их от сынов Израилевых. Это вечное постановление в роды их. ");
INSERT INTO russyn_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Вот закон о всесожжении, о приношении хлебном, о жертве за грех, о жертве повинности, о жертве посвящения и о жертве мирной, ");
INSERT INTO russyn_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","который дал Господь Моисею на горе Синае, когда повелел сынам Израилевым, в пустыне Синайской, приносить Господу приношения их. ");
INSERT INTO russyn_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","возьми Аарона и сынов его с ним, и одежды и елей помазания, и тельца для жертвы за грех и двух овнов, и корзину опресноков, ");
INSERT INTO russyn_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","и собери все общество ко входу скинии собрания. ");
INSERT INTO russyn_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Моисей сделал так, как повелел ему Господь, и собралось общество ко входу скинии собрания. ");
INSERT INTO russyn_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","И сказал Моисей к обществу: вот что повелел Господь сделать. ");
INSERT INTO russyn_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","И привел Моисей Аарона и сынов его и омыл их водою; ");
INSERT INTO russyn_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","и возложил на него хитон, и опоясал его поясом, и надел на него верхнюю ризу, и возложил на него ефод, и опоясал его поясом ефода и прикрепил им ефод на нем, ");
INSERT INTO russyn_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","и возложил на него наперсник, и на наперсник положил урим и туммим, ");
INSERT INTO russyn_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","и возложил на голову его кидар, а на кидар с передней стороны его возложил полированную дощечку, диадиму святыни, как повелел Господь Моисею. ");
INSERT INTO russyn_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","И взял Моисей елей помазания, и помазал скинию и все, что в ней, и освятил это; ");
INSERT INTO russyn_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","и покропил им на жертвенник семь раз, и помазал жертвенник и все принадлежности его и умывальницу и подножие ее, чтобы освятить их; ");
INSERT INTO russyn_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","и возлил Моисей елей помазания на голову Аарона и помазал его, чтоб освятить его. ");
INSERT INTO russyn_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","И привел Моисей сынов Аароновых, и одел их в хитоны, и опоясал их поясом, и возложил на них кидары, как повелел Господь Моисею. ");
INSERT INTO russyn_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","И привел Моисей тельца для жертвы за грех, и Аарон и сыны его возложили руки свои на голову тельца за грех; ");
INSERT INTO russyn_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","и заколол его Моисей и взял крови, и перстом своим возложил на роги жертвенника со всех сторон, и очистил жертвенник, а остальную кровь вылил к подножию жертвенника, и освятил его, чтобы сделать его чистым. ");
INSERT INTO russyn_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","И взял Моисей весь тук, который на внутренностях, и сальник на печени, и обе почки и тук их, и сжег Моисей на жертвеннике; ");
INSERT INTO russyn_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","а тельца и кожу его, и мясо его, и нечистоту его сжег на огне вне стана, как повелел Господь Моисею. ");
INSERT INTO russyn_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","И привел Моисей овна для всесожжения, и возложили Аарон и сыны его руки свои на голову овна; ");
INSERT INTO russyn_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","и заколол его Моисей и покропил кровью на жертвенник со всех сторон; ");
INSERT INTO russyn_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","и рассек овна на части, и сжег Моисей голову и части и тук, ");
INSERT INTO russyn_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","а внутренности и ноги вымыл водою, и сжег Моисей всего овна на жертвеннике: это всесожжение в приятное благоухание, это жертва Господу, как повелел Господь Моисею. ");
INSERT INTO russyn_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","И привел Моисей другого овна, овна посвящения, и возложили Аарон и сыны его руки свои на голову овна; ");
INSERT INTO russyn_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","и заколол его Моисей, и взял крови его, и возложил на край правого уха Ааронова и на большой палец правой руки его и на большой палец правой ноги его. ");
INSERT INTO russyn_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","И привел Моисей сынов Аароновых, и возложил крови на край правого уха их и на большой палец правой руки их и на большой палец правой ноги их, и покропил Моисей кровью на жертвенник со всех сторон. ");
INSERT INTO russyn_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","И взял Моисей тук и курдюк и весь тук, который на внутренностях, и сальник на печени, и обе почки и тук их и правое плечо; ");
INSERT INTO russyn_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","и из корзины с опресноками, которая пред Господом, взял один опреснок и один хлеб с елеем и одну лепешку, и возложил на тук и на правое плечо; ");
INSERT INTO russyn_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","и положил все это на руки Аарону и на руки сынам его, и принес это, потрясая пред лицем Господним; ");
INSERT INTO russyn_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","и взял это Моисей с рук их и сжег на жертвеннике со всесожжением: это жертва посвящения в приятное благоухание, это жертва Господу. ");
INSERT INTO russyn_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","И взял Моисей грудь и принес ее, потрясая пред лицем Господним: это была доля Моисеева от овна посвящения, как повелел Господь Моисею. ");
INSERT INTO russyn_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","И взял Моисей елея помазания и крови, которая на жертвеннике, и покропил Аарона и одежды его, и сынов его и одежды сынов его с ним; и так освятил Аарона и одежды его, и сынов его и одежды сынов его с ним. ");
INSERT INTO russyn_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","И сказал Моисей Аарону и сынам его: сварите мясо у входа скинии собрания и там ешьте его с хлебом, который в корзине посвящения, как мне повелено и сказано: Аарон и сыны его должны есть его; ");
INSERT INTO russyn_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","а остатки мяса и хлеба сожгите на огне. ");
INSERT INTO russyn_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Семь дней не отходите от дверей скинии собрания, пока не исполнятся дни посвящения вашего, ибо семь дней должно совершаться посвящение ваше; ");
INSERT INTO russyn_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","как сегодня было сделано, так повелел Господь делать для очищения вас; ");
INSERT INTO russyn_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","у входа скинии собрания будьте день и ночь в продолжение семи дней и будьте на страже у Господа, чтобы не умереть, ибо так мне повелено от Господа Бога. ");
INSERT INTO russyn_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","И исполнил Аарон и сыны его все, что повелел Господь чрез Моисея. ");
INSERT INTO russyn_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","В восьмой день призвал Моисей Аарона и сынов его и старейшин Израилевых ");
INSERT INTO russyn_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","и сказал Аарону: возьми себе из волов тельца в жертву за грех и овна во всесожжение, обоих без порока, и представь пред лице Господне; ");
INSERT INTO russyn_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","и сынам Израилевым скажи: возьмите козла в жертву за грех, и овна, и тельца, и агнца, однолетних, без порока, во всесожжение, ");
INSERT INTO russyn_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","и вола и овна в жертву мирную, чтобы совершить жертвоприношение пред лицем Господним, и приношение хлебное, смешанное с елеем, ибо сегодня Господь явится вам. ");
INSERT INTO russyn_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","И принесли то, что приказал Моисей, пред скинию собрания, и пришло все общество и стало пред лицем Господним. ");
INSERT INTO russyn_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","И сказал Моисей: вот что повелел Господь сделать, и явится вам слава Господня. ");
INSERT INTO russyn_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","И сказал Моисей Аарону: приступи к жертвеннику и соверши жертву твою о грехе и всесожжение твое, и очисти себя и народ, и сделай приношение от народа, и очисти их, как повелел Господь. ");
INSERT INTO russyn_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","И приступил Аарон к жертвеннику и заколол тельца, который за него, в жертву за грех: ");
INSERT INTO russyn_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","сыны Аарона поднесли ему кровь, и он омочил перст свой в крови и возложил на роги жертвенника, а остальную кровь вылил к подножию жертвенника, ");
INSERT INTO russyn_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","а тук и почки и сальник на печени от жертвы за грех сжег на жертвеннике, как повелел Господь Моисею; ");
INSERT INTO russyn_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","мясо же и кожу сжег на огне вне стана. ");
INSERT INTO russyn_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","И заколол всесожжение, и сыны Аарона поднесли ему кровь; он покропил ею на жертвенник со всех сторон; ");
INSERT INTO russyn_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","и принесли ему всесожжение в кусках и голову, и он сжег на жертвеннике, ");
INSERT INTO russyn_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","а внутренности и ноги омыл и сжег со всесожжением на жертвеннике. ");
INSERT INTO russyn_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","И принес приношение от народа, и взял от народа козла за грех, и заколол его, и принес его в жертву за грех, как и прежнего. ");
INSERT INTO russyn_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","И принес всесожжение и совершил его по уставу. ");
INSERT INTO russyn_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","И принес приношение хлебное, и наполнил им руки свои, и сжег на жертвеннике сверх утреннего всесожжения. ");
INSERT INTO russyn_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","И заколол вола и овна, которые от народа, в жертву мирную; и сыны Аарона поднесли ему кровь, и он покропил ею на жертвенник со всех сторон; ");
INSERT INTO russyn_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","поднесли и тук из вола, и из овна курдюк, и тук покрывающий внутренности, почки и сальник на печени, ");
INSERT INTO russyn_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","и положили тук на грудь, и он сжег тук на жертвеннике; ");
INSERT INTO russyn_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","грудь же и правое плечо принес Аарон, потрясая пред лицем Господним, как повелел Моисей. ");
INSERT INTO russyn_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","И поднял Аарон руки свои, обратившись к народу, и благословил его, и сошел, совершив жертву за грех, всесожжение и жертву мирную. ");
INSERT INTO russyn_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","И вошли Моисей и Аарон в скинию собрания, и вышли, и благословили народ. И явилась слава Господня всему народу: ");
INSERT INTO russyn_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","и вышел огонь от Господа и сжег на жертвеннике всесожжение и тук; и видел весь народ, и воскликнул от радости, и пал на лице свое. ");
INSERT INTO russyn_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Надав и Авиуд, сыны Аароновы, взяли каждый свою кадильницу, и положили в них огня, и вложили в него курений, и принесли пред Господа огонь чуждый, которого Он не велел им; ");
INSERT INTO russyn_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","и вышел огонь от Господа и сжег их, и умерли они пред лицем Господним. ");
INSERT INTO russyn_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","И сказал Моисей Аарону: вот о чем говорил Господь, когда сказал: в приближающихся ко Мне освящусь и пред всем народом прославлюсь. Аарон молчал. ");
INSERT INTO russyn_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","И позвал Моисей Мисаила и Елцафана, сынов Узиила, дяди Ааронова, и сказал им: пойдите, вынесите братьев ваших из святилища за стан. ");
INSERT INTO russyn_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","И пошли и вынесли их в хитонах их за стан, как сказал Моисей. ");
INSERT INTO russyn_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Аарону же и Елеазару и Ифамару, сынам его, Моисей сказал: голов ваших не обнажайте и одежд ваших не раздирайте, чтобы вам не умереть и не навести гнева на все общество; но братья ваши, весь дом Израилев, могут плакать о сожженных, которых сожег Господь, ");
INSERT INTO russyn_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","и из дверей скинии собрания не выходите, чтобы не умереть вам, ибо на вас елей помазания Господня. И сделали по слову Моисея. ");
INSERT INTO russyn_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","И сказал Господь Аарону, говоря: ");
INSERT INTO russyn_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","вина и крепких напитков не пей ты и сыны твои с тобою, когда входите в скинию собрания, или приступаете к жертвеннику, чтобы не умереть. Это вечное постановление в роды ваши, ");
INSERT INTO russyn_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","чтобы вы могли отличать священное от несвященного и нечистое от чистого, ");
INSERT INTO russyn_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","и научать сынов Израилевых всем уставам, которые изрек им Господь чрез Моисея. ");
INSERT INTO russyn_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","И сказал Моисей Аарону и Елеазару и Ифамару, оставшимся сынам его: возьмите приношение хлебное, оставшееся от жертв Господних, и ешьте его пресное у жертвенника, ибо это великая святыня; ");
INSERT INTO russyn_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","и ешьте его на святом месте, ибо это участок твой и участок сынов твоих из жертв Господних: так мне повелено от Господа; ");
INSERT INTO russyn_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","и грудь потрясания и плечо возношения ешьте на чистом месте, ты и сыновья твои и дочери твои с тобою, ибо это дано в участок тебе и в участок сынам твоим из мирных жертв сынов Израилевых; ");
INSERT INTO russyn_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","плечо возношения и грудь потрясания должны они приносить с жертвами тука, потрясая пред лицем Господним, и да будет это вечным участком тебе и сыновьям твоим и дочерям твоим с тобою, как повелел Господь Моисею. ");
INSERT INTO russyn_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","И козла жертвы за грех искал Моисей, и вот, он сожжен. И разгневался Моисей на Елеазара и Ифамара, оставшихся сынов Аароновых, и сказал: ");
INSERT INTO russyn_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","почему вы не ели жертвы за грех на святом месте? ибо она святыня великая, и она дана вам, чтобы снимать грехи с общества и очищать их пред Господом; ");
INSERT INTO russyn_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","вот, кровь ее не внесена внутрь святилища, а вы должны были есть ее на святом месте, как повелено мне. ");
INSERT INTO russyn_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Аарон сказал Моисею: вот, сегодня принесли они жертву свою за грех и всесожжение свое пред Господом, и это случилось со мною; если я сегодня съем жертву за грех, будет ли это угодно Господу? ");
INSERT INTO russyn_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","И услышал Моисей и одобрил. ");
INSERT INTO russyn_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","И сказал Господь Моисею и Аарону, говоря им: ");
INSERT INTO russyn_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","скажите сынам Израилевым: вот животные, которые можно вам есть из всего скота на земле: ");
INSERT INTO russyn_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","всякий скот, у которого раздвоены копыта и на копытах глубокий разрез, и который жует жвачку, ешьте; ");
INSERT INTO russyn_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","только сих не ешьте из жующих жвачку и имеющих раздвоенные копыта: верблюда, потому что он жует жвачку, но копыта у него не раздвоены, нечист он для вас; ");
INSERT INTO russyn_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","и тушканчика, потому что он жует жвачку, но копыта у него не раздвоены, нечист он для вас, ");
INSERT INTO russyn_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","и зайца, потому что он жует жвачку, но копыта у него не раздвоены, нечист он для вас; ");
INSERT INTO russyn_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","и свиньи, потому что копыта у нее раздвоены и на копытах разрез глубокий, но она не жует жвачки, нечиста она для вас; ");
INSERT INTO russyn_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","мяса их не ешьте и к трупам их не прикасайтесь; нечисты они для вас. ");
INSERT INTO russyn_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Из всех животных, которые в воде, ешьте сих: у которых есть перья и чешуя в воде, в морях ли, или реках, тех ешьте; ");
INSERT INTO russyn_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","а все те, у которых нет перьев и чешуи, в морях ли, или реках, из всех плавающих в водах и из всего живущего в водах, скверны для вас; ");
INSERT INTO russyn_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","они должны быть скверны для вас: мяса их не ешьте и трупов их гнушайтесь; ");
INSERT INTO russyn_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","все животные, у которых нет перьев и чешуи в воде, скверны для вас. ");
INSERT INTO russyn_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Из птиц же гнушайтесь сих, скверны они: орла, грифа и морского орла, ");
INSERT INTO russyn_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","коршуна и сокола с породою его, ");
INSERT INTO russyn_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","всякого ворона с породою его, ");
INSERT INTO russyn_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","страуса, совы, чайки и ястреба с породою его, ");
INSERT INTO russyn_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","филина, рыболова и ибиса, ");
INSERT INTO russyn_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","лебедя, пеликана и сипа, ");
INSERT INTO russyn_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","цапли, зуя с породою его, удода и нетопыря. ");
INSERT INTO russyn_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Все животные пресмыкающиеся, крылатые, ходящие на четырех ногах, скверны для нас; ");
INSERT INTO russyn_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","из всех пресмыкающихся, крылатых, ходящих на четырех ногах, тех только ешьте, у которых есть голени выше ног, чтобы скакать ими по земле; ");
INSERT INTO russyn_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","сих ешьте из них: саранчу с ее породою, солам с ее породою, харгол с ее породою и хагаб с ее породою. ");
INSERT INTO russyn_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Всякое другое пресмыкающееся, крылатое, у которого четыре ноги, скверно для вас; ");
INSERT INTO russyn_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","от них вы будете нечисты: всякий, кто прикоснется к трупу их, нечист будет до вечера; ");
INSERT INTO russyn_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","и всякий, кто возьмет труп их, должен омыть одежду свою и нечист будет до вечера. ");
INSERT INTO russyn_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Всякий скот, у которого копыта раздвоены, но нет глубокого разреза, и который не жует жвачки, нечист для вас: всякий, кто прикоснется к нему, будет нечист до вечера. ");
INSERT INTO russyn_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Из всех зверей четвероногих те, которые ходят на лапах, нечисты для вас: всякий, кто прикоснется к трупу их, нечист будет до вечера; ");
INSERT INTO russyn_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","кто возьмет труп их, тот должен омыть одежды свои и нечист будет до вечера: нечисты они для вас. ");
INSERT INTO russyn_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Вот что нечисто для вас из животных, пресмыкающихся по земле: крот, мышь, ящерица с ее породою, ");
INSERT INTO russyn_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","анака, хамелеон, летаа, хоме и тиншемет,- ");
INSERT INTO russyn_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","сии нечисты для вас из всех пресмыкающихся: всякий, кто прикоснется к ним мертвым, нечист будет до вечера. ");
INSERT INTO russyn_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","И все, на что упадет которое-нибудь из них мертвое, всякий деревянный сосуд, или одежда, или кожа, или мешок, и всякая вещь, которая употребляется на дело, будут нечисты: в воду должно положить их, и нечисты будут до вечера, потом будут чисты; ");
INSERT INTO russyn_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","если же которое-нибудь из них упадет в какой-нибудь глиняный сосуд, то находящееся в нем будет нечисто, и самый сосуд разбейте. ");
INSERT INTO russyn_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Всякая пища, которую едят, на которой была вода из такого сосуда, нечиста будет для вас, и всякое питье, которое пьют, во всяком таком сосуде нечисто будет. ");
INSERT INTO russyn_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Все, на что упадет что-нибудь от трупа их, нечисто будет: печь и очаг должно разломать, они нечисты; и они должны быть нечисты для вас; ");
INSERT INTO russyn_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","только источник и колодезь, вмещающий воду, остаются чистыми; а кто прикоснется к трупу их, тот нечист. ");
INSERT INTO russyn_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","И если что-нибудь от трупа их упадет на какое-либо семя, которое сеют, то оно чисто; ");
INSERT INTO russyn_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","если же тогда, как вода налита на семя, упадет на него что-нибудь от трупа их, то оно нечисто для вас. ");
INSERT INTO russyn_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","И когда умрет какой-либо скот, который употребляется вами в пищу, то прикоснувшийся к трупу его нечист будет до вечера; ");
INSERT INTO russyn_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","и тот, кто будет есть мертвечину его, должен омыть одежды свои и нечист будет до вечера; и тот, кто понесет труп его, должен омыть одежды свои и нечист будет до вечера. ");
INSERT INTO russyn_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Всякое животное, пресмыкающееся по земле, скверно для вас, не должно есть его; ");
INSERT INTO russyn_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","всего ползающего на чреве и всего ходящего на четырех ногах, и многоножных из животных пресмыкающихся по земле, не ешьте, ибо они скверны; ");
INSERT INTO russyn_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","не оскверняйте душ ваших каким-либо животным пресмыкающимся и не делайте себя чрез них нечистыми, чтоб быть чрез них нечистыми, ");
INSERT INTO russyn_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","ибо Я - Господь Бог ваш: освящайтесь и будьте святы, ибо Я Господь, Бог ваш свят; и не оскверняйте душ ваших каким-либо животным, ползающим по земле, ");
INSERT INTO russyn_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","ибо Я - Господь, выведший вас из земли Египетской, чтобы быть вашим Богом. Итак будьте святы, потому что Я свят. ");
INSERT INTO russyn_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Вот закон о скоте, о птицах, о всех животных, живущих в водах, и о всех животных, пресмыкающихся по земле, ");
INSERT INTO russyn_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","чтобы отличать нечистое от чистого, и животных, которых можно есть, от животных, которых есть не должно. ");
INSERT INTO russyn_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","скажи сынам Израилевым: если женщина зачнет и родит младенца мужеского пола, то она нечиста будет семь дней; как во дни страдания ее очищением, она будет нечиста; ");
INSERT INTO russyn_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","в восьмой же день обрежется у него крайняя плоть его; ");
INSERT INTO russyn_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","и тридцать три дня должна она сидеть, очищаясь от кровей своих; ни к чему священному не должна прикасаться и к святилищу не должна приходить, пока не исполнятся дни очищения ее. ");
INSERT INTO russyn_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Если же она родит младенца женского пола, то во время очищения своего она будет нечиста две недели, и шестьдесят шесть дней должна сидеть, очищаясь от кровей своих. ");
INSERT INTO russyn_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","По окончании дней очищения своего за сына или за дочь она должна принести однолетнего агнца во всесожжение и молодого голубя или горлицу в жертву за грех, ко входу скинии собрания к священнику; ");
INSERT INTO russyn_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","он принесет это пред Господа и очистит ее, и она будет чиста от течения кровей ее. Вот закон о родившей младенца мужеского или женского пола. ");
INSERT INTO russyn_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Если же она не в состоянии принести агнца, то пусть возьмет двух горлиц или двух молодых голубей, одного во всесожжение, а другого в жертву за грех, и очистит ее священник, и она будет чиста. ");
INSERT INTO russyn_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","И сказал Господь Моисею и Аарону, говоря: ");
INSERT INTO russyn_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","когда у кого появится на коже тела его опухоль, или лишаи, или пятно, и на коже тела его сделается как бы язва проказы, то должно привести его к Аарону священнику, или к одному из сынов его, священников; ");
INSERT INTO russyn_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","священник осмотрит язву на коже тела, и если волосы на язве изменились в белые, и язва оказывается углубленною в кожу тела его, то это язва проказы; священник, осмотрев его, объявит его нечистым. ");
INSERT INTO russyn_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","А если на коже тела его пятно белое, но оно не окажется углубленным в кожу, и волосы на нем не изменились в белые, то священник имеющего язву должен заключить на семь дней; ");
INSERT INTO russyn_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","в седьмой день священник осмотрит его, и если язва остается в своем виде и не распространяется язва по коже, то священник должен заключить его на другие семь дней; ");
INSERT INTO russyn_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","в седьмой день опять священник осмотрит его, и если язва менее приметна и не распространилась язва по коже, то священник должен объявить его чистым: это лишаи, и пусть он омоет одежды свои, и будет чист. ");
INSERT INTO russyn_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Если же лишаи станут распространяться по коже, после того как он являлся к священнику для очищения, то он вторично должен явиться к священнику; ");
INSERT INTO russyn_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","священник, увидев, что лишаи распространяются по коже, объявит его нечистым: это проказа. ");
INSERT INTO russyn_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Если будет на ком язва проказы, то должно привести его к священнику; ");
INSERT INTO russyn_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","священник осмотрит, и если опухоль на коже бела, и волос изменился в белый, и на опухоли живое мясо, ");
INSERT INTO russyn_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","то это застарелая проказа на коже тела его; и священник объявит его нечистым и заключит его, ибо он нечист. ");
INSERT INTO russyn_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Если же проказа расцветет на коже, и покроет проказа всю кожу больного от головы его до ног, сколько могут видеть глаза священника, ");
INSERT INTO russyn_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","и увидит священник, что проказа покрыла все тело его, то он объявит больного чистым, потому что все превратилось в белое: он чист. ");
INSERT INTO russyn_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Когда же окажется на нем живое мясо, то он нечист; ");
INSERT INTO russyn_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","священник, увидев живое мясо, объявит его нечистым; живое мясо нечисто: это проказа. ");
INSERT INTO russyn_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Если же живое мясо изменится и обратится в белое, пусть он придет к священнику; ");
INSERT INTO russyn_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","священник осмотрит его, и если язва обратилась в белое, священник объявит больного чистым; он чист. ");
INSERT INTO russyn_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Если у кого на коже тела был нарыв и зажил, ");
INSERT INTO russyn_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","и на месте нарыва появилась белая опухоль, или пятно белое или красноватое, то он должен явиться к священнику; ");
INSERT INTO russyn_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","священник осмотрит его, и если оно окажется ниже кожи, и волос его изменился в белый, то священник объявит его нечистым: это язва проказы, она расцвела на нарыве; ");
INSERT INTO russyn_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","если же священник увидит, что волос на ней не бел, и она не ниже кожи, и притом мало приметна, то священник заключит его на семь дней; ");
INSERT INTO russyn_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","если она станет очень распространяться по коже, то священник объявит его нечистым: это язва; ");
INSERT INTO russyn_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","если же пятно остается на своем месте и не распространяется, то это воспаление нарыва, и священник объявит его чистым. ");
INSERT INTO russyn_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Или если у кого на коже тела будет ожог, и на зажившем ожоге окажется красноватое или белое пятно, ");
INSERT INTO russyn_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","и священник увидит, что волос на пятне изменился в белый, и оно окажется углубленным в коже, то это проказа, она расцвела на ожоге; и священник объявит его нечистым: это язва проказы; ");
INSERT INTO russyn_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","если же священник увидит, что волос на пятне не бел, и оно не ниже кожи, и притом мало приметно, то священник заключит его на семь дней; ");
INSERT INTO russyn_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","в седьмой день священник осмотрит его, и если оно очень распространяется по коже, то священник объявит его нечистым: это язва проказы; ");
INSERT INTO russyn_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","если же пятно остается на своем месте и не распространяется по коже, и притом мало приметно, то это опухоль от ожога; священник объявит его чистым, ибо это воспаление от ожога. ");
INSERT INTO russyn_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Если у мужчины или у женщины будет язва на голове или на бороде, ");
INSERT INTO russyn_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","и осмотрит священник язву, и она окажется углубленною в коже, и волос на ней желтоватый тонкий, то священник объявит их нечистыми: это паршивость, это проказа на голове или на бороде; ");
INSERT INTO russyn_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","если же священник осмотрит язву паршивости и она не окажется углубленною в коже, и волос на ней не черный, то священник имеющего язву паршивости заключит на семь дней; ");
INSERT INTO russyn_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","в седьмой день священник осмотрит язву, и если паршивость не распространяется, и нет на ней желтоватого волоса, и паршивость не окажется углубленною в коже, ");
INSERT INTO russyn_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","то больного должно остричь, но паршивого места не остригать, и священник должен паршивого вторично заключить на семь дней; ");
INSERT INTO russyn_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","в седьмой день священник осмотрит паршивость, и если паршивость не распространяется по коже и не окажется углубленною в коже, то священник объявит его чистым; пусть он омоет одежды свои, и будет чист. ");
INSERT INTO russyn_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Если же после очищения его будет очень распространяться паршивость по коже, ");
INSERT INTO russyn_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","и священник увидит, что паршивость распространяется по коже, то священник пусть не ищет желтоватого волоса: он нечист. ");
INSERT INTO russyn_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Если же паршивость остается в своем виде, и показывается на ней волос черный, то паршивость прошла, он чист; священник объявит его чистым. ");
INSERT INTO russyn_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Если у мужчины или у женщины на коже тела их будут пятна, пятна белые, ");
INSERT INTO russyn_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","и священник увидит, что на коже тела их пятна бледно-белые, то это лишай, расцветший на коже: он чист. ");
INSERT INTO russyn_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Если у кого на голове вылезли волосы, то это плешивый: он чист; ");
INSERT INTO russyn_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","а если на передней стороне головы вылезли волосы, то это лысый: он чист. ");
INSERT INTO russyn_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Если же на плеши или на лысине будет белое или красноватое пятно, то на плеши его или на лысине его расцвела проказа; ");
INSERT INTO russyn_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","священник осмотрит его, и если увидит, что опухоль язвы бела или красновата на плеши его или на лысине его, видом похожа на проказу кожи тела, ");
INSERT INTO russyn_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","то он прокаженный, нечист он; священник должен объявить его нечистым, у него на голове язва. ");
INSERT INTO russyn_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","У прокаженного, на котором эта язва, должна быть разодрана одежда, и голова его должна быть не покрыта, и до уст он должен быть закрыт и кричать: нечист! нечист! ");
INSERT INTO russyn_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Во все дни, доколе на нем язва, он должен быть нечист, нечист он; он должен жить отдельно, вне стана жилище его. ");
INSERT INTO russyn_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Если язва проказы будет на одежде, на одежде шерстяной, или на одежде льняной, ");
INSERT INTO russyn_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","или на основе, или на утоке из льна или шерсти, или на коже, или на каком-нибудь изделии кожаном, ");
INSERT INTO russyn_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","и пятно будет зеленоватое или красноватое на одежде, или на коже, или на основе, или на утоке, или на какой-нибудь кожаной вещи,- то это язва проказы: должно показать ее священнику; ");
INSERT INTO russyn_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","священник осмотрит язву и заключит зараженное язвою на семь дней; ");
INSERT INTO russyn_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","в седьмой день осмотрит священник зараженное, и если язва распространилась по одежде, или по основе, или по утоку, или по коже, или по какому-либо изделию, сделанному из кожи, то это проказа едкая, язва нечистая; ");
INSERT INTO russyn_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","он должен сжечь одежду, или основу, или уток шерстяной или льняной, или какую бы то ни было кожаную вещь, на которой будет язва, ибо это проказа едкая: должно сжечь на огне. ");
INSERT INTO russyn_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Если же священник увидит, что язва не распространилась по одежде, или по основе, или по утоку, или по какой бы то ни было кожаной вещи, ");
INSERT INTO russyn_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","то священник прикажет омыть то, на чем язва, и вторично заключит на семь дней; ");
INSERT INTO russyn_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","если по омытии зараженной вещи священник увидит, что язва не изменила вида своего и не распространилась язва, то она нечиста, сожги ее на огне; это выеденная ямина на лицевой стороне или на изнанке; ");
INSERT INTO russyn_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","если же священник увидит, что язва по омытии ее сделалась менее приметна, то священник пусть оторвет ее от одежды, или от кожи, или от основы, или от утока. ");
INSERT INTO russyn_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Если же она опять покажется на одежде, или на основе, или на утоке, или на какой-нибудь кожаной вещи, то это расцветающая язва: сожги на огне то, на чем язва. ");
INSERT INTO russyn_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Если же одежду, или основу, или уток, или какую-нибудь кожаную вещь вымоешь, и сойдет с них язва, то должно вымыть их вторично, и они будут чисты. ");
INSERT INTO russyn_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Вот закон о язве проказы на одежде шерстяной или льняной, или на основе и на утоке, или на какой-нибудь кожаной вещи, как объявлять ее чистою или нечистою. ");
INSERT INTO russyn_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","вот закон о прокаженном, когда надобно его очистить: приведут его к священнику; ");
INSERT INTO russyn_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","священник выйдет вон из стана, и если священник увидит, что прокаженный исцелился от болезни прокажения, ");
INSERT INTO russyn_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","то священник прикажет взять для очищаемого двух птиц живых чистых, кедрового дерева, червленую нить и иссопа, ");
INSERT INTO russyn_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","и прикажет священник заколоть одну птицу над глиняным сосудом, над живою водою; ");
INSERT INTO russyn_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","а сам он возьмет живую птицу, кедровое дерево, червленую нить и иссоп, и омочит их и живую птицу в крови птицы заколотой над живою водою, ");
INSERT INTO russyn_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","и покропит на очищаемого от проказы семь раз, и объявит его чистым, и пустит живую птицу в поле. ");
INSERT INTO russyn_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Очищаемый омоет одежды свои, острижет все волосы свои, омоется водою, и будет чист; потом войдет в стан и пробудет семь дней вне шатра своего; ");
INSERT INTO russyn_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","в седьмой день обреет все волосы свои, голову свою, бороду свою, брови глаз своих, все волосы свои обреет, и омоет одежды свои, и омоет тело свое водою, и будет чист; ");
INSERT INTO russyn_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","в восьмой день возьмет он двух овнов однолетних без порока, и одну овцу однолетнюю без порока, и три десятых части ефы пшеничной муки, смешанной с елеем, в приношение хлебное, и один лог елея; ");
INSERT INTO russyn_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","священник очищающий поставит очищаемого человека с ними пред Господом у входа скинии собрания; ");
INSERT INTO russyn_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","и возьмет священник одного овна, и представит его в жертву повинности, и лог елея, и принесет это, потрясая пред Господом; ");
INSERT INTO russyn_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","и заколет овна на том месте, где заколают жертву за грех и всесожжение, на месте святом, ибо сия жертва повинности, подобно жертве за грех, принадлежит священнику: это великая святыня; ");
INSERT INTO russyn_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","и возьмет священник крови жертвы повинности, и возложит священник на край правого уха очищаемого и на большой палец правой руки его и на большой палец правой ноги его; ");
INSERT INTO russyn_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","и возьмет священник из лога елея и польет на левую свою ладонь; ");
INSERT INTO russyn_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","и омочит священник правый перст свой в елей, который на левой ладони его, и покропит елеем с перста своего семь раз пред лицем Господа; ");
INSERT INTO russyn_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","оставшийся же елей, который на ладони его, возложит священник на край правого уха очищаемого, на большой палец правой руки его и на большой палец правой ноги его, на места, где кровь жертвы повинности; ");
INSERT INTO russyn_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","а остальной елей, который на ладони священника, возложит он на голову очищаемого, и очистит его священник пред лицем Господа. ");
INSERT INTO russyn_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","И совершит священник жертву за грех, и очистит очищаемого от нечистоты его; после того заколет жертву всесожжения; ");
INSERT INTO russyn_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","и возложит священник всесожжение и приношение хлебное на жертвенник; и очистит его священник, и он будет чист. ");
INSERT INTO russyn_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Если же он беден и не имеет достатка, то пусть возьмет одного овна в жертву повинности для потрясания, чтоб очистить себя, и одну десятую часть ефы пшеничной муки, смешанной с елеем, в приношение хлебное, и лог елея, ");
INSERT INTO russyn_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","и двух горлиц или двух молодых голубей, что достанет рука его, одну из птиц в жертву за грех, а другую во всесожжение; ");
INSERT INTO russyn_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","и принесет их в восьмой день очищения своего к священнику ко входу скинии собрания, пред лице Господа; ");
INSERT INTO russyn_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","священник возьмет овна жертвы повинности и лог елея, и принесет это священник, потрясая пред Господом; ");
INSERT INTO russyn_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","и заколет овна в жертву повинности, и возьмет священник крови жертвы повинности, и возложит на край правого уха очищаемого и на большой палец правой руки его и на большой палец правой ноги его; ");
INSERT INTO russyn_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","и нальет священник елея на левую свою ладонь, ");
INSERT INTO russyn_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","и елеем, который на левой ладони его, покропит священник с правого перста своего семь раз пред лицем Господним; ");
INSERT INTO russyn_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","и возложит священник елея, который на ладони его, на край правого уха очищаемого, на большой палец правой руки его и на большой палец правой ноги его, на места, где кровь жертвы повинности; ");
INSERT INTO russyn_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","а остальной елей, который на ладони священника, возложит он на голову очищаемого, чтоб очистить его пред лицем Господа; ");
INSERT INTO russyn_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","и принесет одну из горлиц или одного из молодых голубей, что достанет рука очищаемого, ");
INSERT INTO russyn_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","из того, что достанет рука его, одну птицу в жертву за грех, а другую во всесожжение, вместе с приношением хлебным; и очистит священник очищаемого пред лицем Господа. ");
INSERT INTO russyn_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Вот закон о прокаженном, который во время очищения своего не имеет достатка. ");
INSERT INTO russyn_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","И сказал Господь Моисею и Аарону, говоря: ");
INSERT INTO russyn_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","когда войдете в землю Ханаанскую, которую Я даю вам во владение, и Я наведу язву проказы на домы в земле владения вашего, ");
INSERT INTO russyn_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","тогда тот, чей дом, должен пойти и сказать священнику: у меня на доме показалась как бы язва. ");
INSERT INTO russyn_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Священник прикажет опорожнить дом, прежде нежели войдет священник осматривать язву, чтобы не сделалось нечистым все, что в доме; после сего придет священник осматривать дом. ");
INSERT INTO russyn_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Если он, осмотрев язву, увидит, что язва на стенах дома состоит из зеленоватых или красноватых ямин, которые окажутся углубленными в стене, ");
INSERT INTO russyn_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","то священник выйдет из дома к дверям дома и запрет дом на семь дней. ");
INSERT INTO russyn_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","В седьмой день опять придет священник, и если увидит, что язва распространилась по стенам дома, ");
INSERT INTO russyn_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","то священник прикажет выломать камни, на которых язва, и бросить их вне города на место нечистое; ");
INSERT INTO russyn_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","а дом внутри пусть весь оскоблят, и обмазку, которую отскоблят, высыпят вне города на место нечистое; ");
INSERT INTO russyn_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","и возьмут другие камни, и вставят вместо тех камней, и возьмут другую обмазку, и обмажут дом. ");
INSERT INTO russyn_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Если язва опять появится и будет цвести на доме после того, как выломали камни и оскоблили дом и обмазали, ");
INSERT INTO russyn_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","то священник придет и осмотрит, и если язва на доме распространилась, то это едкая проказа на доме, нечист он; ");
INSERT INTO russyn_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","должно разломать сей дом, и камни его и дерево его и всю обмазку дома вынести вне города на место нечистое; ");
INSERT INTO russyn_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","кто входит в дом во все время, когда он заперт, тот нечист до вечера; ");
INSERT INTO russyn_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","и кто спит в доме том, тот должен вымыть одежды свои и нечист будет до вечера; и кто ест в доме том, тот должен вымыть одежды свои и нечист будет до вечера. ");
INSERT INTO russyn_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Если же священник придет и увидит, что язва на доме не распространилась после того, как обмазали дом, то священник объявит дом чистым, потому что язва прошла. ");
INSERT INTO russyn_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","И чтобы очистить дом, возьмет он две птицы, кедрового дерева, червленую нить и иссопа, ");
INSERT INTO russyn_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","и заколет одну птицу над глиняным сосудом, над живою водою; ");
INSERT INTO russyn_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","и возьмет кедровое дерево и иссоп, и червленую нить и живую птицу, и омочит их в крови птицы заколотой и в живой воде, и покропит дом семь раз; ");
INSERT INTO russyn_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","и очистит дом кровью птицы и живою водою, и живою птицею и кедровым деревом, и иссопом и червленою нитью; ");
INSERT INTO russyn_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","и пустит живую птицу вне города в поле и очистит дом, и будет чист. ");
INSERT INTO russyn_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Вот закон о всякой язве проказы и о паршивости, ");
INSERT INTO russyn_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","и о проказе на одежде и на доме, и об опухоли, и о лишаях, и о пятнах, ");
INSERT INTO russyn_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","чтобы указать, когда это нечисто и когда чисто. Вот закон о проказе. ");
INSERT INTO russyn_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","И сказал Господь Моисею и Аарону, говоря: ");
INSERT INTO russyn_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","объявите сынам Израилевым и скажите им: если у кого будет истечение из тела его, то от истечения своего он нечист. ");
INSERT INTO russyn_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","И вот закон о нечистоте его от истечения его: когда течет из тела его истечение его, и когда задерживается в теле его истечение его, это нечистота его; ");
INSERT INTO russyn_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","всякая постель, на которой ляжет имеющий истечение, нечиста, и всякая вещь, на которую сядет имеющий истечение семени, нечиста; ");
INSERT INTO russyn_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","и кто прикоснется к постели его, тот должен вымыть одежды свои и омыться водою и нечист будет до вечера; ");
INSERT INTO russyn_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","кто сядет на какую-либо вещь, на которой сидел имеющий истечение, тот должен вымыть одежды свои и омыться водою и нечист будет до вечера; ");
INSERT INTO russyn_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","и кто прикоснется к телу имеющего истечение, тот должен вымыть одежды свои и омыться водою и нечист будет до вечера; ");
INSERT INTO russyn_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","если имеющий истечение плюнет на чистого, то сей должен вымыть одежды свои и омыться водою, и нечист будет до вечера; ");
INSERT INTO russyn_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","и всякая повозка, в которой ехал имеющий истечение, нечиста будет до вечера; ");
INSERT INTO russyn_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","и всякий, кто прикоснется к чему-нибудь, что было под ним, нечист будет до вечера; и кто понесет это, должен вымыть одежды свои и омыться водою, и нечист будет до вечера; ");
INSERT INTO russyn_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","и всякий, к кому прикоснется имеющий истечение, не омыв рук своих водою, должен вымыть одежды свои и омыться водою, и нечист будет до вечера; ");
INSERT INTO russyn_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","глиняный сосуд, к которому прикоснется имеющий истечение, должно разбить, а всякий деревянный сосуд должно вымыть водою и будет чист. ");
INSERT INTO russyn_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","А когда имеющий истечение освободится от истечения своего, тогда должен он отсчитать себе семь дней для очищения своего и вымыть одежды свои, и омыть тело свое живою водою, и будет чист; ");
INSERT INTO russyn_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","и в восьмой день возьмет он себе двух горлиц или двух молодых голубей, и придет пред лице Господне ко входу скинии собрания, и отдаст их священнику; ");
INSERT INTO russyn_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","и принесет священник из сих птиц одну в жертву за грех, а другую во всесожжение, и очистит его священник пред Господом от истечения его. ");
INSERT INTO russyn_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Если у кого случится излияние семени, то он должен омыть водою все тело свое, и нечист будет до вечера; ");
INSERT INTO russyn_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","и всякая одежда и всякая кожа, на которую попадет семя, должна быть вымыта водою, и нечиста будет до вечера; ");
INSERT INTO russyn_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","если мужчина ляжет с женщиной и будет у него излияние семени, то они должны омыться водою, и нечисты будут до вечера. ");
INSERT INTO russyn_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Если женщина имеет истечение крови, текущей из тела ее, то она должна сидеть семь дней во время очищения своего, и всякий, кто прикоснется к ней, нечист будет до вечера; ");
INSERT INTO russyn_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","и все, на чем она ляжет в продолжение очищения своего, нечисто; и все, на чем сядет, нечисто; ");
INSERT INTO russyn_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","и всякий, кто прикоснется к постели ее, должен вымыть одежды свои и омыться водою, и нечист будет до вечера; ");
INSERT INTO russyn_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","и всякий, кто прикоснется к какой-нибудь вещи, на которой она сидела, должен вымыть одежды свои и омыться водою, и нечист будет до вечера; ");
INSERT INTO russyn_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","и если кто прикоснется к чему-нибудь на постели или на той вещи, на которой она сидела, нечист будет до вечера; ");
INSERT INTO russyn_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","если переспит с нею муж, то нечистота ее будет на нем; он нечист будет семь дней, и всякая постель, на которой он ляжет, будет нечиста. ");
INSERT INTO russyn_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Если у женщины течет кровь многие дни не во время очищения ее, или если она имеет истечение долее обыкновенного очищения ее, то во все время истечения нечистоты ее, подобно как в продолжение очищения своего, она нечиста; ");
INSERT INTO russyn_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","всякая постель, на которой она ляжет во все время истечения своего, будет нечиста, подобно как постель в продолжение очищения ее; и всякая вещь, на которую она сядет, будет нечиста, как нечисто это во время очищения ее; ");
INSERT INTO russyn_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","и всякий, кто прикоснется к ним, будет нечист, и должен вымыть одежды свои и омыться водою, и нечист будет до вечера. ");
INSERT INTO russyn_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","А когда она освободится от истечения своего, тогда должна отсчитать себе семь дней, и потом будет чиста; ");
INSERT INTO russyn_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","в восьмой день возьмет она себе двух горлиц или двух молодых голубей и принесет их к священнику ко входу скинии собрания; ");
INSERT INTO russyn_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","и принесет священник одну из птиц в жертву за грех, а другую во всесожжение, и очистит ее священник пред Господом от истечения нечистоты ее. ");
INSERT INTO russyn_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Так предохраняйте сынов Израилевых от нечистоты их, чтоб они не умерли в нечистоте своей, оскверняя жилище Мое, которое среди них: ");
INSERT INTO russyn_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","вот закон об имеющем истечение и о том, у кого случится излияние семени, делающее его нечистым, ");
INSERT INTO russyn_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","и о страдающей очищением своим, и о имеющих истечение, мужчине или женщине, и о муже, который переспит с нечистою. ");
INSERT INTO russyn_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","И говорил Господь Моисею по смерти двух сынов Аароновых, когда они, приступив с чуждым огнем пред лице Господне, умерли, ");
INSERT INTO russyn_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","и сказал Господь Моисею: скажи Аарону, брату твоему, чтоб он не во всякое время входил во святилище за завесу пред крышку, что на ковчеге откровения, дабы ему не умереть, ибо над крышкою Я буду являться в облаке. ");
INSERT INTO russyn_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Вот с чем должен входить Аарон во святилище: с тельцом в жертву за грех и с овном во всесожжение; ");
INSERT INTO russyn_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","священный льняной хитон должен надевать он, нижнее платье льняное да будет на теле его, и льняным поясом пусть опоясывается, и льняной кидар надевает: это священные одежды; и пусть омывает он тело свое водою и надевает их; ");
INSERT INTO russyn_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","и от общества сынов Израилевых пусть возьмет из стада коз двух козлов в жертву за грех и одного овна во всесожжение. ");
INSERT INTO russyn_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","И принесет Аарон тельца в жертву за грех за себя и очистит себя и дом свой. ");
INSERT INTO russyn_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","И возьмет двух козлов и поставит их пред лицем Господним у входа скинии собрания; ");
INSERT INTO russyn_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","и бросит Аарон об обоих козлах жребии: один жребий для Господа, а другой жребий для отпущения; ");
INSERT INTO russyn_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","и приведет Аарон козла, на которого вышел жребий для Господа, и принесет его в жертву за грех, ");
INSERT INTO russyn_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","а козла, на которого вышел жребий для отпущения, поставит живого пред Господом, чтобы совершить над ним очищение и отослать его в пустыню для отпущения и чтоб он понес на себе их беззакония в землю непроходимую. ");
INSERT INTO russyn_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","И приведет Аарон тельца в жертву за грех за себя, и очистит себя и дом свой, и заколет тельца в жертву за грех за себя; ");
INSERT INTO russyn_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","и возьмет горящих угольев полную кадильницу с жертвенника, который пред лицем Господним, и благовонного мелко истолченного курения полные горсти, и внесет за завесу; ");
INSERT INTO russyn_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","и положит курение на огонь пред лицем Господним, и облако курения покроет крышку, которая над ковчегом откровения, дабы ему не умереть; ");
INSERT INTO russyn_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","и возьмет крови тельца и покропит перстом своим на крышку спереди и пред крышкою, семь раз покропит кровью с перста своего. ");
INSERT INTO russyn_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","И заколет козла в жертву за грех за народ, и внесет кровь его за завесу, и сделает с кровью его то же, что делал с кровью тельца, и покропит ею на крышку и пред крышкою, ");
INSERT INTO russyn_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","и очистит святилище от нечистот сынов Израилевых и от преступлений их, во всех грехах их. Так должен поступить он и со скиниею собрания, находящеюся у них, среди нечистот их. ");
INSERT INTO russyn_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Ни один человек не должен быть в скинии собрания, когда входит он для очищения святилища, до самого выхода его. И так очистит он себя, дом свой и все общество Израилево. ");
INSERT INTO russyn_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","И выйдет он к жертвеннику, который пред лицем Господним, и очистит его, и возьмет крови тельца и крови козла, и возложит на роги жертвенника со всех сторон, ");
INSERT INTO russyn_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","и покропит на него кровью с перста своего семь раз, и очистит его, и освятит его от нечистот сынов Израилевых. ");
INSERT INTO russyn_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","И совершив очищение святилища, скинии собрания и жертвенника и очистив священников, приведет он живого козла, ");
INSERT INTO russyn_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","и возложит Аарон обе руки свои на голову живого козла, и исповедает над ним все беззакония сынов Израилевых и все преступления их и все грехи их, и возложит их на голову козла, и отошлет с нарочным человеком в пустыню: ");
INSERT INTO russyn_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","и понесет козел на себе все беззакония их в землю непроходимую, и пустит он козла в пустыню. ");
INSERT INTO russyn_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","И войдет Аарон в скинию собрания, и снимет льняные одежды, которые надевал, входя во святилище, и оставит их там, ");
INSERT INTO russyn_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","и омоет тело свое водою на святом месте, и наденет одежды свои, и выйдет и совершит всесожжение за себя и всесожжение за народ, и очистит себя, дом свой и народ и священников; ");
INSERT INTO russyn_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","а тук жертвы за грех воскурит на жертвеннике. ");
INSERT INTO russyn_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","И тот, кто отводил козла для отпущения, должен вымыть одежды свои, омыть тело свое водою, и потом может войти в стан. ");
INSERT INTO russyn_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","А тельца за грех и козла за грех, которых кровь внесена была для очищения святилища, пусть вынесут вон из стана и сожгут на огне кожи их и мясо их и нечистоту их; ");
INSERT INTO russyn_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","кто сожжет их, тот должен вымыть одежды свои и омыть тело свое водою, и после того может войти в стан. ");
INSERT INTO russyn_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","И да будет сие для вас вечным постановлением: в седьмой месяц, в десятый день месяца смиряйте души ваши и никакого дела не делайте, ни туземец, ни пришлец, поселившийся между вами, ");
INSERT INTO russyn_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","ибо в сей день очищают вас, чтобы сделать вас чистыми от всех грехов ваших, чтобы вы были чисты пред лицем Господним; ");
INSERT INTO russyn_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","это суббота покоя для вас, смиряйте души ваши: это постановление вечное. ");
INSERT INTO russyn_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Очищать же должен священник, который помазан и который посвящен, чтобы священнодействовать ему вместо отца своего: и наденет он льняные одежды, одежды священные, ");
INSERT INTO russyn_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","и очистит Святое Святых и скинию собрания, и жертвенник очистит, и священников и весь народ общества очистит. ");
INSERT INTO russyn_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","И да будет сие для вас вечным постановлением: очищать сынов Израилевых от всех грехов их однажды в году. И сделал он так, как повелел Господь Моисею. ");
INSERT INTO russyn_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","объяви Аарону и сынам его и всем сынам Израилевым и скажи им: вот что повелевает Господь: ");
INSERT INTO russyn_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","если кто из дома Израилева или из пришельцев, присоединившихся к вам заколет тельца или овцу или козу в стане, или если кто заколет вне стана ");
INSERT INTO russyn_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","и не приведет ко входу скинии собрания, чтобы принести во всесожжение или в жертву о спасении, угодную Господу, в приятное благоухание, и если кто заколет вне стана и ко входу скинии собрания не принесет, чтобы представить в жертву Господу пред жилищем Господним, то человеку тому вменена будет кровь: он пролил кровь, и истребится человек тот из народа своего; ");
INSERT INTO russyn_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","это для того, чтобы приводили сыны Израилевы жертвы свои, которые они заколают на поле, чтобы приводили их пред Господа ко входу скинии собрания, к священнику, и заколали их Господу в жертвы мирные; ");
INSERT INTO russyn_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","и покропит священник кровью на жертвенник Господень у входа скинии собрания и воскурит тук в приятное благоухание Господу, ");
INSERT INTO russyn_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","чтоб они впредь не приносили жертв своих идолам, за которыми блудно ходят они. Сие да будет для них постановлением вечным в роды их. ");
INSERT INTO russyn_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Еще скажи им: если кто из дома Израилева и из пришельцев, которые живут между вами, приносит всесожжение или жертву ");
INSERT INTO russyn_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","и не приведет ко входу скинии собрания, чтобы совершить ее Господу, то истребится человек тот из народа своего. ");
INSERT INTO russyn_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Если кто из дома Израилева и из пришельцев, которые живут между вами, будет есть какую-нибудь кровь, то обращу лице Мое на душу того, кто будет есть кровь, и истреблю ее из народа его, ");
INSERT INTO russyn_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","потому что душа тела в крови, и Я назначил ее вам для жертвенника, чтобы очищать души ваши, ибо кровь сия душу очищает; ");
INSERT INTO russyn_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","потому Я и сказал сынам Израилевым: ни одна душа из вас не должна есть крови, и пришлец, живущий между вами, не должен есть крови. ");
INSERT INTO russyn_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Если кто из сынов Израилевых и из пришельцев, живущих между вами, на ловле поймает зверя или птицу, которую можно есть, то он должен дать вытечь крови ее и покрыть ее землею, ");
INSERT INTO russyn_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","ибо душа всякого тела есть кровь его, она душа его; потому Я сказал сынам Израилевым: не ешьте крови ни из какого тела, потому что душа всякого тела есть кровь его: всякий, кто будет есть ее, истребится. ");
INSERT INTO russyn_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","И всякий, кто будет есть мертвечину или растерзанное зверем, туземец или пришлец, должен вымыть одежды свои и омыться водою, и нечист будет до вечера, а потом будет чист; ");
INSERT INTO russyn_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","если же не вымоет одежд своих и не омоет тела своего, то понесет на себе беззаконие свое. ");
INSERT INTO russyn_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","объяви сынам Израилевым и скажи им: Я Господь, Бог ваш. ");
INSERT INTO russyn_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","По делам земли Египетской, в которой вы жили, не поступайте, и по делам земли Ханаанской, в которую Я веду вас не поступайте, и по установлениям их не ходите: ");
INSERT INTO russyn_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Мои законы исполняйте и Мои постановления соблюдайте, поступая по ним. Я Господь, Бог ваш. ");
INSERT INTO russyn_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Соблюдайте постановления Мои и законы Мои, которые исполняя, человек будет жив. Я Господь Бог ваш. ");
INSERT INTO russyn_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Никто ни к какой родственнице по плоти не должен приближаться с тем, чтобы открыть наготу. Я Господь. ");
INSERT INTO russyn_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Наготы отца твоего и наготы матери твоей не открывай: она мать твоя, не открывай наготы ее. ");
INSERT INTO russyn_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Наготы жены отца твоего не открывай: это нагота отца твоего. ");
INSERT INTO russyn_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Наготы сестры твоей, дочери отца твоего или дочери матери твоей, родившейся в доме или вне дома, не открывай наготы их. ");
INSERT INTO russyn_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Наготы дочери сына твоего или дочери дочери твоей, не открывай наготы их, ибо они твоя нагота. ");
INSERT INTO russyn_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Наготы дочери жены отца твоего, родившейся от отца твоего, она сестра твоя по отцу, не открывай наготы ее. ");
INSERT INTO russyn_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Наготы сестры отца твоего не открывай, она единокровная отцу твоему. ");
INSERT INTO russyn_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Наготы сестры матери твоей не открывай, ибо она единокровная матери твоей. ");
INSERT INTO russyn_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Наготы брата отца твоего не открывай и к жене его не приближайся: она тетка твоя. ");
INSERT INTO russyn_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Наготы невестки твоей не открывай: она жена сына твоего, не открывай наготы ее. ");
INSERT INTO russyn_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Наготы жены брата твоего не открывай, это нагота брата твоего. ");
INSERT INTO russyn_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Наготы жены и дочери ее не открывай; дочери сына ее и дочери дочери ее не бери, чтоб открыть наготу их, они единокровные ее; это беззаконие. ");
INSERT INTO russyn_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Не бери жены вместе с сестрою ее, чтобы сделать ее соперницею, чтоб открыть наготу ее при ней, при жизни ее. ");
INSERT INTO russyn_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","И к жене во время очищения нечистот ее не приближайся, чтоб открыть наготу ее. ");
INSERT INTO russyn_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","И с женою ближнего твоего не ложись, чтобы излить семя и оскверниться с нею. ");
INSERT INTO russyn_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Из детей твоих не отдавай на служение Молоху и не бесчести имени Бога твоего. Я Господь. ");
INSERT INTO russyn_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Не ложись с мужчиною, как с женщиною: это мерзость. ");
INSERT INTO russyn_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","И ни с каким скотом не ложись, чтоб излить семя и оскверниться от него; и женщина не должна становиться пред скотом для совокупления с ним: это гнусно. ");
INSERT INTO russyn_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Не оскверняйте себя ничем этим, ибо всем этим осквернили себя народы, которых Я прогоняю от вас: ");
INSERT INTO russyn_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","и осквернилась земля, и Я воззрел на беззаконие ее, и свергнула с себя земля живущих на ней. ");
INSERT INTO russyn_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","А вы соблюдайте постановления Мои и законы Мои и не делайте всех этих мерзостей, ни туземец, ни пришлец, живущий между вами, ");
INSERT INTO russyn_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","ибо все эти мерзости делали люди сей земли, что пред вами, и осквернилась земля; ");
INSERT INTO russyn_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","чтоб и вас не свергнула с себя земля, когда вы станете осквернять ее, как она свергнула народы, бывшие прежде вас; ");
INSERT INTO russyn_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","ибо если кто будет делать все эти мерзости, то души делающих это истреблены будут из народа своего. ");
INSERT INTO russyn_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Итак соблюдайте повеления Мои, чтобы не поступать по гнусным обычаям, по которым поступали прежде вас, и чтобы не оскверняться ими. Я Господь, Бог ваш. ");
INSERT INTO russyn_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","объяви всему обществу сынов Израилевых и скажи им: святы будьте, ибо свят Я Господь, Бог ваш. ");
INSERT INTO russyn_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Бойтесь каждый матери своей и отца своего и субботы Мои храните. Я Господь, Бог ваш. ");
INSERT INTO russyn_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Не обращайтесь к идолам и богов литых не делайте себе. Я Господь, Бог ваш. ");
INSERT INTO russyn_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Когда будете приносить Господу жертву мирную, то приносите ее, чтобы приобрести себе благоволение: ");
INSERT INTO russyn_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","в день жертвоприношения вашего и на другой день должно есть ее, а оставшееся к третьему дню должно сжечь на огне; ");
INSERT INTO russyn_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","если же кто станет есть ее на третий день, это гнусно, это не будет благоприятно; ");
INSERT INTO russyn_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","кто станет есть ее, тот понесет на себе грех, ибо он осквернил святыню Господню, и истребится душа та из народа своего. ");
INSERT INTO russyn_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Когда будете жать жатву на земле вашей, не дожинай до края поля твоего, и оставшегося от жатвы твоей не подбирай, ");
INSERT INTO russyn_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","и виноградника твоего не обирай дочиста, и попадавших ягод в винограднике не подбирай; оставь это бедному и пришельцу. Я Господь, Бог ваш. ");
INSERT INTO russyn_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Не крадите, не лгите и не обманывайте друг друга. ");
INSERT INTO russyn_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Не клянитесь именем Моим во лжи, и не бесчести имени Бога твоего. Я Господь Бог ваш. ");
INSERT INTO russyn_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Не обижай ближнего твоего и не грабительствуй. Плата наемнику не должна оставаться у тебя до утра. ");
INSERT INTO russyn_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Не злословь глухого и пред слепым не клади ничего, чтобы преткнуться ему; бойся Господа Бога твоего. Я Господь Бог ваш. ");
INSERT INTO russyn_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Не делайте неправды на суде; не будь лицеприятен к нищему и не угождай лицу великого; по правде суди ближнего твоего. ");
INSERT INTO russyn_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Не ходи переносчиком в народе твоем и не восставай на жизнь ближнего твоего. Я Господь Бог ваш. ");
INSERT INTO russyn_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Не враждуй на брата твоего в сердце твоем; обличи ближнего твоего, и не понесешь за него греха. ");
INSERT INTO russyn_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Не мсти и не имей злобы на сынов народа твоего, но люби ближнего твоего, как самого себя. Я Господь Бог ваш. ");
INSERT INTO russyn_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Уставы Мои соблюдайте; скота твоего не своди с иною породою; поля твоего не засевай двумя родами семян; в одежду из разнородных нитей, из шерсти и льна, не одевайся. ");
INSERT INTO russyn_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Если кто переспит с женщиною, а она раба, обрученная мужу, но еще не выкупленная, или свобода еще не дана ей, то должно наказать их, но не смертью, потому что она несвободная: ");
INSERT INTO russyn_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","пусть приведет он Господу ко входу скинии собрания жертву повинности, овна в жертву повинности своей; ");
INSERT INTO russyn_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","и очистит его священник овном повинности пред Господом от греха, которым он согрешил, и прощен будет ему грех, которым он согрешил. ");
INSERT INTO russyn_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Когда придете в землю, которую Господь Бог даст вам, и посадите какое-либо плодовое дерево, то плоды его почитайте за необрезанные: три года должно почитать их за необрезанные, не должно есть их; ");
INSERT INTO russyn_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","а в четвертый год все плоды его должны быть посвящены для празднеств Господних; ");
INSERT INTO russyn_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","в пятый же год вы можете есть плоды его и собирать себе все произведения его. Я Господь, Бог ваш. ");
INSERT INTO russyn_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Не ешьте с кровью; не ворожите и не гадайте. ");
INSERT INTO russyn_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Не стригите головы вашей кругом, и не порти края бороды твоей. ");
INSERT INTO russyn_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Ради умершего не делайте нарезов на теле вашем и не накалывайте на себе письмен. Я Господь Бог ваш. ");
INSERT INTO russyn_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Не оскверняй дочери твоей, допуская ее до блуда, чтобы не блудодействовала земля и не наполнилась земля развратом. ");
INSERT INTO russyn_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Субботы Мои храните и святилище Мое чтите. Я Господь. ");
INSERT INTO russyn_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Не обращайтесь к вызывающим мертвых, и к волшебникам не ходите, и не доводите себя до осквернения от них. Я Господь, Бог ваш. ");
INSERT INTO russyn_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Пред лицом седого вставай и почитай лице старца, и бойся Господа Бога твоего. Я Господь Бог ваш. ");
INSERT INTO russyn_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Когда поселится пришлец в земле вашей, не притесняйте его: ");
INSERT INTO russyn_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","пришлец, поселившийся у вас, да будет для вас то же, что туземец ваш; люби его, как себя; ибо и вы были пришельцами в земле Египетской. Я Господь, Бог ваш. ");
INSERT INTO russyn_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Не делайте неправды в суде, в мере, в весе и в измерении: ");
INSERT INTO russyn_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","да будут у вас весы верные, гири верные, ефа верная и гин верный. Я Господь, Бог ваш, Который вывел вас из земли Египетской. ");
INSERT INTO russyn_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Соблюдайте все уставы Мои и все законы Мои и исполняйте их. Я Господь Бог ваш. ");
INSERT INTO russyn_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","скажи сие сынам Израилевым: кто из сынов Израилевых и из пришельцев, живущих между Израильтянами, даст из детей своих Молоху, тот да будет предан смерти: народ земли да побьет его камнями; ");
INSERT INTO russyn_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","и Я обращу лице Мое на человека того и истреблю его из народа его за то, что он дал из детей своих Молоху, чтоб осквернить святилище Мое и обесчестить святое имя Мое; ");
INSERT INTO russyn_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","и если народ земли не обратит очей своих на человека того, когда он даст из детей своих Молоху, и не умертвит его, ");
INSERT INTO russyn_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","то Я обращу лице Мое на человека того и на род его и истреблю его из народа его, и всех блудящих по следам его, чтобы блудно ходить вслед Молоха. ");
INSERT INTO russyn_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","И если какая душа обратится к вызывающим мертвых и к волшебникам, чтобы блудно ходить вслед их, то Я обращу лице Мое на ту душу и истреблю ее из народа ее. ");
INSERT INTO russyn_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Освящайте себя и будьте святы, ибо Я Господь, Бог ваш, свят. ");
INSERT INTO russyn_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Соблюдайте постановления Мои и исполняйте их, ибо Я Господь, освящающий вас. ");
INSERT INTO russyn_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Кто будет злословить отца своего или мать свою, тот да будет предан смерти; отца своего и мать свою он злословил: кровь его на нем. ");
INSERT INTO russyn_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Если кто будет прелюбодействовать с женой замужнею, если кто будет прелюбодействовать с женою ближнего своего,- да будут преданы смерти и прелюбодей и прелюбодейка. ");
INSERT INTO russyn_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Кто ляжет с женою отца своего, тот открыл наготу отца своего: оба они да будут преданы смерти, кровь их на них. ");
INSERT INTO russyn_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Если кто ляжет с невесткою своею, то оба они да будут преданы смерти: мерзость сделали они, кровь их на них. ");
INSERT INTO russyn_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Если кто ляжет с мужчиною, как с женщиною, то оба они сделали мерзость: да будут преданы смерти, кровь их на них. ");
INSERT INTO russyn_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Если кто возьмет себе жену и мать ее: это беззаконие; на огне должно сжечь его и их, чтобы не было беззакония между вами. ");
INSERT INTO russyn_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Кто смесится со скотиною, того предать смерти, и скотину убейте. ");
INSERT INTO russyn_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Если женщина пойдет к какой-нибудь скотине, чтобы совокупиться с нею, то убей женщину и скотину: да будут они преданы смерти, кровь их на них. ");
INSERT INTO russyn_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Если кто возьмет сестру свою, дочь отца своего или дочь матери своей, и увидит наготу ее, и она увидит наготу его: это срам, да будут они истреблены пред глазами сынов народа своего; он открыл наготу сестры своей: грех свой понесет он. ");
INSERT INTO russyn_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Если кто ляжет с женою во время болезни кровоочищения и откроет наготу ее, то он обнажил истечения ее, и она открыла течение кровей своих: оба они да будут истреблены из народа своего. ");
INSERT INTO russyn_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Наготы сестры матери твоей и сестры отца твоего не открывай, ибо таковой обнажает плоть свою: грех свой понесут они. ");
INSERT INTO russyn_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Кто ляжет с теткою своею, тот открыл наготу дяди своего; грех свой понесут они, бездетными умрут. ");
INSERT INTO russyn_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Если кто возьмет жену брата своего: это гнусно; он открыл наготу брата своего, бездетны будут они. ");
INSERT INTO russyn_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Соблюдайте все уставы Мои и все законы Мои и исполняйте их,- и не свергнет вас с себя земля, в которую Я веду вас жить. ");
INSERT INTO russyn_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Не поступайте по обычаям народа, который Я прогоняю от вас; ибо они все это делали, и Я вознегодовал на них, ");
INSERT INTO russyn_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","и сказал Я вам: вы владейте землею их, и вам отдаю в наследие землю, в которой течет молоко и мед. Я Господь, Бог ваш, Который отделил вас от всех народов. ");
INSERT INTO russyn_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Отличайте скот чистый от нечистого и птицу чистую от нечистой и не оскверняйте душ ваших скотом и птицею и всем пресмыкающимся по земле, что отличил Я, как нечистое. ");
INSERT INTO russyn_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Будьте предо Мною святы, ибо Я свят Господь Бог ваш, и Я отделил вас от народов, чтобы вы были Мои. ");
INSERT INTO russyn_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Мужчина ли или женщина, если будут они вызывать мертвых или волхвовать, да будут преданы смерти: камнями должно побить их, кровь их на них. ");
INSERT INTO russyn_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","И сказал Господь Моисею: объяви священникам, сынам Аароновым, и скажи им: да не оскверняют себя прикосновением к умершему из народа своего; ");
INSERT INTO russyn_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","только к ближнему родственнику своему, к матери своей и к отцу своему, к сыну своему и дочери своей, к брату своему ");
INSERT INTO russyn_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","и к сестре своей, девице, живущей при нем и не бывшей замужем, можно ему прикасаться, не оскверняя себя; ");
INSERT INTO russyn_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","и прикосновением к кому бы то ни было в народе своем не должен он осквернять себя, чтобы не сделаться нечистым. ");
INSERT INTO russyn_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Они не должны брить головы своей и подстригать края бороды своей и делать нарезы на теле своем. ");
INSERT INTO russyn_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Они должны быть святы Богу своему и не должны бесчестить имени Бога своего, ибо они приносят жертвы Господу, хлеб Богу своему, и потому должны быть святы. ");
INSERT INTO russyn_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Они не должны брать за себя блудницу и опороченную, не должны брать и жену, отверженную мужем своим, ибо они святы Господу Богу своему. ");
INSERT INTO russyn_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Святи его, ибо он приносит хлеб Господу Богу твоему: да будет он у тебя свят, ибо свят Я Господь, освящающий вас. ");
INSERT INTO russyn_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Если дочь священника осквернит себя блудодеянием, то она бесчестит отца своего; огнем должно сжечь ее. ");
INSERT INTO russyn_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Великий же священник из братьев своих, на голову которого возлит елей помазания, и который освящен, чтобы облачаться в священные одежды, не должен обнажать головы своей и раздирать одежд своих; ");
INSERT INTO russyn_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","и ни к какому умершему не должен он приступать: даже прикосновением к умершему отцу своему и матери своей он не должен осквернять себя. ");
INSERT INTO russyn_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","И от святилища он не должен отходить и бесчестить святилище Бога своего, ибо освящение елеем помазания Бога его на нем. Я Господь. ");
INSERT INTO russyn_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","В жену он должен брать девицу из народа своего: ");
INSERT INTO russyn_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","вдову, или отверженную, или опороченную, или блудницу, не должен он брать, но девицу из народа своего должен он брать в жену; ");
INSERT INTO russyn_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","он не должен порочить семени своего в народе своем, ибо Я Господь Бог, освящающий его. ");
INSERT INTO russyn_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","скажи Аарону: никто из семени твоего во все роды их, у которого на теле будет недостаток, не должен приступать, чтобы приносить хлеб Богу своему; ");
INSERT INTO russyn_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","никто, у кого на теле есть недостаток, не должен приступать, ни слепой, ни хромой, ни уродливый, ");
INSERT INTO russyn_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ни такой, у которого переломлена нога или переломлена рука, ");
INSERT INTO russyn_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ни горбатый, ни с сухим членом, ни с бельмом на глазу, ни коростовый, ни паршивый, ни с поврежденными ятрами; ");
INSERT INTO russyn_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","ни один человек из семени Аарона священника, у которого на теле есть недостаток, не должен приступать, чтобы приносить жертвы Господу; недостаток на нем, поэтому не должен он приступать, чтобы приносить хлеб Богу своему; ");
INSERT INTO russyn_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","хлеб Бога своего из великих святынь и из святынь он может есть; ");
INSERT INTO russyn_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","но к завесе не должен он приходить и к жертвеннику не должен приступать, потому что недостаток на нем: не должен он бесчестить святилища Моего, ибо Я Господь, освящающий их. ");
INSERT INTO russyn_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","И объявил это Моисей Аарону и сынам его и всем сынам Израилевым. ");
INSERT INTO russyn_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","скажи Аарону и сынам его, чтоб они осторожно поступали со святынями сынов Израилевых и не бесчестили святаго имени Моего в том, что они посвящают Мне. Я Господь. ");
INSERT INTO russyn_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Скажи им: если кто из всего потомства вашего в роды ваши, имея на себе нечистоту, приступит к святыням, которые посвящают сыны Израилевы Господу, то истребится душа та от лица Моего. Я Господь Бог ваш. ");
INSERT INTO russyn_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Кто из семени Ааронова прокажен, или имеет истечение, тот не должен есть святынь, пока не очистится; и кто прикоснется к чему-нибудь нечистому от мертвого, или у кого случится излияние семени, ");
INSERT INTO russyn_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","или кто прикоснется к какому-нибудь гаду, от которого он сделается нечист, или к человеку, от которого он сделается нечист какою бы то ни было нечистотою, ");
INSERT INTO russyn_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","тот, прикоснувшийся к сему, нечист будет до вечера и не должен есть святынь, прежде нежели омоет тело свое водою; ");
INSERT INTO russyn_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","но когда зайдет солнце и он очистится, тогда может он есть святыни, ибо это его пища. ");
INSERT INTO russyn_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Мертвечины и звероядины он не должен есть, чтобы не оскверниться этим. Я Господь. ");
INSERT INTO russyn_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Да соблюдают они повеления Мои, чтобы не понести на себе греха и не умереть в нем, когда нарушат сие. Я Господь Бог, освящающий их. ");
INSERT INTO russyn_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Никто посторонний не должен есть святыни; поселившийся у священника и наемник не должен есть святыни; ");
INSERT INTO russyn_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","если же священник купит себе человека за серебро, то сей может есть оную; также и домочадцы его могут есть хлеб его. ");
INSERT INTO russyn_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Если дочь священника выйдет в замужество за постороннего, то она не должна есть приносимых святынь; ");
INSERT INTO russyn_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","когда же дочь священника будет вдова, или разведенная, и детей нет у нее, и возвратится в дом отца своего, как была в юности своей, тогда она может есть хлеб отца своего; а посторонний никто не должен есть его. ");
INSERT INTO russyn_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Кто по ошибке съест что-нибудь из святыни, тот должен отдать священнику святыню и приложить к ней пятую ее долю. ");
INSERT INTO russyn_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Священники сами не должны порочить святыни сынов Израилевых, которые они приносят Господу, ");
INSERT INTO russyn_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","и не должны навлекать на себя вину в преступлении, когда будут есть святыни свои, ибо Я Господь, освящающий их. ");
INSERT INTO russyn_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","объяви Аарону и сынам его и всем сынам Израилевым и скажи им: если кто из дома Израилева, или из пришельцев, поселившихся между Израильтянами, по обету ли какому, или по усердию приносит жертву свою, которую приносят Господу во всесожжение, ");
INSERT INTO russyn_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","то, чтобы сим приобрести благоволение от Бога, жертва должна быть без порока, мужеского пола, из крупного скота, из овец и из коз; ");
INSERT INTO russyn_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","никакого животного, на котором есть порок, не приносите Господу, ибо это не приобретет вам благоволения. ");
INSERT INTO russyn_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","И если кто приносит мирную жертву Господу, исполняя обет, или по усердию, или в праздники ваши, из крупного скота или из мелкого, то жертва должна быть без порока, чтоб быть угодною Богу: никакого порока не должно быть на ней; ");
INSERT INTO russyn_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","животного слепого, или поврежденного, или уродливого, или больного, или коростового, или паршивого, таких не приносите Господу и в жертву не давайте их на жертвенник Господень; ");
INSERT INTO russyn_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","тельца и агнца с членами, несоразмерно длинными или короткими, в жертву усердия принести можешь; а если по обету, то это не угодно будет Богу; ");
INSERT INTO russyn_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","животного, у которого ятра раздавлены, разбиты, оторваны или вырезаны, не приносите Господу и в земле вашей не делайте сего; ");
INSERT INTO russyn_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","и из рук иноземцев не приносите всех таковых животных в дар Богу вашему, потому что на них повреждение, порок на них: не приобретут они вам благоволения. ");
INSERT INTO russyn_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","когда родится теленок, или ягненок, или козленок, то семь дней он должен пробыть при матери своей, а от восьмого дня и далее будет благоугоден для приношения в жертву Господу; ");
INSERT INTO russyn_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","но ни коровы, ни овцы не заколайте в один день с порождением ее. ");
INSERT INTO russyn_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Если приносите Господу жертву благодарения, то приносите ее так, чтоб она приобрела вам благоволение; ");
INSERT INTO russyn_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","в тот же день должно съесть ее, не оставляйте от нее до утра. Я Господь. ");
INSERT INTO russyn_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","И соблюдайте заповеди Мои и исполняйте их. Я Господь. ");
INSERT INTO russyn_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Не бесчестите святого имени Моего, чтоб Я был святим среди сынов Израилевых. Я Господь, освящающий вас, ");
INSERT INTO russyn_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Который вывел вас из земли Египетской, чтоб быть вашим Богом. Я Господь. ");
INSERT INTO russyn_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","объяви сынам Израилевым и скажи им о праздниках Господних, в которые должно созывать священные собрания. Вот праздники Мои: ");
INSERT INTO russyn_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","шесть дней можно делать дела, а в седьмой день суббота покоя, священное собрание; никакого дела не делайте; это суббота Господня во всех жилищах ваших. ");
INSERT INTO russyn_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Вот праздники Господни, священные собрания, которые вы должны созывать в свое время: ");
INSERT INTO russyn_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","в первый месяц, в четырнадцатый день месяца вечером Пасха Господня; ");
INSERT INTO russyn_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","и в пятнадцатый день того же месяца праздник опресноков Господу; семь дней ешьте опресноки; ");
INSERT INTO russyn_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","в первый день да будет у вас священное собрание; никакой работы не работайте; ");
INSERT INTO russyn_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","и в течение семи дней приносите жертвы Господу; в седьмой день также священное собрание; никакой работы не работайте. ");
INSERT INTO russyn_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","объяви сынам Израилевым и скажи им: когда придете в землю, которую Я даю вам, и будете жать на ней жатву, то принесите первый сноп жатвы вашей к священнику; ");
INSERT INTO russyn_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","он вознесет этот сноп пред Господом, чтобы вам приобрести благоволение; на другой день праздника вознесет его священник; ");
INSERT INTO russyn_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","и в день возношения снопа принесите во всесожжение Господу агнца однолетнего, без порока, ");
INSERT INTO russyn_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","и с ним хлебного приношения две десятых части ефы пшеничной муки, смешанной с елеем, в жертву Господу, в приятное благоухание, и возлияния к нему четверть гина вина; ");
INSERT INTO russyn_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","никакого нового хлеба, ни сушеных зерен, ни зерен сырых не ешьте до того дня, в который принесете приношения Богу вашему: это вечное постановление в роды ваши во всех жилищах ваших. ");
INSERT INTO russyn_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Отсчитайте себе от первого дня после праздника, от того дня, в который приносите сноп потрясания, семь полных недель, ");
INSERT INTO russyn_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","до первого дня после седьмой недели отсчитайте пятьдесят дней, и тогда принесите новое хлебное приношение Господу: ");
INSERT INTO russyn_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","от жилищ ваших приносите два хлеба возношения, которые должны состоять из двух десятых частей ефы пшеничной муки и должны быть испечены кислые, как первый плод Господу; ");
INSERT INTO russyn_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","вместе с хлебами представьте семь агнцев без порока, однолетних, и из крупного скота одного тельца и двух овнов без порока; да будет это во всесожжение Господу, и хлебное приношение и возлияние к ним, в жертву, в приятное благоухание Господу. ");
INSERT INTO russyn_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Приготовьте также из стада коз одного козла в жертву за грех и двух однолетних агнцев в жертву мирную вместе с хлебом первого плода; ");
INSERT INTO russyn_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","священник должен принести это, потрясая пред Господом, вместе с потрясаемыми хлебами первого плода и с двумя агнцами, и это будет святынею Господу; священнику, который приносит, это принадлежит; ");
INSERT INTO russyn_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","и созывайте народ в сей день, священное собрание да будет у вас, никакой работы не работайте: это постановление вечное во всех жилищах ваших в роды ваши. ");
INSERT INTO russyn_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Когда будете жать жатву на земле вашей, не дожинай до края поля твоего, когда жнешь, и оставшегося от жатвы твоей не подбирай; бедному и пришельцу оставь это. Я Господь, Бог ваш. ");
INSERT INTO russyn_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","скажи сынам Израилевым: в седьмой месяц, в первый день месяца да будет у вас покой, праздник труб, священное собрание да будет у вас; ");
INSERT INTO russyn_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","никакой работы не работайте и приносите жертву Господу. ");
INSERT INTO russyn_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","также в девятый день седьмого месяца сего, день очищения, да будет у вас священное собрание; смиряйте души ваши и приносите жертву Господу; ");
INSERT INTO russyn_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","никакого дела не делайте в день сей, ибо это день очищения, дабы очистить вас пред лицем Господа, Бога вашего; ");
INSERT INTO russyn_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","а всякая душа, которая не смирит себя в этот день, истребится из народа своего; ");
INSERT INTO russyn_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","и если какая душа будет делать какое-нибудь дело в день сей, Я истреблю ту душу из народа ее; ");
INSERT INTO russyn_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","никакого дела не делайте: это постановление вечное в роды ваши, во всех жилищах ваших; ");
INSERT INTO russyn_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","это для вас суббота покоя, и смиряйте души ваши, с вечера девятого дня месяца; от вечера до вечера десятого дня месяца празднуйте субботу вашу. ");
INSERT INTO russyn_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","скажи сынам Израилевым: с пятнадцатого дня того же седьмого месяца праздник кущей, семь дней Господу; ");
INSERT INTO russyn_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","в первый день священное собрание, никакой работы не работайте; ");
INSERT INTO russyn_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","в течение семи дней приносите жертву Господу; в восьмой день священное собрание да будет у вас, и приносите жертву Господу: это отдание праздника, никакой работы не работайте. ");
INSERT INTO russyn_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Вот праздники Господни, в которые должно созывать священные собрания, чтобы приносить в жертву Господу всесожжение, хлебное приношение, заколаемые жертвы и возлияния, каждое в свой день, ");
INSERT INTO russyn_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","кроме суббот Господних и кроме даров ваших, и кроме всех обетов ваших и кроме всего приносимого по усердию вашему, что вы даете Господу. ");
INSERT INTO russyn_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","А в пятнадцатый день седьмого месяца, когда вы собираете произведения земли, празднуйте праздник Господень семь дней: в первый день покой и в восьмой день покой; ");
INSERT INTO russyn_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","в первый день возьмите себе ветви красивых дерев, ветви пальмовые и ветви дерев широколиственных и верб речных, и веселитесь пред Господом Богом вашим семь дней; ");
INSERT INTO russyn_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","и празднуйте этот праздник Господень семь дней в году: это постановление вечное в роды ваши; в седьмой месяц празднуйте его; ");
INSERT INTO russyn_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","в кущах живите семь дней; всякий туземец Израильтянин должен жить в кущах, ");
INSERT INTO russyn_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","чтобы знали роды ваши, что в кущах поселил Я сынов Израилевых, когда вывел их из земли Египетской. Я Господь, Бог ваш. ");
INSERT INTO russyn_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","И объявил Моисей сынам Израилевым о праздниках Господних. ");
INSERT INTO russyn_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","прикажи сынам Израилевым, чтоб они принесли тебе елея чистого, выбитого, для освещения, чтобы непрестанно горел светильник; ");
INSERT INTO russyn_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","вне завесы ковчега откровения в скинии собрания Аарон и сыны его должны ставить оный пред Господом от вечера до утра всегда: это вечное постановление в роды ваши; ");
INSERT INTO russyn_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","на подсвечнике чистом должны они ставить светильник пред Господом всегда. ");
INSERT INTO russyn_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","И возьми пшеничной муки и испеки из нее двенадцать хлебов; в каждом хлебе должны быть две десятых ефы; ");
INSERT INTO russyn_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","и положи их в два ряда, по шести в ряд, на чистом столе пред Господом; ");
INSERT INTO russyn_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","и положи на каждый ряд чистого ливана и соли, и будет это при хлебе, в память, в жертву Господу; ");
INSERT INTO russyn_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","в каждый день субботы постоянно должно полагать их пред Господом от сынов Израилевых: это завет вечный; ");
INSERT INTO russyn_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","они будут принадлежать Аарону и сынам его, которые будут есть их на святом месте, ибо это великая святыня для них из жертв Господних: это постановление вечное. ");
INSERT INTO russyn_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","И вышел сын одной Израильтянки, родившейся от Египтянина, к сынам Израилевым, и поссорился в стане сын Израильтянки с Израильтянином; ");
INSERT INTO russyn_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","хулил сын Израильтянки имя Господне и злословил. И привели его к Моисею. И мя же матери его Саломиф, дочь Давриина, из племени Данова; ");
INSERT INTO russyn_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","и посадили его под стражу, доколе не будет объявлена им воля Господня. ");
INSERT INTO russyn_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","выведи злословившего вон из стана, и все слышавшие пусть положат руки свои на голову его, и все общество побьет его камнями; ");
INSERT INTO russyn_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","и сынам Израилевым скажи: кто будет злословить Бога своего, тот понесет грех свой; ");
INSERT INTO russyn_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","и хулитель имени Господня должен умереть, камнями побьет его все общество: пришлец ли, туземец ли станет хулить имя Господне, предан будет смерти. ");
INSERT INTO russyn_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Кто убьет какого-либо человека, тот предан будет смерти. ");
INSERT INTO russyn_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Кто убьет скотину, должен заплатить за нее, скотину за скотину. ");
INSERT INTO russyn_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Кто сделает повреждение на теле ближнего своего, тому должно сделать то же, что он сделал: ");
INSERT INTO russyn_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","перелом за перелом, око за око, зуб за зуб; как он сделал повреждение на теле человека, так и ему должно сделать. ");
INSERT INTO russyn_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Кто убьет скотину, должен заплатить за нее; а кто убьет человека, того должно предать смерти. ");
INSERT INTO russyn_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Один суд должен быть у вас, как для пришельца, так и для туземца; ибо Я Господь, Бог ваш. ");
INSERT INTO russyn_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","И сказал Моисей сынам Израилевым; и вывели злословившего вон из стана, и побили его камнями, и сделали сыны Израилевы, как повелел Господь Моисею. ");
INSERT INTO russyn_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","И сказал Господь Моисею на горе Синае, говоря: ");
INSERT INTO russyn_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","объяви сынам Израилевым и скажи им: когда придете в землю, которую Я даю вам, тогда земля должна покоиться в субботу Господню; ");
INSERT INTO russyn_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","шесть лет засевай поле твое и шесть лет обрезывай виноградник твой, и собирай произведения их, ");
INSERT INTO russyn_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","а в седьмой год да будет суббота покоя земли, суббота Господня: поля твоего не засевай и виноградника твоего не обрезывай; ");
INSERT INTO russyn_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","что само вырастет на жатве твоей, не сжинай, и гроздов с необрезанных лоз твоих не снимай; да будет это год покоя земли; ");
INSERT INTO russyn_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","и будет это в продолжение субботы земли всем вам в пищу, тебе и рабу твоему, и рабе твоей, и наемнику твоему, и поселенцу твоему, поселившемуся у тебя; ");
INSERT INTO russyn_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","и скоту твоему и зверям, которые на земле твоей, да будут все произведения ее в пищу. ");
INSERT INTO russyn_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","И насчитай себе семь субботних лет, семь раз по семи лет, чтоб было у тебя в семи субботних годах сорок девять лет; ");
INSERT INTO russyn_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","и воструби трубою в седьмой месяц, в десятый день месяца, в день очищения вострубите трубою по всей земле вашей; ");
INSERT INTO russyn_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","и освятите пятидесятый год и объявите свободу на земле всем жителям ее: да будет это у вас юбилей; и возвратитесь каждый во владение свое, и каждый возвратитесь в свое племя. ");
INSERT INTO russyn_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Пятидесятый год да будет у вас юбилей: не сейте и не жните, что само вырастет на земле, и не снимайте ягод с необрезанных лоз ее, ");
INSERT INTO russyn_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","ибо это юбилей: священным да будет он для вас; с поля ешьте произведения ее. ");
INSERT INTO russyn_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","В юбилейный год возвратитесь каждый во владение свое. ");
INSERT INTO russyn_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Если будешь продавать что ближнему твоему или будешь покупать что у ближнего твоего, не обижайте друг друга; ");
INSERT INTO russyn_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","по расчислению лет после юбилея ты должен покупать у ближнего твоего, и по расчислению лет дохода он должен продавать тебе; ");
INSERT INTO russyn_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","если много остается лет, умножь цену; а если мало лет остается, уменьши цену, ибо известное число лет жатв он продает тебе. ");
INSERT INTO russyn_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Не обижайте один другого; бойся Бога твоего, ибо Я Господь, Бог ваш. ");
INSERT INTO russyn_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Исполняйте постановления Мои, и храните законы Мои и исполняйте их, и будете жить спокойно на земле; ");
INSERT INTO russyn_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","и будет земля давать плод свой, и будете есть досыта, и будете жить спокойно на ней. ");
INSERT INTO russyn_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Если скажете: что же нам есть в седьмой год, когда мы не будем ни сеять, ни собирать произведений наших? ");
INSERT INTO russyn_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Я пошлю благословение Мое на вас в шестой год, и он принесет произведений на три года; ");
INSERT INTO russyn_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","и будете сеять в восьмой год, но есть будете произведения старые до девятого года; доколе не поспеют произведения его, будете есть старое. ");
INSERT INTO russyn_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Землю не должно продавать навсегда, ибо Моя земля: вы пришельцы и поселенцы у Меня; ");
INSERT INTO russyn_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","по всей земле владения вашего дозволяйте выкуп земли. ");
INSERT INTO russyn_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Если брат твой обеднеет и продаст от владения своего, то придет близкий его родственник и выкупит проданное братом его; ");
INSERT INTO russyn_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","если же некому за него выкупить, но сам он будет иметь достаток и найдет, сколько нужно на выкуп, ");
INSERT INTO russyn_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","то пусть он расчислит годы продажи своей и возвратит остальное тому, кому он продал, и вступит опять во владение свое; ");
INSERT INTO russyn_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","если же не найдет рука его, сколько нужно возвратить ему, то проданное им останется в руках покупщика до юбилейного года, а в юбилейный год отойдет оно, и он опять вступит во владение свое. ");
INSERT INTO russyn_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Если кто продаст жилой дом в городе, огражденном стеною, то выкупить его можно до истечения года от продажи его: в течение года выкупить его можно; ");
INSERT INTO russyn_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","если же не будет он выкуплен до истечения целого года, то дом, который в городе, имеющем стену, останется навсегда у купившего его в роды его, и в юбилей не отойдет от него. ");
INSERT INTO russyn_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","А домы в селениях, вокруг которых нет стены, должно считать наравне с полем земли: выкупать их всегда можно, и в юбилей они отходят. ");
INSERT INTO russyn_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","А города левитов, домы в городах владения их, левитам всегда можно выкупать; ");
INSERT INTO russyn_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","а кто из левитов не выкупит, то проданный дом в городе владения их в юбилей отойдет, потому что домы в городах левитских составляют их владение среди сынов Израилевых; ");
INSERT INTO russyn_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","и полей вокруг городов их продавать нельзя, потому что это вечное владение их. ");
INSERT INTO russyn_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Если брат твой обеднеет и придет в упадок у тебя, то поддержи его, пришлец ли он, или поселенец, чтоб он жил с тобою; ");
INSERT INTO russyn_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","не бери от него роста и прибыли и бойся Бога твоего, чтоб жил брат твой с тобою; ");
INSERT INTO russyn_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","серебра твоего не отдавай ему в рост и хлеба твоего не отдавай ему для получения прибыли. ");
INSERT INTO russyn_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Я Господь, Бог ваш, Который вывел вас из земли Египетской, чтобы дать вам землю Ханаанскую, чтоб быть вашим Богом. ");
INSERT INTO russyn_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Когда обеднеет у тебя брат твой и продан будет тебе, то не налагай на него работы рабской: ");
INSERT INTO russyn_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","он должен быть у тебя как наемник, как поселенец; до юбилейного года пусть работает у тебя, ");
INSERT INTO russyn_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","а тогда пусть отойдет он от тебя, сам и дети его с ним, и возвратится в племя свое, и вступит опять во владение отцов своих, ");
INSERT INTO russyn_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","потому что они - Мои рабы, которых Я вывел из земли Египетской: не должно продавать их, как продают рабов; ");
INSERT INTO russyn_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","не господствуй над ним с жестокостью и бойся Бога твоего. ");
INSERT INTO russyn_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","А чтобы раб твой и рабыня твоя были у тебя, то покупайте себе раба и рабыню у народов, которые вокруг вас; ");
INSERT INTO russyn_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","также и из детей поселенцев, поселившихся у вас, можете покупать, и из племени их, которое у вас, которое у них родилось в земле вашей, и они могут быть вашей собственностью; ");
INSERT INTO russyn_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","можете передавать их в наследство и сынам вашим по себе, как имение; вечно владейте ими, как рабами. А над братьями вашими, сынами Израилевыми, друг над другом, не господствуйте с жестокостью. ");
INSERT INTO russyn_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Если пришлец или поселенец твой будет иметь достаток, а брат твой пред ним обеднеет и продастся пришельцу, поселившемуся у тебя, или кому-нибудь из племени пришельца, ");
INSERT INTO russyn_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","то после продажи можно выкупить его; кто-нибудь из братьев его должен выкупить его, ");
INSERT INTO russyn_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","или дядя его, или сын дяди его должен выкупить его, или кто-нибудь из родства его, из племени его, должен выкупить его; или если будет иметь достаток, сам выкупится. ");
INSERT INTO russyn_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","И он должен рассчитаться с купившим его, начиная от того года, когда он продал себя, до года юбилейного, и серебро, за которое он продал себя, должно отдать ему по числу лет; как временный наемник он должен быть у него; ");
INSERT INTO russyn_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","и если еще много остается лет, то по мере их он должен отдать в выкуп за себя серебро, за которое он куплен; ");
INSERT INTO russyn_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","если же мало остается лет до юбилейного года, то он должен сосчитать и по мере лет отдать за себя выкуп. ");
INSERT INTO russyn_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Он должен быть у него, как наемник, во все годы; он не должен господствовать над ним с жестокостью в глазах твоих. ");
INSERT INTO russyn_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Если же он не выкупится таким образом, то в юбилейный год отойдет сам и дети его с ним, ");
INSERT INTO russyn_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","потому что сыны Израилевы Мои рабы; они Мои рабы, которых Я вывел из земли Египетской. Я Господь, Бог ваш. ");
INSERT INTO russyn_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Не делайте себе кумиров и изваяний, и столбов не ставьте у себя, и камней с изображениями не кладите в земле вашей, чтобы кланяться пред ними, ибо Я Господь Бог ваш. ");
INSERT INTO russyn_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Субботы Мои соблюдайте и святилище Мое чтите: Я Господь. ");
INSERT INTO russyn_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Если вы будете поступать по уставам Моим и заповеди Мои будете хранить и исполнять их, ");
INSERT INTO russyn_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","то Я дам вам дожди в свое время, и земля даст произрастения свои, и дерева полевые дадут плод свой; ");
INSERT INTO russyn_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","и молотьба хлеба будет достигать у вас собирания винограда, собирание винограда будет достигать посева, и будете есть хлеб свой досыта, и будете жить на земле вашей безопасно; ");
INSERT INTO russyn_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","пошлю мир на землю вашу, ляжете, и никто вас не обеспокоит, сгоню лютых зверей с земли вашей, и меч не пройдет по земле вашей; ");
INSERT INTO russyn_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","и будете прогонять врагов ваших, и падут они пред вами от меча; ");
INSERT INTO russyn_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","пятеро из вас прогонят сто, и сто из вас прогонят тьму, и падут враги ваши пред вами от меча; ");
INSERT INTO russyn_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","призрю на вас и благословлю вас, и плодородными сделаю вас, и размножу вас, и буду тверд в завете Моем с вами; ");
INSERT INTO russyn_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","и будете есть старое прошлогоднее, и выбросите старое ради нового; ");
INSERT INTO russyn_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","и поставлю жилище Мое среди вас, и душа Моя не возгнушается вами; ");
INSERT INTO russyn_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","и буду ходить среди вас и буду вашим Богом, а вы будете Моим народом. ");
INSERT INTO russyn_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Я Господь Бог ваш, Который вывел вас из земли Египетской, чтоб вы не были там рабами, и сокрушил узы ярма вашего, и повел вас с поднятою головою. ");
INSERT INTO russyn_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Если же не послушаете Меня и не будете исполнять всех заповедей сих, ");
INSERT INTO russyn_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","и если презрите Мои постановления, и если душа ваша возгнушается Моими законами, так что вы не будете исполнять всех заповедей Моих, нарушив завет Мой, ");
INSERT INTO russyn_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","то и Я поступлю с вами так: пошлю на вас ужас, чахлость и горячку, от которых истомятся глаза и измучится душа, и будете сеять семена ваши напрасно, и враги ваши съедят их; ");
INSERT INTO russyn_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","обращу лице Мое на вас, и падете пред врагами вашими, и будут господствовать над вами неприятели ваши, и побежите, когда никто не гонится за вами. ");
INSERT INTO russyn_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Если и при всем том не послушаете Меня, то Я всемеро увеличу наказание за грехи ваши, ");
INSERT INTO russyn_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","и сломлю гордое упорство ваше, и небо ваше сделаю, как железо, и землю вашу, как медь; ");
INSERT INTO russyn_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","и напрасно будет истощаться сила ваша, и земля ваша не даст произрастений своих, и дерева земли вашей не дадут плодов своих. ");
INSERT INTO russyn_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Если же после сего пойдете против Меня и не захотите слушать Меня, то Я прибавлю вам ударов всемеро за грехи ваши: ");
INSERT INTO russyn_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","пошлю на вас зверей полевых, которые лишат вас детей, истребят скот ваш и вас уменьшат, так что опустеют дороги ваши. ");
INSERT INTO russyn_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Если и после сего не исправитесь и пойдете против Меня, ");
INSERT INTO russyn_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","то и Я в ярости пойду против вас и поражу вас всемеро за грехи ваши, ");
INSERT INTO russyn_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","и наведу на вас мстительный меч в отмщение за завет; если же вы укроетесь в города ваши, то пошлю на вас язву, и преданы будете в руки врага; ");
INSERT INTO russyn_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","хлеб, подкрепляющий человека, истреблю у вас; десять женщин будут печь хлеб ваш в одной печи и будут отдавать хлеб ваш весом; вы будете есть и не будете сыты. ");
INSERT INTO russyn_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Если же и после сего не послушаете Меня и пойдете против Меня, ");
INSERT INTO russyn_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","то и Я в ярости пойду против вас и накажу вас всемеро за грехи ваши, ");
INSERT INTO russyn_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","и будете есть плоть сынов ваших, и плоть дочерей ваших будете есть; ");
INSERT INTO russyn_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","разорю высоты ваши и разрушу столбы ваши, и повергну трупы ваши на обломки идолов ваших, и возгнушается душа Моя вами; ");
INSERT INTO russyn_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","города ваши сделаю пустынею, и опустошу святилища ваши, и не буду обонять приятного благоухания жертв ваших; ");
INSERT INTO russyn_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","опустошу землю вашу, так что изумятся о ней враги ваши, поселившиеся на ней; ");
INSERT INTO russyn_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","а вас рассею между народами и обнажу вслед вас меч, и будет земля ваша пуста и города ваши разрушены. ");
INSERT INTO russyn_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Тогда удовлетворит себя земля за субботы свои во все дни запустения своего; когда вы будете в земле врагов ваших, тогда будет покоиться земля и удовлетворит себя за субботы свои; ");
INSERT INTO russyn_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","во все дни запустения своего будет она покоиться, сколько ни покоилась в субботы ваши, когда вы жили на ней. ");
INSERT INTO russyn_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Оставшимся из вас пошлю в сердца робость в земле врагов их, и шум колеблющегося листа погонит их, и побегут, как от меча, и падут, когда никто не преследует, ");
INSERT INTO russyn_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","и споткнутся друг на друга, как от меча, между тем как никто не преследует, и не будет у вас силы противостоять врагам вашим; ");
INSERT INTO russyn_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","и погибнете между народами, и пожрет вас земля врагов ваших; ");
INSERT INTO russyn_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","а оставшиеся из вас исчахнут за свои беззакония в землях врагов ваших и за беззакония отцов своих исчахнут; ");
INSERT INTO russyn_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","тогда признаются они в беззаконии своем и в беззаконии отцов своих, как они совершали преступления против Меня и шли против Меня, ");
INSERT INTO russyn_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","за что и Я в ярости шел против них и ввел их в землю врагов их; тогда покорится необрезанное сердце их, и тогда потерпят они за беззакония свои. ");
INSERT INTO russyn_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","И Я вспомню завет Мой с Иаковом и завет Мой с Исааком, и завет Мой с Авраамом вспомню, и землю вспомню; ");
INSERT INTO russyn_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","тогда как земля оставлена будет ими и будет удовлетворять себя за субботы свои, опустев от них, и они будут терпеть за свое беззаконие, за то, что презирали законы Мои и душа их гнушалась постановлениями Моими, ");
INSERT INTO russyn_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","и тогда как они будут в земле врагов их,- Я не презрю их и не возгнушаюсь ими до того, чтоб истребить их, чтоб разрушить завет Мой с ними, ибо Я Господь, Бог их; ");
INSERT INTO russyn_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","вспомню для них завет с предками, которых вывел Я из земли Египетской пред глазами народов, чтоб быть их Богом. Я Господь. ");
INSERT INTO russyn_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Вот постановления и определения и законы, которые постановил Господь между Собою и между сынами Израилевыми на горе Синае, чрез Моисея. ");
INSERT INTO russyn_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","объяви сынам Израилевым и скажи им: если кто дает обет посвятить душу Господу по оценке твоей, ");
INSERT INTO russyn_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","то оценка твоя мужчине от двадцати лет до шестидесяти должна быть пятьдесят сиклей серебряных, по сиклю священному; ");
INSERT INTO russyn_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","если же это женщина, то оценка твоя должна быть тридцать сиклей; ");
INSERT INTO russyn_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","от пяти лет до двадцати оценка твоя мужчине должна быть двадцать сиклей, а женщине десять сиклей; ");
INSERT INTO russyn_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","а от месяца до пяти лет оценка твоя мужчине должна быть пять сиклей серебра, а женщине оценка твоя три сикля серебра; ");
INSERT INTO russyn_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","от шестидесяти лет и выше мужчине оценка твоя должна быть пятнадцать сиклей серебра, а женщине десять сиклей. ");
INSERT INTO russyn_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Если же он беден и не в силах отдать по оценке твоей, то пусть представят его священнику, и священник пусть оценит его: соразмерно с состоянием давшего обет пусть оценит его священник. ");
INSERT INTO russyn_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Если же то будет скот, который приносят в жертву Господу, то все, что дано Господу, должно быть свято: ");
INSERT INTO russyn_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","не должно выменивать его и заменять хорошее худым или худое хорошим; если же станет кто заменять скотину скотиною, то и она и замен ее будет святынею. ");
INSERT INTO russyn_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Если же то будет какая-нибудь скотина нечистая, которую не приносят в жертву Господу, то должно представить скотину священнику, ");
INSERT INTO russyn_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","и священник оценит ее, хороша ли она, или худа, и как оценит священник, так и должно быть; ");
INSERT INTO russyn_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","если же кто хочет выкупить ее, то пусть прибавит пятую долю к оценке твоей. ");
INSERT INTO russyn_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Если кто посвящает дом свой в святыню Господу, то священник должен оценить его, хорош ли он, или худ, и как оценит его священник, так и состоится; ");
INSERT INTO russyn_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","если же посвятивший захочет выкупить дом свой, то пусть прибавит пятую часть серебра оценки твоей, и тогда будет его. ");
INSERT INTO russyn_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Если поле из своего владения посвятит кто Господу, то оценка твоя должна быть по мере посева: за посев хомера ячменя пятьдесят сиклей серебра; ");
INSERT INTO russyn_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","если от юбилейного года посвящает кто поле свое, должно состояться по оценке твоей; ");
INSERT INTO russyn_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","если же после юбилея посвящает кто поле свое, то священник должен рассчитать серебро по мере лет, оставшихся до юбилейного года, и должно убавить из оценки твоей; ");
INSERT INTO russyn_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","если же захочет выкупить поле посвятивший его, то пусть он прибавит пятую часть серебра оценки твоей, и оно останется за ним; ");
INSERT INTO russyn_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","если же он не выкупит поля и будет продано поле другому человеку, то уже нельзя выкупить: ");
INSERT INTO russyn_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","поле то, когда оно в юбилей отойдет, будет святынею Господу, как бы поле заклятое; священнику достанется оно во владение. ");
INSERT INTO russyn_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","А если кто посвятит Господу поле купленное, которое не из полей его владения, ");
INSERT INTO russyn_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","то священник должен рассчитать ему количество оценки до юбилейного года, и должен он отдать по расчету в тот же день, как святыню Господню; ");
INSERT INTO russyn_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","поле же в юбилейный год перейдет опять к тому, у кого куплено, кому принадлежит владение той земли. ");
INSERT INTO russyn_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Всякая оценка твоя должна быть по сиклю священному, двадцать гер должно быть в сикле. ");
INSERT INTO russyn_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Только первенцев из скота, которые по первенству принадлежат Господу, не должен никто посвящать: вол ли то, или мелкий скот,- Господни они. ");
INSERT INTO russyn_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Если же скот нечистый, то должно выкупить по оценке твоей и приложить к тому пятую часть; если не выкупят, то должно продать по оценке твоей. ");
INSERT INTO russyn_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Только все заклятое, что под заклятием отдает человек Господу из своей собственности,- человека ли, скотину ли, поле ли своего владения,- не продается и не выкупается: все заклятое есть великая святыня Господня; ");
INSERT INTO russyn_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","все заклятое, что заклято от людей, не выкупается: оно должно быть предано смерти. ");
INSERT INTO russyn_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","И всякая десятина на земле из семян земли и из плодов дерева принадлежит Господу: это святыня Господня; ");
INSERT INTO russyn_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","если же кто захочет выкупить десятину свою, то пусть приложит к цене ее пятую долю. ");
INSERT INTO russyn_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","И всякую десятину из крупного и мелкого скота, из всего, что проходит под жезлом десятое, должно посвящать Господу; ");
INSERT INTO russyn_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","не должно разбирать, хорошее ли то, или худое, и не должно заменять его; если же кто заменит его, то и само оно и замен его будет святынею и не может быть выкуплено. ");
INSERT INTO russyn_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Вот заповеди, которые заповедал Господь Моисею для сынов Израилевых на горе Синае. ");
INSERT INTO russyn_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","И сказал Господь Моисею в пустыне Синайской, в скинии собрания, в первый день второго месяца, во второй год по выходе их из земли Египетской, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","исчислите все общество сынов Израилевых по родам их, по семействам их, по числу имен, всех мужеского пола поголовно: ");
INSERT INTO russyn_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","от двадцати лет и выше, всех годных для войны у Израиля, по ополчениям их исчислите их - ты и Аарон; ");
INSERT INTO russyn_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","с вами должны быть из каждого колена по одному человеку, который в роде своем есть главный. ");
INSERT INTO russyn_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","И вот имена мужей, которые будут с вами: от Рувима Елицур, сын Шедеура; ");
INSERT INTO russyn_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","от Симеона Шелумиил, сын Цуришаддая; ");
INSERT INTO russyn_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","от Иуды Наассон, сын Аминадава; ");
INSERT INTO russyn_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","от Иссахара Нафанаил, сын Цуара; ");
INSERT INTO russyn_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","от Завулона Елиав, сын Хелона; ");
INSERT INTO russyn_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","от сынов Иосифа: от Ефрема Елишама, сын Аммиуда; от Манассии Гамалиил, сын Педацура; ");
INSERT INTO russyn_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","от Вениамина Авидан, сын Гидеония; ");
INSERT INTO russyn_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","от Дана Ахиезер, сын Аммишаддая; ");
INSERT INTO russyn_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","от Асира Пагиил, сын Охрана; ");
INSERT INTO russyn_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","от Гада Елиасаф, сын Регуила; ");
INSERT INTO russyn_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","от Неффалима Ахира, сын Енана. ");
INSERT INTO russyn_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Это - избранные мужи общества, начальники колен отцов своих, главы тысяч Израилевых. ");
INSERT INTO russyn_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","И взял Моисей и Аарон мужей сих, которые названы поименно, ");
INSERT INTO russyn_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","и собрали они все общество в первый день второго месяца. И объявили они родословия свои, по родам их, по семействам их, по числу имен, от двадцати лет и выше, поголовно, ");
INSERT INTO russyn_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","как повелел Господь Моисею. И сделал он счисление им в пустыне Синайской. ");
INSERT INTO russyn_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","И было сынов Рувима, первенца Израилева, по родам их, по племенам их, по семействам их, по числу имен, поголовно, всех мужеского пола, от двадцати лет и выше, всех годных для войны, ");
INSERT INTO russyn_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","исчислено в колене Рувимовом сорок шесть тысяч пятьсот. ");
INSERT INTO russyn_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Сынов Симеона по родам их, по племенам их, по семействам их, по числу имен, поголовно, всех мужеского пола, от двадцати лет и выше, всех годных для войны, ");
INSERT INTO russyn_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","исчислено в колене Симеоновом пятьдесят девять тысяч триста. ");
INSERT INTO russyn_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Сынов Гада по родам их, по племенам их, по семействам их, по числу имен их, поголовно, всех мужеского пола, от двадцати лет и выше, всех годных для войны, ");
INSERT INTO russyn_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","исчислено в колене Гадовом сорок пять тысяч шестьсот пятьдесят. ");
INSERT INTO russyn_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Сынов Иуды по родам их, по племенам их, по семействам их, по числу имен их, поголовно, всех мужеского пола, от двадцати лет и выше, всех годных для войны, ");
INSERT INTO russyn_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","исчислено в колене Иудином семьдесят четыре тысячи шестьсот. ");
INSERT INTO russyn_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Сынов Иссахара по родам их, по племенам их, по семействам их, по числу имен их, поголовно, всех мужеского пола, от двадцати лет и выше, всех годных для войны, ");
INSERT INTO russyn_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","исчислено в колене Иссахаровом пятьдесят четыре тысячи четыреста. ");
INSERT INTO russyn_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Сынов Завулона по родам их, по племенам их, по семействам их, по числу имен их, поголовно, всех мужеского пола, от двадцати лет и выше, всех годных для войны, ");
INSERT INTO russyn_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","исчислено в колене Завулоновом пятьдесят семь тысяч четыреста. ");
INSERT INTO russyn_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Сынов Иосифа, сынов Ефрема по родам их, по племенам их, по семействам их, по числу имен их, поголовно, всех мужеского пола, от двадцати лет и выше, всех годных для войны, ");
INSERT INTO russyn_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","исчислено в колене Ефремовом сорок тысяч пятьсот. ");
INSERT INTO russyn_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Сынов Манассии по родам их, по племенам их, по семействам их, по числу имен их, поголовно, всех мужеского пола, от двадцати лет и выше, всех годных для войны, ");
INSERT INTO russyn_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","исчислено в колене Манассиином тридцать две тысячи двести. ");
INSERT INTO russyn_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Сынов Вениамина по родам их, по племенам их, по семействам их, по числу имен их, поголовно, всех мужеского пола, от двадцати лет и выше, всех годных для войны, ");
INSERT INTO russyn_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","исчислено в колене Вениаминовом тридцать пять тысяч четыреста. ");
INSERT INTO russyn_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Сынов Дана по родам их, по племенам их, по семействам их, по числу имен их, поголовно, всех мужеского пола, от двадцати лет и выше, всех годных для войны, ");
INSERT INTO russyn_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","исчислено в колене Дановом шестьдесят две тысячи семьсот. ");
INSERT INTO russyn_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Сынов Асира по родам их, по племенам их, по семействам их, по числу имен их, поголовно, всех мужеского пола, от двадцати лет и выше, всех годных для войны, ");
INSERT INTO russyn_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","исчислено в колене Асировом сорок одна тысяча пятьсот. ");
INSERT INTO russyn_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Сынов Неффалима по родам их, по племенам их, по семействам их, по числу имен их, поголовно, всех мужеского пола, от двадцати лет и выше, всех годных для войны, ");
INSERT INTO russyn_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","исчислено в колене Неффалимовом пятьдесят три тысячи четыреста. ");
INSERT INTO russyn_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Вот вошедшие в исчисление, которых исчислил Моисей и Аарон и начальники Израиля - двенадцать человек, по одному человеку из каждого племени. ");
INSERT INTO russyn_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","И было всех, вошедших в исчисление, сынов Израилевых, по семействам их, от двадцати лет и выше, всех годных для войны у Израиля, ");
INSERT INTO russyn_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","и было всех вошедших в исчисление шестьсот три тысячи пятьсот пятьдесят. ");
INSERT INTO russyn_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","А левиты по поколениям отцов их не были исчислены между ними. ");
INSERT INTO russyn_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","только колена Левиина не вноси в перепись, и не исчисляй их вместе с сынами Израиля; ");
INSERT INTO russyn_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","но поручи левитам скинию откровения и все принадлежности ее и все, что при ней; пусть они носят скинию и все принадлежности ее, и служат при ней, и около скинии пусть ставят стан свой; ");
INSERT INTO russyn_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","и когда надобно переносить скинию, пусть поднимают ее левиты, и когда надобно остановиться скинии, пусть ставят ее левиты; а если приступит кто посторонний, предан будет смерти. ");
INSERT INTO russyn_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Сыны Израилевы должны становиться каждый в стане своем и каждый при своем знамени, по ополчениям своим; ");
INSERT INTO russyn_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","а левиты должны ставить стан около скинии откровения, чтобы не было гнева на общество сынов Израилевых, и будут левиты стоять на страже у скинии откровения. ");
INSERT INTO russyn_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","И сделали сыны Израилевы; как повелел Господь Моисею, так они и сделали. ");
INSERT INTO russyn_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","И сказал Господь Моисею и Аарону, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","сыны Израилевы должны каждый ставить стан свой при знамени своем, при знаках семейств своих; пред скиниею собрания вокруг должны ставить стан свой. ");
INSERT INTO russyn_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","С передней стороны к востоку ставят стан: знамя стана Иудина по ополчениям их, и начальник сынов Иуды Наассон, сын Аминадава, ");
INSERT INTO russyn_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","и воинства его, вошедших в исчисление его, семьдесят четыре тысячи шестьсот; ");
INSERT INTO russyn_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","после него ставит стан колено Иссахарово, и начальник сынов Иссахара Нафанаил, сын Цуара, ");
INSERT INTO russyn_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","и воинства его, вошедших в исчисление его, пятьдесят четыре тысячи четыреста; ");
INSERT INTO russyn_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","далее ставит стан колено Завулона, и начальник сынов Завулона Елиав, сын Хелона, ");
INSERT INTO russyn_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","и воинства его, вошедших в исчисление его, пятьдесят семь тысяч четыреста; ");
INSERT INTO russyn_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","всех вошедших в исчисление к стану Иуды сто восемьдесят шесть тысяч четыреста, по ополчениям их; первыми они должны отправляться. ");
INSERT INTO russyn_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Знамя стана Рувимова к югу, по ополчениям их, и начальник сынов Рувимовых Елицур, сын Шедеура, ");
INSERT INTO russyn_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","и воинства его, вошедших в исчисление его, сорок шесть тысяч пятьсот; ");
INSERT INTO russyn_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","подле него ставит стан колено Симеоново, и начальник сынов Симеона Шелумиил, сын Цуришаддая, ");
INSERT INTO russyn_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","и воинства его, вошедших в исчисление его, пятьдесят девять тысяч триста; ");
INSERT INTO russyn_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","потом колено Гада, и начальник сынов Гада Елиасаф, сын Регуила, ");
INSERT INTO russyn_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","и воинства его, вошедших в исчисление его, сорок пять тысяч шестьсот пятьдесят; ");
INSERT INTO russyn_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","всех вошедших в исчисление к стану Рувима сто пятьдесят одна тысяча четыреста пятьдесят, по ополчениям их; вторыми они должны отправляться. ");
INSERT INTO russyn_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Когда пойдет скиния собрания, стан левитов будет в середине станов. Как стоят, так и должны идти, каждый на своем месте при знаменах своих. ");
INSERT INTO russyn_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Знамя стана Ефремова по ополчениям их к западу, и начальник сынов Ефрема Елишама, сын Аммиуда, ");
INSERT INTO russyn_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","и воинства его, вошедших в исчисление его, сорок тысяч пятьсот; ");
INSERT INTO russyn_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","подле него колено Манассиино, и начальник сынов Манассии Гамалиил, сын Педацура, ");
INSERT INTO russyn_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","и воинства его, вошедших в исчисление его, тридцать две тысячи двести; ");
INSERT INTO russyn_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","потом колено Вениамина, и начальник сынов Вениамина Авидан, сын Гидеония, ");
INSERT INTO russyn_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","и воинства его, вошедших в исчисление его, тридцать пять тысяч четыреста; ");
INSERT INTO russyn_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","всех вошедших в исчисление к стану Ефрема сто восемь тысяч сто, по ополчениям их; третьими они должны отправляться. ");
INSERT INTO russyn_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Знамя стана Данова к северу, по ополчениям их, и начальник сынов Дана Ахиезер, сын Аммишаддая, ");
INSERT INTO russyn_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","и воинства его, вошедших в исчисление его, шестьдесят две тысячи семьсот; ");
INSERT INTO russyn_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","подле него ставит стан колено Асирово, и начальник сынов Асира Пагиил, сын Охрана, ");
INSERT INTO russyn_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","и воинства его, вошедших в исчисление его, сорок одна тысяча пятьсот; ");
INSERT INTO russyn_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","далее ставит стан колено Неффалима, и начальник сынов Неффалима Ахира, сын Енана, ");
INSERT INTO russyn_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","и воинства его, вошедших в исчисление его, пятьдесят три тысячи четыреста; ");
INSERT INTO russyn_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","всех вошедших в исчисление к стану Дана сто пятьдесят семь тысяч шестьсот; они должны идти последними при знаменах своих. ");
INSERT INTO russyn_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Вот вошедшие в исчисление сыны Израиля по семействам их. Всех вошедших в исчисление в станах, по ополчениям их, шестьсот три тысячи пятьсот пятьдесят. ");
INSERT INTO russyn_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","А левиты не вошли в исчисление вместе с сынами Израиля, как повелел Господь Моисею. ");
INSERT INTO russyn_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","И сделали сыны Израилевы все, что повелел Господь Моисею: так становились станами при знаменах своих и так шли каждый по племенам своим, по семействам своим. ");
INSERT INTO russyn_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Вот родословие Аарона и Моисея, когда говорил Господь Моисею на горе Синае, ");
INSERT INTO russyn_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","и вот имена сынов Аарона: первенец Надав, Авиуд, Елеазар и Ифамар; ");
INSERT INTO russyn_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","это имена сынов Аарона, священников, помазанных, которых он посвятил, чтобы священнодействовать; ");
INSERT INTO russyn_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","но Надав и Авиуд умерли пред лицем Господа, когда они принесли огонь чуждый пред лице Господа в пустыне Синайской, детей же у них не было; и остались священниками Елеазар и Ифамар при Аароне, отце своем. ");
INSERT INTO russyn_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","приведи колено Левиино, и поставь его пред Аароном священником, чтоб они служили ему; ");
INSERT INTO russyn_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","и пусть они будут на страже за него и на страже за все общество при скинии собрания, чтобы отправлять службы при скинии; ");
INSERT INTO russyn_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","и пусть хранят все вещи скинии собрания, и будут на страже за сынов Израилевых, чтобы отправлять службы при скинии; ");
INSERT INTO russyn_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","отдай левитов Аарону брату твоему и сынам его священникам в распоряжение: да будут они отданы ему из сынов Израилевых; ");
INSERT INTO russyn_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Аарону же и сынам его поручи скинию откровения, чтобы они наблюдали священническую должность свою и все, что при жертвеннике и за завесою; а если приступит кто посторонний, предан будет смерти. ");
INSERT INTO russyn_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","вот, Я взял левитов из сынов Израилевых вместо всех первенцев, разверзающих ложесна из сынов Израилевых они будут взамен их; левиты должны быть Мои, ");
INSERT INTO russyn_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","ибо все первенцы - Мои; в тот день, когда поразил Я всех первенцев в земле Египетской, освятил Я Себе всех первенцев Израилевых от человека до скота; они должны быть Мои. Я Господь. ");
INSERT INTO russyn_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","И сказал Господь Моисею в пустыне Синайской, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","исчисли сынов Левииных по семействам их, по родам их; всех мужеского пола от одного месяца и выше исчисли. ");
INSERT INTO russyn_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","И исчислил их Моисей и Аарон по слову Господню, как повелено. ");
INSERT INTO russyn_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","И вот сыны Левиины по именам их: Гирсон, Кааф и Мерари. ");
INSERT INTO russyn_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","И вот имена сынов Гирсоновых по родам их: Ливни и Шимей. ");
INSERT INTO russyn_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","И сыны Каафа по родам их: Амрам и Ицгар, Хеврон и Узиил. ");
INSERT INTO russyn_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","И сыны Мерари по родам их: Махли и Муши. Вот роды Левиины по семействам их. ");
INSERT INTO russyn_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","От Гирсона род Ливни и род Шимея: это роды Гирсоновы. ");
INSERT INTO russyn_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Исчисленных было всех мужеского пола, от одного месяца и выше, семь тысяч пятьсот. ");
INSERT INTO russyn_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Роды Гирсоновы должны становиться станом позади скинии на запад; ");
INSERT INTO russyn_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","начальник поколения сынов Гирсоновых Елиасаф, сын Лаелов; ");
INSERT INTO russyn_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","хранению сынов Гирсоновых в скинии собрания поручается скиния и покров ее, и завеса входа скинии собрания, ");
INSERT INTO russyn_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","и завесы двора и завеса входа двора, который вокруг скинии и жертвенника, и веревки ее, со всеми их принадлежностями. ");
INSERT INTO russyn_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","От Каафа род Амрама и род Ицгара, и род Хеврона, и род Узиила: это роды Каафа. ");
INSERT INTO russyn_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","По счету всех мужеского пола, от одного месяца и выше, восемь тысяч шестьсот, которые охраняли святилище. ");
INSERT INTO russyn_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Роды сынов Каафовых должны ставить стан свой на южной стороне скинии; ");
INSERT INTO russyn_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","начальник же поколения родов Каафовых Елцафан, сын Узиила; ");
INSERT INTO russyn_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","в хранении у них ковчег, стол, светильник, жертвенники, священные сосуды, которые употребляются при служении, и завеса со всеми принадлежностями ее. ");
INSERT INTO russyn_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Начальник над начальниками левитов Елеазар, сын Аарона священника; под его надзором те, которым вверено хранение святилища. ");
INSERT INTO russyn_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","От Мерари род Махли и род Муши: это роды Мерари; ");
INSERT INTO russyn_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","исчисленных по числу всех мужеского пола, от одного месяца и выше - шесть тысяч двести; ");
INSERT INTO russyn_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","начальник поколения родов Мерари Цуриил, сын Авихаила; они должны ставить стан свой на северной стороне скинии; ");
INSERT INTO russyn_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","хранению сынов Мерари поручаются брусья скинии и шесты ее, и столбы ее, и подножия ее и все вещи ее, со всем устройством их, ");
INSERT INTO russyn_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","и столбы двора со всех сторон и подножия их и колья их и веревки их. ");
INSERT INTO russyn_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","А с передней стороны скинии, к востоку пред скиниею собрания, должны ставить стан Моисей и Аарон и сыны его, которым вверено хранение святилища за сынов Израилевых; а если приступит кто посторонний, предан будет смерти. ");
INSERT INTO russyn_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Всех исчисленных левитов, которых исчислил Моисей и Аарон по повелению Господню, по родам их, всех мужеского пола, от одного месяца и выше, двадцать две тысячи. ");
INSERT INTO russyn_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","И сказал Господь Моисею: исчисли всех первенцев мужеского пола из сынов Израилевых, от одного месяца и выше, и пересчитай их поименно; ");
INSERT INTO russyn_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","и возьми левитов для Меня,- Я Господь,- вместо всех первенцев из сынов Израиля, а скот левитов вместо всего первородного скота сынов Израилевых. ");
INSERT INTO russyn_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","И исчислил Моисей, как повелел ему Господь, всех первенцев из сынов Израилевых ");
INSERT INTO russyn_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","и было всех первенцев мужеского пола, по числу имен, от одного месяца и выше, двадцать две тысячи двести семьдесят три. ");
INSERT INTO russyn_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","возьми левитов вместо всех первенцев из сынов Израиля и скот левитов вместо скота их; пусть левиты будут Мои. Я Господь. ");
INSERT INTO russyn_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","А в выкуп двухсот семидесяти трех, которые лишние против числа левитов, из первенцев Израильских, ");
INSERT INTO russyn_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","возьми по пяти сиклей за человека, по сиклю священному возьми, двадцать гер в сикле, ");
INSERT INTO russyn_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","и отдай серебро сие Аарону и сынам его, в выкуп за излишних против числа их. ");
INSERT INTO russyn_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","И взял Моисей серебро выкупа за излишних против числа замененных левитами, ");
INSERT INTO russyn_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","от первенцев Израилевых взял серебра тысячу триста шестьдесят пять сиклей, по сиклю священному, ");
INSERT INTO russyn_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","и отдал Моисей серебро выкупа за излишних Аарону и сынам его по слову Господню, как повелел Господь Моисею. ");
INSERT INTO russyn_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","И сказал Господь Моисею и Аарону, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","исчисли сынов Каафовых из сынов Левия по родам их, по семействам их, ");
INSERT INTO russyn_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","от тридцати лет и выше до пятидесяти лет, всех способных к службе, чтобы отправлять работы в скинии собрания. ");
INSERT INTO russyn_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Вот служение сынов Каафовых левитов по родам их, по семействам их, в скинии собрания: носить Святое Святых. ");
INSERT INTO russyn_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Когда стану надобно подняться в путь, Аарон и сыны его войдут, и снимут завесу закрывающую, и покроют ею ковчег откровения; ");
INSERT INTO russyn_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","и положат на нее покров из кож синего цвета, и сверх его накинут покрывало все из голубой шерсти, и вложат шесты его; ");
INSERT INTO russyn_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","и стол хлебов предложения накроют одеждою из голубой шерсти, и поставят на нем блюда, тарелки, чаши и кружки для возлияния, и хлеб его всегдашний должен быть на нем; ");
INSERT INTO russyn_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","и возложат на них одежду багряную, и покроют ее покровом из кожи синего цвета, и вложат шесты его; ");
INSERT INTO russyn_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","и возьмут одежду из голубой шерсти, и покроют светильник и лампады его, и щипцы его, и лотки его, и все сосуды для елея, которые употребляют при нем, ");
INSERT INTO russyn_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","и покроют его и все принадлежности его покровом из кож синих, и положат на носилки; ");
INSERT INTO russyn_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","и на золотой жертвенник возложат одежду из голубой шерсти, и покроют его покровом из кож синих, и вложат шесты его. ");
INSERT INTO russyn_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","И возьмут все вещи служебные, которые употребляются для служения во святилище, и положат в одежду из голубой шерсти, и покроют их покровом из кож синих, и положат на носилки. ");
INSERT INTO russyn_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","И очистят жертвенник от пепла и накроют его одеждою пурпуровою; ");
INSERT INTO russyn_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","и положат на него все сосуды его, которые употребляются для служения при нем - угольницы, вилки, лопатки и чаши, все сосуды жертвенника - и покроют его покровом из кож синих, и вложат шесты его. И возьмут пурпуровую одежду, и покроют умывальник и подножия его, и положат на них кожаное синее покрывало, и поставят на носилки. ");
INSERT INTO russyn_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Когда, при отправлении в путь стана, Аарон и сыны его покроют все святилище и все вещи святилища, тогда сыны Каафа подойдут, чтобы нести; но не должны они касаться святилища, чтобы не умереть. Сии части скинии собрания должны носить сыны Каафовы. ");
INSERT INTO russyn_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Елеазару, сыну Аарона священника, поручается елей для светильника и благовонное курение, и всегдашнее хлебное приношение и елей помазания,- поручается вся скиния и все, что в ней, святилище и принадлежности его. ");
INSERT INTO russyn_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","И сказал Господь Моисею и Аарону, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","не погубите колена племен Каафовых из среды левитов, ");
INSERT INTO russyn_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","но вот что сделайте им, чтобы они были живы и не умерли, когда приступают к Святому Святых: Аарон и сыны его пусть придут и поставят их каждого в служении его и у ноши его; ");
INSERT INTO russyn_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","но сами они не должны подходить смотреть святыню, когда покрывают ее, чтобы не умереть. ");
INSERT INTO russyn_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","исчисли и сынов Гирсона по семействам их, по родам их, ");
INSERT INTO russyn_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","от тридцати лет и выше до пятидесяти лет, исчисли их всех способных к службе, чтобы отправлять работы при скинии собрания. ");
INSERT INTO russyn_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Вот работы семейств Гирсоновых, при их служении и ношении тяжестей: ");
INSERT INTO russyn_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","они должны носить покровы скинии и скинию собрания, и покров ее, и покров кожаный синий, который поверх его, и завесу входа скинии собрания, ");
INSERT INTO russyn_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","и завесы двора, и завесу входа во двор, который вокруг скинии и жертвенника, и веревки их, и все вещи, принадлежащие к ним; и все, что делается при них, они должны работать; ");
INSERT INTO russyn_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","по повелению Аарона и сынов его должны производиться все службы сынов Гирсоновых при всяком ношении тяжестей и всякой работе их, и поручите их хранению все, что они носят; ");
INSERT INTO russyn_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","вот службы родов сынов Гирсоновых в скинии собрания, и вот что поручается их хранению под надзором Ифамара, сына Аарона, священника. ");
INSERT INTO russyn_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Сынов Мерариных по родам их, по семействам их исчисли, ");
INSERT INTO russyn_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","от тридцати лет и выше до пятидесяти лет, исчисли всех способных на службу, чтобы отправлять работы при скинии собрания. ");
INSERT INTO russyn_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Вот что они должны носить, по службе их при скинии собрания: брусья скинии и шесты ее, и столбы ее и подножия ее, ");
INSERT INTO russyn_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","и столбы двора со всех сторон и подножия их, и колья их, и веревки их, и все вещи при них и все принадлежности их; и поименно сосчитайте вещи, которые они обязаны носить; ");
INSERT INTO russyn_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","вот работы родов сынов Мерариных, по службе их при скинии собрания, под надзором Ифамара, сына Аарона, священника. ");
INSERT INTO russyn_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","И исчислили Моисей и Аарон и начальники общества сынов Каафовых по родам их и по семействам их, ");
INSERT INTO russyn_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","от тридцати лет и выше до пятидесяти лет, всех способных к службе, для работ в скинии собрания; ");
INSERT INTO russyn_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","и было исчислено, по родам их, две тысячи семьсот пятьдесят: ");
INSERT INTO russyn_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","это - исчисленные из родов Каафовых, все служащие при скинии собрания, которых исчислил Моисей и Аарон по повелению Господню, данному чрез Моисея. ");
INSERT INTO russyn_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","И исчислены сыны Гирсона по родам их и по семействам их, ");
INSERT INTO russyn_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","от тридцати лет и выше до пятидесяти лет, все способные к службе, для работ в скинии собрания; ");
INSERT INTO russyn_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","и было исчислено по родам их, по семействам их, две тысячи шестьсот тридцать: ");
INSERT INTO russyn_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","это - исчисленные из родов сынов Гирсона, все служащие при скинии собрания, которых исчислил Моисей и Аарон, по повелению Господню. ");
INSERT INTO russyn_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","И исчислены роды сынов Мерариных по родам их, по семействам их, ");
INSERT INTO russyn_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","от тридцати лет и выше до пятидесяти лет, все способные к службе, для работ при скинии собрания; ");
INSERT INTO russyn_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","и было исчислено по родам их, по семействам их, три тысячи двести: ");
INSERT INTO russyn_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","это - исчисленные из родов сынов Мерариных, которых исчислил Моисей и Аарон по повелению Господню, данному чрез Моисея. ");
INSERT INTO russyn_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","И исчислены все левиты, которых исчислил Моисей и Аарон и начальники Израиля по родам их и по семействам их, ");
INSERT INTO russyn_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","от тридцати лет и выше до пятидесяти лет, все способные к службе для работ и ношения в скинии собрания; ");
INSERT INTO russyn_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","и было исчислено их восемь тысяч пятьсот восемьдесят; ");
INSERT INTO russyn_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","по повелению Господню чрез Моисея определены они каждый к своей работе и ношению, и исчислены, как повелел Господь Моисею. ");
INSERT INTO russyn_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","повели сынам Израилевым выслать из стана всех прокаженных, и всех имеющих истечение, и всех осквернившихся от мертвого, ");
INSERT INTO russyn_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","и мужчин и женщин вышлите, за стан вышлите их, чтобы не оскверняли они станов своих, среди которых Я живу. ");
INSERT INTO russyn_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","И сделали так сыны Израилевы, и выслали их вон из стана; как говорил Господь Моисею, так и сделали сыны Израилевы. ");
INSERT INTO russyn_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","скажи сынам Израилевым: если мужчина или женщина сделает какой-либо грех против человека, и чрез это сделает преступление против Господа, и виновна будет душа та, ");
INSERT INTO russyn_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","то пусть исповедаются во грехе своем, который они сделали, и возвратят сполна то, в чем виновны, и прибавят к тому пятую часть и отдадут тому, против кого согрешили; ");
INSERT INTO russyn_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","если же у него нет наследника, которому следовало бы возвратить за вину: то посвятить это Господу; пусть будет это священнику, сверх овна очищения, которым он очистит его; ");
INSERT INTO russyn_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","и всякое возношение из всех святынь сынов Израилевых, которые они приносят к священнику, ему принадлежит, ");
INSERT INTO russyn_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","и посвященное кем-либо ему принадлежит; все, что даст кто священнику, ему принадлежит. ");
INSERT INTO russyn_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","объяви сынам Израилевым и скажи им: если изменит кому жена, и нарушит верность к нему, ");
INSERT INTO russyn_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","и переспит кто с ней и излиет семя, и это будет скрыто от глаз мужа ее, и она осквернится тайно, и не будет на нее свидетеля, и не будет уличена, ");
INSERT INTO russyn_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","и найдет на него дух ревности, и будет ревновать жену свою, когда она осквернена, или найдет на него дух ревности, и он будет ревновать жену свою, когда она не осквернена, ");
INSERT INTO russyn_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","пусть приведет муж жену свою к священнику и принесет за нее в жертву десятую часть ефы ячменной муки, но не возливает на нее елея и не кладет ливана, потому что это приношение ревнования, приношение воспоминания, напоминающее о беззаконии; ");
INSERT INTO russyn_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","а священник пусть приведет и поставит ее пред лице Господне, ");
INSERT INTO russyn_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","и возьмет священник святой воды в глиняный сосуд, и возьмет священник земли с полу скинии и положит в воду; ");
INSERT INTO russyn_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","и поставит священник жену пред лице Господне, и обнажит голову жены, и даст ей в руки приношение воспоминания,- это приношение ревнования, в руке же у священника будет горькая вода, наводящая проклятие. ");
INSERT INTO russyn_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","И заклянет ее священник и скажет жене: если никто не переспал с тобою, и ты не осквернилась и не изменила мужу своему, то невредима будешь от сей горькой воды, наводящей проклятие; ");
INSERT INTO russyn_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","но если ты изменила мужу твоему и осквернилась, и если кто переспал с тобою кроме мужа твоего, ");
INSERT INTO russyn_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","тогда священник пусть заклянет жену клятвою проклятия и скажет священник жене: да предаст тебя Господь проклятию и клятве в народе твоем, и да соделает Господь лоно твое опавшим и живот твой опухшим; ");
INSERT INTO russyn_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","и да пройдет вода сия, наводящая проклятие, во внутренность твою, чтобы опух живот твой и опало лоно твое. И скажет жена: аминь, аминь. ");
INSERT INTO russyn_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","И напишет священник заклинания сии на свитке, и смоет их в горькую воду; ");
INSERT INTO russyn_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","и даст жене выпить горькую воду, наводящую проклятие, и войдет в нее вода, наводящая проклятие, ко вреду ее. ");
INSERT INTO russyn_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","И возьмет священник из рук жены хлебное приношение ревнования, и вознесет сие приношение пред Господом, и отнесет его к жертвеннику; ");
INSERT INTO russyn_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","и возьмет священник горстью из хлебного приношения часть в память, и сожжет на жертвеннике, и потом даст жене выпить воды; ");
INSERT INTO russyn_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","и когда напоит ее водою, тогда, если она нечиста и сделала преступление против мужа своего, горькая вода, наводящая проклятие, войдет в нее, ко вреду ее, и опухнет чрево ее и опадет лоно ее, и будет эта жена проклятою в народе своем; ");
INSERT INTO russyn_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","если же жена не осквернилась и была чиста, то останется невредимою и будет оплодотворяема семенем. ");
INSERT INTO russyn_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Вот закон о ревновании, когда жена изменит мужу своему и осквернится, ");
INSERT INTO russyn_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","или когда на мужа найдет дух ревности, и он будет ревновать жену свою, тогда пусть он поставит жену пред лицем Господа, и сделает с нею священник все по сему закону, ");
INSERT INTO russyn_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","и будет муж чист от греха, а жена понесет на себе грех свой. ");
INSERT INTO russyn_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","объяви сынам Израилевым и скажи им: если мужчина или женщина решится дать обет назорейства, чтобы посвятить себя в назореи Господу, ");
INSERT INTO russyn_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","то он должен воздержаться от вина и крепкого напитка, и не должен употреблять ни уксусу из вина, ни уксусу из напитка, и ничего приготовленного из винограда не должен пить, и не должен есть ни сырых, ни сушеных виноградных ягод; ");
INSERT INTO russyn_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","во все дни назорейства своего не должен он есть и пить ничего, что делается из винограда, от зерен до кожи. ");
INSERT INTO russyn_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Во все дни обета назорейства его бритва не должна касаться головы его; до исполнения дней, на которые он посвятил себя в назореи Господу, свят он: должен растить волосы на голове своей. ");
INSERT INTO russyn_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Во все дни, на которые он посвятил себя в назореи Господу, не должен он подходить к мертвому телу: ");
INSERT INTO russyn_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","прикосновением к отцу своему, и матери своей, и брату своему, и сестре своей, не должен он оскверняться, когда они умрут, потому что посвящение Богу его на главе его; ");
INSERT INTO russyn_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","во все дни назорейства своего свят он Господу. ");
INSERT INTO russyn_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Если же умрет при нем кто-нибудь вдруг, нечаянно, и он осквернит тем голову назорейства своего: то он должен остричь голову свою в день очищения его, в седьмой день должен остричь ее, ");
INSERT INTO russyn_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","и в восьмой день должен принести двух горлиц, или двух молодых голубей, к священнику, ко входу скинии собрания; ");
INSERT INTO russyn_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","священник одну из птиц принесет в жертву за грех, а другую во всесожжение, и очистит его от осквернения мертвым телом, и освятит голову его в тот день; ");
INSERT INTO russyn_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","и должен он снова начать посвященные Господу дни назорейства своего и принести однолетнего агнца в жертву повинности; прежние же дни пропали, потому что назорейство его осквернено. ");
INSERT INTO russyn_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","И вот закон о назорее, когда исполнятся дни назорейства его: должно привести его ко входу скинии собрания, ");
INSERT INTO russyn_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","и он принесет в жертву Господу одного однолетнего агнца без порока во всесожжение, и одну однолетнюю агницу без порока в жертву за грех, и одного овна без порока в жертву мирную, ");
INSERT INTO russyn_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","и корзину опресноков из пшеничной муки, хлебов, испеченных с елеем, и пресных лепешек, помазанных елеем, и при них хлебное приношение и возлияние; ");
INSERT INTO russyn_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","и представит сие священник пред Господа, и принесет жертву его за грех и всесожжение его; ");
INSERT INTO russyn_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","овна принесет в жертву мирную Господу с корзиною опресноков, также совершит священник хлебное приношение его и возлияние его; ");
INSERT INTO russyn_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","и острижет назорей у входа скинии собрания голову назорейства своего, и возьмет волосы головы назорейства своего, и положит на огонь, который под мирною жертвою; ");
INSERT INTO russyn_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","и возьмет священник сваренное плечо овна и один пресный пирог из корзины и одну пресную лепешку, и положит на руки назорею, после того, как острижет он голову назорейства своего; ");
INSERT INTO russyn_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","и вознесет сие священник, потрясая пред Господом: эта святыня - для священника, сверх груди потрясания и сверх плеча возношения. После сего назорей может пить вино. ");
INSERT INTO russyn_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Вот закон о назорее, который дал обет, и жертва его Господу за назорейство свое, кроме того, что позволит ему достаток его; по обету своему, какой он даст, так и должен он делать, сверх узаконенного о назорействе его. ");
INSERT INTO russyn_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","скажи Аарону и сынам его: так благословляйте сынов Израилевых, говоря им: ");
INSERT INTO russyn_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","да благословит тебя Господь и сохранит тебя! ");
INSERT INTO russyn_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","да призрит на тебя Господь светлым лицем Своим и помилует тебя! ");
INSERT INTO russyn_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","да обратит Господь лице Свое на тебя и даст тебе мир! ");
INSERT INTO russyn_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Так пусть призывают имя Мое на сынов Израилевых, и Я Господь благословлю их. ");
INSERT INTO russyn_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Когда Моисей поставил скинию, и помазал ее, и освятил ее и все принадлежности ее, и жертвенник и все принадлежности его, и помазал их и освятил их, ");
INSERT INTO russyn_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","тогда пришли двенадцать начальников Израилевых, главы се- мейств их, начальники колен, заведовавшие исчислением, ");
INSERT INTO russyn_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","и представили приношение свое пред Господа, шесть крытых повозок и двенадцать волов, по одной повозке от двух начальников и по одному волу от каждого, и представили сие пред скинию. ");
INSERT INTO russyn_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","возьми от них; это будет для отправления работ при скинии собрания; и отдай это левитам, смотря по роду службы их. ");
INSERT INTO russyn_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","И взял Моисей повозки и волов, и отдал их левитам: ");
INSERT INTO russyn_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","две повозки и четырех волов отдал сынам Гирсоновым, по роду служб их: ");
INSERT INTO russyn_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","и четыре повозки и восемь волов отдал сынам Мерариным, по роду служб их, под надзором Ифамара, сына Аарона, священника; ");
INSERT INTO russyn_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","а сынам Каафовым не дал, потому что служба их - носить святилище; на плечах они должны носить. ");
INSERT INTO russyn_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","И принесли начальники жертвы освящения жертвенника в день помазания его, и представили начальники приношение свое пред жертвенник. ");
INSERT INTO russyn_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","И сказал Господь Моисею: по одному начальнику в день пусть приносят приношение свое для освящения жертвенника. ");
INSERT INTO russyn_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","В первый день принес приношение свое Наассон, сын Аминадавов, от колена Иудина; ");
INSERT INTO russyn_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","приношение его было: одно серебряное блюдо, весом в сто тридцать сиклей, одна серебряная чаша в семьдесят сиклей, по сиклю священному, наполненные пшеничною мукою, смешанною с елеем, в приношение хлебное, ");
INSERT INTO russyn_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","одна золотая кадильница в десять сиклей, наполненная курением, ");
INSERT INTO russyn_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","один телец, один овен, один однолетний агнец, во всесожжение, ");
INSERT INTO russyn_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","один козел в жертву за грех, ");
INSERT INTO russyn_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","и в жертву мирную два вола, пять овнов, пять козлов, пять однолетних агнцев; вот приношение Наассона, сына Аминадавова. ");
INSERT INTO russyn_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Во второй день принес Нафанаил, сын Цуара, начальник колена Иссахарова; ");
INSERT INTO russyn_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","он принес от себя приношение: одно серебряное блюдо, весом в сто тридцать сиклей, одну серебряную чашу в семьдесят сиклей, по сиклю священному, наполненные пшеничною мукою, смешанною с елеем, в приношение хлебное, ");
INSERT INTO russyn_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","одну золотую кадильницу в десять сиклей, наполненную курением, ");
INSERT INTO russyn_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","одного тельца, одного овна, одного однолетнего агнца, во всесожжение, ");
INSERT INTO russyn_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","одного козла в жертву за грех, ");
INSERT INTO russyn_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","и в жертву мирную двух волов, пять овнов, пять козлов, пять однолетних агнцев; вот приношение Нафанаила, сына Цуарова. ");
INSERT INTO russyn_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","В третий день начальник сынов Завулоновых Елиав, сын Хелона; ");
INSERT INTO russyn_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","приношение его: одно серебряное блюдо, весом в сто тридцать сиклей, одна серебряная чаша в семьдесят сиклей, по сиклю священному, наполненные пшеничною мукою, смешанною с елеем, в приношение хлебное, ");
INSERT INTO russyn_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","одна золотая кадильница в десять сиклей, наполненная курением, ");
INSERT INTO russyn_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","один телец, один овен, один однолетний агнец, во всесожжение, ");
INSERT INTO russyn_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","один козел в жертву за грех, ");
INSERT INTO russyn_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","и в жертву мирную два вола, пять овнов, пять козлов, пять однолетних агнцев; вот приношение Елиава, сына Хелонова. ");
INSERT INTO russyn_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","В четвертый день начальник сынов Рувимовых Елицур, сын Шедеуров; ");
INSERT INTO russyn_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","приношение его: одно серебряное блюдо, весом в сто тридцать сиклей, одна серебряная чаша в семьдесят сиклей, по сиклю священному, наполненные пшеничною мукою, смешанною с елеем, в приношение хлебное, ");
INSERT INTO russyn_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","одна золотая кадильница в десять сиклей, наполненная курением, ");
INSERT INTO russyn_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","один телец, один овен, один однолетний агнец, во всесожжение, ");
INSERT INTO russyn_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","один козел в жертву за грех, ");
INSERT INTO russyn_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","и в жертву мирную два вола, пять овнов, пять козлов и пять однолетних агнцев; вот приношение Елицура, сына Шедеурова. ");
INSERT INTO russyn_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","В пятый день начальник сынов Симеоновых Шелумиил, сын Цуришаддая; ");
INSERT INTO russyn_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","приношение его: одно серебряное блюдо, весом в сто тридцать сиклей, одна серебряная чаша в семьдесят сиклей, по сиклю священному, наполненные пшеничною мукою, смешанною с елеем, в приношение хлебное, ");
INSERT INTO russyn_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","одна золотая кадильница в десять сиклей, наполненная курением, ");
INSERT INTO russyn_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","один телец, один овен, один однолетний агнец, во всесожжение, ");
INSERT INTO russyn_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","один козел в жертву за грех, ");
INSERT INTO russyn_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","и в жертву мирную два вола, пять овнов, пять козлов и пять однолетних агнцев; вот приношение Шелумиила, сына Цуришаддаева. ");
INSERT INTO russyn_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","В шестой день начальник сынов Гадовых Елиасаф, сын Регуила; ");
INSERT INTO russyn_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","приношение его: одно серебряное блюдо, весом в сто тридцать сиклей, одна серебряная чаша в семьдесят сиклей, по сиклю священному, наполненные пшеничною мукою, смешанною с елеем, в приношение хлебное, ");
INSERT INTO russyn_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","одна золотая кадильница в десять сиклей, наполненная курением, ");
INSERT INTO russyn_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","один телец, один овен, один однолетний агнец, во всесожжение, ");
INSERT INTO russyn_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","один козел в жертву за грех, ");
INSERT INTO russyn_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","и в жертву мирную два вола, пять овнов, пять козлов и пять однолетних агнцев; вот приношение Елиасафа, сына Регуилова. ");
INSERT INTO russyn_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","В седьмой день начальник сынов Ефремовых Елишама, сын Аммиуда. ");
INSERT INTO russyn_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Приношение его: одно серебряное блюдо, весом в сто тридцать сиклей, одна серебряная чаша в семьдесят сиклей, по сиклю священному, наполненные пшеничною мукою, смешанною с елеем, в приношение хлебное, ");
INSERT INTO russyn_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","одна золотая кадильница в десять сиклей, наполненная курением, ");
INSERT INTO russyn_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","один телец, один овен, один однолетний агнец, во всесожжение, ");
INSERT INTO russyn_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","один козел в жертву за грех, ");
INSERT INTO russyn_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","и в жертву мирную два вола, пять овнов, пять козлов, пять однолетних агнцев; вот приношение Елишамы, сына Аммиудова. ");
INSERT INTO russyn_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","В восьмой день начальник сынов Манассииных Гамалиил, сын Педацура. ");
INSERT INTO russyn_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Приношение его: одно серебряное блюдо, весом в сто тридцать сиклей, одна серебряная чаша в семьдесят сиклей, по сиклю священному, наполненные пшеничною мукою, смешанною с елеем, в приношение хлебное, ");
INSERT INTO russyn_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","одна золотая кадильница в десять сиклей, наполненная курением, ");
INSERT INTO russyn_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","один телец, один овен, один однолетний агнец, во всесожжение, ");
INSERT INTO russyn_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","один козел в жертву за грех, ");
INSERT INTO russyn_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","и в жертву мирную два вола, пять овнов, пять козлов, пять однолетних агнцев; вот приношение Гамалиила, сына Педацурова. ");
INSERT INTO russyn_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","В девятый день начальник сынов Вениаминовых Авидан, сын Гидеония; ");
INSERT INTO russyn_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","приношение его: одно серебряное блюдо, весом в сто тридцать сиклей, одна серебряная чаша в семьдесят сиклей, по сиклю священному, наполненные пшеничною мукою, смешанною с елеем, в приношение хлебное, ");
INSERT INTO russyn_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","одна золотая кадильница в десять сиклей, наполненная курением, ");
INSERT INTO russyn_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","один телец, один овен, один однолетний агнец, во всесожжение, ");
INSERT INTO russyn_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","один козел в жертву за грех, ");
INSERT INTO russyn_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","и в жертву мирную два вола, пять овнов, пять козлов, пять однолетних агнцев; вот приношение Авидана, сына Гидеониева. ");
INSERT INTO russyn_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","В десятый день начальник сынов Дановых Ахиезер, сын Аммишаддая; ");
INSERT INTO russyn_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","приношение его: одно серебряное блюдо, весом в сто тридцать сиклей, одна серебряная чаша в семьдесят сиклей, по сиклю священному, наполненные пшеничною мукою, смешанною с елеем, в приношение хлебное, ");
INSERT INTO russyn_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","одна золотая кадильница в десять сиклей, наполненная курением, ");
INSERT INTO russyn_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","один телец, один овен, один однолетний агнец, во всесожжение, ");
INSERT INTO russyn_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","один козел в жертву за грех, ");
INSERT INTO russyn_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","и в жертву мирную два вола, пять овнов, пять козлов, пять однолетних агнцев; вот приношение Ахиезера, сына Аммишаддаева. ");
INSERT INTO russyn_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","В одиннадцатый день начальник сынов Асировых Пагиил, сын Охрана; ");
INSERT INTO russyn_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","приношение его: одно серебряное блюдо, весом в сто тридцать сиклей, одна серебряная чаша в семьдесят сиклей, по сиклю священному, наполненные пшеничною мукою, смешанною с елеем, в приношение хлебное, ");
INSERT INTO russyn_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","одна золотая кадильница в десять сиклей, наполненная курением, ");
INSERT INTO russyn_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","один телец, один овен, один однолетний агнец, во всесожжение, ");
INSERT INTO russyn_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","один козел в жертву за грех, ");
INSERT INTO russyn_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","и в жертву мирную два вола, пять овнов, пять козлов, пять однолетних агнцев; вот приношение Пагиила, сына Охранова. ");
INSERT INTO russyn_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","В двенадцатый день начальник сынов Неффалимовых Ахира, сын Енана; ");
INSERT INTO russyn_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","приношение его: одно серебряное блюдо, весом в сто тридцать сиклей, одна серебряная чаша в семьдесят сиклей, по сиклю священному, наполненные пшеничною мукою, смешанною с елеем, в приношение хлебное, ");
INSERT INTO russyn_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","одна золотая кадильница в десять сиклей, наполненная курением, ");
INSERT INTO russyn_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","один телец, один овен, один однолетний агнец, во всесожжение, ");
INSERT INTO russyn_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","один козел в жертву за грех, ");
INSERT INTO russyn_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","и в жертву мирную два вола, пять овнов, пять козлов, пять однолетних агнцев; вот приношение Ахиры, сына Енанова. ");
INSERT INTO russyn_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Вот приношения от начальников Израилевых при освящении жертвенника в день помазания его: двенадцать серебряных блюд, двенадцать серебряных чаш, двенадцать золотых кадильниц; ");
INSERT INTO russyn_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","по сто тридцати сиклей серебра в каждом блюде и по семидесяти в каждой чаше: итак всего серебра в сих сосудах две тысячи четыреста сиклей, по сиклю священному; ");
INSERT INTO russyn_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","золотых кадильниц, наполненных курением, двенадцать, в каждой кадильнице по десяти сиклей, по сиклю священному: всего золота в кадильницах сто двадцать сиклей; ");
INSERT INTO russyn_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","во всесожжение всего двенадцать тельцов из скота крупного, двенадцать овнов, двенадцать однолетних агнцев и при них хлебное приношение, и в жертву за грех двенадцать козлов, ");
INSERT INTO russyn_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","и в жертву мирную всего из крупного скота двадцать четыре тельца, шестьдесят овнов, шестьдесят однолетних козлов, шестьдесят однолетних агнцев без порока; вот приношения при освящении жертвенника после помазания его. ");
INSERT INTO russyn_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Когда Моисей входил в скинию собрания, чтобы говорить с Господом, слышал голос, говорящий ему с крышки, которая над ковчегом откровения между двух херувимов, и он говорил ему. ");
INSERT INTO russyn_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","объяви Аарону и скажи ему: когда ты будешь зажигать лампады, то на передней стороне светильника должны гореть семь лампад. ");
INSERT INTO russyn_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Аарон так и сделал: на передней стороне светильника зажег лампады его, как повелел Господь Моисею. ");
INSERT INTO russyn_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","И вот устройство светильника: чеканный он из золота, от стебля его и до цветов чеканный; по образу, который показал Господь Моисею, он сделал светильник. ");
INSERT INTO russyn_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","возьми левитов из среды сынов Израилевых и очисти их; ");
INSERT INTO russyn_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","а чтобы очистить их, поступи с ними так: окропи их очистительною водою, и пусть они обреют бритвою все тело свое и вымоют одежды свои, и будут чисты; ");
INSERT INTO russyn_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","и пусть возьмут тельца и хлебное приношение к нему, пшеничной муки, смешанной с елеем, и другого тельца возьми в жертву за грех; ");
INSERT INTO russyn_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","и приведи левитов пред скинию собрания; и собери все общество сынов Израилевых ");
INSERT INTO russyn_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","и приведи левитов их пред Господа, и пусть возложат сыны Израилевы руки свои на левитов; ");
INSERT INTO russyn_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Аарон же пусть совершит над левитами посвящение их пред Господом от сынов Израилевых, чтобы отправляли они служение Господу; ");
INSERT INTO russyn_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","а левиты пусть возложат руки свои на голову тельцов, и принеси одного в жертву за грех, а другого во всесожжение Господу, для очищения левитов; ");
INSERT INTO russyn_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","и поставь левитов пред Аароном и пред сынами его, и соверши над ними посвящение их Господу; ");
INSERT INTO russyn_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","и так отдели левитов от сынов Израилевых, чтобы левиты были Моими. ");
INSERT INTO russyn_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","После сего войдут левиты служить скинии собрания, когда ты очистишь их и совершишь над ними посвящение их; ибо они отданы Мне из сынов Израилевых: ");
INSERT INTO russyn_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","вместо всех первенцев из сынов Израилевых, разверзающих всякие ложесна, Я беру их Себе; ");
INSERT INTO russyn_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","ибо Мои все первенцы у сынов Израилевых, от человека до скота: в тот день, когда Я поразил всех первенцев в земле Египетской, Я освятил их Себе ");
INSERT INTO russyn_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","и взял левитов вместо всех первенцев у сынов Израилевых; ");
INSERT INTO russyn_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","и отдал левитов Аарону и сынам его из среды сынов Израилевых, чтобы они отправляли службы за сынов Израилевых при скинии собрания и служили охранением для сынов Израилевых, чтобы не постигло сынов Израилевых поражение, когда бы сыны Израилевы приступили к святилищу. ");
INSERT INTO russyn_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","И сделали так Моисей и Аарон и все общество сынов Израилевых с левитами: как повелел Господь Моисею о левитах, так и сделали с ними сыны Израилевы. ");
INSERT INTO russyn_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","И очистились левиты и омыли одежды свои, и совершил над ними Аарон посвящение их пред Господом, и очистил их Аарон, чтобы сделать их чистыми; ");
INSERT INTO russyn_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","после сего вошли левиты отправлять службы свои в скинии собрания пред Аароном и пред сынами его. Как повелел Господь Моисею о левитах, так и сделали они с ними. ");
INSERT INTO russyn_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","вот закон о левитах: от двадцати пяти лет и выше должны вступать они в службу для работ при скинии собрания, ");
INSERT INTO russyn_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","а в пятьдесят лет должны прекращать отправление работ и более не работать: ");
INSERT INTO russyn_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","тогда пусть помогают они братьям своим содержать стражу при скинии собрания, работать же - пусть не работают; так поступай с левитами касательно служения их. ");
INSERT INTO russyn_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","И сказал Господь Моисею в пустыне Синайской во второй год по исшествии их из земли Египетской, в первый месяц, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","пусть сыны Израилевы совершат Пасху в назначенное для нее время: ");
INSERT INTO russyn_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","в четырнадцатый день сего месяца вечером совершите ее в назначенное для нее время, по всем постановлениям и по всем обрядам ее совершите ее. ");
INSERT INTO russyn_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","И сказал Моисей сынам Израилевым, чтобы совершили Пасху. ");
INSERT INTO russyn_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","И совершили они Пасху в первый месяц, в четырнадцатый день месяца вечером, в пустыне Синайской: во всем, как повелел Господь Моисею, так и поступили сыны Израилевы. ");
INSERT INTO russyn_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Были люди, которые были нечисты от прикосновения к мертвым телам человеческим, и не могли совершить Пасхи в тот день; и пришли они к Моисею и Аарону в тот день, ");
INSERT INTO russyn_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","и сказали ему те люди: мы нечисты от прикосновения к мертвым телам человеческим; для чего нас лишать того, чтобы мы принесли приношение Господу в назначенное время среди сынов Израилевых? ");
INSERT INTO russyn_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","И сказал им Моисей: постойте, я послушаю, что повелит о вас Господь. ");
INSERT INTO russyn_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","скажи сынам Израилевым: если кто из вас или из потомков ваших будет нечист от прикосновения к мертвому телу, или будет в дальней дороге, то и он должен совершить Пасху Господню; ");
INSERT INTO russyn_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","в четырнадцатый день второго месяца вечером пусть таковые совершат ее и с опресноками и горькими травами пусть едят ее; ");
INSERT INTO russyn_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","и пусть не оставляют от нее до утра и костей ее не сокрушают; пусть совершат ее по всем уставам о Пасхе; ");
INSERT INTO russyn_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","а кто чист и не находится в дальней дороге и не совершит Пасхи,- истребится душа та из народа своего, ибо он не принес приношения Господу в свое время: понесет на себе грех человек тот; ");
INSERT INTO russyn_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","если будет жить у вас пришелец, то и он должен совершать Пасху Господню: по уставу о Пасхе и по обряду ее он должен совершить ее; один устав пусть будет у вас и для пришельца и для туземца. ");
INSERT INTO russyn_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","В тот день, когда поставлена была скиния, облако покрыло скинию откровения, и с вечера над скиниею как бы огонь виден был до самого утра. ");
INSERT INTO russyn_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Так было и всегда: облако покрывало ее днем и подобие огня ночью. ");
INSERT INTO russyn_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","И когда облако поднималось от скинии, тогда сыны Израилевы отправлялись в путь, и на месте, где останавливалось облако, там останавливались станом сыны Израилевы. ");
INSERT INTO russyn_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","По повелению Господню отправлялись сыны Израилевы в путь, и по повелению Господню останавливались: во все то время, когда облако стояло над скиниею, и они стояли; ");
INSERT INTO russyn_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","и если облако долгое время было над скиниею, то и сыны Израилевы следовали этому указанию Господа и не отправлялись; ");
INSERT INTO russyn_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","иногда же облако немного времени было над скиниею: они по указанию Господню останавливались, и по указанию Господню отправлялись в путь; ");
INSERT INTO russyn_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","иногда облако стояло только от вечера до утра, и поутру поднималось облако, тогда и они отправлялись; или день и ночь стояло облако, и когда поднималось, и они тогда отправлялись; ");
INSERT INTO russyn_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","или, если два дня, или месяц, или несколько дней стояло облако над скиниею, то и сыны Израилевы стояли и не отправлялись в путь; а когда оно поднималось, тогда отправлялись; ");
INSERT INTO russyn_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","по указанию Господню останавливались, и по указанию Господню отправлялись в путь: следовали указанию Господню по повелению Господню, данному чрез Моисея. ");
INSERT INTO russyn_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","сделай себе две серебряные трубы, чеканные сделай их, чтобы они служили тебе для созывания общества и для снятия станов; ");
INSERT INTO russyn_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","когда затрубят ими, соберется к тебе все общество ко входу скинии собрания; ");
INSERT INTO russyn_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","когда одною трубою затрубят, соберутся к тебе князья и тысяченачальники Израилевы; ");
INSERT INTO russyn_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","когда затрубите тревогу, поднимутся станы, становящиеся к востоку; ");
INSERT INTO russyn_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","когда во второй раз затрубите тревогу, поднимутся станы, становящиеся к югу; когда затрубите в третий раз тревогу, поднимутся станы, становящиеся к морю; когда в четвертый раз затрубите тревогу, поднимутся станы, становящиеся к северу; тревогу пусть трубят при отправлении их в путь; ");
INSERT INTO russyn_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","а когда надобно собрать собрание, трубите, но не тревогу; ");
INSERT INTO russyn_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","сыны Аароновы, священники, должны трубить трубами: это будет вам постановлением вечным в роды ваши; ");
INSERT INTO russyn_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","и когда пойдете на войну в земле вашей против врага, наступающего на вас, трубите тревогу трубами,- и будете воспомянуты пред Господом, Богом вашим, и спасены будете от врагов ваших; ");
INSERT INTO russyn_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","и в день веселия вашего, и в праздники ваши, и в новомесячия ваши трубите трубами при всесожжениях ваших и при мирных жертвах ваших,- и это будет напоминанием о вас пред Богом вашим. Я Господь, Бог ваш. ");
INSERT INTO russyn_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Во второй год, во второй месяц, в двадцатый день месяца поднялось облако от скинии откровения; ");
INSERT INTO russyn_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","и отправились сыны Израилевы по станам своим из пустыни Синайской, и остановилось облако в пустыне Фаран. ");
INSERT INTO russyn_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","И поднялись они в первый раз, по повелению Господню, данному чрез Моисея. ");
INSERT INTO russyn_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Поднято было во-первых знамя стана сынов Иудиных по ополчениям их; над ополчением их Наассон, сын Аминадава; ");
INSERT INTO russyn_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","и над ополчением колена сынов Иссахаровых Нафанаил, сын Цуара; ");
INSERT INTO russyn_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","и над ополчением колена сынов Завулоновых Елиав, сын Хелона. ");
INSERT INTO russyn_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","И снята была скиния, и пошли сыны Гирсоновы и сыны Мерарины, носящие скинию. ");
INSERT INTO russyn_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","И поднято было знамя стана Рувимова по ополчениям их; и над ополчением его Елицур, сын Шедеура; ");
INSERT INTO russyn_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","и над ополчением колена сынов Симеоновых Шелумиил, сын Цуришаддая; ");
INSERT INTO russyn_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","и над ополчением колена сынов Гадовых Елиасаф, сын Регуила. ");
INSERT INTO russyn_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Потом пошли сыны Каафовы, носящие святилище; скиния же была поставляема до прихода их. ");
INSERT INTO russyn_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","И поднято было знамя стана сынов Ефремовых по ополчениям их; и над ополчением их Елишама, сын Аммиуда; ");
INSERT INTO russyn_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","и над ополчением колена сынов Манассииных Гамалиил, сын Педацура; ");
INSERT INTO russyn_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","и над ополчением колена сынов Вениаминовых Авидан, сын Гидеония. ");
INSERT INTO russyn_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Последним из всех станов поднято было знамя стана сынов Дановых с ополчениями их; и над ополчением их Ахиезер, сын Аммишаддая; ");
INSERT INTO russyn_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","и над ополчением колена сынов Асировых Пагиил, сын Охрана; ");
INSERT INTO russyn_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","и над ополчением колена сынов Неффалимовых Ахира, сын Енана. ");
INSERT INTO russyn_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Вот порядок шествия сынов Израилевых по ополчениям их. И отправились они. ");
INSERT INTO russyn_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","И сказал Моисей Ховаву, сыну Рагуилову, Мадианитянину, родственнику Моисееву: мы отправляемся в то место, о котором Господь сказал: вам отдам его; иди с нами, мы сделаем тебе добро, ибо Господь доброе изрек об Израиле. ");
INSERT INTO russyn_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Но он сказал ему: не пойду; я пойду в свою землю и на свою родину. ");
INSERT INTO russyn_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Моисей же сказал: не оставляй нас, потому что ты знаешь, как располагаемся мы станом в пустыне, и будешь для нас глазом; ");
INSERT INTO russyn_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","если пойдешь с нами, то добро, которое Господь сделает нам, мы сделаем тебе. ");
INSERT INTO russyn_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","И отправились они от горы Господней на три дня пути, и ковчег завета Господня шел пред ними три дня пути, чтоб усмотреть им место, где остановиться. ");
INSERT INTO russyn_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","И облако Господне осеняло их днем, когда они отправлялись из стана. ");
INSERT INTO russyn_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Когда поднимался ковчег в путь, Моисей говорил: восстань, Господи, и рассыплются враги Твои, и побегут от лица Твоего ненавидящие Тебя! ");
INSERT INTO russyn_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","А когда останавливался ковчег, он говорил: возвратись, Господи, к тысячам и тьмам Израилевым! ");
INSERT INTO russyn_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Народ стал роптать вслух Господа; и Господь услышал, и воспламенился гнев Его, и возгорелся у них огонь Господень, и начал истреблять край стана. ");
INSERT INTO russyn_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","И возопил народ к Моисею; и помолился Моисей Господу, и утих огонь. ");
INSERT INTO russyn_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","И нарекли имя месту сему: Тавера, потому что возгорелся у них огонь Господень. ");
INSERT INTO russyn_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Пришельцы между ними стали обнаруживать прихоти; а с ними и сыны Израилевы сидели и плакали и говорили: кто накормит нас мясом? ");
INSERT INTO russyn_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Мы помним рыбу, которую в Египте мы ели даром, огурцы и дыни, и лук, и репчатый лук и чеснок; ");
INSERT INTO russyn_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","а ныне душа наша изнывает; ничего нет, только манна в глазах наших. ");
INSERT INTO russyn_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Манна же была подобна кориандровому семени, видом, как бдолах; ");
INSERT INTO russyn_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","народ ходил и собирал ее, и молол в жерновах или толок в ступе, и варил в котле, и делал из нее лепешки; вкус же ее подобен был вкусу лепешек с елеем. ");
INSERT INTO russyn_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","И когда роса сходила на стан ночью, тогда сходила на него и манна. ");
INSERT INTO russyn_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Моисей слышал, что народ плачет в семействах своих, каждый у дверей шатра своего; и сильно воспламенился гнев Господень, и прискорбно было для Моисея. ");
INSERT INTO russyn_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","И сказал Моисей Господу: для чего Ты мучишь раба Твоего? и почему я не нашел милости пред очами Твоими, что Ты возложил на меня бремя всего народа сего? ");
INSERT INTO russyn_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","разве я носил во чреве весь народ сей, и разве я родил его, что Ты говоришь мне: неси его на руках твоих, как нянька носит ребенка, в землю, которую Ты с клятвою обещал отцам его? ");
INSERT INTO russyn_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","откуда мне взять мяса, чтобы дать всему народу сему? ибо они плачут предо мною и говорят: дай нам есть мяса. ");
INSERT INTO russyn_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Я один не могу нести всего народа сего, потому что он тяжел для меня; ");
INSERT INTO russyn_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","когда Ты так поступаешь со мною, то лучше умертви меня, если я нашел милость пред очами Твоими, чтобы мне не видеть бедствия моего. ");
INSERT INTO russyn_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","И сказал Господь Моисею: собери Мне семьдесят мужей из старейшин Израилевых, которых ты знаешь, что они старейшины и надзиратели его, и возьми их к скинии собрания, чтобы они стали там с тобою; ");
INSERT INTO russyn_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Я сойду, и буду говорить там с тобою, и возьму от Духа, Который на тебе, и возложу на них, чтобы они несли с тобою бремя народа, а не один ты носил. ");
INSERT INTO russyn_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Народу же скажи: очиститесь к завтрашнему дню, и будете есть мясо; так как вы плакали вслух Господа и говорили: кто накормит нас мясом? хорошо нам было в Египте,- то и даст вам Господь мясо, и будете есть мясо: ");
INSERT INTO russyn_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","не один день будете есть, не два дня, не пять дней, не десять дней и не двадцать дней, ");
INSERT INTO russyn_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","но целый месяц будете есть, пока не пойдет оно из ноздрей ваших и не сделается для вас отвратительным, за то, что вы презрели Господа, Который среди вас, и плакали пред Ним, говоря: для чего было нам выходить из Египта? ");
INSERT INTO russyn_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","И сказал Моисей: шестьсот тысяч пеших в народе сем, среди которого я нахожусь; а Ты говоришь: Я дам им мясо, и будут есть целый месяц! ");
INSERT INTO russyn_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","заколоть ли всех овец и волов, чтобы им было довольно? или вся рыба морская соберется, чтобы удовлетворить их? ");
INSERT INTO russyn_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","И сказал Господь Моисею: разве рука Господня коротка? ныне ты увидишь, сбудется ли слово Мое тебе, или нет? ");
INSERT INTO russyn_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Моисей вышел и сказал народу слова Господни, и собрал семьдесят мужей из старейшин народа и поставил их около скинии. ");
INSERT INTO russyn_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","И сошел Господь в облаке, и говорил с ним, и взял от Духа, Который на нем, и дал семидесяти мужам старейшинам. И когда почил на них Дух, они стали пророчествовать, но потом перестали. ");
INSERT INTO russyn_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Двое из мужей оставались в стане, одному имя Елдад, а другому имя Модад; но и на них почил Дух они были из числа записанных, только не выходили к скинии, и они пророчествовали в стане. ");
INSERT INTO russyn_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","И прибежал отрок, и донес Моисею, и сказал: Елдад и Модад пророчествуют в стане. ");
INSERT INTO russyn_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","В ответ на это Иисус, сын Навин, служитель Моисея, один из избранных его, сказал: господин мой Моисей! запрети им. ");
INSERT INTO russyn_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Но Моисей сказал ему: не ревнуешь ли ты за меня? о, если бы все в народе Господнем были пророками, когда бы Господь послал Духа Своего на них! ");
INSERT INTO russyn_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","И возвратился Моисей в стан, он и старейшины Израилевы. ");
INSERT INTO russyn_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","И поднялся ветер от Господа, и принес от моря перепелов, и набросал их около стана, на путь дня по одну сторону и на путь дня по другую сторону около стана, на два почти локтя от земли. ");
INSERT INTO russyn_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","И встал народ, и весь тот день, и всю ночь, и весь следующий день собирали перепелов; и кто мало собирал, тот собрал десять хомеров; и разложили их для себя вокруг стана. ");
INSERT INTO russyn_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Мясо еще было в зубах их и не было еще съедено, как гнев Господень возгорелся на народ, и поразил Господь народ весьма великою язвою. ");
INSERT INTO russyn_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","И нарекли имя месту сему: Киброт-Гаттаава, ибо там похоронили прихотливый народ. ");
INSERT INTO russyn_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","От Киброт-Гаттаавы двинулся народ в Асироф, и остановился в Асирофе. ");
INSERT INTO russyn_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","И упрекали Мариам и Аарон Моисея за жену Ефиоплянку, которую он взял,- ибо он взял за себя Ефиоплянку, ");
INSERT INTO russyn_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","и сказали: одному ли Моисею говорил Господь? не говорил ли Он и нам? И услышал сие Господь. ");
INSERT INTO russyn_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Моисей же был человек кротчайший из всех людей на земле. ");
INSERT INTO russyn_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","И сказал Господь внезапно Моисею и Аарону и Мариами: выйдите вы трое к скинии собрания. И вышли все трое. ");
INSERT INTO russyn_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","И сошел Господь в облачном столпе, и стал у входа скинии, и позвал Аарона и Мариам, и вышли они оба. ");
INSERT INTO russyn_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","И сказал: слушайте слова Мои: если бывает у вас пророк Господень, то Я открываюсь ему в видении, во сне говорю с ним; ");
INSERT INTO russyn_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","но не так с рабом Моим Моисеем,- он верен во всем дому Моем: ");
INSERT INTO russyn_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","устами к устам говорю Я с ним, и явно, а не в гаданиях, и образ Господа он видит; как же вы не убоялись упрекать раба Моего, Моисея? ");
INSERT INTO russyn_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","И воспламенился гнев Господа на них, и Он отошел. ");
INSERT INTO russyn_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","И облако отошло от скинии, и вот, Мариам покрылась проказою, как снегом. Аарон взглянул на Мариам, и вот, она в проказе. ");
INSERT INTO russyn_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","И сказал Аарон Моисею: господин мой! не поставь нам в грех, что мы поступили глупо и согрешили; ");
INSERT INTO russyn_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","не попусти, чтоб она была, как мертворожденный младенец, у которого, когда он выходит из чрева матери своей, истлела уже половина тела. ");
INSERT INTO russyn_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","И возопил Моисей к Господу, говоря: Боже, исцели ее! ");
INSERT INTO russyn_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","И сказал Господь Моисею: если бы отец ее плюнул ей в лице, то не должна ли была бы она стыдиться семь дней? итак пусть будет она в заключении семь дней вне стана, а после опять возвратится. ");
INSERT INTO russyn_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","И пробыла Мариам в заключении вне стана семь дней, и народ не отправлялся в путь, доколе не возвратилась Мариам. ");
INSERT INTO russyn_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","После сего народ двинулся из Асирофа, и остановился в пустыне Фаран. ");
INSERT INTO russyn_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","пошли от себя людей, чтобы они высмотрели землю Ханаанскую, которую Я даю сынам Израилевым; по одному человеку от колена отцов их пошлите, главных из них. ");
INSERT INTO russyn_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","И послал их Моисей из пустыни Фаран, по повелению Господню, и все они мужи главные у сынов Израилевых. ");
INSERT INTO russyn_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Вот имена их: из колена Рувимова Саммуа, сын Закхуров, ");
INSERT INTO russyn_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","из колена Симеонова Сафат, сын Хориев, ");
INSERT INTO russyn_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","из колена Иудина Халев, сын Иефонниин, ");
INSERT INTO russyn_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","из колена Иссахарова Игал, сын Иосифов, ");
INSERT INTO russyn_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","из колена Ефремова Осия, сын Навин, ");
INSERT INTO russyn_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","из колена Вениаминова Фалтий, сын Рафуев, ");
INSERT INTO russyn_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","из колена Завулонова Гаддиил, сын Содиев, ");
INSERT INTO russyn_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","из колена Иосифова от Манассии Гаддий, сын Сусиев, ");
INSERT INTO russyn_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","из колена Данова Аммиил, сын Гемаллиев, ");
INSERT INTO russyn_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","из колена Асирова Сефур, сын Михаилев, ");
INSERT INTO russyn_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","из колена Неффалимова Нахбий, сын Вофсиев, ");
INSERT INTO russyn_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","из колена Гадова Геуил, сын Махиев. ");
INSERT INTO russyn_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Вот имена мужей, которых посылал Моисей высмотреть землю. И назвал Моисей Осию, сына Навина, Иисусом. ");
INSERT INTO russyn_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","И послал их Моисей из пустыни Фаран высмотреть землю Ханаанскую и сказал им: пойдите в эту южную страну, и взойдите на гору, ");
INSERT INTO russyn_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","и осмотрите землю, какова она, и народ живущий на ней, силен ли он или слаб, малочислен ли он или многочислен? ");
INSERT INTO russyn_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","и какова земля, на которой он живет, хороша ли она или худа? и каковы города, в которых он живет, в шатрах ли он живет или в укреплениях? ");
INSERT INTO russyn_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","и какова земля, тучна ли она или тоща? есть ли на ней дерева или нет? будьте смелы, и возьмите от плодов земли. Было же это ко времени созревания винограда. ");
INSERT INTO russyn_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Они пошли и высмотрели землю от пустыни Син даже до Рехова, близ Емафа; ");
INSERT INTO russyn_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","и пошли в южную страну, и дошли до Хеврона, где жили Ахиман, Сесай и Фалмай, дети Енаковы: Хеврон же построен был семью годами прежде Цоана, города Египетского; ");
INSERT INTO russyn_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","и пришли к долине Есхол, и осмотрели ее, и срезали там виноградную ветвь с одною кистью ягод, и понесли ее на шесте двое; взяли также гранатовых яблок и смокв; ");
INSERT INTO russyn_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","место сие назвали долиною Есхол, по причине виноградной кисти, которую срезали там сыны Израилевы. ");
INSERT INTO russyn_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","И, высмотрев землю, возвратились они через сорок дней. ");
INSERT INTO russyn_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","И пошли и пришли к Моисею и Аарону и ко всему обществу сынов Израилевых в пустыню Фаран, в Кадес, и принесли им и всему обществу ответ, и показали им плоды земли; ");
INSERT INTO russyn_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","и рассказывали ему и говорили: мы ходили в землю, в которую ты посылал нас; в ней подлинно течет молоко и мед, и вот плоды ее; ");
INSERT INTO russyn_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","но народ, живущий на земле той, силен, и города укрепленные, весьма большие, и сынов Енаковых мы видели там; ");
INSERT INTO russyn_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Амалик живет на южной части земли, Хеттеи, Евеи, Иевусеи и Аморреи живут на горе, Хананеи же живут при море и на берегу Иордана. ");
INSERT INTO russyn_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Но Халев успокаивал народ пред Моисеем, говоря: пойдем и завладеем ею, потому что мы можем одолеть ее. ");
INSERT INTO russyn_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","А те, которые ходили с ним, говорили: не можем мы идти против народа сего, ибо он сильнее нас. ");
INSERT INTO russyn_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","И распускали худую молву о земле, которую они осматривали, между сынами Израилевыми, говоря: земля, которую проходили мы для осмотра, есть земля, поедающая живущих на ней, и весь народ, который видели мы среди ее, люди великорослые; ");
INSERT INTO russyn_vpl VALUES ("NU13_34","005_13_34","NUM","13","34","34","там видели мы и исполинов, сынов Енаковых, от исполинского рода; и мы были в глазах наших пред ними, как саранча, такими же были мы и в глазах их. ");
INSERT INTO russyn_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","И подняло все общество вопль, и плакал народ во всю ту ночь; ");
INSERT INTO russyn_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","и роптали на Моисея и Аарона все сыны Израилевы, и все общество сказало им: о, если бы мы умерли в земле Египетской, или умерли бы в пустыне сей! ");
INSERT INTO russyn_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","и для чего Господь ведет нас в землю сию, чтобы мы пали от меча? жены наши и дети наши достанутся в добычу врагам; не лучше ли нам возвратиться в Египет? ");
INSERT INTO russyn_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","И сказали друг другу: поставим себе начальника и возвратимся в Египет. ");
INSERT INTO russyn_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","И пали Моисей и Аарон на лица свои пред всем собранием общества сынов Израилевых. ");
INSERT INTO russyn_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","И Иисус, сын Навин, и Халев, сын Иефонниин, из осматривавших землю, разодрали одежды свои ");
INSERT INTO russyn_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","и сказали всему обществу сынов Израилевых: земля, которую мы проходили для осмотра, очень, очень хороша; ");
INSERT INTO russyn_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","если Господь милостив к нам, то введет нас в землю сию и даст нам ее - эту землю, в которой течет молоко и мед; ");
INSERT INTO russyn_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","только против Господа не восставайте и не бойтесь народа земли сей; ибо он достанется нам на съедение: защиты у них не стало, а с нами Господь; не бойтесь их. ");
INSERT INTO russyn_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","И сказало все общество: побить их камнями! Но слава Господня явилась в облаке в скинии собрания всем сынам Израилевым. ");
INSERT INTO russyn_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","И сказал Господь Моисею: доколе будет раздражать Меня народ сей? и доколе будет он не верить Мне при всех знамениях, которые делал Я среди его? ");
INSERT INTO russyn_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","поражу его язвою и истреблю его и произведу от тебя и от дома отца твоего народ многочисленнее и сильнее его. ");
INSERT INTO russyn_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Но Моисей сказал Господу: услышат Египтяне, из среды которых Ты силою Твоею вывел народ сей, ");
INSERT INTO russyn_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","и скажут жителям земли сей, которые слышали, что Ты, Господь, находишься среди народа сего, и что Ты, Господь, даешь им видеть Себя лицом к лицу, и облако Твое стоит над ними, и Ты идешь пред ними днем в столпе облачном, а ночью в столпе огненном; ");
INSERT INTO russyn_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","и если Ты истребишь народ сей, как одного человека, то народы, которые слышали славу Твою, скажут: ");
INSERT INTO russyn_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Господь не мог ввести народ сей в землю, которую Он с клятвою обещал ему, а потому и погубил его в пустыне. ");
INSERT INTO russyn_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Итак да возвеличится сила Господня, как Ты сказал, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","Господь долготерпелив и многомилостив и истинен, прощающий беззакония и преступления и грехи, и не оставляющий без наказания, но наказывающий беззаконие отцов в детях до третьего и четвертого рода. ");
INSERT INTO russyn_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Прости грех народу сему по великой милости Твоей, как Ты прощал народ сей от Египта доселе. ");
INSERT INTO russyn_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","И сказал Господь Моисею: прощаю по слову твоему; ");
INSERT INTO russyn_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","но жив Я, и всегда живет имя Мое, и славы Господней полна вся земля: ");
INSERT INTO russyn_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","все, которые видели славу Мою и знамения Мои, сделанные Мною в Египте и в пустыне, и искушали Меня уже десять раз, и не слушали гласа Моего, ");
INSERT INTO russyn_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","не увидят земли, которую Я с клятвою обещал отцам их; только детям их, которые здесь со Мною, которые не знают, что добро, что зло, всем малолетним, ничего не смыслящим, им дам землю, а все, раздражавшие Меня, не увидят ее; ");
INSERT INTO russyn_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","но раба Моего, Халева, за то, что в нем был иной дух, и он совершенно повиновался Мне, введу в землю, в которую он ходил, и семя его наследует ее; ");
INSERT INTO russyn_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Амаликитяне и Хананеи живут в долине; завтра обратитесь и идите в пустыню к Чермному морю. ");
INSERT INTO russyn_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","И сказал Господь Моисею и Аарону, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","доколе злому обществу сему роптать на Меня? ропот сынов Израилевых, которым они ропщут на Меня, Я слышу. ");
INSERT INTO russyn_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Скажи им: живу Я, говорит Господь: как говорили вы вслух Мне, так и сделаю вам; ");
INSERT INTO russyn_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","в пустыне сей падут тела ваши, и все вы исчисленные, сколько вас числом, от двадцати лет и выше, которые роптали на Меня, ");
INSERT INTO russyn_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","не войдете в землю, на которой Я, подъемля руку Мою, клялся поселить вас, кроме Халева, сына Иефонниина, и Иисуса, сына Навина; ");
INSERT INTO russyn_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","детей ваших, о которых вы говорили, что они достанутся в добычу врагам, Я введу туда, и они узнают землю, которую вы презрели, ");
INSERT INTO russyn_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","а ваши трупы падут в пустыне сей; ");
INSERT INTO russyn_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","а сыны ваши будут кочевать в пустыне сорок лет, и будут нести наказание за блудодейство ваше, доколе не погибнут все тела ваши в пустыне; ");
INSERT INTO russyn_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","по числу сорока дней, в которые вы осматривали землю, вы понесете наказание за грехи ваши сорок лет, год за день, дабы вы познали, что значит быть оставленным Мною. ");
INSERT INTO russyn_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Я, Господь, говорю, и так и сделаю со всем сим злым обществом, восставшим против Меня: в пустыне сей все они погибнут и перемрут. ");
INSERT INTO russyn_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","И те, которых посылал Моисей для осмотрения земли, и которые, возвратившись, возмутили против него все сие общество, распуская худую молву о земле, ");
INSERT INTO russyn_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","сии, распустившие худую молву о земле, умерли, быв поражены пред Господом; ");
INSERT INTO russyn_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","только Иисус, сын Навин, и Халев, сын Иефонниин, остались живы из тех мужей, которые ходили осматривать землю. ");
INSERT INTO russyn_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","И сказал Моисей слова сии пред всеми сынами Израилевыми, и народ сильно опечалился. ");
INSERT INTO russyn_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","И, встав рано поутру, пошли на вершину горы, говоря: вот, мы пойдем на то место, о котором сказал Господь, ибо мы согрешили. ");
INSERT INTO russyn_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Моисей сказал: для чего вы преступаете повеление Господне? это будет безуспешно; ");
INSERT INTO russyn_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","не ходите, ибо нет среди вас Господа, чтобы не поразили вас враги ваши; ");
INSERT INTO russyn_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","ибо Амаликитяне и Хананеи там пред вами, и вы падете от меча, потому что вы отступили от Господа, и не будет с вами Господа. ");
INSERT INTO russyn_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Но они дерзнули подняться на вершину горы; ковчег же завета Господня и Моисей не оставляли стана. ");
INSERT INTO russyn_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","И сошли Амаликитяне и Хананеи, живущие на горе той, и разбили их, и гнали их до Хормы, и возвратились в стан. ");
INSERT INTO russyn_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","объяви сынам Израилевым и скажи им: когда вы войдете в землю вашего жительства, которую Я даю вам, ");
INSERT INTO russyn_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","и будете приносить жертву Господу, всесожжение, или жертву заколаемую, от волов и овец, во исполнение обета, или по усердию, или в праздники ваши, дабы сделать приятное благоухание Господу, ");
INSERT INTO russyn_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","тогда приносящий жертву свою Господу должен принести в приношение от хлеба десятую часть ефы пшеничной муки, смешанной с четвертою частью гина елея; ");
INSERT INTO russyn_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","и вина для возлияния приноси четвертую часть гина при всесожжении, или при заколаемой жертве, на каждого агнца в приятное благоухание Господу. ");
INSERT INTO russyn_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","А принося овна, приноси в приношение хлебное две десятых части ефы пшеничной муки, смешанной с третьею частью гина елея; ");
INSERT INTO russyn_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","и вина для возлияния приноси третью часть гина в приятное благоухание Господу. ");
INSERT INTO russyn_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Если молодого вола приносишь во всесожжение или жертву заколаемую, во исполнение обета или в мирную жертву Господу, ");
INSERT INTO russyn_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","то вместе с волом должно принести приношения хлебного три десятых части ефы пшеничной муки, смешанной с половиною гина елея; ");
INSERT INTO russyn_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","и вина для возлияния приноси полгина в жертву, в приятное благоухание Господу. ");
INSERT INTO russyn_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Так делай при каждом приношении вола и овна и агнца из овец, или коз; ");
INSERT INTO russyn_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","по числу жертв, которые вы приносите, так делайте при каждой, по числу их. ");
INSERT INTO russyn_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Всякий туземец так должен делать это, принося жертву в приятное благоухание Господу; ");
INSERT INTO russyn_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","и если будет между вами жить пришелец, или кто бы ни был среди вас в роды ваши, и принесет жертву в приятное благоухание Господу, то и он должен делать так, как вы делаете; ");
INSERT INTO russyn_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","для вас, общество Господне, и для пришельца, живущего у вас, устав один, устав вечный в роды ваши: что вы, то и пришелец да будет пред Господом; ");
INSERT INTO russyn_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","закон один и одни права да будут для вас и для пришельца, живущего у вас. ");
INSERT INTO russyn_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","объяви сынам Израилевым и скажи им: когда вы войдете в землю, в которую Я веду вас, ");
INSERT INTO russyn_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","и будете есть хлеб той земли, то возносите возношение Господу; ");
INSERT INTO russyn_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","от начатков теста вашего лепешку возносите в возношение; возносите ее так, как возношение с гумна; ");
INSERT INTO russyn_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","от начатков теста вашего отдавайте в возношение Господу в роды ваши. ");
INSERT INTO russyn_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Если же преступите по неведению и не исполните всех сих заповедей, которые изрек Господь Моисею, ");
INSERT INTO russyn_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","всего, что заповедал вам Господь Бог чрез Моисея, от того дня, в который Господь заповедал вам, и впредь в роды ваши, ");
INSERT INTO russyn_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","то, если по недосмотру общества сделана ошибка, пусть все общество принесет одного молодого вола без порока во всесожжение, в приятное благоухание Господу, с хлебным приношением и возлиянием его, по уставу, и одного козла в жертву за грех; ");
INSERT INTO russyn_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","и очистит священник все общество сынов Израилевых, и будет прощено им, ибо это была ошибка, и они принесли приношение свое в жертву Господу, и жертву за грех свой пред Господом, за свою ошибку; ");
INSERT INTO russyn_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","и будет прощено всему обществу сынов Израилевых и пришельцу, живущему между ними, потому что весь народ сделал это по ошибке. ");
INSERT INTO russyn_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Если же один кто согрешит по неведению, то пусть принесет козу однолетнюю в жертву за грех; ");
INSERT INTO russyn_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","и очистит священник душу, сделавшую по ошибке грех пред Господом, и очищена будет, и прощено будет ей; ");
INSERT INTO russyn_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","один закон да будет для вас, как для природного жителя из сынов Израилевых, так и для пришельца, живущего у вас, если кто сделает что по ошибке. ");
INSERT INTO russyn_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Если же кто из туземцев, или из пришельцев, сделает что дерзкою рукою, то он хулит Господа: истребится душа та из народа своего, ");
INSERT INTO russyn_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","ибо слово Господне он презрел и заповедь Его нарушил; истребится душа та; грех ее на ней. ");
INSERT INTO russyn_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Когда сыны Израилевы были в пустыне, нашли человека, собиравшего дрова в день субботы; ");
INSERT INTO russyn_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","и привели его нашедшие его собирающим дрова в день субботы к Моисею и Аарону и ко всему обществу сынов Израилевых; ");
INSERT INTO russyn_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","и посадили его под стражу, потому что не было еще определено, что должно с ним сделать. ");
INSERT INTO russyn_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","И сказал Господь Моисею: должен умереть человек сей; пусть побьет его камнями все общество вне стана. ");
INSERT INTO russyn_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","И вывело его все общество вон из стана, и побили его камнями, и он умер, как повелел Господь Моисею. ");
INSERT INTO russyn_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","объяви сынам Израилевым и скажи им, чтоб они делали себе кисти на краях одежд своих в роды их, и в кисти, которые на краях, вставляли нити из голубой шерсти; ");
INSERT INTO russyn_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","и будут они в кистях у вас для того, чтобы вы, смотря на них, вспоминали все заповеди Господни, и исполняли их, и не ходили вслед сердца вашего и очей ваших, которые влекут вас к блудодейству, ");
INSERT INTO russyn_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","чтобы вы помнили и исполняли все заповеди Мои и были святы пред Богом вашим. ");
INSERT INTO russyn_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Я Господь, Бог ваш, Который вывел вас из земли Египетской, чтоб быть вашим Богом: Я Господь, Бог ваш. ");
INSERT INTO russyn_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Корей, сын Ицгара, сын Каафов, сын Левиин, и Дафан и Авирон, сыны Елиава, и Авнан, сын Фалефа, сыны Рувимовы, ");
INSERT INTO russyn_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","восстали на Моисея, и с ними из сынов Израилевых двести пятьдесят мужей, начальники общества, призываемые на собрания, люди именитые. ");
INSERT INTO russyn_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","И собрались против Моисея и Аарона и сказали им: полно вам; все общество, все святы, и среди их Господь! почему же вы ставите себя выше народа Господня? ");
INSERT INTO russyn_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Моисей, услышав это, пал на лице свое ");
INSERT INTO russyn_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","и сказал Корею и всем сообщникам его, говоря: завтра покажет Господь, кто Его, и кто свят, чтобы приблизить его к Себе; и кого Он изберет, того и приблизит к Себе; ");
INSERT INTO russyn_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","вот что сделайте: Корей и все сообщники его возьмите себе кадильницы ");
INSERT INTO russyn_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","и завтра положите в них огня и всыпьте в них курения пред Господом; и кого изберет Господь, тот и будет свят. Полно вам, сыны Левиины! ");
INSERT INTO russyn_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","И сказал Моисей Корею: послушайте, сыны Левия! ");
INSERT INTO russyn_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","неужели мало вам того, что Бог Израилев отделил вас от общества Израильского и приблизил вас к Себе, чтобы вы исполняли службы при скинии Господней и стояли пред обществом Господним, служа для них? ");
INSERT INTO russyn_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Он приблизил тебя и с тобою всех братьев твоих, сынов Левия, и вы домогаетесь еще и священства. ");
INSERT INTO russyn_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Итак ты и все твое общество собрались против Господа. Что Аарон, что вы ропщете на него? ");
INSERT INTO russyn_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","И послал Моисей позвать Дафана и Авирона, сынов Елиава. Но они сказали: не пойдем! ");
INSERT INTO russyn_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","разве мало того, что ты вывел нас из земли, в которой течет молоко и мед, чтобы погубить нас в пустыне? и ты еще хочешь властвовать над нами! ");
INSERT INTO russyn_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","привел ли ты нас в землю, где течет молоко и мед, и дал ли нам во владение поля и виноградники? глаза людей сих ты хочешь ослепить? не пойдем! ");
INSERT INTO russyn_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Моисей весьма огорчился и сказал Господу: не обращай взора Твоего на приношение их; я не взял ни у одного из них осла и не сделал зла ни одному из них. ");
INSERT INTO russyn_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","И сказал Моисей Корею: завтра ты и все общество твое будьте пред лицом Господа, ты, они и Аарон; ");
INSERT INTO russyn_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","и возьмите каждый свою кадильницу, и положите в них курения, и принесите пред лице Господне каждый свою кадильницу, двести пятьдесят кадильниц; ты и Аарон, каждый свою кадильницу. ");
INSERT INTO russyn_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","И взял каждый свою кадильницу, и положили в них огня, и всыпали в них курения, и стали при входе в скинию собрания; также и Моисей и Аарон. ");
INSERT INTO russyn_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","И собрал против них Корей все общество ко входу скинии собрания. И явилась слава Господня всему обществу. ");
INSERT INTO russyn_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","И сказал Господь Моисею и Аарону, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","отделитесь от общества сего, и Я истреблю их во мгновение. ");
INSERT INTO russyn_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Они же пали на лица свои и сказали: Боже, Боже духов всякой плоти! один человек согрешил, и Ты гневаешься на все общество? ");
INSERT INTO russyn_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","и сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","скажи обществу: отступите со всех сторон от жилища Корея, Дафана и Авирона. ");
INSERT INTO russyn_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","И встал Моисей, и пошел к Дафану и Авирону, и за ним пошли старейшины Израилевы. ");
INSERT INTO russyn_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","И сказал обществу: отойдите от шатров нечестивых людей сих, и не прикасайтесь ни к чему, что принадлежит им, чтобы не погибнуть вам вместе во всех грехах их. ");
INSERT INTO russyn_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","И отошли они со всех сторон от жилища Корея, Дафана и Авирона; а Дафан и Авирон вышли и стояли у дверей шатров своих с женами своими и сыновьями своими и с малыми детьми своими. ");
INSERT INTO russyn_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","И сказал Моисей: из сего узнаете, что Господь послал меня делать все дела сии, а не по своему произволу я делаю сие: ");
INSERT INTO russyn_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","если они умрут, как умирают все люди, и постигнет их такое наказание, какое постигает всех людей, то не Господь послал меня; ");
INSERT INTO russyn_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","а если Господь сотворит необычайное, и земля разверзнет уста свои и поглотит их и домы их и шатры их и все, что у них, и они живые сойдут в преисподнюю, то знайте, что люди сии презрели Господа. ");
INSERT INTO russyn_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Лишь только он сказал слова сии, расселась земля под ними; ");
INSERT INTO russyn_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","и разверзла земля уста свои, и поглотила их и домы их, и всех людей Кореевых и все имущество; ");
INSERT INTO russyn_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","и сошли они со всем, что принадлежало им, живые в преисподнюю, и покрыла их земля, и погибли они из среды общества. ");
INSERT INTO russyn_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","И все Израильтяне, которые были вокруг них, побежали при их вопле, дабы, говорили они, и нас не поглотила земля. ");
INSERT INTO russyn_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","И вышел огонь от Господа и пожрал тех двести пятьдесят мужей, которые принесли курение. ");
INSERT INTO russyn_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","скажи Елеазару, сыну Аарона, священнику, пусть он соберет медные кадильницы сожженных и огонь выбросит вон; ибо освятились ");
INSERT INTO russyn_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","кадильницы грешников сих смертью их, и пусть разобьют их в листы для покрытия жертвенника, ибо они принесли их пред лице Господа, и они сделались освященными; и будут они знамением для сынов Израилевых. ");
INSERT INTO russyn_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","И взял Елеазар священник медные кадильницы, которые принесли сожженные, и разбили их в листы для покрытия жертвенника, ");
INSERT INTO russyn_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","в память сынам Израилевым, чтобы никто посторонний, который не от семени Аарона, не приступал приносить курение пред лице Господне, и не было с ним, что с Кореем и сообщниками его, как говорил ему Господь чрез Моисея. ");
INSERT INTO russyn_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","На другой день все общество сынов Израилевых возроптало на Моисея и Аарона и говорило: вы умертвили народ Господень. ");
INSERT INTO russyn_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","И когда собралось общество против Моисея и Аарона, они обратились к скинии собрания, и вот, облако покрыло ее, и явилась слава Господня. ");
INSERT INTO russyn_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","И пришел Моисей и Аарон к скинии собрания. ");
INSERT INTO russyn_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","И сказал Господь Моисею и Аарону, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","отсторонитесь от общества сего, и Я погублю их во мгновение. Но они пали на лица свои. ");
INSERT INTO russyn_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","И сказал Моисей Аарону: возьми кадильницу и положи в нее огня с жертвенника и всыпь курения, и неси скорее к обществу и заступи их, ибо вышел гнев от Господа, и началось поражение. ");
INSERT INTO russyn_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","И взял Аарон, как сказал Моисей, и побежал в среду общества, и вот, уже началось поражение в народе. И он положил курения и заступил народ; ");
INSERT INTO russyn_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","стал он между мертвыми и живыми, и поражение прекратилось. ");
INSERT INTO russyn_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","И умерло от поражения четырнадцать тысяч семьсот человек, кроме умерших по делу Корееву. ");
INSERT INTO russyn_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","И возвратился Аарон к Моисею, ко входу скинии собрания, после того как поражение прекратилось. ");
INSERT INTO russyn_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","скажи сынам Израилевым и возьми у них по жезлу от колена, от всех начальников их по коленам, двенадцать жезлов, и каждого имя напиши на жезле его; ");
INSERT INTO russyn_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","имя Аарона напиши на жезле Левиином, ибо один жезл от начальника колена их должны они дать; ");
INSERT INTO russyn_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","и положи их в скинии собрания, пред ковчегом откровения, где являюсь Я вам; ");
INSERT INTO russyn_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","и кого Я изберу, того жезл расцветет; и так Я успокою ропот сынов Израилевых, которым они ропщут на вас. ");
INSERT INTO russyn_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","И сказал Моисей сынам Израилевым, и дали ему все начальники их, от каждого начальника по жезлу, по коленам их двенадцать жезлов, и жезл Ааронов был среди жезлов их. ");
INSERT INTO russyn_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","И положил Моисей жезлы пред лицом Господа в скинии откровения. ");
INSERT INTO russyn_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","На другой день вошел Моисей и Аарон в скинию откровения, и вот, жезл Ааронов, от дома Левиина, расцвел, пустил почки, дал цвет и принес миндали. ");
INSERT INTO russyn_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","И вынес Моисей все жезлы от лица Господня ко всем сынам Израилевым. И увидели они это и взяли каждый свой жезл. ");
INSERT INTO russyn_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","И сказал Господь Моисею: положи опять жезл Ааронов пред ковчегом откровения на сохранение, в знамение для непокорных, чтобы прекратился ропот их на Меня, и они не умирали. ");
INSERT INTO russyn_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Моисей сделал это; как повелел ему Господь, так он и сделал. ");
INSERT INTO russyn_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","И сказали сыны Израилевы Моисею: вот, мы умираем, погибаем, все погибаем! ");
INSERT INTO russyn_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","всякий, приближающийся к скинии Господней, умирает: не придется ли всем нам умереть? ");
INSERT INTO russyn_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","И сказал Господь Аарону: ты и сыны твои и дом отца твоего с тобою понесете на себе грех за небрежность во святилище; и ты и сыны твои с тобою понесете на себе грех за неисправность в священстве вашем. ");
INSERT INTO russyn_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Также и братьев твоих, колено Левиино, племя отца твоего, возьми себе: пусть они будут при тебе и служат тебе, а ты и сыны твои с тобою будете при скинии откровения; ");
INSERT INTO russyn_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","пусть они отправляют службу тебе и службу во всей скинии; только чтобы не приступали к вещам святилища и к жертвеннику, дабы не умереть и им и вам. ");
INSERT INTO russyn_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Пусть они будут при тебе и отправляют службу в скинии собрания, все работы по скинии; а посторонний не должен приближаться к вам. ");
INSERT INTO russyn_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Так отправляйте службу во святилище и при жертвеннике, дабы не было впредь гнева на сынов Израилевых; ");
INSERT INTO russyn_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","ибо братьев ваших, левитов, Я взял от сынов Израилевых и дал их вам, в дар Господу, для отправления службы при скинии собрания; ");
INSERT INTO russyn_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","и ты и сыны твои с тобою наблюдайте священство ваше во всем, что принадлежит жертвеннику и что внутри за завесою, и служите; вам даю Я в дар службу священства, а посторонний, приступивший, предан будет смерти. ");
INSERT INTO russyn_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","И сказал Господь Аарону: вот, Я поручаю тебе наблюдать за возношениями Мне; от всего, посвящаемого сынами Израилевыми, Я дал тебе и сынам твоим, ради священства вашего, уставом вечным; ");
INSERT INTO russyn_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","вот, что принадлежит тебе из святынь великих, от сожигаемого: всякое приношение их хлебное, и всякая жертва их за грех, и всякая жертва их повинности, что они принесут Мне; это великая святыня тебе и сынам твоим. ");
INSERT INTO russyn_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","На святейшем месте ешьте это; все мужеского пола могут есть, ты и сыны твои; это святынею да будет для тебя. ");
INSERT INTO russyn_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","И вот, что тебе из возношений даров их: все возношения сынов Израилевых Я дал тебе и сынам твоим и дочерям твоим с тобою, уставом вечным; всякий чистый в доме твоем может есть это. ");
INSERT INTO russyn_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Все лучшее из елея и все лучшее из винограда и хлеба, начатки их, которые они дают Господу, Я отдал тебе; ");
INSERT INTO russyn_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","все первые произведения земли их, которые они принесут Господу, да будут твоими; всякий чистый в доме твоем может есть это. ");
INSERT INTO russyn_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Все заклятое в земле Израилевой да будет твоим. ");
INSERT INTO russyn_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Все, разверзающее ложесна у всякой плоти, которую приносят Господу, из людей и из скота, да будет твоим; только первенец из людей должен быть выкуплен, и первородное из скота нечистого должно быть выкуплено; ");
INSERT INTO russyn_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","а выкуп за них: начиная от одного месяца, по оценке твоей, бери выкуп пять сиклей серебра, по сиклю священному, который в двадцать гер; ");
INSERT INTO russyn_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","но за первородное из волов, и за первородное из овец, и за первородное из коз, не бери выкупа: они святыня; кровью их окропляй жертвенник, и тук их сожигай в жертву, в приятное благоухание Господу; ");
INSERT INTO russyn_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","мясо же их тебе принадлежит, равно как грудь возношения и правое плечо тебе принадлежит. ");
INSERT INTO russyn_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Все возносимые святыни, которые возносят сыны Израилевы Господу, отдаю тебе и сынам твоим и дочерям твоим с тобою, уставом вечным; это завет соли вечный пред Господом, данный для тебя и потомства твоего с тобою. ");
INSERT INTO russyn_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","И сказал Господь Аарону: в земле их не будешь иметь удела и части не будет тебе между ними; Я часть твоя и удел твой среди сынов Израилевых; ");
INSERT INTO russyn_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","а сынам Левия, вот, Я дал в удел десятину из всего, что у Израиля, за службу их, за то, что они отправляют службы в скинии собрания; ");
INSERT INTO russyn_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","и сыны Израилевы не должны впредь приступать к скинии собрания, чтобы не понести греха и не умереть: ");
INSERT INTO russyn_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","пусть левиты исправляют службы в скинии собрания и несут на себе грех их. Это устав вечный в роды ваши; среди же сынов Израилевых они не получат удела; ");
INSERT INTO russyn_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","так как десятину сынов Израилевых, которую они приносят в возношение Господу, Я отдаю левитам в удел, потому и сказал Я им: между сынами Израилевыми они не получат удела. ");
INSERT INTO russyn_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","объяви левитам и скажи им: когда вы будете брать от сынов Израилевых десятину, которую Я дал вам от них в удел, то возносите из нее возношение Господу, десятину из десятины, ");
INSERT INTO russyn_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","и вменено будет вам это возношение ваше, как хлеб с гумна и как взятое от точила; ");
INSERT INTO russyn_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","так и вы будете возносить возношение Господу из всех десятин ваших, которые будете брать от сынов Израилевых, и будете давать из них возношение Господне Аарону священнику; ");
INSERT INTO russyn_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","из всего, даруемого вам, возносите возношение Господу, из всего лучшего освящаемого. ");
INSERT INTO russyn_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","И скажи им: когда вы принесете из сего лучшее, то это вменено будет левитам, как получаемое с гумна и получаемое от точила; ");
INSERT INTO russyn_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","вы можете есть это на всяком месте, вы и сыны ваши и семейства ваши, ибо это вам плата за работы ваши в скинии собрания; ");
INSERT INTO russyn_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","и не понесете за это греха, когда принесете лучшее из сего; и посвящаемого сынами Израилевыми не оскверните, и не умрете. ");
INSERT INTO russyn_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","И сказал Господь Моисею и Аарону, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","вот устав закона, который заповедал Господь, говоря: скажи сынам Израилевым, пусть приведут тебе рыжую телицу без порока, у которой нет недостатка, и на которой не было ярма; ");
INSERT INTO russyn_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","и отдайте ее Елеазару священнику, и выведет ее вон из стана на место чистое, и заколют ее при нем; ");
INSERT INTO russyn_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","и пусть возьмет Елеазар священник перстом своим крови ее и кровью покропит к передней стороне скинии собрания семь раз; ");
INSERT INTO russyn_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","и сожгут телицу при его глазах: кожу ее и мясо ее и кровь ее с нечистотою ее пусть сожгут; ");
INSERT INTO russyn_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","и пусть возьмет священник кедрового дерева и иссопа и нить из червленой шерсти и бросит на сожигаемую телицу; ");
INSERT INTO russyn_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","и пусть вымоет священник одежды свои, и омоет тело свое водою, и потом войдет в стан, и нечист будет священник до вечера. ");
INSERT INTO russyn_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","И сожигавший ее пусть вымоет одежды свои водою, и омоет тело свое водою, и нечист будет до вечера; ");
INSERT INTO russyn_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","и кто-нибудь чистый пусть соберет пепел телицы и положит вне стана на чистом месте, и будет он сохраняться для общества сынов Израилевых, для воды очистительной: это жертва за грех; ");
INSERT INTO russyn_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","и собиравший пепел телицы пусть вымоет одежды свои, и нечист будет до вечера. Это для сынов Израилевых и для пришельцев, живущих у них, да будет уставом вечным. ");
INSERT INTO russyn_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Кто прикоснется к мертвому телу какого-либо человека, нечист будет семь дней: ");
INSERT INTO russyn_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","он должен очистить себя сею водою в третий день и в седьмой день, и будет чист; если же он не очистит себя в третий и седьмой день, то не будет чист; ");
INSERT INTO russyn_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","всякий, прикоснувшийся к мертвому телу какого-либо человека умершего и не очистивший себя, осквернит жилище Господа: истребится человек тот из среды Израиля, ибо он не окроплен очистительною водою, он нечист, еще нечистота его на нем. ");
INSERT INTO russyn_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Вот закон: если человек умрет в шатре, то всякий, кто придет в шатер, и все, что в шатре, нечисто будет семь дней; ");
INSERT INTO russyn_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","всякий открытый сосуд, который не обвязан и не покрыт, нечист. ");
INSERT INTO russyn_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Всякий, кто прикоснется на поле к убитому мечом, или к умершему, или к кости человеческой, или ко гробу, нечист будет семь дней. ");
INSERT INTO russyn_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Для нечистого пусть возьмут пепла той сожженной жертвы за грех и нальют на него живой воды в сосуд; ");
INSERT INTO russyn_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","и пусть кто-нибудь чистый возьмет иссоп, и омочит его в воде, и окропит шатер и все сосуды и людей, которые находятся в нем, и прикоснувшегося к кости человеческой, или к убитому, или к умершему, или ко гробу; ");
INSERT INTO russyn_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","и пусть окропит чистый нечистого в третий и седьмой день, и очистит его в седьмой день; и вымоет он одежды свои, и омоет тело свое водою, и к вечеру будет чист. ");
INSERT INTO russyn_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Если же кто будет нечист и не очистит себя, то истребится человек тот из среды народа, ибо он осквернил святилище Господа; очистительною водою он не окроплен, он нечист. ");
INSERT INTO russyn_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","И да будет это для них уставом вечным. И кропивший очистительною водою пусть вымоет одежды свои; и прикоснувшийся к очистительной воде нечист будет до вечера. ");
INSERT INTO russyn_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","И все, к чему прикоснется нечистый, будет нечисто; и прикоснувшийся человек нечист будет до вечера. ");
INSERT INTO russyn_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","И пришли сыны Израилевы, все общество, в пустыню Син в первый месяц, и остановился народ в Кадесе, и умерла там Мариам и погребена там. ");
INSERT INTO russyn_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","И не было воды для общества, и собрались они против Моисея и Аарона; ");
INSERT INTO russyn_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","и возроптал народ на Моисея и сказал: о, если бы умерли тогда и мы, когда умерли братья наши пред Господом! ");
INSERT INTO russyn_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","зачем вы привели общество Господне в эту пустыню, чтобы умереть здесь нам и скоту нашему? ");
INSERT INTO russyn_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","и для чего вывели вы нас из Египта, чтобы привести нас на это негодное место, где нельзя сеять, нет ни смоковниц, ни винограда, ни гранатовых яблок, ни даже воды для питья? ");
INSERT INTO russyn_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","И пошел Моисей и Аарон от народа ко входу скинии собрания, и пали на лица свои, и явилась им слава Господня. ");
INSERT INTO russyn_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","Возьми жезл и собери общество, ты и Аарон, брат твой, и скажите в глазах их скале, и она даст из себя воду: и так ты изведешь им воду из скалы, и напоишь общество и скот его. ");
INSERT INTO russyn_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","И взял Моисей жезл от лица Господа, как Он повелел ему. ");
INSERT INTO russyn_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","И собрали Моисей и Аарон народ к скале, и сказал он им: послушайте, непокорные, разве нам из этой скалы извести для вас воду? ");
INSERT INTO russyn_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","И поднял Моисей руку свою и ударил в скалу жезлом своим дважды, и потекло много воды, и пило общество и скот его. ");
INSERT INTO russyn_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","И сказал Господь Моисею и Аарону: за то, что вы не поверили Мне, чтоб явить святость Мою пред очами сынов Израилевых, не введете вы народа сего в землю, которую Я даю ему. ");
INSERT INTO russyn_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Это вода Меривы, у которой вошли в распрю сыны Израилевы с Господом, и Он явил им святость Свою. ");
INSERT INTO russyn_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","И послал Моисей из Кадеса послов к царю Едомскому сказать: так говорит брат твой Израиль: ты знаешь все трудности, которые постигли нас; ");
INSERT INTO russyn_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","отцы наши перешли в Египет, и мы жили в Египте много времени, и худо поступали Египтяне с нами и отцами нашими; ");
INSERT INTO russyn_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","и воззвали мы к Господу, и услышал Он голос наш, и послал Ангела, и вывел нас из Египта; и вот, мы в Кадесе, городе у самого предела твоего; ");
INSERT INTO russyn_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","позволь нам пройти землею твоею: мы не пойдем по полям и по виноградникам и не будем пить воды из колодезей твоих; но пойдем дорогою царскою, не своротим ни направо ни налево, доколе не перейдем пределов твоих. ");
INSERT INTO russyn_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Но Едом сказал ему: не проходи через меня, иначе я с мечом выступлю против тебя. ");
INSERT INTO russyn_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","И сказали ему сыны Израилевы: мы пойдем большою дорогою, и если будем пить твою воду, я и скот мой, то буду платить за нее; только ногами моими пройду, что ничего не стоит. ");
INSERT INTO russyn_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Но он сказал: не проходи через меня. И выступил против него Едом с многочисленным народом и с сильною рукою. ");
INSERT INTO russyn_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Итак не согласился Едом позволить Израилю пройти чрез его пределы, и Израиль пошел в сторону от него. ");
INSERT INTO russyn_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","И отправились сыны Израилевы из Кадеса, и пришло все общество к горе Ор. ");
INSERT INTO russyn_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","И сказал Господь Моисею и Аарону на горе Ор, у пределов земли Едомской, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","пусть приложится Аарон к народу своему; ибо он не войдет в землю, которую Я даю сынам Израилевым, за то, что вы непокорны были повелению Моему у вод Меривы; ");
INSERT INTO russyn_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","и возьми Аарона брата твоего и Елеазара, сына его, и возведи их на гору Ор пред всем обществом; ");
INSERT INTO russyn_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","и сними с Аарона одежды его, и облеки в них Елеазара, сына его, и пусть Аарон отойдет и умрет там. ");
INSERT INTO russyn_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","И сделал Моисей так, как повелел Господь. Пошли они на гору Ор в глазах всего общества, ");
INSERT INTO russyn_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","и снял Моисей с Аарона одежды его, и облек в них Елеазара, сына его; и умер там Аарон на вершине горы. А Моисей и Елеазар сошли с горы. ");
INSERT INTO russyn_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","И увидело все общество, что Аарон умер, и оплакивал Аарона весь дом Израилев тридцать дней. ");
INSERT INTO russyn_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Ханаанский царь Арада, живущий к югу, услышав, что Израиль идет дорогою от Афарима, вступил в сражение с Израильтянами и несколько из них взял в плен. ");
INSERT INTO russyn_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","И дал Израиль обет Господу, и сказал: если предашь народ сей в руки мои, то положу заклятие на них и на города их. ");
INSERT INTO russyn_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Господь услышал голос Израиля и предал Хананеев в руки ему, и он положил заклятие на них и на города их и нарек имя месту тому: Хорма. ");
INSERT INTO russyn_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","От горы Ор отправились они путем Чермного моря, чтобы миновать землю Едома. И стал малодушествовать народ на пути, ");
INSERT INTO russyn_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","и говорил народ против Бога и против Моисея: зачем вывели вы нас из Египта, чтоб умереть нам в пустыне, ибо здесь нет ни хлеба, ни воды, и душе нашей опротивела эта негодная пища. ");
INSERT INTO russyn_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","И послал Господь на народ ядовитых змеев, которые жалили народ, и умерло множество народа из сынов Израилевых. ");
INSERT INTO russyn_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","И пришел народ к Моисею и сказал: согрешили мы, что говорили против Господа и против тебя; помолись Господу, чтоб Он удалил от нас змеев. И помолился Моисей Господу о народе. ");
INSERT INTO russyn_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","И сказал Господь Моисею: сделай себе медного змея и выставь его на знамя, и если ужалит змей какого-либо человека, ужаленный, взглянув на него, останется жив. ");
INSERT INTO russyn_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","И сделал Моисей медного змея и выставил его на знамя, и когда змей ужалил человека, он, взглянув на медного змея, оставался жив. ");
INSERT INTO russyn_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","И отправились сыны Израилевы и остановились в Овофе; ");
INSERT INTO russyn_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","и отправились из Овофа и остановились в Ийе-Авариме, в пустыне, что против Моава, к восходу солнца; ");
INSERT INTO russyn_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","оттуда отправились, и остановились на долине Заред; ");
INSERT INTO russyn_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","отправившись отсюда, остановились у той части Арнона в пустыне, которая течет вне пределов Аморрея, ибо Арнон граница Моава, между Моавом и Аморреем. ");
INSERT INTO russyn_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Потому и сказано в книге браней Господних: ");
INSERT INTO russyn_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","Вагеб в Суфе и потоки Арнона, и верховье потоков, которое склоняется к Шебет-Ару и прилегает к пределам Моава. ");
INSERT INTO russyn_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Отсюда отправились к Беэр; это тот колодезь, о котором Господь сказал Моисею: собери народ, и дам им воды. ");
INSERT INTO russyn_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Тогда воспел Израиль песнь сию: наполняйся, колодезь, пойте ему; ");
INSERT INTO russyn_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","колодезь, который выкопали князья, вырыли вожди народа с законодателем жезлами своими. Из пустыни отправились в Матанну, ");
INSERT INTO russyn_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","из Матанны в Нагалиил, из Нагалиила в Вамоф, ");
INSERT INTO russyn_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","из Вамофа в Гай, который в земле Моава, на вершине горы Фасги, обращенной лицем к пустыне. ");
INSERT INTO russyn_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","И послал Израиль послов к Сигону, царю Аморрейскому, с предложением мирным, чтобы сказать: ");
INSERT INTO russyn_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","позволь мне пройти землею твоею; мы пойдем дорогою, не будем заходить в поля и виноградники, не будем пить воды из колодезей твоих, а пойдем путем царским, доколе не перейдем пределов твоих. ");
INSERT INTO russyn_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Но Сигон не позволил Израилю идти через свои пределы; и собрал Сигон весь народ свой и выступил против Израиля в пустыню, и дошел до Иаацы, и сразился с Израилем. ");
INSERT INTO russyn_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","И поразил его Израиль мечом и взял во владение землю его от Арнона до Иавока, до пределов Аммонитских, ибо крепок был предел Аммонитян; ");
INSERT INTO russyn_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","и взял Израиль все города сии, и жил Израиль во всех городах Аморрейских, в Есевоне и во всех зависящих от него; ");
INSERT INTO russyn_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","ибо Есевон был город Сигона, царя Аморрейского, и он воевал с прежним царем Моавитским и взял из руки его всю землю его до Арнона. ");
INSERT INTO russyn_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Потому говорят приточники: идите в Есевон, да устроят и утвердят город Сигона; ");
INSERT INTO russyn_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","ибо огонь вышел из Есевона, пламень из города Сигонова, и пожрал Ар-Моав и владеющих высотами Арнона. ");
INSERT INTO russyn_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Горе тебе, Моав! погиб ты, народ Хамоса! Разбежались сыновья его, и дочери его сделались пленницами Аморрейского царя Сигона; ");
INSERT INTO russyn_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","мы поразили их стрелами; погиб Есевон до Дивона, мы опустошили их до Нофы, которая близ Медевы. ");
INSERT INTO russyn_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","И жил Израиль в земле Аморрейской. ");
INSERT INTO russyn_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","И послал Моисей высмотреть Иазер, и взяли его и селения, зависящие от него, и прогнали Аморреев, которые в них были. ");
INSERT INTO russyn_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","И поворотили и пошли к Васану. И выступил против них Ог, царь Васанский, сам и весь народ его, на сражение к Едреи. ");
INSERT INTO russyn_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","И сказал Господь Моисею: не бойся его, ибо Я предам его и весь народ его и всю землю его в руки твои, и поступишь с ним, как поступил с Сигоном, царем Аморрейским, который жил в Есевоне. ");
INSERT INTO russyn_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","И поразили они его и сынов его и весь народ его, так что ни одного не осталось живого, и овладели землею его. ");
INSERT INTO russyn_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","И отправились сыны Израилевы, и остановились на равнинах Моава, при Иордане, против Иерихона. ");
INSERT INTO russyn_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","И видел Валак, сын Сепфоров, все, что сделал Израиль Аморреям; ");
INSERT INTO russyn_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","и весьма боялись Моавитяне народа сего, потому что он был многочислен; и устрашились Моавитяне сынов Израилевых. ");
INSERT INTO russyn_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","И сказали Моавитяне старейшинам Мадиамским: этот народ поедает теперь все вокруг нас, как вол поедает траву полевую. Валак же, сын Сепфоров, был царем Моавитян в то время. ");
INSERT INTO russyn_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","И послал он послов к Валааму, сыну Веорову, в Пефор, который на реке Евфрате, в земле сынов народа его, чтобы позвать его и сказать: вот, народ вышел из Египта и покрыл лице земли, и живет он подле меня; ");
INSERT INTO russyn_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","итак приди, прокляни мне народ сей, ибо он сильнее меня: может быть, я тогда буду в состоянии поразить его и выгнать его из земли; я знаю, что кого ты благословишь, тот благословен, и кого ты проклянешь, тот проклят. ");
INSERT INTO russyn_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","И пошли старейшины Моавитские и старейшины Мадиамские, с подарками в руках за волхвование, и пришли к Валааму, и пересказали ему слова Валаковы. ");
INSERT INTO russyn_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","И сказал он им: переночуйте здесь ночь, и дам вам ответ, как скажет мне Господь. И остались старейшины Моавитские у Валаама. ");
INSERT INTO russyn_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","И пришел Бог к Валааму и сказал: какие это люди у тебя? ");
INSERT INTO russyn_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Валаам сказал Богу: Валак, сын Сепфоров, царь Моавитский, прислал их ко мне сказать: ");
INSERT INTO russyn_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","вот, народ вышел из Египта и покрыл лице земли, и живет подле меня; итак приди, прокляни мне его; может быть, я тогда буду в состоянии сразиться с ним и выгнать его из земли. ");
INSERT INTO russyn_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","И сказал Бог Валааму: не ходи с ними, не проклинай народа сего, ибо он благословен. ");
INSERT INTO russyn_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","И встал Валаам поутру и сказал князьям Валаковым: пойдите в землю вашу, ибо не хочет Господь позволить мне идти с вами. ");
INSERT INTO russyn_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","И встали князья Моавитские, и пришли к Валаку, и сказали ему: не согласился Валаам идти с нами. ");
INSERT INTO russyn_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Валак послал еще князей, более и знаменитее тех. ");
INSERT INTO russyn_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","И пришли они к Валааму и сказали ему: так говорит Валак, сын Сепфоров: не откажись прийти ко мне; ");
INSERT INTO russyn_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","я окажу тебе великую почесть и сделаю тебе все, что ни скажешь мне; приди же, прокляни мне народ сей. ");
INSERT INTO russyn_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","И отвечал Валаам и сказал рабам Валаковым: хотя бы Валак давал мне полный свой дом серебра и золота, не могу преступить повеления Господа, Бога моего, и сделать что-либо малое или великое по своему произволу; ");
INSERT INTO russyn_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","впрочем, останьтесь здесь и вы на ночь, и я узнаю, что еще скажет мне Господь. ");
INSERT INTO russyn_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","И пришел Бог к Валааму ночью и сказал ему: если люди сии пришли звать тебя, встань, пойди с ними; но только делай то, что Я буду говорить тебе. ");
INSERT INTO russyn_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Валаам встал поутру, оседлал ослицу свою и пошел с князьями Моавитскими. ");
INSERT INTO russyn_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","И воспылал гнев Божий за то, что он пошел, и стал Ангел Господень на дороге, чтобы воспрепят-ствовать ему. Он ехал на ослице своей и с ним двое слуг его. ");
INSERT INTO russyn_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","И увидела ослица Ангела Господня, стоящего на дороге с обнаженным мечом в руке, и своротила ослица с дороги, и пошла на поле; а Валаам стал бить ослицу, чтобы возвратить ее на дорогу. ");
INSERT INTO russyn_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","И стал Ангел Господень на узкой дороге, между виноградниками, где с одной стороны стена и с другой стороны стена. ");
INSERT INTO russyn_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Ослица, увидев Ангела Господня, прижалась к стене и прижала ногу Валаамову к стене; и он опять стал бить ее. ");
INSERT INTO russyn_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Ангел Господень опять перешел и стал в тесном месте, где некуда своротить, ни направо, ни налево. ");
INSERT INTO russyn_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Ослица, увидев Ангела Господня, легла под Валаамом. И воспылал гнев Валаама, и стал он бить ослицу палкою. ");
INSERT INTO russyn_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","И отверз Господь уста ослицы, и она сказала Валааму: что я тебе сделала, что ты бьешь меня вот уже третий раз? ");
INSERT INTO russyn_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Валаам сказал ослице: за то, что ты поругалась надо мною; если бы у меня в руке был меч, то я теперь же убил бы тебя. ");
INSERT INTO russyn_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Ослица же сказала Валааму: не я ли твоя ослица, на которой ты ездил с начала до сего дня? имела ли я привычку так поступать с тобою? Он сказал: нет. ");
INSERT INTO russyn_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","И открыл Господь глаза Валааму, и увидел он Ангела Господня, стоящего на дороге с обнаженным мечом в руке, и преклонился, и пал на лице свое. ");
INSERT INTO russyn_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","И сказал ему Ангел Господень: за что ты бил ослицу твою вот уже три раза? Я вышел, чтобы воспрепятствовать тебе, потому что путь твой не прав предо Мною; ");
INSERT INTO russyn_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","и ослица, видев Меня, своротила от Меня вот уже три раза; если бы она не своротила от Меня, то Я убил бы тебя, а ее оставил бы живою. ");
INSERT INTO russyn_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","И сказал Валаам Ангелу Господню: согрешил я, ибо не знал, что Ты стоишь против меня на дороге; итак, если это неприятно в очах Твоих, то я возвращусь. ");
INSERT INTO russyn_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","И сказал Ангел Господень Валааму: пойди с людьми сими, только говори то, что Я буду говорить тебе. И пошел Валаам с князьями Валаковыми. ");
INSERT INTO russyn_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Валак, услышав, что идет Валаам, вышел навстречу ему в город Моавитский, который на границе при Арноне, что у самого предела. ");
INSERT INTO russyn_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","И сказал Валак Валааму: не посылал ли я к тебе, звать тебя? почему ты не шел ко мне? неужели я в самом деле не могу почтить тебя? ");
INSERT INTO russyn_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","И сказал Валаам Валаку: вот, я и пришел к тебе, но могу ли я что от себя сказать? что вложит Бог в уста мои, то и буду говорить. ");
INSERT INTO russyn_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","И пошел Валаам с Валаком и пришли в Кириаф-Хуцоф. ");
INSERT INTO russyn_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","И заколол Валак волов и овец, и послал к Валааму и князьям, которые были с ним. ");
INSERT INTO russyn_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","На другой день утром Валак взял Валаама и возвел его на высоты Вааловы, чтобы он увидел оттуда часть народа. ");
INSERT INTO russyn_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","И сказал Валаам Валаку: построй мне здесь семь жертвенников и приготовь мне семь тельцов и семь овнов. ");
INSERT INTO russyn_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Валак сделал так, как говорил Валаам, и вознесли Валак и Валаам по тельцу и по овну на каждом жертвеннике. ");
INSERT INTO russyn_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","И сказал Валаам Валаку: постой у всесожжения твоего, а я пойду; может быть, Господь выйдет мне навстречу, и что Он откроет мне, я объявлю тебе. И остался Валак у всесожжения своего, а Валаам пошел на возвышенное место вопросить Бога. ");
INSERT INTO russyn_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","И встретился Бог с Валаамом, и сказал ему Валаам: семь жертвенников устроил я и вознес по тельцу и по овну на каждом жертвен-нике. ");
INSERT INTO russyn_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","И вложил Господь слово в уста Валаамовы и сказал: возвратись к Валаку и так говори. ");
INSERT INTO russyn_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","И возвратился к нему, и вот, он стоит у всесожжения своего, он и все князья Моавитские. И был на нем Дух Божий. ");
INSERT INTO russyn_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","И произнес притчу свою и сказал: из Месопотамии привел меня Валак, царь Моава, от гор восточных: приди, прокляни мне Иакова, приди, изреки зло на Израиля! ");
INSERT INTO russyn_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Как прокляну я? Бог не проклинает его. Как изреку зло? Господь не изрекает на него зла. ");
INSERT INTO russyn_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","С вершины скал вижу я его, и с холмов смотрю на него: вот, народ живет отдельно и между народами не числится. ");
INSERT INTO russyn_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Кто исчислит песок Иакова и число четвертой части Израиля? Да умрет душа моя смертью праведников, и да будет кончина моя, как их! ");
INSERT INTO russyn_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","И сказал Валак Валааму: что ты со мною делаешь? я взял тебя, чтобы проклясть врагов моих, а ты, вот, благословляешь? ");
INSERT INTO russyn_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","И отвечал он и сказал: не должен ли я в точности сказать то, что влагает Господь в уста мои? ");
INSERT INTO russyn_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","И сказал ему Валак: пойди со мною на другое место, с которого ты увидишь его, но только часть его увидишь, а всего его не увидишь; и прокляни мне его оттуда. ");
INSERT INTO russyn_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","И взял его на место стражей, на вершину горы Фасги, и построил семь жертвенников, и вознес по тельцу и по овну на каждом жертвеннике. ");
INSERT INTO russyn_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","И сказал Валаам Валаку: постой здесь у всесожжения твоего, а я пойду туда навстречу Богу. ");
INSERT INTO russyn_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","И встретился Господь с Валаамом, и вложил слово в уста его, и сказал: возвратись к Валаку и так говори. ");
INSERT INTO russyn_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","И пришел к нему, и вот, он стоит у всесожжения своего, и с ним все князья Моавитские. И сказал ему Валак: что говорил Господь? ");
INSERT INTO russyn_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Он произнес притчу свою и сказал: встань, Валак, и послушай, внимай мне, сын Сепфоров. ");
INSERT INTO russyn_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Бог не человек, чтоб Ему лгать, и не сын человеческий, чтоб Ему изменяться. Он ли скажет и не сделает? будет говорить и не исполнит? ");
INSERT INTO russyn_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Вот, благословлять начал я, ибо Он благословил, и я не могу изменить сего. ");
INSERT INTO russyn_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Не видно бедствия в Иакове, и не заметно несчастья в Израиле; Господь, Бог его, с ним, и трубный царский звук у него; ");
INSERT INTO russyn_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Бог вывел их из Египта, быстрота единорога у него; ");
INSERT INTO russyn_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","нет волшебства в Иакове и нет ворожбы в Израиле. В свое время скажут об Иакове и об Израиле: вот что творит Бог! ");
INSERT INTO russyn_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Вот, народ как львица встает и как лев поднимается; не ляжет, пока не съест добычи и не напьется крови убитых. ");
INSERT INTO russyn_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","И сказал Валак Валааму: ни клясть не кляни его, ни благословлять не благословляй его. ");
INSERT INTO russyn_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","И отвечал Валаам и сказал Валаку: не говорил ли я тебе, что я буду делать все то, что скажет мне Господь? ");
INSERT INTO russyn_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","И сказал Валак Валааму: пойди, я возьму тебя на другое место; может быть, угодно будет Богу, и оттуда проклянешь мне его. ");
INSERT INTO russyn_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","И взял Валак Валаама на верх Фегора, обращенного к пустыне. ");
INSERT INTO russyn_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","И сказал Валаам Валаку: построй мне здесь семь жертвенников и приготовь мне здесь семь тельцов и семь овнов. ");
INSERT INTO russyn_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","И сделал Валак, как сказал Валаам, и вознес по тельцу и овну на каждом жертвеннике. ");
INSERT INTO russyn_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Валаам увидел, что Господу угодно благословлять Израиля, и не пошел, как прежде, для волхвования, но обратился лицем своим к пустыне. ");
INSERT INTO russyn_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","И взглянул Валаам и увидел Израиля, стоявшего по коленам своим, и был на нем Дух Божий. ");
INSERT INTO russyn_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","И произнес он притчу свою и сказал: говорит Валаам, сын Веоров, говорит муж с открытым оком, ");
INSERT INTO russyn_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","говорит слышащий слова Божии, который видит видения Всемогущего; падает, но открыты глаза его: ");
INSERT INTO russyn_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","как прекрасны шатры твои, Иаков, жилища твои, Израиль! ");
INSERT INTO russyn_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","расстилаются они как долины, как сады при реке, как алойные дерева, насажденные Господом, как кедры при водах; ");
INSERT INTO russyn_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","польется вода из ведр его, и семя его будет как великие воды, превзойдет Агага царь его и возвысится царство его. ");
INSERT INTO russyn_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Бог вывел его из Египта, быстрота единорога у него, пожирает народы, враждебные ему, раздробляет кости их и стрелами своими разит врага. ");
INSERT INTO russyn_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Преклонился, лежит как лев и как львица, кто поднимет его? Благословляющий тебя благословен, и проклинающий тебя проклят! ");
INSERT INTO russyn_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","И воспламенился гнев Валака на Валаама, и всплеснул он руками своими, и сказал Валак Валааму: я призвал тебя проклясть врагов моих, а ты благословляешь их вот уже третий раз; ");
INSERT INTO russyn_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","итак, беги в свое место; я хотел почтить тебя, но вот, Господь лишает тебя чести. ");
INSERT INTO russyn_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","И сказал Валаам Валаку: не говорил ли я послам твоим, которых ты присылал ко мне: ");
INSERT INTO russyn_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","“хотя бы давал мне Валак полный свой дом серебра и золота, не могу преступить повеления Господня, чтобы сделать что-либо доброе или худое по своему произволу: что скажет Господь, то и буду говорить”? ");
INSERT INTO russyn_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Итак, вот, я иду к народу своему; пойди, я возвещу тебе, что сделает народ сей с народом твоим в последствие времени. ");
INSERT INTO russyn_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","И произнес притчу свою и сказал: говорит Валаам, сын Веоров, говорит муж с открытым оком, ");
INSERT INTO russyn_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","говорит слышащий слова Божии, имеющий ведение от Всевышнего, который видит видения Всемогущего, падает, но открыты очи его. ");
INSERT INTO russyn_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Вижу Его, но ныне еще нет; зрю Его, но не близко. Восходит звезда от Иакова и восстает жезл от Израиля, и разит князей Моава и сокрушает всех сынов Сифовых. ");
INSERT INTO russyn_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Едом будет под владением, Сеир будет под владением врагов своих, а Израиль явит силу свою. ");
INSERT INTO russyn_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Происшедший от Иакова овладеет и погубит оставшееся от города. ");
INSERT INTO russyn_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","И увидел он Амалика, и произнес притчу свою, и сказал: первый из народов Амалик, но конец его - гибель. ");
INSERT INTO russyn_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","И увидел он Кенеев, и произнес притчу свою, и сказал: крепко жилище твое, и на скале положено гнездо твое; ");
INSERT INTO russyn_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","но разорен будет Каин, и недолго до того, что Ассур уведет тебя в плен. ");
INSERT INTO russyn_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","И увидев Ога, произнес притчу свою, и сказал: горе, горе, кто уцелеет, когда наведет сие Бог! ");
INSERT INTO russyn_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","придут корабли от Киттима, и смирят Ассура, и смирят Евера; но и им гибель! ");
INSERT INTO russyn_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","И встал Валаам и пошел обратно в свое место, а Валак также пошел своею дорогою. ");
INSERT INTO russyn_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","И жил Израиль в Ситтиме, и начал народ блудодействовать с дочерями Моава, ");
INSERT INTO russyn_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","и приглашали они народ к жертвам богов своих, и ел народ жертвы их и кланялся богам их. ");
INSERT INTO russyn_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","И прилепился Израиль к Ваал-Фегору. И воспламенился гнев Господень на Израиля. ");
INSERT INTO russyn_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","И сказал Господь Моисею: возьми всех начальников народа и повесь их Господу перед солнцем, и отвратится от Израиля ярость гнева Господня. ");
INSERT INTO russyn_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","И сказал Моисей судьям Израилевым: убейте каждый людей своих, прилепившихся к Ваал-Фегору. ");
INSERT INTO russyn_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","И вот, некто из сынов Израилевых пришел и привел к братьям своим Мадианитянку, в глазах Моисея и в глазах всего общества сынов Израилевых, когда они плакали у входа скинии собрания. ");
INSERT INTO russyn_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Финеес, сын Елеазара, сына Аарона священника, увидев это, встал из среды общества и взял в руку свою копье, ");
INSERT INTO russyn_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","и вошел вслед за Израильтянином в спальню и пронзил обоих их, Израильтянина и женщину в чрево ее: и прекратилось поражение сынов Израилевых. ");
INSERT INTO russyn_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Умерших же от поражения было двадцать четыре тысячи. ");
INSERT INTO russyn_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","Финеес, сын Елеазара, сына Аарона священника, отвратил ярость Мою от сынов Израилевых, возревновав по Мне среди их, и Я не истребил сынов Израилевых в ревности Моей; ");
INSERT INTO russyn_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","посему скажи: вот, Я даю ему Мой завет мира, ");
INSERT INTO russyn_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","и будет он ему и потомству его по нем заветом священства вечного, за то, что он показал ревность по Боге своем и заступил сынов Израилевых. ");
INSERT INTO russyn_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Имя убитого Израильтянина, который убит с Мадианитянкою, было Зимри, сын Салу, начальник поколения Симеонова; ");
INSERT INTO russyn_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","а имя убитой Мадианитянки Хазва; она была дочь Цура, начальника Оммофа, племени Мадиамского. ");
INSERT INTO russyn_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","враждуйте с Мадианитянами, и поражайте их, ");
INSERT INTO russyn_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","ибо они враждебно поступили с вами в коварстве своем, прельстив вас Фегором и Хазвою, дочерью начальника Мадиамского, сестрою своею, убитою в день поражения за Фегора. ");
INSERT INTO russyn_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","После сего поражения сказал Господь Моисею и Елеазару, сыну Аарона, священнику, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","исчислите все общество сынов Израилевых от двадцати лет и выше, по семействам их, всех годных для войны у Израиля. ");
INSERT INTO russyn_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","И сказал им Моисей и Елеазар священник на равнинах Моавитских у Иордана, против Иерихона, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","исчислите всех от двадцати лет и выше, как повелел Господь Моисею и сынам Израилевым, которые вышли из земли Египетской: ");
INSERT INTO russyn_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Рувим, первенец Израиля. Сыны Рувима: от Ханоха поколение Ханохово, от Фаллу поколение Фаллуево, ");
INSERT INTO russyn_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","от Хецрона поколение Хецроново, от Харми поколение Хармиево; ");
INSERT INTO russyn_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","вот поколения Рувимовы; и исчислено их сорок три тысячи семьсот тридцать. ");
INSERT INTO russyn_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","И сыны Фаллуя: Елиав. ");
INSERT INTO russyn_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Сыны Елиава: Немуил, Дафан и Авирон. Это те Дафан и Авирон, призываемые в собрание, которые произвели возмущение против Моисея и Аарона вместе с сообщниками Корея, когда сии произвели возмущение против Господа; ");
INSERT INTO russyn_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","и разверзла земля уста свои, и поглотила их и Корея; вместе с ними умерли и сообщники их, когда огонь пожрал двести пятьдесят человек, и стали они в знамение; ");
INSERT INTO russyn_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","но сыны Кореевы не умерли. ");
INSERT INTO russyn_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Сыны Симеона по поколениям их: от Немуила поколение Немуилово, от Ямина поколение Яминово, от Яхина поколение Яхиново, ");
INSERT INTO russyn_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","от Зары поколение Зарино, от Саула поколение Саулово; ");
INSERT INTO russyn_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","вот поколения Симеоновы при исчислении их: двадцать две тысячи двести. ");
INSERT INTO russyn_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Сыны Гада по поколениям их: от Цефона поколение Цефоново, от Хаггия поколение Хаггиево, от Шуния поколение Шуниево, ");
INSERT INTO russyn_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","от Озния поколение Озниево, от Ерия поколение Ериево, ");
INSERT INTO russyn_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","от Арода поколение Ародово, от Арелия поколение Арелиево; ");
INSERT INTO russyn_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","вот поколения сынов Гадовых, по исчислению их: сорок тысяч пятьсот. ");
INSERT INTO russyn_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Сыны Иуды: Ир и Онан, Шела, Фарес и Зара; но Ир и Онан умерли в земле Ханаанской; ");
INSERT INTO russyn_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","и были сыны Иуды по поколениям их: от Шелы поколение Шелино, от Фареса поколение Фаресово, от Зары поколение Зарино; ");
INSERT INTO russyn_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","и были сыны Фаресовы: от Есрома поколение Есромово, от Хамула поколение Хамулово; ");
INSERT INTO russyn_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","вот поколения Иудины, по исчислению их: семьдесят шесть тысяч пятьсот. ");
INSERT INTO russyn_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Сыны Иссахаровы по поколениям их: от Фолы поколение Фолино, от Фувы поколение Фувино, ");
INSERT INTO russyn_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","от Иашува поколение Иашувово, от Шимрона поколение Шимроново; ");
INSERT INTO russyn_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","вот поколения Иссахаровы, по исчислению их: шестьдесят четыре тысячи триста. ");
INSERT INTO russyn_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Сыны Завулона по поколениям их: от Середа поколение Середово, от Елона поколение Елоново, от Иахлеила поколение Иахлеилово; ");
INSERT INTO russyn_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","вот поколения Завулоновы, по исчислению их: шестьдесят тысяч пятьсот. ");
INSERT INTO russyn_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Сыны Иосифа по поколениям их: Манассия и Ефрем. ");
INSERT INTO russyn_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Сыны Манассии: от Махира поколение Махирово; от Махира родился Галаад, от Галаада поколение Галаадово. ");
INSERT INTO russyn_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Вот сыны Галаадовы: от Иезера поколение Иезерово, от Хелека поколение Хелеково, ");
INSERT INTO russyn_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","от Асриила поколение Асриилово, от Шехема поколение Шехемово, ");
INSERT INTO russyn_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","от Шемиды поколение Шемидино, от Хефера поколение Хеферово. ");
INSERT INTO russyn_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","У Салпаада, сына Хеферова, не было сыновей, а только дочери; имя дочерей Салпаадовых: Махла, Ноа, Хогла, Милка и Фирца. ");
INSERT INTO russyn_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Вот поколения Манассиины; а исчислено их пятьдесят две тысячи семьсот. ");
INSERT INTO russyn_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Вот сыны Ефремовы по поколениям их: от Шутелы поколение Шутелино, от Бехера поколение Бехерово, от Тахана поколение Таханово; ");
INSERT INTO russyn_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","и вот сыны Шутелы: от Арана поколение Араново; ");
INSERT INTO russyn_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","вот поколения сынов Ефремовых, по исчислению их: тридцать две тысячи пятьсот. Вот сыны Иосифовы по поколениям их. ");
INSERT INTO russyn_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Сыны Вениамина по поколениям их: от Белы поколение Белино, от Ашбела поколение Ашбелово, от Ахирама поколение Ахирамово, ");
INSERT INTO russyn_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","от Шефуфама поколение Шефуфамово, от Хуфама поколение Хуфамово; ");
INSERT INTO russyn_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","и были сыны Белы: Ард и Нааман; от Арда поколение Ардово, от Наамана поколение Нааманово; ");
INSERT INTO russyn_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","вот сыны Вениамина по поколениям их; а исчислено их сорок пять тысяч шестьсот. ");
INSERT INTO russyn_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Вот сыны Дановы по поколениям их: от Шухама поколение Шухамово; вот семейства Дановы по поколениям их. ");
INSERT INTO russyn_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","И всех поколений Шухама, по исчислению их: шестьдесят четыре тысячи четыреста. ");
INSERT INTO russyn_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Сыны Асировы по поколениям их: от Имны поколение Имнино, от Ишвы поколение Ишвино, от Верии поколение Вериино; ");
INSERT INTO russyn_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","от сынов Верии, от Хевера поколение Хеверово, от Малхиила поколение Малхиилово; ");
INSERT INTO russyn_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","имя дочери Асировой Сара; ");
INSERT INTO russyn_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","вот поколения сынов Асировых, по исчислению их: пятьдесят три тысячи четыреста. ");
INSERT INTO russyn_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Сыны Неффалима по поколениям их: от Иахцеила поколение Иахцеилово, от Гуния поколение Гуниево, ");
INSERT INTO russyn_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","от Иецера поколение Иецерово, от Шиллема поколение Шиллемово; ");
INSERT INTO russyn_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","вот поколения Неффалимовы по поколениям их; исчислено же их сорок пять тысяч четыреста. ");
INSERT INTO russyn_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Вот число вошедших в исчисление сынов Израилевых: шестьсот одна тысяча семьсот тридцать. ");
INSERT INTO russyn_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","сим в удел должно разделить землю по числу имен; ");
INSERT INTO russyn_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","кто многочисленнее, тем дай удел более; а кто малочисленнее, тем дай удел менее: каждому должно дать удел соразмерно с числом вошедших в исчисление; ");
INSERT INTO russyn_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","по жребию должно разделить землю, по именам колен отцов их должны они получить уделы; ");
INSERT INTO russyn_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","по жребию должно разделить им уделы их, как многочисленным, так и малочисленным. ");
INSERT INTO russyn_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Сии суть вошедшие в исчисление левиты по поколениям их: от Гирсона поколение Гирсоново, от Каафа поколение Каафово, от Мерари поколение Мерарино. ");
INSERT INTO russyn_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Вот поколения Левиины: поколение Ливниево, поколение Хевроново, поколение Махлиево, поколение Мушиево, поколение Кореево. От Каафа родился Амрам. ");
INSERT INTO russyn_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Имя жены Амрамовой Иохаведа, дочь Левиина, которую родила жена Левиина в Египте, а она Амраму родила Аарона, Моисея и Мариам, сестру их. ");
INSERT INTO russyn_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","И родились у Аарона Надав и Авиуд, Елеазар и Ифамар; ");
INSERT INTO russyn_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","но Надав и Авиуд умерли, когда принесли чуждый огонь пред Господа в пустыне Синайской. ");
INSERT INTO russyn_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","И было исчислено двадцать три тысячи всех мужеского пола, от одного месяца и выше; ибо они не были исчислены вместе с сынами Израилевыми, потому что не дано им удела среди сынов Израилевых. ");
INSERT INTO russyn_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Вот исчисленные Моисеем и Елеазаром священником, которые исчисляли сынов Израилевых на равнинах Моавитских у Иордана, против Иерихона; ");
INSERT INTO russyn_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","в числе их не было ни одного человека из исчисленных Моисеем и Аароном священником, которые исчисляли сынов Израилевых в пустыне Синайской; ");
INSERT INTO russyn_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","ибо Господь сказал им, что умрут они в пустыне,- и не осталось из них никого, кроме Халева, сына Иефонниина, и Иисуса, сына Навина. ");
INSERT INTO russyn_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","И пришли дочери Салпаада, сына Хеферова, сына Галаадова, сына Махирова, сына Манассиина из поколения Манассии, сына Иосифова, и вот имена дочерей его: Махла, Ноа, Хогла, Милка и Фирца; ");
INSERT INTO russyn_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","и предстали пред Моисея и пред Елеазара священника, и пред князей и пред все общество, у входа скинии собрания, и сказали: ");
INSERT INTO russyn_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","отец наш умер в пустыне, и он не был в числе сообщников, собравшихся против Господа со скопищем Кореевым, но за свой грех умер, и сыновей у него не было; ");
INSERT INTO russyn_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","за что исчезать имени отца нашего из племени его, потому что нет у него сына? дай нам удел среди братьев отца нашего. ");
INSERT INTO russyn_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","И представил Моисей дело их Господу. ");
INSERT INTO russyn_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","И сказал Господь Моисею: ");
INSERT INTO russyn_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","правду говорят дочери Салпаадовы; дай им наследственный удел среди братьев отца их и передай им удел отца их; ");
INSERT INTO russyn_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","и сынам Израилевым объяви и скажи: если кто умрет, не имея у себя сына, то передавайте удел его дочери его; ");
INSERT INTO russyn_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","если же нет у него дочери, передавайте удел его братьям его; ");
INSERT INTO russyn_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","если же нет у него братьев, отдайте удел его братьям отца его; ");
INSERT INTO russyn_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","если же нет братьев отца его, отдайте удел его близкому его родственнику из поколения его, чтоб он наследовал его; и да будет это для сынов Израилевых постановлено в закон, как повелел Господь Моисею. ");
INSERT INTO russyn_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","И сказал Господь Моисею: взойди на сию гору Аварим, которая по эту сторону Иордана, на сию гору Нево, и посмотри на землю Ханаанскую, которую Я даю сынам Израилевым во владение; ");
INSERT INTO russyn_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","и когда посмотришь на нее, приложись к народу своему и ты, как приложился Аарон, брат твой, на горе Ор; ");
INSERT INTO russyn_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","потому что вы не послушались повеления Моего в пустыне Син, во время распри общества, чтоб явить пред глазами их святость Мою при водах. Это воды Меривы при Кадесе в пустыне Син. ");
INSERT INTO russyn_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","И сказал Моисей Господу, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","да поставит Господь, Бог духов всякой плоти, над обществом сим человека, ");
INSERT INTO russyn_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","который выходил бы пред ними и который входил бы пред ними, который выводил бы их и который приводил бы их, чтобы не осталось общество Господне, как овцы, у которых нет пастыря. ");
INSERT INTO russyn_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","И сказал Господь Моисею: возьми себе Иисуса, сына Навина, человека, в котором есть Дух, и возложи на него руку твою, ");
INSERT INTO russyn_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","и поставь его пред Елеазаром священником и пред всем обществом, и дай ему наставление пред глазами их, ");
INSERT INTO russyn_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","и дай ему от славы твоей, чтобы слушало его все общество сынов Израилевых; ");
INSERT INTO russyn_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","и будет он обращаться к Елеазару священнику и спрашивать его о решении, посредством урима пред Господом; и по его слову должны выходить, и по его слову должны входить он и все сыны Израилевы с ним и все общество. ");
INSERT INTO russyn_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","И сделал Моисей, как повелел ему Господь Бог, и взял Иисуса, и поставил его пред Елеазаром священником и пред всем обществом; ");
INSERT INTO russyn_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","и возложил на него руки свои и дал ему наставление, как говорил Господь чрез Моисея. ");
INSERT INTO russyn_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","повели сынам Израилевым и скажи им: наблюдайте, чтобы приношение Мое, хлеб Мой в жертву Мне, в приятное благоухание Мне, приносимо было Мне в свое время. ");
INSERT INTO russyn_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","И скажи им: вот жертва, которую вы должны приносить Господу: два агнца однолетних без порока на день, во всесожжение постоянное; ");
INSERT INTO russyn_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","одного агнца приноси утром, а другого агнца приноси вечером; ");
INSERT INTO russyn_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","и в приношение хлебное приноси десятую часть ефы пшеничной муки, смешанной с четвертью гина выбитого елея; ");
INSERT INTO russyn_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","это - всесожжение постоянное, какое совершено было при горе Синае, в приятное благоухание, в жертву Господу; ");
INSERT INTO russyn_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","и возлияния при ней четверть гина на одного агнца: на святом месте возливай возлияние, вино Господу. ");
INSERT INTO russyn_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Другого агнца приноси вечером, с таким хлебным приношением, как поутру, и с таким же возлиянием при нем приноси его в жертву, в приятное благоухание Господу. ");
INSERT INTO russyn_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","А в субботу приносите двух агнцев однолетних без порока, и в приношение хлебное две десятых части ефы пшеничной муки, смешанной с елеем, и возлияние при нем: ");
INSERT INTO russyn_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","это - субботнее всесожжение в каждую субботу, сверх постоянного всесожжения и возлияния при нем. ");
INSERT INTO russyn_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","И в новомесячия ваши приносите всесожжение Господу: из крупного скота двух тельцов, одного овна и семь однолетних агнцев без порока, ");
INSERT INTO russyn_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","и три десятых части ефы пшеничной муки, смешанной с елеем, в приношение хлебное на одного тельца, и две десятых части ефы пшеничной муки, смешанной с елеем, в приношение хлебное на овна, ");
INSERT INTO russyn_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","и по десятой части ефы пшеничной муки, смешанной с елеем, в приношение хлебное на каждого агнца; это - всесожжение, приятное благоухание, жертва Господу; ");
INSERT INTO russyn_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","и возлияния при них должно быть полгина вина на тельца, треть гина на овна и четверть гина на агнца; это всесожжение в каждое новомесячие во все месяцы года. ");
INSERT INTO russyn_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","И одного козла приносите Господу в жертву за грех; сверх всесожжения постоянного должно приносить его с возлиянием его. ");
INSERT INTO russyn_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","В первый месяц, в четырнадцатый день месяца Пасха Господня. ");
INSERT INTO russyn_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","И в пятнадцатый день сего месяца праздник; семь дней должно есть опресноки. ");
INSERT INTO russyn_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","В первый день да будет у вас священное собрание; никакой работы не работайте; ");
INSERT INTO russyn_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","и приносите жертву, всесожжение Господу: из крупного скота двух тельцов, одного овна и семь однолетних агнцев; без порока они должны быть у вас; ");
INSERT INTO russyn_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","и при них в приношение хлебное приносите пшеничной муки, смешанной с елеем, три десятых части ефы на каждого тельца, и две десятых части ефы на овна, ");
INSERT INTO russyn_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","и по десятой части ефы приноси на каждого из семи агнцев, ");
INSERT INTO russyn_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","и одного козла в жертву за грех, для очищения вас; ");
INSERT INTO russyn_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","сверх утреннего всесожжения, которое есть всесожжение постоянное, приносите сие. ");
INSERT INTO russyn_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Так приносите и в каждый из семи дней; это хлеб, жертва, приятное благоухание Господу; сверх всесожжения постоянного и возлияния его, должно приносить сие. ");
INSERT INTO russyn_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","И в седьмой день да будет у вас священное собрание; никакой работы не работайте. ");
INSERT INTO russyn_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","И в день первых плодов, когда приносите Господу новое приношение хлебное в седмицы ваши, да будет у вас священное собрание; никакой работы не работайте; ");
INSERT INTO russyn_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","и приносите всесожжение в приятное благоухание Господу: из крупного скота двух тельцов, одного овна и семь однолетних агнцев без порока, ");
INSERT INTO russyn_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","и при них в приношение хлебное пшеничной муки, смешанной с елеем, три десятых части ефы на каждого тельца, две десятых части ефы на овна, ");
INSERT INTO russyn_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","и по десятой части ефы на каждого из семи агнцев, ");
INSERT INTO russyn_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","и одного козла в жертву за грех, для очищения вас; ");
INSERT INTO russyn_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","сверх постоянного всесожжения и хлебного приношения при нем, приносите сие Мне с возлиянием их; без порока должны быть они у вас. ");
INSERT INTO russyn_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","И в седьмой месяц, в первый день месяца, да будет у вас священное собрание; никакой работы не работайте; пусть будет это у вас день трубного звука; ");
INSERT INTO russyn_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","и приносите всесожжение в приятное благоухание Господу: одного тельца, одного овна, семь однолетних агнцев, без порока, ");
INSERT INTO russyn_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","и при них в приношение хлебное пшеничной муки, смешанной с елеем, три десятых части ефы на тельца, две десятых части ефы на овна, ");
INSERT INTO russyn_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","и одну десятую часть ефы на каждого из семи агнцев, ");
INSERT INTO russyn_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","и одного козла в жертву за грех, для очищения вас, ");
INSERT INTO russyn_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","сверх новомесячного всесожжения и хлебного приношения его, и сверх постоянного всесожжения и хлебного приношения его, и возлияний их, по уставу, в приятное благоухание Господу. ");
INSERT INTO russyn_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","И в десятый день сего седьмого месяца пусть будет у вас священное собрание: смиряйте тогда души ваши и никакого дела не делайте; ");
INSERT INTO russyn_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","и приносите всесожжение Господу в приятное благоухание: одного тельца, одного овна, семь однолетних агнцев; без порока пусть будут они у вас; ");
INSERT INTO russyn_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","и при них в приношение хлебное пшеничной муки, смешанной с елеем, три десятых части ефы на тельца, две десятых части ефы на овна, ");
INSERT INTO russyn_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","и по десятой части ефы на каждого из семи агнцев, ");
INSERT INTO russyn_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","и одного козла в жертву за грех, для очищения вас, сверх жертвы за грех, приносимой в день очищения, и сверх всесожжения постоянного и хлебного приношения его, и возлияния их, по уставу приносимых в приятное благоухание, в жертву Господу. ");
INSERT INTO russyn_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","И в пятнадцатый день седьмого месяца пусть будет у вас священное собрание; никакой работы не работайте и празднуйте праздник Господень семь дней; ");
INSERT INTO russyn_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","и приносите всесожжение, жертву, приятное благоухание Господу: тринадцать тельцов, двух овнов, четырнадцать однолетних агнцев; без порока пусть будут они; ");
INSERT INTO russyn_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","и при них в приношение хлебное пшеничной муки, смешанной с елеем, три десятых части ефы на каждого из тринадцати тельцов, две десятых части ефы на каждого из двух овнов, ");
INSERT INTO russyn_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","и по десятой части ефы на каждого из четырнадцати агнцев, ");
INSERT INTO russyn_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","и одного козла в жертву за грех, сверх всесожжения постоянного и хлебного приношения его и возлияния его. ");
INSERT INTO russyn_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","И во второй день двенадцать тельцов, двух овнов, четырнадцать однолетних агнцев, без порока, ");
INSERT INTO russyn_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","и при них приношение хлебное и возлияние для тельцов, овнов и агнцев, по числу их, по уставу, ");
INSERT INTO russyn_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","и одного козла в жертву за грех, сверх всесожжения постоянного и хлебного приношения и возлияния их. ");
INSERT INTO russyn_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","И в третий день одиннадцать тельцов, двух овнов, четырнадцать однолетних агнцев, без порока, ");
INSERT INTO russyn_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","и при них приношение хлебное и возлияние для тельцов, овнов и агнцев, по числу их, по уставу, ");
INSERT INTO russyn_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","и одного козла в жертву за грех, сверх всесожжения постоянного и хлебного приношения и возлияния его. ");
INSERT INTO russyn_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","И в четвертый день десять тельцов, двух овнов, четырнадцать однолетних агнцев, без порока, ");
INSERT INTO russyn_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","и при них приношение хлебное и возлияние для тельцов, овнов и агнцев, по числу их, по уставу, ");
INSERT INTO russyn_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","и одного козла в жертву за грех, сверх всесожжения постоянного и хлебного приношения и возлияния его. ");
INSERT INTO russyn_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","И в пятый день девять тельцов, двух овнов, четырнадцать однолетних агнцев, без порока, ");
INSERT INTO russyn_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","и при них приношение хлебное и возлияние для тельцов, овнов и агнцев, по числу их, по уставу, ");
INSERT INTO russyn_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","и одного козла в жертву за грех, сверх всесожжения постоянного и хлебного приношения и возлияния его. ");
INSERT INTO russyn_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","И в шестой день восемь тельцов, двух овнов, четырнадцать однолетних агнцев, без порока, ");
INSERT INTO russyn_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","и при них приношение хлебное и возлияние для тельцов, овнов и агнцев, по числу их, по уставу, ");
INSERT INTO russyn_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","и одного козла в жертву за грех, сверх всесожжения постоянного и хлебного приношения и возлияния его. ");
INSERT INTO russyn_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","И в седьмой день семь тельцов, двух овнов, четырнадцать однолетних агнцев, без порока, ");
INSERT INTO russyn_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","и при них приношение хлебное и возлияние для тельцов, овнов и агнцев, по числу их, по уставу, ");
INSERT INTO russyn_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","и одного козла в жертву за грех, сверх всесожжения постоянного и хлебного приношения и возлияния его. ");
INSERT INTO russyn_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","В восьмой день пусть будет у вас отдание праздника; никакой работы не работайте; ");
INSERT INTO russyn_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","и приносите всесожжение, жертву, приятное благоухание Господу: одного тельца, одного овна, семь однолетних агнцев, без порока, ");
INSERT INTO russyn_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","и при них приношение хлебное и возлияние для тельца, овна и агнцев по числу их, по уставу, ");
INSERT INTO russyn_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","и одного козла в жертву за грех, сверх всесожжения постоянного и приношения хлебного и возлияния его. ");
INSERT INTO russyn_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Приносите это Господу в праздники ваши, сверх приносимых вами, по обету или по усердию, всесожжений ваших и хлебных приношений ваших, и возлияний ваших и мирных жертв ваших. ");
INSERT INTO russyn_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","И пересказал Моисей сынам Израилевым все, что повелел Господь Моисею. ");
INSERT INTO russyn_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","И сказал Моисей начальникам колен сынов Израилевых, говоря: вот что повелел Господь: ");
INSERT INTO russyn_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","если кто даст обет Господу, или поклянется клятвою, положив зарок на душу свою, то он не должен нарушать слова своего, но должен исполнить все, что вышло из уст его. ");
INSERT INTO russyn_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","Если женщина даст обет Господу и положит на себя зарок в доме отца своего, в юности своей, ");
INSERT INTO russyn_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","и услышит отец обет ее и зарок, который она положила на душу свою, и промолчит о том отец ее, то все обеты ее состоятся, и всякий зарок ее, который она положила на душу свою, состоится; ");
INSERT INTO russyn_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","если же отец ее, услышав, запретит ей, то все обеты ее и зароки, которые она возложила на душу свою, не состоятся, и Господь простит ей, потому что запретил ей отец ее. ");
INSERT INTO russyn_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","Если она выйдет в замужество, а на ней обет ее, или слово уст ее, которым она связала себя, ");
INSERT INTO russyn_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","и услышит муж ее и, услышав, промолчит: то обеты ее состоятся, и зароки ее, которые она возложила на душу свою, состоятся; ");
INSERT INTO russyn_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","если же муж ее, услышав, запретит ей и отвергнет обет ее, который на ней, и слово уст ее, которым она связала себя, то они не состоятся, потому что запретил ей муж ее, и Господь простит ей. ");
INSERT INTO russyn_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","Обет же вдовы и разведенной, какой бы она ни возложила зарок на душу свою, состоится. ");
INSERT INTO russyn_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","Если жена в доме мужа своего дала обет, или возложила зарок на душу свою с клятвою, ");
INSERT INTO russyn_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","и муж ее слышал, и промолчал о том, и не запретил ей, то все обеты ее состоятся, и всякий зарок, который она возложила на душу свою, состоится; ");
INSERT INTO russyn_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","если же муж ее, услышав, отвергнул их, то все вышедшие из уст ее обеты ее и зароки души ее не состоятся: муж ее уничтожил их, и Господь простит ей. ");
INSERT INTO russyn_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Всякий обет и всякий клятвенный зарок, чтобы смирить душу, муж ее может утвердить, и муж ее может отвергнуть; ");
INSERT INTO russyn_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","если же муж ее молчал о том день за день, то он тем утвердил все обеты ее и все зароки ее, которые на ней, утвердил, потому что он, услышав, молчал о том; ");
INSERT INTO russyn_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","а если муж отвергнул их, после того как услышал, то он взял на себя грех ее. ");
INSERT INTO russyn_vpl VALUES ("NU30_17","005_30_17","NUM","30","17","17","Вот уставы, которые Господь заповедал Моисею об отношении между мужем и женою его, между отцом и дочерью его в юности ее, в доме отца ее. ");
INSERT INTO russyn_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","отмсти Мадианитянам за сынов Израилевых, и после отойдешь к народу твоему. ");
INSERT INTO russyn_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","И сказал Моисей народу, говоря: вооружите из себя людей на войну, чтобы они пошли против Мадианитян, совершить мщение Господне над Мадианитянами; ");
INSERT INTO russyn_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","по тысяче из колена, от всех колен сынов Израилевых пошлите на войну. ");
INSERT INTO russyn_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","И выделено из тысяч Израилевых, по тысяче из колена, двенадцать тысяч вооруженных на войну. ");
INSERT INTO russyn_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","И послал их Моисей на войну, по тысяче из колена, их и Финееса, сына Елеазара, сына Аарона, священника, на войну, и в руке его священные сосуды и трубы для тревоги. ");
INSERT INTO russyn_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","И пошли войною на Мадиама, как повелел Господь Моисею, и убили всех мужеского пола; ");
INSERT INTO russyn_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","и вместе с убитыми их убили царей Мадиамских: Евия, Рекема, Цура, Хура и Реву, пять царей Мадиамских, и Валаама, сына Веорова, убили мечом вместе с убитыми их; ");
INSERT INTO russyn_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","а жен Мадиамских и детей их сыны Израилевы взяли в плен, и весь скот их, и все стада их и все имение их взяли в добычу, ");
INSERT INTO russyn_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","и все города их во владениях их и все селения их сожгли огнем; ");
INSERT INTO russyn_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","и взяли все захваченное и всю добычу, от человека до скота; ");
INSERT INTO russyn_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","и доставили пленных и добычу и захваченное к Моисею и к Елеазару священнику и к обществу сынов Израилевых, к стану, на равнины Моавитские, что у Иордана, против Иерихона. ");
INSERT INTO russyn_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","И вышли Моисей и Елеазар священник и все князья общества навстречу им из стана. ");
INSERT INTO russyn_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","И прогневался Моисей на военачальников, тысяченачальников и стоначальников, пришедших с войны, ");
INSERT INTO russyn_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","и сказал им Моисей: для чего вы оставили в живых всех женщин? ");
INSERT INTO russyn_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","вот они, по совету Валаамову, были для сынов Израилевых поводом к отступлению от Господа в угождение Фегору, за что и поражение было в обществе Господнем; ");
INSERT INTO russyn_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","итак убейте всех детей мужеского пола, и всех женщин, познавших мужа на мужеском ложе, убейте; ");
INSERT INTO russyn_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","а всех детей женского пола, которые не познали мужеского ложа, оставьте в живых для себя; ");
INSERT INTO russyn_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","и пробудьте вне стана семь дней; всякий, убивший человека и прикоснувшийся к убитому, очиститесь в третий день и в седьмой день, вы и пленные ваши; ");
INSERT INTO russyn_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","и все одежды, и все кожаные вещи, и все сделанное из козьей шерсти, и все деревянные сосуды очистите. ");
INSERT INTO russyn_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","И сказал Елеазар священник воинам, ходившим на войну: вот постановление закона, который заповедал Господь Моисею: ");
INSERT INTO russyn_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","золото, серебро, медь, железо, олово и свинец, ");
INSERT INTO russyn_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","и все, что проходит через огонь, проведите через огонь, чтоб оно очистилось, а кроме того и очистительною водою должно очистить; все же, что не проходит через огонь, проведите через воду; ");
INSERT INTO russyn_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","и одежды ваши вымойте в седьмой день, и очиститесь, и после того входите в стан. ");
INSERT INTO russyn_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","сочти добычу плена, от человека до скота, ты и Елеазар священник и начальники племен общества; ");
INSERT INTO russyn_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","и раздели добычу пополам между воевавшими, ходившими на войну, и между всем обществом; ");
INSERT INTO russyn_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","и от воинов, ходивших на войну, возьми дань Господу, по одной душе из пятисот, из людей и из крупного скота, и из ослов и из мелкого скота; ");
INSERT INTO russyn_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","возьми это из половины их и отдай Елеазару священнику в возношение Господу; ");
INSERT INTO russyn_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","и из половины сынов Израилевых возьми по одной доле из пятидесяти, из людей, из крупного скота, из ослов и из мелкого скота, и отдай это левитам, служащим при скинии Господней. ");
INSERT INTO russyn_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","И сделал Моисей и Елеазар священник, как повелел Господь Моисею. ");
INSERT INTO russyn_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","И было добычи, оставшейся от захваченного, что захватили бывшие на войне: мелкого скота шестьсот семьдесят пять тысяч, ");
INSERT INTO russyn_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","крупного скота семьдесят две тысячи, ");
INSERT INTO russyn_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","ослов шестьдесят одна тысяча, ");
INSERT INTO russyn_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","людей, женщин, которые не знали мужеского ложа, всех душ тридцать две тысячи. ");
INSERT INTO russyn_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Половина, доля ходивших на войну, по расчислению была: мелкого скота триста тридцать семь тысяч пятьсот, ");
INSERT INTO russyn_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","и дань Господу из мелкого скота шестьсот семьдесят пять; ");
INSERT INTO russyn_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","крупного скота тридцать шесть тысяч, и дань из них Господу семьдесят два; ");
INSERT INTO russyn_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","ослов тридцать тысяч пятьсот, и дань из них Господу шестьдесят один; ");
INSERT INTO russyn_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","людей шестнадцать тысяч, и дань из них Господу тридцать две души. ");
INSERT INTO russyn_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","И отдал Моисей дань, возношение Господу, Елеазару священнику, как повелел Господь Моисею. ");
INSERT INTO russyn_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","И из половины сынов Израилевых, которую отделил Моисей у бывших на войне; ");
INSERT INTO russyn_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","половина же на долю общества была: мелкого скота триста тридцать семь тысяч пятьсот, ");
INSERT INTO russyn_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","крупного скота тридцать шесть тысяч, ");
INSERT INTO russyn_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","ослов тридцать тысяч пятьсот, ");
INSERT INTO russyn_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","людей шестнадцать тысяч. ");
INSERT INTO russyn_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Из половины сынов Израилевых взял Моисей одну пятидесятую часть из людей и из скота и отдал это левитам, исполняющим службу при скинии Господней, как повелел Господь Моисею. ");
INSERT INTO russyn_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","И пришли к Моисею начальники над тысячами войска, тысяченачальники и стоначальники, ");
INSERT INTO russyn_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","и сказали Моисею: рабы твои сосчитали воинов, которые нам поручены, и не убыло ни одного из них; ");
INSERT INTO russyn_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","и вот, мы принесли приношение Господу, кто что достал из золотых вещей: цепочки, запястья, перстни, серьги и привески, для очищения душ наших пред Господом. ");
INSERT INTO russyn_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","И взял у них Моисей и Елеазар священник золото во всех этих изделиях; ");
INSERT INTO russyn_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","и было всего золота, которое принесено в возношение Господу, шестнадцать тысяч семьсот пятьдесят сиклей, от тысяченачальников и стоначальников. ");
INSERT INTO russyn_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Воины грабили каждый для себя. ");
INSERT INTO russyn_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","И взял Моисей и Елеазар священник золото от тысяченачальников и стоначальников, и принесли его в скинию собрания, в память сынов Израилевых пред Господом. ");
INSERT INTO russyn_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","У сынов Рувимовых и у сынов Гадовых стад было весьма много; и увидели они, что земля Иазер и земля Галаад есть место годное для стад; ");
INSERT INTO russyn_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","и пришли сыны Гадовы и сыны Рувимовы и сказали Моисею и Елеазару священнику и князьям общества, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","Атароф и Дивон, и Иазер, и Нимра, и Есевон, и Елеале, и Севам, и Нево, и Веон, ");
INSERT INTO russyn_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","земля, которую Господь поразил пред обществом Израилевым, есть земля годная для стад, а у рабов твоих есть стада. ");
INSERT INTO russyn_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","И сказали: если мы нашли благоволение в глазах твоих, отдай землю сию рабам твоим во владение; не переводи нас чрез Иордан. ");
INSERT INTO russyn_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","И сказал Моисей сынам Гадовым и сынам Рувимовым: братья ваши пойдут на войну, а вы останетесь здесь? ");
INSERT INTO russyn_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","для чего вы отвращаете сердце сынов Израилевых от перехода в землю, которую дает им Господь? ");
INSERT INTO russyn_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","так поступили отцы ваши, когда я посылал их из Кадес-Варни для обозрения земли: ");
INSERT INTO russyn_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","они доходили до долины Есхол, и видели землю, и отвратили сердце сынов Израилевых, чтобы не шли они в землю, которую Господь дает им; ");
INSERT INTO russyn_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","и воспылал в тот день гнев Господа, и поклялся Он, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","люди сии, вышедшие из Египта, от двадцати лет и выше знающие добро и зло, не увидят земли, о которой Я клялся Аврааму, Исааку и Иакову, потому что они не повиновались Мне, ");
INSERT INTO russyn_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","кроме Халева, сына Иефонниина, Кенезеянина, и Иисуса, сына Навина, потому что они повиновались Господу. ");
INSERT INTO russyn_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","И воспылал гнев Господа на Израиля, и водил Он их по пустыне сорок лет, доколе не кончился весь род, сделавший зло в очах Господних. ");
INSERT INTO russyn_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","И вот, вместо отцов ваших восстали вы, отродье грешников, чтоб усилить еще ярость гнева Господня на Израиля. ");
INSERT INTO russyn_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Если вы отвратитесь от Него, то Он опять оставит его в пустыне, и вы погубите весь народ сей. ");
INSERT INTO russyn_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","И подошли они к нему и сказали: мы построим здесь овчие дворы для стад наших и города для детей наших; ");
INSERT INTO russyn_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","сами же мы первые вооружимся и пойдем пред сынами Израилевыми, доколе не приведем их в места их; а дети наши пусть останутся в укрепленных городах, для безопасности от жителей земли; ");
INSERT INTO russyn_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","не возвратимся в домы наши, доколе не вступят сыны Израилевы каждый в удел свой; ");
INSERT INTO russyn_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","ибо мы не возьмем с ними удела по ту сторону Иордана и далее, если удел нам достанется по эту сторону Иордана, к востоку. ");
INSERT INTO russyn_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","И сказал им Моисей: если вы это сделаете, если вооруженные пойдете на войну пред Господом, ");
INSERT INTO russyn_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","и пойдет каждый из вас вооруженный за Иордан пред Господом, доколе не истребит Он врагов Своих пред Собою, ");
INSERT INTO russyn_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","и покорена будет земля пред Господом, то после возвратитесь и будете неповинны пред Господом и пред Израилем, и будет земля сия у вас во владении пред Господом; ");
INSERT INTO russyn_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","если же не сделаете так, то согрешите пред Господом, и испытаете наказание за грех ваш, которое постигнет вас; ");
INSERT INTO russyn_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","стройте себе города для детей ваших и дворы для овец ваших и делайте, что произнесено устами вашими. ");
INSERT INTO russyn_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","И сказали сыны Гадовы и сыны Рувимовы Моисею: рабы твои сделают, как повелевает господин наш; ");
INSERT INTO russyn_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","дети наши, жены наши, стада наши и весь скот наш останутся тут в городах Галаада, ");
INSERT INTO russyn_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","а рабы твои, все, вооружившись, как воины, пойдут пред Господом на войну, как говорит господин наш. ");
INSERT INTO russyn_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","И дал Моисей о них повеление Елеазару священнику и Иисусу, сыну Навину, и начальникам племен сынов Израилевых, ");
INSERT INTO russyn_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","и сказал им Моисей: если сыны Гадовы и сыны Рувимовы перейдут с вами за Иордан, все вооружившись на войну пред Господом, и покорена будет пред вами земля, то отдайте им землю Галаад во владение; ");
INSERT INTO russyn_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","если же не пойдут они с вами вооруженные на войну пред Господом, то пошлите пред собою имение их, жен их и скот их в землю Ханаанскую, и они получат владение вместе с вами в земле Ханаанской. ");
INSERT INTO russyn_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","И отвечали сыны Гадовы и сыны Рувимовы и сказали: как сказал Господь рабам твоим, так и сделаем; ");
INSERT INTO russyn_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","мы пойдем вооруженные пред Господом в землю Ханаанскую, а удел владения нашего пусть будет по эту сторону Иордана. ");
INSERT INTO russyn_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","И отдал Моисей им, сынам Гадовым и сынам Рувимовым, и половине колена Манассии, сына Иосифова, царство Сигона, царя Аморрейского, и царство Ога, царя Васанского, землю с городами ее и окрестностями,- города земли во все стороны. ");
INSERT INTO russyn_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","И построили сыны Гадовы Дивон и Атароф, и Ароер, ");
INSERT INTO russyn_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","и Атароф-Шофан, и Иазер, и Иогбегу, ");
INSERT INTO russyn_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","и Беф-Нимру и Беф-Гаран, города укрепленные и дворы для овец. ");
INSERT INTO russyn_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","И сыны Рувимовы построили Есевон, Елеале, Кириафаим, ");
INSERT INTO russyn_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","и Нево, и Ваал-Меон, которых имена переменены, и Сивму, и дали имена городам, которые они построили. ");
INSERT INTO russyn_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","И пошли сыны Махира, сына Манассиина, в Галаад, и взяли его, и выгнали Аморреев, которые были в нем; ");
INSERT INTO russyn_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","и отдал Моисей Галаад Махиру, сыну Манассии, и он поселился в нем. ");
INSERT INTO russyn_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","И Иаир, сын Манассии, пошел и взял селения их, и назвал их: селения Иаировы. ");
INSERT INTO russyn_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","И Новах пошел и взял Кенаф и зависящие от него города, и назвал его своим именем: Новах. ");
INSERT INTO russyn_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Вот станы сынов Израилевых, которые вышли из земли Египетской по ополчениям своим, под начальством Моисея и Аарона. ");
INSERT INTO russyn_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Моисей, по повелению Господню, описал путешествие их по станам их, и вот станы путешествия их: ");
INSERT INTO russyn_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","из Раамсеса отправились они в первый месяц, в пятнадцатый день первого месяца; на другой день Пасхи вышли сыны Израилевы под рукою высокою в глазах всего Египта; ");
INSERT INTO russyn_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","между тем Египтяне хоронили всех первенцев, которых поразил у них Господь, и над богами их Господь совершил суд. ");
INSERT INTO russyn_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Так отправились сыны Израилевы из Раамсеса и расположились станом в Сокхофе. ");
INSERT INTO russyn_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","И отправились из Сокхофа и расположились станом в Ефаме, что на краю пустыни. ");
INSERT INTO russyn_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","И отправились из Ефама и обратились к Пи-Гахирофу, что пред Ваал-Цефоном, и расположились станом пред Мигдолом. ");
INSERT INTO russyn_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Отправившись от Гахирофа, прошли среди моря в пустыню, и шли три дня пути пустынею Ефам, и расположились станом в Мерре. ");
INSERT INTO russyn_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","И отправились из Мерры и пришли в Елим; в Елиме же было двенадцать источников воды и семьдесят финиковых дерев, и расположились там станом. ");
INSERT INTO russyn_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","И отправились из Елима и расположились станом у Чермного моря. ");
INSERT INTO russyn_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","И отправились от Чермного моря и расположились станом в пустыне Син. ");
INSERT INTO russyn_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","И отправились из пустыни Син и расположились станом в Дофке. ");
INSERT INTO russyn_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","И отправились из Дофки и расположились станом в Алуше. ");
INSERT INTO russyn_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","И отправились из Алуша и расположились станом в Рефидиме, и не было там воды, чтобы пить народу. ");
INSERT INTO russyn_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","И отправились из Рефидима и расположились станом в пустыне Синайской. ");
INSERT INTO russyn_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","И отправились из пустыни Синайской и расположились станом в Киброт-Гаттааве. ");
INSERT INTO russyn_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","И отправились из Киброт-Гаттаавы и расположились станом в Асирофе. ");
INSERT INTO russyn_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","И отправились из Асирофа и расположились станом в Рифме. ");
INSERT INTO russyn_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","И отправились из Рифмы и расположились станом в Римнон-Фареце. ");
INSERT INTO russyn_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","И отправились из Римнон-Фареца и расположились станом в Ливне. ");
INSERT INTO russyn_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","И отправились из Ливны и расположились станом в Риссе. ");
INSERT INTO russyn_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","И отправились из Риссы и расположились станом в Кегелафе. ");
INSERT INTO russyn_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","И отправились из Кегелафы и расположились станом на горе Шафер. ");
INSERT INTO russyn_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","И отправились от горы Шафер и расположились станом в Хараде. ");
INSERT INTO russyn_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","И отправились из Харады и расположились станом в Макелофе. ");
INSERT INTO russyn_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","И отправились из Макелофа и расположились станом в Тахафе. ");
INSERT INTO russyn_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","И отправились из Тахафа и расположились станом в Тарахе. ");
INSERT INTO russyn_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","И отправились из Тараха и расположились станом в Мифке. ");
INSERT INTO russyn_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","И отправились из Мифки и расположились станом в Хашмон. ");
INSERT INTO russyn_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","И отправились из Хашмоны и расположились станом в Мосерофе. ");
INSERT INTO russyn_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","И отправились из Мосерофа и расположились станом в Бене-Яакане. ");
INSERT INTO russyn_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","И отправились из Бене-Яакана и расположились станом в Хор-Агидгаде. ");
INSERT INTO russyn_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","И отправились из Хор-Агидгада и расположились станом в Иотвафе. ");
INSERT INTO russyn_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","И отправились от Иотвафы и расположились станом в Авроне. ");
INSERT INTO russyn_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","И отправились из Аврона и расположились станом в Ецион-Гавере. ");
INSERT INTO russyn_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","И отправились из Ецион-Гавера и расположились станом в пустыне Син. Отправившись из пустыни Син, расположились станом в пустыне Фаран, она же Кадес. ");
INSERT INTO russyn_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","И отправились из Кадеса и расположились станом на горе Ор, у пределов земли Едомской. ");
INSERT INTO russyn_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","И взошел Аарон священник на гору Ор по повелению Господню и умер там в сороковой год по исшествии сынов Израилевых из земли Египетской, в пятый месяц, в первый день месяца; ");
INSERT INTO russyn_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Аарон был ста двадцати трех лет, когда умер на горе Ор. ");
INSERT INTO russyn_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Ханаанский царь Арада, который жил к югу земли Ханаанской, услышал тогда, что идут сыны Израилевы. ");
INSERT INTO russyn_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","И отправились они от горы Ор и расположились станом в Салмоне. ");
INSERT INTO russyn_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","И отправились из Салмона и расположились станом в Пуноне. ");
INSERT INTO russyn_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","И отправились из Пунона и расположились станом в Овофе. ");
INSERT INTO russyn_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","И отправились из Овофа и расположились станом в Ийм-Авариме, на пределах Моава. ");
INSERT INTO russyn_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","И отправились из Ийма и расположились станом в Дивон-Гаде. ");
INSERT INTO russyn_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","И отправились из Дивон-Гада и расположились станом в Алмон-Дивлафаиме. ");
INSERT INTO russyn_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","И отправились из Алмон-Дивлафаима и расположились станом на горах Аваримских пред Нево. ");
INSERT INTO russyn_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","И отправились от гор Аваримских и расположились станом на равнинах Моавитских у Иордана, против Иерихона; ");
INSERT INTO russyn_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","они расположились станом у Иордана от Беф-Иешимофа до Аве-Ситтима на равнинах Моавитских. ");
INSERT INTO russyn_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","И сказал Господь Моисею на равнинах Моавитских у Иордана, против Иерихона, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","объяви сынам Израилевым и скажи им: когда перейдете через Иордан в землю Ханаанскую, ");
INSERT INTO russyn_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","то прогоните от себя всех жителей земли и истребите все изображения их, и всех литых идолов их истребите и все высоты их разорите; ");
INSERT INTO russyn_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","и возьмите во владение землю и поселитесь на ней, ибо Я вам даю землю сию во владение; ");
INSERT INTO russyn_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","и разделите землю по жребию на уделы племенам вашим: многочисленному дайте удел более, а малочисленному дай удел менее; кому где выйдет жребий, там ему и будет удел; по коленам отцов ваших возьмите себе уделы; ");
INSERT INTO russyn_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","если же вы не прогоните от себя жителей земли, то оставшиеся из них будут тернами для глаз ваших и иглами для боков ваших и будут теснить вас на земле, в которой вы будете жить, ");
INSERT INTO russyn_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","и тогда, что Я вознамерился сделать им, сделаю вам. ");
INSERT INTO russyn_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","дай повеление сынам Израилевым и скажи им: когда войдете в землю Ханаанскую, то вот земля, которая достанется вам в удел, земля Ханаанская с ее границами: ");
INSERT INTO russyn_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","южная сторона будет у вас от пустыни Син, подле Едома, и пойдет у вас южная граница от конца Соленого моря с востока, ");
INSERT INTO russyn_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","и направится граница на юг к возвышенности Акравима и пойдет через Син, и будут выступы ее на юг к Кадес-Варни, оттуда пойдет к Гацар-Аддару и пройдет через Ацмон; ");
INSERT INTO russyn_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","от Ацмона направится граница к потоку Египетскому, и будут выступы ее к морю; ");
INSERT INTO russyn_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","а границею западною будет у вас великое море: это будет у вас граница к западу; ");
INSERT INTO russyn_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","к северу же будет у вас граница: от великого моря проведите ее к горе Ор, ");
INSERT INTO russyn_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","от горы Ор проведите к Емафу, и будут выступы границы к Цедаду; ");
INSERT INTO russyn_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","оттуда пойдет граница к Цифрону, и выступы ее будут к Гацар-Енану: это будет у вас граница северная; ");
INSERT INTO russyn_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","границу восточную проведите себе от Гацар-Енана к Шефаму, ");
INSERT INTO russyn_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","от Шефама пойдет граница к Рибле, с восточной стороны Аина, потом пойдет граница и коснется берегов моря Киннереф с восточной стороны; ");
INSERT INTO russyn_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","и пойдет граница к Иордану, и будут выступы ее к Соленому морю. Это будет земля ваша по границам ее со всех сторон. ");
INSERT INTO russyn_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","И дал повеление Моисей сынам Израилевым и сказал: вот земля, которую вы разделите на уделы по жребию, которую повелел Господь дать девяти коленам и половине колена Манассиина; ");
INSERT INTO russyn_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","ибо колено сынов Рувимовых по семействам их, и колено сынов Гадовых по семействам их, и половина колена Манассиина получили удел свой: ");
INSERT INTO russyn_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","два колена и половина колена получили удел свой за Иорданом, против Иерихона, к востоку. ");
INSERT INTO russyn_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","вот имена мужей, которые будут делить вам землю: Елеазар священник и Иисус, сын Навин; ");
INSERT INTO russyn_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","и по одному князю от колена возьмите для раздела земли. ");
INSERT INTO russyn_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","И вот имена сих мужей: для колена Иудина Халев, сын Иефонниин; ");
INSERT INTO russyn_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","для колена сынов Симеоновых Самуил, сын Аммиуда; ");
INSERT INTO russyn_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","для колена Вениаминова Елидад, сын Кислона; ");
INSERT INTO russyn_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","для колена сынов Дановых князь Буккий, сын Иоглии; ");
INSERT INTO russyn_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","для сынов Иосифовых, для колена сынов Манассииных князь Ханниил, сын Ефода; ");
INSERT INTO russyn_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","для колена сынов Ефремовых князь Кемуил, сын Шифтана; ");
INSERT INTO russyn_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","для колена сынов Завулоновых князь Елицафан, сын Фарнака; ");
INSERT INTO russyn_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","для колена сынов Иссахаровых князь Фалтиил, сын Аззана; ");
INSERT INTO russyn_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","для колена сынов Асировых князь Ахиуд, сын Шеломия; ");
INSERT INTO russyn_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","для колена сынов Неффалимовых князь Педаил, сын Аммиуда; ");
INSERT INTO russyn_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","вот те, которым повелел Господь разделить уделы сынам Израилевым в земле Ханаанской. ");
INSERT INTO russyn_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","И сказал Господь Моисею на равнинах Моавитских у Иордана против Иерихона, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","повели сынам Израилевым, чтоб они из уделов владения своего дали левитам города для жительства, и поля при городах со всех сторон дайте левитам: ");
INSERT INTO russyn_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","города будут им для жительства, а поля будут для скота их и для имения их и для всех житейских потребностей их; ");
INSERT INTO russyn_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","поля при городах, которые вы должны дать левитам, от стены города должны простираться на две тысячи локтей, во все стороны; ");
INSERT INTO russyn_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","и отмерьте за городом к восточной стороне две тысячи локтей, и к южной стороне две тысячи локтей, и к западу две тысячи локтей, и к северной стороне две тысячи локтей, а посредине город: таковы будут у них поля при городах. ");
INSERT INTO russyn_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","Из городов, которые вы дадите левитам, будут шесть городов для убежища, в которые вы позволите убегать убийце; и сверх их дайте сорок два города: ");
INSERT INTO russyn_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","всех городов, которые вы должны дать левитам, будет сорок восемь городов, с полями при них. ");
INSERT INTO russyn_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","И когда будете давать города из владения сынов Израилевых, тогда из большего дайте более, из меньшего менее; каждое колено, смотря по уделу, какой получит, должно дать из городов своих левитам. ");
INSERT INTO russyn_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","И сказал Господь Моисею, говоря: ");
INSERT INTO russyn_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","объяви сынам Израилевым и скажи им: когда вы перейдете чрез Иордан в землю Ханаанскую, ");
INSERT INTO russyn_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","выберите себе города, которые были бы у вас городами для убежища, куда мог бы убежать убийца, убивший человека неумышленно; ");
INSERT INTO russyn_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","и будут у вас города сии убежищем от мстителя за кровь, чтобы не был умерщвлен убивший, прежде нежели он предстанет пред общество на суд. ");
INSERT INTO russyn_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Городов же, которые должны вы дать, городов для убежища, должно быть у вас шесть: ");
INSERT INTO russyn_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","три города дайте по эту сторону Иордана и три города дайте в земле Ханаанской; городами убежища должны быть они; ");
INSERT INTO russyn_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","для сынов Израилевых и для пришельца и для поселенца между вами будут сии шесть городов убежищем, чтобы убегать туда всякому, убившему человека неумышленно. ");
INSERT INTO russyn_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","Если кто ударит кого железным орудием так, что тот умрет, то он убийца: убийцу должно предать смерти; ");
INSERT INTO russyn_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","и если кто ударит кого из руки камнем, от которого можно умереть, так что тот умрет, то он убийца: убийцу должно предать смерти; ");
INSERT INTO russyn_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","или если деревянным орудием, от которого можно умереть, ударит из руки так, что тот умрет, то он убийца: убийцу должно предать смерти; ");
INSERT INTO russyn_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","мститель за кровь сам может умертвить убийцу: лишь только встретит его, сам может умертвить его; ");
INSERT INTO russyn_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","если кто толкнет кого по ненависти, или с умыслом бросит на него что-нибудь так, что тот умрет, ");
INSERT INTO russyn_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","или по вражде ударит его рукою так, что тот умрет, то ударившего должно предать смерти: он убийца; мститель за кровь может умертвить убийцу, лишь только встретит его. ");
INSERT INTO russyn_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","Если же он толкнет его нечаянно, без вражды, или бросит на него что-нибудь без умысла, ");
INSERT INTO russyn_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","или какой-нибудь камень, от которого можно умереть, не видя уронит на него так, что тот умрет, но он не был врагом его и не желал ему зла, ");
INSERT INTO russyn_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","то общество должно рассудить между убийцею и мстителем за кровь по сим постановлениям; ");
INSERT INTO russyn_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","и должно общество спасти убийцу от руки мстителя за кровь, и должно возвратить его общество в город убежища его, куда он убежал, чтоб он жил там до смерти великого священника, который помазан священным елеем; ");
INSERT INTO russyn_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","если же убийца выйдет за предел города убежища, в который он убежал, ");
INSERT INTO russyn_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","и найдет его мститель за кровь вне пределов города убежища его, и убьет убийцу сего мститель за кровь, то не будет на нем вины кровопролития, ");
INSERT INTO russyn_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","ибо тот должен был жить в городе убежища своего до смерти великого священника, а по смерти великого священника должен был возвратиться убийца в землю владения своего. ");
INSERT INTO russyn_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","Да будет это у вас постановлением законным в роды ваши, во всех жилищах ваших. ");
INSERT INTO russyn_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","Если кто убьет человека, то убийцу должно убить по словам свидетелей; но одного свидетеля недостаточно, чтобы осудить на смерть. ");
INSERT INTO russyn_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","И не берите выкупа за душу убийцы, который повинен смерти, но его должно предать смерти; ");
INSERT INTO russyn_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","и не берите выкупа за убежавшего в город убежища, чтоб ему позволить жить в земле своей прежде смерти великого священника. ");
INSERT INTO russyn_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","Не оскверняйте земли, на которой вы будете жить; ибо кровь оскверняет землю, и земля не иначе очищается от пролитой на ней крови, как кровью пролившего ее. ");
INSERT INTO russyn_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Не должно осквернять землю, на которой вы живете, среди которой обитаю Я; ибо Я Господь обитаю среди сынов Израилевых. ");
INSERT INTO russyn_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Пришли главы семейств от племени сынов Галаада, сына Махирова, сына Манассиина из племен сынов Иосифовых, и говорили пред Моисеем и пред Елеазаром священником и пред князьями, главами поколений сынов Израилевых, ");
INSERT INTO russyn_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","и сказали: Господь повелел господину нашему дать землю в удел сынам Израилевым по жребию, и господину нашему повелено от Господа дать удел Салпаада, брата нашего, дочерям его; ");
INSERT INTO russyn_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","если же они будут женами сынов которого-нибудь другого колена сынов Израилевых, то удел их отнимется от удела отцов наших и прибавится к уделу того колена, в котором они будут женами, и отнимется от доставшегося по жребию удела нашего; ");
INSERT INTO russyn_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","и даже когда будет у сынов Израилевых юбилей, тогда удел их прибавится к уделу того колена, в котором они будут женами, и от удела колена отцов наших отнимется удел их. ");
INSERT INTO russyn_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","И дал Моисей повеление сынам Израилевым, по слову Господню, и сказал: правду говорит колено сынов Иосифовых; ");
INSERT INTO russyn_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","вот что заповедует Господь о дочерях Салпаадовых: они могут быть женами тех, кто понравится глазам их, только должны быть женами в племени колена отца своего, ");
INSERT INTO russyn_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","чтобы удел сынов Израилевых не переходил из колена в колено; ибо каждый из сынов Израилевых должен быть привязан к уделу колена отцов своих; ");
INSERT INTO russyn_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","и всякая дочь, наследующая удел в коленах сынов Израилевых, должна быть женою кого-нибудь из племени колена отца своего, чтобы сыны Израилевы наследовали каждый удел отцов своих, ");
INSERT INTO russyn_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","и чтобы не переходил удел из колена в другое колено; ибо каждое из колен сынов Израилевых должно быть привязано к своему уделу. ");
INSERT INTO russyn_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Как повелел Господь Моисею, так и сделали дочери Салпаадовы. ");
INSERT INTO russyn_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","И вышли дочери Салпаадовы Махла, Фирца, Хогла, Милка и Ноа в замужество за сыновей дядей своих; ");
INSERT INTO russyn_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","в племени сынов Манассии, сына Иосифова, они были женами, и остался удел их в колене племени отца их. ");
INSERT INTO russyn_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Сии суть заповеди и постановления, которые дал Господь сынам Израилевым чрез Моисея на равнинах Моавитских, у Иордана, против Иерихона. ");
INSERT INTO russyn_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Сии суть слова, которые говорил Моисей всем Израильтянам за Иорданом в пустыне на равнине против Суфа, между Фараном и Тофелом, и Лаваном, и Асирофом, и Дизагавом, ");
INSERT INTO russyn_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","в расстоянии одиннадцати дней пути от Хорива, по дороге от горы Сеир к Кадес-Варни. ");
INSERT INTO russyn_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Сорокового года, одиннадцатого месяца, в первый день месяца говорил Моисей всем сынам Израилевым все, что заповедал ему Господь о них. ");
INSERT INTO russyn_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","По убиении им Сигона, царя Аморрейского, который жил в Есевоне, и Ога, царя Васанского, который жил в Аштерофе в Едреи, ");
INSERT INTO russyn_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","за Иорданом, в земле Моавитской, начал Моисей изъяснять закон сей и сказал: ");
INSERT INTO russyn_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","Господь, Бог наш, говорил нам в Хориве и сказал: “полно вам жить на горе сей! ");
INSERT INTO russyn_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","обратитесь, отправьтесь в путь и пойдите на гору Аморреев и ко всем соседям их, на равнину, на гору, на низкие места и на южный край и к берегам моря, в землю Ханаанскую и к Ливану, даже до реки великой, реки Евфрата; ");
INSERT INTO russyn_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","вот, Я даю вам землю сию, пойдите, возьмите в наследие землю, которую Господь с клятвою обещал дать отцам вашим, Аврааму, Исааку и Иакову, им и потомству их”. ");
INSERT INTO russyn_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","И я сказал вам в то время: не могу один водить вас; ");
INSERT INTO russyn_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Господь, Бог ваш, размножил вас, и вот, вы ныне многочисленны, как звезды небесные; ");
INSERT INTO russyn_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Господь, Бог отцов ваших, да умножит вас в тысячу крат против того, сколько вас теперь, и да благословит вас, как Он говорил вам: ");
INSERT INTO russyn_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","как же мне одному носить тягости ваши, бремена ваши и распри ваши? ");
INSERT INTO russyn_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","изберите себе по коленам вашим мужей мудрых, разумных и испытанных, и я поставлю их начальниками вашими. ");
INSERT INTO russyn_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Вы отвечали мне и сказали: хорошее дело велишь ты сделать. ");
INSERT INTO russyn_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","И взял я главных из колен ваших, мужей мудрых, разумных и испытанных, и сделал их начальниками над вами, тысяченачальниками, стоначальниками, пятидесятиначальниками, десятиначальниками и надзи-рателями по коленам вашим. ");
INSERT INTO russyn_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","И дал я повеление судьям вашим в то время, говоря: выслушивайте братьев ваших и судите справедливо, как брата с братом, так и пришельца его; ");
INSERT INTO russyn_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","не различайте лиц на суде, как малого, так и великого выслушивайте: не бойтесь лица человеческого, ибо суд - дело Божие; а дело, которое для вас трудно, доводите до меня, и я выслушаю его. ");
INSERT INTO russyn_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","И дал я вам в то время повеления обо всем, что надлежит вам делать. ");
INSERT INTO russyn_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","И отправились мы от Хорива, и шли по всей этой великой и страшной пустыне, которую вы видели, по пути к горе Аморрейской, как повелел Господь, Бог наш, и пришли в Кадес-Варни. ");
INSERT INTO russyn_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","И сказал я вам: вы пришли к горе Аморрейской, которую Господь, Бог наш, дает нам; ");
INSERT INTO russyn_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","вот, Господь, Бог твой, отдает тебе землю сию, иди, возьми ее во владение, как говорил тебе Господь, Бог отцов твоих, не бойся и не ужасайся. ");
INSERT INTO russyn_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Но вы все подошли ко мне и сказали: пошлем пред собою людей, чтоб они исследовали нам землю и принесли нам известие о дороге, по которой идти нам, и о городах, в которые идти нам. ");
INSERT INTO russyn_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","Слово это мне понравилось, и я взял из вас двенадцать человек, по одному человеку от каждого колена. ");
INSERT INTO russyn_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Они пошли, взошли на гору и дошли до долины Есхол, и обозрели ее; ");
INSERT INTO russyn_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","и взяли в руки свои плодов земли и доставили нам, и принесли нам известие и сказали: хороша земля, которую Господь, Бог наш, дает нам. ");
INSERT INTO russyn_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","Но вы не захотели идти и воспротивились повелению Господа, Бога вашего, ");
INSERT INTO russyn_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","и роптали в шатрах ваших и говорили: Господь, по ненависти к нам, вывел нас из земли Египетской, чтоб отдать нас в руки Аморреев и истребить нас; ");
INSERT INTO russyn_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","куда мы пойдем? братья наши расслабили сердце наше, говоря: народ тот более, многочисленнее и выше нас, города там большие и с укреплениями до небес, да и сынов Енаковых видели мы там. ");
INSERT INTO russyn_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","И я сказал вам: не страшитесь и не бойтесь их; ");
INSERT INTO russyn_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Господь, Бог ваш, идет перед вами; Он будет сражаться за вас, как Он сделал с вами в Египте, пред глазами вашими, ");
INSERT INTO russyn_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","и в пустыне сей, где, как ты видел, Господь, Бог твой, носил тебя, как человек носит сына своего, на всем пути, которым вы проходили до пришествия вашего на сие место. ");
INSERT INTO russyn_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Но и при этом вы не верили Господу, Богу вашему, ");
INSERT INTO russyn_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","Который шел перед вами путем - искать вам места, где остановиться вам, ночью в огне, чтобы указывать вам дорогу, по которой идти, а днем в облаке. ");
INSERT INTO russyn_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","И Господь Бог услышал слова ваши, и разгневался, и поклялся, говоря: ");
INSERT INTO russyn_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","никто из людей сих, из сего злого рода, не увидит доброй земли, которую Я клялся дать отцам вашим; ");
INSERT INTO russyn_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","только Халев, сын Иефонниин, увидит ее; ему дам Я землю, по которой он проходил, и сынам его, за то, что он повиновался Господу. ");
INSERT INTO russyn_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","И на меня прогневался Господь за вас, говоря: и ты не войдешь туда; ");
INSERT INTO russyn_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Иисус, сын Навин, который при тебе, он войдет туда; его утверди, ибо он введет Израиля во владение ею; ");
INSERT INTO russyn_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","дети ваши, о которых вы говорили, что они достанутся в добычу врагам, и сыновья ваши, которые не знают ныне ни добра ни зла, они войдут туда, им дам ее, и они овладеют ею; ");
INSERT INTO russyn_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","а вы обратитесь и отправьтесь в пустыню по дороге к Чермному морю. ");
INSERT INTO russyn_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","И вы отвечали тогда и сказали мне: согрешили мы пред Господом, Богом нашим, пойдем и сразимся, как повелел нам Господь, Бог наш. И препоясались вы, каждый ратным оружием своим, и безрассудно решились взойти на гору. ");
INSERT INTO russyn_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","Но Господь сказал мне: скажи им: не всходите и не сражайтесь, потому что нет Меня среди вас, чтобы не поразили вас враги ваши. ");
INSERT INTO russyn_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","И я говорил вам, но вы не послушали и воспротивились повелению Господню и по упорству своему взошли на гору. ");
INSERT INTO russyn_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","И выступил против вас Аморрей, живший на горе той, и преследовали вас так, как делают пчелы, и поражали вас на Сеире до самой Хормы. ");
INSERT INTO russyn_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","И возвратились вы и плакали пред Господом: но Господь не услышал вопля вашего и не внял вам. ");
INSERT INTO russyn_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","И пробыли вы в Кадесе много времени, сколько времени вы там были. ");
INSERT INTO russyn_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","И обратились мы и отправились в пустыню к Чермному морю, как говорил мне Господь, и много времени ходили вокруг горы Сеира. ");
INSERT INTO russyn_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","И сказал мне Господь, говоря: ");
INSERT INTO russyn_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","полно вам ходить вокруг этой горы, обратитесь к северу; ");
INSERT INTO russyn_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","и народу дай повеление и скажи: вы будете проходить пределы братьев ваших, сынов Исавовых, живущих на Сеире, и они убоятся вас; но остерегайтесь ");
INSERT INTO russyn_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","начинать с ними войну, ибо Я не дам вам земли их ни на стопу ноги, потому что гору Сеир Я дал во владение Исаву; ");
INSERT INTO russyn_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","пищу покупайте у них за серебро и ешьте; и воду покупайте у них за серебро и пейте; ");
INSERT INTO russyn_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","ибо Господь, Бог твой, благословил тебя во всяком деле рук твоих, покровительствовал тебе во время путешествия твоего по великой и страшной пустыне сей; вот, сорок лет Господь, Бог твой, с тобою; ты ни в чем не терпел недостатка. ");
INSERT INTO russyn_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","И шли мы мимо братьев наших, сынов Исавовых, живущих на Сеире, путем равнины, от Елафа и Ецион-Гавера, и поворотили, и шли к пустыне Моава. ");
INSERT INTO russyn_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","И сказал мне Господь: не вступай во вражду с Моавом и не начинай с ними войны; ибо Я не дам тебе ничего от земли его во владение, потому что Ар отдал Я во владение сынам Лотовым; ");
INSERT INTO russyn_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","прежде жили там Эмимы, народ великий, многочисленный и высокий, как сыны Енаковы, ");
INSERT INTO russyn_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","и они считались между Рефаимами, как сыны Енаковы; Моавитяне же называют их Эмимами; ");
INSERT INTO russyn_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","а на Сеире жили прежде Хорреи; но сыны Исавовы прогнали их и истребили их от лица своего и поселились вместо их - так, как поступил Израиль с землею наследия своего, которую дал им Господь; ");
INSERT INTO russyn_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","итак встаньте и пройдите долину Заред. И прошли мы долину Заред. ");
INSERT INTO russyn_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","С тех пор, как мы пошли в Кадес-Варни и как прошли долину Заред, минуло тридцать восемь лет, и у нас перевелся из среды стана весь род ходящих на войну, как клялся им Господь Бог; ");
INSERT INTO russyn_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","да и рука Господня была на них, чтоб истреблять их из среды стана, пока не вымерли. ");
INSERT INTO russyn_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","Когда же перевелись все ходящие на войну и вымерли из среды народа, ");
INSERT INTO russyn_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","тогда сказал мне Господь, говоря: ");
INSERT INTO russyn_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","ты проходишь ныне мимо пределов Моава, мимо Ара, ");
INSERT INTO russyn_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","и приблизился к Аммонитянам; не вступай с ними во вражду, и не начинай с ними войны, ибо Я не дам тебе ничего от земли сынов Аммоновых во владение, потому что Я отдал ее во владение сынам Лотовым; ");
INSERT INTO russyn_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","и она считалась землею Рефаимов; прежде жили на ней Рефаимы; Аммонитяне же называют их Замзумимами; ");
INSERT INTO russyn_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","народ великий, многочисленный и высокий, как сыны Енаковы, и истребил их Господь пред лицем их, и изгнали они их и поселились на месте их, ");
INSERT INTO russyn_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","как Он сделал для сынов Исавовых, живущих на Сеире, истребив пред лицем их Хорреев, и они изгнали их, и поселились на месте их, и живут до сего дня; ");
INSERT INTO russyn_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","и Аввеев, живших в селениях до самой Газы, Кафторимы, исшедшие из Кафтора, истребили и поселились на месте их. ");
INSERT INTO russyn_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","Встаньте, отправьтесь и перейдите поток Арнон; вот, Я предаю в руку твою Сигона, царя Есевонского, Аморреянина, и землю его; начинай овладевать ею, и веди с ним войну; ");
INSERT INTO russyn_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","с сего дня Я начну распространять страх и ужас пред тобою на народы под всем небом; те, которые услышат о тебе, вострепещут и ужаснутся тебя. ");
INSERT INTO russyn_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","И послал я послов из пустыни Кедемоф к Сигону, царю Есевонскому, с словами мирными, чтобы сказать: ");
INSERT INTO russyn_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","позволь пройти мне землею твоею; я пойду дорогою, не сойду ни направо, ни налево; ");
INSERT INTO russyn_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","пищу продавай мне за серебро, и я буду есть, и воду для питья давай мне за серебро, и я буду пить, только ногами моими пройду ");
INSERT INTO russyn_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","так, как сделали мне сыны Исава, живущие на Сеире, и Моавитяне, живущие в Аре, доколе не перейду чрез Иордан в землю, которую Господь, Бог наш, дает нам. ");
INSERT INTO russyn_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Но Сигон, царь Есевонский, не согласился позволить пройти нам через свою землю, потому что Господь, Бог твой, ожесточил дух его и сердце его сделал упорным, чтобы предать его в руку твою, как это видно ныне. ");
INSERT INTO russyn_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","И сказал мне Господь: вот, Я начинаю предавать тебе Сигона царя Есевонского, Аморреянина, и землю его; начинай овладевать землею его. ");
INSERT INTO russyn_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","И Сигон царь Есевонский со всем народом своим выступил против нас на сражение к Яаце; ");
INSERT INTO russyn_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","и предал его Господь, Бог наш, в руки наши, и мы поразили его и сынов его и весь народ его, ");
INSERT INTO russyn_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","и взяли в то время все города его, и предали заклятию все города, мужчин и женщин и детей, не оставили никого в живых; ");
INSERT INTO russyn_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","только взяли мы себе в добычу скот их и захваченное во взятых нами городах. ");
INSERT INTO russyn_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","От Ароера, который на берегу потока Арнона, и от города, который на долине, до горы Галаада не было города, который был бы неприступен для нас: все предал Господь, Бог наш, в руки наши. ");
INSERT INTO russyn_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Только к земле Аммонитян ты не подходил, ни к местам лежащим близ потока Иавока, ни к городам которые на горе, ни ко всему, к чему не повелел нам Господь, Бог наш. ");
INSERT INTO russyn_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","И обратились мы оттуда, и шли к Васану, и выступил против нас на войну Ог, царь Васанский, со всем народом своим, при Едреи. ");
INSERT INTO russyn_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","И сказал мне Господь: не бойся его, ибо Я отдам в руку твою его, и весь народ его, и всю землю его, и ты поступишь с ним так, как поступил с Сигоном, царем Аморрейским, который жил в Есевоне. ");
INSERT INTO russyn_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","И предал Господь, Бог наш, в руки наши и Ога, царя Васанского, и весь народ его; и мы поразили его, так что никого не осталось у него в живых; ");
INSERT INTO russyn_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","и взяли мы в то время все города его; не было города, которого мы не взяли бы у них: шестьдесят городов, всю область Аргов, царство Ога Васанского; ");
INSERT INTO russyn_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","все эти города укреплены были высокими стенами, воротами и запорами, кроме городов неукрепленных, весьма многих; ");
INSERT INTO russyn_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","и предали мы их заклятию, как поступили с Сигоном, царем Есевонским, предав заклятию всякий город с мужчинами, женщинами и детьми; ");
INSERT INTO russyn_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","но весь скот и захваченное в городах взяли себе в добычу; ");
INSERT INTO russyn_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","И взяли мы в то время из руки двух царей Аморрейских землю сию, которая по эту сторону Иордана, от потока Арнона до горы Ермона, ");
INSERT INTO russyn_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","Сидоняне Ермон называют Сирионом, а Аморреи называют его Сениром, ");
INSERT INTO russyn_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","все города на равнине, весь Галаад и весь Васан до Салхи и Едреи, города царства Ога Васанского; ");
INSERT INTO russyn_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","ибо только Ог, царь Васанский, оставался из Рефаимов. Вот, одр его, одр железный, и теперь в Равве, у сынов Аммоновых: длина его девять локтей, а ширина его четыре локтя, локтей мужеских. ");
INSERT INTO russyn_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","Землю сию взяли мы в то время начиная от Ароера, который у потока Арнона; и половину горы Галаада с городами ее отдал я колену Рувимову и Гадову; ");
INSERT INTO russyn_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","а остаток Галаада и весь Васан, царство Ога, отдал я половине колена Манассиина, всю область Аргов со всем Васаном. Она называется землею Рефаимов. ");
INSERT INTO russyn_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Иаир, сын Манассиин, взял всю область Аргов, до пределов Гесурских и Маахских, и назвал Васан, по имени своему, селениями Иаировыми, что и доныне; ");
INSERT INTO russyn_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","Махиру дал я Галаад; ");
INSERT INTO russyn_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","а колену Рувимову и Гадову дал от Галаада до потока Арнона, землю между потоком и пределом, до потока Иавока, предела сынов Аммоновых, ");
INSERT INTO russyn_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","также равнину и Иордан, который есть и предел, от Киннерефа до моря равнины, моря Соленого, при подошве горы Фасги к востоку. ");
INSERT INTO russyn_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","И дал я вам в то время повеление, говоря: Господь, Бог ваш, дал вам землю сию во владение; все способные к войне, вооружившись, идите впереди братьев ваших, сынов Израилевых; ");
INSERT INTO russyn_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","только жены ваши и дети ваши и скот ваш ибо я знаю, что скота у вас много, пусть останутся в городах ваших, которые я дал вам, ");
INSERT INTO russyn_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","доколе Господь Бог не даст покоя братьям вашим, как вам, и доколе и они не получат во владение землю, которую Господь, Бог ваш, дает им за Иорданом; тогда возвратитесь каждый в свое владение, которое я дал вам. ");
INSERT INTO russyn_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","И Иисусу заповедал я в то время, говоря: глаза твои видели все, что сделал Господь, Бог ваш, с двумя царями сими; то же сделает Господь со всеми царствами, которые ты будешь проходить; ");
INSERT INTO russyn_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","не бойтесь их, ибо Господь, Бог ваш, Сам сражается за вас. ");
INSERT INTO russyn_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","И молился я Господу в то время, говоря: ");
INSERT INTO russyn_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","Владыко Господи, Ты начал показывать рабу Твоему величие Твое и силу Твою, и крепкую руку Твою и высокую мышцу; ибо какой бог есть на небе, или на земле, который мог бы делать такие дела, как Твои, и с могуществом таким, как Твое? ");
INSERT INTO russyn_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","дай мне перейти и увидеть ту добрую землю, которая за Иорданом, и ту прекрасную гору и Ливан. ");
INSERT INTO russyn_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","Но Господь гневался на меня за вас и не послушал меня, и сказал мне Господь: полно тебе, впредь не говори Мне более об этом; ");
INSERT INTO russyn_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","взойди на вершину Фасги и взгляни глазами твоими к морю и к северу, и к югу и к востоку, и посмотри глазами твоими, потому что ты не перейдешь за Иордан сей; ");
INSERT INTO russyn_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","и дай наставление Иисусу, и укрепи его, и утверди его; ибо он будет предшествовать народу сему и он разделит им на уделы всю землю, на которую ты посмотришь. ");
INSERT INTO russyn_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","И остановились мы на долине, напротив Беф-Фегора. ");
INSERT INTO russyn_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","Итак, Израиль, слушай постановления и законы, которые я сегодня научаю вас исполнять, дабы вы были живы и размножились, и пошли и наследовали ту землю, которую Господь, Бог отцов ваших, дает вам в наследие; ");
INSERT INTO russyn_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","не прибавляйте к тому, что я заповедую вам, и не убавляйте от того; соблюдайте заповеди Господа, Бога вашего, которые я вам сегодня заповедую. ");
INSERT INTO russyn_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Глаза ваши видели все, что сделал Господь Бог наш с Ваал-Фегором: всякого человека, последовавшего Ваал-Фегору, истребил Господь, Бог твой, из среды тебя; ");
INSERT INTO russyn_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","а вы, прилепившиеся к Господу, Богу вашему, живы все доныне. ");
INSERT INTO russyn_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","Вот, я научил вас постановлениям и законам, как повелел мне Господь, Бог мой, дабы вы так поступали в той земле, в которую вы вступаете, чтоб овладеть ею; ");
INSERT INTO russyn_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","итак храните и исполняйте их, ибо в этом мудрость ваша и разум ваш пред глазами народов, которые, услышав о всех сих постановлениях, скажут: только этот великий народ есть народ мудрый и разумный. ");
INSERT INTO russyn_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Ибо есть ли какой великий народ, к которому боги его были бы столь близки, как близок к нам Господь, Бог наш, когда ни призовем Его? ");
INSERT INTO russyn_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","и есть ли какой великий народ, у которого были бы такие справедливые постановления и законы, как весь закон сей, который я предлагаю вам сегодня? ");
INSERT INTO russyn_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","Только берегись и тщательно храни душу твою, чтобы тебе не забыть тех дел, которые видели глаза твои, и чтобы они не выходили из сердца твоего во все дни жизни твоей; и поведай о них сынам твоим и сынам сынов твоих, ");
INSERT INTO russyn_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","о том дне, когда ты стоял пред Господом, Богом твоим, при Хориве, в день собрания, и когда сказал Господь мне: собери ко Мне народ, и Я возвещу им слова Мои, из которых они научатся бояться Меня во все дни жизни своей на земле и научат сыновей своих. ");
INSERT INTO russyn_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","Вы приблизились и стали под горою, а гора горела огнем до самых небес, и была тьма, облако и мрак. ");
INSERT INTO russyn_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","И говорил Господь к вам на горе из среды огня; глас слов Его вы слышали, но образа не видели, а только глас; ");
INSERT INTO russyn_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","и объявил Он вам завет Свой, который повелел вам исполнять, десятисловие, и написал его на двух каменных скрижалях; ");
INSERT INTO russyn_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","и повелел мне Господь в то время научить вас постановлениям и законам, дабы вы исполняли их в той земле, в которую вы входите, чтоб овладеть ею. ");
INSERT INTO russyn_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","Твердо держите в душах ваших, что вы не видели никакого образа в тот день, когда говорил к вам Господь на горе Хориве из среды огня, ");
INSERT INTO russyn_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","дабы вы не развратились и не сделали себе изваяний, изображений какого-либо кумира, представляющих мужчину или женщину, ");
INSERT INTO russyn_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","изображения какого-либо скота, который на земле, изображения какой-либо птицы крылатой, которая летает под небесами, ");
INSERT INTO russyn_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","изображения какого-либо гада, ползающего по земле, изображения какой-либо рыбы, которая в водах ниже земли; ");
INSERT INTO russyn_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","и дабы ты, взглянув на небо и увидев солнце, луну и звезды и все воинство небесное, не прельстился и не поклонился им и не служил им, так как Господь, Бог твой, уделил их всем народам под всем небом. ");
INSERT INTO russyn_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","А вас взял Господь Бог и вывел вас из печи железной, из Египта, дабы вы были народом Его удела, как это ныне видно. ");
INSERT INTO russyn_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","И Господь Бог прогневался на меня за вас, и клялся, что я не перейду за Иордан и не войду в ту добрую землю, которую Господь, Бог твой, дает тебе в удел; ");
INSERT INTO russyn_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","я умру в сей земле, не перейдя за Иордан, а вы перейдете и овладеете тою доброю землею. ");
INSERT INTO russyn_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Берегитесь, чтобы не забыть вам завета Господа, Бога вашего, который Он поставил с вами, и чтобы не делать себе кумиров, изображающих что-либо, как повелел тебе Господь, Бог твой; ");
INSERT INTO russyn_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","ибо Господь, Бог твой, есть огнь поядающий, Бог ревнитель. ");
INSERT INTO russyn_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","Если же родятся у тебя сыны и сыны у сынов твоих, и, долго жив на земле, вы развратитесь и сделаете изваяние, изображающее что-либо, и сделаете зло сие пред очами Господа, Бога вашего, и раздражите Его, ");
INSERT INTO russyn_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","то свидетельствуюсь вам сегодня небом и землею, что скоро потеряете землю, для наследования которой вы переходите за Иордан; не пробудете много времени на ней, но погибнете; ");
INSERT INTO russyn_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","и рассеет вас Господь по всем народам, и останетесь в малом числе между народами, к которым отведет вас Господь; ");
INSERT INTO russyn_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","и будете там служить другим богам, сделанным руками человеческими из дерева и камня, которые не видят и не слышат, и не едят и не обоняют. ");
INSERT INTO russyn_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Но когда ты взыщешь там Господа, Бога твоего, то найдешь Его, если будешь искать Его всем сердцем твоим и всею душею твоею. ");
INSERT INTO russyn_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","Когда ты будешь в скорби, и когда все это постигнет тебя в последствие времени, то обратишься к Господу, Богу твоему, и послушаешь гласа Его. ");
INSERT INTO russyn_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","Господь, Бог твой, есть Бог благий и милосердый; Он не оставит тебя и не погубит тебя, и не забудет завета с отцами твоими, который Он клятвою утвердил им. ");
INSERT INTO russyn_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","Ибо спроси у времен прежних, бывших прежде тебя, с того дня, в который сотворил Бог человека на земле, и от края неба до края неба: бывало ли что-нибудь такое, как сие великое дело, или слыхано ли подобное сему? ");
INSERT INTO russyn_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","слышал ли какой народ глас Бога живаго, говорящего из среды огня, и остался жив, как слышал ты? ");
INSERT INTO russyn_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","или покушался ли какой бог пойти, взять себе народ из среды другого народа казнями, знамениями и чудесами, и войною, и рукою крепкою, и мышцею высокою, и великими ужасами, как сделал для вас Господь, Бог ваш, в Египте пред глазами твоими? ");
INSERT INTO russyn_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","Тебе дано видеть это, чтобы ты знал, что только Господь Бог твой есть Бог, и нет еще кроме Его; ");
INSERT INTO russyn_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","с неба дал Он слышать тебе глас Свой, дабы научить тебя, и на земле показал тебе великий огнь Свой, и ты слышал слова Его из среды огня; ");
INSERT INTO russyn_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","и так как Он возлюбил отцов твоих и избрал вас, потомство их после них, то и вывел тебя Сам великою силою Своею из Египта, ");
INSERT INTO russyn_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","чтобы прогнать от лица твоего народы, которые больше и сильнее тебя, и ввести тебя и дать тебе землю их в удел, как это ныне видно. ");
INSERT INTO russyn_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Итак знай ныне и положи на сердце твое, что Господь Бог твой есть Бог на небе вверху и на земле внизу, и нет еще кроме Его; ");
INSERT INTO russyn_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","и храни постановления Его и заповеди Его, которые я заповедую тебе ныне, чтобы хорошо было тебе и сынам твоим после тебя, и чтобы ты много времени пробыл на той земле, которую Господь, Бог твой, дает тебе навсегда. ");
INSERT INTO russyn_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","Тогда отделил Моисей три города по эту сторону Иордана на восток солнца, ");
INSERT INTO russyn_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","чтоб убегал туда убийца, который убьет ближнего своего без намерения, не быв врагом ему ни вчера, ни третьего дня, и чтоб, убежав в один из этих городов, остался жив: ");
INSERT INTO russyn_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","Бецер в пустыне, на равнине в колене Рувимовом, и Рамоф в Галааде в колене Гадовом, и Голан в Васане в колене Манассиином. ");
INSERT INTO russyn_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","Вот закон, который предложил Моисей сынам Израилевым; ");
INSERT INTO russyn_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","вот повеления, постановления и уставы, которые изрек Моисей сынам Израилевым в пустыне, по исшествии их из Египта, ");
INSERT INTO russyn_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","за Иорданом, на долине против Беф-Фегора, в земле Сигона, царя Аморрейского, жившего в Есевоне, которого поразил Моисей с сынами Израилевыми, по исшествии их из Египта. ");
INSERT INTO russyn_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","И овладели они землею его и землею Ога, царя Васанского, двух царей Аморрейских, которая за Иорданом к востоку солнца, ");
INSERT INTO russyn_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","начиная от Ароера, который лежит на берегу потока Арнона, до горы Сиона, она же Ермон, ");
INSERT INTO russyn_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","и всею равниною по эту сторону Иордана к востоку, до самого моря равнины при подошве Фасги. ");
INSERT INTO russyn_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","И созвал Моисей весь Израиль и сказал им: слушай, Израиль, постановления и законы, которые я изреку сегодня в уши ваши, и выучите их и старайтесь исполнять их. ");
INSERT INTO russyn_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","Господь, Бог наш, поставил с нами завет на Хориве; ");
INSERT INTO russyn_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","не с отцами нашими поставил Господь завет сей, но с нами, которые здесь сегодня все живы. ");
INSERT INTO russyn_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","Лицем к лицу говорил Господь с вами на горе из среды огня; ");
INSERT INTO russyn_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","я же стоял между Господом и между вами в то время, дабы пересказывать вам слово Господа, ибо вы боялись огня и не восходили на гору. Он тогда сказал: ");
INSERT INTO russyn_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","Я Господь, Бог твой, Который вывел тебя из земли Египетской, из дома рабства; ");
INSERT INTO russyn_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","да не будет у тебя других богов перед лицем Моим. ");
INSERT INTO russyn_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","Не делай себе кумира и никакого изображения того, что на небе вверху и что на земле внизу, и что в водах ниже земли, ");
INSERT INTO russyn_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","не поклоняйся им и не служи им; ибо Я Господь, Бог твой, Бог ревнитель, за вину отцов наказывающий детей до третьего и четвертого рода, ненавидящих Меня, ");
INSERT INTO russyn_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","и творящий милость до тысячи родов любящим Меня и соблюдающим заповеди Мои. ");
INSERT INTO russyn_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","Не произноси имени Господа, Бога твоего, напрасно; ибо не оставит Господь Бог твой без наказания того, кто употребляет имя Его напрасно. ");
INSERT INTO russyn_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","Наблюдай день субботний, чтобы свято хранить его, как заповедал тебе Господь, Бог твой; ");
INSERT INTO russyn_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","шесть дней работай и делай всякие дела твои, ");
INSERT INTO russyn_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","а день седьмой - суббота Господу, Богу твоему. Не делай в оный никакого дела, ни ты, ни сын твой, ни дочь твоя, ни раб твой, ни раба твоя, ни вол твой, ни осел твой, ни всякий скот твой, ни пришелец твой, который у тебя, чтобы отдохнул раб твой, и раба твоя и осел твой, как и ты; ");
INSERT INTO russyn_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","и помни, что ты был рабом в земле Египетской, но Господь, Бог твой, вывел тебя оттуда рукою крепкою и мышцею высокою, потому и повелел тебе Господь, Бог твой, соблюдать день субботний и свято хранить его. ");
INSERT INTO russyn_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","Почитай отца твоего и матерь твою, как повелел тебе Господь, Бог твой, чтобы продлились дни твои, и чтобы хорошо тебе было на той земле, которую Господь, Бог твой, дает тебе. ");
INSERT INTO russyn_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","Не убивай. ");
INSERT INTO russyn_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","Не прелюбодействуй. ");
INSERT INTO russyn_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","Не кради. ");
INSERT INTO russyn_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","Не произноси ложного свидетельства на ближнего твоего. ");
INSERT INTO russyn_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","Не желай жены ближнего твоего и не желай дома ближнего твоего, ни поля его, ни раба его, ни рабы его, ни вола его, ни осла его, ни всякого скота его, ни всего, что есть у ближнего твоего. ");
INSERT INTO russyn_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","Слова сии изрек Господь ко всему собранию вашему на горе из среды огня, облака и мрака и бури громогласно, и более не говорил, и написал их на двух каменных скрижалях, и дал их мне. ");
INSERT INTO russyn_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","И когда вы услышали глас из среды мрака, и гора горела огнем, то вы подошли ко мне, все начальники колен ваших и старейшины ваши, ");
INSERT INTO russyn_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","и сказали: вот, показал нам Господь, Бог наш, славу Свою и величие Свое, и глас Его слышали мы из среды огня; сегодня видели мы, что Бог говорит с человеком, и сей остается жив; ");
INSERT INTO russyn_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","но теперь для чего нам умирать? ибо великий огонь сей пожрет нас; если мы еще услышим глас Господа, Бога нашего, то умрем, ");
INSERT INTO russyn_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","ибо есть ли какая плоть, которая слышала бы глас Бога живаго, говорящего из среды огня, как мы, и осталась жива? ");
INSERT INTO russyn_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","приступи ты и слушай все, что скажет тебе Господь, Бог наш, и ты пересказывай нам все, что будет говорить тебе Господь, Бог наш, и мы будем слушать и исполнять. ");
INSERT INTO russyn_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","И Господь услышал слова ваши, как вы разговаривали со мною, и сказал мне Господь: слышал Я слова народа сего, которые они говорили тебе; все, что ни говорили они, хорошо; ");
INSERT INTO russyn_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","о, если бы сердце их было у них таково, чтобы бояться Меня и соблюдать все заповеди Мои во все дни, дабы хорошо было им и сынам их вовек! ");
INSERT INTO russyn_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","пойди, скажи им: “возвратитесь в шатры свои”; ");
INSERT INTO russyn_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","а ты здесь останься со Мною, и Я изреку тебе все заповеди и постановления и законы, которым ты должен научить их, чтобы они так поступали на той земле, которую Я даю им во владение. ");
INSERT INTO russyn_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","Смотрите, поступайте так, как повелел вам Господь, Бог ваш; не уклоняйтесь ни направо, ни налево; ");
INSERT INTO russyn_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","ходите по тому пути, по которому повелел вам Господь, Бог ваш, дабы вы были живы, и хорошо было вам, и прожили много времени на той земле, которую получите во владение. ");
INSERT INTO russyn_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","Вот заповеди, постановления и законы, которым повелел Господь, Бог ваш, научить вас, чтобы вы поступали так в той земле, в которую вы идете, чтоб овладеть ею; ");
INSERT INTO russyn_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","дабы ты боялся Господа, Бога твоего, и все постановления Его и заповеди Его, которые сегодня заповедую тебе, соблюдал ты и сыны твои и сыны сынов твоих во все дни жизни твоей, дабы продлились дни твои. ");
INSERT INTO russyn_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Итак слушай, Израиль, и старайся исполнить это, чтобы тебе хорошо было, и чтобы вы весьма размножились, как Господь, Бог отцов твоих, говорил тебе, что Он даст тебе землю, где течет молоко и мед. Сии суть постановления и законы, которые заповедал Господь Бог сынам Израилевым в пустыне, по исшествии их из земли Египетской. ");
INSERT INTO russyn_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","Слушай, Израиль: Господь, Бог наш, Господь един есть; ");
INSERT INTO russyn_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","и люби Господа, Бога твоего, всем сердцем твоим, и всею душею твоею и всеми силами твоими. ");
INSERT INTO russyn_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","И да будут слова сии, которые Я заповедую тебе сегодня, в сердце твоем и в душе твоей; ");
INSERT INTO russyn_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","и внушай их детям твоим и говори о них, сидя в доме твоем и идя дорогою, и ложась и вставая; ");
INSERT INTO russyn_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","и навяжи их в знак на руку твою, и да будут они повязкою над глазами твоими, ");
INSERT INTO russyn_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","и напиши их на косяках дома твоего и на воротах твоих. ");
INSERT INTO russyn_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","Когда же введет тебя Господь, Бог твой, в ту землю, которую Он клялся отцам твоим, Аврааму, Исааку и Иакову, дать тебе с большими и хорошими городами, которых ты не строил, ");
INSERT INTO russyn_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","и с домами, наполненными всяким добром, которых ты не наполнял, и с колодезями, высеченными из камня, которых ты не высекал, с виноградниками и маслинами, которых ты не садил, и будешь есть и насыщаться, ");
INSERT INTO russyn_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","тогда берегись, чтобы не обольстилось сердце твое и не забыл ты Господа, Который вывел тебя из земли Египетской, из дома рабства. ");
INSERT INTO russyn_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","Господа, Бога твоего, бойся, и Ему одному служи, и к Нему прилепись, и Его именем клянись. ");
INSERT INTO russyn_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","Не последуйте иным богам, богам тех народов, которые будут вокруг вас; ");
INSERT INTO russyn_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","ибо Господь, Бог твой, Который среди тебя, есть Бог ревнитель; чтобы не воспламенился гнев Господа, Бога твоего, на тебя, и не истребил Он тебя с лица земли. ");
INSERT INTO russyn_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","Не искушайте Господа, Бога вашего, как вы искушали Его в Массе. ");
INSERT INTO russyn_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","Твердо храните заповеди Господа, Бога вашего, и уставы Его и постановления, которые Он заповедал тебе ");
INSERT INTO russyn_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","и делай справедливое и доброе пред очами Господа Бога твоего, дабы хорошо тебе было, и дабы ты вошел и овладел доброю землею, которую Господь с клятвою обещал отцам твоим, ");
INSERT INTO russyn_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","и чтобы Он прогнал всех врагов твоих от лица твоего, как говорил Господь. ");
INSERT INTO russyn_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","Если спросит у тебя сын твой в последующее время, говоря: “что значат сии уставы, постановления и законы, которые заповедал вам Господь, Бог ваш?” ");
INSERT INTO russyn_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","то скажи сыну твоему: “рабами были мы у фараона в Египте, но Господь Бог вывел нас из Египта рукою крепкою и мышцею высокою, ");
INSERT INTO russyn_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","и явил Господь Бог знамения и чудеса великие и казни над Египтом, над фараоном и над всем домом его и над войском его пред глазами нашими; ");
INSERT INTO russyn_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","а нас вывел оттуда Господь, Бог наш, чтобы ввести нас и дать нам землю, которую Господь, Бог наш, клялся отцам нашим дать нам; ");
INSERT INTO russyn_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","и заповедал нам Господь исполнять все постановления сии, чтобы мы боялись Господа, Бога нашего, дабы хорошо было нам во все дни, дабы сохранить нашу жизнь, как и теперь; ");
INSERT INTO russyn_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","и в сем будет наша праведность, если мы будем стараться исполнять все сии заповеди закона пред лицем Господа, Бога нашего, как Он заповедал нам”. ");
INSERT INTO russyn_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","Когда введет тебя Господь, Бог твой, в землю, в которую ты идешь, чтоб овладеть ею, и изгонит от лица твоего многочисленные народы, Хеттеев, Гергесеев, Аморреев, Хананеев, Ферезеев, Евеев и Иевусеев, семь народов, которые многочисленнее и сильнее тебя, ");
INSERT INTO russyn_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","и предаст их тебе Господь, Бог твой, и поразишь их, тогда предай их заклятию, не вступай с ними в союз и не щади их; ");
INSERT INTO russyn_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","и не вступай с ними в родство: дочери твоей не отдавай за сына его, и дочери его не бери за сына твоего; ");
INSERT INTO russyn_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","ибо они отвратят сынов твоих от Меня, чтобы служить иным богам, и тогда воспламенится на вас гнев Господа, и Он скоро истребит тебя. ");
INSERT INTO russyn_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","Но поступите с ними так: жертвенники их разрушьте, столбы их сокрушите, и рощи их вырубите, и истуканов богов их сожгите огнем; ");
INSERT INTO russyn_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","ибо ты народ святый у Господа, Бога твоего: тебя избрал Господь, Бог твой, чтобы ты был собственным Его народом из всех народов, которые на земле. ");
INSERT INTO russyn_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","Не потому, чтобы вы были многочисленнее всех народов, принял вас Господь и избрал вас,- ибо вы малочисленнее всех народов,- ");
INSERT INTO russyn_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","но потому, что любит вас Господь, и для того, чтобы сохранить клятву, которою Он клялся отцам вашим, вывел вас Господь рукою крепкою и мышцею высокою и освободил тебя из дома рабства, из руки фараона, царя Египетского. ");
INSERT INTO russyn_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","Итак знай, что Господь, Бог твой, есть Бог, Бог верный, Который хранит завет Свой и милость к любящим Его и сохраняющим заповеди Его до тысячи родов, ");
INSERT INTO russyn_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","и воздает ненавидящим Его в лице их, погубляя их; Он не замедлит, ненавидящему Его самому лично воздаст. ");
INSERT INTO russyn_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Итак, соблюдай заповеди и постановления и законы, которые сегодня заповедую тебе исполнять. ");
INSERT INTO russyn_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","И если вы будете слушать законы сии и хранить и исполнять их, то Господь, Бог твой, будет хранить завет и милость к тебе, как Он клялся отцам твоим, ");
INSERT INTO russyn_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","и возлюбит тебя, и благословит тебя, и размножит тебя, и благословит плод чрева твоего и плод земли твоей, и хлеб твой, и вино твое, и елей твой, рождаемое от крупного скота твоего и от стада овец твоих, на той земле, которую Он клялся отцам твоим дать тебе; ");
INSERT INTO russyn_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","благословен ты будешь больше всех народов; не будет ни бесплодного, ни бесплодной, ни у тебя, ни в скоте твоем; ");
INSERT INTO russyn_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","и отдалит от тебя Господь Бог твой всякую немощь, и никаких лютых болезней Египетских, которые ты видел и которые ты знаешь, не наведет на тебя, но наведет их на всех, ненавидящих тебя; ");
INSERT INTO russyn_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","и истребишь все народы, которые Господь, Бог твой, дает тебе: да не пощадит их глаз твой; и не служи богам их, ибо это сеть для тебя. ");
INSERT INTO russyn_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","Если скажешь в сердце твоем: “народы сии многочисленнее меня; как я могу изгнать их?” ");
INSERT INTO russyn_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","Не бойся их, вспомни то, что сделал Господь, Бог твой, с фараоном и всем Египтом, ");
INSERT INTO russyn_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","те великие испытания, которые видели глаза твои, великие знамения, чудеса, и руку крепкую и мышцу высокую, с какими вывел тебя Господь, Бог твой; то же сделает Господь, Бог твой, со всеми народами, которых ты боишься; ");
INSERT INTO russyn_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","и шершней нашлет Господь, Бог твой, на них, доколе не погибнут оставшиеся и скрывшиеся от лица твоего; ");
INSERT INTO russyn_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","не страшись их, ибо Господь, Бог твой, среди тебя, Бог великий и страшный. ");
INSERT INTO russyn_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","И будет Господь, Бог твой, изгонять пред тобою народы сии мало-помалу; не можешь ты истребить их скоро, чтобы земля не сделалась пуста и не умножились против тебя полевые звери; ");
INSERT INTO russyn_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","но предаст их тебе Господь, Бог твой, и приведет их в великое смятение, так что они погибнут; ");
INSERT INTO russyn_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","и предаст царей их в руки твои, и ты истребишь имя их из поднебесной: не устоит никто против тебя, доколе не искоренишь их. ");
INSERT INTO russyn_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","Кумиры богов их сожгите огнем; не пожелай взять себе серебра или золота, которое на них, дабы это не было для тебя сетью, ибо это мерзость для Господа, Бога твоего; ");
INSERT INTO russyn_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","и не вноси мерзости в дом твой, дабы не подпасть заклятию, как она; отвращайся сего и гнушайся сего, ибо это заклятое. ");
INSERT INTO russyn_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","Все заповеди, которые я заповедую вам сегодня, старайтесь исполнять, дабы вы были живы и размножились, и пошли и завладели доброю землею, которую с клятвою обещал Господь Бог отцам вашим. ");
INSERT INTO russyn_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","И помни весь путь, которым вел тебя Господь, Бог твой, по пустыне, вот уже сорок лет, чтобы смирить тебя, чтобы испытать тебя и узнать, что в сердце твоем, будешь ли хранить заповеди Его, или нет; ");
INSERT INTO russyn_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","Он смирял тебя, томил тебя голодом и питал тебя манною, которой не знал ты и не знали отцы твои, дабы показать тебе, что не одним хлебом живет человек, но всяким словом, исходящим из уст Господа, живет человек; ");
INSERT INTO russyn_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","одежда твоя не ветшала на тебе, и нога твоя не пухла, вот уже сорок лет. ");
INSERT INTO russyn_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","И знай в сердце твоем, что Господь, Бог твой, учит тебя, как человек учит сына своего. ");
INSERT INTO russyn_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","Итак храни заповеди Господа, Бога твоего, ходя путями Его и боясь Его. ");
INSERT INTO russyn_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","Ибо Господь, Бог твой, ведет тебя в землю добрую, в землю, где потоки вод, источники и озера выходят из долин и гор, ");
INSERT INTO russyn_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","в землю, где пшеница, ячмень, виноградные лозы, смоковницы и гранатовые деревья, в землю, где масличные деревья и мед, ");
INSERT INTO russyn_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","в землю, в которой без скудости будешь есть хлеб твой и ни в чем не будешь иметь недостатка, в землю, в которой камни - железо, и из гор которой будешь высекать медь. ");
INSERT INTO russyn_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","И когда будешь есть и насыщаться, тогда благословляй Господа, Бога твоего, за добрую землю, которую Он дал тебе. ");
INSERT INTO russyn_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","Берегись, чтобы ты не забыл Господа, Бога твоего, не соблюдая заповедей Его, и законов Его, и постановлений Его, которые сегодня заповедую тебе. ");
INSERT INTO russyn_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","Когда будешь есть и насыщаться, и построишь хорошие домы и будешь жить в них, ");
INSERT INTO russyn_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","и когда будет у тебя много крупного и мелкого скота, и будет много серебра и золота, и всего у тебя будет много,- ");
INSERT INTO russyn_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","то смотри, чтобы не надмилось сердце твое и не забыл ты Господа, Бога твоего, Который вывел тебя из земли Египетской, из дома рабства; ");
INSERT INTO russyn_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","Который провел тебя по пустыне великой и страшной, где змеи, василиски, скорпионы и места сухие, на которых нет воды; Который источил для тебя источник воды из скалы гранитной, ");
INSERT INTO russyn_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","питал тебя в пустыне манною, которой не знал ты и не знали отцы твои, дабы смирить тебя и испытать тебя, чтобы впоследствии сделать тебе добро, ");
INSERT INTO russyn_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","и чтобы ты не сказал в сердце твоем: “моя сила и крепость руки моей приобрели мне богатство сие”, ");
INSERT INTO russyn_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","но чтобы помнил Господа, Бога твоего, ибо Он дает тебе силу приобретать богатство, дабы исполнить, как ныне, завет Свой, который Он клятвою утвердил отцам твоим. ");
INSERT INTO russyn_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","Если же ты забудешь Господа, Бога твоего, и пойдешь вслед богов других, и будешь служить им и поклоняться им, то свидетельствуюсь вам сегодня небом и землею, что вы погибнете; ");
INSERT INTO russyn_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","как народы, которые Господь Бог истребляет от лица вашего, так погибнете и вы за то, что не послушаете гласа Господа, Бога вашего. ");
INSERT INTO russyn_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","Слушай, Израиль: ты теперь идешь за Иордан, чтобы пойти овладеть народами, которые больше и сильнее тебя, городами большими, с укреплениями до небес, ");
INSERT INTO russyn_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","народом великим, многочисленным и великорослым, сынами Енаковыми, о которых ты знаешь и слышал: “кто устоит против сынов Енаковых?” ");
INSERT INTO russyn_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","Знай же ныне, что Господь, Бог твой, идет пред тобою, как огнь поядающий; Он будет истреблять их и низлагать их пред тобою, и ты изгонишь их, и погубишь их скоро, как говорил тебе Господь. ");
INSERT INTO russyn_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","Когда будет изгонять их Господь, Бог твой, от лица твоего, не говори в сердце твоем, что за праведность мою привел меня Господь овладеть сею доброю землею, и что за нечестие народов сих Господь изгоняет их от лица твоего; ");
INSERT INTO russyn_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","не за праведность твою и не за правоту сердца твоего идешь ты наследовать землю их, но за нечестие и беззакония народов сих Господь, Бог твой, изгоняет их от лица твоего, и дабы исполнить слово, которым клялся Господь отцам твоим Аврааму, Исааку и Иакову; ");
INSERT INTO russyn_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","посему знай ныне, что не за праведность твою Господь, Бог твой, дает тебе овладеть сею доброю землею, ибо ты народ жестоковыйный. ");
INSERT INTO russyn_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","Помни, не забудь, сколько ты раздражал Господа, Бога твоего, в пустыне: с самого того дня, как вышел ты из земли Египетской, и до самого прихода вашего на место сие вы противились Господу. ");
INSERT INTO russyn_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","И при Хориве вы раздражали Господа, и прогневался на вас Господь, так что хотел истребить вас, ");
INSERT INTO russyn_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","когда я взошел на гору, чтобы принять скрижали каменные, скрижали завета, который поставил Господь с вами, и пробыл на горе сорок дней и сорок ночей, хлеба не ел и воды не пил, ");
INSERT INTO russyn_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","и дал мне Господь две скрижали каменные, написанные перстом Божиим, а на них написаны были все слова, которые изрек вам Господь на горе из среды огня в день собрания. ");
INSERT INTO russyn_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","По окончании же сорока дней и сорока ночей дал мне Господь две скрижали каменные, скрижали завета, ");
INSERT INTO russyn_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","и сказал мне Господь: встань, пойди скорее отсюда, ибо развратился народ твой, который ты вывел из Египта; скоро уклонились они от пути, который Я заповедал им; они сделали себе литый истукан. ");
INSERT INTO russyn_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","И сказал мне Господь: Я говорил тебе один и другой раз: вижу Я народ сей, вот он народ жестоковыйный; ");
INSERT INTO russyn_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","не удерживай Меня, и Я истреблю их, и изглажу имя их из поднебесной, а от тебя произведу народ, который будет больше, сильнее и многочисленнее их. ");
INSERT INTO russyn_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","Я обратился и пошел с горы, гора же горела огнем; две скрижали завета были в обеих руках моих; ");
INSERT INTO russyn_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","и видел я, что вы согрешили против Господа, Бога вашего, сделали себе литого тельца, скоро уклонились от пути, которого держаться заповедал вам Господь; ");
INSERT INTO russyn_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","и взял я обе скрижали, и бросил их из обеих рук своих, и разбил их пред глазами вашими. ");
INSERT INTO russyn_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","И вторично повергшись пред Господом, молился я, как прежде, сорок дней и сорок ночей, хлеба не ел и воды не пил, за все грехи ваши, которыми вы согрешили, сделав зло в очах Господа Бога вашего и раздражив Его; ");
INSERT INTO russyn_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","ибо я страшился гнева и ярости, которыми Господь прогневался на вас и хотел погубить вас. И послушал меня Господь и на сей раз. ");
INSERT INTO russyn_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","И на Аарона весьма прогневался Господь и хотел погубить его; но я молился и за Аарона в то время. ");
INSERT INTO russyn_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","Грех же ваш, который вы сделали,- тельца я взял, сожег его в огне, разбил его и всего истер до того, что он стал мелок, как прах, и я бросил прах сей в поток, текущий с горы. ");
INSERT INTO russyn_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","И в Тавере, в Массе и в Киброт-Гаттааве вы раздражили Господа Бога вашего. ");
INSERT INTO russyn_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","И когда посылал вас Господь из Кадес-Варни, говоря: пойдите, овладейте землею, которую Я даю вам,- то вы воспротивились повелению Господа Бога вашего, и не поверили Ему, и не послушали гласа Его. ");
INSERT INTO russyn_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","Вы были непокорны Господу с того самого дня, как я стал знать вас. ");
INSERT INTO russyn_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","И повергшись пред Господом, умолял я сорок дней и сорок ночей, в которые я молился, ибо Господь хотел погубить вас; ");
INSERT INTO russyn_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","и молился я Господу и сказал: Владыка Господи, Царь богов, не погубляй народа Твоего и удела Твоего, который Ты избавил величием крепости Твоей, который вывел Ты из Египта рукою сильною и мышцею Твоею высокою; ");
INSERT INTO russyn_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","вспомни рабов Твоих, Авраама, Исаака и Иакова, которым Ты клялся Собою; не смотри на ожесточение народа сего и на нечестие его и на грехи его, ");
INSERT INTO russyn_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","дабы живущие в той земле, откуда Ты вывел нас, не сказали: “Господь не мог ввести их в землю, которую обещал им, и, ненавидя их, вывел Он их, чтоб умертвить их в пустыне”. ");
INSERT INTO russyn_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","А они Твой народ и Твой удел, который Ты вывел из земли Египетской силою Твоею великою и мышцею Твоею высокою. ");
INSERT INTO russyn_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","В то время сказал мне Господь: вытеши себе две скрижали каменные, подобные первым, и взойди ко Мне на гору, и сделай себе деревянный ковчег; ");
INSERT INTO russyn_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","и Я напишу на скрижалях те слова, которые были на прежних скрижалях, которые ты разбил; и положи их в ковчег. ");
INSERT INTO russyn_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","И сделал я ковчег из дерева ситтим, и вытесал две каменные скрижали, как прежние, и пошел на гору; и две сии скрижали были в руках моих. ");
INSERT INTO russyn_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","И написал Он на скрижалях, как написано было прежде, те десять слов, которые изрек вам Господь на горе из среды огня в день собрания, и отдал их Господь мне. ");
INSERT INTO russyn_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","И обратился я, и сошел с горы, и положил скрижали в ковчег, который я сделал, чтоб они там были, как повелел мне Господь. ");
INSERT INTO russyn_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","И сыны Израилевы отправились из Беероф-Бене-Яакана в Мозер; там умер Аарон и погребен там, и стал священником вместо него сын его Елеазар. ");
INSERT INTO russyn_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","Оттуда отправились в Гудгод, из Гудгода в Иотвафу, в землю, где потоки вод. ");
INSERT INTO russyn_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","В то время отделил Господь колено Левиино, чтобы носить ковчег завета Господня, предстоять пред Господом, служить Ему и молиться и благословлять именем Его, как это продолжается до сего дня; ");
INSERT INTO russyn_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","потому нет левиту части и удела с братьями его: Сам Господь есть удел его, как говорил ему Господь, Бог твой. ");
INSERT INTO russyn_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","И пробыл я на горе, как и в прежнее время, сорок дней и сорок ночей; и послушал меня Господь и на сей раз, и не восхотел Господь погубить тебя; ");
INSERT INTO russyn_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","и сказал мне Господь: встань, пойди в путь пред народом сим; пусть они пойдут и овладеют землею, которую Я клялся отцам их дать им. ");
INSERT INTO russyn_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","Итак, Израиль, чего требует от тебя Господь, Бог твой? Того только, чтобы ты боялся Господа, Бога твоего, ходил всеми путями Его, и любил Его, и служил Господу, Богу твоему, от всего сердца твоего и от всей души твоей, ");
INSERT INTO russyn_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","чтобы соблюдал заповеди Господа Бога твоего и постановления Его, которые сегодня заповедую тебе, дабы тебе было хорошо. ");
INSERT INTO russyn_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","Вот у Господа, Бога твоего, небо и небеса небес, земля и все, что на ней; ");
INSERT INTO russyn_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","но только отцов твоих принял Господь и возлюбил их, и избрал вас, семя их после них, из всех народов, как ныне видишь. ");
INSERT INTO russyn_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","Итак обрежьте крайнюю плоть сердца вашего и не будьте впредь жестоковыйны; ");
INSERT INTO russyn_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","ибо Господь, Бог ваш, есть Бог богов и Владыка владык, Бог великий, сильный и страшный, Который не смотрит на лица и не берет даров, ");
INSERT INTO russyn_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","Который дает суд сироте и вдове, и любит пришельца, и дает ему хлеб и одежду. ");
INSERT INTO russyn_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","Любите и вы пришельца, ибо сами были пришельцами в земле Египетской. ");
INSERT INTO russyn_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","Господа, Бога твоего, бойся и Ему одному служи, и к Нему прилепись и Его именем клянись: ");
INSERT INTO russyn_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","Он хвала твоя и Он Бог твой, Который сделал с тобою те великие и страшные дела, какие видели глаза твои; ");
INSERT INTO russyn_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","в семидесяти пяти душах пришли отцы твои в Египет, а ныне Господь, Бог твой, сделал тебя многочисленным, как звезды небесные. ");
INSERT INTO russyn_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","Итак люби Господа, Бога твоего, и соблюдай, что повелено Им соблюдать, и постановления Его и законы Его и заповеди Его во все дни. ");
INSERT INTO russyn_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","И вспомните ныне,- ибо я говорю не с сынами вашими, которые не знают и не видели наказания Господа Бога вашего,- Его величие и Его крепкую руку и высокую мышцу его, ");
INSERT INTO russyn_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","знамения Его и дела Его, которые Он сделал среди Египта с фараоном, царем Египетским, и со всею землею его, ");
INSERT INTO russyn_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","и что Он сделал с войском Египетским, с конями его и колесницами его, которых Он потопил в водах Чермного моря, когда они гнались за вами, и погубил их Господь Бог даже до сего дня; ");
INSERT INTO russyn_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","и что Он делал для вас в пустыне, доколе вы не дошли до места сего, ");
INSERT INTO russyn_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","и что Он сделал с Дафаном и Авироном, сынами Елиава, сына Рувимова, когда земля разверзла уста свои и среди всего Израиля поглотила их и семейства их, и шатры их, и все имущество их, которое было у них; ");
INSERT INTO russyn_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","ибо глаза ваши видели все великие дела Господа, которые Он сделал. ");
INSERT INTO russyn_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","Итак соблюдайте все заповеди Его, которые я заповедую вам сегодня, дабы вы были живы, укрепились и пошли и овладели землею, в которую вы переходите за Иордан, чтоб овладеть ею; ");
INSERT INTO russyn_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","и дабы вы жили много времени на той земле, которую клялся Господь отцам вашим дать им и семени их, на земле, в которой течет молоко и мед. ");
INSERT INTO russyn_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","Ибо земля, в которую ты идешь, чтоб овладеть ею, не такова, как земля Египетская, из которой вышли вы, где ты, посеяв семя твое, поливал ее при помощи ног твоих, как масличный сад; ");
INSERT INTO russyn_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","но земля, в которую вы переходите, чтоб овладеть ею, есть земля с горами и долинами, и от дождя небесного напояется водою, ");
INSERT INTO russyn_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","земля, о которой Господь, Бог твой, печется: очи Господа, Бога твоего, непрестанно на ней, от начала года и до конца года. ");
INSERT INTO russyn_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","Если вы будете слушать заповеди Мои, которые заповедую вам сегодня, любить Господа, Бога вашего, и служить Ему от всего сердца вашего и от всей души вашей, ");
INSERT INTO russyn_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","то дам земле вашей дождь в свое время, ранний и поздний; и ты соберешь хлеб твой и вино твое и елей твой; ");
INSERT INTO russyn_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","и дам траву на поле твоем для скота твоего, и будешь есть и насыщаться. ");
INSERT INTO russyn_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","Берегитесь, чтобы не обольстилось сердце ваше, и вы не уклонились и не стали служить иным богам и не поклонились им; ");
INSERT INTO russyn_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","и тогда воспламенится гнев Господа на вас, и заключит Он небо, и не будет дождя, и земля не принесет произведений своих, и вы скоро погибнете с доброй земли, которую Господь дает вам. ");
INSERT INTO russyn_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","Итак положите сии слова Мои в сердце ваше и в душу вашу, и навяжите их в знак на руку свою, и да будут они повязкою над глазами вашими; ");
INSERT INTO russyn_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","и учите им сыновей своих, говоря о них, когда ты сидишь в доме твоем, и когда идешь дорогою, и когда ложишься, и когда встаешь; ");
INSERT INTO russyn_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","и напиши их на косяках дома твоего и на воротах твоих, ");
INSERT INTO russyn_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","дабы столько же много было дней ваших и дней детей ваших на той земле, которую Господь клялся дать отцам вашим, сколько дней небо будет над землею. ");
INSERT INTO russyn_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","Ибо если вы будете соблюдать все заповеди сии, которые заповедую вам исполнять, будете любить Господа, Бога вашего, ходить всеми путями Его и прилепляться к Нему, ");
INSERT INTO russyn_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","то изгонит Господь все народы сии от лица вашего, и вы овладеете народами, которые больше и сильнее вас; ");
INSERT INTO russyn_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","всякое место, на которое ступит нога ваша, будет ваше; от пустыни и Ливана, от реки, реки Евфрата, даже до моря западного будут пределы ваши; ");
INSERT INTO russyn_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","никто не устоит против вас: Господь, Бог ваш, наведет страх и трепет пред вами на всякую землю, на которую вы ступите, как Он говорил вам. ");
INSERT INTO russyn_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","Вот, я предлагаю вам сегодня благословение и проклятие: ");
INSERT INTO russyn_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","благословение, если послушаете заповедей Господа, Бога вашего, которые я заповедую вам сегодня, ");
INSERT INTO russyn_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","а проклятие, если не послушаете заповедей Господа, Бога вашего, и уклонитесь от пути, который заповедую вам сегодня, и пойдете вслед богов иных, которых вы не знаете. ");
INSERT INTO russyn_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","Когда введет тебя Господь, Бог твой, в ту землю, в которую ты идешь, чтоб овладеть ею, тогда произнеси благословение на горе Гаризим, а проклятие на горе Гевал: ");
INSERT INTO russyn_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","вот они за Иорданом, по дороге к захождению солнца, в земле Хананеев, живущих на равнине, против Галгала, близ дубравы Море. ");
INSERT INTO russyn_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","Ибо вы переходите Иордан, чтобы пойти овладеть землею, которую Господь, Бог ваш, дает вам в удел навсегда, и овладеете ею и будете жить на ней. ");
INSERT INTO russyn_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","Итак старайтесь соблюдать все постановления и законы Его, которые предлагаю я вам сегодня. ");
INSERT INTO russyn_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","Вот постановления и законы, которые вы должны стараться исполнять в земле, которую Господь, Бог отцов твоих, дает тебе во владение, во все дни, которые вы будете жить на той земле. ");
INSERT INTO russyn_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","Истребите все места, где народы, которыми вы овладеете, служили богам своим, на высоких горах и на холмах, и под всяким ветвистым деревом; ");
INSERT INTO russyn_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","и разрушьте жертвенники их, и сокрушите столбы их, и сожгите огнем рощи их, и разбейте истуканы богов их, и истребите имя их от места того. ");
INSERT INTO russyn_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","Не то должны вы делать для Господа, Бога вашего; ");
INSERT INTO russyn_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","но к месту, какое изберет Господь, Бог ваш, из всех колен ваших, чтобы пребывать имени Его там, обращайтесь и туда приходите, ");
INSERT INTO russyn_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","и туда приносите всесожжения ваши, и жертвы ваши, и десятины ваши, и возношение рук ваших, и обеты ваши, и добровольные приношения ваши, и мирные жертвы ваши, и первенцев крупного скота вашего и мелкого скота вашего; ");
INSERT INTO russyn_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","и ешьте там пред Господом, Богом вашим, и веселитесь вы и семейства ваши о всем, что делалось руками вашими, чем благословил тебя Господь, Бог твой. ");
INSERT INTO russyn_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","Там вы не должны делать всего, как мы теперь здесь делаем, каждый, что ему кажется правильным; ");
INSERT INTO russyn_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","ибо вы ныне еще не вступили в место покоя и в удел, который Господь, Бог твой, дает тебе. ");
INSERT INTO russyn_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","Но когда перейдете Иордан и поселитесь на земле, которую Господь, Бог ваш, дает вам в удел, и когда Он успокоит вас от всех врагов ваших, окружающих вас, и будете жить безопасно, ");
INSERT INTO russyn_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","тогда, какое место изберет Господь, Бог ваш, чтобы пребывать имени Его там, туда приносите все, что я заповедую вам сегодня: всесожжения ваши и жертвы ваши, десятины ваши и возношение рук ваших, и все, избранное по обетам вашим, что вы обещали Господу Богу вашему; ");
INSERT INTO russyn_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","и веселитесь пред Господом, Богом вашим, вы и сыны ваши, и дочери ваши, и рабы ваши, и рабыни ваши, и левит, который посреди жилищ ваших, ибо нет ему части и удела с вами. ");
INSERT INTO russyn_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","Берегись приносить всесожжения твои на всяком месте, которое ты увидишь; ");
INSERT INTO russyn_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","но на том только месте, которое изберет Господь Бог твой в одном из колен твоих, приноси всесожжения твои и делай все, что заповедую тебе сегодня. ");
INSERT INTO russyn_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","Впрочем, когда только пожелает душа твоя, можешь заколать и есть, по благословению Господа, Бога твоего, мясо, которое Он дал тебе, во всех жилищах твоих: нечистый и чистый могут есть сие, как серну и как оленя; ");
INSERT INTO russyn_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","только крови не ешьте: на землю выливайте ее, как воду. ");
INSERT INTO russyn_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","Нельзя тебе есть в жилищах твоих десятины хлеба твоего, и вина твоего, и елея твоего, и первенцев крупного скота твоего и мелкого скота твоего, и всех обетов твоих, которые ты обещал, и добровольных приношений твоих, и возношения рук твоих; ");
INSERT INTO russyn_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","но ешь сие только пред Господом, Богом твоим, на том месте, которое изберет Господь, Бог твой,- ты и сын твой, и дочь твоя, и раб твой, и раба твоя, и левит, и пришелец, который в жилищах твоих, и веселись пред Господом, Богом твоим, о всем, что делалось руками твоими. ");
INSERT INTO russyn_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","Смотри, не оставляй левита во все дни, которые будешь жить на земле твоей. ");
INSERT INTO russyn_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","Когда распространит Господь, Бог твой, пределы твои, как Он говорил тебе, и ты скажешь: “поем я мяса”, потому что душа твоя пожелает есть мяса,- тогда, по желанию души твоей, ешь мясо. ");
INSERT INTO russyn_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","Если далеко будет от тебя то место, которое изберет Господь, Бог твой, чтобы пребывать имени Его там, то заколай из крупного и мелкого скота твоего, который дал тебе Господь Бог твой, как я повелел тебе, и ешь в жилищах твоих, по желанию души твоей; ");
INSERT INTO russyn_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","но ешь их так, как едят серну и оленя; нечистый как и чистый у тебя могут есть сие; ");
INSERT INTO russyn_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","только строго наблюдай, чтобы не есть крови, потому что кровь есть душа: не ешь души вместе с мясом; ");
INSERT INTO russyn_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","не ешь ее: выливай ее на землю, как воду; ");
INSERT INTO russyn_vpl VALUES ("DT12_25","006_12_25","DEU","12","25","25","не ешь ее, дабы хорошо было тебе и детям твоим после тебя вовеки, если будешь делать доброе и справедливое пред очами Господа Бога твоего. ");
INSERT INTO russyn_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","26","Только святыни твои, какие будут у тебя, и обеты твои приноси, и приходи на то место, которое изберет Господь Бог твой, чтобы призываемо было там имя Его; ");
INSERT INTO russyn_vpl VALUES ("DT12_27","006_12_27","DEU","12","27","27","и совершай всесожжения твои, мясо и кровь, на жертвеннике Господа, Бога твоего; но кровь других жертв твоих должна быть проливаема у жертвенника Господа, Бога твоего, а мясо ешь. ");
INSERT INTO russyn_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","Слушай и исполняй все слова сии, которые заповедую тебе, дабы хорошо было тебе и детям твоим после тебя вовек, если будешь делать доброе и угодное пред очами Господа, Бога твоего. ");
INSERT INTO russyn_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","Когда Господь, Бог твой, истребит от лица твоего народы, к которым ты идешь, чтобы взять их во владение, и ты, взяв их, поселишься в земле их; ");
INSERT INTO russyn_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","тогда берегись, чтобы ты не попал в сеть, последуя им, по истреблении их от лица твоего, и не искал богов их, говоря: “как служили народы сии богам своим, так буду и я делать”; ");
INSERT INTO russyn_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","не делай так Господу, Богу твоему, ибо все, чего гнушается Господь, что ненавидит Он, они делают богам своим: они и сыновей своих и дочерей своих сожигают на огне богам своим. ");
INSERT INTO russyn_vp